
module ol_vamp_49_ppttjj_ttxgggg_1_/**/REALKIND
contains

! **********************************************************************
subroutine vamp_49(M)
! P(0:3,nlegs) = incoming external momenta
! Uses tree structures 'wf', factors 'c', and denominators 'den' from loop_ppttjj_ttxgggg_1.
! Sets colour stripped amplitudes A from the module loop_amplitudes_ppttjj_ttxgggg_1.
! **********************************************************************
  use KIND_TYPES, only: REALKIND, QREALKIND, intkind2
  use ol_parameters_decl_/**/DREALKIND, only: l_switch
  use ol_parameters_decl_/**/QREALKIND ! masses
  use ol_vert_interface_/**/REALKIND
  use ol_prop_interface_/**/REALKIND
  use ol_last_step_/**/REALKIND
  use ol_tables_storage_ppttjj_ttxgggg_1_/**/DREALKIND
  use ol_tensor_sum_storage_ppttjj_ttxgggg_1_/**/REALKIND
  use ol_loop_handling_/**/REALKIND
  use ofred_reduction_/**/REALKIND, only: Hotf_4pt_reduction, Hotf_4pt_reduction_last
  use ofred_reduction_/**/REALKIND, only: Hotf_5pt_reduction, Hotf_5pt_reduction_last
  use ol_loop_reduction_/**/REALKIND, only: TI_bubble_red, TI_triangle_red
use ol_loop_reduction_/**/REALKIND, only: compute_scalar_box

  use ol_loop_storage_ppttjj_ttxgggg_1_/**/REALKIND
#ifndef PRECISION_dp
  use ol_loop_storage_ppttjj_ttxgggg_1_/**/DREALKIND, only: &
    & ntryL, p_switch, Hel, merge_step, merge_mism, merge_tables, merge_hels
#endif
  use hol_initialisation_/**/REALKIND, only: G0_hol_initialisation
  use ol_h_vert_interface_/**/REALKIND
  use ol_h_prop_interface_/**/REALKIND
  use ol_h_last_step_/**/REALKIND
  use ol_merging_/**/REALKIND, only: ol_merge, ol_merge_tensors, ol_merge_last

  implicit none

  type(Hpolcont) :: Gcoeff(64)
  type(Hpolcont), intent(in) :: M(50,64)


#ifndef PRECISION_dp
  if (ntryL==1 .OR. p_switch == 1) Gcoeff(:)%hf = Hel
#else
  if (ntryL==1 .OR. p_switch == 2) Gcoeff(:)%hf = Hel
#endif

  ! =============================================
  call ol_merge_tensors(T0sum(1264),[G0tensor(2994)])
  call ol_merge_tensors(T0sum(1265),[G0tensor(1889)])
  call ol_merge_tensors(T0sum(1266),[G0tensor(2353)])
  call ol_merge_tensors(T0sum(1267),[G0tensor(2259)])
  call ol_merge_tensors(T0sum(1268),[G0tensor(2148)])
  call ol_merge_tensors(T0sum(1269),[G0tensor(2779)])
  call ol_merge_tensors(T0sum(1270),[G0tensor(2508)])
  call ol_merge_tensors(T0sum(1271),[G0tensor(1839)])
  call ol_merge_tensors(T0sum(1272),[G0tensor(869)])
  call ol_merge_tensors(T0sum(1273),[G0tensor(779)])
  call ol_merge_tensors(T0sum(1274),[G0tensor(3088)])
  call ol_merge_tensors(T0sum(1275),[G0tensor(2503)])
  call ol_merge_tensors(T0sum(1276),[G0tensor(2804)])
  call ol_merge_tensors(T0sum(1277),[G0tensor(2153)])
  call ol_merge_tensors(T0sum(1278),[G0tensor(3089)])
  call ol_merge_tensors(T0sum(1279),[G0tensor(1625)])
  call ol_merge_tensors(T0sum(1280),[G0tensor(2323)])
  call ol_merge_tensors(T0sum(1281),[G0tensor(2178)])
  call ol_merge_tensors(T0sum(1282),[G0tensor(1414)])
  call ol_merge_tensors(T0sum(1283),[G0tensor(899)])
  call ol_merge_tensors(T0sum(1284),[G0tensor(790)])
  call ol_merge_tensors(T0sum(1285),[G0tensor(2974)])
  call ol_merge_tensors(T0sum(1286),[G0tensor(2273)])
  call ol_merge_tensors(T0sum(1287),[G0tensor(3564)])
  call ol_merge_tensors(T0sum(1288),[G0tensor(2558)])


! Compute scalar Master integrals 

  call compute_scalar_box([ 37, 53, 61 ],masses2_29,RedSet_4(4),ScalarBoxes(1))
  call compute_scalar_box([ 33, 53, 61 ],masses2_29,RedSet_4(5),ScalarBoxes(2))
  call compute_scalar_box([ 33, 37, 61 ],masses2_29,RedSet_4(6),ScalarBoxes(3))
  call compute_scalar_box([ 33, 37, 53 ],masses2_29,RedSet_4(7),ScalarBoxes(4))
  call compute_scalar_box([ 4, 20, 28 ],masses2_30,RedSet_4(8),ScalarBoxes(5))
  call compute_scalar_box([ 32, 53, 61 ],masses2_21,RedSet_4(9),ScalarBoxes(6))
  call compute_scalar_box([ 32, 37, 61 ],masses2_21,RedSet_4(10),ScalarBoxes(7))
  call compute_scalar_box([ 32, 37, 53 ],masses2_21,RedSet_4(11),ScalarBoxes(8))
  call compute_scalar_box([ 5, 21, 29 ],masses2_29,RedSet_4(12),ScalarBoxes(9))
  call compute_scalar_box([ 32, 33, 61 ],masses2_21,RedSet_4(13),ScalarBoxes(10))
  call compute_scalar_box([ 32, 33, 53 ],masses2_21,RedSet_4(14),ScalarBoxes(11))
  call compute_scalar_box([ 1, 21, 29 ],masses2_29,RedSet_4(15),ScalarBoxes(12))
  call compute_scalar_box([ 32, 33, 37 ],masses2_21,RedSet_4(1),ScalarBoxes(13))
  call compute_scalar_box([ 1, 5, 29 ],masses2_29,RedSet_4(16),ScalarBoxes(14))
  call compute_scalar_box([ 1, 5, 21 ],masses2_29,RedSet_4(17),ScalarBoxes(15))
  call compute_scalar_box([ 37, 45, 61 ],masses2_29,RedSet_4(18),ScalarBoxes(16))
  call compute_scalar_box([ 33, 45, 61 ],masses2_29,RedSet_4(19),ScalarBoxes(17))
  call compute_scalar_box([ 33, 37, 45 ],masses2_29,RedSet_4(20),ScalarBoxes(18))
  call compute_scalar_box([ 4, 12, 28 ],masses2_30,RedSet_4(21),ScalarBoxes(19))
  call compute_scalar_box([ 32, 45, 61 ],masses2_21,RedSet_4(22),ScalarBoxes(20))
  call compute_scalar_box([ 32, 37, 45 ],masses2_21,RedSet_4(23),ScalarBoxes(21))
  call compute_scalar_box([ 5, 13, 29 ],masses2_29,RedSet_4(24),ScalarBoxes(22))
  call compute_scalar_box([ 32, 33, 45 ],masses2_21,RedSet_4(25),ScalarBoxes(23))
  call compute_scalar_box([ 1, 13, 29 ],masses2_29,RedSet_4(26),ScalarBoxes(24))
  call compute_scalar_box([ 1, 5, 13 ],masses2_29,RedSet_4(27),ScalarBoxes(25))
  call compute_scalar_box([ 41, 57, 61 ],masses2_29,RedSet_4(28),ScalarBoxes(26))
  call compute_scalar_box([ 33, 57, 61 ],masses2_29,RedSet_4(29),ScalarBoxes(27))
  call compute_scalar_box([ 33, 41, 61 ],masses2_29,RedSet_4(30),ScalarBoxes(28))
  call compute_scalar_box([ 33, 41, 57 ],masses2_29,RedSet_4(31),ScalarBoxes(29))
  call compute_scalar_box([ 8, 24, 28 ],masses2_30,RedSet_4(32),ScalarBoxes(30))
  call compute_scalar_box([ 32, 57, 61 ],masses2_21,RedSet_4(33),ScalarBoxes(31))
  call compute_scalar_box([ 32, 41, 61 ],masses2_21,RedSet_4(34),ScalarBoxes(32))
  call compute_scalar_box([ 32, 41, 57 ],masses2_21,RedSet_4(35),ScalarBoxes(33))
  call compute_scalar_box([ 9, 25, 29 ],masses2_29,RedSet_4(36),ScalarBoxes(34))
  call compute_scalar_box([ 32, 33, 57 ],masses2_21,RedSet_4(37),ScalarBoxes(35))
  call compute_scalar_box([ 1, 25, 29 ],masses2_29,RedSet_4(38),ScalarBoxes(36))
  call compute_scalar_box([ 32, 33, 41 ],masses2_21,RedSet_4(2),ScalarBoxes(37))
  call compute_scalar_box([ 1, 9, 29 ],masses2_29,RedSet_4(39),ScalarBoxes(38))
  call compute_scalar_box([ 1, 9, 25 ],masses2_29,RedSet_4(40),ScalarBoxes(39))
  call compute_scalar_box([ 41, 45, 61 ],masses2_29,RedSet_4(41),ScalarBoxes(40))
  call compute_scalar_box([ 33, 41, 45 ],masses2_29,RedSet_4(42),ScalarBoxes(41))
  call compute_scalar_box([ 8, 12, 28 ],masses2_30,RedSet_4(43),ScalarBoxes(42))
  call compute_scalar_box([ 32, 41, 45 ],masses2_21,RedSet_4(44),ScalarBoxes(43))
  call compute_scalar_box([ 9, 13, 29 ],masses2_29,RedSet_4(45),ScalarBoxes(44))
  call compute_scalar_box([ 1, 9, 13 ],masses2_29,RedSet_4(46),ScalarBoxes(45))
  call compute_scalar_box([ 49, 57, 61 ],masses2_29,RedSet_4(47),ScalarBoxes(46))
  call compute_scalar_box([ 33, 49, 61 ],masses2_29,RedSet_4(48),ScalarBoxes(47))
  call compute_scalar_box([ 33, 49, 57 ],masses2_29,RedSet_4(49),ScalarBoxes(48))
  call compute_scalar_box([ 16, 24, 28 ],masses2_30,RedSet_4(50),ScalarBoxes(49))
  call compute_scalar_box([ 32, 49, 61 ],masses2_21,RedSet_4(51),ScalarBoxes(50))
  call compute_scalar_box([ 32, 49, 57 ],masses2_21,RedSet_4(52),ScalarBoxes(51))
  call compute_scalar_box([ 17, 25, 29 ],masses2_29,RedSet_4(53),ScalarBoxes(52))
  call compute_scalar_box([ 32, 33, 49 ],masses2_21,RedSet_4(3),ScalarBoxes(53))
  call compute_scalar_box([ 1, 17, 29 ],masses2_29,RedSet_4(54),ScalarBoxes(54))
  call compute_scalar_box([ 1, 17, 25 ],masses2_29,RedSet_4(55),ScalarBoxes(55))
  call compute_scalar_box([ 49, 53, 61 ],masses2_29,RedSet_4(56),ScalarBoxes(56))
  call compute_scalar_box([ 33, 49, 53 ],masses2_29,RedSet_4(57),ScalarBoxes(57))
  call compute_scalar_box([ 16, 20, 28 ],masses2_30,RedSet_4(58),ScalarBoxes(58))
  call compute_scalar_box([ 32, 49, 53 ],masses2_21,RedSet_4(59),ScalarBoxes(59))
  call compute_scalar_box([ 17, 21, 29 ],masses2_29,RedSet_4(60),ScalarBoxes(60))
  call compute_scalar_box([ 1, 17, 21 ],masses2_29,RedSet_4(61),ScalarBoxes(61))
  call compute_scalar_box([ 44, 45, 47 ],masses2_20,RedSet_4(62),ScalarBoxes(62))
  call compute_scalar_box([ 40, 45, 47 ],masses2_20,RedSet_4(63),ScalarBoxes(63))
  call compute_scalar_box([ 40, 44, 47 ],masses2_16,RedSet_4(64),ScalarBoxes(64))
  call compute_scalar_box([ 40, 44, 45 ],masses2_18,RedSet_4(65),ScalarBoxes(65))
  call compute_scalar_box([ 4, 5, 7 ],masses2_20,RedSet_4(66),ScalarBoxes(66))
  call compute_scalar_box([ 32, 45, 47 ],masses2_20,RedSet_4(67),ScalarBoxes(67))
  call compute_scalar_box([ 32, 44, 47 ],masses2_16,RedSet_4(68),ScalarBoxes(68))
  call compute_scalar_box([ 32, 44, 45 ],masses2_18,RedSet_4(69),ScalarBoxes(69))
  call compute_scalar_box([ 12, 13, 15 ],masses2_20,RedSet_4(70),ScalarBoxes(70))
  call compute_scalar_box([ 32, 40, 47 ],masses2_16,RedSet_4(71),ScalarBoxes(71))
  call compute_scalar_box([ 32, 40, 45 ],masses2_18,RedSet_4(72),ScalarBoxes(72))
  call compute_scalar_box([ 8, 13, 15 ],masses2_20,RedSet_4(73),ScalarBoxes(73))
  call compute_scalar_box([ 32, 40, 44 ],masses2_16,RedSet_4(74),ScalarBoxes(74))
  call compute_scalar_box([ 8, 12, 15 ],masses2_16,RedSet_4(75),ScalarBoxes(75))
  call compute_scalar_box([ 8, 12, 13 ],masses2_18,RedSet_4(76),ScalarBoxes(76))
  call compute_scalar_box([ 36, 45, 47 ],masses2_20,RedSet_4(77),ScalarBoxes(77))
  call compute_scalar_box([ 36, 44, 47 ],masses2_16,RedSet_4(78),ScalarBoxes(78))
  call compute_scalar_box([ 36, 44, 45 ],masses2_18,RedSet_4(79),ScalarBoxes(79))
  call compute_scalar_box([ 8, 9, 11 ],masses2_20,RedSet_4(80),ScalarBoxes(80))
  call compute_scalar_box([ 32, 36, 47 ],masses2_16,RedSet_4(81),ScalarBoxes(81))
  call compute_scalar_box([ 32, 36, 45 ],masses2_18,RedSet_4(82),ScalarBoxes(82))
  call compute_scalar_box([ 4, 13, 15 ],masses2_20,RedSet_4(83),ScalarBoxes(83))
  call compute_scalar_box([ 32, 36, 44 ],masses2_16,RedSet_4(84),ScalarBoxes(84))
  call compute_scalar_box([ 4, 12, 15 ],masses2_16,RedSet_4(85),ScalarBoxes(85))
  call compute_scalar_box([ 4, 12, 13 ],masses2_18,RedSet_4(86),ScalarBoxes(86))
  call compute_scalar_box([ 52, 54, 55 ],masses2_20,RedSet_4(87),ScalarBoxes(87))
  call compute_scalar_box([ 36, 54, 55 ],masses2_20,RedSet_4(88),ScalarBoxes(88))
  call compute_scalar_box([ 36, 52, 55 ],masses2_16,RedSet_4(89),ScalarBoxes(89))
  call compute_scalar_box([ 36, 52, 54 ],masses2_18,RedSet_4(90),ScalarBoxes(90))
  call compute_scalar_box([ 16, 18, 19 ],masses2_20,RedSet_4(91),ScalarBoxes(91))
  call compute_scalar_box([ 32, 54, 55 ],masses2_20,RedSet_4(92),ScalarBoxes(92))
  call compute_scalar_box([ 32, 52, 55 ],masses2_16,RedSet_4(93),ScalarBoxes(93))
  call compute_scalar_box([ 32, 52, 54 ],masses2_18,RedSet_4(94),ScalarBoxes(94))
  call compute_scalar_box([ 20, 22, 23 ],masses2_20,RedSet_4(95),ScalarBoxes(95))
  call compute_scalar_box([ 32, 36, 55 ],masses2_16,RedSet_4(96),ScalarBoxes(96))
  call compute_scalar_box([ 32, 36, 54 ],masses2_18,RedSet_4(97),ScalarBoxes(97))
  call compute_scalar_box([ 4, 22, 23 ],masses2_20,RedSet_4(98),ScalarBoxes(98))
  call compute_scalar_box([ 32, 36, 52 ],masses2_16,RedSet_4(99),ScalarBoxes(99))
  call compute_scalar_box([ 4, 20, 23 ],masses2_16,RedSet_4(100),ScalarBoxes(100))
  call compute_scalar_box([ 4, 20, 22 ],masses2_18,RedSet_4(101),ScalarBoxes(101))
  call compute_scalar_box([ 44, 46, 47 ],masses2_20,RedSet_4(102),ScalarBoxes(102))
  call compute_scalar_box([ 40, 46, 47 ],masses2_20,RedSet_4(103),ScalarBoxes(103))
  call compute_scalar_box([ 40, 44, 46 ],masses2_18,RedSet_4(104),ScalarBoxes(104))
  call compute_scalar_box([ 4, 6, 7 ],masses2_20,RedSet_4(105),ScalarBoxes(105))
  call compute_scalar_box([ 32, 46, 47 ],masses2_20,RedSet_4(106),ScalarBoxes(106))
  call compute_scalar_box([ 32, 44, 46 ],masses2_18,RedSet_4(107),ScalarBoxes(107))
  call compute_scalar_box([ 12, 14, 15 ],masses2_20,RedSet_4(108),ScalarBoxes(108))
  call compute_scalar_box([ 32, 40, 46 ],masses2_18,RedSet_4(109),ScalarBoxes(109))
  call compute_scalar_box([ 8, 14, 15 ],masses2_20,RedSet_4(110),ScalarBoxes(110))
  call compute_scalar_box([ 8, 12, 14 ],masses2_18,RedSet_4(111),ScalarBoxes(111))
  call compute_scalar_box([ 36, 46, 47 ],masses2_20,RedSet_4(112),ScalarBoxes(112))
  call compute_scalar_box([ 36, 44, 46 ],masses2_18,RedSet_4(113),ScalarBoxes(113))
  call compute_scalar_box([ 8, 10, 11 ],masses2_20,RedSet_4(114),ScalarBoxes(114))
  call compute_scalar_box([ 32, 36, 46 ],masses2_18,RedSet_4(115),ScalarBoxes(115))
  call compute_scalar_box([ 4, 14, 15 ],masses2_20,RedSet_4(116),ScalarBoxes(116))
  call compute_scalar_box([ 4, 12, 14 ],masses2_18,RedSet_4(117),ScalarBoxes(117))
  call compute_scalar_box([ 52, 53, 55 ],masses2_20,RedSet_4(118),ScalarBoxes(118))
  call compute_scalar_box([ 36, 53, 55 ],masses2_20,RedSet_4(119),ScalarBoxes(119))
  call compute_scalar_box([ 36, 52, 53 ],masses2_18,RedSet_4(120),ScalarBoxes(120))
  call compute_scalar_box([ 16, 17, 19 ],masses2_20,RedSet_4(121),ScalarBoxes(121))
  call compute_scalar_box([ 32, 53, 55 ],masses2_20,RedSet_4(122),ScalarBoxes(122))
  call compute_scalar_box([ 32, 52, 53 ],masses2_18,RedSet_4(123),ScalarBoxes(123))
  call compute_scalar_box([ 20, 21, 23 ],masses2_20,RedSet_4(124),ScalarBoxes(124))
  call compute_scalar_box([ 32, 36, 53 ],masses2_18,RedSet_4(125),ScalarBoxes(125))
  call compute_scalar_box([ 4, 21, 23 ],masses2_20,RedSet_4(126),ScalarBoxes(126))
  call compute_scalar_box([ 4, 20, 21 ],masses2_18,RedSet_4(127),ScalarBoxes(127))
  call compute_scalar_box([ 41, 45, 47 ],masses2_27,RedSet_4(128),ScalarBoxes(128))
  call compute_scalar_box([ 40, 41, 47 ],masses2_20,RedSet_4(129),ScalarBoxes(129))
  call compute_scalar_box([ 40, 41, 45 ],masses2_21,RedSet_4(130),ScalarBoxes(130))
  call compute_scalar_box([ 1, 5, 7 ],masses2_27,RedSet_4(131),ScalarBoxes(131))
  call compute_scalar_box([ 32, 41, 47 ],masses2_20,RedSet_4(132),ScalarBoxes(132))
  call compute_scalar_box([ 9, 13, 15 ],masses2_27,RedSet_4(133),ScalarBoxes(133))
  call compute_scalar_box([ 32, 40, 41 ],masses2_18,RedSet_4(134),ScalarBoxes(134))
  call compute_scalar_box([ 8, 9, 15 ],masses2_20,RedSet_4(135),ScalarBoxes(135))
  call compute_scalar_box([ 8, 9, 13 ],masses2_21,RedSet_4(136),ScalarBoxes(136))
  call compute_scalar_box([ 37, 45, 47 ],masses2_27,RedSet_4(137),ScalarBoxes(137))
  call compute_scalar_box([ 36, 37, 47 ],masses2_20,RedSet_4(138),ScalarBoxes(138))
  call compute_scalar_box([ 36, 37, 45 ],masses2_21,RedSet_4(139),ScalarBoxes(139))
  call compute_scalar_box([ 1, 9, 11 ],masses2_27,RedSet_4(140),ScalarBoxes(140))
  call compute_scalar_box([ 32, 37, 47 ],masses2_20,RedSet_4(141),ScalarBoxes(141))
  call compute_scalar_box([ 5, 13, 15 ],masses2_27,RedSet_4(142),ScalarBoxes(142))
  call compute_scalar_box([ 32, 36, 37 ],masses2_18,RedSet_4(143),ScalarBoxes(143))
  call compute_scalar_box([ 4, 5, 15 ],masses2_20,RedSet_4(144),ScalarBoxes(144))
  call compute_scalar_box([ 4, 5, 13 ],masses2_21,RedSet_4(145),ScalarBoxes(145))
  call compute_scalar_box([ 50, 54, 55 ],masses2_27,RedSet_4(146),ScalarBoxes(146))
  call compute_scalar_box([ 34, 54, 55 ],masses2_27,RedSet_4(147),ScalarBoxes(147))
  call compute_scalar_box([ 34, 50, 55 ],masses2_27,RedSet_4(148),ScalarBoxes(148))
  call compute_scalar_box([ 34, 50, 54 ],masses2_29,RedSet_4(149),ScalarBoxes(149))
  call compute_scalar_box([ 16, 20, 21 ],masses2_28,RedSet_4(150),ScalarBoxes(150))
  call compute_scalar_box([ 32, 50, 55 ],masses2_20,RedSet_4(151),ScalarBoxes(151))
  call compute_scalar_box([ 32, 50, 54 ],masses2_21,RedSet_4(152),ScalarBoxes(152))
  call compute_scalar_box([ 18, 22, 23 ],masses2_27,RedSet_4(153),ScalarBoxes(153))
  call compute_scalar_box([ 32, 34, 55 ],masses2_20,RedSet_4(154),ScalarBoxes(154))
  call compute_scalar_box([ 32, 34, 54 ],masses2_21,RedSet_4(155),ScalarBoxes(155))
  call compute_scalar_box([ 2, 22, 23 ],masses2_27,RedSet_4(156),ScalarBoxes(156))
  call compute_scalar_box([ 32, 34, 50 ],masses2_21,RedSet_4(157),ScalarBoxes(157))
  call compute_scalar_box([ 2, 18, 23 ],masses2_27,RedSet_4(158),ScalarBoxes(158))
  call compute_scalar_box([ 2, 18, 22 ],masses2_29,RedSet_4(159),ScalarBoxes(159))
  call compute_scalar_box([ 50, 58, 59 ],masses2_27,RedSet_4(160),ScalarBoxes(160))
  call compute_scalar_box([ 34, 58, 59 ],masses2_27,RedSet_4(161),ScalarBoxes(161))
  call compute_scalar_box([ 34, 50, 59 ],masses2_27,RedSet_4(162),ScalarBoxes(162))
  call compute_scalar_box([ 34, 50, 58 ],masses2_29,RedSet_4(163),ScalarBoxes(163))
  call compute_scalar_box([ 16, 24, 25 ],masses2_28,RedSet_4(164),ScalarBoxes(164))
  call compute_scalar_box([ 32, 58, 59 ],masses2_20,RedSet_4(165),ScalarBoxes(165))
  call compute_scalar_box([ 32, 50, 59 ],masses2_20,RedSet_4(166),ScalarBoxes(166))
  call compute_scalar_box([ 32, 50, 58 ],masses2_21,RedSet_4(167),ScalarBoxes(167))
  call compute_scalar_box([ 18, 26, 27 ],masses2_27,RedSet_4(168),ScalarBoxes(168))
  call compute_scalar_box([ 32, 34, 59 ],masses2_20,RedSet_4(169),ScalarBoxes(169))
  call compute_scalar_box([ 32, 34, 58 ],masses2_21,RedSet_4(170),ScalarBoxes(170))
  call compute_scalar_box([ 2, 26, 27 ],masses2_27,RedSet_4(171),ScalarBoxes(171))
  call compute_scalar_box([ 2, 18, 27 ],masses2_27,RedSet_4(172),ScalarBoxes(172))
  call compute_scalar_box([ 2, 18, 26 ],masses2_29,RedSet_4(173),ScalarBoxes(173))
  call compute_scalar_box([ 42, 46, 47 ],masses2_27,RedSet_4(174),ScalarBoxes(174))
  call compute_scalar_box([ 40, 42, 47 ],masses2_20,RedSet_4(175),ScalarBoxes(175))
  call compute_scalar_box([ 40, 42, 46 ],masses2_21,RedSet_4(176),ScalarBoxes(176))
  call compute_scalar_box([ 2, 6, 7 ],masses2_27,RedSet_4(177),ScalarBoxes(177))
  call compute_scalar_box([ 32, 42, 47 ],masses2_20,RedSet_4(178),ScalarBoxes(178))
  call compute_scalar_box([ 32, 42, 46 ],masses2_21,RedSet_4(179),ScalarBoxes(179))
  call compute_scalar_box([ 10, 14, 15 ],masses2_27,RedSet_4(180),ScalarBoxes(180))
  call compute_scalar_box([ 32, 40, 42 ],masses2_18,RedSet_4(181),ScalarBoxes(181))
  call compute_scalar_box([ 8, 10, 15 ],masses2_20,RedSet_4(182),ScalarBoxes(182))
  call compute_scalar_box([ 8, 10, 14 ],masses2_21,RedSet_4(183),ScalarBoxes(183))
  call compute_scalar_box([ 37, 53, 55 ],masses2_27,RedSet_4(184),ScalarBoxes(184))
  call compute_scalar_box([ 36, 37, 55 ],masses2_20,RedSet_4(185),ScalarBoxes(185))
  call compute_scalar_box([ 36, 37, 53 ],masses2_21,RedSet_4(186),ScalarBoxes(186))
  call compute_scalar_box([ 1, 17, 19 ],masses2_27,RedSet_4(187),ScalarBoxes(187))
  call compute_scalar_box([ 32, 37, 55 ],masses2_20,RedSet_4(188),ScalarBoxes(188))
  call compute_scalar_box([ 5, 21, 23 ],masses2_27,RedSet_4(189),ScalarBoxes(189))
  call compute_scalar_box([ 4, 5, 23 ],masses2_20,RedSet_4(190),ScalarBoxes(190))
  call compute_scalar_box([ 4, 5, 21 ],masses2_21,RedSet_4(191),ScalarBoxes(191))
  call compute_scalar_box([ 34, 46, 47 ],masses2_27,RedSet_4(192),ScalarBoxes(192))
  call compute_scalar_box([ 34, 42, 47 ],masses2_27,RedSet_4(193),ScalarBoxes(193))
  call compute_scalar_box([ 34, 42, 46 ],masses2_29,RedSet_4(194),ScalarBoxes(194))
  call compute_scalar_box([ 8, 12, 13 ],masses2_28,RedSet_4(76),ScalarBoxes(195))
  call compute_scalar_box([ 32, 34, 47 ],masses2_20,RedSet_4(195),ScalarBoxes(196))
  call compute_scalar_box([ 32, 34, 46 ],masses2_21,RedSet_4(196),ScalarBoxes(197))
  call compute_scalar_box([ 2, 14, 15 ],masses2_27,RedSet_4(197),ScalarBoxes(198))
  call compute_scalar_box([ 32, 34, 42 ],masses2_21,RedSet_4(198),ScalarBoxes(199))
  call compute_scalar_box([ 2, 10, 15 ],masses2_27,RedSet_4(199),ScalarBoxes(200))
  call compute_scalar_box([ 2, 10, 14 ],masses2_29,RedSet_4(200),ScalarBoxes(201))
  call compute_scalar_box([ 42, 58, 59 ],masses2_27,RedSet_4(201),ScalarBoxes(202))
  call compute_scalar_box([ 34, 42, 59 ],masses2_27,RedSet_4(202),ScalarBoxes(203))
  call compute_scalar_box([ 34, 42, 58 ],masses2_29,RedSet_4(203),ScalarBoxes(204))
  call compute_scalar_box([ 8, 24, 25 ],masses2_28,RedSet_4(204),ScalarBoxes(205))
  call compute_scalar_box([ 32, 42, 59 ],masses2_20,RedSet_4(205),ScalarBoxes(206))
  call compute_scalar_box([ 32, 42, 58 ],masses2_21,RedSet_4(206),ScalarBoxes(207))
  call compute_scalar_box([ 10, 26, 27 ],masses2_27,RedSet_4(207),ScalarBoxes(208))
  call compute_scalar_box([ 2, 10, 27 ],masses2_27,RedSet_4(208),ScalarBoxes(209))
  call compute_scalar_box([ 2, 10, 26 ],masses2_29,RedSet_4(209),ScalarBoxes(210))
  call compute_scalar_box([ 33, 45, 47 ],masses2_27,RedSet_4(210),ScalarBoxes(211))
  call compute_scalar_box([ 33, 37, 47 ],masses2_27,RedSet_4(211),ScalarBoxes(212))
  call compute_scalar_box([ 4, 12, 14 ],masses2_28,RedSet_4(117),ScalarBoxes(213))
  call compute_scalar_box([ 32, 33, 47 ],masses2_20,RedSet_4(212),ScalarBoxes(214))
  call compute_scalar_box([ 1, 13, 15 ],masses2_27,RedSet_4(213),ScalarBoxes(215))
  call compute_scalar_box([ 1, 5, 15 ],masses2_27,RedSet_4(214),ScalarBoxes(216))
  call compute_scalar_box([ 33, 53, 55 ],masses2_27,RedSet_4(215),ScalarBoxes(217))
  call compute_scalar_box([ 33, 37, 55 ],masses2_27,RedSet_4(216),ScalarBoxes(218))
  call compute_scalar_box([ 4, 20, 22 ],masses2_28,RedSet_4(101),ScalarBoxes(219))
  call compute_scalar_box([ 32, 33, 55 ],masses2_20,RedSet_4(217),ScalarBoxes(220))
  call compute_scalar_box([ 1, 21, 23 ],masses2_27,RedSet_4(218),ScalarBoxes(221))
  call compute_scalar_box([ 1, 5, 23 ],masses2_27,RedSet_4(219),ScalarBoxes(222))
  call compute_scalar_box([ 38, 46, 47 ],masses2_27,RedSet_4(220),ScalarBoxes(223))
  call compute_scalar_box([ 36, 38, 47 ],masses2_20,RedSet_4(221),ScalarBoxes(224))
  call compute_scalar_box([ 36, 38, 46 ],masses2_21,RedSet_4(222),ScalarBoxes(225))
  call compute_scalar_box([ 2, 10, 11 ],masses2_27,RedSet_4(223),ScalarBoxes(226))
  call compute_scalar_box([ 32, 38, 47 ],masses2_20,RedSet_4(224),ScalarBoxes(227))
  call compute_scalar_box([ 32, 38, 46 ],masses2_21,RedSet_4(225),ScalarBoxes(228))
  call compute_scalar_box([ 6, 14, 15 ],masses2_27,RedSet_4(226),ScalarBoxes(229))
  call compute_scalar_box([ 32, 36, 38 ],masses2_18,RedSet_4(227),ScalarBoxes(230))
  call compute_scalar_box([ 4, 6, 15 ],masses2_20,RedSet_4(228),ScalarBoxes(231))
  call compute_scalar_box([ 4, 6, 14 ],masses2_21,RedSet_4(229),ScalarBoxes(232))
  call compute_scalar_box([ 38, 54, 55 ],masses2_27,RedSet_4(230),ScalarBoxes(233))
  call compute_scalar_box([ 36, 38, 55 ],masses2_20,RedSet_4(231),ScalarBoxes(234))
  call compute_scalar_box([ 36, 38, 54 ],masses2_21,RedSet_4(232),ScalarBoxes(235))
  call compute_scalar_box([ 2, 18, 19 ],masses2_27,RedSet_4(233),ScalarBoxes(236))
  call compute_scalar_box([ 32, 38, 55 ],masses2_20,RedSet_4(234),ScalarBoxes(237))
  call compute_scalar_box([ 32, 38, 54 ],masses2_21,RedSet_4(235),ScalarBoxes(238))
  call compute_scalar_box([ 6, 22, 23 ],masses2_27,RedSet_4(236),ScalarBoxes(239))
  call compute_scalar_box([ 4, 6, 23 ],masses2_20,RedSet_4(237),ScalarBoxes(240))
  call compute_scalar_box([ 4, 6, 22 ],masses2_21,RedSet_4(238),ScalarBoxes(241))
  call compute_scalar_box([ 34, 38, 47 ],masses2_27,RedSet_4(239),ScalarBoxes(242))
  call compute_scalar_box([ 34, 38, 46 ],masses2_29,RedSet_4(240),ScalarBoxes(243))
  call compute_scalar_box([ 4, 12, 13 ],masses2_28,RedSet_4(86),ScalarBoxes(244))
  call compute_scalar_box([ 32, 34, 38 ],masses2_21,RedSet_4(241),ScalarBoxes(245))
  call compute_scalar_box([ 2, 6, 15 ],masses2_27,RedSet_4(242),ScalarBoxes(246))
  call compute_scalar_box([ 2, 6, 14 ],masses2_29,RedSet_4(243),ScalarBoxes(247))
  call compute_scalar_box([ 34, 38, 55 ],masses2_27,RedSet_4(244),ScalarBoxes(248))
  call compute_scalar_box([ 34, 38, 54 ],masses2_29,RedSet_4(245),ScalarBoxes(249))
  call compute_scalar_box([ 4, 20, 21 ],masses2_28,RedSet_4(127),ScalarBoxes(250))
  call compute_scalar_box([ 2, 6, 23 ],masses2_27,RedSet_4(246),ScalarBoxes(251))
  call compute_scalar_box([ 2, 6, 22 ],masses2_29,RedSet_4(247),ScalarBoxes(252))
  call compute_scalar_box([ 33, 41, 47 ],masses2_27,RedSet_4(248),ScalarBoxes(253))
  call compute_scalar_box([ 8, 12, 14 ],masses2_28,RedSet_4(111),ScalarBoxes(254))
  call compute_scalar_box([ 1, 9, 15 ],masses2_27,RedSet_4(249),ScalarBoxes(255))
  call compute_scalar_box([ 41, 57, 59 ],masses2_27,RedSet_4(250),ScalarBoxes(256))
  call compute_scalar_box([ 33, 57, 59 ],masses2_27,RedSet_4(251),ScalarBoxes(257))
  call compute_scalar_box([ 33, 41, 59 ],masses2_27,RedSet_4(252),ScalarBoxes(258))
  call compute_scalar_box([ 8, 24, 26 ],masses2_28,RedSet_4(253),ScalarBoxes(259))
  call compute_scalar_box([ 32, 57, 59 ],masses2_20,RedSet_4(254),ScalarBoxes(260))
  call compute_scalar_box([ 32, 41, 59 ],masses2_20,RedSet_4(255),ScalarBoxes(261))
  call compute_scalar_box([ 9, 25, 27 ],masses2_27,RedSet_4(256),ScalarBoxes(262))
  call compute_scalar_box([ 32, 33, 59 ],masses2_20,RedSet_4(257),ScalarBoxes(263))
  call compute_scalar_box([ 1, 25, 27 ],masses2_27,RedSet_4(258),ScalarBoxes(264))
  call compute_scalar_box([ 1, 9, 27 ],masses2_27,RedSet_4(259),ScalarBoxes(265))
  call compute_scalar_box([ 49, 53, 55 ],masses2_27,RedSet_4(260),ScalarBoxes(266))
  call compute_scalar_box([ 33, 49, 55 ],masses2_27,RedSet_4(261),ScalarBoxes(267))
  call compute_scalar_box([ 16, 20, 22 ],masses2_28,RedSet_4(262),ScalarBoxes(268))
  call compute_scalar_box([ 32, 49, 55 ],masses2_20,RedSet_4(263),ScalarBoxes(269))
  call compute_scalar_box([ 17, 21, 23 ],masses2_27,RedSet_4(264),ScalarBoxes(270))
  call compute_scalar_box([ 1, 17, 23 ],masses2_27,RedSet_4(265),ScalarBoxes(271))
  call compute_scalar_box([ 49, 57, 59 ],masses2_27,RedSet_4(266),ScalarBoxes(272))
  call compute_scalar_box([ 33, 49, 59 ],masses2_27,RedSet_4(267),ScalarBoxes(273))
  call compute_scalar_box([ 16, 24, 26 ],masses2_28,RedSet_4(268),ScalarBoxes(274))
  call compute_scalar_box([ 32, 49, 59 ],masses2_20,RedSet_4(269),ScalarBoxes(275))
  call compute_scalar_box([ 17, 25, 27 ],masses2_27,RedSet_4(270),ScalarBoxes(276))
  call compute_scalar_box([ 1, 17, 27 ],masses2_27,RedSet_4(271),ScalarBoxes(277))
  call compute_scalar_box([ 42, 43, 47 ],masses2_24,RedSet_4(272),ScalarBoxes(278))
  call compute_scalar_box([ 40, 43, 47 ],masses2_16,RedSet_4(273),ScalarBoxes(279))
  call compute_scalar_box([ 40, 42, 43 ],masses2_20,RedSet_4(274),ScalarBoxes(280))
  call compute_scalar_box([ 2, 3, 7 ],masses2_24,RedSet_4(275),ScalarBoxes(281))
  call compute_scalar_box([ 32, 43, 47 ],masses2_16,RedSet_4(276),ScalarBoxes(282))
  call compute_scalar_box([ 32, 42, 43 ],masses2_20,RedSet_4(277),ScalarBoxes(283))
  call compute_scalar_box([ 10, 11, 15 ],masses2_24,RedSet_4(278),ScalarBoxes(284))
  call compute_scalar_box([ 32, 40, 43 ],masses2_16,RedSet_4(279),ScalarBoxes(285))
  call compute_scalar_box([ 8, 11, 15 ],masses2_16,RedSet_4(280),ScalarBoxes(286))
  call compute_scalar_box([ 37, 39, 47 ],masses2_24,RedSet_4(281),ScalarBoxes(287))
  call compute_scalar_box([ 36, 39, 47 ],masses2_16,RedSet_4(282),ScalarBoxes(288))
  call compute_scalar_box([ 36, 37, 39 ],masses2_20,RedSet_4(283),ScalarBoxes(289))
  call compute_scalar_box([ 1, 3, 11 ],masses2_24,RedSet_4(284),ScalarBoxes(290))
  call compute_scalar_box([ 32, 39, 47 ],masses2_16,RedSet_4(285),ScalarBoxes(291))
  call compute_scalar_box([ 32, 37, 39 ],masses2_20,RedSet_4(286),ScalarBoxes(292))
  call compute_scalar_box([ 5, 7, 15 ],masses2_24,RedSet_4(287),ScalarBoxes(293))
  call compute_scalar_box([ 32, 36, 39 ],masses2_16,RedSet_4(288),ScalarBoxes(294))
  call compute_scalar_box([ 4, 7, 15 ],masses2_16,RedSet_4(289),ScalarBoxes(295))
  call compute_scalar_box([ 44, 45, 47 ],masses2_26,RedSet_4(62),ScalarBoxes(296))
  call compute_scalar_box([ 40, 45, 47 ],masses2_26,RedSet_4(63),ScalarBoxes(297))
  call compute_scalar_box([ 40, 44, 47 ],masses2_30,RedSet_4(64),ScalarBoxes(298))
  call compute_scalar_box([ 40, 44, 45 ],masses2_28,RedSet_4(65),ScalarBoxes(299))
  call compute_scalar_box([ 4, 5, 7 ],masses2_26,RedSet_4(66),ScalarBoxes(300))
  call compute_scalar_box([ 32, 45, 47 ],masses2_26,RedSet_4(67),ScalarBoxes(301))
  call compute_scalar_box([ 32, 44, 47 ],masses2_30,RedSet_4(68),ScalarBoxes(302))
  call compute_scalar_box([ 32, 44, 45 ],masses2_28,RedSet_4(69),ScalarBoxes(303))
  call compute_scalar_box([ 12, 13, 15 ],masses2_26,RedSet_4(70),ScalarBoxes(304))
  call compute_scalar_box([ 32, 40, 47 ],masses2_30,RedSet_4(71),ScalarBoxes(305))
  call compute_scalar_box([ 32, 40, 45 ],masses2_28,RedSet_4(72),ScalarBoxes(306))
  call compute_scalar_box([ 8, 13, 15 ],masses2_26,RedSet_4(73),ScalarBoxes(307))
  call compute_scalar_box([ 32, 40, 44 ],masses2_30,RedSet_4(74),ScalarBoxes(308))
  call compute_scalar_box([ 8, 12, 15 ],masses2_30,RedSet_4(75),ScalarBoxes(309))
  call compute_scalar_box([ 37, 39, 55 ],masses2_24,RedSet_4(290),ScalarBoxes(310))
  call compute_scalar_box([ 36, 39, 55 ],masses2_16,RedSet_4(291),ScalarBoxes(311))
  call compute_scalar_box([ 1, 3, 19 ],masses2_24,RedSet_4(292),ScalarBoxes(312))
  call compute_scalar_box([ 32, 39, 55 ],masses2_16,RedSet_4(293),ScalarBoxes(313))
  call compute_scalar_box([ 5, 7, 23 ],masses2_24,RedSet_4(294),ScalarBoxes(314))
  call compute_scalar_box([ 4, 7, 23 ],masses2_16,RedSet_4(295),ScalarBoxes(315))
  call compute_scalar_box([ 41, 43, 47 ],masses2_24,RedSet_4(296),ScalarBoxes(316))
  call compute_scalar_box([ 40, 41, 43 ],masses2_20,RedSet_4(297),ScalarBoxes(317))
  call compute_scalar_box([ 1, 3, 7 ],masses2_24,RedSet_4(298),ScalarBoxes(318))
  call compute_scalar_box([ 32, 41, 43 ],masses2_20,RedSet_4(299),ScalarBoxes(319))
  call compute_scalar_box([ 9, 11, 15 ],masses2_24,RedSet_4(300),ScalarBoxes(320))
  call compute_scalar_box([ 38, 39, 47 ],masses2_24,RedSet_4(301),ScalarBoxes(321))
  call compute_scalar_box([ 36, 38, 39 ],masses2_20,RedSet_4(302),ScalarBoxes(322))
  call compute_scalar_box([ 2, 3, 11 ],masses2_24,RedSet_4(303),ScalarBoxes(323))
  call compute_scalar_box([ 32, 38, 39 ],masses2_20,RedSet_4(304),ScalarBoxes(324))
  call compute_scalar_box([ 6, 7, 15 ],masses2_24,RedSet_4(305),ScalarBoxes(325))
  call compute_scalar_box([ 36, 45, 47 ],masses2_26,RedSet_4(77),ScalarBoxes(326))
  call compute_scalar_box([ 36, 44, 47 ],masses2_30,RedSet_4(78),ScalarBoxes(327))
  call compute_scalar_box([ 36, 44, 45 ],masses2_28,RedSet_4(79),ScalarBoxes(328))
  call compute_scalar_box([ 8, 9, 11 ],masses2_26,RedSet_4(80),ScalarBoxes(329))
  call compute_scalar_box([ 32, 36, 47 ],masses2_30,RedSet_4(81),ScalarBoxes(330))
  call compute_scalar_box([ 32, 36, 45 ],masses2_28,RedSet_4(82),ScalarBoxes(331))
  call compute_scalar_box([ 4, 13, 15 ],masses2_26,RedSet_4(83),ScalarBoxes(332))
  call compute_scalar_box([ 32, 36, 44 ],masses2_30,RedSet_4(84),ScalarBoxes(333))
  call compute_scalar_box([ 4, 12, 15 ],masses2_30,RedSet_4(85),ScalarBoxes(334))
  call compute_scalar_box([ 52, 54, 55 ],masses2_26,RedSet_4(87),ScalarBoxes(335))
  call compute_scalar_box([ 36, 54, 55 ],masses2_26,RedSet_4(88),ScalarBoxes(336))
  call compute_scalar_box([ 36, 52, 55 ],masses2_30,RedSet_4(89),ScalarBoxes(337))
  call compute_scalar_box([ 36, 52, 54 ],masses2_28,RedSet_4(90),ScalarBoxes(338))
  call compute_scalar_box([ 16, 18, 19 ],masses2_26,RedSet_4(91),ScalarBoxes(339))
  call compute_scalar_box([ 32, 54, 55 ],masses2_26,RedSet_4(92),ScalarBoxes(340))
  call compute_scalar_box([ 32, 52, 55 ],masses2_30,RedSet_4(93),ScalarBoxes(341))
  call compute_scalar_box([ 32, 52, 54 ],masses2_28,RedSet_4(94),ScalarBoxes(342))
  call compute_scalar_box([ 20, 22, 23 ],masses2_26,RedSet_4(95),ScalarBoxes(343))
  call compute_scalar_box([ 32, 36, 55 ],masses2_30,RedSet_4(96),ScalarBoxes(344))
  call compute_scalar_box([ 32, 36, 54 ],masses2_28,RedSet_4(97),ScalarBoxes(345))
  call compute_scalar_box([ 4, 22, 23 ],masses2_26,RedSet_4(98),ScalarBoxes(346))
  call compute_scalar_box([ 32, 36, 52 ],masses2_30,RedSet_4(99),ScalarBoxes(347))
  call compute_scalar_box([ 4, 20, 23 ],masses2_30,RedSet_4(100),ScalarBoxes(348))
  call compute_scalar_box([ 44, 46, 47 ],masses2_26,RedSet_4(102),ScalarBoxes(349))
  call compute_scalar_box([ 40, 46, 47 ],masses2_26,RedSet_4(103),ScalarBoxes(350))
  call compute_scalar_box([ 40, 44, 46 ],masses2_28,RedSet_4(104),ScalarBoxes(351))
  call compute_scalar_box([ 4, 6, 7 ],masses2_26,RedSet_4(105),ScalarBoxes(352))
  call compute_scalar_box([ 32, 46, 47 ],masses2_26,RedSet_4(106),ScalarBoxes(353))
  call compute_scalar_box([ 32, 44, 46 ],masses2_28,RedSet_4(107),ScalarBoxes(354))
  call compute_scalar_box([ 12, 14, 15 ],masses2_26,RedSet_4(108),ScalarBoxes(355))
  call compute_scalar_box([ 32, 40, 46 ],masses2_28,RedSet_4(109),ScalarBoxes(356))
  call compute_scalar_box([ 8, 14, 15 ],masses2_26,RedSet_4(110),ScalarBoxes(357))
  call compute_scalar_box([ 38, 39, 55 ],masses2_24,RedSet_4(306),ScalarBoxes(358))
  call compute_scalar_box([ 2, 3, 19 ],masses2_24,RedSet_4(307),ScalarBoxes(359))
  call compute_scalar_box([ 6, 7, 23 ],masses2_24,RedSet_4(308),ScalarBoxes(360))
  call compute_scalar_box([ 36, 46, 47 ],masses2_26,RedSet_4(112),ScalarBoxes(361))
  call compute_scalar_box([ 36, 44, 46 ],masses2_28,RedSet_4(113),ScalarBoxes(362))
  call compute_scalar_box([ 8, 10, 11 ],masses2_26,RedSet_4(114),ScalarBoxes(363))
  call compute_scalar_box([ 32, 36, 46 ],masses2_28,RedSet_4(115),ScalarBoxes(364))
  call compute_scalar_box([ 4, 14, 15 ],masses2_26,RedSet_4(116),ScalarBoxes(365))
  call compute_scalar_box([ 52, 53, 55 ],masses2_26,RedSet_4(118),ScalarBoxes(366))
  call compute_scalar_box([ 36, 53, 55 ],masses2_26,RedSet_4(119),ScalarBoxes(367))
  call compute_scalar_box([ 36, 52, 53 ],masses2_28,RedSet_4(120),ScalarBoxes(368))
  call compute_scalar_box([ 16, 17, 19 ],masses2_26,RedSet_4(121),ScalarBoxes(369))
  call compute_scalar_box([ 32, 53, 55 ],masses2_26,RedSet_4(122),ScalarBoxes(370))
  call compute_scalar_box([ 32, 52, 53 ],masses2_28,RedSet_4(123),ScalarBoxes(371))
  call compute_scalar_box([ 20, 21, 23 ],masses2_26,RedSet_4(124),ScalarBoxes(372))
  call compute_scalar_box([ 32, 36, 53 ],masses2_28,RedSet_4(125),ScalarBoxes(373))
  call compute_scalar_box([ 4, 21, 23 ],masses2_26,RedSet_4(126),ScalarBoxes(374))
  call compute_scalar_box([ 34, 39, 47 ],masses2_24,RedSet_4(309),ScalarBoxes(375))
  call compute_scalar_box([ 34, 38, 39 ],masses2_27,RedSet_4(310),ScalarBoxes(376))
  call compute_scalar_box([ 4, 5, 13 ],masses2_25,RedSet_4(145),ScalarBoxes(377))
  call compute_scalar_box([ 32, 34, 39 ],masses2_20,RedSet_4(311),ScalarBoxes(378))
  call compute_scalar_box([ 2, 7, 15 ],masses2_24,RedSet_4(312),ScalarBoxes(379))
  call compute_scalar_box([ 34, 43, 47 ],masses2_24,RedSet_4(313),ScalarBoxes(380))
  call compute_scalar_box([ 34, 42, 43 ],masses2_27,RedSet_4(314),ScalarBoxes(381))
  call compute_scalar_box([ 8, 9, 13 ],masses2_25,RedSet_4(136),ScalarBoxes(382))
  call compute_scalar_box([ 32, 34, 43 ],masses2_20,RedSet_4(315),ScalarBoxes(383))
  call compute_scalar_box([ 2, 11, 15 ],masses2_24,RedSet_4(316),ScalarBoxes(384))
  call compute_scalar_box([ 34, 39, 55 ],masses2_24,RedSet_4(317),ScalarBoxes(385))
  call compute_scalar_box([ 4, 5, 21 ],masses2_25,RedSet_4(191),ScalarBoxes(386))
  call compute_scalar_box([ 2, 7, 23 ],masses2_24,RedSet_4(318),ScalarBoxes(387))
  call compute_scalar_box([ 50, 51, 55 ],masses2_24,RedSet_4(319),ScalarBoxes(388))
  call compute_scalar_box([ 34, 51, 55 ],masses2_24,RedSet_4(320),ScalarBoxes(389))
  call compute_scalar_box([ 34, 50, 51 ],masses2_27,RedSet_4(321),ScalarBoxes(390))
  call compute_scalar_box([ 16, 17, 21 ],masses2_25,RedSet_4(322),ScalarBoxes(391))
  call compute_scalar_box([ 32, 51, 55 ],masses2_16,RedSet_4(323),ScalarBoxes(392))
  call compute_scalar_box([ 32, 50, 51 ],masses2_20,RedSet_4(324),ScalarBoxes(393))
  call compute_scalar_box([ 18, 19, 23 ],masses2_24,RedSet_4(325),ScalarBoxes(394))
  call compute_scalar_box([ 32, 34, 51 ],masses2_20,RedSet_4(326),ScalarBoxes(395))
  call compute_scalar_box([ 2, 19, 23 ],masses2_24,RedSet_4(327),ScalarBoxes(396))
  call compute_scalar_box([ 33, 39, 47 ],masses2_24,RedSet_4(328),ScalarBoxes(397))
  call compute_scalar_box([ 33, 37, 39 ],masses2_27,RedSet_4(329),ScalarBoxes(398))
  call compute_scalar_box([ 4, 6, 14 ],masses2_25,RedSet_4(229),ScalarBoxes(399))
  call compute_scalar_box([ 32, 33, 39 ],masses2_20,RedSet_4(330),ScalarBoxes(400))
  call compute_scalar_box([ 1, 7, 15 ],masses2_24,RedSet_4(331),ScalarBoxes(401))
  call compute_scalar_box([ 33, 39, 55 ],masses2_24,RedSet_4(332),ScalarBoxes(402))
  call compute_scalar_box([ 4, 6, 22 ],masses2_25,RedSet_4(238),ScalarBoxes(403))
  call compute_scalar_box([ 1, 7, 23 ],masses2_24,RedSet_4(333),ScalarBoxes(404))
  call compute_scalar_box([ 42, 43, 59 ],masses2_24,RedSet_4(334),ScalarBoxes(405))
  call compute_scalar_box([ 34, 43, 59 ],masses2_24,RedSet_4(335),ScalarBoxes(406))
  call compute_scalar_box([ 8, 9, 25 ],masses2_25,RedSet_4(336),ScalarBoxes(407))
  call compute_scalar_box([ 32, 43, 59 ],masses2_16,RedSet_4(337),ScalarBoxes(408))
  call compute_scalar_box([ 10, 11, 27 ],masses2_24,RedSet_4(338),ScalarBoxes(409))
  call compute_scalar_box([ 2, 11, 27 ],masses2_24,RedSet_4(339),ScalarBoxes(410))
  call compute_scalar_box([ 50, 51, 59 ],masses2_24,RedSet_4(340),ScalarBoxes(411))
  call compute_scalar_box([ 34, 51, 59 ],masses2_24,RedSet_4(341),ScalarBoxes(412))
  call compute_scalar_box([ 16, 17, 25 ],masses2_25,RedSet_4(342),ScalarBoxes(413))
  call compute_scalar_box([ 32, 51, 59 ],masses2_16,RedSet_4(343),ScalarBoxes(414))
  call compute_scalar_box([ 18, 19, 27 ],masses2_24,RedSet_4(344),ScalarBoxes(415))
  call compute_scalar_box([ 2, 19, 27 ],masses2_24,RedSet_4(345),ScalarBoxes(416))
  call compute_scalar_box([ 33, 43, 47 ],masses2_24,RedSet_4(346),ScalarBoxes(417))
  call compute_scalar_box([ 33, 41, 43 ],masses2_27,RedSet_4(347),ScalarBoxes(418))
  call compute_scalar_box([ 8, 10, 14 ],masses2_25,RedSet_4(183),ScalarBoxes(419))
  call compute_scalar_box([ 32, 33, 43 ],masses2_20,RedSet_4(348),ScalarBoxes(420))
  call compute_scalar_box([ 1, 11, 15 ],masses2_24,RedSet_4(349),ScalarBoxes(421))
  call compute_scalar_box([ 41, 43, 59 ],masses2_24,RedSet_4(350),ScalarBoxes(422))
  call compute_scalar_box([ 33, 43, 59 ],masses2_24,RedSet_4(351),ScalarBoxes(423))
  call compute_scalar_box([ 8, 10, 26 ],masses2_25,RedSet_4(352),ScalarBoxes(424))
  call compute_scalar_box([ 9, 11, 27 ],masses2_24,RedSet_4(353),ScalarBoxes(425))
  call compute_scalar_box([ 1, 11, 27 ],masses2_24,RedSet_4(354),ScalarBoxes(426))
  call compute_scalar_box([ 49, 51, 55 ],masses2_24,RedSet_4(355),ScalarBoxes(427))
  call compute_scalar_box([ 33, 51, 55 ],masses2_24,RedSet_4(356),ScalarBoxes(428))
  call compute_scalar_box([ 33, 49, 51 ],masses2_27,RedSet_4(357),ScalarBoxes(429))
  call compute_scalar_box([ 16, 18, 22 ],masses2_25,RedSet_4(358),ScalarBoxes(430))
  call compute_scalar_box([ 32, 49, 51 ],masses2_20,RedSet_4(359),ScalarBoxes(431))
  call compute_scalar_box([ 17, 19, 23 ],masses2_24,RedSet_4(360),ScalarBoxes(432))
  call compute_scalar_box([ 32, 33, 51 ],masses2_20,RedSet_4(361),ScalarBoxes(433))
  call compute_scalar_box([ 1, 19, 23 ],masses2_24,RedSet_4(362),ScalarBoxes(434))
  call compute_scalar_box([ 49, 51, 59 ],masses2_24,RedSet_4(363),ScalarBoxes(435))
  call compute_scalar_box([ 33, 51, 59 ],masses2_24,RedSet_4(364),ScalarBoxes(436))
  call compute_scalar_box([ 16, 18, 26 ],masses2_25,RedSet_4(365),ScalarBoxes(437))
  call compute_scalar_box([ 17, 19, 27 ],masses2_24,RedSet_4(366),ScalarBoxes(438))
  call compute_scalar_box([ 1, 19, 27 ],masses2_24,RedSet_4(367),ScalarBoxes(439))
  call compute_scalar_box([ 42, 43, 47 ],masses2_22,RedSet_4(272),ScalarBoxes(440))
  call compute_scalar_box([ 40, 43, 47 ],masses2_30,RedSet_4(273),ScalarBoxes(441))
  call compute_scalar_box([ 40, 42, 47 ],masses2_26,RedSet_4(175),ScalarBoxes(442))
  call compute_scalar_box([ 40, 42, 43 ],masses2_26,RedSet_4(274),ScalarBoxes(443))
  call compute_scalar_box([ 2, 3, 7 ],masses2_22,RedSet_4(275),ScalarBoxes(444))
  call compute_scalar_box([ 32, 43, 47 ],masses2_30,RedSet_4(276),ScalarBoxes(445))
  call compute_scalar_box([ 32, 42, 47 ],masses2_26,RedSet_4(178),ScalarBoxes(446))
  call compute_scalar_box([ 32, 42, 43 ],masses2_26,RedSet_4(277),ScalarBoxes(447))
  call compute_scalar_box([ 10, 11, 15 ],masses2_22,RedSet_4(278),ScalarBoxes(448))
  call compute_scalar_box([ 32, 40, 43 ],masses2_30,RedSet_4(279),ScalarBoxes(449))
  call compute_scalar_box([ 8, 11, 15 ],masses2_30,RedSet_4(280),ScalarBoxes(450))
  call compute_scalar_box([ 32, 40, 42 ],masses2_28,RedSet_4(181),ScalarBoxes(451))
  call compute_scalar_box([ 8, 10, 15 ],masses2_26,RedSet_4(182),ScalarBoxes(452))
  call compute_scalar_box([ 37, 39, 47 ],masses2_22,RedSet_4(281),ScalarBoxes(453))
  call compute_scalar_box([ 36, 39, 47 ],masses2_30,RedSet_4(282),ScalarBoxes(454))
  call compute_scalar_box([ 36, 37, 47 ],masses2_26,RedSet_4(138),ScalarBoxes(455))
  call compute_scalar_box([ 36, 37, 39 ],masses2_26,RedSet_4(283),ScalarBoxes(456))
  call compute_scalar_box([ 1, 3, 11 ],masses2_22,RedSet_4(284),ScalarBoxes(457))
  call compute_scalar_box([ 32, 39, 47 ],masses2_30,RedSet_4(285),ScalarBoxes(458))
  call compute_scalar_box([ 32, 37, 47 ],masses2_26,RedSet_4(141),ScalarBoxes(459))
  call compute_scalar_box([ 32, 37, 39 ],masses2_26,RedSet_4(286),ScalarBoxes(460))
  call compute_scalar_box([ 5, 7, 15 ],masses2_22,RedSet_4(287),ScalarBoxes(461))
  call compute_scalar_box([ 32, 36, 39 ],masses2_30,RedSet_4(288),ScalarBoxes(462))
  call compute_scalar_box([ 4, 7, 15 ],masses2_30,RedSet_4(289),ScalarBoxes(463))
  call compute_scalar_box([ 32, 36, 37 ],masses2_28,RedSet_4(143),ScalarBoxes(464))
  call compute_scalar_box([ 4, 5, 15 ],masses2_26,RedSet_4(144),ScalarBoxes(465))
  call compute_scalar_box([ 37, 39, 55 ],masses2_22,RedSet_4(290),ScalarBoxes(466))
  call compute_scalar_box([ 36, 39, 55 ],masses2_30,RedSet_4(291),ScalarBoxes(467))
  call compute_scalar_box([ 36, 37, 55 ],masses2_26,RedSet_4(185),ScalarBoxes(468))
  call compute_scalar_box([ 1, 3, 19 ],masses2_22,RedSet_4(292),ScalarBoxes(469))
  call compute_scalar_box([ 32, 39, 55 ],masses2_30,RedSet_4(293),ScalarBoxes(470))
  call compute_scalar_box([ 32, 37, 55 ],masses2_26,RedSet_4(188),ScalarBoxes(471))
  call compute_scalar_box([ 5, 7, 23 ],masses2_22,RedSet_4(294),ScalarBoxes(472))
  call compute_scalar_box([ 4, 7, 23 ],masses2_30,RedSet_4(295),ScalarBoxes(473))
  call compute_scalar_box([ 4, 5, 23 ],masses2_26,RedSet_4(190),ScalarBoxes(474))
  call compute_scalar_box([ 35, 39, 47 ],masses2_30,RedSet_4(368),ScalarBoxes(475))
  call compute_scalar_box([ 34, 39, 47 ],masses2_22,RedSet_4(309),ScalarBoxes(476))
  call compute_scalar_box([ 34, 35, 47 ],masses2_22,RedSet_4(369),ScalarBoxes(477))
  call compute_scalar_box([ 34, 35, 39 ],masses2_22,RedSet_4(370),ScalarBoxes(478))
  call compute_scalar_box([ 32, 35, 47 ],masses2_30,RedSet_4(371),ScalarBoxes(479))
  call compute_scalar_box([ 32, 35, 39 ],masses2_30,RedSet_4(372),ScalarBoxes(480))
  call compute_scalar_box([ 3, 7, 15 ],masses2_30,RedSet_4(373),ScalarBoxes(481))
  call compute_scalar_box([ 32, 34, 47 ],masses2_26,RedSet_4(195),ScalarBoxes(482))
  call compute_scalar_box([ 32, 34, 39 ],masses2_26,RedSet_4(311),ScalarBoxes(483))
  call compute_scalar_box([ 2, 7, 15 ],masses2_22,RedSet_4(312),ScalarBoxes(484))
  call compute_scalar_box([ 32, 34, 35 ],masses2_26,RedSet_4(374),ScalarBoxes(485))
  call compute_scalar_box([ 2, 3, 15 ],masses2_22,RedSet_4(375),ScalarBoxes(486))
  call compute_scalar_box([ 35, 39, 47 ],masses2_16,RedSet_4(368),ScalarBoxes(487))
  call compute_scalar_box([ 34, 35, 47 ],masses2_24,RedSet_4(369),ScalarBoxes(488))
  call compute_scalar_box([ 34, 35, 39 ],masses2_24,RedSet_4(370),ScalarBoxes(489))
  call compute_scalar_box([ 1, 5, 13 ],masses2_17,RedSet_4(27),ScalarBoxes(490))
  call compute_scalar_box([ 32, 35, 47 ],masses2_16,RedSet_4(371),ScalarBoxes(491))
  call compute_scalar_box([ 32, 35, 39 ],masses2_16,RedSet_4(372),ScalarBoxes(492))
  call compute_scalar_box([ 3, 7, 15 ],masses2_16,RedSet_4(373),ScalarBoxes(493))
  call compute_scalar_box([ 32, 34, 35 ],masses2_20,RedSet_4(374),ScalarBoxes(494))
  call compute_scalar_box([ 2, 3, 15 ],masses2_24,RedSet_4(375),ScalarBoxes(495))
  call compute_scalar_box([ 35, 39, 55 ],masses2_30,RedSet_4(376),ScalarBoxes(496))
  call compute_scalar_box([ 34, 39, 55 ],masses2_22,RedSet_4(317),ScalarBoxes(497))
  call compute_scalar_box([ 34, 35, 55 ],masses2_22,RedSet_4(377),ScalarBoxes(498))
  call compute_scalar_box([ 32, 35, 55 ],masses2_30,RedSet_4(378),ScalarBoxes(499))
  call compute_scalar_box([ 3, 7, 23 ],masses2_30,RedSet_4(379),ScalarBoxes(500))
  call compute_scalar_box([ 32, 34, 55 ],masses2_26,RedSet_4(154),ScalarBoxes(501))
  call compute_scalar_box([ 2, 7, 23 ],masses2_22,RedSet_4(318),ScalarBoxes(502))
  call compute_scalar_box([ 2, 3, 23 ],masses2_22,RedSet_4(380),ScalarBoxes(503))
  call compute_scalar_box([ 35, 39, 55 ],masses2_16,RedSet_4(376),ScalarBoxes(504))
  call compute_scalar_box([ 34, 35, 55 ],masses2_24,RedSet_4(377),ScalarBoxes(505))
  call compute_scalar_box([ 1, 5, 21 ],masses2_17,RedSet_4(17),ScalarBoxes(506))
  call compute_scalar_box([ 32, 35, 55 ],masses2_16,RedSet_4(378),ScalarBoxes(507))
  call compute_scalar_box([ 3, 7, 23 ],masses2_16,RedSet_4(379),ScalarBoxes(508))
  call compute_scalar_box([ 2, 3, 23 ],masses2_24,RedSet_4(380),ScalarBoxes(509))
  call compute_scalar_box([ 41, 43, 47 ],masses2_22,RedSet_4(296),ScalarBoxes(510))
  call compute_scalar_box([ 40, 41, 47 ],masses2_26,RedSet_4(129),ScalarBoxes(511))
  call compute_scalar_box([ 40, 41, 43 ],masses2_26,RedSet_4(297),ScalarBoxes(512))
  call compute_scalar_box([ 1, 3, 7 ],masses2_22,RedSet_4(298),ScalarBoxes(513))
  call compute_scalar_box([ 32, 41, 47 ],masses2_26,RedSet_4(132),ScalarBoxes(514))
  call compute_scalar_box([ 32, 41, 43 ],masses2_26,RedSet_4(299),ScalarBoxes(515))
  call compute_scalar_box([ 9, 11, 15 ],masses2_22,RedSet_4(300),ScalarBoxes(516))
  call compute_scalar_box([ 32, 40, 41 ],masses2_28,RedSet_4(134),ScalarBoxes(517))
  call compute_scalar_box([ 8, 9, 15 ],masses2_26,RedSet_4(135),ScalarBoxes(518))
  call compute_scalar_box([ 38, 39, 47 ],masses2_22,RedSet_4(301),ScalarBoxes(519))
  call compute_scalar_box([ 36, 38, 47 ],masses2_26,RedSet_4(221),ScalarBoxes(520))
  call compute_scalar_box([ 36, 38, 39 ],masses2_26,RedSet_4(302),ScalarBoxes(521))
  call compute_scalar_box([ 2, 3, 11 ],masses2_22,RedSet_4(303),ScalarBoxes(522))
  call compute_scalar_box([ 32, 38, 47 ],masses2_26,RedSet_4(224),ScalarBoxes(523))
  call compute_scalar_box([ 32, 38, 39 ],masses2_26,RedSet_4(304),ScalarBoxes(524))
  call compute_scalar_box([ 6, 7, 15 ],masses2_22,RedSet_4(305),ScalarBoxes(525))
  call compute_scalar_box([ 32, 36, 38 ],masses2_28,RedSet_4(227),ScalarBoxes(526))
  call compute_scalar_box([ 4, 6, 15 ],masses2_26,RedSet_4(228),ScalarBoxes(527))
  call compute_scalar_box([ 35, 43, 47 ],masses2_30,RedSet_4(381),ScalarBoxes(528))
  call compute_scalar_box([ 34, 43, 47 ],masses2_22,RedSet_4(313),ScalarBoxes(529))
  call compute_scalar_box([ 34, 35, 43 ],masses2_22,RedSet_4(382),ScalarBoxes(530))
  call compute_scalar_box([ 32, 35, 43 ],masses2_30,RedSet_4(383),ScalarBoxes(531))
  call compute_scalar_box([ 3, 11, 15 ],masses2_30,RedSet_4(384),ScalarBoxes(532))
  call compute_scalar_box([ 32, 34, 43 ],masses2_26,RedSet_4(315),ScalarBoxes(533))
  call compute_scalar_box([ 2, 11, 15 ],masses2_22,RedSet_4(316),ScalarBoxes(534))
  call compute_scalar_box([ 35, 43, 47 ],masses2_16,RedSet_4(381),ScalarBoxes(535))
  call compute_scalar_box([ 34, 35, 43 ],masses2_24,RedSet_4(382),ScalarBoxes(536))
  call compute_scalar_box([ 1, 9, 13 ],masses2_17,RedSet_4(46),ScalarBoxes(537))
  call compute_scalar_box([ 32, 35, 43 ],masses2_16,RedSet_4(383),ScalarBoxes(538))
  call compute_scalar_box([ 3, 11, 15 ],masses2_16,RedSet_4(384),ScalarBoxes(539))
  call compute_scalar_box([ 35, 43, 59 ],masses2_30,RedSet_4(385),ScalarBoxes(540))
  call compute_scalar_box([ 34, 43, 59 ],masses2_22,RedSet_4(335),ScalarBoxes(541))
  call compute_scalar_box([ 34, 35, 59 ],masses2_22,RedSet_4(386),ScalarBoxes(542))
  call compute_scalar_box([ 32, 43, 59 ],masses2_30,RedSet_4(337),ScalarBoxes(543))
  call compute_scalar_box([ 32, 35, 59 ],masses2_30,RedSet_4(387),ScalarBoxes(544))
  call compute_scalar_box([ 3, 11, 27 ],masses2_30,RedSet_4(388),ScalarBoxes(545))
  call compute_scalar_box([ 32, 34, 59 ],masses2_26,RedSet_4(169),ScalarBoxes(546))
  call compute_scalar_box([ 2, 11, 27 ],masses2_22,RedSet_4(339),ScalarBoxes(547))
  call compute_scalar_box([ 2, 3, 27 ],masses2_22,RedSet_4(389),ScalarBoxes(548))
  call compute_scalar_box([ 35, 43, 59 ],masses2_16,RedSet_4(385),ScalarBoxes(549))
  call compute_scalar_box([ 34, 35, 59 ],masses2_24,RedSet_4(386),ScalarBoxes(550))
  call compute_scalar_box([ 1, 9, 25 ],masses2_17,RedSet_4(40),ScalarBoxes(551))
  call compute_scalar_box([ 32, 35, 59 ],masses2_16,RedSet_4(387),ScalarBoxes(552))
  call compute_scalar_box([ 3, 11, 27 ],masses2_16,RedSet_4(388),ScalarBoxes(553))
  call compute_scalar_box([ 2, 3, 27 ],masses2_24,RedSet_4(389),ScalarBoxes(554))
  call compute_scalar_box([ 38, 39, 55 ],masses2_22,RedSet_4(306),ScalarBoxes(555))
  call compute_scalar_box([ 36, 38, 55 ],masses2_26,RedSet_4(231),ScalarBoxes(556))
  call compute_scalar_box([ 2, 3, 19 ],masses2_22,RedSet_4(307),ScalarBoxes(557))
  call compute_scalar_box([ 32, 38, 55 ],masses2_26,RedSet_4(234),ScalarBoxes(558))
  call compute_scalar_box([ 6, 7, 23 ],masses2_22,RedSet_4(308),ScalarBoxes(559))
  call compute_scalar_box([ 4, 6, 23 ],masses2_26,RedSet_4(237),ScalarBoxes(560))
  call compute_scalar_box([ 35, 51, 55 ],masses2_30,RedSet_4(390),ScalarBoxes(561))
  call compute_scalar_box([ 34, 51, 55 ],masses2_22,RedSet_4(320),ScalarBoxes(562))
  call compute_scalar_box([ 34, 35, 51 ],masses2_22,RedSet_4(391),ScalarBoxes(563))
  call compute_scalar_box([ 32, 51, 55 ],masses2_30,RedSet_4(323),ScalarBoxes(564))
  call compute_scalar_box([ 32, 35, 51 ],masses2_30,RedSet_4(392),ScalarBoxes(565))
  call compute_scalar_box([ 3, 19, 23 ],masses2_30,RedSet_4(393),ScalarBoxes(566))
  call compute_scalar_box([ 32, 34, 51 ],masses2_26,RedSet_4(326),ScalarBoxes(567))
  call compute_scalar_box([ 2, 19, 23 ],masses2_22,RedSet_4(327),ScalarBoxes(568))
  call compute_scalar_box([ 35, 51, 55 ],masses2_16,RedSet_4(390),ScalarBoxes(569))
  call compute_scalar_box([ 34, 35, 51 ],masses2_24,RedSet_4(391),ScalarBoxes(570))
  call compute_scalar_box([ 1, 17, 21 ],masses2_17,RedSet_4(61),ScalarBoxes(571))
  call compute_scalar_box([ 32, 35, 51 ],masses2_16,RedSet_4(392),ScalarBoxes(572))
  call compute_scalar_box([ 3, 19, 23 ],masses2_16,RedSet_4(393),ScalarBoxes(573))
  call compute_scalar_box([ 35, 51, 59 ],masses2_30,RedSet_4(394),ScalarBoxes(574))
  call compute_scalar_box([ 34, 51, 59 ],masses2_22,RedSet_4(341),ScalarBoxes(575))
  call compute_scalar_box([ 32, 51, 59 ],masses2_30,RedSet_4(343),ScalarBoxes(576))
  call compute_scalar_box([ 3, 19, 27 ],masses2_30,RedSet_4(395),ScalarBoxes(577))
  call compute_scalar_box([ 2, 19, 27 ],masses2_22,RedSet_4(345),ScalarBoxes(578))
  call compute_scalar_box([ 35, 51, 59 ],masses2_16,RedSet_4(394),ScalarBoxes(579))
  call compute_scalar_box([ 1, 17, 25 ],masses2_17,RedSet_4(55),ScalarBoxes(580))
  call compute_scalar_box([ 3, 19, 27 ],masses2_16,RedSet_4(395),ScalarBoxes(581))
  call compute_scalar_box([ 33, 39, 47 ],masses2_22,RedSet_4(328),ScalarBoxes(582))
  call compute_scalar_box([ 33, 35, 47 ],masses2_22,RedSet_4(396),ScalarBoxes(583))
  call compute_scalar_box([ 33, 35, 39 ],masses2_22,RedSet_4(397),ScalarBoxes(584))
  call compute_scalar_box([ 32, 33, 47 ],masses2_26,RedSet_4(212),ScalarBoxes(585))
  call compute_scalar_box([ 32, 33, 39 ],masses2_26,RedSet_4(330),ScalarBoxes(586))
  call compute_scalar_box([ 1, 7, 15 ],masses2_22,RedSet_4(331),ScalarBoxes(587))
  call compute_scalar_box([ 32, 33, 35 ],masses2_26,RedSet_4(398),ScalarBoxes(588))
  call compute_scalar_box([ 1, 3, 15 ],masses2_22,RedSet_4(399),ScalarBoxes(589))
  call compute_scalar_box([ 33, 35, 47 ],masses2_24,RedSet_4(396),ScalarBoxes(590))
  call compute_scalar_box([ 33, 35, 39 ],masses2_24,RedSet_4(397),ScalarBoxes(591))
  call compute_scalar_box([ 2, 6, 14 ],masses2_17,RedSet_4(243),ScalarBoxes(592))
  call compute_scalar_box([ 32, 33, 35 ],masses2_20,RedSet_4(398),ScalarBoxes(593))
  call compute_scalar_box([ 1, 3, 15 ],masses2_24,RedSet_4(399),ScalarBoxes(594))
  call compute_scalar_box([ 33, 39, 55 ],masses2_22,RedSet_4(332),ScalarBoxes(595))
  call compute_scalar_box([ 33, 35, 55 ],masses2_22,RedSet_4(400),ScalarBoxes(596))
  call compute_scalar_box([ 32, 33, 55 ],masses2_26,RedSet_4(217),ScalarBoxes(597))
  call compute_scalar_box([ 1, 7, 23 ],masses2_22,RedSet_4(333),ScalarBoxes(598))
  call compute_scalar_box([ 1, 3, 23 ],masses2_22,RedSet_4(401),ScalarBoxes(599))
  call compute_scalar_box([ 33, 35, 55 ],masses2_24,RedSet_4(400),ScalarBoxes(600))
  call compute_scalar_box([ 2, 6, 22 ],masses2_17,RedSet_4(247),ScalarBoxes(601))
  call compute_scalar_box([ 1, 3, 23 ],masses2_24,RedSet_4(401),ScalarBoxes(602))
  call compute_scalar_box([ 33, 43, 47 ],masses2_22,RedSet_4(346),ScalarBoxes(603))
  call compute_scalar_box([ 33, 35, 43 ],masses2_22,RedSet_4(402),ScalarBoxes(604))
  call compute_scalar_box([ 32, 33, 43 ],masses2_26,RedSet_4(348),ScalarBoxes(605))
  call compute_scalar_box([ 1, 11, 15 ],masses2_22,RedSet_4(349),ScalarBoxes(606))
  call compute_scalar_box([ 33, 35, 43 ],masses2_24,RedSet_4(402),ScalarBoxes(607))
  call compute_scalar_box([ 2, 10, 14 ],masses2_17,RedSet_4(200),ScalarBoxes(608))
  call compute_scalar_box([ 33, 43, 59 ],masses2_22,RedSet_4(351),ScalarBoxes(609))
  call compute_scalar_box([ 33, 35, 59 ],masses2_22,RedSet_4(403),ScalarBoxes(610))
  call compute_scalar_box([ 32, 33, 59 ],masses2_26,RedSet_4(257),ScalarBoxes(611))
  call compute_scalar_box([ 1, 11, 27 ],masses2_22,RedSet_4(354),ScalarBoxes(612))
  call compute_scalar_box([ 1, 3, 27 ],masses2_22,RedSet_4(404),ScalarBoxes(613))
  call compute_scalar_box([ 33, 35, 59 ],masses2_24,RedSet_4(403),ScalarBoxes(614))
  call compute_scalar_box([ 2, 10, 26 ],masses2_17,RedSet_4(209),ScalarBoxes(615))
  call compute_scalar_box([ 1, 3, 27 ],masses2_24,RedSet_4(404),ScalarBoxes(616))
  call compute_scalar_box([ 33, 51, 55 ],masses2_22,RedSet_4(356),ScalarBoxes(617))
  call compute_scalar_box([ 33, 35, 51 ],masses2_22,RedSet_4(405),ScalarBoxes(618))
  call compute_scalar_box([ 32, 33, 51 ],masses2_26,RedSet_4(361),ScalarBoxes(619))
  call compute_scalar_box([ 1, 19, 23 ],masses2_22,RedSet_4(362),ScalarBoxes(620))
  call compute_scalar_box([ 33, 35, 51 ],masses2_24,RedSet_4(405),ScalarBoxes(621))
  call compute_scalar_box([ 2, 18, 22 ],masses2_17,RedSet_4(159),ScalarBoxes(622))
  call compute_scalar_box([ 33, 51, 59 ],masses2_22,RedSet_4(364),ScalarBoxes(623))
  call compute_scalar_box([ 1, 19, 27 ],masses2_22,RedSet_4(367),ScalarBoxes(624))
  call compute_scalar_box([ 2, 18, 26 ],masses2_17,RedSet_4(173),ScalarBoxes(625))
  call compute_scalar_box([ 41, 45, 47 ],masses2_19,RedSet_4(128),ScalarBoxes(626))
  call compute_scalar_box([ 40, 41, 45 ],masses2_25,RedSet_4(130),ScalarBoxes(627))
  call compute_scalar_box([ 1, 5, 7 ],masses2_19,RedSet_4(131),ScalarBoxes(628))
  call compute_scalar_box([ 32, 41, 45 ],masses2_25,RedSet_4(44),ScalarBoxes(629))
  call compute_scalar_box([ 9, 13, 15 ],masses2_19,RedSet_4(133),ScalarBoxes(630))
  call compute_scalar_box([ 34, 38, 47 ],masses2_19,RedSet_4(239),ScalarBoxes(631))
  call compute_scalar_box([ 34, 38, 39 ],masses2_19,RedSet_4(310),ScalarBoxes(632))
  call compute_scalar_box([ 32, 34, 38 ],masses2_25,RedSet_4(241),ScalarBoxes(633))
  call compute_scalar_box([ 2, 6, 15 ],masses2_19,RedSet_4(242),ScalarBoxes(634))
  call compute_scalar_box([ 2, 6, 7 ],masses2_19,RedSet_4(177),ScalarBoxes(635))
  call compute_scalar_box([ 37, 45, 47 ],masses2_19,RedSet_4(137),ScalarBoxes(636))
  call compute_scalar_box([ 36, 37, 45 ],masses2_25,RedSet_4(139),ScalarBoxes(637))
  call compute_scalar_box([ 1, 9, 11 ],masses2_19,RedSet_4(140),ScalarBoxes(638))
  call compute_scalar_box([ 32, 37, 45 ],masses2_25,RedSet_4(23),ScalarBoxes(639))
  call compute_scalar_box([ 5, 13, 15 ],masses2_19,RedSet_4(142),ScalarBoxes(640))
  call compute_scalar_box([ 34, 42, 47 ],masses2_19,RedSet_4(193),ScalarBoxes(641))
  call compute_scalar_box([ 34, 42, 43 ],masses2_19,RedSet_4(314),ScalarBoxes(642))
  call compute_scalar_box([ 32, 34, 42 ],masses2_25,RedSet_4(198),ScalarBoxes(643))
  call compute_scalar_box([ 2, 10, 15 ],masses2_19,RedSet_4(199),ScalarBoxes(644))
  call compute_scalar_box([ 2, 10, 11 ],masses2_19,RedSet_4(223),ScalarBoxes(645))
  call compute_scalar_box([ 50, 54, 55 ],masses2_19,RedSet_4(146),ScalarBoxes(646))
  call compute_scalar_box([ 34, 54, 55 ],masses2_19,RedSet_4(147),ScalarBoxes(647))
  call compute_scalar_box([ 34, 50, 55 ],masses2_19,RedSet_4(148),ScalarBoxes(648))
  call compute_scalar_box([ 34, 50, 54 ],masses2_17,RedSet_4(149),ScalarBoxes(649))
  call compute_scalar_box([ 16, 20, 21 ],masses2_18,RedSet_4(150),ScalarBoxes(650))
  call compute_scalar_box([ 32, 50, 55 ],masses2_26,RedSet_4(151),ScalarBoxes(651))
  call compute_scalar_box([ 32, 50, 54 ],masses2_25,RedSet_4(152),ScalarBoxes(652))
  call compute_scalar_box([ 18, 22, 23 ],masses2_19,RedSet_4(153),ScalarBoxes(653))
  call compute_scalar_box([ 32, 34, 54 ],masses2_25,RedSet_4(155),ScalarBoxes(654))
  call compute_scalar_box([ 2, 22, 23 ],masses2_19,RedSet_4(156),ScalarBoxes(655))
  call compute_scalar_box([ 32, 34, 50 ],masses2_25,RedSet_4(157),ScalarBoxes(656))
  call compute_scalar_box([ 2, 18, 23 ],masses2_19,RedSet_4(158),ScalarBoxes(657))
  call compute_scalar_box([ 50, 58, 59 ],masses2_19,RedSet_4(160),ScalarBoxes(658))
  call compute_scalar_box([ 34, 58, 59 ],masses2_19,RedSet_4(161),ScalarBoxes(659))
  call compute_scalar_box([ 34, 50, 59 ],masses2_19,RedSet_4(162),ScalarBoxes(660))
  call compute_scalar_box([ 34, 50, 58 ],masses2_17,RedSet_4(163),ScalarBoxes(661))
  call compute_scalar_box([ 16, 24, 25 ],masses2_18,RedSet_4(164),ScalarBoxes(662))
  call compute_scalar_box([ 32, 58, 59 ],masses2_26,RedSet_4(165),ScalarBoxes(663))
  call compute_scalar_box([ 32, 50, 59 ],masses2_26,RedSet_4(166),ScalarBoxes(664))
  call compute_scalar_box([ 32, 50, 58 ],masses2_25,RedSet_4(167),ScalarBoxes(665))
  call compute_scalar_box([ 18, 26, 27 ],masses2_19,RedSet_4(168),ScalarBoxes(666))
  call compute_scalar_box([ 32, 34, 58 ],masses2_25,RedSet_4(170),ScalarBoxes(667))
  call compute_scalar_box([ 2, 26, 27 ],masses2_19,RedSet_4(171),ScalarBoxes(668))
  call compute_scalar_box([ 2, 18, 27 ],masses2_19,RedSet_4(172),ScalarBoxes(669))
  call compute_scalar_box([ 42, 46, 47 ],masses2_19,RedSet_4(174),ScalarBoxes(670))
  call compute_scalar_box([ 40, 42, 46 ],masses2_25,RedSet_4(176),ScalarBoxes(671))
  call compute_scalar_box([ 32, 42, 46 ],masses2_25,RedSet_4(179),ScalarBoxes(672))
  call compute_scalar_box([ 10, 14, 15 ],masses2_19,RedSet_4(180),ScalarBoxes(673))
  call compute_scalar_box([ 34, 38, 55 ],masses2_19,RedSet_4(244),ScalarBoxes(674))
  call compute_scalar_box([ 2, 6, 23 ],masses2_19,RedSet_4(246),ScalarBoxes(675))
  call compute_scalar_box([ 37, 53, 55 ],masses2_19,RedSet_4(184),ScalarBoxes(676))
  call compute_scalar_box([ 36, 37, 53 ],masses2_25,RedSet_4(186),ScalarBoxes(677))
  call compute_scalar_box([ 1, 17, 19 ],masses2_19,RedSet_4(187),ScalarBoxes(678))
  call compute_scalar_box([ 32, 37, 53 ],masses2_25,RedSet_4(11),ScalarBoxes(679))
  call compute_scalar_box([ 5, 21, 23 ],masses2_19,RedSet_4(189),ScalarBoxes(680))
  call compute_scalar_box([ 34, 46, 47 ],masses2_19,RedSet_4(192),ScalarBoxes(681))
  call compute_scalar_box([ 34, 42, 46 ],masses2_17,RedSet_4(194),ScalarBoxes(682))
  call compute_scalar_box([ 32, 34, 46 ],masses2_25,RedSet_4(196),ScalarBoxes(683))
  call compute_scalar_box([ 2, 14, 15 ],masses2_19,RedSet_4(197),ScalarBoxes(684))
  call compute_scalar_box([ 42, 58, 59 ],masses2_19,RedSet_4(201),ScalarBoxes(685))
  call compute_scalar_box([ 34, 42, 59 ],masses2_19,RedSet_4(202),ScalarBoxes(686))
  call compute_scalar_box([ 34, 42, 58 ],masses2_17,RedSet_4(203),ScalarBoxes(687))
  call compute_scalar_box([ 8, 24, 25 ],masses2_18,RedSet_4(204),ScalarBoxes(688))
  call compute_scalar_box([ 32, 42, 59 ],masses2_26,RedSet_4(205),ScalarBoxes(689))
  call compute_scalar_box([ 32, 42, 58 ],masses2_25,RedSet_4(206),ScalarBoxes(690))
  call compute_scalar_box([ 10, 26, 27 ],masses2_19,RedSet_4(207),ScalarBoxes(691))
  call compute_scalar_box([ 2, 10, 27 ],masses2_19,RedSet_4(208),ScalarBoxes(692))
  call compute_scalar_box([ 50, 51, 55 ],masses2_22,RedSet_4(319),ScalarBoxes(693))
  call compute_scalar_box([ 34, 50, 51 ],masses2_19,RedSet_4(321),ScalarBoxes(694))
  call compute_scalar_box([ 16, 17, 21 ],masses2_21,RedSet_4(322),ScalarBoxes(695))
  call compute_scalar_box([ 32, 50, 51 ],masses2_26,RedSet_4(324),ScalarBoxes(696))
  call compute_scalar_box([ 18, 19, 23 ],masses2_22,RedSet_4(325),ScalarBoxes(697))
  call compute_scalar_box([ 2, 18, 19 ],masses2_19,RedSet_4(233),ScalarBoxes(698))
  call compute_scalar_box([ 33, 37, 47 ],masses2_19,RedSet_4(211),ScalarBoxes(699))
  call compute_scalar_box([ 33, 37, 39 ],masses2_19,RedSet_4(329),ScalarBoxes(700))
  call compute_scalar_box([ 32, 33, 37 ],masses2_25,RedSet_4(1),ScalarBoxes(701))
  call compute_scalar_box([ 1, 5, 15 ],masses2_19,RedSet_4(214),ScalarBoxes(702))
  call compute_scalar_box([ 33, 37, 55 ],masses2_19,RedSet_4(216),ScalarBoxes(703))
  call compute_scalar_box([ 1, 5, 23 ],masses2_19,RedSet_4(219),ScalarBoxes(704))
  call compute_scalar_box([ 33, 45, 47 ],masses2_19,RedSet_4(210),ScalarBoxes(705))
  call compute_scalar_box([ 33, 37, 45 ],masses2_17,RedSet_4(20),ScalarBoxes(706))
  call compute_scalar_box([ 32, 33, 45 ],masses2_25,RedSet_4(25),ScalarBoxes(707))
  call compute_scalar_box([ 1, 13, 15 ],masses2_19,RedSet_4(213),ScalarBoxes(708))
  call compute_scalar_box([ 33, 53, 55 ],masses2_19,RedSet_4(215),ScalarBoxes(709))
  call compute_scalar_box([ 33, 37, 53 ],masses2_17,RedSet_4(7),ScalarBoxes(710))
  call compute_scalar_box([ 32, 33, 53 ],masses2_25,RedSet_4(14),ScalarBoxes(711))
  call compute_scalar_box([ 1, 21, 23 ],masses2_19,RedSet_4(218),ScalarBoxes(712))
  call compute_scalar_box([ 37, 53, 61 ],masses2_17,RedSet_4(4),ScalarBoxes(713))
  call compute_scalar_box([ 33, 53, 61 ],masses2_17,RedSet_4(5),ScalarBoxes(714))
  call compute_scalar_box([ 33, 37, 61 ],masses2_17,RedSet_4(6),ScalarBoxes(715))
  call compute_scalar_box([ 4, 20, 28 ],masses2_16,RedSet_4(8),ScalarBoxes(716))
  call compute_scalar_box([ 32, 53, 61 ],masses2_25,RedSet_4(9),ScalarBoxes(717))
  call compute_scalar_box([ 32, 37, 61 ],masses2_25,RedSet_4(10),ScalarBoxes(718))
  call compute_scalar_box([ 5, 21, 29 ],masses2_17,RedSet_4(12),ScalarBoxes(719))
  call compute_scalar_box([ 32, 33, 61 ],masses2_25,RedSet_4(13),ScalarBoxes(720))
  call compute_scalar_box([ 1, 21, 29 ],masses2_17,RedSet_4(15),ScalarBoxes(721))
  call compute_scalar_box([ 1, 5, 29 ],masses2_17,RedSet_4(16),ScalarBoxes(722))
  call compute_scalar_box([ 37, 45, 61 ],masses2_17,RedSet_4(18),ScalarBoxes(723))
  call compute_scalar_box([ 33, 45, 61 ],masses2_17,RedSet_4(19),ScalarBoxes(724))
  call compute_scalar_box([ 4, 12, 28 ],masses2_16,RedSet_4(21),ScalarBoxes(725))
  call compute_scalar_box([ 32, 45, 61 ],masses2_25,RedSet_4(22),ScalarBoxes(726))
  call compute_scalar_box([ 5, 13, 29 ],masses2_17,RedSet_4(24),ScalarBoxes(727))
  call compute_scalar_box([ 1, 13, 29 ],masses2_17,RedSet_4(26),ScalarBoxes(728))
  call compute_scalar_box([ 38, 46, 47 ],masses2_19,RedSet_4(220),ScalarBoxes(729))
  call compute_scalar_box([ 36, 38, 46 ],masses2_25,RedSet_4(222),ScalarBoxes(730))
  call compute_scalar_box([ 32, 38, 46 ],masses2_25,RedSet_4(225),ScalarBoxes(731))
  call compute_scalar_box([ 6, 14, 15 ],masses2_19,RedSet_4(226),ScalarBoxes(732))
  call compute_scalar_box([ 38, 54, 55 ],masses2_19,RedSet_4(230),ScalarBoxes(733))
  call compute_scalar_box([ 36, 38, 54 ],masses2_25,RedSet_4(232),ScalarBoxes(734))
  call compute_scalar_box([ 32, 38, 54 ],masses2_25,RedSet_4(235),ScalarBoxes(735))
  call compute_scalar_box([ 6, 22, 23 ],masses2_19,RedSet_4(236),ScalarBoxes(736))
  call compute_scalar_box([ 34, 38, 46 ],masses2_17,RedSet_4(240),ScalarBoxes(737))
  call compute_scalar_box([ 34, 38, 54 ],masses2_17,RedSet_4(245),ScalarBoxes(738))
  call compute_scalar_box([ 42, 43, 59 ],masses2_22,RedSet_4(334),ScalarBoxes(739))
  call compute_scalar_box([ 8, 9, 25 ],masses2_21,RedSet_4(336),ScalarBoxes(740))
  call compute_scalar_box([ 10, 11, 27 ],masses2_22,RedSet_4(338),ScalarBoxes(741))
  call compute_scalar_box([ 50, 51, 59 ],masses2_22,RedSet_4(340),ScalarBoxes(742))
  call compute_scalar_box([ 16, 17, 25 ],masses2_21,RedSet_4(342),ScalarBoxes(743))
  call compute_scalar_box([ 18, 19, 27 ],masses2_22,RedSet_4(344),ScalarBoxes(744))
  call compute_scalar_box([ 33, 41, 47 ],masses2_19,RedSet_4(248),ScalarBoxes(745))
  call compute_scalar_box([ 33, 41, 43 ],masses2_19,RedSet_4(347),ScalarBoxes(746))
  call compute_scalar_box([ 32, 33, 41 ],masses2_25,RedSet_4(2),ScalarBoxes(747))
  call compute_scalar_box([ 1, 9, 15 ],masses2_19,RedSet_4(249),ScalarBoxes(748))
  call compute_scalar_box([ 33, 41, 45 ],masses2_17,RedSet_4(42),ScalarBoxes(749))
  call compute_scalar_box([ 41, 57, 59 ],masses2_19,RedSet_4(250),ScalarBoxes(750))
  call compute_scalar_box([ 33, 57, 59 ],masses2_19,RedSet_4(251),ScalarBoxes(751))
  call compute_scalar_box([ 33, 41, 59 ],masses2_19,RedSet_4(252),ScalarBoxes(752))
  call compute_scalar_box([ 33, 41, 57 ],masses2_17,RedSet_4(31),ScalarBoxes(753))
  call compute_scalar_box([ 8, 24, 26 ],masses2_18,RedSet_4(253),ScalarBoxes(754))
  call compute_scalar_box([ 32, 57, 59 ],masses2_26,RedSet_4(254),ScalarBoxes(755))
  call compute_scalar_box([ 32, 41, 59 ],masses2_26,RedSet_4(255),ScalarBoxes(756))
  call compute_scalar_box([ 32, 41, 57 ],masses2_25,RedSet_4(35),ScalarBoxes(757))
  call compute_scalar_box([ 9, 25, 27 ],masses2_19,RedSet_4(256),ScalarBoxes(758))
  call compute_scalar_box([ 32, 33, 57 ],masses2_25,RedSet_4(37),ScalarBoxes(759))
  call compute_scalar_box([ 1, 25, 27 ],masses2_19,RedSet_4(258),ScalarBoxes(760))
  call compute_scalar_box([ 1, 9, 27 ],masses2_19,RedSet_4(259),ScalarBoxes(761))
  call compute_scalar_box([ 41, 57, 61 ],masses2_17,RedSet_4(28),ScalarBoxes(762))
  call compute_scalar_box([ 33, 57, 61 ],masses2_17,RedSet_4(29),ScalarBoxes(763))
  call compute_scalar_box([ 33, 41, 61 ],masses2_17,RedSet_4(30),ScalarBoxes(764))
  call compute_scalar_box([ 8, 24, 28 ],masses2_16,RedSet_4(32),ScalarBoxes(765))
  call compute_scalar_box([ 32, 57, 61 ],masses2_25,RedSet_4(33),ScalarBoxes(766))
  call compute_scalar_box([ 32, 41, 61 ],masses2_25,RedSet_4(34),ScalarBoxes(767))
  call compute_scalar_box([ 9, 25, 29 ],masses2_17,RedSet_4(36),ScalarBoxes(768))
  call compute_scalar_box([ 1, 25, 29 ],masses2_17,RedSet_4(38),ScalarBoxes(769))
  call compute_scalar_box([ 1, 9, 29 ],masses2_17,RedSet_4(39),ScalarBoxes(770))
  call compute_scalar_box([ 41, 43, 59 ],masses2_22,RedSet_4(350),ScalarBoxes(771))
  call compute_scalar_box([ 8, 10, 26 ],masses2_21,RedSet_4(352),ScalarBoxes(772))
  call compute_scalar_box([ 9, 11, 27 ],masses2_22,RedSet_4(353),ScalarBoxes(773))
  call compute_scalar_box([ 41, 45, 61 ],masses2_17,RedSet_4(41),ScalarBoxes(774))
  call compute_scalar_box([ 8, 12, 28 ],masses2_16,RedSet_4(43),ScalarBoxes(775))
  call compute_scalar_box([ 9, 13, 29 ],masses2_17,RedSet_4(45),ScalarBoxes(776))
  call compute_scalar_box([ 49, 53, 55 ],masses2_19,RedSet_4(260),ScalarBoxes(777))
  call compute_scalar_box([ 33, 49, 55 ],masses2_19,RedSet_4(261),ScalarBoxes(778))
  call compute_scalar_box([ 33, 49, 53 ],masses2_17,RedSet_4(57),ScalarBoxes(779))
  call compute_scalar_box([ 16, 20, 22 ],masses2_18,RedSet_4(262),ScalarBoxes(780))
  call compute_scalar_box([ 32, 49, 55 ],masses2_26,RedSet_4(263),ScalarBoxes(781))
  call compute_scalar_box([ 32, 49, 53 ],masses2_25,RedSet_4(59),ScalarBoxes(782))
  call compute_scalar_box([ 17, 21, 23 ],masses2_19,RedSet_4(264),ScalarBoxes(783))
  call compute_scalar_box([ 32, 33, 49 ],masses2_25,RedSet_4(3),ScalarBoxes(784))
  call compute_scalar_box([ 1, 17, 23 ],masses2_19,RedSet_4(265),ScalarBoxes(785))
  call compute_scalar_box([ 49, 57, 59 ],masses2_19,RedSet_4(266),ScalarBoxes(786))
  call compute_scalar_box([ 33, 49, 59 ],masses2_19,RedSet_4(267),ScalarBoxes(787))
  call compute_scalar_box([ 33, 49, 57 ],masses2_17,RedSet_4(49),ScalarBoxes(788))
  call compute_scalar_box([ 16, 24, 26 ],masses2_18,RedSet_4(268),ScalarBoxes(789))
  call compute_scalar_box([ 32, 49, 59 ],masses2_26,RedSet_4(269),ScalarBoxes(790))
  call compute_scalar_box([ 32, 49, 57 ],masses2_25,RedSet_4(52),ScalarBoxes(791))
  call compute_scalar_box([ 17, 25, 27 ],masses2_19,RedSet_4(270),ScalarBoxes(792))
  call compute_scalar_box([ 1, 17, 27 ],masses2_19,RedSet_4(271),ScalarBoxes(793))
  call compute_scalar_box([ 49, 51, 55 ],masses2_22,RedSet_4(355),ScalarBoxes(794))
  call compute_scalar_box([ 33, 49, 51 ],masses2_19,RedSet_4(357),ScalarBoxes(795))
  call compute_scalar_box([ 16, 18, 22 ],masses2_21,RedSet_4(358),ScalarBoxes(796))
  call compute_scalar_box([ 32, 49, 51 ],masses2_26,RedSet_4(359),ScalarBoxes(797))
  call compute_scalar_box([ 17, 19, 23 ],masses2_22,RedSet_4(360),ScalarBoxes(798))
  call compute_scalar_box([ 49, 57, 61 ],masses2_17,RedSet_4(47),ScalarBoxes(799))
  call compute_scalar_box([ 33, 49, 61 ],masses2_17,RedSet_4(48),ScalarBoxes(800))
  call compute_scalar_box([ 16, 24, 28 ],masses2_16,RedSet_4(50),ScalarBoxes(801))
  call compute_scalar_box([ 32, 49, 61 ],masses2_25,RedSet_4(51),ScalarBoxes(802))
  call compute_scalar_box([ 17, 25, 29 ],masses2_17,RedSet_4(53),ScalarBoxes(803))
  call compute_scalar_box([ 1, 17, 29 ],masses2_17,RedSet_4(54),ScalarBoxes(804))
  call compute_scalar_box([ 49, 51, 59 ],masses2_22,RedSet_4(363),ScalarBoxes(805))
  call compute_scalar_box([ 16, 18, 26 ],masses2_21,RedSet_4(365),ScalarBoxes(806))
  call compute_scalar_box([ 17, 19, 27 ],masses2_22,RedSet_4(366),ScalarBoxes(807))
  call compute_scalar_box([ 49, 53, 61 ],masses2_17,RedSet_4(56),ScalarBoxes(808))
  call compute_scalar_box([ 16, 20, 28 ],masses2_16,RedSet_4(58),ScalarBoxes(809))
  call compute_scalar_box([ 17, 21, 29 ],masses2_17,RedSet_4(60),ScalarBoxes(810))
  call compute_scalar_box([ 56, 60, 61 ],masses2_18,RedSet_4(433),ScalarBoxes(811))
  call compute_scalar_box([ 48, 60, 61 ],masses2_18,RedSet_4(434),ScalarBoxes(812))
  call compute_scalar_box([ 48, 56, 61 ],masses2_18,RedSet_4(406),ScalarBoxes(813))
  call compute_scalar_box([ 48, 56, 60 ],masses2_16,RedSet_4(407),ScalarBoxes(814))
  call compute_scalar_box([ 52, 60, 61 ],masses2_18,RedSet_4(435),ScalarBoxes(815))
  call compute_scalar_box([ 48, 52, 61 ],masses2_18,RedSet_4(408),ScalarBoxes(816))
  call compute_scalar_box([ 48, 52, 60 ],masses2_16,RedSet_4(409),ScalarBoxes(817))
  call compute_scalar_box([ 44, 60, 62 ],masses2_18,RedSet_4(436),ScalarBoxes(818))
  call compute_scalar_box([ 40, 60, 62 ],masses2_18,RedSet_4(437),ScalarBoxes(819))
  call compute_scalar_box([ 40, 44, 62 ],masses2_18,RedSet_4(410),ScalarBoxes(820))
  call compute_scalar_box([ 40, 44, 60 ],masses2_16,RedSet_4(411),ScalarBoxes(821))
  call compute_scalar_box([ 56, 60, 62 ],masses2_18,RedSet_4(438),ScalarBoxes(822))
  call compute_scalar_box([ 48, 60, 62 ],masses2_18,RedSet_4(439),ScalarBoxes(823))
  call compute_scalar_box([ 48, 56, 62 ],masses2_18,RedSet_4(412),ScalarBoxes(824))
  call compute_scalar_box([ 52, 60, 62 ],masses2_18,RedSet_4(440),ScalarBoxes(825))
  call compute_scalar_box([ 48, 52, 62 ],masses2_18,RedSet_4(413),ScalarBoxes(826))
  call compute_scalar_box([ 44, 60, 61 ],masses2_18,RedSet_4(441),ScalarBoxes(827))
  call compute_scalar_box([ 40, 60, 61 ],masses2_18,RedSet_4(442),ScalarBoxes(828))
  call compute_scalar_box([ 40, 44, 61 ],masses2_18,RedSet_4(414),ScalarBoxes(829))
  call compute_scalar_box([ 56, 57, 61 ],masses2_21,RedSet_4(443),ScalarBoxes(830))
  call compute_scalar_box([ 48, 57, 61 ],masses2_21,RedSet_4(444),ScalarBoxes(831))
  call compute_scalar_box([ 48, 56, 57 ],masses2_18,RedSet_4(415),ScalarBoxes(832))
  call compute_scalar_box([ 52, 53, 61 ],masses2_21,RedSet_4(445),ScalarBoxes(833))
  call compute_scalar_box([ 48, 53, 61 ],masses2_21,RedSet_4(446),ScalarBoxes(834))
  call compute_scalar_box([ 48, 52, 53 ],masses2_18,RedSet_4(416),ScalarBoxes(835))
  call compute_scalar_box([ 42, 58, 62 ],masses2_29,RedSet_4(447),ScalarBoxes(836))
  call compute_scalar_box([ 40, 58, 62 ],masses2_21,RedSet_4(448),ScalarBoxes(837))
  call compute_scalar_box([ 40, 42, 62 ],masses2_21,RedSet_4(417),ScalarBoxes(838))
  call compute_scalar_box([ 40, 42, 58 ],masses2_21,RedSet_4(418),ScalarBoxes(839))
  call compute_scalar_box([ 38, 54, 62 ],masses2_29,RedSet_4(449),ScalarBoxes(840))
  call compute_scalar_box([ 36, 54, 62 ],masses2_21,RedSet_4(450),ScalarBoxes(841))
  call compute_scalar_box([ 36, 38, 62 ],masses2_21,RedSet_4(419),ScalarBoxes(842))
  call compute_scalar_box([ 56, 58, 62 ],masses2_21,RedSet_4(451),ScalarBoxes(843))
  call compute_scalar_box([ 48, 58, 62 ],masses2_21,RedSet_4(452),ScalarBoxes(844))
  call compute_scalar_box([ 48, 56, 58 ],masses2_18,RedSet_4(420),ScalarBoxes(845))
  call compute_scalar_box([ 44, 45, 61 ],masses2_21,RedSet_4(453),ScalarBoxes(846))
  call compute_scalar_box([ 40, 45, 61 ],masses2_21,RedSet_4(454),ScalarBoxes(847))
  call compute_scalar_box([ 50, 58, 62 ],masses2_29,RedSet_4(455),ScalarBoxes(848))
  call compute_scalar_box([ 48, 50, 62 ],masses2_21,RedSet_4(421),ScalarBoxes(849))
  call compute_scalar_box([ 48, 50, 58 ],masses2_21,RedSet_4(422),ScalarBoxes(850))
  call compute_scalar_box([ 38, 46, 62 ],masses2_29,RedSet_4(456),ScalarBoxes(851))
  call compute_scalar_box([ 36, 46, 62 ],masses2_21,RedSet_4(457),ScalarBoxes(852))
  call compute_scalar_box([ 48, 49, 61 ],masses2_21,RedSet_4(423),ScalarBoxes(853))
  call compute_scalar_box([ 48, 49, 53 ],masses2_21,RedSet_4(424),ScalarBoxes(854))
  call compute_scalar_box([ 40, 41, 61 ],masses2_21,RedSet_4(425),ScalarBoxes(855))
  call compute_scalar_box([ 52, 54, 62 ],masses2_21,RedSet_4(458),ScalarBoxes(856))
  call compute_scalar_box([ 48, 54, 62 ],masses2_21,RedSet_4(459),ScalarBoxes(857))
  call compute_scalar_box([ 48, 52, 54 ],masses2_18,RedSet_4(426),ScalarBoxes(858))
  call compute_scalar_box([ 44, 46, 62 ],masses2_21,RedSet_4(460),ScalarBoxes(859))
  call compute_scalar_box([ 40, 46, 62 ],masses2_21,RedSet_4(461),ScalarBoxes(860))
  call compute_scalar_box([ 50, 54, 62 ],masses2_29,RedSet_4(462),ScalarBoxes(861))
  call compute_scalar_box([ 48, 50, 54 ],masses2_21,RedSet_4(427),ScalarBoxes(862))
  call compute_scalar_box([ 42, 46, 62 ],masses2_29,RedSet_4(463),ScalarBoxes(863))
  call compute_scalar_box([ 48, 49, 57 ],masses2_21,RedSet_4(428),ScalarBoxes(864))
  call compute_scalar_box([ 36, 45, 61 ],masses2_21,RedSet_4(464),ScalarBoxes(865))
  call compute_scalar_box([ 36, 37, 61 ],masses2_21,RedSet_4(429),ScalarBoxes(866))
  call compute_scalar_box([ 40, 57, 61 ],masses2_21,RedSet_4(465),ScalarBoxes(867))
  call compute_scalar_box([ 40, 41, 57 ],masses2_21,RedSet_4(430),ScalarBoxes(868))
  call compute_scalar_box([ 36, 53, 61 ],masses2_21,RedSet_4(466),ScalarBoxes(869))
  call compute_scalar_box([ 56, 58, 59 ],masses2_20,RedSet_4(467),ScalarBoxes(870))
  call compute_scalar_box([ 48, 58, 59 ],masses2_20,RedSet_4(468),ScalarBoxes(871))
  call compute_scalar_box([ 48, 56, 59 ],masses2_16,RedSet_4(469),ScalarBoxes(872))
  call compute_scalar_box([ 48, 53, 55 ],masses2_20,RedSet_4(470),ScalarBoxes(873))
  call compute_scalar_box([ 48, 52, 55 ],masses2_16,RedSet_4(471),ScalarBoxes(874))
  call compute_scalar_box([ 56, 60, 61 ],masses2_28,RedSet_4(433),ScalarBoxes(875))
  call compute_scalar_box([ 48, 60, 61 ],masses2_28,RedSet_4(434),ScalarBoxes(876))
  call compute_scalar_box([ 48, 56, 61 ],masses2_28,RedSet_4(406),ScalarBoxes(877))
  call compute_scalar_box([ 48, 56, 60 ],masses2_30,RedSet_4(407),ScalarBoxes(878))
  call compute_scalar_box([ 56, 57, 59 ],masses2_20,RedSet_4(472),ScalarBoxes(879))
  call compute_scalar_box([ 48, 57, 59 ],masses2_20,RedSet_4(473),ScalarBoxes(880))
  call compute_scalar_box([ 48, 54, 55 ],masses2_20,RedSet_4(474),ScalarBoxes(881))
  call compute_scalar_box([ 52, 60, 61 ],masses2_28,RedSet_4(435),ScalarBoxes(882))
  call compute_scalar_box([ 48, 52, 61 ],masses2_28,RedSet_4(408),ScalarBoxes(883))
  call compute_scalar_box([ 48, 52, 60 ],masses2_30,RedSet_4(409),ScalarBoxes(884))
  call compute_scalar_box([ 44, 60, 62 ],masses2_28,RedSet_4(436),ScalarBoxes(885))
  call compute_scalar_box([ 40, 60, 62 ],masses2_28,RedSet_4(437),ScalarBoxes(886))
  call compute_scalar_box([ 40, 44, 62 ],masses2_28,RedSet_4(410),ScalarBoxes(887))
  call compute_scalar_box([ 40, 44, 60 ],masses2_30,RedSet_4(411),ScalarBoxes(888))
  call compute_scalar_box([ 56, 60, 62 ],masses2_28,RedSet_4(438),ScalarBoxes(889))
  call compute_scalar_box([ 48, 60, 62 ],masses2_28,RedSet_4(439),ScalarBoxes(890))
  call compute_scalar_box([ 48, 56, 62 ],masses2_28,RedSet_4(412),ScalarBoxes(891))
  call compute_scalar_box([ 52, 60, 62 ],masses2_28,RedSet_4(440),ScalarBoxes(892))
  call compute_scalar_box([ 48, 52, 62 ],masses2_28,RedSet_4(413),ScalarBoxes(893))
  call compute_scalar_box([ 44, 60, 61 ],masses2_28,RedSet_4(441),ScalarBoxes(894))
  call compute_scalar_box([ 40, 60, 61 ],masses2_28,RedSet_4(442),ScalarBoxes(895))
  call compute_scalar_box([ 40, 44, 61 ],masses2_28,RedSet_4(414),ScalarBoxes(896))
  call compute_scalar_box([ 48, 50, 55 ],masses2_20,RedSet_4(475),ScalarBoxes(897))
  call compute_scalar_box([ 48, 50, 59 ],masses2_20,RedSet_4(476),ScalarBoxes(898))
  call compute_scalar_box([ 40, 58, 59 ],masses2_20,RedSet_4(477),ScalarBoxes(899))
  call compute_scalar_box([ 40, 42, 59 ],masses2_20,RedSet_4(478),ScalarBoxes(900))
  call compute_scalar_box([ 48, 49, 55 ],masses2_20,RedSet_4(479),ScalarBoxes(901))
  call compute_scalar_box([ 48, 49, 59 ],masses2_20,RedSet_4(480),ScalarBoxes(902))
  call compute_scalar_box([ 40, 57, 59 ],masses2_20,RedSet_4(481),ScalarBoxes(903))
  call compute_scalar_box([ 40, 41, 59 ],masses2_20,RedSet_4(482),ScalarBoxes(904))
  call compute_scalar_box([ 56, 58, 59 ],masses2_26,RedSet_4(467),ScalarBoxes(905))
  call compute_scalar_box([ 48, 58, 59 ],masses2_26,RedSet_4(468),ScalarBoxes(906))
  call compute_scalar_box([ 48, 56, 59 ],masses2_30,RedSet_4(469),ScalarBoxes(907))
  call compute_scalar_box([ 48, 56, 58 ],masses2_28,RedSet_4(420),ScalarBoxes(908))
  call compute_scalar_box([ 48, 53, 55 ],masses2_26,RedSet_4(470),ScalarBoxes(909))
  call compute_scalar_box([ 48, 52, 55 ],masses2_30,RedSet_4(471),ScalarBoxes(910))
  call compute_scalar_box([ 48, 52, 53 ],masses2_28,RedSet_4(416),ScalarBoxes(911))
  call compute_scalar_box([ 48, 51, 55 ],masses2_30,RedSet_4(483),ScalarBoxes(912))
  call compute_scalar_box([ 48, 50, 55 ],masses2_26,RedSet_4(475),ScalarBoxes(913))
  call compute_scalar_box([ 48, 50, 51 ],masses2_26,RedSet_4(431),ScalarBoxes(914))
  call compute_scalar_box([ 48, 51, 55 ],masses2_16,RedSet_4(483),ScalarBoxes(915))
  call compute_scalar_box([ 48, 50, 51 ],masses2_20,RedSet_4(431),ScalarBoxes(916))
  call compute_scalar_box([ 56, 57, 59 ],masses2_26,RedSet_4(472),ScalarBoxes(917))
  call compute_scalar_box([ 48, 57, 59 ],masses2_26,RedSet_4(473),ScalarBoxes(918))
  call compute_scalar_box([ 48, 56, 57 ],masses2_28,RedSet_4(415),ScalarBoxes(919))
  call compute_scalar_box([ 48, 54, 55 ],masses2_26,RedSet_4(474),ScalarBoxes(920))
  call compute_scalar_box([ 48, 52, 54 ],masses2_28,RedSet_4(426),ScalarBoxes(921))
  call compute_scalar_box([ 48, 51, 59 ],masses2_30,RedSet_4(484),ScalarBoxes(922))
  call compute_scalar_box([ 48, 50, 59 ],masses2_26,RedSet_4(476),ScalarBoxes(923))
  call compute_scalar_box([ 48, 51, 59 ],masses2_16,RedSet_4(484),ScalarBoxes(924))
  call compute_scalar_box([ 40, 43, 59 ],masses2_30,RedSet_4(485),ScalarBoxes(925))
  call compute_scalar_box([ 40, 42, 59 ],masses2_26,RedSet_4(478),ScalarBoxes(926))
  call compute_scalar_box([ 40, 43, 59 ],masses2_16,RedSet_4(485),ScalarBoxes(927))
  call compute_scalar_box([ 48, 49, 55 ],masses2_26,RedSet_4(479),ScalarBoxes(928))
  call compute_scalar_box([ 48, 49, 51 ],masses2_26,RedSet_4(432),ScalarBoxes(929))
  call compute_scalar_box([ 48, 49, 51 ],masses2_20,RedSet_4(432),ScalarBoxes(930))
  call compute_scalar_box([ 48, 49, 59 ],masses2_26,RedSet_4(480),ScalarBoxes(931))
  call compute_scalar_box([ 40, 41, 59 ],masses2_26,RedSet_4(482),ScalarBoxes(932))
  call compute_scalar_box([ 56, 57, 61 ],masses2_25,RedSet_4(443),ScalarBoxes(933))
  call compute_scalar_box([ 48, 57, 61 ],masses2_25,RedSet_4(444),ScalarBoxes(934))
  call compute_scalar_box([ 48, 50, 54 ],masses2_25,RedSet_4(427),ScalarBoxes(935))
  call compute_scalar_box([ 52, 53, 61 ],masses2_25,RedSet_4(445),ScalarBoxes(936))
  call compute_scalar_box([ 48, 53, 61 ],masses2_25,RedSet_4(446),ScalarBoxes(937))
  call compute_scalar_box([ 48, 50, 58 ],masses2_25,RedSet_4(422),ScalarBoxes(938))
  call compute_scalar_box([ 42, 58, 62 ],masses2_17,RedSet_4(447),ScalarBoxes(939))
  call compute_scalar_box([ 40, 58, 62 ],masses2_25,RedSet_4(448),ScalarBoxes(940))
  call compute_scalar_box([ 40, 42, 62 ],masses2_25,RedSet_4(417),ScalarBoxes(941))
  call compute_scalar_box([ 40, 42, 58 ],masses2_25,RedSet_4(418),ScalarBoxes(942))
  call compute_scalar_box([ 38, 54, 62 ],masses2_17,RedSet_4(449),ScalarBoxes(943))
  call compute_scalar_box([ 36, 54, 62 ],masses2_25,RedSet_4(450),ScalarBoxes(944))
  call compute_scalar_box([ 36, 38, 62 ],masses2_25,RedSet_4(419),ScalarBoxes(945))
  call compute_scalar_box([ 56, 58, 62 ],masses2_25,RedSet_4(451),ScalarBoxes(946))
  call compute_scalar_box([ 48, 58, 62 ],masses2_25,RedSet_4(452),ScalarBoxes(947))
  call compute_scalar_box([ 44, 45, 61 ],masses2_25,RedSet_4(453),ScalarBoxes(948))
  call compute_scalar_box([ 40, 45, 61 ],masses2_25,RedSet_4(454),ScalarBoxes(949))
  call compute_scalar_box([ 50, 58, 62 ],masses2_17,RedSet_4(455),ScalarBoxes(950))
  call compute_scalar_box([ 48, 50, 62 ],masses2_25,RedSet_4(421),ScalarBoxes(951))
  call compute_scalar_box([ 38, 46, 62 ],masses2_17,RedSet_4(456),ScalarBoxes(952))
  call compute_scalar_box([ 36, 46, 62 ],masses2_25,RedSet_4(457),ScalarBoxes(953))
  call compute_scalar_box([ 40, 58, 59 ],masses2_26,RedSet_4(477),ScalarBoxes(954))
  call compute_scalar_box([ 48, 49, 53 ],masses2_25,RedSet_4(424),ScalarBoxes(955))
  call compute_scalar_box([ 48, 49, 61 ],masses2_25,RedSet_4(423),ScalarBoxes(956))
  call compute_scalar_box([ 40, 41, 61 ],masses2_25,RedSet_4(425),ScalarBoxes(957))
  call compute_scalar_box([ 52, 54, 62 ],masses2_25,RedSet_4(458),ScalarBoxes(958))
  call compute_scalar_box([ 48, 54, 62 ],masses2_25,RedSet_4(459),ScalarBoxes(959))
  call compute_scalar_box([ 44, 46, 62 ],masses2_25,RedSet_4(460),ScalarBoxes(960))
  call compute_scalar_box([ 40, 46, 62 ],masses2_25,RedSet_4(461),ScalarBoxes(961))
  call compute_scalar_box([ 50, 54, 62 ],masses2_17,RedSet_4(462),ScalarBoxes(962))
  call compute_scalar_box([ 42, 46, 62 ],masses2_17,RedSet_4(463),ScalarBoxes(963))
  call compute_scalar_box([ 48, 49, 57 ],masses2_25,RedSet_4(428),ScalarBoxes(964))
  call compute_scalar_box([ 36, 45, 61 ],masses2_25,RedSet_4(464),ScalarBoxes(965))
  call compute_scalar_box([ 36, 37, 61 ],masses2_25,RedSet_4(429),ScalarBoxes(966))
  call compute_scalar_box([ 40, 57, 61 ],masses2_25,RedSet_4(465),ScalarBoxes(967))
  call compute_scalar_box([ 40, 41, 57 ],masses2_25,RedSet_4(430),ScalarBoxes(968))
  call compute_scalar_box([ 36, 53, 61 ],masses2_25,RedSet_4(466),ScalarBoxes(969))
  call compute_scalar_box([ 40, 57, 59 ],masses2_26,RedSet_4(481),ScalarBoxes(970))
  call compute_scalar_box([ 35, 51, 55 ],masses2_23,RedSet_4(390),ScalarBoxes(971))
  call compute_scalar_box([ 32, 51, 55 ],masses2_23,RedSet_4(323),ScalarBoxes(972))
  call compute_scalar_box([ 32, 35, 55 ],masses2_23,RedSet_4(378),ScalarBoxes(973))
  call compute_scalar_box([ 32, 35, 51 ],masses2_23,RedSet_4(392),ScalarBoxes(974))
  call compute_scalar_box([ 3, 19, 23 ],masses2_23,RedSet_4(393),ScalarBoxes(975))
  call compute_scalar_box([ 35, 43, 47 ],masses2_23,RedSet_4(381),ScalarBoxes(976))
  call compute_scalar_box([ 32, 43, 47 ],masses2_23,RedSet_4(276),ScalarBoxes(977))
  call compute_scalar_box([ 32, 35, 47 ],masses2_23,RedSet_4(371),ScalarBoxes(978))
  call compute_scalar_box([ 32, 35, 43 ],masses2_23,RedSet_4(383),ScalarBoxes(979))
  call compute_scalar_box([ 3, 11, 15 ],masses2_23,RedSet_4(384),ScalarBoxes(980))
  call compute_scalar_box([ 35, 51, 59 ],masses2_23,RedSet_4(394),ScalarBoxes(981))
  call compute_scalar_box([ 32, 51, 59 ],masses2_23,RedSet_4(343),ScalarBoxes(982))
  call compute_scalar_box([ 32, 35, 59 ],masses2_23,RedSet_4(387),ScalarBoxes(983))
  call compute_scalar_box([ 3, 19, 27 ],masses2_23,RedSet_4(395),ScalarBoxes(984))
  call compute_scalar_box([ 36, 44, 47 ],masses2_23,RedSet_4(78),ScalarBoxes(985))
  call compute_scalar_box([ 32, 44, 47 ],masses2_23,RedSet_4(68),ScalarBoxes(986))
  call compute_scalar_box([ 32, 36, 47 ],masses2_23,RedSet_4(81),ScalarBoxes(987))
  call compute_scalar_box([ 32, 36, 44 ],masses2_23,RedSet_4(84),ScalarBoxes(988))
  call compute_scalar_box([ 4, 12, 15 ],masses2_23,RedSet_4(85),ScalarBoxes(989))
  call compute_scalar_box([ 35, 39, 47 ],masses2_23,RedSet_4(368),ScalarBoxes(990))
  call compute_scalar_box([ 32, 39, 47 ],masses2_23,RedSet_4(285),ScalarBoxes(991))
  call compute_scalar_box([ 32, 35, 39 ],masses2_23,RedSet_4(372),ScalarBoxes(992))
  call compute_scalar_box([ 3, 7, 15 ],masses2_23,RedSet_4(373),ScalarBoxes(993))
  call compute_scalar_box([ 40, 44, 47 ],masses2_23,RedSet_4(64),ScalarBoxes(994))
  call compute_scalar_box([ 32, 40, 47 ],masses2_23,RedSet_4(71),ScalarBoxes(995))
  call compute_scalar_box([ 32, 40, 44 ],masses2_23,RedSet_4(74),ScalarBoxes(996))
  call compute_scalar_box([ 8, 12, 15 ],masses2_23,RedSet_4(75),ScalarBoxes(997))
  call compute_scalar_box([ 35, 43, 59 ],masses2_23,RedSet_4(385),ScalarBoxes(998))
  call compute_scalar_box([ 32, 43, 59 ],masses2_23,RedSet_4(337),ScalarBoxes(999))
  call compute_scalar_box([ 3, 11, 27 ],masses2_23,RedSet_4(388),ScalarBoxes(1000))
  call compute_scalar_box([ 36, 52, 55 ],masses2_23,RedSet_4(89),ScalarBoxes(1001))
  call compute_scalar_box([ 32, 52, 55 ],masses2_23,RedSet_4(93),ScalarBoxes(1002))
  call compute_scalar_box([ 32, 36, 55 ],masses2_23,RedSet_4(96),ScalarBoxes(1003))
  call compute_scalar_box([ 32, 36, 52 ],masses2_23,RedSet_4(99),ScalarBoxes(1004))
  call compute_scalar_box([ 4, 20, 23 ],masses2_23,RedSet_4(100),ScalarBoxes(1005))
  call compute_scalar_box([ 35, 39, 55 ],masses2_23,RedSet_4(376),ScalarBoxes(1006))
  call compute_scalar_box([ 32, 39, 55 ],masses2_23,RedSet_4(293),ScalarBoxes(1007))
  call compute_scalar_box([ 3, 7, 23 ],masses2_23,RedSet_4(379),ScalarBoxes(1008))
  call compute_scalar_box([ 40, 43, 47 ],masses2_23,RedSet_4(273),ScalarBoxes(1009))
  call compute_scalar_box([ 32, 40, 43 ],masses2_23,RedSet_4(279),ScalarBoxes(1010))
  call compute_scalar_box([ 8, 11, 15 ],masses2_23,RedSet_4(280),ScalarBoxes(1011))
  call compute_scalar_box([ 36, 39, 55 ],masses2_23,RedSet_4(291),ScalarBoxes(1012))
  call compute_scalar_box([ 32, 36, 39 ],masses2_23,RedSet_4(288),ScalarBoxes(1013))
  call compute_scalar_box([ 4, 7, 23 ],masses2_23,RedSet_4(295),ScalarBoxes(1014))
  call compute_scalar_box([ 36, 39, 47 ],masses2_23,RedSet_4(282),ScalarBoxes(1015))
  call compute_scalar_box([ 4, 7, 15 ],masses2_23,RedSet_4(289),ScalarBoxes(1016))
! end of process


end subroutine vamp_49

end module ol_vamp_49_ppttjj_ttxgggg_1_/**/REALKIND
