
module ol_vamp_47_ppttjj_ttxgggg_1_/**/REALKIND
contains

! **********************************************************************
subroutine vamp_47(M)
! P(0:3,nlegs) = incoming external momenta
! Uses tree structures 'wf', factors 'c', and denominators 'den' from loop_ppttjj_ttxgggg_1.
! Sets colour stripped amplitudes A from the module loop_amplitudes_ppttjj_ttxgggg_1.
! **********************************************************************
  use KIND_TYPES, only: REALKIND, QREALKIND, intkind2
  use ol_parameters_decl_/**/DREALKIND, only: l_switch
  use ol_parameters_decl_/**/QREALKIND ! masses
  use ol_vert_interface_/**/REALKIND
  use ol_prop_interface_/**/REALKIND
  use ol_last_step_/**/REALKIND
  use ol_tables_storage_ppttjj_ttxgggg_1_/**/DREALKIND
  use ol_tensor_sum_storage_ppttjj_ttxgggg_1_/**/REALKIND
  use ol_loop_handling_/**/REALKIND
  use ofred_reduction_/**/REALKIND, only: Hotf_4pt_reduction, Hotf_4pt_reduction_last
  use ofred_reduction_/**/REALKIND, only: Hotf_5pt_reduction, Hotf_5pt_reduction_last
  use ol_loop_reduction_/**/REALKIND, only: TI_bubble_red, TI_triangle_red
use ol_loop_reduction_/**/REALKIND, only: compute_scalar_box

  use ol_loop_storage_ppttjj_ttxgggg_1_/**/REALKIND
#ifndef PRECISION_dp
  use ol_loop_storage_ppttjj_ttxgggg_1_/**/DREALKIND, only: &
    & ntryL, p_switch, Hel, merge_step, merge_mism, merge_tables, merge_hels
#endif
  use hol_initialisation_/**/REALKIND, only: G0_hol_initialisation
  use ol_h_vert_interface_/**/REALKIND
  use ol_h_prop_interface_/**/REALKIND
  use ol_h_last_step_/**/REALKIND
  use ol_merging_/**/REALKIND, only: ol_merge, ol_merge_tensors, ol_merge_last

  implicit none

  type(Hpolcont) :: Gcoeff(64)
  type(Hpolcont), intent(in) :: M(50,64)


#ifndef PRECISION_dp
  if (ntryL==1 .OR. p_switch == 1) Gcoeff(:)%hf = Hel
#else
  if (ntryL==1 .OR. p_switch == 2) Gcoeff(:)%hf = Hel
#endif

  ! =============================================
  Gcoeff(:)%j = (c(10)*(M(1,:)%j-M(2,:)%j-M(4,:)%j+M(6,:)%j-M(10,:)%j+M(12,:)%j+M(18,:)%j-M(24,:)%j)) * den(1022)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(8687),h0tab(:,8687),[60,3],[0,0],2,2,wf16(:,522),wf4(:,1))
  call Hloop_CV_D(ntryL,G0H64(1),0,wf16(:,522),60,G1H4(1232),m3h16x4(:,1457),heltab2x64(:,:,6284))
  Gcoeff(:)%j = (c(4)*(-M(1,:)%j+M(2,:)%j+M(4,:)%j-M(6,:)%j+M(10,:)%j-M(12,:)%j-M(18,:)%j+M(24,:)%j)) * den(1022)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(8688),h0tab(:,8688),[60,3],[0,0],2,2,wf16(:,522),wf4(:,1))
  call Hloop_UV_W(ntryL,G0H64(1),0,wf16(:,522),60,G1H4(1233),m3h16x4(:,1458),heltab2x64(:,:,6285))
  Gcoeff(:)%j = (c(24)*(M(10,:)%j-M(12,:)%j)) * den(467)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(8689),h0tab(:,8689),[48,15],[0,0],2,2,wf4(:,7),wf16(:,22))
  call Hloop_QV_A(ntryL,G0H64(1),wf4(:,7),G0H16(355),m3h4x16(:,1054),heltab2x64(:,:,6286))
  call Hloop_Q_A(ntryL,G0H16(355),48,0,G1H16(1062),n2h16(1797))
  Gcoeff(:)%j = (c(22)*(M(10,:)%j-M(12,:)%j)) * den(467)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(8690),h0tab(:,8690),[48,15],[nMT,nMT],2,2,wf4(:,7),wf16(:,22))
  call Hloop_QV_A(ntryL,G0H64(1),wf4(:,7),G0H16(355),m3h4x16(:,1055),heltab2x64(:,:,6287))
  call Hloop_Q_A(ntryL,G0H16(355),48,nMT,G1H16(1063),n2h16(1798))
  Gcoeff(:)%j = (c(24)*(M(10,:)%j-M(12,:)%j)) * den(467)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(8691),h0tab(:,8691),[48,15],[0,0],2,2,wf4(:,7),wf16(:,22))
  call Hloop_QV_A(ntryL,G0H64(1),wf4(:,7),G0H16(355),m3h4x16(:,1056),heltab2x64(:,:,6288))
  call Hloop_Q_A(ntryL,G0H16(355),48,0,G1H16(1064),n2h16(1799))
  Gcoeff(:)%j = (c(22)*(M(10,:)%j-M(12,:)%j)) * den(467)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(8692),h0tab(:,8692),[48,15],[nMB,nMB],2,2,wf4(:,7),wf16(:,22))
  call Hloop_QV_A(ntryL,G0H64(1),wf4(:,7),G0H16(355),m3h4x16(:,1057),heltab2x64(:,:,6289))
  call Hloop_Q_A(ntryL,G0H16(355),48,nMB,G1H16(1065),n2h16(1800))
  Gcoeff(:)%j = (c(10)*(M(10,:)%j-M(12,:)%j)) * den(467)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(8693),h0tab(:,8693),[48,15],[0,0],2,2,wf4(:,7),wf16(:,22))
  call Hloop_CV_D(ntryL,G0H64(1),0,wf4(:,7),48,G1H16(1067),m3h4x16(:,1058),heltab2x64(:,:,6290))
  Gcoeff(:)%j = (c(4)*(-M(10,:)%j+M(12,:)%j)) * den(467)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(8694),h0tab(:,8694),[48,15],[0,0],2,2,wf4(:,7),wf16(:,22))
  call Hloop_UV_W(ntryL,G0H64(1),0,wf4(:,7),48,G1H16(1068),m3h4x16(:,1059),heltab2x64(:,:,6291))
  Gcoeff(:)%j = (c(8)*(-M(10,:)%j+M(12,:)%j)) * den(465)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(8695),h0tab(:,8695),[53,10],[nMT,0],2,2,wf16(:,202),wf4(:,15))
  call Hloop_VQ_A(ntryL,G0H64(1),wf16(:,202),G0H4(343),m3h16x4(:,1459),heltab2x64(:,:,6292))
  call Hloop_Q_A(ntryL,G0H4(343),53,nMT,G1H4(1234),n2h4(3915))
  Gcoeff(:)%j = (c(8)*(-M(10,:)%j+M(12,:)%j)) * den(462)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(8696),h0tab(:,8696),[58,5],[nMT,0],2,2,wf16(:,200),wf4(:,9))
  call Hloop_VA_Q(ntryL,G0H64(1),wf16(:,200),G0H4(343),m3h16x4(:,1460),heltab2x64(:,:,6293))
  call Hloop_A_Q(ntryL,G0H4(343),58,nMT,G1H4(1243),n2h4(3916))
  Gcoeff(:)%j = (c(18)*M(12,:)%j) * den(474)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(8697),h0tab(:,8697),[42,21],[nMT,0],2,2,wf8(:,178),wf8(:,39))
  call Hloop_VA_Q(ntryL,G0H64(1),wf8(:,178),G0H8(208),m3h8x8(:,1243),heltab2x64(:,:,6294))
  call Hloop_A_Q(ntryL,G0H8(208),42,nMT,G1H8(388),n2h8(2989))
  Gcoeff(:)%j = (c(18)*M(12,:)%j) * den(1023)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(8698),h0tab(:,8698),[53,10],[nMT,0],2,2,wf16(:,271),wf4(:,15))
  call Hloop_VQ_A(ntryL,G0H64(1),wf16(:,271),G0H4(343),m3h16x4(:,1461),heltab2x64(:,:,6295))
  call Hloop_Q_A(ntryL,G0H4(343),53,nMT,G1H4(1239),n2h4(3917))
  Gcoeff(:)%j = (c(18)*M(10,:)%j) * den(475)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(8699),h0tab(:,8699),[37,26],[nMT,0],2,2,wf8(:,176),wf8(:,42))
  call Hloop_VQ_A(ntryL,G0H64(1),wf8(:,176),G0H8(208),m3h8x8(:,1244),heltab2x64(:,:,6296))
  call Hloop_Q_A(ntryL,G0H8(208),37,nMT,G1H8(311),n2h8(2990))
  Gcoeff(:)%j = (c(18)*M(10,:)%j) * den(1024)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(8700),h0tab(:,8700),[53,10],[nMT,0],2,2,wf16(:,276),wf4(:,15))
  call Hloop_VQ_A(ntryL,G0H64(1),wf16(:,276),G0H4(343),m3h16x4(:,1462),heltab2x64(:,:,6297))
  call Hloop_Q_A(ntryL,G0H4(343),53,nMT,G1H4(1242),n2h4(3918))
  Gcoeff(:)%j = (c(18)*M(10,:)%j) * den(1025)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(8701),h0tab(:,8701),[58,5],[nMT,0],2,2,wf16(:,326),wf4(:,9))
  call Hloop_VA_Q(ntryL,G0H64(1),wf16(:,326),G0H4(343),m3h16x4(:,1463),heltab2x64(:,:,6298))
  call Hloop_A_Q(ntryL,G0H4(343),58,nMT,G1H4(1251),n2h4(3919))
  Gcoeff(:)%j = (c(18)*M(12,:)%j) * den(1026)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(8702),h0tab(:,8702),[58,5],[nMT,0],2,2,wf16(:,330),wf4(:,9))
  call Hloop_VA_Q(ntryL,G0H64(1),wf16(:,330),G0H4(343),m3h16x4(:,1464),heltab2x64(:,:,6299))
  call Hloop_A_Q(ntryL,G0H4(343),58,nMT,G1H4(1252),n2h4(3920))
  Gcoeff(:)%j = (c(24)*(M(16,:)%j-M(18,:)%j)) * den(483)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(8703),h0tab(:,8703),[40,23],[0,0],2,2,wf4(:,6),wf16(:,23))
  call Hloop_QV_A(ntryL,G0H64(1),wf4(:,6),G0H16(355),m3h4x16(:,1060),heltab2x64(:,:,6300))
  call Hloop_Q_A(ntryL,G0H16(355),40,0,G1H16(1069),n2h16(1801))
  Gcoeff(:)%j = (c(22)*(M(16,:)%j-M(18,:)%j)) * den(483)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(8704),h0tab(:,8704),[40,23],[nMT,nMT],2,2,wf4(:,6),wf16(:,23))
  call Hloop_QV_A(ntryL,G0H64(1),wf4(:,6),G0H16(355),m3h4x16(:,1061),heltab2x64(:,:,6301))
  call Hloop_Q_A(ntryL,G0H16(355),40,nMT,G1H16(1070),n2h16(1802))
  Gcoeff(:)%j = (c(24)*(M(16,:)%j-M(18,:)%j)) * den(483)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(8705),h0tab(:,8705),[40,23],[0,0],2,2,wf4(:,6),wf16(:,23))
  call Hloop_QV_A(ntryL,G0H64(1),wf4(:,6),G0H16(355),m3h4x16(:,1062),heltab2x64(:,:,6302))
  call Hloop_Q_A(ntryL,G0H16(355),40,0,G1H16(1072),n2h16(1803))
  Gcoeff(:)%j = (c(22)*(M(16,:)%j-M(18,:)%j)) * den(483)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(8706),h0tab(:,8706),[40,23],[nMB,nMB],2,2,wf4(:,6),wf16(:,23))
  call Hloop_QV_A(ntryL,G0H64(1),wf4(:,6),G0H16(355),m3h4x16(:,1063),heltab2x64(:,:,6303))
  call Hloop_Q_A(ntryL,G0H16(355),40,nMB,G1H16(1073),n2h16(1804))
  Gcoeff(:)%j = (c(10)*(M(16,:)%j-M(18,:)%j)) * den(483)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(8707),h0tab(:,8707),[40,23],[0,0],2,2,wf4(:,6),wf16(:,23))
  call Hloop_CV_D(ntryL,G0H64(1),0,wf4(:,6),40,G1H16(1074),m3h4x16(:,1064),heltab2x64(:,:,6304))
  Gcoeff(:)%j = (c(4)*(-M(16,:)%j+M(18,:)%j)) * den(483)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(8708),h0tab(:,8708),[40,23],[0,0],2,2,wf4(:,6),wf16(:,23))
  call Hloop_UV_W(ntryL,G0H64(1),0,wf4(:,6),40,G1H16(1075),m3h4x16(:,1065),heltab2x64(:,:,6305))
  Gcoeff(:)%j = (c(8)*(-M(16,:)%j+M(18,:)%j)) * den(481)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(8709),h0tab(:,8709),[45,18],[nMT,0],2,2,wf16(:,206),wf4(:,19))
  call Hloop_VQ_A(ntryL,G0H64(1),wf16(:,206),G0H4(343),m3h16x4(:,1465),heltab2x64(:,:,6306))
  call Hloop_Q_A(ntryL,G0H4(343),45,nMT,G1H4(1253),n2h4(3921))
  Gcoeff(:)%j = (c(8)*(-M(16,:)%j+M(18,:)%j)) * den(478)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(8710),h0tab(:,8710),[58,5],[nMT,0],2,2,wf16(:,204),wf4(:,9))
  call Hloop_VA_Q(ntryL,G0H64(1),wf16(:,204),G0H4(343),m3h16x4(:,1466),heltab2x64(:,:,6307))
  call Hloop_A_Q(ntryL,G0H4(343),58,nMT,G1H4(5),n2h4(3922))
  Gcoeff(:)%j = (c(18)*M(18,:)%j) * den(489)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(8711),h0tab(:,8711),[50,13],[nMT,0],2,2,wf8(:,185),wf8(:,45))
  call Hloop_VA_Q(ntryL,G0H64(1),wf8(:,185),G0H8(208),m3h8x8(:,1245),heltab2x64(:,:,6308))
  call Hloop_A_Q(ntryL,G0H8(208),50,nMT,G1H8(247),n2h8(2991))
  Gcoeff(:)%j = (c(18)*M(18,:)%j) * den(1027)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(8712),h0tab(:,8712),[45,18],[nMT,0],2,2,wf16(:,266),wf4(:,19))
  call Hloop_VQ_A(ntryL,G0H64(1),wf16(:,266),G0H4(343),m3h16x4(:,1467),heltab2x64(:,:,6309))
  call Hloop_Q_A(ntryL,G0H4(343),45,nMT,G1H4(1263),n2h4(3923))
  Gcoeff(:)%j = (c(18)*M(16,:)%j) * den(490)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(8713),h0tab(:,8713),[37,26],[nMT,0],2,2,wf8(:,176),wf8(:,47))
  call Hloop_VQ_A(ntryL,G0H64(1),wf8(:,176),G0H8(208),m3h8x8(:,1246),heltab2x64(:,:,6310))
  call Hloop_Q_A(ntryL,G0H8(208),37,nMT,G1H8(38),n2h8(2992))
  Gcoeff(:)%j = (c(18)*M(16,:)%j) * den(1028)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(8714),h0tab(:,8714),[45,18],[nMT,0],2,2,wf16(:,274),wf4(:,19))
  call Hloop_VQ_A(ntryL,G0H64(1),wf16(:,274),G0H4(343),m3h16x4(:,1468),heltab2x64(:,:,6311))
  call Hloop_Q_A(ntryL,G0H4(343),45,nMT,G1H4(1259),n2h4(3924))
  Gcoeff(:)%j = (c(18)*M(16,:)%j) * den(1029)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(8715),h0tab(:,8715),[58,5],[nMT,0],2,2,wf16(:,382),wf4(:,9))
  call Hloop_VA_Q(ntryL,G0H64(1),wf16(:,382),G0H4(343),m3h16x4(:,1469),heltab2x64(:,:,6312))
  call Hloop_A_Q(ntryL,G0H4(343),58,nMT,G1H4(1264),n2h4(3925))
  Gcoeff(:)%j = (c(18)*M(18,:)%j) * den(1030)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(8716),h0tab(:,8716),[58,5],[nMT,0],2,2,wf16(:,386),wf4(:,9))
  call Hloop_VA_Q(ntryL,G0H64(1),wf16(:,386),G0H4(343),m3h16x4(:,1470),heltab2x64(:,:,6313))
  call Hloop_A_Q(ntryL,G0H4(343),58,nMT,G1H4(1267),n2h4(3926))
  Gcoeff(:)%j = (c(24)*(M(22,:)%j-M(24,:)%j)) * den(498)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(8717),h0tab(:,8717),[39,24],[0,0],2,2,wf16(:,24),wf4(:,5))
  call Hloop_QV_A(ntryL,G0H64(1),wf16(:,24),G0H4(343),m3h16x4(:,1471),heltab2x64(:,:,6314))
  call Hloop_Q_A(ntryL,G0H4(343),39,0,G1H4(6),n2h4(3927))
  Gcoeff(:)%j = (c(22)*(M(22,:)%j-M(24,:)%j)) * den(498)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(8718),h0tab(:,8718),[39,24],[nMT,nMT],2,2,wf16(:,24),wf4(:,5))
  call Hloop_QV_A(ntryL,G0H64(1),wf16(:,24),G0H4(343),m3h16x4(:,1472),heltab2x64(:,:,6315))
  call Hloop_Q_A(ntryL,G0H4(343),39,nMT,G1H4(1273),n2h4(3928))
  Gcoeff(:)%j = (c(24)*(M(22,:)%j-M(24,:)%j)) * den(498)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(8719),h0tab(:,8719),[39,24],[0,0],2,2,wf16(:,24),wf4(:,5))
  call Hloop_QV_A(ntryL,G0H64(1),wf16(:,24),G0H4(343),m3h16x4(:,1473),heltab2x64(:,:,6316))
  call Hloop_Q_A(ntryL,G0H4(343),39,0,G1H4(1278),n2h4(3929))
  Gcoeff(:)%j = (c(22)*(M(22,:)%j-M(24,:)%j)) * den(498)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(8720),h0tab(:,8720),[39,24],[nMB,nMB],2,2,wf16(:,24),wf4(:,5))
  call Hloop_QV_A(ntryL,G0H64(1),wf16(:,24),G0H4(343),m3h16x4(:,1474),heltab2x64(:,:,6317))
  call Hloop_Q_A(ntryL,G0H4(343),39,nMB,G1H4(1274),n2h4(3930))
  Gcoeff(:)%j = (c(10)*(M(22,:)%j-M(24,:)%j)) * den(498)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(8721),h0tab(:,8721),[39,24],[0,0],2,2,wf16(:,24),wf4(:,5))
  call Hloop_CV_D(ntryL,G0H64(1),0,wf16(:,24),39,G1H4(1283),m3h16x4(:,1475),heltab2x64(:,:,6318))
  Gcoeff(:)%j = (c(4)*(-M(22,:)%j+M(24,:)%j)) * den(498)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(8722),h0tab(:,8722),[39,24],[0,0],2,2,wf16(:,24),wf4(:,5))
  call Hloop_UV_W(ntryL,G0H64(1),0,wf16(:,24),39,G1H4(1284),m3h16x4(:,1476),heltab2x64(:,:,6319))
  Gcoeff(:)%j = (c(8)*(-M(22,:)%j+M(24,:)%j)) * den(496)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(8723),h0tab(:,8723),[34,29],[0,nMT],2,2,wf4(:,23),wf16(:,210))
  call Hloop_QA_V(ntryL,G0H64(1),wf4(:,23),G0H16(355),m3h4x16(:,1066),heltab2x64(:,:,6320))
  Gcoeff(:)%j = (c(8)*(-M(22,:)%j+M(24,:)%j)) * den(493)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(8724),h0tab(:,8724),[58,5],[nMT,0],2,2,wf16(:,208),wf4(:,9))
  call Hloop_VA_Q(ntryL,G0H64(1),wf16(:,208),G0H4(343),m3h16x4(:,1477),heltab2x64(:,:,6321))
  call Hloop_A_Q(ntryL,G0H4(343),58,nMT,G1H4(1289),n2h4(3931))
  Gcoeff(:)%j = (c(28)*(M(10,:)%j-M(16,:)%j-M(22,:)%j+M(24,:)%j)) * den(1031)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(8725),h0tab(:,8725),[39,24],[0,0],2,2,wf16(:,261),wf4(:,5))
  call Hloop_QV_A(ntryL,G0H64(1),wf16(:,261),G0H4(343),m3h16x4(:,1478),heltab2x64(:,:,6322))
  call Hloop_Q_A(ntryL,G0H4(343),39,0,G1H4(1290),n2h4(3932))
  Gcoeff(:)%j = (c(26)*(M(10,:)%j-M(16,:)%j-M(22,:)%j+M(24,:)%j)) * den(1031)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(8726),h0tab(:,8726),[39,24],[nMT,nMT],2,2,wf16(:,261),wf4(:,5))
  call Hloop_QV_A(ntryL,G0H64(1),wf16(:,261),G0H4(343),m3h16x4(:,1479),heltab2x64(:,:,6323))
  call Hloop_Q_A(ntryL,G0H4(343),39,nMT,G1H4(1293),n2h4(3933))
  Gcoeff(:)%j = (c(28)*(M(10,:)%j-M(16,:)%j-M(22,:)%j+M(24,:)%j)) * den(1031)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(8727),h0tab(:,8727),[39,24],[0,0],2,2,wf16(:,261),wf4(:,5))
  call Hloop_QV_A(ntryL,G0H64(1),wf16(:,261),G0H4(343),m3h16x4(:,1480),heltab2x64(:,:,6324))
  call Hloop_Q_A(ntryL,G0H4(343),39,0,G1H4(1295),n2h4(3934))
  Gcoeff(:)%j = (c(26)*(M(10,:)%j-M(16,:)%j-M(22,:)%j+M(24,:)%j)) * den(1031)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(8728),h0tab(:,8728),[39,24],[nMB,nMB],2,2,wf16(:,261),wf4(:,5))
  call Hloop_QV_A(ntryL,G0H64(1),wf16(:,261),G0H4(343),m3h16x4(:,1481),heltab2x64(:,:,6325))
  call Hloop_Q_A(ntryL,G0H4(343),39,nMB,G1H4(1299),n2h4(3935))
  Gcoeff(:)%j = (c(20)*(M(10,:)%j-M(16,:)%j-M(22,:)%j+M(24,:)%j)) * den(1031)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(8729),h0tab(:,8729),[39,24],[0,0],2,2,wf16(:,261),wf4(:,5))
  call Hloop_CV_D(ntryL,G0H64(1),0,wf16(:,261),39,G1H4(1300),m3h16x4(:,1482),heltab2x64(:,:,6326))
  Gcoeff(:)%j = (c(14)*(-M(10,:)%j+M(16,:)%j+M(22,:)%j-M(24,:)%j)) * den(1031)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(8730),h0tab(:,8730),[39,24],[0,0],2,2,wf16(:,261),wf4(:,5))
  call Hloop_UV_W(ntryL,G0H64(1),0,wf16(:,261),39,G1H4(1305),m3h16x4(:,1483),heltab2x64(:,:,6327))
  Gcoeff(:)%j = (c(28)*(-M(10,:)%j+M(16,:)%j+M(22,:)%j-M(24,:)%j)) * den(502)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(8731),h0tab(:,8731),[56,7],[0,0],2,2,wf8(:,29),wf8(:,17))
  call Hloop_QV_A(ntryL,G0H64(1),wf8(:,29),G0H8(208),m3h8x8(:,1247),heltab2x64(:,:,6328))
  call Hloop_Q_A(ntryL,G0H8(208),56,0,G1H8(894),n2h8(2993))
  Gcoeff(:)%j = (c(26)*(-M(10,:)%j+M(16,:)%j+M(22,:)%j-M(24,:)%j)) * den(502)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(8732),h0tab(:,8732),[56,7],[nMT,nMT],2,2,wf8(:,29),wf8(:,17))
  call Hloop_QV_A(ntryL,G0H64(1),wf8(:,29),G0H8(208),m3h8x8(:,1248),heltab2x64(:,:,6329))
  call Hloop_Q_A(ntryL,G0H8(208),56,nMT,G1H8(819),n2h8(2994))
  Gcoeff(:)%j = (c(28)*(-M(10,:)%j+M(16,:)%j+M(22,:)%j-M(24,:)%j)) * den(502)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(8733),h0tab(:,8733),[56,7],[0,0],2,2,wf8(:,29),wf8(:,17))
  call Hloop_QV_A(ntryL,G0H64(1),wf8(:,29),G0H8(208),m3h8x8(:,1249),heltab2x64(:,:,6330))
  call Hloop_Q_A(ntryL,G0H8(208),56,0,G1H8(783),n2h8(2995))
  Gcoeff(:)%j = (c(26)*(-M(10,:)%j+M(16,:)%j+M(22,:)%j-M(24,:)%j)) * den(502)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(8734),h0tab(:,8734),[56,7],[nMB,nMB],2,2,wf8(:,29),wf8(:,17))
  call Hloop_QV_A(ntryL,G0H64(1),wf8(:,29),G0H8(208),m3h8x8(:,1250),heltab2x64(:,:,6331))
  call Hloop_Q_A(ntryL,G0H8(208),56,nMB,G1H8(754),n2h8(2996))
  Gcoeff(:)%j = (c(20)*(-M(10,:)%j+M(16,:)%j+M(22,:)%j-M(24,:)%j)) * den(502)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(8735),h0tab(:,8735),[56,7],[0,0],2,2,wf8(:,29),wf8(:,17))
  call Hloop_CV_D(ntryL,G0H64(1),0,wf8(:,29),56,G1H8(441),m3h8x8(:,1251),heltab2x64(:,:,6332))
  Gcoeff(:)%j = (c(14)*(M(10,:)%j-M(16,:)%j-M(22,:)%j+M(24,:)%j)) * den(502)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(8736),h0tab(:,8736),[56,7],[0,0],2,2,wf8(:,29),wf8(:,17))
  call Hloop_UV_W(ntryL,G0H64(1),0,wf8(:,29),56,G1H8(423),m3h8x8(:,1252),heltab2x64(:,:,6333))
  Gcoeff(:)%j = (c(8)*(-M(10,:)%j+M(16,:)%j)) * den(503)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(8737),h0tab(:,8737),[37,26],[nMT,0],2,2,wf8(:,176),wf8(:,49))
  call Hloop_VQ_A(ntryL,G0H64(1),wf8(:,176),G0H8(208),m3h8x8(:,1253),heltab2x64(:,:,6334))
  call Hloop_Q_A(ntryL,G0H8(208),37,nMT,G1H8(418),n2h8(2997))
  Gcoeff(:)%j = (c(24)*(M(10,:)%j-M(16,:)%j)) * den(1032)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(8738),h0tab(:,8738),[39,24],[0,0],2,2,wf16(:,272),wf4(:,5))
  call Hloop_QV_A(ntryL,G0H64(1),wf16(:,272),G0H4(343),m3h16x4(:,1484),heltab2x64(:,:,6335))
  call Hloop_Q_A(ntryL,G0H4(343),39,0,G1H4(1306),n2h4(3936))
  Gcoeff(:)%j = (c(22)*(M(10,:)%j-M(16,:)%j)) * den(1032)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(8739),h0tab(:,8739),[39,24],[nMT,nMT],2,2,wf16(:,272),wf4(:,5))
  call Hloop_QV_A(ntryL,G0H64(1),wf16(:,272),G0H4(343),m3h16x4(:,1485),heltab2x64(:,:,6336))
  call Hloop_Q_A(ntryL,G0H4(343),39,nMT,G1H4(1309),n2h4(3937))
  Gcoeff(:)%j = (c(24)*(M(10,:)%j-M(16,:)%j)) * den(1032)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(8740),h0tab(:,8740),[39,24],[0,0],2,2,wf16(:,272),wf4(:,5))
  call Hloop_QV_A(ntryL,G0H64(1),wf16(:,272),G0H4(343),m3h16x4(:,1486),heltab2x64(:,:,6337))
  call Hloop_Q_A(ntryL,G0H4(343),39,0,G1H4(1311),n2h4(3938))
  Gcoeff(:)%j = (c(22)*(M(10,:)%j-M(16,:)%j)) * den(1032)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(8741),h0tab(:,8741),[39,24],[nMB,nMB],2,2,wf16(:,272),wf4(:,5))
  call Hloop_QV_A(ntryL,G0H64(1),wf16(:,272),G0H4(343),m3h16x4(:,1487),heltab2x64(:,:,6338))
  call Hloop_Q_A(ntryL,G0H4(343),39,nMB,G1H4(1315),n2h4(3939))
  Gcoeff(:)%j = (c(10)*(M(10,:)%j-M(16,:)%j)) * den(1032)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(8742),h0tab(:,8742),[39,24],[0,0],2,2,wf16(:,272),wf4(:,5))
  call Hloop_CV_D(ntryL,G0H64(1),0,wf16(:,272),39,G1H4(1316),m3h16x4(:,1488),heltab2x64(:,:,6339))
  Gcoeff(:)%j = (c(4)*(-M(10,:)%j+M(16,:)%j)) * den(1032)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(8743),h0tab(:,8743),[39,24],[0,0],2,2,wf16(:,272),wf4(:,5))
  call Hloop_UV_W(ntryL,G0H64(1),0,wf16(:,272),39,G1H4(1321),m3h16x4(:,1489),heltab2x64(:,:,6340))
  Gcoeff(:)%j = (c(8)*(-M(10,:)%j+M(16,:)%j)) * den(1033)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(8744),h0tab(:,8744),[58,5],[nMT,0],2,2,wf16(:,422),wf4(:,9))
  call Hloop_VA_Q(ntryL,G0H64(1),wf16(:,422),G0H4(343),m3h16x4(:,1490),heltab2x64(:,:,6341))
  call Hloop_A_Q(ntryL,G0H4(343),58,nMT,G1H4(1322),n2h4(3940))
  Gcoeff(:)%j = (c(18)*(M(10,:)%j-M(16,:)%j-M(22,:)%j+M(24,:)%j)) * den(1034)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(8745),h0tab(:,8745),[58,5],[nMT,0],2,2,wf16(:,424),wf4(:,9))
  call Hloop_VA_Q(ntryL,G0H64(1),wf16(:,424),G0H4(343),m3h16x4(:,1491),heltab2x64(:,:,6342))
  call Hloop_A_Q(ntryL,G0H4(343),58,nMT,G1H4(1325),n2h4(3941))
  Gcoeff(:)%j = (c(18)*M(24,:)%j) * den(510)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(8746),h0tab(:,8746),[50,13],[nMT,0],2,2,wf8(:,187),wf8(:,45))
  call Hloop_VA_Q(ntryL,G0H64(1),wf8(:,187),G0H8(208),m3h8x8(:,1254),heltab2x64(:,:,6343))
  call Hloop_A_Q(ntryL,G0H8(208),50,nMT,G1H8(170),n2h8(2998))
  Gcoeff(:)%j = (c(18)*M(24,:)%j) * den(1035)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(8747),h0tab(:,8747),[34,29],[0,nMT],2,2,wf4(:,23),wf16(:,264))
  call Hloop_QA_V(ntryL,G0H64(1),wf4(:,23),G0H16(356),m3h4x16(:,1067),heltab2x64(:,:,6344))
  Gcoeff(:)%j = (c(18)*M(22,:)%j) * den(511)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(8748),h0tab(:,8748),[42,21],[0,nMT],2,2,wf8(:,52),wf8(:,39))
  call Hloop_QA_V(ntryL,G0H64(1),wf8(:,52),G0H8(208),m3h8x8(:,1255),heltab2x64(:,:,6345))
  Gcoeff(:)%j = (c(18)*M(22,:)%j) * den(1036)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(8749),h0tab(:,8749),[34,29],[0,nMT],2,2,wf4(:,23),wf16(:,269))
  call Hloop_QA_V(ntryL,G0H64(1),wf4(:,23),G0H16(357),m3h4x16(:,1068),heltab2x64(:,:,6346))
  Gcoeff(:)%j = (c(18)*M(22,:)%j) * den(1037)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(8750),h0tab(:,8750),[58,5],[nMT,0],2,2,wf16(:,458),wf4(:,9))
  call Hloop_VA_Q(ntryL,G0H64(1),wf16(:,458),G0H4(343),m3h16x4(:,1492),heltab2x64(:,:,6347))
  call Hloop_A_Q(ntryL,G0H4(343),58,nMT,G1H4(1327),n2h4(3942))
  Gcoeff(:)%j = (c(18)*M(24,:)%j) * den(1038)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(8751),h0tab(:,8751),[58,5],[nMT,0],2,2,wf16(:,462),wf4(:,9))
  call Hloop_VA_Q(ntryL,G0H64(1),wf16(:,462),G0H4(343),m3h16x4(:,1493),heltab2x64(:,:,6348))
  call Hloop_A_Q(ntryL,G0H4(343),58,nMT,G1H4(1342),n2h4(3943))
  Gcoeff(:)%j = (c(28)*(M(12,:)%j-M(16,:)%j+M(18,:)%j-M(22,:)%j)) * den(1039)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(8752),h0tab(:,8752),[40,23],[0,0],2,2,wf4(:,6),wf16(:,260))
  call Hloop_QV_A(ntryL,G0H64(1),wf4(:,6),G0H16(358),m3h4x16(:,1069),heltab2x64(:,:,6349))
  call Hloop_Q_A(ntryL,G0H16(358),40,0,G1H16(1077),n2h16(1805))
  Gcoeff(:)%j = (c(26)*(M(12,:)%j-M(16,:)%j+M(18,:)%j-M(22,:)%j)) * den(1039)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(8753),h0tab(:,8753),[40,23],[nMT,nMT],2,2,wf4(:,6),wf16(:,260))
  call Hloop_QV_A(ntryL,G0H64(1),wf4(:,6),G0H16(358),m3h4x16(:,1070),heltab2x64(:,:,6350))
  call Hloop_Q_A(ntryL,G0H16(358),40,nMT,G1H16(1078),n2h16(1806))
  Gcoeff(:)%j = (c(28)*(M(12,:)%j-M(16,:)%j+M(18,:)%j-M(22,:)%j)) * den(1039)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(8754),h0tab(:,8754),[40,23],[0,0],2,2,wf4(:,6),wf16(:,260))
  call Hloop_QV_A(ntryL,G0H64(1),wf4(:,6),G0H16(358),m3h4x16(:,1071),heltab2x64(:,:,6351))
  call Hloop_Q_A(ntryL,G0H16(358),40,0,G1H16(1079),n2h16(1807))
  Gcoeff(:)%j = (c(26)*(M(12,:)%j-M(16,:)%j+M(18,:)%j-M(22,:)%j)) * den(1039)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(8755),h0tab(:,8755),[40,23],[nMB,nMB],2,2,wf4(:,6),wf16(:,260))
  call Hloop_QV_A(ntryL,G0H64(1),wf4(:,6),G0H16(358),m3h4x16(:,1072),heltab2x64(:,:,6352))
  call Hloop_Q_A(ntryL,G0H16(358),40,nMB,G1H16(1080),n2h16(1808))
  Gcoeff(:)%j = (c(20)*(M(12,:)%j-M(16,:)%j+M(18,:)%j-M(22,:)%j)) * den(1039)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(8756),h0tab(:,8756),[40,23],[0,0],2,2,wf4(:,6),wf16(:,260))
  call Hloop_CV_D(ntryL,G0H64(1),0,wf4(:,6),40,G1H16(1082),m3h4x16(:,1073),heltab2x64(:,:,6353))
  Gcoeff(:)%j = (c(14)*(-M(12,:)%j+M(16,:)%j-M(18,:)%j+M(22,:)%j)) * den(1039)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(8757),h0tab(:,8757),[40,23],[0,0],2,2,wf4(:,6),wf16(:,260))
  call Hloop_UV_W(ntryL,G0H64(1),0,wf4(:,6),40,G1H16(1083),m3h4x16(:,1074),heltab2x64(:,:,6354))
  Gcoeff(:)%j = (c(28)*(M(12,:)%j-M(16,:)%j+M(18,:)%j-M(22,:)%j)) * den(515)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(8758),h0tab(:,8758),[56,7],[0,0],2,2,wf8(:,33),wf8(:,17))
  call Hloop_QV_A(ntryL,G0H64(1),wf8(:,33),G0H8(209),m3h8x8(:,1256),heltab2x64(:,:,6355))
  call Hloop_Q_A(ntryL,G0H8(209),56,0,G1H8(115),n2h8(2999))
  Gcoeff(:)%j = (c(26)*(M(12,:)%j-M(16,:)%j+M(18,:)%j-M(22,:)%j)) * den(515)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(8759),h0tab(:,8759),[56,7],[nMT,nMT],2,2,wf8(:,33),wf8(:,17))
  call Hloop_QV_A(ntryL,G0H64(1),wf8(:,33),G0H8(209),m3h8x8(:,1257),heltab2x64(:,:,6356))
  call Hloop_Q_A(ntryL,G0H8(209),56,nMT,G1H8(1259),n2h8(3000))
  Gcoeff(:)%j = (c(28)*(M(12,:)%j-M(16,:)%j+M(18,:)%j-M(22,:)%j)) * den(515)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(8760),h0tab(:,8760),[56,7],[0,0],2,2,wf8(:,33),wf8(:,17))
  call Hloop_QV_A(ntryL,G0H64(1),wf8(:,33),G0H8(209),m3h8x8(:,1258),heltab2x64(:,:,6357))
  call Hloop_Q_A(ntryL,G0H8(209),56,0,G1H8(257),n2h8(3001))
  Gcoeff(:)%j = (c(26)*(M(12,:)%j-M(16,:)%j+M(18,:)%j-M(22,:)%j)) * den(515)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(8761),h0tab(:,8761),[56,7],[nMB,nMB],2,2,wf8(:,33),wf8(:,17))
  call Hloop_QV_A(ntryL,G0H64(1),wf8(:,33),G0H8(209),m3h8x8(:,1259),heltab2x64(:,:,6358))
  call Hloop_Q_A(ntryL,G0H8(209),56,nMB,G1H8(8),n2h8(3002))
  Gcoeff(:)%j = (c(20)*(M(12,:)%j-M(16,:)%j+M(18,:)%j-M(22,:)%j)) * den(515)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(8762),h0tab(:,8762),[56,7],[0,0],2,2,wf8(:,33),wf8(:,17))
  call Hloop_CV_D(ntryL,G0H64(1),0,wf8(:,33),56,G1H8(538),m3h8x8(:,1260),heltab2x64(:,:,6359))
  Gcoeff(:)%j = (c(14)*(-M(12,:)%j+M(16,:)%j-M(18,:)%j+M(22,:)%j)) * den(515)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(8763),h0tab(:,8763),[56,7],[0,0],2,2,wf8(:,33),wf8(:,17))
  call Hloop_UV_W(ntryL,G0H64(1),0,wf8(:,33),56,G1H8(526),m3h8x8(:,1261),heltab2x64(:,:,6360))
  Gcoeff(:)%j = (c(8)*(-M(12,:)%j+M(22,:)%j)) * den(516)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(8764),h0tab(:,8764),[42,21],[0,nMT],2,2,wf8(:,54),wf8(:,39))
  call Hloop_QA_V(ntryL,G0H64(1),wf8(:,54),G0H8(209),m3h8x8(:,1262),heltab2x64(:,:,6361))
  Gcoeff(:)%j = (c(24)*(M(12,:)%j-M(22,:)%j)) * den(1040)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(8765),h0tab(:,8765),[40,23],[0,0],2,2,wf4(:,6),wf16(:,267))
  call Hloop_QV_A(ntryL,G0H64(1),wf4(:,6),G0H16(358),m3h4x16(:,1075),heltab2x64(:,:,6362))
  call Hloop_Q_A(ntryL,G0H16(358),40,0,G1H16(1084),n2h16(1809))
  Gcoeff(:)%j = (c(22)*(M(12,:)%j-M(22,:)%j)) * den(1040)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(8766),h0tab(:,8766),[40,23],[nMT,nMT],2,2,wf4(:,6),wf16(:,267))
  call Hloop_QV_A(ntryL,G0H64(1),wf4(:,6),G0H16(358),m3h4x16(:,1076),heltab2x64(:,:,6363))
  call Hloop_Q_A(ntryL,G0H16(358),40,nMT,G1H16(1085),n2h16(1810))
  Gcoeff(:)%j = (c(24)*(M(12,:)%j-M(22,:)%j)) * den(1040)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(8767),h0tab(:,8767),[40,23],[0,0],2,2,wf4(:,6),wf16(:,267))
  call Hloop_QV_A(ntryL,G0H64(1),wf4(:,6),G0H16(358),m3h4x16(:,1077),heltab2x64(:,:,6364))
  call Hloop_Q_A(ntryL,G0H16(358),40,0,G1H16(1087),n2h16(1811))
  Gcoeff(:)%j = (c(22)*(M(12,:)%j-M(22,:)%j)) * den(1040)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(8768),h0tab(:,8768),[40,23],[nMB,nMB],2,2,wf4(:,6),wf16(:,267))
  call Hloop_QV_A(ntryL,G0H64(1),wf4(:,6),G0H16(358),m3h4x16(:,1078),heltab2x64(:,:,6365))
  call Hloop_Q_A(ntryL,G0H16(358),40,nMB,G1H16(1088),n2h16(1812))
  Gcoeff(:)%j = (c(10)*(M(12,:)%j-M(22,:)%j)) * den(1040)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(8769),h0tab(:,8769),[40,23],[0,0],2,2,wf4(:,6),wf16(:,267))
  call Hloop_CV_D(ntryL,G0H64(1),0,wf4(:,6),40,G1H16(1089),m3h4x16(:,1079),heltab2x64(:,:,6366))
  Gcoeff(:)%j = (c(4)*(-M(12,:)%j+M(22,:)%j)) * den(1040)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(8770),h0tab(:,8770),[40,23],[0,0],2,2,wf4(:,6),wf16(:,267))
  call Hloop_UV_W(ntryL,G0H64(1),0,wf4(:,6),40,G1H16(1090),m3h4x16(:,1080),heltab2x64(:,:,6367))
  Gcoeff(:)%j = (c(8)*(-M(12,:)%j+M(22,:)%j)) * den(1041)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(8771),h0tab(:,8771),[58,5],[nMT,0],2,2,wf16(:,498),wf4(:,9))
  call Hloop_VA_Q(ntryL,G0H64(1),wf16(:,498),G0H4(343),m3h16x4(:,1494),heltab2x64(:,:,6368))
  call Hloop_A_Q(ntryL,G0H4(343),58,nMT,G1H4(1338),n2h4(3944))
  Gcoeff(:)%j = (c(18)*(-M(12,:)%j+M(16,:)%j-M(18,:)%j+M(22,:)%j)) * den(1042)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(8772),h0tab(:,8772),[58,5],[nMT,0],2,2,wf16(:,500),wf4(:,9))
  call Hloop_VA_Q(ntryL,G0H64(1),wf16(:,500),G0H4(343),m3h16x4(:,1495),heltab2x64(:,:,6369))
  call Hloop_A_Q(ntryL,G0H4(343),58,nMT,G1H4(1341),n2h4(3945))
  Gcoeff(:)%j = (c(28)*(-M(10,:)%j+M(12,:)%j+M(18,:)%j-M(24,:)%j)) * den(1043)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(8773),h0tab(:,8773),[48,15],[0,0],2,2,wf4(:,7),wf16(:,259))
  call Hloop_QV_A(ntryL,G0H64(1),wf4(:,7),G0H16(358),m3h4x16(:,1081),heltab2x64(:,:,6370))
  call Hloop_Q_A(ntryL,G0H16(358),48,0,G1H16(1092),n2h16(1813))
  Gcoeff(:)%j = (c(26)*(-M(10,:)%j+M(12,:)%j+M(18,:)%j-M(24,:)%j)) * den(1043)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(8774),h0tab(:,8774),[48,15],[nMT,nMT],2,2,wf4(:,7),wf16(:,259))
  call Hloop_QV_A(ntryL,G0H64(1),wf4(:,7),G0H16(358),m3h4x16(:,1082),heltab2x64(:,:,6371))
  call Hloop_Q_A(ntryL,G0H16(358),48,nMT,G1H16(1093),n2h16(1814))
  Gcoeff(:)%j = (c(28)*(-M(10,:)%j+M(12,:)%j+M(18,:)%j-M(24,:)%j)) * den(1043)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(8775),h0tab(:,8775),[48,15],[0,0],2,2,wf4(:,7),wf16(:,259))
  call Hloop_QV_A(ntryL,G0H64(1),wf4(:,7),G0H16(358),m3h4x16(:,1083),heltab2x64(:,:,6372))
  call Hloop_Q_A(ntryL,G0H16(358),48,0,G1H16(1094),n2h16(1815))
  Gcoeff(:)%j = (c(26)*(-M(10,:)%j+M(12,:)%j+M(18,:)%j-M(24,:)%j)) * den(1043)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(8776),h0tab(:,8776),[48,15],[nMB,nMB],2,2,wf4(:,7),wf16(:,259))
  call Hloop_QV_A(ntryL,G0H64(1),wf4(:,7),G0H16(358),m3h4x16(:,1084),heltab2x64(:,:,6373))
  call Hloop_Q_A(ntryL,G0H16(358),48,nMB,G1H16(1095),n2h16(1816))
  Gcoeff(:)%j = (c(20)*(-M(10,:)%j+M(12,:)%j+M(18,:)%j-M(24,:)%j)) * den(1043)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(8777),h0tab(:,8777),[48,15],[0,0],2,2,wf4(:,7),wf16(:,259))
  call Hloop_CV_D(ntryL,G0H64(1),0,wf4(:,7),48,G1H16(1097),m3h4x16(:,1085),heltab2x64(:,:,6374))
  Gcoeff(:)%j = (c(14)*(M(10,:)%j-M(12,:)%j-M(18,:)%j+M(24,:)%j)) * den(1043)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(8778),h0tab(:,8778),[48,15],[0,0],2,2,wf4(:,7),wf16(:,259))
  call Hloop_UV_W(ntryL,G0H64(1),0,wf4(:,7),48,G1H16(1098),m3h4x16(:,1086),heltab2x64(:,:,6375))
  Gcoeff(:)%j = (c(28)*(-M(10,:)%j+M(12,:)%j+M(18,:)%j-M(24,:)%j)) * den(520)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(8779),h0tab(:,8779),[56,7],[0,0],2,2,wf8(:,35),wf8(:,17))
  call Hloop_QV_A(ntryL,G0H64(1),wf8(:,35),G0H8(210),m3h8x8(:,1263),heltab2x64(:,:,6376))
  call Hloop_Q_A(ntryL,G0H8(210),56,0,G1H8(466),n2h8(3003))
  Gcoeff(:)%j = (c(26)*(-M(10,:)%j+M(12,:)%j+M(18,:)%j-M(24,:)%j)) * den(520)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(8780),h0tab(:,8780),[56,7],[nMT,nMT],2,2,wf8(:,35),wf8(:,17))
  call Hloop_QV_A(ntryL,G0H64(1),wf8(:,35),G0H8(210),m3h8x8(:,1264),heltab2x64(:,:,6377))
  call Hloop_Q_A(ntryL,G0H8(210),56,nMT,G1H8(103),n2h8(3004))
  Gcoeff(:)%j = (c(28)*(-M(10,:)%j+M(12,:)%j+M(18,:)%j-M(24,:)%j)) * den(520)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(8781),h0tab(:,8781),[56,7],[0,0],2,2,wf8(:,35),wf8(:,17))
  call Hloop_QV_A(ntryL,G0H64(1),wf8(:,35),G0H8(210),m3h8x8(:,1265),heltab2x64(:,:,6378))
  call Hloop_Q_A(ntryL,G0H8(210),56,0,G1H8(1024),n2h8(3005))
  Gcoeff(:)%j = (c(26)*(-M(10,:)%j+M(12,:)%j+M(18,:)%j-M(24,:)%j)) * den(520)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(8782),h0tab(:,8782),[56,7],[nMB,nMB],2,2,wf8(:,35),wf8(:,17))
  call Hloop_QV_A(ntryL,G0H64(1),wf8(:,35),G0H8(210),m3h8x8(:,1266),heltab2x64(:,:,6379))
  call Hloop_Q_A(ntryL,G0H8(210),56,nMB,G1H8(1281),n2h8(3006))
  Gcoeff(:)%j = (c(20)*(-M(10,:)%j+M(12,:)%j+M(18,:)%j-M(24,:)%j)) * den(520)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(8783),h0tab(:,8783),[56,7],[0,0],2,2,wf8(:,35),wf8(:,17))
  call Hloop_CV_D(ntryL,G0H64(1),0,wf8(:,35),56,G1H8(291),m3h8x8(:,1267),heltab2x64(:,:,6380))
  Gcoeff(:)%j = (c(14)*(M(10,:)%j-M(12,:)%j-M(18,:)%j+M(24,:)%j)) * den(520)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(8784),h0tab(:,8784),[56,7],[0,0],2,2,wf8(:,35),wf8(:,17))
  call Hloop_UV_W(ntryL,G0H64(1),0,wf8(:,35),56,G1H8(225),m3h8x8(:,1268),heltab2x64(:,:,6381))
  Gcoeff(:)%j = (c(24)*(M(18,:)%j-M(24,:)%j)) * den(1044)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(8785),h0tab(:,8785),[48,15],[0,0],2,2,wf4(:,7),wf16(:,262))
  call Hloop_QV_A(ntryL,G0H64(1),wf4(:,7),G0H16(358),m3h4x16(:,1087),heltab2x64(:,:,6382))
  call Hloop_Q_A(ntryL,G0H16(358),48,0,G1H16(1099),n2h16(1817))
  Gcoeff(:)%j = (c(22)*(M(18,:)%j-M(24,:)%j)) * den(1044)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(8786),h0tab(:,8786),[48,15],[nMT,nMT],2,2,wf4(:,7),wf16(:,262))
  call Hloop_QV_A(ntryL,G0H64(1),wf4(:,7),G0H16(358),m3h4x16(:,1088),heltab2x64(:,:,6383))
  call Hloop_Q_A(ntryL,G0H16(358),48,nMT,G1H16(1100),n2h16(1818))
  Gcoeff(:)%j = (c(24)*(M(18,:)%j-M(24,:)%j)) * den(1044)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(8787),h0tab(:,8787),[48,15],[0,0],2,2,wf4(:,7),wf16(:,262))
  call Hloop_QV_A(ntryL,G0H64(1),wf4(:,7),G0H16(358),m3h4x16(:,1089),heltab2x64(:,:,6384))
  call Hloop_Q_A(ntryL,G0H16(358),48,0,G1H16(1102),n2h16(1819))
  Gcoeff(:)%j = (c(22)*(M(18,:)%j-M(24,:)%j)) * den(1044)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(8788),h0tab(:,8788),[48,15],[nMB,nMB],2,2,wf4(:,7),wf16(:,262))
  call Hloop_QV_A(ntryL,G0H64(1),wf4(:,7),G0H16(358),m3h4x16(:,1090),heltab2x64(:,:,6385))
  call Hloop_Q_A(ntryL,G0H16(358),48,nMB,G1H16(1103),n2h16(1820))
  Gcoeff(:)%j = (c(10)*(M(18,:)%j-M(24,:)%j)) * den(1044)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(8789),h0tab(:,8789),[48,15],[0,0],2,2,wf4(:,7),wf16(:,262))
  call Hloop_CV_D(ntryL,G0H64(1),0,wf4(:,7),48,G1H16(1104),m3h4x16(:,1091),heltab2x64(:,:,6386))
  Gcoeff(:)%j = (c(4)*(-M(18,:)%j+M(24,:)%j)) * den(1044)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(8790),h0tab(:,8790),[48,15],[0,0],2,2,wf4(:,7),wf16(:,262))
  call Hloop_UV_W(ntryL,G0H64(1),0,wf4(:,7),48,G1H16(1105),m3h4x16(:,1092),heltab2x64(:,:,6387))
  Gcoeff(:)%j = (c(8)*(-M(18,:)%j+M(24,:)%j)) * den(521)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(8791),h0tab(:,8791),[50,13],[0,nMT],2,2,wf8(:,56),wf8(:,45))
  call Hloop_QA_V(ntryL,G0H64(1),wf8(:,56),G0H8(210),m3h8x8(:,1269),heltab2x64(:,:,6388))
  Gcoeff(:)%j = (c(8)*(-M(18,:)%j+M(24,:)%j)) * den(1045)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(8792),h0tab(:,8792),[58,5],[nMT,0],2,2,wf16(:,518),wf4(:,9))
  call Hloop_VA_Q(ntryL,G0H64(1),wf16(:,518),G0H4(343),m3h16x4(:,1496),heltab2x64(:,:,6389))
  call Hloop_A_Q(ntryL,G0H4(343),58,nMT,G1H4(1346),n2h4(3946))
  Gcoeff(:)%j = (c(18)*(M(10,:)%j-M(12,:)%j-M(18,:)%j+M(24,:)%j)) * den(1046)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(8793),h0tab(:,8793),[58,5],[nMT,0],2,2,wf16(:,520),wf4(:,9))
  call Hloop_VA_Q(ntryL,G0H64(1),wf16(:,520),G0H4(343),m3h16x4(:,1497),heltab2x64(:,:,6390))
  call Hloop_A_Q(ntryL,G0H4(343),58,nMT,G1H4(1347),n2h4(3947))
  Gcoeff(:)%j = (c(24)*(M(4,:)%j-M(6,:)%j)) * den(531)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(8794),h0tab(:,8794),[48,15],[0,0],2,2,wf4(:,7),wf16(:,25))
  call Hloop_QV_A(ntryL,G0H64(1),wf4(:,7),G0H16(358),m3h4x16(:,1093),heltab2x64(:,:,6391))
  call Hloop_Q_A(ntryL,G0H16(358),48,0,G1H16(1107),n2h16(1821))
  Gcoeff(:)%j = (c(22)*(M(4,:)%j-M(6,:)%j)) * den(531)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(8795),h0tab(:,8795),[48,15],[nMT,nMT],2,2,wf4(:,7),wf16(:,25))
  call Hloop_QV_A(ntryL,G0H64(1),wf4(:,7),G0H16(358),m3h4x16(:,1094),heltab2x64(:,:,6392))
  call Hloop_Q_A(ntryL,G0H16(358),48,nMT,G1H16(1108),n2h16(1822))
  Gcoeff(:)%j = (c(24)*(M(4,:)%j-M(6,:)%j)) * den(531)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(8796),h0tab(:,8796),[48,15],[0,0],2,2,wf4(:,7),wf16(:,25))
  call Hloop_QV_A(ntryL,G0H64(1),wf4(:,7),G0H16(358),m3h4x16(:,1095),heltab2x64(:,:,6393))
  call Hloop_Q_A(ntryL,G0H16(358),48,0,G1H16(1109),n2h16(1823))
  Gcoeff(:)%j = (c(22)*(M(4,:)%j-M(6,:)%j)) * den(531)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(8797),h0tab(:,8797),[48,15],[nMB,nMB],2,2,wf4(:,7),wf16(:,25))
  call Hloop_QV_A(ntryL,G0H64(1),wf4(:,7),G0H16(358),m3h4x16(:,1096),heltab2x64(:,:,6394))
  call Hloop_Q_A(ntryL,G0H16(358),48,nMB,G1H16(1110),n2h16(1824))
  Gcoeff(:)%j = (c(10)*(M(4,:)%j-M(6,:)%j)) * den(531)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(8798),h0tab(:,8798),[48,15],[0,0],2,2,wf4(:,7),wf16(:,25))
  call Hloop_CV_D(ntryL,G0H64(1),0,wf4(:,7),48,G1H16(1112),m3h4x16(:,1097),heltab2x64(:,:,6395))
  Gcoeff(:)%j = (c(4)*(-M(4,:)%j+M(6,:)%j)) * den(531)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(8799),h0tab(:,8799),[48,15],[0,0],2,2,wf4(:,7),wf16(:,25))
  call Hloop_UV_W(ntryL,G0H64(1),0,wf4(:,7),48,G1H16(1113),m3h4x16(:,1098),heltab2x64(:,:,6396))
  Gcoeff(:)%j = (c(8)*(-M(4,:)%j+M(6,:)%j)) * den(529)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(8800),h0tab(:,8800),[57,6],[nMT,0],2,2,wf16(:,214),wf4(:,11))
  call Hloop_VQ_A(ntryL,G0H64(1),wf16(:,214),G0H4(343),m3h16x4(:,1498),heltab2x64(:,:,6397))
  call Hloop_Q_A(ntryL,G0H4(343),57,nMT,G1H4(1348),n2h4(3948))
  Gcoeff(:)%j = (c(8)*(-M(4,:)%j+M(6,:)%j)) * den(526)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(8801),h0tab(:,8801),[54,9],[nMT,0],2,2,wf16(:,212),wf4(:,13))
  call Hloop_VA_Q(ntryL,G0H64(1),wf16(:,212),G0H4(343),m3h16x4(:,1499),heltab2x64(:,:,6398))
  call Hloop_A_Q(ntryL,G0H4(343),54,nMT,G1H4(1358),n2h4(3949))
  Gcoeff(:)%j = (c(18)*M(6,:)%j) * den(538)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(8802),h0tab(:,8802),[38,25],[nMT,0],2,2,wf8(:,197),wf8(:,59))
  call Hloop_VA_Q(ntryL,G0H64(1),wf8(:,197),G0H8(211),m3h8x8(:,1270),heltab2x64(:,:,6399))
  call Hloop_A_Q(ntryL,G0H8(211),38,nMT,G1H8(258),n2h8(3007))
  Gcoeff(:)%j = (c(18)*M(6,:)%j) * den(1047)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(8803),h0tab(:,8803),[57,6],[nMT,0],2,2,wf16(:,307),wf4(:,11))
  call Hloop_VQ_A(ntryL,G0H64(1),wf16(:,307),G0H4(343),m3h16x4(:,1500),heltab2x64(:,:,6400))
  call Hloop_Q_A(ntryL,G0H4(343),57,nMT,G1H4(1354),n2h4(3950))
  Gcoeff(:)%j = (c(18)*M(4,:)%j) * den(539)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(8804),h0tab(:,8804),[41,22],[nMT,0],2,2,wf8(:,195),wf8(:,62))
  call Hloop_VQ_A(ntryL,G0H64(1),wf8(:,195),G0H8(211),m3h8x8(:,1271),heltab2x64(:,:,6401))
  call Hloop_Q_A(ntryL,G0H8(211),41,nMT,G1H8(11),n2h8(3008))
  Gcoeff(:)%j = (c(18)*M(4,:)%j) * den(1048)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(8805),h0tab(:,8805),[57,6],[nMT,0],2,2,wf16(:,312),wf4(:,11))
  call Hloop_VQ_A(ntryL,G0H64(1),wf16(:,312),G0H4(343),m3h16x4(:,1501),heltab2x64(:,:,6402))
  call Hloop_Q_A(ntryL,G0H4(343),57,nMT,G1H4(1357),n2h4(3951))
  Gcoeff(:)%j = (c(18)*M(4,:)%j) * den(1049)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(8806),h0tab(:,8806),[54,9],[nMT,0],2,2,wf16(:,290),wf4(:,13))
  call Hloop_VA_Q(ntryL,G0H64(1),wf16(:,290),G0H4(343),m3h16x4(:,1502),heltab2x64(:,:,6403))
  call Hloop_A_Q(ntryL,G0H4(343),54,nMT,G1H4(1362),n2h4(3952))
  Gcoeff(:)%j = (c(18)*M(6,:)%j) * den(1050)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(8807),h0tab(:,8807),[54,9],[nMT,0],2,2,wf16(:,294),wf4(:,13))
  call Hloop_VA_Q(ntryL,G0H64(1),wf16(:,294),G0H4(343),m3h16x4(:,1503),heltab2x64(:,:,6404))
  call Hloop_A_Q(ntryL,G0H4(343),54,nMT,G1H4(1363),n2h4(3953))
  Gcoeff(:)%j = (c(24)*(M(2,:)%j-M(5,:)%j)) * den(547)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(8808),h0tab(:,8808),[40,23],[0,0],2,2,wf4(:,6),wf16(:,26))
  call Hloop_QV_A(ntryL,G0H64(1),wf4(:,6),G0H16(358),m3h4x16(:,1099),heltab2x64(:,:,6405))
  call Hloop_Q_A(ntryL,G0H16(358),40,0,G1H16(1114),n2h16(1825))
  Gcoeff(:)%j = (c(22)*(M(2,:)%j-M(5,:)%j)) * den(547)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(8809),h0tab(:,8809),[40,23],[nMT,nMT],2,2,wf4(:,6),wf16(:,26))
  call Hloop_QV_A(ntryL,G0H64(1),wf4(:,6),G0H16(358),m3h4x16(:,1100),heltab2x64(:,:,6406))
  call Hloop_Q_A(ntryL,G0H16(358),40,nMT,G1H16(1115),n2h16(1826))
  Gcoeff(:)%j = (c(24)*(M(2,:)%j-M(5,:)%j)) * den(547)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(8810),h0tab(:,8810),[40,23],[0,0],2,2,wf4(:,6),wf16(:,26))
  call Hloop_QV_A(ntryL,G0H64(1),wf4(:,6),G0H16(358),m3h4x16(:,1101),heltab2x64(:,:,6407))
  call Hloop_Q_A(ntryL,G0H16(358),40,0,G1H16(1117),n2h16(1827))
  Gcoeff(:)%j = (c(22)*(M(2,:)%j-M(5,:)%j)) * den(547)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(8811),h0tab(:,8811),[40,23],[nMB,nMB],2,2,wf4(:,6),wf16(:,26))
  call Hloop_QV_A(ntryL,G0H64(1),wf4(:,6),G0H16(358),m3h4x16(:,1102),heltab2x64(:,:,6408))
  call Hloop_Q_A(ntryL,G0H16(358),40,nMB,G1H16(1118),n2h16(1828))
  Gcoeff(:)%j = (c(10)*(M(2,:)%j-M(5,:)%j)) * den(547)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(8812),h0tab(:,8812),[40,23],[0,0],2,2,wf4(:,6),wf16(:,26))
  call Hloop_CV_D(ntryL,G0H64(1),0,wf4(:,6),40,G1H16(1119),m3h4x16(:,1103),heltab2x64(:,:,6409))
  Gcoeff(:)%j = (c(4)*(-M(2,:)%j+M(5,:)%j)) * den(547)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(8813),h0tab(:,8813),[40,23],[0,0],2,2,wf4(:,6),wf16(:,26))
  call Hloop_UV_W(ntryL,G0H64(1),0,wf4(:,6),40,G1H16(1120),m3h4x16(:,1104),heltab2x64(:,:,6410))
  Gcoeff(:)%j = (c(8)*(-M(2,:)%j+M(5,:)%j)) * den(545)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(8814),h0tab(:,8814),[57,6],[nMT,0],2,2,wf16(:,218),wf4(:,11))
  call Hloop_VQ_A(ntryL,G0H64(1),wf16(:,218),G0H4(343),m3h16x4(:,1504),heltab2x64(:,:,6411))
  call Hloop_Q_A(ntryL,G0H4(343),57,nMT,G1H4(1364),n2h4(3954))
  Gcoeff(:)%j = (c(8)*(-M(2,:)%j+M(5,:)%j)) * den(542)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(8815),h0tab(:,8815),[46,17],[nMT,0],2,2,wf16(:,216),wf4(:,17))
  call Hloop_VA_Q(ntryL,G0H64(1),wf16(:,216),G0H4(343),m3h16x4(:,1505),heltab2x64(:,:,6412))
  call Hloop_A_Q(ntryL,G0H4(343),46,nMT,G1H4(1370),n2h4(3955))
  Gcoeff(:)%j = (c(18)*M(5,:)%j) * den(553)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(8816),h0tab(:,8816),[38,25],[nMT,0],2,2,wf8(:,197),wf8(:,64))
  call Hloop_VA_Q(ntryL,G0H64(1),wf8(:,197),G0H8(211),m3h8x8(:,1272),heltab2x64(:,:,6413))
  call Hloop_A_Q(ntryL,G0H8(211),38,nMT,G1H8(876),n2h8(3009))
  Gcoeff(:)%j = (c(18)*M(5,:)%j) * den(1051)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(8817),h0tab(:,8817),[57,6],[nMT,0],2,2,wf16(:,363),wf4(:,11))
  call Hloop_VQ_A(ntryL,G0H64(1),wf16(:,363),G0H4(343),m3h16x4(:,1506),heltab2x64(:,:,6414))
  call Hloop_Q_A(ntryL,G0H4(343),57,nMT,G1H4(1379),n2h4(3956))
  Gcoeff(:)%j = (c(18)*M(2,:)%j) * den(554)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(8818),h0tab(:,8818),[49,14],[nMT,0],2,2,wf8(:,203),wf8(:,67))
  call Hloop_VQ_A(ntryL,G0H64(1),wf8(:,203),G0H8(211),m3h8x8(:,1273),heltab2x64(:,:,6415))
  call Hloop_Q_A(ntryL,G0H8(211),49,nMT,G1H8(616),n2h8(3010))
  Gcoeff(:)%j = (c(18)*M(2,:)%j) * den(1052)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(8819),h0tab(:,8819),[57,6],[nMT,0],2,2,wf16(:,368),wf4(:,11))
  call Hloop_VQ_A(ntryL,G0H64(1),wf16(:,368),G0H4(343),m3h16x4(:,1507),heltab2x64(:,:,6416))
  call Hloop_Q_A(ntryL,G0H4(343),57,nMT,G1H4(12),n2h4(3957))
  Gcoeff(:)%j = (c(18)*M(2,:)%j) * den(1053)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(8820),h0tab(:,8820),[46,17],[nMT,0],2,2,wf16(:,286),wf4(:,17))
  call Hloop_VA_Q(ntryL,G0H64(1),wf16(:,286),G0H4(343),m3h16x4(:,1508),heltab2x64(:,:,6417))
  call Hloop_A_Q(ntryL,G0H4(343),46,nMT,G1H4(1393),n2h4(3958))
  Gcoeff(:)%j = (c(18)*M(5,:)%j) * den(1054)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(8821),h0tab(:,8821),[46,17],[nMT,0],2,2,wf16(:,292),wf4(:,17))
  call Hloop_VA_Q(ntryL,G0H64(1),wf16(:,292),G0H4(343),m3h16x4(:,1509),heltab2x64(:,:,6418))
  call Hloop_A_Q(ntryL,G0H4(343),46,nMT,G1H4(1413),n2h4(3959))
  Gcoeff(:)%j = (c(24)*(M(1,:)%j-M(3,:)%j)) * den(562)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(8822),h0tab(:,8822),[39,24],[0,0],2,2,wf16(:,27),wf4(:,5))
  call Hloop_QV_A(ntryL,G0H64(1),wf16(:,27),G0H4(343),m3h16x4(:,1510),heltab2x64(:,:,6419))
  call Hloop_Q_A(ntryL,G0H4(343),39,0,G1H4(1415),n2h4(3960))
  Gcoeff(:)%j = (c(22)*(M(1,:)%j-M(3,:)%j)) * den(562)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(8823),h0tab(:,8823),[39,24],[nMT,nMT],2,2,wf16(:,27),wf4(:,5))
  call Hloop_QV_A(ntryL,G0H64(1),wf16(:,27),G0H4(343),m3h16x4(:,1511),heltab2x64(:,:,6420))
  call Hloop_Q_A(ntryL,G0H4(343),39,nMT,G1H4(1418),n2h4(3961))
  Gcoeff(:)%j = (c(24)*(M(1,:)%j-M(3,:)%j)) * den(562)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(8824),h0tab(:,8824),[39,24],[0,0],2,2,wf16(:,27),wf4(:,5))
  call Hloop_QV_A(ntryL,G0H64(1),wf16(:,27),G0H4(343),m3h16x4(:,1512),heltab2x64(:,:,6421))
  call Hloop_Q_A(ntryL,G0H4(343),39,0,G1H4(1420),n2h4(3962))
  Gcoeff(:)%j = (c(22)*(M(1,:)%j-M(3,:)%j)) * den(562)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(8825),h0tab(:,8825),[39,24],[nMB,nMB],2,2,wf16(:,27),wf4(:,5))
  call Hloop_QV_A(ntryL,G0H64(1),wf16(:,27),G0H4(343),m3h16x4(:,1513),heltab2x64(:,:,6422))
  call Hloop_Q_A(ntryL,G0H4(343),39,nMB,G1H4(1423),n2h4(3963))
  Gcoeff(:)%j = (c(10)*(M(1,:)%j-M(3,:)%j)) * den(562)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(8826),h0tab(:,8826),[39,24],[0,0],2,2,wf16(:,27),wf4(:,5))
  call Hloop_CV_D(ntryL,G0H64(1),0,wf16(:,27),39,G1H4(1424),m3h16x4(:,1514),heltab2x64(:,:,6423))
  Gcoeff(:)%j = (c(4)*(-M(1,:)%j+M(3,:)%j)) * den(562)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(8827),h0tab(:,8827),[39,24],[0,0],2,2,wf16(:,27),wf4(:,5))
  call Hloop_UV_W(ntryL,G0H64(1),0,wf16(:,27),39,G1H4(15),m3h16x4(:,1515),heltab2x64(:,:,6424))
  Gcoeff(:)%j = (c(8)*(-M(1,:)%j+M(3,:)%j)) * den(560)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(8828),h0tab(:,8828),[57,6],[nMT,0],2,2,wf16(:,222),wf4(:,11))
  call Hloop_VQ_A(ntryL,G0H64(1),wf16(:,222),G0H4(343),m3h16x4(:,1516),heltab2x64(:,:,6425))
  call Hloop_Q_A(ntryL,G0H4(343),57,nMT,G1H4(1427),n2h4(3964))
  Gcoeff(:)%j = (c(8)*(-M(1,:)%j+M(3,:)%j)) * den(557)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(8829),h0tab(:,8829),[33,30],[0,nMT],2,2,wf4(:,21),wf16(:,220))
  call Hloop_AQ_V(ntryL,G0H64(1),wf4(:,21),G0H16(358),m3h4x16(:,1105),heltab2x64(:,:,6426))
  Gcoeff(:)%j = (c(28)*(M(1,:)%j-M(3,:)%j-M(5,:)%j+M(6,:)%j)) * den(1055)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(8830),h0tab(:,8830),[39,24],[0,0],2,2,wf16(:,279),wf4(:,5))
  call Hloop_QV_A(ntryL,G0H64(1),wf16(:,279),G0H4(343),m3h16x4(:,1517),heltab2x64(:,:,6427))
  call Hloop_Q_A(ntryL,G0H4(343),39,0,G1H4(1428),n2h4(3965))
  Gcoeff(:)%j = (c(26)*(M(1,:)%j-M(3,:)%j-M(5,:)%j+M(6,:)%j)) * den(1055)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(8831),h0tab(:,8831),[39,24],[nMT,nMT],2,2,wf16(:,279),wf4(:,5))
  call Hloop_QV_A(ntryL,G0H64(1),wf16(:,279),G0H4(343),m3h16x4(:,1518),heltab2x64(:,:,6428))
  call Hloop_Q_A(ntryL,G0H4(343),39,nMT,G1H4(18),n2h4(3966))
  Gcoeff(:)%j = (c(28)*(M(1,:)%j-M(3,:)%j-M(5,:)%j+M(6,:)%j)) * den(1055)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(8832),h0tab(:,8832),[39,24],[0,0],2,2,wf16(:,279),wf4(:,5))
  call Hloop_QV_A(ntryL,G0H64(1),wf16(:,279),G0H4(343),m3h16x4(:,1519),heltab2x64(:,:,6429))
  call Hloop_Q_A(ntryL,G0H4(343),39,0,G1H4(1431),n2h4(3967))
  Gcoeff(:)%j = (c(26)*(M(1,:)%j-M(3,:)%j-M(5,:)%j+M(6,:)%j)) * den(1055)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(8833),h0tab(:,8833),[39,24],[nMB,nMB],2,2,wf16(:,279),wf4(:,5))
  call Hloop_QV_A(ntryL,G0H64(1),wf16(:,279),G0H4(343),m3h16x4(:,1520),heltab2x64(:,:,6430))
  call Hloop_Q_A(ntryL,G0H4(343),39,nMB,G1H4(1432),n2h4(3968))
  Gcoeff(:)%j = (c(20)*(M(1,:)%j-M(3,:)%j-M(5,:)%j+M(6,:)%j)) * den(1055)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(8834),h0tab(:,8834),[39,24],[0,0],2,2,wf16(:,279),wf4(:,5))
  call Hloop_CV_D(ntryL,G0H64(1),0,wf16(:,279),39,G1H4(1435),m3h16x4(:,1521),heltab2x64(:,:,6431))
  Gcoeff(:)%j = (c(14)*(-M(1,:)%j+M(3,:)%j+M(5,:)%j-M(6,:)%j)) * den(1055)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(8835),h0tab(:,8835),[39,24],[0,0],2,2,wf16(:,279),wf4(:,5))
  call Hloop_UV_W(ntryL,G0H64(1),0,wf16(:,279),39,G1H4(1436),m3h16x4(:,1522),heltab2x64(:,:,6432))
  Gcoeff(:)%j = (c(28)*(-M(1,:)%j+M(3,:)%j+M(5,:)%j-M(6,:)%j)) * den(565)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(8836),h0tab(:,8836),[56,7],[0,0],2,2,wf8(:,29),wf8(:,18))
  call Hloop_QV_A(ntryL,G0H64(1),wf8(:,29),G0H8(211),m3h8x8(:,1274),heltab2x64(:,:,6433))
  call Hloop_Q_A(ntryL,G0H8(211),56,0,G1H8(598),n2h8(3011))
  Gcoeff(:)%j = (c(26)*(-M(1,:)%j+M(3,:)%j+M(5,:)%j-M(6,:)%j)) * den(565)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(8837),h0tab(:,8837),[56,7],[nMT,nMT],2,2,wf8(:,29),wf8(:,18))
  call Hloop_QV_A(ntryL,G0H64(1),wf8(:,29),G0H8(211),m3h8x8(:,1275),heltab2x64(:,:,6434))
  call Hloop_Q_A(ntryL,G0H8(211),56,nMT,G1H8(544),n2h8(3012))
  Gcoeff(:)%j = (c(28)*(-M(1,:)%j+M(3,:)%j+M(5,:)%j-M(6,:)%j)) * den(565)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(8838),h0tab(:,8838),[56,7],[0,0],2,2,wf8(:,29),wf8(:,18))
  call Hloop_QV_A(ntryL,G0H64(1),wf8(:,29),G0H8(211),m3h8x8(:,1276),heltab2x64(:,:,6435))
  call Hloop_Q_A(ntryL,G0H8(211),56,0,G1H8(297),n2h8(3013))
  Gcoeff(:)%j = (c(26)*(-M(1,:)%j+M(3,:)%j+M(5,:)%j-M(6,:)%j)) * den(565)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(8839),h0tab(:,8839),[56,7],[nMB,nMB],2,2,wf8(:,29),wf8(:,18))
  call Hloop_QV_A(ntryL,G0H64(1),wf8(:,29),G0H8(211),m3h8x8(:,1277),heltab2x64(:,:,6436))
  call Hloop_Q_A(ntryL,G0H8(211),56,nMB,G1H8(267),n2h8(3014))
  Gcoeff(:)%j = (c(20)*(-M(1,:)%j+M(3,:)%j+M(5,:)%j-M(6,:)%j)) * den(565)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(8840),h0tab(:,8840),[56,7],[0,0],2,2,wf8(:,29),wf8(:,18))
  call Hloop_CV_D(ntryL,G0H64(1),0,wf8(:,29),56,G1H8(261),m3h8x8(:,1278),heltab2x64(:,:,6437))
  Gcoeff(:)%j = (c(14)*(M(1,:)%j-M(3,:)%j-M(5,:)%j+M(6,:)%j)) * den(565)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(8841),h0tab(:,8841),[56,7],[0,0],2,2,wf8(:,29),wf8(:,18))
  call Hloop_UV_W(ntryL,G0H64(1),0,wf8(:,29),56,G1H8(319),m3h8x8(:,1279),heltab2x64(:,:,6438))
  Gcoeff(:)%j = (c(8)*(-M(5,:)%j+M(6,:)%j)) * den(1056)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(8842),h0tab(:,8842),[57,6],[nMT,0],2,2,wf16(:,414),wf4(:,11))
  call Hloop_VQ_A(ntryL,G0H64(1),wf16(:,414),G0H4(343),m3h16x4(:,1523),heltab2x64(:,:,6439))
  call Hloop_Q_A(ntryL,G0H4(343),57,nMT,G1H4(1437),n2h4(3969))
  Gcoeff(:)%j = (c(8)*(-M(5,:)%j+M(6,:)%j)) * den(566)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(8843),h0tab(:,8843),[38,25],[nMT,0],2,2,wf8(:,197),wf8(:,69))
  call Hloop_VA_Q(ntryL,G0H64(1),wf8(:,197),G0H8(211),m3h8x8(:,1280),heltab2x64(:,:,6440))
  call Hloop_A_Q(ntryL,G0H8(211),38,nMT,G1H8(605),n2h8(3015))
  Gcoeff(:)%j = (c(24)*(M(5,:)%j-M(6,:)%j)) * den(1057)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(8844),h0tab(:,8844),[39,24],[0,0],2,2,wf16(:,282),wf4(:,5))
  call Hloop_QV_A(ntryL,G0H64(1),wf16(:,282),G0H4(343),m3h16x4(:,1524),heltab2x64(:,:,6441))
  call Hloop_Q_A(ntryL,G0H4(343),39,0,G1H4(1441),n2h4(3970))
  Gcoeff(:)%j = (c(22)*(M(5,:)%j-M(6,:)%j)) * den(1057)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(8845),h0tab(:,8845),[39,24],[nMT,nMT],2,2,wf16(:,282),wf4(:,5))
  call Hloop_QV_A(ntryL,G0H64(1),wf16(:,282),G0H4(343),m3h16x4(:,1525),heltab2x64(:,:,6442))
  call Hloop_Q_A(ntryL,G0H4(343),39,nMT,G1H4(220),n2h4(3971))
  Gcoeff(:)%j = (c(24)*(M(5,:)%j-M(6,:)%j)) * den(1057)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(8846),h0tab(:,8846),[39,24],[0,0],2,2,wf16(:,282),wf4(:,5))
  call Hloop_QV_A(ntryL,G0H64(1),wf16(:,282),G0H4(343),m3h16x4(:,1526),heltab2x64(:,:,6443))
  call Hloop_Q_A(ntryL,G0H4(343),39,0,G1H4(1444),n2h4(3972))
  Gcoeff(:)%j = (c(22)*(M(5,:)%j-M(6,:)%j)) * den(1057)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(8847),h0tab(:,8847),[39,24],[nMB,nMB],2,2,wf16(:,282),wf4(:,5))
  call Hloop_QV_A(ntryL,G0H64(1),wf16(:,282),G0H4(343),m3h16x4(:,1527),heltab2x64(:,:,6444))
  call Hloop_Q_A(ntryL,G0H4(343),39,nMB,G1H4(1446),n2h4(3973))
  Gcoeff(:)%j = (c(10)*(M(5,:)%j-M(6,:)%j)) * den(1057)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(8848),h0tab(:,8848),[39,24],[0,0],2,2,wf16(:,282),wf4(:,5))
  call Hloop_CV_D(ntryL,G0H64(1),0,wf16(:,282),39,G1H4(1449),m3h16x4(:,1528),heltab2x64(:,:,6445))
  Gcoeff(:)%j = (c(4)*(-M(5,:)%j+M(6,:)%j)) * den(1057)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(8849),h0tab(:,8849),[39,24],[0,0],2,2,wf16(:,282),wf4(:,5))
  call Hloop_UV_W(ntryL,G0H64(1),0,wf16(:,282),39,G1H4(1450),m3h16x4(:,1529),heltab2x64(:,:,6446))
  Gcoeff(:)%j = (c(18)*(M(1,:)%j-M(3,:)%j-M(5,:)%j+M(6,:)%j)) * den(1058)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(8850),h0tab(:,8850),[57,6],[0,nMT],2,2,wf16(:,416),wf4(:,11))
  call Hloop_AQ_V(ntryL,G0H64(1),wf16(:,416),G0H4(343),m3h16x4(:,1530),heltab2x64(:,:,6447))
  Gcoeff(:)%j = (c(18)*M(3,:)%j) * den(574)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(8851),h0tab(:,8851),[41,22],[0,nMT],2,2,wf8(:,71),wf8(:,62))
  call Hloop_AQ_V(ntryL,G0H64(1),wf8(:,71),G0H8(211),m3h8x8(:,1281),heltab2x64(:,:,6448))
  Gcoeff(:)%j = (c(18)*M(3,:)%j) * den(1059)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(8852),h0tab(:,8852),[57,6],[nMT,0],2,2,wf16(:,439),wf4(:,11))
  call Hloop_VQ_A(ntryL,G0H64(1),wf16(:,439),G0H4(344),m3h16x4(:,1531),heltab2x64(:,:,6449))
  call Hloop_Q_A(ntryL,G0H4(344),57,nMT,G1H4(100),n2h4(3974))
  Gcoeff(:)%j = (c(18)*M(1,:)%j) * den(575)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(8853),h0tab(:,8853),[49,14],[nMT,0],2,2,wf8(:,205),wf8(:,67))
  call Hloop_VQ_A(ntryL,G0H64(1),wf8(:,205),G0H8(212),m3h8x8(:,1282),heltab2x64(:,:,6450))
  call Hloop_Q_A(ntryL,G0H8(212),49,nMT,G1H8(1298),n2h8(3016))
  Gcoeff(:)%j = (c(18)*M(1,:)%j) * den(1060)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(8854),h0tab(:,8854),[57,6],[nMT,0],2,2,wf16(:,444),wf4(:,11))
  call Hloop_VQ_A(ntryL,G0H64(1),wf16(:,444),G0H4(344),m3h16x4(:,1532),heltab2x64(:,:,6451))
  call Hloop_Q_A(ntryL,G0H4(344),57,nMT,G1H4(1452),n2h4(3975))
  Gcoeff(:)%j = (c(18)*M(1,:)%j) * den(1061)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(8855),h0tab(:,8855),[33,30],[0,nMT],2,2,wf4(:,21),wf16(:,284))
  call Hloop_AQ_V(ntryL,G0H64(1),wf4(:,21),G0H16(359),m3h4x16(:,1106),heltab2x64(:,:,6452))
  Gcoeff(:)%j = (c(18)*M(3,:)%j) * den(1062)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(8856),h0tab(:,8856),[33,30],[0,nMT],2,2,wf4(:,21),wf16(:,288))
  call Hloop_AQ_V(ntryL,G0H64(1),wf4(:,21),G0H16(360),m3h4x16(:,1107),heltab2x64(:,:,6453))
  Gcoeff(:)%j = (c(28)*(M(2,:)%j-M(3,:)%j+M(4,:)%j-M(5,:)%j)) * den(1063)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(8857),h0tab(:,8857),[40,23],[0,0],2,2,wf4(:,6),wf16(:,278))
  call Hloop_QV_A(ntryL,G0H64(1),wf4(:,6),G0H16(361),m3h4x16(:,1108),heltab2x64(:,:,6454))
  call Hloop_Q_A(ntryL,G0H16(361),40,0,G1H16(1122),n2h16(1829))
  Gcoeff(:)%j = (c(26)*(M(2,:)%j-M(3,:)%j+M(4,:)%j-M(5,:)%j)) * den(1063)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(8858),h0tab(:,8858),[40,23],[nMT,nMT],2,2,wf4(:,6),wf16(:,278))
  call Hloop_QV_A(ntryL,G0H64(1),wf4(:,6),G0H16(361),m3h4x16(:,1109),heltab2x64(:,:,6455))
  call Hloop_Q_A(ntryL,G0H16(361),40,nMT,G1H16(1123),n2h16(1830))
  Gcoeff(:)%j = (c(28)*(M(2,:)%j-M(3,:)%j+M(4,:)%j-M(5,:)%j)) * den(1063)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(8859),h0tab(:,8859),[40,23],[0,0],2,2,wf4(:,6),wf16(:,278))
  call Hloop_QV_A(ntryL,G0H64(1),wf4(:,6),G0H16(361),m3h4x16(:,1110),heltab2x64(:,:,6456))
  call Hloop_Q_A(ntryL,G0H16(361),40,0,G1H16(1124),n2h16(1831))
  Gcoeff(:)%j = (c(26)*(M(2,:)%j-M(3,:)%j+M(4,:)%j-M(5,:)%j)) * den(1063)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(8860),h0tab(:,8860),[40,23],[nMB,nMB],2,2,wf4(:,6),wf16(:,278))
  call Hloop_QV_A(ntryL,G0H64(1),wf4(:,6),G0H16(361),m3h4x16(:,1111),heltab2x64(:,:,6457))
  call Hloop_Q_A(ntryL,G0H16(361),40,nMB,G1H16(1125),n2h16(1832))
  Gcoeff(:)%j = (c(20)*(M(2,:)%j-M(3,:)%j+M(4,:)%j-M(5,:)%j)) * den(1063)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(8861),h0tab(:,8861),[40,23],[0,0],2,2,wf4(:,6),wf16(:,278))
  call Hloop_CV_D(ntryL,G0H64(1),0,wf4(:,6),40,G1H16(1127),m3h4x16(:,1112),heltab2x64(:,:,6458))
  Gcoeff(:)%j = (c(14)*(-M(2,:)%j+M(3,:)%j-M(4,:)%j+M(5,:)%j)) * den(1063)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(8862),h0tab(:,8862),[40,23],[0,0],2,2,wf4(:,6),wf16(:,278))
  call Hloop_UV_W(ntryL,G0H64(1),0,wf4(:,6),40,G1H16(1128),m3h4x16(:,1113),heltab2x64(:,:,6459))
  Gcoeff(:)%j = (c(28)*(M(2,:)%j-M(3,:)%j+M(4,:)%j-M(5,:)%j)) * den(578)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(8863),h0tab(:,8863),[56,7],[0,0],2,2,wf8(:,33),wf8(:,18))
  call Hloop_QV_A(ntryL,G0H64(1),wf8(:,33),G0H8(212),m3h8x8(:,1283),heltab2x64(:,:,6460))
  call Hloop_Q_A(ntryL,G0H8(212),56,0,G1H8(236),n2h8(3017))
  Gcoeff(:)%j = (c(26)*(M(2,:)%j-M(3,:)%j+M(4,:)%j-M(5,:)%j)) * den(578)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(8864),h0tab(:,8864),[56,7],[nMT,nMT],2,2,wf8(:,33),wf8(:,18))
  call Hloop_QV_A(ntryL,G0H64(1),wf8(:,33),G0H8(212),m3h8x8(:,1284),heltab2x64(:,:,6461))
  call Hloop_Q_A(ntryL,G0H8(212),56,nMT,G1H8(41),n2h8(3018))
  Gcoeff(:)%j = (c(28)*(M(2,:)%j-M(3,:)%j+M(4,:)%j-M(5,:)%j)) * den(578)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(8865),h0tab(:,8865),[56,7],[0,0],2,2,wf8(:,33),wf8(:,18))
  call Hloop_QV_A(ntryL,G0H64(1),wf8(:,33),G0H8(212),m3h8x8(:,1285),heltab2x64(:,:,6462))
  call Hloop_Q_A(ntryL,G0H8(212),56,0,G1H8(309),n2h8(3019))
  Gcoeff(:)%j = (c(26)*(M(2,:)%j-M(3,:)%j+M(4,:)%j-M(5,:)%j)) * den(578)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(8866),h0tab(:,8866),[56,7],[nMB,nMB],2,2,wf8(:,33),wf8(:,18))
  call Hloop_QV_A(ntryL,G0H64(1),wf8(:,33),G0H8(212),m3h8x8(:,1286),heltab2x64(:,:,6463))
  call Hloop_Q_A(ntryL,G0H8(212),56,nMB,G1H8(304),n2h8(3020))
  Gcoeff(:)%j = (c(20)*(M(2,:)%j-M(3,:)%j+M(4,:)%j-M(5,:)%j)) * den(578)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(8867),h0tab(:,8867),[56,7],[0,0],2,2,wf8(:,33),wf8(:,18))
  call Hloop_CV_D(ntryL,G0H64(1),0,wf8(:,33),56,G1H8(303),m3h8x8(:,1287),heltab2x64(:,:,6464))
  Gcoeff(:)%j = (c(14)*(-M(2,:)%j+M(3,:)%j-M(4,:)%j+M(5,:)%j)) * den(578)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(8868),h0tab(:,8868),[56,7],[0,0],2,2,wf8(:,33),wf8(:,18))
  call Hloop_UV_W(ntryL,G0H64(1),0,wf8(:,33),56,G1H8(336),m3h8x8(:,1288),heltab2x64(:,:,6465))
  Gcoeff(:)%j = (c(8)*(-M(3,:)%j+M(4,:)%j)) * den(1064)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(8869),h0tab(:,8869),[57,6],[nMT,0],2,2,wf16(:,490),wf4(:,11))
  call Hloop_VQ_A(ntryL,G0H64(1),wf16(:,490),G0H4(344),m3h16x4(:,1533),heltab2x64(:,:,6466))
  call Hloop_Q_A(ntryL,G0H4(344),57,nMT,G1H4(1453),n2h4(3976))
  Gcoeff(:)%j = (c(8)*(-M(3,:)%j+M(4,:)%j)) * den(579)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(8870),h0tab(:,8870),[41,22],[0,nMT],2,2,wf8(:,74),wf8(:,62))
  call Hloop_AQ_V(ntryL,G0H64(1),wf8(:,74),G0H8(212),m3h8x8(:,1289),heltab2x64(:,:,6467))
  Gcoeff(:)%j = (c(24)*(M(3,:)%j-M(4,:)%j)) * den(1065)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(8871),h0tab(:,8871),[40,23],[0,0],2,2,wf4(:,6),wf16(:,281))
  call Hloop_QV_A(ntryL,G0H64(1),wf4(:,6),G0H16(361),m3h4x16(:,1114),heltab2x64(:,:,6468))
  call Hloop_Q_A(ntryL,G0H16(361),40,0,G1H16(1129),n2h16(1833))
  Gcoeff(:)%j = (c(22)*(M(3,:)%j-M(4,:)%j)) * den(1065)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(8872),h0tab(:,8872),[40,23],[nMT,nMT],2,2,wf4(:,6),wf16(:,281))
  call Hloop_QV_A(ntryL,G0H64(1),wf4(:,6),G0H16(361),m3h4x16(:,1115),heltab2x64(:,:,6469))
  call Hloop_Q_A(ntryL,G0H16(361),40,nMT,G1H16(1130),n2h16(1834))
  Gcoeff(:)%j = (c(24)*(M(3,:)%j-M(4,:)%j)) * den(1065)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(8873),h0tab(:,8873),[40,23],[0,0],2,2,wf4(:,6),wf16(:,281))
  call Hloop_QV_A(ntryL,G0H64(1),wf4(:,6),G0H16(361),m3h4x16(:,1116),heltab2x64(:,:,6470))
  call Hloop_Q_A(ntryL,G0H16(361),40,0,G1H16(1132),n2h16(1835))
  Gcoeff(:)%j = (c(22)*(M(3,:)%j-M(4,:)%j)) * den(1065)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(8874),h0tab(:,8874),[40,23],[nMB,nMB],2,2,wf4(:,6),wf16(:,281))
  call Hloop_QV_A(ntryL,G0H64(1),wf4(:,6),G0H16(361),m3h4x16(:,1117),heltab2x64(:,:,6471))
  call Hloop_Q_A(ntryL,G0H16(361),40,nMB,G1H16(1133),n2h16(1836))
  Gcoeff(:)%j = (c(10)*(M(3,:)%j-M(4,:)%j)) * den(1065)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(8875),h0tab(:,8875),[40,23],[0,0],2,2,wf4(:,6),wf16(:,281))
  call Hloop_CV_D(ntryL,G0H64(1),0,wf4(:,6),40,G1H16(1134),m3h4x16(:,1118),heltab2x64(:,:,6472))
  Gcoeff(:)%j = (c(4)*(-M(3,:)%j+M(4,:)%j)) * den(1065)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(8876),h0tab(:,8876),[40,23],[0,0],2,2,wf4(:,6),wf16(:,281))
  call Hloop_UV_W(ntryL,G0H64(1),0,wf4(:,6),40,G1H16(1135),m3h4x16(:,1119),heltab2x64(:,:,6473))
  Gcoeff(:)%j = (c(18)*(-M(2,:)%j+M(3,:)%j-M(4,:)%j+M(5,:)%j)) * den(1066)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(8877),h0tab(:,8877),[57,6],[0,nMT],2,2,wf16(:,492),wf4(:,11))
  call Hloop_AQ_V(ntryL,G0H64(1),wf16(:,492),G0H4(344),m3h16x4(:,1534),heltab2x64(:,:,6474))
  Gcoeff(:)%j = (c(28)*(-M(1,:)%j+M(2,:)%j+M(4,:)%j-M(6,:)%j)) * den(1067)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(8878),h0tab(:,8878),[48,15],[0,0],2,2,wf4(:,7),wf16(:,277))
  call Hloop_QV_A(ntryL,G0H64(1),wf4(:,7),G0H16(361),m3h4x16(:,1120),heltab2x64(:,:,6475))
  call Hloop_Q_A(ntryL,G0H16(361),48,0,G1H16(1137),n2h16(1837))
  Gcoeff(:)%j = (c(26)*(-M(1,:)%j+M(2,:)%j+M(4,:)%j-M(6,:)%j)) * den(1067)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(8879),h0tab(:,8879),[48,15],[nMT,nMT],2,2,wf4(:,7),wf16(:,277))
  call Hloop_QV_A(ntryL,G0H64(1),wf4(:,7),G0H16(361),m3h4x16(:,1121),heltab2x64(:,:,6476))
  call Hloop_Q_A(ntryL,G0H16(361),48,nMT,G1H16(1138),n2h16(1838))
  Gcoeff(:)%j = (c(28)*(-M(1,:)%j+M(2,:)%j+M(4,:)%j-M(6,:)%j)) * den(1067)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(8880),h0tab(:,8880),[48,15],[0,0],2,2,wf4(:,7),wf16(:,277))
  call Hloop_QV_A(ntryL,G0H64(1),wf4(:,7),G0H16(361),m3h4x16(:,1122),heltab2x64(:,:,6477))
  call Hloop_Q_A(ntryL,G0H16(361),48,0,G1H16(1139),n2h16(1839))
  Gcoeff(:)%j = (c(26)*(-M(1,:)%j+M(2,:)%j+M(4,:)%j-M(6,:)%j)) * den(1067)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(8881),h0tab(:,8881),[48,15],[nMB,nMB],2,2,wf4(:,7),wf16(:,277))
  call Hloop_QV_A(ntryL,G0H64(1),wf4(:,7),G0H16(361),m3h4x16(:,1123),heltab2x64(:,:,6478))
  call Hloop_Q_A(ntryL,G0H16(361),48,nMB,G1H16(1140),n2h16(1840))
  Gcoeff(:)%j = (c(20)*(-M(1,:)%j+M(2,:)%j+M(4,:)%j-M(6,:)%j)) * den(1067)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(8882),h0tab(:,8882),[48,15],[0,0],2,2,wf4(:,7),wf16(:,277))
  call Hloop_CV_D(ntryL,G0H64(1),0,wf4(:,7),48,G1H16(1142),m3h4x16(:,1124),heltab2x64(:,:,6479))
  Gcoeff(:)%j = (c(14)*(M(1,:)%j-M(2,:)%j-M(4,:)%j+M(6,:)%j)) * den(1067)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(8883),h0tab(:,8883),[48,15],[0,0],2,2,wf4(:,7),wf16(:,277))
  call Hloop_UV_W(ntryL,G0H64(1),0,wf4(:,7),48,G1H16(1143),m3h4x16(:,1125),heltab2x64(:,:,6480))
  Gcoeff(:)%j = (c(28)*(-M(1,:)%j+M(2,:)%j+M(4,:)%j-M(6,:)%j)) * den(583)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(8884),h0tab(:,8884),[56,7],[0,0],2,2,wf8(:,35),wf8(:,18))
  call Hloop_QV_A(ntryL,G0H64(1),wf8(:,35),G0H8(213),m3h8x8(:,1290),heltab2x64(:,:,6481))
  call Hloop_Q_A(ntryL,G0H8(213),56,0,G1H8(81),n2h8(3021))
  Gcoeff(:)%j = (c(26)*(-M(1,:)%j+M(2,:)%j+M(4,:)%j-M(6,:)%j)) * den(583)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(8885),h0tab(:,8885),[56,7],[nMT,nMT],2,2,wf8(:,35),wf8(:,18))
  call Hloop_QV_A(ntryL,G0H64(1),wf8(:,35),G0H8(213),m3h8x8(:,1291),heltab2x64(:,:,6482))
  call Hloop_Q_A(ntryL,G0H8(213),56,nMT,G1H8(1319),n2h8(3022))
  Gcoeff(:)%j = (c(28)*(-M(1,:)%j+M(2,:)%j+M(4,:)%j-M(6,:)%j)) * den(583)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(8886),h0tab(:,8886),[56,7],[0,0],2,2,wf8(:,35),wf8(:,18))
  call Hloop_QV_A(ntryL,G0H64(1),wf8(:,35),G0H8(213),m3h8x8(:,1292),heltab2x64(:,:,6483))
  call Hloop_Q_A(ntryL,G0H8(213),56,0,G1H8(339),n2h8(3023))
  Gcoeff(:)%j = (c(26)*(-M(1,:)%j+M(2,:)%j+M(4,:)%j-M(6,:)%j)) * den(583)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(8887),h0tab(:,8887),[56,7],[nMB,nMB],2,2,wf8(:,35),wf8(:,18))
  call Hloop_QV_A(ntryL,G0H64(1),wf8(:,35),G0H8(213),m3h8x8(:,1293),heltab2x64(:,:,6484))
  call Hloop_Q_A(ntryL,G0H8(213),56,nMB,G1H8(49),n2h8(3024))
  Gcoeff(:)%j = (c(20)*(-M(1,:)%j+M(2,:)%j+M(4,:)%j-M(6,:)%j)) * den(583)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(8888),h0tab(:,8888),[56,7],[0,0],2,2,wf8(:,35),wf8(:,18))
  call Hloop_CV_D(ntryL,G0H64(1),0,wf8(:,35),56,G1H8(1),m3h8x8(:,1294),heltab2x64(:,:,6485))
  Gcoeff(:)%j = (c(14)*(M(1,:)%j-M(2,:)%j-M(4,:)%j+M(6,:)%j)) * den(583)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(8889),h0tab(:,8889),[56,7],[0,0],2,2,wf8(:,35),wf8(:,18))
  call Hloop_UV_W(ntryL,G0H64(1),0,wf8(:,35),56,G1H8(927),m3h8x8(:,1295),heltab2x64(:,:,6486))
  Gcoeff(:)%j = (c(8)*(-M(1,:)%j+M(2,:)%j)) * den(1068)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(8890),h0tab(:,8890),[57,6],[nMT,0],2,2,wf16(:,510),wf4(:,11))
  call Hloop_VQ_A(ntryL,G0H64(1),wf16(:,510),G0H4(345),m3h16x4(:,1535),heltab2x64(:,:,6487))
  call Hloop_Q_A(ntryL,G0H4(345),57,nMT,G1H4(1456),n2h4(3977))
  Gcoeff(:)%j = (c(24)*(M(1,:)%j-M(2,:)%j)) * den(1069)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(8891),h0tab(:,8891),[48,15],[0,0],2,2,wf4(:,7),wf16(:,280))
  call Hloop_QV_A(ntryL,G0H64(1),wf4(:,7),G0H16(361),m3h4x16(:,1126),heltab2x64(:,:,6488))
  call Hloop_Q_A(ntryL,G0H16(361),48,0,G1H16(1144),n2h16(1841))
  Gcoeff(:)%j = (c(22)*(M(1,:)%j-M(2,:)%j)) * den(1069)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(8892),h0tab(:,8892),[48,15],[nMT,nMT],2,2,wf4(:,7),wf16(:,280))
  call Hloop_QV_A(ntryL,G0H64(1),wf4(:,7),G0H16(361),m3h4x16(:,1127),heltab2x64(:,:,6489))
  call Hloop_Q_A(ntryL,G0H16(361),48,nMT,G1H16(1145),n2h16(1842))
  Gcoeff(:)%j = (c(24)*(M(1,:)%j-M(2,:)%j)) * den(1069)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(8893),h0tab(:,8893),[48,15],[0,0],2,2,wf4(:,7),wf16(:,280))
  call Hloop_QV_A(ntryL,G0H64(1),wf4(:,7),G0H16(361),m3h4x16(:,1128),heltab2x64(:,:,6490))
  call Hloop_Q_A(ntryL,G0H16(361),48,0,G1H16(1147),n2h16(1843))
  Gcoeff(:)%j = (c(22)*(M(1,:)%j-M(2,:)%j)) * den(1069)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(8894),h0tab(:,8894),[48,15],[nMB,nMB],2,2,wf4(:,7),wf16(:,280))
  call Hloop_QV_A(ntryL,G0H64(1),wf4(:,7),G0H16(361),m3h4x16(:,1129),heltab2x64(:,:,6491))
  call Hloop_Q_A(ntryL,G0H16(361),48,nMB,G1H16(1148),n2h16(1844))
  Gcoeff(:)%j = (c(10)*(M(1,:)%j-M(2,:)%j)) * den(1069)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(8895),h0tab(:,8895),[48,15],[0,0],2,2,wf4(:,7),wf16(:,280))
  call Hloop_CV_D(ntryL,G0H64(1),0,wf4(:,7),48,G1H16(1149),m3h4x16(:,1130),heltab2x64(:,:,6492))
  Gcoeff(:)%j = (c(4)*(-M(1,:)%j+M(2,:)%j)) * den(1069)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(8896),h0tab(:,8896),[48,15],[0,0],2,2,wf4(:,7),wf16(:,280))
  call Hloop_UV_W(ntryL,G0H64(1),0,wf4(:,7),48,G1H16(1150),m3h4x16(:,1131),heltab2x64(:,:,6493))
  Gcoeff(:)%j = (c(18)*(M(1,:)%j-M(2,:)%j-M(4,:)%j+M(6,:)%j)) * den(1070)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(8897),h0tab(:,8897),[57,6],[0,nMT],2,2,wf16(:,512),wf4(:,11))
  call Hloop_AQ_V(ntryL,G0H64(1),wf16(:,512),G0H4(345),m3h16x4(:,1536),heltab2x64(:,:,6494))
  Gcoeff(:)%j = (c(8)*(-M(1,:)%j+M(2,:)%j)) * den(584)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(8898),h0tab(:,8898),[49,14],[0,nMT],2,2,wf8(:,76),wf8(:,67))
  call Hloop_AQ_V(ntryL,G0H64(1),wf8(:,76),G0H8(213),m3h8x8(:,1296),heltab2x64(:,:,6495))
  Gcoeff(:)%j = (c(24)*(M(14,:)%j-M(17,:)%j)) * den(595)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(8899),h0tab(:,8899),[36,27],[0,0],2,2,wf4(:,4),wf16(:,28))
  call Hloop_QV_A(ntryL,G0H64(1),wf4(:,4),G0H16(361),m3h4x16(:,1132),heltab2x64(:,:,6496))
  call Hloop_Q_A(ntryL,G0H16(361),36,0,G1H16(1152),n2h16(1845))
  Gcoeff(:)%j = (c(22)*(M(14,:)%j-M(17,:)%j)) * den(595)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(8900),h0tab(:,8900),[36,27],[nMT,nMT],2,2,wf4(:,4),wf16(:,28))
  call Hloop_QV_A(ntryL,G0H64(1),wf4(:,4),G0H16(361),m3h4x16(:,1133),heltab2x64(:,:,6497))
  call Hloop_Q_A(ntryL,G0H16(361),36,nMT,G1H16(1153),n2h16(1846))
  Gcoeff(:)%j = (c(24)*(M(14,:)%j-M(17,:)%j)) * den(595)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(8901),h0tab(:,8901),[36,27],[0,0],2,2,wf4(:,4),wf16(:,28))
  call Hloop_QV_A(ntryL,G0H64(1),wf4(:,4),G0H16(361),m3h4x16(:,1134),heltab2x64(:,:,6498))
  call Hloop_Q_A(ntryL,G0H16(361),36,0,G1H16(1154),n2h16(1847))
  Gcoeff(:)%j = (c(22)*(M(14,:)%j-M(17,:)%j)) * den(595)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(8902),h0tab(:,8902),[36,27],[nMB,nMB],2,2,wf4(:,4),wf16(:,28))
  call Hloop_QV_A(ntryL,G0H64(1),wf4(:,4),G0H16(361),m3h4x16(:,1135),heltab2x64(:,:,6499))
  call Hloop_Q_A(ntryL,G0H16(361),36,nMB,G1H16(1155),n2h16(1848))
  Gcoeff(:)%j = (c(10)*(M(14,:)%j-M(17,:)%j)) * den(595)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(8903),h0tab(:,8903),[36,27],[0,0],2,2,wf4(:,4),wf16(:,28))
  call Hloop_CV_D(ntryL,G0H64(1),0,wf4(:,4),36,G1H16(1157),m3h4x16(:,1136),heltab2x64(:,:,6500))
  Gcoeff(:)%j = (c(4)*(-M(14,:)%j+M(17,:)%j)) * den(595)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(8904),h0tab(:,8904),[36,27],[0,0],2,2,wf4(:,4),wf16(:,28))
  call Hloop_UV_W(ntryL,G0H64(1),0,wf4(:,4),36,G1H16(1158),m3h4x16(:,1137),heltab2x64(:,:,6501))
  Gcoeff(:)%j = (c(8)*(-M(14,:)%j+M(17,:)%j)) * den(593)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(8905),h0tab(:,8905),[45,18],[nMT,0],2,2,wf16(:,226),wf4(:,19))
  call Hloop_VQ_A(ntryL,G0H64(1),wf16(:,226),G0H4(346),m3h16x4(:,1537),heltab2x64(:,:,6502))
  call Hloop_Q_A(ntryL,G0H4(346),45,nMT,G1H4(1457),n2h4(3978))
  Gcoeff(:)%j = (c(8)*(-M(14,:)%j+M(17,:)%j)) * den(590)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(8906),h0tab(:,8906),[54,9],[nMT,0],2,2,wf16(:,224),wf4(:,13))
  call Hloop_VA_Q(ntryL,G0H64(1),wf16(:,224),G0H4(346),m3h16x4(:,1538),heltab2x64(:,:,6503))
  call Hloop_A_Q(ntryL,G0H4(346),54,nMT,G1H4(1458),n2h4(3979))
  Gcoeff(:)%j = (c(18)*M(17,:)%j) * den(600)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(8907),h0tab(:,8907),[50,13],[nMT,0],2,2,wf8(:,185),wf8(:,78))
  call Hloop_VA_Q(ntryL,G0H64(1),wf8(:,185),G0H8(214),m3h8x8(:,1297),heltab2x64(:,:,6504))
  call Hloop_A_Q(ntryL,G0H8(214),50,nMT,G1H8(837),n2h8(3025))
  Gcoeff(:)%j = (c(18)*M(17,:)%j) * den(1071)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(8908),h0tab(:,8908),[45,18],[nMT,0],2,2,wf16(:,302),wf4(:,19))
  call Hloop_VQ_A(ntryL,G0H64(1),wf16(:,302),G0H4(346),m3h16x4(:,1539),heltab2x64(:,:,6505))
  call Hloop_Q_A(ntryL,G0H4(346),45,nMT,G1H4(172),n2h4(3980))
  Gcoeff(:)%j = (c(18)*M(14,:)%j) * den(601)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(8909),h0tab(:,8909),[41,22],[nMT,0],2,2,wf8(:,195),wf8(:,80))
  call Hloop_VQ_A(ntryL,G0H64(1),wf8(:,195),G0H8(214),m3h8x8(:,1298),heltab2x64(:,:,6506))
  call Hloop_Q_A(ntryL,G0H8(214),41,nMT,G1H8(348),n2h8(3026))
  Gcoeff(:)%j = (c(18)*M(14,:)%j) * den(1072)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(8910),h0tab(:,8910),[45,18],[nMT,0],2,2,wf16(:,310),wf4(:,19))
  call Hloop_VQ_A(ntryL,G0H64(1),wf16(:,310),G0H4(346),m3h16x4(:,1540),heltab2x64(:,:,6507))
  call Hloop_Q_A(ntryL,G0H4(346),45,nMT,G1H4(1469),n2h4(3981))
  Gcoeff(:)%j = (c(18)*M(14,:)%j) * den(1073)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(8911),h0tab(:,8911),[54,9],[nMT,0],2,2,wf16(:,378),wf4(:,13))
  call Hloop_VA_Q(ntryL,G0H64(1),wf16(:,378),G0H4(346),m3h16x4(:,1541),heltab2x64(:,:,6508))
  call Hloop_A_Q(ntryL,G0H4(346),54,nMT,G1H4(1470),n2h4(3982))
  Gcoeff(:)%j = (c(18)*M(17,:)%j) * den(1074)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(8912),h0tab(:,8912),[54,9],[nMT,0],2,2,wf16(:,384),wf4(:,13))
  call Hloop_VA_Q(ntryL,G0H64(1),wf16(:,384),G0H4(346),m3h16x4(:,1542),heltab2x64(:,:,6509))
  call Hloop_A_Q(ntryL,G0H4(346),54,nMT,G1H4(701),n2h4(3983))
  Gcoeff(:)%j = (c(24)*(M(20,:)%j-M(23,:)%j)) * den(609)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(8913),h0tab(:,8913),[43,20],[0,0],2,2,wf16(:,29),wf4(:,3))
  call Hloop_QV_A(ntryL,G0H64(1),wf16(:,29),G0H4(346),m3h16x4(:,1543),heltab2x64(:,:,6510))
  call Hloop_Q_A(ntryL,G0H4(346),43,0,G1H4(1473),n2h4(3984))
  Gcoeff(:)%j = (c(22)*(M(20,:)%j-M(23,:)%j)) * den(609)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(8914),h0tab(:,8914),[43,20],[nMT,nMT],2,2,wf16(:,29),wf4(:,3))
  call Hloop_QV_A(ntryL,G0H64(1),wf16(:,29),G0H4(346),m3h16x4(:,1544),heltab2x64(:,:,6511))
  call Hloop_Q_A(ntryL,G0H4(346),43,nMT,G1H4(372),n2h4(3985))
  Gcoeff(:)%j = (c(24)*(M(20,:)%j-M(23,:)%j)) * den(609)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(8915),h0tab(:,8915),[43,20],[0,0],2,2,wf16(:,29),wf4(:,3))
  call Hloop_QV_A(ntryL,G0H64(1),wf16(:,29),G0H4(346),m3h16x4(:,1545),heltab2x64(:,:,6512))
  call Hloop_Q_A(ntryL,G0H4(346),43,0,G1H4(2781),n2h4(3986))
  Gcoeff(:)%j = (c(22)*(M(20,:)%j-M(23,:)%j)) * den(609)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(8916),h0tab(:,8916),[43,20],[nMB,nMB],2,2,wf16(:,29),wf4(:,3))
  call Hloop_QV_A(ntryL,G0H64(1),wf16(:,29),G0H4(346),m3h16x4(:,1546),heltab2x64(:,:,6513))
  call Hloop_Q_A(ntryL,G0H4(346),43,nMB,G1H4(38),n2h4(3987))
  Gcoeff(:)%j = (c(10)*(M(20,:)%j-M(23,:)%j)) * den(609)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(8917),h0tab(:,8917),[43,20],[0,0],2,2,wf16(:,29),wf4(:,3))
  call Hloop_CV_D(ntryL,G0H64(1),0,wf16(:,29),43,G1H4(2876),m3h16x4(:,1547),heltab2x64(:,:,6514))
  Gcoeff(:)%j = (c(4)*(-M(20,:)%j+M(23,:)%j)) * den(609)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(8918),h0tab(:,8918),[43,20],[0,0],2,2,wf16(:,29),wf4(:,3))
  call Hloop_UV_W(ntryL,G0H64(1),0,wf16(:,29),43,G1H4(349),m3h16x4(:,1548),heltab2x64(:,:,6515))
  Gcoeff(:)%j = (c(8)*(-M(20,:)%j+M(23,:)%j)) * den(607)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(8919),h0tab(:,8919),[34,29],[0,nMT],2,2,wf4(:,23),wf16(:,230))
  call Hloop_QA_V(ntryL,G0H64(1),wf4(:,23),G0H16(361),m3h4x16(:,1138),heltab2x64(:,:,6516))
  Gcoeff(:)%j = (c(8)*(-M(20,:)%j+M(23,:)%j)) * den(604)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(8920),h0tab(:,8920),[54,9],[nMT,0],2,2,wf16(:,228),wf4(:,13))
  call Hloop_VA_Q(ntryL,G0H64(1),wf16(:,228),G0H4(346),m3h16x4(:,1549),heltab2x64(:,:,6517))
  call Hloop_A_Q(ntryL,G0H4(346),54,nMT,G1H4(2957),n2h4(3988))
  Gcoeff(:)%j = (c(28)*(M(4,:)%j-M(14,:)%j-M(20,:)%j+M(23,:)%j)) * den(1075)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(8921),h0tab(:,8921),[43,20],[0,0],2,2,wf16(:,297),wf4(:,3))
  call Hloop_QV_A(ntryL,G0H64(1),wf16(:,297),G0H4(346),m3h16x4(:,1550),heltab2x64(:,:,6518))
  call Hloop_Q_A(ntryL,G0H4(346),43,0,G1H4(265),n2h4(3989))
  Gcoeff(:)%j = (c(26)*(M(4,:)%j-M(14,:)%j-M(20,:)%j+M(23,:)%j)) * den(1075)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(8922),h0tab(:,8922),[43,20],[nMT,nMT],2,2,wf16(:,297),wf4(:,3))
  call Hloop_QV_A(ntryL,G0H64(1),wf16(:,297),G0H4(346),m3h16x4(:,1551),heltab2x64(:,:,6519))
  call Hloop_Q_A(ntryL,G0H4(346),43,nMT,G1H4(3062),n2h4(3990))
  Gcoeff(:)%j = (c(28)*(M(4,:)%j-M(14,:)%j-M(20,:)%j+M(23,:)%j)) * den(1075)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(8923),h0tab(:,8923),[43,20],[0,0],2,2,wf16(:,297),wf4(:,3))
  call Hloop_QV_A(ntryL,G0H64(1),wf16(:,297),G0H4(346),m3h16x4(:,1552),heltab2x64(:,:,6520))
  call Hloop_Q_A(ntryL,G0H4(346),43,0,G1H4(589),n2h4(3991))
  Gcoeff(:)%j = (c(26)*(M(4,:)%j-M(14,:)%j-M(20,:)%j+M(23,:)%j)) * den(1075)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(8924),h0tab(:,8924),[43,20],[nMB,nMB],2,2,wf16(:,297),wf4(:,3))
  call Hloop_QV_A(ntryL,G0H64(1),wf16(:,297),G0H4(346),m3h16x4(:,1553),heltab2x64(:,:,6521))
  call Hloop_Q_A(ntryL,G0H4(346),43,nMB,G1H4(3158),n2h4(3992))
  Gcoeff(:)%j = (c(20)*(M(4,:)%j-M(14,:)%j-M(20,:)%j+M(23,:)%j)) * den(1075)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(8925),h0tab(:,8925),[43,20],[0,0],2,2,wf16(:,297),wf4(:,3))
  call Hloop_CV_D(ntryL,G0H64(1),0,wf16(:,297),43,G1H4(524),m3h16x4(:,1554),heltab2x64(:,:,6522))
  Gcoeff(:)%j = (c(14)*(-M(4,:)%j+M(14,:)%j+M(20,:)%j-M(23,:)%j)) * den(1075)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(8926),h0tab(:,8926),[43,20],[0,0],2,2,wf16(:,297),wf4(:,3))
  call Hloop_UV_W(ntryL,G0H64(1),0,wf16(:,297),43,G1H4(3268),m3h16x4(:,1555),heltab2x64(:,:,6523))
  Gcoeff(:)%j = (c(28)*(-M(4,:)%j+M(14,:)%j+M(20,:)%j-M(23,:)%j)) * den(613)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(8927),h0tab(:,8927),[52,11],[0,0],2,2,wf8(:,27),wf8(:,19))
  call Hloop_QV_A(ntryL,G0H64(1),wf8(:,27),G0H8(214),m3h8x8(:,1299),heltab2x64(:,:,6524))
  call Hloop_Q_A(ntryL,G0H8(214),52,0,G1H8(620),n2h8(3027))
  Gcoeff(:)%j = (c(26)*(-M(4,:)%j+M(14,:)%j+M(20,:)%j-M(23,:)%j)) * den(613)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(8928),h0tab(:,8928),[52,11],[nMT,nMT],2,2,wf8(:,27),wf8(:,19))
  call Hloop_QV_A(ntryL,G0H64(1),wf8(:,27),G0H8(214),m3h8x8(:,1300),heltab2x64(:,:,6525))
  call Hloop_Q_A(ntryL,G0H8(214),52,nMT,G1H8(1339),n2h8(3028))
  Gcoeff(:)%j = (c(28)*(-M(4,:)%j+M(14,:)%j+M(20,:)%j-M(23,:)%j)) * den(613)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(8929),h0tab(:,8929),[52,11],[0,0],2,2,wf8(:,27),wf8(:,19))
  call Hloop_QV_A(ntryL,G0H64(1),wf8(:,27),G0H8(214),m3h8x8(:,1301),heltab2x64(:,:,6526))
  call Hloop_Q_A(ntryL,G0H8(214),52,0,G1H8(301),n2h8(3029))
  Gcoeff(:)%j = (c(26)*(-M(4,:)%j+M(14,:)%j+M(20,:)%j-M(23,:)%j)) * den(613)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(8930),h0tab(:,8930),[52,11],[nMB,nMB],2,2,wf8(:,27),wf8(:,19))
  call Hloop_QV_A(ntryL,G0H64(1),wf8(:,27),G0H8(214),m3h8x8(:,1302),heltab2x64(:,:,6527))
  call Hloop_Q_A(ntryL,G0H8(214),52,nMB,G1H8(29),n2h8(3030))
  Gcoeff(:)%j = (c(20)*(-M(4,:)%j+M(14,:)%j+M(20,:)%j-M(23,:)%j)) * den(613)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(8931),h0tab(:,8931),[52,11],[0,0],2,2,wf8(:,27),wf8(:,19))
  call Hloop_CV_D(ntryL,G0H64(1),0,wf8(:,27),52,G1H8(711),m3h8x8(:,1303),heltab2x64(:,:,6528))
  Gcoeff(:)%j = (c(14)*(M(4,:)%j-M(14,:)%j-M(20,:)%j+M(23,:)%j)) * den(613)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(8932),h0tab(:,8932),[52,11],[0,0],2,2,wf8(:,27),wf8(:,19))
  call Hloop_UV_W(ntryL,G0H64(1),0,wf8(:,27),52,G1H8(693),m3h8x8(:,1304),heltab2x64(:,:,6529))
  Gcoeff(:)%j = (c(8)*(-M(4,:)%j+M(14,:)%j)) * den(614)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(8933),h0tab(:,8933),[41,22],[nMT,0],2,2,wf8(:,195),wf8(:,82))
  call Hloop_VQ_A(ntryL,G0H64(1),wf8(:,195),G0H8(214),m3h8x8(:,1305),heltab2x64(:,:,6530))
  call Hloop_Q_A(ntryL,G0H8(214),41,nMT,G1H8(639),n2h8(3031))
  Gcoeff(:)%j = (c(24)*(M(4,:)%j-M(14,:)%j)) * den(1076)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(8934),h0tab(:,8934),[43,20],[0,0],2,2,wf16(:,308),wf4(:,3))
  call Hloop_QV_A(ntryL,G0H64(1),wf16(:,308),G0H4(346),m3h16x4(:,1556),heltab2x64(:,:,6531))
  call Hloop_Q_A(ntryL,G0H4(346),43,0,G1H4(21),n2h4(3993))
  Gcoeff(:)%j = (c(22)*(M(4,:)%j-M(14,:)%j)) * den(1076)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(8935),h0tab(:,8935),[43,20],[nMT,nMT],2,2,wf16(:,308),wf4(:,3))
  call Hloop_QV_A(ntryL,G0H64(1),wf16(:,308),G0H4(346),m3h16x4(:,1557),heltab2x64(:,:,6532))
  call Hloop_Q_A(ntryL,G0H4(346),43,nMT,G1H4(3296),n2h4(3994))
  Gcoeff(:)%j = (c(24)*(M(4,:)%j-M(14,:)%j)) * den(1076)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(8936),h0tab(:,8936),[43,20],[0,0],2,2,wf16(:,308),wf4(:,3))
  call Hloop_QV_A(ntryL,G0H64(1),wf16(:,308),G0H4(346),m3h16x4(:,1558),heltab2x64(:,:,6533))
  call Hloop_Q_A(ntryL,G0H4(346),43,0,G1H4(587),n2h4(3995))
  Gcoeff(:)%j = (c(22)*(M(4,:)%j-M(14,:)%j)) * den(1076)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(8937),h0tab(:,8937),[43,20],[nMB,nMB],2,2,wf16(:,308),wf4(:,3))
  call Hloop_QV_A(ntryL,G0H64(1),wf16(:,308),G0H4(346),m3h16x4(:,1559),heltab2x64(:,:,6534))
  call Hloop_Q_A(ntryL,G0H4(346),43,nMB,G1H4(704),n2h4(3996))
  Gcoeff(:)%j = (c(10)*(M(4,:)%j-M(14,:)%j)) * den(1076)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(8938),h0tab(:,8938),[43,20],[0,0],2,2,wf16(:,308),wf4(:,3))
  call Hloop_CV_D(ntryL,G0H64(1),0,wf16(:,308),43,G1H4(793),m3h16x4(:,1560),heltab2x64(:,:,6535))
  Gcoeff(:)%j = (c(4)*(-M(4,:)%j+M(14,:)%j)) * den(1076)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(8939),h0tab(:,8939),[43,20],[0,0],2,2,wf16(:,308),wf4(:,3))
  call Hloop_UV_W(ntryL,G0H64(1),0,wf16(:,308),43,G1H4(746),m3h16x4(:,1561),heltab2x64(:,:,6536))
  Gcoeff(:)%j = (c(8)*(-M(4,:)%j+M(14,:)%j)) * den(1077)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(8940),h0tab(:,8940),[54,9],[nMT,0],2,2,wf16(:,400),wf4(:,13))
  call Hloop_VA_Q(ntryL,G0H64(1),wf16(:,400),G0H4(346),m3h16x4(:,1562),heltab2x64(:,:,6537))
  call Hloop_A_Q(ntryL,G0H4(346),54,nMT,G1H4(423),n2h4(3997))
  Gcoeff(:)%j = (c(18)*(M(4,:)%j-M(14,:)%j-M(20,:)%j+M(23,:)%j)) * den(1078)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(8941),h0tab(:,8941),[54,9],[nMT,0],2,2,wf16(:,404),wf4(:,13))
  call Hloop_VA_Q(ntryL,G0H64(1),wf16(:,404),G0H4(346),m3h16x4(:,1563),heltab2x64(:,:,6538))
  call Hloop_A_Q(ntryL,G0H4(346),54,nMT,G1H4(841),n2h4(3998))
  Gcoeff(:)%j = (c(18)*M(23,:)%j) * den(620)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(8942),h0tab(:,8942),[50,13],[nMT,0],2,2,wf8(:,187),wf8(:,78))
  call Hloop_VA_Q(ntryL,G0H64(1),wf8(:,187),G0H8(214),m3h8x8(:,1306),heltab2x64(:,:,6539))
  call Hloop_A_Q(ntryL,G0H8(214),50,nMT,G1H8(898),n2h8(3032))
  Gcoeff(:)%j = (c(18)*M(23,:)%j) * den(1079)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(8943),h0tab(:,8943),[34,29],[0,nMT],2,2,wf4(:,23),wf16(:,300))
  call Hloop_QA_V(ntryL,G0H64(1),wf4(:,23),G0H16(362),m3h4x16(:,1139),heltab2x64(:,:,6540))
  Gcoeff(:)%j = (c(18)*M(20,:)%j) * den(621)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(8944),h0tab(:,8944),[38,25],[0,nMT],2,2,wf8(:,84),wf8(:,59))
  call Hloop_QA_V(ntryL,G0H64(1),wf8(:,84),G0H8(214),m3h8x8(:,1307),heltab2x64(:,:,6541))
  Gcoeff(:)%j = (c(18)*M(20,:)%j) * den(1080)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(8945),h0tab(:,8945),[34,29],[0,nMT],2,2,wf4(:,23),wf16(:,305))
  call Hloop_QA_V(ntryL,G0H64(1),wf4(:,23),G0H16(363),m3h4x16(:,1140),heltab2x64(:,:,6542))
  Gcoeff(:)%j = (c(18)*M(20,:)%j) * den(1081)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(8946),h0tab(:,8946),[54,9],[nMT,0],2,2,wf16(:,454),wf4(:,13))
  call Hloop_VA_Q(ntryL,G0H64(1),wf16(:,454),G0H4(346),m3h16x4(:,1564),heltab2x64(:,:,6543))
  call Hloop_A_Q(ntryL,G0H4(346),54,nMT,G1H4(1091),n2h4(3999))
  Gcoeff(:)%j = (c(18)*M(23,:)%j) * den(1082)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(8947),h0tab(:,8947),[54,9],[nMT,0],2,2,wf16(:,460),wf4(:,13))
  call Hloop_VA_Q(ntryL,G0H64(1),wf16(:,460),G0H4(346),m3h16x4(:,1565),heltab2x64(:,:,6544))
  call Hloop_A_Q(ntryL,G0H4(346),54,nMT,G1H4(883),n2h4(4000))
  Gcoeff(:)%j = (c(28)*(M(6,:)%j-M(14,:)%j+M(17,:)%j-M(20,:)%j)) * den(1083)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(8948),h0tab(:,8948),[36,27],[0,0],2,2,wf4(:,4),wf16(:,296))
  call Hloop_QV_A(ntryL,G0H64(1),wf4(:,4),G0H16(364),m3h4x16(:,1141),heltab2x64(:,:,6545))
  call Hloop_Q_A(ntryL,G0H16(364),36,0,G1H16(1159),n2h16(1849))
  Gcoeff(:)%j = (c(26)*(M(6,:)%j-M(14,:)%j+M(17,:)%j-M(20,:)%j)) * den(1083)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(8949),h0tab(:,8949),[36,27],[nMT,nMT],2,2,wf4(:,4),wf16(:,296))
  call Hloop_QV_A(ntryL,G0H64(1),wf4(:,4),G0H16(364),m3h4x16(:,1142),heltab2x64(:,:,6546))
  call Hloop_Q_A(ntryL,G0H16(364),36,nMT,G1H16(1160),n2h16(1850))
  Gcoeff(:)%j = (c(28)*(M(6,:)%j-M(14,:)%j+M(17,:)%j-M(20,:)%j)) * den(1083)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(8950),h0tab(:,8950),[36,27],[0,0],2,2,wf4(:,4),wf16(:,296))
  call Hloop_QV_A(ntryL,G0H64(1),wf4(:,4),G0H16(364),m3h4x16(:,1143),heltab2x64(:,:,6547))
  call Hloop_Q_A(ntryL,G0H16(364),36,0,G1H16(1162),n2h16(1851))
  Gcoeff(:)%j = (c(26)*(M(6,:)%j-M(14,:)%j+M(17,:)%j-M(20,:)%j)) * den(1083)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(8951),h0tab(:,8951),[36,27],[nMB,nMB],2,2,wf4(:,4),wf16(:,296))
  call Hloop_QV_A(ntryL,G0H64(1),wf4(:,4),G0H16(364),m3h4x16(:,1144),heltab2x64(:,:,6548))
  call Hloop_Q_A(ntryL,G0H16(364),36,nMB,G1H16(1163),n2h16(1852))
  Gcoeff(:)%j = (c(20)*(M(6,:)%j-M(14,:)%j+M(17,:)%j-M(20,:)%j)) * den(1083)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(8952),h0tab(:,8952),[36,27],[0,0],2,2,wf4(:,4),wf16(:,296))
  call Hloop_CV_D(ntryL,G0H64(1),0,wf4(:,4),36,G1H16(1164),m3h4x16(:,1145),heltab2x64(:,:,6549))
  Gcoeff(:)%j = (c(14)*(-M(6,:)%j+M(14,:)%j-M(17,:)%j+M(20,:)%j)) * den(1083)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(8953),h0tab(:,8953),[36,27],[0,0],2,2,wf4(:,4),wf16(:,296))
  call Hloop_UV_W(ntryL,G0H64(1),0,wf4(:,4),36,G1H16(1165),m3h4x16(:,1146),heltab2x64(:,:,6550))
  Gcoeff(:)%j = (c(28)*(M(6,:)%j-M(14,:)%j+M(17,:)%j-M(20,:)%j)) * den(625)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(8954),h0tab(:,8954),[52,11],[0,0],2,2,wf8(:,31),wf8(:,19))
  call Hloop_QV_A(ntryL,G0H64(1),wf8(:,31),G0H8(215),m3h8x8(:,1308),heltab2x64(:,:,6551))
  call Hloop_Q_A(ntryL,G0H8(215),52,0,G1H8(359),n2h8(3033))
  Gcoeff(:)%j = (c(26)*(M(6,:)%j-M(14,:)%j+M(17,:)%j-M(20,:)%j)) * den(625)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(8955),h0tab(:,8955),[52,11],[nMT,nMT],2,2,wf8(:,31),wf8(:,19))
  call Hloop_QV_A(ntryL,G0H64(1),wf8(:,31),G0H8(215),m3h8x8(:,1309),heltab2x64(:,:,6552))
  call Hloop_Q_A(ntryL,G0H8(215),52,nMT,G1H8(1361),n2h8(3034))
  Gcoeff(:)%j = (c(28)*(M(6,:)%j-M(14,:)%j+M(17,:)%j-M(20,:)%j)) * den(625)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(8956),h0tab(:,8956),[52,11],[0,0],2,2,wf8(:,31),wf8(:,19))
  call Hloop_QV_A(ntryL,G0H64(1),wf8(:,31),G0H8(215),m3h8x8(:,1310),heltab2x64(:,:,6553))
  call Hloop_Q_A(ntryL,G0H8(215),52,0,G1H8(238),n2h8(3035))
  Gcoeff(:)%j = (c(26)*(M(6,:)%j-M(14,:)%j+M(17,:)%j-M(20,:)%j)) * den(625)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(8957),h0tab(:,8957),[52,11],[nMB,nMB],2,2,wf8(:,31),wf8(:,19))
  call Hloop_QV_A(ntryL,G0H64(1),wf8(:,31),G0H8(215),m3h8x8(:,1311),heltab2x64(:,:,6554))
  call Hloop_Q_A(ntryL,G0H8(215),52,nMB,G1H8(62),n2h8(3036))
  Gcoeff(:)%j = (c(20)*(M(6,:)%j-M(14,:)%j+M(17,:)%j-M(20,:)%j)) * den(625)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(8958),h0tab(:,8958),[52,11],[0,0],2,2,wf8(:,31),wf8(:,19))
  call Hloop_CV_D(ntryL,G0H64(1),0,wf8(:,31),52,G1H8(156),m3h8x8(:,1312),heltab2x64(:,:,6555))
  Gcoeff(:)%j = (c(14)*(-M(6,:)%j+M(14,:)%j-M(17,:)%j+M(20,:)%j)) * den(625)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(8959),h0tab(:,8959),[52,11],[0,0],2,2,wf8(:,31),wf8(:,19))
  call Hloop_UV_W(ntryL,G0H64(1),0,wf8(:,31),52,G1H8(85),m3h8x8(:,1313),heltab2x64(:,:,6556))
  Gcoeff(:)%j = (c(8)*(-M(6,:)%j+M(20,:)%j)) * den(626)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(8960),h0tab(:,8960),[38,25],[0,nMT],2,2,wf8(:,86),wf8(:,59))
  call Hloop_QA_V(ntryL,G0H64(1),wf8(:,86),G0H8(215),m3h8x8(:,1314),heltab2x64(:,:,6557))
  Gcoeff(:)%j = (c(24)*(M(6,:)%j-M(20,:)%j)) * den(1084)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(8961),h0tab(:,8961),[36,27],[0,0],2,2,wf4(:,4),wf16(:,303))
  call Hloop_QV_A(ntryL,G0H64(1),wf4(:,4),G0H16(364),m3h4x16(:,1147),heltab2x64(:,:,6558))
  call Hloop_Q_A(ntryL,G0H16(364),36,0,G1H16(1167),n2h16(1853))
  Gcoeff(:)%j = (c(22)*(M(6,:)%j-M(20,:)%j)) * den(1084)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(8962),h0tab(:,8962),[36,27],[nMT,nMT],2,2,wf4(:,4),wf16(:,303))
  call Hloop_QV_A(ntryL,G0H64(1),wf4(:,4),G0H16(364),m3h4x16(:,1148),heltab2x64(:,:,6559))
  call Hloop_Q_A(ntryL,G0H16(364),36,nMT,G1H16(1168),n2h16(1854))
  Gcoeff(:)%j = (c(24)*(M(6,:)%j-M(20,:)%j)) * den(1084)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(8963),h0tab(:,8963),[36,27],[0,0],2,2,wf4(:,4),wf16(:,303))
  call Hloop_QV_A(ntryL,G0H64(1),wf4(:,4),G0H16(364),m3h4x16(:,1149),heltab2x64(:,:,6560))
  call Hloop_Q_A(ntryL,G0H16(364),36,0,G1H16(746),n2h16(1855))
  Gcoeff(:)%j = (c(22)*(M(6,:)%j-M(20,:)%j)) * den(1084)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(8964),h0tab(:,8964),[36,27],[nMB,nMB],2,2,wf4(:,4),wf16(:,303))
  call Hloop_QV_A(ntryL,G0H64(1),wf4(:,4),G0H16(364),m3h4x16(:,1150),heltab2x64(:,:,6561))
  call Hloop_Q_A(ntryL,G0H16(364),36,nMB,G1H16(1169),n2h16(1856))
  Gcoeff(:)%j = (c(10)*(M(6,:)%j-M(20,:)%j)) * den(1084)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(8965),h0tab(:,8965),[36,27],[0,0],2,2,wf4(:,4),wf16(:,303))
  call Hloop_CV_D(ntryL,G0H64(1),0,wf4(:,4),36,G1H16(1171),m3h4x16(:,1151),heltab2x64(:,:,6562))
  Gcoeff(:)%j = (c(4)*(-M(6,:)%j+M(20,:)%j)) * den(1084)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(8966),h0tab(:,8966),[36,27],[0,0],2,2,wf4(:,4),wf16(:,303))
  call Hloop_UV_W(ntryL,G0H64(1),0,wf4(:,4),36,G1H16(1172),m3h4x16(:,1152),heltab2x64(:,:,6563))
  Gcoeff(:)%j = (c(8)*(-M(6,:)%j+M(20,:)%j)) * den(1085)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(8967),h0tab(:,8967),[54,9],[nMT,0],2,2,wf16(:,476),wf4(:,13))
  call Hloop_VA_Q(ntryL,G0H64(1),wf16(:,476),G0H4(346),m3h16x4(:,1566),heltab2x64(:,:,6564))
  call Hloop_A_Q(ntryL,G0H4(346),54,nMT,G1H4(966),n2h4(4001))
  Gcoeff(:)%j = (c(18)*(-M(6,:)%j+M(14,:)%j-M(17,:)%j+M(20,:)%j)) * den(1086)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(8968),h0tab(:,8968),[54,9],[nMT,0],2,2,wf16(:,480),wf4(:,13))
  call Hloop_VA_Q(ntryL,G0H64(1),wf16(:,480),G0H4(346),m3h16x4(:,1567),heltab2x64(:,:,6565))
  call Hloop_A_Q(ntryL,G0H4(346),54,nMT,G1H4(925),n2h4(4002))
  Gcoeff(:)%j = (c(28)*(M(4,:)%j-M(6,:)%j-M(17,:)%j+M(23,:)%j)) * den(1087)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(8969),h0tab(:,8969),[48,15],[0,0],2,2,wf4(:,7),wf16(:,295))
  call Hloop_QV_A(ntryL,G0H64(1),wf4(:,7),G0H16(364),m3h4x16(:,1153),heltab2x64(:,:,6566))
  call Hloop_Q_A(ntryL,G0H16(364),48,0,G1H16(748),n2h16(1857))
  Gcoeff(:)%j = (c(26)*(M(4,:)%j-M(6,:)%j-M(17,:)%j+M(23,:)%j)) * den(1087)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(8970),h0tab(:,8970),[48,15],[nMT,nMT],2,2,wf4(:,7),wf16(:,295))
  call Hloop_QV_A(ntryL,G0H64(1),wf4(:,7),G0H16(364),m3h4x16(:,1154),heltab2x64(:,:,6567))
  call Hloop_Q_A(ntryL,G0H16(364),48,nMT,G1H16(1173),n2h16(1858))
  Gcoeff(:)%j = (c(28)*(M(4,:)%j-M(6,:)%j-M(17,:)%j+M(23,:)%j)) * den(1087)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(8971),h0tab(:,8971),[48,15],[0,0],2,2,wf4(:,7),wf16(:,295))
  call Hloop_QV_A(ntryL,G0H64(1),wf4(:,7),G0H16(364),m3h4x16(:,1155),heltab2x64(:,:,6568))
  call Hloop_Q_A(ntryL,G0H16(364),48,0,G1H16(1175),n2h16(1859))
  Gcoeff(:)%j = (c(26)*(M(4,:)%j-M(6,:)%j-M(17,:)%j+M(23,:)%j)) * den(1087)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(8972),h0tab(:,8972),[48,15],[nMB,nMB],2,2,wf4(:,7),wf16(:,295))
  call Hloop_QV_A(ntryL,G0H64(1),wf4(:,7),G0H16(364),m3h4x16(:,1156),heltab2x64(:,:,6569))
  call Hloop_Q_A(ntryL,G0H16(364),48,nMB,G1H16(1176),n2h16(1860))
  Gcoeff(:)%j = (c(20)*(M(4,:)%j-M(6,:)%j-M(17,:)%j+M(23,:)%j)) * den(1087)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(8973),h0tab(:,8973),[48,15],[0,0],2,2,wf4(:,7),wf16(:,295))
  call Hloop_CV_D(ntryL,G0H64(1),0,wf4(:,7),48,G1H16(750),m3h4x16(:,1157),heltab2x64(:,:,6570))
  Gcoeff(:)%j = (c(14)*(-M(4,:)%j+M(6,:)%j+M(17,:)%j-M(23,:)%j)) * den(1087)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(8974),h0tab(:,8974),[48,15],[0,0],2,2,wf4(:,7),wf16(:,295))
  call Hloop_UV_W(ntryL,G0H64(1),0,wf4(:,7),48,G1H16(1177),m3h4x16(:,1158),heltab2x64(:,:,6571))
  Gcoeff(:)%j = (c(28)*(-M(4,:)%j+M(6,:)%j+M(17,:)%j-M(23,:)%j)) * den(630)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(8975),h0tab(:,8975),[52,11],[0,0],2,2,wf8(:,36),wf8(:,19))
  call Hloop_QV_A(ntryL,G0H64(1),wf8(:,36),G0H8(216),m3h8x8(:,1315),heltab2x64(:,:,6572))
  call Hloop_Q_A(ntryL,G0H8(216),52,0,G1H8(175),n2h8(3037))
  Gcoeff(:)%j = (c(26)*(-M(4,:)%j+M(6,:)%j+M(17,:)%j-M(23,:)%j)) * den(630)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(8976),h0tab(:,8976),[52,11],[nMT,nMT],2,2,wf8(:,36),wf8(:,19))
  call Hloop_QV_A(ntryL,G0H64(1),wf8(:,36),G0H8(216),m3h8x8(:,1316),heltab2x64(:,:,6573))
  call Hloop_Q_A(ntryL,G0H8(216),52,nMT,G1H8(119),n2h8(3038))
  Gcoeff(:)%j = (c(28)*(-M(4,:)%j+M(6,:)%j+M(17,:)%j-M(23,:)%j)) * den(630)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(8977),h0tab(:,8977),[52,11],[0,0],2,2,wf8(:,36),wf8(:,19))
  call Hloop_QV_A(ntryL,G0H64(1),wf8(:,36),G0H8(216),m3h8x8(:,1317),heltab2x64(:,:,6574))
  call Hloop_Q_A(ntryL,G0H8(216),52,0,G1H8(500),n2h8(3039))
  Gcoeff(:)%j = (c(26)*(-M(4,:)%j+M(6,:)%j+M(17,:)%j-M(23,:)%j)) * den(630)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(8978),h0tab(:,8978),[52,11],[nMB,nMB],2,2,wf8(:,36),wf8(:,19))
  call Hloop_QV_A(ntryL,G0H64(1),wf8(:,36),G0H8(216),m3h8x8(:,1318),heltab2x64(:,:,6575))
  call Hloop_Q_A(ntryL,G0H8(216),52,nMB,G1H8(1378),n2h8(3040))
  Gcoeff(:)%j = (c(20)*(-M(4,:)%j+M(6,:)%j+M(17,:)%j-M(23,:)%j)) * den(630)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(8979),h0tab(:,8979),[52,11],[0,0],2,2,wf8(:,36),wf8(:,19))
  call Hloop_CV_D(ntryL,G0H64(1),0,wf8(:,36),52,G1H8(207),m3h8x8(:,1319),heltab2x64(:,:,6576))
  Gcoeff(:)%j = (c(14)*(M(4,:)%j-M(6,:)%j-M(17,:)%j+M(23,:)%j)) * den(630)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(8980),h0tab(:,8980),[52,11],[0,0],2,2,wf8(:,36),wf8(:,19))
  call Hloop_UV_W(ntryL,G0H64(1),0,wf8(:,36),52,G1H8(110),m3h8x8(:,1320),heltab2x64(:,:,6577))
  Gcoeff(:)%j = (c(24)*(M(17,:)%j-M(23,:)%j)) * den(1088)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(8981),h0tab(:,8981),[48,15],[0,0],2,2,wf4(:,7),wf16(:,298))
  call Hloop_QV_A(ntryL,G0H64(1),wf4(:,7),G0H16(364),m3h4x16(:,1159),heltab2x64(:,:,6578))
  call Hloop_Q_A(ntryL,G0H16(364),48,0,G1H16(1179),n2h16(1861))
  Gcoeff(:)%j = (c(22)*(M(17,:)%j-M(23,:)%j)) * den(1088)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(8982),h0tab(:,8982),[48,15],[nMT,nMT],2,2,wf4(:,7),wf16(:,298))
  call Hloop_QV_A(ntryL,G0H64(1),wf4(:,7),G0H16(364),m3h4x16(:,1160),heltab2x64(:,:,6579))
  call Hloop_Q_A(ntryL,G0H16(364),48,nMT,G1H16(1180),n2h16(1862))
  Gcoeff(:)%j = (c(24)*(M(17,:)%j-M(23,:)%j)) * den(1088)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(8983),h0tab(:,8983),[48,15],[0,0],2,2,wf4(:,7),wf16(:,298))
  call Hloop_QV_A(ntryL,G0H64(1),wf4(:,7),G0H16(364),m3h4x16(:,1161),heltab2x64(:,:,6580))
  call Hloop_Q_A(ntryL,G0H16(364),48,0,G1H16(752),n2h16(1863))
  Gcoeff(:)%j = (c(22)*(M(17,:)%j-M(23,:)%j)) * den(1088)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(8984),h0tab(:,8984),[48,15],[nMB,nMB],2,2,wf4(:,7),wf16(:,298))
  call Hloop_QV_A(ntryL,G0H64(1),wf4(:,7),G0H16(364),m3h4x16(:,1162),heltab2x64(:,:,6581))
  call Hloop_Q_A(ntryL,G0H16(364),48,nMB,G1H16(1181),n2h16(1864))
  Gcoeff(:)%j = (c(10)*(M(17,:)%j-M(23,:)%j)) * den(1088)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(8985),h0tab(:,8985),[48,15],[0,0],2,2,wf4(:,7),wf16(:,298))
  call Hloop_CV_D(ntryL,G0H64(1),0,wf4(:,7),48,G1H16(1183),m3h4x16(:,1163),heltab2x64(:,:,6582))
  Gcoeff(:)%j = (c(4)*(-M(17,:)%j+M(23,:)%j)) * den(1088)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(8986),h0tab(:,8986),[48,15],[0,0],2,2,wf4(:,7),wf16(:,298))
  call Hloop_UV_W(ntryL,G0H64(1),0,wf4(:,7),48,G1H16(1184),m3h4x16(:,1164),heltab2x64(:,:,6583))
  Gcoeff(:)%j = (c(8)*(-M(17,:)%j+M(23,:)%j)) * den(631)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(8987),h0tab(:,8987),[50,13],[0,nMT],2,2,wf8(:,56),wf8(:,78))
  call Hloop_QA_V(ntryL,G0H64(1),wf8(:,56),G0H8(216),m3h8x8(:,1321),heltab2x64(:,:,6584))
  Gcoeff(:)%j = (c(8)*(-M(17,:)%j+M(23,:)%j)) * den(1089)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(8988),h0tab(:,8988),[54,9],[nMT,0],2,2,wf16(:,514),wf4(:,13))
  call Hloop_VA_Q(ntryL,G0H64(1),wf16(:,514),G0H4(346),m3h16x4(:,1568),heltab2x64(:,:,6585))
  call Hloop_A_Q(ntryL,G0H4(346),54,nMT,G1H4(597),n2h4(4003))
  Gcoeff(:)%j = (c(18)*(M(4,:)%j-M(6,:)%j-M(17,:)%j+M(23,:)%j)) * den(1090)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(8989),h0tab(:,8989),[54,9],[nMT,0],2,2,wf16(:,516),wf4(:,13))
  call Hloop_VA_Q(ntryL,G0H64(1),wf16(:,516),G0H4(346),m3h16x4(:,1569),heltab2x64(:,:,6586))
  call Hloop_A_Q(ntryL,G0H4(346),54,nMT,G1H4(1004),n2h4(4004))
  Gcoeff(:)%j = (c(24)*(M(8,:)%j-M(11,:)%j)) * den(641)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(8990),h0tab(:,8990),[36,27],[0,0],2,2,wf4(:,4),wf16(:,30))
  call Hloop_QV_A(ntryL,G0H64(1),wf4(:,4),G0H16(364),m3h4x16(:,1165),heltab2x64(:,:,6587))
  call Hloop_Q_A(ntryL,G0H16(364),36,0,G1H16(756),n2h16(1865))
  Gcoeff(:)%j = (c(22)*(M(8,:)%j-M(11,:)%j)) * den(641)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(8991),h0tab(:,8991),[36,27],[nMT,nMT],2,2,wf4(:,4),wf16(:,30))
  call Hloop_QV_A(ntryL,G0H64(1),wf4(:,4),G0H16(364),m3h4x16(:,1166),heltab2x64(:,:,6588))
  call Hloop_Q_A(ntryL,G0H16(364),36,nMT,G1H16(1185),n2h16(1866))
  Gcoeff(:)%j = (c(24)*(M(8,:)%j-M(11,:)%j)) * den(641)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(8992),h0tab(:,8992),[36,27],[0,0],2,2,wf4(:,4),wf16(:,30))
  call Hloop_QV_A(ntryL,G0H64(1),wf4(:,4),G0H16(364),m3h4x16(:,1167),heltab2x64(:,:,6589))
  call Hloop_Q_A(ntryL,G0H16(364),36,0,G1H16(1187),n2h16(1867))
  Gcoeff(:)%j = (c(22)*(M(8,:)%j-M(11,:)%j)) * den(641)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(8993),h0tab(:,8993),[36,27],[nMB,nMB],2,2,wf4(:,4),wf16(:,30))
  call Hloop_QV_A(ntryL,G0H64(1),wf4(:,4),G0H16(364),m3h4x16(:,1168),heltab2x64(:,:,6590))
  call Hloop_Q_A(ntryL,G0H16(364),36,nMB,G1H16(1188),n2h16(1868))
  Gcoeff(:)%j = (c(10)*(M(8,:)%j-M(11,:)%j)) * den(641)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(8994),h0tab(:,8994),[36,27],[0,0],2,2,wf4(:,4),wf16(:,30))
  call Hloop_CV_D(ntryL,G0H64(1),0,wf4(:,4),36,G1H16(758),m3h4x16(:,1169),heltab2x64(:,:,6591))
  Gcoeff(:)%j = (c(4)*(-M(8,:)%j+M(11,:)%j)) * den(641)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(8995),h0tab(:,8995),[36,27],[0,0],2,2,wf4(:,4),wf16(:,30))
  call Hloop_UV_W(ntryL,G0H64(1),0,wf4(:,4),36,G1H16(1189),m3h4x16(:,1170),heltab2x64(:,:,6592))
  Gcoeff(:)%j = (c(8)*(-M(8,:)%j+M(11,:)%j)) * den(639)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(8996),h0tab(:,8996),[53,10],[nMT,0],2,2,wf16(:,234),wf4(:,15))
  call Hloop_VQ_A(ntryL,G0H64(1),wf16(:,234),G0H4(346),m3h16x4(:,1570),heltab2x64(:,:,6593))
  call Hloop_Q_A(ntryL,G0H4(346),53,nMT,G1H4(358),n2h4(4005))
  Gcoeff(:)%j = (c(8)*(-M(8,:)%j+M(11,:)%j)) * den(636)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(8997),h0tab(:,8997),[46,17],[nMT,0],2,2,wf16(:,232),wf4(:,17))
  call Hloop_VA_Q(ntryL,G0H64(1),wf16(:,232),G0H4(346),m3h16x4(:,1571),heltab2x64(:,:,6594))
  call Hloop_A_Q(ntryL,G0H4(346),46,nMT,G1H4(339),n2h4(4006))
  Gcoeff(:)%j = (c(18)*M(11,:)%j) * den(646)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(8998),h0tab(:,8998),[42,21],[nMT,0],2,2,wf8(:,178),wf8(:,88))
  call Hloop_VA_Q(ntryL,G0H64(1),wf8(:,178),G0H8(217),m3h8x8(:,1322),heltab2x64(:,:,6595))
  call Hloop_A_Q(ntryL,G0H8(217),42,nMT,G1H8(113),n2h8(3041))
  Gcoeff(:)%j = (c(18)*M(11,:)%j) * den(1091)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(8999),h0tab(:,8999),[53,10],[nMT,0],2,2,wf16(:,358),wf4(:,15))
  call Hloop_VQ_A(ntryL,G0H64(1),wf16(:,358),G0H4(346),m3h16x4(:,1572),heltab2x64(:,:,6596))
  call Hloop_Q_A(ntryL,G0H4(346),53,nMT,G1H4(2493),n2h4(4007))
  Gcoeff(:)%j = (c(18)*M(8,:)%j) * den(647)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(9000),h0tab(:,9000),[49,14],[nMT,0],2,2,wf8(:,203),wf8(:,90))
  call Hloop_VQ_A(ntryL,G0H64(1),wf8(:,203),G0H8(217),m3h8x8(:,1323),heltab2x64(:,:,6597))
  call Hloop_Q_A(ntryL,G0H8(217),49,nMT,G1H8(3),n2h8(3042))
  Gcoeff(:)%j = (c(18)*M(8,:)%j) * den(1092)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(9001),h0tab(:,9001),[53,10],[nMT,0],2,2,wf16(:,366),wf4(:,15))
  call Hloop_VQ_A(ntryL,G0H64(1),wf16(:,366),G0H4(346),m3h16x4(:,1573),heltab2x64(:,:,6598))
  call Hloop_Q_A(ntryL,G0H4(346),53,nMT,G1H4(2492),n2h4(4008))
  Gcoeff(:)%j = (c(18)*M(8,:)%j) * den(1093)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(9002),h0tab(:,9002),[46,17],[nMT,0],2,2,wf16(:,322),wf4(:,17))
  call Hloop_VA_Q(ntryL,G0H64(1),wf16(:,322),G0H4(346),m3h16x4(:,1574),heltab2x64(:,:,6599))
  call Hloop_A_Q(ntryL,G0H4(346),46,nMT,G1H4(2477),n2h4(4009))
  Gcoeff(:)%j = (c(18)*M(11,:)%j) * den(1094)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(9003),h0tab(:,9003),[46,17],[nMT,0],2,2,wf16(:,328),wf4(:,17))
  call Hloop_VA_Q(ntryL,G0H64(1),wf16(:,328),G0H4(346),m3h16x4(:,1575),heltab2x64(:,:,6600))
  call Hloop_A_Q(ntryL,G0H4(346),46,nMT,G1H4(1128),n2h4(4010))
  Gcoeff(:)%j = (c(24)*(M(7,:)%j-M(9,:)%j)) * den(655)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(9004),h0tab(:,9004),[43,20],[0,0],2,2,wf16(:,31),wf4(:,3))
  call Hloop_QV_A(ntryL,G0H64(1),wf16(:,31),G0H4(346),m3h16x4(:,1576),heltab2x64(:,:,6601))
  call Hloop_Q_A(ntryL,G0H4(346),43,0,G1H4(1082),n2h4(4011))
  Gcoeff(:)%j = (c(22)*(M(7,:)%j-M(9,:)%j)) * den(655)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(9005),h0tab(:,9005),[43,20],[nMT,nMT],2,2,wf16(:,31),wf4(:,3))
  call Hloop_QV_A(ntryL,G0H64(1),wf16(:,31),G0H4(346),m3h16x4(:,1577),heltab2x64(:,:,6602))
  call Hloop_Q_A(ntryL,G0H4(346),43,nMT,G1H4(2524),n2h4(4012))
  Gcoeff(:)%j = (c(24)*(M(7,:)%j-M(9,:)%j)) * den(655)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(9006),h0tab(:,9006),[43,20],[0,0],2,2,wf16(:,31),wf4(:,3))
  call Hloop_QV_A(ntryL,G0H64(1),wf16(:,31),G0H4(346),m3h16x4(:,1578),heltab2x64(:,:,6603))
  call Hloop_Q_A(ntryL,G0H4(346),43,0,G1H4(2509),n2h4(4013))
  Gcoeff(:)%j = (c(22)*(M(7,:)%j-M(9,:)%j)) * den(655)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(9007),h0tab(:,9007),[43,20],[nMB,nMB],2,2,wf16(:,31),wf4(:,3))
  call Hloop_QV_A(ntryL,G0H64(1),wf16(:,31),G0H4(346),m3h16x4(:,1579),heltab2x64(:,:,6604))
  call Hloop_Q_A(ntryL,G0H4(346),43,nMB,G1H4(2508),n2h4(4014))
  Gcoeff(:)%j = (c(10)*(M(7,:)%j-M(9,:)%j)) * den(655)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(9008),h0tab(:,9008),[43,20],[0,0],2,2,wf16(:,31),wf4(:,3))
  call Hloop_CV_D(ntryL,G0H64(1),0,wf16(:,31),43,G1H4(168),m3h16x4(:,1580),heltab2x64(:,:,6605))
  Gcoeff(:)%j = (c(4)*(-M(7,:)%j+M(9,:)%j)) * den(655)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(9009),h0tab(:,9009),[43,20],[0,0],2,2,wf16(:,31),wf4(:,3))
  call Hloop_UV_W(ntryL,G0H64(1),0,wf16(:,31),43,G1H4(2984),m3h16x4(:,1581),heltab2x64(:,:,6606))
  Gcoeff(:)%j = (c(8)*(-M(7,:)%j+M(9,:)%j)) * den(653)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(9010),h0tab(:,9010),[53,10],[nMT,0],2,2,wf16(:,238),wf4(:,15))
  call Hloop_VQ_A(ntryL,G0H64(1),wf16(:,238),G0H4(346),m3h16x4(:,1582),heltab2x64(:,:,6607))
  call Hloop_Q_A(ntryL,G0H4(346),53,nMT,G1H4(2541),n2h4(4015))
  Gcoeff(:)%j = (c(8)*(-M(7,:)%j+M(9,:)%j)) * den(650)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(9011),h0tab(:,9011),[33,30],[0,nMT],2,2,wf4(:,21),wf16(:,236))
  call Hloop_AQ_V(ntryL,G0H64(1),wf4(:,21),G0H16(364),m3h4x16(:,1171),heltab2x64(:,:,6608))
  Gcoeff(:)%j = (c(28)*(M(7,:)%j-M(9,:)%j-M(11,:)%j+M(12,:)%j)) * den(1095)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(9012),h0tab(:,9012),[43,20],[0,0],2,2,wf16(:,315),wf4(:,3))
  call Hloop_QV_A(ntryL,G0H64(1),wf16(:,315),G0H4(346),m3h16x4(:,1583),heltab2x64(:,:,6609))
  call Hloop_Q_A(ntryL,G0H4(346),43,0,G1H4(2540),n2h4(4016))
  Gcoeff(:)%j = (c(26)*(M(7,:)%j-M(9,:)%j-M(11,:)%j+M(12,:)%j)) * den(1095)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(9013),h0tab(:,9013),[43,20],[nMT,nMT],2,2,wf16(:,315),wf4(:,3))
  call Hloop_QV_A(ntryL,G0H64(1),wf16(:,315),G0H4(346),m3h16x4(:,1584),heltab2x64(:,:,6610))
  call Hloop_Q_A(ntryL,G0H4(346),43,nMT,G1H4(2525),n2h4(4017))
  Gcoeff(:)%j = (c(28)*(M(7,:)%j-M(9,:)%j-M(11,:)%j+M(12,:)%j)) * den(1095)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(9014),h0tab(:,9014),[43,20],[0,0],2,2,wf16(:,315),wf4(:,3))
  call Hloop_QV_A(ntryL,G0H64(1),wf16(:,315),G0H4(346),m3h16x4(:,1585),heltab2x64(:,:,6611))
  call Hloop_Q_A(ntryL,G0H4(346),43,0,G1H4(1127),n2h4(4018))
  Gcoeff(:)%j = (c(26)*(M(7,:)%j-M(9,:)%j-M(11,:)%j+M(12,:)%j)) * den(1095)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(9015),h0tab(:,9015),[43,20],[nMB,nMB],2,2,wf16(:,315),wf4(:,3))
  call Hloop_QV_A(ntryL,G0H64(1),wf16(:,315),G0H4(346),m3h16x4(:,1586),heltab2x64(:,:,6612))
  call Hloop_Q_A(ntryL,G0H4(346),43,nMB,G1H4(936),n2h4(4019))
  Gcoeff(:)%j = (c(20)*(M(7,:)%j-M(9,:)%j-M(11,:)%j+M(12,:)%j)) * den(1095)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(9016),h0tab(:,9016),[43,20],[0,0],2,2,wf16(:,315),wf4(:,3))
  call Hloop_CV_D(ntryL,G0H64(1),0,wf16(:,315),43,G1H4(336),m3h16x4(:,1587),heltab2x64(:,:,6613))
  Gcoeff(:)%j = (c(14)*(-M(7,:)%j+M(9,:)%j+M(11,:)%j-M(12,:)%j)) * den(1095)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(9017),h0tab(:,9017),[43,20],[0,0],2,2,wf16(:,315),wf4(:,3))
  call Hloop_UV_W(ntryL,G0H64(1),0,wf16(:,315),43,G1H4(2572),m3h16x4(:,1588),heltab2x64(:,:,6614))
  Gcoeff(:)%j = (c(28)*(-M(7,:)%j+M(9,:)%j+M(11,:)%j-M(12,:)%j)) * den(658)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(9018),h0tab(:,9018),[52,11],[0,0],2,2,wf8(:,27),wf8(:,20))
  call Hloop_QV_A(ntryL,G0H64(1),wf8(:,27),G0H8(217),m3h8x8(:,1324),heltab2x64(:,:,6615))
  call Hloop_Q_A(ntryL,G0H8(217),52,0,G1H8(2),n2h8(3043))
  Gcoeff(:)%j = (c(26)*(-M(7,:)%j+M(9,:)%j+M(11,:)%j-M(12,:)%j)) * den(658)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(9019),h0tab(:,9019),[52,11],[nMT,nMT],2,2,wf8(:,27),wf8(:,20))
  call Hloop_QV_A(ntryL,G0H64(1),wf8(:,27),G0H8(217),m3h8x8(:,1325),heltab2x64(:,:,6616))
  call Hloop_Q_A(ntryL,G0H8(217),52,nMT,G1H8(862),n2h8(3044))
  Gcoeff(:)%j = (c(28)*(-M(7,:)%j+M(9,:)%j+M(11,:)%j-M(12,:)%j)) * den(658)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(9020),h0tab(:,9020),[52,11],[0,0],2,2,wf8(:,27),wf8(:,20))
  call Hloop_QV_A(ntryL,G0H64(1),wf8(:,27),G0H8(217),m3h8x8(:,1326),heltab2x64(:,:,6617))
  call Hloop_Q_A(ntryL,G0H8(217),52,0,G1H8(643),n2h8(3045))
  Gcoeff(:)%j = (c(26)*(-M(7,:)%j+M(9,:)%j+M(11,:)%j-M(12,:)%j)) * den(658)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(9021),h0tab(:,9021),[52,11],[nMB,nMB],2,2,wf8(:,27),wf8(:,20))
  call Hloop_QV_A(ntryL,G0H64(1),wf8(:,27),G0H8(217),m3h8x8(:,1327),heltab2x64(:,:,6618))
  call Hloop_Q_A(ntryL,G0H8(217),52,nMB,G1H8(1399),n2h8(3046))
  Gcoeff(:)%j = (c(20)*(-M(7,:)%j+M(9,:)%j+M(11,:)%j-M(12,:)%j)) * den(658)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(9022),h0tab(:,9022),[52,11],[0,0],2,2,wf8(:,27),wf8(:,20))
  call Hloop_CV_D(ntryL,G0H64(1),0,wf8(:,27),52,G1H8(298),m3h8x8(:,1328),heltab2x64(:,:,6619))
  Gcoeff(:)%j = (c(14)*(M(7,:)%j-M(9,:)%j-M(11,:)%j+M(12,:)%j)) * den(658)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(9023),h0tab(:,9023),[52,11],[0,0],2,2,wf8(:,27),wf8(:,20))
  call Hloop_UV_W(ntryL,G0H64(1),0,wf8(:,27),52,G1H8(72),m3h8x8(:,1329),heltab2x64(:,:,6620))
  Gcoeff(:)%j = (c(8)*(-M(11,:)%j+M(12,:)%j)) * den(1096)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(9024),h0tab(:,9024),[53,10],[nMT,0],2,2,wf16(:,392),wf4(:,15))
  call Hloop_VQ_A(ntryL,G0H64(1),wf16(:,392),G0H4(346),m3h16x4(:,1589),heltab2x64(:,:,6621))
  call Hloop_Q_A(ntryL,G0H4(346),53,nMT,G1H4(2557),n2h4(4020))
  Gcoeff(:)%j = (c(8)*(-M(11,:)%j+M(12,:)%j)) * den(659)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(9025),h0tab(:,9025),[42,21],[nMT,0],2,2,wf8(:,178),wf8(:,92))
  call Hloop_VA_Q(ntryL,G0H64(1),wf8(:,178),G0H8(217),m3h8x8(:,1330),heltab2x64(:,:,6622))
  call Hloop_A_Q(ntryL,G0H8(217),42,nMT,G1H8(174),n2h8(3047))
  Gcoeff(:)%j = (c(24)*(M(11,:)%j-M(12,:)%j)) * den(1097)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(9026),h0tab(:,9026),[43,20],[0,0],2,2,wf16(:,318),wf4(:,3))
  call Hloop_QV_A(ntryL,G0H64(1),wf16(:,318),G0H4(346),m3h16x4(:,1590),heltab2x64(:,:,6623))
  call Hloop_Q_A(ntryL,G0H4(346),43,0,G1H4(2556),n2h4(4021))
  Gcoeff(:)%j = (c(22)*(M(11,:)%j-M(12,:)%j)) * den(1097)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(9027),h0tab(:,9027),[43,20],[nMT,nMT],2,2,wf16(:,318),wf4(:,3))
  call Hloop_QV_A(ntryL,G0H64(1),wf16(:,318),G0H4(346),m3h16x4(:,1591),heltab2x64(:,:,6624))
  call Hloop_Q_A(ntryL,G0H4(346),43,nMT,G1H4(115),n2h4(4022))
  Gcoeff(:)%j = (c(24)*(M(11,:)%j-M(12,:)%j)) * den(1097)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(9028),h0tab(:,9028),[43,20],[0,0],2,2,wf16(:,318),wf4(:,3))
  call Hloop_QV_A(ntryL,G0H64(1),wf16(:,318),G0H4(346),m3h16x4(:,1592),heltab2x64(:,:,6625))
  call Hloop_Q_A(ntryL,G0H4(346),43,0,G1H4(74),n2h4(4023))
  Gcoeff(:)%j = (c(22)*(M(11,:)%j-M(12,:)%j)) * den(1097)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(9029),h0tab(:,9029),[43,20],[nMB,nMB],2,2,wf16(:,318),wf4(:,3))
  call Hloop_QV_A(ntryL,G0H64(1),wf16(:,318),G0H4(346),m3h16x4(:,1593),heltab2x64(:,:,6626))
  call Hloop_Q_A(ntryL,G0H4(346),43,nMB,G1H4(30),n2h4(4024))
  Gcoeff(:)%j = (c(10)*(M(11,:)%j-M(12,:)%j)) * den(1097)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(9030),h0tab(:,9030),[43,20],[0,0],2,2,wf16(:,318),wf4(:,3))
  call Hloop_CV_D(ntryL,G0H64(1),0,wf16(:,318),43,G1H4(470),m3h16x4(:,1594),heltab2x64(:,:,6627))
  Gcoeff(:)%j = (c(4)*(-M(11,:)%j+M(12,:)%j)) * den(1097)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(9031),h0tab(:,9031),[43,20],[0,0],2,2,wf16(:,318),wf4(:,3))
  call Hloop_UV_W(ntryL,G0H64(1),0,wf16(:,318),43,G1H4(222),m3h16x4(:,1595),heltab2x64(:,:,6628))
  Gcoeff(:)%j = (c(18)*(M(7,:)%j-M(9,:)%j-M(11,:)%j+M(12,:)%j)) * den(1098)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(9032),h0tab(:,9032),[53,10],[0,nMT],2,2,wf16(:,396),wf4(:,15))
  call Hloop_AQ_V(ntryL,G0H64(1),wf16(:,396),G0H4(346),m3h16x4(:,1596),heltab2x64(:,:,6629))
  Gcoeff(:)%j = (c(18)*M(9,:)%j) * den(666)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(9033),h0tab(:,9033),[37,26],[0,nMT],2,2,wf8(:,94),wf8(:,42))
  call Hloop_AQ_V(ntryL,G0H64(1),wf8(:,94),G0H8(217),m3h8x8(:,1331),heltab2x64(:,:,6630))
  Gcoeff(:)%j = (c(18)*M(9,:)%j) * den(1099)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(9034),h0tab(:,9034),[53,10],[nMT,0],2,2,wf16(:,434),wf4(:,15))
  call Hloop_VQ_A(ntryL,G0H64(1),wf16(:,434),G0H4(347),m3h16x4(:,1597),heltab2x64(:,:,6631))
  call Hloop_Q_A(ntryL,G0H4(347),53,nMT,G1H4(392),n2h4(4025))
  Gcoeff(:)%j = (c(18)*M(7,:)%j) * den(667)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(9035),h0tab(:,9035),[49,14],[nMT,0],2,2,wf8(:,205),wf8(:,90))
  call Hloop_VQ_A(ntryL,G0H64(1),wf8(:,205),G0H8(218),m3h8x8(:,1332),heltab2x64(:,:,6632))
  call Hloop_Q_A(ntryL,G0H8(218),49,nMT,G1H8(97),n2h8(3048))
  Gcoeff(:)%j = (c(18)*M(7,:)%j) * den(1100)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(9036),h0tab(:,9036),[53,10],[nMT,0],2,2,wf16(:,442),wf4(:,15))
  call Hloop_VQ_A(ntryL,G0H64(1),wf16(:,442),G0H4(347),m3h16x4(:,1598),heltab2x64(:,:,6633))
  call Hloop_Q_A(ntryL,G0H4(347),53,nMT,G1H4(301),n2h4(4026))
  Gcoeff(:)%j = (c(18)*M(7,:)%j) * den(1101)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(9037),h0tab(:,9037),[33,30],[0,nMT],2,2,wf4(:,21),wf16(:,320))
  call Hloop_AQ_V(ntryL,G0H64(1),wf4(:,21),G0H16(365),m3h4x16(:,1172),heltab2x64(:,:,6634))
  Gcoeff(:)%j = (c(18)*M(9,:)%j) * den(1102)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(9038),h0tab(:,9038),[33,30],[0,nMT],2,2,wf4(:,21),wf16(:,324))
  call Hloop_AQ_V(ntryL,G0H64(1),wf4(:,21),G0H16(366),m3h4x16(:,1173),heltab2x64(:,:,6635))
  Gcoeff(:)%j = (c(28)*(M(8,:)%j-M(9,:)%j+M(10,:)%j-M(11,:)%j)) * den(1103)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(9039),h0tab(:,9039),[36,27],[0,0],2,2,wf4(:,4),wf16(:,314))
  call Hloop_QV_A(ntryL,G0H64(1),wf4(:,4),G0H16(367),m3h4x16(:,1174),heltab2x64(:,:,6636))
  call Hloop_Q_A(ntryL,G0H16(367),36,0,G1H16(1191),n2h16(1869))
  Gcoeff(:)%j = (c(26)*(M(8,:)%j-M(9,:)%j+M(10,:)%j-M(11,:)%j)) * den(1103)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(9040),h0tab(:,9040),[36,27],[nMT,nMT],2,2,wf4(:,4),wf16(:,314))
  call Hloop_QV_A(ntryL,G0H64(1),wf4(:,4),G0H16(367),m3h4x16(:,1175),heltab2x64(:,:,6637))
  call Hloop_Q_A(ntryL,G0H16(367),36,nMT,G1H16(1192),n2h16(1870))
  Gcoeff(:)%j = (c(28)*(M(8,:)%j-M(9,:)%j+M(10,:)%j-M(11,:)%j)) * den(1103)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(9041),h0tab(:,9041),[36,27],[0,0],2,2,wf4(:,4),wf16(:,314))
  call Hloop_QV_A(ntryL,G0H64(1),wf4(:,4),G0H16(367),m3h4x16(:,1176),heltab2x64(:,:,6638))
  call Hloop_Q_A(ntryL,G0H16(367),36,0,G1H16(762),n2h16(1871))
  Gcoeff(:)%j = (c(26)*(M(8,:)%j-M(9,:)%j+M(10,:)%j-M(11,:)%j)) * den(1103)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(9042),h0tab(:,9042),[36,27],[nMB,nMB],2,2,wf4(:,4),wf16(:,314))
  call Hloop_QV_A(ntryL,G0H64(1),wf4(:,4),G0H16(367),m3h4x16(:,1177),heltab2x64(:,:,6639))
  call Hloop_Q_A(ntryL,G0H16(367),36,nMB,G1H16(1193),n2h16(1872))
  Gcoeff(:)%j = (c(20)*(M(8,:)%j-M(9,:)%j+M(10,:)%j-M(11,:)%j)) * den(1103)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(9043),h0tab(:,9043),[36,27],[0,0],2,2,wf4(:,4),wf16(:,314))
  call Hloop_CV_D(ntryL,G0H64(1),0,wf4(:,4),36,G1H16(1195),m3h4x16(:,1178),heltab2x64(:,:,6640))
  Gcoeff(:)%j = (c(14)*(-M(8,:)%j+M(9,:)%j-M(10,:)%j+M(11,:)%j)) * den(1103)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(9044),h0tab(:,9044),[36,27],[0,0],2,2,wf4(:,4),wf16(:,314))
  call Hloop_UV_W(ntryL,G0H64(1),0,wf4(:,4),36,G1H16(1196),m3h4x16(:,1179),heltab2x64(:,:,6641))
  Gcoeff(:)%j = (c(28)*(M(8,:)%j-M(9,:)%j+M(10,:)%j-M(11,:)%j)) * den(670)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(9045),h0tab(:,9045),[52,11],[0,0],2,2,wf8(:,31),wf8(:,20))
  call Hloop_QV_A(ntryL,G0H64(1),wf8(:,31),G0H8(218),m3h8x8(:,1333),heltab2x64(:,:,6642))
  call Hloop_Q_A(ntryL,G0H8(218),52,0,G1H8(107),n2h8(3049))
  Gcoeff(:)%j = (c(26)*(M(8,:)%j-M(9,:)%j+M(10,:)%j-M(11,:)%j)) * den(670)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(9046),h0tab(:,9046),[52,11],[nMT,nMT],2,2,wf8(:,31),wf8(:,20))
  call Hloop_QV_A(ntryL,G0H64(1),wf8(:,31),G0H8(218),m3h8x8(:,1334),heltab2x64(:,:,6643))
  call Hloop_Q_A(ntryL,G0H8(218),52,nMT,G1H8(409),n2h8(3050))
  Gcoeff(:)%j = (c(28)*(M(8,:)%j-M(9,:)%j+M(10,:)%j-M(11,:)%j)) * den(670)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(9047),h0tab(:,9047),[52,11],[0,0],2,2,wf8(:,31),wf8(:,20))
  call Hloop_QV_A(ntryL,G0H64(1),wf8(:,31),G0H8(218),m3h8x8(:,1335),heltab2x64(:,:,6644))
  call Hloop_Q_A(ntryL,G0H8(218),52,0,G1H8(944),n2h8(3051))
  Gcoeff(:)%j = (c(26)*(M(8,:)%j-M(9,:)%j+M(10,:)%j-M(11,:)%j)) * den(670)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(9048),h0tab(:,9048),[52,11],[nMB,nMB],2,2,wf8(:,31),wf8(:,20))
  call Hloop_QV_A(ntryL,G0H64(1),wf8(:,31),G0H8(218),m3h8x8(:,1336),heltab2x64(:,:,6645))
  call Hloop_Q_A(ntryL,G0H8(218),52,nMB,G1H8(1419),n2h8(3052))
  Gcoeff(:)%j = (c(20)*(M(8,:)%j-M(9,:)%j+M(10,:)%j-M(11,:)%j)) * den(670)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(9049),h0tab(:,9049),[52,11],[0,0],2,2,wf8(:,31),wf8(:,20))
  call Hloop_CV_D(ntryL,G0H64(1),0,wf8(:,31),52,G1H8(502),m3h8x8(:,1337),heltab2x64(:,:,6646))
  Gcoeff(:)%j = (c(14)*(-M(8,:)%j+M(9,:)%j-M(10,:)%j+M(11,:)%j)) * den(670)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(9050),h0tab(:,9050),[52,11],[0,0],2,2,wf8(:,31),wf8(:,20))
  call Hloop_UV_W(ntryL,G0H64(1),0,wf8(:,31),52,G1H8(320),m3h8x8(:,1338),heltab2x64(:,:,6647))
  Gcoeff(:)%j = (c(8)*(-M(9,:)%j+M(10,:)%j)) * den(1104)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(9051),h0tab(:,9051),[53,10],[nMT,0],2,2,wf16(:,468),wf4(:,15))
  call Hloop_VQ_A(ntryL,G0H64(1),wf16(:,468),G0H4(347),m3h16x4(:,1599),heltab2x64(:,:,6648))
  call Hloop_Q_A(ntryL,G0H4(347),53,nMT,G1H4(253),n2h4(4027))
  Gcoeff(:)%j = (c(8)*(-M(9,:)%j+M(10,:)%j)) * den(671)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(9052),h0tab(:,9052),[37,26],[0,nMT],2,2,wf8(:,96),wf8(:,42))
  call Hloop_AQ_V(ntryL,G0H64(1),wf8(:,96),G0H8(218),m3h8x8(:,1339),heltab2x64(:,:,6649))
  Gcoeff(:)%j = (c(24)*(M(9,:)%j-M(10,:)%j)) * den(1105)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(9053),h0tab(:,9053),[36,27],[0,0],2,2,wf4(:,4),wf16(:,317))
  call Hloop_QV_A(ntryL,G0H64(1),wf4(:,4),G0H16(367),m3h4x16(:,1180),heltab2x64(:,:,6650))
  call Hloop_Q_A(ntryL,G0H16(367),36,0,G1H16(764),n2h16(1873))
  Gcoeff(:)%j = (c(22)*(M(9,:)%j-M(10,:)%j)) * den(1105)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(9054),h0tab(:,9054),[36,27],[nMT,nMT],2,2,wf4(:,4),wf16(:,317))
  call Hloop_QV_A(ntryL,G0H64(1),wf4(:,4),G0H16(367),m3h4x16(:,1181),heltab2x64(:,:,6651))
  call Hloop_Q_A(ntryL,G0H16(367),36,nMT,G1H16(766),n2h16(1874))
  Gcoeff(:)%j = (c(24)*(M(9,:)%j-M(10,:)%j)) * den(1105)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(9055),h0tab(:,9055),[36,27],[0,0],2,2,wf4(:,4),wf16(:,317))
  call Hloop_QV_A(ntryL,G0H64(1),wf4(:,4),G0H16(367),m3h4x16(:,1182),heltab2x64(:,:,6652))
  call Hloop_Q_A(ntryL,G0H16(367),36,0,G1H16(98),n2h16(1875))
  Gcoeff(:)%j = (c(22)*(M(9,:)%j-M(10,:)%j)) * den(1105)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(9056),h0tab(:,9056),[36,27],[nMB,nMB],2,2,wf4(:,4),wf16(:,317))
  call Hloop_QV_A(ntryL,G0H64(1),wf4(:,4),G0H16(367),m3h4x16(:,1183),heltab2x64(:,:,6653))
  call Hloop_Q_A(ntryL,G0H16(367),36,nMB,G1H16(1197),n2h16(1876))
  Gcoeff(:)%j = (c(10)*(M(9,:)%j-M(10,:)%j)) * den(1105)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(9057),h0tab(:,9057),[36,27],[0,0],2,2,wf4(:,4),wf16(:,317))
  call Hloop_CV_D(ntryL,G0H64(1),0,wf4(:,4),36,G1H16(1198),m3h4x16(:,1184),heltab2x64(:,:,6654))
  Gcoeff(:)%j = (c(4)*(-M(9,:)%j+M(10,:)%j)) * den(1105)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(9058),h0tab(:,9058),[36,27],[0,0],2,2,wf4(:,4),wf16(:,317))
  call Hloop_UV_W(ntryL,G0H64(1),0,wf4(:,4),36,G1H16(1199),m3h4x16(:,1185),heltab2x64(:,:,6655))
  Gcoeff(:)%j = (c(18)*(-M(8,:)%j+M(9,:)%j-M(10,:)%j+M(11,:)%j)) * den(1106)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(9059),h0tab(:,9059),[53,10],[0,nMT],2,2,wf16(:,472),wf4(:,15))
  call Hloop_AQ_V(ntryL,G0H64(1),wf16(:,472),G0H4(347),m3h16x4(:,1600),heltab2x64(:,:,6656))
  Gcoeff(:)%j = (c(28)*(M(7,:)%j-M(8,:)%j-M(10,:)%j+M(12,:)%j)) * den(1107)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(9060),h0tab(:,9060),[48,15],[0,0],2,2,wf4(:,7),wf16(:,313))
  call Hloop_QV_A(ntryL,G0H64(1),wf4(:,7),G0H16(367),m3h4x16(:,1186),heltab2x64(:,:,6657))
  call Hloop_Q_A(ntryL,G0H16(367),48,0,G1H16(1201),n2h16(1877))
  Gcoeff(:)%j = (c(26)*(M(7,:)%j-M(8,:)%j-M(10,:)%j+M(12,:)%j)) * den(1107)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(9061),h0tab(:,9061),[48,15],[nMT,nMT],2,2,wf4(:,7),wf16(:,313))
  call Hloop_QV_A(ntryL,G0H64(1),wf4(:,7),G0H16(367),m3h4x16(:,1187),heltab2x64(:,:,6658))
  call Hloop_Q_A(ntryL,G0H16(367),48,nMT,G1H16(1202),n2h16(1878))
  Gcoeff(:)%j = (c(28)*(M(7,:)%j-M(8,:)%j-M(10,:)%j+M(12,:)%j)) * den(1107)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(9062),h0tab(:,9062),[48,15],[0,0],2,2,wf4(:,7),wf16(:,313))
  call Hloop_QV_A(ntryL,G0H64(1),wf4(:,7),G0H16(367),m3h4x16(:,1188),heltab2x64(:,:,6659))
  call Hloop_Q_A(ntryL,G0H16(367),48,0,G1H16(773),n2h16(1879))
  Gcoeff(:)%j = (c(26)*(M(7,:)%j-M(8,:)%j-M(10,:)%j+M(12,:)%j)) * den(1107)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(9063),h0tab(:,9063),[48,15],[nMB,nMB],2,2,wf4(:,7),wf16(:,313))
  call Hloop_QV_A(ntryL,G0H64(1),wf4(:,7),G0H16(367),m3h4x16(:,1189),heltab2x64(:,:,6660))
  call Hloop_Q_A(ntryL,G0H16(367),48,nMB,G1H16(1203),n2h16(1880))
  Gcoeff(:)%j = (c(20)*(M(7,:)%j-M(8,:)%j-M(10,:)%j+M(12,:)%j)) * den(1107)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(9064),h0tab(:,9064),[48,15],[0,0],2,2,wf4(:,7),wf16(:,313))
  call Hloop_CV_D(ntryL,G0H64(1),0,wf4(:,7),48,G1H16(1205),m3h4x16(:,1190),heltab2x64(:,:,6661))
  Gcoeff(:)%j = (c(14)*(-M(7,:)%j+M(8,:)%j+M(10,:)%j-M(12,:)%j)) * den(1107)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(9065),h0tab(:,9065),[48,15],[0,0],2,2,wf4(:,7),wf16(:,313))
  call Hloop_UV_W(ntryL,G0H64(1),0,wf4(:,7),48,G1H16(1206),m3h4x16(:,1191),heltab2x64(:,:,6662))
  Gcoeff(:)%j = (c(28)*(-M(7,:)%j+M(8,:)%j+M(10,:)%j-M(12,:)%j)) * den(675)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(9066),h0tab(:,9066),[52,11],[0,0],2,2,wf8(:,36),wf8(:,20))
  call Hloop_QV_A(ntryL,G0H64(1),wf8(:,36),G0H8(219),m3h8x8(:,1340),heltab2x64(:,:,6663))
  call Hloop_Q_A(ntryL,G0H8(219),52,0,G1H8(335),n2h8(3053))
  Gcoeff(:)%j = (c(26)*(-M(7,:)%j+M(8,:)%j+M(10,:)%j-M(12,:)%j)) * den(675)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(9067),h0tab(:,9067),[52,11],[nMT,nMT],2,2,wf8(:,36),wf8(:,20))
  call Hloop_QV_A(ntryL,G0H64(1),wf8(:,36),G0H8(219),m3h8x8(:,1341),heltab2x64(:,:,6664))
  call Hloop_Q_A(ntryL,G0H8(219),52,nMT,G1H8(130),n2h8(3054))
  Gcoeff(:)%j = (c(28)*(-M(7,:)%j+M(8,:)%j+M(10,:)%j-M(12,:)%j)) * den(675)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(9068),h0tab(:,9068),[52,11],[0,0],2,2,wf8(:,36),wf8(:,20))
  call Hloop_QV_A(ntryL,G0H64(1),wf8(:,36),G0H8(219),m3h8x8(:,1342),heltab2x64(:,:,6665))
  call Hloop_Q_A(ntryL,G0H8(219),52,0,G1H8(111),n2h8(3055))
  Gcoeff(:)%j = (c(26)*(-M(7,:)%j+M(8,:)%j+M(10,:)%j-M(12,:)%j)) * den(675)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(9069),h0tab(:,9069),[52,11],[nMB,nMB],2,2,wf8(:,36),wf8(:,20))
  call Hloop_QV_A(ntryL,G0H64(1),wf8(:,36),G0H8(219),m3h8x8(:,1343),heltab2x64(:,:,6666))
  call Hloop_Q_A(ntryL,G0H8(219),52,nMB,G1H8(820),n2h8(3056))
  Gcoeff(:)%j = (c(20)*(-M(7,:)%j+M(8,:)%j+M(10,:)%j-M(12,:)%j)) * den(675)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(9070),h0tab(:,9070),[52,11],[0,0],2,2,wf8(:,36),wf8(:,20))
  call Hloop_CV_D(ntryL,G0H64(1),0,wf8(:,36),52,G1H8(730),m3h8x8(:,1344),heltab2x64(:,:,6667))
  Gcoeff(:)%j = (c(14)*(M(7,:)%j-M(8,:)%j-M(10,:)%j+M(12,:)%j)) * den(675)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(9071),h0tab(:,9071),[52,11],[0,0],2,2,wf8(:,36),wf8(:,20))
  call Hloop_UV_W(ntryL,G0H64(1),0,wf8(:,36),52,G1H8(784),m3h8x8(:,1345),heltab2x64(:,:,6668))
  Gcoeff(:)%j = (c(8)*(-M(7,:)%j+M(8,:)%j)) * den(1108)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(9072),h0tab(:,9072),[53,10],[nMT,0],2,2,wf16(:,506),wf4(:,15))
  call Hloop_VQ_A(ntryL,G0H64(1),wf16(:,506),G0H4(348),m3h16x4(:,1601),heltab2x64(:,:,6669))
  call Hloop_Q_A(ntryL,G0H4(348),53,nMT,G1H4(2589),n2h4(4028))
  Gcoeff(:)%j = (c(24)*(M(7,:)%j-M(8,:)%j)) * den(1109)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(9073),h0tab(:,9073),[48,15],[0,0],2,2,wf4(:,7),wf16(:,316))
  call Hloop_QV_A(ntryL,G0H64(1),wf4(:,7),G0H16(367),m3h4x16(:,1192),heltab2x64(:,:,6670))
  call Hloop_Q_A(ntryL,G0H16(367),48,0,G1H16(775),n2h16(1881))
  Gcoeff(:)%j = (c(22)*(M(7,:)%j-M(8,:)%j)) * den(1109)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(9074),h0tab(:,9074),[48,15],[nMT,nMT],2,2,wf4(:,7),wf16(:,316))
  call Hloop_QV_A(ntryL,G0H64(1),wf4(:,7),G0H16(367),m3h4x16(:,1193),heltab2x64(:,:,6671))
  call Hloop_Q_A(ntryL,G0H16(367),48,nMT,G1H16(1207),n2h16(1882))
  Gcoeff(:)%j = (c(24)*(M(7,:)%j-M(8,:)%j)) * den(1109)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(9075),h0tab(:,9075),[48,15],[0,0],2,2,wf4(:,7),wf16(:,316))
  call Hloop_QV_A(ntryL,G0H64(1),wf4(:,7),G0H16(367),m3h4x16(:,1194),heltab2x64(:,:,6672))
  call Hloop_Q_A(ntryL,G0H16(367),48,0,G1H16(1209),n2h16(1883))
  Gcoeff(:)%j = (c(22)*(M(7,:)%j-M(8,:)%j)) * den(1109)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(9076),h0tab(:,9076),[48,15],[nMB,nMB],2,2,wf4(:,7),wf16(:,316))
  call Hloop_QV_A(ntryL,G0H64(1),wf4(:,7),G0H16(367),m3h4x16(:,1195),heltab2x64(:,:,6673))
  call Hloop_Q_A(ntryL,G0H16(367),48,nMB,G1H16(1210),n2h16(1884))
  Gcoeff(:)%j = (c(10)*(M(7,:)%j-M(8,:)%j)) * den(1109)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(9077),h0tab(:,9077),[48,15],[0,0],2,2,wf4(:,7),wf16(:,316))
  call Hloop_CV_D(ntryL,G0H64(1),0,wf4(:,7),48,G1H16(779),m3h4x16(:,1196),heltab2x64(:,:,6674))
  Gcoeff(:)%j = (c(4)*(-M(7,:)%j+M(8,:)%j)) * den(1109)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(9078),h0tab(:,9078),[48,15],[0,0],2,2,wf4(:,7),wf16(:,316))
  call Hloop_UV_W(ntryL,G0H64(1),0,wf4(:,7),48,G1H16(1211),m3h4x16(:,1197),heltab2x64(:,:,6675))
  Gcoeff(:)%j = (c(18)*(M(7,:)%j-M(8,:)%j-M(10,:)%j+M(12,:)%j)) * den(1110)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(9079),h0tab(:,9079),[53,10],[0,nMT],2,2,wf16(:,508),wf4(:,15))
  call Hloop_AQ_V(ntryL,G0H64(1),wf16(:,508),G0H4(348),m3h16x4(:,1602),heltab2x64(:,:,6676))
  Gcoeff(:)%j = (c(8)*(-M(7,:)%j+M(8,:)%j)) * den(676)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(9080),h0tab(:,9080),[49,14],[0,nMT],2,2,wf8(:,76),wf8(:,90))
  call Hloop_AQ_V(ntryL,G0H64(1),wf8(:,76),G0H8(219),m3h8x8(:,1346),heltab2x64(:,:,6677))
  Gcoeff(:)%j = (c(24)*(M(19,:)%j-M(21,:)%j)) * den(687)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(9081),h0tab(:,9081),[51,12],[0,0],2,2,wf16(:,32),wf4(:,2))
  call Hloop_QV_A(ntryL,G0H64(1),wf16(:,32),G0H4(349),m3h16x4(:,1603),heltab2x64(:,:,6678))
  call Hloop_Q_A(ntryL,G0H4(349),51,0,G1H4(2588),n2h4(4029))
  Gcoeff(:)%j = (c(22)*(M(19,:)%j-M(21,:)%j)) * den(687)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(9082),h0tab(:,9082),[51,12],[nMT,nMT],2,2,wf16(:,32),wf4(:,2))
  call Hloop_QV_A(ntryL,G0H64(1),wf16(:,32),G0H4(349),m3h16x4(:,1604),heltab2x64(:,:,6679))
  call Hloop_Q_A(ntryL,G0H4(349),51,nMT,G1H4(2573),n2h4(4030))
  Gcoeff(:)%j = (c(24)*(M(19,:)%j-M(21,:)%j)) * den(687)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(9083),h0tab(:,9083),[51,12],[0,0],2,2,wf16(:,32),wf4(:,2))
  call Hloop_QV_A(ntryL,G0H64(1),wf16(:,32),G0H4(349),m3h16x4(:,1605),heltab2x64(:,:,6680))
  call Hloop_Q_A(ntryL,G0H4(349),51,0,G1H4(167),n2h4(4031))
  Gcoeff(:)%j = (c(22)*(M(19,:)%j-M(21,:)%j)) * den(687)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(9084),h0tab(:,9084),[51,12],[nMB,nMB],2,2,wf16(:,32),wf4(:,2))
  call Hloop_QV_A(ntryL,G0H64(1),wf16(:,32),G0H4(349),m3h16x4(:,1606),heltab2x64(:,:,6681))
  call Hloop_Q_A(ntryL,G0H4(349),51,nMB,G1H4(83),n2h4(4032))
  Gcoeff(:)%j = (c(10)*(M(19,:)%j-M(21,:)%j)) * den(687)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(9085),h0tab(:,9085),[51,12],[0,0],2,2,wf16(:,32),wf4(:,2))
  call Hloop_CV_D(ntryL,G0H64(1),0,wf16(:,32),51,G1H4(583),m3h16x4(:,1607),heltab2x64(:,:,6682))
  Gcoeff(:)%j = (c(4)*(-M(19,:)%j+M(21,:)%j)) * den(687)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(9086),h0tab(:,9086),[51,12],[0,0],2,2,wf16(:,32),wf4(:,2))
  call Hloop_UV_W(ntryL,G0H64(1),0,wf16(:,32),51,G1H4(3142),m3h16x4(:,1608),heltab2x64(:,:,6683))
  Gcoeff(:)%j = (c(8)*(-M(19,:)%j+M(21,:)%j)) * den(685)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(9087),h0tab(:,9087),[34,29],[0,nMT],2,2,wf4(:,23),wf16(:,242))
  call Hloop_QA_V(ntryL,G0H64(1),wf4(:,23),G0H16(367),m3h4x16(:,1198),heltab2x64(:,:,6684))
  Gcoeff(:)%j = (c(8)*(-M(19,:)%j+M(21,:)%j)) * den(682)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(9088),h0tab(:,9088),[46,17],[nMT,0],2,2,wf16(:,240),wf4(:,17))
  call Hloop_VA_Q(ntryL,G0H64(1),wf16(:,240),G0H4(349),m3h16x4(:,1609),heltab2x64(:,:,6685))
  call Hloop_A_Q(ntryL,G0H4(349),46,nMT,G1H4(505),n2h4(4033))
  Gcoeff(:)%j = (c(28)*(M(2,:)%j-M(8,:)%j-M(19,:)%j+M(21,:)%j)) * den(1111)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(9089),h0tab(:,9089),[51,12],[0,0],2,2,wf16(:,353),wf4(:,2))
  call Hloop_QV_A(ntryL,G0H64(1),wf16(:,353),G0H4(349),m3h16x4(:,1610),heltab2x64(:,:,6686))
  call Hloop_Q_A(ntryL,G0H4(349),51,0,G1H4(2620),n2h4(4034))
  Gcoeff(:)%j = (c(26)*(M(2,:)%j-M(8,:)%j-M(19,:)%j+M(21,:)%j)) * den(1111)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(9090),h0tab(:,9090),[51,12],[nMT,nMT],2,2,wf16(:,353),wf4(:,2))
  call Hloop_QV_A(ntryL,G0H64(1),wf16(:,353),G0H4(349),m3h16x4(:,1611),heltab2x64(:,:,6687))
  call Hloop_Q_A(ntryL,G0H4(349),51,nMT,G1H4(2605),n2h4(4035))
  Gcoeff(:)%j = (c(28)*(M(2,:)%j-M(8,:)%j-M(19,:)%j+M(21,:)%j)) * den(1111)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(9091),h0tab(:,9091),[51,12],[0,0],2,2,wf16(:,353),wf4(:,2))
  call Hloop_QV_A(ntryL,G0H64(1),wf16(:,353),G0H4(349),m3h16x4(:,1612),heltab2x64(:,:,6688))
  call Hloop_Q_A(ntryL,G0H4(349),51,0,G1H4(2604),n2h4(4036))
  Gcoeff(:)%j = (c(26)*(M(2,:)%j-M(8,:)%j-M(19,:)%j+M(21,:)%j)) * den(1111)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(9092),h0tab(:,9092),[51,12],[nMB,nMB],2,2,wf16(:,353),wf4(:,2))
  call Hloop_QV_A(ntryL,G0H64(1),wf16(:,353),G0H4(349),m3h16x4(:,1613),heltab2x64(:,:,6689))
  call Hloop_Q_A(ntryL,G0H4(349),51,nMB,G1H4(57),n2h4(4037))
  Gcoeff(:)%j = (c(20)*(M(2,:)%j-M(8,:)%j-M(19,:)%j+M(21,:)%j)) * den(1111)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(9093),h0tab(:,9093),[51,12],[0,0],2,2,wf16(:,353),wf4(:,2))
  call Hloop_CV_D(ntryL,G0H64(1),0,wf16(:,353),51,G1H4(815),m3h16x4(:,1614),heltab2x64(:,:,6690))
  Gcoeff(:)%j = (c(14)*(-M(2,:)%j+M(8,:)%j+M(19,:)%j-M(21,:)%j)) * den(1111)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(9094),h0tab(:,9094),[51,12],[0,0],2,2,wf16(:,353),wf4(:,2))
  call Hloop_UV_W(ntryL,G0H64(1),0,wf16(:,353),51,G1H4(755),m3h16x4(:,1615),heltab2x64(:,:,6691))
  Gcoeff(:)%j = (c(28)*(-M(2,:)%j+M(8,:)%j+M(19,:)%j-M(21,:)%j)) * den(691)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(9095),h0tab(:,9095),[44,19],[0,0],2,2,wf8(:,25),wf8(:,21))
  call Hloop_QV_A(ntryL,G0H64(1),wf8(:,25),G0H8(220),m3h8x8(:,1347),heltab2x64(:,:,6692))
  call Hloop_Q_A(ntryL,G0H8(220),44,0,G1H8(363),n2h8(3057))
  Gcoeff(:)%j = (c(26)*(-M(2,:)%j+M(8,:)%j+M(19,:)%j-M(21,:)%j)) * den(691)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(9096),h0tab(:,9096),[44,19],[nMT,nMT],2,2,wf8(:,25),wf8(:,21))
  call Hloop_QV_A(ntryL,G0H64(1),wf8(:,25),G0H8(220),m3h8x8(:,1348),heltab2x64(:,:,6693))
  call Hloop_Q_A(ntryL,G0H8(220),44,nMT,G1H8(271),n2h8(3058))
  Gcoeff(:)%j = (c(28)*(-M(2,:)%j+M(8,:)%j+M(19,:)%j-M(21,:)%j)) * den(691)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(9097),h0tab(:,9097),[44,19],[0,0],2,2,wf8(:,25),wf8(:,21))
  call Hloop_QV_A(ntryL,G0H64(1),wf8(:,25),G0H8(220),m3h8x8(:,1349),heltab2x64(:,:,6694))
  call Hloop_Q_A(ntryL,G0H8(220),44,0,G1H8(265),n2h8(3059))
  Gcoeff(:)%j = (c(26)*(-M(2,:)%j+M(8,:)%j+M(19,:)%j-M(21,:)%j)) * den(691)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(9098),h0tab(:,9098),[44,19],[nMB,nMB],2,2,wf8(:,25),wf8(:,21))
  call Hloop_QV_A(ntryL,G0H64(1),wf8(:,25),G0H8(220),m3h8x8(:,1350),heltab2x64(:,:,6695))
  call Hloop_Q_A(ntryL,G0H8(220),44,nMB,G1H8(1429),n2h8(3060))
  Gcoeff(:)%j = (c(20)*(-M(2,:)%j+M(8,:)%j+M(19,:)%j-M(21,:)%j)) * den(691)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(9099),h0tab(:,9099),[44,19],[0,0],2,2,wf8(:,25),wf8(:,21))
  call Hloop_CV_D(ntryL,G0H64(1),0,wf8(:,25),44,G1H8(140),m3h8x8(:,1351),heltab2x64(:,:,6696))
  Gcoeff(:)%j = (c(14)*(M(2,:)%j-M(8,:)%j-M(19,:)%j+M(21,:)%j)) * den(691)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(9100),h0tab(:,9100),[44,19],[0,0],2,2,wf8(:,25),wf8(:,21))
  call Hloop_UV_W(ntryL,G0H64(1),0,wf8(:,25),44,G1H8(232),m3h8x8(:,1352),heltab2x64(:,:,6697))
  Gcoeff(:)%j = (c(8)*(-M(2,:)%j+M(8,:)%j)) * den(692)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(9101),h0tab(:,9101),[49,14],[nMT,0],2,2,wf8(:,203),wf8(:,98))
  call Hloop_VQ_A(ntryL,G0H64(1),wf8(:,203),G0H8(220),m3h8x8(:,1353),heltab2x64(:,:,6698))
  call Hloop_Q_A(ntryL,G0H8(220),49,nMT,G1H8(465),n2h8(3061))
  Gcoeff(:)%j = (c(24)*(M(2,:)%j-M(8,:)%j)) * den(1112)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(9102),h0tab(:,9102),[51,12],[0,0],2,2,wf16(:,364),wf4(:,2))
  call Hloop_QV_A(ntryL,G0H64(1),wf16(:,364),G0H4(349),m3h16x4(:,1616),heltab2x64(:,:,6699))
  call Hloop_Q_A(ntryL,G0H4(349),51,0,G1H4(644),n2h4(4038))
  Gcoeff(:)%j = (c(22)*(M(2,:)%j-M(8,:)%j)) * den(1112)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(9103),h0tab(:,9103),[51,12],[nMT,nMT],2,2,wf16(:,364),wf4(:,2))
  call Hloop_QV_A(ntryL,G0H64(1),wf16(:,364),G0H4(349),m3h16x4(:,1617),heltab2x64(:,:,6700))
  call Hloop_Q_A(ntryL,G0H4(349),51,nMT,G1H4(515),n2h4(4039))
  Gcoeff(:)%j = (c(24)*(M(2,:)%j-M(8,:)%j)) * den(1112)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(9104),h0tab(:,9104),[51,12],[0,0],2,2,wf16(:,364),wf4(:,2))
  call Hloop_QV_A(ntryL,G0H64(1),wf16(:,364),G0H4(349),m3h16x4(:,1618),heltab2x64(:,:,6701))
  call Hloop_Q_A(ntryL,G0H4(349),51,0,G1H4(189),n2h4(4040))
  Gcoeff(:)%j = (c(22)*(M(2,:)%j-M(8,:)%j)) * den(1112)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(9105),h0tab(:,9105),[51,12],[nMB,nMB],2,2,wf16(:,364),wf4(:,2))
  call Hloop_QV_A(ntryL,G0H64(1),wf16(:,364),G0H4(349),m3h16x4(:,1619),heltab2x64(:,:,6702))
  call Hloop_Q_A(ntryL,G0H4(349),51,nMB,G1H4(911),n2h4(4041))
  Gcoeff(:)%j = (c(10)*(M(2,:)%j-M(8,:)%j)) * den(1112)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(9106),h0tab(:,9106),[51,12],[0,0],2,2,wf16(:,364),wf4(:,2))
  call Hloop_CV_D(ntryL,G0H64(1),0,wf16(:,364),51,G1H4(134),m3h16x4(:,1620),heltab2x64(:,:,6703))
  Gcoeff(:)%j = (c(4)*(-M(2,:)%j+M(8,:)%j)) * den(1112)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(9107),h0tab(:,9107),[51,12],[0,0],2,2,wf16(:,364),wf4(:,2))
  call Hloop_UV_W(ntryL,G0H64(1),0,wf16(:,364),51,G1H4(105),m3h16x4(:,1621),heltab2x64(:,:,6704))
  Gcoeff(:)%j = (c(8)*(-M(2,:)%j+M(8,:)%j)) * den(1113)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(9108),h0tab(:,9108),[46,17],[nMT,0],2,2,wf16(:,344),wf4(:,17))
  call Hloop_VA_Q(ntryL,G0H64(1),wf16(:,344),G0H4(349),m3h16x4(:,1622),heltab2x64(:,:,6705))
  call Hloop_A_Q(ntryL,G0H4(349),46,nMT,G1H4(4),n2h4(4042))
  Gcoeff(:)%j = (c(18)*(M(2,:)%j-M(8,:)%j-M(19,:)%j+M(21,:)%j)) * den(1114)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(9109),h0tab(:,9109),[46,17],[nMT,0],2,2,wf16(:,348),wf4(:,17))
  call Hloop_VA_Q(ntryL,G0H64(1),wf16(:,348),G0H4(349),m3h16x4(:,1623),heltab2x64(:,:,6706))
  call Hloop_A_Q(ntryL,G0H4(349),46,nMT,G1H4(1043),n2h4(4043))
  Gcoeff(:)%j = (c(24)*(M(13,:)%j-M(15,:)%j)) * den(701)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(9110),h0tab(:,9110),[51,12],[0,0],2,2,wf16(:,33),wf4(:,2))
  call Hloop_QV_A(ntryL,G0H64(1),wf16(:,33),G0H4(349),m3h16x4(:,1624),heltab2x64(:,:,6707))
  call Hloop_Q_A(ntryL,G0H4(349),51,0,G1H4(740),n2h4(4044))
  Gcoeff(:)%j = (c(22)*(M(13,:)%j-M(15,:)%j)) * den(701)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(9111),h0tab(:,9111),[51,12],[nMT,nMT],2,2,wf16(:,33),wf4(:,2))
  call Hloop_QV_A(ntryL,G0H64(1),wf16(:,33),G0H4(349),m3h16x4(:,1625),heltab2x64(:,:,6708))
  call Hloop_Q_A(ntryL,G0H4(349),51,nMT,G1H4(94),n2h4(4045))
  Gcoeff(:)%j = (c(24)*(M(13,:)%j-M(15,:)%j)) * den(701)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(9112),h0tab(:,9112),[51,12],[0,0],2,2,wf16(:,33),wf4(:,2))
  call Hloop_QV_A(ntryL,G0H64(1),wf16(:,33),G0H4(349),m3h16x4(:,1626),heltab2x64(:,:,6709))
  call Hloop_Q_A(ntryL,G0H4(349),51,0,G1H4(89),n2h4(4046))
  Gcoeff(:)%j = (c(22)*(M(13,:)%j-M(15,:)%j)) * den(701)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(9113),h0tab(:,9113),[51,12],[nMB,nMB],2,2,wf16(:,33),wf4(:,2))
  call Hloop_QV_A(ntryL,G0H64(1),wf16(:,33),G0H4(349),m3h16x4(:,1627),heltab2x64(:,:,6710))
  call Hloop_Q_A(ntryL,G0H4(349),51,nMB,G1H4(787),n2h4(4047))
  Gcoeff(:)%j = (c(10)*(M(13,:)%j-M(15,:)%j)) * den(701)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(9114),h0tab(:,9114),[51,12],[0,0],2,2,wf16(:,33),wf4(:,2))
  call Hloop_CV_D(ntryL,G0H64(1),0,wf16(:,33),51,G1H4(157),m3h16x4(:,1628),heltab2x64(:,:,6711))
  Gcoeff(:)%j = (c(4)*(-M(13,:)%j+M(15,:)%j)) * den(701)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(9115),h0tab(:,9115),[51,12],[0,0],2,2,wf16(:,33),wf4(:,2))
  call Hloop_UV_W(ntryL,G0H64(1),0,wf16(:,33),51,G1H4(982),m3h16x4(:,1629),heltab2x64(:,:,6712))
  Gcoeff(:)%j = (c(8)*(-M(13,:)%j+M(15,:)%j)) * den(699)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(9116),h0tab(:,9116),[45,18],[nMT,0],2,2,wf16(:,246),wf4(:,19))
  call Hloop_VQ_A(ntryL,G0H64(1),wf16(:,246),G0H4(349),m3h16x4(:,1630),heltab2x64(:,:,6713))
  call Hloop_Q_A(ntryL,G0H4(349),45,nMT,G1H4(285),n2h4(4048))
  Gcoeff(:)%j = (c(8)*(-M(13,:)%j+M(15,:)%j)) * den(696)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(9117),h0tab(:,9117),[33,30],[0,nMT],2,2,wf4(:,21),wf16(:,244))
  call Hloop_AQ_V(ntryL,G0H64(1),wf4(:,21),G0H16(368),m3h4x16(:,1199),heltab2x64(:,:,6714))
  Gcoeff(:)%j = (c(28)*(M(13,:)%j-M(15,:)%j-M(17,:)%j+M(18,:)%j)) * den(1115)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(9118),h0tab(:,9118),[51,12],[0,0],2,2,wf16(:,371),wf4(:,2))
  call Hloop_QV_A(ntryL,G0H64(1),wf16(:,371),G0H4(349),m3h16x4(:,1631),heltab2x64(:,:,6715))
  call Hloop_Q_A(ntryL,G0H4(349),51,0,G1H4(449),n2h4(4049))
  Gcoeff(:)%j = (c(26)*(M(13,:)%j-M(15,:)%j-M(17,:)%j+M(18,:)%j)) * den(1115)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(9119),h0tab(:,9119),[51,12],[nMT,nMT],2,2,wf16(:,371),wf4(:,2))
  call Hloop_QV_A(ntryL,G0H64(1),wf16(:,371),G0H4(349),m3h16x4(:,1632),heltab2x64(:,:,6716))
  call Hloop_Q_A(ntryL,G0H4(349),51,nMT,G1H4(849),n2h4(4050))
  Gcoeff(:)%j = (c(28)*(M(13,:)%j-M(15,:)%j-M(17,:)%j+M(18,:)%j)) * den(1115)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(9120),h0tab(:,9120),[51,12],[0,0],2,2,wf16(:,371),wf4(:,2))
  call Hloop_QV_A(ntryL,G0H64(1),wf16(:,371),G0H4(349),m3h16x4(:,1633),heltab2x64(:,:,6717))
  call Hloop_Q_A(ntryL,G0H4(349),51,0,G1H4(508),n2h4(4051))
  Gcoeff(:)%j = (c(26)*(M(13,:)%j-M(15,:)%j-M(17,:)%j+M(18,:)%j)) * den(1115)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(9121),h0tab(:,9121),[51,12],[nMB,nMB],2,2,wf16(:,371),wf4(:,2))
  call Hloop_QV_A(ntryL,G0H64(1),wf16(:,371),G0H4(349),m3h16x4(:,1634),heltab2x64(:,:,6718))
  call Hloop_Q_A(ntryL,G0H4(349),51,nMB,G1H4(413),n2h4(4052))
  Gcoeff(:)%j = (c(20)*(M(13,:)%j-M(15,:)%j-M(17,:)%j+M(18,:)%j)) * den(1115)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(9122),h0tab(:,9122),[51,12],[0,0],2,2,wf16(:,371),wf4(:,2))
  call Hloop_CV_D(ntryL,G0H64(1),0,wf16(:,371),51,G1H4(919),m3h16x4(:,1635),heltab2x64(:,:,6719))
  Gcoeff(:)%j = (c(14)*(-M(13,:)%j+M(15,:)%j+M(17,:)%j-M(18,:)%j)) * den(1115)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(9123),h0tab(:,9123),[51,12],[0,0],2,2,wf16(:,371),wf4(:,2))
  call Hloop_UV_W(ntryL,G0H64(1),0,wf16(:,371),51,G1H4(705),m3h16x4(:,1636),heltab2x64(:,:,6720))
  Gcoeff(:)%j = (c(28)*(-M(13,:)%j+M(15,:)%j+M(17,:)%j-M(18,:)%j)) * den(704)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(9124),h0tab(:,9124),[44,19],[0,0],2,2,wf8(:,25),wf8(:,22))
  call Hloop_QV_A(ntryL,G0H64(1),wf8(:,25),G0H8(220),m3h8x8(:,1354),heltab2x64(:,:,6721))
  call Hloop_Q_A(ntryL,G0H8(220),44,0,G1H8(429),n2h8(3062))
  Gcoeff(:)%j = (c(26)*(-M(13,:)%j+M(15,:)%j+M(17,:)%j-M(18,:)%j)) * den(704)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(9125),h0tab(:,9125),[44,19],[nMT,nMT],2,2,wf8(:,25),wf8(:,22))
  call Hloop_QV_A(ntryL,G0H64(1),wf8(:,25),G0H8(220),m3h8x8(:,1355),heltab2x64(:,:,6722))
  call Hloop_Q_A(ntryL,G0H8(220),44,nMT,G1H8(381),n2h8(3063))
  Gcoeff(:)%j = (c(28)*(-M(13,:)%j+M(15,:)%j+M(17,:)%j-M(18,:)%j)) * den(704)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(9126),h0tab(:,9126),[44,19],[0,0],2,2,wf8(:,25),wf8(:,22))
  call Hloop_QV_A(ntryL,G0H64(1),wf8(:,25),G0H8(220),m3h8x8(:,1356),heltab2x64(:,:,6723))
  call Hloop_Q_A(ntryL,G0H8(220),44,0,G1H8(1441),n2h8(3064))
  Gcoeff(:)%j = (c(26)*(-M(13,:)%j+M(15,:)%j+M(17,:)%j-M(18,:)%j)) * den(704)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(9127),h0tab(:,9127),[44,19],[nMB,nMB],2,2,wf8(:,25),wf8(:,22))
  call Hloop_QV_A(ntryL,G0H64(1),wf8(:,25),G0H8(220),m3h8x8(:,1357),heltab2x64(:,:,6724))
  call Hloop_Q_A(ntryL,G0H8(220),44,nMB,G1H8(454),n2h8(3065))
  Gcoeff(:)%j = (c(20)*(-M(13,:)%j+M(15,:)%j+M(17,:)%j-M(18,:)%j)) * den(704)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(9128),h0tab(:,9128),[44,19],[0,0],2,2,wf8(:,25),wf8(:,22))
  call Hloop_CV_D(ntryL,G0H64(1),0,wf8(:,25),44,G1H8(181),m3h8x8(:,1358),heltab2x64(:,:,6725))
  Gcoeff(:)%j = (c(14)*(M(13,:)%j-M(15,:)%j-M(17,:)%j+M(18,:)%j)) * den(704)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(9129),h0tab(:,9129),[44,19],[0,0],2,2,wf8(:,25),wf8(:,22))
  call Hloop_UV_W(ntryL,G0H64(1),0,wf8(:,25),44,G1H8(89),m3h8x8(:,1359),heltab2x64(:,:,6726))
  Gcoeff(:)%j = (c(8)*(-M(17,:)%j+M(18,:)%j)) * den(1116)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(9130),h0tab(:,9130),[45,18],[nMT,0],2,2,wf16(:,336),wf4(:,19))
  call Hloop_VQ_A(ntryL,G0H64(1),wf16(:,336),G0H4(349),m3h16x4(:,1637),heltab2x64(:,:,6727))
  call Hloop_Q_A(ntryL,G0H4(349),45,nMT,G1H4(700),n2h4(4053))
  Gcoeff(:)%j = (c(8)*(-M(17,:)%j+M(18,:)%j)) * den(705)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(9131),h0tab(:,9131),[50,13],[nMT,0],2,2,wf8(:,185),wf8(:,100))
  call Hloop_VA_Q(ntryL,G0H64(1),wf8(:,185),G0H8(220),m3h8x8(:,1360),heltab2x64(:,:,6728))
  call Hloop_A_Q(ntryL,G0H8(220),50,nMT,G1H8(106),n2h8(3066))
  Gcoeff(:)%j = (c(24)*(M(17,:)%j-M(18,:)%j)) * den(1117)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(9132),h0tab(:,9132),[51,12],[0,0],2,2,wf16(:,374),wf4(:,2))
  call Hloop_QV_A(ntryL,G0H64(1),wf16(:,374),G0H4(349),m3h16x4(:,1638),heltab2x64(:,:,6729))
  call Hloop_Q_A(ntryL,G0H4(349),51,0,G1H4(961),n2h4(4054))
  Gcoeff(:)%j = (c(22)*(M(17,:)%j-M(18,:)%j)) * den(1117)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(9133),h0tab(:,9133),[51,12],[nMT,nMT],2,2,wf16(:,374),wf4(:,2))
  call Hloop_QV_A(ntryL,G0H64(1),wf16(:,374),G0H4(349),m3h16x4(:,1639),heltab2x64(:,:,6730))
  call Hloop_Q_A(ntryL,G0H4(349),51,nMT,G1H4(346),n2h4(4055))
  Gcoeff(:)%j = (c(24)*(M(17,:)%j-M(18,:)%j)) * den(1117)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(9134),h0tab(:,9134),[51,12],[0,0],2,2,wf16(:,374),wf4(:,2))
  call Hloop_QV_A(ntryL,G0H64(1),wf16(:,374),G0H4(349),m3h16x4(:,1640),heltab2x64(:,:,6731))
  call Hloop_Q_A(ntryL,G0H4(349),51,0,G1H4(211),n2h4(4056))
  Gcoeff(:)%j = (c(22)*(M(17,:)%j-M(18,:)%j)) * den(1117)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(9135),h0tab(:,9135),[51,12],[nMB,nMB],2,2,wf16(:,374),wf4(:,2))
  call Hloop_QV_A(ntryL,G0H64(1),wf16(:,374),G0H4(349),m3h16x4(:,1641),heltab2x64(:,:,6732))
  call Hloop_Q_A(ntryL,G0H4(349),51,nMB,G1H4(2129),n2h4(4057))
  Gcoeff(:)%j = (c(10)*(M(17,:)%j-M(18,:)%j)) * den(1117)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(9136),h0tab(:,9136),[51,12],[0,0],2,2,wf16(:,374),wf4(:,2))
  call Hloop_CV_D(ntryL,G0H64(1),0,wf16(:,374),51,G1H4(235),m3h16x4(:,1642),heltab2x64(:,:,6733))
  Gcoeff(:)%j = (c(4)*(-M(17,:)%j+M(18,:)%j)) * den(1117)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(9137),h0tab(:,9137),[51,12],[0,0],2,2,wf16(:,374),wf4(:,2))
  call Hloop_UV_W(ntryL,G0H64(1),0,wf16(:,374),51,G1H4(170),m3h16x4(:,1643),heltab2x64(:,:,6734))
  Gcoeff(:)%j = (c(18)*(M(13,:)%j-M(15,:)%j-M(17,:)%j+M(18,:)%j)) * den(1118)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(9138),h0tab(:,9138),[45,18],[0,nMT],2,2,wf16(:,340),wf4(:,19))
  call Hloop_AQ_V(ntryL,G0H64(1),wf16(:,340),G0H4(349),m3h16x4(:,1644),heltab2x64(:,:,6735))
  Gcoeff(:)%j = (c(28)*(-M(1,:)%j+M(7,:)%j+M(13,:)%j-M(15,:)%j)) * den(1119)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(9139),h0tab(:,9139),[51,12],[0,0],2,2,wf16(:,429),wf4(:,2))
  call Hloop_QV_A(ntryL,G0H64(1),wf16(:,429),G0H4(350),m3h16x4(:,1645),heltab2x64(:,:,6736))
  call Hloop_Q_A(ntryL,G0H4(350),51,0,G1H4(2701),n2h4(4058))
  Gcoeff(:)%j = (c(26)*(-M(1,:)%j+M(7,:)%j+M(13,:)%j-M(15,:)%j)) * den(1119)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(9140),h0tab(:,9140),[51,12],[nMT,nMT],2,2,wf16(:,429),wf4(:,2))
  call Hloop_QV_A(ntryL,G0H64(1),wf16(:,429),G0H4(350),m3h16x4(:,1646),heltab2x64(:,:,6737))
  call Hloop_Q_A(ntryL,G0H4(350),51,nMT,G1H4(971),n2h4(4059))
  Gcoeff(:)%j = (c(28)*(-M(1,:)%j+M(7,:)%j+M(13,:)%j-M(15,:)%j)) * den(1119)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(9141),h0tab(:,9141),[51,12],[0,0],2,2,wf16(:,429),wf4(:,2))
  call Hloop_QV_A(ntryL,G0H64(1),wf16(:,429),G0H4(350),m3h16x4(:,1647),heltab2x64(:,:,6738))
  call Hloop_Q_A(ntryL,G0H4(350),51,0,G1H4(286),n2h4(4060))
  Gcoeff(:)%j = (c(26)*(-M(1,:)%j+M(7,:)%j+M(13,:)%j-M(15,:)%j)) * den(1119)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(9142),h0tab(:,9142),[51,12],[nMB,nMB],2,2,wf16(:,429),wf4(:,2))
  call Hloop_QV_A(ntryL,G0H64(1),wf16(:,429),G0H4(350),m3h16x4(:,1648),heltab2x64(:,:,6739))
  call Hloop_Q_A(ntryL,G0H4(350),51,nMB,G1H4(2732),n2h4(4061))
  Gcoeff(:)%j = (c(20)*(-M(1,:)%j+M(7,:)%j+M(13,:)%j-M(15,:)%j)) * den(1119)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(9143),h0tab(:,9143),[51,12],[0,0],2,2,wf16(:,429),wf4(:,2))
  call Hloop_CV_D(ntryL,G0H64(1),0,wf16(:,429),51,G1H4(310),m3h16x4(:,1649),heltab2x64(:,:,6740))
  Gcoeff(:)%j = (c(14)*(M(1,:)%j-M(7,:)%j-M(13,:)%j+M(15,:)%j)) * den(1119)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(9144),h0tab(:,9144),[51,12],[0,0],2,2,wf16(:,429),wf4(:,2))
  call Hloop_UV_W(ntryL,G0H64(1),0,wf16(:,429),51,G1H4(2765),m3h16x4(:,1650),heltab2x64(:,:,6741))
  Gcoeff(:)%j = (c(28)*(-M(1,:)%j+M(7,:)%j+M(13,:)%j-M(15,:)%j)) * den(711)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(9145),h0tab(:,9145),[35,28],[0,0],2,2,wf8(:,23),wf8(:,26))
  call Hloop_QV_A(ntryL,G0H64(1),wf8(:,23),G0H8(220),m3h8x8(:,1361),heltab2x64(:,:,6742))
  call Hloop_Q_A(ntryL,G0H8(220),35,0,G1H8(15),n2h8(3067))
  Gcoeff(:)%j = (c(26)*(-M(1,:)%j+M(7,:)%j+M(13,:)%j-M(15,:)%j)) * den(711)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(9146),h0tab(:,9146),[35,28],[nMT,nMT],2,2,wf8(:,23),wf8(:,26))
  call Hloop_QV_A(ntryL,G0H64(1),wf8(:,23),G0H8(220),m3h8x8(:,1362),heltab2x64(:,:,6743))
  call Hloop_Q_A(ntryL,G0H8(220),35,nMT,G1H8(276),n2h8(3068))
  Gcoeff(:)%j = (c(28)*(-M(1,:)%j+M(7,:)%j+M(13,:)%j-M(15,:)%j)) * den(711)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(9147),h0tab(:,9147),[35,28],[0,0],2,2,wf8(:,23),wf8(:,26))
  call Hloop_QV_A(ntryL,G0H64(1),wf8(:,23),G0H8(220),m3h8x8(:,1363),heltab2x64(:,:,6744))
  call Hloop_Q_A(ntryL,G0H8(220),35,0,G1H8(272),n2h8(3069))
  Gcoeff(:)%j = (c(26)*(-M(1,:)%j+M(7,:)%j+M(13,:)%j-M(15,:)%j)) * den(711)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(9148),h0tab(:,9148),[35,28],[nMB,nMB],2,2,wf8(:,23),wf8(:,26))
  call Hloop_QV_A(ntryL,G0H64(1),wf8(:,23),G0H8(220),m3h8x8(:,1364),heltab2x64(:,:,6745))
  call Hloop_Q_A(ntryL,G0H8(220),35,nMB,G1H8(501),n2h8(3070))
  Gcoeff(:)%j = (c(20)*(-M(1,:)%j+M(7,:)%j+M(13,:)%j-M(15,:)%j)) * den(711)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(9149),h0tab(:,9149),[35,28],[0,0],2,2,wf8(:,23),wf8(:,26))
  call Hloop_CV_D(ntryL,G0H64(1),0,wf8(:,23),35,G1H8(586),m3h8x8(:,1365),heltab2x64(:,:,6746))
  Gcoeff(:)%j = (c(14)*(M(1,:)%j-M(7,:)%j-M(13,:)%j+M(15,:)%j)) * den(711)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(9150),h0tab(:,9150),[35,28],[0,0],2,2,wf8(:,23),wf8(:,26))
  call Hloop_UV_W(ntryL,G0H64(1),0,wf8(:,23),35,G1H8(550),m3h8x8(:,1366),heltab2x64(:,:,6747))
  Gcoeff(:)%j = (c(8)*(-M(1,:)%j+M(7,:)%j)) * den(712)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(9151),h0tab(:,9151),[49,14],[nMT,0],2,2,wf8(:,205),wf8(:,98))
  call Hloop_VQ_A(ntryL,G0H64(1),wf8(:,205),G0H8(220),m3h8x8(:,1367),heltab2x64(:,:,6748))
  call Hloop_Q_A(ntryL,G0H8(220),49,nMT,G1H8(496),n2h8(3071))
  Gcoeff(:)%j = (c(24)*(M(1,:)%j-M(7,:)%j)) * den(1120)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(9152),h0tab(:,9152),[51,12],[0,0],2,2,wf16(:,440),wf4(:,2))
  call Hloop_QV_A(ntryL,G0H64(1),wf16(:,440),G0H4(350),m3h16x4(:,1651),heltab2x64(:,:,6749))
  call Hloop_Q_A(ntryL,G0H4(350),51,0,G1H4(2780),n2h4(4062))
  Gcoeff(:)%j = (c(22)*(M(1,:)%j-M(7,:)%j)) * den(1120)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(9153),h0tab(:,9153),[51,12],[nMT,nMT],2,2,wf16(:,440),wf4(:,2))
  call Hloop_QV_A(ntryL,G0H64(1),wf16(:,440),G0H4(350),m3h16x4(:,1652),heltab2x64(:,:,6750))
  call Hloop_Q_A(ntryL,G0H4(350),51,nMT,G1H4(2829),n2h4(4063))
  Gcoeff(:)%j = (c(24)*(M(1,:)%j-M(7,:)%j)) * den(1120)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(9154),h0tab(:,9154),[51,12],[0,0],2,2,wf16(:,440),wf4(:,2))
  call Hloop_QV_A(ntryL,G0H64(1),wf16(:,440),G0H4(350),m3h16x4(:,1653),heltab2x64(:,:,6751))
  call Hloop_Q_A(ntryL,G0H4(350),51,0,G1H4(2860),n2h4(4064))
  Gcoeff(:)%j = (c(22)*(M(1,:)%j-M(7,:)%j)) * den(1120)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(9155),h0tab(:,9155),[51,12],[nMB,nMB],2,2,wf16(:,440),wf4(:,2))
  call Hloop_QV_A(ntryL,G0H64(1),wf16(:,440),G0H4(350),m3h16x4(:,1654),heltab2x64(:,:,6752))
  call Hloop_Q_A(ntryL,G0H4(350),51,nMB,G1H4(2861),n2h4(4065))
  Gcoeff(:)%j = (c(10)*(M(1,:)%j-M(7,:)%j)) * den(1120)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(9156),h0tab(:,9156),[51,12],[0,0],2,2,wf16(:,440),wf4(:,2))
  call Hloop_CV_D(ntryL,G0H64(1),0,wf16(:,440),51,G1H4(2924),m3h16x4(:,1655),heltab2x64(:,:,6753))
  Gcoeff(:)%j = (c(4)*(-M(1,:)%j+M(7,:)%j)) * den(1120)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(9157),h0tab(:,9157),[51,12],[0,0],2,2,wf16(:,440),wf4(:,2))
  call Hloop_UV_W(ntryL,G0H64(1),0,wf16(:,440),51,G1H4(2941),m3h16x4(:,1656),heltab2x64(:,:,6754))
  Gcoeff(:)%j = (c(8)*(-M(1,:)%j+M(7,:)%j)) * den(1121)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(9158),h0tab(:,9158),[33,30],[0,nMT],2,2,wf4(:,21),wf16(:,342))
  call Hloop_AQ_V(ntryL,G0H64(1),wf4(:,21),G0H16(369),m3h4x16(:,1200),heltab2x64(:,:,6755))
  Gcoeff(:)%j = (c(18)*(M(1,:)%j-M(7,:)%j-M(13,:)%j+M(15,:)%j)) * den(1122)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(9159),h0tab(:,9159),[33,30],[0,nMT],2,2,wf4(:,21),wf16(:,346))
  call Hloop_AQ_V(ntryL,G0H64(1),wf4(:,21),G0H16(370),m3h4x16(:,1201),heltab2x64(:,:,6756))
  Gcoeff(:)%j = (c(28)*(-M(19,:)%j+M(21,:)%j+M(23,:)%j-M(24,:)%j)) * den(1123)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(9160),h0tab(:,9160),[51,12],[0,0],2,2,wf16(:,447),wf4(:,2))
  call Hloop_QV_A(ntryL,G0H64(1),wf16(:,447),G0H4(350),m3h16x4(:,1657),heltab2x64(:,:,6757))
  call Hloop_Q_A(ntryL,G0H4(350),51,0,G1H4(2956),n2h4(4066))
  Gcoeff(:)%j = (c(26)*(-M(19,:)%j+M(21,:)%j+M(23,:)%j-M(24,:)%j)) * den(1123)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(9161),h0tab(:,9161),[51,12],[nMT,nMT],2,2,wf16(:,447),wf4(:,2))
  call Hloop_QV_A(ntryL,G0H64(1),wf16(:,447),G0H4(350),m3h16x4(:,1658),heltab2x64(:,:,6758))
  call Hloop_Q_A(ntryL,G0H4(350),51,nMT,G1H4(3015),n2h4(4067))
  Gcoeff(:)%j = (c(28)*(-M(19,:)%j+M(21,:)%j+M(23,:)%j-M(24,:)%j)) * den(1123)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(9162),h0tab(:,9162),[51,12],[0,0],2,2,wf16(:,447),wf4(:,2))
  call Hloop_QV_A(ntryL,G0H64(1),wf16(:,447),G0H4(350),m3h16x4(:,1659),heltab2x64(:,:,6759))
  call Hloop_Q_A(ntryL,G0H4(350),51,0,G1H4(3046),n2h4(4068))
  Gcoeff(:)%j = (c(26)*(-M(19,:)%j+M(21,:)%j+M(23,:)%j-M(24,:)%j)) * den(1123)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(9163),h0tab(:,9163),[51,12],[nMB,nMB],2,2,wf16(:,447),wf4(:,2))
  call Hloop_QV_A(ntryL,G0H64(1),wf16(:,447),G0H4(350),m3h16x4(:,1660),heltab2x64(:,:,6760))
  call Hloop_Q_A(ntryL,G0H4(350),51,nMB,G1H4(3047),n2h4(4069))
  Gcoeff(:)%j = (c(20)*(-M(19,:)%j+M(21,:)%j+M(23,:)%j-M(24,:)%j)) * den(1123)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(9164),h0tab(:,9164),[51,12],[0,0],2,2,wf16(:,447),wf4(:,2))
  call Hloop_CV_D(ntryL,G0H64(1),0,wf16(:,447),51,G1H4(3125),m3h16x4(:,1661),heltab2x64(:,:,6761))
  Gcoeff(:)%j = (c(14)*(M(19,:)%j-M(21,:)%j-M(23,:)%j+M(24,:)%j)) * den(1123)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(9165),h0tab(:,9165),[51,12],[0,0],2,2,wf16(:,447),wf4(:,2))
  call Hloop_UV_W(ntryL,G0H64(1),0,wf16(:,447),51,G1H4(3253),m3h16x4(:,1662),heltab2x64(:,:,6762))
  Gcoeff(:)%j = (c(28)*(-M(19,:)%j+M(21,:)%j+M(23,:)%j-M(24,:)%j)) * den(716)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(9166),h0tab(:,9166),[35,28],[0,0],2,2,wf8(:,24),wf8(:,26))
  call Hloop_QV_A(ntryL,G0H64(1),wf8(:,24),G0H8(220),m3h8x8(:,1368),heltab2x64(:,:,6763))
  call Hloop_Q_A(ntryL,G0H8(220),35,0,G1H8(1450),n2h8(3072))
  Gcoeff(:)%j = (c(26)*(-M(19,:)%j+M(21,:)%j+M(23,:)%j-M(24,:)%j)) * den(716)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(9167),h0tab(:,9167),[35,28],[nMT,nMT],2,2,wf8(:,24),wf8(:,26))
  call Hloop_QV_A(ntryL,G0H64(1),wf8(:,24),G0H8(220),m3h8x8(:,1369),heltab2x64(:,:,6764))
  call Hloop_Q_A(ntryL,G0H8(220),35,nMT,G1H8(127),n2h8(3073))
  Gcoeff(:)%j = (c(28)*(-M(19,:)%j+M(21,:)%j+M(23,:)%j-M(24,:)%j)) * den(716)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(9168),h0tab(:,9168),[35,28],[0,0],2,2,wf8(:,24),wf8(:,26))
  call Hloop_QV_A(ntryL,G0H64(1),wf8(:,24),G0H8(220),m3h8x8(:,1370),heltab2x64(:,:,6765))
  call Hloop_Q_A(ntryL,G0H8(220),35,0,G1H8(28),n2h8(3074))
  Gcoeff(:)%j = (c(26)*(-M(19,:)%j+M(21,:)%j+M(23,:)%j-M(24,:)%j)) * den(716)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(9169),h0tab(:,9169),[35,28],[nMB,nMB],2,2,wf8(:,24),wf8(:,26))
  call Hloop_QV_A(ntryL,G0H64(1),wf8(:,24),G0H8(220),m3h8x8(:,1371),heltab2x64(:,:,6766))
  call Hloop_Q_A(ntryL,G0H8(220),35,nMB,G1H8(263),n2h8(3075))
  Gcoeff(:)%j = (c(20)*(-M(19,:)%j+M(21,:)%j+M(23,:)%j-M(24,:)%j)) * den(716)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(9170),h0tab(:,9170),[35,28],[0,0],2,2,wf8(:,24),wf8(:,26))
  call Hloop_CV_D(ntryL,G0H64(1),0,wf8(:,24),35,G1H8(260),m3h8x8(:,1372),heltab2x64(:,:,6767))
  Gcoeff(:)%j = (c(14)*(M(19,:)%j-M(21,:)%j-M(23,:)%j+M(24,:)%j)) * den(716)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(9171),h0tab(:,9171),[35,28],[0,0],2,2,wf8(:,24),wf8(:,26))
  call Hloop_UV_W(ntryL,G0H64(1),0,wf8(:,24),35,G1H8(254),m3h8x8(:,1373),heltab2x64(:,:,6768))
  Gcoeff(:)%j = (c(8)*(-M(23,:)%j+M(24,:)%j)) * den(1124)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(9172),h0tab(:,9172),[34,29],[0,nMT],2,2,wf4(:,23),wf16(:,334))
  call Hloop_QA_V(ntryL,G0H64(1),wf4(:,23),G0H16(371),m3h4x16(:,1202),heltab2x64(:,:,6769))
  Gcoeff(:)%j = (c(8)*(-M(23,:)%j+M(24,:)%j)) * den(717)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(9173),h0tab(:,9173),[50,13],[nMT,0],2,2,wf8(:,187),wf8(:,100))
  call Hloop_VA_Q(ntryL,G0H64(1),wf8(:,187),G0H8(220),m3h8x8(:,1374),heltab2x64(:,:,6770))
  call Hloop_A_Q(ntryL,G0H8(220),50,nMT,G1H8(1458),n2h8(3076))
  Gcoeff(:)%j = (c(24)*(M(23,:)%j-M(24,:)%j)) * den(1125)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(9174),h0tab(:,9174),[51,12],[0,0],2,2,wf16(:,450),wf4(:,2))
  call Hloop_QV_A(ntryL,G0H64(1),wf16(:,450),G0H4(350),m3h16x4(:,1663),heltab2x64(:,:,6771))
  call Hloop_Q_A(ntryL,G0H4(350),51,0,G1H4(3157),n2h4(4070))
  Gcoeff(:)%j = (c(22)*(M(23,:)%j-M(24,:)%j)) * den(1125)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(9175),h0tab(:,9175),[51,12],[nMT,nMT],2,2,wf16(:,450),wf4(:,2))
  call Hloop_QV_A(ntryL,G0H64(1),wf16(:,450),G0H4(350),m3h16x4(:,1664),heltab2x64(:,:,6772))
  call Hloop_Q_A(ntryL,G0H4(350),51,nMT,G1H4(3215),n2h4(4071))
  Gcoeff(:)%j = (c(24)*(M(23,:)%j-M(24,:)%j)) * den(1125)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(9176),h0tab(:,9176),[51,12],[0,0],2,2,wf16(:,450),wf4(:,2))
  call Hloop_QV_A(ntryL,G0H64(1),wf16(:,450),G0H4(350),m3h16x4(:,1665),heltab2x64(:,:,6773))
  call Hloop_Q_A(ntryL,G0H4(350),51,0,G1H4(3216),n2h4(4072))
  Gcoeff(:)%j = (c(22)*(M(23,:)%j-M(24,:)%j)) * den(1125)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(9177),h0tab(:,9177),[51,12],[nMB,nMB],2,2,wf16(:,450),wf4(:,2))
  call Hloop_QV_A(ntryL,G0H64(1),wf16(:,450),G0H4(350),m3h16x4(:,1666),heltab2x64(:,:,6774))
  call Hloop_Q_A(ntryL,G0H4(350),51,nMB,G1H4(3252),n2h4(4073))
  Gcoeff(:)%j = (c(10)*(M(23,:)%j-M(24,:)%j)) * den(1125)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(9178),h0tab(:,9178),[51,12],[0,0],2,2,wf16(:,450),wf4(:,2))
  call Hloop_CV_D(ntryL,G0H64(1),0,wf16(:,450),51,G1H4(27),m3h16x4(:,1667),heltab2x64(:,:,6775))
  Gcoeff(:)%j = (c(4)*(-M(23,:)%j+M(24,:)%j)) * den(1125)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(9179),h0tab(:,9179),[51,12],[0,0],2,2,wf16(:,450),wf4(:,2))
  call Hloop_UV_W(ntryL,G0H64(1),0,wf16(:,450),51,G1H4(698),m3h16x4(:,1668),heltab2x64(:,:,6776))
  Gcoeff(:)%j = (c(18)*(M(19,:)%j-M(21,:)%j-M(23,:)%j+M(24,:)%j)) * den(1126)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(9180),h0tab(:,9180),[34,29],[nMT,0],2,2,wf4(:,23),wf16(:,338))
  call Hloop_VA_Q(ntryL,G0H64(1),wf4(:,23),G0H16(372),m3h4x16(:,1203),heltab2x64(:,:,6777))
  call Hloop_A_Q(ntryL,G0H16(372),34,nMT,G1H16(1213),n2h16(1885))
  Gcoeff(:)%j = (c(28)*(-M(17,:)%j+M(18,:)%j+M(23,:)%j-M(24,:)%j)) * den(1127)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(9181),h0tab(:,9181),[48,15],[0,0],2,2,wf4(:,7),wf16(:,331))
  call Hloop_QV_A(ntryL,G0H64(1),wf4(:,7),G0H16(372),m3h4x16(:,1204),heltab2x64(:,:,6778))
  call Hloop_Q_A(ntryL,G0H16(372),48,0,G1H16(1214),n2h16(1886))
  Gcoeff(:)%j = (c(26)*(-M(17,:)%j+M(18,:)%j+M(23,:)%j-M(24,:)%j)) * den(1127)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(9182),h0tab(:,9182),[48,15],[nMT,nMT],2,2,wf4(:,7),wf16(:,331))
  call Hloop_QV_A(ntryL,G0H64(1),wf4(:,7),G0H16(372),m3h4x16(:,1205),heltab2x64(:,:,6779))
  call Hloop_Q_A(ntryL,G0H16(372),48,nMT,G1H16(781),n2h16(1887))
  Gcoeff(:)%j = (c(28)*(-M(17,:)%j+M(18,:)%j+M(23,:)%j-M(24,:)%j)) * den(1127)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(9183),h0tab(:,9183),[48,15],[0,0],2,2,wf4(:,7),wf16(:,331))
  call Hloop_QV_A(ntryL,G0H64(1),wf4(:,7),G0H16(372),m3h4x16(:,1206),heltab2x64(:,:,6780))
  call Hloop_Q_A(ntryL,G0H16(372),48,0,G1H16(784),n2h16(1888))
  Gcoeff(:)%j = (c(26)*(-M(17,:)%j+M(18,:)%j+M(23,:)%j-M(24,:)%j)) * den(1127)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(9184),h0tab(:,9184),[48,15],[nMB,nMB],2,2,wf4(:,7),wf16(:,331))
  call Hloop_QV_A(ntryL,G0H64(1),wf4(:,7),G0H16(372),m3h4x16(:,1207),heltab2x64(:,:,6781))
  call Hloop_Q_A(ntryL,G0H16(372),48,nMB,G1H16(788),n2h16(1889))
  Gcoeff(:)%j = (c(20)*(-M(17,:)%j+M(18,:)%j+M(23,:)%j-M(24,:)%j)) * den(1127)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(9185),h0tab(:,9185),[48,15],[0,0],2,2,wf4(:,7),wf16(:,331))
  call Hloop_CV_D(ntryL,G0H64(1),0,wf4(:,7),48,G1H16(1215),m3h4x16(:,1208),heltab2x64(:,:,6782))
  Gcoeff(:)%j = (c(14)*(M(17,:)%j-M(18,:)%j-M(23,:)%j+M(24,:)%j)) * den(1127)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(9186),h0tab(:,9186),[48,15],[0,0],2,2,wf4(:,7),wf16(:,331))
  call Hloop_UV_W(ntryL,G0H64(1),0,wf4(:,7),48,G1H16(793),m3h4x16(:,1209),heltab2x64(:,:,6783))
  Gcoeff(:)%j = (c(28)*(-M(1,:)%j+M(2,:)%j+M(7,:)%j-M(8,:)%j)) * den(1128)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(9187),h0tab(:,9187),[51,12],[0,0],2,2,wf16(:,503),wf4(:,2))
  call Hloop_QV_A(ntryL,G0H64(1),wf16(:,503),G0H4(350),m3h16x4(:,1669),heltab2x64(:,:,6784))
  call Hloop_Q_A(ntryL,G0H4(350),51,0,G1H4(39),n2h4(4074))
  Gcoeff(:)%j = (c(26)*(-M(1,:)%j+M(2,:)%j+M(7,:)%j-M(8,:)%j)) * den(1128)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(9188),h0tab(:,9188),[51,12],[nMT,nMT],2,2,wf16(:,503),wf4(:,2))
  call Hloop_QV_A(ntryL,G0H64(1),wf16(:,503),G0H4(350),m3h16x4(:,1670),heltab2x64(:,:,6785))
  call Hloop_Q_A(ntryL,G0H4(350),51,nMT,G1H4(679),n2h4(4075))
  Gcoeff(:)%j = (c(28)*(-M(1,:)%j+M(2,:)%j+M(7,:)%j-M(8,:)%j)) * den(1128)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(9189),h0tab(:,9189),[51,12],[0,0],2,2,wf16(:,503),wf4(:,2))
  call Hloop_QV_A(ntryL,G0H64(1),wf16(:,503),G0H4(350),m3h16x4(:,1671),heltab2x64(:,:,6786))
  call Hloop_Q_A(ntryL,G0H4(350),51,0,G1H4(680),n2h4(4076))
  Gcoeff(:)%j = (c(26)*(-M(1,:)%j+M(2,:)%j+M(7,:)%j-M(8,:)%j)) * den(1128)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(9190),h0tab(:,9190),[51,12],[nMB,nMB],2,2,wf16(:,503),wf4(:,2))
  call Hloop_QV_A(ntryL,G0H64(1),wf16(:,503),G0H4(350),m3h16x4(:,1672),heltab2x64(:,:,6787))
  call Hloop_Q_A(ntryL,G0H4(350),51,nMB,G1H4(697),n2h4(4077))
  Gcoeff(:)%j = (c(20)*(-M(1,:)%j+M(2,:)%j+M(7,:)%j-M(8,:)%j)) * den(1128)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(9191),h0tab(:,9191),[51,12],[0,0],2,2,wf16(:,503),wf4(:,2))
  call Hloop_CV_D(ntryL,G0H64(1),0,wf16(:,503),51,G1H4(728),m3h16x4(:,1673),heltab2x64(:,:,6788))
  Gcoeff(:)%j = (c(14)*(M(1,:)%j-M(2,:)%j-M(7,:)%j+M(8,:)%j)) * den(1128)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(9192),h0tab(:,9192),[51,12],[0,0],2,2,wf16(:,503),wf4(:,2))
  call Hloop_UV_W(ntryL,G0H64(1),0,wf16(:,503),51,G1H4(836),m3h16x4(:,1674),heltab2x64(:,:,6789))
  Gcoeff(:)%j = (c(28)*(-M(1,:)%j+M(2,:)%j+M(7,:)%j-M(8,:)%j)) * den(1129)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(9193),h0tab(:,9193),[48,15],[0,0],2,2,wf4(:,7),wf16(:,332))
  call Hloop_QV_A(ntryL,G0H64(1),wf4(:,7),G0H16(372),m3h4x16(:,1210),heltab2x64(:,:,6790))
  call Hloop_Q_A(ntryL,G0H16(372),48,0,G1H16(72),n2h16(1890))
  Gcoeff(:)%j = (c(26)*(-M(1,:)%j+M(2,:)%j+M(7,:)%j-M(8,:)%j)) * den(1129)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(9194),h0tab(:,9194),[48,15],[nMT,nMT],2,2,wf4(:,7),wf16(:,332))
  call Hloop_QV_A(ntryL,G0H64(1),wf4(:,7),G0H16(372),m3h4x16(:,1211),heltab2x64(:,:,6791))
  call Hloop_Q_A(ntryL,G0H16(372),48,nMT,G1H16(803),n2h16(1891))
  Gcoeff(:)%j = (c(28)*(-M(1,:)%j+M(2,:)%j+M(7,:)%j-M(8,:)%j)) * den(1129)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(9195),h0tab(:,9195),[48,15],[0,0],2,2,wf4(:,7),wf16(:,332))
  call Hloop_QV_A(ntryL,G0H64(1),wf4(:,7),G0H16(372),m3h4x16(:,1212),heltab2x64(:,:,6792))
  call Hloop_Q_A(ntryL,G0H16(372),48,0,G1H16(809),n2h16(1892))
  Gcoeff(:)%j = (c(26)*(-M(1,:)%j+M(2,:)%j+M(7,:)%j-M(8,:)%j)) * den(1129)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(9196),h0tab(:,9196),[48,15],[nMB,nMB],2,2,wf4(:,7),wf16(:,332))
  call Hloop_QV_A(ntryL,G0H64(1),wf4(:,7),G0H16(372),m3h4x16(:,1213),heltab2x64(:,:,6793))
  call Hloop_Q_A(ntryL,G0H16(372),48,nMB,G1H16(815),n2h16(1893))
  Gcoeff(:)%j = (c(20)*(-M(1,:)%j+M(2,:)%j+M(7,:)%j-M(8,:)%j)) * den(1129)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(9197),h0tab(:,9197),[48,15],[0,0],2,2,wf4(:,7),wf16(:,332))
  call Hloop_CV_D(ntryL,G0H64(1),0,wf4(:,7),48,G1H16(77),m3h4x16(:,1214),heltab2x64(:,:,6794))
  Gcoeff(:)%j = (c(14)*(M(1,:)%j-M(2,:)%j-M(7,:)%j+M(8,:)%j)) * den(1129)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(9198),h0tab(:,9198),[48,15],[0,0],2,2,wf4(:,7),wf16(:,332))
  call Hloop_UV_W(ntryL,G0H64(1),0,wf4(:,7),48,G1H16(841),m3h4x16(:,1215),heltab2x64(:,:,6795))
  Gcoeff(:)%j = (c(28)*(-M(17,:)%j+M(18,:)%j+M(23,:)%j-M(24,:)%j)) * den(1130)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(9199),h0tab(:,9199),[51,12],[0,0],2,2,wf16(:,504),wf4(:,2))
  call Hloop_QV_A(ntryL,G0H64(1),wf16(:,504),G0H4(350),m3h16x4(:,1675),heltab2x64(:,:,6796))
  call Hloop_Q_A(ntryL,G0H4(350),51,0,G1H4(745),n2h4(4078))
  Gcoeff(:)%j = (c(26)*(-M(17,:)%j+M(18,:)%j+M(23,:)%j-M(24,:)%j)) * den(1130)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(9200),h0tab(:,9200),[51,12],[nMT,nMT],2,2,wf16(:,504),wf4(:,2))
  call Hloop_QV_A(ntryL,G0H64(1),wf16(:,504),G0H4(350),m3h16x4(:,1676),heltab2x64(:,:,6797))
  call Hloop_Q_A(ntryL,G0H4(350),51,nMT,G1H4(770),n2h4(4079))
  Gcoeff(:)%j = (c(28)*(-M(17,:)%j+M(18,:)%j+M(23,:)%j-M(24,:)%j)) * den(1130)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(9201),h0tab(:,9201),[51,12],[0,0],2,2,wf16(:,504),wf4(:,2))
  call Hloop_QV_A(ntryL,G0H64(1),wf16(:,504),G0H4(350),m3h16x4(:,1677),heltab2x64(:,:,6798))
  call Hloop_Q_A(ntryL,G0H4(350),51,0,G1H4(818),n2h4(4080))
  Gcoeff(:)%j = (c(26)*(-M(17,:)%j+M(18,:)%j+M(23,:)%j-M(24,:)%j)) * den(1130)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(9202),h0tab(:,9202),[51,12],[nMB,nMB],2,2,wf16(:,504),wf4(:,2))
  call Hloop_QV_A(ntryL,G0H64(1),wf16(:,504),G0H4(350),m3h16x4(:,1678),heltab2x64(:,:,6799))
  call Hloop_Q_A(ntryL,G0H4(350),51,nMB,G1H4(774),n2h4(4081))
  Gcoeff(:)%j = (c(20)*(-M(17,:)%j+M(18,:)%j+M(23,:)%j-M(24,:)%j)) * den(1130)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(9203),h0tab(:,9203),[51,12],[0,0],2,2,wf16(:,504),wf4(:,2))
  call Hloop_CV_D(ntryL,G0H64(1),0,wf16(:,504),51,G1H4(877),m3h16x4(:,1679),heltab2x64(:,:,6800))
  Gcoeff(:)%j = (c(14)*(M(17,:)%j-M(18,:)%j-M(23,:)%j+M(24,:)%j)) * den(1130)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(9204),h0tab(:,9204),[51,12],[0,0],2,2,wf16(:,504),wf4(:,2))
  call Hloop_UV_W(ntryL,G0H64(1),0,wf16(:,504),51,G1H4(788),m3h16x4(:,1680),heltab2x64(:,:,6801))
  Gcoeff(:)%j = (c(18)*(M(17,:)%j-M(18,:)%j-M(23,:)%j+M(24,:)%j)) * den(720)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(9205),h0tab(:,9205),[50,13],[nMT,0],2,2,wf8(:,56),wf8(:,100))
  call Hloop_VA_Q(ntryL,G0H64(1),wf8(:,56),G0H8(220),m3h8x8(:,1375),heltab2x64(:,:,6802))
  call Hloop_A_Q(ntryL,G0H8(220),50,nMT,G1H8(324),n2h8(3077))
  Gcoeff(:)%j = (c(18)*(M(1,:)%j-M(2,:)%j-M(7,:)%j+M(8,:)%j)) * den(721)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(9206),h0tab(:,9206),[49,14],[0,nMT],2,2,wf8(:,76),wf8(:,98))
  call Hloop_AQ_V(ntryL,G0H64(1),wf8(:,76),G0H8(220),m3h8x8(:,1376),heltab2x64(:,:,6803))
  Gcoeff(:)%j = (c(18)*M(21,:)%j) * den(730)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(9207),h0tab(:,9207),[42,21],[nMT,0],2,2,wf8(:,52),wf8(:,88))
  call Hloop_VA_Q(ntryL,G0H64(1),wf8(:,52),G0H8(221),m3h8x8(:,1377),heltab2x64(:,:,6804))
  call Hloop_A_Q(ntryL,G0H8(221),42,nMT,G1H8(154),n2h8(3078))
  Gcoeff(:)%j = (c(18)*M(21,:)%j) * den(1131)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(9208),h0tab(:,9208),[34,29],[0,nMT],2,2,wf4(:,23),wf16(:,356))
  call Hloop_QA_V(ntryL,G0H64(1),wf4(:,23),G0H16(372),m3h4x16(:,1216),heltab2x64(:,:,6805))
  Gcoeff(:)%j = (c(18)*M(19,:)%j) * den(731)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(9209),h0tab(:,9209),[38,25],[0,nMT],2,2,wf8(:,84),wf8(:,64))
  call Hloop_QA_V(ntryL,G0H64(1),wf8(:,84),G0H8(221),m3h8x8(:,1378),heltab2x64(:,:,6806))
  Gcoeff(:)%j = (c(18)*M(19,:)%j) * den(1132)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(9210),h0tab(:,9210),[34,29],[0,nMT],2,2,wf4(:,23),wf16(:,361))
  call Hloop_QA_V(ntryL,G0H64(1),wf4(:,23),G0H16(373),m3h4x16(:,1217),heltab2x64(:,:,6807))
  Gcoeff(:)%j = (c(18)*M(19,:)%j) * den(1133)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(9211),h0tab(:,9211),[46,17],[nMT,0],2,2,wf16(:,452),wf4(:,17))
  call Hloop_VA_Q(ntryL,G0H64(1),wf16(:,452),G0H4(350),m3h16x4(:,1681),heltab2x64(:,:,6808))
  call Hloop_A_Q(ntryL,G0H4(350),46,nMT,G1H4(811),n2h4(4082))
  Gcoeff(:)%j = (c(18)*M(21,:)%j) * den(1134)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(9212),h0tab(:,9212),[46,17],[nMT,0],2,2,wf16(:,456),wf4(:,17))
  call Hloop_VA_Q(ntryL,G0H64(1),wf16(:,456),G0H4(350),m3h16x4(:,1682),heltab2x64(:,:,6809))
  call Hloop_A_Q(ntryL,G0H4(350),46,nMT,G1H4(829),n2h4(4083))
  Gcoeff(:)%j = (c(28)*(-M(5,:)%j+M(8,:)%j-M(11,:)%j+M(19,:)%j)) * den(1135)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(9213),h0tab(:,9213),[36,27],[0,0],2,2,wf4(:,4),wf16(:,352))
  call Hloop_QV_A(ntryL,G0H64(1),wf4(:,4),G0H16(374),m3h4x16(:,1218),heltab2x64(:,:,6810))
  call Hloop_Q_A(ntryL,G0H16(374),36,0,G1H16(847),n2h16(1894))
  Gcoeff(:)%j = (c(26)*(-M(5,:)%j+M(8,:)%j-M(11,:)%j+M(19,:)%j)) * den(1135)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(9214),h0tab(:,9214),[36,27],[nMT,nMT],2,2,wf4(:,4),wf16(:,352))
  call Hloop_QV_A(ntryL,G0H64(1),wf4(:,4),G0H16(374),m3h4x16(:,1219),heltab2x64(:,:,6811))
  call Hloop_Q_A(ntryL,G0H16(374),36,nMT,G1H16(853),n2h16(1895))
  Gcoeff(:)%j = (c(28)*(-M(5,:)%j+M(8,:)%j-M(11,:)%j+M(19,:)%j)) * den(1135)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(9215),h0tab(:,9215),[36,27],[0,0],2,2,wf4(:,4),wf16(:,352))
  call Hloop_QV_A(ntryL,G0H64(1),wf4(:,4),G0H16(374),m3h4x16(:,1220),heltab2x64(:,:,6812))
  call Hloop_Q_A(ntryL,G0H16(374),36,0,G1H16(859),n2h16(1896))
  Gcoeff(:)%j = (c(26)*(-M(5,:)%j+M(8,:)%j-M(11,:)%j+M(19,:)%j)) * den(1135)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(9216),h0tab(:,9216),[36,27],[nMB,nMB],2,2,wf4(:,4),wf16(:,352))
  call Hloop_QV_A(ntryL,G0H64(1),wf4(:,4),G0H16(374),m3h4x16(:,1221),heltab2x64(:,:,6813))
  call Hloop_Q_A(ntryL,G0H16(374),36,nMB,G1H16(94),n2h16(1897))
  Gcoeff(:)%j = (c(20)*(-M(5,:)%j+M(8,:)%j-M(11,:)%j+M(19,:)%j)) * den(1135)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(9217),h0tab(:,9217),[36,27],[0,0],2,2,wf4(:,4),wf16(:,352))
  call Hloop_CV_D(ntryL,G0H64(1),0,wf4(:,4),36,G1H16(869),m3h4x16(:,1222),heltab2x64(:,:,6814))
  Gcoeff(:)%j = (c(14)*(M(5,:)%j-M(8,:)%j+M(11,:)%j-M(19,:)%j)) * den(1135)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(9218),h0tab(:,9218),[36,27],[0,0],2,2,wf4(:,4),wf16(:,352))
  call Hloop_UV_W(ntryL,G0H64(1),0,wf4(:,4),36,G1H16(892),m3h4x16(:,1223),heltab2x64(:,:,6815))
  Gcoeff(:)%j = (c(28)*(M(5,:)%j-M(8,:)%j+M(11,:)%j-M(19,:)%j)) * den(735)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(9219),h0tab(:,9219),[44,19],[0,0],2,2,wf8(:,32),wf8(:,21))
  call Hloop_QV_A(ntryL,G0H64(1),wf8(:,32),G0H8(222),m3h8x8(:,1379),heltab2x64(:,:,6816))
  call Hloop_Q_A(ntryL,G0H8(222),44,0,G1H8(293),n2h8(3079))
  Gcoeff(:)%j = (c(26)*(M(5,:)%j-M(8,:)%j+M(11,:)%j-M(19,:)%j)) * den(735)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(9220),h0tab(:,9220),[44,19],[nMT,nMT],2,2,wf8(:,32),wf8(:,21))
  call Hloop_QV_A(ntryL,G0H64(1),wf8(:,32),G0H8(222),m3h8x8(:,1380),heltab2x64(:,:,6817))
  call Hloop_Q_A(ntryL,G0H8(222),44,nMT,G1H8(288),n2h8(3080))
  Gcoeff(:)%j = (c(28)*(M(5,:)%j-M(8,:)%j+M(11,:)%j-M(19,:)%j)) * den(735)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(9221),h0tab(:,9221),[44,19],[0,0],2,2,wf8(:,32),wf8(:,21))
  call Hloop_QV_A(ntryL,G0H64(1),wf8(:,32),G0H8(222),m3h8x8(:,1381),heltab2x64(:,:,6818))
  call Hloop_Q_A(ntryL,G0H8(222),44,0,G1H8(75),n2h8(3081))
  Gcoeff(:)%j = (c(26)*(M(5,:)%j-M(8,:)%j+M(11,:)%j-M(19,:)%j)) * den(735)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(9222),h0tab(:,9222),[44,19],[nMB,nMB],2,2,wf8(:,32),wf8(:,21))
  call Hloop_QV_A(ntryL,G0H64(1),wf8(:,32),G0H8(222),m3h8x8(:,1382),heltab2x64(:,:,6819))
  call Hloop_Q_A(ntryL,G0H8(222),44,nMB,G1H8(1468),n2h8(3082))
  Gcoeff(:)%j = (c(20)*(M(5,:)%j-M(8,:)%j+M(11,:)%j-M(19,:)%j)) * den(735)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(9223),h0tab(:,9223),[44,19],[0,0],2,2,wf8(:,32),wf8(:,21))
  call Hloop_CV_D(ntryL,G0H64(1),0,wf8(:,32),44,G1H8(158),m3h8x8(:,1383),heltab2x64(:,:,6820))
  Gcoeff(:)%j = (c(14)*(-M(5,:)%j+M(8,:)%j-M(11,:)%j+M(19,:)%j)) * den(735)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(9224),h0tab(:,9224),[44,19],[0,0],2,2,wf8(:,32),wf8(:,21))
  call Hloop_UV_W(ntryL,G0H64(1),0,wf8(:,32),44,G1H8(129),m3h8x8(:,1384),heltab2x64(:,:,6821))
  Gcoeff(:)%j = (c(8)*(-M(5,:)%j+M(19,:)%j)) * den(736)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(9225),h0tab(:,9225),[38,25],[0,nMT],2,2,wf8(:,86),wf8(:,64))
  call Hloop_QA_V(ntryL,G0H64(1),wf8(:,86),G0H8(222),m3h8x8(:,1385),heltab2x64(:,:,6822))
  Gcoeff(:)%j = (c(24)*(M(5,:)%j-M(19,:)%j)) * den(1136)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(9226),h0tab(:,9226),[36,27],[0,0],2,2,wf4(:,4),wf16(:,359))
  call Hloop_QV_A(ntryL,G0H64(1),wf4(:,4),G0H16(374),m3h4x16(:,1224),heltab2x64(:,:,6823))
  call Hloop_Q_A(ntryL,G0H16(374),36,0,G1H16(64),n2h16(1898))
  Gcoeff(:)%j = (c(22)*(M(5,:)%j-M(19,:)%j)) * den(1136)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(9227),h0tab(:,9227),[36,27],[nMT,nMT],2,2,wf4(:,4),wf16(:,359))
  call Hloop_QV_A(ntryL,G0H64(1),wf4(:,4),G0H16(374),m3h4x16(:,1225),heltab2x64(:,:,6824))
  call Hloop_Q_A(ntryL,G0H16(374),36,nMT,G1H16(44),n2h16(1899))
  Gcoeff(:)%j = (c(24)*(M(5,:)%j-M(19,:)%j)) * den(1136)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(9228),h0tab(:,9228),[36,27],[0,0],2,2,wf4(:,4),wf16(:,359))
  call Hloop_QV_A(ntryL,G0H64(1),wf4(:,4),G0H16(374),m3h4x16(:,1226),heltab2x64(:,:,6825))
  call Hloop_Q_A(ntryL,G0H16(374),36,0,G1H16(256),n2h16(1900))
  Gcoeff(:)%j = (c(22)*(M(5,:)%j-M(19,:)%j)) * den(1136)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(9229),h0tab(:,9229),[36,27],[nMB,nMB],2,2,wf4(:,4),wf16(:,359))
  call Hloop_QV_A(ntryL,G0H64(1),wf4(:,4),G0H16(374),m3h4x16(:,1227),heltab2x64(:,:,6826))
  call Hloop_Q_A(ntryL,G0H16(374),36,nMB,G1H16(898),n2h16(1901))
  Gcoeff(:)%j = (c(10)*(M(5,:)%j-M(19,:)%j)) * den(1136)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(9230),h0tab(:,9230),[36,27],[0,0],2,2,wf4(:,4),wf16(:,359))
  call Hloop_CV_D(ntryL,G0H64(1),0,wf4(:,4),36,G1H16(297),m3h4x16(:,1228),heltab2x64(:,:,6827))
  Gcoeff(:)%j = (c(4)*(-M(5,:)%j+M(19,:)%j)) * den(1136)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(9231),h0tab(:,9231),[36,27],[0,0],2,2,wf4(:,4),wf16(:,359))
  call Hloop_UV_W(ntryL,G0H64(1),0,wf4(:,4),36,G1H16(312),m3h4x16(:,1229),heltab2x64(:,:,6828))
  Gcoeff(:)%j = (c(8)*(-M(5,:)%j+M(19,:)%j)) * den(1137)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(9232),h0tab(:,9232),[46,17],[nMT,0],2,2,wf16(:,474),wf4(:,17))
  call Hloop_VA_Q(ntryL,G0H64(1),wf16(:,474),G0H4(350),m3h16x4(:,1683),heltab2x64(:,:,6829))
  call Hloop_A_Q(ntryL,G0H4(350),46,nMT,G1H4(860),n2h4(4084))
  Gcoeff(:)%j = (c(18)*(-M(5,:)%j+M(8,:)%j-M(11,:)%j+M(19,:)%j)) * den(1138)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(9233),h0tab(:,9233),[46,17],[nMT,0],2,2,wf16(:,478),wf4(:,17))
  call Hloop_VA_Q(ntryL,G0H64(1),wf16(:,478),G0H4(350),m3h16x4(:,1684),heltab2x64(:,:,6830))
  call Hloop_A_Q(ntryL,G0H4(350),46,nMT,G1H4(872),n2h4(4085))
  Gcoeff(:)%j = (c(28)*(M(2,:)%j-M(5,:)%j-M(11,:)%j+M(21,:)%j)) * den(1139)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(9234),h0tab(:,9234),[40,23],[0,0],2,2,wf4(:,6),wf16(:,351))
  call Hloop_QV_A(ntryL,G0H64(1),wf4(:,6),G0H16(374),m3h4x16(:,1230),heltab2x64(:,:,6831))
  call Hloop_Q_A(ntryL,G0H16(374),40,0,G1H16(913),n2h16(1902))
  Gcoeff(:)%j = (c(26)*(M(2,:)%j-M(5,:)%j-M(11,:)%j+M(21,:)%j)) * den(1139)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(9235),h0tab(:,9235),[40,23],[nMT,nMT],2,2,wf4(:,6),wf16(:,351))
  call Hloop_QV_A(ntryL,G0H64(1),wf4(:,6),G0H16(374),m3h4x16(:,1231),heltab2x64(:,:,6832))
  call Hloop_Q_A(ntryL,G0H16(374),40,nMT,G1H16(126),n2h16(1903))
  Gcoeff(:)%j = (c(28)*(M(2,:)%j-M(5,:)%j-M(11,:)%j+M(21,:)%j)) * den(1139)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(9236),h0tab(:,9236),[40,23],[0,0],2,2,wf4(:,6),wf16(:,351))
  call Hloop_QV_A(ntryL,G0H64(1),wf4(:,6),G0H16(374),m3h4x16(:,1232),heltab2x64(:,:,6833))
  call Hloop_Q_A(ntryL,G0H16(374),40,0,G1H16(133),n2h16(1904))
  Gcoeff(:)%j = (c(26)*(M(2,:)%j-M(5,:)%j-M(11,:)%j+M(21,:)%j)) * den(1139)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(9237),h0tab(:,9237),[40,23],[nMB,nMB],2,2,wf4(:,6),wf16(:,351))
  call Hloop_QV_A(ntryL,G0H64(1),wf4(:,6),G0H16(374),m3h4x16(:,1233),heltab2x64(:,:,6834))
  call Hloop_Q_A(ntryL,G0H16(374),40,nMB,G1H16(140),n2h16(1905))
  Gcoeff(:)%j = (c(20)*(M(2,:)%j-M(5,:)%j-M(11,:)%j+M(21,:)%j)) * den(1139)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(9238),h0tab(:,9238),[40,23],[0,0],2,2,wf4(:,6),wf16(:,351))
  call Hloop_CV_D(ntryL,G0H64(1),0,wf4(:,6),40,G1H16(903),m3h4x16(:,1234),heltab2x64(:,:,6835))
  Gcoeff(:)%j = (c(14)*(-M(2,:)%j+M(5,:)%j+M(11,:)%j-M(21,:)%j)) * den(1139)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(9239),h0tab(:,9239),[40,23],[0,0],2,2,wf4(:,6),wf16(:,351))
  call Hloop_UV_W(ntryL,G0H64(1),0,wf4(:,6),40,G1H16(9),m3h4x16(:,1235),heltab2x64(:,:,6836))
  Gcoeff(:)%j = (c(28)*(-M(2,:)%j+M(5,:)%j+M(11,:)%j-M(21,:)%j)) * den(740)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(9240),h0tab(:,9240),[44,19],[0,0],2,2,wf8(:,34),wf8(:,21))
  call Hloop_QV_A(ntryL,G0H64(1),wf8(:,34),G0H8(223),m3h8x8(:,1386),heltab2x64(:,:,6837))
  call Hloop_Q_A(ntryL,G0H8(223),44,0,G1H8(284),n2h8(3083))
  Gcoeff(:)%j = (c(26)*(-M(2,:)%j+M(5,:)%j+M(11,:)%j-M(21,:)%j)) * den(740)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(9241),h0tab(:,9241),[44,19],[nMT,nMT],2,2,wf8(:,34),wf8(:,21))
  call Hloop_QV_A(ntryL,G0H64(1),wf8(:,34),G0H8(223),m3h8x8(:,1387),heltab2x64(:,:,6838))
  call Hloop_Q_A(ntryL,G0H8(223),44,nMT,G1H8(283),n2h8(3084))
  Gcoeff(:)%j = (c(28)*(-M(2,:)%j+M(5,:)%j+M(11,:)%j-M(21,:)%j)) * den(740)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(9242),h0tab(:,9242),[44,19],[0,0],2,2,wf8(:,34),wf8(:,21))
  call Hloop_QV_A(ntryL,G0H64(1),wf8(:,34),G0H8(223),m3h8x8(:,1388),heltab2x64(:,:,6839))
  call Hloop_Q_A(ntryL,G0H8(223),44,0,G1H8(282),n2h8(3085))
  Gcoeff(:)%j = (c(26)*(-M(2,:)%j+M(5,:)%j+M(11,:)%j-M(21,:)%j)) * den(740)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(9243),h0tab(:,9243),[44,19],[nMB,nMB],2,2,wf8(:,34),wf8(:,21))
  call Hloop_QV_A(ntryL,G0H64(1),wf8(:,34),G0H8(223),m3h8x8(:,1389),heltab2x64(:,:,6840))
  call Hloop_Q_A(ntryL,G0H8(223),44,nMB,G1H8(1479),n2h8(3086))
  Gcoeff(:)%j = (c(20)*(-M(2,:)%j+M(5,:)%j+M(11,:)%j-M(21,:)%j)) * den(740)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(9244),h0tab(:,9244),[44,19],[0,0],2,2,wf8(:,34),wf8(:,21))
  call Hloop_CV_D(ntryL,G0H64(1),0,wf8(:,34),44,G1H8(343),m3h8x8(:,1390),heltab2x64(:,:,6841))
  Gcoeff(:)%j = (c(14)*(M(2,:)%j-M(5,:)%j-M(11,:)%j+M(21,:)%j)) * den(740)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(9245),h0tab(:,9245),[44,19],[0,0],2,2,wf8(:,34),wf8(:,21))
  call Hloop_UV_W(ntryL,G0H64(1),0,wf8(:,34),44,G1H8(850),m3h8x8(:,1391),heltab2x64(:,:,6842))
  Gcoeff(:)%j = (c(24)*(M(11,:)%j-M(21,:)%j)) * den(1140)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(9246),h0tab(:,9246),[40,23],[0,0],2,2,wf4(:,6),wf16(:,354))
  call Hloop_QV_A(ntryL,G0H64(1),wf4(:,6),G0H16(374),m3h4x16(:,1236),heltab2x64(:,:,6843))
  call Hloop_Q_A(ntryL,G0H16(374),40,0,G1H16(936),n2h16(1906))
  Gcoeff(:)%j = (c(22)*(M(11,:)%j-M(21,:)%j)) * den(1140)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(9247),h0tab(:,9247),[40,23],[nMT,nMT],2,2,wf4(:,6),wf16(:,354))
  call Hloop_QV_A(ntryL,G0H64(1),wf4(:,6),G0H16(374),m3h4x16(:,1237),heltab2x64(:,:,6844))
  call Hloop_Q_A(ntryL,G0H16(374),40,nMT,G1H16(905),n2h16(1907))
  Gcoeff(:)%j = (c(24)*(M(11,:)%j-M(21,:)%j)) * den(1140)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(9248),h0tab(:,9248),[40,23],[0,0],2,2,wf4(:,6),wf16(:,354))
  call Hloop_QV_A(ntryL,G0H64(1),wf4(:,6),G0H16(374),m3h4x16(:,1238),heltab2x64(:,:,6845))
  call Hloop_Q_A(ntryL,G0H16(374),40,0,G1H16(121),n2h16(1908))
  Gcoeff(:)%j = (c(22)*(M(11,:)%j-M(21,:)%j)) * den(1140)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(9249),h0tab(:,9249),[40,23],[nMB,nMB],2,2,wf4(:,6),wf16(:,354))
  call Hloop_QV_A(ntryL,G0H64(1),wf4(:,6),G0H16(374),m3h4x16(:,1239),heltab2x64(:,:,6846))
  call Hloop_Q_A(ntryL,G0H16(374),40,nMB,G1H16(12),n2h16(1909))
  Gcoeff(:)%j = (c(10)*(M(11,:)%j-M(21,:)%j)) * den(1140)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(9250),h0tab(:,9250),[40,23],[0,0],2,2,wf4(:,6),wf16(:,354))
  call Hloop_CV_D(ntryL,G0H64(1),0,wf4(:,6),40,G1H16(951),m3h4x16(:,1240),heltab2x64(:,:,6847))
  Gcoeff(:)%j = (c(4)*(-M(11,:)%j+M(21,:)%j)) * den(1140)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(9251),h0tab(:,9251),[40,23],[0,0],2,2,wf4(:,6),wf16(:,354))
  call Hloop_UV_W(ntryL,G0H64(1),0,wf4(:,6),40,G1H16(149),m3h4x16(:,1241),heltab2x64(:,:,6848))
  Gcoeff(:)%j = (c(8)*(-M(11,:)%j+M(21,:)%j)) * den(741)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(9252),h0tab(:,9252),[42,21],[0,nMT],2,2,wf8(:,54),wf8(:,88))
  call Hloop_QA_V(ntryL,G0H64(1),wf8(:,54),G0H8(223),m3h8x8(:,1392),heltab2x64(:,:,6849))
  Gcoeff(:)%j = (c(8)*(-M(11,:)%j+M(21,:)%j)) * den(1141)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(9253),h0tab(:,9253),[46,17],[nMT,0],2,2,wf16(:,494),wf4(:,17))
  call Hloop_VA_Q(ntryL,G0H64(1),wf16(:,494),G0H4(350),m3h16x4(:,1685),heltab2x64(:,:,6850))
  call Hloop_A_Q(ntryL,G0H4(350),46,nMT,G1H4(906),n2h4(4086))
  Gcoeff(:)%j = (c(18)*(M(2,:)%j-M(5,:)%j-M(11,:)%j+M(21,:)%j)) * den(1142)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(9254),h0tab(:,9254),[46,17],[nMT,0],2,2,wf16(:,496),wf4(:,17))
  call Hloop_VA_Q(ntryL,G0H64(1),wf16(:,496),G0H4(350),m3h16x4(:,1686),heltab2x64(:,:,6851))
  call Hloop_A_Q(ntryL,G0H4(350),46,nMT,G1H4(1003),n2h4(4087))
  Gcoeff(:)%j = (c(18)*M(15,:)%j) * den(748)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(9255),h0tab(:,9255),[37,26],[0,nMT],2,2,wf8(:,94),wf8(:,47))
  call Hloop_AQ_V(ntryL,G0H64(1),wf8(:,94),G0H8(224),m3h8x8(:,1393),heltab2x64(:,:,6852))
  Gcoeff(:)%j = (c(18)*M(15,:)%j) * den(1143)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(9256),h0tab(:,9256),[45,18],[nMT,0],2,2,wf16(:,432),wf4(:,19))
  call Hloop_VQ_A(ntryL,G0H64(1),wf16(:,432),G0H4(350),m3h16x4(:,1687),heltab2x64(:,:,6853))
  call Hloop_Q_A(ntryL,G0H4(350),45,nMT,G1H4(920),n2h4(4088))
  Gcoeff(:)%j = (c(18)*M(13,:)%j) * den(749)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(9257),h0tab(:,9257),[41,22],[nMT,0],2,2,wf8(:,71),wf8(:,80))
  call Hloop_VQ_A(ntryL,G0H64(1),wf8(:,71),G0H8(225),m3h8x8(:,1394),heltab2x64(:,:,6854))
  call Hloop_Q_A(ntryL,G0H8(225),41,nMT,G1H8(308),n2h8(3087))
  Gcoeff(:)%j = (c(18)*M(13,:)%j) * den(1144)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(9258),h0tab(:,9258),[45,18],[nMT,0],2,2,wf16(:,437),wf4(:,19))
  call Hloop_VQ_A(ntryL,G0H64(1),wf16(:,437),G0H4(350),m3h16x4(:,1688),heltab2x64(:,:,6855))
  call Hloop_Q_A(ntryL,G0H4(350),45,nMT,G1H4(944),n2h4(4089))
  Gcoeff(:)%j = (c(18)*M(13,:)%j) * den(1145)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(9259),h0tab(:,9259),[33,30],[0,nMT],2,2,wf4(:,21),wf16(:,376))
  call Hloop_AQ_V(ntryL,G0H64(1),wf4(:,21),G0H16(374),m3h4x16(:,1242),heltab2x64(:,:,6856))
  Gcoeff(:)%j = (c(18)*M(15,:)%j) * den(1146)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(9260),h0tab(:,9260),[33,30],[0,nMT],2,2,wf4(:,21),wf16(:,380))
  call Hloop_AQ_V(ntryL,G0H64(1),wf4(:,21),G0H16(375),m3h4x16(:,1243),heltab2x64(:,:,6857))
  Gcoeff(:)%j = (c(28)*(-M(14,:)%j+M(15,:)%j-M(16,:)%j+M(17,:)%j)) * den(1147)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(9261),h0tab(:,9261),[36,27],[0,0],2,2,wf4(:,4),wf16(:,370))
  call Hloop_QV_A(ntryL,G0H64(1),wf4(:,4),G0H16(376),m3h4x16(:,1244),heltab2x64(:,:,6858))
  call Hloop_Q_A(ntryL,G0H16(376),36,0,G1H16(155),n2h16(1910))
  Gcoeff(:)%j = (c(26)*(-M(14,:)%j+M(15,:)%j-M(16,:)%j+M(17,:)%j)) * den(1147)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(9262),h0tab(:,9262),[36,27],[nMT,nMT],2,2,wf4(:,4),wf16(:,370))
  call Hloop_QV_A(ntryL,G0H64(1),wf4(:,4),G0H16(376),m3h4x16(:,1245),heltab2x64(:,:,6859))
  call Hloop_Q_A(ntryL,G0H16(376),36,nMT,G1H16(208),n2h16(1911))
  Gcoeff(:)%j = (c(28)*(-M(14,:)%j+M(15,:)%j-M(16,:)%j+M(17,:)%j)) * den(1147)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(9263),h0tab(:,9263),[36,27],[0,0],2,2,wf4(:,4),wf16(:,370))
  call Hloop_QV_A(ntryL,G0H64(1),wf4(:,4),G0H16(376),m3h4x16(:,1246),heltab2x64(:,:,6860))
  call Hloop_Q_A(ntryL,G0H16(376),36,0,G1H16(253),n2h16(1912))
  Gcoeff(:)%j = (c(26)*(-M(14,:)%j+M(15,:)%j-M(16,:)%j+M(17,:)%j)) * den(1147)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(9264),h0tab(:,9264),[36,27],[nMB,nMB],2,2,wf4(:,4),wf16(:,370))
  call Hloop_QV_A(ntryL,G0H64(1),wf4(:,4),G0H16(376),m3h4x16(:,1247),heltab2x64(:,:,6861))
  call Hloop_Q_A(ntryL,G0H16(376),36,nMB,G1H16(122),n2h16(1913))
  Gcoeff(:)%j = (c(20)*(-M(14,:)%j+M(15,:)%j-M(16,:)%j+M(17,:)%j)) * den(1147)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(9265),h0tab(:,9265),[36,27],[0,0],2,2,wf4(:,4),wf16(:,370))
  call Hloop_CV_D(ntryL,G0H64(1),0,wf4(:,4),36,G1H16(289),m3h4x16(:,1248),heltab2x64(:,:,6862))
  Gcoeff(:)%j = (c(14)*(M(14,:)%j-M(15,:)%j+M(16,:)%j-M(17,:)%j)) * den(1147)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(9266),h0tab(:,9266),[36,27],[0,0],2,2,wf4(:,4),wf16(:,370))
  call Hloop_UV_W(ntryL,G0H64(1),0,wf4(:,4),36,G1H16(7),m3h4x16(:,1249),heltab2x64(:,:,6863))
  Gcoeff(:)%j = (c(28)*(M(14,:)%j-M(15,:)%j+M(16,:)%j-M(17,:)%j)) * den(752)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(9267),h0tab(:,9267),[44,19],[0,0],2,2,wf8(:,32),wf8(:,22))
  call Hloop_QV_A(ntryL,G0H64(1),wf8(:,32),G0H8(225),m3h8x8(:,1395),heltab2x64(:,:,6864))
  call Hloop_Q_A(ntryL,G0H8(225),44,0,G1H8(307),n2h8(3088))
  Gcoeff(:)%j = (c(26)*(M(14,:)%j-M(15,:)%j+M(16,:)%j-M(17,:)%j)) * den(752)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(9268),h0tab(:,9268),[44,19],[nMT,nMT],2,2,wf8(:,32),wf8(:,22))
  call Hloop_QV_A(ntryL,G0H64(1),wf8(:,32),G0H8(225),m3h8x8(:,1396),heltab2x64(:,:,6865))
  call Hloop_Q_A(ntryL,G0H8(225),44,nMT,G1H8(306),n2h8(3089))
  Gcoeff(:)%j = (c(28)*(M(14,:)%j-M(15,:)%j+M(16,:)%j-M(17,:)%j)) * den(752)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(9269),h0tab(:,9269),[44,19],[0,0],2,2,wf8(:,32),wf8(:,22))
  call Hloop_QV_A(ntryL,G0H64(1),wf8(:,32),G0H8(225),m3h8x8(:,1397),heltab2x64(:,:,6866))
  call Hloop_Q_A(ntryL,G0H8(225),44,0,G1H8(1494),n2h8(3090))
  Gcoeff(:)%j = (c(26)*(M(14,:)%j-M(15,:)%j+M(16,:)%j-M(17,:)%j)) * den(752)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(9270),h0tab(:,9270),[44,19],[nMB,nMB],2,2,wf8(:,32),wf8(:,22))
  call Hloop_QV_A(ntryL,G0H64(1),wf8(:,32),G0H8(225),m3h8x8(:,1398),heltab2x64(:,:,6867))
  call Hloop_Q_A(ntryL,G0H8(225),44,nMB,G1H8(332),n2h8(3091))
  Gcoeff(:)%j = (c(20)*(M(14,:)%j-M(15,:)%j+M(16,:)%j-M(17,:)%j)) * den(752)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(9271),h0tab(:,9271),[44,19],[0,0],2,2,wf8(:,32),wf8(:,22))
  call Hloop_CV_D(ntryL,G0H64(1),0,wf8(:,32),44,G1H8(825),m3h8x8(:,1399),heltab2x64(:,:,6868))
  Gcoeff(:)%j = (c(14)*(-M(14,:)%j+M(15,:)%j-M(16,:)%j+M(17,:)%j)) * den(752)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(9272),h0tab(:,9272),[44,19],[0,0],2,2,wf8(:,32),wf8(:,22))
  call Hloop_UV_W(ntryL,G0H64(1),0,wf8(:,32),44,G1H8(302),m3h8x8(:,1400),heltab2x64(:,:,6869))
  Gcoeff(:)%j = (c(8)*(-M(15,:)%j+M(16,:)%j)) * den(1148)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(9273),h0tab(:,9273),[45,18],[nMT,0],2,2,wf16(:,466),wf4(:,19))
  call Hloop_VQ_A(ntryL,G0H64(1),wf16(:,466),G0H4(350),m3h16x4(:,1689),heltab2x64(:,:,6870))
  call Hloop_Q_A(ntryL,G0H4(350),45,nMT,G1H4(315),n2h4(4090))
  Gcoeff(:)%j = (c(8)*(-M(15,:)%j+M(16,:)%j)) * den(753)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(9274),h0tab(:,9274),[37,26],[0,nMT],2,2,wf8(:,96),wf8(:,47))
  call Hloop_AQ_V(ntryL,G0H64(1),wf8(:,96),G0H8(225),m3h8x8(:,1401),heltab2x64(:,:,6871))
  Gcoeff(:)%j = (c(24)*(M(15,:)%j-M(16,:)%j)) * den(1149)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(9275),h0tab(:,9275),[36,27],[0,0],2,2,wf4(:,4),wf16(:,373))
  call Hloop_QV_A(ntryL,G0H64(1),wf4(:,4),G0H16(376),m3h4x16(:,1250),heltab2x64(:,:,6872))
  call Hloop_Q_A(ntryL,G0H16(376),36,0,G1H16(944),n2h16(1914))
  Gcoeff(:)%j = (c(22)*(M(15,:)%j-M(16,:)%j)) * den(1149)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(9276),h0tab(:,9276),[36,27],[nMT,nMT],2,2,wf4(:,4),wf16(:,373))
  call Hloop_QV_A(ntryL,G0H64(1),wf4(:,4),G0H16(376),m3h4x16(:,1251),heltab2x64(:,:,6873))
  call Hloop_Q_A(ntryL,G0H16(376),36,nMT,G1H16(53),n2h16(1915))
  Gcoeff(:)%j = (c(24)*(M(15,:)%j-M(16,:)%j)) * den(1149)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(9277),h0tab(:,9277),[36,27],[0,0],2,2,wf4(:,4),wf16(:,373))
  call Hloop_QV_A(ntryL,G0H64(1),wf4(:,4),G0H16(376),m3h4x16(:,1252),heltab2x64(:,:,6874))
  call Hloop_Q_A(ntryL,G0H16(376),36,0,G1H16(112),n2h16(1916))
  Gcoeff(:)%j = (c(22)*(M(15,:)%j-M(16,:)%j)) * den(1149)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(9278),h0tab(:,9278),[36,27],[nMB,nMB],2,2,wf4(:,4),wf16(:,373))
  call Hloop_QV_A(ntryL,G0H64(1),wf4(:,4),G0H16(376),m3h4x16(:,1253),heltab2x64(:,:,6875))
  call Hloop_Q_A(ntryL,G0H16(376),36,nMB,G1H16(42),n2h16(1917))
  Gcoeff(:)%j = (c(10)*(M(15,:)%j-M(16,:)%j)) * den(1149)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(9279),h0tab(:,9279),[36,27],[0,0],2,2,wf4(:,4),wf16(:,373))
  call Hloop_CV_D(ntryL,G0H64(1),0,wf4(:,4),36,G1H16(26),m3h4x16(:,1254),heltab2x64(:,:,6876))
  Gcoeff(:)%j = (c(4)*(-M(15,:)%j+M(16,:)%j)) * den(1149)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(9280),h0tab(:,9280),[36,27],[0,0],2,2,wf4(:,4),wf16(:,373))
  call Hloop_UV_W(ntryL,G0H64(1),0,wf4(:,4),36,G1H16(351),m3h4x16(:,1255),heltab2x64(:,:,6877))
  Gcoeff(:)%j = (c(18)*(-M(14,:)%j+M(15,:)%j-M(16,:)%j+M(17,:)%j)) * den(1150)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(9281),h0tab(:,9281),[45,18],[0,nMT],2,2,wf16(:,470),wf4(:,19))
  call Hloop_AQ_V(ntryL,G0H64(1),wf16(:,470),G0H4(350),m3h16x4(:,1690),heltab2x64(:,:,6878))
  Gcoeff(:)%j = (c(28)*(M(13,:)%j-M(14,:)%j-M(16,:)%j+M(18,:)%j)) * den(1151)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(9282),h0tab(:,9282),[40,23],[0,0],2,2,wf4(:,6),wf16(:,369))
  call Hloop_QV_A(ntryL,G0H64(1),wf4(:,6),G0H16(376),m3h4x16(:,1256),heltab2x64(:,:,6879))
  call Hloop_Q_A(ntryL,G0H16(376),40,0,G1H16(423),n2h16(1918))
  Gcoeff(:)%j = (c(26)*(M(13,:)%j-M(14,:)%j-M(16,:)%j+M(18,:)%j)) * den(1151)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(9283),h0tab(:,9283),[40,23],[nMT,nMT],2,2,wf4(:,6),wf16(:,369))
  call Hloop_QV_A(ntryL,G0H64(1),wf4(:,6),G0H16(376),m3h4x16(:,1257),heltab2x64(:,:,6880))
  call Hloop_Q_A(ntryL,G0H16(376),40,nMT,G1H16(453),n2h16(1919))
  Gcoeff(:)%j = (c(28)*(M(13,:)%j-M(14,:)%j-M(16,:)%j+M(18,:)%j)) * den(1151)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(9284),h0tab(:,9284),[40,23],[0,0],2,2,wf4(:,6),wf16(:,369))
  call Hloop_QV_A(ntryL,G0H64(1),wf4(:,6),G0H16(376),m3h4x16(:,1258),heltab2x64(:,:,6881))
  call Hloop_Q_A(ntryL,G0H16(376),40,0,G1H16(128),n2h16(1920))
  Gcoeff(:)%j = (c(26)*(M(13,:)%j-M(14,:)%j-M(16,:)%j+M(18,:)%j)) * den(1151)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(9285),h0tab(:,9285),[40,23],[nMB,nMB],2,2,wf4(:,6),wf16(:,369))
  call Hloop_QV_A(ntryL,G0H64(1),wf4(:,6),G0H16(376),m3h4x16(:,1259),heltab2x64(:,:,6882))
  call Hloop_Q_A(ntryL,G0H16(376),40,nMB,G1H16(805),n2h16(1921))
  Gcoeff(:)%j = (c(20)*(M(13,:)%j-M(14,:)%j-M(16,:)%j+M(18,:)%j)) * den(1151)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(9286),h0tab(:,9286),[40,23],[0,0],2,2,wf4(:,6),wf16(:,369))
  call Hloop_CV_D(ntryL,G0H64(1),0,wf4(:,6),40,G1H16(837),m3h4x16(:,1260),heltab2x64(:,:,6883))
  Gcoeff(:)%j = (c(14)*(-M(13,:)%j+M(14,:)%j+M(16,:)%j-M(18,:)%j)) * den(1151)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(9287),h0tab(:,9287),[40,23],[0,0],2,2,wf4(:,6),wf16(:,369))
  call Hloop_UV_W(ntryL,G0H64(1),0,wf4(:,6),40,G1H16(917),m3h4x16(:,1261),heltab2x64(:,:,6884))
  Gcoeff(:)%j = (c(28)*(-M(13,:)%j+M(14,:)%j+M(16,:)%j-M(18,:)%j)) * den(757)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(9288),h0tab(:,9288),[44,19],[0,0],2,2,wf8(:,34),wf8(:,22))
  call Hloop_QV_A(ntryL,G0H64(1),wf8(:,34),G0H8(226),m3h8x8(:,1402),heltab2x64(:,:,6885))
  call Hloop_Q_A(ntryL,G0H8(226),44,0,G1H8(296),n2h8(3092))
  Gcoeff(:)%j = (c(26)*(-M(13,:)%j+M(14,:)%j+M(16,:)%j-M(18,:)%j)) * den(757)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(9289),h0tab(:,9289),[44,19],[nMT,nMT],2,2,wf8(:,34),wf8(:,22))
  call Hloop_QV_A(ntryL,G0H64(1),wf8(:,34),G0H8(226),m3h8x8(:,1403),heltab2x64(:,:,6886))
  call Hloop_Q_A(ntryL,G0H8(226),44,nMT,G1H8(294),n2h8(3093))
  Gcoeff(:)%j = (c(28)*(-M(13,:)%j+M(14,:)%j+M(16,:)%j-M(18,:)%j)) * den(757)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(9290),h0tab(:,9290),[44,19],[0,0],2,2,wf8(:,34),wf8(:,22))
  call Hloop_QV_A(ntryL,G0H64(1),wf8(:,34),G0H8(226),m3h8x8(:,1404),heltab2x64(:,:,6887))
  call Hloop_Q_A(ntryL,G0H8(226),44,0,G1H8(1499),n2h8(3094))
  Gcoeff(:)%j = (c(26)*(-M(13,:)%j+M(14,:)%j+M(16,:)%j-M(18,:)%j)) * den(757)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(9291),h0tab(:,9291),[44,19],[nMB,nMB],2,2,wf8(:,34),wf8(:,22))
  call Hloop_QV_A(ntryL,G0H64(1),wf8(:,34),G0H8(226),m3h8x8(:,1405),heltab2x64(:,:,6888))
  call Hloop_Q_A(ntryL,G0H8(226),44,nMB,G1H8(354),n2h8(3095))
  Gcoeff(:)%j = (c(20)*(-M(13,:)%j+M(14,:)%j+M(16,:)%j-M(18,:)%j)) * den(757)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(9292),h0tab(:,9292),[44,19],[0,0],2,2,wf8(:,34),wf8(:,22))
  call Hloop_CV_D(ntryL,G0H64(1),0,wf8(:,34),44,G1H8(849),m3h8x8(:,1406),heltab2x64(:,:,6889))
  Gcoeff(:)%j = (c(14)*(M(13,:)%j-M(14,:)%j-M(16,:)%j+M(18,:)%j)) * den(757)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(9293),h0tab(:,9293),[44,19],[0,0],2,2,wf8(:,34),wf8(:,22))
  call Hloop_UV_W(ntryL,G0H64(1),0,wf8(:,34),44,G1H8(274),m3h8x8(:,1407),heltab2x64(:,:,6890))
  Gcoeff(:)%j = (c(8)*(-M(13,:)%j+M(14,:)%j)) * den(1152)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(9294),h0tab(:,9294),[45,18],[nMT,0],2,2,wf16(:,486),wf4(:,19))
  call Hloop_VQ_A(ntryL,G0H64(1),wf16(:,486),G0H4(351),m3h16x4(:,1691),heltab2x64(:,:,6891))
  call Hloop_Q_A(ntryL,G0H4(351),45,nMT,G1H4(949),n2h4(4091))
  Gcoeff(:)%j = (c(24)*(M(13,:)%j-M(14,:)%j)) * den(1153)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(9295),h0tab(:,9295),[40,23],[0,0],2,2,wf4(:,6),wf16(:,372))
  call Hloop_QV_A(ntryL,G0H64(1),wf4(:,6),G0H16(376),m3h4x16(:,1262),heltab2x64(:,:,6892))
  call Hloop_Q_A(ntryL,G0H16(376),40,0,G1H16(871),n2h16(1922))
  Gcoeff(:)%j = (c(22)*(M(13,:)%j-M(14,:)%j)) * den(1153)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(9296),h0tab(:,9296),[40,23],[nMT,nMT],2,2,wf4(:,6),wf16(:,372))
  call Hloop_QV_A(ntryL,G0H64(1),wf4(:,6),G0H16(376),m3h4x16(:,1263),heltab2x64(:,:,6893))
  call Hloop_Q_A(ntryL,G0H16(376),40,nMT,G1H16(904),n2h16(1923))
  Gcoeff(:)%j = (c(24)*(M(13,:)%j-M(14,:)%j)) * den(1153)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(9297),h0tab(:,9297),[40,23],[0,0],2,2,wf4(:,6),wf16(:,372))
  call Hloop_QV_A(ntryL,G0H64(1),wf4(:,6),G0H16(376),m3h4x16(:,1264),heltab2x64(:,:,6894))
  call Hloop_Q_A(ntryL,G0H16(376),40,0,G1H16(143),n2h16(1924))
  Gcoeff(:)%j = (c(22)*(M(13,:)%j-M(14,:)%j)) * den(1153)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(9298),h0tab(:,9298),[40,23],[nMB,nMB],2,2,wf4(:,6),wf16(:,372))
  call Hloop_QV_A(ntryL,G0H64(1),wf4(:,6),G0H16(376),m3h4x16(:,1265),heltab2x64(:,:,6895))
  call Hloop_Q_A(ntryL,G0H16(376),40,nMB,G1H16(61),n2h16(1925))
  Gcoeff(:)%j = (c(10)*(M(13,:)%j-M(14,:)%j)) * den(1153)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(9299),h0tab(:,9299),[40,23],[0,0],2,2,wf4(:,6),wf16(:,372))
  call Hloop_CV_D(ntryL,G0H64(1),0,wf4(:,6),40,G1H16(189),m3h4x16(:,1266),heltab2x64(:,:,6896))
  Gcoeff(:)%j = (c(4)*(-M(13,:)%j+M(14,:)%j)) * den(1153)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(9300),h0tab(:,9300),[40,23],[0,0],2,2,wf4(:,6),wf16(:,372))
  call Hloop_UV_W(ntryL,G0H64(1),0,wf4(:,6),40,G1H16(158),m3h4x16(:,1267),heltab2x64(:,:,6897))
  Gcoeff(:)%j = (c(18)*(M(13,:)%j-M(14,:)%j-M(16,:)%j+M(18,:)%j)) * den(1154)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(9301),h0tab(:,9301),[45,18],[0,nMT],2,2,wf16(:,488),wf4(:,19))
  call Hloop_AQ_V(ntryL,G0H64(1),wf16(:,488),G0H4(351),m3h16x4(:,1692),heltab2x64(:,:,6898))
  Gcoeff(:)%j = (c(8)*(-M(13,:)%j+M(14,:)%j)) * den(758)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(9302),h0tab(:,9302),[41,22],[0,nMT],2,2,wf8(:,74),wf8(:,80))
  call Hloop_AQ_V(ntryL,G0H64(1),wf8(:,74),G0H8(226),m3h8x8(:,1408),heltab2x64(:,:,6899))
  Gcoeff(:)%j = (c(28)*(-M(3,:)%j+M(7,:)%j-M(9,:)%j+M(13,:)%j)) * den(1155)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(9303),h0tab(:,9303),[43,20],[0,0],2,2,wf16(:,428),wf4(:,3))
  call Hloop_QV_A(ntryL,G0H64(1),wf16(:,428),G0H4(352),m3h16x4(:,1693),heltab2x64(:,:,6900))
  call Hloop_Q_A(ntryL,G0H4(352),43,0,G1H4(1039),n2h4(4092))
  Gcoeff(:)%j = (c(26)*(-M(3,:)%j+M(7,:)%j-M(9,:)%j+M(13,:)%j)) * den(1155)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(9304),h0tab(:,9304),[43,20],[nMT,nMT],2,2,wf16(:,428),wf4(:,3))
  call Hloop_QV_A(ntryL,G0H64(1),wf16(:,428),G0H4(352),m3h16x4(:,1694),heltab2x64(:,:,6901))
  call Hloop_Q_A(ntryL,G0H4(352),43,nMT,G1H4(962),n2h4(4093))
  Gcoeff(:)%j = (c(28)*(-M(3,:)%j+M(7,:)%j-M(9,:)%j+M(13,:)%j)) * den(1155)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(9305),h0tab(:,9305),[43,20],[0,0],2,2,wf16(:,428),wf4(:,3))
  call Hloop_QV_A(ntryL,G0H64(1),wf16(:,428),G0H4(352),m3h16x4(:,1695),heltab2x64(:,:,6902))
  call Hloop_Q_A(ntryL,G0H4(352),43,0,G1H4(980),n2h4(4094))
  Gcoeff(:)%j = (c(26)*(-M(3,:)%j+M(7,:)%j-M(9,:)%j+M(13,:)%j)) * den(1155)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(9306),h0tab(:,9306),[43,20],[nMB,nMB],2,2,wf16(:,428),wf4(:,3))
  call Hloop_QV_A(ntryL,G0H64(1),wf16(:,428),G0H4(352),m3h16x4(:,1696),heltab2x64(:,:,6903))
  call Hloop_Q_A(ntryL,G0H4(352),43,nMB,G1H4(997),n2h4(4095))
  Gcoeff(:)%j = (c(20)*(-M(3,:)%j+M(7,:)%j-M(9,:)%j+M(13,:)%j)) * den(1155)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(9307),h0tab(:,9307),[43,20],[0,0],2,2,wf16(:,428),wf4(:,3))
  call Hloop_CV_D(ntryL,G0H64(1),0,wf16(:,428),43,G1H4(1026),m3h16x4(:,1697),heltab2x64(:,:,6904))
  Gcoeff(:)%j = (c(14)*(M(3,:)%j-M(7,:)%j+M(9,:)%j-M(13,:)%j)) * den(1155)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(9308),h0tab(:,9308),[43,20],[0,0],2,2,wf16(:,428),wf4(:,3))
  call Hloop_UV_W(ntryL,G0H64(1),0,wf16(:,428),43,G1H4(1038),m3h16x4(:,1698),heltab2x64(:,:,6905))
  Gcoeff(:)%j = (c(28)*(M(3,:)%j-M(7,:)%j+M(9,:)%j-M(13,:)%j)) * den(765)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(9309),h0tab(:,9309),[35,28],[0,0],2,2,wf8(:,23),wf8(:,28))
  call Hloop_QV_A(ntryL,G0H64(1),wf8(:,23),G0H8(227),m3h8x8(:,1409),heltab2x64(:,:,6906))
  call Hloop_Q_A(ntryL,G0H8(227),35,0,G1H8(201),n2h8(3096))
  Gcoeff(:)%j = (c(26)*(M(3,:)%j-M(7,:)%j+M(9,:)%j-M(13,:)%j)) * den(765)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(9310),h0tab(:,9310),[35,28],[nMT,nMT],2,2,wf8(:,23),wf8(:,28))
  call Hloop_QV_A(ntryL,G0H64(1),wf8(:,23),G0H8(227),m3h8x8(:,1410),heltab2x64(:,:,6907))
  call Hloop_Q_A(ntryL,G0H8(227),35,nMT,G1H8(317),n2h8(3097))
  Gcoeff(:)%j = (c(28)*(M(3,:)%j-M(7,:)%j+M(9,:)%j-M(13,:)%j)) * den(765)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(9311),h0tab(:,9311),[35,28],[0,0],2,2,wf8(:,23),wf8(:,28))
  call Hloop_QV_A(ntryL,G0H64(1),wf8(:,23),G0H8(227),m3h8x8(:,1411),heltab2x64(:,:,6908))
  call Hloop_Q_A(ntryL,G0H8(227),35,0,G1H8(1509),n2h8(3098))
  Gcoeff(:)%j = (c(26)*(M(3,:)%j-M(7,:)%j+M(9,:)%j-M(13,:)%j)) * den(765)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(9312),h0tab(:,9312),[35,28],[nMB,nMB],2,2,wf8(:,23),wf8(:,28))
  call Hloop_QV_A(ntryL,G0H64(1),wf8(:,23),G0H8(227),m3h8x8(:,1412),heltab2x64(:,:,6909))
  call Hloop_Q_A(ntryL,G0H8(227),35,nMB,G1H8(74),n2h8(3099))
  Gcoeff(:)%j = (c(20)*(M(3,:)%j-M(7,:)%j+M(9,:)%j-M(13,:)%j)) * den(765)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(9313),h0tab(:,9313),[35,28],[0,0],2,2,wf8(:,23),wf8(:,28))
  call Hloop_CV_D(ntryL,G0H64(1),0,wf8(:,23),35,G1H8(747),m3h8x8(:,1413),heltab2x64(:,:,6910))
  Gcoeff(:)%j = (c(14)*(-M(3,:)%j+M(7,:)%j-M(9,:)%j+M(13,:)%j)) * den(765)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(9314),h0tab(:,9314),[35,28],[0,0],2,2,wf8(:,23),wf8(:,28))
  call Hloop_UV_W(ntryL,G0H64(1),0,wf8(:,23),35,G1H8(565),m3h8x8(:,1414),heltab2x64(:,:,6911))
  Gcoeff(:)%j = (c(8)*(-M(3,:)%j+M(13,:)%j)) * den(766)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(9315),h0tab(:,9315),[41,22],[nMT,0],2,2,wf8(:,71),wf8(:,82))
  call Hloop_VQ_A(ntryL,G0H64(1),wf8(:,71),G0H8(227),m3h8x8(:,1415),heltab2x64(:,:,6912))
  call Hloop_Q_A(ntryL,G0H8(227),41,nMT,G1H8(105),n2h8(3100))
  Gcoeff(:)%j = (c(24)*(M(3,:)%j-M(13,:)%j)) * den(1156)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(9316),h0tab(:,9316),[43,20],[0,0],2,2,wf16(:,435),wf4(:,3))
  call Hloop_QV_A(ntryL,G0H64(1),wf16(:,435),G0H4(352),m3h16x4(:,1699),heltab2x64(:,:,6913))
  call Hloop_Q_A(ntryL,G0H4(352),43,0,G1H4(1064),n2h4(4096))
  Gcoeff(:)%j = (c(22)*(M(3,:)%j-M(13,:)%j)) * den(1156)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(9317),h0tab(:,9317),[43,20],[nMT,nMT],2,2,wf16(:,435),wf4(:,3))
  call Hloop_QV_A(ntryL,G0H64(1),wf16(:,435),G0H4(352),m3h16x4(:,1700),heltab2x64(:,:,6914))
  call Hloop_Q_A(ntryL,G0H4(352),43,nMT,G1H4(1076),n2h4(4097))
  Gcoeff(:)%j = (c(24)*(M(3,:)%j-M(13,:)%j)) * den(1156)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(9318),h0tab(:,9318),[43,20],[0,0],2,2,wf16(:,435),wf4(:,3))
  call Hloop_QV_A(ntryL,G0H64(1),wf16(:,435),G0H4(352),m3h16x4(:,1701),heltab2x64(:,:,6915))
  call Hloop_Q_A(ntryL,G0H4(352),43,0,G1H4(1081),n2h4(4098))
  Gcoeff(:)%j = (c(22)*(M(3,:)%j-M(13,:)%j)) * den(1156)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(9319),h0tab(:,9319),[43,20],[nMB,nMB],2,2,wf16(:,435),wf4(:,3))
  call Hloop_QV_A(ntryL,G0H64(1),wf16(:,435),G0H4(352),m3h16x4(:,1702),heltab2x64(:,:,6916))
  call Hloop_Q_A(ntryL,G0H4(352),43,nMB,G1H4(1106),n2h4(4099))
  Gcoeff(:)%j = (c(10)*(M(3,:)%j-M(13,:)%j)) * den(1156)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(9320),h0tab(:,9320),[43,20],[0,0],2,2,wf16(:,435),wf4(:,3))
  call Hloop_CV_D(ntryL,G0H64(1),0,wf16(:,435),43,G1H4(1122),m3h16x4(:,1703),heltab2x64(:,:,6917))
  Gcoeff(:)%j = (c(4)*(-M(3,:)%j+M(13,:)%j)) * den(1156)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(9321),h0tab(:,9321),[43,20],[0,0],2,2,wf16(:,435),wf4(:,3))
  call Hloop_UV_W(ntryL,G0H64(1),0,wf16(:,435),43,G1H4(1123),m3h16x4(:,1704),heltab2x64(:,:,6918))
  Gcoeff(:)%j = (c(8)*(-M(3,:)%j+M(13,:)%j)) * den(1157)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(9322),h0tab(:,9322),[33,30],[0,nMT],2,2,wf4(:,21),wf16(:,398))
  call Hloop_AQ_V(ntryL,G0H64(1),wf4(:,21),G0H16(376),m3h4x16(:,1268),heltab2x64(:,:,6919))
  Gcoeff(:)%j = (c(18)*(-M(3,:)%j+M(7,:)%j-M(9,:)%j+M(13,:)%j)) * den(1158)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(9323),h0tab(:,9323),[33,30],[0,nMT],2,2,wf4(:,21),wf16(:,402))
  call Hloop_AQ_V(ntryL,G0H64(1),wf4(:,21),G0H16(377),m3h4x16(:,1269),heltab2x64(:,:,6920))
  Gcoeff(:)%j = (c(28)*(-M(20,:)%j+M(21,:)%j-M(22,:)%j+M(23,:)%j)) * den(1159)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(9324),h0tab(:,9324),[43,20],[0,0],2,2,wf16(:,446),wf4(:,3))
  call Hloop_QV_A(ntryL,G0H64(1),wf16(:,446),G0H4(352),m3h16x4(:,1705),heltab2x64(:,:,6921))
  call Hloop_Q_A(ntryL,G0H4(352),43,0,G1H4(1168),n2h4(4100))
  Gcoeff(:)%j = (c(26)*(-M(20,:)%j+M(21,:)%j-M(22,:)%j+M(23,:)%j)) * den(1159)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(9325),h0tab(:,9325),[43,20],[nMT,nMT],2,2,wf16(:,446),wf4(:,3))
  call Hloop_QV_A(ntryL,G0H64(1),wf16(:,446),G0H4(352),m3h16x4(:,1706),heltab2x64(:,:,6922))
  call Hloop_Q_A(ntryL,G0H4(352),43,nMT,G1H4(399),n2h4(4101))
  Gcoeff(:)%j = (c(28)*(-M(20,:)%j+M(21,:)%j-M(22,:)%j+M(23,:)%j)) * den(1159)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(9326),h0tab(:,9326),[43,20],[0,0],2,2,wf16(:,446),wf4(:,3))
  call Hloop_QV_A(ntryL,G0H64(1),wf16(:,446),G0H4(352),m3h16x4(:,1707),heltab2x64(:,:,6923))
  call Hloop_Q_A(ntryL,G0H4(352),43,0,G1H4(36),n2h4(4102))
  Gcoeff(:)%j = (c(26)*(-M(20,:)%j+M(21,:)%j-M(22,:)%j+M(23,:)%j)) * den(1159)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(9327),h0tab(:,9327),[43,20],[nMB,nMB],2,2,wf16(:,446),wf4(:,3))
  call Hloop_QV_A(ntryL,G0H64(1),wf16(:,446),G0H4(352),m3h16x4(:,1708),heltab2x64(:,:,6924))
  call Hloop_Q_A(ntryL,G0H4(352),43,nMB,G1H4(108),n2h4(4103))
  Gcoeff(:)%j = (c(20)*(-M(20,:)%j+M(21,:)%j-M(22,:)%j+M(23,:)%j)) * den(1159)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(9328),h0tab(:,9328),[43,20],[0,0],2,2,wf16(:,446),wf4(:,3))
  call Hloop_CV_D(ntryL,G0H64(1),0,wf16(:,446),43,G1H4(120),m3h16x4(:,1709),heltab2x64(:,:,6925))
  Gcoeff(:)%j = (c(14)*(M(20,:)%j-M(21,:)%j+M(22,:)%j-M(23,:)%j)) * den(1159)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(9329),h0tab(:,9329),[43,20],[0,0],2,2,wf16(:,446),wf4(:,3))
  call Hloop_UV_W(ntryL,G0H64(1),0,wf16(:,446),43,G1H4(924),m3h16x4(:,1710),heltab2x64(:,:,6926))
  Gcoeff(:)%j = (c(28)*(M(20,:)%j-M(21,:)%j+M(22,:)%j-M(23,:)%j)) * den(770)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(9330),h0tab(:,9330),[35,28],[0,0],2,2,wf8(:,24),wf8(:,28))
  call Hloop_QV_A(ntryL,G0H64(1),wf8(:,24),G0H8(227),m3h8x8(:,1416),heltab2x64(:,:,6927))
  call Hloop_Q_A(ntryL,G0H8(227),35,0,G1H8(689),n2h8(3101))
  Gcoeff(:)%j = (c(26)*(M(20,:)%j-M(21,:)%j+M(22,:)%j-M(23,:)%j)) * den(770)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(9331),h0tab(:,9331),[35,28],[nMT,nMT],2,2,wf8(:,24),wf8(:,28))
  call Hloop_QV_A(ntryL,G0H64(1),wf8(:,24),G0H8(227),m3h8x8(:,1417),heltab2x64(:,:,6928))
  call Hloop_Q_A(ntryL,G0H8(227),35,nMT,G1H8(617),n2h8(3102))
  Gcoeff(:)%j = (c(28)*(M(20,:)%j-M(21,:)%j+M(22,:)%j-M(23,:)%j)) * den(770)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(9332),h0tab(:,9332),[35,28],[0,0],2,2,wf8(:,24),wf8(:,28))
  call Hloop_QV_A(ntryL,G0H64(1),wf8(:,24),G0H8(227),m3h8x8(:,1418),heltab2x64(:,:,6929))
  call Hloop_Q_A(ntryL,G0H8(227),35,0,G1H8(455),n2h8(3103))
  Gcoeff(:)%j = (c(26)*(M(20,:)%j-M(21,:)%j+M(22,:)%j-M(23,:)%j)) * den(770)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(9333),h0tab(:,9333),[35,28],[nMB,nMB],2,2,wf8(:,24),wf8(:,28))
  call Hloop_QV_A(ntryL,G0H64(1),wf8(:,24),G0H8(227),m3h8x8(:,1419),heltab2x64(:,:,6930))
  call Hloop_Q_A(ntryL,G0H8(227),35,nMB,G1H8(452),n2h8(3104))
  Gcoeff(:)%j = (c(20)*(M(20,:)%j-M(21,:)%j+M(22,:)%j-M(23,:)%j)) * den(770)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(9334),h0tab(:,9334),[35,28],[0,0],2,2,wf8(:,24),wf8(:,28))
  call Hloop_CV_D(ntryL,G0H64(1),0,wf8(:,24),35,G1H8(451),m3h8x8(:,1420),heltab2x64(:,:,6931))
  Gcoeff(:)%j = (c(14)*(-M(20,:)%j+M(21,:)%j-M(22,:)%j+M(23,:)%j)) * den(770)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(9335),h0tab(:,9335),[35,28],[0,0],2,2,wf8(:,24),wf8(:,28))
  call Hloop_UV_W(ntryL,G0H64(1),0,wf8(:,24),35,G1H8(58),m3h8x8(:,1421),heltab2x64(:,:,6932))
  Gcoeff(:)%j = (c(8)*(-M(21,:)%j+M(22,:)%j)) * den(1160)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(9336),h0tab(:,9336),[34,29],[0,nMT],2,2,wf4(:,23),wf16(:,390))
  call Hloop_QA_V(ntryL,G0H64(1),wf4(:,23),G0H16(378),m3h4x16(:,1270),heltab2x64(:,:,6933))
  Gcoeff(:)%j = (c(8)*(-M(21,:)%j+M(22,:)%j)) * den(771)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(9337),h0tab(:,9337),[42,21],[nMT,0],2,2,wf8(:,52),wf8(:,92))
  call Hloop_VA_Q(ntryL,G0H64(1),wf8(:,52),G0H8(227),m3h8x8(:,1422),heltab2x64(:,:,6934))
  call Hloop_A_Q(ntryL,G0H8(227),42,nMT,G1H8(407),n2h8(3105))
  Gcoeff(:)%j = (c(24)*(M(21,:)%j-M(22,:)%j)) * den(1161)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(9338),h0tab(:,9338),[43,20],[0,0],2,2,wf16(:,449),wf4(:,3))
  call Hloop_QV_A(ntryL,G0H64(1),wf16(:,449),G0H4(352),m3h16x4(:,1711),heltab2x64(:,:,6935))
  call Hloop_Q_A(ntryL,G0H4(352),43,0,G1H4(360),n2h4(4104))
  Gcoeff(:)%j = (c(22)*(M(21,:)%j-M(22,:)%j)) * den(1161)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(9339),h0tab(:,9339),[43,20],[nMT,nMT],2,2,wf16(:,449),wf4(:,3))
  call Hloop_QV_A(ntryL,G0H64(1),wf16(:,449),G0H4(352),m3h16x4(:,1712),heltab2x64(:,:,6936))
  call Hloop_Q_A(ntryL,G0H4(352),43,nMT,G1H4(840),n2h4(4105))
  Gcoeff(:)%j = (c(24)*(M(21,:)%j-M(22,:)%j)) * den(1161)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(9340),h0tab(:,9340),[43,20],[0,0],2,2,wf16(:,449),wf4(:,3))
  call Hloop_QV_A(ntryL,G0H64(1),wf16(:,449),G0H4(352),m3h16x4(:,1713),heltab2x64(:,:,6937))
  call Hloop_Q_A(ntryL,G0H4(352),43,0,G1H4(912),n2h4(4106))
  Gcoeff(:)%j = (c(22)*(M(21,:)%j-M(22,:)%j)) * den(1161)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(9341),h0tab(:,9341),[43,20],[nMB,nMB],2,2,wf16(:,449),wf4(:,3))
  call Hloop_QV_A(ntryL,G0H64(1),wf16(:,449),G0H4(352),m3h16x4(:,1714),heltab2x64(:,:,6938))
  call Hloop_Q_A(ntryL,G0H4(352),43,nMB,G1H4(471),n2h4(4107))
  Gcoeff(:)%j = (c(10)*(M(21,:)%j-M(22,:)%j)) * den(1161)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(9342),h0tab(:,9342),[43,20],[0,0],2,2,wf16(:,449),wf4(:,3))
  call Hloop_CV_D(ntryL,G0H64(1),0,wf16(:,449),43,G1H4(1092),m3h16x4(:,1715),heltab2x64(:,:,6939))
  Gcoeff(:)%j = (c(4)*(-M(21,:)%j+M(22,:)%j)) * den(1161)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(9343),h0tab(:,9343),[43,20],[0,0],2,2,wf16(:,449),wf4(:,3))
  call Hloop_UV_W(ntryL,G0H64(1),0,wf16(:,449),43,G1H4(1121),m3h16x4(:,1716),heltab2x64(:,:,6940))
  Gcoeff(:)%j = (c(18)*(-M(20,:)%j+M(21,:)%j-M(22,:)%j+M(23,:)%j)) * den(1162)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(9344),h0tab(:,9344),[34,29],[nMT,0],2,2,wf4(:,23),wf16(:,394))
  call Hloop_VA_Q(ntryL,G0H64(1),wf4(:,23),G0H16(379),m3h4x16(:,1271),heltab2x64(:,:,6941))
  call Hloop_A_Q(ntryL,G0H16(379),34,nMT,G1H16(245),n2h16(1926))
  Gcoeff(:)%j = (c(28)*(-M(11,:)%j+M(12,:)%j+M(21,:)%j-M(22,:)%j)) * den(1163)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(9345),h0tab(:,9345),[40,23],[0,0],2,2,wf4(:,6),wf16(:,387))
  call Hloop_QV_A(ntryL,G0H64(1),wf4(:,6),G0H16(379),m3h4x16(:,1272),heltab2x64(:,:,6942))
  call Hloop_Q_A(ntryL,G0H16(379),40,0,G1H16(931),n2h16(1927))
  Gcoeff(:)%j = (c(26)*(-M(11,:)%j+M(12,:)%j+M(21,:)%j-M(22,:)%j)) * den(1163)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(9346),h0tab(:,9346),[40,23],[nMT,nMT],2,2,wf4(:,6),wf16(:,387))
  call Hloop_QV_A(ntryL,G0H64(1),wf4(:,6),G0H16(379),m3h4x16(:,1273),heltab2x64(:,:,6943))
  call Hloop_Q_A(ntryL,G0H16(379),40,nMT,G1H16(28),n2h16(1928))
  Gcoeff(:)%j = (c(28)*(-M(11,:)%j+M(12,:)%j+M(21,:)%j-M(22,:)%j)) * den(1163)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(9347),h0tab(:,9347),[40,23],[0,0],2,2,wf4(:,6),wf16(:,387))
  call Hloop_QV_A(ntryL,G0H64(1),wf4(:,6),G0H16(379),m3h4x16(:,1274),heltab2x64(:,:,6944))
  call Hloop_Q_A(ntryL,G0H16(379),40,0,G1H16(25),n2h16(1929))
  Gcoeff(:)%j = (c(26)*(-M(11,:)%j+M(12,:)%j+M(21,:)%j-M(22,:)%j)) * den(1163)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(9348),h0tab(:,9348),[40,23],[nMB,nMB],2,2,wf4(:,6),wf16(:,387))
  call Hloop_QV_A(ntryL,G0H64(1),wf4(:,6),G0H16(379),m3h4x16(:,1275),heltab2x64(:,:,6945))
  call Hloop_Q_A(ntryL,G0H16(379),40,nMB,G1H16(929),n2h16(1930))
  Gcoeff(:)%j = (c(20)*(-M(11,:)%j+M(12,:)%j+M(21,:)%j-M(22,:)%j)) * den(1163)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(9349),h0tab(:,9349),[40,23],[0,0],2,2,wf4(:,6),wf16(:,387))
  call Hloop_CV_D(ntryL,G0H64(1),0,wf4(:,6),40,G1H16(316),m3h4x16(:,1276),heltab2x64(:,:,6946))
  Gcoeff(:)%j = (c(14)*(M(11,:)%j-M(12,:)%j-M(21,:)%j+M(22,:)%j)) * den(1163)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(9350),h0tab(:,9350),[40,23],[0,0],2,2,wf4(:,6),wf16(:,387))
  call Hloop_UV_W(ntryL,G0H64(1),0,wf4(:,6),40,G1H16(173),m3h4x16(:,1277),heltab2x64(:,:,6947))
  Gcoeff(:)%j = (c(28)*(-M(3,:)%j+M(4,:)%j+M(13,:)%j-M(14,:)%j)) * den(1164)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(9351),h0tab(:,9351),[43,20],[0,0],2,2,wf16(:,483),wf4(:,3))
  call Hloop_QV_A(ntryL,G0H64(1),wf16(:,483),G0H4(352),m3h16x4(:,1717),heltab2x64(:,:,6948))
  call Hloop_Q_A(ntryL,G0H4(352),43,0,G1H4(73),n2h4(4108))
  Gcoeff(:)%j = (c(26)*(-M(3,:)%j+M(4,:)%j+M(13,:)%j-M(14,:)%j)) * den(1164)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(9352),h0tab(:,9352),[43,20],[nMT,nMT],2,2,wf16(:,483),wf4(:,3))
  call Hloop_QV_A(ntryL,G0H64(1),wf16(:,483),G0H4(352),m3h16x4(:,1718),heltab2x64(:,:,6949))
  call Hloop_Q_A(ntryL,G0H4(352),43,nMT,G1H4(31),n2h4(4109))
  Gcoeff(:)%j = (c(28)*(-M(3,:)%j+M(4,:)%j+M(13,:)%j-M(14,:)%j)) * den(1164)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(9353),h0tab(:,9353),[43,20],[0,0],2,2,wf16(:,483),wf4(:,3))
  call Hloop_QV_A(ntryL,G0H64(1),wf16(:,483),G0H4(352),m3h16x4(:,1719),heltab2x64(:,:,6950))
  call Hloop_Q_A(ntryL,G0H4(352),43,0,G1H4(55),n2h4(4110))
  Gcoeff(:)%j = (c(26)*(-M(3,:)%j+M(4,:)%j+M(13,:)%j-M(14,:)%j)) * den(1164)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(9354),h0tab(:,9354),[43,20],[nMB,nMB],2,2,wf16(:,483),wf4(:,3))
  call Hloop_QV_A(ntryL,G0H64(1),wf16(:,483),G0H4(352),m3h16x4(:,1720),heltab2x64(:,:,6951))
  call Hloop_Q_A(ntryL,G0H4(352),43,nMB,G1H4(68),n2h4(4111))
  Gcoeff(:)%j = (c(20)*(-M(3,:)%j+M(4,:)%j+M(13,:)%j-M(14,:)%j)) * den(1164)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(9355),h0tab(:,9355),[43,20],[0,0],2,2,wf16(:,483),wf4(:,3))
  call Hloop_CV_D(ntryL,G0H64(1),0,wf16(:,483),43,G1H4(98),m3h16x4(:,1721),heltab2x64(:,:,6952))
  Gcoeff(:)%j = (c(14)*(M(3,:)%j-M(4,:)%j-M(13,:)%j+M(14,:)%j)) * den(1164)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(9356),h0tab(:,9356),[43,20],[0,0],2,2,wf16(:,483),wf4(:,3))
  call Hloop_UV_W(ntryL,G0H64(1),0,wf16(:,483),43,G1H4(110),m3h16x4(:,1722),heltab2x64(:,:,6953))
  Gcoeff(:)%j = (c(28)*(-M(3,:)%j+M(4,:)%j+M(13,:)%j-M(14,:)%j)) * den(1165)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(9357),h0tab(:,9357),[40,23],[0,0],2,2,wf4(:,6),wf16(:,388))
  call Hloop_QV_A(ntryL,G0H64(1),wf4(:,6),G0H16(379),m3h4x16(:,1278),heltab2x64(:,:,6954))
  call Hloop_Q_A(ntryL,G0H16(379),40,0,G1H16(215),n2h16(1931))
  Gcoeff(:)%j = (c(26)*(-M(3,:)%j+M(4,:)%j+M(13,:)%j-M(14,:)%j)) * den(1165)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(9358),h0tab(:,9358),[40,23],[nMT,nMT],2,2,wf4(:,6),wf16(:,388))
  call Hloop_QV_A(ntryL,G0H64(1),wf4(:,6),G0H16(379),m3h4x16(:,1279),heltab2x64(:,:,6955))
  call Hloop_Q_A(ntryL,G0H16(379),40,nMT,G1H16(65),n2h16(1932))
  Gcoeff(:)%j = (c(28)*(-M(3,:)%j+M(4,:)%j+M(13,:)%j-M(14,:)%j)) * den(1165)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(9359),h0tab(:,9359),[40,23],[0,0],2,2,wf4(:,6),wf16(:,388))
  call Hloop_QV_A(ntryL,G0H64(1),wf4(:,6),G0H16(379),m3h4x16(:,1280),heltab2x64(:,:,6956))
  call Hloop_Q_A(ntryL,G0H16(379),40,0,G1H16(138),n2h16(1933))
  Gcoeff(:)%j = (c(26)*(-M(3,:)%j+M(4,:)%j+M(13,:)%j-M(14,:)%j)) * den(1165)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(9360),h0tab(:,9360),[40,23],[nMB,nMB],2,2,wf4(:,6),wf16(:,388))
  call Hloop_QV_A(ntryL,G0H64(1),wf4(:,6),G0H16(379),m3h4x16(:,1281),heltab2x64(:,:,6957))
  call Hloop_Q_A(ntryL,G0H16(379),40,nMB,G1H16(381),n2h16(1934))
  Gcoeff(:)%j = (c(20)*(-M(3,:)%j+M(4,:)%j+M(13,:)%j-M(14,:)%j)) * den(1165)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(9361),h0tab(:,9361),[40,23],[0,0],2,2,wf4(:,6),wf16(:,388))
  call Hloop_CV_D(ntryL,G0H64(1),0,wf4(:,6),40,G1H16(4),m3h4x16(:,1282),heltab2x64(:,:,6958))
  Gcoeff(:)%j = (c(14)*(M(3,:)%j-M(4,:)%j-M(13,:)%j+M(14,:)%j)) * den(1165)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(9362),h0tab(:,9362),[40,23],[0,0],2,2,wf4(:,6),wf16(:,388))
  call Hloop_UV_W(ntryL,G0H64(1),0,wf4(:,6),40,G1H16(956),m3h4x16(:,1283),heltab2x64(:,:,6959))
  Gcoeff(:)%j = (c(28)*(-M(11,:)%j+M(12,:)%j+M(21,:)%j-M(22,:)%j)) * den(1166)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(9363),h0tab(:,9363),[43,20],[0,0],2,2,wf16(:,484),wf4(:,3))
  call Hloop_QV_A(ntryL,G0H64(1),wf16(:,484),G0H4(352),m3h16x4(:,1723),heltab2x64(:,:,6960))
  call Hloop_Q_A(ntryL,G0H4(352),43,0,G1H4(114),n2h4(4112))
  Gcoeff(:)%j = (c(26)*(-M(11,:)%j+M(12,:)%j+M(21,:)%j-M(22,:)%j)) * den(1166)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(9364),h0tab(:,9364),[43,20],[nMT,nMT],2,2,wf16(:,484),wf4(:,3))
  call Hloop_QV_A(ntryL,G0H64(1),wf16(:,484),G0H4(352),m3h16x4(:,1724),heltab2x64(:,:,6961))
  call Hloop_Q_A(ntryL,G0H4(352),43,nMT,G1H4(218),n2h4(4113))
  Gcoeff(:)%j = (c(28)*(-M(11,:)%j+M(12,:)%j+M(21,:)%j-M(22,:)%j)) * den(1166)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(9365),h0tab(:,9365),[43,20],[0,0],2,2,wf16(:,484),wf4(:,3))
  call Hloop_QV_A(ntryL,G0H64(1),wf16(:,484),G0H4(352),m3h16x4(:,1725),heltab2x64(:,:,6962))
  call Hloop_Q_A(ntryL,G0H4(352),43,0,G1H4(236),n2h4(4114))
  Gcoeff(:)%j = (c(26)*(-M(11,:)%j+M(12,:)%j+M(21,:)%j-M(22,:)%j)) * den(1166)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(9366),h0tab(:,9366),[43,20],[nMB,nMB],2,2,wf16(:,484),wf4(:,3))
  call Hloop_QV_A(ntryL,G0H64(1),wf16(:,484),G0H4(352),m3h16x4(:,1726),heltab2x64(:,:,6963))
  call Hloop_Q_A(ntryL,G0H4(352),43,nMB,G1H4(241),n2h4(4115))
  Gcoeff(:)%j = (c(20)*(-M(11,:)%j+M(12,:)%j+M(21,:)%j-M(22,:)%j)) * den(1166)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(9367),h0tab(:,9367),[43,20],[0,0],2,2,wf16(:,484),wf4(:,3))
  call Hloop_CV_D(ntryL,G0H64(1),0,wf16(:,484),43,G1H4(343),m3h16x4(:,1727),heltab2x64(:,:,6964))
  Gcoeff(:)%j = (c(14)*(M(11,:)%j-M(12,:)%j-M(21,:)%j+M(22,:)%j)) * den(1166)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(9368),h0tab(:,9368),[43,20],[0,0],2,2,wf16(:,484),wf4(:,3))
  call Hloop_UV_W(ntryL,G0H64(1),0,wf16(:,484),43,G1H4(254),m3h16x4(:,1728),heltab2x64(:,:,6965))
  Gcoeff(:)%j = (c(18)*(M(11,:)%j-M(12,:)%j-M(21,:)%j+M(22,:)%j)) * den(774)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(9369),h0tab(:,9369),[42,21],[nMT,0],2,2,wf8(:,54),wf8(:,92))
  call Hloop_VA_Q(ntryL,G0H64(1),wf8(:,54),G0H8(227),m3h8x8(:,1423),heltab2x64(:,:,6966))
  call Hloop_A_Q(ntryL,G0H8(227),42,nMT,G1H8(673),n2h8(3106))
  Gcoeff(:)%j = (c(18)*(M(3,:)%j-M(4,:)%j-M(13,:)%j+M(14,:)%j)) * den(775)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(9370),h0tab(:,9370),[41,22],[0,nMT],2,2,wf8(:,74),wf8(:,82))
  call Hloop_AQ_V(ntryL,G0H64(1),wf8(:,74),G0H8(227),m3h8x8(:,1424),heltab2x64(:,:,6967))
  Gcoeff(:)%j = (c(28)*(M(1,:)%j-M(3,:)%j-M(9,:)%j+M(15,:)%j)) * den(1167)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(9371),h0tab(:,9371),[39,24],[0,0],2,2,wf16(:,427),wf4(:,5))
  call Hloop_QV_A(ntryL,G0H64(1),wf16(:,427),G0H4(352),m3h16x4(:,1729),heltab2x64(:,:,6968))
  call Hloop_Q_A(ntryL,G0H4(352),39,0,G1H4(366),n2h4(4116))
  Gcoeff(:)%j = (c(26)*(M(1,:)%j-M(3,:)%j-M(9,:)%j+M(15,:)%j)) * den(1167)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(9372),h0tab(:,9372),[39,24],[nMT,nMT],2,2,wf16(:,427),wf4(:,5))
  call Hloop_QV_A(ntryL,G0H64(1),wf16(:,427),G0H4(352),m3h16x4(:,1730),heltab2x64(:,:,6969))
  call Hloop_Q_A(ntryL,G0H4(352),39,nMT,G1H4(282),n2h4(4117))
  Gcoeff(:)%j = (c(28)*(M(1,:)%j-M(3,:)%j-M(9,:)%j+M(15,:)%j)) * den(1167)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(9373),h0tab(:,9373),[39,24],[0,0],2,2,wf16(:,427),wf4(:,5))
  call Hloop_QV_A(ntryL,G0H64(1),wf16(:,427),G0H4(352),m3h16x4(:,1731),heltab2x64(:,:,6970))
  call Hloop_Q_A(ntryL,G0H4(352),39,0,G1H4(295),n2h4(4118))
  Gcoeff(:)%j = (c(26)*(M(1,:)%j-M(3,:)%j-M(9,:)%j+M(15,:)%j)) * den(1167)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(9374),h0tab(:,9374),[39,24],[nMB,nMB],2,2,wf16(:,427),wf4(:,5))
  call Hloop_QV_A(ntryL,G0H64(1),wf16(:,427),G0H4(352),m3h16x4(:,1732),heltab2x64(:,:,6971))
  call Hloop_Q_A(ntryL,G0H4(352),39,nMB,G1H4(296),n2h4(4119))
  Gcoeff(:)%j = (c(20)*(M(1,:)%j-M(3,:)%j-M(9,:)%j+M(15,:)%j)) * den(1167)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(9375),h0tab(:,9375),[39,24],[0,0],2,2,wf16(:,427),wf4(:,5))
  call Hloop_CV_D(ntryL,G0H64(1),0,wf16(:,427),39,G1H4(326),m3h16x4(:,1733),heltab2x64(:,:,6972))
  Gcoeff(:)%j = (c(14)*(-M(1,:)%j+M(3,:)%j+M(9,:)%j-M(15,:)%j)) * den(1167)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(9376),h0tab(:,9376),[39,24],[0,0],2,2,wf16(:,427),wf4(:,5))
  call Hloop_UV_W(ntryL,G0H64(1),0,wf16(:,427),39,G1H4(330),m3h16x4(:,1734),heltab2x64(:,:,6973))
  Gcoeff(:)%j = (c(28)*(-M(1,:)%j+M(3,:)%j+M(9,:)%j-M(15,:)%j)) * den(782)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(9377),h0tab(:,9377),[35,28],[0,0],2,2,wf8(:,23),wf8(:,30))
  call Hloop_QV_A(ntryL,G0H64(1),wf8(:,23),G0H8(228),m3h8x8(:,1425),heltab2x64(:,:,6974))
  call Hloop_Q_A(ntryL,G0H8(228),35,0,G1H8(815),n2h8(3107))
  Gcoeff(:)%j = (c(26)*(-M(1,:)%j+M(3,:)%j+M(9,:)%j-M(15,:)%j)) * den(782)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(9378),h0tab(:,9378),[35,28],[nMT,nMT],2,2,wf8(:,23),wf8(:,30))
  call Hloop_QV_A(ntryL,G0H64(1),wf8(:,23),G0H8(228),m3h8x8(:,1426),heltab2x64(:,:,6975))
  call Hloop_Q_A(ntryL,G0H8(228),35,nMT,G1H8(21),n2h8(3108))
  Gcoeff(:)%j = (c(28)*(-M(1,:)%j+M(3,:)%j+M(9,:)%j-M(15,:)%j)) * den(782)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(9379),h0tab(:,9379),[35,28],[0,0],2,2,wf8(:,23),wf8(:,30))
  call Hloop_QV_A(ntryL,G0H64(1),wf8(:,23),G0H8(228),m3h8x8(:,1427),heltab2x64(:,:,6976))
  call Hloop_Q_A(ntryL,G0H8(228),35,0,G1H8(1277),n2h8(3109))
  Gcoeff(:)%j = (c(26)*(-M(1,:)%j+M(3,:)%j+M(9,:)%j-M(15,:)%j)) * den(782)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(9380),h0tab(:,9380),[35,28],[nMB,nMB],2,2,wf8(:,23),wf8(:,30))
  call Hloop_QV_A(ntryL,G0H64(1),wf8(:,23),G0H8(228),m3h8x8(:,1428),heltab2x64(:,:,6977))
  call Hloop_Q_A(ntryL,G0H8(228),35,nMB,G1H8(1209),n2h8(3110))
  Gcoeff(:)%j = (c(20)*(-M(1,:)%j+M(3,:)%j+M(9,:)%j-M(15,:)%j)) * den(782)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(9381),h0tab(:,9381),[35,28],[0,0],2,2,wf8(:,23),wf8(:,30))
  call Hloop_CV_D(ntryL,G0H64(1),0,wf8(:,23),35,G1H8(633),m3h8x8(:,1429),heltab2x64(:,:,6978))
  Gcoeff(:)%j = (c(14)*(M(1,:)%j-M(3,:)%j-M(9,:)%j+M(15,:)%j)) * den(782)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(9382),h0tab(:,9382),[35,28],[0,0],2,2,wf8(:,23),wf8(:,30))
  call Hloop_UV_W(ntryL,G0H64(1),0,wf8(:,23),35,G1H8(634),m3h8x8(:,1430),heltab2x64(:,:,6979))
  Gcoeff(:)%j = (c(24)*(M(9,:)%j-M(15,:)%j)) * den(1168)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(9383),h0tab(:,9383),[39,24],[0,0],2,2,wf16(:,430),wf4(:,5))
  call Hloop_QV_A(ntryL,G0H64(1),wf16(:,430),G0H4(352),m3h16x4(:,1735),heltab2x64(:,:,6980))
  call Hloop_Q_A(ntryL,G0H4(352),39,0,G1H4(342),n2h4(4120))
  Gcoeff(:)%j = (c(22)*(M(9,:)%j-M(15,:)%j)) * den(1168)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(9384),h0tab(:,9384),[39,24],[nMT,nMT],2,2,wf16(:,430),wf4(:,5))
  call Hloop_QV_A(ntryL,G0H64(1),wf16(:,430),G0H4(352),m3h16x4(:,1736),heltab2x64(:,:,6981))
  call Hloop_Q_A(ntryL,G0H4(352),39,nMT,G1H4(380),n2h4(4121))
  Gcoeff(:)%j = (c(24)*(M(9,:)%j-M(15,:)%j)) * den(1168)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(9385),h0tab(:,9385),[39,24],[0,0],2,2,wf16(:,430),wf4(:,5))
  call Hloop_QV_A(ntryL,G0H64(1),wf16(:,430),G0H4(352),m3h16x4(:,1737),heltab2x64(:,:,6982))
  call Hloop_Q_A(ntryL,G0H4(352),39,0,G1H4(391),n2h4(4122))
  Gcoeff(:)%j = (c(22)*(M(9,:)%j-M(15,:)%j)) * den(1168)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(9386),h0tab(:,9386),[39,24],[nMB,nMB],2,2,wf16(:,430),wf4(:,5))
  call Hloop_QV_A(ntryL,G0H64(1),wf16(:,430),G0H4(352),m3h16x4(:,1738),heltab2x64(:,:,6983))
  call Hloop_Q_A(ntryL,G0H4(352),39,nMB,G1H4(450),n2h4(4123))
  Gcoeff(:)%j = (c(10)*(M(9,:)%j-M(15,:)%j)) * den(1168)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(9387),h0tab(:,9387),[39,24],[0,0],2,2,wf16(:,430),wf4(:,5))
  call Hloop_CV_D(ntryL,G0H64(1),0,wf16(:,430),39,G1H4(451),m3h16x4(:,1739),heltab2x64(:,:,6984))
  Gcoeff(:)%j = (c(4)*(-M(9,:)%j+M(15,:)%j)) * den(1168)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(9388),h0tab(:,9388),[39,24],[0,0],2,2,wf16(:,430),wf4(:,5))
  call Hloop_UV_W(ntryL,G0H64(1),0,wf16(:,430),39,G1H4(23),m3h16x4(:,1740),heltab2x64(:,:,6985))
  Gcoeff(:)%j = (c(8)*(-M(9,:)%j+M(15,:)%j)) * den(783)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(9389),h0tab(:,9389),[37,26],[nMT,0],2,2,wf8(:,94),wf8(:,49))
  call Hloop_VQ_A(ntryL,G0H64(1),wf8(:,94),G0H8(228),m3h8x8(:,1431),heltab2x64(:,:,6986))
  call Hloop_Q_A(ntryL,G0H8(228),37,nMT,G1H8(591),n2h8(3111))
  Gcoeff(:)%j = (c(8)*(-M(9,:)%j+M(15,:)%j)) * den(1169)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(9390),h0tab(:,9390),[33,30],[0,nMT],2,2,wf4(:,21),wf16(:,418))
  call Hloop_AQ_V(ntryL,G0H64(1),wf4(:,21),G0H16(379),m3h4x16(:,1284),heltab2x64(:,:,6987))
  Gcoeff(:)%j = (c(18)*(M(1,:)%j-M(3,:)%j-M(9,:)%j+M(15,:)%j)) * den(1170)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(9391),h0tab(:,9391),[33,30],[0,nMT],2,2,wf4(:,21),wf16(:,420))
  call Hloop_AQ_V(ntryL,G0H64(1),wf4(:,21),G0H16(380),m3h4x16(:,1285),heltab2x64(:,:,6988))
  Gcoeff(:)%j = (c(28)*(M(19,:)%j-M(20,:)%j-M(22,:)%j+M(24,:)%j)) * den(1171)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(9392),h0tab(:,9392),[39,24],[0,0],2,2,wf16(:,445),wf4(:,5))
  call Hloop_QV_A(ntryL,G0H64(1),wf16(:,445),G0H4(352),m3h16x4(:,1741),heltab2x64(:,:,6989))
  call Hloop_Q_A(ntryL,G0H4(352),39,0,G1H4(506),n2h4(4124))
  Gcoeff(:)%j = (c(26)*(M(19,:)%j-M(20,:)%j-M(22,:)%j+M(24,:)%j)) * den(1171)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(9393),h0tab(:,9393),[39,24],[nMT,nMT],2,2,wf16(:,445),wf4(:,5))
  call Hloop_QV_A(ntryL,G0H64(1),wf16(:,445),G0H4(352),m3h16x4(:,1742),heltab2x64(:,:,6990))
  call Hloop_Q_A(ntryL,G0H4(352),39,nMT,G1H4(566),n2h4(4125))
  Gcoeff(:)%j = (c(28)*(M(19,:)%j-M(20,:)%j-M(22,:)%j+M(24,:)%j)) * den(1171)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(9394),h0tab(:,9394),[39,24],[0,0],2,2,wf16(:,445),wf4(:,5))
  call Hloop_QV_A(ntryL,G0H64(1),wf16(:,445),G0H4(352),m3h16x4(:,1743),heltab2x64(:,:,6991))
  call Hloop_Q_A(ntryL,G0H4(352),39,0,G1H4(767),n2h4(4126))
  Gcoeff(:)%j = (c(26)*(M(19,:)%j-M(20,:)%j-M(22,:)%j+M(24,:)%j)) * den(1171)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(9395),h0tab(:,9395),[39,24],[nMB,nMB],2,2,wf16(:,445),wf4(:,5))
  call Hloop_QV_A(ntryL,G0H64(1),wf16(:,445),G0H4(352),m3h16x4(:,1744),heltab2x64(:,:,6992))
  call Hloop_Q_A(ntryL,G0H4(352),39,nMB,G1H4(584),n2h4(4127))
  Gcoeff(:)%j = (c(20)*(M(19,:)%j-M(20,:)%j-M(22,:)%j+M(24,:)%j)) * den(1171)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(9396),h0tab(:,9396),[39,24],[0,0],2,2,wf16(:,445),wf4(:,5))
  call Hloop_CV_D(ntryL,G0H64(1),0,wf16(:,445),39,G1H4(606),m3h16x4(:,1745),heltab2x64(:,:,6993))
  Gcoeff(:)%j = (c(14)*(-M(19,:)%j+M(20,:)%j+M(22,:)%j-M(24,:)%j)) * den(1171)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(9397),h0tab(:,9397),[39,24],[0,0],2,2,wf16(:,445),wf4(:,5))
  call Hloop_UV_W(ntryL,G0H64(1),0,wf16(:,445),39,G1H4(619),m3h16x4(:,1746),heltab2x64(:,:,6994))
  Gcoeff(:)%j = (c(28)*(-M(19,:)%j+M(20,:)%j+M(22,:)%j-M(24,:)%j)) * den(787)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(9398),h0tab(:,9398),[35,28],[0,0],2,2,wf8(:,24),wf8(:,30))
  call Hloop_QV_A(ntryL,G0H64(1),wf8(:,24),G0H8(228),m3h8x8(:,1432),heltab2x64(:,:,6995))
  call Hloop_Q_A(ntryL,G0H8(228),35,0,G1H8(889),n2h8(3112))
  Gcoeff(:)%j = (c(26)*(-M(19,:)%j+M(20,:)%j+M(22,:)%j-M(24,:)%j)) * den(787)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(9399),h0tab(:,9399),[35,28],[nMT,nMT],2,2,wf8(:,24),wf8(:,30))
  call Hloop_QV_A(ntryL,G0H64(1),wf8(:,24),G0H8(228),m3h8x8(:,1433),heltab2x64(:,:,6996))
  call Hloop_Q_A(ntryL,G0H8(228),35,nMT,G1H8(549),n2h8(3113))
  Gcoeff(:)%j = (c(28)*(-M(19,:)%j+M(20,:)%j+M(22,:)%j-M(24,:)%j)) * den(787)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(9400),h0tab(:,9400),[35,28],[0,0],2,2,wf8(:,24),wf8(:,30))
  call Hloop_QV_A(ntryL,G0H64(1),wf8(:,24),G0H8(228),m3h8x8(:,1434),heltab2x64(:,:,6997))
  call Hloop_Q_A(ntryL,G0H8(228),35,0,G1H8(660),n2h8(3114))
  Gcoeff(:)%j = (c(26)*(-M(19,:)%j+M(20,:)%j+M(22,:)%j-M(24,:)%j)) * den(787)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(9401),h0tab(:,9401),[35,28],[nMB,nMB],2,2,wf8(:,24),wf8(:,30))
  call Hloop_QV_A(ntryL,G0H64(1),wf8(:,24),G0H8(228),m3h8x8(:,1435),heltab2x64(:,:,6998))
  call Hloop_Q_A(ntryL,G0H8(228),35,nMB,G1H8(1465),n2h8(3115))
  Gcoeff(:)%j = (c(20)*(-M(19,:)%j+M(20,:)%j+M(22,:)%j-M(24,:)%j)) * den(787)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(9402),h0tab(:,9402),[35,28],[0,0],2,2,wf8(:,24),wf8(:,30))
  call Hloop_CV_D(ntryL,G0H64(1),0,wf8(:,24),35,G1H8(1369),m3h8x8(:,1436),heltab2x64(:,:,6999))
  Gcoeff(:)%j = (c(14)*(M(19,:)%j-M(20,:)%j-M(22,:)%j+M(24,:)%j)) * den(787)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(9403),h0tab(:,9403),[35,28],[0,0],2,2,wf8(:,24),wf8(:,30))
  call Hloop_UV_W(ntryL,G0H64(1),0,wf8(:,24),35,G1H8(469),m3h8x8(:,1437),heltab2x64(:,:,7000))
  Gcoeff(:)%j = (c(8)*(-M(19,:)%j+M(20,:)%j)) * den(1172)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(9404),h0tab(:,9404),[34,29],[0,nMT],2,2,wf4(:,23),wf16(:,410))
  call Hloop_QA_V(ntryL,G0H64(1),wf4(:,23),G0H16(381),m3h4x16(:,1286),heltab2x64(:,:,7001))
  Gcoeff(:)%j = (c(24)*(M(19,:)%j-M(20,:)%j)) * den(1173)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(9405),h0tab(:,9405),[39,24],[0,0],2,2,wf16(:,448),wf4(:,5))
  call Hloop_QV_A(ntryL,G0H64(1),wf16(:,448),G0H4(352),m3h16x4(:,1747),heltab2x64(:,:,7002))
  call Hloop_Q_A(ntryL,G0H4(352),39,0,G1H4(899),n2h4(4128))
  Gcoeff(:)%j = (c(22)*(M(19,:)%j-M(20,:)%j)) * den(1173)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(9406),h0tab(:,9406),[39,24],[nMT,nMT],2,2,wf16(:,448),wf4(:,5))
  call Hloop_QV_A(ntryL,G0H64(1),wf16(:,448),G0H4(352),m3h16x4(:,1748),heltab2x64(:,:,7003))
  call Hloop_Q_A(ntryL,G0H4(352),39,nMT,G1H4(143),n2h4(4129))
  Gcoeff(:)%j = (c(24)*(M(19,:)%j-M(20,:)%j)) * den(1173)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(9407),h0tab(:,9407),[39,24],[0,0],2,2,wf16(:,448),wf4(:,5))
  call Hloop_QV_A(ntryL,G0H64(1),wf16(:,448),G0H4(352),m3h16x4(:,1749),heltab2x64(:,:,7004))
  call Hloop_Q_A(ntryL,G0H4(352),39,0,G1H4(129),n2h4(4130))
  Gcoeff(:)%j = (c(22)*(M(19,:)%j-M(20,:)%j)) * den(1173)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(9408),h0tab(:,9408),[39,24],[nMB,nMB],2,2,wf16(:,448),wf4(:,5))
  call Hloop_QV_A(ntryL,G0H64(1),wf16(:,448),G0H4(352),m3h16x4(:,1750),heltab2x64(:,:,7005))
  call Hloop_Q_A(ntryL,G0H4(352),39,nMB,G1H4(251),n2h4(4131))
  Gcoeff(:)%j = (c(10)*(M(19,:)%j-M(20,:)%j)) * den(1173)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(9409),h0tab(:,9409),[39,24],[0,0],2,2,wf16(:,448),wf4(:,5))
  call Hloop_CV_D(ntryL,G0H64(1),0,wf16(:,448),39,G1H4(323),m3h16x4(:,1751),heltab2x64(:,:,7006))
  Gcoeff(:)%j = (c(4)*(-M(19,:)%j+M(20,:)%j)) * den(1173)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(9410),h0tab(:,9410),[39,24],[0,0],2,2,wf16(:,448),wf4(:,5))
  call Hloop_UV_W(ntryL,G0H64(1),0,wf16(:,448),39,G1H4(333),m3h16x4(:,1752),heltab2x64(:,:,7007))
  Gcoeff(:)%j = (c(18)*(M(19,:)%j-M(20,:)%j-M(22,:)%j+M(24,:)%j)) * den(1174)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(9411),h0tab(:,9411),[34,29],[nMT,0],2,2,wf4(:,23),wf16(:,412))
  call Hloop_VA_Q(ntryL,G0H64(1),wf4(:,23),G0H16(382),m3h4x16(:,1287),heltab2x64(:,:,7008))
  call Hloop_A_Q(ntryL,G0H16(382),34,nMT,G1H16(103),n2h16(1935))
  Gcoeff(:)%j = (c(8)*(-M(19,:)%j+M(20,:)%j)) * den(788)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(9412),h0tab(:,9412),[38,25],[nMT,0],2,2,wf8(:,84),wf8(:,69))
  call Hloop_VA_Q(ntryL,G0H64(1),wf8(:,84),G0H8(228),m3h8x8(:,1438),heltab2x64(:,:,7009))
  call Hloop_A_Q(ntryL,G0H8(228),38,nMT,G1H8(84),n2h8(3116))
  Gcoeff(:)%j = (c(28)*(-M(9,:)%j+M(10,:)%j+M(15,:)%j-M(16,:)%j)) * den(1175)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(9413),h0tab(:,9413),[39,24],[0,0],2,2,wf16(:,463),wf4(:,5))
  call Hloop_QV_A(ntryL,G0H64(1),wf16(:,463),G0H4(352),m3h16x4(:,1753),heltab2x64(:,:,7010))
  call Hloop_Q_A(ntryL,G0H4(352),39,0,G1H4(371),n2h4(4132))
  Gcoeff(:)%j = (c(26)*(-M(9,:)%j+M(10,:)%j+M(15,:)%j-M(16,:)%j)) * den(1175)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(9414),h0tab(:,9414),[39,24],[nMT,nMT],2,2,wf16(:,463),wf4(:,5))
  call Hloop_QV_A(ntryL,G0H64(1),wf16(:,463),G0H4(352),m3h16x4(:,1754),heltab2x64(:,:,7011))
  call Hloop_Q_A(ntryL,G0H4(352),39,nMT,G1H4(443),n2h4(4133))
  Gcoeff(:)%j = (c(28)*(-M(9,:)%j+M(10,:)%j+M(15,:)%j-M(16,:)%j)) * den(1175)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(9415),h0tab(:,9415),[39,24],[0,0],2,2,wf16(:,463),wf4(:,5))
  call Hloop_QV_A(ntryL,G0H64(1),wf16(:,463),G0H4(352),m3h16x4(:,1755),heltab2x64(:,:,7012))
  call Hloop_Q_A(ntryL,G0H4(352),39,0,G1H4(465),n2h4(4134))
  Gcoeff(:)%j = (c(26)*(-M(9,:)%j+M(10,:)%j+M(15,:)%j-M(16,:)%j)) * den(1175)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(9416),h0tab(:,9416),[39,24],[nMB,nMB],2,2,wf16(:,463),wf4(:,5))
  call Hloop_QV_A(ntryL,G0H64(1),wf16(:,463),G0H4(352),m3h16x4(:,1756),heltab2x64(:,:,7013))
  call Hloop_Q_A(ntryL,G0H4(352),39,nMB,G1H4(321),n2h4(4135))
  Gcoeff(:)%j = (c(20)*(-M(9,:)%j+M(10,:)%j+M(15,:)%j-M(16,:)%j)) * den(1175)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(9417),h0tab(:,9417),[39,24],[0,0],2,2,wf16(:,463),wf4(:,5))
  call Hloop_CV_D(ntryL,G0H64(1),0,wf16(:,463),39,G1H4(623),m3h16x4(:,1757),heltab2x64(:,:,7014))
  Gcoeff(:)%j = (c(14)*(M(9,:)%j-M(10,:)%j-M(15,:)%j+M(16,:)%j)) * den(1175)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(9418),h0tab(:,9418),[39,24],[0,0],2,2,wf16(:,463),wf4(:,5))
  call Hloop_UV_W(ntryL,G0H64(1),0,wf16(:,463),39,G1H4(169),m3h16x4(:,1758),heltab2x64(:,:,7015))
  Gcoeff(:)%j = (c(28)*(-M(5,:)%j+M(6,:)%j+M(19,:)%j-M(20,:)%j)) * den(1176)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(9419),h0tab(:,9419),[36,27],[0,0],2,2,wf4(:,4),wf16(:,407))
  call Hloop_QV_A(ntryL,G0H64(1),wf4(:,4),G0H16(382),m3h4x16(:,1288),heltab2x64(:,:,7016))
  call Hloop_Q_A(ntryL,G0H16(382),36,0,G1H16(310),n2h16(1936))
  Gcoeff(:)%j = (c(26)*(-M(5,:)%j+M(6,:)%j+M(19,:)%j-M(20,:)%j)) * den(1176)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(9420),h0tab(:,9420),[36,27],[nMT,nMT],2,2,wf4(:,4),wf16(:,407))
  call Hloop_QV_A(ntryL,G0H64(1),wf4(:,4),G0H16(382),m3h4x16(:,1289),heltab2x64(:,:,7017))
  call Hloop_Q_A(ntryL,G0H16(382),36,nMT,G1H16(958),n2h16(1937))
  Gcoeff(:)%j = (c(28)*(-M(5,:)%j+M(6,:)%j+M(19,:)%j-M(20,:)%j)) * den(1176)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(9421),h0tab(:,9421),[36,27],[0,0],2,2,wf4(:,4),wf16(:,407))
  call Hloop_QV_A(ntryL,G0H64(1),wf4(:,4),G0H16(382),m3h4x16(:,1290),heltab2x64(:,:,7018))
  call Hloop_Q_A(ntryL,G0H16(382),36,0,G1H16(325),n2h16(1938))
  Gcoeff(:)%j = (c(26)*(-M(5,:)%j+M(6,:)%j+M(19,:)%j-M(20,:)%j)) * den(1176)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(9422),h0tab(:,9422),[36,27],[nMB,nMB],2,2,wf4(:,4),wf16(:,407))
  call Hloop_QV_A(ntryL,G0H64(1),wf4(:,4),G0H16(382),m3h4x16(:,1291),heltab2x64(:,:,7019))
  call Hloop_Q_A(ntryL,G0H16(382),36,nMB,G1H16(295),n2h16(1939))
  Gcoeff(:)%j = (c(20)*(-M(5,:)%j+M(6,:)%j+M(19,:)%j-M(20,:)%j)) * den(1176)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(9423),h0tab(:,9423),[36,27],[0,0],2,2,wf4(:,4),wf16(:,407))
  call Hloop_CV_D(ntryL,G0H64(1),0,wf4(:,4),36,G1H16(304),m3h4x16(:,1292),heltab2x64(:,:,7020))
  Gcoeff(:)%j = (c(14)*(M(5,:)%j-M(6,:)%j-M(19,:)%j+M(20,:)%j)) * den(1176)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(9424),h0tab(:,9424),[36,27],[0,0],2,2,wf4(:,4),wf16(:,407))
  call Hloop_UV_W(ntryL,G0H64(1),0,wf4(:,4),36,G1H16(589),m3h4x16(:,1293),heltab2x64(:,:,7021))
  Gcoeff(:)%j = (c(28)*(-M(5,:)%j+M(6,:)%j+M(19,:)%j-M(20,:)%j)) * den(1177)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(9425),h0tab(:,9425),[39,24],[0,0],2,2,wf16(:,464),wf4(:,5))
  call Hloop_QV_A(ntryL,G0H64(1),wf16(:,464),G0H4(352),m3h16x4(:,1759),heltab2x64(:,:,7022))
  call Hloop_Q_A(ntryL,G0H4(352),39,0,G1H4(163),n2h4(4136))
  Gcoeff(:)%j = (c(26)*(-M(5,:)%j+M(6,:)%j+M(19,:)%j-M(20,:)%j)) * den(1177)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(9426),h0tab(:,9426),[39,24],[nMT,nMT],2,2,wf16(:,464),wf4(:,5))
  call Hloop_QV_A(ntryL,G0H64(1),wf16(:,464),G0H4(352),m3h16x4(:,1760),heltab2x64(:,:,7023))
  call Hloop_Q_A(ntryL,G0H4(352),39,nMT,G1H4(162),n2h4(4137))
  Gcoeff(:)%j = (c(28)*(-M(5,:)%j+M(6,:)%j+M(19,:)%j-M(20,:)%j)) * den(1177)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(9427),h0tab(:,9427),[39,24],[0,0],2,2,wf16(:,464),wf4(:,5))
  call Hloop_QV_A(ntryL,G0H64(1),wf16(:,464),G0H4(352),m3h16x4(:,1761),heltab2x64(:,:,7024))
  call Hloop_Q_A(ntryL,G0H4(352),39,0,G1H4(10),n2h4(4138))
  Gcoeff(:)%j = (c(26)*(-M(5,:)%j+M(6,:)%j+M(19,:)%j-M(20,:)%j)) * den(1177)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(9428),h0tab(:,9428),[39,24],[nMB,nMB],2,2,wf16(:,464),wf4(:,5))
  call Hloop_QV_A(ntryL,G0H64(1),wf16(:,464),G0H4(352),m3h16x4(:,1762),heltab2x64(:,:,7025))
  call Hloop_Q_A(ntryL,G0H4(352),39,nMB,G1H4(152),n2h4(4139))
  Gcoeff(:)%j = (c(20)*(-M(5,:)%j+M(6,:)%j+M(19,:)%j-M(20,:)%j)) * den(1177)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(9429),h0tab(:,9429),[39,24],[0,0],2,2,wf16(:,464),wf4(:,5))
  call Hloop_CV_D(ntryL,G0H64(1),0,wf16(:,464),39,G1H4(28),m3h16x4(:,1763),heltab2x64(:,:,7026))
  Gcoeff(:)%j = (c(14)*(M(5,:)%j-M(6,:)%j-M(19,:)%j+M(20,:)%j)) * den(1177)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(9430),h0tab(:,9430),[39,24],[0,0],2,2,wf16(:,464),wf4(:,5))
  call Hloop_UV_W(ntryL,G0H64(1),0,wf16(:,464),39,G1H4(875),m3h16x4(:,1764),heltab2x64(:,:,7027))
  Gcoeff(:)%j = (c(28)*(-M(9,:)%j+M(10,:)%j+M(15,:)%j-M(16,:)%j)) * den(1178)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(9431),h0tab(:,9431),[36,27],[0,0],2,2,wf4(:,4),wf16(:,408))
  call Hloop_QV_A(ntryL,G0H64(1),wf4(:,4),G0H16(382),m3h4x16(:,1294),heltab2x64(:,:,7028))
  call Hloop_Q_A(ntryL,G0H16(382),36,0,G1H16(195),n2h16(1940))
  Gcoeff(:)%j = (c(26)*(-M(9,:)%j+M(10,:)%j+M(15,:)%j-M(16,:)%j)) * den(1178)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(9432),h0tab(:,9432),[36,27],[nMT,nMT],2,2,wf4(:,4),wf16(:,408))
  call Hloop_QV_A(ntryL,G0H64(1),wf4(:,4),G0H16(382),m3h4x16(:,1295),heltab2x64(:,:,7029))
  call Hloop_Q_A(ntryL,G0H16(382),36,nMT,G1H16(207),n2h16(1941))
  Gcoeff(:)%j = (c(28)*(-M(9,:)%j+M(10,:)%j+M(15,:)%j-M(16,:)%j)) * den(1178)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(9433),h0tab(:,9433),[36,27],[0,0],2,2,wf4(:,4),wf16(:,408))
  call Hloop_QV_A(ntryL,G0H64(1),wf4(:,4),G0H16(382),m3h4x16(:,1296),heltab2x64(:,:,7030))
  call Hloop_Q_A(ntryL,G0H16(382),36,0,G1H16(665),n2h16(1942))
  Gcoeff(:)%j = (c(26)*(-M(9,:)%j+M(10,:)%j+M(15,:)%j-M(16,:)%j)) * den(1178)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(9434),h0tab(:,9434),[36,27],[nMB,nMB],2,2,wf4(:,4),wf16(:,408))
  call Hloop_QV_A(ntryL,G0H64(1),wf4(:,4),G0H16(382),m3h4x16(:,1297),heltab2x64(:,:,7031))
  call Hloop_Q_A(ntryL,G0H16(382),36,nMB,G1H16(421),n2h16(1943))
  Gcoeff(:)%j = (c(20)*(-M(9,:)%j+M(10,:)%j+M(15,:)%j-M(16,:)%j)) * den(1178)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(9435),h0tab(:,9435),[36,27],[0,0],2,2,wf4(:,4),wf16(:,408))
  call Hloop_CV_D(ntryL,G0H64(1),0,wf4(:,4),36,G1H16(345),m3h4x16(:,1298),heltab2x64(:,:,7032))
  Gcoeff(:)%j = (c(14)*(M(9,:)%j-M(10,:)%j-M(15,:)%j+M(16,:)%j)) * den(1178)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(9436),h0tab(:,9436),[36,27],[0,0],2,2,wf4(:,4),wf16(:,408))
  call Hloop_UV_W(ntryL,G0H64(1),0,wf4(:,4),36,G1H16(276),m3h4x16(:,1299),heltab2x64(:,:,7033))



end subroutine vamp_47

end module ol_vamp_47_ppttjj_ttxgggg_1_/**/REALKIND
