
module ol_vamp_2_ppttjj_uuxttxddx_1_/**/REALKIND
contains

! **********************************************************************
subroutine vamp_2(M)
! P(0:3,nlegs) = incoming external momenta
! Uses tree structures 'wf', factors 'c', and denominators 'den' from loop_ppttjj_uuxttxddx_1.
! Sets colour stripped amplitudes A from the module loop_amplitudes_ppttjj_uuxttxddx_1.
! **********************************************************************
  use KIND_TYPES, only: REALKIND, QREALKIND, intkind2
  use ol_parameters_decl_/**/DREALKIND, only: l_switch
  use ol_parameters_decl_/**/QREALKIND ! masses
  use ol_vert_interface_/**/REALKIND
  use ol_prop_interface_/**/REALKIND
  use ol_last_step_/**/REALKIND
  use ol_tables_storage_ppttjj_uuxttxddx_1_/**/DREALKIND
  use ol_tensor_sum_storage_ppttjj_uuxttxddx_1_/**/REALKIND
  use ol_loop_handling_/**/REALKIND
  use ofred_reduction_/**/REALKIND, only: Hotf_4pt_reduction, Hotf_4pt_reduction_last
  use ofred_reduction_/**/REALKIND, only: Hotf_5pt_reduction, Hotf_5pt_reduction_last
  use ol_loop_reduction_/**/REALKIND, only: TI_bubble_red, TI_triangle_red
use ol_loop_reduction_/**/REALKIND, only: compute_scalar_box

  use ol_loop_storage_ppttjj_uuxttxddx_1_/**/REALKIND
#ifndef PRECISION_dp
  use ol_loop_storage_ppttjj_uuxttxddx_1_/**/DREALKIND, only: &
    & ntryL, p_switch, Hel, merge_step, merge_mism, merge_tables, merge_hels
#endif
  use hol_initialisation_/**/REALKIND, only: G0_hol_initialisation
  use ol_h_vert_interface_/**/REALKIND
  use ol_h_prop_interface_/**/REALKIND
  use ol_h_last_step_/**/REALKIND
  use ol_merging_/**/REALKIND, only: ol_merge, ol_merge_tensors, ol_merge_last

  implicit none

  type(Hpolcont) :: Gcoeff(64)
  type(Hpolcont), intent(in) :: M(6,64)


#ifndef PRECISION_dp
  if (ntryL==1 .OR. p_switch == 1) Gcoeff(:)%hf = Hel
#else
  if (ntryL==1 .OR. p_switch == 2) Gcoeff(:)%hf = Hel
#endif

  ! =============================================
  call Hloop_A_Q(ntryL,G0H32(7),32,0,G1H32(6),n2h32(11))
  Gcoeff(:)%j = (-(c(6)*M(3,:)%j)+c(4)*(M(1,:)%j+M(5,:)%j)-c(3)*M(6,:)%j) * den(78)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(134),h0tab(:,134),[32,15,16],[0,0,0],3,1,wf16(:,11))
  call Hloop_QA_V(ntryL,G0H64(1),ex6(:),G0H32(15),m3h2x32(:,57),heltab2x64(:,:,128))
  Gcoeff(:)%j = (-(c(15)*M(2,:)%j)+c(12)*(M(1,:)%j+M(5,:)%j)-c(11)*M(6,:)%j) * den(79)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(135),h0tab(:,135),[32,15,16],[0,0,0],3,1,wf16(:,12))
  call Hloop_VA_Q(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,58),heltab2x64(:,:,129))
  call Hloop_A_Q(ntryL,G0H32(1),32,0,G1H32(7),n2h32(12))
  Gcoeff(:)%j = (-(c(6)*M(2,:)%j)+c(4)*(M(1,:)%j+M(5,:)%j)-c(3)*M(6,:)%j) * den(79)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(136),h0tab(:,136),[32,15,16],[0,0,0],3,1,wf16(:,12))
  call Hloop_QA_V(ntryL,G0H64(1),ex6(:),G0H32(9),m3h2x32(:,59),heltab2x64(:,:,130))
  Gcoeff(:)%j = (-(c(15)*M(2,:)%j)+c(12)*(M(1,:)%j+M(4,:)%j)-c(11)*M(6,:)%j) * den(80)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(137),h0tab(:,137),[60,1,2],[0,0,0],3,1,wf16(:,13))
  call Hloop_AV_Q(ntryL,G0H64(1),wf16(:,13),G0H4(7),m3h16x4(:,9),heltab2x64(:,:,131))
  call Hloop_A_Q(ntryL,G0H4(7),60,0,G1H4(12),n2h4(52))
  Gcoeff(:)%j = (-(c(6)*M(2,:)%j)+c(4)*(M(1,:)%j+M(4,:)%j)-c(3)*M(6,:)%j) * den(80)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(138),h0tab(:,138),[60,1,2],[0,0,0],3,1,wf16(:,13))
  call Hloop_UV_W(ntryL,G0H64(1),0,wf16(:,13),60,G1H4(18),m3h16x4(:,10),heltab2x64(:,:,132))
  Gcoeff(:)%j = (-(c(15)*M(3,:)%j)+c(12)*(M(1,:)%j+M(4,:)%j)-c(11)*M(6,:)%j) * den(81)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(139),h0tab(:,139),[60,1,2],[0,0,0],3,1,wf16(:,14))
  call Hloop_AV_Q(ntryL,G0H64(1),wf16(:,14),G0H4(7),m3h16x4(:,11),heltab2x64(:,:,133))
  call Hloop_A_Q(ntryL,G0H4(7),60,0,G1H4(19),n2h4(53))
  Gcoeff(:)%j = (-(c(6)*M(3,:)%j)+c(4)*(M(1,:)%j+M(4,:)%j)-c(3)*M(6,:)%j) * den(81)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(140),h0tab(:,140),[60,1,2],[0,0,0],3,1,wf16(:,14))
  call Hloop_UV_W(ntryL,G0H64(1),0,wf16(:,14),60,G1H4(16),m3h16x4(:,12),heltab2x64(:,:,134))
  Gcoeff(:)%j = (-(c(15)*M(2,:)%j)+c(12)*(M(1,:)%j+M(5,:)%j)-c(11)*M(6,:)%j) * den(82)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(141),h0tab(:,141),[51,4,8],[nMT,0,nMT],3,1,wf16(:,15))
  call Hloop_AV_Q(ntryL,G0H64(1),wf16(:,15),G0H4(7),m3h16x4(:,13),heltab2x64(:,:,135))
  call Hloop_A_Q(ntryL,G0H4(7),51,nMT,G1H4(21),n2h4(54))
  Gcoeff(:)%j = (-(c(6)*M(2,:)%j)+c(4)*(M(1,:)%j+M(5,:)%j)-c(3)*M(6,:)%j) * den(82)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(142),h0tab(:,142),[51,4,8],[0,nMT,0],3,1,wf16(:,15))
  call Hloop_UV_W(ntryL,G0H64(1),0,wf16(:,15),51,G1H4(34),m3h16x4(:,14),heltab2x64(:,:,136))
  Gcoeff(:)%j = (-(c(15)*M(3,:)%j)+c(12)*(M(1,:)%j+M(5,:)%j)-c(11)*M(6,:)%j) * den(83)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(143),h0tab(:,143),[51,4,8],[nMT,0,nMT],3,1,wf16(:,16))
  call Hloop_AV_Q(ntryL,G0H64(1),wf16(:,16),G0H4(7),m3h16x4(:,15),heltab2x64(:,:,137))
  call Hloop_A_Q(ntryL,G0H4(7),51,nMT,G1H4(14),n2h4(55))
  Gcoeff(:)%j = (-(c(6)*M(3,:)%j)+c(4)*(M(1,:)%j+M(5,:)%j)-c(3)*M(6,:)%j) * den(83)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(144),h0tab(:,144),[51,4,8],[0,nMT,0],3,1,wf16(:,16))
  call Hloop_UV_W(ntryL,G0H64(1),0,wf16(:,16),51,G1H4(6),m3h16x4(:,16),heltab2x64(:,:,138))
  Gcoeff(:)%j = (-(c(15)*M(3,:)%j)+c(12)*(M(4,:)%j+M(5,:)%j)-c(11)*M(6,:)%j) * den(84)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(145),h0tab(:,145),[60,1,2],[0,0,0],3,1,wf16(:,17))
  call Hloop_AV_Q(ntryL,G0H64(1),wf16(:,17),G0H4(7),m3h16x4(:,17),heltab2x64(:,:,139))
  call Hloop_A_Q(ntryL,G0H4(7),60,0,G1H4(5),n2h4(56))
  Gcoeff(:)%j = (-(c(6)*M(3,:)%j)+c(4)*(M(4,:)%j+M(5,:)%j)-c(3)*M(6,:)%j) * den(84)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(146),h0tab(:,146),[60,1,2],[0,0,0],3,1,wf16(:,17))
  call Hloop_UV_W(ntryL,G0H64(1),0,wf16(:,17),60,G1H4(17),m3h16x4(:,18),heltab2x64(:,:,140))
  Gcoeff(:)%j = (-(c(15)*M(2,:)%j)+c(12)*(M(4,:)%j+M(5,:)%j)-c(11)*M(6,:)%j) * den(85)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(147),h0tab(:,147),[60,1,2],[0,0,0],3,1,wf16(:,18))
  call Hloop_AV_Q(ntryL,G0H64(1),wf16(:,18),G0H4(7),m3h16x4(:,19),heltab2x64(:,:,141))
  call Hloop_A_Q(ntryL,G0H4(7),60,0,G1H4(37),n2h4(57))
  Gcoeff(:)%j = (-(c(6)*M(2,:)%j)+c(4)*(M(4,:)%j+M(5,:)%j)-c(3)*M(6,:)%j) * den(85)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(148),h0tab(:,148),[60,1,2],[0,0,0],3,1,wf16(:,18))
  call Hloop_UV_W(ntryL,G0H64(1),0,wf16(:,18),60,G1H4(38),m3h16x4(:,20),heltab2x64(:,:,142))
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(6),[G1H4(34),G1H4(30),G1H4(26),G1H4(3),G1H4(15),G0H4(3) &
    ,G0H4(2),G0H4(1)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H8(1),[G1H8(8)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H8(7),[G1H8(14)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H8(3),[G1H8(17)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(38),[G1H4(17),G1H4(16),G1H4(18),G1H4(32),G0H4(6),G0H4(5) &
    ,G0H4(4)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H16(7),[G1H16(3)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H16(9),[G1H16(5)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(14),[G1H4(21),G1H4(4),G1H4(25),G1H4(36)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(37),[G1H4(5),G1H4(19),G1H4(12),G1H4(31)])
  call Hloop_VQ_A(ntryL,G1H4(6),ex3(:),G1H2(33),m3h2x2(:,75),heltab2x4(:,:,103))
  call Hloop_Q_A(ntryL,G1H2(33),55,nMT,G2H2(18),n2h2(45))
  call Hloop_VA_Q(ntryL,G1H4(22),ex4(:),G1H2(87),m3h2x2(:,76),heltab2x4(:,:,104))
  call Hloop_A_Q(ntryL,G1H2(87),59,nMT,G2H2(21),n2h2(46))
  call Hloop_AV_Q(ntryL,G1H8(1),wf4(:,1),G1H2(55),m3h4x2(:,21),heltab2x8(:,:,71))
  call Hloop_A_Q(ntryL,G1H2(55),47,0,G2H2(24),n2h2(47))
  call Hloop_AV_Q(ntryL,G1H8(7),wf4(:,2),G1H2(56),m3h4x2(:,22),heltab2x8(:,:,72))
  call Hloop_A_Q(ntryL,G1H2(56),47,0,G2H2(27),n2h2(48))
  call Hloop_QV_A(ntryL,G1H8(3),wf4(:,1),G1H2(81),m3h4x2(:,23),heltab2x8(:,:,73))
  call Hloop_Q_A(ntryL,G1H2(81),55,nMT,G2H2(30),n2h2(49))
  call Hloop_QV_A(ntryL,G1H8(21),wf4(:,2),G1H2(29),m3h4x2(:,24),heltab2x8(:,:,74))
  call Hloop_Q_A(ntryL,G1H2(29),61,0,G2H2(33),n2h2(50))
  call Hloop_GGG_G_12(ntryL,G0H32(4),wf4(:,1),wf4(:,2),G0H2(1),m4h4x4x2(:,1),heltab3x32(:,:,1))
  call Hloop_GGG_G_12(ntryL,G0H32(6),wf4(:,2),wf4(:,1),G0H2(2),m4h4x4x2(:,2),heltab3x32(:,:,2))
  call Hloop_GGG_G_23(ntryL,G0H32(8),wf4(:,1),wf4(:,2),G0H2(3),m4h4x4x2(:,3),heltab3x32(:,:,3))
  call Hloop_VQ_A(ntryL,G1H4(38),ex1(:),G1H2(43),m3h2x2(:,77),heltab2x4(:,:,105))
  call Hloop_Q_A(ntryL,G1H2(43),61,0,G2H2(5),n2h2(51))
  call Hloop_AV_Q(ntryL,G1H16(7),wf4(:,1),G1H4(34),m3h4x4(:,9),heltab2x16(:,:,47))
  call Hloop_A_Q(ntryL,G1H4(34),51,0,G2H4(13),n2h4(58))
  call Hloop_AV_Q(ntryL,G1H16(4),wf4(:,1),G1H4(30),m3h4x4(:,10),heltab2x16(:,:,48))
  call Hloop_A_Q(ntryL,G1H4(30),51,nMT,G2H4(14),n2h4(59))
  call Hloop_QV_A(ntryL,G1H16(9),wf4(:,1),G1H4(26),m3h4x4(:,11),heltab2x16(:,:,49))
  call Hloop_Q_A(ntryL,G1H4(26),51,0,G2H4(15),n2h4(60))
  call Hloop_QV_A(ntryL,G1H16(6),wf4(:,1),G1H4(3),m3h4x4(:,12),heltab2x16(:,:,50))
  call Hloop_Q_A(ntryL,G1H4(3),51,nMT,G2H4(16),n2h4(61))
  call Hloop_AV_Q(ntryL,G1H16(8),wf4(:,1),G1H4(15),m3h4x4(:,13),heltab2x16(:,:,51))
  call Hloop_A_Q(ntryL,G1H4(15),51,nMB,G2H4(17),n2h4(62))
  call Hloop_QV_A(ntryL,G1H16(10),wf4(:,1),G1H4(17),m3h4x4(:,14),heltab2x16(:,:,52))
  call Hloop_Q_A(ntryL,G1H4(17),51,nMB,G2H4(18),n2h4(63))
  call Hloop_DV_C(ntryL,G1H16(11),48,wf4(:,1),G2H4(1),m3h4x4(:,15),heltab2x16(:,:,53))
  call Hloop_CV_D(ntryL,G1H16(12),48,wf4(:,1),3,G2H4(2),m3h4x4(:,16),heltab2x16(:,:,54))
  call Hloop_UV_W(ntryL,G1H16(13),48,wf4(:,1),3,G2H4(4),m3h4x4(:,17),heltab2x16(:,:,55))
  call Hloop_AV_Q(ntryL,G1H32(1),wf4(:,2),G1H8(15),m3h4x8(:,13),heltab2x32(:,:,43))
  call Hloop_A_Q(ntryL,G1H8(15),44,0,G2H8(1),n2h8(28))
  call Hloop_UV_W(ntryL,G0H32(3),32,wf4(:,2),12,G1H8(16),m3h4x8(:,14),heltab2x32(:,:,44))
  call Hloop_UV_W(ntryL,G0H8(2),35,wf4(:,2),12,G1H2(76),m3h4x2(:,25),heltab2x8(:,:,75))
  call Hloop_AV_Q(ntryL,G1H32(2),wf4(:,1),G1H8(5),m3h4x8(:,15),heltab2x32(:,:,45))
  call Hloop_A_Q(ntryL,G1H8(5),35,0,G2H8(2),n2h8(29))
  call Hloop_UV_W(ntryL,G0H32(10),32,wf4(:,1),3,G1H8(6),m3h4x8(:,16),heltab2x32(:,:,46))
  call Hloop_UV_W(ntryL,G0H8(4),44,wf4(:,1),3,G1H2(44),m3h4x2(:,26),heltab2x8(:,:,76))
  call Hloop_AV_Q(ntryL,G1H32(3),wf16(:,1),G1H2(54),m3h16x2(:,1),heltab2x32(:,:,47))
  call Hloop_A_Q(ntryL,G1H2(54),47,0,G2H2(6),n2h2(52))
  call Hloop_UV_W(ntryL,G0H32(12),32,wf16(:,1),15,G1H2(5),m3h16x2(:,2),heltab2x32(:,:,48))
  call Hloop_AQ_V(ntryL,G1H16(14),wf8(:,9),G1H2(31),m3h8x2(:,5),heltab2x16(:,:,56))
  call Hloop_VQ_A(ntryL,G1H16(15),wf8(:,9),G1H2(1),m3h8x2(:,6),heltab2x16(:,:,57))
  call Hloop_Q_A(ntryL,G1H2(1),55,nMT,G2H2(13),n2h2(53))
  call Hloop_AQ_V(ntryL,G1H16(16),ex3(:),G1H8(18),m3h2x8(:,35),heltab2x16(:,:,58))
  call Hloop_VQ_A(ntryL,G1H16(17),ex3(:),G1H8(19),m3h2x8(:,36),heltab2x16(:,:,59))
  call Hloop_Q_A(ntryL,G1H8(19),52,nMT,G2H8(3),n2h8(30))
  call Hloop_UV_W(ntryL,G0H8(6),52,wf4(:,1),3,G1H2(59),m3h4x2(:,27),heltab2x8(:,:,77))
  call Hloop_AV_Q(ntryL,G1H8(12),wf4(:,1),G1H2(16),m3h4x2(:,28),heltab2x8(:,:,78))
  call Hloop_A_Q(ntryL,G1H2(16),59,nMT,G2H2(14),n2h2(54))
  call Hloop_UV_W(ntryL,G0H8(8),56,wf4(:,1),3,G1H2(40),m3h4x2(:,29),heltab2x8(:,:,79))
  call Hloop_AQ_V(ntryL,G1H4(14),ex3(:),G1H2(64),m3h2x2(:,78),heltab2x4(:,:,106))
  call Hloop_AV_Q(ntryL,G1H32(4),wf16(:,7),G1H2(10),m3h16x2(:,3),heltab2x32(:,:,49))
  call Hloop_A_Q(ntryL,G1H2(10),47,0,G2H2(9),n2h2(55))
  call Hloop_UV_W(ntryL,G0H32(14),32,wf16(:,7),15,G1H2(39),m3h16x2(:,4),heltab2x32(:,:,50))
  call Hloop_AV_Q(ntryL,G1H32(5),wf16(:,8),G1H2(50),m3h16x2(:,5),heltab2x32(:,:,51))
  call Hloop_A_Q(ntryL,G1H2(50),47,0,G2H2(4),n2h2(56))
  call Hloop_UV_W(ntryL,G0H32(5),32,wf16(:,8),15,G1H2(22),m3h16x2(:,6),heltab2x32(:,:,52))
  call Hloop_QA_V(ntryL,G1H16(18),ex2(:),G1H8(10),m3h2x8(:,37),heltab2x16(:,:,60))
  call Hloop_VA_Q(ntryL,G1H16(1),ex2(:),G1H8(2),m3h2x8(:,38),heltab2x16(:,:,61))
  call Hloop_A_Q(ntryL,G1H8(2),50,0,G2H8(4),n2h8(31))
  call Hloop_VA_Q(ntryL,G0H8(1),ex2(:),G0H4(7),m3h2x4(:,47),heltab2x8(:,:,80))
  call Hloop_A_Q(ntryL,G0H4(7),51,0,G1H4(16),n2h4(64))
  call Hloop_QA_V(ntryL,G1H8(4),ex2(:),G1H4(18),m3h2x4(:,48),heltab2x8(:,:,81))
  call Hloop_AQ_V(ntryL,G1H16(2),ex1(:),G1H8(22),m3h2x8(:,39),heltab2x16(:,:,62))
  call Hloop_VQ_A(ntryL,G1H16(19),ex1(:),G1H8(23),m3h2x8(:,40),heltab2x16(:,:,63))
  call Hloop_Q_A(ntryL,G1H8(23),49,0,G2H8(5),n2h8(32))
  call Hloop_VQ_A(ntryL,G0H8(5),ex1(:),G0H4(3),m3h2x4(:,49),heltab2x8(:,:,82))
  call Hloop_Q_A(ntryL,G0H4(3),51,0,G1H4(32),n2h4(65))
  call Hloop_AQ_V(ntryL,G1H8(13),ex1(:),G1H4(21),m3h2x4(:,50),heltab2x8(:,:,83))
  call Hloop_AQ_V(ntryL,G1H4(37),ex1(:),G1H2(24),m3h2x2(:,79),heltab2x4(:,:,107))
  call Hloop_AV_Q(ntryL,G1H32(6),wf16(:,11),G1H2(71),m3h16x2(:,7),heltab2x32(:,:,53))
  call Hloop_A_Q(ntryL,G1H2(71),47,0,G2H2(3),n2h2(57))
  call Hloop_UV_W(ntryL,G0H32(15),32,wf16(:,11),15,G1H2(34),m3h16x2(:,8),heltab2x32(:,:,54))
  call Hloop_AV_Q(ntryL,G1H32(7),wf16(:,12),G1H2(65),m3h16x2(:,9),heltab2x32(:,:,55))
  call Hloop_A_Q(ntryL,G1H2(65),47,0,G2H2(10),n2h2(58))
  call Hloop_UV_W(ntryL,G0H32(9),32,wf16(:,12),15,G1H2(9),m3h16x2(:,10),heltab2x32(:,:,56))
call HGT_w2_OLR(G1H2(47),1,1,2)
call HGT_w2_invQ_OLR(G1H2(47),2,5,2)
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(47),[G1H2(40)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(13),[G2H2(34),G2H2(16)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(59),[G1H2(45)])
call HGT_w2_OLR(G1H2(66),1,1,2)
call HGT_w2_invQ_OLR(G1H2(66),2,5,2)
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(66),[G1H2(59)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(10),[G2H2(3),G2H2(4),G2H2(9),G2H2(6),G2H2(29),G2H2(25)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(13),[G1H4(33)])
call HGT_w2_OLR(G1H4(1),1,1,4)
call HGT_w2_invQ_OLR(G1H4(1),2,5,4)
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(13),[G1H4(1)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(32),[G1H4(8)])
call HGT_w2_OLR(G1H4(35),1,1,4)
call HGT_w2_invQ_OLR(G1H4(35),2,5,4)
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(35),[G1H4(32)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(44),[G1H2(98)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(9),[G1H2(34),G1H2(22),G1H2(39),G1H2(5),G1H2(19),G1H2(102) &
    ,G0H2(3),G0H2(2),G0H2(1)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(76),[G1H2(13)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(31),[G1H2(80),G1H2(60)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(64),[G1H2(79)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(15),[G1H4(11)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(21),[G1H4(20)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(4),[G1H4(13),G1H4(28)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(16),[G1H4(27)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(18),[G1H4(7)])
  call Hloop_VQ_A(ntryL,G1H2(47),ex3(:),G1H1(1),m3h2x1(:,169),heltab2x2(:,:,169))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,nMT,G2tensor(115),n2h1(157))
  call Hcheck_last_QA_V(ntryL,l_switch,G2H2(13),ex4(:),G2tensor(28),m3h2x1(:,170),heltab2x2(:,:,170))
  call Hloop_VA_Q(ntryL,G1H2(66),ex4(:),G1H1(1),m3h2x1(:,171),heltab2x2(:,:,171))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,nMT,G2tensor(26),n2h1(158))
  call Hcheck_last_AQ_V(ntryL,l_switch,G2H2(20),ex3(:),G2tensor(133),m3h2x1(:,172),heltab2x2(:,:,172))
call HGT_w2_OLR(G1H4(10),1,1,4)
call HGT_w2_invQ_OLR(G1H4(10),2,5,4)
  call Hloop_AV_Q(ntryL,G1H4(10),wf4(:,1),G1H1(1),m3h4x1(:,29),heltab2x4(:,:,108))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,0,G2tensor(47),n2h1(159))
  call Hcheck_last_AQ_V(ntryL,l_switch,G2H2(10),ex5(:),G2tensor(32),m3h2x1(:,173),heltab2x2(:,:,173))
  call Hloop_AV_Q(ntryL,G2H4(13),wf4(:,2),G2H1(1),m3h4x1(:,30),heltab2x4(:,:,109))
  call Hcheck_last_A_Q(ntryL,l_switch,G2H1(1),63,0,G3tensor(1),n2h1(160))
call HGT_w2_OLR(G1H4(2),1,1,4)
call HGT_w2_invQ_OLR(G1H4(2),2,5,4)
  call Hloop_QV_A(ntryL,G1H4(2),wf4(:,1),G1H1(1),m3h4x1(:,31),heltab2x4(:,:,110))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,nMT,G2tensor(30),n2h1(161))
  call Hloop_QV_A(ntryL,G1H4(35),wf4(:,2),G1H1(1),m3h4x1(:,32),heltab2x4(:,:,111))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(139),n2h1(162))
  call Hcheck_last_QA_V(ntryL,l_switch,G2H2(37),ex2(:),G2tensor(59),m3h2x1(:,174),heltab2x2(:,:,174))
  call Hloop_VQ_A(ntryL,G1H2(44),ex5(:),G1H1(1),m3h2x1(:,175),heltab2x2(:,:,175))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(36),n2h1(163))
  call Hloop_VQ_A(ntryL,G1H2(9),ex5(:),G1H1(1),m3h2x1(:,176),heltab2x2(:,:,176))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(34),n2h1(164))
  call Hloop_VQ_A(ntryL,G1H2(76),ex5(:),G1H1(1),m3h2x1(:,177),heltab2x2(:,:,177))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(42),n2h1(165))
  call Hloop_QV_A(ntryL,G1H4(23),wf4(:,2),G1H1(1),m3h4x1(:,33),heltab2x4(:,:,112))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(44),n2h1(166))
  call Hloop_QV_A(ntryL,G1H4(24),wf4(:,2),G1H1(1),m3h4x1(:,34),heltab2x4(:,:,113))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(69),n2h1(167))
  call Hloop_VA_Q(ntryL,G1H2(31),ex4(:),G1H1(1),m3h2x1(:,178),heltab2x2(:,:,178))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,nMT,G2tensor(48),n2h1(168))
  call Hloop_VA_Q(ntryL,G1H2(68),ex2(:),G1H1(1),m3h2x1(:,179),heltab2x2(:,:,179))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,0,G2tensor(51),n2h1(169))
  call Hloop_VA_Q(ntryL,G1H2(72),ex2(:),G1H1(1),m3h2x1(:,180),heltab2x2(:,:,180))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,0,G2tensor(53),n2h1(170))
  call Hcheck_last_UV_W(ntryL,l_switch,G1H4(9),51,wf4(:,2),12,G2tensor(72),m3h4x1(:,35),heltab2x4(:,:,114))
  call Hcheck_last_UV_W(ntryL,l_switch,G1H4(29),51,wf4(:,2),12,G2tensor(60),m3h4x1(:,36),heltab2x4(:,:,115))
  call Hloop_VA_Q(ntryL,G1H2(64),ex4(:),G1H1(1),m3h2x1(:,181),heltab2x2(:,:,181))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,nMT,G2tensor(65),n2h1(171))
  call Hloop_VQ_A(ntryL,G1H2(90),ex3(:),G1H1(1),m3h2x1(:,182),heltab2x2(:,:,182))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,nMT,G2tensor(68),n2h1(172))
  call Hloop_VQ_A(ntryL,G1H2(91),ex3(:),G1H1(1),m3h2x1(:,183),heltab2x2(:,:,183))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,nMT,G2tensor(71),n2h1(173))
  call Hloop_QV_A(ntryL,G2H4(15),wf4(:,2),G2H1(1),m3h4x1(:,37),heltab2x4(:,:,116))
  call Hcheck_last_Q_A(ntryL,l_switch,G2H1(1),63,0,G3tensor(2),n2h1(174))
  call Hcheck_last_UV_W(ntryL,l_switch,G1H4(21),51,wf4(:,2),12,G2tensor(107),m3h4x1(:,38),heltab2x4(:,:,117))
  call Hcheck_last_UV_W(ntryL,l_switch,G2H4(4),51,wf4(:,2),12,G3tensor(3),m3h4x1(:,39),heltab2x4(:,:,118))
  call Hloop_AV_Q(ntryL,G1H4(16),wf4(:,2),G1H1(1),m3h4x1(:,40),heltab2x4(:,:,119))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,0,G2tensor(77),n2h1(175))
  call Hcheck_last_UV_W(ntryL,l_switch,G1H4(18),51,wf4(:,2),12,G2tensor(86),m3h4x1(:,41),heltab2x4(:,:,120))
  call Hcheck_last_QA_V(ntryL,l_switch,G2H2(18),ex4(:),G2tensor(89),m3h2x1(:,184),heltab2x2(:,:,184))
  call Hcheck_last_AQ_V(ntryL,l_switch,G2H2(21),ex3(:),G2tensor(101),m3h2x1(:,185),heltab2x2(:,:,185))
  call Hcheck_last_AQ_V(ntryL,l_switch,G2H2(24),ex5(:),G2tensor(103),m3h2x1(:,186),heltab2x2(:,:,186))
  call Hcheck_last_AQ_V(ntryL,l_switch,G2H2(27),ex5(:),G2tensor(124),m3h2x1(:,187),heltab2x2(:,:,187))
  call Hcheck_last_QA_V(ntryL,l_switch,G2H2(30),ex4(:),G2tensor(136),m3h2x1(:,188),heltab2x2(:,:,188))
  call Hcheck_last_QA_V(ntryL,l_switch,G2H2(33),ex2(:),G2tensor(142),m3h2x1(:,189),heltab2x2(:,:,189))
  call Hcheck_last_QA_V(ntryL,l_switch,G2H2(5),ex2(:),G2tensor(38),m3h2x1(:,190),heltab2x2(:,:,190))
  call Hloop_AV_Q(ntryL,G2H4(14),wf4(:,2),G2H1(1),m3h4x1(:,42),heltab2x4(:,:,121))
  call Hcheck_last_A_Q(ntryL,l_switch,G2H1(1),63,nMT,G3tensor(4),n2h1(176))
  call Hloop_QV_A(ntryL,G2H4(16),wf4(:,2),G2H1(1),m3h4x1(:,43),heltab2x4(:,:,122))
  call Hcheck_last_Q_A(ntryL,l_switch,G2H1(1),63,nMT,G3tensor(5),n2h1(177))
  call Hloop_AV_Q(ntryL,G2H4(17),wf4(:,2),G2H1(1),m3h4x1(:,44),heltab2x4(:,:,123))
  call Hcheck_last_A_Q(ntryL,l_switch,G2H1(1),63,nMB,G3tensor(6),n2h1(178))
  call Hloop_QV_A(ntryL,G2H4(18),wf4(:,2),G2H1(1),m3h4x1(:,45),heltab2x4(:,:,124))
  call Hcheck_last_Q_A(ntryL,l_switch,G2H1(1),63,nMB,G3tensor(7),n2h1(179))
  call Hcheck_last_DV_C(ntryL,l_switch,G2H4(1),51,wf4(:,2),G3tensor(8),m3h4x1(:,46),heltab2x4(:,:,125))
  call Hcheck_last_CV_D(ntryL,l_switch,G2H4(2),51,wf4(:,2),12,G3tensor(9),m3h4x1(:,47),heltab2x4(:,:,126))
  call Hcheck_last_AQ_V(ntryL,l_switch,G2H8(1),wf8(:,3),G2tensor(39),m3h8x1(:,5),heltab2x8(:,:,84))
  call Hloop_VQ_A(ntryL,G1H8(16),wf8(:,3),G1H1(1),m3h8x1(:,6),heltab2x8(:,:,85))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(41),n2h1(180))
  call Hcheck_last_AQ_V(ntryL,l_switch,G2H8(2),wf8(:,6),G2tensor(94),m3h8x1(:,7),heltab2x8(:,:,86))
  call Hloop_VQ_A(ntryL,G1H8(6),wf8(:,6),G1H1(1),m3h8x1(:,8),heltab2x8(:,:,87))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(97),n2h1(181))
  call Hloop_VA_Q(ntryL,G1H8(18),wf8(:,31),G1H1(1),m3h8x1(:,9),heltab2x8(:,:,88))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,nMT,G2tensor(45),n2h1(182))
  call Hcheck_last_QA_V(ntryL,l_switch,G2H8(3),wf8(:,31),G2tensor(96),m3h8x1(:,10),heltab2x8(:,:,89))
  call Hcheck_last_AQ_V(ntryL,l_switch,G2H2(14),ex3(:),G2tensor(50),m3h2x1(:,191),heltab2x2(:,:,191))
  call Hloop_VQ_A(ntryL,G1H8(10),wf8(:,15),G1H1(1),m3h8x1(:,11),heltab2x8(:,:,90))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(93),n2h1(183))
  call Hcheck_last_AQ_V(ntryL,l_switch,G2H8(4),wf8(:,15),G2tensor(99),m3h8x1(:,12),heltab2x8(:,:,91))
  call Hloop_VA_Q(ntryL,G1H8(22),wf8(:,48),G1H1(1),m3h8x1(:,13),heltab2x8(:,:,92))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,0,G2tensor(54),n2h1(184))
  call Hcheck_last_QA_V(ntryL,l_switch,G2H8(5),wf8(:,48),G2tensor(56),m3h8x1(:,14),heltab2x8(:,:,93))
  call Hloop_VA_Q(ntryL,G1H2(24),ex2(:),G1H1(1),m3h2x1(:,192),heltab2x2(:,:,192))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,0,G2tensor(57),n2h1(185))
  call ol_merge_tensors(G3tensor(9),[G3tensor(8),G3tensor(3),G3tensor(2),G3tensor(1),G2tensor(113),G2tensor(100),G2tensor(98) &
    ,G1tensor(304),G1tensor(8),G1tensor(235),G1tensor(79),G1tensor(49),G0tensor(337),G0tensor(65),G0tensor(40),G0tensor(14) &
    ,G0tensor(9)])
  call ol_merge_tensors(G2tensor(41),[G2tensor(39),G2tensor(111),G2tensor(102),G1tensor(282),G1tensor(144),G1tensor(68) &
    ,G1tensor(199),G1tensor(145),G0tensor(300),G0tensor(80),G0tensor(59),G0tensor(34),G0tensor(25)])
  call ol_merge_tensors(G2tensor(97),[G2tensor(94),G2tensor(126),G2tensor(117),G2tensor(114),G2tensor(104),G1tensor(387) &
    ,G1tensor(367),G1tensor(307),G1tensor(210),G1tensor(23),G1tensor(92),G1tensor(226),G1tensor(10),G0tensor(515),G0tensor(495) &
    ,G0tensor(340),G0tensor(84),G0tensor(70),G0tensor(49),G0tensor(45),G0tensor(5)])
  call ol_merge_tensors(G2tensor(96),[G2tensor(106),G1tensor(319),G1tensor(240),G1tensor(56),G0tensor(367),G0tensor(245) &
    ,G0tensor(210),G0tensor(100),G0tensor(55)])
  call ol_merge_tensors(G2tensor(56),[G2tensor(54),G2tensor(144),G2tensor(141),G2tensor(123),G2tensor(108),G1tensor(344) &
    ,G1tensor(267),G1tensor(213),G1tensor(83),G1tensor(119),G1tensor(255),G1tensor(85),G0tensor(452),G0tensor(275),G0tensor(260) &
    ,G0tensor(175),G0tensor(165),G0tensor(130),G0tensor(15)])
  call ol_merge_tensors(G2tensor(47),[G2tensor(110),G1tensor(279),G1tensor(6),G1tensor(35),G1tensor(169),G1tensor(115) &
    ,G0tensor(297),G0tensor(75),G0tensor(54),G0tensor(29),G0tensor(20)])
  call ol_merge_tensors(G2tensor(103),[G2tensor(36),G2tensor(125),G2tensor(116),G1tensor(369),G1tensor(349),G1tensor(315) &
    ,G1tensor(280),G1tensor(270),G1tensor(116),G1tensor(254),G1tensor(37),G0tensor(497),G0tensor(477),G0tensor(358),G0tensor(298) &
    ,G0tensor(283),G0tensor(114),G0tensor(109),G0tensor(2)])
  call ol_merge_tensors(G2tensor(119),[G1tensor(434),G1tensor(269),G1tensor(106),G1tensor(41),G1tensor(163),G0tensor(562) &
    ,G0tensor(282),G0tensor(150),G0tensor(140),G0tensor(28)])
  call ol_merge_tensors(G2tensor(45),[G2tensor(120),G1tensor(437),G1tensor(70),G1tensor(52),G0tensor(565),G0tensor(155) &
    ,G0tensor(145)])
  call ol_merge_tensors(G2tensor(107),[G2tensor(139),G2tensor(122),G1tensor(294),G1tensor(88),G1tensor(65),G1tensor(21) &
    ,G1tensor(261),G1tensor(39),G0tensor(322),G0tensor(170),G0tensor(160),G0tensor(132),G0tensor(127),G0tensor(8)])
  call ol_merge_tensors(G2tensor(50),[G2tensor(128),G1tensor(454),G1tensor(389),G1tensor(153),G0tensor(582),G0tensor(517) &
    ,G0tensor(88)])
  call ol_merge_tensors(G3tensor(5),[G3tensor(4),G2tensor(132),G2tensor(129),G1tensor(462),G1tensor(457),G0tensor(590) &
    ,G0tensor(585)])
  call ol_merge_tensors(G2tensor(136),[G2tensor(131),G1tensor(459),G1tensor(394),G1tensor(257),G0tensor(587),G0tensor(522) &
    ,G0tensor(98)])
  call ol_merge_tensors(G2tensor(137),[G2tensor(134),G1tensor(107),G1tensor(131),G1tensor(53),G1tensor(24),G1tensor(122) &
    ,G1tensor(204),G1tensor(27),G0tensor(238),G0tensor(212),G0tensor(187),G0tensor(148),G0tensor(107),G0tensor(73),G0tensor(47) &
    ,G0tensor(7)])
  call ol_merge_tensors(G2tensor(99),[G2tensor(93),G2tensor(138),G2tensor(135),G1tensor(309),G1tensor(124),G1tensor(161) &
    ,G1tensor(14),G1tensor(55),G0tensor(342),G0tensor(220),G0tensor(195),G0tensor(120),G0tensor(10)])
  call ol_merge_tensors(G2tensor(57),[G2tensor(38),G2tensor(143),G2tensor(140),G1tensor(221),G1tensor(191),G1tensor(33) &
    ,G1tensor(258),G1tensor(180),G1tensor(103),G1tensor(67),G0tensor(262),G0tensor(247),G0tensor(203),G0tensor(138),G0tensor(112) &
    ,G0tensor(82),G0tensor(18),G0tensor(12)])
  call ol_merge_tensors(G2tensor(72),[G2tensor(44),G1tensor(410),G1tensor(400),G1tensor(377),G1tensor(357),G1tensor(26) &
    ,G0tensor(538),G0tensor(528),G0tensor(505),G0tensor(485),G0tensor(3)])
  call ol_merge_tensors(G2tensor(60),[G2tensor(69),G1tensor(416),G1tensor(406),G1tensor(382),G1tensor(362),G1tensor(4) &
    ,G0tensor(544),G0tensor(534),G0tensor(510),G0tensor(490),G0tensor(4)])
  call ol_merge_tensors(G2tensor(86),[G2tensor(77),G1tensor(339),G1tensor(250),G1tensor(200),G1tensor(3),G1tensor(25),G1tensor(73) &
    ,G0tensor(442),G0tensor(270),G0tensor(255),G0tensor(122),G0tensor(117),G0tensor(13)])
  call ol_merge_tensors(G1tensor(419),[G1tensor(43),G1tensor(127),G1tensor(97),G0tensor(547),G0tensor(199),G0tensor(179) &
    ,G0tensor(118),G0tensor(22),G0tensor(17)])
  call ol_merge_tensors(G2tensor(53),[G2tensor(59),G1tensor(451),G1tensor(446),G1tensor(274),G1tensor(15),G1tensor(109) &
    ,G0tensor(579),G0tensor(574),G0tensor(292),G0tensor(209),G0tensor(184),G0tensor(129),G0tensor(19)])
  call ol_merge_tensors(G1tensor(414),[G1tensor(30),G1tensor(133),G0tensor(542),G0tensor(363),G0tensor(288),G0tensor(115) &
    ,G0tensor(23)])
  call ol_merge_tensors(G1tensor(277),[G1tensor(34),G1tensor(139),G0tensor(374),G0tensor(309),G0tensor(295),G0tensor(134) &
    ,G0tensor(24)])
  call ol_merge_tensors(G2tensor(101),[G1tensor(380),G1tensor(375),G1tensor(324),G1tensor(251),G1tensor(232),G1tensor(214) &
    ,G1tensor(80),G1tensor(187),G1tensor(157),G0tensor(508),G0tensor(503),G0tensor(377),G0tensor(268),G0tensor(222),G0tensor(177) &
    ,G0tensor(168),G0tensor(63),G0tensor(32),G0tensor(27)])
  call ol_merge_tensors(G1tensor(284),[G1tensor(135),G1tensor(175),G0tensor(302),G0tensor(230),G0tensor(185),G0tensor(90) &
    ,G0tensor(30)])
  call ol_merge_tensors(G1tensor(272),[G1tensor(193),G0tensor(410),G0tensor(290),G0tensor(285),G0tensor(33)])
  call ol_merge_tensors(G1tensor(287),[G1tensor(230),G1tensor(205),G0tensor(420),G0tensor(310),G0tensor(305),G0tensor(95) &
    ,G0tensor(35)])
  call ol_merge_tensors(G2tensor(115),[G1tensor(173),G1tensor(89),G1tensor(247),G1tensor(217),G0tensor(249),G0tensor(189) &
    ,G0tensor(42),G0tensor(37)])
  call ol_merge_tensors(G2tensor(89),[G1tensor(360),G1tensor(355),G1tensor(289),G1tensor(196),G1tensor(166),G1tensor(149) &
    ,G1tensor(19),G1tensor(176),G1tensor(223),G0tensor(488),G0tensor(483),G0tensor(312),G0tensor(253),G0tensor(232),G0tensor(197) &
    ,G0tensor(158),G0tensor(57),G0tensor(52),G0tensor(38)])
  call ol_merge_tensors(G2tensor(28),[G1tensor(299),G1tensor(207),G1tensor(215),G1tensor(236),G1tensor(229),G0tensor(332) &
    ,G0tensor(259),G0tensor(194),G0tensor(99),G0tensor(39)])
  call ol_merge_tensors(G1tensor(292),[G1tensor(253),G0tensor(448),G0tensor(328),G0tensor(315),G0tensor(43)])
  call ol_merge_tensors(G1tensor(302),[G1tensor(246),G1tensor(259),G0tensor(459),G0tensor(349),G0tensor(335),G0tensor(104) &
    ,G0tensor(44)])
  call ol_merge_tensors(G1tensor(402),[G1tensor(297),G1tensor(198),G0tensor(530),G0tensor(390),G0tensor(330),G0tensor(325) &
    ,G0tensor(48)])
  call ol_merge_tensors(G1tensor(407),[G1tensor(312),G1tensor(128),G1tensor(40),G0tensor(535),G0tensor(400),G0tensor(350) &
    ,G0tensor(345),G0tensor(125),G0tensor(50)])
  call ol_merge_tensors(G1tensor(314),[G1tensor(47),G0tensor(357),G0tensor(240),G0tensor(205),G0tensor(53)])
  call ol_merge_tensors(G1tensor(317),[G1tensor(60),G0tensor(430),G0tensor(365),G0tensor(360),G0tensor(58)])
  call ol_merge_tensors(G1tensor(322),[G1tensor(248),G1tensor(17),G0tensor(435),G0tensor(375),G0tensor(370),G0tensor(105) &
    ,G0tensor(60)])
  call ol_merge_tensors(G2tensor(26),[G1tensor(435),G1tensor(227),G1tensor(123),G1tensor(222),G1tensor(72),G0tensor(563) &
    ,G0tensor(264),G0tensor(214),G0tensor(67),G0tensor(62)])
  call ol_merge_tensors(G2tensor(133),[G1tensor(329),G1tensor(266),G1tensor(130),G1tensor(141),G1tensor(29),G0tensor(392) &
    ,G0tensor(274),G0tensor(219),G0tensor(89),G0tensor(64)])
  call ol_merge_tensors(G1tensor(327),[G1tensor(96),G0tensor(468),G0tensor(388),G0tensor(380),G0tensor(68)])
  call ol_merge_tensors(G1tensor(332),[G1tensor(51),G1tensor(110),G0tensor(474),G0tensor(399),G0tensor(395),G0tensor(94) &
    ,G0tensor(69)])
  call ol_merge_tensors(G2tensor(142),[G2tensor(51),G1tensor(424),G1tensor(177),G1tensor(148),G1tensor(11),G1tensor(140) &
    ,G1tensor(114),G0tensor(552),G0tensor(234),G0tensor(224),G0tensor(128),G0tensor(77),G0tensor(72)])
  call ol_merge_tensors(G1tensor(334),[G1tensor(86),G1tensor(42),G0tensor(412),G0tensor(244),G0tensor(229),G0tensor(119) &
    ,G0tensor(74)])
  call ol_merge_tensors(G1tensor(404),[G1tensor(74),G1tensor(46),G0tensor(532),G0tensor(428),G0tensor(408),G0tensor(110) &
    ,G0tensor(78)])
  call ol_merge_tensors(G1tensor(337),[G1tensor(5),G1tensor(12),G0tensor(434),G0tensor(419),G0tensor(415),G0tensor(124) &
    ,G0tensor(79)])
  call ol_merge_tensors(G1tensor(412),[G1tensor(342),G1tensor(206),G0tensor(540),G0tensor(470),G0tensor(450),G0tensor(445) &
    ,G0tensor(83)])
  call ol_merge_tensors(G1tensor(417),[G1tensor(347),G1tensor(164),G1tensor(212),G0tensor(545),G0tensor(475),G0tensor(460) &
    ,G0tensor(455),G0tensor(135),G0tensor(85)])
  call ol_merge_tensors(G1tensor(99),[G1tensor(218),G0tensor(92),G0tensor(87)])
  call ol_merge_tensors(G1tensor(392),[G1tensor(57),G0tensor(520),G0tensor(93)])
  call ol_merge_tensors(G2tensor(30),[G1tensor(50),G1tensor(263),G0tensor(102),G0tensor(97)])
  call ol_merge_tensors(G1tensor(397),[G1tensor(13),G0tensor(525),G0tensor(103)])
  call ol_merge_tensors(G1tensor(420),[G1tensor(399),G1tensor(335),G1tensor(252),G0tensor(548),G0tensor(527),G0tensor(423) &
    ,G0tensor(413),G0tensor(403),G0tensor(108)])
  call ol_merge_tensors(G1tensor(425),[G1tensor(409),G1tensor(275),G1tensor(260),G0tensor(553),G0tensor(537),G0tensor(353) &
    ,G0tensor(293),G0tensor(278),G0tensor(113)])
  call ol_merge_tensors(G1tensor(422),[G1tensor(249),G0tensor(550),G0tensor(123)])
  call ol_merge_tensors(G1tensor(427),[G1tensor(22),G0tensor(555),G0tensor(133)])
  call ol_merge_tensors(G1tensor(48),[G1tensor(170),G0tensor(287),G0tensor(178),G0tensor(142),G0tensor(137)])
  call ol_merge_tensors(G1tensor(429),[G1tensor(243),G0tensor(557),G0tensor(277),G0tensor(183),G0tensor(139)])
  call ol_merge_tensors(G1tensor(262),[G1tensor(231),G1tensor(188),G0tensor(472),G0tensor(272),G0tensor(265),G0tensor(143)])
  call ol_merge_tensors(G1tensor(432),[G1tensor(45),G0tensor(560),G0tensor(144)])
  call ol_merge_tensors(G1tensor(450),[G1tensor(160),G1tensor(58),G1tensor(69),G0tensor(578),G0tensor(407),G0tensor(223) &
    ,G0tensor(152),G0tensor(147)])
  call ol_merge_tensors(G1tensor(439),[G1tensor(238),G0tensor(567),G0tensor(402),G0tensor(228),G0tensor(149)])
  call ol_merge_tensors(G1tensor(208),[G1tensor(117),G1tensor(143),G0tensor(397),G0tensor(217),G0tensor(215),G0tensor(153)])
  call ol_merge_tensors(G1tensor(442),[G1tensor(112),G0tensor(570),G0tensor(154)])
  call ol_merge_tensors(G1tensor(95),[G1tensor(81),G1tensor(209),G0tensor(327),G0tensor(188),G0tensor(162),G0tensor(157)])
  call ol_merge_tensors(G1tensor(444),[G1tensor(101),G1tensor(71),G0tensor(572),G0tensor(317),G0tensor(193),G0tensor(159)])
  call ol_merge_tensors(G1tensor(167),[G1tensor(75),G0tensor(432),G0tensor(242),G0tensor(235),G0tensor(163)])
  call ol_merge_tensors(G1tensor(447),[G1tensor(76),G0tensor(575),G0tensor(164)])
  call ol_merge_tensors(G1tensor(440),[G1tensor(183),G1tensor(178),G1tensor(77),G0tensor(568),G0tensor(387),G0tensor(213) &
    ,G0tensor(172),G0tensor(167)])
  call ol_merge_tensors(G1tensor(449),[G1tensor(190),G1tensor(172),G0tensor(577),G0tensor(382),G0tensor(218),G0tensor(169)])
  call ol_merge_tensors(G1tensor(142),[G1tensor(125),G0tensor(417),G0tensor(227),G0tensor(225),G0tensor(173)])
  call ol_merge_tensors(G1tensor(452),[G1tensor(94),G0tensor(580),G0tensor(174)])
  call ol_merge_tensors(G1tensor(111),[G1tensor(100),G0tensor(347),G0tensor(192),G0tensor(190)])
  call ol_merge_tensors(G1tensor(445),[G1tensor(185),G0tensor(573),G0tensor(427),G0tensor(237),G0tensor(233)])
  call ol_merge_tensors(G1tensor(195),[G1tensor(179),G0tensor(447),G0tensor(252),G0tensor(248)])
  call ol_merge_tensors(G1tensor(202),[G1tensor(184),G0tensor(457),G0tensor(257),G0tensor(250)])
  call ol_merge_tensors(G1tensor(203),[G1tensor(197),G0tensor(437),G0tensor(258),G0tensor(254)])
  call ol_merge_tensors(G1tensor(430),[G1tensor(244),G1tensor(225),G0tensor(558),G0tensor(467),G0tensor(267),G0tensor(263)])
  call ol_merge_tensors(G1tensor(265),[G1tensor(245),G0tensor(462),G0tensor(273),G0tensor(269)])
  call ol_merge_tensors(G1tensor(391),[G1tensor(285),G1tensor(271),G0tensor(519),G0tensor(404),G0tensor(303),G0tensor(284) &
    ,G0tensor(279)])
  call ol_merge_tensors(G2tensor(34),[G2tensor(32),G1tensor(346),G1tensor(336),G1tensor(331),G1tensor(321),G1tensor(311) &
    ,G1tensor(306),G1tensor(301),G1tensor(286),G1tensor(281),G1tensor(276),G0tensor(454),G0tensor(414),G0tensor(394),G0tensor(369) &
    ,G0tensor(344),G0tensor(339),G0tensor(334),G0tensor(304),G0tensor(299),G0tensor(294)])
  call ol_merge_tensors(G1tensor(395),[G1tensor(300),G1tensor(290),G0tensor(523),G0tensor(438),G0tensor(333),G0tensor(318) &
    ,G0tensor(313)])
  call ol_merge_tensors(G2tensor(124),[G2tensor(42),G1tensor(340),G1tensor(326),G1tensor(305),G1tensor(295),G1tensor(291) &
    ,G0tensor(443),G0tensor(379),G0tensor(338),G0tensor(323),G0tensor(314)])
  call ol_merge_tensors(G1tensor(421),[G1tensor(310),G1tensor(296),G0tensor(549),G0tensor(384),G0tensor(343),G0tensor(324) &
    ,G0tensor(319)])
  call ol_merge_tensors(G1tensor(396),[G1tensor(320),G1tensor(316),G0tensor(524),G0tensor(424),G0tensor(368),G0tensor(359) &
    ,G0tensor(354)])
  call ol_merge_tensors(G1tensor(390),[G1tensor(330),G1tensor(325),G0tensor(518),G0tensor(463),G0tensor(393),G0tensor(383) &
    ,G0tensor(378)])
  call ol_merge_tensors(G1tensor(426),[G1tensor(345),G1tensor(341),G0tensor(554),G0tensor(464),G0tensor(453),G0tensor(444) &
    ,G0tensor(439)])
  call ol_merge_tensors(G1tensor(354),[G1tensor(350),G0tensor(482),G0tensor(478)])
  call ol_merge_tensors(G1tensor(359),[G1tensor(351),G0tensor(487),G0tensor(479)])
  call ol_merge_tensors(G1tensor(364),[G1tensor(352),G0tensor(492),G0tensor(480)])
  call ol_merge_tensors(G1tensor(365),[G1tensor(356),G0tensor(493),G0tensor(484)])
  call ol_merge_tensors(G1tensor(366),[G1tensor(361),G0tensor(494),G0tensor(489)])
  call ol_merge_tensors(G1tensor(374),[G1tensor(370),G0tensor(502),G0tensor(498)])
  call ol_merge_tensors(G1tensor(379),[G1tensor(371),G0tensor(507),G0tensor(499)])
  call ol_merge_tensors(G1tensor(384),[G1tensor(372),G0tensor(512),G0tensor(500)])
  call ol_merge_tensors(G1tensor(385),[G1tensor(376),G0tensor(513),G0tensor(504)])
  call ol_merge_tensors(G1tensor(386),[G1tensor(381),G0tensor(514),G0tensor(509)])
  call ol_merge_tensors(G1tensor(405),[G1tensor(401),G0tensor(533),G0tensor(529)])
  call ol_merge_tensors(G1tensor(415),[G1tensor(411),G0tensor(543),G0tensor(539)])
  call ol_merge_tensors(G2tensor(48),[G1tensor(456),G1tensor(441),G1tensor(436),G1tensor(431),G0tensor(584),G0tensor(569) &
    ,G0tensor(564),G0tensor(559)])
  call ol_merge_tensors(G2tensor(65),[G1tensor(455),G0tensor(583)])
  call ol_merge_tensors(G2tensor(68),[G1tensor(460),G0tensor(588)])
  call ol_merge_tensors(G2tensor(71),[G1tensor(461),G0tensor(589)])
  call ol_merge_tensors(G0tensor(307),[G0tensor(182),G0tensor(180)])
  call ol_merge_tensors(G0tensor(362),[G0tensor(202),G0tensor(198)])
  call ol_merge_tensors(G0tensor(372),[G0tensor(207),G0tensor(200)])
  call ol_merge_tensors(G0tensor(352),[G0tensor(208),G0tensor(204)])
  call ol_merge_tensors(G0tensor(422),[G0tensor(243),G0tensor(239)])
  call ol_merge_tensors(G0tensor(308),[G0tensor(289),G0tensor(280)])
  call ol_merge_tensors(G0tensor(348),[G0tensor(329),G0tensor(320)])
  call ol_merge_tensors(G0tensor(373),[G0tensor(364),G0tensor(355)])
  call ol_merge_tensors(G0tensor(398),[G0tensor(389),G0tensor(385)])
  call ol_merge_tensors(G0tensor(418),[G0tensor(409),G0tensor(405)])
  call ol_merge_tensors(G0tensor(433),[G0tensor(429),G0tensor(425)])
  call ol_merge_tensors(G0tensor(458),[G0tensor(449),G0tensor(440)])
  call ol_merge_tensors(G0tensor(473),[G0tensor(469),G0tensor(465)])
  call ol_merge_tensors(G3tensor(7),[G3tensor(6)])
  call TI_triangle_red(G3tensor(9),RedBasis(93),mass3set(:,1),G0tensor(1),G0tensor(6),G0tensor(11),G0tensor(16),M2L1R1)
  call TI_triangle_red(G2tensor(41),RedBasis(2),mass3set(:,1),G0tensor(21),G0tensor(26),G0tensor(31),G0tensor(36),M2L1R1)
  call TI_triangle_red(G2tensor(97),RedBasis(8),mass3set(:,1),G0tensor(41),G0tensor(46),G0tensor(51),G0tensor(56),M2L1R1)
  call TI_triangle_red(G2tensor(96),RedBasis(109),mass3set(:,2),G0tensor(61),G0tensor(66),G0tensor(71),G0tensor(76),M2L1R1,[nMT], &
    G0tensor(81))
  call TI_triangle_red(G2tensor(56),RedBasis(99),mass3set(:,1),G0tensor(86),G0tensor(91),G0tensor(96),G0tensor(101),M2L1R1)
  call TI_triangle_red(G2tensor(47),RedBasis(125),mass3set(:,1),G0tensor(106),G0tensor(111),G0tensor(116),G0tensor(121),M2L1R1)
  call TI_triangle_red(G2tensor(103),RedBasis(27),mass3set(:,1),G0tensor(126),G0tensor(131),G0tensor(136),G0tensor(141),M2L1R1)
  call TI_triangle_red(G2tensor(119),RedBasis(126),mass3set(:,3),G0tensor(146),G0tensor(151),G0tensor(156), &
    G0tensor(161),M2L1R1,[nMT],G0tensor(166))
  call TI_triangle_red(G2tensor(45),RedBasis(109),mass3set(:,4),G0tensor(171),G0tensor(176),G0tensor(181), &
    G0tensor(186),M2L1R1,[nMT],G0tensor(191))
  call TI_triangle_red(G2tensor(107),RedBasis(95),mass3set(:,1),G0tensor(196),G0tensor(201),G0tensor(206),G0tensor(211),M2L1R1)
  call TI_triangle_red(G2tensor(50),RedBasis(142),mass3set(:,5),G0tensor(216),G0tensor(221),G0tensor(226), &
    G0tensor(231),M2L1R1,[nMT],G0tensor(236))
  call TI_triangle_red(G3tensor(5),RedBasis(93),mass3set(:,6),G0tensor(241),G0tensor(246),G0tensor(251), &
    G0tensor(256),M2L1R1,[nMT],G0tensor(261))
  call TI_triangle_red(G2tensor(136),RedBasis(112),mass3set(:,5),G0tensor(266),G0tensor(271),G0tensor(276), &
    G0tensor(281),M2L1R1,[nMT],G0tensor(286))
  call TI_triangle_red(G2tensor(137),RedBasis(133),mass3set(:,1),G0tensor(291),G0tensor(296),G0tensor(301),G0tensor(306),M2L1R1)
  call TI_triangle_red(G2tensor(99),RedBasis(92),mass3set(:,1),G0tensor(311),G0tensor(316),G0tensor(321),G0tensor(326),M2L1R1)
  call TI_triangle_red(G2tensor(57),RedBasis(128),mass3set(:,1),G0tensor(331),G0tensor(336),G0tensor(341),G0tensor(346),M2L1R1)
  call TI_triangle_red(G2tensor(72),RedBasis(86),mass3set(:,1),G0tensor(351),G0tensor(356),G0tensor(361),G0tensor(366),M2L1R1)
  call TI_triangle_red(G2tensor(60),RedBasis(84),mass3set(:,1),G0tensor(371),G0tensor(376),G0tensor(381),G0tensor(386),M2L1R1)
  call TI_triangle_red(G2tensor(86),RedBasis(100),mass3set(:,1),G0tensor(391),G0tensor(396),G0tensor(401),G0tensor(406),M2L1R1)
  call TI_triangle_red(G2tensor(53),RedBasis(117),mass3set(:,1),G0tensor(411),G0tensor(416),G0tensor(421),G0tensor(426),M2L1R1)
  call TI_triangle_red(G2tensor(101),RedBasis(91),mass3set(:,2),G0tensor(431),G0tensor(436),G0tensor(441), &
    G0tensor(446),M2L1R1,[nMT],G0tensor(451))
  call TI_triangle_red(G2tensor(115),RedBasis(142),mass3set(:,7),G0tensor(456),G0tensor(461),G0tensor(466), &
    G0tensor(471),M2L1R1,[nMT],G0tensor(476))
  call TI_triangle_red(G2tensor(89),RedBasis(88),mass3set(:,2),G0tensor(481),G0tensor(486),G0tensor(491), &
    G0tensor(496),M2L1R1,[nMT],G0tensor(501))
  call TI_triangle_red(G2tensor(28),RedBasis(94),mass3set(:,2),G0tensor(506),G0tensor(511),G0tensor(516), &
    G0tensor(521),M2L1R1,[nMT],G0tensor(526))
  call TI_triangle_red(G2tensor(26),RedBasis(112),mass3set(:,7),G0tensor(531),G0tensor(536),G0tensor(541), &
    G0tensor(546),M2L1R1,[nMT],G0tensor(551))
  call TI_triangle_red(G2tensor(133),RedBasis(97),mass3set(:,2),G0tensor(556),G0tensor(561),G0tensor(566), &
    G0tensor(571),M2L1R1,[nMT],G0tensor(576))
  call TI_triangle_red(G2tensor(142),RedBasis(119),mass3set(:,1),G0tensor(581),G0tensor(586),G0tensor(337),G0tensor(65),M2L1R1)
  call TI_triangle_red(G2tensor(30),RedBasis(126),mass3set(:,8),G0tensor(40),G0tensor(14),G0tensor(9),G0tensor(300),M2L1R1,[nMT], &
    G0tensor(80))
  call TI_triangle_red(G2tensor(34),RedBasis(33),mass3set(:,1),G0tensor(59),G0tensor(34),G0tensor(25),G0tensor(515),M2L1R1)
  call TI_triangle_red(G2tensor(124),RedBasis(40),mass3set(:,1),G0tensor(495),G0tensor(340),G0tensor(84),G0tensor(70),M2L1R1)
  call TI_triangle_red(G2tensor(48),RedBasis(94),mass3set(:,4),G0tensor(49),G0tensor(45),G0tensor(5),G0tensor(367),M2L1R1,[nMT], &
    G0tensor(245))
  call TI_triangle_red(G2tensor(65),RedBasis(88),mass3set(:,4),G0tensor(210),G0tensor(100),G0tensor(55), &
    G0tensor(452),M2L1R1,[nMT],G0tensor(275))
  call TI_triangle_red(G2tensor(68),RedBasis(91),mass3set(:,4),G0tensor(260),G0tensor(175),G0tensor(165), &
    G0tensor(130),M2L1R1,[nMT],G0tensor(15))
  call TI_triangle_red(G2tensor(71),RedBasis(97),mass3set(:,4),G0tensor(297),G0tensor(75),G0tensor(54),G0tensor(29),M2L1R1,[nMT], &
    G0tensor(20))
  call TI_triangle_red(G3tensor(7),RedBasis(93),mass3set(:,9),G0tensor(497),G0tensor(477),G0tensor(358), &
    G0tensor(298),M2L1R1,[nMB],G0tensor(283))
  call TI_triangle_red(G1tensor(419),RedBasis(143),mass3set(:,1),G0tensor(114),G0tensor(109),G0tensor(2),G0tensor(562),M2L1R1)
  call TI_triangle_red(G1tensor(414),RedBasis(6),mass3set(:,1),G0tensor(282),G0tensor(150),G0tensor(140),G0tensor(28),M2L1R1)
  call TI_triangle_red(G1tensor(277),RedBasis(3),mass3set(:,1),G0tensor(565),G0tensor(155),G0tensor(145),G0tensor(322),M2L1R1)
  call TI_triangle_red(G1tensor(284),RedBasis(124),mass3set(:,2),G0tensor(170),G0tensor(160),G0tensor(132), &
    G0tensor(127),M2L1R1,[nMT],G0tensor(8))
  call TI_triangle_red(G1tensor(272),RedBasis(4),mass3set(:,3),G0tensor(582),G0tensor(517),G0tensor(88), &
    G0tensor(590),M2L1R1,[nMT],G0tensor(585))
  call TI_triangle_red(G1tensor(287),RedBasis(1),mass3set(:,2),G0tensor(587),G0tensor(522),G0tensor(98), &
    G0tensor(238),M2L1R1,[nMT],G0tensor(212))
  call TI_triangle_red(G1tensor(292),RedBasis(12),mass3set(:,2),G0tensor(187),G0tensor(148),G0tensor(107), &
    G0tensor(73),M2L1R1,[nMT],G0tensor(47))
  call TI_triangle_red(G1tensor(302),RedBasis(9),mass3set(:,2),G0tensor(7),G0tensor(342),G0tensor(220),G0tensor(195),M2L1R1,[nMT], &
    G0tensor(120))
  call TI_triangle_red(G1tensor(402),RedBasis(10),mass3set(:,1),G0tensor(10),G0tensor(262),G0tensor(247),G0tensor(203),M2L1R1)
  call TI_triangle_red(G1tensor(407),RedBasis(7),mass3set(:,1),G0tensor(138),G0tensor(112),G0tensor(82),G0tensor(18),M2L1R1)
  call TI_triangle_red(G1tensor(314),RedBasis(129),mass3set(:,3),G0tensor(12),G0tensor(538),G0tensor(528), &
    G0tensor(505),M2L1R1,[nMT],G0tensor(485))
  call TI_triangle_red(G1tensor(317),RedBasis(14),mass3set(:,3),G0tensor(3),G0tensor(544),G0tensor(534), &
    G0tensor(510),M2L1R1,[nMT],G0tensor(490))
  call TI_triangle_red(G1tensor(322),RedBasis(13),mass3set(:,2),G0tensor(4),G0tensor(442),G0tensor(270), &
    G0tensor(255),M2L1R1,[nMT],G0tensor(122))
  call TI_triangle_red(G1tensor(327),RedBasis(18),mass3set(:,2),G0tensor(117),G0tensor(13),G0tensor(547), &
    G0tensor(199),M2L1R1,[nMT],G0tensor(179))
  call TI_triangle_red(G1tensor(332),RedBasis(16),mass3set(:,2),G0tensor(118),G0tensor(22),G0tensor(17), &
    G0tensor(579),M2L1R1,[nMT],G0tensor(574))
  call TI_triangle_red(G1tensor(334),RedBasis(131),mass3set(:,1),G0tensor(292),G0tensor(209),G0tensor(184),G0tensor(129),M2L1R1)
  call TI_triangle_red(G1tensor(404),RedBasis(21),mass3set(:,1),G0tensor(19),G0tensor(542),G0tensor(363),G0tensor(288),M2L1R1)
  call TI_triangle_red(G1tensor(337),RedBasis(19),mass3set(:,1),G0tensor(115),G0tensor(23),G0tensor(374),G0tensor(309),M2L1R1)
  call TI_triangle_red(G1tensor(412),RedBasis(24),mass3set(:,1),G0tensor(295),G0tensor(134),G0tensor(24),G0tensor(508),M2L1R1)
  call TI_triangle_red(G1tensor(417),RedBasis(23),mass3set(:,1),G0tensor(503),G0tensor(377),G0tensor(268),G0tensor(222),M2L1R1)
  call TI_triangle_red(G1tensor(99),RedBasis(129),mass3set(:,8),G0tensor(177),G0tensor(168),G0tensor(63), &
    G0tensor(32),M2L1R1,[nMT],G0tensor(27))
  call TI_triangle_red(G1tensor(392),RedBasis(103),mass3set(:,5),G0tensor(302),G0tensor(230),G0tensor(185), &
    G0tensor(90),M2L1R1,[nMT],G0tensor(30))
  call TI_triangle_red(G1tensor(397),RedBasis(104),mass3set(:,5),G0tensor(410),G0tensor(290),G0tensor(285), &
    G0tensor(33),M2L1R1,[nMT],G0tensor(420))
  call TI_triangle_red(G1tensor(420),RedBasis(65),mass3set(:,1),G0tensor(310),G0tensor(305),G0tensor(95),G0tensor(35),M2L1R1)
  call TI_triangle_red(G1tensor(425),RedBasis(28),mass3set(:,1),G0tensor(249),G0tensor(189),G0tensor(42),G0tensor(37),M2L1R1)
  call TI_triangle_red(G1tensor(422),RedBasis(107),mass3set(:,1),G0tensor(488),G0tensor(483),G0tensor(312),G0tensor(253),M2L1R1)
  call TI_triangle_red(G1tensor(427),RedBasis(108),mass3set(:,1),G0tensor(232),G0tensor(197),G0tensor(158),G0tensor(57),M2L1R1)
  call TI_triangle_red(G1tensor(48),RedBasis(153),mass3set(:,3),G0tensor(52),G0tensor(38),G0tensor(332), &
    G0tensor(259),M2L1R1,[nMT],G0tensor(194))
  call TI_triangle_red(G1tensor(429),RedBasis(127),mass3set(:,3),G0tensor(99),G0tensor(39),G0tensor(448), &
    G0tensor(328),M2L1R1,[nMT],G0tensor(315))
  call TI_triangle_red(G1tensor(262),RedBasis(111),mass3set(:,7),G0tensor(43),G0tensor(459),G0tensor(349), &
    G0tensor(335),M2L1R1,[nMT],G0tensor(104))
  call TI_triangle_red(G1tensor(432),RedBasis(110),mass3set(:,4),G0tensor(44),G0tensor(530),G0tensor(390), &
    G0tensor(330),M2L1R1,[nMT],G0tensor(325))
  call TI_triangle_red(G1tensor(450),RedBasis(123),mass3set(:,3),G0tensor(48),G0tensor(535),G0tensor(400), &
    G0tensor(350),M2L1R1,[nMT],G0tensor(345))
  call TI_triangle_red(G1tensor(439),RedBasis(132),mass3set(:,3),G0tensor(125),G0tensor(50),G0tensor(357), &
    G0tensor(240),M2L1R1,[nMT],G0tensor(205))
  call TI_triangle_red(G1tensor(208),RedBasis(115),mass3set(:,7),G0tensor(53),G0tensor(430),G0tensor(365), &
    G0tensor(360),M2L1R1,[nMT],G0tensor(58))
  call TI_triangle_red(G1tensor(442),RedBasis(114),mass3set(:,4),G0tensor(435),G0tensor(375),G0tensor(370), &
    G0tensor(105),M2L1R1,[nMT],G0tensor(60))
  call TI_triangle_red(G1tensor(95),RedBasis(145),mass3set(:,7),G0tensor(563),G0tensor(264),G0tensor(214), &
    G0tensor(67),M2L1R1,[nMT],G0tensor(62))
  call TI_triangle_red(G1tensor(444),RedBasis(96),mass3set(:,2),G0tensor(392),G0tensor(274),G0tensor(219), &
    G0tensor(89),M2L1R1,[nMT],G0tensor(64))
  call TI_triangle_red(G1tensor(167),RedBasis(118),mass3set(:,2),G0tensor(468),G0tensor(388),G0tensor(380), &
    G0tensor(68),M2L1R1,[nMT],G0tensor(474))
  call TI_triangle_red(G1tensor(447),RedBasis(110),mass3set(:,2),G0tensor(399),G0tensor(395),G0tensor(94), &
    G0tensor(69),M2L1R1,[nMT],G0tensor(552))
  call TI_triangle_red(G1tensor(440),RedBasis(116),mass3set(:,7),G0tensor(234),G0tensor(224),G0tensor(128), &
    G0tensor(77),M2L1R1,[nMT],G0tensor(72))
  call TI_triangle_red(G1tensor(449),RedBasis(98),mass3set(:,2),G0tensor(412),G0tensor(244),G0tensor(229), &
    G0tensor(119),M2L1R1,[nMT],G0tensor(74))
  call TI_triangle_red(G1tensor(142),RedBasis(122),mass3set(:,2),G0tensor(532),G0tensor(428),G0tensor(408), &
    G0tensor(110),M2L1R1,[nMT],G0tensor(78))
  call TI_triangle_red(G1tensor(452),RedBasis(121),mass3set(:,2),G0tensor(434),G0tensor(419),G0tensor(415), &
    G0tensor(124),M2L1R1,[nMT],G0tensor(79))
  call TI_triangle_red(G1tensor(111),RedBasis(144),mass3set(:,7),G0tensor(540),G0tensor(470),G0tensor(450), &
    G0tensor(445),M2L1R1,[nMT],G0tensor(83))
  call TI_triangle_red(G1tensor(445),RedBasis(120),mass3set(:,3),G0tensor(545),G0tensor(475),G0tensor(460), &
    G0tensor(455),M2L1R1,[nMT],G0tensor(135))
  call TI_triangle_red(G1tensor(195),RedBasis(147),mass3set(:,7),G0tensor(85),G0tensor(92),G0tensor(87), &
    G0tensor(520),M2L1R1,[nMT],G0tensor(93))
  call TI_triangle_red(G1tensor(202),RedBasis(146),mass3set(:,7),G0tensor(102),G0tensor(97),G0tensor(525), &
    G0tensor(103),M2L1R1,[nMT],G0tensor(548))
  call TI_triangle_red(G1tensor(203),RedBasis(101),mass3set(:,2),G0tensor(527),G0tensor(423),G0tensor(413), &
    G0tensor(403),M2L1R1,[nMT],G0tensor(108))
  call TI_triangle_red(G1tensor(430),RedBasis(113),mass3set(:,7),G0tensor(553),G0tensor(537),G0tensor(353), &
    G0tensor(293),M2L1R1,[nMT],G0tensor(278))
  call TI_triangle_red(G1tensor(265),RedBasis(102),mass3set(:,2),G0tensor(113),G0tensor(550),G0tensor(123), &
    G0tensor(555),M2L1R1,[nMT],G0tensor(133))
  call TI_triangle_red(G1tensor(391),RedBasis(29),mass3set(:,3),G0tensor(287),G0tensor(178),G0tensor(142), &
    G0tensor(137),M2L1R1,[nMT],G0tensor(557))
  call TI_triangle_red(G1tensor(395),RedBasis(41),mass3set(:,3),G0tensor(277),G0tensor(183),G0tensor(139), &
    G0tensor(472),M2L1R1,[nMT],G0tensor(272))
  call TI_triangle_red(G1tensor(421),RedBasis(42),mass3set(:,1),G0tensor(265),G0tensor(143),G0tensor(560),G0tensor(144),M2L1R1)
  call TI_triangle_red(G1tensor(396),RedBasis(52),mass3set(:,3),G0tensor(578),G0tensor(407),G0tensor(223), &
    G0tensor(152),M2L1R1,[nMT],G0tensor(147))
  call TI_triangle_red(G1tensor(390),RedBasis(59),mass3set(:,3),G0tensor(567),G0tensor(402),G0tensor(228), &
    G0tensor(149),M2L1R1,[nMT],G0tensor(397))
  call TI_triangle_red(G1tensor(426),RedBasis(74),mass3set(:,1),G0tensor(217),G0tensor(215),G0tensor(153),G0tensor(570),M2L1R1)
  call TI_triangle_red(G1tensor(354),RedBasis(149),mass3set(:,7),G0tensor(154),G0tensor(327),G0tensor(188), &
    G0tensor(162),M2L1R1,[nMT],G0tensor(157))
  call TI_triangle_red(G1tensor(359),RedBasis(148),mass3set(:,7),G0tensor(572),G0tensor(317),G0tensor(193), &
    G0tensor(159),M2L1R1,[nMT],G0tensor(432))
  call TI_triangle_red(G1tensor(364),RedBasis(103),mass3set(:,7),G0tensor(242),G0tensor(235),G0tensor(163), &
    G0tensor(575),M2L1R1,[nMT],G0tensor(164))
  call TI_triangle_red(G1tensor(365),RedBasis(87),mass3set(:,2),G0tensor(568),G0tensor(387),G0tensor(213), &
    G0tensor(172),M2L1R1,[nMT],G0tensor(167))
  call TI_triangle_red(G1tensor(366),RedBasis(85),mass3set(:,2),G0tensor(577),G0tensor(382),G0tensor(218), &
    G0tensor(169),M2L1R1,[nMT],G0tensor(417))
  call TI_triangle_red(G1tensor(374),RedBasis(151),mass3set(:,7),G0tensor(227),G0tensor(225),G0tensor(173), &
    G0tensor(580),M2L1R1,[nMT],G0tensor(174))
  call TI_triangle_red(G1tensor(379),RedBasis(150),mass3set(:,7),G0tensor(347),G0tensor(192),G0tensor(190), &
    G0tensor(573),M2L1R1,[nMT],G0tensor(427))
  call TI_triangle_red(G1tensor(384),RedBasis(104),mass3set(:,7),G0tensor(237),G0tensor(233),G0tensor(447), &
    G0tensor(252),M2L1R1,[nMT],G0tensor(248))
  call TI_triangle_red(G1tensor(385),RedBasis(90),mass3set(:,2),G0tensor(457),G0tensor(257),G0tensor(250), &
    G0tensor(437),M2L1R1,[nMT],G0tensor(258))
  call TI_triangle_red(G1tensor(386),RedBasis(89),mass3set(:,2),G0tensor(254),G0tensor(558),G0tensor(467), &
    G0tensor(267),M2L1R1,[nMT],G0tensor(263))
  call TI_triangle_red(G1tensor(405),RedBasis(105),mass3set(:,1),G0tensor(462),G0tensor(273),G0tensor(269),G0tensor(519),M2L1R1)
  call TI_triangle_red(G1tensor(415),RedBasis(106),mass3set(:,1),G0tensor(404),G0tensor(303),G0tensor(284),G0tensor(279),M2L1R1)
  call ol_merge_tensors(T0sum(119),[G0tensor(1)])
  call ol_merge_tensors(T0sum(120),[G0tensor(21)])
  call ol_merge_tensors(T0sum(121),[G0tensor(41)])
  call ol_merge_tensors(T0sum(122),[G0tensor(61)])
  call ol_merge_tensors(T0sum(123),[G0tensor(86)])
  call ol_merge_tensors(T0sum(124),[G0tensor(106)])
  call ol_merge_tensors(T0sum(125),[G0tensor(126)])
  call ol_merge_tensors(T0sum(126),[G0tensor(146)])
  call ol_merge_tensors(T0sum(127),[G0tensor(171)])
  call ol_merge_tensors(T0sum(128),[G0tensor(196)])
  call ol_merge_tensors(T0sum(129),[G0tensor(216)])
  call ol_merge_tensors(T0sum(130),[G0tensor(241)])
  call ol_merge_tensors(T0sum(131),[G0tensor(266)])
  call ol_merge_tensors(T0sum(132),[G0tensor(291)])
  call ol_merge_tensors(T0sum(133),[G0tensor(311)])
  call ol_merge_tensors(T0sum(134),[G0tensor(331)])
  call ol_merge_tensors(T0sum(135),[G0tensor(351)])
  call ol_merge_tensors(T0sum(136),[G0tensor(371)])
  call ol_merge_tensors(T0sum(137),[G0tensor(391)])
  call ol_merge_tensors(T0sum(138),[G0tensor(114)])
  call ol_merge_tensors(T0sum(139),[G0tensor(411)])
  call ol_merge_tensors(T0sum(140),[G0tensor(282)])
  call ol_merge_tensors(T0sum(141),[G0tensor(565)])
  call ol_merge_tensors(T0sum(142),[G0tensor(431)])
  call ol_merge_tensors(T0sum(143),[G0tensor(170)])
  call ol_merge_tensors(T0sum(144),[G0tensor(582)])
  call ol_merge_tensors(T0sum(145),[G0tensor(587)])
  call ol_merge_tensors(T0sum(146),[G0tensor(456)])
  call ol_merge_tensors(T0sum(147),[G0tensor(481)])
  call ol_merge_tensors(T0sum(148),[G0tensor(506)])
  call ol_merge_tensors(T0sum(149),[G0tensor(187)])
  call ol_merge_tensors(T0sum(150),[G0tensor(7)])
  call ol_merge_tensors(T0sum(151),[G0tensor(10)])
  call ol_merge_tensors(T0sum(152),[G0tensor(138)])
  call ol_merge_tensors(T0sum(153),[G0tensor(12)])
  call ol_merge_tensors(T0sum(154),[G0tensor(3)])
  call ol_merge_tensors(T0sum(155),[G0tensor(4)])
  call ol_merge_tensors(T0sum(156),[G0tensor(531)])
  call ol_merge_tensors(T0sum(157),[G0tensor(556)])
  call ol_merge_tensors(T0sum(158),[G0tensor(117)])
  call ol_merge_tensors(T0sum(159),[G0tensor(118)])
  call ol_merge_tensors(T0sum(160),[G0tensor(581)])
  call ol_merge_tensors(T0sum(161),[G0tensor(292)])
  call ol_merge_tensors(T0sum(162),[G0tensor(19)])
  call ol_merge_tensors(T0sum(163),[G0tensor(115)])
  call ol_merge_tensors(T0sum(164),[G0tensor(295)])
  call ol_merge_tensors(T0sum(165),[G0tensor(503)])
  call ol_merge_tensors(T0sum(166),[G0tensor(177)])
  call ol_merge_tensors(T0sum(167),[G0tensor(302)])
  call ol_merge_tensors(T0sum(168),[G0tensor(40)])
  call ol_merge_tensors(T0sum(169),[G0tensor(410)])
  call ol_merge_tensors(T0sum(170),[G0tensor(310)])
  call ol_merge_tensors(T0sum(171),[G0tensor(249)])
  call ol_merge_tensors(T0sum(172),[G0tensor(488)])
  call ol_merge_tensors(T0sum(173),[G0tensor(232)])
  call ol_merge_tensors(T0sum(174),[G0tensor(52)])
  call ol_merge_tensors(T0sum(175),[G0tensor(99)])
  call ol_merge_tensors(T0sum(176),[G0tensor(43)])
  call ol_merge_tensors(T0sum(177),[G0tensor(44)])
  call ol_merge_tensors(T0sum(178),[G0tensor(48)])
  call ol_merge_tensors(T0sum(179),[G0tensor(125)])
  call ol_merge_tensors(T0sum(180),[G0tensor(53)])
  call ol_merge_tensors(T0sum(181),[G0tensor(435)])
  call ol_merge_tensors(T0sum(182),[G0tensor(563)])
  call ol_merge_tensors(T0sum(183),[G0tensor(392)])
  call ol_merge_tensors(T0sum(184),[G0tensor(468)])
  call ol_merge_tensors(T0sum(185),[G0tensor(399)])
  call ol_merge_tensors(T0sum(186),[G0tensor(234)])
  call ol_merge_tensors(T0sum(187),[G0tensor(412)])
  call ol_merge_tensors(T0sum(188),[G0tensor(532)])
  call ol_merge_tensors(T0sum(189),[G0tensor(434)])
  call ol_merge_tensors(T0sum(190),[G0tensor(540)])
  call ol_merge_tensors(T0sum(191),[G0tensor(545)])
  call ol_merge_tensors(T0sum(192),[G0tensor(85)])
  call ol_merge_tensors(T0sum(193),[G0tensor(102)])
  call ol_merge_tensors(T0sum(194),[G0tensor(527)])
  call ol_merge_tensors(T0sum(195),[G0tensor(553)])
  call ol_merge_tensors(T0sum(196),[G0tensor(113)])
  call ol_merge_tensors(T0sum(197),[G0tensor(287)])
  call ol_merge_tensors(T0sum(198),[G0tensor(59)])
  call ol_merge_tensors(T0sum(199),[G0tensor(277)])
  call ol_merge_tensors(T0sum(200),[G0tensor(495)])
  call ol_merge_tensors(T0sum(201),[G0tensor(265)])
  call ol_merge_tensors(T0sum(202),[G0tensor(578)])
  call ol_merge_tensors(T0sum(203),[G0tensor(567)])
  call ol_merge_tensors(T0sum(204),[G0tensor(217)])
  call ol_merge_tensors(T0sum(205),[G0tensor(154)])
  call ol_merge_tensors(T0sum(206),[G0tensor(572)])
  call ol_merge_tensors(T0sum(207),[G0tensor(242)])
  call ol_merge_tensors(T0sum(208),[G0tensor(568)])
  call ol_merge_tensors(T0sum(209),[G0tensor(577)])
  call ol_merge_tensors(T0sum(210),[G0tensor(227)])
  call ol_merge_tensors(T0sum(211),[G0tensor(347)])
  call ol_merge_tensors(T0sum(212),[G0tensor(237)])
  call ol_merge_tensors(T0sum(213),[G0tensor(457)])
  call ol_merge_tensors(T0sum(214),[G0tensor(254)])
  call ol_merge_tensors(T0sum(215),[G0tensor(462)])
  call ol_merge_tensors(T0sum(216),[G0tensor(404)])
  call ol_merge_tensors(T0sum(217),[G0tensor(49)])
  call ol_merge_tensors(T0sum(218),[G0tensor(210)])
  call ol_merge_tensors(T0sum(219),[G0tensor(260)])
  call ol_merge_tensors(T0sum(220),[G0tensor(297)])
  call ol_merge_tensors(T0sum(221),[G0tensor(307)])
  call ol_merge_tensors(T0sum(222),[G0tensor(362)])
  call ol_merge_tensors(T0sum(223),[G0tensor(372)])
  call ol_merge_tensors(T0sum(224),[G0tensor(352)])
  call ol_merge_tensors(T0sum(225),[G0tensor(422)])
  call ol_merge_tensors(T0sum(226),[G0tensor(308)])
  call ol_merge_tensors(T0sum(227),[G0tensor(348)])
  call ol_merge_tensors(T0sum(228),[G0tensor(373)])
  call ol_merge_tensors(T0sum(229),[G0tensor(398)])
  call ol_merge_tensors(T0sum(230),[G0tensor(418)])
  call ol_merge_tensors(T0sum(231),[G0tensor(433)])
  call ol_merge_tensors(T0sum(232),[G0tensor(458)])
  call ol_merge_tensors(T0sum(233),[G0tensor(473)])
  call ol_merge_tensors(T0sum(234),[G0tensor(497)])
  Gcoeff(:)%j = (c(1)*(-M(2,:)%j+M(3,:)%j)) * den(87)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(149),h0tab(:,149),[60,3],[0,0],3,3,wf4(:,2),wf4(:,3),wf4(:,1))
  call Hloop_GGG_G_12(ntryL,G0H64(1),wf4(:,2),wf4(:,3),G0H4(2),m4h4x4x4(:,7),heltab3x64(:,:,7))
  Gcoeff(:)%j = (c(1)*(M(2,:)%j-M(3,:)%j)) * den(87)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(150),h0tab(:,150),[60,3],[0,0],3,3,wf4(:,3),wf4(:,2),wf4(:,1))
  call Hloop_GGG_G_12(ntryL,G0H64(1),wf4(:,3),wf4(:,2),G0H4(1),m4h4x4x4(:,8),heltab3x64(:,:,8))
  Gcoeff(:)%j = (c(2)*(M(2,:)%j-M(3,:)%j)) * den(87)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(151),h0tab(:,151),[60,3],[0,0],3,3,wf4(:,2),wf4(:,3),wf4(:,1))
  call Hloop_GGG_G_23(ntryL,G0H64(1),wf4(:,2),wf4(:,3),G0H4(6),m4h4x4x4(:,9),heltab3x64(:,:,9))
  Gcoeff(:)%j = (c(1)*(M(2,:)%j-M(3,:)%j)) * den(88)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(152),h0tab(:,152),[51,12],[0,0],3,3,wf4(:,1),wf4(:,3),wf4(:,2))
  call Hloop_GGG_G_12(ntryL,G0H64(1),wf4(:,1),wf4(:,3),G0H4(5),m4h4x4x4(:,10),heltab3x64(:,:,10))
  Gcoeff(:)%j = (c(1)*(-M(2,:)%j+M(3,:)%j)) * den(88)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(153),h0tab(:,153),[51,12],[0,0],3,3,wf4(:,3),wf4(:,1),wf4(:,2))
  call Hloop_GGG_G_12(ntryL,G0H64(1),wf4(:,3),wf4(:,1),G0H4(4),m4h4x4x4(:,11),heltab3x64(:,:,11))
  Gcoeff(:)%j = (c(2)*(-M(2,:)%j+M(3,:)%j)) * den(88)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(154),h0tab(:,154),[51,12],[0,0],3,3,wf4(:,1),wf4(:,3),wf4(:,2))
  call Hloop_GGG_G_23(ntryL,G0H64(1),wf4(:,1),wf4(:,3),G0H4(7),m4h4x4x4(:,12),heltab3x64(:,:,12))
  Gcoeff(:)%j = (c(1)*(-M(2,:)%j+M(3,:)%j)) * den(5)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(155),h0tab(:,155),[48,15],[0,0],3,3,wf4(:,3),wf4(:,1),wf4(:,2))
  call Hloop_UV_W(ntryL,G0H64(1),0,wf4(:,3),48,G1H16(3),m3h4x16(:,40),heltab2x64(:,:,143))
  Gcoeff(:)%j = (c(1)*(M(2,:)%j-M(3,:)%j)) * den(5)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(156),h0tab(:,156),[48,15],[0,0],3,3,wf4(:,3),wf4(:,2),wf4(:,1))
  call Hloop_UV_W(ntryL,G0H64(1),0,wf4(:,3),48,G1H16(5),m3h4x16(:,41),heltab2x64(:,:,144))
  Gcoeff(:)%j = (c(2)*(M(2,:)%j-M(3,:)%j)) * den(5)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(157),h0tab(:,157),[48,15],[0,0],3,3,wf4(:,3),wf4(:,1),wf4(:,2))
  call Hloop_UV_W(ntryL,G0H64(1),0,wf4(:,3),48,G1H16(7),m3h4x16(:,42),heltab2x64(:,:,145))
  Gcoeff(:)%j = (c(28)*(M(2,:)%j-M(3,:)%j)) * den(52)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(158),h0tab(:,158),[48,15],[0,0],2,2,wf4(:,3),wf16(:,1))
  call Hloop_QV_A(ntryL,G0H64(1),wf4(:,3),G0H16(1),m3h4x16(:,43),heltab2x64(:,:,146))
  call Hloop_Q_A(ntryL,G0H16(1),48,0,G1H16(4),n2h16(49))
  Gcoeff(:)%j = (c(27)*(M(2,:)%j-M(3,:)%j)) * den(52)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(159),h0tab(:,159),[48,15],[nMT,nMT],2,2,wf4(:,3),wf16(:,1))
  call Hloop_QV_A(ntryL,G0H64(1),wf4(:,3),G0H16(1),m3h4x16(:,44),heltab2x64(:,:,147))
  call Hloop_Q_A(ntryL,G0H16(1),48,nMT,G1H16(9),n2h16(50))
  Gcoeff(:)%j = (c(28)*(M(2,:)%j-M(3,:)%j)) * den(52)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(160),h0tab(:,160),[48,15],[0,0],2,2,wf4(:,3),wf16(:,1))
  call Hloop_QV_A(ntryL,G0H64(1),wf4(:,3),G0H16(1),m3h4x16(:,45),heltab2x64(:,:,148))
  call Hloop_Q_A(ntryL,G0H16(1),48,0,G1H16(6),n2h16(51))
  Gcoeff(:)%j = (c(27)*(M(2,:)%j-M(3,:)%j)) * den(52)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(161),h0tab(:,161),[48,15],[nMB,nMB],2,2,wf4(:,3),wf16(:,1))
  call Hloop_QV_A(ntryL,G0H64(1),wf4(:,3),G0H16(1),m3h4x16(:,46),heltab2x64(:,:,149))
  call Hloop_Q_A(ntryL,G0H16(1),48,nMB,G1H16(8),n2h16(52))
  Gcoeff(:)%j = (c(7)*(M(2,:)%j-M(3,:)%j)) * den(52)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(162),h0tab(:,162),[48,15],[0,0],2,2,wf4(:,3),wf16(:,1))
  call Hloop_CV_D(ntryL,G0H64(1),0,wf4(:,3),48,G1H16(10),m3h4x16(:,47),heltab2x64(:,:,150))
  Gcoeff(:)%j = (c(2)*(-M(2,:)%j+M(3,:)%j)) * den(52)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(163),h0tab(:,163),[48,15],[0,0],2,2,wf4(:,3),wf16(:,1))
  call Hloop_UV_W(ntryL,G0H64(1),0,wf4(:,3),48,G1H16(11),m3h4x16(:,48),heltab2x64(:,:,151))
  Gcoeff(:)%j = (c(28)*(-M(2,:)%j+M(3,:)%j)) * den(49)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(164),h0tab(:,164),[51,12],[0,0],2,2,wf16(:,6),wf4(:,2))
  call Hloop_QV_A(ntryL,G0H64(1),wf16(:,6),G0H4(3),m3h16x4(:,21),heltab2x64(:,:,152))
  call Hloop_Q_A(ntryL,G0H4(3),51,0,G1H4(4),n2h4(66))
  Gcoeff(:)%j = (c(27)*(-M(2,:)%j+M(3,:)%j)) * den(49)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(165),h0tab(:,165),[51,12],[nMT,nMT],2,2,wf16(:,6),wf4(:,2))
  call Hloop_QV_A(ntryL,G0H64(1),wf16(:,6),G0H4(3),m3h16x4(:,22),heltab2x64(:,:,153))
  call Hloop_Q_A(ntryL,G0H4(3),51,nMT,G1H4(25),n2h4(67))
  Gcoeff(:)%j = (c(28)*(-M(2,:)%j+M(3,:)%j)) * den(49)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(166),h0tab(:,166),[51,12],[0,0],2,2,wf16(:,6),wf4(:,2))
  call Hloop_QV_A(ntryL,G0H64(1),wf16(:,6),G0H4(3),m3h16x4(:,23),heltab2x64(:,:,154))
  call Hloop_Q_A(ntryL,G0H4(3),51,0,G1H4(36),n2h4(68))
  Gcoeff(:)%j = (c(27)*(-M(2,:)%j+M(3,:)%j)) * den(49)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(167),h0tab(:,167),[51,12],[nMB,nMB],2,2,wf16(:,6),wf4(:,2))
  call Hloop_QV_A(ntryL,G0H64(1),wf16(:,6),G0H4(3),m3h16x4(:,24),heltab2x64(:,:,155))
  call Hloop_Q_A(ntryL,G0H4(3),51,nMB,G1H4(5),n2h4(69))
  Gcoeff(:)%j = (c(7)*(-M(2,:)%j+M(3,:)%j)) * den(49)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(168),h0tab(:,168),[51,12],[0,0],2,2,wf16(:,6),wf4(:,2))
  call Hloop_CV_D(ntryL,G0H64(1),0,wf16(:,6),51,G1H4(19),m3h16x4(:,25),heltab2x64(:,:,156))
  Gcoeff(:)%j = (c(2)*(M(2,:)%j-M(3,:)%j)) * den(49)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(169),h0tab(:,169),[51,12],[0,0],2,2,wf16(:,6),wf4(:,2))
  call Hloop_UV_W(ntryL,G0H64(1),0,wf16(:,6),51,G1H4(12),m3h16x4(:,26),heltab2x64(:,:,157))
  Gcoeff(:)%j = (c(28)*(M(2,:)%j-M(3,:)%j)) * den(45)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(170),h0tab(:,170),[60,3],[0,0],2,2,wf16(:,5),wf4(:,1))
  call Hloop_QV_A(ntryL,G0H64(1),wf16(:,5),G0H4(3),m3h16x4(:,27),heltab2x64(:,:,158))
  call Hloop_Q_A(ntryL,G0H4(3),60,0,G1H4(31),n2h4(70))
  Gcoeff(:)%j = (c(27)*(M(2,:)%j-M(3,:)%j)) * den(45)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(171),h0tab(:,171),[60,3],[nMT,nMT],2,2,wf16(:,5),wf4(:,1))
  call Hloop_QV_A(ntryL,G0H64(1),wf16(:,5),G0H4(3),m3h16x4(:,28),heltab2x64(:,:,159))
  call Hloop_Q_A(ntryL,G0H4(3),60,nMT,G1H4(6),n2h4(71))
  Gcoeff(:)%j = (c(28)*(M(2,:)%j-M(3,:)%j)) * den(45)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(172),h0tab(:,172),[60,3],[0,0],2,2,wf16(:,5),wf4(:,1))
  call Hloop_QV_A(ntryL,G0H64(1),wf16(:,5),G0H4(3),m3h16x4(:,29),heltab2x64(:,:,160))
  call Hloop_Q_A(ntryL,G0H4(3),60,0,G1H4(22),n2h4(72))
  Gcoeff(:)%j = (c(27)*(M(2,:)%j-M(3,:)%j)) * den(45)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(173),h0tab(:,173),[60,3],[nMB,nMB],2,2,wf16(:,5),wf4(:,1))
  call Hloop_QV_A(ntryL,G0H64(1),wf16(:,5),G0H4(3),m3h16x4(:,30),heltab2x64(:,:,161))
  call Hloop_Q_A(ntryL,G0H4(3),60,nMB,G1H4(38),n2h4(73))
  Gcoeff(:)%j = (c(7)*(M(2,:)%j-M(3,:)%j)) * den(45)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(174),h0tab(:,174),[60,3],[0,0],2,2,wf16(:,5),wf4(:,1))
  call Hloop_CV_D(ntryL,G0H64(1),0,wf16(:,5),60,G1H4(34),m3h16x4(:,31),heltab2x64(:,:,162))
  Gcoeff(:)%j = (c(2)*(-M(2,:)%j+M(3,:)%j)) * den(45)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(175),h0tab(:,175),[60,3],[0,0],2,2,wf16(:,5),wf4(:,1))
  call Hloop_UV_W(ntryL,G0H64(1),0,wf16(:,5),60,G1H4(30),m3h16x4(:,32),heltab2x64(:,:,163))
  Gcoeff(:)%j = (c(24)*M(3,:)%j+c(19)*(-M(1,:)%j-M(4,:)%j)+c(14)*M(6,:)%j) * den(59)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(176),h0tab(:,176),[44,19],[0,0],2,2,wf8(:,24),wf8(:,3))
  call Hloop_VA_Q(ntryL,G0H64(1),wf8(:,24),G0H8(3),m3h8x8(:,25),heltab2x64(:,:,164))
  call Hloop_A_Q(ntryL,G0H8(3),44,0,G1H8(9),n2h8(33))
  Gcoeff(:)%j = (-(c(36)*M(3,:)%j)+c(35)*(M(1,:)%j+M(4,:)%j)-c(33)*M(6,:)%j) * den(89)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(177),h0tab(:,177),[51,12],[0,0],2,2,wf16(:,9),wf4(:,2))
  call Hloop_QV_A(ntryL,G0H64(1),wf16(:,9),G0H4(3),m3h16x4(:,33),heltab2x64(:,:,165))
  call Hloop_Q_A(ntryL,G0H4(3),51,0,G1H4(26),n2h4(74))
  Gcoeff(:)%j = (-(c(32)*M(3,:)%j)+c(31)*(M(1,:)%j+M(4,:)%j)-c(29)*M(6,:)%j) * den(89)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(178),h0tab(:,178),[51,12],[nMT,nMT],2,2,wf16(:,9),wf4(:,2))
  call Hloop_QV_A(ntryL,G0H64(1),wf16(:,9),G0H4(3),m3h16x4(:,34),heltab2x64(:,:,166))
  call Hloop_Q_A(ntryL,G0H4(3),51,nMT,G1H4(3),n2h4(75))
  Gcoeff(:)%j = (-(c(36)*M(3,:)%j)+c(35)*(M(1,:)%j+M(4,:)%j)-c(33)*M(6,:)%j) * den(89)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(179),h0tab(:,179),[51,12],[0,0],2,2,wf16(:,9),wf4(:,2))
  call Hloop_QV_A(ntryL,G0H64(1),wf16(:,9),G0H4(3),m3h16x4(:,35),heltab2x64(:,:,167))
  call Hloop_Q_A(ntryL,G0H4(3),51,0,G1H4(15),n2h4(76))
  Gcoeff(:)%j = (-(c(32)*M(3,:)%j)+c(31)*(M(1,:)%j+M(4,:)%j)-c(29)*M(6,:)%j) * den(89)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(180),h0tab(:,180),[51,12],[nMB,nMB],2,2,wf16(:,9),wf4(:,2))
  call Hloop_QV_A(ntryL,G0H64(1),wf16(:,9),G0H4(3),m3h16x4(:,36),heltab2x64(:,:,168))
  call Hloop_Q_A(ntryL,G0H4(3),51,nMB,G1H4(17),n2h4(77))
  Gcoeff(:)%j = (-(c(26)*M(3,:)%j)+c(22)*(M(1,:)%j+M(4,:)%j)-c(17)*M(6,:)%j) * den(89)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(181),h0tab(:,181),[51,12],[0,0],2,2,wf16(:,9),wf4(:,2))
  call Hloop_CV_D(ntryL,G0H64(1),0,wf16(:,9),51,G1H4(14),m3h16x4(:,37),heltab2x64(:,:,169))
  Gcoeff(:)%j = (c(10)*M(3,:)%j+c(9)*(-M(1,:)%j-M(4,:)%j)+c(8)*M(6,:)%j) * den(89)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(182),h0tab(:,182),[51,12],[0,0],2,2,wf16(:,9),wf4(:,2))
  call Hloop_UV_W(ntryL,G0H64(1),0,wf16(:,9),51,G1H4(37),m3h16x4(:,38),heltab2x64(:,:,170))
  Gcoeff(:)%j = (c(24)*M(2,:)%j+c(19)*(-M(1,:)%j-M(4,:)%j)+c(14)*M(6,:)%j) * den(60)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(183),h0tab(:,183),[35,28],[0,0],2,2,wf8(:,22),wf8(:,6))
  call Hloop_VA_Q(ntryL,G0H64(1),wf8(:,22),G0H8(7),m3h8x8(:,26),heltab2x64(:,:,171))
  call Hloop_A_Q(ntryL,G0H8(7),35,0,G1H8(20),n2h8(34))
  Gcoeff(:)%j = (-(c(36)*M(2,:)%j)+c(35)*(M(1,:)%j+M(4,:)%j)-c(33)*M(6,:)%j) * den(90)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(184),h0tab(:,184),[51,12],[0,0],2,2,wf16(:,10),wf4(:,2))
  call Hloop_QV_A(ntryL,G0H64(1),wf16(:,10),G0H4(3),m3h16x4(:,39),heltab2x64(:,:,172))
  call Hloop_Q_A(ntryL,G0H4(3),51,0,G1H4(33),n2h4(78))
  Gcoeff(:)%j = (-(c(32)*M(2,:)%j)+c(31)*(M(1,:)%j+M(4,:)%j)-c(29)*M(6,:)%j) * den(90)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(185),h0tab(:,185),[51,12],[nMT,nMT],2,2,wf16(:,10),wf4(:,2))
  call Hloop_QV_A(ntryL,G0H64(1),wf16(:,10),G0H4(3),m3h16x4(:,40),heltab2x64(:,:,173))
  call Hloop_Q_A(ntryL,G0H4(3),51,nMT,G1H4(1),n2h4(79))
  Gcoeff(:)%j = (-(c(36)*M(2,:)%j)+c(35)*(M(1,:)%j+M(4,:)%j)-c(33)*M(6,:)%j) * den(90)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(186),h0tab(:,186),[51,12],[0,0],2,2,wf16(:,10),wf4(:,2))
  call Hloop_QV_A(ntryL,G0H64(1),wf16(:,10),G0H4(3),m3h16x4(:,41),heltab2x64(:,:,174))
  call Hloop_Q_A(ntryL,G0H4(3),51,0,G1H4(8),n2h4(80))
  Gcoeff(:)%j = (-(c(32)*M(2,:)%j)+c(31)*(M(1,:)%j+M(4,:)%j)-c(29)*M(6,:)%j) * den(90)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(187),h0tab(:,187),[51,12],[nMB,nMB],2,2,wf16(:,10),wf4(:,2))
  call Hloop_QV_A(ntryL,G0H64(1),wf16(:,10),G0H4(3),m3h16x4(:,42),heltab2x64(:,:,175))
  call Hloop_Q_A(ntryL,G0H4(3),51,nMB,G1H4(32),n2h4(81))
  Gcoeff(:)%j = (-(c(26)*M(2,:)%j)+c(22)*(M(1,:)%j+M(4,:)%j)-c(17)*M(6,:)%j) * den(90)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(188),h0tab(:,188),[51,12],[0,0],2,2,wf16(:,10),wf4(:,2))
  call Hloop_CV_D(ntryL,G0H64(1),0,wf16(:,10),51,G1H4(11),m3h16x4(:,43),heltab2x64(:,:,176))
  Gcoeff(:)%j = (c(10)*M(2,:)%j+c(9)*(-M(1,:)%j-M(4,:)%j)+c(8)*M(6,:)%j) * den(90)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(189),h0tab(:,189),[51,12],[0,0],2,2,wf16(:,10),wf4(:,2))
  call Hloop_UV_W(ntryL,G0H64(1),0,wf16(:,10),51,G1H4(20),m3h16x4(:,44),heltab2x64(:,:,177))
  Gcoeff(:)%j = (-(c(36)*M(2,:)%j)+c(35)*(M(1,:)%j+M(4,:)%j)-c(33)*M(6,:)%j) * den(91)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(190),h0tab(:,190),[60,3],[0,0],2,2,wf16(:,13),wf4(:,1))
  call Hloop_QV_A(ntryL,G0H64(1),wf16(:,13),G0H4(3),m3h16x4(:,45),heltab2x64(:,:,178))
  call Hloop_Q_A(ntryL,G0H4(3),60,0,G1H4(13),n2h4(82))
  Gcoeff(:)%j = (-(c(32)*M(2,:)%j)+c(31)*(M(1,:)%j+M(4,:)%j)-c(29)*M(6,:)%j) * den(91)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(191),h0tab(:,191),[60,3],[nMT,nMT],2,2,wf16(:,13),wf4(:,1))
  call Hloop_QV_A(ntryL,G0H64(1),wf16(:,13),G0H4(3),m3h16x4(:,46),heltab2x64(:,:,179))
  call Hloop_Q_A(ntryL,G0H4(3),60,nMT,G1H4(28),n2h4(83))
  Gcoeff(:)%j = (-(c(36)*M(2,:)%j)+c(35)*(M(1,:)%j+M(4,:)%j)-c(33)*M(6,:)%j) * den(91)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(192),h0tab(:,192),[60,3],[0,0],2,2,wf16(:,13),wf4(:,1))
  call Hloop_QV_A(ntryL,G0H64(1),wf16(:,13),G0H4(3),m3h16x4(:,47),heltab2x64(:,:,180))
  call Hloop_Q_A(ntryL,G0H4(3),60,0,G1H4(27),n2h4(84))
  Gcoeff(:)%j = (-(c(32)*M(2,:)%j)+c(31)*(M(1,:)%j+M(4,:)%j)-c(29)*M(6,:)%j) * den(91)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(193),h0tab(:,193),[60,3],[nMB,nMB],2,2,wf16(:,13),wf4(:,1))
  call Hloop_QV_A(ntryL,G0H64(1),wf16(:,13),G0H4(3),m3h16x4(:,48),heltab2x64(:,:,181))
  call Hloop_Q_A(ntryL,G0H4(3),60,nMB,G1H4(7),n2h4(85))
  Gcoeff(:)%j = (-(c(26)*M(2,:)%j)+c(22)*(M(1,:)%j+M(4,:)%j)-c(17)*M(6,:)%j) * den(91)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(194),h0tab(:,194),[60,3],[0,0],2,2,wf16(:,13),wf4(:,1))
  call Hloop_CV_D(ntryL,G0H64(1),0,wf16(:,13),60,G1H4(10),m3h16x4(:,49),heltab2x64(:,:,182))
  Gcoeff(:)%j = (c(10)*M(2,:)%j+c(9)*(-M(1,:)%j-M(4,:)%j)+c(8)*M(6,:)%j) * den(91)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(195),h0tab(:,195),[60,3],[0,0],2,2,wf16(:,13),wf4(:,1))
  call Hloop_UV_W(ntryL,G0H64(1),0,wf16(:,13),60,G1H4(2),m3h16x4(:,50),heltab2x64(:,:,183))
  Gcoeff(:)%j = (-(c(36)*M(3,:)%j)+c(35)*(M(1,:)%j+M(4,:)%j)-c(33)*M(6,:)%j) * den(92)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(196),h0tab(:,196),[60,3],[0,0],2,2,wf16(:,14),wf4(:,1))
  call Hloop_QV_A(ntryL,G0H64(1),wf16(:,14),G0H4(3),m3h16x4(:,51),heltab2x64(:,:,184))
  call Hloop_Q_A(ntryL,G0H4(3),60,0,G1H4(35),n2h4(86))
  Gcoeff(:)%j = (-(c(32)*M(3,:)%j)+c(31)*(M(1,:)%j+M(4,:)%j)-c(29)*M(6,:)%j) * den(92)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(197),h0tab(:,197),[60,3],[nMT,nMT],2,2,wf16(:,14),wf4(:,1))
  call Hloop_QV_A(ntryL,G0H64(1),wf16(:,14),G0H4(3),m3h16x4(:,52),heltab2x64(:,:,185))
  call Hloop_Q_A(ntryL,G0H4(3),60,nMT,G1H4(23),n2h4(87))
  Gcoeff(:)%j = (-(c(36)*M(3,:)%j)+c(35)*(M(1,:)%j+M(4,:)%j)-c(33)*M(6,:)%j) * den(92)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(198),h0tab(:,198),[60,3],[0,0],2,2,wf16(:,14),wf4(:,1))
  call Hloop_QV_A(ntryL,G0H64(1),wf16(:,14),G0H4(3),m3h16x4(:,53),heltab2x64(:,:,186))
  call Hloop_Q_A(ntryL,G0H4(3),60,0,G1H4(24),n2h4(88))
  Gcoeff(:)%j = (-(c(32)*M(3,:)%j)+c(31)*(M(1,:)%j+M(4,:)%j)-c(29)*M(6,:)%j) * den(92)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(199),h0tab(:,199),[60,3],[nMB,nMB],2,2,wf16(:,14),wf4(:,1))
  call Hloop_QV_A(ntryL,G0H64(1),wf16(:,14),G0H4(3),m3h16x4(:,54),heltab2x64(:,:,187))
  call Hloop_Q_A(ntryL,G0H4(3),60,nMB,G1H4(9),n2h4(89))
  Gcoeff(:)%j = (-(c(26)*M(3,:)%j)+c(22)*(M(1,:)%j+M(4,:)%j)-c(17)*M(6,:)%j) * den(92)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(200),h0tab(:,200),[60,3],[0,0],2,2,wf16(:,14),wf4(:,1))
  call Hloop_CV_D(ntryL,G0H64(1),0,wf16(:,14),60,G1H4(29),m3h16x4(:,55),heltab2x64(:,:,188))
  Gcoeff(:)%j = (c(10)*M(3,:)%j+c(9)*(-M(1,:)%j-M(4,:)%j)+c(8)*M(6,:)%j) * den(92)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(201),h0tab(:,201),[60,3],[0,0],2,2,wf16(:,14),wf4(:,1))
  call Hloop_UV_W(ntryL,G0H64(1),0,wf16(:,14),60,G1H4(21),m3h16x4(:,56),heltab2x64(:,:,189))
  Gcoeff(:)%j = (-(c(36)*M(2,:)%j)+c(35)*(M(4,:)%j+M(5,:)%j)-c(33)*M(6,:)%j) * den(93)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(202),h0tab(:,202),[48,15],[0,0],2,2,wf4(:,3),wf16(:,7))
  call Hloop_QV_A(ntryL,G0H64(1),wf4(:,3),G0H16(1),m3h4x16(:,49),heltab2x64(:,:,190))
  call Hloop_Q_A(ntryL,G0H16(1),48,0,G1H16(12),n2h16(53))
  Gcoeff(:)%j = (-(c(32)*M(2,:)%j)+c(31)*(M(4,:)%j+M(5,:)%j)-c(29)*M(6,:)%j) * den(93)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(203),h0tab(:,203),[48,15],[nMT,nMT],2,2,wf4(:,3),wf16(:,7))
  call Hloop_QV_A(ntryL,G0H64(1),wf4(:,3),G0H16(1),m3h4x16(:,50),heltab2x64(:,:,191))
  call Hloop_Q_A(ntryL,G0H16(1),48,nMT,G1H16(13),n2h16(54))
  Gcoeff(:)%j = (-(c(36)*M(2,:)%j)+c(35)*(M(4,:)%j+M(5,:)%j)-c(33)*M(6,:)%j) * den(93)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(204),h0tab(:,204),[48,15],[0,0],2,2,wf4(:,3),wf16(:,7))
  call Hloop_QV_A(ntryL,G0H64(1),wf4(:,3),G0H16(1),m3h4x16(:,51),heltab2x64(:,:,192))
  call Hloop_Q_A(ntryL,G0H16(1),48,0,G1H16(14),n2h16(55))
  Gcoeff(:)%j = (-(c(32)*M(2,:)%j)+c(31)*(M(4,:)%j+M(5,:)%j)-c(29)*M(6,:)%j) * den(93)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(205),h0tab(:,205),[48,15],[nMB,nMB],2,2,wf4(:,3),wf16(:,7))
  call Hloop_QV_A(ntryL,G0H64(1),wf4(:,3),G0H16(1),m3h4x16(:,52),heltab2x64(:,:,193))
  call Hloop_Q_A(ntryL,G0H16(1),48,nMB,G1H16(15),n2h16(56))
  Gcoeff(:)%j = (-(c(26)*M(2,:)%j)+c(22)*(M(4,:)%j+M(5,:)%j)-c(17)*M(6,:)%j) * den(93)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(206),h0tab(:,206),[48,15],[0,0],2,2,wf4(:,3),wf16(:,7))
  call Hloop_CV_D(ntryL,G0H64(1),0,wf4(:,3),48,G1H16(16),m3h4x16(:,53),heltab2x64(:,:,194))
  Gcoeff(:)%j = (c(10)*M(2,:)%j+c(9)*(-M(4,:)%j-M(5,:)%j)+c(8)*M(6,:)%j) * den(93)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(207),h0tab(:,207),[48,15],[0,0],2,2,wf4(:,3),wf16(:,7))
  call Hloop_UV_W(ntryL,G0H64(1),0,wf4(:,3),48,G1H16(17),m3h4x16(:,54),heltab2x64(:,:,195))
  Gcoeff(:)%j = (c(24)*M(2,:)%j+c(19)*(-M(4,:)%j-M(5,:)%j)+c(14)*M(6,:)%j) * den(63)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(208),h0tab(:,208),[56,7],[nMT,0],2,2,wf8(:,33),wf8(:,9))
  call Hloop_VA_Q(ntryL,G0H64(1),wf8(:,33),G0H8(2),m3h8x8(:,27),heltab2x64(:,:,196))
  call Hloop_A_Q(ntryL,G0H8(2),56,nMT,G1H8(11),n2h8(35))
  Gcoeff(:)%j = (-(c(36)*M(3,:)%j)+c(35)*(M(4,:)%j+M(5,:)%j)-c(33)*M(6,:)%j) * den(94)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(209),h0tab(:,209),[48,15],[0,0],2,2,wf4(:,3),wf16(:,8))
  call Hloop_QV_A(ntryL,G0H64(1),wf4(:,3),G0H16(1),m3h4x16(:,55),heltab2x64(:,:,197))
  call Hloop_Q_A(ntryL,G0H16(1),48,0,G1H16(18),n2h16(57))
  Gcoeff(:)%j = (-(c(32)*M(3,:)%j)+c(31)*(M(4,:)%j+M(5,:)%j)-c(29)*M(6,:)%j) * den(94)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(210),h0tab(:,210),[48,15],[nMT,nMT],2,2,wf4(:,3),wf16(:,8))
  call Hloop_QV_A(ntryL,G0H64(1),wf4(:,3),G0H16(1),m3h4x16(:,56),heltab2x64(:,:,198))
  call Hloop_Q_A(ntryL,G0H16(1),48,nMT,G1H16(1),n2h16(58))
  Gcoeff(:)%j = (-(c(36)*M(3,:)%j)+c(35)*(M(4,:)%j+M(5,:)%j)-c(33)*M(6,:)%j) * den(94)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(211),h0tab(:,211),[48,15],[0,0],2,2,wf4(:,3),wf16(:,8))
  call Hloop_QV_A(ntryL,G0H64(1),wf4(:,3),G0H16(1),m3h4x16(:,57),heltab2x64(:,:,199))
  call Hloop_Q_A(ntryL,G0H16(1),48,0,G1H16(2),n2h16(59))
  Gcoeff(:)%j = (-(c(32)*M(3,:)%j)+c(31)*(M(4,:)%j+M(5,:)%j)-c(29)*M(6,:)%j) * den(94)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(212),h0tab(:,212),[48,15],[nMB,nMB],2,2,wf4(:,3),wf16(:,8))
  call Hloop_QV_A(ntryL,G0H64(1),wf4(:,3),G0H16(1),m3h4x16(:,58),heltab2x64(:,:,200))
  call Hloop_Q_A(ntryL,G0H16(1),48,nMB,G1H16(19),n2h16(60))
  Gcoeff(:)%j = (-(c(26)*M(3,:)%j)+c(22)*(M(4,:)%j+M(5,:)%j)-c(17)*M(6,:)%j) * den(94)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(213),h0tab(:,213),[48,15],[0,0],2,2,wf4(:,3),wf16(:,8))
  call Hloop_CV_D(ntryL,G0H64(1),0,wf4(:,3),48,G1H16(20),m3h4x16(:,59),heltab2x64(:,:,201))
  Gcoeff(:)%j = (c(10)*M(3,:)%j+c(9)*(-M(4,:)%j-M(5,:)%j)+c(8)*M(6,:)%j) * den(94)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(214),h0tab(:,214),[48,15],[0,0],2,2,wf4(:,3),wf16(:,8))
  call Hloop_UV_W(ntryL,G0H64(1),0,wf4(:,3),48,G1H16(21),m3h4x16(:,60),heltab2x64(:,:,202))
  Gcoeff(:)%j = (c(24)*M(3,:)%j+c(19)*(-M(4,:)%j-M(5,:)%j)+c(14)*M(6,:)%j) * den(64)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(215),h0tab(:,215),[52,11],[0,nMT],2,2,wf8(:,12),wf8(:,31))
  call Hloop_AQ_V(ntryL,G0H64(1),wf8(:,12),G0H8(4),m3h8x8(:,28),heltab2x64(:,:,203))
  Gcoeff(:)%j = (-(c(36)*M(3,:)%j)+c(35)*(M(4,:)%j+M(5,:)%j)-c(33)*M(6,:)%j) * den(95)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(216),h0tab(:,216),[60,3],[0,0],2,2,wf16(:,17),wf4(:,1))
  call Hloop_QV_A(ntryL,G0H64(1),wf16(:,17),G0H4(3),m3h16x4(:,57),heltab2x64(:,:,204))
  call Hloop_Q_A(ntryL,G0H4(3),60,0,G1H4(16),n2h4(90))
  Gcoeff(:)%j = (-(c(32)*M(3,:)%j)+c(31)*(M(4,:)%j+M(5,:)%j)-c(29)*M(6,:)%j) * den(95)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(217),h0tab(:,217),[60,3],[nMT,nMT],2,2,wf16(:,17),wf4(:,1))
  call Hloop_QV_A(ntryL,G0H64(1),wf16(:,17),G0H4(3),m3h16x4(:,58),heltab2x64(:,:,205))
  call Hloop_Q_A(ntryL,G0H4(3),60,nMT,G1H4(18),n2h4(91))
  Gcoeff(:)%j = (-(c(36)*M(3,:)%j)+c(35)*(M(4,:)%j+M(5,:)%j)-c(33)*M(6,:)%j) * den(95)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(218),h0tab(:,218),[60,3],[0,0],2,2,wf16(:,17),wf4(:,1))
  call Hloop_QV_A(ntryL,G0H64(1),wf16(:,17),G0H4(3),m3h16x4(:,59),heltab2x64(:,:,206))
  call Hloop_Q_A(ntryL,G0H4(3),60,0,G1H4(39),n2h4(92))
  Gcoeff(:)%j = (-(c(32)*M(3,:)%j)+c(31)*(M(4,:)%j+M(5,:)%j)-c(29)*M(6,:)%j) * den(95)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(219),h0tab(:,219),[60,3],[nMB,nMB],2,2,wf16(:,17),wf4(:,1))
  call Hloop_QV_A(ntryL,G0H64(1),wf16(:,17),G0H4(3),m3h16x4(:,60),heltab2x64(:,:,207))
  call Hloop_Q_A(ntryL,G0H4(3),60,nMB,G1H4(40),n2h4(93))
  Gcoeff(:)%j = (-(c(26)*M(3,:)%j)+c(22)*(M(4,:)%j+M(5,:)%j)-c(17)*M(6,:)%j) * den(95)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(220),h0tab(:,220),[60,3],[0,0],2,2,wf16(:,17),wf4(:,1))
  call Hloop_CV_D(ntryL,G0H64(1),0,wf16(:,17),60,G1H4(41),m3h16x4(:,61),heltab2x64(:,:,208))
  Gcoeff(:)%j = (c(10)*M(3,:)%j+c(9)*(-M(4,:)%j-M(5,:)%j)+c(8)*M(6,:)%j) * den(95)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(221),h0tab(:,221),[60,3],[0,0],2,2,wf16(:,17),wf4(:,1))
  call Hloop_UV_W(ntryL,G0H64(1),0,wf16(:,17),60,G1H4(42),m3h16x4(:,62),heltab2x64(:,:,209))
  Gcoeff(:)%j = (-(c(36)*M(2,:)%j)+c(35)*(M(4,:)%j+M(5,:)%j)-c(33)*M(6,:)%j) * den(96)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(222),h0tab(:,222),[60,3],[0,0],2,2,wf16(:,18),wf4(:,1))
  call Hloop_QV_A(ntryL,G0H64(1),wf16(:,18),G0H4(3),m3h16x4(:,63),heltab2x64(:,:,210))
  call Hloop_Q_A(ntryL,G0H4(3),60,0,G1H4(43),n2h4(94))
  Gcoeff(:)%j = (-(c(32)*M(2,:)%j)+c(31)*(M(4,:)%j+M(5,:)%j)-c(29)*M(6,:)%j) * den(96)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(223),h0tab(:,223),[60,3],[nMT,nMT],2,2,wf16(:,18),wf4(:,1))
  call Hloop_QV_A(ntryL,G0H64(1),wf16(:,18),G0H4(3),m3h16x4(:,64),heltab2x64(:,:,211))
  call Hloop_Q_A(ntryL,G0H4(3),60,nMT,G1H4(44),n2h4(95))
  Gcoeff(:)%j = (-(c(36)*M(2,:)%j)+c(35)*(M(4,:)%j+M(5,:)%j)-c(33)*M(6,:)%j) * den(96)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(224),h0tab(:,224),[60,3],[0,0],2,2,wf16(:,18),wf4(:,1))
  call Hloop_QV_A(ntryL,G0H64(1),wf16(:,18),G0H4(3),m3h16x4(:,65),heltab2x64(:,:,212))
  call Hloop_Q_A(ntryL,G0H4(3),60,0,G1H4(45),n2h4(96))
  Gcoeff(:)%j = (-(c(32)*M(2,:)%j)+c(31)*(M(4,:)%j+M(5,:)%j)-c(29)*M(6,:)%j) * den(96)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(225),h0tab(:,225),[60,3],[nMB,nMB],2,2,wf16(:,18),wf4(:,1))
  call Hloop_QV_A(ntryL,G0H64(1),wf16(:,18),G0H4(3),m3h16x4(:,66),heltab2x64(:,:,213))
  call Hloop_Q_A(ntryL,G0H4(3),60,nMB,G1H4(46),n2h4(97))
  Gcoeff(:)%j = (-(c(26)*M(2,:)%j)+c(22)*(M(4,:)%j+M(5,:)%j)-c(17)*M(6,:)%j) * den(96)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(226),h0tab(:,226),[60,3],[0,0],2,2,wf16(:,18),wf4(:,1))
  call Hloop_CV_D(ntryL,G0H64(1),0,wf16(:,18),60,G1H4(47),m3h16x4(:,67),heltab2x64(:,:,214))
  Gcoeff(:)%j = (c(10)*M(2,:)%j+c(9)*(-M(4,:)%j-M(5,:)%j)+c(8)*M(6,:)%j) * den(96)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(227),h0tab(:,227),[60,3],[0,0],2,2,wf16(:,18),wf4(:,1))
  call Hloop_UV_W(ntryL,G0H64(1),0,wf16(:,18),60,G1H4(48),m3h16x4(:,68),heltab2x64(:,:,215))
  Gcoeff(:)%j = (-(c(36)*M(3,:)%j)+c(35)*(M(1,:)%j+M(5,:)%j)-c(33)*M(6,:)%j) * den(97)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(228),h0tab(:,228),[48,15],[0,0],2,2,wf4(:,3),wf16(:,11))
  call Hloop_QV_A(ntryL,G0H64(1),wf4(:,3),G0H16(1),m3h4x16(:,61),heltab2x64(:,:,216))
  call Hloop_Q_A(ntryL,G0H16(1),48,0,G1H16(22),n2h16(61))
  Gcoeff(:)%j = (-(c(32)*M(3,:)%j)+c(31)*(M(1,:)%j+M(5,:)%j)-c(29)*M(6,:)%j) * den(97)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(229),h0tab(:,229),[48,15],[nMT,nMT],2,2,wf4(:,3),wf16(:,11))
  call Hloop_QV_A(ntryL,G0H64(1),wf4(:,3),G0H16(1),m3h4x16(:,62),heltab2x64(:,:,217))
  call Hloop_Q_A(ntryL,G0H16(1),48,nMT,G1H16(23),n2h16(62))
  Gcoeff(:)%j = (-(c(36)*M(3,:)%j)+c(35)*(M(1,:)%j+M(5,:)%j)-c(33)*M(6,:)%j) * den(97)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(230),h0tab(:,230),[48,15],[0,0],2,2,wf4(:,3),wf16(:,11))
  call Hloop_QV_A(ntryL,G0H64(1),wf4(:,3),G0H16(1),m3h4x16(:,63),heltab2x64(:,:,218))
  call Hloop_Q_A(ntryL,G0H16(1),48,0,G1H16(24),n2h16(63))
  Gcoeff(:)%j = (-(c(32)*M(3,:)%j)+c(31)*(M(1,:)%j+M(5,:)%j)-c(29)*M(6,:)%j) * den(97)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(231),h0tab(:,231),[48,15],[nMB,nMB],2,2,wf4(:,3),wf16(:,11))
  call Hloop_QV_A(ntryL,G0H64(1),wf4(:,3),G0H16(1),m3h4x16(:,64),heltab2x64(:,:,219))
  call Hloop_Q_A(ntryL,G0H16(1),48,nMB,G1H16(25),n2h16(64))
  Gcoeff(:)%j = (-(c(26)*M(3,:)%j)+c(22)*(M(1,:)%j+M(5,:)%j)-c(17)*M(6,:)%j) * den(97)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(232),h0tab(:,232),[48,15],[0,0],2,2,wf4(:,3),wf16(:,11))
  call Hloop_CV_D(ntryL,G0H64(1),0,wf4(:,3),48,G1H16(26),m3h4x16(:,65),heltab2x64(:,:,220))
  Gcoeff(:)%j = (c(10)*M(3,:)%j+c(9)*(-M(1,:)%j-M(5,:)%j)+c(8)*M(6,:)%j) * den(97)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(233),h0tab(:,233),[48,15],[0,0],2,2,wf4(:,3),wf16(:,11))
  call Hloop_UV_W(ntryL,G0H64(1),0,wf4(:,3),48,G1H16(27),m3h4x16(:,66),heltab2x64(:,:,221))
  Gcoeff(:)%j = (-(c(36)*M(2,:)%j)+c(35)*(M(1,:)%j+M(5,:)%j)-c(33)*M(6,:)%j) * den(98)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(234),h0tab(:,234),[51,12],[0,0],2,2,wf16(:,15),wf4(:,2))
  call Hloop_QV_A(ntryL,G0H64(1),wf16(:,15),G0H4(3),m3h16x4(:,69),heltab2x64(:,:,222))
  call Hloop_Q_A(ntryL,G0H4(3),51,0,G1H4(49),n2h4(98))
  Gcoeff(:)%j = (-(c(32)*M(2,:)%j)+c(31)*(M(1,:)%j+M(5,:)%j)-c(29)*M(6,:)%j) * den(98)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(235),h0tab(:,235),[51,12],[nMT,nMT],2,2,wf16(:,15),wf4(:,2))
  call Hloop_QV_A(ntryL,G0H64(1),wf16(:,15),G0H4(3),m3h16x4(:,70),heltab2x64(:,:,223))
  call Hloop_Q_A(ntryL,G0H4(3),51,nMT,G1H4(50),n2h4(99))
  Gcoeff(:)%j = (-(c(36)*M(2,:)%j)+c(35)*(M(1,:)%j+M(5,:)%j)-c(33)*M(6,:)%j) * den(98)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(236),h0tab(:,236),[51,12],[0,0],2,2,wf16(:,15),wf4(:,2))
  call Hloop_QV_A(ntryL,G0H64(1),wf16(:,15),G0H4(3),m3h16x4(:,71),heltab2x64(:,:,224))
  call Hloop_Q_A(ntryL,G0H4(3),51,0,G1H4(51),n2h4(100))
  Gcoeff(:)%j = (-(c(32)*M(2,:)%j)+c(31)*(M(1,:)%j+M(5,:)%j)-c(29)*M(6,:)%j) * den(98)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(237),h0tab(:,237),[51,12],[nMB,nMB],2,2,wf16(:,15),wf4(:,2))
  call Hloop_QV_A(ntryL,G0H64(1),wf16(:,15),G0H4(3),m3h16x4(:,72),heltab2x64(:,:,225))
  call Hloop_Q_A(ntryL,G0H4(3),51,nMB,G1H4(52),n2h4(101))
  Gcoeff(:)%j = (-(c(26)*M(2,:)%j)+c(22)*(M(1,:)%j+M(5,:)%j)-c(17)*M(6,:)%j) * den(98)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(238),h0tab(:,238),[51,12],[0,0],2,2,wf16(:,15),wf4(:,2))
  call Hloop_CV_D(ntryL,G0H64(1),0,wf16(:,15),51,G1H4(53),m3h16x4(:,73),heltab2x64(:,:,226))
  Gcoeff(:)%j = (c(10)*M(2,:)%j+c(9)*(-M(1,:)%j-M(5,:)%j)+c(8)*M(6,:)%j) * den(98)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(239),h0tab(:,239),[51,12],[0,0],2,2,wf16(:,15),wf4(:,2))
  call Hloop_UV_W(ntryL,G0H64(1),0,wf16(:,15),51,G1H4(54),m3h16x4(:,74),heltab2x64(:,:,227))
  Gcoeff(:)%j = (-(c(36)*M(2,:)%j)+c(35)*(M(1,:)%j+M(5,:)%j)-c(33)*M(6,:)%j) * den(99)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(240),h0tab(:,240),[48,15],[0,0],2,2,wf4(:,3),wf16(:,12))
  call Hloop_QV_A(ntryL,G0H64(1),wf4(:,3),G0H16(1),m3h4x16(:,67),heltab2x64(:,:,228))
  call Hloop_Q_A(ntryL,G0H16(1),48,0,G1H16(28),n2h16(65))
  Gcoeff(:)%j = (-(c(32)*M(2,:)%j)+c(31)*(M(1,:)%j+M(5,:)%j)-c(29)*M(6,:)%j) * den(99)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(241),h0tab(:,241),[48,15],[nMT,nMT],2,2,wf4(:,3),wf16(:,12))
  call Hloop_QV_A(ntryL,G0H64(1),wf4(:,3),G0H16(1),m3h4x16(:,68),heltab2x64(:,:,229))
  call Hloop_Q_A(ntryL,G0H16(1),48,nMT,G1H16(29),n2h16(66))
  Gcoeff(:)%j = (-(c(36)*M(2,:)%j)+c(35)*(M(1,:)%j+M(5,:)%j)-c(33)*M(6,:)%j) * den(99)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(242),h0tab(:,242),[48,15],[0,0],2,2,wf4(:,3),wf16(:,12))
  call Hloop_QV_A(ntryL,G0H64(1),wf4(:,3),G0H16(1),m3h4x16(:,69),heltab2x64(:,:,230))
  call Hloop_Q_A(ntryL,G0H16(1),48,0,G1H16(30),n2h16(67))
  Gcoeff(:)%j = (-(c(32)*M(2,:)%j)+c(31)*(M(1,:)%j+M(5,:)%j)-c(29)*M(6,:)%j) * den(99)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(243),h0tab(:,243),[48,15],[nMB,nMB],2,2,wf4(:,3),wf16(:,12))
  call Hloop_QV_A(ntryL,G0H64(1),wf4(:,3),G0H16(1),m3h4x16(:,70),heltab2x64(:,:,231))
  call Hloop_Q_A(ntryL,G0H16(1),48,nMB,G1H16(31),n2h16(68))
  Gcoeff(:)%j = (-(c(26)*M(2,:)%j)+c(22)*(M(1,:)%j+M(5,:)%j)-c(17)*M(6,:)%j) * den(99)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(244),h0tab(:,244),[48,15],[0,0],2,2,wf4(:,3),wf16(:,12))
  call Hloop_CV_D(ntryL,G0H64(1),0,wf4(:,3),48,G1H16(32),m3h4x16(:,71),heltab2x64(:,:,232))
  Gcoeff(:)%j = (c(10)*M(2,:)%j+c(9)*(-M(1,:)%j-M(5,:)%j)+c(8)*M(6,:)%j) * den(99)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(245),h0tab(:,245),[48,15],[0,0],2,2,wf4(:,3),wf16(:,12))
  call Hloop_UV_W(ntryL,G0H64(1),0,wf4(:,3),48,G1H16(33),m3h4x16(:,72),heltab2x64(:,:,233))
  Gcoeff(:)%j = (-(c(36)*M(3,:)%j)+c(35)*(M(1,:)%j+M(5,:)%j)-c(33)*M(6,:)%j) * den(100)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(246),h0tab(:,246),[51,12],[0,0],2,2,wf16(:,16),wf4(:,2))
  call Hloop_QV_A(ntryL,G0H64(1),wf16(:,16),G0H4(3),m3h16x4(:,75),heltab2x64(:,:,234))
  call Hloop_Q_A(ntryL,G0H4(3),51,0,G1H4(55),n2h4(102))
  Gcoeff(:)%j = (-(c(32)*M(3,:)%j)+c(31)*(M(1,:)%j+M(5,:)%j)-c(29)*M(6,:)%j) * den(100)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(247),h0tab(:,247),[51,12],[nMT,nMT],2,2,wf16(:,16),wf4(:,2))
  call Hloop_QV_A(ntryL,G0H64(1),wf16(:,16),G0H4(3),m3h16x4(:,76),heltab2x64(:,:,235))
  call Hloop_Q_A(ntryL,G0H4(3),51,nMT,G1H4(56),n2h4(103))
  Gcoeff(:)%j = (-(c(36)*M(3,:)%j)+c(35)*(M(1,:)%j+M(5,:)%j)-c(33)*M(6,:)%j) * den(100)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(248),h0tab(:,248),[51,12],[0,0],2,2,wf16(:,16),wf4(:,2))
  call Hloop_QV_A(ntryL,G0H64(1),wf16(:,16),G0H4(3),m3h16x4(:,77),heltab2x64(:,:,236))
  call Hloop_Q_A(ntryL,G0H4(3),51,0,G1H4(57),n2h4(104))
  Gcoeff(:)%j = (-(c(32)*M(3,:)%j)+c(31)*(M(1,:)%j+M(5,:)%j)-c(29)*M(6,:)%j) * den(100)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(249),h0tab(:,249),[51,12],[nMB,nMB],2,2,wf16(:,16),wf4(:,2))
  call Hloop_QV_A(ntryL,G0H64(1),wf16(:,16),G0H4(3),m3h16x4(:,78),heltab2x64(:,:,237))
  call Hloop_Q_A(ntryL,G0H4(3),51,nMB,G1H4(58),n2h4(105))
  Gcoeff(:)%j = (-(c(26)*M(3,:)%j)+c(22)*(M(1,:)%j+M(5,:)%j)-c(17)*M(6,:)%j) * den(100)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(250),h0tab(:,250),[51,12],[0,0],2,2,wf16(:,16),wf4(:,2))
  call Hloop_CV_D(ntryL,G0H64(1),0,wf16(:,16),51,G1H4(59),m3h16x4(:,79),heltab2x64(:,:,238))
  Gcoeff(:)%j = (c(10)*M(3,:)%j+c(9)*(-M(1,:)%j-M(5,:)%j)+c(8)*M(6,:)%j) * den(100)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(251),h0tab(:,251),[51,12],[0,0],2,2,wf16(:,16),wf4(:,2))
  call Hloop_UV_W(ntryL,G0H64(1),0,wf16(:,16),51,G1H4(60),m3h16x4(:,80),heltab2x64(:,:,239))
  Gcoeff(:)%j = (c(24)*M(3,:)%j+c(19)*(-M(1,:)%j-M(5,:)%j)+c(14)*M(6,:)%j) * den(68)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(252),h0tab(:,252),[50,13],[0,0],2,2,wf8(:,46),wf8(:,15))
  call Hloop_VA_Q(ntryL,G0H64(1),wf8(:,46),G0H8(6),m3h8x8(:,29),heltab2x64(:,:,240))
  call Hloop_A_Q(ntryL,G0H8(6),50,0,G1H8(24),n2h8(36))
  Gcoeff(:)%j = (c(24)*M(2,:)%j+c(19)*(-M(1,:)%j-M(5,:)%j)+c(14)*M(6,:)%j) * den(69)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(253),h0tab(:,253),[49,14],[0,0],2,2,wf8(:,18),wf8(:,48))
  call Hloop_AQ_V(ntryL,G0H64(1),wf8(:,18),G0H8(8),m3h8x8(:,30),heltab2x64(:,:,241))
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(48),[G1H4(42),G1H4(21),G1H4(2),G1H4(30),G0H4(6),G0H4(1) &
    ,G0H4(2)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(60),[G1H4(54),G1H4(20),G1H4(37),G1H4(12),G0H4(7),G0H4(4) &
    ,G0H4(5)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H16(6),[G1H16(4)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(57),[G1H4(55),G1H4(51),G1H4(49),G1H4(8),G1H4(33),G1H4(15) &
    ,G1H4(26),G1H4(36),G1H4(4)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(56),[G1H4(50),G1H4(1),G1H4(3),G1H4(25)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(58),[G1H4(52),G1H4(32),G1H4(17),G1H4(5)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(59),[G1H4(53),G1H4(11),G1H4(14),G1H4(19)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(45),[G1H4(43),G1H4(39),G1H4(16),G1H4(24),G1H4(35) &
    ,G1H4(27),G1H4(13),G1H4(22),G1H4(31)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(44),[G1H4(18),G1H4(23),G1H4(28),G1H4(6)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(46),[G1H4(40),G1H4(9),G1H4(7),G1H4(38)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(47),[G1H4(41),G1H4(29),G1H4(10),G1H4(34)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H16(14),[G1H16(12)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H16(2),[G1H16(18)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H16(24),[G1H16(22)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H16(30),[G1H16(28)])
  call Hcheck_last_UV_W(ntryL,l_switch,G1H4(48),60,wf4(:,1),3,G2tensor(95),m3h4x1(:,48),heltab2x4(:,:,127))
  call Hcheck_last_UV_W(ntryL,l_switch,G1H4(60),51,wf4(:,2),12,G2tensor(62),m3h4x1(:,49),heltab2x4(:,:,128))
  call Hcheck_last_GGG_G_12(ntryL,l_switch,G1H16(3),wf4(:,1),wf4(:,2),G1tensor(1),m4h4x4x1(:,1),heltab3x16(:,:,1))
  call Hcheck_last_GGG_G_12(ntryL,l_switch,G1H16(5),wf4(:,2),wf4(:,1),G1tensor(36),m4h4x4x1(:,2),heltab3x16(:,:,2))
  call Hcheck_last_GGG_G_23(ntryL,l_switch,G1H16(7),wf4(:,1),wf4(:,2),G1tensor(61),m4h4x4x1(:,3),heltab3x16(:,:,3))
  call Hloop_QV_A(ntryL,G1H16(6),wf16(:,1),G1H1(1),m3h16x1(:,1),heltab2x16(:,:,64))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(63),n2h1(186))
  call Hloop_QV_A(ntryL,G1H16(9),wf16(:,1),G1H1(1),m3h16x1(:,2),heltab2x16(:,:,65))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,nMT,G2tensor(105),n2h1(187))
  call Hloop_QV_A(ntryL,G1H16(8),wf16(:,1),G1H1(1),m3h16x1(:,3),heltab2x16(:,:,66))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,nMB,G2tensor(66),n2h1(188))
  call Hcheck_last_CV_D(ntryL,l_switch,G1H16(10),48,wf16(:,1),15,G2tensor(52),m3h16x1(:,4),heltab2x16(:,:,67))
  call Hcheck_last_UV_W(ntryL,l_switch,G1H16(11),48,wf16(:,1),15,G2tensor(1),m3h16x1(:,5),heltab2x16(:,:,68))
  call Hloop_QV_A(ntryL,G1H4(57),wf4(:,2),G1H1(1),m3h4x1(:,50),heltab2x4(:,:,129))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(74),n2h1(189))
  call Hloop_QV_A(ntryL,G1H4(56),wf4(:,2),G1H1(1),m3h4x1(:,51),heltab2x4(:,:,130))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,nMT,G2tensor(75),n2h1(190))
  call Hloop_QV_A(ntryL,G1H4(58),wf4(:,2),G1H1(1),m3h4x1(:,52),heltab2x4(:,:,131))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,nMB,G2tensor(121),n2h1(191))
  call Hcheck_last_CV_D(ntryL,l_switch,G1H4(59),51,wf4(:,2),12,G2tensor(78),m3h4x1(:,53),heltab2x4(:,:,132))
  call Hloop_QV_A(ntryL,G1H4(45),wf4(:,1),G1H1(1),m3h4x1(:,54),heltab2x4(:,:,133))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(80),n2h1(192))
  call Hloop_QV_A(ntryL,G1H4(44),wf4(:,1),G1H1(1),m3h4x1(:,55),heltab2x4(:,:,134))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,nMT,G2tensor(81),n2h1(193))
  call Hloop_QV_A(ntryL,G1H4(46),wf4(:,1),G1H1(1),m3h4x1(:,56),heltab2x4(:,:,135))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,nMB,G2tensor(83),n2h1(194))
  call Hcheck_last_CV_D(ntryL,l_switch,G1H4(47),60,wf4(:,1),3,G2tensor(84),m3h4x1(:,57),heltab2x4(:,:,136))
  call Hcheck_last_AQ_V(ntryL,l_switch,G1H8(9),wf8(:,3),G1tensor(91),m3h8x1(:,15),heltab2x8(:,:,94))
  call Hcheck_last_AQ_V(ntryL,l_switch,G1H8(20),wf8(:,6),G1tensor(121),m3h8x1(:,16),heltab2x8(:,:,95))
  call Hloop_QV_A(ntryL,G1H16(14),wf16(:,7),G1H1(1),m3h16x1(:,6),heltab2x16(:,:,69))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(85),n2h1(195))
  call Hloop_QV_A(ntryL,G1H16(13),wf16(:,7),G1H1(1),m3h16x1(:,7),heltab2x16(:,:,70))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,nMT,G2tensor(87),n2h1(196))
  call Hloop_QV_A(ntryL,G1H16(15),wf16(:,7),G1H1(1),m3h16x1(:,8),heltab2x16(:,:,71))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,nMB,G2tensor(88),n2h1(197))
  call Hcheck_last_CV_D(ntryL,l_switch,G1H16(16),48,wf16(:,7),15,G2tensor(90),m3h16x1(:,9),heltab2x16(:,:,72))
  call Hcheck_last_UV_W(ntryL,l_switch,G1H16(17),48,wf16(:,7),15,G2tensor(2),m3h16x1(:,10),heltab2x16(:,:,73))
  call Hcheck_last_AQ_V(ntryL,l_switch,G1H8(11),wf8(:,9),G1tensor(151),m3h8x1(:,17),heltab2x8(:,:,96))
  call Hloop_QV_A(ntryL,G1H16(2),wf16(:,8),G1H1(1),m3h16x1(:,11),heltab2x16(:,:,74))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(29),n2h1(198))
  call Hloop_QV_A(ntryL,G1H16(1),wf16(:,8),G1H1(1),m3h16x1(:,12),heltab2x16(:,:,75))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,nMT,G2tensor(6),n2h1(199))
  call Hloop_QV_A(ntryL,G1H16(19),wf16(:,8),G1H1(1),m3h16x1(:,13),heltab2x16(:,:,76))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,nMB,G2tensor(31),n2h1(200))
  call Hcheck_last_CV_D(ntryL,l_switch,G1H16(20),48,wf16(:,8),15,G2tensor(67),m3h16x1(:,14),heltab2x16(:,:,77))
  call Hcheck_last_UV_W(ntryL,l_switch,G1H16(21),48,wf16(:,8),15,G2tensor(61),m3h16x1(:,15),heltab2x16(:,:,78))
  call Hloop_VA_Q(ntryL,G0H8(4),wf8(:,31),G0H1(1),m3h8x1(:,18),heltab2x8(:,:,97))
  call Hcheck_last_A_Q(ntryL,l_switch,G0H1(1),63,nMT,G1tensor(181),n2h1(201))
  call Hloop_QV_A(ntryL,G1H16(24),wf16(:,11),G1H1(1),m3h16x1(:,16),heltab2x16(:,:,79))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(10),n2h1(202))
  call Hloop_QV_A(ntryL,G1H16(23),wf16(:,11),G1H1(1),m3h16x1(:,17),heltab2x16(:,:,80))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,nMT,G2tensor(91),n2h1(203))
  call Hloop_QV_A(ntryL,G1H16(25),wf16(:,11),G1H1(1),m3h16x1(:,18),heltab2x16(:,:,81))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,nMB,G2tensor(12),n2h1(204))
  call Hcheck_last_CV_D(ntryL,l_switch,G1H16(26),48,wf16(:,11),15,G2tensor(33),m3h16x1(:,19),heltab2x16(:,:,82))
  call Hcheck_last_UV_W(ntryL,l_switch,G1H16(27),48,wf16(:,11),15,G2tensor(92),m3h16x1(:,20),heltab2x16(:,:,83))
  call Hloop_QV_A(ntryL,G1H16(30),wf16(:,12),G1H1(1),m3h16x1(:,21),heltab2x16(:,:,84))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(35),n2h1(205))
  call Hloop_QV_A(ntryL,G1H16(29),wf16(:,12),G1H1(1),m3h16x1(:,22),heltab2x16(:,:,85))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,nMT,G2tensor(3),n2h1(206))
  call Hloop_QV_A(ntryL,G1H16(31),wf16(:,12),G1H1(1),m3h16x1(:,23),heltab2x16(:,:,86))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,nMB,G2tensor(37),n2h1(207))
  call Hcheck_last_CV_D(ntryL,l_switch,G1H16(32),48,wf16(:,12),15,G2tensor(109),m3h16x1(:,24),heltab2x16(:,:,87))
  call Hcheck_last_UV_W(ntryL,l_switch,G1H16(33),48,wf16(:,12),15,G2tensor(40),m3h16x1(:,25),heltab2x16(:,:,88))
  call Hcheck_last_AQ_V(ntryL,l_switch,G1H8(24),wf8(:,15),G1tensor(211),m3h8x1(:,19),heltab2x8(:,:,98))
  call Hloop_VA_Q(ntryL,G0H8(8),wf8(:,48),G0H1(1),m3h8x1(:,20),heltab2x8(:,:,99))
  call Hcheck_last_A_Q(ntryL,l_switch,G0H1(1),63,0,G1tensor(241),n2h1(208))
  call ol_merge_tensors(G2tensor(84),[G2tensor(80),G2tensor(95),G0tensor(233),G0tensor(235),G0tensor(528),G0tensor(536) &
    ,G0tensor(461),G0tensor(346),G0tensor(306),G0tensor(156),G0tensor(131),G0tensor(116),G0tensor(46),G0tensor(6)])
  call ol_merge_tensors(G2tensor(78),[G2tensor(74),G2tensor(62),G0tensor(284),G0tensor(269),G0tensor(197),G0tensor(483) &
    ,G0tensor(109),G0tensor(340),G0tensor(586),G0tensor(496),G0tensor(446),G0tensor(401),G0tensor(381),G0tensor(361),G0tensor(206) &
    ,G0tensor(111),G0tensor(26),G0tensor(11)])
  call ol_merge_tensors(G2tensor(40),[G2tensor(109),G2tensor(35),G2tensor(92),G2tensor(33),G2tensor(10),G2tensor(61),G2tensor(67) &
    ,G2tensor(29),G2tensor(2),G2tensor(90),G2tensor(85),G2tensor(1),G2tensor(52),G2tensor(63),G1tensor(61),G1tensor(36) &
    ,G1tensor(1),G0tensor(124),G0tensor(69),G0tensor(129),G0tensor(127),G0tensor(34),G0tensor(571),G0tensor(521),G0tensor(426) &
    ,G0tensor(326),G0tensor(121),G0tensor(101),G0tensor(76),G0tensor(16)])
  call ol_merge_tensors(G1tensor(91),[G0tensor(192),G0tensor(317),G0tensor(288),G0tensor(534),G0tensor(88),G0tensor(28) &
    ,G0tensor(376),G0tensor(141),G0tensor(31)])
  call ol_merge_tensors(G0tensor(267),[G0tensor(169),G0tensor(222),G0tensor(309),G0tensor(579),G0tensor(255),G0tensor(18) &
    ,G0tensor(195),G0tensor(238),G0tensor(322),G0tensor(515),G0tensor(386),G0tensor(56),G0tensor(36)])
  call ol_merge_tensors(G1tensor(121),[G0tensor(437),G0tensor(172),G0tensor(24),G0tensor(199),G0tensor(247),G0tensor(73) &
    ,G0tensor(70),G0tensor(366),G0tensor(51)])
  call ol_merge_tensors(G0tensor(193),[G0tensor(188),G0tensor(87),G0tensor(388),G0tensor(214),G0tensor(442),G0tensor(148) &
    ,G0tensor(54),G0tensor(165),G0tensor(14),G0tensor(486),G0tensor(466),G0tensor(66)])
  call ol_merge_tensors(G0tensor(407),[G0tensor(505),G0tensor(75),G0tensor(281),G0tensor(71)])
  call ol_merge_tensors(G0tensor(263),[G0tensor(258),G0tensor(248),G0tensor(427),G0tensor(174),G0tensor(417),G0tensor(167) &
    ,G0tensor(164),G0tensor(432),G0tensor(157),G0tensor(397),G0tensor(147),G0tensor(272),G0tensor(557),G0tensor(133),G0tensor(278) &
    ,G0tensor(108),G0tensor(548),G0tensor(93),G0tensor(135),G0tensor(83),G0tensor(79),G0tensor(78),G0tensor(74),G0tensor(72) &
    ,G0tensor(552),G0tensor(474),G0tensor(64),G0tensor(62),G0tensor(60),G0tensor(58),G0tensor(205),G0tensor(345),G0tensor(325) &
    ,G0tensor(104),G0tensor(315),G0tensor(194),G0tensor(420),G0tensor(30),G0tensor(27),G0tensor(574),G0tensor(179),G0tensor(122) &
    ,G0tensor(490),G0tensor(485),G0tensor(120),G0tensor(47),G0tensor(212),G0tensor(585),G0tensor(8),G0tensor(20),G0tensor(15) &
    ,G0tensor(275),G0tensor(245),G0tensor(80),G0tensor(576),G0tensor(551),G0tensor(526),G0tensor(501),G0tensor(476),G0tensor(451) &
    ,G0tensor(286),G0tensor(261),G0tensor(236),G0tensor(191),G0tensor(166),G0tensor(81)])
  call ol_merge_tensors(G0tensor(97),[G0tensor(224),G0tensor(264),G0tensor(357),G0tensor(459),G0tensor(332),G0tensor(305) &
    ,G0tensor(377),G0tensor(184),G0tensor(262),G0tensor(150),G0tensor(2),G0tensor(336),G0tensor(301),G0tensor(201),G0tensor(91)])
  call ol_merge_tensors(G1tensor(241),[G0tensor(215),G0tensor(555),G0tensor(403),G0tensor(110),G0tensor(68),G0tensor(23) &
    ,G0tensor(209),G0tensor(65),G0tensor(406),G0tensor(96)])
  call ol_merge_tensors(G0tensor(225),[G0tensor(327),G0tensor(153),G0tensor(228),G0tensor(223),G0tensor(560),G0tensor(139) &
    ,G0tensor(142),G0tensor(42),G0tensor(95),G0tensor(84),G0tensor(25),G0tensor(356),G0tensor(136)])
  call ol_merge_tensors(G0tensor(467),[G0tensor(250),G0tensor(402),G0tensor(123),G0tensor(229),G0tensor(535),G0tensor(38) &
    ,G0tensor(517),G0tensor(100),G0tensor(566),G0tensor(441),G0tensor(226),G0tensor(176),G0tensor(151)])
  call ol_merge_tensors(G1tensor(151),[G0tensor(178),G0tensor(240),G0tensor(328),G0tensor(132),G0tensor(45),G0tensor(231) &
    ,G0tensor(161)])
  call ol_merge_tensors(G1tensor(181),[G0tensor(360),G0tensor(335),G0tensor(32),G0tensor(22),G0tensor(561),G0tensor(546) &
    ,G0tensor(181)])
  call ol_merge_tensors(G2tensor(3),[G2tensor(91),G2tensor(6),G2tensor(87),G2tensor(105),G0tensor(105),G0tensor(330),G0tensor(29) &
    ,G0tensor(367),G0tensor(256),G0tensor(186)])
  call ol_merge_tensors(G1tensor(211),[G0tensor(143),G0tensor(119),G0tensor(89),G0tensor(155),G0tensor(562),G0tensor(416) &
    ,G0tensor(321),G0tensor(211)])
  call ol_merge_tensors(G2tensor(81),[G0tensor(290),G0tensor(230),G0tensor(63),G0tensor(9),G0tensor(271),G0tensor(246) &
    ,G0tensor(221)])
  call ol_merge_tensors(G2tensor(75),[G0tensor(130),G0tensor(452),G0tensor(251)])
  call ol_merge_tensors(G0tensor(218),[G0tensor(213),G0tensor(183),G0tensor(413),G0tensor(475),G0tensor(219),G0tensor(544) &
    ,G0tensor(538),G0tensor(175),G0tensor(516),G0tensor(491),G0tensor(276)])
  call ol_merge_tensors(G0tensor(537),[G0tensor(92),G0tensor(460),G0tensor(470),G0tensor(430),G0tensor(400),G0tensor(448) &
    ,G0tensor(189),G0tensor(134),G0tensor(542),G0tensor(112),G0tensor(337),G0tensor(421),G0tensor(396),G0tensor(341),G0tensor(316) &
    ,G0tensor(296)])
  call ol_merge_tensors(G0tensor(190),[G0tensor(173),G0tensor(353),G0tensor(428),G0tensor(128),G0tensor(168),G0tensor(13) &
    ,G0tensor(522),G0tensor(160),G0tensor(55),G0tensor(5),G0tensor(541),G0tensor(436)])
  call ol_merge_tensors(G0tensor(103),[G0tensor(445),G0tensor(342),G0tensor(300),G0tensor(511),G0tensor(471)])
  call ol_merge_tensors(G2tensor(83),[G0tensor(477)])
  call ol_merge_tensors(G2tensor(121),[G0tensor(358)])
  call ol_merge_tensors(G2tensor(37),[G2tensor(12),G2tensor(31),G2tensor(88),G2tensor(66),G0tensor(298)])
  call ol_merge_tensors(G0tensor(303),[G0tensor(158),G0tensor(37),G0tensor(145),G0tensor(140)])
  call ol_merge_tensors(G0tensor(137),[G0tensor(90),G0tensor(98),G0tensor(590)])
  call ol_merge_tensors(G0tensor(472),[G0tensor(285),G0tensor(220),G0tensor(107)])
  call ol_merge_tensors(G0tensor(519),[G0tensor(144),G0tensor(253),G0tensor(82),G0tensor(203)])
  call ol_merge_tensors(G0tensor(152),[G0tensor(33),G0tensor(270),G0tensor(510)])
  call ol_merge_tensors(G0tensor(149),[G0tensor(185),G0tensor(17),G0tensor(547)])
  call ol_merge_tensors(G0tensor(273),[G0tensor(312),G0tensor(35),G0tensor(374),G0tensor(363)])
  call ol_merge_tensors(G0tensor(279),[G0tensor(570),G0tensor(57),G0tensor(268),G0tensor(508)])
  call ol_merge_tensors(G0tensor(530),[G0tensor(39),G0tensor(259)])
  call ol_merge_tensors(G0tensor(550),[G0tensor(293),G0tensor(390),G0tensor(349)])
  call ol_merge_tensors(G0tensor(415),[G0tensor(408),G0tensor(375),G0tensor(50),G0tensor(350)])
  call ol_merge_tensors(G0tensor(419),[G0tensor(244),G0tensor(77),G0tensor(370),G0tensor(365)])
  call ol_merge_tensors(G0tensor(450),[G0tensor(395),G0tensor(274),G0tensor(67)])
  call ol_merge_tensors(G0tensor(455),[G0tensor(94),G0tensor(380)])
  call ol_merge_tensors(G0tensor(423),[G0tensor(525),G0tensor(520)])
  call ol_merge_tensors(G0tensor(387),[G0tensor(163),G0tensor(162)])
  call ol_merge_tensors(G0tensor(382),[G0tensor(575),G0tensor(159)])
  call ol_merge_tensors(G0tensor(257),[G0tensor(447),G0tensor(580)])
  call ol_merge_tensors(G0tensor(558),[G0tensor(252),G0tensor(573)])
call TI_bubble_red(G2tensor(84),60,mass2set(:,1),G0tensor(454),M2L1R1)
call TI_bubble_red(G2tensor(78),51,mass2set(:,1),G0tensor(414),M2L1R1)
call TI_bubble_red(G2tensor(40),48,mass2set(:,1),G0tensor(394),M2L1R1)
call TI_bubble_red(G2tensor(3),48,mass2set(:,2),G0tensor(369),M2L1R1,G0tensor(344))
call TI_bubble_red(G2tensor(81),60,mass2set(:,2),G0tensor(339),M2L1R1,G0tensor(334))
call TI_bubble_red(G2tensor(75),51,mass2set(:,2),G0tensor(304),M2L1R1,G0tensor(299))
call TI_bubble_red(G2tensor(83),60,mass2set(:,3),G0tensor(294),M2L1R1,G0tensor(523))
call TI_bubble_red(G2tensor(121),51,mass2set(:,3),G0tensor(438),M2L1R1,G0tensor(333))
call TI_bubble_red(G2tensor(37),48,mass2set(:,3),G0tensor(318),M2L1R1,G0tensor(313))
  call ol_merge_tensors(G0tensor(299),[G0tensor(334),G0tensor(344),G0tensor(263)])
  call ol_merge_tensors(G0tensor(283),[G0tensor(313),G0tensor(333),G0tensor(523)])
call TI_bubble_red(G1tensor(91),44,mass2set(:,1),G0tensor(443),M2L1R1)
call TI_bubble_red(G1tensor(121),35,mass2set(:,1),G0tensor(379),M2L1R1)
call TI_bubble_red(G1tensor(241),49,mass2set(:,1),G0tensor(338),M2L1R1)
call TI_bubble_red(G1tensor(151),56,mass2set(:,4),G0tensor(323),M2L1R1,G0tensor(314))
call TI_bubble_red(G1tensor(181),52,mass2set(:,5),G0tensor(549),M2L1R1,G0tensor(384))
call TI_bubble_red(G1tensor(211),50,mass2set(:,1),G0tensor(343),M2L1R1)
  call ol_merge_tensors(G0tensor(384),[G0tensor(314),G0tensor(299)])
  call ol_merge_tensors(T0sum(235),[G0tensor(454)])
  call ol_merge_tensors(T0sum(236),[G0tensor(414)])
  call ol_merge_tensors(T0sum(237),[G0tensor(394)])
  call ol_merge_tensors(T0sum(238),[G0tensor(443)])
  call ol_merge_tensors(T0sum(239),[G0tensor(267)])
  call ol_merge_tensors(T0sum(240),[G0tensor(379)])
  call ol_merge_tensors(T0sum(241),[G0tensor(193)])
  call ol_merge_tensors(T0sum(242),[G0tensor(407)])
  call ol_merge_tensors(T0sum(243),[G0tensor(384)])
  call ol_merge_tensors(T0sum(244),[G0tensor(97)])
  call ol_merge_tensors(T0sum(245),[G0tensor(338)])
  call ol_merge_tensors(T0sum(246),[G0tensor(225)])
  call ol_merge_tensors(T0sum(247),[G0tensor(467)])
  call ol_merge_tensors(T0sum(248),[G0tensor(323)])
  call ol_merge_tensors(T0sum(249),[G0tensor(549)])
  call ol_merge_tensors(T0sum(250),[G0tensor(369)])
  call ol_merge_tensors(T0sum(251),[G0tensor(343)])
  call ol_merge_tensors(T0sum(252),[G0tensor(339)])
  call ol_merge_tensors(T0sum(253),[G0tensor(304)])
  call ol_merge_tensors(T0sum(254),[G0tensor(218)])
  call ol_merge_tensors(T0sum(255),[G0tensor(537)])
  call ol_merge_tensors(T0sum(256),[G0tensor(190)])
  call ol_merge_tensors(T0sum(257),[G0tensor(103)])
  call ol_merge_tensors(T0sum(258),[G0tensor(294)])
  call ol_merge_tensors(T0sum(259),[G0tensor(283)])
  call ol_merge_tensors(T0sum(260),[G0tensor(438)])
  call ol_merge_tensors(T0sum(261),[G0tensor(318)])
  call ol_merge_tensors(T0sum(262),[G0tensor(303)])
  call ol_merge_tensors(T0sum(263),[G0tensor(137)])
  call ol_merge_tensors(T0sum(264),[G0tensor(472)])
  call ol_merge_tensors(T0sum(265),[G0tensor(519)])
  call ol_merge_tensors(T0sum(266),[G0tensor(152)])
  call ol_merge_tensors(T0sum(267),[G0tensor(149)])
  call ol_merge_tensors(T0sum(268),[G0tensor(273)])
  call ol_merge_tensors(T0sum(269),[G0tensor(279)])
  call ol_merge_tensors(T0sum(270),[G0tensor(530)])
  call ol_merge_tensors(T0sum(271),[G0tensor(550)])
  call ol_merge_tensors(T0sum(272),[G0tensor(415)])
  call ol_merge_tensors(T0sum(273),[G0tensor(419)])
  call ol_merge_tensors(T0sum(274),[G0tensor(450)])
  call ol_merge_tensors(T0sum(275),[G0tensor(455)])
  call ol_merge_tensors(T0sum(276),[G0tensor(423)])
  call ol_merge_tensors(T0sum(277),[G0tensor(387)])
  call ol_merge_tensors(T0sum(278),[G0tensor(382)])
  call ol_merge_tensors(T0sum(279),[G0tensor(257)])
  call ol_merge_tensors(T0sum(280),[G0tensor(558)])


! Compute scalar Master integrals 

  call compute_scalar_box([ 44, 45, 47 ],masses2_16,RedSet_4(1),ScalarBoxes(1))
  call compute_scalar_box([ 40, 45, 47 ],masses2_21,RedSet_4(2),ScalarBoxes(2))
  call compute_scalar_box([ 40, 44, 47 ],masses2_21,RedSet_4(3),ScalarBoxes(3))
  call compute_scalar_box([ 40, 44, 45 ],masses2_21,RedSet_4(4),ScalarBoxes(4))
  call compute_scalar_box([ 4, 5, 7 ],masses2_17,RedSet_4(5),ScalarBoxes(5))
  call compute_scalar_box([ 32, 45, 47 ],masses2_16,RedSet_4(6),ScalarBoxes(6))
  call compute_scalar_box([ 32, 44, 47 ],masses2_16,RedSet_4(7),ScalarBoxes(7))
  call compute_scalar_box([ 32, 44, 45 ],masses2_16,RedSet_4(8),ScalarBoxes(8))
  call compute_scalar_box([ 12, 13, 15 ],masses2_16,RedSet_4(9),ScalarBoxes(9))
  call compute_scalar_box([ 32, 40, 47 ],masses2_19,RedSet_4(10),ScalarBoxes(10))
  call compute_scalar_box([ 32, 40, 45 ],masses2_19,RedSet_4(11),ScalarBoxes(11))
  call compute_scalar_box([ 8, 13, 15 ],masses2_21,RedSet_4(12),ScalarBoxes(12))
  call compute_scalar_box([ 32, 40, 44 ],masses2_19,RedSet_4(13),ScalarBoxes(13))
  call compute_scalar_box([ 8, 12, 15 ],masses2_21,RedSet_4(14),ScalarBoxes(14))
  call compute_scalar_box([ 8, 12, 13 ],masses2_21,RedSet_4(15),ScalarBoxes(15))
  call compute_scalar_box([ 35, 39, 47 ],masses2_19,RedSet_4(16),ScalarBoxes(16))
  call compute_scalar_box([ 34, 39, 47 ],masses2_19,RedSet_4(17),ScalarBoxes(17))
  call compute_scalar_box([ 34, 35, 47 ],masses2_16,RedSet_4(18),ScalarBoxes(18))
  call compute_scalar_box([ 34, 35, 39 ],masses2_18,RedSet_4(19),ScalarBoxes(19))
  call compute_scalar_box([ 1, 5, 13 ],masses2_19,RedSet_4(20),ScalarBoxes(20))
  call compute_scalar_box([ 32, 39, 47 ],masses2_19,RedSet_4(21),ScalarBoxes(21))
  call compute_scalar_box([ 32, 35, 47 ],masses2_16,RedSet_4(22),ScalarBoxes(22))
  call compute_scalar_box([ 32, 35, 39 ],masses2_18,RedSet_4(23),ScalarBoxes(23))
  call compute_scalar_box([ 3, 7, 15 ],masses2_19,RedSet_4(24),ScalarBoxes(24))
  call compute_scalar_box([ 32, 34, 47 ],masses2_16,RedSet_4(25),ScalarBoxes(25))
  call compute_scalar_box([ 32, 34, 39 ],masses2_18,RedSet_4(26),ScalarBoxes(26))
  call compute_scalar_box([ 2, 7, 15 ],masses2_19,RedSet_4(27),ScalarBoxes(27))
  call compute_scalar_box([ 32, 34, 35 ],masses2_16,RedSet_4(28),ScalarBoxes(28))
  call compute_scalar_box([ 2, 3, 15 ],masses2_16,RedSet_4(29),ScalarBoxes(29))
  call compute_scalar_box([ 2, 3, 7 ],masses2_18,RedSet_4(30),ScalarBoxes(30))
  call compute_scalar_box([ 36, 45, 47 ],masses2_21,RedSet_4(31),ScalarBoxes(31))
  call compute_scalar_box([ 36, 44, 47 ],masses2_21,RedSet_4(32),ScalarBoxes(32))
  call compute_scalar_box([ 36, 44, 45 ],masses2_21,RedSet_4(33),ScalarBoxes(33))
  call compute_scalar_box([ 8, 9, 11 ],masses2_17,RedSet_4(34),ScalarBoxes(34))
  call compute_scalar_box([ 32, 36, 47 ],masses2_19,RedSet_4(35),ScalarBoxes(35))
  call compute_scalar_box([ 32, 36, 45 ],masses2_19,RedSet_4(36),ScalarBoxes(36))
  call compute_scalar_box([ 4, 13, 15 ],masses2_21,RedSet_4(37),ScalarBoxes(37))
  call compute_scalar_box([ 32, 36, 44 ],masses2_19,RedSet_4(38),ScalarBoxes(38))
  call compute_scalar_box([ 4, 12, 15 ],masses2_21,RedSet_4(39),ScalarBoxes(39))
  call compute_scalar_box([ 4, 12, 13 ],masses2_21,RedSet_4(40),ScalarBoxes(40))
  call compute_scalar_box([ 35, 43, 47 ],masses2_19,RedSet_4(41),ScalarBoxes(41))
  call compute_scalar_box([ 34, 43, 47 ],masses2_19,RedSet_4(42),ScalarBoxes(42))
  call compute_scalar_box([ 34, 35, 43 ],masses2_18,RedSet_4(43),ScalarBoxes(43))
  call compute_scalar_box([ 1, 9, 13 ],masses2_19,RedSet_4(44),ScalarBoxes(44))
  call compute_scalar_box([ 32, 43, 47 ],masses2_19,RedSet_4(45),ScalarBoxes(45))
  call compute_scalar_box([ 32, 35, 43 ],masses2_18,RedSet_4(46),ScalarBoxes(46))
  call compute_scalar_box([ 3, 11, 15 ],masses2_19,RedSet_4(47),ScalarBoxes(47))
  call compute_scalar_box([ 32, 34, 43 ],masses2_18,RedSet_4(48),ScalarBoxes(48))
  call compute_scalar_box([ 2, 11, 15 ],masses2_19,RedSet_4(49),ScalarBoxes(49))
  call compute_scalar_box([ 2, 3, 11 ],masses2_18,RedSet_4(50),ScalarBoxes(50))
  call compute_scalar_box([ 44, 46, 47 ],masses2_16,RedSet_4(51),ScalarBoxes(51))
  call compute_scalar_box([ 40, 46, 47 ],masses2_21,RedSet_4(52),ScalarBoxes(52))
  call compute_scalar_box([ 40, 44, 46 ],masses2_21,RedSet_4(53),ScalarBoxes(53))
  call compute_scalar_box([ 4, 6, 7 ],masses2_17,RedSet_4(54),ScalarBoxes(54))
  call compute_scalar_box([ 32, 46, 47 ],masses2_16,RedSet_4(55),ScalarBoxes(55))
  call compute_scalar_box([ 32, 44, 46 ],masses2_16,RedSet_4(56),ScalarBoxes(56))
  call compute_scalar_box([ 12, 14, 15 ],masses2_16,RedSet_4(57),ScalarBoxes(57))
  call compute_scalar_box([ 32, 40, 46 ],masses2_19,RedSet_4(58),ScalarBoxes(58))
  call compute_scalar_box([ 8, 14, 15 ],masses2_21,RedSet_4(59),ScalarBoxes(59))
  call compute_scalar_box([ 8, 12, 14 ],masses2_21,RedSet_4(60),ScalarBoxes(60))
  call compute_scalar_box([ 36, 46, 47 ],masses2_21,RedSet_4(61),ScalarBoxes(61))
  call compute_scalar_box([ 36, 44, 46 ],masses2_21,RedSet_4(62),ScalarBoxes(62))
  call compute_scalar_box([ 8, 10, 11 ],masses2_17,RedSet_4(63),ScalarBoxes(63))
  call compute_scalar_box([ 32, 36, 46 ],masses2_19,RedSet_4(64),ScalarBoxes(64))
  call compute_scalar_box([ 4, 14, 15 ],masses2_21,RedSet_4(65),ScalarBoxes(65))
  call compute_scalar_box([ 4, 12, 14 ],masses2_21,RedSet_4(66),ScalarBoxes(66))
  call compute_scalar_box([ 33, 39, 47 ],masses2_19,RedSet_4(67),ScalarBoxes(67))
  call compute_scalar_box([ 33, 35, 47 ],masses2_16,RedSet_4(68),ScalarBoxes(68))
  call compute_scalar_box([ 33, 35, 39 ],masses2_18,RedSet_4(69),ScalarBoxes(69))
  call compute_scalar_box([ 2, 6, 14 ],masses2_19,RedSet_4(70),ScalarBoxes(70))
  call compute_scalar_box([ 32, 33, 47 ],masses2_16,RedSet_4(71),ScalarBoxes(71))
  call compute_scalar_box([ 32, 33, 39 ],masses2_18,RedSet_4(72),ScalarBoxes(72))
  call compute_scalar_box([ 1, 7, 15 ],masses2_19,RedSet_4(73),ScalarBoxes(73))
  call compute_scalar_box([ 32, 33, 35 ],masses2_16,RedSet_4(74),ScalarBoxes(74))
  call compute_scalar_box([ 1, 3, 15 ],masses2_16,RedSet_4(75),ScalarBoxes(75))
  call compute_scalar_box([ 1, 3, 7 ],masses2_18,RedSet_4(76),ScalarBoxes(76))
  call compute_scalar_box([ 33, 43, 47 ],masses2_19,RedSet_4(77),ScalarBoxes(77))
  call compute_scalar_box([ 33, 35, 43 ],masses2_18,RedSet_4(78),ScalarBoxes(78))
  call compute_scalar_box([ 2, 10, 14 ],masses2_19,RedSet_4(79),ScalarBoxes(79))
  call compute_scalar_box([ 32, 33, 43 ],masses2_18,RedSet_4(80),ScalarBoxes(80))
  call compute_scalar_box([ 1, 11, 15 ],masses2_19,RedSet_4(81),ScalarBoxes(81))
  call compute_scalar_box([ 1, 3, 11 ],masses2_18,RedSet_4(82),ScalarBoxes(82))
  call compute_scalar_box([ 56, 60, 61 ],masses2_21,RedSet_4(83),ScalarBoxes(83))
  call compute_scalar_box([ 48, 60, 61 ],masses2_16,RedSet_4(84),ScalarBoxes(84))
  call compute_scalar_box([ 48, 56, 61 ],masses2_19,RedSet_4(85),ScalarBoxes(85))
  call compute_scalar_box([ 48, 56, 60 ],masses2_19,RedSet_4(86),ScalarBoxes(86))
  call compute_scalar_box([ 50, 51, 55 ],masses2_18,RedSet_4(87),ScalarBoxes(87))
  call compute_scalar_box([ 48, 51, 55 ],masses2_18,RedSet_4(88),ScalarBoxes(88))
  call compute_scalar_box([ 48, 50, 55 ],masses2_18,RedSet_4(89),ScalarBoxes(89))
  call compute_scalar_box([ 48, 50, 51 ],masses2_16,RedSet_4(90),ScalarBoxes(90))
  call compute_scalar_box([ 52, 60, 61 ],masses2_21,RedSet_4(91),ScalarBoxes(91))
  call compute_scalar_box([ 48, 52, 61 ],masses2_19,RedSet_4(92),ScalarBoxes(92))
  call compute_scalar_box([ 48, 52, 60 ],masses2_19,RedSet_4(93),ScalarBoxes(93))
  call compute_scalar_box([ 50, 51, 59 ],masses2_18,RedSet_4(94),ScalarBoxes(94))
  call compute_scalar_box([ 48, 51, 59 ],masses2_18,RedSet_4(95),ScalarBoxes(95))
  call compute_scalar_box([ 48, 50, 59 ],masses2_18,RedSet_4(96),ScalarBoxes(96))
  call compute_scalar_box([ 56, 60, 62 ],masses2_21,RedSet_4(97),ScalarBoxes(97))
  call compute_scalar_box([ 48, 60, 62 ],masses2_16,RedSet_4(98),ScalarBoxes(98))
  call compute_scalar_box([ 48, 56, 62 ],masses2_19,RedSet_4(99),ScalarBoxes(99))
  call compute_scalar_box([ 52, 60, 62 ],masses2_21,RedSet_4(100),ScalarBoxes(100))
  call compute_scalar_box([ 48, 52, 62 ],masses2_19,RedSet_4(101),ScalarBoxes(101))
  call compute_scalar_box([ 49, 51, 55 ],masses2_18,RedSet_4(102),ScalarBoxes(102))
  call compute_scalar_box([ 48, 49, 55 ],masses2_18,RedSet_4(103),ScalarBoxes(103))
  call compute_scalar_box([ 48, 49, 51 ],masses2_16,RedSet_4(104),ScalarBoxes(104))
  call compute_scalar_box([ 49, 51, 59 ],masses2_18,RedSet_4(105),ScalarBoxes(105))
  call compute_scalar_box([ 48, 49, 59 ],masses2_18,RedSet_4(106),ScalarBoxes(106))
  call compute_scalar_box([ 35, 51, 55 ],masses2_18,RedSet_4(107),ScalarBoxes(107))
  call compute_scalar_box([ 32, 51, 55 ],masses2_18,RedSet_4(108),ScalarBoxes(108))
  call compute_scalar_box([ 32, 35, 55 ],masses2_18,RedSet_4(109),ScalarBoxes(109))
  call compute_scalar_box([ 32, 35, 51 ],masses2_16,RedSet_4(110),ScalarBoxes(110))
  call compute_scalar_box([ 3, 19, 23 ],masses2_18,RedSet_4(111),ScalarBoxes(111))
  call compute_scalar_box([ 35, 51, 59 ],masses2_18,RedSet_4(112),ScalarBoxes(112))
  call compute_scalar_box([ 32, 51, 59 ],masses2_18,RedSet_4(113),ScalarBoxes(113))
  call compute_scalar_box([ 32, 35, 59 ],masses2_18,RedSet_4(114),ScalarBoxes(114))
  call compute_scalar_box([ 3, 19, 27 ],masses2_18,RedSet_4(115),ScalarBoxes(115))
  call compute_scalar_box([ 40, 43, 47 ],masses2_23,RedSet_4(116),ScalarBoxes(116))
  call compute_scalar_box([ 32, 40, 43 ],masses2_20,RedSet_4(117),ScalarBoxes(117))
  call compute_scalar_box([ 8, 11, 15 ],masses2_23,RedSet_4(118),ScalarBoxes(118))
  call compute_scalar_box([ 36, 39, 47 ],masses2_23,RedSet_4(119),ScalarBoxes(119))
  call compute_scalar_box([ 32, 36, 39 ],masses2_20,RedSet_4(120),ScalarBoxes(120))
  call compute_scalar_box([ 4, 7, 15 ],masses2_23,RedSet_4(121),ScalarBoxes(121))
  call compute_scalar_box([ 34, 35, 51 ],masses2_16,RedSet_4(122),ScalarBoxes(122))
  call compute_scalar_box([ 32, 34, 51 ],masses2_16,RedSet_4(123),ScalarBoxes(123))
  call compute_scalar_box([ 2, 3, 19 ],masses2_16,RedSet_4(124),ScalarBoxes(124))
  call compute_scalar_box([ 33, 35, 51 ],masses2_16,RedSet_4(125),ScalarBoxes(125))
  call compute_scalar_box([ 32, 33, 51 ],masses2_16,RedSet_4(126),ScalarBoxes(126))
  call compute_scalar_box([ 1, 3, 19 ],masses2_16,RedSet_4(127),ScalarBoxes(127))
  call compute_scalar_box([ 34, 46, 47 ],masses2_16,RedSet_4(128),ScalarBoxes(128))
  call compute_scalar_box([ 32, 34, 46 ],masses2_16,RedSet_4(129),ScalarBoxes(129))
  call compute_scalar_box([ 2, 14, 15 ],masses2_16,RedSet_4(130),ScalarBoxes(130))
  call compute_scalar_box([ 33, 45, 47 ],masses2_16,RedSet_4(131),ScalarBoxes(131))
  call compute_scalar_box([ 32, 33, 45 ],masses2_16,RedSet_4(132),ScalarBoxes(132))
  call compute_scalar_box([ 1, 13, 15 ],masses2_16,RedSet_4(133),ScalarBoxes(133))
  call compute_scalar_box([ 52, 53, 55 ],masses2_17,RedSet_4(134),ScalarBoxes(134))
  call compute_scalar_box([ 48, 53, 55 ],masses2_22,RedSet_4(135),ScalarBoxes(135))
  call compute_scalar_box([ 48, 52, 55 ],masses2_22,RedSet_4(136),ScalarBoxes(136))
  call compute_scalar_box([ 48, 52, 53 ],masses2_22,RedSet_4(137),ScalarBoxes(137))
  call compute_scalar_box([ 52, 54, 55 ],masses2_17,RedSet_4(138),ScalarBoxes(138))
  call compute_scalar_box([ 48, 54, 55 ],masses2_22,RedSet_4(139),ScalarBoxes(139))
  call compute_scalar_box([ 48, 52, 54 ],masses2_22,RedSet_4(140),ScalarBoxes(140))
  call compute_scalar_box([ 49, 53, 61 ],masses2_19,RedSet_4(141),ScalarBoxes(141))
  call compute_scalar_box([ 48, 53, 61 ],masses2_19,RedSet_4(142),ScalarBoxes(142))
  call compute_scalar_box([ 48, 49, 61 ],masses2_16,RedSet_4(143),ScalarBoxes(143))
  call compute_scalar_box([ 48, 49, 53 ],masses2_18,RedSet_4(144),ScalarBoxes(144))
  call compute_scalar_box([ 49, 57, 61 ],masses2_19,RedSet_4(145),ScalarBoxes(145))
  call compute_scalar_box([ 48, 57, 61 ],masses2_19,RedSet_4(146),ScalarBoxes(146))
  call compute_scalar_box([ 48, 49, 57 ],masses2_18,RedSet_4(147),ScalarBoxes(147))
! end of process


end subroutine vamp_2

end module ol_vamp_2_ppttjj_uuxttxddx_1_/**/REALKIND
