
module ol_vamp_1_ppttjj_uuxttxddx_1_/**/REALKIND
contains

! **********************************************************************
subroutine vamp_1(M)
! P(0:3,nlegs) = incoming external momenta
! Uses tree structures 'wf', factors 'c', and denominators 'den' from loop_ppttjj_uuxttxddx_1.
! Sets colour stripped amplitudes A from the module loop_amplitudes_ppttjj_uuxttxddx_1.
! **********************************************************************
  use KIND_TYPES, only: REALKIND, QREALKIND, intkind2
  use ol_parameters_decl_/**/DREALKIND, only: l_switch
  use ol_parameters_decl_/**/QREALKIND ! masses
  use ol_vert_interface_/**/REALKIND
  use ol_prop_interface_/**/REALKIND
  use ol_last_step_/**/REALKIND
  use ol_tables_storage_ppttjj_uuxttxddx_1_/**/DREALKIND
  use ol_tensor_sum_storage_ppttjj_uuxttxddx_1_/**/REALKIND
  use ol_loop_handling_/**/REALKIND
  use ofred_reduction_/**/REALKIND, only: Hotf_4pt_reduction, Hotf_4pt_reduction_last
  use ofred_reduction_/**/REALKIND, only: Hotf_5pt_reduction, Hotf_5pt_reduction_last
  use ol_loop_reduction_/**/REALKIND, only: TI_bubble_red, TI_triangle_red
use ol_loop_reduction_/**/REALKIND, only: compute_scalar_box

  use ol_loop_storage_ppttjj_uuxttxddx_1_/**/REALKIND
#ifndef PRECISION_dp
  use ol_loop_storage_ppttjj_uuxttxddx_1_/**/DREALKIND, only: &
    & ntryL, p_switch, Hel, merge_step, merge_mism, merge_tables, merge_hels
#endif
  use hol_initialisation_/**/REALKIND, only: G0_hol_initialisation
  use ol_h_vert_interface_/**/REALKIND
  use ol_h_prop_interface_/**/REALKIND
  use ol_h_last_step_/**/REALKIND
  use ol_merging_/**/REALKIND, only: ol_merge, ol_merge_tensors, ol_merge_last

  implicit none

  type(Hpolcont) :: Gcoeff(64)
  type(Hpolcont), intent(in) :: M(6,64)


#ifndef PRECISION_dp
  if (ntryL==1 .OR. p_switch == 1) Gcoeff(:)%hf = Hel
#else
  if (ntryL==1 .OR. p_switch == 2) Gcoeff(:)%hf = Hel
#endif

  ! =============================================


! Dressing, otf merging and otf reduction calls to build loop structures

  Gcoeff(:)%j = (c(21)*M(1,:)%j-c(15)*M(2,:)%j-c(17)*M(3,:)%j+c(12)*(M(4,:)%j+M(5,:)%j)-c(11)*M(6,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(1),h0tab(:,1),[32,8,4,1,2,16],[0,nMT,0,0,0,0],6,0)
  call Hloop_QA_V(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,1),heltab2x64(:,:,1))
  Gcoeff(:)%j = (-(c(17)*M(2,:)%j)-c(15)*M(3,:)%j+c(21)*M(4,:)%j+c(12)*(M(1,:)%j+M(5,:)%j)-c(11)*M(6,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(2),h0tab(:,2),[32,2,1,4,8,16],[0,0,0,nMT,0,0],6,0)
  call Hloop_QA_V(ntryL,G0H64(1),ex6(:),G0H32(2),m3h2x32(:,2),heltab2x64(:,:,2))
  Gcoeff(:)%j = (c(22)*M(3,:)%j+c(12)*(M(1,:)%j+M(4,:)%j+M(5,:)%j)-c(11)*M(6,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(3),h0tab(:,3),[32,4,8,1,2,16],[0,nMT,0,0,0,0],6,0)
  call Hloop_QA_V(ntryL,G0H64(1),ex6(:),G0H32(3),m3h2x32(:,3),heltab2x64(:,:,3))
  Gcoeff(:)%j = (-(c(15)*M(2,:)%j)-c(17)*M(3,:)%j+c(12)*(M(1,:)%j+M(4,:)%j)+c(21)*M(5,:)%j-c(11)*M(6,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(4),h0tab(:,4),[32,2,1,8,4,16],[0,0,0,nMT,0,0],6,0)
  call Hloop_QA_V(ntryL,G0H64(1),ex6(:),G0H32(4),m3h2x32(:,4),heltab2x64(:,:,4))
  Gcoeff(:)%j = (-(c(17)*M(2,:)%j)-c(15)*M(3,:)%j+c(12)*(M(1,:)%j+M(4,:)%j)+c(21)*M(5,:)%j-c(11)*M(6,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(5),h0tab(:,5),[32,8,4,2,1,16],[0,nMT,0,0,0,0],6,0)
  call Hloop_QA_V(ntryL,G0H64(1),ex6(:),G0H32(5),m3h2x32(:,5),heltab2x64(:,:,5))
  Gcoeff(:)%j = (-(c(15)*M(2,:)%j)-c(17)*M(3,:)%j+c(21)*M(4,:)%j+c(12)*(M(1,:)%j+M(5,:)%j)-c(11)*M(6,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(6),h0tab(:,6),[32,4,8,2,1,16],[0,nMT,0,0,0,0],6,0)
  call Hloop_QA_V(ntryL,G0H64(1),ex6(:),G0H32(6),m3h2x32(:,6),heltab2x64(:,:,6))
  Gcoeff(:)%j = (c(22)*M(2,:)%j+c(12)*(M(1,:)%j+M(4,:)%j+M(5,:)%j)-c(11)*M(6,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(7),h0tab(:,7),[32,1,2,4,8,16],[0,0,0,nMT,0,0],6,0)
  call Hloop_QA_V(ntryL,G0H64(1),ex6(:),G0H32(7),m3h2x32(:,7),heltab2x64(:,:,7))
  Gcoeff(:)%j = (c(21)*M(1,:)%j-c(17)*M(2,:)%j-c(15)*M(3,:)%j+c(12)*(M(4,:)%j+M(5,:)%j)-c(11)*M(6,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(8),h0tab(:,8),[32,1,2,8,4,16],[0,0,0,nMT,0,0],6,0)
  call Hloop_QA_V(ntryL,G0H64(1),ex6(:),G0H32(8),m3h2x32(:,8),heltab2x64(:,:,8))
  call Hloop_VA_Q(ntryL,G0H32(1),ex4(:),G0H16(1),m3h2x16(:,1),heltab2x32(:,:,1))
  call Hloop_A_Q(ntryL,G0H16(1),40,nMT,G1H16(1),n2h16(1))
  call Hloop_VA_Q(ntryL,G0H32(2),ex2(:),G0H16(1),m3h2x16(:,2),heltab2x32(:,:,2))
  call Hloop_A_Q(ntryL,G0H16(1),34,0,G1H16(2),n2h16(2))
  call Hloop_VQ_A(ntryL,G0H32(3),ex3(:),G0H16(1),m3h2x16(:,3),heltab2x32(:,:,3))
  call Hloop_Q_A(ntryL,G0H16(1),36,nMT,G1H16(3),n2h16(3))
  call Hloop_VA_Q(ntryL,G0H32(4),ex2(:),G0H16(1),m3h2x16(:,4),heltab2x32(:,:,4))
  call Hloop_A_Q(ntryL,G0H16(1),34,0,G1H16(4),n2h16(4))
  call Hloop_VA_Q(ntryL,G0H32(5),ex4(:),G0H16(1),m3h2x16(:,5),heltab2x32(:,:,5))
  call Hloop_A_Q(ntryL,G0H16(1),40,nMT,G1H16(5),n2h16(5))
  call Hloop_VQ_A(ntryL,G0H32(6),ex3(:),G0H16(1),m3h2x16(:,6),heltab2x32(:,:,6))
  call Hloop_Q_A(ntryL,G0H16(1),36,nMT,G1H16(6),n2h16(6))
  call Hloop_VQ_A(ntryL,G0H32(7),ex1(:),G0H16(1),m3h2x16(:,7),heltab2x32(:,:,7))
  call Hloop_Q_A(ntryL,G0H16(1),33,0,G1H16(7),n2h16(7))
  call Hloop_VQ_A(ntryL,G0H32(8),ex1(:),G0H16(1),m3h2x16(:,8),heltab2x32(:,:,8))
  call Hloop_Q_A(ntryL,G0H16(1),33,0,G1H16(8),n2h16(8))
  call Hloop_AQ_V(ntryL,G1H16(1),ex3(:),G1H8(1),m3h2x8(:,1),heltab2x16(:,:,1))
  call Hloop_AQ_V(ntryL,G1H16(2),ex1(:),G1H8(2),m3h2x8(:,2),heltab2x16(:,:,2))
  call Hloop_QA_V(ntryL,G1H16(3),ex4(:),G1H8(3),m3h2x8(:,3),heltab2x16(:,:,3))
  call Hloop_AQ_V(ntryL,G1H16(4),ex1(:),G1H8(4),m3h2x8(:,4),heltab2x16(:,:,4))
  call Hloop_AQ_V(ntryL,G1H16(5),ex3(:),G1H8(5),m3h2x8(:,5),heltab2x16(:,:,5))
  call Hloop_QA_V(ntryL,G1H16(6),ex4(:),G1H8(6),m3h2x8(:,6),heltab2x16(:,:,6))
  call Hloop_QA_V(ntryL,G1H16(7),ex2(:),G1H8(7),m3h2x8(:,7),heltab2x16(:,:,7))
  call Hloop_QA_V(ntryL,G1H16(8),ex2(:),G1H8(8),m3h2x8(:,8),heltab2x16(:,:,8))
  call Hloop_VQ_A(ntryL,G1H8(1),ex1(:),G1H4(1),m3h2x4(:,1),heltab2x8(:,:,1))
  call Hloop_Q_A(ntryL,G1H4(1),45,0,G2H4(1),n2h4(1))
  call Hloop_VQ_A(ntryL,G1H8(2),ex3(:),G1H4(1),m3h2x4(:,2),heltab2x8(:,:,2))
  call Hloop_Q_A(ntryL,G1H4(1),39,nMT,G2H4(2),n2h4(2))
  call Hloop_VQ_A(ntryL,G1H8(3),ex1(:),G1H4(1),m3h2x4(:,3),heltab2x8(:,:,3))
  call Hloop_Q_A(ntryL,G1H4(1),45,0,G2H4(3),n2h4(3))
  call Hloop_VA_Q(ntryL,G1H8(4),ex4(:),G1H4(1),m3h2x4(:,4),heltab2x8(:,:,4))
  call Hloop_A_Q(ntryL,G1H4(1),43,nMT,G2H4(4),n2h4(4))
  call Hloop_VA_Q(ntryL,G1H8(5),ex2(:),G1H4(1),m3h2x4(:,5),heltab2x8(:,:,5))
  call Hloop_A_Q(ntryL,G1H4(1),46,0,G2H4(5),n2h4(5))
  call Hloop_VA_Q(ntryL,G1H8(6),ex2(:),G1H4(1),m3h2x4(:,6),heltab2x8(:,:,6))
  call Hloop_A_Q(ntryL,G1H4(1),46,0,G2H4(6),n2h4(6))
  call Hloop_VQ_A(ntryL,G1H8(7),ex3(:),G1H4(1),m3h2x4(:,7),heltab2x8(:,:,7))
  call Hloop_Q_A(ntryL,G1H4(1),39,nMT,G2H4(7),n2h4(7))
  call Hloop_VA_Q(ntryL,G1H8(8),ex4(:),G1H4(1),m3h2x4(:,8),heltab2x8(:,:,8))
  call Hloop_A_Q(ntryL,G1H4(1),43,nMT,G2H4(8),n2h4(8))
  call Hloop_QA_V(ntryL,G2H4(1),ex2(:),G2H2(1),m3h2x2(:,1),heltab2x4(:,:,1))
  call Hloop_QA_V(ntryL,G2H4(2),ex4(:),G2H2(2),m3h2x2(:,2),heltab2x4(:,:,2))
  call Hloop_QA_V(ntryL,G2H4(3),ex2(:),G2H2(3),m3h2x2(:,3),heltab2x4(:,:,3))
  call Hloop_AQ_V(ntryL,G2H4(4),ex3(:),G2H2(4),m3h2x2(:,4),heltab2x4(:,:,4))
  call Hloop_AQ_V(ntryL,G2H4(5),ex1(:),G2H2(5),m3h2x2(:,5),heltab2x4(:,:,5))
  call Hloop_AQ_V(ntryL,G2H4(6),ex1(:),G2H2(6),m3h2x2(:,6),heltab2x4(:,:,6))
  call Hloop_QA_V(ntryL,G2H4(7),ex4(:),G2H2(7),m3h2x2(:,7),heltab2x4(:,:,7))
  call Hloop_AQ_V(ntryL,G2H4(8),ex3(:),G2H2(8),m3h2x2(:,8),heltab2x4(:,:,8))
  call Hotf_5pt_reduction(G2H2(1),RedSet_5(1),mass5set(:,1),  & 
G1H2(1),G1H2(2),G1H2(3),G1H2(4),G1H2(5),G1H2(6),2)
  call HG1shiftOLR(G1H2(2),16,2)
  call Hotf_5pt_reduction(G2H2(2),RedSet_5(2),mass5set(:,2),  & 
G1H2(7),G1H2(8),G1H2(9),G1H2(10),G1H2(11),G1H2(12),2)
  call HG1shiftOLR(G1H2(8),16,2)
  call Hotf_5pt_reduction(G2H2(3),RedSet_5(3),mass5set(:,1),  & 
G1H2(13),G1H2(14),G1H2(15),G1H2(16),G1H2(17),G1H2(18),2)
  call HG1shiftOLR(G1H2(14),16,2)
  call Hotf_5pt_reduction(G2H2(4),RedSet_5(4),mass5set(:,2),  & 
G1H2(19),G1H2(20),G1H2(21),G1H2(22),G1H2(23),G1H2(24),2)
  call HG1shiftOLR(G1H2(20),16,2)
  call Hotf_5pt_reduction(G2H2(5),RedSet_5(5),mass5set(:,1),  & 
G1H2(25),G1H2(26),G1H2(27),G1H2(28),G1H2(29),G1H2(30),2)
  call HG1shiftOLR(G1H2(26),16,2)
  call Hotf_5pt_reduction(G2H2(6),RedSet_5(6),mass5set(:,1),  & 
G1H2(31),G1H2(32),G1H2(33),G1H2(34),G1H2(35),G1H2(36),2)
  call HG1shiftOLR(G1H2(32),16,2)
  call Hotf_5pt_reduction(G2H2(7),RedSet_5(7),mass5set(:,2),  & 
G1H2(37),G1H2(38),G1H2(39),G1H2(40),G1H2(41),G1H2(42),2)
  call HG1shiftOLR(G1H2(38),16,2)
  call Hotf_5pt_reduction(G2H2(8),RedSet_5(8),mass5set(:,2),  & 
G1H2(43),G1H2(44),G1H2(45),G1H2(46),G1H2(47),G1H2(48),2)
  call HG1shiftOLR(G1H2(44),16,2)
  call Hloop_VQ_A(ntryL,G1H2(1),ex5(:),G1H1(1),m3h2x1(:,1),heltab2x2(:,:,1))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(1),n2h1(1))
  call Hloop_VQ_A(ntryL,G1H2(2),ex5(:),G1H1(1),m3h2x1(:,2),heltab2x2(:,:,2))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),16,0,G2tensor(2),n2h1(2))
  call Hloop_VQ_A(ntryL,G1H2(7),ex5(:),G1H1(1),m3h2x1(:,3),heltab2x2(:,:,3))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(3),n2h1(3))
  call Hloop_VQ_A(ntryL,G1H2(8),ex5(:),G1H1(1),m3h2x1(:,4),heltab2x2(:,:,4))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),16,0,G2tensor(4),n2h1(4))
  call Hloop_VQ_A(ntryL,G1H2(13),ex5(:),G1H1(1),m3h2x1(:,5),heltab2x2(:,:,5))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(5),n2h1(5))
  call Hloop_VQ_A(ntryL,G1H2(14),ex5(:),G1H1(1),m3h2x1(:,6),heltab2x2(:,:,6))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),16,0,G2tensor(6),n2h1(6))
  call Hloop_VQ_A(ntryL,G1H2(19),ex5(:),G1H1(1),m3h2x1(:,7),heltab2x2(:,:,7))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(7),n2h1(7))
  call Hloop_VQ_A(ntryL,G1H2(20),ex5(:),G1H1(1),m3h2x1(:,8),heltab2x2(:,:,8))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),16,0,G2tensor(8),n2h1(8))
  call Hloop_VQ_A(ntryL,G1H2(25),ex5(:),G1H1(1),m3h2x1(:,9),heltab2x2(:,:,9))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(9),n2h1(9))
  call Hloop_VQ_A(ntryL,G1H2(26),ex5(:),G1H1(1),m3h2x1(:,10),heltab2x2(:,:,10))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),16,0,G2tensor(10),n2h1(10))
  call Hloop_VQ_A(ntryL,G1H2(31),ex5(:),G1H1(1),m3h2x1(:,11),heltab2x2(:,:,11))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(11),n2h1(11))
  call Hloop_VQ_A(ntryL,G1H2(32),ex5(:),G1H1(1),m3h2x1(:,12),heltab2x2(:,:,12))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),16,0,G2tensor(12),n2h1(12))
  call Hloop_VQ_A(ntryL,G1H2(37),ex5(:),G1H1(1),m3h2x1(:,13),heltab2x2(:,:,13))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(13),n2h1(13))
  call Hloop_VQ_A(ntryL,G1H2(38),ex5(:),G1H1(1),m3h2x1(:,14),heltab2x2(:,:,14))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),16,0,G2tensor(14),n2h1(14))
  call Hloop_VQ_A(ntryL,G1H2(43),ex5(:),G1H1(1),m3h2x1(:,15),heltab2x2(:,:,15))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(15),n2h1(15))
  call Hloop_VQ_A(ntryL,G1H2(44),ex5(:),G1H1(1),m3h2x1(:,16),heltab2x2(:,:,16))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),16,0,G2tensor(16),n2h1(16))
  call Hotf_5pt_reduction_last(G2tensor(1),RedSet_5(1),mass5set(:,1),  & 
G1tensor(1),G1tensor(2),G1tensor(3),G1tensor(4),G1tensor(5),G1tensor(6))
  call G_TensorShift(G1tensor(2),16)
  call Hotf_5pt_reduction_last(G2tensor(3),RedSet_5(2),mass5set(:,2),  & 
G1tensor(7),G1tensor(8),G1tensor(9),G1tensor(10),G1tensor(11),G1tensor(12))
  call G_TensorShift(G1tensor(8),16)
  call Hotf_5pt_reduction_last(G2tensor(5),RedSet_5(3),mass5set(:,1),  & 
G1tensor(13),G1tensor(14),G1tensor(15),G1tensor(16),G1tensor(17),G1tensor(18))
  call G_TensorShift(G1tensor(14),16)
  call Hotf_5pt_reduction_last(G2tensor(7),RedSet_5(4),mass5set(:,2),  & 
G1tensor(19),G1tensor(20),G1tensor(21),G1tensor(22),G1tensor(23),G1tensor(24))
  call G_TensorShift(G1tensor(20),16)
  call Hotf_5pt_reduction_last(G2tensor(9),RedSet_5(5),mass5set(:,1),  & 
G1tensor(25),G1tensor(26),G1tensor(27),G1tensor(28),G1tensor(29),G1tensor(30))
  call G_TensorShift(G1tensor(26),16)
  call Hotf_5pt_reduction_last(G2tensor(11),RedSet_5(6),mass5set(:,1),  & 
G1tensor(31),G1tensor(32),G1tensor(33),G1tensor(34),G1tensor(35),G1tensor(36))
  call G_TensorShift(G1tensor(32),16)
  call Hotf_5pt_reduction_last(G2tensor(13),RedSet_5(7),mass5set(:,2),  & 
G1tensor(37),G1tensor(38),G1tensor(39),G1tensor(40),G1tensor(41),G1tensor(42))
  call G_TensorShift(G1tensor(38),16)
  call Hotf_5pt_reduction_last(G2tensor(15),RedSet_5(8),mass5set(:,2),  & 
G1tensor(43),G1tensor(44),G1tensor(45),G1tensor(46),G1tensor(47),G1tensor(48))
  call G_TensorShift(G1tensor(44),16)
  call ol_merge_tensors(T1sum(1),[G1tensor(1)])
  call ol_merge_tensors(T1sum(2),[G1tensor(7)])
  call ol_merge_tensors(T1sum(3),[G1tensor(13)])
  call ol_merge_tensors(T1sum(4),[G1tensor(19)])
  call ol_merge_tensors(T1sum(5),[G1tensor(25)])
  call ol_merge_tensors(T1sum(6),[G1tensor(31)])
  call ol_merge_tensors(T1sum(7),[G1tensor(37)])
  call ol_merge_tensors(T1sum(8),[G1tensor(43)])
  Gcoeff(:)%j = (c(12)*M(1,:)%j+c(15)*(-M(2,:)%j-M(3,:)%j)+c(13)*M(4,:)%j+c(20)*M(5,:)%j-c(16)*M(6,:)%j) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(9),h0tab(:,9),[32,3,16,4,8],[0,0,0,nMT,0],5,1,wf4(:,1))
  call Hloop_VA_Q(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,9),heltab2x64(:,:,9))
  call Hloop_A_Q(ntryL,G0H32(1),32,0,G1H32(1),n2h32(1))
  Gcoeff(:)%j = (c(3)*(M(2,:)%j-M(3,:)%j)+c(4)*(-M(1,:)%j+M(5,:)%j)) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(10),h0tab(:,10),[32,3,8,4,16],[0,0,nMT,0,0],5,1,wf4(:,1))
  call Hloop_QA_V(ntryL,G0H64(1),ex6(:),G0H32(2),m3h2x32(:,10),heltab2x64(:,:,10))
  Gcoeff(:)%j = (c(12)*M(1,:)%j+c(15)*(-M(2,:)%j-M(3,:)%j)+c(13)*M(4,:)%j-c(11)*M(6,:)%j) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(11),h0tab(:,11),[32,3,16,8,4],[0,0,0,nMT,0],5,1,wf4(:,1))
  call Hloop_VA_Q(ntryL,G0H64(1),ex6(:),G0H32(3),m3h2x32(:,11),heltab2x64(:,:,11))
  call Hloop_A_Q(ntryL,G0H32(3),32,0,G1H32(2),n2h32(2))
  Gcoeff(:)%j = (-(c(3)*M(2,:)%j)-c(5)*M(3,:)%j+c(4)*M(4,:)%j) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(12),h0tab(:,12),[32,4,8,3,16],[0,nMT,0,0,0],5,1,wf4(:,1))
  call Hloop_QA_V(ntryL,G0H64(1),ex6(:),G0H32(4),m3h2x32(:,12),heltab2x64(:,:,12))
  Gcoeff(:)%j = (-(c(5)*M(2,:)%j)-c(3)*M(3,:)%j+c(4)*M(4,:)%j) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(13),h0tab(:,13),[32,3,4,8,16],[0,0,nMT,0,0],5,1,wf4(:,1))
  call Hloop_QA_V(ntryL,G0H64(1),ex6(:),G0H32(5),m3h2x32(:,13),heltab2x64(:,:,13))
  Gcoeff(:)%j = (c(3)*(-M(2,:)%j+M(3,:)%j)+c(4)*(-M(1,:)%j+M(5,:)%j)) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(14),h0tab(:,14),[32,8,4,3,16],[0,nMT,0,0,0],5,1,wf4(:,1))
  call Hloop_QA_V(ntryL,G0H64(1),ex6(:),G0H32(6),m3h2x32(:,14),heltab2x64(:,:,14))
  Gcoeff(:)%j = (c(20)*M(1,:)%j+c(15)*(-M(2,:)%j-M(3,:)%j)+c(13)*M(4,:)%j+c(12)*M(5,:)%j-c(16)*M(6,:)%j) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(15),h0tab(:,15),[32,8,3,4,16],[0,nMT,nMT,0,0],5,1,wf4(:,1))
  call Hloop_QA_V(ntryL,G0H64(1),ex6(:),G0H32(7),m3h2x32(:,15),heltab2x64(:,:,15))
  Gcoeff(:)%j = (c(15)*(-M(2,:)%j-M(3,:)%j)+c(13)*M(4,:)%j+c(12)*M(5,:)%j-c(11)*M(6,:)%j) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(16),h0tab(:,16),[32,4,3,8,16],[0,nMT,nMT,0,0],5,1,wf4(:,1))
  call Hloop_QA_V(ntryL,G0H64(1),ex6(:),G0H32(8),m3h2x32(:,16),heltab2x64(:,:,16))
  Gcoeff(:)%j = (c(13)*M(1,:)%j+c(15)*(-M(2,:)%j-M(3,:)%j)+c(12)*M(4,:)%j+c(20)*M(5,:)%j-c(16)*M(6,:)%j) * den(2)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(17),h0tab(:,17),[32,2,1,16,12],[0,0,0,0,0],5,1,wf4(:,2))
  call Hloop_QA_V(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,17),heltab2x64(:,:,17))
  Gcoeff(:)%j = (c(3)*(-M(2,:)%j+M(3,:)%j)+c(4)*(-M(4,:)%j+M(5,:)%j)) * den(2)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(18),h0tab(:,18),[32,12,2,1,16],[0,0,0,0,0],5,1,wf4(:,2))
  call Hloop_QA_V(ntryL,G0H64(1),ex6(:),G0H32(3),m3h2x32(:,18),heltab2x64(:,:,18))
  Gcoeff(:)%j = (c(13)*M(1,:)%j+c(15)*(-M(2,:)%j-M(3,:)%j)+c(12)*M(4,:)%j-c(11)*M(6,:)%j) * den(2)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(19),h0tab(:,19),[32,1,2,16,12],[0,0,0,0,0],5,1,wf4(:,2))
  call Hloop_QA_V(ntryL,G0H64(1),ex6(:),G0H32(9),m3h2x32(:,19),heltab2x64(:,:,19))
  Gcoeff(:)%j = (c(4)*M(1,:)%j-c(5)*M(2,:)%j-c(3)*M(3,:)%j) * den(2)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(20),h0tab(:,20),[32,1,2,12,16],[0,0,0,0,0],5,1,wf4(:,2))
  call Hloop_QA_V(ntryL,G0H64(1),ex6(:),G0H32(10),m3h2x32(:,20),heltab2x64(:,:,20))
  Gcoeff(:)%j = (c(4)*M(1,:)%j-c(3)*M(2,:)%j-c(5)*M(3,:)%j) * den(2)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(21),h0tab(:,21),[32,12,1,2,16],[0,0,0,0,0],5,1,wf4(:,2))
  call Hloop_QA_V(ntryL,G0H64(1),ex6(:),G0H32(11),m3h2x32(:,21),heltab2x64(:,:,21))
  Gcoeff(:)%j = (c(3)*(M(2,:)%j-M(3,:)%j)+c(4)*(-M(4,:)%j+M(5,:)%j)) * den(2)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(22),h0tab(:,22),[32,2,1,12,16],[0,0,0,0,0],5,1,wf4(:,2))
  call Hloop_QA_V(ntryL,G0H64(1),ex6(:),G0H32(12),m3h2x32(:,22),heltab2x64(:,:,22))
  Gcoeff(:)%j = (c(13)*M(1,:)%j+c(15)*(-M(2,:)%j-M(3,:)%j)+c(20)*M(4,:)%j+c(12)*M(5,:)%j-c(16)*M(6,:)%j) * den(2)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(23),h0tab(:,23),[32,2,12,1,16],[0,0,0,0,0],5,1,wf4(:,2))
  call Hloop_QA_V(ntryL,G0H64(1),ex6(:),G0H32(13),m3h2x32(:,23),heltab2x64(:,:,23))
  Gcoeff(:)%j = (c(13)*M(1,:)%j+c(15)*(-M(2,:)%j-M(3,:)%j)+c(12)*M(5,:)%j-c(11)*M(6,:)%j) * den(2)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(24),h0tab(:,24),[32,1,12,2,16],[0,0,0,0,0],5,1,wf4(:,2))
  call Hloop_QA_V(ntryL,G0H64(1),ex6(:),G0H32(14),m3h2x32(:,24),heltab2x64(:,:,24))
  Gcoeff(:)%j = (c(20)*M(1,:)%j+c(15)*(-M(2,:)%j-M(3,:)%j)+c(12)*M(4,:)%j+c(13)*M(5,:)%j-c(16)*M(6,:)%j) * den(3)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(25),h0tab(:,25),[48,4,1,2,8],[nMT,0,0,0,nMT],5,1,wf4(:,3))
  call Hloop_AV_Q(ntryL,G0H64(1),wf4(:,3),G0H16(1),m3h4x16(:,1),heltab2x64(:,:,25))
  call Hloop_A_Q(ntryL,G0H16(1),48,nMT,G1H16(1),n2h16(9))
  Gcoeff(:)%j = (c(3)*(M(2,:)%j-M(3,:)%j)+c(4)*(M(1,:)%j-M(4,:)%j)) * den(3)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(26),h0tab(:,26),[48,2,1,4,8],[0,0,0,nMT,0],5,1,wf4(:,3))
  call Hloop_UV_W(ntryL,G0H64(1),0,wf4(:,3),48,G1H16(2),m3h4x16(:,2),heltab2x64(:,:,26))
  Gcoeff(:)%j = (c(15)*(-M(2,:)%j-M(3,:)%j)+c(12)*M(4,:)%j+c(13)*M(5,:)%j-c(11)*M(6,:)%j) * den(3)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(27),h0tab(:,27),[48,4,2,1,8],[nMT,0,0,0,nMT],5,1,wf4(:,3))
  call Hloop_AV_Q(ntryL,G0H64(1),wf4(:,3),G0H16(1),m3h4x16(:,3),heltab2x64(:,:,27))
  call Hloop_A_Q(ntryL,G0H16(1),48,nMT,G1H16(3),n2h16(10))
  Gcoeff(:)%j = (c(3)*M(2,:)%j+c(5)*M(3,:)%j-c(4)*M(5,:)%j) * den(3)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(28),h0tab(:,28),[48,2,1,8,4],[0,0,0,nMT,0],5,1,wf4(:,3))
  call Hloop_UV_W(ntryL,G0H64(1),0,wf4(:,3),48,G1H16(4),m3h4x16(:,4),heltab2x64(:,:,28))
  Gcoeff(:)%j = (-(c(5)*M(2,:)%j)-c(3)*M(3,:)%j+c(4)*M(5,:)%j) * den(3)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(29),h0tab(:,29),[48,1,2,4,8],[0,0,0,nMT,0],5,1,wf4(:,3))
  call Hloop_UV_W(ntryL,G0H64(1),0,wf4(:,3),48,G1H16(5),m3h4x16(:,5),heltab2x64(:,:,29))
  Gcoeff(:)%j = (c(3)*(M(2,:)%j-M(3,:)%j)+c(4)*(-M(1,:)%j+M(4,:)%j)) * den(3)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(30),h0tab(:,30),[48,1,2,8,4],[0,0,0,nMT,0],5,1,wf4(:,3))
  call Hloop_UV_W(ntryL,G0H64(1),0,wf4(:,3),48,G1H16(6),m3h4x16(:,6),heltab2x64(:,:,30))
  Gcoeff(:)%j = (c(12)*M(1,:)%j+c(15)*(-M(2,:)%j-M(3,:)%j)+c(20)*M(4,:)%j+c(13)*M(5,:)%j-c(16)*M(6,:)%j) * den(3)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(31),h0tab(:,31),[48,1,4,8,2],[0,0,nMT,0,0],5,1,wf4(:,3))
  call Hloop_AV_Q(ntryL,G0H64(1),wf4(:,3),G0H16(1),m3h4x16(:,7),heltab2x64(:,:,31))
  call Hloop_A_Q(ntryL,G0H16(1),48,0,G1H16(7),n2h16(11))
  Gcoeff(:)%j = (c(12)*M(1,:)%j+c(15)*(-M(2,:)%j-M(3,:)%j)+c(13)*M(5,:)%j-c(11)*M(6,:)%j) * den(3)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(32),h0tab(:,32),[48,1,8,4,2],[0,0,nMT,0,0],5,1,wf4(:,3))
  call Hloop_AV_Q(ntryL,G0H64(1),wf4(:,3),G0H16(1),m3h4x16(:,8),heltab2x64(:,:,32))
  call Hloop_A_Q(ntryL,G0H16(1),48,0,G1H16(8),n2h16(12))
  call Hloop_AV_Q(ntryL,G1H32(1),wf4(:,1),G1H8(1),m3h4x8(:,1),heltab2x32(:,:,9))
  call Hloop_A_Q(ntryL,G1H8(1),35,0,G2H8(1),n2h8(1))
  call Hloop_UV_W(ntryL,G0H32(2),32,wf4(:,1),3,G1H8(2),m3h4x8(:,2),heltab2x32(:,:,10))
  call Hloop_AV_Q(ntryL,G1H32(2),wf4(:,1),G1H8(3),m3h4x8(:,3),heltab2x32(:,:,11))
  call Hloop_A_Q(ntryL,G1H8(3),35,0,G2H8(2),n2h8(2))
  call Hloop_VQ_A(ntryL,G0H32(4),ex3(:),G0H16(1),m3h2x16(:,9),heltab2x32(:,:,12))
  call Hloop_Q_A(ntryL,G0H16(1),36,nMT,G1H16(9),n2h16(13))
  call Hloop_UV_W(ntryL,G0H32(5),32,wf4(:,1),3,G1H8(4),m3h4x8(:,4),heltab2x32(:,:,13))
  call Hloop_VA_Q(ntryL,G0H32(6),ex4(:),G0H16(1),m3h2x16(:,10),heltab2x32(:,:,14))
  call Hloop_A_Q(ntryL,G0H16(1),40,nMT,G1H16(10),n2h16(14))
  call Hloop_VA_Q(ntryL,G0H32(7),ex4(:),G0H16(1),m3h2x16(:,11),heltab2x32(:,:,15))
  call Hloop_A_Q(ntryL,G0H16(1),40,nMT,G1H16(11),n2h16(15))
  call Hloop_VQ_A(ntryL,G0H32(8),ex3(:),G0H16(1),m3h2x16(:,12),heltab2x32(:,:,16))
  call Hloop_Q_A(ntryL,G0H16(1),36,nMT,G1H16(12),n2h16(16))
  call Hloop_VA_Q(ntryL,G0H32(1),ex2(:),G0H16(1),m3h2x16(:,13),heltab2x32(:,:,17))
  call Hloop_A_Q(ntryL,G0H16(1),34,0,G1H16(13),n2h16(17))
  call Hloop_UV_W(ntryL,G0H32(3),32,wf4(:,2),12,G1H8(5),m3h4x8(:,5),heltab2x32(:,:,18))
  call Hloop_VQ_A(ntryL,G0H32(9),ex1(:),G0H16(1),m3h2x16(:,14),heltab2x32(:,:,19))
  call Hloop_Q_A(ntryL,G0H16(1),33,0,G1H16(14),n2h16(18))
  call Hloop_VQ_A(ntryL,G0H32(10),ex1(:),G0H16(1),m3h2x16(:,15),heltab2x32(:,:,20))
  call Hloop_Q_A(ntryL,G0H16(1),33,0,G1H16(15),n2h16(19))
  call Hloop_UV_W(ntryL,G0H32(11),32,wf4(:,2),12,G1H8(6),m3h4x8(:,6),heltab2x32(:,:,21))
  call Hloop_VA_Q(ntryL,G0H32(12),ex2(:),G0H16(1),m3h2x16(:,16),heltab2x32(:,:,22))
  call Hloop_A_Q(ntryL,G0H16(1),34,0,G1H16(16),n2h16(20))
  call Hloop_VA_Q(ntryL,G0H32(13),ex2(:),G0H16(1),m3h2x16(:,17),heltab2x32(:,:,23))
  call Hloop_A_Q(ntryL,G0H16(1),34,0,G1H16(17),n2h16(21))
  call Hloop_VQ_A(ntryL,G0H32(14),ex1(:),G0H16(1),m3h2x16(:,18),heltab2x32(:,:,24))
  call Hloop_Q_A(ntryL,G0H16(1),33,0,G1H16(18),n2h16(22))
  call Hloop_AQ_V(ntryL,G1H16(1),ex3(:),G1H8(7),m3h2x8(:,9),heltab2x16(:,:,9))
  call Hloop_VA_Q(ntryL,G1H16(2),ex2(:),G1H8(8),m3h2x8(:,10),heltab2x16(:,:,10))
  call Hloop_A_Q(ntryL,G1H8(8),50,0,G2H8(3),n2h8(3))
  call Hloop_AQ_V(ntryL,G1H16(3),ex3(:),G1H8(1),m3h2x8(:,11),heltab2x16(:,:,11))
  call Hloop_VA_Q(ntryL,G1H16(4),ex2(:),G1H8(3),m3h2x8(:,12),heltab2x16(:,:,12))
  call Hloop_A_Q(ntryL,G1H8(3),50,0,G2H8(4),n2h8(4))
  call Hloop_VQ_A(ntryL,G1H16(5),ex1(:),G1H8(8),m3h2x8(:,13),heltab2x16(:,:,13))
  call Hloop_Q_A(ntryL,G1H8(8),49,0,G2H8(5),n2h8(5))
  call Hloop_VQ_A(ntryL,G1H16(6),ex1(:),G1H8(3),m3h2x8(:,14),heltab2x16(:,:,14))
  call Hloop_Q_A(ntryL,G1H8(3),49,0,G2H8(6),n2h8(6))
  call Hloop_AQ_V(ntryL,G1H16(7),ex1(:),G1H8(8),m3h2x8(:,15),heltab2x16(:,:,15))
  call Hloop_AQ_V(ntryL,G1H16(8),ex1(:),G1H8(3),m3h2x8(:,16),heltab2x16(:,:,16))
  call Hloop_AQ_V(ntryL,G2H8(1),ex5(:),G2H4(1),m3h2x4(:,9),heltab2x8(:,:,9))
  call Hloop_VA_Q(ntryL,G1H8(2),ex4(:),G1H4(1),m3h2x4(:,10),heltab2x8(:,:,10))
  call Hloop_A_Q(ntryL,G1H4(1),43,nMT,G2H4(2),n2h4(9))
  call Hloop_AQ_V(ntryL,G2H8(2),ex5(:),G2H4(3),m3h2x4(:,11),heltab2x8(:,:,11))
  call Hloop_QA_V(ntryL,G1H16(9),ex4(:),G1H8(2),m3h2x8(:,17),heltab2x16(:,:,17))
  call Hloop_VQ_A(ntryL,G1H8(4),ex3(:),G1H4(1),m3h2x4(:,12),heltab2x8(:,:,12))
  call Hloop_Q_A(ntryL,G1H4(1),39,nMT,G2H4(4),n2h4(10))
  call Hloop_AQ_V(ntryL,G1H16(10),ex3(:),G1H8(4),m3h2x8(:,18),heltab2x16(:,:,18))
  call Hloop_AV_Q(ntryL,G1H16(11),wf4(:,1),G1H4(1),m3h4x4(:,1),heltab2x16(:,:,19))
  call Hloop_A_Q(ntryL,G1H4(1),43,nMT,G2H4(5),n2h4(11))
  call Hloop_QV_A(ntryL,G1H16(12),wf4(:,1),G1H4(1),m3h4x4(:,2),heltab2x16(:,:,20))
  call Hloop_Q_A(ntryL,G1H4(1),39,nMT,G2H4(6),n2h4(12))
  call Hloop_AQ_V(ntryL,G1H16(13),ex1(:),G1H8(9),m3h2x8(:,19),heltab2x16(:,:,21))
  call Hloop_VA_Q(ntryL,G1H8(5),ex2(:),G1H4(1),m3h2x4(:,13),heltab2x8(:,:,13))
  call Hloop_A_Q(ntryL,G1H4(1),46,0,G2H4(7),n2h4(13))
  call Hloop_QA_V(ntryL,G1H16(14),ex2(:),G1H8(5),m3h2x8(:,20),heltab2x16(:,:,22))
  call Hloop_QA_V(ntryL,G1H16(15),ex2(:),G1H8(10),m3h2x8(:,21),heltab2x16(:,:,23))
  call Hloop_VQ_A(ntryL,G1H8(6),ex1(:),G1H4(1),m3h2x4(:,14),heltab2x8(:,:,14))
  call Hloop_Q_A(ntryL,G1H4(1),45,0,G2H4(8),n2h4(14))
  call Hloop_AQ_V(ntryL,G1H16(16),ex1(:),G1H8(6),m3h2x8(:,22),heltab2x16(:,:,24))
  call Hloop_AV_Q(ntryL,G1H16(17),wf4(:,2),G1H4(1),m3h4x4(:,3),heltab2x16(:,:,25))
  call Hloop_A_Q(ntryL,G1H4(1),46,0,G2H4(9),n2h4(15))
  call Hloop_QV_A(ntryL,G1H16(18),wf4(:,2),G1H4(1),m3h4x4(:,4),heltab2x16(:,:,26))
  call Hloop_Q_A(ntryL,G1H4(1),45,0,G2H4(10),n2h4(16))
  call Hloop_VQ_A(ntryL,G1H8(7),ex1(:),G1H4(1),m3h2x4(:,15),heltab2x8(:,:,15))
  call Hloop_Q_A(ntryL,G1H4(1),53,0,G2H4(11),n2h4(17))
  call Hloop_AQ_V(ntryL,G2H8(3),ex1(:),G2H4(12),m3h2x4(:,16),heltab2x8(:,:,16))
  call Hloop_VA_Q(ntryL,G1H8(1),ex2(:),G1H4(1),m3h2x4(:,17),heltab2x8(:,:,17))
  call Hloop_A_Q(ntryL,G1H4(1),54,0,G2H4(13),n2h4(18))
  call Hloop_AQ_V(ntryL,G2H8(4),ex1(:),G2H4(14),m3h2x4(:,18),heltab2x8(:,:,18))
  call Hloop_QA_V(ntryL,G2H8(5),ex2(:),G2H4(15),m3h2x4(:,19),heltab2x8(:,:,19))
  call Hloop_QA_V(ntryL,G2H8(6),ex2(:),G2H4(16),m3h2x4(:,20),heltab2x8(:,:,20))
  call Hloop_VQ_A(ntryL,G1H8(8),ex3(:),G1H4(1),m3h2x4(:,21),heltab2x8(:,:,21))
  call Hloop_Q_A(ntryL,G1H4(1),53,nMT,G2H4(17),n2h4(19))
  call Hloop_VA_Q(ntryL,G1H8(3),ex4(:),G1H4(1),m3h2x4(:,22),heltab2x8(:,:,22))
  call Hloop_A_Q(ntryL,G1H4(1),57,nMT,G2H4(18),n2h4(20))
  call Hotf_5pt_reduction(G2H4(1),RedSet_5(9),mass5set(:,2),  & 
G1H4(1),G1H4(2),G1H4(3),G1H4(4),G1H4(5),G1H4(6),4)
  call HG1shiftOLR(G1H4(2),8,4)
  call Hloop_AQ_V(ntryL,G2H4(2),ex3(:),G2H2(1),m3h2x2(:,9),heltab2x4(:,:,9))
  call Hotf_5pt_reduction(G2H4(3),RedSet_5(10),mass5set(:,2),  & 
G1H4(7),G1H4(8),G1H4(9),G1H4(10),G1H4(11),G1H4(12),4)
  call HG1shiftOLR(G1H4(8),4,4)
  call Hloop_UV_W(ntryL,G1H8(2),44,wf4(:,1),3,G2H2(2),m3h4x2(:,1),heltab2x8(:,:,23))
  call Hloop_QA_V(ntryL,G2H4(4),ex4(:),G2H2(3),m3h2x2(:,10),heltab2x4(:,:,10))
  call Hloop_UV_W(ntryL,G1H8(4),44,wf4(:,1),3,G2H2(4),m3h4x2(:,2),heltab2x8(:,:,24))
  call Hloop_AQ_V(ntryL,G2H4(5),ex3(:),G2H2(5),m3h2x2(:,11),heltab2x4(:,:,11))
  call Hloop_QA_V(ntryL,G2H4(6),ex4(:),G2H2(6),m3h2x2(:,12),heltab2x4(:,:,12))
  call Hloop_VQ_A(ntryL,G1H8(9),ex5(:),G1H4(13),m3h2x4(:,23),heltab2x8(:,:,25))
  call Hloop_Q_A(ntryL,G1H4(13),51,0,G2H4(1),n2h4(21))
  call Hloop_AQ_V(ntryL,G2H4(7),ex1(:),G2H2(7),m3h2x2(:,13),heltab2x4(:,:,13))
  call Hloop_VQ_A(ntryL,G1H8(5),ex5(:),G1H4(13),m3h2x4(:,24),heltab2x8(:,:,26))
  call Hloop_Q_A(ntryL,G1H4(13),51,0,G2H4(2),n2h4(22))
  call Hloop_UV_W(ntryL,G1H8(10),35,wf4(:,2),12,G2H2(8),m3h4x2(:,3),heltab2x8(:,:,27))
  call Hloop_QA_V(ntryL,G2H4(8),ex2(:),G2H2(9),m3h2x2(:,14),heltab2x4(:,:,14))
  call Hloop_UV_W(ntryL,G1H8(6),35,wf4(:,2),12,G2H2(10),m3h4x2(:,4),heltab2x8(:,:,28))
  call Hloop_AQ_V(ntryL,G2H4(9),ex1(:),G2H2(11),m3h2x2(:,15),heltab2x4(:,:,15))
  call Hloop_QA_V(ntryL,G2H4(10),ex2(:),G2H2(12),m3h2x2(:,16),heltab2x4(:,:,16))
  call Hloop_QA_V(ntryL,G2H4(11),ex2(:),G2H2(13),m3h2x2(:,17),heltab2x4(:,:,17))
  call Hotf_5pt_reduction(G2H4(12),RedSet_5(11),mass5set(:,2),  & 
G1H4(13),G1H4(14),G1H4(15),G1H4(16),G1H4(17),G1H4(18),4)
  call HG1shiftOLR(G1H4(14),8,4)
  call Hloop_AQ_V(ntryL,G2H4(13),ex1(:),G2H2(14),m3h2x2(:,18),heltab2x4(:,:,18))
  call Hotf_5pt_reduction(G2H4(14),RedSet_5(12),mass5set(:,2),  & 
G1H4(19),G1H4(20),G1H4(21),G1H4(22),G1H4(23),G1H4(24),4)
  call HG1shiftOLR(G1H4(20),4,4)
  call Hotf_5pt_reduction(G2H4(15),RedSet_5(13),mass5set(:,2),  & 
G1H4(25),G1H4(26),G1H4(27),G1H4(28),G1H4(29),G1H4(30),4)
  call HG1shiftOLR(G1H4(26),8,4)
  call Hotf_5pt_reduction(G2H4(16),RedSet_5(14),mass5set(:,2),  & 
G1H4(31),G1H4(32),G1H4(33),G1H4(34),G1H4(35),G1H4(36),4)
  call HG1shiftOLR(G1H4(32),4,4)
  call Hloop_QA_V(ntryL,G2H4(17),ex4(:),G2H2(15),m3h2x2(:,19),heltab2x4(:,:,19))
  call Hloop_AQ_V(ntryL,G2H4(18),ex3(:),G2H2(16),m3h2x2(:,20),heltab2x4(:,:,20))
  call Hloop_VQ_A(ntryL,G1H4(1),ex3(:),G1H2(1),m3h2x2(:,21),heltab2x4(:,:,21))
  call Hloop_Q_A(ntryL,G1H2(1),55,nMT,G2H2(17),n2h2(1))
call HGT_raise_alpha_OLR(G1H4(2),1,1,4)
call HGT_raise_alpha_invQ_OLR(G1H4(2),2,5,4)
  call Hloop_VA_Q(ntryL,G1H4(2),ex4(:),G1H2(2),m3h2x2(:,22),heltab2x4(:,:,22))
  call Hloop_VQ_A(ntryL,G1H4(5),ex3(:),G1H2(7),m3h2x2(:,23),heltab2x4(:,:,23))
  call Hloop_Q_A(ntryL,G1H2(7),55,nMT,G2H2(18),n2h2(2))
  call Hloop_VQ_A(ntryL,G1H4(6),ex3(:),G1H2(8),m3h2x2(:,24),heltab2x4(:,:,24))
  call Hloop_Q_A(ntryL,G1H2(8),55,nMT,G2H2(19),n2h2(3))
  call Hloop_VA_Q(ntryL,G1H4(7),ex4(:),G1H2(13),m3h2x2(:,25),heltab2x4(:,:,25))
  call Hloop_A_Q(ntryL,G1H2(13),59,nMT,G2H2(20),n2h2(4))
call HGT_raise_alpha_OLR(G1H4(8),1,1,4)
call HGT_raise_alpha_invQ_OLR(G1H4(8),2,5,4)
  call Hloop_VQ_A(ntryL,G1H4(8),ex3(:),G1H2(14),m3h2x2(:,26),heltab2x4(:,:,26))
  call Hloop_VA_Q(ntryL,G1H4(11),ex4(:),G1H2(19),m3h2x2(:,27),heltab2x4(:,:,27))
  call Hloop_A_Q(ntryL,G1H2(19),59,nMT,G2H2(21),n2h2(5))
  call Hloop_VA_Q(ntryL,G1H4(12),ex4(:),G1H2(20),m3h2x2(:,28),heltab2x4(:,:,28))
  call Hloop_A_Q(ntryL,G1H2(20),59,nMT,G2H2(22),n2h2(6))
  call Hloop_VQ_A(ntryL,G1H4(13),ex3(:),G1H2(25),m3h2x2(:,29),heltab2x4(:,:,29))
  call Hloop_Q_A(ntryL,G1H2(25),55,nMT,G2H2(23),n2h2(7))
call HGT_raise_alpha_OLR(G1H4(14),1,1,4)
call HGT_raise_alpha_invQ_OLR(G1H4(14),2,5,4)
  call Hloop_VA_Q(ntryL,G1H4(14),ex4(:),G1H2(26),m3h2x2(:,30),heltab2x4(:,:,30))
  call Hloop_VQ_A(ntryL,G1H4(17),ex3(:),G1H2(31),m3h2x2(:,31),heltab2x4(:,:,31))
  call Hloop_Q_A(ntryL,G1H2(31),55,nMT,G2H2(24),n2h2(8))
  call Hloop_VQ_A(ntryL,G1H4(18),ex3(:),G1H2(32),m3h2x2(:,32),heltab2x4(:,:,32))
  call Hloop_Q_A(ntryL,G1H2(32),55,nMT,G2H2(25),n2h2(9))
  call Hloop_VA_Q(ntryL,G1H4(19),ex4(:),G1H2(37),m3h2x2(:,33),heltab2x4(:,:,33))
  call Hloop_A_Q(ntryL,G1H2(37),59,nMT,G2H2(26),n2h2(10))
call HGT_raise_alpha_OLR(G1H4(20),1,1,4)
call HGT_raise_alpha_invQ_OLR(G1H4(20),2,5,4)
  call Hloop_VQ_A(ntryL,G1H4(20),ex3(:),G1H2(38),m3h2x2(:,34),heltab2x4(:,:,34))
  call Hloop_VA_Q(ntryL,G1H4(23),ex4(:),G1H2(43),m3h2x2(:,35),heltab2x4(:,:,35))
  call Hloop_A_Q(ntryL,G1H2(43),59,nMT,G2H2(27),n2h2(11))
  call Hloop_VA_Q(ntryL,G1H4(24),ex4(:),G1H2(44),m3h2x2(:,36),heltab2x4(:,:,36))
  call Hloop_A_Q(ntryL,G1H2(44),59,nMT,G2H2(28),n2h2(12))
  call Hloop_VQ_A(ntryL,G1H4(25),ex3(:),G1H2(1),m3h2x2(:,37),heltab2x4(:,:,37))
  call Hloop_Q_A(ntryL,G1H2(1),55,nMT,G2H2(29),n2h2(13))
call HGT_raise_alpha_OLR(G1H4(26),1,1,4)
call HGT_raise_alpha_invQ_OLR(G1H4(26),2,5,4)
  call Hloop_VA_Q(ntryL,G1H4(26),ex4(:),G1H2(7),m3h2x2(:,38),heltab2x4(:,:,38))
  call Hloop_VQ_A(ntryL,G1H4(29),ex3(:),G1H2(8),m3h2x2(:,39),heltab2x4(:,:,39))
  call Hloop_Q_A(ntryL,G1H2(8),55,nMT,G2H2(30),n2h2(14))
  call Hloop_VQ_A(ntryL,G1H4(30),ex3(:),G1H2(13),m3h2x2(:,40),heltab2x4(:,:,40))
  call Hloop_Q_A(ntryL,G1H2(13),55,nMT,G2H2(31),n2h2(15))
  call Hloop_VA_Q(ntryL,G1H4(31),ex4(:),G1H2(19),m3h2x2(:,41),heltab2x4(:,:,41))
  call Hloop_A_Q(ntryL,G1H2(19),59,nMT,G2H2(32),n2h2(16))
call HGT_raise_alpha_OLR(G1H4(32),1,1,4)
call HGT_raise_alpha_invQ_OLR(G1H4(32),2,5,4)
  call Hloop_VQ_A(ntryL,G1H4(32),ex3(:),G1H2(20),m3h2x2(:,42),heltab2x4(:,:,42))
  call Hloop_VA_Q(ntryL,G1H4(35),ex4(:),G1H2(25),m3h2x2(:,43),heltab2x4(:,:,43))
  call Hloop_A_Q(ntryL,G1H2(25),59,nMT,G2H2(33),n2h2(17))
  call Hloop_VA_Q(ntryL,G1H4(36),ex4(:),G1H2(31),m3h2x2(:,44),heltab2x4(:,:,44))
  call Hloop_A_Q(ntryL,G1H2(31),59,nMT,G2H2(34),n2h2(18))
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(9),[G1H2(16),G1H2(4)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(4),[G1H2(30),G1H2(6)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(3),[G1H2(40),G1H2(10)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(10),[G1H2(24),G1H2(12)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(2),[G1H2(36),G1H2(18)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(1),[G1H2(46),G1H2(22)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(7),[G1H2(34),G1H2(28)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(8),[G1H2(48),G1H2(42)])
  call Hloop_VQ_A(ntryL,G1H2(3),ex5(:),G1H1(1),m3h2x1(:,17),heltab2x2(:,:,17))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(1),n2h1(17))
  call Hotf_5pt_reduction(G2H2(9),RedSet_5(15),mass5set(:,3),  & 
G1H2(32),G1H2(37),G1H2(43),G1H2(44),G1H2(1),G1H2(8),2)
  call HG1shiftOLR(G1H2(37),16,2)
  call Hloop_VQ_A(ntryL,G1H2(5),ex5(:),G1H1(1),m3h2x1(:,18),heltab2x2(:,:,18))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(3),n2h1(18))
  call Hotf_5pt_reduction(G2H2(4),RedSet_5(16),mass5set(:,1),  & 
G1H2(13),G1H2(19),G1H2(25),G1H2(31),G1H2(16),G1H2(4),2)
  call HG1shiftOLR(G1H2(19),16,2)
  call Hloop_VQ_A(ntryL,G1H2(9),ex5(:),G1H1(1),m3h2x1(:,19),heltab2x2(:,:,19))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(5),n2h1(19))
  call Hotf_5pt_reduction(G2H2(3),RedSet_5(17),mass5set(:,4),  & 
G1H2(30),G1H2(6),G1H2(40),G1H2(10),G1H2(24),G1H2(12),2)
  call HG1shiftOLR(G1H2(6),16,2)
  call Hloop_VQ_A(ntryL,G1H2(11),ex5(:),G1H1(1),m3h2x1(:,20),heltab2x2(:,:,20))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(7),n2h1(20))
  call Hotf_5pt_reduction(G2H2(10),RedSet_5(18),mass5set(:,3),  & 
G1H2(36),G1H2(18),G1H2(46),G1H2(22),G1H2(34),G1H2(28),2)
  call HG1shiftOLR(G1H2(18),16,2)
  call Hloop_VQ_A(ntryL,G1H2(15),ex5(:),G1H1(1),m3h2x1(:,21),heltab2x2(:,:,21))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(9),n2h1(21))
  call Hloop_VQ_A(ntryL,G1H2(17),ex5(:),G1H1(1),m3h2x1(:,22),heltab2x2(:,:,22))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(11),n2h1(22))
  call Hotf_5pt_reduction(G2H2(2),RedSet_5(19),mass5set(:,1),  & 
G1H2(48),G1H2(42),G1H2(3),G1H2(5),G1H2(9),G1H2(11),2)
  call HG1shiftOLR(G1H2(42),16,2)
  call Hloop_VQ_A(ntryL,G1H2(21),ex5(:),G1H1(1),m3h2x1(:,23),heltab2x2(:,:,23))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(13),n2h1(23))
  call Hotf_5pt_reduction(G2H2(1),RedSet_5(20),mass5set(:,4),  & 
G1H2(15),G1H2(17),G1H2(21),G1H2(49),G1H2(50),G1H2(51),2)
  call HG1shiftOLR(G1H2(17),16,2)
  call Hloop_VQ_A(ntryL,G1H2(23),ex5(:),G1H1(1),m3h2x1(:,24),heltab2x2(:,:,24))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(15),n2h1(24))
  call Hloop_VQ_A(ntryL,G1H2(27),ex5(:),G1H1(1),m3h2x1(:,25),heltab2x2(:,:,25))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(17),n2h1(25))
  call Hotf_5pt_reduction(G2H2(7),RedSet_5(21),mass5set(:,3),  & 
G1H2(23),G1H2(27),G1H2(52),G1H2(53),G1H2(54),G1H2(55),2)
  call HG1shiftOLR(G1H2(27),16,2)
  call Hloop_VQ_A(ntryL,G1H2(29),ex5(:),G1H1(1),m3h2x1(:,26),heltab2x2(:,:,26))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(18),n2h1(26))
  call Hloop_VQ_A(ntryL,G1H2(33),ex5(:),G1H1(1),m3h2x1(:,27),heltab2x2(:,:,27))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(19),n2h1(27))
  call Hloop_VQ_A(ntryL,G1H2(35),ex5(:),G1H1(1),m3h2x1(:,28),heltab2x2(:,:,28))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(20),n2h1(28))
  call Hloop_VQ_A(ntryL,G1H2(39),ex5(:),G1H1(1),m3h2x1(:,29),heltab2x2(:,:,29))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(21),n2h1(29))
  call Hloop_VQ_A(ntryL,G1H2(41),ex5(:),G1H1(1),m3h2x1(:,30),heltab2x2(:,:,30))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(22),n2h1(30))
  call Hotf_5pt_reduction(G2H2(8),RedSet_5(22),mass5set(:,3),  & 
G1H2(29),G1H2(33),G1H2(35),G1H2(39),G1H2(41),G1H2(56),2)
  call HG1shiftOLR(G1H2(33),16,2)
  call Hloop_VQ_A(ntryL,G1H2(45),ex5(:),G1H1(1),m3h2x1(:,31),heltab2x2(:,:,31))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(23),n2h1(31))
  call Hloop_VQ_A(ntryL,G1H2(47),ex5(:),G1H1(1),m3h2x1(:,32),heltab2x2(:,:,32))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(24),n2h1(32))
  call Hotf_5pt_reduction(G2H2(5),RedSet_5(23),mass5set(:,5),  & 
G1H2(45),G1H2(47),G1H2(57),G1H2(58),G1H2(59),G1H2(60),2)
  call HG1shiftOLR(G1H2(47),16,2)
  call Hotf_5pt_reduction(G2H2(6),RedSet_5(24),mass5set(:,5),  & 
G1H2(61),G1H2(62),G1H2(63),G1H2(64),G1H2(65),G1H2(66),2)
  call HG1shiftOLR(G1H2(62),16,2)
  call Hotf_5pt_reduction(G2H4(1),RedSet_5(25),mass5set(:,3),  & 
G1H4(1),G1H4(2),G1H4(5),G1H4(6),G1H4(7),G1H4(8),4)
  call HG1shiftOLR(G1H4(2),12,4)
  call Hotf_5pt_reduction(G2H4(2),RedSet_5(26),mass5set(:,3),  & 
G1H4(11),G1H4(12),G1H4(13),G1H4(14),G1H4(17),G1H4(18),4)
  call HG1shiftOLR(G1H4(12),12,4)
  call Hotf_5pt_reduction(G2H2(11),RedSet_5(27),mass5set(:,3),  & 
G1H2(67),G1H2(68),G1H2(69),G1H2(70),G1H2(71),G1H2(72),2)
  call HG1shiftOLR(G1H2(68),16,2)
  call Hotf_5pt_reduction(G2H2(12),RedSet_5(28),mass5set(:,3),  & 
G1H2(73),G1H2(74),G1H2(75),G1H2(76),G1H2(77),G1H2(78),2)
  call HG1shiftOLR(G1H2(74),16,2)
  call Hotf_5pt_reduction(G2H2(13),RedSet_5(29),mass5set(:,6),  & 
G1H2(79),G1H2(80),G1H2(81),G1H2(82),G1H2(83),G1H2(84),2)
  call HG1shiftOLR(G1H2(80),8,2)
  call Hotf_5pt_reduction(G2H2(14),RedSet_5(30),mass5set(:,6),  & 
G1H2(85),G1H2(86),G1H2(87),G1H2(88),G1H2(89),G1H2(90),2)
  call HG1shiftOLR(G1H2(86),8,2)
  call Hotf_5pt_reduction(G2H2(15),RedSet_5(31),mass5set(:,4),  & 
G1H2(91),G1H2(92),G1H2(93),G1H2(94),G1H2(95),G1H2(96),2)
  call HG1shiftOLR(G1H2(92),2,2)
  call Hotf_5pt_reduction(G2H2(16),RedSet_5(32),mass5set(:,4),  & 
G1H2(97),G1H2(98),G1H2(99),G1H2(100),G1H2(101),G1H2(102),2)
  call HG1shiftOLR(G1H2(98),2,2)
  call Hcheck_last_QA_V(ntryL,l_switch,G2H2(17),ex4(:),G2tensor(25),m3h2x1(:,33),heltab2x2(:,:,33))
  call Hcheck_last_QA_V(ntryL,l_switch,G2H2(19),ex4(:),G2tensor(26),m3h2x1(:,34),heltab2x2(:,:,34))
  call Hcheck_last_AQ_V(ntryL,l_switch,G2H2(20),ex3(:),G2tensor(27),m3h2x1(:,35),heltab2x2(:,:,35))
  call Hcheck_last_AQ_V(ntryL,l_switch,G2H2(22),ex3(:),G2tensor(28),m3h2x1(:,36),heltab2x2(:,:,36))
  call Hcheck_last_QA_V(ntryL,l_switch,G2H2(23),ex4(:),G2tensor(29),m3h2x1(:,37),heltab2x2(:,:,37))
  call Hcheck_last_QA_V(ntryL,l_switch,G2H2(25),ex4(:),G2tensor(30),m3h2x1(:,38),heltab2x2(:,:,38))
  call Hcheck_last_AQ_V(ntryL,l_switch,G2H2(26),ex3(:),G2tensor(31),m3h2x1(:,39),heltab2x2(:,:,39))
  call Hcheck_last_AQ_V(ntryL,l_switch,G2H2(28),ex3(:),G2tensor(32),m3h2x1(:,40),heltab2x2(:,:,40))
  call Hcheck_last_QA_V(ntryL,l_switch,G2H2(29),ex4(:),G2tensor(33),m3h2x1(:,41),heltab2x2(:,:,41))
  call Hcheck_last_QA_V(ntryL,l_switch,G2H2(31),ex4(:),G2tensor(34),m3h2x1(:,42),heltab2x2(:,:,42))
  call Hcheck_last_AQ_V(ntryL,l_switch,G2H2(32),ex3(:),G2tensor(35),m3h2x1(:,43),heltab2x2(:,:,43))
  call Hcheck_last_AQ_V(ntryL,l_switch,G2H2(34),ex3(:),G2tensor(36),m3h2x1(:,44),heltab2x2(:,:,44))
  call Hloop_VQ_A(ntryL,G1H2(32),ex5(:),G1H1(1),m3h2x1(:,45),heltab2x2(:,:,45))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(37),n2h1(33))
  call Hloop_VQ_A(ntryL,G1H2(37),ex5(:),G1H1(1),m3h2x1(:,46),heltab2x2(:,:,46))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),16,0,G2tensor(38),n2h1(34))
  call Hloop_VQ_A(ntryL,G1H2(8),ex5(:),G1H1(1),m3h2x1(:,47),heltab2x2(:,:,47))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(39),n2h1(35))
  call Hloop_VQ_A(ntryL,G1H2(13),ex5(:),G1H1(1),m3h2x1(:,48),heltab2x2(:,:,48))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(40),n2h1(36))
  call Hloop_VQ_A(ntryL,G1H2(19),ex5(:),G1H1(1),m3h2x1(:,49),heltab2x2(:,:,49))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),16,0,G2tensor(41),n2h1(37))
  call Hloop_VQ_A(ntryL,G1H2(4),ex5(:),G1H1(1),m3h2x1(:,50),heltab2x2(:,:,50))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(42),n2h1(38))
  call Hloop_VQ_A(ntryL,G1H2(30),ex5(:),G1H1(1),m3h2x1(:,51),heltab2x2(:,:,51))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(43),n2h1(39))
  call Hloop_VQ_A(ntryL,G1H2(6),ex5(:),G1H1(1),m3h2x1(:,52),heltab2x2(:,:,52))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),16,0,G2tensor(44),n2h1(40))
  call Hloop_VQ_A(ntryL,G1H2(12),ex5(:),G1H1(1),m3h2x1(:,53),heltab2x2(:,:,53))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(45),n2h1(41))
  call Hloop_VQ_A(ntryL,G1H2(36),ex5(:),G1H1(1),m3h2x1(:,54),heltab2x2(:,:,54))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(46),n2h1(42))
  call Hloop_VQ_A(ntryL,G1H2(18),ex5(:),G1H1(1),m3h2x1(:,55),heltab2x2(:,:,55))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),16,0,G2tensor(47),n2h1(43))
  call Hloop_VQ_A(ntryL,G1H2(28),ex5(:),G1H1(1),m3h2x1(:,56),heltab2x2(:,:,56))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(48),n2h1(44))
  call Hloop_VQ_A(ntryL,G1H2(48),ex5(:),G1H1(1),m3h2x1(:,57),heltab2x2(:,:,57))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(49),n2h1(45))
  call Hloop_VQ_A(ntryL,G1H2(42),ex5(:),G1H1(1),m3h2x1(:,58),heltab2x2(:,:,58))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),16,0,G2tensor(50),n2h1(46))
  call Hloop_VQ_A(ntryL,G1H2(11),ex5(:),G1H1(1),m3h2x1(:,59),heltab2x2(:,:,59))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(51),n2h1(47))
  call Hloop_VQ_A(ntryL,G1H2(15),ex5(:),G1H1(1),m3h2x1(:,60),heltab2x2(:,:,60))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(52),n2h1(48))
  call Hloop_VQ_A(ntryL,G1H2(17),ex5(:),G1H1(1),m3h2x1(:,61),heltab2x2(:,:,61))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),16,0,G2tensor(53),n2h1(49))
  call Hloop_VQ_A(ntryL,G1H2(51),ex5(:),G1H1(1),m3h2x1(:,62),heltab2x2(:,:,62))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(54),n2h1(50))
  call Hloop_VQ_A(ntryL,G1H2(23),ex5(:),G1H1(1),m3h2x1(:,63),heltab2x2(:,:,63))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(55),n2h1(51))
  call Hloop_VQ_A(ntryL,G1H2(27),ex5(:),G1H1(1),m3h2x1(:,64),heltab2x2(:,:,64))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),16,0,G2tensor(56),n2h1(52))
  call Hloop_VQ_A(ntryL,G1H2(55),ex5(:),G1H1(1),m3h2x1(:,65),heltab2x2(:,:,65))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(57),n2h1(53))
  call Hloop_VQ_A(ntryL,G1H2(29),ex5(:),G1H1(1),m3h2x1(:,66),heltab2x2(:,:,66))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(58),n2h1(54))
  call Hloop_VQ_A(ntryL,G1H2(33),ex5(:),G1H1(1),m3h2x1(:,67),heltab2x2(:,:,67))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),16,0,G2tensor(59),n2h1(55))
  call Hloop_VQ_A(ntryL,G1H2(56),ex5(:),G1H1(1),m3h2x1(:,68),heltab2x2(:,:,68))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(60),n2h1(56))
  call Hloop_VQ_A(ntryL,G1H2(45),ex5(:),G1H1(1),m3h2x1(:,69),heltab2x2(:,:,69))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(61),n2h1(57))
  call Hloop_VQ_A(ntryL,G1H2(47),ex5(:),G1H1(1),m3h2x1(:,70),heltab2x2(:,:,70))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),16,0,G2tensor(62),n2h1(58))
  call Hloop_VQ_A(ntryL,G1H2(60),ex5(:),G1H1(1),m3h2x1(:,71),heltab2x2(:,:,71))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(63),n2h1(59))
  call Hloop_VQ_A(ntryL,G1H2(61),ex5(:),G1H1(1),m3h2x1(:,72),heltab2x2(:,:,72))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(64),n2h1(60))
  call Hloop_VQ_A(ntryL,G1H2(62),ex5(:),G1H1(1),m3h2x1(:,73),heltab2x2(:,:,73))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),16,0,G2tensor(65),n2h1(61))
  call Hloop_VQ_A(ntryL,G1H2(66),ex5(:),G1H1(1),m3h2x1(:,74),heltab2x2(:,:,74))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(66),n2h1(62))
  call Hloop_QV_A(ntryL,G1H4(1),wf4(:,2),G1H1(1),m3h4x1(:,1),heltab2x4(:,:,45))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(67),n2h1(63))
  call Hloop_QV_A(ntryL,G1H4(2),wf4(:,2),G1H1(1),m3h4x1(:,2),heltab2x4(:,:,46))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),12,0,G2tensor(68),n2h1(64))
  call Hloop_QV_A(ntryL,G1H4(8),wf4(:,2),G1H1(1),m3h4x1(:,3),heltab2x4(:,:,47))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(69),n2h1(65))
  call Hloop_QV_A(ntryL,G1H4(11),wf4(:,2),G1H1(1),m3h4x1(:,4),heltab2x4(:,:,48))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(70),n2h1(66))
  call Hloop_QV_A(ntryL,G1H4(12),wf4(:,2),G1H1(1),m3h4x1(:,5),heltab2x4(:,:,49))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),12,0,G2tensor(71),n2h1(67))
  call Hloop_QV_A(ntryL,G1H4(18),wf4(:,2),G1H1(1),m3h4x1(:,6),heltab2x4(:,:,50))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(72),n2h1(68))
  call Hloop_VQ_A(ntryL,G1H2(67),ex5(:),G1H1(1),m3h2x1(:,75),heltab2x2(:,:,75))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(73),n2h1(69))
  call Hloop_VQ_A(ntryL,G1H2(68),ex5(:),G1H1(1),m3h2x1(:,76),heltab2x2(:,:,76))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),16,0,G2tensor(74),n2h1(70))
  call Hloop_VQ_A(ntryL,G1H2(72),ex5(:),G1H1(1),m3h2x1(:,77),heltab2x2(:,:,77))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(75),n2h1(71))
  call Hloop_VQ_A(ntryL,G1H2(73),ex5(:),G1H1(1),m3h2x1(:,78),heltab2x2(:,:,78))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(76),n2h1(72))
  call Hloop_VQ_A(ntryL,G1H2(74),ex5(:),G1H1(1),m3h2x1(:,79),heltab2x2(:,:,79))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),16,0,G2tensor(77),n2h1(73))
  call Hloop_VQ_A(ntryL,G1H2(78),ex5(:),G1H1(1),m3h2x1(:,80),heltab2x2(:,:,80))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(78),n2h1(74))
  call Hloop_VA_Q(ntryL,G1H2(79),ex4(:),G1H1(1),m3h2x1(:,81),heltab2x2(:,:,81))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,nMT,G2tensor(79),n2h1(75))
  call Hloop_VA_Q(ntryL,G1H2(80),ex4(:),G1H1(1),m3h2x1(:,82),heltab2x2(:,:,82))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),8,nMT,G2tensor(80),n2h1(76))
  call Hloop_VA_Q(ntryL,G1H2(84),ex4(:),G1H1(1),m3h2x1(:,83),heltab2x2(:,:,83))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,nMT,G2tensor(81),n2h1(77))
  call Hloop_VA_Q(ntryL,G1H2(85),ex4(:),G1H1(1),m3h2x1(:,84),heltab2x2(:,:,84))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,nMT,G2tensor(82),n2h1(78))
  call Hloop_VA_Q(ntryL,G1H2(86),ex4(:),G1H1(1),m3h2x1(:,85),heltab2x2(:,:,85))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),8,nMT,G2tensor(83),n2h1(79))
  call Hloop_VA_Q(ntryL,G1H2(90),ex4(:),G1H1(1),m3h2x1(:,86),heltab2x2(:,:,86))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,nMT,G2tensor(84),n2h1(80))
  call Hloop_VA_Q(ntryL,G1H2(91),ex2(:),G1H1(1),m3h2x1(:,87),heltab2x2(:,:,87))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,0,G2tensor(85),n2h1(81))
  call Hloop_VA_Q(ntryL,G1H2(92),ex2(:),G1H1(1),m3h2x1(:,88),heltab2x2(:,:,88))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),2,0,G2tensor(86),n2h1(82))
  call Hloop_VA_Q(ntryL,G1H2(96),ex2(:),G1H1(1),m3h2x1(:,89),heltab2x2(:,:,89))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,0,G2tensor(87),n2h1(83))
  call Hloop_VA_Q(ntryL,G1H2(97),ex2(:),G1H1(1),m3h2x1(:,90),heltab2x2(:,:,90))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,0,G2tensor(88),n2h1(84))
  call Hloop_VA_Q(ntryL,G1H2(98),ex2(:),G1H1(1),m3h2x1(:,91),heltab2x2(:,:,91))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),2,0,G2tensor(89),n2h1(85))
  call Hloop_VA_Q(ntryL,G1H2(102),ex2(:),G1H1(1),m3h2x1(:,92),heltab2x2(:,:,92))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,0,G2tensor(90),n2h1(86))
  call ol_merge_tensors(G2tensor(2),[G1tensor(2)])
  call ol_merge_tensors(G2tensor(29),[G2tensor(4),G1tensor(8)])
  call ol_merge_tensors(G2tensor(6),[G1tensor(14)])
  call ol_merge_tensors(G2tensor(31),[G2tensor(8),G1tensor(20)])
  call ol_merge_tensors(G2tensor(10),[G1tensor(26)])
  call ol_merge_tensors(G2tensor(12),[G1tensor(32)])
  call ol_merge_tensors(G2tensor(33),[G2tensor(14),G1tensor(38)])
  call ol_merge_tensors(G2tensor(35),[G2tensor(16),G1tensor(44)])
  call ol_merge_tensors(G2tensor(1),[G1tensor(3)])
  call ol_merge_tensors(G2tensor(37),[G1tensor(16),G1tensor(4)])
  call ol_merge_tensors(G2tensor(3),[G1tensor(5)])
  call ol_merge_tensors(G2tensor(40),[G1tensor(30),G1tensor(6)])
  call ol_merge_tensors(G2tensor(5),[G1tensor(9)])
  call ol_merge_tensors(G2tensor(43),[G1tensor(40),G1tensor(10)])
  call ol_merge_tensors(G2tensor(7),[G1tensor(11)])
  call ol_merge_tensors(G2tensor(46),[G1tensor(24),G1tensor(12)])
  call ol_merge_tensors(G2tensor(9),[G1tensor(15)])
  call ol_merge_tensors(G2tensor(11),[G1tensor(17)])
  call ol_merge_tensors(G2tensor(49),[G1tensor(36),G1tensor(18)])
  call ol_merge_tensors(G2tensor(13),[G1tensor(21)])
  call ol_merge_tensors(G2tensor(52),[G1tensor(46),G1tensor(22)])
  call ol_merge_tensors(G2tensor(15),[G1tensor(23)])
  call ol_merge_tensors(G2tensor(17),[G1tensor(27)])
  call ol_merge_tensors(G2tensor(55),[G1tensor(34),G1tensor(28)])
  call ol_merge_tensors(G2tensor(18),[G1tensor(29)])
  call ol_merge_tensors(G2tensor(19),[G1tensor(33)])
  call ol_merge_tensors(G2tensor(20),[G1tensor(35)])
  call ol_merge_tensors(G2tensor(21),[G1tensor(39)])
  call ol_merge_tensors(G2tensor(22),[G1tensor(41)])
  call ol_merge_tensors(G2tensor(58),[G1tensor(48),G1tensor(42)])
  call ol_merge_tensors(G2tensor(23),[G1tensor(45)])
  call ol_merge_tensors(G2tensor(24),[G1tensor(47)])
  call Hotf_5pt_reduction_last(G2tensor(2),RedSet_5(33),mass5set(:,1),  & 
G1tensor(1),G1tensor(7),G1tensor(13),G1tensor(19),G1tensor(25),G1tensor(31))
  call G_TensorShift(G1tensor(7),2)
  call Hotf_5pt_reduction_last(G2tensor(29),RedSet_5(11),mass5set(:,2),  & 
G1tensor(37),G1tensor(43),G1tensor(2),G1tensor(8),G1tensor(14),G1tensor(20))
  call G_TensorShift(G1tensor(43),8)
  call Hotf_5pt_reduction_last(G2tensor(6),RedSet_5(34),mass5set(:,1),  & 
G1tensor(26),G1tensor(32),G1tensor(38),G1tensor(44),G1tensor(3),G1tensor(16))
  call G_TensorShift(G1tensor(32),2)
  call Hotf_5pt_reduction_last(G2tensor(31),RedSet_5(12),mass5set(:,2),  & 
G1tensor(4),G1tensor(5),G1tensor(30),G1tensor(6),G1tensor(9),G1tensor(40))
  call G_TensorShift(G1tensor(5),4)
  call Hotf_5pt_reduction_last(G2tensor(10),RedSet_5(35),mass5set(:,1),  & 
G1tensor(10),G1tensor(11),G1tensor(24),G1tensor(12),G1tensor(15),G1tensor(17))
  call G_TensorShift(G1tensor(11),1)
  call Hotf_5pt_reduction_last(G2tensor(12),RedSet_5(36),mass5set(:,1),  & 
G1tensor(36),G1tensor(18),G1tensor(21),G1tensor(46),G1tensor(22),G1tensor(23))
  call G_TensorShift(G1tensor(18),1)
  call Hotf_5pt_reduction_last(G2tensor(33),RedSet_5(13),mass5set(:,2),  & 
G1tensor(27),G1tensor(34),G1tensor(28),G1tensor(29),G1tensor(33),G1tensor(35))
  call G_TensorShift(G1tensor(34),8)
  call Hotf_5pt_reduction_last(G2tensor(35),RedSet_5(14),mass5set(:,2),  & 
G1tensor(39),G1tensor(41),G1tensor(48),G1tensor(42),G1tensor(45),G1tensor(47))
  call G_TensorShift(G1tensor(41),4)
  call Hotf_5pt_reduction_last(G2tensor(1),RedSet_5(37),mass5set(:,7),  & 
G1tensor(49),G1tensor(50),G1tensor(51),G1tensor(52),G1tensor(53),G1tensor(54))
  call G_TensorShift(G1tensor(50),16)
  call Hotf_5pt_reduction_last(G2tensor(37),RedSet_5(15),mass5set(:,3),  & 
G1tensor(55),G1tensor(56),G1tensor(57),G1tensor(58),G1tensor(59),G1tensor(60))
  call G_TensorShift(G1tensor(56),16)
  call Hotf_5pt_reduction_last(G2tensor(3),RedSet_5(38),mass5set(:,1),  & 
G1tensor(61),G1tensor(62),G1tensor(63),G1tensor(64),G1tensor(65),G1tensor(66))
  call G_TensorShift(G1tensor(62),16)
  call Hotf_5pt_reduction_last(G2tensor(40),RedSet_5(16),mass5set(:,1),  & 
G1tensor(67),G1tensor(68),G1tensor(69),G1tensor(70),G1tensor(71),G1tensor(72))
  call G_TensorShift(G1tensor(68),16)
  call Hotf_5pt_reduction_last(G2tensor(5),RedSet_5(39),mass5set(:,4),  & 
G1tensor(73),G1tensor(74),G1tensor(75),G1tensor(76),G1tensor(77),G1tensor(78))
  call G_TensorShift(G1tensor(74),16)
  call Hotf_5pt_reduction_last(G2tensor(43),RedSet_5(17),mass5set(:,4),  & 
G1tensor(79),G1tensor(80),G1tensor(81),G1tensor(82),G1tensor(83),G1tensor(84))
  call G_TensorShift(G1tensor(80),16)
  call Hotf_5pt_reduction_last(G2tensor(7),RedSet_5(40),mass5set(:,4),  & 
G1tensor(85),G1tensor(86),G1tensor(87),G1tensor(88),G1tensor(89),G1tensor(90))
  call G_TensorShift(G1tensor(86),16)
  call Hotf_5pt_reduction_last(G2tensor(46),RedSet_5(18),mass5set(:,3),  & 
G1tensor(91),G1tensor(92),G1tensor(93),G1tensor(94),G1tensor(95),G1tensor(96))
  call G_TensorShift(G1tensor(92),16)
  call Hotf_5pt_reduction_last(G2tensor(9),RedSet_5(41),mass5set(:,7),  & 
G1tensor(97),G1tensor(98),G1tensor(99),G1tensor(100),G1tensor(101),G1tensor(102))
  call G_TensorShift(G1tensor(98),16)
  call Hotf_5pt_reduction_last(G2tensor(11),RedSet_5(42),mass5set(:,1),  & 
G1tensor(103),G1tensor(104),G1tensor(105),G1tensor(106),G1tensor(107),G1tensor(108))
  call G_TensorShift(G1tensor(104),16)
  call Hotf_5pt_reduction_last(G2tensor(49),RedSet_5(19),mass5set(:,1),  & 
G1tensor(109),G1tensor(110),G1tensor(111),G1tensor(112),G1tensor(113),G1tensor(114))
  call G_TensorShift(G1tensor(110),16)
  call Hotf_5pt_reduction_last(G2tensor(13),RedSet_5(43),mass5set(:,4),  & 
G1tensor(115),G1tensor(116),G1tensor(117),G1tensor(118),G1tensor(119),G1tensor(120))
  call G_TensorShift(G1tensor(116),16)
  call Hotf_5pt_reduction_last(G2tensor(52),RedSet_5(20),mass5set(:,4),  & 
G1tensor(121),G1tensor(122),G1tensor(123),G1tensor(124),G1tensor(125),G1tensor(126))
  call G_TensorShift(G1tensor(122),16)
  call Hotf_5pt_reduction_last(G2tensor(15),RedSet_5(44),mass5set(:,4),  & 
G1tensor(127),G1tensor(128),G1tensor(129),G1tensor(130),G1tensor(131),G1tensor(132))
  call G_TensorShift(G1tensor(128),16)
  call Hotf_5pt_reduction_last(G2tensor(17),RedSet_5(45),mass5set(:,7),  & 
G1tensor(133),G1tensor(134),G1tensor(135),G1tensor(136),G1tensor(137),G1tensor(138))
  call G_TensorShift(G1tensor(134),16)
  call Hotf_5pt_reduction_last(G2tensor(55),RedSet_5(21),mass5set(:,3),  & 
G1tensor(139),G1tensor(140),G1tensor(141),G1tensor(142),G1tensor(143),G1tensor(144))
  call G_TensorShift(G1tensor(140),16)
  call Hotf_5pt_reduction_last(G2tensor(18),RedSet_5(46),mass5set(:,1),  & 
G1tensor(145),G1tensor(146),G1tensor(147),G1tensor(148),G1tensor(149),G1tensor(150))
  call G_TensorShift(G1tensor(146),16)
  call Hotf_5pt_reduction_last(G2tensor(19),RedSet_5(47),mass5set(:,7),  & 
G1tensor(151),G1tensor(152),G1tensor(153),G1tensor(154),G1tensor(155),G1tensor(156))
  call G_TensorShift(G1tensor(152),16)
  call Hotf_5pt_reduction_last(G2tensor(20),RedSet_5(48),mass5set(:,1),  & 
G1tensor(157),G1tensor(158),G1tensor(159),G1tensor(160),G1tensor(161),G1tensor(162))
  call G_TensorShift(G1tensor(158),16)
  call Hotf_5pt_reduction_last(G2tensor(21),RedSet_5(49),mass5set(:,4),  & 
G1tensor(163),G1tensor(164),G1tensor(165),G1tensor(166),G1tensor(167),G1tensor(168))
  call G_TensorShift(G1tensor(164),16)
  call Hotf_5pt_reduction_last(G2tensor(22),RedSet_5(50),mass5set(:,4),  & 
G1tensor(169),G1tensor(170),G1tensor(171),G1tensor(172),G1tensor(173),G1tensor(174))
  call G_TensorShift(G1tensor(170),16)
  call Hotf_5pt_reduction_last(G2tensor(58),RedSet_5(22),mass5set(:,3),  & 
G1tensor(175),G1tensor(176),G1tensor(177),G1tensor(178),G1tensor(179),G1tensor(180))
  call G_TensorShift(G1tensor(176),16)
  call Hotf_5pt_reduction_last(G2tensor(23),RedSet_5(51),mass5set(:,4),  & 
G1tensor(181),G1tensor(182),G1tensor(183),G1tensor(184),G1tensor(185),G1tensor(186))
  call G_TensorShift(G1tensor(182),16)
  call Hotf_5pt_reduction_last(G2tensor(24),RedSet_5(52),mass5set(:,4),  & 
G1tensor(187),G1tensor(188),G1tensor(189),G1tensor(190),G1tensor(191),G1tensor(192))
  call G_TensorShift(G1tensor(188),16)
  call Hotf_5pt_reduction_last(G2tensor(25),RedSet_5(9),mass5set(:,2),  & 
G1tensor(193),G1tensor(194),G1tensor(195),G1tensor(196),G1tensor(197),G1tensor(198))
  call G_TensorShift(G1tensor(194),8)
  call Hotf_5pt_reduction_last(G2tensor(27),RedSet_5(10),mass5set(:,2),  & 
G1tensor(199),G1tensor(200),G1tensor(201),G1tensor(202),G1tensor(203),G1tensor(204))
  call G_TensorShift(G1tensor(200),4)
  call Hotf_5pt_reduction_last(G2tensor(61),RedSet_5(23),mass5set(:,5),  & 
G1tensor(205),G1tensor(206),G1tensor(207),G1tensor(208),G1tensor(209),G1tensor(210))
  call G_TensorShift(G1tensor(206),16)
  call Hotf_5pt_reduction_last(G2tensor(64),RedSet_5(24),mass5set(:,5),  & 
G1tensor(211),G1tensor(212),G1tensor(213),G1tensor(214),G1tensor(215),G1tensor(216))
  call G_TensorShift(G1tensor(212),16)
  call Hotf_5pt_reduction_last(G2tensor(67),RedSet_5(25),mass5set(:,3),  & 
G1tensor(217),G1tensor(218),G1tensor(219),G1tensor(220),G1tensor(221),G1tensor(222))
  call G_TensorShift(G1tensor(218),12)
  call Hotf_5pt_reduction_last(G2tensor(70),RedSet_5(26),mass5set(:,3),  & 
G1tensor(223),G1tensor(224),G1tensor(225),G1tensor(226),G1tensor(227),G1tensor(228))
  call G_TensorShift(G1tensor(224),12)
  call Hotf_5pt_reduction_last(G2tensor(73),RedSet_5(27),mass5set(:,3),  & 
G1tensor(229),G1tensor(230),G1tensor(231),G1tensor(232),G1tensor(233),G1tensor(234))
  call G_TensorShift(G1tensor(230),16)
  call Hotf_5pt_reduction_last(G2tensor(76),RedSet_5(28),mass5set(:,3),  & 
G1tensor(235),G1tensor(236),G1tensor(237),G1tensor(238),G1tensor(239),G1tensor(240))
  call G_TensorShift(G1tensor(236),16)
  call Hotf_5pt_reduction_last(G2tensor(79),RedSet_5(29),mass5set(:,6),  & 
G1tensor(241),G1tensor(242),G1tensor(243),G1tensor(244),G1tensor(245),G1tensor(246))
  call G_TensorShift(G1tensor(242),8)
  call Hotf_5pt_reduction_last(G2tensor(82),RedSet_5(30),mass5set(:,6),  & 
G1tensor(247),G1tensor(248),G1tensor(249),G1tensor(250),G1tensor(251),G1tensor(252))
  call G_TensorShift(G1tensor(248),8)
  call Hotf_5pt_reduction_last(G2tensor(85),RedSet_5(31),mass5set(:,4),  & 
G1tensor(253),G1tensor(254),G1tensor(255),G1tensor(256),G1tensor(257),G1tensor(258))
  call G_TensorShift(G1tensor(254),2)
  call Hotf_5pt_reduction_last(G2tensor(88),RedSet_5(32),mass5set(:,4),  & 
G1tensor(259),G1tensor(260),G1tensor(261),G1tensor(262),G1tensor(263),G1tensor(264))
  call G_TensorShift(G1tensor(260),2)
  call ol_merge_tensors(T1sum(9),[G1tensor(1)])
  call ol_merge_tensors(T1sum(10),[G1tensor(37)])
  call ol_merge_tensors(T1sum(11),[G1tensor(26)])
  call ol_merge_tensors(T1sum(12),[G1tensor(4)])
  call ol_merge_tensors(T1sum(13),[G1tensor(10)])
  call ol_merge_tensors(T1sum(14),[G1tensor(36)])
  call ol_merge_tensors(T1sum(15),[G1tensor(27)])
  call ol_merge_tensors(T1sum(16),[G1tensor(39)])
  call ol_merge_tensors(T1sum(17),[G1tensor(49)])
  call ol_merge_tensors(T1sum(18),[G1tensor(55)])
  call ol_merge_tensors(T1sum(19),[G1tensor(61)])
  call ol_merge_tensors(T1sum(20),[G1tensor(67)])
  call ol_merge_tensors(T1sum(21),[G1tensor(73)])
  call ol_merge_tensors(T1sum(22),[G1tensor(79)])
  call ol_merge_tensors(T1sum(23),[G1tensor(85)])
  call ol_merge_tensors(T1sum(24),[G1tensor(91)])
  call ol_merge_tensors(T1sum(25),[G1tensor(97)])
  call ol_merge_tensors(T1sum(26),[G1tensor(103)])
  call ol_merge_tensors(T1sum(27),[G1tensor(109)])
  call ol_merge_tensors(T1sum(28),[G1tensor(115)])
  call ol_merge_tensors(T1sum(29),[G1tensor(121)])
  call ol_merge_tensors(T1sum(30),[G1tensor(127)])
  call ol_merge_tensors(T1sum(31),[G1tensor(133)])
  call ol_merge_tensors(T1sum(32),[G1tensor(139)])
  call ol_merge_tensors(T1sum(33),[G1tensor(145)])
  call ol_merge_tensors(T1sum(34),[G1tensor(151)])
  call ol_merge_tensors(T1sum(35),[G1tensor(157)])
  call ol_merge_tensors(T1sum(36),[G1tensor(163)])
  call ol_merge_tensors(T1sum(37),[G1tensor(169)])
  call ol_merge_tensors(T1sum(38),[G1tensor(175)])
  call ol_merge_tensors(T1sum(39),[G1tensor(181)])
  call ol_merge_tensors(T1sum(40),[G1tensor(187)])
  call ol_merge_tensors(T1sum(41),[G1tensor(193)])
  call ol_merge_tensors(T1sum(42),[G1tensor(199)])
  call ol_merge_tensors(T1sum(43),[G1tensor(205)])
  call ol_merge_tensors(T1sum(44),[G1tensor(211)])
  call ol_merge_tensors(T1sum(45),[G1tensor(217)])
  call ol_merge_tensors(T1sum(46),[G1tensor(223)])
  call ol_merge_tensors(T1sum(47),[G1tensor(229)])
  call ol_merge_tensors(T1sum(48),[G1tensor(235)])
  call ol_merge_tensors(T1sum(49),[G1tensor(241)])
  call ol_merge_tensors(T1sum(50),[G1tensor(247)])
  call ol_merge_tensors(T1sum(51),[G1tensor(253)])
  call ol_merge_tensors(T1sum(52),[G1tensor(259)])
  Gcoeff(:)%j = (-(c(15)*M(3,:)%j)+c(12)*(M(1,:)%j+M(4,:)%j)+c(20)*M(5,:)%j-c(16)*M(6,:)%j) * den(4)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(33),h0tab(:,33),[32,12,3,16],[0,0,0,0],4,2,wf4(:,2),wf4(:,1))
  call Hloop_VA_Q(ntryL,G0H64(1),ex6(:),G0H32(2),m3h2x32(:,25),heltab2x64(:,:,33))
  call Hloop_A_Q(ntryL,G0H32(2),32,0,G1H32(1),n2h32(3))
  Gcoeff(:)%j = (c(25)*M(3,:)%j+c(20)*(-M(1,:)%j-M(4,:)%j+M(5,:)%j)) * den(4)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(34),h0tab(:,34),[32,12,3,16],[0,0,0,0],4,2,wf4(:,2),wf4(:,1))
  call Hloop_QA_V(ntryL,G0H64(1),ex6(:),G0H32(4),m3h2x32(:,26),heltab2x64(:,:,34))
  Gcoeff(:)%j = (-(c(15)*M(2,:)%j)+c(12)*(M(1,:)%j+M(4,:)%j)+c(20)*M(5,:)%j-c(16)*M(6,:)%j) * den(4)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(35),h0tab(:,35),[32,3,12,16],[0,0,0,0],4,2,wf4(:,1),wf4(:,2))
  call Hloop_VA_Q(ntryL,G0H64(1),ex6(:),G0H32(5),m3h2x32(:,27),heltab2x64(:,:,35))
  call Hloop_A_Q(ntryL,G0H32(5),32,0,G1H32(2),n2h32(4))
  Gcoeff(:)%j = (c(25)*M(2,:)%j+c(20)*(-M(1,:)%j-M(4,:)%j+M(5,:)%j)) * den(4)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(36),h0tab(:,36),[32,3,12,16],[0,0,0,0],4,2,wf4(:,1),wf4(:,2))
  call Hloop_QA_V(ntryL,G0H64(1),ex6(:),G0H32(6),m3h2x32(:,28),heltab2x64(:,:,36))
  Gcoeff(:)%j = (-(c(4)*M(5,:)%j)+c(3)*M(6,:)%j) * den(4)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(37),h0tab(:,37),[32,3,16,12],[0,0,0,0],4,2,wf4(:,1),wf4(:,2))
  call Hloop_VA_Q(ntryL,G0H64(1),ex6(:),G0H32(7),m3h2x32(:,29),heltab2x64(:,:,37))
  call Hloop_A_Q(ntryL,G0H32(7),32,0,G1H32(3),n2h32(5))
  Gcoeff(:)%j = (c(4)*M(5,:)%j-c(3)*M(6,:)%j) * den(4)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(38),h0tab(:,38),[32,3,16,12],[0,0,0,0],4,2,wf4(:,1),wf4(:,2))
  call Hloop_QA_V(ntryL,G0H64(1),ex6(:),G0H32(8),m3h2x32(:,30),heltab2x64(:,:,38))
  Gcoeff(:)%j = (c(20)*M(1,:)%j-c(15)*M(2,:)%j+c(12)*(M(4,:)%j+M(5,:)%j)-c(16)*M(6,:)%j) * den(46)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(39),h0tab(:,39),[48,3,4,8],[nMT,nMT,0,nMT],4,2,wf4(:,3),wf4(:,1))
  call Hloop_AV_Q(ntryL,G0H64(1),wf4(:,3),G0H16(1),m3h4x16(:,9),heltab2x64(:,:,39))
  call Hloop_A_Q(ntryL,G0H16(1),48,nMT,G1H16(1),n2h16(23))
  Gcoeff(:)%j = (c(25)*M(2,:)%j+c(20)*(M(1,:)%j-M(4,:)%j-M(5,:)%j)) * den(46)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(40),h0tab(:,40),[48,3,4,8],[0,0,nMT,0],4,2,wf4(:,3),wf4(:,1))
  call Hloop_UV_W(ntryL,G0H64(1),0,wf4(:,3),48,G1H16(2),m3h4x16(:,10),heltab2x64(:,:,40))
  Gcoeff(:)%j = (c(20)*M(1,:)%j-c(15)*M(3,:)%j+c(12)*(M(4,:)%j+M(5,:)%j)-c(16)*M(6,:)%j) * den(46)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(41),h0tab(:,41),[48,3,8,4],[nMT,nMT,0,nMT],4,2,wf4(:,3),wf4(:,1))
  call Hloop_QV_A(ntryL,G0H64(1),wf4(:,3),G0H16(1),m3h4x16(:,11),heltab2x64(:,:,41))
  call Hloop_Q_A(ntryL,G0H16(1),48,nMT,G1H16(3),n2h16(24))
  Gcoeff(:)%j = (c(25)*M(3,:)%j+c(20)*(M(1,:)%j-M(4,:)%j-M(5,:)%j)) * den(46)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(42),h0tab(:,42),[48,3,8,4],[0,0,nMT,0],4,2,wf4(:,3),wf4(:,1))
  call Hloop_UV_W(ntryL,G0H64(1),0,wf4(:,3),48,G1H16(4),m3h4x16(:,12),heltab2x64(:,:,42))
  Gcoeff(:)%j = (c(4)*M(1,:)%j-c(3)*M(6,:)%j) * den(46)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(43),h0tab(:,43),[48,4,3,8],[0,nMT,nMT,0],4,2,wf4(:,3),wf4(:,1))
  call Hloop_UV_W(ntryL,G0H64(1),0,wf4(:,3),48,G1H16(5),m3h4x16(:,13),heltab2x64(:,:,43))
  Gcoeff(:)%j = (-(c(4)*M(1,:)%j)+c(3)*M(6,:)%j) * den(46)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(44),h0tab(:,44),[48,4,3,8],[nMT,0,0,nMT],4,2,wf4(:,3),wf4(:,1))
  call Hloop_AV_Q(ntryL,G0H64(1),wf4(:,3),G0H16(1),m3h4x16(:,14),heltab2x64(:,:,44))
  call Hloop_A_Q(ntryL,G0H16(1),48,nMT,G1H16(6),n2h16(25))
  Gcoeff(:)%j = (c(23)*M(2,:)%j-c(18)*M(4,:)%j+c(12)*M(5,:)%j-c(11)*M(6,:)%j) * den(13)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(45),h0tab(:,45),[32,7,8,16],[0,nMT,0,0],4,1,wf8(:,9))
  call Hloop_QA_V(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,31),heltab2x64(:,:,45))
  Gcoeff(:)%j = (-(c(17)*M(2,:)%j)+c(13)*M(4,:)%j+c(21)*M(5,:)%j-c(16)*M(6,:)%j) * den(13)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(46),h0tab(:,46),[32,8,7,16],[0,nMT,0,0],4,1,wf8(:,9))
  call Hloop_QA_V(ntryL,G0H64(1),ex6(:),G0H32(3),m3h2x32(:,32),heltab2x64(:,:,46))
  Gcoeff(:)%j = (-(c(17)*M(3,:)%j)+c(13)*M(4,:)%j+c(21)*M(5,:)%j-c(16)*M(6,:)%j) * den(31)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(47),h0tab(:,47),[32,11,4,16],[0,nMT,0,0],4,1,wf8(:,31))
  call Hloop_QA_V(ntryL,G0H64(1),ex6(:),G0H32(9),m3h2x32(:,33),heltab2x64(:,:,47))
  Gcoeff(:)%j = (c(23)*M(3,:)%j-c(18)*M(4,:)%j+c(12)*M(5,:)%j-c(11)*M(6,:)%j) * den(31)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(48),h0tab(:,48),[32,4,11,16],[0,nMT,0,0],4,1,wf8(:,31))
  call Hloop_QA_V(ntryL,G0H64(1),ex6(:),G0H32(10),m3h2x32(:,34),heltab2x64(:,:,48))
  Gcoeff(:)%j = (c(12)*M(1,:)%j+c(23)*M(3,:)%j-c(18)*M(4,:)%j-c(11)*M(6,:)%j) * den(7)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(49),h0tab(:,49),[32,4,8,19],[0,nMT,0,0],4,1,wf8(:,3))
  call Hloop_QA_V(ntryL,G0H64(1),ex6(:),G0H32(11),m3h2x32(:,35),heltab2x64(:,:,49))
  Gcoeff(:)%j = (c(21)*M(1,:)%j-c(17)*M(3,:)%j+c(13)*M(4,:)%j-c(16)*M(6,:)%j) * den(7)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(50),h0tab(:,50),[32,8,4,19],[0,nMT,0,0],4,1,wf8(:,3))
  call Hloop_QA_V(ntryL,G0H64(1),ex6(:),G0H32(12),m3h2x32(:,36),heltab2x64(:,:,50))
  Gcoeff(:)%j = (c(21)*M(1,:)%j-c(17)*M(2,:)%j+c(13)*M(4,:)%j-c(16)*M(6,:)%j) * den(25)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(51),h0tab(:,51),[35,8,4,16],[0,nMT,0,0],4,1,wf8(:,22))
  call Hloop_QA_V(ntryL,G0H64(1),wf8(:,22),G0H8(1),m3h8x8(:,1),heltab2x64(:,:,51))
  Gcoeff(:)%j = (c(12)*M(1,:)%j+c(23)*M(2,:)%j-c(18)*M(4,:)%j-c(11)*M(6,:)%j) * den(25)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(52),h0tab(:,52),[35,4,8,16],[0,nMT,0,0],4,1,wf8(:,22))
  call Hloop_QA_V(ntryL,G0H64(1),wf8(:,22),G0H8(2),m3h8x8(:,2),heltab2x64(:,:,52))
  Gcoeff(:)%j = (-(c(15)*M(3,:)%j)+c(20)*M(4,:)%j+c(12)*(M(1,:)%j+M(5,:)%j)-c(16)*M(6,:)%j) * den(42)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(53),h0tab(:,53),[48,2,1,12],[0,0,0,0],4,2,wf4(:,3),wf4(:,2))
  call Hloop_QV_A(ntryL,G0H64(1),wf4(:,3),G0H16(1),m3h4x16(:,15),heltab2x64(:,:,53))
  call Hloop_Q_A(ntryL,G0H16(1),48,0,G1H16(7),n2h16(26))
  Gcoeff(:)%j = (c(25)*M(3,:)%j+c(20)*(-M(1,:)%j+M(4,:)%j-M(5,:)%j)) * den(42)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(54),h0tab(:,54),[48,2,1,12],[0,0,0,0],4,2,wf4(:,3),wf4(:,2))
  call Hloop_UV_W(ntryL,G0H64(1),0,wf4(:,3),48,G1H16(8),m3h4x16(:,16),heltab2x64(:,:,54))
  Gcoeff(:)%j = (-(c(15)*M(2,:)%j)+c(20)*M(4,:)%j+c(12)*(M(1,:)%j+M(5,:)%j)-c(16)*M(6,:)%j) * den(42)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(55),h0tab(:,55),[48,1,2,12],[0,0,0,0],4,2,wf4(:,3),wf4(:,2))
  call Hloop_AV_Q(ntryL,G0H64(1),wf4(:,3),G0H16(1),m3h4x16(:,17),heltab2x64(:,:,55))
  call Hloop_A_Q(ntryL,G0H16(1),48,0,G1H16(9),n2h16(27))
  Gcoeff(:)%j = (c(25)*M(2,:)%j+c(20)*(-M(1,:)%j+M(4,:)%j-M(5,:)%j)) * den(42)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(56),h0tab(:,56),[48,1,2,12],[0,0,0,0],4,2,wf4(:,3),wf4(:,2))
  call Hloop_UV_W(ntryL,G0H64(1),0,wf4(:,3),48,G1H16(10),m3h4x16(:,18),heltab2x64(:,:,56))
  Gcoeff(:)%j = (c(4)*M(4,:)%j-c(3)*M(6,:)%j) * den(42)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(57),h0tab(:,57),[48,1,12,2],[0,0,0,0],4,2,wf4(:,3),wf4(:,2))
  call Hloop_UV_W(ntryL,G0H64(1),0,wf4(:,3),48,G1H16(11),m3h4x16(:,19),heltab2x64(:,:,57))
  Gcoeff(:)%j = (-(c(4)*M(4,:)%j)+c(3)*M(6,:)%j) * den(42)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(58),h0tab(:,58),[48,1,12,2],[0,0,0,0],4,2,wf4(:,3),wf4(:,2))
  call Hloop_AV_Q(ntryL,G0H64(1),wf4(:,3),G0H16(1),m3h4x16(:,20),heltab2x64(:,:,58))
  call Hloop_A_Q(ntryL,G0H16(1),48,0,G1H16(12),n2h16(28))
  Gcoeff(:)%j = (-(c(18)*M(1,:)%j)+c(23)*M(3,:)%j+c(12)*M(5,:)%j-c(11)*M(6,:)%j) * den(19)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(59),h0tab(:,59),[32,13,2,16],[0,0,0,0],4,1,wf8(:,15))
  call Hloop_QA_V(ntryL,G0H64(1),ex6(:),G0H32(13),m3h2x32(:,37),heltab2x64(:,:,59))
  Gcoeff(:)%j = (c(13)*M(1,:)%j-c(17)*M(3,:)%j+c(21)*M(5,:)%j-c(16)*M(6,:)%j) * den(19)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(60),h0tab(:,60),[32,2,13,16],[0,0,0,0],4,1,wf8(:,15))
  call Hloop_QA_V(ntryL,G0H64(1),ex6(:),G0H32(14),m3h2x32(:,38),heltab2x64(:,:,60))
  Gcoeff(:)%j = (c(13)*M(1,:)%j-c(17)*M(2,:)%j+c(21)*M(5,:)%j-c(16)*M(6,:)%j) * den(40)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(61),h0tab(:,61),[32,14,1,16],[0,0,0,0],4,1,wf8(:,48))
  call Hloop_QA_V(ntryL,G0H64(1),ex6(:),G0H32(2),m3h2x32(:,39),heltab2x64(:,:,61))
  Gcoeff(:)%j = (-(c(18)*M(1,:)%j)+c(23)*M(2,:)%j+c(12)*M(5,:)%j-c(11)*M(6,:)%j) * den(40)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(62),h0tab(:,62),[32,1,14,16],[0,0,0,0],4,1,wf8(:,48))
  call Hloop_QA_V(ntryL,G0H64(1),ex6(:),G0H32(5),m3h2x32(:,40),heltab2x64(:,:,62))
  Gcoeff(:)%j = (-(c(18)*M(1,:)%j)+c(23)*M(2,:)%j+c(12)*M(4,:)%j-c(11)*M(6,:)%j) * den(10)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(63),h0tab(:,63),[32,1,2,28],[0,0,0,0],4,1,wf8(:,6))
  call Hloop_QA_V(ntryL,G0H64(1),ex6(:),G0H32(7),m3h2x32(:,41),heltab2x64(:,:,63))
  Gcoeff(:)%j = (c(13)*M(1,:)%j-c(17)*M(2,:)%j+c(21)*M(4,:)%j-c(16)*M(6,:)%j) * den(10)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(64),h0tab(:,64),[32,2,1,28],[0,0,0,0],4,1,wf8(:,6))
  call Hloop_QA_V(ntryL,G0H64(1),ex6(:),G0H32(15),m3h2x32(:,42),heltab2x64(:,:,64))
  Gcoeff(:)%j = (c(13)*M(1,:)%j-c(17)*M(3,:)%j+c(21)*M(4,:)%j-c(16)*M(6,:)%j) * den(28)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(65),h0tab(:,65),[44,2,1,16],[0,0,0,0],4,1,wf8(:,24))
  call Hloop_QA_V(ntryL,G0H64(1),wf8(:,24),G0H8(3),m3h8x8(:,3),heltab2x64(:,:,65))
  Gcoeff(:)%j = (-(c(18)*M(1,:)%j)+c(23)*M(3,:)%j+c(12)*M(4,:)%j-c(11)*M(6,:)%j) * den(28)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(66),h0tab(:,66),[44,1,2,16],[0,0,0,0],4,1,wf8(:,24))
  call Hloop_QA_V(ntryL,G0H64(1),wf8(:,24),G0H8(4),m3h8x8(:,4),heltab2x64(:,:,66))
  Gcoeff(:)%j = (c(12)*M(1,:)%j+c(23)*M(2,:)%j-c(18)*M(5,:)%j-c(11)*M(6,:)%j) * den(22)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(67),h0tab(:,67),[49,2,4,8],[0,0,nMT,0],4,1,wf8(:,18))
  call Hloop_VQ_A(ntryL,G0H64(1),wf8(:,18),G0H8(5),m3h8x8(:,5),heltab2x64(:,:,67))
  call Hloop_Q_A(ntryL,G0H8(5),49,0,G1H8(7),n2h8(7))
  Gcoeff(:)%j = (c(21)*M(1,:)%j-c(17)*M(2,:)%j+c(13)*M(5,:)%j-c(16)*M(6,:)%j) * den(22)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(68),h0tab(:,68),[49,2,8,4],[0,0,nMT,0],4,1,wf8(:,18))
  call Hloop_VQ_A(ntryL,G0H64(1),wf8(:,18),G0H8(5),m3h8x8(:,6),heltab2x64(:,:,68))
  call Hloop_Q_A(ntryL,G0H8(5),49,0,G1H8(1),n2h8(8))
  Gcoeff(:)%j = (c(21)*M(1,:)%j-c(17)*M(3,:)%j+c(13)*M(5,:)%j-c(16)*M(6,:)%j) * den(37)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(69),h0tab(:,69),[50,1,4,8],[0,0,nMT,0],4,1,wf8(:,46))
  call Hloop_VA_Q(ntryL,G0H64(1),wf8(:,46),G0H8(5),m3h8x8(:,7),heltab2x64(:,:,69))
  call Hloop_A_Q(ntryL,G0H8(5),50,0,G1H8(8),n2h8(9))
  Gcoeff(:)%j = (c(12)*M(1,:)%j+c(23)*M(3,:)%j-c(18)*M(5,:)%j-c(11)*M(6,:)%j) * den(37)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(70),h0tab(:,70),[50,1,8,4],[0,0,nMT,0],4,1,wf8(:,46))
  call Hloop_VA_Q(ntryL,G0H64(1),wf8(:,46),G0H8(5),m3h8x8(:,8),heltab2x64(:,:,70))
  call Hloop_A_Q(ntryL,G0H8(5),50,0,G1H8(3),n2h8(10))
  Gcoeff(:)%j = (c(23)*M(3,:)%j+c(12)*M(4,:)%j-c(18)*M(5,:)%j-c(11)*M(6,:)%j) * den(16)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(71),h0tab(:,71),[52,2,1,8],[0,0,0,nMT],4,1,wf8(:,12))
  call Hloop_AQ_V(ntryL,G0H64(1),wf8(:,12),G0H8(5),m3h8x8(:,9),heltab2x64(:,:,71))
  Gcoeff(:)%j = (-(c(17)*M(3,:)%j)+c(21)*M(4,:)%j+c(13)*M(5,:)%j-c(16)*M(6,:)%j) * den(16)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(72),h0tab(:,72),[52,1,2,8],[0,0,0,nMT],4,1,wf8(:,12))
  call Hloop_AQ_V(ntryL,G0H64(1),wf8(:,12),G0H8(6),m3h8x8(:,10),heltab2x64(:,:,72))
  Gcoeff(:)%j = (-(c(17)*M(2,:)%j)+c(21)*M(4,:)%j+c(13)*M(5,:)%j-c(16)*M(6,:)%j) * den(34)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(73),h0tab(:,73),[56,2,1,4],[0,0,0,nMT],4,1,wf8(:,33))
  call Hloop_QA_V(ntryL,G0H64(1),wf8(:,33),G0H8(7),m3h8x8(:,11),heltab2x64(:,:,73))
  Gcoeff(:)%j = (c(23)*M(2,:)%j+c(12)*M(4,:)%j-c(18)*M(5,:)%j-c(11)*M(6,:)%j) * den(34)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(74),h0tab(:,74),[56,1,2,4],[0,0,0,nMT],4,1,wf8(:,33))
  call Hloop_QA_V(ntryL,G0H64(1),wf8(:,33),G0H8(8),m3h8x8(:,12),heltab2x64(:,:,74))
  call Hloop_AV_Q(ntryL,G1H32(1),wf4(:,2),G1H8(2),m3h4x8(:,7),heltab2x32(:,:,25))
  call Hloop_A_Q(ntryL,G1H8(2),44,0,G2H8(1),n2h8(11))
  call Hloop_UV_W(ntryL,G0H32(4),32,wf4(:,2),12,G1H8(4),m3h4x8(:,8),heltab2x32(:,:,26))
  call Hloop_AV_Q(ntryL,G1H32(2),wf4(:,1),G1H8(9),m3h4x8(:,9),heltab2x32(:,:,27))
  call Hloop_A_Q(ntryL,G1H8(9),35,0,G2H8(2),n2h8(12))
  call Hloop_UV_W(ntryL,G0H32(6),32,wf4(:,1),3,G1H8(5),m3h4x8(:,10),heltab2x32(:,:,28))
  call Hloop_AV_Q(ntryL,G1H32(3),wf4(:,1),G1H8(10),m3h4x8(:,11),heltab2x32(:,:,29))
  call Hloop_A_Q(ntryL,G1H8(10),35,0,G2H8(3),n2h8(13))
  call Hloop_UV_W(ntryL,G0H32(8),32,wf4(:,1),3,G1H8(6),m3h4x8(:,12),heltab2x32(:,:,30))
  call Hloop_AV_Q(ntryL,G1H16(1),wf4(:,1),G1H4(19),m3h4x4(:,5),heltab2x16(:,:,27))
  call Hloop_A_Q(ntryL,G1H4(19),51,nMT,G2H4(3),n2h4(29))
  call Hloop_UV_W(ntryL,G1H16(2),48,wf4(:,1),3,G2H4(4),m3h4x4(:,6),heltab2x16(:,:,28))
  call Hloop_QV_A(ntryL,G1H16(3),wf4(:,1),G1H4(20),m3h4x4(:,7),heltab2x16(:,:,29))
  call Hloop_Q_A(ntryL,G1H4(20),51,nMT,G2H4(5),n2h4(30))
  call Hloop_UV_W(ntryL,G1H16(4),48,wf4(:,1),3,G2H4(6),m3h4x4(:,8),heltab2x16(:,:,30))
  call Hloop_VQ_A(ntryL,G1H16(5),ex3(:),G1H8(2),m3h2x8(:,23),heltab2x16(:,:,31))
  call Hloop_Q_A(ntryL,G1H8(2),52,nMT,G2H8(4),n2h8(14))
  call Hloop_AQ_V(ntryL,G1H16(6),ex3(:),G1H8(9),m3h2x8(:,24),heltab2x16(:,:,32))
  call Hloop_VQ_A(ntryL,G0H32(1),wf8(:,9),G0H4(1),m3h8x4(:,1),heltab2x32(:,:,31))
  call Hloop_Q_A(ntryL,G0H4(1),39,nMT,G1H4(23),n2h4(31))
  call Hloop_VA_Q(ntryL,G0H32(3),ex4(:),G0H16(1),m3h2x16(:,19),heltab2x32(:,:,32))
  call Hloop_A_Q(ntryL,G0H16(1),40,nMT,G1H16(13),n2h16(29))
  call Hloop_VA_Q(ntryL,G0H32(9),wf8(:,31),G0H4(1),m3h8x4(:,2),heltab2x32(:,:,33))
  call Hloop_A_Q(ntryL,G0H4(1),43,nMT,G1H4(24),n2h4(32))
  call Hloop_VQ_A(ntryL,G0H32(10),ex3(:),G0H16(1),m3h2x16(:,20),heltab2x32(:,:,34))
  call Hloop_Q_A(ntryL,G0H16(1),36,nMT,G1H16(14),n2h16(30))
  call Hloop_VQ_A(ntryL,G0H32(11),ex3(:),G0H16(1),m3h2x16(:,21),heltab2x32(:,:,35))
  call Hloop_Q_A(ntryL,G0H16(1),36,nMT,G1H16(15),n2h16(31))
  call Hloop_VA_Q(ntryL,G0H32(12),ex4(:),G0H16(1),m3h2x16(:,22),heltab2x32(:,:,36))
  call Hloop_A_Q(ntryL,G0H16(1),40,nMT,G1H16(16),n2h16(32))
  call Hloop_VA_Q(ntryL,G0H8(1),ex4(:),G0H4(1),m3h2x4(:,25),heltab2x8(:,:,29))
  call Hloop_A_Q(ntryL,G0H4(1),43,nMT,G1H4(25),n2h4(33))
  call Hloop_VQ_A(ntryL,G0H8(2),ex3(:),G0H4(1),m3h2x4(:,26),heltab2x8(:,:,30))
  call Hloop_Q_A(ntryL,G0H4(1),39,nMT,G1H4(26),n2h4(34))
  call Hloop_QA_V(ntryL,G1H16(7),ex2(:),G1H8(10),m3h2x8(:,25),heltab2x16(:,:,33))
  call Hloop_VA_Q(ntryL,G1H16(8),ex2(:),G1H8(2),m3h2x8(:,26),heltab2x16(:,:,34))
  call Hloop_A_Q(ntryL,G1H8(2),50,0,G2H8(5),n2h8(15))
  call Hloop_AQ_V(ntryL,G1H16(9),ex1(:),G1H8(2),m3h2x8(:,27),heltab2x16(:,:,35))
  call Hloop_VQ_A(ntryL,G1H16(10),ex1(:),G1H8(11),m3h2x8(:,28),heltab2x16(:,:,36))
  call Hloop_Q_A(ntryL,G1H8(11),49,0,G2H8(6),n2h8(16))
  call Hloop_VQ_A(ntryL,G1H16(11),ex1(:),G1H8(11),m3h2x8(:,29),heltab2x16(:,:,37))
  call Hloop_Q_A(ntryL,G1H8(11),49,0,G2H8(7),n2h8(17))
  call Hloop_AQ_V(ntryL,G1H16(12),ex1(:),G1H8(11),m3h2x8(:,30),heltab2x16(:,:,38))
  call Hloop_VQ_A(ntryL,G0H32(13),wf8(:,15),G0H4(1),m3h8x4(:,3),heltab2x32(:,:,37))
  call Hloop_Q_A(ntryL,G0H4(1),45,0,G1H4(29),n2h4(35))
  call Hloop_VA_Q(ntryL,G0H32(14),ex2(:),G0H16(1),m3h2x16(:,23),heltab2x32(:,:,38))
  call Hloop_A_Q(ntryL,G0H16(1),34,0,G1H16(17),n2h16(33))
  call Hloop_VA_Q(ntryL,G0H32(2),wf8(:,48),G0H4(1),m3h8x4(:,4),heltab2x32(:,:,39))
  call Hloop_A_Q(ntryL,G0H4(1),46,0,G1H4(30),n2h4(36))
  call Hloop_VQ_A(ntryL,G0H32(5),ex1(:),G0H16(1),m3h2x16(:,24),heltab2x32(:,:,40))
  call Hloop_Q_A(ntryL,G0H16(1),33,0,G1H16(18),n2h16(34))
  call Hloop_VQ_A(ntryL,G0H32(7),ex1(:),G0H16(1),m3h2x16(:,25),heltab2x32(:,:,41))
  call Hloop_Q_A(ntryL,G0H16(1),33,0,G1H16(1),n2h16(35))
  call Hloop_VA_Q(ntryL,G0H32(15),ex2(:),G0H16(1),m3h2x16(:,26),heltab2x32(:,:,42))
  call Hloop_A_Q(ntryL,G0H16(1),34,0,G1H16(2),n2h16(36))
  call Hloop_VA_Q(ntryL,G0H8(3),ex2(:),G0H4(1),m3h2x4(:,27),heltab2x8(:,:,31))
  call Hloop_A_Q(ntryL,G0H4(1),46,0,G1H4(31),n2h4(37))
  call Hloop_VQ_A(ntryL,G0H8(4),ex1(:),G0H4(1),m3h2x4(:,28),heltab2x8(:,:,32))
  call Hloop_Q_A(ntryL,G0H4(1),45,0,G1H4(32),n2h4(38))
  call Hloop_QA_V(ntryL,G1H8(7),ex2(:),G1H4(35),m3h2x4(:,29),heltab2x8(:,:,33))
  call Hloop_QA_V(ntryL,G1H8(1),ex2(:),G1H4(36),m3h2x4(:,30),heltab2x8(:,:,34))
  call Hloop_AQ_V(ntryL,G1H8(8),ex1(:),G1H4(1),m3h2x4(:,31),heltab2x8(:,:,35))
  call Hloop_AQ_V(ntryL,G1H8(3),ex1(:),G1H4(2),m3h2x4(:,32),heltab2x8(:,:,36))
  call Hloop_VA_Q(ntryL,G0H8(5),ex2(:),G0H4(1),m3h2x4(:,33),heltab2x8(:,:,37))
  call Hloop_A_Q(ntryL,G0H4(1),54,0,G1H4(8),n2h4(39))
  call Hloop_VQ_A(ntryL,G0H8(6),ex1(:),G0H4(1),m3h2x4(:,34),heltab2x8(:,:,38))
  call Hloop_Q_A(ntryL,G0H4(1),53,0,G1H4(11),n2h4(40))
  call Hloop_VA_Q(ntryL,G0H8(7),ex2(:),G0H4(1),m3h2x4(:,35),heltab2x8(:,:,39))
  call Hloop_A_Q(ntryL,G0H4(1),58,0,G1H4(12),n2h4(41))
  call Hloop_VQ_A(ntryL,G0H8(8),ex1(:),G0H4(1),m3h2x4(:,36),heltab2x8(:,:,40))
  call Hloop_Q_A(ntryL,G0H4(1),57,0,G1H4(18),n2h4(42))
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(1),[G1H4(15)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(4),[G1H4(28),G1H4(16)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(2),[G1H4(21)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(6),[G1H4(34),G1H4(22)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(35),[G1H4(27)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(36),[G1H4(33)])
  call Hloop_VQ_A(ntryL,G1H4(3),ex3(:),G1H2(32),m3h2x2(:,45),heltab2x4(:,:,51))
  call Hloop_Q_A(ntryL,G1H2(32),55,nMT,G2H2(9),n2h2(19))
  call Hloop_VQ_A(ntryL,G1H4(4),ex3(:),G1H2(37),m3h2x2(:,46),heltab2x4(:,:,52))
  call Hloop_Q_A(ntryL,G1H2(37),55,nMT,G2H2(4),n2h2(20))
  call Hloop_VA_Q(ntryL,G1H4(9),ex4(:),G1H2(8),m3h2x2(:,47),heltab2x4(:,:,53))
  call Hloop_A_Q(ntryL,G1H2(8),59,nMT,G2H2(3),n2h2(21))
  call Hloop_VA_Q(ntryL,G1H4(10),ex4(:),G1H2(13),m3h2x2(:,48),heltab2x4(:,:,54))
  call Hloop_A_Q(ntryL,G1H2(13),59,nMT,G2H2(10),n2h2(22))
  call Hloop_VQ_A(ntryL,G1H4(1),ex3(:),G1H2(19),m3h2x2(:,49),heltab2x4(:,:,55))
  call Hloop_Q_A(ntryL,G1H2(19),55,nMT,G2H2(2),n2h2(23))
  call Hotf_4pt_reduction(G2H4(4),RedSet_4(88),mass4set(:,1),  & 
G1H4(19),G1H4(20),G1H4(15),G1H4(28),G1H4(16),4)
  call HG1shiftOLR(G1H4(20),8,4)
  call Hloop_VA_Q(ntryL,G1H4(2),ex4(:),G1H2(4),m3h2x2(:,50),heltab2x4(:,:,56))
  call Hloop_A_Q(ntryL,G1H2(4),59,nMT,G2H2(1),n2h2(24))
  call Hotf_4pt_reduction(G2H4(6),RedSet_4(95),mass4set(:,1),  & 
G1H4(21),G1H4(34),G1H4(22),G1H4(27),G1H4(33),4)
  call HG1shiftOLR(G1H4(34),4,4)
  call Hloop_VQ_A(ntryL,G1H4(35),ex3(:),G1H2(30),m3h2x2(:,51),heltab2x4(:,:,57))
  call Hloop_Q_A(ntryL,G1H2(30),55,nMT,G2H2(7),n2h2(25))
  call Hloop_VA_Q(ntryL,G1H4(36),ex4(:),G1H2(6),m3h2x2(:,52),heltab2x4(:,:,58))
  call Hloop_A_Q(ntryL,G1H2(6),59,nMT,G2H2(8),n2h2(26))
  call Hotf_4pt_reduction(G2H8(1),RedSet_4(7),mass4set(:,2),  & 
G1H8(7),G1H8(1),G1H8(8),G1H8(3),G1H8(12),8)
  call HG1shiftOLR(G1H8(1),16,8)
  call Hloop_UV_W(ntryL,G1H8(4),44,wf4(:,1),3,G2H2(5),m3h4x2(:,5),heltab2x8(:,:,41))
  call Hotf_4pt_reduction(G2H8(2),RedSet_4(22),mass4set(:,2),  & 
G1H8(4),G1H8(13),G1H8(14),G1H8(15),G1H8(16),8)
  call HG1shiftOLR(G1H8(13),16,8)
  call Hloop_UV_W(ntryL,G1H8(5),35,wf4(:,2),12,G2H2(6),m3h4x2(:,6),heltab2x8(:,:,42))
  call Hloop_AQ_V(ntryL,G2H8(3),ex5(:),G2H4(7),m3h2x4(:,37),heltab2x8(:,:,43))
  call Hloop_VQ_A(ntryL,G1H8(6),ex5(:),G1H4(3),m3h2x4(:,38),heltab2x8(:,:,44))
  call Hloop_Q_A(ntryL,G1H4(3),51,0,G2H4(8),n2h4(43))
  call Hloop_AQ_V(ntryL,G2H4(3),ex3(:),G2H2(11),m3h2x2(:,53),heltab2x4(:,:,59))
  call Hloop_QA_V(ntryL,G2H4(5),ex4(:),G2H2(12),m3h2x2(:,54),heltab2x4(:,:,60))
  call Hotf_4pt_reduction(G2H8(4),RedSet_4(136),mass4set(:,3),  & 
G1H8(5),G1H8(6),G1H8(17),G1H8(18),G1H8(19),8)
  call HG1shiftOLR(G1H8(6),8,8)
  call Hloop_UV_W(ntryL,G1H8(9),52,wf4(:,1),3,G2H2(13),m3h4x2(:,7),heltab2x8(:,:,45))
  call Hloop_QA_V(ntryL,G1H4(23),ex4(:),G1H2(12),m3h2x2(:,55),heltab2x4(:,:,61))
  call Hloop_AQ_V(ntryL,G1H16(13),wf8(:,9),G1H2(36),m3h8x2(:,1),heltab2x16(:,:,39))
  call Hloop_AQ_V(ntryL,G1H4(24),ex3(:),G1H2(18),m3h2x2(:,56),heltab2x4(:,:,62))
  call Hloop_QA_V(ntryL,G1H16(14),wf8(:,31),G1H2(28),m3h8x2(:,2),heltab2x16(:,:,40))
  call Hloop_QA_V(ntryL,G1H16(15),ex4(:),G1H8(9),m3h2x8(:,31),heltab2x16(:,:,41))
  call Hloop_AQ_V(ntryL,G1H16(16),ex3(:),G1H8(20),m3h2x8(:,32),heltab2x16(:,:,42))
  call Hloop_AQ_V(ntryL,G1H4(25),ex3(:),G1H2(48),m3h2x2(:,57),heltab2x4(:,:,63))
  call Hloop_QA_V(ntryL,G1H4(26),ex4(:),G1H2(42),m3h2x2(:,58),heltab2x4(:,:,64))
  call Hloop_VQ_A(ntryL,G1H8(10),ex1(:),G1H4(4),m3h2x4(:,39),heltab2x8(:,:,46))
  call Hloop_Q_A(ntryL,G1H4(4),51,0,G2H4(9),n2h4(44))
  call Hloop_AQ_V(ntryL,G2H8(5),ex1(:),G2H4(10),m3h2x4(:,40),heltab2x8(:,:,47))
  call Hloop_VA_Q(ntryL,G1H8(2),ex2(:),G1H4(9),m3h2x4(:,41),heltab2x8(:,:,48))
  call Hloop_A_Q(ntryL,G1H4(9),51,0,G2H4(11),n2h4(45))
  call Hloop_QA_V(ntryL,G2H8(6),ex2(:),G2H4(12),m3h2x4(:,42),heltab2x8(:,:,49))
  call Hotf_4pt_reduction(G2H8(7),RedSet_4(143),mass4set(:,2),  & 
G1H8(10),G1H8(2),G1H8(21),G1H8(22),G1H8(23),8)
  call HG1shiftOLR(G1H8(2),2,8)
  call Hloop_UV_W(ntryL,G1H8(11),49,wf4(:,2),12,G2H2(14),m3h4x2(:,8),heltab2x8(:,:,50))
  call Hloop_QA_V(ntryL,G1H4(29),ex2(:),G1H2(11),m3h2x2(:,59),heltab2x4(:,:,65))
  call Hloop_AQ_V(ntryL,G1H16(17),wf8(:,15),G1H2(15),m3h8x2(:,3),heltab2x16(:,:,43))
  call Hloop_AQ_V(ntryL,G1H4(30),ex1(:),G1H2(17),m3h2x2(:,60),heltab2x4(:,:,66))
  call Hloop_QA_V(ntryL,G1H16(18),wf8(:,48),G1H2(51),m3h8x2(:,4),heltab2x16(:,:,44))
  call Hloop_QA_V(ntryL,G1H16(1),ex2(:),G1H8(11),m3h2x8(:,33),heltab2x16(:,:,45))
  call Hloop_AQ_V(ntryL,G1H16(2),ex1(:),G1H8(24),m3h2x8(:,34),heltab2x16(:,:,46))
  call Hloop_AQ_V(ntryL,G1H4(31),ex1(:),G1H2(23),m3h2x2(:,61),heltab2x4(:,:,67))
  call Hloop_QA_V(ntryL,G1H4(32),ex2(:),G1H2(27),m3h2x2(:,62),heltab2x4(:,:,68))
  call Hloop_AQ_V(ntryL,G1H4(8),ex1(:),G1H2(55),m3h2x2(:,63),heltab2x4(:,:,69))
  call Hloop_QA_V(ntryL,G1H4(11),ex2(:),G1H2(29),m3h2x2(:,64),heltab2x4(:,:,70))
  call Hloop_AQ_V(ntryL,G1H4(12),ex1(:),G1H2(33),m3h2x2(:,65),heltab2x4(:,:,71))
  call Hloop_QA_V(ntryL,G1H4(18),ex2(:),G1H2(56),m3h2x2(:,66),heltab2x4(:,:,72))
  call Hloop_VQ_A(ntryL,G1H4(19),ex3(:),G1H2(45),m3h2x2(:,67),heltab2x4(:,:,73))
  call Hloop_Q_A(ntryL,G1H2(45),55,nMT,G2H2(15),n2h2(27))
call HGT_raise_alpha_OLR(G1H4(20),1,1,4)
call HGT_raise_alpha_invQ_OLR(G1H4(20),2,5,4)
  call Hloop_VA_Q(ntryL,G1H4(20),ex4(:),G1H2(47),m3h2x2(:,68),heltab2x4(:,:,74))
  call Hloop_VQ_A(ntryL,G1H4(28),ex3(:),G1H2(60),m3h2x2(:,69),heltab2x4(:,:,75))
  call Hloop_Q_A(ntryL,G1H2(60),55,nMT,G2H2(16),n2h2(28))
  call Hloop_VQ_A(ntryL,G1H4(16),ex3(:),G1H2(61),m3h2x2(:,70),heltab2x4(:,:,76))
  call Hloop_Q_A(ntryL,G1H2(61),55,nMT,G2H2(17),n2h2(29))
  call Hloop_VA_Q(ntryL,G1H4(21),ex4(:),G1H2(62),m3h2x2(:,71),heltab2x4(:,:,77))
  call Hloop_A_Q(ntryL,G1H2(62),59,nMT,G2H2(19),n2h2(30))
call HGT_raise_alpha_OLR(G1H4(34),1,1,4)
call HGT_raise_alpha_invQ_OLR(G1H4(34),2,5,4)
  call Hloop_VQ_A(ntryL,G1H4(34),ex3(:),G1H2(66),m3h2x2(:,72),heltab2x4(:,:,78))
  call Hloop_VA_Q(ntryL,G1H4(27),ex4(:),G1H2(67),m3h2x2(:,73),heltab2x4(:,:,79))
  call Hloop_A_Q(ntryL,G1H2(67),59,nMT,G2H2(20),n2h2(31))
  call Hloop_VA_Q(ntryL,G1H4(33),ex4(:),G1H2(68),m3h2x2(:,74),heltab2x4(:,:,80))
  call Hloop_A_Q(ntryL,G1H2(68),59,nMT,G2H2(22),n2h2(32))
  call Hloop_AV_Q(ntryL,G1H8(7),wf4(:,1),G1H2(72),m3h4x2(:,9),heltab2x8(:,:,51))
  call Hloop_A_Q(ntryL,G1H2(72),47,0,G2H2(23),n2h2(33))
call HGT_raise_alpha_OLR(G1H8(1),1,1,8)
call HGT_raise_alpha_invQ_OLR(G1H8(1),2,5,8)
  call Hloop_VQ_A(ntryL,G1H8(1),ex5(:),G1H4(10),m3h2x4(:,43),heltab2x8(:,:,52))
  call Hloop_AV_Q(ntryL,G1H8(3),wf4(:,1),G1H2(73),m3h4x2(:,10),heltab2x8(:,:,53))
  call Hloop_A_Q(ntryL,G1H2(73),47,0,G2H2(25),n2h2(34))
  call Hloop_AV_Q(ntryL,G1H8(12),wf4(:,1),G1H2(74),m3h4x2(:,11),heltab2x8(:,:,54))
  call Hloop_A_Q(ntryL,G1H2(74),47,0,G2H2(26),n2h2(35))
  call Hloop_AV_Q(ntryL,G1H8(4),wf4(:,2),G1H2(78),m3h4x2(:,12),heltab2x8(:,:,55))
  call Hloop_A_Q(ntryL,G1H2(78),47,0,G2H2(28),n2h2(36))
call HGT_raise_alpha_OLR(G1H8(13),1,1,8)
call HGT_raise_alpha_invQ_OLR(G1H8(13),2,5,8)
  call Hloop_VQ_A(ntryL,G1H8(13),ex5(:),G1H4(1),m3h2x4(:,44),heltab2x8(:,:,56))
  call Hloop_AV_Q(ntryL,G1H8(15),wf4(:,2),G1H2(79),m3h4x2(:,13),heltab2x8(:,:,57))
  call Hloop_A_Q(ntryL,G1H2(79),47,0,G2H2(29),n2h2(37))
  call Hloop_AV_Q(ntryL,G1H8(16),wf4(:,2),G1H2(80),m3h4x2(:,14),heltab2x8(:,:,58))
  call Hloop_A_Q(ntryL,G1H2(80),47,0,G2H2(31),n2h2(38))
  call Hloop_QV_A(ntryL,G1H8(5),wf4(:,1),G1H2(84),m3h4x2(:,15),heltab2x8(:,:,59))
  call Hloop_Q_A(ntryL,G1H2(84),55,nMT,G2H2(32),n2h2(39))
call HGT_raise_alpha_OLR(G1H8(6),1,1,8)
call HGT_raise_alpha_invQ_OLR(G1H8(6),2,5,8)
  call Hloop_VA_Q(ntryL,G1H8(6),ex4(:),G1H4(2),m3h2x4(:,45),heltab2x8(:,:,60))
  call Hloop_QV_A(ntryL,G1H8(18),wf4(:,1),G1H2(85),m3h4x2(:,16),heltab2x8(:,:,61))
  call Hloop_Q_A(ntryL,G1H2(85),55,nMT,G2H2(34),n2h2(40))
  call Hloop_QV_A(ntryL,G1H8(19),wf4(:,1),G1H2(86),m3h4x2(:,17),heltab2x8(:,:,62))
  call Hloop_Q_A(ntryL,G1H2(86),55,nMT,G2H2(35),n2h2(41))
  call Hloop_QV_A(ntryL,G1H8(10),wf4(:,2),G1H2(90),m3h4x2(:,18),heltab2x8(:,:,63))
  call Hloop_Q_A(ntryL,G1H2(90),61,0,G2H2(36),n2h2(42))
call HGT_raise_alpha_OLR(G1H8(2),1,1,8)
call HGT_raise_alpha_invQ_OLR(G1H8(2),2,5,8)
  call Hloop_VA_Q(ntryL,G1H8(2),ex2(:),G1H4(35),m3h2x4(:,46),heltab2x8(:,:,64))
  call Hloop_QV_A(ntryL,G1H8(22),wf4(:,2),G1H2(91),m3h4x2(:,19),heltab2x8(:,:,65))
  call Hloop_Q_A(ntryL,G1H2(91),61,0,G2H2(37),n2h2(43))
  call Hloop_QV_A(ntryL,G1H8(23),wf4(:,2),G1H2(92),m3h4x2(:,20),heltab2x8(:,:,66))
  call Hloop_Q_A(ntryL,G1H2(92),61,0,G2H2(38),n2h2(44))
call HGT_w2_OLR(G1H2(26),1,1,2)
call HGT_w2_invQ_OLR(G1H2(26),2,5,2)
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(26),[G1H2(33)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(55),[G1H2(87)])
call HGT_w2_OLR(G1H2(38),1,1,2)
call HGT_w2_invQ_OLR(G1H2(38),2,5,2)
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(38),[G1H2(55)])
call HGT_w2_OLR(G1H2(7),1,1,2)
call HGT_w2_invQ_OLR(G1H2(7),2,5,2)
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(7),[G1H2(56)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(29),[G1H2(81)])
call HGT_w2_OLR(G1H2(20),1,1,2)
call HGT_w2_invQ_OLR(G1H2(20),2,5,2)
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(20),[G1H2(29)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(27),[G1H2(43)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(11),[G1H2(76),G1H2(44)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(5),[G1H2(54),G1H2(5),G1H2(31),G1H2(1)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(36),[G1H2(59),G1H2(16)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(42),[G1H2(40)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(12),[G1H2(64),G1H2(10)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(6),[G1H2(39),G1H2(50),G1H2(22),G1H2(24)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(15),[G1H2(71),G1H2(34)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(28),[G1H2(65),G1H2(9)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(48),[G1H2(21)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(18),[G1H2(58),G1H2(49)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(23),[G1H2(52)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(17),[G1H2(70),G1H2(53)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(51),[G1H2(77),G1H2(41)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(8),[G1H4(14),G1H4(6)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(13),[G1H2(89),G1H2(83)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(14),[G1H2(101),G1H2(95)])
call HGT_w2_OLR(G1H2(2),1,1,2)
call HGT_w2_invQ_OLR(G1H2(2),2,5,2)
  call Hloop_VQ_A(ntryL,G1H2(2),ex3(:),G1H1(1),m3h2x1(:,93),heltab2x2(:,:,93))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,nMT,G2tensor(4),n2h1(87))
  call Hcheck_last_QA_V(ntryL,l_switch,G2H2(18),ex4(:),G2tensor(8),m3h2x1(:,94),heltab2x2(:,:,94))
call HGT_w2_OLR(G1H2(14),1,1,2)
call HGT_w2_invQ_OLR(G1H2(14),2,5,2)
  call Hloop_VA_Q(ntryL,G1H2(14),ex4(:),G1H1(1),m3h2x1(:,95),heltab2x2(:,:,95))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,nMT,G2tensor(14),n2h1(88))
  call Hcheck_last_AQ_V(ntryL,l_switch,G2H2(21),ex3(:),G2tensor(16),m3h2x1(:,96),heltab2x2(:,:,96))
  call Hloop_VQ_A(ntryL,G1H2(26),ex3(:),G1H1(1),m3h2x1(:,97),heltab2x2(:,:,97))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,nMT,G2tensor(2),n2h1(89))
  call Hcheck_last_QA_V(ntryL,l_switch,G2H2(24),ex4(:),G2tensor(29),m3h2x1(:,98),heltab2x2(:,:,98))
  call Hloop_VA_Q(ntryL,G1H2(38),ex4(:),G1H1(1),m3h2x1(:,99),heltab2x2(:,:,99))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,nMT,G2tensor(6),n2h1(90))
  call Hcheck_last_AQ_V(ntryL,l_switch,G2H2(27),ex3(:),G2tensor(31),m3h2x1(:,100),heltab2x2(:,:,100))
  call Hloop_VQ_A(ntryL,G1H2(7),ex3(:),G1H1(1),m3h2x1(:,101),heltab2x2(:,:,101))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,nMT,G2tensor(10),n2h1(91))
  call Hcheck_last_QA_V(ntryL,l_switch,G2H2(30),ex4(:),G2tensor(12),m3h2x1(:,102),heltab2x2(:,:,102))
  call Hloop_VA_Q(ntryL,G1H2(20),ex4(:),G1H1(1),m3h2x1(:,103),heltab2x2(:,:,103))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,nMT,G2tensor(33),n2h1(92))
  call Hcheck_last_AQ_V(ntryL,l_switch,G2H2(33),ex3(:),G2tensor(35),m3h2x1(:,104),heltab2x2(:,:,104))
  call Hloop_VQ_A(ntryL,G1H2(27),ex5(:),G1H1(1),m3h2x1(:,105),heltab2x2(:,:,105))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(1),n2h1(93))
  call Hloop_VQ_A(ntryL,G1H2(11),ex5(:),G1H1(1),m3h2x1(:,106),heltab2x2(:,:,106))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(37),n2h1(94))
  call Hotf_4pt_reduction(G2H2(5),RedSet_4(7),mass4set(:,2),  & 
G1H2(96),G1H2(97),G1H2(98),G1H2(102),G1H2(32),2)
  call HG1shiftOLR(G1H2(97),16,2)
  call Hloop_VQ_A(ntryL,G1H2(25),ex5(:),G1H1(1),m3h2x1(:,107),heltab2x2(:,:,107))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(3),n2h1(95))
  call Hloop_VQ_A(ntryL,G1H2(36),ex5(:),G1H1(1),m3h2x1(:,108),heltab2x2(:,:,108))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(40),n2h1(96))
  call Hloop_VQ_A(ntryL,G1H2(42),ex5(:),G1H1(1),m3h2x1(:,109),heltab2x2(:,:,109))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(5),n2h1(97))
  call Hloop_VQ_A(ntryL,G1H2(12),ex5(:),G1H1(1),m3h2x1(:,110),heltab2x2(:,:,110))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(43),n2h1(98))
  call Hotf_4pt_reduction(G2H2(6),RedSet_4(22),mass4set(:,2),  & 
G1H2(37),G1H2(8),G1H2(13),G1H2(19),G1H2(4),2)
  call HG1shiftOLR(G1H2(8),16,2)
  call Hloop_VQ_A(ntryL,G1H2(46),ex5(:),G1H1(1),m3h2x1(:,111),heltab2x2(:,:,111))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(7),n2h1(99))
  call Hloop_VQ_A(ntryL,G1H2(15),ex5(:),G1H1(1),m3h2x1(:,112),heltab2x2(:,:,112))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(46),n2h1(100))
  call Hloop_VQ_A(ntryL,G1H2(3),ex5(:),G1H1(1),m3h2x1(:,113),heltab2x2(:,:,113))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(9),n2h1(101))
  call Hloop_VQ_A(ntryL,G1H2(28),ex5(:),G1H1(1),m3h2x1(:,114),heltab2x2(:,:,114))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(11),n2h1(102))
  call Hloop_VQ_A(ntryL,G1H2(48),ex5(:),G1H1(1),m3h2x1(:,115),heltab2x2(:,:,115))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(49),n2h1(103))
  call Hloop_VQ_A(ntryL,G1H2(18),ex5(:),G1H1(1),m3h2x1(:,116),heltab2x2(:,:,116))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(13),n2h1(104))
  call Hloop_VQ_A(ntryL,G1H2(23),ex5(:),G1H1(1),m3h2x1(:,117),heltab2x2(:,:,117))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(52),n2h1(105))
  call Hloop_VQ_A(ntryL,G1H2(17),ex5(:),G1H1(1),m3h2x1(:,118),heltab2x2(:,:,118))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(15),n2h1(106))
  call Hloop_VQ_A(ntryL,G1H2(35),ex5(:),G1H1(1),m3h2x1(:,119),heltab2x2(:,:,119))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(17),n2h1(107))
  call Hloop_VQ_A(ntryL,G1H2(51),ex5(:),G1H1(1),m3h2x1(:,120),heltab2x2(:,:,120))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(55),n2h1(108))
  call Hloop_VQ_A(ntryL,G1H2(57),ex5(:),G1H1(1),m3h2x1(:,121),heltab2x2(:,:,121))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(18),n2h1(109))
  call Hloop_VQ_A(ntryL,G1H2(63),ex5(:),G1H1(1),m3h2x1(:,122),heltab2x2(:,:,122))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(19),n2h1(110))
  call Hloop_QV_A(ntryL,G1H4(5),wf4(:,2),G1H1(1),m3h4x1(:,7),heltab2x4(:,:,81))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(20),n2h1(111))
  call Hotf_4pt_reduction(G2H4(8),RedSet_4(110),mass4set(:,2),  & 
G1H4(36),G1H4(3),G1H4(23),G1H4(24),G1H4(25),4)
  call HG1shiftOLR(G1H4(3),12,4)
  call Hloop_QV_A(ntryL,G1H4(7),wf4(:,2),G1H1(1),m3h4x1(:,8),heltab2x4(:,:,82))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(21),n2h1(112))
  call Hloop_QV_A(ntryL,G1H4(13),wf4(:,2),G1H1(1),m3h4x1(:,9),heltab2x4(:,:,83))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(22),n2h1(113))
  call Hloop_QV_A(ntryL,G1H4(17),wf4(:,2),G1H1(1),m3h4x1(:,10),heltab2x4(:,:,84))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(58),n2h1(114))
  call Hloop_VQ_A(ntryL,G1H2(69),ex5(:),G1H1(1),m3h2x1(:,123),heltab2x2(:,:,123))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(23),n2h1(115))
  call Hloop_VQ_A(ntryL,G1H2(75),ex5(:),G1H1(1),m3h2x1(:,124),heltab2x2(:,:,124))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(24),n2h1(116))
  call Hloop_VA_Q(ntryL,G1H2(82),ex4(:),G1H1(1),m3h2x1(:,125),heltab2x2(:,:,125))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,nMT,G2tensor(25),n2h1(117))
  call Hotf_4pt_reduction(G2H2(13),RedSet_4(136),mass4set(:,4),  & 
G1H2(30),G1H2(6),G1H2(45),G1H2(60),G1H2(61),2)
  call HG1shiftOLR(G1H2(6),8,2)
  call Hloop_VA_Q(ntryL,G1H2(88),ex4(:),G1H1(1),m3h2x1(:,126),heltab2x2(:,:,126))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,nMT,G2tensor(27),n2h1(118))
  call Hloop_VA_Q(ntryL,G1H2(93),ex2(:),G1H1(1),m3h2x1(:,127),heltab2x2(:,:,127))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,0,G2tensor(61),n2h1(119))
  call Hloop_VA_Q(ntryL,G1H2(94),ex2(:),G1H1(1),m3h2x1(:,128),heltab2x2(:,:,128))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,0,G2tensor(64),n2h1(120))
  call Hotf_4pt_reduction(G2H2(14),RedSet_4(143),mass4set(:,2),  & 
G1H2(62),G1H2(67),G1H2(68),G1H2(72),G1H2(73),2)
  call HG1shiftOLR(G1H2(67),2,2)
  call Hloop_VA_Q(ntryL,G1H2(99),ex2(:),G1H1(1),m3h2x1(:,129),heltab2x2(:,:,129))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,0,G2tensor(67),n2h1(121))
  call Hloop_VA_Q(ntryL,G1H2(100),ex2(:),G1H1(1),m3h2x1(:,130),heltab2x2(:,:,130))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,0,G2tensor(70),n2h1(122))
  call Hcheck_last_QA_V(ntryL,l_switch,G2H2(9),ex4(:),G2tensor(73),m3h2x1(:,131),heltab2x2(:,:,131))
  call Hcheck_last_QA_V(ntryL,l_switch,G2H2(4),ex4(:),G2tensor(76),m3h2x1(:,132),heltab2x2(:,:,132))
  call Hcheck_last_AQ_V(ntryL,l_switch,G2H2(3),ex3(:),G2tensor(79),m3h2x1(:,133),heltab2x2(:,:,133))
  call Hcheck_last_AQ_V(ntryL,l_switch,G2H2(10),ex3(:),G2tensor(82),m3h2x1(:,134),heltab2x2(:,:,134))
  call Hcheck_last_QA_V(ntryL,l_switch,G2H2(2),ex4(:),G2tensor(85),m3h2x1(:,135),heltab2x2(:,:,135))
  call Hcheck_last_AQ_V(ntryL,l_switch,G2H2(1),ex3(:),G2tensor(88),m3h2x1(:,136),heltab2x2(:,:,136))
  call Hcheck_last_QA_V(ntryL,l_switch,G2H2(7),ex4(:),G2tensor(91),m3h2x1(:,137),heltab2x2(:,:,137))
  call Hcheck_last_AQ_V(ntryL,l_switch,G2H2(8),ex3(:),G2tensor(92),m3h2x1(:,138),heltab2x2(:,:,138))
  call Hotf_4pt_reduction(G2H4(7),RedSet_4(110),mass4set(:,2),  & 
G1H4(26),G1H4(4),G1H4(9),G1H4(29),G1H4(30),4)
  call HG1shiftOLR(G1H4(4),12,4)
  call Hotf_4pt_reduction(G2H2(11),RedSet_4(88),mass4set(:,5),  & 
G1H2(74),G1H2(78),G1H2(79),G1H2(80),G1H2(84),2)
  call HG1shiftOLR(G1H2(78),8,2)
  call Hotf_4pt_reduction(G2H2(12),RedSet_4(95),mass4set(:,5),  & 
G1H2(85),G1H2(86),G1H2(90),G1H2(91),G1H2(92),2)
  call HG1shiftOLR(G1H2(86),4,2)
  call Hloop_VQ_A(ntryL,G1H8(9),wf8(:,3),G1H1(1),m3h8x1(:,1),heltab2x8(:,:,67))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(93),n2h1(123))
  call Hloop_VQ_A(ntryL,G1H8(20),wf8(:,3),G1H1(1),m3h8x1(:,2),heltab2x8(:,:,68))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(94),n2h1(124))
  call Hotf_4pt_reduction(G2H4(9),RedSet_4(90),mass4set(:,2),  & 
G1H4(31),G1H4(32),G1H4(8),G1H4(11),G1H4(12),4)
  call HG1shiftOLR(G1H4(32),12,4)
  call Hotf_4pt_reduction(G2H4(10),RedSet_4(90),mass4set(:,2),  & 
G1H4(18),G1H4(19),G1H4(20),G1H4(28),G1H4(16),4)
  call HG1shiftOLR(G1H4(19),12,4)
  call Hotf_4pt_reduction(G2H4(11),RedSet_4(104),mass4set(:,2),  & 
G1H4(21),G1H4(34),G1H4(27),G1H4(33),G1H4(14),4)
  call HG1shiftOLR(G1H4(34),12,4)
  call Hotf_4pt_reduction(G2H4(12),RedSet_4(104),mass4set(:,2),  & 
G1H4(6),G1H4(5),G1H4(7),G1H4(13),G1H4(17),4)
  call HG1shiftOLR(G1H4(5),12,4)
  call Hloop_VQ_A(ntryL,G1H8(11),wf8(:,6),G1H1(1),m3h8x1(:,3),heltab2x8(:,:,69))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(95),n2h1(125))
  call Hloop_VQ_A(ntryL,G1H8(24),wf8(:,6),G1H1(1),m3h8x1(:,4),heltab2x8(:,:,70))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(96),n2h1(126))
  call Hcheck_last_QA_V(ntryL,l_switch,G2H2(15),ex4(:),G2tensor(97),m3h2x1(:,139),heltab2x2(:,:,139))
  call Hcheck_last_QA_V(ntryL,l_switch,G2H2(17),ex4(:),G2tensor(98),m3h2x1(:,140),heltab2x2(:,:,140))
  call Hcheck_last_AQ_V(ntryL,l_switch,G2H2(19),ex3(:),G2tensor(99),m3h2x1(:,141),heltab2x2(:,:,141))
  call Hcheck_last_AQ_V(ntryL,l_switch,G2H2(22),ex3(:),G2tensor(100),m3h2x1(:,142),heltab2x2(:,:,142))
  call Hcheck_last_AQ_V(ntryL,l_switch,G2H2(23),ex5(:),G2tensor(101),m3h2x1(:,143),heltab2x2(:,:,143))
  call Hcheck_last_AQ_V(ntryL,l_switch,G2H2(26),ex5(:),G2tensor(102),m3h2x1(:,144),heltab2x2(:,:,144))
  call Hcheck_last_AQ_V(ntryL,l_switch,G2H2(28),ex5(:),G2tensor(103),m3h2x1(:,145),heltab2x2(:,:,145))
  call Hcheck_last_AQ_V(ntryL,l_switch,G2H2(31),ex5(:),G2tensor(104),m3h2x1(:,146),heltab2x2(:,:,146))
  call Hcheck_last_QA_V(ntryL,l_switch,G2H2(32),ex4(:),G2tensor(105),m3h2x1(:,147),heltab2x2(:,:,147))
  call Hcheck_last_QA_V(ntryL,l_switch,G2H2(35),ex4(:),G2tensor(106),m3h2x1(:,148),heltab2x2(:,:,148))
  call Hcheck_last_QA_V(ntryL,l_switch,G2H2(36),ex2(:),G2tensor(107),m3h2x1(:,149),heltab2x2(:,:,149))
  call Hcheck_last_QA_V(ntryL,l_switch,G2H2(38),ex2(:),G2tensor(108),m3h2x1(:,150),heltab2x2(:,:,150))
  call Hloop_VQ_A(ntryL,G1H2(96),ex5(:),G1H1(1),m3h2x1(:,151),heltab2x2(:,:,151))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(109),n2h1(127))
  call Hloop_VQ_A(ntryL,G1H2(97),ex5(:),G1H1(1),m3h2x1(:,152),heltab2x2(:,:,152))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),16,0,G2tensor(110),n2h1(128))
  call Hloop_VQ_A(ntryL,G1H2(32),ex5(:),G1H1(1),m3h2x1(:,153),heltab2x2(:,:,153))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(111),n2h1(129))
  call Hloop_VQ_A(ntryL,G1H2(37),ex5(:),G1H1(1),m3h2x1(:,154),heltab2x2(:,:,154))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(112),n2h1(130))
  call Hloop_VQ_A(ntryL,G1H2(8),ex5(:),G1H1(1),m3h2x1(:,155),heltab2x2(:,:,155))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),16,0,G2tensor(113),n2h1(131))
  call Hloop_VQ_A(ntryL,G1H2(4),ex5(:),G1H1(1),m3h2x1(:,156),heltab2x2(:,:,156))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(114),n2h1(132))
  call Hloop_QV_A(ntryL,G1H4(36),wf4(:,2),G1H1(1),m3h4x1(:,11),heltab2x4(:,:,85))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(115),n2h1(133))
  call Hloop_QV_A(ntryL,G1H4(3),wf4(:,2),G1H1(1),m3h4x1(:,12),heltab2x4(:,:,86))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),12,0,G2tensor(116),n2h1(134))
  call Hloop_QV_A(ntryL,G1H4(25),wf4(:,2),G1H1(1),m3h4x1(:,13),heltab2x4(:,:,87))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(117),n2h1(135))
  call Hloop_VA_Q(ntryL,G1H2(30),ex4(:),G1H1(1),m3h2x1(:,157),heltab2x2(:,:,157))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,nMT,G2tensor(118),n2h1(136))
  call Hloop_VA_Q(ntryL,G1H2(6),ex4(:),G1H1(1),m3h2x1(:,158),heltab2x2(:,:,158))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),8,nMT,G2tensor(119),n2h1(137))
  call Hloop_VA_Q(ntryL,G1H2(61),ex4(:),G1H1(1),m3h2x1(:,159),heltab2x2(:,:,159))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,nMT,G2tensor(120),n2h1(138))
  call Hloop_VA_Q(ntryL,G1H2(62),ex2(:),G1H1(1),m3h2x1(:,160),heltab2x2(:,:,160))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,0,G2tensor(121),n2h1(139))
  call Hloop_VA_Q(ntryL,G1H2(67),ex2(:),G1H1(1),m3h2x1(:,161),heltab2x2(:,:,161))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),2,0,G2tensor(122),n2h1(140))
  call Hloop_VA_Q(ntryL,G1H2(73),ex2(:),G1H1(1),m3h2x1(:,162),heltab2x2(:,:,162))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,0,G2tensor(123),n2h1(141))
  call Hcheck_last_UV_W(ntryL,l_switch,G1H4(26),51,wf4(:,2),12,G2tensor(124),m3h4x1(:,14),heltab2x4(:,:,88))
  call Hcheck_last_UV_W(ntryL,l_switch,G1H4(4),0,wf4(:,2),12,G2tensor(125),m3h4x1(:,15),heltab2x4(:,:,89))
  call Hcheck_last_UV_W(ntryL,l_switch,G1H4(30),51,wf4(:,2),12,G2tensor(126),m3h4x1(:,16),heltab2x4(:,:,90))
  call Hloop_VA_Q(ntryL,G1H2(74),ex4(:),G1H1(1),m3h2x1(:,163),heltab2x2(:,:,163))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,nMT,G2tensor(127),n2h1(143))
  call Hloop_VA_Q(ntryL,G1H2(78),ex4(:),G1H1(1),m3h2x1(:,164),heltab2x2(:,:,164))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),8,nMT,G2tensor(128),n2h1(144))
  call Hloop_VA_Q(ntryL,G1H2(84),ex4(:),G1H1(1),m3h2x1(:,165),heltab2x2(:,:,165))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,nMT,G2tensor(129),n2h1(145))
  call Hloop_VQ_A(ntryL,G1H2(85),ex3(:),G1H1(1),m3h2x1(:,166),heltab2x2(:,:,166))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,nMT,G2tensor(130),n2h1(146))
  call Hloop_VQ_A(ntryL,G1H2(86),ex3(:),G1H1(1),m3h2x1(:,167),heltab2x2(:,:,167))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),4,nMT,G2tensor(131),n2h1(147))
  call Hloop_VQ_A(ntryL,G1H2(92),ex3(:),G1H1(1),m3h2x1(:,168),heltab2x2(:,:,168))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,nMT,G2tensor(132),n2h1(148))
  call Hloop_QV_A(ntryL,G1H4(31),wf4(:,2),G1H1(1),m3h4x1(:,17),heltab2x4(:,:,91))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(133),n2h1(149))
  call Hloop_QV_A(ntryL,G1H4(32),wf4(:,2),G1H1(1),m3h4x1(:,18),heltab2x4(:,:,92))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),12,0,G2tensor(134),n2h1(150))
  call Hloop_QV_A(ntryL,G1H4(12),wf4(:,2),G1H1(1),m3h4x1(:,19),heltab2x4(:,:,93))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(135),n2h1(151))
  call Hcheck_last_UV_W(ntryL,l_switch,G1H4(18),51,wf4(:,2),12,G2tensor(136),m3h4x1(:,20),heltab2x4(:,:,94))
  call Hcheck_last_UV_W(ntryL,l_switch,G1H4(19),0,wf4(:,2),12,G2tensor(137),m3h4x1(:,21),heltab2x4(:,:,95))
  call Hcheck_last_UV_W(ntryL,l_switch,G1H4(16),51,wf4(:,2),12,G2tensor(138),m3h4x1(:,22),heltab2x4(:,:,96))
  call Hloop_AV_Q(ntryL,G1H4(21),wf4(:,2),G1H1(1),m3h4x1(:,23),heltab2x4(:,:,97))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,0,G2tensor(139),n2h1(153))
  call Hloop_AV_Q(ntryL,G1H4(34),wf4(:,2),G1H1(1),m3h4x1(:,24),heltab2x4(:,:,98))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),12,0,G2tensor(140),n2h1(154))
  call Hloop_AV_Q(ntryL,G1H4(14),wf4(:,2),G1H1(1),m3h4x1(:,25),heltab2x4(:,:,99))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,0,G2tensor(141),n2h1(155))
  call Hcheck_last_UV_W(ntryL,l_switch,G1H4(6),51,wf4(:,2),12,G2tensor(142),m3h4x1(:,26),heltab2x4(:,:,100))
  call Hcheck_last_UV_W(ntryL,l_switch,G1H4(5),0,wf4(:,2),12,G2tensor(143),m3h4x1(:,27),heltab2x4(:,:,101))
  call Hcheck_last_UV_W(ntryL,l_switch,G1H4(17),51,wf4(:,2),12,G2tensor(144),m3h4x1(:,28),heltab2x4(:,:,102))
  call ol_merge_tensors(G2tensor(124),[G2tensor(115),G2tensor(28),G2tensor(26),G1tensor(226),G1tensor(220),G1tensor(204) &
    ,G1tensor(198)])
  call ol_merge_tensors(G2tensor(136),[G2tensor(133),G2tensor(47),G2tensor(32),G2tensor(30),G1tensor(92),G1tensor(40) &
    ,G1tensor(20)])
  call ol_merge_tensors(G2tensor(142),[G2tensor(139),G2tensor(59),G2tensor(36),G2tensor(34),G1tensor(176),G1tensor(47) &
    ,G1tensor(35)])
  call ol_merge_tensors(G2tensor(38),[G1tensor(56),G1tensor(44),G1tensor(19)])
  call ol_merge_tensors(G2tensor(39),[G1tensor(60)])
  call ol_merge_tensors(G2tensor(41),[G1tensor(68),G1tensor(17),G1tensor(31)])
  call ol_merge_tensors(G2tensor(94),[G2tensor(42),G1tensor(72)])
  call ol_merge_tensors(G2tensor(97),[G2tensor(44),G1tensor(80),G1tensor(29),G1tensor(8)])
  call ol_merge_tensors(G2tensor(45),[G1tensor(84)])
  call ol_merge_tensors(G2tensor(96),[G2tensor(69),G2tensor(48),G1tensor(222),G1tensor(96)])
  call ol_merge_tensors(G2tensor(50),[G1tensor(110),G1tensor(23),G1tensor(16)])
  call ol_merge_tensors(G2tensor(93),[G2tensor(51),G1tensor(114)])
  call ol_merge_tensors(G2tensor(99),[G2tensor(53),G1tensor(122),G1tensor(42),G1tensor(6)])
  call ol_merge_tensors(G2tensor(54),[G1tensor(126)])
  call ol_merge_tensors(G2tensor(56),[G1tensor(140),G1tensor(46),G1tensor(12)])
  call ol_merge_tensors(G2tensor(57),[G1tensor(144)])
  call ol_merge_tensors(G2tensor(95),[G2tensor(72),G2tensor(60),G1tensor(228),G1tensor(180)])
  call ol_merge_tensors(G2tensor(62),[G1tensor(206)])
  call ol_merge_tensors(G2tensor(63),[G1tensor(210)])
  call ol_merge_tensors(G2tensor(105),[G2tensor(65),G1tensor(212)])
  call ol_merge_tensors(G2tensor(66),[G1tensor(216)])
  call ol_merge_tensors(G2tensor(52),[G2tensor(68),G1tensor(218),G1tensor(153),G1tensor(141),G1tensor(135)])
  call ol_merge_tensors(G2tensor(1),[G2tensor(71),G1tensor(224),G1tensor(99),G1tensor(57),G1tensor(51)])
  call ol_merge_tensors(G2tensor(74),[G1tensor(230)])
  call ol_merge_tensors(G2tensor(75),[G1tensor(234)])
  call ol_merge_tensors(G2tensor(121),[G2tensor(107),G2tensor(77),G1tensor(263),G1tensor(257),G1tensor(236)])
  call ol_merge_tensors(G2tensor(78),[G1tensor(240)])
  call ol_merge_tensors(G2tensor(80),[G1tensor(242),G1tensor(50),G1tensor(13)])
  call ol_merge_tensors(G2tensor(81),[G1tensor(246)])
  call ol_merge_tensors(G2tensor(83),[G1tensor(248),G1tensor(134),G1tensor(24)])
  call ol_merge_tensors(G2tensor(84),[G1tensor(252)])
  call ol_merge_tensors(G2tensor(85),[G2tensor(86),G1tensor(254),G1tensor(74),G1tensor(2)])
  call ol_merge_tensors(G2tensor(87),[G1tensor(258)])
  call ol_merge_tensors(G2tensor(88),[G2tensor(89),G1tensor(260),G1tensor(116),G1tensor(30)])
  call ol_merge_tensors(G2tensor(90),[G1tensor(264)])
  call ol_merge_tensors(G1tensor(62),[G1tensor(25)])
  call ol_merge_tensors(G2tensor(2),[G1tensor(43)])
  call ol_merge_tensors(G2tensor(29),[G1tensor(86),G1tensor(14)])
  call ol_merge_tensors(G1tensor(98),[G1tensor(38)])
  call ol_merge_tensors(G1tensor(104),[G1tensor(3)])
  call ol_merge_tensors(G2tensor(6),[G1tensor(249),G1tensor(5)])
  call ol_merge_tensors(G2tensor(31),[G1tensor(128),G1tensor(9)])
  call ol_merge_tensors(G2tensor(67),[G1tensor(261),G1tensor(11)])
  call ol_merge_tensors(G1tensor(146),[G1tensor(15)])
  call ol_merge_tensors(G2tensor(61),[G1tensor(255),G1tensor(18)])
  call ol_merge_tensors(G1tensor(152),[G1tensor(21)])
  call ol_merge_tensors(G1tensor(158),[G1tensor(22)])
  call ol_merge_tensors(G2tensor(10),[G1tensor(34)])
  call ol_merge_tensors(G2tensor(91),[G1tensor(164),G1tensor(28)])
  call ol_merge_tensors(G2tensor(12),[G1tensor(170),G1tensor(33)])
  call ol_merge_tensors(G2tensor(33),[G1tensor(243),G1tensor(41)])
  call ol_merge_tensors(G2tensor(92),[G1tensor(182),G1tensor(48)])
  call ol_merge_tensors(G2tensor(35),[G1tensor(188),G1tensor(45)])
  call ol_merge_tensors(G1tensor(63),[G1tensor(52)])
  call ol_merge_tensors(G2tensor(3),[G1tensor(137),G1tensor(69),G1tensor(53)])
  call ol_merge_tensors(G2tensor(37),[G1tensor(238),G1tensor(106),G1tensor(64),G1tensor(58)])
  call ol_merge_tensors(G2tensor(109),[G2tensor(101),G1tensor(143),G1tensor(112),G1tensor(70),G1tensor(59)])
  call ol_merge_tensors(G2tensor(40),[G1tensor(209),G1tensor(149),G1tensor(71),G1tensor(65)])
  call ol_merge_tensors(G2tensor(5),[G1tensor(165),G1tensor(81),G1tensor(75)])
  call ol_merge_tensors(G1tensor(87),[G1tensor(76)])
  call ol_merge_tensors(G2tensor(7),[G1tensor(119),G1tensor(93),G1tensor(77)])
  call ol_merge_tensors(G2tensor(43),[G1tensor(214),G1tensor(172),G1tensor(88),G1tensor(82)])
  call ol_merge_tensors(G2tensor(112),[G2tensor(103),G1tensor(178),G1tensor(125),G1tensor(94),G1tensor(83)])
  call ol_merge_tensors(G2tensor(46),[G1tensor(233),G1tensor(131),G1tensor(95),G1tensor(89)])
  call ol_merge_tensors(G1tensor(105),[G1tensor(100)])
  call ol_merge_tensors(G2tensor(9),[G1tensor(155),G1tensor(111),G1tensor(101)])
  call ol_merge_tensors(G2tensor(11),[G1tensor(215),G1tensor(161),G1tensor(113),G1tensor(107)])
  call ol_merge_tensors(G2tensor(49),[G1tensor(183),G1tensor(123),G1tensor(117)])
  call ol_merge_tensors(G1tensor(129),[G1tensor(118)])
  call ol_merge_tensors(G2tensor(13),[G1tensor(208),G1tensor(190),G1tensor(130),G1tensor(124)])
  call ol_merge_tensors(G1tensor(147),[G1tensor(136)])
  call ol_merge_tensors(G2tensor(15),[G1tensor(232),G1tensor(160),G1tensor(148),G1tensor(142)])
  call ol_merge_tensors(G1tensor(159),[G1tensor(154)])
  call ol_merge_tensors(G1tensor(171),[G1tensor(166)])
  call ol_merge_tensors(G2tensor(17),[G1tensor(185),G1tensor(177),G1tensor(167)])
  call ol_merge_tensors(G2tensor(55),[G1tensor(239),G1tensor(191),G1tensor(179),G1tensor(173)])
  call ol_merge_tensors(G1tensor(189),[G1tensor(184)])
  call ol_merge_tensors(G2tensor(4),[G1tensor(194)])
  call ol_merge_tensors(G2tensor(73),[G1tensor(195)])
  call ol_merge_tensors(G2tensor(76),[G1tensor(196)])
  call ol_merge_tensors(G2tensor(8),[G1tensor(197)])
  call ol_merge_tensors(G2tensor(14),[G1tensor(200)])
  call ol_merge_tensors(G2tensor(79),[G1tensor(201)])
  call ol_merge_tensors(G2tensor(82),[G1tensor(202)])
  call ol_merge_tensors(G2tensor(16),[G1tensor(203)])
  call ol_merge_tensors(G2tensor(18),[G1tensor(207)])
  call ol_merge_tensors(G2tensor(19),[G1tensor(213)])
  call ol_merge_tensors(G2tensor(20),[G1tensor(219)])
  call ol_merge_tensors(G2tensor(21),[G1tensor(221)])
  call ol_merge_tensors(G2tensor(22),[G1tensor(225)])
  call ol_merge_tensors(G2tensor(58),[G1tensor(227)])
  call ol_merge_tensors(G2tensor(23),[G1tensor(231)])
  call ol_merge_tensors(G2tensor(24),[G1tensor(237)])
  call ol_merge_tensors(G2tensor(25),[G1tensor(244)])
  call ol_merge_tensors(G2tensor(118),[G1tensor(251),G1tensor(245)])
  call ol_merge_tensors(G2tensor(27),[G1tensor(250)])
  call ol_merge_tensors(G2tensor(64),[G1tensor(256)])
  call ol_merge_tensors(G2tensor(70),[G1tensor(262)])
  call Hotf_4pt_reduction_last(G2tensor(124),RedSet_4(110),mass4set(:,2),  & 
G1tensor(1),G1tensor(37),G1tensor(26),G1tensor(4),G1tensor(10))
  call G_TensorShift(G1tensor(37),12)
  call Hotf_4pt_reduction_last(G2tensor(136),RedSet_4(90),mass4set(:,2),  & 
G1tensor(36),G1tensor(27),G1tensor(39),G1tensor(49),G1tensor(55))
  call G_TensorShift(G1tensor(27),12)
  call Hotf_4pt_reduction_last(G2tensor(142),RedSet_4(104),mass4set(:,2),  & 
G1tensor(61),G1tensor(67),G1tensor(73),G1tensor(79),G1tensor(85))
  call G_TensorShift(G1tensor(67),12)
  call Hotf_4pt_reduction_last(G2tensor(38),RedSet_4(84),mass4set(:,2),  & 
G1tensor(91),G1tensor(97),G1tensor(103),G1tensor(109),G1tensor(115))
  call G_TensorShift(G1tensor(97),2)
  call Hotf_4pt_reduction_last(G2tensor(39),RedSet_4(8),mass4set(:,2),  & 
G1tensor(121),G1tensor(127),G1tensor(133),G1tensor(139),G1tensor(145))
  call G_TensorShift(G1tensor(127),18)
  call Hotf_4pt_reduction_last(G2tensor(41),RedSet_4(86),mass4set(:,6),  & 
G1tensor(151),G1tensor(157),G1tensor(163),G1tensor(169),G1tensor(175))
  call G_TensorShift(G1tensor(157),3)
  call Hotf_4pt_reduction_last(G2tensor(94),RedSet_4(13),mass4set(:,6),  & 
G1tensor(181),G1tensor(187),G1tensor(193),G1tensor(199),G1tensor(205))
  call G_TensorShift(G1tensor(187),19)
  call Hotf_4pt_reduction_last(G2tensor(97),RedSet_4(88),mass4set(:,1),  & 
G1tensor(211),G1tensor(217),G1tensor(223),G1tensor(229),G1tensor(235))
  call G_TensorShift(G1tensor(217),8)
  call Hotf_4pt_reduction_last(G2tensor(45),RedSet_4(23),mass4set(:,1),  & 
G1tensor(241),G1tensor(247),G1tensor(253),G1tensor(259),G1tensor(226))
  call G_TensorShift(G1tensor(247),24)
  call Hotf_4pt_reduction_last(G2tensor(96),RedSet_4(28),mass4set(:,2),  & 
G1tensor(220),G1tensor(204),G1tensor(198),G1tensor(92),G1tensor(40))
  call G_TensorShift(G1tensor(204),28)
  call Hotf_4pt_reduction_last(G2tensor(50),RedSet_4(93),mass4set(:,6),  & 
G1tensor(20),G1tensor(176),G1tensor(47),G1tensor(35),G1tensor(56))
  call G_TensorShift(G1tensor(176),3)
  call Hotf_4pt_reduction_last(G2tensor(93),RedSet_4(38),mass4set(:,6),  & 
G1tensor(44),G1tensor(19),G1tensor(60),G1tensor(68),G1tensor(17))
  call G_TensorShift(G1tensor(19),19)
  call Hotf_4pt_reduction_last(G2tensor(99),RedSet_4(95),mass4set(:,1),  & 
G1tensor(31),G1tensor(72),G1tensor(80),G1tensor(29),G1tensor(8))
  call G_TensorShift(G1tensor(72),4)
  call Hotf_4pt_reduction_last(G2tensor(54),RedSet_4(46),mass4set(:,1),  & 
G1tensor(84),G1tensor(222),G1tensor(96),G1tensor(110),G1tensor(23))
  call G_TensorShift(G1tensor(222),20)
  call Hotf_4pt_reduction_last(G2tensor(56),RedSet_4(98),mass4set(:,2),  & 
G1tensor(16),G1tensor(114),G1tensor(122),G1tensor(42),G1tensor(6))
  call G_TensorShift(G1tensor(114),1)
  call Hotf_4pt_reduction_last(G2tensor(57),RedSet_4(56),mass4set(:,2),  & 
G1tensor(126),G1tensor(140),G1tensor(46),G1tensor(12),G1tensor(144))
  call G_TensorShift(G1tensor(140),17)
  call Hotf_4pt_reduction_last(G2tensor(95),RedSet_4(74),mass4set(:,2),  & 
G1tensor(228),G1tensor(180),G1tensor(206),G1tensor(210),G1tensor(212))
  call G_TensorShift(G1tensor(180),28)
  call Hotf_4pt_reduction_last(G2tensor(62),RedSet_4(148),mass4set(:,3),  & 
G1tensor(216),G1tensor(218),G1tensor(153),G1tensor(141),G1tensor(135))
  call G_TensorShift(G1tensor(218),4)
  call Hotf_4pt_reduction_last(G2tensor(63),RedSet_4(117),mass4set(:,3),  & 
G1tensor(224),G1tensor(99),G1tensor(57),G1tensor(51),G1tensor(230))
  call G_TensorShift(G1tensor(99),20)
  call Hotf_4pt_reduction_last(G2tensor(105),RedSet_4(136),mass4set(:,3),  & 
G1tensor(234),G1tensor(263),G1tensor(257),G1tensor(236),G1tensor(240))
  call G_TensorShift(G1tensor(263),8)
  call Hotf_4pt_reduction_last(G2tensor(66),RedSet_4(120),mass4set(:,3),  & 
G1tensor(242),G1tensor(50),G1tensor(13),G1tensor(246),G1tensor(248))
  call G_TensorShift(G1tensor(50),24)
  call Hotf_4pt_reduction_last(G2tensor(52),RedSet_4(51),mass4set(:,2),  & 
G1tensor(134),G1tensor(24),G1tensor(252),G1tensor(254),G1tensor(74))
  call G_TensorShift(G1tensor(24),16)
  call Hotf_4pt_reduction_last(G2tensor(1),RedSet_4(1),mass4set(:,2),  & 
G1tensor(2),G1tensor(258),G1tensor(260),G1tensor(116),G1tensor(30))
  call G_TensorShift(G1tensor(258),16)
  call Hotf_4pt_reduction_last(G2tensor(74),RedSet_4(149),mass4set(:,2),  & 
G1tensor(264),G1tensor(25),G1tensor(43),G1tensor(86),G1tensor(14))
  call G_TensorShift(G1tensor(25),1)
  call Hotf_4pt_reduction_last(G2tensor(75),RedSet_4(129),mass4set(:,2),  & 
G1tensor(38),G1tensor(3),G1tensor(249),G1tensor(5),G1tensor(128))
  call G_TensorShift(G1tensor(3),17)
  call Hotf_4pt_reduction_last(G2tensor(121),RedSet_4(143),mass4set(:,2),  & 
G1tensor(9),G1tensor(261),G1tensor(11),G1tensor(15),G1tensor(255))
  call G_TensorShift(G1tensor(261),2)
  call Hotf_4pt_reduction_last(G2tensor(78),RedSet_4(132),mass4set(:,2),  & 
G1tensor(18),G1tensor(21),G1tensor(22),G1tensor(34),G1tensor(164))
  call G_TensorShift(G1tensor(21),18)
  call Hotf_4pt_reduction_last(G2tensor(80),RedSet_4(83),mass4set(:,7),  & 
G1tensor(28),G1tensor(170),G1tensor(33),G1tensor(243),G1tensor(41))
  call G_TensorShift(G1tensor(170),2)
  call Hotf_4pt_reduction_last(G2tensor(81),RedSet_4(137),mass4set(:,4),  & 
G1tensor(182),G1tensor(48),G1tensor(188),G1tensor(45),G1tensor(52))
  call G_TensorShift(G1tensor(48),10)
  call Hotf_4pt_reduction_last(G2tensor(83),RedSet_4(97),mass4set(:,7),  & 
G1tensor(137),G1tensor(69),G1tensor(53),G1tensor(238),G1tensor(106))
  call G_TensorShift(G1tensor(69),1)
  call Hotf_4pt_reduction_last(G2tensor(84),RedSet_4(140),mass4set(:,4),  & 
G1tensor(64),G1tensor(58),G1tensor(143),G1tensor(112),G1tensor(70))
  call G_TensorShift(G1tensor(58),9)
  call Hotf_4pt_reduction_last(G2tensor(85),RedSet_4(87),mass4set(:,1),  & 
G1tensor(59),G1tensor(209),G1tensor(149),G1tensor(71),G1tensor(65))
  call G_TensorShift(G1tensor(209),8)
  call Hotf_4pt_reduction_last(G2tensor(87),RedSet_4(144),mass4set(:,1),  & 
G1tensor(165),G1tensor(81),G1tensor(75),G1tensor(76),G1tensor(119))
  call G_TensorShift(G1tensor(81),10)
  call Hotf_4pt_reduction_last(G2tensor(88),RedSet_4(94),mass4set(:,1),  & 
G1tensor(93),G1tensor(77),G1tensor(214),G1tensor(172),G1tensor(88))
  call G_TensorShift(G1tensor(77),4)
  call Hotf_4pt_reduction_last(G2tensor(90),RedSet_4(147),mass4set(:,1),  & 
G1tensor(82),G1tensor(178),G1tensor(125),G1tensor(94),G1tensor(83))
  call G_TensorShift(G1tensor(178),6)
  call Hotf_4pt_reduction_last(G2tensor(2),RedSet_4(150),mass4set(:,8),  & 
G1tensor(233),G1tensor(131),G1tensor(95),G1tensor(89),G1tensor(100))
  call G_TensorShift(G1tensor(131),4)
  call Hotf_4pt_reduction_last(G2tensor(29),RedSet_4(89),mass4set(:,1),  & 
G1tensor(155),G1tensor(111),G1tensor(101),G1tensor(215),G1tensor(161))
  call G_TensorShift(G1tensor(111),8)
  call Hotf_4pt_reduction_last(G2tensor(6),RedSet_4(138),mass4set(:,8),  & 
G1tensor(113),G1tensor(107),G1tensor(183),G1tensor(123),G1tensor(117))
  call G_TensorShift(G1tensor(107),8)
  call Hotf_4pt_reduction_last(G2tensor(31),RedSet_4(96),mass4set(:,1),  & 
G1tensor(118),G1tensor(208),G1tensor(190),G1tensor(130),G1tensor(124))
  call G_TensorShift(G1tensor(208),4)
  call Hotf_4pt_reduction_last(G2tensor(67),RedSet_4(145),mass4set(:,6),  & 
G1tensor(136),G1tensor(232),G1tensor(160),G1tensor(148),G1tensor(142))
  call G_TensorShift(G1tensor(232),2)
  call Hotf_4pt_reduction_last(G2tensor(61),RedSet_4(141),mass4set(:,6),  & 
G1tensor(154),G1tensor(166),G1tensor(185),G1tensor(177),G1tensor(167))
  call G_TensorShift(G1tensor(166),2)
  call Hotf_4pt_reduction_last(G2tensor(10),RedSet_4(151),mass4set(:,8),  & 
G1tensor(239),G1tensor(191),G1tensor(179),G1tensor(173),G1tensor(184))
  call G_TensorShift(G1tensor(191),4)
  call Hotf_4pt_reduction_last(G2tensor(91),RedSet_4(102),mass4set(:,1),  & 
G1tensor(194),G1tensor(195),G1tensor(196),G1tensor(197),G1tensor(200))
  call G_TensorShift(G1tensor(195),8)
  call Hotf_4pt_reduction_last(G2tensor(12),RedSet_4(103),mass4set(:,1),  & 
G1tensor(201),G1tensor(202),G1tensor(203),G1tensor(207),G1tensor(213))
  call G_TensorShift(G1tensor(202),8)
  call Hotf_4pt_reduction_last(G2tensor(33),RedSet_4(134),mass4set(:,8),  & 
G1tensor(219),G1tensor(221),G1tensor(225),G1tensor(227),G1tensor(231))
  call G_TensorShift(G1tensor(221),8)
  call Hotf_4pt_reduction_last(G2tensor(92),RedSet_4(105),mass4set(:,1),  & 
G1tensor(237),G1tensor(244),G1tensor(251),G1tensor(245),G1tensor(250))
  call G_TensorShift(G1tensor(244),4)
  call Hotf_4pt_reduction_last(G2tensor(35),RedSet_4(106),mass4set(:,1),  & 
G1tensor(256),G1tensor(262),G1tensor(265),G1tensor(266),G1tensor(267))
  call G_TensorShift(G1tensor(262),4)
  call Hotf_4pt_reduction_last(G2tensor(3),RedSet_4(3),mass4set(:,7),  & 
G1tensor(268),G1tensor(269),G1tensor(270),G1tensor(271),G1tensor(272))
  call G_TensorShift(G1tensor(269),16)
  call Hotf_4pt_reduction_last(G2tensor(37),RedSet_4(6),mass4set(:,2),  & 
G1tensor(273),G1tensor(274),G1tensor(275),G1tensor(276),G1tensor(277))
  call G_TensorShift(G1tensor(274),16)
  call Hotf_4pt_reduction_last(G2tensor(109),RedSet_4(7),mass4set(:,2),  & 
G1tensor(278),G1tensor(279),G1tensor(280),G1tensor(281),G1tensor(282))
  call G_TensorShift(G1tensor(279),16)
  call Hotf_4pt_reduction_last(G2tensor(40),RedSet_4(10),mass4set(:,6),  & 
G1tensor(283),G1tensor(284),G1tensor(285),G1tensor(286),G1tensor(287))
  call G_TensorShift(G1tensor(284),16)
  call Hotf_4pt_reduction_last(G2tensor(5),RedSet_4(16),mass4set(:,6),  & 
G1tensor(288),G1tensor(289),G1tensor(290),G1tensor(291),G1tensor(292))
  call G_TensorShift(G1tensor(289),16)
  call Hotf_4pt_reduction_last(G2tensor(7),RedSet_4(18),mass4set(:,2),  & 
G1tensor(293),G1tensor(294),G1tensor(295),G1tensor(296),G1tensor(297))
  call G_TensorShift(G1tensor(294),16)
  call Hotf_4pt_reduction_last(G2tensor(43),RedSet_4(21),mass4set(:,6),  & 
G1tensor(298),G1tensor(299),G1tensor(300),G1tensor(301),G1tensor(302))
  call G_TensorShift(G1tensor(299),16)
  call Hotf_4pt_reduction_last(G2tensor(112),RedSet_4(22),mass4set(:,2),  & 
G1tensor(303),G1tensor(304),G1tensor(305),G1tensor(306),G1tensor(307))
  call G_TensorShift(G1tensor(304),16)
  call Hotf_4pt_reduction_last(G2tensor(46),RedSet_4(25),mass4set(:,2),  & 
G1tensor(308),G1tensor(309),G1tensor(310),G1tensor(311),G1tensor(312))
  call G_TensorShift(G1tensor(309),16)
  call Hotf_4pt_reduction_last(G2tensor(9),RedSet_4(32),mass4set(:,7),  & 
G1tensor(313),G1tensor(314),G1tensor(315),G1tensor(316),G1tensor(317))
  call G_TensorShift(G1tensor(314),16)
  call Hotf_4pt_reduction_last(G2tensor(11),RedSet_4(35),mass4set(:,6),  & 
G1tensor(318),G1tensor(319),G1tensor(320),G1tensor(321),G1tensor(322))
  call G_TensorShift(G1tensor(319),16)
  call Hotf_4pt_reduction_last(G2tensor(49),RedSet_4(41),mass4set(:,6),  & 
G1tensor(323),G1tensor(324),G1tensor(325),G1tensor(326),G1tensor(327))
  call G_TensorShift(G1tensor(324),16)
  call Hotf_4pt_reduction_last(G2tensor(13),RedSet_4(45),mass4set(:,6),  & 
G1tensor(328),G1tensor(329),G1tensor(330),G1tensor(331),G1tensor(332))
  call G_TensorShift(G1tensor(329),16)
  call Hotf_4pt_reduction_last(G2tensor(15),RedSet_4(55),mass4set(:,2),  & 
G1tensor(333),G1tensor(334),G1tensor(335),G1tensor(336),G1tensor(337))
  call G_TensorShift(G1tensor(334),16)
  call Hotf_4pt_reduction_last(G2tensor(17),RedSet_4(68),mass4set(:,2),  & 
G1tensor(338),G1tensor(339),G1tensor(340),G1tensor(341),G1tensor(342))
  call G_TensorShift(G1tensor(339),16)
  call Hotf_4pt_reduction_last(G2tensor(55),RedSet_4(71),mass4set(:,2),  & 
G1tensor(343),G1tensor(344),G1tensor(345),G1tensor(346),G1tensor(347))
  call G_TensorShift(G1tensor(344),16)
  call Hotf_4pt_reduction_last(G2tensor(4),RedSet_4(152),mass4set(:,8),  & 
G1tensor(348),G1tensor(349),G1tensor(350),G1tensor(351),G1tensor(352))
  call G_TensorShift(G1tensor(349),4)
  call Hotf_4pt_reduction_last(G2tensor(73),RedSet_4(107),mass4set(:,1),  & 
G1tensor(353),G1tensor(354),G1tensor(355),G1tensor(356),G1tensor(357))
  call G_TensorShift(G1tensor(354),8)
  call Hotf_4pt_reduction_last(G2tensor(76),RedSet_4(108),mass4set(:,1),  & 
G1tensor(358),G1tensor(359),G1tensor(360),G1tensor(361),G1tensor(362))
  call G_TensorShift(G1tensor(359),8)
  call Hotf_4pt_reduction_last(G2tensor(8),RedSet_4(109),mass4set(:,1),  & 
G1tensor(363),G1tensor(364),G1tensor(365),G1tensor(366),G1tensor(367))
  call G_TensorShift(G1tensor(364),8)
  call Hotf_4pt_reduction_last(G2tensor(14),RedSet_4(153),mass4set(:,8),  & 
G1tensor(368),G1tensor(369),G1tensor(370),G1tensor(371),G1tensor(372))
  call G_TensorShift(G1tensor(369),8)
  call Hotf_4pt_reduction_last(G2tensor(79),RedSet_4(112),mass4set(:,1),  & 
G1tensor(373),G1tensor(374),G1tensor(375),G1tensor(376),G1tensor(377))
  call G_TensorShift(G1tensor(374),4)
  call Hotf_4pt_reduction_last(G2tensor(82),RedSet_4(113),mass4set(:,1),  & 
G1tensor(378),G1tensor(379),G1tensor(380),G1tensor(381),G1tensor(382))
  call G_TensorShift(G1tensor(379),4)
  call Hotf_4pt_reduction_last(G2tensor(16),RedSet_4(114),mass4set(:,1),  & 
G1tensor(383),G1tensor(384),G1tensor(385),G1tensor(386),G1tensor(387))
  call G_TensorShift(G1tensor(384),4)
  call Hotf_4pt_reduction_last(G2tensor(18),RedSet_4(116),mass4set(:,9),  & 
G1tensor(388),G1tensor(389),G1tensor(390),G1tensor(391),G1tensor(392))
  call G_TensorShift(G1tensor(389),16)
  call Hotf_4pt_reduction_last(G2tensor(19),RedSet_4(119),mass4set(:,9),  & 
G1tensor(393),G1tensor(394),G1tensor(395),G1tensor(396),G1tensor(397))
  call G_TensorShift(G1tensor(394),16)
  call Hotf_4pt_reduction_last(G2tensor(20),RedSet_4(122),mass4set(:,2),  & 
G1tensor(398),G1tensor(399),G1tensor(400),G1tensor(401),G1tensor(402))
  call G_TensorShift(G1tensor(399),12)
  call Hotf_4pt_reduction_last(G2tensor(21),RedSet_4(123),mass4set(:,2),  & 
G1tensor(403),G1tensor(404),G1tensor(405),G1tensor(406),G1tensor(407))
  call G_TensorShift(G1tensor(404),12)
  call Hotf_4pt_reduction_last(G2tensor(22),RedSet_4(125),mass4set(:,2),  & 
G1tensor(408),G1tensor(409),G1tensor(410),G1tensor(411),G1tensor(412))
  call G_TensorShift(G1tensor(409),12)
  call Hotf_4pt_reduction_last(G2tensor(58),RedSet_4(126),mass4set(:,2),  & 
G1tensor(413),G1tensor(414),G1tensor(415),G1tensor(416),G1tensor(417))
  call G_TensorShift(G1tensor(414),12)
  call Hotf_4pt_reduction_last(G2tensor(23),RedSet_4(128),mass4set(:,2),  & 
G1tensor(418),G1tensor(419),G1tensor(420),G1tensor(421),G1tensor(422))
  call G_TensorShift(G1tensor(419),16)
  call Hotf_4pt_reduction_last(G2tensor(24),RedSet_4(131),mass4set(:,2),  & 
G1tensor(423),G1tensor(424),G1tensor(425),G1tensor(426),G1tensor(427))
  call G_TensorShift(G1tensor(424),16)
  call Hotf_4pt_reduction_last(G2tensor(25),RedSet_4(135),mass4set(:,4),  & 
G1tensor(428),G1tensor(429),G1tensor(430),G1tensor(431),G1tensor(432))
  call G_TensorShift(G1tensor(429),8)
  call Hotf_4pt_reduction_last(G2tensor(118),RedSet_4(136),mass4set(:,4),  & 
G1tensor(433),G1tensor(434),G1tensor(435),G1tensor(436),G1tensor(437))
  call G_TensorShift(G1tensor(434),8)
  call Hotf_4pt_reduction_last(G2tensor(27),RedSet_4(139),mass4set(:,4),  & 
G1tensor(438),G1tensor(439),G1tensor(440),G1tensor(441),G1tensor(442))
  call G_TensorShift(G1tensor(439),8)
  call Hotf_4pt_reduction_last(G2tensor(64),RedSet_4(142),mass4set(:,6),  & 
G1tensor(443),G1tensor(444),G1tensor(445),G1tensor(446),G1tensor(447))
  call G_TensorShift(G1tensor(444),2)
  call Hotf_4pt_reduction_last(G2tensor(70),RedSet_4(146),mass4set(:,6),  & 
G1tensor(448),G1tensor(449),G1tensor(450),G1tensor(451),G1tensor(452))
  call G_TensorShift(G1tensor(449),2)
  call Hotf_4pt_reduction_last(G2tensor(127),RedSet_4(88),mass4set(:,5),  & 
G1tensor(453),G1tensor(454),G1tensor(455),G1tensor(456),G1tensor(457))
  call G_TensorShift(G1tensor(454),8)
  call Hotf_4pt_reduction_last(G2tensor(130),RedSet_4(95),mass4set(:,5),  & 
G1tensor(458),G1tensor(459),G1tensor(460),G1tensor(461),G1tensor(462))
  call G_TensorShift(G1tensor(459),4)
  call Hotf_4pt_reduction_last(G1tensor(1),RedSet_4(110),mass4set(:,2),  & 
G0tensor(1),G0tensor(2),G0tensor(3),G0tensor(4),G0tensor(5))
  call Hotf_4pt_reduction_last(G1tensor(36),RedSet_4(90),mass4set(:,2),  & 
G0tensor(6),G0tensor(7),G0tensor(8),G0tensor(9),G0tensor(10))
  call Hotf_4pt_reduction_last(G1tensor(61),RedSet_4(104),mass4set(:,2),  & 
G0tensor(11),G0tensor(12),G0tensor(13),G0tensor(14),G0tensor(15))
  call Hotf_4pt_reduction_last(G1tensor(91),RedSet_4(84),mass4set(:,2),  & 
G0tensor(16),G0tensor(17),G0tensor(18),G0tensor(19),G0tensor(20))
  call Hotf_4pt_reduction_last(G1tensor(121),RedSet_4(8),mass4set(:,2),  & 
G0tensor(21),G0tensor(22),G0tensor(23),G0tensor(24),G0tensor(25))
  call Hotf_4pt_reduction_last(G1tensor(151),RedSet_4(86),mass4set(:,6),  & 
G0tensor(26),G0tensor(27),G0tensor(28),G0tensor(29),G0tensor(30))
  call Hotf_4pt_reduction_last(G1tensor(181),RedSet_4(13),mass4set(:,6),  & 
G0tensor(31),G0tensor(32),G0tensor(33),G0tensor(34),G0tensor(35))
  call Hotf_4pt_reduction_last(G1tensor(211),RedSet_4(88),mass4set(:,1),  & 
G0tensor(36),G0tensor(37),G0tensor(38),G0tensor(39),G0tensor(40))
  call Hotf_4pt_reduction_last(G1tensor(241),RedSet_4(23),mass4set(:,1),  & 
G0tensor(41),G0tensor(42),G0tensor(43),G0tensor(44),G0tensor(45))
  call Hotf_4pt_reduction_last(G1tensor(220),RedSet_4(28),mass4set(:,2),  & 
G0tensor(46),G0tensor(47),G0tensor(48),G0tensor(49),G0tensor(50))
  call Hotf_4pt_reduction_last(G1tensor(20),RedSet_4(93),mass4set(:,6),  & 
G0tensor(51),G0tensor(52),G0tensor(53),G0tensor(54),G0tensor(55))
  call Hotf_4pt_reduction_last(G1tensor(44),RedSet_4(38),mass4set(:,6),  & 
G0tensor(56),G0tensor(57),G0tensor(58),G0tensor(59),G0tensor(60))
  call Hotf_4pt_reduction_last(G1tensor(31),RedSet_4(95),mass4set(:,1),  & 
G0tensor(61),G0tensor(62),G0tensor(63),G0tensor(64),G0tensor(65))
  call Hotf_4pt_reduction_last(G1tensor(84),RedSet_4(46),mass4set(:,1),  & 
G0tensor(66),G0tensor(67),G0tensor(68),G0tensor(69),G0tensor(70))
  call Hotf_4pt_reduction_last(G1tensor(16),RedSet_4(98),mass4set(:,2),  & 
G0tensor(71),G0tensor(72),G0tensor(73),G0tensor(74),G0tensor(75))
  call Hotf_4pt_reduction_last(G1tensor(126),RedSet_4(56),mass4set(:,2),  & 
G0tensor(76),G0tensor(77),G0tensor(78),G0tensor(79),G0tensor(80))
  call Hotf_4pt_reduction_last(G1tensor(228),RedSet_4(74),mass4set(:,2),  & 
G0tensor(81),G0tensor(82),G0tensor(83),G0tensor(84),G0tensor(85))
  call Hotf_4pt_reduction_last(G1tensor(216),RedSet_4(148),mass4set(:,3),  & 
G0tensor(86),G0tensor(87),G0tensor(88),G0tensor(89),G0tensor(90))
  call Hotf_4pt_reduction_last(G1tensor(224),RedSet_4(117),mass4set(:,3),  & 
G0tensor(91),G0tensor(92),G0tensor(93),G0tensor(94),G0tensor(95))
  call Hotf_4pt_reduction_last(G1tensor(234),RedSet_4(136),mass4set(:,3),  & 
G0tensor(96),G0tensor(97),G0tensor(98),G0tensor(99),G0tensor(100))
  call Hotf_4pt_reduction_last(G1tensor(242),RedSet_4(120),mass4set(:,3),  & 
G0tensor(101),G0tensor(102),G0tensor(103),G0tensor(104),G0tensor(105))
  call Hotf_4pt_reduction_last(G1tensor(134),RedSet_4(51),mass4set(:,2),  & 
G0tensor(106),G0tensor(107),G0tensor(108),G0tensor(109),G0tensor(110))
  call Hotf_4pt_reduction_last(G1tensor(2),RedSet_4(1),mass4set(:,2),  & 
G0tensor(111),G0tensor(112),G0tensor(113),G0tensor(114),G0tensor(115))
  call Hotf_4pt_reduction_last(G1tensor(264),RedSet_4(149),mass4set(:,2),  & 
G0tensor(116),G0tensor(117),G0tensor(118),G0tensor(119),G0tensor(120))
  call Hotf_4pt_reduction_last(G1tensor(38),RedSet_4(129),mass4set(:,2),  & 
G0tensor(121),G0tensor(122),G0tensor(123),G0tensor(124),G0tensor(125))
  call Hotf_4pt_reduction_last(G1tensor(9),RedSet_4(143),mass4set(:,2),  & 
G0tensor(126),G0tensor(127),G0tensor(128),G0tensor(129),G0tensor(130))
  call Hotf_4pt_reduction_last(G1tensor(18),RedSet_4(132),mass4set(:,2),  & 
G0tensor(131),G0tensor(132),G0tensor(133),G0tensor(134),G0tensor(135))
  call Hotf_4pt_reduction_last(G1tensor(28),RedSet_4(83),mass4set(:,7),  & 
G0tensor(136),G0tensor(137),G0tensor(138),G0tensor(139),G0tensor(140))
  call Hotf_4pt_reduction_last(G1tensor(182),RedSet_4(137),mass4set(:,4),  & 
G0tensor(141),G0tensor(142),G0tensor(143),G0tensor(144),G0tensor(145))
  call Hotf_4pt_reduction_last(G1tensor(137),RedSet_4(97),mass4set(:,7),  & 
G0tensor(146),G0tensor(147),G0tensor(148),G0tensor(149),G0tensor(150))
  call Hotf_4pt_reduction_last(G1tensor(64),RedSet_4(140),mass4set(:,4),  & 
G0tensor(151),G0tensor(152),G0tensor(153),G0tensor(154),G0tensor(155))
  call Hotf_4pt_reduction_last(G1tensor(59),RedSet_4(87),mass4set(:,1),  & 
G0tensor(156),G0tensor(157),G0tensor(158),G0tensor(159),G0tensor(160))
  call Hotf_4pt_reduction_last(G1tensor(165),RedSet_4(144),mass4set(:,1),  & 
G0tensor(161),G0tensor(162),G0tensor(163),G0tensor(164),G0tensor(165))
  call Hotf_4pt_reduction_last(G1tensor(93),RedSet_4(94),mass4set(:,1),  & 
G0tensor(166),G0tensor(167),G0tensor(168),G0tensor(169),G0tensor(170))
  call Hotf_4pt_reduction_last(G1tensor(82),RedSet_4(147),mass4set(:,1),  & 
G0tensor(171),G0tensor(172),G0tensor(173),G0tensor(174),G0tensor(175))
  call Hotf_4pt_reduction_last(G1tensor(7),RedSet_4(154),mass4set(:,6),  & 
G0tensor(176),G0tensor(177),G0tensor(178),G0tensor(179),G0tensor(180))
  call Hotf_4pt_reduction_last(G1tensor(62),RedSet_4(85),mass4set(:,6),  & 
G0tensor(181),G0tensor(182),G0tensor(183),G0tensor(184),G0tensor(185))
  call Hotf_4pt_reduction_last(G1tensor(233),RedSet_4(150),mass4set(:,8),  & 
G0tensor(186),G0tensor(187),G0tensor(188),G0tensor(189),G0tensor(190))
  call Hotf_4pt_reduction_last(G1tensor(155),RedSet_4(89),mass4set(:,1),  & 
G0tensor(191),G0tensor(192),G0tensor(193),G0tensor(194),G0tensor(195))
  call Hotf_4pt_reduction_last(G1tensor(32),RedSet_4(155),mass4set(:,6),  & 
G0tensor(196),G0tensor(197),G0tensor(198),G0tensor(199),G0tensor(200))
  call Hotf_4pt_reduction_last(G1tensor(98),RedSet_4(91),mass4set(:,7),  & 
G0tensor(201),G0tensor(202),G0tensor(203),G0tensor(204),G0tensor(205))
  call Hotf_4pt_reduction_last(G1tensor(104),RedSet_4(92),mass4set(:,6),  & 
G0tensor(206),G0tensor(207),G0tensor(208),G0tensor(209),G0tensor(210))
  call Hotf_4pt_reduction_last(G1tensor(113),RedSet_4(138),mass4set(:,8),  & 
G0tensor(211),G0tensor(212),G0tensor(213),G0tensor(214),G0tensor(215))
  call Hotf_4pt_reduction_last(G1tensor(118),RedSet_4(96),mass4set(:,1),  & 
G0tensor(216),G0tensor(217),G0tensor(218),G0tensor(219),G0tensor(220))
  call Hotf_4pt_reduction_last(G1tensor(136),RedSet_4(145),mass4set(:,6),  & 
G0tensor(221),G0tensor(222),G0tensor(223),G0tensor(224),G0tensor(225))
  call Hotf_4pt_reduction_last(G1tensor(146),RedSet_4(99),mass4set(:,6),  & 
G0tensor(226),G0tensor(227),G0tensor(228),G0tensor(229),G0tensor(230))
  call Hotf_4pt_reduction_last(G1tensor(154),RedSet_4(141),mass4set(:,6),  & 
G0tensor(231),G0tensor(232),G0tensor(233),G0tensor(234),G0tensor(235))
  call Hotf_4pt_reduction_last(G1tensor(152),RedSet_4(100),mass4set(:,7),  & 
G0tensor(236),G0tensor(237),G0tensor(238),G0tensor(239),G0tensor(240))
  call Hotf_4pt_reduction_last(G1tensor(158),RedSet_4(101),mass4set(:,6),  & 
G0tensor(241),G0tensor(242),G0tensor(243),G0tensor(244),G0tensor(245))
  call Hotf_4pt_reduction_last(G1tensor(239),RedSet_4(151),mass4set(:,8),  & 
G0tensor(246),G0tensor(247),G0tensor(248),G0tensor(249),G0tensor(250))
  call Hotf_4pt_reduction_last(G1tensor(194),RedSet_4(102),mass4set(:,1),  & 
G0tensor(251),G0tensor(252),G0tensor(253),G0tensor(254),G0tensor(255))
  call Hotf_4pt_reduction_last(G1tensor(201),RedSet_4(103),mass4set(:,1),  & 
G0tensor(256),G0tensor(257),G0tensor(258),G0tensor(259),G0tensor(260))
  call Hotf_4pt_reduction_last(G1tensor(219),RedSet_4(134),mass4set(:,8),  & 
G0tensor(261),G0tensor(262),G0tensor(263),G0tensor(264),G0tensor(265))
  call Hotf_4pt_reduction_last(G1tensor(237),RedSet_4(105),mass4set(:,1),  & 
G0tensor(266),G0tensor(267),G0tensor(268),G0tensor(269),G0tensor(270))
  call Hotf_4pt_reduction_last(G1tensor(256),RedSet_4(106),mass4set(:,1),  & 
G0tensor(271),G0tensor(272),G0tensor(273),G0tensor(274),G0tensor(275))
  call Hotf_4pt_reduction_last(G1tensor(63),RedSet_4(2),mass4set(:,7),  & 
G0tensor(276),G0tensor(277),G0tensor(278),G0tensor(279),G0tensor(280))
  call Hotf_4pt_reduction_last(G1tensor(268),RedSet_4(3),mass4set(:,7),  & 
G0tensor(281),G0tensor(282),G0tensor(283),G0tensor(284),G0tensor(285))
  call Hotf_4pt_reduction_last(G1tensor(54),RedSet_4(4),mass4set(:,7),  & 
G0tensor(286),G0tensor(287),G0tensor(288),G0tensor(289),G0tensor(290))
  call Hotf_4pt_reduction_last(G1tensor(273),RedSet_4(6),mass4set(:,2),  & 
G0tensor(291),G0tensor(292),G0tensor(293),G0tensor(294),G0tensor(295))
  call Hotf_4pt_reduction_last(G1tensor(278),RedSet_4(7),mass4set(:,2),  & 
G0tensor(296),G0tensor(297),G0tensor(298),G0tensor(299),G0tensor(300))
  call Hotf_4pt_reduction_last(G1tensor(283),RedSet_4(10),mass4set(:,6),  & 
G0tensor(301),G0tensor(302),G0tensor(303),G0tensor(304),G0tensor(305))
  call Hotf_4pt_reduction_last(G1tensor(66),RedSet_4(11),mass4set(:,6),  & 
G0tensor(306),G0tensor(307),G0tensor(308),G0tensor(309),G0tensor(310))
  call Hotf_4pt_reduction_last(G1tensor(288),RedSet_4(16),mass4set(:,6),  & 
G0tensor(311),G0tensor(312),G0tensor(313),G0tensor(314),G0tensor(315))
  call Hotf_4pt_reduction_last(G1tensor(87),RedSet_4(17),mass4set(:,6),  & 
G0tensor(316),G0tensor(317),G0tensor(318),G0tensor(319),G0tensor(320))
  call Hotf_4pt_reduction_last(G1tensor(293),RedSet_4(18),mass4set(:,2),  & 
G0tensor(321),G0tensor(322),G0tensor(323),G0tensor(324),G0tensor(325))
  call Hotf_4pt_reduction_last(G1tensor(78),RedSet_4(19),mass4set(:,1),  & 
G0tensor(326),G0tensor(327),G0tensor(328),G0tensor(329),G0tensor(330))
  call Hotf_4pt_reduction_last(G1tensor(298),RedSet_4(21),mass4set(:,6),  & 
G0tensor(331),G0tensor(332),G0tensor(333),G0tensor(334),G0tensor(335))
  call Hotf_4pt_reduction_last(G1tensor(303),RedSet_4(22),mass4set(:,2),  & 
G0tensor(336),G0tensor(337),G0tensor(338),G0tensor(339),G0tensor(340))
  call Hotf_4pt_reduction_last(G1tensor(308),RedSet_4(25),mass4set(:,2),  & 
G0tensor(341),G0tensor(342),G0tensor(343),G0tensor(344),G0tensor(345))
  call Hotf_4pt_reduction_last(G1tensor(90),RedSet_4(26),mass4set(:,1),  & 
G0tensor(346),G0tensor(347),G0tensor(348),G0tensor(349),G0tensor(350))
  call Hotf_4pt_reduction_last(G1tensor(105),RedSet_4(31),mass4set(:,7),  & 
G0tensor(351),G0tensor(352),G0tensor(353),G0tensor(354),G0tensor(355))
  call Hotf_4pt_reduction_last(G1tensor(313),RedSet_4(32),mass4set(:,7),  & 
G0tensor(356),G0tensor(357),G0tensor(358),G0tensor(359),G0tensor(360))
  call Hotf_4pt_reduction_last(G1tensor(102),RedSet_4(33),mass4set(:,7),  & 
G0tensor(361),G0tensor(362),G0tensor(363),G0tensor(364),G0tensor(365))
  call Hotf_4pt_reduction_last(G1tensor(318),RedSet_4(35),mass4set(:,6),  & 
G0tensor(366),G0tensor(367),G0tensor(368),G0tensor(369),G0tensor(370))
  call Hotf_4pt_reduction_last(G1tensor(108),RedSet_4(36),mass4set(:,6),  & 
G0tensor(371),G0tensor(372),G0tensor(373),G0tensor(374),G0tensor(375))
  call Hotf_4pt_reduction_last(G1tensor(323),RedSet_4(41),mass4set(:,6),  & 
G0tensor(376),G0tensor(377),G0tensor(378),G0tensor(379),G0tensor(380))
  call Hotf_4pt_reduction_last(G1tensor(129),RedSet_4(42),mass4set(:,6),  & 
G0tensor(381),G0tensor(382),G0tensor(383),G0tensor(384),G0tensor(385))
  call Hotf_4pt_reduction_last(G1tensor(120),RedSet_4(43),mass4set(:,1),  & 
G0tensor(386),G0tensor(387),G0tensor(388),G0tensor(389),G0tensor(390))
  call Hotf_4pt_reduction_last(G1tensor(328),RedSet_4(45),mass4set(:,6),  & 
G0tensor(391),G0tensor(392),G0tensor(393),G0tensor(394),G0tensor(395))
  call Hotf_4pt_reduction_last(G1tensor(132),RedSet_4(48),mass4set(:,1),  & 
G0tensor(396),G0tensor(397),G0tensor(398),G0tensor(399),G0tensor(400))
  call Hotf_4pt_reduction_last(G1tensor(147),RedSet_4(52),mass4set(:,7),  & 
G0tensor(401),G0tensor(402),G0tensor(403),G0tensor(404),G0tensor(405))
  call Hotf_4pt_reduction_last(G1tensor(138),RedSet_4(53),mass4set(:,7),  & 
G0tensor(406),G0tensor(407),G0tensor(408),G0tensor(409),G0tensor(410))
  call Hotf_4pt_reduction_last(G1tensor(333),RedSet_4(55),mass4set(:,2),  & 
G0tensor(411),G0tensor(412),G0tensor(413),G0tensor(414),G0tensor(415))
  call Hotf_4pt_reduction_last(G1tensor(150),RedSet_4(58),mass4set(:,6),  & 
G0tensor(416),G0tensor(417),G0tensor(418),G0tensor(419),G0tensor(420))
  call Hotf_4pt_reduction_last(G1tensor(159),RedSet_4(61),mass4set(:,7),  & 
G0tensor(421),G0tensor(422),G0tensor(423),G0tensor(424),G0tensor(425))
  call Hotf_4pt_reduction_last(G1tensor(156),RedSet_4(62),mass4set(:,7),  & 
G0tensor(426),G0tensor(427),G0tensor(428),G0tensor(429),G0tensor(430))
  call Hotf_4pt_reduction_last(G1tensor(162),RedSet_4(64),mass4set(:,6),  & 
G0tensor(431),G0tensor(432),G0tensor(433),G0tensor(434),G0tensor(435))
  call Hotf_4pt_reduction_last(G1tensor(171),RedSet_4(67),mass4set(:,6),  & 
G0tensor(436),G0tensor(437),G0tensor(438),G0tensor(439),G0tensor(440))
  call Hotf_4pt_reduction_last(G1tensor(338),RedSet_4(68),mass4set(:,2),  & 
G0tensor(441),G0tensor(442),G0tensor(443),G0tensor(444),G0tensor(445))
  call Hotf_4pt_reduction_last(G1tensor(168),RedSet_4(69),mass4set(:,1),  & 
G0tensor(446),G0tensor(447),G0tensor(448),G0tensor(449),G0tensor(450))
  call Hotf_4pt_reduction_last(G1tensor(343),RedSet_4(71),mass4set(:,2),  & 
G0tensor(451),G0tensor(452),G0tensor(453),G0tensor(454),G0tensor(455))
  call Hotf_4pt_reduction_last(G1tensor(174),RedSet_4(72),mass4set(:,1),  & 
G0tensor(456),G0tensor(457),G0tensor(458),G0tensor(459),G0tensor(460))
  call Hotf_4pt_reduction_last(G1tensor(189),RedSet_4(77),mass4set(:,6),  & 
G0tensor(461),G0tensor(462),G0tensor(463),G0tensor(464),G0tensor(465))
  call Hotf_4pt_reduction_last(G1tensor(186),RedSet_4(78),mass4set(:,1),  & 
G0tensor(466),G0tensor(467),G0tensor(468),G0tensor(469),G0tensor(470))
  call Hotf_4pt_reduction_last(G1tensor(192),RedSet_4(80),mass4set(:,1),  & 
G0tensor(471),G0tensor(472),G0tensor(473),G0tensor(474),G0tensor(475))
  call Hotf_4pt_reduction_last(G1tensor(348),RedSet_4(152),mass4set(:,8),  & 
G0tensor(476),G0tensor(477),G0tensor(478),G0tensor(479),G0tensor(480))
  call Hotf_4pt_reduction_last(G1tensor(353),RedSet_4(107),mass4set(:,1),  & 
G0tensor(481),G0tensor(482),G0tensor(483),G0tensor(484),G0tensor(485))
  call Hotf_4pt_reduction_last(G1tensor(358),RedSet_4(108),mass4set(:,1),  & 
G0tensor(486),G0tensor(487),G0tensor(488),G0tensor(489),G0tensor(490))
  call Hotf_4pt_reduction_last(G1tensor(363),RedSet_4(109),mass4set(:,1),  & 
G0tensor(491),G0tensor(492),G0tensor(493),G0tensor(494),G0tensor(495))
  call Hotf_4pt_reduction_last(G1tensor(368),RedSet_4(153),mass4set(:,8),  & 
G0tensor(496),G0tensor(497),G0tensor(498),G0tensor(499),G0tensor(500))
  call Hotf_4pt_reduction_last(G1tensor(373),RedSet_4(112),mass4set(:,1),  & 
G0tensor(501),G0tensor(502),G0tensor(503),G0tensor(504),G0tensor(505))
  call Hotf_4pt_reduction_last(G1tensor(378),RedSet_4(113),mass4set(:,1),  & 
G0tensor(506),G0tensor(507),G0tensor(508),G0tensor(509),G0tensor(510))
  call Hotf_4pt_reduction_last(G1tensor(383),RedSet_4(114),mass4set(:,1),  & 
G0tensor(511),G0tensor(512),G0tensor(513),G0tensor(514),G0tensor(515))
  call Hotf_4pt_reduction_last(G1tensor(388),RedSet_4(116),mass4set(:,9),  & 
G0tensor(516),G0tensor(517),G0tensor(518),G0tensor(519),G0tensor(520))
  call Hotf_4pt_reduction_last(G1tensor(393),RedSet_4(119),mass4set(:,9),  & 
G0tensor(521),G0tensor(522),G0tensor(523),G0tensor(524),G0tensor(525))
  call Hotf_4pt_reduction_last(G1tensor(398),RedSet_4(122),mass4set(:,2),  & 
G0tensor(526),G0tensor(527),G0tensor(528),G0tensor(529),G0tensor(530))
  call Hotf_4pt_reduction_last(G1tensor(403),RedSet_4(123),mass4set(:,2),  & 
G0tensor(531),G0tensor(532),G0tensor(533),G0tensor(534),G0tensor(535))
  call Hotf_4pt_reduction_last(G1tensor(408),RedSet_4(125),mass4set(:,2),  & 
G0tensor(536),G0tensor(537),G0tensor(538),G0tensor(539),G0tensor(540))
  call Hotf_4pt_reduction_last(G1tensor(413),RedSet_4(126),mass4set(:,2),  & 
G0tensor(541),G0tensor(542),G0tensor(543),G0tensor(544),G0tensor(545))
  call Hotf_4pt_reduction_last(G1tensor(418),RedSet_4(128),mass4set(:,2),  & 
G0tensor(546),G0tensor(547),G0tensor(548),G0tensor(549),G0tensor(550))
  call Hotf_4pt_reduction_last(G1tensor(423),RedSet_4(131),mass4set(:,2),  & 
G0tensor(551),G0tensor(552),G0tensor(553),G0tensor(554),G0tensor(555))
  call Hotf_4pt_reduction_last(G1tensor(428),RedSet_4(135),mass4set(:,4),  & 
G0tensor(556),G0tensor(557),G0tensor(558),G0tensor(559),G0tensor(560))
  call Hotf_4pt_reduction_last(G1tensor(433),RedSet_4(136),mass4set(:,4),  & 
G0tensor(561),G0tensor(562),G0tensor(563),G0tensor(564),G0tensor(565))
  call Hotf_4pt_reduction_last(G1tensor(438),RedSet_4(139),mass4set(:,4),  & 
G0tensor(566),G0tensor(567),G0tensor(568),G0tensor(569),G0tensor(570))
  call Hotf_4pt_reduction_last(G1tensor(443),RedSet_4(142),mass4set(:,6),  & 
G0tensor(571),G0tensor(572),G0tensor(573),G0tensor(574),G0tensor(575))
  call Hotf_4pt_reduction_last(G1tensor(448),RedSet_4(146),mass4set(:,6),  & 
G0tensor(576),G0tensor(577),G0tensor(578),G0tensor(579),G0tensor(580))
  call Hotf_4pt_reduction_last(G1tensor(453),RedSet_4(88),mass4set(:,5),  & 
G0tensor(581),G0tensor(582),G0tensor(583),G0tensor(584),G0tensor(585))
  call Hotf_4pt_reduction_last(G1tensor(458),RedSet_4(95),mass4set(:,5),  & 
G0tensor(586),G0tensor(587),G0tensor(588),G0tensor(589),G0tensor(590))
  call ol_merge_tensors(T0sum(1),[G0tensor(1)])
  call ol_merge_tensors(T0sum(2),[G0tensor(6)])
  call ol_merge_tensors(T0sum(3),[G0tensor(11)])
  call ol_merge_tensors(T0sum(4),[G0tensor(16)])
  call ol_merge_tensors(T0sum(5),[G0tensor(21)])
  call ol_merge_tensors(T0sum(6),[G0tensor(26)])
  call ol_merge_tensors(T0sum(7),[G0tensor(31)])
  call ol_merge_tensors(T0sum(8),[G0tensor(36)])
  call ol_merge_tensors(T0sum(9),[G0tensor(41)])
  call ol_merge_tensors(T0sum(10),[G0tensor(46)])
  call ol_merge_tensors(T0sum(11),[G0tensor(51)])
  call ol_merge_tensors(T0sum(12),[G0tensor(56)])
  call ol_merge_tensors(T0sum(13),[G0tensor(61)])
  call ol_merge_tensors(T0sum(14),[G0tensor(66)])
  call ol_merge_tensors(T0sum(15),[G0tensor(71)])
  call ol_merge_tensors(T0sum(16),[G0tensor(76)])
  call ol_merge_tensors(T0sum(17),[G0tensor(81)])
  call ol_merge_tensors(T0sum(18),[G0tensor(86)])
  call ol_merge_tensors(T0sum(19),[G0tensor(91)])
  call ol_merge_tensors(T0sum(20),[G0tensor(96)])
  call ol_merge_tensors(T0sum(21),[G0tensor(101)])
  call ol_merge_tensors(T0sum(22),[G0tensor(106)])
  call ol_merge_tensors(T0sum(23),[G0tensor(111)])
  call ol_merge_tensors(T0sum(24),[G0tensor(116)])
  call ol_merge_tensors(T0sum(25),[G0tensor(121)])
  call ol_merge_tensors(T0sum(26),[G0tensor(126)])
  call ol_merge_tensors(T0sum(27),[G0tensor(131)])
  call ol_merge_tensors(T0sum(28),[G0tensor(136)])
  call ol_merge_tensors(T0sum(29),[G0tensor(141)])
  call ol_merge_tensors(T0sum(30),[G0tensor(146)])
  call ol_merge_tensors(T0sum(31),[G0tensor(151)])
  call ol_merge_tensors(T0sum(32),[G0tensor(156)])
  call ol_merge_tensors(T0sum(33),[G0tensor(161)])
  call ol_merge_tensors(T0sum(34),[G0tensor(166)])
  call ol_merge_tensors(T0sum(35),[G0tensor(171)])
  call ol_merge_tensors(T0sum(36),[G0tensor(176)])
  call ol_merge_tensors(T0sum(37),[G0tensor(181)])
  call ol_merge_tensors(T0sum(38),[G0tensor(186)])
  call ol_merge_tensors(T0sum(39),[G0tensor(191)])
  call ol_merge_tensors(T0sum(40),[G0tensor(196)])
  call ol_merge_tensors(T0sum(41),[G0tensor(201)])
  call ol_merge_tensors(T0sum(42),[G0tensor(206)])
  call ol_merge_tensors(T0sum(43),[G0tensor(211)])
  call ol_merge_tensors(T0sum(44),[G0tensor(216)])
  call ol_merge_tensors(T0sum(45),[G0tensor(221)])
  call ol_merge_tensors(T0sum(46),[G0tensor(226)])
  call ol_merge_tensors(T0sum(47),[G0tensor(231)])
  call ol_merge_tensors(T0sum(48),[G0tensor(236)])
  call ol_merge_tensors(T0sum(49),[G0tensor(241)])
  call ol_merge_tensors(T0sum(50),[G0tensor(246)])
  call ol_merge_tensors(T0sum(51),[G0tensor(251)])
  call ol_merge_tensors(T0sum(52),[G0tensor(256)])
  call ol_merge_tensors(T0sum(53),[G0tensor(261)])
  call ol_merge_tensors(T0sum(54),[G0tensor(266)])
  call ol_merge_tensors(T0sum(55),[G0tensor(271)])
  call ol_merge_tensors(T0sum(56),[G0tensor(276)])
  call ol_merge_tensors(T0sum(57),[G0tensor(281)])
  call ol_merge_tensors(T0sum(58),[G0tensor(286)])
  call ol_merge_tensors(T0sum(59),[G0tensor(291)])
  call ol_merge_tensors(T0sum(60),[G0tensor(296)])
  call ol_merge_tensors(T0sum(61),[G0tensor(301)])
  call ol_merge_tensors(T0sum(62),[G0tensor(306)])
  call ol_merge_tensors(T0sum(63),[G0tensor(311)])
  call ol_merge_tensors(T0sum(64),[G0tensor(316)])
  call ol_merge_tensors(T0sum(65),[G0tensor(321)])
  call ol_merge_tensors(T0sum(66),[G0tensor(326)])
  call ol_merge_tensors(T0sum(67),[G0tensor(331)])
  call ol_merge_tensors(T0sum(68),[G0tensor(336)])
  call ol_merge_tensors(T0sum(69),[G0tensor(341)])
  call ol_merge_tensors(T0sum(70),[G0tensor(346)])
  call ol_merge_tensors(T0sum(71),[G0tensor(351)])
  call ol_merge_tensors(T0sum(72),[G0tensor(356)])
  call ol_merge_tensors(T0sum(73),[G0tensor(361)])
  call ol_merge_tensors(T0sum(74),[G0tensor(366)])
  call ol_merge_tensors(T0sum(75),[G0tensor(371)])
  call ol_merge_tensors(T0sum(76),[G0tensor(376)])
  call ol_merge_tensors(T0sum(77),[G0tensor(381)])
  call ol_merge_tensors(T0sum(78),[G0tensor(386)])
  call ol_merge_tensors(T0sum(79),[G0tensor(391)])
  call ol_merge_tensors(T0sum(80),[G0tensor(396)])
  call ol_merge_tensors(T0sum(81),[G0tensor(401)])
  call ol_merge_tensors(T0sum(82),[G0tensor(406)])
  call ol_merge_tensors(T0sum(83),[G0tensor(411)])
  call ol_merge_tensors(T0sum(84),[G0tensor(416)])
  call ol_merge_tensors(T0sum(85),[G0tensor(421)])
  call ol_merge_tensors(T0sum(86),[G0tensor(426)])
  call ol_merge_tensors(T0sum(87),[G0tensor(431)])
  call ol_merge_tensors(T0sum(88),[G0tensor(436)])
  call ol_merge_tensors(T0sum(89),[G0tensor(441)])
  call ol_merge_tensors(T0sum(90),[G0tensor(446)])
  call ol_merge_tensors(T0sum(91),[G0tensor(451)])
  call ol_merge_tensors(T0sum(92),[G0tensor(456)])
  call ol_merge_tensors(T0sum(93),[G0tensor(461)])
  call ol_merge_tensors(T0sum(94),[G0tensor(466)])
  call ol_merge_tensors(T0sum(95),[G0tensor(471)])
  call ol_merge_tensors(T0sum(96),[G0tensor(476)])
  call ol_merge_tensors(T0sum(97),[G0tensor(481)])
  call ol_merge_tensors(T0sum(98),[G0tensor(486)])
  call ol_merge_tensors(T0sum(99),[G0tensor(491)])
  call ol_merge_tensors(T0sum(100),[G0tensor(496)])
  call ol_merge_tensors(T0sum(101),[G0tensor(501)])
  call ol_merge_tensors(T0sum(102),[G0tensor(506)])
  call ol_merge_tensors(T0sum(103),[G0tensor(511)])
  call ol_merge_tensors(T0sum(104),[G0tensor(516)])
  call ol_merge_tensors(T0sum(105),[G0tensor(521)])
  call ol_merge_tensors(T0sum(106),[G0tensor(526)])
  call ol_merge_tensors(T0sum(107),[G0tensor(531)])
  call ol_merge_tensors(T0sum(108),[G0tensor(536)])
  call ol_merge_tensors(T0sum(109),[G0tensor(541)])
  call ol_merge_tensors(T0sum(110),[G0tensor(546)])
  call ol_merge_tensors(T0sum(111),[G0tensor(551)])
  call ol_merge_tensors(T0sum(112),[G0tensor(556)])
  call ol_merge_tensors(T0sum(113),[G0tensor(561)])
  call ol_merge_tensors(T0sum(114),[G0tensor(566)])
  call ol_merge_tensors(T0sum(115),[G0tensor(571)])
  call ol_merge_tensors(T0sum(116),[G0tensor(576)])
  call ol_merge_tensors(T0sum(117),[G0tensor(581)])
  call ol_merge_tensors(T0sum(118),[G0tensor(586)])
  Gcoeff(:)%j = (c(25)*M(2,:)%j+c(20)*(-M(1,:)%j-M(4,:)%j+M(5,:)%j)) * den(4)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(75),h0tab(:,75),[32,15,16],[0,0,0],4,2,wf4(:,1),wf4(:,2))
  call Hloop_QA_V(ntryL,G0H64(1),ex6(:),G0H32(4),m3h2x32(:,43),heltab2x64(:,:,75))
  Gcoeff(:)%j = (c(25)*M(3,:)%j+c(20)*(-M(1,:)%j-M(4,:)%j+M(5,:)%j)) * den(4)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(76),h0tab(:,76),[32,15,16],[0,0,0],4,2,wf4(:,2),wf4(:,1))
  call Hloop_QA_V(ntryL,G0H64(1),ex6(:),G0H32(6),m3h2x32(:,44),heltab2x64(:,:,76))
  Gcoeff(:)%j = (c(25)*(-M(2,:)%j+M(3,:)%j)) * den(4)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(77),h0tab(:,77),[32,15,16],[0,0,0],4,2,wf4(:,1),wf4(:,2))
  call Hloop_QA_V(ntryL,G0H64(1),ex6(:),G0H32(8),m3h2x32(:,45),heltab2x64(:,:,77))
  Gcoeff(:)%j = (c(25)*M(3,:)%j+c(20)*(M(1,:)%j-M(4,:)%j-M(5,:)%j)) * den(46)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(78),h0tab(:,78),[51,4,8],[0,nMT,0],4,2,wf4(:,1),wf4(:,3))
  call Hloop_GGG_G_12(ntryL,G0H64(1),wf4(:,1),wf4(:,3),G0H4(1),m4h4x4x4(:,1),heltab3x64(:,:,1))
  Gcoeff(:)%j = (c(25)*M(2,:)%j+c(20)*(M(1,:)%j-M(4,:)%j-M(5,:)%j)) * den(46)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(79),h0tab(:,79),[51,4,8],[0,nMT,0],4,2,wf4(:,3),wf4(:,1))
  call Hloop_GGG_G_12(ntryL,G0H64(1),wf4(:,3),wf4(:,1),G0H4(2),m4h4x4x4(:,2),heltab3x64(:,:,2))
  Gcoeff(:)%j = (c(25)*(M(2,:)%j-M(3,:)%j)) * den(46)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(80),h0tab(:,80),[51,4,8],[0,nMT,0],4,2,wf4(:,1),wf4(:,3))
  call Hloop_GGG_G_23(ntryL,G0H64(1),wf4(:,1),wf4(:,3),G0H4(3),m4h4x4x4(:,3),heltab3x64(:,:,3))
  Gcoeff(:)%j = (c(25)*M(2,:)%j+c(20)*(-M(1,:)%j+M(4,:)%j-M(5,:)%j)) * den(42)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(81),h0tab(:,81),[60,1,2],[0,0,0],4,2,wf4(:,2),wf4(:,3))
  call Hloop_GGG_G_12(ntryL,G0H64(1),wf4(:,2),wf4(:,3),G0H4(4),m4h4x4x4(:,4),heltab3x64(:,:,4))
  Gcoeff(:)%j = (c(25)*M(3,:)%j+c(20)*(-M(1,:)%j+M(4,:)%j-M(5,:)%j)) * den(42)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(82),h0tab(:,82),[60,1,2],[0,0,0],4,2,wf4(:,3),wf4(:,2))
  call Hloop_GGG_G_12(ntryL,G0H64(1),wf4(:,3),wf4(:,2),G0H4(5),m4h4x4x4(:,5),heltab3x64(:,:,5))
  Gcoeff(:)%j = (c(25)*(-M(2,:)%j+M(3,:)%j)) * den(42)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(83),h0tab(:,83),[60,1,2],[0,0,0],4,2,wf4(:,2),wf4(:,3))
  call Hloop_GGG_G_23(ntryL,G0H64(1),wf4(:,2),wf4(:,3),G0H4(6),m4h4x4x4(:,6),heltab3x64(:,:,6))
  Gcoeff(:)%j = (-(c(36)*M(2,:)%j)+c(35)*(M(1,:)%j+M(4,:)%j+M(5,:)%j)-c(34)*M(6,:)%j) * den(86)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(84),h0tab(:,84),[48,3,12],[0,0,0],3,3,wf4(:,3),wf4(:,1),wf4(:,2))
  call Hloop_AV_Q(ntryL,G0H64(1),wf4(:,3),G0H16(1),m3h4x16(:,21),heltab2x64(:,:,78))
  call Hloop_A_Q(ntryL,G0H16(1),48,0,G1H16(3),n2h16(37))
  Gcoeff(:)%j = (-(c(32)*M(2,:)%j)+c(31)*(M(1,:)%j+M(4,:)%j+M(5,:)%j)-c(30)*M(6,:)%j) * den(86)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(85),h0tab(:,85),[48,3,12],[nMT,nMT,nMT],3,3,wf4(:,3),wf4(:,1),wf4(:,2))
  call Hloop_AV_Q(ntryL,G0H64(1),wf4(:,3),G0H16(1),m3h4x16(:,22),heltab2x64(:,:,79))
  call Hloop_A_Q(ntryL,G0H16(1),48,nMT,G1H16(4),n2h16(38))
  Gcoeff(:)%j = (-(c(36)*M(3,:)%j)+c(35)*(M(1,:)%j+M(4,:)%j+M(5,:)%j)-c(34)*M(6,:)%j) * den(86)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(86),h0tab(:,86),[48,3,12],[0,0,0],3,3,wf4(:,3),wf4(:,1),wf4(:,2))
  call Hloop_QV_A(ntryL,G0H64(1),wf4(:,3),G0H16(1),m3h4x16(:,23),heltab2x64(:,:,80))
  call Hloop_Q_A(ntryL,G0H16(1),48,0,G1H16(5),n2h16(39))
  Gcoeff(:)%j = (-(c(32)*M(3,:)%j)+c(31)*(M(1,:)%j+M(4,:)%j+M(5,:)%j)-c(30)*M(6,:)%j) * den(86)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(87),h0tab(:,87),[48,3,12],[nMT,nMT,nMT],3,3,wf4(:,3),wf4(:,1),wf4(:,2))
  call Hloop_QV_A(ntryL,G0H64(1),wf4(:,3),G0H16(1),m3h4x16(:,24),heltab2x64(:,:,81))
  call Hloop_Q_A(ntryL,G0H16(1),48,nMT,G1H16(6),n2h16(40))
  Gcoeff(:)%j = (-(c(36)*M(2,:)%j)+c(35)*(M(1,:)%j+M(4,:)%j+M(5,:)%j)-c(34)*M(6,:)%j) * den(86)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(88),h0tab(:,88),[48,3,12],[0,0,0],3,3,wf4(:,3),wf4(:,1),wf4(:,2))
  call Hloop_AV_Q(ntryL,G0H64(1),wf4(:,3),G0H16(1),m3h4x16(:,25),heltab2x64(:,:,82))
  call Hloop_A_Q(ntryL,G0H16(1),48,0,G1H16(7),n2h16(41))
  Gcoeff(:)%j = (-(c(32)*M(2,:)%j)+c(31)*(M(1,:)%j+M(4,:)%j+M(5,:)%j)-c(30)*M(6,:)%j) * den(86)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(89),h0tab(:,89),[48,3,12],[nMB,nMB,nMB],3,3,wf4(:,3),wf4(:,1),wf4(:,2))
  call Hloop_AV_Q(ntryL,G0H64(1),wf4(:,3),G0H16(1),m3h4x16(:,26),heltab2x64(:,:,83))
  call Hloop_A_Q(ntryL,G0H16(1),48,nMB,G1H16(8),n2h16(42))
  Gcoeff(:)%j = (-(c(36)*M(3,:)%j)+c(35)*(M(1,:)%j+M(4,:)%j+M(5,:)%j)-c(34)*M(6,:)%j) * den(86)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(90),h0tab(:,90),[48,3,12],[0,0,0],3,3,wf4(:,3),wf4(:,1),wf4(:,2))
  call Hloop_QV_A(ntryL,G0H64(1),wf4(:,3),G0H16(1),m3h4x16(:,27),heltab2x64(:,:,84))
  call Hloop_Q_A(ntryL,G0H16(1),48,0,G1H16(9),n2h16(43))
  Gcoeff(:)%j = (-(c(32)*M(3,:)%j)+c(31)*(M(1,:)%j+M(4,:)%j+M(5,:)%j)-c(30)*M(6,:)%j) * den(86)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(91),h0tab(:,91),[48,3,12],[nMB,nMB,nMB],3,3,wf4(:,3),wf4(:,1),wf4(:,2))
  call Hloop_QV_A(ntryL,G0H64(1),wf4(:,3),G0H16(1),m3h4x16(:,28),heltab2x64(:,:,85))
  call Hloop_Q_A(ntryL,G0H16(1),48,nMB,G1H16(10),n2h16(44))
  Gcoeff(:)%j = (c(6)*(M(2,:)%j-M(3,:)%j)) * den(86)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(92),h0tab(:,92),[48,3,12],[0,0,0],3,3,wf4(:,3),wf4(:,1),wf4(:,2))
  call Hloop_DV_C(ntryL,G0H64(1),0,wf4(:,3),G1H16(11),m3h4x16(:,29),heltab2x64(:,:,86))
  Gcoeff(:)%j = (c(6)*(-M(2,:)%j+M(3,:)%j)) * den(86)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(93),h0tab(:,93),[48,3,12],[0,0,0],3,3,wf4(:,3),wf4(:,1),wf4(:,2))
  call Hloop_CV_D(ntryL,G0H64(1),0,wf4(:,3),48,G1H16(12),m3h4x16(:,30),heltab2x64(:,:,87))
  Gcoeff(:)%j = (c(6)*(-M(2,:)%j+M(3,:)%j)) * den(86)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(94),h0tab(:,94),[48,3,12],[0,0,0],3,3,wf4(:,3),wf4(:,1),wf4(:,2))
  call Hloop_UV_W(ntryL,G0H64(1),0,wf4(:,3),48,G1H16(13),m3h4x16(:,31),heltab2x64(:,:,88))
  Gcoeff(:)%j = (-(c(15)*M(3,:)%j)+c(12)*(M(1,:)%j+M(4,:)%j)-c(11)*M(6,:)%j) * den(8)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(95),h0tab(:,95),[32,12,19],[0,0,0],3,2,wf4(:,2),wf8(:,3))
  call Hloop_VA_Q(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,46),heltab2x64(:,:,89))
  call Hloop_A_Q(ntryL,G0H32(1),32,0,G1H32(1),n2h32(6))
  Gcoeff(:)%j = (-(c(6)*M(3,:)%j)+c(4)*(M(1,:)%j+M(4,:)%j)-c(3)*M(6,:)%j) * den(8)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(96),h0tab(:,96),[32,12,19],[0,0,0],3,2,wf4(:,2),wf8(:,3))
  call Hloop_QA_V(ntryL,G0H64(1),ex6(:),G0H32(3),m3h2x32(:,47),heltab2x64(:,:,90))
  Gcoeff(:)%j = (-(c(15)*M(2,:)%j)+c(12)*(M(1,:)%j+M(4,:)%j)-c(11)*M(6,:)%j) * den(26)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(97),h0tab(:,97),[35,12,16],[0,0,0],3,2,wf8(:,22),wf4(:,2))
  call Hloop_VA_Q(ntryL,G0H64(1),wf8(:,22),G0H8(1),m3h8x8(:,13),heltab2x64(:,:,91))
  call Hloop_A_Q(ntryL,G0H8(1),35,0,G1H8(7),n2h8(22))
  Gcoeff(:)%j = (-(c(6)*M(2,:)%j)+c(4)*(M(1,:)%j+M(4,:)%j)-c(3)*M(6,:)%j) * den(26)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(98),h0tab(:,98),[35,12,16],[0,0,0],3,2,wf8(:,22),wf4(:,2))
  call Hloop_QA_V(ntryL,G0H64(1),wf8(:,22),G0H8(2),m3h8x8(:,14),heltab2x64(:,:,92))
  Gcoeff(:)%j = (-(c(15)*M(2,:)%j)+c(12)*(M(1,:)%j+M(4,:)%j)-c(11)*M(6,:)%j) * den(11)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(99),h0tab(:,99),[32,3,28],[0,0,0],3,2,wf4(:,1),wf8(:,6))
  call Hloop_VA_Q(ntryL,G0H64(1),ex6(:),G0H32(9),m3h2x32(:,48),heltab2x64(:,:,93))
  call Hloop_A_Q(ntryL,G0H32(9),32,0,G1H32(2),n2h32(7))
  Gcoeff(:)%j = (-(c(6)*M(2,:)%j)+c(4)*(M(1,:)%j+M(4,:)%j)-c(3)*M(6,:)%j) * den(11)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(100),h0tab(:,100),[32,3,28],[0,0,0],3,2,wf4(:,1),wf8(:,6))
  call Hloop_QA_V(ntryL,G0H64(1),ex6(:),G0H32(10),m3h2x32(:,49),heltab2x64(:,:,94))
  Gcoeff(:)%j = (-(c(15)*M(3,:)%j)+c(12)*(M(1,:)%j+M(4,:)%j)-c(11)*M(6,:)%j) * den(29)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(101),h0tab(:,101),[44,3,16],[0,0,0],3,2,wf8(:,24),wf4(:,1))
  call Hloop_VA_Q(ntryL,G0H64(1),wf8(:,24),G0H8(3),m3h8x8(:,15),heltab2x64(:,:,95))
  call Hloop_A_Q(ntryL,G0H8(3),44,0,G1H8(1),n2h8(23))
  Gcoeff(:)%j = (-(c(6)*M(3,:)%j)+c(4)*(M(1,:)%j+M(4,:)%j)-c(3)*M(6,:)%j) * den(29)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(102),h0tab(:,102),[44,3,16],[0,0,0],3,2,wf8(:,24),wf4(:,1))
  call Hloop_QA_V(ntryL,G0H64(1),wf8(:,24),G0H8(4),m3h8x8(:,16),heltab2x64(:,:,96))
  Gcoeff(:)%j = (c(3)*(M(2,:)%j-M(3,:)%j)) * den(51)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(103),h0tab(:,103),[32,15,16],[0,0,0],3,1,wf16(:,1))
  call Hloop_VA_Q(ntryL,G0H64(1),ex6(:),G0H32(11),m3h2x32(:,50),heltab2x64(:,:,97))
  call Hloop_A_Q(ntryL,G0H32(11),32,0,G1H32(3),n2h32(8))
  Gcoeff(:)%j = (c(25)*(M(2,:)%j-M(3,:)%j)) * den(51)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(104),h0tab(:,104),[32,15,16],[0,0,0],3,1,wf16(:,1))
  call Hloop_QA_V(ntryL,G0H64(1),ex6(:),G0H32(12),m3h2x32(:,51),heltab2x64(:,:,98))
  Gcoeff(:)%j = (-(c(15)*M(2,:)%j)+c(12)*(M(4,:)%j+M(5,:)%j)-c(11)*M(6,:)%j) * den(14)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(105),h0tab(:,105),[48,7,8],[nMT,0,nMT],3,2,wf4(:,3),wf8(:,9))
  call Hloop_AV_Q(ntryL,G0H64(1),wf4(:,3),G0H16(1),m3h4x16(:,32),heltab2x64(:,:,99))
  call Hloop_A_Q(ntryL,G0H16(1),48,nMT,G1H16(14),n2h16(45))
  Gcoeff(:)%j = (-(c(6)*M(2,:)%j)+c(4)*(M(4,:)%j+M(5,:)%j)-c(3)*M(6,:)%j) * den(14)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(106),h0tab(:,106),[48,7,8],[0,nMT,0],3,2,wf4(:,3),wf8(:,9))
  call Hloop_UV_W(ntryL,G0H64(1),0,wf4(:,3),48,G1H16(15),m3h4x16(:,33),heltab2x64(:,:,100))
  Gcoeff(:)%j = (-(c(15)*M(3,:)%j)+c(12)*(M(4,:)%j+M(5,:)%j)-c(11)*M(6,:)%j) * den(32)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(107),h0tab(:,107),[48,4,11],[nMT,0,nMT],3,2,wf4(:,3),wf8(:,31))
  call Hloop_AV_Q(ntryL,G0H64(1),wf4(:,3),G0H16(1),m3h4x16(:,34),heltab2x64(:,:,101))
  call Hloop_A_Q(ntryL,G0H16(1),48,nMT,G1H16(16),n2h16(46))
  Gcoeff(:)%j = (-(c(6)*M(3,:)%j)+c(4)*(M(4,:)%j+M(5,:)%j)-c(3)*M(6,:)%j) * den(32)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(108),h0tab(:,108),[48,4,11],[0,nMT,0],3,2,wf4(:,3),wf8(:,31))
  call Hloop_UV_W(ntryL,G0H64(1),0,wf4(:,3),48,G1H16(17),m3h4x16(:,35),heltab2x64(:,:,102))
  Gcoeff(:)%j = (-(c(15)*M(3,:)%j)+c(12)*(M(4,:)%j+M(5,:)%j)-c(11)*M(6,:)%j) * den(17)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(109),h0tab(:,109),[52,3,8],[nMT,nMT,0],3,2,wf8(:,12),wf4(:,1))
  call Hloop_VQ_A(ntryL,G0H64(1),wf8(:,12),G0H8(5),m3h8x8(:,17),heltab2x64(:,:,103))
  call Hloop_Q_A(ntryL,G0H8(5),52,nMT,G1H8(3),n2h8(24))
  Gcoeff(:)%j = (c(6)*M(3,:)%j+c(4)*(-M(4,:)%j-M(5,:)%j)+c(3)*M(6,:)%j) * den(17)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(110),h0tab(:,110),[52,3,8],[0,0,nMT],3,2,wf8(:,12),wf4(:,1))
  call Hloop_AQ_V(ntryL,G0H64(1),wf8(:,12),G0H8(6),m3h8x8(:,18),heltab2x64(:,:,104))
  Gcoeff(:)%j = (-(c(15)*M(2,:)%j)+c(12)*(M(4,:)%j+M(5,:)%j)-c(11)*M(6,:)%j) * den(35)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(111),h0tab(:,111),[56,3,4],[nMT,nMT,0],3,2,wf8(:,33),wf4(:,1))
  call Hloop_VA_Q(ntryL,G0H64(1),wf8(:,33),G0H8(7),m3h8x8(:,19),heltab2x64(:,:,105))
  call Hloop_A_Q(ntryL,G0H8(7),56,nMT,G1H8(12),n2h8(25))
  Gcoeff(:)%j = (-(c(6)*M(2,:)%j)+c(4)*(M(4,:)%j+M(5,:)%j)-c(3)*M(6,:)%j) * den(35)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(112),h0tab(:,112),[56,3,4],[0,0,nMT],3,2,wf8(:,33),wf4(:,1))
  call Hloop_QA_V(ntryL,G0H64(1),wf8(:,33),G0H8(8),m3h8x8(:,20),heltab2x64(:,:,106))
  Gcoeff(:)%j = (c(3)*(-M(2,:)%j+M(3,:)%j)) * den(48)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(113),h0tab(:,113),[51,4,8],[nMT,0,nMT],3,1,wf16(:,6))
  call Hloop_AV_Q(ntryL,G0H64(1),wf16(:,6),G0H4(7),m3h16x4(:,1),heltab2x64(:,:,107))
  call Hloop_A_Q(ntryL,G0H4(7),51,nMT,G1H4(36),n2h4(48))
  Gcoeff(:)%j = (c(25)*(-M(2,:)%j+M(3,:)%j)) * den(48)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(114),h0tab(:,114),[51,4,8],[0,nMT,0],3,1,wf16(:,6))
  call Hloop_UV_W(ntryL,G0H64(1),0,wf16(:,6),51,G1H4(3),m3h16x4(:,2),heltab2x64(:,:,108))
  Gcoeff(:)%j = (-(c(15)*M(2,:)%j)+c(12)*(M(4,:)%j+M(5,:)%j)-c(11)*M(6,:)%j) * den(74)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(115),h0tab(:,115),[32,15,16],[0,0,0],3,1,wf16(:,7))
  call Hloop_VA_Q(ntryL,G0H64(1),ex6(:),G0H32(13),m3h2x32(:,52),heltab2x64(:,:,109))
  call Hloop_A_Q(ntryL,G0H32(13),32,0,G1H32(4),n2h32(9))
  Gcoeff(:)%j = (-(c(6)*M(2,:)%j)+c(4)*(M(4,:)%j+M(5,:)%j)-c(3)*M(6,:)%j) * den(74)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(116),h0tab(:,116),[32,15,16],[0,0,0],3,1,wf16(:,7))
  call Hloop_QA_V(ntryL,G0H64(1),ex6(:),G0H32(14),m3h2x32(:,53),heltab2x64(:,:,110))
  Gcoeff(:)%j = (-(c(15)*M(3,:)%j)+c(12)*(M(4,:)%j+M(5,:)%j)-c(11)*M(6,:)%j) * den(75)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(117),h0tab(:,117),[32,15,16],[0,0,0],3,1,wf16(:,8))
  call Hloop_VA_Q(ntryL,G0H64(1),ex6(:),G0H32(2),m3h2x32(:,54),heltab2x64(:,:,111))
  call Hloop_A_Q(ntryL,G0H32(2),32,0,G1H32(5),n2h32(10))
  Gcoeff(:)%j = (-(c(6)*M(3,:)%j)+c(4)*(M(4,:)%j+M(5,:)%j)-c(3)*M(6,:)%j) * den(75)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(118),h0tab(:,118),[32,15,16],[0,0,0],3,1,wf16(:,8))
  call Hloop_QA_V(ntryL,G0H64(1),ex6(:),G0H32(5),m3h2x32(:,55),heltab2x64(:,:,112))
  Gcoeff(:)%j = (-(c(15)*M(3,:)%j)+c(12)*(M(1,:)%j+M(4,:)%j)-c(11)*M(6,:)%j) * den(76)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(119),h0tab(:,119),[51,4,8],[nMT,0,nMT],3,1,wf16(:,9))
  call Hloop_AV_Q(ntryL,G0H64(1),wf16(:,9),G0H4(7),m3h16x4(:,3),heltab2x64(:,:,113))
  call Hloop_A_Q(ntryL,G0H4(7),51,nMT,G1H4(25),n2h4(49))
  Gcoeff(:)%j = (-(c(6)*M(3,:)%j)+c(4)*(M(1,:)%j+M(4,:)%j)-c(3)*M(6,:)%j) * den(76)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(120),h0tab(:,120),[51,4,8],[0,nMT,0],3,1,wf16(:,9))
  call Hloop_UV_W(ntryL,G0H64(1),0,wf16(:,9),51,G1H4(26),m3h16x4(:,4),heltab2x64(:,:,114))
  Gcoeff(:)%j = (-(c(15)*M(2,:)%j)+c(12)*(M(1,:)%j+M(4,:)%j)-c(11)*M(6,:)%j) * den(77)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(121),h0tab(:,121),[51,4,8],[nMT,0,nMT],3,1,wf16(:,10))
  call Hloop_AV_Q(ntryL,G0H64(1),wf16(:,10),G0H4(7),m3h16x4(:,5),heltab2x64(:,:,115))
  call Hloop_A_Q(ntryL,G0H4(7),51,nMT,G1H4(4),n2h4(50))
  Gcoeff(:)%j = (-(c(6)*M(2,:)%j)+c(4)*(M(1,:)%j+M(4,:)%j)-c(3)*M(6,:)%j) * den(77)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(122),h0tab(:,122),[51,4,8],[0,nMT,0],3,1,wf16(:,10))
  call Hloop_UV_W(ntryL,G0H64(1),0,wf16(:,10),51,G1H4(30),m3h16x4(:,6),heltab2x64(:,:,116))
  Gcoeff(:)%j = (-(c(15)*M(3,:)%j)+c(12)*(M(1,:)%j+M(5,:)%j)-c(11)*M(6,:)%j) * den(20)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(123),h0tab(:,123),[48,2,13],[0,0,0],3,2,wf4(:,3),wf8(:,15))
  call Hloop_QV_A(ntryL,G0H64(1),wf4(:,3),G0H16(1),m3h4x16(:,36),heltab2x64(:,:,117))
  call Hloop_Q_A(ntryL,G0H16(1),48,0,G1H16(18),n2h16(47))
  Gcoeff(:)%j = (c(6)*M(3,:)%j+c(4)*(-M(1,:)%j-M(5,:)%j)+c(3)*M(6,:)%j) * den(20)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(124),h0tab(:,124),[48,2,13],[0,0,0],3,2,wf4(:,3),wf8(:,15))
  call Hloop_UV_W(ntryL,G0H64(1),0,wf4(:,3),48,G1H16(1),m3h4x16(:,37),heltab2x64(:,:,118))
  Gcoeff(:)%j = (-(c(15)*M(2,:)%j)+c(12)*(M(1,:)%j+M(5,:)%j)-c(11)*M(6,:)%j) * den(23)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(125),h0tab(:,125),[49,2,12],[0,0,0],3,2,wf8(:,18),wf4(:,2))
  call Hloop_AQ_V(ntryL,G0H64(1),wf8(:,18),G0H8(1),m3h8x8(:,21),heltab2x64(:,:,119))
  Gcoeff(:)%j = (-(c(6)*M(2,:)%j)+c(4)*(M(1,:)%j+M(5,:)%j)-c(3)*M(6,:)%j) * den(23)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(126),h0tab(:,126),[49,2,12],[0,0,0],3,2,wf8(:,18),wf4(:,2))
  call Hloop_VQ_A(ntryL,G0H64(1),wf8(:,18),G0H8(3),m3h8x8(:,22),heltab2x64(:,:,120))
  call Hloop_Q_A(ntryL,G0H8(3),49,0,G1H8(4),n2h8(26))
  Gcoeff(:)%j = (-(c(15)*M(2,:)%j)+c(12)*(M(1,:)%j+M(5,:)%j)-c(11)*M(6,:)%j) * den(41)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(127),h0tab(:,127),[48,1,14],[0,0,0],3,2,wf4(:,3),wf8(:,48))
  call Hloop_AV_Q(ntryL,G0H64(1),wf4(:,3),G0H16(1),m3h4x16(:,38),heltab2x64(:,:,121))
  call Hloop_A_Q(ntryL,G0H16(1),48,0,G1H16(2),n2h16(48))
  Gcoeff(:)%j = (-(c(6)*M(2,:)%j)+c(4)*(M(1,:)%j+M(5,:)%j)-c(3)*M(6,:)%j) * den(41)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(128),h0tab(:,128),[48,1,14],[0,0,0],3,2,wf4(:,3),wf8(:,48))
  call Hloop_UV_W(ntryL,G0H64(1),0,wf4(:,3),48,G1H16(19),m3h4x16(:,39),heltab2x64(:,:,122))
  Gcoeff(:)%j = (-(c(15)*M(3,:)%j)+c(12)*(M(1,:)%j+M(5,:)%j)-c(11)*M(6,:)%j) * den(38)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(129),h0tab(:,129),[50,1,12],[0,0,0],3,2,wf8(:,46),wf4(:,2))
  call Hloop_QA_V(ntryL,G0H64(1),wf8(:,46),G0H8(5),m3h8x8(:,23),heltab2x64(:,:,123))
  Gcoeff(:)%j = (c(6)*M(3,:)%j+c(4)*(-M(1,:)%j-M(5,:)%j)+c(3)*M(6,:)%j) * den(38)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(130),h0tab(:,130),[50,1,12],[0,0,0],3,2,wf8(:,46),wf4(:,2))
  call Hloop_VA_Q(ntryL,G0H64(1),wf8(:,46),G0H8(7),m3h8x8(:,24),heltab2x64(:,:,124))
  call Hloop_A_Q(ntryL,G0H8(7),50,0,G1H8(13),n2h8(27))
  Gcoeff(:)%j = (c(3)*(M(2,:)%j-M(3,:)%j)) * den(44)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(131),h0tab(:,131),[60,1,2],[0,0,0],3,1,wf16(:,5))
  call Hloop_AV_Q(ntryL,G0H64(1),wf16(:,5),G0H4(7),m3h16x4(:,7),heltab2x64(:,:,125))
  call Hloop_A_Q(ntryL,G0H4(7),60,0,G1H4(31),n2h4(51))
  Gcoeff(:)%j = (c(25)*(M(2,:)%j-M(3,:)%j)) * den(44)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(132),h0tab(:,132),[60,1,2],[0,0,0],3,1,wf16(:,5))
  call Hloop_UV_W(ntryL,G0H64(1),0,wf16(:,5),60,G1H4(32),m3h16x4(:,8),heltab2x64(:,:,126))
  Gcoeff(:)%j = (-(c(15)*M(3,:)%j)+c(12)*(M(1,:)%j+M(5,:)%j)-c(11)*M(6,:)%j) * den(78)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(133),h0tab(:,133),[32,15,16],[0,0,0],3,1,wf16(:,11))
  call Hloop_VA_Q(ntryL,G0H64(1),ex6(:),G0H32(7),m3h2x32(:,56),heltab2x64(:,:,127))



end subroutine vamp_1

end module ol_vamp_1_ppttjj_uuxttxddx_1_/**/REALKIND
