
module ol_vamp_1_ppttjj_ttxgggg_1_/**/REALKIND
contains

! **********************************************************************
subroutine vamp_1(M)
! P(0:3,nlegs) = incoming external momenta
! Uses tree structures 'wf', factors 'c', and denominators 'den' from loop_ppttjj_ttxgggg_1.
! Sets colour stripped amplitudes A from the module loop_amplitudes_ppttjj_ttxgggg_1.
! **********************************************************************
  use KIND_TYPES, only: REALKIND, QREALKIND, intkind2
  use ol_parameters_decl_/**/DREALKIND, only: l_switch
  use ol_parameters_decl_/**/QREALKIND ! masses
  use ol_vert_interface_/**/REALKIND
  use ol_prop_interface_/**/REALKIND
  use ol_last_step_/**/REALKIND
  use ol_tables_storage_ppttjj_ttxgggg_1_/**/DREALKIND
  use ol_tensor_sum_storage_ppttjj_ttxgggg_1_/**/REALKIND
  use ol_loop_handling_/**/REALKIND
  use ofred_reduction_/**/REALKIND, only: Hotf_4pt_reduction, Hotf_4pt_reduction_last
  use ofred_reduction_/**/REALKIND, only: Hotf_5pt_reduction, Hotf_5pt_reduction_last
  use ol_loop_reduction_/**/REALKIND, only: TI_bubble_red, TI_triangle_red
use ol_loop_reduction_/**/REALKIND, only: compute_scalar_box

  use ol_loop_storage_ppttjj_ttxgggg_1_/**/REALKIND
#ifndef PRECISION_dp
  use ol_loop_storage_ppttjj_ttxgggg_1_/**/DREALKIND, only: &
    & ntryL, p_switch, Hel, merge_step, merge_mism, merge_tables, merge_hels
#endif
  use hol_initialisation_/**/REALKIND, only: G0_hol_initialisation
  use ol_h_vert_interface_/**/REALKIND
  use ol_h_prop_interface_/**/REALKIND
  use ol_h_last_step_/**/REALKIND
  use ol_merging_/**/REALKIND, only: ol_merge, ol_merge_tensors, ol_merge_last

  implicit none

  type(Hpolcont) :: Gcoeff(64)
  type(Hpolcont), intent(in) :: M(50,64)


#ifndef PRECISION_dp
  if (ntryL==1 .OR. p_switch == 1) Gcoeff(:)%hf = Hel
#else
  if (ntryL==1 .OR. p_switch == 2) Gcoeff(:)%hf = Hel
#endif

  ! =============================================


! Dressing, otf merging and otf reduction calls to build loop structures

  Gcoeff(:)%j = (-(c(15)*M(12,:)%j)+c(16)*M(46,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(1),h0tab(:,1),[32,8,2,1,4,16],[nMT,nMT,0,nMT,nMT,nMT],6,0)
  call Hloop_QV_A(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,1),heltab2x64(:,:,1))
  call Hloop_Q_A(ntryL,G0H32(1),32,nMT,G1H32(1),n2h32(1))
  Gcoeff(:)%j = (c(19)*M(12,:)%j+c(16)*(M(26,:)%j+M(27,:)%j+M(29,:)%j+M(32,:)%j+M(34,:)%j+M(36,:)%j-M(39,:)%j-M(40,:)%j-M(41,:)%j &
    -M(43,:)%j+M(48,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(2),h0tab(:,2),[32,8,2,1,4,16],[0,0,nMT,0,0,0],6,0)
  call Hloop_UV_W(ntryL,G0H64(1),0,ex6(:),32,G1H32(2),m3h2x32(:,2),heltab2x64(:,:,2))
  Gcoeff(:)%j = (-(c(15)*M(10,:)%j)+c(16)*M(45,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(3),h0tab(:,3),[32,4,1,2,8,16],[nMT,nMT,0,nMT,nMT,nMT],6,0)
  call Hloop_AV_Q(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,3),heltab2x64(:,:,3))
  call Hloop_A_Q(ntryL,G0H32(1),32,nMT,G1H32(3),n2h32(2))
  Gcoeff(:)%j = (c(19)*M(10,:)%j+c(16)*(M(25,:)%j+M(27,:)%j+M(29,:)%j+M(32,:)%j+M(34,:)%j+M(36,:)%j-M(39,:)%j-M(41,:)%j-M(42,:)%j &
    -M(44,:)%j+M(50,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(4),h0tab(:,4),[32,4,1,2,8,16],[0,0,nMT,0,0,0],6,0)
  call Hloop_UV_W(ntryL,G0H64(1),0,ex6(:),32,G1H32(4),m3h2x32(:,4),heltab2x64(:,:,4))
  Gcoeff(:)%j = (-(c(15)*M(18,:)%j)+c(16)*M(48,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(5),h0tab(:,5),[32,8,4,1,2,16],[nMT,nMT,nMT,0,nMT,nMT],6,0)
  call Hloop_AV_Q(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,5),heltab2x64(:,:,5))
  call Hloop_A_Q(ntryL,G0H32(1),32,nMT,G1H32(5),n2h32(3))
  Gcoeff(:)%j = (c(19)*M(18,:)%j+c(16)*(M(25,:)%j+M(28,:)%j+M(30,:)%j+M(32,:)%j+M(34,:)%j+M(36,:)%j-M(37,:)%j-M(38,:)%j-M(42,:)%j &
    -M(44,:)%j+M(46,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(6),h0tab(:,6),[32,8,4,1,2,16],[0,0,0,nMT,0,0],6,0)
  call Hloop_UV_W(ntryL,G0H64(1),0,ex6(:),32,G1H32(6),m3h2x32(:,6),heltab2x64(:,:,6))
  Gcoeff(:)%j = (-(c(15)*M(16,:)%j)+c(16)*M(47,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(7),h0tab(:,7),[32,4,1,2,16,8],[nMT,nMT,0,nMT,nMT,nMT],6,0)
  call Hloop_AV_Q(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,7),heltab2x64(:,:,7))
  call Hloop_A_Q(ntryL,G0H32(1),32,nMT,G1H32(7),n2h32(4))
  Gcoeff(:)%j = (c(19)*M(16,:)%j+c(16)*(M(25,:)%j+M(27,:)%j+M(30,:)%j+M(32,:)%j+M(34,:)%j+M(36,:)%j-M(37,:)%j-M(41,:)%j-M(42,:)%j &
    -M(43,:)%j+M(49,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(8),h0tab(:,8),[32,4,1,2,16,8],[0,0,nMT,0,0,0],6,0)
  call Hloop_UV_W(ntryL,G0H64(1),0,ex6(:),32,G1H32(8),m3h2x32(:,8),heltab2x64(:,:,8))
  Gcoeff(:)%j = (-(c(15)*M(24,:)%j)+c(16)*M(50,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(9),h0tab(:,9),[32,2,1,4,8,16],[nMT,0,nMT,nMT,nMT,nMT],6,0)
  call Hloop_QV_A(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,9),heltab2x64(:,:,9))
  call Hloop_Q_A(ntryL,G0H32(1),32,nMT,G1H32(9),n2h32(5))
  Gcoeff(:)%j = (c(19)*M(24,:)%j+c(16)*(M(26,:)%j+M(28,:)%j+M(30,:)%j+M(32,:)%j+M(34,:)%j+M(36,:)%j-M(37,:)%j-M(38,:)%j-M(40,:)%j &
    -M(43,:)%j+M(45,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(10),h0tab(:,10),[32,2,1,4,8,16],[0,nMT,0,0,0,0],6,0)
  call Hloop_UV_W(ntryL,G0H64(1),0,ex6(:),32,G1H32(10),m3h2x32(:,10),heltab2x64(:,:,10))
  Gcoeff(:)%j = (-(c(15)*M(22,:)%j)+c(16)*M(49,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(11),h0tab(:,11),[32,2,1,4,16,8],[nMT,0,nMT,nMT,nMT,nMT],6,0)
  call Hloop_QV_A(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,11),heltab2x64(:,:,11))
  call Hloop_Q_A(ntryL,G0H32(1),32,nMT,G1H32(11),n2h32(6))
  Gcoeff(:)%j = (c(19)*M(22,:)%j+c(16)*(M(26,:)%j+M(28,:)%j+M(29,:)%j+M(32,:)%j+M(34,:)%j+M(36,:)%j-M(38,:)%j-M(39,:)%j-M(40,:)%j &
    -M(44,:)%j+M(47,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(12),h0tab(:,12),[32,2,1,4,16,8],[0,nMT,0,0,0,0],6,0)
  call Hloop_UV_W(ntryL,G0H64(1),0,ex6(:),32,G1H32(12),m3h2x32(:,12),heltab2x64(:,:,12))
  Gcoeff(:)%j = (-(c(15)*M(4,:)%j)+c(16)*M(48,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(13),h0tab(:,13),[32,8,1,2,4,16],[nMT,nMT,0,nMT,nMT,nMT],6,0)
  call Hloop_AV_Q(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,13),heltab2x64(:,:,13))
  call Hloop_A_Q(ntryL,G0H32(1),32,nMT,G1H32(13),n2h32(7))
  Gcoeff(:)%j = (c(19)*M(4,:)%j+c(16)*(M(25,:)%j+M(28,:)%j+M(30,:)%j+M(31,:)%j+M(33,:)%j+M(35,:)%j-M(37,:)%j-M(38,:)%j-M(42,:)%j &
    -M(44,:)%j+M(46,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(14),h0tab(:,14),[32,8,1,2,4,16],[0,0,nMT,0,0,0],6,0)
  call Hloop_UV_W(ntryL,G0H64(1),0,ex6(:),32,G1H32(14),m3h2x32(:,14),heltab2x64(:,:,14))
  Gcoeff(:)%j = (-(c(15)*M(6,:)%j)+c(16)*M(50,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(15),h0tab(:,15),[32,4,2,1,8,16],[nMT,nMT,0,nMT,nMT,nMT],6,0)
  call Hloop_QV_A(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,15),heltab2x64(:,:,15))
  call Hloop_Q_A(ntryL,G0H32(1),32,nMT,G1H32(15),n2h32(8))
  Gcoeff(:)%j = (c(19)*M(6,:)%j+c(16)*(M(26,:)%j+M(28,:)%j+M(30,:)%j+M(31,:)%j+M(33,:)%j+M(35,:)%j-M(37,:)%j-M(38,:)%j-M(40,:)%j &
    -M(43,:)%j+M(45,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(16),h0tab(:,16),[32,4,2,1,8,16],[0,0,nMT,0,0,0],6,0)
  call Hloop_UV_W(ntryL,G0H64(1),0,ex6(:),32,G1H32(16),m3h2x32(:,16),heltab2x64(:,:,16))
  Gcoeff(:)%j = (-(c(15)*M(17,:)%j)+c(16)*M(45,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(17),h0tab(:,17),[32,4,8,1,2,16],[nMT,nMT,nMT,0,nMT,nMT],6,0)
  call Hloop_AV_Q(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,17),heltab2x64(:,:,17))
  call Hloop_A_Q(ntryL,G0H32(1),32,nMT,G1H32(17),n2h32(9))
  Gcoeff(:)%j = (c(19)*M(17,:)%j+c(16)*(M(25,:)%j+M(28,:)%j+M(30,:)%j+M(32,:)%j+M(34,:)%j+M(35,:)%j-M(39,:)%j-M(41,:)%j-M(42,:)%j &
    -M(44,:)%j+M(50,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(18),h0tab(:,18),[32,4,8,1,2,16],[0,0,0,nMT,0,0],6,0)
  call Hloop_UV_W(ntryL,G0H64(1),0,ex6(:),32,G1H32(18),m3h2x32(:,18),heltab2x64(:,:,18))
  Gcoeff(:)%j = (-(c(15)*M(14,:)%j)+c(16)*M(49,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(19),h0tab(:,19),[32,4,16,2,1,8],[nMT,nMT,nMT,0,nMT,nMT],6,0)
  call Hloop_QV_A(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,19),heltab2x64(:,:,19))
  call Hloop_Q_A(ntryL,G0H32(1),32,nMT,G1H32(19),n2h32(10))
  Gcoeff(:)%j = (c(19)*M(14,:)%j+c(16)*(M(25,:)%j+M(28,:)%j+M(30,:)%j+M(31,:)%j+M(34,:)%j+M(35,:)%j-M(38,:)%j-M(39,:)%j-M(40,:)%j &
    -M(44,:)%j+M(47,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(20),h0tab(:,20),[32,4,16,2,1,8],[0,0,0,nMT,0,0],6,0)
  call Hloop_UV_W(ntryL,G0H64(1),0,ex6(:),32,G1H32(20),m3h2x32(:,20),heltab2x64(:,:,20))
  Gcoeff(:)%j = (-(c(15)*M(23,:)%j)+c(16)*M(46,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(21),h0tab(:,21),[32,2,1,8,4,16],[nMT,0,nMT,nMT,nMT,nMT],6,0)
  call Hloop_QV_A(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,21),heltab2x64(:,:,21))
  call Hloop_Q_A(ntryL,G0H32(1),32,nMT,G1H32(21),n2h32(11))
  Gcoeff(:)%j = (c(19)*M(23,:)%j+c(16)*(M(26,:)%j+M(28,:)%j+M(30,:)%j+M(32,:)%j+M(34,:)%j+M(35,:)%j-M(39,:)%j-M(40,:)%j-M(41,:)%j &
    -M(43,:)%j+M(48,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(22),h0tab(:,22),[32,2,1,8,4,16],[0,nMT,0,0,0,0],6,0)
  call Hloop_UV_W(ntryL,G0H64(1),0,ex6(:),32,G1H32(22),m3h2x32(:,22),heltab2x64(:,:,22))
  Gcoeff(:)%j = (-(c(15)*M(20,:)%j)+c(16)*M(47,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(23),h0tab(:,23),[32,2,1,8,16,4],[nMT,0,nMT,nMT,nMT,nMT],6,0)
  call Hloop_QV_A(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,23),heltab2x64(:,:,23))
  call Hloop_Q_A(ntryL,G0H32(1),32,nMT,G1H32(23),n2h32(12))
  Gcoeff(:)%j = (c(19)*M(20,:)%j+c(16)*(M(26,:)%j+M(28,:)%j+M(30,:)%j+M(32,:)%j+M(33,:)%j+M(35,:)%j-M(37,:)%j-M(41,:)%j-M(42,:)%j &
    -M(43,:)%j+M(49,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(24),h0tab(:,24),[32,2,1,8,16,4],[0,nMT,0,0,0,0],6,0)
  call Hloop_UV_W(ntryL,G0H64(1),0,ex6(:),32,G1H32(24),m3h2x32(:,24),heltab2x64(:,:,24))
  Gcoeff(:)%j = (-(c(15)*M(2,:)%j)+c(16)*M(46,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(25),h0tab(:,25),[32,8,4,2,1,16],[nMT,nMT,nMT,0,nMT,nMT],6,0)
  call Hloop_QV_A(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,25),heltab2x64(:,:,25))
  call Hloop_Q_A(ntryL,G0H32(1),32,nMT,G1H32(25),n2h32(13))
  Gcoeff(:)%j = (c(19)*M(2,:)%j+c(16)*(M(26,:)%j+M(27,:)%j+M(29,:)%j+M(31,:)%j+M(33,:)%j+M(35,:)%j-M(39,:)%j-M(40,:)%j-M(41,:)%j &
    -M(43,:)%j+M(48,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(26),h0tab(:,26),[32,8,4,2,1,16],[0,0,0,nMT,0,0],6,0)
  call Hloop_UV_W(ntryL,G0H64(1),0,ex6(:),32,G1H32(26),m3h2x32(:,26),heltab2x64(:,:,26))
  Gcoeff(:)%j = (-(c(15)*M(5,:)%j)+c(16)*M(49,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(27),h0tab(:,27),[32,4,2,1,16,8],[nMT,nMT,0,nMT,nMT,nMT],6,0)
  call Hloop_QV_A(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,27),heltab2x64(:,:,27))
  call Hloop_Q_A(ntryL,G0H32(1),32,nMT,G1H32(27),n2h32(14))
  Gcoeff(:)%j = (c(19)*M(5,:)%j+c(16)*(M(26,:)%j+M(28,:)%j+M(29,:)%j+M(31,:)%j+M(33,:)%j+M(35,:)%j-M(38,:)%j-M(39,:)%j-M(40,:)%j &
    -M(44,:)%j+M(47,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(28),h0tab(:,28),[32,4,2,1,16,8],[0,0,nMT,0,0,0],6,0)
  call Hloop_UV_W(ntryL,G0H64(1),0,ex6(:),32,G1H32(28),m3h2x32(:,28),heltab2x64(:,:,28))
  Gcoeff(:)%j = (-(c(15)*M(8,:)%j)+c(16)*M(50,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(29),h0tab(:,29),[32,4,8,2,1,16],[nMT,nMT,nMT,0,nMT,nMT],6,0)
  call Hloop_QV_A(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,29),heltab2x64(:,:,29))
  call Hloop_Q_A(ntryL,G0H32(1),32,nMT,G1H32(29),n2h32(15))
  Gcoeff(:)%j = (c(19)*M(8,:)%j+c(16)*(M(26,:)%j+M(27,:)%j+M(29,:)%j+M(31,:)%j+M(33,:)%j+M(36,:)%j-M(37,:)%j-M(38,:)%j-M(40,:)%j &
    -M(43,:)%j+M(45,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(30),h0tab(:,30),[32,4,8,2,1,16],[0,0,0,nMT,0,0],6,0)
  call Hloop_UV_W(ntryL,G0H64(1),0,ex6(:),32,G1H32(30),m3h2x32(:,30),heltab2x64(:,:,30))
  Gcoeff(:)%j = (-(c(15)*M(11,:)%j)+c(16)*M(47,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(31),h0tab(:,31),[32,4,16,1,2,8],[nMT,nMT,nMT,0,nMT,nMT],6,0)
  call Hloop_AV_Q(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,31),heltab2x64(:,:,31))
  call Hloop_A_Q(ntryL,G0H32(1),32,nMT,G1H32(31),n2h32(16))
  Gcoeff(:)%j = (c(19)*M(11,:)%j+c(16)*(M(26,:)%j+M(27,:)%j+M(29,:)%j+M(32,:)%j+M(33,:)%j+M(36,:)%j-M(37,:)%j-M(41,:)%j-M(42,:)%j &
    -M(43,:)%j+M(49,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(32),h0tab(:,32),[32,4,16,1,2,8],[0,0,0,nMT,0,0],6,0)
  call Hloop_UV_W(ntryL,G0H64(1),0,ex6(:),32,G1H32(32),m3h2x32(:,32),heltab2x64(:,:,32))
  Gcoeff(:)%j = (-(c(15)*M(21,:)%j)+c(16)*M(48,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(33),h0tab(:,33),[32,2,1,16,4,8],[nMT,0,nMT,nMT,nMT,nMT],6,0)
  call Hloop_QV_A(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,33),heltab2x64(:,:,33))
  call Hloop_Q_A(ntryL,G0H32(1),32,nMT,G1H32(33),n2h32(17))
  Gcoeff(:)%j = (c(19)*M(21,:)%j+c(16)*(M(26,:)%j+M(28,:)%j+M(29,:)%j+M(32,:)%j+M(33,:)%j+M(36,:)%j-M(37,:)%j-M(38,:)%j-M(42,:)%j &
    -M(44,:)%j+M(46,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(34),h0tab(:,34),[32,2,1,16,4,8],[0,nMT,0,0,0,0],6,0)
  call Hloop_UV_W(ntryL,G0H64(1),0,ex6(:),32,G1H32(34),m3h2x32(:,34),heltab2x64(:,:,34))
  Gcoeff(:)%j = (-(c(15)*M(19,:)%j)+c(16)*M(45,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(35),h0tab(:,35),[32,2,1,16,8,4],[nMT,0,nMT,nMT,nMT,nMT],6,0)
  call Hloop_QV_A(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,35),heltab2x64(:,:,35))
  call Hloop_Q_A(ntryL,G0H32(1),32,nMT,G1H32(35),n2h32(18))
  Gcoeff(:)%j = (c(19)*M(19,:)%j+c(16)*(M(26,:)%j+M(28,:)%j+M(29,:)%j+M(32,:)%j+M(33,:)%j+M(35,:)%j-M(39,:)%j-M(41,:)%j-M(42,:)%j &
    -M(44,:)%j+M(50,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(36),h0tab(:,36),[32,2,1,16,8,4],[0,nMT,0,0,0,0],6,0)
  call Hloop_UV_W(ntryL,G0H64(1),0,ex6(:),32,G1H32(36),m3h2x32(:,36),heltab2x64(:,:,36))
  Gcoeff(:)%j = (-(c(15)*M(1,:)%j)+c(16)*M(45,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(37),h0tab(:,37),[32,1,2,4,8,16],[nMT,0,nMT,nMT,nMT,nMT],6,0)
  call Hloop_AV_Q(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,37),heltab2x64(:,:,37))
  call Hloop_A_Q(ntryL,G0H32(1),32,nMT,G1H32(37),n2h32(19))
  Gcoeff(:)%j = (c(19)*M(1,:)%j+c(16)*(M(25,:)%j+M(27,:)%j+M(29,:)%j+M(31,:)%j+M(33,:)%j+M(35,:)%j-M(39,:)%j-M(41,:)%j-M(42,:)%j &
    -M(44,:)%j+M(50,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(38),h0tab(:,38),[32,1,2,4,8,16],[0,nMT,0,0,0,0],6,0)
  call Hloop_UV_W(ntryL,G0H64(1),0,ex6(:),32,G1H32(38),m3h2x32(:,38),heltab2x64(:,:,38))
  Gcoeff(:)%j = (-(c(15)*M(3,:)%j)+c(16)*M(47,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(39),h0tab(:,39),[32,1,2,4,16,8],[nMT,0,nMT,nMT,nMT,nMT],6,0)
  call Hloop_AV_Q(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,39),heltab2x64(:,:,39))
  call Hloop_A_Q(ntryL,G0H32(1),32,nMT,G1H32(39),n2h32(20))
  Gcoeff(:)%j = (c(19)*M(3,:)%j+c(16)*(M(25,:)%j+M(27,:)%j+M(30,:)%j+M(31,:)%j+M(33,:)%j+M(35,:)%j-M(37,:)%j-M(41,:)%j-M(42,:)%j &
    -M(43,:)%j+M(49,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(40),h0tab(:,40),[32,1,2,4,16,8],[0,nMT,0,0,0,0],6,0)
  call Hloop_UV_W(ntryL,G0H64(1),0,ex6(:),32,G1H32(40),m3h2x32(:,40),heltab2x64(:,:,40))
  Gcoeff(:)%j = (-(c(15)*M(7,:)%j)+c(16)*M(48,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(41),h0tab(:,41),[32,1,2,8,4,16],[nMT,0,nMT,nMT,nMT,nMT],6,0)
  call Hloop_AV_Q(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,41),heltab2x64(:,:,41))
  call Hloop_A_Q(ntryL,G0H32(1),32,nMT,G1H32(41),n2h32(21))
  Gcoeff(:)%j = (c(19)*M(7,:)%j+c(16)*(M(25,:)%j+M(27,:)%j+M(29,:)%j+M(31,:)%j+M(33,:)%j+M(36,:)%j-M(37,:)%j-M(38,:)%j-M(42,:)%j &
    -M(44,:)%j+M(46,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(42),h0tab(:,42),[32,1,2,8,4,16],[0,nMT,0,0,0,0],6,0)
  call Hloop_UV_W(ntryL,G0H64(1),0,ex6(:),32,G1H32(42),m3h2x32(:,42),heltab2x64(:,:,42))
  Gcoeff(:)%j = (-(c(15)*M(9,:)%j)+c(16)*M(49,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(43),h0tab(:,43),[32,1,2,8,16,4],[nMT,0,nMT,nMT,nMT,nMT],6,0)
  call Hloop_AV_Q(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,43),heltab2x64(:,:,43))
  call Hloop_A_Q(ntryL,G0H32(1),32,nMT,G1H32(43),n2h32(22))
  Gcoeff(:)%j = (c(19)*M(9,:)%j+c(16)*(M(25,:)%j+M(27,:)%j+M(29,:)%j+M(31,:)%j+M(34,:)%j+M(36,:)%j-M(38,:)%j-M(39,:)%j-M(40,:)%j &
    -M(44,:)%j+M(47,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(44),h0tab(:,44),[32,1,2,8,16,4],[0,nMT,0,0,0,0],6,0)
  call Hloop_UV_W(ntryL,G0H64(1),0,ex6(:),32,G1H32(44),m3h2x32(:,44),heltab2x64(:,:,44))
  Gcoeff(:)%j = (-(c(15)*M(13,:)%j)+c(16)*M(46,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(45),h0tab(:,45),[32,1,2,16,4,8],[nMT,0,nMT,nMT,nMT,nMT],6,0)
  call Hloop_AV_Q(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,45),heltab2x64(:,:,45))
  call Hloop_A_Q(ntryL,G0H32(1),32,nMT,G1H32(45),n2h32(23))
  Gcoeff(:)%j = (c(19)*M(13,:)%j+c(16)*(M(25,:)%j+M(27,:)%j+M(30,:)%j+M(31,:)%j+M(34,:)%j+M(35,:)%j-M(39,:)%j-M(40,:)%j-M(41,:)%j &
    -M(43,:)%j+M(48,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(46),h0tab(:,46),[32,1,2,16,4,8],[0,nMT,0,0,0,0],6,0)
  call Hloop_UV_W(ntryL,G0H64(1),0,ex6(:),32,G1H32(46),m3h2x32(:,46),heltab2x64(:,:,46))
  Gcoeff(:)%j = (-(c(15)*M(15,:)%j)+c(16)*M(50,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(47),h0tab(:,47),[32,1,2,16,8,4],[nMT,0,nMT,nMT,nMT,nMT],6,0)
  call Hloop_AV_Q(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,47),heltab2x64(:,:,47))
  call Hloop_A_Q(ntryL,G0H32(1),32,nMT,G1H32(47),n2h32(24))
  Gcoeff(:)%j = (c(19)*M(15,:)%j+c(16)*(M(25,:)%j+M(27,:)%j+M(30,:)%j+M(31,:)%j+M(34,:)%j+M(36,:)%j-M(37,:)%j-M(38,:)%j-M(40,:)%j &
    -M(43,:)%j+M(45,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(48),h0tab(:,48),[32,1,2,16,8,4],[0,nMT,0,0,0,0],6,0)
  call Hloop_UV_W(ntryL,G0H64(1),0,ex6(:),32,G1H32(48),m3h2x32(:,48),heltab2x64(:,:,48))
  Gcoeff(:)%j = (c(6)*(M(43,:)%j-M(48,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(49),h0tab(:,49),[32,8,1,4,2,16],[nMT,nMT,0,0,nMT,nMT],6,0)
  call Hloop_AV_Q(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,49),heltab2x64(:,:,49))
  call Hloop_A_Q(ntryL,G0H32(1),32,nMT,G1H32(49),n2h32(25))
  Gcoeff(:)%j = (c(6)*(M(25,:)%j+M(28,:)%j+M(30,:)%j-M(37,:)%j-M(38,:)%j-M(42,:)%j+M(46,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(50),h0tab(:,50),[32,8,1,4,2,16],[0,0,nMT,nMT,0,0],6,0)
  call Hloop_UV_W(ntryL,G0H64(1),0,ex6(:),32,G1H32(50),m3h2x32(:,50),heltab2x64(:,:,50))
  Gcoeff(:)%j = (c(6)*(-M(44,:)%j+M(50,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(51),h0tab(:,51),[32,2,4,1,8,16],[nMT,0,0,nMT,nMT,nMT],6,0)
  call Hloop_QV_A(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,51),heltab2x64(:,:,51))
  call Hloop_Q_A(ntryL,G0H32(1),32,nMT,G1H32(51),n2h32(26))
  Gcoeff(:)%j = (c(6)*(-M(26,:)%j-M(28,:)%j-M(30,:)%j+M(37,:)%j+M(38,:)%j+M(40,:)%j-M(45,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(52),h0tab(:,52),[32,2,4,1,8,16],[0,nMT,nMT,0,0,0],6,0)
  call Hloop_UV_W(ntryL,G0H64(1),0,ex6(:),32,G1H32(52),m3h2x32(:,52),heltab2x64(:,:,52))
  Gcoeff(:)%j = (c(6)*(M(40,:)%j-M(45,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(53),h0tab(:,53),[32,4,1,8,2,16],[nMT,nMT,0,0,nMT,nMT],6,0)
  call Hloop_AV_Q(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,53),heltab2x64(:,:,53))
  call Hloop_A_Q(ntryL,G0H32(1),32,nMT,G1H32(53),n2h32(27))
  Gcoeff(:)%j = (c(6)*(M(25,:)%j+M(32,:)%j+M(34,:)%j-M(39,:)%j-M(41,:)%j-M(44,:)%j+M(50,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(54),h0tab(:,54),[32,4,1,8,2,16],[0,0,nMT,nMT,0,0],6,0)
  call Hloop_UV_W(ntryL,G0H64(1),0,ex6(:),32,G1H32(54),m3h2x32(:,54),heltab2x64(:,:,54))
  Gcoeff(:)%j = (c(6)*(-M(42,:)%j+M(46,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(55),h0tab(:,55),[32,2,8,1,4,16],[nMT,0,0,nMT,nMT,nMT],6,0)
  call Hloop_QV_A(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,55),heltab2x64(:,:,55))
  call Hloop_Q_A(ntryL,G0H32(1),32,nMT,G1H32(55),n2h32(28))
  Gcoeff(:)%j = (c(6)*(-M(26,:)%j-M(32,:)%j-M(34,:)%j+M(39,:)%j+M(41,:)%j+M(43,:)%j-M(48,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(56),h0tab(:,56),[32,2,8,1,4,16],[0,nMT,nMT,0,0,0],6,0)
  call Hloop_UV_W(ntryL,G0H64(1),0,ex6(:),32,G1H32(56),m3h2x32(:,56),heltab2x64(:,:,56))
  Gcoeff(:)%j = (c(16)*(M(28,:)%j-M(37,:)%j-M(42,:)%j+M(46,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(57),h0tab(:,57),[32,2,16,4,1,8],[0,nMT,nMT,nMT,0,0],6,0)
  call Hloop_UV_W(ntryL,G0H64(1),0,ex6(:),32,G1H32(57),m3h2x32(:,57),heltab2x64(:,:,57))
  Gcoeff(:)%j = (c(16)*(M(34,:)%j-M(41,:)%j-M(43,:)%j+M(48,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(58),h0tab(:,58),[32,2,16,4,1,8],[nMT,0,0,0,nMT,nMT],6,0)
  call Hloop_QV_A(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,58),heltab2x64(:,:,58))
  call Hloop_Q_A(ntryL,G0H32(1),32,nMT,G1H32(58),n2h32(29))
  Gcoeff(:)%j = (c(16)*(M(30,:)%j-M(38,:)%j-M(40,:)%j+M(45,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(59),h0tab(:,59),[32,2,16,8,1,4],[nMT,0,0,0,nMT,nMT],6,0)
  call Hloop_QV_A(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,59),heltab2x64(:,:,59))
  call Hloop_Q_A(ntryL,G0H32(1),32,nMT,G1H32(59),n2h32(30))
  Gcoeff(:)%j = (c(16)*(M(32,:)%j-M(39,:)%j-M(44,:)%j+M(50,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(60),h0tab(:,60),[32,2,16,8,1,4],[0,nMT,nMT,nMT,0,0],6,0)
  call Hloop_UV_W(ntryL,G0H64(1),0,ex6(:),32,G1H32(60),m3h2x32(:,60),heltab2x64(:,:,60))
  Gcoeff(:)%j = (c(6)*(-M(44,:)%j+M(46,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(61),h0tab(:,61),[32,8,2,4,1,16],[nMT,nMT,0,0,nMT,nMT],6,0)
  call Hloop_QV_A(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,61),heltab2x64(:,:,61))
  call Hloop_Q_A(ntryL,G0H32(1),32,nMT,G1H32(61),n2h32(31))
  Gcoeff(:)%j = (c(6)*(-M(26,:)%j-M(27,:)%j-M(29,:)%j+M(39,:)%j+M(40,:)%j+M(41,:)%j-M(48,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(62),h0tab(:,62),[32,8,2,4,1,16],[0,0,nMT,nMT,0,0],6,0)
  call Hloop_UV_W(ntryL,G0H64(1),0,ex6(:),32,G1H32(62),m3h2x32(:,62),heltab2x64(:,:,62))
  Gcoeff(:)%j = (c(6)*(-M(43,:)%j+M(49,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(63),h0tab(:,63),[32,2,4,1,16,8],[nMT,0,0,nMT,nMT,nMT],6,0)
  call Hloop_QV_A(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,63),heltab2x64(:,:,63))
  call Hloop_Q_A(ntryL,G0H32(1),32,nMT,G1H32(63),n2h32(32))
  Gcoeff(:)%j = (c(6)*(-M(26,:)%j-M(28,:)%j-M(29,:)%j+M(38,:)%j+M(39,:)%j+M(40,:)%j-M(47,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(64),h0tab(:,64),[32,2,4,1,16,8],[0,nMT,nMT,0,0,0],6,0)
  call Hloop_UV_W(ntryL,G0H64(1),0,ex6(:),32,G1H32(64),m3h2x32(:,64),heltab2x64(:,:,64))
  Gcoeff(:)%j = (c(6)*(M(38,:)%j-M(47,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(65),h0tab(:,65),[32,4,1,16,2,8],[nMT,nMT,0,0,nMT,nMT],6,0)
  call Hloop_AV_Q(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,65),heltab2x64(:,:,65))
  call Hloop_A_Q(ntryL,G0H32(1),32,nMT,G1H32(65),n2h32(33))
  Gcoeff(:)%j = (c(6)*(M(27,:)%j+M(32,:)%j+M(36,:)%j-M(37,:)%j-M(42,:)%j-M(43,:)%j+M(49,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(66),h0tab(:,66),[32,4,1,16,2,8],[0,0,nMT,nMT,0,0],6,0)
  call Hloop_UV_W(ntryL,G0H64(1),0,ex6(:),32,G1H32(66),m3h2x32(:,66),heltab2x64(:,:,66))
  Gcoeff(:)%j = (c(16)*(M(26,:)%j-M(39,:)%j-M(41,:)%j+M(48,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(67),h0tab(:,67),[32,2,8,4,1,16],[0,nMT,nMT,nMT,0,0],6,0)
  call Hloop_UV_W(ntryL,G0H64(1),0,ex6(:),32,G1H32(67),m3h2x32(:,67),heltab2x64(:,:,67))
  Gcoeff(:)%j = (c(16)*(M(36,:)%j-M(42,:)%j-M(44,:)%j+M(46,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(68),h0tab(:,68),[32,2,8,4,1,16],[nMT,0,0,0,nMT,nMT],6,0)
  call Hloop_QV_A(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,68),heltab2x64(:,:,68))
  call Hloop_Q_A(ntryL,G0H32(1),32,nMT,G1H32(68),n2h32(34))
  Gcoeff(:)%j = (c(16)*(M(29,:)%j-M(38,:)%j-M(40,:)%j+M(47,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(69),h0tab(:,69),[32,2,8,16,1,4],[nMT,0,0,0,nMT,nMT],6,0)
  call Hloop_QV_A(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,69),heltab2x64(:,:,69))
  call Hloop_Q_A(ntryL,G0H32(1),32,nMT,G1H32(69),n2h32(35))
  Gcoeff(:)%j = (c(16)*(M(32,:)%j-M(37,:)%j-M(43,:)%j+M(49,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(70),h0tab(:,70),[32,2,8,16,1,4],[0,nMT,nMT,nMT,0,0],6,0)
  call Hloop_UV_W(ntryL,G0H64(1),0,ex6(:),32,G1H32(70),m3h2x32(:,70),heltab2x64(:,:,70))
  Gcoeff(:)%j = (c(6)*(-M(41,:)%j+M(48,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(71),h0tab(:,71),[32,2,16,1,4,8],[nMT,0,0,nMT,nMT,nMT],6,0)
  call Hloop_QV_A(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,71),heltab2x64(:,:,71))
  call Hloop_Q_A(ntryL,G0H32(1),32,nMT,G1H32(71),n2h32(36))
  Gcoeff(:)%j = (c(6)*(-M(28,:)%j-M(32,:)%j-M(36,:)%j+M(37,:)%j+M(42,:)%j+M(44,:)%j-M(46,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(72),h0tab(:,72),[32,2,16,1,4,8],[0,nMT,nMT,0,0,0],6,0)
  call Hloop_UV_W(ntryL,G0H64(1),0,ex6(:),32,G1H32(72),m3h2x32(:,72),heltab2x64(:,:,72))
  Gcoeff(:)%j = (c(6)*(M(43,:)%j-M(45,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(73),h0tab(:,73),[32,1,4,2,8,16],[nMT,0,0,nMT,nMT,nMT],6,0)
  call Hloop_AV_Q(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,73),heltab2x64(:,:,73))
  call Hloop_A_Q(ntryL,G0H32(1),32,nMT,G1H32(73),n2h32(37))
  Gcoeff(:)%j = (c(6)*(M(25,:)%j+M(27,:)%j+M(29,:)%j-M(39,:)%j-M(41,:)%j-M(42,:)%j+M(50,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(74),h0tab(:,74),[32,1,4,2,8,16],[0,nMT,nMT,0,0,0],6,0)
  call Hloop_UV_W(ntryL,G0H64(1),0,ex6(:),32,G1H32(74),m3h2x32(:,74),heltab2x64(:,:,74))
  Gcoeff(:)%j = (c(6)*(M(44,:)%j-M(47,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(75),h0tab(:,75),[32,1,4,2,16,8],[nMT,0,0,nMT,nMT,nMT],6,0)
  call Hloop_AV_Q(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,75),heltab2x64(:,:,75))
  call Hloop_A_Q(ntryL,G0H32(1),32,nMT,G1H32(75),n2h32(38))
  Gcoeff(:)%j = (c(6)*(M(25,:)%j+M(27,:)%j+M(30,:)%j-M(37,:)%j-M(41,:)%j-M(42,:)%j+M(49,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(76),h0tab(:,76),[32,1,4,2,16,8],[0,nMT,nMT,0,0,0],6,0)
  call Hloop_UV_W(ntryL,G0H64(1),0,ex6(:),32,G1H32(76),m3h2x32(:,76),heltab2x64(:,:,76))
  Gcoeff(:)%j = (c(16)*(M(25,:)%j-M(39,:)%j-M(41,:)%j+M(50,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(77),h0tab(:,77),[32,1,4,8,2,16],[0,nMT,nMT,nMT,0,0],6,0)
  call Hloop_UV_W(ntryL,G0H64(1),0,ex6(:),32,G1H32(77),m3h2x32(:,77),heltab2x64(:,:,77))
  Gcoeff(:)%j = (c(16)*(M(36,:)%j-M(40,:)%j-M(43,:)%j+M(45,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(78),h0tab(:,78),[32,1,4,8,2,16],[nMT,0,0,0,nMT,nMT],6,0)
  call Hloop_AV_Q(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,78),heltab2x64(:,:,78))
  call Hloop_A_Q(ntryL,G0H32(1),32,nMT,G1H32(78),n2h32(39))
  Gcoeff(:)%j = (c(16)*(M(27,:)%j-M(37,:)%j-M(42,:)%j+M(49,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(79),h0tab(:,79),[32,1,4,16,2,8],[0,nMT,nMT,nMT,0,0],6,0)
  call Hloop_UV_W(ntryL,G0H64(1),0,ex6(:),32,G1H32(79),m3h2x32(:,79),heltab2x64(:,:,79))
  Gcoeff(:)%j = (c(16)*(M(34,:)%j-M(38,:)%j-M(44,:)%j+M(47,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(80),h0tab(:,80),[32,1,4,16,2,8],[nMT,0,0,0,nMT,nMT],6,0)
  call Hloop_AV_Q(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,80),heltab2x64(:,:,80))
  call Hloop_A_Q(ntryL,G0H32(1),32,nMT,G1H32(80),n2h32(40))
  Gcoeff(:)%j = (c(6)*(-M(37,:)%j+M(49,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(81),h0tab(:,81),[32,1,4,16,8,2],[0,nMT,nMT,nMT,nMT,0],6,0)
  call Hloop_UV_W(ntryL,G0H64(1),0,ex6(:),32,G1H32(81),m3h2x32(:,81),heltab2x64(:,:,81))
  Gcoeff(:)%j = (c(6)*(-M(29,:)%j-M(34,:)%j-M(36,:)%j+M(38,:)%j+M(40,:)%j+M(44,:)%j-M(47,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(82),h0tab(:,82),[32,1,4,16,8,2],[nMT,0,0,0,0,nMT],6,0)
  call Hloop_AV_Q(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,82),heltab2x64(:,:,82))
  call Hloop_A_Q(ntryL,G0H32(1),32,nMT,G1H32(82),n2h32(41))
  Gcoeff(:)%j = (c(6)*(-M(39,:)%j+M(50,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(83),h0tab(:,83),[32,1,4,8,16,2],[0,nMT,nMT,nMT,nMT,0],6,0)
  call Hloop_UV_W(ntryL,G0H64(1),0,ex6(:),32,G1H32(83),m3h2x32(:,83),heltab2x64(:,:,83))
  Gcoeff(:)%j = (c(6)*(-M(30,:)%j-M(34,:)%j-M(36,:)%j+M(38,:)%j+M(40,:)%j+M(43,:)%j-M(45,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(84),h0tab(:,84),[32,1,4,8,16,2],[nMT,0,0,0,0,nMT],6,0)
  call Hloop_AV_Q(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,84),heltab2x64(:,:,84))
  call Hloop_A_Q(ntryL,G0H32(1),32,nMT,G1H32(84),n2h32(42))
  Gcoeff(:)%j = (c(6)*(-M(42,:)%j+M(50,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(85),h0tab(:,85),[32,4,2,8,1,16],[nMT,nMT,0,0,nMT,nMT],6,0)
  call Hloop_QV_A(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,85),heltab2x64(:,:,85))
  call Hloop_Q_A(ntryL,G0H32(1),32,nMT,G1H32(85),n2h32(43))
  Gcoeff(:)%j = (c(6)*(-M(26,:)%j-M(31,:)%j-M(33,:)%j+M(37,:)%j+M(38,:)%j+M(43,:)%j-M(45,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(86),h0tab(:,86),[32,4,2,8,1,16],[0,0,nMT,nMT,0,0],6,0)
  call Hloop_UV_W(ntryL,G0H64(1),0,ex6(:),32,G1H32(86),m3h2x32(:,86),heltab2x64(:,:,86))
  Gcoeff(:)%j = (c(6)*(-M(41,:)%j+M(49,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(87),h0tab(:,87),[32,4,2,16,1,8],[nMT,nMT,0,0,nMT,nMT],6,0)
  call Hloop_QV_A(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,87),heltab2x64(:,:,87))
  call Hloop_Q_A(ntryL,G0H32(1),32,nMT,G1H32(87),n2h32(44))
  Gcoeff(:)%j = (c(6)*(-M(28,:)%j-M(31,:)%j-M(35,:)%j+M(39,:)%j+M(40,:)%j+M(44,:)%j-M(47,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(88),h0tab(:,88),[32,4,2,16,1,8],[0,0,nMT,nMT,0,0],6,0)
  call Hloop_UV_W(ntryL,G0H64(1),0,ex6(:),32,G1H32(88),m3h2x32(:,88),heltab2x64(:,:,88))
  Gcoeff(:)%j = (c(16)*(M(26,:)%j-M(37,:)%j-M(38,:)%j+M(45,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(89),h0tab(:,89),[32,2,4,8,1,16],[0,nMT,nMT,nMT,0,0],6,0)
  call Hloop_UV_W(ntryL,G0H64(1),0,ex6(:),32,G1H32(89),m3h2x32(:,89),heltab2x64(:,:,89))
  Gcoeff(:)%j = (c(16)*(M(35,:)%j-M(42,:)%j-M(44,:)%j+M(50,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(90),h0tab(:,90),[32,2,4,8,1,16],[nMT,0,0,0,nMT,nMT],6,0)
  call Hloop_QV_A(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,90),heltab2x64(:,:,90))
  call Hloop_Q_A(ntryL,G0H32(1),32,nMT,G1H32(90),n2h32(45))
  Gcoeff(:)%j = (c(16)*(M(33,:)%j-M(41,:)%j-M(43,:)%j+M(49,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(91),h0tab(:,91),[32,2,4,16,1,8],[nMT,0,0,0,nMT,nMT],6,0)
  call Hloop_QV_A(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,91),heltab2x64(:,:,91))
  call Hloop_Q_A(ntryL,G0H32(1),32,nMT,G1H32(91),n2h32(46))
  Gcoeff(:)%j = (c(16)*(M(28,:)%j-M(39,:)%j-M(40,:)%j+M(47,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(92),h0tab(:,92),[32,2,4,16,1,8],[0,nMT,nMT,nMT,0,0],6,0)
  call Hloop_UV_W(ntryL,G0H64(1),0,ex6(:),32,G1H32(92),m3h2x32(:,92),heltab2x64(:,:,92))
  Gcoeff(:)%j = (c(6)*(-M(40,:)%j+M(47,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(93),h0tab(:,93),[32,2,8,1,16,4],[nMT,0,0,nMT,nMT,nMT],6,0)
  call Hloop_QV_A(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,93),heltab2x64(:,:,93))
  call Hloop_Q_A(ntryL,G0H32(1),32,nMT,G1H32(93),n2h32(47))
  Gcoeff(:)%j = (c(6)*(-M(26,:)%j-M(32,:)%j-M(33,:)%j+M(37,:)%j+M(41,:)%j+M(43,:)%j-M(49,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(94),h0tab(:,94),[32,2,8,1,16,4],[0,nMT,nMT,0,0,0],6,0)
  call Hloop_UV_W(ntryL,G0H64(1),0,ex6(:),32,G1H32(94),m3h2x32(:,94),heltab2x64(:,:,94))
  Gcoeff(:)%j = (c(6)*(-M(38,:)%j+M(45,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(95),h0tab(:,95),[32,2,16,1,8,4],[nMT,0,0,nMT,nMT,nMT],6,0)
  call Hloop_QV_A(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,95),heltab2x64(:,:,95))
  call Hloop_Q_A(ntryL,G0H32(1),32,nMT,G1H32(95),n2h32(48))
  Gcoeff(:)%j = (c(6)*(-M(28,:)%j-M(32,:)%j-M(35,:)%j+M(39,:)%j+M(42,:)%j+M(44,:)%j-M(50,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(96),h0tab(:,96),[32,2,16,1,8,4],[0,nMT,nMT,0,0,0],6,0)
  call Hloop_UV_W(ntryL,G0H64(1),0,ex6(:),32,G1H32(96),m3h2x32(:,96),heltab2x64(:,:,96))
  Gcoeff(:)%j = (c(6)*(M(40,:)%j-M(48,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(97),h0tab(:,97),[32,1,8,2,4,16],[nMT,0,0,nMT,nMT,nMT],6,0)
  call Hloop_AV_Q(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,97),heltab2x64(:,:,97))
  call Hloop_A_Q(ntryL,G0H32(1),32,nMT,G1H32(97),n2h32(49))
  Gcoeff(:)%j = (c(6)*(M(25,:)%j+M(31,:)%j+M(33,:)%j-M(37,:)%j-M(38,:)%j-M(44,:)%j+M(46,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(98),h0tab(:,98),[32,1,8,2,4,16],[0,nMT,nMT,0,0,0],6,0)
  call Hloop_UV_W(ntryL,G0H64(1),0,ex6(:),32,G1H32(98),m3h2x32(:,98),heltab2x64(:,:,98))
  Gcoeff(:)%j = (c(16)*(M(25,:)%j-M(37,:)%j-M(38,:)%j+M(46,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(99),h0tab(:,99),[32,1,8,4,2,16],[0,nMT,nMT,nMT,0,0],6,0)
  call Hloop_UV_W(ntryL,G0H64(1),0,ex6(:),32,G1H32(99),m3h2x32(:,99),heltab2x64(:,:,99))
  Gcoeff(:)%j = (c(16)*(M(35,:)%j-M(40,:)%j-M(43,:)%j+M(48,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(100),h0tab(:,100),[32,1,8,4,2,16],[nMT,0,0,0,nMT,nMT],6,0)
  call Hloop_AV_Q(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,100),heltab2x64(:,:,100))
  call Hloop_A_Q(ntryL,G0H32(1),32,nMT,G1H32(100),n2h32(50))
  Gcoeff(:)%j = (c(16)*(M(31,:)%j-M(39,:)%j-M(44,:)%j+M(47,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(101),h0tab(:,101),[32,1,8,16,2,4],[0,nMT,nMT,nMT,0,0],6,0)
  call Hloop_UV_W(ntryL,G0H64(1),0,ex6(:),32,G1H32(101),m3h2x32(:,101),heltab2x64(:,:,101))
  Gcoeff(:)%j = (c(16)*(M(30,:)%j-M(41,:)%j-M(42,:)%j+M(49,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(102),h0tab(:,102),[32,1,8,16,2,4],[nMT,0,0,0,nMT,nMT],6,0)
  call Hloop_AV_Q(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,102),heltab2x64(:,:,102))
  call Hloop_A_Q(ntryL,G0H32(1),32,nMT,G1H32(102),n2h32(51))
  Gcoeff(:)%j = (c(6)*(-M(39,:)%j+M(47,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(103),h0tab(:,103),[32,1,8,16,4,2],[0,nMT,nMT,nMT,nMT,0],6,0)
  call Hloop_UV_W(ntryL,G0H64(1),0,ex6(:),32,G1H32(103),m3h2x32(:,103),heltab2x64(:,:,103))
  Gcoeff(:)%j = (c(6)*(-M(30,:)%j-M(33,:)%j-M(35,:)%j+M(41,:)%j+M(42,:)%j+M(43,:)%j-M(49,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(104),h0tab(:,104),[32,1,8,16,4,2],[nMT,0,0,0,0,nMT],6,0)
  call Hloop_AV_Q(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,104),heltab2x64(:,:,104))
  call Hloop_A_Q(ntryL,G0H32(1),32,nMT,G1H32(104),n2h32(52))
  Gcoeff(:)%j = (c(6)*(M(42,:)%j-M(49,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(105),h0tab(:,105),[32,1,8,2,16,4],[nMT,0,0,nMT,nMT,nMT],6,0)
  call Hloop_AV_Q(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,105),heltab2x64(:,:,105))
  call Hloop_A_Q(ntryL,G0H32(1),32,nMT,G1H32(105),n2h32(53))
  Gcoeff(:)%j = (c(6)*(M(25,:)%j+M(31,:)%j+M(34,:)%j-M(38,:)%j-M(39,:)%j-M(44,:)%j+M(47,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(106),h0tab(:,106),[32,1,8,2,16,4],[0,nMT,nMT,0,0,0],6,0)
  call Hloop_UV_W(ntryL,G0H64(1),0,ex6(:),32,G1H32(106),m3h2x32(:,106),heltab2x64(:,:,106))
  Gcoeff(:)%j = (c(6)*(-M(37,:)%j+M(46,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(107),h0tab(:,107),[32,1,8,4,16,2],[0,nMT,nMT,nMT,nMT,0],6,0)
  call Hloop_UV_W(ntryL,G0H64(1),0,ex6(:),32,G1H32(107),m3h2x32(:,107),heltab2x64(:,:,107))
  Gcoeff(:)%j = (c(6)*(-M(30,:)%j-M(34,:)%j-M(35,:)%j+M(40,:)%j+M(41,:)%j+M(43,:)%j-M(48,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(108),h0tab(:,108),[32,1,8,4,16,2],[nMT,0,0,0,0,nMT],6,0)
  call Hloop_AV_Q(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,108),heltab2x64(:,:,108))
  call Hloop_A_Q(ntryL,G0H32(1),32,nMT,G1H32(108),n2h32(54))
  Gcoeff(:)%j = (c(16)*(M(27,:)%j-M(39,:)%j-M(40,:)%j+M(48,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(109),h0tab(:,109),[32,1,16,4,2,8],[0,nMT,nMT,nMT,0,0],6,0)
  call Hloop_UV_W(ntryL,G0H64(1),0,ex6(:),32,G1H32(109),m3h2x32(:,109),heltab2x64(:,:,109))
  Gcoeff(:)%j = (c(16)*(M(33,:)%j-M(38,:)%j-M(44,:)%j+M(46,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(110),h0tab(:,110),[32,1,16,4,2,8],[nMT,0,0,0,nMT,nMT],6,0)
  call Hloop_AV_Q(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,110),heltab2x64(:,:,110))
  call Hloop_A_Q(ntryL,G0H32(1),32,nMT,G1H32(110),n2h32(55))
  Gcoeff(:)%j = (c(16)*(M(31,:)%j-M(37,:)%j-M(43,:)%j+M(45,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(111),h0tab(:,111),[32,1,16,8,2,4],[0,nMT,nMT,nMT,0,0],6,0)
  call Hloop_UV_W(ntryL,G0H64(1),0,ex6(:),32,G1H32(111),m3h2x32(:,111),heltab2x64(:,:,111))
  Gcoeff(:)%j = (c(16)*(M(29,:)%j-M(41,:)%j-M(42,:)%j+M(50,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(112),h0tab(:,112),[32,1,16,8,2,4],[nMT,0,0,0,nMT,nMT],6,0)
  call Hloop_AV_Q(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,112),heltab2x64(:,:,112))
  call Hloop_A_Q(ntryL,G0H32(1),32,nMT,G1H32(112),n2h32(56))
  Gcoeff(:)%j = (c(6)*(M(38,:)%j-M(46,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(113),h0tab(:,113),[32,1,16,2,4,8],[nMT,0,0,nMT,nMT,nMT],6,0)
  call Hloop_AV_Q(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,113),heltab2x64(:,:,113))
  call Hloop_A_Q(ntryL,G0H32(1),32,nMT,G1H32(113),n2h32(57))
  Gcoeff(:)%j = (c(6)*(M(27,:)%j+M(31,:)%j+M(35,:)%j-M(39,:)%j-M(40,:)%j-M(43,:)%j+M(48,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(114),h0tab(:,114),[32,1,16,2,4,8],[0,nMT,nMT,0,0,0],6,0)
  call Hloop_UV_W(ntryL,G0H64(1),0,ex6(:),32,G1H32(114),m3h2x32(:,114),heltab2x64(:,:,114))
  Gcoeff(:)%j = (c(6)*(-M(37,:)%j+M(45,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(115),h0tab(:,115),[32,1,16,8,4,2],[0,nMT,nMT,nMT,nMT,0],6,0)
  call Hloop_UV_W(ntryL,G0H64(1),0,ex6(:),32,G1H32(115),m3h2x32(:,115),heltab2x64(:,:,115))
  Gcoeff(:)%j = (c(6)*(-M(29,:)%j-M(33,:)%j-M(35,:)%j+M(41,:)%j+M(42,:)%j+M(44,:)%j-M(50,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(116),h0tab(:,116),[32,1,16,8,4,2],[nMT,0,0,0,0,nMT],6,0)
  call Hloop_AV_Q(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,116),heltab2x64(:,:,116))
  call Hloop_A_Q(ntryL,G0H32(1),32,nMT,G1H32(116),n2h32(58))
  Gcoeff(:)%j = (c(6)*(M(41,:)%j-M(50,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(117),h0tab(:,117),[32,1,16,2,8,4],[nMT,0,0,nMT,nMT,nMT],6,0)
  call Hloop_AV_Q(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,117),heltab2x64(:,:,117))
  call Hloop_A_Q(ntryL,G0H32(1),32,nMT,G1H32(117),n2h32(59))
  Gcoeff(:)%j = (c(6)*(M(27,:)%j+M(31,:)%j+M(36,:)%j-M(37,:)%j-M(40,:)%j-M(43,:)%j+M(45,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(118),h0tab(:,118),[32,1,16,2,8,4],[0,nMT,nMT,0,0,0],6,0)
  call Hloop_UV_W(ntryL,G0H64(1),0,ex6(:),32,G1H32(118),m3h2x32(:,118),heltab2x64(:,:,118))
  Gcoeff(:)%j = (c(6)*(-M(39,:)%j+M(48,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(119),h0tab(:,119),[32,1,16,4,8,2],[0,nMT,nMT,nMT,nMT,0],6,0)
  call Hloop_UV_W(ntryL,G0H64(1),0,ex6(:),32,G1H32(119),m3h2x32(:,119),heltab2x64(:,:,119))
  Gcoeff(:)%j = (c(6)*(-M(29,:)%j-M(33,:)%j-M(36,:)%j+M(38,:)%j+M(42,:)%j+M(44,:)%j-M(46,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(120),h0tab(:,120),[32,1,16,4,8,2],[nMT,0,0,0,0,nMT],6,0)
  call Hloop_AV_Q(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,120),heltab2x64(:,:,120))
  call Hloop_A_Q(ntryL,G0H32(1),32,nMT,G1H32(120),n2h32(60))
  call Hloop_QV_A(ntryL,G1H32(1),ex4(:),G1H16(1),m3h2x16(:,1),heltab2x32(:,:,1))
  call Hloop_Q_A(ntryL,G1H16(1),40,nMT,G2H16(1),n2h16(1))
  call Hloop_UV_W(ntryL,G1H32(2),32,ex4(:),8,G2H16(2),m3h2x16(:,2),heltab2x32(:,:,2))
  call Hloop_AV_Q(ntryL,G1H32(3),ex3(:),G1H16(1),m3h2x16(:,3),heltab2x32(:,:,3))
  call Hloop_A_Q(ntryL,G1H16(1),36,nMT,G2H16(3),n2h16(2))
  call Hloop_UV_W(ntryL,G1H32(4),32,ex3(:),4,G2H16(4),m3h2x16(:,4),heltab2x32(:,:,4))
  call Hloop_AV_Q(ntryL,G1H32(5),ex4(:),G1H16(1),m3h2x16(:,5),heltab2x32(:,:,5))
  call Hloop_A_Q(ntryL,G1H16(1),40,nMT,G2H16(5),n2h16(3))
  call Hloop_UV_W(ntryL,G1H32(6),32,ex4(:),8,G2H16(6),m3h2x16(:,6),heltab2x32(:,:,6))
  call Hloop_AV_Q(ntryL,G1H32(7),ex3(:),G1H16(1),m3h2x16(:,7),heltab2x32(:,:,7))
  call Hloop_A_Q(ntryL,G1H16(1),36,nMT,G2H16(7),n2h16(4))
  call Hloop_UV_W(ntryL,G1H32(8),32,ex3(:),4,G2H16(8),m3h2x16(:,8),heltab2x32(:,:,8))
  call Hloop_QA_V(ntryL,G1H32(9),ex2(:),G1H16(1),m3h2x16(:,9),heltab2x32(:,:,9))
  call Hloop_VA_Q(ntryL,G1H32(10),ex2(:),G1H16(2),m3h2x16(:,10),heltab2x32(:,:,10))
  call Hloop_A_Q(ntryL,G1H16(2),34,nMT,G2H16(9),n2h16(5))
  call Hloop_QA_V(ntryL,G1H32(11),ex2(:),G1H16(2),m3h2x16(:,11),heltab2x32(:,:,11))
  call Hloop_VA_Q(ntryL,G1H32(12),ex2(:),G1H16(3),m3h2x16(:,12),heltab2x32(:,:,12))
  call Hloop_A_Q(ntryL,G1H16(3),34,nMT,G2H16(10),n2h16(6))
  call Hloop_AV_Q(ntryL,G1H32(13),ex4(:),G1H16(3),m3h2x16(:,13),heltab2x32(:,:,13))
  call Hloop_A_Q(ntryL,G1H16(3),40,nMT,G2H16(11),n2h16(7))
  call Hloop_UV_W(ntryL,G1H32(14),32,ex4(:),8,G2H16(12),m3h2x16(:,14),heltab2x32(:,:,14))
  call Hloop_QV_A(ntryL,G1H32(15),ex3(:),G1H16(3),m3h2x16(:,15),heltab2x32(:,:,15))
  call Hloop_Q_A(ntryL,G1H16(3),36,nMT,G2H16(13),n2h16(8))
  call Hloop_UV_W(ntryL,G1H32(16),32,ex3(:),4,G2H16(14),m3h2x16(:,16),heltab2x32(:,:,16))
  call Hloop_AV_Q(ntryL,G1H32(17),ex3(:),G1H16(3),m3h2x16(:,17),heltab2x32(:,:,17))
  call Hloop_A_Q(ntryL,G1H16(3),36,nMT,G2H16(15),n2h16(9))
  call Hloop_UV_W(ntryL,G1H32(18),32,ex3(:),4,G2H16(16),m3h2x16(:,18),heltab2x32(:,:,18))
  call Hloop_QV_A(ntryL,G1H32(19),ex3(:),G1H16(3),m3h2x16(:,19),heltab2x32(:,:,19))
  call Hloop_Q_A(ntryL,G1H16(3),36,nMT,G2H16(17),n2h16(10))
  call Hloop_UV_W(ntryL,G1H32(20),32,ex3(:),4,G2H16(18),m3h2x16(:,20),heltab2x32(:,:,20))
  call Hloop_QA_V(ntryL,G1H32(21),ex2(:),G1H16(3),m3h2x16(:,21),heltab2x32(:,:,21))
  call Hloop_VA_Q(ntryL,G1H32(22),ex2(:),G1H16(4),m3h2x16(:,22),heltab2x32(:,:,22))
  call Hloop_A_Q(ntryL,G1H16(4),34,nMT,G2H16(19),n2h16(11))
  call Hloop_QA_V(ntryL,G1H32(23),ex2(:),G1H16(4),m3h2x16(:,23),heltab2x32(:,:,23))
  call Hloop_VA_Q(ntryL,G1H32(24),ex2(:),G1H16(5),m3h2x16(:,24),heltab2x32(:,:,24))
  call Hloop_A_Q(ntryL,G1H16(5),34,nMT,G2H16(20),n2h16(12))
  call Hloop_QV_A(ntryL,G1H32(25),ex4(:),G1H16(5),m3h2x16(:,25),heltab2x32(:,:,25))
  call Hloop_Q_A(ntryL,G1H16(5),40,nMT,G2H16(21),n2h16(13))
  call Hloop_UV_W(ntryL,G1H32(26),32,ex4(:),8,G2H16(22),m3h2x16(:,26),heltab2x32(:,:,26))
  call Hloop_QV_A(ntryL,G1H32(27),ex3(:),G1H16(5),m3h2x16(:,27),heltab2x32(:,:,27))
  call Hloop_Q_A(ntryL,G1H16(5),36,nMT,G2H16(23),n2h16(14))
  call Hloop_UV_W(ntryL,G1H32(28),32,ex3(:),4,G2H16(24),m3h2x16(:,28),heltab2x32(:,:,28))
  call Hloop_QV_A(ntryL,G1H32(29),ex3(:),G1H16(5),m3h2x16(:,29),heltab2x32(:,:,29))
  call Hloop_Q_A(ntryL,G1H16(5),36,nMT,G2H16(25),n2h16(15))
  call Hloop_UV_W(ntryL,G1H32(30),32,ex3(:),4,G2H16(26),m3h2x16(:,30),heltab2x32(:,:,30))
  call Hloop_AV_Q(ntryL,G1H32(31),ex3(:),G1H16(5),m3h2x16(:,31),heltab2x32(:,:,31))
  call Hloop_A_Q(ntryL,G1H16(5),36,nMT,G2H16(27),n2h16(16))
  call Hloop_UV_W(ntryL,G1H32(32),32,ex3(:),4,G2H16(28),m3h2x16(:,32),heltab2x32(:,:,32))
  call Hloop_QA_V(ntryL,G1H32(33),ex2(:),G1H16(5),m3h2x16(:,33),heltab2x32(:,:,33))
  call Hloop_VA_Q(ntryL,G1H32(34),ex2(:),G1H16(6),m3h2x16(:,34),heltab2x32(:,:,34))
  call Hloop_A_Q(ntryL,G1H16(6),34,nMT,G2H16(29),n2h16(17))
  call Hloop_QA_V(ntryL,G1H32(35),ex2(:),G1H16(6),m3h2x16(:,35),heltab2x32(:,:,35))
  call Hloop_VA_Q(ntryL,G1H32(36),ex2(:),G1H16(7),m3h2x16(:,36),heltab2x32(:,:,36))
  call Hloop_A_Q(ntryL,G1H16(7),34,nMT,G2H16(30),n2h16(18))
  call Hloop_AQ_V(ntryL,G1H32(37),ex1(:),G1H16(7),m3h2x16(:,37),heltab2x32(:,:,37))
  call Hloop_VQ_A(ntryL,G1H32(38),ex1(:),G1H16(8),m3h2x16(:,38),heltab2x32(:,:,38))
  call Hloop_Q_A(ntryL,G1H16(8),33,nMT,G2H16(31),n2h16(19))
  call Hloop_AQ_V(ntryL,G1H32(39),ex1(:),G1H16(8),m3h2x16(:,39),heltab2x32(:,:,39))
  call Hloop_VQ_A(ntryL,G1H32(40),ex1(:),G1H16(9),m3h2x16(:,40),heltab2x32(:,:,40))
  call Hloop_Q_A(ntryL,G1H16(9),33,nMT,G2H16(32),n2h16(20))
  call Hloop_AQ_V(ntryL,G1H32(41),ex1(:),G1H16(9),m3h2x16(:,41),heltab2x32(:,:,41))
  call Hloop_VQ_A(ntryL,G1H32(42),ex1(:),G1H16(10),m3h2x16(:,42),heltab2x32(:,:,42))
  call Hloop_Q_A(ntryL,G1H16(10),33,nMT,G2H16(33),n2h16(21))
  call Hloop_AQ_V(ntryL,G1H32(43),ex1(:),G1H16(10),m3h2x16(:,43),heltab2x32(:,:,43))
  call Hloop_VQ_A(ntryL,G1H32(44),ex1(:),G1H16(11),m3h2x16(:,44),heltab2x32(:,:,44))
  call Hloop_Q_A(ntryL,G1H16(11),33,nMT,G2H16(34),n2h16(22))
  call Hloop_AQ_V(ntryL,G1H32(45),ex1(:),G1H16(11),m3h2x16(:,45),heltab2x32(:,:,45))
  call Hloop_VQ_A(ntryL,G1H32(46),ex1(:),G1H16(12),m3h2x16(:,46),heltab2x32(:,:,46))
  call Hloop_Q_A(ntryL,G1H16(12),33,nMT,G2H16(35),n2h16(23))
  call Hloop_AQ_V(ntryL,G1H32(47),ex1(:),G1H16(12),m3h2x16(:,47),heltab2x32(:,:,47))
  call Hloop_VQ_A(ntryL,G1H32(48),ex1(:),G1H16(13),m3h2x16(:,48),heltab2x32(:,:,48))
  call Hloop_Q_A(ntryL,G1H16(13),33,nMT,G2H16(36),n2h16(24))
  call Hloop_AV_Q(ntryL,G1H32(49),ex4(:),G1H16(13),m3h2x16(:,49),heltab2x32(:,:,49))
  call Hloop_A_Q(ntryL,G1H16(13),40,nMT,G2H16(37),n2h16(25))
  call Hloop_UV_W(ntryL,G1H32(50),32,ex4(:),8,G2H16(38),m3h2x16(:,50),heltab2x32(:,:,50))
  call Hloop_QA_V(ntryL,G1H32(51),ex2(:),G1H16(13),m3h2x16(:,51),heltab2x32(:,:,51))
  call Hloop_VA_Q(ntryL,G1H32(52),ex2(:),G1H16(14),m3h2x16(:,52),heltab2x32(:,:,52))
  call Hloop_A_Q(ntryL,G1H16(14),34,nMT,G2H16(39),n2h16(26))
  call Hloop_AV_Q(ntryL,G1H32(53),ex3(:),G1H16(14),m3h2x16(:,53),heltab2x32(:,:,53))
  call Hloop_A_Q(ntryL,G1H16(14),36,nMT,G2H16(40),n2h16(27))
  call Hloop_UV_W(ntryL,G1H32(54),32,ex3(:),4,G2H16(41),m3h2x16(:,54),heltab2x32(:,:,54))
  call Hloop_QA_V(ntryL,G1H32(55),ex2(:),G1H16(14),m3h2x16(:,55),heltab2x32(:,:,55))
  call Hloop_VA_Q(ntryL,G1H32(56),ex2(:),G1H16(15),m3h2x16(:,56),heltab2x32(:,:,56))
  call Hloop_A_Q(ntryL,G1H16(15),34,nMT,G2H16(42),n2h16(28))
  call Hloop_VA_Q(ntryL,G1H32(57),ex2(:),G1H16(15),m3h2x16(:,57),heltab2x32(:,:,57))
  call Hloop_A_Q(ntryL,G1H16(15),34,nMT,G2H16(43),n2h16(29))
  call Hloop_QA_V(ntryL,G1H32(58),ex2(:),G1H16(15),m3h2x16(:,58),heltab2x32(:,:,58))
  call Hloop_QA_V(ntryL,G1H32(59),ex2(:),G1H16(16),m3h2x16(:,59),heltab2x32(:,:,59))
  call Hloop_VA_Q(ntryL,G1H32(60),ex2(:),G1H16(17),m3h2x16(:,60),heltab2x32(:,:,60))
  call Hloop_A_Q(ntryL,G1H16(17),34,nMT,G2H16(44),n2h16(30))
  call Hloop_QV_A(ntryL,G1H32(61),ex4(:),G1H16(17),m3h2x16(:,61),heltab2x32(:,:,61))
  call Hloop_Q_A(ntryL,G1H16(17),40,nMT,G2H16(45),n2h16(31))
  call Hloop_UV_W(ntryL,G1H32(62),32,ex4(:),8,G2H16(46),m3h2x16(:,62),heltab2x32(:,:,62))
  call Hloop_QA_V(ntryL,G1H32(63),ex2(:),G1H16(17),m3h2x16(:,63),heltab2x32(:,:,63))
  call Hloop_VA_Q(ntryL,G1H32(64),ex2(:),G1H16(18),m3h2x16(:,64),heltab2x32(:,:,64))
  call Hloop_A_Q(ntryL,G1H16(18),34,nMT,G2H16(47),n2h16(32))
  call Hloop_AV_Q(ntryL,G1H32(65),ex3(:),G1H16(18),m3h2x16(:,65),heltab2x32(:,:,65))
  call Hloop_A_Q(ntryL,G1H16(18),36,nMT,G2H16(48),n2h16(33))
  call Hloop_UV_W(ntryL,G1H32(66),32,ex3(:),4,G2H16(49),m3h2x16(:,66),heltab2x32(:,:,66))
  call Hloop_VA_Q(ntryL,G1H32(67),ex2(:),G1H16(18),m3h2x16(:,67),heltab2x32(:,:,67))
  call Hloop_A_Q(ntryL,G1H16(18),34,nMT,G2H16(50),n2h16(34))
  call Hloop_QA_V(ntryL,G1H32(68),ex2(:),G1H16(18),m3h2x16(:,68),heltab2x32(:,:,68))
  call Hloop_QA_V(ntryL,G1H32(69),ex2(:),G1H16(19),m3h2x16(:,69),heltab2x32(:,:,69))
  call Hloop_VA_Q(ntryL,G1H32(70),ex2(:),G1H16(20),m3h2x16(:,70),heltab2x32(:,:,70))
  call Hloop_A_Q(ntryL,G1H16(20),34,nMT,G2H16(51),n2h16(35))
  call Hloop_QA_V(ntryL,G1H32(71),ex2(:),G1H16(20),m3h2x16(:,71),heltab2x32(:,:,71))
  call Hloop_VA_Q(ntryL,G1H32(72),ex2(:),G1H16(21),m3h2x16(:,72),heltab2x32(:,:,72))
  call Hloop_A_Q(ntryL,G1H16(21),34,nMT,G2H16(52),n2h16(36))
  call Hloop_AQ_V(ntryL,G1H32(73),ex1(:),G1H16(21),m3h2x16(:,73),heltab2x32(:,:,73))
  call Hloop_VQ_A(ntryL,G1H32(74),ex1(:),G1H16(22),m3h2x16(:,74),heltab2x32(:,:,74))
  call Hloop_Q_A(ntryL,G1H16(22),33,nMT,G2H16(53),n2h16(37))
  call Hloop_AQ_V(ntryL,G1H32(75),ex1(:),G1H16(22),m3h2x16(:,75),heltab2x32(:,:,75))
  call Hloop_VQ_A(ntryL,G1H32(76),ex1(:),G1H16(23),m3h2x16(:,76),heltab2x32(:,:,76))
  call Hloop_Q_A(ntryL,G1H16(23),33,nMT,G2H16(54),n2h16(38))
  call Hloop_VQ_A(ntryL,G1H32(77),ex1(:),G1H16(23),m3h2x16(:,77),heltab2x32(:,:,77))
  call Hloop_Q_A(ntryL,G1H16(23),33,nMT,G2H16(55),n2h16(39))
  call Hloop_AQ_V(ntryL,G1H32(78),ex1(:),G1H16(23),m3h2x16(:,78),heltab2x32(:,:,78))
  call Hloop_VQ_A(ntryL,G1H32(79),ex1(:),G1H16(24),m3h2x16(:,79),heltab2x32(:,:,79))
  call Hloop_Q_A(ntryL,G1H16(24),33,nMT,G2H16(56),n2h16(40))
  call Hloop_AQ_V(ntryL,G1H32(80),ex1(:),G1H16(24),m3h2x16(:,80),heltab2x32(:,:,80))
  call Hloop_VQ_A(ntryL,G1H32(81),ex1(:),G1H16(25),m3h2x16(:,81),heltab2x32(:,:,81))
  call Hloop_Q_A(ntryL,G1H16(25),33,nMT,G2H16(57),n2h16(41))
  call Hloop_AQ_V(ntryL,G1H32(82),ex1(:),G1H16(25),m3h2x16(:,82),heltab2x32(:,:,82))
  call Hloop_VQ_A(ntryL,G1H32(83),ex1(:),G1H16(26),m3h2x16(:,83),heltab2x32(:,:,83))
  call Hloop_Q_A(ntryL,G1H16(26),33,nMT,G2H16(58),n2h16(42))
  call Hloop_AQ_V(ntryL,G1H32(84),ex1(:),G1H16(26),m3h2x16(:,84),heltab2x32(:,:,84))
  call Hloop_QV_A(ntryL,G1H32(85),ex3(:),G1H16(27),m3h2x16(:,85),heltab2x32(:,:,85))
  call Hloop_Q_A(ntryL,G1H16(27),36,nMT,G2H16(59),n2h16(43))
  call Hloop_UV_W(ntryL,G1H32(86),32,ex3(:),4,G2H16(60),m3h2x16(:,86),heltab2x32(:,:,86))
  call Hloop_QV_A(ntryL,G1H32(87),ex3(:),G1H16(27),m3h2x16(:,87),heltab2x32(:,:,87))
  call Hloop_Q_A(ntryL,G1H16(27),36,nMT,G2H16(61),n2h16(44))
  call Hloop_UV_W(ntryL,G1H32(88),32,ex3(:),4,G2H16(62),m3h2x16(:,88),heltab2x32(:,:,88))
  call Hloop_VA_Q(ntryL,G1H32(89),ex2(:),G1H16(27),m3h2x16(:,89),heltab2x32(:,:,89))
  call Hloop_A_Q(ntryL,G1H16(27),34,nMT,G2H16(63),n2h16(45))
  call Hloop_QA_V(ntryL,G1H32(90),ex2(:),G1H16(27),m3h2x16(:,90),heltab2x32(:,:,90))
  call Hloop_QA_V(ntryL,G1H32(91),ex2(:),G1H16(28),m3h2x16(:,91),heltab2x32(:,:,91))
  call Hloop_VA_Q(ntryL,G1H32(92),ex2(:),G1H16(29),m3h2x16(:,92),heltab2x32(:,:,92))
  call Hloop_A_Q(ntryL,G1H16(29),34,nMT,G2H16(64),n2h16(46))
  call Hloop_QA_V(ntryL,G1H32(93),ex2(:),G1H16(29),m3h2x16(:,93),heltab2x32(:,:,93))
  call Hloop_VA_Q(ntryL,G1H32(94),ex2(:),G1H16(30),m3h2x16(:,94),heltab2x32(:,:,94))
  call Hloop_A_Q(ntryL,G1H16(30),34,nMT,G2H16(65),n2h16(47))
  call Hloop_QA_V(ntryL,G1H32(95),ex2(:),G1H16(30),m3h2x16(:,95),heltab2x32(:,:,95))
  call Hloop_VA_Q(ntryL,G1H32(96),ex2(:),G1H16(31),m3h2x16(:,96),heltab2x32(:,:,96))
  call Hloop_A_Q(ntryL,G1H16(31),34,nMT,G2H16(66),n2h16(48))
  call Hloop_AQ_V(ntryL,G1H32(97),ex1(:),G1H16(31),m3h2x16(:,97),heltab2x32(:,:,97))
  call Hloop_VQ_A(ntryL,G1H32(98),ex1(:),G1H16(32),m3h2x16(:,98),heltab2x32(:,:,98))
  call Hloop_Q_A(ntryL,G1H16(32),33,nMT,G2H16(67),n2h16(49))
  call Hloop_VQ_A(ntryL,G1H32(99),ex1(:),G1H16(32),m3h2x16(:,99),heltab2x32(:,:,99))
  call Hloop_Q_A(ntryL,G1H16(32),33,nMT,G2H16(68),n2h16(50))
  call Hloop_AQ_V(ntryL,G1H32(100),ex1(:),G1H16(32),m3h2x16(:,100),heltab2x32(:,:,100))
  call Hloop_VQ_A(ntryL,G1H32(101),ex1(:),G1H16(33),m3h2x16(:,101),heltab2x32(:,:,101))
  call Hloop_Q_A(ntryL,G1H16(33),33,nMT,G2H16(69),n2h16(51))
  call Hloop_AQ_V(ntryL,G1H32(102),ex1(:),G1H16(33),m3h2x16(:,102),heltab2x32(:,:,102))
  call Hloop_VQ_A(ntryL,G1H32(103),ex1(:),G1H16(34),m3h2x16(:,103),heltab2x32(:,:,103))
  call Hloop_Q_A(ntryL,G1H16(34),33,nMT,G2H16(70),n2h16(52))
  call Hloop_AQ_V(ntryL,G1H32(104),ex1(:),G1H16(34),m3h2x16(:,104),heltab2x32(:,:,104))
  call Hloop_AQ_V(ntryL,G1H32(105),ex1(:),G1H16(35),m3h2x16(:,105),heltab2x32(:,:,105))
  call Hloop_VQ_A(ntryL,G1H32(106),ex1(:),G1H16(36),m3h2x16(:,106),heltab2x32(:,:,106))
  call Hloop_Q_A(ntryL,G1H16(36),33,nMT,G2H16(71),n2h16(53))
  call Hloop_VQ_A(ntryL,G1H32(107),ex1(:),G1H16(36),m3h2x16(:,107),heltab2x32(:,:,107))
  call Hloop_Q_A(ntryL,G1H16(36),33,nMT,G2H16(72),n2h16(54))
  call Hloop_AQ_V(ntryL,G1H32(108),ex1(:),G1H16(36),m3h2x16(:,108),heltab2x32(:,:,108))
  call Hloop_VQ_A(ntryL,G1H32(109),ex1(:),G1H16(37),m3h2x16(:,109),heltab2x32(:,:,109))
  call Hloop_Q_A(ntryL,G1H16(37),33,nMT,G2H16(73),n2h16(55))
  call Hloop_AQ_V(ntryL,G1H32(110),ex1(:),G1H16(37),m3h2x16(:,110),heltab2x32(:,:,110))
  call Hloop_VQ_A(ntryL,G1H32(111),ex1(:),G1H16(38),m3h2x16(:,111),heltab2x32(:,:,111))
  call Hloop_Q_A(ntryL,G1H16(38),33,nMT,G2H16(74),n2h16(56))
  call Hloop_AQ_V(ntryL,G1H32(112),ex1(:),G1H16(38),m3h2x16(:,112),heltab2x32(:,:,112))
  call Hloop_AQ_V(ntryL,G1H32(113),ex1(:),G1H16(39),m3h2x16(:,113),heltab2x32(:,:,113))
  call Hloop_VQ_A(ntryL,G1H32(114),ex1(:),G1H16(40),m3h2x16(:,114),heltab2x32(:,:,114))
  call Hloop_Q_A(ntryL,G1H16(40),33,nMT,G2H16(75),n2h16(57))
  call Hloop_VQ_A(ntryL,G1H32(115),ex1(:),G1H16(40),m3h2x16(:,115),heltab2x32(:,:,115))
  call Hloop_Q_A(ntryL,G1H16(40),33,nMT,G2H16(76),n2h16(58))
  call Hloop_AQ_V(ntryL,G1H32(116),ex1(:),G1H16(40),m3h2x16(:,116),heltab2x32(:,:,116))
  call Hloop_AQ_V(ntryL,G1H32(117),ex1(:),G1H16(41),m3h2x16(:,117),heltab2x32(:,:,117))
  call Hloop_VQ_A(ntryL,G1H32(118),ex1(:),G1H16(42),m3h2x16(:,118),heltab2x32(:,:,118))
  call Hloop_Q_A(ntryL,G1H16(42),33,nMT,G2H16(77),n2h16(59))
  call Hloop_VQ_A(ntryL,G1H32(119),ex1(:),G1H16(42),m3h2x16(:,119),heltab2x32(:,:,119))
  call Hloop_Q_A(ntryL,G1H16(42),33,nMT,G2H16(78),n2h16(60))
  call Hloop_AQ_V(ntryL,G1H32(120),ex1(:),G1H16(42),m3h2x16(:,120),heltab2x32(:,:,120))
  call Hloop_QA_V(ntryL,G2H16(1),ex2(:),G2H8(1),m3h2x8(:,1),heltab2x16(:,:,1))
  call Hotf_5pt_reduction(G2H16(2),RedSet_5(1),mass5set(:,1),  & 
G1H16(43),G1H16(44),G1H16(45),G1H16(46),G1H16(47),G1H16(48),16)
  call HG1shiftOLR(G1H16(44),16,16)
  call Hloop_AQ_V(ntryL,G2H16(3),ex1(:),G2H8(2),m3h2x8(:,2),heltab2x16(:,:,2))
  call Hotf_5pt_reduction(G2H16(4),RedSet_5(2),mass5set(:,1),  & 
G1H16(49),G1H16(50),G1H16(51),G1H16(52),G1H16(53),G1H16(54),16)
  call HG1shiftOLR(G1H16(50),16,16)
  call Hotf_5pt_reduction(G2H16(5),RedSet_5(3),mass5set(:,2),  & 
G1H16(55),G1H16(56),G1H16(57),G1H16(58),G1H16(59),G1H16(60),16)
  call HG1shiftOLR(G1H16(56),16,16)
  call Hotf_5pt_reduction(G2H16(6),RedSet_5(3),mass5set(:,3),  & 
G1H16(61),G1H16(62),G1H16(63),G1H16(64),G1H16(65),G1H16(66),16)
  call HG1shiftOLR(G1H16(62),16,16)
  call Hloop_AQ_V(ntryL,G2H16(7),ex1(:),G2H8(3),m3h2x8(:,3),heltab2x16(:,:,3))
  call Hotf_5pt_reduction(G2H16(8),RedSet_5(2),mass5set(:,1),  & 
G1H16(67),G1H16(68),G1H16(69),G1H16(70),G1H16(71),G1H16(72),16)
  call HG1shiftOLR(G1H16(68),8,16)
  call Hloop_VQ_A(ntryL,G1H16(1),ex1(:),G1H8(1),m3h2x8(:,4),heltab2x16(:,:,4))
  call Hloop_Q_A(ntryL,G1H8(1),35,nMT,G2H8(4),n2h8(1))
  call Hloop_AQ_V(ntryL,G2H16(9),ex1(:),G2H8(5),m3h2x8(:,5),heltab2x16(:,:,5))
  call Hloop_VQ_A(ntryL,G1H16(2),ex1(:),G1H8(1),m3h2x8(:,6),heltab2x16(:,:,6))
  call Hloop_Q_A(ntryL,G1H8(1),35,nMT,G2H8(6),n2h8(2))
  call Hloop_AQ_V(ntryL,G2H16(10),ex1(:),G2H8(7),m3h2x8(:,7),heltab2x16(:,:,7))
  call Hloop_AQ_V(ntryL,G2H16(11),ex1(:),G2H8(8),m3h2x8(:,8),heltab2x16(:,:,8))
  call Hotf_5pt_reduction(G2H16(12),RedSet_5(4),mass5set(:,1),  & 
G1H16(1),G1H16(2),G1H16(73),G1H16(74),G1H16(75),G1H16(76),16)
  call HG1shiftOLR(G1H16(2),16,16)
  call Hloop_QA_V(ntryL,G2H16(13),ex2(:),G2H8(9),m3h2x8(:,9),heltab2x16(:,:,9))
  call Hotf_5pt_reduction(G2H16(14),RedSet_5(5),mass5set(:,1),  & 
G1H16(77),G1H16(78),G1H16(79),G1H16(80),G1H16(81),G1H16(82),16)
  call HG1shiftOLR(G1H16(78),16,16)
  call Hotf_5pt_reduction(G2H16(15),RedSet_5(6),mass5set(:,2),  & 
G1H16(83),G1H16(84),G1H16(85),G1H16(86),G1H16(87),G1H16(88),16)
  call HG1shiftOLR(G1H16(84),16,16)
  call Hotf_5pt_reduction(G2H16(16),RedSet_5(6),mass5set(:,3),  & 
G1H16(89),G1H16(90),G1H16(91),G1H16(92),G1H16(93),G1H16(94),16)
  call HG1shiftOLR(G1H16(90),16,16)
  call Hotf_5pt_reduction(G2H16(17),RedSet_5(7),mass5set(:,2),  & 
G1H16(95),G1H16(96),G1H16(97),G1H16(98),G1H16(99),G1H16(100),16)
  call HG1shiftOLR(G1H16(96),8,16)
  call Hotf_5pt_reduction(G2H16(18),RedSet_5(7),mass5set(:,3),  & 
G1H16(101),G1H16(102),G1H16(103),G1H16(104),G1H16(105),G1H16(106),16)
  call HG1shiftOLR(G1H16(102),8,16)
  call Hloop_VQ_A(ntryL,G1H16(3),ex1(:),G1H8(1),m3h2x8(:,10),heltab2x16(:,:,10))
  call Hloop_Q_A(ntryL,G1H8(1),35,nMT,G2H8(10),n2h8(3))
  call Hloop_AQ_V(ntryL,G2H16(19),ex1(:),G2H8(11),m3h2x8(:,11),heltab2x16(:,:,11))
  call Hloop_VQ_A(ntryL,G1H16(4),ex1(:),G1H8(1),m3h2x8(:,12),heltab2x16(:,:,12))
  call Hloop_Q_A(ntryL,G1H8(1),35,nMT,G2H8(12),n2h8(4))
  call Hloop_AQ_V(ntryL,G2H16(20),ex1(:),G2H8(13),m3h2x8(:,13),heltab2x16(:,:,13))
  call Hotf_5pt_reduction(G2H16(21),RedSet_5(8),mass5set(:,2),  & 
G1H16(3),G1H16(4),G1H16(107),G1H16(108),G1H16(109),G1H16(110),16)
  call HG1shiftOLR(G1H16(4),16,16)
  call Hotf_5pt_reduction(G2H16(22),RedSet_5(8),mass5set(:,3),  & 
G1H16(111),G1H16(112),G1H16(113),G1H16(114),G1H16(115),G1H16(116),16)
  call HG1shiftOLR(G1H16(112),16,16)
  call Hloop_QA_V(ntryL,G2H16(23),ex2(:),G2H8(14),m3h2x8(:,14),heltab2x16(:,:,14))
  call Hotf_5pt_reduction(G2H16(24),RedSet_5(5),mass5set(:,1),  & 
G1H16(117),G1H16(118),G1H16(119),G1H16(120),G1H16(121),G1H16(122),16)
  call HG1shiftOLR(G1H16(118),8,16)
  call Hotf_5pt_reduction(G2H16(25),RedSet_5(9),mass5set(:,2),  & 
G1H16(123),G1H16(124),G1H16(125),G1H16(126),G1H16(127),G1H16(128),16)
  call HG1shiftOLR(G1H16(124),16,16)
  call Hotf_5pt_reduction(G2H16(26),RedSet_5(9),mass5set(:,3),  & 
G1H16(129),G1H16(130),G1H16(131),G1H16(132),G1H16(133),G1H16(134),16)
  call HG1shiftOLR(G1H16(130),16,16)
  call Hotf_5pt_reduction(G2H16(27),RedSet_5(10),mass5set(:,2),  & 
G1H16(135),G1H16(136),G1H16(137),G1H16(138),G1H16(139),G1H16(140),16)
  call HG1shiftOLR(G1H16(136),8,16)
  call Hotf_5pt_reduction(G2H16(28),RedSet_5(10),mass5set(:,3),  & 
G1H16(141),G1H16(142),G1H16(143),G1H16(144),G1H16(145),G1H16(146),16)
  call HG1shiftOLR(G1H16(142),8,16)
  call Hloop_VQ_A(ntryL,G1H16(5),ex1(:),G1H8(1),m3h2x8(:,15),heltab2x16(:,:,15))
  call Hloop_Q_A(ntryL,G1H8(1),35,nMT,G2H8(15),n2h8(5))
  call Hloop_AQ_V(ntryL,G2H16(29),ex1(:),G2H8(16),m3h2x8(:,16),heltab2x16(:,:,16))
  call Hloop_VQ_A(ntryL,G1H16(6),ex1(:),G1H8(1),m3h2x8(:,17),heltab2x16(:,:,17))
  call Hloop_Q_A(ntryL,G1H8(1),35,nMT,G2H8(17),n2h8(6))
  call Hloop_AQ_V(ntryL,G2H16(30),ex1(:),G2H8(18),m3h2x8(:,18),heltab2x16(:,:,18))
  call Hloop_VA_Q(ntryL,G1H16(7),ex2(:),G1H8(1),m3h2x8(:,19),heltab2x16(:,:,19))
  call Hloop_A_Q(ntryL,G1H8(1),35,nMT,G2H8(19),n2h8(7))
  call Hloop_QA_V(ntryL,G2H16(31),ex2(:),G2H8(20),m3h2x8(:,20),heltab2x16(:,:,20))
  call Hloop_VA_Q(ntryL,G1H16(8),ex2(:),G1H8(1),m3h2x8(:,21),heltab2x16(:,:,21))
  call Hloop_A_Q(ntryL,G1H8(1),35,nMT,G2H8(21),n2h8(8))
  call Hloop_QA_V(ntryL,G2H16(32),ex2(:),G2H8(22),m3h2x8(:,22),heltab2x16(:,:,22))
  call Hloop_VA_Q(ntryL,G1H16(9),ex2(:),G1H8(1),m3h2x8(:,23),heltab2x16(:,:,23))
  call Hloop_A_Q(ntryL,G1H8(1),35,nMT,G2H8(23),n2h8(9))
  call Hloop_QA_V(ntryL,G2H16(33),ex2(:),G2H8(24),m3h2x8(:,24),heltab2x16(:,:,24))
  call Hloop_VA_Q(ntryL,G1H16(10),ex2(:),G1H8(1),m3h2x8(:,25),heltab2x16(:,:,25))
  call Hloop_A_Q(ntryL,G1H8(1),35,nMT,G2H8(25),n2h8(10))
  call Hloop_QA_V(ntryL,G2H16(34),ex2(:),G2H8(26),m3h2x8(:,26),heltab2x16(:,:,26))
  call Hloop_VA_Q(ntryL,G1H16(11),ex2(:),G1H8(1),m3h2x8(:,27),heltab2x16(:,:,27))
  call Hloop_A_Q(ntryL,G1H8(1),35,nMT,G2H8(27),n2h8(11))
  call Hloop_QA_V(ntryL,G2H16(35),ex2(:),G2H8(28),m3h2x8(:,28),heltab2x16(:,:,28))
  call Hloop_VA_Q(ntryL,G1H16(12),ex2(:),G1H8(1),m3h2x8(:,29),heltab2x16(:,:,29))
  call Hloop_A_Q(ntryL,G1H8(1),35,nMT,G2H8(29),n2h8(12))
  call Hloop_QA_V(ntryL,G2H16(36),ex2(:),G2H8(30),m3h2x8(:,30),heltab2x16(:,:,30))
  call Hloop_AQ_V(ntryL,G2H16(37),ex1(:),G2H8(31),m3h2x8(:,31),heltab2x16(:,:,31))
  call Hotf_5pt_reduction(G2H16(38),RedSet_5(11),mass5set(:,4),  & 
G1H16(5),G1H16(6),G1H16(7),G1H16(8),G1H16(9),G1H16(10),16)
  call HG1shiftOLR(G1H16(6),16,16)
  call Hloop_UV_W(ntryL,G1H16(13),34,ex3(:),4,G2H8(32),m3h2x8(:,32),heltab2x16(:,:,32))
  call Hotf_5pt_reduction(G2H16(39),RedSet_5(12),mass5set(:,5),  & 
G1H16(11),G1H16(12),G1H16(13),G1H16(147),G1H16(148),G1H16(149),16)
  call HG1shiftOLR(G1H16(12),16,16)
  call Hloop_AQ_V(ntryL,G2H16(40),ex1(:),G2H8(33),m3h2x8(:,33),heltab2x16(:,:,33))
  call Hotf_5pt_reduction(G2H16(41),RedSet_5(13),mass5set(:,4),  & 
G1H16(150),G1H16(151),G1H16(152),G1H16(153),G1H16(154),G1H16(155),16)
  call HG1shiftOLR(G1H16(151),16,16)
  call Hloop_UV_W(ntryL,G1H16(14),34,ex4(:),8,G2H8(34),m3h2x8(:,34),heltab2x16(:,:,34))
  call Hotf_5pt_reduction(G2H16(42),RedSet_5(14),mass5set(:,5),  & 
G1H16(14),G1H16(156),G1H16(157),G1H16(158),G1H16(159),G1H16(160),16)
  call HG1shiftOLR(G1H16(156),16,16)
  call Hotf_5pt_reduction(G2H16(43),RedSet_5(15),mass5set(:,6),  & 
G1H16(161),G1H16(162),G1H16(163),G1H16(164),G1H16(165),G1H16(166),16)
  call HG1shiftOLR(G1H16(162),8,16)
  call Hloop_UV_W(ntryL,G1H16(15),34,ex5(:),16,G2H8(35),m3h2x8(:,35),heltab2x16(:,:,35))
  call Hloop_UV_W(ntryL,G1H16(16),34,ex5(:),16,G2H8(36),m3h2x8(:,36),heltab2x16(:,:,36))
  call Hotf_5pt_reduction(G2H16(44),RedSet_5(16),mass5set(:,6),  & 
G1H16(15),G1H16(16),G1H16(167),G1H16(168),G1H16(169),G1H16(170),16)
  call HG1shiftOLR(G1H16(16),4,16)
  call Hloop_QA_V(ntryL,G2H16(45),ex2(:),G2H8(37),m3h2x8(:,37),heltab2x16(:,:,37))
  call Hotf_5pt_reduction(G2H16(46),RedSet_5(17),mass5set(:,4),  & 
G1H16(171),G1H16(172),G1H16(173),G1H16(174),G1H16(175),G1H16(176),16)
  call HG1shiftOLR(G1H16(172),16,16)
  call Hloop_UV_W(ntryL,G1H16(17),34,ex3(:),4,G2H8(38),m3h2x8(:,38),heltab2x16(:,:,38))
  call Hotf_5pt_reduction(G2H16(47),RedSet_5(12),mass5set(:,5),  & 
G1H16(17),G1H16(177),G1H16(178),G1H16(179),G1H16(180),G1H16(181),16)
  call HG1shiftOLR(G1H16(177),8,16)
  call Hloop_AQ_V(ntryL,G2H16(48),ex1(:),G2H8(39),m3h2x8(:,39),heltab2x16(:,:,39))
  call Hotf_5pt_reduction(G2H16(49),RedSet_5(18),mass5set(:,4),  & 
G1H16(182),G1H16(183),G1H16(184),G1H16(185),G1H16(186),G1H16(187),16)
  call HG1shiftOLR(G1H16(183),8,16)
  call Hotf_5pt_reduction(G2H16(50),RedSet_5(19),mass5set(:,6),  & 
G1H16(188),G1H16(189),G1H16(190),G1H16(191),G1H16(192),G1H16(193),16)
  call HG1shiftOLR(G1H16(189),16,16)
  call Hloop_UV_W(ntryL,G1H16(18),34,ex4(:),8,G2H8(40),m3h2x8(:,40),heltab2x16(:,:,40))
  call Hloop_UV_W(ntryL,G1H16(19),34,ex4(:),8,G2H8(41),m3h2x8(:,41),heltab2x16(:,:,41))
  call Hotf_5pt_reduction(G2H16(51),RedSet_5(20),mass5set(:,6),  & 
G1H16(18),G1H16(19),G1H16(194),G1H16(195),G1H16(196),G1H16(197),16)
  call HG1shiftOLR(G1H16(19),4,16)
  call Hloop_UV_W(ntryL,G1H16(20),34,ex5(:),16,G2H8(42),m3h2x8(:,42),heltab2x16(:,:,42))
  call Hotf_5pt_reduction(G2H16(52),RedSet_5(21),mass5set(:,5),  & 
G1H16(20),G1H16(198),G1H16(199),G1H16(200),G1H16(201),G1H16(202),16)
  call HG1shiftOLR(G1H16(198),8,16)
  call Hloop_UV_W(ntryL,G1H16(21),33,ex3(:),4,G2H8(43),m3h2x8(:,43),heltab2x16(:,:,43))
  call Hotf_5pt_reduction(G2H16(53),RedSet_5(22),mass5set(:,5),  & 
G1H16(21),G1H16(203),G1H16(204),G1H16(205),G1H16(206),G1H16(207),16)
  call HG1shiftOLR(G1H16(203),16,16)
  call Hloop_UV_W(ntryL,G1H16(22),33,ex3(:),4,G2H8(44),m3h2x8(:,44),heltab2x16(:,:,44))
  call Hotf_5pt_reduction(G2H16(54),RedSet_5(22),mass5set(:,5),  & 
G1H16(22),G1H16(208),G1H16(209),G1H16(210),G1H16(211),G1H16(212),16)
  call HG1shiftOLR(G1H16(208),8,16)
  call Hotf_5pt_reduction(G2H16(55),RedSet_5(23),mass5set(:,6),  & 
G1H16(213),G1H16(214),G1H16(215),G1H16(216),G1H16(217),G1H16(218),16)
  call HG1shiftOLR(G1H16(214),16,16)
  call Hloop_UV_W(ntryL,G1H16(23),33,ex3(:),4,G2H8(45),m3h2x8(:,45),heltab2x16(:,:,45))
  call Hotf_5pt_reduction(G2H16(56),RedSet_5(24),mass5set(:,6),  & 
G1H16(23),G1H16(219),G1H16(220),G1H16(221),G1H16(222),G1H16(223),16)
  call HG1shiftOLR(G1H16(219),8,16)
  call Hloop_UV_W(ntryL,G1H16(24),33,ex3(:),4,G2H8(46),m3h2x8(:,46),heltab2x16(:,:,46))
  call Hotf_5pt_reduction(G2H16(57),RedSet_5(24),mass5set(:,6),  & 
G1H16(24),G1H16(224),G1H16(225),G1H16(226),G1H16(227),G1H16(228),16)
  call HG1shiftOLR(G1H16(224),2,16)
  call Hloop_UV_W(ntryL,G1H16(25),33,ex3(:),4,G2H8(47),m3h2x8(:,47),heltab2x16(:,:,47))
  call Hotf_5pt_reduction(G2H16(58),RedSet_5(23),mass5set(:,6),  & 
G1H16(25),G1H16(229),G1H16(230),G1H16(231),G1H16(232),G1H16(233),16)
  call HG1shiftOLR(G1H16(229),2,16)
  call Hloop_UV_W(ntryL,G1H16(26),33,ex3(:),4,G2H8(48),m3h2x8(:,48),heltab2x16(:,:,48))
  call Hloop_QA_V(ntryL,G2H16(59),ex2(:),G2H8(49),m3h2x8(:,49),heltab2x16(:,:,49))
  call Hotf_5pt_reduction(G2H16(60),RedSet_5(25),mass5set(:,4),  & 
G1H16(26),G1H16(234),G1H16(235),G1H16(236),G1H16(237),G1H16(238),16)
  call HG1shiftOLR(G1H16(234),16,16)
  call Hloop_QA_V(ntryL,G2H16(61),ex2(:),G2H8(50),m3h2x8(:,50),heltab2x16(:,:,50))
  call Hotf_5pt_reduction(G2H16(62),RedSet_5(26),mass5set(:,4),  & 
G1H16(239),G1H16(240),G1H16(241),G1H16(242),G1H16(243),G1H16(244),16)
  call HG1shiftOLR(G1H16(240),8,16)
  call Hotf_5pt_reduction(G2H16(63),RedSet_5(27),mass5set(:,6),  & 
G1H16(245),G1H16(246),G1H16(247),G1H16(248),G1H16(249),G1H16(250),16)
  call HG1shiftOLR(G1H16(246),16,16)
  call Hloop_UV_W(ntryL,G1H16(27),34,ex3(:),4,G2H8(51),m3h2x8(:,51),heltab2x16(:,:,51))
  call Hloop_UV_W(ntryL,G1H16(28),34,ex3(:),4,G2H8(52),m3h2x8(:,52),heltab2x16(:,:,52))
  call Hotf_5pt_reduction(G2H16(64),RedSet_5(28),mass5set(:,6),  & 
G1H16(27),G1H16(28),G1H16(251),G1H16(252),G1H16(253),G1H16(254),16)
  call HG1shiftOLR(G1H16(28),8,16)
  call Hloop_UV_W(ntryL,G1H16(29),34,ex4(:),8,G2H8(53),m3h2x8(:,53),heltab2x16(:,:,53))
  call Hotf_5pt_reduction(G2H16(65),RedSet_5(14),mass5set(:,5),  & 
G1H16(29),G1H16(255),G1H16(256),G1H16(257),G1H16(258),G1H16(259),16)
  call HG1shiftOLR(G1H16(255),4,16)
  call Hloop_UV_W(ntryL,G1H16(30),34,ex5(:),16,G2H8(54),m3h2x8(:,54),heltab2x16(:,:,54))
  call Hotf_5pt_reduction(G2H16(66),RedSet_5(21),mass5set(:,5),  & 
G1H16(30),G1H16(260),G1H16(261),G1H16(262),G1H16(263),G1H16(264),16)
  call HG1shiftOLR(G1H16(260),4,16)
  call Hloop_UV_W(ntryL,G1H16(31),33,ex4(:),8,G2H8(55),m3h2x8(:,55),heltab2x16(:,:,55))
  call Hotf_5pt_reduction(G2H16(67),RedSet_5(29),mass5set(:,5),  & 
G1H16(31),G1H16(265),G1H16(266),G1H16(267),G1H16(268),G1H16(269),16)
  call HG1shiftOLR(G1H16(265),16,16)
  call Hotf_5pt_reduction(G2H16(68),RedSet_5(30),mass5set(:,6),  & 
G1H16(270),G1H16(271),G1H16(272),G1H16(273),G1H16(274),G1H16(275),16)
  call HG1shiftOLR(G1H16(271),16,16)
  call Hloop_UV_W(ntryL,G1H16(32),33,ex4(:),8,G2H8(56),m3h2x8(:,56),heltab2x16(:,:,56))
  call Hotf_5pt_reduction(G2H16(69),RedSet_5(31),mass5set(:,6),  & 
G1H16(32),G1H16(276),G1H16(277),G1H16(278),G1H16(279),G1H16(280),16)
  call HG1shiftOLR(G1H16(276),4,16)
  call Hloop_UV_W(ntryL,G1H16(33),33,ex4(:),8,G2H8(57),m3h2x8(:,57),heltab2x16(:,:,57))
  call Hotf_5pt_reduction(G2H16(70),RedSet_5(31),mass5set(:,6),  & 
G1H16(33),G1H16(281),G1H16(282),G1H16(283),G1H16(284),G1H16(285),16)
  call HG1shiftOLR(G1H16(281),2,16)
  call Hloop_UV_W(ntryL,G1H16(34),33,ex4(:),8,G2H8(58),m3h2x8(:,58),heltab2x16(:,:,58))
  call Hloop_UV_W(ntryL,G1H16(35),33,ex4(:),8,G2H8(59),m3h2x8(:,59),heltab2x16(:,:,59))
  call Hotf_5pt_reduction(G2H16(71),RedSet_5(29),mass5set(:,5),  & 
G1H16(34),G1H16(35),G1H16(286),G1H16(287),G1H16(288),G1H16(289),16)
  call HG1shiftOLR(G1H16(35),4,16)
  call Hotf_5pt_reduction(G2H16(72),RedSet_5(30),mass5set(:,6),  & 
G1H16(290),G1H16(291),G1H16(292),G1H16(293),G1H16(294),G1H16(295),16)
  call HG1shiftOLR(G1H16(291),2,16)
  call Hloop_UV_W(ntryL,G1H16(36),33,ex4(:),8,G2H8(60),m3h2x8(:,60),heltab2x16(:,:,60))
  call Hotf_5pt_reduction(G2H16(73),RedSet_5(32),mass5set(:,6),  & 
G1H16(36),G1H16(296),G1H16(297),G1H16(298),G1H16(299),G1H16(300),16)
  call HG1shiftOLR(G1H16(296),8,16)
  call Hloop_UV_W(ntryL,G1H16(37),33,ex5(:),16,G2H8(61),m3h2x8(:,61),heltab2x16(:,:,61))
  call Hotf_5pt_reduction(G2H16(74),RedSet_5(33),mass5set(:,6),  & 
G1H16(37),G1H16(301),G1H16(302),G1H16(303),G1H16(304),G1H16(305),16)
  call HG1shiftOLR(G1H16(301),4,16)
  call Hloop_UV_W(ntryL,G1H16(38),33,ex5(:),16,G2H8(62),m3h2x8(:,62),heltab2x16(:,:,62))
  call Hloop_UV_W(ntryL,G1H16(39),33,ex5(:),16,G2H8(63),m3h2x8(:,63),heltab2x16(:,:,63))
  call Hotf_5pt_reduction(G2H16(75),RedSet_5(34),mass5set(:,5),  & 
G1H16(38),G1H16(39),G1H16(306),G1H16(307),G1H16(308),G1H16(309),16)
  call HG1shiftOLR(G1H16(39),8,16)
  call Hotf_5pt_reduction(G2H16(76),RedSet_5(33),mass5set(:,6),  & 
G1H16(310),G1H16(311),G1H16(312),G1H16(313),G1H16(314),G1H16(315),16)
  call HG1shiftOLR(G1H16(311),2,16)
  call Hloop_UV_W(ntryL,G1H16(40),33,ex5(:),16,G2H8(64),m3h2x8(:,64),heltab2x16(:,:,64))
  call Hloop_UV_W(ntryL,G1H16(41),33,ex5(:),16,G2H8(65),m3h2x8(:,65),heltab2x16(:,:,65))
  call Hotf_5pt_reduction(G2H16(77),RedSet_5(34),mass5set(:,5),  & 
G1H16(40),G1H16(41),G1H16(316),G1H16(317),G1H16(318),G1H16(319),16)
  call HG1shiftOLR(G1H16(41),4,16)
  call Hotf_5pt_reduction(G2H16(78),RedSet_5(32),mass5set(:,6),  & 
G1H16(320),G1H16(321),G1H16(322),G1H16(323),G1H16(324),G1H16(325),16)
  call HG1shiftOLR(G1H16(321),2,16)
  call Hloop_UV_W(ntryL,G1H16(42),33,ex5(:),16,G2H8(66),m3h2x8(:,66),heltab2x16(:,:,66))
  call Hloop_VA_Q(ntryL,G1H16(43),ex2(:),G1H8(1),m3h2x8(:,67),heltab2x16(:,:,67))
  call Hloop_A_Q(ntryL,G1H8(1),42,nMT,G2H8(67),n2h8(13))
call HGT_raise_alpha_OLR(G1H16(44),1,1,16)
call HGT_raise_alpha_invQ_OLR(G1H16(44),2,5,16)
  call Hloop_UV_W(ntryL,G1H16(44),-16,ex5(:),16,G2H8(68),m3h2x8(:,68),heltab2x16(:,:,68))
call signflip_OLR(G2H8(68))
  call Hloop_VA_Q(ntryL,G1H16(46),ex2(:),G1H8(1),m3h2x8(:,69),heltab2x16(:,:,69))
  call Hloop_A_Q(ntryL,G1H8(1),42,nMT,G2H8(69),n2h8(14))
  call Hloop_VA_Q(ntryL,G1H16(47),ex2(:),G1H8(1),m3h2x8(:,70),heltab2x16(:,:,70))
  call Hloop_A_Q(ntryL,G1H8(1),42,nMT,G2H8(70),n2h8(15))
  call Hloop_VA_Q(ntryL,G1H16(48),ex2(:),G1H8(1),m3h2x8(:,71),heltab2x16(:,:,71))
  call Hloop_A_Q(ntryL,G1H8(1),42,nMT,G2H8(71),n2h8(16))
  call Hloop_VQ_A(ntryL,G1H16(49),ex1(:),G1H8(1),m3h2x8(:,72),heltab2x16(:,:,72))
  call Hloop_Q_A(ntryL,G1H8(1),37,nMT,G2H8(72),n2h8(17))
call HGT_raise_alpha_OLR(G1H16(50),1,1,16)
call HGT_raise_alpha_invQ_OLR(G1H16(50),2,5,16)
  call Hloop_UV_W(ntryL,G1H16(50),-16,ex5(:),16,G2H8(73),m3h2x8(:,73),heltab2x16(:,:,73))
call signflip_OLR(G2H8(73))
  call Hloop_VQ_A(ntryL,G1H16(52),ex1(:),G1H8(1),m3h2x8(:,74),heltab2x16(:,:,74))
  call Hloop_Q_A(ntryL,G1H8(1),37,nMT,G2H8(74),n2h8(18))
  call Hloop_VQ_A(ntryL,G1H16(53),ex1(:),G1H8(1),m3h2x8(:,75),heltab2x16(:,:,75))
  call Hloop_Q_A(ntryL,G1H8(1),37,nMT,G2H8(75),n2h8(19))
  call Hloop_VQ_A(ntryL,G1H16(54),ex1(:),G1H8(1),m3h2x8(:,76),heltab2x16(:,:,76))
  call Hloop_Q_A(ntryL,G1H8(1),37,nMT,G2H8(76),n2h8(20))
  call Hloop_AV_Q(ntryL,G1H16(55),ex3(:),G1H8(1),m3h2x8(:,77),heltab2x16(:,:,77))
  call Hloop_A_Q(ntryL,G1H8(1),44,nMT,G2H8(77),n2h8(21))
call HGT_OLR(G1H16(56),1,1,16)
call HGT_invQ_OLR(G1H16(56),2,5,16)
  call Hloop_Q_A(ntryL,G1H16(56),-16,nMT,G2H16(1),n2h16(63))
  call Hloop_QV_A(ntryL,G2H16(1),ex5(:),G2H8(78),m3h2x8(:,78),heltab2x16(:,:,78))
  call Hloop_AV_Q(ntryL,G1H16(58),ex3(:),G1H8(1),m3h2x8(:,79),heltab2x16(:,:,79))
  call Hloop_A_Q(ntryL,G1H8(1),44,nMT,G2H8(79),n2h8(22))
  call Hloop_AV_Q(ntryL,G1H16(59),ex3(:),G1H8(1),m3h2x8(:,80),heltab2x16(:,:,80))
  call Hloop_A_Q(ntryL,G1H8(1),44,nMT,G2H8(80),n2h8(23))
  call Hloop_AV_Q(ntryL,G1H16(60),ex3(:),G1H8(1),m3h2x8(:,81),heltab2x16(:,:,81))
  call Hloop_A_Q(ntryL,G1H8(1),44,nMT,G2H8(81),n2h8(24))
  call Hloop_UV_W(ntryL,G1H16(61),40,ex3(:),4,G2H8(82),m3h2x8(:,82),heltab2x16(:,:,82))
call HGT_raise_alpha_OLR(G1H16(62),1,1,16)
call HGT_raise_alpha_invQ_OLR(G1H16(62),2,5,16)
  call Hloop_UV_W(ntryL,G1H16(62),-16,ex5(:),16,G2H8(83),m3h2x8(:,83),heltab2x16(:,:,83))
call signflip_OLR(G2H8(83))
  call Hloop_UV_W(ntryL,G1H16(64),40,ex3(:),4,G2H8(84),m3h2x8(:,84),heltab2x16(:,:,84))
  call Hloop_UV_W(ntryL,G1H16(65),40,ex3(:),4,G2H8(85),m3h2x8(:,85),heltab2x16(:,:,85))
  call Hloop_UV_W(ntryL,G1H16(66),40,ex3(:),4,G2H8(86),m3h2x8(:,86),heltab2x16(:,:,86))
  call Hloop_VQ_A(ntryL,G1H16(67),ex1(:),G1H8(1),m3h2x8(:,87),heltab2x16(:,:,87))
  call Hloop_Q_A(ntryL,G1H8(1),37,nMT,G2H8(87),n2h8(25))
call HGT_raise_alpha_OLR(G1H16(68),1,1,16)
call HGT_raise_alpha_invQ_OLR(G1H16(68),2,5,16)
  call Hloop_UV_W(ntryL,G1H16(68),-8,ex4(:),8,G2H8(88),m3h2x8(:,88),heltab2x16(:,:,88))
call signflip_OLR(G2H8(88))
  call Hloop_VQ_A(ntryL,G1H16(70),ex1(:),G1H8(1),m3h2x8(:,89),heltab2x16(:,:,89))
  call Hloop_Q_A(ntryL,G1H8(1),37,nMT,G2H8(89),n2h8(26))
  call Hloop_VQ_A(ntryL,G1H16(71),ex1(:),G1H8(1),m3h2x8(:,90),heltab2x16(:,:,90))
  call Hloop_Q_A(ntryL,G1H8(1),37,nMT,G2H8(90),n2h8(27))
  call Hloop_VQ_A(ntryL,G1H16(72),ex1(:),G1H8(1),m3h2x8(:,91),heltab2x16(:,:,91))
  call Hloop_Q_A(ntryL,G1H8(1),37,nMT,G2H8(91),n2h8(28))
  call Hloop_VQ_A(ntryL,G1H16(1),ex1(:),G1H8(1),m3h2x8(:,92),heltab2x16(:,:,92))
  call Hloop_Q_A(ntryL,G1H8(1),41,nMT,G2H8(92),n2h8(29))
call HGT_raise_alpha_OLR(G1H16(2),1,1,16)
call HGT_raise_alpha_invQ_OLR(G1H16(2),2,5,16)
  call Hloop_UV_W(ntryL,G1H16(2),-16,ex5(:),16,G2H8(93),m3h2x8(:,93),heltab2x16(:,:,93))
call signflip_OLR(G2H8(93))
  call Hloop_VQ_A(ntryL,G1H16(74),ex1(:),G1H8(1),m3h2x8(:,94),heltab2x16(:,:,94))
  call Hloop_Q_A(ntryL,G1H8(1),41,nMT,G2H8(94),n2h8(30))
  call Hloop_VQ_A(ntryL,G1H16(75),ex1(:),G1H8(1),m3h2x8(:,95),heltab2x16(:,:,95))
  call Hloop_Q_A(ntryL,G1H8(1),41,nMT,G2H8(95),n2h8(31))
  call Hloop_VQ_A(ntryL,G1H16(76),ex1(:),G1H8(1),m3h2x8(:,96),heltab2x16(:,:,96))
  call Hloop_Q_A(ntryL,G1H8(1),41,nMT,G2H8(96),n2h8(32))
  call Hloop_VA_Q(ntryL,G1H16(77),ex2(:),G1H8(1),m3h2x8(:,97),heltab2x16(:,:,97))
  call Hloop_A_Q(ntryL,G1H8(1),38,nMT,G2H8(97),n2h8(33))
call HGT_raise_alpha_OLR(G1H16(78),1,1,16)
call HGT_raise_alpha_invQ_OLR(G1H16(78),2,5,16)
  call Hloop_UV_W(ntryL,G1H16(78),-16,ex5(:),16,G2H8(98),m3h2x8(:,98),heltab2x16(:,:,98))
call signflip_OLR(G2H8(98))
  call Hloop_VA_Q(ntryL,G1H16(80),ex2(:),G1H8(1),m3h2x8(:,99),heltab2x16(:,:,99))
  call Hloop_A_Q(ntryL,G1H8(1),38,nMT,G2H8(99),n2h8(34))
  call Hloop_VA_Q(ntryL,G1H16(81),ex2(:),G1H8(1),m3h2x8(:,100),heltab2x16(:,:,100))
  call Hloop_A_Q(ntryL,G1H8(1),38,nMT,G2H8(100),n2h8(35))
  call Hloop_VA_Q(ntryL,G1H16(82),ex2(:),G1H8(1),m3h2x8(:,101),heltab2x16(:,:,101))
  call Hloop_A_Q(ntryL,G1H8(1),38,nMT,G2H8(101),n2h8(36))
  call Hloop_AV_Q(ntryL,G1H16(83),ex4(:),G1H8(1),m3h2x8(:,102),heltab2x16(:,:,102))
  call Hloop_A_Q(ntryL,G1H8(1),44,nMT,G2H8(102),n2h8(37))
call HGT_OLR(G1H16(84),1,1,16)
call HGT_invQ_OLR(G1H16(84),2,5,16)
  call Hloop_Q_A(ntryL,G1H16(84),-16,nMT,G2H16(2),n2h16(68))
  call Hloop_QV_A(ntryL,G2H16(2),ex5(:),G2H8(103),m3h2x8(:,103),heltab2x16(:,:,103))
  call Hloop_AV_Q(ntryL,G1H16(86),ex4(:),G1H8(1),m3h2x8(:,104),heltab2x16(:,:,104))
  call Hloop_A_Q(ntryL,G1H8(1),44,nMT,G2H8(104),n2h8(38))
  call Hloop_AV_Q(ntryL,G1H16(87),ex4(:),G1H8(1),m3h2x8(:,105),heltab2x16(:,:,105))
  call Hloop_A_Q(ntryL,G1H8(1),44,nMT,G2H8(105),n2h8(39))
  call Hloop_AV_Q(ntryL,G1H16(88),ex4(:),G1H8(1),m3h2x8(:,106),heltab2x16(:,:,106))
  call Hloop_A_Q(ntryL,G1H8(1),44,nMT,G2H8(106),n2h8(40))
  call Hloop_UV_W(ntryL,G1H16(89),36,ex4(:),8,G2H8(107),m3h2x8(:,107),heltab2x16(:,:,107))
call HGT_raise_alpha_OLR(G1H16(90),1,1,16)
call HGT_raise_alpha_invQ_OLR(G1H16(90),2,5,16)
  call Hloop_UV_W(ntryL,G1H16(90),-16,ex5(:),16,G2H8(108),m3h2x8(:,108),heltab2x16(:,:,108))
call signflip_OLR(G2H8(108))
  call Hloop_UV_W(ntryL,G1H16(92),36,ex4(:),8,G2H8(109),m3h2x8(:,109),heltab2x16(:,:,109))
  call Hloop_UV_W(ntryL,G1H16(93),36,ex4(:),8,G2H8(110),m3h2x8(:,110),heltab2x16(:,:,110))
  call Hloop_UV_W(ntryL,G1H16(94),36,ex4(:),8,G2H8(111),m3h2x8(:,111),heltab2x16(:,:,111))
  call Hloop_QV_A(ntryL,G1H16(95),ex5(:),G1H8(1),m3h2x8(:,112),heltab2x16(:,:,112))
  call Hloop_Q_A(ntryL,G1H8(1),52,nMT,G2H8(112),n2h8(41))
call HGT_OLR(G1H16(96),1,1,16)
call HGT_invQ_OLR(G1H16(96),2,5,16)
  call Hloop_A_Q(ntryL,G1H16(96),-8,nMT,G2H16(3),n2h16(70))
  call Hloop_AV_Q(ntryL,G2H16(3),ex4(:),G2H8(113),m3h2x8(:,113),heltab2x16(:,:,113))
  call Hloop_QV_A(ntryL,G1H16(98),ex5(:),G1H8(1),m3h2x8(:,114),heltab2x16(:,:,114))
  call Hloop_Q_A(ntryL,G1H8(1),52,nMT,G2H8(114),n2h8(42))
  call Hloop_QV_A(ntryL,G1H16(99),ex5(:),G1H8(1),m3h2x8(:,115),heltab2x16(:,:,115))
  call Hloop_Q_A(ntryL,G1H8(1),52,nMT,G2H8(115),n2h8(43))
  call Hloop_QV_A(ntryL,G1H16(100),ex5(:),G1H8(1),m3h2x8(:,116),heltab2x16(:,:,116))
  call Hloop_Q_A(ntryL,G1H8(1),52,nMT,G2H8(116),n2h8(44))
  call Hloop_UV_W(ntryL,G1H16(101),36,ex5(:),16,G2H8(117),m3h2x8(:,117),heltab2x16(:,:,117))
call HGT_raise_alpha_OLR(G1H16(102),1,1,16)
call HGT_raise_alpha_invQ_OLR(G1H16(102),2,5,16)
  call Hloop_UV_W(ntryL,G1H16(102),-8,ex4(:),8,G2H8(118),m3h2x8(:,118),heltab2x16(:,:,118))
call signflip_OLR(G2H8(118))
  call Hloop_UV_W(ntryL,G1H16(104),36,ex5(:),16,G2H8(119),m3h2x8(:,119),heltab2x16(:,:,119))
  call Hloop_UV_W(ntryL,G1H16(105),36,ex5(:),16,G2H8(120),m3h2x8(:,120),heltab2x16(:,:,120))
  call Hloop_UV_W(ntryL,G1H16(106),36,ex5(:),16,G2H8(121),m3h2x8(:,121),heltab2x16(:,:,121))
  call Hloop_QV_A(ntryL,G1H16(3),ex3(:),G1H8(1),m3h2x8(:,122),heltab2x16(:,:,122))
  call Hloop_Q_A(ntryL,G1H8(1),44,nMT,G2H8(122),n2h8(45))
call HGT_OLR(G1H16(4),1,1,16)
call HGT_invQ_OLR(G1H16(4),2,5,16)
  call Hloop_A_Q(ntryL,G1H16(4),-16,nMT,G2H16(4),n2h16(72))
  call Hloop_AV_Q(ntryL,G2H16(4),ex5(:),G2H8(123),m3h2x8(:,123),heltab2x16(:,:,123))
  call Hloop_QV_A(ntryL,G1H16(108),ex3(:),G1H8(1),m3h2x8(:,124),heltab2x16(:,:,124))
  call Hloop_Q_A(ntryL,G1H8(1),44,nMT,G2H8(124),n2h8(46))
  call Hloop_QV_A(ntryL,G1H16(109),ex3(:),G1H8(1),m3h2x8(:,125),heltab2x16(:,:,125))
  call Hloop_Q_A(ntryL,G1H8(1),44,nMT,G2H8(125),n2h8(47))
  call Hloop_QV_A(ntryL,G1H16(110),ex3(:),G1H8(1),m3h2x8(:,126),heltab2x16(:,:,126))
  call Hloop_Q_A(ntryL,G1H8(1),44,nMT,G2H8(126),n2h8(48))
  call Hloop_UV_W(ntryL,G1H16(111),40,ex3(:),4,G2H8(127),m3h2x8(:,127),heltab2x16(:,:,127))
call HGT_raise_alpha_OLR(G1H16(112),1,1,16)
call HGT_raise_alpha_invQ_OLR(G1H16(112),2,5,16)
  call Hloop_UV_W(ntryL,G1H16(112),-16,ex5(:),16,G2H8(128),m3h2x8(:,128),heltab2x16(:,:,128))
call signflip_OLR(G2H8(128))
  call Hloop_UV_W(ntryL,G1H16(114),40,ex3(:),4,G2H8(129),m3h2x8(:,129),heltab2x16(:,:,129))
  call Hloop_UV_W(ntryL,G1H16(115),40,ex3(:),4,G2H8(130),m3h2x8(:,130),heltab2x16(:,:,130))
  call Hloop_UV_W(ntryL,G1H16(116),40,ex3(:),4,G2H8(131),m3h2x8(:,131),heltab2x16(:,:,131))
  call Hloop_VA_Q(ntryL,G1H16(117),ex2(:),G1H8(1),m3h2x8(:,132),heltab2x16(:,:,132))
  call Hloop_A_Q(ntryL,G1H8(1),38,nMT,G2H8(132),n2h8(49))
call HGT_raise_alpha_OLR(G1H16(118),1,1,16)
call HGT_raise_alpha_invQ_OLR(G1H16(118),2,5,16)
  call Hloop_UV_W(ntryL,G1H16(118),-8,ex4(:),8,G2H8(133),m3h2x8(:,133),heltab2x16(:,:,133))
call signflip_OLR(G2H8(133))
  call Hloop_VA_Q(ntryL,G1H16(120),ex2(:),G1H8(1),m3h2x8(:,134),heltab2x16(:,:,134))
  call Hloop_A_Q(ntryL,G1H8(1),38,nMT,G2H8(134),n2h8(50))
  call Hloop_VA_Q(ntryL,G1H16(121),ex2(:),G1H8(1),m3h2x8(:,135),heltab2x16(:,:,135))
  call Hloop_A_Q(ntryL,G1H8(1),38,nMT,G2H8(135),n2h8(51))
  call Hloop_VA_Q(ntryL,G1H16(122),ex2(:),G1H8(1),m3h2x8(:,136),heltab2x16(:,:,136))
  call Hloop_A_Q(ntryL,G1H8(1),38,nMT,G2H8(136),n2h8(52))
  call Hloop_QV_A(ntryL,G1H16(123),ex4(:),G1H8(1),m3h2x8(:,137),heltab2x16(:,:,137))
  call Hloop_Q_A(ntryL,G1H8(1),44,nMT,G2H8(137),n2h8(53))
call HGT_OLR(G1H16(124),1,1,16)
call HGT_invQ_OLR(G1H16(124),2,5,16)
  call Hloop_A_Q(ntryL,G1H16(124),-16,nMT,G2H16(5),n2h16(75))
  call Hloop_AV_Q(ntryL,G2H16(5),ex5(:),G2H8(138),m3h2x8(:,138),heltab2x16(:,:,138))
  call Hloop_QV_A(ntryL,G1H16(126),ex4(:),G1H8(1),m3h2x8(:,139),heltab2x16(:,:,139))
  call Hloop_Q_A(ntryL,G1H8(1),44,nMT,G2H8(139),n2h8(54))
  call Hloop_QV_A(ntryL,G1H16(127),ex4(:),G1H8(1),m3h2x8(:,140),heltab2x16(:,:,140))
  call Hloop_Q_A(ntryL,G1H8(1),44,nMT,G2H8(140),n2h8(55))
  call Hloop_QV_A(ntryL,G1H16(128),ex4(:),G1H8(1),m3h2x8(:,141),heltab2x16(:,:,141))
  call Hloop_Q_A(ntryL,G1H8(1),44,nMT,G2H8(141),n2h8(56))
  call Hloop_UV_W(ntryL,G1H16(129),36,ex4(:),8,G2H8(142),m3h2x8(:,142),heltab2x16(:,:,142))
call HGT_raise_alpha_OLR(G1H16(130),1,1,16)
call HGT_raise_alpha_invQ_OLR(G1H16(130),2,5,16)
  call Hloop_UV_W(ntryL,G1H16(130),-16,ex5(:),16,G2H8(143),m3h2x8(:,143),heltab2x16(:,:,143))
call signflip_OLR(G2H8(143))
  call Hloop_UV_W(ntryL,G1H16(132),36,ex4(:),8,G2H8(144),m3h2x8(:,144),heltab2x16(:,:,144))
  call Hloop_UV_W(ntryL,G1H16(133),36,ex4(:),8,G2H8(145),m3h2x8(:,145),heltab2x16(:,:,145))
  call Hloop_UV_W(ntryL,G1H16(134),36,ex4(:),8,G2H8(146),m3h2x8(:,146),heltab2x16(:,:,146))
  call Hloop_AV_Q(ntryL,G1H16(135),ex5(:),G1H8(1),m3h2x8(:,147),heltab2x16(:,:,147))
  call Hloop_A_Q(ntryL,G1H8(1),52,nMT,G2H8(147),n2h8(57))
call HGT_OLR(G1H16(136),1,1,16)
call HGT_invQ_OLR(G1H16(136),2,5,16)
  call Hloop_Q_A(ntryL,G1H16(136),-8,nMT,G2H16(6),n2h16(77))
  call Hloop_QV_A(ntryL,G2H16(6),ex4(:),G2H8(148),m3h2x8(:,148),heltab2x16(:,:,148))
  call Hloop_AV_Q(ntryL,G1H16(138),ex5(:),G1H8(1),m3h2x8(:,149),heltab2x16(:,:,149))
  call Hloop_A_Q(ntryL,G1H8(1),52,nMT,G2H8(149),n2h8(58))
  call Hloop_AV_Q(ntryL,G1H16(139),ex5(:),G1H8(1),m3h2x8(:,150),heltab2x16(:,:,150))
  call Hloop_A_Q(ntryL,G1H8(1),52,nMT,G2H8(150),n2h8(59))
  call Hloop_AV_Q(ntryL,G1H16(140),ex5(:),G1H8(1),m3h2x8(:,151),heltab2x16(:,:,151))
  call Hloop_A_Q(ntryL,G1H8(1),52,nMT,G2H8(151),n2h8(60))
  call Hloop_UV_W(ntryL,G1H16(141),36,ex5(:),16,G2H8(152),m3h2x8(:,152),heltab2x16(:,:,152))
call HGT_raise_alpha_OLR(G1H16(142),1,1,16)
call HGT_raise_alpha_invQ_OLR(G1H16(142),2,5,16)
  call Hloop_UV_W(ntryL,G1H16(142),-8,ex4(:),8,G2H8(153),m3h2x8(:,153),heltab2x16(:,:,153))
call signflip_OLR(G2H8(153))
  call Hloop_UV_W(ntryL,G1H16(144),36,ex5(:),16,G2H8(154),m3h2x8(:,154),heltab2x16(:,:,154))
  call Hloop_UV_W(ntryL,G1H16(145),36,ex5(:),16,G2H8(155),m3h2x8(:,155),heltab2x16(:,:,155))
  call Hloop_UV_W(ntryL,G1H16(146),36,ex5(:),16,G2H8(156),m3h2x8(:,156),heltab2x16(:,:,156))
  call Hloop_VQ_A(ntryL,G1H16(5),ex1(:),G1H8(1),m3h2x8(:,157),heltab2x16(:,:,157))
  call Hloop_Q_A(ntryL,G1H8(1),41,nMT,G2H8(157),n2h8(61))
call HGT_raise_alpha_OLR(G1H16(6),1,1,16)
call HGT_raise_alpha_invQ_OLR(G1H16(6),2,5,16)
  call Hloop_UV_W(ntryL,G1H16(6),-16,ex5(:),16,G2H8(158),m3h2x8(:,158),heltab2x16(:,:,158))
call signflip_OLR(G2H8(158))
  call Hloop_VQ_A(ntryL,G1H16(8),ex1(:),G1H8(1),m3h2x8(:,159),heltab2x16(:,:,159))
  call Hloop_Q_A(ntryL,G1H8(1),41,nMT,G2H8(159),n2h8(62))
  call Hloop_VQ_A(ntryL,G1H16(9),ex1(:),G1H8(1),m3h2x8(:,160),heltab2x16(:,:,160))
  call Hloop_Q_A(ntryL,G1H8(1),41,nMT,G2H8(160),n2h8(63))
  call Hloop_VQ_A(ntryL,G1H16(10),ex1(:),G1H8(1),m3h2x8(:,161),heltab2x16(:,:,161))
  call Hloop_Q_A(ntryL,G1H8(1),41,nMT,G2H8(161),n2h8(64))
  call Hloop_AV_Q(ntryL,G1H16(11),ex3(:),G1H8(1),m3h2x8(:,162),heltab2x16(:,:,162))
  call Hloop_A_Q(ntryL,G1H8(1),38,nMT,G2H8(162),n2h8(65))
call HGT_raise_alpha_OLR(G1H16(12),1,1,16)
call HGT_raise_alpha_invQ_OLR(G1H16(12),2,5,16)
  call Hloop_UV_W(ntryL,G1H16(12),-16,ex5(:),16,G2H8(163),m3h2x8(:,163),heltab2x16(:,:,163))
call signflip_OLR(G2H8(163))
  call Hloop_AV_Q(ntryL,G1H16(147),ex3(:),G1H8(1),m3h2x8(:,164),heltab2x16(:,:,164))
  call Hloop_A_Q(ntryL,G1H8(1),38,nMT,G2H8(164),n2h8(66))
  call Hloop_AV_Q(ntryL,G1H16(148),ex3(:),G1H8(1),m3h2x8(:,165),heltab2x16(:,:,165))
  call Hloop_A_Q(ntryL,G1H8(1),38,nMT,G2H8(165),n2h8(67))
  call Hloop_AV_Q(ntryL,G1H16(149),ex3(:),G1H8(1),m3h2x8(:,166),heltab2x16(:,:,166))
  call Hloop_A_Q(ntryL,G1H8(1),38,nMT,G2H8(166),n2h8(68))
  call Hloop_VQ_A(ntryL,G1H16(150),ex1(:),G1H8(1),m3h2x8(:,167),heltab2x16(:,:,167))
  call Hloop_Q_A(ntryL,G1H8(1),37,nMT,G2H8(167),n2h8(69))
call HGT_raise_alpha_OLR(G1H16(151),1,1,16)
call HGT_raise_alpha_invQ_OLR(G1H16(151),2,5,16)
  call Hloop_UV_W(ntryL,G1H16(151),-16,ex5(:),16,G2H8(168),m3h2x8(:,168),heltab2x16(:,:,168))
call signflip_OLR(G2H8(168))
  call Hloop_VQ_A(ntryL,G1H16(153),ex1(:),G1H8(1),m3h2x8(:,169),heltab2x16(:,:,169))
  call Hloop_Q_A(ntryL,G1H8(1),37,nMT,G2H8(169),n2h8(70))
  call Hloop_VQ_A(ntryL,G1H16(154),ex1(:),G1H8(1),m3h2x8(:,170),heltab2x16(:,:,170))
  call Hloop_Q_A(ntryL,G1H8(1),37,nMT,G2H8(170),n2h8(71))
  call Hloop_VQ_A(ntryL,G1H16(155),ex1(:),G1H8(1),m3h2x8(:,171),heltab2x16(:,:,171))
  call Hloop_Q_A(ntryL,G1H8(1),37,nMT,G2H8(171),n2h8(72))
  call Hloop_AV_Q(ntryL,G1H16(14),ex4(:),G1H8(1),m3h2x8(:,172),heltab2x16(:,:,172))
  call Hloop_A_Q(ntryL,G1H8(1),42,nMT,G2H8(172),n2h8(73))
call HGT_raise_alpha_OLR(G1H16(156),1,1,16)
call HGT_raise_alpha_invQ_OLR(G1H16(156),2,5,16)
  call Hloop_UV_W(ntryL,G1H16(156),-16,ex5(:),16,G2H8(173),m3h2x8(:,173),heltab2x16(:,:,173))
call signflip_OLR(G2H8(173))
  call Hloop_AV_Q(ntryL,G1H16(158),ex4(:),G1H8(1),m3h2x8(:,174),heltab2x16(:,:,174))
  call Hloop_A_Q(ntryL,G1H8(1),42,nMT,G2H8(174),n2h8(74))
  call Hloop_AV_Q(ntryL,G1H16(159),ex4(:),G1H8(1),m3h2x8(:,175),heltab2x16(:,:,175))
  call Hloop_A_Q(ntryL,G1H8(1),42,nMT,G2H8(175),n2h8(75))
  call Hloop_AV_Q(ntryL,G1H16(160),ex4(:),G1H8(1),m3h2x8(:,176),heltab2x16(:,:,176))
  call Hloop_A_Q(ntryL,G1H8(1),42,nMT,G2H8(176),n2h8(76))
  call Hloop_AV_Q(ntryL,G1H16(161),ex5(:),G1H8(1),m3h2x8(:,177),heltab2x16(:,:,177))
  call Hloop_A_Q(ntryL,G1H8(1),50,nMT,G2H8(177),n2h8(77))
call HGT_raise_alpha_OLR(G1H16(162),1,1,16)
call HGT_raise_alpha_invQ_OLR(G1H16(162),2,5,16)
  call Hloop_UV_W(ntryL,G1H16(162),-8,ex4(:),8,G2H8(178),m3h2x8(:,178),heltab2x16(:,:,178))
call signflip_OLR(G2H8(178))
  call Hloop_AV_Q(ntryL,G1H16(164),ex5(:),G1H8(1),m3h2x8(:,179),heltab2x16(:,:,179))
  call Hloop_A_Q(ntryL,G1H8(1),50,nMT,G2H8(179),n2h8(78))
  call Hloop_AV_Q(ntryL,G1H16(165),ex5(:),G1H8(1),m3h2x8(:,180),heltab2x16(:,:,180))
  call Hloop_A_Q(ntryL,G1H8(1),50,nMT,G2H8(180),n2h8(79))
  call Hloop_AV_Q(ntryL,G1H16(166),ex5(:),G1H8(1),m3h2x8(:,181),heltab2x16(:,:,181))
  call Hloop_A_Q(ntryL,G1H8(1),50,nMT,G2H8(181),n2h8(80))
  call Hloop_AV_Q(ntryL,G1H16(15),ex5(:),G1H8(1),m3h2x8(:,182),heltab2x16(:,:,182))
  call Hloop_A_Q(ntryL,G1H8(1),50,nMT,G2H8(182),n2h8(81))
call HGT_raise_alpha_OLR(G1H16(16),1,1,16)
call HGT_raise_alpha_invQ_OLR(G1H16(16),2,5,16)
  call Hloop_UV_W(ntryL,G1H16(16),-4,ex3(:),4,G2H8(183),m3h2x8(:,183),heltab2x16(:,:,183))
call signflip_OLR(G2H8(183))
  call Hloop_AV_Q(ntryL,G1H16(168),ex5(:),G1H8(1),m3h2x8(:,184),heltab2x16(:,:,184))
  call Hloop_A_Q(ntryL,G1H8(1),50,nMT,G2H8(184),n2h8(82))
  call Hloop_AV_Q(ntryL,G1H16(169),ex5(:),G1H8(1),m3h2x8(:,185),heltab2x16(:,:,185))
  call Hloop_A_Q(ntryL,G1H8(1),50,nMT,G2H8(185),n2h8(83))
  call Hloop_AV_Q(ntryL,G1H16(170),ex5(:),G1H8(1),m3h2x8(:,186),heltab2x16(:,:,186))
  call Hloop_A_Q(ntryL,G1H8(1),50,nMT,G2H8(186),n2h8(84))
  call Hloop_VA_Q(ntryL,G1H16(171),ex2(:),G1H8(1),m3h2x8(:,187),heltab2x16(:,:,187))
  call Hloop_A_Q(ntryL,G1H8(1),42,nMT,G2H8(187),n2h8(85))
call HGT_raise_alpha_OLR(G1H16(172),1,1,16)
call HGT_raise_alpha_invQ_OLR(G1H16(172),2,5,16)
  call Hloop_UV_W(ntryL,G1H16(172),-16,ex5(:),16,G2H8(188),m3h2x8(:,188),heltab2x16(:,:,188))
call signflip_OLR(G2H8(188))
  call Hloop_VA_Q(ntryL,G1H16(174),ex2(:),G1H8(1),m3h2x8(:,189),heltab2x16(:,:,189))
  call Hloop_A_Q(ntryL,G1H8(1),42,nMT,G2H8(189),n2h8(86))
  call Hloop_VA_Q(ntryL,G1H16(175),ex2(:),G1H8(1),m3h2x8(:,190),heltab2x16(:,:,190))
  call Hloop_A_Q(ntryL,G1H8(1),42,nMT,G2H8(190),n2h8(87))
  call Hloop_VA_Q(ntryL,G1H16(176),ex2(:),G1H8(1),m3h2x8(:,191),heltab2x16(:,:,191))
  call Hloop_A_Q(ntryL,G1H8(1),42,nMT,G2H8(191),n2h8(88))
  call Hloop_AV_Q(ntryL,G1H16(17),ex3(:),G1H8(1),m3h2x8(:,192),heltab2x16(:,:,192))
  call Hloop_A_Q(ntryL,G1H8(1),38,nMT,G2H8(192),n2h8(89))
call HGT_raise_alpha_OLR(G1H16(177),1,1,16)
call HGT_raise_alpha_invQ_OLR(G1H16(177),2,5,16)
  call Hloop_UV_W(ntryL,G1H16(177),-8,ex4(:),8,G2H8(193),m3h2x8(:,193),heltab2x16(:,:,193))
call signflip_OLR(G2H8(193))
  call Hloop_AV_Q(ntryL,G1H16(179),ex3(:),G1H8(1),m3h2x8(:,194),heltab2x16(:,:,194))
  call Hloop_A_Q(ntryL,G1H8(1),38,nMT,G2H8(194),n2h8(90))
  call Hloop_AV_Q(ntryL,G1H16(180),ex3(:),G1H8(1),m3h2x8(:,195),heltab2x16(:,:,195))
  call Hloop_A_Q(ntryL,G1H8(1),38,nMT,G2H8(195),n2h8(91))
  call Hloop_AV_Q(ntryL,G1H16(181),ex3(:),G1H8(1),m3h2x8(:,196),heltab2x16(:,:,196))
  call Hloop_A_Q(ntryL,G1H8(1),38,nMT,G2H8(196),n2h8(92))
  call Hloop_VQ_A(ntryL,G1H16(182),ex1(:),G1H8(1),m3h2x8(:,197),heltab2x16(:,:,197))
  call Hloop_Q_A(ntryL,G1H8(1),37,nMT,G2H8(197),n2h8(93))
call HGT_raise_alpha_OLR(G1H16(183),1,1,16)
call HGT_raise_alpha_invQ_OLR(G1H16(183),2,5,16)
  call Hloop_UV_W(ntryL,G1H16(183),-8,ex4(:),8,G2H8(198),m3h2x8(:,198),heltab2x16(:,:,198))
call signflip_OLR(G2H8(198))
  call Hloop_VQ_A(ntryL,G1H16(185),ex1(:),G1H8(1),m3h2x8(:,199),heltab2x16(:,:,199))
  call Hloop_Q_A(ntryL,G1H8(1),37,nMT,G2H8(199),n2h8(94))
  call Hloop_VQ_A(ntryL,G1H16(186),ex1(:),G1H8(1),m3h2x8(:,200),heltab2x16(:,:,200))
  call Hloop_Q_A(ntryL,G1H8(1),37,nMT,G2H8(200),n2h8(95))
  call Hloop_VQ_A(ntryL,G1H16(187),ex1(:),G1H8(1),m3h2x8(:,201),heltab2x16(:,:,201))
  call Hloop_Q_A(ntryL,G1H8(1),37,nMT,G2H8(201),n2h8(96))
  call Hloop_AV_Q(ntryL,G1H16(188),ex4(:),G1H8(1),m3h2x8(:,202),heltab2x16(:,:,202))
  call Hloop_A_Q(ntryL,G1H8(1),42,nMT,G2H8(202),n2h8(97))
call HGT_raise_alpha_OLR(G1H16(189),1,1,16)
call HGT_raise_alpha_invQ_OLR(G1H16(189),2,5,16)
  call Hloop_UV_W(ntryL,G1H16(189),-16,ex5(:),16,G2H8(203),m3h2x8(:,203),heltab2x16(:,:,203))
call signflip_OLR(G2H8(203))
  call Hloop_AV_Q(ntryL,G1H16(191),ex4(:),G1H8(1),m3h2x8(:,204),heltab2x16(:,:,204))
  call Hloop_A_Q(ntryL,G1H8(1),42,nMT,G2H8(204),n2h8(98))
  call Hloop_AV_Q(ntryL,G1H16(192),ex4(:),G1H8(1),m3h2x8(:,205),heltab2x16(:,:,205))
  call Hloop_A_Q(ntryL,G1H8(1),42,nMT,G2H8(205),n2h8(99))
  call Hloop_AV_Q(ntryL,G1H16(193),ex4(:),G1H8(1),m3h2x8(:,206),heltab2x16(:,:,206))
  call Hloop_A_Q(ntryL,G1H8(1),42,nMT,G2H8(206),n2h8(100))
  call Hloop_AV_Q(ntryL,G1H16(18),ex4(:),G1H8(1),m3h2x8(:,207),heltab2x16(:,:,207))
  call Hloop_A_Q(ntryL,G1H8(1),42,nMT,G2H8(207),n2h8(101))
call HGT_raise_alpha_OLR(G1H16(19),1,1,16)
call HGT_raise_alpha_invQ_OLR(G1H16(19),2,5,16)
  call Hloop_UV_W(ntryL,G1H16(19),-4,ex3(:),4,G2H8(208),m3h2x8(:,208),heltab2x16(:,:,208))
call signflip_OLR(G2H8(208))
  call Hloop_AV_Q(ntryL,G1H16(195),ex4(:),G1H8(1),m3h2x8(:,209),heltab2x16(:,:,209))
  call Hloop_A_Q(ntryL,G1H8(1),42,nMT,G2H8(209),n2h8(102))
  call Hloop_AV_Q(ntryL,G1H16(196),ex4(:),G1H8(1),m3h2x8(:,210),heltab2x16(:,:,210))
  call Hloop_A_Q(ntryL,G1H8(1),42,nMT,G2H8(210),n2h8(103))
  call Hloop_AV_Q(ntryL,G1H16(197),ex4(:),G1H8(1),m3h2x8(:,211),heltab2x16(:,:,211))
  call Hloop_A_Q(ntryL,G1H8(1),42,nMT,G2H8(211),n2h8(104))
  call Hloop_AV_Q(ntryL,G1H16(20),ex5(:),G1H8(1),m3h2x8(:,212),heltab2x16(:,:,212))
  call Hloop_A_Q(ntryL,G1H8(1),50,nMT,G2H8(212),n2h8(105))
call HGT_raise_alpha_OLR(G1H16(198),1,1,16)
call HGT_raise_alpha_invQ_OLR(G1H16(198),2,5,16)
  call Hloop_UV_W(ntryL,G1H16(198),-8,ex4(:),8,G2H8(213),m3h2x8(:,213),heltab2x16(:,:,213))
call signflip_OLR(G2H8(213))
  call Hloop_AV_Q(ntryL,G1H16(200),ex5(:),G1H8(1),m3h2x8(:,214),heltab2x16(:,:,214))
  call Hloop_A_Q(ntryL,G1H8(1),50,nMT,G2H8(214),n2h8(106))
  call Hloop_AV_Q(ntryL,G1H16(201),ex5(:),G1H8(1),m3h2x8(:,215),heltab2x16(:,:,215))
  call Hloop_A_Q(ntryL,G1H8(1),50,nMT,G2H8(215),n2h8(107))
  call Hloop_AV_Q(ntryL,G1H16(202),ex5(:),G1H8(1),m3h2x8(:,216),heltab2x16(:,:,216))
  call Hloop_A_Q(ntryL,G1H8(1),50,nMT,G2H8(216),n2h8(108))
  call Hloop_QV_A(ntryL,G1H16(21),ex3(:),G1H8(1),m3h2x8(:,217),heltab2x16(:,:,217))
  call Hloop_Q_A(ntryL,G1H8(1),37,nMT,G2H8(217),n2h8(109))
call HGT_raise_alpha_OLR(G1H16(203),1,1,16)
call HGT_raise_alpha_invQ_OLR(G1H16(203),2,5,16)
  call Hloop_UV_W(ntryL,G1H16(203),-16,ex5(:),16,G2H8(218),m3h2x8(:,218),heltab2x16(:,:,218))
call signflip_OLR(G2H8(218))
  call Hloop_QV_A(ntryL,G1H16(205),ex3(:),G1H8(1),m3h2x8(:,219),heltab2x16(:,:,219))
  call Hloop_Q_A(ntryL,G1H8(1),37,nMT,G2H8(219),n2h8(110))
  call Hloop_QV_A(ntryL,G1H16(206),ex3(:),G1H8(1),m3h2x8(:,220),heltab2x16(:,:,220))
  call Hloop_Q_A(ntryL,G1H8(1),37,nMT,G2H8(220),n2h8(111))
  call Hloop_QV_A(ntryL,G1H16(207),ex3(:),G1H8(1),m3h2x8(:,221),heltab2x16(:,:,221))
  call Hloop_Q_A(ntryL,G1H8(1),37,nMT,G2H8(221),n2h8(112))
  call Hloop_QV_A(ntryL,G1H16(22),ex3(:),G1H8(1),m3h2x8(:,222),heltab2x16(:,:,222))
  call Hloop_Q_A(ntryL,G1H8(1),37,nMT,G2H8(222),n2h8(113))
call HGT_raise_alpha_OLR(G1H16(208),1,1,16)
call HGT_raise_alpha_invQ_OLR(G1H16(208),2,5,16)
  call Hloop_UV_W(ntryL,G1H16(208),-8,ex4(:),8,G2H8(223),m3h2x8(:,223),heltab2x16(:,:,223))
call signflip_OLR(G2H8(223))
  call Hloop_QV_A(ntryL,G1H16(210),ex3(:),G1H8(1),m3h2x8(:,224),heltab2x16(:,:,224))
  call Hloop_Q_A(ntryL,G1H8(1),37,nMT,G2H8(224),n2h8(114))
  call Hloop_QV_A(ntryL,G1H16(211),ex3(:),G1H8(1),m3h2x8(:,225),heltab2x16(:,:,225))
  call Hloop_Q_A(ntryL,G1H8(1),37,nMT,G2H8(225),n2h8(115))
  call Hloop_QV_A(ntryL,G1H16(212),ex3(:),G1H8(1),m3h2x8(:,226),heltab2x16(:,:,226))
  call Hloop_Q_A(ntryL,G1H8(1),37,nMT,G2H8(226),n2h8(116))
  call Hloop_QV_A(ntryL,G1H16(213),ex3(:),G1H8(1),m3h2x8(:,227),heltab2x16(:,:,227))
  call Hloop_Q_A(ntryL,G1H8(1),37,nMT,G2H8(227),n2h8(117))
call HGT_raise_alpha_OLR(G1H16(214),1,1,16)
call HGT_raise_alpha_invQ_OLR(G1H16(214),2,5,16)
  call Hloop_UV_W(ntryL,G1H16(214),-16,ex5(:),16,G2H8(228),m3h2x8(:,228),heltab2x16(:,:,228))
call signflip_OLR(G2H8(228))
  call Hloop_QV_A(ntryL,G1H16(216),ex3(:),G1H8(1),m3h2x8(:,229),heltab2x16(:,:,229))
  call Hloop_Q_A(ntryL,G1H8(1),37,nMT,G2H8(229),n2h8(118))
  call Hloop_QV_A(ntryL,G1H16(217),ex3(:),G1H8(1),m3h2x8(:,230),heltab2x16(:,:,230))
  call Hloop_Q_A(ntryL,G1H8(1),37,nMT,G2H8(230),n2h8(119))
  call Hloop_QV_A(ntryL,G1H16(218),ex3(:),G1H8(1),m3h2x8(:,231),heltab2x16(:,:,231))
  call Hloop_Q_A(ntryL,G1H8(1),37,nMT,G2H8(231),n2h8(120))
  call Hloop_QV_A(ntryL,G1H16(23),ex3(:),G1H8(1),m3h2x8(:,232),heltab2x16(:,:,232))
  call Hloop_Q_A(ntryL,G1H8(1),37,nMT,G2H8(232),n2h8(121))
call HGT_raise_alpha_OLR(G1H16(219),1,1,16)
call HGT_raise_alpha_invQ_OLR(G1H16(219),2,5,16)
  call Hloop_UV_W(ntryL,G1H16(219),-8,ex4(:),8,G2H8(233),m3h2x8(:,233),heltab2x16(:,:,233))
call signflip_OLR(G2H8(233))
  call Hloop_QV_A(ntryL,G1H16(221),ex3(:),G1H8(1),m3h2x8(:,234),heltab2x16(:,:,234))
  call Hloop_Q_A(ntryL,G1H8(1),37,nMT,G2H8(234),n2h8(122))
  call Hloop_QV_A(ntryL,G1H16(222),ex3(:),G1H8(1),m3h2x8(:,235),heltab2x16(:,:,235))
  call Hloop_Q_A(ntryL,G1H8(1),37,nMT,G2H8(235),n2h8(123))
  call Hloop_QV_A(ntryL,G1H16(223),ex3(:),G1H8(1),m3h2x8(:,236),heltab2x16(:,:,236))
  call Hloop_Q_A(ntryL,G1H8(1),37,nMT,G2H8(236),n2h8(124))
  call Hloop_QV_A(ntryL,G1H16(24),ex3(:),G1H8(1),m3h2x8(:,237),heltab2x16(:,:,237))
  call Hloop_Q_A(ntryL,G1H8(1),37,nMT,G2H8(237),n2h8(125))
call HGT_raise_alpha_OLR(G1H16(224),1,1,16)
call HGT_raise_alpha_invQ_OLR(G1H16(224),2,5,16)
  call Hloop_VA_Q(ntryL,G1H16(224),ex2(:),G1H8(1),m3h2x8(:,238),heltab2x16(:,:,238))
  call Hloop_QV_A(ntryL,G1H16(226),ex3(:),G1H8(2),m3h2x8(:,239),heltab2x16(:,:,239))
  call Hloop_Q_A(ntryL,G1H8(2),37,nMT,G2H8(238),n2h8(126))
  call Hloop_QV_A(ntryL,G1H16(227),ex3(:),G1H8(2),m3h2x8(:,240),heltab2x16(:,:,240))
  call Hloop_Q_A(ntryL,G1H8(2),37,nMT,G2H8(239),n2h8(127))
  call Hloop_QV_A(ntryL,G1H16(228),ex3(:),G1H8(2),m3h2x8(:,241),heltab2x16(:,:,241))
  call Hloop_Q_A(ntryL,G1H8(2),37,nMT,G2H8(240),n2h8(128))
  call Hloop_QV_A(ntryL,G1H16(25),ex3(:),G1H8(2),m3h2x8(:,242),heltab2x16(:,:,242))
  call Hloop_Q_A(ntryL,G1H8(2),37,nMT,G2H8(241),n2h8(129))
call HGT_raise_alpha_OLR(G1H16(229),1,1,16)
call HGT_raise_alpha_invQ_OLR(G1H16(229),2,5,16)
  call Hloop_VA_Q(ntryL,G1H16(229),ex2(:),G1H8(2),m3h2x8(:,243),heltab2x16(:,:,243))
  call Hloop_QV_A(ntryL,G1H16(231),ex3(:),G1H8(3),m3h2x8(:,244),heltab2x16(:,:,244))
  call Hloop_Q_A(ntryL,G1H8(3),37,nMT,G2H8(242),n2h8(130))
  call Hloop_QV_A(ntryL,G1H16(232),ex3(:),G1H8(3),m3h2x8(:,245),heltab2x16(:,:,245))
  call Hloop_Q_A(ntryL,G1H8(3),37,nMT,G2H8(243),n2h8(131))
  call Hloop_QV_A(ntryL,G1H16(233),ex3(:),G1H8(3),m3h2x8(:,246),heltab2x16(:,:,246))
  call Hloop_Q_A(ntryL,G1H8(3),37,nMT,G2H8(244),n2h8(132))
  call Hloop_VA_Q(ntryL,G1H16(26),ex2(:),G1H8(3),m3h2x8(:,247),heltab2x16(:,:,247))
  call Hloop_A_Q(ntryL,G1H8(3),38,nMT,G2H8(245),n2h8(133))
call HGT_raise_alpha_OLR(G1H16(234),1,1,16)
call HGT_raise_alpha_invQ_OLR(G1H16(234),2,5,16)
  call Hloop_UV_W(ntryL,G1H16(234),-16,ex5(:),16,G2H8(246),m3h2x8(:,248),heltab2x16(:,:,248))
call signflip_OLR(G2H8(246))
  call Hloop_VA_Q(ntryL,G1H16(236),ex2(:),G1H8(3),m3h2x8(:,249),heltab2x16(:,:,249))
  call Hloop_A_Q(ntryL,G1H8(3),38,nMT,G2H8(247),n2h8(134))
  call Hloop_VA_Q(ntryL,G1H16(237),ex2(:),G1H8(3),m3h2x8(:,250),heltab2x16(:,:,250))
  call Hloop_A_Q(ntryL,G1H8(3),38,nMT,G2H8(248),n2h8(135))
  call Hloop_VA_Q(ntryL,G1H16(238),ex2(:),G1H8(3),m3h2x8(:,251),heltab2x16(:,:,251))
  call Hloop_A_Q(ntryL,G1H8(3),38,nMT,G2H8(249),n2h8(136))
  call Hloop_VA_Q(ntryL,G1H16(239),ex2(:),G1H8(3),m3h2x8(:,252),heltab2x16(:,:,252))
  call Hloop_A_Q(ntryL,G1H8(3),38,nMT,G2H8(250),n2h8(137))
call HGT_raise_alpha_OLR(G1H16(240),1,1,16)
call HGT_raise_alpha_invQ_OLR(G1H16(240),2,5,16)
  call Hloop_UV_W(ntryL,G1H16(240),-8,ex4(:),8,G2H8(251),m3h2x8(:,253),heltab2x16(:,:,253))
call signflip_OLR(G2H8(251))
  call Hloop_VA_Q(ntryL,G1H16(242),ex2(:),G1H8(3),m3h2x8(:,254),heltab2x16(:,:,254))
  call Hloop_A_Q(ntryL,G1H8(3),38,nMT,G2H8(252),n2h8(138))
  call Hloop_VA_Q(ntryL,G1H16(243),ex2(:),G1H8(3),m3h2x8(:,255),heltab2x16(:,:,255))
  call Hloop_A_Q(ntryL,G1H8(3),38,nMT,G2H8(253),n2h8(139))
  call Hloop_VA_Q(ntryL,G1H16(244),ex2(:),G1H8(3),m3h2x8(:,256),heltab2x16(:,:,256))
  call Hloop_A_Q(ntryL,G1H8(3),38,nMT,G2H8(254),n2h8(140))
  call Hloop_AV_Q(ntryL,G1H16(245),ex3(:),G1H8(3),m3h2x8(:,257),heltab2x16(:,:,257))
  call Hloop_A_Q(ntryL,G1H8(3),38,nMT,G2H8(255),n2h8(141))
call HGT_raise_alpha_OLR(G1H16(246),1,1,16)
call HGT_raise_alpha_invQ_OLR(G1H16(246),2,5,16)
  call Hloop_UV_W(ntryL,G1H16(246),-16,ex5(:),16,G2H8(256),m3h2x8(:,258),heltab2x16(:,:,258))
call signflip_OLR(G2H8(256))
  call Hloop_AV_Q(ntryL,G1H16(248),ex3(:),G1H8(3),m3h2x8(:,259),heltab2x16(:,:,259))
  call Hloop_A_Q(ntryL,G1H8(3),38,nMT,G2H8(257),n2h8(142))
  call Hloop_AV_Q(ntryL,G1H16(249),ex3(:),G1H8(3),m3h2x8(:,260),heltab2x16(:,:,260))
  call Hloop_A_Q(ntryL,G1H8(3),38,nMT,G2H8(258),n2h8(143))
  call Hloop_AV_Q(ntryL,G1H16(250),ex3(:),G1H8(3),m3h2x8(:,261),heltab2x16(:,:,261))
  call Hloop_A_Q(ntryL,G1H8(3),38,nMT,G2H8(259),n2h8(144))
  call Hloop_AV_Q(ntryL,G1H16(27),ex3(:),G1H8(3),m3h2x8(:,262),heltab2x16(:,:,262))
  call Hloop_A_Q(ntryL,G1H8(3),38,nMT,G2H8(260),n2h8(145))
call HGT_raise_alpha_OLR(G1H16(28),1,1,16)
call HGT_raise_alpha_invQ_OLR(G1H16(28),2,5,16)
  call Hloop_UV_W(ntryL,G1H16(28),-8,ex4(:),8,G2H8(261),m3h2x8(:,263),heltab2x16(:,:,263))
call signflip_OLR(G2H8(261))
  call Hloop_AV_Q(ntryL,G1H16(252),ex3(:),G1H8(3),m3h2x8(:,264),heltab2x16(:,:,264))
  call Hloop_A_Q(ntryL,G1H8(3),38,nMT,G2H8(262),n2h8(146))
  call Hloop_AV_Q(ntryL,G1H16(253),ex3(:),G1H8(3),m3h2x8(:,265),heltab2x16(:,:,265))
  call Hloop_A_Q(ntryL,G1H8(3),38,nMT,G2H8(263),n2h8(147))
  call Hloop_AV_Q(ntryL,G1H16(254),ex3(:),G1H8(3),m3h2x8(:,266),heltab2x16(:,:,266))
  call Hloop_A_Q(ntryL,G1H8(3),38,nMT,G2H8(264),n2h8(148))
  call Hloop_AV_Q(ntryL,G1H16(29),ex4(:),G1H8(3),m3h2x8(:,267),heltab2x16(:,:,267))
  call Hloop_A_Q(ntryL,G1H8(3),42,nMT,G2H8(265),n2h8(149))
call HGT_raise_alpha_OLR(G1H16(255),1,1,16)
call HGT_raise_alpha_invQ_OLR(G1H16(255),2,5,16)
  call Hloop_UV_W(ntryL,G1H16(255),-4,ex3(:),4,G2H8(266),m3h2x8(:,268),heltab2x16(:,:,268))
call signflip_OLR(G2H8(266))
  call Hloop_AV_Q(ntryL,G1H16(257),ex4(:),G1H8(3),m3h2x8(:,269),heltab2x16(:,:,269))
  call Hloop_A_Q(ntryL,G1H8(3),42,nMT,G2H8(267),n2h8(150))
  call Hloop_AV_Q(ntryL,G1H16(258),ex4(:),G1H8(3),m3h2x8(:,270),heltab2x16(:,:,270))
  call Hloop_A_Q(ntryL,G1H8(3),42,nMT,G2H8(268),n2h8(151))
  call Hloop_AV_Q(ntryL,G1H16(259),ex4(:),G1H8(3),m3h2x8(:,271),heltab2x16(:,:,271))
  call Hloop_A_Q(ntryL,G1H8(3),42,nMT,G2H8(269),n2h8(152))
  call Hloop_AV_Q(ntryL,G1H16(30),ex5(:),G1H8(3),m3h2x8(:,272),heltab2x16(:,:,272))
  call Hloop_A_Q(ntryL,G1H8(3),50,nMT,G2H8(270),n2h8(153))
call HGT_raise_alpha_OLR(G1H16(260),1,1,16)
call HGT_raise_alpha_invQ_OLR(G1H16(260),2,5,16)
  call Hloop_UV_W(ntryL,G1H16(260),-4,ex3(:),4,G2H8(271),m3h2x8(:,273),heltab2x16(:,:,273))
call signflip_OLR(G2H8(271))
  call Hloop_AV_Q(ntryL,G1H16(262),ex5(:),G1H8(3),m3h2x8(:,274),heltab2x16(:,:,274))
  call Hloop_A_Q(ntryL,G1H8(3),50,nMT,G2H8(272),n2h8(154))
  call Hloop_AV_Q(ntryL,G1H16(263),ex5(:),G1H8(3),m3h2x8(:,275),heltab2x16(:,:,275))
  call Hloop_A_Q(ntryL,G1H8(3),50,nMT,G2H8(273),n2h8(155))
  call Hloop_AV_Q(ntryL,G1H16(264),ex5(:),G1H8(3),m3h2x8(:,276),heltab2x16(:,:,276))
  call Hloop_A_Q(ntryL,G1H8(3),50,nMT,G2H8(274),n2h8(156))
  call Hloop_QV_A(ntryL,G1H16(31),ex4(:),G1H8(3),m3h2x8(:,277),heltab2x16(:,:,277))
  call Hloop_Q_A(ntryL,G1H8(3),41,nMT,G2H8(275),n2h8(157))
call HGT_raise_alpha_OLR(G1H16(265),1,1,16)
call HGT_raise_alpha_invQ_OLR(G1H16(265),2,5,16)
  call Hloop_UV_W(ntryL,G1H16(265),-16,ex5(:),16,G2H8(276),m3h2x8(:,278),heltab2x16(:,:,278))
call signflip_OLR(G2H8(276))
  call Hloop_QV_A(ntryL,G1H16(267),ex4(:),G1H8(3),m3h2x8(:,279),heltab2x16(:,:,279))
  call Hloop_Q_A(ntryL,G1H8(3),41,nMT,G2H8(277),n2h8(158))
  call Hloop_QV_A(ntryL,G1H16(268),ex4(:),G1H8(3),m3h2x8(:,280),heltab2x16(:,:,280))
  call Hloop_Q_A(ntryL,G1H8(3),41,nMT,G2H8(278),n2h8(159))
  call Hloop_QV_A(ntryL,G1H16(269),ex4(:),G1H8(3),m3h2x8(:,281),heltab2x16(:,:,281))
  call Hloop_Q_A(ntryL,G1H8(3),41,nMT,G2H8(279),n2h8(160))
  call Hloop_QV_A(ntryL,G1H16(270),ex4(:),G1H8(3),m3h2x8(:,282),heltab2x16(:,:,282))
  call Hloop_Q_A(ntryL,G1H8(3),41,nMT,G2H8(280),n2h8(161))
call HGT_raise_alpha_OLR(G1H16(271),1,1,16)
call HGT_raise_alpha_invQ_OLR(G1H16(271),2,5,16)
  call Hloop_UV_W(ntryL,G1H16(271),-16,ex5(:),16,G2H8(281),m3h2x8(:,283),heltab2x16(:,:,283))
call signflip_OLR(G2H8(281))
  call Hloop_QV_A(ntryL,G1H16(273),ex4(:),G1H8(3),m3h2x8(:,284),heltab2x16(:,:,284))
  call Hloop_Q_A(ntryL,G1H8(3),41,nMT,G2H8(282),n2h8(162))
  call Hloop_QV_A(ntryL,G1H16(274),ex4(:),G1H8(3),m3h2x8(:,285),heltab2x16(:,:,285))
  call Hloop_Q_A(ntryL,G1H8(3),41,nMT,G2H8(283),n2h8(163))
  call Hloop_QV_A(ntryL,G1H16(275),ex4(:),G1H8(3),m3h2x8(:,286),heltab2x16(:,:,286))
  call Hloop_Q_A(ntryL,G1H8(3),41,nMT,G2H8(284),n2h8(164))
  call Hloop_QV_A(ntryL,G1H16(32),ex4(:),G1H8(3),m3h2x8(:,287),heltab2x16(:,:,287))
  call Hloop_Q_A(ntryL,G1H8(3),41,nMT,G2H8(285),n2h8(165))
call HGT_raise_alpha_OLR(G1H16(276),1,1,16)
call HGT_raise_alpha_invQ_OLR(G1H16(276),2,5,16)
  call Hloop_UV_W(ntryL,G1H16(276),-4,ex3(:),4,G2H8(286),m3h2x8(:,288),heltab2x16(:,:,288))
call signflip_OLR(G2H8(286))
  call Hloop_QV_A(ntryL,G1H16(278),ex4(:),G1H8(3),m3h2x8(:,289),heltab2x16(:,:,289))
  call Hloop_Q_A(ntryL,G1H8(3),41,nMT,G2H8(287),n2h8(166))
  call Hloop_QV_A(ntryL,G1H16(279),ex4(:),G1H8(3),m3h2x8(:,290),heltab2x16(:,:,290))
  call Hloop_Q_A(ntryL,G1H8(3),41,nMT,G2H8(288),n2h8(167))
  call Hloop_QV_A(ntryL,G1H16(280),ex4(:),G1H8(3),m3h2x8(:,291),heltab2x16(:,:,291))
  call Hloop_Q_A(ntryL,G1H8(3),41,nMT,G2H8(289),n2h8(168))
  call Hloop_QV_A(ntryL,G1H16(33),ex4(:),G1H8(3),m3h2x8(:,292),heltab2x16(:,:,292))
  call Hloop_Q_A(ntryL,G1H8(3),41,nMT,G2H8(290),n2h8(169))
call HGT_raise_alpha_OLR(G1H16(281),1,1,16)
call HGT_raise_alpha_invQ_OLR(G1H16(281),2,5,16)
  call Hloop_VA_Q(ntryL,G1H16(281),ex2(:),G1H8(3),m3h2x8(:,293),heltab2x16(:,:,293))
  call Hloop_QV_A(ntryL,G1H16(283),ex4(:),G1H8(4),m3h2x8(:,294),heltab2x16(:,:,294))
  call Hloop_Q_A(ntryL,G1H8(4),41,nMT,G2H8(291),n2h8(170))
  call Hloop_QV_A(ntryL,G1H16(284),ex4(:),G1H8(4),m3h2x8(:,295),heltab2x16(:,:,295))
  call Hloop_Q_A(ntryL,G1H8(4),41,nMT,G2H8(292),n2h8(171))
  call Hloop_QV_A(ntryL,G1H16(285),ex4(:),G1H8(4),m3h2x8(:,296),heltab2x16(:,:,296))
  call Hloop_Q_A(ntryL,G1H8(4),41,nMT,G2H8(293),n2h8(172))
  call Hloop_QV_A(ntryL,G1H16(34),ex4(:),G1H8(4),m3h2x8(:,297),heltab2x16(:,:,297))
  call Hloop_Q_A(ntryL,G1H8(4),41,nMT,G2H8(294),n2h8(173))
call HGT_raise_alpha_OLR(G1H16(35),1,1,16)
call HGT_raise_alpha_invQ_OLR(G1H16(35),2,5,16)
  call Hloop_UV_W(ntryL,G1H16(35),-4,ex3(:),4,G2H8(295),m3h2x8(:,298),heltab2x16(:,:,298))
call signflip_OLR(G2H8(295))
  call Hloop_QV_A(ntryL,G1H16(287),ex4(:),G1H8(4),m3h2x8(:,299),heltab2x16(:,:,299))
  call Hloop_Q_A(ntryL,G1H8(4),41,nMT,G2H8(296),n2h8(174))
  call Hloop_QV_A(ntryL,G1H16(288),ex4(:),G1H8(4),m3h2x8(:,300),heltab2x16(:,:,300))
  call Hloop_Q_A(ntryL,G1H8(4),41,nMT,G2H8(297),n2h8(175))
  call Hloop_QV_A(ntryL,G1H16(289),ex4(:),G1H8(4),m3h2x8(:,301),heltab2x16(:,:,301))
  call Hloop_Q_A(ntryL,G1H8(4),41,nMT,G2H8(298),n2h8(176))
  call Hloop_QV_A(ntryL,G1H16(290),ex4(:),G1H8(4),m3h2x8(:,302),heltab2x16(:,:,302))
  call Hloop_Q_A(ntryL,G1H8(4),41,nMT,G2H8(299),n2h8(177))
call HGT_raise_alpha_OLR(G1H16(291),1,1,16)
call HGT_raise_alpha_invQ_OLR(G1H16(291),2,5,16)
  call Hloop_VA_Q(ntryL,G1H16(291),ex2(:),G1H8(4),m3h2x8(:,303),heltab2x16(:,:,303))
  call Hloop_QV_A(ntryL,G1H16(293),ex4(:),G1H8(5),m3h2x8(:,304),heltab2x16(:,:,304))
  call Hloop_Q_A(ntryL,G1H8(5),41,nMT,G2H8(300),n2h8(178))
  call Hloop_QV_A(ntryL,G1H16(294),ex4(:),G1H8(5),m3h2x8(:,305),heltab2x16(:,:,305))
  call Hloop_Q_A(ntryL,G1H8(5),41,nMT,G2H8(301),n2h8(179))
  call Hloop_QV_A(ntryL,G1H16(295),ex4(:),G1H8(5),m3h2x8(:,306),heltab2x16(:,:,306))
  call Hloop_Q_A(ntryL,G1H8(5),41,nMT,G2H8(302),n2h8(180))
  call Hloop_QV_A(ntryL,G1H16(36),ex5(:),G1H8(5),m3h2x8(:,307),heltab2x16(:,:,307))
  call Hloop_Q_A(ntryL,G1H8(5),49,nMT,G2H8(303),n2h8(181))
call HGT_raise_alpha_OLR(G1H16(296),1,1,16)
call HGT_raise_alpha_invQ_OLR(G1H16(296),2,5,16)
  call Hloop_UV_W(ntryL,G1H16(296),-8,ex4(:),8,G2H8(304),m3h2x8(:,308),heltab2x16(:,:,308))
call signflip_OLR(G2H8(304))
  call Hloop_QV_A(ntryL,G1H16(298),ex5(:),G1H8(5),m3h2x8(:,309),heltab2x16(:,:,309))
  call Hloop_Q_A(ntryL,G1H8(5),49,nMT,G2H8(305),n2h8(182))
  call Hloop_QV_A(ntryL,G1H16(299),ex5(:),G1H8(5),m3h2x8(:,310),heltab2x16(:,:,310))
  call Hloop_Q_A(ntryL,G1H8(5),49,nMT,G2H8(306),n2h8(183))
  call Hloop_QV_A(ntryL,G1H16(300),ex5(:),G1H8(5),m3h2x8(:,311),heltab2x16(:,:,311))
  call Hloop_Q_A(ntryL,G1H8(5),49,nMT,G2H8(307),n2h8(184))
  call Hloop_QV_A(ntryL,G1H16(37),ex5(:),G1H8(5),m3h2x8(:,312),heltab2x16(:,:,312))
  call Hloop_Q_A(ntryL,G1H8(5),49,nMT,G2H8(308),n2h8(185))
call HGT_raise_alpha_OLR(G1H16(301),1,1,16)
call HGT_raise_alpha_invQ_OLR(G1H16(301),2,5,16)
  call Hloop_UV_W(ntryL,G1H16(301),-4,ex3(:),4,G2H8(309),m3h2x8(:,313),heltab2x16(:,:,313))
call signflip_OLR(G2H8(309))
  call Hloop_QV_A(ntryL,G1H16(303),ex5(:),G1H8(5),m3h2x8(:,314),heltab2x16(:,:,314))
  call Hloop_Q_A(ntryL,G1H8(5),49,nMT,G2H8(310),n2h8(186))
  call Hloop_QV_A(ntryL,G1H16(304),ex5(:),G1H8(5),m3h2x8(:,315),heltab2x16(:,:,315))
  call Hloop_Q_A(ntryL,G1H8(5),49,nMT,G2H8(311),n2h8(187))
  call Hloop_QV_A(ntryL,G1H16(305),ex5(:),G1H8(5),m3h2x8(:,316),heltab2x16(:,:,316))
  call Hloop_Q_A(ntryL,G1H8(5),49,nMT,G2H8(312),n2h8(188))
  call Hloop_QV_A(ntryL,G1H16(38),ex5(:),G1H8(5),m3h2x8(:,317),heltab2x16(:,:,317))
  call Hloop_Q_A(ntryL,G1H8(5),49,nMT,G2H8(313),n2h8(189))
call HGT_raise_alpha_OLR(G1H16(39),1,1,16)
call HGT_raise_alpha_invQ_OLR(G1H16(39),2,5,16)
  call Hloop_UV_W(ntryL,G1H16(39),-8,ex4(:),8,G2H8(314),m3h2x8(:,318),heltab2x16(:,:,318))
call signflip_OLR(G2H8(314))
  call Hloop_QV_A(ntryL,G1H16(307),ex5(:),G1H8(5),m3h2x8(:,319),heltab2x16(:,:,319))
  call Hloop_Q_A(ntryL,G1H8(5),49,nMT,G2H8(315),n2h8(190))
  call Hloop_QV_A(ntryL,G1H16(308),ex5(:),G1H8(5),m3h2x8(:,320),heltab2x16(:,:,320))
  call Hloop_Q_A(ntryL,G1H8(5),49,nMT,G2H8(316),n2h8(191))
  call Hloop_QV_A(ntryL,G1H16(309),ex5(:),G1H8(5),m3h2x8(:,321),heltab2x16(:,:,321))
  call Hloop_Q_A(ntryL,G1H8(5),49,nMT,G2H8(317),n2h8(192))
  call Hloop_QV_A(ntryL,G1H16(310),ex5(:),G1H8(5),m3h2x8(:,322),heltab2x16(:,:,322))
  call Hloop_Q_A(ntryL,G1H8(5),49,nMT,G2H8(318),n2h8(193))
call HGT_raise_alpha_OLR(G1H16(311),1,1,16)
call HGT_raise_alpha_invQ_OLR(G1H16(311),2,5,16)
  call Hloop_VA_Q(ntryL,G1H16(311),ex2(:),G1H8(5),m3h2x8(:,323),heltab2x16(:,:,323))
  call Hloop_QV_A(ntryL,G1H16(313),ex5(:),G1H8(6),m3h2x8(:,324),heltab2x16(:,:,324))
  call Hloop_Q_A(ntryL,G1H8(6),49,nMT,G2H8(319),n2h8(194))
  call Hloop_QV_A(ntryL,G1H16(314),ex5(:),G1H8(6),m3h2x8(:,325),heltab2x16(:,:,325))
  call Hloop_Q_A(ntryL,G1H8(6),49,nMT,G2H8(320),n2h8(195))
  call Hloop_QV_A(ntryL,G1H16(315),ex5(:),G1H8(6),m3h2x8(:,326),heltab2x16(:,:,326))
  call Hloop_Q_A(ntryL,G1H8(6),49,nMT,G2H8(321),n2h8(196))
  call Hloop_QV_A(ntryL,G1H16(40),ex5(:),G1H8(6),m3h2x8(:,327),heltab2x16(:,:,327))
  call Hloop_Q_A(ntryL,G1H8(6),49,nMT,G2H8(322),n2h8(197))
call HGT_raise_alpha_OLR(G1H16(41),1,1,16)
call HGT_raise_alpha_invQ_OLR(G1H16(41),2,5,16)
  call Hloop_UV_W(ntryL,G1H16(41),-4,ex3(:),4,G2H8(323),m3h2x8(:,328),heltab2x16(:,:,328))
call signflip_OLR(G2H8(323))
  call Hloop_QV_A(ntryL,G1H16(317),ex5(:),G1H8(6),m3h2x8(:,329),heltab2x16(:,:,329))
  call Hloop_Q_A(ntryL,G1H8(6),49,nMT,G2H8(324),n2h8(198))
  call Hloop_QV_A(ntryL,G1H16(318),ex5(:),G1H8(6),m3h2x8(:,330),heltab2x16(:,:,330))
  call Hloop_Q_A(ntryL,G1H8(6),49,nMT,G2H8(325),n2h8(199))
  call Hloop_QV_A(ntryL,G1H16(319),ex5(:),G1H8(6),m3h2x8(:,331),heltab2x16(:,:,331))
  call Hloop_Q_A(ntryL,G1H8(6),49,nMT,G2H8(326),n2h8(200))
  call Hloop_QV_A(ntryL,G1H16(320),ex5(:),G1H8(6),m3h2x8(:,332),heltab2x16(:,:,332))
  call Hloop_Q_A(ntryL,G1H8(6),49,nMT,G2H8(327),n2h8(201))
call HGT_raise_alpha_OLR(G1H16(321),1,1,16)
call HGT_raise_alpha_invQ_OLR(G1H16(321),2,5,16)
  call Hloop_VA_Q(ntryL,G1H16(321),ex2(:),G1H8(6),m3h2x8(:,333),heltab2x16(:,:,333))
  call Hloop_QV_A(ntryL,G1H16(323),ex5(:),G1H8(7),m3h2x8(:,334),heltab2x16(:,:,334))
  call Hloop_Q_A(ntryL,G1H8(7),49,nMT,G2H8(328),n2h8(202))
  call Hloop_QV_A(ntryL,G1H16(324),ex5(:),G1H8(7),m3h2x8(:,335),heltab2x16(:,:,335))
  call Hloop_Q_A(ntryL,G1H8(7),49,nMT,G2H8(329),n2h8(203))
  call Hloop_QV_A(ntryL,G1H16(325),ex5(:),G1H8(7),m3h2x8(:,336),heltab2x16(:,:,336))
  call Hloop_Q_A(ntryL,G1H8(7),49,nMT,G2H8(330),n2h8(204))
  call Hotf_5pt_reduction(G2H8(1),RedSet_5(1),mass5set(:,7),  & 
G1H8(7),G1H8(8),G1H8(9),G1H8(10),G1H8(11),G1H8(12),8)
  call HG1shiftOLR(G1H8(8),16,8)
  call Hotf_5pt_reduction(G2H8(2),RedSet_5(2),mass5set(:,7),  & 
G1H8(13),G1H8(14),G1H8(15),G1H8(16),G1H8(17),G1H8(18),8)
  call HG1shiftOLR(G1H8(14),16,8)
  call Hotf_5pt_reduction(G2H8(3),RedSet_5(2),mass5set(:,7),  & 
G1H8(19),G1H8(20),G1H8(21),G1H8(22),G1H8(23),G1H8(24),8)
  call HG1shiftOLR(G1H8(20),8,8)
  call Hotf_5pt_reduction(G2H8(4),RedSet_5(35),mass5set(:,8),  & 
G1H8(25),G1H8(26),G1H8(27),G1H8(28),G1H8(29),G1H8(30),8)
  call HG1shiftOLR(G1H8(26),16,8)
  call Hotf_5pt_reduction(G2H8(5),RedSet_5(35),mass5set(:,9),  & 
G1H8(31),G1H8(32),G1H8(33),G1H8(34),G1H8(35),G1H8(36),8)
  call HG1shiftOLR(G1H8(32),16,8)
  call Hotf_5pt_reduction(G2H8(6),RedSet_5(35),mass5set(:,8),  & 
G1H8(37),G1H8(38),G1H8(39),G1H8(40),G1H8(41),G1H8(42),8)
  call HG1shiftOLR(G1H8(38),8,8)
  call Hotf_5pt_reduction(G2H8(7),RedSet_5(35),mass5set(:,9),  & 
G1H8(43),G1H8(44),G1H8(45),G1H8(46),G1H8(47),G1H8(48),8)
  call HG1shiftOLR(G1H8(44),8,8)
  call Hotf_5pt_reduction(G2H8(8),RedSet_5(4),mass5set(:,7),  & 
G1H8(49),G1H8(50),G1H8(51),G1H8(52),G1H8(53),G1H8(54),8)
  call HG1shiftOLR(G1H8(50),16,8)
  call Hotf_5pt_reduction(G2H8(9),RedSet_5(5),mass5set(:,7),  & 
G1H8(55),G1H8(56),G1H8(57),G1H8(58),G1H8(59),G1H8(60),8)
  call HG1shiftOLR(G1H8(56),16,8)
  call Hotf_5pt_reduction(G2H8(10),RedSet_5(36),mass5set(:,8),  & 
G1H8(61),G1H8(62),G1H8(63),G1H8(64),G1H8(65),G1H8(66),8)
  call HG1shiftOLR(G1H8(62),16,8)
  call Hotf_5pt_reduction(G2H8(11),RedSet_5(36),mass5set(:,9),  & 
G1H8(67),G1H8(68),G1H8(69),G1H8(70),G1H8(71),G1H8(72),8)
  call HG1shiftOLR(G1H8(68),16,8)
  call Hotf_5pt_reduction(G2H8(12),RedSet_5(36),mass5set(:,8),  & 
G1H8(73),G1H8(74),G1H8(75),G1H8(76),G1H8(77),G1H8(78),8)
  call HG1shiftOLR(G1H8(74),4,8)
  call Hotf_5pt_reduction(G2H8(13),RedSet_5(36),mass5set(:,9),  & 
G1H8(79),G1H8(80),G1H8(81),G1H8(82),G1H8(83),G1H8(84),8)
  call HG1shiftOLR(G1H8(80),4,8)
  call Hotf_5pt_reduction(G2H8(14),RedSet_5(5),mass5set(:,7),  & 
G1H8(85),G1H8(86),G1H8(87),G1H8(88),G1H8(89),G1H8(90),8)
  call HG1shiftOLR(G1H8(86),8,8)
  call Hotf_5pt_reduction(G2H8(15),RedSet_5(37),mass5set(:,8),  & 
G1H8(91),G1H8(92),G1H8(93),G1H8(94),G1H8(95),G1H8(96),8)
  call HG1shiftOLR(G1H8(92),8,8)
  call Hotf_5pt_reduction(G2H8(16),RedSet_5(37),mass5set(:,9),  & 
G1H8(97),G1H8(98),G1H8(99),G1H8(100),G1H8(101),G1H8(102),8)
  call HG1shiftOLR(G1H8(98),8,8)
  call Hotf_5pt_reduction(G2H8(17),RedSet_5(37),mass5set(:,8),  & 
G1H8(103),G1H8(104),G1H8(105),G1H8(106),G1H8(107),G1H8(108),8)
  call HG1shiftOLR(G1H8(104),4,8)
  call Hotf_5pt_reduction(G2H8(18),RedSet_5(37),mass5set(:,9),  & 
G1H8(109),G1H8(110),G1H8(111),G1H8(112),G1H8(113),G1H8(114),8)
  call HG1shiftOLR(G1H8(110),4,8)
  call Hotf_5pt_reduction(G2H8(19),RedSet_5(38),mass5set(:,8),  & 
G1H8(115),G1H8(116),G1H8(117),G1H8(118),G1H8(119),G1H8(120),8)
  call HG1shiftOLR(G1H8(116),16,8)
  call Hotf_5pt_reduction(G2H8(20),RedSet_5(38),mass5set(:,9),  & 
G1H8(121),G1H8(122),G1H8(123),G1H8(124),G1H8(125),G1H8(126),8)
  call HG1shiftOLR(G1H8(122),16,8)
  call Hotf_5pt_reduction(G2H8(21),RedSet_5(38),mass5set(:,8),  & 
G1H8(127),G1H8(128),G1H8(129),G1H8(130),G1H8(131),G1H8(132),8)
  call HG1shiftOLR(G1H8(128),8,8)
  call Hotf_5pt_reduction(G2H8(22),RedSet_5(38),mass5set(:,9),  & 
G1H8(133),G1H8(134),G1H8(135),G1H8(136),G1H8(137),G1H8(138),8)
  call HG1shiftOLR(G1H8(134),8,8)
  call Hotf_5pt_reduction(G2H8(23),RedSet_5(39),mass5set(:,8),  & 
G1H8(139),G1H8(140),G1H8(141),G1H8(142),G1H8(143),G1H8(144),8)
  call HG1shiftOLR(G1H8(140),16,8)
  call Hotf_5pt_reduction(G2H8(24),RedSet_5(39),mass5set(:,9),  & 
G1H8(145),G1H8(146),G1H8(147),G1H8(148),G1H8(149),G1H8(150),8)
  call HG1shiftOLR(G1H8(146),16,8)
  call Hotf_5pt_reduction(G2H8(25),RedSet_5(39),mass5set(:,8),  & 
G1H8(151),G1H8(152),G1H8(153),G1H8(154),G1H8(155),G1H8(156),8)
  call HG1shiftOLR(G1H8(152),4,8)
  call Hotf_5pt_reduction(G2H8(26),RedSet_5(39),mass5set(:,9),  & 
G1H8(157),G1H8(158),G1H8(159),G1H8(160),G1H8(161),G1H8(162),8)
  call HG1shiftOLR(G1H8(158),4,8)
  call Hotf_5pt_reduction(G2H8(27),RedSet_5(40),mass5set(:,8),  & 
G1H8(163),G1H8(164),G1H8(165),G1H8(166),G1H8(167),G1H8(168),8)
  call HG1shiftOLR(G1H8(164),8,8)
  call Hotf_5pt_reduction(G2H8(28),RedSet_5(40),mass5set(:,9),  & 
G1H8(169),G1H8(170),G1H8(171),G1H8(172),G1H8(173),G1H8(174),8)
  call HG1shiftOLR(G1H8(170),8,8)
  call Hotf_5pt_reduction(G2H8(29),RedSet_5(40),mass5set(:,8),  & 
G1H8(175),G1H8(176),G1H8(177),G1H8(178),G1H8(179),G1H8(180),8)
  call HG1shiftOLR(G1H8(176),4,8)
  call Hotf_5pt_reduction(G2H8(30),RedSet_5(40),mass5set(:,9),  & 
G1H8(181),G1H8(182),G1H8(183),G1H8(184),G1H8(185),G1H8(186),8)
  call HG1shiftOLR(G1H8(182),4,8)
  call Hotf_5pt_reduction(G2H8(31),RedSet_5(11),mass5set(:,10),  & 
G1H8(187),G1H8(188),G1H8(189),G1H8(190),G1H8(191),G1H8(192),8)
  call HG1shiftOLR(G1H8(188),16,8)
  call Hotf_5pt_reduction(G2H8(32),RedSet_5(12),mass5set(:,11),  & 
G1H8(193),G1H8(194),G1H8(195),G1H8(196),G1H8(197),G1H8(198),8)
  call HG1shiftOLR(G1H8(194),16,8)
  call Hotf_5pt_reduction(G2H8(33),RedSet_5(13),mass5set(:,10),  & 
G1H8(199),G1H8(200),G1H8(201),G1H8(202),G1H8(203),G1H8(204),8)
  call HG1shiftOLR(G1H8(200),16,8)
  call Hotf_5pt_reduction(G2H8(34),RedSet_5(14),mass5set(:,11),  & 
G1H8(205),G1H8(206),G1H8(207),G1H8(208),G1H8(209),G1H8(210),8)
  call HG1shiftOLR(G1H8(206),16,8)
  call Hotf_5pt_reduction(G2H8(35),RedSet_5(15),mass5set(:,12),  & 
G1H8(211),G1H8(212),G1H8(213),G1H8(214),G1H8(215),G1H8(216),8)
  call HG1shiftOLR(G1H8(212),8,8)
  call Hotf_5pt_reduction(G2H8(36),RedSet_5(16),mass5set(:,12),  & 
G1H8(217),G1H8(218),G1H8(219),G1H8(220),G1H8(221),G1H8(222),8)
  call HG1shiftOLR(G1H8(218),4,8)
  call Hotf_5pt_reduction(G2H8(37),RedSet_5(17),mass5set(:,10),  & 
G1H8(223),G1H8(224),G1H8(225),G1H8(226),G1H8(227),G1H8(228),8)
  call HG1shiftOLR(G1H8(224),16,8)
  call Hotf_5pt_reduction(G2H8(38),RedSet_5(12),mass5set(:,11),  & 
G1H8(229),G1H8(230),G1H8(231),G1H8(232),G1H8(233),G1H8(234),8)
  call HG1shiftOLR(G1H8(230),8,8)
  call Hotf_5pt_reduction(G2H8(39),RedSet_5(18),mass5set(:,10),  & 
G1H8(235),G1H8(236),G1H8(237),G1H8(238),G1H8(239),G1H8(240),8)
  call HG1shiftOLR(G1H8(236),8,8)
  call Hotf_5pt_reduction(G2H8(40),RedSet_5(19),mass5set(:,12),  & 
G1H8(241),G1H8(242),G1H8(243),G1H8(244),G1H8(245),G1H8(246),8)
  call HG1shiftOLR(G1H8(242),16,8)
  call Hotf_5pt_reduction(G2H8(41),RedSet_5(20),mass5set(:,12),  & 
G1H8(247),G1H8(248),G1H8(249),G1H8(250),G1H8(251),G1H8(252),8)
  call HG1shiftOLR(G1H8(248),4,8)
  call Hotf_5pt_reduction(G2H8(42),RedSet_5(21),mass5set(:,11),  & 
G1H8(253),G1H8(254),G1H8(255),G1H8(256),G1H8(257),G1H8(258),8)
  call HG1shiftOLR(G1H8(254),8,8)
  call Hotf_5pt_reduction(G2H8(43),RedSet_5(22),mass5set(:,11),  & 
G1H8(259),G1H8(260),G1H8(261),G1H8(262),G1H8(263),G1H8(264),8)
  call HG1shiftOLR(G1H8(260),16,8)
  call Hotf_5pt_reduction(G2H8(44),RedSet_5(22),mass5set(:,11),  & 
G1H8(265),G1H8(266),G1H8(267),G1H8(268),G1H8(269),G1H8(270),8)
  call HG1shiftOLR(G1H8(266),8,8)
  call Hotf_5pt_reduction(G2H8(45),RedSet_5(23),mass5set(:,12),  & 
G1H8(271),G1H8(272),G1H8(273),G1H8(274),G1H8(275),G1H8(276),8)
  call HG1shiftOLR(G1H8(272),16,8)
  call Hotf_5pt_reduction(G2H8(46),RedSet_5(24),mass5set(:,12),  & 
G1H8(277),G1H8(278),G1H8(279),G1H8(280),G1H8(281),G1H8(282),8)
  call HG1shiftOLR(G1H8(278),8,8)
  call Hotf_5pt_reduction(G2H8(47),RedSet_5(24),mass5set(:,12),  & 
G1H8(283),G1H8(284),G1H8(285),G1H8(286),G1H8(287),G1H8(288),8)
  call HG1shiftOLR(G1H8(284),2,8)
  call Hotf_5pt_reduction(G2H8(48),RedSet_5(23),mass5set(:,12),  & 
G1H8(289),G1H8(290),G1H8(291),G1H8(292),G1H8(293),G1H8(294),8)
  call HG1shiftOLR(G1H8(290),2,8)
  call Hotf_5pt_reduction(G2H8(49),RedSet_5(25),mass5set(:,10),  & 
G1H8(295),G1H8(296),G1H8(297),G1H8(298),G1H8(299),G1H8(300),8)
  call HG1shiftOLR(G1H8(296),16,8)
  call Hotf_5pt_reduction(G2H8(50),RedSet_5(26),mass5set(:,10),  & 
G1H8(301),G1H8(302),G1H8(303),G1H8(304),G1H8(305),G1H8(306),8)
  call HG1shiftOLR(G1H8(302),8,8)
  call Hotf_5pt_reduction(G2H8(51),RedSet_5(27),mass5set(:,12),  & 
G1H8(307),G1H8(308),G1H8(309),G1H8(310),G1H8(311),G1H8(312),8)
  call HG1shiftOLR(G1H8(308),16,8)
  call Hotf_5pt_reduction(G2H8(52),RedSet_5(28),mass5set(:,12),  & 
G1H8(313),G1H8(314),G1H8(315),G1H8(316),G1H8(317),G1H8(318),8)
  call HG1shiftOLR(G1H8(314),8,8)
  call Hotf_5pt_reduction(G2H8(53),RedSet_5(14),mass5set(:,11),  & 
G1H8(319),G1H8(320),G1H8(321),G1H8(322),G1H8(323),G1H8(324),8)
  call HG1shiftOLR(G1H8(320),4,8)
  call Hotf_5pt_reduction(G2H8(54),RedSet_5(21),mass5set(:,11),  & 
G1H8(325),G1H8(326),G1H8(327),G1H8(328),G1H8(329),G1H8(330),8)
  call HG1shiftOLR(G1H8(326),4,8)
  call Hotf_5pt_reduction(G2H8(55),RedSet_5(29),mass5set(:,11),  & 
G1H8(331),G1H8(332),G1H8(333),G1H8(334),G1H8(335),G1H8(336),8)
  call HG1shiftOLR(G1H8(332),16,8)
  call Hotf_5pt_reduction(G2H8(56),RedSet_5(30),mass5set(:,12),  & 
G1H8(337),G1H8(338),G1H8(339),G1H8(340),G1H8(341),G1H8(342),8)
  call HG1shiftOLR(G1H8(338),16,8)
  call Hotf_5pt_reduction(G2H8(57),RedSet_5(31),mass5set(:,12),  & 
G1H8(343),G1H8(344),G1H8(345),G1H8(346),G1H8(347),G1H8(348),8)
  call HG1shiftOLR(G1H8(344),4,8)
  call Hotf_5pt_reduction(G2H8(58),RedSet_5(31),mass5set(:,12),  & 
G1H8(349),G1H8(350),G1H8(351),G1H8(352),G1H8(353),G1H8(354),8)
  call HG1shiftOLR(G1H8(350),2,8)
  call Hotf_5pt_reduction(G2H8(59),RedSet_5(29),mass5set(:,11),  & 
G1H8(355),G1H8(356),G1H8(357),G1H8(358),G1H8(359),G1H8(360),8)
  call HG1shiftOLR(G1H8(356),4,8)
  call Hotf_5pt_reduction(G2H8(60),RedSet_5(30),mass5set(:,12),  & 
G1H8(361),G1H8(362),G1H8(363),G1H8(364),G1H8(365),G1H8(366),8)
  call HG1shiftOLR(G1H8(362),2,8)
  call Hotf_5pt_reduction(G2H8(61),RedSet_5(32),mass5set(:,12),  & 
G1H8(367),G1H8(368),G1H8(369),G1H8(370),G1H8(371),G1H8(372),8)
  call HG1shiftOLR(G1H8(368),8,8)
  call Hotf_5pt_reduction(G2H8(62),RedSet_5(33),mass5set(:,12),  & 
G1H8(373),G1H8(374),G1H8(375),G1H8(376),G1H8(377),G1H8(378),8)
  call HG1shiftOLR(G1H8(374),4,8)
  call Hotf_5pt_reduction(G2H8(63),RedSet_5(34),mass5set(:,11),  & 
G1H8(379),G1H8(380),G1H8(381),G1H8(382),G1H8(383),G1H8(384),8)
  call HG1shiftOLR(G1H8(380),8,8)
  call Hotf_5pt_reduction(G2H8(64),RedSet_5(33),mass5set(:,12),  & 
G1H8(385),G1H8(386),G1H8(387),G1H8(388),G1H8(389),G1H8(390),8)
  call HG1shiftOLR(G1H8(386),2,8)
  call Hotf_5pt_reduction(G2H8(65),RedSet_5(34),mass5set(:,11),  & 
G1H8(391),G1H8(392),G1H8(393),G1H8(394),G1H8(395),G1H8(396),8)
  call HG1shiftOLR(G1H8(392),4,8)
  call Hotf_5pt_reduction(G2H8(66),RedSet_5(32),mass5set(:,12),  & 
G1H8(397),G1H8(398),G1H8(399),G1H8(400),G1H8(401),G1H8(402),8)
  call HG1shiftOLR(G1H8(398),2,8)
  call Hloop_AQ_V(ntryL,G2H8(67),ex1(:),G2H4(1),m3h2x4(:,1),heltab2x8(:,:,1))
  call Hloop_AQ_V(ntryL,G2H8(70),ex1(:),G2H4(2),m3h2x4(:,2),heltab2x8(:,:,2))
  call Hloop_AQ_V(ntryL,G2H8(71),ex1(:),G2H4(3),m3h2x4(:,3),heltab2x8(:,:,3))
  call Hloop_QA_V(ntryL,G2H8(72),ex2(:),G2H4(4),m3h2x4(:,4),heltab2x8(:,:,4))
  call Hloop_QA_V(ntryL,G2H8(75),ex2(:),G2H4(5),m3h2x4(:,5),heltab2x8(:,:,5))
  call Hloop_QA_V(ntryL,G2H8(76),ex2(:),G2H4(6),m3h2x4(:,6),heltab2x8(:,:,6))
  call Hloop_AQ_V(ntryL,G2H8(77),ex1(:),G2H4(7),m3h2x4(:,7),heltab2x8(:,:,7))
  call Hloop_AQ_V(ntryL,G2H8(80),ex1(:),G2H4(8),m3h2x4(:,8),heltab2x8(:,:,8))
  call Hloop_AQ_V(ntryL,G2H8(81),ex1(:),G2H4(9),m3h2x4(:,9),heltab2x8(:,:,9))
  call Hotf_5pt_reduction(G2H8(82),RedSet_5(3),mass5set(:,3),  & 
G1H8(403),G1H8(404),G1H8(405),G1H8(406),G1H8(407),G1H8(408),8)
  call HG1shiftOLR(G1H8(404),16,8)
  call Hotf_5pt_reduction(G2H8(85),RedSet_5(41),mass5set(:,1),  & 
G1H8(409),G1H8(410),G1H8(411),G1H8(412),G1H8(413),G1H8(414),8)
  call HG1shiftOLR(G1H8(410),16,8)
  call Hotf_5pt_reduction(G2H8(86),RedSet_5(42),mass5set(:,13),  & 
G1H8(415),G1H8(416),G1H8(417),G1H8(418),G1H8(419),G1H8(420),8)
  call HG1shiftOLR(G1H8(416),16,8)
  call Hloop_QA_V(ntryL,G2H8(87),ex2(:),G2H4(10),m3h2x4(:,10),heltab2x8(:,:,10))
  call Hloop_QA_V(ntryL,G2H8(90),ex2(:),G2H4(11),m3h2x4(:,11),heltab2x8(:,:,11))
  call Hloop_QA_V(ntryL,G2H8(91),ex2(:),G2H4(12),m3h2x4(:,12),heltab2x8(:,:,12))
  call Hloop_QA_V(ntryL,G2H8(92),ex2(:),G2H4(13),m3h2x4(:,13),heltab2x8(:,:,13))
  call Hloop_QA_V(ntryL,G2H8(95),ex2(:),G2H4(14),m3h2x4(:,14),heltab2x8(:,:,14))
  call Hloop_QA_V(ntryL,G2H8(96),ex2(:),G2H4(15),m3h2x4(:,15),heltab2x8(:,:,15))
  call Hloop_AQ_V(ntryL,G2H8(97),ex1(:),G2H4(16),m3h2x4(:,16),heltab2x8(:,:,16))
  call Hloop_AQ_V(ntryL,G2H8(100),ex1(:),G2H4(17),m3h2x4(:,17),heltab2x8(:,:,17))
  call Hloop_AQ_V(ntryL,G2H8(101),ex1(:),G2H4(18),m3h2x4(:,18),heltab2x8(:,:,18))
  call Hloop_AQ_V(ntryL,G2H8(102),ex1(:),G2H4(19),m3h2x4(:,19),heltab2x8(:,:,19))
  call Hloop_AQ_V(ntryL,G2H8(105),ex1(:),G2H4(20),m3h2x4(:,20),heltab2x8(:,:,20))
  call Hloop_AQ_V(ntryL,G2H8(106),ex1(:),G2H4(21),m3h2x4(:,21),heltab2x8(:,:,21))
  call Hotf_5pt_reduction(G2H8(107),RedSet_5(6),mass5set(:,3),  & 
G1H8(421),G1H8(422),G1H8(423),G1H8(424),G1H8(425),G1H8(426),8)
  call HG1shiftOLR(G1H8(422),16,8)
  call Hotf_5pt_reduction(G2H8(110),RedSet_5(43),mass5set(:,1),  & 
G1H8(427),G1H8(428),G1H8(429),G1H8(430),G1H8(431),G1H8(432),8)
  call HG1shiftOLR(G1H8(428),16,8)
  call Hotf_5pt_reduction(G2H8(111),RedSet_5(44),mass5set(:,13),  & 
G1H8(433),G1H8(434),G1H8(435),G1H8(436),G1H8(437),G1H8(438),8)
  call HG1shiftOLR(G1H8(434),16,8)
  call Hloop_QA_V(ntryL,G2H8(112),ex2(:),G2H4(22),m3h2x4(:,22),heltab2x8(:,:,22))
  call Hloop_QA_V(ntryL,G2H8(115),ex2(:),G2H4(23),m3h2x4(:,23),heltab2x8(:,:,23))
  call Hloop_QA_V(ntryL,G2H8(116),ex2(:),G2H4(24),m3h2x4(:,24),heltab2x8(:,:,24))
  call Hotf_5pt_reduction(G2H8(117),RedSet_5(7),mass5set(:,3),  & 
G1H8(439),G1H8(440),G1H8(441),G1H8(442),G1H8(443),G1H8(444),8)
  call HG1shiftOLR(G1H8(440),8,8)
  call Hotf_5pt_reduction(G2H8(120),RedSet_5(45),mass5set(:,1),  & 
G1H8(445),G1H8(446),G1H8(447),G1H8(448),G1H8(449),G1H8(450),8)
  call HG1shiftOLR(G1H8(446),8,8)
  call Hotf_5pt_reduction(G2H8(121),RedSet_5(46),mass5set(:,13),  & 
G1H8(451),G1H8(452),G1H8(453),G1H8(454),G1H8(455),G1H8(456),8)
  call HG1shiftOLR(G1H8(452),8,8)
  call Hloop_QA_V(ntryL,G2H8(122),ex2(:),G2H4(25),m3h2x4(:,25),heltab2x8(:,:,25))
  call Hloop_QA_V(ntryL,G2H8(125),ex2(:),G2H4(26),m3h2x4(:,26),heltab2x8(:,:,26))
  call Hloop_QA_V(ntryL,G2H8(126),ex2(:),G2H4(27),m3h2x4(:,27),heltab2x8(:,:,27))
  call Hotf_5pt_reduction(G2H8(127),RedSet_5(8),mass5set(:,3),  & 
G1H8(457),G1H8(458),G1H8(459),G1H8(460),G1H8(461),G1H8(462),8)
  call HG1shiftOLR(G1H8(458),16,8)
  call Hotf_5pt_reduction(G2H8(130),RedSet_5(47),mass5set(:,1),  & 
G1H8(463),G1H8(464),G1H8(465),G1H8(466),G1H8(467),G1H8(468),8)
  call HG1shiftOLR(G1H8(464),16,8)
  call Hotf_5pt_reduction(G2H8(131),RedSet_5(42),mass5set(:,13),  & 
G1H8(469),G1H8(470),G1H8(471),G1H8(472),G1H8(473),G1H8(474),8)
  call HG1shiftOLR(G1H8(470),16,8)
  call Hloop_AQ_V(ntryL,G2H8(132),ex1(:),G2H4(28),m3h2x4(:,28),heltab2x8(:,:,28))
  call Hloop_AQ_V(ntryL,G2H8(135),ex1(:),G2H4(29),m3h2x4(:,29),heltab2x8(:,:,29))
  call Hloop_AQ_V(ntryL,G2H8(136),ex1(:),G2H4(30),m3h2x4(:,30),heltab2x8(:,:,30))
  call Hloop_QA_V(ntryL,G2H8(137),ex2(:),G2H4(31),m3h2x4(:,31),heltab2x8(:,:,31))
  call Hloop_QA_V(ntryL,G2H8(140),ex2(:),G2H4(32),m3h2x4(:,32),heltab2x8(:,:,32))
  call Hloop_QA_V(ntryL,G2H8(141),ex2(:),G2H4(33),m3h2x4(:,33),heltab2x8(:,:,33))
  call Hotf_5pt_reduction(G2H8(142),RedSet_5(9),mass5set(:,3),  & 
G1H8(475),G1H8(476),G1H8(477),G1H8(478),G1H8(479),G1H8(480),8)
  call HG1shiftOLR(G1H8(476),16,8)
  call Hotf_5pt_reduction(G2H8(145),RedSet_5(48),mass5set(:,1),  & 
G1H8(481),G1H8(482),G1H8(483),G1H8(484),G1H8(485),G1H8(486),8)
  call HG1shiftOLR(G1H8(482),16,8)
  call Hotf_5pt_reduction(G2H8(146),RedSet_5(44),mass5set(:,13),  & 
G1H8(487),G1H8(488),G1H8(489),G1H8(490),G1H8(491),G1H8(492),8)
  call HG1shiftOLR(G1H8(488),16,8)
  call Hloop_AQ_V(ntryL,G2H8(147),ex1(:),G2H4(34),m3h2x4(:,34),heltab2x8(:,:,34))
  call Hloop_AQ_V(ntryL,G2H8(150),ex1(:),G2H4(35),m3h2x4(:,35),heltab2x8(:,:,35))
  call Hloop_AQ_V(ntryL,G2H8(151),ex1(:),G2H4(36),m3h2x4(:,36),heltab2x8(:,:,36))
  call Hotf_5pt_reduction(G2H8(152),RedSet_5(10),mass5set(:,3),  & 
G1H8(493),G1H8(494),G1H8(495),G1H8(496),G1H8(497),G1H8(498),8)
  call HG1shiftOLR(G1H8(494),8,8)
  call Hotf_5pt_reduction(G2H8(155),RedSet_5(49),mass5set(:,1),  & 
G1H8(499),G1H8(500),G1H8(501),G1H8(502),G1H8(503),G1H8(504),8)
  call HG1shiftOLR(G1H8(500),8,8)
  call Hotf_5pt_reduction(G2H8(156),RedSet_5(46),mass5set(:,13),  & 
G1H8(505),G1H8(506),G1H8(507),G1H8(508),G1H8(509),G1H8(510),8)
  call HG1shiftOLR(G1H8(506),8,8)
  call Hotf_5pt_reduction(G2H8(157),RedSet_5(11),mass5set(:,4),  & 
G1H8(511),G1H8(512),G1H8(513),G1H8(514),G1H8(515),G1H8(516),8)
  call HG1shiftOLR(G1H8(512),16,8)
  call Hotf_5pt_reduction(G2H8(160),RedSet_5(41),mass5set(:,1),  & 
G1H8(517),G1H8(518),G1H8(519),G1H8(520),G1H8(521),G1H8(522),8)
  call HG1shiftOLR(G1H8(518),16,8)
  call Hotf_5pt_reduction(G2H8(161),RedSet_5(50),mass5set(:,1),  & 
G1H8(523),G1H8(524),G1H8(525),G1H8(526),G1H8(527),G1H8(528),8)
  call HG1shiftOLR(G1H8(524),16,8)
  call Hloop_AQ_V(ntryL,G2H8(162),ex1(:),G2H4(37),m3h2x4(:,37),heltab2x8(:,:,37))
  call Hloop_AQ_V(ntryL,G2H8(165),ex1(:),G2H4(38),m3h2x4(:,38),heltab2x8(:,:,38))
  call Hloop_AQ_V(ntryL,G2H8(166),ex1(:),G2H4(39),m3h2x4(:,39),heltab2x8(:,:,39))
  call Hotf_5pt_reduction(G2H8(167),RedSet_5(13),mass5set(:,4),  & 
G1H8(529),G1H8(530),G1H8(531),G1H8(532),G1H8(533),G1H8(534),8)
  call HG1shiftOLR(G1H8(530),16,8)
  call Hotf_5pt_reduction(G2H8(170),RedSet_5(43),mass5set(:,1),  & 
G1H8(535),G1H8(536),G1H8(537),G1H8(538),G1H8(539),G1H8(540),8)
  call HG1shiftOLR(G1H8(536),16,8)
  call Hotf_5pt_reduction(G2H8(171),RedSet_5(51),mass5set(:,1),  & 
G1H8(541),G1H8(542),G1H8(543),G1H8(544),G1H8(545),G1H8(546),8)
  call HG1shiftOLR(G1H8(542),16,8)
  call Hloop_AQ_V(ntryL,G2H8(172),ex1(:),G2H4(40),m3h2x4(:,40),heltab2x8(:,:,40))
  call Hloop_AQ_V(ntryL,G2H8(175),ex1(:),G2H4(41),m3h2x4(:,41),heltab2x8(:,:,41))
  call Hloop_AQ_V(ntryL,G2H8(176),ex1(:),G2H4(42),m3h2x4(:,42),heltab2x8(:,:,42))
  call Hotf_5pt_reduction(G2H8(177),RedSet_5(15),mass5set(:,6),  & 
G1H8(547),G1H8(548),G1H8(549),G1H8(550),G1H8(551),G1H8(552),8)
  call HG1shiftOLR(G1H8(548),8,8)
  call Hotf_5pt_reduction(G2H8(180),RedSet_5(52),mass5set(:,5),  & 
G1H8(553),G1H8(554),G1H8(555),G1H8(556),G1H8(557),G1H8(558),8)
  call HG1shiftOLR(G1H8(554),8,8)
  call Hotf_5pt_reduction(G2H8(181),RedSet_5(53),mass5set(:,5),  & 
G1H8(559),G1H8(560),G1H8(561),G1H8(562),G1H8(563),G1H8(564),8)
  call HG1shiftOLR(G1H8(560),8,8)
  call Hotf_5pt_reduction(G2H8(182),RedSet_5(16),mass5set(:,6),  & 
G1H8(565),G1H8(566),G1H8(567),G1H8(568),G1H8(569),G1H8(570),8)
  call HG1shiftOLR(G1H8(566),4,8)
  call Hotf_5pt_reduction(G2H8(185),RedSet_5(54),mass5set(:,5),  & 
G1H8(571),G1H8(572),G1H8(573),G1H8(574),G1H8(575),G1H8(576),8)
  call HG1shiftOLR(G1H8(572),4,8)
  call Hotf_5pt_reduction(G2H8(186),RedSet_5(55),mass5set(:,5),  & 
G1H8(577),G1H8(578),G1H8(579),G1H8(580),G1H8(581),G1H8(582),8)
  call HG1shiftOLR(G1H8(578),4,8)
  call Hotf_5pt_reduction(G2H8(187),RedSet_5(17),mass5set(:,4),  & 
G1H8(583),G1H8(584),G1H8(585),G1H8(586),G1H8(587),G1H8(588),8)
  call HG1shiftOLR(G1H8(584),16,8)
  call Hotf_5pt_reduction(G2H8(190),RedSet_5(47),mass5set(:,1),  & 
G1H8(589),G1H8(590),G1H8(591),G1H8(592),G1H8(593),G1H8(594),8)
  call HG1shiftOLR(G1H8(590),16,8)
  call Hotf_5pt_reduction(G2H8(191),RedSet_5(56),mass5set(:,1),  & 
G1H8(595),G1H8(596),G1H8(597),G1H8(598),G1H8(599),G1H8(600),8)
  call HG1shiftOLR(G1H8(596),16,8)
  call Hloop_AQ_V(ntryL,G2H8(192),ex1(:),G2H4(43),m3h2x4(:,43),heltab2x8(:,:,43))
  call Hloop_AQ_V(ntryL,G2H8(195),ex1(:),G2H4(44),m3h2x4(:,44),heltab2x8(:,:,44))
  call Hloop_AQ_V(ntryL,G2H8(196),ex1(:),G2H4(45),m3h2x4(:,45),heltab2x8(:,:,45))
  call Hotf_5pt_reduction(G2H8(197),RedSet_5(18),mass5set(:,4),  & 
G1H8(601),G1H8(602),G1H8(603),G1H8(604),G1H8(605),G1H8(606),8)
  call HG1shiftOLR(G1H8(602),8,8)
  call Hotf_5pt_reduction(G2H8(200),RedSet_5(49),mass5set(:,1),  & 
G1H8(607),G1H8(608),G1H8(609),G1H8(610),G1H8(611),G1H8(612),8)
  call HG1shiftOLR(G1H8(608),8,8)
  call Hotf_5pt_reduction(G2H8(201),RedSet_5(57),mass5set(:,1),  & 
G1H8(613),G1H8(614),G1H8(615),G1H8(616),G1H8(617),G1H8(618),8)
  call HG1shiftOLR(G1H8(614),8,8)
  call Hotf_5pt_reduction(G2H8(202),RedSet_5(19),mass5set(:,6),  & 
G1H8(619),G1H8(620),G1H8(621),G1H8(622),G1H8(623),G1H8(624),8)
  call HG1shiftOLR(G1H8(620),16,8)
  call Hotf_5pt_reduction(G2H8(205),RedSet_5(58),mass5set(:,5),  & 
G1H8(625),G1H8(626),G1H8(627),G1H8(628),G1H8(629),G1H8(630),8)
  call HG1shiftOLR(G1H8(626),16,8)
  call Hotf_5pt_reduction(G2H8(206),RedSet_5(59),mass5set(:,5),  & 
G1H8(631),G1H8(632),G1H8(633),G1H8(634),G1H8(635),G1H8(636),8)
  call HG1shiftOLR(G1H8(632),16,8)
  call Hotf_5pt_reduction(G2H8(207),RedSet_5(20),mass5set(:,6),  & 
G1H8(637),G1H8(638),G1H8(639),G1H8(640),G1H8(641),G1H8(642),8)
  call HG1shiftOLR(G1H8(638),4,8)
  call Hotf_5pt_reduction(G2H8(210),RedSet_5(54),mass5set(:,5),  & 
G1H8(643),G1H8(644),G1H8(645),G1H8(646),G1H8(647),G1H8(648),8)
  call HG1shiftOLR(G1H8(644),4,8)
  call Hotf_5pt_reduction(G2H8(211),RedSet_5(60),mass5set(:,5),  & 
G1H8(649),G1H8(650),G1H8(651),G1H8(652),G1H8(653),G1H8(654),8)
  call HG1shiftOLR(G1H8(650),4,8)
  call Hloop_AQ_V(ntryL,G2H8(212),ex1(:),G2H4(46),m3h2x4(:,46),heltab2x8(:,:,46))
  call Hloop_AQ_V(ntryL,G2H8(215),ex1(:),G2H4(47),m3h2x4(:,47),heltab2x8(:,:,47))
  call Hloop_AQ_V(ntryL,G2H8(216),ex1(:),G2H4(48),m3h2x4(:,48),heltab2x8(:,:,48))
  call Hloop_QA_V(ntryL,G2H8(217),ex2(:),G2H4(49),m3h2x4(:,49),heltab2x8(:,:,49))
  call Hloop_QA_V(ntryL,G2H8(220),ex2(:),G2H4(50),m3h2x4(:,50),heltab2x8(:,:,50))
  call Hloop_QA_V(ntryL,G2H8(221),ex2(:),G2H4(51),m3h2x4(:,51),heltab2x8(:,:,51))
  call Hloop_QA_V(ntryL,G2H8(222),ex2(:),G2H4(52),m3h2x4(:,52),heltab2x8(:,:,52))
  call Hloop_QA_V(ntryL,G2H8(225),ex2(:),G2H4(53),m3h2x4(:,53),heltab2x8(:,:,53))
  call Hloop_QA_V(ntryL,G2H8(226),ex2(:),G2H4(54),m3h2x4(:,54),heltab2x8(:,:,54))
  call Hotf_5pt_reduction(G2H8(227),RedSet_5(23),mass5set(:,6),  & 
G1H8(655),G1H8(656),G1H8(657),G1H8(658),G1H8(659),G1H8(660),8)
  call HG1shiftOLR(G1H8(656),16,8)
  call Hotf_5pt_reduction(G2H8(230),RedSet_5(61),mass5set(:,5),  & 
G1H8(661),G1H8(662),G1H8(663),G1H8(664),G1H8(665),G1H8(666),8)
  call HG1shiftOLR(G1H8(662),16,8)
  call Hotf_5pt_reduction(G2H8(231),RedSet_5(62),mass5set(:,5),  & 
G1H8(667),G1H8(668),G1H8(669),G1H8(670),G1H8(671),G1H8(672),8)
  call HG1shiftOLR(G1H8(668),16,8)
  call Hotf_5pt_reduction(G2H8(232),RedSet_5(24),mass5set(:,6),  & 
G1H8(673),G1H8(674),G1H8(675),G1H8(676),G1H8(677),G1H8(678),8)
  call HG1shiftOLR(G1H8(674),8,8)
  call Hotf_5pt_reduction(G2H8(235),RedSet_5(63),mass5set(:,5),  & 
G1H8(679),G1H8(680),G1H8(681),G1H8(682),G1H8(683),G1H8(684),8)
  call HG1shiftOLR(G1H8(680),8,8)
  call Hotf_5pt_reduction(G2H8(236),RedSet_5(64),mass5set(:,5),  & 
G1H8(685),G1H8(686),G1H8(687),G1H8(688),G1H8(689),G1H8(690),8)
  call HG1shiftOLR(G1H8(686),8,8)
  call Hotf_5pt_reduction(G2H8(237),RedSet_5(24),mass5set(:,6),  & 
G1H8(691),G1H8(692),G1H8(693),G1H8(694),G1H8(695),G1H8(696),8)
  call HG1shiftOLR(G1H8(692),2,8)
  call Hotf_5pt_reduction(G2H8(239),RedSet_5(65),mass5set(:,6),  & 
G1H8(697),G1H8(698),G1H8(699),G1H8(700),G1H8(701),G1H8(702),8)
  call HG1shiftOLR(G1H8(698),2,8)
  call Hotf_5pt_reduction(G2H8(240),RedSet_5(66),mass5set(:,6),  & 
G1H8(703),G1H8(704),G1H8(705),G1H8(706),G1H8(707),G1H8(708),8)
  call HG1shiftOLR(G1H8(704),2,8)
  call Hotf_5pt_reduction(G2H8(241),RedSet_5(23),mass5set(:,6),  & 
G1H8(709),G1H8(710),G1H8(711),G1H8(712),G1H8(713),G1H8(714),8)
  call HG1shiftOLR(G1H8(710),2,8)
  call Hotf_5pt_reduction(G2H8(243),RedSet_5(67),mass5set(:,6),  & 
G1H8(715),G1H8(716),G1H8(717),G1H8(718),G1H8(719),G1H8(720),8)
  call HG1shiftOLR(G1H8(716),2,8)
  call Hotf_5pt_reduction(G2H8(244),RedSet_5(66),mass5set(:,6),  & 
G1H8(721),G1H8(722),G1H8(723),G1H8(724),G1H8(725),G1H8(726),8)
  call HG1shiftOLR(G1H8(722),2,8)
  call Hotf_5pt_reduction(G2H8(245),RedSet_5(25),mass5set(:,4),  & 
G1H8(727),G1H8(728),G1H8(729),G1H8(730),G1H8(731),G1H8(732),8)
  call HG1shiftOLR(G1H8(728),16,8)
  call Hotf_5pt_reduction(G2H8(248),RedSet_5(48),mass5set(:,1),  & 
G1H8(733),G1H8(734),G1H8(735),G1H8(736),G1H8(737),G1H8(738),8)
  call HG1shiftOLR(G1H8(734),16,8)
  call Hotf_5pt_reduction(G2H8(249),RedSet_5(68),mass5set(:,1),  & 
G1H8(739),G1H8(740),G1H8(741),G1H8(742),G1H8(743),G1H8(744),8)
  call HG1shiftOLR(G1H8(740),16,8)
  call Hotf_5pt_reduction(G2H8(250),RedSet_5(26),mass5set(:,4),  & 
G1H8(745),G1H8(746),G1H8(747),G1H8(748),G1H8(749),G1H8(750),8)
  call HG1shiftOLR(G1H8(746),8,8)
  call Hotf_5pt_reduction(G2H8(253),RedSet_5(45),mass5set(:,1),  & 
G1H8(751),G1H8(752),G1H8(753),G1H8(754),G1H8(755),G1H8(756),8)
  call HG1shiftOLR(G1H8(752),8,8)
  call Hotf_5pt_reduction(G2H8(254),RedSet_5(69),mass5set(:,1),  & 
G1H8(757),G1H8(758),G1H8(759),G1H8(760),G1H8(761),G1H8(762),8)
  call HG1shiftOLR(G1H8(758),8,8)
  call Hotf_5pt_reduction(G2H8(255),RedSet_5(27),mass5set(:,6),  & 
G1H8(763),G1H8(764),G1H8(765),G1H8(766),G1H8(767),G1H8(768),8)
  call HG1shiftOLR(G1H8(764),16,8)
  call Hotf_5pt_reduction(G2H8(258),RedSet_5(58),mass5set(:,5),  & 
G1H8(769),G1H8(770),G1H8(771),G1H8(772),G1H8(773),G1H8(774),8)
  call HG1shiftOLR(G1H8(770),16,8)
  call Hotf_5pt_reduction(G2H8(259),RedSet_5(70),mass5set(:,5),  & 
G1H8(775),G1H8(776),G1H8(777),G1H8(778),G1H8(779),G1H8(780),8)
  call HG1shiftOLR(G1H8(776),16,8)
  call Hotf_5pt_reduction(G2H8(260),RedSet_5(28),mass5set(:,6),  & 
G1H8(781),G1H8(782),G1H8(783),G1H8(784),G1H8(785),G1H8(786),8)
  call HG1shiftOLR(G1H8(782),8,8)
  call Hotf_5pt_reduction(G2H8(263),RedSet_5(52),mass5set(:,5),  & 
G1H8(787),G1H8(788),G1H8(789),G1H8(790),G1H8(791),G1H8(792),8)
  call HG1shiftOLR(G1H8(788),8,8)
  call Hotf_5pt_reduction(G2H8(264),RedSet_5(71),mass5set(:,5),  & 
G1H8(793),G1H8(794),G1H8(795),G1H8(796),G1H8(797),G1H8(798),8)
  call HG1shiftOLR(G1H8(794),8,8)
  call Hloop_AQ_V(ntryL,G2H8(265),ex1(:),G2H4(55),m3h2x4(:,55),heltab2x8(:,:,55))
  call Hloop_AQ_V(ntryL,G2H8(268),ex1(:),G2H4(56),m3h2x4(:,56),heltab2x8(:,:,56))
  call Hloop_AQ_V(ntryL,G2H8(269),ex1(:),G2H4(57),m3h2x4(:,57),heltab2x8(:,:,57))
  call Hloop_AQ_V(ntryL,G2H8(270),ex1(:),G2H4(58),m3h2x4(:,58),heltab2x8(:,:,58))
  call Hloop_AQ_V(ntryL,G2H8(273),ex1(:),G2H4(59),m3h2x4(:,59),heltab2x8(:,:,59))
  call Hloop_AQ_V(ntryL,G2H8(274),ex1(:),G2H4(60),m3h2x4(:,60),heltab2x8(:,:,60))
  call Hloop_QA_V(ntryL,G2H8(275),ex2(:),G2H4(61),m3h2x4(:,61),heltab2x8(:,:,61))
  call Hloop_QA_V(ntryL,G2H8(278),ex2(:),G2H4(62),m3h2x4(:,62),heltab2x8(:,:,62))
  call Hloop_QA_V(ntryL,G2H8(279),ex2(:),G2H4(63),m3h2x4(:,63),heltab2x8(:,:,63))
  call Hotf_5pt_reduction(G2H8(280),RedSet_5(30),mass5set(:,6),  & 
G1H8(799),G1H8(800),G1H8(801),G1H8(802),G1H8(803),G1H8(804),8)
  call HG1shiftOLR(G1H8(800),16,8)
  call Hotf_5pt_reduction(G2H8(283),RedSet_5(61),mass5set(:,5),  & 
G1H8(805),G1H8(806),G1H8(807),G1H8(808),G1H8(809),G1H8(810),8)
  call HG1shiftOLR(G1H8(806),16,8)
  call Hotf_5pt_reduction(G2H8(284),RedSet_5(72),mass5set(:,5),  & 
G1H8(811),G1H8(812),G1H8(813),G1H8(814),G1H8(815),G1H8(816),8)
  call HG1shiftOLR(G1H8(812),16,8)
  call Hotf_5pt_reduction(G2H8(285),RedSet_5(31),mass5set(:,6),  & 
G1H8(817),G1H8(818),G1H8(819),G1H8(820),G1H8(821),G1H8(822),8)
  call HG1shiftOLR(G1H8(818),4,8)
  call Hotf_5pt_reduction(G2H8(288),RedSet_5(73),mass5set(:,5),  & 
G1H8(823),G1H8(824),G1H8(825),G1H8(826),G1H8(827),G1H8(828),8)
  call HG1shiftOLR(G1H8(824),4,8)
  call Hotf_5pt_reduction(G2H8(289),RedSet_5(74),mass5set(:,5),  & 
G1H8(829),G1H8(830),G1H8(831),G1H8(832),G1H8(833),G1H8(834),8)
  call HG1shiftOLR(G1H8(830),4,8)
  call Hotf_5pt_reduction(G2H8(290),RedSet_5(31),mass5set(:,6),  & 
G1H8(835),G1H8(836),G1H8(837),G1H8(838),G1H8(839),G1H8(840),8)
  call HG1shiftOLR(G1H8(836),2,8)
  call Hotf_5pt_reduction(G2H8(292),RedSet_5(75),mass5set(:,6),  & 
G1H8(841),G1H8(842),G1H8(843),G1H8(844),G1H8(845),G1H8(846),8)
  call HG1shiftOLR(G1H8(842),2,8)
  call Hotf_5pt_reduction(G2H8(293),RedSet_5(76),mass5set(:,6),  & 
G1H8(847),G1H8(848),G1H8(849),G1H8(850),G1H8(851),G1H8(852),8)
  call HG1shiftOLR(G1H8(848),2,8)
  call Hloop_QA_V(ntryL,G2H8(294),ex2(:),G2H4(64),m3h2x4(:,64),heltab2x8(:,:,64))
  call Hloop_QA_V(ntryL,G2H8(297),ex2(:),G2H4(65),m3h2x4(:,65),heltab2x8(:,:,65))
  call Hloop_QA_V(ntryL,G2H8(298),ex2(:),G2H4(66),m3h2x4(:,66),heltab2x8(:,:,66))
  call Hotf_5pt_reduction(G2H8(299),RedSet_5(30),mass5set(:,6),  & 
G1H8(853),G1H8(854),G1H8(855),G1H8(856),G1H8(857),G1H8(858),8)
  call HG1shiftOLR(G1H8(854),2,8)
  call Hotf_5pt_reduction(G2H8(301),RedSet_5(67),mass5set(:,6),  & 
G1H8(859),G1H8(860),G1H8(861),G1H8(862),G1H8(863),G1H8(864),8)
  call HG1shiftOLR(G1H8(860),2,8)
  call Hotf_5pt_reduction(G2H8(302),RedSet_5(76),mass5set(:,6),  & 
G1H8(865),G1H8(866),G1H8(867),G1H8(868),G1H8(869),G1H8(870),8)
  call HG1shiftOLR(G1H8(866),2,8)
  call Hotf_5pt_reduction(G2H8(303),RedSet_5(32),mass5set(:,6),  & 
G1H8(871),G1H8(872),G1H8(873),G1H8(874),G1H8(875),G1H8(876),8)
  call HG1shiftOLR(G1H8(872),8,8)
  call Hotf_5pt_reduction(G2H8(306),RedSet_5(63),mass5set(:,5),  & 
G1H8(877),G1H8(878),G1H8(879),G1H8(880),G1H8(881),G1H8(882),8)
  call HG1shiftOLR(G1H8(878),8,8)
  call Hotf_5pt_reduction(G2H8(307),RedSet_5(77),mass5set(:,5),  & 
G1H8(883),G1H8(884),G1H8(885),G1H8(886),G1H8(887),G1H8(888),8)
  call HG1shiftOLR(G1H8(884),8,8)
  call Hotf_5pt_reduction(G2H8(308),RedSet_5(33),mass5set(:,6),  & 
G1H8(889),G1H8(890),G1H8(891),G1H8(892),G1H8(893),G1H8(894),8)
  call HG1shiftOLR(G1H8(890),4,8)
  call Hotf_5pt_reduction(G2H8(311),RedSet_5(73),mass5set(:,5),  & 
G1H8(895),G1H8(896),G1H8(897),G1H8(898),G1H8(899),G1H8(900),8)
  call HG1shiftOLR(G1H8(896),4,8)
  call Hotf_5pt_reduction(G2H8(312),RedSet_5(78),mass5set(:,5),  & 
G1H8(901),G1H8(902),G1H8(903),G1H8(904),G1H8(905),G1H8(906),8)
  call HG1shiftOLR(G1H8(902),4,8)
  call Hloop_QA_V(ntryL,G2H8(313),ex2(:),G2H4(67),m3h2x4(:,67),heltab2x8(:,:,67))
  call Hloop_QA_V(ntryL,G2H8(316),ex2(:),G2H4(68),m3h2x4(:,68),heltab2x8(:,:,68))
  call Hloop_QA_V(ntryL,G2H8(317),ex2(:),G2H4(69),m3h2x4(:,69),heltab2x8(:,:,69))
  call Hotf_5pt_reduction(G2H8(318),RedSet_5(33),mass5set(:,6),  & 
G1H8(907),G1H8(908),G1H8(909),G1H8(910),G1H8(911),G1H8(912),8)
  call HG1shiftOLR(G1H8(908),2,8)
  call Hotf_5pt_reduction(G2H8(320),RedSet_5(75),mass5set(:,6),  & 
G1H8(913),G1H8(914),G1H8(915),G1H8(916),G1H8(917),G1H8(918),8)
  call HG1shiftOLR(G1H8(914),2,8)
  call Hotf_5pt_reduction(G2H8(321),RedSet_5(79),mass5set(:,6),  & 
G1H8(919),G1H8(920),G1H8(921),G1H8(922),G1H8(923),G1H8(924),8)
  call HG1shiftOLR(G1H8(920),2,8)
  call Hloop_QA_V(ntryL,G2H8(322),ex2(:),G2H4(70),m3h2x4(:,70),heltab2x8(:,:,70))
  call Hloop_QA_V(ntryL,G2H8(325),ex2(:),G2H4(71),m3h2x4(:,71),heltab2x8(:,:,71))
  call Hloop_QA_V(ntryL,G2H8(326),ex2(:),G2H4(72),m3h2x4(:,72),heltab2x8(:,:,72))
  call Hotf_5pt_reduction(G2H8(327),RedSet_5(32),mass5set(:,6),  & 
G1H8(925),G1H8(926),G1H8(927),G1H8(928),G1H8(929),G1H8(930),8)
  call HG1shiftOLR(G1H8(926),2,8)
  call Hotf_5pt_reduction(G2H8(329),RedSet_5(65),mass5set(:,6),  & 
G1H8(931),G1H8(932),G1H8(933),G1H8(934),G1H8(935),G1H8(936),8)
  call HG1shiftOLR(G1H8(932),2,8)
  call Hotf_5pt_reduction(G2H8(330),RedSet_5(79),mass5set(:,6),  & 
G1H8(937),G1H8(938),G1H8(939),G1H8(940),G1H8(941),G1H8(942),8)
  call HG1shiftOLR(G1H8(938),2,8)
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H8(409),[G1H8(407)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H8(415),[G1H8(408)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H8(427),[G1H8(425)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H8(433),[G1H8(426)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H8(445),[G1H8(443)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H8(451),[G1H8(444)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H8(463),[G1H8(461)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H8(469),[G1H8(462)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H8(481),[G1H8(479)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H8(487),[G1H8(480)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H8(499),[G1H8(497)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H8(505),[G1H8(498)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H8(517),[G1H8(515)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H8(523),[G1H8(516)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H8(535),[G1H8(533)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H8(541),[G1H8(534)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H8(553),[G1H8(551)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H8(559),[G1H8(552)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H8(571),[G1H8(569)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H8(577),[G1H8(570)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H8(589),[G1H8(587)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H8(595),[G1H8(588)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H8(607),[G1H8(605)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H8(613),[G1H8(606)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H8(625),[G1H8(623)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H8(631),[G1H8(624)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H8(643),[G1H8(641)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H8(649),[G1H8(642)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H8(661),[G1H8(659)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H8(667),[G1H8(660)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H8(679),[G1H8(677)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H8(685),[G1H8(678)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H8(697),[G1H8(695)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H8(703),[G1H8(696)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H8(715),[G1H8(713)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H8(721),[G1H8(714)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H8(733),[G1H8(731)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H8(739),[G1H8(732)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H8(751),[G1H8(749)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H8(757),[G1H8(750)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H8(769),[G1H8(767)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H8(775),[G1H8(768)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H8(787),[G1H8(785)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H8(793),[G1H8(786)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H8(805),[G1H8(803)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H8(811),[G1H8(804)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H8(823),[G1H8(821)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H8(829),[G1H8(822)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H8(841),[G1H8(839)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H8(847),[G1H8(840)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H8(859),[G1H8(857)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H8(865),[G1H8(858)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H8(877),[G1H8(875)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H8(883),[G1H8(876)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H8(895),[G1H8(893)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H8(901),[G1H8(894)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H8(913),[G1H8(911)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H8(919),[G1H8(912)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H8(931),[G1H8(929)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H8(937),[G1H8(930)])
  call Hloop_VQ_A(ntryL,G1H8(7),ex1(:),G1H4(1),m3h2x4(:,73),heltab2x8(:,:,73))
  call Hloop_Q_A(ntryL,G1H4(1),43,nMT,G2H4(73),n2h4(1))
call HGT_OLR(G1H8(8),1,1,8)
call HGT_invQ_OLR(G1H8(8),2,5,8)
  call Hloop_A_Q(ntryL,G1H8(8),-16,nMT,G2H8(1),n2h8(205))
  call Hloop_AV_Q(ntryL,G2H8(1),ex5(:),G2H4(74),m3h2x4(:,74),heltab2x8(:,:,74))
  call Hloop_VQ_A(ntryL,G1H8(11),ex1(:),G1H4(1),m3h2x4(:,75),heltab2x8(:,:,75))
  call Hloop_Q_A(ntryL,G1H4(1),43,nMT,G2H4(75),n2h4(2))
  call Hloop_VQ_A(ntryL,G1H8(12),ex1(:),G1H4(1),m3h2x4(:,76),heltab2x8(:,:,76))
  call Hloop_Q_A(ntryL,G1H4(1),43,nMT,G2H4(76),n2h4(3))
  call Hloop_VA_Q(ntryL,G1H8(13),ex2(:),G1H4(1),m3h2x4(:,77),heltab2x8(:,:,77))
  call Hloop_A_Q(ntryL,G1H4(1),39,nMT,G2H4(77),n2h4(4))
call HGT_OLR(G1H8(14),1,1,8)
call HGT_invQ_OLR(G1H8(14),2,5,8)
  call Hloop_Q_A(ntryL,G1H8(14),-16,nMT,G2H8(2),n2h8(206))
  call Hloop_QV_A(ntryL,G2H8(2),ex5(:),G2H4(78),m3h2x4(:,78),heltab2x8(:,:,78))
  call Hloop_VA_Q(ntryL,G1H8(17),ex2(:),G1H4(1),m3h2x4(:,79),heltab2x8(:,:,79))
  call Hloop_A_Q(ntryL,G1H4(1),39,nMT,G2H4(79),n2h4(5))
  call Hloop_VA_Q(ntryL,G1H8(18),ex2(:),G1H4(1),m3h2x4(:,80),heltab2x8(:,:,80))
  call Hloop_A_Q(ntryL,G1H4(1),39,nMT,G2H4(80),n2h4(6))
  call Hloop_VA_Q(ntryL,G1H8(19),ex2(:),G1H4(1),m3h2x4(:,81),heltab2x8(:,:,81))
  call Hloop_A_Q(ntryL,G1H4(1),39,nMT,G2H4(81),n2h4(7))
call HGT_OLR(G1H8(20),1,1,8)
call HGT_invQ_OLR(G1H8(20),2,5,8)
  call Hloop_Q_A(ntryL,G1H8(20),-8,nMT,G2H8(3),n2h8(207))
  call Hloop_QV_A(ntryL,G2H8(3),ex4(:),G2H4(82),m3h2x4(:,82),heltab2x8(:,:,82))
  call Hloop_VA_Q(ntryL,G1H8(23),ex2(:),G1H4(1),m3h2x4(:,83),heltab2x8(:,:,83))
  call Hloop_A_Q(ntryL,G1H4(1),39,nMT,G2H4(83),n2h4(8))
  call Hloop_VA_Q(ntryL,G1H8(24),ex2(:),G1H4(1),m3h2x4(:,84),heltab2x8(:,:,84))
  call Hloop_A_Q(ntryL,G1H4(1),39,nMT,G2H4(84),n2h4(9))
  call Hloop_QV_A(ntryL,G1H8(25),ex3(:),G1H4(1),m3h2x4(:,85),heltab2x8(:,:,85))
  call Hloop_Q_A(ntryL,G1H4(1),39,nMT,G2H4(85),n2h4(10))
call HGT_OLR(G1H8(26),1,1,8)
call HGT_invQ_OLR(G1H8(26),2,5,8)
  call Hloop_A_Q(ntryL,G1H8(26),-16,nMT,G2H8(4),n2h8(208))
  call Hloop_AV_Q(ntryL,G2H8(4),ex5(:),G2H4(86),m3h2x4(:,86),heltab2x8(:,:,86))
  call Hloop_QV_A(ntryL,G1H8(29),ex3(:),G1H4(1),m3h2x4(:,87),heltab2x8(:,:,87))
  call Hloop_Q_A(ntryL,G1H4(1),39,nMT,G2H4(87),n2h4(11))
  call Hloop_QV_A(ntryL,G1H8(30),ex3(:),G1H4(1),m3h2x4(:,88),heltab2x8(:,:,88))
  call Hloop_Q_A(ntryL,G1H4(1),39,nMT,G2H4(88),n2h4(12))
  call Hloop_UV_W(ntryL,G1H8(31),35,ex3(:),4,G2H4(89),m3h2x4(:,89),heltab2x8(:,:,89))
call HGT_raise_alpha_OLR(G1H8(32),1,1,8)
call HGT_raise_alpha_invQ_OLR(G1H8(32),2,5,8)
  call Hloop_UV_W(ntryL,G1H8(32),-16,ex5(:),16,G2H4(90),m3h2x4(:,90),heltab2x8(:,:,90))
call signflip_OLR(G2H4(90))
  call Hloop_UV_W(ntryL,G1H8(35),35,ex3(:),4,G2H4(91),m3h2x4(:,91),heltab2x8(:,:,91))
  call Hloop_UV_W(ntryL,G1H8(36),35,ex3(:),4,G2H4(92),m3h2x4(:,92),heltab2x8(:,:,92))
  call Hloop_QV_A(ntryL,G1H8(37),ex3(:),G1H4(1),m3h2x4(:,93),heltab2x8(:,:,93))
  call Hloop_Q_A(ntryL,G1H4(1),39,nMT,G2H4(93),n2h4(13))
call HGT_OLR(G1H8(38),1,1,8)
call HGT_invQ_OLR(G1H8(38),2,5,8)
  call Hloop_A_Q(ntryL,G1H8(38),-8,nMT,G2H8(5),n2h8(210))
  call Hloop_AV_Q(ntryL,G2H8(5),ex4(:),G2H4(94),m3h2x4(:,94),heltab2x8(:,:,94))
  call Hloop_QV_A(ntryL,G1H8(41),ex3(:),G1H4(1),m3h2x4(:,95),heltab2x8(:,:,95))
  call Hloop_Q_A(ntryL,G1H4(1),39,nMT,G2H4(95),n2h4(14))
  call Hloop_QV_A(ntryL,G1H8(42),ex3(:),G1H4(1),m3h2x4(:,96),heltab2x8(:,:,96))
  call Hloop_Q_A(ntryL,G1H4(1),39,nMT,G2H4(96),n2h4(15))
  call Hloop_UV_W(ntryL,G1H8(43),35,ex3(:),4,G2H4(97),m3h2x4(:,97),heltab2x8(:,:,97))
call HGT_raise_alpha_OLR(G1H8(44),1,1,8)
call HGT_raise_alpha_invQ_OLR(G1H8(44),2,5,8)
  call Hloop_UV_W(ntryL,G1H8(44),-8,ex4(:),8,G2H4(98),m3h2x4(:,98),heltab2x8(:,:,98))
call signflip_OLR(G2H4(98))
  call Hloop_UV_W(ntryL,G1H8(47),35,ex3(:),4,G2H4(99),m3h2x4(:,99),heltab2x8(:,:,99))
  call Hloop_UV_W(ntryL,G1H8(48),35,ex3(:),4,G2H4(100),m3h2x4(:,100),heltab2x8(:,:,100))
  call Hloop_VA_Q(ntryL,G1H8(49),ex2(:),G1H4(1),m3h2x4(:,101),heltab2x8(:,:,101))
  call Hloop_A_Q(ntryL,G1H4(1),43,nMT,G2H4(101),n2h4(16))
call HGT_OLR(G1H8(50),1,1,8)
call HGT_invQ_OLR(G1H8(50),2,5,8)
  call Hloop_Q_A(ntryL,G1H8(50),-16,nMT,G2H8(6),n2h8(212))
  call Hloop_QV_A(ntryL,G2H8(6),ex5(:),G2H4(102),m3h2x4(:,102),heltab2x8(:,:,102))
  call Hloop_VA_Q(ntryL,G1H8(53),ex2(:),G1H4(1),m3h2x4(:,103),heltab2x8(:,:,103))
  call Hloop_A_Q(ntryL,G1H4(1),43,nMT,G2H4(103),n2h4(17))
  call Hloop_VA_Q(ntryL,G1H8(54),ex2(:),G1H4(1),m3h2x4(:,104),heltab2x8(:,:,104))
  call Hloop_A_Q(ntryL,G1H4(1),43,nMT,G2H4(104),n2h4(18))
  call Hloop_VQ_A(ntryL,G1H8(55),ex1(:),G1H4(1),m3h2x4(:,105),heltab2x8(:,:,105))
  call Hloop_Q_A(ntryL,G1H4(1),39,nMT,G2H4(105),n2h4(19))
call HGT_OLR(G1H8(56),1,1,8)
call HGT_invQ_OLR(G1H8(56),2,5,8)
  call Hloop_A_Q(ntryL,G1H8(56),-16,nMT,G2H8(7),n2h8(213))
  call Hloop_AV_Q(ntryL,G2H8(7),ex5(:),G2H4(106),m3h2x4(:,106),heltab2x8(:,:,106))
  call Hloop_VQ_A(ntryL,G1H8(59),ex1(:),G1H4(1),m3h2x4(:,107),heltab2x8(:,:,107))
  call Hloop_Q_A(ntryL,G1H4(1),39,nMT,G2H4(107),n2h4(20))
  call Hloop_VQ_A(ntryL,G1H8(60),ex1(:),G1H4(1),m3h2x4(:,108),heltab2x8(:,:,108))
  call Hloop_Q_A(ntryL,G1H4(1),39,nMT,G2H4(108),n2h4(21))
  call Hloop_QV_A(ntryL,G1H8(61),ex4(:),G1H4(1),m3h2x4(:,109),heltab2x8(:,:,109))
  call Hloop_Q_A(ntryL,G1H4(1),43,nMT,G2H4(109),n2h4(22))
call HGT_OLR(G1H8(62),1,1,8)
call HGT_invQ_OLR(G1H8(62),2,5,8)
  call Hloop_A_Q(ntryL,G1H8(62),-16,nMT,G2H8(8),n2h8(214))
  call Hloop_AV_Q(ntryL,G2H8(8),ex5(:),G2H4(110),m3h2x4(:,110),heltab2x8(:,:,110))
  call Hloop_QV_A(ntryL,G1H8(65),ex4(:),G1H4(1),m3h2x4(:,111),heltab2x8(:,:,111))
  call Hloop_Q_A(ntryL,G1H4(1),43,nMT,G2H4(111),n2h4(23))
  call Hloop_QV_A(ntryL,G1H8(66),ex4(:),G1H4(1),m3h2x4(:,112),heltab2x8(:,:,112))
  call Hloop_Q_A(ntryL,G1H4(1),43,nMT,G2H4(112),n2h4(24))
  call Hloop_UV_W(ntryL,G1H8(67),35,ex4(:),8,G2H4(113),m3h2x4(:,113),heltab2x8(:,:,113))
call HGT_raise_alpha_OLR(G1H8(68),1,1,8)
call HGT_raise_alpha_invQ_OLR(G1H8(68),2,5,8)
  call Hloop_UV_W(ntryL,G1H8(68),-16,ex5(:),16,G2H4(114),m3h2x4(:,114),heltab2x8(:,:,114))
call signflip_OLR(G2H4(114))
  call Hloop_UV_W(ntryL,G1H8(71),35,ex4(:),8,G2H4(115),m3h2x4(:,115),heltab2x8(:,:,115))
  call Hloop_UV_W(ntryL,G1H8(72),35,ex4(:),8,G2H4(116),m3h2x4(:,116),heltab2x8(:,:,116))
  call Hloop_QV_A(ntryL,G1H8(73),ex4(:),G1H4(1),m3h2x4(:,117),heltab2x8(:,:,117))
  call Hloop_Q_A(ntryL,G1H4(1),43,nMT,G2H4(117),n2h4(25))
call HGT_OLR(G1H8(74),1,1,8)
call HGT_invQ_OLR(G1H8(74),2,5,8)
  call Hloop_A_Q(ntryL,G1H8(74),-4,nMT,G2H8(9),n2h8(216))
  call Hloop_AV_Q(ntryL,G2H8(9),ex3(:),G2H4(118),m3h2x4(:,118),heltab2x8(:,:,118))
  call Hloop_QV_A(ntryL,G1H8(77),ex4(:),G1H4(1),m3h2x4(:,119),heltab2x8(:,:,119))
  call Hloop_Q_A(ntryL,G1H4(1),43,nMT,G2H4(119),n2h4(26))
  call Hloop_QV_A(ntryL,G1H8(78),ex4(:),G1H4(1),m3h2x4(:,120),heltab2x8(:,:,120))
  call Hloop_Q_A(ntryL,G1H4(1),43,nMT,G2H4(120),n2h4(27))
  call Hloop_UV_W(ntryL,G1H8(79),35,ex4(:),8,G2H4(121),m3h2x4(:,121),heltab2x8(:,:,121))
call HGT_raise_alpha_OLR(G1H8(80),1,1,8)
call HGT_raise_alpha_invQ_OLR(G1H8(80),2,5,8)
  call Hloop_UV_W(ntryL,G1H8(80),-4,ex3(:),4,G2H4(122),m3h2x4(:,122),heltab2x8(:,:,122))
call signflip_OLR(G2H4(122))
  call Hloop_UV_W(ntryL,G1H8(83),35,ex4(:),8,G2H4(123),m3h2x4(:,123),heltab2x8(:,:,123))
  call Hloop_UV_W(ntryL,G1H8(84),35,ex4(:),8,G2H4(124),m3h2x4(:,124),heltab2x8(:,:,124))
  call Hloop_VQ_A(ntryL,G1H8(85),ex1(:),G1H4(1),m3h2x4(:,125),heltab2x8(:,:,125))
  call Hloop_Q_A(ntryL,G1H4(1),39,nMT,G2H4(125),n2h4(28))
call HGT_OLR(G1H8(86),1,1,8)
call HGT_invQ_OLR(G1H8(86),2,5,8)
  call Hloop_A_Q(ntryL,G1H8(86),-8,nMT,G2H8(10),n2h8(218))
  call Hloop_AV_Q(ntryL,G2H8(10),ex4(:),G2H4(126),m3h2x4(:,126),heltab2x8(:,:,126))
  call Hloop_VQ_A(ntryL,G1H8(89),ex1(:),G1H4(1),m3h2x4(:,127),heltab2x8(:,:,127))
  call Hloop_Q_A(ntryL,G1H4(1),39,nMT,G2H4(127),n2h4(29))
  call Hloop_VQ_A(ntryL,G1H8(90),ex1(:),G1H4(1),m3h2x4(:,128),heltab2x8(:,:,128))
  call Hloop_Q_A(ntryL,G1H4(1),39,nMT,G2H4(128),n2h4(30))
  call Hloop_QV_A(ntryL,G1H8(91),ex5(:),G1H4(1),m3h2x4(:,129),heltab2x8(:,:,129))
  call Hloop_Q_A(ntryL,G1H4(1),51,nMT,G2H4(129),n2h4(31))
call HGT_OLR(G1H8(92),1,1,8)
call HGT_invQ_OLR(G1H8(92),2,5,8)
  call Hloop_A_Q(ntryL,G1H8(92),-8,nMT,G2H8(11),n2h8(219))
  call Hloop_AV_Q(ntryL,G2H8(11),ex4(:),G2H4(130),m3h2x4(:,130),heltab2x8(:,:,130))
  call Hloop_QV_A(ntryL,G1H8(95),ex5(:),G1H4(1),m3h2x4(:,131),heltab2x8(:,:,131))
  call Hloop_Q_A(ntryL,G1H4(1),51,nMT,G2H4(131),n2h4(32))
  call Hloop_QV_A(ntryL,G1H8(96),ex5(:),G1H4(1),m3h2x4(:,132),heltab2x8(:,:,132))
  call Hloop_Q_A(ntryL,G1H4(1),51,nMT,G2H4(132),n2h4(33))
  call Hloop_UV_W(ntryL,G1H8(97),35,ex5(:),16,G2H4(133),m3h2x4(:,133),heltab2x8(:,:,133))
call HGT_raise_alpha_OLR(G1H8(98),1,1,8)
call HGT_raise_alpha_invQ_OLR(G1H8(98),2,5,8)
  call Hloop_UV_W(ntryL,G1H8(98),-8,ex4(:),8,G2H4(134),m3h2x4(:,134),heltab2x8(:,:,134))
call signflip_OLR(G2H4(134))
  call Hloop_UV_W(ntryL,G1H8(101),35,ex5(:),16,G2H4(135),m3h2x4(:,135),heltab2x8(:,:,135))
  call Hloop_UV_W(ntryL,G1H8(102),35,ex5(:),16,G2H4(136),m3h2x4(:,136),heltab2x8(:,:,136))
  call Hloop_QV_A(ntryL,G1H8(103),ex5(:),G1H4(1),m3h2x4(:,137),heltab2x8(:,:,137))
  call Hloop_Q_A(ntryL,G1H4(1),51,nMT,G2H4(137),n2h4(34))
call HGT_OLR(G1H8(104),1,1,8)
call HGT_invQ_OLR(G1H8(104),2,5,8)
  call Hloop_A_Q(ntryL,G1H8(104),-4,nMT,G2H8(12),n2h8(221))
  call Hloop_AV_Q(ntryL,G2H8(12),ex3(:),G2H4(138),m3h2x4(:,138),heltab2x8(:,:,138))
  call Hloop_QV_A(ntryL,G1H8(107),ex5(:),G1H4(1),m3h2x4(:,139),heltab2x8(:,:,139))
  call Hloop_Q_A(ntryL,G1H4(1),51,nMT,G2H4(139),n2h4(35))
  call Hloop_QV_A(ntryL,G1H8(108),ex5(:),G1H4(1),m3h2x4(:,140),heltab2x8(:,:,140))
  call Hloop_Q_A(ntryL,G1H4(1),51,nMT,G2H4(140),n2h4(36))
  call Hloop_UV_W(ntryL,G1H8(109),35,ex5(:),16,G2H4(141),m3h2x4(:,141),heltab2x8(:,:,141))
call HGT_raise_alpha_OLR(G1H8(110),1,1,8)
call HGT_raise_alpha_invQ_OLR(G1H8(110),2,5,8)
  call Hloop_UV_W(ntryL,G1H8(110),-4,ex3(:),4,G2H4(142),m3h2x4(:,142),heltab2x8(:,:,142))
call signflip_OLR(G2H4(142))
  call Hloop_UV_W(ntryL,G1H8(113),35,ex5(:),16,G2H4(143),m3h2x4(:,143),heltab2x8(:,:,143))
  call Hloop_UV_W(ntryL,G1H8(114),35,ex5(:),16,G2H4(144),m3h2x4(:,144),heltab2x8(:,:,144))
  call Hloop_AV_Q(ntryL,G1H8(115),ex3(:),G1H4(1),m3h2x4(:,145),heltab2x8(:,:,145))
  call Hloop_A_Q(ntryL,G1H4(1),39,nMT,G2H4(145),n2h4(37))
call HGT_OLR(G1H8(116),1,1,8)
call HGT_invQ_OLR(G1H8(116),2,5,8)
  call Hloop_Q_A(ntryL,G1H8(116),-16,nMT,G2H8(13),n2h8(223))
  call Hloop_QV_A(ntryL,G2H8(13),ex5(:),G2H4(146),m3h2x4(:,146),heltab2x8(:,:,146))
  call Hloop_AV_Q(ntryL,G1H8(119),ex3(:),G1H4(1),m3h2x4(:,147),heltab2x8(:,:,147))
  call Hloop_A_Q(ntryL,G1H4(1),39,nMT,G2H4(147),n2h4(38))
  call Hloop_AV_Q(ntryL,G1H8(120),ex3(:),G1H4(1),m3h2x4(:,148),heltab2x8(:,:,148))
  call Hloop_A_Q(ntryL,G1H4(1),39,nMT,G2H4(148),n2h4(39))
  call Hloop_UV_W(ntryL,G1H8(121),35,ex3(:),4,G2H4(149),m3h2x4(:,149),heltab2x8(:,:,149))
call HGT_raise_alpha_OLR(G1H8(122),1,1,8)
call HGT_raise_alpha_invQ_OLR(G1H8(122),2,5,8)
  call Hloop_UV_W(ntryL,G1H8(122),-16,ex5(:),16,G2H4(150),m3h2x4(:,150),heltab2x8(:,:,150))
call signflip_OLR(G2H4(150))
  call Hloop_UV_W(ntryL,G1H8(125),35,ex3(:),4,G2H4(151),m3h2x4(:,151),heltab2x8(:,:,151))
  call Hloop_UV_W(ntryL,G1H8(126),35,ex3(:),4,G2H4(152),m3h2x4(:,152),heltab2x8(:,:,152))
  call Hloop_AV_Q(ntryL,G1H8(127),ex3(:),G1H4(1),m3h2x4(:,153),heltab2x8(:,:,153))
  call Hloop_A_Q(ntryL,G1H4(1),39,nMT,G2H4(153),n2h4(40))
call HGT_OLR(G1H8(128),1,1,8)
call HGT_invQ_OLR(G1H8(128),2,5,8)
  call Hloop_Q_A(ntryL,G1H8(128),-8,nMT,G2H8(14),n2h8(225))
  call Hloop_QV_A(ntryL,G2H8(14),ex4(:),G2H4(154),m3h2x4(:,154),heltab2x8(:,:,154))
  call Hloop_AV_Q(ntryL,G1H8(131),ex3(:),G1H4(1),m3h2x4(:,155),heltab2x8(:,:,155))
  call Hloop_A_Q(ntryL,G1H4(1),39,nMT,G2H4(155),n2h4(41))
  call Hloop_AV_Q(ntryL,G1H8(132),ex3(:),G1H4(1),m3h2x4(:,156),heltab2x8(:,:,156))
  call Hloop_A_Q(ntryL,G1H4(1),39,nMT,G2H4(156),n2h4(42))
  call Hloop_UV_W(ntryL,G1H8(133),35,ex3(:),4,G2H4(157),m3h2x4(:,157),heltab2x8(:,:,157))
call HGT_raise_alpha_OLR(G1H8(134),1,1,8)
call HGT_raise_alpha_invQ_OLR(G1H8(134),2,5,8)
  call Hloop_UV_W(ntryL,G1H8(134),-8,ex4(:),8,G2H4(158),m3h2x4(:,158),heltab2x8(:,:,158))
call signflip_OLR(G2H4(158))
  call Hloop_UV_W(ntryL,G1H8(137),35,ex3(:),4,G2H4(159),m3h2x4(:,159),heltab2x8(:,:,159))
  call Hloop_UV_W(ntryL,G1H8(138),35,ex3(:),4,G2H4(160),m3h2x4(:,160),heltab2x8(:,:,160))
  call Hloop_AV_Q(ntryL,G1H8(139),ex4(:),G1H4(1),m3h2x4(:,161),heltab2x8(:,:,161))
  call Hloop_A_Q(ntryL,G1H4(1),43,nMT,G2H4(161),n2h4(43))
call HGT_OLR(G1H8(140),1,1,8)
call HGT_invQ_OLR(G1H8(140),2,5,8)
  call Hloop_Q_A(ntryL,G1H8(140),-16,nMT,G2H8(15),n2h8(227))
  call Hloop_QV_A(ntryL,G2H8(15),ex5(:),G2H4(162),m3h2x4(:,162),heltab2x8(:,:,162))
  call Hloop_AV_Q(ntryL,G1H8(143),ex4(:),G1H4(1),m3h2x4(:,163),heltab2x8(:,:,163))
  call Hloop_A_Q(ntryL,G1H4(1),43,nMT,G2H4(163),n2h4(44))
  call Hloop_AV_Q(ntryL,G1H8(144),ex4(:),G1H4(1),m3h2x4(:,164),heltab2x8(:,:,164))
  call Hloop_A_Q(ntryL,G1H4(1),43,nMT,G2H4(164),n2h4(45))
  call Hloop_UV_W(ntryL,G1H8(145),35,ex4(:),8,G2H4(165),m3h2x4(:,165),heltab2x8(:,:,165))
call HGT_raise_alpha_OLR(G1H8(146),1,1,8)
call HGT_raise_alpha_invQ_OLR(G1H8(146),2,5,8)
  call Hloop_UV_W(ntryL,G1H8(146),-16,ex5(:),16,G2H4(166),m3h2x4(:,166),heltab2x8(:,:,166))
call signflip_OLR(G2H4(166))
  call Hloop_UV_W(ntryL,G1H8(149),35,ex4(:),8,G2H4(167),m3h2x4(:,167),heltab2x8(:,:,167))
  call Hloop_UV_W(ntryL,G1H8(150),35,ex4(:),8,G2H4(168),m3h2x4(:,168),heltab2x8(:,:,168))
  call Hloop_AV_Q(ntryL,G1H8(151),ex4(:),G1H4(1),m3h2x4(:,169),heltab2x8(:,:,169))
  call Hloop_A_Q(ntryL,G1H4(1),43,nMT,G2H4(169),n2h4(46))
call HGT_OLR(G1H8(152),1,1,8)
call HGT_invQ_OLR(G1H8(152),2,5,8)
  call Hloop_Q_A(ntryL,G1H8(152),-4,nMT,G2H8(16),n2h8(229))
  call Hloop_QV_A(ntryL,G2H8(16),ex3(:),G2H4(170),m3h2x4(:,170),heltab2x8(:,:,170))
  call Hloop_AV_Q(ntryL,G1H8(155),ex4(:),G1H4(1),m3h2x4(:,171),heltab2x8(:,:,171))
  call Hloop_A_Q(ntryL,G1H4(1),43,nMT,G2H4(171),n2h4(47))
  call Hloop_AV_Q(ntryL,G1H8(156),ex4(:),G1H4(1),m3h2x4(:,172),heltab2x8(:,:,172))
  call Hloop_A_Q(ntryL,G1H4(1),43,nMT,G2H4(172),n2h4(48))
  call Hloop_UV_W(ntryL,G1H8(157),35,ex4(:),8,G2H4(173),m3h2x4(:,173),heltab2x8(:,:,173))
call HGT_raise_alpha_OLR(G1H8(158),1,1,8)
call HGT_raise_alpha_invQ_OLR(G1H8(158),2,5,8)
  call Hloop_UV_W(ntryL,G1H8(158),-4,ex3(:),4,G2H4(174),m3h2x4(:,174),heltab2x8(:,:,174))
call signflip_OLR(G2H4(174))
  call Hloop_UV_W(ntryL,G1H8(161),35,ex4(:),8,G2H4(175),m3h2x4(:,175),heltab2x8(:,:,175))
  call Hloop_UV_W(ntryL,G1H8(162),35,ex4(:),8,G2H4(176),m3h2x4(:,176),heltab2x8(:,:,176))
  call Hloop_AV_Q(ntryL,G1H8(163),ex5(:),G1H4(1),m3h2x4(:,177),heltab2x8(:,:,177))
  call Hloop_A_Q(ntryL,G1H4(1),51,nMT,G2H4(177),n2h4(49))
call HGT_OLR(G1H8(164),1,1,8)
call HGT_invQ_OLR(G1H8(164),2,5,8)
  call Hloop_Q_A(ntryL,G1H8(164),-8,nMT,G2H8(17),n2h8(231))
  call Hloop_QV_A(ntryL,G2H8(17),ex4(:),G2H4(178),m3h2x4(:,178),heltab2x8(:,:,178))
  call Hloop_AV_Q(ntryL,G1H8(167),ex5(:),G1H4(1),m3h2x4(:,179),heltab2x8(:,:,179))
  call Hloop_A_Q(ntryL,G1H4(1),51,nMT,G2H4(179),n2h4(50))
  call Hloop_AV_Q(ntryL,G1H8(168),ex5(:),G1H4(1),m3h2x4(:,180),heltab2x8(:,:,180))
  call Hloop_A_Q(ntryL,G1H4(1),51,nMT,G2H4(180),n2h4(51))
  call Hloop_UV_W(ntryL,G1H8(169),35,ex5(:),16,G2H4(181),m3h2x4(:,181),heltab2x8(:,:,181))
call HGT_raise_alpha_OLR(G1H8(170),1,1,8)
call HGT_raise_alpha_invQ_OLR(G1H8(170),2,5,8)
  call Hloop_UV_W(ntryL,G1H8(170),-8,ex4(:),8,G2H4(182),m3h2x4(:,182),heltab2x8(:,:,182))
call signflip_OLR(G2H4(182))
  call Hloop_UV_W(ntryL,G1H8(173),35,ex5(:),16,G2H4(183),m3h2x4(:,183),heltab2x8(:,:,183))
  call Hloop_UV_W(ntryL,G1H8(174),35,ex5(:),16,G2H4(184),m3h2x4(:,184),heltab2x8(:,:,184))
  call Hloop_AV_Q(ntryL,G1H8(175),ex5(:),G1H4(1),m3h2x4(:,185),heltab2x8(:,:,185))
  call Hloop_A_Q(ntryL,G1H4(1),51,nMT,G2H4(185),n2h4(52))
call HGT_OLR(G1H8(176),1,1,8)
call HGT_invQ_OLR(G1H8(176),2,5,8)
  call Hloop_Q_A(ntryL,G1H8(176),-4,nMT,G2H8(18),n2h8(233))
  call Hloop_QV_A(ntryL,G2H8(18),ex3(:),G2H4(186),m3h2x4(:,186),heltab2x8(:,:,186))
  call Hloop_AV_Q(ntryL,G1H8(179),ex5(:),G1H4(1),m3h2x4(:,187),heltab2x8(:,:,187))
  call Hloop_A_Q(ntryL,G1H4(1),51,nMT,G2H4(187),n2h4(53))
  call Hloop_AV_Q(ntryL,G1H8(180),ex5(:),G1H4(1),m3h2x4(:,188),heltab2x8(:,:,188))
  call Hloop_A_Q(ntryL,G1H4(1),51,nMT,G2H4(188),n2h4(54))
  call Hloop_UV_W(ntryL,G1H8(181),35,ex5(:),16,G2H4(189),m3h2x4(:,189),heltab2x8(:,:,189))
call HGT_raise_alpha_OLR(G1H8(182),1,1,8)
call HGT_raise_alpha_invQ_OLR(G1H8(182),2,5,8)
  call Hloop_UV_W(ntryL,G1H8(182),-4,ex3(:),4,G2H4(190),m3h2x4(:,190),heltab2x8(:,:,190))
call signflip_OLR(G2H4(190))
  call Hloop_UV_W(ntryL,G1H8(185),35,ex5(:),16,G2H4(191),m3h2x4(:,191),heltab2x8(:,:,191))
  call Hloop_UV_W(ntryL,G1H8(186),35,ex5(:),16,G2H4(192),m3h2x4(:,192),heltab2x8(:,:,192))
  call Hloop_UV_W(ntryL,G1H8(187),41,ex3(:),4,G2H4(193),m3h2x4(:,193),heltab2x8(:,:,193))
call HGT_OLR(G1H8(188),1,1,8)
call HGT_invQ_OLR(G1H8(188),2,5,8)
  call Hloop_Q_A(ntryL,G1H8(188),-16,nMT,G2H8(19),n2h8(235))
  call Hloop_QV_A(ntryL,G2H8(19),ex5(:),G2H4(194),m3h2x4(:,194),heltab2x8(:,:,194))
  call Hloop_UV_W(ntryL,G1H8(191),41,ex3(:),4,G2H4(195),m3h2x4(:,195),heltab2x8(:,:,195))
  call Hloop_UV_W(ntryL,G1H8(192),41,ex3(:),4,G2H4(196),m3h2x4(:,196),heltab2x8(:,:,196))
  call Hloop_VQ_A(ntryL,G1H8(193),ex1(:),G1H4(1),m3h2x4(:,197),heltab2x8(:,:,197))
  call Hloop_Q_A(ntryL,G1H4(1),39,nMT,G2H4(197),n2h4(55))
call HGT_OLR(G1H8(194),1,1,8)
call HGT_invQ_OLR(G1H8(194),2,5,8)
  call Hloop_A_Q(ntryL,G1H8(194),-16,nMT,G2H8(20),n2h8(236))
  call Hloop_AV_Q(ntryL,G2H8(20),ex5(:),G2H4(198),m3h2x4(:,198),heltab2x8(:,:,198))
  call Hloop_VQ_A(ntryL,G1H8(197),ex1(:),G1H4(1),m3h2x4(:,199),heltab2x8(:,:,199))
  call Hloop_Q_A(ntryL,G1H4(1),39,nMT,G2H4(199),n2h4(56))
  call Hloop_VQ_A(ntryL,G1H8(198),ex1(:),G1H4(1),m3h2x4(:,200),heltab2x8(:,:,200))
  call Hloop_Q_A(ntryL,G1H4(1),39,nMT,G2H4(200),n2h4(57))
  call Hloop_UV_W(ntryL,G1H8(199),37,ex4(:),8,G2H4(201),m3h2x4(:,201),heltab2x8(:,:,201))
call HGT_OLR(G1H8(200),1,1,8)
call HGT_invQ_OLR(G1H8(200),2,5,8)
  call Hloop_Q_A(ntryL,G1H8(200),-16,nMT,G2H8(21),n2h8(237))
  call Hloop_QV_A(ntryL,G2H8(21),ex5(:),G2H4(202),m3h2x4(:,202),heltab2x8(:,:,202))
  call Hloop_UV_W(ntryL,G1H8(203),37,ex4(:),8,G2H4(203),m3h2x4(:,203),heltab2x8(:,:,203))
  call Hloop_UV_W(ntryL,G1H8(204),37,ex4(:),8,G2H4(204),m3h2x4(:,204),heltab2x8(:,:,204))
  call Hloop_VQ_A(ntryL,G1H8(205),ex1(:),G1H4(1),m3h2x4(:,205),heltab2x8(:,:,205))
  call Hloop_Q_A(ntryL,G1H4(1),43,nMT,G2H4(205),n2h4(58))
call HGT_OLR(G1H8(206),1,1,8)
call HGT_invQ_OLR(G1H8(206),2,5,8)
  call Hloop_A_Q(ntryL,G1H8(206),-16,nMT,G2H8(22),n2h8(238))
  call Hloop_AV_Q(ntryL,G2H8(22),ex5(:),G2H4(206),m3h2x4(:,206),heltab2x8(:,:,206))
  call Hloop_VQ_A(ntryL,G1H8(209),ex1(:),G1H4(1),m3h2x4(:,207),heltab2x8(:,:,207))
  call Hloop_Q_A(ntryL,G1H4(1),43,nMT,G2H4(207),n2h4(59))
  call Hloop_VQ_A(ntryL,G1H8(210),ex1(:),G1H4(1),m3h2x4(:,208),heltab2x8(:,:,208))
  call Hloop_Q_A(ntryL,G1H4(1),43,nMT,G2H4(208),n2h4(60))
  call Hloop_UV_W(ntryL,G1H8(211),50,ex3(:),4,G2H4(209),m3h2x4(:,209),heltab2x8(:,:,209))
call HGT_OLR(G1H8(212),1,1,8)
call HGT_invQ_OLR(G1H8(212),2,5,8)
  call Hloop_A_Q(ntryL,G1H8(212),-8,nMT,G2H8(23),n2h8(239))
  call Hloop_AV_Q(ntryL,G2H8(23),ex4(:),G2H4(210),m3h2x4(:,210),heltab2x8(:,:,210))
  call Hloop_UV_W(ntryL,G1H8(215),50,ex3(:),4,G2H4(211),m3h2x4(:,211),heltab2x8(:,:,211))
  call Hloop_UV_W(ntryL,G1H8(216),50,ex3(:),4,G2H4(212),m3h2x4(:,212),heltab2x8(:,:,212))
  call Hloop_UV_W(ntryL,G1H8(217),50,ex4(:),8,G2H4(213),m3h2x4(:,213),heltab2x8(:,:,213))
call HGT_OLR(G1H8(218),1,1,8)
call HGT_invQ_OLR(G1H8(218),2,5,8)
  call Hloop_A_Q(ntryL,G1H8(218),-4,nMT,G2H8(24),n2h8(240))
  call Hloop_AV_Q(ntryL,G2H8(24),ex3(:),G2H4(214),m3h2x4(:,214),heltab2x8(:,:,214))
  call Hloop_UV_W(ntryL,G1H8(221),50,ex4(:),8,G2H4(215),m3h2x4(:,215),heltab2x8(:,:,215))
  call Hloop_UV_W(ntryL,G1H8(222),50,ex4(:),8,G2H4(216),m3h2x4(:,216),heltab2x8(:,:,216))
  call Hloop_UV_W(ntryL,G1H8(223),42,ex3(:),4,G2H4(217),m3h2x4(:,217),heltab2x8(:,:,217))
call HGT_OLR(G1H8(224),1,1,8)
call HGT_invQ_OLR(G1H8(224),2,5,8)
  call Hloop_A_Q(ntryL,G1H8(224),-16,nMT,G2H8(25),n2h8(241))
  call Hloop_AV_Q(ntryL,G2H8(25),ex5(:),G2H4(218),m3h2x4(:,218),heltab2x8(:,:,218))
  call Hloop_UV_W(ntryL,G1H8(227),42,ex3(:),4,G2H4(219),m3h2x4(:,219),heltab2x8(:,:,219))
  call Hloop_UV_W(ntryL,G1H8(228),42,ex3(:),4,G2H4(220),m3h2x4(:,220),heltab2x8(:,:,220))
  call Hloop_VQ_A(ntryL,G1H8(229),ex1(:),G1H4(1),m3h2x4(:,221),heltab2x8(:,:,221))
  call Hloop_Q_A(ntryL,G1H4(1),39,nMT,G2H4(221),n2h4(61))
call HGT_OLR(G1H8(230),1,1,8)
call HGT_invQ_OLR(G1H8(230),2,5,8)
  call Hloop_A_Q(ntryL,G1H8(230),-8,nMT,G2H8(26),n2h8(242))
  call Hloop_AV_Q(ntryL,G2H8(26),ex4(:),G2H4(222),m3h2x4(:,222),heltab2x8(:,:,222))
  call Hloop_VQ_A(ntryL,G1H8(233),ex1(:),G1H4(1),m3h2x4(:,223),heltab2x8(:,:,223))
  call Hloop_Q_A(ntryL,G1H4(1),39,nMT,G2H4(223),n2h4(62))
  call Hloop_VQ_A(ntryL,G1H8(234),ex1(:),G1H4(1),m3h2x4(:,224),heltab2x8(:,:,224))
  call Hloop_Q_A(ntryL,G1H4(1),39,nMT,G2H4(224),n2h4(63))
  call Hloop_UV_W(ntryL,G1H8(235),37,ex5(:),16,G2H4(225),m3h2x4(:,225),heltab2x8(:,:,225))
call HGT_OLR(G1H8(236),1,1,8)
call HGT_invQ_OLR(G1H8(236),2,5,8)
  call Hloop_Q_A(ntryL,G1H8(236),-8,nMT,G2H8(27),n2h8(243))
  call Hloop_QV_A(ntryL,G2H8(27),ex4(:),G2H4(226),m3h2x4(:,226),heltab2x8(:,:,226))
  call Hloop_UV_W(ntryL,G1H8(239),37,ex5(:),16,G2H4(227),m3h2x4(:,227),heltab2x8(:,:,227))



end subroutine vamp_1

end module ol_vamp_1_ppttjj_ttxgggg_1_/**/REALKIND
