
module ol_vamp_19_ppttjj_ttxgggg_1_/**/REALKIND
contains

! **********************************************************************
subroutine vamp_19(M)
! P(0:3,nlegs) = incoming external momenta
! Uses tree structures 'wf', factors 'c', and denominators 'den' from loop_ppttjj_ttxgggg_1.
! Sets colour stripped amplitudes A from the module loop_amplitudes_ppttjj_ttxgggg_1.
! **********************************************************************
  use KIND_TYPES, only: REALKIND, QREALKIND, intkind2
  use ol_parameters_decl_/**/DREALKIND, only: l_switch
  use ol_parameters_decl_/**/QREALKIND ! masses
  use ol_vert_interface_/**/REALKIND
  use ol_prop_interface_/**/REALKIND
  use ol_last_step_/**/REALKIND
  use ol_tables_storage_ppttjj_ttxgggg_1_/**/DREALKIND
  use ol_tensor_sum_storage_ppttjj_ttxgggg_1_/**/REALKIND
  use ol_loop_handling_/**/REALKIND
  use ofred_reduction_/**/REALKIND, only: Hotf_4pt_reduction, Hotf_4pt_reduction_last
  use ofred_reduction_/**/REALKIND, only: Hotf_5pt_reduction, Hotf_5pt_reduction_last
  use ol_loop_reduction_/**/REALKIND, only: TI_bubble_red, TI_triangle_red
use ol_loop_reduction_/**/REALKIND, only: compute_scalar_box

  use ol_loop_storage_ppttjj_ttxgggg_1_/**/REALKIND
#ifndef PRECISION_dp
  use ol_loop_storage_ppttjj_ttxgggg_1_/**/DREALKIND, only: &
    & ntryL, p_switch, Hel, merge_step, merge_mism, merge_tables, merge_hels
#endif
  use hol_initialisation_/**/REALKIND, only: G0_hol_initialisation
  use ol_h_vert_interface_/**/REALKIND
  use ol_h_prop_interface_/**/REALKIND
  use ol_h_last_step_/**/REALKIND
  use ol_merging_/**/REALKIND, only: ol_merge, ol_merge_tensors, ol_merge_last

  implicit none

  type(Hpolcont) :: Gcoeff(64)
  type(Hpolcont), intent(in) :: M(50,64)


#ifndef PRECISION_dp
  if (ntryL==1 .OR. p_switch == 1) Gcoeff(:)%hf = Hel
#else
  if (ntryL==1 .OR. p_switch == 2) Gcoeff(:)%hf = Hel
#endif

  ! =============================================
  Gcoeff(:)%j = (c(9)*(-M(7,:)%j+M(8,:)%j)+c(6)*(-M(25,:)%j+M(26,:)%j)) * den(127)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(2496),h0tab(:,2496),[49,2,8,4],[nMT,0,0,0],4,1,wf8(:,76))
  call Hloop_VQ_A(ntryL,G0H64(1),wf8(:,76),G0H8(142),m3h8x8(:,297),heltab2x64(:,:,2082))
  call Hloop_Q_A(ntryL,G0H8(142),49,nMT,G1H8(813),n2h8(1484))
  Gcoeff(:)%j = (c(16)*(M(25,:)%j-M(26,:)%j)) * den(95)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(2497),h0tab(:,2497),[50,4,1,8],[nMT,nMT,0,0],4,1,wf8(:,56))
  call Hloop_VA_Q(ntryL,G0H64(1),wf8(:,56),G0H8(142),m3h8x8(:,298),heltab2x64(:,:,2083))
  call Hloop_A_Q(ntryL,G0H8(142),50,nMT,G1H8(831),n2h8(1485))
  Gcoeff(:)%j = (c(16)*(-M(25,:)%j+M(26,:)%j)) * den(95)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(2498),h0tab(:,2498),[50,4,1,8],[0,0,nMT,nMT],4,1,wf8(:,56))
  call Hloop_QA_V(ntryL,G0H64(1),wf8(:,56),G0H8(142),m3h8x8(:,299),heltab2x64(:,:,2084))
  Gcoeff(:)%j = (c(5)*(M(18,:)%j-M(24,:)%j)+c(6)*(-M(25,:)%j+M(26,:)%j)) * den(95)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(2499),h0tab(:,2499),[50,1,4,8],[0,nMT,nMT,nMT],4,1,wf8(:,56))
  call Hloop_QA_V(ntryL,G0H64(1),wf8(:,56),G0H8(143),m3h8x8(:,300),heltab2x64(:,:,2085))
  Gcoeff(:)%j = (c(9)*(-M(18,:)%j+M(24,:)%j)+c(6)*(-M(25,:)%j+M(26,:)%j)) * den(95)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(2500),h0tab(:,2500),[50,1,4,8],[nMT,0,0,0],4,1,wf8(:,56))
  call Hloop_VA_Q(ntryL,G0H64(1),wf8(:,56),G0H8(144),m3h8x8(:,301),heltab2x64(:,:,2086))
  call Hloop_A_Q(ntryL,G0H8(144),50,nMT,G1H8(832),n2h8(1486))
  Gcoeff(:)%j = (c(5)*(M(17,:)%j-M(23,:)%j)+c(6)*(-M(25,:)%j+M(26,:)%j)) * den(95)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(2501),h0tab(:,2501),[50,1,8,4],[0,nMT,nMT,nMT],4,1,wf8(:,56))
  call Hloop_QA_V(ntryL,G0H64(1),wf8(:,56),G0H8(144),m3h8x8(:,302),heltab2x64(:,:,2087))
  Gcoeff(:)%j = (c(9)*(-M(17,:)%j+M(23,:)%j)+c(6)*(-M(25,:)%j+M(26,:)%j)) * den(95)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(2502),h0tab(:,2502),[50,1,8,4],[nMT,0,0,0],4,1,wf8(:,56))
  call Hloop_VA_Q(ntryL,G0H64(1),wf8(:,56),G0H8(145),m3h8x8(:,303),heltab2x64(:,:,2088))
  call Hloop_A_Q(ntryL,G0H8(145),50,nMT,G1H8(843),n2h8(1487))
  Gcoeff(:)%j = (c(15)*(-M(4,:)%j+M(6,:)%j+M(17,:)%j-M(23,:)%j)+c(16)*(-M(45,:)%j+M(46,:)%j+M(48,:)%j-M(50,:)%j)) * den(63)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(2503),h0tab(:,2503),[52,2,1,8],[nMT,0,nMT,nMT],4,1,wf8(:,36))
  call Hloop_QV_A(ntryL,G0H64(1),wf8(:,36),G0H8(145),m3h8x8(:,304),heltab2x64(:,:,2089))
  call Hloop_Q_A(ntryL,G0H8(145),52,nMT,G1H8(844),n2h8(1488))
  Gcoeff(:)%j = (c(19)*(M(4,:)%j-M(6,:)%j-M(17,:)%j+M(23,:)%j)+c(16)*(-M(45,:)%j+M(46,:)%j+M(48,:)%j-M(50,:)%j)) * den(63)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(2504),h0tab(:,2504),[52,2,1,8],[0,nMT,0,0],4,1,wf8(:,36))
  call Hloop_UV_W(ntryL,G0H64(1),0,wf8(:,36),52,G1H8(861),m3h8x8(:,305),heltab2x64(:,:,2090))
  Gcoeff(:)%j = (c(15)*(-M(7,:)%j+M(8,:)%j+M(10,:)%j-M(12,:)%j)+c(16)*(-M(45,:)%j+M(46,:)%j+M(48,:)%j-M(50,:)%j)) * den(63)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(2505),h0tab(:,2505),[52,1,2,8],[nMT,0,nMT,nMT],4,1,wf8(:,36))
  call Hloop_AV_Q(ntryL,G0H64(1),wf8(:,36),G0H8(145),m3h8x8(:,306),heltab2x64(:,:,2091))
  call Hloop_A_Q(ntryL,G0H8(145),52,nMT,G1H8(862),n2h8(1489))
  Gcoeff(:)%j = (c(19)*(M(7,:)%j-M(8,:)%j-M(10,:)%j+M(12,:)%j)+c(16)*(-M(45,:)%j+M(46,:)%j+M(48,:)%j-M(50,:)%j)) * den(63)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(2506),h0tab(:,2506),[52,1,2,8],[0,nMT,0,0],4,1,wf8(:,36))
  call Hloop_UV_W(ntryL,G0H64(1),0,wf8(:,36),52,G1H8(867),m3h8x8(:,307),heltab2x64(:,:,2092))
  Gcoeff(:)%j = (c(6)*(-M(45,:)%j+M(46,:)%j+M(48,:)%j-M(50,:)%j)) * den(63)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(2507),h0tab(:,2507),[52,1,8,2],[0,nMT,nMT,0],4,1,wf8(:,36))
  call Hloop_UV_W(ntryL,G0H64(1),0,wf8(:,36),52,G1H8(868),m3h8x8(:,308),heltab2x64(:,:,2093))
  Gcoeff(:)%j = (c(6)*(M(45,:)%j-M(46,:)%j-M(48,:)%j+M(50,:)%j)) * den(63)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(2508),h0tab(:,2508),[52,1,8,2],[nMT,0,0,nMT],4,1,wf8(:,36))
  call Hloop_AV_Q(ntryL,G0H64(1),wf8(:,36),G0H8(145),m3h8x8(:,309),heltab2x64(:,:,2094))
  call Hloop_A_Q(ntryL,G0H8(145),52,nMT,G1H8(885),n2h8(1490))
  Gcoeff(:)%j = (c(15)*(-M(10,:)%j+M(12,:)%j+M(18,:)%j-M(24,:)%j)+c(16)*(M(45,:)%j-M(46,:)%j-M(48,:)%j+M(50,:)%j)) * den(276)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(2509),h0tab(:,2509),[56,2,1,4],[nMT,0,nMT,nMT],4,1,wf8(:,35))
  call Hloop_QV_A(ntryL,G0H64(1),wf8(:,35),G0H8(145),m3h8x8(:,310),heltab2x64(:,:,2095))
  call Hloop_Q_A(ntryL,G0H8(145),56,nMT,G1H8(886),n2h8(1491))
  Gcoeff(:)%j = (c(19)*(M(10,:)%j-M(12,:)%j-M(18,:)%j+M(24,:)%j)+c(16)*(M(45,:)%j-M(46,:)%j-M(48,:)%j+M(50,:)%j)) * den(276)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(2510),h0tab(:,2510),[56,2,1,4],[0,nMT,0,0],4,1,wf8(:,35))
  call Hloop_UV_W(ntryL,G0H64(1),0,wf8(:,35),56,G1H8(897),m3h8x8(:,311),heltab2x64(:,:,2096))
  Gcoeff(:)%j = (c(15)*(-M(1,:)%j+M(2,:)%j+M(4,:)%j-M(6,:)%j)+c(16)*(M(45,:)%j-M(46,:)%j-M(48,:)%j+M(50,:)%j)) * den(276)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(2511),h0tab(:,2511),[56,1,2,4],[nMT,0,nMT,nMT],4,1,wf8(:,35))
  call Hloop_AV_Q(ntryL,G0H64(1),wf8(:,35),G0H8(145),m3h8x8(:,312),heltab2x64(:,:,2097))
  call Hloop_A_Q(ntryL,G0H8(145),56,nMT,G1H8(898),n2h8(1492))
  Gcoeff(:)%j = (c(19)*(M(1,:)%j-M(2,:)%j-M(4,:)%j+M(6,:)%j)+c(16)*(M(45,:)%j-M(46,:)%j-M(48,:)%j+M(50,:)%j)) * den(276)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(2512),h0tab(:,2512),[56,1,2,4],[0,nMT,0,0],4,1,wf8(:,35))
  call Hloop_UV_W(ntryL,G0H64(1),0,wf8(:,35),56,G1H8(915),m3h8x8(:,313),heltab2x64(:,:,2098))
  Gcoeff(:)%j = (c(6)*(M(45,:)%j-M(46,:)%j-M(48,:)%j+M(50,:)%j)) * den(276)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(2513),h0tab(:,2513),[56,1,4,2],[0,nMT,nMT,0],4,1,wf8(:,35))
  call Hloop_UV_W(ntryL,G0H64(1),0,wf8(:,35),56,G1H8(916),m3h8x8(:,314),heltab2x64(:,:,2099))
  Gcoeff(:)%j = (c(6)*(-M(45,:)%j+M(46,:)%j+M(48,:)%j-M(50,:)%j)) * den(276)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(2514),h0tab(:,2514),[56,1,4,2],[nMT,0,0,nMT],4,1,wf8(:,35))
  call Hloop_AV_Q(ntryL,G0H64(1),wf8(:,35),G0H8(145),m3h8x8(:,315),heltab2x64(:,:,2100))
  call Hloop_A_Q(ntryL,G0H8(145),56,nMT,G1H8(921),n2h8(1493))
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H8(897),[G1H8(190),G1H8(587),G1H8(485),G1H8(482),G1H8(687) &
    ,G1H8(223),G0H8(66),G0H8(65),G0H8(64),G0H8(48),G0H8(47),G0H8(46),G0H8(30),G0H8(29),G0H8(28)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H8(867),[G1H8(88),G1H8(516),G1H8(907),G1H8(906),G1H8(870) &
    ,G1H8(18),G1H8(414),G1H8(233),G0H8(87),G0H8(86),G0H8(85),G0H8(42),G0H8(41),G0H8(40),G0H8(24),G0H8(23),G0H8(22)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H8(166),[G1H8(196),G1H8(1519),G1H8(1072),G1H8(1071) &
    ,G1H8(1056),G1H8(98),G1H8(269),G1H8(259),G0H8(78),G0H8(77),G0H8(76),G0H8(60),G0H8(59),G0H8(58),G0H8(15),G0H8(14),G0H8(13)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H8(915),[G1H8(759),G1H8(605),G1H8(595),G1H8(584),G1H8(559) &
    ,G1H8(277),G0H8(69),G0H8(68),G0H8(67),G0H8(51),G0H8(50),G0H8(49),G0H8(33),G0H8(32),G0H8(31)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H8(861),[G1H8(81),G1H8(479),G1H8(799),G1H8(798),G1H8(764) &
    ,G1H8(115),G1H8(331),G1H8(287),G0H8(84),G0H8(83),G0H8(82),G0H8(39),G0H8(38),G0H8(37),G0H8(21),G0H8(20),G0H8(19)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H8(147),[G1H8(52),G1H8(1503),G1H8(1024),G1H8(1023) &
    ,G1H8(1008),G1H8(20),G1H8(367),G1H8(359),G0H8(75),G0H8(74),G0H8(73),G0H8(57),G0H8(56),G0H8(55),G0H8(12),G0H8(11),G0H8(10)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H8(916),[G1H8(796),G1H8(606),G1H8(655),G1H8(625),G1H8(620) &
    ,G1H8(427),G0H8(72),G0H8(71),G0H8(70),G0H8(54),G0H8(53),G0H8(52),G0H8(36),G0H8(35),G0H8(34)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H8(100),[G1H8(66),G1H8(1440),G1H8(334),G1H8(643) &
    ,G1H8(437)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H8(831),[G1H8(928),G1H8(408),G1H8(802),G1H8(500) &
    ,G1H8(446)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H8(868),[G1H8(94),G1H8(533),G1H8(959),G1H8(944),G1H8(943) &
    ,G1H8(457),G0H8(90),G0H8(89),G0H8(88),G0H8(45),G0H8(44),G0H8(43),G0H8(27),G0H8(26),G0H8(25)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H8(16),[G1H8(56),G1H8(1392),G1H8(747),G1H8(835),G1H8(468)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H8(622),[G1H8(522),G1H8(481)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H8(118),[G1H8(105),G1H8(1471),G1H8(513),G1H8(554) &
    ,G1H8(545)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H8(171),[G1H8(58),G1H8(1520),G1H8(1103),G1H8(1088) &
    ,G1H8(1087),G1H8(565),G0H8(81),G0H8(80),G0H8(79),G0H8(63),G0H8(62),G0H8(61),G0H8(18),G0H8(17),G0H8(16)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H8(63),[G1H8(923),G1H8(576)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H8(712),[G1H8(619),G1H8(608)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H8(795),[G1H8(74),G1H8(1536),G1H8(117),G1H8(869) &
    ,G1H8(630)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H8(189),[G1H8(932),G1H8(653)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H8(172),[G1H8(846),G1H8(662)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H8(169),[G1H8(878),G1H8(673)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H8(9),[G1H8(805),G1H8(684)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H8(124),[G1H8(856),G1H8(1423),G1H8(21),G1H8(761) &
    ,G1H8(707)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H8(34),[G1H8(770),G1H8(727)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H8(141),[G1H8(889),G1H8(781)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H8(165),[G1H8(913),G1H8(792)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H8(69),[G1H8(900),G1H8(815)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H8(82),[G1H8(859),G1H8(824)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H8(460),[G1H8(875),G1H8(1247),G1H8(407)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H8(604),[G1H8(14),G1H8(1296),G1H8(461),G0H8(6),G0H8(5) &
    ,G0H8(4)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H8(151),[G1H8(36),G1H8(1328),G1H8(515)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H8(838),[G1H8(55),G1H8(1391),G1H8(569),G0H8(9),G0H8(8) &
    ,G0H8(7)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H8(92),[G1H8(660),G1H8(1136),G1H8(623)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H8(406),[G1H8(804),G1H8(1215),G1H8(677),G0H8(3),G0H8(2) &
    ,G0H8(1)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H8(442),[G1H8(857),G1H8(1231),G1H8(35)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H8(39),[G1H8(31),G1H8(1312),G1H8(43)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H8(102),[G1H8(713),G1H8(1152),G1H8(53)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H16(187),[G1H16(155),G0H16(56),G0H16(57),G0H16(97)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H16(188),[G1H16(165),G0H16(104),G0H16(105),G0H16(55)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H16(189),[G1H16(177),G0H16(92),G0H16(93),G0H16(103)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H16(191),[G1H16(185),G0H16(95),G0H16(96),G0H16(91)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H16(193),[G1H16(192),G0H16(2),G0H16(3),G0H16(94)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H16(196),[G1H16(208),G0H16(5),G0H16(6),G0H16(1)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H16(156),[G1H16(216)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H16(158),[G1H16(222)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H16(159),[G1H16(240)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H16(179),[G1H16(248)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H16(180),[G1H16(253)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H16(181),[G1H16(259)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H16(245),[G1H16(31),G0H16(61),G0H16(79),G0H16(82)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H16(246),[G1H16(271),G0H16(99),G0H16(63),G0H16(81)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H16(249),[G1H16(280),G0H16(98),G0H16(62),G0H16(80)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H16(250),[G1H16(289),G0H16(43),G0H16(73),G0H16(76)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H16(27),[G1H16(300),G0H16(84),G0H16(45),G0H16(75)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H16(28),[G1H16(309),G0H16(83),G0H16(44),G0H16(74)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H16(213),[G1H16(319)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H16(214),[G1H16(69)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H16(217),[G1H16(7)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H16(228),[G1H16(235)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H16(25),[G1H16(82)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H16(239),[G1H16(104)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H8(104),[G1H8(84),G1H8(714),G1H8(659),G1H8(1167),G1H8(1135) &
    ,G1H8(549)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H8(116),[G1H8(96),G1H8(749),G1H8(678),G1H8(1183),G1H8(1151) &
    ,G1H8(621)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H8(114),[G1H8(732),G1H8(1168),G1H8(736)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H8(203),[G1H8(768),G1H8(1184),G1H8(801)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H8(205),[G1H8(786),G1H8(1199),G1H8(909)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H8(424),[G1H8(803),G1H8(1200),G1H8(5)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H16(125),[G1H16(73),G1H16(53)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H16(79),[G1H16(67)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H16(173),[G1H16(91),G1H16(81)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H16(113),[G1H16(96)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H16(152),[G1H16(112)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H16(184),[G1H16(127)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H16(190),[G1H16(141)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H16(215),[G1H16(162)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H16(241),[G1H16(171),G0H16(32),G0H16(33),G0H16(28)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H8(459),[G1H8(405),G1H8(911),G1H8(840),G1H8(1248),G1H8(1216) &
    ,G1H8(193)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H8(532),[G1H8(478),G1H8(929),G1H8(858),G1H8(1264),G1H8(1232) &
    ,G1H8(249)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H8(496),[G1H8(912),G1H8(1263),G1H8(131)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H8(550),[G1H8(930),G1H8(1279),G1H8(179)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H8(568),[G1H8(12),G1H8(1280),G1H8(321)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H8(586),[G1H8(13),G1H8(1295),G1H8(345)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H16(306),[G1H16(42),G1H16(19)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H16(277),[G1H16(21)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H16(286),[G1H16(87),G1H16(224)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H16(65),[G1H16(26)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H16(322),[G1H16(327)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H16(292),[G1H16(333)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H16(135),[G1H16(339)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H16(130),[G1H16(345)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H16(138),[G1H16(351),G0H16(23),G0H16(24),G0H16(19)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H8(766),[G1H8(640),G1H8(37),G1H8(26),G1H8(1343),G1H8(1311) &
    ,G1H8(525)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H8(784),[G1H8(155),G1H8(44),G1H8(32),G1H8(1359),G1H8(1327) &
    ,G1H8(555)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H8(730),[G1H8(42),G1H8(1344),G1H8(579)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H8(820),[G1H8(47),G1H8(1360),G1H8(609)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H8(75),[G1H8(48),G1H8(1375),G1H8(645)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H8(163),[G1H8(54),G1H8(1376),G1H8(681)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H16(4),[G1H16(266),G1H16(411)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H16(272),[G1H16(417)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H16(71),[G1H16(101),G1H16(423)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H16(80),[G1H16(429)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H16(2),[G1H16(435)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H16(103),[G1H16(441)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H16(102),[G1H16(447)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H16(74),[G1H16(453)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H16(137),[G1H16(459),G0H16(17),G0H16(18),G0H16(13)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H16(40),[G1H16(308),G1H16(465)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H16(310),[G1H16(471)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H16(320),[G1H16(314),G1H16(477)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H16(315),[G1H16(483)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H16(317),[G1H16(489)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H16(321),[G1H16(495)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H16(325),[G1H16(501)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H16(45),[G1H16(507)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H16(51),[G1H16(513),G0H16(29),G0H16(30),G0H16(25)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H16(299),[G1H16(290),G1H16(519)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H16(294),[G1H16(525)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H16(295),[G1H16(34),G1H16(531)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H16(287),[G1H16(537)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H16(301),[G1H16(543)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H16(36),[G1H16(549)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H16(305),[G1H16(555)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H16(304),[G1H16(561)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H16(38),[G1H16(567),G0H16(26),G0H16(27),G0H16(22)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H16(124),[G1H16(577)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H16(144),[G1H16(583),G0H16(68),G0H16(69),G0H16(64)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H16(132),[G1H16(599),G0H16(59),G0H16(60),G0H16(52)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H16(170),[G1H16(607)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H16(195),[G1H16(613),G0H16(116),G0H16(115),G0H16(114)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H16(174),[G1H16(629),G0H16(110),G0H16(109),G0H16(106)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H16(231),[G1H16(633),G0H16(177),G0H16(176),G0H16(175)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H16(207),[G1H16(639)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H16(24),[G1H16(643)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H16(234),[G1H16(649),G0H16(180),G0H16(179),G0H16(178)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H16(229),[G1H16(677),G0H16(174),G0H16(173),G0H16(172)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H16(336),[G1H16(681),G0H16(186),G0H16(185),G0H16(184)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H16(330),[G1H16(687)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H16(332),[G1H16(691)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H16(340),[G1H16(697),G0H16(189),G0H16(188),G0H16(187)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H16(335),[G1H16(725),G0H16(183),G0H16(182),G0H16(181)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H16(353),[G1H16(739)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H16(349),[G1H16(749)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H16(368),[G1H16(755),G0H16(195),G0H16(194),G0H16(193)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H16(376),[G1H16(761),G0H16(150),G0H16(149),G0H16(148)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H16(364),[G1H16(767)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H16(365),[G1H16(771)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H16(373),[G1H16(777)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H16(374),[G1H16(783),G0H16(147),G0H16(146),G0H16(145)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H16(372),[G1H16(789),G0H16(198),G0H16(197),G0H16(196)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H16(362),[G1H16(795)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H16(366),[G1H16(805)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H16(367),[G1H16(811),G0H16(192),G0H16(191),G0H16(190)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H16(386),[G1H16(821),G0H16(204),G0H16(203),G0H16(202)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H16(394),[G1H16(827),G0H16(159),G0H16(158),G0H16(157)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H16(380),[G1H16(833)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H16(383),[G1H16(837)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H16(391),[G1H16(843)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H16(392),[G1H16(849),G0H16(156),G0H16(155),G0H16(154)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H16(390),[G1H16(855),G0H16(207),G0H16(206),G0H16(205)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H16(382),[G1H16(861)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H16(384),[G1H16(871)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H16(385),[G1H16(877),G0H16(201),G0H16(200),G0H16(199)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H16(409),[G1H16(230),G0H16(168),G0H16(167),G0H16(166)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H16(407),[G1H16(890),G0H16(165),G0H16(164),G0H16(163)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H16(400),[G1H16(894)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H16(403),[G1H16(904)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H16(421),[G1H16(924),G0H16(213),G0H16(212),G0H16(211)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H16(424),[G1H16(928),G0H16(210),G0H16(209),G0H16(208)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H16(414),[G1H16(932)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H16(418),[G1H16(942)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H16(275),[G0H16(85),G0H16(40),G0H16(133)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H16(32),[G0H16(39),G0H16(87),G0H16(42)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H16(276),[G0H16(38),G0H16(86),G0H16(41)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H16(270),[G0H16(49),G0H16(88),G0H16(37)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H16(273),[G0H16(78),G0H16(51),G0H16(90)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H16(274),[G0H16(77),G0H16(50),G0H16(89)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H16(52),[G0H16(8),G0H16(9),G0H16(4)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H16(83),[G0H16(11),G0H16(12),G0H16(7)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H16(118),[G0H16(14),G0H16(15),G0H16(10)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H16(84),[G0H16(20),G0H16(21),G0H16(16)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H16(6),[G0H16(35),G0H16(36),G0H16(31)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H16(10),[G0H16(47),G0H16(48),G0H16(34)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H16(16),[G0H16(53),G0H16(54),G0H16(46)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H16(134),[G0H16(65),G0H16(66),G0H16(58)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H16(200),[G0H16(71),G0H16(72),G0H16(67)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H16(201),[G0H16(101),G0H16(102),G0H16(70)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H16(205),[G0H16(107),G0H16(108),G0H16(100)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H16(175),[G0H16(113),G0H16(112),G0H16(111)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H16(237),[G0H16(119),G0H16(118),G0H16(117)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H16(238),[G0H16(122),G0H16(121),G0H16(120)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H16(329),[G0H16(125),G0H16(124),G0H16(123)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H16(342),[G0H16(128),G0H16(127),G0H16(126)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H16(343),[G0H16(131),G0H16(130),G0H16(129)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H16(347),[G0H16(135),G0H16(134),G0H16(132)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H16(356),[G0H16(138),G0H16(137),G0H16(136)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H16(359),[G0H16(141),G0H16(140),G0H16(139)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H16(360),[G0H16(144),G0H16(143),G0H16(142)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H16(379),[G0H16(153),G0H16(152),G0H16(151)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H16(397),[G0H16(162),G0H16(161),G0H16(160)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H16(410),[G0H16(171),G0H16(170),G0H16(169)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H8(886),[G1H8(178),G1H8(551),G1H8(669),G1H8(574) &
    ,G1H8(573)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H8(898),[G1H8(195),G1H8(588),G1H8(553),G1H8(518) &
    ,G1H8(523)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H8(921),[G1H8(789),G1H8(642),G1H8(703),G1H8(692) &
    ,G1H8(656)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H16(426),[G0H16(216),G0H16(215),G0H16(214)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H8(844),[G1H8(76),G1H8(462),G1H8(763),G1H8(733),G1H8(728)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H8(862),[G1H8(160),G1H8(480),G1H8(866),G1H8(834) &
    ,G1H8(833)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H8(885),[G1H8(99),G1H8(534),G1H8(976),G1H8(975),G1H8(960)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H8(142),[G1H8(136),G1H8(1488),G1H8(1007),G1H8(992) &
    ,G1H8(991)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H8(153),[G1H8(57),G1H8(1504),G1H8(1055),G1H8(1040) &
    ,G1H8(1039)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H8(177),[G1H8(70),G1H8(1535),G1H8(1120),G1H8(1119) &
    ,G1H8(1104)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H32(140),[G1H32(134)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H32(146),[G1H32(138)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H32(157),[G1H32(149)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H32(159),[G1H32(151)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H32(170),[G1H32(162)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H32(169),[G1H32(168)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H32(180),[G1H32(179)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H32(183),[G1H32(181)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H32(194),[G1H32(192)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H32(196),[G1H32(191)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H32(207),[G1H32(202)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H32(209),[G1H32(205)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H32(220),[G1H32(216)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H32(222),[G1H32(218)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H32(233),[G1H32(229)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H32(237),[G1H32(231)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H32(246),[G1H32(242)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H32(248),[G1H32(244)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H16(111),[G1H16(143)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H16(194),[G1H16(58)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H16(117),[G1H16(142)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H16(148),[G1H16(106)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H16(66),[G1H16(54)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H16(70),[G1H16(61)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H16(100),[G1H16(86)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H16(3),[G1H16(92)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H32(257),[G1H32(253)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H32(259),[G1H32(255)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H32(268),[G1H32(264)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H32(270),[G1H32(266)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H32(279),[G1H32(275)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H32(281),[G1H32(277)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H32(290),[G1H32(286)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H32(292),[G1H32(288)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H32(301),[G1H32(297)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H32(303),[G1H32(299)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H32(312),[G1H32(308)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H32(314),[G1H32(310)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H32(323),[G1H32(319)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H32(325),[G1H32(321)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H32(334),[G1H32(330)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H32(336),[G1H32(332)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H32(345),[G1H32(341)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H32(347),[G1H32(343)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H32(374),[G1H32(370)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H32(376),[G1H32(372)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H32(385),[G1H32(381)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H32(387),[G1H32(383)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H32(396),[G1H32(392)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H32(398),[G1H32(394)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G0H8(127),[G0H8(109),G0H8(91)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G0H8(128),[G0H8(110),G0H8(92)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H8(268),[G1H8(59),G1H8(1407)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G0H8(129),[G0H8(111),G0H8(93)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H8(22),[G1H8(65),G1H8(1408)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H32(437),[G1H32(433)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H32(439),[G1H32(435)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H32(448),[G1H32(444)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H32(450),[G1H32(446)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H32(459),[G1H32(455)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H32(461),[G1H32(457)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G0H8(130),[G0H8(118),G0H8(94)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G0H8(131),[G0H8(119),G0H8(95)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H8(40),[G1H8(874),G1H8(1424)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G0H8(132),[G0H8(120),G0H8(96)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H8(45),[G1H8(892),G1H8(1439)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H32(494),[G1H32(490)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H32(496),[G1H32(492)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H32(505),[G1H32(501)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H32(507),[G1H32(503)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H32(516),[G1H32(512)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H32(518),[G1H32(514)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G0H8(133),[G0H8(112),G0H8(97)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G0H8(134),[G0H8(113),G0H8(98)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H8(184),[G1H8(67),G1H8(1455)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G0H8(135),[G0H8(114),G0H8(99)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H8(112),[G1H8(68),G1H8(1456)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H32(551),[G1H32(547)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H32(553),[G1H32(549)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H32(562),[G1H32(558)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H32(564),[G1H32(560)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H32(573),[G1H32(569)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H32(575),[G1H32(571)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G0H8(136),[G0H8(121),G0H8(100)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G0H8(137),[G0H8(122),G0H8(101)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H8(123),[G1H8(93),G1H8(1472)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G0H8(138),[G0H8(123),G0H8(102)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H8(135),[G1H8(167),G1H8(1487)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H32(626),[G1H32(622)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H32(628),[G1H32(624)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H32(637),[G1H32(633)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H32(639),[G1H32(635)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H32(648),[G1H32(644)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H32(650),[G1H32(646)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G0H8(139),[G0H8(115),G0H8(103)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G0H8(140),[G0H8(116),G0H8(104)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H8(807),[G1H8(77),G1H8(1551)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G0H8(141),[G0H8(117),G0H8(105)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H8(813),[G1H8(78),G1H8(1552)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H32(671),[G1H32(667)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H32(673),[G1H32(669)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H32(682),[G1H32(678)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H32(684),[G1H32(680)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H32(693),[G1H32(689)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H32(695),[G1H32(691)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G0H8(142),[G0H8(124),G0H8(106)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G0H8(143),[G0H8(125),G0H8(107)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H8(832),[G1H8(208),G1H8(425)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G0H8(144),[G0H8(126),G0H8(108)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H8(843),[G1H8(262),G1H8(444)])
  call Hloop_VA_Q(ntryL,G1H8(897),ex2(:),G1H4(1041),m3h2x4(:,2188),heltab2x8(:,:,2657))
  call Hloop_A_Q(ntryL,G1H4(1041),58,nMT,G2H4(716),n2h4(2026))
  call Hloop_VQ_A(ntryL,G1H8(867),ex1(:),G1H4(1066),m3h2x4(:,2189),heltab2x8(:,:,2658))
  call Hloop_Q_A(ntryL,G1H4(1066),53,nMT,G2H4(719),n2h4(2027))
  call Hloop_AV_Q(ntryL,G1H8(241),ex3(:),G1H4(1101),m3h2x4(:,2190),heltab2x8(:,:,2659))
  call Hloop_A_Q(ntryL,G1H4(1101),60,nMT,G2H4(720),n2h4(2028))
  call Hloop_UV_W(ntryL,G1H8(251),56,ex3(:),4,G2H4(725),m3h2x4(:,2191),heltab2x8(:,:,2660))
  call Hloop_VQ_A(ntryL,G1H8(166),ex1(:),G1H4(1077),m3h2x4(:,2192),heltab2x8(:,:,2661))
  call Hloop_Q_A(ntryL,G1H4(1077),45,nMT,G2H4(729),n2h4(2029))
  call Hloop_VQ_A(ntryL,G1H8(915),ex1(:),G1H4(1090),m3h2x4(:,2193),heltab2x8(:,:,2662))
  call Hloop_Q_A(ntryL,G1H4(1090),57,nMT,G2H4(730),n2h4(2030))
  call Hloop_VA_Q(ntryL,G1H8(861),ex2(:),G1H4(1102),m3h2x4(:,2194),heltab2x8(:,:,2663))
  call Hloop_A_Q(ntryL,G1H4(1102),54,nMT,G2H4(734),n2h4(2031))
  call Hloop_AV_Q(ntryL,G1H8(295),ex4(:),G1H4(1115),m3h2x4(:,2195),heltab2x8(:,:,2664))
  call Hloop_A_Q(ntryL,G1H4(1115),60,nMT,G2H4(735),n2h4(2032))
  call Hloop_UV_W(ntryL,G1H8(305),52,ex4(:),8,G2H4(738),m3h2x4(:,2196),heltab2x8(:,:,2665))
  call Hloop_QV_A(ntryL,G1H8(313),ex5(:),G1H4(1118),m3h2x4(:,2197),heltab2x8(:,:,2666))
  call Hloop_Q_A(ntryL,G1H4(1118),60,nMT,G2H4(739),n2h4(2033))
  call Hloop_UV_W(ntryL,G1H8(323),44,ex5(:),16,G2H4(744),m3h2x4(:,2198),heltab2x8(:,:,2667))
  call Hloop_QV_A(ntryL,G1H8(341),ex3(:),G1H4(1119),m3h2x4(:,2199),heltab2x8(:,:,2668))
  call Hloop_Q_A(ntryL,G1H4(1119),60,nMT,G2H4(747),n2h4(2034))
  call Hloop_UV_W(ntryL,G1H8(349),56,ex3(:),4,G2H4(748),m3h2x4(:,2200),heltab2x8(:,:,2669))
  call Hloop_VA_Q(ntryL,G1H8(147),ex2(:),G1H4(1136),m3h2x4(:,2201),heltab2x8(:,:,2670))
  call Hloop_A_Q(ntryL,G1H4(1136),46,nMT,G2H4(753),n2h4(2035))
  call Hloop_QV_A(ntryL,G1H8(377),ex4(:),G1H4(1153),m3h2x4(:,2202),heltab2x8(:,:,2671))
  call Hloop_Q_A(ntryL,G1H4(1153),60,nMT,G2H4(757),n2h4(2036))
  call Hloop_UV_W(ntryL,G1H8(385),52,ex4(:),8,G2H4(762),m3h2x4(:,2203),heltab2x8(:,:,2672))
  call Hloop_AV_Q(ntryL,G1H8(395),ex5(:),G1H4(1141),m3h2x4(:,2204),heltab2x8(:,:,2673))
  call Hloop_A_Q(ntryL,G1H4(1141),60,nMT,G2H4(766),n2h4(2037))
  call Hloop_UV_W(ntryL,G1H8(403),44,ex5(:),16,G2H4(767),m3h2x4(:,2205),heltab2x8(:,:,2674))
  call Hloop_VQ_A(ntryL,G1H8(916),ex1(:),G1H4(1152),m3h2x4(:,2206),heltab2x8(:,:,2675))
  call Hloop_Q_A(ntryL,G1H4(1152),57,nMT,G2H4(770),n2h4(2038))
  call Hloop_QV_A(ntryL,G1H8(100),ex3(:),G1H4(1158),m3h2x4(:,2207),heltab2x8(:,:,2676))
  call Hloop_Q_A(ntryL,G1H4(1158),45,nMT,G2H4(771),n2h4(2039))
  call Hloop_AV_Q(ntryL,G1H8(831),ex3(:),G1H4(1170),m3h2x4(:,2208),heltab2x8(:,:,2677))
  call Hloop_A_Q(ntryL,G1H4(1170),54,nMT,G2H4(776),n2h4(2040))
  call Hloop_VQ_A(ntryL,G1H8(868),ex1(:),G1H4(1175),m3h2x4(:,2209),heltab2x8(:,:,2678))
  call Hloop_Q_A(ntryL,G1H4(1175),53,nMT,G2H4(780),n2h4(2041))
  call Hloop_QV_A(ntryL,G1H8(16),ex4(:),G1H4(1176),m3h2x4(:,2210),heltab2x8(:,:,2679))
  call Hloop_Q_A(ntryL,G1H4(1176),45,nMT,G2H4(781),n2h4(2042))
  call Hloop_AV_Q(ntryL,G1H8(622),ex4(:),G1H4(1201),m3h2x4(:,2211),heltab2x8(:,:,2680))
  call Hloop_A_Q(ntryL,G1H4(1201),58,nMT,G2H4(784),n2h4(2043))
  call Hloop_AV_Q(ntryL,G1H8(491),ex5(:),G1H4(1206),m3h2x4(:,2212),heltab2x8(:,:,2681))
  call Hloop_A_Q(ntryL,G1H4(1206),58,nMT,G2H4(785),n2h4(2044))
  call Hloop_AV_Q(ntryL,G1H8(511),ex5(:),G1H4(1202),m3h2x4(:,2213),heltab2x8(:,:,2682))
  call Hloop_A_Q(ntryL,G1H4(1202),54,nMT,G2H4(790),n2h4(2045))
  call Hloop_VA_Q(ntryL,G1H8(535),ex2(:),G1H4(1205),m3h2x4(:,2214),heltab2x8(:,:,2683))
  call Hloop_A_Q(ntryL,G1H4(1205),58,nMT,G2H4(794),n2h4(2046))
  call Hloop_AV_Q(ntryL,G1H8(118),ex3(:),G1H4(1207),m3h2x4(:,2215),heltab2x8(:,:,2684))
  call Hloop_A_Q(ntryL,G1H4(1207),46,nMT,G2H4(799),n2h4(2047))
  call Hloop_VQ_A(ntryL,G1H8(171),ex1(:),G1H4(1210),m3h2x4(:,2216),heltab2x8(:,:,2685))
  call Hloop_Q_A(ntryL,G1H4(1210),45,nMT,G2H4(803),n2h4(2048))
  call Hloop_QV_A(ntryL,G1H8(63),ex5(:),G1H4(1211),m3h2x4(:,2217),heltab2x8(:,:,2686))
  call Hloop_Q_A(ntryL,G1H4(1211),53,nMT,G2H4(808),n2h4(2049))
  call Hloop_AV_Q(ntryL,G1H8(589),ex4(:),G1H4(1212),m3h2x4(:,2218),heltab2x8(:,:,2687))
  call Hloop_A_Q(ntryL,G1H4(1212),58,nMT,G2H4(812),n2h4(2050))
  call Hloop_AV_Q(ntryL,G1H8(599),ex4(:),G1H4(1217),m3h2x4(:,2219),heltab2x8(:,:,2688))
  call Hloop_A_Q(ntryL,G1H4(1217),46,nMT,G2H4(813),n2h4(2051))
  call Hloop_AV_Q(ntryL,G1H8(712),ex5(:),G1H4(1222),m3h2x4(:,2220),heltab2x8(:,:,2689))
  call Hloop_A_Q(ntryL,G1H4(1222),58,nMT,G2H4(817),n2h4(2052))
  call Hloop_QV_A(ntryL,G1H8(795),ex3(:),G1H4(1218),m3h2x4(:,2221),heltab2x8(:,:,2690))
  call Hloop_Q_A(ntryL,G1H4(1218),53,nMT,G2H4(822),n2h4(2053))
  call Hloop_QV_A(ntryL,G1H8(189),ex3(:),G1H4(1221),m3h2x4(:,2222),heltab2x8(:,:,2691))
  call Hloop_Q_A(ntryL,G1H4(1221),53,nMT,G2H4(826),n2h4(2054))
  call Hloop_QV_A(ntryL,G1H8(172),ex3(:),G1H4(1223),m3h2x4(:,2223),heltab2x8(:,:,2692))
  call Hloop_Q_A(ntryL,G1H4(1223),45,nMT,G2H4(835),n2h4(2055))
  call Hloop_QV_A(ntryL,G1H8(169),ex5(:),G1H4(1226),m3h2x4(:,2224),heltab2x8(:,:,2693))
  call Hloop_Q_A(ntryL,G1H4(1226),53,nMT,G2H4(839),n2h4(2056))
  call Hloop_QV_A(ntryL,G1H8(9),ex4(:),G1H4(1227),m3h2x4(:,2225),heltab2x8(:,:,2694))
  call Hloop_Q_A(ntryL,G1H4(1227),45,nMT,G2H4(840),n2h4(2057))
  call Hloop_VA_Q(ntryL,G1H8(697),ex2(:),G1H4(1228),m3h2x4(:,2226),heltab2x8(:,:,2695))
  call Hloop_A_Q(ntryL,G1H4(1228),54,nMT,G2H4(843),n2h4(2058))
  call Hloop_AV_Q(ntryL,G1H8(124),ex4(:),G1H4(1231),m3h2x4(:,2227),heltab2x8(:,:,2696))
  call Hloop_A_Q(ntryL,G1H4(1231),46,nMT,G2H4(844),n2h4(2059))
  call Hloop_VA_Q(ntryL,G1H8(716),ex2(:),G1H4(1232),m3h2x4(:,2228),heltab2x8(:,:,2697))
  call Hloop_A_Q(ntryL,G1H4(1232),46,nMT,G2H4(845),n2h4(2060))
  call Hloop_AV_Q(ntryL,G1H8(34),ex5(:),G1H4(1233),m3h2x4(:,2229),heltab2x8(:,:,2698))
  call Hloop_A_Q(ntryL,G1H4(1233),54,nMT,G2H4(848),n2h4(2061))
  call Hloop_AV_Q(ntryL,G1H8(738),ex3(:),G1H4(1234),m3h2x4(:,2230),heltab2x8(:,:,2699))
  call Hloop_A_Q(ntryL,G1H4(1234),54,nMT,G2H4(849),n2h4(2062))
  call Hloop_AV_Q(ntryL,G1H8(751),ex3(:),G1H4(2),m3h2x4(:,2231),heltab2x8(:,:,2700))
  call Hloop_A_Q(ntryL,G1H4(2),46,nMT,G2H4(850),n2h4(2063))
  call Hloop_QV_A(ntryL,G1H8(141),ex4(:),G1H4(1243),m3h2x4(:,2232),heltab2x8(:,:,2701))
  call Hloop_Q_A(ntryL,G1H4(1243),57,nMT,G2H4(854),n2h4(2064))
  call Hloop_QV_A(ntryL,G1H8(165),ex4(:),G1H4(1239),m3h2x4(:,2233),heltab2x8(:,:,2702))
  call Hloop_Q_A(ntryL,G1H4(1239),57,nMT,G2H4(866),n2h4(2065))
  call Hloop_QV_A(ntryL,G1H8(69),ex5(:),G1H4(1242),m3h2x4(:,2234),heltab2x8(:,:,2703))
  call Hloop_Q_A(ntryL,G1H4(1242),57,nMT,G2H4(870),n2h4(2066))
  call Hloop_QV_A(ntryL,G1H8(82),ex5(:),G1H4(1244),m3h2x4(:,2235),heltab2x8(:,:,2704))
  call Hloop_Q_A(ntryL,G1H4(1244),57,nMT,G2H4(875),n2h4(2067))
  call Hloop_QV_A(ntryL,G1H8(460),ex3(:),G1H4(1247),m3h2x4(:,2236),heltab2x8(:,:,2705))
  call Hloop_Q_A(ntryL,G1H4(1247),39,nMT,G2H4(879),n2h4(2068))
  call Hloop_UV_W(ntryL,G1H8(604),35,ex3(:),4,G2H4(884),m3h2x4(:,2237),heltab2x8(:,:,2706))
  call Hloop_QV_A(ntryL,G1H8(151),ex3(:),G1H4(3),m3h2x4(:,2238),heltab2x8(:,:,2707))
  call Hloop_Q_A(ntryL,G1H4(3),39,nMT,G2H4(888),n2h4(2069))
  call Hloop_UV_W(ntryL,G1H8(838),35,ex3(:),4,G2H4(897),m3h2x4(:,2239),heltab2x8(:,:,2708))
  call Hloop_QV_A(ntryL,G1H8(92),ex4(:),G1H4(1248),m3h2x4(:,2240),heltab2x8(:,:,2709))
  call Hloop_Q_A(ntryL,G1H4(1248),43,nMT,G2H4(901),n2h4(2070))
  call Hloop_UV_W(ntryL,G1H8(406),35,ex4(:),8,G2H4(902),m3h2x4(:,2241),heltab2x8(:,:,2710))
  call Hloop_QV_A(ntryL,G1H8(731),ex4(:),G1H4(1251),m3h2x4(:,2242),heltab2x8(:,:,2711))
  call Hloop_Q_A(ntryL,G1H4(1251),43,nMT,G2H4(906),n2h4(2071))
  call Hloop_UV_W(ntryL,G1H8(785),35,ex4(:),8,G2H4(907),m3h2x4(:,2243),heltab2x8(:,:,2712))
  call Hloop_QV_A(ntryL,G1H8(839),ex5(:),G1H4(1252),m3h2x4(:,2244),heltab2x8(:,:,2713))
  call Hloop_Q_A(ntryL,G1H4(1252),51,nMT,G2H4(910),n2h4(2072))
  call Hloop_UV_W(ntryL,G1H8(893),35,ex5(:),16,G2H4(911),m3h2x4(:,2245),heltab2x8(:,:,2714))
  call Hloop_QV_A(ntryL,G1H8(7),ex5(:),G1H4(1253),m3h2x4(:,2246),heltab2x8(:,:,2715))
  call Hloop_Q_A(ntryL,G1H4(1253),51,nMT,G2H4(920),n2h4(2073))
  call Hloop_UV_W(ntryL,G1H8(25),35,ex5(:),16,G2H4(924),m3h2x4(:,2247),heltab2x8(:,:,2716))
  call Hloop_AV_Q(ntryL,G1H8(442),ex3(:),G1H4(1254),m3h2x4(:,2248),heltab2x8(:,:,2717))
  call Hloop_A_Q(ntryL,G1H4(1254),39,nMT,G2H4(928),n2h4(2074))
  call Hloop_AV_Q(ntryL,G1H8(39),ex3(:),G1H4(5),m3h2x4(:,2249),heltab2x8(:,:,2718))
  call Hloop_A_Q(ntryL,G1H4(5),39,nMT,G2H4(929),n2h4(2075))
  call Hloop_AV_Q(ntryL,G1H8(102),ex4(:),G1H4(1263),m3h2x4(:,2250),heltab2x8(:,:,2719))
  call Hloop_A_Q(ntryL,G1H4(1263),43,nMT,G2H4(933),n2h4(2076))
  call Hloop_AV_Q(ntryL,G1H8(61),ex4(:),G1H4(1259),m3h2x4(:,2251),heltab2x8(:,:,2720))
  call Hloop_A_Q(ntryL,G1H4(1259),43,nMT,G2H4(937),n2h4(2077))
  call Hloop_AV_Q(ntryL,G1H8(71),ex5(:),G1H4(1262),m3h2x4(:,2252),heltab2x8(:,:,2721))
  call Hloop_A_Q(ntryL,G1H4(1262),51,nMT,G2H4(942),n2h4(2078))
  call Hloop_AV_Q(ntryL,G1H8(80),ex5(:),G1H4(1264),m3h2x4(:,2253),heltab2x8(:,:,2722))
  call Hloop_A_Q(ntryL,G1H4(1264),51,nMT,G2H4(946),n2h4(2079))
  call Hloop_VQ_A(ntryL,G1H16(187),ex1(:),G1H8(922),m3h2x8(:,1159),heltab2x16(:,:,1406))
  call Hloop_Q_A(ntryL,G1H8(922),37,nMT,G2H8(234),n2h8(1494))
  call Hloop_VQ_A(ntryL,G1H16(188),ex1(:),G1H8(939),m3h2x8(:,1160),heltab2x16(:,:,1407))
  call Hloop_Q_A(ntryL,G1H8(939),37,nMT,G2H8(199),n2h8(1495))
  call Hloop_VQ_A(ntryL,G1H16(189),ex1(:),G1H8(940),m3h2x8(:,1161),heltab2x16(:,:,1408))
  call Hloop_Q_A(ntryL,G1H8(940),37,nMT,G2H8(161),n2h8(1496))
  call Hloop_VA_Q(ntryL,G1H16(191),ex2(:),G1H8(705),m3h2x8(:,1162),heltab2x16(:,:,1409))
  call Hloop_A_Q(ntryL,G1H8(705),38,nMT,G2H8(68),n2h8(1497))
  call Hloop_VA_Q(ntryL,G1H16(193),ex2(:),G1H8(706),m3h2x8(:,1163),heltab2x16(:,:,1410))
  call Hloop_A_Q(ntryL,G1H8(706),38,nMT,G2H8(73),n2h8(1498))
  call Hloop_VA_Q(ntryL,G1H16(196),ex2(:),G1H8(723),m3h2x8(:,1164),heltab2x16(:,:,1411))
  call Hloop_A_Q(ntryL,G1H8(723),38,nMT,G2H8(263),n2h8(1499))
  call Hloop_QV_A(ntryL,G1H16(156),ex3(:),G1H8(724),m3h2x8(:,1165),heltab2x16(:,:,1412))
  call Hloop_Q_A(ntryL,G1H8(724),37,nMT,G2H8(78),n2h8(1500))
  call Hloop_QV_A(ntryL,G1H16(158),ex3(:),G1H8(735),m3h2x8(:,1166),heltab2x16(:,:,1413))
  call Hloop_Q_A(ntryL,G1H8(735),37,nMT,G2H8(83),n2h8(1501))
  call Hloop_QV_A(ntryL,G1H16(159),ex3(:),G1H8(772),m3h2x8(:,1167),heltab2x16(:,:,1414))
  call Hloop_Q_A(ntryL,G1H8(772),37,nMT,G2H8(284),n2h8(1502))
  call Hloop_AV_Q(ntryL,G1H16(179),ex3(:),G1H8(753),m3h2x8(:,1168),heltab2x16(:,:,1415))
  call Hloop_A_Q(ntryL,G1H8(753),38,nMT,G2H8(88),n2h8(1503))
  call Hloop_AV_Q(ntryL,G1H16(180),ex3(:),G1H8(790),m3h2x8(:,1169),heltab2x16(:,:,1416))
  call Hloop_A_Q(ntryL,G1H8(790),38,nMT,G2H8(93),n2h8(1504))
  call Hloop_AV_Q(ntryL,G1H16(181),ex3(:),G1H8(182),m3h2x8(:,1170),heltab2x16(:,:,1417))
  call Hloop_A_Q(ntryL,G1H8(182),38,nMT,G2H8(274),n2h8(1505))
  call Hloop_VQ_A(ntryL,G1H16(245),ex1(:),G1H8(186),m3h2x8(:,1171),heltab2x16(:,:,1418))
  call Hloop_Q_A(ntryL,G1H8(186),41,nMT,G2H8(98),n2h8(1506))
  call Hloop_VQ_A(ntryL,G1H16(246),ex1(:),G1H8(194),m3h2x8(:,1172),heltab2x16(:,:,1419))
  call Hloop_Q_A(ntryL,G1H8(194),41,nMT,G2H8(103),n2h8(1507))
  call Hloop_VQ_A(ntryL,G1H16(249),ex1(:),G1H8(198),m3h2x8(:,1173),heltab2x16(:,:,1420))
  call Hloop_Q_A(ntryL,G1H8(198),41,nMT,G2H8(108),n2h8(1508))
  call Hloop_VA_Q(ntryL,G1H16(250),ex2(:),G1H8(199),m3h2x8(:,1174),heltab2x16(:,:,1421))
  call Hloop_A_Q(ntryL,G1H8(199),42,nMT,G2H8(113),n2h8(1509))
  call Hloop_VA_Q(ntryL,G1H16(27),ex2(:),G1H8(200),m3h2x8(:,1175),heltab2x16(:,:,1422))
  call Hloop_A_Q(ntryL,G1H8(200),42,nMT,G2H8(118),n2h8(1510))
  call Hloop_VA_Q(ntryL,G1H16(28),ex2(:),G1H8(209),m3h2x8(:,1176),heltab2x16(:,:,1423))
  call Hloop_A_Q(ntryL,G1H8(209),42,nMT,G2H8(119),n2h8(1511))
  call Hloop_QV_A(ntryL,G1H16(213),ex4(:),G1H8(210),m3h2x8(:,1177),heltab2x16(:,:,1424))
  call Hloop_Q_A(ntryL,G1H8(210),41,nMT,G2H8(123),n2h8(1512))
  call Hloop_QV_A(ntryL,G1H16(214),ex4(:),G1H8(211),m3h2x8(:,1178),heltab2x16(:,:,1425))
  call Hloop_Q_A(ntryL,G1H8(211),41,nMT,G2H8(128),n2h8(1513))
  call Hloop_QV_A(ntryL,G1H16(217),ex4(:),G1H8(212),m3h2x8(:,1179),heltab2x16(:,:,1426))
  call Hloop_Q_A(ntryL,G1H8(212),41,nMT,G2H8(280),n2h8(1514))
  call Hloop_AV_Q(ntryL,G1H16(228),ex4(:),G1H8(217),m3h2x8(:,1180),heltab2x16(:,:,1427))
  call Hloop_A_Q(ntryL,G1H8(217),42,nMT,G2H8(133),n2h8(1515))
  call Hloop_AV_Q(ntryL,G1H16(25),ex4(:),G1H8(218),m3h2x8(:,1181),heltab2x16(:,:,1428))
  call Hloop_A_Q(ntryL,G1H8(218),42,nMT,G2H8(138),n2h8(1516))
  call Hloop_AV_Q(ntryL,G1H16(239),ex4(:),G1H8(221),m3h2x8(:,1182),heltab2x16(:,:,1429))
  call Hloop_A_Q(ntryL,G1H8(221),42,nMT,G2H8(143),n2h8(1517))
  call Hloop_QV_A(ntryL,G1H16(163),ex5(:),G1H8(222),m3h2x8(:,1183),heltab2x16(:,:,1430))
  call Hloop_Q_A(ntryL,G1H8(222),49,nMT,G2H8(148),n2h8(1518))
  call Hloop_QV_A(ntryL,G1H16(43),ex5(:),G1H8(228),m3h2x8(:,1184),heltab2x16(:,:,1431))
  call Hloop_Q_A(ntryL,G1H8(228),49,nMT,G2H8(153),n2h8(1519))
  call Hloop_QV_A(ntryL,G1H16(261),ex5(:),G1H8(229),m3h2x8(:,1185),heltab2x16(:,:,1432))
  call Hloop_Q_A(ntryL,G1H8(229),49,nMT,G2H8(154),n2h8(1520))
  call Hloop_AV_Q(ntryL,G1H16(316),ex5(:),G1H8(230),m3h2x8(:,1186),heltab2x16(:,:,1433))
  call Hloop_A_Q(ntryL,G1H8(230),50,nMT,G2H8(158),n2h8(1521))
  call Hloop_AV_Q(ntryL,G1H16(146),ex5(:),G1H8(234),m3h2x8(:,1187),heltab2x16(:,:,1434))
  call Hloop_A_Q(ntryL,G1H8(234),50,nMT,G2H8(163),n2h8(1522))
  call Hloop_AV_Q(ntryL,G1H16(147),ex5(:),G1H8(239),m3h2x8(:,1188),heltab2x16(:,:,1435))
  call Hloop_A_Q(ntryL,G1H8(239),50,nMT,G2H8(168),n2h8(1523))
  call Hloop_AV_Q(ntryL,G1H8(202),ex5(:),G1H4(1267),m3h2x4(:,2254),heltab2x8(:,:,2723))
  call Hloop_A_Q(ntryL,G1H4(1267),51,0,G2H4(951),n2h4(2080))
  call Hloop_QV_A(ntryL,G1H8(237),ex5(:),G1H4(6),m3h2x4(:,2255),heltab2x8(:,:,2724))
  call Hloop_Q_A(ntryL,G1H4(6),51,0,G2H4(955),n2h4(2081))
  call Hloop_AV_Q(ntryL,G1H8(273),ex5(:),G1H4(1268),m3h2x4(:,2256),heltab2x8(:,:,2725))
  call Hloop_A_Q(ntryL,G1H4(1268),51,nMB,G2H4(956),n2h4(2082))
  call Hloop_QV_A(ntryL,G1H8(316),ex5(:),G1H4(1273),m3h2x4(:,2257),heltab2x8(:,:,2726))
  call Hloop_Q_A(ntryL,G1H4(1273),51,nMB,G2H4(959),n2h4(2083))
  call Hloop_DV_C(ntryL,G1H8(412),35,ex5(:),G2H4(960),m3h2x4(:,2258),heltab2x8(:,:,2727))
  call Hloop_CV_D(ntryL,G1H8(477),35,ex5(:),16,G2H4(964),m3h2x4(:,2259),heltab2x8(:,:,2728))
  call Hloop_QV_A(ntryL,G1H8(104),ex4(:),G1H4(1278),m3h2x4(:,2260),heltab2x8(:,:,2729))
  call Hloop_Q_A(ntryL,G1H4(1278),43,0,G2H4(965),n2h4(2084))
  call Hloop_AV_Q(ntryL,G1H8(116),ex4(:),G1H4(1274),m3h2x4(:,2261),heltab2x8(:,:,2730))
  call Hloop_A_Q(ntryL,G1H4(1274),43,0,G2H4(969),n2h4(2085))
  call Hloop_QV_A(ntryL,G1H8(114),ex4(:),G1H4(1277),m3h2x4(:,2262),heltab2x8(:,:,2731))
  call Hloop_Q_A(ntryL,G1H4(1277),43,nMB,G2H4(973),n2h4(2086))
  call Hloop_AV_Q(ntryL,G1H8(203),ex4(:),G1H4(1279),m3h2x4(:,2263),heltab2x8(:,:,2732))
  call Hloop_A_Q(ntryL,G1H4(1279),43,nMB,G2H4(978),n2h4(2087))
  call Hloop_CV_D(ntryL,G1H8(205),35,ex4(:),8,G2H4(983),m3h2x4(:,2264),heltab2x8(:,:,2733))
  call Hloop_DV_C(ntryL,G1H8(424),35,ex4(:),G2H4(988),m3h2x4(:,2265),heltab2x8(:,:,2734))
  call Hloop_QV_A(ntryL,G1H8(176),ex5(:),G1H4(1282),m3h2x4(:,2266),heltab2x8(:,:,2735))
  call Hloop_Q_A(ntryL,G1H4(1282),51,0,G2H4(993),n2h4(2088))
  call Hloop_AV_Q(ntryL,G1H8(173),ex5(:),G1H4(1283),m3h2x4(:,2267),heltab2x8(:,:,2736))
  call Hloop_A_Q(ntryL,G1H4(1283),51,0,G2H4(998),n2h4(2089))
  call Hloop_QV_A(ntryL,G1H8(168),ex5(:),G1H4(1284),m3h2x4(:,2268),heltab2x8(:,:,2737))
  call Hloop_Q_A(ntryL,G1H4(1284),51,nMB,G2H4(1003),n2h4(2090))
  call Hloop_AV_Q(ntryL,G1H8(133),ex5(:),G1H4(1289),m3h2x4(:,2269),heltab2x8(:,:,2738))
  call Hloop_A_Q(ntryL,G1H4(1289),51,nMB,G2H4(1008),n2h4(2091))
  call Hloop_CV_D(ntryL,G1H8(143),35,ex5(:),16,G2H4(1013),m3h2x4(:,2270),heltab2x8(:,:,2739))
  call Hloop_DV_C(ntryL,G1H8(83),35,ex5(:),G2H4(1018),m3h2x4(:,2271),heltab2x8(:,:,2740))
  call Hloop_AV_Q(ntryL,G1H16(125),ex4(:),G1H8(240),m3h2x8(:,1189),heltab2x16(:,:,1436))
  call Hloop_A_Q(ntryL,G1H8(240),44,0,G2H8(260),n2h8(1524))
  call Hloop_AV_Q(ntryL,G1H16(79),ex4(:),G1H8(242),m3h2x8(:,1190),heltab2x16(:,:,1437))
  call Hloop_A_Q(ntryL,G1H8(242),44,nMT,G2H8(178),n2h8(1525))
  call Hloop_QV_A(ntryL,G1H16(173),ex4(:),G1H8(245),m3h2x8(:,1191),heltab2x16(:,:,1438))
  call Hloop_Q_A(ntryL,G1H8(245),44,0,G2H8(179),n2h8(1526))
  call Hloop_QV_A(ntryL,G1H16(113),ex4(:),G1H8(248),m3h2x8(:,1192),heltab2x16(:,:,1439))
  call Hloop_Q_A(ntryL,G1H8(248),44,nMT,G2H8(183),n2h8(1527))
  call Hloop_AV_Q(ntryL,G1H16(152),ex4(:),G1H8(252),m3h2x8(:,1193),heltab2x16(:,:,1440))
  call Hloop_A_Q(ntryL,G1H8(252),44,nMB,G2H8(188),n2h8(1528))
  call Hloop_QV_A(ntryL,G1H16(184),ex4(:),G1H8(253),m3h2x8(:,1194),heltab2x16(:,:,1441))
  call Hloop_Q_A(ntryL,G1H8(253),44,nMB,G2H8(275),n2h8(1529))
  call Hloop_DV_C(ntryL,G1H16(190),36,ex4(:),G2H8(193),m3h2x8(:,1195),heltab2x16(:,:,1442))
  call Hloop_CV_D(ntryL,G1H16(215),36,ex4(:),8,G2H8(259),m3h2x8(:,1196),heltab2x16(:,:,1443))
  call Hloop_UV_W(ntryL,G1H16(241),36,ex4(:),8,G2H8(203),m3h2x8(:,1197),heltab2x16(:,:,1444))
  call Hloop_AV_Q(ntryL,G1H8(459),ex3(:),G1H4(1294),m3h2x4(:,2272),heltab2x8(:,:,2741))
  call Hloop_A_Q(ntryL,G1H4(1294),39,0,G2H4(1023),n2h4(2092))
  call Hloop_QV_A(ntryL,G1H8(532),ex3(:),G1H4(1290),m3h2x4(:,2273),heltab2x8(:,:,2742))
  call Hloop_Q_A(ntryL,G1H4(1290),39,0,G2H4(1028),n2h4(2093))
  call Hloop_AV_Q(ntryL,G1H8(496),ex3(:),G1H4(1293),m3h2x4(:,2274),heltab2x8(:,:,2743))
  call Hloop_A_Q(ntryL,G1H4(1293),39,nMB,G2H4(1033),n2h4(2094))
  call Hloop_QV_A(ntryL,G1H8(550),ex3(:),G1H4(1295),m3h2x4(:,2275),heltab2x8(:,:,2744))
  call Hloop_Q_A(ntryL,G1H4(1295),39,nMB,G2H4(1038),n2h4(2095))
  call Hloop_DV_C(ntryL,G1H8(568),35,ex3(:),G2H4(1043),m3h2x4(:,2276),heltab2x8(:,:,2745))
  call Hloop_CV_D(ntryL,G1H8(586),35,ex3(:),4,G2H4(1048),m3h2x4(:,2277),heltab2x8(:,:,2746))
  call Hloop_QV_A(ntryL,G1H16(306),ex3(:),G1H8(254),m3h2x8(:,1198),heltab2x16(:,:,1445))
  call Hloop_Q_A(ntryL,G1H8(254),44,0,G2H8(208),n2h8(1530))
  call Hloop_QV_A(ntryL,G1H16(277),ex3(:),G1H8(260),m3h2x8(:,1199),heltab2x16(:,:,1446))
  call Hloop_Q_A(ntryL,G1H8(260),44,nMT,G2H8(213),n2h8(1531))
  call Hloop_AV_Q(ntryL,G1H16(286),ex3(:),G1H8(263),m3h2x8(:,1200),heltab2x16(:,:,1447))
  call Hloop_A_Q(ntryL,G1H8(263),44,0,G2H8(214),n2h8(1532))
  call Hloop_AV_Q(ntryL,G1H16(65),ex3(:),G1H8(264),m3h2x8(:,1201),heltab2x16(:,:,1448))
  call Hloop_A_Q(ntryL,G1H8(264),44,nMT,G2H8(218),n2h8(1533))
  call Hloop_QV_A(ntryL,G1H16(322),ex3(:),G1H8(265),m3h2x8(:,1202),heltab2x16(:,:,1449))
  call Hloop_Q_A(ntryL,G1H8(265),44,nMB,G2H8(228),n2h8(1534))
  call Hloop_AV_Q(ntryL,G1H16(292),ex3(:),G1H8(271),m3h2x8(:,1203),heltab2x16(:,:,1450))
  call Hloop_A_Q(ntryL,G1H8(271),44,nMB,G2H8(233),n2h8(1535))
  call Hloop_CV_D(ntryL,G1H16(135),40,ex3(:),4,G2H8(238),m3h2x8(:,1204),heltab2x16(:,:,1451))
  call Hloop_DV_C(ntryL,G1H16(130),40,ex3(:),G2H8(246),m3h2x8(:,1205),heltab2x16(:,:,1452))
  call Hloop_UV_W(ntryL,G1H16(138),40,ex3(:),4,G2H8(268),m3h2x8(:,1206),heltab2x16(:,:,1453))
  call Hloop_QV_A(ntryL,G1H8(363),ex4(:),G1H4(1298),m3h2x4(:,2278),heltab2x8(:,:,2747))
  call Hloop_Q_A(ntryL,G1H4(1298),43,0,G2H4(1053),n2h4(2096))
  call Hloop_AV_Q(ntryL,G1H8(381),ex4(:),G1H4(1299),m3h2x4(:,2279),heltab2x8(:,:,2748))
  call Hloop_A_Q(ntryL,G1H4(1299),43,0,G2H4(1058),n2h4(2097))
  call Hloop_QV_A(ntryL,G1H8(399),ex4(:),G1H4(1300),m3h2x4(:,2280),heltab2x8(:,:,2749))
  call Hloop_Q_A(ntryL,G1H4(1300),43,nMB,G2H4(1063),n2h4(2098))
  call Hloop_AV_Q(ntryL,G1H8(429),ex4(:),G1H4(1305),m3h2x4(:,2281),heltab2x8(:,:,2750))
  call Hloop_A_Q(ntryL,G1H4(1305),43,nMB,G2H4(1064),n2h4(2099))
  call Hloop_CV_D(ntryL,G1H8(465),35,ex4(:),8,G2H4(1068),m3h2x4(:,2282),heltab2x8(:,:,2751))
  call Hloop_DV_C(ntryL,G1H8(501),35,ex4(:),G2H4(1069),m3h2x4(:,2283),heltab2x8(:,:,2752))
  call Hloop_AV_Q(ntryL,G1H16(357),ex5(:),G1H8(272),m3h2x8(:,1207),heltab2x16(:,:,1454))
  call Hloop_A_Q(ntryL,G1H8(272),52,0,G2H8(251),n2h8(1536))
  call Hloop_AV_Q(ntryL,G1H16(363),ex5(:),G1H8(275),m3h2x8(:,1208),heltab2x16(:,:,1455))
  call Hloop_A_Q(ntryL,G1H8(275),52,nMT,G2H8(256),n2h8(1537))
  call Hloop_QV_A(ntryL,G1H16(369),ex5(:),G1H8(276),m3h2x8(:,1209),heltab2x16(:,:,1456))
  call Hloop_Q_A(ntryL,G1H8(276),52,0,G2H8(261),n2h8(1538))
  call Hloop_QV_A(ntryL,G1H16(375),ex5(:),G1H8(282),m3h2x8(:,1210),heltab2x16(:,:,1457))
  call Hloop_Q_A(ntryL,G1H8(282),52,nMT,G2H8(266),n2h8(1539))
  call Hloop_AV_Q(ntryL,G1H16(381),ex5(:),G1H8(283),m3h2x8(:,1211),heltab2x16(:,:,1458))
  call Hloop_A_Q(ntryL,G1H8(283),52,nMB,G2H8(271),n2h8(1540))
  call Hloop_QV_A(ntryL,G1H16(387),ex5(:),G1H8(284),m3h2x8(:,1212),heltab2x16(:,:,1459))
  call Hloop_Q_A(ntryL,G1H8(284),52,nMB,G2H8(272),n2h8(1541))
  call Hloop_DV_C(ntryL,G1H16(393),36,ex5(:),G2H8(276),m3h2x8(:,1213),heltab2x16(:,:,1460))
  call Hloop_CV_D(ntryL,G1H16(399),36,ex5(:),16,G2H8(286),m3h2x8(:,1214),heltab2x16(:,:,1461))
  call Hloop_UV_W(ntryL,G1H16(405),36,ex5(:),16,G2H8(287),m3h2x8(:,1215),heltab2x16(:,:,1462))
  call Hloop_AV_Q(ntryL,G1H8(766),ex3(:),G1H4(1310),m3h2x4(:,2284),heltab2x8(:,:,2753))
  call Hloop_A_Q(ntryL,G1H4(1310),39,0,G2H4(1073),n2h4(2100))
  call Hloop_QV_A(ntryL,G1H8(784),ex3(:),G1H4(1306),m3h2x4(:,2285),heltab2x8(:,:,2754))
  call Hloop_Q_A(ntryL,G1H4(1306),39,0,G2H4(1074),n2h4(2101))
  call Hloop_AV_Q(ntryL,G1H8(730),ex3(:),G1H4(1309),m3h2x4(:,2286),heltab2x8(:,:,2755))
  call Hloop_A_Q(ntryL,G1H4(1309),39,nMB,G2H4(1078),n2h4(2102))
  call Hloop_QV_A(ntryL,G1H8(820),ex3(:),G1H4(1311),m3h2x4(:,2287),heltab2x8(:,:,2756))
  call Hloop_Q_A(ntryL,G1H4(1311),39,nMB,G2H4(1079),n2h4(2103))
  call Hloop_DV_C(ntryL,G1H8(75),35,ex3(:),G2H4(1083),m3h2x4(:,2288),heltab2x8(:,:,2757))
  call Hloop_CV_D(ntryL,G1H8(163),35,ex3(:),4,G2H4(1084),m3h2x4(:,2289),heltab2x8(:,:,2758))
  call Hloop_AV_Q(ntryL,G1H16(4),wf4(:,1),G1H4(1314),m3h4x4(:,248),heltab2x16(:,:,1463))
  call Hloop_A_Q(ntryL,G1H4(1314),43,0,G2H4(1088),n2h4(2104))
  call Hloop_AV_Q(ntryL,G1H16(272),wf4(:,1),G1H4(1315),m3h4x4(:,249),heltab2x16(:,:,1464))
  call Hloop_A_Q(ntryL,G1H4(1315),43,nMT,G2H4(1089),n2h4(2105))
  call Hloop_QV_A(ntryL,G1H16(71),wf4(:,1),G1H4(1316),m3h4x4(:,250),heltab2x16(:,:,1465))
  call Hloop_Q_A(ntryL,G1H4(1316),43,0,G2H4(1093),n2h4(2106))
  call Hloop_QV_A(ntryL,G1H16(80),wf4(:,1),G1H4(1321),m3h4x4(:,251),heltab2x16(:,:,1466))
  call Hloop_Q_A(ntryL,G1H4(1321),43,nMT,G2H4(1094),n2h4(2107))
  call Hloop_AV_Q(ntryL,G1H16(2),wf4(:,1),G1H4(1326),m3h4x4(:,252),heltab2x16(:,:,1467))
  call Hloop_A_Q(ntryL,G1H4(1326),43,nMB,G2H4(1098),n2h4(2108))
  call Hloop_QV_A(ntryL,G1H16(103),wf4(:,1),G1H4(1322),m3h4x4(:,253),heltab2x16(:,:,1468))
  call Hloop_Q_A(ntryL,G1H4(1322),43,nMB,G2H4(1099),n2h4(2109))
  call Hloop_DV_C(ntryL,G1H16(102),40,wf4(:,1),G2H4(1103),m3h4x4(:,254),heltab2x16(:,:,1469))
  call Hloop_CV_D(ntryL,G1H16(74),40,wf4(:,1),3,G2H4(1104),m3h4x4(:,255),heltab2x16(:,:,1470))
  call Hloop_UV_W(ntryL,G1H16(137),40,wf4(:,1),3,G2H4(1108),m3h4x4(:,256),heltab2x16(:,:,1471))
  call Hloop_QV_A(ntryL,G1H16(40),wf4(:,1),G1H4(1325),m3h4x4(:,257),heltab2x16(:,:,1472))
  call Hloop_Q_A(ntryL,G1H4(1325),39,0,G2H4(1109),n2h4(2110))
  call Hloop_QV_A(ntryL,G1H16(310),wf4(:,1),G1H4(1327),m3h4x4(:,258),heltab2x16(:,:,1473))
  call Hloop_Q_A(ntryL,G1H4(1327),39,nMT,G2H4(1113),n2h4(2111))
  call Hloop_AV_Q(ntryL,G1H16(320),wf4(:,1),G1H4(1330),m3h4x4(:,259),heltab2x16(:,:,1474))
  call Hloop_A_Q(ntryL,G1H4(1330),39,0,G2H4(1117),n2h4(2112))
  call Hloop_AV_Q(ntryL,G1H16(315),wf4(:,1),G1H4(1331),m3h4x4(:,260),heltab2x16(:,:,1475))
  call Hloop_A_Q(ntryL,G1H4(1331),39,nMT,G2H4(1121),n2h4(2113))
  call Hloop_QV_A(ntryL,G1H16(317),wf4(:,1),G1H4(1332),m3h4x4(:,261),heltab2x16(:,:,1476))
  call Hloop_Q_A(ntryL,G1H4(1332),39,nMB,G2H4(1122),n2h4(2114))
  call Hloop_AV_Q(ntryL,G1H16(321),wf4(:,1),G1H4(1337),m3h4x4(:,262),heltab2x16(:,:,1477))
  call Hloop_A_Q(ntryL,G1H4(1337),39,nMB,G2H4(1126),n2h4(2115))
  call Hloop_CV_D(ntryL,G1H16(325),36,wf4(:,1),3,G2H4(1127),m3h4x4(:,263),heltab2x16(:,:,1478))
  call Hloop_DV_C(ntryL,G1H16(45),36,wf4(:,1),G2H4(1131),m3h4x4(:,264),heltab2x16(:,:,1479))
  call Hloop_UV_W(ntryL,G1H16(51),36,wf4(:,1),3,G2H4(1132),m3h4x4(:,265),heltab2x16(:,:,1480))
  call Hloop_QV_A(ntryL,G1H16(299),wf4(:,1),G1H4(1342),m3h4x4(:,266),heltab2x16(:,:,1481))
  call Hloop_Q_A(ntryL,G1H4(1342),39,0,G2H4(1136),n2h4(2116))
  call Hloop_QV_A(ntryL,G1H16(294),wf4(:,1),G1H4(1338),m3h4x4(:,267),heltab2x16(:,:,1482))
  call Hloop_Q_A(ntryL,G1H4(1338),39,nMT,G2H4(1137),n2h4(2117))
  call Hloop_AV_Q(ntryL,G1H16(295),wf4(:,1),G1H4(1341),m3h4x4(:,268),heltab2x16(:,:,1483))
  call Hloop_A_Q(ntryL,G1H4(1341),39,0,G2H4(1141),n2h4(2118))
  call Hloop_AV_Q(ntryL,G1H16(287),wf4(:,1),G1H4(1343),m3h4x4(:,269),heltab2x16(:,:,1484))
  call Hloop_A_Q(ntryL,G1H4(1343),39,nMT,G2H4(1145),n2h4(2119))
  call Hloop_QV_A(ntryL,G1H16(301),wf4(:,1),G1H4(1346),m3h4x4(:,270),heltab2x16(:,:,1485))
  call Hloop_Q_A(ntryL,G1H4(1346),39,nMB,G2H4(1149),n2h4(2120))
  call Hloop_AV_Q(ntryL,G1H16(36),wf4(:,1),G1H4(1347),m3h4x4(:,271),heltab2x16(:,:,1486))
  call Hloop_A_Q(ntryL,G1H4(1347),39,nMB,G2H4(1150),n2h4(2121))
  call Hloop_CV_D(ntryL,G1H16(305),36,wf4(:,1),3,G2H4(1154),m3h4x4(:,272),heltab2x16(:,:,1487))
  call Hloop_DV_C(ntryL,G1H16(304),36,wf4(:,1),G2H4(1155),m3h4x4(:,273),heltab2x16(:,:,1488))
  call Hloop_UV_W(ntryL,G1H16(38),36,wf4(:,1),3,G2H4(1159),m3h4x4(:,274),heltab2x16(:,:,1489))
  call Hloop_AV_Q(ntryL,G1H16(573),ex4(:),G1H8(288),m3h2x8(:,1216),heltab2x16(:,:,1490))
  call Hloop_A_Q(ntryL,G1H8(288),42,nMT,G2H8(291),n2h8(1542))
  call Hloop_AV_Q(ntryL,G1H16(124),ex4(:),G1H8(293),m3h2x8(:,1217),heltab2x16(:,:,1491))
  call Hloop_A_Q(ntryL,G1H8(293),42,nMT,G2H8(296),n2h8(1543))
  call Hloop_VA_Q(ntryL,G1H16(144),ex2(:),G1H8(294),m3h2x8(:,1218),heltab2x16(:,:,1492))
  call Hloop_A_Q(ntryL,G1H8(294),42,nMT,G2H8(300),n2h8(1544))
  call Hloop_AV_Q(ntryL,G1H16(589),ex5(:),G1H8(296),m3h2x8(:,1219),heltab2x16(:,:,1493))
  call Hloop_A_Q(ntryL,G1H8(296),50,nMT,G2H8(304),n2h8(1545))
  call Hloop_AV_Q(ntryL,G1H16(593),ex5(:),G1H8(299),m3h2x8(:,1220),heltab2x16(:,:,1494))
  call Hloop_A_Q(ntryL,G1H8(299),50,nMT,G2H8(309),n2h8(1546))
  call Hloop_VQ_A(ntryL,G1H16(132),wf4(:,9),G1H4(1348),m3h4x4(:,275),heltab2x16(:,:,1495))
  call Hloop_Q_A(ntryL,G1H4(1348),45,nMT,G2H4(1163),n2h4(2122))
  call Hloop_QV_A(ntryL,G1H16(603),ex4(:),G1H8(302),m3h2x8(:,1221),heltab2x16(:,:,1496))
  call Hloop_Q_A(ntryL,G1H8(302),41,nMT,G2H8(310),n2h8(1547))
  call Hloop_QV_A(ntryL,G1H16(170),ex4(:),G1H8(306),m3h2x8(:,1222),heltab2x16(:,:,1497))
  call Hloop_Q_A(ntryL,G1H8(306),41,nMT,G2H8(314),n2h8(1548))
  call Hloop_VQ_A(ntryL,G1H16(195),ex1(:),G1H8(307),m3h2x8(:,1223),heltab2x16(:,:,1498))
  call Hloop_Q_A(ntryL,G1H8(307),41,nMT,G2H8(319),n2h8(1549))
  call Hloop_QV_A(ntryL,G1H16(619),ex5(:),G1H8(308),m3h2x8(:,1224),heltab2x16(:,:,1499))
  call Hloop_Q_A(ntryL,G1H8(308),49,nMT,G2H8(323),n2h8(1550))
  call Hloop_QV_A(ntryL,G1H16(623),ex5(:),G1H8(314),m3h2x8(:,1225),heltab2x16(:,:,1500))
  call Hloop_Q_A(ntryL,G1H8(314),49,nMT,G2H8(324),n2h8(1551))
  call Hloop_VA_Q(ntryL,G1H16(174),wf4(:,11),G1H4(1353),m3h4x4(:,276),heltab2x16(:,:,1501))
  call Hloop_A_Q(ntryL,G1H4(1353),46,nMT,G2H4(1167),n2h4(2123))
  call Hloop_VA_Q(ntryL,G1H16(231),ex2(:),G1H8(317),m3h2x8(:,1226),heltab2x16(:,:,1502))
  call Hloop_A_Q(ntryL,G1H8(317),38,nMT,G2H8(221),n2h8(1552))
  call Hloop_AV_Q(ntryL,G1H16(207),ex3(:),G1H8(201),m3h2x8(:,1227),heltab2x16(:,:,1503))
  call Hloop_A_Q(ntryL,G1H8(201),38,nMT,G2H8(230),n2h8(1553))
  call Hloop_AV_Q(ntryL,G1H16(24),ex3(:),G1H8(274),m3h2x8(:,1228),heltab2x16(:,:,1504))
  call Hloop_A_Q(ntryL,G1H8(274),38,nMT,G2H8(249),n2h8(1554))
  call Hloop_VA_Q(ntryL,G1H16(234),ex2(:),G1H8(244),m3h2x8(:,1229),heltab2x16(:,:,1505))
  call Hloop_A_Q(ntryL,G1H8(244),38,nMT,G2H8(187),n2h8(1555))
  call Hloop_AV_Q(ntryL,G1H16(655),ex5(:),G1H8(226),m3h2x8(:,1230),heltab2x16(:,:,1506))
  call Hloop_A_Q(ntryL,G1H8(226),50,nMT,G2H8(200),n2h8(1556))
  call Hloop_AV_Q(ntryL,G1H16(659),ex5(:),G1H8(231),m3h2x8(:,1231),heltab2x16(:,:,1507))
  call Hloop_A_Q(ntryL,G1H8(231),50,nMT,G2H8(232),n2h8(1557))
  call Hloop_QV_A(ntryL,G1H16(665),ex5(:),G1H8(280),m3h2x8(:,1232),heltab2x16(:,:,1508))
  call Hloop_Q_A(ntryL,G1H8(280),52,nMT,G2H8(176),n2h8(1558))
  call Hloop_UV_W(ntryL,G1H16(671),36,ex5(:),16,G2H8(185),m3h2x8(:,1233),heltab2x16(:,:,1509))
  call Hloop_VQ_A(ntryL,G1H16(229),wf4(:,13),G1H4(1358),m3h4x4(:,277),heltab2x16(:,:,1510))
  call Hloop_Q_A(ntryL,G1H4(1358),45,nMT,G2H4(1168),n2h4(2124))
  call Hloop_VQ_A(ntryL,G1H16(336),ex1(:),G1H8(261),m3h2x8(:,1234),heltab2x16(:,:,1511))
  call Hloop_Q_A(ntryL,G1H8(261),37,nMT,G2H8(202),n2h8(1559))
  call Hloop_QV_A(ntryL,G1H16(330),ex3(:),G1H8(267),m3h2x8(:,1235),heltab2x16(:,:,1512))
  call Hloop_Q_A(ntryL,G1H8(267),37,nMT,G2H8(217),n2h8(1560))
  call Hloop_QV_A(ntryL,G1H16(332),ex3(:),G1H8(279),m3h2x8(:,1236),heltab2x16(:,:,1513))
  call Hloop_Q_A(ntryL,G1H8(279),37,nMT,G2H8(245),n2h8(1561))
  call Hloop_VQ_A(ntryL,G1H16(340),ex1(:),G1H8(297),m3h2x8(:,1237),heltab2x16(:,:,1514))
  call Hloop_Q_A(ntryL,G1H8(297),37,nMT,G2H8(191),n2h8(1562))
  call Hloop_QV_A(ntryL,G1H16(703),ex5(:),G1H8(303),m3h2x8(:,1238),heltab2x16(:,:,1515))
  call Hloop_Q_A(ntryL,G1H8(303),49,nMT,G2H8(172),n2h8(1563))
  call Hloop_QV_A(ntryL,G1H16(707),ex5(:),G1H8(304),m3h2x8(:,1239),heltab2x16(:,:,1516))
  call Hloop_Q_A(ntryL,G1H8(304),49,nMT,G2H8(206),n2h8(1564))
  call Hloop_AV_Q(ntryL,G1H16(713),ex5(:),G1H8(309),m3h2x8(:,1240),heltab2x16(:,:,1517))
  call Hloop_A_Q(ntryL,G1H8(309),52,nMT,G2H8(63),n2h8(1565))
  call Hloop_UV_W(ntryL,G1H16(719),36,ex5(:),16,G2H8(72),m3h2x8(:,1241),heltab2x16(:,:,1518))
  call Hloop_VA_Q(ntryL,G1H16(335),wf4(:,15),G1H4(1354),m3h4x4(:,278),heltab2x16(:,:,1519))
  call Hloop_A_Q(ntryL,G1H4(1354),46,nMT,G2H4(1171),n2h4(2125))
  call Hloop_QV_A(ntryL,G1H16(119),ex5(:),G1H8(315),m3h2x8(:,1242),heltab2x16(:,:,1520))
  call Hloop_Q_A(ntryL,G1H8(315),49,nMT,G2H8(76),n2h8(1566))
  call Hloop_QV_A(ntryL,G1H16(730),ex5(:),G1H8(418),m3h2x8(:,1243),heltab2x16(:,:,1521))
  call Hloop_Q_A(ntryL,G1H8(418),49,nMT,G2H8(85),n2h8(1567))
  call Hloop_AV_Q(ntryL,G1H16(734),ex5(:),G1H8(423),m3h2x8(:,1244),heltab2x16(:,:,1522))
  call Hloop_A_Q(ntryL,G1H8(423),50,nMT,G2H8(92),n2h8(1568))
  call Hloop_AV_Q(ntryL,G1H16(353),wf4(:,2),G1H4(1357),m3h4x4(:,279),heltab2x16(:,:,1523))
  call Hloop_A_Q(ntryL,G1H4(1357),46,nMT,G2H4(1172),n2h4(2126))
  call Hloop_QV_A(ntryL,G1H16(745),wf4(:,2),G1H4(1359),m3h4x4(:,280),heltab2x16(:,:,1524))
  call Hloop_Q_A(ntryL,G1H4(1359),45,nMT,G2H4(1173),n2h4(2127))
  call Hloop_QV_A(ntryL,G1H16(349),wf4(:,2),G1H4(1362),m3h4x4(:,281),heltab2x16(:,:,1525))
  call Hloop_Q_A(ntryL,G1H4(1362),45,nMT,G2H4(1176),n2h4(2128))
  call Hloop_VA_Q(ntryL,G1H16(368),ex2(:),G1H8(441),m3h2x8(:,1245),heltab2x16(:,:,1526))
  call Hloop_A_Q(ntryL,G1H8(441),38,nMT,G2H8(95),n2h8(1569))
  call Hloop_VA_Q(ntryL,G1H16(376),ex2(:),G1H8(466),m3h2x8(:,1246),heltab2x16(:,:,1527))
  call Hloop_A_Q(ntryL,G1H8(466),42,nMT,G2H8(101),n2h8(1570))
  call Hloop_AV_Q(ntryL,G1H16(364),ex3(:),G1H8(520),m3h2x8(:,1247),heltab2x16(:,:,1528))
  call Hloop_A_Q(ntryL,G1H8(520),38,nMT,G2H8(105),n2h8(1571))
  call Hloop_AV_Q(ntryL,G1H16(365),ex3(:),G1H8(526),m3h2x8(:,1248),heltab2x16(:,:,1529))
  call Hloop_A_Q(ntryL,G1H8(526),38,nMT,G2H8(106),n2h8(1572))
  call Hloop_QV_A(ntryL,G1H16(373),ex3(:),G1H8(538),m3h2x8(:,1249),heltab2x16(:,:,1530))
  call Hloop_Q_A(ntryL,G1H8(538),44,nMT,G2H8(111),n2h8(1573))
  call Hloop_UV_W(ntryL,G1H16(374),40,ex3(:),4,G2H8(120),m3h2x8(:,1250),heltab2x16(:,:,1531))
  call Hloop_VA_Q(ntryL,G1H16(372),ex2(:),G1H8(544),m3h2x8(:,1251),heltab2x16(:,:,1532))
  call Hloop_A_Q(ntryL,G1H8(544),38,nMT,G2H8(121),n2h8(1574))
  call Hloop_AV_Q(ntryL,G1H16(362),ex4(:),G1H8(598),m3h2x8(:,1252),heltab2x16(:,:,1533))
  call Hloop_A_Q(ntryL,G1H8(598),42,nMT,G2H8(62),n2h8(1575))
  call Hloop_AV_Q(ntryL,G1H16(799),ex4(:),G1H8(610),m3h2x8(:,1253),heltab2x16(:,:,1534))
  call Hloop_A_Q(ntryL,G1H8(610),42,nMT,G2H8(70),n2h8(1576))
  call Hloop_QV_A(ntryL,G1H16(366),ex4(:),G1H8(616),m3h2x8(:,1254),heltab2x16(:,:,1535))
  call Hloop_Q_A(ntryL,G1H8(616),44,nMT,G2H8(71),n2h8(1577))
  call Hloop_UV_W(ntryL,G1H16(367),36,ex4(:),8,G2H8(75),m3h2x8(:,1255),heltab2x16(:,:,1536))
  call Hloop_VQ_A(ntryL,G1H16(817),wf4(:,17),G1H4(1363),m3h4x4(:,282),heltab2x16(:,:,1537))
  call Hloop_Q_A(ntryL,G1H4(1363),53,nMT,G2H4(1177),n2h4(2129))
  call Hloop_VQ_A(ntryL,G1H16(386),ex1(:),G1H8(639),m3h2x8(:,1256),heltab2x16(:,:,1538))
  call Hloop_Q_A(ntryL,G1H8(639),37,nMT,G2H8(90),n2h8(1578))
  call Hloop_VQ_A(ntryL,G1H16(394),ex1(:),G1H8(693),m3h2x8(:,1257),heltab2x16(:,:,1539))
  call Hloop_Q_A(ntryL,G1H8(693),41,nMT,G2H8(96),n2h8(1579))
  call Hloop_QV_A(ntryL,G1H16(380),ex3(:),G1H8(711),m3h2x8(:,1258),heltab2x16(:,:,1540))
  call Hloop_Q_A(ntryL,G1H8(711),37,nMT,G2H8(97),n2h8(1580))
  call Hloop_QV_A(ntryL,G1H16(383),ex3(:),G1H8(742),m3h2x8(:,1259),heltab2x16(:,:,1541))
  call Hloop_Q_A(ntryL,G1H8(742),37,nMT,G2H8(116),n2h8(1581))
  call Hloop_AV_Q(ntryL,G1H16(391),ex3(:),G1H8(754),m3h2x8(:,1260),heltab2x16(:,:,1542))
  call Hloop_A_Q(ntryL,G1H8(754),44,nMT,G2H8(117),n2h8(1582))
  call Hloop_UV_W(ntryL,G1H16(392),40,ex3(:),4,G2H8(125),m3h2x8(:,1261),heltab2x16(:,:,1543))
  call Hloop_VQ_A(ntryL,G1H16(390),ex1(:),G1H8(783),m3h2x8(:,1262),heltab2x16(:,:,1544))
  call Hloop_Q_A(ntryL,G1H8(783),37,nMT,G2H8(140),n2h8(1583))
  call Hloop_QV_A(ntryL,G1H16(382),ex4(:),G1H8(819),m3h2x8(:,1263),heltab2x16(:,:,1545))
  call Hloop_Q_A(ntryL,G1H8(819),41,nMT,G2H8(142),n2h8(1584))
  call Hloop_QV_A(ntryL,G1H16(865),ex4(:),G1H8(837),m3h2x8(:,1264),heltab2x16(:,:,1546))
  call Hloop_Q_A(ntryL,G1H8(837),41,nMT,G2H8(145),n2h8(1585))
  call Hloop_AV_Q(ntryL,G1H16(384),ex4(:),G1H8(855),m3h2x8(:,1265),heltab2x16(:,:,1547))
  call Hloop_A_Q(ntryL,G1H8(855),44,nMT,G2H8(160),n2h8(1586))
  call Hloop_UV_W(ntryL,G1H16(385),36,ex4(:),8,G2H8(171),m3h2x8(:,1266),heltab2x16(:,:,1548))
  call Hloop_VA_Q(ntryL,G1H16(883),wf4(:,19),G1H4(1364),m3h4x4(:,283),heltab2x16(:,:,1549))
  call Hloop_A_Q(ntryL,G1H4(1364),54,nMT,G2H4(1178),n2h4(2130))
  call Hloop_VQ_A(ntryL,G1H16(409),ex1(:),G1H8(927),m3h2x8(:,1267),heltab2x16(:,:,1550))
  call Hloop_Q_A(ntryL,G1H8(927),41,nMT,G2H8(175),n2h8(1587))
  call Hloop_VA_Q(ntryL,G1H16(407),ex2(:),G1H8(1),m3h2x8(:,1268),heltab2x16(:,:,1551))
  call Hloop_A_Q(ntryL,G1H8(1),42,nMT,G2H8(181),n2h8(1588))
  call Hloop_QV_A(ntryL,G1H16(400),ex4(:),G1H8(2),m3h2x8(:,1269),heltab2x16(:,:,1552))
  call Hloop_Q_A(ntryL,G1H8(2),41,nMT,G2H8(182),n2h8(1589))
  call Hloop_QV_A(ntryL,G1H16(900),ex4(:),G1H8(3),m3h2x8(:,1270),heltab2x16(:,:,1553))
  call Hloop_Q_A(ntryL,G1H8(3),41,nMT,G2H8(186),n2h8(1590))
  call Hloop_AV_Q(ntryL,G1H16(403),ex4(:),G1H8(187),m3h2x8(:,1271),heltab2x16(:,:,1554))
  call Hloop_A_Q(ntryL,G1H8(187),42,nMT,G2H8(195),n2h8(1591))
  call Hloop_AV_Q(ntryL,G1H16(909),wf4(:,3),G1H4(1367),m3h4x4(:,284),heltab2x16(:,:,1555))
  call Hloop_A_Q(ntryL,G1H4(1367),54,nMT,G2H4(1181),n2h4(2131))
  call Hloop_QV_A(ntryL,G1H16(915),wf4(:,3),G1H4(1368),m3h4x4(:,285),heltab2x16(:,:,1556))
  call Hloop_Q_A(ntryL,G1H4(1368),53,nMT,G2H4(1182),n2h4(2132))
  call Hloop_QV_A(ntryL,G1H16(919),wf4(:,3),G1H4(1369),m3h4x4(:,286),heltab2x16(:,:,1557))
  call Hloop_Q_A(ntryL,G1H4(1369),53,nMT,G2H4(1183),n2h4(2133))
  call Hloop_VQ_A(ntryL,G1H16(421),ex1(:),G1H8(113),m3h2x8(:,1272),heltab2x16(:,:,1558))
  call Hloop_Q_A(ntryL,G1H8(113),37,nMT,G2H8(196),n2h8(1592))
  call Hloop_VA_Q(ntryL,G1H16(424),ex2(:),G1H8(175),m3h2x8(:,1273),heltab2x16(:,:,1559))
  call Hloop_A_Q(ntryL,G1H8(175),38,nMT,G2H8(197),n2h8(1593))
  call Hloop_QV_A(ntryL,G1H16(414),ex3(:),G1H8(85),m3h2x8(:,1274),heltab2x16(:,:,1560))
  call Hloop_Q_A(ntryL,G1H8(85),37,nMT,G2H8(207),n2h8(1594))
  call Hloop_QV_A(ntryL,G1H16(938),ex3(:),G1H8(156),m3h2x8(:,1275),heltab2x16(:,:,1561))
  call Hloop_Q_A(ntryL,G1H8(156),37,nMT,G2H8(210),n2h8(1595))
  call Hloop_AV_Q(ntryL,G1H16(418),ex3(:),G1H8(191),m3h2x8(:,1276),heltab2x16(:,:,1562))
  call Hloop_A_Q(ntryL,G1H8(191),38,nMT,G2H8(211),n2h8(1596))
  call Hloop_AV_Q(ntryL,G1H16(947),wf4(:,5),G1H4(1370),m3h4x4(:,287),heltab2x16(:,:,1563))
  call Hloop_A_Q(ntryL,G1H4(1370),58,nMT,G2H4(1186),n2h4(2134))
  call Hloop_QV_A(ntryL,G1H16(953),wf4(:,5),G1H4(8),m3h4x4(:,288),heltab2x16(:,:,1564))
  call Hloop_Q_A(ntryL,G1H4(8),57,nMT,G2H4(1187),n2h4(2135))
  call Hloop_QV_A(ntryL,G1H16(957),wf4(:,5),G1H4(1379),m3h4x4(:,289),heltab2x16(:,:,1565))
  call Hloop_Q_A(ntryL,G1H4(1379),57,nMT,G2H4(1188),n2h4(2136))
  call Hloop_VA_Q(ntryL,G1H16(275),ex2(:),G1H8(107),m3h2x8(:,1277),heltab2x16(:,:,1566))
  call Hloop_A_Q(ntryL,G1H8(107),50,nMT,G2H8(220),n2h8(1597))
  call Hloop_VA_Q(ntryL,G1H16(32),ex2(:),G1H8(97),m3h2x8(:,1278),heltab2x16(:,:,1567))
  call Hloop_A_Q(ntryL,G1H8(97),50,nMT,G2H8(222),n2h8(1598))
  call Hloop_VA_Q(ntryL,G1H16(276),ex2(:),G1H8(174),m3h2x8(:,1279),heltab2x16(:,:,1568))
  call Hloop_A_Q(ntryL,G1H8(174),50,nMT,G2H8(235),n2h8(1599))
  call Hloop_VQ_A(ntryL,G1H16(270),ex1(:),G1H8(101),m3h2x8(:,1280),heltab2x16(:,:,1569))
  call Hloop_Q_A(ntryL,G1H8(101),49,nMT,G2H8(240),n2h8(1600))
  call Hloop_VQ_A(ntryL,G1H16(273),ex1(:),G1H8(170),m3h2x8(:,1281),heltab2x16(:,:,1570))
  call Hloop_Q_A(ntryL,G1H8(170),49,nMT,G2H8(241),n2h8(1601))
  call Hloop_VQ_A(ntryL,G1H16(274),ex1(:),G1H8(125),m3h2x8(:,1282),heltab2x16(:,:,1571))
  call Hloop_Q_A(ntryL,G1H8(125),49,nMT,G2H8(244),n2h8(1602))
  call Hloop_UV_W(ntryL,G1H32(109),32,ex3(:),4,G2H16(49),m3h2x16(:,465),heltab2x32(:,:,547))
  call Hloop_UV_W(ntryL,G1H32(111),32,ex3(:),4,G2H16(50),m3h2x16(:,466),heltab2x32(:,:,548))
  call Hloop_UV_W(ntryL,G1H32(120),32,ex3(:),4,G2H16(51),m3h2x16(:,467),heltab2x32(:,:,549))
  call Hloop_UV_W(ntryL,G1H32(122),32,ex4(:),8,G2H16(52),m3h2x16(:,468),heltab2x32(:,:,550))
  call Hloop_UV_W(ntryL,G1H32(131),32,ex4(:),8,G2H16(53),m3h2x16(:,469),heltab2x32(:,:,551))
  call Hloop_UV_W(ntryL,G1H32(133),32,ex4(:),8,G2H16(54),m3h2x16(:,470),heltab2x32(:,:,552))
  call Hloop_UV_W(ntryL,G1H32(142),32,ex3(:),4,G2H16(55),m3h2x16(:,471),heltab2x32(:,:,553))
  call Hloop_UV_W(ntryL,G1H32(144),32,ex3(:),4,G2H16(56),m3h2x16(:,472),heltab2x32(:,:,554))
  call Hloop_UV_W(ntryL,G1H32(153),32,ex3(:),4,G2H16(57),m3h2x16(:,473),heltab2x32(:,:,555))
  call Hloop_UV_W(ntryL,G1H16(52),48,wf4(:,1),3,G2H4(1191),m3h4x4(:,290),heltab2x16(:,:,1572))
  call Hloop_UV_W(ntryL,G1H16(83),48,wf4(:,1),3,G2H4(1192),m3h4x4(:,291),heltab2x16(:,:,1573))
  call Hloop_UV_W(ntryL,G1H16(118),48,ex3(:),4,G2H8(253),m3h2x8(:,1283),heltab2x16(:,:,1574))
  call Hloop_UV_W(ntryL,G1H32(155),32,ex3(:),4,G2H16(58),m3h2x16(:,474),heltab2x32(:,:,556))
  call Hloop_UV_W(ntryL,G1H32(164),32,ex3(:),4,G2H16(59),m3h2x16(:,475),heltab2x32(:,:,557))
  call Hloop_UV_W(ntryL,G1H32(166),32,ex3(:),4,G2H16(60),m3h2x16(:,476),heltab2x32(:,:,558))
  call Hloop_GGG_G_12(ntryL,G1H32(175),ex4(:),wf4(:,1),G1H4(1375),m4h2x4x4(:,1),heltab3x32(:,:,7))
  call Hloop_GGG_G_12(ntryL,G1H32(177),wf4(:,1),ex4(:),G1H4(1378),m4h4x2x4(:,1),heltab3x32(:,:,8))
  call Hloop_GGG_G_23(ntryL,G1H32(186),ex4(:),wf4(:,1),G1H4(1380),m4h2x4x4(:,2),heltab3x32(:,:,9))
  call Hloop_UV_W(ntryL,G1H32(188),32,ex3(:),4,G2H16(61),m3h2x16(:,477),heltab2x32(:,:,559))
  call Hloop_UV_W(ntryL,G1H32(197),32,ex3(:),4,G2H16(62),m3h2x16(:,478),heltab2x32(:,:,560))
  call Hloop_UV_W(ntryL,G1H32(199),32,ex3(:),4,G2H16(63),m3h2x16(:,479),heltab2x32(:,:,561))
  call Hloop_UV_W(ntryL,G1H16(84),40,wf4(:,1),3,G2H4(1193),m3h4x4(:,292),heltab2x16(:,:,1575))
  call Hloop_UV_W(ntryL,G1H32(208),32,ex3(:),4,G2H16(64),m3h2x16(:,480),heltab2x32(:,:,562))
  call Hloop_UV_W(ntryL,G1H32(210),32,ex3(:),4,G2H16(65),m3h2x16(:,481),heltab2x32(:,:,563))
  call Hloop_UV_W(ntryL,G1H32(219),32,ex3(:),4,G2H16(66),m3h2x16(:,482),heltab2x32(:,:,564))
  call Hloop_UV_W(ntryL,G1H32(221),32,wf4(:,1),3,G2H8(254),m3h4x8(:,83),heltab2x32(:,:,565))
  call Hloop_UV_W(ntryL,G1H32(230),32,wf4(:,1),3,G2H8(255),m3h4x8(:,84),heltab2x32(:,:,566))
  call Hloop_UV_W(ntryL,G1H32(232),32,wf4(:,1),3,G2H8(151),m3h4x8(:,85),heltab2x32(:,:,567))
  call Hloop_UV_W(ntryL,G1H32(1),32,wf4(:,1),3,G2H8(77),m3h4x8(:,86),heltab2x32(:,:,568))
  call Hloop_UV_W(ntryL,G1H32(2),32,wf4(:,1),3,G2H8(152),m3h4x8(:,87),heltab2x32(:,:,569))
  call Hloop_UV_W(ntryL,G1H32(3),32,wf4(:,1),3,G2H8(247),m3h4x8(:,88),heltab2x32(:,:,570))
  call Hloop_GGG_G_12(ntryL,G1H32(4),ex3(:),wf4(:,1),G1H4(1383),m4h2x4x4(:,3),heltab3x32(:,:,10))
  call Hloop_GGG_G_12(ntryL,G1H32(5),wf4(:,1),ex3(:),G1H4(9),m4h4x2x4(:,2),heltab3x32(:,:,11))
  call Hloop_GGG_G_23(ntryL,G1H32(6),ex3(:),wf4(:,1),G1H4(1384),m4h2x4x4(:,4),heltab3x32(:,:,12))
  call Hloop_GGG_G_12(ntryL,G1H32(7),ex3(:),wf4(:,1),G1H4(1387),m4h2x4x4(:,5),heltab3x32(:,:,13))
  call Hloop_GGG_G_12(ntryL,G1H32(8),wf4(:,1),ex3(:),G1H4(1388),m4h4x2x4(:,3),heltab3x32(:,:,14))
  call Hloop_GGG_G_23(ntryL,G1H32(9),ex3(:),wf4(:,1),G1H4(11),m4h2x4x4(:,6),heltab3x32(:,:,15))
  call Hloop_UV_W(ntryL,G1H32(10),32,ex4(:),8,G2H16(67),m3h2x16(:,483),heltab2x32(:,:,571))
  call Hloop_UV_W(ntryL,G1H32(11),32,ex4(:),8,G2H16(68),m3h2x16(:,484),heltab2x32(:,:,572))
  call Hloop_UV_W(ntryL,G1H32(12),32,ex4(:),8,G2H16(69),m3h2x16(:,485),heltab2x32(:,:,573))
  call Hloop_UV_W(ntryL,G1H32(13),32,ex4(:),8,G2H16(70),m3h2x16(:,486),heltab2x32(:,:,574))
  call Hloop_UV_W(ntryL,G1H32(14),32,ex4(:),8,G2H16(71),m3h2x16(:,487),heltab2x32(:,:,575))
  call Hloop_UV_W(ntryL,G1H32(15),32,ex4(:),8,G2H16(72),m3h2x16(:,488),heltab2x32(:,:,576))
  call Hloop_UV_W(ntryL,G1H32(16),32,wf4(:,1),3,G2H8(262),m3h4x8(:,89),heltab2x32(:,:,577))
  call Hloop_UV_W(ntryL,G1H32(17),32,wf4(:,1),3,G2H8(252),m3h4x8(:,90),heltab2x32(:,:,578))
  call Hloop_UV_W(ntryL,G1H32(18),32,wf4(:,1),3,G2H8(155),m3h4x8(:,91),heltab2x32(:,:,579))
  call Hloop_UV_W(ntryL,G1H32(19),32,wf4(:,1),3,G2H8(156),m3h4x8(:,92),heltab2x32(:,:,580))
  call Hloop_UV_W(ntryL,G1H32(20),32,wf4(:,1),3,G2H8(167),m3h4x8(:,93),heltab2x32(:,:,581))
  call Hloop_UV_W(ntryL,G1H32(21),32,wf4(:,1),3,G2H8(170),m3h4x8(:,94),heltab2x32(:,:,582))
  call Hloop_GGG_G_12(ntryL,G1H32(22),ex4(:),ex3(:),G1H8(128),m4h2x2x8(:,7),heltab3x32(:,:,16))
  call Hloop_GGG_G_12(ntryL,G1H32(23),ex3(:),ex4(:),G1H8(134),m4h2x2x8(:,8),heltab3x32(:,:,17))
  call Hloop_GGG_G_23(ntryL,G1H32(24),ex4(:),ex3(:),G1H8(137),m4h2x2x8(:,9),heltab3x32(:,:,18))
  call Hloop_UV_W(ntryL,G1H32(25),32,wf4(:,1),3,G2H8(165),m3h4x8(:,95),heltab2x32(:,:,583))
  call Hloop_UV_W(ntryL,G1H32(26),32,wf4(:,1),3,G2H8(91),m3h4x8(:,96),heltab2x32(:,:,584))
  call Hloop_UV_W(ntryL,G1H32(27),32,wf4(:,1),3,G2H8(127),m3h4x8(:,97),heltab2x32(:,:,585))
  call Hloop_UV_W(ntryL,G1H32(28),32,wf4(:,1),3,G2H8(130),m3h4x8(:,98),heltab2x32(:,:,586))
  call Hloop_UV_W(ntryL,G1H32(29),32,wf4(:,1),3,G2H8(132),m3h4x8(:,99),heltab2x32(:,:,587))
  call Hloop_UV_W(ntryL,G1H32(30),32,wf4(:,1),3,G2H8(56),m3h4x8(:,100),heltab2x32(:,:,588))
  call Hloop_VQ_A(ntryL,G1H16(6),wf4(:,9),G1H4(12),m3h4x4(:,293),heltab2x16(:,:,1576))
  call Hloop_Q_A(ntryL,G1H4(12),53,nMT,G2H4(1196),n2h4(2137))
  call Hloop_VA_Q(ntryL,G1H16(10),ex2(:),G1H8(138),m3h2x8(:,1284),heltab2x16(:,:,1577))
  call Hloop_A_Q(ntryL,G1H8(138),50,nMT,G2H8(57),n2h8(1603))
  call Hloop_VA_Q(ntryL,G1H16(16),ex2(:),G1H8(144),m3h2x8(:,1285),heltab2x16(:,:,1578))
  call Hloop_A_Q(ntryL,G1H8(144),50,nMT,G2H8(59),n2h8(1604))
  call Hloop_VA_Q(ntryL,G1H16(134),ex2(:),G1H8(197),m3h2x8(:,1286),heltab2x16(:,:,1579))
  call Hloop_A_Q(ntryL,G1H8(197),42,nMT,G2H8(225),n2h8(1605))
  call Hloop_VA_Q(ntryL,G1H32(31),ex2(:),G1H16(427),m3h2x16(:,489),heltab2x32(:,:,589))
  call Hloop_A_Q(ntryL,G1H16(427),34,nMT,G2H16(73),n2h16(729))
  call Hloop_VA_Q(ntryL,G1H32(32),ex2(:),G1H16(428),m3h2x16(:,490),heltab2x32(:,:,590))
  call Hloop_A_Q(ntryL,G1H16(428),34,nMT,G2H16(74),n2h16(730))
  call Hloop_VA_Q(ntryL,G1H32(33),ex2(:),G1H16(430),m3h2x16(:,491),heltab2x32(:,:,591))
  call Hloop_A_Q(ntryL,G1H16(430),34,nMT,G2H16(75),n2h16(731))
  call Hloop_QA_V(ntryL,G1H32(34),ex2(:),G1H16(431),m3h2x16(:,492),heltab2x32(:,:,592))
  call Hloop_QA_V(ntryL,G1H32(35),ex2(:),G1H16(432),m3h2x16(:,493),heltab2x32(:,:,593))
  call Hloop_QA_V(ntryL,G1H32(36),ex2(:),G1H16(433),m3h2x16(:,494),heltab2x32(:,:,594))
  call Hloop_VQ_A(ntryL,G1H32(37),wf4(:,9),G1H8(103),m3h4x8(:,101),heltab2x32(:,:,595))
  call Hloop_Q_A(ntryL,G1H8(103),37,nMT,G2H8(226),n2h8(1606))
  call Hloop_VQ_A(ntryL,G1H32(38),wf4(:,9),G1H8(146),m3h4x8(:,102),heltab2x32(:,:,596))
  call Hloop_Q_A(ntryL,G1H8(146),37,nMT,G2H8(227),n2h8(1607))
  call Hloop_VQ_A(ntryL,G1H32(39),wf4(:,9),G1H8(213),m3h4x8(:,103),heltab2x32(:,:,597))
  call Hloop_Q_A(ntryL,G1H8(213),37,nMT,G2H8(332),n2h8(1608))
  call Hloop_VA_Q(ntryL,G1H16(200),wf4(:,11),G1H4(1393),m3h4x4(:,294),heltab2x16(:,:,1580))
  call Hloop_A_Q(ntryL,G1H4(1393),54,nMT,G2H4(1197),n2h4(2138))
  call Hloop_VQ_A(ntryL,G1H16(201),ex1(:),G1H8(214),m3h2x8(:,1287),heltab2x16(:,:,1581))
  call Hloop_Q_A(ntryL,G1H8(214),49,nMT,G2H8(333),n2h8(1609))
  call Hloop_VQ_A(ntryL,G1H16(205),ex1(:),G1H8(318),m3h2x8(:,1288),heltab2x16(:,:,1582))
  call Hloop_Q_A(ntryL,G1H8(318),49,nMT,G2H8(334),n2h8(1610))
  call Hloop_VQ_A(ntryL,G1H16(175),ex1(:),G1H8(319),m3h2x8(:,1289),heltab2x16(:,:,1583))
  call Hloop_Q_A(ntryL,G1H8(319),41,nMT,G2H8(337),n2h8(1611))
  call Hloop_VQ_A(ntryL,G1H32(40),ex1(:),G1H16(434),m3h2x16(:,495),heltab2x32(:,:,598))
  call Hloop_Q_A(ntryL,G1H16(434),33,nMT,G2H16(76),n2h16(732))
  call Hloop_VQ_A(ntryL,G1H32(41),ex1(:),G1H16(436),m3h2x16(:,496),heltab2x32(:,:,599))
  call Hloop_Q_A(ntryL,G1H16(436),33,nMT,G2H16(77),n2h16(733))
  call Hloop_VQ_A(ntryL,G1H32(42),ex1(:),G1H16(437),m3h2x16(:,497),heltab2x32(:,:,600))
  call Hloop_Q_A(ntryL,G1H16(437),33,nMT,G2H16(78),n2h16(734))
  call Hloop_AQ_V(ntryL,G1H32(43),ex1(:),G1H16(438),m3h2x16(:,498),heltab2x32(:,:,601))
  call Hloop_AQ_V(ntryL,G1H32(44),ex1(:),G1H16(439),m3h2x16(:,499),heltab2x32(:,:,602))
  call Hloop_AQ_V(ntryL,G1H32(45),ex1(:),G1H16(440),m3h2x16(:,500),heltab2x32(:,:,603))
  call Hloop_VA_Q(ntryL,G1H32(46),wf4(:,11),G1H8(325),m3h4x8(:,104),heltab2x32(:,:,604))
  call Hloop_A_Q(ntryL,G1H8(325),38,nMT,G2H8(338),n2h8(1612))
  call Hloop_VA_Q(ntryL,G1H32(47),wf4(:,11),G1H8(326),m3h4x8(:,105),heltab2x32(:,:,605))
  call Hloop_A_Q(ntryL,G1H8(326),38,nMT,G2H8(339),n2h8(1613))
  call Hloop_VA_Q(ntryL,G1H32(48),wf4(:,11),G1H8(329),m3h4x8(:,106),heltab2x32(:,:,606))
  call Hloop_A_Q(ntryL,G1H8(329),38,nMT,G2H8(342),n2h8(1614))
  call Hloop_UV_W(ntryL,G1H16(237),48,ex3(:),4,G2H8(343),m3h2x8(:,1290),heltab2x16(:,:,1584))
  call Hloop_VA_Q(ntryL,G1H16(238),ex2(:),G1H8(330),m3h2x8(:,1291),heltab2x16(:,:,1585))
  call Hloop_A_Q(ntryL,G1H8(330),50,nMT,G2H8(344),n2h8(1615))
  call Hloop_VA_Q(ntryL,G1H16(329),ex2(:),G1H8(336),m3h2x8(:,1292),heltab2x16(:,:,1586))
  call Hloop_A_Q(ntryL,G1H8(336),50,nMT,G2H8(347),n2h8(1616))
  call Hloop_UV_W(ntryL,G1H16(342),48,ex3(:),4,G2H8(348),m3h2x8(:,1293),heltab2x16(:,:,1587))
  call Hloop_VQ_A(ntryL,G1H16(343),ex1(:),G1H8(337),m3h2x8(:,1294),heltab2x16(:,:,1588))
  call Hloop_Q_A(ntryL,G1H8(337),49,nMT,G2H8(349),n2h8(1617))
  call Hloop_VQ_A(ntryL,G1H16(347),ex1(:),G1H8(338),m3h2x8(:,1295),heltab2x16(:,:,1589))
  call Hloop_Q_A(ntryL,G1H8(338),49,nMT,G2H8(352),n2h8(1618))
  call Hloop_VQ_A(ntryL,G1H32(49),ex1(:),G1H16(442),m3h2x16(:,501),heltab2x32(:,:,607))
  call Hloop_Q_A(ntryL,G1H16(442),33,nMT,G2H16(1),n2h16(735))
  call Hloop_VQ_A(ntryL,G1H32(50),ex1(:),G1H16(443),m3h2x16(:,502),heltab2x32(:,:,608))
  call Hloop_Q_A(ntryL,G1H16(443),33,nMT,G2H16(2),n2h16(736))
  call Hloop_VQ_A(ntryL,G1H32(51),ex1(:),G1H16(444),m3h2x16(:,503),heltab2x32(:,:,609))
  call Hloop_Q_A(ntryL,G1H16(444),33,nMT,G2H16(3),n2h16(737))
  call Hloop_VA_Q(ntryL,G1H32(52),ex2(:),G1H16(445),m3h2x16(:,504),heltab2x32(:,:,610))
  call Hloop_A_Q(ntryL,G1H16(445),34,nMT,G2H16(4),n2h16(738))
  call Hloop_VA_Q(ntryL,G1H32(53),ex2(:),G1H16(446),m3h2x16(:,505),heltab2x32(:,:,611))
  call Hloop_A_Q(ntryL,G1H16(446),34,nMT,G2H16(5),n2h16(739))
  call Hloop_VA_Q(ntryL,G1H32(54),ex2(:),G1H16(448),m3h2x16(:,506),heltab2x32(:,:,612))
  call Hloop_A_Q(ntryL,G1H16(448),34,nMT,G2H16(6),n2h16(740))
  call Hloop_AQ_V(ntryL,G1H32(55),ex1(:),G1H16(449),m3h2x16(:,507),heltab2x32(:,:,613))
  call Hloop_AQ_V(ntryL,G1H32(56),ex1(:),G1H16(450),m3h2x16(:,508),heltab2x32(:,:,614))
  call Hloop_AQ_V(ntryL,G1H32(57),ex1(:),G1H16(451),m3h2x16(:,509),heltab2x32(:,:,615))
  call Hloop_VA_Q(ntryL,G1H16(356),ex2(:),G1H8(342),m3h2x8(:,1296),heltab2x16(:,:,1590))
  call Hloop_A_Q(ntryL,G1H8(342),50,nMT,G2H8(353),n2h8(1619))
  call Hloop_VQ_A(ntryL,G1H16(359),ex1(:),G1H8(347),m3h2x8(:,1297),heltab2x16(:,:,1591))
  call Hloop_Q_A(ntryL,G1H8(347),49,nMT,G2H8(354),n2h8(1620))
  call Hloop_VQ_A(ntryL,G1H16(360),ex1(:),G1H8(348),m3h2x8(:,1298),heltab2x16(:,:,1592))
  call Hloop_Q_A(ntryL,G1H8(348),49,nMT,G2H8(357),n2h8(1621))
  call Hloop_VA_Q(ntryL,G1H16(379),ex2(:),G1H8(350),m3h2x8(:,1299),heltab2x16(:,:,1593))
  call Hloop_A_Q(ntryL,G1H8(350),42,nMT,G2H8(358),n2h8(1622))
  call Hloop_VQ_A(ntryL,G1H16(397),ex1(:),G1H8(353),m3h2x8(:,1300),heltab2x16(:,:,1594))
  call Hloop_Q_A(ntryL,G1H8(353),41,nMT,G2H8(359),n2h8(1623))
  call Hloop_VQ_A(ntryL,G1H32(58),ex1(:),G1H16(452),m3h2x16(:,510),heltab2x32(:,:,616))
  call Hloop_Q_A(ntryL,G1H16(452),33,nMT,G2H16(79),n2h16(741))
  call Hloop_VQ_A(ntryL,G1H32(59),ex1(:),G1H16(454),m3h2x16(:,511),heltab2x32(:,:,617))
  call Hloop_Q_A(ntryL,G1H16(454),33,nMT,G2H16(80),n2h16(742))
  call Hloop_VQ_A(ntryL,G1H32(60),ex1(:),G1H16(455),m3h2x16(:,512),heltab2x32(:,:,618))
  call Hloop_Q_A(ntryL,G1H16(455),33,nMT,G2H16(81),n2h16(743))
  call Hloop_VA_Q(ntryL,G1H32(61),ex2(:),G1H16(456),m3h2x16(:,513),heltab2x32(:,:,619))
  call Hloop_A_Q(ntryL,G1H16(456),34,nMT,G2H16(82),n2h16(744))
  call Hloop_VA_Q(ntryL,G1H32(62),ex2(:),G1H16(457),m3h2x16(:,514),heltab2x32(:,:,620))
  call Hloop_A_Q(ntryL,G1H16(457),34,nMT,G2H16(83),n2h16(745))
  call Hloop_VA_Q(ntryL,G1H32(63),ex2(:),G1H16(458),m3h2x16(:,515),heltab2x32(:,:,621))
  call Hloop_A_Q(ntryL,G1H16(458),34,nMT,G2H16(84),n2h16(746))
  call Hloop_AQ_V(ntryL,G1H32(64),ex1(:),G1H16(460),m3h2x16(:,516),heltab2x32(:,:,622))
  call Hloop_AQ_V(ntryL,G1H32(65),ex1(:),G1H16(461),m3h2x16(:,517),heltab2x32(:,:,623))
  call Hloop_AQ_V(ntryL,G1H32(66),ex1(:),G1H16(462),m3h2x16(:,518),heltab2x32(:,:,624))
  call Hloop_VQ_A(ntryL,G1H16(410),ex1(:),G1H8(356),m3h2x8(:,1301),heltab2x16(:,:,1595))
  call Hloop_Q_A(ntryL,G1H8(356),41,nMT,G2H8(362),n2h8(1624))
  call Hloop_QA_V(ntryL,G1H16(153),ex2(:),G1H8(360),m3h2x8(:,1302),heltab2x16(:,:,1596))
  call Hloop_QA_V(ntryL,G1H16(154),ex2(:),G1H8(219),m3h2x8(:,1303),heltab2x16(:,:,1597))
  call Hloop_QA_V(ntryL,G1H16(14),ex2(:),G1H8(220),m3h2x8(:,1304),heltab2x16(:,:,1598))
  call Hloop_QA_V(ntryL,G1H16(160),ex2(:),G1H8(185),m3h2x8(:,1305),heltab2x16(:,:,1599))
  call Hloop_QA_V(ntryL,G1H16(166),ex2(:),G1H8(79),m3h2x8(:,1306),heltab2x16(:,:,1600))
  call Hloop_QA_V(ntryL,G1H16(15),ex2(:),G1H8(149),m3h2x8(:,1307),heltab2x16(:,:,1601))
  call Hloop_AQ_V(ntryL,G1H16(90),ex1(:),G1H8(250),m3h2x8(:,1308),heltab2x16(:,:,1602))
  call Hloop_AQ_V(ntryL,G1H16(95),ex1(:),G1H8(120),m3h2x8(:,1309),heltab2x16(:,:,1603))
  call Hloop_AQ_V(ntryL,G1H16(17),ex1(:),G1H8(122),m3h2x8(:,1310),heltab2x16(:,:,1604))
  call Hloop_AQ_V(ntryL,G1H16(182),ex1(:),G1H8(132),m3h2x8(:,1311),heltab2x16(:,:,1605))
  call Hloop_AQ_V(ntryL,G1H16(183),ex1(:),G1H8(285),m3h2x8(:,1312),heltab2x16(:,:,1606))
  call Hloop_AQ_V(ntryL,G1H16(186),ex1(:),G1H8(292),m3h2x8(:,1313),heltab2x16(:,:,1607))
  call Hloop_AQ_V(ntryL,G1H16(197),ex1(:),G1H8(95),m3h2x8(:,1314),heltab2x16(:,:,1608))
  call Hloop_AQ_V(ntryL,G1H16(20),ex1(:),G1H8(180),m3h2x8(:,1315),heltab2x16(:,:,1609))
  call Hloop_AQ_V(ntryL,G1H16(22),ex1(:),G1H8(91),m3h2x8(:,1316),heltab2x16(:,:,1610))
  call Hloop_QA_V(ntryL,G1H8(886),ex2(:),G1H4(1398),m3h2x4(:,2290),heltab2x8(:,:,2759))
  call Hloop_AQ_V(ntryL,G1H8(898),ex1(:),G1H4(1394),m3h2x4(:,2291),heltab2x8(:,:,2760))
  call Hloop_AQ_V(ntryL,G1H8(921),ex1(:),G1H4(1397),m3h2x4(:,2292),heltab2x8(:,:,2761))
  call Hloop_VA_Q(ntryL,G1H32(67),ex2(:),G1H16(463),m3h2x16(:,519),heltab2x32(:,:,625))
  call Hloop_A_Q(ntryL,G1H16(463),34,nMT,G2H16(85),n2h16(747))
  call Hloop_VA_Q(ntryL,G1H32(68),ex2(:),G1H16(464),m3h2x16(:,520),heltab2x32(:,:,626))
  call Hloop_A_Q(ntryL,G1H16(464),34,nMT,G2H16(86),n2h16(748))
  call Hloop_VA_Q(ntryL,G1H32(69),ex2(:),G1H16(466),m3h2x16(:,521),heltab2x32(:,:,627))
  call Hloop_A_Q(ntryL,G1H16(466),34,nMT,G2H16(87),n2h16(749))
  call Hloop_QA_V(ntryL,G1H32(70),ex2(:),G1H16(467),m3h2x16(:,522),heltab2x32(:,:,628))
  call Hloop_QA_V(ntryL,G1H32(71),ex2(:),G1H16(468),m3h2x16(:,523),heltab2x32(:,:,629))
  call Hloop_QA_V(ntryL,G1H32(72),ex2(:),G1H16(469),m3h2x16(:,524),heltab2x32(:,:,630))
  call Hloop_VQ_A(ntryL,G1H32(73),wf4(:,13),G1H8(322),m3h4x8(:,107),heltab2x32(:,:,631))
  call Hloop_Q_A(ntryL,G1H8(322),41,nMT,G2H8(363),n2h8(1625))
  call Hloop_VQ_A(ntryL,G1H32(74),wf4(:,13),G1H8(327),m3h4x8(:,108),heltab2x32(:,:,632))
  call Hloop_Q_A(ntryL,G1H8(327),41,nMT,G2H8(364),n2h8(1626))
  call Hloop_VQ_A(ntryL,G1H32(75),wf4(:,13),G1H8(328),m3h4x8(:,109),heltab2x32(:,:,633))
  call Hloop_Q_A(ntryL,G1H8(328),41,nMT,G2H8(367),n2h8(1627))
  call Hloop_VQ_A(ntryL,G1H32(76),ex1(:),G1H16(470),m3h2x16(:,525),heltab2x32(:,:,634))
  call Hloop_Q_A(ntryL,G1H16(470),33,nMT,G2H16(88),n2h16(750))
  call Hloop_VQ_A(ntryL,G1H32(77),ex1(:),G1H16(472),m3h2x16(:,526),heltab2x32(:,:,635))
  call Hloop_Q_A(ntryL,G1H16(472),33,nMT,G2H16(89),n2h16(751))
  call Hloop_VQ_A(ntryL,G1H32(78),ex1(:),G1H16(473),m3h2x16(:,527),heltab2x32(:,:,636))
  call Hloop_Q_A(ntryL,G1H16(473),33,nMT,G2H16(90),n2h16(752))
  call Hloop_AQ_V(ntryL,G1H32(79),ex1(:),G1H16(474),m3h2x16(:,528),heltab2x32(:,:,637))
  call Hloop_AQ_V(ntryL,G1H32(80),ex1(:),G1H16(475),m3h2x16(:,529),heltab2x32(:,:,638))
  call Hloop_AQ_V(ntryL,G1H32(81),ex1(:),G1H16(476),m3h2x16(:,530),heltab2x32(:,:,639))
  call Hloop_VA_Q(ntryL,G1H32(82),wf4(:,15),G1H8(119),m3h4x8(:,110),heltab2x32(:,:,640))
  call Hloop_A_Q(ntryL,G1H8(119),42,nMT,G2H8(368),n2h8(1628))
  call Hloop_VA_Q(ntryL,G1H32(83),wf4(:,15),G1H8(351),m3h4x8(:,111),heltab2x32(:,:,641))
  call Hloop_A_Q(ntryL,G1H8(351),42,nMT,G2H8(369),n2h8(1629))
  call Hloop_VA_Q(ntryL,G1H32(84),wf4(:,15),G1H8(352),m3h4x8(:,112),heltab2x32(:,:,642))
  call Hloop_A_Q(ntryL,G1H8(352),42,nMT,G2H8(372),n2h8(1630))
  call Hloop_VQ_A(ntryL,G1H32(85),ex1(:),G1H16(478),m3h2x16(:,531),heltab2x32(:,:,643))
  call Hloop_Q_A(ntryL,G1H16(478),33,nMT,G2H16(91),n2h16(753))
  call Hloop_VQ_A(ntryL,G1H32(86),ex1(:),G1H16(479),m3h2x16(:,532),heltab2x32(:,:,644))
  call Hloop_Q_A(ntryL,G1H16(479),33,nMT,G2H16(92),n2h16(754))
  call Hloop_VQ_A(ntryL,G1H32(87),ex1(:),G1H16(480),m3h2x16(:,533),heltab2x32(:,:,645))
  call Hloop_Q_A(ntryL,G1H16(480),33,nMT,G2H16(93),n2h16(755))
  call Hloop_VA_Q(ntryL,G1H32(88),ex2(:),G1H16(481),m3h2x16(:,534),heltab2x32(:,:,646))
  call Hloop_A_Q(ntryL,G1H16(481),34,nMT,G2H16(94),n2h16(756))
  call Hloop_VA_Q(ntryL,G1H32(89),ex2(:),G1H16(482),m3h2x16(:,535),heltab2x32(:,:,647))
  call Hloop_A_Q(ntryL,G1H16(482),34,nMT,G2H16(95),n2h16(757))
  call Hloop_VA_Q(ntryL,G1H32(90),ex2(:),G1H16(484),m3h2x16(:,536),heltab2x32(:,:,648))
  call Hloop_A_Q(ntryL,G1H16(484),34,nMT,G2H16(96),n2h16(758))
  call Hloop_AQ_V(ntryL,G1H32(91),ex1(:),G1H16(485),m3h2x16(:,537),heltab2x32(:,:,649))
  call Hloop_AQ_V(ntryL,G1H32(92),ex1(:),G1H16(486),m3h2x16(:,538),heltab2x32(:,:,650))
  call Hloop_AQ_V(ntryL,G1H32(93),ex1(:),G1H16(487),m3h2x16(:,539),heltab2x32(:,:,651))
  call Hloop_VQ_A(ntryL,G1H16(426),ex1(:),G1H8(361),m3h2x8(:,1317),heltab2x16(:,:,1611))
  call Hloop_Q_A(ntryL,G1H8(361),37,nMT,G2H8(373),n2h8(1631))
  call Hloop_QA_V(ntryL,G1H16(210),ex2(:),G1H8(362),m3h2x8(:,1318),heltab2x16(:,:,1612))
  call Hloop_QA_V(ntryL,G1H16(211),ex2(:),G1H8(368),m3h2x8(:,1319),heltab2x16(:,:,1613))
  call Hloop_QA_V(ntryL,G1H16(212),ex2(:),G1H8(371),m3h2x8(:,1320),heltab2x16(:,:,1614))
  call Hloop_QA_V(ntryL,G1H16(218),ex2(:),G1H8(372),m3h2x8(:,1321),heltab2x16(:,:,1615))
  call Hloop_QA_V(ntryL,G1H16(23),ex2(:),G1H8(373),m3h2x8(:,1322),heltab2x16(:,:,1616))
  call Hloop_QA_V(ntryL,G1H16(219),ex2(:),G1H8(379),m3h2x8(:,1323),heltab2x16(:,:,1617))
  call Hloop_AQ_V(ntryL,G1H16(221),ex1(:),G1H8(380),m3h2x8(:,1324),heltab2x16(:,:,1618))
  call Hloop_AQ_V(ntryL,G1H16(223),ex1(:),G1H8(383),m3h2x8(:,1325),heltab2x16(:,:,1619))
  call Hloop_AQ_V(ntryL,G1H16(227),ex1(:),G1H8(384),m3h2x8(:,1326),heltab2x16(:,:,1620))
  call Hloop_AQ_V(ntryL,G1H16(242),ex1(:),G1H8(390),m3h2x8(:,1327),heltab2x16(:,:,1621))
  call Hloop_AQ_V(ntryL,G1H16(243),ex1(:),G1H8(391),m3h2x8(:,1328),heltab2x16(:,:,1622))
  call Hloop_AQ_V(ntryL,G1H16(244),ex1(:),G1H8(392),m3h2x8(:,1329),heltab2x16(:,:,1623))
  call Hloop_AQ_V(ntryL,G1H16(252),ex1(:),G1H8(396),m3h2x8(:,1330),heltab2x16(:,:,1624))
  call Hloop_AQ_V(ntryL,G1H16(254),ex1(:),G1H8(401),m3h2x8(:,1331),heltab2x16(:,:,1625))
  call Hloop_AQ_V(ntryL,G1H16(29),ex1(:),G1H8(402),m3h2x8(:,1332),heltab2x16(:,:,1626))
  call Hloop_QA_V(ntryL,G1H8(844),ex2(:),G1H4(1399),m3h2x4(:,2293),heltab2x8(:,:,2762))
  call Hloop_AQ_V(ntryL,G1H8(862),ex1(:),G1H4(1402),m3h2x4(:,2294),heltab2x8(:,:,2763))
  call Hloop_AQ_V(ntryL,G1H8(885),ex1(:),G1H4(1403),m3h2x4(:,2295),heltab2x8(:,:,2764))
  call Hloop_VA_Q(ntryL,G1H32(94),ex2(:),G1H16(488),m3h2x16(:,540),heltab2x32(:,:,652))
  call Hloop_A_Q(ntryL,G1H16(488),34,nMT,G2H16(97),n2h16(759))
  call Hloop_VA_Q(ntryL,G1H32(95),ex2(:),G1H16(490),m3h2x16(:,541),heltab2x32(:,:,653))
  call Hloop_A_Q(ntryL,G1H16(490),34,nMT,G2H16(98),n2h16(760))
  call Hloop_VA_Q(ntryL,G1H32(96),ex2(:),G1H16(491),m3h2x16(:,542),heltab2x32(:,:,654))
  call Hloop_A_Q(ntryL,G1H16(491),34,nMT,G2H16(99),n2h16(761))
  call Hloop_QA_V(ntryL,G1H32(97),ex2(:),G1H16(492),m3h2x16(:,543),heltab2x32(:,:,655))
  call Hloop_QA_V(ntryL,G1H32(98),ex2(:),G1H16(493),m3h2x16(:,544),heltab2x32(:,:,656))
  call Hloop_QA_V(ntryL,G1H32(99),ex2(:),G1H16(494),m3h2x16(:,545),heltab2x32(:,:,657))
  call Hloop_GGG_G_12(ntryL,G1H32(100),ex4(:),ex3(:),G1H8(357),m4h2x2x8(:,10),heltab3x32(:,:,19))
  call Hloop_GGG_G_12(ntryL,G1H32(101),ex3(:),ex4(:),G1H8(358),m4h2x2x8(:,11),heltab3x32(:,:,20))
  call Hloop_GGG_G_23(ntryL,G1H32(102),ex4(:),ex3(:),G1H8(370),m4h2x2x8(:,12),heltab3x32(:,:,21))
  call Hloop_VQ_A(ntryL,G1H32(103),ex1(:),G1H16(496),m3h2x16(:,546),heltab2x32(:,:,658))
  call Hloop_Q_A(ntryL,G1H16(496),33,nMT,G2H16(100),n2h16(762))
  call Hloop_VQ_A(ntryL,G1H32(104),ex1(:),G1H16(497),m3h2x16(:,547),heltab2x32(:,:,659))
  call Hloop_Q_A(ntryL,G1H16(497),33,nMT,G2H16(101),n2h16(763))
  call Hloop_VQ_A(ntryL,G1H32(105),ex1(:),G1H16(498),m3h2x16(:,548),heltab2x32(:,:,660))
  call Hloop_Q_A(ntryL,G1H16(498),33,nMT,G2H16(102),n2h16(764))
  call Hloop_AQ_V(ntryL,G1H32(106),ex1(:),G1H16(499),m3h2x16(:,549),heltab2x32(:,:,661))
  call Hloop_AQ_V(ntryL,G1H32(107),ex1(:),G1H16(500),m3h2x16(:,550),heltab2x32(:,:,662))
  call Hloop_AQ_V(ntryL,G1H32(108),ex1(:),G1H16(502),m3h2x16(:,551),heltab2x32(:,:,663))
  call Hloop_GGG_G_12(ntryL,G1H32(113),ex4(:),ex3(:),G1H8(375),m4h2x2x8(:,13),heltab3x32(:,:,22))
  call Hloop_GGG_G_12(ntryL,G1H32(110),ex3(:),ex4(:),G1H8(376),m4h2x2x8(:,14),heltab3x32(:,:,23))
  call Hloop_GGG_G_23(ntryL,G1H32(115),ex4(:),ex3(:),G1H8(382),m4h2x2x8(:,15),heltab3x32(:,:,24))
  call Hloop_QA_V(ntryL,G1H16(255),ex2(:),G1H8(393),m3h2x8(:,1333),heltab2x16(:,:,1627))
  call Hloop_QA_V(ntryL,G1H16(257),ex2(:),G1H8(394),m3h2x8(:,1334),heltab2x16(:,:,1628))
  call Hloop_QA_V(ntryL,G1H16(258),ex2(:),G1H8(400),m3h2x8(:,1335),heltab2x16(:,:,1629))
  call Hloop_GGG_G_12(ntryL,G0H16(217),ex4(:),ex3(:),G0H4(1),m4h2x2x4(:,58),heltab3x16(:,:,58))
  call Hloop_GGG_G_12(ntryL,G0H16(218),ex3(:),ex4(:),G0H4(2),m4h2x2x4(:,59),heltab3x16(:,:,59))
  call Hloop_GGG_G_23(ntryL,G0H16(219),ex4(:),ex3(:),G0H4(3),m4h2x2x4(:,60),heltab3x16(:,:,60))
  call Hloop_QA_V(ntryL,G1H16(30),ex2(:),G1H8(411),m3h2x8(:,1336),heltab2x16(:,:,1630))
  call Hloop_QA_V(ntryL,G1H16(260),ex2(:),G1H8(436),m3h2x8(:,1337),heltab2x16(:,:,1631))
  call Hloop_QA_V(ntryL,G1H16(262),ex2(:),G1H8(435),m3h2x8(:,1338),heltab2x16(:,:,1632))
  call Hloop_AQ_V(ntryL,G1H16(263),ex1(:),G1H8(447),m3h2x8(:,1339),heltab2x16(:,:,1633))
  call Hloop_AQ_V(ntryL,G1H16(264),ex1(:),G1H8(448),m3h2x8(:,1340),heltab2x16(:,:,1634))
  call Hloop_AQ_V(ntryL,G1H16(265),ex1(:),G1H8(484),m3h2x8(:,1341),heltab2x16(:,:,1635))
  call Hloop_GGG_G_12(ntryL,G0H16(220),ex4(:),ex3(:),G0H4(4),m4h2x2x4(:,61),heltab3x16(:,:,61))
  call Hloop_GGG_G_12(ntryL,G0H16(221),ex3(:),ex4(:),G0H4(5),m4h2x2x4(:,62),heltab3x16(:,:,62))
  call Hloop_GGG_G_23(ntryL,G0H16(222),ex4(:),ex3(:),G0H4(6),m4h2x2x4(:,63),heltab3x16(:,:,63))
  call Hloop_AQ_V(ntryL,G1H16(267),ex1(:),G1H8(471),m3h2x8(:,1342),heltab2x16(:,:,1636))
  call Hloop_AQ_V(ntryL,G1H16(268),ex1(:),G1H8(490),m3h2x8(:,1343),heltab2x16(:,:,1637))
  call Hloop_AQ_V(ntryL,G1H16(269),ex1(:),G1H8(483),m3h2x8(:,1344),heltab2x16(:,:,1638))
  call Hloop_AQ_V(ntryL,G1H16(33),ex1(:),G1H8(507),m3h2x8(:,1345),heltab2x16(:,:,1639))
  call Hloop_AQ_V(ntryL,G1H16(281),ex1(:),G1H8(508),m3h2x8(:,1346),heltab2x16(:,:,1640))
  call Hloop_AQ_V(ntryL,G1H16(285),ex1(:),G1H8(404),m3h2x8(:,1347),heltab2x16(:,:,1641))
  call Hloop_QA_V(ntryL,G1H8(142),ex2(:),G1H4(1404),m3h2x4(:,2296),heltab2x8(:,:,2765))
  call Hloop_AQ_V(ntryL,G1H8(153),ex1(:),G1H4(1409),m3h2x4(:,2297),heltab2x8(:,:,2766))
  call Hloop_AQ_V(ntryL,G1H8(177),ex1(:),G1H4(1414),m3h2x4(:,2298),heltab2x8(:,:,2767))
  call Hloop_AQ_V(ntryL,G1H32(112),ex1(:),G1H16(503),m3h2x16(:,552),heltab2x32(:,:,664))
  call Hloop_AQ_V(ntryL,G1H32(114),ex1(:),G1H16(504),m3h2x16(:,553),heltab2x32(:,:,665))
  call Hloop_AQ_V(ntryL,G1H32(116),ex1(:),G1H16(505),m3h2x16(:,554),heltab2x32(:,:,666))
  call Hloop_VQ_A(ntryL,G1H32(117),ex1(:),G1H16(506),m3h2x16(:,555),heltab2x32(:,:,667))
  call Hloop_Q_A(ntryL,G1H16(506),33,nMT,G2H16(103),n2h16(765))
  call Hloop_VQ_A(ntryL,G1H32(118),ex1(:),G1H16(508),m3h2x16(:,556),heltab2x32(:,:,668))
  call Hloop_Q_A(ntryL,G1H16(508),33,nMT,G2H16(104),n2h16(766))
  call Hloop_VQ_A(ntryL,G1H32(119),ex1(:),G1H16(509),m3h2x16(:,557),heltab2x32(:,:,669))
  call Hloop_Q_A(ntryL,G1H16(509),33,nMT,G2H16(105),n2h16(767))
  call Hloop_QA_V(ntryL,G1H32(124),ex2(:),G1H16(510),m3h2x16(:,558),heltab2x32(:,:,670))
  call Hloop_QA_V(ntryL,G1H32(121),ex2(:),G1H16(511),m3h2x16(:,559),heltab2x32(:,:,671))
  call Hloop_QA_V(ntryL,G1H32(126),ex2(:),G1H16(512),m3h2x16(:,560),heltab2x32(:,:,672))
  call Hloop_VA_Q(ntryL,G1H32(123),ex2(:),G1H16(514),m3h2x16(:,561),heltab2x32(:,:,673))
  call Hloop_A_Q(ntryL,G1H16(514),34,nMT,G2H16(106),n2h16(768))
  call Hloop_VA_Q(ntryL,G1H32(125),ex2(:),G1H16(515),m3h2x16(:,562),heltab2x32(:,:,674))
  call Hloop_A_Q(ntryL,G1H16(515),34,nMT,G2H16(107),n2h16(769))
  call Hloop_VA_Q(ntryL,G1H32(127),ex2(:),G1H16(516),m3h2x16(:,563),heltab2x32(:,:,675))
  call Hloop_A_Q(ntryL,G1H16(516),34,nMT,G2H16(108),n2h16(770))
  call Hloop_AQ_V(ntryL,G1H32(128),ex1(:),G1H16(517),m3h2x16(:,564),heltab2x32(:,:,676))
  call Hloop_AQ_V(ntryL,G1H32(129),ex1(:),G1H16(518),m3h2x16(:,565),heltab2x32(:,:,677))
  call Hloop_AQ_V(ntryL,G1H32(130),ex1(:),G1H16(520),m3h2x16(:,566),heltab2x32(:,:,678))
  call Hloop_VQ_A(ntryL,G1H32(135),ex1(:),G1H16(521),m3h2x16(:,567),heltab2x32(:,:,679))
  call Hloop_Q_A(ntryL,G1H16(521),33,nMT,G2H16(109),n2h16(771))
  call Hloop_VQ_A(ntryL,G1H32(132),ex1(:),G1H16(522),m3h2x16(:,568),heltab2x32(:,:,680))
  call Hloop_Q_A(ntryL,G1H16(522),33,nMT,G2H16(110),n2h16(772))
  call Hloop_VQ_A(ntryL,G1H32(137),ex1(:),G1H16(523),m3h2x16(:,569),heltab2x32(:,:,681))
  call Hloop_Q_A(ntryL,G1H16(523),33,nMT,G2H16(111),n2h16(773))
  call Hloop_AV_Q(ntryL,G1H32(140),wf4(:,2),G1H8(409),m3h4x8(:,113),heltab2x32(:,:,682))
  call Hloop_A_Q(ntryL,G1H8(409),44,0,G2H8(401),n2h8(1632))
  call Hloop_AV_Q(ntryL,G1H32(136),wf4(:,2),G1H8(413),m3h4x8(:,114),heltab2x32(:,:,683))
  call Hloop_A_Q(ntryL,G1H8(413),44,nMT,G2H8(403),n2h8(1633))
  call Hloop_QV_A(ntryL,G1H32(146),wf4(:,2),G1H8(416),m3h4x8(:,115),heltab2x32(:,:,684))
  call Hloop_Q_A(ntryL,G1H8(416),44,0,G2H8(404),n2h8(1634))
  call Hloop_QV_A(ntryL,G1H32(139),wf4(:,2),G1H8(419),m3h4x8(:,116),heltab2x32(:,:,685))
  call Hloop_Q_A(ntryL,G1H8(419),44,nMT,G2H8(405),n2h8(1635))
  call Hloop_AV_Q(ntryL,G1H32(141),wf4(:,2),G1H8(420),m3h4x8(:,117),heltab2x32(:,:,686))
  call Hloop_A_Q(ntryL,G1H8(420),44,nMB,G2H8(408),n2h8(1636))
  call Hloop_QV_A(ntryL,G1H32(143),wf4(:,2),G1H8(433),m3h4x8(:,118),heltab2x32(:,:,687))
  call Hloop_Q_A(ntryL,G1H8(433),44,nMB,G2H8(409),n2h8(1637))
  call Hloop_DV_C(ntryL,G1H32(148),32,wf4(:,2),G2H8(410),m3h4x8(:,119),heltab2x32(:,:,688))
  call Hloop_CV_D(ntryL,G1H32(145),32,wf4(:,2),12,G2H8(413),m3h4x8(:,120),heltab2x32(:,:,689))
  call Hloop_UV_W(ntryL,G1H32(147),32,wf4(:,2),12,G2H8(414),m3h4x8(:,121),heltab2x32(:,:,690))
  call Hloop_AV_Q(ntryL,G1H32(157),wf4(:,1),G1H8(428),m3h4x8(:,122),heltab2x32(:,:,691))
  call Hloop_A_Q(ntryL,G1H8(428),35,0,G2H8(415),n2h8(1638))
  call Hloop_AV_Q(ntryL,G1H32(150),wf4(:,1),G1H8(431),m3h4x8(:,123),heltab2x32(:,:,692))
  call Hloop_A_Q(ntryL,G1H8(431),35,nMT,G2H8(417),n2h8(1639))
  call Hloop_QV_A(ntryL,G1H32(159),wf4(:,1),G1H8(432),m3h4x8(:,124),heltab2x32(:,:,693))
  call Hloop_Q_A(ntryL,G1H8(432),35,0,G2H8(418),n2h8(1640))
  call Hloop_QV_A(ntryL,G1H32(152),wf4(:,1),G1H8(439),m3h4x8(:,125),heltab2x32(:,:,694))
  call Hloop_Q_A(ntryL,G1H8(439),35,nMT,G2H8(419),n2h8(1641))
  call Hloop_AV_Q(ntryL,G1H32(154),wf4(:,1),G1H8(440),m3h4x8(:,126),heltab2x32(:,:,695))
  call Hloop_A_Q(ntryL,G1H8(440),35,nMB,G2H8(422),n2h8(1642))
  call Hloop_QV_A(ntryL,G1H32(156),wf4(:,1),G1H8(445),m3h4x8(:,127),heltab2x32(:,:,696))
  call Hloop_Q_A(ntryL,G1H8(445),35,nMB,G2H8(423),n2h8(1643))
  call Hloop_DV_C(ntryL,G1H32(158),32,wf4(:,1),G2H8(425),m3h4x8(:,128),heltab2x32(:,:,697))
  call Hloop_CV_D(ntryL,G1H32(160),32,wf4(:,1),3,G2H8(427),m3h4x8(:,129),heltab2x32(:,:,698))
  call Hloop_UV_W(ntryL,G1H32(161),32,wf4(:,1),3,G2H8(428),m3h4x8(:,130),heltab2x32(:,:,699))
  call Hloop_QV_A(ntryL,G1H32(170),wf4(:,1),G1H8(451),m3h4x8(:,131),heltab2x32(:,:,700))
  call Hloop_Q_A(ntryL,G1H8(451),35,0,G2H8(429),n2h8(1644))
  call Hloop_QV_A(ntryL,G1H32(163),wf4(:,1),G1H8(452),m3h4x8(:,132),heltab2x32(:,:,701))
  call Hloop_Q_A(ntryL,G1H8(452),35,nMT,G2H8(432),n2h8(1645))
  call Hloop_AV_Q(ntryL,G1H32(169),wf4(:,1),G1H8(455),m3h4x8(:,133),heltab2x32(:,:,702))
  call Hloop_A_Q(ntryL,G1H8(455),35,0,G2H8(433),n2h8(1646))
  call Hloop_AV_Q(ntryL,G1H32(165),wf4(:,1),G1H8(519),m3h4x8(:,134),heltab2x32(:,:,703))
  call Hloop_A_Q(ntryL,G1H8(519),35,nMT,G2H8(434),n2h8(1647))
  call Hloop_QV_A(ntryL,G1H32(167),wf4(:,1),G1H8(808),m3h4x8(:,135),heltab2x32(:,:,704))
  call Hloop_Q_A(ntryL,G1H8(808),35,nMB,G2H8(437),n2h8(1648))
  call Hloop_AV_Q(ntryL,G1H32(171),wf4(:,1),G1H8(664),m3h4x8(:,136),heltab2x32(:,:,705))
  call Hloop_A_Q(ntryL,G1H8(664),35,nMB,G2H8(438),n2h8(1649))
  call Hloop_CV_D(ntryL,G1H32(172),32,wf4(:,1),3,G2H8(439),m3h4x8(:,137),heltab2x32(:,:,706))
  call Hloop_DV_C(ntryL,G1H32(173),32,wf4(:,1),G2H8(441),m3h4x8(:,138),heltab2x32(:,:,707))
  call Hloop_UV_W(ntryL,G1H32(174),32,wf4(:,1),3,G2H8(442),m3h4x8(:,139),heltab2x32(:,:,708))
  call Hloop_QV_A(ntryL,G1H32(180),ex4(:),G1H16(524),m3h2x16(:,570),heltab2x32(:,:,709))
  call Hloop_Q_A(ntryL,G1H16(524),40,0,G2H16(112),n2h16(774))
  call Hloop_QV_A(ntryL,G1H32(176),ex4(:),G1H16(526),m3h2x16(:,571),heltab2x32(:,:,710))
  call Hloop_Q_A(ntryL,G1H16(526),40,nMT,G2H16(113),n2h16(775))
  call Hloop_AV_Q(ntryL,G1H32(183),ex4(:),G1H16(527),m3h2x16(:,572),heltab2x32(:,:,711))
  call Hloop_A_Q(ntryL,G1H16(527),40,0,G2H16(114),n2h16(776))
  call Hloop_AV_Q(ntryL,G1H32(178),ex4(:),G1H16(528),m3h2x16(:,573),heltab2x32(:,:,712))
  call Hloop_A_Q(ntryL,G1H16(528),40,nMT,G2H16(115),n2h16(777))
  call Hloop_QV_A(ntryL,G1H32(182),ex4(:),G1H16(529),m3h2x16(:,574),heltab2x32(:,:,713))
  call Hloop_Q_A(ntryL,G1H16(529),40,nMB,G2H16(116),n2h16(778))
  call Hloop_AV_Q(ntryL,G1H32(184),ex4(:),G1H16(530),m3h2x16(:,575),heltab2x32(:,:,714))
  call Hloop_A_Q(ntryL,G1H16(530),40,nMB,G2H16(117),n2h16(779))
  call Hloop_CV_D(ntryL,G1H32(185),32,ex4(:),8,G2H16(118),m3h2x16(:,576),heltab2x32(:,:,715))
  call Hloop_DV_C(ntryL,G1H32(190),32,ex4(:),G2H16(119),m3h2x16(:,577),heltab2x32(:,:,716))
  call Hloop_UV_W(ntryL,G1H32(187),32,ex4(:),8,G2H16(120),m3h2x16(:,578),heltab2x32(:,:,717))
  call Hloop_AV_Q(ntryL,G1H32(194),wf4(:,1),G1H8(543),m3h4x8(:,140),heltab2x32(:,:,718))
  call Hloop_A_Q(ntryL,G1H8(543),35,0,G2H8(443),n2h8(1650))
  call Hloop_AV_Q(ntryL,G1H32(189),wf4(:,1),G1H8(670),m3h4x8(:,141),heltab2x32(:,:,719))
  call Hloop_A_Q(ntryL,G1H8(670),35,nMT,G2H8(446),n2h8(1651))
  call Hloop_QV_A(ntryL,G1H32(196),wf4(:,1),G1H8(556),m3h4x8(:,142),heltab2x32(:,:,720))
  call Hloop_Q_A(ntryL,G1H8(556),35,0,G2H8(447),n2h8(1652))
  call Hloop_QV_A(ntryL,G1H32(193),wf4(:,1),G1H8(580),m3h4x8(:,143),heltab2x32(:,:,721))
  call Hloop_Q_A(ntryL,G1H8(580),35,nMT,G2H8(449),n2h8(1653))
  call Hloop_AV_Q(ntryL,G1H32(195),wf4(:,1),G1H8(682),m3h4x8(:,144),heltab2x32(:,:,722))
  call Hloop_A_Q(ntryL,G1H8(682),35,nMB,G2H8(451),n2h8(1654))
  call Hloop_QV_A(ntryL,G1H32(201),wf4(:,1),G1H8(591),m3h4x8(:,145),heltab2x32(:,:,723))
  call Hloop_Q_A(ntryL,G1H8(591),35,nMB,G2H8(452),n2h8(1655))
  call Hloop_DV_C(ntryL,G1H32(198),32,wf4(:,1),G2H8(453),m3h4x8(:,146),heltab2x32(:,:,724))
  call Hloop_CV_D(ntryL,G1H32(203),32,wf4(:,1),3,G2H8(455),m3h4x8(:,147),heltab2x32(:,:,725))
  call Hloop_UV_W(ntryL,G1H32(200),32,wf4(:,1),3,G2H8(456),m3h4x8(:,148),heltab2x32(:,:,726))
  call Hloop_QV_A(ntryL,G1H32(207),wf4(:,1),G1H8(634),m3h4x8(:,149),heltab2x32(:,:,727))
  call Hloop_Q_A(ntryL,G1H8(634),35,0,G2H8(457),n2h8(1656))
  call Hloop_QV_A(ntryL,G1H32(204),wf4(:,1),G1H8(615),m3h4x8(:,150),heltab2x32(:,:,728))
  call Hloop_Q_A(ntryL,G1H8(615),35,nMT,G2H8(460),n2h8(1657))
  call Hloop_AV_Q(ntryL,G1H32(209),wf4(:,1),G1H8(633),m3h4x8(:,151),heltab2x32(:,:,729))
  call Hloop_A_Q(ntryL,G1H8(633),35,0,G2H8(461),n2h8(1658))
  call Hloop_AV_Q(ntryL,G1H32(206),wf4(:,1),G1H8(646),m3h4x8(:,152),heltab2x32(:,:,730))
  call Hloop_A_Q(ntryL,G1H8(646),35,nMT,G2H8(462),n2h8(1659))
  call Hloop_QV_A(ntryL,G1H32(212),wf4(:,1),G1H8(651),m3h4x8(:,153),heltab2x32(:,:,731))
  call Hloop_Q_A(ntryL,G1H8(651),35,nMB,G2H8(465),n2h8(1660))
  call Hloop_AV_Q(ntryL,G1H32(214),wf4(:,1),G1H8(699),m3h4x8(:,154),heltab2x32(:,:,732))
  call Hloop_A_Q(ntryL,G1H8(699),35,nMB,G2H8(466),n2h8(1661))
  call Hloop_CV_D(ntryL,G1H32(211),32,wf4(:,1),3,G2H8(467),m3h4x8(:,155),heltab2x32(:,:,733))
  call Hloop_DV_C(ntryL,G1H32(213),32,wf4(:,1),G2H8(469),m3h4x8(:,156),heltab2x32(:,:,734))
  call Hloop_UV_W(ntryL,G1H32(215),32,wf4(:,1),3,G2H8(470),m3h4x8(:,157),heltab2x32(:,:,735))
  call Hloop_QV_A(ntryL,G1H32(220),ex3(:),G1H16(532),m3h2x16(:,579),heltab2x32(:,:,736))
  call Hloop_Q_A(ntryL,G1H16(532),36,0,G2H16(121),n2h16(780))
  call Hloop_QV_A(ntryL,G1H32(217),ex3(:),G1H16(533),m3h2x16(:,580),heltab2x32(:,:,737))
  call Hloop_Q_A(ntryL,G1H16(533),36,nMT,G2H16(122),n2h16(781))
  call Hloop_AV_Q(ntryL,G1H32(222),ex3(:),G1H16(534),m3h2x16(:,581),heltab2x32(:,:,738))
  call Hloop_A_Q(ntryL,G1H16(534),36,0,G2H16(123),n2h16(782))
  call Hloop_AV_Q(ntryL,G1H32(223),ex3(:),G1H16(535),m3h2x16(:,582),heltab2x32(:,:,739))
  call Hloop_A_Q(ntryL,G1H16(535),36,nMT,G2H16(124),n2h16(783))
  call Hloop_QV_A(ntryL,G1H32(225),ex3(:),G1H16(536),m3h2x16(:,583),heltab2x32(:,:,740))
  call Hloop_Q_A(ntryL,G1H16(536),36,nMB,G2H16(125),n2h16(784))
  call Hloop_AV_Q(ntryL,G1H32(224),ex3(:),G1H16(538),m3h2x16(:,584),heltab2x32(:,:,741))
  call Hloop_A_Q(ntryL,G1H16(538),36,nMB,G2H16(126),n2h16(785))
  call Hloop_CV_D(ntryL,G1H32(226),32,ex3(:),4,G2H16(127),m3h2x16(:,585),heltab2x32(:,:,742))
  call Hloop_DV_C(ntryL,G1H32(227),32,ex3(:),G2H16(128),m3h2x16(:,586),heltab2x32(:,:,743))
  call Hloop_UV_W(ntryL,G1H32(228),32,ex3(:),4,G2H16(129),m3h2x16(:,587),heltab2x32(:,:,744))
  call Hloop_AV_Q(ntryL,G1H32(233),wf4(:,1),G1H8(469),m3h4x8(:,158),heltab2x32(:,:,745))
  call Hloop_A_Q(ntryL,G1H8(469),35,0,G2H8(471),n2h8(1662))
  call Hloop_AV_Q(ntryL,G1H32(234),wf4(:,1),G1H8(700),m3h4x8(:,159),heltab2x32(:,:,746))
  call Hloop_A_Q(ntryL,G1H8(700),35,nMT,G2H8(474),n2h8(1663))
  call Hloop_QV_A(ntryL,G1H32(237),wf4(:,1),G1H8(463),m3h4x8(:,160),heltab2x32(:,:,747))
  call Hloop_Q_A(ntryL,G1H8(463),35,0,G2H8(475),n2h8(1664))
  call Hloop_QV_A(ntryL,G1H32(236),wf4(:,1),G1H8(464),m3h4x8(:,161),heltab2x32(:,:,748))
  call Hloop_Q_A(ntryL,G1H8(464),35,nMT,G2H8(476),n2h8(1665))
  call Hloop_AV_Q(ntryL,G1H32(235),wf4(:,1),G1H8(473),m3h4x8(:,162),heltab2x32(:,:,749))
  call Hloop_A_Q(ntryL,G1H8(473),35,nMB,G2H8(478),n2h8(1666))
  call Hloop_QV_A(ntryL,G1H32(238),wf4(:,1),G1H8(474),m3h4x8(:,163),heltab2x32(:,:,750))
  call Hloop_Q_A(ntryL,G1H8(474),35,nMB,G2H8(479),n2h8(1667))
  call Hloop_DV_C(ntryL,G1H32(239),32,wf4(:,1),G2H8(480),m3h4x8(:,164),heltab2x32(:,:,751))
  call Hloop_CV_D(ntryL,G1H32(240),32,wf4(:,1),3,G2H8(482),m3h4x8(:,165),heltab2x32(:,:,752))
  call Hloop_UV_W(ntryL,G1H32(241),32,wf4(:,1),3,G2H8(483),m3h4x8(:,166),heltab2x32(:,:,753))
  call Hloop_QV_A(ntryL,G1H32(246),wf4(:,1),G1H8(475),m3h4x8(:,167),heltab2x32(:,:,754))
  call Hloop_Q_A(ntryL,G1H8(475),35,0,G2H8(485),n2h8(1668))
  call Hloop_QV_A(ntryL,G1H32(243),wf4(:,1),G1H8(486),m3h4x8(:,168),heltab2x32(:,:,755))
  call Hloop_Q_A(ntryL,G1H8(486),35,nMT,G2H8(487),n2h8(1669))
  call Hloop_AV_Q(ntryL,G1H32(248),wf4(:,1),G1H8(499),m3h4x8(:,169),heltab2x32(:,:,756))
  call Hloop_A_Q(ntryL,G1H8(499),35,0,G2H8(488),n2h8(1670))
  call Hloop_AV_Q(ntryL,G1H32(245),wf4(:,1),G1H8(488),m3h4x8(:,170),heltab2x32(:,:,757))
  call Hloop_A_Q(ntryL,G1H8(488),35,nMT,G2H8(489),n2h8(1671))
  call Hloop_QV_A(ntryL,G1H32(247),wf4(:,1),G1H8(494),m3h4x8(:,171),heltab2x32(:,:,758))
  call Hloop_Q_A(ntryL,G1H8(494),35,nMB,G2H8(491),n2h8(1672))
  call Hloop_AV_Q(ntryL,G1H32(249),wf4(:,1),G1H8(505),m3h4x8(:,172),heltab2x32(:,:,759))
  call Hloop_A_Q(ntryL,G1H8(505),35,nMB,G2H8(492),n2h8(1673))
  call Hloop_CV_D(ntryL,G1H32(250),32,wf4(:,1),3,G2H8(493),m3h4x8(:,173),heltab2x32(:,:,760))
  call Hloop_DV_C(ntryL,G1H32(251),32,wf4(:,1),G2H8(496),m3h4x8(:,174),heltab2x32(:,:,761))
  call Hloop_UV_W(ntryL,G1H32(252),32,wf4(:,1),3,G2H8(497),m3h4x8(:,175),heltab2x32(:,:,762))
  call Hloop_QV_A(ntryL,G1H16(111),wf4(:,1),G1H4(1410),m3h4x4(:,295),heltab2x16(:,:,1642))
  call Hloop_Q_A(ntryL,G1H4(1410),43,0,G2H4(1198),n2h4(2139))
  call Hloop_QV_A(ntryL,G1H16(116),wf4(:,1),G1H4(1413),m3h4x4(:,296),heltab2x16(:,:,1643))
  call Hloop_Q_A(ntryL,G1H4(1413),43,nMT,G2H4(1201),n2h4(2140))
  call Hloop_AV_Q(ntryL,G1H16(194),wf4(:,1),G1H4(1415),m3h4x4(:,297),heltab2x16(:,:,1644))
  call Hloop_A_Q(ntryL,G1H4(1415),43,0,G2H4(1202),n2h4(2141))
  call Hloop_AV_Q(ntryL,G1H16(167),wf4(:,1),G1H4(1418),m3h4x4(:,298),heltab2x16(:,:,1645))
  call Hloop_A_Q(ntryL,G1H4(1418),43,nMT,G2H4(1203),n2h4(2142))
  call Hloop_QV_A(ntryL,G1H16(60),wf4(:,1),G1H4(1419),m3h4x4(:,299),heltab2x16(:,:,1646))
  call Hloop_Q_A(ntryL,G1H4(1419),43,nMB,G2H4(1206),n2h4(2143))
  call Hloop_AV_Q(ntryL,G1H16(199),wf4(:,1),G1H4(1420),m3h4x4(:,300),heltab2x16(:,:,1647))
  call Hloop_A_Q(ntryL,G1H4(1420),43,nMB,G2H4(1207),n2h4(2144))
  call Hloop_CV_D(ntryL,G1H16(49),40,wf4(:,1),3,G2H4(1208),m3h4x4(:,301),heltab2x16(:,:,1648))
  call Hloop_DV_C(ntryL,G1H16(225),40,wf4(:,1),G2H4(1211),m3h4x4(:,302),heltab2x16(:,:,1649))
  call Hloop_AV_Q(ntryL,G1H16(117),wf4(:,1),G1H4(1423),m3h4x4(:,303),heltab2x16(:,:,1650))
  call Hloop_A_Q(ntryL,G1H4(1423),51,0,G2H4(1212),n2h4(2145))
  call Hloop_AV_Q(ntryL,G1H16(8),wf4(:,1),G1H4(1424),m3h4x4(:,304),heltab2x16(:,:,1651))
  call Hloop_A_Q(ntryL,G1H4(1424),51,nMT,G2H4(1213),n2h4(2146))
  call Hloop_QV_A(ntryL,G1H16(148),wf4(:,1),G1H4(14),m3h4x4(:,305),heltab2x16(:,:,1652))
  call Hloop_Q_A(ntryL,G1H4(14),51,0,G2H4(1216),n2h4(2147))
  call Hloop_QV_A(ntryL,G1H16(114),wf4(:,1),G1H4(15),m3h4x4(:,306),heltab2x16(:,:,1653))
  call Hloop_Q_A(ntryL,G1H4(15),51,nMT,G2H4(1217),n2h4(2148))
  call Hloop_AV_Q(ntryL,G1H16(11),wf4(:,1),G1H4(1427),m3h4x4(:,307),heltab2x16(:,:,1654))
  call Hloop_A_Q(ntryL,G1H4(1427),51,nMB,G2H4(1218),n2h4(2149))
  call Hloop_QV_A(ntryL,G1H16(151),wf4(:,1),G1H4(1428),m3h4x4(:,308),heltab2x16(:,:,1655))
  call Hloop_Q_A(ntryL,G1H4(1428),51,nMB,G2H4(1221),n2h4(2150))
  call Hloop_DV_C(ntryL,G1H16(47),48,wf4(:,1),G2H4(1222),m3h4x4(:,309),heltab2x16(:,:,1656))
  call Hloop_CV_D(ntryL,G1H16(48),48,wf4(:,1),3,G2H4(1223),m3h4x4(:,310),heltab2x16(:,:,1657))
  call Hloop_QV_A(ntryL,G1H16(66),wf4(:,1),G1H4(17),m3h4x4(:,311),heltab2x16(:,:,1658))
  call Hloop_Q_A(ntryL,G1H4(17),51,0,G2H4(1226),n2h4(2151))
  call Hloop_QV_A(ntryL,G1H16(55),wf4(:,1),G1H4(18),m3h4x4(:,312),heltab2x16(:,:,1659))
  call Hloop_Q_A(ntryL,G1H4(18),51,nMT,G2H4(1227),n2h4(2152))
  call Hloop_AV_Q(ntryL,G1H16(70),wf4(:,1),G1H4(1431),m3h4x4(:,313),heltab2x16(:,:,1660))
  call Hloop_A_Q(ntryL,G1H4(1431),51,0,G2H4(1228),n2h4(2153))
  call Hloop_AV_Q(ntryL,G1H16(62),wf4(:,1),G1H4(1432),m3h4x4(:,314),heltab2x16(:,:,1661))
  call Hloop_A_Q(ntryL,G1H4(1432),51,nMT,G2H4(1231),n2h4(2154))
  call Hloop_QV_A(ntryL,G1H16(68),wf4(:,1),G1H4(184),m3h4x4(:,315),heltab2x16(:,:,1662))
  call Hloop_Q_A(ntryL,G1H4(184),51,nMB,G2H4(1232),n2h4(2155))
  call Hloop_AV_Q(ntryL,G1H16(1),wf4(:,1),G1H4(1435),m3h4x4(:,316),heltab2x16(:,:,1663))
  call Hloop_A_Q(ntryL,G1H4(1435),51,nMB,G2H4(1233),n2h4(2156))
  call Hloop_CV_D(ntryL,G1H16(76),48,wf4(:,1),3,G2H4(1236),m3h4x4(:,317),heltab2x16(:,:,1664))
  call Hloop_DV_C(ntryL,G1H16(78),48,wf4(:,1),G2H4(1237),m3h4x4(:,318),heltab2x16(:,:,1665))
  call Hloop_AV_Q(ntryL,G1H16(100),ex3(:),G1H8(506),m3h2x8(:,1348),heltab2x16(:,:,1666))
  call Hloop_A_Q(ntryL,G1H8(506),52,0,G2H8(498),n2h8(1674))
  call Hloop_AV_Q(ntryL,G1H16(88),ex3(:),G1H8(509),m3h2x8(:,1349),heltab2x16(:,:,1667))
  call Hloop_A_Q(ntryL,G1H8(509),52,nMT,G2H8(501),n2h8(1675))
  call Hloop_QV_A(ntryL,G1H16(3),ex3(:),G1H8(510),m3h2x8(:,1350),heltab2x16(:,:,1668))
  call Hloop_Q_A(ntryL,G1H8(510),52,0,G2H8(502),n2h8(1676))
  call Hloop_QV_A(ntryL,G1H16(93),ex3(:),G1H8(521),m3h2x8(:,1351),heltab2x16(:,:,1669))
  call Hloop_Q_A(ntryL,G1H8(521),52,nMT,G2H8(503),n2h8(1677))
  call Hloop_AV_Q(ntryL,G1H16(105),ex3(:),G1H8(530),m3h2x8(:,1352),heltab2x16(:,:,1670))
  call Hloop_A_Q(ntryL,G1H8(530),52,nMB,G2H8(505),n2h8(1678))
  call Hloop_QV_A(ntryL,G1H16(108),ex3(:),G1H8(524),m3h2x8(:,1353),heltab2x16(:,:,1671))
  call Hloop_Q_A(ntryL,G1H8(524),52,nMB,G2H8(506),n2h8(1679))
  call Hloop_DV_C(ntryL,G1H16(110),48,ex3(:),G2H8(507),m3h2x8(:,1354),heltab2x16(:,:,1672))
  call Hloop_CV_D(ntryL,G1H16(115),48,ex3(:),4,G2H8(510),m3h2x8(:,1355),heltab2x16(:,:,1673))
  call Hloop_QV_A(ntryL,G1H32(257),wf8(:,2),G1H4(1436),m3h8x4(:,1),heltab2x32(:,:,763))
  call Hloop_Q_A(ntryL,G1H4(1436),39,0,G2H4(1238),n2h4(2157))
  call Hloop_QV_A(ntryL,G1H32(254),wf8(:,2),G1H4(1437),m3h8x4(:,2),heltab2x32(:,:,764))
  call Hloop_Q_A(ntryL,G1H4(1437),39,nMT,G2H4(1241),n2h4(2158))
  call Hloop_AV_Q(ntryL,G1H32(259),wf8(:,2),G1H4(1440),m3h8x4(:,3),heltab2x32(:,:,765))
  call Hloop_A_Q(ntryL,G1H4(1440),39,0,G2H4(1242),n2h4(2159))
  call Hloop_AV_Q(ntryL,G1H32(256),wf8(:,2),G1H4(1441),m3h8x4(:,4),heltab2x32(:,:,766))
  call Hloop_A_Q(ntryL,G1H4(1441),39,nMT,G2H4(1243),n2h4(2160))
  call Hloop_QV_A(ntryL,G1H32(258),wf8(:,2),G1H4(220),m3h8x4(:,5),heltab2x32(:,:,767))
  call Hloop_Q_A(ntryL,G1H4(220),39,nMB,G2H4(1246),n2h4(2161))
  call Hloop_AV_Q(ntryL,G1H32(260),wf8(:,2),G1H4(1444),m3h8x4(:,6),heltab2x32(:,:,768))
  call Hloop_A_Q(ntryL,G1H4(1444),39,nMB,G2H4(1247),n2h4(2162))
  call Hloop_CV_D(ntryL,G1H32(261),32,wf8(:,2),7,G2H4(1248),m3h8x4(:,7),heltab2x32(:,:,769))
  call Hloop_DV_C(ntryL,G1H32(262),32,wf8(:,2),G2H4(1251),m3h8x4(:,8),heltab2x32(:,:,770))
  call Hloop_UV_W(ntryL,G1H32(263),32,wf8(:,2),7,G2H4(1252),m3h8x4(:,9),heltab2x32(:,:,771))
  call Hloop_AV_Q(ntryL,G1H32(268),wf8(:,2),G1H4(1445),m3h8x4(:,10),heltab2x32(:,:,772))
  call Hloop_A_Q(ntryL,G1H4(1445),39,0,G2H4(1253),n2h4(2163))
  call Hloop_AV_Q(ntryL,G1H32(265),wf8(:,2),G1H4(1446),m3h8x4(:,11),heltab2x32(:,:,773))
  call Hloop_A_Q(ntryL,G1H4(1446),39,nMT,G2H4(1256),n2h4(2164))
  call Hloop_QV_A(ntryL,G1H32(270),wf8(:,2),G1H4(1449),m3h8x4(:,12),heltab2x32(:,:,774))
  call Hloop_Q_A(ntryL,G1H4(1449),39,0,G2H4(1257),n2h4(2165))
  call Hloop_QV_A(ntryL,G1H32(267),wf8(:,2),G1H4(1450),m3h8x4(:,13),heltab2x32(:,:,775))
  call Hloop_Q_A(ntryL,G1H4(1450),39,nMT,G2H4(1258),n2h4(2166))
  call Hloop_AV_Q(ntryL,G1H32(269),wf8(:,2),G1H4(51),m3h8x4(:,14),heltab2x32(:,:,776))
  call Hloop_A_Q(ntryL,G1H4(51),39,nMB,G2H4(1261),n2h4(2167))
  call Hloop_QV_A(ntryL,G1H32(271),wf8(:,2),G1H4(100),m3h8x4(:,15),heltab2x32(:,:,777))
  call Hloop_Q_A(ntryL,G1H4(100),39,nMB,G2H4(1262),n2h4(2168))
  call Hloop_DV_C(ntryL,G1H32(272),32,wf8(:,2),G2H4(1263),m3h8x4(:,16),heltab2x32(:,:,778))
  call Hloop_CV_D(ntryL,G1H32(273),32,wf8(:,2),7,G2H4(1266),m3h8x4(:,17),heltab2x32(:,:,779))
  call Hloop_UV_W(ntryL,G1H32(274),32,wf8(:,2),7,G2H4(1267),m3h8x4(:,18),heltab2x32(:,:,780))
  call Hloop_QV_A(ntryL,G1H32(279),ex4(:),G1H16(539),m3h2x16(:,588),heltab2x32(:,:,781))
  call Hloop_Q_A(ntryL,G1H16(539),40,0,G2H16(130),n2h16(786))
  call Hloop_QV_A(ntryL,G1H32(276),ex4(:),G1H16(540),m3h2x16(:,589),heltab2x32(:,:,782))
  call Hloop_Q_A(ntryL,G1H16(540),40,nMT,G2H16(131),n2h16(787))
  call Hloop_AV_Q(ntryL,G1H32(281),ex4(:),G1H16(541),m3h2x16(:,590),heltab2x32(:,:,783))
  call Hloop_A_Q(ntryL,G1H16(541),40,0,G2H16(132),n2h16(788))
  call Hloop_AV_Q(ntryL,G1H32(278),ex4(:),G1H16(542),m3h2x16(:,591),heltab2x32(:,:,784))
  call Hloop_A_Q(ntryL,G1H16(542),40,nMT,G2H16(133),n2h16(789))
  call Hloop_QV_A(ntryL,G1H32(280),ex4(:),G1H16(544),m3h2x16(:,592),heltab2x32(:,:,785))
  call Hloop_Q_A(ntryL,G1H16(544),40,nMB,G2H16(134),n2h16(790))
  call Hloop_AV_Q(ntryL,G1H32(282),ex4(:),G1H16(545),m3h2x16(:,593),heltab2x32(:,:,786))
  call Hloop_A_Q(ntryL,G1H16(545),40,nMB,G2H16(135),n2h16(791))
  call Hloop_CV_D(ntryL,G1H32(283),32,ex4(:),8,G2H16(136),m3h2x16(:,594),heltab2x32(:,:,787))
  call Hloop_DV_C(ntryL,G1H32(284),32,ex4(:),G2H16(137),m3h2x16(:,595),heltab2x32(:,:,788))
  call Hloop_UV_W(ntryL,G1H32(285),32,ex4(:),8,G2H16(138),m3h2x16(:,596),heltab2x32(:,:,789))
  call Hloop_AV_Q(ntryL,G1H32(290),ex3(:),G1H16(546),m3h2x16(:,597),heltab2x32(:,:,790))
  call Hloop_A_Q(ntryL,G1H16(546),36,0,G2H16(139),n2h16(792))
  call Hloop_AV_Q(ntryL,G1H32(287),ex3(:),G1H16(547),m3h2x16(:,598),heltab2x32(:,:,791))
  call Hloop_A_Q(ntryL,G1H16(547),36,nMT,G2H16(140),n2h16(793))
  call Hloop_QV_A(ntryL,G1H32(292),ex3(:),G1H16(548),m3h2x16(:,599),heltab2x32(:,:,792))
  call Hloop_Q_A(ntryL,G1H16(548),36,0,G2H16(141),n2h16(794))
  call Hloop_QV_A(ntryL,G1H32(289),ex3(:),G1H16(550),m3h2x16(:,600),heltab2x32(:,:,793))
  call Hloop_Q_A(ntryL,G1H16(550),36,nMT,G2H16(142),n2h16(795))
  call Hloop_AV_Q(ntryL,G1H32(291),ex3(:),G1H16(551),m3h2x16(:,601),heltab2x32(:,:,794))
  call Hloop_A_Q(ntryL,G1H16(551),36,nMB,G2H16(143),n2h16(796))
  call Hloop_QV_A(ntryL,G1H32(293),ex3(:),G1H16(552),m3h2x16(:,602),heltab2x32(:,:,795))
  call Hloop_Q_A(ntryL,G1H16(552),36,nMB,G2H16(144),n2h16(797))
  call Hloop_DV_C(ntryL,G1H32(294),32,ex3(:),G2H16(145),m3h2x16(:,603),heltab2x32(:,:,796))
  call Hloop_CV_D(ntryL,G1H32(295),32,ex3(:),4,G2H16(146),m3h2x16(:,604),heltab2x32(:,:,797))
  call Hloop_UV_W(ntryL,G1H32(296),32,ex3(:),4,G2H16(147),m3h2x16(:,605),heltab2x32(:,:,798))
  call Hloop_AV_Q(ntryL,G1H32(301),wf8(:,6),G1H4(1452),m3h8x4(:,19),heltab2x32(:,:,799))
  call Hloop_A_Q(ntryL,G1H4(1452),43,0,G2H4(1268),n2h4(2169))
  call Hloop_AV_Q(ntryL,G1H32(298),wf8(:,6),G1H4(1453),m3h8x4(:,20),heltab2x32(:,:,800))
  call Hloop_A_Q(ntryL,G1H4(1453),43,nMT,G2H4(1271),n2h4(2170))
  call Hloop_QV_A(ntryL,G1H32(303),wf8(:,6),G1H4(232),m3h8x4(:,21),heltab2x32(:,:,801))
  call Hloop_Q_A(ntryL,G1H4(232),43,0,G2H4(1272),n2h4(2171))
  call Hloop_QV_A(ntryL,G1H32(300),wf8(:,6),G1H4(1456),m3h8x4(:,22),heltab2x32(:,:,802))
  call Hloop_Q_A(ntryL,G1H4(1456),43,nMT,G2H4(1273),n2h4(2172))
  call Hloop_AV_Q(ntryL,G1H32(302),wf8(:,6),G1H4(1457),m3h8x4(:,23),heltab2x32(:,:,803))
  call Hloop_A_Q(ntryL,G1H4(1457),43,nMB,G2H4(1276),n2h4(2173))
  call Hloop_QV_A(ntryL,G1H32(304),wf8(:,6),G1H4(1458),m3h8x4(:,24),heltab2x32(:,:,804))
  call Hloop_Q_A(ntryL,G1H4(1458),43,nMB,G2H4(1277),n2h4(2174))
  call Hloop_DV_C(ntryL,G1H32(305),32,wf8(:,6),G2H4(1278),m3h8x4(:,25),heltab2x32(:,:,805))
  call Hloop_CV_D(ntryL,G1H32(306),32,wf8(:,6),11,G2H4(1281),m3h8x4(:,26),heltab2x32(:,:,806))
  call Hloop_UV_W(ntryL,G1H32(307),32,wf8(:,6),11,G2H4(1282),m3h8x4(:,27),heltab2x32(:,:,807))
  call Hloop_QV_A(ntryL,G1H32(312),ex3(:),G1H16(553),m3h2x16(:,606),heltab2x32(:,:,808))
  call Hloop_Q_A(ntryL,G1H16(553),36,0,G2H16(148),n2h16(798))
  call Hloop_QV_A(ntryL,G1H32(309),ex3(:),G1H16(554),m3h2x16(:,607),heltab2x32(:,:,809))
  call Hloop_Q_A(ntryL,G1H16(554),36,nMT,G2H16(149),n2h16(799))
  call Hloop_AV_Q(ntryL,G1H32(314),ex3(:),G1H16(556),m3h2x16(:,608),heltab2x32(:,:,810))
  call Hloop_A_Q(ntryL,G1H16(556),36,0,G2H16(150),n2h16(800))
  call Hloop_AV_Q(ntryL,G1H32(311),ex3(:),G1H16(557),m3h2x16(:,609),heltab2x32(:,:,811))
  call Hloop_A_Q(ntryL,G1H16(557),36,nMT,G2H16(151),n2h16(801))
  call Hloop_QV_A(ntryL,G1H32(313),ex3(:),G1H16(558),m3h2x16(:,610),heltab2x32(:,:,812))
  call Hloop_Q_A(ntryL,G1H16(558),36,nMB,G2H16(152),n2h16(802))
  call Hloop_AV_Q(ntryL,G1H32(315),ex3(:),G1H16(559),m3h2x16(:,611),heltab2x32(:,:,813))
  call Hloop_A_Q(ntryL,G1H16(559),36,nMB,G2H16(153),n2h16(803))
  call Hloop_CV_D(ntryL,G1H32(316),32,ex3(:),4,G2H16(154),m3h2x16(:,612),heltab2x32(:,:,814))
  call Hloop_DV_C(ntryL,G1H32(317),32,ex3(:),G2H16(155),m3h2x16(:,613),heltab2x32(:,:,815))
  call Hloop_UV_W(ntryL,G1H32(318),32,ex3(:),4,G2H16(156),m3h2x16(:,614),heltab2x32(:,:,816))
  call Hloop_AV_Q(ntryL,G1H32(323),ex3(:),G1H16(560),m3h2x16(:,615),heltab2x32(:,:,817))
  call Hloop_A_Q(ntryL,G1H16(560),36,0,G2H16(157),n2h16(804))
  call Hloop_AV_Q(ntryL,G1H32(320),ex3(:),G1H16(562),m3h2x16(:,616),heltab2x32(:,:,818))
  call Hloop_A_Q(ntryL,G1H16(562),36,nMT,G2H16(158),n2h16(805))
  call Hloop_QV_A(ntryL,G1H32(325),ex3(:),G1H16(563),m3h2x16(:,617),heltab2x32(:,:,819))
  call Hloop_Q_A(ntryL,G1H16(563),36,0,G2H16(159),n2h16(806))
  call Hloop_QV_A(ntryL,G1H32(322),ex3(:),G1H16(564),m3h2x16(:,618),heltab2x32(:,:,820))
  call Hloop_Q_A(ntryL,G1H16(564),36,nMT,G2H16(160),n2h16(807))
  call Hloop_AV_Q(ntryL,G1H32(324),ex3(:),G1H16(565),m3h2x16(:,619),heltab2x32(:,:,821))
  call Hloop_A_Q(ntryL,G1H16(565),36,nMB,G2H16(161),n2h16(808))
  call Hloop_QV_A(ntryL,G1H32(326),ex3(:),G1H16(566),m3h2x16(:,620),heltab2x32(:,:,822))
  call Hloop_Q_A(ntryL,G1H16(566),36,nMB,G2H16(162),n2h16(809))
  call Hloop_DV_C(ntryL,G1H32(327),32,ex3(:),G2H16(163),m3h2x16(:,621),heltab2x32(:,:,823))
  call Hloop_CV_D(ntryL,G1H32(328),32,ex3(:),4,G2H16(164),m3h2x16(:,622),heltab2x32(:,:,824))
  call Hloop_UV_W(ntryL,G1H32(329),32,ex3(:),4,G2H16(165),m3h2x16(:,623),heltab2x32(:,:,825))
  call Hloop_QV_A(ntryL,G1H32(334),ex4(:),G1H16(568),m3h2x16(:,624),heltab2x32(:,:,826))
  call Hloop_Q_A(ntryL,G1H16(568),40,0,G2H16(166),n2h16(810))
  call Hloop_QV_A(ntryL,G1H32(331),ex4(:),G1H16(569),m3h2x16(:,625),heltab2x32(:,:,827))
  call Hloop_Q_A(ntryL,G1H16(569),40,nMT,G2H16(167),n2h16(811))
  call Hloop_AV_Q(ntryL,G1H32(336),ex4(:),G1H16(570),m3h2x16(:,626),heltab2x32(:,:,828))
  call Hloop_A_Q(ntryL,G1H16(570),40,0,G2H16(168),n2h16(812))
  call Hloop_AV_Q(ntryL,G1H32(333),ex4(:),G1H16(571),m3h2x16(:,627),heltab2x32(:,:,829))
  call Hloop_A_Q(ntryL,G1H16(571),40,nMT,G2H16(169),n2h16(813))
  call Hloop_QV_A(ntryL,G1H32(335),ex4(:),G1H16(572),m3h2x16(:,628),heltab2x32(:,:,830))
  call Hloop_Q_A(ntryL,G1H16(572),40,nMB,G2H16(170),n2h16(814))
  call Hloop_AV_Q(ntryL,G1H32(337),ex4(:),G1H16(574),m3h2x16(:,629),heltab2x32(:,:,831))
  call Hloop_A_Q(ntryL,G1H16(574),40,nMB,G2H16(171),n2h16(815))
  call Hloop_CV_D(ntryL,G1H32(338),32,ex4(:),8,G2H16(172),m3h2x16(:,630),heltab2x32(:,:,832))
  call Hloop_DV_C(ntryL,G1H32(339),32,ex4(:),G2H16(173),m3h2x16(:,631),heltab2x32(:,:,833))
  call Hloop_UV_W(ntryL,G1H32(340),32,ex4(:),8,G2H16(174),m3h2x16(:,632),heltab2x32(:,:,834))
  call Hloop_QV_A(ntryL,G1H32(345),ex3(:),G1H16(575),m3h2x16(:,633),heltab2x32(:,:,835))
  call Hloop_Q_A(ntryL,G1H16(575),36,0,G2H16(175),n2h16(816))
  call Hloop_QV_A(ntryL,G1H32(342),ex3(:),G1H16(576),m3h2x16(:,634),heltab2x32(:,:,836))
  call Hloop_Q_A(ntryL,G1H16(576),36,nMT,G2H16(176),n2h16(817))
  call Hloop_AV_Q(ntryL,G1H32(347),ex3(:),G1H16(278),m3h2x16(:,635),heltab2x32(:,:,837))
  call Hloop_A_Q(ntryL,G1H16(278),36,0,G2H16(177),n2h16(818))
  call Hloop_AV_Q(ntryL,G1H32(344),ex3(:),G1H16(279),m3h2x16(:,636),heltab2x32(:,:,838))
  call Hloop_A_Q(ntryL,G1H16(279),36,nMT,G2H16(178),n2h16(819))
  call Hloop_QV_A(ntryL,G1H32(346),ex3(:),G1H16(578),m3h2x16(:,637),heltab2x32(:,:,839))
  call Hloop_Q_A(ntryL,G1H16(578),36,nMB,G2H16(179),n2h16(820))
  call Hloop_AV_Q(ntryL,G1H32(348),ex3(:),G1H16(579),m3h2x16(:,638),heltab2x32(:,:,840))
  call Hloop_A_Q(ntryL,G1H16(579),36,nMB,G2H16(180),n2h16(821))
  call Hloop_CV_D(ntryL,G1H32(349),32,ex3(:),4,G2H16(181),m3h2x16(:,639),heltab2x32(:,:,841))
  call Hloop_DV_C(ntryL,G1H32(350),32,ex3(:),G2H16(182),m3h2x16(:,640),heltab2x32(:,:,842))
  call Hloop_UV_W(ntryL,G1H32(351),32,ex3(:),4,G2H16(183),m3h2x16(:,641),heltab2x32(:,:,843))
  call Hloop_QA_V(ntryL,G1H32(352),wf4(:,15),G1H8(529),m3h4x8(:,176),heltab2x32(:,:,844))
  call Hloop_VA_Q(ntryL,G1H32(353),wf4(:,15),G1H8(541),m3h4x8(:,177),heltab2x32(:,:,845))
  call Hloop_A_Q(ntryL,G1H8(541),42,nMT,G2H8(511),n2h8(1680))
  call Hloop_AQ_V(ntryL,G1H32(354),wf4(:,9),G1H8(540),m3h4x8(:,178),heltab2x32(:,:,846))
  call Hloop_VQ_A(ntryL,G1H32(355),wf4(:,9),G1H8(542),m3h4x8(:,179),heltab2x32(:,:,847))
  call Hloop_Q_A(ntryL,G1H8(542),37,nMT,G2H8(512),n2h8(1681))
  call Hloop_VQ_A(ntryL,G1H32(356),wf4(:,9),G1H8(546),m3h4x8(:,180),heltab2x32(:,:,848))
  call Hloop_Q_A(ntryL,G1H8(546),37,nMT,G2H8(514),n2h8(1682))
  call Hloop_AQ_V(ntryL,G1H32(357),wf4(:,9),G1H8(557),m3h4x8(:,181),heltab2x32(:,:,849))
  call Hloop_AV_Q(ntryL,G1H32(358),ex4(:),G1H16(580),m3h2x16(:,642),heltab2x32(:,:,850))
  call Hloop_A_Q(ntryL,G1H16(580),40,nMT,G2H16(184),n2h16(822))
  call Hloop_UV_W(ntryL,G1H32(359),32,ex4(:),8,G2H16(185),m3h2x16(:,643),heltab2x32(:,:,851))
  call Hloop_AQ_V(ntryL,G1H32(360),wf4(:,9),G1H8(566),m3h4x8(:,182),heltab2x32(:,:,852))
  call Hloop_VQ_A(ntryL,G1H32(361),wf4(:,9),G1H8(558),m3h4x8(:,183),heltab2x32(:,:,853))
  call Hloop_Q_A(ntryL,G1H8(558),37,nMT,G2H8(515),n2h8(1683))
  call Hloop_VQ_A(ntryL,G1H32(362),wf4(:,9),G1H8(564),m3h4x8(:,184),heltab2x32(:,:,854))
  call Hloop_Q_A(ntryL,G1H8(564),37,nMT,G2H8(516),n2h8(1684))
  call Hloop_AQ_V(ntryL,G1H32(363),wf4(:,9),G1H8(571),m3h4x8(:,185),heltab2x32(:,:,855))
  call Hloop_QA_V(ntryL,G1H32(364),ex2(:),G1H16(581),m3h2x16(:,644),heltab2x32(:,:,856))
  call Hloop_VA_Q(ntryL,G1H32(365),ex2(:),G1H16(582),m3h2x16(:,645),heltab2x32(:,:,857))
  call Hloop_A_Q(ntryL,G1H16(582),34,nMT,G2H16(186),n2h16(823))
  call Hloop_QA_V(ntryL,G1H32(366),ex2(:),G1H16(584),m3h2x16(:,646),heltab2x32(:,:,858))
  call Hloop_VA_Q(ntryL,G1H32(367),ex2(:),G1H16(585),m3h2x16(:,647),heltab2x32(:,:,859))
  call Hloop_A_Q(ntryL,G1H16(585),34,nMT,G2H16(187),n2h16(824))
  call Hloop_AQ_V(ntryL,G1H32(368),wf4(:,9),G1H8(575),m3h4x8(:,186),heltab2x32(:,:,860))
  call Hloop_VQ_A(ntryL,G1H32(369),wf4(:,9),G1H8(578),m3h4x8(:,187),heltab2x32(:,:,861))
  call Hloop_Q_A(ntryL,G1H8(578),37,nMT,G2H8(518),n2h8(1685))
  call Hloop_VQ_A(ntryL,G0H16(223),wf4(:,9),G0H4(7),m3h4x4(:,319),heltab2x16(:,:,1674))
  call Hloop_Q_A(ntryL,G0H4(7),39,nMT,G1H4(1461),n2h4(2175))
  call Hloop_AQ_V(ntryL,G1H16(120),wf4(:,9),G1H4(1462),m3h4x4(:,320),heltab2x16(:,:,1675))
  call Hloop_VQ_A(ntryL,G0H16(224),wf4(:,9),G0H4(8),m3h4x4(:,321),heltab2x16(:,:,1676))
  call Hloop_Q_A(ntryL,G0H4(8),39,nMT,G1H4(75),n2h4(2176))
  call Hloop_AQ_V(ntryL,G1H16(123),wf4(:,9),G1H4(268),m3h4x4(:,322),heltab2x16(:,:,1677))
  call Hloop_UV_W(ntryL,G0H16(225),34,ex4(:),8,G1H8(581),m3h2x8(:,1356),heltab2x16(:,:,1678))
  call Hloop_AQ_V(ntryL,G1H16(129),wf4(:,9),G1H4(1465),m3h4x4(:,323),heltab2x16(:,:,1679))
  call Hloop_QA_V(ntryL,G1H16(136),ex2(:),G1H8(590),m3h2x8(:,1357),heltab2x16(:,:,1680))
  call Hloop_QA_V(ntryL,G1H16(139),ex2(:),G1H8(601),m3h2x8(:,1358),heltab2x16(:,:,1681))
  call Hloop_AQ_V(ntryL,G1H16(5),wf4(:,9),G1H4(1466),m3h4x4(:,324),heltab2x16(:,:,1682))
  call Hloop_QA_V(ntryL,G1H16(161),ex2(:),G1H8(593),m3h2x8(:,1359),heltab2x16(:,:,1683))
  call Hloop_QA_V(ntryL,G1H16(164),ex2(:),G1H8(600),m3h2x8(:,1360),heltab2x16(:,:,1684))
  call Hloop_QV_A(ntryL,G1H32(374),wf8(:,17),G1H4(87),m3h8x4(:,28),heltab2x32(:,:,862))
  call Hloop_Q_A(ntryL,G1H4(87),39,0,G2H4(1283),n2h4(2177))
  call Hloop_QV_A(ntryL,G1H32(371),wf8(:,17),G1H4(172),m3h8x4(:,29),heltab2x32(:,:,863))
  call Hloop_Q_A(ntryL,G1H4(172),39,nMT,G2H4(1286),n2h4(2178))
  call Hloop_AV_Q(ntryL,G1H32(376),wf8(:,17),G1H4(1469),m3h8x4(:,30),heltab2x32(:,:,864))
  call Hloop_A_Q(ntryL,G1H4(1469),39,0,G2H4(1287),n2h4(2179))
  call Hloop_AV_Q(ntryL,G1H32(373),wf8(:,17),G1H4(1470),m3h8x4(:,31),heltab2x32(:,:,865))
  call Hloop_A_Q(ntryL,G1H4(1470),39,nMT,G2H4(1288),n2h4(2180))
  call Hloop_QV_A(ntryL,G1H32(375),wf8(:,17),G1H4(99),m3h8x4(:,32),heltab2x32(:,:,866))
  call Hloop_Q_A(ntryL,G1H4(99),39,nMB,G2H4(1291),n2h4(2181))
  call Hloop_AV_Q(ntryL,G1H32(377),wf8(:,17),G1H4(701),m3h8x4(:,33),heltab2x32(:,:,867))
  call Hloop_A_Q(ntryL,G1H4(701),39,nMB,G2H4(1292),n2h4(2182))
  call Hloop_CV_D(ntryL,G1H32(378),32,wf8(:,17),7,G2H4(1293),m3h8x4(:,34),heltab2x32(:,:,868))
  call Hloop_DV_C(ntryL,G1H32(379),32,wf8(:,17),G2H4(1296),m3h8x4(:,35),heltab2x32(:,:,869))
  call Hloop_UV_W(ntryL,G1H32(380),32,wf8(:,17),7,G2H4(1297),m3h8x4(:,36),heltab2x32(:,:,870))
  call Hloop_AV_Q(ntryL,G1H32(385),wf8(:,17),G1H4(1473),m3h8x4(:,37),heltab2x32(:,:,871))
  call Hloop_A_Q(ntryL,G1H4(1473),39,0,G2H4(1298),n2h4(2183))
  call Hloop_AV_Q(ntryL,G1H32(382),wf8(:,17),G1H4(1474),m3h8x4(:,38),heltab2x32(:,:,872))
  call Hloop_A_Q(ntryL,G1H4(1474),39,nMT,G2H4(1301),n2h4(2184))
  call Hloop_QV_A(ntryL,G1H32(387),wf8(:,17),G1H4(1475),m3h8x4(:,39),heltab2x32(:,:,873))
  call Hloop_Q_A(ntryL,G1H4(1475),39,0,G2H4(1302),n2h4(2185))
  call Hloop_QV_A(ntryL,G1H32(384),wf8(:,17),G1H4(1476),m3h8x4(:,40),heltab2x32(:,:,874))
  call Hloop_Q_A(ntryL,G1H4(1476),39,nMT,G2H4(1303),n2h4(2186))
  call Hloop_AV_Q(ntryL,G1H32(386),wf8(:,17),G1H4(1479),m3h8x4(:,41),heltab2x32(:,:,875))
  call Hloop_A_Q(ntryL,G1H4(1479),39,nMB,G2H4(1306),n2h4(2187))
  call Hloop_QV_A(ntryL,G1H32(388),wf8(:,17),G1H4(1480),m3h8x4(:,42),heltab2x32(:,:,876))
  call Hloop_Q_A(ntryL,G1H4(1480),39,nMB,G2H4(1307),n2h4(2188))
  call Hloop_DV_C(ntryL,G1H32(389),32,wf8(:,17),G2H4(1308),m3h8x4(:,43),heltab2x32(:,:,877))
  call Hloop_CV_D(ntryL,G1H32(390),32,wf8(:,17),7,G2H4(1311),m3h8x4(:,44),heltab2x32(:,:,878))
  call Hloop_UV_W(ntryL,G1H32(391),32,wf8(:,17),7,G2H4(1312),m3h8x4(:,45),heltab2x32(:,:,879))
  call Hloop_QV_A(ntryL,G1H32(396),ex4(:),G1H16(586),m3h2x16(:,648),heltab2x32(:,:,880))
  call Hloop_Q_A(ntryL,G1H16(586),40,0,G2H16(188),n2h16(825))
  call Hloop_QV_A(ntryL,G1H32(393),ex4(:),G1H16(587),m3h2x16(:,649),heltab2x32(:,:,881))
  call Hloop_Q_A(ntryL,G1H16(587),40,nMT,G2H16(189),n2h16(826))
  call Hloop_AV_Q(ntryL,G1H32(398),ex4(:),G1H16(588),m3h2x16(:,650),heltab2x32(:,:,882))
  call Hloop_A_Q(ntryL,G1H16(588),40,0,G2H16(190),n2h16(827))
  call Hloop_AV_Q(ntryL,G1H32(395),ex4(:),G1H16(590),m3h2x16(:,651),heltab2x32(:,:,883))
  call Hloop_A_Q(ntryL,G1H16(590),40,nMT,G2H16(191),n2h16(828))
  call Hloop_QV_A(ntryL,G1H32(397),ex4(:),G1H16(591),m3h2x16(:,652),heltab2x32(:,:,884))
  call Hloop_Q_A(ntryL,G1H16(591),40,nMB,G2H16(192),n2h16(829))
  call Hloop_AV_Q(ntryL,G1H32(399),ex4(:),G1H16(592),m3h2x16(:,653),heltab2x32(:,:,885))
  call Hloop_A_Q(ntryL,G1H16(592),40,nMB,G2H16(193),n2h16(830))
  call Hloop_CV_D(ntryL,G1H32(400),32,ex4(:),8,G2H16(194),m3h2x16(:,654),heltab2x32(:,:,886))
  call Hloop_DV_C(ntryL,G1H32(401),32,ex4(:),G2H16(195),m3h2x16(:,655),heltab2x32(:,:,887))
  call Hloop_UV_W(ntryL,G1H32(402),32,ex4(:),8,G2H16(196),m3h2x16(:,656),heltab2x32(:,:,888))
  call Hloop_VA_Q(ntryL,G1H32(403),ex2(:),G1H16(283),m3h2x16(:,657),heltab2x32(:,:,889))
  call Hloop_A_Q(ntryL,G1H16(283),34,nMT,G2H16(197),n2h16(831))
  call Hloop_QA_V(ntryL,G1H32(404),ex2(:),G1H16(284),m3h2x16(:,658),heltab2x32(:,:,890))
  call Hloop_AQ_V(ntryL,G1H32(405),wf8(:,45),G1H4(111),m3h8x4(:,46),heltab2x32(:,:,891))
  call Hloop_VQ_A(ntryL,G1H32(406),wf8(:,45),G1H4(112),m3h8x4(:,47),heltab2x32(:,:,892))
  call Hloop_Q_A(ntryL,G1H4(112),45,nMT,G2H4(1313),n2h4(2189))
  call Hloop_QA_V(ntryL,G1H32(407),ex2(:),G1H16(594),m3h2x16(:,659),heltab2x32(:,:,893))
  call Hloop_VA_Q(ntryL,G1H32(408),ex2(:),G1H16(595),m3h2x16(:,660),heltab2x32(:,:,894))
  call Hloop_A_Q(ntryL,G1H16(595),34,nMT,G2H16(198),n2h16(832))
  call Hloop_VA_Q(ntryL,G1H32(409),ex2(:),G1H16(596),m3h2x16(:,661),heltab2x32(:,:,895))
  call Hloop_A_Q(ntryL,G1H16(596),34,nMT,G2H16(199),n2h16(833))
  call Hloop_QA_V(ntryL,G1H32(410),ex2(:),G1H16(597),m3h2x16(:,662),heltab2x32(:,:,896))
  call Hloop_QV_A(ntryL,G1H32(411),ex4(:),G1H16(598),m3h2x16(:,663),heltab2x32(:,:,897))
  call Hloop_Q_A(ntryL,G1H16(598),40,nMT,G2H16(200),n2h16(834))
  call Hloop_UV_W(ntryL,G1H32(412),32,ex4(:),8,G2H16(201),m3h2x16(:,664),heltab2x32(:,:,898))
  call Hloop_QA_V(ntryL,G1H32(413),ex2(:),G1H16(600),m3h2x16(:,665),heltab2x32(:,:,899))
  call Hloop_VA_Q(ntryL,G1H32(414),ex2(:),G1H16(601),m3h2x16(:,666),heltab2x32(:,:,900))
  call Hloop_A_Q(ntryL,G1H16(601),34,nMT,G2H16(202),n2h16(835))
  call Hloop_UV_W(ntryL,G0H8(127),37,ex4(:),8,G1H4(1482),m3h2x4(:,2299),heltab2x8(:,:,2768))
  call Hloop_VA_Q(ntryL,G0H8(128),ex2(:),G0H4(9),m3h2x4(:,2300),heltab2x8(:,:,2769))
  call Hloop_A_Q(ntryL,G0H4(9),39,nMT,G1H4(1483),n2h4(2190))
  call Hloop_QA_V(ntryL,G1H8(268),ex2(:),G1H4(123),m3h2x4(:,2301),heltab2x8(:,:,2770))
  call Hloop_VA_Q(ntryL,G0H8(129),ex2(:),G0H4(10),m3h2x4(:,2302),heltab2x8(:,:,2771))
  call Hloop_A_Q(ntryL,G0H4(10),39,nMT,G1H4(148),n2h4(2191))
  call Hloop_QA_V(ntryL,G1H8(22),ex2(:),G1H4(1485),m3h2x4(:,2303),heltab2x8(:,:,2772))
  call Hloop_QA_V(ntryL,G1H32(415),wf4(:,11),G1H8(602),m3h4x8(:,188),heltab2x32(:,:,901))
  call Hloop_VA_Q(ntryL,G1H32(416),wf4(:,11),G1H8(611),m3h4x8(:,189),heltab2x32(:,:,902))
  call Hloop_A_Q(ntryL,G1H8(611),38,nMT,G2H8(519),n2h8(1686))
  call Hloop_AQ_V(ntryL,G1H32(417),wf4(:,13),G1H8(612),m3h4x8(:,190),heltab2x32(:,:,903))
  call Hloop_VQ_A(ntryL,G1H32(418),wf4(:,13),G1H8(614),m3h4x8(:,191),heltab2x32(:,:,904))
  call Hloop_Q_A(ntryL,G1H8(614),41,nMT,G2H8(521),n2h8(1687))
  call Hloop_VA_Q(ntryL,G1H32(419),wf4(:,11),G1H8(631),m3h4x8(:,192),heltab2x32(:,:,905))
  call Hloop_A_Q(ntryL,G1H8(631),38,nMT,G2H8(523),n2h8(1688))
  call Hloop_QA_V(ntryL,G1H32(420),wf4(:,11),G1H8(636),m3h4x8(:,193),heltab2x32(:,:,906))
  call Hloop_QA_V(ntryL,G1H32(421),wf4(:,11),G1H8(626),m3h4x8(:,194),heltab2x32(:,:,907))
  call Hloop_VA_Q(ntryL,G1H32(422),wf4(:,11),G1H8(635),m3h4x8(:,195),heltab2x32(:,:,908))
  call Hloop_A_Q(ntryL,G1H8(635),38,nMT,G2H8(524),n2h8(1689))
  call Hloop_QV_A(ntryL,G1H32(423),ex4(:),G1H16(602),m3h2x16(:,667),heltab2x32(:,:,909))
  call Hloop_Q_A(ntryL,G1H16(602),40,nMT,G2H16(203),n2h16(836))
  call Hloop_UV_W(ntryL,G1H32(424),32,ex4(:),8,G2H16(204),m3h2x16(:,668),heltab2x32(:,:,910))
  call Hloop_VA_Q(ntryL,G1H32(425),wf4(:,11),G1H8(637),m3h4x8(:,196),heltab2x32(:,:,911))
  call Hloop_A_Q(ntryL,G1H8(637),38,nMT,G2H8(525),n2h8(1690))
  call Hloop_QA_V(ntryL,G1H32(426),wf4(:,11),G1H8(644),m3h4x8(:,197),heltab2x32(:,:,912))
  call Hloop_AQ_V(ntryL,G1H32(427),ex1(:),G1H16(35),m3h2x16(:,669),heltab2x32(:,:,913))
  call Hloop_VQ_A(ntryL,G1H32(428),ex1(:),G1H16(288),m3h2x16(:,670),heltab2x32(:,:,914))
  call Hloop_Q_A(ntryL,G1H16(288),33,nMT,G2H16(205),n2h16(837))
  call Hloop_AQ_V(ntryL,G1H32(429),ex1(:),G1H16(604),m3h2x16(:,671),heltab2x32(:,:,915))
  call Hloop_VQ_A(ntryL,G1H32(430),ex1(:),G1H16(605),m3h2x16(:,672),heltab2x32(:,:,916))
  call Hloop_Q_A(ntryL,G1H16(605),33,nMT,G2H16(206),n2h16(838))
  call Hloop_QA_V(ntryL,G1H32(431),wf4(:,11),G1H8(647),m3h4x8(:,198),heltab2x32(:,:,917))
  call Hloop_VA_Q(ntryL,G1H32(432),wf4(:,11),G1H8(648),m3h4x8(:,199),heltab2x32(:,:,918))
  call Hloop_A_Q(ntryL,G1H8(648),38,nMT,G2H8(527),n2h8(1691))
  call Hloop_VA_Q(ntryL,G0H16(226),wf4(:,11),G0H4(11),m3h4x4(:,325),heltab2x16(:,:,1685))
  call Hloop_A_Q(ntryL,G0H4(11),39,nMT,G1H4(1486),n2h4(2192))
  call Hloop_QA_V(ntryL,G1H16(168),wf4(:,11),G1H4(135),m3h4x4(:,326),heltab2x16(:,:,1686))
  call Hloop_VA_Q(ntryL,G0H16(227),wf4(:,11),G0H4(12),m3h4x4(:,327),heltab2x16(:,:,1687))
  call Hloop_A_Q(ntryL,G0H4(12),39,nMT,G1H4(196),n2h4(2193))
  call Hloop_QA_V(ntryL,G1H16(169),wf4(:,11),G1H4(1489),m3h4x4(:,328),heltab2x16(:,:,1688))
  call Hloop_UV_W(ntryL,G0H16(228),33,ex4(:),8,G1H8(661),m3h2x8(:,1361),heltab2x16(:,:,1689))
  call Hloop_QA_V(ntryL,G1H16(172),wf4(:,11),G1H4(1490),m3h4x4(:,329),heltab2x16(:,:,1690))
  call Hloop_AQ_V(ntryL,G1H16(176),ex1(:),G1H8(671),m3h2x8(:,1362),heltab2x16(:,:,1691))
  call Hloop_AQ_V(ntryL,G1H16(18),ex1(:),G1H8(667),m3h2x8(:,1363),heltab2x16(:,:,1692))
  call Hloop_QA_V(ntryL,G1H16(198),wf4(:,11),G1H4(147),m3h4x4(:,330),heltab2x16(:,:,1693))
  call Hloop_AQ_V(ntryL,G1H16(202),ex1(:),G1H8(668),m3h2x8(:,1364),heltab2x16(:,:,1694))
  call Hloop_AQ_V(ntryL,G1H16(203),ex1(:),G1H8(672),m3h2x8(:,1365),heltab2x16(:,:,1695))
  call Hloop_QV_A(ntryL,G1H32(437),wf8(:,18),G1H4(893),m3h8x4(:,48),heltab2x32(:,:,919))
  call Hloop_Q_A(ntryL,G1H4(893),39,0,G2H4(1316),n2h4(2194))
  call Hloop_QV_A(ntryL,G1H32(434),wf8(:,18),G1H4(1493),m3h8x4(:,49),heltab2x32(:,:,920))
  call Hloop_Q_A(ntryL,G1H4(1493),39,nMT,G2H4(1317),n2h4(2195))
  call Hloop_AV_Q(ntryL,G1H32(439),wf8(:,18),G1H4(1494),m3h8x4(:,50),heltab2x32(:,:,921))
  call Hloop_A_Q(ntryL,G1H4(1494),39,0,G2H4(1318),n2h4(2196))
  call Hloop_AV_Q(ntryL,G1H32(436),wf8(:,18),G1H4(1495),m3h8x4(:,51),heltab2x32(:,:,922))
  call Hloop_A_Q(ntryL,G1H4(1495),39,nMT,G2H4(1321),n2h4(2197))
  call Hloop_QV_A(ntryL,G1H32(438),wf8(:,18),G1H4(1496),m3h8x4(:,52),heltab2x32(:,:,923))
  call Hloop_Q_A(ntryL,G1H4(1496),39,nMB,G2H4(1322),n2h4(2198))
  call Hloop_AV_Q(ntryL,G1H32(440),wf8(:,18),G1H4(1499),m3h8x4(:,53),heltab2x32(:,:,924))
  call Hloop_A_Q(ntryL,G1H4(1499),39,nMB,G2H4(1323),n2h4(2199))
  call Hloop_CV_D(ntryL,G1H32(441),32,wf8(:,18),7,G2H4(1326),m3h8x4(:,54),heltab2x32(:,:,925))
  call Hloop_DV_C(ntryL,G1H32(442),32,wf8(:,18),G2H4(1327),m3h8x4(:,55),heltab2x32(:,:,926))
  call Hloop_UV_W(ntryL,G1H32(443),32,wf8(:,18),7,G2H4(1328),m3h8x4(:,56),heltab2x32(:,:,927))
  call Hloop_AV_Q(ntryL,G1H32(448),wf8(:,18),G1H4(1500),m3h8x4(:,57),heltab2x32(:,:,928))
  call Hloop_A_Q(ntryL,G1H4(1500),39,0,G2H4(1331),n2h4(2200))
  call Hloop_AV_Q(ntryL,G1H32(445),wf8(:,18),G1H4(159),m3h8x4(:,58),heltab2x32(:,:,929))
  call Hloop_A_Q(ntryL,G1H4(159),39,nMT,G2H4(1332),n2h4(2201))
  call Hloop_QV_A(ntryL,G1H32(450),wf8(:,18),G1H4(160),m3h8x4(:,59),heltab2x32(:,:,930))
  call Hloop_Q_A(ntryL,G1H4(160),39,0,G2H4(1333),n2h4(2202))
  call Hloop_QV_A(ntryL,G1H32(447),wf8(:,18),G1H4(1502),m3h8x4(:,60),heltab2x32(:,:,931))
  call Hloop_Q_A(ntryL,G1H4(1502),39,nMT,G2H4(1336),n2h4(2203))
  call Hloop_AV_Q(ntryL,G1H32(449),wf8(:,18),G1H4(1503),m3h8x4(:,61),heltab2x32(:,:,932))
  call Hloop_A_Q(ntryL,G1H4(1503),39,nMB,G2H4(1337),n2h4(2204))
  call Hloop_QV_A(ntryL,G1H32(451),wf8(:,18),G1H4(171),m3h8x4(:,62),heltab2x32(:,:,933))
  call Hloop_Q_A(ntryL,G1H4(171),39,nMB,G2H4(1338),n2h4(2205))
  call Hloop_DV_C(ntryL,G1H32(452),32,wf8(:,18),G2H4(1341),m3h8x4(:,63),heltab2x32(:,:,934))
  call Hloop_CV_D(ntryL,G1H32(453),32,wf8(:,18),7,G2H4(1342),m3h8x4(:,64),heltab2x32(:,:,935))
  call Hloop_UV_W(ntryL,G1H32(454),32,wf8(:,18),7,G2H4(1343),m3h8x4(:,65),heltab2x32(:,:,936))
  call Hloop_QV_A(ntryL,G1H32(459),ex4(:),G1H16(606),m3h2x16(:,673),heltab2x32(:,:,937))
  call Hloop_Q_A(ntryL,G1H16(606),40,0,G2H16(207),n2h16(839))
  call Hloop_QV_A(ntryL,G1H32(456),ex4(:),G1H16(291),m3h2x16(:,674),heltab2x32(:,:,938))
  call Hloop_Q_A(ntryL,G1H16(291),40,nMT,G2H16(208),n2h16(840))
  call Hloop_AV_Q(ntryL,G1H32(461),ex4(:),G1H16(293),m3h2x16(:,675),heltab2x32(:,:,939))
  call Hloop_A_Q(ntryL,G1H16(293),40,0,G2H16(209),n2h16(841))
  call Hloop_AV_Q(ntryL,G1H32(458),ex4(:),G1H16(608),m3h2x16(:,676),heltab2x32(:,:,940))
  call Hloop_A_Q(ntryL,G1H16(608),40,nMT,G2H16(210),n2h16(842))
  call Hloop_QV_A(ntryL,G1H32(460),ex4(:),G1H16(609),m3h2x16(:,677),heltab2x32(:,:,941))
  call Hloop_Q_A(ntryL,G1H16(609),40,nMB,G2H16(211),n2h16(843))
  call Hloop_AV_Q(ntryL,G1H32(462),ex4(:),G1H16(610),m3h2x16(:,678),heltab2x32(:,:,942))
  call Hloop_A_Q(ntryL,G1H16(610),40,nMB,G2H16(212),n2h16(844))
  call Hloop_CV_D(ntryL,G1H32(463),32,ex4(:),8,G2H16(213),m3h2x16(:,679),heltab2x32(:,:,943))
  call Hloop_DV_C(ntryL,G1H32(464),32,ex4(:),G2H16(214),m3h2x16(:,680),heltab2x32(:,:,944))
  call Hloop_UV_W(ntryL,G1H32(465),32,ex4(:),8,G2H16(215),m3h2x16(:,681),heltab2x32(:,:,945))
  call Hloop_VQ_A(ntryL,G1H32(466),ex1(:),G1H16(611),m3h2x16(:,682),heltab2x32(:,:,946))
  call Hloop_Q_A(ntryL,G1H16(611),33,nMT,G2H16(216),n2h16(845))
  call Hloop_AQ_V(ntryL,G1H32(467),ex1(:),G1H16(612),m3h2x16(:,683),heltab2x32(:,:,947))
  call Hloop_QA_V(ntryL,G1H32(468),wf8(:,67),G1H4(365),m3h8x4(:,66),heltab2x32(:,:,948))
  call Hloop_VA_Q(ntryL,G1H32(469),wf8(:,67),G1H4(1506),m3h8x4(:,67),heltab2x32(:,:,949))
  call Hloop_A_Q(ntryL,G1H4(1506),46,nMT,G2H4(1346),n2h4(2206))
  call Hloop_AQ_V(ntryL,G1H32(470),ex1(:),G1H16(614),m3h2x16(:,684),heltab2x32(:,:,950))
  call Hloop_VQ_A(ntryL,G1H32(471),ex1(:),G1H16(615),m3h2x16(:,685),heltab2x32(:,:,951))
  call Hloop_Q_A(ntryL,G1H16(615),33,nMT,G2H16(217),n2h16(846))
  call Hloop_VQ_A(ntryL,G1H32(472),ex1(:),G1H16(616),m3h2x16(:,686),heltab2x32(:,:,952))
  call Hloop_Q_A(ntryL,G1H16(616),33,nMT,G2H16(218),n2h16(847))
  call Hloop_AQ_V(ntryL,G1H32(473),ex1(:),G1H16(617),m3h2x16(:,687),heltab2x32(:,:,953))
  call Hloop_AV_Q(ntryL,G1H32(474),ex4(:),G1H16(618),m3h2x16(:,688),heltab2x32(:,:,954))
  call Hloop_A_Q(ntryL,G1H16(618),40,nMT,G2H16(219),n2h16(848))
  call Hloop_UV_W(ntryL,G1H32(475),32,ex4(:),8,G2H16(220),m3h2x16(:,689),heltab2x32(:,:,955))
  call Hloop_AQ_V(ntryL,G1H32(476),ex1(:),G1H16(620),m3h2x16(:,690),heltab2x32(:,:,956))
  call Hloop_VQ_A(ntryL,G1H32(477),ex1(:),G1H16(621),m3h2x16(:,691),heltab2x32(:,:,957))
  call Hloop_Q_A(ntryL,G1H16(621),33,nMT,G2H16(221),n2h16(849))
  call Hloop_UV_W(ntryL,G0H8(130),38,ex4(:),8,G1H4(1507),m3h2x4(:,2304),heltab2x8(:,:,2773))
  call Hloop_VQ_A(ntryL,G0H8(131),ex1(:),G0H4(13),m3h2x4(:,2305),heltab2x8(:,:,2774))
  call Hloop_Q_A(ntryL,G0H4(13),39,nMT,G1H4(183),n2h4(2207))
  call Hloop_AQ_V(ntryL,G1H8(40),ex1(:),G1H4(437),m3h2x4(:,2306),heltab2x8(:,:,2775))
  call Hloop_VQ_A(ntryL,G0H8(132),ex1(:),G0H4(14),m3h2x4(:,2307),heltab2x8(:,:,2776))
  call Hloop_Q_A(ntryL,G0H4(14),39,nMT,G1H4(1510),n2h4(2208))
  call Hloop_AQ_V(ntryL,G1H8(45),ex1(:),G1H4(1511),m3h2x4(:,2308),heltab2x8(:,:,2777))
  call Hloop_AV_Q(ntryL,G1H32(478),ex3(:),G1H16(622),m3h2x16(:,692),heltab2x32(:,:,958))
  call Hloop_A_Q(ntryL,G1H16(622),36,nMT,G2H16(222),n2h16(850))
  call Hloop_UV_W(ntryL,G1H32(479),32,ex3(:),4,G2H16(223),m3h2x16(:,693),heltab2x32(:,:,959))
  call Hloop_QV_A(ntryL,G1H32(480),ex3(:),G1H16(296),m3h2x16(:,694),heltab2x32(:,:,960))
  call Hloop_Q_A(ntryL,G1H16(296),36,nMT,G2H16(224),n2h16(851))
  call Hloop_UV_W(ntryL,G1H32(481),32,ex3(:),4,G2H16(225),m3h2x16(:,695),heltab2x32(:,:,961))
  call Hloop_VQ_A(ntryL,G1H32(482),wf4(:,13),G1H8(680),m3h4x8(:,200),heltab2x32(:,:,962))
  call Hloop_Q_A(ntryL,G1H8(680),41,nMT,G2H8(528),n2h8(1692))
  call Hloop_AQ_V(ntryL,G1H32(483),wf4(:,13),G1H8(683),m3h4x8(:,201),heltab2x32(:,:,963))
  call Hloop_QA_V(ntryL,G1H32(484),ex2(:),G1H16(298),m3h2x16(:,696),heltab2x32(:,:,964))
  call Hloop_VA_Q(ntryL,G1H32(485),ex2(:),G1H16(624),m3h2x16(:,697),heltab2x32(:,:,965))
  call Hloop_A_Q(ntryL,G1H16(624),34,nMT,G2H16(226),n2h16(852))
  call Hloop_QA_V(ntryL,G1H32(486),ex2(:),G1H16(625),m3h2x16(:,698),heltab2x32(:,:,966))
  call Hloop_VA_Q(ntryL,G1H32(487),ex2(:),G1H16(626),m3h2x16(:,699),heltab2x32(:,:,967))
  call Hloop_A_Q(ntryL,G1H16(626),34,nMT,G2H16(227),n2h16(853))
  call Hloop_AQ_V(ntryL,G1H32(488),wf4(:,13),G1H8(686),m3h4x8(:,202),heltab2x32(:,:,968))
  call Hloop_VQ_A(ntryL,G1H32(489),wf4(:,13),G1H8(698),m3h4x8(:,203),heltab2x32(:,:,969))
  call Hloop_Q_A(ntryL,G1H8(698),41,nMT,G2H8(529),n2h8(1693))
  call Hloop_VQ_A(ntryL,G0H16(229),wf4(:,13),G0H4(15),m3h4x4(:,331),heltab2x16(:,:,1696))
  call Hloop_Q_A(ntryL,G0H4(15),43,nMT,G1H4(195),n2h4(2209))
  call Hloop_AQ_V(ntryL,G1H16(206),wf4(:,13),G1H4(389),m3h4x4(:,332),heltab2x16(:,:,1697))
  call Hloop_UV_W(ntryL,G0H16(230),34,ex3(:),4,G1H8(709),m3h2x8(:,1366),heltab2x16(:,:,1698))
  call Hloop_UV_W(ntryL,G0H16(231),34,ex3(:),4,G1H8(701),m3h2x8(:,1367),heltab2x16(:,:,1699))
  call Hloop_AQ_V(ntryL,G1H16(226),wf4(:,13),G1H4(1514),m3h4x4(:,333),heltab2x16(:,:,1700))
  call Hloop_QA_V(ntryL,G1H16(232),ex2(:),G1H8(708),m3h2x8(:,1368),heltab2x16(:,:,1701))
  call Hloop_QA_V(ntryL,G1H16(233),ex2(:),G1H8(710),m3h2x8(:,1369),heltab2x16(:,:,1702))
  call Hloop_QV_A(ntryL,G1H16(236),ex3(:),G1H8(719),m3h2x8(:,1370),heltab2x16(:,:,1703))
  call Hloop_Q_A(ntryL,G1H8(719),52,nMT,G2H8(531),n2h8(1694))
  call Hloop_QA_V(ntryL,G1H16(326),ex2(:),G1H8(720),m3h2x8(:,1371),heltab2x16(:,:,1704))
  call Hloop_QA_V(ntryL,G1H16(328),ex2(:),G1H8(722),m3h2x8(:,1372),heltab2x16(:,:,1705))
  call Hloop_AV_Q(ntryL,G1H32(494),ex3(:),G1H16(627),m3h2x16(:,700),heltab2x32(:,:,970))
  call Hloop_A_Q(ntryL,G1H16(627),36,0,G2H16(228),n2h16(854))
  call Hloop_AV_Q(ntryL,G1H32(491),ex3(:),G1H16(628),m3h2x16(:,701),heltab2x32(:,:,971))
  call Hloop_A_Q(ntryL,G1H16(628),36,nMT,G2H16(229),n2h16(855))
  call Hloop_QV_A(ntryL,G1H32(496),ex3(:),G1H16(630),m3h2x16(:,702),heltab2x32(:,:,972))
  call Hloop_Q_A(ntryL,G1H16(630),36,0,G2H16(230),n2h16(856))
  call Hloop_QV_A(ntryL,G1H32(493),ex3(:),G1H16(631),m3h2x16(:,703),heltab2x32(:,:,973))
  call Hloop_Q_A(ntryL,G1H16(631),36,nMT,G2H16(231),n2h16(857))
  call Hloop_AV_Q(ntryL,G1H32(495),ex3(:),G1H16(632),m3h2x16(:,704),heltab2x32(:,:,974))
  call Hloop_A_Q(ntryL,G1H16(632),36,nMB,G2H16(232),n2h16(858))
  call Hloop_QV_A(ntryL,G1H32(497),ex3(:),G1H16(37),m3h2x16(:,705),heltab2x32(:,:,975))
  call Hloop_Q_A(ntryL,G1H16(37),36,nMB,G2H16(233),n2h16(859))
  call Hloop_DV_C(ntryL,G1H32(498),32,ex3(:),G2H16(234),m3h2x16(:,706),heltab2x32(:,:,976))
  call Hloop_CV_D(ntryL,G1H32(499),32,ex3(:),4,G2H16(235),m3h2x16(:,707),heltab2x32(:,:,977))
  call Hloop_UV_W(ntryL,G1H32(500),32,ex3(:),4,G2H16(236),m3h2x16(:,708),heltab2x32(:,:,978))
  call Hloop_AV_Q(ntryL,G1H32(505),wf8(:,19),G1H4(1515),m3h8x4(:,68),heltab2x32(:,:,979))
  call Hloop_A_Q(ntryL,G1H4(1515),43,0,G2H4(1347),n2h4(2210))
  call Hloop_AV_Q(ntryL,G1H32(502),wf8(:,19),G1H4(1516),m3h8x4(:,69),heltab2x32(:,:,980))
  call Hloop_A_Q(ntryL,G1H4(1516),43,nMT,G2H4(1348),n2h4(2211))
  call Hloop_QV_A(ntryL,G1H32(507),wf8(:,19),G1H4(1517),m3h8x4(:,70),heltab2x32(:,:,981))
  call Hloop_Q_A(ntryL,G1H4(1517),43,0,G2H4(1350),n2h4(2212))
  call Hloop_QV_A(ntryL,G1H32(504),wf8(:,19),G1H4(1520),m3h8x4(:,71),heltab2x32(:,:,982))
  call Hloop_Q_A(ntryL,G1H4(1520),43,nMT,G2H4(1351),n2h4(2213))
  call Hloop_AV_Q(ntryL,G1H32(506),wf8(:,19),G1H4(1521),m3h8x4(:,72),heltab2x32(:,:,983))
  call Hloop_A_Q(ntryL,G1H4(1521),43,nMB,G2H4(1355),n2h4(2214))
  call Hloop_QV_A(ntryL,G1H32(508),wf8(:,19),G1H4(207),m3h8x4(:,73),heltab2x32(:,:,984))
  call Hloop_Q_A(ntryL,G1H4(207),43,nMB,G2H4(1356),n2h4(2215))
  call Hloop_DV_C(ntryL,G1H32(509),32,wf8(:,19),G2H4(1358),m3h8x4(:,74),heltab2x32(:,:,985))
  call Hloop_CV_D(ntryL,G1H32(510),32,wf8(:,19),11,G2H4(1359),m3h8x4(:,75),heltab2x32(:,:,986))
  call Hloop_UV_W(ntryL,G1H32(511),32,wf8(:,19),11,G2H4(1363),m3h8x4(:,76),heltab2x32(:,:,987))
  call Hloop_QV_A(ntryL,G1H32(516),ex3(:),G1H16(303),m3h2x16(:,709),heltab2x32(:,:,988))
  call Hloop_Q_A(ntryL,G1H16(303),36,0,G2H16(237),n2h16(860))
  call Hloop_QV_A(ntryL,G1H32(513),ex3(:),G1H16(634),m3h2x16(:,710),heltab2x32(:,:,989))
  call Hloop_Q_A(ntryL,G1H16(634),36,nMT,G2H16(238),n2h16(861))
  call Hloop_AV_Q(ntryL,G1H32(518),ex3(:),G1H16(635),m3h2x16(:,711),heltab2x32(:,:,990))
  call Hloop_A_Q(ntryL,G1H16(635),36,0,G2H16(239),n2h16(862))
  call Hloop_AV_Q(ntryL,G1H32(515),ex3(:),G1H16(636),m3h2x16(:,712),heltab2x32(:,:,991))
  call Hloop_A_Q(ntryL,G1H16(636),36,nMT,G2H16(240),n2h16(863))
  call Hloop_QV_A(ntryL,G1H32(517),ex3(:),G1H16(637),m3h2x16(:,713),heltab2x32(:,:,992))
  call Hloop_Q_A(ntryL,G1H16(637),36,nMB,G2H16(241),n2h16(864))
  call Hloop_AV_Q(ntryL,G1H32(519),ex3(:),G1H16(638),m3h2x16(:,714),heltab2x32(:,:,993))
  call Hloop_A_Q(ntryL,G1H16(638),36,nMB,G2H16(242),n2h16(865))
  call Hloop_CV_D(ntryL,G1H32(520),32,ex3(:),4,G2H16(7),m3h2x16(:,715),heltab2x32(:,:,994))
  call Hloop_DV_C(ntryL,G1H32(521),32,ex3(:),G2H16(8),m3h2x16(:,716),heltab2x32(:,:,995))
  call Hloop_UV_W(ntryL,G1H32(522),32,ex3(:),4,G2H16(9),m3h2x16(:,717),heltab2x32(:,:,996))
  call Hloop_VA_Q(ntryL,G1H32(523),ex2(:),G1H16(640),m3h2x16(:,718),heltab2x32(:,:,997))
  call Hloop_A_Q(ntryL,G1H16(640),34,nMT,G2H16(10),n2h16(866))
  call Hloop_QA_V(ntryL,G1H32(524),ex2(:),G1H16(641),m3h2x16(:,719),heltab2x32(:,:,998))
  call Hloop_AQ_V(ntryL,G1H32(525),wf8(:,78),G1H4(208),m3h8x4(:,77),heltab2x32(:,:,999))
  call Hloop_VQ_A(ntryL,G1H32(526),wf8(:,78),G1H4(1523),m3h8x4(:,78),heltab2x32(:,:,1000))
  call Hloop_Q_A(ntryL,G1H4(1523),45,nMT,G2H4(1364),n2h4(2216))
  call Hloop_QA_V(ntryL,G1H32(527),ex2(:),G1H16(642),m3h2x16(:,720),heltab2x32(:,:,1001))
  call Hloop_VA_Q(ntryL,G1H32(528),ex2(:),G1H16(39),m3h2x16(:,721),heltab2x32(:,:,1002))
  call Hloop_A_Q(ntryL,G1H16(39),34,nMT,G2H16(11),n2h16(867))
  call Hloop_VA_Q(ntryL,G1H32(529),ex2(:),G1H16(307),m3h2x16(:,722),heltab2x32(:,:,1003))
  call Hloop_A_Q(ntryL,G1H16(307),34,nMT,G2H16(12),n2h16(868))
  call Hloop_QA_V(ntryL,G1H32(530),ex2(:),G1H16(644),m3h2x16(:,723),heltab2x32(:,:,1004))
  call Hloop_QV_A(ntryL,G1H32(531),ex3(:),G1H16(645),m3h2x16(:,724),heltab2x32(:,:,1005))
  call Hloop_Q_A(ntryL,G1H16(645),36,nMT,G2H16(13),n2h16(869))
  call Hloop_UV_W(ntryL,G1H32(532),32,ex3(:),4,G2H16(14),m3h2x16(:,725),heltab2x32(:,:,1006))
  call Hloop_QA_V(ntryL,G1H32(533),ex2(:),G1H16(646),m3h2x16(:,726),heltab2x32(:,:,1007))
  call Hloop_VA_Q(ntryL,G1H32(534),ex2(:),G1H16(647),m3h2x16(:,727),heltab2x32(:,:,1008))
  call Hloop_A_Q(ntryL,G1H16(647),34,nMT,G2H16(15),n2h16(870))
  call Hloop_UV_W(ntryL,G0H8(133),41,ex3(:),4,G1H4(1524),m3h2x4(:,2309),heltab2x8(:,:,2778))
  call Hloop_VA_Q(ntryL,G0H8(134),ex2(:),G0H4(16),m3h2x4(:,2310),heltab2x8(:,:,2779))
  call Hloop_A_Q(ntryL,G0H4(16),43,nMT,G1H4(219),n2h4(2217))
  call Hloop_QA_V(ntryL,G1H8(184),ex2(:),G1H4(545),m3h2x4(:,2311),heltab2x8(:,:,2780))
  call Hloop_VA_Q(ntryL,G0H8(135),ex2(:),G0H4(17),m3h2x4(:,2312),heltab2x8(:,:,2781))
  call Hloop_A_Q(ntryL,G0H4(17),43,nMT,G1H4(1527),n2h4(2218))
  call Hloop_QA_V(ntryL,G1H8(112),ex2(:),G1H4(1528),m3h2x4(:,2313),heltab2x8(:,:,2782))
  call Hloop_AV_Q(ntryL,G1H32(535),ex3(:),G1H16(648),m3h2x16(:,728),heltab2x32(:,:,1009))
  call Hloop_A_Q(ntryL,G1H16(648),36,nMT,G2H16(16),n2h16(871))
  call Hloop_UV_W(ntryL,G1H32(536),32,ex3(:),4,G2H16(17),m3h2x16(:,729),heltab2x32(:,:,1010))
  call Hloop_QV_A(ntryL,G1H32(537),ex3(:),G1H16(650),m3h2x16(:,730),heltab2x32(:,:,1011))
  call Hloop_Q_A(ntryL,G1H16(650),36,nMT,G2H16(18),n2h16(872))
  call Hloop_UV_W(ntryL,G1H32(538),32,ex3(:),4,G2H16(19),m3h2x16(:,731),heltab2x32(:,:,1012))
  call Hloop_VA_Q(ntryL,G1H32(539),wf4(:,15),G1H8(739),m3h4x8(:,204),heltab2x32(:,:,1013))
  call Hloop_A_Q(ntryL,G1H8(739),42,nMT,G2H8(532),n2h8(1695))
  call Hloop_QA_V(ntryL,G1H32(540),wf4(:,15),G1H8(744),m3h4x8(:,205),heltab2x32(:,:,1014))
  call Hloop_AQ_V(ntryL,G1H32(541),ex1(:),G1H16(651),m3h2x16(:,732),heltab2x32(:,:,1015))
  call Hloop_VQ_A(ntryL,G1H32(542),ex1(:),G1H16(652),m3h2x16(:,733),heltab2x32(:,:,1016))
  call Hloop_Q_A(ntryL,G1H16(652),33,nMT,G2H16(20),n2h16(873))
  call Hloop_AQ_V(ntryL,G1H32(543),ex1(:),G1H16(653),m3h2x16(:,734),heltab2x32(:,:,1017))
  call Hloop_VQ_A(ntryL,G1H32(544),ex1(:),G1H16(654),m3h2x16(:,735),heltab2x32(:,:,1018))
  call Hloop_Q_A(ntryL,G1H16(654),33,nMT,G2H16(21),n2h16(874))
  call Hloop_QA_V(ntryL,G1H32(545),wf4(:,15),G1H8(734),m3h4x8(:,206),heltab2x32(:,:,1019))
  call Hloop_VA_Q(ntryL,G1H32(546),wf4(:,15),G1H8(743),m3h4x8(:,207),heltab2x32(:,:,1020))
  call Hloop_A_Q(ntryL,G1H8(743),42,nMT,G2H8(535),n2h8(1696))
  call Hloop_UV_W(ntryL,G0H16(232),33,ex3(:),4,G1H8(745),m3h2x8(:,1373),heltab2x16(:,:,1706))
  call Hloop_VA_Q(ntryL,G0H16(233),wf4(:,15),G0H4(18),m3h4x4(:,334),heltab2x16(:,:,1707))
  call Hloop_A_Q(ntryL,G0H4(18),43,nMT,G1H4(231),n2h4(2219))
  call Hloop_QA_V(ntryL,G1H16(331),wf4(:,15),G1H4(569),m3h4x4(:,335),heltab2x16(:,:,1708))
  call Hloop_UV_W(ntryL,G0H16(234),33,ex3(:),4,G1H8(752),m3h2x8(:,1374),heltab2x16(:,:,1709))
  call Hloop_QA_V(ntryL,G1H16(334),wf4(:,15),G1H4(1531),m3h4x4(:,336),heltab2x16(:,:,1710))
  call Hloop_AQ_V(ntryL,G1H16(337),ex1(:),G1H8(755),m3h2x8(:,1375),heltab2x16(:,:,1711))
  call Hloop_AQ_V(ntryL,G1H16(338),ex1(:),G1H8(756),m3h2x8(:,1376),heltab2x16(:,:,1712))
  call Hloop_AV_Q(ntryL,G1H16(341),ex3(:),G1H8(769),m3h2x8(:,1377),heltab2x16(:,:,1713))
  call Hloop_A_Q(ntryL,G1H8(769),52,nMT,G2H8(537),n2h8(1697))
  call Hloop_AQ_V(ntryL,G1H16(344),ex1(:),G1H8(779),m3h2x8(:,1378),heltab2x16(:,:,1714))
  call Hloop_AQ_V(ntryL,G1H16(346),ex1(:),G1H8(775),m3h2x8(:,1379),heltab2x16(:,:,1715))
  call Hloop_AV_Q(ntryL,G1H32(551),ex3(:),G1H16(656),m3h2x16(:,736),heltab2x32(:,:,1021))
  call Hloop_A_Q(ntryL,G1H16(656),36,0,G2H16(22),n2h16(875))
  call Hloop_AV_Q(ntryL,G1H32(548),ex3(:),G1H16(657),m3h2x16(:,737),heltab2x32(:,:,1022))
  call Hloop_A_Q(ntryL,G1H16(657),36,nMT,G2H16(23),n2h16(876))
  call Hloop_QV_A(ntryL,G1H32(553),ex3(:),G1H16(658),m3h2x16(:,738),heltab2x32(:,:,1023))
  call Hloop_Q_A(ntryL,G1H16(658),36,0,G2H16(24),n2h16(877))
  call Hloop_QV_A(ntryL,G1H32(550),ex3(:),G1H16(311),m3h2x16(:,739),heltab2x32(:,:,1024))
  call Hloop_Q_A(ntryL,G1H16(311),36,nMT,G2H16(25),n2h16(878))
  call Hloop_AV_Q(ntryL,G1H32(552),ex3(:),G1H16(313),m3h2x16(:,740),heltab2x32(:,:,1025))
  call Hloop_A_Q(ntryL,G1H16(313),36,nMB,G2H16(26),n2h16(879))
  call Hloop_QV_A(ntryL,G1H32(554),ex3(:),G1H16(660),m3h2x16(:,741),heltab2x32(:,:,1026))
  call Hloop_Q_A(ntryL,G1H16(660),36,nMB,G2H16(27),n2h16(880))
  call Hloop_DV_C(ntryL,G1H32(555),32,ex3(:),G2H16(28),m3h2x16(:,742),heltab2x32(:,:,1027))
  call Hloop_CV_D(ntryL,G1H32(556),32,ex3(:),4,G2H16(29),m3h2x16(:,743),heltab2x32(:,:,1028))
  call Hloop_UV_W(ntryL,G1H32(557),32,ex3(:),4,G2H16(30),m3h2x16(:,744),heltab2x32(:,:,1029))
  call Hloop_AV_Q(ntryL,G1H32(562),wf8(:,20),G1H4(1532),m3h8x4(:,79),heltab2x32(:,:,1030))
  call Hloop_A_Q(ntryL,G1H4(1532),43,0,G2H4(1366),n2h4(2220))
  call Hloop_AV_Q(ntryL,G1H32(559),wf8(:,20),G1H4(1533),m3h8x4(:,80),heltab2x32(:,:,1031))
  call Hloop_A_Q(ntryL,G1H4(1533),43,nMT,G2H4(1367),n2h4(2221))
  call Hloop_QV_A(ntryL,G1H32(564),wf8(:,20),G1H4(1534),m3h8x4(:,81),heltab2x32(:,:,1032))
  call Hloop_Q_A(ntryL,G1H4(1534),43,0,G2H4(1368),n2h4(2222))
  call Hloop_QV_A(ntryL,G1H32(561),wf8(:,20),G1H4(1537),m3h8x4(:,82),heltab2x32(:,:,1033))
  call Hloop_Q_A(ntryL,G1H4(1537),43,nMT,G2H4(1370),n2h4(2223))
  call Hloop_AV_Q(ntryL,G1H32(563),wf8(:,20),G1H4(1538),m3h8x4(:,83),heltab2x32(:,:,1034))
  call Hloop_A_Q(ntryL,G1H4(1538),43,nMB,G2H4(1371),n2h4(2224))
  call Hloop_QV_A(ntryL,G1H32(565),wf8(:,20),G1H4(243),m3h8x4(:,84),heltab2x32(:,:,1035))
  call Hloop_Q_A(ntryL,G1H4(243),43,nMB,G2H4(1372),n2h4(2225))
  call Hloop_DV_C(ntryL,G1H32(566),32,wf8(:,20),G2H4(1374),m3h8x4(:,85),heltab2x32(:,:,1036))
  call Hloop_CV_D(ntryL,G1H32(567),32,wf8(:,20),11,G2H4(1375),m3h8x4(:,86),heltab2x32(:,:,1037))
  call Hloop_UV_W(ntryL,G1H32(568),32,wf8(:,20),11,G2H4(1376),m3h8x4(:,87),heltab2x32(:,:,1038))
  call Hloop_QV_A(ntryL,G1H32(573),ex3(:),G1H16(661),m3h2x16(:,745),heltab2x32(:,:,1039))
  call Hloop_Q_A(ntryL,G1H16(661),36,0,G2H16(31),n2h16(881))
  call Hloop_QV_A(ntryL,G1H32(570),ex3(:),G1H16(662),m3h2x16(:,746),heltab2x32(:,:,1040))
  call Hloop_Q_A(ntryL,G1H16(662),36,nMT,G2H16(32),n2h16(882))
  call Hloop_AV_Q(ntryL,G1H32(575),ex3(:),G1H16(663),m3h2x16(:,747),heltab2x32(:,:,1041))
  call Hloop_A_Q(ntryL,G1H16(663),36,0,G2H16(33),n2h16(883))
  call Hloop_AV_Q(ntryL,G1H32(572),ex3(:),G1H16(664),m3h2x16(:,748),heltab2x32(:,:,1042))
  call Hloop_A_Q(ntryL,G1H16(664),36,nMT,G2H16(34),n2h16(884))
  call Hloop_QV_A(ntryL,G1H32(574),ex3(:),G1H16(666),m3h2x16(:,749),heltab2x32(:,:,1043))
  call Hloop_Q_A(ntryL,G1H16(666),36,nMB,G2H16(35),n2h16(885))
  call Hloop_AV_Q(ntryL,G1H32(576),ex3(:),G1H16(667),m3h2x16(:,750),heltab2x32(:,:,1044))
  call Hloop_A_Q(ntryL,G1H16(667),36,nMB,G2H16(36),n2h16(886))
  call Hloop_CV_D(ntryL,G1H32(577),32,ex3(:),4,G2H16(37),m3h2x16(:,751),heltab2x32(:,:,1045))
  call Hloop_DV_C(ntryL,G1H32(578),32,ex3(:),G2H16(38),m3h2x16(:,752),heltab2x32(:,:,1046))
  call Hloop_UV_W(ntryL,G1H32(579),32,ex3(:),4,G2H16(39),m3h2x16(:,753),heltab2x32(:,:,1047))
  call Hloop_VQ_A(ntryL,G1H32(580),ex1(:),G1H16(668),m3h2x16(:,754),heltab2x32(:,:,1048))
  call Hloop_Q_A(ntryL,G1H16(668),33,nMT,G2H16(40),n2h16(887))
  call Hloop_AQ_V(ntryL,G1H32(581),ex1(:),G1H16(669),m3h2x16(:,755),heltab2x32(:,:,1049))
  call Hloop_QA_V(ntryL,G1H32(582),wf8(:,90),G1H4(244),m3h8x4(:,88),heltab2x32(:,:,1050))
  call Hloop_VA_Q(ntryL,G1H32(583),wf8(:,90),G1H4(1540),m3h8x4(:,89),heltab2x32(:,:,1051))
  call Hloop_A_Q(ntryL,G1H4(1540),46,nMT,G2H4(1378),n2h4(2226))
  call Hloop_AQ_V(ntryL,G1H32(584),ex1(:),G1H16(670),m3h2x16(:,756),heltab2x32(:,:,1052))
  call Hloop_VQ_A(ntryL,G1H32(585),ex1(:),G1H16(672),m3h2x16(:,757),heltab2x32(:,:,1053))
  call Hloop_Q_A(ntryL,G1H16(672),33,nMT,G2H16(41),n2h16(888))
  call Hloop_VQ_A(ntryL,G1H32(586),ex1(:),G1H16(673),m3h2x16(:,758),heltab2x32(:,:,1054))
  call Hloop_Q_A(ntryL,G1H16(673),33,nMT,G2H16(42),n2h16(889))
  call Hloop_AQ_V(ntryL,G1H32(587),ex1(:),G1H16(674),m3h2x16(:,759),heltab2x32(:,:,1055))
  call Hloop_AV_Q(ntryL,G1H32(588),ex3(:),G1H16(675),m3h2x16(:,760),heltab2x32(:,:,1056))
  call Hloop_A_Q(ntryL,G1H16(675),36,nMT,G2H16(43),n2h16(890))
  call Hloop_UV_W(ntryL,G1H32(589),32,ex3(:),4,G2H16(44),m3h2x16(:,761),heltab2x32(:,:,1057))
  call Hloop_AQ_V(ntryL,G1H32(590),ex1(:),G1H16(676),m3h2x16(:,762),heltab2x32(:,:,1058))
  call Hloop_VQ_A(ntryL,G1H32(591),ex1(:),G1H16(678),m3h2x16(:,763),heltab2x32(:,:,1059))
  call Hloop_Q_A(ntryL,G1H16(678),33,nMT,G2H16(45),n2h16(891))
  call Hloop_UV_W(ntryL,G0H8(136),42,ex3(:),4,G1H4(1541),m3h2x4(:,2314),heltab2x8(:,:,2783))
  call Hloop_VQ_A(ntryL,G0H8(137),ex1(:),G0H4(19),m3h2x4(:,2315),heltab2x8(:,:,2784))
  call Hloop_Q_A(ntryL,G0H4(19),43,nMT,G1H4(1542),n2h4(2227))
  call Hloop_AQ_V(ntryL,G1H8(123),ex1(:),G1H4(1543),m3h2x4(:,2316),heltab2x8(:,:,2785))
  call Hloop_VQ_A(ntryL,G0H8(138),ex1(:),G0H4(20),m3h2x4(:,2317),heltab2x8(:,:,2786))
  call Hloop_Q_A(ntryL,G0H4(20),43,nMT,G1H4(1546),n2h4(2228))
  call Hloop_AQ_V(ntryL,G1H8(135),ex1(:),G1H4(1547),m3h2x4(:,2318),heltab2x8(:,:,2787))
  call Hloop_QA_V(ntryL,G1H32(592),ex2(:),G1H16(679),m3h2x16(:,764),heltab2x32(:,:,1060))
  call Hloop_VA_Q(ntryL,G1H32(593),ex2(:),G1H16(680),m3h2x16(:,765),heltab2x32(:,:,1061))
  call Hloop_A_Q(ntryL,G1H16(680),34,nMT,G2H16(46),n2h16(892))
  call Hloop_QA_V(ntryL,G1H32(594),ex2(:),G1H16(41),m3h2x16(:,766),heltab2x32(:,:,1062))
  call Hloop_VA_Q(ntryL,G1H32(595),ex2(:),G1H16(318),m3h2x16(:,767),heltab2x32(:,:,1063))
  call Hloop_A_Q(ntryL,G1H16(318),34,nMT,G2H16(47),n2h16(893))
  call Hloop_QV_A(ntryL,G1H32(596),wf4(:,2),G1H8(776),m3h4x8(:,208),heltab2x32(:,:,1064))
  call Hloop_Q_A(ntryL,G1H8(776),44,nMT,G2H8(538),n2h8(1698))
  call Hloop_UV_W(ntryL,G1H32(597),32,wf4(:,2),12,G2H8(539),m3h4x8(:,209),heltab2x32(:,:,1065))
  call Hloop_AQ_V(ntryL,G1H32(598),ex1(:),G1H16(682),m3h2x16(:,768),heltab2x32(:,:,1066))
  call Hloop_VQ_A(ntryL,G1H32(599),ex1(:),G1H16(683),m3h2x16(:,769),heltab2x32(:,:,1067))
  call Hloop_Q_A(ntryL,G1H16(683),33,nMT,G2H16(48),n2h16(894))
  call Hloop_AQ_V(ntryL,G1H32(600),ex1(:),G1H16(684),m3h2x16(:,770),heltab2x32(:,:,1068))
  call Hloop_VQ_A(ntryL,G1H32(601),ex1(:),G1H16(685),m3h2x16(:,771),heltab2x32(:,:,1069))
  call Hloop_Q_A(ntryL,G1H16(685),33,nMT,G2H16(243),n2h16(895))
  call Hloop_AV_Q(ntryL,G1H32(602),wf4(:,2),G1H8(780),m3h4x8(:,210),heltab2x32(:,:,1070))
  call Hloop_A_Q(ntryL,G1H8(780),44,nMT,G2H8(541),n2h8(1699))
  call Hloop_UV_W(ntryL,G1H32(603),32,wf4(:,2),12,G2H8(542),m3h4x8(:,211),heltab2x32(:,:,1071))
  call Hloop_VA_Q(ntryL,G0H16(235),ex2(:),G0H8(145),m3h2x8(:,1380),heltab2x16(:,:,1716))
  call Hloop_A_Q(ntryL,G0H8(145),35,nMT,G1H8(793),n2h8(1700))
  call Hloop_QA_V(ntryL,G1H16(348),ex2(:),G1H8(788),m3h2x8(:,1381),heltab2x16(:,:,1717))
  call Hloop_UV_W(ntryL,G0H16(236),33,wf4(:,2),12,G1H4(255),m3h4x4(:,337),heltab2x16(:,:,1718))
  call Hloop_VA_Q(ntryL,G0H16(237),ex2(:),G0H8(66),m3h2x8(:,1382),heltab2x16(:,:,1719))
  call Hloop_A_Q(ntryL,G0H8(66),35,nMT,G1H8(791),n2h8(1701))
  call Hloop_QA_V(ntryL,G1H16(350),ex2(:),G1H8(800),m3h2x8(:,1383),heltab2x16(:,:,1720))
  call Hloop_VQ_A(ntryL,G0H16(238),ex1(:),G0H8(65),m3h2x8(:,1384),heltab2x16(:,:,1721))
  call Hloop_Q_A(ntryL,G0H8(65),35,nMT,G1H8(812),n2h8(1702))
  call Hloop_AQ_V(ntryL,G1H16(352),ex1(:),G1H8(811),m3h2x8(:,1385),heltab2x16(:,:,1722))
  call Hloop_UV_W(ntryL,G0H16(239),34,wf4(:,2),12,G1H4(256),m3h4x4(:,338),heltab2x16(:,:,1723))
  call Hloop_VQ_A(ntryL,G0H16(240),ex1(:),G0H8(64),m3h2x8(:,1386),heltab2x16(:,:,1724))
  call Hloop_Q_A(ntryL,G0H8(64),35,nMT,G1H8(810),n2h8(1703))
  call Hloop_AQ_V(ntryL,G1H16(354),ex1(:),G1H8(816),m3h2x8(:,1387),heltab2x16(:,:,1725))
  call Hloop_QA_V(ntryL,G1H16(355),ex2(:),G1H8(823),m3h2x8(:,1388),heltab2x16(:,:,1726))
  call Hloop_AQ_V(ntryL,G1H16(358),ex1(:),G1H8(829),m3h2x8(:,1389),heltab2x16(:,:,1727))
  call Hloop_AQ_V(ntryL,G1H16(361),ex1(:),G1H8(827),m3h2x8(:,1390),heltab2x16(:,:,1728))
  call Hloop_VA_Q(ntryL,G1H32(604),ex2(:),G1H16(686),m3h2x16(:,772),heltab2x32(:,:,1072))
  call Hloop_A_Q(ntryL,G1H16(686),34,nMT,G2H16(244),n2h16(896))
  call Hloop_QA_V(ntryL,G1H32(605),ex2(:),G1H16(688),m3h2x16(:,773),heltab2x32(:,:,1073))
  call Hloop_AQ_V(ntryL,G1H32(606),wf8(:,100),G1H4(1549),m3h8x4(:,90),heltab2x32(:,:,1074))
  call Hloop_VQ_A(ntryL,G1H32(607),wf8(:,100),G1H4(1550),m3h8x4(:,91),heltab2x32(:,:,1075))
  call Hloop_Q_A(ntryL,G1H4(1550),45,nMT,G2H4(1379),n2h4(2229))
  call Hloop_QA_V(ntryL,G1H32(608),ex2(:),G1H16(689),m3h2x16(:,774),heltab2x32(:,:,1076))
  call Hloop_VA_Q(ntryL,G1H32(609),ex2(:),G1H16(690),m3h2x16(:,775),heltab2x32(:,:,1077))
  call Hloop_A_Q(ntryL,G1H16(690),34,nMT,G2H16(245),n2h16(897))
  call Hloop_VQ_A(ntryL,G1H32(610),ex1(:),G1H16(323),m3h2x16(:,776),heltab2x32(:,:,1078))
  call Hloop_Q_A(ntryL,G1H16(323),33,nMT,G2H16(246),n2h16(898))
  call Hloop_AQ_V(ntryL,G1H32(611),ex1(:),G1H16(324),m3h2x16(:,777),heltab2x32(:,:,1079))
  call Hloop_QA_V(ntryL,G1H32(612),wf8(:,98),G1H4(267),m3h8x4(:,92),heltab2x32(:,:,1080))
  call Hloop_VA_Q(ntryL,G1H32(613),wf8(:,98),G1H4(593),m3h8x4(:,93),heltab2x32(:,:,1081))
  call Hloop_A_Q(ntryL,G1H4(593),46,nMT,G2H4(1383),n2h4(2230))
  call Hloop_AQ_V(ntryL,G1H32(614),ex1(:),G1H16(692),m3h2x16(:,778),heltab2x32(:,:,1082))
  call Hloop_VQ_A(ntryL,G1H32(615),ex1(:),G1H16(693),m3h2x16(:,779),heltab2x32(:,:,1083))
  call Hloop_Q_A(ntryL,G1H16(693),33,nMT,G2H16(247),n2h16(899))
  call Hloop_AQ_V(ntryL,G1H32(616),ex1(:),G1H16(694),m3h2x16(:,780),heltab2x32(:,:,1084))
  call Hloop_VQ_A(ntryL,G1H32(617),ex1(:),G1H16(695),m3h2x16(:,781),heltab2x32(:,:,1085))



end subroutine vamp_19

end module ol_vamp_19_ppttjj_ttxgggg_1_/**/REALKIND
