
module ol_vamp_17_ppttjj_ttxgggg_1_/**/REALKIND
contains

! **********************************************************************
subroutine vamp_17(M)
! P(0:3,nlegs) = incoming external momenta
! Uses tree structures 'wf', factors 'c', and denominators 'den' from loop_ppttjj_ttxgggg_1.
! Sets colour stripped amplitudes A from the module loop_amplitudes_ppttjj_ttxgggg_1.
! **********************************************************************
  use KIND_TYPES, only: REALKIND, QREALKIND, intkind2
  use ol_parameters_decl_/**/DREALKIND, only: l_switch
  use ol_parameters_decl_/**/QREALKIND ! masses
  use ol_vert_interface_/**/REALKIND
  use ol_prop_interface_/**/REALKIND
  use ol_last_step_/**/REALKIND
  use ol_tables_storage_ppttjj_ttxgggg_1_/**/DREALKIND
  use ol_tensor_sum_storage_ppttjj_ttxgggg_1_/**/REALKIND
  use ol_loop_handling_/**/REALKIND
  use ofred_reduction_/**/REALKIND, only: Hotf_4pt_reduction, Hotf_4pt_reduction_last
  use ofred_reduction_/**/REALKIND, only: Hotf_5pt_reduction, Hotf_5pt_reduction_last
  use ol_loop_reduction_/**/REALKIND, only: TI_bubble_red, TI_triangle_red
use ol_loop_reduction_/**/REALKIND, only: compute_scalar_box

  use ol_loop_storage_ppttjj_ttxgggg_1_/**/REALKIND
#ifndef PRECISION_dp
  use ol_loop_storage_ppttjj_ttxgggg_1_/**/DREALKIND, only: &
    & ntryL, p_switch, Hel, merge_step, merge_mism, merge_tables, merge_hels
#endif
  use hol_initialisation_/**/REALKIND, only: G0_hol_initialisation
  use ol_h_vert_interface_/**/REALKIND
  use ol_h_prop_interface_/**/REALKIND
  use ol_h_last_step_/**/REALKIND
  use ol_merging_/**/REALKIND, only: ol_merge, ol_merge_tensors, ol_merge_last

  implicit none

  type(Hpolcont) :: Gcoeff(64)
  type(Hpolcont), intent(in) :: M(50,64)


#ifndef PRECISION_dp
  if (ntryL==1 .OR. p_switch == 1) Gcoeff(:)%hf = Hel
#else
  if (ntryL==1 .OR. p_switch == 2) Gcoeff(:)%hf = Hel
#endif

  ! =============================================
  Gcoeff(:)%j = (c(9)*M(6,:)%j+c(6)*(M(31,:)%j+M(33,:)%j+M(35,:)%j-M(43,:)%j)) * den(24)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(977),h0tab(:,977),[48,6,1,8],[0,nMT,0,0],5,1,wf4(:,11))
  call Hloop_GGG_G_12(ntryL,G0H64(1),ex5(:),ex6(:),G0H16(72),m4h2x2x16(:,209),heltab3x64(:,:,218))
  Gcoeff(:)%j = (c(9)*(-M(4,:)%j+M(6,:)%j)+c(6)*(-M(43,:)%j+M(44,:)%j)) * den(24)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(978),h0tab(:,978),[48,6,1,8],[0,nMT,0,0],5,1,wf4(:,11))
  call Hloop_GGG_G_23(ntryL,G0H64(1),ex6(:),ex5(:),G0H16(71),m4h2x2x16(:,210),heltab3x64(:,:,219))
  Gcoeff(:)%j = (c(16)*(-M(31,:)%j-M(33,:)%j+M(43,:)%j)) * den(24)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(979),h0tab(:,979),[48,1,8,6],[0,nMT,nMT,0],5,1,wf4(:,11))
  call Hloop_GGG_G_12(ntryL,G0H64(1),ex6(:),ex5(:),G0H16(70),m4h2x2x16(:,211),heltab3x64(:,:,220))
  Gcoeff(:)%j = (c(16)*(-M(31,:)%j-M(33,:)%j+M(44,:)%j)) * den(24)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(980),h0tab(:,980),[48,1,8,6],[0,nMT,nMT,0],5,1,wf4(:,11))
  call Hloop_GGG_G_12(ntryL,G0H64(1),ex5(:),ex6(:),G0H16(102),m4h2x2x16(:,212),heltab3x64(:,:,221))
  Gcoeff(:)%j = (c(16)*(-M(43,:)%j+M(44,:)%j)) * den(24)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(981),h0tab(:,981),[48,1,8,6],[0,nMT,nMT,0],5,1,wf4(:,11))
  call Hloop_GGG_G_23(ntryL,G0H64(1),ex6(:),ex5(:),G0H16(101),m4h2x2x16(:,213),heltab3x64(:,:,222))
  Gcoeff(:)%j = (-(c(9)*M(2,:)%j)+c(6)*(-M(31,:)%j-M(33,:)%j-M(35,:)%j+M(43,:)%j)) * den(24)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(982),h0tab(:,982),[48,1,6,8],[0,nMT,0,0],5,1,wf4(:,11))
  call Hloop_GGG_G_12(ntryL,G0H64(1),ex6(:),ex5(:),G0H16(100),m4h2x2x16(:,214),heltab3x64(:,:,223))
  Gcoeff(:)%j = (-(c(9)*M(1,:)%j)+c(6)*(-M(31,:)%j-M(33,:)%j-M(35,:)%j+M(44,:)%j)) * den(24)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(983),h0tab(:,983),[48,1,6,8],[0,nMT,0,0],5,1,wf4(:,11))
  call Hloop_GGG_G_12(ntryL,G0H64(1),ex5(:),ex6(:),G0H16(108),m4h2x2x16(:,215),heltab3x64(:,:,224))
  Gcoeff(:)%j = (c(9)*(-M(1,:)%j+M(2,:)%j)+c(6)*(-M(43,:)%j+M(44,:)%j)) * den(24)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(984),h0tab(:,984),[48,1,6,8],[0,nMT,0,0],5,1,wf4(:,11))
  call Hloop_GGG_G_23(ntryL,G0H64(1),ex6(:),ex5(:),G0H16(107),m4h2x2x16(:,216),heltab3x64(:,:,225))
  Gcoeff(:)%j = (c(9)*M(2,:)%j+c(6)*(M(31,:)%j+M(33,:)%j+M(35,:)%j-M(43,:)%j)) * den(24)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(985),h0tab(:,985),[40,6,1,16],[0,nMT,0,0],5,1,wf4(:,11))
  call Hloop_GGG_G_12(ntryL,G0H64(1),ex6(:),ex4(:),G0H16(106),m4h2x2x16(:,217),heltab3x64(:,:,226))
  Gcoeff(:)%j = (c(9)*M(5,:)%j+c(6)*(M(31,:)%j+M(33,:)%j+M(35,:)%j-M(44,:)%j)) * den(24)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(986),h0tab(:,986),[40,6,1,16],[0,nMT,0,0],5,1,wf4(:,11))
  call Hloop_GGG_G_12(ntryL,G0H64(1),ex4(:),ex6(:),G0H16(109),m4h2x2x16(:,218),heltab3x64(:,:,227))
  Gcoeff(:)%j = (c(9)*(-M(2,:)%j+M(5,:)%j)+c(6)*(M(43,:)%j-M(44,:)%j)) * den(24)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(987),h0tab(:,987),[40,6,1,16],[0,nMT,0,0],5,1,wf4(:,11))
  call Hloop_GGG_G_23(ntryL,G0H64(1),ex6(:),ex4(:),G0H16(110),m4h2x2x16(:,219),heltab3x64(:,:,228))
  Gcoeff(:)%j = (c(16)*(-M(31,:)%j-M(35,:)%j+M(44,:)%j)) * den(24)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(988),h0tab(:,988),[40,1,16,6],[0,nMT,nMT,0],5,1,wf4(:,11))
  call Hloop_GGG_G_12(ntryL,G0H64(1),ex6(:),ex4(:),G0H16(111),m4h2x2x16(:,220),heltab3x64(:,:,229))
  Gcoeff(:)%j = (c(16)*(-M(31,:)%j-M(35,:)%j+M(43,:)%j)) * den(24)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(989),h0tab(:,989),[40,1,16,6],[0,nMT,nMT,0],5,1,wf4(:,11))
  call Hloop_GGG_G_12(ntryL,G0H64(1),ex4(:),ex6(:),G0H16(112),m4h2x2x16(:,221),heltab3x64(:,:,230))
  Gcoeff(:)%j = (c(16)*(M(43,:)%j-M(44,:)%j)) * den(24)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(990),h0tab(:,990),[40,1,16,6],[0,nMT,nMT,0],5,1,wf4(:,11))
  call Hloop_GGG_G_23(ntryL,G0H64(1),ex6(:),ex4(:),G0H16(113),m4h2x2x16(:,222),heltab3x64(:,:,231))
  Gcoeff(:)%j = (-(c(9)*M(4,:)%j)+c(6)*(-M(31,:)%j-M(33,:)%j-M(35,:)%j+M(44,:)%j)) * den(24)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(991),h0tab(:,991),[40,1,6,16],[0,nMT,0,0],5,1,wf4(:,11))
  call Hloop_GGG_G_12(ntryL,G0H64(1),ex6(:),ex4(:),G0H16(114),m4h2x2x16(:,223),heltab3x64(:,:,232))
  Gcoeff(:)%j = (-(c(9)*M(3,:)%j)+c(6)*(-M(31,:)%j-M(33,:)%j-M(35,:)%j+M(43,:)%j)) * den(24)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(992),h0tab(:,992),[40,1,6,16],[0,nMT,0,0],5,1,wf4(:,11))
  call Hloop_GGG_G_12(ntryL,G0H64(1),ex4(:),ex6(:),G0H16(115),m4h2x2x16(:,224),heltab3x64(:,:,233))
  Gcoeff(:)%j = (c(9)*(-M(3,:)%j+M(4,:)%j)+c(6)*(M(43,:)%j-M(44,:)%j)) * den(24)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(993),h0tab(:,993),[40,1,6,16],[0,nMT,0,0],5,1,wf4(:,11))
  call Hloop_GGG_G_23(ntryL,G0H64(1),ex6(:),ex4(:),G0H16(116),m4h2x2x16(:,225),heltab3x64(:,:,234))
  Gcoeff(:)%j = (-(c(9)*M(3,:)%j)+c(6)*(-M(31,:)%j-M(33,:)%j-M(35,:)%j+M(43,:)%j)) * den(24)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(994),h0tab(:,994),[32,1,6,24],[0,nMT,0,0],5,1,wf4(:,11))
  call Hloop_UV_W(ntryL,G0H64(1),0,ex6(:),32,G1H32(40),m3h2x32(:,640),heltab2x64(:,:,760))
  Gcoeff(:)%j = (-(c(9)*M(1,:)%j)+c(6)*(-M(31,:)%j-M(33,:)%j-M(35,:)%j+M(44,:)%j)) * den(24)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(995),h0tab(:,995),[32,1,6,24],[0,nMT,0,0],5,1,wf4(:,11))
  call Hloop_UV_W(ntryL,G0H64(1),0,ex6(:),32,G1H32(41),m3h2x32(:,641),heltab2x64(:,:,761))
  Gcoeff(:)%j = (c(9)*(-M(1,:)%j+M(3,:)%j)+c(6)*(-M(43,:)%j+M(44,:)%j)) * den(24)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(996),h0tab(:,996),[32,1,6,24],[0,nMT,0,0],5,1,wf4(:,11))
  call Hloop_UV_W(ntryL,G0H64(1),0,ex6(:),32,G1H32(42),m3h2x32(:,642),heltab2x64(:,:,762))
  Gcoeff(:)%j = (c(16)*(-M(33,:)%j-M(35,:)%j+M(44,:)%j)) * den(24)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(997),h0tab(:,997),[32,1,24,6],[nMT,0,0,nMT],5,1,wf4(:,11))
  call Hloop_AV_Q(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,643),heltab2x64(:,:,763))
  call Hloop_A_Q(ntryL,G0H32(1),32,nMT,G1H32(43),n2h32(304))
  Gcoeff(:)%j = (c(16)*(-M(33,:)%j-M(35,:)%j+M(43,:)%j)) * den(24)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(998),h0tab(:,998),[32,1,24,6],[nMT,0,0,nMT],5,1,wf4(:,11))
  call Hloop_AV_Q(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,644),heltab2x64(:,:,764))
  call Hloop_A_Q(ntryL,G0H32(1),32,nMT,G1H32(44),n2h32(305))
  Gcoeff(:)%j = (c(16)*(M(43,:)%j-M(44,:)%j)) * den(24)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(999),h0tab(:,999),[32,1,24,6],[nMT,0,0,nMT],5,1,wf4(:,11))
  call Hloop_AV_Q(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,645),heltab2x64(:,:,765))
  call Hloop_A_Q(ntryL,G0H32(1),32,nMT,G1H32(45),n2h32(306))
  Gcoeff(:)%j = (c(9)*M(5,:)%j+c(6)*(M(31,:)%j+M(33,:)%j+M(35,:)%j-M(44,:)%j)) * den(24)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(1000),h0tab(:,1000),[32,6,1,24],[0,nMT,0,0],5,1,wf4(:,11))
  call Hloop_UV_W(ntryL,G0H64(1),0,ex6(:),32,G1H32(46),m3h2x32(:,646),heltab2x64(:,:,766))
  Gcoeff(:)%j = (c(9)*M(6,:)%j+c(6)*(M(31,:)%j+M(33,:)%j+M(35,:)%j-M(43,:)%j)) * den(24)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(1001),h0tab(:,1001),[32,6,1,24],[0,nMT,0,0],5,1,wf4(:,11))
  call Hloop_UV_W(ntryL,G0H64(1),0,ex6(:),32,G1H32(47),m3h2x32(:,647),heltab2x64(:,:,767))
  Gcoeff(:)%j = (c(9)*(-M(5,:)%j+M(6,:)%j)+c(6)*(-M(43,:)%j+M(44,:)%j)) * den(24)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(1002),h0tab(:,1002),[32,6,1,24],[0,nMT,0,0],5,1,wf4(:,11))
  call Hloop_UV_W(ntryL,G0H64(1),0,ex6(:),32,G1H32(48),m3h2x32(:,648),heltab2x64(:,:,768))
  Gcoeff(:)%j = (c(9)*M(4,:)%j+c(6)*(M(28,:)%j+M(30,:)%j+M(35,:)%j-M(42,:)%j)) * den(26)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(1003),h0tab(:,1003),[48,4,2,9],[0,0,nMT,0],5,1,wf4(:,13))
  call Hloop_GGG_G_12(ntryL,G0H64(1),ex6(:),ex5(:),G0H16(117),m4h2x2x16(:,226),heltab3x64(:,:,235))
  Gcoeff(:)%j = (c(9)*M(6,:)%j+c(6)*(M(28,:)%j+M(30,:)%j+M(35,:)%j-M(40,:)%j)) * den(26)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(1004),h0tab(:,1004),[48,4,2,9],[0,0,nMT,0],5,1,wf4(:,13))
  call Hloop_GGG_G_12(ntryL,G0H64(1),ex5(:),ex6(:),G0H16(118),m4h2x2x16(:,227),heltab3x64(:,:,236))
  Gcoeff(:)%j = (c(9)*(-M(4,:)%j+M(6,:)%j)+c(6)*(-M(40,:)%j+M(42,:)%j)) * den(26)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(1005),h0tab(:,1005),[48,4,2,9],[0,0,nMT,0],5,1,wf4(:,13))
  call Hloop_GGG_G_23(ntryL,G0H64(1),ex6(:),ex5(:),G0H16(119),m4h2x2x16(:,228),heltab3x64(:,:,237))
  Gcoeff(:)%j = (c(16)*(-M(28,:)%j-M(30,:)%j+M(42,:)%j)) * den(26)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(1006),h0tab(:,1006),[48,2,4,9],[0,nMT,nMT,0],5,1,wf4(:,13))
  call Hloop_GGG_G_12(ntryL,G0H64(1),ex6(:),ex5(:),G0H16(120),m4h2x2x16(:,229),heltab3x64(:,:,238))
  Gcoeff(:)%j = (c(16)*(-M(28,:)%j-M(30,:)%j+M(40,:)%j)) * den(26)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(1007),h0tab(:,1007),[48,2,4,9],[0,nMT,nMT,0],5,1,wf4(:,13))
  call Hloop_GGG_G_12(ntryL,G0H64(1),ex5(:),ex6(:),G0H16(121),m4h2x2x16(:,230),heltab3x64(:,:,239))
  Gcoeff(:)%j = (c(16)*(M(40,:)%j-M(42,:)%j)) * den(26)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(1008),h0tab(:,1008),[48,2,4,9],[0,nMT,nMT,0],5,1,wf4(:,13))
  call Hloop_GGG_G_23(ntryL,G0H64(1),ex6(:),ex5(:),G0H16(122),m4h2x2x16(:,231),heltab3x64(:,:,240))
  Gcoeff(:)%j = (c(9)*M(17,:)%j+c(6)*(M(28,:)%j+M(30,:)%j+M(35,:)%j-M(42,:)%j)) * den(26)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(1009),h0tab(:,1009),[48,2,9,4],[0,nMT,0,0],5,1,wf4(:,13))
  call Hloop_GGG_G_12(ntryL,G0H64(1),ex6(:),ex5(:),G0H16(123),m4h2x2x16(:,232),heltab3x64(:,:,241))
  Gcoeff(:)%j = (c(9)*M(23,:)%j+c(6)*(M(28,:)%j+M(30,:)%j+M(35,:)%j-M(40,:)%j)) * den(26)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(1010),h0tab(:,1010),[48,2,9,4],[0,nMT,0,0],5,1,wf4(:,13))
  call Hloop_GGG_G_12(ntryL,G0H64(1),ex5(:),ex6(:),G0H16(124),m4h2x2x16(:,233),heltab3x64(:,:,242))
  Gcoeff(:)%j = (c(9)*(-M(17,:)%j+M(23,:)%j)+c(6)*(-M(40,:)%j+M(42,:)%j)) * den(26)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(1011),h0tab(:,1011),[48,2,9,4],[0,nMT,0,0],5,1,wf4(:,13))
  call Hloop_GGG_G_23(ntryL,G0H64(1),ex6(:),ex5(:),G0H16(125),m4h2x2x16(:,234),heltab3x64(:,:,243))
  Gcoeff(:)%j = (-(c(9)*M(12,:)%j)+c(6)*(-M(27,:)%j-M(29,:)%j-M(36,:)%j+M(40,:)%j)) * den(28)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(1012),h0tab(:,1012),[48,4,1,10],[0,0,nMT,0],5,1,wf4(:,15))
  call Hloop_GGG_G_12(ntryL,G0H64(1),ex6(:),ex5(:),G0H16(126),m4h2x2x16(:,235),heltab3x64(:,:,244))
  Gcoeff(:)%j = (-(c(9)*M(10,:)%j)+c(6)*(-M(27,:)%j-M(29,:)%j-M(36,:)%j+M(42,:)%j)) * den(28)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(1013),h0tab(:,1013),[48,4,1,10],[0,0,nMT,0],5,1,wf4(:,15))
  call Hloop_GGG_G_12(ntryL,G0H64(1),ex5(:),ex6(:),G0H16(127),m4h2x2x16(:,236),heltab3x64(:,:,245))
  Gcoeff(:)%j = (c(9)*(-M(10,:)%j+M(12,:)%j)+c(6)*(-M(40,:)%j+M(42,:)%j)) * den(28)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(1014),h0tab(:,1014),[48,4,1,10],[0,0,nMT,0],5,1,wf4(:,15))
  call Hloop_GGG_G_23(ntryL,G0H64(1),ex6(:),ex5(:),G0H16(128),m4h2x2x16(:,237),heltab3x64(:,:,246))
  Gcoeff(:)%j = (c(16)*(-M(27,:)%j-M(29,:)%j+M(40,:)%j)) * den(28)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(1015),h0tab(:,1015),[48,1,4,10],[0,nMT,nMT,0],5,1,wf4(:,15))
  call Hloop_GGG_G_12(ntryL,G0H64(1),ex6(:),ex5(:),G0H16(129),m4h2x2x16(:,238),heltab3x64(:,:,247))
  Gcoeff(:)%j = (c(16)*(-M(27,:)%j-M(29,:)%j+M(42,:)%j)) * den(28)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(1016),h0tab(:,1016),[48,1,4,10],[0,nMT,nMT,0],5,1,wf4(:,15))
  call Hloop_GGG_G_12(ntryL,G0H64(1),ex5(:),ex6(:),G0H16(130),m4h2x2x16(:,239),heltab3x64(:,:,248))
  Gcoeff(:)%j = (c(16)*(-M(40,:)%j+M(42,:)%j)) * den(28)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(1017),h0tab(:,1017),[48,1,4,10],[0,nMT,nMT,0],5,1,wf4(:,15))
  call Hloop_GGG_G_23(ntryL,G0H64(1),ex6(:),ex5(:),G0H16(131),m4h2x2x16(:,240),heltab3x64(:,:,249))
  Gcoeff(:)%j = (-(c(9)*M(8,:)%j)+c(6)*(-M(27,:)%j-M(29,:)%j-M(36,:)%j+M(40,:)%j)) * den(28)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(1018),h0tab(:,1018),[48,1,10,4],[0,nMT,0,0],5,1,wf4(:,15))
  call Hloop_GGG_G_12(ntryL,G0H64(1),ex6(:),ex5(:),G0H16(132),m4h2x2x16(:,241),heltab3x64(:,:,250))
  Gcoeff(:)%j = (-(c(9)*M(7,:)%j)+c(6)*(-M(27,:)%j-M(29,:)%j-M(36,:)%j+M(42,:)%j)) * den(28)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(1019),h0tab(:,1019),[48,1,10,4],[0,nMT,0,0],5,1,wf4(:,15))
  call Hloop_GGG_G_12(ntryL,G0H64(1),ex5(:),ex6(:),G0H16(134),m4h2x2x16(:,242),heltab3x64(:,:,251))
  Gcoeff(:)%j = (c(9)*(-M(7,:)%j+M(8,:)%j)+c(6)*(-M(40,:)%j+M(42,:)%j)) * den(28)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(1020),h0tab(:,1020),[48,1,10,4],[0,nMT,0,0],5,1,wf4(:,15))
  call Hloop_GGG_G_23(ntryL,G0H64(1),ex6(:),ex5(:),G0H16(135),m4h2x2x16(:,243),heltab3x64(:,:,252))
  Gcoeff(:)%j = (c(19)*(-M(2,:)%j+M(8,:)%j)+c(16)*(-M(35,:)%j+M(36,:)%j-M(37,:)%j-M(38,:)%j+M(39,:)%j+M(41,:)%j+M(45,:)%j &
    -M(48,:)%j)) * den(2)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(1021),h0tab(:,1021),[44,2,1,16],[0,nMT,0,0],5,1,wf4(:,2))
  call Hloop_GGG_G_12(ntryL,G0H64(1),ex6(:),wf4(:,2),G0H8(10),m4h2x4x8(:,7),heltab3x64(:,:,253))
  Gcoeff(:)%j = (c(19)*(-M(19,:)%j+M(21,:)%j)+c(16)*(-M(35,:)%j+M(36,:)%j-M(37,:)%j-M(38,:)%j+M(39,:)%j+M(41,:)%j+M(46,:)%j &
    -M(50,:)%j)) * den(2)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(1022),h0tab(:,1022),[44,2,1,16],[0,nMT,0,0],5,1,wf4(:,2))
  call Hloop_GGG_G_12(ntryL,G0H64(1),wf4(:,2),ex6(:),G0H8(11),m4h4x2x8(:,4),heltab3x64(:,:,254))
  Gcoeff(:)%j = (c(19)*(M(2,:)%j-M(8,:)%j-M(19,:)%j+M(21,:)%j)+c(16)*(-M(45,:)%j+M(46,:)%j+M(48,:)%j-M(50,:)%j)) * den(2)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(1023),h0tab(:,1023),[44,2,1,16],[0,nMT,0,0],5,1,wf4(:,2))
  call Hloop_GGG_G_23(ntryL,G0H64(1),ex6(:),wf4(:,2),G0H8(12),m4h2x4x8(:,8),heltab3x64(:,:,255))
  Gcoeff(:)%j = (c(19)*(M(17,:)%j-M(18,:)%j)+c(16)*(M(35,:)%j-M(36,:)%j+M(37,:)%j+M(38,:)%j-M(39,:)%j-M(41,:)%j-M(46,:)%j &
    +M(50,:)%j)) * den(2)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(1024),h0tab(:,1024),[44,1,2,16],[0,nMT,0,0],5,1,wf4(:,2))
  call Hloop_GGG_G_12(ntryL,G0H64(1),ex6(:),wf4(:,2),G0H8(13),m4h2x4x8(:,9),heltab3x64(:,:,256))
  Gcoeff(:)%j = (c(19)*(M(13,:)%j-M(15,:)%j)+c(16)*(M(35,:)%j-M(36,:)%j+M(37,:)%j+M(38,:)%j-M(39,:)%j-M(41,:)%j-M(45,:)%j &
    +M(48,:)%j)) * den(2)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(1025),h0tab(:,1025),[44,1,2,16],[0,nMT,0,0],5,1,wf4(:,2))
  call Hloop_GGG_G_12(ntryL,G0H64(1),wf4(:,2),ex6(:),G0H8(14),m4h4x2x8(:,5),heltab3x64(:,:,257))
  Gcoeff(:)%j = (c(19)*(M(13,:)%j-M(15,:)%j-M(17,:)%j+M(18,:)%j)+c(16)*(-M(45,:)%j+M(46,:)%j+M(48,:)%j-M(50,:)%j)) * den(2)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(1026),h0tab(:,1026),[44,1,2,16],[0,nMT,0,0],5,1,wf4(:,2))
  call Hloop_GGG_G_23(ntryL,G0H64(1),ex6(:),wf4(:,2),G0H8(15),m4h2x4x8(:,10),heltab3x64(:,:,258))
  Gcoeff(:)%j = (c(6)*(M(35,:)%j-M(36,:)%j+M(37,:)%j-M(39,:)%j-M(46,:)%j+M(50,:)%j)) * den(2)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(1027),h0tab(:,1027),[44,1,16,2],[0,nMT,nMT,0],5,1,wf4(:,2))
  call Hloop_GGG_G_12(ntryL,G0H64(1),ex6(:),wf4(:,2),G0H8(16),m4h2x4x8(:,11),heltab3x64(:,:,259))
  Gcoeff(:)%j = (c(6)*(M(35,:)%j-M(36,:)%j+M(37,:)%j-M(39,:)%j-M(45,:)%j+M(48,:)%j)) * den(2)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(1028),h0tab(:,1028),[44,1,16,2],[0,nMT,nMT,0],5,1,wf4(:,2))
  call Hloop_GGG_G_12(ntryL,G0H64(1),wf4(:,2),ex6(:),G0H8(17),m4h4x2x8(:,6),heltab3x64(:,:,260))
  Gcoeff(:)%j = (c(6)*(-M(45,:)%j+M(46,:)%j+M(48,:)%j-M(50,:)%j)) * den(2)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(1029),h0tab(:,1029),[44,1,16,2],[0,nMT,nMT,0],5,1,wf4(:,2))
  call Hloop_GGG_G_23(ntryL,G0H64(1),ex6(:),wf4(:,2),G0H8(18),m4h2x4x8(:,12),heltab3x64(:,:,261))
  Gcoeff(:)%j = (c(19)*(M(13,:)%j-M(15,:)%j)+c(16)*(M(35,:)%j-M(36,:)%j+M(37,:)%j+M(38,:)%j-M(39,:)%j-M(41,:)%j-M(45,:)%j &
    +M(48,:)%j)) * den(2)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(1030),h0tab(:,1030),[32,1,2,28],[0,nMT,0,0],5,1,wf4(:,2))
  call Hloop_UV_W(ntryL,G0H64(1),0,ex6(:),32,G1H32(49),m3h2x32(:,649),heltab2x64(:,:,769))
  Gcoeff(:)%j = (c(19)*(M(1,:)%j-M(7,:)%j)+c(16)*(M(35,:)%j-M(36,:)%j+M(37,:)%j+M(38,:)%j-M(39,:)%j-M(41,:)%j-M(46,:)%j &
    +M(50,:)%j)) * den(2)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(1031),h0tab(:,1031),[32,1,2,28],[0,nMT,0,0],5,1,wf4(:,2))
  call Hloop_UV_W(ntryL,G0H64(1),0,ex6(:),32,G1H32(50),m3h2x32(:,650),heltab2x64(:,:,770))
  Gcoeff(:)%j = (c(19)*(M(1,:)%j-M(7,:)%j-M(13,:)%j+M(15,:)%j)+c(16)*(M(45,:)%j-M(46,:)%j-M(48,:)%j+M(50,:)%j)) * den(2)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(1032),h0tab(:,1032),[32,1,2,28],[0,nMT,0,0],5,1,wf4(:,2))
  call Hloop_UV_W(ntryL,G0H64(1),0,ex6(:),32,G1H32(51),m3h2x32(:,651),heltab2x64(:,:,771))
  Gcoeff(:)%j = (c(19)*(-M(19,:)%j+M(21,:)%j)+c(16)*(-M(35,:)%j+M(36,:)%j-M(37,:)%j-M(38,:)%j+M(39,:)%j+M(41,:)%j+M(46,:)%j &
    -M(50,:)%j)) * den(2)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(1033),h0tab(:,1033),[32,2,1,28],[0,nMT,0,0],5,1,wf4(:,2))
  call Hloop_UV_W(ntryL,G0H64(1),0,ex6(:),32,G1H32(52),m3h2x32(:,652),heltab2x64(:,:,772))
  Gcoeff(:)%j = (c(19)*(-M(23,:)%j+M(24,:)%j)+c(16)*(-M(35,:)%j+M(36,:)%j-M(37,:)%j-M(38,:)%j+M(39,:)%j+M(41,:)%j+M(45,:)%j &
    -M(48,:)%j)) * den(2)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(1034),h0tab(:,1034),[32,2,1,28],[0,nMT,0,0],5,1,wf4(:,2))
  call Hloop_UV_W(ntryL,G0H64(1),0,ex6(:),32,G1H32(53),m3h2x32(:,653),heltab2x64(:,:,773))
  Gcoeff(:)%j = (c(19)*(M(19,:)%j-M(21,:)%j-M(23,:)%j+M(24,:)%j)+c(16)*(M(45,:)%j-M(46,:)%j-M(48,:)%j+M(50,:)%j)) * den(2)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(1035),h0tab(:,1035),[32,2,1,28],[0,nMT,0,0],5,1,wf4(:,2))
  call Hloop_UV_W(ntryL,G0H64(1),0,ex6(:),32,G1H32(54),m3h2x32(:,654),heltab2x64(:,:,774))
  Gcoeff(:)%j = (c(6)*(M(35,:)%j-M(36,:)%j+M(38,:)%j-M(41,:)%j-M(46,:)%j+M(50,:)%j)) * den(2)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(1036),h0tab(:,1036),[32,1,28,2],[nMT,0,0,nMT],5,1,wf4(:,2))
  call Hloop_AV_Q(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,655),heltab2x64(:,:,775))
  call Hloop_A_Q(ntryL,G0H32(1),32,nMT,G1H32(55),n2h32(307))
  Gcoeff(:)%j = (c(6)*(M(35,:)%j-M(36,:)%j+M(38,:)%j-M(41,:)%j-M(45,:)%j+M(48,:)%j)) * den(2)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(1037),h0tab(:,1037),[32,1,28,2],[nMT,0,0,nMT],5,1,wf4(:,2))
  call Hloop_AV_Q(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,656),heltab2x64(:,:,776))
  call Hloop_A_Q(ntryL,G0H32(1),32,nMT,G1H32(56),n2h32(308))
  Gcoeff(:)%j = (c(6)*(-M(45,:)%j+M(46,:)%j+M(48,:)%j-M(50,:)%j)) * den(2)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(1038),h0tab(:,1038),[32,1,28,2],[nMT,0,0,nMT],5,1,wf4(:,2))
  call Hloop_AV_Q(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,657),heltab2x64(:,:,777))
  call Hloop_A_Q(ntryL,G0H32(1),32,nMT,G1H32(57),n2h32(309))
  Gcoeff(:)%j = (c(19)*(-M(17,:)%j+M(18,:)%j)+c(16)*(-M(35,:)%j+M(36,:)%j-M(37,:)%j-M(38,:)%j+M(39,:)%j+M(41,:)%j+M(46,:)%j &
    -M(50,:)%j)) * den(2)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(1039),h0tab(:,1039),[48,2,1,12],[0,nMT,0,0],5,1,wf4(:,2))
  call Hloop_GGG_G_12(ntryL,G0H64(1),ex6(:),ex5(:),G0H16(136),m4h2x2x16(:,244),heltab3x64(:,:,262))
  Gcoeff(:)%j = (c(19)*(-M(23,:)%j+M(24,:)%j)+c(16)*(-M(35,:)%j+M(36,:)%j-M(37,:)%j-M(38,:)%j+M(39,:)%j+M(41,:)%j+M(45,:)%j &
    -M(48,:)%j)) * den(2)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(1040),h0tab(:,1040),[48,2,1,12],[0,nMT,0,0],5,1,wf4(:,2))
  call Hloop_GGG_G_12(ntryL,G0H64(1),ex5(:),ex6(:),G0H16(137),m4h2x2x16(:,245),heltab3x64(:,:,263))
  Gcoeff(:)%j = (c(19)*(M(17,:)%j-M(18,:)%j-M(23,:)%j+M(24,:)%j)+c(16)*(M(45,:)%j-M(46,:)%j-M(48,:)%j+M(50,:)%j)) * den(2)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(1041),h0tab(:,1041),[48,2,1,12],[0,nMT,0,0],5,1,wf4(:,2))
  call Hloop_GGG_G_23(ntryL,G0H64(1),ex6(:),ex5(:),G0H16(138),m4h2x2x16(:,246),heltab3x64(:,:,264))
  Gcoeff(:)%j = (c(19)*(M(2,:)%j-M(8,:)%j)+c(16)*(M(35,:)%j-M(36,:)%j+M(37,:)%j+M(38,:)%j-M(39,:)%j-M(41,:)%j-M(45,:)%j &
    +M(48,:)%j)) * den(2)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(1042),h0tab(:,1042),[48,1,2,12],[0,nMT,0,0],5,1,wf4(:,2))
  call Hloop_GGG_G_12(ntryL,G0H64(1),ex6(:),ex5(:),G0H16(139),m4h2x2x16(:,247),heltab3x64(:,:,265))
  Gcoeff(:)%j = (c(19)*(M(1,:)%j-M(7,:)%j)+c(16)*(M(35,:)%j-M(36,:)%j+M(37,:)%j+M(38,:)%j-M(39,:)%j-M(41,:)%j-M(46,:)%j &
    +M(50,:)%j)) * den(2)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(1043),h0tab(:,1043),[48,1,2,12],[0,nMT,0,0],5,1,wf4(:,2))
  call Hloop_GGG_G_12(ntryL,G0H64(1),ex5(:),ex6(:),G0H16(140),m4h2x2x16(:,248),heltab3x64(:,:,266))
  Gcoeff(:)%j = (c(19)*(M(1,:)%j-M(2,:)%j-M(7,:)%j+M(8,:)%j)+c(16)*(M(45,:)%j-M(46,:)%j-M(48,:)%j+M(50,:)%j)) * den(2)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(1044),h0tab(:,1044),[48,1,2,12],[0,nMT,0,0],5,1,wf4(:,2))
  call Hloop_GGG_G_23(ntryL,G0H64(1),ex6(:),ex5(:),G0H16(141),m4h2x2x16(:,249),heltab3x64(:,:,267))
  Gcoeff(:)%j = (c(6)*(M(37,:)%j+M(38,:)%j-M(39,:)%j-M(41,:)%j-M(45,:)%j+M(48,:)%j)) * den(2)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(1045),h0tab(:,1045),[48,1,12,2],[0,nMT,nMT,0],5,1,wf4(:,2))
  call Hloop_GGG_G_12(ntryL,G0H64(1),ex6(:),ex5(:),G0H16(142),m4h2x2x16(:,250),heltab3x64(:,:,268))
  Gcoeff(:)%j = (c(6)*(M(37,:)%j+M(38,:)%j-M(39,:)%j-M(41,:)%j-M(46,:)%j+M(50,:)%j)) * den(2)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(1046),h0tab(:,1046),[48,1,12,2],[0,nMT,nMT,0],5,1,wf4(:,2))
  call Hloop_GGG_G_12(ntryL,G0H64(1),ex5(:),ex6(:),G0H16(143),m4h2x2x16(:,251),heltab3x64(:,:,269))
  Gcoeff(:)%j = (c(6)*(M(45,:)%j-M(46,:)%j-M(48,:)%j+M(50,:)%j)) * den(2)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(1047),h0tab(:,1047),[48,1,12,2],[0,nMT,nMT,0],5,1,wf4(:,2))
  call Hloop_GGG_G_23(ntryL,G0H64(1),ex6(:),ex5(:),G0H16(144),m4h2x2x16(:,252),heltab3x64(:,:,270))
  Gcoeff(:)%j = (c(19)*(-M(4,:)%j+M(14,:)%j)+c(16)*(-M(33,:)%j+M(34,:)%j+M(37,:)%j-M(39,:)%j-M(40,:)%j+M(42,:)%j-M(46,:)%j &
    +M(47,:)%j)) * den(4)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(1048),h0tab(:,1048),[52,2,1,8],[0,nMT,0,0],5,1,wf4(:,3))
  call Hloop_GGG_G_12(ntryL,G0H64(1),ex6(:),wf4(:,3),G0H8(19),m4h2x4x8(:,13),heltab3x64(:,:,271))
  Gcoeff(:)%j = (c(19)*(-M(20,:)%j+M(23,:)%j)+c(16)*(-M(33,:)%j+M(34,:)%j+M(37,:)%j-M(39,:)%j-M(40,:)%j+M(42,:)%j+M(48,:)%j &
    -M(49,:)%j)) * den(4)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(1049),h0tab(:,1049),[52,2,1,8],[0,nMT,0,0],5,1,wf4(:,3))
  call Hloop_GGG_G_12(ntryL,G0H64(1),wf4(:,3),ex6(:),G0H8(20),m4h4x2x8(:,7),heltab3x64(:,:,272))
  Gcoeff(:)%j = (c(19)*(M(4,:)%j-M(14,:)%j-M(20,:)%j+M(23,:)%j)+c(16)*(M(46,:)%j-M(47,:)%j+M(48,:)%j-M(49,:)%j)) * den(4)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(1050),h0tab(:,1050),[52,2,1,8],[0,nMT,0,0],5,1,wf4(:,3))
  call Hloop_GGG_G_23(ntryL,G0H64(1),ex6(:),wf4(:,3),G0H8(21),m4h2x4x8(:,14),heltab3x64(:,:,273))
  Gcoeff(:)%j = (c(19)*(M(11,:)%j-M(12,:)%j)+c(16)*(M(33,:)%j-M(34,:)%j-M(37,:)%j+M(39,:)%j+M(40,:)%j-M(42,:)%j-M(48,:)%j &
    +M(49,:)%j)) * den(4)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(1051),h0tab(:,1051),[52,1,2,8],[0,nMT,0,0],5,1,wf4(:,3))
  call Hloop_GGG_G_12(ntryL,G0H64(1),ex6(:),wf4(:,3),G0H8(22),m4h2x4x8(:,15),heltab3x64(:,:,274))
  Gcoeff(:)%j = (c(19)*(M(7,:)%j-M(9,:)%j)+c(16)*(M(33,:)%j-M(34,:)%j-M(37,:)%j+M(39,:)%j+M(40,:)%j-M(42,:)%j+M(46,:)%j &
    -M(47,:)%j)) * den(4)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(1052),h0tab(:,1052),[52,1,2,8],[0,nMT,0,0],5,1,wf4(:,3))
  call Hloop_GGG_G_12(ntryL,G0H64(1),wf4(:,3),ex6(:),G0H8(23),m4h4x2x8(:,8),heltab3x64(:,:,275))
  Gcoeff(:)%j = (c(19)*(M(7,:)%j-M(9,:)%j-M(11,:)%j+M(12,:)%j)+c(16)*(M(46,:)%j-M(47,:)%j+M(48,:)%j-M(49,:)%j)) * den(4)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(1053),h0tab(:,1053),[52,1,2,8],[0,nMT,0,0],5,1,wf4(:,3))
  call Hloop_GGG_G_23(ntryL,G0H64(1),ex6(:),wf4(:,3),G0H8(24),m4h2x4x8(:,16),heltab3x64(:,:,276))
  Gcoeff(:)%j = (c(6)*(M(33,:)%j-M(34,:)%j-M(37,:)%j+M(39,:)%j-M(48,:)%j+M(49,:)%j)) * den(4)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(1054),h0tab(:,1054),[52,1,8,2],[0,nMT,nMT,0],5,1,wf4(:,3))
  call Hloop_GGG_G_12(ntryL,G0H64(1),ex6(:),wf4(:,3),G0H8(25),m4h2x4x8(:,17),heltab3x64(:,:,277))
  Gcoeff(:)%j = (c(6)*(M(33,:)%j-M(34,:)%j-M(37,:)%j+M(39,:)%j+M(46,:)%j-M(47,:)%j)) * den(4)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(1055),h0tab(:,1055),[52,1,8,2],[0,nMT,nMT,0],5,1,wf4(:,3))
  call Hloop_GGG_G_12(ntryL,G0H64(1),wf4(:,3),ex6(:),G0H8(26),m4h4x2x8(:,9),heltab3x64(:,:,278))
  Gcoeff(:)%j = (c(6)*(M(46,:)%j-M(47,:)%j+M(48,:)%j-M(49,:)%j)) * den(4)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(1056),h0tab(:,1056),[52,1,8,2],[0,nMT,nMT,0],5,1,wf4(:,3))
  call Hloop_GGG_G_23(ntryL,G0H64(1),ex6(:),wf4(:,3),G0H8(27),m4h2x4x8(:,18),heltab3x64(:,:,279))
  Gcoeff(:)%j = (c(19)*(-M(10,:)%j+M(16,:)%j)+c(16)*(-M(29,:)%j+M(30,:)%j-M(37,:)%j+M(39,:)%j-M(43,:)%j+M(44,:)%j+M(49,:)%j &
    -M(50,:)%j)) * den(10)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(1057),h0tab(:,1057),[56,2,1,4],[0,nMT,0,0],5,1,wf4(:,5))
  call Hloop_GGG_G_12(ntryL,G0H64(1),ex6(:),wf4(:,5),G0H8(28),m4h2x4x8(:,19),heltab3x64(:,:,280))
  Gcoeff(:)%j = (c(19)*(-M(22,:)%j+M(24,:)%j)+c(16)*(-M(29,:)%j+M(30,:)%j-M(37,:)%j+M(39,:)%j-M(43,:)%j+M(44,:)%j+M(45,:)%j &
    -M(47,:)%j)) * den(10)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(1058),h0tab(:,1058),[56,2,1,4],[0,nMT,0,0],5,1,wf4(:,5))
  call Hloop_GGG_G_12(ntryL,G0H64(1),wf4(:,5),ex6(:),G0H8(29),m4h4x2x8(:,10),heltab3x64(:,:,281))
  Gcoeff(:)%j = (c(19)*(M(10,:)%j-M(16,:)%j-M(22,:)%j+M(24,:)%j)+c(16)*(M(45,:)%j-M(47,:)%j-M(49,:)%j+M(50,:)%j)) * den(10)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(1059),h0tab(:,1059),[56,2,1,4],[0,nMT,0,0],5,1,wf4(:,5))
  call Hloop_GGG_G_23(ntryL,G0H64(1),ex6(:),wf4(:,5),G0H8(30),m4h2x4x8(:,20),heltab3x64(:,:,282))
  Gcoeff(:)%j = (c(19)*(M(5,:)%j-M(6,:)%j)+c(16)*(M(29,:)%j-M(30,:)%j+M(37,:)%j-M(39,:)%j+M(43,:)%j-M(44,:)%j-M(45,:)%j &
    +M(47,:)%j)) * den(10)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(1060),h0tab(:,1060),[56,1,2,4],[0,nMT,0,0],5,1,wf4(:,5))
  call Hloop_GGG_G_12(ntryL,G0H64(1),ex6(:),wf4(:,5),G0H8(31),m4h2x4x8(:,21),heltab3x64(:,:,283))
  Gcoeff(:)%j = (c(19)*(M(1,:)%j-M(3,:)%j)+c(16)*(M(29,:)%j-M(30,:)%j+M(37,:)%j-M(39,:)%j+M(43,:)%j-M(44,:)%j-M(49,:)%j &
    +M(50,:)%j)) * den(10)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(1061),h0tab(:,1061),[56,1,2,4],[0,nMT,0,0],5,1,wf4(:,5))
  call Hloop_GGG_G_12(ntryL,G0H64(1),wf4(:,5),ex6(:),G0H8(32),m4h4x2x8(:,11),heltab3x64(:,:,284))
  Gcoeff(:)%j = (c(19)*(M(1,:)%j-M(3,:)%j-M(5,:)%j+M(6,:)%j)+c(16)*(M(45,:)%j-M(47,:)%j-M(49,:)%j+M(50,:)%j)) * den(10)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(1062),h0tab(:,1062),[56,1,2,4],[0,nMT,0,0],5,1,wf4(:,5))
  call Hloop_GGG_G_23(ntryL,G0H64(1),ex6(:),wf4(:,5),G0H8(33),m4h2x4x8(:,22),heltab3x64(:,:,285))
  Gcoeff(:)%j = (c(6)*(M(29,:)%j-M(30,:)%j+M(37,:)%j-M(39,:)%j-M(45,:)%j+M(47,:)%j)) * den(10)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(1063),h0tab(:,1063),[56,1,4,2],[0,nMT,nMT,0],5,1,wf4(:,5))
  call Hloop_GGG_G_12(ntryL,G0H64(1),ex6(:),wf4(:,5),G0H8(34),m4h2x4x8(:,23),heltab3x64(:,:,286))
  Gcoeff(:)%j = (c(6)*(M(29,:)%j-M(30,:)%j+M(37,:)%j-M(39,:)%j-M(49,:)%j+M(50,:)%j)) * den(10)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(1064),h0tab(:,1064),[56,1,4,2],[0,nMT,nMT,0],5,1,wf4(:,5))
  call Hloop_GGG_G_12(ntryL,G0H64(1),wf4(:,5),ex6(:),G0H8(35),m4h4x2x8(:,12),heltab3x64(:,:,287))
  Gcoeff(:)%j = (c(6)*(M(45,:)%j-M(47,:)%j-M(49,:)%j+M(50,:)%j)) * den(10)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(1065),h0tab(:,1065),[56,1,4,2],[0,nMT,nMT,0],5,1,wf4(:,5))
  call Hloop_GGG_G_23(ntryL,G0H64(1),ex6(:),wf4(:,5),G0H8(36),m4h2x4x8(:,24),heltab3x64(:,:,288))
  Gcoeff(:)%j = (c(19)*(-M(6,:)%j+M(20,:)%j)+c(16)*(-M(31,:)%j+M(32,:)%j+M(38,:)%j+M(40,:)%j-M(41,:)%j-M(42,:)%j-M(45,:)%j &
    +M(49,:)%j)) * den(6)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(1066),h0tab(:,1066),[52,2,1,8],[0,nMT,0,0],5,1,wf4(:,4))
  call Hloop_GGG_G_12(ntryL,G0H64(1),ex5(:),wf4(:,4),G0H8(37),m4h2x4x8(:,25),heltab3x64(:,:,289))
  Gcoeff(:)%j = (c(19)*(-M(14,:)%j+M(17,:)%j)+c(16)*(-M(31,:)%j+M(32,:)%j+M(38,:)%j+M(40,:)%j-M(41,:)%j-M(42,:)%j-M(47,:)%j &
    +M(50,:)%j)) * den(6)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(1067),h0tab(:,1067),[52,2,1,8],[0,nMT,0,0],5,1,wf4(:,4))
  call Hloop_GGG_G_12(ntryL,G0H64(1),wf4(:,4),ex5(:),G0H8(38),m4h4x2x8(:,13),heltab3x64(:,:,290))
  Gcoeff(:)%j = (c(19)*(M(6,:)%j-M(14,:)%j+M(17,:)%j-M(20,:)%j)+c(16)*(M(45,:)%j-M(47,:)%j-M(49,:)%j+M(50,:)%j)) * den(6)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(1068),h0tab(:,1068),[52,2,1,8],[0,nMT,0,0],5,1,wf4(:,4))
  call Hloop_GGG_G_23(ntryL,G0H64(1),ex5(:),wf4(:,4),G0H8(39),m4h2x4x8(:,26),heltab3x64(:,:,291))
  Gcoeff(:)%j = (c(19)*(M(9,:)%j-M(10,:)%j)+c(16)*(M(31,:)%j-M(32,:)%j-M(38,:)%j-M(40,:)%j+M(41,:)%j+M(42,:)%j+M(47,:)%j &
    -M(50,:)%j)) * den(6)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(1069),h0tab(:,1069),[52,1,2,8],[0,nMT,0,0],5,1,wf4(:,4))
  call Hloop_GGG_G_12(ntryL,G0H64(1),ex5(:),wf4(:,4),G0H8(40),m4h2x4x8(:,27),heltab3x64(:,:,292))
  Gcoeff(:)%j = (c(19)*(M(8,:)%j-M(11,:)%j)+c(16)*(M(31,:)%j-M(32,:)%j-M(38,:)%j-M(40,:)%j+M(41,:)%j+M(42,:)%j+M(45,:)%j &
    -M(49,:)%j)) * den(6)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(1070),h0tab(:,1070),[52,1,2,8],[0,nMT,0,0],5,1,wf4(:,4))
  call Hloop_GGG_G_12(ntryL,G0H64(1),wf4(:,4),ex5(:),G0H8(41),m4h4x2x8(:,14),heltab3x64(:,:,293))
  Gcoeff(:)%j = (c(19)*(M(8,:)%j-M(9,:)%j+M(10,:)%j-M(11,:)%j)+c(16)*(M(45,:)%j-M(47,:)%j-M(49,:)%j+M(50,:)%j)) * den(6)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(1071),h0tab(:,1071),[52,1,2,8],[0,nMT,0,0],5,1,wf4(:,4))
  call Hloop_GGG_G_23(ntryL,G0H64(1),ex5(:),wf4(:,4),G0H8(42),m4h2x4x8(:,28),heltab3x64(:,:,294))
  Gcoeff(:)%j = (c(6)*(M(31,:)%j-M(32,:)%j-M(38,:)%j+M(41,:)%j+M(47,:)%j-M(50,:)%j)) * den(6)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(1072),h0tab(:,1072),[52,1,8,2],[0,nMT,nMT,0],5,1,wf4(:,4))
  call Hloop_GGG_G_12(ntryL,G0H64(1),ex5(:),wf4(:,4),G0H8(43),m4h2x4x8(:,29),heltab3x64(:,:,295))
  Gcoeff(:)%j = (c(6)*(M(31,:)%j-M(32,:)%j-M(38,:)%j+M(41,:)%j+M(45,:)%j-M(49,:)%j)) * den(6)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(1073),h0tab(:,1073),[52,1,8,2],[0,nMT,nMT,0],5,1,wf4(:,4))
  call Hloop_GGG_G_12(ntryL,G0H64(1),wf4(:,4),ex5(:),G0H8(44),m4h4x2x8(:,15),heltab3x64(:,:,296))
  Gcoeff(:)%j = (c(6)*(M(45,:)%j-M(47,:)%j-M(49,:)%j+M(50,:)%j)) * den(6)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(1074),h0tab(:,1074),[52,1,8,2],[0,nMT,nMT,0],5,1,wf4(:,4))
  call Hloop_GGG_G_23(ntryL,G0H64(1),ex5(:),wf4(:,4),G0H8(45),m4h2x4x8(:,30),heltab3x64(:,:,297))
  Gcoeff(:)%j = (c(19)*(-M(12,:)%j+M(22,:)%j)+c(16)*(-M(27,:)%j+M(28,:)%j-M(38,:)%j+M(41,:)%j+M(43,:)%j-M(44,:)%j+M(47,:)%j &
    -M(48,:)%j)) * den(12)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(1075),h0tab(:,1075),[56,2,1,4],[0,nMT,0,0],5,1,wf4(:,6))
  call Hloop_GGG_G_12(ntryL,G0H64(1),ex5(:),wf4(:,6),G0H8(46),m4h2x4x8(:,31),heltab3x64(:,:,298))
  Gcoeff(:)%j = (c(19)*(-M(16,:)%j+M(18,:)%j)+c(16)*(-M(27,:)%j+M(28,:)%j-M(38,:)%j+M(41,:)%j+M(43,:)%j-M(44,:)%j+M(46,:)%j &
    -M(49,:)%j)) * den(12)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(1076),h0tab(:,1076),[56,2,1,4],[0,nMT,0,0],5,1,wf4(:,6))
  call Hloop_GGG_G_12(ntryL,G0H64(1),wf4(:,6),ex5(:),G0H8(47),m4h4x2x8(:,16),heltab3x64(:,:,299))
  Gcoeff(:)%j = (c(19)*(M(12,:)%j-M(16,:)%j+M(18,:)%j-M(22,:)%j)+c(16)*(M(46,:)%j-M(47,:)%j+M(48,:)%j-M(49,:)%j)) * den(12)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(1077),h0tab(:,1077),[56,2,1,4],[0,nMT,0,0],5,1,wf4(:,6))
  call Hloop_GGG_G_23(ntryL,G0H64(1),ex5(:),wf4(:,6),G0H8(48),m4h2x4x8(:,32),heltab3x64(:,:,300))
  Gcoeff(:)%j = (c(19)*(M(3,:)%j-M(4,:)%j)+c(16)*(M(27,:)%j-M(28,:)%j+M(38,:)%j-M(41,:)%j-M(43,:)%j+M(44,:)%j-M(46,:)%j &
    +M(49,:)%j)) * den(12)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(1078),h0tab(:,1078),[56,1,2,4],[0,nMT,0,0],5,1,wf4(:,6))
  call Hloop_GGG_G_12(ntryL,G0H64(1),ex5(:),wf4(:,6),G0H8(49),m4h2x4x8(:,33),heltab3x64(:,:,301))
  Gcoeff(:)%j = (c(19)*(M(2,:)%j-M(5,:)%j)+c(16)*(M(27,:)%j-M(28,:)%j+M(38,:)%j-M(41,:)%j-M(43,:)%j+M(44,:)%j-M(47,:)%j &
    +M(48,:)%j)) * den(12)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(1079),h0tab(:,1079),[56,1,2,4],[0,nMT,0,0],5,1,wf4(:,6))
  call Hloop_GGG_G_12(ntryL,G0H64(1),wf4(:,6),ex5(:),G0H8(50),m4h4x2x8(:,17),heltab3x64(:,:,302))
  Gcoeff(:)%j = (c(19)*(M(2,:)%j-M(3,:)%j+M(4,:)%j-M(5,:)%j)+c(16)*(M(46,:)%j-M(47,:)%j+M(48,:)%j-M(49,:)%j)) * den(12)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(1080),h0tab(:,1080),[56,1,2,4],[0,nMT,0,0],5,1,wf4(:,6))
  call Hloop_GGG_G_23(ntryL,G0H64(1),ex5(:),wf4(:,6),G0H8(51),m4h2x4x8(:,34),heltab3x64(:,:,303))
  Gcoeff(:)%j = (c(6)*(M(27,:)%j-M(28,:)%j+M(38,:)%j-M(41,:)%j-M(46,:)%j+M(49,:)%j)) * den(12)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(1081),h0tab(:,1081),[56,1,4,2],[0,nMT,nMT,0],5,1,wf4(:,6))
  call Hloop_GGG_G_12(ntryL,G0H64(1),ex5(:),wf4(:,6),G0H8(52),m4h2x4x8(:,35),heltab3x64(:,:,304))
  Gcoeff(:)%j = (c(6)*(M(27,:)%j-M(28,:)%j+M(38,:)%j-M(41,:)%j-M(47,:)%j+M(48,:)%j)) * den(12)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(1082),h0tab(:,1082),[56,1,4,2],[0,nMT,nMT,0],5,1,wf4(:,6))
  call Hloop_GGG_G_12(ntryL,G0H64(1),wf4(:,6),ex5(:),G0H8(53),m4h4x2x8(:,18),heltab3x64(:,:,305))
  Gcoeff(:)%j = (c(6)*(M(46,:)%j-M(47,:)%j+M(48,:)%j-M(49,:)%j)) * den(12)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(1083),h0tab(:,1083),[56,1,4,2],[0,nMT,nMT,0],5,1,wf4(:,6))
  call Hloop_GGG_G_23(ntryL,G0H64(1),ex5(:),wf4(:,6),G0H8(54),m4h2x4x8(:,36),heltab3x64(:,:,306))
  Gcoeff(:)%j = (c(9)*M(2,:)%j+c(6)*(M(26,:)%j+M(29,:)%j+M(33,:)%j-M(41,:)%j)) * den(30)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(1084),h0tab(:,1084),[40,4,2,17],[0,0,nMT,0],5,1,wf4(:,17))
  call Hloop_GGG_G_12(ntryL,G0H64(1),ex6(:),ex4(:),G0H16(145),m4h2x2x16(:,253),heltab3x64(:,:,307))
  Gcoeff(:)%j = (c(9)*M(5,:)%j+c(6)*(M(26,:)%j+M(29,:)%j+M(33,:)%j-M(38,:)%j)) * den(30)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(1085),h0tab(:,1085),[40,4,2,17],[0,0,nMT,0],5,1,wf4(:,17))
  call Hloop_GGG_G_12(ntryL,G0H64(1),ex4(:),ex6(:),G0H16(146),m4h2x2x16(:,254),heltab3x64(:,:,308))
  Gcoeff(:)%j = (c(9)*(-M(2,:)%j+M(5,:)%j)+c(6)*(-M(38,:)%j+M(41,:)%j)) * den(30)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(1086),h0tab(:,1086),[40,4,2,17],[0,0,nMT,0],5,1,wf4(:,17))
  call Hloop_GGG_G_23(ntryL,G0H64(1),ex6(:),ex4(:),G0H16(147),m4h2x2x16(:,255),heltab3x64(:,:,309))
  Gcoeff(:)%j = (c(16)*(-M(26,:)%j-M(29,:)%j+M(41,:)%j)) * den(30)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(1087),h0tab(:,1087),[40,2,4,17],[0,nMT,nMT,0],5,1,wf4(:,17))
  call Hloop_GGG_G_12(ntryL,G0H64(1),ex6(:),ex4(:),G0H16(148),m4h2x2x16(:,256),heltab3x64(:,:,310))
  Gcoeff(:)%j = (c(16)*(-M(26,:)%j-M(29,:)%j+M(38,:)%j)) * den(30)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(1088),h0tab(:,1088),[40,2,4,17],[0,nMT,nMT,0],5,1,wf4(:,17))
  call Hloop_GGG_G_12(ntryL,G0H64(1),ex4(:),ex6(:),G0H16(149),m4h2x2x16(:,257),heltab3x64(:,:,311))
  Gcoeff(:)%j = (c(16)*(M(38,:)%j-M(41,:)%j)) * den(30)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(1089),h0tab(:,1089),[40,2,4,17],[0,nMT,nMT,0],5,1,wf4(:,17))
  call Hloop_GGG_G_23(ntryL,G0H64(1),ex6(:),ex4(:),G0H16(150),m4h2x2x16(:,258),heltab3x64(:,:,312))
  Gcoeff(:)%j = (c(9)*M(11,:)%j+c(6)*(M(26,:)%j+M(29,:)%j+M(33,:)%j-M(41,:)%j)) * den(30)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(1090),h0tab(:,1090),[40,2,17,4],[0,nMT,0,0],5,1,wf4(:,17))
  call Hloop_GGG_G_12(ntryL,G0H64(1),ex6(:),ex4(:),G0H16(151),m4h2x2x16(:,259),heltab3x64(:,:,313))
  Gcoeff(:)%j = (c(9)*M(21,:)%j+c(6)*(M(26,:)%j+M(29,:)%j+M(33,:)%j-M(38,:)%j)) * den(30)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(1091),h0tab(:,1091),[40,2,17,4],[0,nMT,0,0],5,1,wf4(:,17))
  call Hloop_GGG_G_12(ntryL,G0H64(1),ex4(:),ex6(:),G0H16(152),m4h2x2x16(:,260),heltab3x64(:,:,314))
  Gcoeff(:)%j = (c(9)*(-M(11,:)%j+M(21,:)%j)+c(6)*(-M(38,:)%j+M(41,:)%j)) * den(30)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(1092),h0tab(:,1092),[40,2,17,4],[0,nMT,0,0],5,1,wf4(:,17))
  call Hloop_GGG_G_23(ntryL,G0H64(1),ex6(:),ex4(:),G0H16(153),m4h2x2x16(:,261),heltab3x64(:,:,315))
  Gcoeff(:)%j = (-(c(9)*M(18,:)%j)+c(6)*(-M(25,:)%j-M(30,:)%j-M(34,:)%j+M(38,:)%j)) * den(32)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(1093),h0tab(:,1093),[40,4,1,18],[0,0,nMT,0],5,1,wf4(:,19))
  call Hloop_GGG_G_12(ntryL,G0H64(1),ex6(:),ex4(:),G0H16(154),m4h2x2x16(:,262),heltab3x64(:,:,316))
  Gcoeff(:)%j = (-(c(9)*M(16,:)%j)+c(6)*(-M(25,:)%j-M(30,:)%j-M(34,:)%j+M(41,:)%j)) * den(32)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(1094),h0tab(:,1094),[40,4,1,18],[0,0,nMT,0],5,1,wf4(:,19))
  call Hloop_GGG_G_12(ntryL,G0H64(1),ex4(:),ex6(:),G0H16(155),m4h2x2x16(:,263),heltab3x64(:,:,317))
  Gcoeff(:)%j = (c(9)*(-M(16,:)%j+M(18,:)%j)+c(6)*(-M(38,:)%j+M(41,:)%j)) * den(32)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(1095),h0tab(:,1095),[40,4,1,18],[0,0,nMT,0],5,1,wf4(:,19))
  call Hloop_GGG_G_23(ntryL,G0H64(1),ex6(:),ex4(:),G0H16(156),m4h2x2x16(:,264),heltab3x64(:,:,318))
  Gcoeff(:)%j = (c(16)*(-M(25,:)%j-M(30,:)%j+M(38,:)%j)) * den(32)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(1096),h0tab(:,1096),[40,1,4,18],[0,nMT,nMT,0],5,1,wf4(:,19))
  call Hloop_GGG_G_12(ntryL,G0H64(1),ex6(:),ex4(:),G0H16(157),m4h2x2x16(:,265),heltab3x64(:,:,319))
  Gcoeff(:)%j = (c(16)*(-M(25,:)%j-M(30,:)%j+M(41,:)%j)) * den(32)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(1097),h0tab(:,1097),[40,1,4,18],[0,nMT,nMT,0],5,1,wf4(:,19))
  call Hloop_GGG_G_12(ntryL,G0H64(1),ex4(:),ex6(:),G0H16(158),m4h2x2x16(:,266),heltab3x64(:,:,320))
  Gcoeff(:)%j = (c(16)*(-M(38,:)%j+M(41,:)%j)) * den(32)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(1098),h0tab(:,1098),[40,1,4,18],[0,nMT,nMT,0],5,1,wf4(:,19))
  call Hloop_GGG_G_23(ntryL,G0H64(1),ex6(:),ex4(:),G0H16(159),m4h2x2x16(:,267),heltab3x64(:,:,321))
  Gcoeff(:)%j = (-(c(9)*M(14,:)%j)+c(6)*(-M(25,:)%j-M(30,:)%j-M(34,:)%j+M(38,:)%j)) * den(32)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(1099),h0tab(:,1099),[40,1,18,4],[0,nMT,0,0],5,1,wf4(:,19))
  call Hloop_GGG_G_12(ntryL,G0H64(1),ex6(:),ex4(:),G0H16(160),m4h2x2x16(:,268),heltab3x64(:,:,322))
  Gcoeff(:)%j = (-(c(9)*M(13,:)%j)+c(6)*(-M(25,:)%j-M(30,:)%j-M(34,:)%j+M(41,:)%j)) * den(32)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(1100),h0tab(:,1100),[40,1,18,4],[0,nMT,0,0],5,1,wf4(:,19))
  call Hloop_GGG_G_12(ntryL,G0H64(1),ex4(:),ex6(:),G0H16(161),m4h2x2x16(:,269),heltab3x64(:,:,323))
  Gcoeff(:)%j = (c(9)*(-M(13,:)%j+M(14,:)%j)+c(6)*(-M(38,:)%j+M(41,:)%j)) * den(32)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(1101),h0tab(:,1101),[40,1,18,4],[0,nMT,0,0],5,1,wf4(:,19))
  call Hloop_GGG_G_23(ntryL,G0H64(1),ex6(:),ex4(:),G0H16(162),m4h2x2x16(:,270),heltab3x64(:,:,324))
  Gcoeff(:)%j = (c(19)*(M(7,:)%j-M(9,:)%j)+c(16)*(M(33,:)%j-M(34,:)%j-M(37,:)%j+M(39,:)%j+M(40,:)%j-M(42,:)%j+M(46,:)%j &
    -M(47,:)%j)) * den(4)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(1102),h0tab(:,1102),[32,1,2,28],[0,nMT,0,0],5,1,wf4(:,3))
  call Hloop_UV_W(ntryL,G0H64(1),0,ex6(:),32,G1H32(58),m3h2x32(:,658),heltab2x64(:,:,778))
  Gcoeff(:)%j = (c(19)*(M(3,:)%j-M(13,:)%j)+c(16)*(M(33,:)%j-M(34,:)%j-M(37,:)%j+M(39,:)%j+M(40,:)%j-M(42,:)%j-M(48,:)%j &
    +M(49,:)%j)) * den(4)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(1103),h0tab(:,1103),[32,1,2,28],[0,nMT,0,0],5,1,wf4(:,3))
  call Hloop_UV_W(ntryL,G0H64(1),0,ex6(:),32,G1H32(59),m3h2x32(:,659),heltab2x64(:,:,779))
  Gcoeff(:)%j = (c(19)*(M(3,:)%j-M(7,:)%j+M(9,:)%j-M(13,:)%j)+c(16)*(-M(46,:)%j+M(47,:)%j-M(48,:)%j+M(49,:)%j)) * den(4)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(1104),h0tab(:,1104),[32,1,2,28],[0,nMT,0,0],5,1,wf4(:,3))
  call Hloop_UV_W(ntryL,G0H64(1),0,ex6(:),32,G1H32(60),m3h2x32(:,660),heltab2x64(:,:,780))
  Gcoeff(:)%j = (c(19)*(-M(20,:)%j+M(23,:)%j)+c(16)*(-M(33,:)%j+M(34,:)%j+M(37,:)%j-M(39,:)%j-M(40,:)%j+M(42,:)%j+M(48,:)%j &
    -M(49,:)%j)) * den(4)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(1105),h0tab(:,1105),[32,2,1,28],[0,nMT,0,0],5,1,wf4(:,3))
  call Hloop_UV_W(ntryL,G0H64(1),0,ex6(:),32,G1H32(61),m3h2x32(:,661),heltab2x64(:,:,781))
  Gcoeff(:)%j = (c(19)*(-M(21,:)%j+M(22,:)%j)+c(16)*(-M(33,:)%j+M(34,:)%j+M(37,:)%j-M(39,:)%j-M(40,:)%j+M(42,:)%j-M(46,:)%j &
    +M(47,:)%j)) * den(4)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(1106),h0tab(:,1106),[32,2,1,28],[0,nMT,0,0],5,1,wf4(:,3))
  call Hloop_UV_W(ntryL,G0H64(1),0,ex6(:),32,G1H32(62),m3h2x32(:,662),heltab2x64(:,:,782))
  Gcoeff(:)%j = (c(19)*(M(20,:)%j-M(21,:)%j+M(22,:)%j-M(23,:)%j)+c(16)*(-M(46,:)%j+M(47,:)%j-M(48,:)%j+M(49,:)%j)) * den(4)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(1107),h0tab(:,1107),[32,2,1,28],[0,nMT,0,0],5,1,wf4(:,3))
  call Hloop_UV_W(ntryL,G0H64(1),0,ex6(:),32,G1H32(63),m3h2x32(:,663),heltab2x64(:,:,783))
  Gcoeff(:)%j = (c(6)*(M(33,:)%j-M(34,:)%j+M(40,:)%j-M(42,:)%j-M(48,:)%j+M(49,:)%j)) * den(4)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(1108),h0tab(:,1108),[32,1,28,2],[nMT,0,0,nMT],5,1,wf4(:,3))
  call Hloop_AV_Q(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,664),heltab2x64(:,:,784))
  call Hloop_A_Q(ntryL,G0H32(1),32,nMT,G1H32(64),n2h32(310))
  Gcoeff(:)%j = (c(6)*(M(33,:)%j-M(34,:)%j+M(40,:)%j-M(42,:)%j+M(46,:)%j-M(47,:)%j)) * den(4)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(1109),h0tab(:,1109),[32,1,28,2],[nMT,0,0,nMT],5,1,wf4(:,3))
  call Hloop_AV_Q(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,665),heltab2x64(:,:,785))
  call Hloop_A_Q(ntryL,G0H32(1),32,nMT,G1H32(65),n2h32(311))
  Gcoeff(:)%j = (c(6)*(M(46,:)%j-M(47,:)%j+M(48,:)%j-M(49,:)%j)) * den(4)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(1110),h0tab(:,1110),[32,1,28,2],[nMT,0,0,nMT],5,1,wf4(:,3))
  call Hloop_AV_Q(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,666),heltab2x64(:,:,786))
  call Hloop_A_Q(ntryL,G0H32(1),32,nMT,G1H32(66),n2h32(312))
  Gcoeff(:)%j = (c(19)*(-M(11,:)%j+M(12,:)%j)+c(16)*(-M(33,:)%j+M(34,:)%j+M(37,:)%j-M(39,:)%j-M(40,:)%j+M(42,:)%j+M(48,:)%j &
    -M(49,:)%j)) * den(4)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(1111),h0tab(:,1111),[40,2,1,20],[0,nMT,0,0],5,1,wf4(:,3))
  call Hloop_GGG_G_12(ntryL,G0H64(1),ex6(:),ex4(:),G0H16(163),m4h2x2x16(:,271),heltab3x64(:,:,325))
  Gcoeff(:)%j = (c(19)*(-M(21,:)%j+M(22,:)%j)+c(16)*(-M(33,:)%j+M(34,:)%j+M(37,:)%j-M(39,:)%j-M(40,:)%j+M(42,:)%j-M(46,:)%j &
    +M(47,:)%j)) * den(4)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(1112),h0tab(:,1112),[40,2,1,20],[0,nMT,0,0],5,1,wf4(:,3))
  call Hloop_GGG_G_12(ntryL,G0H64(1),ex4(:),ex6(:),G0H16(164),m4h2x2x16(:,272),heltab3x64(:,:,326))
  Gcoeff(:)%j = (c(19)*(M(11,:)%j-M(12,:)%j-M(21,:)%j+M(22,:)%j)+c(16)*(-M(46,:)%j+M(47,:)%j-M(48,:)%j+M(49,:)%j)) * den(4)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(1113),h0tab(:,1113),[40,2,1,20],[0,nMT,0,0],5,1,wf4(:,3))
  call Hloop_GGG_G_23(ntryL,G0H64(1),ex6(:),ex4(:),G0H16(165),m4h2x2x16(:,273),heltab3x64(:,:,327))
  Gcoeff(:)%j = (c(19)*(M(4,:)%j-M(14,:)%j)+c(16)*(M(33,:)%j-M(34,:)%j-M(37,:)%j+M(39,:)%j+M(40,:)%j-M(42,:)%j+M(46,:)%j &
    -M(47,:)%j)) * den(4)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(1114),h0tab(:,1114),[40,1,2,20],[0,nMT,0,0],5,1,wf4(:,3))
  call Hloop_GGG_G_12(ntryL,G0H64(1),ex6(:),ex4(:),G0H16(166),m4h2x2x16(:,274),heltab3x64(:,:,328))
  Gcoeff(:)%j = (c(19)*(M(3,:)%j-M(13,:)%j)+c(16)*(M(33,:)%j-M(34,:)%j-M(37,:)%j+M(39,:)%j+M(40,:)%j-M(42,:)%j-M(48,:)%j &
    +M(49,:)%j)) * den(4)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(1115),h0tab(:,1115),[40,1,2,20],[0,nMT,0,0],5,1,wf4(:,3))
  call Hloop_GGG_G_12(ntryL,G0H64(1),ex4(:),ex6(:),G0H16(167),m4h2x2x16(:,275),heltab3x64(:,:,329))
  Gcoeff(:)%j = (c(19)*(M(3,:)%j-M(4,:)%j-M(13,:)%j+M(14,:)%j)+c(16)*(-M(46,:)%j+M(47,:)%j-M(48,:)%j+M(49,:)%j)) * den(4)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(1116),h0tab(:,1116),[40,1,2,20],[0,nMT,0,0],5,1,wf4(:,3))
  call Hloop_GGG_G_23(ntryL,G0H64(1),ex6(:),ex4(:),G0H16(168),m4h2x2x16(:,276),heltab3x64(:,:,330))
  Gcoeff(:)%j = (c(6)*(-M(37,:)%j+M(39,:)%j+M(40,:)%j-M(42,:)%j+M(46,:)%j-M(47,:)%j)) * den(4)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(1117),h0tab(:,1117),[40,1,20,2],[0,nMT,nMT,0],5,1,wf4(:,3))
  call Hloop_GGG_G_12(ntryL,G0H64(1),ex6(:),ex4(:),G0H16(169),m4h2x2x16(:,277),heltab3x64(:,:,331))
  Gcoeff(:)%j = (c(6)*(-M(37,:)%j+M(39,:)%j+M(40,:)%j-M(42,:)%j-M(48,:)%j+M(49,:)%j)) * den(4)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(1118),h0tab(:,1118),[40,1,20,2],[0,nMT,nMT,0],5,1,wf4(:,3))
  call Hloop_GGG_G_12(ntryL,G0H64(1),ex4(:),ex6(:),G0H16(170),m4h2x2x16(:,278),heltab3x64(:,:,332))
  Gcoeff(:)%j = (c(6)*(-M(46,:)%j+M(47,:)%j-M(48,:)%j+M(49,:)%j)) * den(4)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(1119),h0tab(:,1119),[40,1,20,2],[0,nMT,nMT,0],5,1,wf4(:,3))
  call Hloop_GGG_G_23(ntryL,G0H64(1),ex6(:),ex4(:),G0H16(171),m4h2x2x16(:,279),heltab3x64(:,:,333))
  Gcoeff(:)%j = (c(19)*(-M(5,:)%j+M(19,:)%j)+c(16)*(-M(31,:)%j+M(32,:)%j+M(38,:)%j+M(40,:)%j-M(41,:)%j-M(42,:)%j-M(47,:)%j &
    +M(50,:)%j)) * den(6)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(1120),h0tab(:,1120),[44,2,1,16],[0,nMT,0,0],5,1,wf4(:,4))
  call Hloop_GGG_G_12(ntryL,G0H64(1),ex4(:),wf4(:,4),G0H8(55),m4h2x4x8(:,37),heltab3x64(:,:,334))
  Gcoeff(:)%j = (c(19)*(-M(8,:)%j+M(11,:)%j)+c(16)*(-M(31,:)%j+M(32,:)%j+M(38,:)%j+M(40,:)%j-M(41,:)%j-M(42,:)%j-M(45,:)%j &
    +M(49,:)%j)) * den(6)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(1121),h0tab(:,1121),[44,2,1,16],[0,nMT,0,0],5,1,wf4(:,4))
  call Hloop_GGG_G_12(ntryL,G0H64(1),wf4(:,4),ex4(:),G0H8(56),m4h4x2x8(:,19),heltab3x64(:,:,335))
  Gcoeff(:)%j = (c(19)*(M(5,:)%j-M(8,:)%j+M(11,:)%j-M(19,:)%j)+c(16)*(-M(45,:)%j+M(47,:)%j+M(49,:)%j-M(50,:)%j)) * den(6)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(1122),h0tab(:,1122),[44,2,1,16],[0,nMT,0,0],5,1,wf4(:,4))
  call Hloop_GGG_G_23(ntryL,G0H64(1),ex4(:),wf4(:,4),G0H8(57),m4h2x4x8(:,38),heltab3x64(:,:,336))
  Gcoeff(:)%j = (c(19)*(M(15,:)%j-M(16,:)%j)+c(16)*(M(31,:)%j-M(32,:)%j-M(38,:)%j-M(40,:)%j+M(41,:)%j+M(42,:)%j+M(45,:)%j &
    -M(49,:)%j)) * den(6)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(1123),h0tab(:,1123),[44,1,2,16],[0,nMT,0,0],5,1,wf4(:,4))
  call Hloop_GGG_G_12(ntryL,G0H64(1),ex4(:),wf4(:,4),G0H8(58),m4h2x4x8(:,39),heltab3x64(:,:,337))
  Gcoeff(:)%j = (c(19)*(M(14,:)%j-M(17,:)%j)+c(16)*(M(31,:)%j-M(32,:)%j-M(38,:)%j-M(40,:)%j+M(41,:)%j+M(42,:)%j+M(47,:)%j &
    -M(50,:)%j)) * den(6)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(1124),h0tab(:,1124),[44,1,2,16],[0,nMT,0,0],5,1,wf4(:,4))
  call Hloop_GGG_G_12(ntryL,G0H64(1),wf4(:,4),ex4(:),G0H8(59),m4h4x2x8(:,20),heltab3x64(:,:,338))
  Gcoeff(:)%j = (c(19)*(M(14,:)%j-M(15,:)%j+M(16,:)%j-M(17,:)%j)+c(16)*(-M(45,:)%j+M(47,:)%j+M(49,:)%j-M(50,:)%j)) * den(6)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(1125),h0tab(:,1125),[44,1,2,16],[0,nMT,0,0],5,1,wf4(:,4))
  call Hloop_GGG_G_23(ntryL,G0H64(1),ex4(:),wf4(:,4),G0H8(60),m4h2x4x8(:,40),heltab3x64(:,:,339))
  Gcoeff(:)%j = (c(6)*(M(31,:)%j-M(32,:)%j-M(40,:)%j+M(42,:)%j+M(45,:)%j-M(49,:)%j)) * den(6)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(1126),h0tab(:,1126),[44,1,16,2],[0,nMT,nMT,0],5,1,wf4(:,4))
  call Hloop_GGG_G_12(ntryL,G0H64(1),ex4(:),wf4(:,4),G0H8(61),m4h2x4x8(:,41),heltab3x64(:,:,340))
  Gcoeff(:)%j = (c(6)*(M(31,:)%j-M(32,:)%j-M(40,:)%j+M(42,:)%j+M(47,:)%j-M(50,:)%j)) * den(6)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(1127),h0tab(:,1127),[44,1,16,2],[0,nMT,nMT,0],5,1,wf4(:,4))
  call Hloop_GGG_G_12(ntryL,G0H64(1),wf4(:,4),ex4(:),G0H8(62),m4h4x2x8(:,21),heltab3x64(:,:,341))
  Gcoeff(:)%j = (c(6)*(-M(45,:)%j+M(47,:)%j+M(49,:)%j-M(50,:)%j)) * den(6)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(1128),h0tab(:,1128),[44,1,16,2],[0,nMT,nMT,0],5,1,wf4(:,4))
  call Hloop_GGG_G_23(ntryL,G0H64(1),ex4(:),wf4(:,4),G0H8(63),m4h2x4x8(:,42),heltab3x64(:,:,342))
  Gcoeff(:)%j = (c(19)*(-M(18,:)%j+M(24,:)%j)+c(16)*(-M(25,:)%j+M(26,:)%j-M(40,:)%j+M(42,:)%j-M(43,:)%j+M(44,:)%j+M(45,:)%j &
    -M(46,:)%j)) * den(16)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(1129),h0tab(:,1129),[56,2,1,4],[0,nMT,0,0],5,1,wf4(:,7))
  call Hloop_GGG_G_12(ntryL,G0H64(1),ex4(:),wf4(:,7),G0H8(64),m4h2x4x8(:,43),heltab3x64(:,:,343))
  Gcoeff(:)%j = (c(19)*(-M(10,:)%j+M(12,:)%j)+c(16)*(-M(25,:)%j+M(26,:)%j-M(40,:)%j+M(42,:)%j-M(43,:)%j+M(44,:)%j+M(48,:)%j &
    -M(50,:)%j)) * den(16)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(1130),h0tab(:,1130),[56,2,1,4],[0,nMT,0,0],5,1,wf4(:,7))
  call Hloop_GGG_G_12(ntryL,G0H64(1),wf4(:,7),ex4(:),G0H8(65),m4h4x2x8(:,22),heltab3x64(:,:,344))
  Gcoeff(:)%j = (c(19)*(-M(10,:)%j+M(12,:)%j+M(18,:)%j-M(24,:)%j)+c(16)*(-M(45,:)%j+M(46,:)%j+M(48,:)%j-M(50,:)%j)) * den(16)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(1131),h0tab(:,1131),[56,2,1,4],[0,nMT,0,0],5,1,wf4(:,7))
  call Hloop_GGG_G_23(ntryL,G0H64(1),ex4(:),wf4(:,7),G0H8(66),m4h2x4x8(:,44),heltab3x64(:,:,345))
  Gcoeff(:)%j = (c(19)*(M(1,:)%j-M(2,:)%j)+c(16)*(M(25,:)%j-M(26,:)%j+M(40,:)%j-M(42,:)%j+M(43,:)%j-M(44,:)%j-M(48,:)%j &
    +M(50,:)%j)) * den(16)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(1132),h0tab(:,1132),[56,1,2,4],[0,nMT,0,0],5,1,wf4(:,7))
  call Hloop_GGG_G_12(ntryL,G0H64(1),ex4(:),wf4(:,7),G0H8(67),m4h2x4x8(:,45),heltab3x64(:,:,346))
  Gcoeff(:)%j = (c(19)*(M(4,:)%j-M(6,:)%j)+c(16)*(M(25,:)%j-M(26,:)%j+M(40,:)%j-M(42,:)%j+M(43,:)%j-M(44,:)%j-M(45,:)%j &
    +M(46,:)%j)) * den(16)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(1133),h0tab(:,1133),[56,1,2,4],[0,nMT,0,0],5,1,wf4(:,7))
  call Hloop_GGG_G_12(ntryL,G0H64(1),wf4(:,7),ex4(:),G0H8(68),m4h4x2x8(:,23),heltab3x64(:,:,347))
  Gcoeff(:)%j = (c(19)*(-M(1,:)%j+M(2,:)%j+M(4,:)%j-M(6,:)%j)+c(16)*(-M(45,:)%j+M(46,:)%j+M(48,:)%j-M(50,:)%j)) * den(16)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(1134),h0tab(:,1134),[56,1,2,4],[0,nMT,0,0],5,1,wf4(:,7))
  call Hloop_GGG_G_23(ntryL,G0H64(1),ex4(:),wf4(:,7),G0H8(69),m4h2x4x8(:,46),heltab3x64(:,:,348))
  Gcoeff(:)%j = (c(6)*(M(25,:)%j-M(26,:)%j+M(40,:)%j-M(42,:)%j-M(48,:)%j+M(50,:)%j)) * den(16)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(1135),h0tab(:,1135),[56,1,4,2],[0,nMT,nMT,0],5,1,wf4(:,7))
  call Hloop_GGG_G_12(ntryL,G0H64(1),ex4(:),wf4(:,7),G0H8(70),m4h2x4x8(:,47),heltab3x64(:,:,349))
  Gcoeff(:)%j = (c(6)*(M(25,:)%j-M(26,:)%j+M(40,:)%j-M(42,:)%j-M(45,:)%j+M(46,:)%j)) * den(16)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(1136),h0tab(:,1136),[56,1,4,2],[0,nMT,nMT,0],5,1,wf4(:,7))
  call Hloop_GGG_G_12(ntryL,G0H64(1),wf4(:,7),ex4(:),G0H8(71),m4h4x2x8(:,24),heltab3x64(:,:,350))
  Gcoeff(:)%j = (c(6)*(-M(45,:)%j+M(46,:)%j+M(48,:)%j-M(50,:)%j)) * den(16)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(1137),h0tab(:,1137),[56,1,4,2],[0,nMT,nMT,0],5,1,wf4(:,7))
  call Hloop_GGG_G_23(ntryL,G0H64(1),ex4(:),wf4(:,7),G0H8(72),m4h2x4x8(:,48),heltab3x64(:,:,351))
  Gcoeff(:)%j = (-(c(9)*M(3,:)%j)+c(6)*(-M(25,:)%j-M(27,:)%j-M(31,:)%j+M(37,:)%j)) * den(34)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(1138),h0tab(:,1138),[33,2,4,24],[nMT,0,0,0],5,1,wf4(:,21))
  call Hloop_VQ_A(ntryL,G0H64(1),wf4(:,21),G0H16(172),m3h4x16(:,121),heltab2x64(:,:,787))
  call Hloop_Q_A(ntryL,G0H16(172),33,nMT,G1H16(153),n2h16(519))
  Gcoeff(:)%j = (-(c(9)*M(1,:)%j)+c(6)*(-M(25,:)%j-M(27,:)%j-M(31,:)%j+M(39,:)%j)) * den(34)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(1139),h0tab(:,1139),[33,2,4,24],[nMT,0,0,0],5,1,wf4(:,21))
  call Hloop_VQ_A(ntryL,G0H64(1),wf4(:,21),G0H16(172),m3h4x16(:,122),heltab2x64(:,:,788))
  call Hloop_Q_A(ntryL,G0H16(172),33,nMT,G1H16(154),n2h16(520))
  Gcoeff(:)%j = (c(9)*(-M(1,:)%j+M(3,:)%j)+c(6)*(-M(37,:)%j+M(39,:)%j)) * den(34)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(1140),h0tab(:,1140),[33,2,4,24],[nMT,0,0,0],5,1,wf4(:,21))
  call Hloop_VQ_A(ntryL,G0H64(1),wf4(:,21),G0H16(172),m3h4x16(:,123),heltab2x64(:,:,789))
  call Hloop_Q_A(ntryL,G0H16(172),33,nMT,G1H16(14),n2h16(521))
  Gcoeff(:)%j = (c(16)*(-M(25,:)%j-M(27,:)%j+M(37,:)%j)) * den(34)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(1141),h0tab(:,1141),[33,4,2,24],[nMT,nMT,0,0],5,1,wf4(:,21))
  call Hloop_VQ_A(ntryL,G0H64(1),wf4(:,21),G0H16(172),m3h4x16(:,124),heltab2x64(:,:,790))
  call Hloop_Q_A(ntryL,G0H16(172),33,nMT,G1H16(156),n2h16(522))
  Gcoeff(:)%j = (c(16)*(-M(25,:)%j-M(27,:)%j+M(39,:)%j)) * den(34)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(1142),h0tab(:,1142),[33,4,2,24],[nMT,nMT,0,0],5,1,wf4(:,21))
  call Hloop_VQ_A(ntryL,G0H64(1),wf4(:,21),G0H16(172),m3h4x16(:,125),heltab2x64(:,:,791))
  call Hloop_Q_A(ntryL,G0H16(172),33,nMT,G1H16(158),n2h16(523))
  Gcoeff(:)%j = (c(16)*(-M(37,:)%j+M(39,:)%j)) * den(34)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(1143),h0tab(:,1143),[33,4,2,24],[nMT,nMT,0,0],5,1,wf4(:,21))
  call Hloop_VQ_A(ntryL,G0H64(1),wf4(:,21),G0H16(172),m3h4x16(:,126),heltab2x64(:,:,792))
  call Hloop_Q_A(ntryL,G0H16(172),33,nMT,G1H16(159),n2h16(524))
  Gcoeff(:)%j = (-(c(9)*M(15,:)%j)+c(6)*(-M(25,:)%j-M(27,:)%j-M(31,:)%j+M(37,:)%j)) * den(34)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(1144),h0tab(:,1144),[33,2,24,4],[nMT,0,0,0],5,1,wf4(:,21))
  call Hloop_VQ_A(ntryL,G0H64(1),wf4(:,21),G0H16(172),m3h4x16(:,127),heltab2x64(:,:,793))
  call Hloop_Q_A(ntryL,G0H16(172),33,nMT,G1H16(160),n2h16(525))
  Gcoeff(:)%j = (-(c(9)*M(9,:)%j)+c(6)*(-M(25,:)%j-M(27,:)%j-M(31,:)%j+M(39,:)%j)) * den(34)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(1145),h0tab(:,1145),[33,2,24,4],[nMT,0,0,0],5,1,wf4(:,21))
  call Hloop_VQ_A(ntryL,G0H64(1),wf4(:,21),G0H16(172),m3h4x16(:,128),heltab2x64(:,:,794))
  call Hloop_Q_A(ntryL,G0H16(172),33,nMT,G1H16(166),n2h16(526))
  Gcoeff(:)%j = (c(9)*(-M(9,:)%j+M(15,:)%j)+c(6)*(-M(37,:)%j+M(39,:)%j)) * den(34)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(1146),h0tab(:,1146),[33,2,24,4],[nMT,0,0,0],5,1,wf4(:,21))
  call Hloop_VQ_A(ntryL,G0H64(1),wf4(:,21),G0H16(172),m3h4x16(:,129),heltab2x64(:,:,795))
  call Hloop_Q_A(ntryL,G0H16(172),33,nMT,G1H16(15),n2h16(527))
  Gcoeff(:)%j = (c(9)*M(22,:)%j+c(6)*(M(26,:)%j+M(28,:)%j+M(32,:)%j-M(39,:)%j)) * den(36)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(1147),h0tab(:,1147),[34,1,4,24],[nMT,0,0,0],5,1,wf4(:,23))
  call Hloop_VA_Q(ntryL,G0H64(1),wf4(:,23),G0H16(172),m3h4x16(:,130),heltab2x64(:,:,796))
  call Hloop_A_Q(ntryL,G0H16(172),34,nMT,G1H16(90),n2h16(528))
  Gcoeff(:)%j = (c(9)*M(24,:)%j+c(6)*(M(26,:)%j+M(28,:)%j+M(32,:)%j-M(37,:)%j)) * den(36)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(1148),h0tab(:,1148),[34,1,4,24],[nMT,0,0,0],5,1,wf4(:,23))
  call Hloop_VA_Q(ntryL,G0H64(1),wf4(:,23),G0H16(172),m3h4x16(:,131),heltab2x64(:,:,797))
  call Hloop_A_Q(ntryL,G0H16(172),34,nMT,G1H16(95),n2h16(529))
  Gcoeff(:)%j = (c(9)*(-M(22,:)%j+M(24,:)%j)+c(6)*(-M(37,:)%j+M(39,:)%j)) * den(36)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(1149),h0tab(:,1149),[34,1,4,24],[nMT,0,0,0],5,1,wf4(:,23))
  call Hloop_VA_Q(ntryL,G0H64(1),wf4(:,23),G0H16(172),m3h4x16(:,132),heltab2x64(:,:,798))
  call Hloop_A_Q(ntryL,G0H16(172),34,nMT,G1H16(17),n2h16(530))
  Gcoeff(:)%j = (c(16)*(-M(26,:)%j-M(28,:)%j+M(39,:)%j)) * den(36)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(1150),h0tab(:,1150),[34,4,1,24],[nMT,nMT,0,0],5,1,wf4(:,23))
  call Hloop_VA_Q(ntryL,G0H64(1),wf4(:,23),G0H16(172),m3h4x16(:,133),heltab2x64(:,:,799))
  call Hloop_A_Q(ntryL,G0H16(172),34,nMT,G1H16(179),n2h16(531))
  Gcoeff(:)%j = (c(16)*(-M(26,:)%j-M(28,:)%j+M(37,:)%j)) * den(36)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(1151),h0tab(:,1151),[34,4,1,24],[nMT,nMT,0,0],5,1,wf4(:,23))
  call Hloop_VA_Q(ntryL,G0H64(1),wf4(:,23),G0H16(172),m3h4x16(:,134),heltab2x64(:,:,800))
  call Hloop_A_Q(ntryL,G0H16(172),34,nMT,G1H16(180),n2h16(532))
  Gcoeff(:)%j = (c(16)*(M(37,:)%j-M(39,:)%j)) * den(36)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(1152),h0tab(:,1152),[34,4,1,24],[nMT,nMT,0,0],5,1,wf4(:,23))
  call Hloop_VA_Q(ntryL,G0H64(1),wf4(:,23),G0H16(172),m3h4x16(:,135),heltab2x64(:,:,801))
  call Hloop_A_Q(ntryL,G0H16(172),34,nMT,G1H16(181),n2h16(533))
  Gcoeff(:)%j = (c(9)*M(19,:)%j+c(6)*(M(26,:)%j+M(28,:)%j+M(32,:)%j-M(39,:)%j)) * den(36)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(1153),h0tab(:,1153),[34,1,24,4],[nMT,0,0,0],5,1,wf4(:,23))
  call Hloop_VA_Q(ntryL,G0H64(1),wf4(:,23),G0H16(172),m3h4x16(:,136),heltab2x64(:,:,802))
  call Hloop_A_Q(ntryL,G0H16(172),34,nMT,G1H16(182),n2h16(534))
  Gcoeff(:)%j = (c(9)*M(20,:)%j+c(6)*(M(26,:)%j+M(28,:)%j+M(32,:)%j-M(37,:)%j)) * den(36)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(1154),h0tab(:,1154),[34,1,24,4],[nMT,0,0,0],5,1,wf4(:,23))
  call Hloop_VA_Q(ntryL,G0H64(1),wf4(:,23),G0H16(172),m3h4x16(:,137),heltab2x64(:,:,803))
  call Hloop_A_Q(ntryL,G0H16(172),34,nMT,G1H16(183),n2h16(535))
  Gcoeff(:)%j = (c(9)*(-M(19,:)%j+M(20,:)%j)+c(6)*(-M(37,:)%j+M(39,:)%j)) * den(36)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(1155),h0tab(:,1155),[34,1,24,4],[nMT,0,0,0],5,1,wf4(:,23))
  call Hloop_VA_Q(ntryL,G0H64(1),wf4(:,23),G0H16(172),m3h4x16(:,138),heltab2x64(:,:,804))
  call Hloop_A_Q(ntryL,G0H16(172),34,nMT,G1H16(186),n2h16(536))
  Gcoeff(:)%j = (c(19)*(M(15,:)%j-M(16,:)%j)+c(16)*(M(31,:)%j-M(32,:)%j-M(38,:)%j-M(40,:)%j+M(41,:)%j+M(42,:)%j+M(45,:)%j &
    -M(49,:)%j)) * den(6)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(1156),h0tab(:,1156),[36,1,2,24],[0,nMT,0,0],5,1,wf4(:,4))
  call Hloop_UV_W(ntryL,G0H64(1),0,wf4(:,4),36,G1H16(187),m3h4x16(:,139),heltab2x64(:,:,805))
  Gcoeff(:)%j = (c(19)*(M(9,:)%j-M(10,:)%j)+c(16)*(M(31,:)%j-M(32,:)%j-M(38,:)%j-M(40,:)%j+M(41,:)%j+M(42,:)%j+M(47,:)%j &
    -M(50,:)%j)) * den(6)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(1157),h0tab(:,1157),[36,1,2,24],[0,nMT,0,0],5,1,wf4(:,4))
  call Hloop_UV_W(ntryL,G0H64(1),0,wf4(:,4),36,G1H16(188),m3h4x16(:,140),heltab2x64(:,:,806))
  Gcoeff(:)%j = (c(19)*(M(9,:)%j-M(10,:)%j-M(15,:)%j+M(16,:)%j)+c(16)*(-M(45,:)%j+M(47,:)%j+M(49,:)%j-M(50,:)%j)) * den(6)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(1158),h0tab(:,1158),[36,1,2,24],[0,nMT,0,0],5,1,wf4(:,4))
  call Hloop_UV_W(ntryL,G0H64(1),0,wf4(:,4),36,G1H16(189),m3h4x16(:,141),heltab2x64(:,:,807))
  Gcoeff(:)%j = (c(19)*(-M(5,:)%j+M(19,:)%j)+c(16)*(-M(31,:)%j+M(32,:)%j+M(38,:)%j+M(40,:)%j-M(41,:)%j-M(42,:)%j-M(47,:)%j &
    +M(50,:)%j)) * den(6)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(1159),h0tab(:,1159),[36,2,1,24],[0,nMT,0,0],5,1,wf4(:,4))
  call Hloop_UV_W(ntryL,G0H64(1),0,wf4(:,4),36,G1H16(191),m3h4x16(:,142),heltab2x64(:,:,808))
  Gcoeff(:)%j = (c(19)*(-M(6,:)%j+M(20,:)%j)+c(16)*(-M(31,:)%j+M(32,:)%j+M(38,:)%j+M(40,:)%j-M(41,:)%j-M(42,:)%j-M(45,:)%j &
    +M(49,:)%j)) * den(6)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(1160),h0tab(:,1160),[36,2,1,24],[0,nMT,0,0],5,1,wf4(:,4))
  call Hloop_UV_W(ntryL,G0H64(1),0,wf4(:,4),36,G1H16(193),m3h4x16(:,143),heltab2x64(:,:,809))
  Gcoeff(:)%j = (c(19)*(M(5,:)%j-M(6,:)%j-M(19,:)%j+M(20,:)%j)+c(16)*(-M(45,:)%j+M(47,:)%j+M(49,:)%j-M(50,:)%j)) * den(6)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(1161),h0tab(:,1161),[36,2,1,24],[0,nMT,0,0],5,1,wf4(:,4))
  call Hloop_UV_W(ntryL,G0H64(1),0,wf4(:,4),36,G1H16(196),m3h4x16(:,144),heltab2x64(:,:,810))
  Gcoeff(:)%j = (c(6)*(-M(38,:)%j-M(40,:)%j+M(41,:)%j+M(42,:)%j+M(47,:)%j-M(50,:)%j)) * den(6)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(1162),h0tab(:,1162),[36,1,24,2],[nMT,0,0,nMT],5,1,wf4(:,4))
  call Hloop_AV_Q(ntryL,G0H64(1),wf4(:,4),G0H16(172),m3h4x16(:,145),heltab2x64(:,:,811))
  call Hloop_A_Q(ntryL,G0H16(172),36,nMT,G1H16(197),n2h16(537))
  Gcoeff(:)%j = (c(6)*(-M(38,:)%j-M(40,:)%j+M(41,:)%j+M(42,:)%j+M(45,:)%j-M(49,:)%j)) * den(6)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(1163),h0tab(:,1163),[36,1,24,2],[nMT,0,0,nMT],5,1,wf4(:,4))
  call Hloop_AV_Q(ntryL,G0H64(1),wf4(:,4),G0H16(172),m3h4x16(:,146),heltab2x64(:,:,812))
  call Hloop_A_Q(ntryL,G0H16(172),36,nMT,G1H16(20),n2h16(538))
  Gcoeff(:)%j = (c(6)*(M(45,:)%j-M(47,:)%j-M(49,:)%j+M(50,:)%j)) * den(6)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(1164),h0tab(:,1164),[36,1,24,2],[nMT,0,0,nMT],5,1,wf4(:,4))
  call Hloop_AV_Q(ntryL,G0H64(1),wf4(:,4),G0H16(172),m3h4x16(:,147),heltab2x64(:,:,813))
  call Hloop_A_Q(ntryL,G0H16(172),36,nMT,G1H16(22),n2h16(539))
  Gcoeff(:)%j = (c(15)*(-M(10,:)%j+M(16,:)%j+M(22,:)%j-M(24,:)%j)+c(16)*(M(45,:)%j-M(47,:)%j-M(49,:)%j+M(50,:)%j)) * den(8)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(1165),h0tab(:,1165),[56,2,1,4],[nMT,0,nMT,nMT],4,1,wf8(:,1))
  call Hloop_QV_A(ntryL,G0H64(1),wf8(:,1),G0H8(73),m3h8x8(:,1),heltab2x64(:,:,814))
  call Hloop_Q_A(ntryL,G0H8(73),56,nMT,G1H8(573),n2h8(1314))
  Gcoeff(:)%j = (c(15)*(M(10,:)%j-M(12,:)%j-M(18,:)%j+M(24,:)%j)+c(16)*(-M(45,:)%j+M(46,:)%j+M(48,:)%j-M(50,:)%j)) * den(8)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(1166),h0tab(:,1166),[56,2,1,4],[nMT,0,nMT,nMT],4,1,wf8(:,3))
  call Hloop_QV_A(ntryL,G0H64(1),wf8(:,3),G0H8(73),m3h8x8(:,2),heltab2x64(:,:,815))
  call Hloop_Q_A(ntryL,G0H8(73),56,nMT,G1H8(574),n2h8(1315))
  Gcoeff(:)%j = (c(15)*(M(12,:)%j-M(16,:)%j+M(18,:)%j-M(22,:)%j)+c(16)*(-M(46,:)%j+M(47,:)%j-M(48,:)%j+M(49,:)%j)) * den(8)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(1167),h0tab(:,1167),[56,2,1,4],[nMT,0,nMT,nMT],4,1,wf8(:,4))
  call Hloop_QV_A(ntryL,G0H64(1),wf8(:,4),G0H8(73),m3h8x8(:,3),heltab2x64(:,:,816))
  call Hloop_Q_A(ntryL,G0H8(73),56,nMT,G1H8(669),n2h8(1316))
  Gcoeff(:)%j = (c(19)*(M(10,:)%j-M(16,:)%j-M(22,:)%j+M(24,:)%j)+c(16)*(M(45,:)%j-M(47,:)%j-M(49,:)%j+M(50,:)%j)) * den(8)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(1168),h0tab(:,1168),[56,2,1,4],[0,nMT,0,0],4,1,wf8(:,1))
  call Hloop_UV_W(ntryL,G0H64(1),0,wf8(:,1),56,G1H8(687),m3h8x8(:,4),heltab2x64(:,:,817))
  Gcoeff(:)%j = (c(19)*(-M(10,:)%j+M(12,:)%j+M(18,:)%j-M(24,:)%j)+c(16)*(-M(45,:)%j+M(46,:)%j+M(48,:)%j-M(50,:)%j)) * den(8)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(1169),h0tab(:,1169),[56,2,1,4],[0,nMT,0,0],4,1,wf8(:,3))
  call Hloop_UV_W(ntryL,G0H64(1),0,wf8(:,3),56,G1H8(482),m3h8x8(:,5),heltab2x64(:,:,818))
  Gcoeff(:)%j = (c(19)*(-M(12,:)%j+M(16,:)%j-M(18,:)%j+M(22,:)%j)+c(16)*(-M(46,:)%j+M(47,:)%j-M(48,:)%j+M(49,:)%j)) * den(8)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(1170),h0tab(:,1170),[56,2,1,4],[0,nMT,0,0],4,1,wf8(:,4))
  call Hloop_UV_W(ntryL,G0H64(1),0,wf8(:,4),56,G1H8(485),m3h8x8(:,6),heltab2x64(:,:,819))
  Gcoeff(:)%j = (c(15)*(-M(1,:)%j+M(3,:)%j+M(5,:)%j-M(6,:)%j)+c(16)*(M(45,:)%j-M(47,:)%j-M(49,:)%j+M(50,:)%j)) * den(8)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(1171),h0tab(:,1171),[56,1,2,4],[nMT,0,nMT,nMT],4,1,wf8(:,1))
  call Hloop_AV_Q(ntryL,G0H64(1),wf8(:,1),G0H8(73),m3h8x8(:,7),heltab2x64(:,:,820))
  call Hloop_A_Q(ntryL,G0H8(73),56,nMT,G1H8(523),n2h8(1317))
  Gcoeff(:)%j = (c(15)*(M(1,:)%j-M(2,:)%j-M(4,:)%j+M(6,:)%j)+c(16)*(-M(45,:)%j+M(46,:)%j+M(48,:)%j-M(50,:)%j)) * den(8)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(1172),h0tab(:,1172),[56,1,2,4],[nMT,0,nMT,nMT],4,1,wf8(:,3))
  call Hloop_AV_Q(ntryL,G0H64(1),wf8(:,3),G0H8(73),m3h8x8(:,8),heltab2x64(:,:,821))
  call Hloop_A_Q(ntryL,G0H8(73),56,nMT,G1H8(518),n2h8(1318))
  Gcoeff(:)%j = (c(15)*(M(2,:)%j-M(3,:)%j+M(4,:)%j-M(5,:)%j)+c(16)*(-M(46,:)%j+M(47,:)%j-M(48,:)%j+M(49,:)%j)) * den(8)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(1173),h0tab(:,1173),[56,1,2,4],[nMT,0,nMT,nMT],4,1,wf8(:,4))
  call Hloop_AV_Q(ntryL,G0H64(1),wf8(:,4),G0H8(73),m3h8x8(:,9),heltab2x64(:,:,822))
  call Hloop_A_Q(ntryL,G0H8(73),56,nMT,G1H8(553),n2h8(1319))
  Gcoeff(:)%j = (c(19)*(M(1,:)%j-M(3,:)%j-M(5,:)%j+M(6,:)%j)+c(16)*(M(45,:)%j-M(47,:)%j-M(49,:)%j+M(50,:)%j)) * den(8)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(1174),h0tab(:,1174),[56,1,2,4],[0,nMT,0,0],4,1,wf8(:,1))
  call Hloop_UV_W(ntryL,G0H64(1),0,wf8(:,1),56,G1H8(559),m3h8x8(:,10),heltab2x64(:,:,823))
  Gcoeff(:)%j = (c(19)*(-M(1,:)%j+M(2,:)%j+M(4,:)%j-M(6,:)%j)+c(16)*(-M(45,:)%j+M(46,:)%j+M(48,:)%j-M(50,:)%j)) * den(8)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(1175),h0tab(:,1175),[56,1,2,4],[0,nMT,0,0],4,1,wf8(:,3))
  call Hloop_UV_W(ntryL,G0H64(1),0,wf8(:,3),56,G1H8(584),m3h8x8(:,11),heltab2x64(:,:,824))
  Gcoeff(:)%j = (c(19)*(-M(2,:)%j+M(3,:)%j-M(4,:)%j+M(5,:)%j)+c(16)*(-M(46,:)%j+M(47,:)%j-M(48,:)%j+M(49,:)%j)) * den(8)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(1176),h0tab(:,1176),[56,1,2,4],[0,nMT,0,0],4,1,wf8(:,4))
  call Hloop_UV_W(ntryL,G0H64(1),0,wf8(:,4),56,G1H8(595),m3h8x8(:,12),heltab2x64(:,:,825))
  Gcoeff(:)%j = (c(6)*(M(45,:)%j-M(47,:)%j-M(49,:)%j+M(50,:)%j)) * den(8)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(1177),h0tab(:,1177),[56,1,4,2],[0,nMT,nMT,0],4,1,wf8(:,1))
  call Hloop_UV_W(ntryL,G0H64(1),0,wf8(:,1),56,G1H8(620),m3h8x8(:,13),heltab2x64(:,:,826))
  Gcoeff(:)%j = (c(6)*(-M(45,:)%j+M(46,:)%j+M(48,:)%j-M(50,:)%j)) * den(8)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(1178),h0tab(:,1178),[56,1,4,2],[0,nMT,nMT,0],4,1,wf8(:,3))
  call Hloop_UV_W(ntryL,G0H64(1),0,wf8(:,3),56,G1H8(625),m3h8x8(:,14),heltab2x64(:,:,827))
  Gcoeff(:)%j = (c(6)*(-M(46,:)%j+M(47,:)%j-M(48,:)%j+M(49,:)%j)) * den(8)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(1179),h0tab(:,1179),[56,1,4,2],[0,nMT,nMT,0],4,1,wf8(:,4))
  call Hloop_UV_W(ntryL,G0H64(1),0,wf8(:,4),56,G1H8(655),m3h8x8(:,15),heltab2x64(:,:,828))
  Gcoeff(:)%j = (c(6)*(-M(45,:)%j+M(47,:)%j+M(49,:)%j-M(50,:)%j)) * den(8)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(1180),h0tab(:,1180),[56,1,4,2],[nMT,0,0,nMT],4,1,wf8(:,1))
  call Hloop_AV_Q(ntryL,G0H64(1),wf8(:,1),G0H8(73),m3h8x8(:,16),heltab2x64(:,:,829))
  call Hloop_A_Q(ntryL,G0H8(73),56,nMT,G1H8(656),n2h8(1320))
  Gcoeff(:)%j = (c(6)*(M(45,:)%j-M(46,:)%j-M(48,:)%j+M(50,:)%j)) * den(8)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(1181),h0tab(:,1181),[56,1,4,2],[nMT,0,0,nMT],4,1,wf8(:,3))
  call Hloop_AV_Q(ntryL,G0H64(1),wf8(:,3),G0H8(73),m3h8x8(:,17),heltab2x64(:,:,830))
  call Hloop_A_Q(ntryL,G0H8(73),56,nMT,G1H8(692),n2h8(1321))
  Gcoeff(:)%j = (c(6)*(M(46,:)%j-M(47,:)%j+M(48,:)%j-M(49,:)%j)) * den(8)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(1182),h0tab(:,1182),[56,1,4,2],[nMT,0,0,nMT],4,1,wf8(:,4))
  call Hloop_AV_Q(ntryL,G0H64(1),wf8(:,4),G0H8(73),m3h8x8(:,18),heltab2x64(:,:,831))
  call Hloop_A_Q(ntryL,G0H8(73),56,nMT,G1H8(703),n2h8(1322))
  Gcoeff(:)%j = (-(c(9)*M(17,:)%j)+c(6)*(-M(28,:)%j-M(30,:)%j-M(35,:)%j+M(42,:)%j)) * den(26)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(1183),h0tab(:,1183),[36,9,2,16],[0,nMT,0,0],5,1,wf4(:,13))
  call Hloop_GGG_G_12(ntryL,G0H64(1),ex6(:),ex3(:),G0H16(172),m4h2x2x16(:,280),heltab3x64(:,:,352))
  Gcoeff(:)%j = (-(c(9)*M(14,:)%j)+c(6)*(-M(28,:)%j-M(30,:)%j-M(35,:)%j+M(40,:)%j)) * den(26)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(1184),h0tab(:,1184),[36,9,2,16],[0,nMT,0,0],5,1,wf4(:,13))
  call Hloop_GGG_G_12(ntryL,G0H64(1),ex3(:),ex6(:),G0H16(173),m4h2x2x16(:,281),heltab3x64(:,:,353))
  Gcoeff(:)%j = (c(9)*(-M(14,:)%j+M(17,:)%j)+c(6)*(M(40,:)%j-M(42,:)%j)) * den(26)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(1185),h0tab(:,1185),[36,9,2,16],[0,nMT,0,0],5,1,wf4(:,13))
  call Hloop_GGG_G_23(ntryL,G0H64(1),ex6(:),ex3(:),G0H16(174),m4h2x2x16(:,282),heltab3x64(:,:,354))
  Gcoeff(:)%j = (c(16)*(-M(28,:)%j-M(35,:)%j+M(40,:)%j)) * den(26)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(1186),h0tab(:,1186),[36,2,16,9],[0,nMT,nMT,0],5,1,wf4(:,13))
  call Hloop_GGG_G_12(ntryL,G0H64(1),ex6(:),ex3(:),G0H16(175),m4h2x2x16(:,283),heltab3x64(:,:,355))
  Gcoeff(:)%j = (c(16)*(-M(28,:)%j-M(35,:)%j+M(42,:)%j)) * den(26)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(1187),h0tab(:,1187),[36,2,16,9],[0,nMT,nMT,0],5,1,wf4(:,13))
  call Hloop_GGG_G_12(ntryL,G0H64(1),ex3(:),ex6(:),G0H16(176),m4h2x2x16(:,284),heltab3x64(:,:,356))
  Gcoeff(:)%j = (c(16)*(-M(40,:)%j+M(42,:)%j)) * den(26)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(1188),h0tab(:,1188),[36,2,16,9],[0,nMT,nMT,0],5,1,wf4(:,13))
  call Hloop_GGG_G_23(ntryL,G0H64(1),ex6(:),ex3(:),G0H16(177),m4h2x2x16(:,285),heltab3x64(:,:,357))
  Gcoeff(:)%j = (c(9)*M(6,:)%j+c(6)*(M(28,:)%j+M(30,:)%j+M(35,:)%j-M(40,:)%j)) * den(26)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(1189),h0tab(:,1189),[36,2,9,16],[0,nMT,0,0],5,1,wf4(:,13))
  call Hloop_GGG_G_12(ntryL,G0H64(1),ex6(:),ex3(:),G0H16(178),m4h2x2x16(:,286),heltab3x64(:,:,358))
  Gcoeff(:)%j = (c(9)*M(20,:)%j+c(6)*(M(28,:)%j+M(30,:)%j+M(35,:)%j-M(42,:)%j)) * den(26)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(1190),h0tab(:,1190),[36,2,9,16],[0,nMT,0,0],5,1,wf4(:,13))
  call Hloop_GGG_G_12(ntryL,G0H64(1),ex3(:),ex6(:),G0H16(179),m4h2x2x16(:,287),heltab3x64(:,:,359))
  Gcoeff(:)%j = (c(9)*(-M(6,:)%j+M(20,:)%j)+c(6)*(M(40,:)%j-M(42,:)%j)) * den(26)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(1191),h0tab(:,1191),[36,2,9,16],[0,nMT,0,0],5,1,wf4(:,13))
  call Hloop_GGG_G_23(ntryL,G0H64(1),ex6(:),ex3(:),G0H16(180),m4h2x2x16(:,288),heltab3x64(:,:,360))
  Gcoeff(:)%j = (c(9)*M(20,:)%j+c(6)*(M(28,:)%j+M(30,:)%j+M(35,:)%j-M(42,:)%j)) * den(26)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(1192),h0tab(:,1192),[32,2,9,20],[0,nMT,0,0],5,1,wf4(:,13))
  call Hloop_UV_W(ntryL,G0H64(1),0,ex6(:),32,G1H32(67),m3h2x32(:,667),heltab2x64(:,:,832))
  Gcoeff(:)%j = (c(9)*M(23,:)%j+c(6)*(M(28,:)%j+M(30,:)%j+M(35,:)%j-M(40,:)%j)) * den(26)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(1193),h0tab(:,1193),[32,2,9,20],[0,nMT,0,0],5,1,wf4(:,13))
  call Hloop_UV_W(ntryL,G0H64(1),0,ex6(:),32,G1H32(68),m3h2x32(:,668),heltab2x64(:,:,833))
  Gcoeff(:)%j = (c(9)*(-M(20,:)%j+M(23,:)%j)+c(6)*(-M(40,:)%j+M(42,:)%j)) * den(26)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(1194),h0tab(:,1194),[32,2,9,20],[0,nMT,0,0],5,1,wf4(:,13))
  call Hloop_UV_W(ntryL,G0H64(1),0,ex6(:),32,G1H32(69),m3h2x32(:,669),heltab2x64(:,:,834))
  Gcoeff(:)%j = (c(16)*(-M(30,:)%j-M(35,:)%j+M(40,:)%j)) * den(26)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(1195),h0tab(:,1195),[32,2,20,9],[nMT,0,0,nMT],5,1,wf4(:,13))
  call Hloop_QV_A(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,670),heltab2x64(:,:,835))
  call Hloop_Q_A(ntryL,G0H32(1),32,nMT,G1H32(70),n2h32(313))
  Gcoeff(:)%j = (c(16)*(-M(30,:)%j-M(35,:)%j+M(42,:)%j)) * den(26)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(1196),h0tab(:,1196),[32,2,20,9],[nMT,0,0,nMT],5,1,wf4(:,13))
  call Hloop_QV_A(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,671),heltab2x64(:,:,836))
  call Hloop_Q_A(ntryL,G0H32(1),32,nMT,G1H32(71),n2h32(314))
  Gcoeff(:)%j = (c(16)*(-M(40,:)%j+M(42,:)%j)) * den(26)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(1197),h0tab(:,1197),[32,2,20,9],[nMT,0,0,nMT],5,1,wf4(:,13))
  call Hloop_QV_A(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,672),heltab2x64(:,:,837))
  call Hloop_Q_A(ntryL,G0H32(1),32,nMT,G1H32(72),n2h32(315))
  Gcoeff(:)%j = (-(c(9)*M(14,:)%j)+c(6)*(-M(28,:)%j-M(30,:)%j-M(35,:)%j+M(40,:)%j)) * den(26)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(1198),h0tab(:,1198),[32,9,2,20],[0,nMT,0,0],5,1,wf4(:,13))
  call Hloop_UV_W(ntryL,G0H64(1),0,ex6(:),32,G1H32(73),m3h2x32(:,673),heltab2x64(:,:,838))
  Gcoeff(:)%j = (-(c(9)*M(4,:)%j)+c(6)*(-M(28,:)%j-M(30,:)%j-M(35,:)%j+M(42,:)%j)) * den(26)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(1199),h0tab(:,1199),[32,9,2,20],[0,nMT,0,0],5,1,wf4(:,13))
  call Hloop_UV_W(ntryL,G0H64(1),0,ex6(:),32,G1H32(74),m3h2x32(:,674),heltab2x64(:,:,839))
  Gcoeff(:)%j = (c(9)*(-M(4,:)%j+M(14,:)%j)+c(6)*(-M(40,:)%j+M(42,:)%j)) * den(26)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(1200),h0tab(:,1200),[32,9,2,20],[0,nMT,0,0],5,1,wf4(:,13))
  call Hloop_UV_W(ntryL,G0H64(1),0,ex6(:),32,G1H32(75),m3h2x32(:,675),heltab2x64(:,:,840))
  Gcoeff(:)%j = (c(9)*M(8,:)%j+c(6)*(M(27,:)%j+M(29,:)%j+M(36,:)%j-M(40,:)%j)) * den(28)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(1201),h0tab(:,1201),[36,10,1,16],[0,nMT,0,0],5,1,wf4(:,15))
  call Hloop_GGG_G_12(ntryL,G0H64(1),ex6(:),ex3(:),G0H16(181),m4h2x2x16(:,289),heltab3x64(:,:,361))
  Gcoeff(:)%j = (c(9)*M(11,:)%j+c(6)*(M(27,:)%j+M(29,:)%j+M(36,:)%j-M(42,:)%j)) * den(28)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(1202),h0tab(:,1202),[36,10,1,16],[0,nMT,0,0],5,1,wf4(:,15))
  call Hloop_GGG_G_12(ntryL,G0H64(1),ex3(:),ex6(:),G0H16(182),m4h2x2x16(:,290),heltab3x64(:,:,362))
  Gcoeff(:)%j = (c(9)*(-M(8,:)%j+M(11,:)%j)+c(6)*(M(40,:)%j-M(42,:)%j)) * den(28)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(1203),h0tab(:,1203),[36,10,1,16],[0,nMT,0,0],5,1,wf4(:,15))
  call Hloop_GGG_G_23(ntryL,G0H64(1),ex6(:),ex3(:),G0H16(183),m4h2x2x16(:,291),heltab3x64(:,:,363))
  Gcoeff(:)%j = (c(16)*(-M(27,:)%j-M(36,:)%j+M(42,:)%j)) * den(28)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(1204),h0tab(:,1204),[36,1,16,10],[0,nMT,nMT,0],5,1,wf4(:,15))
  call Hloop_GGG_G_12(ntryL,G0H64(1),ex6(:),ex3(:),G0H16(184),m4h2x2x16(:,292),heltab3x64(:,:,364))
  Gcoeff(:)%j = (c(16)*(-M(27,:)%j-M(36,:)%j+M(40,:)%j)) * den(28)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(1205),h0tab(:,1205),[36,1,16,10],[0,nMT,nMT,0],5,1,wf4(:,15))
  call Hloop_GGG_G_12(ntryL,G0H64(1),ex3(:),ex6(:),G0H16(185),m4h2x2x16(:,293),heltab3x64(:,:,365))
  Gcoeff(:)%j = (c(16)*(M(40,:)%j-M(42,:)%j)) * den(28)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(1206),h0tab(:,1206),[36,1,16,10],[0,nMT,nMT,0],5,1,wf4(:,15))
  call Hloop_GGG_G_23(ntryL,G0H64(1),ex6(:),ex3(:),G0H16(186),m4h2x2x16(:,294),heltab3x64(:,:,366))
  Gcoeff(:)%j = (-(c(9)*M(10,:)%j)+c(6)*(-M(27,:)%j-M(29,:)%j-M(36,:)%j+M(42,:)%j)) * den(28)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(1207),h0tab(:,1207),[36,1,10,16],[0,nMT,0,0],5,1,wf4(:,15))
  call Hloop_GGG_G_12(ntryL,G0H64(1),ex6(:),ex3(:),G0H16(187),m4h2x2x16(:,295),heltab3x64(:,:,367))
  Gcoeff(:)%j = (-(c(9)*M(9,:)%j)+c(6)*(-M(27,:)%j-M(29,:)%j-M(36,:)%j+M(40,:)%j)) * den(28)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(1208),h0tab(:,1208),[36,1,10,16],[0,nMT,0,0],5,1,wf4(:,15))
  call Hloop_GGG_G_12(ntryL,G0H64(1),ex3(:),ex6(:),G0H16(188),m4h2x2x16(:,296),heltab3x64(:,:,368))
  Gcoeff(:)%j = (c(9)*(-M(9,:)%j+M(10,:)%j)+c(6)*(M(40,:)%j-M(42,:)%j)) * den(28)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(1209),h0tab(:,1209),[36,1,10,16],[0,nMT,0,0],5,1,wf4(:,15))
  call Hloop_GGG_G_23(ntryL,G0H64(1),ex6(:),ex3(:),G0H16(189),m4h2x2x16(:,297),heltab3x64(:,:,369))
  Gcoeff(:)%j = (-(c(9)*M(9,:)%j)+c(6)*(-M(27,:)%j-M(29,:)%j-M(36,:)%j+M(40,:)%j)) * den(28)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(1210),h0tab(:,1210),[32,1,10,20],[0,nMT,0,0],5,1,wf4(:,15))
  call Hloop_UV_W(ntryL,G0H64(1),0,ex6(:),32,G1H32(76),m3h2x32(:,676),heltab2x64(:,:,841))
  Gcoeff(:)%j = (-(c(9)*M(7,:)%j)+c(6)*(-M(27,:)%j-M(29,:)%j-M(36,:)%j+M(42,:)%j)) * den(28)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(1211),h0tab(:,1211),[32,1,10,20],[0,nMT,0,0],5,1,wf4(:,15))
  call Hloop_UV_W(ntryL,G0H64(1),0,ex6(:),32,G1H32(77),m3h2x32(:,677),heltab2x64(:,:,842))
  Gcoeff(:)%j = (c(9)*(-M(7,:)%j+M(9,:)%j)+c(6)*(-M(40,:)%j+M(42,:)%j)) * den(28)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(1212),h0tab(:,1212),[32,1,10,20],[0,nMT,0,0],5,1,wf4(:,15))
  call Hloop_UV_W(ntryL,G0H64(1),0,ex6(:),32,G1H32(78),m3h2x32(:,678),heltab2x64(:,:,843))
  Gcoeff(:)%j = (c(16)*(-M(29,:)%j-M(36,:)%j+M(42,:)%j)) * den(28)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(1213),h0tab(:,1213),[32,1,20,10],[nMT,0,0,nMT],5,1,wf4(:,15))
  call Hloop_AV_Q(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,679),heltab2x64(:,:,844))
  call Hloop_A_Q(ntryL,G0H32(1),32,nMT,G1H32(79),n2h32(316))
  Gcoeff(:)%j = (c(16)*(-M(29,:)%j-M(36,:)%j+M(40,:)%j)) * den(28)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(1214),h0tab(:,1214),[32,1,20,10],[nMT,0,0,nMT],5,1,wf4(:,15))
  call Hloop_AV_Q(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,680),heltab2x64(:,:,845))
  call Hloop_A_Q(ntryL,G0H32(1),32,nMT,G1H32(80),n2h32(317))
  Gcoeff(:)%j = (c(16)*(M(40,:)%j-M(42,:)%j)) * den(28)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(1215),h0tab(:,1215),[32,1,20,10],[nMT,0,0,nMT],5,1,wf4(:,15))
  call Hloop_AV_Q(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,681),heltab2x64(:,:,846))
  call Hloop_A_Q(ntryL,G0H32(1),32,nMT,G1H32(81),n2h32(318))
  Gcoeff(:)%j = (c(9)*M(11,:)%j+c(6)*(M(27,:)%j+M(29,:)%j+M(36,:)%j-M(42,:)%j)) * den(28)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(1216),h0tab(:,1216),[32,10,1,20],[0,nMT,0,0],5,1,wf4(:,15))
  call Hloop_UV_W(ntryL,G0H64(1),0,ex6(:),32,G1H32(82),m3h2x32(:,682),heltab2x64(:,:,847))
  Gcoeff(:)%j = (c(9)*M(12,:)%j+c(6)*(M(27,:)%j+M(29,:)%j+M(36,:)%j-M(40,:)%j)) * den(28)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(1217),h0tab(:,1217),[32,10,1,20],[0,nMT,0,0],5,1,wf4(:,15))
  call Hloop_UV_W(ntryL,G0H64(1),0,ex6(:),32,G1H32(83),m3h2x32(:,683),heltab2x64(:,:,848))
  Gcoeff(:)%j = (c(9)*(-M(11,:)%j+M(12,:)%j)+c(6)*(-M(40,:)%j+M(42,:)%j)) * den(28)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(1218),h0tab(:,1218),[32,10,1,20],[0,nMT,0,0],5,1,wf4(:,15))
  call Hloop_UV_W(ntryL,G0H64(1),0,ex6(:),32,G1H32(84),m3h2x32(:,684),heltab2x64(:,:,849))
  Gcoeff(:)%j = (c(9)*M(8,:)%j+c(6)*(M(26,:)%j+M(29,:)%j+M(33,:)%j-M(38,:)%j)) * den(30)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(1219),h0tab(:,1219),[36,8,2,17],[0,0,nMT,0],5,1,wf4(:,17))
  call Hloop_GGG_G_12(ntryL,G0H64(1),ex6(:),ex3(:),G0H16(190),m4h2x2x16(:,298),heltab3x64(:,:,370))
  Gcoeff(:)%j = (c(9)*M(11,:)%j+c(6)*(M(26,:)%j+M(29,:)%j+M(33,:)%j-M(41,:)%j)) * den(30)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(1220),h0tab(:,1220),[36,8,2,17],[0,0,nMT,0],5,1,wf4(:,17))
  call Hloop_GGG_G_12(ntryL,G0H64(1),ex3(:),ex6(:),G0H16(191),m4h2x2x16(:,299),heltab3x64(:,:,371))
  Gcoeff(:)%j = (c(9)*(-M(8,:)%j+M(11,:)%j)+c(6)*(M(38,:)%j-M(41,:)%j)) * den(30)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(1221),h0tab(:,1221),[36,8,2,17],[0,0,nMT,0],5,1,wf4(:,17))
  call Hloop_GGG_G_23(ntryL,G0H64(1),ex6(:),ex3(:),G0H16(192),m4h2x2x16(:,300),heltab3x64(:,:,372))
  Gcoeff(:)%j = (c(16)*(-M(26,:)%j-M(33,:)%j+M(38,:)%j)) * den(30)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(1222),h0tab(:,1222),[36,2,8,17],[0,nMT,nMT,0],5,1,wf4(:,17))
  call Hloop_GGG_G_12(ntryL,G0H64(1),ex6(:),ex3(:),G0H16(193),m4h2x2x16(:,301),heltab3x64(:,:,373))
  Gcoeff(:)%j = (c(16)*(-M(26,:)%j-M(33,:)%j+M(41,:)%j)) * den(30)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(1223),h0tab(:,1223),[36,2,8,17],[0,nMT,nMT,0],5,1,wf4(:,17))
  call Hloop_GGG_G_12(ntryL,G0H64(1),ex3(:),ex6(:),G0H16(194),m4h2x2x16(:,302),heltab3x64(:,:,374))
  Gcoeff(:)%j = (c(16)*(-M(38,:)%j+M(41,:)%j)) * den(30)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(1224),h0tab(:,1224),[36,2,8,17],[0,nMT,nMT,0],5,1,wf4(:,17))
  call Hloop_GGG_G_23(ntryL,G0H64(1),ex6(:),ex3(:),G0H16(195),m4h2x2x16(:,303),heltab3x64(:,:,375))
  Gcoeff(:)%j = (c(9)*M(5,:)%j+c(6)*(M(26,:)%j+M(29,:)%j+M(33,:)%j-M(38,:)%j)) * den(30)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(1225),h0tab(:,1225),[36,2,17,8],[0,nMT,0,0],5,1,wf4(:,17))
  call Hloop_GGG_G_12(ntryL,G0H64(1),ex6(:),ex3(:),G0H16(196),m4h2x2x16(:,304),heltab3x64(:,:,376))
  Gcoeff(:)%j = (c(9)*M(19,:)%j+c(6)*(M(26,:)%j+M(29,:)%j+M(33,:)%j-M(41,:)%j)) * den(30)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(1226),h0tab(:,1226),[36,2,17,8],[0,nMT,0,0],5,1,wf4(:,17))
  call Hloop_GGG_G_12(ntryL,G0H64(1),ex3(:),ex6(:),G0H16(197),m4h2x2x16(:,305),heltab3x64(:,:,377))
  Gcoeff(:)%j = (c(9)*(-M(5,:)%j+M(19,:)%j)+c(6)*(M(38,:)%j-M(41,:)%j)) * den(30)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(1227),h0tab(:,1227),[36,2,17,8],[0,nMT,0,0],5,1,wf4(:,17))
  call Hloop_GGG_G_23(ntryL,G0H64(1),ex6(:),ex3(:),G0H16(198),m4h2x2x16(:,306),heltab3x64(:,:,378))
  Gcoeff(:)%j = (-(c(9)*M(17,:)%j)+c(6)*(-M(25,:)%j-M(30,:)%j-M(34,:)%j+M(41,:)%j)) * den(32)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(1228),h0tab(:,1228),[36,8,1,18],[0,0,nMT,0],5,1,wf4(:,19))
  call Hloop_GGG_G_12(ntryL,G0H64(1),ex6(:),ex3(:),G0H16(199),m4h2x2x16(:,307),heltab3x64(:,:,379))
  Gcoeff(:)%j = (-(c(9)*M(14,:)%j)+c(6)*(-M(25,:)%j-M(30,:)%j-M(34,:)%j+M(38,:)%j)) * den(32)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(1229),h0tab(:,1229),[36,8,1,18],[0,0,nMT,0],5,1,wf4(:,19))
  call Hloop_GGG_G_12(ntryL,G0H64(1),ex3(:),ex6(:),G0H16(200),m4h2x2x16(:,308),heltab3x64(:,:,380))
  Gcoeff(:)%j = (c(9)*(-M(14,:)%j+M(17,:)%j)+c(6)*(M(38,:)%j-M(41,:)%j)) * den(32)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(1230),h0tab(:,1230),[36,8,1,18],[0,0,nMT,0],5,1,wf4(:,19))
  call Hloop_GGG_G_23(ntryL,G0H64(1),ex6(:),ex3(:),G0H16(201),m4h2x2x16(:,309),heltab3x64(:,:,381))
  Gcoeff(:)%j = (c(16)*(-M(25,:)%j-M(34,:)%j+M(41,:)%j)) * den(32)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(1231),h0tab(:,1231),[36,1,8,18],[0,nMT,nMT,0],5,1,wf4(:,19))
  call Hloop_GGG_G_12(ntryL,G0H64(1),ex6(:),ex3(:),G0H16(202),m4h2x2x16(:,310),heltab3x64(:,:,382))
  Gcoeff(:)%j = (c(16)*(-M(25,:)%j-M(34,:)%j+M(38,:)%j)) * den(32)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(1232),h0tab(:,1232),[36,1,8,18],[0,nMT,nMT,0],5,1,wf4(:,19))
  call Hloop_GGG_G_12(ntryL,G0H64(1),ex3(:),ex6(:),G0H16(203),m4h2x2x16(:,311),heltab3x64(:,:,383))
  Gcoeff(:)%j = (c(16)*(M(38,:)%j-M(41,:)%j)) * den(32)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(1233),h0tab(:,1233),[36,1,8,18],[0,nMT,nMT,0],5,1,wf4(:,19))
  call Hloop_GGG_G_23(ntryL,G0H64(1),ex6(:),ex3(:),G0H16(204),m4h2x2x16(:,312),heltab3x64(:,:,384))
  Gcoeff(:)%j = (-(c(9)*M(16,:)%j)+c(6)*(-M(25,:)%j-M(30,:)%j-M(34,:)%j+M(41,:)%j)) * den(32)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(1234),h0tab(:,1234),[36,1,18,8],[0,nMT,0,0],5,1,wf4(:,19))
  call Hloop_GGG_G_12(ntryL,G0H64(1),ex6(:),ex3(:),G0H16(205),m4h2x2x16(:,313),heltab3x64(:,:,385))
  Gcoeff(:)%j = (-(c(9)*M(15,:)%j)+c(6)*(-M(25,:)%j-M(30,:)%j-M(34,:)%j+M(38,:)%j)) * den(32)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(1235),h0tab(:,1235),[36,1,18,8],[0,nMT,0,0],5,1,wf4(:,19))
  call Hloop_GGG_G_12(ntryL,G0H64(1),ex3(:),ex6(:),G0H16(206),m4h2x2x16(:,314),heltab3x64(:,:,386))
  Gcoeff(:)%j = (c(9)*(-M(15,:)%j+M(16,:)%j)+c(6)*(M(38,:)%j-M(41,:)%j)) * den(32)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(1236),h0tab(:,1236),[36,1,18,8],[0,nMT,0,0],5,1,wf4(:,19))
  call Hloop_GGG_G_23(ntryL,G0H64(1),ex6(:),ex3(:),G0H16(207),m4h2x2x16(:,315),heltab3x64(:,:,387))
  Gcoeff(:)%j = (c(19)*(M(1,:)%j-M(3,:)%j)+c(16)*(M(29,:)%j-M(30,:)%j+M(37,:)%j-M(39,:)%j+M(43,:)%j-M(44,:)%j-M(49,:)%j &
    +M(50,:)%j)) * den(10)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(1237),h0tab(:,1237),[32,1,2,28],[0,nMT,0,0],5,1,wf4(:,5))
  call Hloop_UV_W(ntryL,G0H64(1),0,ex6(:),32,G1H32(85),m3h2x32(:,685),heltab2x64(:,:,850))
  Gcoeff(:)%j = (c(19)*(M(9,:)%j-M(15,:)%j)+c(16)*(M(29,:)%j-M(30,:)%j+M(37,:)%j-M(39,:)%j+M(43,:)%j-M(44,:)%j-M(45,:)%j &
    +M(47,:)%j)) * den(10)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(1238),h0tab(:,1238),[32,1,2,28],[0,nMT,0,0],5,1,wf4(:,5))
  call Hloop_UV_W(ntryL,G0H64(1),0,ex6(:),32,G1H32(86),m3h2x32(:,686),heltab2x64(:,:,851))
  Gcoeff(:)%j = (c(19)*(-M(1,:)%j+M(3,:)%j+M(9,:)%j-M(15,:)%j)+c(16)*(-M(45,:)%j+M(47,:)%j+M(49,:)%j-M(50,:)%j)) * den(10)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(1239),h0tab(:,1239),[32,1,2,28],[0,nMT,0,0],5,1,wf4(:,5))
  call Hloop_UV_W(ntryL,G0H64(1),0,ex6(:),32,G1H32(87),m3h2x32(:,687),heltab2x64(:,:,852))
  Gcoeff(:)%j = (c(19)*(-M(22,:)%j+M(24,:)%j)+c(16)*(-M(29,:)%j+M(30,:)%j-M(37,:)%j+M(39,:)%j-M(43,:)%j+M(44,:)%j+M(45,:)%j &
    -M(47,:)%j)) * den(10)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(1240),h0tab(:,1240),[32,2,1,28],[0,nMT,0,0],5,1,wf4(:,5))
  call Hloop_UV_W(ntryL,G0H64(1),0,ex6(:),32,G1H32(88),m3h2x32(:,688),heltab2x64(:,:,853))
  Gcoeff(:)%j = (c(19)*(-M(19,:)%j+M(20,:)%j)+c(16)*(-M(29,:)%j+M(30,:)%j-M(37,:)%j+M(39,:)%j-M(43,:)%j+M(44,:)%j+M(49,:)%j &
    -M(50,:)%j)) * den(10)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(1241),h0tab(:,1241),[32,2,1,28],[0,nMT,0,0],5,1,wf4(:,5))
  call Hloop_UV_W(ntryL,G0H64(1),0,ex6(:),32,G1H32(89),m3h2x32(:,689),heltab2x64(:,:,854))
  Gcoeff(:)%j = (c(19)*(-M(19,:)%j+M(20,:)%j+M(22,:)%j-M(24,:)%j)+c(16)*(-M(45,:)%j+M(47,:)%j+M(49,:)%j-M(50,:)%j)) * den(10)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(1242),h0tab(:,1242),[32,2,1,28],[0,nMT,0,0],5,1,wf4(:,5))
  call Hloop_UV_W(ntryL,G0H64(1),0,ex6(:),32,G1H32(90),m3h2x32(:,690),heltab2x64(:,:,855))
  Gcoeff(:)%j = (c(6)*(M(29,:)%j-M(30,:)%j+M(43,:)%j-M(44,:)%j-M(45,:)%j+M(47,:)%j)) * den(10)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(1243),h0tab(:,1243),[32,1,28,2],[nMT,0,0,nMT],5,1,wf4(:,5))
  call Hloop_AV_Q(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,691),heltab2x64(:,:,856))
  call Hloop_A_Q(ntryL,G0H32(1),32,nMT,G1H32(91),n2h32(319))
  Gcoeff(:)%j = (c(6)*(M(29,:)%j-M(30,:)%j+M(43,:)%j-M(44,:)%j-M(49,:)%j+M(50,:)%j)) * den(10)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(1244),h0tab(:,1244),[32,1,28,2],[nMT,0,0,nMT],5,1,wf4(:,5))
  call Hloop_AV_Q(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,692),heltab2x64(:,:,857))
  call Hloop_A_Q(ntryL,G0H32(1),32,nMT,G1H32(92),n2h32(320))
  Gcoeff(:)%j = (c(6)*(M(45,:)%j-M(47,:)%j-M(49,:)%j+M(50,:)%j)) * den(10)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(1245),h0tab(:,1245),[32,1,28,2],[nMT,0,0,nMT],5,1,wf4(:,5))
  call Hloop_AV_Q(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,693),heltab2x64(:,:,858))
  call Hloop_A_Q(ntryL,G0H32(1),32,nMT,G1H32(93),n2h32(321))
  Gcoeff(:)%j = (c(19)*(-M(5,:)%j+M(6,:)%j)+c(16)*(-M(29,:)%j+M(30,:)%j-M(37,:)%j+M(39,:)%j-M(43,:)%j+M(44,:)%j+M(45,:)%j &
    -M(47,:)%j)) * den(10)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(1246),h0tab(:,1246),[36,2,1,24],[0,nMT,0,0],5,1,wf4(:,5))
  call Hloop_GGG_G_12(ntryL,G0H64(1),ex6(:),ex3(:),G0H16(208),m4h2x2x16(:,316),heltab3x64(:,:,388))
  Gcoeff(:)%j = (c(19)*(-M(19,:)%j+M(20,:)%j)+c(16)*(-M(29,:)%j+M(30,:)%j-M(37,:)%j+M(39,:)%j-M(43,:)%j+M(44,:)%j+M(49,:)%j &
    -M(50,:)%j)) * den(10)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(1247),h0tab(:,1247),[36,2,1,24],[0,nMT,0,0],5,1,wf4(:,5))
  call Hloop_GGG_G_12(ntryL,G0H64(1),ex3(:),ex6(:),G0H16(209),m4h2x2x16(:,317),heltab3x64(:,:,389))
  Gcoeff(:)%j = (c(19)*(M(5,:)%j-M(6,:)%j-M(19,:)%j+M(20,:)%j)+c(16)*(-M(45,:)%j+M(47,:)%j+M(49,:)%j-M(50,:)%j)) * den(10)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(1248),h0tab(:,1248),[36,2,1,24],[0,nMT,0,0],5,1,wf4(:,5))
  call Hloop_GGG_G_23(ntryL,G0H64(1),ex6(:),ex3(:),G0H16(210),m4h2x2x16(:,318),heltab3x64(:,:,390))
  Gcoeff(:)%j = (c(19)*(M(10,:)%j-M(16,:)%j)+c(16)*(M(29,:)%j-M(30,:)%j+M(37,:)%j-M(39,:)%j+M(43,:)%j-M(44,:)%j-M(49,:)%j &
    +M(50,:)%j)) * den(10)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(1249),h0tab(:,1249),[36,1,2,24],[0,nMT,0,0],5,1,wf4(:,5))
  call Hloop_GGG_G_12(ntryL,G0H64(1),ex6(:),ex3(:),G0H16(211),m4h2x2x16(:,319),heltab3x64(:,:,391))
  Gcoeff(:)%j = (c(19)*(M(9,:)%j-M(15,:)%j)+c(16)*(M(29,:)%j-M(30,:)%j+M(37,:)%j-M(39,:)%j+M(43,:)%j-M(44,:)%j-M(45,:)%j &
    +M(47,:)%j)) * den(10)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(1250),h0tab(:,1250),[36,1,2,24],[0,nMT,0,0],5,1,wf4(:,5))
  call Hloop_GGG_G_12(ntryL,G0H64(1),ex3(:),ex6(:),G0H16(212),m4h2x2x16(:,320),heltab3x64(:,:,392))
  Gcoeff(:)%j = (c(19)*(M(9,:)%j-M(10,:)%j-M(15,:)%j+M(16,:)%j)+c(16)*(-M(45,:)%j+M(47,:)%j+M(49,:)%j-M(50,:)%j)) * den(10)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(1251),h0tab(:,1251),[36,1,2,24],[0,nMT,0,0],5,1,wf4(:,5))
  call Hloop_GGG_G_23(ntryL,G0H64(1),ex6(:),ex3(:),G0H16(213),m4h2x2x16(:,321),heltab3x64(:,:,393))
  Gcoeff(:)%j = (c(6)*(M(37,:)%j-M(39,:)%j+M(43,:)%j-M(44,:)%j-M(49,:)%j+M(50,:)%j)) * den(10)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(1252),h0tab(:,1252),[36,1,24,2],[0,nMT,nMT,0],5,1,wf4(:,5))
  call Hloop_GGG_G_12(ntryL,G0H64(1),ex6(:),ex3(:),G0H16(214),m4h2x2x16(:,322),heltab3x64(:,:,394))
  Gcoeff(:)%j = (c(6)*(M(37,:)%j-M(39,:)%j+M(43,:)%j-M(44,:)%j-M(45,:)%j+M(47,:)%j)) * den(10)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(1253),h0tab(:,1253),[36,1,24,2],[0,nMT,nMT,0],5,1,wf4(:,5))
  call Hloop_GGG_G_12(ntryL,G0H64(1),ex3(:),ex6(:),G0H16(215),m4h2x2x16(:,323),heltab3x64(:,:,395))
  Gcoeff(:)%j = (c(6)*(-M(45,:)%j+M(47,:)%j+M(49,:)%j-M(50,:)%j)) * den(10)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(1254),h0tab(:,1254),[36,1,24,2],[0,nMT,nMT,0],5,1,wf4(:,5))
  call Hloop_GGG_G_23(ntryL,G0H64(1),ex6(:),ex3(:),G0H16(216),m4h2x2x16(:,324),heltab3x64(:,:,396))
  Gcoeff(:)%j = (c(19)*(-M(11,:)%j+M(21,:)%j)+c(16)*(-M(27,:)%j+M(28,:)%j-M(38,:)%j+M(41,:)%j+M(43,:)%j-M(44,:)%j+M(46,:)%j &
    -M(49,:)%j)) * den(12)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(1255),h0tab(:,1255),[44,2,1,16],[0,nMT,0,0],5,1,wf4(:,6))
  call Hloop_GGG_G_12(ntryL,G0H64(1),ex3(:),wf4(:,6),G0H8(73),m4h2x4x8(:,49),heltab3x64(:,:,397))
  Gcoeff(:)%j = (c(19)*(-M(2,:)%j+M(5,:)%j)+c(16)*(-M(27,:)%j+M(28,:)%j-M(38,:)%j+M(41,:)%j+M(43,:)%j-M(44,:)%j+M(47,:)%j &
    -M(48,:)%j)) * den(12)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(1256),h0tab(:,1256),[44,2,1,16],[0,nMT,0,0],5,1,wf4(:,6))
  call Hloop_GGG_G_12(ntryL,G0H64(1),wf4(:,6),ex3(:),G0H8(74),m4h4x2x8(:,25),heltab3x64(:,:,398))
  Gcoeff(:)%j = (c(19)*(-M(2,:)%j+M(5,:)%j+M(11,:)%j-M(21,:)%j)+c(16)*(-M(46,:)%j+M(47,:)%j-M(48,:)%j+M(49,:)%j)) * den(12)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(1257),h0tab(:,1257),[44,2,1,16],[0,nMT,0,0],5,1,wf4(:,6))
  call Hloop_GGG_G_23(ntryL,G0H64(1),ex3(:),wf4(:,6),G0H8(75),m4h2x4x8(:,50),heltab3x64(:,:,399))
  Gcoeff(:)%j = (c(19)*(M(13,:)%j-M(14,:)%j)+c(16)*(M(27,:)%j-M(28,:)%j+M(38,:)%j-M(41,:)%j-M(43,:)%j+M(44,:)%j-M(47,:)%j &
    +M(48,:)%j)) * den(12)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(1258),h0tab(:,1258),[44,1,2,16],[0,nMT,0,0],5,1,wf4(:,6))
  call Hloop_GGG_G_12(ntryL,G0H64(1),ex3(:),wf4(:,6),G0H8(76),m4h2x4x8(:,51),heltab3x64(:,:,400))
  Gcoeff(:)%j = (c(19)*(M(16,:)%j-M(18,:)%j)+c(16)*(M(27,:)%j-M(28,:)%j+M(38,:)%j-M(41,:)%j-M(43,:)%j+M(44,:)%j-M(46,:)%j &
    +M(49,:)%j)) * den(12)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(1259),h0tab(:,1259),[44,1,2,16],[0,nMT,0,0],5,1,wf4(:,6))
  call Hloop_GGG_G_12(ntryL,G0H64(1),wf4(:,6),ex3(:),G0H8(77),m4h4x2x8(:,26),heltab3x64(:,:,401))
  Gcoeff(:)%j = (c(19)*(-M(13,:)%j+M(14,:)%j+M(16,:)%j-M(18,:)%j)+c(16)*(-M(46,:)%j+M(47,:)%j-M(48,:)%j+M(49,:)%j)) * den(12)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(1260),h0tab(:,1260),[44,1,2,16],[0,nMT,0,0],5,1,wf4(:,6))
  call Hloop_GGG_G_23(ntryL,G0H64(1),ex3(:),wf4(:,6),G0H8(78),m4h2x4x8(:,52),heltab3x64(:,:,402))
  Gcoeff(:)%j = (c(6)*(M(27,:)%j-M(28,:)%j-M(43,:)%j+M(44,:)%j-M(47,:)%j+M(48,:)%j)) * den(12)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(1261),h0tab(:,1261),[44,1,16,2],[0,nMT,nMT,0],5,1,wf4(:,6))
  call Hloop_GGG_G_12(ntryL,G0H64(1),ex3(:),wf4(:,6),G0H8(79),m4h2x4x8(:,53),heltab3x64(:,:,403))
  Gcoeff(:)%j = (c(6)*(M(27,:)%j-M(28,:)%j-M(43,:)%j+M(44,:)%j-M(46,:)%j+M(49,:)%j)) * den(12)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(1262),h0tab(:,1262),[44,1,16,2],[0,nMT,nMT,0],5,1,wf4(:,6))
  call Hloop_GGG_G_12(ntryL,G0H64(1),wf4(:,6),ex3(:),G0H8(80),m4h4x2x8(:,27),heltab3x64(:,:,404))
  Gcoeff(:)%j = (c(6)*(-M(46,:)%j+M(47,:)%j-M(48,:)%j+M(49,:)%j)) * den(12)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(1263),h0tab(:,1263),[44,1,16,2],[0,nMT,nMT,0],5,1,wf4(:,6))
  call Hloop_GGG_G_23(ntryL,G0H64(1),ex3(:),wf4(:,6),G0H8(81),m4h2x4x8(:,54),heltab3x64(:,:,405))
  Gcoeff(:)%j = (c(19)*(-M(17,:)%j+M(23,:)%j)+c(16)*(-M(25,:)%j+M(26,:)%j-M(40,:)%j+M(42,:)%j-M(43,:)%j+M(44,:)%j+M(48,:)%j &
    -M(50,:)%j)) * den(16)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(1264),h0tab(:,1264),[52,2,1,8],[0,nMT,0,0],5,1,wf4(:,7))
  call Hloop_GGG_G_12(ntryL,G0H64(1),ex3(:),wf4(:,7),G0H8(82),m4h2x4x8(:,55),heltab3x64(:,:,406))
  Gcoeff(:)%j = (c(19)*(-M(4,:)%j+M(6,:)%j)+c(16)*(-M(25,:)%j+M(26,:)%j-M(40,:)%j+M(42,:)%j-M(43,:)%j+M(44,:)%j+M(45,:)%j &
    -M(46,:)%j)) * den(16)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(1265),h0tab(:,1265),[52,2,1,8],[0,nMT,0,0],5,1,wf4(:,7))
  call Hloop_GGG_G_12(ntryL,G0H64(1),wf4(:,7),ex3(:),G0H8(83),m4h4x2x8(:,28),heltab3x64(:,:,407))
  Gcoeff(:)%j = (c(19)*(-M(4,:)%j+M(6,:)%j+M(17,:)%j-M(23,:)%j)+c(16)*(M(45,:)%j-M(46,:)%j-M(48,:)%j+M(50,:)%j)) * den(16)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(1266),h0tab(:,1266),[52,2,1,8],[0,nMT,0,0],5,1,wf4(:,7))
  call Hloop_GGG_G_23(ntryL,G0H64(1),ex3(:),wf4(:,7),G0H8(84),m4h2x4x8(:,56),heltab3x64(:,:,408))
  Gcoeff(:)%j = (c(19)*(M(7,:)%j-M(8,:)%j)+c(16)*(M(25,:)%j-M(26,:)%j+M(40,:)%j-M(42,:)%j+M(43,:)%j-M(44,:)%j-M(45,:)%j &
    +M(46,:)%j)) * den(16)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(1267),h0tab(:,1267),[52,1,2,8],[0,nMT,0,0],5,1,wf4(:,7))
  call Hloop_GGG_G_12(ntryL,G0H64(1),ex3(:),wf4(:,7),G0H8(85),m4h2x4x8(:,57),heltab3x64(:,:,409))
  Gcoeff(:)%j = (c(19)*(M(10,:)%j-M(12,:)%j)+c(16)*(M(25,:)%j-M(26,:)%j+M(40,:)%j-M(42,:)%j+M(43,:)%j-M(44,:)%j-M(48,:)%j &
    +M(50,:)%j)) * den(16)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(1268),h0tab(:,1268),[52,1,2,8],[0,nMT,0,0],5,1,wf4(:,7))
  call Hloop_GGG_G_12(ntryL,G0H64(1),wf4(:,7),ex3(:),G0H8(86),m4h4x2x8(:,29),heltab3x64(:,:,410))
  Gcoeff(:)%j = (c(19)*(-M(7,:)%j+M(8,:)%j+M(10,:)%j-M(12,:)%j)+c(16)*(M(45,:)%j-M(46,:)%j-M(48,:)%j+M(50,:)%j)) * den(16)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(1269),h0tab(:,1269),[52,1,2,8],[0,nMT,0,0],5,1,wf4(:,7))
  call Hloop_GGG_G_23(ntryL,G0H64(1),ex3(:),wf4(:,7),G0H8(87),m4h2x4x8(:,58),heltab3x64(:,:,411))
  Gcoeff(:)%j = (c(6)*(M(25,:)%j-M(26,:)%j+M(43,:)%j-M(44,:)%j-M(45,:)%j+M(46,:)%j)) * den(16)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(1270),h0tab(:,1270),[52,1,8,2],[0,nMT,nMT,0],5,1,wf4(:,7))
  call Hloop_GGG_G_12(ntryL,G0H64(1),ex3(:),wf4(:,7),G0H8(88),m4h2x4x8(:,59),heltab3x64(:,:,412))
  Gcoeff(:)%j = (c(6)*(M(25,:)%j-M(26,:)%j+M(43,:)%j-M(44,:)%j-M(48,:)%j+M(50,:)%j)) * den(16)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(1271),h0tab(:,1271),[52,1,8,2],[0,nMT,nMT,0],5,1,wf4(:,7))
  call Hloop_GGG_G_12(ntryL,G0H64(1),wf4(:,7),ex3(:),G0H8(89),m4h4x2x8(:,30),heltab3x64(:,:,413))
  Gcoeff(:)%j = (c(6)*(M(45,:)%j-M(46,:)%j-M(48,:)%j+M(50,:)%j)) * den(16)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(1272),h0tab(:,1272),[52,1,8,2],[0,nMT,nMT,0],5,1,wf4(:,7))
  call Hloop_GGG_G_23(ntryL,G0H64(1),ex3(:),wf4(:,7),G0H8(90),m4h2x4x8(:,60),heltab3x64(:,:,414))
  Gcoeff(:)%j = (-(c(9)*M(9,:)%j)+c(6)*(-M(25,:)%j-M(27,:)%j-M(31,:)%j+M(39,:)%j)) * den(34)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(1273),h0tab(:,1273),[33,2,8,20],[nMT,0,0,0],5,1,wf4(:,21))
  call Hloop_VQ_A(ntryL,G0H64(1),wf4(:,21),G0H16(217),m3h4x16(:,148),heltab2x64(:,:,859))
  call Hloop_Q_A(ntryL,G0H16(217),33,nMT,G1H16(210),n2h16(540))
  Gcoeff(:)%j = (-(c(9)*M(7,:)%j)+c(6)*(-M(25,:)%j-M(27,:)%j-M(31,:)%j+M(37,:)%j)) * den(34)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(1274),h0tab(:,1274),[33,2,8,20],[nMT,0,0,0],5,1,wf4(:,21))
  call Hloop_VQ_A(ntryL,G0H64(1),wf4(:,21),G0H16(217),m3h4x16(:,149),heltab2x64(:,:,860))
  call Hloop_Q_A(ntryL,G0H16(217),33,nMT,G1H16(211),n2h16(541))
  Gcoeff(:)%j = (c(9)*(-M(7,:)%j+M(9,:)%j)+c(6)*(M(37,:)%j-M(39,:)%j)) * den(34)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(1275),h0tab(:,1275),[33,2,8,20],[nMT,0,0,0],5,1,wf4(:,21))
  call Hloop_VQ_A(ntryL,G0H64(1),wf4(:,21),G0H16(217),m3h4x16(:,150),heltab2x64(:,:,861))
  call Hloop_Q_A(ntryL,G0H16(217),33,nMT,G1H16(212),n2h16(542))
  Gcoeff(:)%j = (c(16)*(-M(25,:)%j-M(31,:)%j+M(39,:)%j)) * den(34)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(1276),h0tab(:,1276),[33,8,2,20],[nMT,nMT,0,0],5,1,wf4(:,21))
  call Hloop_VQ_A(ntryL,G0H64(1),wf4(:,21),G0H16(217),m3h4x16(:,151),heltab2x64(:,:,862))
  call Hloop_Q_A(ntryL,G0H16(217),33,nMT,G1H16(213),n2h16(543))
  Gcoeff(:)%j = (c(16)*(-M(25,:)%j-M(31,:)%j+M(37,:)%j)) * den(34)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(1277),h0tab(:,1277),[33,8,2,20],[nMT,nMT,0,0],5,1,wf4(:,21))
  call Hloop_VQ_A(ntryL,G0H64(1),wf4(:,21),G0H16(217),m3h4x16(:,152),heltab2x64(:,:,863))
  call Hloop_Q_A(ntryL,G0H16(217),33,nMT,G1H16(214),n2h16(544))
  Gcoeff(:)%j = (c(16)*(M(37,:)%j-M(39,:)%j)) * den(34)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(1278),h0tab(:,1278),[33,8,2,20],[nMT,nMT,0,0],5,1,wf4(:,21))
  call Hloop_VQ_A(ntryL,G0H64(1),wf4(:,21),G0H16(217),m3h4x16(:,153),heltab2x64(:,:,864))
  call Hloop_Q_A(ntryL,G0H16(217),33,nMT,G1H16(217),n2h16(545))
  Gcoeff(:)%j = (-(c(9)*M(13,:)%j)+c(6)*(-M(25,:)%j-M(27,:)%j-M(31,:)%j+M(39,:)%j)) * den(34)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(1279),h0tab(:,1279),[33,2,20,8],[nMT,0,0,0],5,1,wf4(:,21))
  call Hloop_VQ_A(ntryL,G0H64(1),wf4(:,21),G0H16(217),m3h4x16(:,154),heltab2x64(:,:,865))
  call Hloop_Q_A(ntryL,G0H16(217),33,nMT,G1H16(218),n2h16(546))
  Gcoeff(:)%j = (-(c(9)*M(3,:)%j)+c(6)*(-M(25,:)%j-M(27,:)%j-M(31,:)%j+M(37,:)%j)) * den(34)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(1280),h0tab(:,1280),[33,2,20,8],[nMT,0,0,0],5,1,wf4(:,21))
  call Hloop_VQ_A(ntryL,G0H64(1),wf4(:,21),G0H16(217),m3h4x16(:,155),heltab2x64(:,:,866))
  call Hloop_Q_A(ntryL,G0H16(217),33,nMT,G1H16(23),n2h16(547))
  Gcoeff(:)%j = (c(9)*(-M(3,:)%j+M(13,:)%j)+c(6)*(M(37,:)%j-M(39,:)%j)) * den(34)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(1281),h0tab(:,1281),[33,2,20,8],[nMT,0,0,0],5,1,wf4(:,21))
  call Hloop_VQ_A(ntryL,G0H64(1),wf4(:,21),G0H16(217),m3h4x16(:,156),heltab2x64(:,:,867))
  call Hloop_Q_A(ntryL,G0H16(217),33,nMT,G1H16(219),n2h16(548))
  Gcoeff(:)%j = (c(9)*M(20,:)%j+c(6)*(M(26,:)%j+M(28,:)%j+M(32,:)%j-M(37,:)%j)) * den(36)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(1282),h0tab(:,1282),[34,1,8,20],[nMT,0,0,0],5,1,wf4(:,23))
  call Hloop_VA_Q(ntryL,G0H64(1),wf4(:,23),G0H16(217),m3h4x16(:,157),heltab2x64(:,:,868))
  call Hloop_A_Q(ntryL,G0H16(217),34,nMT,G1H16(221),n2h16(549))
  Gcoeff(:)%j = (c(9)*M(23,:)%j+c(6)*(M(26,:)%j+M(28,:)%j+M(32,:)%j-M(39,:)%j)) * den(36)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(1283),h0tab(:,1283),[34,1,8,20],[nMT,0,0,0],5,1,wf4(:,23))
  call Hloop_VA_Q(ntryL,G0H64(1),wf4(:,23),G0H16(217),m3h4x16(:,158),heltab2x64(:,:,869))
  call Hloop_A_Q(ntryL,G0H16(217),34,nMT,G1H16(223),n2h16(550))
  Gcoeff(:)%j = (c(9)*(-M(20,:)%j+M(23,:)%j)+c(6)*(M(37,:)%j-M(39,:)%j)) * den(36)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(1284),h0tab(:,1284),[34,1,8,20],[nMT,0,0,0],5,1,wf4(:,23))
  call Hloop_VA_Q(ntryL,G0H64(1),wf4(:,23),G0H16(217),m3h4x16(:,159),heltab2x64(:,:,870))
  call Hloop_A_Q(ntryL,G0H16(217),34,nMT,G1H16(227),n2h16(551))
  Gcoeff(:)%j = (c(16)*(-M(26,:)%j-M(32,:)%j+M(37,:)%j)) * den(36)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(1285),h0tab(:,1285),[34,8,1,20],[nMT,nMT,0,0],5,1,wf4(:,23))
  call Hloop_VA_Q(ntryL,G0H64(1),wf4(:,23),G0H16(217),m3h4x16(:,160),heltab2x64(:,:,871))
  call Hloop_A_Q(ntryL,G0H16(217),34,nMT,G1H16(228),n2h16(552))
  Gcoeff(:)%j = (c(16)*(-M(26,:)%j-M(32,:)%j+M(39,:)%j)) * den(36)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(1286),h0tab(:,1286),[34,8,1,20],[nMT,nMT,0,0],5,1,wf4(:,23))
  call Hloop_VA_Q(ntryL,G0H64(1),wf4(:,23),G0H16(217),m3h4x16(:,161),heltab2x64(:,:,872))
  call Hloop_A_Q(ntryL,G0H16(217),34,nMT,G1H16(25),n2h16(553))
  Gcoeff(:)%j = (c(16)*(-M(37,:)%j+M(39,:)%j)) * den(36)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(1287),h0tab(:,1287),[34,8,1,20],[nMT,nMT,0,0],5,1,wf4(:,23))
  call Hloop_VA_Q(ntryL,G0H64(1),wf4(:,23),G0H16(217),m3h4x16(:,162),heltab2x64(:,:,873))
  call Hloop_A_Q(ntryL,G0H16(217),34,nMT,G1H16(239),n2h16(554))
  Gcoeff(:)%j = (c(9)*M(21,:)%j+c(6)*(M(26,:)%j+M(28,:)%j+M(32,:)%j-M(37,:)%j)) * den(36)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(1288),h0tab(:,1288),[34,1,20,8],[nMT,0,0,0],5,1,wf4(:,23))
  call Hloop_VA_Q(ntryL,G0H64(1),wf4(:,23),G0H16(217),m3h4x16(:,163),heltab2x64(:,:,874))
  call Hloop_A_Q(ntryL,G0H16(217),34,nMT,G1H16(242),n2h16(555))
  Gcoeff(:)%j = (c(9)*M(22,:)%j+c(6)*(M(26,:)%j+M(28,:)%j+M(32,:)%j-M(39,:)%j)) * den(36)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(1289),h0tab(:,1289),[34,1,20,8],[nMT,0,0,0],5,1,wf4(:,23))
  call Hloop_VA_Q(ntryL,G0H64(1),wf4(:,23),G0H16(217),m3h4x16(:,164),heltab2x64(:,:,875))
  call Hloop_A_Q(ntryL,G0H16(217),34,nMT,G1H16(243),n2h16(556))
  Gcoeff(:)%j = (c(9)*(-M(21,:)%j+M(22,:)%j)+c(6)*(M(37,:)%j-M(39,:)%j)) * den(36)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(1290),h0tab(:,1290),[34,1,20,8],[nMT,0,0,0],5,1,wf4(:,23))
  call Hloop_VA_Q(ntryL,G0H64(1),wf4(:,23),G0H16(217),m3h4x16(:,165),heltab2x64(:,:,876))
  call Hloop_A_Q(ntryL,G0H16(217),34,nMT,G1H16(244),n2h16(557))
  Gcoeff(:)%j = (c(19)*(M(13,:)%j-M(14,:)%j)+c(16)*(M(27,:)%j-M(28,:)%j+M(38,:)%j-M(41,:)%j-M(43,:)%j+M(44,:)%j-M(47,:)%j &
    +M(48,:)%j)) * den(12)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(1291),h0tab(:,1291),[40,1,2,20],[0,nMT,0,0],5,1,wf4(:,6))
  call Hloop_UV_W(ntryL,G0H64(1),0,wf4(:,6),40,G1H16(245),m3h4x16(:,166),heltab2x64(:,:,877))
  Gcoeff(:)%j = (c(19)*(M(3,:)%j-M(4,:)%j)+c(16)*(M(27,:)%j-M(28,:)%j+M(38,:)%j-M(41,:)%j-M(43,:)%j+M(44,:)%j-M(46,:)%j &
    +M(49,:)%j)) * den(12)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(1292),h0tab(:,1292),[40,1,2,20],[0,nMT,0,0],5,1,wf4(:,6))
  call Hloop_UV_W(ntryL,G0H64(1),0,wf4(:,6),40,G1H16(246),m3h4x16(:,167),heltab2x64(:,:,878))
  Gcoeff(:)%j = (c(19)*(M(3,:)%j-M(4,:)%j-M(13,:)%j+M(14,:)%j)+c(16)*(-M(46,:)%j+M(47,:)%j-M(48,:)%j+M(49,:)%j)) * den(12)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(1293),h0tab(:,1293),[40,1,2,20],[0,nMT,0,0],5,1,wf4(:,6))
  call Hloop_UV_W(ntryL,G0H64(1),0,wf4(:,6),40,G1H16(249),m3h4x16(:,168),heltab2x64(:,:,879))
  Gcoeff(:)%j = (c(19)*(-M(11,:)%j+M(21,:)%j)+c(16)*(-M(27,:)%j+M(28,:)%j-M(38,:)%j+M(41,:)%j+M(43,:)%j-M(44,:)%j+M(46,:)%j &
    -M(49,:)%j)) * den(12)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(1294),h0tab(:,1294),[40,2,1,20],[0,nMT,0,0],5,1,wf4(:,6))
  call Hloop_UV_W(ntryL,G0H64(1),0,wf4(:,6),40,G1H16(250),m3h4x16(:,169),heltab2x64(:,:,880))
  Gcoeff(:)%j = (c(19)*(-M(12,:)%j+M(22,:)%j)+c(16)*(-M(27,:)%j+M(28,:)%j-M(38,:)%j+M(41,:)%j+M(43,:)%j-M(44,:)%j+M(47,:)%j &
    -M(48,:)%j)) * den(12)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(1295),h0tab(:,1295),[40,2,1,20],[0,nMT,0,0],5,1,wf4(:,6))
  call Hloop_UV_W(ntryL,G0H64(1),0,wf4(:,6),40,G1H16(27),m3h4x16(:,170),heltab2x64(:,:,881))
  Gcoeff(:)%j = (c(19)*(M(11,:)%j-M(12,:)%j-M(21,:)%j+M(22,:)%j)+c(16)*(-M(46,:)%j+M(47,:)%j-M(48,:)%j+M(49,:)%j)) * den(12)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(1296),h0tab(:,1296),[40,2,1,20],[0,nMT,0,0],5,1,wf4(:,6))
  call Hloop_UV_W(ntryL,G0H64(1),0,wf4(:,6),40,G1H16(28),m3h4x16(:,171),heltab2x64(:,:,882))
  Gcoeff(:)%j = (c(6)*(M(38,:)%j-M(41,:)%j-M(43,:)%j+M(44,:)%j-M(46,:)%j+M(49,:)%j)) * den(12)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(1297),h0tab(:,1297),[40,1,20,2],[nMT,0,0,nMT],5,1,wf4(:,6))
  call Hloop_AV_Q(ntryL,G0H64(1),wf4(:,6),G0H16(217),m3h4x16(:,172),heltab2x64(:,:,883))
  call Hloop_A_Q(ntryL,G0H16(217),40,nMT,G1H16(252),n2h16(558))
  Gcoeff(:)%j = (c(6)*(M(38,:)%j-M(41,:)%j-M(43,:)%j+M(44,:)%j-M(47,:)%j+M(48,:)%j)) * den(12)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(1298),h0tab(:,1298),[40,1,20,2],[nMT,0,0,nMT],5,1,wf4(:,6))
  call Hloop_AV_Q(ntryL,G0H64(1),wf4(:,6),G0H16(217),m3h4x16(:,173),heltab2x64(:,:,884))
  call Hloop_A_Q(ntryL,G0H16(217),40,nMT,G1H16(254),n2h16(559))
  Gcoeff(:)%j = (c(6)*(M(46,:)%j-M(47,:)%j+M(48,:)%j-M(49,:)%j)) * den(12)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(1299),h0tab(:,1299),[40,1,20,2],[nMT,0,0,nMT],5,1,wf4(:,6))
  call Hloop_AV_Q(ntryL,G0H64(1),wf4(:,6),G0H16(217),m3h4x16(:,174),heltab2x64(:,:,885))
  call Hloop_A_Q(ntryL,G0H16(217),40,nMT,G1H16(29),n2h16(560))
  Gcoeff(:)%j = (c(15)*(-M(4,:)%j+M(14,:)%j+M(20,:)%j-M(23,:)%j)+c(16)*(M(46,:)%j-M(47,:)%j+M(48,:)%j-M(49,:)%j)) * den(14)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(1300),h0tab(:,1300),[52,2,1,8],[nMT,0,nMT,nMT],4,1,wf8(:,5))
  call Hloop_QV_A(ntryL,G0H64(1),wf8(:,5),G0H8(91),m3h8x8(:,19),heltab2x64(:,:,886))
  call Hloop_Q_A(ntryL,G0H8(91),52,nMT,G1H8(728),n2h8(1323))
  Gcoeff(:)%j = (c(15)*(M(4,:)%j-M(6,:)%j-M(17,:)%j+M(23,:)%j)+c(16)*(M(45,:)%j-M(46,:)%j-M(48,:)%j+M(50,:)%j)) * den(14)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(1301),h0tab(:,1301),[52,2,1,8],[nMT,0,nMT,nMT],4,1,wf8(:,7))
  call Hloop_QV_A(ntryL,G0H64(1),wf8(:,7),G0H8(91),m3h8x8(:,20),heltab2x64(:,:,887))
  call Hloop_Q_A(ntryL,G0H8(91),52,nMT,G1H8(733),n2h8(1324))
  Gcoeff(:)%j = (c(15)*(M(6,:)%j-M(14,:)%j+M(17,:)%j-M(20,:)%j)+c(16)*(-M(45,:)%j+M(47,:)%j+M(49,:)%j-M(50,:)%j)) * den(14)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(1302),h0tab(:,1302),[52,2,1,8],[nMT,0,nMT,nMT],4,1,wf8(:,8))
  call Hloop_QV_A(ntryL,G0H64(1),wf8(:,8),G0H8(91),m3h8x8(:,21),heltab2x64(:,:,888))
  call Hloop_Q_A(ntryL,G0H8(91),52,nMT,G1H8(763),n2h8(1325))
  Gcoeff(:)%j = (c(19)*(M(4,:)%j-M(14,:)%j-M(20,:)%j+M(23,:)%j)+c(16)*(M(46,:)%j-M(47,:)%j+M(48,:)%j-M(49,:)%j)) * den(14)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(1303),h0tab(:,1303),[52,2,1,8],[0,nMT,0,0],4,1,wf8(:,5))
  call Hloop_UV_W(ntryL,G0H64(1),0,wf8(:,5),52,G1H8(764),m3h8x8(:,22),heltab2x64(:,:,889))
  Gcoeff(:)%j = (c(19)*(-M(4,:)%j+M(6,:)%j+M(17,:)%j-M(23,:)%j)+c(16)*(M(45,:)%j-M(46,:)%j-M(48,:)%j+M(50,:)%j)) * den(14)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(1304),h0tab(:,1304),[52,2,1,8],[0,nMT,0,0],4,1,wf8(:,7))
  call Hloop_UV_W(ntryL,G0H64(1),0,wf8(:,7),52,G1H8(798),m3h8x8(:,23),heltab2x64(:,:,890))
  Gcoeff(:)%j = (c(19)*(-M(6,:)%j+M(14,:)%j-M(17,:)%j+M(20,:)%j)+c(16)*(-M(45,:)%j+M(47,:)%j+M(49,:)%j-M(50,:)%j)) * den(14)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(1305),h0tab(:,1305),[52,2,1,8],[0,nMT,0,0],4,1,wf8(:,8))
  call Hloop_UV_W(ntryL,G0H64(1),0,wf8(:,8),52,G1H8(799),m3h8x8(:,24),heltab2x64(:,:,891))
  Gcoeff(:)%j = (c(15)*(-M(7,:)%j+M(9,:)%j+M(11,:)%j-M(12,:)%j)+c(16)*(M(46,:)%j-M(47,:)%j+M(48,:)%j-M(49,:)%j)) * den(14)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(1306),h0tab(:,1306),[52,1,2,8],[nMT,0,nMT,nMT],4,1,wf8(:,5))
  call Hloop_AV_Q(ntryL,G0H64(1),wf8(:,5),G0H8(91),m3h8x8(:,25),heltab2x64(:,:,892))
  call Hloop_A_Q(ntryL,G0H8(91),52,nMT,G1H8(833),n2h8(1326))
  Gcoeff(:)%j = (c(15)*(M(7,:)%j-M(8,:)%j-M(10,:)%j+M(12,:)%j)+c(16)*(M(45,:)%j-M(46,:)%j-M(48,:)%j+M(50,:)%j)) * den(14)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(1307),h0tab(:,1307),[52,1,2,8],[nMT,0,nMT,nMT],4,1,wf8(:,7))
  call Hloop_AV_Q(ntryL,G0H64(1),wf8(:,7),G0H8(91),m3h8x8(:,26),heltab2x64(:,:,893))
  call Hloop_A_Q(ntryL,G0H8(91),52,nMT,G1H8(834),n2h8(1327))
  Gcoeff(:)%j = (c(15)*(M(8,:)%j-M(9,:)%j+M(10,:)%j-M(11,:)%j)+c(16)*(-M(45,:)%j+M(47,:)%j+M(49,:)%j-M(50,:)%j)) * den(14)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(1308),h0tab(:,1308),[52,1,2,8],[nMT,0,nMT,nMT],4,1,wf8(:,8))
  call Hloop_AV_Q(ntryL,G0H64(1),wf8(:,8),G0H8(91),m3h8x8(:,27),heltab2x64(:,:,894))
  call Hloop_A_Q(ntryL,G0H8(91),52,nMT,G1H8(866),n2h8(1328))
  Gcoeff(:)%j = (c(19)*(M(7,:)%j-M(9,:)%j-M(11,:)%j+M(12,:)%j)+c(16)*(M(46,:)%j-M(47,:)%j+M(48,:)%j-M(49,:)%j)) * den(14)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(1309),h0tab(:,1309),[52,1,2,8],[0,nMT,0,0],4,1,wf8(:,5))
  call Hloop_UV_W(ntryL,G0H64(1),0,wf8(:,5),52,G1H8(870),m3h8x8(:,28),heltab2x64(:,:,895))
  Gcoeff(:)%j = (c(19)*(-M(7,:)%j+M(8,:)%j+M(10,:)%j-M(12,:)%j)+c(16)*(M(45,:)%j-M(46,:)%j-M(48,:)%j+M(50,:)%j)) * den(14)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(1310),h0tab(:,1310),[52,1,2,8],[0,nMT,0,0],4,1,wf8(:,7))
  call Hloop_UV_W(ntryL,G0H64(1),0,wf8(:,7),52,G1H8(906),m3h8x8(:,29),heltab2x64(:,:,896))
  Gcoeff(:)%j = (c(19)*(-M(8,:)%j+M(9,:)%j-M(10,:)%j+M(11,:)%j)+c(16)*(-M(45,:)%j+M(47,:)%j+M(49,:)%j-M(50,:)%j)) * den(14)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(1311),h0tab(:,1311),[52,1,2,8],[0,nMT,0,0],4,1,wf8(:,8))
  call Hloop_UV_W(ntryL,G0H64(1),0,wf8(:,8),52,G1H8(907),m3h8x8(:,30),heltab2x64(:,:,897))
  Gcoeff(:)%j = (c(6)*(M(46,:)%j-M(47,:)%j+M(48,:)%j-M(49,:)%j)) * den(14)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(1312),h0tab(:,1312),[52,1,8,2],[0,nMT,nMT,0],4,1,wf8(:,5))
  call Hloop_UV_W(ntryL,G0H64(1),0,wf8(:,5),52,G1H8(943),m3h8x8(:,31),heltab2x64(:,:,898))
  Gcoeff(:)%j = (c(6)*(M(45,:)%j-M(46,:)%j-M(48,:)%j+M(50,:)%j)) * den(14)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(1313),h0tab(:,1313),[52,1,8,2],[0,nMT,nMT,0],4,1,wf8(:,7))
  call Hloop_UV_W(ntryL,G0H64(1),0,wf8(:,7),52,G1H8(944),m3h8x8(:,32),heltab2x64(:,:,899))
  Gcoeff(:)%j = (c(6)*(-M(45,:)%j+M(47,:)%j+M(49,:)%j-M(50,:)%j)) * den(14)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(1314),h0tab(:,1314),[52,1,8,2],[0,nMT,nMT,0],4,1,wf8(:,8))
  call Hloop_UV_W(ntryL,G0H64(1),0,wf8(:,8),52,G1H8(959),m3h8x8(:,33),heltab2x64(:,:,900))
  Gcoeff(:)%j = (c(6)*(-M(46,:)%j+M(47,:)%j-M(48,:)%j+M(49,:)%j)) * den(14)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(1315),h0tab(:,1315),[52,1,8,2],[nMT,0,0,nMT],4,1,wf8(:,5))
  call Hloop_AV_Q(ntryL,G0H64(1),wf8(:,5),G0H8(91),m3h8x8(:,34),heltab2x64(:,:,901))
  call Hloop_A_Q(ntryL,G0H8(91),52,nMT,G1H8(960),n2h8(1329))
  Gcoeff(:)%j = (c(6)*(-M(45,:)%j+M(46,:)%j+M(48,:)%j-M(50,:)%j)) * den(14)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(1316),h0tab(:,1316),[52,1,8,2],[nMT,0,0,nMT],4,1,wf8(:,7))
  call Hloop_AV_Q(ntryL,G0H64(1),wf8(:,7),G0H8(91),m3h8x8(:,35),heltab2x64(:,:,902))
  call Hloop_A_Q(ntryL,G0H8(91),52,nMT,G1H8(975),n2h8(1330))
  Gcoeff(:)%j = (c(6)*(M(45,:)%j-M(47,:)%j-M(49,:)%j+M(50,:)%j)) * den(14)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(1317),h0tab(:,1317),[52,1,8,2],[nMT,0,0,nMT],4,1,wf8(:,8))
  call Hloop_AV_Q(ntryL,G0H64(1),wf8(:,8),G0H8(91),m3h8x8(:,36),heltab2x64(:,:,903))
  call Hloop_A_Q(ntryL,G0H8(91),52,nMT,G1H8(976),n2h8(1331))
  Gcoeff(:)%j = (c(9)*M(19,:)%j+c(6)*(M(26,:)%j+M(29,:)%j+M(33,:)%j-M(41,:)%j)) * den(30)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(1318),h0tab(:,1318),[32,2,17,12],[0,nMT,0,0],5,1,wf4(:,17))
  call Hloop_UV_W(ntryL,G0H64(1),0,ex6(:),32,G1H32(94),m3h2x32(:,694),heltab2x64(:,:,904))
  Gcoeff(:)%j = (c(9)*M(21,:)%j+c(6)*(M(26,:)%j+M(29,:)%j+M(33,:)%j-M(38,:)%j)) * den(30)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(1319),h0tab(:,1319),[32,2,17,12],[0,nMT,0,0],5,1,wf4(:,17))
  call Hloop_UV_W(ntryL,G0H64(1),0,ex6(:),32,G1H32(95),m3h2x32(:,695),heltab2x64(:,:,905))
  Gcoeff(:)%j = (c(9)*(-M(19,:)%j+M(21,:)%j)+c(6)*(-M(38,:)%j+M(41,:)%j)) * den(30)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(1320),h0tab(:,1320),[32,2,17,12],[0,nMT,0,0],5,1,wf4(:,17))
  call Hloop_UV_W(ntryL,G0H64(1),0,ex6(:),32,G1H32(96),m3h2x32(:,696),heltab2x64(:,:,906))
  Gcoeff(:)%j = (c(16)*(-M(29,:)%j-M(33,:)%j+M(38,:)%j)) * den(30)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(1321),h0tab(:,1321),[32,2,12,17],[nMT,0,0,nMT],5,1,wf4(:,17))
  call Hloop_QV_A(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,697),heltab2x64(:,:,907))
  call Hloop_Q_A(ntryL,G0H32(1),32,nMT,G1H32(97),n2h32(322))
  Gcoeff(:)%j = (c(16)*(-M(29,:)%j-M(33,:)%j+M(41,:)%j)) * den(30)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(1322),h0tab(:,1322),[32,2,12,17],[nMT,0,0,nMT],5,1,wf4(:,17))
  call Hloop_QV_A(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,698),heltab2x64(:,:,908))
  call Hloop_Q_A(ntryL,G0H32(1),32,nMT,G1H32(98),n2h32(323))
  Gcoeff(:)%j = (c(16)*(-M(38,:)%j+M(41,:)%j)) * den(30)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(1323),h0tab(:,1323),[32,2,12,17],[nMT,0,0,nMT],5,1,wf4(:,17))
  call Hloop_QV_A(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,699),heltab2x64(:,:,909))
  call Hloop_Q_A(ntryL,G0H32(1),32,nMT,G1H32(99),n2h32(324))
  Gcoeff(:)%j = (c(9)*M(2,:)%j+c(6)*(M(26,:)%j+M(29,:)%j+M(33,:)%j-M(41,:)%j)) * den(30)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(1324),h0tab(:,1324),[32,12,2,17],[0,0,nMT,0],5,1,wf4(:,17))
  call Hloop_UV_W(ntryL,G0H64(1),0,ex6(:),32,G1H32(100),m3h2x32(:,700),heltab2x64(:,:,910))
  Gcoeff(:)%j = (c(9)*M(8,:)%j+c(6)*(M(26,:)%j+M(29,:)%j+M(33,:)%j-M(38,:)%j)) * den(30)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(1325),h0tab(:,1325),[32,12,2,17],[0,0,nMT,0],5,1,wf4(:,17))
  call Hloop_UV_W(ntryL,G0H64(1),0,ex6(:),32,G1H32(101),m3h2x32(:,701),heltab2x64(:,:,911))
  Gcoeff(:)%j = (c(9)*(-M(2,:)%j+M(8,:)%j)+c(6)*(-M(38,:)%j+M(41,:)%j)) * den(30)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(1326),h0tab(:,1326),[32,12,2,17],[0,0,nMT,0],5,1,wf4(:,17))
  call Hloop_UV_W(ntryL,G0H64(1),0,ex6(:),32,G1H32(102),m3h2x32(:,702),heltab2x64(:,:,912))
  Gcoeff(:)%j = (-(c(9)*M(15,:)%j)+c(6)*(-M(25,:)%j-M(30,:)%j-M(34,:)%j+M(38,:)%j)) * den(32)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(1327),h0tab(:,1327),[32,1,18,12],[0,nMT,0,0],5,1,wf4(:,19))
  call Hloop_UV_W(ntryL,G0H64(1),0,ex6(:),32,G1H32(103),m3h2x32(:,703),heltab2x64(:,:,913))
  Gcoeff(:)%j = (-(c(9)*M(13,:)%j)+c(6)*(-M(25,:)%j-M(30,:)%j-M(34,:)%j+M(41,:)%j)) * den(32)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(1328),h0tab(:,1328),[32,1,18,12],[0,nMT,0,0],5,1,wf4(:,19))
  call Hloop_UV_W(ntryL,G0H64(1),0,ex6(:),32,G1H32(104),m3h2x32(:,704),heltab2x64(:,:,914))
  Gcoeff(:)%j = (c(9)*(-M(13,:)%j+M(15,:)%j)+c(6)*(-M(38,:)%j+M(41,:)%j)) * den(32)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(1329),h0tab(:,1329),[32,1,18,12],[0,nMT,0,0],5,1,wf4(:,19))
  call Hloop_UV_W(ntryL,G0H64(1),0,ex6(:),32,G1H32(105),m3h2x32(:,705),heltab2x64(:,:,915))
  Gcoeff(:)%j = (c(16)*(-M(30,:)%j-M(34,:)%j+M(41,:)%j)) * den(32)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(1330),h0tab(:,1330),[32,1,12,18],[nMT,0,0,nMT],5,1,wf4(:,19))
  call Hloop_AV_Q(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,706),heltab2x64(:,:,916))
  call Hloop_A_Q(ntryL,G0H32(1),32,nMT,G1H32(106),n2h32(325))
  Gcoeff(:)%j = (c(16)*(-M(30,:)%j-M(34,:)%j+M(38,:)%j)) * den(32)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(1331),h0tab(:,1331),[32,1,12,18],[nMT,0,0,nMT],5,1,wf4(:,19))
  call Hloop_AV_Q(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,707),heltab2x64(:,:,917))
  call Hloop_A_Q(ntryL,G0H32(1),32,nMT,G1H32(107),n2h32(326))
  Gcoeff(:)%j = (c(16)*(M(38,:)%j-M(41,:)%j)) * den(32)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(1332),h0tab(:,1332),[32,1,12,18],[nMT,0,0,nMT],5,1,wf4(:,19))
  call Hloop_AV_Q(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,708),heltab2x64(:,:,918))
  call Hloop_A_Q(ntryL,G0H32(1),32,nMT,G1H32(108),n2h32(327))
  Gcoeff(:)%j = (-(c(9)*M(18,:)%j)+c(6)*(-M(25,:)%j-M(30,:)%j-M(34,:)%j+M(38,:)%j)) * den(32)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(1333),h0tab(:,1333),[32,12,1,18],[0,0,nMT,0],5,1,wf4(:,19))
  call Hloop_UV_W(ntryL,G0H64(1),0,ex6(:),32,G1H32(113),m3h2x32(:,709),heltab2x64(:,:,919))
  Gcoeff(:)%j = (-(c(9)*M(17,:)%j)+c(6)*(-M(25,:)%j-M(30,:)%j-M(34,:)%j+M(41,:)%j)) * den(32)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(1334),h0tab(:,1334),[32,12,1,18],[0,0,nMT,0],5,1,wf4(:,19))
  call Hloop_UV_W(ntryL,G0H64(1),0,ex6(:),32,G1H32(110),m3h2x32(:,710),heltab2x64(:,:,920))
  Gcoeff(:)%j = (c(9)*(-M(17,:)%j+M(18,:)%j)+c(6)*(-M(38,:)%j+M(41,:)%j)) * den(32)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(1335),h0tab(:,1335),[32,12,1,18],[0,0,nMT,0],5,1,wf4(:,19))
  call Hloop_UV_W(ntryL,G0H64(1),0,ex6(:),32,G1H32(115),m3h2x32(:,711),heltab2x64(:,:,921))
  Gcoeff(:)%j = (-(c(9)*M(15,:)%j)+c(6)*(-M(25,:)%j-M(27,:)%j-M(31,:)%j+M(37,:)%j)) * den(34)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(1336),h0tab(:,1336),[33,2,16,12],[nMT,0,0,0],5,1,wf4(:,21))
  call Hloop_VQ_A(ntryL,G0H64(1),wf4(:,21),G0H16(217),m3h4x16(:,175),heltab2x64(:,:,922))
  call Hloop_Q_A(ntryL,G0H16(217),33,nMT,G1H16(255),n2h16(561))
  Gcoeff(:)%j = (-(c(9)*M(13,:)%j)+c(6)*(-M(25,:)%j-M(27,:)%j-M(31,:)%j+M(39,:)%j)) * den(34)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(1337),h0tab(:,1337),[33,2,16,12],[nMT,0,0,0],5,1,wf4(:,21))
  call Hloop_VQ_A(ntryL,G0H64(1),wf4(:,21),G0H16(217),m3h4x16(:,176),heltab2x64(:,:,923))
  call Hloop_Q_A(ntryL,G0H16(217),33,nMT,G1H16(257),n2h16(562))
  Gcoeff(:)%j = (c(9)*(-M(13,:)%j+M(15,:)%j)+c(6)*(-M(37,:)%j+M(39,:)%j)) * den(34)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(1338),h0tab(:,1338),[33,2,16,12],[nMT,0,0,0],5,1,wf4(:,21))
  call Hloop_VQ_A(ntryL,G0H64(1),wf4(:,21),G0H16(217),m3h4x16(:,177),heltab2x64(:,:,924))
  call Hloop_Q_A(ntryL,G0H16(217),33,nMT,G1H16(258),n2h16(563))
  Gcoeff(:)%j = (c(16)*(-M(27,:)%j-M(31,:)%j+M(39,:)%j)) * den(34)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(1339),h0tab(:,1339),[33,12,2,16],[0,0,nMT,nMT],5,1,wf4(:,21))
  call Hloop_AQ_V(ntryL,G0H64(1),wf4(:,21),G0H16(217),m3h4x16(:,178),heltab2x64(:,:,925))
  Gcoeff(:)%j = (c(16)*(-M(27,:)%j-M(31,:)%j+M(37,:)%j)) * den(34)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(1340),h0tab(:,1340),[33,12,2,16],[0,0,nMT,nMT],5,1,wf4(:,21))
  call Hloop_AQ_V(ntryL,G0H64(1),wf4(:,21),G0H16(218),m3h4x16(:,179),heltab2x64(:,:,926))
  Gcoeff(:)%j = (c(16)*(M(37,:)%j-M(39,:)%j)) * den(34)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(1341),h0tab(:,1341),[33,12,2,16],[0,0,nMT,nMT],5,1,wf4(:,21))
  call Hloop_AQ_V(ntryL,G0H64(1),wf4(:,21),G0H16(219),m3h4x16(:,180),heltab2x64(:,:,927))
  Gcoeff(:)%j = (-(c(9)*M(7,:)%j)+c(6)*(-M(25,:)%j-M(27,:)%j-M(31,:)%j+M(37,:)%j)) * den(34)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(1342),h0tab(:,1342),[33,2,12,16],[nMT,0,0,0],5,1,wf4(:,21))
  call Hloop_VQ_A(ntryL,G0H64(1),wf4(:,21),G0H16(220),m3h4x16(:,181),heltab2x64(:,:,928))
  call Hloop_Q_A(ntryL,G0H16(220),33,nMT,G1H16(30),n2h16(564))
  Gcoeff(:)%j = (-(c(9)*M(1,:)%j)+c(6)*(-M(25,:)%j-M(27,:)%j-M(31,:)%j+M(39,:)%j)) * den(34)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(1343),h0tab(:,1343),[33,2,12,16],[nMT,0,0,0],5,1,wf4(:,21))
  call Hloop_VQ_A(ntryL,G0H64(1),wf4(:,21),G0H16(220),m3h4x16(:,182),heltab2x64(:,:,929))
  call Hloop_Q_A(ntryL,G0H16(220),33,nMT,G1H16(260),n2h16(565))
  Gcoeff(:)%j = (c(9)*(-M(1,:)%j+M(7,:)%j)+c(6)*(-M(37,:)%j+M(39,:)%j)) * den(34)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(1344),h0tab(:,1344),[33,2,12,16],[nMT,0,0,0],5,1,wf4(:,21))
  call Hloop_VQ_A(ntryL,G0H64(1),wf4(:,21),G0H16(220),m3h4x16(:,183),heltab2x64(:,:,930))
  call Hloop_Q_A(ntryL,G0H16(220),33,nMT,G1H16(262),n2h16(566))
  Gcoeff(:)%j = (c(9)*M(19,:)%j+c(6)*(M(26,:)%j+M(28,:)%j+M(32,:)%j-M(39,:)%j)) * den(36)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(1345),h0tab(:,1345),[34,1,16,12],[nMT,0,0,0],5,1,wf4(:,23))
  call Hloop_VA_Q(ntryL,G0H64(1),wf4(:,23),G0H16(220),m3h4x16(:,184),heltab2x64(:,:,931))
  call Hloop_A_Q(ntryL,G0H16(220),34,nMT,G1H16(263),n2h16(567))
  Gcoeff(:)%j = (c(9)*M(21,:)%j+c(6)*(M(26,:)%j+M(28,:)%j+M(32,:)%j-M(37,:)%j)) * den(36)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(1346),h0tab(:,1346),[34,1,16,12],[nMT,0,0,0],5,1,wf4(:,23))
  call Hloop_VA_Q(ntryL,G0H64(1),wf4(:,23),G0H16(220),m3h4x16(:,185),heltab2x64(:,:,932))
  call Hloop_A_Q(ntryL,G0H16(220),34,nMT,G1H16(264),n2h16(568))
  Gcoeff(:)%j = (c(9)*(-M(19,:)%j+M(21,:)%j)+c(6)*(-M(37,:)%j+M(39,:)%j)) * den(36)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(1347),h0tab(:,1347),[34,1,16,12],[nMT,0,0,0],5,1,wf4(:,23))
  call Hloop_VA_Q(ntryL,G0H64(1),wf4(:,23),G0H16(220),m3h4x16(:,186),heltab2x64(:,:,933))
  call Hloop_A_Q(ntryL,G0H16(220),34,nMT,G1H16(265),n2h16(569))
  Gcoeff(:)%j = (c(16)*(-M(28,:)%j-M(32,:)%j+M(37,:)%j)) * den(36)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(1348),h0tab(:,1348),[34,12,1,16],[0,0,nMT,nMT],5,1,wf4(:,23))
  call Hloop_QA_V(ntryL,G0H64(1),wf4(:,23),G0H16(220),m3h4x16(:,187),heltab2x64(:,:,934))
  Gcoeff(:)%j = (c(16)*(-M(28,:)%j-M(32,:)%j+M(39,:)%j)) * den(36)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(1349),h0tab(:,1349),[34,12,1,16],[0,0,nMT,nMT],5,1,wf4(:,23))
  call Hloop_QA_V(ntryL,G0H64(1),wf4(:,23),G0H16(221),m3h4x16(:,188),heltab2x64(:,:,935))
  Gcoeff(:)%j = (c(16)*(-M(37,:)%j+M(39,:)%j)) * den(36)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(1350),h0tab(:,1350),[34,12,1,16],[0,0,nMT,nMT],5,1,wf4(:,23))
  call Hloop_QA_V(ntryL,G0H64(1),wf4(:,23),G0H16(222),m3h4x16(:,189),heltab2x64(:,:,936))
  Gcoeff(:)%j = (c(9)*M(23,:)%j+c(6)*(M(26,:)%j+M(28,:)%j+M(32,:)%j-M(39,:)%j)) * den(36)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(1351),h0tab(:,1351),[34,1,12,16],[nMT,0,0,0],5,1,wf4(:,23))
  call Hloop_VA_Q(ntryL,G0H64(1),wf4(:,23),G0H16(223),m3h4x16(:,190),heltab2x64(:,:,937))
  call Hloop_A_Q(ntryL,G0H16(223),34,nMT,G1H16(267),n2h16(570))
  Gcoeff(:)%j = (c(9)*M(24,:)%j+c(6)*(M(26,:)%j+M(28,:)%j+M(32,:)%j-M(37,:)%j)) * den(36)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(1352),h0tab(:,1352),[34,1,12,16],[nMT,0,0,0],5,1,wf4(:,23))
  call Hloop_VA_Q(ntryL,G0H64(1),wf4(:,23),G0H16(223),m3h4x16(:,191),heltab2x64(:,:,938))
  call Hloop_A_Q(ntryL,G0H16(223),34,nMT,G1H16(268),n2h16(571))
  Gcoeff(:)%j = (c(9)*(-M(23,:)%j+M(24,:)%j)+c(6)*(-M(37,:)%j+M(39,:)%j)) * den(36)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(1353),h0tab(:,1353),[34,1,12,16],[nMT,0,0,0],5,1,wf4(:,23))
  call Hloop_VA_Q(ntryL,G0H64(1),wf4(:,23),G0H16(223),m3h4x16(:,192),heltab2x64(:,:,939))
  call Hloop_A_Q(ntryL,G0H16(223),34,nMT,G1H16(269),n2h16(572))
  Gcoeff(:)%j = (c(19)*(M(7,:)%j-M(8,:)%j)+c(16)*(M(25,:)%j-M(26,:)%j+M(40,:)%j-M(42,:)%j+M(43,:)%j-M(44,:)%j-M(45,:)%j &
    +M(46,:)%j)) * den(16)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(1354),h0tab(:,1354),[48,1,2,12],[0,nMT,0,0],5,1,wf4(:,7))
  call Hloop_UV_W(ntryL,G0H64(1),0,wf4(:,7),48,G1H16(270),m3h4x16(:,193),heltab2x64(:,:,940))
  Gcoeff(:)%j = (c(19)*(M(1,:)%j-M(2,:)%j)+c(16)*(M(25,:)%j-M(26,:)%j+M(40,:)%j-M(42,:)%j+M(43,:)%j-M(44,:)%j-M(48,:)%j &
    +M(50,:)%j)) * den(16)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(1355),h0tab(:,1355),[48,1,2,12],[0,nMT,0,0],5,1,wf4(:,7))
  call Hloop_UV_W(ntryL,G0H64(1),0,wf4(:,7),48,G1H16(273),m3h4x16(:,194),heltab2x64(:,:,941))
  Gcoeff(:)%j = (c(19)*(M(1,:)%j-M(2,:)%j-M(7,:)%j+M(8,:)%j)+c(16)*(M(45,:)%j-M(46,:)%j-M(48,:)%j+M(50,:)%j)) * den(16)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(1356),h0tab(:,1356),[48,1,2,12],[0,nMT,0,0],5,1,wf4(:,7))
  call Hloop_UV_W(ntryL,G0H64(1),0,wf4(:,7),48,G1H16(274),m3h4x16(:,195),heltab2x64(:,:,942))
  Gcoeff(:)%j = (c(19)*(-M(17,:)%j+M(23,:)%j)+c(16)*(-M(25,:)%j+M(26,:)%j-M(40,:)%j+M(42,:)%j-M(43,:)%j+M(44,:)%j+M(48,:)%j &
    -M(50,:)%j)) * den(16)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(1357),h0tab(:,1357),[48,2,1,12],[0,nMT,0,0],5,1,wf4(:,7))
  call Hloop_UV_W(ntryL,G0H64(1),0,wf4(:,7),48,G1H16(275),m3h4x16(:,196),heltab2x64(:,:,943))
  Gcoeff(:)%j = (c(19)*(-M(18,:)%j+M(24,:)%j)+c(16)*(-M(25,:)%j+M(26,:)%j-M(40,:)%j+M(42,:)%j-M(43,:)%j+M(44,:)%j+M(45,:)%j &
    -M(46,:)%j)) * den(16)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(1358),h0tab(:,1358),[48,2,1,12],[0,nMT,0,0],5,1,wf4(:,7))
  call Hloop_UV_W(ntryL,G0H64(1),0,wf4(:,7),48,G1H16(32),m3h4x16(:,197),heltab2x64(:,:,944))
  Gcoeff(:)%j = (c(19)*(M(17,:)%j-M(18,:)%j-M(23,:)%j+M(24,:)%j)+c(16)*(M(45,:)%j-M(46,:)%j-M(48,:)%j+M(50,:)%j)) * den(16)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(1359),h0tab(:,1359),[48,2,1,12],[0,nMT,0,0],5,1,wf4(:,7))
  call Hloop_UV_W(ntryL,G0H64(1),0,wf4(:,7),48,G1H16(276),m3h4x16(:,198),heltab2x64(:,:,945))
  Gcoeff(:)%j = (c(6)*(M(40,:)%j-M(42,:)%j+M(43,:)%j-M(44,:)%j-M(48,:)%j+M(50,:)%j)) * den(16)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(1360),h0tab(:,1360),[48,1,12,2],[nMT,0,0,nMT],5,1,wf4(:,7))
  call Hloop_AV_Q(ntryL,G0H64(1),wf4(:,7),G0H16(223),m3h4x16(:,199),heltab2x64(:,:,946))
  call Hloop_A_Q(ntryL,G0H16(223),48,nMT,G1H16(33),n2h16(573))
  Gcoeff(:)%j = (c(6)*(M(40,:)%j-M(42,:)%j+M(43,:)%j-M(44,:)%j-M(45,:)%j+M(46,:)%j)) * den(16)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(1361),h0tab(:,1361),[48,1,12,2],[nMT,0,0,nMT],5,1,wf4(:,7))
  call Hloop_AV_Q(ntryL,G0H64(1),wf4(:,7),G0H16(223),m3h4x16(:,200),heltab2x64(:,:,947))
  call Hloop_A_Q(ntryL,G0H16(223),48,nMT,G1H16(281),n2h16(574))
  Gcoeff(:)%j = (c(6)*(-M(45,:)%j+M(46,:)%j+M(48,:)%j-M(50,:)%j)) * den(16)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(1362),h0tab(:,1362),[48,1,12,2],[nMT,0,0,nMT],5,1,wf4(:,7))
  call Hloop_AV_Q(ntryL,G0H64(1),wf4(:,7),G0H16(223),m3h4x16(:,201),heltab2x64(:,:,948))
  call Hloop_A_Q(ntryL,G0H16(223),48,nMT,G1H16(285),n2h16(575))
  Gcoeff(:)%j = (c(15)*(-M(2,:)%j+M(8,:)%j+M(19,:)%j-M(21,:)%j)+c(16)*(-M(45,:)%j+M(46,:)%j+M(48,:)%j-M(50,:)%j)) * den(18)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(1363),h0tab(:,1363),[44,2,1,16],[nMT,0,nMT,nMT],4,1,wf8(:,9))
  call Hloop_QV_A(ntryL,G0H64(1),wf8(:,9),G0H8(91),m3h8x8(:,37),heltab2x64(:,:,949))
  call Hloop_Q_A(ntryL,G0H8(91),44,nMT,G1H8(991),n2h8(1332))
  Gcoeff(:)%j = (c(15)*(M(2,:)%j-M(5,:)%j-M(11,:)%j+M(21,:)%j)+c(16)*(-M(46,:)%j+M(47,:)%j-M(48,:)%j+M(49,:)%j)) * den(18)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(1364),h0tab(:,1364),[44,2,1,16],[nMT,0,nMT,nMT],4,1,wf8(:,11))
  call Hloop_QV_A(ntryL,G0H64(1),wf8(:,11),G0H8(91),m3h8x8(:,38),heltab2x64(:,:,950))
  call Hloop_Q_A(ntryL,G0H8(91),44,nMT,G1H8(992),n2h8(1333))
  Gcoeff(:)%j = (c(15)*(M(5,:)%j-M(8,:)%j+M(11,:)%j-M(19,:)%j)+c(16)*(M(45,:)%j-M(47,:)%j-M(49,:)%j+M(50,:)%j)) * den(18)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(1365),h0tab(:,1365),[44,2,1,16],[nMT,0,nMT,nMT],4,1,wf8(:,12))
  call Hloop_QV_A(ntryL,G0H64(1),wf8(:,12),G0H8(91),m3h8x8(:,39),heltab2x64(:,:,951))
  call Hloop_Q_A(ntryL,G0H8(91),44,nMT,G1H8(1007),n2h8(1334))
  Gcoeff(:)%j = (c(19)*(M(2,:)%j-M(8,:)%j-M(19,:)%j+M(21,:)%j)+c(16)*(-M(45,:)%j+M(46,:)%j+M(48,:)%j-M(50,:)%j)) * den(18)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(1366),h0tab(:,1366),[44,2,1,16],[0,nMT,0,0],4,1,wf8(:,9))
  call Hloop_UV_W(ntryL,G0H64(1),0,wf8(:,9),44,G1H8(1008),m3h8x8(:,40),heltab2x64(:,:,952))
  Gcoeff(:)%j = (c(19)*(-M(2,:)%j+M(5,:)%j+M(11,:)%j-M(21,:)%j)+c(16)*(-M(46,:)%j+M(47,:)%j-M(48,:)%j+M(49,:)%j)) * den(18)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(1367),h0tab(:,1367),[44,2,1,16],[0,nMT,0,0],4,1,wf8(:,11))
  call Hloop_UV_W(ntryL,G0H64(1),0,wf8(:,11),44,G1H8(1023),m3h8x8(:,41),heltab2x64(:,:,953))
  Gcoeff(:)%j = (c(19)*(-M(5,:)%j+M(8,:)%j-M(11,:)%j+M(19,:)%j)+c(16)*(M(45,:)%j-M(47,:)%j-M(49,:)%j+M(50,:)%j)) * den(18)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(1368),h0tab(:,1368),[44,2,1,16],[0,nMT,0,0],4,1,wf8(:,12))
  call Hloop_UV_W(ntryL,G0H64(1),0,wf8(:,12),44,G1H8(1024),m3h8x8(:,42),heltab2x64(:,:,954))
  Gcoeff(:)%j = (c(15)*(-M(13,:)%j+M(15,:)%j+M(17,:)%j-M(18,:)%j)+c(16)*(-M(45,:)%j+M(46,:)%j+M(48,:)%j-M(50,:)%j)) * den(18)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(1369),h0tab(:,1369),[44,1,2,16],[nMT,0,nMT,nMT],4,1,wf8(:,9))
  call Hloop_AV_Q(ntryL,G0H64(1),wf8(:,9),G0H8(91),m3h8x8(:,43),heltab2x64(:,:,955))
  call Hloop_A_Q(ntryL,G0H8(91),44,nMT,G1H8(1039),n2h8(1335))
  Gcoeff(:)%j = (c(15)*(M(13,:)%j-M(14,:)%j-M(16,:)%j+M(18,:)%j)+c(16)*(-M(46,:)%j+M(47,:)%j-M(48,:)%j+M(49,:)%j)) * den(18)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(1370),h0tab(:,1370),[44,1,2,16],[nMT,0,nMT,nMT],4,1,wf8(:,11))
  call Hloop_AV_Q(ntryL,G0H64(1),wf8(:,11),G0H8(91),m3h8x8(:,44),heltab2x64(:,:,956))
  call Hloop_A_Q(ntryL,G0H8(91),44,nMT,G1H8(1040),n2h8(1336))
  Gcoeff(:)%j = (c(15)*(M(14,:)%j-M(15,:)%j+M(16,:)%j-M(17,:)%j)+c(16)*(M(45,:)%j-M(47,:)%j-M(49,:)%j+M(50,:)%j)) * den(18)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(1371),h0tab(:,1371),[44,1,2,16],[nMT,0,nMT,nMT],4,1,wf8(:,12))
  call Hloop_AV_Q(ntryL,G0H64(1),wf8(:,12),G0H8(91),m3h8x8(:,45),heltab2x64(:,:,957))
  call Hloop_A_Q(ntryL,G0H8(91),44,nMT,G1H8(1055),n2h8(1337))
  Gcoeff(:)%j = (c(19)*(M(13,:)%j-M(15,:)%j-M(17,:)%j+M(18,:)%j)+c(16)*(-M(45,:)%j+M(46,:)%j+M(48,:)%j-M(50,:)%j)) * den(18)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(1372),h0tab(:,1372),[44,1,2,16],[0,nMT,0,0],4,1,wf8(:,9))
  call Hloop_UV_W(ntryL,G0H64(1),0,wf8(:,9),44,G1H8(1056),m3h8x8(:,46),heltab2x64(:,:,958))
  Gcoeff(:)%j = (c(19)*(-M(13,:)%j+M(14,:)%j+M(16,:)%j-M(18,:)%j)+c(16)*(-M(46,:)%j+M(47,:)%j-M(48,:)%j+M(49,:)%j)) * den(18)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(1373),h0tab(:,1373),[44,1,2,16],[0,nMT,0,0],4,1,wf8(:,11))
  call Hloop_UV_W(ntryL,G0H64(1),0,wf8(:,11),44,G1H8(1071),m3h8x8(:,47),heltab2x64(:,:,959))
  Gcoeff(:)%j = (c(19)*(-M(14,:)%j+M(15,:)%j-M(16,:)%j+M(17,:)%j)+c(16)*(M(45,:)%j-M(47,:)%j-M(49,:)%j+M(50,:)%j)) * den(18)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(1374),h0tab(:,1374),[44,1,2,16],[0,nMT,0,0],4,1,wf8(:,12))
  call Hloop_UV_W(ntryL,G0H64(1),0,wf8(:,12),44,G1H8(1072),m3h8x8(:,48),heltab2x64(:,:,960))
  Gcoeff(:)%j = (c(6)*(-M(45,:)%j+M(46,:)%j+M(48,:)%j-M(50,:)%j)) * den(18)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(1375),h0tab(:,1375),[44,1,16,2],[0,nMT,nMT,0],4,1,wf8(:,9))
  call Hloop_UV_W(ntryL,G0H64(1),0,wf8(:,9),44,G1H8(1087),m3h8x8(:,49),heltab2x64(:,:,961))
  Gcoeff(:)%j = (c(6)*(-M(46,:)%j+M(47,:)%j-M(48,:)%j+M(49,:)%j)) * den(18)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(1376),h0tab(:,1376),[44,1,16,2],[0,nMT,nMT,0],4,1,wf8(:,11))
  call Hloop_UV_W(ntryL,G0H64(1),0,wf8(:,11),44,G1H8(1088),m3h8x8(:,50),heltab2x64(:,:,962))
  Gcoeff(:)%j = (c(6)*(M(45,:)%j-M(47,:)%j-M(49,:)%j+M(50,:)%j)) * den(18)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(1377),h0tab(:,1377),[44,1,16,2],[0,nMT,nMT,0],4,1,wf8(:,12))
  call Hloop_UV_W(ntryL,G0H64(1),0,wf8(:,12),44,G1H8(1103),m3h8x8(:,51),heltab2x64(:,:,963))
  Gcoeff(:)%j = (c(6)*(M(45,:)%j-M(46,:)%j-M(48,:)%j+M(50,:)%j)) * den(18)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(1378),h0tab(:,1378),[44,1,16,2],[nMT,0,0,nMT],4,1,wf8(:,9))
  call Hloop_AV_Q(ntryL,G0H64(1),wf8(:,9),G0H8(91),m3h8x8(:,52),heltab2x64(:,:,964))
  call Hloop_A_Q(ntryL,G0H8(91),44,nMT,G1H8(1104),n2h8(1338))
  Gcoeff(:)%j = (c(6)*(M(46,:)%j-M(47,:)%j+M(48,:)%j-M(49,:)%j)) * den(18)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(1379),h0tab(:,1379),[44,1,16,2],[nMT,0,0,nMT],4,1,wf8(:,11))
  call Hloop_AV_Q(ntryL,G0H64(1),wf8(:,11),G0H8(91),m3h8x8(:,53),heltab2x64(:,:,965))
  call Hloop_A_Q(ntryL,G0H8(91),44,nMT,G1H8(1119),n2h8(1339))
  Gcoeff(:)%j = (c(6)*(-M(45,:)%j+M(47,:)%j+M(49,:)%j-M(50,:)%j)) * den(18)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(1380),h0tab(:,1380),[44,1,16,2],[nMT,0,0,nMT],4,1,wf8(:,12))
  call Hloop_AV_Q(ntryL,G0H64(1),wf8(:,12),G0H8(91),m3h8x8(:,54),heltab2x64(:,:,966))
  call Hloop_A_Q(ntryL,G0H8(91),44,nMT,G1H8(1120),n2h8(1340))
  Gcoeff(:)%j = (c(15)*(-M(1,:)%j+M(7,:)%j+M(13,:)%j-M(15,:)%j)+c(16)*(M(45,:)%j-M(46,:)%j-M(48,:)%j+M(50,:)%j)) * den(20)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(1381),h0tab(:,1381),[32,1,2,28],[nMT,0,nMT,nMT],4,1,wf8(:,13))
  call Hloop_AV_Q(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,712),heltab2x64(:,:,967))
  call Hloop_A_Q(ntryL,G0H32(1),32,nMT,G1H32(112),n2h32(328))
  Gcoeff(:)%j = (c(15)*(M(1,:)%j-M(3,:)%j-M(9,:)%j+M(15,:)%j)+c(16)*(-M(45,:)%j+M(47,:)%j+M(49,:)%j-M(50,:)%j)) * den(20)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(1382),h0tab(:,1382),[32,1,2,28],[nMT,0,nMT,nMT],4,1,wf8(:,15))
  call Hloop_AV_Q(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,713),heltab2x64(:,:,968))
  call Hloop_A_Q(ntryL,G0H32(1),32,nMT,G1H32(114),n2h32(329))
  Gcoeff(:)%j = (c(15)*(M(3,:)%j-M(7,:)%j+M(9,:)%j-M(13,:)%j)+c(16)*(M(46,:)%j-M(47,:)%j+M(48,:)%j-M(49,:)%j)) * den(20)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(1383),h0tab(:,1383),[32,1,2,28],[nMT,0,nMT,nMT],4,1,wf8(:,16))
  call Hloop_AV_Q(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,714),heltab2x64(:,:,969))
  call Hloop_A_Q(ntryL,G0H32(1),32,nMT,G1H32(116),n2h32(330))
  Gcoeff(:)%j = (c(19)*(M(1,:)%j-M(7,:)%j-M(13,:)%j+M(15,:)%j)+c(16)*(M(45,:)%j-M(46,:)%j-M(48,:)%j+M(50,:)%j)) * den(20)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(1384),h0tab(:,1384),[32,1,2,28],[0,nMT,0,0],4,1,wf8(:,13))
  call Hloop_UV_W(ntryL,G0H64(1),0,ex6(:),32,G1H32(117),m3h2x32(:,715),heltab2x64(:,:,970))
  Gcoeff(:)%j = (c(19)*(-M(1,:)%j+M(3,:)%j+M(9,:)%j-M(15,:)%j)+c(16)*(-M(45,:)%j+M(47,:)%j+M(49,:)%j-M(50,:)%j)) * den(20)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(1385),h0tab(:,1385),[32,1,2,28],[0,nMT,0,0],4,1,wf8(:,15))
  call Hloop_UV_W(ntryL,G0H64(1),0,ex6(:),32,G1H32(118),m3h2x32(:,716),heltab2x64(:,:,971))
  Gcoeff(:)%j = (c(19)*(-M(3,:)%j+M(7,:)%j-M(9,:)%j+M(13,:)%j)+c(16)*(M(46,:)%j-M(47,:)%j+M(48,:)%j-M(49,:)%j)) * den(20)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(1386),h0tab(:,1386),[32,1,2,28],[0,nMT,0,0],4,1,wf8(:,16))
  call Hloop_UV_W(ntryL,G0H64(1),0,ex6(:),32,G1H32(119),m3h2x32(:,717),heltab2x64(:,:,972))
  Gcoeff(:)%j = (c(15)*(-M(19,:)%j+M(21,:)%j+M(23,:)%j-M(24,:)%j)+c(16)*(M(45,:)%j-M(46,:)%j-M(48,:)%j+M(50,:)%j)) * den(20)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(1387),h0tab(:,1387),[32,2,1,28],[nMT,0,nMT,nMT],4,1,wf8(:,13))
  call Hloop_QV_A(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,718),heltab2x64(:,:,973))
  call Hloop_Q_A(ntryL,G0H32(1),32,nMT,G1H32(124),n2h32(331))
  Gcoeff(:)%j = (c(15)*(M(19,:)%j-M(20,:)%j-M(22,:)%j+M(24,:)%j)+c(16)*(-M(45,:)%j+M(47,:)%j+M(49,:)%j-M(50,:)%j)) * den(20)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(1388),h0tab(:,1388),[32,2,1,28],[nMT,0,nMT,nMT],4,1,wf8(:,15))
  call Hloop_QV_A(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,719),heltab2x64(:,:,974))
  call Hloop_Q_A(ntryL,G0H32(1),32,nMT,G1H32(121),n2h32(332))
  Gcoeff(:)%j = (c(15)*(M(20,:)%j-M(21,:)%j+M(22,:)%j-M(23,:)%j)+c(16)*(M(46,:)%j-M(47,:)%j+M(48,:)%j-M(49,:)%j)) * den(20)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(1389),h0tab(:,1389),[32,2,1,28],[nMT,0,nMT,nMT],4,1,wf8(:,16))
  call Hloop_QV_A(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,720),heltab2x64(:,:,975))
  call Hloop_Q_A(ntryL,G0H32(1),32,nMT,G1H32(126),n2h32(333))
  Gcoeff(:)%j = (c(19)*(M(19,:)%j-M(21,:)%j-M(23,:)%j+M(24,:)%j)+c(16)*(M(45,:)%j-M(46,:)%j-M(48,:)%j+M(50,:)%j)) * den(20)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(1390),h0tab(:,1390),[32,2,1,28],[0,nMT,0,0],4,1,wf8(:,13))
  call Hloop_UV_W(ntryL,G0H64(1),0,ex6(:),32,G1H32(123),m3h2x32(:,721),heltab2x64(:,:,976))
  Gcoeff(:)%j = (c(19)*(-M(19,:)%j+M(20,:)%j+M(22,:)%j-M(24,:)%j)+c(16)*(-M(45,:)%j+M(47,:)%j+M(49,:)%j-M(50,:)%j)) * den(20)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(1391),h0tab(:,1391),[32,2,1,28],[0,nMT,0,0],4,1,wf8(:,15))
  call Hloop_UV_W(ntryL,G0H64(1),0,ex6(:),32,G1H32(125),m3h2x32(:,722),heltab2x64(:,:,977))
  Gcoeff(:)%j = (c(19)*(-M(20,:)%j+M(21,:)%j-M(22,:)%j+M(23,:)%j)+c(16)*(M(46,:)%j-M(47,:)%j+M(48,:)%j-M(49,:)%j)) * den(20)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(1392),h0tab(:,1392),[32,2,1,28],[0,nMT,0,0],4,1,wf8(:,16))
  call Hloop_UV_W(ntryL,G0H64(1),0,ex6(:),32,G1H32(127),m3h2x32(:,723),heltab2x64(:,:,978))
  Gcoeff(:)%j = (c(6)*(-M(45,:)%j+M(46,:)%j+M(48,:)%j-M(50,:)%j)) * den(20)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(1393),h0tab(:,1393),[32,1,28,2],[nMT,0,0,nMT],4,1,wf8(:,13))
  call Hloop_AV_Q(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,724),heltab2x64(:,:,979))
  call Hloop_A_Q(ntryL,G0H32(1),32,nMT,G1H32(128),n2h32(334))
  Gcoeff(:)%j = (c(6)*(M(45,:)%j-M(47,:)%j-M(49,:)%j+M(50,:)%j)) * den(20)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(1394),h0tab(:,1394),[32,1,28,2],[nMT,0,0,nMT],4,1,wf8(:,15))
  call Hloop_AV_Q(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,725),heltab2x64(:,:,980))
  call Hloop_A_Q(ntryL,G0H32(1),32,nMT,G1H32(129),n2h32(335))
  Gcoeff(:)%j = (c(6)*(-M(46,:)%j+M(47,:)%j-M(48,:)%j+M(49,:)%j)) * den(20)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(1395),h0tab(:,1395),[32,1,28,2],[nMT,0,0,nMT],4,1,wf8(:,16))
  call Hloop_AV_Q(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,726),heltab2x64(:,:,981))
  call Hloop_A_Q(ntryL,G0H32(1),32,nMT,G1H32(130),n2h32(336))
  Gcoeff(:)%j = (c(6)*(M(45,:)%j-M(46,:)%j-M(48,:)%j+M(50,:)%j)) * den(20)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(1396),h0tab(:,1396),[32,1,28,2],[0,nMT,nMT,0],4,1,wf8(:,13))
  call Hloop_UV_W(ntryL,G0H64(1),0,ex6(:),32,G1H32(135),m3h2x32(:,727),heltab2x64(:,:,982))
  Gcoeff(:)%j = (c(6)*(-M(45,:)%j+M(47,:)%j+M(49,:)%j-M(50,:)%j)) * den(20)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(1397),h0tab(:,1397),[32,1,28,2],[0,nMT,nMT,0],4,1,wf8(:,15))
  call Hloop_UV_W(ntryL,G0H64(1),0,ex6(:),32,G1H32(132),m3h2x32(:,728),heltab2x64(:,:,983))
  Gcoeff(:)%j = (c(6)*(M(46,:)%j-M(47,:)%j+M(48,:)%j-M(49,:)%j)) * den(20)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(1398),h0tab(:,1398),[32,1,28,2],[0,nMT,nMT,0],4,1,wf8(:,16))
  call Hloop_UV_W(ntryL,G0H64(1),0,ex6(:),32,G1H32(137),m3h2x32(:,729),heltab2x64(:,:,984))
  Gcoeff(:)%j = (c(24)*(M(17,:)%j-M(18,:)%j)+c(23)*(-M(45,:)%j+M(48,:)%j)) * den(3)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(1399),h0tab(:,1399),[32,12,3,16],[0,0,0,0],4,2,wf4(:,2),wf4(:,1))
  call Hloop_AV_Q(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,730),heltab2x64(:,:,985))
  call Hloop_A_Q(ntryL,G0H32(1),32,0,G1H32(134),n2h32(337))
  Gcoeff(:)%j = (c(22)*(M(17,:)%j-M(18,:)%j)+c(21)*(-M(45,:)%j+M(48,:)%j)) * den(3)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(1400),h0tab(:,1400),[32,12,3,16],[nMT,nMT,nMT,nMT],4,2,wf4(:,2),wf4(:,1))
  call Hloop_AV_Q(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,731),heltab2x64(:,:,986))
  call Hloop_A_Q(ntryL,G0H32(1),32,nMT,G1H32(136),n2h32(338))
  Gcoeff(:)%j = (c(24)*(M(2,:)%j-M(8,:)%j)+c(23)*(-M(46,:)%j+M(50,:)%j)) * den(3)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(1401),h0tab(:,1401),[32,12,3,16],[0,0,0,0],4,2,wf4(:,2),wf4(:,1))
  call Hloop_QV_A(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,732),heltab2x64(:,:,987))
  call Hloop_Q_A(ntryL,G0H32(1),32,0,G1H32(138),n2h32(339))
  Gcoeff(:)%j = (c(22)*(M(2,:)%j-M(8,:)%j)+c(21)*(-M(46,:)%j+M(50,:)%j)) * den(3)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(1402),h0tab(:,1402),[32,12,3,16],[nMT,nMT,nMT,nMT],4,2,wf4(:,2),wf4(:,1))
  call Hloop_QV_A(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,733),heltab2x64(:,:,988))
  call Hloop_Q_A(ntryL,G0H32(1),32,nMT,G1H32(139),n2h32(340))
  Gcoeff(:)%j = (c(24)*(M(17,:)%j-M(18,:)%j)+c(23)*(-M(45,:)%j+M(48,:)%j)) * den(3)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(1403),h0tab(:,1403),[32,12,3,16],[0,0,0,0],4,2,wf4(:,2),wf4(:,1))
  call Hloop_AV_Q(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,734),heltab2x64(:,:,989))
  call Hloop_A_Q(ntryL,G0H32(1),32,0,G1H32(140),n2h32(341))
  Gcoeff(:)%j = (c(22)*(M(17,:)%j-M(18,:)%j)+c(21)*(-M(45,:)%j+M(48,:)%j)) * den(3)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(1404),h0tab(:,1404),[32,12,3,16],[nMB,nMB,nMB,nMB],4,2,wf4(:,2),wf4(:,1))
  call Hloop_AV_Q(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,735),heltab2x64(:,:,990))
  call Hloop_A_Q(ntryL,G0H32(1),32,nMB,G1H32(141),n2h32(342))
  Gcoeff(:)%j = (c(24)*(M(2,:)%j-M(8,:)%j)+c(23)*(-M(46,:)%j+M(50,:)%j)) * den(3)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(1405),h0tab(:,1405),[32,12,3,16],[0,0,0,0],4,2,wf4(:,2),wf4(:,1))
  call Hloop_QV_A(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,736),heltab2x64(:,:,991))
  call Hloop_Q_A(ntryL,G0H32(1),32,0,G1H32(146),n2h32(343))
  Gcoeff(:)%j = (c(22)*(M(2,:)%j-M(8,:)%j)+c(21)*(-M(46,:)%j+M(50,:)%j)) * den(3)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(1406),h0tab(:,1406),[32,12,3,16],[nMB,nMB,nMB,nMB],4,2,wf4(:,2),wf4(:,1))
  call Hloop_QV_A(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,737),heltab2x64(:,:,992))
  call Hloop_Q_A(ntryL,G0H32(1),32,nMB,G1H32(143),n2h32(344))
  Gcoeff(:)%j = (c(9)*(M(2,:)%j-M(8,:)%j+M(17,:)%j-M(18,:)%j)+c(7)*(M(35,:)%j-M(36,:)%j+M(37,:)%j+M(38,:)%j-M(39,:)%j-M(41,:)%j) &
    +c(6)*(-M(45,:)%j-M(46,:)%j+M(48,:)%j+M(50,:)%j)) * den(3)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(1407),h0tab(:,1407),[32,12,3,16],[0,0,0,0],4,2,wf4(:,2),wf4(:,1))
  call Hloop_DV_C(ntryL,G0H64(1),0,ex6(:),G1H32(148),m3h2x32(:,738),heltab2x64(:,:,993))
  Gcoeff(:)%j = (c(9)*(M(2,:)%j-M(8,:)%j+M(17,:)%j-M(18,:)%j)+c(7)*(M(35,:)%j-M(36,:)%j+M(37,:)%j+M(38,:)%j-M(39,:)%j-M(41,:)%j) &
    +c(6)*(-M(45,:)%j-M(46,:)%j+M(48,:)%j+M(50,:)%j)) * den(3)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(1408),h0tab(:,1408),[32,12,3,16],[0,0,0,0],4,2,wf4(:,2),wf4(:,1))
  call Hloop_CV_D(ntryL,G0H64(1),0,ex6(:),32,G1H32(145),m3h2x32(:,739),heltab2x64(:,:,994))
  Gcoeff(:)%j = (c(9)*(-M(2,:)%j+M(8,:)%j-M(17,:)%j+M(18,:)%j)+c(7)*(-M(35,:)%j+M(36,:)%j-M(37,:)%j-M(38,:)%j+M(39,:)%j+M(41,:)%j) &
    +c(6)*(M(45,:)%j+M(46,:)%j-M(48,:)%j-M(50,:)%j)) * den(3)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(1409),h0tab(:,1409),[32,12,3,16],[0,0,0,0],4,2,wf4(:,2),wf4(:,1))
  call Hloop_UV_W(ntryL,G0H64(1),0,ex6(:),32,G1H32(147),m3h2x32(:,740),heltab2x64(:,:,995))
  Gcoeff(:)%j = (c(24)*(M(1,:)%j-M(7,:)%j)+c(23)*(-M(45,:)%j+M(48,:)%j)) * den(3)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(1410),h0tab(:,1410),[32,3,12,16],[0,0,0,0],4,2,wf4(:,1),wf4(:,2))
  call Hloop_AV_Q(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,741),heltab2x64(:,:,996))
  call Hloop_A_Q(ntryL,G0H32(1),32,0,G1H32(149),n2h32(345))
  Gcoeff(:)%j = (c(22)*(M(1,:)%j-M(7,:)%j)+c(21)*(-M(45,:)%j+M(48,:)%j)) * den(3)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(1411),h0tab(:,1411),[32,3,12,16],[nMT,nMT,nMT,nMT],4,2,wf4(:,1),wf4(:,2))
  call Hloop_AV_Q(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,742),heltab2x64(:,:,997))
  call Hloop_A_Q(ntryL,G0H32(1),32,nMT,G1H32(150),n2h32(346))
  Gcoeff(:)%j = (c(24)*(M(23,:)%j-M(24,:)%j)+c(23)*(-M(46,:)%j+M(50,:)%j)) * den(3)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(1412),h0tab(:,1412),[32,3,12,16],[0,0,0,0],4,2,wf4(:,1),wf4(:,2))
  call Hloop_QV_A(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,743),heltab2x64(:,:,998))
  call Hloop_Q_A(ntryL,G0H32(1),32,0,G1H32(151),n2h32(347))
  Gcoeff(:)%j = (c(22)*(M(23,:)%j-M(24,:)%j)+c(21)*(-M(46,:)%j+M(50,:)%j)) * den(3)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(1413),h0tab(:,1413),[32,3,12,16],[nMT,nMT,nMT,nMT],4,2,wf4(:,1),wf4(:,2))
  call Hloop_QV_A(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,744),heltab2x64(:,:,999))
  call Hloop_Q_A(ntryL,G0H32(1),32,nMT,G1H32(152),n2h32(348))
  Gcoeff(:)%j = (c(24)*(M(1,:)%j-M(7,:)%j)+c(23)*(-M(45,:)%j+M(48,:)%j)) * den(3)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(1414),h0tab(:,1414),[32,3,12,16],[0,0,0,0],4,2,wf4(:,1),wf4(:,2))
  call Hloop_AV_Q(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,745),heltab2x64(:,:,1000))
  call Hloop_A_Q(ntryL,G0H32(1),32,0,G1H32(157),n2h32(349))
  Gcoeff(:)%j = (c(22)*(M(1,:)%j-M(7,:)%j)+c(21)*(-M(45,:)%j+M(48,:)%j)) * den(3)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(1415),h0tab(:,1415),[32,3,12,16],[nMB,nMB,nMB,nMB],4,2,wf4(:,1),wf4(:,2))
  call Hloop_AV_Q(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,746),heltab2x64(:,:,1001))
  call Hloop_A_Q(ntryL,G0H32(1),32,nMB,G1H32(154),n2h32(350))
  Gcoeff(:)%j = (c(24)*(M(23,:)%j-M(24,:)%j)+c(23)*(-M(46,:)%j+M(50,:)%j)) * den(3)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(1416),h0tab(:,1416),[32,3,12,16],[0,0,0,0],4,2,wf4(:,1),wf4(:,2))
  call Hloop_QV_A(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,747),heltab2x64(:,:,1002))
  call Hloop_Q_A(ntryL,G0H32(1),32,0,G1H32(159),n2h32(351))
  Gcoeff(:)%j = (c(22)*(M(23,:)%j-M(24,:)%j)+c(21)*(-M(46,:)%j+M(50,:)%j)) * den(3)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(1417),h0tab(:,1417),[32,3,12,16],[nMB,nMB,nMB,nMB],4,2,wf4(:,1),wf4(:,2))
  call Hloop_QV_A(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,748),heltab2x64(:,:,1003))
  call Hloop_Q_A(ntryL,G0H32(1),32,nMB,G1H32(156),n2h32(352))
  Gcoeff(:)%j = (c(9)*(M(1,:)%j-M(7,:)%j+M(23,:)%j-M(24,:)%j)+c(7)*(M(35,:)%j-M(36,:)%j+M(37,:)%j+M(38,:)%j-M(39,:)%j-M(41,:)%j) &
    +c(6)*(-M(45,:)%j-M(46,:)%j+M(48,:)%j+M(50,:)%j)) * den(3)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(1418),h0tab(:,1418),[32,3,12,16],[0,0,0,0],4,2,wf4(:,1),wf4(:,2))
  call Hloop_DV_C(ntryL,G0H64(1),0,ex6(:),G1H32(158),m3h2x32(:,749),heltab2x64(:,:,1004))
  Gcoeff(:)%j = (c(9)*(M(1,:)%j-M(7,:)%j+M(23,:)%j-M(24,:)%j)+c(7)*(M(35,:)%j-M(36,:)%j+M(37,:)%j+M(38,:)%j-M(39,:)%j-M(41,:)%j) &
    +c(6)*(-M(45,:)%j-M(46,:)%j+M(48,:)%j+M(50,:)%j)) * den(3)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(1419),h0tab(:,1419),[32,3,12,16],[0,0,0,0],4,2,wf4(:,1),wf4(:,2))
  call Hloop_CV_D(ntryL,G0H64(1),0,ex6(:),32,G1H32(160),m3h2x32(:,750),heltab2x64(:,:,1005))
  Gcoeff(:)%j = (c(9)*(-M(1,:)%j+M(7,:)%j-M(23,:)%j+M(24,:)%j)+c(7)*(-M(35,:)%j+M(36,:)%j-M(37,:)%j-M(38,:)%j+M(39,:)%j+M(41,:)%j) &
    +c(6)*(M(45,:)%j+M(46,:)%j-M(48,:)%j-M(50,:)%j)) * den(3)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(1420),h0tab(:,1420),[32,3,12,16],[0,0,0,0],4,2,wf4(:,1),wf4(:,2))
  call Hloop_UV_W(ntryL,G0H64(1),0,ex6(:),32,G1H32(161),m3h2x32(:,751),heltab2x64(:,:,1006))
  Gcoeff(:)%j = (c(24)*(M(19,:)%j-M(21,:)%j)+c(23)*(-M(45,:)%j+M(48,:)%j)) * den(3)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(1421),h0tab(:,1421),[32,3,16,12],[0,0,0,0],4,2,wf4(:,1),wf4(:,2))
  call Hloop_QV_A(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,752),heltab2x64(:,:,1007))
  call Hloop_Q_A(ntryL,G0H32(1),32,0,G1H32(162),n2h32(353))
  Gcoeff(:)%j = (c(22)*(M(19,:)%j-M(21,:)%j)+c(21)*(-M(45,:)%j+M(48,:)%j)) * den(3)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(1422),h0tab(:,1422),[32,3,16,12],[nMT,nMT,nMT,nMT],4,2,wf4(:,1),wf4(:,2))
  call Hloop_QV_A(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,753),heltab2x64(:,:,1008))
  call Hloop_Q_A(ntryL,G0H32(1),32,nMT,G1H32(163),n2h32(354))
  Gcoeff(:)%j = (c(24)*(M(13,:)%j-M(15,:)%j)+c(23)*(-M(46,:)%j+M(50,:)%j)) * den(3)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(1423),h0tab(:,1423),[32,3,16,12],[0,0,0,0],4,2,wf4(:,1),wf4(:,2))
  call Hloop_AV_Q(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,754),heltab2x64(:,:,1009))
  call Hloop_A_Q(ntryL,G0H32(1),32,0,G1H32(168),n2h32(355))
  Gcoeff(:)%j = (c(22)*(M(13,:)%j-M(15,:)%j)+c(21)*(-M(46,:)%j+M(50,:)%j)) * den(3)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(1424),h0tab(:,1424),[32,3,16,12],[nMT,nMT,nMT,nMT],4,2,wf4(:,1),wf4(:,2))
  call Hloop_AV_Q(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,755),heltab2x64(:,:,1010))
  call Hloop_A_Q(ntryL,G0H32(1),32,nMT,G1H32(165),n2h32(356))
  Gcoeff(:)%j = (c(24)*(M(19,:)%j-M(21,:)%j)+c(23)*(-M(45,:)%j+M(48,:)%j)) * den(3)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(1425),h0tab(:,1425),[32,3,16,12],[0,0,0,0],4,2,wf4(:,1),wf4(:,2))
  call Hloop_QV_A(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,756),heltab2x64(:,:,1011))
  call Hloop_Q_A(ntryL,G0H32(1),32,0,G1H32(170),n2h32(357))
  Gcoeff(:)%j = (c(22)*(M(19,:)%j-M(21,:)%j)+c(21)*(-M(45,:)%j+M(48,:)%j)) * den(3)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(1426),h0tab(:,1426),[32,3,16,12],[nMB,nMB,nMB,nMB],4,2,wf4(:,1),wf4(:,2))
  call Hloop_QV_A(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,757),heltab2x64(:,:,1012))
  call Hloop_Q_A(ntryL,G0H32(1),32,nMB,G1H32(167),n2h32(358))
  Gcoeff(:)%j = (c(24)*(M(13,:)%j-M(15,:)%j)+c(23)*(-M(46,:)%j+M(50,:)%j)) * den(3)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(1427),h0tab(:,1427),[32,3,16,12],[0,0,0,0],4,2,wf4(:,1),wf4(:,2))
  call Hloop_AV_Q(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,758),heltab2x64(:,:,1013))
  call Hloop_A_Q(ntryL,G0H32(1),32,0,G1H32(169),n2h32(359))
  Gcoeff(:)%j = (c(22)*(M(13,:)%j-M(15,:)%j)+c(21)*(-M(46,:)%j+M(50,:)%j)) * den(3)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(1428),h0tab(:,1428),[32,3,16,12],[nMB,nMB,nMB,nMB],4,2,wf4(:,1),wf4(:,2))
  call Hloop_AV_Q(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,759),heltab2x64(:,:,1014))
  call Hloop_A_Q(ntryL,G0H32(1),32,nMB,G1H32(171),n2h32(360))
  Gcoeff(:)%j = (c(9)*(M(13,:)%j-M(15,:)%j+M(19,:)%j-M(21,:)%j)+c(7)*(M(35,:)%j-M(36,:)%j+M(37,:)%j+M(38,:)%j-M(39,:)%j-M(41,:)%j) &
    +c(6)*(-M(45,:)%j-M(46,:)%j+M(48,:)%j+M(50,:)%j)) * den(3)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(1429),h0tab(:,1429),[32,3,16,12],[0,0,0,0],4,2,wf4(:,1),wf4(:,2))
  call Hloop_CV_D(ntryL,G0H64(1),0,ex6(:),32,G1H32(172),m3h2x32(:,760),heltab2x64(:,:,1015))
  Gcoeff(:)%j = (c(9)*(M(13,:)%j-M(15,:)%j+M(19,:)%j-M(21,:)%j)+c(7)*(M(35,:)%j-M(36,:)%j+M(37,:)%j+M(38,:)%j-M(39,:)%j-M(41,:)%j) &
    +c(6)*(-M(45,:)%j-M(46,:)%j+M(48,:)%j+M(50,:)%j)) * den(3)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(1430),h0tab(:,1430),[32,3,16,12],[0,0,0,0],4,2,wf4(:,1),wf4(:,2))
  call Hloop_DV_C(ntryL,G0H64(1),0,ex6(:),G1H32(173),m3h2x32(:,761),heltab2x64(:,:,1016))
  Gcoeff(:)%j = (c(9)*(-M(13,:)%j+M(15,:)%j-M(19,:)%j+M(21,:)%j)+c(7)*(-M(35,:)%j+M(36,:)%j-M(37,:)%j-M(38,:)%j+M(39,:)%j &
    +M(41,:)%j)+c(6)*(M(45,:)%j+M(46,:)%j-M(48,:)%j-M(50,:)%j)) * den(3)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(1431),h0tab(:,1431),[32,3,16,12],[0,0,0,0],4,2,wf4(:,1),wf4(:,2))
  call Hloop_UV_W(ntryL,G0H64(1),0,ex6(:),32,G1H32(174),m3h2x32(:,762),heltab2x64(:,:,1017))
  Gcoeff(:)%j = (c(24)*(M(11,:)%j-M(12,:)%j)+c(23)*(M(46,:)%j-M(47,:)%j)) * den(5)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(1432),h0tab(:,1432),[32,8,3,20],[0,0,0,0],4,2,wf4(:,1),wf4(:,3))
  call Hloop_QV_A(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,763),heltab2x64(:,:,1018))
  call Hloop_Q_A(ntryL,G0H32(1),32,0,G1H32(179),n2h32(361))
  Gcoeff(:)%j = (c(22)*(M(11,:)%j-M(12,:)%j)+c(21)*(M(46,:)%j-M(47,:)%j)) * den(5)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(1433),h0tab(:,1433),[32,8,3,20],[nMT,nMT,nMT,nMT],4,2,wf4(:,1),wf4(:,3))
  call Hloop_QV_A(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,764),heltab2x64(:,:,1019))
  call Hloop_Q_A(ntryL,G0H32(1),32,nMT,G1H32(176),n2h32(362))
  Gcoeff(:)%j = (c(24)*(M(4,:)%j-M(14,:)%j)+c(23)*(-M(48,:)%j+M(49,:)%j)) * den(5)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(1434),h0tab(:,1434),[32,8,3,20],[0,0,0,0],4,2,wf4(:,1),wf4(:,3))
  call Hloop_AV_Q(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,765),heltab2x64(:,:,1020))
  call Hloop_A_Q(ntryL,G0H32(1),32,0,G1H32(181),n2h32(363))
  Gcoeff(:)%j = (c(22)*(M(4,:)%j-M(14,:)%j)+c(21)*(-M(48,:)%j+M(49,:)%j)) * den(5)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(1435),h0tab(:,1435),[32,8,3,20],[nMT,nMT,nMT,nMT],4,2,wf4(:,1),wf4(:,3))
  call Hloop_AV_Q(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,766),heltab2x64(:,:,1021))
  call Hloop_A_Q(ntryL,G0H32(1),32,nMT,G1H32(178),n2h32(364))
  Gcoeff(:)%j = (c(24)*(M(11,:)%j-M(12,:)%j)+c(23)*(M(46,:)%j-M(47,:)%j)) * den(5)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(1436),h0tab(:,1436),[32,8,3,20],[0,0,0,0],4,2,wf4(:,1),wf4(:,3))
  call Hloop_QV_A(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,767),heltab2x64(:,:,1022))
  call Hloop_Q_A(ntryL,G0H32(1),32,0,G1H32(180),n2h32(365))
  Gcoeff(:)%j = (c(22)*(M(11,:)%j-M(12,:)%j)+c(21)*(M(46,:)%j-M(47,:)%j)) * den(5)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(1437),h0tab(:,1437),[32,8,3,20],[nMB,nMB,nMB,nMB],4,2,wf4(:,1),wf4(:,3))
  call Hloop_QV_A(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,768),heltab2x64(:,:,1023))
  call Hloop_Q_A(ntryL,G0H32(1),32,nMB,G1H32(182),n2h32(366))
  Gcoeff(:)%j = (c(24)*(M(4,:)%j-M(14,:)%j)+c(23)*(-M(48,:)%j+M(49,:)%j)) * den(5)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(1438),h0tab(:,1438),[32,8,3,20],[0,0,0,0],4,2,wf4(:,1),wf4(:,3))
  call Hloop_AV_Q(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,769),heltab2x64(:,:,1024))
  call Hloop_A_Q(ntryL,G0H32(1),32,0,G1H32(183),n2h32(367))
  Gcoeff(:)%j = (c(22)*(M(4,:)%j-M(14,:)%j)+c(21)*(-M(48,:)%j+M(49,:)%j)) * den(5)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(1439),h0tab(:,1439),[32,8,3,20],[nMB,nMB,nMB,nMB],4,2,wf4(:,1),wf4(:,3))
  call Hloop_AV_Q(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,770),heltab2x64(:,:,1025))
  call Hloop_A_Q(ntryL,G0H32(1),32,nMB,G1H32(184),n2h32(368))
  Gcoeff(:)%j = (c(9)*(M(4,:)%j+M(11,:)%j-M(12,:)%j-M(14,:)%j)+c(7)*(M(33,:)%j-M(34,:)%j-M(37,:)%j+M(39,:)%j+M(40,:)%j-M(42,:)%j) &
    +c(6)*(M(46,:)%j-M(47,:)%j-M(48,:)%j+M(49,:)%j)) * den(5)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(1440),h0tab(:,1440),[32,8,3,20],[0,0,0,0],4,2,wf4(:,1),wf4(:,3))
  call Hloop_CV_D(ntryL,G0H64(1),0,ex6(:),32,G1H32(185),m3h2x32(:,771),heltab2x64(:,:,1026))
  Gcoeff(:)%j = (c(9)*(M(4,:)%j+M(11,:)%j-M(12,:)%j-M(14,:)%j)+c(7)*(M(33,:)%j-M(34,:)%j-M(37,:)%j+M(39,:)%j+M(40,:)%j-M(42,:)%j) &
    +c(6)*(M(46,:)%j-M(47,:)%j-M(48,:)%j+M(49,:)%j)) * den(5)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(1441),h0tab(:,1441),[32,8,3,20],[0,0,0,0],4,2,wf4(:,1),wf4(:,3))
  call Hloop_DV_C(ntryL,G0H64(1),0,ex6(:),G1H32(190),m3h2x32(:,772),heltab2x64(:,:,1027))
  Gcoeff(:)%j = (c(9)*(-M(4,:)%j-M(11,:)%j+M(12,:)%j+M(14,:)%j)+c(7)*(-M(33,:)%j+M(34,:)%j+M(37,:)%j-M(39,:)%j-M(40,:)%j &
    +M(42,:)%j)+c(6)*(-M(46,:)%j+M(47,:)%j+M(48,:)%j-M(49,:)%j)) * den(5)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(1442),h0tab(:,1442),[32,8,3,20],[0,0,0,0],4,2,wf4(:,1),wf4(:,3))
  call Hloop_UV_W(ntryL,G0H64(1),0,ex6(:),32,G1H32(187),m3h2x32(:,773),heltab2x64(:,:,1028))
  Gcoeff(:)%j = (c(24)*(M(3,:)%j-M(13,:)%j)+c(23)*(M(46,:)%j-M(47,:)%j)) * den(5)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(1443),h0tab(:,1443),[32,3,20,8],[0,0,0,0],4,2,wf4(:,1),wf4(:,3))
  call Hloop_AV_Q(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,774),heltab2x64(:,:,1029))
  call Hloop_A_Q(ntryL,G0H32(1),32,0,G1H32(192),n2h32(369))
  Gcoeff(:)%j = (c(22)*(M(3,:)%j-M(13,:)%j)+c(21)*(M(46,:)%j-M(47,:)%j)) * den(5)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(1444),h0tab(:,1444),[32,3,20,8],[nMT,nMT,nMT,nMT],4,2,wf4(:,1),wf4(:,3))
  call Hloop_AV_Q(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,775),heltab2x64(:,:,1030))
  call Hloop_A_Q(ntryL,G0H32(1),32,nMT,G1H32(189),n2h32(370))
  Gcoeff(:)%j = (c(24)*(M(21,:)%j-M(22,:)%j)+c(23)*(-M(48,:)%j+M(49,:)%j)) * den(5)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(1445),h0tab(:,1445),[32,3,20,8],[0,0,0,0],4,2,wf4(:,1),wf4(:,3))
  call Hloop_QV_A(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,776),heltab2x64(:,:,1031))
  call Hloop_Q_A(ntryL,G0H32(1),32,0,G1H32(191),n2h32(371))
  Gcoeff(:)%j = (c(22)*(M(21,:)%j-M(22,:)%j)+c(21)*(-M(48,:)%j+M(49,:)%j)) * den(5)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(1446),h0tab(:,1446),[32,3,20,8],[nMT,nMT,nMT,nMT],4,2,wf4(:,1),wf4(:,3))
  call Hloop_QV_A(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,777),heltab2x64(:,:,1032))
  call Hloop_Q_A(ntryL,G0H32(1),32,nMT,G1H32(193),n2h32(372))
  Gcoeff(:)%j = (c(24)*(M(3,:)%j-M(13,:)%j)+c(23)*(M(46,:)%j-M(47,:)%j)) * den(5)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(1447),h0tab(:,1447),[32,3,20,8],[0,0,0,0],4,2,wf4(:,1),wf4(:,3))
  call Hloop_AV_Q(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,778),heltab2x64(:,:,1033))
  call Hloop_A_Q(ntryL,G0H32(1),32,0,G1H32(194),n2h32(373))
  Gcoeff(:)%j = (c(22)*(M(3,:)%j-M(13,:)%j)+c(21)*(M(46,:)%j-M(47,:)%j)) * den(5)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(1448),h0tab(:,1448),[32,3,20,8],[nMB,nMB,nMB,nMB],4,2,wf4(:,1),wf4(:,3))
  call Hloop_AV_Q(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,779),heltab2x64(:,:,1034))
  call Hloop_A_Q(ntryL,G0H32(1),32,nMB,G1H32(195),n2h32(374))
  Gcoeff(:)%j = (c(24)*(M(21,:)%j-M(22,:)%j)+c(23)*(-M(48,:)%j+M(49,:)%j)) * den(5)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(1449),h0tab(:,1449),[32,3,20,8],[0,0,0,0],4,2,wf4(:,1),wf4(:,3))
  call Hloop_QV_A(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,780),heltab2x64(:,:,1035))
  call Hloop_Q_A(ntryL,G0H32(1),32,0,G1H32(196),n2h32(375))
  Gcoeff(:)%j = (c(22)*(M(21,:)%j-M(22,:)%j)+c(21)*(-M(48,:)%j+M(49,:)%j)) * den(5)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(1450),h0tab(:,1450),[32,3,20,8],[nMB,nMB,nMB,nMB],4,2,wf4(:,1),wf4(:,3))
  call Hloop_QV_A(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,781),heltab2x64(:,:,1036))
  call Hloop_Q_A(ntryL,G0H32(1),32,nMB,G1H32(201),n2h32(376))
  Gcoeff(:)%j = (c(9)*(M(3,:)%j-M(13,:)%j+M(21,:)%j-M(22,:)%j)+c(7)*(M(33,:)%j-M(34,:)%j-M(37,:)%j+M(39,:)%j+M(40,:)%j-M(42,:)%j) &
    +c(6)*(M(46,:)%j-M(47,:)%j-M(48,:)%j+M(49,:)%j)) * den(5)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(1451),h0tab(:,1451),[32,3,20,8],[0,0,0,0],4,2,wf4(:,1),wf4(:,3))
  call Hloop_DV_C(ntryL,G0H64(1),0,ex6(:),G1H32(198),m3h2x32(:,782),heltab2x64(:,:,1037))
  Gcoeff(:)%j = (c(9)*(M(3,:)%j-M(13,:)%j+M(21,:)%j-M(22,:)%j)+c(7)*(M(33,:)%j-M(34,:)%j-M(37,:)%j+M(39,:)%j+M(40,:)%j-M(42,:)%j) &
    +c(6)*(M(46,:)%j-M(47,:)%j-M(48,:)%j+M(49,:)%j)) * den(5)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(1452),h0tab(:,1452),[32,3,20,8],[0,0,0,0],4,2,wf4(:,1),wf4(:,3))
  call Hloop_CV_D(ntryL,G0H64(1),0,ex6(:),32,G1H32(203),m3h2x32(:,783),heltab2x64(:,:,1038))
  Gcoeff(:)%j = (c(9)*(-M(3,:)%j+M(13,:)%j-M(21,:)%j+M(22,:)%j)+c(7)*(-M(33,:)%j+M(34,:)%j+M(37,:)%j-M(39,:)%j-M(40,:)%j &
    +M(42,:)%j)+c(6)*(-M(46,:)%j+M(47,:)%j+M(48,:)%j-M(49,:)%j)) * den(5)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(1453),h0tab(:,1453),[32,3,20,8],[0,0,0,0],4,2,wf4(:,1),wf4(:,3))
  call Hloop_UV_W(ntryL,G0H64(1),0,ex6(:),32,G1H32(200),m3h2x32(:,784),heltab2x64(:,:,1039))
  Gcoeff(:)%j = (c(24)*(M(20,:)%j-M(23,:)%j)+c(23)*(M(46,:)%j-M(47,:)%j)) * den(5)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(1454),h0tab(:,1454),[32,3,8,20],[0,0,0,0],4,2,wf4(:,1),wf4(:,3))
  call Hloop_QV_A(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,785),heltab2x64(:,:,1040))
  call Hloop_Q_A(ntryL,G0H32(1),32,0,G1H32(202),n2h32(377))
  Gcoeff(:)%j = (c(22)*(M(20,:)%j-M(23,:)%j)+c(21)*(M(46,:)%j-M(47,:)%j)) * den(5)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(1455),h0tab(:,1455),[32,3,8,20],[nMT,nMT,nMT,nMT],4,2,wf4(:,1),wf4(:,3))
  call Hloop_QV_A(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,786),heltab2x64(:,:,1041))
  call Hloop_Q_A(ntryL,G0H32(1),32,nMT,G1H32(204),n2h32(378))
  Gcoeff(:)%j = (c(24)*(M(7,:)%j-M(9,:)%j)+c(23)*(-M(48,:)%j+M(49,:)%j)) * den(5)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(1456),h0tab(:,1456),[32,3,8,20],[0,0,0,0],4,2,wf4(:,1),wf4(:,3))
  call Hloop_AV_Q(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,787),heltab2x64(:,:,1042))
  call Hloop_A_Q(ntryL,G0H32(1),32,0,G1H32(205),n2h32(379))
  Gcoeff(:)%j = (c(22)*(M(7,:)%j-M(9,:)%j)+c(21)*(-M(48,:)%j+M(49,:)%j)) * den(5)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(1457),h0tab(:,1457),[32,3,8,20],[nMT,nMT,nMT,nMT],4,2,wf4(:,1),wf4(:,3))
  call Hloop_AV_Q(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,788),heltab2x64(:,:,1043))
  call Hloop_A_Q(ntryL,G0H32(1),32,nMT,G1H32(206),n2h32(380))
  Gcoeff(:)%j = (c(24)*(M(20,:)%j-M(23,:)%j)+c(23)*(M(46,:)%j-M(47,:)%j)) * den(5)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(1458),h0tab(:,1458),[32,3,8,20],[0,0,0,0],4,2,wf4(:,1),wf4(:,3))
  call Hloop_QV_A(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,789),heltab2x64(:,:,1044))
  call Hloop_Q_A(ntryL,G0H32(1),32,0,G1H32(207),n2h32(381))
  Gcoeff(:)%j = (c(22)*(M(20,:)%j-M(23,:)%j)+c(21)*(M(46,:)%j-M(47,:)%j)) * den(5)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(1459),h0tab(:,1459),[32,3,8,20],[nMB,nMB,nMB,nMB],4,2,wf4(:,1),wf4(:,3))
  call Hloop_QV_A(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,790),heltab2x64(:,:,1045))
  call Hloop_Q_A(ntryL,G0H32(1),32,nMB,G1H32(212),n2h32(382))
  Gcoeff(:)%j = (c(24)*(M(7,:)%j-M(9,:)%j)+c(23)*(-M(48,:)%j+M(49,:)%j)) * den(5)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(1460),h0tab(:,1460),[32,3,8,20],[0,0,0,0],4,2,wf4(:,1),wf4(:,3))
  call Hloop_AV_Q(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,791),heltab2x64(:,:,1046))
  call Hloop_A_Q(ntryL,G0H32(1),32,0,G1H32(209),n2h32(383))
  Gcoeff(:)%j = (c(22)*(M(7,:)%j-M(9,:)%j)+c(21)*(-M(48,:)%j+M(49,:)%j)) * den(5)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(1461),h0tab(:,1461),[32,3,8,20],[nMB,nMB,nMB,nMB],4,2,wf4(:,1),wf4(:,3))
  call Hloop_AV_Q(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,792),heltab2x64(:,:,1047))
  call Hloop_A_Q(ntryL,G0H32(1),32,nMB,G1H32(214),n2h32(384))
  Gcoeff(:)%j = (c(9)*(M(7,:)%j-M(9,:)%j+M(20,:)%j-M(23,:)%j)+c(7)*(M(33,:)%j-M(34,:)%j-M(37,:)%j+M(39,:)%j+M(40,:)%j-M(42,:)%j) &
    +c(6)*(M(46,:)%j-M(47,:)%j-M(48,:)%j+M(49,:)%j)) * den(5)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(1462),h0tab(:,1462),[32,3,8,20],[0,0,0,0],4,2,wf4(:,1),wf4(:,3))
  call Hloop_CV_D(ntryL,G0H64(1),0,ex6(:),32,G1H32(211),m3h2x32(:,793),heltab2x64(:,:,1048))
  Gcoeff(:)%j = (c(9)*(M(7,:)%j-M(9,:)%j+M(20,:)%j-M(23,:)%j)+c(7)*(M(33,:)%j-M(34,:)%j-M(37,:)%j+M(39,:)%j+M(40,:)%j-M(42,:)%j) &
    +c(6)*(M(46,:)%j-M(47,:)%j-M(48,:)%j+M(49,:)%j)) * den(5)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(1463),h0tab(:,1463),[32,3,8,20],[0,0,0,0],4,2,wf4(:,1),wf4(:,3))
  call Hloop_DV_C(ntryL,G0H64(1),0,ex6(:),G1H32(213),m3h2x32(:,794),heltab2x64(:,:,1049))
  Gcoeff(:)%j = (c(9)*(-M(7,:)%j+M(9,:)%j-M(20,:)%j+M(23,:)%j)+c(7)*(-M(33,:)%j+M(34,:)%j+M(37,:)%j-M(39,:)%j-M(40,:)%j+M(42,:)%j) &
    +c(6)*(-M(46,:)%j+M(47,:)%j+M(48,:)%j-M(49,:)%j)) * den(5)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(1464),h0tab(:,1464),[32,3,8,20],[0,0,0,0],4,2,wf4(:,1),wf4(:,3))
  call Hloop_UV_W(ntryL,G0H64(1),0,ex6(:),32,G1H32(215),m3h2x32(:,795),heltab2x64(:,:,1050))
  Gcoeff(:)%j = (c(24)*(M(5,:)%j-M(6,:)%j)+c(23)*(-M(49,:)%j+M(50,:)%j)) * den(11)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(1465),h0tab(:,1465),[32,4,3,24],[0,0,0,0],4,2,wf4(:,1),wf4(:,5))
  call Hloop_QV_A(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,796),heltab2x64(:,:,1051))
  call Hloop_Q_A(ntryL,G0H32(1),32,0,G1H32(216),n2h32(385))
  Gcoeff(:)%j = (c(22)*(M(5,:)%j-M(6,:)%j)+c(21)*(-M(49,:)%j+M(50,:)%j)) * den(11)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(1466),h0tab(:,1466),[32,4,3,24],[nMT,nMT,nMT,nMT],4,2,wf4(:,1),wf4(:,5))
  call Hloop_QV_A(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,797),heltab2x64(:,:,1052))
  call Hloop_Q_A(ntryL,G0H32(1),32,nMT,G1H32(217),n2h32(386))
  Gcoeff(:)%j = (c(24)*(M(10,:)%j-M(16,:)%j)+c(23)*(-M(45,:)%j+M(47,:)%j)) * den(11)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(1467),h0tab(:,1467),[32,4,3,24],[0,0,0,0],4,2,wf4(:,1),wf4(:,5))
  call Hloop_AV_Q(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,798),heltab2x64(:,:,1053))
  call Hloop_A_Q(ntryL,G0H32(1),32,0,G1H32(218),n2h32(387))
  Gcoeff(:)%j = (c(22)*(M(10,:)%j-M(16,:)%j)+c(21)*(-M(45,:)%j+M(47,:)%j)) * den(11)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(1468),h0tab(:,1468),[32,4,3,24],[nMT,nMT,nMT,nMT],4,2,wf4(:,1),wf4(:,5))
  call Hloop_AV_Q(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,799),heltab2x64(:,:,1054))
  call Hloop_A_Q(ntryL,G0H32(1),32,nMT,G1H32(223),n2h32(388))
  Gcoeff(:)%j = (c(24)*(M(5,:)%j-M(6,:)%j)+c(23)*(-M(49,:)%j+M(50,:)%j)) * den(11)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(1469),h0tab(:,1469),[32,4,3,24],[0,0,0,0],4,2,wf4(:,1),wf4(:,5))
  call Hloop_QV_A(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,800),heltab2x64(:,:,1055))
  call Hloop_Q_A(ntryL,G0H32(1),32,0,G1H32(220),n2h32(389))
  Gcoeff(:)%j = (c(22)*(M(5,:)%j-M(6,:)%j)+c(21)*(-M(49,:)%j+M(50,:)%j)) * den(11)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(1470),h0tab(:,1470),[32,4,3,24],[nMB,nMB,nMB,nMB],4,2,wf4(:,1),wf4(:,5))
  call Hloop_QV_A(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,801),heltab2x64(:,:,1056))
  call Hloop_Q_A(ntryL,G0H32(1),32,nMB,G1H32(225),n2h32(390))
  Gcoeff(:)%j = (c(24)*(M(10,:)%j-M(16,:)%j)+c(23)*(-M(45,:)%j+M(47,:)%j)) * den(11)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(1471),h0tab(:,1471),[32,4,3,24],[0,0,0,0],4,2,wf4(:,1),wf4(:,5))
  call Hloop_AV_Q(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,802),heltab2x64(:,:,1057))
  call Hloop_A_Q(ntryL,G0H32(1),32,0,G1H32(222),n2h32(391))
  Gcoeff(:)%j = (c(22)*(M(10,:)%j-M(16,:)%j)+c(21)*(-M(45,:)%j+M(47,:)%j)) * den(11)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(1472),h0tab(:,1472),[32,4,3,24],[nMB,nMB,nMB,nMB],4,2,wf4(:,1),wf4(:,5))
  call Hloop_AV_Q(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,803),heltab2x64(:,:,1058))
  call Hloop_A_Q(ntryL,G0H32(1),32,nMB,G1H32(224),n2h32(392))
  Gcoeff(:)%j = (c(9)*(M(5,:)%j-M(6,:)%j+M(10,:)%j-M(16,:)%j)+c(7)*(M(29,:)%j-M(30,:)%j+M(37,:)%j-M(39,:)%j+M(43,:)%j-M(44,:)%j) &
    +c(6)*(-M(45,:)%j+M(47,:)%j-M(49,:)%j+M(50,:)%j)) * den(11)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(1473),h0tab(:,1473),[32,4,3,24],[0,0,0,0],4,2,wf4(:,1),wf4(:,5))
  call Hloop_CV_D(ntryL,G0H64(1),0,ex6(:),32,G1H32(226),m3h2x32(:,804),heltab2x64(:,:,1059))
  Gcoeff(:)%j = (c(9)*(M(5,:)%j-M(6,:)%j+M(10,:)%j-M(16,:)%j)+c(7)*(M(29,:)%j-M(30,:)%j+M(37,:)%j-M(39,:)%j+M(43,:)%j-M(44,:)%j) &
    +c(6)*(-M(45,:)%j+M(47,:)%j-M(49,:)%j+M(50,:)%j)) * den(11)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(1474),h0tab(:,1474),[32,4,3,24],[0,0,0,0],4,2,wf4(:,1),wf4(:,5))
  call Hloop_DV_C(ntryL,G0H64(1),0,ex6(:),G1H32(227),m3h2x32(:,805),heltab2x64(:,:,1060))
  Gcoeff(:)%j = (c(9)*(-M(5,:)%j+M(6,:)%j-M(10,:)%j+M(16,:)%j)+c(7)*(-M(29,:)%j+M(30,:)%j-M(37,:)%j+M(39,:)%j-M(43,:)%j+M(44,:)%j) &
    +c(6)*(M(45,:)%j-M(47,:)%j+M(49,:)%j-M(50,:)%j)) * den(11)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(1475),h0tab(:,1475),[32,4,3,24],[0,0,0,0],4,2,wf4(:,1),wf4(:,5))
  call Hloop_UV_W(ntryL,G0H64(1),0,ex6(:),32,G1H32(228),m3h2x32(:,806),heltab2x64(:,:,1061))
  Gcoeff(:)%j = (c(24)*(M(9,:)%j-M(15,:)%j)+c(23)*(-M(49,:)%j+M(50,:)%j)) * den(11)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(1476),h0tab(:,1476),[32,3,24,4],[0,0,0,0],4,2,wf4(:,1),wf4(:,5))
  call Hloop_AV_Q(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,807),heltab2x64(:,:,1062))
  call Hloop_A_Q(ntryL,G0H32(1),32,0,G1H32(229),n2h32(393))
  Gcoeff(:)%j = (c(22)*(M(9,:)%j-M(15,:)%j)+c(21)*(-M(49,:)%j+M(50,:)%j)) * den(11)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(1477),h0tab(:,1477),[32,3,24,4],[nMT,nMT,nMT,nMT],4,2,wf4(:,1),wf4(:,5))
  call Hloop_AV_Q(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,808),heltab2x64(:,:,1063))
  call Hloop_A_Q(ntryL,G0H32(1),32,nMT,G1H32(234),n2h32(394))
  Gcoeff(:)%j = (c(24)*(M(19,:)%j-M(20,:)%j)+c(23)*(-M(45,:)%j+M(47,:)%j)) * den(11)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(1478),h0tab(:,1478),[32,3,24,4],[0,0,0,0],4,2,wf4(:,1),wf4(:,5))
  call Hloop_QV_A(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,809),heltab2x64(:,:,1064))
  call Hloop_Q_A(ntryL,G0H32(1),32,0,G1H32(231),n2h32(395))
  Gcoeff(:)%j = (c(22)*(M(19,:)%j-M(20,:)%j)+c(21)*(-M(45,:)%j+M(47,:)%j)) * den(11)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(1479),h0tab(:,1479),[32,3,24,4],[nMT,nMT,nMT,nMT],4,2,wf4(:,1),wf4(:,5))
  call Hloop_QV_A(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,810),heltab2x64(:,:,1065))
  call Hloop_Q_A(ntryL,G0H32(1),32,nMT,G1H32(236),n2h32(396))
  Gcoeff(:)%j = (c(24)*(M(9,:)%j-M(15,:)%j)+c(23)*(-M(49,:)%j+M(50,:)%j)) * den(11)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(1480),h0tab(:,1480),[32,3,24,4],[0,0,0,0],4,2,wf4(:,1),wf4(:,5))
  call Hloop_AV_Q(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,811),heltab2x64(:,:,1066))
  call Hloop_A_Q(ntryL,G0H32(1),32,0,G1H32(233),n2h32(397))
  Gcoeff(:)%j = (c(22)*(M(9,:)%j-M(15,:)%j)+c(21)*(-M(49,:)%j+M(50,:)%j)) * den(11)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(1481),h0tab(:,1481),[32,3,24,4],[nMB,nMB,nMB,nMB],4,2,wf4(:,1),wf4(:,5))
  call Hloop_AV_Q(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,812),heltab2x64(:,:,1067))
  call Hloop_A_Q(ntryL,G0H32(1),32,nMB,G1H32(235),n2h32(398))
  Gcoeff(:)%j = (c(24)*(M(19,:)%j-M(20,:)%j)+c(23)*(-M(45,:)%j+M(47,:)%j)) * den(11)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(1482),h0tab(:,1482),[32,3,24,4],[0,0,0,0],4,2,wf4(:,1),wf4(:,5))
  call Hloop_QV_A(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,813),heltab2x64(:,:,1068))
  call Hloop_Q_A(ntryL,G0H32(1),32,0,G1H32(237),n2h32(399))
  Gcoeff(:)%j = (c(22)*(M(19,:)%j-M(20,:)%j)+c(21)*(-M(45,:)%j+M(47,:)%j)) * den(11)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(1483),h0tab(:,1483),[32,3,24,4],[nMB,nMB,nMB,nMB],4,2,wf4(:,1),wf4(:,5))
  call Hloop_QV_A(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,814),heltab2x64(:,:,1069))
  call Hloop_Q_A(ntryL,G0H32(1),32,nMB,G1H32(238),n2h32(400))
  Gcoeff(:)%j = (c(9)*(M(9,:)%j-M(15,:)%j+M(19,:)%j-M(20,:)%j)+c(7)*(M(29,:)%j-M(30,:)%j+M(37,:)%j-M(39,:)%j+M(43,:)%j-M(44,:)%j) &
    +c(6)*(-M(45,:)%j+M(47,:)%j-M(49,:)%j+M(50,:)%j)) * den(11)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(1484),h0tab(:,1484),[32,3,24,4],[0,0,0,0],4,2,wf4(:,1),wf4(:,5))
  call Hloop_DV_C(ntryL,G0H64(1),0,ex6(:),G1H32(239),m3h2x32(:,815),heltab2x64(:,:,1070))
  Gcoeff(:)%j = (c(9)*(M(9,:)%j-M(15,:)%j+M(19,:)%j-M(20,:)%j)+c(7)*(M(29,:)%j-M(30,:)%j+M(37,:)%j-M(39,:)%j+M(43,:)%j-M(44,:)%j) &
    +c(6)*(-M(45,:)%j+M(47,:)%j-M(49,:)%j+M(50,:)%j)) * den(11)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(1485),h0tab(:,1485),[32,3,24,4],[0,0,0,0],4,2,wf4(:,1),wf4(:,5))
  call Hloop_CV_D(ntryL,G0H64(1),0,ex6(:),32,G1H32(240),m3h2x32(:,816),heltab2x64(:,:,1071))
  Gcoeff(:)%j = (c(9)*(-M(9,:)%j+M(15,:)%j-M(19,:)%j+M(20,:)%j)+c(7)*(-M(29,:)%j+M(30,:)%j-M(37,:)%j+M(39,:)%j-M(43,:)%j &
    +M(44,:)%j)+c(6)*(M(45,:)%j-M(47,:)%j+M(49,:)%j-M(50,:)%j)) * den(11)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(1486),h0tab(:,1486),[32,3,24,4],[0,0,0,0],4,2,wf4(:,1),wf4(:,5))
  call Hloop_UV_W(ntryL,G0H64(1),0,ex6(:),32,G1H32(241),m3h2x32(:,817),heltab2x64(:,:,1072))
  Gcoeff(:)%j = (c(24)*(M(22,:)%j-M(24,:)%j)+c(23)*(-M(49,:)%j+M(50,:)%j)) * den(11)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(1487),h0tab(:,1487),[32,3,4,24],[0,0,0,0],4,2,wf4(:,1),wf4(:,5))
  call Hloop_QV_A(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,818),heltab2x64(:,:,1073))
  call Hloop_Q_A(ntryL,G0H32(1),32,0,G1H32(242),n2h32(401))
  Gcoeff(:)%j = (c(22)*(M(22,:)%j-M(24,:)%j)+c(21)*(-M(49,:)%j+M(50,:)%j)) * den(11)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(1488),h0tab(:,1488),[32,3,4,24],[nMT,nMT,nMT,nMT],4,2,wf4(:,1),wf4(:,5))
  call Hloop_QV_A(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,819),heltab2x64(:,:,1074))
  call Hloop_Q_A(ntryL,G0H32(1),32,nMT,G1H32(243),n2h32(402))
  Gcoeff(:)%j = (c(24)*(M(1,:)%j-M(3,:)%j)+c(23)*(-M(45,:)%j+M(47,:)%j)) * den(11)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(1489),h0tab(:,1489),[32,3,4,24],[0,0,0,0],4,2,wf4(:,1),wf4(:,5))
  call Hloop_AV_Q(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,820),heltab2x64(:,:,1075))
  call Hloop_A_Q(ntryL,G0H32(1),32,0,G1H32(244),n2h32(403))
  Gcoeff(:)%j = (c(22)*(M(1,:)%j-M(3,:)%j)+c(21)*(-M(45,:)%j+M(47,:)%j)) * den(11)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(1490),h0tab(:,1490),[32,3,4,24],[nMT,nMT,nMT,nMT],4,2,wf4(:,1),wf4(:,5))
  call Hloop_AV_Q(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,821),heltab2x64(:,:,1076))
  call Hloop_A_Q(ntryL,G0H32(1),32,nMT,G1H32(245),n2h32(404))
  Gcoeff(:)%j = (c(24)*(M(22,:)%j-M(24,:)%j)+c(23)*(-M(49,:)%j+M(50,:)%j)) * den(11)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(1491),h0tab(:,1491),[32,3,4,24],[0,0,0,0],4,2,wf4(:,1),wf4(:,5))
  call Hloop_QV_A(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,822),heltab2x64(:,:,1077))
  call Hloop_Q_A(ntryL,G0H32(1),32,0,G1H32(246),n2h32(405))
  Gcoeff(:)%j = (c(22)*(M(22,:)%j-M(24,:)%j)+c(21)*(-M(49,:)%j+M(50,:)%j)) * den(11)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(1492),h0tab(:,1492),[32,3,4,24],[nMB,nMB,nMB,nMB],4,2,wf4(:,1),wf4(:,5))
  call Hloop_QV_A(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,823),heltab2x64(:,:,1078))
  call Hloop_Q_A(ntryL,G0H32(1),32,nMB,G1H32(247),n2h32(406))
  Gcoeff(:)%j = (c(24)*(M(1,:)%j-M(3,:)%j)+c(23)*(-M(45,:)%j+M(47,:)%j)) * den(11)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(1493),h0tab(:,1493),[32,3,4,24],[0,0,0,0],4,2,wf4(:,1),wf4(:,5))
  call Hloop_AV_Q(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,824),heltab2x64(:,:,1079))
  call Hloop_A_Q(ntryL,G0H32(1),32,0,G1H32(248),n2h32(407))
  Gcoeff(:)%j = (c(22)*(M(1,:)%j-M(3,:)%j)+c(21)*(-M(45,:)%j+M(47,:)%j)) * den(11)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(1494),h0tab(:,1494),[32,3,4,24],[nMB,nMB,nMB,nMB],4,2,wf4(:,1),wf4(:,5))
  call Hloop_AV_Q(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,825),heltab2x64(:,:,1080))
  call Hloop_A_Q(ntryL,G0H32(1),32,nMB,G1H32(249),n2h32(408))
  Gcoeff(:)%j = (c(9)*(M(1,:)%j-M(3,:)%j+M(22,:)%j-M(24,:)%j)+c(7)*(M(29,:)%j-M(30,:)%j+M(37,:)%j-M(39,:)%j+M(43,:)%j-M(44,:)%j) &
    +c(6)*(-M(45,:)%j+M(47,:)%j-M(49,:)%j+M(50,:)%j)) * den(11)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(1495),h0tab(:,1495),[32,3,4,24],[0,0,0,0],4,2,wf4(:,1),wf4(:,5))
  call Hloop_CV_D(ntryL,G0H64(1),0,ex6(:),32,G1H32(250),m3h2x32(:,826),heltab2x64(:,:,1081))
  Gcoeff(:)%j = (c(9)*(M(1,:)%j-M(3,:)%j+M(22,:)%j-M(24,:)%j)+c(7)*(M(29,:)%j-M(30,:)%j+M(37,:)%j-M(39,:)%j+M(43,:)%j-M(44,:)%j) &
    +c(6)*(-M(45,:)%j+M(47,:)%j-M(49,:)%j+M(50,:)%j)) * den(11)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(1496),h0tab(:,1496),[32,3,4,24],[0,0,0,0],4,2,wf4(:,1),wf4(:,5))
  call Hloop_DV_C(ntryL,G0H64(1),0,ex6(:),G1H32(251),m3h2x32(:,827),heltab2x64(:,:,1082))
  Gcoeff(:)%j = (c(9)*(-M(1,:)%j+M(3,:)%j-M(22,:)%j+M(24,:)%j)+c(7)*(-M(29,:)%j+M(30,:)%j-M(37,:)%j+M(39,:)%j-M(43,:)%j+M(44,:)%j) &
    +c(6)*(M(45,:)%j-M(47,:)%j+M(49,:)%j-M(50,:)%j)) * den(11)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(1497),h0tab(:,1497),[32,3,4,24],[0,0,0,0],4,2,wf4(:,1),wf4(:,5))
  call Hloop_UV_W(ntryL,G0H64(1),0,ex6(:),32,G1H32(252),m3h2x32(:,828),heltab2x64(:,:,1083))
  Gcoeff(:)%j = (c(24)*(M(9,:)%j-M(10,:)%j)+c(23)*(M(45,:)%j-M(49,:)%j)) * den(7)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(1498),h0tab(:,1498),[36,3,8,16],[0,0,0,0],4,2,wf4(:,4),wf4(:,1))
  call Hloop_AV_Q(ntryL,G0H64(1),wf4(:,4),G0H16(223),m3h4x16(:,202),heltab2x64(:,:,1084))
  call Hloop_A_Q(ntryL,G0H16(223),36,0,G1H16(34),n2h16(576))
  Gcoeff(:)%j = (c(22)*(M(9,:)%j-M(10,:)%j)+c(21)*(M(45,:)%j-M(49,:)%j)) * den(7)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(1499),h0tab(:,1499),[36,3,8,16],[nMT,nMT,nMT,nMT],4,2,wf4(:,4),wf4(:,1))
  call Hloop_AV_Q(ntryL,G0H64(1),wf4(:,4),G0H16(223),m3h4x16(:,203),heltab2x64(:,:,1085))
  call Hloop_A_Q(ntryL,G0H16(223),36,nMT,G1H16(287),n2h16(577))
  Gcoeff(:)%j = (c(24)*(M(6,:)%j-M(20,:)%j)+c(23)*(M(47,:)%j-M(50,:)%j)) * den(7)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(1500),h0tab(:,1500),[36,3,8,16],[0,0,0,0],4,2,wf4(:,4),wf4(:,1))
  call Hloop_QV_A(ntryL,G0H64(1),wf4(:,4),G0H16(223),m3h4x16(:,204),heltab2x64(:,:,1086))
  call Hloop_Q_A(ntryL,G0H16(223),36,0,G1H16(290),n2h16(578))
  Gcoeff(:)%j = (c(22)*(M(6,:)%j-M(20,:)%j)+c(21)*(M(47,:)%j-M(50,:)%j)) * den(7)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(1501),h0tab(:,1501),[36,3,8,16],[nMT,nMT,nMT,nMT],4,2,wf4(:,4),wf4(:,1))
  call Hloop_QV_A(ntryL,G0H64(1),wf4(:,4),G0H16(223),m3h4x16(:,205),heltab2x64(:,:,1087))
  call Hloop_Q_A(ntryL,G0H16(223),36,nMT,G1H16(294),n2h16(579))
  Gcoeff(:)%j = (c(24)*(M(9,:)%j-M(10,:)%j)+c(23)*(M(45,:)%j-M(49,:)%j)) * den(7)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(1502),h0tab(:,1502),[36,3,8,16],[0,0,0,0],4,2,wf4(:,4),wf4(:,1))
  call Hloop_AV_Q(ntryL,G0H64(1),wf4(:,4),G0H16(223),m3h4x16(:,206),heltab2x64(:,:,1088))
  call Hloop_A_Q(ntryL,G0H16(223),36,0,G1H16(295),n2h16(580))
  Gcoeff(:)%j = (c(22)*(M(9,:)%j-M(10,:)%j)+c(21)*(M(45,:)%j-M(49,:)%j)) * den(7)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(1503),h0tab(:,1503),[36,3,8,16],[nMB,nMB,nMB,nMB],4,2,wf4(:,4),wf4(:,1))
  call Hloop_AV_Q(ntryL,G0H64(1),wf4(:,4),G0H16(223),m3h4x16(:,207),heltab2x64(:,:,1089))
  call Hloop_A_Q(ntryL,G0H16(223),36,nMB,G1H16(36),n2h16(581))
  Gcoeff(:)%j = (c(24)*(M(6,:)%j-M(20,:)%j)+c(23)*(M(47,:)%j-M(50,:)%j)) * den(7)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(1504),h0tab(:,1504),[36,3,8,16],[0,0,0,0],4,2,wf4(:,4),wf4(:,1))
  call Hloop_QV_A(ntryL,G0H64(1),wf4(:,4),G0H16(223),m3h4x16(:,208),heltab2x64(:,:,1090))
  call Hloop_Q_A(ntryL,G0H16(223),36,0,G1H16(299),n2h16(582))
  Gcoeff(:)%j = (c(22)*(M(6,:)%j-M(20,:)%j)+c(21)*(M(47,:)%j-M(50,:)%j)) * den(7)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(1505),h0tab(:,1505),[36,3,8,16],[nMB,nMB,nMB,nMB],4,2,wf4(:,4),wf4(:,1))
  call Hloop_QV_A(ntryL,G0H64(1),wf4(:,4),G0H16(223),m3h4x16(:,209),heltab2x64(:,:,1091))
  call Hloop_Q_A(ntryL,G0H16(223),36,nMB,G1H16(301),n2h16(583))
  Gcoeff(:)%j = (c(9)*(M(6,:)%j+M(9,:)%j-M(10,:)%j-M(20,:)%j)+c(7)*(M(31,:)%j-M(32,:)%j-M(38,:)%j-M(40,:)%j+M(41,:)%j+M(42,:)%j) &
    +c(6)*(M(45,:)%j+M(47,:)%j-M(49,:)%j-M(50,:)%j)) * den(7)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(1506),h0tab(:,1506),[36,3,8,16],[0,0,0,0],4,2,wf4(:,4),wf4(:,1))
  call Hloop_DV_C(ntryL,G0H64(1),0,wf4(:,4),G1H16(304),m3h4x16(:,210),heltab2x64(:,:,1092))
  Gcoeff(:)%j = (c(9)*(M(6,:)%j+M(9,:)%j-M(10,:)%j-M(20,:)%j)+c(7)*(M(31,:)%j-M(32,:)%j-M(38,:)%j-M(40,:)%j+M(41,:)%j+M(42,:)%j) &
    +c(6)*(M(45,:)%j+M(47,:)%j-M(49,:)%j-M(50,:)%j)) * den(7)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(1507),h0tab(:,1507),[36,3,8,16],[0,0,0,0],4,2,wf4(:,4),wf4(:,1))
  call Hloop_CV_D(ntryL,G0H64(1),0,wf4(:,4),36,G1H16(305),m3h4x16(:,211),heltab2x64(:,:,1093))
  Gcoeff(:)%j = (c(9)*(-M(6,:)%j-M(9,:)%j+M(10,:)%j+M(20,:)%j)+c(7)*(-M(31,:)%j+M(32,:)%j+M(38,:)%j+M(40,:)%j-M(41,:)%j-M(42,:)%j) &
    +c(6)*(-M(45,:)%j-M(47,:)%j+M(49,:)%j+M(50,:)%j)) * den(7)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(1508),h0tab(:,1508),[36,3,8,16],[0,0,0,0],4,2,wf4(:,4),wf4(:,1))
  call Hloop_UV_W(ntryL,G0H64(1),0,wf4(:,4),36,G1H16(38),m3h4x16(:,212),heltab2x64(:,:,1094))
  Gcoeff(:)%j = (c(24)*(M(5,:)%j-M(19,:)%j)+c(23)*(M(45,:)%j-M(49,:)%j)) * den(7)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(1509),h0tab(:,1509),[36,3,16,8],[0,0,0,0],4,2,wf4(:,4),wf4(:,1))
  call Hloop_QV_A(ntryL,G0H64(1),wf4(:,4),G0H16(223),m3h4x16(:,213),heltab2x64(:,:,1095))
  call Hloop_Q_A(ntryL,G0H16(223),36,0,G1H16(308),n2h16(584))
  Gcoeff(:)%j = (c(22)*(M(5,:)%j-M(19,:)%j)+c(21)*(M(45,:)%j-M(49,:)%j)) * den(7)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(1510),h0tab(:,1510),[36,3,16,8],[nMT,nMT,nMT,nMT],4,2,wf4(:,4),wf4(:,1))
  call Hloop_QV_A(ntryL,G0H64(1),wf4(:,4),G0H16(223),m3h4x16(:,214),heltab2x64(:,:,1096))
  call Hloop_Q_A(ntryL,G0H16(223),36,nMT,G1H16(310),n2h16(585))
  Gcoeff(:)%j = (c(24)*(M(15,:)%j-M(16,:)%j)+c(23)*(M(47,:)%j-M(50,:)%j)) * den(7)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(1511),h0tab(:,1511),[36,3,16,8],[0,0,0,0],4,2,wf4(:,4),wf4(:,1))
  call Hloop_AV_Q(ntryL,G0H64(1),wf4(:,4),G0H16(223),m3h4x16(:,215),heltab2x64(:,:,1097))
  call Hloop_A_Q(ntryL,G0H16(223),36,0,G1H16(314),n2h16(586))
  Gcoeff(:)%j = (c(22)*(M(15,:)%j-M(16,:)%j)+c(21)*(M(47,:)%j-M(50,:)%j)) * den(7)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(1512),h0tab(:,1512),[36,3,16,8],[nMT,nMT,nMT,nMT],4,2,wf4(:,4),wf4(:,1))
  call Hloop_AV_Q(ntryL,G0H64(1),wf4(:,4),G0H16(223),m3h4x16(:,216),heltab2x64(:,:,1098))
  call Hloop_A_Q(ntryL,G0H16(223),36,nMT,G1H16(315),n2h16(587))
  Gcoeff(:)%j = (c(24)*(M(5,:)%j-M(19,:)%j)+c(23)*(M(45,:)%j-M(49,:)%j)) * den(7)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(1513),h0tab(:,1513),[36,3,16,8],[0,0,0,0],4,2,wf4(:,4),wf4(:,1))
  call Hloop_QV_A(ntryL,G0H64(1),wf4(:,4),G0H16(223),m3h4x16(:,217),heltab2x64(:,:,1099))
  call Hloop_Q_A(ntryL,G0H16(223),36,0,G1H16(40),n2h16(588))
  Gcoeff(:)%j = (c(22)*(M(5,:)%j-M(19,:)%j)+c(21)*(M(45,:)%j-M(49,:)%j)) * den(7)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(1514),h0tab(:,1514),[36,3,16,8],[nMB,nMB,nMB,nMB],4,2,wf4(:,4),wf4(:,1))
  call Hloop_QV_A(ntryL,G0H64(1),wf4(:,4),G0H16(223),m3h4x16(:,218),heltab2x64(:,:,1100))
  call Hloop_Q_A(ntryL,G0H16(223),36,nMB,G1H16(317),n2h16(589))
  Gcoeff(:)%j = (c(24)*(M(15,:)%j-M(16,:)%j)+c(23)*(M(47,:)%j-M(50,:)%j)) * den(7)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(1515),h0tab(:,1515),[36,3,16,8],[0,0,0,0],4,2,wf4(:,4),wf4(:,1))
  call Hloop_AV_Q(ntryL,G0H64(1),wf4(:,4),G0H16(223),m3h4x16(:,219),heltab2x64(:,:,1101))
  call Hloop_A_Q(ntryL,G0H16(223),36,0,G1H16(320),n2h16(590))
  Gcoeff(:)%j = (c(22)*(M(15,:)%j-M(16,:)%j)+c(21)*(M(47,:)%j-M(50,:)%j)) * den(7)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(1516),h0tab(:,1516),[36,3,16,8],[nMB,nMB,nMB,nMB],4,2,wf4(:,4),wf4(:,1))
  call Hloop_AV_Q(ntryL,G0H64(1),wf4(:,4),G0H16(223),m3h4x16(:,220),heltab2x64(:,:,1102))
  call Hloop_A_Q(ntryL,G0H16(223),36,nMB,G1H16(321),n2h16(591))
  Gcoeff(:)%j = (c(9)*(M(5,:)%j+M(15,:)%j-M(16,:)%j-M(19,:)%j)+c(7)*(M(31,:)%j-M(32,:)%j-M(38,:)%j-M(40,:)%j+M(41,:)%j+M(42,:)%j) &
    +c(6)*(M(45,:)%j+M(47,:)%j-M(49,:)%j-M(50,:)%j)) * den(7)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(1517),h0tab(:,1517),[36,3,16,8],[0,0,0,0],4,2,wf4(:,4),wf4(:,1))
  call Hloop_CV_D(ntryL,G0H64(1),0,wf4(:,4),36,G1H16(325),m3h4x16(:,221),heltab2x64(:,:,1103))
  Gcoeff(:)%j = (c(9)*(M(5,:)%j+M(15,:)%j-M(16,:)%j-M(19,:)%j)+c(7)*(M(31,:)%j-M(32,:)%j-M(38,:)%j-M(40,:)%j+M(41,:)%j+M(42,:)%j) &
    +c(6)*(M(45,:)%j+M(47,:)%j-M(49,:)%j-M(50,:)%j)) * den(7)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(1518),h0tab(:,1518),[36,3,16,8],[0,0,0,0],4,2,wf4(:,4),wf4(:,1))
  call Hloop_DV_C(ntryL,G0H64(1),0,wf4(:,4),G1H16(45),m3h4x16(:,222),heltab2x64(:,:,1104))
  Gcoeff(:)%j = (c(9)*(-M(5,:)%j-M(15,:)%j+M(16,:)%j+M(19,:)%j)+c(7)*(-M(31,:)%j+M(32,:)%j+M(38,:)%j+M(40,:)%j-M(41,:)%j &
    -M(42,:)%j)+c(6)*(-M(45,:)%j-M(47,:)%j+M(49,:)%j+M(50,:)%j)) * den(7)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(1519),h0tab(:,1519),[36,3,16,8],[0,0,0,0],4,2,wf4(:,4),wf4(:,1))
  call Hloop_UV_W(ntryL,G0H64(1),0,wf4(:,4),36,G1H16(51),m3h4x16(:,223),heltab2x64(:,:,1105))
  Gcoeff(:)%j = (c(24)*(M(14,:)%j-M(17,:)%j)+c(23)*(M(45,:)%j-M(49,:)%j)) * den(7)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(1520),h0tab(:,1520),[36,8,3,16],[0,0,0,0],4,2,wf4(:,4),wf4(:,1))
  call Hloop_AV_Q(ntryL,G0H64(1),wf4(:,4),G0H16(223),m3h4x16(:,224),heltab2x64(:,:,1106))
  call Hloop_A_Q(ntryL,G0H16(223),36,0,G1H16(73),n2h16(592))
  Gcoeff(:)%j = (c(22)*(M(14,:)%j-M(17,:)%j)+c(21)*(M(45,:)%j-M(49,:)%j)) * den(7)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(1521),h0tab(:,1521),[36,8,3,16],[nMT,nMT,nMT,nMT],4,2,wf4(:,4),wf4(:,1))
  call Hloop_AV_Q(ntryL,G0H64(1),wf4(:,4),G0H16(223),m3h4x16(:,225),heltab2x64(:,:,1107))
  call Hloop_A_Q(ntryL,G0H16(223),36,nMT,G1H16(79),n2h16(593))
  Gcoeff(:)%j = (c(24)*(M(8,:)%j-M(11,:)%j)+c(23)*(M(47,:)%j-M(50,:)%j)) * den(7)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(1522),h0tab(:,1522),[36,8,3,16],[0,0,0,0],4,2,wf4(:,4),wf4(:,1))
  call Hloop_QV_A(ntryL,G0H64(1),wf4(:,4),G0H16(223),m3h4x16(:,226),heltab2x64(:,:,1108))
  call Hloop_Q_A(ntryL,G0H16(223),36,0,G1H16(91),n2h16(594))
  Gcoeff(:)%j = (c(22)*(M(8,:)%j-M(11,:)%j)+c(21)*(M(47,:)%j-M(50,:)%j)) * den(7)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(1523),h0tab(:,1523),[36,8,3,16],[nMT,nMT,nMT,nMT],4,2,wf4(:,4),wf4(:,1))
  call Hloop_QV_A(ntryL,G0H64(1),wf4(:,4),G0H16(223),m3h4x16(:,227),heltab2x64(:,:,1109))
  call Hloop_Q_A(ntryL,G0H16(223),36,nMT,G1H16(113),n2h16(595))
  Gcoeff(:)%j = (c(24)*(M(14,:)%j-M(17,:)%j)+c(23)*(M(45,:)%j-M(49,:)%j)) * den(7)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(1524),h0tab(:,1524),[36,8,3,16],[0,0,0,0],4,2,wf4(:,4),wf4(:,1))
  call Hloop_AV_Q(ntryL,G0H64(1),wf4(:,4),G0H16(223),m3h4x16(:,228),heltab2x64(:,:,1110))
  call Hloop_A_Q(ntryL,G0H16(223),36,0,G1H16(125),n2h16(596))
  Gcoeff(:)%j = (c(22)*(M(14,:)%j-M(17,:)%j)+c(21)*(M(45,:)%j-M(49,:)%j)) * den(7)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(1525),h0tab(:,1525),[36,8,3,16],[nMB,nMB,nMB,nMB],4,2,wf4(:,4),wf4(:,1))
  call Hloop_AV_Q(ntryL,G0H64(1),wf4(:,4),G0H16(223),m3h4x16(:,229),heltab2x64(:,:,1111))
  call Hloop_A_Q(ntryL,G0H16(223),36,nMB,G1H16(152),n2h16(597))
  Gcoeff(:)%j = (c(24)*(M(8,:)%j-M(11,:)%j)+c(23)*(M(47,:)%j-M(50,:)%j)) * den(7)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(1526),h0tab(:,1526),[36,8,3,16],[0,0,0,0],4,2,wf4(:,4),wf4(:,1))
  call Hloop_QV_A(ntryL,G0H64(1),wf4(:,4),G0H16(223),m3h4x16(:,230),heltab2x64(:,:,1112))
  call Hloop_Q_A(ntryL,G0H16(223),36,0,G1H16(173),n2h16(598))
  Gcoeff(:)%j = (c(22)*(M(8,:)%j-M(11,:)%j)+c(21)*(M(47,:)%j-M(50,:)%j)) * den(7)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(1527),h0tab(:,1527),[36,8,3,16],[nMB,nMB,nMB,nMB],4,2,wf4(:,4),wf4(:,1))
  call Hloop_QV_A(ntryL,G0H64(1),wf4(:,4),G0H16(223),m3h4x16(:,231),heltab2x64(:,:,1113))
  call Hloop_Q_A(ntryL,G0H16(223),36,nMB,G1H16(184),n2h16(599))
  Gcoeff(:)%j = (c(9)*(M(8,:)%j-M(11,:)%j+M(14,:)%j-M(17,:)%j)+c(7)*(M(31,:)%j-M(32,:)%j-M(38,:)%j-M(40,:)%j+M(41,:)%j+M(42,:)%j) &
    +c(6)*(M(45,:)%j+M(47,:)%j-M(49,:)%j-M(50,:)%j)) * den(7)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(1528),h0tab(:,1528),[36,8,3,16],[0,0,0,0],4,2,wf4(:,4),wf4(:,1))
  call Hloop_DV_C(ntryL,G0H64(1),0,wf4(:,4),G1H16(190),m3h4x16(:,232),heltab2x64(:,:,1114))
  Gcoeff(:)%j = (c(9)*(M(8,:)%j-M(11,:)%j+M(14,:)%j-M(17,:)%j)+c(7)*(M(31,:)%j-M(32,:)%j-M(38,:)%j-M(40,:)%j+M(41,:)%j+M(42,:)%j) &
    +c(6)*(M(45,:)%j+M(47,:)%j-M(49,:)%j-M(50,:)%j)) * den(7)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(1529),h0tab(:,1529),[36,8,3,16],[0,0,0,0],4,2,wf4(:,4),wf4(:,1))
  call Hloop_CV_D(ntryL,G0H64(1),0,wf4(:,4),36,G1H16(215),m3h4x16(:,233),heltab2x64(:,:,1115))
  Gcoeff(:)%j = (c(9)*(-M(8,:)%j+M(11,:)%j-M(14,:)%j+M(17,:)%j)+c(7)*(-M(31,:)%j+M(32,:)%j+M(38,:)%j+M(40,:)%j-M(41,:)%j &
    -M(42,:)%j)+c(6)*(-M(45,:)%j-M(47,:)%j+M(49,:)%j+M(50,:)%j)) * den(7)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(1530),h0tab(:,1530),[36,8,3,16],[0,0,0,0],4,2,wf4(:,4),wf4(:,1))
  call Hloop_UV_W(ntryL,G0H64(1),0,wf4(:,4),36,G1H16(241),m3h4x16(:,234),heltab2x64(:,:,1116))
  Gcoeff(:)%j = (c(24)*(M(3,:)%j-M(4,:)%j)+c(23)*(-M(47,:)%j+M(48,:)%j)) * den(13)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(1531),h0tab(:,1531),[40,3,4,16],[0,0,0,0],4,2,wf4(:,6),wf4(:,1))
  call Hloop_AV_Q(ntryL,G0H64(1),wf4(:,6),G0H16(223),m3h4x16(:,235),heltab2x64(:,:,1117))
  call Hloop_A_Q(ntryL,G0H16(223),40,0,G1H16(266),n2h16(600))
  Gcoeff(:)%j = (c(22)*(M(3,:)%j-M(4,:)%j)+c(21)*(-M(47,:)%j+M(48,:)%j)) * den(13)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(1532),h0tab(:,1532),[40,3,4,16],[nMT,nMT,nMT,nMT],4,2,wf4(:,6),wf4(:,1))
  call Hloop_AV_Q(ntryL,G0H64(1),wf4(:,6),G0H16(223),m3h4x16(:,236),heltab2x64(:,:,1118))
  call Hloop_A_Q(ntryL,G0H16(223),40,nMT,G1H16(272),n2h16(601))
  Gcoeff(:)%j = (c(24)*(M(12,:)%j-M(22,:)%j)+c(23)*(-M(46,:)%j+M(49,:)%j)) * den(13)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(1533),h0tab(:,1533),[40,3,4,16],[0,0,0,0],4,2,wf4(:,6),wf4(:,1))
  call Hloop_QV_A(ntryL,G0H64(1),wf4(:,6),G0H16(223),m3h4x16(:,237),heltab2x64(:,:,1119))
  call Hloop_Q_A(ntryL,G0H16(223),40,0,G1H16(101),n2h16(602))
  Gcoeff(:)%j = (c(22)*(M(12,:)%j-M(22,:)%j)+c(21)*(-M(46,:)%j+M(49,:)%j)) * den(13)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(1534),h0tab(:,1534),[40,3,4,16],[nMT,nMT,nMT,nMT],4,2,wf4(:,6),wf4(:,1))
  call Hloop_QV_A(ntryL,G0H64(1),wf4(:,6),G0H16(223),m3h4x16(:,238),heltab2x64(:,:,1120))
  call Hloop_Q_A(ntryL,G0H16(223),40,nMT,G1H16(80),n2h16(603))
  Gcoeff(:)%j = (c(24)*(M(3,:)%j-M(4,:)%j)+c(23)*(-M(47,:)%j+M(48,:)%j)) * den(13)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(1535),h0tab(:,1535),[40,3,4,16],[0,0,0,0],4,2,wf4(:,6),wf4(:,1))
  call Hloop_AV_Q(ntryL,G0H64(1),wf4(:,6),G0H16(223),m3h4x16(:,239),heltab2x64(:,:,1121))
  call Hloop_A_Q(ntryL,G0H16(223),40,0,G1H16(4),n2h16(604))
  Gcoeff(:)%j = (c(22)*(M(3,:)%j-M(4,:)%j)+c(21)*(-M(47,:)%j+M(48,:)%j)) * den(13)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(1536),h0tab(:,1536),[40,3,4,16],[nMB,nMB,nMB,nMB],4,2,wf4(:,6),wf4(:,1))
  call Hloop_AV_Q(ntryL,G0H64(1),wf4(:,6),G0H16(223),m3h4x16(:,240),heltab2x64(:,:,1122))
  call Hloop_A_Q(ntryL,G0H16(223),40,nMB,G1H16(2),n2h16(605))
  Gcoeff(:)%j = (c(24)*(M(12,:)%j-M(22,:)%j)+c(23)*(-M(46,:)%j+M(49,:)%j)) * den(13)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(1537),h0tab(:,1537),[40,3,4,16],[0,0,0,0],4,2,wf4(:,6),wf4(:,1))
  call Hloop_QV_A(ntryL,G0H64(1),wf4(:,6),G0H16(223),m3h4x16(:,241),heltab2x64(:,:,1123))
  call Hloop_Q_A(ntryL,G0H16(223),40,0,G1H16(71),n2h16(606))
  Gcoeff(:)%j = (c(22)*(M(12,:)%j-M(22,:)%j)+c(21)*(-M(46,:)%j+M(49,:)%j)) * den(13)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(1538),h0tab(:,1538),[40,3,4,16],[nMB,nMB,nMB,nMB],4,2,wf4(:,6),wf4(:,1))
  call Hloop_QV_A(ntryL,G0H64(1),wf4(:,6),G0H16(223),m3h4x16(:,242),heltab2x64(:,:,1124))
  call Hloop_Q_A(ntryL,G0H16(223),40,nMB,G1H16(103),n2h16(607))
  Gcoeff(:)%j = (c(9)*(M(3,:)%j-M(4,:)%j+M(12,:)%j-M(22,:)%j)+c(7)*(M(27,:)%j-M(28,:)%j+M(38,:)%j-M(41,:)%j-M(43,:)%j+M(44,:)%j) &
    +c(6)*(-M(46,:)%j-M(47,:)%j+M(48,:)%j+M(49,:)%j)) * den(13)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(1539),h0tab(:,1539),[40,3,4,16],[0,0,0,0],4,2,wf4(:,6),wf4(:,1))
  call Hloop_DV_C(ntryL,G0H64(1),0,wf4(:,6),G1H16(102),m3h4x16(:,243),heltab2x64(:,:,1125))
  Gcoeff(:)%j = (c(9)*(M(3,:)%j-M(4,:)%j+M(12,:)%j-M(22,:)%j)+c(7)*(M(27,:)%j-M(28,:)%j+M(38,:)%j-M(41,:)%j-M(43,:)%j+M(44,:)%j) &
    +c(6)*(-M(46,:)%j-M(47,:)%j+M(48,:)%j+M(49,:)%j)) * den(13)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(1540),h0tab(:,1540),[40,3,4,16],[0,0,0,0],4,2,wf4(:,6),wf4(:,1))
  call Hloop_CV_D(ntryL,G0H64(1),0,wf4(:,6),40,G1H16(74),m3h4x16(:,244),heltab2x64(:,:,1126))
  Gcoeff(:)%j = (c(9)*(-M(3,:)%j+M(4,:)%j-M(12,:)%j+M(22,:)%j)+c(7)*(-M(27,:)%j+M(28,:)%j-M(38,:)%j+M(41,:)%j+M(43,:)%j-M(44,:)%j) &
    +c(6)*(M(46,:)%j+M(47,:)%j-M(48,:)%j-M(49,:)%j)) * den(13)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(1541),h0tab(:,1541),[40,3,4,16],[0,0,0,0],4,2,wf4(:,6),wf4(:,1))
  call Hloop_UV_W(ntryL,G0H64(1),0,wf4(:,6),40,G1H16(137),m3h4x16(:,245),heltab2x64(:,:,1127))
  Gcoeff(:)%j = (c(24)*(M(11,:)%j-M(21,:)%j)+c(23)*(-M(47,:)%j+M(48,:)%j)) * den(13)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(1542),h0tab(:,1542),[40,3,16,4],[0,0,0,0],4,2,wf4(:,6),wf4(:,1))
  call Hloop_QV_A(ntryL,G0H64(1),wf4(:,6),G0H16(223),m3h4x16(:,246),heltab2x64(:,:,1128))
  call Hloop_Q_A(ntryL,G0H16(223),40,0,G1H16(143),n2h16(608))
  Gcoeff(:)%j = (c(22)*(M(11,:)%j-M(21,:)%j)+c(21)*(-M(47,:)%j+M(48,:)%j)) * den(13)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(1543),h0tab(:,1543),[40,3,16,4],[nMT,nMT,nMT,nMT],4,2,wf4(:,6),wf4(:,1))
  call Hloop_QV_A(ntryL,G0H64(1),wf4(:,6),G0H16(223),m3h4x16(:,247),heltab2x64(:,:,1129))
  call Hloop_Q_A(ntryL,G0H16(223),40,nMT,G1H16(116),n2h16(609))
  Gcoeff(:)%j = (c(24)*(M(13,:)%j-M(14,:)%j)+c(23)*(-M(46,:)%j+M(49,:)%j)) * den(13)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(1544),h0tab(:,1544),[40,3,16,4],[0,0,0,0],4,2,wf4(:,6),wf4(:,1))
  call Hloop_AV_Q(ntryL,G0H64(1),wf4(:,6),G0H16(223),m3h4x16(:,248),heltab2x64(:,:,1130))
  call Hloop_A_Q(ntryL,G0H16(223),40,0,G1H16(58),n2h16(610))
  Gcoeff(:)%j = (c(22)*(M(13,:)%j-M(14,:)%j)+c(21)*(-M(46,:)%j+M(49,:)%j)) * den(13)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(1545),h0tab(:,1545),[40,3,16,4],[nMT,nMT,nMT,nMT],4,2,wf4(:,6),wf4(:,1))
  call Hloop_AV_Q(ntryL,G0H64(1),wf4(:,6),G0H16(223),m3h4x16(:,249),heltab2x64(:,:,1131))
  call Hloop_A_Q(ntryL,G0H16(223),40,nMT,G1H16(167),n2h16(611))
  Gcoeff(:)%j = (c(24)*(M(11,:)%j-M(21,:)%j)+c(23)*(-M(47,:)%j+M(48,:)%j)) * den(13)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(1546),h0tab(:,1546),[40,3,16,4],[0,0,0,0],4,2,wf4(:,6),wf4(:,1))
  call Hloop_QV_A(ntryL,G0H64(1),wf4(:,6),G0H16(223),m3h4x16(:,250),heltab2x64(:,:,1132))
  call Hloop_Q_A(ntryL,G0H16(223),40,0,G1H16(111),n2h16(612))
  Gcoeff(:)%j = (c(22)*(M(11,:)%j-M(21,:)%j)+c(21)*(-M(47,:)%j+M(48,:)%j)) * den(13)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(1547),h0tab(:,1547),[40,3,16,4],[nMB,nMB,nMB,nMB],4,2,wf4(:,6),wf4(:,1))
  call Hloop_QV_A(ntryL,G0H64(1),wf4(:,6),G0H16(223),m3h4x16(:,251),heltab2x64(:,:,1133))
  call Hloop_Q_A(ntryL,G0H16(223),40,nMB,G1H16(60),n2h16(613))
  Gcoeff(:)%j = (c(24)*(M(13,:)%j-M(14,:)%j)+c(23)*(-M(46,:)%j+M(49,:)%j)) * den(13)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(1548),h0tab(:,1548),[40,3,16,4],[0,0,0,0],4,2,wf4(:,6),wf4(:,1))
  call Hloop_AV_Q(ntryL,G0H64(1),wf4(:,6),G0H16(223),m3h4x16(:,252),heltab2x64(:,:,1134))
  call Hloop_A_Q(ntryL,G0H16(223),40,0,G1H16(194),n2h16(614))
  Gcoeff(:)%j = (c(22)*(M(13,:)%j-M(14,:)%j)+c(21)*(-M(46,:)%j+M(49,:)%j)) * den(13)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(1549),h0tab(:,1549),[40,3,16,4],[nMB,nMB,nMB,nMB],4,2,wf4(:,6),wf4(:,1))
  call Hloop_AV_Q(ntryL,G0H64(1),wf4(:,6),G0H16(223),m3h4x16(:,253),heltab2x64(:,:,1135))
  call Hloop_A_Q(ntryL,G0H16(223),40,nMB,G1H16(199),n2h16(615))
  Gcoeff(:)%j = (c(9)*(M(11,:)%j+M(13,:)%j-M(14,:)%j-M(21,:)%j)+c(7)*(M(27,:)%j-M(28,:)%j+M(38,:)%j-M(41,:)%j-M(43,:)%j+M(44,:)%j) &
    +c(6)*(-M(46,:)%j-M(47,:)%j+M(48,:)%j+M(49,:)%j)) * den(13)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(1550),h0tab(:,1550),[40,3,16,4],[0,0,0,0],4,2,wf4(:,6),wf4(:,1))
  call Hloop_CV_D(ntryL,G0H64(1),0,wf4(:,6),40,G1H16(49),m3h4x16(:,254),heltab2x64(:,:,1136))
  Gcoeff(:)%j = (c(9)*(M(11,:)%j+M(13,:)%j-M(14,:)%j-M(21,:)%j)+c(7)*(M(27,:)%j-M(28,:)%j+M(38,:)%j-M(41,:)%j-M(43,:)%j+M(44,:)%j) &
    +c(6)*(-M(46,:)%j-M(47,:)%j+M(48,:)%j+M(49,:)%j)) * den(13)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(1551),h0tab(:,1551),[40,3,16,4],[0,0,0,0],4,2,wf4(:,6),wf4(:,1))
  call Hloop_DV_C(ntryL,G0H64(1),0,wf4(:,6),G1H16(225),m3h4x16(:,255),heltab2x64(:,:,1137))
  Gcoeff(:)%j = (c(9)*(-M(11,:)%j-M(13,:)%j+M(14,:)%j+M(21,:)%j)+c(7)*(-M(27,:)%j+M(28,:)%j-M(38,:)%j+M(41,:)%j+M(43,:)%j &
    -M(44,:)%j)+c(6)*(M(46,:)%j+M(47,:)%j-M(48,:)%j-M(49,:)%j)) * den(13)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(1552),h0tab(:,1552),[40,3,16,4],[0,0,0,0],4,2,wf4(:,6),wf4(:,1))
  call Hloop_UV_W(ntryL,G0H64(1),0,wf4(:,6),40,G1H16(84),m3h4x16(:,256),heltab2x64(:,:,1138))
  Gcoeff(:)%j = (c(24)*(M(16,:)%j-M(18,:)%j)+c(23)*(-M(47,:)%j+M(48,:)%j)) * den(13)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(1553),h0tab(:,1553),[40,4,3,16],[0,0,0,0],4,2,wf4(:,6),wf4(:,1))
  call Hloop_AV_Q(ntryL,G0H64(1),wf4(:,6),G0H16(223),m3h4x16(:,257),heltab2x64(:,:,1139))
  call Hloop_A_Q(ntryL,G0H16(223),40,0,G1H16(87),n2h16(616))
  Gcoeff(:)%j = (c(22)*(M(16,:)%j-M(18,:)%j)+c(21)*(-M(47,:)%j+M(48,:)%j)) * den(13)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(1554),h0tab(:,1554),[40,4,3,16],[nMT,nMT,nMT,nMT],4,2,wf4(:,6),wf4(:,1))
  call Hloop_AV_Q(ntryL,G0H64(1),wf4(:,6),G0H16(223),m3h4x16(:,258),heltab2x64(:,:,1140))
  call Hloop_A_Q(ntryL,G0H16(223),40,nMT,G1H16(65),n2h16(617))
  Gcoeff(:)%j = (c(24)*(M(2,:)%j-M(5,:)%j)+c(23)*(-M(46,:)%j+M(49,:)%j)) * den(13)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(1555),h0tab(:,1555),[40,4,3,16],[0,0,0,0],4,2,wf4(:,6),wf4(:,1))
  call Hloop_QV_A(ntryL,G0H64(1),wf4(:,6),G0H16(223),m3h4x16(:,259),heltab2x64(:,:,1141))
  call Hloop_Q_A(ntryL,G0H16(223),40,0,G1H16(42),n2h16(618))
  Gcoeff(:)%j = (c(22)*(M(2,:)%j-M(5,:)%j)+c(21)*(-M(46,:)%j+M(49,:)%j)) * den(13)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(1556),h0tab(:,1556),[40,4,3,16],[nMT,nMT,nMT,nMT],4,2,wf4(:,6),wf4(:,1))
  call Hloop_QV_A(ntryL,G0H64(1),wf4(:,6),G0H16(223),m3h4x16(:,260),heltab2x64(:,:,1142))
  call Hloop_Q_A(ntryL,G0H16(223),40,nMT,G1H16(277),n2h16(619))
  Gcoeff(:)%j = (c(24)*(M(16,:)%j-M(18,:)%j)+c(23)*(-M(47,:)%j+M(48,:)%j)) * den(13)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(1557),h0tab(:,1557),[40,4,3,16],[0,0,0,0],4,2,wf4(:,6),wf4(:,1))
  call Hloop_AV_Q(ntryL,G0H64(1),wf4(:,6),G0H16(223),m3h4x16(:,261),heltab2x64(:,:,1143))
  call Hloop_A_Q(ntryL,G0H16(223),40,0,G1H16(286),n2h16(620))
  Gcoeff(:)%j = (c(22)*(M(16,:)%j-M(18,:)%j)+c(21)*(-M(47,:)%j+M(48,:)%j)) * den(13)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(1558),h0tab(:,1558),[40,4,3,16],[nMB,nMB,nMB,nMB],4,2,wf4(:,6),wf4(:,1))
  call Hloop_AV_Q(ntryL,G0H64(1),wf4(:,6),G0H16(223),m3h4x16(:,262),heltab2x64(:,:,1144))
  call Hloop_A_Q(ntryL,G0H16(223),40,nMB,G1H16(292),n2h16(621))
  Gcoeff(:)%j = (c(24)*(M(2,:)%j-M(5,:)%j)+c(23)*(-M(46,:)%j+M(49,:)%j)) * den(13)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(1559),h0tab(:,1559),[40,4,3,16],[0,0,0,0],4,2,wf4(:,6),wf4(:,1))
  call Hloop_QV_A(ntryL,G0H64(1),wf4(:,6),G0H16(223),m3h4x16(:,263),heltab2x64(:,:,1145))
  call Hloop_Q_A(ntryL,G0H16(223),40,0,G1H16(306),n2h16(622))
  Gcoeff(:)%j = (c(22)*(M(2,:)%j-M(5,:)%j)+c(21)*(-M(46,:)%j+M(49,:)%j)) * den(13)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(1560),h0tab(:,1560),[40,4,3,16],[nMB,nMB,nMB,nMB],4,2,wf4(:,6),wf4(:,1))
  call Hloop_QV_A(ntryL,G0H64(1),wf4(:,6),G0H16(223),m3h4x16(:,264),heltab2x64(:,:,1146))
  call Hloop_Q_A(ntryL,G0H16(223),40,nMB,G1H16(322),n2h16(623))
  Gcoeff(:)%j = (c(9)*(M(2,:)%j-M(5,:)%j+M(16,:)%j-M(18,:)%j)+c(7)*(M(27,:)%j-M(28,:)%j+M(38,:)%j-M(41,:)%j-M(43,:)%j+M(44,:)%j) &
    +c(6)*(-M(46,:)%j-M(47,:)%j+M(48,:)%j+M(49,:)%j)) * den(13)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(1561),h0tab(:,1561),[40,4,3,16],[0,0,0,0],4,2,wf4(:,6),wf4(:,1))
  call Hloop_DV_C(ntryL,G0H64(1),0,wf4(:,6),G1H16(130),m3h4x16(:,265),heltab2x64(:,:,1147))
  Gcoeff(:)%j = (c(9)*(M(2,:)%j-M(5,:)%j+M(16,:)%j-M(18,:)%j)+c(7)*(M(27,:)%j-M(28,:)%j+M(38,:)%j-M(41,:)%j-M(43,:)%j+M(44,:)%j) &
    +c(6)*(-M(46,:)%j-M(47,:)%j+M(48,:)%j+M(49,:)%j)) * den(13)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(1562),h0tab(:,1562),[40,4,3,16],[0,0,0,0],4,2,wf4(:,6),wf4(:,1))
  call Hloop_CV_D(ntryL,G0H64(1),0,wf4(:,6),40,G1H16(135),m3h4x16(:,266),heltab2x64(:,:,1148))
  Gcoeff(:)%j = (c(9)*(-M(2,:)%j+M(5,:)%j-M(16,:)%j+M(18,:)%j)+c(7)*(-M(27,:)%j+M(28,:)%j-M(38,:)%j+M(41,:)%j+M(43,:)%j-M(44,:)%j) &
    +c(6)*(M(46,:)%j+M(47,:)%j-M(48,:)%j-M(49,:)%j)) * den(13)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(1563),h0tab(:,1563),[40,4,3,16],[0,0,0,0],4,2,wf4(:,6),wf4(:,1))
  call Hloop_UV_W(ntryL,G0H64(1),0,wf4(:,6),40,G1H16(138),m3h4x16(:,267),heltab2x64(:,:,1149))
  Gcoeff(:)%j = (c(24)*(M(1,:)%j-M(2,:)%j)+c(23)*(-M(45,:)%j+M(46,:)%j)) * den(17)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(1564),h0tab(:,1564),[48,3,4,8],[0,0,0,0],4,2,wf4(:,7),wf4(:,1))
  call Hloop_AV_Q(ntryL,G0H64(1),wf4(:,7),G0H16(223),m3h4x16(:,268),heltab2x64(:,:,1150))
  call Hloop_A_Q(ntryL,G0H16(223),48,0,G1H16(142),n2h16(624))
  Gcoeff(:)%j = (c(22)*(M(1,:)%j-M(2,:)%j)+c(21)*(-M(45,:)%j+M(46,:)%j)) * den(17)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(1565),h0tab(:,1565),[48,3,4,8],[nMT,nMT,nMT,nMT],4,2,wf4(:,7),wf4(:,1))
  call Hloop_AV_Q(ntryL,G0H64(1),wf4(:,7),G0H16(223),m3h4x16(:,269),heltab2x64(:,:,1151))
  call Hloop_A_Q(ntryL,G0H16(223),48,nMT,G1H16(8),n2h16(625))
  Gcoeff(:)%j = (c(24)*(M(18,:)%j-M(24,:)%j)+c(23)*(-M(48,:)%j+M(50,:)%j)) * den(17)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(1566),h0tab(:,1566),[48,3,4,8],[0,0,0,0],4,2,wf4(:,7),wf4(:,1))
  call Hloop_QV_A(ntryL,G0H64(1),wf4(:,7),G0H16(223),m3h4x16(:,270),heltab2x64(:,:,1152))
  call Hloop_Q_A(ntryL,G0H16(223),48,0,G1H16(106),n2h16(626))
  Gcoeff(:)%j = (c(22)*(M(18,:)%j-M(24,:)%j)+c(21)*(-M(48,:)%j+M(50,:)%j)) * den(17)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(1567),h0tab(:,1567),[48,3,4,8],[nMT,nMT,nMT,nMT],4,2,wf4(:,7),wf4(:,1))
  call Hloop_QV_A(ntryL,G0H64(1),wf4(:,7),G0H16(223),m3h4x16(:,271),heltab2x64(:,:,1153))
  call Hloop_Q_A(ntryL,G0H16(223),48,nMT,G1H16(114),n2h16(627))
  Gcoeff(:)%j = (c(24)*(M(1,:)%j-M(2,:)%j)+c(23)*(-M(45,:)%j+M(46,:)%j)) * den(17)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(1568),h0tab(:,1568),[48,3,4,8],[0,0,0,0],4,2,wf4(:,7),wf4(:,1))
  call Hloop_AV_Q(ntryL,G0H64(1),wf4(:,7),G0H16(223),m3h4x16(:,272),heltab2x64(:,:,1154))
  call Hloop_A_Q(ntryL,G0H16(223),48,0,G1H16(117),n2h16(628))
  Gcoeff(:)%j = (c(22)*(M(1,:)%j-M(2,:)%j)+c(21)*(-M(45,:)%j+M(46,:)%j)) * den(17)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(1569),h0tab(:,1569),[48,3,4,8],[nMB,nMB,nMB,nMB],4,2,wf4(:,7),wf4(:,1))
  call Hloop_AV_Q(ntryL,G0H64(1),wf4(:,7),G0H16(223),m3h4x16(:,273),heltab2x64(:,:,1155))
  call Hloop_A_Q(ntryL,G0H16(223),48,nMB,G1H16(11),n2h16(629))
  Gcoeff(:)%j = (c(24)*(M(18,:)%j-M(24,:)%j)+c(23)*(-M(48,:)%j+M(50,:)%j)) * den(17)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(1570),h0tab(:,1570),[48,3,4,8],[0,0,0,0],4,2,wf4(:,7),wf4(:,1))
  call Hloop_QV_A(ntryL,G0H64(1),wf4(:,7),G0H16(223),m3h4x16(:,274),heltab2x64(:,:,1156))
  call Hloop_Q_A(ntryL,G0H16(223),48,0,G1H16(148),n2h16(630))
  Gcoeff(:)%j = (c(22)*(M(18,:)%j-M(24,:)%j)+c(21)*(-M(48,:)%j+M(50,:)%j)) * den(17)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(1571),h0tab(:,1571),[48,3,4,8],[nMB,nMB,nMB,nMB],4,2,wf4(:,7),wf4(:,1))
  call Hloop_QV_A(ntryL,G0H64(1),wf4(:,7),G0H16(223),m3h4x16(:,275),heltab2x64(:,:,1157))
  call Hloop_Q_A(ntryL,G0H16(223),48,nMB,G1H16(151),n2h16(631))
  Gcoeff(:)%j = (c(9)*(M(1,:)%j-M(2,:)%j+M(18,:)%j-M(24,:)%j)+c(7)*(M(25,:)%j-M(26,:)%j+M(40,:)%j-M(42,:)%j+M(43,:)%j-M(44,:)%j) &
    +c(6)*(-M(45,:)%j+M(46,:)%j-M(48,:)%j+M(50,:)%j)) * den(17)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(1572),h0tab(:,1572),[48,3,4,8],[0,0,0,0],4,2,wf4(:,7),wf4(:,1))
  call Hloop_DV_C(ntryL,G0H64(1),0,wf4(:,7),G1H16(47),m3h4x16(:,276),heltab2x64(:,:,1158))
  Gcoeff(:)%j = (c(9)*(M(1,:)%j-M(2,:)%j+M(18,:)%j-M(24,:)%j)+c(7)*(M(25,:)%j-M(26,:)%j+M(40,:)%j-M(42,:)%j+M(43,:)%j-M(44,:)%j) &
    +c(6)*(-M(45,:)%j+M(46,:)%j-M(48,:)%j+M(50,:)%j)) * den(17)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(1573),h0tab(:,1573),[48,3,4,8],[0,0,0,0],4,2,wf4(:,7),wf4(:,1))
  call Hloop_CV_D(ntryL,G0H64(1),0,wf4(:,7),48,G1H16(48),m3h4x16(:,277),heltab2x64(:,:,1159))
  Gcoeff(:)%j = (c(9)*(-M(1,:)%j+M(2,:)%j-M(18,:)%j+M(24,:)%j)+c(7)*(-M(25,:)%j+M(26,:)%j-M(40,:)%j+M(42,:)%j-M(43,:)%j+M(44,:)%j) &
    +c(6)*(M(45,:)%j-M(46,:)%j+M(48,:)%j-M(50,:)%j)) * den(17)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(1574),h0tab(:,1574),[48,3,4,8],[0,0,0,0],4,2,wf4(:,7),wf4(:,1))
  call Hloop_UV_W(ntryL,G0H64(1),0,wf4(:,7),48,G1H16(52),m3h4x16(:,278),heltab2x64(:,:,1160))
  Gcoeff(:)%j = (c(24)*(M(17,:)%j-M(23,:)%j)+c(23)*(-M(45,:)%j+M(46,:)%j)) * den(17)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(1575),h0tab(:,1575),[48,3,8,4],[0,0,0,0],4,2,wf4(:,7),wf4(:,1))
  call Hloop_QV_A(ntryL,G0H64(1),wf4(:,7),G0H16(223),m3h4x16(:,279),heltab2x64(:,:,1161))
  call Hloop_Q_A(ntryL,G0H16(223),48,0,G1H16(54),n2h16(632))
  Gcoeff(:)%j = (c(22)*(M(17,:)%j-M(23,:)%j)+c(21)*(-M(45,:)%j+M(46,:)%j)) * den(17)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(1576),h0tab(:,1576),[48,3,8,4],[nMT,nMT,nMT,nMT],4,2,wf4(:,7),wf4(:,1))
  call Hloop_QV_A(ntryL,G0H64(1),wf4(:,7),G0H16(223),m3h4x16(:,280),heltab2x64(:,:,1162))
  call Hloop_Q_A(ntryL,G0H16(223),48,nMT,G1H16(55),n2h16(633))
  Gcoeff(:)%j = (c(24)*(M(7,:)%j-M(8,:)%j)+c(23)*(-M(48,:)%j+M(50,:)%j)) * den(17)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(1577),h0tab(:,1577),[48,3,8,4],[0,0,0,0],4,2,wf4(:,7),wf4(:,1))
  call Hloop_AV_Q(ntryL,G0H64(1),wf4(:,7),G0H16(223),m3h4x16(:,281),heltab2x64(:,:,1163))
  call Hloop_A_Q(ntryL,G0H16(223),48,0,G1H16(61),n2h16(634))
  Gcoeff(:)%j = (c(22)*(M(7,:)%j-M(8,:)%j)+c(21)*(-M(48,:)%j+M(50,:)%j)) * den(17)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(1578),h0tab(:,1578),[48,3,8,4],[nMT,nMT,nMT,nMT],4,2,wf4(:,7),wf4(:,1))
  call Hloop_AV_Q(ntryL,G0H64(1),wf4(:,7),G0H16(223),m3h4x16(:,282),heltab2x64(:,:,1164))
  call Hloop_A_Q(ntryL,G0H16(223),48,nMT,G1H16(62),n2h16(635))
  Gcoeff(:)%j = (c(24)*(M(17,:)%j-M(23,:)%j)+c(23)*(-M(45,:)%j+M(46,:)%j)) * den(17)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(1579),h0tab(:,1579),[48,3,8,4],[0,0,0,0],4,2,wf4(:,7),wf4(:,1))
  call Hloop_QV_A(ntryL,G0H64(1),wf4(:,7),G0H16(223),m3h4x16(:,283),heltab2x64(:,:,1165))
  call Hloop_Q_A(ntryL,G0H16(223),48,0,G1H16(66),n2h16(636))
  Gcoeff(:)%j = (c(22)*(M(17,:)%j-M(23,:)%j)+c(21)*(-M(45,:)%j+M(46,:)%j)) * den(17)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(1580),h0tab(:,1580),[48,3,8,4],[nMB,nMB,nMB,nMB],4,2,wf4(:,7),wf4(:,1))
  call Hloop_QV_A(ntryL,G0H64(1),wf4(:,7),G0H16(223),m3h4x16(:,284),heltab2x64(:,:,1166))
  call Hloop_Q_A(ntryL,G0H16(223),48,nMB,G1H16(68),n2h16(637))
  Gcoeff(:)%j = (c(24)*(M(7,:)%j-M(8,:)%j)+c(23)*(-M(48,:)%j+M(50,:)%j)) * den(17)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(1581),h0tab(:,1581),[48,3,8,4],[0,0,0,0],4,2,wf4(:,7),wf4(:,1))
  call Hloop_AV_Q(ntryL,G0H64(1),wf4(:,7),G0H16(223),m3h4x16(:,285),heltab2x64(:,:,1167))
  call Hloop_A_Q(ntryL,G0H16(223),48,0,G1H16(70),n2h16(638))
  Gcoeff(:)%j = (c(22)*(M(7,:)%j-M(8,:)%j)+c(21)*(-M(48,:)%j+M(50,:)%j)) * den(17)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(1582),h0tab(:,1582),[48,3,8,4],[nMB,nMB,nMB,nMB],4,2,wf4(:,7),wf4(:,1))
  call Hloop_AV_Q(ntryL,G0H64(1),wf4(:,7),G0H16(223),m3h4x16(:,286),heltab2x64(:,:,1168))
  call Hloop_A_Q(ntryL,G0H16(223),48,nMB,G1H16(1),n2h16(639))
  Gcoeff(:)%j = (c(9)*(M(7,:)%j-M(8,:)%j+M(17,:)%j-M(23,:)%j)+c(7)*(M(25,:)%j-M(26,:)%j+M(40,:)%j-M(42,:)%j+M(43,:)%j-M(44,:)%j) &
    +c(6)*(-M(45,:)%j+M(46,:)%j-M(48,:)%j+M(50,:)%j)) * den(17)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(1583),h0tab(:,1583),[48,3,8,4],[0,0,0,0],4,2,wf4(:,7),wf4(:,1))
  call Hloop_CV_D(ntryL,G0H64(1),0,wf4(:,7),48,G1H16(76),m3h4x16(:,287),heltab2x64(:,:,1169))
  Gcoeff(:)%j = (c(9)*(M(7,:)%j-M(8,:)%j+M(17,:)%j-M(23,:)%j)+c(7)*(M(25,:)%j-M(26,:)%j+M(40,:)%j-M(42,:)%j+M(43,:)%j-M(44,:)%j) &
    +c(6)*(-M(45,:)%j+M(46,:)%j-M(48,:)%j+M(50,:)%j)) * den(17)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(1584),h0tab(:,1584),[48,3,8,4],[0,0,0,0],4,2,wf4(:,7),wf4(:,1))
  call Hloop_DV_C(ntryL,G0H64(1),0,wf4(:,7),G1H16(78),m3h4x16(:,288),heltab2x64(:,:,1170))
  Gcoeff(:)%j = (c(9)*(-M(7,:)%j+M(8,:)%j-M(17,:)%j+M(23,:)%j)+c(7)*(-M(25,:)%j+M(26,:)%j-M(40,:)%j+M(42,:)%j-M(43,:)%j+M(44,:)%j) &
    +c(6)*(M(45,:)%j-M(46,:)%j+M(48,:)%j-M(50,:)%j)) * den(17)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(1585),h0tab(:,1585),[48,3,8,4],[0,0,0,0],4,2,wf4(:,7),wf4(:,1))
  call Hloop_UV_W(ntryL,G0H64(1),0,wf4(:,7),48,G1H16(83),m3h4x16(:,289),heltab2x64(:,:,1171))
  Gcoeff(:)%j = (c(24)*(M(10,:)%j-M(12,:)%j)+c(23)*(-M(45,:)%j+M(46,:)%j)) * den(17)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(1586),h0tab(:,1586),[48,4,3,8],[0,0,0,0],4,2,wf4(:,7),wf4(:,1))
  call Hloop_AV_Q(ntryL,G0H64(1),wf4(:,7),G0H16(223),m3h4x16(:,290),heltab2x64(:,:,1172))
  call Hloop_A_Q(ntryL,G0H16(223),48,0,G1H16(86),n2h16(640))
  Gcoeff(:)%j = (c(22)*(M(10,:)%j-M(12,:)%j)+c(21)*(-M(45,:)%j+M(46,:)%j)) * den(17)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(1587),h0tab(:,1587),[48,4,3,8],[nMT,nMT,nMT,nMT],4,2,wf4(:,7),wf4(:,1))
  call Hloop_AV_Q(ntryL,G0H64(1),wf4(:,7),G0H16(223),m3h4x16(:,291),heltab2x64(:,:,1173))
  call Hloop_A_Q(ntryL,G0H16(223),48,nMT,G1H16(88),n2h16(641))
  Gcoeff(:)%j = (c(24)*(M(4,:)%j-M(6,:)%j)+c(23)*(-M(48,:)%j+M(50,:)%j)) * den(17)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(1588),h0tab(:,1588),[48,4,3,8],[0,0,0,0],4,2,wf4(:,7),wf4(:,1))
  call Hloop_QV_A(ntryL,G0H64(1),wf4(:,7),G0H16(223),m3h4x16(:,292),heltab2x64(:,:,1174))
  call Hloop_Q_A(ntryL,G0H16(223),48,0,G1H16(92),n2h16(642))
  Gcoeff(:)%j = (c(22)*(M(4,:)%j-M(6,:)%j)+c(21)*(-M(48,:)%j+M(50,:)%j)) * den(17)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(1589),h0tab(:,1589),[48,4,3,8],[nMT,nMT,nMT,nMT],4,2,wf4(:,7),wf4(:,1))
  call Hloop_QV_A(ntryL,G0H64(1),wf4(:,7),G0H16(223),m3h4x16(:,293),heltab2x64(:,:,1175))
  call Hloop_Q_A(ntryL,G0H16(223),48,nMT,G1H16(93),n2h16(643))
  Gcoeff(:)%j = (c(24)*(M(10,:)%j-M(12,:)%j)+c(23)*(-M(45,:)%j+M(46,:)%j)) * den(17)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(1590),h0tab(:,1590),[48,4,3,8],[0,0,0,0],4,2,wf4(:,7),wf4(:,1))
  call Hloop_AV_Q(ntryL,G0H64(1),wf4(:,7),G0H16(223),m3h4x16(:,294),heltab2x64(:,:,1176))
  call Hloop_A_Q(ntryL,G0H16(223),48,0,G1H16(100),n2h16(644))
  Gcoeff(:)%j = (c(22)*(M(10,:)%j-M(12,:)%j)+c(21)*(-M(45,:)%j+M(46,:)%j)) * den(17)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(1591),h0tab(:,1591),[48,4,3,8],[nMB,nMB,nMB,nMB],4,2,wf4(:,7),wf4(:,1))
  call Hloop_AV_Q(ntryL,G0H64(1),wf4(:,7),G0H16(223),m3h4x16(:,295),heltab2x64(:,:,1177))
  call Hloop_A_Q(ntryL,G0H16(223),48,nMB,G1H16(105),n2h16(645))
  Gcoeff(:)%j = (c(24)*(M(4,:)%j-M(6,:)%j)+c(23)*(-M(48,:)%j+M(50,:)%j)) * den(17)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(1592),h0tab(:,1592),[48,4,3,8],[0,0,0,0],4,2,wf4(:,7),wf4(:,1))
  call Hloop_QV_A(ntryL,G0H64(1),wf4(:,7),G0H16(223),m3h4x16(:,296),heltab2x64(:,:,1178))
  call Hloop_Q_A(ntryL,G0H16(223),48,0,G1H16(3),n2h16(646))
  Gcoeff(:)%j = (c(22)*(M(4,:)%j-M(6,:)%j)+c(21)*(-M(48,:)%j+M(50,:)%j)) * den(17)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(1593),h0tab(:,1593),[48,4,3,8],[nMB,nMB,nMB,nMB],4,2,wf4(:,7),wf4(:,1))
  call Hloop_QV_A(ntryL,G0H64(1),wf4(:,7),G0H16(223),m3h4x16(:,297),heltab2x64(:,:,1179))
  call Hloop_Q_A(ntryL,G0H16(223),48,nMB,G1H16(108),n2h16(647))
  Gcoeff(:)%j = (c(9)*(M(4,:)%j-M(6,:)%j+M(10,:)%j-M(12,:)%j)+c(7)*(M(25,:)%j-M(26,:)%j+M(40,:)%j-M(42,:)%j+M(43,:)%j-M(44,:)%j) &
    +c(6)*(-M(45,:)%j+M(46,:)%j-M(48,:)%j+M(50,:)%j)) * den(17)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(1594),h0tab(:,1594),[48,4,3,8],[0,0,0,0],4,2,wf4(:,7),wf4(:,1))
  call Hloop_DV_C(ntryL,G0H64(1),0,wf4(:,7),G1H16(110),m3h4x16(:,298),heltab2x64(:,:,1180))
  Gcoeff(:)%j = (c(9)*(M(4,:)%j-M(6,:)%j+M(10,:)%j-M(12,:)%j)+c(7)*(M(25,:)%j-M(26,:)%j+M(40,:)%j-M(42,:)%j+M(43,:)%j-M(44,:)%j) &
    +c(6)*(-M(45,:)%j+M(46,:)%j-M(48,:)%j+M(50,:)%j)) * den(17)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(1595),h0tab(:,1595),[48,4,3,8],[0,0,0,0],4,2,wf4(:,7),wf4(:,1))
  call Hloop_CV_D(ntryL,G0H64(1),0,wf4(:,7),48,G1H16(115),m3h4x16(:,299),heltab2x64(:,:,1181))
  Gcoeff(:)%j = (c(9)*(-M(4,:)%j+M(6,:)%j-M(10,:)%j+M(12,:)%j)+c(7)*(-M(25,:)%j+M(26,:)%j-M(40,:)%j+M(42,:)%j-M(43,:)%j+M(44,:)%j) &
    +c(6)*(M(45,:)%j-M(46,:)%j+M(48,:)%j-M(50,:)%j)) * den(17)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(1596),h0tab(:,1596),[48,4,3,8],[0,0,0,0],4,2,wf4(:,7),wf4(:,1))
  call Hloop_UV_W(ntryL,G0H64(1),0,wf4(:,7),48,G1H16(118),m3h4x16(:,300),heltab2x64(:,:,1182))
  Gcoeff(:)%j = (c(24)*(M(5,:)%j-M(22,:)%j)) * den(52)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(1597),h0tab(:,1597),[32,7,16,8],[0,0,0,0],4,1,wf8(:,2))
  call Hloop_QV_A(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,829),heltab2x64(:,:,1183))
  call Hloop_Q_A(ntryL,G0H32(1),32,0,G1H32(253),n2h32(409))
  Gcoeff(:)%j = (c(22)*(M(5,:)%j-M(22,:)%j)) * den(52)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(1598),h0tab(:,1598),[32,7,16,8],[nMT,nMT,nMT,nMT],4,1,wf8(:,2))
  call Hloop_QV_A(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,830),heltab2x64(:,:,1184))
  call Hloop_Q_A(ntryL,G0H32(1),32,nMT,G1H32(254),n2h32(410))
  Gcoeff(:)%j = (c(24)*(M(3,:)%j-M(16,:)%j)) * den(52)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(1599),h0tab(:,1599),[32,7,16,8],[0,0,0,0],4,1,wf8(:,2))
  call Hloop_AV_Q(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,831),heltab2x64(:,:,1185))
  call Hloop_A_Q(ntryL,G0H32(1),32,0,G1H32(255),n2h32(411))
  Gcoeff(:)%j = (c(22)*(M(3,:)%j-M(16,:)%j)) * den(52)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(1600),h0tab(:,1600),[32,7,16,8],[nMT,nMT,nMT,nMT],4,1,wf8(:,2))
  call Hloop_AV_Q(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,832),heltab2x64(:,:,1186))
  call Hloop_A_Q(ntryL,G0H32(1),32,nMT,G1H32(256),n2h32(412))
  Gcoeff(:)%j = (c(24)*(M(5,:)%j-M(22,:)%j)) * den(52)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(1601),h0tab(:,1601),[32,7,16,8],[0,0,0,0],4,1,wf8(:,2))
  call Hloop_QV_A(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,833),heltab2x64(:,:,1187))
  call Hloop_Q_A(ntryL,G0H32(1),32,0,G1H32(257),n2h32(413))
  Gcoeff(:)%j = (c(22)*(M(5,:)%j-M(22,:)%j)) * den(52)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(1602),h0tab(:,1602),[32,7,16,8],[nMB,nMB,nMB,nMB],4,1,wf8(:,2))
  call Hloop_QV_A(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,834),heltab2x64(:,:,1188))
  call Hloop_Q_A(ntryL,G0H32(1),32,nMB,G1H32(258),n2h32(414))
  Gcoeff(:)%j = (c(24)*(M(3,:)%j-M(16,:)%j)) * den(52)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(1603),h0tab(:,1603),[32,7,16,8],[0,0,0,0],4,1,wf8(:,2))
  call Hloop_AV_Q(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,835),heltab2x64(:,:,1189))
  call Hloop_A_Q(ntryL,G0H32(1),32,0,G1H32(259),n2h32(415))
  Gcoeff(:)%j = (c(22)*(M(3,:)%j-M(16,:)%j)) * den(52)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(1604),h0tab(:,1604),[32,7,16,8],[nMB,nMB,nMB,nMB],4,1,wf8(:,2))
  call Hloop_AV_Q(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,836),heltab2x64(:,:,1190))
  call Hloop_A_Q(ntryL,G0H32(1),32,nMB,G1H32(260),n2h32(416))
  Gcoeff(:)%j = (c(9)*(M(3,:)%j+M(5,:)%j-M(16,:)%j-M(22,:)%j)+c(7)*(M(31,:)%j-M(32,:)%j+M(33,:)%j-M(34,:)%j+M(35,:)%j-M(36,:)%j))  &
    * den(52)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(1605),h0tab(:,1605),[32,7,16,8],[0,0,0,0],4,1,wf8(:,2))
  call Hloop_CV_D(ntryL,G0H64(1),0,ex6(:),32,G1H32(261),m3h2x32(:,837),heltab2x64(:,:,1191))
  Gcoeff(:)%j = (c(9)*(M(3,:)%j+M(5,:)%j-M(16,:)%j-M(22,:)%j)+c(7)*(M(31,:)%j-M(32,:)%j+M(33,:)%j-M(34,:)%j+M(35,:)%j-M(36,:)%j))  &
    * den(52)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(1606),h0tab(:,1606),[32,7,16,8],[0,0,0,0],4,1,wf8(:,2))
  call Hloop_DV_C(ntryL,G0H64(1),0,ex6(:),G1H32(262),m3h2x32(:,838),heltab2x64(:,:,1192))
  Gcoeff(:)%j = (c(9)*(-M(3,:)%j-M(5,:)%j+M(16,:)%j+M(22,:)%j)+c(7)*(-M(31,:)%j+M(32,:)%j-M(33,:)%j+M(34,:)%j-M(35,:)%j &
    +M(36,:)%j)) * den(52)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(1607),h0tab(:,1607),[32,7,16,8],[0,0,0,0],4,1,wf8(:,2))
  call Hloop_UV_W(ntryL,G0H64(1),0,ex6(:),32,G1H32(263),m3h2x32(:,839),heltab2x64(:,:,1193))
  Gcoeff(:)%j = (c(24)*(M(1,:)%j-M(10,:)%j)) * den(52)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(1608),h0tab(:,1608),[32,7,8,16],[0,0,0,0],4,1,wf8(:,2))
  call Hloop_AV_Q(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,840),heltab2x64(:,:,1194))
  call Hloop_A_Q(ntryL,G0H32(1),32,0,G1H32(264),n2h32(417))
  Gcoeff(:)%j = (c(22)*(M(1,:)%j-M(10,:)%j)) * den(52)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(1609),h0tab(:,1609),[32,7,8,16],[nMT,nMT,nMT,nMT],4,1,wf8(:,2))
  call Hloop_AV_Q(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,841),heltab2x64(:,:,1195))
  call Hloop_A_Q(ntryL,G0H32(1),32,nMT,G1H32(265),n2h32(418))
  Gcoeff(:)%j = (c(24)*(M(6,:)%j-M(24,:)%j)) * den(52)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(1610),h0tab(:,1610),[32,7,8,16],[0,0,0,0],4,1,wf8(:,2))
  call Hloop_QV_A(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,842),heltab2x64(:,:,1196))
  call Hloop_Q_A(ntryL,G0H32(1),32,0,G1H32(266),n2h32(419))
  Gcoeff(:)%j = (c(22)*(M(6,:)%j-M(24,:)%j)) * den(52)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(1611),h0tab(:,1611),[32,7,8,16],[nMT,nMT,nMT,nMT],4,1,wf8(:,2))
  call Hloop_QV_A(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,843),heltab2x64(:,:,1197))
  call Hloop_Q_A(ntryL,G0H32(1),32,nMT,G1H32(267),n2h32(420))
  Gcoeff(:)%j = (c(24)*(M(1,:)%j-M(10,:)%j)) * den(52)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(1612),h0tab(:,1612),[32,7,8,16],[0,0,0,0],4,1,wf8(:,2))
  call Hloop_AV_Q(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,844),heltab2x64(:,:,1198))
  call Hloop_A_Q(ntryL,G0H32(1),32,0,G1H32(268),n2h32(421))
  Gcoeff(:)%j = (c(22)*(M(1,:)%j-M(10,:)%j)) * den(52)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(1613),h0tab(:,1613),[32,7,8,16],[nMB,nMB,nMB,nMB],4,1,wf8(:,2))
  call Hloop_AV_Q(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,845),heltab2x64(:,:,1199))
  call Hloop_A_Q(ntryL,G0H32(1),32,nMB,G1H32(269),n2h32(422))
  Gcoeff(:)%j = (c(24)*(M(6,:)%j-M(24,:)%j)) * den(52)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(1614),h0tab(:,1614),[32,7,8,16],[0,0,0,0],4,1,wf8(:,2))
  call Hloop_QV_A(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,846),heltab2x64(:,:,1200))
  call Hloop_Q_A(ntryL,G0H32(1),32,0,G1H32(270),n2h32(423))
  Gcoeff(:)%j = (c(22)*(M(6,:)%j-M(24,:)%j)) * den(52)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(1615),h0tab(:,1615),[32,7,8,16],[nMB,nMB,nMB,nMB],4,1,wf8(:,2))
  call Hloop_QV_A(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,847),heltab2x64(:,:,1201))
  call Hloop_Q_A(ntryL,G0H32(1),32,nMB,G1H32(271),n2h32(424))
  Gcoeff(:)%j = (c(9)*(M(1,:)%j+M(6,:)%j-M(10,:)%j-M(24,:)%j)+c(7)*(M(31,:)%j-M(32,:)%j+M(33,:)%j-M(34,:)%j+M(35,:)%j-M(36,:)%j))  &
    * den(52)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(1616),h0tab(:,1616),[32,7,8,16],[0,0,0,0],4,1,wf8(:,2))
  call Hloop_DV_C(ntryL,G0H64(1),0,ex6(:),G1H32(272),m3h2x32(:,848),heltab2x64(:,:,1202))
  Gcoeff(:)%j = (c(9)*(M(1,:)%j+M(6,:)%j-M(10,:)%j-M(24,:)%j)+c(7)*(M(31,:)%j-M(32,:)%j+M(33,:)%j-M(34,:)%j+M(35,:)%j-M(36,:)%j))  &
    * den(52)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(1617),h0tab(:,1617),[32,7,8,16],[0,0,0,0],4,1,wf8(:,2))
  call Hloop_CV_D(ntryL,G0H64(1),0,ex6(:),32,G1H32(273),m3h2x32(:,849),heltab2x64(:,:,1203))
  Gcoeff(:)%j = (c(9)*(-M(1,:)%j-M(6,:)%j+M(10,:)%j+M(24,:)%j)+c(7)*(-M(31,:)%j+M(32,:)%j-M(33,:)%j+M(34,:)%j-M(35,:)%j &
    +M(36,:)%j)) * den(52)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(1618),h0tab(:,1618),[32,7,8,16],[0,0,0,0],4,1,wf8(:,2))
  call Hloop_UV_W(ntryL,G0H64(1),0,ex6(:),32,G1H32(274),m3h2x32(:,850),heltab2x64(:,:,1204))
  Gcoeff(:)%j = (c(24)*(M(2,:)%j-M(12,:)%j)) * den(52)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(1619),h0tab(:,1619),[32,8,7,16],[0,0,0,0],4,1,wf8(:,2))
  call Hloop_QV_A(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,851),heltab2x64(:,:,1205))
  call Hloop_Q_A(ntryL,G0H32(1),32,0,G1H32(275),n2h32(425))
  Gcoeff(:)%j = (c(22)*(M(2,:)%j-M(12,:)%j)) * den(52)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(1620),h0tab(:,1620),[32,8,7,16],[nMT,nMT,nMT,nMT],4,1,wf8(:,2))
  call Hloop_QV_A(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,852),heltab2x64(:,:,1206))
  call Hloop_Q_A(ntryL,G0H32(1),32,nMT,G1H32(276),n2h32(426))
  Gcoeff(:)%j = (c(24)*(M(4,:)%j-M(18,:)%j)) * den(52)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(1621),h0tab(:,1621),[32,8,7,16],[0,0,0,0],4,1,wf8(:,2))
  call Hloop_AV_Q(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,853),heltab2x64(:,:,1207))
  call Hloop_A_Q(ntryL,G0H32(1),32,0,G1H32(277),n2h32(427))
  Gcoeff(:)%j = (c(22)*(M(4,:)%j-M(18,:)%j)) * den(52)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(1622),h0tab(:,1622),[32,8,7,16],[nMT,nMT,nMT,nMT],4,1,wf8(:,2))
  call Hloop_AV_Q(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,854),heltab2x64(:,:,1208))
  call Hloop_A_Q(ntryL,G0H32(1),32,nMT,G1H32(278),n2h32(428))
  Gcoeff(:)%j = (c(24)*(M(2,:)%j-M(12,:)%j)) * den(52)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(1623),h0tab(:,1623),[32,8,7,16],[0,0,0,0],4,1,wf8(:,2))
  call Hloop_QV_A(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,855),heltab2x64(:,:,1209))
  call Hloop_Q_A(ntryL,G0H32(1),32,0,G1H32(279),n2h32(429))
  Gcoeff(:)%j = (c(22)*(M(2,:)%j-M(12,:)%j)) * den(52)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(1624),h0tab(:,1624),[32,8,7,16],[nMB,nMB,nMB,nMB],4,1,wf8(:,2))
  call Hloop_QV_A(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,856),heltab2x64(:,:,1210))
  call Hloop_Q_A(ntryL,G0H32(1),32,nMB,G1H32(280),n2h32(430))
  Gcoeff(:)%j = (c(24)*(M(4,:)%j-M(18,:)%j)) * den(52)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(1625),h0tab(:,1625),[32,8,7,16],[0,0,0,0],4,1,wf8(:,2))
  call Hloop_AV_Q(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,857),heltab2x64(:,:,1211))
  call Hloop_A_Q(ntryL,G0H32(1),32,0,G1H32(281),n2h32(431))
  Gcoeff(:)%j = (c(22)*(M(4,:)%j-M(18,:)%j)) * den(52)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(1626),h0tab(:,1626),[32,8,7,16],[nMB,nMB,nMB,nMB],4,1,wf8(:,2))
  call Hloop_AV_Q(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,858),heltab2x64(:,:,1212))
  call Hloop_A_Q(ntryL,G0H32(1),32,nMB,G1H32(282),n2h32(432))
  Gcoeff(:)%j = (c(9)*(M(2,:)%j+M(4,:)%j-M(12,:)%j-M(18,:)%j)+c(7)*(M(31,:)%j-M(32,:)%j+M(33,:)%j-M(34,:)%j+M(35,:)%j-M(36,:)%j))  &
    * den(52)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(1627),h0tab(:,1627),[32,8,7,16],[0,0,0,0],4,1,wf8(:,2))
  call Hloop_CV_D(ntryL,G0H64(1),0,ex6(:),32,G1H32(283),m3h2x32(:,859),heltab2x64(:,:,1213))
  Gcoeff(:)%j = (c(9)*(M(2,:)%j+M(4,:)%j-M(12,:)%j-M(18,:)%j)+c(7)*(M(31,:)%j-M(32,:)%j+M(33,:)%j-M(34,:)%j+M(35,:)%j-M(36,:)%j))  &
    * den(52)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(1628),h0tab(:,1628),[32,8,7,16],[0,0,0,0],4,1,wf8(:,2))
  call Hloop_DV_C(ntryL,G0H64(1),0,ex6(:),G1H32(284),m3h2x32(:,860),heltab2x64(:,:,1214))
  Gcoeff(:)%j = (c(9)*(-M(2,:)%j-M(4,:)%j+M(12,:)%j+M(18,:)%j)+c(7)*(-M(31,:)%j+M(32,:)%j-M(33,:)%j+M(34,:)%j-M(35,:)%j &
    +M(36,:)%j)) * den(52)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(1629),h0tab(:,1629),[32,8,7,16],[0,0,0,0],4,1,wf8(:,2))
  call Hloop_UV_W(ntryL,G0H64(1),0,ex6(:),32,G1H32(285),m3h2x32(:,861),heltab2x64(:,:,1215))
  Gcoeff(:)%j = (c(24)*(M(11,:)%j-M(20,:)%j)) * den(46)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(1630),h0tab(:,1630),[32,4,16,11],[0,0,0,0],4,1,wf8(:,6))
  call Hloop_AV_Q(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,862),heltab2x64(:,:,1216))
  call Hloop_A_Q(ntryL,G0H32(1),32,0,G1H32(286),n2h32(433))
  Gcoeff(:)%j = (c(22)*(M(11,:)%j-M(20,:)%j)) * den(46)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(1631),h0tab(:,1631),[32,4,16,11],[nMT,nMT,nMT,nMT],4,1,wf8(:,6))
  call Hloop_AV_Q(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,863),heltab2x64(:,:,1217))
  call Hloop_A_Q(ntryL,G0H32(1),32,nMT,G1H32(287),n2h32(434))
  Gcoeff(:)%j = (c(24)*(M(9,:)%j-M(14,:)%j)) * den(46)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(1632),h0tab(:,1632),[32,4,16,11],[0,0,0,0],4,1,wf8(:,6))
  call Hloop_QV_A(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,864),heltab2x64(:,:,1218))
  call Hloop_Q_A(ntryL,G0H32(1),32,0,G1H32(288),n2h32(435))
  Gcoeff(:)%j = (c(22)*(M(9,:)%j-M(14,:)%j)) * den(46)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(1633),h0tab(:,1633),[32,4,16,11],[nMT,nMT,nMT,nMT],4,1,wf8(:,6))
  call Hloop_QV_A(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,865),heltab2x64(:,:,1219))
  call Hloop_Q_A(ntryL,G0H32(1),32,nMT,G1H32(289),n2h32(436))
  Gcoeff(:)%j = (c(24)*(M(11,:)%j-M(20,:)%j)) * den(46)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(1634),h0tab(:,1634),[32,4,16,11],[0,0,0,0],4,1,wf8(:,6))
  call Hloop_AV_Q(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,866),heltab2x64(:,:,1220))
  call Hloop_A_Q(ntryL,G0H32(1),32,0,G1H32(290),n2h32(437))
  Gcoeff(:)%j = (c(22)*(M(11,:)%j-M(20,:)%j)) * den(46)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(1635),h0tab(:,1635),[32,4,16,11],[nMB,nMB,nMB,nMB],4,1,wf8(:,6))
  call Hloop_AV_Q(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,867),heltab2x64(:,:,1221))
  call Hloop_A_Q(ntryL,G0H32(1),32,nMB,G1H32(291),n2h32(438))
  Gcoeff(:)%j = (c(24)*(M(9,:)%j-M(14,:)%j)) * den(46)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(1636),h0tab(:,1636),[32,4,16,11],[0,0,0,0],4,1,wf8(:,6))
  call Hloop_QV_A(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,868),heltab2x64(:,:,1222))
  call Hloop_Q_A(ntryL,G0H32(1),32,0,G1H32(292),n2h32(439))
  Gcoeff(:)%j = (c(22)*(M(9,:)%j-M(14,:)%j)) * den(46)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(1637),h0tab(:,1637),[32,4,16,11],[nMB,nMB,nMB,nMB],4,1,wf8(:,6))
  call Hloop_QV_A(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,869),heltab2x64(:,:,1223))
  call Hloop_Q_A(ntryL,G0H32(1),32,nMB,G1H32(293),n2h32(440))
  Gcoeff(:)%j = (c(9)*(M(9,:)%j+M(11,:)%j-M(14,:)%j-M(20,:)%j)+c(7)*(M(27,:)%j-M(28,:)%j+M(29,:)%j-M(30,:)%j-M(35,:)%j &
    +M(36,:)%j)) * den(46)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(1638),h0tab(:,1638),[32,4,16,11],[0,0,0,0],4,1,wf8(:,6))
  call Hloop_DV_C(ntryL,G0H64(1),0,ex6(:),G1H32(294),m3h2x32(:,870),heltab2x64(:,:,1224))
  Gcoeff(:)%j = (c(9)*(M(9,:)%j+M(11,:)%j-M(14,:)%j-M(20,:)%j)+c(7)*(M(27,:)%j-M(28,:)%j+M(29,:)%j-M(30,:)%j-M(35,:)%j &
    +M(36,:)%j)) * den(46)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(1639),h0tab(:,1639),[32,4,16,11],[0,0,0,0],4,1,wf8(:,6))
  call Hloop_CV_D(ntryL,G0H64(1),0,ex6(:),32,G1H32(295),m3h2x32(:,871),heltab2x64(:,:,1225))
  Gcoeff(:)%j = (c(9)*(-M(9,:)%j-M(11,:)%j+M(14,:)%j+M(20,:)%j)+c(7)*(-M(27,:)%j+M(28,:)%j-M(29,:)%j+M(30,:)%j+M(35,:)%j &
    -M(36,:)%j)) * den(46)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(1640),h0tab(:,1640),[32,4,16,11],[0,0,0,0],4,1,wf8(:,6))
  call Hloop_UV_W(ntryL,G0H64(1),0,ex6(:),32,G1H32(296),m3h2x32(:,872),heltab2x64(:,:,1226))
  Gcoeff(:)%j = (c(24)*(-M(4,:)%j+M(7,:)%j)) * den(46)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(1641),h0tab(:,1641),[32,11,4,16],[0,0,0,0],4,1,wf8(:,6))
  call Hloop_AV_Q(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,873),heltab2x64(:,:,1227))
  call Hloop_A_Q(ntryL,G0H32(1),32,0,G1H32(297),n2h32(441))
  Gcoeff(:)%j = (c(22)*(-M(4,:)%j+M(7,:)%j)) * den(46)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(1642),h0tab(:,1642),[32,11,4,16],[nMT,nMT,nMT,nMT],4,1,wf8(:,6))
  call Hloop_AV_Q(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,874),heltab2x64(:,:,1228))
  call Hloop_A_Q(ntryL,G0H32(1),32,nMT,G1H32(298),n2h32(442))
  Gcoeff(:)%j = (c(24)*(M(12,:)%j-M(23,:)%j)) * den(46)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(1643),h0tab(:,1643),[32,11,4,16],[0,0,0,0],4,1,wf8(:,6))
  call Hloop_QV_A(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,875),heltab2x64(:,:,1229))
  call Hloop_Q_A(ntryL,G0H32(1),32,0,G1H32(299),n2h32(443))
  Gcoeff(:)%j = (c(22)*(M(12,:)%j-M(23,:)%j)) * den(46)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(1644),h0tab(:,1644),[32,11,4,16],[nMT,nMT,nMT,nMT],4,1,wf8(:,6))
  call Hloop_QV_A(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,876),heltab2x64(:,:,1230))
  call Hloop_Q_A(ntryL,G0H32(1),32,nMT,G1H32(300),n2h32(444))
  Gcoeff(:)%j = (c(24)*(-M(4,:)%j+M(7,:)%j)) * den(46)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(1645),h0tab(:,1645),[32,11,4,16],[0,0,0,0],4,1,wf8(:,6))
  call Hloop_AV_Q(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,877),heltab2x64(:,:,1231))
  call Hloop_A_Q(ntryL,G0H32(1),32,0,G1H32(301),n2h32(445))
  Gcoeff(:)%j = (c(22)*(-M(4,:)%j+M(7,:)%j)) * den(46)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(1646),h0tab(:,1646),[32,11,4,16],[nMB,nMB,nMB,nMB],4,1,wf8(:,6))
  call Hloop_AV_Q(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,878),heltab2x64(:,:,1232))
  call Hloop_A_Q(ntryL,G0H32(1),32,nMB,G1H32(302),n2h32(446))
  Gcoeff(:)%j = (c(24)*(M(12,:)%j-M(23,:)%j)) * den(46)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(1647),h0tab(:,1647),[32,11,4,16],[0,0,0,0],4,1,wf8(:,6))
  call Hloop_QV_A(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,879),heltab2x64(:,:,1233))
  call Hloop_Q_A(ntryL,G0H32(1),32,0,G1H32(303),n2h32(447))
  Gcoeff(:)%j = (c(22)*(M(12,:)%j-M(23,:)%j)) * den(46)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(1648),h0tab(:,1648),[32,11,4,16],[nMB,nMB,nMB,nMB],4,1,wf8(:,6))
  call Hloop_QV_A(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,880),heltab2x64(:,:,1234))
  call Hloop_Q_A(ntryL,G0H32(1),32,nMB,G1H32(304),n2h32(448))
  Gcoeff(:)%j = (c(9)*(-M(4,:)%j+M(7,:)%j+M(12,:)%j-M(23,:)%j)+c(7)*(M(27,:)%j-M(28,:)%j+M(29,:)%j-M(30,:)%j-M(35,:)%j &
    +M(36,:)%j)) * den(46)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(1649),h0tab(:,1649),[32,11,4,16],[0,0,0,0],4,1,wf8(:,6))
  call Hloop_DV_C(ntryL,G0H64(1),0,ex6(:),G1H32(305),m3h2x32(:,881),heltab2x64(:,:,1235))
  Gcoeff(:)%j = (c(9)*(-M(4,:)%j+M(7,:)%j+M(12,:)%j-M(23,:)%j)+c(7)*(M(27,:)%j-M(28,:)%j+M(29,:)%j-M(30,:)%j-M(35,:)%j &
    +M(36,:)%j)) * den(46)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(1650),h0tab(:,1650),[32,11,4,16],[0,0,0,0],4,1,wf8(:,6))
  call Hloop_CV_D(ntryL,G0H64(1),0,ex6(:),32,G1H32(306),m3h2x32(:,882),heltab2x64(:,:,1236))
  Gcoeff(:)%j = (c(9)*(M(4,:)%j-M(7,:)%j-M(12,:)%j+M(23,:)%j)+c(7)*(-M(27,:)%j+M(28,:)%j-M(29,:)%j+M(30,:)%j+M(35,:)%j &
    -M(36,:)%j)) * den(46)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(1651),h0tab(:,1651),[32,11,4,16],[0,0,0,0],4,1,wf8(:,6))
  call Hloop_UV_W(ntryL,G0H64(1),0,ex6(:),32,G1H32(307),m3h2x32(:,883),heltab2x64(:,:,1237))
  Gcoeff(:)%j = (c(24)*(-M(6,:)%j+M(8,:)%j)) * den(46)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(1652),h0tab(:,1652),[32,4,11,16],[0,0,0,0],4,1,wf8(:,6))
  call Hloop_QV_A(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,884),heltab2x64(:,:,1238))
  call Hloop_Q_A(ntryL,G0H32(1),32,0,G1H32(308),n2h32(449))
  Gcoeff(:)%j = (c(22)*(-M(6,:)%j+M(8,:)%j)) * den(46)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(1653),h0tab(:,1653),[32,4,11,16],[nMT,nMT,nMT,nMT],4,1,wf8(:,6))
  call Hloop_QV_A(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,885),heltab2x64(:,:,1239))
  call Hloop_Q_A(ntryL,G0H32(1),32,nMT,G1H32(309),n2h32(450))
  Gcoeff(:)%j = (c(24)*(M(10,:)%j-M(17,:)%j)) * den(46)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(1654),h0tab(:,1654),[32,4,11,16],[0,0,0,0],4,1,wf8(:,6))
  call Hloop_AV_Q(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,886),heltab2x64(:,:,1240))
  call Hloop_A_Q(ntryL,G0H32(1),32,0,G1H32(310),n2h32(451))
  Gcoeff(:)%j = (c(22)*(M(10,:)%j-M(17,:)%j)) * den(46)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(1655),h0tab(:,1655),[32,4,11,16],[nMT,nMT,nMT,nMT],4,1,wf8(:,6))
  call Hloop_AV_Q(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,887),heltab2x64(:,:,1241))
  call Hloop_A_Q(ntryL,G0H32(1),32,nMT,G1H32(311),n2h32(452))
  Gcoeff(:)%j = (c(24)*(-M(6,:)%j+M(8,:)%j)) * den(46)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(1656),h0tab(:,1656),[32,4,11,16],[0,0,0,0],4,1,wf8(:,6))
  call Hloop_QV_A(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,888),heltab2x64(:,:,1242))
  call Hloop_Q_A(ntryL,G0H32(1),32,0,G1H32(312),n2h32(453))
  Gcoeff(:)%j = (c(22)*(-M(6,:)%j+M(8,:)%j)) * den(46)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(1657),h0tab(:,1657),[32,4,11,16],[nMB,nMB,nMB,nMB],4,1,wf8(:,6))
  call Hloop_QV_A(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,889),heltab2x64(:,:,1243))
  call Hloop_Q_A(ntryL,G0H32(1),32,nMB,G1H32(313),n2h32(454))
  Gcoeff(:)%j = (c(24)*(M(10,:)%j-M(17,:)%j)) * den(46)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(1658),h0tab(:,1658),[32,4,11,16],[0,0,0,0],4,1,wf8(:,6))
  call Hloop_AV_Q(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,890),heltab2x64(:,:,1244))
  call Hloop_A_Q(ntryL,G0H32(1),32,0,G1H32(314),n2h32(455))
  Gcoeff(:)%j = (c(22)*(M(10,:)%j-M(17,:)%j)) * den(46)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(1659),h0tab(:,1659),[32,4,11,16],[nMB,nMB,nMB,nMB],4,1,wf8(:,6))
  call Hloop_AV_Q(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,891),heltab2x64(:,:,1245))
  call Hloop_A_Q(ntryL,G0H32(1),32,nMB,G1H32(315),n2h32(456))
  Gcoeff(:)%j = (c(9)*(-M(6,:)%j+M(8,:)%j+M(10,:)%j-M(17,:)%j)+c(7)*(M(27,:)%j-M(28,:)%j+M(29,:)%j-M(30,:)%j-M(35,:)%j &
    +M(36,:)%j)) * den(46)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(1660),h0tab(:,1660),[32,4,11,16],[0,0,0,0],4,1,wf8(:,6))
  call Hloop_CV_D(ntryL,G0H64(1),0,ex6(:),32,G1H32(316),m3h2x32(:,892),heltab2x64(:,:,1246))
  Gcoeff(:)%j = (c(9)*(-M(6,:)%j+M(8,:)%j+M(10,:)%j-M(17,:)%j)+c(7)*(M(27,:)%j-M(28,:)%j+M(29,:)%j-M(30,:)%j-M(35,:)%j &
    +M(36,:)%j)) * den(46)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(1661),h0tab(:,1661),[32,4,11,16],[0,0,0,0],4,1,wf8(:,6))
  call Hloop_DV_C(ntryL,G0H64(1),0,ex6(:),G1H32(317),m3h2x32(:,893),heltab2x64(:,:,1247))
  Gcoeff(:)%j = (c(9)*(M(6,:)%j-M(8,:)%j-M(10,:)%j+M(17,:)%j)+c(7)*(-M(27,:)%j+M(28,:)%j-M(29,:)%j+M(30,:)%j+M(35,:)%j &
    -M(36,:)%j)) * den(46)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(1662),h0tab(:,1662),[32,4,11,16],[0,0,0,0],4,1,wf8(:,6))
  call Hloop_UV_W(ntryL,G0H64(1),0,ex6(:),32,G1H32(318),m3h2x32(:,894),heltab2x64(:,:,1248))
  Gcoeff(:)%j = (c(24)*(M(17,:)%j-M(19,:)%j)) * den(40)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(1663),h0tab(:,1663),[32,4,8,19],[0,0,0,0],4,1,wf8(:,10))
  call Hloop_AV_Q(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,895),heltab2x64(:,:,1249))
  call Hloop_A_Q(ntryL,G0H32(1),32,0,G1H32(319),n2h32(457))
  Gcoeff(:)%j = (c(22)*(M(17,:)%j-M(19,:)%j)) * den(40)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(1664),h0tab(:,1664),[32,4,8,19],[nMT,nMT,nMT,nMT],4,1,wf8(:,10))
  call Hloop_AV_Q(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,896),heltab2x64(:,:,1250))
  call Hloop_A_Q(ntryL,G0H32(1),32,nMT,G1H32(320),n2h32(458))
  Gcoeff(:)%j = (c(24)*(-M(8,:)%j+M(15,:)%j)) * den(40)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(1665),h0tab(:,1665),[32,4,8,19],[0,0,0,0],4,1,wf8(:,10))
  call Hloop_QV_A(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,897),heltab2x64(:,:,1251))
  call Hloop_Q_A(ntryL,G0H32(1),32,0,G1H32(321),n2h32(459))
  Gcoeff(:)%j = (c(22)*(-M(8,:)%j+M(15,:)%j)) * den(40)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(1666),h0tab(:,1666),[32,4,8,19],[nMT,nMT,nMT,nMT],4,1,wf8(:,10))
  call Hloop_QV_A(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,898),heltab2x64(:,:,1252))
  call Hloop_Q_A(ntryL,G0H32(1),32,nMT,G1H32(322),n2h32(460))
  Gcoeff(:)%j = (c(24)*(M(17,:)%j-M(19,:)%j)) * den(40)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(1667),h0tab(:,1667),[32,4,8,19],[0,0,0,0],4,1,wf8(:,10))
  call Hloop_AV_Q(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,899),heltab2x64(:,:,1253))
  call Hloop_A_Q(ntryL,G0H32(1),32,0,G1H32(323),n2h32(461))
  Gcoeff(:)%j = (c(22)*(M(17,:)%j-M(19,:)%j)) * den(40)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(1668),h0tab(:,1668),[32,4,8,19],[nMB,nMB,nMB,nMB],4,1,wf8(:,10))
  call Hloop_AV_Q(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,900),heltab2x64(:,:,1254))
  call Hloop_A_Q(ntryL,G0H32(1),32,nMB,G1H32(324),n2h32(462))
  Gcoeff(:)%j = (c(24)*(-M(8,:)%j+M(15,:)%j)) * den(40)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(1669),h0tab(:,1669),[32,4,8,19],[0,0,0,0],4,1,wf8(:,10))
  call Hloop_QV_A(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,901),heltab2x64(:,:,1255))
  call Hloop_Q_A(ntryL,G0H32(1),32,0,G1H32(325),n2h32(463))
  Gcoeff(:)%j = (c(22)*(-M(8,:)%j+M(15,:)%j)) * den(40)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(1670),h0tab(:,1670),[32,4,8,19],[nMB,nMB,nMB,nMB],4,1,wf8(:,10))
  call Hloop_QV_A(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,902),heltab2x64(:,:,1256))
  call Hloop_Q_A(ntryL,G0H32(1),32,nMB,G1H32(326),n2h32(464))
  Gcoeff(:)%j = (c(9)*(-M(8,:)%j+M(15,:)%j+M(17,:)%j-M(19,:)%j)+c(7)*(M(25,:)%j-M(26,:)%j-M(29,:)%j+M(30,:)%j-M(33,:)%j &
    +M(34,:)%j)) * den(40)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(1671),h0tab(:,1671),[32,4,8,19],[0,0,0,0],4,1,wf8(:,10))
  call Hloop_DV_C(ntryL,G0H64(1),0,ex6(:),G1H32(327),m3h2x32(:,903),heltab2x64(:,:,1257))
  Gcoeff(:)%j = (c(9)*(-M(8,:)%j+M(15,:)%j+M(17,:)%j-M(19,:)%j)+c(7)*(M(25,:)%j-M(26,:)%j-M(29,:)%j+M(30,:)%j-M(33,:)%j &
    +M(34,:)%j)) * den(40)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(1672),h0tab(:,1672),[32,4,8,19],[0,0,0,0],4,1,wf8(:,10))
  call Hloop_CV_D(ntryL,G0H64(1),0,ex6(:),32,G1H32(328),m3h2x32(:,904),heltab2x64(:,:,1258))
  Gcoeff(:)%j = (c(9)*(M(8,:)%j-M(15,:)%j-M(17,:)%j+M(19,:)%j)+c(7)*(-M(25,:)%j+M(26,:)%j+M(29,:)%j-M(30,:)%j+M(33,:)%j &
    -M(34,:)%j)) * den(40)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(1673),h0tab(:,1673),[32,4,8,19],[0,0,0,0],4,1,wf8(:,10))
  call Hloop_UV_W(ntryL,G0H64(1),0,ex6(:),32,G1H32(329),m3h2x32(:,905),heltab2x64(:,:,1259))
  Gcoeff(:)%j = (c(24)*(-M(2,:)%j+M(13,:)%j)) * den(40)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(1674),h0tab(:,1674),[32,8,4,19],[0,0,0,0],4,1,wf8(:,10))
  call Hloop_QV_A(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,906),heltab2x64(:,:,1260))
  call Hloop_Q_A(ntryL,G0H32(1),32,0,G1H32(330),n2h32(465))
  Gcoeff(:)%j = (c(22)*(-M(2,:)%j+M(13,:)%j)) * den(40)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(1675),h0tab(:,1675),[32,8,4,19],[nMT,nMT,nMT,nMT],4,1,wf8(:,10))
  call Hloop_QV_A(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,907),heltab2x64(:,:,1261))
  call Hloop_Q_A(ntryL,G0H32(1),32,nMT,G1H32(331),n2h32(466))
  Gcoeff(:)%j = (c(24)*(M(18,:)%j-M(21,:)%j)) * den(40)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(1676),h0tab(:,1676),[32,8,4,19],[0,0,0,0],4,1,wf8(:,10))
  call Hloop_AV_Q(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,908),heltab2x64(:,:,1262))
  call Hloop_A_Q(ntryL,G0H32(1),32,0,G1H32(332),n2h32(467))
  Gcoeff(:)%j = (c(22)*(M(18,:)%j-M(21,:)%j)) * den(40)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(1677),h0tab(:,1677),[32,8,4,19],[nMT,nMT,nMT,nMT],4,1,wf8(:,10))
  call Hloop_AV_Q(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,909),heltab2x64(:,:,1263))
  call Hloop_A_Q(ntryL,G0H32(1),32,nMT,G1H32(333),n2h32(468))
  Gcoeff(:)%j = (c(24)*(-M(2,:)%j+M(13,:)%j)) * den(40)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(1678),h0tab(:,1678),[32,8,4,19],[0,0,0,0],4,1,wf8(:,10))
  call Hloop_QV_A(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,910),heltab2x64(:,:,1264))
  call Hloop_Q_A(ntryL,G0H32(1),32,0,G1H32(334),n2h32(469))
  Gcoeff(:)%j = (c(22)*(-M(2,:)%j+M(13,:)%j)) * den(40)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(1679),h0tab(:,1679),[32,8,4,19],[nMB,nMB,nMB,nMB],4,1,wf8(:,10))
  call Hloop_QV_A(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,911),heltab2x64(:,:,1265))
  call Hloop_Q_A(ntryL,G0H32(1),32,nMB,G1H32(335),n2h32(470))
  Gcoeff(:)%j = (c(24)*(M(18,:)%j-M(21,:)%j)) * den(40)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(1680),h0tab(:,1680),[32,8,4,19],[0,0,0,0],4,1,wf8(:,10))
  call Hloop_AV_Q(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,912),heltab2x64(:,:,1266))
  call Hloop_A_Q(ntryL,G0H32(1),32,0,G1H32(336),n2h32(471))
  Gcoeff(:)%j = (c(22)*(M(18,:)%j-M(21,:)%j)) * den(40)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(1681),h0tab(:,1681),[32,8,4,19],[nMB,nMB,nMB,nMB],4,1,wf8(:,10))
  call Hloop_AV_Q(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,913),heltab2x64(:,:,1267))
  call Hloop_A_Q(ntryL,G0H32(1),32,nMB,G1H32(337),n2h32(472))
  Gcoeff(:)%j = (c(9)*(-M(2,:)%j+M(13,:)%j+M(18,:)%j-M(21,:)%j)+c(7)*(M(25,:)%j-M(26,:)%j-M(29,:)%j+M(30,:)%j-M(33,:)%j &
    +M(34,:)%j)) * den(40)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(1682),h0tab(:,1682),[32,8,4,19],[0,0,0,0],4,1,wf8(:,10))
  call Hloop_CV_D(ntryL,G0H64(1),0,ex6(:),32,G1H32(338),m3h2x32(:,914),heltab2x64(:,:,1268))
  Gcoeff(:)%j = (c(9)*(-M(2,:)%j+M(13,:)%j+M(18,:)%j-M(21,:)%j)+c(7)*(M(25,:)%j-M(26,:)%j-M(29,:)%j+M(30,:)%j-M(33,:)%j &
    +M(34,:)%j)) * den(40)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(1683),h0tab(:,1683),[32,8,4,19],[0,0,0,0],4,1,wf8(:,10))
  call Hloop_DV_C(ntryL,G0H64(1),0,ex6(:),G1H32(339),m3h2x32(:,915),heltab2x64(:,:,1269))
  Gcoeff(:)%j = (c(9)*(M(2,:)%j-M(13,:)%j-M(18,:)%j+M(21,:)%j)+c(7)*(-M(25,:)%j+M(26,:)%j+M(29,:)%j-M(30,:)%j+M(33,:)%j &
    -M(34,:)%j)) * den(40)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(1684),h0tab(:,1684),[32,8,4,19],[0,0,0,0],4,1,wf8(:,10))
  call Hloop_UV_W(ntryL,G0H64(1),0,ex6(:),32,G1H32(340),m3h2x32(:,916),heltab2x64(:,:,1270))
  Gcoeff(:)%j = (c(24)*(-M(5,:)%j+M(14,:)%j)) * den(40)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(1685),h0tab(:,1685),[32,4,19,8],[0,0,0,0],4,1,wf8(:,10))
  call Hloop_QV_A(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,917),heltab2x64(:,:,1271))
  call Hloop_Q_A(ntryL,G0H32(1),32,0,G1H32(341),n2h32(473))
  Gcoeff(:)%j = (c(22)*(-M(5,:)%j+M(14,:)%j)) * den(40)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(1686),h0tab(:,1686),[32,4,19,8],[nMT,nMT,nMT,nMT],4,1,wf8(:,10))
  call Hloop_QV_A(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,918),heltab2x64(:,:,1272))
  call Hloop_Q_A(ntryL,G0H32(1),32,nMT,G1H32(342),n2h32(474))
  Gcoeff(:)%j = (c(24)*(-M(11,:)%j+M(16,:)%j)) * den(40)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(1687),h0tab(:,1687),[32,4,19,8],[0,0,0,0],4,1,wf8(:,10))
  call Hloop_AV_Q(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,919),heltab2x64(:,:,1273))
  call Hloop_A_Q(ntryL,G0H32(1),32,0,G1H32(343),n2h32(475))
  Gcoeff(:)%j = (c(22)*(-M(11,:)%j+M(16,:)%j)) * den(40)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(1688),h0tab(:,1688),[32,4,19,8],[nMT,nMT,nMT,nMT],4,1,wf8(:,10))
  call Hloop_AV_Q(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,920),heltab2x64(:,:,1274))
  call Hloop_A_Q(ntryL,G0H32(1),32,nMT,G1H32(344),n2h32(476))
  Gcoeff(:)%j = (c(24)*(-M(5,:)%j+M(14,:)%j)) * den(40)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(1689),h0tab(:,1689),[32,4,19,8],[0,0,0,0],4,1,wf8(:,10))
  call Hloop_QV_A(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,921),heltab2x64(:,:,1275))
  call Hloop_Q_A(ntryL,G0H32(1),32,0,G1H32(345),n2h32(477))
  Gcoeff(:)%j = (c(22)*(-M(5,:)%j+M(14,:)%j)) * den(40)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(1690),h0tab(:,1690),[32,4,19,8],[nMB,nMB,nMB,nMB],4,1,wf8(:,10))
  call Hloop_QV_A(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,922),heltab2x64(:,:,1276))
  call Hloop_Q_A(ntryL,G0H32(1),32,nMB,G1H32(346),n2h32(478))
  Gcoeff(:)%j = (c(24)*(-M(11,:)%j+M(16,:)%j)) * den(40)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(1691),h0tab(:,1691),[32,4,19,8],[0,0,0,0],4,1,wf8(:,10))
  call Hloop_AV_Q(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,923),heltab2x64(:,:,1277))
  call Hloop_A_Q(ntryL,G0H32(1),32,0,G1H32(347),n2h32(479))
  Gcoeff(:)%j = (c(22)*(-M(11,:)%j+M(16,:)%j)) * den(40)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(1692),h0tab(:,1692),[32,4,19,8],[nMB,nMB,nMB,nMB],4,1,wf8(:,10))
  call Hloop_AV_Q(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,924),heltab2x64(:,:,1278))
  call Hloop_A_Q(ntryL,G0H32(1),32,nMB,G1H32(348),n2h32(480))
  Gcoeff(:)%j = (c(9)*(-M(5,:)%j-M(11,:)%j+M(14,:)%j+M(16,:)%j)+c(7)*(M(25,:)%j-M(26,:)%j-M(29,:)%j+M(30,:)%j-M(33,:)%j &
    +M(34,:)%j)) * den(40)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(1693),h0tab(:,1693),[32,4,19,8],[0,0,0,0],4,1,wf8(:,10))
  call Hloop_CV_D(ntryL,G0H64(1),0,ex6(:),32,G1H32(349),m3h2x32(:,925),heltab2x64(:,:,1279))
  Gcoeff(:)%j = (c(9)*(-M(5,:)%j-M(11,:)%j+M(14,:)%j+M(16,:)%j)+c(7)*(M(25,:)%j-M(26,:)%j-M(29,:)%j+M(30,:)%j-M(33,:)%j &
    +M(34,:)%j)) * den(40)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(1694),h0tab(:,1694),[32,4,19,8],[0,0,0,0],4,1,wf8(:,10))
  call Hloop_DV_C(ntryL,G0H64(1),0,ex6(:),G1H32(350),m3h2x32(:,926),heltab2x64(:,:,1280))
  Gcoeff(:)%j = (c(9)*(M(5,:)%j+M(11,:)%j-M(14,:)%j-M(16,:)%j)+c(7)*(-M(25,:)%j+M(26,:)%j+M(29,:)%j-M(30,:)%j+M(33,:)%j &
    -M(34,:)%j)) * den(40)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(1695),h0tab(:,1695),[32,4,19,8],[0,0,0,0],4,1,wf8(:,10))
  call Hloop_UV_W(ntryL,G0H64(1),0,ex6(:),32,G1H32(351),m3h2x32(:,927),heltab2x64(:,:,1281))
  Gcoeff(:)%j = (c(24)*(-M(13,:)%j+M(23,:)%j)) * den(222)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(1696),h0tab(:,1696),[35,8,4,16],[0,0,0,0],4,1,wf8(:,14))
  call Hloop_QV_A(ntryL,G0H64(1),wf8(:,14),G0H8(91),m3h8x8(:,55),heltab2x64(:,:,1282))
  call Hloop_Q_A(ntryL,G0H8(91),35,0,G1H8(1135),n2h8(1341))
  Gcoeff(:)%j = (c(22)*(-M(13,:)%j+M(23,:)%j)) * den(222)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(1697),h0tab(:,1697),[35,8,4,16],[nMT,nMT,nMT,nMT],4,1,wf8(:,14))
  call Hloop_QV_A(ntryL,G0H64(1),wf8(:,14),G0H8(91),m3h8x8(:,56),heltab2x64(:,:,1283))
  call Hloop_Q_A(ntryL,G0H8(91),35,nMT,G1H8(1136),n2h8(1342))
  Gcoeff(:)%j = (c(24)*(-M(7,:)%j+M(21,:)%j)) * den(222)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(1698),h0tab(:,1698),[35,8,4,16],[0,0,0,0],4,1,wf8(:,14))
  call Hloop_AV_Q(ntryL,G0H64(1),wf8(:,14),G0H8(91),m3h8x8(:,57),heltab2x64(:,:,1284))
  call Hloop_A_Q(ntryL,G0H8(91),35,0,G1H8(1151),n2h8(1343))
  Gcoeff(:)%j = (c(22)*(-M(7,:)%j+M(21,:)%j)) * den(222)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(1699),h0tab(:,1699),[35,8,4,16],[nMT,nMT,nMT,nMT],4,1,wf8(:,14))
  call Hloop_AV_Q(ntryL,G0H64(1),wf8(:,14),G0H8(91),m3h8x8(:,58),heltab2x64(:,:,1285))
  call Hloop_A_Q(ntryL,G0H8(91),35,nMT,G1H8(1152),n2h8(1344))
  Gcoeff(:)%j = (c(24)*(-M(13,:)%j+M(23,:)%j)) * den(222)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(1700),h0tab(:,1700),[35,8,4,16],[0,0,0,0],4,1,wf8(:,14))
  call Hloop_QV_A(ntryL,G0H64(1),wf8(:,14),G0H8(91),m3h8x8(:,59),heltab2x64(:,:,1286))
  call Hloop_Q_A(ntryL,G0H8(91),35,0,G1H8(1167),n2h8(1345))
  Gcoeff(:)%j = (c(22)*(-M(13,:)%j+M(23,:)%j)) * den(222)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(1701),h0tab(:,1701),[35,8,4,16],[nMB,nMB,nMB,nMB],4,1,wf8(:,14))
  call Hloop_QV_A(ntryL,G0H64(1),wf8(:,14),G0H8(91),m3h8x8(:,60),heltab2x64(:,:,1287))
  call Hloop_Q_A(ntryL,G0H8(91),35,nMB,G1H8(1168),n2h8(1346))
  Gcoeff(:)%j = (c(24)*(-M(7,:)%j+M(21,:)%j)) * den(222)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(1702),h0tab(:,1702),[35,8,4,16],[0,0,0,0],4,1,wf8(:,14))
  call Hloop_AV_Q(ntryL,G0H64(1),wf8(:,14),G0H8(91),m3h8x8(:,61),heltab2x64(:,:,1288))
  call Hloop_A_Q(ntryL,G0H8(91),35,0,G1H8(1183),n2h8(1347))
  Gcoeff(:)%j = (c(22)*(-M(7,:)%j+M(21,:)%j)) * den(222)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(1703),h0tab(:,1703),[35,8,4,16],[nMB,nMB,nMB,nMB],4,1,wf8(:,14))
  call Hloop_AV_Q(ntryL,G0H64(1),wf8(:,14),G0H8(91),m3h8x8(:,62),heltab2x64(:,:,1289))
  call Hloop_A_Q(ntryL,G0H8(91),35,nMB,G1H8(1184),n2h8(1348))
  Gcoeff(:)%j = (c(9)*(-M(7,:)%j-M(13,:)%j+M(21,:)%j+M(23,:)%j)+c(7)*(-M(25,:)%j+M(26,:)%j-M(27,:)%j+M(28,:)%j-M(31,:)%j &
    +M(32,:)%j)) * den(222)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(1704),h0tab(:,1704),[35,8,4,16],[0,0,0,0],4,1,wf8(:,14))
  call Hloop_CV_D(ntryL,G0H64(1),0,wf8(:,14),35,G1H8(1199),m3h8x8(:,63),heltab2x64(:,:,1290))
  Gcoeff(:)%j = (c(9)*(-M(7,:)%j-M(13,:)%j+M(21,:)%j+M(23,:)%j)+c(7)*(-M(25,:)%j+M(26,:)%j-M(27,:)%j+M(28,:)%j-M(31,:)%j &
    +M(32,:)%j)) * den(222)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(1705),h0tab(:,1705),[35,8,4,16],[0,0,0,0],4,1,wf8(:,14))
  call Hloop_DV_C(ntryL,G0H64(1),0,wf8(:,14),G1H8(1200),m3h8x8(:,64),heltab2x64(:,:,1291))
  Gcoeff(:)%j = (c(9)*(M(7,:)%j+M(13,:)%j-M(21,:)%j-M(23,:)%j)+c(7)*(M(25,:)%j-M(26,:)%j+M(27,:)%j-M(28,:)%j+M(31,:)%j &
    -M(32,:)%j)) * den(222)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(1706),h0tab(:,1706),[35,8,4,16],[0,0,0,0],4,1,wf8(:,14))
  call Hloop_UV_W(ntryL,G0H64(1),0,wf8(:,14),35,G1H8(1215),m3h8x8(:,65),heltab2x64(:,:,1292))
  Gcoeff(:)%j = (c(24)*(-M(1,:)%j+M(19,:)%j)) * den(222)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(1707),h0tab(:,1707),[35,4,8,16],[0,0,0,0],4,1,wf8(:,14))
  call Hloop_AV_Q(ntryL,G0H64(1),wf8(:,14),G0H8(91),m3h8x8(:,66),heltab2x64(:,:,1293))
  call Hloop_A_Q(ntryL,G0H8(91),35,0,G1H8(1216),n2h8(1349))
  Gcoeff(:)%j = (c(22)*(-M(1,:)%j+M(19,:)%j)) * den(222)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(1708),h0tab(:,1708),[35,4,8,16],[nMT,nMT,nMT,nMT],4,1,wf8(:,14))
  call Hloop_AV_Q(ntryL,G0H64(1),wf8(:,14),G0H8(91),m3h8x8(:,67),heltab2x64(:,:,1294))
  call Hloop_A_Q(ntryL,G0H8(91),35,nMT,G1H8(1231),n2h8(1350))
  Gcoeff(:)%j = (c(24)*(-M(15,:)%j+M(24,:)%j)) * den(222)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(1709),h0tab(:,1709),[35,4,8,16],[0,0,0,0],4,1,wf8(:,14))
  call Hloop_QV_A(ntryL,G0H64(1),wf8(:,14),G0H8(91),m3h8x8(:,68),heltab2x64(:,:,1295))
  call Hloop_Q_A(ntryL,G0H8(91),35,0,G1H8(1232),n2h8(1351))
  Gcoeff(:)%j = (c(22)*(-M(15,:)%j+M(24,:)%j)) * den(222)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(1710),h0tab(:,1710),[35,4,8,16],[nMT,nMT,nMT,nMT],4,1,wf8(:,14))
  call Hloop_QV_A(ntryL,G0H64(1),wf8(:,14),G0H8(91),m3h8x8(:,69),heltab2x64(:,:,1296))
  call Hloop_Q_A(ntryL,G0H8(91),35,nMT,G1H8(1247),n2h8(1352))
  Gcoeff(:)%j = (c(24)*(-M(1,:)%j+M(19,:)%j)) * den(222)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(1711),h0tab(:,1711),[35,4,8,16],[0,0,0,0],4,1,wf8(:,14))
  call Hloop_AV_Q(ntryL,G0H64(1),wf8(:,14),G0H8(91),m3h8x8(:,70),heltab2x64(:,:,1297))
  call Hloop_A_Q(ntryL,G0H8(91),35,0,G1H8(1248),n2h8(1353))
  Gcoeff(:)%j = (c(22)*(-M(1,:)%j+M(19,:)%j)) * den(222)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(1712),h0tab(:,1712),[35,4,8,16],[nMB,nMB,nMB,nMB],4,1,wf8(:,14))
  call Hloop_AV_Q(ntryL,G0H64(1),wf8(:,14),G0H8(91),m3h8x8(:,71),heltab2x64(:,:,1298))
  call Hloop_A_Q(ntryL,G0H8(91),35,nMB,G1H8(1263),n2h8(1354))
  Gcoeff(:)%j = (c(24)*(-M(15,:)%j+M(24,:)%j)) * den(222)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(1713),h0tab(:,1713),[35,4,8,16],[0,0,0,0],4,1,wf8(:,14))
  call Hloop_QV_A(ntryL,G0H64(1),wf8(:,14),G0H8(91),m3h8x8(:,72),heltab2x64(:,:,1299))
  call Hloop_Q_A(ntryL,G0H8(91),35,0,G1H8(1264),n2h8(1355))
  Gcoeff(:)%j = (c(22)*(-M(15,:)%j+M(24,:)%j)) * den(222)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(1714),h0tab(:,1714),[35,4,8,16],[nMB,nMB,nMB,nMB],4,1,wf8(:,14))
  call Hloop_QV_A(ntryL,G0H64(1),wf8(:,14),G0H8(91),m3h8x8(:,73),heltab2x64(:,:,1300))
  call Hloop_Q_A(ntryL,G0H8(91),35,nMB,G1H8(1279),n2h8(1356))
  Gcoeff(:)%j = (c(9)*(-M(1,:)%j-M(15,:)%j+M(19,:)%j+M(24,:)%j)+c(7)*(-M(25,:)%j+M(26,:)%j-M(27,:)%j+M(28,:)%j-M(31,:)%j &
    +M(32,:)%j)) * den(222)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(1715),h0tab(:,1715),[35,4,8,16],[0,0,0,0],4,1,wf8(:,14))
  call Hloop_DV_C(ntryL,G0H64(1),0,wf8(:,14),G1H8(1280),m3h8x8(:,74),heltab2x64(:,:,1301))
  Gcoeff(:)%j = (c(9)*(-M(1,:)%j-M(15,:)%j+M(19,:)%j+M(24,:)%j)+c(7)*(-M(25,:)%j+M(26,:)%j-M(27,:)%j+M(28,:)%j-M(31,:)%j &
    +M(32,:)%j)) * den(222)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(1716),h0tab(:,1716),[35,4,8,16],[0,0,0,0],4,1,wf8(:,14))
  call Hloop_CV_D(ntryL,G0H64(1),0,wf8(:,14),35,G1H8(1295),m3h8x8(:,75),heltab2x64(:,:,1302))
  Gcoeff(:)%j = (c(9)*(M(1,:)%j+M(15,:)%j-M(19,:)%j-M(24,:)%j)+c(7)*(M(25,:)%j-M(26,:)%j+M(27,:)%j-M(28,:)%j+M(31,:)%j &
    -M(32,:)%j)) * den(222)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(1717),h0tab(:,1717),[35,4,8,16],[0,0,0,0],4,1,wf8(:,14))
  call Hloop_UV_W(ntryL,G0H64(1),0,wf8(:,14),35,G1H8(1296),m3h8x8(:,76),heltab2x64(:,:,1303))
  Gcoeff(:)%j = (c(24)*(-M(3,:)%j+M(20,:)%j)) * den(222)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(1718),h0tab(:,1718),[35,4,16,8],[0,0,0,0],4,1,wf8(:,14))
  call Hloop_AV_Q(ntryL,G0H64(1),wf8(:,14),G0H8(91),m3h8x8(:,77),heltab2x64(:,:,1304))
  call Hloop_A_Q(ntryL,G0H8(91),35,0,G1H8(1311),n2h8(1357))
  Gcoeff(:)%j = (c(22)*(-M(3,:)%j+M(20,:)%j)) * den(222)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(1719),h0tab(:,1719),[35,4,16,8],[nMT,nMT,nMT,nMT],4,1,wf8(:,14))
  call Hloop_AV_Q(ntryL,G0H64(1),wf8(:,14),G0H8(91),m3h8x8(:,78),heltab2x64(:,:,1305))
  call Hloop_A_Q(ntryL,G0H8(91),35,nMT,G1H8(1312),n2h8(1358))
  Gcoeff(:)%j = (c(24)*(-M(9,:)%j+M(22,:)%j)) * den(222)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(1720),h0tab(:,1720),[35,4,16,8],[0,0,0,0],4,1,wf8(:,14))
  call Hloop_QV_A(ntryL,G0H64(1),wf8(:,14),G0H8(91),m3h8x8(:,79),heltab2x64(:,:,1306))
  call Hloop_Q_A(ntryL,G0H8(91),35,0,G1H8(1327),n2h8(1359))
  Gcoeff(:)%j = (c(22)*(-M(9,:)%j+M(22,:)%j)) * den(222)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(1721),h0tab(:,1721),[35,4,16,8],[nMT,nMT,nMT,nMT],4,1,wf8(:,14))



end subroutine vamp_17

end module ol_vamp_17_ppttjj_ttxgggg_1_/**/REALKIND
