! 2
! The number above is the number of vamp routines for this process.
! This is needed by the build system.

#if 3 > 1
#ifndef USE_CHECK_qp
#define DUMMY_qp
#endif
#else
#ifndef USE_qp
#define DUMMY_qp
#endif
#endif

module ol_vamp_ppttjj_uuxttxddx_1_/**/REALKIND

  contains

! **********************************************************************
subroutine redbaseconstr() 
! **********************************************************************
  use KIND_TYPES, only: REALKIND 
  use ol_data_types_/**/REALKIND, only: basis 
  use ol_momenta_decl_/**/REALKIND, only: Q 
  use ol_parameters_decl_/**/QREALKIND ! masses 
  use ol_tensor_sum_storage_ppttjj_uuxttxddx_1_/**/REALKIND 
  use ofred_basis_construction_/**/REALKIND, only: construct_RedBasis, construct_redset4 
use ofred_basis_construction_/**/REALKIND, only: construct_redset5 
  implicit none

  ! Define mass sets for reduction 
mass5set(0:4,1) = [0,0,nMT,0,0]
mass5set(0:4,2) = [0,0,0,0,nMT]
mass5set(0:4,3) = [0,0,0,0,0]
mass5set(0:4,4) = [0,0,0,nMT,0]
mass5set(0:4,5) = [0,0,nMT,nMT,0]
mass5set(0:4,6) = [nMT,nMT,0,0,0]
mass5set(0:4,7) = [0,nMT,0,0,0]
mass4set(0:3,1) = [0,0,0,nMT]
mass4set(0:3,2) = [0,0,0,0]
mass4set(0:3,3) = [0,0,nMT,nMT]
mass4set(0:3,4) = [nMT,nMT,0,0]
mass4set(0:3,5) = [nMT,nMT,nMT,0]
mass4set(0:3,6) = [0,0,nMT,0]
mass4set(0:3,7) = [0,nMT,0,0]
mass4set(0:3,8) = [nMT,0,0,0]
mass4set(0:3,9) = [0,nMT,nMT,0]
mass3set(0:2,1) = [0,0,0]
mass3set(0:2,2) = [0,0,nMT]
mass3set(0:2,3) = [0,nMT,0]
mass3set(0:2,4) = [nMT,nMT,0]
mass3set(0:2,5) = [0,nMT,nMT]
mass3set(0:2,6) = [nMT,nMT,nMT]
mass3set(0:2,7) = [nMT,0,0]
mass3set(0:2,8) = [nMT,0,nMT]
mass3set(0:2,9) = [nMB,nMB,nMB]
mass2set(0:1,1) = [0,0]
mass2set(0:1,2) = [nMT,nMT]
mass2set(0:1,3) = [nMB,nMB]
mass2set(0:1,4) = [0,nMT]
mass2set(0:1,5) = [nMT,0]


  ! Compute reduction bases from external momentum pairs p1, p2 (in light cone rep) 
call construct_RedBasis(32,40,RedBasis(1))
call construct_RedBasis(32,44,RedBasis(2))
call construct_RedBasis(32,45,RedBasis(3))
call construct_RedBasis(40,44,RedBasis(4))
call construct_RedBasis(40,45,RedBasis(5))
call construct_RedBasis(44,45,RedBasis(6))
call construct_RedBasis(32,34,RedBasis(7))
call construct_RedBasis(32,35,RedBasis(8))
call construct_RedBasis(32,39,RedBasis(9))
call construct_RedBasis(34,35,RedBasis(10))
call construct_RedBasis(34,39,RedBasis(11))
call construct_RedBasis(35,39,RedBasis(12))
call construct_RedBasis(32,36,RedBasis(13))
call construct_RedBasis(36,44,RedBasis(14))
call construct_RedBasis(36,45,RedBasis(15))
call construct_RedBasis(32,43,RedBasis(16))
call construct_RedBasis(34,43,RedBasis(17))
call construct_RedBasis(35,43,RedBasis(18))
call construct_RedBasis(32,46,RedBasis(19))
call construct_RedBasis(40,46,RedBasis(20))
call construct_RedBasis(44,46,RedBasis(21))
call construct_RedBasis(36,46,RedBasis(22))
call construct_RedBasis(32,33,RedBasis(23))
call construct_RedBasis(33,35,RedBasis(24))
call construct_RedBasis(33,39,RedBasis(25))
call construct_RedBasis(33,43,RedBasis(26))
call construct_RedBasis(44,47,RedBasis(27))
call construct_RedBasis(45,47,RedBasis(28))
call construct_RedBasis(40,47,RedBasis(29))
call construct_RedBasis(4,5,RedBasis(30))
call construct_RedBasis(4,7,RedBasis(31))
call construct_RedBasis(5,7,RedBasis(32))
call construct_RedBasis(32,47,RedBasis(33))
call construct_RedBasis(12,13,RedBasis(34))
call construct_RedBasis(12,15,RedBasis(35))
call construct_RedBasis(13,15,RedBasis(36))
call construct_RedBasis(8,13,RedBasis(37))
call construct_RedBasis(8,15,RedBasis(38))
call construct_RedBasis(8,12,RedBasis(39))
call construct_RedBasis(35,47,RedBasis(40))
call construct_RedBasis(39,47,RedBasis(41))
call construct_RedBasis(34,47,RedBasis(42))
call construct_RedBasis(1,5,RedBasis(43))
call construct_RedBasis(1,13,RedBasis(44))
call construct_RedBasis(5,13,RedBasis(45))
call construct_RedBasis(3,7,RedBasis(46))
call construct_RedBasis(3,15,RedBasis(47))
call construct_RedBasis(7,15,RedBasis(48))
call construct_RedBasis(2,7,RedBasis(49))
call construct_RedBasis(2,15,RedBasis(50))
call construct_RedBasis(2,3,RedBasis(51))
call construct_RedBasis(36,47,RedBasis(52))
call construct_RedBasis(8,9,RedBasis(53))
call construct_RedBasis(8,11,RedBasis(54))
call construct_RedBasis(9,11,RedBasis(55))
call construct_RedBasis(4,13,RedBasis(56))
call construct_RedBasis(4,15,RedBasis(57))
call construct_RedBasis(4,12,RedBasis(58))
call construct_RedBasis(43,47,RedBasis(59))
call construct_RedBasis(1,9,RedBasis(60))
call construct_RedBasis(9,13,RedBasis(61))
call construct_RedBasis(3,11,RedBasis(62))
call construct_RedBasis(11,15,RedBasis(63))
call construct_RedBasis(2,11,RedBasis(64))
call construct_RedBasis(46,47,RedBasis(65))
call construct_RedBasis(4,6,RedBasis(66))
call construct_RedBasis(6,7,RedBasis(67))
call construct_RedBasis(12,14,RedBasis(68))
call construct_RedBasis(14,15,RedBasis(69))
call construct_RedBasis(8,14,RedBasis(70))
call construct_RedBasis(8,10,RedBasis(71))
call construct_RedBasis(10,11,RedBasis(72))
call construct_RedBasis(4,14,RedBasis(73))
call construct_RedBasis(33,47,RedBasis(74))
call construct_RedBasis(2,6,RedBasis(75))
call construct_RedBasis(2,14,RedBasis(76))
call construct_RedBasis(6,14,RedBasis(77))
call construct_RedBasis(1,7,RedBasis(78))
call construct_RedBasis(1,15,RedBasis(79))
call construct_RedBasis(1,3,RedBasis(80))
call construct_RedBasis(2,10,RedBasis(81))
call construct_RedBasis(10,14,RedBasis(82))
call construct_RedBasis(1,11,RedBasis(83))
call construct_RedBasis(32,51,RedBasis(84))
call construct_RedBasis(32,55,RedBasis(85))
call construct_RedBasis(35,51,RedBasis(86))
call construct_RedBasis(35,55,RedBasis(87))
call construct_RedBasis(51,55,RedBasis(88))
call construct_RedBasis(32,59,RedBasis(89))
call construct_RedBasis(35,59,RedBasis(90))
call construct_RedBasis(51,59,RedBasis(91))
call construct_RedBasis(48,50,RedBasis(92))
call construct_RedBasis(48,51,RedBasis(93))
call construct_RedBasis(48,55,RedBasis(94))
call construct_RedBasis(50,51,RedBasis(95))
call construct_RedBasis(50,55,RedBasis(96))
call construct_RedBasis(48,59,RedBasis(97))
call construct_RedBasis(50,59,RedBasis(98))
call construct_RedBasis(48,49,RedBasis(99))
call construct_RedBasis(49,51,RedBasis(100))
call construct_RedBasis(49,55,RedBasis(101))
call construct_RedBasis(49,59,RedBasis(102))
call construct_RedBasis(40,43,RedBasis(103))
call construct_RedBasis(36,39,RedBasis(104))
call construct_RedBasis(34,51,RedBasis(105))
call construct_RedBasis(33,51,RedBasis(106))
call construct_RedBasis(34,46,RedBasis(107))
call construct_RedBasis(33,45,RedBasis(108))
call construct_RedBasis(48,52,RedBasis(109))
call construct_RedBasis(48,53,RedBasis(110))
call construct_RedBasis(52,53,RedBasis(111))
call construct_RedBasis(52,55,RedBasis(112))
call construct_RedBasis(53,55,RedBasis(113))
call construct_RedBasis(48,54,RedBasis(114))
call construct_RedBasis(52,54,RedBasis(115))
call construct_RedBasis(54,55,RedBasis(116))
call construct_RedBasis(48,61,RedBasis(117))
call construct_RedBasis(49,53,RedBasis(118))
call construct_RedBasis(49,61,RedBasis(119))
call construct_RedBasis(53,61,RedBasis(120))
call construct_RedBasis(48,57,RedBasis(121))
call construct_RedBasis(49,57,RedBasis(122))
call construct_RedBasis(57,61,RedBasis(123))
call construct_RedBasis(48,56,RedBasis(124))
call construct_RedBasis(48,60,RedBasis(125))
call construct_RedBasis(56,60,RedBasis(126))
call construct_RedBasis(56,61,RedBasis(127))
call construct_RedBasis(60,61,RedBasis(128))
call construct_RedBasis(52,60,RedBasis(129))
call construct_RedBasis(52,61,RedBasis(130))
call construct_RedBasis(48,62,RedBasis(131))
call construct_RedBasis(56,62,RedBasis(132))
call construct_RedBasis(60,62,RedBasis(133))
call construct_RedBasis(52,62,RedBasis(134))
call construct_RedBasis(3,19,RedBasis(135))
call construct_RedBasis(3,23,RedBasis(136))
call construct_RedBasis(19,23,RedBasis(137))
call construct_RedBasis(3,27,RedBasis(138))
call construct_RedBasis(19,27,RedBasis(139))
call construct_RedBasis(2,19,RedBasis(140))
call construct_RedBasis(1,19,RedBasis(141))
call construct_RedBasis(56,59,RedBasis(142))
call construct_RedBasis(50,62,RedBasis(143))
call construct_RedBasis(56,58,RedBasis(144))
call construct_RedBasis(58,59,RedBasis(145))
call construct_RedBasis(56,57,RedBasis(146))
call construct_RedBasis(57,59,RedBasis(147))
call construct_RedBasis(40,59,RedBasis(148))
call construct_RedBasis(43,59,RedBasis(149))
call construct_RedBasis(36,55,RedBasis(150))
call construct_RedBasis(39,55,RedBasis(151))
call construct_RedBasis(50,58,RedBasis(152))
call construct_RedBasis(58,62,RedBasis(153))
call construct_RedBasis(50,54,RedBasis(154))
call construct_RedBasis(54,62,RedBasis(155))


  ! Compute scalars depending on a third momentum p3 (in light cone rep) 
call construct_redset5(32, 40, 44, 45, RedBasis(1), RedBasis(2), & 
 RedBasis(3), RedBasis(4),RedBasis(5), RedBasis(6), RedSet_5(1))
call construct_redset5(32, 34, 35, 39, RedBasis(7), RedBasis(8), & 
 RedBasis(9), RedBasis(10),RedBasis(11), RedBasis(12), RedSet_5(2))
call construct_redset5(32, 36, 44, 45, RedBasis(13), RedBasis(2), & 
 RedBasis(3), RedBasis(14),RedBasis(15), RedBasis(6), RedSet_5(3))
call construct_redset5(32, 34, 35, 43, RedBasis(7), RedBasis(8), & 
 RedBasis(16), RedBasis(10),RedBasis(17), RedBasis(18), RedSet_5(4))
call construct_redset5(32, 40, 44, 46, RedBasis(1), RedBasis(2), & 
 RedBasis(19), RedBasis(4),RedBasis(20), RedBasis(21), RedSet_5(5))
call construct_redset5(32, 36, 44, 46, RedBasis(13), RedBasis(2), & 
 RedBasis(19), RedBasis(14),RedBasis(22), RedBasis(21), RedSet_5(6))
call construct_redset5(32, 33, 35, 39, RedBasis(23), RedBasis(8), & 
 RedBasis(9), RedBasis(24),RedBasis(25), RedBasis(12), RedSet_5(7))
call construct_redset5(32, 33, 35, 43, RedBasis(23), RedBasis(8), & 
 RedBasis(16), RedBasis(24),RedBasis(26), RedBasis(18), RedSet_5(8))
call construct_redset4(44,45,47,RedBasis(6),RedBasis(27),RedBasis(28),RedSet_4(1))
call construct_redset4(40,45,47,RedBasis(5),RedBasis(29),RedBasis(28),RedSet_4(2))
call construct_redset4(40,44,47,RedBasis(4),RedBasis(29),RedBasis(27),RedSet_4(3))
call construct_redset4(40,44,45,RedBasis(4),RedBasis(5),RedBasis(6),RedSet_4(4))
call construct_redset4(4,5,7,RedBasis(30),RedBasis(31),RedBasis(32),RedSet_4(5))
call construct_redset4(32,45,47,RedBasis(3),RedBasis(33),RedBasis(28),RedSet_4(6))
call construct_redset4(32,44,47,RedBasis(2),RedBasis(33),RedBasis(27),RedSet_4(7))
call construct_redset4(32,44,45,RedBasis(2),RedBasis(3),RedBasis(6),RedSet_4(8))
call construct_redset4(12,13,15,RedBasis(34),RedBasis(35),RedBasis(36),RedSet_4(9))
call construct_redset4(32,40,47,RedBasis(1),RedBasis(33),RedBasis(29),RedSet_4(10))
call construct_redset4(32,40,45,RedBasis(1),RedBasis(3),RedBasis(5),RedSet_4(11))
call construct_redset4(8,13,15,RedBasis(37),RedBasis(38),RedBasis(36),RedSet_4(12))
call construct_redset4(32,40,44,RedBasis(1),RedBasis(2),RedBasis(4),RedSet_4(13))
call construct_redset4(8,12,15,RedBasis(39),RedBasis(38),RedBasis(35),RedSet_4(14))
call construct_redset4(8,12,13,RedBasis(39),RedBasis(37),RedBasis(34),RedSet_4(15))
call construct_redset4(35,39,47,RedBasis(12),RedBasis(40),RedBasis(41),RedSet_4(16))
call construct_redset4(34,39,47,RedBasis(11),RedBasis(42),RedBasis(41),RedSet_4(17))
call construct_redset4(34,35,47,RedBasis(10),RedBasis(42),RedBasis(40),RedSet_4(18))
call construct_redset4(34,35,39,RedBasis(10),RedBasis(11),RedBasis(12),RedSet_4(19))
call construct_redset4(1,5,13,RedBasis(43),RedBasis(44),RedBasis(45),RedSet_4(20))
call construct_redset4(32,39,47,RedBasis(9),RedBasis(33),RedBasis(41),RedSet_4(21))
call construct_redset4(32,35,47,RedBasis(8),RedBasis(33),RedBasis(40),RedSet_4(22))
call construct_redset4(32,35,39,RedBasis(8),RedBasis(9),RedBasis(12),RedSet_4(23))
call construct_redset4(3,7,15,RedBasis(46),RedBasis(47),RedBasis(48),RedSet_4(24))
call construct_redset4(32,34,47,RedBasis(7),RedBasis(33),RedBasis(42),RedSet_4(25))
call construct_redset4(32,34,39,RedBasis(7),RedBasis(9),RedBasis(11),RedSet_4(26))
call construct_redset4(2,7,15,RedBasis(49),RedBasis(50),RedBasis(48),RedSet_4(27))
call construct_redset4(32,34,35,RedBasis(7),RedBasis(8),RedBasis(10),RedSet_4(28))
call construct_redset4(2,3,15,RedBasis(51),RedBasis(50),RedBasis(47),RedSet_4(29))
call construct_redset4(2,3,7,RedBasis(51),RedBasis(49),RedBasis(46),RedSet_4(30))
call construct_redset4(36,45,47,RedBasis(15),RedBasis(52),RedBasis(28),RedSet_4(31))
call construct_redset4(36,44,47,RedBasis(14),RedBasis(52),RedBasis(27),RedSet_4(32))
call construct_redset4(36,44,45,RedBasis(14),RedBasis(15),RedBasis(6),RedSet_4(33))
call construct_redset4(8,9,11,RedBasis(53),RedBasis(54),RedBasis(55),RedSet_4(34))
call construct_redset4(32,36,47,RedBasis(13),RedBasis(33),RedBasis(52),RedSet_4(35))
call construct_redset4(32,36,45,RedBasis(13),RedBasis(3),RedBasis(15),RedSet_4(36))
call construct_redset4(4,13,15,RedBasis(56),RedBasis(57),RedBasis(36),RedSet_4(37))
call construct_redset4(32,36,44,RedBasis(13),RedBasis(2),RedBasis(14),RedSet_4(38))
call construct_redset4(4,12,15,RedBasis(58),RedBasis(57),RedBasis(35),RedSet_4(39))
call construct_redset4(4,12,13,RedBasis(58),RedBasis(56),RedBasis(34),RedSet_4(40))
call construct_redset4(35,43,47,RedBasis(18),RedBasis(40),RedBasis(59),RedSet_4(41))
call construct_redset4(34,43,47,RedBasis(17),RedBasis(42),RedBasis(59),RedSet_4(42))
call construct_redset4(34,35,43,RedBasis(10),RedBasis(17),RedBasis(18),RedSet_4(43))
call construct_redset4(1,9,13,RedBasis(60),RedBasis(44),RedBasis(61),RedSet_4(44))
call construct_redset4(32,43,47,RedBasis(16),RedBasis(33),RedBasis(59),RedSet_4(45))
call construct_redset4(32,35,43,RedBasis(8),RedBasis(16),RedBasis(18),RedSet_4(46))
call construct_redset4(3,11,15,RedBasis(62),RedBasis(47),RedBasis(63),RedSet_4(47))
call construct_redset4(32,34,43,RedBasis(7),RedBasis(16),RedBasis(17),RedSet_4(48))
call construct_redset4(2,11,15,RedBasis(64),RedBasis(50),RedBasis(63),RedSet_4(49))
call construct_redset4(2,3,11,RedBasis(51),RedBasis(64),RedBasis(62),RedSet_4(50))
call construct_redset4(44,46,47,RedBasis(21),RedBasis(27),RedBasis(65),RedSet_4(51))
call construct_redset4(40,46,47,RedBasis(20),RedBasis(29),RedBasis(65),RedSet_4(52))
call construct_redset4(40,44,46,RedBasis(4),RedBasis(20),RedBasis(21),RedSet_4(53))
call construct_redset4(4,6,7,RedBasis(66),RedBasis(31),RedBasis(67),RedSet_4(54))
call construct_redset4(32,46,47,RedBasis(19),RedBasis(33),RedBasis(65),RedSet_4(55))
call construct_redset4(32,44,46,RedBasis(2),RedBasis(19),RedBasis(21),RedSet_4(56))
call construct_redset4(12,14,15,RedBasis(68),RedBasis(35),RedBasis(69),RedSet_4(57))
call construct_redset4(32,40,46,RedBasis(1),RedBasis(19),RedBasis(20),RedSet_4(58))
call construct_redset4(8,14,15,RedBasis(70),RedBasis(38),RedBasis(69),RedSet_4(59))
call construct_redset4(8,12,14,RedBasis(39),RedBasis(70),RedBasis(68),RedSet_4(60))
call construct_redset4(36,46,47,RedBasis(22),RedBasis(52),RedBasis(65),RedSet_4(61))
call construct_redset4(36,44,46,RedBasis(14),RedBasis(22),RedBasis(21),RedSet_4(62))
call construct_redset4(8,10,11,RedBasis(71),RedBasis(54),RedBasis(72),RedSet_4(63))
call construct_redset4(32,36,46,RedBasis(13),RedBasis(19),RedBasis(22),RedSet_4(64))
call construct_redset4(4,14,15,RedBasis(73),RedBasis(57),RedBasis(69),RedSet_4(65))
call construct_redset4(4,12,14,RedBasis(58),RedBasis(73),RedBasis(68),RedSet_4(66))
call construct_redset4(33,39,47,RedBasis(25),RedBasis(74),RedBasis(41),RedSet_4(67))
call construct_redset4(33,35,47,RedBasis(24),RedBasis(74),RedBasis(40),RedSet_4(68))
call construct_redset4(33,35,39,RedBasis(24),RedBasis(25),RedBasis(12),RedSet_4(69))
call construct_redset4(2,6,14,RedBasis(75),RedBasis(76),RedBasis(77),RedSet_4(70))
call construct_redset4(32,33,47,RedBasis(23),RedBasis(33),RedBasis(74),RedSet_4(71))
call construct_redset4(32,33,39,RedBasis(23),RedBasis(9),RedBasis(25),RedSet_4(72))
call construct_redset4(1,7,15,RedBasis(78),RedBasis(79),RedBasis(48),RedSet_4(73))
call construct_redset4(32,33,35,RedBasis(23),RedBasis(8),RedBasis(24),RedSet_4(74))
call construct_redset4(1,3,15,RedBasis(80),RedBasis(79),RedBasis(47),RedSet_4(75))
call construct_redset4(1,3,7,RedBasis(80),RedBasis(78),RedBasis(46),RedSet_4(76))
call construct_redset4(33,43,47,RedBasis(26),RedBasis(74),RedBasis(59),RedSet_4(77))
call construct_redset4(33,35,43,RedBasis(24),RedBasis(26),RedBasis(18),RedSet_4(78))
call construct_redset4(2,10,14,RedBasis(81),RedBasis(76),RedBasis(82),RedSet_4(79))
call construct_redset4(32,33,43,RedBasis(23),RedBasis(16),RedBasis(26),RedSet_4(80))
call construct_redset4(1,11,15,RedBasis(83),RedBasis(79),RedBasis(63),RedSet_4(81))
call construct_redset4(1,3,11,RedBasis(80),RedBasis(83),RedBasis(62),RedSet_4(82))
call construct_redset5(32, 35, 51, 55, RedBasis(8), RedBasis(84), & 
 RedBasis(85), RedBasis(86),RedBasis(87), RedBasis(88), RedSet_5(9))
call construct_redset5(32, 35, 51, 59, RedBasis(8), RedBasis(84), & 
 RedBasis(89), RedBasis(86),RedBasis(90), RedBasis(91), RedSet_5(10))
call construct_redset5(48, 50, 51, 55, RedBasis(92), RedBasis(93), & 
 RedBasis(94), RedBasis(95),RedBasis(96), RedBasis(88), RedSet_5(11))
call construct_redset5(48, 50, 51, 59, RedBasis(92), RedBasis(93), & 
 RedBasis(97), RedBasis(95),RedBasis(98), RedBasis(91), RedSet_5(12))
call construct_redset5(48, 49, 51, 55, RedBasis(99), RedBasis(93), & 
 RedBasis(94), RedBasis(100),RedBasis(101), RedBasis(88), RedSet_5(13))
call construct_redset5(48, 49, 51, 59, RedBasis(99), RedBasis(93), & 
 RedBasis(97), RedBasis(100),RedBasis(102), RedBasis(91), RedSet_5(14))
call construct_redset5(32, 44, 45, 47, RedBasis(2), RedBasis(3), & 
 RedBasis(33), RedBasis(6),RedBasis(27), RedBasis(28), RedSet_5(15))
call construct_redset5(32, 40, 44, 47, RedBasis(1), RedBasis(2), & 
 RedBasis(33), RedBasis(4),RedBasis(29), RedBasis(27), RedSet_5(16))
call construct_redset5(32, 35, 39, 47, RedBasis(8), RedBasis(9), & 
 RedBasis(33), RedBasis(12),RedBasis(40), RedBasis(41), RedSet_5(17))
call construct_redset5(32, 34, 35, 47, RedBasis(7), RedBasis(8), & 
 RedBasis(33), RedBasis(10),RedBasis(42), RedBasis(40), RedSet_5(18))
call construct_redset5(32, 36, 44, 47, RedBasis(13), RedBasis(2), & 
 RedBasis(33), RedBasis(14),RedBasis(52), RedBasis(27), RedSet_5(19))
call construct_redset5(32, 35, 43, 47, RedBasis(8), RedBasis(16), & 
 RedBasis(33), RedBasis(18),RedBasis(40), RedBasis(59), RedSet_5(20))
call construct_redset5(32, 44, 46, 47, RedBasis(2), RedBasis(19), & 
 RedBasis(33), RedBasis(21),RedBasis(27), RedBasis(65), RedSet_5(21))
call construct_redset5(32, 33, 35, 47, RedBasis(23), RedBasis(8), & 
 RedBasis(33), RedBasis(24),RedBasis(74), RedBasis(40), RedSet_5(22))
call construct_redset5(32, 40, 43, 47, RedBasis(1), RedBasis(16), & 
 RedBasis(33), RedBasis(103),RedBasis(29), RedBasis(59), RedSet_5(23))
call construct_redset5(32, 36, 39, 47, RedBasis(13), RedBasis(9), & 
 RedBasis(33), RedBasis(104),RedBasis(52), RedBasis(41), RedSet_5(24))
call construct_redset5(32, 34, 35, 51, RedBasis(7), RedBasis(8), & 
 RedBasis(84), RedBasis(10),RedBasis(105), RedBasis(86), RedSet_5(25))
call construct_redset5(32, 33, 35, 51, RedBasis(23), RedBasis(8), & 
 RedBasis(84), RedBasis(24),RedBasis(106), RedBasis(86), RedSet_5(26))
call construct_redset5(32, 34, 46, 47, RedBasis(7), RedBasis(19), & 
 RedBasis(33), RedBasis(107),RedBasis(42), RedBasis(65), RedSet_5(27))
call construct_redset5(32, 33, 45, 47, RedBasis(23), RedBasis(3), & 
 RedBasis(33), RedBasis(108),RedBasis(74), RedBasis(28), RedSet_5(28))
call construct_redset5(48, 52, 53, 55, RedBasis(109), RedBasis(110), & 
 RedBasis(94), RedBasis(111),RedBasis(112), RedBasis(113), RedSet_5(29))
call construct_redset5(48, 52, 54, 55, RedBasis(109), RedBasis(114), & 
 RedBasis(94), RedBasis(115),RedBasis(112), RedBasis(116), RedSet_5(30))
call construct_redset5(48, 49, 53, 61, RedBasis(99), RedBasis(110), & 
 RedBasis(117), RedBasis(118),RedBasis(119), RedBasis(120), RedSet_5(31))
call construct_redset5(48, 49, 57, 61, RedBasis(99), RedBasis(121), & 
 RedBasis(117), RedBasis(122),RedBasis(119), RedBasis(123), RedSet_5(32))
call construct_redset5(48, 56, 60, 61, RedBasis(124), RedBasis(125), & 
 RedBasis(117), RedBasis(126),RedBasis(127), RedBasis(128), RedSet_5(33))
call construct_redset5(48, 52, 60, 61, RedBasis(109), RedBasis(125), & 
 RedBasis(117), RedBasis(129),RedBasis(130), RedBasis(128), RedSet_5(34))
call construct_redset5(48, 56, 60, 62, RedBasis(124), RedBasis(125), & 
 RedBasis(131), RedBasis(126),RedBasis(132), RedBasis(133), RedSet_5(35))
call construct_redset5(48, 52, 60, 62, RedBasis(109), RedBasis(125), & 
 RedBasis(131), RedBasis(129),RedBasis(134), RedBasis(133), RedSet_5(36))
call construct_redset5(40, 44, 45, 47, RedBasis(4), RedBasis(5), & 
 RedBasis(29), RedBasis(6),RedBasis(27), RedBasis(28), RedSet_5(37))
call construct_redset5(32, 40, 45, 47, RedBasis(1), RedBasis(3), & 
 RedBasis(33), RedBasis(5),RedBasis(29), RedBasis(28), RedSet_5(38))
call construct_redset5(34, 35, 39, 47, RedBasis(10), RedBasis(11), & 
 RedBasis(42), RedBasis(12),RedBasis(40), RedBasis(41), RedSet_5(39))
call construct_redset5(32, 34, 39, 47, RedBasis(7), RedBasis(9), & 
 RedBasis(33), RedBasis(11),RedBasis(42), RedBasis(41), RedSet_5(40))
call construct_redset5(36, 44, 45, 47, RedBasis(14), RedBasis(15), & 
 RedBasis(52), RedBasis(6),RedBasis(27), RedBasis(28), RedSet_5(41))
call construct_redset5(32, 36, 45, 47, RedBasis(13), RedBasis(3), & 
 RedBasis(33), RedBasis(15),RedBasis(52), RedBasis(28), RedSet_5(42))
call construct_redset5(34, 35, 43, 47, RedBasis(10), RedBasis(17), & 
 RedBasis(42), RedBasis(18),RedBasis(40), RedBasis(59), RedSet_5(43))
call construct_redset5(32, 34, 43, 47, RedBasis(7), RedBasis(16), & 
 RedBasis(33), RedBasis(17),RedBasis(42), RedBasis(59), RedSet_5(44))
call construct_redset5(40, 44, 46, 47, RedBasis(4), RedBasis(20), & 
 RedBasis(29), RedBasis(21),RedBasis(27), RedBasis(65), RedSet_5(45))
call construct_redset5(32, 40, 46, 47, RedBasis(1), RedBasis(19), & 
 RedBasis(33), RedBasis(20),RedBasis(29), RedBasis(65), RedSet_5(46))
call construct_redset5(36, 44, 46, 47, RedBasis(14), RedBasis(22), & 
 RedBasis(52), RedBasis(21),RedBasis(27), RedBasis(65), RedSet_5(47))
call construct_redset5(32, 36, 46, 47, RedBasis(13), RedBasis(19), & 
 RedBasis(33), RedBasis(22),RedBasis(52), RedBasis(65), RedSet_5(48))
call construct_redset5(33, 35, 39, 47, RedBasis(24), RedBasis(25), & 
 RedBasis(74), RedBasis(12),RedBasis(40), RedBasis(41), RedSet_5(49))
call construct_redset5(32, 33, 39, 47, RedBasis(23), RedBasis(9), & 
 RedBasis(33), RedBasis(25),RedBasis(74), RedBasis(41), RedSet_5(50))
call construct_redset5(33, 35, 43, 47, RedBasis(24), RedBasis(26), & 
 RedBasis(74), RedBasis(18),RedBasis(40), RedBasis(59), RedSet_5(51))
call construct_redset5(32, 33, 43, 47, RedBasis(23), RedBasis(16), & 
 RedBasis(33), RedBasis(26),RedBasis(74), RedBasis(59), RedSet_5(52))
call construct_redset4(56,60,61,RedBasis(126),RedBasis(127),RedBasis(128),RedSet_4(83))
call construct_redset4(48,60,61,RedBasis(125),RedBasis(117),RedBasis(128),RedSet_4(84))
call construct_redset4(48,56,61,RedBasis(124),RedBasis(117),RedBasis(127),RedSet_4(85))
call construct_redset4(48,56,60,RedBasis(124),RedBasis(125),RedBasis(126),RedSet_4(86))
call construct_redset4(50,51,55,RedBasis(95),RedBasis(96),RedBasis(88),RedSet_4(87))
call construct_redset4(48,51,55,RedBasis(93),RedBasis(94),RedBasis(88),RedSet_4(88))
call construct_redset4(48,50,55,RedBasis(92),RedBasis(94),RedBasis(96),RedSet_4(89))
call construct_redset4(48,50,51,RedBasis(92),RedBasis(93),RedBasis(95),RedSet_4(90))
call construct_redset4(52,60,61,RedBasis(129),RedBasis(130),RedBasis(128),RedSet_4(91))
call construct_redset4(48,52,61,RedBasis(109),RedBasis(117),RedBasis(130),RedSet_4(92))
call construct_redset4(48,52,60,RedBasis(109),RedBasis(125),RedBasis(129),RedSet_4(93))
call construct_redset4(50,51,59,RedBasis(95),RedBasis(98),RedBasis(91),RedSet_4(94))
call construct_redset4(48,51,59,RedBasis(93),RedBasis(97),RedBasis(91),RedSet_4(95))
call construct_redset4(48,50,59,RedBasis(92),RedBasis(97),RedBasis(98),RedSet_4(96))
call construct_redset4(56,60,62,RedBasis(126),RedBasis(132),RedBasis(133),RedSet_4(97))
call construct_redset4(48,60,62,RedBasis(125),RedBasis(131),RedBasis(133),RedSet_4(98))
call construct_redset4(48,56,62,RedBasis(124),RedBasis(131),RedBasis(132),RedSet_4(99))
call construct_redset4(52,60,62,RedBasis(129),RedBasis(134),RedBasis(133),RedSet_4(100))
call construct_redset4(48,52,62,RedBasis(109),RedBasis(131),RedBasis(134),RedSet_4(101))
call construct_redset4(49,51,55,RedBasis(100),RedBasis(101),RedBasis(88),RedSet_4(102))
call construct_redset4(48,49,55,RedBasis(99),RedBasis(94),RedBasis(101),RedSet_4(103))
call construct_redset4(48,49,51,RedBasis(99),RedBasis(93),RedBasis(100),RedSet_4(104))
call construct_redset4(49,51,59,RedBasis(100),RedBasis(102),RedBasis(91),RedSet_4(105))
call construct_redset4(48,49,59,RedBasis(99),RedBasis(97),RedBasis(102),RedSet_4(106))
call construct_redset4(35,51,55,RedBasis(86),RedBasis(87),RedBasis(88),RedSet_4(107))
call construct_redset4(32,51,55,RedBasis(84),RedBasis(85),RedBasis(88),RedSet_4(108))
call construct_redset4(32,35,55,RedBasis(8),RedBasis(85),RedBasis(87),RedSet_4(109))
call construct_redset4(32,35,51,RedBasis(8),RedBasis(84),RedBasis(86),RedSet_4(110))
call construct_redset4(3,19,23,RedBasis(135),RedBasis(136),RedBasis(137),RedSet_4(111))
call construct_redset4(35,51,59,RedBasis(86),RedBasis(90),RedBasis(91),RedSet_4(112))
call construct_redset4(32,51,59,RedBasis(84),RedBasis(89),RedBasis(91),RedSet_4(113))
call construct_redset4(32,35,59,RedBasis(8),RedBasis(89),RedBasis(90),RedSet_4(114))
call construct_redset4(3,19,27,RedBasis(135),RedBasis(138),RedBasis(139),RedSet_4(115))
call construct_redset4(40,43,47,RedBasis(103),RedBasis(29),RedBasis(59),RedSet_4(116))
call construct_redset4(32,40,43,RedBasis(1),RedBasis(16),RedBasis(103),RedSet_4(117))
call construct_redset4(8,11,15,RedBasis(54),RedBasis(38),RedBasis(63),RedSet_4(118))
call construct_redset4(36,39,47,RedBasis(104),RedBasis(52),RedBasis(41),RedSet_4(119))
call construct_redset4(32,36,39,RedBasis(13),RedBasis(9),RedBasis(104),RedSet_4(120))
call construct_redset4(4,7,15,RedBasis(31),RedBasis(57),RedBasis(48),RedSet_4(121))
call construct_redset4(34,35,51,RedBasis(10),RedBasis(105),RedBasis(86),RedSet_4(122))
call construct_redset4(32,34,51,RedBasis(7),RedBasis(84),RedBasis(105),RedSet_4(123))
call construct_redset4(2,3,19,RedBasis(51),RedBasis(140),RedBasis(135),RedSet_4(124))
call construct_redset4(33,35,51,RedBasis(24),RedBasis(106),RedBasis(86),RedSet_4(125))
call construct_redset4(32,33,51,RedBasis(23),RedBasis(84),RedBasis(106),RedSet_4(126))
call construct_redset4(1,3,19,RedBasis(80),RedBasis(141),RedBasis(135),RedSet_4(127))
call construct_redset4(34,46,47,RedBasis(107),RedBasis(42),RedBasis(65),RedSet_4(128))
call construct_redset4(32,34,46,RedBasis(7),RedBasis(19),RedBasis(107),RedSet_4(129))
call construct_redset4(2,14,15,RedBasis(76),RedBasis(50),RedBasis(69),RedSet_4(130))
call construct_redset4(33,45,47,RedBasis(108),RedBasis(74),RedBasis(28),RedSet_4(131))
call construct_redset4(32,33,45,RedBasis(23),RedBasis(3),RedBasis(108),RedSet_4(132))
call construct_redset4(1,13,15,RedBasis(44),RedBasis(79),RedBasis(36),RedSet_4(133))
call construct_redset4(52,53,55,RedBasis(111),RedBasis(112),RedBasis(113),RedSet_4(134))
call construct_redset4(48,53,55,RedBasis(110),RedBasis(94),RedBasis(113),RedSet_4(135))
call construct_redset4(48,52,55,RedBasis(109),RedBasis(94),RedBasis(112),RedSet_4(136))
call construct_redset4(48,52,53,RedBasis(109),RedBasis(110),RedBasis(111),RedSet_4(137))
call construct_redset4(52,54,55,RedBasis(115),RedBasis(112),RedBasis(116),RedSet_4(138))
call construct_redset4(48,54,55,RedBasis(114),RedBasis(94),RedBasis(116),RedSet_4(139))
call construct_redset4(48,52,54,RedBasis(109),RedBasis(114),RedBasis(115),RedSet_4(140))
call construct_redset4(49,53,61,RedBasis(118),RedBasis(119),RedBasis(120),RedSet_4(141))
call construct_redset4(48,53,61,RedBasis(110),RedBasis(117),RedBasis(120),RedSet_4(142))
call construct_redset4(48,49,61,RedBasis(99),RedBasis(117),RedBasis(119),RedSet_4(143))
call construct_redset4(48,49,53,RedBasis(99),RedBasis(110),RedBasis(118),RedSet_4(144))
call construct_redset4(49,57,61,RedBasis(122),RedBasis(119),RedBasis(123),RedSet_4(145))
call construct_redset4(48,57,61,RedBasis(121),RedBasis(117),RedBasis(123),RedSet_4(146))
call construct_redset4(48,49,57,RedBasis(99),RedBasis(121),RedBasis(122),RedSet_4(147))
call construct_redset4(48,56,59,RedBasis(124),RedBasis(97),RedBasis(142),RedSet_4(148))
call construct_redset4(48,50,62,RedBasis(92),RedBasis(131),RedBasis(143),RedSet_4(149))
call construct_redset4(56,58,59,RedBasis(144),RedBasis(142),RedBasis(145),RedSet_4(150))
call construct_redset4(56,57,59,RedBasis(146),RedBasis(142),RedBasis(147),RedSet_4(151))
call construct_redset4(40,43,59,RedBasis(103),RedBasis(148),RedBasis(149),RedSet_4(152))
call construct_redset4(36,39,55,RedBasis(104),RedBasis(150),RedBasis(151),RedSet_4(153))
call construct_redset4(50,58,62,RedBasis(152),RedBasis(143),RedBasis(153),RedSet_4(154))
call construct_redset4(50,54,62,RedBasis(154),RedBasis(143),RedBasis(155),RedSet_4(155))

end subroutine 



! **********************************************************************
subroutine vamp(M)
! **********************************************************************
  use KIND_TYPES, only: REALKIND
  use ol_data_types_/**/REALKIND, only: Hpolcont
  use ol_momenta_decl_/**/REALKIND, only: Q
  use ol_parameters_decl_/**/REALKIND ! masses
  use ol_parameters_init_/**/REALKIND, only: init_met
  use ol_tensor_sum_storage_ppttjj_uuxttxddx_1_/**/REALKIND
  use ol_vamp_1_ppttjj_uuxttxddx_1_/**/REALKIND, only: vamp_1
  use ol_vamp_2_ppttjj_uuxttxddx_1_/**/REALKIND, only: vamp_2

  implicit none
  type(Hpolcont), intent(in) :: M(6,64)

#ifdef LOOPSQUARED
  M = 0
#endif

  ! Call subroutines for all branches to calculate loop coefficient tensors
  call init_met(M2L1R1)
  call vamp_1(M)
  call vamp_2(M)


end subroutine vamp

! **********************************************************************
subroutine vamp2base(P_scatt, M2L0, M2L1, IRL1, M2L2, IRL2, mode)
! P_scatt(0:3,Npart) = external momenta
! M2tree = helicity-summed squared tree matrix element for up anti-up top anti-top down anti-down -> 0
! M2loop0 = helicity-summed squared loop matrix element for up anti-up top anti-top down anti-down -> 0
! M2loop1 = IR1, M2loop2 = IR2 are dummy values for the single and double poles
! IR0, IR1, IR2 = finite, single pole, and double pole IR contribution
! mode = 1 (default): full matrix element;
!        2: reuse and scale coefficients from the last call;
!        note that scalings cannot be reset
! **********************************************************************
  use KIND_TYPES, only: REALKIND, DREALKIND
#ifdef PRECISION_dp
  use KIND_TYPES, only: QREALKIND
#endif
  use ol_debug, only: ol_fatal
  use ol_generic, only: to_string
  use ol_external_ppttjj_uuxttxddx_1, only: &
    & external_perm_inv_ppttjj_uuxttxddx_1, average_factor_ppttjj_uuxttxddx_1
  use ol_colourmatrix_ppttjj_uuxttxddx_1_/**/REALKIND ! colmat_not_initialised, colourmatrix_init, K1, K2, KL, KL2, KL2ct, KL2ct2
  use ol_kinematics_/**/REALKIND, only: init_kinematics, get_rmass2
  use ol_parameters_decl_/**/REALKIND ! parameters_status, scalefactor, <masses>
  ! tensorrankuse: for compatibility with old OL versions only insert if rank > 6
  use ol_parameters_init_/**/REALKIND, only: ensure_mp_loop_init
  use ol_init, only: set_parameter, parameters_flush
  use ol_loop_parameters_decl_/**/REALKIND, only: loop_parameters_status
  use ol_loop_parameters_decl_/**/DREALKIND, only: IR_is_on, ioperator_mode
  use ol_forced_parameters_ppttjj_uuxttxddx_1_/**/REALKIND, only: check_forced_parameters
  use ol_momenta_decl_/**/DREALKIND, only: momenta_nan_check
  use ol_momenta_decl_/**/REALKIND, only: QInvariantsMatrix
  use ol_tensor_sum_storage_ppttjj_uuxttxddx_1_/**/REALKIND, only: &
    & reset_tensor_sum, integrate_tensor_sum, scale_tensor_sum, HOL_memory_allocation, HCL_memory_allocation, &
    & set_integral_masses_and_momenta, Tsum_memory_allocation
  use ol_tables_storage_ppttjj_uuxttxddx_1_/**/DREALKIND, only: HOL_m3_init
  use ol_loop_ppttjj_uuxttxddx_1_/**/REALKIND, only: amp2, fac_init_loop
  use ol_loop_storage_ppttjj_uuxttxddx_1_/**/REALKIND, only: &
    & fac_status_loop1, fac_status_loop2, M0_col1_helarray
  use ol_i_operator_/**/REALKIND, only: intdip  
  use ol_loop_storage_ppttjj_uuxttxddx_1_/**/DREALKIND, only: ntry, p_switch,  &
  & dp_not_alloc, qp_not_alloc
  use hol_initialisation_/**/REALKIND, only: G0_hol_initialisation
  use ol_h_vert_interface_/**/REALKIND
  use ol_h_prop_interface_/**/REALKIND
  use ol_merging_/**/DREALKIND, only: n_merge_2, n_hels
  implicit none

  real(DREALKIND), intent(in)  :: P_scatt(0:3,6)
  real(REALKIND),  intent(out) :: M2L0, M2L1, IRL1(0:2), M2L2, IRL2(0:4)
  integer, intent(in), optional :: mode
  real(REALKIND)       :: P(0:3,6)
  integer              :: i, j, colmatpos, recycle_mode, ofred_mode
  complex(REALKIND)    :: M0_col1(6), Mct(6)
  complex(REALKIND)    :: Mcol_loop(6)
  real(REALKIND)       :: M2colint(22), M2CC(6,6), M2CC_EW ! colour correlations
  integer              :: extmasses2(6)
  real(REALKIND)       :: M2hel, M2ct, M2L2ct, M2L2ct2, vdip, c_dip(0:2)
  real(REALKIND)       :: scalebackfactor

  ofred_mode = 1  

  if (present(mode)) then
    recycle_mode = mode
  else
    recycle_mode = 1
  end if

  call set_parameter("ew_renorm", 0)
  call parameters_flush()
  call ensure_mp_loop_init()
  if (fac_status_loop1 /= parameters_status .or. fac_status_loop2 /= loop_parameters_status) then
    ! Note: if fac_init would only be called when parameters changed which are relevant for the factors,
    ! a different 'status' would have to be used, because forced_parameters should be called after every parameter change.
    call check_forced_parameters()
    call fac_init_loop()
  end if

  if (colmat_not_initialised) call colourmatrix_init()


  M2L0     = 0
  M2L1     = 0
  M2ct     = 0
  M2colint = 0
  M2L2     = 0
  M2L2ct   = 0
  M2L2ct2  = 0
  IRL1     = 0
  IRL2     = 0
  extmasses2 = [ 0, 0, nMT, nMT, 0, 0 ]

  if (momenta_nan_check(P_scatt) /= 0) return

  call init_kinematics(P_scatt, extmasses2, P, external_perm_inv_ppttjj_uuxttxddx_1, 6)

#ifndef PRECISION_dp 
  if (ntry==1 .OR. qp_not_alloc) then
    call Tsum_memory_allocation()    
  end if
#else 
  if (ntry==1 .OR. dp_not_alloc) then
    call Tsum_memory_allocation()    
  end if
#endif

#ifdef LOOPSQUARED
  call integrate_tensor_sum(M2L1)
#else
  if (recycle_mode == 1 .or. ofred_mode == 1) call reset_tensor_sum()
#endif


  ! Here we calculate the tree level squared using the helicity bookkeeping subroutines
  ! The value of the tree level squared is M2L0
  ! The subtrees are also initialised
  call amp2(P_scatt, M2L0, M2ct, M2colint)
  
  !The following part refers to the 1-loop calculation

  !! Number of on-the-fly merging steps on open loops and
  !! total number of helicity states
  if(ntry==1) then
    n_merge_2 = 188
    n_hels = 64
  end if

  ! Construction of the basis used for the reduction 
call redbaseconstr()
  ! Memory allocation for the hol types is done just for the first phase space point
  ! Memory is reallocated when switching from double- to quad-precision for the first time
#ifndef PRECISION_dp 
  if (ntry==1 .OR. qp_not_alloc) then
    call HOL_memory_allocation()
    call HCL_memory_allocation()
    qp_not_alloc = .FALSE.      
  end if
#else 
  if (ntry==1 .OR. dp_not_alloc) then
    call HOL_memory_allocation()
    call HCL_memory_allocation()
    dp_not_alloc = .FALSE.      
  end if
#endif

  ! m3 initialization is done just for the first phase space point   
  if (ntry==1) call HOL_m3_init()

  call set_integral_masses_and_momenta()

  !Here we insert a call for the calculation of the 1-loop contribution
  !we could use the current subroutine vamp(M)
  if (recycle_mode == 1 .or. ofred_mode == 1) then
    call vamp(M0_col1_helarray)
  end if
 
  if(ntry==1) ntry = 2

#ifdef PRECISION_dp 
  p_switch = 1 
#else 
  p_switch = 2
#endif


#ifdef LOOPSQUARED
  M2L2 = (M2L2 + 2*M2L2ct + M2L2ct2) / average_factor_ppttjj_uuxttxddx_1
#else
  if (recycle_mode == 2 .and. ofred_mode == 0) then
    call scale_tensor_sum()
  end if
  call integrate_tensor_sum(M2L1)
#endif

  if (IR_is_on > 0) then
    do i = 1, 6
      do j = 1, i
        ! Why does this work without permuting the colour correlation matrices?
        ! M2CC(i,j) = M2colint(extcomb_perm_uxuexe_uxuexe(i*(i-1)/2+j))
        M2CC(i,j) = M2colint(i*(i-1)/2+j)
      end do
    end do
    do j = 2, 6
      do i = 1, j-1
        M2CC(i,j) = M2CC(j,i)
      end do
    end do
    M2CC_EW = M2colint(6*(6+1)/2+1)
    call intdip(ioperator_mode, M2L0, M2CC, M2CC_EW, [2,2,2,2,2,2], [2,-2,2,-2,-1,1]/3._/**/REALKIND, &
      & 6, get_rmass2(extmasses2), QInvariantsMatrix, vdip, c_dip)
    IRL1(0) = c_dip(0) / average_factor_ppttjj_uuxttxddx_1
    IRL1(1) = c_dip(1) / average_factor_ppttjj_uuxttxddx_1
    IRL1(2) = c_dip(2) / average_factor_ppttjj_uuxttxddx_1
  else
    vdip = 0
    IRL1 = 0
  end if

  ! loop^2 IR contribution: not implemented
  IRL2 = 0

  ! Colour and helicity average and symmetry factor of outgoing particles
  M2L0 = M2L0 / average_factor_ppttjj_uuxttxddx_1
  M2L1 = 2*(M2L1 + M2ct)
  if (IR_is_on > 1) then
    M2L1 = M2L1 + vdip
  end if
  M2L1 = M2L1 / average_factor_ppttjj_uuxttxddx_1

  ! check for NaN result
  if (M2L0 /= M2L0) then
    M2L0 = 0
  end if
  if (M2L1 /= M2L1) then
    M2L1 = 0
    M2L2 = 0
    IRL1 = 0
    IRL2 = 0
  end if

  scalebackfactor = scalefactor**(2*6-8)
  M2L0 = scalebackfactor * M2L0
  M2L1 = scalebackfactor * M2L1
  IRL1 = scalebackfactor * IRL1
  M2L2 = scalebackfactor * M2L2
  IRL2 = scalebackfactor * IRL2

end subroutine vamp2base


! **********************************************************************
subroutine ctamp2base(P_scatt, M2tree, M2ct)
! The part of vamp2 which calculates tree and counter-term
! matrix elements, but not the loop. R2 is deactivated.
! Does not calculate loop^2 counterterms/R2.
! P_scatt(0:3,Npart) = external momenta
! M2tree = helicity-summed squared tree matrix element for up anti-up top anti-top down anti-down -> 0
! M2ct   = helicity-summed counterterm matrix element
! **********************************************************************
  use KIND_TYPES, only: REALKIND, DREALKIND
!   use ol_external_ppttjj_uuxttxddx_1, only: hel_not_initialised, hel_init, H
  use ol_colourmatrix_ppttjj_uuxttxddx_1_/**/REALKIND, only: &
    & colmat_not_initialised, colourmatrix_init, K1, K2
  use ol_parameters_decl_/**/REALKIND ! parameters_status, scalefactor, <masses>
  use ol_parameters_decl_/**/DREALKIND, only: do_ew_renorm
  use ol_loop_parameters_decl_/**/DREALKIND, only: &
    & loop_parameters_status, CT_is_on, R2_is_on, TP_is_on
  use ol_init, only: set_parameter, parameters_flush
  use ol_parameters_init_/**/REALKIND, only: ensure_mp_loop_init
  use ol_external_ppttjj_uuxttxddx_1, only: &
    & external_perm_inv_ppttjj_uuxttxddx_1, average_factor_ppttjj_uuxttxddx_1
  use ol_momenta_decl_/**/DREALKIND, only: momenta_nan_check
  use ol_kinematics_/**/REALKIND, only: init_kinematics
  use ol_forced_parameters_ppttjj_uuxttxddx_1_/**/REALKIND, only: check_forced_parameters
  use ol_loop_storage_ppttjj_uuxttxddx_1_/**/REALKIND, only: &
    & fac_status_loop1, fac_status_loop2
  use ol_loop_ppttjj_uuxttxddx_1_/**/REALKIND, only: fac_init_loop, amp2
  implicit none

  real(DREALKIND), intent(in)  :: P_scatt(0:3,6)
  real(REALKIND),  intent(out) :: M2tree, M2ct
  real(REALKIND)    :: P(0:3,6)
  real(REALKIND)       :: M2colint(22)
  integer,  save    :: ntry = 1
  real(REALKIND)    :: extmasses2(6)
  integer           :: CT_on_bak, R2_on_bak, TP_on_bak
  real(REALKIND)    :: scalebackfactor

  if (CT_is_on == 0 .or. CT_is_on == 1) then
    ! This routine is called from the old evaluate_ct() interface
    ! which does not set CT_is_on. Need to set it here for compatibility
    ! (the new evaluate_ct() interface sets CT_is_on=-1|2 to identify itself).
    CT_on_bak = CT_is_on
    R2_on_bak = R2_is_on
    TP_on_bak = TP_is_on
    call set_parameter("ct_on", 1)
    call set_parameter("r2_on", 0)
    call set_parameter("tp_on", 0)
  else if (CT_is_on == 2) then
    call set_parameter("ct_on", 1)
  else if (CT_is_on == -1) then
    call set_parameter("ct_on", 0)
  end if
  call set_parameter("ew_renorm", 0)
  call parameters_flush()
  call ensure_mp_loop_init()

  extmasses2 = [ 0, 0, nMT, nMT, 0, 0 ]
 
    M2tree = 0
    M2ct   = 0
    
  if (momenta_nan_check(P_scatt) /= 0)  return

  ! Convert 2 -> n-2 PS-point to n -> 0 (so that P(1) + ... + P(n) = 0) and compute
  ! internal-propagator momenta in light-cone representation
  call init_kinematics(P_scatt, extmasses2, P, external_perm_inv_ppttjj_uuxttxddx_1, 6)
  
  call amp2(P_scatt, M2tree, M2ct, M2colint)

  if (CT_on_bak == 0 .or. CT_on_bak == 1) then
    call set_parameter("ct_on", CT_on_bak)
    call set_parameter("r2_on", R2_on_bak)
    call set_parameter("tp_on", TP_on_bak)
  end if

  scalebackfactor = scalefactor**(2*6-8)
  M2tree = scalebackfactor * M2tree / average_factor_ppttjj_uuxttxddx_1
  M2ct   = scalebackfactor * 2*M2ct / average_factor_ppttjj_uuxttxddx_1

end subroutine ctamp2base




subroutine vamp2pc(P_scatt, M2L0, M2L1, IRL1, M2L2, IRL2, mode)
  ! polecheck routine: perform multiple calls of vamp2
  ! with different values of the UV/IR poles
  ! to determine the coefficients of the IR poles.
  use KIND_TYPES, only: REALKIND, DREALKIND
  use ol_parameters_decl_/**/DREALKIND, only: rZERO_dp => rZERO
  use ol_loop_parameters_decl_/**/REALKIND, only: &
    & de1_UV, de1_IR, de2_i_IR
  use ol_loop_parameters_decl_/**/DREALKIND, only: &
    & polescale_dp => polescale, polecheck_is, CT_is_on, IR_is_on
  use ol_init, only: set_parameter
  implicit none
  real(DREALKIND), intent(in)  :: P_scatt(:,:)
  real(REALKIND),  intent(out) :: M2L0, M2L1(0:2), IRL1(0:2), M2L2(0:4), IRL2(0:4)
  integer, intent(in), optional :: mode
  real(DREALKIND) :: poleUV1bak, poleIR1bak, poleIR2bak
  integer         :: CT_on_bak, IR_on_bak
  real(REALKIND)  :: M2L1_00, M2L1_10, M2L1_01, M2L1_20, M2L1_02, M2L1_11
  real(REALKIND)  :: M2L2_00, M2L2_10, M2L2_01, M2L2_20, M2L2_02, M2L2_11
  real(REALKIND)  :: IRL1x(0:2), IRL2x(0:4)

  if (polecheck_is == 0) then
    call vamp2base(P_scatt, M2L0, M2L1(0), IRL1, M2L2(0), IRL2, mode)
    if (IR_is_on == 2) then
      M2L1(1:2) = 0
      M2L2(1:4) = 0
    else
      M2L1(1:2) = -IRL1(1:2)
      M2L2(1:4) = -IRL2(1:4)
    end if
  else
    ! remember original parameters
    poleUV1bak = de1_UV
    poleIR1bak = de1_IR
    poleIR2bak = de2_i_IR
    CT_on_bak  = CT_is_on
    IR_on_bak  = IR_is_on
    ! three calls with different IR poles; IR subtractions are calculated but not added
    call set_parameter("pole_uv", rZERO_dp)
    call set_parameter("pole_ir1", rZERO_dp)
    call set_parameter("pole_ir2", rZERO_dp)
    call set_parameter("ct_on", 1)
    call set_parameter("ir_on", 1)
    call vamp2base(P_scatt, M2L0, M2L1_00, IRL1, M2L2_00, IRL2, mode)
    call set_parameter("pole_uv", polescale_dp)
    call set_parameter("pole_ir1", polescale_dp)
    call set_parameter("pole_ir2", rZERO_dp)
    call set_parameter("ir_on", 0)
    call vamp2base(P_scatt, M2L0, M2L1_10, IRL1x, M2L2_10, IRL2x, mode)
    call set_parameter("pole_uv", rZERO_dp)
    call set_parameter("pole_ir1", rZERO_dp)
    call set_parameter("pole_ir2", polescale_dp)
    call vamp2base(P_scatt, M2L0, M2L1_01, IRL1x, M2L2_01, IRL2x, mode)

    M2L1(0) = M2L1_00
    M2L1(1) = (M2L1_10 - M2L1_00)/polescale_dp
    M2L1(2) = (M2L1_01 - M2L1_00)/polescale_dp

#ifdef LOOPSQUARED
    call set_parameter("pole_uv", polescale_dp)
    call set_parameter("pole_ir1", 2*polescale_dp)
    call set_parameter("pole_ir2", rZERO_dp)
    call vamp2base(P_scatt, M2L0, M2L1_20, IRL1x, M2L2_20, IRL2x)
    call set_parameter("pole_uv", rZERO_dp)
    call set_parameter("pole_ir1", rZERO_dp)
    call set_parameter("pole_ir2", 2*polescale_dp)
    call vamp2base(P_scatt, M2L0, M2L1_02, IRL1x, M2L2_02, IRL2x)
    call set_parameter("pole_uv", rZERO_dp)
    call set_parameter("pole_ir1", polescale_dp)
    call set_parameter("pole_ir2", polescale_dp)
    call vamp2base(P_scatt, M2L0, M2L1_11, IRL1x, M2L2_11, IRL2x)

    M2L2(0) = M2L2_00
    M2L2(1) = (-3*M2L2_00 - M2L2_20 + 4*M2L2_10)/(2*polescale_dp)
    M2L2(2) = (-3*M2L2_00 + 4*M2L2_01 - M2L2_02)/(2*polescale_dp) + (M2L2_00 - 2*M2L2_10 + M2L2_20)/(2*polescale_dp**2)
    M2L2(3) = (M2L2_00 - M2L2_01 - M2L2_10 + M2L2_11)/polescale_dp**2
    M2L2(4) = (M2L2_00 + M2L2_02 - 2*M2L2_01)/(2*polescale_dp**2)
#endif
    ! restore original parameters
    call set_parameter("pole_uv", poleUV1bak)
    call set_parameter("pole_ir1", poleIR1bak)
    call set_parameter("pole_ir2", poleIR2bak)
    call set_parameter("ct_on", CT_on_bak)
    call set_parameter("ir_on", IR_on_bak)
    if (IR_on_bak == 2) then
      M2L1 = M2L1 + IRL1
      M2L2 = M2L2 + IRL2
    end if
  end if

end subroutine vamp2pc

end module ol_vamp_ppttjj_uuxttxddx_1_/**/REALKIND


#ifdef DUMMY_qp
module ol_vamp_ppttjj_uuxttxddx_1_/**/QREALKIND
  implicit none
  contains
  subroutine vamp2pc(P_scatt, M2L0, M2L1, IRL1, M2L2, IRL2, mode)
    ! Dummy quad precision routine. Throws an error if the process called but
    ! the process has not been compiled in quad precision.
    use KIND_TYPES, only: DREALKIND, QREALKIND
    use ol_debug, only: ol_fatal
    implicit none
    real(DREALKIND), intent(in)  :: P_scatt(:,:)
    real(QREALKIND),  intent(out) :: M2L0, M2L1(0:2), IRL1(0:2), M2L2(0:4), IRL2(0:4)
    integer, intent(in), optional :: mode
    call ol_fatal("Process ppttjj_uuxttxddx_1&
      & has not been compiled in quad precision")
  end subroutine vamp2pc
end module ol_vamp_ppttjj_uuxttxddx_1_/**/QREALKIND
#endif


#ifdef PRECISION_dp

module ol_vamp_ppttjj_uuxttxddx_1
  use ol_parameters_decl_/**/DREALKIND, only: procname_length
  use ol_data_types_/**/DREALKIND, only: me_cache
  use ol_merging_/**/DREALKIND, only: deallocate_merging_tables
  implicit none
  character(procname_length) :: processname = 'ppttjj_uuxttxddx_1'
  integer, save :: qp_eval = 0, killed = 0
  integer, save :: npoints(8) = 0
  integer, save :: stability_histogram(20) = 0, stability_histogram_qp(20) = 0
  type(me_cache), allocatable, target, save :: me_caches(:)
  contains

  subroutine finish_ppttjj_uuxttxddx_1()
    ! final update of the stability histogram
    use KIND_TYPES, only: DREALKIND
!    use ol_data_types_/**/REALKIND, only: Hpolcont
!  use ol_tensor_sum_storage_ppttjj_uuxttxddx_1_/**/DREALKIND, only: HOL_memory_allocation 
    use ol_stability, only: finish_histograms
    use ol_vamp_ppttjj_uuxttxddx_1_/**/DREALKIND, only: vamp
  use ol_tensor_sum_storage_ppttjj_uuxttxddx_1_/**/DREALKIND, only: HOL_memory_deallocation_/**/DREALKIND, HCL_memory_deallocation_/**/DREALKIND
#ifndef DUMMY_qp
  use ol_tensor_sum_storage_ppttjj_uuxttxddx_1_/**/QREALKIND, only: HOL_memory_deallocation_/**/QREALKIND, HCL_memory_deallocation_/**/QREALKIND
#endif
 use ol_loop_storage_ppttjj_uuxttxddx_1_/**/DREALKIND, only: dp_not_alloc, qp_not_alloc
    implicit none
    integer :: k
    
!    type(Hpolcont) :: Mdummy(6,64)
!    call HOL_memory_allocation()     
!    call vamp(Mdummy)

    ! Memory is deallocated for both dp and/or qp stored hol coefficients
    if (.NOT. dp_not_alloc) then 
      call HOL_memory_deallocation_/**/DREALKIND(0)
      call HCL_memory_deallocation_/**/DREALKIND(0)
    end if
    if (.NOT. qp_not_alloc) then 
      call HOL_memory_deallocation_/**/QREALKIND(0)
      call HCL_memory_deallocation_/**/QREALKIND(0)
    end if

    ! Memory is deallocated for the merging tables
    call deallocate_merging_tables()

  if (allocated(me_caches)) then
      do k = 1, size(me_caches)
        if (allocated(me_caches(k)%psp)) deallocate(me_caches(k)%psp)
        if (allocated(me_caches(k)%me)) deallocate(me_caches(k)%me)
      end do
      deallocate(me_caches)
    end if
    call finish_histograms(processname, stability_histogram, stability_histogram_qp, npoints, qp_eval, killed)
  end subroutine finish_ppttjj_uuxttxddx_1


  subroutine vamp2(P_scatt, M2L0, M2L1, IRL1, M2L2, IRL2) &
      & bind(c,name="ol_f_vamp2_ppttjj_uuxttxddx_1")
    use KIND_TYPES, only: DREALKIND
    use ol_init, only: register_cleanup
    use ol_external_ppttjj_uuxttxddx_1, only: external_perm_ppttjj_uuxttxddx_1
    use ol_vamp_ppttjj_uuxttxddx_1_/**/DREALKIND, only: vamp2dp => vamp2pc
    use ol_vamp_ppttjj_uuxttxddx_1_/**/QREALKIND, only: vamp2qp => vamp2pc
    use ol_stability, only: vamp2generic
    implicit none
    real(DREALKIND), intent(in)  :: P_scatt(0:3,6)
    real(DREALKIND), intent(out) :: M2L0, M2L1(0:2), IRL1(0:2), M2L2(0:4), IRL2(0:4)
    real(DREALKIND), save :: abs_kfactor_threshold = 1, trigeff_local = 0, sum_M2tree = 0
    logical :: first_call = .true.
    if (first_call) then
      call register_cleanup(finish_ppttjj_uuxttxddx_1)
      first_call = .false.
    end if
    call vamp2generic(vamp2dp, vamp2qp, processname, P_scatt, M2L0, M2L1, IRL1, M2L2, IRL2, &
                    & abs_kfactor_threshold, trigeff_local, sum_M2tree, &
                    & npoints, qp_eval, killed, stability_histogram, stability_histogram_qp, &
                    & external_perm_ppttjj_uuxttxddx_1, me_caches)
  end subroutine vamp2


  subroutine ctamp2(P_scatt, M2tree, M2ct) &
      & bind(c,name="ol_f_ctamp2_ppttjj_uuxttxddx_1")
    use KIND_TYPES, only: DREALKIND
    use ol_vamp_ppttjj_uuxttxddx_1_/**/DREALKIND, only: ctamp2base
    implicit none
    real(DREALKIND), intent(in)  :: P_scatt(0:3,6)
    real(DREALKIND), intent(out) :: M2tree, M2ct
    call ctamp2base(P_scatt, M2tree, M2ct)
  end subroutine ctamp2


  subroutine vamp2_c(P_scatt, M2L0, M2L1, IRL1, M2L2, IRL2) &
      & bind(c,name="ol_vamp2_ppttjj_uuxttxddx_1")
    use KIND_TYPES, only: DREALKIND
    use, intrinsic :: iso_c_binding, only: c_double
    implicit none
    real(c_double), intent(in)  :: P_scatt(0:3,6)
    real(c_double), intent(out) :: M2L0, M2L1(0:2), IRL1(0:2), M2L2(0:4), IRL2(0:4)
    real(DREALKIND) :: f_p_scatt(0:3,6)
    real(DREALKIND) :: f_m2l0, f_m2l1(0:2), f_irl1(0:2), f_m2l2(0:4), f_irl2(0:4)
    f_p_scatt = P_scatt
    call vamp2(f_p_scatt, f_m2l0, f_m2l1, f_irl1, f_m2l2, f_irl2)
    M2L0 = f_m2l0
    M2L1 = f_m2l1
    IRL1 = f_irl1
    M2L2 = f_m2l2
    IRL2 = f_irl2
  end subroutine vamp2_c


  subroutine ctamp2_c(P_scatt, M2tree, M2ct) &
      & bind(c,name="ol_ctamp2_ppttjj_uuxttxddx_1")
    use KIND_TYPES, only: DREALKIND
    use, intrinsic :: iso_c_binding, only: c_double
    implicit none
    real(c_double), intent(in)  :: P_scatt(0:3,6)
    real(c_double), intent(out) :: M2tree, M2ct
    real(DREALKIND) :: f_p_scatt(0:3,6)
    real(DREALKIND) :: f_m2tree, f_m2ct
    f_p_scatt = P_scatt
    call ctamp2(f_p_scatt, f_m2tree, f_m2ct)
    M2tree = f_m2tree
    M2ct = f_m2ct
  end subroutine ctamp2_c

end module ol_vamp_ppttjj_uuxttxddx_1

! #ifdef PRECISION_dp
#endif
