
module ol_vamp_1_ppttjj_ttxbbxgg_1_/**/REALKIND
contains

! **********************************************************************
subroutine vamp_1(M)
! P(0:3,nlegs) = incoming external momenta
! Uses tree structures 'wf', factors 'c', and denominators 'den' from loop_ppttjj_ttxbbxgg_1.
! Sets colour stripped amplitudes A from the module loop_amplitudes_ppttjj_ttxbbxgg_1.
! **********************************************************************
  use KIND_TYPES, only: REALKIND, QREALKIND, intkind2
  use ol_momenta_decl_/**/QREALKIND, only: Q
  use ol_parameters_decl_/**/DREALKIND, only: l_switch
  use ol_parameters_decl_/**/QREALKIND ! masses
  use ol_vert_interface_/**/REALKIND
  use ol_prop_interface_/**/REALKIND
  use ol_last_step_/**/REALKIND
  use ol_tables_storage_ppttjj_ttxbbxgg_1_/**/DREALKIND
  use ol_tensor_sum_storage_ppttjj_ttxbbxgg_1_/**/REALKIND
  use ol_loop_handling_/**/REALKIND
  use ofred_reduction_/**/REALKIND, only: Hotf_4pt_reduction, Hotf_4pt_reduction_last
  use ofred_reduction_/**/REALKIND, only: Hotf_5pt_reduction, Hotf_5pt_reduction_last
  use ol_loop_reduction_/**/REALKIND, only: TI_bubble_red, TI_triangle_red
use ol_loop_reduction_/**/REALKIND, only: compute_scalar_box

  use ol_loop_storage_ppttjj_ttxbbxgg_1_/**/REALKIND
#ifndef PRECISION_dp
  use ol_loop_storage_ppttjj_ttxbbxgg_1_/**/DREALKIND, only: ntry, p_switch, Hel
#endif
  use hol_initialisation_/**/REALKIND, only: G0_hol_initialisation
  use ol_h_vert_interface_/**/REALKIND
  use ol_h_prop_interface_/**/REALKIND
  use ol_h_last_step_/**/REALKIND
  use ol_merging_/**/REALKIND, only: ol_merge, ol_merge_tensors, ol_merge_last

  implicit none

  type(Hpolcont) :: Gcoeff(64)
  type(Hpolcont), intent(in) :: M(14,64)


#ifndef PRECISION_dp
  if (ntry==1 .OR. p_switch == 1) Gcoeff(:)%hf = Hel
#else
  if (ntry==1 .OR. p_switch == 2) Gcoeff(:)%hf = Hel
#endif

  ! =============================================


! Dressing, otf merging and otf reduction calls to build loop structures

Gcoeff(:)%j = (c(24)*M(9,:)%j+c(21)*(-M(10,:)%j-M(11,:)%j)+c(20)*M(12,:)%j)
call G0_hol_initialisation(ntry,Gcoeff,G0H64(1),m0h(1),h0tab(:,1),[32,8,2,1,4,16],[nMB,0,nMT,0,nMB,nMB],6,0)
  call Hloop_QV_A(ntry,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,1),heltab2x64(:,:,1))
  call Hloop_Q_A(ntry,G0H32(1),32,nMB,G1H32(1),n2h32(1))
Gcoeff(:)%j = (c(24)*M(5,:)%j+c(21)*(-M(6,:)%j-M(7,:)%j)+c(20)*M(8,:)%j)
call G0_hol_initialisation(ntry,Gcoeff,G0H64(1),m0h(2),h0tab(:,2),[32,4,1,2,8,16],[nMB,0,nMT,0,nMB,nMB],6,0)
  call Hloop_AV_Q(ntry,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,2),heltab2x64(:,:,2))
  call Hloop_A_Q(ntry,G0H32(1),32,nMB,G1H32(2),n2h32(2))
Gcoeff(:)%j = (c(21)*(M(2,:)%j+M(3,:)%j-M(6,:)%j-M(11,:)%j)+c(24)*(-M(1,:)%j-M(4,:)%j+M(5,:)%j+M(12,:)%j))
call G0_hol_initialisation(ntry,Gcoeff,G0H64(1),m0h(3),h0tab(:,3),[32,8,4,1,2,16],[0,nMB,0,nMT,0,0],6,0)
  call Hloop_UV_W(ntry,G0H64(1),0,ex6(:),32,G1H32(3),m3h2x32(:,3),heltab2x64(:,:,3))
Gcoeff(:)%j = (c(9)*(M(1,:)%j-M(5,:)%j)+c(6)*(-M(2,:)%j+M(6,:)%j))
call G0_hol_initialisation(ntry,Gcoeff,G0H64(1),m0h(4),h0tab(:,4),[32,4,1,2,16,8],[nMB,0,nMT,0,0,nMB],6,0)
  call Hloop_AV_Q(ntry,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,4),heltab2x64(:,:,4))
  call Hloop_A_Q(ntry,G0H32(1),32,nMB,G1H32(4),n2h32(3))
Gcoeff(:)%j = (c(24)*(-M(1,:)%j-M(4,:)%j+M(8,:)%j+M(9,:)%j)+c(21)*(M(2,:)%j+M(3,:)%j-M(7,:)%j-M(10,:)%j))
call G0_hol_initialisation(ntry,Gcoeff,G0H64(1),m0h(5),h0tab(:,5),[32,2,1,4,8,16],[0,nMT,0,nMB,0,0],6,0)
  call Hloop_UV_W(ntry,G0H64(1),0,ex6(:),32,G1H32(5),m3h2x32(:,5),heltab2x64(:,:,5))
Gcoeff(:)%j = (c(9)*(-M(4,:)%j+M(9,:)%j)+c(6)*(M(3,:)%j-M(10,:)%j))
call G0_hol_initialisation(ntry,Gcoeff,G0H64(1),m0h(6),h0tab(:,6),[32,2,1,4,16,8],[0,nMT,0,nMB,nMB,0],6,0)
  call Hloop_UV_W(ntry,G0H64(1),0,ex6(:),32,G1H32(6),m3h2x32(:,6),heltab2x64(:,:,6))
Gcoeff(:)%j = (c(21)*(-M(10,:)%j-M(11,:)%j)+c(20)*M(12,:)%j+c(24)*M(13,:)%j)
call G0_hol_initialisation(ntry,Gcoeff,G0H64(1),m0h(7),h0tab(:,7),[32,8,1,2,4,16],[nMB,0,nMT,0,nMB,nMB],6,0)
  call Hloop_QV_A(ntry,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,7),heltab2x64(:,:,7))
  call Hloop_Q_A(ntry,G0H32(1),32,nMB,G1H32(7),n2h32(4))
Gcoeff(:)%j = (c(21)*(-M(6,:)%j-M(7,:)%j)+c(20)*M(8,:)%j+c(24)*M(13,:)%j)
call G0_hol_initialisation(ntry,Gcoeff,G0H64(1),m0h(8),h0tab(:,8),[32,4,2,1,8,16],[nMB,0,nMT,0,nMB,nMB],6,0)
  call Hloop_AV_Q(ntry,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,8),heltab2x64(:,:,8))
  call Hloop_A_Q(ntry,G0H32(1),32,nMB,G1H32(8),n2h32(5))
Gcoeff(:)%j = (c(28)*M(6,:)%j+c(21)*(M(2,:)%j+M(3,:)%j-M(11,:)%j)+c(24)*M(13,:)%j)
call G0_hol_initialisation(ntry,Gcoeff,G0H64(1),m0h(9),h0tab(:,9),[32,4,8,1,2,16],[0,nMB,0,nMT,0,0],6,0)
  call Hloop_UV_W(ntry,G0H64(1),0,ex6(:),32,G1H32(9),m3h2x32(:,9),heltab2x64(:,:,9))
Gcoeff(:)%j = (c(6)*(-M(3,:)%j+M(11,:)%j)-c(9)*M(13,:)%j)
call G0_hol_initialisation(ntry,Gcoeff,G0H64(1),m0h(10),h0tab(:,10),[32,4,16,2,1,8],[nMB,0,0,nMT,0,nMB],6,0)
  call Hloop_AV_Q(ntry,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,10),heltab2x64(:,:,10))
  call Hloop_A_Q(ntry,G0H32(1),32,nMB,G1H32(10),n2h32(6))
Gcoeff(:)%j = (c(21)*(M(2,:)%j+M(3,:)%j-M(7,:)%j)+c(28)*M(10,:)%j+c(24)*M(13,:)%j)
call G0_hol_initialisation(ntry,Gcoeff,G0H64(1),m0h(11),h0tab(:,11),[32,2,1,8,4,16],[0,nMT,0,nMB,0,0],6,0)
  call Hloop_UV_W(ntry,G0H64(1),0,ex6(:),32,G1H32(11),m3h2x32(:,11),heltab2x64(:,:,11))
Gcoeff(:)%j = (c(6)*(-M(2,:)%j+M(7,:)%j)-c(9)*M(13,:)%j)
call G0_hol_initialisation(ntry,Gcoeff,G0H64(1),m0h(12),h0tab(:,12),[32,2,1,8,16,4],[0,nMT,0,nMB,nMB,0],6,0)
  call Hloop_UV_W(ntry,G0H64(1),0,ex6(:),32,G1H32(12),m3h2x32(:,12),heltab2x64(:,:,12))
Gcoeff(:)%j = (c(21)*(M(2,:)%j+M(3,:)%j-M(6,:)%j)+c(28)*M(11,:)%j+c(24)*M(13,:)%j)
call G0_hol_initialisation(ntry,Gcoeff,G0H64(1),m0h(13),h0tab(:,13),[32,8,4,2,1,16],[0,nMB,0,nMT,0,0],6,0)
  call Hloop_UV_W(ntry,G0H64(1),0,ex6(:),32,G1H32(13),m3h2x32(:,13),heltab2x64(:,:,13))
Gcoeff(:)%j = (c(6)*(-M(2,:)%j+M(6,:)%j)-c(9)*M(13,:)%j)
call G0_hol_initialisation(ntry,Gcoeff,G0H64(1),m0h(14),h0tab(:,14),[32,4,2,1,16,8],[nMB,0,nMT,0,0,nMB],6,0)
  call Hloop_AV_Q(ntry,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,14),heltab2x64(:,:,14))
  call Hloop_A_Q(ntry,G0H32(1),32,nMB,G1H32(14),n2h32(7))
Gcoeff(:)%j = (c(24)*(-M(1,:)%j-M(4,:)%j+M(8,:)%j+M(9,:)%j)+c(21)*(M(2,:)%j+M(3,:)%j-M(6,:)%j-M(11,:)%j))
call G0_hol_initialisation(ntry,Gcoeff,G0H64(1),m0h(15),h0tab(:,15),[32,4,8,2,1,16],[0,nMB,0,nMT,0,0],6,0)
  call Hloop_UV_W(ntry,G0H64(1),0,ex6(:),32,G1H32(15),m3h2x32(:,15),heltab2x64(:,:,15))
Gcoeff(:)%j = (c(9)*(M(1,:)%j-M(9,:)%j)+c(6)*(-M(3,:)%j+M(11,:)%j))
call G0_hol_initialisation(ntry,Gcoeff,G0H64(1),m0h(16),h0tab(:,16),[32,4,16,1,2,8],[nMB,0,0,nMT,0,nMB],6,0)
  call Hloop_AV_Q(ntry,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,16),heltab2x64(:,:,16))
  call Hloop_A_Q(ntry,G0H32(1),32,nMB,G1H32(16),n2h32(8))
Gcoeff(:)%j = (c(24)*(-M(1,:)%j-M(4,:)%j+M(9,:)%j+M(12,:)%j))
call G0_hol_initialisation(ntry,Gcoeff,G0H64(1),m0h(17),h0tab(:,17),[32,2,1,16,4,8],[0,nMT,0,0,nMB,0],6,0)
  call Hloop_UV_W(ntry,G0H64(1),0,ex6(:),32,G1H32(17),m3h2x32(:,17),heltab2x64(:,:,17))
Gcoeff(:)%j = (c(29)*M(2,:)%j+c(24)*M(13,:)%j)
call G0_hol_initialisation(ntry,Gcoeff,G0H64(1),m0h(18),h0tab(:,18),[32,2,1,16,8,4],[0,nMT,0,0,nMB,0],6,0)
  call Hloop_UV_W(ntry,G0H64(1),0,ex6(:),32,G1H32(18),m3h2x32(:,18),heltab2x64(:,:,18))
Gcoeff(:)%j = (c(28)*M(7,:)%j+c(21)*(M(2,:)%j+M(3,:)%j-M(10,:)%j)+c(24)*M(13,:)%j)
call G0_hol_initialisation(ntry,Gcoeff,G0H64(1),m0h(19),h0tab(:,19),[32,1,2,4,8,16],[0,nMT,0,nMB,0,0],6,0)
  call Hloop_UV_W(ntry,G0H64(1),0,ex6(:),32,G1H32(19),m3h2x32(:,19),heltab2x64(:,:,19))
Gcoeff(:)%j = (c(6)*(M(3,:)%j-M(10,:)%j)+c(9)*M(13,:)%j)
call G0_hol_initialisation(ntry,Gcoeff,G0H64(1),m0h(20),h0tab(:,20),[32,1,2,4,16,8],[0,nMT,0,nMB,nMB,0],6,0)
  call Hloop_UV_W(ntry,G0H64(1),0,ex6(:),32,G1H32(20),m3h2x32(:,20),heltab2x64(:,:,20))
Gcoeff(:)%j = (c(21)*(M(2,:)%j+M(3,:)%j-M(7,:)%j-M(10,:)%j)+c(24)*(-M(1,:)%j-M(4,:)%j+M(5,:)%j+M(12,:)%j))
call G0_hol_initialisation(ntry,Gcoeff,G0H64(1),m0h(21),h0tab(:,21),[32,1,2,8,4,16],[0,nMT,0,nMB,0,0],6,0)
  call Hloop_UV_W(ntry,G0H64(1),0,ex6(:),32,G1H32(21),m3h2x32(:,21),heltab2x64(:,:,21))
Gcoeff(:)%j = (c(9)*(M(4,:)%j-M(5,:)%j)+c(6)*(-M(2,:)%j+M(7,:)%j))
call G0_hol_initialisation(ntry,Gcoeff,G0H64(1),m0h(22),h0tab(:,22),[32,1,2,8,16,4],[0,nMT,0,nMB,nMB,0],6,0)
  call Hloop_UV_W(ntry,G0H64(1),0,ex6(:),32,G1H32(22),m3h2x32(:,22),heltab2x64(:,:,22))
Gcoeff(:)%j = (c(29)*M(3,:)%j+c(24)*M(13,:)%j)
call G0_hol_initialisation(ntry,Gcoeff,G0H64(1),m0h(23),h0tab(:,23),[32,1,2,16,4,8],[0,nMT,0,0,nMB,0],6,0)
  call Hloop_UV_W(ntry,G0H64(1),0,ex6(:),32,G1H32(23),m3h2x32(:,23),heltab2x64(:,:,23))
Gcoeff(:)%j = (c(24)*(-M(1,:)%j-M(4,:)%j+M(5,:)%j+M(8,:)%j))
call G0_hol_initialisation(ntry,Gcoeff,G0H64(1),m0h(24),h0tab(:,24),[32,1,2,16,8,4],[0,nMT,0,0,nMB,0],6,0)
  call Hloop_UV_W(ntry,G0H64(1),0,ex6(:),32,G1H32(24),m3h2x32(:,24),heltab2x64(:,:,24))
Gcoeff(:)%j = (c(24)*M(1,:)%j+c(21)*(-M(2,:)%j-M(3,:)%j)+c(20)*M(4,:)%j)
call G0_hol_initialisation(ntry,Gcoeff,G0H64(1),m0h(25),h0tab(:,25),[32,4,1,16,2,8],[nMB,0,nMT,nMT,0,nMB],6,0)
  call Hloop_AV_Q(ntry,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,25),heltab2x64(:,:,25))
  call Hloop_A_Q(ntry,G0H32(1),32,nMB,G1H32(25),n2h32(9))
Gcoeff(:)%j = (c(20)*M(9,:)%j+c(21)*(-M(10,:)%j-M(11,:)%j)+c(24)*M(12,:)%j)
call G0_hol_initialisation(ntry,Gcoeff,G0H64(1),m0h(26),h0tab(:,26),[32,2,8,4,1,16],[nMT,0,nMB,0,nMT,nMT],6,0)
  call Hloop_QV_A(ntry,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,26),heltab2x64(:,:,26))
  call Hloop_Q_A(ntry,G0H32(1),32,nMT,G1H32(26),n2h32(10))
Gcoeff(:)%j = (c(6)*(-M(2,:)%j+M(11,:)%j)+c(9)*(M(1,:)%j-M(12,:)%j))
call G0_hol_initialisation(ntry,Gcoeff,G0H64(1),m0h(27),h0tab(:,27),[32,2,16,1,4,8],[0,nMT,nMT,0,nMB,0],6,0)
  call Hloop_UV_W(ntry,G0H64(1),0,ex6(:),32,G1H32(27),m3h2x32(:,27),heltab2x64(:,:,27))
Gcoeff(:)%j = (c(20)*M(5,:)%j+c(21)*(-M(6,:)%j-M(7,:)%j)+c(24)*M(8,:)%j)
call G0_hol_initialisation(ntry,Gcoeff,G0H64(1),m0h(28),h0tab(:,28),[32,1,4,8,2,16],[nMT,0,nMB,0,nMT,nMT],6,0)
  call Hloop_AV_Q(ntry,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,28),heltab2x64(:,:,28))
  call Hloop_A_Q(ntry,G0H32(1),32,nMT,G1H32(28),n2h32(11))
Gcoeff(:)%j = (c(20)*M(1,:)%j+c(21)*(-M(2,:)%j-M(3,:)%j)+c(24)*M(4,:)%j)
call G0_hol_initialisation(ntry,Gcoeff,G0H64(1),m0h(29),h0tab(:,29),[32,1,4,16,8,2],[nMT,0,nMB,nMB,0,nMT],6,0)
  call Hloop_AV_Q(ntry,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,29),heltab2x64(:,:,29))
  call Hloop_A_Q(ntry,G0H32(1),32,nMT,G1H32(29),n2h32(12))
Gcoeff(:)%j = (c(6)*(-M(3,:)%j+M(7,:)%j)+c(9)*(M(4,:)%j-M(8,:)%j))
call G0_hol_initialisation(ntry,Gcoeff,G0H64(1),m0h(30),h0tab(:,30),[32,1,4,8,16,2],[nMT,0,nMB,0,0,nMT],6,0)
  call Hloop_AV_Q(ntry,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,30),heltab2x64(:,:,30))
  call Hloop_A_Q(ntry,G0H32(1),32,nMT,G1H32(30),n2h32(13))
Gcoeff(:)%j = (c(20)*M(4,:)%j+c(21)*(-M(6,:)%j-M(11,:)%j)+c(24)*M(13,:)%j)
call G0_hol_initialisation(ntry,Gcoeff,G0H64(1),m0h(31),h0tab(:,31),[32,4,2,16,1,8],[nMB,0,nMT,nMT,0,nMB],6,0)
  call Hloop_AV_Q(ntry,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,31),heltab2x64(:,:,31))
  call Hloop_A_Q(ntry,G0H32(1),32,nMB,G1H32(31),n2h32(14))
Gcoeff(:)%j = (c(20)*M(9,:)%j+c(21)*(-M(10,:)%j-M(11,:)%j)+c(24)*M(13,:)%j)
call G0_hol_initialisation(ntry,Gcoeff,G0H64(1),m0h(32),h0tab(:,32),[32,2,4,8,1,16],[nMT,0,nMB,0,nMT,nMT],6,0)
  call Hloop_QV_A(ntry,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,32),heltab2x64(:,:,32))
  call Hloop_Q_A(ntry,G0H32(1),32,nMT,G1H32(32),n2h32(15))
Gcoeff(:)%j = (c(6)*(-M(2,:)%j+M(11,:)%j)-c(9)*M(13,:)%j)
call G0_hol_initialisation(ntry,Gcoeff,G0H64(1),m0h(33),h0tab(:,33),[32,2,16,1,8,4],[0,nMT,nMT,0,nMB,0],6,0)
  call Hloop_UV_W(ntry,G0H64(1),0,ex6(:),32,G1H32(33),m3h2x32(:,33),heltab2x64(:,:,33))
Gcoeff(:)%j = (c(20)*M(5,:)%j+c(21)*(-M(6,:)%j-M(7,:)%j)+c(24)*M(13,:)%j)
call G0_hol_initialisation(ntry,Gcoeff,G0H64(1),m0h(34),h0tab(:,34),[32,1,8,4,2,16],[nMT,0,nMB,0,nMT,nMT],6,0)
  call Hloop_AV_Q(ntry,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,34),heltab2x64(:,:,34))
  call Hloop_A_Q(ntry,G0H32(1),32,nMT,G1H32(34),n2h32(16))
Gcoeff(:)%j = (c(20)*M(1,:)%j+c(21)*(-M(7,:)%j-M(10,:)%j)+c(24)*M(13,:)%j)
call G0_hol_initialisation(ntry,Gcoeff,G0H64(1),m0h(35),h0tab(:,35),[32,1,8,16,4,2],[nMT,0,nMB,nMB,0,nMT],6,0)
  call Hloop_AV_Q(ntry,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,35),heltab2x64(:,:,35))
  call Hloop_A_Q(ntry,G0H32(1),32,nMT,G1H32(35),n2h32(17))
Gcoeff(:)%j = (c(6)*(-M(3,:)%j+M(7,:)%j)-c(9)*M(13,:)%j)
call G0_hol_initialisation(ntry,Gcoeff,G0H64(1),m0h(36),h0tab(:,36),[32,1,8,4,16,2],[nMT,0,nMB,0,0,nMT],6,0)
  call Hloop_AV_Q(ntry,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,36),heltab2x64(:,:,36))
  call Hloop_A_Q(ntry,G0H32(1),32,nMT,G1H32(36),n2h32(18))
Gcoeff(:)%j = (c(6)*(M(3,:)%j-M(6,:)%j)+c(9)*M(13,:)%j)
call G0_hol_initialisation(ntry,Gcoeff,G0H64(1),m0h(37),h0tab(:,37),[32,1,16,2,4,8],[0,nMT,nMT,0,nMB,0],6,0)
  call Hloop_UV_W(ntry,G0H64(1),0,ex6(:),32,G1H32(37),m3h2x32(:,37),heltab2x64(:,:,37))
Gcoeff(:)%j = (c(6)*(-M(2,:)%j+M(10,:)%j)-c(9)*M(13,:)%j)
call G0_hol_initialisation(ntry,Gcoeff,G0H64(1),m0h(38),h0tab(:,38),[32,1,16,8,4,2],[nMT,0,0,nMB,0,nMT],6,0)
  call Hloop_AV_Q(ntry,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,38),heltab2x64(:,:,38))
  call Hloop_A_Q(ntry,G0H32(1),32,nMT,G1H32(38),n2h32(19))
Gcoeff(:)%j = (c(6)*(M(3,:)%j-M(6,:)%j)+c(9)*(-M(1,:)%j+M(8,:)%j))
call G0_hol_initialisation(ntry,Gcoeff,G0H64(1),m0h(39),h0tab(:,39),[32,1,16,2,8,4],[0,nMT,nMT,0,nMB,0],6,0)
  call Hloop_UV_W(ntry,G0H64(1),0,ex6(:),32,G1H32(39),m3h2x32(:,39),heltab2x64(:,:,39))
Gcoeff(:)%j = (c(6)*(-M(2,:)%j+M(10,:)%j)+c(9)*(M(4,:)%j-M(12,:)%j))
call G0_hol_initialisation(ntry,Gcoeff,G0H64(1),m0h(40),h0tab(:,40),[32,1,16,4,8,2],[nMT,0,0,nMB,0,nMT],6,0)
  call Hloop_AV_Q(ntry,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,40),heltab2x64(:,:,40))
  call Hloop_A_Q(ntry,G0H32(1),32,nMT,G1H32(40),n2h32(20))
  call Hloop_QA_V(ntry,G1H32(1),ex4(:),G1H16(1),m3h2x16(:,1),heltab2x32(:,:,1))
  call Hloop_AQ_V(ntry,G1H32(2),ex3(:),G1H16(2),m3h2x16(:,2),heltab2x32(:,:,2))
  call Hloop_VA_Q(ntry,G1H32(3),ex4(:),G1H16(3),m3h2x16(:,3),heltab2x32(:,:,3))
  call Hloop_A_Q(ntry,G1H16(3),40,nMB,G2H16(1),n2h16(1))
  call Hloop_AQ_V(ntry,G1H32(4),ex3(:),G1H16(3),m3h2x16(:,4),heltab2x32(:,:,4))
  call Hloop_VA_Q(ntry,G1H32(5),ex2(:),G1H16(4),m3h2x16(:,5),heltab2x32(:,:,5))
  call Hloop_A_Q(ntry,G1H16(4),34,nMT,G2H16(2),n2h16(2))
  call Hloop_VA_Q(ntry,G1H32(6),ex2(:),G1H16(4),m3h2x16(:,6),heltab2x32(:,:,6))
  call Hloop_A_Q(ntry,G1H16(4),34,nMT,G2H16(3),n2h16(3))
  call Hloop_QA_V(ntry,G1H32(7),ex4(:),G1H16(4),m3h2x16(:,7),heltab2x32(:,:,7))
  call Hloop_AQ_V(ntry,G1H32(8),ex3(:),G1H16(5),m3h2x16(:,8),heltab2x32(:,:,8))
  call Hloop_VQ_A(ntry,G1H32(9),ex3(:),G1H16(6),m3h2x16(:,9),heltab2x32(:,:,9))
  call Hloop_Q_A(ntry,G1H16(6),36,nMB,G2H16(4),n2h16(4))
  call Hloop_AQ_V(ntry,G1H32(10),ex3(:),G1H16(6),m3h2x16(:,10),heltab2x32(:,:,10))
  call Hloop_VA_Q(ntry,G1H32(11),ex2(:),G1H16(7),m3h2x16(:,11),heltab2x32(:,:,11))
  call Hloop_A_Q(ntry,G1H16(7),34,nMT,G2H16(5),n2h16(5))
  call Hloop_VA_Q(ntry,G1H32(12),ex2(:),G1H16(7),m3h2x16(:,12),heltab2x32(:,:,12))
  call Hloop_A_Q(ntry,G1H16(7),34,nMT,G2H16(6),n2h16(6))
  call Hloop_VA_Q(ntry,G1H32(13),ex4(:),G1H16(7),m3h2x16(:,13),heltab2x32(:,:,13))
  call Hloop_A_Q(ntry,G1H16(7),40,nMB,G2H16(7),n2h16(7))
  call Hloop_AQ_V(ntry,G1H32(14),ex3(:),G1H16(7),m3h2x16(:,14),heltab2x32(:,:,14))
  call Hloop_VQ_A(ntry,G1H32(15),ex3(:),G1H16(8),m3h2x16(:,15),heltab2x32(:,:,15))
  call Hloop_Q_A(ntry,G1H16(8),36,nMB,G2H16(8),n2h16(8))
  call Hloop_AQ_V(ntry,G1H32(16),ex3(:),G1H16(8),m3h2x16(:,16),heltab2x32(:,:,16))
  call Hloop_VA_Q(ntry,G1H32(17),ex2(:),G1H16(9),m3h2x16(:,17),heltab2x32(:,:,17))
  call Hloop_A_Q(ntry,G1H16(9),34,nMT,G2H16(9),n2h16(9))
  call Hloop_VA_Q(ntry,G1H32(18),ex2(:),G1H16(9),m3h2x16(:,18),heltab2x32(:,:,18))
  call Hloop_A_Q(ntry,G1H16(9),34,nMT,G2H16(10),n2h16(10))
  call Hloop_VQ_A(ntry,G1H32(19),ex1(:),G1H16(9),m3h2x16(:,19),heltab2x32(:,:,19))
  call Hloop_Q_A(ntry,G1H16(9),33,nMT,G2H16(11),n2h16(11))
  call Hloop_VQ_A(ntry,G1H32(20),ex1(:),G1H16(9),m3h2x16(:,20),heltab2x32(:,:,20))
  call Hloop_Q_A(ntry,G1H16(9),33,nMT,G2H16(12),n2h16(12))
  call Hloop_VQ_A(ntry,G1H32(21),ex1(:),G1H16(9),m3h2x16(:,21),heltab2x32(:,:,21))
  call Hloop_Q_A(ntry,G1H16(9),33,nMT,G2H16(13),n2h16(13))
  call Hloop_VQ_A(ntry,G1H32(22),ex1(:),G1H16(9),m3h2x16(:,22),heltab2x32(:,:,22))
  call Hloop_Q_A(ntry,G1H16(9),33,nMT,G2H16(14),n2h16(14))
  call Hloop_VQ_A(ntry,G1H32(23),ex1(:),G1H16(9),m3h2x16(:,23),heltab2x32(:,:,23))
  call Hloop_Q_A(ntry,G1H16(9),33,nMT,G2H16(15),n2h16(15))
  call Hloop_VQ_A(ntry,G1H32(24),ex1(:),G1H16(9),m3h2x16(:,24),heltab2x32(:,:,24))
  call Hloop_Q_A(ntry,G1H16(9),33,nMT,G2H16(16),n2h16(16))
  call Hloop_AQ_V(ntry,G1H32(25),ex3(:),G1H16(9),m3h2x16(:,25),heltab2x32(:,:,25))
  call Hloop_QA_V(ntry,G1H32(26),ex2(:),G1H16(10),m3h2x16(:,26),heltab2x32(:,:,26))
  call Hloop_VA_Q(ntry,G1H32(27),ex2(:),G1H16(11),m3h2x16(:,27),heltab2x32(:,:,27))
  call Hloop_A_Q(ntry,G1H16(11),34,nMT,G2H16(17),n2h16(17))
  call Hloop_AQ_V(ntry,G1H32(28),ex1(:),G1H16(11),m3h2x16(:,28),heltab2x32(:,:,28))
  call Hloop_AQ_V(ntry,G1H32(29),ex1(:),G1H16(12),m3h2x16(:,29),heltab2x32(:,:,29))
  call Hloop_AQ_V(ntry,G1H32(30),ex1(:),G1H16(13),m3h2x16(:,30),heltab2x32(:,:,30))
  call Hloop_AQ_V(ntry,G1H32(31),ex3(:),G1H16(14),m3h2x16(:,31),heltab2x32(:,:,31))
  call Hloop_QA_V(ntry,G1H32(32),ex2(:),G1H16(15),m3h2x16(:,32),heltab2x32(:,:,32))
  call Hloop_VA_Q(ntry,G1H32(33),ex2(:),G1H16(16),m3h2x16(:,33),heltab2x32(:,:,33))
  call Hloop_A_Q(ntry,G1H16(16),34,nMT,G2H16(18),n2h16(18))
  call Hloop_AQ_V(ntry,G1H32(34),ex1(:),G1H16(16),m3h2x16(:,34),heltab2x32(:,:,34))
  call Hloop_AQ_V(ntry,G1H32(35),ex1(:),G1H16(17),m3h2x16(:,35),heltab2x32(:,:,35))
  call Hloop_AQ_V(ntry,G1H32(36),ex1(:),G1H16(18),m3h2x16(:,36),heltab2x32(:,:,36))
  call Hloop_VQ_A(ntry,G1H32(37),ex1(:),G1H16(19),m3h2x16(:,37),heltab2x32(:,:,37))
  call Hloop_Q_A(ntry,G1H16(19),33,nMT,G2H16(19),n2h16(19))
  call Hloop_AQ_V(ntry,G1H32(38),ex1(:),G1H16(19),m3h2x16(:,38),heltab2x32(:,:,38))
  call Hloop_VQ_A(ntry,G1H32(39),ex1(:),G1H16(20),m3h2x16(:,39),heltab2x32(:,:,39))
  call Hloop_Q_A(ntry,G1H16(20),33,nMT,G2H16(20),n2h16(20))
  call Hloop_AQ_V(ntry,G1H32(40),ex1(:),G1H16(20),m3h2x16(:,40),heltab2x32(:,:,40))
  call Hloop_VA_Q(ntry,G1H16(1),ex2(:),G1H8(1),m3h2x8(:,1),heltab2x16(:,:,1))
  call Hloop_A_Q(ntry,G1H8(1),42,nMT,G2H8(1),n2h8(1))
  call Hloop_VQ_A(ntry,G1H16(2),ex1(:),G1H8(1),m3h2x8(:,2),heltab2x16(:,:,2))
  call Hloop_Q_A(ntry,G1H8(1),37,nMT,G2H8(2),n2h8(2))
  call Hloop_AQ_V(ntry,G2H16(1),ex3(:),G2H8(3),m3h2x8(:,3),heltab2x16(:,:,3))
  call Hloop_VQ_A(ntry,G1H16(3),ex1(:),G1H8(1),m3h2x8(:,4),heltab2x16(:,:,4))
  call Hloop_Q_A(ntry,G1H8(1),37,nMT,G2H8(4),n2h8(3))
  call Hloop_AQ_V(ntry,G2H16(2),ex1(:),G2H8(5),m3h2x8(:,5),heltab2x16(:,:,5))
  call Hloop_AQ_V(ntry,G2H16(3),ex1(:),G2H8(6),m3h2x8(:,6),heltab2x16(:,:,6))
  call Hloop_VQ_A(ntry,G1H16(4),ex1(:),G1H8(1),m3h2x8(:,7),heltab2x16(:,:,7))
  call Hloop_Q_A(ntry,G1H8(1),41,nMT,G2H8(7),n2h8(4))
  call Hloop_VA_Q(ntry,G1H16(5),ex2(:),G1H8(1),m3h2x8(:,8),heltab2x16(:,:,8))
  call Hloop_A_Q(ntry,G1H8(1),38,nMT,G2H8(8),n2h8(5))
  call Hloop_QA_V(ntry,G2H16(4),ex4(:),G2H8(9),m3h2x8(:,9),heltab2x16(:,:,9))
  call Hloop_UV_W(ntry,G1H16(6),36,ex5(:),16,G2H8(10),m3h2x8(:,10),heltab2x16(:,:,10))
  call Hloop_AQ_V(ntry,G2H16(5),ex1(:),G2H8(11),m3h2x8(:,11),heltab2x16(:,:,11))
  call Hloop_AQ_V(ntry,G2H16(6),ex1(:),G2H8(12),m3h2x8(:,12),heltab2x16(:,:,12))
  call Hloop_AQ_V(ntry,G2H16(7),ex3(:),G2H8(13),m3h2x8(:,13),heltab2x16(:,:,13))
  call Hloop_VA_Q(ntry,G1H16(7),ex2(:),G1H8(1),m3h2x8(:,14),heltab2x16(:,:,14))
  call Hloop_A_Q(ntry,G1H8(1),38,nMT,G2H8(14),n2h8(6))
  call Hloop_QA_V(ntry,G2H16(8),ex4(:),G2H8(15),m3h2x8(:,15),heltab2x16(:,:,15))
  call Hloop_UV_W(ntry,G1H16(8),36,ex5(:),16,G2H8(16),m3h2x8(:,16),heltab2x16(:,:,16))
  call Hloop_AQ_V(ntry,G2H16(9),ex1(:),G2H8(17),m3h2x8(:,17),heltab2x16(:,:,17))
  call Hloop_AQ_V(ntry,G2H16(10),ex1(:),G2H8(18),m3h2x8(:,18),heltab2x16(:,:,18))
  call Hloop_QA_V(ntry,G2H16(11),ex2(:),G2H8(19),m3h2x8(:,19),heltab2x16(:,:,19))
  call Hloop_QA_V(ntry,G2H16(12),ex2(:),G2H8(20),m3h2x8(:,20),heltab2x16(:,:,20))
  call Hloop_QA_V(ntry,G2H16(13),ex2(:),G2H8(21),m3h2x8(:,21),heltab2x16(:,:,21))
  call Hloop_QA_V(ntry,G2H16(14),ex2(:),G2H8(22),m3h2x8(:,22),heltab2x16(:,:,22))
  call Hloop_QA_V(ntry,G2H16(15),ex2(:),G2H8(23),m3h2x8(:,23),heltab2x16(:,:,23))
  call Hloop_QA_V(ntry,G2H16(16),ex2(:),G2H8(24),m3h2x8(:,24),heltab2x16(:,:,24))
  call Hloop_VQ_A(ntry,G1H16(9),ex1(:),G1H8(1),m3h2x8(:,25),heltab2x16(:,:,25))
  call Hloop_Q_A(ntry,G1H8(1),37,nMT,G2H8(25),n2h8(7))
  call Hloop_VA_Q(ntry,G1H16(10),ex4(:),G1H8(1),m3h2x8(:,26),heltab2x16(:,:,26))
  call Hloop_A_Q(ntry,G1H8(1),42,nMB,G2H8(26),n2h8(8))
call Hotf_5pt_reduction(G2H16(17),RedSet_5(1),mass5set(:,1),  & 
G1H16(1),G1H16(2),G1H16(3),G1H16(4),G1H16(5),G1H16(6),16)
call HG1shiftOLR(G1H16(2),8,16)
  call Hloop_VQ_A(ntry,G1H16(11),ex3(:),G1H8(1),m3h2x8(:,27),heltab2x16(:,:,27))
  call Hloop_Q_A(ntry,G1H8(1),37,nMB,G2H8(27),n2h8(9))
  call Hloop_VQ_A(ntry,G1H16(12),ex3(:),G1H8(1),m3h2x8(:,28),heltab2x16(:,:,28))
  call Hloop_Q_A(ntry,G1H8(1),37,nMB,G2H8(28),n2h8(10))
  call Hloop_VQ_A(ntry,G1H16(13),ex3(:),G1H8(1),m3h2x8(:,29),heltab2x16(:,:,29))
  call Hloop_Q_A(ntry,G1H8(1),37,nMB,G2H8(29),n2h8(11))
  call Hloop_VA_Q(ntry,G1H16(14),ex2(:),G1H8(1),m3h2x8(:,30),heltab2x16(:,:,30))
  call Hloop_A_Q(ntry,G1H8(1),38,nMT,G2H8(30),n2h8(12))
  call Hloop_VQ_A(ntry,G1H16(15),ex3(:),G1H8(1),m3h2x8(:,31),heltab2x16(:,:,31))
  call Hloop_Q_A(ntry,G1H8(1),38,nMB,G2H8(31),n2h8(13))
call Hotf_5pt_reduction(G2H16(18),RedSet_5(1),mass5set(:,1),  & 
G1H16(7),G1H16(8),G1H16(9),G1H16(10),G1H16(11),G1H16(12),16)
call HG1shiftOLR(G1H16(8),4,16)
  call Hloop_VA_Q(ntry,G1H16(16),ex4(:),G1H8(1),m3h2x8(:,32),heltab2x16(:,:,32))
  call Hloop_A_Q(ntry,G1H8(1),41,nMB,G2H8(32),n2h8(14))
  call Hloop_VA_Q(ntry,G1H16(17),ex4(:),G1H8(1),m3h2x8(:,33),heltab2x16(:,:,33))
  call Hloop_A_Q(ntry,G1H8(1),41,nMB,G2H8(33),n2h8(15))
  call Hloop_VA_Q(ntry,G1H16(18),ex4(:),G1H8(1),m3h2x8(:,34),heltab2x16(:,:,34))
  call Hloop_A_Q(ntry,G1H8(1),41,nMB,G2H8(34),n2h8(16))
call Hotf_5pt_reduction(G2H16(19),RedSet_5(2),mass5set(:,1),  & 
G1H16(13),G1H16(14),G1H16(15),G1H16(16),G1H16(17),G1H16(18),16)
call HG1shiftOLR(G1H16(14),8,16)
  call Hloop_UV_W(ntry,G1H16(19),33,ex5(:),16,G2H8(35),m3h2x8(:,35),heltab2x16(:,:,35))
call Hotf_5pt_reduction(G2H16(20),RedSet_5(2),mass5set(:,1),  & 
G1H16(19),G1H16(21),G1H16(22),G1H16(23),G1H16(24),G1H16(25),16)
call HG1shiftOLR(G1H16(21),4,16)
  call Hloop_UV_W(ntry,G1H16(20),33,ex5(:),16,G2H8(36),m3h2x8(:,36),heltab2x16(:,:,36))
  call Hloop_AV_Q(ntry,G1H16(1),ex5(:),G1H8(1),m3h2x8(:,37),heltab2x16(:,:,37))
  call Hloop_A_Q(ntry,G1H8(1),50,nMT,G2H8(37),n2h8(17))
call HGT_raise_alpha_OLR(G1H16(2),1,1,16)
call HGT_raise_alpha_invQ_OLR(G1H16(2),2,5,16)
  call Hloop_VA_Q(ntry,G1H16(2),ex4(:),G1H8(1),m3h2x8(:,38),heltab2x16(:,:,38))
  call Hloop_AV_Q(ntry,G1H16(4),ex5(:),G1H8(2),m3h2x8(:,39),heltab2x16(:,:,39))
  call Hloop_A_Q(ntry,G1H8(2),50,nMT,G2H8(38),n2h8(18))
  call Hloop_AV_Q(ntry,G1H16(5),ex5(:),G1H8(2),m3h2x8(:,40),heltab2x16(:,:,40))
  call Hloop_A_Q(ntry,G1H8(2),50,nMT,G2H8(39),n2h8(19))
  call Hloop_AV_Q(ntry,G1H16(6),ex5(:),G1H8(2),m3h2x8(:,41),heltab2x16(:,:,41))
  call Hloop_A_Q(ntry,G1H8(2),50,nMT,G2H8(40),n2h8(20))
  call Hloop_AV_Q(ntry,G1H16(7),ex5(:),G1H8(2),m3h2x8(:,42),heltab2x16(:,:,42))
  call Hloop_A_Q(ntry,G1H8(2),50,nMT,G2H8(41),n2h8(21))
call HGT_raise_alpha_OLR(G1H16(8),1,1,16)
call HGT_raise_alpha_invQ_OLR(G1H16(8),2,5,16)
  call Hloop_VQ_A(ntry,G1H16(8),ex3(:),G1H8(2),m3h2x8(:,43),heltab2x16(:,:,43))
  call Hloop_AV_Q(ntry,G1H16(10),ex5(:),G1H8(3),m3h2x8(:,44),heltab2x16(:,:,44))
  call Hloop_A_Q(ntry,G1H8(3),50,nMT,G2H8(42),n2h8(22))
  call Hloop_AV_Q(ntry,G1H16(11),ex5(:),G1H8(3),m3h2x8(:,45),heltab2x16(:,:,45))
  call Hloop_A_Q(ntry,G1H8(3),50,nMT,G2H8(43),n2h8(23))
  call Hloop_AV_Q(ntry,G1H16(12),ex5(:),G1H8(3),m3h2x8(:,46),heltab2x16(:,:,46))
  call Hloop_A_Q(ntry,G1H8(3),50,nMT,G2H8(44),n2h8(24))
  call Hloop_QV_A(ntry,G1H16(13),ex5(:),G1H8(3),m3h2x8(:,47),heltab2x16(:,:,47))
  call Hloop_Q_A(ntry,G1H8(3),49,nMT,G2H8(45),n2h8(25))
call HGT_raise_alpha_OLR(G1H16(14),1,1,16)
call HGT_raise_alpha_invQ_OLR(G1H16(14),2,5,16)
  call Hloop_VA_Q(ntry,G1H16(14),ex4(:),G1H8(3),m3h2x8(:,48),heltab2x16(:,:,48))
  call Hloop_QV_A(ntry,G1H16(16),ex5(:),G1H8(4),m3h2x8(:,49),heltab2x16(:,:,49))
  call Hloop_Q_A(ntry,G1H8(4),49,nMT,G2H8(46),n2h8(26))
  call Hloop_QV_A(ntry,G1H16(17),ex5(:),G1H8(4),m3h2x8(:,50),heltab2x16(:,:,50))
  call Hloop_Q_A(ntry,G1H8(4),49,nMT,G2H8(47),n2h8(27))
  call Hloop_QV_A(ntry,G1H16(18),ex5(:),G1H8(4),m3h2x8(:,51),heltab2x16(:,:,51))
  call Hloop_Q_A(ntry,G1H8(4),49,nMT,G2H8(48),n2h8(28))
  call Hloop_QV_A(ntry,G1H16(19),ex5(:),G1H8(4),m3h2x8(:,52),heltab2x16(:,:,52))
  call Hloop_Q_A(ntry,G1H8(4),49,nMT,G2H8(49),n2h8(29))
call HGT_raise_alpha_OLR(G1H16(21),1,1,16)
call HGT_raise_alpha_invQ_OLR(G1H16(21),2,5,16)
  call Hloop_VQ_A(ntry,G1H16(21),ex3(:),G1H8(4),m3h2x8(:,53),heltab2x16(:,:,53))
  call Hloop_QV_A(ntry,G1H16(23),ex5(:),G1H8(5),m3h2x8(:,54),heltab2x16(:,:,54))
  call Hloop_Q_A(ntry,G1H8(5),49,nMT,G2H8(50),n2h8(30))
  call Hloop_QV_A(ntry,G1H16(24),ex5(:),G1H8(5),m3h2x8(:,55),heltab2x16(:,:,55))
  call Hloop_Q_A(ntry,G1H8(5),49,nMT,G2H8(51),n2h8(31))
  call Hloop_QV_A(ntry,G1H16(25),ex5(:),G1H8(5),m3h2x8(:,56),heltab2x16(:,:,56))
  call Hloop_Q_A(ntry,G1H8(5),49,nMT,G2H8(52),n2h8(32))
  call Hloop_AQ_V(ntry,G2H8(1),ex1(:),G2H4(1),m3h2x4(:,1),heltab2x8(:,:,1))
  call Hloop_QA_V(ntry,G2H8(2),ex2(:),G2H4(2),m3h2x4(:,2),heltab2x8(:,:,2))
call Hotf_5pt_reduction(G2H8(3),RedSet_5(3),mass5set(:,2),  & 
G1H8(5),G1H8(6),G1H8(7),G1H8(8),G1H8(9),G1H8(10),8)
call HG1shiftOLR(G1H8(6),16,8)
  call Hloop_QA_V(ntry,G2H8(4),ex2(:),G2H4(3),m3h2x4(:,3),heltab2x8(:,:,3))
call Hotf_5pt_reduction(G2H8(5),RedSet_5(4),mass5set(:,3),  & 
G1H8(11),G1H8(12),G1H8(13),G1H8(14),G1H8(15),G1H8(16),8)
call HG1shiftOLR(G1H8(12),16,8)
call Hotf_5pt_reduction(G2H8(6),RedSet_5(4),mass5set(:,3),  & 
G1H8(17),G1H8(18),G1H8(19),G1H8(20),G1H8(21),G1H8(22),8)
call HG1shiftOLR(G1H8(18),8,8)
  call Hloop_QA_V(ntry,G2H8(7),ex2(:),G2H4(4),m3h2x4(:,4),heltab2x8(:,:,4))
  call Hloop_AQ_V(ntry,G2H8(8),ex1(:),G2H4(5),m3h2x4(:,5),heltab2x8(:,:,5))
call Hotf_5pt_reduction(G2H8(9),RedSet_5(5),mass5set(:,2),  & 
G1H8(23),G1H8(24),G1H8(25),G1H8(26),G1H8(27),G1H8(28),8)
call HG1shiftOLR(G1H8(24),16,8)
call Hotf_5pt_reduction(G2H8(10),RedSet_5(6),mass5set(:,4),  & 
G1H8(29),G1H8(30),G1H8(31),G1H8(32),G1H8(33),G1H8(34),8)
call HG1shiftOLR(G1H8(30),8,8)
call Hotf_5pt_reduction(G2H8(11),RedSet_5(7),mass5set(:,3),  & 
G1H8(35),G1H8(36),G1H8(37),G1H8(38),G1H8(39),G1H8(40),8)
call HG1shiftOLR(G1H8(36),16,8)
call Hotf_5pt_reduction(G2H8(12),RedSet_5(7),mass5set(:,3),  & 
G1H8(41),G1H8(42),G1H8(43),G1H8(44),G1H8(45),G1H8(46),8)
call HG1shiftOLR(G1H8(42),4,8)
call Hotf_5pt_reduction(G2H8(13),RedSet_5(8),mass5set(:,2),  & 
G1H8(47),G1H8(48),G1H8(49),G1H8(50),G1H8(51),G1H8(52),8)
call HG1shiftOLR(G1H8(48),16,8)
  call Hloop_AQ_V(ntry,G2H8(14),ex1(:),G2H4(6),m3h2x4(:,6),heltab2x8(:,:,6))
call Hotf_5pt_reduction(G2H8(15),RedSet_5(9),mass5set(:,2),  & 
G1H8(53),G1H8(54),G1H8(55),G1H8(56),G1H8(57),G1H8(58),8)
call HG1shiftOLR(G1H8(54),16,8)
call Hotf_5pt_reduction(G2H8(16),RedSet_5(10),mass5set(:,4),  & 
G1H8(59),G1H8(60),G1H8(61),G1H8(62),G1H8(63),G1H8(64),8)
call HG1shiftOLR(G1H8(60),8,8)
call Hotf_5pt_reduction(G2H8(17),RedSet_5(11),mass5set(:,5),  & 
G1H8(65),G1H8(66),G1H8(67),G1H8(68),G1H8(69),G1H8(70),8)
call HG1shiftOLR(G1H8(66),8,8)
call Hotf_5pt_reduction(G2H8(18),RedSet_5(11),mass5set(:,5),  & 
G1H8(71),G1H8(72),G1H8(73),G1H8(74),G1H8(75),G1H8(76),8)
call HG1shiftOLR(G1H8(72),4,8)
call Hotf_5pt_reduction(G2H8(19),RedSet_5(12),mass5set(:,3),  & 
G1H8(77),G1H8(78),G1H8(79),G1H8(80),G1H8(81),G1H8(82),8)
call HG1shiftOLR(G1H8(78),16,8)
call Hotf_5pt_reduction(G2H8(20),RedSet_5(12),mass5set(:,3),  & 
G1H8(83),G1H8(84),G1H8(85),G1H8(86),G1H8(87),G1H8(88),8)
call HG1shiftOLR(G1H8(84),8,8)
call Hotf_5pt_reduction(G2H8(21),RedSet_5(13),mass5set(:,3),  & 
G1H8(89),G1H8(90),G1H8(91),G1H8(92),G1H8(93),G1H8(94),8)
call HG1shiftOLR(G1H8(90),16,8)
call Hotf_5pt_reduction(G2H8(22),RedSet_5(13),mass5set(:,3),  & 
G1H8(95),G1H8(96),G1H8(97),G1H8(98),G1H8(99),G1H8(100),8)
call HG1shiftOLR(G1H8(96),4,8)
call Hotf_5pt_reduction(G2H8(23),RedSet_5(14),mass5set(:,5),  & 
G1H8(101),G1H8(102),G1H8(103),G1H8(104),G1H8(105),G1H8(106),8)
call HG1shiftOLR(G1H8(102),8,8)
call Hotf_5pt_reduction(G2H8(24),RedSet_5(14),mass5set(:,5),  & 
G1H8(107),G1H8(108),G1H8(109),G1H8(110),G1H8(111),G1H8(112),8)
call HG1shiftOLR(G1H8(108),4,8)
call Hotf_5pt_reduction(G2H8(25),RedSet_5(15),mass5set(:,6),  & 
G1H8(113),G1H8(114),G1H8(115),G1H8(116),G1H8(117),G1H8(118),8)
call HG1shiftOLR(G1H8(114),8,8)
  call Hloop_AQ_V(ntry,G2H8(26),ex3(:),G2H4(7),m3h2x4(:,7),heltab2x8(:,:,7))
  call Hloop_QA_V(ntry,G2H8(27),ex4(:),G2H4(8),m3h2x4(:,8),heltab2x8(:,:,8))
call Hotf_5pt_reduction(G2H8(28),RedSet_5(16),mass5set(:,7),  & 
G1H8(119),G1H8(120),G1H8(121),G1H8(122),G1H8(123),G1H8(124),8)
call HG1shiftOLR(G1H8(120),2,8)
  call Hloop_QA_V(ntry,G2H8(29),ex4(:),G2H4(9),m3h2x4(:,9),heltab2x8(:,:,9))
call Hotf_5pt_reduction(G2H8(30),RedSet_5(17),mass5set(:,6),  & 
G1H8(125),G1H8(126),G1H8(127),G1H8(128),G1H8(129),G1H8(130),8)
call HG1shiftOLR(G1H8(126),8,8)
  call Hloop_QA_V(ntry,G2H8(31),ex4(:),G2H4(10),m3h2x4(:,10),heltab2x8(:,:,10))
  call Hloop_AQ_V(ntry,G2H8(32),ex3(:),G2H4(11),m3h2x4(:,11),heltab2x8(:,:,11))
call Hotf_5pt_reduction(G2H8(33),RedSet_5(18),mass5set(:,7),  & 
G1H8(131),G1H8(132),G1H8(133),G1H8(134),G1H8(135),G1H8(136),8)
call HG1shiftOLR(G1H8(132),2,8)
  call Hloop_AQ_V(ntry,G2H8(34),ex3(:),G2H4(12),m3h2x4(:,12),heltab2x8(:,:,12))
call Hotf_5pt_reduction(G2H8(35),RedSet_5(19),mass5set(:,8),  & 
G1H8(137),G1H8(138),G1H8(139),G1H8(140),G1H8(141),G1H8(142),8)
call HG1shiftOLR(G1H8(138),2,8)
call Hotf_5pt_reduction(G2H8(36),RedSet_5(20),mass5set(:,8),  & 
G1H8(143),G1H8(144),G1H8(145),G1H8(146),G1H8(147),G1H8(148),8)
call HG1shiftOLR(G1H8(144),2,8)
  call Hloop_AQ_V(ntry,G2H8(37),ex1(:),G2H4(13),m3h2x4(:,13),heltab2x8(:,:,13))
  call Hloop_AQ_V(ntry,G2H8(39),ex1(:),G2H4(14),m3h2x4(:,14),heltab2x8(:,:,14))
  call Hloop_AQ_V(ntry,G2H8(40),ex1(:),G2H4(15),m3h2x4(:,15),heltab2x8(:,:,15))
  call Hloop_AQ_V(ntry,G2H8(41),ex1(:),G2H4(16),m3h2x4(:,16),heltab2x8(:,:,16))
  call Hloop_AQ_V(ntry,G2H8(43),ex1(:),G2H4(17),m3h2x4(:,17),heltab2x8(:,:,17))
  call Hloop_AQ_V(ntry,G2H8(44),ex1(:),G2H4(18),m3h2x4(:,18),heltab2x8(:,:,18))
  call Hloop_QA_V(ntry,G2H8(45),ex2(:),G2H4(19),m3h2x4(:,19),heltab2x8(:,:,19))
  call Hloop_QA_V(ntry,G2H8(47),ex2(:),G2H4(20),m3h2x4(:,20),heltab2x8(:,:,20))
  call Hloop_QA_V(ntry,G2H8(48),ex2(:),G2H4(21),m3h2x4(:,21),heltab2x8(:,:,21))
  call Hloop_QA_V(ntry,G2H8(49),ex2(:),G2H4(22),m3h2x4(:,22),heltab2x8(:,:,22))
  call Hloop_QA_V(ntry,G2H8(51),ex2(:),G2H4(23),m3h2x4(:,23),heltab2x8(:,:,23))
  call Hloop_QA_V(ntry,G2H8(52),ex2(:),G2H4(24),m3h2x4(:,24),heltab2x8(:,:,24))
  call Hloop_VQ_A(ntry,G1H8(5),ex1(:),G1H4(1),m3h2x4(:,25),heltab2x8(:,:,25))
  call Hloop_Q_A(ntry,G1H4(1),45,nMT,G2H4(25),n2h4(1))
call HGT_raise_alpha_OLR(G1H8(6),1,1,8)
call HGT_raise_alpha_invQ_OLR(G1H8(6),2,5,8)
  call Hloop_UV_W(ntry,G1H8(6),-16,ex5(:),16,G2H4(26),m3h2x4(:,26),heltab2x8(:,:,26))
call signflip_OLR(G2H4(26))
  call Hloop_VQ_A(ntry,G1H8(9),ex1(:),G1H4(1),m3h2x4(:,27),heltab2x8(:,:,27))
  call Hloop_Q_A(ntry,G1H4(1),45,nMT,G2H4(27),n2h4(2))
  call Hloop_VQ_A(ntry,G1H8(10),ex1(:),G1H4(1),m3h2x4(:,28),heltab2x8(:,:,28))
  call Hloop_Q_A(ntry,G1H4(1),45,nMT,G2H4(28),n2h4(3))
  call Hloop_VQ_A(ntry,G1H8(11),ex3(:),G1H4(1),m3h2x4(:,29),heltab2x8(:,:,29))
  call Hloop_Q_A(ntry,G1H4(1),39,nMB,G2H4(29),n2h4(4))
call HGT_raise_alpha_OLR(G1H8(12),1,1,8)
call HGT_raise_alpha_invQ_OLR(G1H8(12),2,5,8)
  call Hloop_UV_W(ntry,G1H8(12),-16,ex5(:),16,G2H4(30),m3h2x4(:,30),heltab2x8(:,:,30))
call signflip_OLR(G2H4(30))
  call Hloop_VQ_A(ntry,G1H8(15),ex3(:),G1H4(1),m3h2x4(:,31),heltab2x8(:,:,31))
  call Hloop_Q_A(ntry,G1H4(1),39,nMB,G2H4(31),n2h4(5))
  call Hloop_VQ_A(ntry,G1H8(16),ex3(:),G1H4(1),m3h2x4(:,32),heltab2x8(:,:,32))
  call Hloop_Q_A(ntry,G1H4(1),39,nMB,G2H4(32),n2h4(6))
  call Hloop_VQ_A(ntry,G1H8(17),ex3(:),G1H4(1),m3h2x4(:,33),heltab2x8(:,:,33))
  call Hloop_Q_A(ntry,G1H4(1),39,nMB,G2H4(33),n2h4(7))
call HGT_raise_alpha_OLR(G1H8(18),1,1,8)
call HGT_raise_alpha_invQ_OLR(G1H8(18),2,5,8)
  call Hloop_VA_Q(ntry,G1H8(18),ex4(:),G1H4(1),m3h2x4(:,34),heltab2x8(:,:,34))
  call Hloop_VQ_A(ntry,G1H8(21),ex3(:),G1H4(2),m3h2x4(:,35),heltab2x8(:,:,35))
  call Hloop_Q_A(ntry,G1H4(2),39,nMB,G2H4(34),n2h4(8))
  call Hloop_VQ_A(ntry,G1H8(22),ex3(:),G1H4(2),m3h2x4(:,36),heltab2x8(:,:,36))
  call Hloop_Q_A(ntry,G1H4(2),39,nMB,G2H4(35),n2h4(9))
  call Hloop_VQ_A(ntry,G1H8(23),ex1(:),G1H4(2),m3h2x4(:,37),heltab2x8(:,:,37))
  call Hloop_Q_A(ntry,G1H4(2),45,nMT,G2H4(36),n2h4(10))
call HGT_raise_alpha_OLR(G1H8(24),1,1,8)
call HGT_raise_alpha_invQ_OLR(G1H8(24),2,5,8)
  call Hloop_UV_W(ntry,G1H8(24),-16,ex5(:),16,G2H4(37),m3h2x4(:,38),heltab2x8(:,:,38))
call signflip_OLR(G2H4(37))
  call Hloop_VQ_A(ntry,G1H8(27),ex1(:),G1H4(2),m3h2x4(:,39),heltab2x8(:,:,39))
  call Hloop_Q_A(ntry,G1H4(2),45,nMT,G2H4(38),n2h4(11))
  call Hloop_VQ_A(ntry,G1H8(28),ex1(:),G1H4(2),m3h2x4(:,40),heltab2x8(:,:,40))
  call Hloop_Q_A(ntry,G1H4(2),45,nMT,G2H4(39),n2h4(12))
  call Hloop_VA_Q(ntry,G1H8(29),ex2(:),G1H4(2),m3h2x4(:,41),heltab2x8(:,:,41))
  call Hloop_A_Q(ntry,G1H4(2),54,nMT,G2H4(40),n2h4(13))
call HGT_OLR(G1H8(30),1,1,8)
call HGT_invQ_OLR(G1H8(30),2,5,8)
  call Hloop_Q_A(ntry,G1H8(30),-8,nMB,G2H8(1),n2h8(37))
  call Hloop_QA_V(ntry,G2H8(1),ex4(:),G2H4(41),m3h2x4(:,42),heltab2x8(:,:,42))
  call Hloop_VA_Q(ntry,G1H8(33),ex2(:),G1H4(2),m3h2x4(:,43),heltab2x8(:,:,43))
  call Hloop_A_Q(ntry,G1H4(2),54,nMT,G2H4(42),n2h4(14))
  call Hloop_VA_Q(ntry,G1H8(34),ex2(:),G1H4(2),m3h2x4(:,44),heltab2x8(:,:,44))
  call Hloop_A_Q(ntry,G1H4(2),54,nMT,G2H4(43),n2h4(15))
  call Hloop_VA_Q(ntry,G1H8(35),ex4(:),G1H4(2),m3h2x4(:,45),heltab2x8(:,:,45))
  call Hloop_A_Q(ntry,G1H4(2),43,nMB,G2H4(44),n2h4(16))
call HGT_raise_alpha_OLR(G1H8(36),1,1,8)
call HGT_raise_alpha_invQ_OLR(G1H8(36),2,5,8)
  call Hloop_UV_W(ntry,G1H8(36),-16,ex5(:),16,G2H4(45),m3h2x4(:,46),heltab2x8(:,:,46))
call signflip_OLR(G2H4(45))
  call Hloop_VA_Q(ntry,G1H8(39),ex4(:),G1H4(2),m3h2x4(:,47),heltab2x8(:,:,47))
  call Hloop_A_Q(ntry,G1H4(2),43,nMB,G2H4(46),n2h4(17))
  call Hloop_VA_Q(ntry,G1H8(40),ex4(:),G1H4(2),m3h2x4(:,48),heltab2x8(:,:,48))
  call Hloop_A_Q(ntry,G1H4(2),43,nMB,G2H4(47),n2h4(18))
  call Hloop_VA_Q(ntry,G1H8(41),ex4(:),G1H4(2),m3h2x4(:,49),heltab2x8(:,:,49))
  call Hloop_A_Q(ntry,G1H4(2),43,nMB,G2H4(48),n2h4(19))
call HGT_raise_alpha_OLR(G1H8(42),1,1,8)
call HGT_raise_alpha_invQ_OLR(G1H8(42),2,5,8)
  call Hloop_VQ_A(ntry,G1H8(42),ex3(:),G1H4(2),m3h2x4(:,50),heltab2x8(:,:,50))
  call Hloop_VA_Q(ntry,G1H8(45),ex4(:),G1H4(3),m3h2x4(:,51),heltab2x8(:,:,51))
  call Hloop_A_Q(ntry,G1H4(3),43,nMB,G2H4(49),n2h4(20))
  call Hloop_VA_Q(ntry,G1H8(46),ex4(:),G1H4(3),m3h2x4(:,52),heltab2x8(:,:,52))
  call Hloop_A_Q(ntry,G1H4(3),43,nMB,G2H4(50),n2h4(21))
  call Hloop_VA_Q(ntry,G1H8(47),ex2(:),G1H4(3),m3h2x4(:,53),heltab2x8(:,:,53))
  call Hloop_A_Q(ntry,G1H4(3),46,nMT,G2H4(51),n2h4(22))
call HGT_raise_alpha_OLR(G1H8(48),1,1,8)
call HGT_raise_alpha_invQ_OLR(G1H8(48),2,5,8)
  call Hloop_UV_W(ntry,G1H8(48),-16,ex5(:),16,G2H4(52),m3h2x4(:,54),heltab2x8(:,:,54))
call signflip_OLR(G2H4(52))
  call Hloop_VA_Q(ntry,G1H8(51),ex2(:),G1H4(3),m3h2x4(:,55),heltab2x8(:,:,55))
  call Hloop_A_Q(ntry,G1H4(3),46,nMT,G2H4(53),n2h4(23))
  call Hloop_VA_Q(ntry,G1H8(52),ex2(:),G1H4(3),m3h2x4(:,56),heltab2x8(:,:,56))
  call Hloop_A_Q(ntry,G1H4(3),46,nMT,G2H4(54),n2h4(24))
  call Hloop_VA_Q(ntry,G1H8(53),ex2(:),G1H4(3),m3h2x4(:,57),heltab2x8(:,:,57))
  call Hloop_A_Q(ntry,G1H4(3),46,nMT,G2H4(55),n2h4(25))
call HGT_raise_alpha_OLR(G1H8(54),1,1,8)
call HGT_raise_alpha_invQ_OLR(G1H8(54),2,5,8)
  call Hloop_UV_W(ntry,G1H8(54),-16,ex5(:),16,G2H4(56),m3h2x4(:,58),heltab2x8(:,:,58))
call signflip_OLR(G2H4(56))
  call Hloop_VA_Q(ntry,G1H8(57),ex2(:),G1H4(3),m3h2x4(:,59),heltab2x8(:,:,59))
  call Hloop_A_Q(ntry,G1H4(3),46,nMT,G2H4(57),n2h4(26))
  call Hloop_VA_Q(ntry,G1H8(58),ex2(:),G1H4(3),m3h2x4(:,60),heltab2x8(:,:,60))
  call Hloop_A_Q(ntry,G1H4(3),46,nMT,G2H4(58),n2h4(27))
  call Hloop_VQ_A(ntry,G1H8(59),ex1(:),G1H4(3),m3h2x4(:,61),heltab2x8(:,:,61))
  call Hloop_Q_A(ntry,G1H4(3),53,nMT,G2H4(59),n2h4(28))
call HGT_OLR(G1H8(60),1,1,8)
call HGT_invQ_OLR(G1H8(60),2,5,8)
  call Hloop_Q_A(ntry,G1H8(60),-8,nMB,G2H8(2),n2h8(42))
  call Hloop_QA_V(ntry,G2H8(2),ex4(:),G2H4(60),m3h2x4(:,62),heltab2x8(:,:,62))
  call Hloop_VQ_A(ntry,G1H8(63),ex1(:),G1H4(3),m3h2x4(:,63),heltab2x8(:,:,63))
  call Hloop_Q_A(ntry,G1H4(3),53,nMT,G2H4(61),n2h4(29))
  call Hloop_VQ_A(ntry,G1H8(64),ex1(:),G1H4(3),m3h2x4(:,64),heltab2x8(:,:,64))
  call Hloop_Q_A(ntry,G1H4(3),53,nMT,G2H4(62),n2h4(30))
  call Hloop_UV_W(ntry,G1H8(65),35,ex5(:),16,G2H4(63),m3h2x4(:,65),heltab2x8(:,:,65))
call HGT_raise_alpha_OLR(G1H8(66),1,1,8)
call HGT_raise_alpha_invQ_OLR(G1H8(66),2,5,8)
  call Hloop_VA_Q(ntry,G1H8(66),ex4(:),G1H4(3),m3h2x4(:,66),heltab2x8(:,:,66))
  call Hloop_UV_W(ntry,G1H8(69),35,ex5(:),16,G2H4(64),m3h2x4(:,67),heltab2x8(:,:,67))
  call Hloop_UV_W(ntry,G1H8(70),35,ex5(:),16,G2H4(65),m3h2x4(:,68),heltab2x8(:,:,68))
  call Hloop_UV_W(ntry,G1H8(71),35,ex5(:),16,G2H4(66),m3h2x4(:,69),heltab2x8(:,:,69))
call HGT_raise_alpha_OLR(G1H8(72),1,1,8)
call HGT_raise_alpha_invQ_OLR(G1H8(72),2,5,8)
  call Hloop_VQ_A(ntry,G1H8(72),ex3(:),G1H4(4),m3h2x4(:,70),heltab2x8(:,:,70))
  call Hloop_UV_W(ntry,G1H8(75),35,ex5(:),16,G2H4(67),m3h2x4(:,71),heltab2x8(:,:,71))
  call Hloop_UV_W(ntry,G1H8(76),35,ex5(:),16,G2H4(68),m3h2x4(:,72),heltab2x8(:,:,72))
  call Hloop_VQ_A(ntry,G1H8(77),ex3(:),G1H4(5),m3h2x4(:,73),heltab2x8(:,:,73))
  call Hloop_Q_A(ntry,G1H4(5),39,nMB,G2H4(69),n2h4(31))
call HGT_raise_alpha_OLR(G1H8(78),1,1,8)
call HGT_raise_alpha_invQ_OLR(G1H8(78),2,5,8)
  call Hloop_UV_W(ntry,G1H8(78),-16,ex5(:),16,G2H4(70),m3h2x4(:,74),heltab2x8(:,:,74))
call signflip_OLR(G2H4(70))
  call Hloop_VQ_A(ntry,G1H8(81),ex3(:),G1H4(5),m3h2x4(:,75),heltab2x8(:,:,75))
  call Hloop_Q_A(ntry,G1H4(5),39,nMB,G2H4(71),n2h4(32))
  call Hloop_VQ_A(ntry,G1H8(82),ex3(:),G1H4(5),m3h2x4(:,76),heltab2x8(:,:,76))
  call Hloop_Q_A(ntry,G1H4(5),39,nMB,G2H4(72),n2h4(33))
  call Hloop_VQ_A(ntry,G1H8(83),ex3(:),G1H4(5),m3h2x4(:,77),heltab2x8(:,:,77))
  call Hloop_Q_A(ntry,G1H4(5),39,nMB,G2H4(73),n2h4(34))
call HGT_raise_alpha_OLR(G1H8(84),1,1,8)
call HGT_raise_alpha_invQ_OLR(G1H8(84),2,5,8)
  call Hloop_VA_Q(ntry,G1H8(84),ex4(:),G1H4(5),m3h2x4(:,78),heltab2x8(:,:,78))
  call Hloop_VQ_A(ntry,G1H8(87),ex3(:),G1H4(6),m3h2x4(:,79),heltab2x8(:,:,79))
  call Hloop_Q_A(ntry,G1H4(6),39,nMB,G2H4(74),n2h4(35))
  call Hloop_VQ_A(ntry,G1H8(88),ex3(:),G1H4(6),m3h2x4(:,80),heltab2x8(:,:,80))
  call Hloop_Q_A(ntry,G1H4(6),39,nMB,G2H4(75),n2h4(36))
  call Hloop_VA_Q(ntry,G1H8(89),ex4(:),G1H4(6),m3h2x4(:,81),heltab2x8(:,:,81))
  call Hloop_A_Q(ntry,G1H4(6),43,nMB,G2H4(76),n2h4(37))
call HGT_raise_alpha_OLR(G1H8(90),1,1,8)
call HGT_raise_alpha_invQ_OLR(G1H8(90),2,5,8)
  call Hloop_UV_W(ntry,G1H8(90),-16,ex5(:),16,G2H4(77),m3h2x4(:,82),heltab2x8(:,:,82))
call signflip_OLR(G2H4(77))
  call Hloop_VA_Q(ntry,G1H8(93),ex4(:),G1H4(6),m3h2x4(:,83),heltab2x8(:,:,83))
  call Hloop_A_Q(ntry,G1H4(6),43,nMB,G2H4(78),n2h4(38))
  call Hloop_VA_Q(ntry,G1H8(94),ex4(:),G1H4(6),m3h2x4(:,84),heltab2x8(:,:,84))
  call Hloop_A_Q(ntry,G1H4(6),43,nMB,G2H4(79),n2h4(39))
  call Hloop_VA_Q(ntry,G1H8(95),ex4(:),G1H4(6),m3h2x4(:,85),heltab2x8(:,:,85))
  call Hloop_A_Q(ntry,G1H4(6),43,nMB,G2H4(80),n2h4(40))
call HGT_raise_alpha_OLR(G1H8(96),1,1,8)
call HGT_raise_alpha_invQ_OLR(G1H8(96),2,5,8)
  call Hloop_VQ_A(ntry,G1H8(96),ex3(:),G1H4(6),m3h2x4(:,86),heltab2x8(:,:,86))
  call Hloop_VA_Q(ntry,G1H8(99),ex4(:),G1H4(7),m3h2x4(:,87),heltab2x8(:,:,87))
  call Hloop_A_Q(ntry,G1H4(7),43,nMB,G2H4(81),n2h4(41))
  call Hloop_VA_Q(ntry,G1H8(100),ex4(:),G1H4(7),m3h2x4(:,88),heltab2x8(:,:,88))
  call Hloop_A_Q(ntry,G1H4(7),43,nMB,G2H4(82),n2h4(42))
  call Hloop_UV_W(ntry,G1H8(101),35,ex5(:),16,G2H4(83),m3h2x4(:,89),heltab2x8(:,:,89))
call HGT_raise_alpha_OLR(G1H8(102),1,1,8)
call HGT_raise_alpha_invQ_OLR(G1H8(102),2,5,8)
  call Hloop_VA_Q(ntry,G1H8(102),ex4(:),G1H4(7),m3h2x4(:,90),heltab2x8(:,:,90))
  call Hloop_UV_W(ntry,G1H8(105),35,ex5(:),16,G2H4(84),m3h2x4(:,91),heltab2x8(:,:,91))
  call Hloop_UV_W(ntry,G1H8(106),35,ex5(:),16,G2H4(85),m3h2x4(:,92),heltab2x8(:,:,92))
  call Hloop_UV_W(ntry,G1H8(107),35,ex5(:),16,G2H4(86),m3h2x4(:,93),heltab2x8(:,:,93))
call HGT_raise_alpha_OLR(G1H8(108),1,1,8)
call HGT_raise_alpha_invQ_OLR(G1H8(108),2,5,8)
  call Hloop_VQ_A(ntry,G1H8(108),ex3(:),G1H4(8),m3h2x4(:,94),heltab2x8(:,:,94))
  call Hloop_UV_W(ntry,G1H8(111),35,ex5(:),16,G2H4(87),m3h2x4(:,95),heltab2x8(:,:,95))
  call Hloop_UV_W(ntry,G1H8(112),35,ex5(:),16,G2H4(88),m3h2x4(:,96),heltab2x8(:,:,96))
  call Hloop_QV_A(ntry,G1H8(113),ex5(:),G1H4(9),m3h2x4(:,97),heltab2x8(:,:,97))
  call Hloop_Q_A(ntry,G1H4(9),53,nMT,G2H4(89),n2h4(43))
call HGT_OLR(G1H8(114),1,1,8)
call HGT_invQ_OLR(G1H8(114),2,5,8)
  call Hloop_Q_A(ntry,G1H8(114),-8,nMB,G2H8(3),n2h8(51))
  call Hloop_QA_V(ntry,G2H8(3),ex4(:),G2H4(90),m3h2x4(:,98),heltab2x8(:,:,98))
  call Hloop_QV_A(ntry,G1H8(117),ex5(:),G1H4(9),m3h2x4(:,99),heltab2x8(:,:,99))
  call Hloop_Q_A(ntry,G1H4(9),53,nMT,G2H4(91),n2h4(44))
  call Hloop_QV_A(ntry,G1H8(118),ex5(:),G1H4(9),m3h2x4(:,100),heltab2x8(:,:,100))
  call Hloop_Q_A(ntry,G1H4(9),53,nMT,G2H4(92),n2h4(45))
  call Hloop_QV_A(ntry,G1H8(119),ex5(:),G1H4(9),m3h2x4(:,101),heltab2x8(:,:,101))
  call Hloop_Q_A(ntry,G1H4(9),53,nMB,G2H4(93),n2h4(46))
call HGT_OLR(G1H8(120),1,1,8)
call HGT_invQ_OLR(G1H8(120),2,5,8)
  call Hloop_Q_A(ntry,G1H8(120),-2,nMT,G2H8(4),n2h8(52))
  call Hloop_QA_V(ntry,G2H8(4),ex2(:),G2H4(94),m3h2x4(:,102),heltab2x8(:,:,102))
  call Hloop_QV_A(ntry,G1H8(123),ex5(:),G1H4(9),m3h2x4(:,103),heltab2x8(:,:,103))
  call Hloop_Q_A(ntry,G1H4(9),53,nMB,G2H4(95),n2h4(47))
  call Hloop_QV_A(ntry,G1H8(124),ex5(:),G1H4(9),m3h2x4(:,104),heltab2x8(:,:,104))
  call Hloop_Q_A(ntry,G1H4(9),53,nMB,G2H4(96),n2h4(48))
  call Hloop_AV_Q(ntry,G1H8(125),ex5(:),G1H4(9),m3h2x4(:,105),heltab2x8(:,:,105))
  call Hloop_A_Q(ntry,G1H4(9),54,nMT,G2H4(97),n2h4(49))
call HGT_OLR(G1H8(126),1,1,8)
call HGT_invQ_OLR(G1H8(126),2,5,8)
  call Hloop_Q_A(ntry,G1H8(126),-8,nMB,G2H8(5),n2h8(53))
  call Hloop_QA_V(ntry,G2H8(5),ex4(:),G2H4(98),m3h2x4(:,106),heltab2x8(:,:,106))
  call Hloop_AV_Q(ntry,G1H8(129),ex5(:),G1H4(9),m3h2x4(:,107),heltab2x8(:,:,107))
  call Hloop_A_Q(ntry,G1H4(9),54,nMT,G2H4(99),n2h4(50))
  call Hloop_AV_Q(ntry,G1H8(130),ex5(:),G1H4(9),m3h2x4(:,108),heltab2x8(:,:,108))
  call Hloop_A_Q(ntry,G1H4(9),54,nMT,G2H4(100),n2h4(51))
  call Hloop_AV_Q(ntry,G1H8(131),ex5(:),G1H4(9),m3h2x4(:,109),heltab2x8(:,:,109))
  call Hloop_A_Q(ntry,G1H4(9),57,nMB,G2H4(101),n2h4(52))
call HGT_OLR(G1H8(132),1,1,8)
call HGT_invQ_OLR(G1H8(132),2,5,8)
  call Hloop_Q_A(ntry,G1H8(132),-2,nMT,G2H8(6),n2h8(54))
  call Hloop_QA_V(ntry,G2H8(6),ex2(:),G2H4(102),m3h2x4(:,110),heltab2x8(:,:,110))
  call Hloop_AV_Q(ntry,G1H8(135),ex5(:),G1H4(9),m3h2x4(:,111),heltab2x8(:,:,111))
  call Hloop_A_Q(ntry,G1H4(9),57,nMB,G2H4(103),n2h4(53))
  call Hloop_AV_Q(ntry,G1H8(136),ex5(:),G1H4(9),m3h2x4(:,112),heltab2x8(:,:,112))
  call Hloop_A_Q(ntry,G1H4(9),57,nMB,G2H4(104),n2h4(54))
  call Hloop_VA_Q(ntry,G1H8(137),ex4(:),G1H4(9),m3h2x4(:,113),heltab2x8(:,:,113))
  call Hloop_A_Q(ntry,G1H4(9),57,nMB,G2H4(105),n2h4(55))
call HGT_OLR(G1H8(138),1,1,8)
call HGT_invQ_OLR(G1H8(138),2,5,8)
  call Hloop_Q_A(ntry,G1H8(138),-2,nMT,G2H8(7),n2h8(55))
  call Hloop_QA_V(ntry,G2H8(7),ex2(:),G2H4(106),m3h2x4(:,114),heltab2x8(:,:,114))
  call Hloop_VA_Q(ntry,G1H8(141),ex4(:),G1H4(9),m3h2x4(:,115),heltab2x8(:,:,115))
  call Hloop_A_Q(ntry,G1H4(9),57,nMB,G2H4(107),n2h4(56))
  call Hloop_VA_Q(ntry,G1H8(142),ex4(:),G1H4(9),m3h2x4(:,116),heltab2x8(:,:,116))
  call Hloop_A_Q(ntry,G1H4(9),57,nMB,G2H4(108),n2h4(57))
  call Hloop_VQ_A(ntry,G1H8(143),ex3(:),G1H4(9),m3h2x4(:,117),heltab2x8(:,:,117))
  call Hloop_Q_A(ntry,G1H4(9),53,nMB,G2H4(109),n2h4(58))
call HGT_OLR(G1H8(144),1,1,8)
call HGT_invQ_OLR(G1H8(144),2,5,8)
  call Hloop_Q_A(ntry,G1H8(144),-2,nMT,G2H8(8),n2h8(56))
  call Hloop_QA_V(ntry,G2H8(8),ex2(:),G2H4(110),m3h2x4(:,118),heltab2x8(:,:,118))
  call Hloop_VQ_A(ntry,G1H8(147),ex3(:),G1H4(9),m3h2x4(:,119),heltab2x8(:,:,119))
  call Hloop_Q_A(ntry,G1H4(9),53,nMB,G2H4(111),n2h4(59))
  call Hloop_VQ_A(ntry,G1H8(148),ex3(:),G1H4(9),m3h2x4(:,120),heltab2x8(:,:,120))
  call Hloop_Q_A(ntry,G1H4(9),53,nMB,G2H4(112),n2h4(60))
call Hotf_5pt_reduction(G2H4(1),RedSet_5(21),mass5set(:,9),  & 
G1H4(9),G1H4(10),G1H4(11),G1H4(12),G1H4(13),G1H4(14),4)
call HG1shiftOLR(G1H4(10),16,4)
call Hotf_5pt_reduction(G2H4(2),RedSet_5(22),mass5set(:,9),  & 
G1H4(15),G1H4(16),G1H4(17),G1H4(18),G1H4(19),G1H4(20),4)
call HG1shiftOLR(G1H4(16),16,4)
call Hotf_5pt_reduction(G2H4(3),RedSet_5(22),mass5set(:,9),  & 
G1H4(21),G1H4(22),G1H4(23),G1H4(24),G1H4(25),G1H4(26),4)
call HG1shiftOLR(G1H4(22),8,4)
call Hotf_5pt_reduction(G2H4(4),RedSet_5(23),mass5set(:,9),  & 
G1H4(27),G1H4(28),G1H4(29),G1H4(30),G1H4(31),G1H4(32),4)
call HG1shiftOLR(G1H4(28),16,4)
call Hotf_5pt_reduction(G2H4(5),RedSet_5(24),mass5set(:,9),  & 
G1H4(33),G1H4(34),G1H4(35),G1H4(36),G1H4(37),G1H4(38),4)
call HG1shiftOLR(G1H4(34),16,4)
call Hotf_5pt_reduction(G2H4(6),RedSet_5(24),mass5set(:,9),  & 
G1H4(39),G1H4(40),G1H4(41),G1H4(42),G1H4(43),G1H4(44),4)
call HG1shiftOLR(G1H4(40),8,4)
call Hotf_5pt_reduction(G2H4(7),RedSet_5(25),mass5set(:,10),  & 
G1H4(45),G1H4(46),G1H4(47),G1H4(48),G1H4(49),G1H4(50),4)
call HG1shiftOLR(G1H4(46),16,4)
call Hotf_5pt_reduction(G2H4(8),RedSet_5(26),mass5set(:,10),  & 
G1H4(51),G1H4(52),G1H4(53),G1H4(54),G1H4(55),G1H4(56),4)
call HG1shiftOLR(G1H4(52),16,4)
call Hotf_5pt_reduction(G2H4(9),RedSet_5(26),mass5set(:,10),  & 
G1H4(57),G1H4(58),G1H4(59),G1H4(60),G1H4(61),G1H4(62),4)
call HG1shiftOLR(G1H4(58),2,4)
call Hotf_5pt_reduction(G2H4(10),RedSet_5(27),mass5set(:,10),  & 
G1H4(63),G1H4(64),G1H4(65),G1H4(66),G1H4(67),G1H4(68),4)
call HG1shiftOLR(G1H4(64),16,4)
call Hotf_5pt_reduction(G2H4(11),RedSet_5(28),mass5set(:,10),  & 
G1H4(69),G1H4(70),G1H4(71),G1H4(72),G1H4(73),G1H4(74),4)
call HG1shiftOLR(G1H4(70),16,4)
call Hotf_5pt_reduction(G2H4(12),RedSet_5(28),mass5set(:,10),  & 
G1H4(75),G1H4(76),G1H4(77),G1H4(78),G1H4(79),G1H4(80),4)
call HG1shiftOLR(G1H4(76),2,4)
call Hotf_5pt_reduction(G2H4(13),RedSet_5(1),mass5set(:,1),  & 
G1H4(81),G1H4(82),G1H4(83),G1H4(84),G1H4(85),G1H4(86),4)
call HG1shiftOLR(G1H4(82),8,4)
call Hotf_5pt_reduction(G2H4(15),RedSet_5(29),mass5set(:,11),  & 
G1H4(87),G1H4(88),G1H4(89),G1H4(90),G1H4(91),G1H4(92),4)
call HG1shiftOLR(G1H4(88),8,4)
call Hotf_5pt_reduction(G2H4(16),RedSet_5(1),mass5set(:,1),  & 
G1H4(93),G1H4(94),G1H4(95),G1H4(96),G1H4(97),G1H4(98),4)
call HG1shiftOLR(G1H4(94),4,4)
call Hotf_5pt_reduction(G2H4(18),RedSet_5(30),mass5set(:,11),  & 
G1H4(99),G1H4(100),G1H4(101),G1H4(102),G1H4(103),G1H4(104),4)
call HG1shiftOLR(G1H4(100),4,4)
call Hotf_5pt_reduction(G2H4(19),RedSet_5(2),mass5set(:,1),  & 
G1H4(105),G1H4(106),G1H4(107),G1H4(108),G1H4(109),G1H4(110),4)
call HG1shiftOLR(G1H4(106),8,4)
call Hotf_5pt_reduction(G2H4(21),RedSet_5(31),mass5set(:,11),  & 
G1H4(111),G1H4(112),G1H4(113),G1H4(114),G1H4(115),G1H4(116),4)
call HG1shiftOLR(G1H4(112),8,4)
call Hotf_5pt_reduction(G2H4(22),RedSet_5(2),mass5set(:,1),  & 
G1H4(117),G1H4(118),G1H4(119),G1H4(120),G1H4(121),G1H4(122),4)
call HG1shiftOLR(G1H4(118),4,4)
call Hotf_5pt_reduction(G2H4(24),RedSet_5(32),mass5set(:,11),  & 
G1H4(123),G1H4(124),G1H4(125),G1H4(126),G1H4(127),G1H4(128),4)
call HG1shiftOLR(G1H4(124),4,4)
  call Hloop_QA_V(ntry,G2H4(25),ex2(:),G2H2(1),m3h2x2(:,1),heltab2x4(:,:,1))
  call Hloop_QA_V(ntry,G2H4(28),ex2(:),G2H2(2),m3h2x2(:,2),heltab2x4(:,:,2))
  call Hloop_QA_V(ntry,G2H4(29),ex4(:),G2H2(3),m3h2x2(:,3),heltab2x4(:,:,3))
  call Hloop_QA_V(ntry,G2H4(32),ex4(:),G2H2(4),m3h2x2(:,4),heltab2x4(:,:,4))
call Hotf_5pt_reduction(G2H4(33),RedSet_5(4),mass5set(:,3),  & 
G1H4(129),G1H4(130),G1H4(131),G1H4(132),G1H4(133),G1H4(134),4)
call HG1shiftOLR(G1H4(130),8,4)
call Hotf_5pt_reduction(G2H4(35),RedSet_5(33),mass5set(:,3),  & 
G1H4(135),G1H4(136),G1H4(137),G1H4(138),G1H4(139),G1H4(140),4)
call HG1shiftOLR(G1H4(136),8,4)
  call Hloop_QA_V(ntry,G2H4(36),ex2(:),G2H2(5),m3h2x2(:,5),heltab2x4(:,:,5))
  call Hloop_QA_V(ntry,G2H4(39),ex2(:),G2H2(6),m3h2x2(:,6),heltab2x4(:,:,6))
  call Hloop_AQ_V(ntry,G2H4(40),ex1(:),G2H2(7),m3h2x2(:,7),heltab2x4(:,:,7))
  call Hloop_AQ_V(ntry,G2H4(43),ex1(:),G2H2(8),m3h2x2(:,8),heltab2x4(:,:,8))
  call Hloop_AQ_V(ntry,G2H4(44),ex3(:),G2H2(9),m3h2x2(:,9),heltab2x4(:,:,9))
  call Hloop_AQ_V(ntry,G2H4(47),ex3(:),G2H2(10),m3h2x2(:,10),heltab2x4(:,:,10))
call Hotf_5pt_reduction(G2H4(48),RedSet_5(7),mass5set(:,3),  & 
G1H4(141),G1H4(142),G1H4(143),G1H4(144),G1H4(145),G1H4(146),4)
call HG1shiftOLR(G1H4(142),4,4)
call Hotf_5pt_reduction(G2H4(50),RedSet_5(34),mass5set(:,3),  & 
G1H4(147),G1H4(148),G1H4(149),G1H4(150),G1H4(151),G1H4(152),4)
call HG1shiftOLR(G1H4(148),4,4)
  call Hloop_AQ_V(ntry,G2H4(51),ex1(:),G2H2(11),m3h2x2(:,11),heltab2x4(:,:,11))
  call Hloop_AQ_V(ntry,G2H4(54),ex1(:),G2H2(12),m3h2x2(:,12),heltab2x4(:,:,12))
  call Hloop_AQ_V(ntry,G2H4(55),ex1(:),G2H2(13),m3h2x2(:,13),heltab2x4(:,:,13))
  call Hloop_AQ_V(ntry,G2H4(58),ex1(:),G2H2(14),m3h2x2(:,14),heltab2x4(:,:,14))
  call Hloop_QA_V(ntry,G2H4(59),ex2(:),G2H2(15),m3h2x2(:,15),heltab2x4(:,:,15))
  call Hloop_QA_V(ntry,G2H4(62),ex2(:),G2H2(16),m3h2x2(:,16),heltab2x4(:,:,16))
call Hotf_5pt_reduction(G2H4(63),RedSet_5(11),mass5set(:,5),  & 
G1H4(153),G1H4(154),G1H4(155),G1H4(156),G1H4(157),G1H4(158),4)
call HG1shiftOLR(G1H4(154),8,4)
call Hotf_5pt_reduction(G2H4(65),RedSet_5(33),mass5set(:,3),  & 
G1H4(159),G1H4(160),G1H4(161),G1H4(162),G1H4(163),G1H4(164),4)
call HG1shiftOLR(G1H4(160),8,4)
call Hotf_5pt_reduction(G2H4(66),RedSet_5(11),mass5set(:,5),  & 
G1H4(165),G1H4(166),G1H4(167),G1H4(168),G1H4(169),G1H4(170),4)
call HG1shiftOLR(G1H4(166),4,4)
call Hotf_5pt_reduction(G2H4(68),RedSet_5(34),mass5set(:,3),  & 
G1H4(171),G1H4(172),G1H4(173),G1H4(174),G1H4(175),G1H4(176),4)
call HG1shiftOLR(G1H4(172),4,4)
  call Hloop_QA_V(ntry,G2H4(69),ex4(:),G2H2(17),m3h2x2(:,17),heltab2x4(:,:,17))
  call Hloop_QA_V(ntry,G2H4(72),ex4(:),G2H2(18),m3h2x2(:,18),heltab2x4(:,:,18))
call Hotf_5pt_reduction(G2H4(73),RedSet_5(12),mass5set(:,3),  & 
G1H4(177),G1H4(178),G1H4(179),G1H4(180),G1H4(181),G1H4(182),4)
call HG1shiftOLR(G1H4(178),8,4)
call Hotf_5pt_reduction(G2H4(75),RedSet_5(35),mass5set(:,3),  & 
G1H4(183),G1H4(184),G1H4(185),G1H4(186),G1H4(187),G1H4(188),4)
call HG1shiftOLR(G1H4(184),8,4)
  call Hloop_AQ_V(ntry,G2H4(76),ex3(:),G2H2(19),m3h2x2(:,19),heltab2x4(:,:,19))
  call Hloop_AQ_V(ntry,G2H4(79),ex3(:),G2H2(20),m3h2x2(:,20),heltab2x4(:,:,20))
call Hotf_5pt_reduction(G2H4(80),RedSet_5(13),mass5set(:,3),  & 
G1H4(189),G1H4(190),G1H4(191),G1H4(192),G1H4(193),G1H4(194),4)
call HG1shiftOLR(G1H4(190),4,4)
call Hotf_5pt_reduction(G2H4(82),RedSet_5(36),mass5set(:,3),  & 
G1H4(195),G1H4(196),G1H4(197),G1H4(198),G1H4(199),G1H4(200),4)
call HG1shiftOLR(G1H4(196),4,4)
call Hotf_5pt_reduction(G2H4(83),RedSet_5(14),mass5set(:,5),  & 
G1H4(201),G1H4(202),G1H4(203),G1H4(204),G1H4(205),G1H4(206),4)
call HG1shiftOLR(G1H4(202),8,4)
call Hotf_5pt_reduction(G2H4(85),RedSet_5(35),mass5set(:,3),  & 
G1H4(207),G1H4(208),G1H4(209),G1H4(210),G1H4(211),G1H4(212),4)
call HG1shiftOLR(G1H4(208),8,4)
call Hotf_5pt_reduction(G2H4(86),RedSet_5(14),mass5set(:,5),  & 
G1H4(213),G1H4(214),G1H4(215),G1H4(216),G1H4(217),G1H4(218),4)
call HG1shiftOLR(G1H4(214),4,4)
call Hotf_5pt_reduction(G2H4(88),RedSet_5(36),mass5set(:,3),  & 
G1H4(219),G1H4(220),G1H4(221),G1H4(222),G1H4(223),G1H4(224),4)
call HG1shiftOLR(G1H4(220),4,4)
  call Hloop_QA_V(ntry,G2H4(89),ex2(:),G2H2(21),m3h2x2(:,21),heltab2x4(:,:,21))
  call Hloop_QA_V(ntry,G2H4(92),ex2(:),G2H2(22),m3h2x2(:,22),heltab2x4(:,:,22))
  call Hloop_QA_V(ntry,G2H4(93),ex4(:),G2H2(23),m3h2x2(:,23),heltab2x4(:,:,23))
  call Hloop_QA_V(ntry,G2H4(96),ex4(:),G2H2(24),m3h2x2(:,24),heltab2x4(:,:,24))
  call Hloop_AQ_V(ntry,G2H4(97),ex1(:),G2H2(25),m3h2x2(:,25),heltab2x4(:,:,25))
  call Hloop_AQ_V(ntry,G2H4(100),ex1(:),G2H2(26),m3h2x2(:,26),heltab2x4(:,:,26))
  call Hloop_AQ_V(ntry,G2H4(101),ex3(:),G2H2(27),m3h2x2(:,27),heltab2x4(:,:,27))
  call Hloop_AQ_V(ntry,G2H4(104),ex3(:),G2H2(28),m3h2x2(:,28),heltab2x4(:,:,28))
  call Hloop_AQ_V(ntry,G2H4(105),ex3(:),G2H2(29),m3h2x2(:,29),heltab2x4(:,:,29))
  call Hloop_AQ_V(ntry,G2H4(108),ex3(:),G2H2(30),m3h2x2(:,30),heltab2x4(:,:,30))
  call Hloop_QA_V(ntry,G2H4(109),ex4(:),G2H2(31),m3h2x2(:,31),heltab2x4(:,:,31))
  call Hloop_QA_V(ntry,G2H4(112),ex4(:),G2H2(32),m3h2x2(:,32),heltab2x4(:,:,32))
  call ol_merge(ntry,G1H4(87),[G1H4(86)])
  call ol_merge(ntry,G1H4(99),[G1H4(98)])
  call ol_merge(ntry,G1H4(111),[G1H4(110)])
  call ol_merge(ntry,G1H4(123),[G1H4(122)])
  call ol_merge(ntry,G1H4(135),[G1H4(134)])
  call ol_merge(ntry,G1H4(147),[G1H4(146)])
  call ol_merge(ntry,G1H4(159),[G1H4(158)])
  call ol_merge(ntry,G1H4(171),[G1H4(170)])
  call ol_merge(ntry,G1H4(183),[G1H4(182)])
  call ol_merge(ntry,G1H4(195),[G1H4(194)])
  call ol_merge(ntry,G1H4(207),[G1H4(206)])
  call ol_merge(ntry,G1H4(219),[G1H4(218)])
  call Hloop_VQ_A(ntry,G1H4(9),ex3(:),G1H2(1),m3h2x2(:,33),heltab2x4(:,:,33))
  call Hloop_Q_A(ntry,G1H2(1),47,nMB,G2H2(33),n2h2(1))
call HGT_OLR(G1H4(10),1,1,4)
call HGT_invQ_OLR(G1H4(10),2,5,4)
  call Hloop_A_Q(ntry,G1H4(10),-16,nMB,G2H4(1),n2h4(61))
  call Hloop_AV_Q(ntry,G2H4(1),ex5(:),G2H2(34),m3h2x2(:,34),heltab2x4(:,:,34))
  call Hloop_VQ_A(ntry,G1H4(14),ex3(:),G1H2(1),m3h2x2(:,35),heltab2x4(:,:,35))
  call Hloop_Q_A(ntry,G1H2(1),47,nMB,G2H2(35),n2h2(2))
  call Hloop_VA_Q(ntry,G1H4(15),ex4(:),G1H2(1),m3h2x2(:,36),heltab2x4(:,:,36))
  call Hloop_A_Q(ntry,G1H2(1),47,nMB,G2H2(36),n2h2(3))
call HGT_OLR(G1H4(16),1,1,4)
call HGT_invQ_OLR(G1H4(16),2,5,4)
  call Hloop_Q_A(ntry,G1H4(16),-16,nMB,G2H4(2),n2h4(62))
  call Hloop_QV_A(ntry,G2H4(2),ex5(:),G2H2(37),m3h2x2(:,37),heltab2x4(:,:,37))
  call Hloop_VA_Q(ntry,G1H4(20),ex4(:),G1H2(1),m3h2x2(:,38),heltab2x4(:,:,38))
  call Hloop_A_Q(ntry,G1H2(1),47,nMB,G2H2(38),n2h2(4))
  call Hloop_UV_W(ntry,G1H4(21),39,ex5(:),16,G2H2(39),m3h2x2(:,39),heltab2x4(:,:,39))
call HGT_OLR(G1H4(22),1,1,4)
call HGT_invQ_OLR(G1H4(22),2,5,4)
  call Hloop_Q_A(ntry,G1H4(22),-8,nMB,G2H4(3),n2h4(63))
  call Hloop_QA_V(ntry,G2H4(3),ex4(:),G2H2(40),m3h2x2(:,40),heltab2x4(:,:,40))
  call Hloop_UV_W(ntry,G1H4(26),39,ex5(:),16,G2H2(41),m3h2x2(:,41),heltab2x4(:,:,41))
  call Hloop_VQ_A(ntry,G1H4(27),ex3(:),G1H2(1),m3h2x2(:,42),heltab2x4(:,:,42))
  call Hloop_Q_A(ntry,G1H2(1),47,nMB,G2H2(42),n2h2(5))
call HGT_OLR(G1H4(28),1,1,4)
call HGT_invQ_OLR(G1H4(28),2,5,4)
  call Hloop_A_Q(ntry,G1H4(28),-16,nMB,G2H4(4),n2h4(64))
  call Hloop_AV_Q(ntry,G2H4(4),ex5(:),G2H2(43),m3h2x2(:,43),heltab2x4(:,:,43))
  call Hloop_VQ_A(ntry,G1H4(32),ex3(:),G1H2(1),m3h2x2(:,44),heltab2x4(:,:,44))
  call Hloop_Q_A(ntry,G1H2(1),47,nMB,G2H2(44),n2h2(6))
  call Hloop_VA_Q(ntry,G1H4(33),ex4(:),G1H2(1),m3h2x2(:,45),heltab2x4(:,:,45))
  call Hloop_A_Q(ntry,G1H2(1),47,nMB,G2H2(45),n2h2(7))
call HGT_OLR(G1H4(34),1,1,4)
call HGT_invQ_OLR(G1H4(34),2,5,4)
  call Hloop_Q_A(ntry,G1H4(34),-16,nMB,G2H4(5),n2h4(65))
  call Hloop_QV_A(ntry,G2H4(5),ex5(:),G2H2(46),m3h2x2(:,46),heltab2x4(:,:,46))
  call Hloop_VA_Q(ntry,G1H4(38),ex4(:),G1H2(1),m3h2x2(:,47),heltab2x4(:,:,47))
  call Hloop_A_Q(ntry,G1H2(1),47,nMB,G2H2(47),n2h2(8))
  call Hloop_UV_W(ntry,G1H4(39),39,ex5(:),16,G2H2(48),m3h2x2(:,48),heltab2x4(:,:,48))
call HGT_OLR(G1H4(40),1,1,4)
call HGT_invQ_OLR(G1H4(40),2,5,4)
  call Hloop_Q_A(ntry,G1H4(40),-8,nMB,G2H4(6),n2h4(66))
  call Hloop_QA_V(ntry,G2H4(6),ex4(:),G2H2(49),m3h2x2(:,49),heltab2x4(:,:,49))
  call Hloop_UV_W(ntry,G1H4(44),39,ex5(:),16,G2H2(50),m3h2x2(:,50),heltab2x4(:,:,50))
  call Hloop_VQ_A(ntry,G1H4(45),ex1(:),G1H2(1),m3h2x2(:,51),heltab2x4(:,:,51))
  call Hloop_Q_A(ntry,G1H2(1),47,nMT,G2H2(51),n2h2(9))
call HGT_OLR(G1H4(46),1,1,4)
call HGT_invQ_OLR(G1H4(46),2,5,4)
  call Hloop_A_Q(ntry,G1H4(46),-16,nMT,G2H4(7),n2h4(67))
  call Hloop_AV_Q(ntry,G2H4(7),ex5(:),G2H2(52),m3h2x2(:,52),heltab2x4(:,:,52))
  call Hloop_VQ_A(ntry,G1H4(50),ex1(:),G1H2(1),m3h2x2(:,53),heltab2x4(:,:,53))
  call Hloop_Q_A(ntry,G1H2(1),47,nMT,G2H2(53),n2h2(10))
  call Hloop_VA_Q(ntry,G1H4(51),ex2(:),G1H2(1),m3h2x2(:,54),heltab2x4(:,:,54))
  call Hloop_A_Q(ntry,G1H2(1),47,nMT,G2H2(54),n2h2(11))
call HGT_OLR(G1H4(52),1,1,4)
call HGT_invQ_OLR(G1H4(52),2,5,4)
  call Hloop_Q_A(ntry,G1H4(52),-16,nMT,G2H4(8),n2h4(68))
  call Hloop_QV_A(ntry,G2H4(8),ex5(:),G2H2(55),m3h2x2(:,55),heltab2x4(:,:,55))
  call Hloop_VA_Q(ntry,G1H4(56),ex2(:),G1H2(1),m3h2x2(:,56),heltab2x4(:,:,56))
  call Hloop_A_Q(ntry,G1H2(1),47,nMT,G2H2(56),n2h2(12))
  call Hloop_UV_W(ntry,G1H4(57),45,ex5(:),16,G2H2(57),m3h2x2(:,57),heltab2x4(:,:,57))
call HGT_OLR(G1H4(58),1,1,4)
call HGT_invQ_OLR(G1H4(58),2,5,4)
  call Hloop_Q_A(ntry,G1H4(58),-2,nMT,G2H4(9),n2h4(69))
  call Hloop_QA_V(ntry,G2H4(9),ex2(:),G2H2(58),m3h2x2(:,58),heltab2x4(:,:,58))
  call Hloop_UV_W(ntry,G1H4(62),45,ex5(:),16,G2H2(59),m3h2x2(:,59),heltab2x4(:,:,59))
  call Hloop_VQ_A(ntry,G1H4(63),ex1(:),G1H2(1),m3h2x2(:,60),heltab2x4(:,:,60))
  call Hloop_Q_A(ntry,G1H2(1),47,nMT,G2H2(60),n2h2(13))
call HGT_OLR(G1H4(64),1,1,4)
call HGT_invQ_OLR(G1H4(64),2,5,4)
  call Hloop_A_Q(ntry,G1H4(64),-16,nMT,G2H4(10),n2h4(70))
  call Hloop_AV_Q(ntry,G2H4(10),ex5(:),G2H2(61),m3h2x2(:,61),heltab2x4(:,:,61))
  call Hloop_VQ_A(ntry,G1H4(68),ex1(:),G1H2(1),m3h2x2(:,62),heltab2x4(:,:,62))
  call Hloop_Q_A(ntry,G1H2(1),47,nMT,G2H2(62),n2h2(14))
  call Hloop_VA_Q(ntry,G1H4(69),ex2(:),G1H2(1),m3h2x2(:,63),heltab2x4(:,:,63))
  call Hloop_A_Q(ntry,G1H2(1),47,nMT,G2H2(63),n2h2(15))
call HGT_OLR(G1H4(70),1,1,4)
call HGT_invQ_OLR(G1H4(70),2,5,4)
  call Hloop_Q_A(ntry,G1H4(70),-16,nMT,G2H4(11),n2h4(71))
  call Hloop_QV_A(ntry,G2H4(11),ex5(:),G2H2(64),m3h2x2(:,64),heltab2x4(:,:,64))
  call Hloop_VA_Q(ntry,G1H4(74),ex2(:),G1H2(1),m3h2x2(:,65),heltab2x4(:,:,65))
  call Hloop_A_Q(ntry,G1H2(1),47,nMT,G2H2(65),n2h2(16))
  call Hloop_UV_W(ntry,G1H4(75),45,ex5(:),16,G2H2(66),m3h2x2(:,66),heltab2x4(:,:,66))
call HGT_OLR(G1H4(76),1,1,4)
call HGT_invQ_OLR(G1H4(76),2,5,4)
  call Hloop_Q_A(ntry,G1H4(76),-2,nMT,G2H4(12),n2h4(72))
  call Hloop_QA_V(ntry,G2H4(12),ex2(:),G2H2(67),m3h2x2(:,67),heltab2x4(:,:,67))
  call Hloop_UV_W(ntry,G1H4(80),45,ex5(:),16,G2H2(68),m3h2x2(:,68),heltab2x4(:,:,68))
  call Hloop_VQ_A(ntry,G1H4(81),ex3(:),G1H2(1),m3h2x2(:,69),heltab2x4(:,:,69))
  call Hloop_Q_A(ntry,G1H2(1),55,nMB,G2H2(69),n2h2(17))
call HGT_raise_alpha_OLR(G1H4(82),1,1,4)
call HGT_raise_alpha_invQ_OLR(G1H4(82),2,5,4)
  call Hloop_VA_Q(ntry,G1H4(82),ex4(:),G1H2(1),m3h2x2(:,70),heltab2x4(:,:,70))
  call Hloop_VQ_A(ntry,G1H4(87),ex3(:),G1H2(2),m3h2x2(:,71),heltab2x4(:,:,71))
  call Hloop_Q_A(ntry,G1H2(2),55,nMB,G2H2(70),n2h2(18))
call HGT_raise_alpha_OLR(G1H4(88),1,1,4)
call HGT_raise_alpha_invQ_OLR(G1H4(88),2,5,4)
  call Hloop_VA_Q(ntry,G1H4(88),ex4(:),G1H2(2),m3h2x2(:,72),heltab2x4(:,:,72))
  call Hloop_VQ_A(ntry,G1H4(92),ex3(:),G1H2(3),m3h2x2(:,73),heltab2x4(:,:,73))
  call Hloop_Q_A(ntry,G1H2(3),55,nMB,G2H2(71),n2h2(19))
  call Hloop_VA_Q(ntry,G1H4(93),ex4(:),G1H2(3),m3h2x2(:,74),heltab2x4(:,:,74))
  call Hloop_A_Q(ntry,G1H2(3),59,nMB,G2H2(72),n2h2(20))
call HGT_raise_alpha_OLR(G1H4(94),1,1,4)
call HGT_raise_alpha_invQ_OLR(G1H4(94),2,5,4)
  call Hloop_VQ_A(ntry,G1H4(94),ex3(:),G1H2(3),m3h2x2(:,75),heltab2x4(:,:,75))
  call Hloop_VA_Q(ntry,G1H4(99),ex4(:),G1H2(4),m3h2x2(:,76),heltab2x4(:,:,76))
  call Hloop_A_Q(ntry,G1H2(4),59,nMB,G2H2(73),n2h2(21))
call HGT_raise_alpha_OLR(G1H4(100),1,1,4)
call HGT_raise_alpha_invQ_OLR(G1H4(100),2,5,4)
  call Hloop_VQ_A(ntry,G1H4(100),ex3(:),G1H2(4),m3h2x2(:,77),heltab2x4(:,:,77))
  call Hloop_VA_Q(ntry,G1H4(104),ex4(:),G1H2(5),m3h2x2(:,78),heltab2x4(:,:,78))
  call Hloop_A_Q(ntry,G1H2(5),59,nMB,G2H2(74),n2h2(22))
  call Hloop_VQ_A(ntry,G1H4(105),ex3(:),G1H2(5),m3h2x2(:,79),heltab2x4(:,:,79))
  call Hloop_Q_A(ntry,G1H2(5),55,nMB,G2H2(75),n2h2(23))
call HGT_raise_alpha_OLR(G1H4(106),1,1,4)
call HGT_raise_alpha_invQ_OLR(G1H4(106),2,5,4)
  call Hloop_VA_Q(ntry,G1H4(106),ex4(:),G1H2(5),m3h2x2(:,80),heltab2x4(:,:,80))
  call Hloop_VQ_A(ntry,G1H4(111),ex3(:),G1H2(6),m3h2x2(:,81),heltab2x4(:,:,81))
  call Hloop_Q_A(ntry,G1H2(6),55,nMB,G2H2(76),n2h2(24))
call HGT_raise_alpha_OLR(G1H4(112),1,1,4)
call HGT_raise_alpha_invQ_OLR(G1H4(112),2,5,4)
  call Hloop_VA_Q(ntry,G1H4(112),ex4(:),G1H2(6),m3h2x2(:,82),heltab2x4(:,:,82))
  call Hloop_VQ_A(ntry,G1H4(116),ex3(:),G1H2(7),m3h2x2(:,83),heltab2x4(:,:,83))
  call Hloop_Q_A(ntry,G1H2(7),55,nMB,G2H2(77),n2h2(25))
  call Hloop_VA_Q(ntry,G1H4(117),ex4(:),G1H2(7),m3h2x2(:,84),heltab2x4(:,:,84))
  call Hloop_A_Q(ntry,G1H2(7),59,nMB,G2H2(78),n2h2(26))
call HGT_raise_alpha_OLR(G1H4(118),1,1,4)
call HGT_raise_alpha_invQ_OLR(G1H4(118),2,5,4)
  call Hloop_VQ_A(ntry,G1H4(118),ex3(:),G1H2(7),m3h2x2(:,85),heltab2x4(:,:,85))
  call Hloop_VA_Q(ntry,G1H4(123),ex4(:),G1H2(8),m3h2x2(:,86),heltab2x4(:,:,86))
  call Hloop_A_Q(ntry,G1H2(8),59,nMB,G2H2(79),n2h2(27))
call HGT_raise_alpha_OLR(G1H4(124),1,1,4)
call HGT_raise_alpha_invQ_OLR(G1H4(124),2,5,4)
  call Hloop_VQ_A(ntry,G1H4(124),ex3(:),G1H2(8),m3h2x2(:,87),heltab2x4(:,:,87))
  call Hloop_VA_Q(ntry,G1H4(128),ex4(:),G1H2(9),m3h2x2(:,88),heltab2x4(:,:,88))
  call Hloop_A_Q(ntry,G1H2(9),59,nMB,G2H2(80),n2h2(28))
  call Hloop_QV_A(ntry,G1H4(129),ex5(:),G1H2(9),m3h2x2(:,89),heltab2x4(:,:,89))
  call Hloop_Q_A(ntry,G1H2(9),55,nMB,G2H2(81),n2h2(29))
call HGT_raise_alpha_OLR(G1H4(130),1,1,4)
call HGT_raise_alpha_invQ_OLR(G1H4(130),2,5,4)
  call Hloop_VA_Q(ntry,G1H4(130),ex4(:),G1H2(9),m3h2x2(:,90),heltab2x4(:,:,90))
  call Hloop_QV_A(ntry,G1H4(135),ex5(:),G1H2(10),m3h2x2(:,91),heltab2x4(:,:,91))
  call Hloop_Q_A(ntry,G1H2(10),55,nMB,G2H2(82),n2h2(30))
call HGT_raise_alpha_OLR(G1H4(136),1,1,4)
call HGT_raise_alpha_invQ_OLR(G1H4(136),2,5,4)
  call Hloop_VA_Q(ntry,G1H4(136),ex4(:),G1H2(10),m3h2x2(:,92),heltab2x4(:,:,92))
  call Hloop_QV_A(ntry,G1H4(140),ex5(:),G1H2(11),m3h2x2(:,93),heltab2x4(:,:,93))
  call Hloop_Q_A(ntry,G1H2(11),55,nMB,G2H2(83),n2h2(31))
  call Hloop_AV_Q(ntry,G1H4(141),ex5(:),G1H2(11),m3h2x2(:,94),heltab2x4(:,:,94))
  call Hloop_A_Q(ntry,G1H2(11),59,nMB,G2H2(84),n2h2(32))
call HGT_raise_alpha_OLR(G1H4(142),1,1,4)
call HGT_raise_alpha_invQ_OLR(G1H4(142),2,5,4)
  call Hloop_VQ_A(ntry,G1H4(142),ex3(:),G1H2(11),m3h2x2(:,95),heltab2x4(:,:,95))
  call Hloop_AV_Q(ntry,G1H4(147),ex5(:),G1H2(12),m3h2x2(:,96),heltab2x4(:,:,96))
  call Hloop_A_Q(ntry,G1H2(12),59,nMB,G2H2(85),n2h2(33))
call HGT_raise_alpha_OLR(G1H4(148),1,1,4)
call HGT_raise_alpha_invQ_OLR(G1H4(148),2,5,4)
  call Hloop_VQ_A(ntry,G1H4(148),ex3(:),G1H2(12),m3h2x2(:,97),heltab2x4(:,:,97))
  call Hloop_AV_Q(ntry,G1H4(152),ex5(:),G1H2(13),m3h2x2(:,98),heltab2x4(:,:,98))
  call Hloop_A_Q(ntry,G1H2(13),59,nMB,G2H2(86),n2h2(34))
  call Hloop_VQ_A(ntry,G1H4(153),ex3(:),G1H2(13),m3h2x2(:,99),heltab2x4(:,:,99))
  call Hloop_Q_A(ntry,G1H2(13),55,nMB,G2H2(87),n2h2(35))
call HGT_raise_alpha_OLR(G1H4(154),1,1,4)
call HGT_raise_alpha_invQ_OLR(G1H4(154),2,5,4)
  call Hloop_VA_Q(ntry,G1H4(154),ex4(:),G1H2(13),m3h2x2(:,100),heltab2x4(:,:,100))
  call Hloop_VQ_A(ntry,G1H4(159),ex3(:),G1H2(14),m3h2x2(:,101),heltab2x4(:,:,101))
  call Hloop_Q_A(ntry,G1H2(14),55,nMB,G2H2(88),n2h2(36))
call HGT_raise_alpha_OLR(G1H4(160),1,1,4)
call HGT_raise_alpha_invQ_OLR(G1H4(160),2,5,4)
  call Hloop_VA_Q(ntry,G1H4(160),ex4(:),G1H2(14),m3h2x2(:,102),heltab2x4(:,:,102))
  call Hloop_VQ_A(ntry,G1H4(164),ex3(:),G1H2(15),m3h2x2(:,103),heltab2x4(:,:,103))
  call Hloop_Q_A(ntry,G1H2(15),55,nMB,G2H2(89),n2h2(37))
  call Hloop_VA_Q(ntry,G1H4(165),ex4(:),G1H2(15),m3h2x2(:,104),heltab2x4(:,:,104))
  call Hloop_A_Q(ntry,G1H2(15),59,nMB,G2H2(90),n2h2(38))
call HGT_raise_alpha_OLR(G1H4(166),1,1,4)
call HGT_raise_alpha_invQ_OLR(G1H4(166),2,5,4)
  call Hloop_VQ_A(ntry,G1H4(166),ex3(:),G1H2(15),m3h2x2(:,105),heltab2x4(:,:,105))
  call Hloop_VA_Q(ntry,G1H4(171),ex4(:),G1H2(16),m3h2x2(:,106),heltab2x4(:,:,106))
  call Hloop_A_Q(ntry,G1H2(16),59,nMB,G2H2(91),n2h2(39))
call HGT_raise_alpha_OLR(G1H4(172),1,1,4)
call HGT_raise_alpha_invQ_OLR(G1H4(172),2,5,4)
  call Hloop_VQ_A(ntry,G1H4(172),ex3(:),G1H2(16),m3h2x2(:,107),heltab2x4(:,:,107))
  call Hloop_VA_Q(ntry,G1H4(176),ex4(:),G1H2(17),m3h2x2(:,108),heltab2x4(:,:,108))
  call Hloop_A_Q(ntry,G1H2(17),59,nMB,G2H2(92),n2h2(40))
  call Hloop_QV_A(ntry,G1H4(177),ex5(:),G1H2(17),m3h2x2(:,109),heltab2x4(:,:,109))
  call Hloop_Q_A(ntry,G1H2(17),55,nMB,G2H2(93),n2h2(41))
call HGT_raise_alpha_OLR(G1H4(178),1,1,4)
call HGT_raise_alpha_invQ_OLR(G1H4(178),2,5,4)
  call Hloop_VA_Q(ntry,G1H4(178),ex4(:),G1H2(17),m3h2x2(:,110),heltab2x4(:,:,110))
  call Hloop_QV_A(ntry,G1H4(183),ex5(:),G1H2(18),m3h2x2(:,111),heltab2x4(:,:,111))
  call Hloop_Q_A(ntry,G1H2(18),55,nMB,G2H2(94),n2h2(42))
call HGT_raise_alpha_OLR(G1H4(184),1,1,4)
call HGT_raise_alpha_invQ_OLR(G1H4(184),2,5,4)
  call Hloop_VA_Q(ntry,G1H4(184),ex4(:),G1H2(18),m3h2x2(:,112),heltab2x4(:,:,112))
  call Hloop_QV_A(ntry,G1H4(188),ex5(:),G1H2(19),m3h2x2(:,113),heltab2x4(:,:,113))
  call Hloop_Q_A(ntry,G1H2(19),55,nMB,G2H2(95),n2h2(43))
  call Hloop_AV_Q(ntry,G1H4(189),ex5(:),G1H2(19),m3h2x2(:,114),heltab2x4(:,:,114))
  call Hloop_A_Q(ntry,G1H2(19),59,nMB,G2H2(96),n2h2(44))
call HGT_raise_alpha_OLR(G1H4(190),1,1,4)
call HGT_raise_alpha_invQ_OLR(G1H4(190),2,5,4)
  call Hloop_VQ_A(ntry,G1H4(190),ex3(:),G1H2(19),m3h2x2(:,115),heltab2x4(:,:,115))
  call Hloop_AV_Q(ntry,G1H4(195),ex5(:),G1H2(20),m3h2x2(:,116),heltab2x4(:,:,116))
  call Hloop_A_Q(ntry,G1H2(20),59,nMB,G2H2(97),n2h2(45))
call HGT_raise_alpha_OLR(G1H4(196),1,1,4)
call HGT_raise_alpha_invQ_OLR(G1H4(196),2,5,4)
  call Hloop_VQ_A(ntry,G1H4(196),ex3(:),G1H2(20),m3h2x2(:,117),heltab2x4(:,:,117))
  call Hloop_AV_Q(ntry,G1H4(200),ex5(:),G1H2(21),m3h2x2(:,118),heltab2x4(:,:,118))
  call Hloop_A_Q(ntry,G1H2(21),59,nMB,G2H2(98),n2h2(46))
  call Hloop_VQ_A(ntry,G1H4(201),ex3(:),G1H2(21),m3h2x2(:,119),heltab2x4(:,:,119))
  call Hloop_Q_A(ntry,G1H2(21),55,nMB,G2H2(99),n2h2(47))
call HGT_raise_alpha_OLR(G1H4(202),1,1,4)
call HGT_raise_alpha_invQ_OLR(G1H4(202),2,5,4)
  call Hloop_VA_Q(ntry,G1H4(202),ex4(:),G1H2(21),m3h2x2(:,120),heltab2x4(:,:,120))
  call Hloop_VQ_A(ntry,G1H4(207),ex3(:),G1H2(22),m3h2x2(:,121),heltab2x4(:,:,121))
  call Hloop_Q_A(ntry,G1H2(22),55,nMB,G2H2(100),n2h2(48))
call HGT_raise_alpha_OLR(G1H4(208),1,1,4)
call HGT_raise_alpha_invQ_OLR(G1H4(208),2,5,4)
  call Hloop_VA_Q(ntry,G1H4(208),ex4(:),G1H2(22),m3h2x2(:,122),heltab2x4(:,:,122))
  call Hloop_VQ_A(ntry,G1H4(212),ex3(:),G1H2(23),m3h2x2(:,123),heltab2x4(:,:,123))
  call Hloop_Q_A(ntry,G1H2(23),55,nMB,G2H2(101),n2h2(49))
  call Hloop_VA_Q(ntry,G1H4(213),ex4(:),G1H2(23),m3h2x2(:,124),heltab2x4(:,:,124))
  call Hloop_A_Q(ntry,G1H2(23),59,nMB,G2H2(102),n2h2(50))
call HGT_raise_alpha_OLR(G1H4(214),1,1,4)
call HGT_raise_alpha_invQ_OLR(G1H4(214),2,5,4)
  call Hloop_VQ_A(ntry,G1H4(214),ex3(:),G1H2(23),m3h2x2(:,125),heltab2x4(:,:,125))
  call Hloop_VA_Q(ntry,G1H4(219),ex4(:),G1H2(24),m3h2x2(:,126),heltab2x4(:,:,126))
  call Hloop_A_Q(ntry,G1H2(24),59,nMB,G2H2(103),n2h2(51))
call HGT_raise_alpha_OLR(G1H4(220),1,1,4)
call HGT_raise_alpha_invQ_OLR(G1H4(220),2,5,4)
  call Hloop_VQ_A(ntry,G1H4(220),ex3(:),G1H2(24),m3h2x2(:,127),heltab2x4(:,:,127))
  call Hloop_VA_Q(ntry,G1H4(224),ex4(:),G1H2(25),m3h2x2(:,128),heltab2x4(:,:,128))
  call Hloop_A_Q(ntry,G1H2(25),59,nMB,G2H2(104),n2h2(52))
call Hotf_5pt_reduction(G2H2(1),RedSet_5(3),mass5set(:,2),  & 
G1H2(25),G1H2(26),G1H2(27),G1H2(28),G1H2(29),G1H2(30),2)
call HG1shiftOLR(G1H2(26),16,2)
call Hotf_5pt_reduction(G2H2(3),RedSet_5(4),mass5set(:,3),  & 
G1H2(31),G1H2(32),G1H2(33),G1H2(34),G1H2(35),G1H2(36),2)
call HG1shiftOLR(G1H2(32),16,2)
call Hotf_5pt_reduction(G2H2(5),RedSet_5(5),mass5set(:,2),  & 
G1H2(37),G1H2(38),G1H2(39),G1H2(40),G1H2(41),G1H2(42),2)
call HG1shiftOLR(G1H2(38),16,2)
call Hotf_5pt_reduction(G2H2(7),RedSet_5(6),mass5set(:,4),  & 
G1H2(43),G1H2(44),G1H2(45),G1H2(46),G1H2(47),G1H2(48),2)
call HG1shiftOLR(G1H2(44),8,2)
call Hotf_5pt_reduction(G2H2(9),RedSet_5(7),mass5set(:,3),  & 
G1H2(49),G1H2(50),G1H2(51),G1H2(52),G1H2(53),G1H2(54),2)
call HG1shiftOLR(G1H2(50),16,2)
call Hotf_5pt_reduction(G2H2(11),RedSet_5(8),mass5set(:,2),  & 
G1H2(55),G1H2(56),G1H2(57),G1H2(58),G1H2(59),G1H2(60),2)
call HG1shiftOLR(G1H2(56),16,2)
call Hotf_5pt_reduction(G2H2(13),RedSet_5(9),mass5set(:,2),  & 
G1H2(61),G1H2(62),G1H2(63),G1H2(64),G1H2(65),G1H2(66),2)
call HG1shiftOLR(G1H2(62),16,2)
call Hotf_5pt_reduction(G2H2(15),RedSet_5(10),mass5set(:,4),  & 
G1H2(67),G1H2(68),G1H2(69),G1H2(70),G1H2(71),G1H2(72),2)
call HG1shiftOLR(G1H2(68),8,2)
call Hotf_5pt_reduction(G2H2(17),RedSet_5(12),mass5set(:,3),  & 
G1H2(73),G1H2(74),G1H2(75),G1H2(76),G1H2(77),G1H2(78),2)
call HG1shiftOLR(G1H2(74),16,2)
call Hotf_5pt_reduction(G2H2(19),RedSet_5(13),mass5set(:,3),  & 
G1H2(79),G1H2(80),G1H2(81),G1H2(82),G1H2(83),G1H2(84),2)
call HG1shiftOLR(G1H2(80),16,2)
call Hotf_5pt_reduction(G2H2(21),RedSet_5(15),mass5set(:,6),  & 
G1H2(85),G1H2(86),G1H2(87),G1H2(88),G1H2(89),G1H2(90),2)
call HG1shiftOLR(G1H2(86),8,2)
call Hotf_5pt_reduction(G2H2(23),RedSet_5(16),mass5set(:,7),  & 
G1H2(91),G1H2(92),G1H2(93),G1H2(94),G1H2(95),G1H2(96),2)
call HG1shiftOLR(G1H2(92),2,2)
call Hotf_5pt_reduction(G2H2(25),RedSet_5(17),mass5set(:,6),  & 
G1H2(97),G1H2(98),G1H2(99),G1H2(100),G1H2(101),G1H2(102),2)
call HG1shiftOLR(G1H2(98),8,2)
call Hotf_5pt_reduction(G2H2(27),RedSet_5(18),mass5set(:,7),  & 
G1H2(103),G1H2(104),G1H2(105),G1H2(106),G1H2(107),G1H2(108),2)
call HG1shiftOLR(G1H2(104),2,2)
call Hotf_5pt_reduction(G2H2(29),RedSet_5(19),mass5set(:,8),  & 
G1H2(109),G1H2(110),G1H2(111),G1H2(112),G1H2(113),G1H2(114),2)
call HG1shiftOLR(G1H2(110),2,2)
call Hotf_5pt_reduction(G2H2(31),RedSet_5(20),mass5set(:,8),  & 
G1H2(115),G1H2(116),G1H2(117),G1H2(118),G1H2(119),G1H2(120),2)
call HG1shiftOLR(G1H2(116),2,2)
call Hotf_5pt_reduction(G2H2(33),RedSet_5(21),mass5set(:,9),  & 
G1H2(121),G1H2(122),G1H2(123),G1H2(124),G1H2(125),G1H2(126),2)
call HG1shiftOLR(G1H2(122),16,2)
call Hotf_5pt_reduction(G2H2(36),RedSet_5(22),mass5set(:,9),  & 
G1H2(127),G1H2(128),G1H2(129),G1H2(130),G1H2(131),G1H2(132),2)
call HG1shiftOLR(G1H2(128),16,2)
call Hotf_5pt_reduction(G2H2(39),RedSet_5(22),mass5set(:,9),  & 
G1H2(133),G1H2(134),G1H2(135),G1H2(136),G1H2(137),G1H2(138),2)
call HG1shiftOLR(G1H2(134),8,2)
call Hotf_5pt_reduction(G2H2(42),RedSet_5(23),mass5set(:,9),  & 
G1H2(139),G1H2(140),G1H2(141),G1H2(142),G1H2(143),G1H2(144),2)
call HG1shiftOLR(G1H2(140),16,2)
call Hotf_5pt_reduction(G2H2(45),RedSet_5(24),mass5set(:,9),  & 
G1H2(145),G1H2(146),G1H2(147),G1H2(148),G1H2(149),G1H2(150),2)
call HG1shiftOLR(G1H2(146),16,2)
call Hotf_5pt_reduction(G2H2(48),RedSet_5(24),mass5set(:,9),  & 
G1H2(151),G1H2(152),G1H2(153),G1H2(154),G1H2(155),G1H2(156),2)
call HG1shiftOLR(G1H2(152),8,2)
call Hotf_5pt_reduction(G2H2(51),RedSet_5(25),mass5set(:,10),  & 
G1H2(157),G1H2(158),G1H2(159),G1H2(160),G1H2(161),G1H2(162),2)
call HG1shiftOLR(G1H2(158),16,2)
call Hotf_5pt_reduction(G2H2(54),RedSet_5(26),mass5set(:,10),  & 
G1H2(163),G1H2(164),G1H2(165),G1H2(166),G1H2(167),G1H2(168),2)
call HG1shiftOLR(G1H2(164),16,2)
call Hotf_5pt_reduction(G2H2(57),RedSet_5(26),mass5set(:,10),  & 
G1H2(169),G1H2(170),G1H2(171),G1H2(172),G1H2(173),G1H2(174),2)
call HG1shiftOLR(G1H2(170),2,2)
call Hotf_5pt_reduction(G2H2(60),RedSet_5(27),mass5set(:,10),  & 
G1H2(175),G1H2(176),G1H2(177),G1H2(178),G1H2(179),G1H2(180),2)
call HG1shiftOLR(G1H2(176),16,2)
call Hotf_5pt_reduction(G2H2(63),RedSet_5(28),mass5set(:,10),  & 
G1H2(181),G1H2(182),G1H2(183),G1H2(184),G1H2(185),G1H2(186),2)
call HG1shiftOLR(G1H2(182),16,2)
call Hotf_5pt_reduction(G2H2(66),RedSet_5(28),mass5set(:,10),  & 
G1H2(187),G1H2(188),G1H2(189),G1H2(190),G1H2(191),G1H2(192),2)
call HG1shiftOLR(G1H2(188),2,2)
  call Hcheck_last_QA_V(ntry,l_switch,G2H2(69),ex4(:),G2tensor(1),m3h2x1(:,1),heltab2x2(:,:,1))
  call Hcheck_last_AQ_V(ntry,l_switch,G2H2(72),ex3(:),G2tensor(2),m3h2x1(:,2),heltab2x2(:,:,2))
  call Hcheck_last_QA_V(ntry,l_switch,G2H2(75),ex4(:),G2tensor(3),m3h2x1(:,3),heltab2x2(:,:,3))
  call Hcheck_last_AQ_V(ntry,l_switch,G2H2(78),ex3(:),G2tensor(4),m3h2x1(:,4),heltab2x2(:,:,4))
  call Hcheck_last_QA_V(ntry,l_switch,G2H2(81),ex4(:),G2tensor(5),m3h2x1(:,5),heltab2x2(:,:,5))
  call Hcheck_last_AQ_V(ntry,l_switch,G2H2(84),ex3(:),G2tensor(6),m3h2x1(:,6),heltab2x2(:,:,6))
  call Hcheck_last_QA_V(ntry,l_switch,G2H2(87),ex4(:),G2tensor(7),m3h2x1(:,7),heltab2x2(:,:,7))
  call Hcheck_last_AQ_V(ntry,l_switch,G2H2(90),ex3(:),G2tensor(8),m3h2x1(:,8),heltab2x2(:,:,8))
  call Hcheck_last_QA_V(ntry,l_switch,G2H2(93),ex4(:),G2tensor(9),m3h2x1(:,9),heltab2x2(:,:,9))
  call Hcheck_last_AQ_V(ntry,l_switch,G2H2(96),ex3(:),G2tensor(10),m3h2x1(:,10),heltab2x2(:,:,10))
  call Hcheck_last_QA_V(ntry,l_switch,G2H2(99),ex4(:),G2tensor(11),m3h2x1(:,11),heltab2x2(:,:,11))
  call Hcheck_last_AQ_V(ntry,l_switch,G2H2(102),ex3(:),G2tensor(12),m3h2x1(:,12),heltab2x2(:,:,12))
  call Hcheck_last_UV_W(ntry,l_switch,G1H2(25),47,ex5(:),16,G2tensor(13),m3h2x1(:,13),heltab2x2(:,:,13))
  call Hcheck_last_UV_W(ntry,l_switch,G1H2(26),0,ex5(:),16,G2tensor(14),m3h2x1(:,14),heltab2x2(:,:,14))
  call Hcheck_last_UV_W(ntry,l_switch,G1H2(31),47,ex5(:),16,G2tensor(15),m3h2x1(:,15),heltab2x2(:,:,15))
  call Hcheck_last_UV_W(ntry,l_switch,G1H2(32),0,ex5(:),16,G2tensor(16),m3h2x1(:,16),heltab2x2(:,:,16))
  call Hcheck_last_UV_W(ntry,l_switch,G1H2(37),47,ex5(:),16,G2tensor(17),m3h2x1(:,17),heltab2x2(:,:,17))
  call Hcheck_last_UV_W(ntry,l_switch,G1H2(38),0,ex5(:),16,G2tensor(18),m3h2x1(:,18),heltab2x2(:,:,18))
  call Hloop_VA_Q(ntry,G1H2(43),ex4(:),G1H1(1),m3h2x1(:,19),heltab2x2(:,:,19))
  call Hcheck_last_A_Q(ntry,l_switch,G1H1(1),63,nMB,G2tensor(19),n2h1(4))
  call Hloop_VA_Q(ntry,G1H2(44),ex4(:),G1H1(1),m3h2x1(:,20),heltab2x2(:,:,20))
  call Hcheck_last_A_Q(ntry,l_switch,G1H1(1),8,nMB,G2tensor(20),n2h1(5))
  call Hcheck_last_UV_W(ntry,l_switch,G1H2(49),47,ex5(:),16,G2tensor(21),m3h2x1(:,21),heltab2x2(:,:,21))
  call Hcheck_last_UV_W(ntry,l_switch,G1H2(50),0,ex5(:),16,G2tensor(22),m3h2x1(:,22),heltab2x2(:,:,22))
  call Hcheck_last_UV_W(ntry,l_switch,G1H2(55),47,ex5(:),16,G2tensor(23),m3h2x1(:,23),heltab2x2(:,:,23))
  call Hcheck_last_UV_W(ntry,l_switch,G1H2(56),0,ex5(:),16,G2tensor(24),m3h2x1(:,24),heltab2x2(:,:,24))
  call Hcheck_last_UV_W(ntry,l_switch,G1H2(61),47,ex5(:),16,G2tensor(25),m3h2x1(:,25),heltab2x2(:,:,25))
  call Hcheck_last_UV_W(ntry,l_switch,G1H2(62),0,ex5(:),16,G2tensor(26),m3h2x1(:,26),heltab2x2(:,:,26))
  call Hloop_VA_Q(ntry,G1H2(67),ex4(:),G1H1(1),m3h2x1(:,27),heltab2x2(:,:,27))
  call Hcheck_last_A_Q(ntry,l_switch,G1H1(1),63,nMB,G2tensor(27),n2h1(9))
  call Hloop_VA_Q(ntry,G1H2(68),ex4(:),G1H1(1),m3h2x1(:,28),heltab2x2(:,:,28))
  call Hcheck_last_A_Q(ntry,l_switch,G1H1(1),8,nMB,G2tensor(28),n2h1(10))
  call Hcheck_last_UV_W(ntry,l_switch,G1H2(73),47,ex5(:),16,G2tensor(29),m3h2x1(:,29),heltab2x2(:,:,29))
  call Hcheck_last_UV_W(ntry,l_switch,G1H2(74),0,ex5(:),16,G2tensor(30),m3h2x1(:,30),heltab2x2(:,:,30))
  call Hcheck_last_UV_W(ntry,l_switch,G1H2(79),47,ex5(:),16,G2tensor(31),m3h2x1(:,31),heltab2x2(:,:,31))
  call Hcheck_last_UV_W(ntry,l_switch,G1H2(80),0,ex5(:),16,G2tensor(32),m3h2x1(:,32),heltab2x2(:,:,32))
  call Hloop_VA_Q(ntry,G1H2(85),ex4(:),G1H1(1),m3h2x1(:,33),heltab2x2(:,:,33))
  call Hcheck_last_A_Q(ntry,l_switch,G1H1(1),63,nMB,G2tensor(33),n2h1(13))
  call Hloop_VA_Q(ntry,G1H2(86),ex4(:),G1H1(1),m3h2x1(:,34),heltab2x2(:,:,34))
  call Hcheck_last_A_Q(ntry,l_switch,G1H1(1),8,nMB,G2tensor(34),n2h1(14))
  call Hloop_VA_Q(ntry,G1H2(91),ex2(:),G1H1(1),m3h2x1(:,35),heltab2x2(:,:,35))
  call Hcheck_last_A_Q(ntry,l_switch,G1H1(1),63,nMT,G2tensor(35),n2h1(15))
  call Hloop_VA_Q(ntry,G1H2(92),ex2(:),G1H1(1),m3h2x1(:,36),heltab2x2(:,:,36))
  call Hcheck_last_A_Q(ntry,l_switch,G1H1(1),2,nMT,G2tensor(36),n2h1(16))
  call Hloop_VA_Q(ntry,G1H2(97),ex4(:),G1H1(1),m3h2x1(:,37),heltab2x2(:,:,37))
  call Hcheck_last_A_Q(ntry,l_switch,G1H1(1),63,nMB,G2tensor(37),n2h1(17))
  call Hloop_VA_Q(ntry,G1H2(98),ex4(:),G1H1(1),m3h2x1(:,38),heltab2x2(:,:,38))
  call Hcheck_last_A_Q(ntry,l_switch,G1H1(1),8,nMB,G2tensor(38),n2h1(18))
  call Hloop_VA_Q(ntry,G1H2(103),ex2(:),G1H1(1),m3h2x1(:,39),heltab2x2(:,:,39))
  call Hcheck_last_A_Q(ntry,l_switch,G1H1(1),63,nMT,G2tensor(39),n2h1(19))
  call Hloop_VA_Q(ntry,G1H2(104),ex2(:),G1H1(1),m3h2x1(:,40),heltab2x2(:,:,40))
  call Hcheck_last_A_Q(ntry,l_switch,G1H1(1),2,nMT,G2tensor(40),n2h1(20))
  call Hloop_VA_Q(ntry,G1H2(109),ex2(:),G1H1(1),m3h2x1(:,41),heltab2x2(:,:,41))
  call Hcheck_last_A_Q(ntry,l_switch,G1H1(1),63,nMT,G2tensor(41),n2h1(21))
  call Hloop_VA_Q(ntry,G1H2(110),ex2(:),G1H1(1),m3h2x1(:,42),heltab2x2(:,:,42))
  call Hcheck_last_A_Q(ntry,l_switch,G1H1(1),2,nMT,G2tensor(42),n2h1(22))
  call Hloop_VA_Q(ntry,G1H2(115),ex2(:),G1H1(1),m3h2x1(:,43),heltab2x2(:,:,43))
  call Hcheck_last_A_Q(ntry,l_switch,G1H1(1),63,nMT,G2tensor(43),n2h1(23))
  call Hloop_VA_Q(ntry,G1H2(116),ex2(:),G1H1(1),m3h2x1(:,44),heltab2x2(:,:,44))
  call Hcheck_last_A_Q(ntry,l_switch,G1H1(1),2,nMT,G2tensor(44),n2h1(24))
  call Hloop_QV_A(ntry,G1H2(121),ex5(:),G1H1(1),m3h2x1(:,45),heltab2x2(:,:,45))
  call Hcheck_last_Q_A(ntry,l_switch,G1H1(1),63,nMB,G2tensor(45),n2h1(25))
  call Hloop_QV_A(ntry,G1H2(122),ex5(:),G1H1(1),m3h2x1(:,46),heltab2x2(:,:,46))
  call Hcheck_last_Q_A(ntry,l_switch,G1H1(1),16,nMB,G2tensor(46),n2h1(26))
  call Hloop_AV_Q(ntry,G1H2(127),ex5(:),G1H1(1),m3h2x1(:,47),heltab2x2(:,:,47))
  call Hcheck_last_A_Q(ntry,l_switch,G1H1(1),63,nMB,G2tensor(47),n2h1(27))
  call Hloop_AV_Q(ntry,G1H2(128),ex5(:),G1H1(1),m3h2x1(:,48),heltab2x2(:,:,48))
  call Hcheck_last_A_Q(ntry,l_switch,G1H1(1),16,nMB,G2tensor(48),n2h1(28))
  call Hloop_VA_Q(ntry,G1H2(133),ex4(:),G1H1(1),m3h2x1(:,49),heltab2x2(:,:,49))
  call Hcheck_last_A_Q(ntry,l_switch,G1H1(1),63,nMB,G2tensor(49),n2h1(29))
  call Hloop_VA_Q(ntry,G1H2(134),ex4(:),G1H1(1),m3h2x1(:,50),heltab2x2(:,:,50))
  call Hcheck_last_A_Q(ntry,l_switch,G1H1(1),8,nMB,G2tensor(50),n2h1(30))
  call Hloop_QV_A(ntry,G1H2(139),ex5(:),G1H1(1),m3h2x1(:,51),heltab2x2(:,:,51))
  call Hcheck_last_Q_A(ntry,l_switch,G1H1(1),63,nMB,G2tensor(51),n2h1(31))
  call Hloop_QV_A(ntry,G1H2(140),ex5(:),G1H1(1),m3h2x1(:,52),heltab2x2(:,:,52))
  call Hcheck_last_Q_A(ntry,l_switch,G1H1(1),16,nMB,G2tensor(52),n2h1(32))
  call Hloop_AV_Q(ntry,G1H2(145),ex5(:),G1H1(1),m3h2x1(:,53),heltab2x2(:,:,53))
  call Hcheck_last_A_Q(ntry,l_switch,G1H1(1),63,nMB,G2tensor(53),n2h1(33))
  call Hloop_AV_Q(ntry,G1H2(146),ex5(:),G1H1(1),m3h2x1(:,54),heltab2x2(:,:,54))
  call Hcheck_last_A_Q(ntry,l_switch,G1H1(1),16,nMB,G2tensor(54),n2h1(34))
  call Hloop_VA_Q(ntry,G1H2(151),ex4(:),G1H1(1),m3h2x1(:,55),heltab2x2(:,:,55))
  call Hcheck_last_A_Q(ntry,l_switch,G1H1(1),63,nMB,G2tensor(55),n2h1(35))
  call Hloop_VA_Q(ntry,G1H2(152),ex4(:),G1H1(1),m3h2x1(:,56),heltab2x2(:,:,56))
  call Hcheck_last_A_Q(ntry,l_switch,G1H1(1),8,nMB,G2tensor(56),n2h1(36))
  call Hloop_QV_A(ntry,G1H2(157),ex5(:),G1H1(1),m3h2x1(:,57),heltab2x2(:,:,57))
  call Hcheck_last_Q_A(ntry,l_switch,G1H1(1),63,nMT,G2tensor(57),n2h1(37))
  call Hloop_QV_A(ntry,G1H2(158),ex5(:),G1H1(1),m3h2x1(:,58),heltab2x2(:,:,58))
  call Hcheck_last_Q_A(ntry,l_switch,G1H1(1),16,nMT,G2tensor(58),n2h1(38))
  call Hloop_AV_Q(ntry,G1H2(163),ex5(:),G1H1(1),m3h2x1(:,59),heltab2x2(:,:,59))
  call Hcheck_last_A_Q(ntry,l_switch,G1H1(1),63,nMT,G2tensor(59),n2h1(39))
  call Hloop_AV_Q(ntry,G1H2(164),ex5(:),G1H1(1),m3h2x1(:,60),heltab2x2(:,:,60))
  call Hcheck_last_A_Q(ntry,l_switch,G1H1(1),16,nMT,G2tensor(60),n2h1(40))
  call Hloop_VA_Q(ntry,G1H2(169),ex2(:),G1H1(1),m3h2x1(:,61),heltab2x2(:,:,61))
  call Hcheck_last_A_Q(ntry,l_switch,G1H1(1),63,nMT,G2tensor(61),n2h1(41))
  call Hloop_VA_Q(ntry,G1H2(170),ex2(:),G1H1(1),m3h2x1(:,62),heltab2x2(:,:,62))
  call Hcheck_last_A_Q(ntry,l_switch,G1H1(1),2,nMT,G2tensor(62),n2h1(42))
  call Hloop_QV_A(ntry,G1H2(175),ex5(:),G1H1(1),m3h2x1(:,63),heltab2x2(:,:,63))
  call Hcheck_last_Q_A(ntry,l_switch,G1H1(1),63,nMT,G2tensor(63),n2h1(43))
  call Hloop_QV_A(ntry,G1H2(176),ex5(:),G1H1(1),m3h2x1(:,64),heltab2x2(:,:,64))
  call Hcheck_last_Q_A(ntry,l_switch,G1H1(1),16,nMT,G2tensor(64),n2h1(44))
  call Hloop_AV_Q(ntry,G1H2(181),ex5(:),G1H1(1),m3h2x1(:,65),heltab2x2(:,:,65))
  call Hcheck_last_A_Q(ntry,l_switch,G1H1(1),63,nMT,G2tensor(65),n2h1(45))
  call Hloop_AV_Q(ntry,G1H2(182),ex5(:),G1H1(1),m3h2x1(:,66),heltab2x2(:,:,66))
  call Hcheck_last_A_Q(ntry,l_switch,G1H1(1),16,nMT,G2tensor(66),n2h1(46))
  call Hloop_VA_Q(ntry,G1H2(187),ex2(:),G1H1(1),m3h2x1(:,67),heltab2x2(:,:,67))
  call Hcheck_last_A_Q(ntry,l_switch,G1H1(1),63,nMT,G2tensor(67),n2h1(47))
  call Hloop_VA_Q(ntry,G1H2(188),ex2(:),G1H1(1),m3h2x1(:,68),heltab2x2(:,:,68))
  call Hcheck_last_A_Q(ntry,l_switch,G1H1(1),2,nMT,G2tensor(68),n2h1(48))
call Hotf_5pt_reduction_last(G2tensor(1),RedSet_5(1),mass5set(:,1),  & 
G1tensor(1),G1tensor(2),G1tensor(3),G1tensor(4),G1tensor(5),G1tensor(6))
call G_TensorShift(G1tensor(2),8)
call Hotf_5pt_reduction_last(G2tensor(2),RedSet_5(1),mass5set(:,1),  & 
G1tensor(7),G1tensor(8),G1tensor(9),G1tensor(10),G1tensor(11),G1tensor(12))
call G_TensorShift(G1tensor(8),4)
call Hotf_5pt_reduction_last(G2tensor(3),RedSet_5(2),mass5set(:,1),  & 
G1tensor(13),G1tensor(14),G1tensor(15),G1tensor(16),G1tensor(17),G1tensor(18))
call G_TensorShift(G1tensor(14),8)
call Hotf_5pt_reduction_last(G2tensor(4),RedSet_5(2),mass5set(:,1),  & 
G1tensor(19),G1tensor(20),G1tensor(21),G1tensor(22),G1tensor(23),G1tensor(24))
call G_TensorShift(G1tensor(20),4)
call Hotf_5pt_reduction_last(G2tensor(5),RedSet_5(4),mass5set(:,3),  & 
G1tensor(25),G1tensor(26),G1tensor(27),G1tensor(28),G1tensor(29),G1tensor(30))
call G_TensorShift(G1tensor(26),8)
call Hotf_5pt_reduction_last(G2tensor(6),RedSet_5(7),mass5set(:,3),  & 
G1tensor(31),G1tensor(32),G1tensor(33),G1tensor(34),G1tensor(35),G1tensor(36))
call G_TensorShift(G1tensor(32),4)
call Hotf_5pt_reduction_last(G2tensor(7),RedSet_5(11),mass5set(:,5),  & 
G1tensor(37),G1tensor(38),G1tensor(39),G1tensor(40),G1tensor(41),G1tensor(42))
call G_TensorShift(G1tensor(38),8)
call Hotf_5pt_reduction_last(G2tensor(8),RedSet_5(11),mass5set(:,5),  & 
G1tensor(43),G1tensor(44),G1tensor(45),G1tensor(46),G1tensor(47),G1tensor(48))
call G_TensorShift(G1tensor(44),4)
call Hotf_5pt_reduction_last(G2tensor(9),RedSet_5(12),mass5set(:,3),  & 
G1tensor(49),G1tensor(50),G1tensor(51),G1tensor(52),G1tensor(53),G1tensor(54))
call G_TensorShift(G1tensor(50),8)
call Hotf_5pt_reduction_last(G2tensor(10),RedSet_5(13),mass5set(:,3),  & 
G1tensor(55),G1tensor(56),G1tensor(57),G1tensor(58),G1tensor(59),G1tensor(60))
call G_TensorShift(G1tensor(56),4)
call Hotf_5pt_reduction_last(G2tensor(11),RedSet_5(14),mass5set(:,5),  & 
G1tensor(61),G1tensor(62),G1tensor(63),G1tensor(64),G1tensor(65),G1tensor(66))
call G_TensorShift(G1tensor(62),8)
call Hotf_5pt_reduction_last(G2tensor(12),RedSet_5(14),mass5set(:,5),  & 
G1tensor(67),G1tensor(68),G1tensor(69),G1tensor(70),G1tensor(71),G1tensor(72))
call G_TensorShift(G1tensor(68),4)
call Hotf_5pt_reduction_last(G2tensor(13),RedSet_5(3),mass5set(:,2),  & 
G1tensor(73),G1tensor(74),G1tensor(75),G1tensor(76),G1tensor(77),G1tensor(78))
call G_TensorShift(G1tensor(74),16)
call Hotf_5pt_reduction_last(G2tensor(15),RedSet_5(4),mass5set(:,3),  & 
G1tensor(79),G1tensor(80),G1tensor(81),G1tensor(82),G1tensor(83),G1tensor(84))
call G_TensorShift(G1tensor(80),16)
call Hotf_5pt_reduction_last(G2tensor(17),RedSet_5(5),mass5set(:,2),  & 
G1tensor(85),G1tensor(86),G1tensor(87),G1tensor(88),G1tensor(89),G1tensor(90))
call G_TensorShift(G1tensor(86),16)
call Hotf_5pt_reduction_last(G2tensor(19),RedSet_5(6),mass5set(:,4),  & 
G1tensor(91),G1tensor(92),G1tensor(93),G1tensor(94),G1tensor(95),G1tensor(96))
call G_TensorShift(G1tensor(92),8)
call Hotf_5pt_reduction_last(G2tensor(21),RedSet_5(7),mass5set(:,3),  & 
G1tensor(97),G1tensor(98),G1tensor(99),G1tensor(100),G1tensor(101),G1tensor(102))
call G_TensorShift(G1tensor(98),16)
call Hotf_5pt_reduction_last(G2tensor(23),RedSet_5(8),mass5set(:,2),  & 
G1tensor(103),G1tensor(104),G1tensor(105),G1tensor(106),G1tensor(107),G1tensor(108))
call G_TensorShift(G1tensor(104),16)
call Hotf_5pt_reduction_last(G2tensor(25),RedSet_5(9),mass5set(:,2),  & 
G1tensor(109),G1tensor(110),G1tensor(111),G1tensor(112),G1tensor(113),G1tensor(114))
call G_TensorShift(G1tensor(110),16)
call Hotf_5pt_reduction_last(G2tensor(27),RedSet_5(10),mass5set(:,4),  & 
G1tensor(115),G1tensor(116),G1tensor(117),G1tensor(118),G1tensor(119),G1tensor(120))
call G_TensorShift(G1tensor(116),8)
call Hotf_5pt_reduction_last(G2tensor(29),RedSet_5(12),mass5set(:,3),  & 
G1tensor(121),G1tensor(122),G1tensor(123),G1tensor(124),G1tensor(125),G1tensor(126))
call G_TensorShift(G1tensor(122),16)
call Hotf_5pt_reduction_last(G2tensor(31),RedSet_5(13),mass5set(:,3),  & 
G1tensor(127),G1tensor(128),G1tensor(129),G1tensor(130),G1tensor(131),G1tensor(132))
call G_TensorShift(G1tensor(128),16)
call Hotf_5pt_reduction_last(G2tensor(33),RedSet_5(15),mass5set(:,6),  & 
G1tensor(133),G1tensor(134),G1tensor(135),G1tensor(136),G1tensor(137),G1tensor(138))
call G_TensorShift(G1tensor(134),8)
call Hotf_5pt_reduction_last(G2tensor(35),RedSet_5(16),mass5set(:,7),  & 
G1tensor(139),G1tensor(140),G1tensor(141),G1tensor(142),G1tensor(143),G1tensor(144))
call G_TensorShift(G1tensor(140),2)
call Hotf_5pt_reduction_last(G2tensor(37),RedSet_5(17),mass5set(:,6),  & 
G1tensor(145),G1tensor(146),G1tensor(147),G1tensor(148),G1tensor(149),G1tensor(150))
call G_TensorShift(G1tensor(146),8)
call Hotf_5pt_reduction_last(G2tensor(39),RedSet_5(18),mass5set(:,7),  & 
G1tensor(151),G1tensor(152),G1tensor(153),G1tensor(154),G1tensor(155),G1tensor(156))
call G_TensorShift(G1tensor(152),2)
call Hotf_5pt_reduction_last(G2tensor(41),RedSet_5(19),mass5set(:,8),  & 
G1tensor(157),G1tensor(158),G1tensor(159),G1tensor(160),G1tensor(161),G1tensor(162))
call G_TensorShift(G1tensor(158),2)
call Hotf_5pt_reduction_last(G2tensor(43),RedSet_5(20),mass5set(:,8),  & 
G1tensor(163),G1tensor(164),G1tensor(165),G1tensor(166),G1tensor(167),G1tensor(168))
call G_TensorShift(G1tensor(164),2)
call Hotf_5pt_reduction_last(G2tensor(45),RedSet_5(21),mass5set(:,9),  & 
G1tensor(169),G1tensor(170),G1tensor(171),G1tensor(172),G1tensor(173),G1tensor(174))
call G_TensorShift(G1tensor(170),16)
call Hotf_5pt_reduction_last(G2tensor(47),RedSet_5(22),mass5set(:,9),  & 
G1tensor(175),G1tensor(176),G1tensor(177),G1tensor(178),G1tensor(179),G1tensor(180))
call G_TensorShift(G1tensor(176),16)
call Hotf_5pt_reduction_last(G2tensor(49),RedSet_5(22),mass5set(:,9),  & 
G1tensor(181),G1tensor(182),G1tensor(183),G1tensor(184),G1tensor(185),G1tensor(186))
call G_TensorShift(G1tensor(182),8)
call Hotf_5pt_reduction_last(G2tensor(51),RedSet_5(23),mass5set(:,9),  & 
G1tensor(187),G1tensor(188),G1tensor(189),G1tensor(190),G1tensor(191),G1tensor(192))
call G_TensorShift(G1tensor(188),16)
call Hotf_5pt_reduction_last(G2tensor(53),RedSet_5(24),mass5set(:,9),  & 
G1tensor(193),G1tensor(194),G1tensor(195),G1tensor(196),G1tensor(197),G1tensor(198))
call G_TensorShift(G1tensor(194),16)
call Hotf_5pt_reduction_last(G2tensor(55),RedSet_5(24),mass5set(:,9),  & 
G1tensor(199),G1tensor(200),G1tensor(201),G1tensor(202),G1tensor(203),G1tensor(204))
call G_TensorShift(G1tensor(200),8)
call Hotf_5pt_reduction_last(G2tensor(57),RedSet_5(25),mass5set(:,10),  & 
G1tensor(205),G1tensor(206),G1tensor(207),G1tensor(208),G1tensor(209),G1tensor(210))
call G_TensorShift(G1tensor(206),16)
call Hotf_5pt_reduction_last(G2tensor(59),RedSet_5(26),mass5set(:,10),  & 
G1tensor(211),G1tensor(212),G1tensor(213),G1tensor(214),G1tensor(215),G1tensor(216))
call G_TensorShift(G1tensor(212),16)
call Hotf_5pt_reduction_last(G2tensor(61),RedSet_5(26),mass5set(:,10),  & 
G1tensor(217),G1tensor(218),G1tensor(219),G1tensor(220),G1tensor(221),G1tensor(222))
call G_TensorShift(G1tensor(218),2)
call Hotf_5pt_reduction_last(G2tensor(63),RedSet_5(27),mass5set(:,10),  & 
G1tensor(223),G1tensor(224),G1tensor(225),G1tensor(226),G1tensor(227),G1tensor(228))
call G_TensorShift(G1tensor(224),16)
call Hotf_5pt_reduction_last(G2tensor(65),RedSet_5(28),mass5set(:,10),  & 
G1tensor(229),G1tensor(230),G1tensor(231),G1tensor(232),G1tensor(233),G1tensor(234))
call G_TensorShift(G1tensor(230),16)
call Hotf_5pt_reduction_last(G2tensor(67),RedSet_5(28),mass5set(:,10),  & 
G1tensor(235),G1tensor(236),G1tensor(237),G1tensor(238),G1tensor(239),G1tensor(240))
call G_TensorShift(G1tensor(236),2)
call ol_merge_tensors(T1sum(1),[G1tensor(1)])
call ol_merge_tensors(T1sum(2),[G1tensor(7)])
call ol_merge_tensors(T1sum(3),[G1tensor(13)])
call ol_merge_tensors(T1sum(4),[G1tensor(19)])
call ol_merge_tensors(T1sum(5),[G1tensor(25)])
call ol_merge_tensors(T1sum(6),[G1tensor(31)])
call ol_merge_tensors(T1sum(7),[G1tensor(37)])
call ol_merge_tensors(T1sum(8),[G1tensor(43)])
call ol_merge_tensors(T1sum(9),[G1tensor(49)])
call ol_merge_tensors(T1sum(10),[G1tensor(55)])
call ol_merge_tensors(T1sum(11),[G1tensor(61)])
call ol_merge_tensors(T1sum(12),[G1tensor(67)])
call ol_merge_tensors(T1sum(13),[G1tensor(73)])
call ol_merge_tensors(T1sum(14),[G1tensor(79)])
call ol_merge_tensors(T1sum(15),[G1tensor(85)])
call ol_merge_tensors(T1sum(16),[G1tensor(91)])
call ol_merge_tensors(T1sum(17),[G1tensor(97)])
call ol_merge_tensors(T1sum(18),[G1tensor(103)])
call ol_merge_tensors(T1sum(19),[G1tensor(109)])
call ol_merge_tensors(T1sum(20),[G1tensor(115)])
call ol_merge_tensors(T1sum(21),[G1tensor(121)])
call ol_merge_tensors(T1sum(22),[G1tensor(127)])
call ol_merge_tensors(T1sum(23),[G1tensor(133)])
call ol_merge_tensors(T1sum(24),[G1tensor(139)])
call ol_merge_tensors(T1sum(25),[G1tensor(145)])
call ol_merge_tensors(T1sum(26),[G1tensor(151)])
call ol_merge_tensors(T1sum(27),[G1tensor(157)])
call ol_merge_tensors(T1sum(28),[G1tensor(163)])
call ol_merge_tensors(T1sum(29),[G1tensor(169)])
call ol_merge_tensors(T1sum(30),[G1tensor(175)])
call ol_merge_tensors(T1sum(31),[G1tensor(181)])
call ol_merge_tensors(T1sum(32),[G1tensor(187)])
call ol_merge_tensors(T1sum(33),[G1tensor(193)])
call ol_merge_tensors(T1sum(34),[G1tensor(199)])
call ol_merge_tensors(T1sum(35),[G1tensor(205)])
call ol_merge_tensors(T1sum(36),[G1tensor(211)])
call ol_merge_tensors(T1sum(37),[G1tensor(217)])
call ol_merge_tensors(T1sum(38),[G1tensor(223)])
call ol_merge_tensors(T1sum(39),[G1tensor(229)])
call ol_merge_tensors(T1sum(40),[G1tensor(235)])
Gcoeff(:)%j = (c(21)*(M(2,:)%j+M(3,:)%j-M(6,:)%j-M(11,:)%j)+c(24)*(-M(1,:)%j-M(4,:)%j+M(5,:)%j+M(12,:)%j))
call G0_hol_initialisation(ntry,Gcoeff,G0H64(1),m0h(41),h0tab(:,41),[48,2,1,4,8],[0,nMT,0,nMB,0],6,0)
  call Hloop_GGG_G_12(ntry,G0H64(1),ex6(:),ex5(:),G0H16(1),m4h2x2x16(:,1),heltab3x64(:,:,1))
Gcoeff(:)%j = (c(24)*(-M(1,:)%j-M(4,:)%j+M(8,:)%j+M(9,:)%j)+c(21)*(M(2,:)%j+M(3,:)%j-M(7,:)%j-M(10,:)%j))
call G0_hol_initialisation(ntry,Gcoeff,G0H64(1),m0h(42),h0tab(:,42),[48,2,1,4,8],[0,nMT,0,nMB,0],6,0)
  call Hloop_GGG_G_12(ntry,G0H64(1),ex5(:),ex6(:),G0H16(2),m4h2x2x16(:,2),heltab3x64(:,:,2))
Gcoeff(:)%j = (c(21)*(M(6,:)%j-M(7,:)%j-M(10,:)%j+M(11,:)%j)+c(24)*(-M(5,:)%j+M(8,:)%j+M(9,:)%j-M(12,:)%j))
call G0_hol_initialisation(ntry,Gcoeff,G0H64(1),m0h(43),h0tab(:,43),[48,2,1,4,8],[0,nMT,0,nMB,0],6,0)
  call Hloop_GGG_G_23(ntry,G0H64(1),ex6(:),ex5(:),G0H16(3),m4h2x2x16(:,3),heltab3x64(:,:,3))
Gcoeff(:)%j = (c(28)*M(6,:)%j+c(21)*(M(2,:)%j+M(3,:)%j-M(11,:)%j)+c(24)*M(13,:)%j)
call G0_hol_initialisation(ntry,Gcoeff,G0H64(1),m0h(44),h0tab(:,44),[48,2,1,8,4],[0,nMT,0,nMB,0],6,0)
  call Hloop_GGG_G_12(ntry,G0H64(1),ex6(:),ex5(:),G0H16(4),m4h2x2x16(:,4),heltab3x64(:,:,4))
Gcoeff(:)%j = (c(21)*(M(2,:)%j+M(3,:)%j-M(7,:)%j)+c(28)*M(10,:)%j+c(24)*M(13,:)%j)
call G0_hol_initialisation(ntry,Gcoeff,G0H64(1),m0h(45),h0tab(:,45),[48,2,1,8,4],[0,nMT,0,nMB,0],6,0)
  call Hloop_GGG_G_12(ntry,G0H64(1),ex5(:),ex6(:),G0H16(5),m4h2x2x16(:,5),heltab3x64(:,:,5))
Gcoeff(:)%j = (c(28)*(-M(6,:)%j+M(10,:)%j)+c(21)*(-M(7,:)%j+M(11,:)%j))
call G0_hol_initialisation(ntry,Gcoeff,G0H64(1),m0h(46),h0tab(:,46),[48,2,1,8,4],[0,nMT,0,nMB,0],6,0)
  call Hloop_GGG_G_23(ntry,G0H64(1),ex6(:),ex5(:),G0H16(6),m4h2x2x16(:,6),heltab3x64(:,:,6))
Gcoeff(:)%j = (c(21)*(M(2,:)%j+M(3,:)%j-M(6,:)%j)+c(28)*M(11,:)%j+c(24)*M(13,:)%j)
call G0_hol_initialisation(ntry,Gcoeff,G0H64(1),m0h(47),h0tab(:,47),[48,1,2,4,8],[0,nMT,0,nMB,0],6,0)
  call Hloop_GGG_G_12(ntry,G0H64(1),ex6(:),ex5(:),G0H16(7),m4h2x2x16(:,7),heltab3x64(:,:,7))
Gcoeff(:)%j = (c(28)*M(7,:)%j+c(21)*(M(2,:)%j+M(3,:)%j-M(10,:)%j)+c(24)*M(13,:)%j)
call G0_hol_initialisation(ntry,Gcoeff,G0H64(1),m0h(48),h0tab(:,48),[48,1,2,4,8],[0,nMT,0,nMB,0],6,0)
  call Hloop_GGG_G_12(ntry,G0H64(1),ex5(:),ex6(:),G0H16(8),m4h2x2x16(:,8),heltab3x64(:,:,8))
Gcoeff(:)%j = (c(21)*(M(6,:)%j-M(10,:)%j)+c(28)*(M(7,:)%j-M(11,:)%j))
call G0_hol_initialisation(ntry,Gcoeff,G0H64(1),m0h(49),h0tab(:,49),[48,1,2,4,8],[0,nMT,0,nMB,0],6,0)
  call Hloop_GGG_G_23(ntry,G0H64(1),ex6(:),ex5(:),G0H16(9),m4h2x2x16(:,9),heltab3x64(:,:,9))
Gcoeff(:)%j = (c(24)*(-M(1,:)%j-M(4,:)%j+M(8,:)%j+M(9,:)%j)+c(21)*(M(2,:)%j+M(3,:)%j-M(6,:)%j-M(11,:)%j))
call G0_hol_initialisation(ntry,Gcoeff,G0H64(1),m0h(50),h0tab(:,50),[48,1,2,8,4],[0,nMT,0,nMB,0],6,0)
  call Hloop_GGG_G_12(ntry,G0H64(1),ex6(:),ex5(:),G0H16(10),m4h2x2x16(:,10),heltab3x64(:,:,10))
Gcoeff(:)%j = (c(21)*(M(2,:)%j+M(3,:)%j-M(7,:)%j-M(10,:)%j)+c(24)*(-M(1,:)%j-M(4,:)%j+M(5,:)%j+M(12,:)%j))
call G0_hol_initialisation(ntry,Gcoeff,G0H64(1),m0h(51),h0tab(:,51),[48,1,2,8,4],[0,nMT,0,nMB,0],6,0)
  call Hloop_GGG_G_12(ntry,G0H64(1),ex5(:),ex6(:),G0H16(11),m4h2x2x16(:,11),heltab3x64(:,:,11))
Gcoeff(:)%j = (c(21)*(M(6,:)%j-M(7,:)%j-M(10,:)%j+M(11,:)%j)+c(24)*(M(5,:)%j-M(8,:)%j-M(9,:)%j+M(12,:)%j))
call G0_hol_initialisation(ntry,Gcoeff,G0H64(1),m0h(52),h0tab(:,52),[48,1,2,8,4],[0,nMT,0,nMB,0],6,0)
  call Hloop_GGG_G_23(ntry,G0H64(1),ex6(:),ex5(:),G0H16(12),m4h2x2x16(:,12),heltab3x64(:,:,12))
Gcoeff(:)%j = (c(24)*M(5,:)%j+c(20)*M(12,:)%j+c(21)*(-M(3,:)%j-M(14,:)%j)) * den(1)
call G0_hol_initialisation(ntry,Gcoeff,G0H64(1),m0h(53),h0tab(:,53),[32,3,16,4,8],[nMB,nMB,nMB,0,nMB],5,1,wf4(:,1))
  call Hloop_AV_Q(ntry,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,41),heltab2x64(:,:,41))
  call Hloop_A_Q(ntry,G0H32(1),32,nMB,G1H32(1),n2h32(21))
Gcoeff(:)%j = (-(c(14)*M(3,:)%j)+c(9)*(-M(1,:)%j-M(4,:)%j+M(9,:)%j+M(12,:)%j-M(13,:)%j)) * den(1)
call G0_hol_initialisation(ntry,Gcoeff,G0H64(1),m0h(54),h0tab(:,54),[32,3,16,4,8],[0,0,0,nMB,0],5,1,wf4(:,1))
  call Hloop_UV_W(ntry,G0H64(1),0,ex6(:),32,G1H32(2),m3h2x32(:,42),heltab2x64(:,:,42))
Gcoeff(:)%j = (c(24)*M(9,:)%j+c(20)*M(12,:)%j+c(21)*(-M(10,:)%j-M(14,:)%j)) * den(1)
call G0_hol_initialisation(ntry,Gcoeff,G0H64(1),m0h(55),h0tab(:,55),[32,3,8,4,16],[nMB,nMB,0,nMB,nMB],5,1,wf4(:,1))
  call Hloop_QV_A(ntry,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,43),heltab2x64(:,:,43))
  call Hloop_Q_A(ntry,G0H32(1),32,nMB,G1H32(3),n2h32(22))
Gcoeff(:)%j = (c(14)*M(10,:)%j+c(9)*(M(1,:)%j+M(4,:)%j-M(5,:)%j-M(12,:)%j+M(13,:)%j)) * den(1)
call G0_hol_initialisation(ntry,Gcoeff,G0H64(1),m0h(56),h0tab(:,56),[32,3,8,4,16],[0,0,nMB,0,0],5,1,wf4(:,1))
  call Hloop_UV_W(ntry,G0H64(1),0,ex6(:),32,G1H32(4),m3h2x32(:,44),heltab2x64(:,:,44))
Gcoeff(:)%j = (c(20)*M(8,:)%j+c(24)*M(9,:)%j+c(21)*(-M(2,:)%j-M(14,:)%j)) * den(1)
call G0_hol_initialisation(ntry,Gcoeff,G0H64(1),m0h(57),h0tab(:,57),[32,3,16,8,4],[nMB,nMB,nMB,0,nMB],5,1,wf4(:,1))
  call Hloop_QV_A(ntry,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,45),heltab2x64(:,:,45))
  call Hloop_Q_A(ntry,G0H32(1),32,nMB,G1H32(5),n2h32(23))
Gcoeff(:)%j = (c(14)*M(2,:)%j+c(9)*(M(1,:)%j+M(4,:)%j-M(5,:)%j-M(8,:)%j+M(13,:)%j)) * den(1)
call G0_hol_initialisation(ntry,Gcoeff,G0H64(1),m0h(58),h0tab(:,58),[32,3,16,8,4],[0,0,0,nMB,0],5,1,wf4(:,1))
  call Hloop_UV_W(ntry,G0H64(1),0,ex6(:),32,G1H32(6),m3h2x32(:,46),heltab2x64(:,:,46))
Gcoeff(:)%j = (c(24)*M(5,:)%j+c(20)*M(8,:)%j+c(21)*(-M(6,:)%j-M(14,:)%j)) * den(1)
call G0_hol_initialisation(ntry,Gcoeff,G0H64(1),m0h(59),h0tab(:,59),[32,4,8,3,16],[nMB,0,nMB,nMB,nMB],5,1,wf4(:,1))
  call Hloop_AV_Q(ntry,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,47),heltab2x64(:,:,47))
  call Hloop_A_Q(ntry,G0H32(1),32,nMB,G1H32(7),n2h32(24))
Gcoeff(:)%j = (-(c(14)*M(6,:)%j)+c(9)*(-M(1,:)%j-M(4,:)%j+M(8,:)%j+M(9,:)%j-M(13,:)%j)) * den(1)
call G0_hol_initialisation(ntry,Gcoeff,G0H64(1),m0h(60),h0tab(:,60),[32,4,8,3,16],[0,nMB,0,0,0],5,1,wf4(:,1))
  call Hloop_UV_W(ntry,G0H64(1),0,ex6(:),32,G1H32(8),m3h2x32(:,48),heltab2x64(:,:,48))
Gcoeff(:)%j = (c(24)*M(5,:)%j+c(20)*M(8,:)%j+c(21)*(-M(7,:)%j-M(14,:)%j)) * den(1)
call G0_hol_initialisation(ntry,Gcoeff,G0H64(1),m0h(61),h0tab(:,61),[32,3,4,8,16],[nMB,nMB,0,nMB,nMB],5,1,wf4(:,1))
  call Hloop_AV_Q(ntry,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,49),heltab2x64(:,:,49))
  call Hloop_A_Q(ntry,G0H32(1),32,nMB,G1H32(9),n2h32(25))
Gcoeff(:)%j = (-(c(14)*M(7,:)%j)+c(9)*(-M(1,:)%j-M(4,:)%j+M(8,:)%j+M(9,:)%j-M(13,:)%j)) * den(1)
call G0_hol_initialisation(ntry,Gcoeff,G0H64(1),m0h(62),h0tab(:,62),[32,3,4,8,16],[0,0,nMB,0,0],5,1,wf4(:,1))
  call Hloop_UV_W(ntry,G0H64(1),0,ex6(:),32,G1H32(10),m3h2x32(:,50),heltab2x64(:,:,50))
Gcoeff(:)%j = (c(24)*M(9,:)%j+c(20)*M(12,:)%j+c(21)*(-M(11,:)%j-M(14,:)%j)) * den(1)
call G0_hol_initialisation(ntry,Gcoeff,G0H64(1),m0h(63),h0tab(:,63),[32,8,4,3,16],[nMB,0,nMB,nMB,nMB],5,1,wf4(:,1))
  call Hloop_QV_A(ntry,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,51),heltab2x64(:,:,51))
  call Hloop_Q_A(ntry,G0H32(1),32,nMB,G1H32(11),n2h32(26))
Gcoeff(:)%j = (c(14)*M(11,:)%j+c(9)*(M(1,:)%j+M(4,:)%j-M(5,:)%j-M(12,:)%j+M(13,:)%j)) * den(1)
call G0_hol_initialisation(ntry,Gcoeff,G0H64(1),m0h(64),h0tab(:,64),[32,8,4,3,16],[0,nMB,0,0,0],5,1,wf4(:,1))
  call Hloop_UV_W(ntry,G0H64(1),0,ex6(:),32,G1H32(12),m3h2x32(:,52),heltab2x64(:,:,52))
Gcoeff(:)%j = (c(9)*(-M(1,:)%j+M(9,:)%j)-c(6)*M(14,:)%j) * den(1)
call G0_hol_initialisation(ntry,Gcoeff,G0H64(1),m0h(65),h0tab(:,65),[32,3,8,16,4],[nMB,nMB,0,0,nMB],5,1,wf4(:,1))
  call Hloop_QV_A(ntry,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,53),heltab2x64(:,:,53))
  call Hloop_Q_A(ntry,G0H32(1),32,nMB,G1H32(13),n2h32(27))
Gcoeff(:)%j = (c(24)*(-M(4,:)%j+M(5,:)%j-M(13,:)%j)) * den(1)
call G0_hol_initialisation(ntry,Gcoeff,G0H64(1),m0h(66),h0tab(:,66),[32,3,8,16,4],[0,0,nMB,nMB,0],5,1,wf4(:,1))
  call Hloop_UV_W(ntry,G0H64(1),0,ex6(:),32,G1H32(14),m3h2x32(:,54),heltab2x64(:,:,54))
Gcoeff(:)%j = (c(9)*(-M(4,:)%j+M(5,:)%j)-c(6)*M(14,:)%j) * den(1)
call G0_hol_initialisation(ntry,Gcoeff,G0H64(1),m0h(67),h0tab(:,67),[32,4,16,3,8],[0,nMB,nMB,nMB,0],5,1,wf4(:,1))
  call Hloop_UV_W(ntry,G0H64(1),0,ex6(:),32,G1H32(15),m3h2x32(:,55),heltab2x64(:,:,55))
Gcoeff(:)%j = (c(24)*(-M(1,:)%j+M(9,:)%j-M(13,:)%j)) * den(1)
call G0_hol_initialisation(ntry,Gcoeff,G0H64(1),m0h(68),h0tab(:,68),[32,4,16,3,8],[nMB,0,0,0,nMB],5,1,wf4(:,1))
  call Hloop_AV_Q(ntry,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,56),heltab2x64(:,:,56))
  call Hloop_A_Q(ntry,G0H32(1),32,nMB,G1H32(16),n2h32(28))
Gcoeff(:)%j = (c(9)*(M(1,:)%j-M(5,:)%j)+c(6)*M(14,:)%j) * den(1)
call G0_hol_initialisation(ntry,Gcoeff,G0H64(1),m0h(69),h0tab(:,69),[32,3,4,16,8],[nMB,nMB,0,0,nMB],5,1,wf4(:,1))
  call Hloop_AV_Q(ntry,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,57),heltab2x64(:,:,57))
  call Hloop_A_Q(ntry,G0H32(1),32,nMB,G1H32(17),n2h32(29))
Gcoeff(:)%j = (c(24)*(-M(4,:)%j+M(9,:)%j-M(13,:)%j)) * den(1)
call G0_hol_initialisation(ntry,Gcoeff,G0H64(1),m0h(70),h0tab(:,70),[32,3,4,16,8],[0,0,nMB,nMB,0],5,1,wf4(:,1))
  call Hloop_UV_W(ntry,G0H64(1),0,ex6(:),32,G1H32(18),m3h2x32(:,58),heltab2x64(:,:,58))
Gcoeff(:)%j = (c(9)*(M(9,:)%j-M(13,:)%j)) * den(1)
call G0_hol_initialisation(ntry,Gcoeff,G0H64(1),m0h(71),h0tab(:,71),[32,8,3,4,16],[nMB,0,0,nMB,nMB],5,1,wf4(:,1))
  call Hloop_QV_A(ntry,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,59),heltab2x64(:,:,59))
  call Hloop_Q_A(ntry,G0H32(1),32,nMB,G1H32(19),n2h32(30))
Gcoeff(:)%j = (c(24)*(-M(1,:)%j-M(4,:)%j+M(5,:)%j)-c(21)*M(14,:)%j) * den(1)
call G0_hol_initialisation(ntry,Gcoeff,G0H64(1),m0h(72),h0tab(:,72),[32,8,3,4,16],[0,nMB,nMB,0,0],5,1,wf4(:,1))
  call Hloop_UV_W(ntry,G0H64(1),0,ex6(:),32,G1H32(20),m3h2x32(:,60),heltab2x64(:,:,60))
Gcoeff(:)%j = (c(9)*(-M(4,:)%j+M(9,:)%j)-c(6)*M(14,:)%j) * den(1)
call G0_hol_initialisation(ntry,Gcoeff,G0H64(1),m0h(73),h0tab(:,73),[32,4,3,16,8],[0,nMB,nMB,nMB,0],5,1,wf4(:,1))
  call Hloop_UV_W(ntry,G0H64(1),0,ex6(:),32,G1H32(21),m3h2x32(:,61),heltab2x64(:,:,61))
Gcoeff(:)%j = (c(24)*(-M(1,:)%j+M(5,:)%j-M(13,:)%j)) * den(1)
call G0_hol_initialisation(ntry,Gcoeff,G0H64(1),m0h(74),h0tab(:,74),[32,4,3,16,8],[nMB,0,0,0,nMB],5,1,wf4(:,1))
  call Hloop_AV_Q(ntry,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,62),heltab2x64(:,:,62))
  call Hloop_A_Q(ntry,G0H32(1),32,nMB,G1H32(22),n2h32(31))
Gcoeff(:)%j = (c(9)*(-M(5,:)%j+M(13,:)%j)) * den(1)
call G0_hol_initialisation(ntry,Gcoeff,G0H64(1),m0h(75),h0tab(:,75),[32,4,3,8,16],[nMB,0,0,nMB,nMB],5,1,wf4(:,1))
  call Hloop_AV_Q(ntry,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,63),heltab2x64(:,:,63))
  call Hloop_A_Q(ntry,G0H32(1),32,nMB,G1H32(23),n2h32(32))
Gcoeff(:)%j = (c(24)*(-M(1,:)%j-M(4,:)%j+M(9,:)%j)-c(21)*M(14,:)%j) * den(1)
call G0_hol_initialisation(ntry,Gcoeff,G0H64(1),m0h(76),h0tab(:,76),[32,4,3,8,16],[0,nMB,nMB,0,0],5,1,wf4(:,1))
  call Hloop_UV_W(ntry,G0H64(1),0,ex6(:),32,G1H32(24),m3h2x32(:,64),heltab2x64(:,:,64))
Gcoeff(:)%j = (c(24)*M(8,:)%j+c(20)*M(9,:)%j+c(21)*(-M(2,:)%j-M(14,:)%j)) * den(2)
call G0_hol_initialisation(ntry,Gcoeff,G0H64(1),m0h(77),h0tab(:,77),[32,2,1,16,12],[nMT,0,nMT,nMT,nMT],5,1,wf4(:,2))
  call Hloop_QV_A(ntry,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,65),heltab2x64(:,:,65))
  call Hloop_Q_A(ntry,G0H32(1),32,nMT,G1H32(25),n2h32(33))
Gcoeff(:)%j = (c(14)*M(2,:)%j+c(9)*(M(1,:)%j+M(4,:)%j-M(9,:)%j-M(12,:)%j+M(13,:)%j)) * den(2)
call G0_hol_initialisation(ntry,Gcoeff,G0H64(1),m0h(78),h0tab(:,78),[32,2,1,16,12],[0,nMT,0,0,0],5,1,wf4(:,2))
  call Hloop_UV_W(ntry,G0H64(1),0,ex6(:),32,G1H32(26),m3h2x32(:,66),heltab2x64(:,:,66))
Gcoeff(:)%j = (c(20)*M(9,:)%j+c(24)*M(12,:)%j+c(21)*(-M(11,:)%j-M(14,:)%j)) * den(2)
call G0_hol_initialisation(ntry,Gcoeff,G0H64(1),m0h(79),h0tab(:,79),[32,12,2,1,16],[nMT,nMT,0,nMT,nMT],5,1,wf4(:,2))
  call Hloop_QV_A(ntry,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,67),heltab2x64(:,:,67))
  call Hloop_Q_A(ntry,G0H32(1),32,nMT,G1H32(27),n2h32(34))
Gcoeff(:)%j = (c(14)*M(11,:)%j+c(9)*(M(1,:)%j+M(4,:)%j-M(8,:)%j-M(9,:)%j+M(13,:)%j)) * den(2)
call G0_hol_initialisation(ntry,Gcoeff,G0H64(1),m0h(80),h0tab(:,80),[32,12,2,1,16],[0,0,nMT,0,0],5,1,wf4(:,2))
  call Hloop_UV_W(ntry,G0H64(1),0,ex6(:),32,G1H32(28),m3h2x32(:,68),heltab2x64(:,:,68))
Gcoeff(:)%j = (c(20)*M(5,:)%j+c(24)*M(12,:)%j+c(21)*(-M(3,:)%j-M(14,:)%j)) * den(2)
call G0_hol_initialisation(ntry,Gcoeff,G0H64(1),m0h(81),h0tab(:,81),[32,1,2,16,12],[nMT,0,nMT,nMT,nMT],5,1,wf4(:,2))
  call Hloop_AV_Q(ntry,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,69),heltab2x64(:,:,69))
  call Hloop_A_Q(ntry,G0H32(1),32,nMT,G1H32(29),n2h32(35))
Gcoeff(:)%j = (-(c(14)*M(3,:)%j)+c(9)*(-M(1,:)%j-M(4,:)%j+M(5,:)%j+M(8,:)%j-M(13,:)%j)) * den(2)
call G0_hol_initialisation(ntry,Gcoeff,G0H64(1),m0h(82),h0tab(:,82),[32,1,2,16,12],[0,nMT,0,0,0],5,1,wf4(:,2))
  call Hloop_UV_W(ntry,G0H64(1),0,ex6(:),32,G1H32(30),m3h2x32(:,70),heltab2x64(:,:,70))
Gcoeff(:)%j = (c(20)*M(5,:)%j+c(24)*M(8,:)%j+c(21)*(-M(7,:)%j-M(14,:)%j)) * den(2)
call G0_hol_initialisation(ntry,Gcoeff,G0H64(1),m0h(83),h0tab(:,83),[32,1,2,12,16],[nMT,0,nMT,nMT,nMT],5,1,wf4(:,2))
  call Hloop_AV_Q(ntry,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,71),heltab2x64(:,:,71))
  call Hloop_A_Q(ntry,G0H32(1),32,nMT,G1H32(31),n2h32(36))
Gcoeff(:)%j = (-(c(14)*M(7,:)%j)+c(9)*(-M(1,:)%j-M(4,:)%j+M(5,:)%j+M(12,:)%j-M(13,:)%j)) * den(2)
call G0_hol_initialisation(ntry,Gcoeff,G0H64(1),m0h(84),h0tab(:,84),[32,1,2,12,16],[0,nMT,0,0,0],5,1,wf4(:,2))
  call Hloop_UV_W(ntry,G0H64(1),0,ex6(:),32,G1H32(32),m3h2x32(:,72),heltab2x64(:,:,72))
Gcoeff(:)%j = (c(20)*M(5,:)%j+c(24)*M(8,:)%j+c(21)*(-M(6,:)%j-M(14,:)%j)) * den(2)
call G0_hol_initialisation(ntry,Gcoeff,G0H64(1),m0h(85),h0tab(:,85),[32,12,1,2,16],[nMT,nMT,0,nMT,nMT],5,1,wf4(:,2))
  call Hloop_AV_Q(ntry,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,73),heltab2x64(:,:,73))
  call Hloop_A_Q(ntry,G0H32(1),32,nMT,G1H32(33),n2h32(37))
Gcoeff(:)%j = (-(c(14)*M(6,:)%j)+c(9)*(-M(1,:)%j-M(4,:)%j+M(5,:)%j+M(12,:)%j-M(13,:)%j)) * den(2)
call G0_hol_initialisation(ntry,Gcoeff,G0H64(1),m0h(86),h0tab(:,86),[32,12,1,2,16],[0,0,nMT,0,0],5,1,wf4(:,2))
  call Hloop_UV_W(ntry,G0H64(1),0,ex6(:),32,G1H32(34),m3h2x32(:,74),heltab2x64(:,:,74))
Gcoeff(:)%j = (c(20)*M(9,:)%j+c(24)*M(12,:)%j+c(21)*(-M(10,:)%j-M(14,:)%j)) * den(2)
call G0_hol_initialisation(ntry,Gcoeff,G0H64(1),m0h(87),h0tab(:,87),[32,2,1,12,16],[nMT,0,nMT,nMT,nMT],5,1,wf4(:,2))
  call Hloop_QV_A(ntry,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,75),heltab2x64(:,:,75))
  call Hloop_Q_A(ntry,G0H32(1),32,nMT,G1H32(35),n2h32(38))
Gcoeff(:)%j = (c(14)*M(10,:)%j+c(9)*(M(1,:)%j+M(4,:)%j-M(8,:)%j-M(9,:)%j+M(13,:)%j)) * den(2)
call G0_hol_initialisation(ntry,Gcoeff,G0H64(1),m0h(88),h0tab(:,88),[32,2,1,12,16],[0,nMT,0,0,0],5,1,wf4(:,2))
  call Hloop_UV_W(ntry,G0H64(1),0,ex6(:),32,G1H32(36),m3h2x32(:,76),heltab2x64(:,:,76))
Gcoeff(:)%j = (c(9)*(M(4,:)%j-M(12,:)%j)+c(6)*M(14,:)%j) * den(2)
call G0_hol_initialisation(ntry,Gcoeff,G0H64(1),m0h(89),h0tab(:,89),[32,1,16,2,12],[nMT,0,0,nMT,nMT],5,1,wf4(:,2))
  call Hloop_AV_Q(ntry,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,77),heltab2x64(:,:,77))
  call Hloop_A_Q(ntry,G0H32(1),32,nMT,G1H32(37),n2h32(39))
Gcoeff(:)%j = (c(24)*(-M(1,:)%j+M(8,:)%j-M(13,:)%j)) * den(2)
call G0_hol_initialisation(ntry,Gcoeff,G0H64(1),m0h(90),h0tab(:,90),[32,1,16,2,12],[0,nMT,nMT,0,0],5,1,wf4(:,2))
  call Hloop_UV_W(ntry,G0H64(1),0,ex6(:),32,G1H32(38),m3h2x32(:,78),heltab2x64(:,:,78))
Gcoeff(:)%j = (c(9)*(-M(1,:)%j+M(8,:)%j)-c(6)*M(14,:)%j) * den(2)
call G0_hol_initialisation(ntry,Gcoeff,G0H64(1),m0h(91),h0tab(:,91),[32,1,16,12,2],[0,nMT,nMT,nMT,0],5,1,wf4(:,2))
  call Hloop_UV_W(ntry,G0H64(1),0,ex6(:),32,G1H32(39),m3h2x32(:,79),heltab2x64(:,:,79))
Gcoeff(:)%j = (c(24)*(-M(4,:)%j+M(12,:)%j-M(13,:)%j)) * den(2)
call G0_hol_initialisation(ntry,Gcoeff,G0H64(1),m0h(92),h0tab(:,92),[32,1,16,12,2],[nMT,0,0,0,nMT],5,1,wf4(:,2))
  call Hloop_AV_Q(ntry,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,80),heltab2x64(:,:,80))
  call Hloop_A_Q(ntry,G0H32(1),32,nMT,G1H32(40),n2h32(40))
Gcoeff(:)%j = (c(9)*(-M(4,:)%j+M(8,:)%j)-c(6)*M(14,:)%j) * den(2)
call G0_hol_initialisation(ntry,Gcoeff,G0H64(1),m0h(93),h0tab(:,93),[32,2,16,1,12],[nMT,0,0,nMT,nMT],5,1,wf4(:,2))
  call Hloop_QV_A(ntry,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,81),heltab2x64(:,:,81))
  call Hloop_Q_A(ntry,G0H32(1),32,nMT,G1H32(41),n2h32(41))
Gcoeff(:)%j = (c(24)*(-M(1,:)%j+M(12,:)%j-M(13,:)%j)) * den(2)
call G0_hol_initialisation(ntry,Gcoeff,G0H64(1),m0h(94),h0tab(:,94),[32,2,16,1,12],[0,nMT,nMT,0,0],5,1,wf4(:,2))
  call Hloop_UV_W(ntry,G0H64(1),0,ex6(:),32,G1H32(42),m3h2x32(:,82),heltab2x64(:,:,82))
Gcoeff(:)%j = (c(9)*(M(12,:)%j-M(13,:)%j)) * den(2)
call G0_hol_initialisation(ntry,Gcoeff,G0H64(1),m0h(95),h0tab(:,95),[32,2,12,1,16],[nMT,0,0,nMT,nMT],5,1,wf4(:,2))
  call Hloop_QV_A(ntry,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,83),heltab2x64(:,:,83))
  call Hloop_Q_A(ntry,G0H32(1),32,nMT,G1H32(43),n2h32(42))
Gcoeff(:)%j = (c(24)*(-M(1,:)%j-M(4,:)%j+M(8,:)%j)-c(21)*M(14,:)%j) * den(2)
call G0_hol_initialisation(ntry,Gcoeff,G0H64(1),m0h(96),h0tab(:,96),[32,2,12,1,16],[0,nMT,nMT,0,0],5,1,wf4(:,2))
  call Hloop_UV_W(ntry,G0H64(1),0,ex6(:),32,G1H32(44),m3h2x32(:,84),heltab2x64(:,:,84))
Gcoeff(:)%j = (c(9)*(-M(1,:)%j+M(12,:)%j)-c(6)*M(14,:)%j) * den(2)
call G0_hol_initialisation(ntry,Gcoeff,G0H64(1),m0h(97),h0tab(:,97),[32,1,12,16,2],[0,nMT,nMT,nMT,0],5,1,wf4(:,2))
  call Hloop_UV_W(ntry,G0H64(1),0,ex6(:),32,G1H32(45),m3h2x32(:,85),heltab2x64(:,:,85))
Gcoeff(:)%j = (c(24)*(-M(4,:)%j+M(8,:)%j-M(13,:)%j)) * den(2)
call G0_hol_initialisation(ntry,Gcoeff,G0H64(1),m0h(98),h0tab(:,98),[32,1,12,16,2],[nMT,0,0,0,nMT],5,1,wf4(:,2))
  call Hloop_AV_Q(ntry,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,86),heltab2x64(:,:,86))
  call Hloop_A_Q(ntry,G0H32(1),32,nMT,G1H32(46),n2h32(43))
Gcoeff(:)%j = (c(9)*(-M(8,:)%j+M(13,:)%j)) * den(2)
call G0_hol_initialisation(ntry,Gcoeff,G0H64(1),m0h(99),h0tab(:,99),[32,1,12,2,16],[nMT,0,0,nMT,nMT],5,1,wf4(:,2))
  call Hloop_AV_Q(ntry,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,87),heltab2x64(:,:,87))
  call Hloop_A_Q(ntry,G0H32(1),32,nMT,G1H32(47),n2h32(44))
Gcoeff(:)%j = (c(24)*(-M(1,:)%j-M(4,:)%j+M(12,:)%j)-c(21)*M(14,:)%j) * den(2)
call G0_hol_initialisation(ntry,Gcoeff,G0H64(1),m0h(100),h0tab(:,100),[32,1,12,2,16],[0,nMT,nMT,0,0],5,1,wf4(:,2))
  call Hloop_UV_W(ntry,G0H64(1),0,ex6(:),32,G1H32(48),m3h2x32(:,88),heltab2x64(:,:,88))
Gcoeff(:)%j = (c(20)*M(9,:)%j+c(21)*(-M(2,:)%j-M(11,:)%j)) * den(41)
call G0_hol_initialisation(ntry,Gcoeff,G0H64(1),m0h(101),h0tab(:,101),[32,2,4,8,17],[nMT,0,nMB,0,nMT],5,1,wf4(:,14))
  call Hloop_QV_A(ntry,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,89),heltab2x64(:,:,89))
  call Hloop_Q_A(ntry,G0H32(1),32,nMT,G1H32(49),n2h32(45))
Gcoeff(:)%j = (c(6)*M(2,:)%j+c(13)*M(11,:)%j) * den(41)
call G0_hol_initialisation(ntry,Gcoeff,G0H64(1),m0h(102),h0tab(:,102),[32,8,4,2,17],[0,nMB,0,nMT,0],5,1,wf4(:,14))
  call Hloop_UV_W(ntry,G0H64(1),0,ex6(:),32,G1H32(50),m3h2x32(:,90),heltab2x64(:,:,90))
Gcoeff(:)%j = (c(20)*M(4,:)%j+c(21)*(-M(2,:)%j-M(11,:)%j)) * den(41)
call G0_hol_initialisation(ntry,Gcoeff,G0H64(1),m0h(103),h0tab(:,103),[32,4,2,17,8],[nMB,0,nMT,0,nMB],5,1,wf4(:,14))
  call Hloop_AV_Q(ntry,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,91),heltab2x64(:,:,91))
  call Hloop_A_Q(ntry,G0H32(1),32,nMB,G1H32(51),n2h32(46))
Gcoeff(:)%j = (c(24)*M(4,:)%j+c(20)*M(9,:)%j+c(21)*(-M(2,:)%j-M(11,:)%j)) * den(41)
call G0_hol_initialisation(ntry,Gcoeff,G0H64(1),m0h(104),h0tab(:,104),[32,2,8,4,17],[nMT,0,nMB,0,nMT],5,1,wf4(:,14))
  call Hloop_QV_A(ntry,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,92),heltab2x64(:,:,92))
  call Hloop_Q_A(ntry,G0H32(1),32,nMT,G1H32(52),n2h32(47))
Gcoeff(:)%j = (c(9)*(-M(4,:)%j+M(9,:)%j)+c(6)*(M(2,:)%j-M(11,:)%j)) * den(41)
call G0_hol_initialisation(ntry,Gcoeff,G0H64(1),m0h(105),h0tab(:,105),[32,4,8,2,17],[0,nMB,0,nMT,0],5,1,wf4(:,14))
  call Hloop_UV_W(ntry,G0H64(1),0,ex6(:),32,G1H32(53),m3h2x32(:,93),heltab2x64(:,:,93))
Gcoeff(:)%j = (c(20)*M(4,:)%j+c(24)*M(9,:)%j+c(21)*(-M(2,:)%j-M(11,:)%j)) * den(41)
call G0_hol_initialisation(ntry,Gcoeff,G0H64(1),m0h(106),h0tab(:,106),[32,4,17,2,8],[nMB,0,nMT,0,nMB],5,1,wf4(:,14))
  call Hloop_AV_Q(ntry,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,94),heltab2x64(:,:,94))
  call Hloop_A_Q(ntry,G0H32(1),32,nMB,G1H32(54),n2h32(48))
Gcoeff(:)%j = (c(13)*M(2,:)%j+c(6)*M(11,:)%j) * den(41)
call G0_hol_initialisation(ntry,Gcoeff,G0H64(1),m0h(107),h0tab(:,107),[32,2,17,8,4],[0,nMT,0,nMB,0],5,1,wf4(:,14))
  call Hloop_UV_W(ntry,G0H64(1),0,ex6(:),32,G1H32(55),m3h2x32(:,95),heltab2x64(:,:,95))
Gcoeff(:)%j = (c(9)*(-M(4,:)%j+M(9,:)%j)+c(6)*(-M(2,:)%j+M(11,:)%j)) * den(41)
call G0_hol_initialisation(ntry,Gcoeff,G0H64(1),m0h(108),h0tab(:,108),[32,2,17,4,8],[0,nMT,0,nMB,0],5,1,wf4(:,14))
  call Hloop_UV_W(ntry,G0H64(1),0,ex6(:),32,G1H32(56),m3h2x32(:,96),heltab2x64(:,:,96))
Gcoeff(:)%j = (c(24)*M(4,:)%j+c(20)*M(5,:)%j+c(21)*(-M(3,:)%j-M(6,:)%j)) * den(51)
call G0_hol_initialisation(ntry,Gcoeff,G0H64(1),m0h(109),h0tab(:,109),[32,1,4,8,18],[nMT,0,nMB,0,nMT],5,1,wf4(:,19))
  call Hloop_AV_Q(ntry,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,97),heltab2x64(:,:,97))
  call Hloop_A_Q(ntry,G0H32(1),32,nMT,G1H32(57),n2h32(49))
Gcoeff(:)%j = (c(9)*(M(4,:)%j-M(5,:)%j)+c(6)*(-M(3,:)%j+M(6,:)%j)) * den(51)
call G0_hol_initialisation(ntry,Gcoeff,G0H64(1),m0h(110),h0tab(:,110),[32,8,4,1,18],[0,nMB,0,nMT,0],5,1,wf4(:,19))
  call Hloop_UV_W(ntry,G0H64(1),0,ex6(:),32,G1H32(58),m3h2x32(:,98),heltab2x64(:,:,98))
Gcoeff(:)%j = (c(20)*M(4,:)%j+c(24)*M(5,:)%j+c(21)*(-M(3,:)%j-M(6,:)%j)) * den(51)
call G0_hol_initialisation(ntry,Gcoeff,G0H64(1),m0h(111),h0tab(:,111),[32,4,1,18,8],[nMB,0,nMT,0,nMB],5,1,wf4(:,19))
  call Hloop_AV_Q(ntry,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,99),heltab2x64(:,:,99))
  call Hloop_A_Q(ntry,G0H32(1),32,nMB,G1H32(59),n2h32(50))
Gcoeff(:)%j = (c(20)*M(5,:)%j+c(21)*(-M(3,:)%j-M(6,:)%j)) * den(51)
call G0_hol_initialisation(ntry,Gcoeff,G0H64(1),m0h(112),h0tab(:,112),[32,1,8,4,18],[nMT,0,nMB,0,nMT],5,1,wf4(:,19))
  call Hloop_AV_Q(ntry,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,100),heltab2x64(:,:,100))
  call Hloop_A_Q(ntry,G0H32(1),32,nMT,G1H32(60),n2h32(51))
Gcoeff(:)%j = (-(c(6)*M(3,:)%j)-c(13)*M(6,:)%j) * den(51)
call G0_hol_initialisation(ntry,Gcoeff,G0H64(1),m0h(113),h0tab(:,113),[32,4,8,1,18],[0,nMB,0,nMT,0],5,1,wf4(:,19))
  call Hloop_UV_W(ntry,G0H64(1),0,ex6(:),32,G1H32(61),m3h2x32(:,101),heltab2x64(:,:,101))
Gcoeff(:)%j = (c(20)*M(4,:)%j+c(21)*(-M(3,:)%j-M(6,:)%j)) * den(51)
call G0_hol_initialisation(ntry,Gcoeff,G0H64(1),m0h(114),h0tab(:,114),[32,4,18,1,8],[nMB,0,nMT,0,nMB],5,1,wf4(:,19))
  call Hloop_AV_Q(ntry,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,102),heltab2x64(:,:,102))
  call Hloop_A_Q(ntry,G0H32(1),32,nMB,G1H32(62),n2h32(52))
Gcoeff(:)%j = (c(9)*(M(4,:)%j-M(5,:)%j)+c(6)*(M(3,:)%j-M(6,:)%j)) * den(51)
call G0_hol_initialisation(ntry,Gcoeff,G0H64(1),m0h(115),h0tab(:,115),[32,1,18,8,4],[0,nMT,0,nMB,0],5,1,wf4(:,19))
  call Hloop_UV_W(ntry,G0H64(1),0,ex6(:),32,G1H32(63),m3h2x32(:,103),heltab2x64(:,:,103))
Gcoeff(:)%j = (-(c(13)*M(3,:)%j)-c(6)*M(6,:)%j) * den(51)
call G0_hol_initialisation(ntry,Gcoeff,G0H64(1),m0h(116),h0tab(:,116),[32,1,18,4,8],[0,nMT,0,nMB,0],5,1,wf4(:,19))
  call Hloop_UV_W(ntry,G0H64(1),0,ex6(:),32,G1H32(64),m3h2x32(:,104),heltab2x64(:,:,104))
Gcoeff(:)%j = (c(6)*M(3,:)%j+c(13)*M(10,:)%j) * den(12)
call G0_hol_initialisation(ntry,Gcoeff,G0H64(1),m0h(117),h0tab(:,117),[32,2,1,8,20],[0,nMT,0,nMB,0],5,1,wf4(:,6))
  call Hloop_UV_W(ntry,G0H64(1),0,ex6(:),32,G1H32(65),m3h2x32(:,105),heltab2x64(:,:,105))
Gcoeff(:)%j = (c(21)*(-M(3,:)%j-M(10,:)%j)+c(20)*M(12,:)%j) * den(12)
call G0_hol_initialisation(ntry,Gcoeff,G0H64(1),m0h(118),h0tab(:,118),[32,8,1,2,20],[nMB,0,nMT,0,nMB],5,1,wf4(:,6))
  call Hloop_QV_A(ntry,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,106),heltab2x64(:,:,106))
  call Hloop_Q_A(ntry,G0H32(1),32,nMB,G1H32(66),n2h32(53))
Gcoeff(:)%j = (c(6)*(M(3,:)%j-M(10,:)%j)+c(9)*(-M(1,:)%j+M(12,:)%j)) * den(12)
call G0_hol_initialisation(ntry,Gcoeff,G0H64(1),m0h(119),h0tab(:,119),[32,1,2,8,20],[0,nMT,0,nMB,0],5,1,wf4(:,6))
  call Hloop_UV_W(ntry,G0H64(1),0,ex6(:),32,G1H32(67),m3h2x32(:,107),heltab2x64(:,:,107))
Gcoeff(:)%j = (-(c(13)*M(3,:)%j)-c(6)*M(10,:)%j) * den(12)
call G0_hol_initialisation(ntry,Gcoeff,G0H64(1),m0h(120),h0tab(:,120),[32,1,2,20,8],[0,nMT,0,nMB,0],5,1,wf4(:,6))
  call Hloop_UV_W(ntry,G0H64(1),0,ex6(:),32,G1H32(68),m3h2x32(:,108),heltab2x64(:,:,108))
Gcoeff(:)%j = (c(24)*M(1,:)%j+c(21)*(-M(3,:)%j-M(10,:)%j)+c(20)*M(12,:)%j) * den(12)
call G0_hol_initialisation(ntry,Gcoeff,G0H64(1),m0h(121),h0tab(:,121),[32,8,2,1,20],[nMB,0,nMT,0,nMB],5,1,wf4(:,6))
  call Hloop_QV_A(ntry,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,109),heltab2x64(:,:,109))
  call Hloop_Q_A(ntry,G0H32(1),32,nMB,G1H32(69),n2h32(54))
Gcoeff(:)%j = (c(6)*(M(3,:)%j-M(10,:)%j)+c(9)*(M(1,:)%j-M(12,:)%j)) * den(12)
call G0_hol_initialisation(ntry,Gcoeff,G0H64(1),m0h(122),h0tab(:,122),[32,2,1,20,8],[0,nMT,0,nMB,0],5,1,wf4(:,6))
  call Hloop_UV_W(ntry,G0H64(1),0,ex6(:),32,G1H32(70),m3h2x32(:,110),heltab2x64(:,:,110))
Gcoeff(:)%j = (c(20)*M(1,:)%j+c(21)*(-M(3,:)%j-M(10,:)%j)) * den(12)
call G0_hol_initialisation(ntry,Gcoeff,G0H64(1),m0h(123),h0tab(:,123),[32,1,8,20,2],[nMT,0,nMB,0,nMT],5,1,wf4(:,6))
  call Hloop_AV_Q(ntry,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,111),heltab2x64(:,:,111))
  call Hloop_A_Q(ntry,G0H32(1),32,nMT,G1H32(71),n2h32(55))
Gcoeff(:)%j = (c(20)*M(1,:)%j+c(21)*(-M(3,:)%j-M(10,:)%j)+c(24)*M(12,:)%j) * den(12)
call G0_hol_initialisation(ntry,Gcoeff,G0H64(1),m0h(124),h0tab(:,124),[32,1,20,8,2],[nMT,0,nMB,0,nMT],5,1,wf4(:,6))
  call Hloop_AV_Q(ntry,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,112),heltab2x64(:,:,112))
  call Hloop_A_Q(ntry,G0H32(1),32,nMT,G1H32(72),n2h32(56))
Gcoeff(:)%j = (c(6)*(-M(2,:)%j+M(7,:)%j)+c(9)*(M(1,:)%j-M(8,:)%j)) * den(22)
call G0_hol_initialisation(ntry,Gcoeff,G0H64(1),m0h(125),h0tab(:,125),[32,2,1,4,24],[0,nMT,0,nMB,0],5,1,wf4(:,11))
  call Hloop_UV_W(ntry,G0H64(1),0,ex6(:),32,G1H32(73),m3h2x32(:,113),heltab2x64(:,:,113))
Gcoeff(:)%j = (c(24)*M(1,:)%j+c(21)*(-M(2,:)%j-M(7,:)%j)+c(20)*M(8,:)%j) * den(22)
call G0_hol_initialisation(ntry,Gcoeff,G0H64(1),m0h(126),h0tab(:,126),[32,4,1,2,24],[nMB,0,nMT,0,nMB],5,1,wf4(:,11))
  call Hloop_AV_Q(ntry,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,114),heltab2x64(:,:,114))
  call Hloop_A_Q(ntry,G0H32(1),32,nMB,G1H32(74),n2h32(57))
Gcoeff(:)%j = (-(c(6)*M(2,:)%j)-c(13)*M(7,:)%j) * den(22)
call G0_hol_initialisation(ntry,Gcoeff,G0H64(1),m0h(127),h0tab(:,127),[32,1,2,4,24],[0,nMT,0,nMB,0],5,1,wf4(:,11))
  call Hloop_UV_W(ntry,G0H64(1),0,ex6(:),32,G1H32(75),m3h2x32(:,115),heltab2x64(:,:,115))
Gcoeff(:)%j = (c(6)*(-M(2,:)%j+M(7,:)%j)+c(9)*(-M(1,:)%j+M(8,:)%j)) * den(22)
call G0_hol_initialisation(ntry,Gcoeff,G0H64(1),m0h(128),h0tab(:,128),[32,1,2,24,4],[0,nMT,0,nMB,0],5,1,wf4(:,11))
  call Hloop_UV_W(ntry,G0H64(1),0,ex6(:),32,G1H32(76),m3h2x32(:,116),heltab2x64(:,:,116))
Gcoeff(:)%j = (c(21)*(-M(2,:)%j-M(7,:)%j)+c(20)*M(8,:)%j) * den(22)
call G0_hol_initialisation(ntry,Gcoeff,G0H64(1),m0h(129),h0tab(:,129),[32,4,2,1,24],[nMB,0,nMT,0,nMB],5,1,wf4(:,11))
  call Hloop_AV_Q(ntry,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,117),heltab2x64(:,:,117))
  call Hloop_A_Q(ntry,G0H32(1),32,nMB,G1H32(77),n2h32(58))
Gcoeff(:)%j = (c(13)*M(2,:)%j+c(6)*M(7,:)%j) * den(22)
call G0_hol_initialisation(ntry,Gcoeff,G0H64(1),m0h(130),h0tab(:,130),[32,2,1,24,4],[0,nMT,0,nMB,0],5,1,wf4(:,11))
  call Hloop_UV_W(ntry,G0H64(1),0,ex6(:),32,G1H32(78),m3h2x32(:,118),heltab2x64(:,:,118))
Gcoeff(:)%j = (c(20)*M(1,:)%j+c(21)*(-M(2,:)%j-M(7,:)%j)+c(24)*M(8,:)%j) * den(22)
call G0_hol_initialisation(ntry,Gcoeff,G0H64(1),m0h(131),h0tab(:,131),[32,1,4,24,2],[nMT,0,nMB,0,nMT],5,1,wf4(:,11))
  call Hloop_AV_Q(ntry,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,119),heltab2x64(:,:,119))
  call Hloop_A_Q(ntry,G0H32(1),32,nMT,G1H32(79),n2h32(59))
Gcoeff(:)%j = (c(20)*M(1,:)%j+c(21)*(-M(2,:)%j-M(7,:)%j)) * den(22)
call G0_hol_initialisation(ntry,Gcoeff,G0H64(1),m0h(132),h0tab(:,132),[32,1,24,4,2],[nMT,0,nMB,0,nMT],5,1,wf4(:,11))
  call Hloop_AV_Q(ntry,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,120),heltab2x64(:,:,120))
  call Hloop_A_Q(ntry,G0H32(1),32,nMT,G1H32(80),n2h32(60))
Gcoeff(:)%j = (c(20)*M(5,:)%j+c(21)*(-M(3,:)%j-M(7,:)%j)) * den(50)
call G0_hol_initialisation(ntry,Gcoeff,G0H64(1),m0h(133),h0tab(:,133),[33,8,4,2,16],[0,nMB,0,nMT,nMT],5,1,wf4(:,18))
  call Hloop_AQ_V(ntry,G0H64(1),wf4(:,18),G0H16(13),m3h4x16(:,1),heltab2x64(:,:,121))
Gcoeff(:)%j = (-(c(6)*M(3,:)%j)-c(13)*M(7,:)%j) * den(50)
call G0_hol_initialisation(ntry,Gcoeff,G0H64(1),m0h(134),h0tab(:,134),[33,2,4,8,16],[nMT,0,nMB,0,0],5,1,wf4(:,18))
  call Hloop_VQ_A(ntry,G0H64(1),wf4(:,18),G0H16(14),m3h4x16(:,2),heltab2x64(:,:,122))
  call Hloop_Q_A(ntry,G0H16(14),33,nMT,G1H16(20),n2h16(25))
Gcoeff(:)%j = (c(20)*M(1,:)%j+c(21)*(-M(3,:)%j-M(7,:)%j)) * den(50)
call G0_hol_initialisation(ntry,Gcoeff,G0H64(1),m0h(135),h0tab(:,135),[33,2,4,16,8],[nMT,0,nMB,nMB,0],5,1,wf4(:,18))
  call Hloop_VQ_A(ntry,G0H64(1),wf4(:,18),G0H16(14),m3h4x16(:,3),heltab2x64(:,:,123))
  call Hloop_Q_A(ntry,G0H16(14),33,nMT,G1H16(1),n2h16(26))
Gcoeff(:)%j = (c(24)*M(1,:)%j+c(20)*M(5,:)%j+c(21)*(-M(3,:)%j-M(7,:)%j)) * den(50)
call G0_hol_initialisation(ntry,Gcoeff,G0H64(1),m0h(136),h0tab(:,136),[33,4,8,2,16],[0,nMB,0,nMT,nMT],5,1,wf4(:,18))
  call Hloop_AQ_V(ntry,G0H64(1),wf4(:,18),G0H16(14),m3h4x16(:,4),heltab2x64(:,:,124))
Gcoeff(:)%j = (c(9)*(M(1,:)%j-M(5,:)%j)+c(6)*(-M(3,:)%j+M(7,:)%j)) * den(50)
call G0_hol_initialisation(ntry,Gcoeff,G0H64(1),m0h(137),h0tab(:,137),[33,2,8,4,16],[nMT,0,nMB,0,0],5,1,wf4(:,18))
  call Hloop_VQ_A(ntry,G0H64(1),wf4(:,18),G0H16(15),m3h4x16(:,5),heltab2x64(:,:,125))
  call Hloop_Q_A(ntry,G0H16(15),33,nMT,G1H16(2),n2h16(27))
Gcoeff(:)%j = (c(20)*M(1,:)%j+c(24)*M(5,:)%j+c(21)*(-M(3,:)%j-M(7,:)%j)) * den(50)
call G0_hol_initialisation(ntry,Gcoeff,G0H64(1),m0h(138),h0tab(:,138),[33,2,8,16,4],[nMT,0,nMB,nMB,0],5,1,wf4(:,18))
  call Hloop_VQ_A(ntry,G0H64(1),wf4(:,18),G0H16(15),m3h4x16(:,6),heltab2x64(:,:,126))
  call Hloop_Q_A(ntry,G0H16(15),33,nMT,G1H16(4),n2h16(28))
Gcoeff(:)%j = (-(c(13)*M(3,:)%j)-c(6)*M(7,:)%j) * den(50)
call G0_hol_initialisation(ntry,Gcoeff,G0H64(1),m0h(139),h0tab(:,139),[33,2,16,4,8],[nMT,0,0,nMB,0],5,1,wf4(:,18))
  call Hloop_VQ_A(ntry,G0H64(1),wf4(:,18),G0H16(15),m3h4x16(:,7),heltab2x64(:,:,127))
  call Hloop_Q_A(ntry,G0H16(15),33,nMT,G1H16(5),n2h16(29))
Gcoeff(:)%j = (c(9)*(M(1,:)%j-M(5,:)%j)+c(6)*(M(3,:)%j-M(7,:)%j)) * den(50)
call G0_hol_initialisation(ntry,Gcoeff,G0H64(1),m0h(140),h0tab(:,140),[33,2,16,8,4],[nMT,0,0,nMB,0],5,1,wf4(:,18))
  call Hloop_VQ_A(ntry,G0H64(1),wf4(:,18),G0H16(15),m3h4x16(:,8),heltab2x64(:,:,128))
  call Hloop_Q_A(ntry,G0H16(15),33,nMT,G1H16(6),n2h16(30))
Gcoeff(:)%j = (c(24)*M(1,:)%j+c(20)*M(9,:)%j+c(21)*(-M(2,:)%j-M(10,:)%j)) * den(42)
call G0_hol_initialisation(ntry,Gcoeff,G0H64(1),m0h(141),h0tab(:,141),[34,8,4,1,16],[0,nMB,0,nMT,nMT],5,1,wf4(:,15))
  call Hloop_QA_V(ntry,G0H64(1),wf4(:,15),G0H16(15),m3h4x16(:,9),heltab2x64(:,:,129))
Gcoeff(:)%j = (c(9)*(-M(1,:)%j+M(9,:)%j)+c(6)*(M(2,:)%j-M(10,:)%j)) * den(42)
call G0_hol_initialisation(ntry,Gcoeff,G0H64(1),m0h(142),h0tab(:,142),[34,1,4,8,16],[nMT,0,nMB,0,0],5,1,wf4(:,15))
  call Hloop_VA_Q(ntry,G0H64(1),wf4(:,15),G0H16(16),m3h4x16(:,10),heltab2x64(:,:,130))
  call Hloop_A_Q(ntry,G0H16(16),34,nMT,G1H16(7),n2h16(31))
Gcoeff(:)%j = (c(20)*M(1,:)%j+c(24)*M(9,:)%j+c(21)*(-M(2,:)%j-M(10,:)%j)) * den(42)
call G0_hol_initialisation(ntry,Gcoeff,G0H64(1),m0h(143),h0tab(:,143),[34,1,4,16,8],[nMT,0,nMB,nMB,0],5,1,wf4(:,15))
  call Hloop_VA_Q(ntry,G0H64(1),wf4(:,15),G0H16(16),m3h4x16(:,11),heltab2x64(:,:,131))
  call Hloop_A_Q(ntry,G0H16(16),34,nMT,G1H16(8),n2h16(32))
Gcoeff(:)%j = (c(20)*M(9,:)%j+c(21)*(-M(2,:)%j-M(10,:)%j)) * den(42)
call G0_hol_initialisation(ntry,Gcoeff,G0H64(1),m0h(144),h0tab(:,144),[34,4,8,1,16],[0,nMB,0,nMT,nMT],5,1,wf4(:,15))
  call Hloop_QA_V(ntry,G0H64(1),wf4(:,15),G0H16(16),m3h4x16(:,12),heltab2x64(:,:,132))
Gcoeff(:)%j = (c(6)*M(2,:)%j+c(13)*M(10,:)%j) * den(42)
call G0_hol_initialisation(ntry,Gcoeff,G0H64(1),m0h(145),h0tab(:,145),[34,1,8,4,16],[nMT,0,nMB,0,0],5,1,wf4(:,15))
  call Hloop_VA_Q(ntry,G0H64(1),wf4(:,15),G0H16(17),m3h4x16(:,13),heltab2x64(:,:,133))
  call Hloop_A_Q(ntry,G0H16(17),34,nMT,G1H16(10),n2h16(33))
Gcoeff(:)%j = (c(20)*M(1,:)%j+c(21)*(-M(2,:)%j-M(10,:)%j)) * den(42)
call G0_hol_initialisation(ntry,Gcoeff,G0H64(1),m0h(146),h0tab(:,146),[34,1,8,16,4],[nMT,0,nMB,nMB,0],5,1,wf4(:,15))
  call Hloop_VA_Q(ntry,G0H64(1),wf4(:,15),G0H16(17),m3h4x16(:,14),heltab2x64(:,:,134))
  call Hloop_A_Q(ntry,G0H16(17),34,nMT,G1H16(11),n2h16(34))
Gcoeff(:)%j = (c(9)*(-M(1,:)%j+M(9,:)%j)+c(6)*(-M(2,:)%j+M(10,:)%j)) * den(42)
call G0_hol_initialisation(ntry,Gcoeff,G0H64(1),m0h(147),h0tab(:,147),[34,1,16,4,8],[nMT,0,0,nMB,0],5,1,wf4(:,15))
  call Hloop_VA_Q(ntry,G0H64(1),wf4(:,15),G0H16(17),m3h4x16(:,15),heltab2x64(:,:,135))
  call Hloop_A_Q(ntry,G0H16(17),34,nMT,G1H16(12),n2h16(35))
Gcoeff(:)%j = (c(13)*M(2,:)%j+c(6)*M(10,:)%j) * den(42)
call G0_hol_initialisation(ntry,Gcoeff,G0H64(1),m0h(148),h0tab(:,148),[34,1,16,8,4],[nMT,0,0,nMB,0],5,1,wf4(:,15))
  call Hloop_VA_Q(ntry,G0H64(1),wf4(:,15),G0H16(17),m3h4x16(:,16),heltab2x64(:,:,136))
  call Hloop_A_Q(ntry,G0H16(17),34,nMT,G1H16(13),n2h16(36))
Gcoeff(:)%j = (-(c(6)*M(2,:)%j)-c(13)*M(6,:)%j) * den(21)
call G0_hol_initialisation(ntry,Gcoeff,G0H64(1),m0h(149),h0tab(:,149),[36,8,1,2,16],[nMB,0,nMT,0,0],5,1,wf4(:,10))
  call Hloop_VQ_A(ntry,G0H64(1),wf4(:,10),G0H16(17),m3h4x16(:,17),heltab2x64(:,:,137))
  call Hloop_Q_A(ntry,G0H16(17),36,nMB,G1H16(14),n2h16(37))
Gcoeff(:)%j = (c(21)*(-M(2,:)%j-M(6,:)%j)+c(20)*M(8,:)%j) * den(21)
call G0_hol_initialisation(ntry,Gcoeff,G0H64(1),m0h(150),h0tab(:,150),[36,2,1,8,16],[0,nMT,0,nMB,nMB],5,1,wf4(:,10))
  call Hloop_AQ_V(ntry,G0H64(1),wf4(:,10),G0H16(17),m3h4x16(:,18),heltab2x64(:,:,138))
Gcoeff(:)%j = (c(6)*(-M(2,:)%j+M(6,:)%j)+c(9)*(M(4,:)%j-M(8,:)%j)) * den(21)
call G0_hol_initialisation(ntry,Gcoeff,G0H64(1),m0h(151),h0tab(:,151),[36,8,2,1,16],[nMB,0,nMT,0,0],5,1,wf4(:,10))
  call Hloop_VQ_A(ntry,G0H64(1),wf4(:,10),G0H16(18),m3h4x16(:,19),heltab2x64(:,:,139))
  call Hloop_Q_A(ntry,G0H16(18),36,nMB,G1H16(16),n2h16(38))
Gcoeff(:)%j = (c(13)*M(2,:)%j+c(6)*M(6,:)%j) * den(21)
call G0_hol_initialisation(ntry,Gcoeff,G0H64(1),m0h(152),h0tab(:,152),[36,2,1,16,8],[0,nMT,0,0,nMB],5,1,wf4(:,10))
  call Hloop_AQ_V(ntry,G0H64(1),wf4(:,10),G0H16(18),m3h4x16(:,20),heltab2x64(:,:,140))
Gcoeff(:)%j = (c(24)*M(4,:)%j+c(21)*(-M(2,:)%j-M(6,:)%j)+c(20)*M(8,:)%j) * den(21)
call G0_hol_initialisation(ntry,Gcoeff,G0H64(1),m0h(153),h0tab(:,153),[36,1,2,8,16],[0,nMT,0,nMB,nMB],5,1,wf4(:,10))
  call Hloop_AQ_V(ntry,G0H64(1),wf4(:,10),G0H16(19),m3h4x16(:,21),heltab2x64(:,:,141))
Gcoeff(:)%j = (c(6)*(-M(2,:)%j+M(6,:)%j)+c(9)*(-M(4,:)%j+M(8,:)%j)) * den(21)
call G0_hol_initialisation(ntry,Gcoeff,G0H64(1),m0h(154),h0tab(:,154),[36,1,2,16,8],[0,nMT,0,0,nMB],5,1,wf4(:,10))
  call Hloop_AQ_V(ntry,G0H64(1),wf4(:,10),G0H16(20),m3h4x16(:,22),heltab2x64(:,:,142))
Gcoeff(:)%j = (c(20)*M(4,:)%j+c(21)*(-M(2,:)%j-M(6,:)%j)) * den(21)
call G0_hol_initialisation(ntry,Gcoeff,G0H64(1),m0h(155),h0tab(:,155),[36,2,16,1,8],[0,nMT,nMT,0,nMB],5,1,wf4(:,10))
  call Hloop_AQ_V(ntry,G0H64(1),wf4(:,10),G0H16(21),m3h4x16(:,23),heltab2x64(:,:,143))
Gcoeff(:)%j = (c(20)*M(4,:)%j+c(21)*(-M(2,:)%j-M(6,:)%j)+c(24)*M(8,:)%j) * den(21)
call G0_hol_initialisation(ntry,Gcoeff,G0H64(1),m0h(156),h0tab(:,156),[36,1,16,2,8],[0,nMT,nMT,0,nMB],5,1,wf4(:,10))
  call Hloop_AQ_V(ntry,G0H64(1),wf4(:,10),G0H16(22),m3h4x16(:,24),heltab2x64(:,:,144))
Gcoeff(:)%j = (c(6)*(M(3,:)%j-M(11,:)%j)+c(9)*(-M(4,:)%j+M(12,:)%j)) * den(13)
call G0_hol_initialisation(ntry,Gcoeff,G0H64(1),m0h(157),h0tab(:,157),[40,4,1,2,16],[nMB,0,nMT,0,0],5,1,wf4(:,7))
  call Hloop_VA_Q(ntry,G0H64(1),wf4(:,7),G0H16(23),m3h4x16(:,25),heltab2x64(:,:,145))
  call Hloop_A_Q(ntry,G0H16(23),40,nMB,G1H16(17),n2h16(39))
Gcoeff(:)%j = (c(24)*M(4,:)%j+c(21)*(-M(3,:)%j-M(11,:)%j)+c(20)*M(12,:)%j) * den(13)
call G0_hol_initialisation(ntry,Gcoeff,G0H64(1),m0h(158),h0tab(:,158),[40,2,1,4,16],[0,nMT,0,nMB,nMB],5,1,wf4(:,7))
  call Hloop_QA_V(ntry,G0H64(1),wf4(:,7),G0H16(23),m3h4x16(:,26),heltab2x64(:,:,146))
Gcoeff(:)%j = (c(6)*M(3,:)%j+c(13)*M(11,:)%j) * den(13)
call G0_hol_initialisation(ntry,Gcoeff,G0H64(1),m0h(159),h0tab(:,159),[40,4,2,1,16],[nMB,0,nMT,0,0],5,1,wf4(:,7))
  call Hloop_VA_Q(ntry,G0H64(1),wf4(:,7),G0H16(24),m3h4x16(:,27),heltab2x64(:,:,147))
  call Hloop_A_Q(ntry,G0H16(24),40,nMB,G1H16(18),n2h16(40))
Gcoeff(:)%j = (c(6)*(M(3,:)%j-M(11,:)%j)+c(9)*(M(4,:)%j-M(12,:)%j)) * den(13)
call G0_hol_initialisation(ntry,Gcoeff,G0H64(1),m0h(160),h0tab(:,160),[40,2,1,16,4],[0,nMT,0,0,nMB],5,1,wf4(:,7))
  call Hloop_QA_V(ntry,G0H64(1),wf4(:,7),G0H16(24),m3h4x16(:,28),heltab2x64(:,:,148))
Gcoeff(:)%j = (c(21)*(-M(3,:)%j-M(11,:)%j)+c(20)*M(12,:)%j) * den(13)
call G0_hol_initialisation(ntry,Gcoeff,G0H64(1),m0h(161),h0tab(:,161),[40,1,2,4,16],[0,nMT,0,nMB,nMB],5,1,wf4(:,7))
  call Hloop_QA_V(ntry,G0H64(1),wf4(:,7),G0H16(25),m3h4x16(:,29),heltab2x64(:,:,149))
Gcoeff(:)%j = (-(c(13)*M(3,:)%j)-c(6)*M(11,:)%j) * den(13)
call G0_hol_initialisation(ntry,Gcoeff,G0H64(1),m0h(162),h0tab(:,162),[40,1,2,16,4],[0,nMT,0,0,nMB],5,1,wf4(:,7))
  call Hloop_QA_V(ntry,G0H64(1),wf4(:,7),G0H16(26),m3h4x16(:,30),heltab2x64(:,:,150))
Gcoeff(:)%j = (c(20)*M(4,:)%j+c(21)*(-M(3,:)%j-M(11,:)%j)+c(24)*M(12,:)%j) * den(13)
call G0_hol_initialisation(ntry,Gcoeff,G0H64(1),m0h(163),h0tab(:,163),[40,2,16,1,4],[0,nMT,nMT,0,nMB],5,1,wf4(:,7))
  call Hloop_QA_V(ntry,G0H64(1),wf4(:,7),G0H16(27),m3h4x16(:,31),heltab2x64(:,:,151))
Gcoeff(:)%j = (c(20)*M(4,:)%j+c(21)*(-M(3,:)%j-M(11,:)%j)) * den(13)
call G0_hol_initialisation(ntry,Gcoeff,G0H64(1),m0h(164),h0tab(:,164),[40,1,16,2,4],[0,nMT,nMT,0,nMB],5,1,wf4(:,7))
  call Hloop_QA_V(ntry,G0H64(1),wf4(:,7),G0H16(28),m3h4x16(:,32),heltab2x64(:,:,152))
Gcoeff(:)%j = (c(9)*(-M(5,:)%j+M(9,:)%j)+c(6)*(M(6,:)%j+M(7,:)%j-M(10,:)%j-M(11,:)%j)+c(5)*(-M(8,:)%j+M(12,:)%j)) * den(4)
call G0_hol_initialisation(ntry,Gcoeff,G0H64(1),m0h(165),h0tab(:,165),[48,4,1,2,8],[nMB,0,nMT,0,nMB],5,1,wf4(:,3))
  call Hloop_AV_Q(ntry,G0H64(1),wf4(:,3),G0H16(29),m3h4x16(:,33),heltab2x64(:,:,153))
  call Hloop_A_Q(ntry,G0H16(29),48,nMB,G1H16(19),n2h16(41))
Gcoeff(:)%j = (c(21)*(M(6,:)%j-M(7,:)%j-M(10,:)%j+M(11,:)%j)+c(24)*(-M(5,:)%j+M(8,:)%j+M(9,:)%j-M(12,:)%j)) * den(4)
call G0_hol_initialisation(ntry,Gcoeff,G0H64(1),m0h(166),h0tab(:,166),[48,2,1,4,8],[0,nMT,0,nMB,0],5,1,wf4(:,3))
  call Hloop_UV_W(ntry,G0H64(1),0,wf4(:,3),48,G1H16(21),m3h4x16(:,34),heltab2x64(:,:,154))
Gcoeff(:)%j = (c(6)*(M(6,:)%j+M(7,:)%j-M(10,:)%j-M(11,:)%j)+c(5)*(-M(8,:)%j+M(12,:)%j)) * den(4)
call G0_hol_initialisation(ntry,Gcoeff,G0H64(1),m0h(167),h0tab(:,167),[48,4,2,1,8],[nMB,0,nMT,0,nMB],5,1,wf4(:,3))
  call Hloop_AV_Q(ntry,G0H64(1),wf4(:,3),G0H16(29),m3h4x16(:,35),heltab2x64(:,:,155))
  call Hloop_A_Q(ntry,G0H16(29),48,nMB,G1H16(23),n2h16(42))
Gcoeff(:)%j = (c(28)*(-M(6,:)%j+M(10,:)%j)+c(21)*(-M(7,:)%j+M(11,:)%j)) * den(4)
call G0_hol_initialisation(ntry,Gcoeff,G0H64(1),m0h(168),h0tab(:,168),[48,2,1,8,4],[0,nMT,0,nMB,0],5,1,wf4(:,3))
  call Hloop_UV_W(ntry,G0H64(1),0,wf4(:,3),48,G1H16(24),m3h4x16(:,36),heltab2x64(:,:,156))
Gcoeff(:)%j = (c(21)*(M(6,:)%j-M(10,:)%j)+c(28)*(M(7,:)%j-M(11,:)%j)) * den(4)
call G0_hol_initialisation(ntry,Gcoeff,G0H64(1),m0h(169),h0tab(:,169),[48,1,2,4,8],[0,nMT,0,nMB,0],5,1,wf4(:,3))
  call Hloop_UV_W(ntry,G0H64(1),0,wf4(:,3),48,G1H16(25),m3h4x16(:,37),heltab2x64(:,:,157))
Gcoeff(:)%j = (c(21)*(M(6,:)%j-M(7,:)%j-M(10,:)%j+M(11,:)%j)+c(24)*(M(5,:)%j-M(8,:)%j-M(9,:)%j+M(12,:)%j)) * den(4)
call G0_hol_initialisation(ntry,Gcoeff,G0H64(1),m0h(170),h0tab(:,170),[48,1,2,8,4],[0,nMT,0,nMB,0],5,1,wf4(:,3))
  call Hloop_UV_W(ntry,G0H64(1),0,wf4(:,3),48,G1H16(26),m3h4x16(:,38),heltab2x64(:,:,158))
Gcoeff(:)%j = (c(5)*(-M(5,:)%j+M(9,:)%j)+c(6)*(M(6,:)%j+M(7,:)%j-M(10,:)%j-M(11,:)%j)+c(9)*(-M(8,:)%j+M(12,:)%j)) * den(4)
call G0_hol_initialisation(ntry,Gcoeff,G0H64(1),m0h(171),h0tab(:,171),[48,1,4,8,2],[nMT,0,nMB,0,nMT],5,1,wf4(:,3))
  call Hloop_AV_Q(ntry,G0H64(1),wf4(:,3),G0H16(29),m3h4x16(:,39),heltab2x64(:,:,159))
  call Hloop_A_Q(ntry,G0H16(29),48,nMT,G1H16(27),n2h16(43))
Gcoeff(:)%j = (c(5)*(-M(5,:)%j+M(9,:)%j)+c(6)*(M(6,:)%j+M(7,:)%j-M(10,:)%j-M(11,:)%j)) * den(4)
call G0_hol_initialisation(ntry,Gcoeff,G0H64(1),m0h(172),h0tab(:,172),[48,1,8,4,2],[nMT,0,nMB,0,nMT],5,1,wf4(:,3))
  call Hloop_AV_Q(ntry,G0H64(1),wf4(:,3),G0H16(29),m3h4x16(:,40),heltab2x64(:,:,160))
  call Hloop_A_Q(ntry,G0H16(29),48,nMT,G1H16(28),n2h16(44))
  call ol_merge(ntry,G1H16(21),[G0H16(3),G0H16(2),G0H16(1)])
  call ol_merge(ntry,G1H16(24),[G0H16(6),G0H16(5),G0H16(4)])
  call ol_merge(ntry,G1H16(25),[G0H16(9),G0H16(8),G0H16(7)])
  call ol_merge(ntry,G1H16(26),[G0H16(12),G0H16(11),G0H16(10)])
  call Hloop_AV_Q(ntry,G1H16(3),ex5(:),G1H8(5),m3h2x8(:,57),heltab2x16(:,:,57))
  call Hloop_A_Q(ntry,G1H8(5),50,nMT,G2H8(9),n2h8(57))
  call Hloop_AV_Q(ntry,G1H16(9),ex5(:),G1H8(6),m3h2x8(:,58),heltab2x16(:,:,58))
  call Hloop_A_Q(ntry,G1H8(6),50,nMT,G2H8(10),n2h8(58))
  call Hloop_QV_A(ntry,G1H16(15),ex5(:),G1H8(9),m3h2x8(:,59),heltab2x16(:,:,59))
  call Hloop_Q_A(ntry,G1H8(9),49,nMT,G2H8(11),n2h8(59))
  call Hloop_QV_A(ntry,G1H16(22),ex5(:),G1H8(10),m3h2x8(:,60),heltab2x16(:,:,60))
  call Hloop_Q_A(ntry,G1H8(10),49,nMT,G2H8(12),n2h8(60))
  call Hloop_VA_Q(ntry,G1H16(21),ex2(:),G1H8(11),m3h2x8(:,61),heltab2x16(:,:,61))
  call Hloop_A_Q(ntry,G1H8(11),50,nMT,G2H8(13),n2h8(61))
  call Hloop_VA_Q(ntry,G1H16(24),ex2(:),G1H8(12),m3h2x8(:,62),heltab2x16(:,:,62))
  call Hloop_A_Q(ntry,G1H8(12),50,nMT,G2H8(14),n2h8(62))
  call Hloop_VQ_A(ntry,G1H16(25),ex1(:),G1H8(15),m3h2x8(:,63),heltab2x16(:,:,63))
  call Hloop_Q_A(ntry,G1H8(15),49,nMT,G2H8(15),n2h8(63))
  call Hloop_VQ_A(ntry,G1H16(26),ex1(:),G1H8(16),m3h2x8(:,64),heltab2x16(:,:,64))
  call Hloop_Q_A(ntry,G1H8(16),49,nMT,G2H8(16),n2h8(64))
  call Hloop_AV_Q(ntry,G1H32(1),wf4(:,1),G1H8(17),m3h4x8(:,1),heltab2x32(:,:,41))
  call Hloop_A_Q(ntry,G1H8(17),35,nMB,G2H8(17),n2h8(65))
  call Hloop_UV_W(ntry,G1H32(2),32,wf4(:,1),3,G2H8(18),m3h4x8(:,2),heltab2x32(:,:,42))
  call Hloop_QV_A(ntry,G1H32(3),wf4(:,1),G1H8(18),m3h4x8(:,3),heltab2x32(:,:,43))
  call Hloop_Q_A(ntry,G1H8(18),35,nMB,G2H8(19),n2h8(66))
  call Hloop_UV_W(ntry,G1H32(4),32,wf4(:,1),3,G2H8(20),m3h4x8(:,4),heltab2x32(:,:,44))
  call Hloop_QV_A(ntry,G1H32(5),wf4(:,1),G1H8(21),m3h4x8(:,5),heltab2x32(:,:,45))
  call Hloop_Q_A(ntry,G1H8(21),35,nMB,G2H8(21),n2h8(67))
  call Hloop_UV_W(ntry,G1H32(6),32,wf4(:,1),3,G2H8(22),m3h4x8(:,6),heltab2x32(:,:,46))
  call Hloop_AQ_V(ntry,G1H32(7),ex3(:),G1H16(3),m3h2x16(:,41),heltab2x32(:,:,47))
  call Hloop_VQ_A(ntry,G1H32(8),ex3(:),G1H16(9),m3h2x16(:,42),heltab2x32(:,:,48))
  call Hloop_Q_A(ntry,G1H16(9),36,nMB,G2H16(1),n2h16(45))
  call Hloop_AV_Q(ntry,G1H32(9),wf4(:,1),G1H8(22),m3h4x8(:,7),heltab2x32(:,:,49))
  call Hloop_A_Q(ntry,G1H8(22),35,nMB,G2H8(23),n2h8(68))
  call Hloop_UV_W(ntry,G1H32(10),32,wf4(:,1),3,G2H8(24),m3h4x8(:,8),heltab2x32(:,:,50))
  call Hloop_QA_V(ntry,G1H32(11),ex4(:),G1H16(15),m3h2x16(:,43),heltab2x32(:,:,51))
  call Hloop_VA_Q(ntry,G1H32(12),ex4(:),G1H16(22),m3h2x16(:,44),heltab2x32(:,:,52))
  call Hloop_A_Q(ntry,G1H16(22),40,nMB,G2H16(2),n2h16(46))
  call Hloop_QV_A(ntry,G1H32(13),wf4(:,1),G1H8(23),m3h4x8(:,9),heltab2x32(:,:,53))
  call Hloop_Q_A(ntry,G1H8(23),35,nMB,G2H8(25),n2h8(69))
  call Hloop_UV_W(ntry,G1H32(14),32,wf4(:,1),3,G2H8(26),m3h4x8(:,10),heltab2x32(:,:,54))
  call Hloop_VQ_A(ntry,G1H32(15),ex3(:),G1H16(21),m3h2x16(:,45),heltab2x32(:,:,55))
  call Hloop_Q_A(ntry,G1H16(21),36,nMB,G2H16(3),n2h16(47))
  call Hloop_AQ_V(ntry,G1H32(16),ex3(:),G1H16(24),m3h2x16(:,46),heltab2x32(:,:,56))
  call Hloop_AV_Q(ntry,G1H32(17),wf4(:,1),G1H8(24),m3h4x8(:,11),heltab2x32(:,:,57))
  call Hloop_A_Q(ntry,G1H8(24),35,nMB,G2H8(27),n2h8(70))
  call Hloop_UV_W(ntry,G1H32(18),32,wf4(:,1),3,G2H8(28),m3h4x8(:,12),heltab2x32(:,:,58))
  call Hloop_QA_V(ntry,G1H32(19),ex4(:),G1H16(25),m3h2x16(:,47),heltab2x32(:,:,59))
  call Hloop_VA_Q(ntry,G1H32(20),ex4(:),G1H16(26),m3h2x16(:,48),heltab2x32(:,:,60))
  call Hloop_A_Q(ntry,G1H16(26),40,nMB,G2H16(4),n2h16(48))
  call Hloop_VQ_A(ntry,G1H32(21),ex3(:),G1H16(9),m3h2x16(:,49),heltab2x32(:,:,61))
  call Hloop_Q_A(ntry,G1H16(9),36,nMB,G2H16(5),n2h16(49))
  call Hloop_AQ_V(ntry,G1H32(22),ex3(:),G1H16(22),m3h2x16(:,50),heltab2x32(:,:,62))
  call Hloop_AQ_V(ntry,G1H32(23),ex3(:),G1H16(21),m3h2x16(:,51),heltab2x32(:,:,63))
  call Hloop_VQ_A(ntry,G1H32(24),ex3(:),G1H16(26),m3h2x16(:,52),heltab2x32(:,:,64))
  call Hloop_Q_A(ntry,G1H16(26),36,nMB,G2H16(6),n2h16(50))
  call Hloop_QA_V(ntry,G1H32(25),ex2(:),G1H16(9),m3h2x16(:,53),heltab2x32(:,:,65))
  call Hloop_VA_Q(ntry,G1H32(26),ex2(:),G1H16(26),m3h2x16(:,54),heltab2x32(:,:,66))
  call Hloop_A_Q(ntry,G1H16(26),34,nMT,G2H16(7),n2h16(51))
  call Hloop_QV_A(ntry,G1H32(27),wf4(:,2),G1H8(27),m3h4x8(:,13),heltab2x32(:,:,67))
  call Hloop_Q_A(ntry,G1H8(27),44,nMT,G2H8(29),n2h8(71))
  call Hloop_UV_W(ntry,G1H32(28),32,wf4(:,2),12,G2H8(30),m3h4x8(:,14),heltab2x32(:,:,68))
  call Hloop_AQ_V(ntry,G1H32(29),ex1(:),G1H16(26),m3h2x16(:,55),heltab2x32(:,:,69))
  call Hloop_VQ_A(ntry,G1H32(30),ex1(:),G1H16(29),m3h2x16(:,56),heltab2x32(:,:,70))
  call Hloop_Q_A(ntry,G1H16(29),33,nMT,G2H16(8),n2h16(52))
  call Hloop_AQ_V(ntry,G1H32(31),ex1(:),G1H16(29),m3h2x16(:,57),heltab2x32(:,:,71))
  call Hloop_VQ_A(ntry,G1H32(32),ex1(:),G1H16(30),m3h2x16(:,58),heltab2x32(:,:,72))
  call Hloop_Q_A(ntry,G1H16(30),33,nMT,G2H16(9),n2h16(53))
  call Hloop_AV_Q(ntry,G1H32(33),wf4(:,2),G1H8(28),m3h4x8(:,15),heltab2x32(:,:,73))
  call Hloop_A_Q(ntry,G1H8(28),44,nMT,G2H8(31),n2h8(72))
  call Hloop_UV_W(ntry,G1H32(34),32,wf4(:,2),12,G2H8(32),m3h4x8(:,16),heltab2x32(:,:,74))
  call Hloop_QA_V(ntry,G1H32(35),ex2(:),G1H16(30),m3h2x16(:,59),heltab2x32(:,:,75))
  call Hloop_VA_Q(ntry,G1H32(36),ex2(:),G1H16(31),m3h2x16(:,60),heltab2x32(:,:,76))
  call Hloop_A_Q(ntry,G1H16(31),34,nMT,G2H16(10),n2h16(54))
  call Hloop_AQ_V(ntry,G1H32(37),ex1(:),G1H16(31),m3h2x16(:,61),heltab2x32(:,:,77))
  call Hloop_VQ_A(ntry,G1H32(38),ex1(:),G1H16(32),m3h2x16(:,62),heltab2x32(:,:,78))
  call Hloop_Q_A(ntry,G1H16(32),33,nMT,G2H16(11),n2h16(55))
  call Hloop_VQ_A(ntry,G1H32(39),ex1(:),G1H16(32),m3h2x16(:,63),heltab2x32(:,:,79))
  call Hloop_Q_A(ntry,G1H16(32),33,nMT,G2H16(12),n2h16(56))
  call Hloop_AQ_V(ntry,G1H32(40),ex1(:),G1H16(32),m3h2x16(:,64),heltab2x32(:,:,80))
  call Hloop_QA_V(ntry,G1H32(41),ex2(:),G1H16(33),m3h2x16(:,65),heltab2x32(:,:,81))
  call Hloop_VA_Q(ntry,G1H32(42),ex2(:),G1H16(34),m3h2x16(:,66),heltab2x32(:,:,82))
  call Hloop_A_Q(ntry,G1H16(34),34,nMT,G2H16(13),n2h16(57))
  call Hloop_QA_V(ntry,G1H32(43),ex2(:),G1H16(34),m3h2x16(:,67),heltab2x32(:,:,83))
  call Hloop_VA_Q(ntry,G1H32(44),ex2(:),G1H16(35),m3h2x16(:,68),heltab2x32(:,:,84))
  call Hloop_A_Q(ntry,G1H16(35),34,nMT,G2H16(14),n2h16(58))
  call Hloop_VQ_A(ntry,G1H32(45),ex1(:),G1H16(35),m3h2x16(:,69),heltab2x32(:,:,85))
  call Hloop_Q_A(ntry,G1H16(35),33,nMT,G2H16(15),n2h16(59))
  call Hloop_AQ_V(ntry,G1H32(46),ex1(:),G1H16(35),m3h2x16(:,70),heltab2x32(:,:,86))
  call Hloop_AQ_V(ntry,G1H32(47),ex1(:),G1H16(36),m3h2x16(:,71),heltab2x32(:,:,87))
  call Hloop_VQ_A(ntry,G1H32(48),ex1(:),G1H16(37),m3h2x16(:,72),heltab2x32(:,:,88))
  call Hloop_Q_A(ntry,G1H16(37),33,nMT,G2H16(16),n2h16(60))
  call Hloop_QA_V(ntry,G1H32(49),ex2(:),G1H16(37),m3h2x16(:,73),heltab2x32(:,:,89))
  call Hloop_VA_Q(ntry,G1H32(50),ex4(:),G1H16(38),m3h2x16(:,74),heltab2x32(:,:,90))
  call Hloop_A_Q(ntry,G1H16(38),40,nMB,G2H16(17),n2h16(61))
  call Hloop_AQ_V(ntry,G1H32(51),ex3(:),G1H16(38),m3h2x16(:,75),heltab2x32(:,:,91))
  call Hloop_QA_V(ntry,G1H32(52),ex2(:),G1H16(39),m3h2x16(:,76),heltab2x32(:,:,92))
  call Hloop_VQ_A(ntry,G1H32(53),ex3(:),G1H16(40),m3h2x16(:,77),heltab2x32(:,:,93))
  call Hloop_Q_A(ntry,G1H16(40),36,nMB,G2H16(18),n2h16(62))
  call Hloop_AQ_V(ntry,G1H32(54),ex3(:),G1H16(40),m3h2x16(:,78),heltab2x32(:,:,94))
  call Hloop_VA_Q(ntry,G1H32(55),ex2(:),G1H16(41),m3h2x16(:,79),heltab2x32(:,:,95))
  call Hloop_A_Q(ntry,G1H16(41),34,nMT,G2H16(19),n2h16(63))
  call Hloop_VA_Q(ntry,G1H32(56),ex2(:),G1H16(41),m3h2x16(:,80),heltab2x32(:,:,96))
  call Hloop_A_Q(ntry,G1H16(41),34,nMT,G2H16(20),n2h16(64))
  call Hloop_AQ_V(ntry,G1H32(57),ex1(:),G1H16(41),m3h2x16(:,81),heltab2x32(:,:,97))
  call Hloop_VA_Q(ntry,G1H32(58),ex4(:),G1H16(42),m3h2x16(:,82),heltab2x32(:,:,98))
  call Hloop_A_Q(ntry,G1H16(42),40,nMB,G2H16(21),n2h16(65))
  call Hloop_AQ_V(ntry,G1H32(59),ex3(:),G1H16(42),m3h2x16(:,83),heltab2x32(:,:,99))
  call Hloop_AQ_V(ntry,G1H32(60),ex1(:),G1H16(43),m3h2x16(:,84),heltab2x32(:,:,100))
  call Hloop_VQ_A(ntry,G1H32(61),ex3(:),G1H16(44),m3h2x16(:,85),heltab2x32(:,:,101))
  call Hloop_Q_A(ntry,G1H16(44),36,nMB,G2H16(22),n2h16(66))
  call Hloop_AQ_V(ntry,G1H32(62),ex3(:),G1H16(44),m3h2x16(:,86),heltab2x32(:,:,102))
  call Hloop_VQ_A(ntry,G1H32(63),ex1(:),G1H16(45),m3h2x16(:,87),heltab2x32(:,:,103))
  call Hloop_Q_A(ntry,G1H16(45),33,nMT,G2H16(23),n2h16(67))
  call Hloop_VQ_A(ntry,G1H32(64),ex1(:),G1H16(45),m3h2x16(:,88),heltab2x32(:,:,104))
  call Hloop_Q_A(ntry,G1H16(45),33,nMT,G2H16(24),n2h16(68))
  call Hloop_VA_Q(ntry,G1H32(65),ex2(:),G1H16(45),m3h2x16(:,89),heltab2x32(:,:,105))
  call Hloop_A_Q(ntry,G1H16(45),34,nMT,G2H16(25),n2h16(69))
  call Hloop_QA_V(ntry,G1H32(66),ex4(:),G1H16(45),m3h2x16(:,90),heltab2x32(:,:,106))
  call Hloop_VQ_A(ntry,G1H32(67),ex1(:),G1H16(46),m3h2x16(:,91),heltab2x32(:,:,107))
  call Hloop_Q_A(ntry,G1H16(46),33,nMT,G2H16(26),n2h16(70))
  call Hloop_VQ_A(ntry,G1H32(68),ex1(:),G1H16(46),m3h2x16(:,92),heltab2x32(:,:,108))
  call Hloop_Q_A(ntry,G1H16(46),33,nMT,G2H16(27),n2h16(71))
  call Hloop_QA_V(ntry,G1H32(69),ex4(:),G1H16(46),m3h2x16(:,93),heltab2x32(:,:,109))
  call Hloop_VA_Q(ntry,G1H32(70),ex2(:),G1H16(47),m3h2x16(:,94),heltab2x32(:,:,110))
  call Hloop_A_Q(ntry,G1H16(47),34,nMT,G2H16(28),n2h16(72))
  call Hloop_AQ_V(ntry,G1H32(71),ex1(:),G1H16(47),m3h2x16(:,95),heltab2x32(:,:,111))
  call Hloop_AQ_V(ntry,G1H32(72),ex1(:),G1H16(48),m3h2x16(:,96),heltab2x32(:,:,112))
  call Hloop_VA_Q(ntry,G1H32(73),ex2(:),G1H16(49),m3h2x16(:,97),heltab2x32(:,:,113))
  call Hloop_A_Q(ntry,G1H16(49),34,nMT,G2H16(29),n2h16(73))
  call Hloop_AQ_V(ntry,G1H32(74),ex3(:),G1H16(49),m3h2x16(:,98),heltab2x32(:,:,114))
  call Hloop_VQ_A(ntry,G1H32(75),ex1(:),G1H16(50),m3h2x16(:,99),heltab2x32(:,:,115))
  call Hloop_Q_A(ntry,G1H16(50),33,nMT,G2H16(30),n2h16(74))
  call Hloop_VQ_A(ntry,G1H32(76),ex1(:),G1H16(50),m3h2x16(:,100),heltab2x32(:,:,116))
  call Hloop_Q_A(ntry,G1H16(50),33,nMT,G2H16(31),n2h16(75))
  call Hloop_AQ_V(ntry,G1H32(77),ex3(:),G1H16(50),m3h2x16(:,101),heltab2x32(:,:,117))
  call Hloop_VA_Q(ntry,G1H32(78),ex2(:),G1H16(51),m3h2x16(:,102),heltab2x32(:,:,118))
  call Hloop_A_Q(ntry,G1H16(51),34,nMT,G2H16(32),n2h16(76))
  call Hloop_AQ_V(ntry,G1H32(79),ex1(:),G1H16(51),m3h2x16(:,103),heltab2x32(:,:,119))
  call Hloop_AQ_V(ntry,G1H32(80),ex1(:),G1H16(52),m3h2x16(:,104),heltab2x32(:,:,120))
  call Hloop_VA_Q(ntry,G0H16(13),ex4(:),G0H8(1),m3h2x8(:,65),heltab2x16(:,:,65))
  call Hloop_A_Q(ntry,G0H8(1),41,nMB,G1H8(29),n2h8(73))
  call Hloop_QA_V(ntry,G1H16(20),ex2(:),G1H8(30),m3h2x8(:,66),heltab2x16(:,:,66))
  call Hloop_QA_V(ntry,G1H16(1),ex2(:),G1H8(33),m3h2x8(:,67),heltab2x16(:,:,67))
  call Hloop_VQ_A(ntry,G0H16(14),ex3(:),G0H8(1),m3h2x8(:,68),heltab2x16(:,:,68))
  call Hloop_Q_A(ntry,G0H8(1),37,nMB,G1H8(34),n2h8(74))
  call Hloop_QA_V(ntry,G1H16(2),ex2(:),G1H8(35),m3h2x8(:,69),heltab2x16(:,:,69))
  call Hloop_QA_V(ntry,G1H16(4),ex2(:),G1H8(36),m3h2x8(:,70),heltab2x16(:,:,70))
  call Hloop_QA_V(ntry,G1H16(5),ex2(:),G1H8(39),m3h2x8(:,71),heltab2x16(:,:,71))
  call Hloop_QA_V(ntry,G1H16(6),ex2(:),G1H8(40),m3h2x8(:,72),heltab2x16(:,:,72))
  call Hloop_VA_Q(ntry,G0H16(15),ex4(:),G0H8(1),m3h2x8(:,73),heltab2x16(:,:,73))
  call Hloop_A_Q(ntry,G0H8(1),42,nMB,G1H8(41),n2h8(75))
  call Hloop_AQ_V(ntry,G1H16(7),ex1(:),G1H8(42),m3h2x8(:,74),heltab2x16(:,:,74))
  call Hloop_AQ_V(ntry,G1H16(8),ex1(:),G1H8(45),m3h2x8(:,75),heltab2x16(:,:,75))
  call Hloop_VQ_A(ntry,G0H16(16),ex3(:),G0H8(1),m3h2x8(:,76),heltab2x16(:,:,76))
  call Hloop_Q_A(ntry,G0H8(1),38,nMB,G1H8(46),n2h8(76))
  call Hloop_AQ_V(ntry,G1H16(10),ex1(:),G1H8(47),m3h2x8(:,77),heltab2x16(:,:,77))
  call Hloop_AQ_V(ntry,G1H16(11),ex1(:),G1H8(48),m3h2x8(:,78),heltab2x16(:,:,78))
  call Hloop_AQ_V(ntry,G1H16(12),ex1(:),G1H8(51),m3h2x8(:,79),heltab2x16(:,:,79))
  call Hloop_AQ_V(ntry,G1H16(13),ex1(:),G1H8(52),m3h2x8(:,80),heltab2x16(:,:,80))
  call Hloop_QA_V(ntry,G1H16(14),ex4(:),G1H8(53),m3h2x8(:,81),heltab2x16(:,:,81))
  call Hloop_VA_Q(ntry,G0H16(17),ex2(:),G0H8(1),m3h2x8(:,82),heltab2x16(:,:,82))
  call Hloop_A_Q(ntry,G0H8(1),38,nMT,G1H8(54),n2h8(77))
  call Hloop_QA_V(ntry,G1H16(16),ex4(:),G1H8(57),m3h2x8(:,83),heltab2x16(:,:,83))
  call Hloop_VA_Q(ntry,G0H16(18),ex2(:),G0H8(1),m3h2x8(:,84),heltab2x16(:,:,84))
  call Hloop_A_Q(ntry,G0H8(1),38,nMT,G1H8(58),n2h8(78))
  call Hloop_VQ_A(ntry,G0H16(19),ex1(:),G0H8(1),m3h2x8(:,85),heltab2x16(:,:,85))
  call Hloop_Q_A(ntry,G0H8(1),37,nMT,G1H8(59),n2h8(79))
  call Hloop_VQ_A(ntry,G0H16(20),ex1(:),G0H8(1),m3h2x8(:,86),heltab2x16(:,:,86))
  call Hloop_Q_A(ntry,G0H8(1),37,nMT,G1H8(60),n2h8(80))
  call Hloop_VA_Q(ntry,G0H16(21),ex2(:),G0H8(1),m3h2x8(:,87),heltab2x16(:,:,87))
  call Hloop_A_Q(ntry,G0H8(1),38,nMT,G1H8(63),n2h8(81))
  call Hloop_VQ_A(ntry,G0H16(22),ex1(:),G0H8(1),m3h2x8(:,88),heltab2x16(:,:,88))
  call Hloop_Q_A(ntry,G0H8(1),37,nMT,G1H8(64),n2h8(82))
  call Hloop_AQ_V(ntry,G1H16(17),ex3(:),G1H8(65),m3h2x8(:,89),heltab2x16(:,:,89))
  call Hloop_VA_Q(ntry,G0H16(23),ex2(:),G0H8(1),m3h2x8(:,90),heltab2x16(:,:,90))
  call Hloop_A_Q(ntry,G0H8(1),42,nMT,G1H8(66),n2h8(83))
  call Hloop_AQ_V(ntry,G1H16(18),ex3(:),G1H8(69),m3h2x8(:,91),heltab2x16(:,:,91))
  call Hloop_VA_Q(ntry,G0H16(24),ex2(:),G0H8(1),m3h2x8(:,92),heltab2x16(:,:,92))
  call Hloop_A_Q(ntry,G0H8(1),42,nMT,G1H8(70),n2h8(84))
  call Hloop_VQ_A(ntry,G0H16(25),ex1(:),G0H8(1),m3h2x8(:,93),heltab2x16(:,:,93))
  call Hloop_Q_A(ntry,G0H8(1),41,nMT,G1H8(71),n2h8(85))
  call Hloop_VQ_A(ntry,G0H16(26),ex1(:),G0H8(1),m3h2x8(:,94),heltab2x16(:,:,94))
  call Hloop_Q_A(ntry,G0H8(1),41,nMT,G1H8(72),n2h8(86))
  call Hloop_VA_Q(ntry,G0H16(27),ex2(:),G0H8(1),m3h2x8(:,95),heltab2x16(:,:,95))
  call Hloop_A_Q(ntry,G0H8(1),42,nMT,G1H8(75),n2h8(87))
  call Hloop_VQ_A(ntry,G0H16(28),ex1(:),G0H8(1),m3h2x8(:,96),heltab2x16(:,:,96))
  call Hloop_Q_A(ntry,G0H8(1),41,nMT,G1H8(76),n2h8(88))
  call Hloop_AQ_V(ntry,G1H16(19),ex3(:),G1H8(77),m3h2x8(:,97),heltab2x16(:,:,97))
  call Hloop_AQ_V(ntry,G1H16(23),ex3(:),G1H8(78),m3h2x8(:,98),heltab2x16(:,:,98))
  call Hloop_AQ_V(ntry,G1H16(27),ex1(:),G1H8(81),m3h2x8(:,99),heltab2x16(:,:,99))
  call Hloop_AQ_V(ntry,G1H16(28),ex1(:),G1H8(82),m3h2x8(:,100),heltab2x16(:,:,100))
call HGT_w2_OLR(G1H8(1),1,1,8)
call HGT_w2_invQ_OLR(G1H8(1),2,5,8)
  call ol_merge(ntry,G1H8(1),[G1H8(75)])
  call ol_merge(ntry,G1H8(63),[G1H8(127)])
call HGT_w2_OLR(G1H8(2),1,1,8)
call HGT_w2_invQ_OLR(G1H8(2),2,5,8)
  call ol_merge(ntry,G1H8(2),[G1H8(63)])
call HGT_w2_OLR(G1H8(3),1,1,8)
call HGT_w2_invQ_OLR(G1H8(3),2,5,8)
  call ol_merge(ntry,G1H8(3),[G1H8(76)])
  call ol_merge(ntry,G1H8(64),[G1H8(115)])
call HGT_w2_OLR(G1H8(4),1,1,8)
call HGT_w2_invQ_OLR(G1H8(4),2,5,8)
  call ol_merge(ntry,G1H8(4),[G1H8(64)])
  call ol_merge(ntry,G1H8(65),[G1H8(7)])
  call ol_merge(ntry,G2H8(32),[G1H8(26),G1H8(8)])
  call ol_merge(ntry,G1H8(42),[G1H8(13)])
  call ol_merge(ntry,G2H8(24),[G1H8(80),G1H8(14)])
  call ol_merge(ntry,G1H8(45),[G1H8(19)])
  call ol_merge(ntry,G2H8(28),[G1H8(86),G1H8(20)])
  call ol_merge(ntry,G1H8(53),[G1H8(25)])
  call ol_merge(ntry,G1H8(47),[G1H8(37)])
  call ol_merge(ntry,G2H8(20),[G1H8(92),G1H8(38)])
  call ol_merge(ntry,G1H8(48),[G1H8(43)])
  call ol_merge(ntry,G2H8(26),[G1H8(98),G1H8(44)])
  call ol_merge(ntry,G1H8(69),[G1H8(49)])
  call ol_merge(ntry,G2H8(30),[G1H8(56),G1H8(50)])
  call ol_merge(ntry,G1H8(57),[G1H8(55)])
  call ol_merge(ntry,G1H8(51),[G1H8(67)])
  call ol_merge(ntry,G2H8(18),[G1H8(104),G1H8(68)])
  call ol_merge(ntry,G1H8(52),[G1H8(73)])
  call ol_merge(ntry,G2H8(22),[G1H8(110),G1H8(74)])
  call ol_merge(ntry,G1H8(30),[G1H8(79)])
  call ol_merge(ntry,G1H8(33),[G1H8(85)])
  call ol_merge(ntry,G1H8(35),[G1H8(91)])
  call ol_merge(ntry,G1H8(36),[G1H8(97)])
  call ol_merge(ntry,G1H8(39),[G1H8(103)])
  call ol_merge(ntry,G1H8(40),[G1H8(109)])
  call Hloop_AV_Q(ntry,G1H8(1),ex5(:),G1H4(86),m3h2x4(:,121),heltab2x8(:,:,121))
  call Hloop_A_Q(ntry,G1H4(86),58,nMT,G2H4(13),n2h4(97))
  call Hloop_AQ_V(ntry,G2H8(38),ex1(:),G2H4(15),m3h2x4(:,122),heltab2x8(:,:,122))
  call Hloop_AV_Q(ntry,G1H8(2),ex5(:),G1H4(98),m3h2x4(:,123),heltab2x8(:,:,123))
  call Hloop_A_Q(ntry,G1H4(98),54,nMT,G2H4(16),n2h4(98))
  call Hloop_AQ_V(ntry,G2H8(42),ex1(:),G2H4(18),m3h2x4(:,124),heltab2x8(:,:,124))
  call Hloop_QV_A(ntry,G1H8(3),ex5(:),G1H4(110),m3h2x4(:,125),heltab2x8(:,:,125))
  call Hloop_Q_A(ntry,G1H4(110),57,nMT,G2H4(19),n2h4(99))
  call Hloop_QA_V(ntry,G2H8(46),ex2(:),G2H4(21),m3h2x4(:,126),heltab2x8(:,:,126))
  call Hloop_QV_A(ntry,G1H8(4),ex5(:),G1H4(122),m3h2x4(:,127),heltab2x8(:,:,127))
  call Hloop_Q_A(ntry,G1H4(122),53,nMT,G2H4(22),n2h4(100))
  call Hloop_QA_V(ntry,G2H8(50),ex2(:),G2H4(24),m3h2x4(:,128),heltab2x8(:,:,128))
  call Hloop_VQ_A(ntry,G1H8(65),ex1(:),G1H4(134),m3h2x4(:,129),heltab2x8(:,:,129))
  call Hloop_Q_A(ntry,G1H4(134),45,nMT,G2H4(25),n2h4(101))
call Hotf_5pt_reduction(G2H8(32),RedSet_5(37),mass5set(:,12),  & 
G1H8(83),G1H8(84),G1H8(87),G1H8(88),G1H8(89),G1H8(90),8)
call HG1shiftOLR(G1H8(84),16,8)
  call Hloop_VQ_A(ntry,G1H8(42),ex3(:),G1H4(146),m3h2x4(:,130),heltab2x8(:,:,130))
  call Hloop_Q_A(ntry,G1H4(146),39,nMB,G2H4(28),n2h4(102))
call Hotf_5pt_reduction(G2H8(24),RedSet_5(38),mass5set(:,13),  & 
G1H8(93),G1H8(94),G1H8(95),G1H8(96),G1H8(99),G1H8(100),8)
call HG1shiftOLR(G1H8(94),16,8)
  call Hloop_VQ_A(ntry,G1H8(45),ex3(:),G1H4(158),m3h2x4(:,131),heltab2x8(:,:,131))
  call Hloop_Q_A(ntry,G1H4(158),39,nMB,G2H4(29),n2h4(103))
call Hotf_5pt_reduction(G2H8(28),RedSet_5(39),mass5set(:,14),  & 
G1H8(101),G1H8(102),G1H8(105),G1H8(106),G1H8(107),G1H8(108),8)
call HG1shiftOLR(G1H8(102),8,8)
  call Hloop_VQ_A(ntry,G1H8(53),ex1(:),G1H4(170),m3h2x4(:,132),heltab2x8(:,:,132))
  call Hloop_Q_A(ntry,G1H4(170),45,nMT,G2H4(32),n2h4(104))
  call Hloop_VA_Q(ntry,G1H8(31),ex2(:),G1H4(182),m3h2x4(:,133),heltab2x8(:,:,133))
  call Hloop_A_Q(ntry,G1H4(182),54,nMT,G2H4(33),n2h4(105))
  call Hloop_VA_Q(ntry,G1H8(32),ex2(:),G1H4(194),m3h2x4(:,134),heltab2x8(:,:,134))
  call Hloop_A_Q(ntry,G1H4(194),54,nMT,G2H4(35),n2h4(106))
  call Hloop_VA_Q(ntry,G1H8(47),ex4(:),G1H4(206),m3h2x4(:,135),heltab2x8(:,:,135))
  call Hloop_A_Q(ntry,G1H4(206),43,nMB,G2H4(36),n2h4(107))
call Hotf_5pt_reduction(G2H8(20),RedSet_5(40),mass5set(:,13),  & 
G1H8(111),G1H8(112),G1H8(113),G1H8(114),G1H8(117),G1H8(118),8)
call HG1shiftOLR(G1H8(112),16,8)
  call Hloop_VA_Q(ntry,G1H8(48),ex4(:),G1H4(218),m3h2x4(:,136),heltab2x8(:,:,136))
  call Hloop_A_Q(ntry,G1H4(218),43,nMB,G2H4(39),n2h4(108))
call Hotf_5pt_reduction(G2H8(26),RedSet_5(41),mass5set(:,14),  & 
G1H8(119),G1H8(120),G1H8(123),G1H8(124),G1H8(125),G1H8(126),8)
call HG1shiftOLR(G1H8(120),4,8)
  call Hloop_VA_Q(ntry,G1H8(69),ex2(:),G1H4(9),m3h2x4(:,137),heltab2x8(:,:,137))
  call Hloop_A_Q(ntry,G1H4(9),46,nMT,G2H4(40),n2h4(109))
call Hotf_5pt_reduction(G2H8(30),RedSet_5(42),mass5set(:,12),  & 
G1H8(129),G1H8(130),G1H8(131),G1H8(132),G1H8(135),G1H8(136),8)
call HG1shiftOLR(G1H8(130),16,8)
  call Hloop_VA_Q(ntry,G1H8(57),ex2(:),G1H4(10),m3h2x4(:,138),heltab2x8(:,:,138))
  call Hloop_A_Q(ntry,G1H4(10),46,nMT,G2H4(43),n2h4(110))
  call Hloop_VQ_A(ntry,G1H8(61),ex1(:),G1H4(14),m3h2x4(:,139),heltab2x8(:,:,139))
  call Hloop_Q_A(ntry,G1H4(14),53,nMT,G2H4(44),n2h4(111))
  call Hloop_VQ_A(ntry,G1H8(62),ex1(:),G1H4(15),m3h2x4(:,140),heltab2x8(:,:,140))
  call Hloop_Q_A(ntry,G1H4(15),53,nMT,G2H4(47),n2h4(112))
  call Hloop_UV_W(ntry,G1H8(51),35,ex5(:),16,G2H4(48),m3h2x4(:,141),heltab2x8(:,:,141))
call Hotf_5pt_reduction(G2H8(18),RedSet_5(43),mass5set(:,15),  & 
G1H8(137),G1H8(138),G1H8(141),G1H8(142),G1H8(143),G1H8(144),8)
call HG1shiftOLR(G1H8(138),8,8)
  call Hloop_UV_W(ntry,G1H8(52),35,ex5(:),16,G2H4(50),m3h2x4(:,142),heltab2x8(:,:,142))
call Hotf_5pt_reduction(G2H8(22),RedSet_5(44),mass5set(:,15),  & 
G1H8(147),G1H8(148),G1H8(5),G1H8(6),G1H8(9),G1H8(10),8)
call HG1shiftOLR(G1H8(148),4,8)
  call Hloop_VQ_A(ntry,G1H8(30),ex3(:),G1H4(16),m3h2x4(:,143),heltab2x8(:,:,143))
  call Hloop_Q_A(ntry,G1H4(16),39,nMB,G2H4(51),n2h4(113))
  call Hloop_VQ_A(ntry,G1H8(33),ex3(:),G1H4(20),m3h2x4(:,144),heltab2x8(:,:,144))
  call Hloop_Q_A(ntry,G1H4(20),39,nMB,G2H4(54),n2h4(114))
  call Hloop_VA_Q(ntry,G1H8(35),ex4(:),G1H4(21),m3h2x4(:,145),heltab2x8(:,:,145))
  call Hloop_A_Q(ntry,G1H4(21),43,nMB,G2H4(55),n2h4(115))
  call Hloop_VA_Q(ntry,G1H8(36),ex4(:),G1H4(22),m3h2x4(:,146),heltab2x8(:,:,146))
  call Hloop_A_Q(ntry,G1H4(22),43,nMB,G2H4(58),n2h4(116))
  call Hloop_UV_W(ntry,G1H8(39),35,ex5(:),16,G2H4(59),m3h2x4(:,147),heltab2x8(:,:,147))
  call Hloop_UV_W(ntry,G1H8(40),35,ex5(:),16,G2H4(62),m3h2x4(:,148),heltab2x8(:,:,148))
  call Hloop_QV_A(ntry,G1H8(116),ex5(:),G1H4(26),m3h2x4(:,149),heltab2x8(:,:,149))
  call Hloop_Q_A(ntry,G1H4(26),53,nMT,G2H4(63),n2h4(117))
  call Hloop_QV_A(ntry,G1H8(121),ex5(:),G1H4(27),m3h2x4(:,150),heltab2x8(:,:,150))
  call Hloop_Q_A(ntry,G1H4(27),53,nMB,G2H4(65),n2h4(118))
  call Hloop_QV_A(ntry,G1H8(122),ex5(:),G1H4(28),m3h2x4(:,151),heltab2x8(:,:,151))
  call Hloop_Q_A(ntry,G1H4(28),53,nMB,G2H4(66),n2h4(119))
  call Hloop_AV_Q(ntry,G1H8(128),ex5(:),G1H4(32),m3h2x4(:,152),heltab2x8(:,:,152))
  call Hloop_A_Q(ntry,G1H4(32),54,nMT,G2H4(68),n2h4(120))
  call Hloop_AV_Q(ntry,G1H8(133),ex5(:),G1H4(33),m3h2x4(:,153),heltab2x8(:,:,153))
  call Hloop_A_Q(ntry,G1H4(33),57,nMB,G2H4(69),n2h4(121))
  call Hloop_AV_Q(ntry,G1H8(134),ex5(:),G1H4(34),m3h2x4(:,154),heltab2x8(:,:,154))
  call Hloop_A_Q(ntry,G1H4(34),57,nMB,G2H4(72),n2h4(122))
  call Hloop_VA_Q(ntry,G1H8(139),ex4(:),G1H4(38),m3h2x4(:,155),heltab2x8(:,:,155))
  call Hloop_A_Q(ntry,G1H4(38),57,nMB,G2H4(73),n2h4(123))
  call Hloop_VA_Q(ntry,G1H8(140),ex4(:),G1H4(39),m3h2x4(:,156),heltab2x8(:,:,156))
  call Hloop_A_Q(ntry,G1H4(39),57,nMB,G2H4(75),n2h4(124))
  call Hloop_VQ_A(ntry,G1H8(145),ex3(:),G1H4(40),m3h2x4(:,157),heltab2x8(:,:,157))
  call Hloop_Q_A(ntry,G1H4(40),53,nMB,G2H4(76),n2h4(125))
  call Hloop_VQ_A(ntry,G1H8(146),ex3(:),G1H4(44),m3h2x4(:,158),heltab2x8(:,:,158))
  call Hloop_Q_A(ntry,G1H4(44),53,nMB,G2H4(79),n2h4(126))
  call Hloop_AQ_V(ntry,G2H8(9),ex1(:),G2H4(80),m3h2x4(:,159),heltab2x8(:,:,159))
  call Hloop_AQ_V(ntry,G2H8(10),ex1(:),G2H4(82),m3h2x4(:,160),heltab2x8(:,:,160))
  call Hloop_QA_V(ntry,G2H8(11),ex2(:),G2H4(83),m3h2x4(:,161),heltab2x8(:,:,161))
  call Hloop_QA_V(ntry,G2H8(12),ex2(:),G2H4(85),m3h2x4(:,162),heltab2x8(:,:,162))
  call Hloop_AQ_V(ntry,G2H8(13),ex1(:),G2H4(86),m3h2x4(:,163),heltab2x8(:,:,163))
  call Hloop_AQ_V(ntry,G2H8(14),ex1(:),G2H4(88),m3h2x4(:,164),heltab2x8(:,:,164))
  call Hloop_QA_V(ntry,G2H8(15),ex2(:),G2H4(89),m3h2x4(:,165),heltab2x8(:,:,165))
  call Hloop_QA_V(ntry,G2H8(16),ex2(:),G2H4(92),m3h2x4(:,166),heltab2x8(:,:,166))
call Hotf_5pt_reduction(G2H8(17),RedSet_5(43),mass5set(:,16),  & 
G1H8(11),G1H8(12),G1H8(15),G1H8(16),G1H8(17),G1H8(18),8)
call HG1shiftOLR(G1H8(12),8,8)
  call Hloop_QA_V(ntry,G2H8(19),ex4(:),G2H4(93),m3h2x4(:,167),heltab2x8(:,:,167))
call Hotf_5pt_reduction(G2H8(21),RedSet_5(44),mass5set(:,16),  & 
G1H8(21),G1H8(22),G1H8(23),G1H8(24),G1H8(27),G1H8(28),8)
call HG1shiftOLR(G1H8(22),4,8)
  call Hloop_VA_Q(ntry,G1H16(3),ex4(:),G1H8(75),m3h2x8(:,101),heltab2x16(:,:,101))
  call Hloop_A_Q(ntry,G1H8(75),44,nMB,G2H8(33),n2h8(89))
  call Hloop_QA_V(ntry,G2H16(1),ex4(:),G2H8(34),m3h2x8(:,102),heltab2x16(:,:,102))
  call Hloop_AQ_V(ntry,G2H8(23),ex3(:),G2H4(96),m3h2x4(:,168),heltab2x8(:,:,168))
  call Hloop_VQ_A(ntry,G1H16(15),ex3(:),G1H8(127),m3h2x8(:,103),heltab2x16(:,:,103))
  call Hloop_Q_A(ntry,G1H8(127),44,nMB,G2H8(35),n2h8(90))
  call Hloop_AQ_V(ntry,G2H16(2),ex3(:),G2H8(36),m3h2x8(:,104),heltab2x16(:,:,104))
  call Hloop_QA_V(ntry,G2H8(25),ex4(:),G2H4(97),m3h2x4(:,169),heltab2x8(:,:,169))
call Hotf_5pt_reduction(G2H16(3),RedSet_5(45),mass5set(:,17),  & 
G1H16(20),G1H16(1),G1H16(2),G1H16(4),G1H16(5),G1H16(6),16)
call HG1shiftOLR(G1H16(1),8,16)
  call Hloop_UV_W(ntry,G1H16(24),36,ex5(:),16,G2H8(37),m3h2x8(:,105),heltab2x16(:,:,105))
  call Hloop_AQ_V(ntry,G2H8(27),ex3(:),G2H4(100),m3h2x4(:,170),heltab2x8(:,:,170))
  call Hloop_UV_W(ntry,G1H16(25),40,wf4(:,1),3,G2H4(101),m3h4x4(:,1),heltab2x16(:,:,106))
call Hotf_5pt_reduction(G2H16(4),RedSet_5(46),mass5set(:,18),  & 
G1H16(7),G1H16(8),G1H16(10),G1H16(11),G1H16(12),G1H16(13),16)
call HG1shiftOLR(G1H16(8),16,16)
call Hotf_5pt_reduction(G2H16(5),RedSet_5(47),mass5set(:,17),  & 
G1H16(14),G1H16(16),G1H16(17),G1H16(18),G1H16(19),G1H16(23),16)
call HG1shiftOLR(G1H16(16),8,16)
  call Hloop_UV_W(ntry,G1H16(22),36,wf4(:,1),3,G2H4(104),m3h4x4(:,2),heltab2x16(:,:,107))
  call Hloop_UV_W(ntry,G1H16(21),36,wf4(:,1),3,G2H4(105),m3h4x4(:,3),heltab2x16(:,:,108))
call Hotf_5pt_reduction(G2H16(6),RedSet_5(48),mass5set(:,18),  & 
G1H16(27),G1H16(28),G1H16(3),G1H16(15),G1H16(24),G1H16(25),16)
call HG1shiftOLR(G1H16(28),16,16)
  call Hloop_VQ_A(ntry,G1H16(9),ex1(:),G1H8(63),m3h2x8(:,106),heltab2x16(:,:,109))
  call Hloop_Q_A(ntry,G1H8(63),35,nMT,G2H8(39),n2h8(91))
  call Hloop_AQ_V(ntry,G2H16(7),ex1(:),G2H8(40),m3h2x8(:,107),heltab2x16(:,:,110))
  call Hloop_QA_V(ntry,G2H8(29),ex2(:),G2H4(108),m3h2x4(:,171),heltab2x8(:,:,171))
  call Hloop_VA_Q(ntry,G1H16(26),ex2(:),G1H8(76),m3h2x8(:,108),heltab2x16(:,:,111))
  call Hloop_A_Q(ntry,G1H8(76),35,nMT,G2H8(41),n2h8(92))
  call Hloop_QA_V(ntry,G2H16(8),ex2(:),G2H8(43),m3h2x8(:,109),heltab2x16(:,:,112))
  call Hloop_VA_Q(ntry,G1H16(29),ex2(:),G1H8(115),m3h2x8(:,110),heltab2x16(:,:,113))
  call Hloop_A_Q(ntry,G1H8(115),35,nMT,G2H8(44),n2h8(93))
  call Hloop_QA_V(ntry,G2H16(9),ex2(:),G2H8(45),m3h2x8(:,111),heltab2x16(:,:,114))
  call Hloop_AQ_V(ntry,G2H8(31),ex1(:),G2H4(109),m3h2x4(:,172),heltab2x8(:,:,172))
  call Hloop_VQ_A(ntry,G1H16(30),ex1(:),G1H8(64),m3h2x8(:,112),heltab2x16(:,:,115))
  call Hloop_Q_A(ntry,G1H8(64),35,nMT,G2H8(47),n2h8(94))
  call Hloop_AQ_V(ntry,G2H16(10),ex1(:),G2H8(48),m3h2x8(:,113),heltab2x16(:,:,116))
  call Hloop_UV_W(ntry,G1H16(31),33,ex5(:),16,G2H8(49),m3h2x8(:,114),heltab2x16(:,:,117))
call Hotf_5pt_reduction(G2H16(11),RedSet_5(2),mass5set(:,1),  & 
G1H16(22),G1H16(21),G1H16(9),G1H16(26),G1H16(29),G1H16(30),16)
call HG1shiftOLR(G1H16(21),12,16)
call Hotf_5pt_reduction(G2H16(12),RedSet_5(49),mass5set(:,19),  & 
G1H16(31),G1H16(53),G1H16(54),G1H16(55),G1H16(56),G1H16(57),16)
call HG1shiftOLR(G1H16(53),2,16)
  call Hloop_UV_W(ntry,G1H16(32),33,ex5(:),16,G2H8(51),m3h2x8(:,115),heltab2x16(:,:,118))
  call Hloop_UV_W(ntry,G1H16(33),34,ex5(:),16,G2H8(52),m3h2x8(:,116),heltab2x16(:,:,119))
call Hotf_5pt_reduction(G2H16(13),RedSet_5(1),mass5set(:,1),  & 
G1H16(32),G1H16(33),G1H16(58),G1H16(59),G1H16(60),G1H16(61),16)
call HG1shiftOLR(G1H16(33),12,16)
  call Hloop_UV_W(ntry,G1H16(34),34,wf4(:,2),12,G2H4(112),m3h4x4(:,4),heltab2x16(:,:,120))
call Hotf_5pt_reduction(G2H16(14),RedSet_5(50),mass5set(:,1),  & 
G1H16(34),G1H16(62),G1H16(63),G1H16(64),G1H16(65),G1H16(66),16)
call HG1shiftOLR(G1H16(62),16,16)
call Hotf_5pt_reduction(G2H16(15),RedSet_5(51),mass5set(:,19),  & 
G1H16(67),G1H16(68),G1H16(69),G1H16(70),G1H16(71),G1H16(72),16)
call HG1shiftOLR(G1H16(68),2,16)
  call Hloop_UV_W(ntry,G1H16(35),33,wf4(:,2),12,G2H4(1),m3h4x4(:,5),heltab2x16(:,:,121))
  call Hloop_UV_W(ntry,G1H16(36),33,wf4(:,2),12,G2H4(2),m3h4x4(:,6),heltab2x16(:,:,122))
call Hotf_5pt_reduction(G2H16(16),RedSet_5(52),mass5set(:,1),  & 
G1H16(35),G1H16(36),G1H16(73),G1H16(74),G1H16(75),G1H16(76),16)
call HG1shiftOLR(G1H16(36),16,16)
  call Hloop_VQ_A(ntry,G1H16(37),ex3(:),G1H8(7),m3h2x8(:,117),heltab2x16(:,:,123))
  call Hloop_Q_A(ntry,G1H8(7),38,nMB,G2H8(1),n2h8(95))
  call Hloop_AQ_V(ntry,G2H16(17),ex3(:),G2H8(2),m3h2x8(:,118),heltab2x16(:,:,124))
  call Hloop_VA_Q(ntry,G1H16(38),ex2(:),G1H8(26),m3h2x8(:,119),heltab2x16(:,:,125))
  call Hloop_A_Q(ntry,G1H8(26),38,nMT,G2H8(3),n2h8(96))
  call Hloop_VA_Q(ntry,G1H16(39),ex4(:),G1H8(8),m3h2x8(:,120),heltab2x16(:,:,126))
  call Hloop_A_Q(ntry,G1H8(8),42,nMB,G2H8(4),n2h8(97))
  call Hloop_QA_V(ntry,G2H16(18),ex4(:),G2H8(5),m3h2x8(:,121),heltab2x16(:,:,127))
  call Hloop_VQ_A(ntry,G1H16(40),wf4(:,14),G1H4(45),m3h4x4(:,7),heltab2x16(:,:,128))
  call Hloop_Q_A(ntry,G1H4(45),53,nMT,G2H4(3),n2h4(127))
  call Hloop_AQ_V(ntry,G2H16(19),wf4(:,14),G2H4(4),m3h4x4(:,8),heltab2x16(:,:,129))
  call Hloop_AQ_V(ntry,G2H16(20),wf4(:,14),G2H4(5),m3h4x4(:,9),heltab2x16(:,:,130))
  call Hloop_VQ_A(ntry,G1H16(41),ex3(:),G1H8(13),m3h2x8(:,122),heltab2x16(:,:,131))
  call Hloop_Q_A(ntry,G1H8(13),37,nMB,G2H8(6),n2h8(98))
  call Hloop_AQ_V(ntry,G2H16(21),ex3(:),G2H8(7),m3h2x8(:,123),heltab2x16(:,:,132))
  call Hloop_VQ_A(ntry,G1H16(42),ex1(:),G1H8(80),m3h2x8(:,124),heltab2x16(:,:,133))
  call Hloop_Q_A(ntry,G1H8(80),37,nMT,G2H8(8),n2h8(99))
  call Hloop_VA_Q(ntry,G1H16(43),ex4(:),G1H8(14),m3h2x8(:,125),heltab2x16(:,:,134))
  call Hloop_A_Q(ntry,G1H8(14),41,nMB,G2H8(38),n2h8(100))
  call Hloop_QA_V(ntry,G2H16(22),ex4(:),G2H8(42),m3h2x8(:,126),heltab2x16(:,:,135))
  call Hloop_VA_Q(ntry,G1H16(44),wf4(:,19),G1H4(46),m3h4x4(:,10),heltab2x16(:,:,136))
  call Hloop_A_Q(ntry,G1H4(46),54,nMT,G2H4(6),n2h4(128))
  call Hloop_QA_V(ntry,G2H16(23),wf4(:,19),G2H4(7),m3h4x4(:,11),heltab2x16(:,:,137))
  call Hloop_QA_V(ntry,G2H16(24),wf4(:,19),G2H4(8),m3h4x4(:,12),heltab2x16(:,:,138))
  call Hloop_AQ_V(ntry,G2H16(25),ex1(:),G2H8(46),m3h2x8(:,127),heltab2x16(:,:,139))
  call Hloop_VQ_A(ntry,G1H16(45),ex1(:),G1H8(19),m3h2x8(:,128),heltab2x16(:,:,140))
  call Hloop_Q_A(ntry,G1H8(19),41,nMT,G2H8(50),n2h8(101))
  call Hloop_QA_V(ntry,G2H16(26),ex2(:),G2H8(32),m3h2x8(:,129),heltab2x16(:,:,141))
  call Hloop_QA_V(ntry,G2H16(27),ex2(:),G2H8(24),m3h2x8(:,130),heltab2x16(:,:,142))
  call Hloop_VA_Q(ntry,G1H16(46),ex2(:),G1H8(86),m3h2x8(:,131),heltab2x16(:,:,143))
  call Hloop_A_Q(ntry,G1H8(86),42,nMT,G2H8(28),n2h8(102))
  call Hloop_AQ_V(ntry,G2H16(28),ex1(:),G2H8(20),m3h2x8(:,132),heltab2x16(:,:,144))
  call Hloop_VA_Q(ntry,G1H16(47),ex4(:),G1H8(20),m3h2x8(:,133),heltab2x16(:,:,145))
  call Hloop_A_Q(ntry,G1H8(20),41,nMB,G2H8(26),n2h8(103))
  call Hloop_VQ_A(ntry,G1H16(48),wf4(:,6),G1H4(50),m3h4x4(:,13),heltab2x16(:,:,146))
  call Hloop_Q_A(ntry,G1H4(50),53,nMB,G2H4(9),n2h4(129))
  call Hloop_AQ_V(ntry,G2H16(29),ex1(:),G2H8(30),m3h2x8(:,134),heltab2x16(:,:,147))
  call Hloop_VQ_A(ntry,G1H16(49),ex1(:),G1H8(25),m3h2x8(:,135),heltab2x16(:,:,148))
  call Hloop_Q_A(ntry,G1H8(25),37,nMT,G2H8(18),n2h8(104))
  call Hloop_QA_V(ntry,G2H16(30),ex2(:),G2H8(22),m3h2x8(:,136),heltab2x16(:,:,149))
  call Hloop_QA_V(ntry,G2H16(31),ex2(:),G2H8(9),m3h2x8(:,137),heltab2x16(:,:,150))
  call Hloop_VA_Q(ntry,G1H16(50),ex2(:),G1H8(37),m3h2x8(:,138),heltab2x16(:,:,151))
  call Hloop_A_Q(ntry,G1H8(37),38,nMT,G2H8(10),n2h8(105))
  call Hloop_AQ_V(ntry,G2H16(32),ex1(:),G2H8(11),m3h2x8(:,139),heltab2x16(:,:,152))
  call Hloop_VQ_A(ntry,G1H16(51),ex3(:),G1H8(92),m3h2x8(:,140),heltab2x16(:,:,153))
  call Hloop_Q_A(ntry,G1H8(92),37,nMB,G2H8(12),n2h8(106))
  call Hloop_VA_Q(ntry,G1H16(52),wf4(:,11),G1H4(51),m3h4x4(:,14),heltab2x16(:,:,154))
  call Hloop_A_Q(ntry,G1H4(51),57,nMB,G2H4(10),n2h4(130))
  call Hloop_AQ_V(ntry,G1H8(29),ex3(:),G1H4(52),m3h2x4(:,173),heltab2x8(:,:,173))
  call Hloop_QA_V(ntry,G1H8(34),ex4(:),G1H4(56),m3h2x4(:,174),heltab2x8(:,:,174))
  call Hloop_AQ_V(ntry,G1H8(41),ex3(:),G1H4(57),m3h2x4(:,175),heltab2x8(:,:,175))
  call Hloop_QA_V(ntry,G1H8(46),ex4(:),G1H4(58),m3h2x4(:,176),heltab2x8(:,:,176))
  call Hloop_AQ_V(ntry,G1H8(54),ex1(:),G1H4(62),m3h2x4(:,177),heltab2x8(:,:,177))
  call Hloop_AQ_V(ntry,G1H8(58),ex1(:),G1H4(63),m3h2x4(:,178),heltab2x8(:,:,178))
  call Hloop_QA_V(ntry,G1H8(59),ex2(:),G1H4(64),m3h2x4(:,179),heltab2x8(:,:,179))
  call Hloop_QA_V(ntry,G1H8(60),ex2(:),G1H4(68),m3h2x4(:,180),heltab2x8(:,:,180))
  call Hloop_AQ_V(ntry,G1H8(66),ex1(:),G1H4(69),m3h2x4(:,181),heltab2x8(:,:,181))
  call Hloop_AQ_V(ntry,G1H8(70),ex1(:),G1H4(70),m3h2x4(:,182),heltab2x8(:,:,182))
  call Hloop_QA_V(ntry,G1H8(71),ex2(:),G1H4(74),m3h2x4(:,183),heltab2x8(:,:,183))
  call Hloop_QA_V(ntry,G1H8(72),ex2(:),G1H4(75),m3h2x4(:,184),heltab2x8(:,:,184))
  call Hloop_VQ_A(ntry,G1H8(77),ex1(:),G1H4(76),m3h2x4(:,185),heltab2x8(:,:,185))
  call Hloop_Q_A(ntry,G1H4(76),53,nMT,G2H4(11),n2h4(131))
  call Hloop_VA_Q(ntry,G1H8(78),ex2(:),G1H4(80),m3h2x4(:,186),heltab2x8(:,:,186))
  call Hloop_A_Q(ntry,G1H4(80),54,nMT,G2H4(12),n2h4(132))
  call Hloop_VQ_A(ntry,G1H8(81),ex3(:),G1H4(81),m3h2x4(:,187),heltab2x8(:,:,187))
  call Hloop_Q_A(ntry,G1H4(81),53,nMB,G2H4(113),n2h4(133))
  call Hloop_VA_Q(ntry,G1H8(82),ex4(:),G1H4(82),m3h2x4(:,188),heltab2x8(:,:,188))
  call Hloop_A_Q(ntry,G1H4(82),57,nMB,G2H4(114),n2h4(134))
  call Hloop_VQ_A(ntry,G1H8(83),ex1(:),G1H4(87),m3h2x4(:,189),heltab2x8(:,:,189))
  call Hloop_Q_A(ntry,G1H4(87),45,nMT,G2H4(115),n2h4(135))
call HGT_raise_alpha_OLR(G1H8(84),1,1,8)
call HGT_raise_alpha_invQ_OLR(G1H8(84),2,5,8)
  call Hloop_UV_W(ntry,G1H8(84),-16,ex5(:),16,G2H4(116),m3h2x4(:,190),heltab2x8(:,:,190))
call signflip_OLR(G2H4(116))
  call Hloop_VQ_A(ntry,G1H8(88),ex1(:),G1H4(88),m3h2x4(:,191),heltab2x8(:,:,191))
  call Hloop_Q_A(ntry,G1H4(88),45,nMT,G2H4(117),n2h4(136))
  call Hloop_VQ_A(ntry,G1H8(89),ex1(:),G1H4(92),m3h2x4(:,192),heltab2x8(:,:,192))
  call Hloop_Q_A(ntry,G1H4(92),45,nMT,G2H4(118),n2h4(137))
  call Hloop_VQ_A(ntry,G1H8(90),ex1(:),G1H4(93),m3h2x4(:,193),heltab2x8(:,:,193))
  call Hloop_Q_A(ntry,G1H4(93),45,nMT,G2H4(119),n2h4(138))
  call Hloop_VQ_A(ntry,G1H8(93),ex3(:),G1H4(94),m3h2x4(:,194),heltab2x8(:,:,194))
  call Hloop_Q_A(ntry,G1H4(94),39,nMB,G2H4(120),n2h4(139))
call HGT_raise_alpha_OLR(G1H8(94),1,1,8)
call HGT_raise_alpha_invQ_OLR(G1H8(94),2,5,8)
  call Hloop_UV_W(ntry,G1H8(94),-16,ex5(:),16,G2H4(121),m3h2x4(:,195),heltab2x8(:,:,195))
call signflip_OLR(G2H4(121))
  call Hloop_VQ_A(ntry,G1H8(96),ex3(:),G1H4(99),m3h2x4(:,196),heltab2x8(:,:,196))
  call Hloop_Q_A(ntry,G1H4(99),39,nMB,G2H4(122),n2h4(140))
  call Hloop_VQ_A(ntry,G1H8(99),ex3(:),G1H4(100),m3h2x4(:,197),heltab2x8(:,:,197))
  call Hloop_Q_A(ntry,G1H4(100),39,nMB,G2H4(123),n2h4(141))
  call Hloop_VQ_A(ntry,G1H8(100),ex3(:),G1H4(104),m3h2x4(:,198),heltab2x8(:,:,198))
  call Hloop_Q_A(ntry,G1H4(104),39,nMB,G2H4(124),n2h4(142))
  call Hloop_VQ_A(ntry,G1H8(101),ex3(:),G1H4(105),m3h2x4(:,199),heltab2x8(:,:,199))
  call Hloop_Q_A(ntry,G1H4(105),39,nMB,G2H4(125),n2h4(143))
call HGT_raise_alpha_OLR(G1H8(102),1,1,8)
call HGT_raise_alpha_invQ_OLR(G1H8(102),2,5,8)
  call Hloop_VA_Q(ntry,G1H8(102),ex4(:),G1H4(106),m3h2x4(:,200),heltab2x8(:,:,200))
  call Hloop_VQ_A(ntry,G1H8(106),ex3(:),G1H4(111),m3h2x4(:,201),heltab2x8(:,:,201))
  call Hloop_Q_A(ntry,G1H4(111),39,nMB,G2H4(126),n2h4(144))
  call Hloop_VQ_A(ntry,G1H8(107),ex3(:),G1H4(112),m3h2x4(:,202),heltab2x8(:,:,202))
  call Hloop_Q_A(ntry,G1H4(112),39,nMB,G2H4(127),n2h4(145))
  call Hloop_VQ_A(ntry,G1H8(108),ex3(:),G1H4(116),m3h2x4(:,203),heltab2x8(:,:,203))
  call Hloop_Q_A(ntry,G1H4(116),39,nMB,G2H4(128),n2h4(146))
  call Hloop_VA_Q(ntry,G1H8(111),ex4(:),G1H4(117),m3h2x4(:,204),heltab2x8(:,:,204))
  call Hloop_A_Q(ntry,G1H4(117),43,nMB,G2H4(129),n2h4(147))
call HGT_raise_alpha_OLR(G1H8(112),1,1,8)
call HGT_raise_alpha_invQ_OLR(G1H8(112),2,5,8)
  call Hloop_UV_W(ntry,G1H8(112),-16,ex5(:),16,G2H4(130),m3h2x4(:,205),heltab2x8(:,:,205))
call signflip_OLR(G2H4(130))
  call Hloop_VA_Q(ntry,G1H8(114),ex4(:),G1H4(118),m3h2x4(:,206),heltab2x8(:,:,206))
  call Hloop_A_Q(ntry,G1H4(118),43,nMB,G2H4(131),n2h4(148))
  call Hloop_VA_Q(ntry,G1H8(117),ex4(:),G1H4(123),m3h2x4(:,207),heltab2x8(:,:,207))
  call Hloop_A_Q(ntry,G1H4(123),43,nMB,G2H4(132),n2h4(149))
  call Hloop_VA_Q(ntry,G1H8(118),ex4(:),G1H4(124),m3h2x4(:,208),heltab2x8(:,:,208))
  call Hloop_A_Q(ntry,G1H4(124),43,nMB,G2H4(133),n2h4(150))
  call Hloop_VA_Q(ntry,G1H8(119),ex4(:),G1H4(128),m3h2x4(:,209),heltab2x8(:,:,209))
  call Hloop_A_Q(ntry,G1H4(128),43,nMB,G2H4(134),n2h4(151))
call HGT_raise_alpha_OLR(G1H8(120),1,1,8)
call HGT_raise_alpha_invQ_OLR(G1H8(120),2,5,8)
  call Hloop_VQ_A(ntry,G1H8(120),ex3(:),G1H4(129),m3h2x4(:,210),heltab2x8(:,:,210))
  call Hloop_VA_Q(ntry,G1H8(124),ex4(:),G1H4(130),m3h2x4(:,211),heltab2x8(:,:,211))
  call Hloop_A_Q(ntry,G1H4(130),43,nMB,G2H4(135),n2h4(152))
  call Hloop_VA_Q(ntry,G1H8(125),ex4(:),G1H4(135),m3h2x4(:,212),heltab2x8(:,:,212))
  call Hloop_A_Q(ntry,G1H4(135),43,nMB,G2H4(136),n2h4(153))
  call Hloop_VA_Q(ntry,G1H8(126),ex4(:),G1H4(136),m3h2x4(:,213),heltab2x8(:,:,213))
  call Hloop_A_Q(ntry,G1H4(136),43,nMB,G2H4(137),n2h4(154))
  call Hloop_VA_Q(ntry,G1H8(129),ex2(:),G1H4(140),m3h2x4(:,214),heltab2x8(:,:,214))
  call Hloop_A_Q(ntry,G1H4(140),46,nMT,G2H4(138),n2h4(155))
call HGT_raise_alpha_OLR(G1H8(130),1,1,8)
call HGT_raise_alpha_invQ_OLR(G1H8(130),2,5,8)
  call Hloop_UV_W(ntry,G1H8(130),-16,ex5(:),16,G2H4(139),m3h2x4(:,215),heltab2x8(:,:,215))
call signflip_OLR(G2H4(139))
  call Hloop_VA_Q(ntry,G1H8(132),ex2(:),G1H4(141),m3h2x4(:,216),heltab2x8(:,:,216))
  call Hloop_A_Q(ntry,G1H4(141),46,nMT,G2H4(140),n2h4(156))
  call Hloop_VA_Q(ntry,G1H8(135),ex2(:),G1H4(142),m3h2x4(:,217),heltab2x8(:,:,217))
  call Hloop_A_Q(ntry,G1H4(142),46,nMT,G2H4(141),n2h4(157))



end subroutine vamp_1

end module ol_vamp_1_ppttjj_ttxbbxgg_1_/**/REALKIND
