
module ol_colourmatrix_ppttjj_ttxddxbbx_1_/**/REALKIND
  use KIND_TYPES, only: REALKIND
  implicit none
  logical, save           :: colmat_not_initialised = .true.
  complex(REALKIND), save :: K1(138,6), K2(6,6), KL(6,6)
  contains
  subroutine colourmatrix_init
    use ol_parameters_decl_/**/REALKIND, only: CI
    implicit none
    colmat_not_initialised = .false.
    ! colour matrix

  K1(  1,:) = [  27,   9,   9,   3,   3,   9]
  K1(  2,:) = [   9,  27,   3,   9,   9,   3]
  K1(  3,:) = [   9,   3,  27,   9,   9,   3]
  K1(  4,:) = [   3,   9,   9,  27,   3,   9]
  K1(  5,:) = [   3,   9,   9,   3,  27,   9]
  K1(  6,:) = [   9,   3,   3,   9,   9,  27]
  K1(  7,:) = [  36,  12,  12,   4,   4,  12]
  K1(  8,:) = [  12,  36,   4,  12,  12,   4]
  K1(  9,:) = [  12,   4,  36,  12,  12,   4]
  K1( 10,:) = [   4,  12,  12,  36,   4,  12]
  K1( 11,:) = [   4,  12,  12,   4,  36,  12]
  K1( 12,:) = [  12,   4,   4,  12,  12,  36]
  K1( 13,:) = [   0,   0,   0,  -4,  -4, -12]
  K1( 14,:) = [   0,   0,  -4, -12,   0,  -4]
  K1( 15,:) = [   0,  -4,   0, -12,   0,  -4]
  K1( 16,:) = [  -4, -12, -12, -36,  -4, -12]
  K1( 17,:) = [  -4,   0,   0,  -4,   0, -12]
  K1( 18,:) = [ -12,  -4,  -4, -12, -12, -36]
  K1( 19,:) = [  36,  12,  12,   4,   4,  12]
  K1( 20,:) = [  12,  36,   4,  12,  12,   4]
  K1( 21,:) = [  12,   4,  36,  12,  12,   4]
  K1( 22,:) = [   4,  12,  12,  36,   4,  12]
  K1( 23,:) = [   4,  12,  12,   4,  36,  12]
  K1( 24,:) = [  12,   4,   4,  12,  12,  36]
  K1( 25,:) = [   0,   0,  12,   4,   4,   0]
  K1( 26,:) = [   0,   0,   4,  12,   0,   4]
  K1( 27,:) = [  12,   4,   0,   0,   0,   4]
  K1( 28,:) = [   4,  12,   0,   0,   4,   0]
  K1( 29,:) = [   4,   0,   0,   4,   0,  12]
  K1( 30,:) = [   0,   4,   4,   0,  12,   0]
  K1( 31,:) = [   0, -12,   0,  -4,  -4,   0]
  K1( 32,:) = [ -12, -36,  -4, -12, -12,  -4]
  K1( 33,:) = [   0,  -4,   0,   0, -12,  -4]
  K1( 34,:) = [  -4, -12,   0,   0,  -4,   0]
  K1( 35,:) = [  -4, -12, -12,  -4, -36, -12]
  K1( 36,:) = [   0,  -4,  -4,   0, -12,   0]
  K1( 37,:) = [  36,  12,  12,   4,   4,  12]
  K1( 38,:) = [  12,  36,   4,  12,  12,   4]
  K1( 39,:) = [  12,   4,  36,  12,  12,   4]
  K1( 40,:) = [   4,  12,  12,  36,   4,  12]
  K1( 41,:) = [   4,  12,  12,   4,  36,  12]
  K1( 42,:) = [  12,   4,   4,  12,  12,  36]
  K1( 43,:) = [   0,   0, -12,  -4,  -4,   0]
  K1( 44,:) = [   0,   0,  -4,   0, -12,  -4]
  K1( 45,:) = [ -12,  -4, -36, -12, -12,  -4]
  K1( 46,:) = [  -4,   0, -12,   0,  -4,   0]
  K1( 47,:) = [  -4, -12, -12,  -4, -36, -12]
  K1( 48,:) = [   0,  -4,  -4,   0, -12,   0]
  K1( 49,:) = [   0,  12,   0,   4,   4,   0]
  K1( 50,:) = [  12,   0,   4,   0,   0,   4]
  K1( 51,:) = [   0,   4,   0,  12,   0,   4]
  K1( 52,:) = [   4,   0,  12,   0,   4,   0]
  K1( 53,:) = [   4,   0,   0,   4,   0,  12]
  K1( 54,:) = [   0,   4,   4,   0,  12,   0]
  K1( 55,:) = [ -36, -12, -12,  -4,  -4, -12]
  K1( 56,:) = [ -12,   0,  -4,   0,   0,  -4]
  K1( 57,:) = [ -12,  -4,   0,   0,   0,  -4]
  K1( 58,:) = [  -4,   0,   0,   0,  -4, -12]
  K1( 59,:) = [  -4,   0,   0,  -4,   0, -12]
  K1( 60,:) = [ -12,  -4,  -4, -12, -12, -36]
  K1( 61,:) = [  36,  12,  12,   4,   4,  12]
  K1( 62,:) = [  12,  36,   4,  12,  12,   4]
  K1( 63,:) = [  12,   4,  36,  12,  12,   4]
  K1( 64,:) = [   4,  12,  12,  36,   4,  12]
  K1( 65,:) = [   4,  12,  12,   4,  36,  12]
  K1( 66,:) = [  12,   4,   4,  12,  12,  36]
  K1( 67,:) = [   0,   0,   0,   4,   4,  12]
  K1( 68,:) = [   0,   0,   4,   0,  12,   4]
  K1( 69,:) = [   0,   4,   0,  12,   0,   4]
  K1( 70,:) = [   4,   0,  12,   0,   4,   0]
  K1( 71,:) = [   4,  12,   0,   4,   0,   0]
  K1( 72,:) = [  12,   4,   4,   0,   0,   0]
  K1( 73,:) = [ -36, -12, -12,  -4,  -4, -12]
  K1( 74,:) = [ -12,   0,  -4,   0,   0,  -4]
  K1( 75,:) = [ -12,  -4, -36, -12, -12,  -4]
  K1( 76,:) = [  -4,   0, -12,   0,  -4,   0]
  K1( 77,:) = [  -4,   0, -12,  -4,   0,   0]
  K1( 78,:) = [ -12,  -4,  -4,   0,   0,   0]
  K1( 79,:) = [   0,  12,   0,   4,   4,   0]
  K1( 80,:) = [  12,   0,   4,   0,   0,   4]
  K1( 81,:) = [   0,   4,   0,   0,  12,   4]
  K1( 82,:) = [   4,   0,   0,   0,   4,  12]
  K1( 83,:) = [   4,   0,  12,   4,   0,   0]
  K1( 84,:) = [   0,   4,   4,  12,   0,   0]
  K1( 85,:) = [   0, -12,   0,  -4,  -4,   0]
  K1( 86,:) = [ -12, -36,  -4, -12, -12,  -4]
  K1( 87,:) = [   0,  -4,   0, -12,   0,  -4]
  K1( 88,:) = [  -4, -12, -12, -36,  -4, -12]
  K1( 89,:) = [  -4, -12,   0,  -4,   0,   0]
  K1( 90,:) = [   0,  -4,  -4, -12,   0,   0]
  K1( 91,:) = [  36,  12,  12,   4,   4,  12]
  K1( 92,:) = [  12,  36,   4,  12,  12,   4]
  K1( 93,:) = [  12,   4,  36,  12,  12,   4]
  K1( 94,:) = [   4,  12,  12,  36,   4,  12]
  K1( 95,:) = [   4,  12,  12,   4,  36,  12]
  K1( 96,:) = [  12,   4,   4,  12,  12,  36]
  K1( 97,:) = [ -36, -12, -12,  -4,  -4, -12]
  K1( 98,:) = [ -12, -36,  -4, -12, -12,  -4]
  K1( 99,:) = [ -12,  -4,   0,   0,   0,  -4]
  K1(100,:) = [  -4, -12,   0,   0,  -4,   0]
  K1(101,:) = [  -4, -12,   0,  -4,   0,   0]
  K1(102,:) = [ -12,  -4,  -4,   0,   0,   0]
  K1(103,:) = [   0,   0,   0,   4,   4,  12]
  K1(104,:) = [   0,   0,   4,  12,   0,   4]
  K1(105,:) = [   0,   4,   0,   0,  12,   4]
  K1(106,:) = [   4,  12,   0,   0,   4,   0]
  K1(107,:) = [   4,   0,  12,   4,   0,   0]
  K1(108,:) = [  12,   4,   4,   0,   0,   0]
  K1(109,:) = [   0,   0, -12,  -4,  -4,   0]
  K1(110,:) = [   0,   0,  -4, -12,   0,  -4]
  K1(111,:) = [ -12,  -4, -36, -12, -12,  -4]
  K1(112,:) = [  -4, -12, -12, -36,  -4, -12]
  K1(113,:) = [  -4,   0, -12,  -4,   0,   0]
  K1(114,:) = [   0,  -4,  -4, -12,   0,   0]
  K1(115,:) = [   0,   0,  12,   4,   4,   0]
  K1(116,:) = [   0,   0,   4,   0,  12,   4]
  K1(117,:) = [  12,   4,   0,   0,   0,   4]
  K1(118,:) = [   4,   0,   0,   0,   4,  12]
  K1(119,:) = [   4,  12,   0,   4,   0,   0]
  K1(120,:) = [   0,   4,   4,  12,   0,   0]
  K1(121,:) = [   0,   0,   0,  -4,  -4, -12]
  K1(122,:) = [   0,   0,  -4,   0, -12,  -4]
  K1(123,:) = [   0,  -4,   0,   0, -12,  -4]
  K1(124,:) = [  -4,   0,   0,   0,  -4, -12]
  K1(125,:) = [  -4, -12, -12,  -4, -36, -12]
  K1(126,:) = [ -12,  -4,  -4, -12, -12, -36]
  K1(127,:) = [  36,  12,  12,   4,   4,  12]
  K1(128,:) = [  12,  36,   4,  12,  12,   4]
  K1(129,:) = [  12,   4,  36,  12,  12,   4]
  K1(130,:) = [   4,  12,  12,  36,   4,  12]
  K1(131,:) = [   4,  12,  12,   4,  36,  12]
  K1(132,:) = [  12,   4,   4,  12,  12,  36]
  K1(133,:) = [   0,   0,   0,   0,   0,   0]
  K1(134,:) = [   0,   0,   0,   0,   0,   0]
  K1(135,:) = [   0,   0,   0,   0,   0,   0]
  K1(136,:) = [   0,   0,   0,   0,   0,   0]
  K1(137,:) = [   0,   0,   0,   0,   0,   0]
  K1(138,:) = [   0,   0,   0,   0,   0,   0]

  K2(1,:) = [ 27,  9,  9,  3,  3,  9]
  K2(2,:) = [  9, 27,  3,  9,  9,  3]
  K2(3,:) = [  9,  3, 27,  9,  9,  3]
  K2(4,:) = [  3,  9,  9, 27,  3,  9]
  K2(5,:) = [  3,  9,  9,  3, 27,  9]
  K2(6,:) = [  9,  3,  3,  9,  9, 27]

  KL(1,:) = [ 27,  9,  9,  3,  3,  9]
  KL(2,:) = [  9, 27,  3,  9,  9,  3]
  KL(3,:) = [  9,  3, 27,  9,  9,  3]
  KL(4,:) = [  3,  9,  9, 27,  3,  9]
  KL(5,:) = [  3,  9,  9,  3, 27,  9]
  KL(6,:) = [  9,  3,  3,  9,  9, 27]

  end subroutine colourmatrix_init
end module ol_colourmatrix_ppttjj_ttxddxbbx_1_/**/REALKIND



module ol_forced_parameters_ppttjj_ttxddxbbx_1_/**/REALKIND
  implicit none
  contains
  subroutine check_forced_parameters
    use ol_parameters_decl_/**/REALKIND
    use ol_loop_parameters_decl_/**/REALKIND
#ifndef PRECISION_dp
    use ol_loop_parameters_decl_/**/DREALKIND, only: LeadingColour, nc, nf, CKMORDER
#endif
    implicit none
    logical, save :: checks_not_written = .true.

    if (checks_not_written) then
    ! e.g.
    ! if (ME /= 0) write(*,101) 'ME = 0'
  if (CKMORDER /= 0) write(*,101) 'CKMORDER = 0'
  if (nc /= 3) write(*,101) 'nc = 3'
  if (nf /= 6) write(*,101) 'nf = 6'
  if (MU /= 0) write(*,101) 'MU = 0'
  if (MD /= 0) write(*,101) 'MD = 0'
  if (MS /= 0) write(*,101) 'MS = 0'
  if (MC /= 0) write(*,101) 'MC = 0'
  if (LeadingColour /= 0) write(*,101) 'LeadingColour = 0'
  if (wMT /= 0) write(*,101) 'wMT = 0'
  if (wMT /= 0) write(*,101) 'wMT = 0'
  if (wMB /= 0) write(*,101) 'wMB = 0'
  if (wMB /= 0) write(*,101) 'wMB = 0'


    checks_not_written = .false.
    end if

    101 format('[OpenLoops] === WARNING ===',/,'[OpenLoops] code was generated with ',A,/,'[OpenLoops] ===============')
  end subroutine check_forced_parameters
end module ol_forced_parameters_ppttjj_ttxddxbbx_1_/**/REALKIND
! **********************************************************************
module ol_loop_storage_ppttjj_ttxddxbbx_1_/**/REALKIND
! **********************************************************************
  use KIND_TYPES, only: REALKIND, intkind1, intkind2  
  use ol_data_types_/**/REALKIND, only: wfun, Hpolcont
  
#ifdef PRECISION_dp
  integer(intkind1), save :: ntry = 1
  integer(intkind1), save :: p_switch = 0 ! switch for dp or qp. Used for memory allocation of the OL types 
  ! the following are flags for memory allocation of the hol coefficients in dp or qp 
  logical, save :: dp_not_alloc = .TRUE., qp_not_alloc = .TRUE.
  integer(intkind2), parameter :: nheltot = 64 ! number of helicity configurations
  integer(intkind2), save :: nhel = 64 ! number of non-vanishing helicity configurations (adapted at runtime)
  integer(intkind2), save :: Hel(64) ! physical helicity states
#endif

  complex(REALKIND), save :: den(100)

  ! external wave functions ex1(h1),... for h<n> helicities
  type(wfun) :: ex1(2), ex2(2), ex3(2), ex4(2), ex5(2), ex6(2)

  ! wf<h>(h,n) n wave functions with h helicity configurations
  type(wfun) :: wf4(4,9), wf8(8,72), wf16(16,18), wf64(64,56)

  ! diagram prefactors
  integer,           save :: fac_status_loop1 = -1, fac_status_loop2 = -1
  complex(REALKIND), save :: f(19), c(36)

  !below the colour vector for Born-Loop interference
  type(Hpolcont),   save :: M0_col1_helarray(6,64)

end module ol_loop_storage_ppttjj_ttxddxbbx_1_/**/REALKIND






! **********************************************************************
module ol_loop_ppttjj_ttxddxbbx_1_/**/REALKIND
! **********************************************************************
  use KIND_TYPES, only: REALKIND, DREALKIND, intkind1, intkind2  
  use ol_data_types_/**/REALKIND, only: wfun, Hpolcont
  use ol_loop_storage_ppttjj_ttxddxbbx_1_/**/REALKIND
  implicit none

!*********************************************************************************
  contains

! **********************************************************************
subroutine fac_init_loop()
! Writes diagram prefactors to 'f', rsp. 'c'
! **********************************************************************
  use ol_parameters_decl_/**/REALKIND
  use ol_loop_parameters_decl_/**/REALKIND
  use ol_init, only: set_parameter, tree_parameters_flush, parameters_flush
#ifndef PRECISION_dp
  use ol_loop_parameters_decl_/**/DREALKIND, only: SwF, SwB
!  use ol_loop_parameters_decl_/**/DREALKIND, only: DOI
#endif
  implicit none
  call set_parameter("ew_renorm", 0)
  if (parameters_status == 0) call tree_parameters_flush()
  if (loop_parameters_status == 0) call parameters_flush()
  fac_status_loop1 = parameters_status
  fac_status_loop2 = loop_parameters_status
  ! factors of the diagrams
    f( 1) = CI*gQCD**4
    f( 2) = gQCD**4
    f( 3) = CI*countertermnorm*gQCD**6
    f( 4) = countertermnorm*gQCD**6
    f( 5) = CI*countertermnorm*ctGbb*gQCD**6
    f( 6) = countertermnorm*ctGbb*gQCD**6
    f( 7) = CI*countertermnorm*ctGqq*gQCD**6
    f( 8) = countertermnorm*ctGqq*gQCD**6
    f( 9) = CI*countertermnorm*ctGtt*gQCD**6
    f(10) = countertermnorm*ctGtt*gQCD**6
    f(11) = countertermnorm*ctVVV*gQCD**6
    f(12) = (CI*gQCD**6*integralnorm*SwB)/2._/**/REALKIND
    f(13) = CI*gQCD**6*integralnorm*SwB
    f(14) = (gQCD**6*integralnorm*SwB)/2._/**/REALKIND
    f(15) = gQCD**6*integralnorm*SwB
    f(16) = CI*gQCD**6*integralnorm*SwF
    f(17) = 2*CI*gQCD**6*integralnorm*SwF
    f(18) = gQCD**6*integralnorm*SwF
    f(19) = 2*gQCD**6*integralnorm*SwF

  c = [ 81*CI*f(12), 162*CI*f(12), 9*CI*f(13), 27*CI*f(13), 72*CI*f(13), 81*CI*f(13), 162*CI*f(13), 18*f(14), 54*f(14), 162*f(14) &
    , f(15), 3*f(15), 6*f(15), 8*f(15), 9*f(15), 10*f(15), 18*f(15), 21*f(15), 24*f(15), 27*f(15), 30*f(15), 54*f(15), 63*f(15) &
    , 72*f(15), 81*f(15), 162*f(15), 27*CI*f(16), 27*CI*f(17), 3*f(18), 6*f(18), 9*f(18), 27*f(18), 3*f(19), 6*f(19), 9*f(19) &
    , 27*f(19) ]
  c = (1._/**/REALKIND / 216) * c
end subroutine fac_init_loop

subroutine denominators()
  use ol_parameters_decl_/**/REALKIND ! masses
  use ol_momenta_decl_/**/REALKIND, only: L
  implicit none
  ! propagators
  den(1) = 1 /((L(5,3))+L(6,3))
  den(2) = 1 /((L(5,12))+L(6,12))
  den(3) = 1 /((L(5,48))+L(6,48))
  den(6) = 1 /((L(5,19) - MB2)+L(6,19))
  den(9) = 1 /((L(5,28) - MB2)+L(6,28))
  den(12) = 1 /((L(5,7))+L(6,7))
  den(15) = 1 /((L(5,52))+L(6,52))
  den(18) = 1 /((L(5,13) - MT2)+L(6,13))
  den(21) = 1 /((L(5,49) - MT2)+L(6,49))
  den(24) = 1 /((L(5,35) - MB2)+L(6,35))
  den(27) = 1 /((L(5,44) - MB2)+L(6,44))
  den(30) = 1 /((L(5,11))+L(6,11))
  den(33) = 1 /((L(5,56))+L(6,56))
  den(36) = 1 /((L(5,50) - MT2)+L(6,50))
  den(39) = 1 /((L(5,14) - MT2)+L(6,14))
  den(43) = 1 /((L(5,60))+L(6,60))
  den(47) = 1 /((L(5,51))+L(6,51))
  den(50) = 1 /((L(5,15))+L(6,15))

  ! denominators
  den(4) = den(1)*den(2)
  den(5) = den(3)*den(4)
  den(7) = den(1)*den(6)
  den(8) = den(2)*den(7)
  den(10) = den(2)*den(9)
  den(11) = den(1)*den(10)
  den(13) = den(1)*den(12)
  den(14) = den(3)*den(13)
  den(16) = den(3)*den(15)
  den(17) = den(1)*den(16)
  den(19) = den(2)*den(18)
  den(20) = den(3)*den(19)
  den(22) = den(3)*den(21)
  den(23) = den(2)*den(22)
  den(25) = den(1)*den(24)
  den(26) = den(2)*den(25)
  den(28) = den(2)*den(27)
  den(29) = den(1)*den(28)
  den(31) = den(1)*den(30)
  den(32) = den(3)*den(31)
  den(34) = den(3)*den(33)
  den(35) = den(1)*den(34)
  den(37) = den(3)*den(36)
  den(38) = den(2)*den(37)
  den(40) = den(2)*den(39)
  den(41) = den(3)*den(40)
  den(42) = den(2)*den(3)
  den(44) = den(42)*den(43)
  den(45) = den(1)*den(44)
  den(46) = den(1)*den(3)
  den(48) = den(46)*den(47)
  den(49) = den(2)*den(48)
  den(51) = den(4)*den(50)
  den(52) = den(3)*den(51)
  den(53) = den(1)**2
  den(54) = den(28)*den(53)
  den(55) = den(10)*den(53)
  den(56) = den(2)**2
  den(57) = den(25)*den(56)
  den(58) = den(7)*den(56)
  den(59) = den(7)*den(28)
  den(60) = den(10)*den(25)
  den(61) = den(34)*den(53)
  den(62) = den(16)*den(53)
  den(63) = den(13)*den(34)
  den(64) = den(16)*den(31)
  den(65) = den(3)**2
  den(66) = den(31)*den(65)
  den(67) = den(13)*den(65)
  den(68) = den(19)*den(37)
  den(69) = den(22)*den(40)
  den(70) = den(37)*den(56)
  den(71) = den(40)*den(65)
  den(72) = den(22)*den(56)
  den(73) = den(19)*den(65)
  den(74) = den(13)*den(50)
  den(75) = den(31)*den(50)
  den(76) = den(7)*den(47)
  den(77) = den(25)*den(47)
  den(78) = den(19)*den(50)
  den(79) = den(40)*den(50)
  den(80) = den(10)*den(43)
  den(81) = den(28)*den(43)
  den(82) = den(22)*den(47)
  den(83) = den(37)*den(47)
  den(84) = den(16)*den(43)
  den(85) = den(34)*den(43)
  den(86) = den(1)*den(2)*den(3)
  den(87) = den(1)*den(42)
  den(88) = den(2)*den(46)
  den(89) = den(2)*den(76)
  den(90) = den(2)*den(77)
  den(91) = den(1)*den(80)
  den(92) = den(1)*den(81)
  den(93) = den(3)*den(74)
  den(94) = den(3)*den(75)
  den(95) = den(1)*den(84)
  den(96) = den(1)*den(85)
  den(97) = den(3)*den(78)
  den(98) = den(2)*den(82)
  den(99) = den(3)*den(79)
  den(100) = den(2)*den(83)

end subroutine denominators

!
!
!
!
!
! **********************************************************************
#ifdef PRECISION_dp
subroutine amp2(P_scatt, M02, M2ct, M2colint) &
    & bind(c,name="Hol_f_amp2_ppttjj_ttxddxbbx_1")
#else
subroutine amp2(P_scatt, M02, M2ct, M2colint)
  use ol_loop_storage_ppttjj_ttxddxbbx_1_/**/DREALKIND, only: ntry, nhel, Hel
#endif
! P_scatt(0:3,Npart) = incoming external momenta
! M2  = helicity-summed squared matrix element for top anti-top down anti-down bottom anti-bottom -> 0
! **********************************************************************
  use ol_parameters_decl_/**/REALKIND !, only: ci, parameters_status, ZERO, scalefactor, >masses<
  use ol_parameters_init_/**/REALKIND, only: ensure_mp_init
  use ol_kinematics_/**/REALKIND, only: init_kinematics
  use ol_momenta_decl_/**/DREALKIND, only: momenta_nan_check
  use ol_momenta_decl_/**/REALKIND, only: Q
  use ol_data_types_/**/REALKIND
  use ol_h_helicity_bookkeeping_/**/REALKIND, only: &
    & helbookkeeping_wf, helsync, flip_phase
  use ol_helicity_init, only: helbookkeeping_flip, helsync_flip
  use ol_hel_propagators_/**/REALKIND
  use ol_hel_wavefunctions_/**/REALKIND
  use ol_wavefunctions_/**/REALKIND, only: wf_V_Std
  use ol_hel_vertices_/**/REALKIND
  use ol_hel_contractions_/**/REALKIND
  use ol_external_ppttjj_ttxddxbbx_1, only: external_perm_ppttjj_ttxddxbbx_1, &
    & external_perm_inv_ppttjj_ttxddxbbx_1, extcomb_perm_ppttjj_ttxddxbbx_1, &
    & average_factor_ppttjj_ttxddxbbx_1
  use ol_external_ppttjj_ttxddxbbx_1, only: H, hel_not_initialised, hel_init, POLSEL
  use ol_colourmatrix_ppttjj_ttxddxbbx_1_/**/REALKIND, only: colmat_not_initialised, colourmatrix_init
  use ol_forced_parameters_ppttjj_ttxddxbbx_1_/**/REALKIND, only: check_forced_parameters
  use ol_heltables_OLR_ppttjj_ttxddxbbx_1
  use ol_kinematics_/**/REALKIND, only: LC2Std_Rep_cmplx
  use ol_h_counterterms_/**/REALKIND
  use ol_loop_parameters_decl_/**/REALKIND ! counterterms
  use ol_loop_parameters_decl_/**/DREALKIND, only: IR_is_on
  use ol_init, only: set_parameter, parameters_flush
#ifdef PRECISION_dp
  use ol_kinematics_/**/QREALKIND, only: conv_mom_scatt2in_qp=>conv_mom_scatt2in, &
                                         internal_momenta_qp=>internal_momenta
  use ol_momenta_decl_/**/DREALKIND, only: L, Q
  use ol_momenta_decl_/**/QREALKIND, only: L_qp=>L, Q_qp=>L
#endif
  implicit none

  real(DREALKIND), intent(in)  :: P_scatt(0:3,6)
  real(REALKIND),  intent(out) :: M02, M2ct, M2colint(22)

  integer           :: shift, k, r, m, n
  real(REALKIND)    :: P(0:3,6)
#ifdef PRECISION_dp
  real(QREALKIND)    :: P_qp(0:3,6)
#endif
  integer           :: extmasses2(6)
  real(REALKIND)    :: M2add, M2add_ct, M2add_colint(22)
  complex(REALKIND) :: M1(6), M2(6) 
  real(REALKIND)    :: P_scatt_intern(0:3,6)
  real(REALKIND), save :: scalebackfactor, old_scalefactor = 0
  integer(intkind1) :: nsync
  type(Hpolcont),   save :: M1helarray(6,64)
  type(Hpolcont) :: M1helarray_ct(6,64)

  type(Hpolcont) :: A(64,56)

  !Aj are not used at the moment
  !complex(REALKIND) :: Aj(56)

  complex(REALKIND) :: omega(2) ! phases for helicity correlations

  call set_parameter("ew_renorm", 0)
  call parameters_flush()
  call ensure_mp_init()

  if (colmat_not_initialised) call colourmatrix_init()

  if (fac_status_loop1 /= parameters_status .or. fac_status_loop2 /= loop_parameters_status) then
    ! Note: if fac_init would only be called when parameters changed which are relevant for the factors,
    ! a different 'status' would have to be used, because forced_parameters should be called after every parameter change.
    call check_forced_parameters()
    call fac_init_loop()
  end if

  if (momenta_nan_check(P_scatt) /= 0) then
    M02 = 0
    return
  end if

  extmasses2 = [ nMT, nMT, 0, 0, nMB, nMB ]
  ! Convert 2 -> n-2 PS-point to n -> 0 (so that P(1) + ... + P(n) = 0) and compute
  ! internal-propagator momenta in light-cone representation
  call init_kinematics(P_scatt, extmasses2, P, external_perm_inv_ppttjj_ttxddxbbx_1, 6)

  ! denominators
  call denominators()

   if (heltables_not_init) call init_heltables()

  ! external WFs
  ! Here the external wavefunctions are initialiased
  call pol_wf_Q(P(:,1), rMT, H1, ex1, POLSEL(1),1)
  call pol_wf_A(P(:,2), rMT, H2, ex2, POLSEL(2),2)
  call pol_wf_Q(P(:,3), rZERO, H3, ex3, POLSEL(3),3)
  call pol_wf_A(P(:,4), rZERO, H4, ex4, POLSEL(4),4)
  call pol_wf_Q(P(:,5), rMB, H5, ex5, POLSEL(5),5)
  call pol_wf_A(P(:,6), rMB, H6, ex6, POLSEL(6),6)



  ! internal WFs
  ! e.g. call vert_VQ_A(ntry, ex3, ex1, wf1, n1, t1) ...
  call vert_QA_V(ntry, ex1(:), ex2(:), wf4(:,1), n3(:,1), t3x4(:,:,1))
  call vert_QA_V(ntry, ex3(:), ex4(:), wf4(:,2), n3(:,2), t3x4(:,:,2))
  call vert_QA_V(ntry, ex5(:), ex6(:), wf4(:,3), n3(:,3), t3x4(:,:,3))
  call vert_UV_W(ntry, wf4(:,1), 3, wf4(:,2), 12, wf16(:,1), n3(:,4), t3x16(:,:,1))
  call vert_VQ_A(ntry, wf4(:,1), ex5(:), wf8(:,1), n3(:,5), t3x8(:,:,1))
  call vert_AV_Q(ntry, ex6(:), wf4(:,2), wf8(:,2), n3(:,6), t3x8(:,:,2))
  call prop_Q_A(ntry, wf8(:,1), 19, MB, 1_intkind1, wf8(:,3), n2(1))
  call vert_VQ_A(ntry, wf4(:,2), ex5(:), wf8(:,4), n3(:,7), t3x8(:,:,3))
  call vert_AV_Q(ntry, ex6(:), wf4(:,1), wf8(:,5), n3(:,8), t3x8(:,:,4))
  call prop_Q_A(ntry, wf8(:,4), 28, MB, 1_intkind1, wf8(:,6), n2(2))
  call vert_VQ_A(ntry, wf4(:,1), ex3(:), wf8(:,7), n3(:,9), t3x8(:,:,5))
  call vert_AV_Q(ntry, ex4(:), wf4(:,3), wf8(:,8), n3(:,10), t3x8(:,:,6))
  call prop_Q_A(ntry, wf8(:,7), 7, ZERO, 0_intkind1, wf8(:,9), n2(3))
  call vert_VQ_A(ntry, wf4(:,3), ex3(:), wf8(:,10), n3(:,11), t3x8(:,:,7))
  call vert_AV_Q(ntry, ex4(:), wf4(:,1), wf8(:,11), n3(:,12), t3x8(:,:,8))
  call prop_Q_A(ntry, wf8(:,10), 52, ZERO, 0_intkind1, wf8(:,12), n2(4))
  call vert_VQ_A(ntry, wf4(:,2), ex1(:), wf8(:,13), n3(:,13), t3x8(:,:,9))
  call vert_AV_Q(ntry, ex2(:), wf4(:,3), wf8(:,14), n3(:,14), t3x8(:,:,10))
  call prop_Q_A(ntry, wf8(:,13), 13, MT, 1_intkind1, wf8(:,15), n2(5))
  call vert_VQ_A(ntry, wf4(:,3), ex1(:), wf8(:,16), n3(:,15), t3x8(:,:,11))
  call vert_AV_Q(ntry, ex2(:), wf4(:,2), wf8(:,17), n3(:,16), t3x8(:,:,12))
  call prop_Q_A(ntry, wf8(:,16), 49, MT, 1_intkind1, wf8(:,18), n2(6))
  call counter_UV_W(ntry, wf4(:,1), 3, wf4(:,2), 12, wf16(:,2), n3(:,17), t3x16(:,:,2))
  call counter_AV_Q(ntry, ex6(:), wf4(:,2), wf8(:,19), n3(:,18), t3x8(:,:,13))
  call counter_AV_Q(ntry, ex6(:), wf4(:,1), wf8(:,20), n3(:,19), t3x8(:,:,14))
  call counter_VQ_A(ntry, wf4(:,2), ex5(:), wf8(:,21), n3(:,20), t3x8(:,:,15))
  call prop_A_Q(ntry, wf8(:,5), 35, MB, 1_intkind1, wf8(:,22), n2(7))
  call counter_VQ_A(ntry, wf4(:,1), ex5(:), wf8(:,23), n3(:,21), t3x8(:,:,16))
  call prop_A_Q(ntry, wf8(:,2), 44, MB, 1_intkind1, wf8(:,24), n2(8))
  call counter_QA_V(ntry, ex5(:), ex6(:), wf4(:,4), n3(:,22), t3x4(:,:,4))
  call vert_AV_Q(ntry, ex4(:), wf4(:,4), wf8(:,25), n3(:,23), t3x8(:,:,17))
  call vert_VQ_A(ntry, wf4(:,4), ex3(:), wf8(:,26), n3(:,24), t3x8(:,:,18))
  call prop_Q_A(ntry, wf8(:,26), 52, ZERO, 0_intkind1, wf8(:,27), n2(9))
  call counter_AV_Q(ntry, ex4(:), wf4(:,3), wf8(:,28), n3(:,25), t3x8(:,:,19))
  call counter_AV_Q(ntry, ex4(:), wf4(:,1), wf8(:,29), n3(:,26), t3x8(:,:,20))
  call counter_VQ_A(ntry, wf4(:,3), ex3(:), wf8(:,30), n3(:,27), t3x8(:,:,21))
  call prop_A_Q(ntry, wf8(:,11), 11, ZERO, 0_intkind1, wf8(:,31), n2(10))
  call counter_VQ_A(ntry, wf4(:,1), ex3(:), wf8(:,32), n3(:,28), t3x8(:,:,22))
  call prop_A_Q(ntry, wf8(:,8), 56, ZERO, 0_intkind1, wf8(:,33), n2(11))
  call counter_QA_V(ntry, ex3(:), ex4(:), wf4(:,5), n3(:,29), t3x4(:,:,5))
  call vert_UV_W(ntry, wf4(:,1), 3, wf4(:,5), 12, wf16(:,3), n3(:,30), t3x16(:,:,3))
  call vert_AV_Q(ntry, ex6(:), wf4(:,5), wf8(:,34), n3(:,31), t3x8(:,:,23))
  call vert_VQ_A(ntry, wf4(:,5), ex5(:), wf8(:,35), n3(:,32), t3x8(:,:,24))
  call prop_Q_A(ntry, wf8(:,35), 28, MB, 1_intkind1, wf8(:,36), n2(12))
  call vert_AV_Q(ntry, ex2(:), wf4(:,4), wf8(:,37), n3(:,33), t3x8(:,:,25))
  call vert_VQ_A(ntry, wf4(:,4), ex1(:), wf8(:,38), n3(:,34), t3x8(:,:,26))
  call prop_Q_A(ntry, wf8(:,38), 49, MT, 1_intkind1, wf8(:,39), n2(13))
  call vert_AV_Q(ntry, ex2(:), wf4(:,5), wf8(:,40), n3(:,35), t3x8(:,:,27))
  call vert_VQ_A(ntry, wf4(:,5), ex1(:), wf8(:,41), n3(:,36), t3x8(:,:,28))
  call prop_Q_A(ntry, wf8(:,41), 13, MT, 1_intkind1, wf8(:,42), n2(14))
  call counter_AV_Q(ntry, ex2(:), wf4(:,3), wf8(:,43), n3(:,37), t3x8(:,:,29))
  call counter_AV_Q(ntry, ex2(:), wf4(:,2), wf8(:,44), n3(:,38), t3x8(:,:,30))
  call counter_VQ_A(ntry, wf4(:,2), ex1(:), wf8(:,45), n3(:,39), t3x8(:,:,31))
  call prop_A_Q(ntry, wf8(:,14), 50, MT, 1_intkind1, wf8(:,46), n2(15))
  call counter_VQ_A(ntry, wf4(:,3), ex1(:), wf8(:,47), n3(:,40), t3x8(:,:,32))
  call prop_A_Q(ntry, wf8(:,17), 14, MT, 1_intkind1, wf8(:,48), n2(16))
  call counter_QA_V(ntry, ex1(:), ex2(:), wf4(:,6), n3(:,41), t3x4(:,:,6))
  call vert_UV_W(ntry, wf4(:,6), 3, wf4(:,2), 12, wf16(:,4), n3(:,42), t3x16(:,:,4))
  call vert_VQ_A(ntry, wf4(:,6), ex5(:), wf8(:,49), n3(:,43), t3x8(:,:,33))
  call prop_Q_A(ntry, wf8(:,49), 19, MB, 1_intkind1, wf8(:,50), n2(17))
  call vert_AV_Q(ntry, ex6(:), wf4(:,6), wf8(:,51), n3(:,44), t3x8(:,:,34))
  call vert_VQ_A(ntry, wf4(:,6), ex3(:), wf8(:,52), n3(:,45), t3x8(:,:,35))
  call prop_Q_A(ntry, wf8(:,52), 7, ZERO, 0_intkind1, wf8(:,53), n2(18))
  call vert_AV_Q(ntry, ex4(:), wf4(:,6), wf8(:,54), n3(:,46), t3x8(:,:,36))
  call vert_UV_W(ntry, wf4(:,2), 12, wf4(:,3), 48, wf16(:,5), n3(:,47), t3x16(:,:,5))
  call counter_V_V(ctGG,21,ntry, wf4(:,1), 3, wf4(:,7), n2(19))
  call vert_UV_W(ntry, wf4(:,1), 3, wf4(:,3), 48, wf16(:,6), n3(:,48), t3x16(:,:,6))
  call counter_V_V(ctGG,21,ntry, wf4(:,2), 12, wf4(:,8), n2(20))
  call counter_V_V(ctGG,21,ntry, wf4(:,3), 48, wf4(:,9), n2(21))
  call vert_VQ_A(ntry, wf4(:,7), ex5(:), wf8(:,55), n3(:,49), t3x8(:,:,37))
  call vert_AV_Q(ntry, ex6(:), wf4(:,7), wf8(:,56), n3(:,50), t3x8(:,:,38))
  call vert_VQ_A(ntry, wf4(:,8), ex5(:), wf8(:,57), n3(:,51), t3x8(:,:,39))
  call vert_AV_Q(ntry, ex6(:), wf4(:,8), wf8(:,58), n3(:,52), t3x8(:,:,40))
  call counter_Q_A(ctbb,5,ntry, wf8(:,3), 19, wf8(:,59), n2(22))
  call counter_Q_A(ctbb,5,ntry, wf8(:,6), 28, wf8(:,60), n2(23))
  call vert_VQ_A(ntry, wf4(:,7), ex3(:), wf8(:,61), n3(:,53), t3x8(:,:,41))
  call vert_AV_Q(ntry, ex4(:), wf4(:,7), wf8(:,62), n3(:,54), t3x8(:,:,42))
  call counter_Q_A(ctqq,1,ntry, wf8(:,9), 7, wf8(:,63), n2(24))
  call counter_Q_A(ctqq,1,ntry, wf8(:,12), 52, wf8(:,64), n2(25))
  call vert_VQ_A(ntry, wf4(:,9), ex3(:), wf8(:,65), n3(:,55), t3x8(:,:,43))
  call vert_AV_Q(ntry, ex4(:), wf4(:,9), wf8(:,66), n3(:,56), t3x8(:,:,44))
  call counter_Q_A(cttt,6,ntry, wf8(:,15), 13, wf8(:,67), n2(26))
  call counter_Q_A(cttt,6,ntry, wf8(:,18), 49, wf8(:,68), n2(27))
  call vert_VQ_A(ntry, wf4(:,8), ex1(:), wf8(:,69), n3(:,57), t3x8(:,:,45))
  call vert_VQ_A(ntry, wf4(:,9), ex1(:), wf8(:,70), n3(:,58), t3x8(:,:,46))
  call vert_AV_Q(ntry, ex2(:), wf4(:,8), wf8(:,71), n3(:,59), t3x8(:,:,47))
  call vert_AV_Q(ntry, ex2(:), wf4(:,9), wf8(:,72), n3(:,60), t3x8(:,:,48))
  call vert_QA_V(ntry, wf8(:,9), ex4(:), wf16(:,7), n3(:,61), t3x16(:,:,7))
  call vert_QA_V(ntry, ex3(:), wf8(:,31), wf16(:,8), n3(:,62), t3x16(:,:,8))
  call vert_QA_V(ntry, wf8(:,3), ex6(:), wf16(:,9), n3(:,63), t3x16(:,:,9))
  call vert_QA_V(ntry, ex5(:), wf8(:,22), wf16(:,10), n3(:,64), t3x16(:,:,10))
  call vert_QA_V(ntry, wf8(:,15), ex2(:), wf16(:,11), n3(:,65), t3x16(:,:,11))
  call vert_QA_V(ntry, ex1(:), wf8(:,48), wf16(:,12), n3(:,66), t3x16(:,:,12))
  call vert_QA_V(ntry, wf8(:,6), ex6(:), wf16(:,13), n3(:,67), t3x16(:,:,13))
  call vert_QA_V(ntry, ex5(:), wf8(:,24), wf16(:,14), n3(:,68), t3x16(:,:,14))
  call vert_QA_V(ntry, wf8(:,18), ex2(:), wf16(:,15), n3(:,69), t3x16(:,:,15))
  call vert_QA_V(ntry, ex1(:), wf8(:,46), wf16(:,16), n3(:,70), t3x16(:,:,16))
  call vert_QA_V(ntry, wf8(:,12), ex4(:), wf16(:,17), n3(:,71), t3x16(:,:,17))
  call vert_QA_V(ntry, ex3(:), wf8(:,33), wf16(:,18), n3(:,72), t3x16(:,:,18))


  call init_hybrid_exwf(ex1)
  call init_hybrid_exwf(ex2)
  call init_hybrid_exwf(ex3)
  call init_hybrid_exwf(ex4)
  call init_hybrid_exwf(ex5)
  call init_hybrid_exwf(ex6)
  call init_hybrid_wf(wf4)
  call init_hybrid_wf(wf8)
  call init_hybrid_wf(wf16)


  if (ntry==1) then
    call physical_helicities()
  end if

  ! computation of the colour-stripped amplitudes
  do nsync = ntry+ntry-1, ntry+1  !  nsync = 1,2  for 1st point and nsync = 3 later
    call diagrams()
    if (nsync == 1) call helsync(nsync, A, nhel, Hel)
  end do

  ! In the following loop the coefficients \Gamma_{i} of the expansion in
  ! the colour basis are computed for every helicity state and stored in M1helarray.
  ! Also the colour vector for the Born-loop interference is computed and saved in
  ! M0_col1_helarray
  do k = 1, nhel
    call colourvectors(A, k, M1helarray(:,k),M1helarray_ct(:,k))
    call colborninterf(M1helarray(:,k), M0_col1_helarray(:,k))
  end do
  M1helarray(:,nhel+1:)%j = 0
  M0_col1_helarray(:,nhel+1:)%hf = -1_intkind2
  M0_col1_helarray(:,nhel+1:)%j = 0

  M2add = 0
  M2add_ct = 0
  M2add_colint = 0

  M02 = 0
  M2ct = 0
  M2colint = 0
  
    do k = 1, nhel
      call colint(M1helarray(:,k)%j, M2add)
      call colint_ct(M1helarray(:,k)%j, M1helarray_ct(:,k)%j, M2add_ct)
      if (IR_is_on > 0) then
	call colint_IR(M1helarray(:,k)%j, M2add_colint)
      end if
      !summation over helicity configurations
      M02 = M02 + M2add
      M2ct = M2ct + M2add_ct
      M2colint = M2colint + M2add_colint
    end do



  contains

subroutine physical_helicities()
  implicit none 

integer :: i1,i2,i3,i4,i5,i6
integer :: n

n=0

do i6= 1, 2
do i5= 1, 2
do i4= 1, 2
do i3= 1, 2
do i2= 1, 2
do i1= 1, 2
n = n + 1
 if((ex1(i1)%hf==-1_intkind2) .OR. (ex2(i2)%hf==-1_intkind2) .OR. (ex3(i3)%hf==-1_intkind2) .OR. (ex4(i4)%hf==-1_intkind2)  &
    .OR. (ex5(i5)%hf==-1_intkind2) .OR. (ex6(i6)%hf==-1_intkind2)) then
  Hel(n) = -1_intkind2
 else
  Hel(n) = ex1(i1)%hf + ex2(i2)%hf + ex3(i3)%hf + ex4(i4)%hf + ex5(i5)%hf + ex6(i6)%hf
 end if
end do
end do
end do
end do
end do
end do

end subroutine physical_helicities

subroutine diagrams()
  implicit none
  integer :: h
  ! e.g. call cont_VV(nsync, wf3, wf6, A(:,1), n64, t64, nhel, den(5)) ...

    call Hcont_VV(nsync, wf4(:,3), wf16(:,1), A(:,1), n3(:,73), t3x64(:,:,1), nhel, den(5))
    call Hcont_QA(nsync, wf8(:,2), wf8(:,3), A(:,2), n3(:,74), t3x64(:,:,2), nhel, den(8))
    call Hcont_QA(nsync, wf8(:,5), wf8(:,6), A(:,3), n3(:,75), t3x64(:,:,3), nhel, den(11))
    call Hcont_QA(nsync, wf8(:,8), wf8(:,9), A(:,4), n3(:,76), t3x64(:,:,4), nhel, den(14))
    call Hcont_QA(nsync, wf8(:,11), wf8(:,12), A(:,5), n3(:,77), t3x64(:,:,5), nhel, den(17))
    call Hcont_QA(nsync, wf8(:,14), wf8(:,15), A(:,6), n3(:,78), t3x64(:,:,6), nhel, den(20))
    call Hcont_QA(nsync, wf8(:,17), wf8(:,18), A(:,7), n3(:,79), t3x64(:,:,7), nhel, den(23))

    call Hcont_VV(nsync, wf4(:,3), wf16(:,2), A(:,8), n3(:,80), t3x64(:,:,8), nhel, den(5))
    call Hcont_QA(nsync, wf8(:,3), wf8(:,19), A(:,9), n3(:,81), t3x64(:,:,9), nhel, den(8))
    call Hcont_QA(nsync, wf8(:,6), wf8(:,20), A(:,10), n3(:,82), t3x64(:,:,10), nhel, den(11))
    call Hcont_QA(nsync, wf8(:,21), wf8(:,22), A(:,11), n3(:,83), t3x64(:,:,11), nhel, den(26))
    call Hcont_QA(nsync, wf8(:,23), wf8(:,24), A(:,12), n3(:,84), t3x64(:,:,12), nhel, den(29))
    call Hcont_VV(nsync, wf16(:,1), wf4(:,4), A(:,13), n3(:,85), t3x64(:,:,13), nhel, den(5))
    call Hcont_QA(nsync, wf8(:,9), wf8(:,25), A(:,14), n3(:,86), t3x64(:,:,14), nhel, den(14))
    call Hcont_QA(nsync, wf8(:,11), wf8(:,27), A(:,15), n3(:,87), t3x64(:,:,15), nhel, den(17))
    call Hcont_QA(nsync, wf8(:,9), wf8(:,28), A(:,16), n3(:,88), t3x64(:,:,16), nhel, den(14))
    call Hcont_QA(nsync, wf8(:,12), wf8(:,29), A(:,17), n3(:,89), t3x64(:,:,17), nhel, den(17))
    call Hcont_QA(nsync, wf8(:,30), wf8(:,31), A(:,18), n3(:,90), t3x64(:,:,18), nhel, den(32))
    call Hcont_QA(nsync, wf8(:,32), wf8(:,33), A(:,19), n3(:,91), t3x64(:,:,19), nhel, den(35))
    call Hcont_VV(nsync, wf4(:,3), wf16(:,3), A(:,20), n3(:,92), t3x64(:,:,20), nhel, den(5))
    call Hcont_QA(nsync, wf8(:,3), wf8(:,34), A(:,21), n3(:,93), t3x64(:,:,21), nhel, den(8))
    call Hcont_QA(nsync, wf8(:,5), wf8(:,36), A(:,22), n3(:,94), t3x64(:,:,22), nhel, den(11))
    call Hcont_QA(nsync, wf8(:,15), wf8(:,37), A(:,23), n3(:,95), t3x64(:,:,23), nhel, den(20))
    call Hcont_QA(nsync, wf8(:,17), wf8(:,39), A(:,24), n3(:,96), t3x64(:,:,24), nhel, den(23))
    call Hcont_QA(nsync, wf8(:,18), wf8(:,40), A(:,25), n3(:,97), t3x64(:,:,25), nhel, den(23))
    call Hcont_QA(nsync, wf8(:,14), wf8(:,42), A(:,26), n3(:,98), t3x64(:,:,26), nhel, den(20))
    call Hcont_QA(nsync, wf8(:,15), wf8(:,43), A(:,27), n3(:,99), t3x64(:,:,27), nhel, den(20))
    call Hcont_QA(nsync, wf8(:,18), wf8(:,44), A(:,28), n3(:,100), t3x64(:,:,28), nhel, den(23))
    call Hcont_QA(nsync, wf8(:,45), wf8(:,46), A(:,29), n3(:,101), t3x64(:,:,29), nhel, den(38))
    call Hcont_QA(nsync, wf8(:,47), wf8(:,48), A(:,30), n3(:,102), t3x64(:,:,30), nhel, den(41))
    call Hcont_VV(nsync, wf4(:,3), wf16(:,4), A(:,31), n3(:,103), t3x64(:,:,31), nhel, den(5))
    call Hcont_QA(nsync, wf8(:,2), wf8(:,50), A(:,32), n3(:,104), t3x64(:,:,32), nhel, den(8))
    call Hcont_QA(nsync, wf8(:,6), wf8(:,51), A(:,33), n3(:,105), t3x64(:,:,33), nhel, den(11))
    call Hcont_QA(nsync, wf8(:,8), wf8(:,53), A(:,34), n3(:,106), t3x64(:,:,34), nhel, den(14))
    call Hcont_QA(nsync, wf8(:,12), wf8(:,54), A(:,35), n3(:,107), t3x64(:,:,35), nhel, den(17))
    call Hcont_VV(nsync, wf16(:,5), wf4(:,7), A(:,36), n3(:,108), t3x64(:,:,36), nhel, den(45))
    call Hcont_VV(nsync, wf16(:,6), wf4(:,8), A(:,37), n3(:,109), t3x64(:,:,37), nhel, den(49))
    call Hcont_VV(nsync, wf16(:,1), wf4(:,9), A(:,38), n3(:,110), t3x64(:,:,38), nhel, den(52))
    call Hcont_QA(nsync, wf8(:,24), wf8(:,55), A(:,39), n3(:,111), t3x64(:,:,39), nhel, den(54))
    call Hcont_QA(nsync, wf8(:,6), wf8(:,56), A(:,40), n3(:,112), t3x64(:,:,40), nhel, den(55))
    call Hcont_QA(nsync, wf8(:,22), wf8(:,57), A(:,41), n3(:,113), t3x64(:,:,41), nhel, den(57))
    call Hcont_QA(nsync, wf8(:,3), wf8(:,58), A(:,42), n3(:,114), t3x64(:,:,42), nhel, den(58))
    call Hcont_QA(nsync, wf8(:,24), wf8(:,59), A(:,43), n3(:,115), t3x64(:,:,43), nhel, den(59))
    call Hcont_QA(nsync, wf8(:,22), wf8(:,60), A(:,44), n3(:,116), t3x64(:,:,44), nhel, den(60))
    call Hcont_QA(nsync, wf8(:,33), wf8(:,61), A(:,45), n3(:,117), t3x64(:,:,45), nhel, den(61))
    call Hcont_QA(nsync, wf8(:,12), wf8(:,62), A(:,46), n3(:,118), t3x64(:,:,46), nhel, den(62))
    call Hcont_QA(nsync, wf8(:,33), wf8(:,63), A(:,47), n3(:,119), t3x64(:,:,47), nhel, den(63))
    call Hcont_QA(nsync, wf8(:,31), wf8(:,64), A(:,48), n3(:,120), t3x64(:,:,48), nhel, den(64))
    call Hcont_QA(nsync, wf8(:,31), wf8(:,65), A(:,49), n3(:,121), t3x64(:,:,49), nhel, den(66))
    call Hcont_QA(nsync, wf8(:,9), wf8(:,66), A(:,50), n3(:,122), t3x64(:,:,50), nhel, den(67))
    call Hcont_QA(nsync, wf8(:,46), wf8(:,67), A(:,51), n3(:,123), t3x64(:,:,51), nhel, den(68))
    call Hcont_QA(nsync, wf8(:,48), wf8(:,68), A(:,52), n3(:,124), t3x64(:,:,52), nhel, den(69))
    call Hcont_QA(nsync, wf8(:,46), wf8(:,69), A(:,53), n3(:,125), t3x64(:,:,53), nhel, den(70))
    call Hcont_QA(nsync, wf8(:,48), wf8(:,70), A(:,54), n3(:,126), t3x64(:,:,54), nhel, den(71))
    call Hcont_QA(nsync, wf8(:,18), wf8(:,71), A(:,55), n3(:,127), t3x64(:,:,55), nhel, den(72))
    call Hcont_QA(nsync, wf8(:,15), wf8(:,72), A(:,56), n3(:,128), t3x64(:,:,56), nhel, den(73))

end subroutine diagrams


elemental function diagmap(j, n)
  implicit none
  integer, intent(in) :: j, n
  complex(REALKIND) :: diagmap
  diagmap = A(j,n)%j
end function diagmap

function diagsum(j, pos, neg)
  implicit none
  integer, intent(in) :: j, pos(:), neg(:)
  complex(REALKIND) :: diagsum
  diagsum = sum(diagmap(j, pos)) - sum(diagmap(j, neg))
end function diagsum

subroutine colourvectors(A, j, M1, M2)
  implicit none
  type(Hpolcont) :: A(:,:)
  integer, intent(in) :: j
  type(Hpolcont), intent(out) :: M1(6), M2(6) ! M1helarray(6,64)
  integer :: empty(0), i

  M1(1)%j = ((-A(j,2)%j-A(j,3)%j-A(j,6)%j-A(j,7)%j)*f(1))/12._/**/REALKIND
  M1(2)%j = ((A(j,3)%j+A(j,4)%j+A(j,7)%j)*f(1))/4._/**/REALKIND+(CI*A(j,1)%j*f(2))/4._/**/REALKIND
  M1(3)%j = ((A(j,2)%j+A(j,5)%j+A(j,6)%j)*f(1))/4._/**/REALKIND-(CI*A(j,1)%j*f(2))/4._/**/REALKIND
  M1(4)%j = ((-A(j,2)%j-A(j,3)%j-A(j,4)%j-A(j,5)%j)*f(1))/12._/**/REALKIND
  M1(5)%j = ((-A(j,4)%j-A(j,5)%j-A(j,6)%j-A(j,7)%j)*f(1))/12._/**/REALKIND
  M1(6)%j = ((A(j,2)%j+A(j,3)%j+A(j,4)%j+A(j,5)%j+A(j,6)%j+A(j,7)%j)*f(1))/36._/**/REALKIND

  M2(1)%j = ((A(j,39)%j+A(j,40)%j+A(j,41)%j+A(j,42)%j+A(j,43)%j+A(j,44)%j+A(j,51)%j+A(j,52)%j+A(j,53)%j+A(j,54)%j+A(j,55)%j &
       +A(j,56)%j)*f(3))/12._/**/REALKIND+((-A(j,9)%j-A(j,10)%j-A(j,11)%j-A(j,12)%j-A(j,23)%j-A(j,24)%j)*f(5))/12._/**/REALKIND+(( &
       -A(j,21)%j-A(j,22)%j-A(j,25)%j-A(j,26)%j)*f(7))/12._/**/REALKIND+((-A(j,27)%j-A(j,28)%j-A(j,29)%j-A(j,30)%j-A(j,32)%j &
       -A(j,33)%j)*f(9))/12._/**/REALKIND
  M2(2)%j = ((-A(j,40)%j-A(j,41)%j-A(j,44)%j-A(j,45)%j-A(j,47)%j-A(j,50)%j-A(j,52)%j-A(j,54)%j-A(j,55)%j)*f(3))/4._/**/REALKIND &
       +(CI*(-A(j,36)%j+A(j,37)%j-A(j,38)%j)*f(4))/4._/**/REALKIND+((A(j,10)%j+A(j,11)%j+A(j,14)%j &
       +A(j,24)%j)*f(5))/4._/**/REALKIND+(CI*A(j,13)%j*f(6))/4._/**/REALKIND+((A(j,16)%j+A(j,19)%j+A(j,22)%j &
       +A(j,25)%j)*f(7))/4._/**/REALKIND+(CI*A(j,20)%j*f(8))/4._/**/REALKIND+((A(j,28)%j+A(j,30)%j+A(j,33)%j &
       +A(j,34)%j)*f(9))/4._/**/REALKIND+(CI*A(j,31)%j*f(10))/4._/**/REALKIND+(CI*A(j,8)%j*f(11))/4._/**/REALKIND
  M2(3)%j = ((-A(j,39)%j-A(j,42)%j-A(j,43)%j-A(j,46)%j-A(j,48)%j-A(j,49)%j-A(j,51)%j-A(j,53)%j-A(j,56)%j)*f(3))/4._/**/REALKIND &
       +(CI*(A(j,36)%j-A(j,37)%j+A(j,38)%j)*f(4))/4._/**/REALKIND+((A(j,9)%j+A(j,12)%j+A(j,15)%j+A(j,23)%j)*f(5))/4._/**/REALKIND &
       -(CI*A(j,13)%j*f(6))/4._/**/REALKIND+((A(j,17)%j+A(j,18)%j+A(j,21)%j+A(j,26)%j)*f(7))/4._/**/REALKIND &
       -(CI*A(j,20)%j*f(8))/4._/**/REALKIND+((A(j,27)%j+A(j,29)%j+A(j,32)%j+A(j,35)%j)*f(9))/4._/**/REALKIND &
       -(CI*A(j,31)%j*f(10))/4._/**/REALKIND-(CI*A(j,8)%j*f(11))/4._/**/REALKIND
  M2(4)%j = ((A(j,39)%j+A(j,40)%j+A(j,41)%j+A(j,42)%j+A(j,43)%j+A(j,44)%j+A(j,45)%j+A(j,46)%j+A(j,47)%j+A(j,48)%j+A(j,49)%j &
       +A(j,50)%j)*f(3))/12._/**/REALKIND+((-A(j,9)%j-A(j,10)%j-A(j,11)%j-A(j,12)%j-A(j,14)%j-A(j,15)%j)*f(5))/12._/**/REALKIND+(( &
       -A(j,16)%j-A(j,17)%j-A(j,18)%j-A(j,19)%j-A(j,21)%j-A(j,22)%j)*f(7))/12._/**/REALKIND+((-A(j,32)%j-A(j,33)%j-A(j,34)%j &
       -A(j,35)%j)*f(9))/12._/**/REALKIND
  M2(5)%j = ((A(j,45)%j+A(j,46)%j+A(j,47)%j+A(j,48)%j+A(j,49)%j+A(j,50)%j+A(j,51)%j+A(j,52)%j+A(j,53)%j+A(j,54)%j+A(j,55)%j &
       +A(j,56)%j)*f(3))/12._/**/REALKIND+((-A(j,14)%j-A(j,15)%j-A(j,23)%j-A(j,24)%j)*f(5))/12._/**/REALKIND+((-A(j,16)%j &
       -A(j,17)%j-A(j,18)%j-A(j,19)%j-A(j,25)%j-A(j,26)%j)*f(7))/12._/**/REALKIND+((-A(j,27)%j-A(j,28)%j-A(j,29)%j-A(j,30)%j &
       -A(j,34)%j-A(j,35)%j)*f(9))/12._/**/REALKIND
  M2(6)%j = ((-A(j,39)%j-A(j,40)%j-A(j,41)%j-A(j,42)%j-A(j,43)%j-A(j,44)%j-A(j,45)%j-A(j,46)%j-A(j,47)%j-A(j,48)%j-A(j,49)%j &
       -A(j,50)%j-A(j,51)%j-A(j,52)%j-A(j,53)%j-A(j,54)%j-A(j,55)%j-A(j,56)%j)*f(3))/36._/**/REALKIND+((A(j,9)%j+A(j,10)%j &
       +A(j,11)%j+A(j,12)%j+A(j,14)%j+A(j,15)%j+A(j,23)%j+A(j,24)%j)*f(5))/36._/**/REALKIND+((A(j,16)%j+A(j,17)%j+A(j,18)%j &
       +A(j,19)%j+A(j,21)%j+A(j,22)%j+A(j,25)%j+A(j,26)%j)*f(7))/36._/**/REALKIND+((A(j,27)%j+A(j,28)%j+A(j,29)%j+A(j,30)%j &
       +A(j,32)%j+A(j,33)%j+A(j,34)%j+A(j,35)%j)*f(9))/36._/**/REALKIND


  M1(:)%hf = Hel(j)
  M2(:)%hf = Hel(j)  

  !M(i) corresponds to \Gamma_{i} in Fabio's thesis

end subroutine colourvectors


! **********************************************************************
subroutine colint(M, M2colint)
! M(i)   = <M|Ci> colour component of matrix element
! COLINT = <M|M>
!        = Sum_{i,j} <M|Ci> * <Ci|Cj> * <Cj|M>
!        = colour-summed squared matrix element
! K2(i,j) = <Ci|Cj>
! **********************************************************************
  use ol_colourmatrix_ppttjj_ttxddxbbx_1_/**/REALKIND, only: K1
  implicit none

  complex(REALKIND), intent(in)  :: M(6)
  real(REALKIND),    intent(out) :: M2colint
  integer :: i, j

  M2colint = 0

    do i = 1, 6
      do j = 1, 6
        M2colint = M2colint + real(conjg(M(i))*K1(i,j)*M(j))
      end do
    end do

end subroutine colint

! **********************************************************************
subroutine colint_ct(M, Mct, M2colint_ct)
! M(i)   = <M|Ci> colour component of matrix element
! COLINT = <M|M>
!        = Sum_{i,j} <M|Ci> * <Ci|Cj> * <Cj|M>
!        = colour-summed squared matrix element
! K2(i,j) = <Ci|Cj>
! **********************************************************************
  use ol_colourmatrix_ppttjj_ttxddxbbx_1_/**/REALKIND, only: K2
  implicit none

  complex(REALKIND), intent(in)  :: M(6), Mct(6)
  real(REALKIND),    intent(out) :: M2colint_ct
  integer ::  i, j

  M2colint_ct = 0

    do i = 1, 6
      do j = 1, 6
        M2colint_ct = M2colint_ct + real(conjg(M(i))*K2(i,j)*Mct(j))
      end do
    end do


end subroutine colint_ct

! **********************************************************************
subroutine colint_IR(M, M2IRadd)
! M(i)   = <M|Ci> colour component of matrix element
! K1(i,j) = .....
! **********************************************************************
  use ol_colourmatrix_ppttjj_ttxddxbbx_1_/**/REALKIND, only: K1
  implicit none

  complex(REALKIND), intent(in)  :: M(6)
  real(REALKIND),    intent(out) :: M2IRadd(22)
  integer ::  i, j, k, colmatpos

  M2IRadd = 0

  do k = 1, 23-1
    colmatpos = 6*k
    do i = 1, 6
      do j = 1, 6
	M2IRadd(k) = M2IRadd(k) + real(conjg(M(i))*K1(i+colmatpos,j)*M(j))
      end do
    end do
  end do
  
end subroutine colint_IR

! **********************************************************************
subroutine colintmunu(M1, M2, M2colint)
! M1(i)    = <M1|Ci> colour component of matrix element
! M2(i)    = <M2|Ci> colour component of matrix element
! M2colint = <M1|M2>
!          = Sum_{i,j} <M1|Ci> * <Ci|Cj> * <Cj|M2>
!          = colour-summed squared matrix element
! K2(i,j) = <Ci|Cj>
! **********************************************************************
  use ol_colourmatrix_ppttjj_ttxddxbbx_1_/**/REALKIND, only: K2
  implicit none

  complex(REALKIND), intent(in)  :: M1(6)
  complex(REALKIND), intent(in)  :: M2(6)
  complex(REALKIND),    intent(out) :: M2colint
  integer :: i, j

  M2colint = 0

  do i = 1, 6
    do j = 1, 6
      M2colint = M2colint + M1(i)*K2(i,j)*conjg(M2(j))
    end do
  end do

end subroutine colintmunu





! **********************************************************************
subroutine colborninterf(M, M0_col)
! M(i)         = <M|Ci> colour component of matrix element
! M0_col(i)    = <M2|Ci> colour component of matrix element,
!                see \tilde{M}_{j} in Fabio's thesis
! M2colint = Sum_{i} <M1|Ci> * <Ci|Cj>
!          = colour-summed squared matrix element
! KL(i,j) = <Ci|Cj> with elements Cj of 1-loop colour basis
! **********************************************************************
  use ol_colourmatrix_ppttjj_ttxddxbbx_1_/**/REALKIND, only: KL
  implicit none

  type(Hpolcont), intent(in)  :: M(6)
  type(Hpolcont), intent(out)  :: M0_col(6)
  integer :: i, j


  do j = 1, 6 !size(KL(1,:))
    M0_col(j)%j = 0
    M0_col(j)%hf = M(1)%hf
    do i = 1, 6 !size(KL(:,1))
      M0_col(j)%j = M0_col(j)%j  + conjg(M(i)%j)*KL(i,j)
    end do    
  end do

end subroutine colborninterf

end subroutine amp2

end module ol_loop_ppttjj_ttxddxbbx_1_/**/REALKIND
