
module ol_colourmatrix_ppttjj_ttxdddxdx_1_/**/REALKIND
  use KIND_TYPES, only: REALKIND
  implicit none
  logical, save           :: colmat_not_initialised = .true.
  complex(REALKIND), save :: K1(138,6), K2(6,6), KL(6,6)
  contains
  subroutine colourmatrix_init
    use ol_parameters_decl_/**/REALKIND, only: CI
    implicit none
    colmat_not_initialised = .false.
    ! colour matrix

  K1(  1,:) = [  27,   9,   9,   3,   3,   9]
  K1(  2,:) = [   9,  27,   3,   9,   9,   3]
  K1(  3,:) = [   9,   3,  27,   9,   9,   3]
  K1(  4,:) = [   3,   9,   9,  27,   3,   9]
  K1(  5,:) = [   3,   9,   9,   3,  27,   9]
  K1(  6,:) = [   9,   3,   3,   9,   9,  27]
  K1(  7,:) = [  36,  12,  12,   4,   4,  12]
  K1(  8,:) = [  12,  36,   4,  12,  12,   4]
  K1(  9,:) = [  12,   4,  36,  12,  12,   4]
  K1( 10,:) = [   4,  12,  12,  36,   4,  12]
  K1( 11,:) = [   4,  12,  12,   4,  36,  12]
  K1( 12,:) = [  12,   4,   4,  12,  12,  36]
  K1( 13,:) = [   0,   0,   0,  -4,  -4, -12]
  K1( 14,:) = [   0,   0,  -4, -12,   0,  -4]
  K1( 15,:) = [   0,  -4,   0, -12,   0,  -4]
  K1( 16,:) = [  -4, -12, -12, -36,  -4, -12]
  K1( 17,:) = [  -4,   0,   0,  -4,   0, -12]
  K1( 18,:) = [ -12,  -4,  -4, -12, -12, -36]
  K1( 19,:) = [  36,  12,  12,   4,   4,  12]
  K1( 20,:) = [  12,  36,   4,  12,  12,   4]
  K1( 21,:) = [  12,   4,  36,  12,  12,   4]
  K1( 22,:) = [   4,  12,  12,  36,   4,  12]
  K1( 23,:) = [   4,  12,  12,   4,  36,  12]
  K1( 24,:) = [  12,   4,   4,  12,  12,  36]
  K1( 25,:) = [   0,   0,  12,   4,   4,   0]
  K1( 26,:) = [   0,   0,   4,  12,   0,   4]
  K1( 27,:) = [  12,   4,   0,   0,   0,   4]
  K1( 28,:) = [   4,  12,   0,   0,   4,   0]
  K1( 29,:) = [   4,   0,   0,   4,   0,  12]
  K1( 30,:) = [   0,   4,   4,   0,  12,   0]
  K1( 31,:) = [   0, -12,   0,  -4,  -4,   0]
  K1( 32,:) = [ -12, -36,  -4, -12, -12,  -4]
  K1( 33,:) = [   0,  -4,   0,   0, -12,  -4]
  K1( 34,:) = [  -4, -12,   0,   0,  -4,   0]
  K1( 35,:) = [  -4, -12, -12,  -4, -36, -12]
  K1( 36,:) = [   0,  -4,  -4,   0, -12,   0]
  K1( 37,:) = [  36,  12,  12,   4,   4,  12]
  K1( 38,:) = [  12,  36,   4,  12,  12,   4]
  K1( 39,:) = [  12,   4,  36,  12,  12,   4]
  K1( 40,:) = [   4,  12,  12,  36,   4,  12]
  K1( 41,:) = [   4,  12,  12,   4,  36,  12]
  K1( 42,:) = [  12,   4,   4,  12,  12,  36]
  K1( 43,:) = [   0,   0,   0,   4,   4,  12]
  K1( 44,:) = [   0,   0,   4,   0,  12,   4]
  K1( 45,:) = [   0,   4,   0,  12,   0,   4]
  K1( 46,:) = [   4,   0,  12,   0,   4,   0]
  K1( 47,:) = [   4,  12,   0,   4,   0,   0]
  K1( 48,:) = [  12,   4,   4,   0,   0,   0]
  K1( 49,:) = [ -36, -12, -12,  -4,  -4, -12]
  K1( 50,:) = [ -12,   0,  -4,   0,   0,  -4]
  K1( 51,:) = [ -12,  -4, -36, -12, -12,  -4]
  K1( 52,:) = [  -4,   0, -12,   0,  -4,   0]
  K1( 53,:) = [  -4,   0, -12,  -4,   0,   0]
  K1( 54,:) = [ -12,  -4,  -4,   0,   0,   0]
  K1( 55,:) = [   0,  12,   0,   4,   4,   0]
  K1( 56,:) = [  12,   0,   4,   0,   0,   4]
  K1( 57,:) = [   0,   4,   0,   0,  12,   4]
  K1( 58,:) = [   4,   0,   0,   0,   4,  12]
  K1( 59,:) = [   4,   0,  12,   4,   0,   0]
  K1( 60,:) = [   0,   4,   4,  12,   0,   0]
  K1( 61,:) = [  36,  12,  12,   4,   4,  12]
  K1( 62,:) = [  12,  36,   4,  12,  12,   4]
  K1( 63,:) = [  12,   4,  36,  12,  12,   4]
  K1( 64,:) = [   4,  12,  12,  36,   4,  12]
  K1( 65,:) = [   4,  12,  12,   4,  36,  12]
  K1( 66,:) = [  12,   4,   4,  12,  12,  36]
  K1( 67,:) = [   0,   0, -12,  -4,  -4,   0]
  K1( 68,:) = [   0,   0,  -4,   0, -12,  -4]
  K1( 69,:) = [ -12,  -4, -36, -12, -12,  -4]
  K1( 70,:) = [  -4,   0, -12,   0,  -4,   0]
  K1( 71,:) = [  -4, -12, -12,  -4, -36, -12]
  K1( 72,:) = [   0,  -4,  -4,   0, -12,   0]
  K1( 73,:) = [   0,  12,   0,   4,   4,   0]
  K1( 74,:) = [  12,   0,   4,   0,   0,   4]
  K1( 75,:) = [   0,   4,   0,  12,   0,   4]
  K1( 76,:) = [   4,   0,  12,   0,   4,   0]
  K1( 77,:) = [   4,   0,   0,   4,   0,  12]
  K1( 78,:) = [   0,   4,   4,   0,  12,   0]
  K1( 79,:) = [ -36, -12, -12,  -4,  -4, -12]
  K1( 80,:) = [ -12,   0,  -4,   0,   0,  -4]
  K1( 81,:) = [ -12,  -4,   0,   0,   0,  -4]
  K1( 82,:) = [  -4,   0,   0,   0,  -4, -12]
  K1( 83,:) = [  -4,   0,   0,  -4,   0, -12]
  K1( 84,:) = [ -12,  -4,  -4, -12, -12, -36]
  K1( 85,:) = [   0, -12,   0,  -4,  -4,   0]
  K1( 86,:) = [ -12, -36,  -4, -12, -12,  -4]
  K1( 87,:) = [   0,  -4,   0, -12,   0,  -4]
  K1( 88,:) = [  -4, -12, -12, -36,  -4, -12]
  K1( 89,:) = [  -4, -12,   0,  -4,   0,   0]
  K1( 90,:) = [   0,  -4,  -4, -12,   0,   0]
  K1( 91,:) = [  36,  12,  12,   4,   4,  12]
  K1( 92,:) = [  12,  36,   4,  12,  12,   4]
  K1( 93,:) = [  12,   4,  36,  12,  12,   4]
  K1( 94,:) = [   4,  12,  12,  36,   4,  12]
  K1( 95,:) = [   4,  12,  12,   4,  36,  12]
  K1( 96,:) = [  12,   4,   4,  12,  12,  36]
  K1( 97,:) = [ -36, -12, -12,  -4,  -4, -12]
  K1( 98,:) = [ -12, -36,  -4, -12, -12,  -4]
  K1( 99,:) = [ -12,  -4,   0,   0,   0,  -4]
  K1(100,:) = [  -4, -12,   0,   0,  -4,   0]
  K1(101,:) = [  -4, -12,   0,  -4,   0,   0]
  K1(102,:) = [ -12,  -4,  -4,   0,   0,   0]
  K1(103,:) = [   0,   0,   0,   4,   4,  12]
  K1(104,:) = [   0,   0,   4,  12,   0,   4]
  K1(105,:) = [   0,   4,   0,   0,  12,   4]
  K1(106,:) = [   4,  12,   0,   0,   4,   0]
  K1(107,:) = [   4,   0,  12,   4,   0,   0]
  K1(108,:) = [  12,   4,   4,   0,   0,   0]
  K1(109,:) = [   0,   0, -12,  -4,  -4,   0]
  K1(110,:) = [   0,   0,  -4, -12,   0,  -4]
  K1(111,:) = [ -12,  -4, -36, -12, -12,  -4]
  K1(112,:) = [  -4, -12, -12, -36,  -4, -12]
  K1(113,:) = [  -4,   0, -12,  -4,   0,   0]
  K1(114,:) = [   0,  -4,  -4, -12,   0,   0]
  K1(115,:) = [   0,   0,   0,  -4,  -4, -12]
  K1(116,:) = [   0,   0,  -4,   0, -12,  -4]
  K1(117,:) = [   0,  -4,   0,   0, -12,  -4]
  K1(118,:) = [  -4,   0,   0,   0,  -4, -12]
  K1(119,:) = [  -4, -12, -12,  -4, -36, -12]
  K1(120,:) = [ -12,  -4,  -4, -12, -12, -36]
  K1(121,:) = [   0,   0,  12,   4,   4,   0]
  K1(122,:) = [   0,   0,   4,   0,  12,   4]
  K1(123,:) = [  12,   4,   0,   0,   0,   4]
  K1(124,:) = [   4,   0,   0,   0,   4,  12]
  K1(125,:) = [   4,  12,   0,   4,   0,   0]
  K1(126,:) = [   0,   4,   4,  12,   0,   0]
  K1(127,:) = [  36,  12,  12,   4,   4,  12]
  K1(128,:) = [  12,  36,   4,  12,  12,   4]
  K1(129,:) = [  12,   4,  36,  12,  12,   4]
  K1(130,:) = [   4,  12,  12,  36,   4,  12]
  K1(131,:) = [   4,  12,  12,   4,  36,  12]
  K1(132,:) = [  12,   4,   4,  12,  12,  36]
  K1(133,:) = [   0,   0,   0,   0,   0,   0]
  K1(134,:) = [   0,   0,   0,   0,   0,   0]
  K1(135,:) = [   0,   0,   0,   0,   0,   0]
  K1(136,:) = [   0,   0,   0,   0,   0,   0]
  K1(137,:) = [   0,   0,   0,   0,   0,   0]
  K1(138,:) = [   0,   0,   0,   0,   0,   0]

  K2(1,:) = [ 27,  9,  9,  3,  3,  9]
  K2(2,:) = [  9, 27,  3,  9,  9,  3]
  K2(3,:) = [  9,  3, 27,  9,  9,  3]
  K2(4,:) = [  3,  9,  9, 27,  3,  9]
  K2(5,:) = [  3,  9,  9,  3, 27,  9]
  K2(6,:) = [  9,  3,  3,  9,  9, 27]

  KL(1,:) = [ 27,  9,  9,  3,  3,  9]
  KL(2,:) = [  9, 27,  3,  9,  9,  3]
  KL(3,:) = [  9,  3, 27,  9,  9,  3]
  KL(4,:) = [  3,  9,  9, 27,  3,  9]
  KL(5,:) = [  3,  9,  9,  3, 27,  9]
  KL(6,:) = [  9,  3,  3,  9,  9, 27]

  end subroutine colourmatrix_init
end module ol_colourmatrix_ppttjj_ttxdddxdx_1_/**/REALKIND



module ol_forced_parameters_ppttjj_ttxdddxdx_1_/**/REALKIND
  implicit none
  contains
  subroutine check_forced_parameters
    use ol_parameters_decl_/**/REALKIND
    use ol_loop_parameters_decl_/**/REALKIND
#ifndef PRECISION_dp
    use ol_loop_parameters_decl_/**/DREALKIND, only: LeadingColour, nc, nf, CKMORDER
#endif
    implicit none
    logical, save :: checks_not_written = .true.

    if (checks_not_written) then
    ! e.g.
    ! if (ME /= 0) write(*,101) 'ME = 0'
  if (CKMORDER /= 0) write(*,101) 'CKMORDER = 0'
  if (nc /= 3) write(*,101) 'nc = 3'
  if (nf /= 6) write(*,101) 'nf = 6'
  if (MU /= 0) write(*,101) 'MU = 0'
  if (MD /= 0) write(*,101) 'MD = 0'
  if (MS /= 0) write(*,101) 'MS = 0'
  if (MC /= 0) write(*,101) 'MC = 0'
  if (LeadingColour /= 0) write(*,101) 'LeadingColour = 0'
  if (wMT /= 0) write(*,101) 'wMT = 0'
  if (wMT /= 0) write(*,101) 'wMT = 0'


    checks_not_written = .false.
    end if

    101 format('[OpenLoops] === WARNING ===',/,'[OpenLoops] code was generated with ',A,/,'[OpenLoops] ===============')
  end subroutine check_forced_parameters
end module ol_forced_parameters_ppttjj_ttxdddxdx_1_/**/REALKIND
! **********************************************************************
module ol_loop_storage_ppttjj_ttxdddxdx_1_/**/REALKIND
! **********************************************************************
  use KIND_TYPES, only: REALKIND, intkind1, intkind2  
  use ol_data_types_/**/REALKIND, only: wfun, Hpolcont
  
#ifdef PRECISION_dp
  integer(intkind1), save :: ntry = 1
  integer(intkind1), save :: p_switch = 0 ! switch for dp or qp. Used for memory allocation of the OL types 
  ! the following are flags for memory allocation of the hol coefficients in dp or qp 
  logical, save :: dp_not_alloc = .TRUE., qp_not_alloc = .TRUE.
  integer(intkind2), parameter :: nheltot = 64 ! number of helicity configurations
  integer(intkind2), save :: nhel = 64 ! number of non-vanishing helicity configurations (adapted at runtime)
  integer(intkind2), save :: Hel(64) ! physical helicity states
#endif

  complex(REALKIND), save :: den(185)

  ! external wave functions ex1(h1),... for h<n> helicities
  type(wfun) :: ex1(2), ex2(2), ex3(2), ex4(2), ex5(2), ex6(2)

  ! wf<h>(h,n) n wave functions with h helicity configurations
  type(wfun) :: wf4(4,15), wf8(8,120), wf16(16,36), wf64(64,112)

  ! diagram prefactors
  integer,           save :: fac_status_loop1 = -1, fac_status_loop2 = -1
  complex(REALKIND), save :: f(17), c(36)

  !below the colour vector for Born-Loop interference
  type(Hpolcont),   save :: M0_col1_helarray(6,64)

end module ol_loop_storage_ppttjj_ttxdddxdx_1_/**/REALKIND






! **********************************************************************
module ol_loop_ppttjj_ttxdddxdx_1_/**/REALKIND
! **********************************************************************
  use KIND_TYPES, only: REALKIND, DREALKIND, intkind1, intkind2  
  use ol_data_types_/**/REALKIND, only: wfun, Hpolcont
  use ol_loop_storage_ppttjj_ttxdddxdx_1_/**/REALKIND
  implicit none

!*********************************************************************************
  contains

! **********************************************************************
subroutine fac_init_loop()
! Writes diagram prefactors to 'f', rsp. 'c'
! **********************************************************************
  use ol_parameters_decl_/**/REALKIND
  use ol_loop_parameters_decl_/**/REALKIND
  use ol_init, only: set_parameter, tree_parameters_flush, parameters_flush
#ifndef PRECISION_dp
  use ol_loop_parameters_decl_/**/DREALKIND, only: SwF, SwB
!  use ol_loop_parameters_decl_/**/DREALKIND, only: DOI
#endif
  implicit none
  call set_parameter("ew_renorm", 0)
  if (parameters_status == 0) call tree_parameters_flush()
  if (loop_parameters_status == 0) call parameters_flush()
  fac_status_loop1 = parameters_status
  fac_status_loop2 = loop_parameters_status
  ! factors of the diagrams
    f( 1) = CI*gQCD**4
    f( 2) = gQCD**4
    f( 3) = CI*countertermnorm*gQCD**6
    f( 4) = countertermnorm*gQCD**6
    f( 5) = CI*countertermnorm*ctGqq*gQCD**6
    f( 6) = countertermnorm*ctGqq*gQCD**6
    f( 7) = CI*countertermnorm*ctGtt*gQCD**6
    f( 8) = countertermnorm*ctGtt*gQCD**6
    f( 9) = countertermnorm*ctVVV*gQCD**6
    f(10) = (CI*gQCD**6*integralnorm*SwB)/2._/**/REALKIND
    f(11) = CI*gQCD**6*integralnorm*SwB
    f(12) = (gQCD**6*integralnorm*SwB)/2._/**/REALKIND
    f(13) = gQCD**6*integralnorm*SwB
    f(14) = CI*gQCD**6*integralnorm*SwF
    f(15) = 2*CI*gQCD**6*integralnorm*SwF
    f(16) = gQCD**6*integralnorm*SwF
    f(17) = 2*gQCD**6*integralnorm*SwF

  c = [ 81*CI*f(10), 162*CI*f(10), 9*CI*f(11), 27*CI*f(11), 72*CI*f(11), 81*CI*f(11), 162*CI*f(11), 18*f(12), 54*f(12), 162*f(12) &
    , f(13), 3*f(13), 6*f(13), 8*f(13), 9*f(13), 10*f(13), 18*f(13), 21*f(13), 24*f(13), 27*f(13), 30*f(13), 54*f(13), 63*f(13) &
    , 72*f(13), 81*f(13), 162*f(13), 27*CI*f(14), 27*CI*f(15), 3*f(16), 6*f(16), 9*f(16), 27*f(16), 3*f(17), 6*f(17), 9*f(17) &
    , 27*f(17) ]
  c = (1._/**/REALKIND / 216) * c
end subroutine fac_init_loop

subroutine denominators()
  use ol_parameters_decl_/**/REALKIND ! masses
  use ol_momenta_decl_/**/REALKIND, only: L
  implicit none
  ! propagators
  den(1) = 1 /((L(5,3))+L(6,3))
  den(2) = 1 /((L(5,20))+L(6,20))
  den(3) = 1 /((L(5,40))+L(6,40))
  den(6) = 1 /((L(5,11))+L(6,11))
  den(9) = 1 /((L(5,28))+L(6,28))
  den(12) = 1 /((L(5,36))+L(6,36))
  den(13) = 1 /((L(5,24))+L(6,24))
  den(16) = 1 /((L(5,7))+L(6,7))
  den(22) = 1 /((L(5,44))+L(6,44))
  den(28) = 1 /((L(5,21) - MT2)+L(6,21))
  den(31) = 1 /((L(5,41) - MT2)+L(6,41))
  den(34) = 1 /((L(5,37) - MT2)+L(6,37))
  den(37) = 1 /((L(5,25) - MT2)+L(6,25))
  den(40) = 1 /((L(5,35))+L(6,35))
  den(43) = 1 /((L(5,52))+L(6,52))
  den(46) = 1 /((L(5,19))+L(6,19))
  den(52) = 1 /((L(5,56))+L(6,56))
  den(58) = 1 /((L(5,42) - MT2)+L(6,42))
  den(61) = 1 /((L(5,22) - MT2)+L(6,22))
  den(64) = 1 /((L(5,26) - MT2)+L(6,26))
  den(67) = 1 /((L(5,38) - MT2)+L(6,38))
  den(71) = 1 /((L(5,60))+L(6,60))
  den(75) = 1 /((L(5,43))+L(6,43))
  den(78) = 1 /((L(5,23))+L(6,23))
  den(93) = 1 /((L(5,27))+L(6,27))
  den(96) = 1 /((L(5,39))+L(6,39))

  ! denominators
  den(4) = den(1)*den(2)
  den(5) = den(3)*den(4)
  den(7) = den(1)*den(6)
  den(8) = den(2)*den(7)
  den(10) = den(2)*den(9)
  den(11) = den(1)*den(10)
  den(14) = den(1)*den(12)
  den(15) = den(13)*den(14)
  den(17) = den(1)*den(16)
  den(18) = den(13)*den(17)
  den(19) = den(9)*den(13)
  den(20) = den(1)*den(19)
  den(21) = den(7)*den(12)
  den(23) = den(12)*den(22)
  den(24) = den(1)*den(23)
  den(25) = den(3)*den(17)
  den(26) = den(3)*den(22)
  den(27) = den(1)*den(26)
  den(29) = den(2)*den(28)
  den(30) = den(3)*den(29)
  den(32) = den(3)*den(31)
  den(33) = den(2)*den(32)
  den(35) = den(12)*den(34)
  den(36) = den(13)*den(35)
  den(38) = den(13)*den(37)
  den(39) = den(12)*den(38)
  den(41) = den(1)*den(40)
  den(42) = den(2)*den(41)
  den(44) = den(2)*den(43)
  den(45) = den(1)*den(44)
  den(47) = den(1)*den(46)
  den(48) = den(12)*den(47)
  den(49) = den(12)*den(43)
  den(50) = den(1)*den(49)
  den(51) = den(13)*den(41)
  den(53) = den(13)*den(52)
  den(54) = den(1)*den(53)
  den(55) = den(3)*den(47)
  den(56) = den(3)*den(52)
  den(57) = den(1)*den(56)
  den(59) = den(3)*den(58)
  den(60) = den(2)*den(59)
  den(62) = den(2)*den(61)
  den(63) = den(3)*den(62)
  den(65) = den(13)*den(64)
  den(66) = den(12)*den(65)
  den(68) = den(12)*den(67)
  den(69) = den(13)*den(68)
  den(70) = den(2)*den(3)
  den(72) = den(70)*den(71)
  den(73) = den(1)*den(72)
  den(74) = den(1)*den(3)
  den(76) = den(74)*den(75)
  den(77) = den(2)*den(76)
  den(79) = den(4)*den(78)
  den(80) = den(3)*den(79)
  den(81) = den(1)**2
  den(82) = den(44)*den(81)
  den(83) = den(10)*den(81)
  den(84) = den(2)**2
  den(85) = den(41)*den(84)
  den(86) = den(7)*den(84)
  den(87) = den(7)*den(44)
  den(88) = den(10)*den(41)
  den(89) = den(12)*den(13)
  den(90) = den(71)*den(89)
  den(91) = den(1)*den(90)
  den(92) = den(1)*den(13)
  den(94) = den(92)*den(93)
  den(95) = den(12)*den(94)
  den(97) = den(14)*den(96)
  den(98) = den(13)*den(97)
  den(99) = den(53)*den(81)
  den(100) = den(19)*den(81)
  den(101) = den(13)**2
  den(102) = den(41)*den(101)
  den(103) = den(17)*den(53)
  den(104) = den(19)*den(41)
  den(105) = den(17)*den(101)
  den(106) = den(49)*den(81)
  den(107) = den(23)*den(81)
  den(108) = den(12)**2
  den(109) = den(47)*den(108)
  den(110) = den(7)*den(108)
  den(111) = den(7)*den(49)
  den(112) = den(23)*den(47)
  den(113) = den(56)*den(81)
  den(114) = den(26)*den(81)
  den(115) = den(3)**2
  den(116) = den(47)*den(115)
  den(117) = den(17)*den(56)
  den(118) = den(26)*den(47)
  den(119) = den(17)*den(115)
  den(120) = den(29)*den(59)
  den(121) = den(32)*den(62)
  den(122) = den(59)*den(84)
  den(123) = den(62)*den(115)
  den(124) = den(32)*den(84)
  den(125) = den(29)*den(115)
  den(126) = den(35)*den(65)
  den(127) = den(38)*den(68)
  den(128) = den(65)*den(108)
  den(129) = den(68)*den(101)
  den(130) = den(38)*den(108)
  den(131) = den(35)*den(101)
  den(132) = den(17)*den(78)
  den(133) = den(17)*den(96)
  den(134) = den(7)*den(93)
  den(135) = den(7)*den(75)
  den(136) = den(47)*den(78)
  den(137) = den(47)*den(93)
  den(138) = den(41)*den(96)
  den(139) = den(41)*den(75)
  den(140) = den(29)*den(78)
  den(141) = den(62)*den(78)
  den(142) = den(10)*den(71)
  den(143) = den(44)*den(71)
  den(144) = den(38)*den(93)
  den(145) = den(65)*den(93)
  den(146) = den(19)*den(71)
  den(147) = den(53)*den(71)
  den(148) = den(35)*den(96)
  den(149) = den(68)*den(96)
  den(150) = den(23)*den(71)
  den(151) = den(49)*den(71)
  den(152) = den(32)*den(75)
  den(153) = den(59)*den(75)
  den(154) = den(26)*den(71)
  den(155) = den(56)*den(71)
  den(156) = den(1)*den(2)*den(3)
  den(157) = den(1)*den(12)*den(13)
  den(158) = den(1)*den(70)
  den(159) = den(2)*den(74)
  den(160) = den(1)*den(89)
  den(161) = den(12)*den(92)
  den(162) = den(2)*den(135)
  den(163) = den(2)*den(139)
  den(164) = den(1)*den(142)
  den(165) = den(1)*den(143)
  den(166) = den(13)*den(133)
  den(167) = den(13)*den(138)
  den(168) = den(1)*den(146)
  den(169) = den(1)*den(147)
  den(170) = den(12)*den(134)
  den(171) = den(12)*den(137)
  den(172) = den(1)*den(150)
  den(173) = den(1)*den(151)
  den(174) = den(3)*den(132)
  den(175) = den(3)*den(136)
  den(176) = den(1)*den(154)
  den(177) = den(1)*den(155)
  den(178) = den(3)*den(140)
  den(179) = den(2)*den(152)
  den(180) = den(3)*den(141)
  den(181) = den(2)*den(153)
  den(182) = den(13)*den(148)
  den(183) = den(12)*den(144)
  den(184) = den(13)*den(149)
  den(185) = den(12)*den(145)

end subroutine denominators

!
!
!
!
!
! **********************************************************************
#ifdef PRECISION_dp
subroutine amp2(P_scatt, M02, M2ct, M2colint) &
    & bind(c,name="Hol_f_amp2_ppttjj_ttxdddxdx_1")
#else
subroutine amp2(P_scatt, M02, M2ct, M2colint)
  use ol_loop_storage_ppttjj_ttxdddxdx_1_/**/DREALKIND, only: ntry, nhel, Hel
#endif
! P_scatt(0:3,Npart) = incoming external momenta
! M2  = helicity-summed squared matrix element for top anti-top down down anti-down anti-down -> 0
! **********************************************************************
  use ol_parameters_decl_/**/REALKIND !, only: ci, parameters_status, ZERO, scalefactor, >masses<
  use ol_parameters_init_/**/REALKIND, only: ensure_mp_init
  use ol_kinematics_/**/REALKIND, only: init_kinematics
  use ol_momenta_decl_/**/DREALKIND, only: momenta_nan_check
  use ol_momenta_decl_/**/REALKIND, only: Q
  use ol_data_types_/**/REALKIND
  use ol_h_helicity_bookkeeping_/**/REALKIND, only: &
    & helbookkeeping_wf, helsync, flip_phase
  use ol_helicity_init, only: helbookkeeping_flip, helsync_flip
  use ol_hel_propagators_/**/REALKIND
  use ol_hel_wavefunctions_/**/REALKIND
  use ol_wavefunctions_/**/REALKIND, only: wf_V_Std
  use ol_hel_vertices_/**/REALKIND
  use ol_hel_contractions_/**/REALKIND
  use ol_external_ppttjj_ttxdddxdx_1, only: external_perm_ppttjj_ttxdddxdx_1, &
    & external_perm_inv_ppttjj_ttxdddxdx_1, extcomb_perm_ppttjj_ttxdddxdx_1, &
    & average_factor_ppttjj_ttxdddxdx_1
  use ol_external_ppttjj_ttxdddxdx_1, only: H, hel_not_initialised, hel_init, POLSEL
  use ol_colourmatrix_ppttjj_ttxdddxdx_1_/**/REALKIND, only: colmat_not_initialised, colourmatrix_init
  use ol_forced_parameters_ppttjj_ttxdddxdx_1_/**/REALKIND, only: check_forced_parameters
  use ol_heltables_OLR_ppttjj_ttxdddxdx_1
  use ol_kinematics_/**/REALKIND, only: LC2Std_Rep_cmplx
  use ol_h_counterterms_/**/REALKIND
  use ol_loop_parameters_decl_/**/REALKIND ! counterterms
  use ol_loop_parameters_decl_/**/DREALKIND, only: IR_is_on
  use ol_init, only: set_parameter, parameters_flush
#ifdef PRECISION_dp
  use ol_kinematics_/**/QREALKIND, only: conv_mom_scatt2in_qp=>conv_mom_scatt2in, &
                                         internal_momenta_qp=>internal_momenta
  use ol_momenta_decl_/**/DREALKIND, only: L, Q
  use ol_momenta_decl_/**/QREALKIND, only: L_qp=>L, Q_qp=>L
#endif
  implicit none

  real(DREALKIND), intent(in)  :: P_scatt(0:3,6)
  real(REALKIND),  intent(out) :: M02, M2ct, M2colint(22)

  integer           :: shift, k, r, m, n
  real(REALKIND)    :: P(0:3,6)
#ifdef PRECISION_dp
  real(QREALKIND)    :: P_qp(0:3,6)
#endif
  integer           :: extmasses2(6)
  real(REALKIND)    :: M2add, M2add_ct, M2add_colint(22)
  complex(REALKIND) :: M1(6), M2(6) 
  real(REALKIND)    :: P_scatt_intern(0:3,6)
  real(REALKIND), save :: scalebackfactor, old_scalefactor = 0
  integer(intkind1) :: nsync
  type(Hpolcont),   save :: M1helarray(6,64)
  type(Hpolcont) :: M1helarray_ct(6,64)

  type(Hpolcont) :: A(64,112)

  !Aj are not used at the moment
  !complex(REALKIND) :: Aj(112)

  complex(REALKIND) :: omega(2) ! phases for helicity correlations

  call set_parameter("ew_renorm", 0)
  call parameters_flush()
  call ensure_mp_init()

  if (colmat_not_initialised) call colourmatrix_init()

  if (fac_status_loop1 /= parameters_status .or. fac_status_loop2 /= loop_parameters_status) then
    ! Note: if fac_init would only be called when parameters changed which are relevant for the factors,
    ! a different 'status' would have to be used, because forced_parameters should be called after every parameter change.
    call check_forced_parameters()
    call fac_init_loop()
  end if

  if (momenta_nan_check(P_scatt) /= 0) then
    M02 = 0
    return
  end if

  extmasses2 = [ nMT, nMT, 0, 0, 0, 0 ]
  ! Convert 2 -> n-2 PS-point to n -> 0 (so that P(1) + ... + P(n) = 0) and compute
  ! internal-propagator momenta in light-cone representation
  call init_kinematics(P_scatt, extmasses2, P, external_perm_inv_ppttjj_ttxdddxdx_1, 6)

  ! denominators
  call denominators()

   if (heltables_not_init) call init_heltables()

  ! external WFs
  ! Here the external wavefunctions are initialiased
  call pol_wf_Q(P(:,1), rMT, H1, ex1, POLSEL(1),1)
  call pol_wf_A(P(:,2), rMT, H2, ex2, POLSEL(2),2)
  call pol_wf_Q(P(:,3), rZERO, H3, ex3, POLSEL(3),3)
  call pol_wf_Q(P(:,4), rZERO, H4, ex4, POLSEL(4),4)
  call pol_wf_A(P(:,5), rZERO, H5, ex5, POLSEL(5),5)
  call pol_wf_A(P(:,6), rZERO, H6, ex6, POLSEL(6),6)



  ! internal WFs
  ! e.g. call vert_VQ_A(ntry, ex3, ex1, wf1, n1, t1) ...
  call vert_QA_V(ntry, ex1(:), ex2(:), wf4(:,1), n3(:,1), t3x4(:,:,1))
  call vert_QA_V(ntry, ex3(:), ex5(:), wf4(:,2), n3(:,2), t3x4(:,:,2))
  call vert_QA_V(ntry, ex4(:), ex6(:), wf4(:,3), n3(:,3), t3x4(:,:,3))
  call vert_UV_W(ntry, wf4(:,1), 3, wf4(:,2), 20, wf16(:,1), n3(:,4), t3x16(:,:,1))
  call vert_VQ_A(ntry, wf4(:,1), ex4(:), wf8(:,1), n3(:,5), t3x8(:,:,1))
  call vert_AV_Q(ntry, ex6(:), wf4(:,2), wf8(:,2), n3(:,6), t3x8(:,:,2))
  call prop_Q_A(ntry, wf8(:,1), 11, ZERO, 0_intkind1, wf8(:,3), n2(1))
  call vert_VQ_A(ntry, wf4(:,2), ex4(:), wf8(:,4), n3(:,7), t3x8(:,:,3))
  call vert_AV_Q(ntry, ex6(:), wf4(:,1), wf8(:,5), n3(:,8), t3x8(:,:,4))
  call prop_Q_A(ntry, wf8(:,4), 28, ZERO, 0_intkind1, wf8(:,6), n2(2))
  call vert_QA_V(ntry, ex3(:), ex6(:), wf4(:,4), n3(:,9), t3x4(:,:,4))
  call vert_QA_V(ntry, ex4(:), ex5(:), wf4(:,5), n3(:,10), t3x4(:,:,5))
  call vert_UV_W(ntry, wf4(:,1), 3, wf4(:,4), 36, wf16(:,2), n3(:,11), t3x16(:,:,2))
  call vert_VQ_A(ntry, wf4(:,1), ex3(:), wf8(:,7), n3(:,12), t3x8(:,:,5))
  call vert_AV_Q(ntry, ex6(:), wf4(:,5), wf8(:,8), n3(:,13), t3x8(:,:,6))
  call prop_Q_A(ntry, wf8(:,7), 7, ZERO, 0_intkind1, wf8(:,9), n2(3))
  call vert_VQ_A(ntry, wf4(:,5), ex3(:), wf8(:,10), n3(:,14), t3x8(:,:,7))
  call prop_Q_A(ntry, wf8(:,10), 28, ZERO, 0_intkind1, wf8(:,11), n2(4))
  call vert_AV_Q(ntry, ex5(:), wf4(:,4), wf8(:,12), n3(:,15), t3x8(:,:,8))
  call vert_VQ_A(ntry, wf4(:,4), ex4(:), wf8(:,13), n3(:,16), t3x8(:,:,9))
  call vert_AV_Q(ntry, ex5(:), wf4(:,1), wf8(:,14), n3(:,17), t3x8(:,:,10))
  call prop_Q_A(ntry, wf8(:,13), 44, ZERO, 0_intkind1, wf8(:,15), n2(5))
  call vert_AV_Q(ntry, ex5(:), wf4(:,3), wf8(:,16), n3(:,18), t3x8(:,:,11))
  call vert_VQ_A(ntry, wf4(:,3), ex3(:), wf8(:,17), n3(:,19), t3x8(:,:,12))
  call prop_Q_A(ntry, wf8(:,17), 44, ZERO, 0_intkind1, wf8(:,18), n2(6))
  call vert_VQ_A(ntry, wf4(:,2), ex1(:), wf8(:,19), n3(:,20), t3x8(:,:,13))
  call vert_AV_Q(ntry, ex2(:), wf4(:,3), wf8(:,20), n3(:,21), t3x8(:,:,14))
  call prop_Q_A(ntry, wf8(:,19), 21, MT, 1_intkind1, wf8(:,21), n2(7))
  call vert_VQ_A(ntry, wf4(:,3), ex1(:), wf8(:,22), n3(:,22), t3x8(:,:,15))
  call vert_AV_Q(ntry, ex2(:), wf4(:,2), wf8(:,23), n3(:,23), t3x8(:,:,16))
  call prop_Q_A(ntry, wf8(:,22), 41, MT, 1_intkind1, wf8(:,24), n2(8))
  call vert_VQ_A(ntry, wf4(:,4), ex1(:), wf8(:,25), n3(:,24), t3x8(:,:,17))
  call vert_AV_Q(ntry, ex2(:), wf4(:,5), wf8(:,26), n3(:,25), t3x8(:,:,18))
  call prop_Q_A(ntry, wf8(:,25), 37, MT, 1_intkind1, wf8(:,27), n2(9))
  call vert_VQ_A(ntry, wf4(:,5), ex1(:), wf8(:,28), n3(:,26), t3x8(:,:,19))
  call vert_AV_Q(ntry, ex2(:), wf4(:,4), wf8(:,29), n3(:,27), t3x8(:,:,20))
  call prop_Q_A(ntry, wf8(:,28), 25, MT, 1_intkind1, wf8(:,30), n2(10))
  call counter_UV_W(ntry, wf4(:,1), 3, wf4(:,2), 20, wf16(:,3), n3(:,28), t3x16(:,:,3))
  call counter_AV_Q(ntry, ex6(:), wf4(:,2), wf8(:,31), n3(:,29), t3x8(:,:,21))
  call counter_AV_Q(ntry, ex6(:), wf4(:,1), wf8(:,32), n3(:,30), t3x8(:,:,22))
  call counter_UV_W(ntry, wf4(:,1), 3, wf4(:,4), 36, wf16(:,4), n3(:,31), t3x16(:,:,4))
  call counter_AV_Q(ntry, ex6(:), wf4(:,5), wf8(:,33), n3(:,32), t3x8(:,:,23))
  call counter_AV_Q(ntry, ex5(:), wf4(:,4), wf8(:,34), n3(:,33), t3x8(:,:,24))
  call counter_AV_Q(ntry, ex5(:), wf4(:,1), wf8(:,35), n3(:,34), t3x8(:,:,25))
  call counter_AV_Q(ntry, ex5(:), wf4(:,3), wf8(:,36), n3(:,35), t3x8(:,:,26))
  call counter_VQ_A(ntry, wf4(:,2), ex4(:), wf8(:,37), n3(:,36), t3x8(:,:,27))
  call prop_A_Q(ntry, wf8(:,5), 35, ZERO, 0_intkind1, wf8(:,38), n2(11))
  call counter_VQ_A(ntry, wf4(:,1), ex4(:), wf8(:,39), n3(:,37), t3x8(:,:,28))
  call prop_A_Q(ntry, wf8(:,2), 52, ZERO, 0_intkind1, wf8(:,40), n2(12))
  call counter_QA_V(ntry, ex4(:), ex6(:), wf4(:,6), n3(:,38), t3x4(:,:,6))
  call counter_VQ_A(ntry, wf4(:,4), ex4(:), wf8(:,41), n3(:,39), t3x8(:,:,29))
  call prop_A_Q(ntry, wf8(:,14), 19, ZERO, 0_intkind1, wf8(:,42), n2(13))
  call prop_A_Q(ntry, wf8(:,12), 52, ZERO, 0_intkind1, wf8(:,43), n2(14))
  call vert_AV_Q(ntry, ex5(:), wf4(:,6), wf8(:,44), n3(:,40), t3x8(:,:,30))
  call vert_VQ_A(ntry, wf4(:,6), ex3(:), wf8(:,45), n3(:,41), t3x8(:,:,31))
  call prop_Q_A(ntry, wf8(:,45), 44, ZERO, 0_intkind1, wf8(:,46), n2(15))
  call counter_QA_V(ntry, ex4(:), ex5(:), wf4(:,7), n3(:,42), t3x4(:,:,7))
  call vert_AV_Q(ntry, ex6(:), wf4(:,7), wf8(:,47), n3(:,43), t3x8(:,:,32))
  call vert_VQ_A(ntry, wf4(:,7), ex3(:), wf8(:,48), n3(:,44), t3x8(:,:,33))
  call prop_Q_A(ntry, wf8(:,48), 28, ZERO, 0_intkind1, wf8(:,49), n2(16))
  call counter_VQ_A(ntry, wf4(:,5), ex3(:), wf8(:,50), n3(:,45), t3x8(:,:,34))
  call counter_VQ_A(ntry, wf4(:,1), ex3(:), wf8(:,51), n3(:,46), t3x8(:,:,35))
  call prop_A_Q(ntry, wf8(:,8), 56, ZERO, 0_intkind1, wf8(:,52), n2(17))
  call counter_QA_V(ntry, ex3(:), ex6(:), wf4(:,8), n3(:,47), t3x4(:,:,8))
  call vert_UV_W(ntry, wf4(:,1), 3, wf4(:,8), 36, wf16(:,5), n3(:,48), t3x16(:,:,5))
  call counter_VQ_A(ntry, wf4(:,3), ex3(:), wf8(:,53), n3(:,49), t3x8(:,:,36))
  call prop_A_Q(ntry, wf8(:,16), 56, ZERO, 0_intkind1, wf8(:,54), n2(18))
  call vert_AV_Q(ntry, ex5(:), wf4(:,8), wf8(:,55), n3(:,50), t3x8(:,:,37))
  call vert_VQ_A(ntry, wf4(:,8), ex4(:), wf8(:,56), n3(:,51), t3x8(:,:,38))
  call prop_Q_A(ntry, wf8(:,56), 44, ZERO, 0_intkind1, wf8(:,57), n2(19))
  call counter_QA_V(ntry, ex3(:), ex5(:), wf4(:,9), n3(:,52), t3x4(:,:,9))
  call vert_UV_W(ntry, wf4(:,1), 3, wf4(:,9), 20, wf16(:,6), n3(:,53), t3x16(:,:,6))
  call vert_AV_Q(ntry, ex6(:), wf4(:,9), wf8(:,58), n3(:,54), t3x8(:,:,39))
  call vert_VQ_A(ntry, wf4(:,9), ex4(:), wf8(:,59), n3(:,55), t3x8(:,:,40))
  call prop_Q_A(ntry, wf8(:,59), 28, ZERO, 0_intkind1, wf8(:,60), n2(20))
  call vert_AV_Q(ntry, ex2(:), wf4(:,6), wf8(:,61), n3(:,56), t3x8(:,:,41))
  call vert_VQ_A(ntry, wf4(:,6), ex1(:), wf8(:,62), n3(:,57), t3x8(:,:,42))
  call prop_Q_A(ntry, wf8(:,62), 41, MT, 1_intkind1, wf8(:,63), n2(21))
  call vert_AV_Q(ntry, ex2(:), wf4(:,7), wf8(:,64), n3(:,58), t3x8(:,:,43))
  call vert_VQ_A(ntry, wf4(:,7), ex1(:), wf8(:,65), n3(:,59), t3x8(:,:,44))
  call prop_Q_A(ntry, wf8(:,65), 25, MT, 1_intkind1, wf8(:,66), n2(22))
  call vert_AV_Q(ntry, ex2(:), wf4(:,8), wf8(:,67), n3(:,60), t3x8(:,:,45))
  call vert_VQ_A(ntry, wf4(:,8), ex1(:), wf8(:,68), n3(:,61), t3x8(:,:,46))
  call prop_Q_A(ntry, wf8(:,68), 37, MT, 1_intkind1, wf8(:,69), n2(23))
  call vert_AV_Q(ntry, ex2(:), wf4(:,9), wf8(:,70), n3(:,62), t3x8(:,:,47))
  call vert_VQ_A(ntry, wf4(:,9), ex1(:), wf8(:,71), n3(:,63), t3x8(:,:,48))
  call prop_Q_A(ntry, wf8(:,71), 21, MT, 1_intkind1, wf8(:,72), n2(24))
  call counter_AV_Q(ntry, ex2(:), wf4(:,3), wf8(:,73), n3(:,64), t3x8(:,:,49))
  call counter_AV_Q(ntry, ex2(:), wf4(:,2), wf8(:,74), n3(:,65), t3x8(:,:,50))
  call counter_AV_Q(ntry, ex2(:), wf4(:,5), wf8(:,75), n3(:,66), t3x8(:,:,51))
  call counter_AV_Q(ntry, ex2(:), wf4(:,4), wf8(:,76), n3(:,67), t3x8(:,:,52))
  call counter_VQ_A(ntry, wf4(:,2), ex1(:), wf8(:,77), n3(:,68), t3x8(:,:,53))
  call prop_A_Q(ntry, wf8(:,20), 42, MT, 1_intkind1, wf8(:,78), n2(25))
  call counter_VQ_A(ntry, wf4(:,3), ex1(:), wf8(:,79), n3(:,69), t3x8(:,:,54))
  call prop_A_Q(ntry, wf8(:,23), 22, MT, 1_intkind1, wf8(:,80), n2(26))
  call counter_VQ_A(ntry, wf4(:,4), ex1(:), wf8(:,81), n3(:,70), t3x8(:,:,55))
  call prop_A_Q(ntry, wf8(:,26), 26, MT, 1_intkind1, wf8(:,82), n2(27))
  call counter_VQ_A(ntry, wf4(:,5), ex1(:), wf8(:,83), n3(:,71), t3x8(:,:,56))
  call prop_A_Q(ntry, wf8(:,29), 38, MT, 1_intkind1, wf8(:,84), n2(28))
  call counter_QA_V(ntry, ex1(:), ex2(:), wf4(:,10), n3(:,72), t3x4(:,:,10))
  call vert_UV_W(ntry, wf4(:,10), 3, wf4(:,2), 20, wf16(:,7), n3(:,73), t3x16(:,:,7))
  call vert_VQ_A(ntry, wf4(:,10), ex4(:), wf8(:,85), n3(:,74), t3x8(:,:,57))
  call prop_Q_A(ntry, wf8(:,85), 11, ZERO, 0_intkind1, wf8(:,86), n2(29))
  call vert_AV_Q(ntry, ex6(:), wf4(:,10), wf8(:,87), n3(:,75), t3x8(:,:,58))
  call vert_UV_W(ntry, wf4(:,10), 3, wf4(:,4), 36, wf16(:,8), n3(:,76), t3x16(:,:,8))
  call vert_VQ_A(ntry, wf4(:,10), ex3(:), wf8(:,88), n3(:,77), t3x8(:,:,59))
  call prop_Q_A(ntry, wf8(:,88), 7, ZERO, 0_intkind1, wf8(:,89), n2(30))
  call vert_AV_Q(ntry, ex5(:), wf4(:,10), wf8(:,90), n3(:,78), t3x8(:,:,60))
  call vert_UV_W(ntry, wf4(:,2), 20, wf4(:,3), 40, wf16(:,9), n3(:,79), t3x16(:,:,9))
  call counter_V_V(ctGG,21,ntry, wf4(:,1), 3, wf4(:,11), n2(31))
  call vert_UV_W(ntry, wf4(:,1), 3, wf4(:,3), 40, wf16(:,10), n3(:,80), t3x16(:,:,10))
  call counter_V_V(ctGG,21,ntry, wf4(:,2), 20, wf4(:,12), n2(32))
  call counter_V_V(ctGG,21,ntry, wf4(:,3), 40, wf4(:,13), n2(33))
  call vert_VQ_A(ntry, wf4(:,11), ex4(:), wf8(:,91), n3(:,81), t3x8(:,:,61))
  call vert_AV_Q(ntry, ex6(:), wf4(:,11), wf8(:,92), n3(:,82), t3x8(:,:,62))
  call vert_VQ_A(ntry, wf4(:,12), ex4(:), wf8(:,93), n3(:,83), t3x8(:,:,63))
  call vert_AV_Q(ntry, ex6(:), wf4(:,12), wf8(:,94), n3(:,84), t3x8(:,:,64))
  call counter_Q_A(ctqq,1,ntry, wf8(:,3), 11, wf8(:,95), n2(34))
  call counter_Q_A(ctqq,1,ntry, wf8(:,6), 28, wf8(:,96), n2(35))
  call vert_UV_W(ntry, wf4(:,5), 24, wf4(:,4), 36, wf16(:,11), n3(:,85), t3x16(:,:,11))
  call vert_UV_W(ntry, wf4(:,1), 3, wf4(:,5), 24, wf16(:,12), n3(:,86), t3x16(:,:,12))
  call counter_V_V(ctGG,21,ntry, wf4(:,4), 36, wf4(:,14), n2(36))
  call counter_V_V(ctGG,21,ntry, wf4(:,5), 24, wf4(:,15), n2(37))
  call vert_VQ_A(ntry, wf4(:,11), ex3(:), wf8(:,97), n3(:,87), t3x8(:,:,65))
  call vert_VQ_A(ntry, wf4(:,15), ex3(:), wf8(:,98), n3(:,88), t3x8(:,:,66))
  call counter_Q_A(ctqq,1,ntry, wf8(:,9), 7, wf8(:,99), n2(38))
  call counter_Q_A(ctqq,1,ntry, wf8(:,11), 28, wf8(:,100), n2(39))
  call vert_AV_Q(ntry, ex6(:), wf4(:,15), wf8(:,101), n3(:,89), t3x8(:,:,67))
  call vert_AV_Q(ntry, ex5(:), wf4(:,11), wf8(:,102), n3(:,90), t3x8(:,:,68))
  call vert_VQ_A(ntry, wf4(:,14), ex4(:), wf8(:,103), n3(:,91), t3x8(:,:,69))
  call vert_AV_Q(ntry, ex5(:), wf4(:,14), wf8(:,104), n3(:,92), t3x8(:,:,70))
  call counter_Q_A(ctqq,1,ntry, wf8(:,15), 44, wf8(:,105), n2(40))
  call vert_VQ_A(ntry, wf4(:,13), ex3(:), wf8(:,106), n3(:,93), t3x8(:,:,71))
  call counter_Q_A(ctqq,1,ntry, wf8(:,18), 44, wf8(:,107), n2(41))
  call vert_AV_Q(ntry, ex5(:), wf4(:,13), wf8(:,108), n3(:,94), t3x8(:,:,72))
  call counter_Q_A(cttt,6,ntry, wf8(:,21), 21, wf8(:,109), n2(42))
  call counter_Q_A(cttt,6,ntry, wf8(:,24), 41, wf8(:,110), n2(43))
  call vert_VQ_A(ntry, wf4(:,12), ex1(:), wf8(:,111), n3(:,95), t3x8(:,:,73))
  call vert_VQ_A(ntry, wf4(:,13), ex1(:), wf8(:,112), n3(:,96), t3x8(:,:,74))
  call vert_AV_Q(ntry, ex2(:), wf4(:,12), wf8(:,113), n3(:,97), t3x8(:,:,75))
  call vert_AV_Q(ntry, ex2(:), wf4(:,13), wf8(:,114), n3(:,98), t3x8(:,:,76))
  call counter_Q_A(cttt,6,ntry, wf8(:,27), 37, wf8(:,115), n2(44))
  call counter_Q_A(cttt,6,ntry, wf8(:,30), 25, wf8(:,116), n2(45))
  call vert_VQ_A(ntry, wf4(:,14), ex1(:), wf8(:,117), n3(:,99), t3x8(:,:,77))
  call vert_VQ_A(ntry, wf4(:,15), ex1(:), wf8(:,118), n3(:,100), t3x8(:,:,78))
  call vert_AV_Q(ntry, ex2(:), wf4(:,14), wf8(:,119), n3(:,101), t3x8(:,:,79))
  call vert_AV_Q(ntry, ex2(:), wf4(:,15), wf8(:,120), n3(:,102), t3x8(:,:,80))
  call vert_QA_V(ntry, wf8(:,9), ex5(:), wf16(:,13), n3(:,103), t3x16(:,:,13))
  call vert_QA_V(ntry, wf8(:,9), ex6(:), wf16(:,14), n3(:,104), t3x16(:,:,14))
  call vert_QA_V(ntry, wf8(:,3), ex5(:), wf16(:,15), n3(:,105), t3x16(:,:,15))
  call vert_QA_V(ntry, wf8(:,3), ex6(:), wf16(:,16), n3(:,106), t3x16(:,:,16))
  call vert_QA_V(ntry, ex3(:), wf8(:,42), wf16(:,17), n3(:,107), t3x16(:,:,17))
  call vert_QA_V(ntry, ex4(:), wf8(:,42), wf16(:,18), n3(:,108), t3x16(:,:,18))
  call vert_QA_V(ntry, ex3(:), wf8(:,38), wf16(:,19), n3(:,109), t3x16(:,:,19))
  call vert_QA_V(ntry, ex4(:), wf8(:,38), wf16(:,20), n3(:,110), t3x16(:,:,20))
  call vert_QA_V(ntry, wf8(:,21), ex2(:), wf16(:,21), n3(:,111), t3x16(:,:,21))
  call vert_QA_V(ntry, ex1(:), wf8(:,80), wf16(:,22), n3(:,112), t3x16(:,:,22))
  call vert_QA_V(ntry, wf8(:,6), ex6(:), wf16(:,23), n3(:,113), t3x16(:,:,23))
  call vert_QA_V(ntry, ex4(:), wf8(:,40), wf16(:,24), n3(:,114), t3x16(:,:,24))
  call vert_QA_V(ntry, wf8(:,30), ex2(:), wf16(:,25), n3(:,115), t3x16(:,:,25))
  call vert_QA_V(ntry, ex1(:), wf8(:,82), wf16(:,26), n3(:,116), t3x16(:,:,26))
  call vert_QA_V(ntry, wf8(:,11), ex6(:), wf16(:,27), n3(:,117), t3x16(:,:,27))
  call vert_QA_V(ntry, ex3(:), wf8(:,52), wf16(:,28), n3(:,118), t3x16(:,:,28))
  call vert_QA_V(ntry, wf8(:,27), ex2(:), wf16(:,29), n3(:,119), t3x16(:,:,29))
  call vert_QA_V(ntry, ex1(:), wf8(:,84), wf16(:,30), n3(:,120), t3x16(:,:,30))
  call vert_QA_V(ntry, wf8(:,15), ex5(:), wf16(:,31), n3(:,121), t3x16(:,:,31))
  call vert_QA_V(ntry, ex4(:), wf8(:,43), wf16(:,32), n3(:,122), t3x16(:,:,32))
  call vert_QA_V(ntry, wf8(:,24), ex2(:), wf16(:,33), n3(:,123), t3x16(:,:,33))
  call vert_QA_V(ntry, ex1(:), wf8(:,78), wf16(:,34), n3(:,124), t3x16(:,:,34))
  call vert_QA_V(ntry, wf8(:,18), ex5(:), wf16(:,35), n3(:,125), t3x16(:,:,35))
  call vert_QA_V(ntry, ex3(:), wf8(:,54), wf16(:,36), n3(:,126), t3x16(:,:,36))


  call init_hybrid_exwf(ex1)
  call init_hybrid_exwf(ex2)
  call init_hybrid_exwf(ex3)
  call init_hybrid_exwf(ex4)
  call init_hybrid_exwf(ex5)
  call init_hybrid_exwf(ex6)
  call init_hybrid_wf(wf4)
  call init_hybrid_wf(wf8)
  call init_hybrid_wf(wf16)


  if (ntry==1) then
    call physical_helicities()
  end if

  ! computation of the colour-stripped amplitudes
  do nsync = ntry+ntry-1, ntry+1  !  nsync = 1,2  for 1st point and nsync = 3 later
    call diagrams()
    if (nsync == 1) call helsync(nsync, A, nhel, Hel)
  end do

  ! In the following loop the coefficients \Gamma_{i} of the expansion in
  ! the colour basis are computed for every helicity state and stored in M1helarray.
  ! Also the colour vector for the Born-loop interference is computed and saved in
  ! M0_col1_helarray
  do k = 1, nhel
    call colourvectors(A, k, M1helarray(:,k),M1helarray_ct(:,k))
    call colborninterf(M1helarray(:,k), M0_col1_helarray(:,k))
  end do
  M1helarray(:,nhel+1:)%j = 0
  M0_col1_helarray(:,nhel+1:)%hf = -1_intkind2
  M0_col1_helarray(:,nhel+1:)%j = 0

  M2add = 0
  M2add_ct = 0
  M2add_colint = 0

  M02 = 0
  M2ct = 0
  M2colint = 0
  
    do k = 1, nhel
      call colint(M1helarray(:,k)%j, M2add)
      call colint_ct(M1helarray(:,k)%j, M1helarray_ct(:,k)%j, M2add_ct)
      if (IR_is_on > 0) then
	call colint_IR(M1helarray(:,k)%j, M2add_colint)
      end if
      !summation over helicity configurations
      M02 = M02 + M2add
      M2ct = M2ct + M2add_ct
      M2colint = M2colint + M2add_colint
    end do



  contains

subroutine physical_helicities()
  implicit none 

integer :: i1,i2,i3,i4,i5,i6
integer :: n

n=0

do i6= 1, 2
do i5= 1, 2
do i4= 1, 2
do i3= 1, 2
do i2= 1, 2
do i1= 1, 2
n = n + 1
 if((ex1(i1)%hf==-1_intkind2) .OR. (ex2(i2)%hf==-1_intkind2) .OR. (ex3(i3)%hf==-1_intkind2) .OR. (ex4(i4)%hf==-1_intkind2)  &
    .OR. (ex5(i5)%hf==-1_intkind2) .OR. (ex6(i6)%hf==-1_intkind2)) then
  Hel(n) = -1_intkind2
 else
  Hel(n) = ex1(i1)%hf + ex2(i2)%hf + ex3(i3)%hf + ex4(i4)%hf + ex5(i5)%hf + ex6(i6)%hf
 end if
end do
end do
end do
end do
end do
end do

end subroutine physical_helicities

subroutine diagrams()
  implicit none
  integer :: h
  ! e.g. call cont_VV(nsync, wf3, wf6, A(:,1), n64, t64, nhel, den(5)) ...

    call Hcont_VV(nsync, wf4(:,3), wf16(:,1), A(:,1), n3(:,127), t3x64(:,:,1), nhel, den(5))
    call Hcont_QA(nsync, wf8(:,2), wf8(:,3), A(:,2), n3(:,128), t3x64(:,:,2), nhel, den(8))
    call Hcont_QA(nsync, wf8(:,5), wf8(:,6), A(:,3), n3(:,129), t3x64(:,:,3), nhel, den(11))
    call Hcont_VV(nsync, wf4(:,5), wf16(:,2), A(:,4), n3(:,130), t3x64(:,:,4), nhel, den(15))
    call Hcont_QA(nsync, wf8(:,8), wf8(:,9), A(:,5), n3(:,131), t3x64(:,:,5), nhel, den(18))
    call Hcont_QA(nsync, wf8(:,5), wf8(:,11), A(:,6), n3(:,132), t3x64(:,:,6), nhel, den(20))
    call Hcont_QA(nsync, wf8(:,3), wf8(:,12), A(:,7), n3(:,133), t3x64(:,:,7), nhel, den(21))
    call Hcont_QA(nsync, wf8(:,14), wf8(:,15), A(:,8), n3(:,134), t3x64(:,:,8), nhel, den(24))
    call Hcont_QA(nsync, wf8(:,9), wf8(:,16), A(:,9), n3(:,135), t3x64(:,:,9), nhel, den(25))
    call Hcont_QA(nsync, wf8(:,14), wf8(:,18), A(:,10), n3(:,136), t3x64(:,:,10), nhel, den(27))
    call Hcont_QA(nsync, wf8(:,20), wf8(:,21), A(:,11), n3(:,137), t3x64(:,:,11), nhel, den(30))
    call Hcont_QA(nsync, wf8(:,23), wf8(:,24), A(:,12), n3(:,138), t3x64(:,:,12), nhel, den(33))
    call Hcont_QA(nsync, wf8(:,26), wf8(:,27), A(:,13), n3(:,139), t3x64(:,:,13), nhel, den(36))
    call Hcont_QA(nsync, wf8(:,29), wf8(:,30), A(:,14), n3(:,140), t3x64(:,:,14), nhel, den(39))

    call Hcont_VV(nsync, wf4(:,3), wf16(:,3), A(:,15), n3(:,141), t3x64(:,:,15), nhel, den(5))
    call Hcont_QA(nsync, wf8(:,3), wf8(:,31), A(:,16), n3(:,142), t3x64(:,:,16), nhel, den(8))
    call Hcont_QA(nsync, wf8(:,6), wf8(:,32), A(:,17), n3(:,143), t3x64(:,:,17), nhel, den(11))
    call Hcont_VV(nsync, wf4(:,5), wf16(:,4), A(:,18), n3(:,144), t3x64(:,:,18), nhel, den(15))
    call Hcont_QA(nsync, wf8(:,9), wf8(:,33), A(:,19), n3(:,145), t3x64(:,:,19), nhel, den(18))
    call Hcont_QA(nsync, wf8(:,11), wf8(:,32), A(:,20), n3(:,146), t3x64(:,:,20), nhel, den(20))
    call Hcont_QA(nsync, wf8(:,3), wf8(:,34), A(:,21), n3(:,147), t3x64(:,:,21), nhel, den(21))
    call Hcont_QA(nsync, wf8(:,15), wf8(:,35), A(:,22), n3(:,148), t3x64(:,:,22), nhel, den(24))
    call Hcont_QA(nsync, wf8(:,9), wf8(:,36), A(:,23), n3(:,149), t3x64(:,:,23), nhel, den(25))
    call Hcont_QA(nsync, wf8(:,18), wf8(:,35), A(:,24), n3(:,150), t3x64(:,:,24), nhel, den(27))
    call Hcont_QA(nsync, wf8(:,37), wf8(:,38), A(:,25), n3(:,151), t3x64(:,:,25), nhel, den(42))
    call Hcont_QA(nsync, wf8(:,39), wf8(:,40), A(:,26), n3(:,152), t3x64(:,:,26), nhel, den(45))
    call Hcont_VV(nsync, wf16(:,1), wf4(:,6), A(:,27), n3(:,153), t3x64(:,:,27), nhel, den(5))
    call Hcont_QA(nsync, wf8(:,41), wf8(:,42), A(:,28), n3(:,154), t3x64(:,:,28), nhel, den(48))
    call Hcont_QA(nsync, wf8(:,39), wf8(:,43), A(:,29), n3(:,155), t3x64(:,:,29), nhel, den(50))
    call Hcont_QA(nsync, wf8(:,9), wf8(:,44), A(:,30), n3(:,156), t3x64(:,:,30), nhel, den(25))
    call Hcont_QA(nsync, wf8(:,14), wf8(:,46), A(:,31), n3(:,157), t3x64(:,:,31), nhel, den(27))
    call Hcont_VV(nsync, wf16(:,2), wf4(:,7), A(:,32), n3(:,158), t3x64(:,:,32), nhel, den(15))
    call Hcont_QA(nsync, wf8(:,9), wf8(:,47), A(:,33), n3(:,159), t3x64(:,:,33), nhel, den(18))
    call Hcont_QA(nsync, wf8(:,5), wf8(:,49), A(:,34), n3(:,160), t3x64(:,:,34), nhel, den(20))
    call Hcont_QA(nsync, wf8(:,38), wf8(:,50), A(:,35), n3(:,161), t3x64(:,:,35), nhel, den(51))
    call Hcont_QA(nsync, wf8(:,51), wf8(:,52), A(:,36), n3(:,162), t3x64(:,:,36), nhel, den(54))
    call Hcont_VV(nsync, wf4(:,5), wf16(:,5), A(:,37), n3(:,163), t3x64(:,:,37), nhel, den(15))
    call Hcont_QA(nsync, wf8(:,42), wf8(:,53), A(:,38), n3(:,164), t3x64(:,:,38), nhel, den(55))
    call Hcont_QA(nsync, wf8(:,51), wf8(:,54), A(:,39), n3(:,165), t3x64(:,:,39), nhel, den(57))
    call Hcont_QA(nsync, wf8(:,3), wf8(:,55), A(:,40), n3(:,166), t3x64(:,:,40), nhel, den(21))
    call Hcont_QA(nsync, wf8(:,14), wf8(:,57), A(:,41), n3(:,167), t3x64(:,:,41), nhel, den(24))
    call Hcont_VV(nsync, wf4(:,3), wf16(:,6), A(:,42), n3(:,168), t3x64(:,:,42), nhel, den(5))
    call Hcont_QA(nsync, wf8(:,3), wf8(:,58), A(:,43), n3(:,169), t3x64(:,:,43), nhel, den(8))
    call Hcont_QA(nsync, wf8(:,5), wf8(:,60), A(:,44), n3(:,170), t3x64(:,:,44), nhel, den(11))
    call Hcont_QA(nsync, wf8(:,21), wf8(:,61), A(:,45), n3(:,171), t3x64(:,:,45), nhel, den(30))
    call Hcont_QA(nsync, wf8(:,23), wf8(:,63), A(:,46), n3(:,172), t3x64(:,:,46), nhel, den(33))
    call Hcont_QA(nsync, wf8(:,27), wf8(:,64), A(:,47), n3(:,173), t3x64(:,:,47), nhel, den(36))
    call Hcont_QA(nsync, wf8(:,29), wf8(:,66), A(:,48), n3(:,174), t3x64(:,:,48), nhel, den(39))
    call Hcont_QA(nsync, wf8(:,30), wf8(:,67), A(:,49), n3(:,175), t3x64(:,:,49), nhel, den(39))
    call Hcont_QA(nsync, wf8(:,26), wf8(:,69), A(:,50), n3(:,176), t3x64(:,:,50), nhel, den(36))
    call Hcont_QA(nsync, wf8(:,24), wf8(:,70), A(:,51), n3(:,177), t3x64(:,:,51), nhel, den(33))
    call Hcont_QA(nsync, wf8(:,20), wf8(:,72), A(:,52), n3(:,178), t3x64(:,:,52), nhel, den(30))
    call Hcont_QA(nsync, wf8(:,21), wf8(:,73), A(:,53), n3(:,179), t3x64(:,:,53), nhel, den(30))
    call Hcont_QA(nsync, wf8(:,24), wf8(:,74), A(:,54), n3(:,180), t3x64(:,:,54), nhel, den(33))
    call Hcont_QA(nsync, wf8(:,27), wf8(:,75), A(:,55), n3(:,181), t3x64(:,:,55), nhel, den(36))
    call Hcont_QA(nsync, wf8(:,30), wf8(:,76), A(:,56), n3(:,182), t3x64(:,:,56), nhel, den(39))
    call Hcont_QA(nsync, wf8(:,77), wf8(:,78), A(:,57), n3(:,183), t3x64(:,:,57), nhel, den(60))
    call Hcont_QA(nsync, wf8(:,79), wf8(:,80), A(:,58), n3(:,184), t3x64(:,:,58), nhel, den(63))
    call Hcont_QA(nsync, wf8(:,81), wf8(:,82), A(:,59), n3(:,185), t3x64(:,:,59), nhel, den(66))
    call Hcont_QA(nsync, wf8(:,83), wf8(:,84), A(:,60), n3(:,186), t3x64(:,:,60), nhel, den(69))
    call Hcont_VV(nsync, wf4(:,3), wf16(:,7), A(:,61), n3(:,187), t3x64(:,:,61), nhel, den(5))
    call Hcont_QA(nsync, wf8(:,2), wf8(:,86), A(:,62), n3(:,188), t3x64(:,:,62), nhel, den(8))
    call Hcont_QA(nsync, wf8(:,6), wf8(:,87), A(:,63), n3(:,189), t3x64(:,:,63), nhel, den(11))
    call Hcont_VV(nsync, wf4(:,5), wf16(:,8), A(:,64), n3(:,190), t3x64(:,:,64), nhel, den(15))
    call Hcont_QA(nsync, wf8(:,8), wf8(:,89), A(:,65), n3(:,191), t3x64(:,:,65), nhel, den(18))
    call Hcont_QA(nsync, wf8(:,11), wf8(:,87), A(:,66), n3(:,192), t3x64(:,:,66), nhel, den(20))
    call Hcont_QA(nsync, wf8(:,12), wf8(:,86), A(:,67), n3(:,193), t3x64(:,:,67), nhel, den(21))
    call Hcont_QA(nsync, wf8(:,15), wf8(:,90), A(:,68), n3(:,194), t3x64(:,:,68), nhel, den(24))
    call Hcont_QA(nsync, wf8(:,16), wf8(:,89), A(:,69), n3(:,195), t3x64(:,:,69), nhel, den(25))
    call Hcont_QA(nsync, wf8(:,18), wf8(:,90), A(:,70), n3(:,196), t3x64(:,:,70), nhel, den(27))
    call Hcont_VV(nsync, wf16(:,9), wf4(:,11), A(:,71), n3(:,197), t3x64(:,:,71), nhel, den(73))
    call Hcont_VV(nsync, wf16(:,10), wf4(:,12), A(:,72), n3(:,198), t3x64(:,:,72), nhel, den(77))
    call Hcont_VV(nsync, wf16(:,1), wf4(:,13), A(:,73), n3(:,199), t3x64(:,:,73), nhel, den(80))
    call Hcont_QA(nsync, wf8(:,40), wf8(:,91), A(:,74), n3(:,200), t3x64(:,:,74), nhel, den(82))
    call Hcont_QA(nsync, wf8(:,6), wf8(:,92), A(:,75), n3(:,201), t3x64(:,:,75), nhel, den(83))
    call Hcont_QA(nsync, wf8(:,38), wf8(:,93), A(:,76), n3(:,202), t3x64(:,:,76), nhel, den(85))
    call Hcont_QA(nsync, wf8(:,3), wf8(:,94), A(:,77), n3(:,203), t3x64(:,:,77), nhel, den(86))
    call Hcont_QA(nsync, wf8(:,40), wf8(:,95), A(:,78), n3(:,204), t3x64(:,:,78), nhel, den(87))
    call Hcont_QA(nsync, wf8(:,38), wf8(:,96), A(:,79), n3(:,205), t3x64(:,:,79), nhel, den(88))
    call Hcont_VV(nsync, wf4(:,11), wf16(:,11), A(:,80), n3(:,206), t3x64(:,:,80), nhel, den(91))
    call Hcont_VV(nsync, wf16(:,12), wf4(:,14), A(:,81), n3(:,207), t3x64(:,:,81), nhel, den(95))
    call Hcont_VV(nsync, wf16(:,2), wf4(:,15), A(:,82), n3(:,208), t3x64(:,:,82), nhel, den(98))
    call Hcont_QA(nsync, wf8(:,52), wf8(:,97), A(:,83), n3(:,209), t3x64(:,:,83), nhel, den(99))
    call Hcont_QA(nsync, wf8(:,11), wf8(:,92), A(:,84), n3(:,210), t3x64(:,:,84), nhel, den(100))
    call Hcont_QA(nsync, wf8(:,38), wf8(:,98), A(:,85), n3(:,211), t3x64(:,:,85), nhel, den(102))
    call Hcont_QA(nsync, wf8(:,52), wf8(:,99), A(:,86), n3(:,212), t3x64(:,:,86), nhel, den(103))
    call Hcont_QA(nsync, wf8(:,38), wf8(:,100), A(:,87), n3(:,213), t3x64(:,:,87), nhel, den(104))
    call Hcont_QA(nsync, wf8(:,9), wf8(:,101), A(:,88), n3(:,214), t3x64(:,:,88), nhel, den(105))
    call Hcont_QA(nsync, wf8(:,43), wf8(:,91), A(:,89), n3(:,215), t3x64(:,:,89), nhel, den(106))
    call Hcont_QA(nsync, wf8(:,15), wf8(:,102), A(:,90), n3(:,216), t3x64(:,:,90), nhel, den(107))
    call Hcont_QA(nsync, wf8(:,42), wf8(:,103), A(:,91), n3(:,217), t3x64(:,:,91), nhel, den(109))
    call Hcont_QA(nsync, wf8(:,3), wf8(:,104), A(:,92), n3(:,218), t3x64(:,:,92), nhel, den(110))
    call Hcont_QA(nsync, wf8(:,43), wf8(:,95), A(:,93), n3(:,219), t3x64(:,:,93), nhel, den(111))
    call Hcont_QA(nsync, wf8(:,42), wf8(:,105), A(:,94), n3(:,220), t3x64(:,:,94), nhel, den(112))
    call Hcont_QA(nsync, wf8(:,54), wf8(:,97), A(:,95), n3(:,221), t3x64(:,:,95), nhel, den(113))
    call Hcont_QA(nsync, wf8(:,18), wf8(:,102), A(:,96), n3(:,222), t3x64(:,:,96), nhel, den(114))
    call Hcont_QA(nsync, wf8(:,42), wf8(:,106), A(:,97), n3(:,223), t3x64(:,:,97), nhel, den(116))
    call Hcont_QA(nsync, wf8(:,54), wf8(:,99), A(:,98), n3(:,224), t3x64(:,:,98), nhel, den(117))
    call Hcont_QA(nsync, wf8(:,42), wf8(:,107), A(:,99), n3(:,225), t3x64(:,:,99), nhel, den(118))
    call Hcont_QA(nsync, wf8(:,9), wf8(:,108), A(:,100), n3(:,226), t3x64(:,:,100), nhel, den(119))
    call Hcont_QA(nsync, wf8(:,78), wf8(:,109), A(:,101), n3(:,227), t3x64(:,:,101), nhel, den(120))
    call Hcont_QA(nsync, wf8(:,80), wf8(:,110), A(:,102), n3(:,228), t3x64(:,:,102), nhel, den(121))
    call Hcont_QA(nsync, wf8(:,78), wf8(:,111), A(:,103), n3(:,229), t3x64(:,:,103), nhel, den(122))
    call Hcont_QA(nsync, wf8(:,80), wf8(:,112), A(:,104), n3(:,230), t3x64(:,:,104), nhel, den(123))
    call Hcont_QA(nsync, wf8(:,24), wf8(:,113), A(:,105), n3(:,231), t3x64(:,:,105), nhel, den(124))
    call Hcont_QA(nsync, wf8(:,21), wf8(:,114), A(:,106), n3(:,232), t3x64(:,:,106), nhel, den(125))
    call Hcont_QA(nsync, wf8(:,82), wf8(:,115), A(:,107), n3(:,233), t3x64(:,:,107), nhel, den(126))
    call Hcont_QA(nsync, wf8(:,84), wf8(:,116), A(:,108), n3(:,234), t3x64(:,:,108), nhel, den(127))
    call Hcont_QA(nsync, wf8(:,82), wf8(:,117), A(:,109), n3(:,235), t3x64(:,:,109), nhel, den(128))
    call Hcont_QA(nsync, wf8(:,84), wf8(:,118), A(:,110), n3(:,236), t3x64(:,:,110), nhel, den(129))
    call Hcont_QA(nsync, wf8(:,30), wf8(:,119), A(:,111), n3(:,237), t3x64(:,:,111), nhel, den(130))
    call Hcont_QA(nsync, wf8(:,27), wf8(:,120), A(:,112), n3(:,238), t3x64(:,:,112), nhel, den(131))

end subroutine diagrams


elemental function diagmap(j, n)
  implicit none
  integer, intent(in) :: j, n
  complex(REALKIND) :: diagmap
  diagmap = A(j,n)%j
end function diagmap

function diagsum(j, pos, neg)
  implicit none
  integer, intent(in) :: j, pos(:), neg(:)
  complex(REALKIND) :: diagsum
  diagsum = sum(diagmap(j, pos)) - sum(diagmap(j, neg))
end function diagsum

subroutine colourvectors(A, j, M1, M2)
  implicit none
  type(Hpolcont) :: A(:,:)
  integer, intent(in) :: j
  type(Hpolcont), intent(out) :: M1(6), M2(6) ! M1helarray(6,64)
  integer :: empty(0), i

  M1(1)%j = ((A(j,2)%j+A(j,3)%j+A(j,11)%j+A(j,12)%j)*f(1))/12._/**/REALKIND+((A(j,6)%j+A(j,7)%j+A(j,13)%j)*f(1))/4._/**/REALKIND &
       -(CI*A(j,4)%j*f(2))/4._/**/REALKIND
  M1(2)%j = ((-A(j,3)%j-A(j,9)%j-A(j,12)%j)*f(1))/4._/**/REALKIND+((-A(j,5)%j-A(j,6)%j-A(j,13)%j-A(j,14)%j)*f(1))/12._/**/REALKIND &
       -(CI*A(j,1)%j*f(2))/4._/**/REALKIND
  M1(3)%j = ((-A(j,2)%j-A(j,10)%j-A(j,11)%j)*f(1))/4._/**/REALKIND+((-A(j,7)%j-A(j,8)%j-A(j,13)%j &
       -A(j,14)%j)*f(1))/12._/**/REALKIND+(CI*A(j,1)%j*f(2))/4._/**/REALKIND
  M1(4)%j = ((A(j,2)%j+A(j,3)%j+A(j,9)%j+A(j,10)%j)*f(1))/12._/**/REALKIND+((A(j,5)%j+A(j,6)%j+A(j,7)%j+A(j,8)%j+A(j,13)%j &
       +A(j,14)%j)*f(1))/36._/**/REALKIND
  M1(5)%j = ((A(j,9)%j+A(j,10)%j+A(j,11)%j+A(j,12)%j)*f(1))/12._/**/REALKIND+((A(j,5)%j+A(j,8)%j+A(j,14)%j)*f(1))/4._/**/REALKIND &
       +(CI*A(j,4)%j*f(2))/4._/**/REALKIND
  M1(6)%j = ((-A(j,5)%j-A(j,6)%j-A(j,7)%j-A(j,8)%j)*f(1))/12._/**/REALKIND+((-A(j,2)%j-A(j,3)%j-A(j,9)%j-A(j,10)%j-A(j,11)%j &
       -A(j,12)%j)*f(1))/36._/**/REALKIND

  M2(1)%j = ((-A(j,74)%j-A(j,75)%j-A(j,76)%j-A(j,77)%j-A(j,78)%j-A(j,79)%j-A(j,101)%j-A(j,102)%j-A(j,103)%j-A(j,104)%j-A(j,105)%j &
       -A(j,106)%j)*f(3))/12._/**/REALKIND+((-A(j,84)%j-A(j,85)%j-A(j,87)%j-A(j,89)%j-A(j,92)%j-A(j,93)%j-A(j,107)%j-A(j,109)%j &
       -A(j,112)%j)*f(3))/4._/**/REALKIND+(CI*(-A(j,80)%j-A(j,81)%j+A(j,82)%j)*f(4))/4._/**/REALKIND+((A(j,20)%j+A(j,21)%j &
       +A(j,29)%j+A(j,34)%j+A(j,35)%j+A(j,40)%j+A(j,47)%j+A(j,50)%j)*f(5))/4._/**/REALKIND+((A(j,16)%j+A(j,17)%j+A(j,25)%j &
       +A(j,26)%j+A(j,43)%j+A(j,44)%j+A(j,45)%j+A(j,46)%j+A(j,51)%j+A(j,52)%j)*f(5))/12._/**/REALKIND+(CI*(-A(j,32)%j &
       -A(j,37)%j)*f(6))/4._/**/REALKIND+((A(j,53)%j+A(j,54)%j+A(j,57)%j+A(j,58)%j+A(j,62)%j+A(j,63)%j)*f(7))/12._/**/REALKIND &
       +((A(j,55)%j+A(j,59)%j+A(j,66)%j+A(j,67)%j)*f(7))/4._/**/REALKIND-(CI*A(j,64)%j*f(8))/4._/**/REALKIND &
       -(CI*A(j,18)%j*f(9))/4._/**/REALKIND
  M2(2)%j = ((A(j,75)%j+A(j,76)%j+A(j,79)%j+A(j,95)%j+A(j,98)%j+A(j,100)%j+A(j,102)%j+A(j,104)%j+A(j,105)%j)*f(3))/4._/**/REALKIND &
       +((A(j,83)%j+A(j,84)%j+A(j,85)%j+A(j,86)%j+A(j,87)%j+A(j,88)%j+A(j,107)%j+A(j,108)%j+A(j,109)%j+A(j,110)%j+A(j,111)%j &
       +A(j,112)%j)*f(3))/12._/**/REALKIND+(CI*(A(j,71)%j-A(j,72)%j+A(j,73)%j)*f(4))/4._/**/REALKIND+((-A(j,19)%j-A(j,20)%j &
       -A(j,33)%j-A(j,34)%j-A(j,35)%j-A(j,36)%j-A(j,47)%j-A(j,48)%j-A(j,49)%j-A(j,50)%j)*f(5))/12._/**/REALKIND+((-A(j,17)%j &
       -A(j,23)%j-A(j,25)%j-A(j,30)%j-A(j,39)%j-A(j,44)%j-A(j,46)%j-A(j,51)%j)*f(5))/4._/**/REALKIND+(CI*(-A(j,27)%j &
       -A(j,42)%j)*f(6))/4._/**/REALKIND+((-A(j,55)%j-A(j,56)%j-A(j,59)%j-A(j,60)%j-A(j,65)%j-A(j,66)%j)*f(7))/12._/**/REALKIND+(( &
       -A(j,54)%j-A(j,58)%j-A(j,63)%j-A(j,69)%j)*f(7))/4._/**/REALKIND-(CI*A(j,61)%j*f(8))/4._/**/REALKIND &
       -(CI*A(j,15)%j*f(9))/4._/**/REALKIND
  M2(3)%j = ((A(j,74)%j+A(j,77)%j+A(j,78)%j+A(j,96)%j+A(j,97)%j+A(j,99)%j+A(j,101)%j+A(j,103)%j+A(j,106)%j)*f(3))/4._/**/REALKIND &
       +((A(j,89)%j+A(j,90)%j+A(j,91)%j+A(j,92)%j+A(j,93)%j+A(j,94)%j+A(j,107)%j+A(j,108)%j+A(j,109)%j+A(j,110)%j+A(j,111)%j &
       +A(j,112)%j)*f(3))/12._/**/REALKIND+(CI*(-A(j,71)%j+A(j,72)%j-A(j,73)%j)*f(4))/4._/**/REALKIND+((-A(j,21)%j-A(j,22)%j &
       -A(j,28)%j-A(j,29)%j-A(j,40)%j-A(j,41)%j-A(j,47)%j-A(j,48)%j-A(j,49)%j-A(j,50)%j)*f(5))/12._/**/REALKIND+((-A(j,16)%j &
       -A(j,24)%j-A(j,26)%j-A(j,31)%j-A(j,38)%j-A(j,43)%j-A(j,45)%j-A(j,52)%j)*f(5))/4._/**/REALKIND+(CI*(A(j,27)%j &
       +A(j,42)%j)*f(6))/4._/**/REALKIND+((-A(j,55)%j-A(j,56)%j-A(j,59)%j-A(j,60)%j-A(j,67)%j-A(j,68)%j)*f(7))/12._/**/REALKIND+(( &
       -A(j,53)%j-A(j,57)%j-A(j,62)%j-A(j,70)%j)*f(7))/4._/**/REALKIND+(CI*A(j,61)%j*f(8))/4._/**/REALKIND &
       +(CI*A(j,15)%j*f(9))/4._/**/REALKIND
  M2(4)%j = ((-A(j,74)%j-A(j,75)%j-A(j,76)%j-A(j,77)%j-A(j,78)%j-A(j,79)%j-A(j,95)%j-A(j,96)%j-A(j,97)%j-A(j,98)%j-A(j,99)%j &
       -A(j,100)%j)*f(3))/12._/**/REALKIND+((-A(j,83)%j-A(j,84)%j-A(j,85)%j-A(j,86)%j-A(j,87)%j-A(j,88)%j-A(j,89)%j-A(j,90)%j &
       -A(j,91)%j-A(j,92)%j-A(j,93)%j-A(j,94)%j-A(j,107)%j-A(j,108)%j-A(j,109)%j-A(j,110)%j-A(j,111)%j &
       -A(j,112)%j)*f(3))/36._/**/REALKIND+((A(j,16)%j+A(j,17)%j+A(j,23)%j+A(j,24)%j+A(j,25)%j+A(j,26)%j+A(j,30)%j+A(j,31)%j &
       +A(j,38)%j+A(j,39)%j+A(j,43)%j+A(j,44)%j)*f(5))/12._/**/REALKIND+((A(j,19)%j+A(j,20)%j+A(j,21)%j+A(j,22)%j+A(j,28)%j &
       +A(j,29)%j+A(j,33)%j+A(j,34)%j+A(j,35)%j+A(j,36)%j+A(j,40)%j+A(j,41)%j+A(j,47)%j+A(j,48)%j+A(j,49)%j &
       +A(j,50)%j)*f(5))/36._/**/REALKIND+((A(j,55)%j+A(j,56)%j+A(j,59)%j+A(j,60)%j+A(j,65)%j+A(j,66)%j+A(j,67)%j &
       +A(j,68)%j)*f(7))/36._/**/REALKIND+((A(j,62)%j+A(j,63)%j+A(j,69)%j+A(j,70)%j)*f(7))/12._/**/REALKIND
  M2(5)%j = ((-A(j,95)%j-A(j,96)%j-A(j,97)%j-A(j,98)%j-A(j,99)%j-A(j,100)%j-A(j,101)%j-A(j,102)%j-A(j,103)%j-A(j,104)%j-A(j,105)%j &
       -A(j,106)%j)*f(3))/12._/**/REALKIND+((-A(j,83)%j-A(j,86)%j-A(j,88)%j-A(j,90)%j-A(j,91)%j-A(j,94)%j-A(j,108)%j-A(j,110)%j &
       -A(j,111)%j)*f(3))/4._/**/REALKIND+(CI*(A(j,80)%j+A(j,81)%j-A(j,82)%j)*f(4))/4._/**/REALKIND+((A(j,19)%j+A(j,22)%j &
       +A(j,28)%j+A(j,33)%j+A(j,36)%j+A(j,41)%j+A(j,48)%j+A(j,49)%j)*f(5))/4._/**/REALKIND+((A(j,23)%j+A(j,24)%j+A(j,30)%j &
       +A(j,31)%j+A(j,38)%j+A(j,39)%j+A(j,45)%j+A(j,46)%j+A(j,51)%j+A(j,52)%j)*f(5))/12._/**/REALKIND+(CI*(A(j,32)%j &
       +A(j,37)%j)*f(6))/4._/**/REALKIND+((A(j,56)%j+A(j,60)%j+A(j,65)%j+A(j,68)%j)*f(7))/4._/**/REALKIND+((A(j,53)%j+A(j,54)%j &
       +A(j,57)%j+A(j,58)%j+A(j,69)%j+A(j,70)%j)*f(7))/12._/**/REALKIND+(CI*A(j,64)%j*f(8))/4._/**/REALKIND &
       +(CI*A(j,18)%j*f(9))/4._/**/REALKIND
  M2(6)%j = ((A(j,83)%j+A(j,84)%j+A(j,85)%j+A(j,86)%j+A(j,87)%j+A(j,88)%j+A(j,89)%j+A(j,90)%j+A(j,91)%j+A(j,92)%j+A(j,93)%j &
       +A(j,94)%j)*f(3))/12._/**/REALKIND+((A(j,74)%j+A(j,75)%j+A(j,76)%j+A(j,77)%j+A(j,78)%j+A(j,79)%j+A(j,95)%j+A(j,96)%j &
       +A(j,97)%j+A(j,98)%j+A(j,99)%j+A(j,100)%j+A(j,101)%j+A(j,102)%j+A(j,103)%j+A(j,104)%j+A(j,105)%j &
       +A(j,106)%j)*f(3))/36._/**/REALKIND+((-A(j,19)%j-A(j,20)%j-A(j,21)%j-A(j,22)%j-A(j,28)%j-A(j,29)%j-A(j,33)%j-A(j,34)%j &
       -A(j,35)%j-A(j,36)%j-A(j,40)%j-A(j,41)%j)*f(5))/12._/**/REALKIND+((-A(j,16)%j-A(j,17)%j-A(j,23)%j-A(j,24)%j-A(j,25)%j &
       -A(j,26)%j-A(j,30)%j-A(j,31)%j-A(j,38)%j-A(j,39)%j-A(j,43)%j-A(j,44)%j-A(j,45)%j-A(j,46)%j-A(j,51)%j &
       -A(j,52)%j)*f(5))/36._/**/REALKIND+((-A(j,65)%j-A(j,66)%j-A(j,67)%j-A(j,68)%j)*f(7))/12._/**/REALKIND+((-A(j,53)%j &
       -A(j,54)%j-A(j,57)%j-A(j,58)%j-A(j,62)%j-A(j,63)%j-A(j,69)%j-A(j,70)%j)*f(7))/36._/**/REALKIND


  M1(:)%hf = Hel(j)
  M2(:)%hf = Hel(j)  

  !M(i) corresponds to \Gamma_{i} in Fabio's thesis

end subroutine colourvectors


! **********************************************************************
subroutine colint(M, M2colint)
! M(i)   = <M|Ci> colour component of matrix element
! COLINT = <M|M>
!        = Sum_{i,j} <M|Ci> * <Ci|Cj> * <Cj|M>
!        = colour-summed squared matrix element
! K2(i,j) = <Ci|Cj>
! **********************************************************************
  use ol_colourmatrix_ppttjj_ttxdddxdx_1_/**/REALKIND, only: K1
  implicit none

  complex(REALKIND), intent(in)  :: M(6)
  real(REALKIND),    intent(out) :: M2colint
  integer :: i, j

  M2colint = 0

    do i = 1, 6
      do j = 1, 6
        M2colint = M2colint + real(conjg(M(i))*K1(i,j)*M(j))
      end do
    end do

end subroutine colint

! **********************************************************************
subroutine colint_ct(M, Mct, M2colint_ct)
! M(i)   = <M|Ci> colour component of matrix element
! COLINT = <M|M>
!        = Sum_{i,j} <M|Ci> * <Ci|Cj> * <Cj|M>
!        = colour-summed squared matrix element
! K2(i,j) = <Ci|Cj>
! **********************************************************************
  use ol_colourmatrix_ppttjj_ttxdddxdx_1_/**/REALKIND, only: K2
  implicit none

  complex(REALKIND), intent(in)  :: M(6), Mct(6)
  real(REALKIND),    intent(out) :: M2colint_ct
  integer ::  i, j

  M2colint_ct = 0

    do i = 1, 6
      do j = 1, 6
        M2colint_ct = M2colint_ct + real(conjg(M(i))*K2(i,j)*Mct(j))
      end do
    end do


end subroutine colint_ct

! **********************************************************************
subroutine colint_IR(M, M2IRadd)
! M(i)   = <M|Ci> colour component of matrix element
! K1(i,j) = .....
! **********************************************************************
  use ol_colourmatrix_ppttjj_ttxdddxdx_1_/**/REALKIND, only: K1
  implicit none

  complex(REALKIND), intent(in)  :: M(6)
  real(REALKIND),    intent(out) :: M2IRadd(22)
  integer ::  i, j, k, colmatpos

  M2IRadd = 0

  do k = 1, 23-1
    colmatpos = 6*k
    do i = 1, 6
      do j = 1, 6
	M2IRadd(k) = M2IRadd(k) + real(conjg(M(i))*K1(i+colmatpos,j)*M(j))
      end do
    end do
  end do
  
end subroutine colint_IR

! **********************************************************************
subroutine colintmunu(M1, M2, M2colint)
! M1(i)    = <M1|Ci> colour component of matrix element
! M2(i)    = <M2|Ci> colour component of matrix element
! M2colint = <M1|M2>
!          = Sum_{i,j} <M1|Ci> * <Ci|Cj> * <Cj|M2>
!          = colour-summed squared matrix element
! K2(i,j) = <Ci|Cj>
! **********************************************************************
  use ol_colourmatrix_ppttjj_ttxdddxdx_1_/**/REALKIND, only: K2
  implicit none

  complex(REALKIND), intent(in)  :: M1(6)
  complex(REALKIND), intent(in)  :: M2(6)
  complex(REALKIND),    intent(out) :: M2colint
  integer :: i, j

  M2colint = 0

  do i = 1, 6
    do j = 1, 6
      M2colint = M2colint + M1(i)*K2(i,j)*conjg(M2(j))
    end do
  end do

end subroutine colintmunu





! **********************************************************************
subroutine colborninterf(M, M0_col)
! M(i)         = <M|Ci> colour component of matrix element
! M0_col(i)    = <M2|Ci> colour component of matrix element,
!                see \tilde{M}_{j} in Fabio's thesis
! M2colint = Sum_{i} <M1|Ci> * <Ci|Cj>
!          = colour-summed squared matrix element
! KL(i,j) = <Ci|Cj> with elements Cj of 1-loop colour basis
! **********************************************************************
  use ol_colourmatrix_ppttjj_ttxdddxdx_1_/**/REALKIND, only: KL
  implicit none

  type(Hpolcont), intent(in)  :: M(6)
  type(Hpolcont), intent(out)  :: M0_col(6)
  integer :: i, j


  do j = 1, 6 !size(KL(1,:))
    M0_col(j)%j = 0
    M0_col(j)%hf = M(1)%hf
    do i = 1, 6 !size(KL(:,1))
      M0_col(j)%j = M0_col(j)%j  + conjg(M(i)%j)*KL(i,j)
    end do    
  end do

end subroutine colborninterf

end subroutine amp2

end module ol_loop_ppttjj_ttxdddxdx_1_/**/REALKIND
