
module ol_colourmatrix_ppttjj_ttxbbxgg_1_/**/REALKIND
  use KIND_TYPES, only: REALKIND
  implicit none
  logical, save           :: colmat_not_initialised = .true.
  complex(REALKIND), save :: K1(276,12), K2(12,14), KL(12,14)
  contains
  subroutine colourmatrix_init
    use ol_parameters_decl_/**/REALKIND, only: CI
    implicit none
    colmat_not_initialised = .false.
    ! colour matrix

  K1(  1,:) = [  144,   48,   48,   18,    0,   -6,   48,    0,    0,   48,   -6,    0]
  K1(  2,:) = [   48,  144,   18,   48,   -6,    0,    0,   48,   48,    0,    0,   -6]
  K1(  3,:) = [   48,   18,  144,   48,   48,    0,    0,   -6,   -6,    0,    0,   48]
  K1(  4,:) = [   18,   48,   48,  144,    0,   48,   -6,    0,    0,   -6,   48,    0]
  K1(  5,:) = [    0,   -6,   48,    0,  144,   48,   48,   18,  -18,   -6,   -6,   18]
  K1(  6,:) = [   -6,    0,    0,   48,   48,  144,   18,   48,   -6,  -18,   18,   -6]
  K1(  7,:) = [   48,    0,    0,   -6,   48,   18,  144,   48,   -6,   18,  -18,   -6]
  K1(  8,:) = [    0,   48,   -6,    0,   18,   48,   48,  144,   18,   -6,   -6,  -18]
  K1(  9,:) = [    0,   48,   -6,    0,  -18,   -6,   -6,   18,  144,   48,   48,   18]
  K1( 10,:) = [   48,    0,    0,   -6,   -6,  -18,   18,   -6,   48,  144,   18,   48]
  K1( 11,:) = [   -6,    0,    0,   48,   -6,   18,  -18,   -6,   48,   18,  144,   48]
  K1( 12,:) = [    0,   -6,   48,    0,   18,   -6,   -6,  -18,   18,   48,   48,  144]
  K1( 13,:) = [  192,   64,   64,   24,    0,   -8,   64,    0,    0,   64,   -8,    0]
  K1( 14,:) = [   64,  192,   24,   64,   -8,    0,    0,   64,   64,    0,    0,   -8]
  K1( 15,:) = [   64,   24,  192,   64,   64,    0,    0,   -8,   -8,    0,    0,   64]
  K1( 16,:) = [   24,   64,   64,  192,    0,   64,   -8,    0,    0,   -8,   64,    0]
  K1( 17,:) = [    0,   -8,   64,    0,  192,   64,   64,   24,  -24,   -8,   -8,   24]
  K1( 18,:) = [   -8,    0,    0,   64,   64,  192,   24,   64,   -8,  -24,   24,   -8]
  K1( 19,:) = [   64,    0,    0,   -8,   64,   24,  192,   64,   -8,   24,  -24,   -8]
  K1( 20,:) = [    0,   64,   -8,    0,   24,   64,   64,  192,   24,   -8,   -8,  -24]
  K1( 21,:) = [    0,   64,   -8,    0,  -24,   -8,   -8,   24,  192,   64,   64,   24]
  K1( 22,:) = [   64,    0,    0,   -8,   -8,  -24,   24,   -8,   64,  192,   24,   64]
  K1( 23,:) = [   -8,    0,    0,   64,   -8,   24,  -24,   -8,   64,   24,  192,   64]
  K1( 24,:) = [    0,   -8,   64,    0,   24,   -8,   -8,  -24,   24,   64,   64,  192]
  K1( 25,:) = [   24,    8,    8,    3,    0,   -1,    8,    0,    0,    8,   -1,    0]
  K1( 26,:) = [    8,    0,    6,    8,  -10,  -24,  -24,  -64,   -1,    3,    3,    8]
  K1( 27,:) = [    8,    6,    0,    8,   -1,    3,    3,    8,  -10,  -24,  -24,  -64]
  K1( 28,:) = [    3,    8,    8,   24,    0,    8,   -1,    0,    0,   -1,    8,    0]
  K1( 29,:) = [    0,  -10,   -1,    0,   -3,   -1,   -1,  -24,  -30,  -10,  -10,  -24]
  K1( 30,:) = [   -1,  -24,    3,    8,   -1,    0,  -21,  -64,  -10,    0,    6,    8]
  K1( 31,:) = [    8,  -24,    3,   -1,   -1,  -21,    0,  -64,  -10,    6,    0,    8]
  K1( 32,:) = [    0,  -64,    8,    0,  -24,  -64,  -64, -192,  -24,    8,    8,   24]
  K1( 33,:) = [    0,   -1,  -10,    0,  -30,  -10,  -10,  -24,   -3,   -1,   -1,  -24]
  K1( 34,:) = [    8,    3,  -24,   -1,  -10,    0,    6,    8,   -1,    0,  -21,  -64]
  K1( 35,:) = [   -1,    3,  -24,    8,  -10,    6,    0,    8,   -1,  -21,    0,  -64]
  K1( 36,:) = [    0,    8,  -64,    0,  -24,    8,    8,   24,  -24,  -64,  -64, -192]
  K1( 37,:) = [  192,   64,   64,   24,    0,   -8,   64,    0,    0,   64,   -8,    0]
  K1( 38,:) = [   64,  192,   24,   64,   -8,    0,    0,   64,   64,    0,    0,   -8]
  K1( 39,:) = [   64,   24,  192,   64,   64,    0,    0,   -8,   -8,    0,    0,   64]
  K1( 40,:) = [   24,   64,   64,  192,    0,   64,   -8,    0,    0,   -8,   64,    0]
  K1( 41,:) = [    0,   -8,   64,    0,  192,   64,   64,   24,  -24,   -8,   -8,   24]
  K1( 42,:) = [   -8,    0,    0,   64,   64,  192,   24,   64,   -8,  -24,   24,   -8]
  K1( 43,:) = [   64,    0,    0,   -8,   64,   24,  192,   64,   -8,   24,  -24,   -8]
  K1( 44,:) = [    0,   64,   -8,    0,   24,   64,   64,  192,   24,   -8,   -8,  -24]
  K1( 45,:) = [    0,   64,   -8,    0,  -24,   -8,   -8,   24,  192,   64,   64,   24]
  K1( 46,:) = [   64,    0,    0,   -8,   -8,  -24,   24,   -8,   64,  192,   24,   64]
  K1( 47,:) = [   -8,    0,    0,   64,   -8,   24,  -24,   -8,   64,   24,  192,   64]
  K1( 48,:) = [    0,   -8,   64,    0,   24,   -8,   -8,  -24,   24,   64,   64,  192]
  K1( 49,:) = [    0,   64,    1,   21,   -3,    1,   -8,   24,   24,   -8,    1,   -3]
  K1( 50,:) = [   64,    0,   21,    1,    1,   -3,   24,   -8,   -8,   24,   -3,    1]
  K1( 51,:) = [    1,   21,    0,   64,   -8,   24,   -3,    1,    1,   -3,   24,   -8]
  K1( 52,:) = [   21,    1,   64,    0,   24,   -8,    1,   -3,   -3,    1,   -8,   24]
  K1( 53,:) = [   -3,    1,   -8,   24,    0,   64,    1,   21,    0,   -8,   10,   -6]
  K1( 54,:) = [    1,   -3,   24,   -8,   64,    0,   21,    1,   -8,    0,   -6,   10]
  K1( 55,:) = [   -8,   24,   -3,    1,    1,   21,    0,   64,   10,   -6,    0,   -8]
  K1( 56,:) = [   24,   -8,    1,   -3,   21,    1,   64,    0,   -6,   10,   -8,    0]
  K1( 57,:) = [   24,   -8,    1,   -3,    0,   -8,   10,   -6,    0,   64,    1,   21]
  K1( 58,:) = [   -8,   24,   -3,    1,   -8,    0,   -6,   10,   64,    0,   21,    1]
  K1( 59,:) = [    1,   -3,   24,   -8,   10,   -6,    0,   -8,    1,   21,    0,   64]
  K1( 60,:) = [   -3,    1,   -8,   24,   -6,   10,   -8,    0,   21,    1,   64,    0]
  K1( 61,:) = [    0,    8,    8,    6,  -24,  -10,  -64,  -24,    3,   -1,    8,    3]
  K1( 62,:) = [    8,   24,    3,    8,   -1,    0,    0,    8,    8,    0,    0,   -1]
  K1( 63,:) = [    8,    3,   24,    8,    8,    0,    0,   -1,   -1,    0,    0,    8]
  K1( 64,:) = [    6,    8,    8,    0,    3,   -1,    8,    3,  -24,  -10,  -64,  -24]
  K1( 65,:) = [  -24,   -1,    8,    3,    0,   -1,  -64,  -21,    0,  -10,    8,    6]
  K1( 66,:) = [  -10,    0,    0,   -1,   -1,   -3,  -24,   -1,  -10,  -30,  -24,  -10]
  K1( 67,:) = [  -64,    0,    0,    8,  -64,  -24, -192,  -64,    8,  -24,   24,    8]
  K1( 68,:) = [  -24,    8,   -1,    3,  -21,   -1,  -64,    0,    6,  -10,    8,    0]
  K1( 69,:) = [    3,    8,   -1,  -24,    0,  -10,    8,    6,    0,   -1,  -64,  -21]
  K1( 70,:) = [   -1,    0,    0,  -10,  -10,  -30,  -24,  -10,   -1,   -3,  -24,   -1]
  K1( 71,:) = [    8,    0,    0,  -64,    8,  -24,   24,    8,  -64,  -24, -192,  -64]
  K1( 72,:) = [    3,   -1,    8,  -24,    6,  -10,    8,    0,  -21,   -1,  -64,    0]
  K1( 73,:) = [  192,   64,   64,   24,    0,   -8,   64,    0,    0,   64,   -8,    0]
  K1( 74,:) = [   64,  192,   24,   64,   -8,    0,    0,   64,   64,    0,    0,   -8]
  K1( 75,:) = [   64,   24,  192,   64,   64,    0,    0,   -8,   -8,    0,    0,   64]
  K1( 76,:) = [   24,   64,   64,  192,    0,   64,   -8,    0,    0,   -8,   64,    0]
  K1( 77,:) = [    0,   -8,   64,    0,  192,   64,   64,   24,  -24,   -8,   -8,   24]
  K1( 78,:) = [   -8,    0,    0,   64,   64,  192,   24,   64,   -8,  -24,   24,   -8]
  K1( 79,:) = [   64,    0,    0,   -8,   64,   24,  192,   64,   -8,   24,  -24,   -8]
  K1( 80,:) = [    0,   64,   -8,    0,   24,   64,   64,  192,   24,   -8,   -8,  -24]
  K1( 81,:) = [    0,   64,   -8,    0,  -24,   -8,   -8,   24,  192,   64,   64,   24]
  K1( 82,:) = [   64,    0,    0,   -8,   -8,  -24,   24,   -8,   64,  192,   24,   64]
  K1( 83,:) = [   -8,    0,    0,   64,   -8,   24,  -24,   -8,   64,   24,  192,   64]
  K1( 84,:) = [    0,   -8,   64,    0,   24,   -8,   -8,  -24,   24,   64,   64,  192]
  K1( 85,:) = [    0,    8,    8,    6,    3,    8,   -1,    3,  -24,  -64,  -10,  -24]
  K1( 86,:) = [    8,   24,    3,    8,   -1,    0,    0,    8,    8,    0,    0,   -1]
  K1( 87,:) = [    8,    3,   24,    8,    8,    0,    0,   -1,   -1,    0,    0,    8]
  K1( 88,:) = [    6,    8,    8,    0,  -24,  -64,  -10,  -24,    3,    8,   -1,    3]
  K1( 89,:) = [    3,   -1,    8,  -24,    0,  -64,   -1,  -21,    0,    8,  -10,    6]
  K1( 90,:) = [    8,    0,    0,  -64,  -64, -192,  -24,  -64,    8,   24,  -24,    8]
  K1( 91,:) = [   -1,    0,    0,  -10,   -1,  -24,   -3,   -1,  -10,  -24,  -30,  -10]
  K1( 92,:) = [    3,    8,   -1,  -24,  -21,  -64,   -1,    0,    6,    8,  -10,    0]
  K1( 93,:) = [  -24,    8,   -1,    3,    0,    8,  -10,    6,    0,  -64,   -1,  -21]
  K1( 94,:) = [  -64,    0,    0,    8,    8,   24,  -24,    8,  -64, -192,  -24,  -64]
  K1( 95,:) = [  -10,    0,    0,   -1,  -10,  -24,  -30,  -10,   -1,  -24,   -3,   -1]
  K1( 96,:) = [  -24,   -1,    8,    3,    6,    8,  -10,    0,  -21,  -64,   -1,    0]
  K1( 97,:) = [    0,    1,   64,   21,   24,    1,   -8,   -3,   -3,   -8,    1,   24]
  K1( 98,:) = [    1,    0,   21,   64,    1,   24,   -3,   -8,   -8,   -3,   24,    1]
  K1( 99,:) = [   64,   21,    0,    1,   -8,   -3,   24,    1,    1,   24,   -3,   -8]
  K1(100,:) = [   21,   64,    1,    0,   -3,   -8,    1,   24,   24,    1,   -8,   -3]
  K1(101,:) = [   24,    1,   -8,   -3,    0,    1,   64,   21,    0,   10,   -8,   -6]
  K1(102,:) = [    1,   24,   -3,   -8,    1,    0,   21,   64,   10,    0,   -6,   -8]
  K1(103,:) = [   -8,   -3,   24,    1,   64,   21,    0,    1,   -8,   -6,    0,   10]
  K1(104,:) = [   -3,   -8,    1,   24,   21,   64,    1,    0,   -6,   -8,   10,    0]
  K1(105,:) = [   -3,   -8,    1,   24,    0,   10,   -8,   -6,    0,    1,   64,   21]
  K1(106,:) = [   -8,   -3,   24,    1,   10,    0,   -6,   -8,    1,    0,   21,   64]
  K1(107,:) = [    1,   24,   -3,   -8,   -8,   -6,    0,   10,   64,   21,    0,    1]
  K1(108,:) = [   24,    1,   -8,   -3,   -6,   -8,   10,    0,   21,   64,    1,    0]
  K1(109,:) = [   24,    8,    8,    3,    0,   -1,    8,    0,    0,    8,   -1,    0]
  K1(110,:) = [    8,    0,    6,    8,    8,    3,    3,   -1,  -64,  -24,  -24,  -10]
  K1(111,:) = [    8,    6,    0,    8,  -64,  -24,  -24,  -10,    8,    3,    3,   -1]
  K1(112,:) = [    3,    8,    8,   24,    0,    8,   -1,    0,    0,   -1,    8,    0]
  K1(113,:) = [    0,    8,  -64,    0, -192,  -64,  -64,  -24,   24,    8,    8,  -24]
  K1(114,:) = [   -1,    3,  -24,    8,  -64,    0,  -21,   -1,    8,    0,    6,  -10]
  K1(115,:) = [    8,    3,  -24,   -1,  -64,  -21,    0,   -1,    8,    6,    0,  -10]
  K1(116,:) = [    0,   -1,  -10,    0,  -24,   -1,   -1,   -3,  -24,  -10,  -10,  -30]
  K1(117,:) = [    0,  -64,    8,    0,   24,    8,    8,  -24, -192,  -64,  -64,  -24]
  K1(118,:) = [    8,  -24,    3,   -1,    8,    0,    6,  -10,  -64,    0,  -21,   -1]
  K1(119,:) = [   -1,  -24,    3,    8,    8,    6,    0,  -10,  -64,  -21,    0,   -1]
  K1(120,:) = [    0,  -10,   -1,    0,  -24,  -10,  -10,  -30,  -24,   -1,   -1,   -3]
  K1(121,:) = [  192,   64,   64,   24,    0,   -8,   64,    0,    0,   64,   -8,    0]
  K1(122,:) = [   64,  192,   24,   64,   -8,    0,    0,   64,   64,    0,    0,   -8]
  K1(123,:) = [   64,   24,  192,   64,   64,    0,    0,   -8,   -8,    0,    0,   64]
  K1(124,:) = [   24,   64,   64,  192,    0,   64,   -8,    0,    0,   -8,   64,    0]
  K1(125,:) = [    0,   -8,   64,    0,  192,   64,   64,   24,  -24,   -8,   -8,   24]
  K1(126,:) = [   -8,    0,    0,   64,   64,  192,   24,   64,   -8,  -24,   24,   -8]
  K1(127,:) = [   64,    0,    0,   -8,   64,   24,  192,   64,   -8,   24,  -24,   -8]
  K1(128,:) = [    0,   64,   -8,    0,   24,   64,   64,  192,   24,   -8,   -8,  -24]
  K1(129,:) = [    0,   64,   -8,    0,  -24,   -8,   -8,   24,  192,   64,   64,   24]
  K1(130,:) = [   64,    0,    0,   -8,   -8,  -24,   24,   -8,   64,  192,   24,   64]
  K1(131,:) = [   -8,    0,    0,   64,   -8,   24,  -24,   -8,   64,   24,  192,   64]
  K1(132,:) = [    0,   -8,   64,    0,   24,   -8,   -8,  -24,   24,   64,   64,  192]
  K1(133,:) = [    0,  -72,   -9,  -27,    0,   -9,    9,  -27,    0,   72,    9,   27]
  K1(134,:) = [  -72, -216,  -27,  -72,    9,    0,    0,  -72,  -72,    0,    0,    9]
  K1(135,:) = [   -9,  -27,    0,  -72,    9,  -27,    0,   -9,    9,   27,    0,   72]
  K1(136,:) = [  -27,  -72,  -72, -216,    0,  -72,    9,    0,    0,    9,  -72,    0]
  K1(137,:) = [    0,    9,    9,    0,   27,    9,    9,   27,   27,    9,    9,   27]
  K1(138,:) = [   -9,    0,  -27,  -72,    9,    0,   27,   72,    9,    0,  -27,   -9]
  K1(139,:) = [    9,    0,    0,    9,    9,   27,   27,    9,    9,   27,   27,    9]
  K1(140,:) = [  -27,  -72,   -9,    0,   27,   72,    9,    0,  -27,   -9,    9,    0]
  K1(141,:) = [    0,  -72,    9,    0,   27,    9,    9,  -27, -216,  -72,  -72,  -27]
  K1(142,:) = [   72,    0,   27,    9,    9,    0,   27,   -9,  -72,    0,  -27,   -9]
  K1(143,:) = [    9,    0,    0,  -72,    9,  -27,   27,    9,  -72,  -27, -216,  -72]
  K1(144,:) = [   27,    9,   72,    0,   27,   -9,    9,    0,  -27,   -9,  -72,    0]
  K1(145,:) = [    0,   -9,  -72,  -27,    0,    9,   72,   27,    0,    9,   -9,  -27]
  K1(146,:) = [   -9,    0,  -27,  -72,    9,    0,   27,   72,    9,    0,  -27,   -9]
  K1(147,:) = [  -72,  -27, -216,  -72,  -72,    0,    0,    9,    9,    0,    0,  -72]
  K1(148,:) = [  -27,  -72,  -72, -216,    0,  -72,    9,    0,    0,    9,  -72,    0]
  K1(149,:) = [    0,    9,  -72,    0, -216,  -72,  -72,  -27,   27,    9,    9,  -27]
  K1(150,:) = [    9,    0,    0,  -72,  -72, -216,  -27,  -72,    9,   27,  -27,    9]
  K1(151,:) = [   72,   27,    0,    9,  -72,  -27,    0,   -9,    9,   27,    0,   -9]
  K1(152,:) = [   27,   72,    9,    0,  -27,  -72,   -9,    0,   27,    9,   -9,    0]
  K1(153,:) = [    0,    9,    9,    0,   27,    9,    9,   27,   27,    9,    9,   27]
  K1(154,:) = [    9,    0,    0,    9,    9,   27,   27,    9,    9,   27,   27,    9]
  K1(155,:) = [   -9,  -27,    0,  -72,    9,  -27,    0,   -9,    9,   27,    0,   72]
  K1(156,:) = [  -27,   -9,  -72,    0,  -27,    9,   -9,    0,   27,    9,   72,    0]
  K1(157,:) = [ -216,  -72,  -72,  -27,    0,    9,  -72,    0,    0,  -72,    9,    0]
  K1(158,:) = [  -72,    0,  -27,   -9,   -9,    0,  -27,    9,   72,    0,   27,    9]
  K1(159,:) = [  -72,  -27, -216,  -72,  -72,    0,    0,    9,    9,    0,    0,  -72]
  K1(160,:) = [  -27,   -9,  -72,    0,  -27,    9,   -9,    0,   27,    9,   72,    0]
  K1(161,:) = [    0,   -9,  -72,  -27,    0,    9,   72,   27,    0,    9,   -9,  -27]
  K1(162,:) = [    9,    0,    0,    9,    9,   27,   27,    9,    9,   27,   27,    9]
  K1(163,:) = [  -72,  -27,    0,   -9,   72,   27,    0,    9,   -9,  -27,    0,    9]
  K1(164,:) = [    0,    9,    9,    0,   27,    9,    9,   27,   27,    9,    9,   27]
  K1(165,:) = [    0,   72,    9,   27,    0,    9,   -9,   27,    0,  -72,   -9,  -27]
  K1(166,:) = [  -72,    0,    0,    9,    9,   27,  -27,    9,  -72, -216,  -27,  -72]
  K1(167,:) = [    9,   27,    0,   72,   -9,   27,    0,    9,   -9,  -27,    0,  -72]
  K1(168,:) = [    0,    9,  -72,    0,  -27,    9,    9,   27,  -27,  -72,  -72, -216]
  K1(169,:) = [ -216,  -72,  -72,  -27,    0,    9,  -72,    0,    0,  -72,    9,    0]
  K1(170,:) = [  -72, -216,  -27,  -72,    9,    0,    0,  -72,  -72,    0,    0,    9]
  K1(171,:) = [  -72,  -27,    0,   -9,   72,   27,    0,    9,   -9,  -27,    0,    9]
  K1(172,:) = [  -27,  -72,   -9,    0,   27,   72,    9,    0,  -27,   -9,    9,    0]
  K1(173,:) = [    0,    9,   72,   27,    0,   -9,  -72,  -27,    0,   -9,    9,   27]
  K1(174,:) = [    9,    0,   27,   72,   -9,    0,  -27,  -72,   -9,    0,   27,    9]
  K1(175,:) = [  -72,    0,    0,    9,  -72,  -27, -216,  -72,    9,  -27,   27,    9]
  K1(176,:) = [    0,  -72,    9,    0,  -27,  -72,  -72, -216,  -27,    9,    9,   27]
  K1(177,:) = [    0,  -72,   -9,  -27,    0,   -9,    9,  -27,    0,   72,    9,   27]
  K1(178,:) = [  -72,    0,  -27,   -9,   -9,    0,  -27,    9,   72,    0,   27,    9]
  K1(179,:) = [    9,    0,    0,    9,    9,   27,   27,    9,    9,   27,   27,    9]
  K1(180,:) = [    0,    9,    9,    0,   27,    9,    9,   27,   27,    9,    9,   27]
  K1(181,:) = [  432,  144,  144,   54,    0,  -18,  144,    0,    0,  144,  -18,    0]
  K1(182,:) = [  144,  432,   54,  144,  -18,    0,    0,  144,  144,    0,    0,  -18]
  K1(183,:) = [  144,   54,  432,  144,  144,    0,    0,  -18,  -18,    0,    0,  144]
  K1(184,:) = [   54,  144,  144,  432,    0,  144,  -18,    0,    0,  -18,  144,    0]
  K1(185,:) = [    0,  -18,  144,    0,  432,  144,  144,   54,  -54,  -18,  -18,   54]
  K1(186,:) = [  -18,    0,    0,  144,  144,  432,   54,  144,  -18,  -54,   54,  -18]
  K1(187,:) = [  144,    0,    0,  -18,  144,   54,  432,  144,  -18,   54,  -54,  -18]
  K1(188,:) = [    0,  144,  -18,    0,   54,  144,  144,  432,   54,  -18,  -18,  -54]
  K1(189,:) = [    0,  144,  -18,    0,  -54,  -18,  -18,   54,  432,  144,  144,   54]
  K1(190,:) = [  144,    0,    0,  -18,  -18,  -54,   54,  -18,  144,  432,   54,  144]
  K1(191,:) = [  -18,    0,    0,  144,  -18,   54,  -54,  -18,  144,   54,  432,  144]
  K1(192,:) = [    0,  -18,  144,    0,   54,  -18,  -18,  -54,   54,  144,  144,  432]
  K1(193,:) = [ -216,  -72,  -72,  -27,    0,    9,  -72,    0,    0,  -72,    9,    0]
  K1(194,:) = [  -72,    0,  -27,   -9,    9,   27,    0,   72,    9,  -27,    0,   -9]
  K1(195,:) = [  -72,  -27, -216,  -72,  -72,    0,    0,    9,    9,    0,    0,  -72]
  K1(196,:) = [  -27,   -9,  -72,    0,    0,   72,    9,   27,    0,   -9,    9,  -27]
  K1(197,:) = [    0,    9,  -72,    0, -216,  -72,  -72,  -27,   27,    9,    9,  -27]
  K1(198,:) = [    9,   27,    0,   72,  -72,    0,  -27,   -9,    9,    0,   27,   -9]
  K1(199,:) = [  -72,    0,    0,    9,  -72,  -27, -216,  -72,    9,  -27,   27,    9]
  K1(200,:) = [    0,   72,    9,   27,  -27,   -9,  -72,    0,   27,   -9,    9,    0]
  K1(201,:) = [    0,    9,    9,    0,   27,    9,    9,   27,   27,    9,    9,   27]
  K1(202,:) = [  -72,  -27,    0,   -9,    9,    0,  -27,   -9,    9,    0,   27,   72]
  K1(203,:) = [    9,    0,    0,    9,    9,   27,   27,    9,    9,   27,   27,    9]
  K1(204,:) = [    0,   -9,  -72,  -27,  -27,   -9,    9,    0,   27,   72,    9,    0]
  K1(205,:) = [ -216,  -72,  -72,  -27,    0,    9,  -72,    0,    0,  -72,    9,    0]
  K1(206,:) = [  -72, -216,  -27,  -72,    9,    0,    0,  -72,  -72,    0,    0,    9]
  K1(207,:) = [  -72,  -27,    0,   -9,    9,    0,  -27,   -9,    9,    0,   27,   72]
  K1(208,:) = [  -27,  -72,   -9,    0,    0,    9,   -9,  -27,    0,    9,   72,   27]
  K1(209,:) = [    0,    9,    9,    0,   27,    9,    9,   27,   27,    9,    9,   27]
  K1(210,:) = [    9,    0,    0,    9,    9,   27,   27,    9,    9,   27,   27,    9]
  K1(211,:) = [  -72,    0,  -27,   -9,    9,   27,    0,   72,    9,  -27,    0,   -9]
  K1(212,:) = [    0,  -72,   -9,  -27,   27,    9,   72,    0,  -27,    9,   -9,    0]
  K1(213,:) = [    0,  -72,    9,    0,   27,    9,    9,  -27, -216,  -72,  -72,  -27]
  K1(214,:) = [  -72,    0,    0,    9,    9,   27,  -27,    9,  -72, -216,  -27,  -72]
  K1(215,:) = [    9,    0,   27,   72,    9,   27,    0,   -9,  -72,  -27,    0,   -9]
  K1(216,:) = [    0,    9,   72,   27,   27,    9,   -9,    0,  -27,  -72,   -9,    0]
  K1(217,:) = [    0,  -72,   -9,  -27,   27,    9,   72,    0,  -27,    9,   -9,    0]
  K1(218,:) = [  -72, -216,  -27,  -72,    9,    0,    0,  -72,  -72,    0,    0,    9]
  K1(219,:) = [   -9,  -27,    0,  -72,   72,    0,   27,    9,   -9,    0,  -27,    9]
  K1(220,:) = [  -27,  -72,  -72, -216,    0,  -72,    9,    0,    0,    9,  -72,    0]
  K1(221,:) = [   27,    9,   72,    0,    0,  -72,   -9,  -27,    0,    9,   -9,   27]
  K1(222,:) = [    9,    0,    0,  -72,  -72, -216,  -27,  -72,    9,   27,  -27,    9]
  K1(223,:) = [   72,    0,   27,    9,   -9,  -27,    0,  -72,   -9,   27,    0,    9]
  K1(224,:) = [    0,  -72,    9,    0,  -27,  -72,  -72, -216,  -27,    9,    9,   27]
  K1(225,:) = [  -27,  -72,   -9,    0,    0,    9,   -9,  -27,    0,    9,   72,   27]
  K1(226,:) = [    9,    0,    0,    9,    9,   27,   27,    9,    9,   27,   27,    9]
  K1(227,:) = [   -9,    0,  -27,  -72,   -9,  -27,    0,    9,   72,   27,    0,    9]
  K1(228,:) = [    0,    9,    9,    0,   27,    9,    9,   27,   27,    9,    9,   27]
  K1(229,:) = [    0,   -9,  -72,  -27,  -27,   -9,    9,    0,   27,   72,    9,    0]
  K1(230,:) = [   -9,    0,  -27,  -72,   -9,  -27,    0,    9,   72,   27,    0,    9]
  K1(231,:) = [  -72,  -27, -216,  -72,  -72,    0,    0,    9,    9,    0,    0,  -72]
  K1(232,:) = [  -27,  -72,  -72, -216,    0,  -72,    9,    0,    0,    9,  -72,    0]
  K1(233,:) = [  -27,   -9,  -72,    0,    0,   72,    9,   27,    0,   -9,    9,  -27]
  K1(234,:) = [   -9,  -27,    0,  -72,   72,    0,   27,    9,   -9,    0,  -27,    9]
  K1(235,:) = [    9,    0,    0,    9,    9,   27,   27,    9,    9,   27,   27,    9]
  K1(236,:) = [    0,    9,    9,    0,   27,    9,    9,   27,   27,    9,    9,   27]
  K1(237,:) = [   27,   72,    9,    0,    0,   -9,    9,   27,    0,   -9,  -72,  -27]
  K1(238,:) = [   72,   27,    0,    9,   -9,    0,   27,    9,   -9,    0,  -27,  -72]
  K1(239,:) = [    9,    0,    0,  -72,    9,  -27,   27,    9,  -72,  -27, -216,  -72]
  K1(240,:) = [    0,    9,  -72,    0,  -27,    9,    9,   27,  -27,  -72,  -72, -216]
  K1(241,:) = [    0,   81,   81,   54,    0,    0,  -81,    0,    0,  -81,    0,    0]
  K1(242,:) = [   81,    0,   54,   81,    0,    0,    0,  -81,  -81,    0,    0,    0]
  K1(243,:) = [   81,   54,    0,   81,  -81,    0,    0,    0,    0,    0,    0,  -81]
  K1(244,:) = [   54,   81,   81,    0,    0,  -81,    0,    0,    0,    0,  -81,    0]
  K1(245,:) = [    0,    0,  -81,    0, -243,  -81,  -81,  -54,    0,    0,    0,  -54]
  K1(246,:) = [    0,    0,    0,  -81,  -81, -243,  -54,  -81,    0,    0,  -54,    0]
  K1(247,:) = [  -81,    0,    0,    0,  -81,  -54, -243,  -81,    0,  -54,    0,    0]
  K1(248,:) = [    0,  -81,    0,    0,  -54,  -81,  -81, -243,  -54,    0,    0,    0]
  K1(249,:) = [    0,  -81,    0,    0,    0,    0,    0,  -54, -243,  -81,  -81,  -54]
  K1(250,:) = [  -81,    0,    0,    0,    0,    0,  -54,    0,  -81, -243,  -54,  -81]
  K1(251,:) = [    0,    0,    0,  -81,    0,  -54,    0,    0,  -81,  -54, -243,  -81]
  K1(252,:) = [    0,    0,  -81,    0,  -54,    0,    0,    0,  -54,  -81,  -81, -243]
  K1(253,:) = [  432,  144,  144,   54,    0,  -18,  144,    0,    0,  144,  -18,    0]
  K1(254,:) = [  144,  432,   54,  144,  -18,    0,    0,  144,  144,    0,    0,  -18]
  K1(255,:) = [  144,   54,  432,  144,  144,    0,    0,  -18,  -18,    0,    0,  144]
  K1(256,:) = [   54,  144,  144,  432,    0,  144,  -18,    0,    0,  -18,  144,    0]
  K1(257,:) = [    0,  -18,  144,    0,  432,  144,  144,   54,  -54,  -18,  -18,   54]
  K1(258,:) = [  -18,    0,    0,  144,  144,  432,   54,  144,  -18,  -54,   54,  -18]
  K1(259,:) = [  144,    0,    0,  -18,  144,   54,  432,  144,  -18,   54,  -54,  -18]
  K1(260,:) = [    0,  144,  -18,    0,   54,  144,  144,  432,   54,  -18,  -18,  -54]
  K1(261,:) = [    0,  144,  -18,    0,  -54,  -18,  -18,   54,  432,  144,  144,   54]
  K1(262,:) = [  144,    0,    0,  -18,  -18,  -54,   54,  -18,  144,  432,   54,  144]
  K1(263,:) = [  -18,    0,    0,  144,  -18,   54,  -54,  -18,  144,   54,  432,  144]
  K1(264,:) = [    0,  -18,  144,    0,   54,  -18,  -18,  -54,   54,  144,  144,  432]
  K1(265,:) = [    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,    0]
  K1(266,:) = [    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,    0]
  K1(267,:) = [    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,    0]
  K1(268,:) = [    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,    0]
  K1(269,:) = [    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,    0]
  K1(270,:) = [    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,    0]
  K1(271,:) = [    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,    0]
  K1(272,:) = [    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,    0]
  K1(273,:) = [    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,    0]
  K1(274,:) = [    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,    0]
  K1(275,:) = [    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,    0]
  K1(276,:) = [    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,    0]
  K1 = (1._/**/REALKIND / 9) * K1

  K2( 1,:) = [ 48, 16, 16,  6,  0, -2, 16,  0,  0, 16, -2,  0,  6,  0]
  K2( 2,:) = [ 16, 48,  6, 16, -2,  0,  0, 16, 16,  0,  0, -2,  0,  6]
  K2( 3,:) = [ 16,  6, 48, 16, 16,  0,  0, -2, -2,  0,  0, 16,  0,  6]
  K2( 4,:) = [  6, 16, 16, 48,  0, 16, -2,  0,  0, -2, 16,  0,  6,  0]
  K2( 5,:) = [  0, -2, 16,  0, 48, 16, 16,  6, -6, -2, -2,  6,  6, 18]
  K2( 6,:) = [ -2,  0,  0, 16, 16, 48,  6, 16, -2, -6,  6, -2, 18,  6]
  K2( 7,:) = [ 16,  0,  0, -2, 16,  6, 48, 16, -2,  6, -6, -2, 18,  6]
  K2( 8,:) = [  0, 16, -2,  0,  6, 16, 16, 48,  6, -2, -2, -6,  6, 18]
  K2( 9,:) = [  0, 16, -2,  0, -6, -2, -2,  6, 48, 16, 16,  6,  6, 18]
  K2(10,:) = [ 16,  0,  0, -2, -2, -6,  6, -2, 16, 48,  6, 16, 18,  6]
  K2(11,:) = [ -2,  0,  0, 16, -2,  6, -6, -2, 16,  6, 48, 16, 18,  6]
  K2(12,:) = [  0, -2, 16,  0,  6, -2, -2, -6,  6, 16, 16, 48,  6, 18]
  K2 = (1._/**/REALKIND / 3) * K2

  KL( 1,:) = [ 48, 16, 16,  6,  0, -2, 16,  0,  0, 16, -2,  0,  6,  0]
  KL( 2,:) = [ 16, 48,  6, 16, -2,  0,  0, 16, 16,  0,  0, -2,  0,  6]
  KL( 3,:) = [ 16,  6, 48, 16, 16,  0,  0, -2, -2,  0,  0, 16,  0,  6]
  KL( 4,:) = [  6, 16, 16, 48,  0, 16, -2,  0,  0, -2, 16,  0,  6,  0]
  KL( 5,:) = [  0, -2, 16,  0, 48, 16, 16,  6, -6, -2, -2,  6,  6, 18]
  KL( 6,:) = [ -2,  0,  0, 16, 16, 48,  6, 16, -2, -6,  6, -2, 18,  6]
  KL( 7,:) = [ 16,  0,  0, -2, 16,  6, 48, 16, -2,  6, -6, -2, 18,  6]
  KL( 8,:) = [  0, 16, -2,  0,  6, 16, 16, 48,  6, -2, -2, -6,  6, 18]
  KL( 9,:) = [  0, 16, -2,  0, -6, -2, -2,  6, 48, 16, 16,  6,  6, 18]
  KL(10,:) = [ 16,  0,  0, -2, -2, -6,  6, -2, 16, 48,  6, 16, 18,  6]
  KL(11,:) = [ -2,  0,  0, 16, -2,  6, -6, -2, 16,  6, 48, 16, 18,  6]
  KL(12,:) = [  0, -2, 16,  0,  6, -2, -2, -6,  6, 16, 16, 48,  6, 18]
  KL = (1._/**/REALKIND / 3) * KL

  end subroutine colourmatrix_init
end module ol_colourmatrix_ppttjj_ttxbbxgg_1_/**/REALKIND



module ol_forced_parameters_ppttjj_ttxbbxgg_1_/**/REALKIND
  implicit none
  contains
  subroutine check_forced_parameters
    use ol_parameters_decl_/**/REALKIND
    use ol_loop_parameters_decl_/**/REALKIND
#ifndef PRECISION_dp
    use ol_loop_parameters_decl_/**/DREALKIND, only: LeadingColour, nc, nf, CKMORDER
#endif
    implicit none
    logical, save :: checks_not_written = .true.

    if (checks_not_written) then
    ! e.g.
    ! if (ME /= 0) write(*,101) 'ME = 0'
  if (CKMORDER /= 0) write(*,101) 'CKMORDER = 0'
  if (nc /= 3) write(*,101) 'nc = 3'
  if (nf /= 6) write(*,101) 'nf = 6'
  if (MU /= 0) write(*,101) 'MU = 0'
  if (MD /= 0) write(*,101) 'MD = 0'
  if (MS /= 0) write(*,101) 'MS = 0'
  if (MC /= 0) write(*,101) 'MC = 0'
  if (LeadingColour /= 0) write(*,101) 'LeadingColour = 0'
  if (wMT /= 0) write(*,101) 'wMT = 0'
  if (wMT /= 0) write(*,101) 'wMT = 0'
  if (wMB /= 0) write(*,101) 'wMB = 0'
  if (wMB /= 0) write(*,101) 'wMB = 0'


    checks_not_written = .false.
    end if

    101 format('[OpenLoops] === WARNING ===',/,'[OpenLoops] code was generated with ',A,/,'[OpenLoops] ===============')
  end subroutine check_forced_parameters
end module ol_forced_parameters_ppttjj_ttxbbxgg_1_/**/REALKIND
! **********************************************************************
module ol_loop_storage_ppttjj_ttxbbxgg_1_/**/REALKIND
! **********************************************************************
  use KIND_TYPES, only: REALKIND, intkind1, intkind2  
  use ol_data_types_/**/REALKIND, only: wfun, Hpolcont
  
#ifdef PRECISION_dp
  integer(intkind1), save :: ntry = 1
  integer(intkind1), save :: p_switch = 0 ! switch for dp or qp. Used for memory allocation of the OL types 
  ! the following are flags for memory allocation of the hol coefficients in dp or qp 
  logical, save :: dp_not_alloc = .TRUE., qp_not_alloc = .TRUE.
  integer(intkind2), parameter :: nheltot = 64 ! number of helicity configurations
  integer(intkind2), save :: nhel = 64 ! number of non-vanishing helicity configurations (adapted at runtime)
  integer(intkind2), save :: Hel(64) ! physical helicity states
#endif

  complex(REALKIND), save :: den(412)

  ! external wave functions ex1(h1),... for h<n> helicities
  type(wfun) :: ex1(2), ex2(2), ex3(2), ex4(2), ex5(2), ex6(2)

  ! wf<h>(h,n) n wave functions with h helicity configurations
  type(wfun) :: wf4(4,57), wf8(8,150), wf16(16,142), wf64(64,301)

  ! diagram prefactors
  integer,           save :: fac_status_loop1 = -1, fac_status_loop2 = -1
  complex(REALKIND), save :: f(20), c(40)

  !below the colour vector for Born-Loop interference
  type(Hpolcont),   save :: M0_col1_helarray(14,64)

end module ol_loop_storage_ppttjj_ttxbbxgg_1_/**/REALKIND






! **********************************************************************
module ol_loop_ppttjj_ttxbbxgg_1_/**/REALKIND
! **********************************************************************
  use KIND_TYPES, only: REALKIND, DREALKIND, intkind1, intkind2  
  use ol_data_types_/**/REALKIND, only: wfun, Hpolcont
  use ol_loop_storage_ppttjj_ttxbbxgg_1_/**/REALKIND
  implicit none

!*********************************************************************************
  contains

! **********************************************************************
subroutine fac_init_loop()
! Writes diagram prefactors to 'f', rsp. 'c'
! **********************************************************************
  use ol_parameters_decl_/**/REALKIND
  use ol_loop_parameters_decl_/**/REALKIND
  use ol_init, only: set_parameter, tree_parameters_flush, parameters_flush
#ifndef PRECISION_dp
  use ol_loop_parameters_decl_/**/DREALKIND, only: SwF, SwB
!  use ol_loop_parameters_decl_/**/DREALKIND, only: DOI
#endif
  implicit none
  call set_parameter("ew_renorm", 0)
  if (parameters_status == 0) call tree_parameters_flush()
  if (loop_parameters_status == 0) call parameters_flush()
  fac_status_loop1 = parameters_status
  fac_status_loop2 = loop_parameters_status
  ! factors of the diagrams
    f( 1) = CI*gQCD**4
    f( 2) = gQCD**4
    f( 3) = CI*countertermnorm*gQCD**6
    f( 4) = countertermnorm*gQCD**6
    f( 5) = CI*countertermnorm*ctGbb*gQCD**6
    f( 6) = countertermnorm*ctGbb*gQCD**6
    f( 7) = CI*countertermnorm*ctGtt*gQCD**6
    f( 8) = countertermnorm*ctGtt*gQCD**6
    f( 9) = CI*countertermnorm*ctVVV*gQCD**6
    f(10) = countertermnorm*ctVVV*gQCD**6
    f(11) = CI*countertermnorm*ctVVVV*gQCD**6
    f(12) = CI*countertermnorm*gQCD**6*R2GGGG
    f(13) = (CI*gQCD**6*integralnorm*SwB)/2._/**/REALKIND
    f(14) = CI*gQCD**6*integralnorm*SwB
    f(15) = (gQCD**6*integralnorm*SwB)/2._/**/REALKIND
    f(16) = gQCD**6*integralnorm*SwB
    f(17) = CI*gQCD**6*integralnorm*SwF
    f(18) = 2*CI*gQCD**6*integralnorm*SwF
    f(19) = gQCD**6*integralnorm*SwF
    f(20) = 2*gQCD**6*integralnorm*SwF

  c = [ 9*CI*f(13), 18*CI*f(13), 27*CI*f(13), 54*CI*f(13), CI*f(14), 3*CI*f(14), 6*CI*f(14), 8*CI*f(14), 9*CI*f(14), 10*CI*f(14) &
    , 18*CI*f(14), 21*CI*f(14), 24*CI*f(14), 27*CI*f(14), 54*CI*f(14), 9*f(15), 18*f(15), 27*f(15), 54*f(15), f(16), 3*f(16) &
    , 6*f(16), 8*f(16), 9*f(16), 10*f(16), 18*f(16), 21*f(16), 24*f(16), 27*f(16), 54*f(16), 3*CI*f(17), 9*CI*f(17), 3*CI*f(18) &
    , 9*CI*f(18), f(19), 3*f(19), 9*f(19), f(20), 3*f(20), 9*f(20) ]
  c = (1._/**/REALKIND / 36) * c
end subroutine fac_init_loop

subroutine denominators()
  use ol_parameters_decl_/**/REALKIND ! masses
  use ol_momenta_decl_/**/REALKIND, only: L
  implicit none
  ! propagators
  den(1) = 1 /((L(5,3))+L(6,3))
  den(2) = 1 /((L(5,12))+L(6,12))
  den(4) = 1 /((L(5,48))+L(6,48))
  den(6) = 1 /((L(5,19))+L(6,19))
  den(9) = 1 /((L(5,28))+L(6,28))
  den(12) = 1 /((L(5,20) - MB2)+L(6,20))
  den(13) = 1 /((L(5,40) - MB2)+L(6,40))
  den(16) = 1 /((L(5,11) - MB2)+L(6,11))
  den(21) = 1 /((L(5,36) - MB2)+L(6,36))
  den(22) = 1 /((L(5,24) - MB2)+L(6,24))
  den(25) = 1 /((L(5,7) - MB2)+L(6,7))
  den(31) = 1 /((L(5,44))+L(6,44))
  den(38) = 1 /((L(5,52) - MB2)+L(6,52))
  den(41) = 1 /((L(5,17) - MT2)+L(6,17))
  den(42) = 1 /((L(5,34) - MT2)+L(6,34))
  den(47) = 1 /((L(5,14) - MT2)+L(6,14))
  den(50) = 1 /((L(5,33) - MT2)+L(6,33))
  den(51) = 1 /((L(5,18) - MT2)+L(6,18))
  den(56) = 1 /((L(5,13) - MT2)+L(6,13))
  den(59) = 1 /((L(5,35))+L(6,35))
  den(67) = 1 /((L(5,49) - MT2)+L(6,49))
  den(78) = 1 /((L(5,60))+L(6,60))
  den(81) = 1 /((L(5,51))+L(6,51))
  den(95) = 1 /((L(5,56) - MB2)+L(6,56))
  den(115) = 1 /((L(5,50) - MT2)+L(6,50))
  den(134) = 1 /((L(5,15))+L(6,15))
  den(149) = 1 /((L(5,43) - MB2)+L(6,43))
  den(152) = 1 /((L(5,23) - MB2)+L(6,23))
  den(166) = 1 /((L(5,27) - MB2)+L(6,27))
  den(169) = 1 /((L(5,39) - MB2)+L(6,39))
  den(201) = 1 /((L(5,46) - MT2)+L(6,46))
  den(205) = 1 /((L(5,29) - MT2)+L(6,29))
  den(218) = 1 /((L(5,30) - MT2)+L(6,30))
  den(222) = 1 /((L(5,45) - MT2)+L(6,45))

  ! denominators
  den(3) = den(1)*den(2)
  den(5) = den(3)*den(4)
  den(7) = den(1)*den(6)
  den(8) = den(2)*den(7)
  den(10) = den(2)*den(9)
  den(11) = den(1)*den(10)
  den(14) = den(1)*den(12)
  den(15) = den(13)*den(14)
  den(17) = den(1)*den(16)
  den(18) = den(12)*den(17)
  den(19) = den(9)*den(12)
  den(20) = den(1)*den(19)
  den(23) = den(1)*den(21)
  den(24) = den(22)*den(23)
  den(26) = den(1)*den(25)
  den(27) = den(22)*den(26)
  den(28) = den(9)*den(22)
  den(29) = den(1)*den(28)
  den(30) = den(17)*den(21)
  den(32) = den(21)*den(31)
  den(33) = den(1)*den(32)
  den(34) = den(13)*den(26)
  den(35) = den(13)*den(31)
  den(36) = den(1)*den(35)
  den(37) = den(4)*den(26)
  den(39) = den(4)*den(38)
  den(40) = den(1)*den(39)
  den(43) = den(41)*den(42)
  den(44) = den(2)*den(43)
  den(45) = den(6)*den(41)
  den(46) = den(2)*den(45)
  den(48) = den(2)*den(47)
  den(49) = den(41)*den(48)
  den(52) = den(50)*den(51)
  den(53) = den(2)*den(52)
  den(54) = den(6)*den(51)
  den(55) = den(2)*den(54)
  den(57) = den(2)*den(56)
  den(58) = den(51)*den(57)
  den(60) = den(50)*den(59)
  den(61) = den(2)*den(60)
  den(62) = den(48)*den(50)
  den(63) = den(42)*den(59)
  den(64) = den(2)*den(63)
  den(65) = den(42)*den(57)
  den(66) = den(4)*den(57)
  den(68) = den(4)*den(67)
  den(69) = den(2)*den(68)
  den(70) = den(21)*den(45)
  den(71) = den(13)*den(45)
  den(72) = den(21)*den(54)
  den(73) = den(13)*den(54)
  den(74) = den(12)*den(60)
  den(75) = den(12)*den(63)
  den(76) = den(22)*den(60)
  den(77) = den(22)*den(63)
  den(79) = den(2)*den(78)
  den(80) = den(1)*den(79)
  den(82) = den(1)*den(81)
  den(83) = den(2)*den(82)
  den(84) = den(1)*den(59)
  den(85) = den(2)*den(84)
  den(86) = den(2)*den(31)
  den(87) = den(1)*den(86)
  den(88) = den(12)*den(84)
  den(89) = den(12)*den(38)
  den(90) = den(1)*den(89)
  den(91) = den(7)*den(21)
  den(92) = den(21)*den(38)
  den(93) = den(1)*den(92)
  den(94) = den(22)*den(84)
  den(96) = den(22)*den(95)
  den(97) = den(1)*den(96)
  den(98) = den(7)*den(13)
  den(99) = den(13)*den(95)
  den(100) = den(1)*den(99)
  den(101) = den(4)*den(17)
  den(102) = den(4)*den(95)
  den(103) = den(1)*den(102)
  den(104) = den(41)*den(67)
  den(105) = den(2)*den(104)
  den(106) = den(41)*den(86)
  den(107) = den(50)*den(67)
  den(108) = den(2)*den(107)
  den(109) = den(10)*den(50)
  den(110) = den(32)*den(41)
  den(111) = den(35)*den(41)
  den(112) = den(19)*den(50)
  den(113) = den(28)*den(50)
  den(114) = den(51)*den(86)
  den(116) = den(51)*den(115)
  den(117) = den(2)*den(116)
  den(118) = den(10)*den(42)
  den(119) = den(42)*den(115)
  den(120) = den(2)*den(119)
  den(121) = den(4)*den(115)
  den(122) = den(2)*den(121)
  den(123) = den(4)*den(48)
  den(124) = den(32)*den(51)
  den(125) = den(35)*den(51)
  den(126) = den(19)*den(42)
  den(127) = den(28)*den(42)
  den(128) = den(2)*den(4)
  den(129) = den(78)*den(128)
  den(130) = den(1)*den(129)
  den(131) = den(1)*den(4)
  den(132) = den(81)*den(131)
  den(133) = den(2)*den(132)
  den(135) = den(3)*den(134)
  den(136) = den(4)*den(135)
  den(137) = den(1)**2
  den(138) = den(86)*den(137)
  den(139) = den(10)*den(137)
  den(140) = den(2)**2
  den(141) = den(84)*den(140)
  den(142) = den(7)*den(140)
  den(143) = den(7)*den(86)
  den(144) = den(10)*den(84)
  den(145) = den(12)*den(13)
  den(146) = den(78)*den(145)
  den(147) = den(1)*den(146)
  den(148) = den(1)*den(13)
  den(150) = den(148)*den(149)
  den(151) = den(12)*den(150)
  den(153) = den(14)*den(152)
  den(154) = den(13)*den(153)
  den(155) = den(89)*den(137)
  den(156) = den(19)*den(137)
  den(157) = den(12)**2
  den(158) = den(84)*den(157)
  den(159) = den(17)*den(157)
  den(160) = den(17)*den(89)
  den(161) = den(19)*den(84)
  den(162) = den(21)*den(22)
  den(163) = den(78)*den(162)
  den(164) = den(1)*den(163)
  den(165) = den(1)*den(22)
  den(167) = den(165)*den(166)
  den(168) = den(21)*den(167)
  den(170) = den(23)*den(169)
  den(171) = den(22)*den(170)
  den(172) = den(96)*den(137)
  den(173) = den(28)*den(137)
  den(174) = den(22)**2
  den(175) = den(84)*den(174)
  den(176) = den(26)*den(96)
  den(177) = den(28)*den(84)
  den(178) = den(26)*den(174)
  den(179) = den(92)*den(137)
  den(180) = den(32)*den(137)
  den(181) = den(21)**2
  den(182) = den(7)*den(181)
  den(183) = den(17)*den(181)
  den(184) = den(17)*den(92)
  den(185) = den(7)*den(32)
  den(186) = den(99)*den(137)
  den(187) = den(35)*den(137)
  den(188) = den(13)**2
  den(189) = den(7)*den(188)
  den(190) = den(26)*den(99)
  den(191) = den(7)*den(35)
  den(192) = den(26)*den(188)
  den(193) = den(102)*den(137)
  den(194) = den(39)*den(137)
  den(195) = den(26)*den(102)
  den(196) = den(17)*den(39)
  den(197) = den(4)**2
  den(198) = den(17)*den(197)
  den(199) = den(26)*den(197)
  den(200) = den(2)*den(42)
  den(202) = den(200)*den(201)
  den(203) = den(41)*den(202)
  den(204) = den(2)*den(41)
  den(206) = den(204)*den(205)
  den(207) = den(42)*den(206)
  den(208) = den(43)*den(81)
  den(209) = den(2)*den(208)
  den(210) = den(41)**2
  den(211) = den(86)*den(210)
  den(212) = den(48)*den(210)
  den(213) = den(104)*den(140)
  den(214) = den(45)*den(86)
  den(215) = den(48)*den(104)
  den(216) = den(45)*den(140)
  den(217) = den(2)*den(51)
  den(219) = den(217)*den(218)
  den(220) = den(50)*den(219)
  den(221) = den(2)*den(50)
  den(223) = den(221)*den(222)
  den(224) = den(51)*den(223)
  den(225) = den(52)*den(81)
  den(226) = den(2)*den(225)
  den(227) = den(51)**2
  den(228) = den(86)*den(227)
  den(229) = den(116)*den(140)
  den(230) = den(54)*den(86)
  den(231) = den(57)*den(116)
  den(232) = den(57)*den(227)
  den(233) = den(54)*den(140)
  den(234) = den(50)**2
  den(235) = den(10)*den(234)
  den(236) = den(48)*den(234)
  den(237) = den(107)*den(140)
  den(238) = den(10)*den(60)
  den(239) = den(48)*den(107)
  den(240) = den(60)*den(140)
  den(241) = den(42)**2
  den(242) = den(10)*den(241)
  den(243) = den(119)*den(140)
  den(244) = den(10)*den(63)
  den(245) = den(57)*den(119)
  den(246) = den(57)*den(241)
  den(247) = den(63)*den(140)
  den(248) = den(57)*den(121)
  den(249) = den(48)*den(68)
  den(250) = den(121)*den(140)
  den(251) = den(48)*den(197)
  den(252) = den(68)*den(140)
  den(253) = den(57)*den(197)
  den(254) = den(32)*den(210)
  den(255) = den(32)*den(45)
  den(256) = den(45)*den(181)
  den(257) = den(35)*den(210)
  den(258) = den(35)*den(45)
  den(259) = den(45)*den(188)
  den(260) = den(32)*den(227)
  den(261) = den(32)*den(54)
  den(262) = den(54)*den(181)
  den(263) = den(35)*den(227)
  den(264) = den(35)*den(54)
  den(265) = den(54)*den(188)
  den(266) = den(19)*den(234)
  den(267) = den(19)*den(60)
  den(268) = den(60)*den(157)
  den(269) = den(19)*den(241)
  den(270) = den(19)*den(63)
  den(271) = den(63)*den(157)
  den(272) = den(28)*den(234)
  den(273) = den(28)*den(60)
  den(274) = den(60)*den(174)
  den(275) = den(28)*den(241)
  den(276) = den(28)*den(63)
  den(277) = den(63)*den(174)
  den(278) = den(26)*den(134)
  den(279) = den(26)*den(152)
  den(280) = den(26)*den(169)
  den(281) = den(17)*den(134)
  den(282) = den(17)*den(166)
  den(283) = den(17)*den(149)
  den(284) = den(7)*den(152)
  den(285) = den(7)*den(166)
  den(286) = den(7)*den(81)
  den(287) = den(84)*den(169)
  den(288) = den(84)*den(149)
  den(289) = den(81)*den(84)
  den(290) = den(57)*den(134)
  den(291) = den(48)*den(134)
  den(292) = den(57)*den(205)
  den(293) = den(57)*den(222)
  den(294) = den(10)*den(205)
  den(295) = den(86)*den(222)
  den(296) = den(48)*den(218)
  den(297) = den(48)*den(201)
  den(298) = den(10)*den(218)
  den(299) = den(86)*den(201)
  den(300) = den(10)*den(78)
  den(301) = den(78)*den(86)
  den(302) = den(45)*den(152)
  den(303) = den(45)*den(166)
  den(304) = den(45)*den(81)
  den(305) = den(81)*den(104)
  den(306) = den(54)*den(152)
  den(307) = den(54)*den(166)
  den(308) = den(54)*den(81)
  den(309) = den(81)*den(116)
  den(310) = den(19)*den(205)
  den(311) = den(19)*den(218)
  den(312) = den(19)*den(78)
  den(313) = den(78)*den(89)
  den(314) = den(28)*den(205)
  den(315) = den(28)*den(218)
  den(316) = den(28)*den(78)
  den(317) = den(78)*den(96)
  den(318) = den(60)*den(169)
  den(319) = den(60)*den(149)
  den(320) = den(60)*den(81)
  den(321) = den(81)*den(107)
  den(322) = den(63)*den(169)
  den(323) = den(63)*den(149)
  den(324) = den(63)*den(81)
  den(325) = den(81)*den(119)
  den(326) = den(32)*den(222)
  den(327) = den(32)*den(201)
  den(328) = den(32)*den(78)
  den(329) = den(78)*den(92)
  den(330) = den(35)*den(222)
  den(331) = den(35)*den(201)
  den(332) = den(35)*den(78)
  den(333) = den(78)*den(99)
  den(334) = den(68)*den(81)
  den(335) = den(81)*den(121)
  den(336) = den(39)*den(78)
  den(337) = den(78)*den(102)
  den(338) = den(1)*den(2)*den(4)
  den(339) = den(1)*den(12)*den(13)
  den(340) = den(1)*den(21)*den(22)
  den(341) = den(2)*den(41)*den(42)
  den(342) = den(2)*den(50)*den(51)
  den(343) = den(21)*den(41)
  den(344) = den(13)*den(41)
  den(345) = den(21)*den(51)
  den(346) = den(13)*den(51)
  den(347) = den(12)*den(50)
  den(348) = den(12)*den(42)
  den(349) = den(22)*den(50)
  den(350) = den(22)*den(42)
  den(351) = den(1)*den(128)
  den(352) = den(2)*den(131)
  den(353) = den(2)*den(286)
  den(354) = den(2)*den(289)
  den(355) = den(1)*den(300)
  den(356) = den(1)*den(301)
  den(357) = den(12)*den(283)
  den(358) = den(12)*den(288)
  den(359) = den(1)*den(312)
  den(360) = den(1)*den(313)
  den(361) = den(22)*den(280)
  den(362) = den(22)*den(287)
  den(363) = den(1)*den(316)
  den(364) = den(1)*den(317)
  den(365) = den(21)*den(282)
  den(366) = den(21)*den(285)
  den(367) = den(1)*den(328)
  den(368) = den(1)*den(329)
  den(369) = den(13)*den(279)
  den(370) = den(13)*den(284)
  den(371) = den(1)*den(332)
  den(372) = den(1)*den(333)
  den(373) = den(4)*den(278)
  den(374) = den(4)*den(281)
  den(375) = den(1)*den(336)
  den(376) = den(1)*den(337)
  den(377) = den(2)*den(304)
  den(378) = den(2)*den(305)
  den(379) = den(41)*den(297)
  den(380) = den(41)*den(299)
  den(381) = den(2)*den(308)
  den(382) = den(51)*den(293)
  den(383) = den(2)*den(309)
  den(384) = den(51)*den(295)
  den(385) = den(2)*den(320)
  den(386) = den(2)*den(321)
  den(387) = den(50)*den(296)
  den(388) = den(50)*den(298)
  den(389) = den(2)*den(324)
  den(390) = den(42)*den(292)
  den(391) = den(2)*den(325)
  den(392) = den(42)*den(294)
  den(393) = den(4)*den(290)
  den(394) = den(2)*den(334)
  den(395) = den(4)*den(291)
  den(396) = den(2)*den(335)
  den(397) = den(21)*den(303)
  den(398) = den(41)*den(327)
  den(399) = den(13)*den(302)
  den(400) = den(41)*den(331)
  den(401) = den(21)*den(307)
  den(402) = den(51)*den(326)
  den(403) = den(13)*den(306)
  den(404) = den(51)*den(330)
  den(405) = den(12)*den(319)
  den(406) = den(50)*den(311)
  den(407) = den(12)*den(323)
  den(408) = den(42)*den(310)
  den(409) = den(22)*den(318)
  den(410) = den(50)*den(315)
  den(411) = den(22)*den(322)
  den(412) = den(42)*den(314)

end subroutine denominators

!
!
!
!
!
! **********************************************************************
#ifdef PRECISION_dp
subroutine amp2(P_scatt, M02, M2ct, M2colint) &
    & bind(c,name="Hol_f_amp2_ppttjj_ttxbbxgg_1")
#else
subroutine amp2(P_scatt, M02, M2ct, M2colint)
  use ol_loop_storage_ppttjj_ttxbbxgg_1_/**/DREALKIND, only: ntry, nhel, Hel
#endif
! P_scatt(0:3,Npart) = incoming external momenta
! M2  = helicity-summed squared matrix element for top anti-top bottom anti-bottom glue glue -> 0
! **********************************************************************
  use ol_parameters_decl_/**/REALKIND !, only: ci, parameters_status, ZERO, scalefactor, >masses<
  use ol_parameters_init_/**/REALKIND, only: ensure_mp_init
  use ol_kinematics_/**/REALKIND, only: init_kinematics
  use ol_momenta_decl_/**/DREALKIND, only: momenta_nan_check
  use ol_momenta_decl_/**/REALKIND, only: Q
  use ol_data_types_/**/REALKIND
  use ol_h_helicity_bookkeeping_/**/REALKIND, only: &
    & helbookkeeping_wf, helsync, flip_phase
  use ol_helicity_init, only: helbookkeeping_flip, helsync_flip
  use ol_hel_propagators_/**/REALKIND
  use ol_hel_wavefunctions_/**/REALKIND
  use ol_wavefunctions_/**/REALKIND, only: wf_V_Std
  use ol_hel_vertices_/**/REALKIND
  use ol_hel_contractions_/**/REALKIND
  use ol_external_ppttjj_ttxbbxgg_1, only: external_perm_ppttjj_ttxbbxgg_1, &
    & external_perm_inv_ppttjj_ttxbbxgg_1, extcomb_perm_ppttjj_ttxbbxgg_1, &
    & average_factor_ppttjj_ttxbbxgg_1
  use ol_external_ppttjj_ttxbbxgg_1, only: H, hel_not_initialised, hel_init, POLSEL
  use ol_colourmatrix_ppttjj_ttxbbxgg_1_/**/REALKIND, only: colmat_not_initialised, colourmatrix_init
  use ol_forced_parameters_ppttjj_ttxbbxgg_1_/**/REALKIND, only: check_forced_parameters
  use ol_heltables_OLR_ppttjj_ttxbbxgg_1
  use ol_kinematics_/**/REALKIND, only: LC2Std_Rep_cmplx
  use ol_h_counterterms_/**/REALKIND
  use ol_loop_parameters_decl_/**/REALKIND ! counterterms
  use ol_loop_parameters_decl_/**/DREALKIND, only: IR_is_on
  use ol_init, only: set_parameter, parameters_flush
#ifdef PRECISION_dp
  use ol_kinematics_/**/QREALKIND, only: conv_mom_scatt2in_qp=>conv_mom_scatt2in, &
                                         internal_momenta_qp=>internal_momenta
  use ol_momenta_decl_/**/DREALKIND, only: L, Q
  use ol_momenta_decl_/**/QREALKIND, only: L_qp=>L, Q_qp=>L
#endif
  implicit none

  real(DREALKIND), intent(in)  :: P_scatt(0:3,6)
  real(REALKIND),  intent(out) :: M02, M2ct, M2colint(22)

  integer           :: shift, k, r, m, n
  real(REALKIND)    :: P(0:3,6)
#ifdef PRECISION_dp
  real(QREALKIND)    :: P_qp(0:3,6)
#endif
  integer           :: extmasses2(6)
  real(REALKIND)    :: M2add, M2add_ct, M2add_colint(22)
  complex(REALKIND) :: M1(12), M2(14) 
  real(REALKIND)    :: P_scatt_intern(0:3,6)
  real(REALKIND), save :: scalebackfactor, old_scalefactor = 0
  integer(intkind1) :: nsync
  type(Hpolcont),   save :: M1helarray(12,64)
  type(Hpolcont) :: M1helarray_ct(14,64)

  type(Hpolcont) :: A(64,301)

  !Aj are not used at the moment
  !complex(REALKIND) :: Aj(301)

  complex(REALKIND) :: omega(2) ! phases for helicity correlations

  call set_parameter("ew_renorm", 0)
  call parameters_flush()
  call ensure_mp_init()

  if (colmat_not_initialised) call colourmatrix_init()

  if (fac_status_loop1 /= parameters_status .or. fac_status_loop2 /= loop_parameters_status) then
    ! Note: if fac_init would only be called when parameters changed which are relevant for the factors,
    ! a different 'status' would have to be used, because forced_parameters should be called after every parameter change.
    call check_forced_parameters()
    call fac_init_loop()
  end if

  if (momenta_nan_check(P_scatt) /= 0) then
    M02 = 0
    return
  end if

  extmasses2 = [ nMT, nMT, nMB, nMB, 0, 0 ]
  ! Convert 2 -> n-2 PS-point to n -> 0 (so that P(1) + ... + P(n) = 0) and compute
  ! internal-propagator momenta in light-cone representation
  call init_kinematics(P_scatt, extmasses2, P, external_perm_inv_ppttjj_ttxbbxgg_1, 6)

  ! denominators
  call denominators()

   if (heltables_not_init) call init_heltables()

  ! external WFs
  ! Here the external wavefunctions are initialiased
  call pol_wf_Q(P(:,1), rMT, H1, ex1, POLSEL(1),1)
  call pol_wf_A(P(:,2), rMT, H2, ex2, POLSEL(2),2)
  call pol_wf_Q(P(:,3), rMB, H3, ex3, POLSEL(3),3)
  call pol_wf_A(P(:,4), rMB, H4, ex4, POLSEL(4),4)
  call pol_wf_V(P(:,5), rZERO, H5, ex5, POLSEL(5),5)
  call pol_wf_V(P(:,6), rZERO, H6, ex6, POLSEL(6),6)



  ! internal WFs
  ! e.g. call vert_VQ_A(ntry, ex3, ex1, wf1, n1, t1) ...
  call vert_QA_V(ntry, ex1(:), ex2(:), wf4(:,1), n3(:,1), t3x4(:,:,1))
  call vert_QA_V(ntry, ex3(:), ex4(:), wf4(:,2), n3(:,2), t3x4(:,:,2))
  call vert_GGG_G(ntry, wf4(:,1), ex5(:), ex6(:), wf16(:,1), n4(:,1), t4x16(:,:,1))
  call vert_GGG_G(ntry, ex5(:), ex6(:), wf4(:,1), wf16(:,2), n4(:,2), t4x16(:,:,2))
  call vert_GGG_G(ntry, ex6(:), wf4(:,1), ex5(:), wf16(:,3), n4(:,3), t4x16(:,:,3))
  call vert_UV_W(ntry, ex5(:), 16, ex6(:), 32, wf4(:,3), n3(:,3), t3x4(:,:,3))
  call vert_UV_W(ntry, wf4(:,1), 3, wf4(:,2), 12, wf16(:,4), n3(:,4), t3x16(:,:,1))
  call vert_UV_W(ntry, wf4(:,1), 3, ex5(:), 16, wf8(:,1), n3(:,5), t3x8(:,:,1))
  call vert_UV_W(ntry, wf4(:,2), 12, ex6(:), 32, wf8(:,2), n3(:,6), t3x8(:,:,2))
  call vert_UV_W(ntry, wf4(:,2), 12, ex5(:), 16, wf8(:,3), n3(:,7), t3x8(:,:,3))
  call vert_UV_W(ntry, wf4(:,1), 3, ex6(:), 32, wf8(:,4), n3(:,8), t3x8(:,:,4))
  call vert_VQ_A(ntry, ex5(:), ex3(:), wf4(:,4), n3(:,9), t3x4(:,:,4))
  call vert_AV_Q(ntry, ex4(:), ex6(:), wf4(:,5), n3(:,10), t3x4(:,:,5))
  call prop_Q_A(ntry, wf4(:,4), 20, MB, 1_intkind1, wf4(:,6), n2(1))
  call prop_A_Q(ntry, wf4(:,5), 40, MB, 1_intkind1, wf4(:,7), n2(2))
  call vert_VQ_A(ntry, wf4(:,1), wf4(:,6), wf16(:,5), n3(:,11), t3x16(:,:,2))
  call vert_AV_Q(ntry, ex4(:), wf4(:,1), wf8(:,5), n3(:,12), t3x8(:,:,5))
  call vert_VQ_A(ntry, ex6(:), wf4(:,6), wf8(:,6), n3(:,13), t3x8(:,:,6))
  call prop_A_Q(ntry, wf8(:,5), 11, MB, 1_intkind1, wf8(:,7), n2(3))
  call vert_QA_V(ntry, wf4(:,6), ex4(:), wf8(:,8), n3(:,14), t3x8(:,:,7))
  call vert_VQ_A(ntry, ex6(:), ex3(:), wf4(:,8), n3(:,15), t3x4(:,:,6))
  call vert_AV_Q(ntry, ex4(:), ex5(:), wf4(:,9), n3(:,16), t3x4(:,:,7))
  call prop_Q_A(ntry, wf4(:,8), 36, MB, 1_intkind1, wf4(:,10), n2(4))
  call prop_A_Q(ntry, wf4(:,9), 24, MB, 1_intkind1, wf4(:,11), n2(5))
  call vert_VQ_A(ntry, wf4(:,1), wf4(:,10), wf16(:,6), n3(:,17), t3x16(:,:,3))
  call vert_VQ_A(ntry, wf4(:,1), ex3(:), wf8(:,9), n3(:,18), t3x8(:,:,8))
  call vert_AV_Q(ntry, wf4(:,11), ex6(:), wf8(:,10), n3(:,19), t3x8(:,:,9))
  call prop_Q_A(ntry, wf8(:,9), 7, MB, 1_intkind1, wf8(:,11), n2(6))
  call vert_QA_V(ntry, ex3(:), wf4(:,11), wf8(:,12), n3(:,20), t3x8(:,:,10))
  call vert_VQ_A(ntry, ex5(:), wf4(:,10), wf8(:,13), n3(:,21), t3x8(:,:,11))
  call vert_QA_V(ntry, wf4(:,10), ex4(:), wf8(:,14), n3(:,22), t3x8(:,:,12))
  call vert_AV_Q(ntry, wf4(:,7), ex5(:), wf8(:,15), n3(:,23), t3x8(:,:,13))
  call vert_QA_V(ntry, ex3(:), wf4(:,7), wf8(:,16), n3(:,24), t3x8(:,:,14))
  call vert_AV_Q(ntry, ex4(:), wf4(:,3), wf8(:,17), n3(:,25), t3x8(:,:,15))
  call vert_VQ_A(ntry, wf4(:,3), ex3(:), wf8(:,18), n3(:,26), t3x8(:,:,16))
  call prop_Q_A(ntry, wf8(:,18), 52, MB, 1_intkind1, wf8(:,19), n2(7))
  call vert_VQ_A(ntry, ex5(:), ex1(:), wf4(:,12), n3(:,27), t3x4(:,:,8))
  call vert_AV_Q(ntry, ex2(:), ex6(:), wf4(:,13), n3(:,28), t3x4(:,:,9))
  call prop_Q_A(ntry, wf4(:,12), 17, MT, 1_intkind1, wf4(:,14), n2(8))
  call prop_A_Q(ntry, wf4(:,13), 34, MT, 1_intkind1, wf4(:,15), n2(9))
  call vert_QA_V(ntry, wf4(:,14), wf4(:,15), wf16(:,7), n3(:,29), t3x16(:,:,4))
  call vert_QA_V(ntry, wf4(:,14), ex2(:), wf8(:,20), n3(:,30), t3x8(:,:,17))
  call vert_AV_Q(ntry, ex2(:), wf4(:,2), wf8(:,21), n3(:,31), t3x8(:,:,18))
  call vert_VQ_A(ntry, ex6(:), wf4(:,14), wf8(:,22), n3(:,32), t3x8(:,:,19))
  call prop_A_Q(ntry, wf8(:,21), 14, MT, 1_intkind1, wf8(:,23), n2(10))
  call vert_VQ_A(ntry, ex6(:), ex1(:), wf4(:,16), n3(:,33), t3x4(:,:,10))
  call vert_AV_Q(ntry, ex2(:), ex5(:), wf4(:,17), n3(:,34), t3x4(:,:,11))
  call prop_Q_A(ntry, wf4(:,16), 33, MT, 1_intkind1, wf4(:,18), n2(11))
  call prop_A_Q(ntry, wf4(:,17), 18, MT, 1_intkind1, wf4(:,19), n2(12))
  call vert_QA_V(ntry, wf4(:,18), wf4(:,19), wf16(:,8), n3(:,35), t3x16(:,:,5))
  call vert_QA_V(ntry, ex1(:), wf4(:,19), wf8(:,24), n3(:,36), t3x8(:,:,20))
  call vert_VQ_A(ntry, wf4(:,2), ex1(:), wf8(:,25), n3(:,37), t3x8(:,:,21))
  call vert_AV_Q(ntry, wf4(:,19), ex6(:), wf8(:,26), n3(:,38), t3x8(:,:,22))
  call prop_Q_A(ntry, wf8(:,25), 13, MT, 1_intkind1, wf8(:,27), n2(13))
  call vert_QA_V(ntry, wf4(:,18), ex2(:), wf8(:,28), n3(:,39), t3x8(:,:,23))
  call vert_VQ_A(ntry, ex5(:), wf4(:,18), wf8(:,29), n3(:,40), t3x8(:,:,24))
  call vert_QA_V(ntry, ex1(:), wf4(:,15), wf8(:,30), n3(:,41), t3x8(:,:,25))
  call vert_AV_Q(ntry, wf4(:,15), ex5(:), wf8(:,31), n3(:,42), t3x8(:,:,26))
  call vert_AV_Q(ntry, ex2(:), wf4(:,3), wf8(:,32), n3(:,43), t3x8(:,:,27))
  call vert_VQ_A(ntry, wf4(:,3), ex1(:), wf8(:,33), n3(:,44), t3x8(:,:,28))
  call prop_Q_A(ntry, wf8(:,33), 49, MT, 1_intkind1, wf8(:,34), n2(14))
  call counter_GGG_G(ntry, wf4(:,1), ex5(:), ex6(:), wf16(:,9), n4(:,4), t4x16(:,:,4))
  call counter_GGG_G(ntry, ex5(:), ex6(:), wf4(:,1), wf16(:,10), n4(:,5), t4x16(:,:,5))
  call counter_GGG_G(ntry, ex6(:), wf4(:,1), ex5(:), wf16(:,11), n4(:,6), t4x16(:,:,6))
  call counter_QA_V(ntry, ex3(:), ex4(:), wf4(:,20), n3(:,45), t3x4(:,:,12))
  call counter_QA_V(ntry, ex1(:), ex2(:), wf4(:,21), n3(:,46), t3x4(:,:,13))
  call vert_GGG_G(ntry, wf4(:,21), ex5(:), ex6(:), wf16(:,12), n4(:,7), t4x16(:,:,7))
  call vert_GGG_G(ntry, ex5(:), ex6(:), wf4(:,21), wf16(:,13), n4(:,8), t4x16(:,:,8))
  call vert_GGG_G(ntry, ex6(:), wf4(:,21), ex5(:), wf16(:,14), n4(:,9), t4x16(:,:,9))
  call counter_UV_W(ntry, wf4(:,1), 3, wf4(:,2), 12, wf16(:,15), n3(:,47), t3x16(:,:,6))
  call counter_UV_W(ntry, wf4(:,2), 12, ex6(:), 32, wf8(:,35), n3(:,48), t3x8(:,:,29))
  call counter_UV_W(ntry, wf4(:,1), 3, ex6(:), 32, wf8(:,36), n3(:,49), t3x8(:,:,30))
  call vert_GGG_G(ntry, wf4(:,2), ex5(:), ex6(:), wf16(:,16), n4(:,10), t4x16(:,:,10))
  call counter_V_V(ctGG,21,ntry, wf4(:,1), 3, wf4(:,22), n2(15))
  call vert_GGG_G(ntry, ex5(:), ex6(:), wf4(:,2), wf16(:,17), n4(:,11), t4x16(:,:,11))
  call vert_GGG_G(ntry, ex6(:), wf4(:,2), ex5(:), wf16(:,18), n4(:,12), t4x16(:,:,12))
  call counter_V_V(ctGG,21,ntry, wf4(:,2), 12, wf4(:,23), n2(16))
  call counter_UV_W(ntry, wf4(:,2), 12, ex5(:), 16, wf8(:,37), n3(:,50), t3x8(:,:,31))
  call counter_UV_W(ntry, wf4(:,1), 3, ex5(:), 16, wf8(:,38), n3(:,51), t3x8(:,:,32))
  call counter_UV_W(ntry, ex5(:), 16, ex6(:), 32, wf4(:,24), n3(:,52), t3x4(:,:,14))
  call counter_VQ_A(ntry, wf4(:,1), wf4(:,6), wf16(:,19), n3(:,53), t3x16(:,:,7))
  call counter_VQ_A(ntry, ex6(:), wf4(:,6), wf8(:,39), n3(:,54), t3x8(:,:,33))
  call counter_VQ_A(ntry, wf4(:,1), wf4(:,10), wf16(:,20), n3(:,55), t3x16(:,:,8))
  call counter_AV_Q(ntry, wf4(:,11), ex6(:), wf8(:,40), n3(:,56), t3x8(:,:,34))
  call counter_VQ_A(ntry, ex5(:), wf4(:,10), wf8(:,41), n3(:,57), t3x8(:,:,35))
  call counter_AV_Q(ntry, wf4(:,7), ex5(:), wf8(:,42), n3(:,58), t3x8(:,:,36))
  call vert_AV_Q(ntry, ex4(:), wf4(:,24), wf8(:,43), n3(:,59), t3x8(:,:,37))
  call vert_VQ_A(ntry, wf4(:,24), ex3(:), wf8(:,44), n3(:,60), t3x8(:,:,38))
  call prop_Q_A(ntry, wf8(:,44), 52, MB, 1_intkind1, wf8(:,45), n2(17))
  call counter_QA_V(ntry, wf4(:,6), ex4(:), wf8(:,46), n3(:,61), t3x8(:,:,39))
  call counter_AV_Q(ntry, ex4(:), wf4(:,1), wf8(:,47), n3(:,62), t3x8(:,:,40))
  call prop_Q_A(ntry, wf8(:,6), 52, MB, 1_intkind1, wf8(:,48), n2(18))
  call counter_AV_Q(ntry, ex4(:), ex6(:), wf4(:,25), n3(:,63), t3x4(:,:,15))
  call prop_A_Q(ntry, wf4(:,25), 40, MB, 1_intkind1, wf4(:,26), n2(19))
  call counter_QA_V(ntry, wf4(:,10), ex4(:), wf8(:,49), n3(:,64), t3x8(:,:,41))
  call prop_Q_A(ntry, wf8(:,13), 52, MB, 1_intkind1, wf8(:,50), n2(20))
  call counter_AV_Q(ntry, ex4(:), wf4(:,3), wf8(:,51), n3(:,65), t3x8(:,:,42))
  call vert_AV_Q(ntry, wf4(:,26), ex5(:), wf8(:,52), n3(:,66), t3x8(:,:,43))
  call vert_QA_V(ntry, ex3(:), wf4(:,26), wf8(:,53), n3(:,67), t3x8(:,:,44))
  call counter_AV_Q(ntry, ex4(:), ex5(:), wf4(:,27), n3(:,68), t3x4(:,:,16))
  call prop_A_Q(ntry, wf4(:,27), 24, MB, 1_intkind1, wf4(:,28), n2(21))
  call vert_AV_Q(ntry, wf4(:,28), ex6(:), wf8(:,54), n3(:,69), t3x8(:,:,45))
  call vert_QA_V(ntry, ex3(:), wf4(:,28), wf8(:,55), n3(:,70), t3x8(:,:,46))
  call counter_QA_V(ntry, ex3(:), wf4(:,11), wf8(:,56), n3(:,71), t3x8(:,:,47))
  call counter_VQ_A(ntry, wf4(:,1), ex3(:), wf8(:,57), n3(:,72), t3x8(:,:,48))
  call prop_A_Q(ntry, wf8(:,10), 56, MB, 1_intkind1, wf8(:,58), n2(22))
  call counter_VQ_A(ntry, ex6(:), ex3(:), wf4(:,29), n3(:,73), t3x4(:,:,17))
  call prop_Q_A(ntry, wf4(:,29), 36, MB, 1_intkind1, wf4(:,30), n2(23))
  call vert_VQ_A(ntry, wf4(:,1), wf4(:,30), wf16(:,21), n3(:,74), t3x16(:,:,9))
  call counter_QA_V(ntry, ex3(:), wf4(:,7), wf8(:,59), n3(:,75), t3x8(:,:,49))
  call prop_A_Q(ntry, wf8(:,15), 56, MB, 1_intkind1, wf8(:,60), n2(24))
  call counter_VQ_A(ntry, wf4(:,3), ex3(:), wf8(:,61), n3(:,76), t3x8(:,:,50))
  call prop_A_Q(ntry, wf8(:,17), 56, MB, 1_intkind1, wf8(:,62), n2(25))
  call vert_VQ_A(ntry, ex5(:), wf4(:,30), wf8(:,63), n3(:,77), t3x8(:,:,51))
  call vert_QA_V(ntry, wf4(:,30), ex4(:), wf8(:,64), n3(:,78), t3x8(:,:,52))
  call counter_VQ_A(ntry, ex5(:), ex3(:), wf4(:,31), n3(:,79), t3x4(:,:,18))
  call prop_Q_A(ntry, wf4(:,31), 20, MB, 1_intkind1, wf4(:,32), n2(26))
  call vert_VQ_A(ntry, wf4(:,1), wf4(:,32), wf16(:,22), n3(:,80), t3x16(:,:,10))
  call vert_VQ_A(ntry, ex6(:), wf4(:,32), wf8(:,65), n3(:,81), t3x8(:,:,53))
  call vert_QA_V(ntry, wf4(:,32), ex4(:), wf8(:,66), n3(:,82), t3x8(:,:,54))
  call vert_UV_W(ntry, wf4(:,1), 3, wf4(:,20), 12, wf16(:,23), n3(:,83), t3x16(:,:,11))
  call vert_UV_W(ntry, wf4(:,20), 12, ex6(:), 32, wf8(:,67), n3(:,84), t3x8(:,:,55))
  call vert_UV_W(ntry, wf4(:,20), 12, ex5(:), 16, wf8(:,68), n3(:,85), t3x8(:,:,56))
  call counter_QA_V(ntry, wf4(:,14), wf4(:,15), wf16(:,24), n3(:,86), t3x16(:,:,12))
  call counter_VQ_A(ntry, ex6(:), wf4(:,14), wf8(:,69), n3(:,87), t3x8(:,:,57))
  call counter_QA_V(ntry, wf4(:,18), wf4(:,19), wf16(:,25), n3(:,88), t3x16(:,:,13))
  call counter_AV_Q(ntry, wf4(:,19), ex6(:), wf8(:,70), n3(:,89), t3x8(:,:,58))
  call counter_VQ_A(ntry, ex5(:), wf4(:,18), wf8(:,71), n3(:,90), t3x8(:,:,59))
  call counter_AV_Q(ntry, wf4(:,15), ex5(:), wf8(:,72), n3(:,91), t3x8(:,:,60))
  call vert_AV_Q(ntry, ex2(:), wf4(:,24), wf8(:,73), n3(:,92), t3x8(:,:,61))
  call vert_VQ_A(ntry, wf4(:,24), ex1(:), wf8(:,74), n3(:,93), t3x8(:,:,62))
  call prop_Q_A(ntry, wf8(:,74), 49, MT, 1_intkind1, wf8(:,75), n2(27))
  call vert_AV_Q(ntry, ex2(:), wf4(:,20), wf8(:,76), n3(:,94), t3x8(:,:,63))
  call prop_A_Q(ntry, wf8(:,76), 14, MT, 1_intkind1, wf8(:,77), n2(28))
  call vert_VQ_A(ntry, wf4(:,20), ex1(:), wf8(:,78), n3(:,95), t3x8(:,:,64))
  call prop_Q_A(ntry, wf8(:,78), 13, MT, 1_intkind1, wf8(:,79), n2(29))
  call counter_AV_Q(ntry, ex2(:), wf4(:,2), wf8(:,80), n3(:,96), t3x8(:,:,65))
  call prop_Q_A(ntry, wf8(:,22), 49, MT, 1_intkind1, wf8(:,81), n2(30))
  call counter_QA_V(ntry, wf4(:,14), ex2(:), wf8(:,82), n3(:,97), t3x8(:,:,66))
  call counter_AV_Q(ntry, ex2(:), ex6(:), wf4(:,33), n3(:,98), t3x4(:,:,19))
  call prop_A_Q(ntry, wf4(:,33), 34, MT, 1_intkind1, wf4(:,34), n2(31))
  call vert_QA_V(ntry, wf4(:,14), wf4(:,34), wf16(:,26), n3(:,99), t3x16(:,:,14))
  call prop_Q_A(ntry, wf8(:,29), 49, MT, 1_intkind1, wf8(:,83), n2(32))
  call counter_QA_V(ntry, wf4(:,18), ex2(:), wf8(:,84), n3(:,100), t3x8(:,:,67))
  call counter_AV_Q(ntry, ex2(:), wf4(:,3), wf8(:,85), n3(:,101), t3x8(:,:,68))
  call vert_AV_Q(ntry, wf4(:,34), ex5(:), wf8(:,86), n3(:,102), t3x8(:,:,69))
  call vert_QA_V(ntry, ex1(:), wf4(:,34), wf8(:,87), n3(:,103), t3x8(:,:,70))
  call counter_AV_Q(ntry, ex2(:), ex5(:), wf4(:,35), n3(:,104), t3x4(:,:,20))
  call prop_A_Q(ntry, wf4(:,35), 18, MT, 1_intkind1, wf4(:,36), n2(33))
  call vert_QA_V(ntry, wf4(:,18), wf4(:,36), wf16(:,27), n3(:,105), t3x16(:,:,15))
  call vert_AV_Q(ntry, wf4(:,36), ex6(:), wf8(:,88), n3(:,106), t3x8(:,:,71))
  call vert_QA_V(ntry, ex1(:), wf4(:,36), wf8(:,89), n3(:,107), t3x8(:,:,72))
  call counter_QA_V(ntry, ex1(:), wf4(:,19), wf8(:,90), n3(:,108), t3x8(:,:,73))
  call counter_VQ_A(ntry, wf4(:,2), ex1(:), wf8(:,91), n3(:,109), t3x8(:,:,74))
  call prop_A_Q(ntry, wf8(:,26), 50, MT, 1_intkind1, wf8(:,92), n2(34))
  call counter_VQ_A(ntry, ex6(:), ex1(:), wf4(:,37), n3(:,110), t3x4(:,:,21))
  call prop_Q_A(ntry, wf4(:,37), 33, MT, 1_intkind1, wf4(:,38), n2(35))
  call vert_QA_V(ntry, wf4(:,38), wf4(:,19), wf16(:,28), n3(:,111), t3x16(:,:,16))
  call counter_QA_V(ntry, ex1(:), wf4(:,15), wf8(:,93), n3(:,112), t3x8(:,:,75))
  call prop_A_Q(ntry, wf8(:,31), 50, MT, 1_intkind1, wf8(:,94), n2(36))
  call prop_A_Q(ntry, wf8(:,32), 50, MT, 1_intkind1, wf8(:,95), n2(37))
  call counter_VQ_A(ntry, wf4(:,3), ex1(:), wf8(:,96), n3(:,113), t3x8(:,:,76))
  call vert_QA_V(ntry, wf4(:,38), ex2(:), wf8(:,97), n3(:,114), t3x8(:,:,77))
  call vert_VQ_A(ntry, ex5(:), wf4(:,38), wf8(:,98), n3(:,115), t3x8(:,:,78))
  call counter_VQ_A(ntry, ex5(:), ex1(:), wf4(:,39), n3(:,116), t3x4(:,:,22))
  call prop_Q_A(ntry, wf4(:,39), 17, MT, 1_intkind1, wf4(:,40), n2(38))
  call vert_QA_V(ntry, wf4(:,40), wf4(:,15), wf16(:,29), n3(:,117), t3x16(:,:,17))
  call vert_QA_V(ntry, wf4(:,40), ex2(:), wf8(:,99), n3(:,118), t3x8(:,:,79))
  call vert_VQ_A(ntry, ex6(:), wf4(:,40), wf8(:,100), n3(:,119), t3x8(:,:,80))
  call vert_UV_W(ntry, wf4(:,21), 3, wf4(:,2), 12, wf16(:,30), n3(:,120), t3x16(:,:,18))
  call vert_UV_W(ntry, wf4(:,21), 3, ex5(:), 16, wf8(:,101), n3(:,121), t3x8(:,:,81))
  call vert_UV_W(ntry, wf4(:,21), 3, ex6(:), 32, wf8(:,102), n3(:,122), t3x8(:,:,82))
  call vert_VQ_A(ntry, wf4(:,21), wf4(:,6), wf16(:,31), n3(:,123), t3x16(:,:,19))
  call vert_AV_Q(ntry, ex4(:), wf4(:,21), wf8(:,103), n3(:,124), t3x8(:,:,83))
  call prop_A_Q(ntry, wf8(:,103), 11, MB, 1_intkind1, wf8(:,104), n2(39))
  call vert_VQ_A(ntry, wf4(:,21), wf4(:,10), wf16(:,32), n3(:,125), t3x16(:,:,20))
  call vert_VQ_A(ntry, wf4(:,21), ex3(:), wf8(:,105), n3(:,126), t3x8(:,:,84))
  call prop_Q_A(ntry, wf8(:,105), 7, MB, 1_intkind1, wf8(:,106), n2(40))
  call vert_UV_W(ntry, wf4(:,2), 12, wf4(:,3), 48, wf16(:,33), n3(:,127), t3x16(:,:,21))
  call vert_UV_W(ntry, wf4(:,1), 3, wf4(:,3), 48, wf16(:,34), n3(:,128), t3x16(:,:,22))
  call counter_V_V(ctGG,21,ntry, wf4(:,3), 48, wf4(:,41), n2(41))
  call vert_UV_W(ntry, wf4(:,22), 3, ex5(:), 16, wf8(:,107), n3(:,129), t3x8(:,:,85))
  call vert_UV_W(ntry, wf4(:,22), 3, ex6(:), 32, wf8(:,108), n3(:,130), t3x8(:,:,86))
  call vert_UV_W(ntry, wf4(:,23), 12, ex5(:), 16, wf8(:,109), n3(:,131), t3x8(:,:,87))
  call vert_UV_W(ntry, wf4(:,23), 12, ex6(:), 32, wf8(:,110), n3(:,132), t3x8(:,:,88))
  call counter_V_V(ctGG,21,ntry, wf8(:,1), 19, wf8(:,111), n2(42))
  call counter_V_V(ctGG,21,ntry, wf8(:,3), 28, wf8(:,112), n2(43))
  call vert_QA_V(ntry, wf4(:,6), wf4(:,7), wf16(:,35), n3(:,133), t3x16(:,:,23))
  call vert_AV_Q(ntry, wf4(:,7), wf4(:,1), wf16(:,36), n3(:,134), t3x16(:,:,24))
  call counter_Q_A(ctbb,5,ntry, wf4(:,6), 20, wf4(:,42), n2(44))
  call prop_A_Q(ntry, wf16(:,36), 43, MB, 1_intkind1, wf16(:,37), n2(45))
  call counter_A_Q(ctbb,5,ntry, wf4(:,7), 40, wf4(:,43), n2(46))
  call prop_Q_A(ntry, wf16(:,5), 23, MB, 1_intkind1, wf16(:,38), n2(47))
  call vert_AV_Q(ntry, ex4(:), wf4(:,22), wf8(:,113), n3(:,135), t3x8(:,:,89))
  call prop_Q_A(ntry, wf4(:,42), 20, MB, 1_intkind1, wf4(:,44), n2(48))
  call vert_QA_V(ntry, wf4(:,44), ex4(:), wf8(:,114), n3(:,136), t3x8(:,:,90))
  call vert_VQ_A(ntry, ex6(:), wf4(:,44), wf8(:,115), n3(:,137), t3x8(:,:,91))
  call counter_A_Q(ctbb,5,ntry, wf8(:,7), 11, wf8(:,116), n2(49))
  call counter_V_V(ctGG,21,ntry, wf8(:,8), 28, wf8(:,117), n2(50))
  call vert_QA_V(ntry, wf4(:,10), wf4(:,11), wf16(:,39), n3(:,138), t3x16(:,:,25))
  call vert_AV_Q(ntry, wf4(:,11), wf4(:,1), wf16(:,40), n3(:,139), t3x16(:,:,26))
  call counter_Q_A(ctbb,5,ntry, wf4(:,10), 36, wf4(:,45), n2(51))
  call prop_A_Q(ntry, wf16(:,40), 27, MB, 1_intkind1, wf16(:,41), n2(52))
  call counter_A_Q(ctbb,5,ntry, wf4(:,11), 24, wf4(:,46), n2(53))
  call prop_Q_A(ntry, wf16(:,6), 39, MB, 1_intkind1, wf16(:,42), n2(54))
  call vert_VQ_A(ntry, wf4(:,22), ex3(:), wf8(:,118), n3(:,140), t3x8(:,:,92))
  call prop_A_Q(ntry, wf4(:,46), 24, MB, 1_intkind1, wf4(:,47), n2(55))
  call vert_QA_V(ntry, ex3(:), wf4(:,47), wf8(:,119), n3(:,141), t3x8(:,:,93))
  call counter_Q_A(ctbb,5,ntry, wf8(:,11), 7, wf8(:,120), n2(56))
  call counter_V_V(ctGG,21,ntry, wf8(:,12), 28, wf8(:,121), n2(57))
  call vert_AV_Q(ntry, wf4(:,47), ex6(:), wf8(:,122), n3(:,142), t3x8(:,:,94))
  call prop_Q_A(ntry, wf4(:,45), 36, MB, 1_intkind1, wf4(:,48), n2(58))
  call vert_QA_V(ntry, wf4(:,48), ex4(:), wf8(:,123), n3(:,143), t3x8(:,:,95))
  call vert_VQ_A(ntry, ex5(:), wf4(:,48), wf8(:,124), n3(:,144), t3x8(:,:,96))
  call counter_V_V(ctGG,21,ntry, wf8(:,14), 44, wf8(:,125), n2(59))
  call prop_A_Q(ntry, wf4(:,43), 40, MB, 1_intkind1, wf4(:,49), n2(60))
  call vert_QA_V(ntry, ex3(:), wf4(:,49), wf8(:,126), n3(:,145), t3x8(:,:,97))
  call counter_V_V(ctGG,21,ntry, wf8(:,16), 44, wf8(:,127), n2(61))
  call vert_AV_Q(ntry, wf4(:,49), ex5(:), wf8(:,128), n3(:,146), t3x8(:,:,98))
  call counter_Q_A(ctbb,5,ntry, wf8(:,19), 52, wf8(:,129), n2(62))
  call vert_VQ_A(ntry, wf4(:,41), ex3(:), wf8(:,130), n3(:,147), t3x8(:,:,99))
  call vert_AV_Q(ntry, ex4(:), wf4(:,41), wf8(:,131), n3(:,148), t3x8(:,:,100))
  call vert_AV_Q(ntry, wf4(:,15), wf4(:,2), wf16(:,43), n3(:,149), t3x16(:,:,27))
  call counter_Q_A(cttt,6,ntry, wf4(:,14), 17, wf4(:,50), n2(63))
  call prop_A_Q(ntry, wf16(:,43), 46, MT, 1_intkind1, wf16(:,44), n2(64))
  call vert_VQ_A(ntry, wf4(:,2), wf4(:,14), wf16(:,45), n3(:,150), t3x16(:,:,28))
  call counter_A_Q(cttt,6,ntry, wf4(:,15), 34, wf4(:,51), n2(65))
  call prop_Q_A(ntry, wf16(:,45), 29, MT, 1_intkind1, wf16(:,46), n2(66))
  call prop_Q_A(ntry, wf4(:,50), 17, MT, 1_intkind1, wf4(:,52), n2(67))
  call vert_QA_V(ntry, wf4(:,52), ex2(:), wf8(:,132), n3(:,151), t3x8(:,:,101))
  call vert_VQ_A(ntry, ex6(:), wf4(:,52), wf8(:,133), n3(:,152), t3x8(:,:,102))
  call vert_AV_Q(ntry, ex2(:), wf4(:,23), wf8(:,134), n3(:,153), t3x8(:,:,103))
  call counter_V_V(ctGG,21,ntry, wf8(:,20), 19, wf8(:,135), n2(68))
  call counter_A_Q(cttt,6,ntry, wf8(:,23), 14, wf8(:,136), n2(69))
  call vert_AV_Q(ntry, wf4(:,19), wf4(:,2), wf16(:,47), n3(:,154), t3x16(:,:,29))
  call counter_Q_A(cttt,6,ntry, wf4(:,18), 33, wf4(:,53), n2(70))
  call prop_A_Q(ntry, wf16(:,47), 30, MT, 1_intkind1, wf16(:,48), n2(71))
  call vert_VQ_A(ntry, wf4(:,2), wf4(:,18), wf16(:,49), n3(:,155), t3x16(:,:,30))
  call counter_A_Q(cttt,6,ntry, wf4(:,19), 18, wf4(:,54), n2(72))
  call prop_Q_A(ntry, wf16(:,49), 45, MT, 1_intkind1, wf16(:,50), n2(73))
  call prop_A_Q(ntry, wf4(:,54), 18, MT, 1_intkind1, wf4(:,55), n2(74))
  call vert_QA_V(ntry, ex1(:), wf4(:,55), wf8(:,137), n3(:,156), t3x8(:,:,104))
  call vert_VQ_A(ntry, wf4(:,23), ex1(:), wf8(:,138), n3(:,157), t3x8(:,:,105))
  call counter_V_V(ctGG,21,ntry, wf8(:,24), 19, wf8(:,139), n2(75))
  call counter_Q_A(cttt,6,ntry, wf8(:,27), 13, wf8(:,140), n2(76))
  call vert_AV_Q(ntry, wf4(:,55), ex6(:), wf8(:,141), n3(:,158), t3x8(:,:,106))
  call prop_Q_A(ntry, wf4(:,53), 33, MT, 1_intkind1, wf4(:,56), n2(77))
  call vert_QA_V(ntry, wf4(:,56), ex2(:), wf8(:,142), n3(:,159), t3x8(:,:,107))
  call vert_VQ_A(ntry, ex5(:), wf4(:,56), wf8(:,143), n3(:,160), t3x8(:,:,108))
  call counter_V_V(ctGG,21,ntry, wf8(:,28), 35, wf8(:,144), n2(78))
  call prop_A_Q(ntry, wf4(:,51), 34, MT, 1_intkind1, wf4(:,57), n2(79))
  call vert_QA_V(ntry, ex1(:), wf4(:,57), wf8(:,145), n3(:,161), t3x8(:,:,109))
  call counter_V_V(ctGG,21,ntry, wf8(:,30), 35, wf8(:,146), n2(80))
  call vert_AV_Q(ntry, wf4(:,57), ex5(:), wf8(:,147), n3(:,162), t3x8(:,:,110))
  call counter_Q_A(cttt,6,ntry, wf8(:,34), 49, wf8(:,148), n2(81))
  call vert_VQ_A(ntry, wf4(:,41), ex1(:), wf8(:,149), n3(:,163), t3x8(:,:,111))
  call vert_AV_Q(ntry, ex2(:), wf4(:,41), wf8(:,150), n3(:,164), t3x8(:,:,112))
  call vert_QA_V(ntry, wf8(:,11), ex4(:), wf16(:,51), n3(:,165), t3x16(:,:,31))
  call vert_VQ_A(ntry, ex5(:), wf8(:,11), wf16(:,52), n3(:,166), t3x16(:,:,32))
  call prop_Q_A(ntry, wf16(:,52), 23, MB, 1_intkind1, wf16(:,53), n2(82))
  call vert_VQ_A(ntry, ex6(:), wf8(:,11), wf16(:,54), n3(:,167), t3x16(:,:,33))
  call prop_Q_A(ntry, wf16(:,54), 39, MB, 1_intkind1, wf16(:,55), n2(83))
  call vert_QA_V(ntry, ex3(:), wf8(:,7), wf16(:,56), n3(:,168), t3x16(:,:,34))
  call vert_AV_Q(ntry, wf8(:,7), ex5(:), wf16(:,57), n3(:,169), t3x16(:,:,35))
  call prop_A_Q(ntry, wf16(:,57), 27, MB, 1_intkind1, wf16(:,58), n2(84))
  call vert_AV_Q(ntry, wf8(:,7), ex6(:), wf16(:,59), n3(:,170), t3x16(:,:,36))
  call prop_A_Q(ntry, wf16(:,59), 43, MB, 1_intkind1, wf16(:,60), n2(85))
  call vert_VQ_A(ntry, wf8(:,1), ex3(:), wf16(:,61), n3(:,171), t3x16(:,:,37))
  call prop_Q_A(ntry, wf16(:,61), 23, MB, 1_intkind1, wf16(:,62), n2(86))
  call vert_AV_Q(ntry, ex4(:), wf8(:,1), wf16(:,63), n3(:,172), t3x16(:,:,38))
  call prop_A_Q(ntry, wf16(:,63), 27, MB, 1_intkind1, wf16(:,64), n2(87))
  call vert_UV_W(ntry, wf8(:,1), 19, ex6(:), 32, wf16(:,65), n3(:,173), t3x16(:,:,39))
  call vert_VQ_A(ntry, wf8(:,4), ex3(:), wf16(:,66), n3(:,174), t3x16(:,:,40))
  call prop_Q_A(ntry, wf16(:,66), 39, MB, 1_intkind1, wf16(:,67), n2(88))
  call vert_AV_Q(ntry, ex4(:), wf8(:,4), wf16(:,68), n3(:,175), t3x16(:,:,41))
  call prop_A_Q(ntry, wf16(:,68), 43, MB, 1_intkind1, wf16(:,69), n2(89))
  call vert_UV_W(ntry, ex5(:), 16, wf8(:,4), 35, wf16(:,70), n3(:,176), t3x16(:,:,42))
  call vert_QA_V(ntry, wf8(:,27), ex2(:), wf16(:,71), n3(:,177), t3x16(:,:,43))
  call vert_QA_V(ntry, ex1(:), wf8(:,23), wf16(:,72), n3(:,178), t3x16(:,:,44))
  call vert_VQ_A(ntry, ex5(:), wf8(:,27), wf16(:,73), n3(:,179), t3x16(:,:,45))
  call prop_Q_A(ntry, wf16(:,73), 29, MT, 1_intkind1, wf16(:,74), n2(90))
  call vert_VQ_A(ntry, ex6(:), wf8(:,27), wf16(:,75), n3(:,180), t3x16(:,:,46))
  call prop_Q_A(ntry, wf16(:,75), 45, MT, 1_intkind1, wf16(:,76), n2(91))
  call vert_VQ_A(ntry, wf8(:,3), ex1(:), wf16(:,77), n3(:,181), t3x16(:,:,47))
  call prop_Q_A(ntry, wf16(:,77), 29, MT, 1_intkind1, wf16(:,78), n2(92))
  call vert_VQ_A(ntry, wf8(:,2), ex1(:), wf16(:,79), n3(:,182), t3x16(:,:,48))
  call prop_Q_A(ntry, wf16(:,79), 45, MT, 1_intkind1, wf16(:,80), n2(93))
  call vert_AV_Q(ntry, wf8(:,23), ex5(:), wf16(:,81), n3(:,183), t3x16(:,:,49))
  call prop_A_Q(ntry, wf16(:,81), 30, MT, 1_intkind1, wf16(:,82), n2(94))
  call vert_AV_Q(ntry, wf8(:,23), ex6(:), wf16(:,83), n3(:,184), t3x16(:,:,50))
  call prop_A_Q(ntry, wf16(:,83), 46, MT, 1_intkind1, wf16(:,84), n2(95))
  call vert_AV_Q(ntry, ex2(:), wf8(:,3), wf16(:,85), n3(:,185), t3x16(:,:,51))
  call prop_A_Q(ntry, wf16(:,85), 30, MT, 1_intkind1, wf16(:,86), n2(96))
  call vert_AV_Q(ntry, ex2(:), wf8(:,2), wf16(:,87), n3(:,186), t3x16(:,:,52))
  call prop_A_Q(ntry, wf16(:,87), 46, MT, 1_intkind1, wf16(:,88), n2(97))
  call vert_UV_W(ntry, wf8(:,3), 28, ex6(:), 32, wf16(:,89), n3(:,187), t3x16(:,:,53))
  call vert_UV_W(ntry, ex5(:), 16, wf8(:,2), 44, wf16(:,90), n3(:,188), t3x16(:,:,54))
  call vert_VQ_A(ntry, wf8(:,20), ex3(:), wf16(:,91), n3(:,189), t3x16(:,:,55))
  call prop_Q_A(ntry, wf16(:,91), 23, MB, 1_intkind1, wf16(:,92), n2(98))
  call vert_AV_Q(ntry, ex4(:), wf8(:,20), wf16(:,93), n3(:,190), t3x16(:,:,56))
  call prop_A_Q(ntry, wf16(:,93), 27, MB, 1_intkind1, wf16(:,94), n2(99))
  call vert_UV_W(ntry, wf8(:,20), 19, ex6(:), 32, wf16(:,95), n3(:,191), t3x16(:,:,57))
  call vert_QA_V(ntry, wf8(:,81), ex2(:), wf16(:,96), n3(:,192), t3x16(:,:,58))
  call vert_VQ_A(ntry, wf8(:,24), ex3(:), wf16(:,97), n3(:,193), t3x16(:,:,59))
  call prop_Q_A(ntry, wf16(:,97), 23, MB, 1_intkind1, wf16(:,98), n2(100))
  call vert_AV_Q(ntry, ex4(:), wf8(:,24), wf16(:,99), n3(:,194), t3x16(:,:,60))
  call prop_A_Q(ntry, wf16(:,99), 27, MB, 1_intkind1, wf16(:,100), n2(101))
  call vert_UV_W(ntry, wf8(:,24), 19, ex6(:), 32, wf16(:,101), n3(:,195), t3x16(:,:,61))
  call vert_QA_V(ntry, ex1(:), wf8(:,92), wf16(:,102), n3(:,196), t3x16(:,:,62))
  call vert_VQ_A(ntry, wf8(:,8), ex1(:), wf16(:,103), n3(:,197), t3x16(:,:,63))
  call prop_Q_A(ntry, wf16(:,103), 29, MT, 1_intkind1, wf16(:,104), n2(102))
  call vert_AV_Q(ntry, ex2(:), wf8(:,8), wf16(:,105), n3(:,198), t3x16(:,:,64))
  call prop_A_Q(ntry, wf16(:,105), 30, MT, 1_intkind1, wf16(:,106), n2(103))
  call vert_UV_W(ntry, wf8(:,8), 28, ex6(:), 32, wf16(:,107), n3(:,199), t3x16(:,:,65))
  call vert_QA_V(ntry, wf8(:,48), ex4(:), wf16(:,108), n3(:,200), t3x16(:,:,66))
  call vert_VQ_A(ntry, wf8(:,12), ex1(:), wf16(:,109), n3(:,201), t3x16(:,:,67))
  call prop_Q_A(ntry, wf16(:,109), 29, MT, 1_intkind1, wf16(:,110), n2(104))
  call vert_AV_Q(ntry, ex2(:), wf8(:,12), wf16(:,111), n3(:,202), t3x16(:,:,68))
  call prop_A_Q(ntry, wf16(:,111), 30, MT, 1_intkind1, wf16(:,112), n2(105))
  call vert_UV_W(ntry, wf8(:,12), 28, ex6(:), 32, wf16(:,113), n3(:,203), t3x16(:,:,69))
  call vert_QA_V(ntry, ex3(:), wf8(:,58), wf16(:,114), n3(:,204), t3x16(:,:,70))
  call vert_VQ_A(ntry, wf8(:,28), ex3(:), wf16(:,115), n3(:,205), t3x16(:,:,71))
  call prop_Q_A(ntry, wf16(:,115), 39, MB, 1_intkind1, wf16(:,116), n2(106))
  call vert_AV_Q(ntry, ex4(:), wf8(:,28), wf16(:,117), n3(:,206), t3x16(:,:,72))
  call prop_A_Q(ntry, wf16(:,117), 43, MB, 1_intkind1, wf16(:,118), n2(107))
  call vert_UV_W(ntry, ex5(:), 16, wf8(:,28), 35, wf16(:,119), n3(:,207), t3x16(:,:,73))
  call vert_QA_V(ntry, wf8(:,83), ex2(:), wf16(:,120), n3(:,208), t3x16(:,:,74))
  call vert_VQ_A(ntry, wf8(:,30), ex3(:), wf16(:,121), n3(:,209), t3x16(:,:,75))
  call prop_Q_A(ntry, wf16(:,121), 39, MB, 1_intkind1, wf16(:,122), n2(108))
  call vert_AV_Q(ntry, ex4(:), wf8(:,30), wf16(:,123), n3(:,210), t3x16(:,:,76))
  call prop_A_Q(ntry, wf16(:,123), 43, MB, 1_intkind1, wf16(:,124), n2(109))
  call vert_UV_W(ntry, ex5(:), 16, wf8(:,30), 35, wf16(:,125), n3(:,211), t3x16(:,:,77))
  call vert_QA_V(ntry, ex1(:), wf8(:,94), wf16(:,126), n3(:,212), t3x16(:,:,78))
  call vert_VQ_A(ntry, wf8(:,14), ex1(:), wf16(:,127), n3(:,213), t3x16(:,:,79))
  call prop_Q_A(ntry, wf16(:,127), 45, MT, 1_intkind1, wf16(:,128), n2(110))
  call vert_AV_Q(ntry, ex2(:), wf8(:,14), wf16(:,129), n3(:,214), t3x16(:,:,80))
  call prop_A_Q(ntry, wf16(:,129), 46, MT, 1_intkind1, wf16(:,130), n2(111))
  call vert_UV_W(ntry, ex5(:), 16, wf8(:,14), 44, wf16(:,131), n3(:,215), t3x16(:,:,81))
  call vert_QA_V(ntry, wf8(:,50), ex4(:), wf16(:,132), n3(:,216), t3x16(:,:,82))
  call vert_VQ_A(ntry, wf8(:,16), ex1(:), wf16(:,133), n3(:,217), t3x16(:,:,83))
  call prop_Q_A(ntry, wf16(:,133), 45, MT, 1_intkind1, wf16(:,134), n2(112))
  call vert_AV_Q(ntry, ex2(:), wf8(:,16), wf16(:,135), n3(:,218), t3x16(:,:,84))
  call prop_A_Q(ntry, wf16(:,135), 46, MT, 1_intkind1, wf16(:,136), n2(113))
  call vert_UV_W(ntry, ex5(:), 16, wf8(:,16), 44, wf16(:,137), n3(:,219), t3x16(:,:,85))
  call vert_QA_V(ntry, ex3(:), wf8(:,60), wf16(:,138), n3(:,220), t3x16(:,:,86))
  call vert_QA_V(ntry, wf8(:,34), ex2(:), wf16(:,139), n3(:,221), t3x16(:,:,87))
  call vert_QA_V(ntry, ex1(:), wf8(:,95), wf16(:,140), n3(:,222), t3x16(:,:,88))
  call vert_QA_V(ntry, wf8(:,19), ex4(:), wf16(:,141), n3(:,223), t3x16(:,:,89))
  call vert_QA_V(ntry, ex3(:), wf8(:,62), wf16(:,142), n3(:,224), t3x16(:,:,90))


  call init_hybrid_exwf(ex1)
  call init_hybrid_exwf(ex2)
  call init_hybrid_exwf(ex3)
  call init_hybrid_exwf(ex4)
  call init_hybrid_exwf(ex5)
  call init_hybrid_exwf(ex6)
  call init_hybrid_wf(wf4)
  call init_hybrid_wf(wf8)
  call init_hybrid_wf(wf16)


  if (ntry==1) then
    call physical_helicities()
  end if

  ! computation of the colour-stripped amplitudes
  do nsync = ntry+ntry-1, ntry+1  !  nsync = 1,2  for 1st point and nsync = 3 later
    call diagrams()
    if (nsync == 1) call helsync(nsync, A, nhel, Hel)
  end do

  ! In the following loop the coefficients \Gamma_{i} of the expansion in
  ! the colour basis are computed for every helicity state and stored in M1helarray.
  ! Also the colour vector for the Born-loop interference is computed and saved in
  ! M0_col1_helarray
  do k = 1, nhel
    call colourvectors(A, k, M1helarray(:,k),M1helarray_ct(:,k))
    call colborninterf(M1helarray(:,k), M0_col1_helarray(:,k))
  end do
  M1helarray(:,nhel+1:)%j = 0
  M0_col1_helarray(:,nhel+1:)%hf = -1_intkind2
  M0_col1_helarray(:,nhel+1:)%j = 0

  M2add = 0
  M2add_ct = 0
  M2add_colint = 0

  M02 = 0
  M2ct = 0
  M2colint = 0
  
    do k = 1, nhel
      call colint(M1helarray(:,k)%j, M2add)
      call colint_ct(M1helarray(:,k)%j, M1helarray_ct(:,k)%j, M2add_ct)
      if (IR_is_on > 0) then
	call colint_IR(M1helarray(:,k)%j, M2add_colint)
      end if
      !summation over helicity configurations
      M02 = M02 + M2add
      M2ct = M2ct + M2add_ct
      M2colint = M2colint + M2add_colint
    end do



  contains

subroutine physical_helicities()
  implicit none 

integer :: i1,i2,i3,i4,i5,i6
integer :: n

n=0

do i6= 1, 2
do i5= 1, 2
do i4= 1, 2
do i3= 1, 2
do i2= 1, 2
do i1= 1, 2
n = n + 1
 if((ex1(i1)%hf==-1_intkind2) .OR. (ex2(i2)%hf==-1_intkind2) .OR. (ex3(i3)%hf==-1_intkind2) .OR. (ex4(i4)%hf==-1_intkind2)  &
    .OR. (ex5(i5)%hf==-1_intkind2) .OR. (ex6(i6)%hf==-1_intkind2)) then
  Hel(n) = -1_intkind2
 else
  Hel(n) = ex1(i1)%hf + ex2(i2)%hf + ex3(i3)%hf + ex4(i4)%hf + ex5(i5)%hf + ex6(i6)%hf
 end if
end do
end do
end do
end do
end do
end do

end subroutine physical_helicities

subroutine diagrams()
  implicit none
  integer :: h
  ! e.g. call cont_VV(nsync, wf3, wf6, A(:,1), n64, t64, nhel, den(5)) ...

    call Hcont_VV(nsync, wf4(:,2), wf16(:,1), A(:,1), n3(:,225), t3x64(:,:,1), nhel, den(3))
    call Hcont_VV(nsync, wf4(:,2), wf16(:,2), A(:,2), n3(:,226), t3x64(:,:,2), nhel, den(3))
    call Hcont_VV(nsync, wf4(:,2), wf16(:,3), A(:,3), n3(:,227), t3x64(:,:,3), nhel, den(3))
    call Hcont_VV(nsync, wf4(:,3), wf16(:,4), A(:,4), n3(:,228), t3x64(:,:,4), nhel, den(5))
    call Hcont_VV(nsync, wf8(:,1), wf8(:,2), A(:,5), n3(:,229), t3x64(:,:,5), nhel, den(8))
    call Hcont_VV(nsync, wf8(:,3), wf8(:,4), A(:,6), n3(:,230), t3x64(:,:,6), nhel, den(11))
    call Hcont_QA(nsync, wf4(:,7), wf16(:,5), A(:,7), n3(:,231), t3x64(:,:,7), nhel, den(15))
    call Hcont_QA(nsync, wf8(:,6), wf8(:,7), A(:,8), n3(:,232), t3x64(:,:,8), nhel, den(18))
    call Hcont_VV(nsync, wf8(:,4), wf8(:,8), A(:,9), n3(:,233), t3x64(:,:,9), nhel, den(20))
    call Hcont_QA(nsync, wf4(:,11), wf16(:,6), A(:,10), n3(:,234), t3x64(:,:,10), nhel, den(24))
    call Hcont_QA(nsync, wf8(:,10), wf8(:,11), A(:,11), n3(:,235), t3x64(:,:,11), nhel, den(27))
    call Hcont_VV(nsync, wf8(:,4), wf8(:,12), A(:,12), n3(:,236), t3x64(:,:,12), nhel, den(29))
    call Hcont_QA(nsync, wf8(:,7), wf8(:,13), A(:,13), n3(:,237), t3x64(:,:,13), nhel, den(30))
    call Hcont_VV(nsync, wf8(:,1), wf8(:,14), A(:,14), n3(:,238), t3x64(:,:,14), nhel, den(33))
    call Hcont_QA(nsync, wf8(:,11), wf8(:,15), A(:,15), n3(:,239), t3x64(:,:,15), nhel, den(34))
    call Hcont_VV(nsync, wf8(:,1), wf8(:,16), A(:,16), n3(:,240), t3x64(:,:,16), nhel, den(36))
    call Hcont_QA(nsync, wf8(:,11), wf8(:,17), A(:,17), n3(:,241), t3x64(:,:,17), nhel, den(37))
    call Hcont_QA(nsync, wf8(:,5), wf8(:,19), A(:,18), n3(:,242), t3x64(:,:,18), nhel, den(40))
    call Hcont_VV(nsync, wf4(:,2), wf16(:,7), A(:,19), n3(:,243), t3x64(:,:,19), nhel, den(44))
    call Hcont_VV(nsync, wf8(:,2), wf8(:,20), A(:,20), n3(:,244), t3x64(:,:,20), nhel, den(46))
    call Hcont_QA(nsync, wf8(:,22), wf8(:,23), A(:,21), n3(:,245), t3x64(:,:,21), nhel, den(49))
    call Hcont_VV(nsync, wf4(:,2), wf16(:,8), A(:,22), n3(:,246), t3x64(:,:,22), nhel, den(53))
    call Hcont_VV(nsync, wf8(:,2), wf8(:,24), A(:,23), n3(:,247), t3x64(:,:,23), nhel, den(55))
    call Hcont_QA(nsync, wf8(:,26), wf8(:,27), A(:,24), n3(:,248), t3x64(:,:,24), nhel, den(58))
    call Hcont_VV(nsync, wf8(:,3), wf8(:,28), A(:,25), n3(:,249), t3x64(:,:,25), nhel, den(61))
    call Hcont_QA(nsync, wf8(:,23), wf8(:,29), A(:,26), n3(:,250), t3x64(:,:,26), nhel, den(62))
    call Hcont_VV(nsync, wf8(:,3), wf8(:,30), A(:,27), n3(:,251), t3x64(:,:,27), nhel, den(64))
    call Hcont_QA(nsync, wf8(:,27), wf8(:,31), A(:,28), n3(:,252), t3x64(:,:,28), nhel, den(65))
    call Hcont_QA(nsync, wf8(:,27), wf8(:,32), A(:,29), n3(:,253), t3x64(:,:,29), nhel, den(66))
    call Hcont_QA(nsync, wf8(:,21), wf8(:,34), A(:,30), n3(:,254), t3x64(:,:,30), nhel, den(69))
    call Hcont_VV(nsync, wf8(:,14), wf8(:,20), A(:,31), n3(:,255), t3x64(:,:,31), nhel, den(70))
    call Hcont_VV(nsync, wf8(:,16), wf8(:,20), A(:,32), n3(:,256), t3x64(:,:,32), nhel, den(71))
    call Hcont_VV(nsync, wf8(:,14), wf8(:,24), A(:,33), n3(:,257), t3x64(:,:,33), nhel, den(72))
    call Hcont_VV(nsync, wf8(:,16), wf8(:,24), A(:,34), n3(:,258), t3x64(:,:,34), nhel, den(73))
    call Hcont_VV(nsync, wf8(:,8), wf8(:,28), A(:,35), n3(:,259), t3x64(:,:,35), nhel, den(74))
    call Hcont_VV(nsync, wf8(:,8), wf8(:,30), A(:,36), n3(:,260), t3x64(:,:,36), nhel, den(75))
    call Hcont_VV(nsync, wf8(:,12), wf8(:,28), A(:,37), n3(:,261), t3x64(:,:,37), nhel, den(76))
    call Hcont_VV(nsync, wf8(:,12), wf8(:,30), A(:,38), n3(:,262), t3x64(:,:,38), nhel, den(77))

    call Hcont_VV(nsync, wf4(:,2), wf16(:,9), A(:,39), n3(:,263), t3x64(:,:,39), nhel, den(3))
    call Hcont_VV(nsync, wf4(:,2), wf16(:,10), A(:,40), n3(:,264), t3x64(:,:,40), nhel, den(3))
    call Hcont_VV(nsync, wf4(:,2), wf16(:,11), A(:,41), n3(:,265), t3x64(:,:,41), nhel, den(3))
    call Hcont_VV(nsync, wf4(:,2), wf16(:,9), A(:,42), n3(:,266), t3x64(:,:,42), nhel, den(3))
    call Hcont_VV(nsync, wf4(:,2), wf16(:,10), A(:,43), n3(:,267), t3x64(:,:,43), nhel, den(3))
    call Hcont_VV(nsync, wf4(:,2), wf16(:,11), A(:,44), n3(:,268), t3x64(:,:,44), nhel, den(3))
    call Hcont_VV(nsync, wf16(:,1), wf4(:,20), A(:,45), n3(:,269), t3x64(:,:,45), nhel, den(3))
    call Hcont_VV(nsync, wf16(:,2), wf4(:,20), A(:,46), n3(:,270), t3x64(:,:,46), nhel, den(3))
    call Hcont_VV(nsync, wf16(:,3), wf4(:,20), A(:,47), n3(:,271), t3x64(:,:,47), nhel, den(3))
    call Hcont_VV(nsync, wf4(:,2), wf16(:,12), A(:,48), n3(:,272), t3x64(:,:,48), nhel, den(3))
    call Hcont_VV(nsync, wf4(:,2), wf16(:,13), A(:,49), n3(:,273), t3x64(:,:,49), nhel, den(3))
    call Hcont_VV(nsync, wf4(:,2), wf16(:,14), A(:,50), n3(:,274), t3x64(:,:,50), nhel, den(3))
    call Hcont_VV(nsync, wf4(:,3), wf16(:,15), A(:,51), n3(:,275), t3x64(:,:,51), nhel, den(5))
    call Hcont_VV(nsync, wf8(:,1), wf8(:,35), A(:,52), n3(:,276), t3x64(:,:,52), nhel, den(8))
    call Hcont_VV(nsync, wf8(:,3), wf8(:,36), A(:,53), n3(:,277), t3x64(:,:,53), nhel, den(11))
    call Hcont_VV(nsync, wf16(:,16), wf4(:,22), A(:,54), n3(:,278), t3x64(:,:,54), nhel, den(80))
    call Hcont_VV(nsync, wf4(:,22), wf16(:,17), A(:,55), n3(:,279), t3x64(:,:,55), nhel, den(80))
    call Hcont_VV(nsync, wf4(:,22), wf16(:,18), A(:,56), n3(:,280), t3x64(:,:,56), nhel, den(80))
    call Hcont_VV(nsync, wf16(:,1), wf4(:,23), A(:,57), n3(:,281), t3x64(:,:,57), nhel, den(83))
    call Hcont_VV(nsync, wf16(:,2), wf4(:,23), A(:,58), n3(:,282), t3x64(:,:,58), nhel, den(83))
    call Hcont_VV(nsync, wf16(:,3), wf4(:,23), A(:,59), n3(:,283), t3x64(:,:,59), nhel, den(83))
    call Hcont_VV(nsync, wf8(:,4), wf8(:,37), A(:,60), n3(:,284), t3x64(:,:,60), nhel, den(85))
    call Hcont_VV(nsync, wf8(:,2), wf8(:,38), A(:,61), n3(:,285), t3x64(:,:,61), nhel, den(87))
    call Hcont_VV(nsync, wf16(:,4), wf4(:,24), A(:,62), n3(:,286), t3x64(:,:,62), nhel, den(5))
    call Hcont_QA(nsync, wf4(:,7), wf16(:,19), A(:,63), n3(:,287), t3x64(:,:,63), nhel, den(15))
    call Hcont_QA(nsync, wf8(:,7), wf8(:,39), A(:,64), n3(:,288), t3x64(:,:,64), nhel, den(18))
    call Hcont_VV(nsync, wf8(:,8), wf8(:,36), A(:,65), n3(:,289), t3x64(:,:,65), nhel, den(20))
    call Hcont_QA(nsync, wf4(:,11), wf16(:,20), A(:,66), n3(:,290), t3x64(:,:,66), nhel, den(24))
    call Hcont_QA(nsync, wf8(:,11), wf8(:,40), A(:,67), n3(:,291), t3x64(:,:,67), nhel, den(27))
    call Hcont_VV(nsync, wf8(:,12), wf8(:,36), A(:,68), n3(:,292), t3x64(:,:,68), nhel, den(29))
    call Hcont_QA(nsync, wf8(:,7), wf8(:,41), A(:,69), n3(:,293), t3x64(:,:,69), nhel, den(30))
    call Hcont_VV(nsync, wf8(:,14), wf8(:,38), A(:,70), n3(:,294), t3x64(:,:,70), nhel, den(33))
    call Hcont_QA(nsync, wf8(:,11), wf8(:,42), A(:,71), n3(:,295), t3x64(:,:,71), nhel, den(34))
    call Hcont_VV(nsync, wf8(:,16), wf8(:,38), A(:,72), n3(:,296), t3x64(:,:,72), nhel, den(36))
    call Hcont_QA(nsync, wf8(:,11), wf8(:,43), A(:,73), n3(:,297), t3x64(:,:,73), nhel, den(37))
    call Hcont_QA(nsync, wf8(:,5), wf8(:,45), A(:,74), n3(:,298), t3x64(:,:,74), nhel, den(40))
    call Hcont_VV(nsync, wf8(:,4), wf8(:,46), A(:,75), n3(:,299), t3x64(:,:,75), nhel, den(88))
    call Hcont_QA(nsync, wf8(:,47), wf8(:,48), A(:,76), n3(:,300), t3x64(:,:,76), nhel, den(90))
    call Hcont_QA(nsync, wf16(:,5), wf4(:,26), A(:,77), n3(:,301), t3x64(:,:,77), nhel, den(15))
    call Hcont_VV(nsync, wf8(:,1), wf8(:,49), A(:,78), n3(:,302), t3x64(:,:,78), nhel, den(91))
    call Hcont_QA(nsync, wf8(:,47), wf8(:,50), A(:,79), n3(:,303), t3x64(:,:,79), nhel, den(93))
    call Hcont_QA(nsync, wf8(:,11), wf8(:,51), A(:,80), n3(:,304), t3x64(:,:,80), nhel, den(37))
    call Hcont_QA(nsync, wf8(:,19), wf8(:,47), A(:,81), n3(:,305), t3x64(:,:,81), nhel, den(40))
    call Hcont_QA(nsync, wf8(:,11), wf8(:,52), A(:,82), n3(:,306), t3x64(:,:,82), nhel, den(34))
    call Hcont_VV(nsync, wf8(:,1), wf8(:,53), A(:,83), n3(:,307), t3x64(:,:,83), nhel, den(36))
    call Hcont_QA(nsync, wf16(:,6), wf4(:,28), A(:,84), n3(:,308), t3x64(:,:,84), nhel, den(24))
    call Hcont_QA(nsync, wf8(:,11), wf8(:,54), A(:,85), n3(:,309), t3x64(:,:,85), nhel, den(27))
    call Hcont_VV(nsync, wf8(:,4), wf8(:,55), A(:,86), n3(:,310), t3x64(:,:,86), nhel, den(29))
    call Hcont_VV(nsync, wf8(:,4), wf8(:,56), A(:,87), n3(:,311), t3x64(:,:,87), nhel, den(94))
    call Hcont_QA(nsync, wf8(:,57), wf8(:,58), A(:,88), n3(:,312), t3x64(:,:,88), nhel, den(97))
    call Hcont_QA(nsync, wf4(:,11), wf16(:,21), A(:,89), n3(:,313), t3x64(:,:,89), nhel, den(24))
    call Hcont_VV(nsync, wf8(:,1), wf8(:,59), A(:,90), n3(:,314), t3x64(:,:,90), nhel, den(98))
    call Hcont_QA(nsync, wf8(:,57), wf8(:,60), A(:,91), n3(:,315), t3x64(:,:,91), nhel, den(100))
    call Hcont_QA(nsync, wf8(:,7), wf8(:,61), A(:,92), n3(:,316), t3x64(:,:,92), nhel, den(101))
    call Hcont_QA(nsync, wf8(:,57), wf8(:,62), A(:,93), n3(:,317), t3x64(:,:,93), nhel, den(103))
    call Hcont_QA(nsync, wf8(:,7), wf8(:,63), A(:,94), n3(:,318), t3x64(:,:,94), nhel, den(30))
    call Hcont_VV(nsync, wf8(:,1), wf8(:,64), A(:,95), n3(:,319), t3x64(:,:,95), nhel, den(33))
    call Hcont_QA(nsync, wf4(:,7), wf16(:,22), A(:,96), n3(:,320), t3x64(:,:,96), nhel, den(15))
    call Hcont_QA(nsync, wf8(:,7), wf8(:,65), A(:,97), n3(:,321), t3x64(:,:,97), nhel, den(18))
    call Hcont_VV(nsync, wf8(:,4), wf8(:,66), A(:,98), n3(:,322), t3x64(:,:,98), nhel, den(20))
    call Hcont_VV(nsync, wf4(:,3), wf16(:,23), A(:,99), n3(:,323), t3x64(:,:,99), nhel, den(5))
    call Hcont_VV(nsync, wf8(:,1), wf8(:,67), A(:,100), n3(:,324), t3x64(:,:,100), nhel, den(8))
    call Hcont_VV(nsync, wf8(:,4), wf8(:,68), A(:,101), n3(:,325), t3x64(:,:,101), nhel, den(11))
    call Hcont_VV(nsync, wf4(:,2), wf16(:,24), A(:,102), n3(:,326), t3x64(:,:,102), nhel, den(44))
    call Hcont_VV(nsync, wf8(:,20), wf8(:,35), A(:,103), n3(:,327), t3x64(:,:,103), nhel, den(46))
    call Hcont_QA(nsync, wf8(:,23), wf8(:,69), A(:,104), n3(:,328), t3x64(:,:,104), nhel, den(49))
    call Hcont_VV(nsync, wf4(:,2), wf16(:,25), A(:,105), n3(:,329), t3x64(:,:,105), nhel, den(53))
    call Hcont_VV(nsync, wf8(:,24), wf8(:,35), A(:,106), n3(:,330), t3x64(:,:,106), nhel, den(55))
    call Hcont_QA(nsync, wf8(:,27), wf8(:,70), A(:,107), n3(:,331), t3x64(:,:,107), nhel, den(58))
    call Hcont_VV(nsync, wf8(:,28), wf8(:,37), A(:,108), n3(:,332), t3x64(:,:,108), nhel, den(61))
    call Hcont_QA(nsync, wf8(:,23), wf8(:,71), A(:,109), n3(:,333), t3x64(:,:,109), nhel, den(62))
    call Hcont_VV(nsync, wf8(:,30), wf8(:,37), A(:,110), n3(:,334), t3x64(:,:,110), nhel, den(64))
    call Hcont_QA(nsync, wf8(:,27), wf8(:,72), A(:,111), n3(:,335), t3x64(:,:,111), nhel, den(65))
    call Hcont_QA(nsync, wf8(:,27), wf8(:,73), A(:,112), n3(:,336), t3x64(:,:,112), nhel, den(66))
    call Hcont_QA(nsync, wf8(:,21), wf8(:,75), A(:,113), n3(:,337), t3x64(:,:,113), nhel, den(69))
    call Hcont_VV(nsync, wf8(:,20), wf8(:,49), A(:,114), n3(:,338), t3x64(:,:,114), nhel, den(70))
    call Hcont_VV(nsync, wf8(:,20), wf8(:,53), A(:,115), n3(:,339), t3x64(:,:,115), nhel, den(71))
    call Hcont_VV(nsync, wf8(:,24), wf8(:,49), A(:,116), n3(:,340), t3x64(:,:,116), nhel, den(72))
    call Hcont_VV(nsync, wf8(:,24), wf8(:,53), A(:,117), n3(:,341), t3x64(:,:,117), nhel, den(73))
    call Hcont_VV(nsync, wf8(:,28), wf8(:,46), A(:,118), n3(:,342), t3x64(:,:,118), nhel, den(74))
    call Hcont_VV(nsync, wf8(:,30), wf8(:,46), A(:,119), n3(:,343), t3x64(:,:,119), nhel, den(75))
    call Hcont_VV(nsync, wf8(:,28), wf8(:,55), A(:,120), n3(:,344), t3x64(:,:,120), nhel, den(76))
    call Hcont_VV(nsync, wf8(:,30), wf8(:,55), A(:,121), n3(:,345), t3x64(:,:,121), nhel, den(77))
    call Hcont_VV(nsync, wf8(:,20), wf8(:,59), A(:,122), n3(:,346), t3x64(:,:,122), nhel, den(71))
    call Hcont_VV(nsync, wf8(:,20), wf8(:,64), A(:,123), n3(:,347), t3x64(:,:,123), nhel, den(70))
    call Hcont_VV(nsync, wf8(:,24), wf8(:,59), A(:,124), n3(:,348), t3x64(:,:,124), nhel, den(73))
    call Hcont_VV(nsync, wf8(:,24), wf8(:,64), A(:,125), n3(:,349), t3x64(:,:,125), nhel, den(72))
    call Hcont_VV(nsync, wf8(:,28), wf8(:,56), A(:,126), n3(:,350), t3x64(:,:,126), nhel, den(76))
    call Hcont_VV(nsync, wf8(:,30), wf8(:,56), A(:,127), n3(:,351), t3x64(:,:,127), nhel, den(77))
    call Hcont_VV(nsync, wf8(:,28), wf8(:,66), A(:,128), n3(:,352), t3x64(:,:,128), nhel, den(74))
    call Hcont_VV(nsync, wf8(:,30), wf8(:,66), A(:,129), n3(:,353), t3x64(:,:,129), nhel, den(75))
    call Hcont_VV(nsync, wf16(:,7), wf4(:,20), A(:,130), n3(:,354), t3x64(:,:,130), nhel, den(44))
    call Hcont_VV(nsync, wf8(:,20), wf8(:,67), A(:,131), n3(:,355), t3x64(:,:,131), nhel, den(46))
    call Hcont_QA(nsync, wf8(:,22), wf8(:,77), A(:,132), n3(:,356), t3x64(:,:,132), nhel, den(49))
    call Hcont_VV(nsync, wf16(:,8), wf4(:,20), A(:,133), n3(:,357), t3x64(:,:,133), nhel, den(53))
    call Hcont_VV(nsync, wf8(:,24), wf8(:,67), A(:,134), n3(:,358), t3x64(:,:,134), nhel, den(55))
    call Hcont_QA(nsync, wf8(:,26), wf8(:,79), A(:,135), n3(:,359), t3x64(:,:,135), nhel, den(58))
    call Hcont_VV(nsync, wf8(:,28), wf8(:,68), A(:,136), n3(:,360), t3x64(:,:,136), nhel, den(61))
    call Hcont_QA(nsync, wf8(:,29), wf8(:,77), A(:,137), n3(:,361), t3x64(:,:,137), nhel, den(62))
    call Hcont_VV(nsync, wf8(:,30), wf8(:,68), A(:,138), n3(:,362), t3x64(:,:,138), nhel, den(64))
    call Hcont_QA(nsync, wf8(:,31), wf8(:,79), A(:,139), n3(:,363), t3x64(:,:,139), nhel, den(65))
    call Hcont_QA(nsync, wf8(:,34), wf8(:,76), A(:,140), n3(:,364), t3x64(:,:,140), nhel, den(69))
    call Hcont_QA(nsync, wf8(:,32), wf8(:,79), A(:,141), n3(:,365), t3x64(:,:,141), nhel, den(66))
    call Hcont_QA(nsync, wf8(:,80), wf8(:,81), A(:,142), n3(:,366), t3x64(:,:,142), nhel, den(105))
    call Hcont_VV(nsync, wf8(:,2), wf8(:,82), A(:,143), n3(:,367), t3x64(:,:,143), nhel, den(106))
    call Hcont_VV(nsync, wf4(:,2), wf16(:,26), A(:,144), n3(:,368), t3x64(:,:,144), nhel, den(44))
    call Hcont_QA(nsync, wf8(:,80), wf8(:,83), A(:,145), n3(:,369), t3x64(:,:,145), nhel, den(108))
    call Hcont_VV(nsync, wf8(:,3), wf8(:,84), A(:,146), n3(:,370), t3x64(:,:,146), nhel, den(109))
    call Hcont_QA(nsync, wf8(:,27), wf8(:,85), A(:,147), n3(:,371), t3x64(:,:,147), nhel, den(66))
    call Hcont_QA(nsync, wf8(:,34), wf8(:,80), A(:,148), n3(:,372), t3x64(:,:,148), nhel, den(69))
    call Hcont_QA(nsync, wf8(:,27), wf8(:,86), A(:,149), n3(:,373), t3x64(:,:,149), nhel, den(65))
    call Hcont_VV(nsync, wf8(:,3), wf8(:,87), A(:,150), n3(:,374), t3x64(:,:,150), nhel, den(64))
    call Hcont_VV(nsync, wf4(:,2), wf16(:,27), A(:,151), n3(:,375), t3x64(:,:,151), nhel, den(53))
    call Hcont_QA(nsync, wf8(:,27), wf8(:,88), A(:,152), n3(:,376), t3x64(:,:,152), nhel, den(58))
    call Hcont_VV(nsync, wf8(:,2), wf8(:,89), A(:,153), n3(:,377), t3x64(:,:,153), nhel, den(55))
    call Hcont_VV(nsync, wf8(:,14), wf8(:,82), A(:,154), n3(:,378), t3x64(:,:,154), nhel, den(110))
    call Hcont_VV(nsync, wf8(:,16), wf8(:,82), A(:,155), n3(:,379), t3x64(:,:,155), nhel, den(111))
    call Hcont_VV(nsync, wf8(:,8), wf8(:,84), A(:,156), n3(:,380), t3x64(:,:,156), nhel, den(112))
    call Hcont_VV(nsync, wf8(:,8), wf8(:,87), A(:,157), n3(:,381), t3x64(:,:,157), nhel, den(75))
    call Hcont_VV(nsync, wf8(:,12), wf8(:,84), A(:,158), n3(:,382), t3x64(:,:,158), nhel, den(113))
    call Hcont_VV(nsync, wf8(:,12), wf8(:,87), A(:,159), n3(:,383), t3x64(:,:,159), nhel, den(77))
    call Hcont_VV(nsync, wf8(:,14), wf8(:,89), A(:,160), n3(:,384), t3x64(:,:,160), nhel, den(72))
    call Hcont_VV(nsync, wf8(:,16), wf8(:,89), A(:,161), n3(:,385), t3x64(:,:,161), nhel, den(73))
    call Hcont_VV(nsync, wf8(:,2), wf8(:,90), A(:,162), n3(:,386), t3x64(:,:,162), nhel, den(114))
    call Hcont_QA(nsync, wf8(:,91), wf8(:,92), A(:,163), n3(:,387), t3x64(:,:,163), nhel, den(117))
    call Hcont_VV(nsync, wf4(:,2), wf16(:,28), A(:,164), n3(:,388), t3x64(:,:,164), nhel, den(53))
    call Hcont_VV(nsync, wf8(:,3), wf8(:,93), A(:,165), n3(:,389), t3x64(:,:,165), nhel, den(118))
    call Hcont_QA(nsync, wf8(:,91), wf8(:,94), A(:,166), n3(:,390), t3x64(:,:,166), nhel, den(120))
    call Hcont_QA(nsync, wf8(:,91), wf8(:,95), A(:,167), n3(:,391), t3x64(:,:,167), nhel, den(122))
    call Hcont_QA(nsync, wf8(:,23), wf8(:,96), A(:,168), n3(:,392), t3x64(:,:,168), nhel, den(123))
    call Hcont_VV(nsync, wf8(:,3), wf8(:,97), A(:,169), n3(:,393), t3x64(:,:,169), nhel, den(61))
    call Hcont_QA(nsync, wf8(:,23), wf8(:,98), A(:,170), n3(:,394), t3x64(:,:,170), nhel, den(62))
    call Hcont_VV(nsync, wf4(:,2), wf16(:,29), A(:,171), n3(:,395), t3x64(:,:,171), nhel, den(44))
    call Hcont_VV(nsync, wf8(:,2), wf8(:,99), A(:,172), n3(:,396), t3x64(:,:,172), nhel, den(46))
    call Hcont_QA(nsync, wf8(:,23), wf8(:,100), A(:,173), n3(:,397), t3x64(:,:,173), nhel, den(49))
    call Hcont_VV(nsync, wf8(:,14), wf8(:,90), A(:,174), n3(:,398), t3x64(:,:,174), nhel, den(124))
    call Hcont_VV(nsync, wf8(:,16), wf8(:,90), A(:,175), n3(:,399), t3x64(:,:,175), nhel, den(125))
    call Hcont_VV(nsync, wf8(:,8), wf8(:,93), A(:,176), n3(:,400), t3x64(:,:,176), nhel, den(126))
    call Hcont_VV(nsync, wf8(:,8), wf8(:,97), A(:,177), n3(:,401), t3x64(:,:,177), nhel, den(74))
    call Hcont_VV(nsync, wf8(:,12), wf8(:,93), A(:,178), n3(:,402), t3x64(:,:,178), nhel, den(127))
    call Hcont_VV(nsync, wf8(:,12), wf8(:,97), A(:,179), n3(:,403), t3x64(:,:,179), nhel, den(76))
    call Hcont_VV(nsync, wf8(:,14), wf8(:,99), A(:,180), n3(:,404), t3x64(:,:,180), nhel, den(70))
    call Hcont_VV(nsync, wf8(:,16), wf8(:,99), A(:,181), n3(:,405), t3x64(:,:,181), nhel, den(71))
    call Hcont_VV(nsync, wf4(:,3), wf16(:,30), A(:,182), n3(:,406), t3x64(:,:,182), nhel, den(5))
    call Hcont_VV(nsync, wf8(:,2), wf8(:,101), A(:,183), n3(:,407), t3x64(:,:,183), nhel, den(8))
    call Hcont_VV(nsync, wf8(:,3), wf8(:,102), A(:,184), n3(:,408), t3x64(:,:,184), nhel, den(11))
    call Hcont_QA(nsync, wf4(:,7), wf16(:,31), A(:,185), n3(:,409), t3x64(:,:,185), nhel, den(15))
    call Hcont_QA(nsync, wf8(:,6), wf8(:,104), A(:,186), n3(:,410), t3x64(:,:,186), nhel, den(18))
    call Hcont_VV(nsync, wf8(:,8), wf8(:,102), A(:,187), n3(:,411), t3x64(:,:,187), nhel, den(20))
    call Hcont_QA(nsync, wf4(:,11), wf16(:,32), A(:,188), n3(:,412), t3x64(:,:,188), nhel, den(24))
    call Hcont_QA(nsync, wf8(:,10), wf8(:,106), A(:,189), n3(:,413), t3x64(:,:,189), nhel, den(27))
    call Hcont_VV(nsync, wf8(:,12), wf8(:,102), A(:,190), n3(:,414), t3x64(:,:,190), nhel, den(29))
    call Hcont_QA(nsync, wf8(:,13), wf8(:,104), A(:,191), n3(:,415), t3x64(:,:,191), nhel, den(30))
    call Hcont_VV(nsync, wf8(:,14), wf8(:,101), A(:,192), n3(:,416), t3x64(:,:,192), nhel, den(33))
    call Hcont_QA(nsync, wf8(:,15), wf8(:,106), A(:,193), n3(:,417), t3x64(:,:,193), nhel, den(34))
    call Hcont_VV(nsync, wf8(:,16), wf8(:,101), A(:,194), n3(:,418), t3x64(:,:,194), nhel, den(36))
    call Hcont_QA(nsync, wf8(:,17), wf8(:,106), A(:,195), n3(:,419), t3x64(:,:,195), nhel, den(37))
    call Hcont_QA(nsync, wf8(:,19), wf8(:,103), A(:,196), n3(:,420), t3x64(:,:,196), nhel, den(40))
    call Hcont_VV(nsync, wf4(:,22), wf16(:,33), A(:,197), n3(:,421), t3x64(:,:,197), nhel, den(130))
    call Hcont_VV(nsync, wf4(:,23), wf16(:,34), A(:,198), n3(:,422), t3x64(:,:,198), nhel, den(133))
    call Hcont_VV(nsync, wf16(:,4), wf4(:,41), A(:,199), n3(:,423), t3x64(:,:,199), nhel, den(136))
    call Hcont_VV(nsync, wf8(:,2), wf8(:,107), A(:,200), n3(:,424), t3x64(:,:,200), nhel, den(138))
    call Hcont_VV(nsync, wf8(:,3), wf8(:,108), A(:,201), n3(:,425), t3x64(:,:,201), nhel, den(139))
    call Hcont_VV(nsync, wf8(:,4), wf8(:,109), A(:,202), n3(:,426), t3x64(:,:,202), nhel, den(141))
    call Hcont_VV(nsync, wf8(:,1), wf8(:,110), A(:,203), n3(:,427), t3x64(:,:,203), nhel, den(142))
    call Hcont_VV(nsync, wf8(:,2), wf8(:,111), A(:,204), n3(:,428), t3x64(:,:,204), nhel, den(143))
    call Hcont_VV(nsync, wf8(:,4), wf8(:,112), A(:,205), n3(:,429), t3x64(:,:,205), nhel, den(144))
    call Hcont_VV(nsync, wf4(:,22), wf16(:,35), A(:,206), n3(:,430), t3x64(:,:,206), nhel, den(147))
    call Hcont_QA(nsync, wf4(:,42), wf16(:,37), A(:,207), n3(:,431), t3x64(:,:,207), nhel, den(151))
    call Hcont_QA(nsync, wf4(:,43), wf16(:,38), A(:,208), n3(:,432), t3x64(:,:,208), nhel, den(154))
    call Hcont_QA(nsync, wf8(:,48), wf8(:,113), A(:,209), n3(:,433), t3x64(:,:,209), nhel, den(155))
    call Hcont_VV(nsync, wf8(:,8), wf8(:,108), A(:,210), n3(:,434), t3x64(:,:,210), nhel, den(156))
    call Hcont_VV(nsync, wf8(:,4), wf8(:,114), A(:,211), n3(:,435), t3x64(:,:,211), nhel, den(158))
    call Hcont_QA(nsync, wf8(:,7), wf8(:,115), A(:,212), n3(:,436), t3x64(:,:,212), nhel, den(159))
    call Hcont_QA(nsync, wf8(:,48), wf8(:,116), A(:,213), n3(:,437), t3x64(:,:,213), nhel, den(160))
    call Hcont_VV(nsync, wf8(:,4), wf8(:,117), A(:,214), n3(:,438), t3x64(:,:,214), nhel, den(161))
    call Hcont_VV(nsync, wf4(:,22), wf16(:,39), A(:,215), n3(:,439), t3x64(:,:,215), nhel, den(164))
    call Hcont_QA(nsync, wf4(:,45), wf16(:,41), A(:,216), n3(:,440), t3x64(:,:,216), nhel, den(168))
    call Hcont_QA(nsync, wf4(:,46), wf16(:,42), A(:,217), n3(:,441), t3x64(:,:,217), nhel, den(171))
    call Hcont_QA(nsync, wf8(:,58), wf8(:,118), A(:,218), n3(:,442), t3x64(:,:,218), nhel, den(172))
    call Hcont_VV(nsync, wf8(:,12), wf8(:,108), A(:,219), n3(:,443), t3x64(:,:,219), nhel, den(173))
    call Hcont_VV(nsync, wf8(:,4), wf8(:,119), A(:,220), n3(:,444), t3x64(:,:,220), nhel, den(175))
    call Hcont_QA(nsync, wf8(:,58), wf8(:,120), A(:,221), n3(:,445), t3x64(:,:,221), nhel, den(176))
    call Hcont_VV(nsync, wf8(:,4), wf8(:,121), A(:,222), n3(:,446), t3x64(:,:,222), nhel, den(177))
    call Hcont_QA(nsync, wf8(:,11), wf8(:,122), A(:,223), n3(:,447), t3x64(:,:,223), nhel, den(178))
    call Hcont_QA(nsync, wf8(:,50), wf8(:,113), A(:,224), n3(:,448), t3x64(:,:,224), nhel, den(179))
    call Hcont_VV(nsync, wf8(:,14), wf8(:,107), A(:,225), n3(:,449), t3x64(:,:,225), nhel, den(180))
    call Hcont_VV(nsync, wf8(:,1), wf8(:,123), A(:,226), n3(:,450), t3x64(:,:,226), nhel, den(182))
    call Hcont_QA(nsync, wf8(:,7), wf8(:,124), A(:,227), n3(:,451), t3x64(:,:,227), nhel, den(183))
    call Hcont_QA(nsync, wf8(:,50), wf8(:,116), A(:,228), n3(:,452), t3x64(:,:,228), nhel, den(184))
    call Hcont_VV(nsync, wf8(:,1), wf8(:,125), A(:,229), n3(:,453), t3x64(:,:,229), nhel, den(185))
    call Hcont_QA(nsync, wf8(:,60), wf8(:,118), A(:,230), n3(:,454), t3x64(:,:,230), nhel, den(186))
    call Hcont_VV(nsync, wf8(:,16), wf8(:,107), A(:,231), n3(:,455), t3x64(:,:,231), nhel, den(187))
    call Hcont_VV(nsync, wf8(:,1), wf8(:,126), A(:,232), n3(:,456), t3x64(:,:,232), nhel, den(189))
    call Hcont_QA(nsync, wf8(:,60), wf8(:,120), A(:,233), n3(:,457), t3x64(:,:,233), nhel, den(190))
    call Hcont_VV(nsync, wf8(:,1), wf8(:,127), A(:,234), n3(:,458), t3x64(:,:,234), nhel, den(191))
    call Hcont_QA(nsync, wf8(:,11), wf8(:,128), A(:,235), n3(:,459), t3x64(:,:,235), nhel, den(192))
    call Hcont_QA(nsync, wf8(:,62), wf8(:,118), A(:,236), n3(:,460), t3x64(:,:,236), nhel, den(193))
    call Hcont_QA(nsync, wf8(:,19), wf8(:,113), A(:,237), n3(:,461), t3x64(:,:,237), nhel, den(194))
    call Hcont_QA(nsync, wf8(:,62), wf8(:,120), A(:,238), n3(:,462), t3x64(:,:,238), nhel, den(195))
    call Hcont_QA(nsync, wf8(:,7), wf8(:,129), A(:,239), n3(:,463), t3x64(:,:,239), nhel, den(196))
    call Hcont_QA(nsync, wf8(:,7), wf8(:,130), A(:,240), n3(:,464), t3x64(:,:,240), nhel, den(198))
    call Hcont_QA(nsync, wf8(:,11), wf8(:,131), A(:,241), n3(:,465), t3x64(:,:,241), nhel, den(199))
    call Hcont_QA(nsync, wf4(:,50), wf16(:,44), A(:,242), n3(:,466), t3x64(:,:,242), nhel, den(203))
    call Hcont_QA(nsync, wf4(:,51), wf16(:,46), A(:,243), n3(:,467), t3x64(:,:,243), nhel, den(207))
    call Hcont_VV(nsync, wf16(:,7), wf4(:,23), A(:,244), n3(:,468), t3x64(:,:,244), nhel, den(209))
    call Hcont_VV(nsync, wf8(:,2), wf8(:,132), A(:,245), n3(:,469), t3x64(:,:,245), nhel, den(211))
    call Hcont_QA(nsync, wf8(:,23), wf8(:,133), A(:,246), n3(:,470), t3x64(:,:,246), nhel, den(212))
    call Hcont_QA(nsync, wf8(:,81), wf8(:,134), A(:,247), n3(:,471), t3x64(:,:,247), nhel, den(213))
    call Hcont_VV(nsync, wf8(:,2), wf8(:,135), A(:,248), n3(:,472), t3x64(:,:,248), nhel, den(214))
    call Hcont_QA(nsync, wf8(:,81), wf8(:,136), A(:,249), n3(:,473), t3x64(:,:,249), nhel, den(215))
    call Hcont_VV(nsync, wf8(:,20), wf8(:,110), A(:,250), n3(:,474), t3x64(:,:,250), nhel, den(216))
    call Hcont_QA(nsync, wf4(:,53), wf16(:,48), A(:,251), n3(:,475), t3x64(:,:,251), nhel, den(220))
    call Hcont_QA(nsync, wf4(:,54), wf16(:,50), A(:,252), n3(:,476), t3x64(:,:,252), nhel, den(224))
    call Hcont_VV(nsync, wf16(:,8), wf4(:,23), A(:,253), n3(:,477), t3x64(:,:,253), nhel, den(226))
    call Hcont_VV(nsync, wf8(:,2), wf8(:,137), A(:,254), n3(:,478), t3x64(:,:,254), nhel, den(228))
    call Hcont_QA(nsync, wf8(:,92), wf8(:,138), A(:,255), n3(:,479), t3x64(:,:,255), nhel, den(229))
    call Hcont_VV(nsync, wf8(:,2), wf8(:,139), A(:,256), n3(:,480), t3x64(:,:,256), nhel, den(230))
    call Hcont_QA(nsync, wf8(:,92), wf8(:,140), A(:,257), n3(:,481), t3x64(:,:,257), nhel, den(231))
    call Hcont_QA(nsync, wf8(:,27), wf8(:,141), A(:,258), n3(:,482), t3x64(:,:,258), nhel, den(232))
    call Hcont_VV(nsync, wf8(:,24), wf8(:,110), A(:,259), n3(:,483), t3x64(:,:,259), nhel, den(233))
    call Hcont_VV(nsync, wf8(:,3), wf8(:,142), A(:,260), n3(:,484), t3x64(:,:,260), nhel, den(235))
    call Hcont_QA(nsync, wf8(:,23), wf8(:,143), A(:,261), n3(:,485), t3x64(:,:,261), nhel, den(236))
    call Hcont_QA(nsync, wf8(:,83), wf8(:,134), A(:,262), n3(:,486), t3x64(:,:,262), nhel, den(237))
    call Hcont_VV(nsync, wf8(:,3), wf8(:,144), A(:,263), n3(:,487), t3x64(:,:,263), nhel, den(238))
    call Hcont_QA(nsync, wf8(:,83), wf8(:,136), A(:,264), n3(:,488), t3x64(:,:,264), nhel, den(239))
    call Hcont_VV(nsync, wf8(:,28), wf8(:,109), A(:,265), n3(:,489), t3x64(:,:,265), nhel, den(240))
    call Hcont_VV(nsync, wf8(:,3), wf8(:,145), A(:,266), n3(:,490), t3x64(:,:,266), nhel, den(242))
    call Hcont_QA(nsync, wf8(:,94), wf8(:,138), A(:,267), n3(:,491), t3x64(:,:,267), nhel, den(243))
    call Hcont_VV(nsync, wf8(:,3), wf8(:,146), A(:,268), n3(:,492), t3x64(:,:,268), nhel, den(244))
    call Hcont_QA(nsync, wf8(:,94), wf8(:,140), A(:,269), n3(:,493), t3x64(:,:,269), nhel, den(245))
    call Hcont_QA(nsync, wf8(:,27), wf8(:,147), A(:,270), n3(:,494), t3x64(:,:,270), nhel, den(246))
    call Hcont_VV(nsync, wf8(:,30), wf8(:,109), A(:,271), n3(:,495), t3x64(:,:,271), nhel, den(247))
    call Hcont_QA(nsync, wf8(:,95), wf8(:,140), A(:,272), n3(:,496), t3x64(:,:,272), nhel, den(248))
    call Hcont_QA(nsync, wf8(:,23), wf8(:,148), A(:,273), n3(:,497), t3x64(:,:,273), nhel, den(249))
    call Hcont_QA(nsync, wf8(:,95), wf8(:,138), A(:,274), n3(:,498), t3x64(:,:,274), nhel, den(250))
    call Hcont_QA(nsync, wf8(:,23), wf8(:,149), A(:,275), n3(:,499), t3x64(:,:,275), nhel, den(251))
    call Hcont_QA(nsync, wf8(:,34), wf8(:,134), A(:,276), n3(:,500), t3x64(:,:,276), nhel, den(252))
    call Hcont_QA(nsync, wf8(:,27), wf8(:,150), A(:,277), n3(:,501), t3x64(:,:,277), nhel, den(253))
    call Hcont_VV(nsync, wf8(:,14), wf8(:,132), A(:,278), n3(:,502), t3x64(:,:,278), nhel, den(254))
    call Hcont_VV(nsync, wf8(:,14), wf8(:,135), A(:,279), n3(:,503), t3x64(:,:,279), nhel, den(255))
    call Hcont_VV(nsync, wf8(:,20), wf8(:,123), A(:,280), n3(:,504), t3x64(:,:,280), nhel, den(256))
    call Hcont_VV(nsync, wf8(:,16), wf8(:,132), A(:,281), n3(:,505), t3x64(:,:,281), nhel, den(257))
    call Hcont_VV(nsync, wf8(:,16), wf8(:,135), A(:,282), n3(:,506), t3x64(:,:,282), nhel, den(258))
    call Hcont_VV(nsync, wf8(:,20), wf8(:,126), A(:,283), n3(:,507), t3x64(:,:,283), nhel, den(259))
    call Hcont_VV(nsync, wf8(:,14), wf8(:,137), A(:,284), n3(:,508), t3x64(:,:,284), nhel, den(260))
    call Hcont_VV(nsync, wf8(:,14), wf8(:,139), A(:,285), n3(:,509), t3x64(:,:,285), nhel, den(261))
    call Hcont_VV(nsync, wf8(:,24), wf8(:,123), A(:,286), n3(:,510), t3x64(:,:,286), nhel, den(262))
    call Hcont_VV(nsync, wf8(:,16), wf8(:,137), A(:,287), n3(:,511), t3x64(:,:,287), nhel, den(263))
    call Hcont_VV(nsync, wf8(:,16), wf8(:,139), A(:,288), n3(:,512), t3x64(:,:,288), nhel, den(264))
    call Hcont_VV(nsync, wf8(:,24), wf8(:,126), A(:,289), n3(:,513), t3x64(:,:,289), nhel, den(265))
    call Hcont_VV(nsync, wf8(:,8), wf8(:,142), A(:,290), n3(:,514), t3x64(:,:,290), nhel, den(266))
    call Hcont_VV(nsync, wf8(:,8), wf8(:,144), A(:,291), n3(:,515), t3x64(:,:,291), nhel, den(267))
    call Hcont_VV(nsync, wf8(:,28), wf8(:,114), A(:,292), n3(:,516), t3x64(:,:,292), nhel, den(268))
    call Hcont_VV(nsync, wf8(:,8), wf8(:,145), A(:,293), n3(:,517), t3x64(:,:,293), nhel, den(269))
    call Hcont_VV(nsync, wf8(:,8), wf8(:,146), A(:,294), n3(:,518), t3x64(:,:,294), nhel, den(270))
    call Hcont_VV(nsync, wf8(:,30), wf8(:,114), A(:,295), n3(:,519), t3x64(:,:,295), nhel, den(271))
    call Hcont_VV(nsync, wf8(:,12), wf8(:,142), A(:,296), n3(:,520), t3x64(:,:,296), nhel, den(272))
    call Hcont_VV(nsync, wf8(:,12), wf8(:,144), A(:,297), n3(:,521), t3x64(:,:,297), nhel, den(273))
    call Hcont_VV(nsync, wf8(:,28), wf8(:,119), A(:,298), n3(:,522), t3x64(:,:,298), nhel, den(274))
    call Hcont_VV(nsync, wf8(:,12), wf8(:,145), A(:,299), n3(:,523), t3x64(:,:,299), nhel, den(275))
    call Hcont_VV(nsync, wf8(:,12), wf8(:,146), A(:,300), n3(:,524), t3x64(:,:,300), nhel, den(276))
    call Hcont_VV(nsync, wf8(:,30), wf8(:,119), A(:,301), n3(:,525), t3x64(:,:,301), nhel, den(277))

end subroutine diagrams


elemental function diagmap(j, n)
  implicit none
  integer, intent(in) :: j, n
  complex(REALKIND) :: diagmap
  diagmap = A(j,n)%j
end function diagmap

function diagsum(j, pos, neg)
  implicit none
  integer, intent(in) :: j, pos(:), neg(:)
  complex(REALKIND) :: diagsum
  diagsum = sum(diagmap(j, pos)) - sum(diagmap(j, neg))
end function diagsum

subroutine colourvectors(A, j, M1, M2)
  implicit none
  type(Hpolcont) :: A(:,:)
  integer, intent(in) :: j
  type(Hpolcont), intent(out) :: M1(12), M2(14) ! M1helarray(14,64)
  integer :: empty(0), i

  M1( 1)%j = ((-A(j,35)%j-A(j,36)%j-A(j,37)%j-A(j,38)%j)*f(1))/6._/**/REALKIND
  M1( 2)%j = ((-A(j,1)%j+A(j,3)%j+A(j,5)%j+A(j,6)%j+A(j,10)%j+A(j,19)%j+A(j,31)%j+A(j,38)%j)*f(1))/2._/**/REALKIND+(CI*(A(j,12)%j &
        -A(j,14)%j-A(j,20)%j+A(j,27)%j)*f(2))/2._/**/REALKIND
  M1( 3)%j = ((-A(j,1)%j+A(j,3)%j+A(j,5)%j+A(j,6)%j+A(j,7)%j+A(j,22)%j+A(j,34)%j+A(j,35)%j)*f(1))/2._/**/REALKIND+(CI*(-A(j,9)%j &
        +A(j,16)%j+A(j,23)%j-A(j,25)%j)*f(2))/2._/**/REALKIND
  M1( 4)%j = ((-A(j,31)%j-A(j,32)%j-A(j,33)%j-A(j,34)%j)*f(1))/6._/**/REALKIND
  M1( 5)%j = ((-A(j,22)%j-A(j,24)%j-A(j,26)%j)*f(1))/6._/**/REALKIND+(CI*(-A(j,29)%j-A(j,30)%j)*f(2))/6._/**/REALKIND
  M1( 6)%j = ((A(j,1)%j-A(j,2)%j-A(j,4)%j-A(j,5)%j+A(j,13)%j+A(j,24)%j+A(j,33)%j)*f(1))/2._/**/REALKIND+(CI*(A(j,14)%j+A(j,18)%j &
        -A(j,23)%j+A(j,29)%j)*f(2))/2._/**/REALKIND
  M1( 7)%j = ((A(j,2)%j-A(j,3)%j+A(j,4)%j-A(j,6)%j+A(j,11)%j+A(j,26)%j+A(j,37)%j)*f(1))/2._/**/REALKIND+(CI*(-A(j,12)%j+A(j,17)%j &
        +A(j,25)%j+A(j,30)%j)*f(2))/2._/**/REALKIND
  M1( 8)%j = ((-A(j,10)%j-A(j,11)%j-A(j,13)%j)*f(1))/6._/**/REALKIND+(CI*(-A(j,17)%j-A(j,18)%j)*f(2))/6._/**/REALKIND
  M1( 9)%j = ((-A(j,19)%j-A(j,21)%j-A(j,28)%j)*f(1))/6._/**/REALKIND+(CI*(A(j,29)%j+A(j,30)%j)*f(2))/6._/**/REALKIND
  M1(10)%j = ((A(j,2)%j-A(j,3)%j+A(j,4)%j-A(j,6)%j+A(j,8)%j+A(j,28)%j+A(j,36)%j)*f(1))/2._/**/REALKIND+(CI*(A(j,9)%j-A(j,18)%j &
        -A(j,27)%j-A(j,29)%j)*f(2))/2._/**/REALKIND
  M1(11)%j = ((A(j,1)%j-A(j,2)%j-A(j,4)%j-A(j,5)%j+A(j,15)%j+A(j,21)%j+A(j,32)%j)*f(1))/2._/**/REALKIND+(CI*(-A(j,16)%j-A(j,17)%j &
        +A(j,20)%j-A(j,30)%j)*f(2))/2._/**/REALKIND
  M1(12)%j = ((-A(j,7)%j-A(j,8)%j-A(j,15)%j)*f(1))/6._/**/REALKIND+(CI*(A(j,17)%j+A(j,18)%j)*f(2))/6._/**/REALKIND

  M2( 1)%j = ((A(j,290)%j+A(j,291)%j+A(j,292)%j+A(j,293)%j+A(j,294)%j+A(j,295)%j+A(j,296)%j+A(j,297)%j+A(j,298)%j+A(j,299)%j &
        +A(j,300)%j+A(j,301)%j)*f(3))/6._/**/REALKIND+((-A(j,118)%j-A(j,119)%j-A(j,120)%j-A(j,121)%j-A(j,126)%j-A(j,127)%j &
        -A(j,128)%j-A(j,129)%j)*f(5))/6._/**/REALKIND+((-A(j,156)%j-A(j,157)%j-A(j,158)%j-A(j,159)%j-A(j,176)%j-A(j,177)%j &
        -A(j,178)%j-A(j,179)%j)*f(7))/6._/**/REALKIND+((-A(j,42)%j-A(j,43)%j-A(j,44)%j)*f(12))/3._/**/REALKIND
  M2( 2)%j = ((A(j,54)%j-A(j,56)%j+A(j,57)%j-A(j,59)%j-A(j,200)%j-A(j,201)%j-A(j,202)%j-A(j,203)%j-A(j,204)%j-A(j,205)%j &
        -A(j,215)%j-A(j,216)%j-A(j,217)%j-A(j,242)%j-A(j,243)%j-A(j,244)%j-A(j,278)%j-A(j,279)%j-A(j,280)%j-A(j,299)%j-A(j,300)%j &
        -A(j,301)%j)*f(3))/2._/**/REALKIND+(CI*(-A(j,219)%j-A(j,220)%j-A(j,222)%j+A(j,225)%j+A(j,226)%j+A(j,229)%j+A(j,245)%j &
        +A(j,248)%j+A(j,250)%j-A(j,266)%j-A(j,268)%j-A(j,271)%j)*f(4))/2._/**/REALKIND+((-A(j,45)%j+A(j,47)%j+A(j,66)%j+A(j,84)%j &
        +A(j,89)%j+A(j,100)%j+A(j,101)%j+A(j,114)%j+A(j,121)%j+A(j,123)%j+A(j,127)%j+A(j,130)%j)*f(5))/2._/**/REALKIND+(CI*( &
        -A(j,78)%j+A(j,86)%j+A(j,87)%j-A(j,95)%j-A(j,131)%j+A(j,138)%j)*f(6))/2._/**/REALKIND+((-A(j,48)%j+A(j,50)%j+A(j,102)%j &
        +A(j,144)%j+A(j,154)%j+A(j,159)%j+A(j,171)%j+A(j,178)%j+A(j,180)%j+A(j,183)%j+A(j,184)%j+A(j,188)%j)*f(7))/2._/**/REALKIND &
        +(CI*(-A(j,143)%j+A(j,150)%j+A(j,165)%j-A(j,172)%j+A(j,190)%j-A(j,192)%j)*f(8))/2._/**/REALKIND+((A(j,52)%j+A(j,53)%j &
        +A(j,60)%j+A(j,61)%j)*f(9))/2._/**/REALKIND+(CI*(A(j,68)%j-A(j,70)%j-A(j,103)%j+A(j,110)%j)*f(10))/2._/**/REALKIND &
        +A(j,40)%j*f(11)+((-A(j,39)%j-A(j,41)%j)*f(11))/2._/**/REALKIND-9*A(j,43)%j*f(12)+(19*(A(j,42)%j &
        +A(j,44)%j)*f(12))/4._/**/REALKIND
  M2( 3)%j = ((A(j,54)%j-A(j,56)%j+A(j,57)%j-A(j,59)%j-A(j,200)%j-A(j,201)%j-A(j,202)%j-A(j,203)%j-A(j,204)%j-A(j,205)%j &
        -A(j,206)%j-A(j,207)%j-A(j,208)%j-A(j,251)%j-A(j,252)%j-A(j,253)%j-A(j,287)%j-A(j,288)%j-A(j,289)%j-A(j,290)%j-A(j,291)%j &
        -A(j,292)%j)*f(3))/2._/**/REALKIND+(CI*(A(j,210)%j+A(j,211)%j+A(j,214)%j-A(j,231)%j-A(j,232)%j-A(j,234)%j-A(j,254)%j &
        -A(j,256)%j-A(j,259)%j+A(j,260)%j+A(j,263)%j+A(j,265)%j)*f(4))/2._/**/REALKIND+((-A(j,45)%j+A(j,47)%j+A(j,63)%j+A(j,77)%j &
        +A(j,96)%j+A(j,100)%j+A(j,101)%j+A(j,117)%j+A(j,118)%j+A(j,124)%j+A(j,128)%j+A(j,133)%j)*f(5))/2._/**/REALKIND+(CI*( &
        -A(j,75)%j+A(j,83)%j+A(j,90)%j-A(j,98)%j+A(j,134)%j-A(j,136)%j)*f(6))/2._/**/REALKIND+((-A(j,48)%j+A(j,50)%j+A(j,105)%j &
        +A(j,151)%j+A(j,156)%j+A(j,161)%j+A(j,164)%j+A(j,175)%j+A(j,177)%j+A(j,183)%j+A(j,184)%j+A(j,185)%j)*f(7))/2._/**/REALKIND &
        +(CI*(-A(j,146)%j+A(j,153)%j+A(j,162)%j-A(j,169)%j-A(j,187)%j+A(j,194)%j)*f(8))/2._/**/REALKIND+((A(j,52)%j+A(j,53)%j &
        +A(j,60)%j+A(j,61)%j)*f(9))/2._/**/REALKIND+(CI*(-A(j,65)%j+A(j,72)%j+A(j,106)%j-A(j,108)%j)*f(10))/2._/**/REALKIND &
        +A(j,40)%j*f(11)+((-A(j,39)%j-A(j,41)%j)*f(11))/2._/**/REALKIND-9*A(j,43)%j*f(12)+(19*(A(j,42)%j &
        +A(j,44)%j)*f(12))/4._/**/REALKIND
  M2( 4)%j = ((A(j,278)%j+A(j,279)%j+A(j,280)%j+A(j,281)%j+A(j,282)%j+A(j,283)%j+A(j,284)%j+A(j,285)%j+A(j,286)%j+A(j,287)%j &
        +A(j,288)%j+A(j,289)%j)*f(3))/6._/**/REALKIND+((-A(j,114)%j-A(j,115)%j-A(j,116)%j-A(j,117)%j-A(j,122)%j-A(j,123)%j &
        -A(j,124)%j-A(j,125)%j)*f(5))/6._/**/REALKIND+((-A(j,154)%j-A(j,155)%j-A(j,160)%j-A(j,161)%j-A(j,174)%j-A(j,175)%j &
        -A(j,180)%j-A(j,181)%j)*f(7))/6._/**/REALKIND+((-A(j,42)%j-A(j,43)%j-A(j,44)%j)*f(12))/3._/**/REALKIND
  M2( 5)%j = ((A(j,251)%j+A(j,252)%j+A(j,253)%j+A(j,255)%j+A(j,257)%j+A(j,258)%j+A(j,261)%j+A(j,262)%j &
        +A(j,264)%j)*f(3))/6._/**/REALKIND+(CI*(A(j,272)%j+A(j,273)%j+A(j,274)%j+A(j,275)%j+A(j,276)%j &
        +A(j,277)%j)*f(4))/6._/**/REALKIND+((-A(j,133)%j-A(j,135)%j-A(j,137)%j)*f(5))/6._/**/REALKIND+(CI*(-A(j,140)%j &
        -A(j,141)%j)*f(6))/6._/**/REALKIND+((-A(j,105)%j-A(j,107)%j-A(j,109)%j-A(j,145)%j-A(j,151)%j-A(j,152)%j-A(j,163)%j &
        -A(j,164)%j-A(j,170)%j)*f(7))/6._/**/REALKIND+(CI*(-A(j,147)%j-A(j,148)%j-A(j,167)%j-A(j,168)%j)*f(8))/6._/**/REALKIND &
        +(CI*(-A(j,112)%j-A(j,113)%j)*f(10))/6._/**/REALKIND+((-A(j,42)%j-A(j,43)%j-A(j,44)%j)*f(12))/6._/**/REALKIND
  M2( 6)%j = ((-A(j,55)%j+A(j,56)%j-A(j,57)%j+A(j,58)%j+A(j,197)%j-A(j,198)%j+A(j,199)%j+A(j,200)%j+A(j,203)%j+A(j,204)%j &
        -A(j,224)%j-A(j,227)%j-A(j,228)%j-A(j,255)%j-A(j,257)%j-A(j,258)%j-A(j,284)%j-A(j,285)%j-A(j,286)%j)*f(3))/2._/**/REALKIND &
        +(CI*(-A(j,225)%j-A(j,226)%j-A(j,229)%j-A(j,237)%j-A(j,239)%j-A(j,240)%j+A(j,254)%j+A(j,256)%j+A(j,259)%j-A(j,272)%j &
        -A(j,274)%j-A(j,277)%j)*f(4))/2._/**/REALKIND+((A(j,45)%j-A(j,46)%j+A(j,69)%j+A(j,79)%j+A(j,94)%j-A(j,99)%j-A(j,100)%j &
        +A(j,116)%j+A(j,125)%j+A(j,135)%j)*f(5))/2._/**/REALKIND+(CI*(A(j,78)%j+A(j,81)%j+A(j,92)%j+A(j,95)%j-A(j,134)%j &
        +A(j,141)%j)*f(6))/2._/**/REALKIND+((A(j,48)%j-A(j,49)%j+A(j,107)%j+A(j,152)%j+A(j,160)%j+A(j,163)%j+A(j,174)%j-A(j,182)%j &
        -A(j,183)%j+A(j,191)%j)*f(7))/2._/**/REALKIND+(CI*(A(j,147)%j-A(j,153)%j-A(j,162)%j+A(j,167)%j+A(j,192)%j &
        +A(j,196)%j)*f(8))/2._/**/REALKIND+((-A(j,51)%j-A(j,52)%j-A(j,61)%j-A(j,62)%j)*f(9))/2._/**/REALKIND+(CI*(A(j,70)%j &
        +A(j,74)%j-A(j,106)%j+A(j,112)%j)*f(10))/2._/**/REALKIND+((-A(j,39)%j-A(j,40)%j)*f(11))/2._/**/REALKIND+A(j,41)%j*f(11) &
        +(19*(A(j,42)%j+A(j,43)%j)*f(12))/4._/**/REALKIND-9*A(j,44)%j*f(12)
  M2( 7)%j = ((-A(j,54)%j+A(j,55)%j-A(j,58)%j+A(j,59)%j-A(j,197)%j+A(j,198)%j-A(j,199)%j+A(j,201)%j+A(j,202)%j+A(j,205)%j &
        -A(j,218)%j-A(j,221)%j-A(j,223)%j-A(j,261)%j-A(j,262)%j-A(j,264)%j-A(j,296)%j-A(j,297)%j-A(j,298)%j)*f(3))/2._/**/REALKIND &
        +(CI*(A(j,219)%j+A(j,220)%j+A(j,222)%j-A(j,236)%j-A(j,238)%j-A(j,241)%j-A(j,260)%j-A(j,263)%j-A(j,265)%j-A(j,273)%j &
        -A(j,275)%j-A(j,276)%j)*f(4))/2._/**/REALKIND+((A(j,46)%j-A(j,47)%j+A(j,67)%j+A(j,85)%j+A(j,88)%j+A(j,99)%j-A(j,101)%j &
        +A(j,120)%j+A(j,126)%j+A(j,137)%j)*f(5))/2._/**/REALKIND+(CI*(A(j,80)%j-A(j,86)%j-A(j,87)%j+A(j,93)%j+A(j,136)%j &
        +A(j,140)%j)*f(6))/2._/**/REALKIND+((A(j,49)%j-A(j,50)%j+A(j,109)%j+A(j,145)%j+A(j,158)%j+A(j,170)%j+A(j,179)%j+A(j,182)%j &
        -A(j,184)%j+A(j,189)%j)*f(7))/2._/**/REALKIND+(CI*(A(j,146)%j+A(j,148)%j+A(j,168)%j+A(j,169)%j-A(j,190)%j &
        +A(j,195)%j)*f(8))/2._/**/REALKIND+((A(j,51)%j-A(j,53)%j-A(j,60)%j+A(j,62)%j)*f(9))/2._/**/REALKIND+(CI*(-A(j,68)%j &
        +A(j,73)%j+A(j,108)%j+A(j,113)%j)*f(10))/2._/**/REALKIND+A(j,39)%j*f(11)+((-A(j,40)%j-A(j,41)%j)*f(11))/2._/**/REALKIND &
        -9*A(j,42)%j*f(12)+(19*(A(j,43)%j+A(j,44)%j)*f(12))/4._/**/REALKIND
  M2( 8)%j = ((A(j,215)%j+A(j,216)%j+A(j,217)%j+A(j,218)%j+A(j,221)%j+A(j,223)%j+A(j,224)%j+A(j,227)%j &
        +A(j,228)%j)*f(3))/6._/**/REALKIND+(CI*(A(j,236)%j+A(j,237)%j+A(j,238)%j+A(j,239)%j+A(j,240)%j &
        +A(j,241)%j)*f(4))/6._/**/REALKIND+((-A(j,66)%j-A(j,67)%j-A(j,69)%j-A(j,79)%j-A(j,84)%j-A(j,85)%j-A(j,88)%j-A(j,89)%j &
        -A(j,94)%j)*f(5))/6._/**/REALKIND+(CI*(-A(j,80)%j-A(j,81)%j-A(j,92)%j-A(j,93)%j)*f(6))/6._/**/REALKIND+((-A(j,188)%j &
        -A(j,189)%j-A(j,191)%j)*f(7))/6._/**/REALKIND+(CI*(-A(j,195)%j-A(j,196)%j)*f(8))/6._/**/REALKIND+(CI*(-A(j,73)%j &
        -A(j,74)%j)*f(10))/6._/**/REALKIND+((-A(j,42)%j-A(j,43)%j-A(j,44)%j)*f(12))/6._/**/REALKIND
  M2( 9)%j = ((A(j,242)%j+A(j,243)%j+A(j,244)%j+A(j,246)%j+A(j,247)%j+A(j,249)%j+A(j,267)%j+A(j,269)%j &
        +A(j,270)%j)*f(3))/6._/**/REALKIND+(CI*(-A(j,272)%j-A(j,273)%j-A(j,274)%j-A(j,275)%j-A(j,276)%j &
        -A(j,277)%j)*f(4))/6._/**/REALKIND+((-A(j,130)%j-A(j,132)%j-A(j,139)%j)*f(5))/6._/**/REALKIND+(CI*(A(j,140)%j &
        +A(j,141)%j)*f(6))/6._/**/REALKIND+((-A(j,102)%j-A(j,104)%j-A(j,111)%j-A(j,142)%j-A(j,144)%j-A(j,149)%j-A(j,166)%j &
        -A(j,171)%j-A(j,173)%j)*f(7))/6._/**/REALKIND+(CI*(A(j,147)%j+A(j,148)%j+A(j,167)%j+A(j,168)%j)*f(8))/6._/**/REALKIND &
        +(CI*(A(j,112)%j+A(j,113)%j)*f(10))/6._/**/REALKIND+((-A(j,42)%j-A(j,43)%j-A(j,44)%j)*f(12))/6._/**/REALKIND
  M2(10)%j = ((-A(j,54)%j+A(j,55)%j-A(j,58)%j+A(j,59)%j-A(j,197)%j+A(j,198)%j-A(j,199)%j+A(j,201)%j+A(j,202)%j+A(j,205)%j &
        -A(j,209)%j-A(j,212)%j-A(j,213)%j-A(j,267)%j-A(j,269)%j-A(j,270)%j-A(j,293)%j-A(j,294)%j-A(j,295)%j)*f(3))/2._/**/REALKIND &
        +(CI*(-A(j,210)%j-A(j,211)%j-A(j,214)%j+A(j,237)%j+A(j,239)%j+A(j,240)%j+A(j,266)%j+A(j,268)%j+A(j,271)%j+A(j,272)%j &
        +A(j,274)%j+A(j,277)%j)*f(4))/2._/**/REALKIND+((A(j,46)%j-A(j,47)%j+A(j,64)%j+A(j,76)%j+A(j,97)%j+A(j,99)%j-A(j,101)%j &
        +A(j,119)%j+A(j,129)%j+A(j,139)%j)*f(5))/2._/**/REALKIND+(CI*(A(j,75)%j-A(j,81)%j-A(j,92)%j+A(j,98)%j-A(j,138)%j &
        -A(j,141)%j)*f(6))/2._/**/REALKIND+((A(j,49)%j-A(j,50)%j+A(j,111)%j+A(j,149)%j+A(j,157)%j+A(j,166)%j+A(j,176)%j+A(j,182)%j &
        -A(j,184)%j+A(j,186)%j)*f(7))/2._/**/REALKIND+(CI*(-A(j,147)%j-A(j,150)%j-A(j,165)%j-A(j,167)%j+A(j,187)%j &
        -A(j,196)%j)*f(8))/2._/**/REALKIND+((A(j,51)%j-A(j,53)%j-A(j,60)%j+A(j,62)%j)*f(9))/2._/**/REALKIND+(CI*(A(j,65)%j &
        -A(j,74)%j-A(j,110)%j-A(j,112)%j)*f(10))/2._/**/REALKIND+A(j,39)%j*f(11)+((-A(j,40)%j-A(j,41)%j)*f(11))/2._/**/REALKIND &
        -9*A(j,42)%j*f(12)+(19*(A(j,43)%j+A(j,44)%j)*f(12))/4._/**/REALKIND
  M2(11)%j = ((-A(j,55)%j+A(j,56)%j-A(j,57)%j+A(j,58)%j+A(j,197)%j-A(j,198)%j+A(j,199)%j+A(j,200)%j+A(j,203)%j+A(j,204)%j &
        -A(j,230)%j-A(j,233)%j-A(j,235)%j-A(j,246)%j-A(j,247)%j-A(j,249)%j-A(j,281)%j-A(j,282)%j-A(j,283)%j)*f(3))/2._/**/REALKIND &
        +(CI*(A(j,231)%j+A(j,232)%j+A(j,234)%j+A(j,236)%j+A(j,238)%j+A(j,241)%j-A(j,245)%j-A(j,248)%j-A(j,250)%j+A(j,273)%j &
        +A(j,275)%j+A(j,276)%j)*f(4))/2._/**/REALKIND+((A(j,45)%j-A(j,46)%j+A(j,71)%j+A(j,82)%j+A(j,91)%j-A(j,99)%j-A(j,100)%j &
        +A(j,115)%j+A(j,122)%j+A(j,132)%j)*f(5))/2._/**/REALKIND+(CI*(-A(j,80)%j-A(j,83)%j-A(j,90)%j-A(j,93)%j+A(j,131)%j &
        -A(j,140)%j)*f(6))/2._/**/REALKIND+((A(j,48)%j-A(j,49)%j+A(j,104)%j+A(j,142)%j+A(j,155)%j+A(j,173)%j+A(j,181)%j-A(j,182)%j &
        -A(j,183)%j+A(j,193)%j)*f(7))/2._/**/REALKIND+(CI*(A(j,143)%j-A(j,148)%j-A(j,168)%j+A(j,172)%j-A(j,194)%j &
        -A(j,195)%j)*f(8))/2._/**/REALKIND+((-A(j,51)%j-A(j,52)%j-A(j,61)%j-A(j,62)%j)*f(9))/2._/**/REALKIND+(CI*(-A(j,72)%j &
        -A(j,73)%j+A(j,103)%j-A(j,113)%j)*f(10))/2._/**/REALKIND+((-A(j,39)%j-A(j,40)%j)*f(11))/2._/**/REALKIND+A(j,41)%j*f(11) &
        +(19*(A(j,42)%j+A(j,43)%j)*f(12))/4._/**/REALKIND-9*A(j,44)%j*f(12)
  M2(12)%j = ((A(j,206)%j+A(j,207)%j+A(j,208)%j+A(j,209)%j+A(j,212)%j+A(j,213)%j+A(j,230)%j+A(j,233)%j &
        +A(j,235)%j)*f(3))/6._/**/REALKIND+(CI*(-A(j,236)%j-A(j,237)%j-A(j,238)%j-A(j,239)%j-A(j,240)%j &
        -A(j,241)%j)*f(4))/6._/**/REALKIND+((-A(j,63)%j-A(j,64)%j-A(j,71)%j-A(j,76)%j-A(j,77)%j-A(j,82)%j-A(j,91)%j-A(j,96)%j &
        -A(j,97)%j)*f(5))/6._/**/REALKIND+(CI*(A(j,80)%j+A(j,81)%j+A(j,92)%j+A(j,93)%j)*f(6))/6._/**/REALKIND+((-A(j,185)%j &
        -A(j,186)%j-A(j,193)%j)*f(7))/6._/**/REALKIND+(CI*(A(j,195)%j+A(j,196)%j)*f(8))/6._/**/REALKIND+(CI*(A(j,73)%j &
        +A(j,74)%j)*f(10))/6._/**/REALKIND+((-A(j,42)%j-A(j,43)%j-A(j,44)%j)*f(12))/6._/**/REALKIND
  M2(13)%j = ((-A(j,42)%j-A(j,43)%j-A(j,44)%j)*f(12))/3._/**/REALKIND
  M2(14)%j = (2*(A(j,42)%j+A(j,43)%j+A(j,44)%j)*f(12))/9._/**/REALKIND


  M1(:)%hf = Hel(j)
  M2(:)%hf = Hel(j)  

  !M(i) corresponds to \Gamma_{i} in Fabio's thesis

end subroutine colourvectors


! **********************************************************************
subroutine colint(M, M2colint)
! M(i)   = <M|Ci> colour component of matrix element
! COLINT = <M|M>
!        = Sum_{i,j} <M|Ci> * <Ci|Cj> * <Cj|M>
!        = colour-summed squared matrix element
! K2(i,j) = <Ci|Cj>
! **********************************************************************
  use ol_colourmatrix_ppttjj_ttxbbxgg_1_/**/REALKIND, only: K1
  implicit none

  complex(REALKIND), intent(in)  :: M(12)
  real(REALKIND),    intent(out) :: M2colint
  integer :: i, j

  M2colint = 0

    do i = 1, 12
      do j = 1, 12
        M2colint = M2colint + real(conjg(M(i))*K1(i,j)*M(j))
      end do
    end do

end subroutine colint

! **********************************************************************
subroutine colint_ct(M, Mct, M2colint_ct)
! M(i)   = <M|Ci> colour component of matrix element
! COLINT = <M|M>
!        = Sum_{i,j} <M|Ci> * <Ci|Cj> * <Cj|M>
!        = colour-summed squared matrix element
! K2(i,j) = <Ci|Cj>
! **********************************************************************
  use ol_colourmatrix_ppttjj_ttxbbxgg_1_/**/REALKIND, only: K2
  implicit none

  complex(REALKIND), intent(in)  :: M(12), Mct(14)
  real(REALKIND),    intent(out) :: M2colint_ct
  integer ::  i, j

  M2colint_ct = 0

    do i = 1, 12
      do j = 1, 14
        M2colint_ct = M2colint_ct + real(conjg(M(i))*K2(i,j)*Mct(j))
      end do
    end do


end subroutine colint_ct

! **********************************************************************
subroutine colint_IR(M, M2IRadd)
! M(i)   = <M|Ci> colour component of matrix element
! K1(i,j) = .....
! **********************************************************************
  use ol_colourmatrix_ppttjj_ttxbbxgg_1_/**/REALKIND, only: K1
  implicit none

  complex(REALKIND), intent(in)  :: M(12)
  real(REALKIND),    intent(out) :: M2IRadd(22)
  integer ::  i, j, k, colmatpos

  M2IRadd = 0

  do k = 1, 23-1
    colmatpos = 12*k
    do i = 1, 12
      do j = 1, 12
	M2IRadd(k) = M2IRadd(k) + real(conjg(M(i))*K1(i+colmatpos,j)*M(j))
      end do
    end do
  end do
  
end subroutine colint_IR

! **********************************************************************
subroutine colintmunu(M1, M2, M2colint)
! M1(i)    = <M1|Ci> colour component of matrix element
! M2(i)    = <M2|Ci> colour component of matrix element
! M2colint = <M1|M2>
!          = Sum_{i,j} <M1|Ci> * <Ci|Cj> * <Cj|M2>
!          = colour-summed squared matrix element
! K2(i,j) = <Ci|Cj>
! **********************************************************************
  use ol_colourmatrix_ppttjj_ttxbbxgg_1_/**/REALKIND, only: K2
  implicit none

  complex(REALKIND), intent(in)  :: M1(12)
  complex(REALKIND), intent(in)  :: M2(12)
  complex(REALKIND),    intent(out) :: M2colint
  integer :: i, j

  M2colint = 0

  do i = 1, 12
    do j = 1, 12
      M2colint = M2colint + M1(i)*K2(i,j)*conjg(M2(j))
    end do
  end do

end subroutine colintmunu





! **********************************************************************
subroutine colborninterf(M, M0_col)
! M(i)         = <M|Ci> colour component of matrix element
! M0_col(i)    = <M2|Ci> colour component of matrix element,
!                see \tilde{M}_{j} in Fabio's thesis
! M2colint = Sum_{i} <M1|Ci> * <Ci|Cj>
!          = colour-summed squared matrix element
! KL(i,j) = <Ci|Cj> with elements Cj of 1-loop colour basis
! **********************************************************************
  use ol_colourmatrix_ppttjj_ttxbbxgg_1_/**/REALKIND, only: KL
  implicit none

  type(Hpolcont), intent(in)  :: M(12)
  type(Hpolcont), intent(out)  :: M0_col(14)
  integer :: i, j


  do j = 1, 14 !size(KL(1,:))
    M0_col(j)%j = 0
    M0_col(j)%hf = M(1)%hf
    do i = 1, 12 !size(KL(:,1))
      M0_col(j)%j = M0_col(j)%j  + conjg(M(i)%j)*KL(i,j)
    end do    
  end do

end subroutine colborninterf

end subroutine amp2

end module ol_loop_ppttjj_ttxbbxgg_1_/**/REALKIND
