
module ol_colourmatrix_ppttjj_ttxggggg_1_/**/REALKIND
  use KIND_TYPES, only: REALKIND
  implicit none
  logical, save           :: colmat_not_initialised = .true.
  complex(REALKIND), save :: K1(3600,120)
  contains
  subroutine colourmatrix_init
    use ol_parameters_decl_/**/REALKIND, only: CI
    implicit none
    colmat_not_initialised = .false.
    ! colour matrix

  K1(   1,:) = [  24576,  -3072,  -3072,    384,    384,   3840,  -3072,    384,    384,    -48,    -48,   -480,    384,    -48, &
                  3840,   -480,   3408,   2976,    -48,   -480,   -480,   2976,   2976,  -1344,  -3072,    384,    384,    -48, &
                   -48,   -480,    384,    -48,    -48,      6,      6,     60,    -48,      6,   -480,     60,   -426,   -372, &
                     6,     60,     60,   -372,   -372,    168,    384,    -48,    -48,      6,      6,     60,   3840,   -480, &
                  -480,     60,     60,    600,   3408,   -426,   2976,   -372,   3030,   3084,   -426,    114,   -372,   -318, &
                  -804,   -264,    -48,      6,   -480,     60,   -426,   -372,   -480,     60,   2976,   -372,    114,   -318, &
                  2976,   -372,  -1344,    168,   -804,   -264,   3030,   -804,   -804,   2652,   2652,   -696,      6,     60, &
                    60,   -372,   -372,    168,     60,    600,   -372,   3084,   -318,   -264,   -372,   -318,    168,   -264, &
                  2652,   -696,   3084,   -264,   -264,   -696,   -696,    816]
  K1(   2,:) = [  -3072,  24576,    384,   3840,  -3072,    384,    384,  -3072,    -48,   -480,    384,    -48,    -48,   -480, &
                  -480,   2976,   2976,  -1344,    384,    -48,   3840,   -480,   3408,   2976,    384,  -3072,    -48,   -480, &
                   384,    -48,    -48,    384,      6,     60,    -48,      6,      6,     60,     60,   -372,   -372,    168, &
                   -48,      6,   -480,     60,   -426,   -372,    -48,    384,      6,     60,    -48,      6,   -480,   3840, &
                    60,    600,   -480,     60,   -426,    114,   -372,   -318,   -804,   -264,   3408,   -426,   2976,   -372, &
                  3030,   3084,      6,     60,     60,   -372,   -372,    168,     60,    600,   -372,   3084,   -318,   -264, &
                  -372,   -318,    168,   -264,   2652,   -696,   3084,   -264,   -264,   -696,   -696,    816,    -48,      6, &
                  -480,     60,   -426,   -372,   -480,     60,   2976,   -372,    114,   -318,   2976,   -372,  -1344,    168, &
                  -804,   -264,   3030,   -804,   -804,   2652,   2652,   -696]
  K1(   3,:) = [  -3072,    384,  24576,  -3072,   3840,    384,    384,    -48,   3840,   -480,   3408,   2976,  -3072,    384, &
                   384,    -48,    -48,   -480,   -480,    -48,   2976,  -1344,   -480,   2976,    384,    -48,  -3072,    384, &
                  -480,    -48,    -48,      6,   -480,     60,   -426,   -372,    384,    -48,    -48,      6,      6,     60, &
                    60,      6,   -372,    168,     60,   -372,    -48,      6,   -480,     60,   -426,   -372,   -480,     60, &
                  2976,   -372,    114,   -318,   2976,   -372,  -1344,    168,   -804,   -264,   3030,   -804,   -804,   2652, &
                  2652,   -696,    384,    -48,    -48,      6,      6,     60,   3840,   -480,   -480,     60,     60,    600, &
                  3408,   -426,   2976,   -372,   3030,   3084,   -426,    114,   -372,   -318,   -804,   -264,     60,      6, &
                  -372,    168,     60,   -372,    600,     60,   -318,   -264,   -372,   3084,   3084,   -264,   -264,   -696, &
                  -696,    816,   -372,   -318,    168,   -264,   2652,   -696]
  K1(   4,:) = [    384,   3840,  -3072,  24576,    384,  -3072,    -48,   -480,   -480,   2976,   2976,  -1344,    384,  -3072, &
                   -48,   -480,    384,    -48,    -48,    384,   3408,   2976,   3840,   -480,    -48,   -480,    384,  -3072, &
                   -48,    384,      6,     60,     60,   -372,   -372,    168,    -48,    384,      6,     60,    -48,      6, &
                     6,    -48,   -426,   -372,   -480,     60,      6,     60,     60,   -372,   -372,    168,     60,    600, &
                  -372,   3084,   -318,   -264,   -372,   -318,    168,   -264,   2652,   -696,   3084,   -264,   -264,   -696, &
                  -696,    816,    -48,    384,      6,     60,    -48,      6,   -480,   3840,     60,    600,   -480,     60, &
                  -426,    114,   -372,   -318,   -804,   -264,   3408,   -426,   2976,   -372,   3030,   3084,      6,    -48, &
                  -426,   -372,   -480,     60,     60,   -480,    114,   -318,   2976,   -372,   3030,   -804,   -804,   2652, &
                  2652,   -696,   2976,   -372,  -1344,    168,   -804,   -264]
  K1(   5,:) = [    384,  -3072,   3840,    384,  24576,  -3072,    -48,    384,   3408,   2976,   3840,   -480,   -480,    -48, &
                  2976,  -1344,   -480,   2976,  -3072,    384,    384,    -48,    -48,   -480,    -48,    384,   -480,    -48, &
                 -3072,    384,      6,    -48,   -426,   -372,   -480,     60,     60,      6,   -372,    168,     60,   -372, &
                   384,    -48,    -48,      6,      6,     60,      6,    -48,   -426,   -372,   -480,     60,     60,   -480, &
                   114,   -318,   2976,   -372,   3030,   -804,   -804,   2652,   2652,   -696,   2976,   -372,  -1344,    168, &
                  -804,   -264,     60,      6,   -372,    168,     60,   -372,    600,     60,   -318,   -264,   -372,   3084, &
                  3084,   -264,   -264,   -696,   -696,    816,   -372,   -318,    168,   -264,   2652,   -696,    384,    -48, &
                   -48,      6,      6,     60,   3840,   -480,   -480,     60,     60,    600,   3408,   -426,   2976,   -372, &
                  3030,   3084,   -426,    114,   -372,   -318,   -804,   -264]
  K1(   6,:) = [   3840,    384,    384,  -3072,  -3072,  24576,   -480,    -48,   2976,  -1344,   -480,   2976,    -48,    384, &
                  3408,   2976,   3840,   -480,    384,  -3072,    -48,   -480,    384,    -48,   -480,    -48,    -48,    384, &
                   384,  -3072,     60,      6,   -372,    168,     60,   -372,      6,    -48,   -426,   -372,   -480,     60, &
                   -48,    384,      6,     60,    -48,      6,     60,      6,   -372,    168,     60,   -372,    600,     60, &
                  -318,   -264,   -372,   3084,   3084,   -264,   -264,   -696,   -696,    816,   -372,   -318,    168,   -264, &
                  2652,   -696,      6,    -48,   -426,   -372,   -480,     60,     60,   -480,    114,   -318,   2976,   -372, &
                  3030,   -804,   -804,   2652,   2652,   -696,   2976,   -372,  -1344,    168,   -804,   -264,    -48,    384, &
                     6,     60,    -48,      6,   -480,   3840,     60,    600,   -480,     60,   -426,    114,   -372,   -318, &
                  -804,   -264,   3408,   -426,   2976,   -372,   3030,   3084]
  K1(   7,:) = [  -3072,    384,    384,    -48,    -48,   -480,  24576,  -3072,  -3072,    384,    384,   3840,   3840,   -480, &
                   384,    -48,   2976,   3408,   -480,   2976,    -48,   -480,  -1344,   2976,    384,    -48,    -48,      6, &
                     6,     60,   3840,   -480,   -480,     60,     60,    600,   3408,   -426,   2976,   -372,   3030,   3084, &
                  -426,    114,   -372,   -318,   -804,   -264,  -3072,    384,    384,    -48,    -48,   -480,    384,    -48, &
                   -48,      6,      6,     60,    -48,      6,   -480,     60,   -426,   -372,      6,     60,     60,   -372, &
                  -372,    168,   -480,     60,    -48,      6,   -372,   -426,   2976,   -372,  -1344,    168,   -804,   -264, &
                  -480,     60,   2976,   -372,    114,   -318,   -804,   3030,   2652,   -696,   -804,   2652,     60,   -372, &
                     6,     60,    168,   -372,   -372,   -318,    168,   -264,   2652,   -696,     60,    600,   -372,   3084, &
                  -318,   -264,   -264,   3084,   -696,    816,   -264,   -696]
  K1(   8,:) = [    384,  -3072,    -48,   -480,    384,    -48,  -3072,  24576,    384,   3840,  -3072,    384,   -480,   2976, &
                   -48,   -480,  -1344,   2976,   3840,   -480,    384,    -48,   2976,   3408,    -48,    384,      6,     60, &
                   -48,      6,   -480,   3840,     60,    600,   -480,     60,   -426,    114,   -372,   -318,   -804,   -264, &
                  3408,   -426,   2976,   -372,   3030,   3084,    384,  -3072,    -48,   -480,    384,    -48,    -48,    384, &
                     6,     60,    -48,      6,      6,     60,     60,   -372,   -372,    168,    -48,      6,   -480,     60, &
                  -426,   -372,     60,   -372,      6,     60,    168,   -372,   -372,   -318,    168,   -264,   2652,   -696, &
                    60,    600,   -372,   3084,   -318,   -264,   -264,   3084,   -696,    816,   -264,   -696,   -480,     60, &
                   -48,      6,   -372,   -426,   2976,   -372,  -1344,    168,   -804,   -264,   -480,     60,   2976,   -372, &
                   114,   -318,   -804,   3030,   2652,   -696,   -804,   2652]
  K1(   9,:) = [    384,    -48,   3840,   -480,   3408,   2976,  -3072,    384,  24576,  -3072,   3840,    384,    384,    -48, &
                 -3072,    384,   -480,    -48,   2976,  -1344,   -480,    -48,   2976,   -480,    -48,      6,   -480,     60, &
                  -426,   -372,   -480,     60,   2976,   -372,    114,   -318,   2976,   -372,  -1344,    168,   -804,   -264, &
                  3030,   -804,   -804,   2652,   2652,   -696,    384,    -48,  -3072,    384,   -480,    -48,    -48,      6, &
                  -480,     60,   -426,   -372,    384,    -48,    -48,      6,      6,     60,     60,      6,   -372,    168, &
                    60,   -372,    -48,      6,    384,    -48,     60,      6,   3408,   -426,   2976,   -372,   3030,   3084, &
                  3840,   -480,   -480,     60,     60,    600,    114,   -426,   -804,   -264,   -372,   -318,   -372,    168, &
                    60,      6,   -372,     60,   3084,   -264,   -264,   -696,   -696,    816,    600,     60,   -318,   -264, &
                  -372,   3084,   -318,   -372,   2652,   -696,    168,   -264]
  K1(  10,:) = [    -48,   -480,   -480,   2976,   2976,  -1344,    384,   3840,  -3072,  24576,    384,  -3072,    -48,   -480, &
                   384,  -3072,    -48,    384,   3408,   2976,    -48,    384,   -480,   3840,      6,     60,     60,   -372, &
                  -372,    168,     60,    600,   -372,   3084,   -318,   -264,   -372,   -318,    168,   -264,   2652,   -696, &
                  3084,   -264,   -264,   -696,   -696,    816,    -48,   -480,    384,  -3072,    -48,    384,      6,     60, &
                    60,   -372,   -372,    168,    -48,    384,      6,     60,    -48,      6,      6,    -48,   -426,   -372, &
                  -480,     60,      6,     60,    -48,    384,      6,    -48,   -426,    114,   -372,   -318,   -804,   -264, &
                  -480,   3840,     60,    600,   -480,     60,   -426,   3408,   3030,   3084,   2976,   -372,   -426,   -372, &
                     6,    -48,     60,   -480,   3030,   -804,   -804,   2652,   2652,   -696,     60,   -480,    114,   -318, &
                  2976,   -372,   -372,   2976,   -804,   -264,  -1344,    168]
  K1(  11,:) = [    -48,    384,   3408,   2976,   3840,   -480,    384,  -3072,   3840,    384,  24576,  -3072,   2976,  -1344, &
                  -480,    -48,   2976,   -480,    384,    -48,  -3072,    384,   -480,    -48,      6,    -48,   -426,   -372, &
                  -480,     60,     60,   -480,    114,   -318,   2976,   -372,   3030,   -804,   -804,   2652,   2652,   -696, &
                  2976,   -372,  -1344,    168,   -804,   -264,    -48,    384,   -480,    -48,  -3072,    384,      6,    -48, &
                  -426,   -372,   -480,     60,     60,      6,   -372,    168,     60,   -372,    384,    -48,    -48,      6, &
                     6,     60,   -372,    168,     60,      6,   -372,     60,   3084,   -264,   -264,   -696,   -696,    816, &
                   600,     60,   -318,   -264,   -372,   3084,   -318,   -372,   2652,   -696,    168,   -264,    -48,      6, &
                   384,    -48,     60,      6,   3408,   -426,   2976,   -372,   3030,   3084,   3840,   -480,   -480,     60, &
                    60,    600,    114,   -426,   -804,   -264,   -372,   -318]
  K1(  12,:) = [   -480,    -48,   2976,  -1344,   -480,   2976,   3840,    384,    384,  -3072,  -3072,  24576,   3408,   2976, &
                   -48,    384,   -480,   3840,    -48,   -480,    384,  -3072,    -48,    384,     60,      6,   -372,    168, &
                    60,   -372,    600,     60,   -318,   -264,   -372,   3084,   3084,   -264,   -264,   -696,   -696,    816, &
                  -372,   -318,    168,   -264,   2652,   -696,   -480,    -48,    -48,    384,    384,  -3072,     60,      6, &
                  -372,    168,     60,   -372,      6,    -48,   -426,   -372,   -480,     60,    -48,    384,      6,     60, &
                   -48,      6,   -426,   -372,      6,    -48,     60,   -480,   3030,   -804,   -804,   2652,   2652,   -696, &
                    60,   -480,    114,   -318,   2976,   -372,   -372,   2976,   -804,   -264,  -1344,    168,      6,     60, &
                   -48,    384,      6,    -48,   -426,    114,   -372,   -318,   -804,   -264,   -480,   3840,     60,    600, &
                  -480,     60,   -426,   3408,   3030,   3084,   2976,   -372]
  K1(  13,:) = [    384,    -48,  -3072,    384,   -480,    -48,   3840,   -480,    384,    -48,   2976,   3408,  24576,  -3072, &
                 -3072,    384,    384,   3840,   2976,   -480,  -1344,   2976,    -48,   -480,    -48,      6,    384,    -48, &
                    60,      6,   3408,   -426,   2976,   -372,   3030,   3084,   3840,   -480,   -480,     60,     60,    600, &
                   114,   -426,   -804,   -264,   -372,   -318,   -480,     60,    -48,      6,   -372,   -426,   2976,   -372, &
                 -1344,    168,   -804,   -264,   -480,     60,   2976,   -372,    114,   -318,   -804,   3030,   2652,   -696, &
                  -804,   2652,  -3072,    384,    384,    -48,    -48,   -480,    384,    -48,    -48,      6,      6,     60, &
                   -48,      6,   -480,     60,   -426,   -372,      6,     60,     60,   -372,   -372,    168,   -372,     60, &
                   168,   -372,      6,     60,   -318,   -372,   2652,   -696,    168,   -264,   -264,   3084,   -696,    816, &
                  -264,   -696,     60,    600,   -372,   3084,   -318,   -264]
  K1(  14,:) = [    -48,   -480,    384,  -3072,    -48,    384,   -480,   2976,    -48,   -480,  -1344,   2976,  -3072,  24576, &
                   384,   3840,  -3072,    384,   -480,   3840,   2976,   3408,    384,    -48,      6,     60,    -48,    384, &
                     6,    -48,   -426,    114,   -372,   -318,   -804,   -264,   -480,   3840,     60,    600,   -480,     60, &
                  -426,   3408,   3030,   3084,   2976,   -372,     60,   -372,      6,     60,    168,   -372,   -372,   -318, &
                   168,   -264,   2652,   -696,     60,    600,   -372,   3084,   -318,   -264,   -264,   3084,   -696,    816, &
                  -264,   -696,    384,  -3072,    -48,   -480,    384,    -48,    -48,    384,      6,     60,    -48,      6, &
                     6,     60,     60,   -372,   -372,    168,    -48,      6,   -480,     60,   -426,   -372,     60,   -480, &
                  -372,   -426,    -48,      6,   -372,   2976,   -804,   -264,  -1344,    168,   -804,   3030,   2652,   -696, &
                  -804,   2652,   -480,     60,   2976,   -372,    114,   -318]
  K1(  15,:) = [   3840,   -480,    384,    -48,   2976,   3408,    384,    -48,  -3072,    384,   -480,    -48,  -3072,    384, &
                 24576,  -3072,   3840,    384,  -1344,   2976,   2976,   -480,   -480,    -48,   -480,     60,    -48,      6, &
                  -372,   -426,   2976,   -372,  -1344,    168,   -804,   -264,   -480,     60,   2976,   -372,    114,   -318, &
                  -804,   3030,   2652,   -696,   -804,   2652,    -48,      6,    384,    -48,     60,      6,   3408,   -426, &
                  2976,   -372,   3030,   3084,   3840,   -480,   -480,     60,     60,    600,    114,   -426,   -804,   -264, &
                  -372,   -318,    384,    -48,  -3072,    384,   -480,    -48,    -48,      6,   -480,     60,   -426,   -372, &
                   384,    -48,    -48,      6,      6,     60,     60,      6,   -372,    168,     60,   -372,    168,   -372, &
                  -372,     60,     60,      6,   -264,   3084,   -696,    816,   -264,   -696,   -318,   -372,   2652,   -696, &
                   168,   -264,    600,     60,   -318,   -264,   -372,   3084]
  K1(  16,:) = [   -480,   2976,    -48,   -480,  -1344,   2976,    -48,   -480,    384,  -3072,    -48,    384,    384,   3840, &
                 -3072,  24576,    384,  -3072,   2976,   3408,   -480,   3840,    -48,    384,     60,   -372,      6,     60, &
                   168,   -372,   -372,   -318,    168,   -264,   2652,   -696,     60,    600,   -372,   3084,   -318,   -264, &
                  -264,   3084,   -696,    816,   -264,   -696,      6,     60,    -48,    384,      6,    -48,   -426,    114, &
                  -372,   -318,   -804,   -264,   -480,   3840,     60,    600,   -480,     60,   -426,   3408,   3030,   3084, &
                  2976,   -372,    -48,   -480,    384,  -3072,    -48,    384,      6,     60,     60,   -372,   -372,    168, &
                   -48,    384,      6,     60,    -48,      6,      6,    -48,   -426,   -372,   -480,     60,   -372,   -426, &
                    60,   -480,      6,    -48,   -804,   3030,   2652,   -696,   -804,   2652,   -372,   2976,   -804,   -264, &
                 -1344,    168,     60,   -480,    114,   -318,   2976,   -372]
  K1(  17,:) = [   3408,   2976,    -48,    384,   -480,   3840,   2976,  -1344,   -480,    -48,   2976,   -480,    384,  -3072, &
                  3840,    384,  24576,  -3072,    -48,    384,   -480,    -48,  -3072,    384,   -426,   -372,      6,    -48, &
                    60,   -480,   3030,   -804,   -804,   2652,   2652,   -696,     60,   -480,    114,   -318,   2976,   -372, &
                  -372,   2976,   -804,   -264,  -1344,    168,   -372,    168,     60,      6,   -372,     60,   3084,   -264, &
                  -264,   -696,   -696,    816,    600,     60,   -318,   -264,   -372,   3084,   -318,   -372,   2652,   -696, &
                   168,   -264,    -48,    384,   -480,    -48,  -3072,    384,      6,    -48,   -426,   -372,   -480,     60, &
                    60,      6,   -372,    168,     60,   -372,    384,    -48,    -48,      6,      6,     60,      6,    -48, &
                    60,      6,    384,    -48,   -426,   3408,   3030,   3084,   2976,   -372,    114,   -426,   -804,   -264, &
                  -372,   -318,   3840,   -480,   -480,     60,     60,    600]
  K1(  18,:) = [   2976,  -1344,   -480,    -48,   2976,   -480,   3408,   2976,    -48,    384,   -480,   3840,   3840,    384, &
                   384,  -3072,  -3072,  24576,   -480,    -48,    -48,    384,    384,  -3072,   -372,    168,     60,      6, &
                  -372,     60,   3084,   -264,   -264,   -696,   -696,    816,    600,     60,   -318,   -264,   -372,   3084, &
                  -318,   -372,   2652,   -696,    168,   -264,   -426,   -372,      6,    -48,     60,   -480,   3030,   -804, &
                  -804,   2652,   2652,   -696,     60,   -480,    114,   -318,   2976,   -372,   -372,   2976,   -804,   -264, &
                 -1344,    168,   -480,    -48,    -48,    384,    384,  -3072,     60,      6,   -372,    168,     60,   -372, &
                     6,    -48,   -426,   -372,   -480,     60,    -48,    384,      6,     60,    -48,      6,     60,      6, &
                     6,    -48,    -48,    384,    114,   -426,   -804,   -264,   -372,   -318,   -426,   3408,   3030,   3084, &
                  2976,   -372,   -480,   3840,     60,    600,   -480,     60]
  K1(  19,:) = [    -48,    384,   -480,    -48,  -3072,    384,   -480,   3840,   2976,   3408,    384,    -48,   2976,   -480, &
                 -1344,   2976,    -48,   -480,  24576,  -3072,  -3072,    384,    384,   3840,      6,    -48,     60,      6, &
                   384,    -48,   -426,   3408,   3030,   3084,   2976,   -372,    114,   -426,   -804,   -264,   -372,   -318, &
                  3840,   -480,   -480,     60,     60,    600,     60,   -480,   -372,   -426,    -48,      6,   -372,   2976, &
                  -804,   -264,  -1344,    168,   -804,   3030,   2652,   -696,   -804,   2652,   -480,     60,   2976,   -372, &
                   114,   -318,   -372,     60,    168,   -372,      6,     60,   -318,   -372,   2652,   -696,    168,   -264, &
                  -264,   3084,   -696,    816,   -264,   -696,     60,    600,   -372,   3084,   -318,   -264,  -3072,    384, &
                   384,    -48,    -48,   -480,    384,    -48,    -48,      6,      6,     60,    -48,      6,   -480,     60, &
                  -426,   -372,      6,     60,     60,   -372,   -372,    168]
  K1(  20,:) = [   -480,    -48,    -48,    384,    384,  -3072,   2976,   -480,  -1344,   2976,    -48,   -480,   -480,   3840, &
                  2976,   3408,    384,    -48,  -3072,  24576,    384,   3840,  -3072,    384,     60,      6,      6,    -48, &
                   -48,    384,    114,   -426,   -804,   -264,   -372,   -318,   -426,   3408,   3030,   3084,   2976,   -372, &
                  -480,   3840,     60,    600,   -480,     60,   -372,     60,    168,   -372,      6,     60,   -318,   -372, &
                  2652,   -696,    168,   -264,   -264,   3084,   -696,    816,   -264,   -696,     60,    600,   -372,   3084, &
                  -318,   -264,     60,   -480,   -372,   -426,    -48,      6,   -372,   2976,   -804,   -264,  -1344,    168, &
                  -804,   3030,   2652,   -696,   -804,   2652,   -480,     60,   2976,   -372,    114,   -318,    384,  -3072, &
                   -48,   -480,    384,    -48,    -48,    384,      6,     60,    -48,      6,      6,     60,     60,   -372, &
                  -372,    168,    -48,      6,   -480,     60,   -426,   -372]
  K1(  21,:) = [   -480,   3840,   2976,   3408,    384,    -48,    -48,    384,   -480,    -48,  -3072,    384,  -1344,   2976, &
                  2976,   -480,   -480,    -48,  -3072,    384,  24576,  -3072,   3840,    384,     60,   -480,   -372,   -426, &
                   -48,      6,   -372,   2976,   -804,   -264,  -1344,    168,   -804,   3030,   2652,   -696,   -804,   2652, &
                  -480,     60,   2976,   -372,    114,   -318,      6,    -48,     60,      6,    384,    -48,   -426,   3408, &
                  3030,   3084,   2976,   -372,    114,   -426,   -804,   -264,   -372,   -318,   3840,   -480,   -480,     60, &
                    60,    600,    168,   -372,   -372,     60,     60,      6,   -264,   3084,   -696,    816,   -264,   -696, &
                  -318,   -372,   2652,   -696,    168,   -264,    600,     60,   -318,   -264,   -372,   3084,    384,    -48, &
                 -3072,    384,   -480,    -48,    -48,      6,   -480,     60,   -426,   -372,    384,    -48,    -48,      6, &
                     6,     60,     60,      6,   -372,    168,     60,   -372]
  K1(  22,:) = [   2976,   -480,  -1344,   2976,    -48,   -480,   -480,    -48,    -48,    384,    384,  -3072,   2976,   3408, &
                  -480,   3840,    -48,    384,    384,   3840,  -3072,  24576,    384,  -3072,   -372,     60,    168,   -372, &
                     6,     60,   -318,   -372,   2652,   -696,    168,   -264,   -264,   3084,   -696,    816,   -264,   -696, &
                    60,    600,   -372,   3084,   -318,   -264,     60,      6,      6,    -48,    -48,    384,    114,   -426, &
                  -804,   -264,   -372,   -318,   -426,   3408,   3030,   3084,   2976,   -372,   -480,   3840,     60,    600, &
                  -480,     60,   -372,   -426,     60,   -480,      6,    -48,   -804,   3030,   2652,   -696,   -804,   2652, &
                  -372,   2976,   -804,   -264,  -1344,    168,     60,   -480,    114,   -318,   2976,   -372,    -48,   -480, &
                   384,  -3072,    -48,    384,      6,     60,     60,   -372,   -372,    168,    -48,    384,      6,     60, &
                   -48,      6,      6,    -48,   -426,   -372,   -480,     60]
  K1(  23,:) = [   2976,   3408,   -480,   3840,    -48,    384,  -1344,   2976,   2976,   -480,   -480,    -48,    -48,    384, &
                  -480,    -48,  -3072,    384,    384,  -3072,   3840,    384,  24576,  -3072,   -372,   -426,     60,   -480, &
                     6,    -48,   -804,   3030,   2652,   -696,   -804,   2652,   -372,   2976,   -804,   -264,  -1344,    168, &
                    60,   -480,    114,   -318,   2976,   -372,    168,   -372,   -372,     60,     60,      6,   -264,   3084, &
                  -696,    816,   -264,   -696,   -318,   -372,   2652,   -696,    168,   -264,    600,     60,   -318,   -264, &
                  -372,   3084,      6,    -48,     60,      6,    384,    -48,   -426,   3408,   3030,   3084,   2976,   -372, &
                   114,   -426,   -804,   -264,   -372,   -318,   3840,   -480,   -480,     60,     60,    600,    -48,    384, &
                  -480,    -48,  -3072,    384,      6,    -48,   -426,   -372,   -480,     60,     60,      6,   -372,    168, &
                    60,   -372,    384,    -48,    -48,      6,      6,     60]
  K1(  24,:) = [  -1344,   2976,   2976,   -480,   -480,    -48,   2976,   3408,   -480,   3840,    -48,    384,   -480,    -48, &
                   -48,    384,    384,  -3072,   3840,    384,    384,  -3072,  -3072,  24576,    168,   -372,   -372,     60, &
                    60,      6,   -264,   3084,   -696,    816,   -264,   -696,   -318,   -372,   2652,   -696,    168,   -264, &
                   600,     60,   -318,   -264,   -372,   3084,   -372,   -426,     60,   -480,      6,    -48,   -804,   3030, &
                  2652,   -696,   -804,   2652,   -372,   2976,   -804,   -264,  -1344,    168,     60,   -480,    114,   -318, &
                  2976,   -372,     60,      6,      6,    -48,    -48,    384,    114,   -426,   -804,   -264,   -372,   -318, &
                  -426,   3408,   3030,   3084,   2976,   -372,   -480,   3840,     60,    600,   -480,     60,   -480,    -48, &
                   -48,    384,    384,  -3072,     60,      6,   -372,    168,     60,   -372,      6,    -48,   -426,   -372, &
                  -480,     60,    -48,    384,      6,     60,    -48,      6]
  K1(  25,:) = [  -3072,    384,    384,    -48,    -48,   -480,    384,    -48,    -48,      6,      6,     60,    -48,      6, &
                  -480,     60,   -426,   -372,      6,     60,     60,   -372,   -372,    168,  24576,  -3072,  -3072,    384, &
                   384,   3840,  -3072,    384,    384,    -48,    -48,   -480,    384,    -48,   3840,   -480,   3408,   2976, &
                   -48,   -480,   -480,   2976,   2976,  -1344,   3840,   -480,   -480,     60,     60,    600,    384,    -48, &
                   -48,      6,      6,     60,   2976,   -372,   3408,   -426,   3084,   3030,   -372,   -318,   -426,    114, &
                  -264,   -804,   -480,     60,   2976,   -372,    114,   -318,    -48,      6,   -480,     60,   -426,   -372, &
                 -1344,    168,   2976,   -372,   -264,   -804,   -804,   2652,   3030,   -804,   -696,   2652,     60,    600, &
                  -372,   3084,   -318,   -264,      6,     60,     60,   -372,   -372,    168,    168,   -264,   -372,   -318, &
                  -696,   2652,   -264,   -696,   3084,   -264,    816,   -696]
  K1(  26,:) = [    384,  -3072,    -48,   -480,    384,    -48,    -48,    384,      6,     60,    -48,      6,      6,     60, &
                    60,   -372,   -372,    168,    -48,      6,   -480,     60,   -426,   -372,  -3072,  24576,    384,   3840, &
                 -3072,    384,    384,  -3072,    -48,   -480,    384,    -48,    -48,   -480,   -480,   2976,   2976,  -1344, &
                   384,    -48,   3840,   -480,   3408,   2976,   -480,   3840,     60,    600,   -480,     60,    -48,    384, &
                     6,     60,    -48,      6,   -372,   -318,   -426,    114,   -264,   -804,   2976,   -372,   3408,   -426, &
                  3084,   3030,     60,    600,   -372,   3084,   -318,   -264,      6,     60,     60,   -372,   -372,    168, &
                   168,   -264,   -372,   -318,   -696,   2652,   -264,   -696,   3084,   -264,    816,   -696,   -480,     60, &
                  2976,   -372,    114,   -318,    -48,      6,   -480,     60,   -426,   -372,  -1344,    168,   2976,   -372, &
                  -264,   -804,   -804,   2652,   3030,   -804,   -696,   2652]
  K1(  27,:) = [    384,    -48,  -3072,    384,   -480,    -48,    -48,      6,   -480,     60,   -426,   -372,    384,    -48, &
                   -48,      6,      6,     60,     60,      6,   -372,    168,     60,   -372,  -3072,    384,  24576,  -3072, &
                  3840,    384,    384,    -48,   3840,   -480,   3408,   2976,  -3072,    384,    384,    -48,    -48,   -480, &
                  -480,    -48,   2976,  -1344,   -480,   2976,   -480,     60,   2976,   -372,    114,   -318,    -48,      6, &
                  -480,     60,   -426,   -372,  -1344,    168,   2976,   -372,   -264,   -804,   -804,   2652,   3030,   -804, &
                  -696,   2652,   3840,   -480,   -480,     60,     60,    600,    384,    -48,    -48,      6,      6,     60, &
                  2976,   -372,   3408,   -426,   3084,   3030,   -372,   -318,   -426,    114,   -264,   -804,    600,     60, &
                  -318,   -264,   -372,   3084,     60,      6,   -372,    168,     60,   -372,   -264,   -696,   3084,   -264, &
                   816,   -696,    168,   -264,   -372,   -318,   -696,   2652]
  K1(  28,:) = [    -48,   -480,    384,  -3072,    -48,    384,      6,     60,     60,   -372,   -372,    168,    -48,    384, &
                     6,     60,    -48,      6,      6,    -48,   -426,   -372,   -480,     60,    384,   3840,  -3072,  24576, &
                   384,  -3072,    -48,   -480,   -480,   2976,   2976,  -1344,    384,  -3072,    -48,   -480,    384,    -48, &
                   -48,    384,   3408,   2976,   3840,   -480,     60,    600,   -372,   3084,   -318,   -264,      6,     60, &
                    60,   -372,   -372,    168,    168,   -264,   -372,   -318,   -696,   2652,   -264,   -696,   3084,   -264, &
                   816,   -696,   -480,   3840,     60,    600,   -480,     60,    -48,    384,      6,     60,    -48,      6, &
                  -372,   -318,   -426,    114,   -264,   -804,   2976,   -372,   3408,   -426,   3084,   3030,     60,   -480, &
                   114,   -318,   2976,   -372,      6,    -48,   -426,   -372,   -480,     60,   -804,   2652,   3030,   -804, &
                  -696,   2652,  -1344,    168,   2976,   -372,   -264,   -804]
  K1(  29,:) = [    -48,    384,   -480,    -48,  -3072,    384,      6,    -48,   -426,   -372,   -480,     60,     60,      6, &
                  -372,    168,     60,   -372,    384,    -48,    -48,      6,      6,     60,    384,  -3072,   3840,    384, &
                 24576,  -3072,    -48,    384,   3408,   2976,   3840,   -480,   -480,    -48,   2976,  -1344,   -480,   2976, &
                 -3072,    384,    384,    -48,    -48,   -480,     60,   -480,    114,   -318,   2976,   -372,      6,    -48, &
                  -426,   -372,   -480,     60,   -804,   2652,   3030,   -804,   -696,   2652,  -1344,    168,   2976,   -372, &
                  -264,   -804,    600,     60,   -318,   -264,   -372,   3084,     60,      6,   -372,    168,     60,   -372, &
                  -264,   -696,   3084,   -264,    816,   -696,    168,   -264,   -372,   -318,   -696,   2652,   3840,   -480, &
                  -480,     60,     60,    600,    384,    -48,    -48,      6,      6,     60,   2976,   -372,   3408,   -426, &
                  3084,   3030,   -372,   -318,   -426,    114,   -264,   -804]
  K1(  30,:) = [   -480,    -48,    -48,    384,    384,  -3072,     60,      6,   -372,    168,     60,   -372,      6,    -48, &
                  -426,   -372,   -480,     60,    -48,    384,      6,     60,    -48,      6,   3840,    384,    384,  -3072, &
                 -3072,  24576,   -480,    -48,   2976,  -1344,   -480,   2976,    -48,    384,   3408,   2976,   3840,   -480, &
                   384,  -3072,    -48,   -480,    384,    -48,    600,     60,   -318,   -264,   -372,   3084,     60,      6, &
                  -372,    168,     60,   -372,   -264,   -696,   3084,   -264,    816,   -696,    168,   -264,   -372,   -318, &
                  -696,   2652,     60,   -480,    114,   -318,   2976,   -372,      6,    -48,   -426,   -372,   -480,     60, &
                  -804,   2652,   3030,   -804,   -696,   2652,  -1344,    168,   2976,   -372,   -264,   -804,   -480,   3840, &
                    60,    600,   -480,     60,    -48,    384,      6,     60,    -48,      6,   -372,   -318,   -426,    114, &
                  -264,   -804,   2976,   -372,   3408,   -426,   3084,   3030]
  K1(  31,:) = [    384,    -48,    -48,      6,      6,     60,   3840,   -480,   -480,     60,     60,    600,   3408,   -426, &
                  2976,   -372,   3030,   3084,   -426,    114,   -372,   -318,   -804,   -264,  -3072,    384,    384,    -48, &
                   -48,   -480,  24576,  -3072,  -3072,    384,    384,   3840,   3840,   -480,    384,    -48,   2976,   3408, &
                  -480,   2976,    -48,   -480,  -1344,   2976,    384,    -48,    -48,      6,      6,     60,  -3072,    384, &
                   384,    -48,    -48,   -480,   -480,     60,    -48,      6,   -372,   -426,     60,   -372,      6,     60, &
                   168,   -372,   2976,   -372,  -1344,    168,   -804,   -264,   -480,     60,    -48,      6,   -372,   -426, &
                  2976,   -372,   -480,     60,   -318,    114,   2652,   -696,   -804,   3030,   2652,   -804,   -372,   -318, &
                   168,   -264,   2652,   -696,     60,   -372,      6,     60,    168,   -372,   -372,   3084,     60,    600, &
                  -264,   -318,   -696,    816,   -264,   3084,   -696,   -264]
  K1(  32,:) = [    -48,    384,      6,     60,    -48,      6,   -480,   3840,     60,    600,   -480,     60,   -426,    114, &
                  -372,   -318,   -804,   -264,   3408,   -426,   2976,   -372,   3030,   3084,    384,  -3072,    -48,   -480, &
                   384,    -48,  -3072,  24576,    384,   3840,  -3072,    384,   -480,   2976,    -48,   -480,  -1344,   2976, &
                  3840,   -480,    384,    -48,   2976,   3408,    -48,    384,      6,     60,    -48,      6,    384,  -3072, &
                   -48,   -480,    384,    -48,     60,   -372,      6,     60,    168,   -372,   -480,     60,    -48,      6, &
                  -372,   -426,   -372,   -318,    168,   -264,   2652,   -696,     60,   -372,      6,     60,    168,   -372, &
                  -372,   3084,     60,    600,   -264,   -318,   -696,    816,   -264,   3084,   -696,   -264,   2976,   -372, &
                 -1344,    168,   -804,   -264,   -480,     60,    -48,      6,   -372,   -426,   2976,   -372,   -480,     60, &
                  -318,    114,   2652,   -696,   -804,   3030,   2652,   -804]
  K1(  33,:) = [    -48,      6,   -480,     60,   -426,   -372,   -480,     60,   2976,   -372,    114,   -318,   2976,   -372, &
                 -1344,    168,   -804,   -264,   3030,   -804,   -804,   2652,   2652,   -696,    384,    -48,   3840,   -480, &
                  3408,   2976,  -3072,    384,  24576,  -3072,   3840,    384,    384,    -48,  -3072,    384,   -480,    -48, &
                  2976,  -1344,   -480,    -48,   2976,   -480,    -48,      6,   -480,     60,   -426,   -372,    384,    -48, &
                 -3072,    384,   -480,    -48,    -48,      6,    384,    -48,     60,      6,   -372,    168,     60,      6, &
                  -372,     60,   3408,   -426,   2976,   -372,   3030,   3084,    -48,      6,    384,    -48,     60,      6, &
                  -480,     60,   3840,   -480,    600,     60,   -804,   -264,    114,   -426,   -318,   -372,   3084,   -264, &
                  -264,   -696,   -696,    816,   -372,    168,     60,      6,   -372,     60,   -318,   -264,    600,     60, &
                  3084,   -372,   2652,   -696,   -318,   -372,   -264,    168]
  K1(  34,:) = [      6,     60,     60,   -372,   -372,    168,     60,    600,   -372,   3084,   -318,   -264,   -372,   -318, &
                   168,   -264,   2652,   -696,   3084,   -264,   -264,   -696,   -696,    816,    -48,   -480,   -480,   2976, &
                  2976,  -1344,    384,   3840,  -3072,  24576,    384,  -3072,    -48,   -480,    384,  -3072,    -48,    384, &
                  3408,   2976,    -48,    384,   -480,   3840,      6,     60,     60,   -372,   -372,    168,    -48,   -480, &
                   384,  -3072,    -48,    384,      6,     60,    -48,    384,      6,    -48,   -426,   -372,      6,    -48, &
                    60,   -480,   -426,    114,   -372,   -318,   -804,   -264,      6,     60,    -48,    384,      6,    -48, &
                    60,    600,   -480,   3840,     60,   -480,   3030,   3084,   -426,   3408,   -372,   2976,   3030,   -804, &
                  -804,   2652,   2652,   -696,   -426,   -372,      6,    -48,     60,   -480,    114,   -318,     60,   -480, &
                  -372,   2976,   -804,   -264,   -372,   2976,    168,  -1344]
  K1(  35,:) = [      6,    -48,   -426,   -372,   -480,     60,     60,   -480,    114,   -318,   2976,   -372,   3030,   -804, &
                  -804,   2652,   2652,   -696,   2976,   -372,  -1344,    168,   -804,   -264,    -48,    384,   3408,   2976, &
                  3840,   -480,    384,  -3072,   3840,    384,  24576,  -3072,   2976,  -1344,   -480,    -48,   2976,   -480, &
                   384,    -48,  -3072,    384,   -480,    -48,      6,    -48,   -426,   -372,   -480,     60,    -48,    384, &
                  -480,    -48,  -3072,    384,   -372,    168,     60,      6,   -372,     60,    -48,      6,    384,    -48, &
                    60,      6,   3084,   -264,   -264,   -696,   -696,    816,   -372,    168,     60,      6,   -372,     60, &
                  -318,   -264,    600,     60,   3084,   -372,   2652,   -696,   -318,   -372,   -264,    168,   3408,   -426, &
                  2976,   -372,   3030,   3084,    -48,      6,    384,    -48,     60,      6,   -480,     60,   3840,   -480, &
                   600,     60,   -804,   -264,    114,   -426,   -318,   -372]
  K1(  36,:) = [     60,      6,   -372,    168,     60,   -372,    600,     60,   -318,   -264,   -372,   3084,   3084,   -264, &
                  -264,   -696,   -696,    816,   -372,   -318,    168,   -264,   2652,   -696,   -480,    -48,   2976,  -1344, &
                  -480,   2976,   3840,    384,    384,  -3072,  -3072,  24576,   3408,   2976,    -48,    384,   -480,   3840, &
                   -48,   -480,    384,  -3072,    -48,    384,     60,      6,   -372,    168,     60,   -372,   -480,    -48, &
                   -48,    384,    384,  -3072,   -426,   -372,      6,    -48,     60,   -480,      6,     60,    -48,    384, &
                     6,    -48,   3030,   -804,   -804,   2652,   2652,   -696,   -426,   -372,      6,    -48,     60,   -480, &
                   114,   -318,     60,   -480,   -372,   2976,   -804,   -264,   -372,   2976,    168,  -1344,   -426,    114, &
                  -372,   -318,   -804,   -264,      6,     60,    -48,    384,      6,    -48,     60,    600,   -480,   3840, &
                    60,   -480,   3030,   3084,   -426,   3408,   -372,   2976]
  K1(  37,:) = [    -48,      6,    384,    -48,     60,      6,   3408,   -426,   2976,   -372,   3030,   3084,   3840,   -480, &
                  -480,     60,     60,    600,    114,   -426,   -804,   -264,   -372,   -318,    384,    -48,  -3072,    384, &
                  -480,    -48,   3840,   -480,    384,    -48,   2976,   3408,  24576,  -3072,  -3072,    384,    384,   3840, &
                  2976,   -480,  -1344,   2976,    -48,   -480,   2976,   -372,  -1344,    168,   -804,   -264,   -480,     60, &
                   -48,      6,   -372,   -426,   2976,   -372,   -480,     60,   -318,    114,   2652,   -696,   -804,   3030, &
                  2652,   -804,    384,    -48,    -48,      6,      6,     60,  -3072,    384,    384,    -48,    -48,   -480, &
                  -480,     60,    -48,      6,   -372,   -426,     60,   -372,      6,     60,    168,   -372,   -318,   -372, &
                  2652,   -696,    168,   -264,   -372,     60,    168,   -372,      6,     60,   -696,    816,   -264,   3084, &
                  -696,   -264,   -372,   3084,     60,    600,   -264,   -318]
  K1(  38,:) = [      6,     60,    -48,    384,      6,    -48,   -426,    114,   -372,   -318,   -804,   -264,   -480,   3840, &
                    60,    600,   -480,     60,   -426,   3408,   3030,   3084,   2976,   -372,    -48,   -480,    384,  -3072, &
                   -48,    384,   -480,   2976,    -48,   -480,  -1344,   2976,  -3072,  24576,    384,   3840,  -3072,    384, &
                  -480,   3840,   2976,   3408,    384,    -48,   -372,   -318,    168,   -264,   2652,   -696,     60,   -372, &
                     6,     60,    168,   -372,   -372,   3084,     60,    600,   -264,   -318,   -696,    816,   -264,   3084, &
                  -696,   -264,    -48,    384,      6,     60,    -48,      6,    384,  -3072,    -48,   -480,    384,    -48, &
                    60,   -372,      6,     60,    168,   -372,   -480,     60,    -48,      6,   -372,   -426,   -372,   2976, &
                  -804,   -264,  -1344,    168,     60,   -480,   -372,   -426,    -48,      6,   2652,   -696,   -804,   3030, &
                  2652,   -804,   2976,   -372,   -480,     60,   -318,    114]
  K1(  39,:) = [   -480,     60,    -48,      6,   -372,   -426,   2976,   -372,  -1344,    168,   -804,   -264,   -480,     60, &
                  2976,   -372,    114,   -318,   -804,   3030,   2652,   -696,   -804,   2652,   3840,   -480,    384,    -48, &
                  2976,   3408,    384,    -48,  -3072,    384,   -480,    -48,  -3072,    384,  24576,  -3072,   3840,    384, &
                 -1344,   2976,   2976,   -480,   -480,    -48,   3408,   -426,   2976,   -372,   3030,   3084,    -48,      6, &
                   384,    -48,     60,      6,   -480,     60,   3840,   -480,    600,     60,   -804,   -264,    114,   -426, &
                  -318,   -372,    -48,      6,   -480,     60,   -426,   -372,    384,    -48,  -3072,    384,   -480,    -48, &
                   -48,      6,    384,    -48,     60,      6,   -372,    168,     60,      6,   -372,     60,   -264,   3084, &
                  -696,    816,   -264,   -696,    168,   -372,   -372,     60,     60,      6,   2652,   -696,   -318,   -372, &
                  -264,    168,   -318,   -264,    600,     60,   3084,   -372]
  K1(  40,:) = [     60,   -372,      6,     60,    168,   -372,   -372,   -318,    168,   -264,   2652,   -696,     60,    600, &
                  -372,   3084,   -318,   -264,   -264,   3084,   -696,    816,   -264,   -696,   -480,   2976,    -48,   -480, &
                 -1344,   2976,    -48,   -480,    384,  -3072,    -48,    384,    384,   3840,  -3072,  24576,    384,  -3072, &
                  2976,   3408,   -480,   3840,    -48,    384,   -426,    114,   -372,   -318,   -804,   -264,      6,     60, &
                   -48,    384,      6,    -48,     60,    600,   -480,   3840,     60,   -480,   3030,   3084,   -426,   3408, &
                  -372,   2976,      6,     60,     60,   -372,   -372,    168,    -48,   -480,    384,  -3072,    -48,    384, &
                     6,     60,    -48,    384,      6,    -48,   -426,   -372,      6,    -48,     60,   -480,   -804,   3030, &
                  2652,   -696,   -804,   2652,   -372,   -426,     60,   -480,      6,    -48,   -804,   -264,   -372,   2976, &
                   168,  -1344,    114,   -318,     60,   -480,   -372,   2976]
  K1(  41,:) = [   -426,   -372,      6,    -48,     60,   -480,   3030,   -804,   -804,   2652,   2652,   -696,     60,   -480, &
                   114,   -318,   2976,   -372,   -372,   2976,   -804,   -264,  -1344,    168,   3408,   2976,    -48,    384, &
                  -480,   3840,   2976,  -1344,   -480,    -48,   2976,   -480,    384,  -3072,   3840,    384,  24576,  -3072, &
                   -48,    384,   -480,    -48,  -3072,    384,   3084,   -264,   -264,   -696,   -696,    816,   -372,    168, &
                    60,      6,   -372,     60,   -318,   -264,    600,     60,   3084,   -372,   2652,   -696,   -318,   -372, &
                  -264,    168,      6,    -48,   -426,   -372,   -480,     60,    -48,    384,   -480,    -48,  -3072,    384, &
                  -372,    168,     60,      6,   -372,     60,    -48,      6,    384,    -48,     60,      6,   -426,   3408, &
                  3030,   3084,   2976,   -372,      6,    -48,     60,      6,    384,    -48,   -804,   -264,    114,   -426, &
                  -318,   -372,   -480,     60,   3840,   -480,    600,     60]
  K1(  42,:) = [   -372,    168,     60,      6,   -372,     60,   3084,   -264,   -264,   -696,   -696,    816,    600,     60, &
                  -318,   -264,   -372,   3084,   -318,   -372,   2652,   -696,    168,   -264,   2976,  -1344,   -480,    -48, &
                  2976,   -480,   3408,   2976,    -48,    384,   -480,   3840,   3840,    384,    384,  -3072,  -3072,  24576, &
                  -480,    -48,    -48,    384,    384,  -3072,   3030,   -804,   -804,   2652,   2652,   -696,   -426,   -372, &
                     6,    -48,     60,   -480,    114,   -318,     60,   -480,   -372,   2976,   -804,   -264,   -372,   2976, &
                   168,  -1344,     60,      6,   -372,    168,     60,   -372,   -480,    -48,    -48,    384,    384,  -3072, &
                  -426,   -372,      6,    -48,     60,   -480,      6,     60,    -48,    384,      6,    -48,    114,   -426, &
                  -804,   -264,   -372,   -318,     60,      6,      6,    -48,    -48,    384,   3030,   3084,   -426,   3408, &
                  -372,   2976,     60,    600,   -480,   3840,     60,   -480]
  K1(  43,:) = [      6,    -48,     60,      6,    384,    -48,   -426,   3408,   3030,   3084,   2976,   -372,    114,   -426, &
                  -804,   -264,   -372,   -318,   3840,   -480,   -480,     60,     60,    600,    -48,    384,   -480,    -48, &
                 -3072,    384,   -480,   3840,   2976,   3408,    384,    -48,   2976,   -480,  -1344,   2976,    -48,   -480, &
                 24576,  -3072,  -3072,    384,    384,   3840,   -372,   2976,   -804,   -264,  -1344,    168,     60,   -480, &
                  -372,   -426,    -48,      6,   2652,   -696,   -804,   3030,   2652,   -804,   2976,   -372,   -480,     60, &
                  -318,    114,   -318,   -372,   2652,   -696,    168,   -264,   -372,     60,    168,   -372,      6,     60, &
                  -696,    816,   -264,   3084,   -696,   -264,   -372,   3084,     60,    600,   -264,   -318,    384,    -48, &
                   -48,      6,      6,     60,  -3072,    384,    384,    -48,    -48,   -480,   -480,     60,    -48,      6, &
                  -372,   -426,     60,   -372,      6,     60,    168,   -372]
  K1(  44,:) = [     60,      6,      6,    -48,    -48,    384,    114,   -426,   -804,   -264,   -372,   -318,   -426,   3408, &
                  3030,   3084,   2976,   -372,   -480,   3840,     60,    600,   -480,     60,   -480,    -48,    -48,    384, &
                   384,  -3072,   2976,   -480,  -1344,   2976,    -48,   -480,   -480,   3840,   2976,   3408,    384,    -48, &
                 -3072,  24576,    384,   3840,  -3072,    384,   -318,   -372,   2652,   -696,    168,   -264,   -372,     60, &
                   168,   -372,      6,     60,   -696,    816,   -264,   3084,   -696,   -264,   -372,   3084,     60,    600, &
                  -264,   -318,   -372,   2976,   -804,   -264,  -1344,    168,     60,   -480,   -372,   -426,    -48,      6, &
                  2652,   -696,   -804,   3030,   2652,   -804,   2976,   -372,   -480,     60,   -318,    114,    -48,    384, &
                     6,     60,    -48,      6,    384,  -3072,    -48,   -480,    384,    -48,     60,   -372,      6,     60, &
                   168,   -372,   -480,     60,    -48,      6,   -372,   -426]
  K1(  45,:) = [     60,   -480,   -372,   -426,    -48,      6,   -372,   2976,   -804,   -264,  -1344,    168,   -804,   3030, &
                  2652,   -696,   -804,   2652,   -480,     60,   2976,   -372,    114,   -318,   -480,   3840,   2976,   3408, &
                   384,    -48,    -48,    384,   -480,    -48,  -3072,    384,  -1344,   2976,   2976,   -480,   -480,    -48, &
                 -3072,    384,  24576,  -3072,   3840,    384,   -426,   3408,   3030,   3084,   2976,   -372,      6,    -48, &
                    60,      6,    384,    -48,   -804,   -264,    114,   -426,   -318,   -372,   -480,     60,   3840,   -480, &
                   600,     60,   -264,   3084,   -696,    816,   -264,   -696,    168,   -372,   -372,     60,     60,      6, &
                  2652,   -696,   -318,   -372,   -264,    168,   -318,   -264,    600,     60,   3084,   -372,    -48,      6, &
                  -480,     60,   -426,   -372,    384,    -48,  -3072,    384,   -480,    -48,    -48,      6,    384,    -48, &
                    60,      6,   -372,    168,     60,      6,   -372,     60]
  K1(  46,:) = [   -372,     60,    168,   -372,      6,     60,   -318,   -372,   2652,   -696,    168,   -264,   -264,   3084, &
                  -696,    816,   -264,   -696,     60,    600,   -372,   3084,   -318,   -264,   2976,   -480,  -1344,   2976, &
                   -48,   -480,   -480,    -48,    -48,    384,    384,  -3072,   2976,   3408,   -480,   3840,    -48,    384, &
                   384,   3840,  -3072,  24576,    384,  -3072,    114,   -426,   -804,   -264,   -372,   -318,     60,      6, &
                     6,    -48,    -48,    384,   3030,   3084,   -426,   3408,   -372,   2976,     60,    600,   -480,   3840, &
                    60,   -480,   -804,   3030,   2652,   -696,   -804,   2652,   -372,   -426,     60,   -480,      6,    -48, &
                  -804,   -264,   -372,   2976,    168,  -1344,    114,   -318,     60,   -480,   -372,   2976,      6,     60, &
                    60,   -372,   -372,    168,    -48,   -480,    384,  -3072,    -48,    384,      6,     60,    -48,    384, &
                     6,    -48,   -426,   -372,      6,    -48,     60,   -480]
  K1(  47,:) = [   -372,   -426,     60,   -480,      6,    -48,   -804,   3030,   2652,   -696,   -804,   2652,   -372,   2976, &
                  -804,   -264,  -1344,    168,     60,   -480,    114,   -318,   2976,   -372,   2976,   3408,   -480,   3840, &
                   -48,    384,  -1344,   2976,   2976,   -480,   -480,    -48,    -48,    384,   -480,    -48,  -3072,    384, &
                   384,  -3072,   3840,    384,  24576,  -3072,   -264,   3084,   -696,    816,   -264,   -696,    168,   -372, &
                  -372,     60,     60,      6,   2652,   -696,   -318,   -372,   -264,    168,   -318,   -264,    600,     60, &
                  3084,   -372,   -426,   3408,   3030,   3084,   2976,   -372,      6,    -48,     60,      6,    384,    -48, &
                  -804,   -264,    114,   -426,   -318,   -372,   -480,     60,   3840,   -480,    600,     60,      6,    -48, &
                  -426,   -372,   -480,     60,    -48,    384,   -480,    -48,  -3072,    384,   -372,    168,     60,      6, &
                  -372,     60,    -48,      6,    384,    -48,     60,      6]
  K1(  48,:) = [    168,   -372,   -372,     60,     60,      6,   -264,   3084,   -696,    816,   -264,   -696,   -318,   -372, &
                  2652,   -696,    168,   -264,    600,     60,   -318,   -264,   -372,   3084,  -1344,   2976,   2976,   -480, &
                  -480,    -48,   2976,   3408,   -480,   3840,    -48,    384,   -480,    -48,    -48,    384,    384,  -3072, &
                  3840,    384,    384,  -3072,  -3072,  24576,   -804,   3030,   2652,   -696,   -804,   2652,   -372,   -426, &
                    60,   -480,      6,    -48,   -804,   -264,   -372,   2976,    168,  -1344,    114,   -318,     60,   -480, &
                  -372,   2976,    114,   -426,   -804,   -264,   -372,   -318,     60,      6,      6,    -48,    -48,    384, &
                  3030,   3084,   -426,   3408,   -372,   2976,     60,    600,   -480,   3840,     60,   -480,     60,      6, &
                  -372,    168,     60,   -372,   -480,    -48,    -48,    384,    384,  -3072,   -426,   -372,      6,    -48, &
                    60,   -480,      6,     60,    -48,    384,      6,    -48]
  K1(  49,:) = [    384,    -48,    -48,      6,      6,     60,  -3072,    384,    384,    -48,    -48,   -480,   -480,     60, &
                   -48,      6,   -372,   -426,     60,   -372,      6,     60,    168,   -372,   3840,   -480,   -480,     60, &
                    60,    600,    384,    -48,    -48,      6,      6,     60,   2976,   -372,   3408,   -426,   3084,   3030, &
                  -372,   -318,   -426,    114,   -264,   -804,  24576,  -3072,  -3072,    384,    384,   3840,  -3072,    384, &
                   384,    -48,    -48,   -480,    384,    -48,   3840,   -480,   3408,   2976,    -48,   -480,   -480,   2976, &
                  2976,  -1344,   2976,   -372,   -480,     60,   -318,    114,  -1344,    168,   2976,   -372,   -264,   -804, &
                   -48,      6,   -480,     60,   -426,   -372,   2652,   -804,   -696,   2652,   3030,   -804,   -372,   3084, &
                    60,    600,   -264,   -318,    168,   -264,   -372,   -318,   -696,   2652,      6,     60,     60,   -372, &
                  -372,    168,   -696,   -264,    816,   -696,   3084,   -264]
  K1(  50,:) = [    -48,    384,      6,     60,    -48,      6,    384,  -3072,    -48,   -480,    384,    -48,     60,   -372, &
                     6,     60,    168,   -372,   -480,     60,    -48,      6,   -372,   -426,   -480,   3840,     60,    600, &
                  -480,     60,    -48,    384,      6,     60,    -48,      6,   -372,   -318,   -426,    114,   -264,   -804, &
                  2976,   -372,   3408,   -426,   3084,   3030,  -3072,  24576,    384,   3840,  -3072,    384,    384,  -3072, &
                   -48,   -480,    384,    -48,    -48,   -480,   -480,   2976,   2976,  -1344,    384,    -48,   3840,   -480, &
                  3408,   2976,   -372,   3084,     60,    600,   -264,   -318,    168,   -264,   -372,   -318,   -696,   2652, &
                     6,     60,     60,   -372,   -372,    168,   -696,   -264,    816,   -696,   3084,   -264,   2976,   -372, &
                  -480,     60,   -318,    114,  -1344,    168,   2976,   -372,   -264,   -804,    -48,      6,   -480,     60, &
                  -426,   -372,   2652,   -804,   -696,   2652,   3030,   -804]
  K1(  51,:) = [    -48,      6,   -480,     60,   -426,   -372,    384,    -48,  -3072,    384,   -480,    -48,    -48,      6, &
                   384,    -48,     60,      6,   -372,    168,     60,      6,   -372,     60,   -480,     60,   2976,   -372, &
                   114,   -318,    -48,      6,   -480,     60,   -426,   -372,  -1344,    168,   2976,   -372,   -264,   -804, &
                  -804,   2652,   3030,   -804,   -696,   2652,  -3072,    384,  24576,  -3072,   3840,    384,    384,    -48, &
                  3840,   -480,   3408,   2976,  -3072,    384,    384,    -48,    -48,   -480,   -480,    -48,   2976,  -1344, &
                  -480,   2976,   -480,     60,   3840,   -480,    600,     60,   2976,   -372,   3408,   -426,   3084,   3030, &
                   384,    -48,    -48,      6,      6,     60,   -318,   -372,   -264,   -804,   -426,    114,   -318,   -264, &
                   600,     60,   3084,   -372,   -264,   -696,   3084,   -264,    816,   -696,     60,      6,   -372,    168, &
                    60,   -372,   -264,    168,   -696,   2652,   -372,   -318]
  K1(  52,:) = [      6,     60,     60,   -372,   -372,    168,    -48,   -480,    384,  -3072,    -48,    384,      6,     60, &
                   -48,    384,      6,    -48,   -426,   -372,      6,    -48,     60,   -480,     60,    600,   -372,   3084, &
                  -318,   -264,      6,     60,     60,   -372,   -372,    168,    168,   -264,   -372,   -318,   -696,   2652, &
                  -264,   -696,   3084,   -264,    816,   -696,    384,   3840,  -3072,  24576,    384,  -3072,    -48,   -480, &
                  -480,   2976,   2976,  -1344,    384,  -3072,    -48,   -480,    384,    -48,    -48,    384,   3408,   2976, &
                  3840,   -480,     60,    600,   -480,   3840,     60,   -480,   -372,   -318,   -426,    114,   -264,   -804, &
                   -48,    384,      6,     60,    -48,      6,   -372,   2976,   3084,   3030,   3408,   -426,    114,   -318, &
                    60,   -480,   -372,   2976,   -804,   2652,   3030,   -804,   -696,   2652,      6,    -48,   -426,   -372, &
                  -480,     60,    168,  -1344,   -264,   -804,   2976,   -372]
  K1(  53,:) = [      6,    -48,   -426,   -372,   -480,     60,    -48,    384,   -480,    -48,  -3072,    384,   -372,    168, &
                    60,      6,   -372,     60,    -48,      6,    384,    -48,     60,      6,     60,   -480,    114,   -318, &
                  2976,   -372,      6,    -48,   -426,   -372,   -480,     60,   -804,   2652,   3030,   -804,   -696,   2652, &
                 -1344,    168,   2976,   -372,   -264,   -804,    384,  -3072,   3840,    384,  24576,  -3072,    -48,    384, &
                  3408,   2976,   3840,   -480,   -480,    -48,   2976,  -1344,   -480,   2976,  -3072,    384,    384,    -48, &
                   -48,   -480,   -318,   -264,    600,     60,   3084,   -372,   -264,   -696,   3084,   -264,    816,   -696, &
                    60,      6,   -372,    168,     60,   -372,   -264,    168,   -696,   2652,   -372,   -318,   -480,     60, &
                  3840,   -480,    600,     60,   2976,   -372,   3408,   -426,   3084,   3030,    384,    -48,    -48,      6, &
                     6,     60,   -318,   -372,   -264,   -804,   -426,    114]
  K1(  54,:) = [     60,      6,   -372,    168,     60,   -372,   -480,    -48,    -48,    384,    384,  -3072,   -426,   -372, &
                     6,    -48,     60,   -480,      6,     60,    -48,    384,      6,    -48,    600,     60,   -318,   -264, &
                  -372,   3084,     60,      6,   -372,    168,     60,   -372,   -264,   -696,   3084,   -264,    816,   -696, &
                   168,   -264,   -372,   -318,   -696,   2652,   3840,    384,    384,  -3072,  -3072,  24576,   -480,    -48, &
                  2976,  -1344,   -480,   2976,    -48,    384,   3408,   2976,   3840,   -480,    384,  -3072,    -48,   -480, &
                   384,    -48,    114,   -318,     60,   -480,   -372,   2976,   -804,   2652,   3030,   -804,   -696,   2652, &
                     6,    -48,   -426,   -372,   -480,     60,    168,  -1344,   -264,   -804,   2976,   -372,     60,    600, &
                  -480,   3840,     60,   -480,   -372,   -318,   -426,    114,   -264,   -804,    -48,    384,      6,     60, &
                   -48,      6,   -372,   2976,   3084,   3030,   3408,   -426]
  K1(  55,:) = [   3840,   -480,   -480,     60,     60,    600,    384,    -48,    -48,      6,      6,     60,   2976,   -372, &
                  3408,   -426,   3084,   3030,   -372,   -318,   -426,    114,   -264,   -804,    384,    -48,    -48,      6, &
                     6,     60,  -3072,    384,    384,    -48,    -48,   -480,   -480,     60,    -48,      6,   -372,   -426, &
                    60,   -372,      6,     60,    168,   -372,  -3072,    384,    384,    -48,    -48,   -480,  24576,  -3072, &
                 -3072,    384,    384,   3840,   3840,   -480,    384,    -48,   2976,   3408,   -480,   2976,    -48,   -480, &
                 -1344,   2976,  -1344,    168,   2976,   -372,   -264,   -804,   2976,   -372,   -480,     60,   -318,    114, &
                  -480,     60,    -48,      6,   -372,   -426,   -696,   2652,   2652,   -804,   -804,   3030,    168,   -264, &
                  -372,   -318,   -696,   2652,   -372,   3084,     60,    600,   -264,   -318,     60,   -372,      6,     60, &
                   168,   -372,    816,   -696,   -696,   -264,   -264,   3084]
  K1(  56,:) = [   -480,   3840,     60,    600,   -480,     60,    -48,    384,      6,     60,    -48,      6,   -372,   -318, &
                  -426,    114,   -264,   -804,   2976,   -372,   3408,   -426,   3084,   3030,    -48,    384,      6,     60, &
                   -48,      6,    384,  -3072,    -48,   -480,    384,    -48,     60,   -372,      6,     60,    168,   -372, &
                  -480,     60,    -48,      6,   -372,   -426,    384,  -3072,    -48,   -480,    384,    -48,  -3072,  24576, &
                   384,   3840,  -3072,    384,   -480,   2976,    -48,   -480,  -1344,   2976,   3840,   -480,    384,    -48, &
                  2976,   3408,    168,   -264,   -372,   -318,   -696,   2652,   -372,   3084,     60,    600,   -264,   -318, &
                    60,   -372,      6,     60,    168,   -372,    816,   -696,   -696,   -264,   -264,   3084,  -1344,    168, &
                  2976,   -372,   -264,   -804,   2976,   -372,   -480,     60,   -318,    114,   -480,     60,    -48,      6, &
                  -372,   -426,   -696,   2652,   2652,   -804,   -804,   3030]
  K1(  57,:) = [   -480,     60,   2976,   -372,    114,   -318,    -48,      6,   -480,     60,   -426,   -372,  -1344,    168, &
                  2976,   -372,   -264,   -804,   -804,   2652,   3030,   -804,   -696,   2652,    -48,      6,   -480,     60, &
                  -426,   -372,    384,    -48,  -3072,    384,   -480,    -48,    -48,      6,    384,    -48,     60,      6, &
                  -372,    168,     60,      6,   -372,     60,    384,    -48,   3840,   -480,   3408,   2976,  -3072,    384, &
                 24576,  -3072,   3840,    384,    384,    -48,  -3072,    384,   -480,    -48,   2976,  -1344,   -480,    -48, &
                  2976,   -480,   2976,   -372,   3408,   -426,   3084,   3030,   -480,     60,   3840,   -480,    600,     60, &
                   -48,      6,    384,    -48,     60,      6,   -264,   -804,   -318,   -372,    114,   -426,   -264,   -696, &
                  3084,   -264,    816,   -696,   -318,   -264,    600,     60,   3084,   -372,   -372,    168,     60,      6, &
                  -372,     60,   -696,   2652,   -264,    168,   -318,   -372]
  K1(  58,:) = [     60,    600,   -372,   3084,   -318,   -264,      6,     60,     60,   -372,   -372,    168,    168,   -264, &
                  -372,   -318,   -696,   2652,   -264,   -696,   3084,   -264,    816,   -696,      6,     60,     60,   -372, &
                  -372,    168,    -48,   -480,    384,  -3072,    -48,    384,      6,     60,    -48,    384,      6,    -48, &
                  -426,   -372,      6,    -48,     60,   -480,    -48,   -480,   -480,   2976,   2976,  -1344,    384,   3840, &
                 -3072,  24576,    384,  -3072,    -48,   -480,    384,  -3072,    -48,    384,   3408,   2976,    -48,    384, &
                  -480,   3840,   -372,   -318,   -426,    114,   -264,   -804,     60,    600,   -480,   3840,     60,   -480, &
                     6,     60,    -48,    384,      6,    -48,   3084,   3030,   -372,   2976,   -426,   3408,   -804,   2652, &
                  3030,   -804,   -696,   2652,    114,   -318,     60,   -480,   -372,   2976,   -426,   -372,      6,    -48, &
                    60,   -480,   -264,   -804,    168,  -1344,   -372,   2976]
  K1(  59,:) = [     60,   -480,    114,   -318,   2976,   -372,      6,    -48,   -426,   -372,   -480,     60,   -804,   2652, &
                  3030,   -804,   -696,   2652,  -1344,    168,   2976,   -372,   -264,   -804,      6,    -48,   -426,   -372, &
                  -480,     60,    -48,    384,   -480,    -48,  -3072,    384,   -372,    168,     60,      6,   -372,     60, &
                   -48,      6,    384,    -48,     60,      6,    -48,    384,   3408,   2976,   3840,   -480,    384,  -3072, &
                  3840,    384,  24576,  -3072,   2976,  -1344,   -480,    -48,   2976,   -480,    384,    -48,  -3072,    384, &
                  -480,    -48,   -264,   -696,   3084,   -264,    816,   -696,   -318,   -264,    600,     60,   3084,   -372, &
                  -372,    168,     60,      6,   -372,     60,   -696,   2652,   -264,    168,   -318,   -372,   2976,   -372, &
                  3408,   -426,   3084,   3030,   -480,     60,   3840,   -480,    600,     60,    -48,      6,    384,    -48, &
                    60,      6,   -264,   -804,   -318,   -372,    114,   -426]
  K1(  60,:) = [    600,     60,   -318,   -264,   -372,   3084,     60,      6,   -372,    168,     60,   -372,   -264,   -696, &
                  3084,   -264,    816,   -696,    168,   -264,   -372,   -318,   -696,   2652,     60,      6,   -372,    168, &
                    60,   -372,   -480,    -48,    -48,    384,    384,  -3072,   -426,   -372,      6,    -48,     60,   -480, &
                     6,     60,    -48,    384,      6,    -48,   -480,    -48,   2976,  -1344,   -480,   2976,   3840,    384, &
                   384,  -3072,  -3072,  24576,   3408,   2976,    -48,    384,   -480,   3840,    -48,   -480,    384,  -3072, &
                   -48,    384,   -804,   2652,   3030,   -804,   -696,   2652,    114,   -318,     60,   -480,   -372,   2976, &
                  -426,   -372,      6,    -48,     60,   -480,   -264,   -804,    168,  -1344,   -372,   2976,   -372,   -318, &
                  -426,    114,   -264,   -804,     60,    600,   -480,   3840,     60,   -480,      6,     60,    -48,    384, &
                     6,    -48,   3084,   3030,   -372,   2976,   -426,   3408]
  K1(  61,:) = [   3408,   -426,   2976,   -372,   3030,   3084,    -48,      6,    384,    -48,     60,      6,   -480,     60, &
                  3840,   -480,    600,     60,   -804,   -264,    114,   -426,   -318,   -372,   2976,   -372,  -1344,    168, &
                  -804,   -264,   -480,     60,    -48,      6,   -372,   -426,   2976,   -372,   -480,     60,   -318,    114, &
                  2652,   -696,   -804,   3030,   2652,   -804,    384,    -48,  -3072,    384,   -480,    -48,   3840,   -480, &
                   384,    -48,   2976,   3408,  24576,  -3072,  -3072,    384,    384,   3840,   2976,   -480,  -1344,   2976, &
                   -48,   -480,    -48,      6,    384,    -48,     60,      6,   -480,     60,    -48,      6,   -372,   -426, &
                 -3072,    384,    384,    -48,    -48,   -480,   -372,     60,    168,   -372,      6,     60,   2652,   -696, &
                  -318,   -372,   -264,    168,   -696,    816,   -264,   3084,   -696,   -264,   -372,     60,    168,   -372, &
                     6,     60,   3084,   -372,   -264,   -318,     60,    600]
  K1(  62,:) = [   -426,    114,   -372,   -318,   -804,   -264,      6,     60,    -48,    384,      6,    -48,     60,    600, &
                  -480,   3840,     60,   -480,   3030,   3084,   -426,   3408,   -372,   2976,   -372,   -318,    168,   -264, &
                  2652,   -696,     60,   -372,      6,     60,    168,   -372,   -372,   3084,     60,    600,   -264,   -318, &
                  -696,    816,   -264,   3084,   -696,   -264,    -48,   -480,    384,  -3072,    -48,    384,   -480,   2976, &
                   -48,   -480,  -1344,   2976,  -3072,  24576,    384,   3840,  -3072,    384,   -480,   3840,   2976,   3408, &
                   384,    -48,      6,     60,    -48,    384,      6,    -48,     60,   -372,      6,     60,    168,   -372, &
                   384,  -3072,    -48,   -480,    384,    -48,     60,   -480,   -372,   -426,    -48,      6,   -804,   -264, &
                  -372,   2976,    168,  -1344,   2652,   -696,   -804,   3030,   2652,   -804,     60,   -480,   -372,   -426, &
                   -48,      6,   -372,   2976,   -318,    114,   -480,     60]
  K1(  63,:) = [   2976,   -372,  -1344,    168,   -804,   -264,   -480,     60,    -48,      6,   -372,   -426,   2976,   -372, &
                  -480,     60,   -318,    114,   2652,   -696,   -804,   3030,   2652,   -804,   3408,   -426,   2976,   -372, &
                  3030,   3084,    -48,      6,    384,    -48,     60,      6,   -480,     60,   3840,   -480,    600,     60, &
                  -804,   -264,    114,   -426,   -318,   -372,   3840,   -480,    384,    -48,   2976,   3408,    384,    -48, &
                 -3072,    384,   -480,    -48,  -3072,    384,  24576,  -3072,   3840,    384,  -1344,   2976,   2976,   -480, &
                  -480,    -48,   -480,     60,    -48,      6,   -372,   -426,    -48,      6,    384,    -48,     60,      6, &
                   384,    -48,  -3072,    384,   -480,    -48,    168,   -372,   -372,     60,     60,      6,   -696,    816, &
                  -264,   3084,   -696,   -264,   2652,   -696,   -318,   -372,   -264,    168,    168,   -372,   -372,     60, &
                    60,      6,   -264,   -318,   3084,   -372,    600,     60]
  K1(  64,:) = [   -372,   -318,    168,   -264,   2652,   -696,     60,   -372,      6,     60,    168,   -372,   -372,   3084, &
                    60,    600,   -264,   -318,   -696,    816,   -264,   3084,   -696,   -264,   -426,    114,   -372,   -318, &
                  -804,   -264,      6,     60,    -48,    384,      6,    -48,     60,    600,   -480,   3840,     60,   -480, &
                  3030,   3084,   -426,   3408,   -372,   2976,   -480,   2976,    -48,   -480,  -1344,   2976,    -48,   -480, &
                   384,  -3072,    -48,    384,    384,   3840,  -3072,  24576,    384,  -3072,   2976,   3408,   -480,   3840, &
                   -48,    384,     60,   -372,      6,     60,    168,   -372,      6,     60,    -48,    384,      6,    -48, &
                   -48,   -480,    384,  -3072,    -48,    384,   -372,   -426,     60,   -480,      6,    -48,   2652,   -696, &
                  -804,   3030,   2652,   -804,   -804,   -264,   -372,   2976,    168,  -1344,   -372,   -426,     60,   -480, &
                     6,    -48,   -318,    114,   -372,   2976,     60,   -480]
  K1(  65,:) = [   3030,   -804,   -804,   2652,   2652,   -696,   -426,   -372,      6,    -48,     60,   -480,    114,   -318, &
                    60,   -480,   -372,   2976,   -804,   -264,   -372,   2976,    168,  -1344,   3084,   -264,   -264,   -696, &
                  -696,    816,   -372,    168,     60,      6,   -372,     60,   -318,   -264,    600,     60,   3084,   -372, &
                  2652,   -696,   -318,   -372,   -264,    168,   3408,   2976,    -48,    384,   -480,   3840,   2976,  -1344, &
                  -480,    -48,   2976,   -480,    384,  -3072,   3840,    384,  24576,  -3072,    -48,    384,   -480,    -48, &
                 -3072,    384,   -426,   -372,      6,    -48,     60,   -480,   -372,    168,     60,      6,   -372,     60, &
                   -48,    384,   -480,    -48,  -3072,    384,      6,    -48,     60,      6,    384,    -48,   3030,   3084, &
                  -426,   3408,   -372,   2976,   -804,   -264,    114,   -426,   -318,   -372,      6,    -48,     60,      6, &
                   384,    -48,     60,   -480,    600,     60,   3840,   -480]
  K1(  66,:) = [   3084,   -264,   -264,   -696,   -696,    816,   -372,    168,     60,      6,   -372,     60,   -318,   -264, &
                   600,     60,   3084,   -372,   2652,   -696,   -318,   -372,   -264,    168,   3030,   -804,   -804,   2652, &
                  2652,   -696,   -426,   -372,      6,    -48,     60,   -480,    114,   -318,     60,   -480,   -372,   2976, &
                  -804,   -264,   -372,   2976,    168,  -1344,   2976,  -1344,   -480,    -48,   2976,   -480,   3408,   2976, &
                   -48,    384,   -480,   3840,   3840,    384,    384,  -3072,  -3072,  24576,   -480,    -48,    -48,    384, &
                   384,  -3072,   -372,    168,     60,      6,   -372,     60,   -426,   -372,      6,    -48,     60,   -480, &
                  -480,    -48,    -48,    384,    384,  -3072,     60,      6,      6,    -48,    -48,    384,   -804,   -264, &
                   114,   -426,   -318,   -372,   3030,   3084,   -426,   3408,   -372,   2976,     60,      6,      6,    -48, &
                   -48,    384,    600,     60,     60,   -480,   -480,   3840]
  K1(  67,:) = [   -426,   3408,   3030,   3084,   2976,   -372,      6,    -48,     60,      6,    384,    -48,   -804,   -264, &
                   114,   -426,   -318,   -372,   -480,     60,   3840,   -480,    600,     60,   -372,   2976,   -804,   -264, &
                 -1344,    168,     60,   -480,   -372,   -426,    -48,      6,   2652,   -696,   -804,   3030,   2652,   -804, &
                  2976,   -372,   -480,     60,   -318,    114,    -48,    384,   -480,    -48,  -3072,    384,   -480,   3840, &
                  2976,   3408,    384,    -48,   2976,   -480,  -1344,   2976,    -48,   -480,  24576,  -3072,  -3072,    384, &
                   384,   3840,   2652,   -696,   -318,   -372,   -264,    168,   -696,    816,   -264,   3084,   -696,   -264, &
                  -372,     60,    168,   -372,      6,     60,   3084,   -372,   -264,   -318,     60,    600,    -48,      6, &
                   384,    -48,     60,      6,   -480,     60,    -48,      6,   -372,   -426,  -3072,    384,    384,    -48, &
                   -48,   -480,   -372,     60,    168,   -372,      6,     60]
  K1(  68,:) = [    114,   -426,   -804,   -264,   -372,   -318,     60,      6,      6,    -48,    -48,    384,   3030,   3084, &
                  -426,   3408,   -372,   2976,     60,    600,   -480,   3840,     60,   -480,   -318,   -372,   2652,   -696, &
                   168,   -264,   -372,     60,    168,   -372,      6,     60,   -696,    816,   -264,   3084,   -696,   -264, &
                  -372,   3084,     60,    600,   -264,   -318,   -480,    -48,    -48,    384,    384,  -3072,   2976,   -480, &
                 -1344,   2976,    -48,   -480,   -480,   3840,   2976,   3408,    384,    -48,  -3072,  24576,    384,   3840, &
                 -3072,    384,   -804,   -264,   -372,   2976,    168,  -1344,   2652,   -696,   -804,   3030,   2652,   -804, &
                    60,   -480,   -372,   -426,    -48,      6,   -372,   2976,   -318,    114,   -480,     60,      6,     60, &
                   -48,    384,      6,    -48,     60,   -372,      6,     60,    168,   -372,    384,  -3072,    -48,   -480, &
                   384,    -48,     60,   -480,   -372,   -426,    -48,      6]
  K1(  69,:) = [   -372,   2976,   -804,   -264,  -1344,    168,     60,   -480,   -372,   -426,    -48,      6,   2652,   -696, &
                  -804,   3030,   2652,   -804,   2976,   -372,   -480,     60,   -318,    114,   -426,   3408,   3030,   3084, &
                  2976,   -372,      6,    -48,     60,      6,    384,    -48,   -804,   -264,    114,   -426,   -318,   -372, &
                  -480,     60,   3840,   -480,    600,     60,   -480,   3840,   2976,   3408,    384,    -48,    -48,    384, &
                  -480,    -48,  -3072,    384,  -1344,   2976,   2976,   -480,   -480,    -48,  -3072,    384,  24576,  -3072, &
                  3840,    384,   -696,    816,   -264,   3084,   -696,   -264,   2652,   -696,   -318,   -372,   -264,    168, &
                   168,   -372,   -372,     60,     60,      6,   -264,   -318,   3084,   -372,    600,     60,   -480,     60, &
                   -48,      6,   -372,   -426,    -48,      6,    384,    -48,     60,      6,    384,    -48,  -3072,    384, &
                  -480,    -48,    168,   -372,   -372,     60,     60,      6]
  K1(  70,:) = [   -318,   -372,   2652,   -696,    168,   -264,   -372,     60,    168,   -372,      6,     60,   -696,    816, &
                  -264,   3084,   -696,   -264,   -372,   3084,     60,    600,   -264,   -318,    114,   -426,   -804,   -264, &
                  -372,   -318,     60,      6,      6,    -48,    -48,    384,   3030,   3084,   -426,   3408,   -372,   2976, &
                    60,    600,   -480,   3840,     60,   -480,   2976,   -480,  -1344,   2976,    -48,   -480,   -480,    -48, &
                   -48,    384,    384,  -3072,   2976,   3408,   -480,   3840,    -48,    384,    384,   3840,  -3072,  24576, &
                   384,  -3072,   2652,   -696,   -804,   3030,   2652,   -804,   -804,   -264,   -372,   2976,    168,  -1344, &
                  -372,   -426,     60,   -480,      6,    -48,   -318,    114,   -372,   2976,     60,   -480,     60,   -372, &
                     6,     60,    168,   -372,      6,     60,    -48,    384,      6,    -48,    -48,   -480,    384,  -3072, &
                   -48,    384,   -372,   -426,     60,   -480,      6,    -48]
  K1(  71,:) = [   -804,   3030,   2652,   -696,   -804,   2652,   -372,   -426,     60,   -480,      6,    -48,   -804,   -264, &
                  -372,   2976,    168,  -1344,    114,   -318,     60,   -480,   -372,   2976,   -264,   3084,   -696,    816, &
                  -264,   -696,    168,   -372,   -372,     60,     60,      6,   2652,   -696,   -318,   -372,   -264,    168, &
                  -318,   -264,    600,     60,   3084,   -372,   2976,   3408,   -480,   3840,    -48,    384,  -1344,   2976, &
                  2976,   -480,   -480,    -48,    -48,    384,   -480,    -48,  -3072,    384,    384,  -3072,   3840,    384, &
                 24576,  -3072,   3030,   3084,   -426,   3408,   -372,   2976,   -804,   -264,    114,   -426,   -318,   -372, &
                     6,    -48,     60,      6,    384,    -48,     60,   -480,    600,     60,   3840,   -480,   -426,   -372, &
                     6,    -48,     60,   -480,   -372,    168,     60,      6,   -372,     60,    -48,    384,   -480,    -48, &
                 -3072,    384,      6,    -48,     60,      6,    384,    -48]
  K1(  72,:) = [   -264,   3084,   -696,    816,   -264,   -696,    168,   -372,   -372,     60,     60,      6,   2652,   -696, &
                  -318,   -372,   -264,    168,   -318,   -264,    600,     60,   3084,   -372,   -804,   3030,   2652,   -696, &
                  -804,   2652,   -372,   -426,     60,   -480,      6,    -48,   -804,   -264,   -372,   2976,    168,  -1344, &
                   114,   -318,     60,   -480,   -372,   2976,  -1344,   2976,   2976,   -480,   -480,    -48,   2976,   3408, &
                  -480,   3840,    -48,    384,   -480,    -48,    -48,    384,    384,  -3072,   3840,    384,    384,  -3072, &
                 -3072,  24576,   -804,   -264,    114,   -426,   -318,   -372,   3030,   3084,   -426,   3408,   -372,   2976, &
                    60,      6,      6,    -48,    -48,    384,    600,     60,     60,   -480,   -480,   3840,   -372,    168, &
                    60,      6,   -372,     60,   -426,   -372,      6,    -48,     60,   -480,   -480,    -48,    -48,    384, &
                   384,  -3072,     60,      6,      6,    -48,    -48,    384]
  K1(  73,:) = [    -48,      6,    384,    -48,     60,      6,   -480,     60,    -48,      6,   -372,   -426,  -3072,    384, &
                   384,    -48,    -48,   -480,   -372,     60,    168,   -372,      6,     60,   -480,     60,   3840,   -480, &
                   600,     60,   2976,   -372,   3408,   -426,   3084,   3030,    384,    -48,    -48,      6,      6,     60, &
                  -318,   -372,   -264,   -804,   -426,    114,   2976,   -372,   -480,     60,   -318,    114,  -1344,    168, &
                  2976,   -372,   -264,   -804,    -48,      6,   -480,     60,   -426,   -372,   2652,   -804,   -696,   2652, &
                  3030,   -804,  24576,  -3072,  -3072,    384,    384,   3840,  -3072,    384,    384,    -48,    -48,   -480, &
                   384,    -48,   3840,   -480,   3408,   2976,    -48,   -480,   -480,   2976,   2976,  -1344,   3084,   -372, &
                  -264,   -318,     60,    600,   -264,    168,   -696,   2652,   -372,   -318,   -696,   -264,    816,   -696, &
                  3084,   -264,      6,     60,     60,   -372,   -372,    168]
  K1(  74,:) = [      6,     60,    -48,    384,      6,    -48,     60,   -372,      6,     60,    168,   -372,    384,  -3072, &
                   -48,   -480,    384,    -48,     60,   -480,   -372,   -426,    -48,      6,     60,    600,   -480,   3840, &
                    60,   -480,   -372,   -318,   -426,    114,   -264,   -804,    -48,    384,      6,     60,    -48,      6, &
                  -372,   2976,   3084,   3030,   3408,   -426,   -372,   3084,     60,    600,   -264,   -318,    168,   -264, &
                  -372,   -318,   -696,   2652,      6,     60,     60,   -372,   -372,    168,   -696,   -264,    816,   -696, &
                  3084,   -264,  -3072,  24576,    384,   3840,  -3072,    384,    384,  -3072,    -48,   -480,    384,    -48, &
                   -48,   -480,   -480,   2976,   2976,  -1344,    384,    -48,   3840,   -480,   3408,   2976,   -372,   2976, &
                  -318,    114,   -480,     60,    168,  -1344,   -264,   -804,   2976,   -372,   2652,   -804,   -696,   2652, &
                  3030,   -804,    -48,      6,   -480,     60,   -426,   -372]
  K1(  75,:) = [   -480,     60,    -48,      6,   -372,   -426,    -48,      6,    384,    -48,     60,      6,    384,    -48, &
                 -3072,    384,   -480,    -48,    168,   -372,   -372,     60,     60,      6,   2976,   -372,   -480,     60, &
                  -318,    114,  -1344,    168,   2976,   -372,   -264,   -804,    -48,      6,   -480,     60,   -426,   -372, &
                  2652,   -804,   -696,   2652,   3030,   -804,   -480,     60,   3840,   -480,    600,     60,   2976,   -372, &
                  3408,   -426,   3084,   3030,    384,    -48,    -48,      6,      6,     60,   -318,   -372,   -264,   -804, &
                  -426,    114,  -3072,    384,  24576,  -3072,   3840,    384,    384,    -48,   3840,   -480,   3408,   2976, &
                 -3072,    384,    384,    -48,    -48,   -480,   -480,    -48,   2976,  -1344,   -480,   2976,   -264,   -318, &
                  3084,   -372,    600,     60,   -696,   -264,    816,   -696,   3084,   -264,   -264,    168,   -696,   2652, &
                  -372,   -318,     60,      6,   -372,    168,     60,   -372]
  K1(  76,:) = [     60,   -372,      6,     60,    168,   -372,      6,     60,    -48,    384,      6,    -48,    -48,   -480, &
                   384,  -3072,    -48,    384,   -372,   -426,     60,   -480,      6,    -48,   -372,   3084,     60,    600, &
                  -264,   -318,    168,   -264,   -372,   -318,   -696,   2652,      6,     60,     60,   -372,   -372,    168, &
                  -696,   -264,    816,   -696,   3084,   -264,     60,    600,   -480,   3840,     60,   -480,   -372,   -318, &
                  -426,    114,   -264,   -804,    -48,    384,      6,     60,    -48,      6,   -372,   2976,   3084,   3030, &
                  3408,   -426,    384,   3840,  -3072,  24576,    384,  -3072,    -48,   -480,   -480,   2976,   2976,  -1344, &
                   384,  -3072,    -48,   -480,    384,    -48,    -48,    384,   3408,   2976,   3840,   -480,   -318,    114, &
                  -372,   2976,     60,   -480,   2652,   -804,   -696,   2652,   3030,   -804,    168,  -1344,   -264,   -804, &
                  2976,   -372,      6,    -48,   -426,   -372,   -480,     60]
  K1(  77,:) = [   -426,   -372,      6,    -48,     60,   -480,   -372,    168,     60,      6,   -372,     60,    -48,    384, &
                  -480,    -48,  -3072,    384,      6,    -48,     60,      6,    384,    -48,    114,   -318,     60,   -480, &
                  -372,   2976,   -804,   2652,   3030,   -804,   -696,   2652,      6,    -48,   -426,   -372,   -480,     60, &
                   168,  -1344,   -264,   -804,   2976,   -372,   -318,   -264,    600,     60,   3084,   -372,   -264,   -696, &
                  3084,   -264,    816,   -696,     60,      6,   -372,    168,     60,   -372,   -264,    168,   -696,   2652, &
                  -372,   -318,    384,  -3072,   3840,    384,  24576,  -3072,    -48,    384,   3408,   2976,   3840,   -480, &
                  -480,    -48,   2976,  -1344,   -480,   2976,  -3072,    384,    384,    -48,    -48,   -480,     60,   -480, &
                   600,     60,   3840,   -480,   -372,   2976,   3084,   3030,   3408,   -426,   -318,   -372,   -264,   -804, &
                  -426,    114,    384,    -48,    -48,      6,      6,     60]
  K1(  78,:) = [   -372,    168,     60,      6,   -372,     60,   -426,   -372,      6,    -48,     60,   -480,   -480,    -48, &
                   -48,    384,    384,  -3072,     60,      6,      6,    -48,    -48,    384,   -318,   -264,    600,     60, &
                  3084,   -372,   -264,   -696,   3084,   -264,    816,   -696,     60,      6,   -372,    168,     60,   -372, &
                  -264,    168,   -696,   2652,   -372,   -318,    114,   -318,     60,   -480,   -372,   2976,   -804,   2652, &
                  3030,   -804,   -696,   2652,      6,    -48,   -426,   -372,   -480,     60,    168,  -1344,   -264,   -804, &
                  2976,   -372,   3840,    384,    384,  -3072,  -3072,  24576,   -480,    -48,   2976,  -1344,   -480,   2976, &
                   -48,    384,   3408,   2976,   3840,   -480,    384,  -3072,    -48,   -480,    384,    -48,    600,     60, &
                    60,   -480,   -480,   3840,   -318,   -372,   -264,   -804,   -426,    114,   -372,   2976,   3084,   3030, &
                  3408,   -426,    -48,    384,      6,     60,    -48,      6]
  K1(  79,:) = [   -480,     60,   3840,   -480,    600,     60,   2976,   -372,   3408,   -426,   3084,   3030,    384,    -48, &
                   -48,      6,      6,     60,   -318,   -372,   -264,   -804,   -426,    114,    -48,      6,    384,    -48, &
                    60,      6,   -480,     60,    -48,      6,   -372,   -426,  -3072,    384,    384,    -48,    -48,   -480, &
                  -372,     60,    168,   -372,      6,     60,  -1344,    168,   2976,   -372,   -264,   -804,   2976,   -372, &
                  -480,     60,   -318,    114,   -480,     60,    -48,      6,   -372,   -426,   -696,   2652,   2652,   -804, &
                  -804,   3030,  -3072,    384,    384,    -48,    -48,   -480,  24576,  -3072,  -3072,    384,    384,   3840, &
                  3840,   -480,    384,    -48,   2976,   3408,   -480,   2976,    -48,   -480,  -1344,   2976,   -264,    168, &
                  -696,   2652,   -372,   -318,   3084,   -372,   -264,   -318,     60,    600,    816,   -696,   -696,   -264, &
                  -264,   3084,     60,   -372,      6,     60,    168,   -372]
  K1(  80,:) = [     60,    600,   -480,   3840,     60,   -480,   -372,   -318,   -426,    114,   -264,   -804,    -48,    384, &
                     6,     60,    -48,      6,   -372,   2976,   3084,   3030,   3408,   -426,      6,     60,    -48,    384, &
                     6,    -48,     60,   -372,      6,     60,    168,   -372,    384,  -3072,    -48,   -480,    384,    -48, &
                    60,   -480,   -372,   -426,    -48,      6,    168,   -264,   -372,   -318,   -696,   2652,   -372,   3084, &
                    60,    600,   -264,   -318,     60,   -372,      6,     60,    168,   -372,    816,   -696,   -696,   -264, &
                  -264,   3084,    384,  -3072,    -48,   -480,    384,    -48,  -3072,  24576,    384,   3840,  -3072,    384, &
                  -480,   2976,    -48,   -480,  -1344,   2976,   3840,   -480,    384,    -48,   2976,   3408,    168,  -1344, &
                  -264,   -804,   2976,   -372,   -372,   2976,   -318,    114,   -480,     60,   -696,   2652,   2652,   -804, &
                  -804,   3030,   -480,     60,    -48,      6,   -372,   -426]
  K1(  81,:) = [   2976,   -372,   -480,     60,   -318,    114,  -1344,    168,   2976,   -372,   -264,   -804,    -48,      6, &
                  -480,     60,   -426,   -372,   2652,   -804,   -696,   2652,   3030,   -804,   -480,     60,    -48,      6, &
                  -372,   -426,    -48,      6,    384,    -48,     60,      6,    384,    -48,  -3072,    384,   -480,    -48, &
                   168,   -372,   -372,     60,     60,      6,   2976,   -372,   3408,   -426,   3084,   3030,   -480,     60, &
                  3840,   -480,    600,     60,    -48,      6,    384,    -48,     60,      6,   -264,   -804,   -318,   -372, &
                   114,   -426,    384,    -48,   3840,   -480,   3408,   2976,  -3072,    384,  24576,  -3072,   3840,    384, &
                   384,    -48,  -3072,    384,   -480,    -48,   2976,  -1344,   -480,    -48,   2976,   -480,   -696,   -264, &
                   816,   -696,   3084,   -264,   -264,   -318,   3084,   -372,    600,     60,   -696,   2652,   -264,    168, &
                  -318,   -372,   -372,    168,     60,      6,   -372,     60]
  K1(  82,:) = [   -372,   3084,     60,    600,   -264,   -318,    168,   -264,   -372,   -318,   -696,   2652,      6,     60, &
                    60,   -372,   -372,    168,   -696,   -264,    816,   -696,   3084,   -264,     60,   -372,      6,     60, &
                   168,   -372,      6,     60,    -48,    384,      6,    -48,    -48,   -480,    384,  -3072,    -48,    384, &
                  -372,   -426,     60,   -480,      6,    -48,   -372,   -318,   -426,    114,   -264,   -804,     60,    600, &
                  -480,   3840,     60,   -480,      6,     60,    -48,    384,      6,    -48,   3084,   3030,   -372,   2976, &
                  -426,   3408,    -48,   -480,   -480,   2976,   2976,  -1344,    384,   3840,  -3072,  24576,    384,  -3072, &
                   -48,   -480,    384,  -3072,    -48,    384,   3408,   2976,    -48,    384,   -480,   3840,   2652,   -804, &
                  -696,   2652,   3030,   -804,   -318,    114,   -372,   2976,     60,   -480,   -264,   -804,    168,  -1344, &
                  -372,   2976,   -426,   -372,      6,    -48,     60,   -480]
  K1(  83,:) = [    114,   -318,     60,   -480,   -372,   2976,   -804,   2652,   3030,   -804,   -696,   2652,      6,    -48, &
                  -426,   -372,   -480,     60,    168,  -1344,   -264,   -804,   2976,   -372,   -426,   -372,      6,    -48, &
                    60,   -480,   -372,    168,     60,      6,   -372,     60,    -48,    384,   -480,    -48,  -3072,    384, &
                     6,    -48,     60,      6,    384,    -48,   -264,   -696,   3084,   -264,    816,   -696,   -318,   -264, &
                   600,     60,   3084,   -372,   -372,    168,     60,      6,   -372,     60,   -696,   2652,   -264,    168, &
                  -318,   -372,    -48,    384,   3408,   2976,   3840,   -480,    384,  -3072,   3840,    384,  24576,  -3072, &
                  2976,  -1344,   -480,    -48,   2976,   -480,    384,    -48,  -3072,    384,   -480,    -48,   -372,   2976, &
                  3084,   3030,   3408,   -426,     60,   -480,    600,     60,   3840,   -480,   -264,   -804,   -318,   -372, &
                   114,   -426,    -48,      6,    384,    -48,     60,      6]
  K1(  84,:) = [   -318,   -264,    600,     60,   3084,   -372,   -264,   -696,   3084,   -264,    816,   -696,     60,      6, &
                  -372,    168,     60,   -372,   -264,    168,   -696,   2652,   -372,   -318,   -372,    168,     60,      6, &
                  -372,     60,   -426,   -372,      6,    -48,     60,   -480,   -480,    -48,    -48,    384,    384,  -3072, &
                    60,      6,      6,    -48,    -48,    384,   -804,   2652,   3030,   -804,   -696,   2652,    114,   -318, &
                    60,   -480,   -372,   2976,   -426,   -372,      6,    -48,     60,   -480,   -264,   -804,    168,  -1344, &
                  -372,   2976,   -480,    -48,   2976,  -1344,   -480,   2976,   3840,    384,    384,  -3072,  -3072,  24576, &
                  3408,   2976,    -48,    384,   -480,   3840,    -48,   -480,    384,  -3072,    -48,    384,   -318,   -372, &
                  -264,   -804,   -426,    114,    600,     60,     60,   -480,   -480,   3840,   3084,   3030,   -372,   2976, &
                  -426,   3408,      6,     60,    -48,    384,      6,    -48]
  K1(  85,:) = [   2976,   -372,   3408,   -426,   3084,   3030,   -480,     60,   3840,   -480,    600,     60,    -48,      6, &
                   384,    -48,     60,      6,   -264,   -804,   -318,   -372,    114,   -426,  -1344,    168,   2976,   -372, &
                  -264,   -804,   2976,   -372,   -480,     60,   -318,    114,   -480,     60,    -48,      6,   -372,   -426, &
                  -696,   2652,   2652,   -804,   -804,   3030,    -48,      6,    384,    -48,     60,      6,   -480,     60, &
                   -48,      6,   -372,   -426,  -3072,    384,    384,    -48,    -48,   -480,   -372,     60,    168,   -372, &
                     6,     60,    384,    -48,  -3072,    384,   -480,    -48,   3840,   -480,    384,    -48,   2976,   3408, &
                 24576,  -3072,  -3072,    384,    384,   3840,   2976,   -480,  -1344,   2976,    -48,   -480,   -696,   2652, &
                  -264,    168,   -318,   -372,    816,   -696,   -696,   -264,   -264,   3084,   3084,   -372,   -264,   -318, &
                    60,    600,   -372,     60,    168,   -372,      6,     60]
  K1(  86,:) = [   -372,   -318,   -426,    114,   -264,   -804,     60,    600,   -480,   3840,     60,   -480,      6,     60, &
                   -48,    384,      6,    -48,   3084,   3030,   -372,   2976,   -426,   3408,    168,   -264,   -372,   -318, &
                  -696,   2652,   -372,   3084,     60,    600,   -264,   -318,     60,   -372,      6,     60,    168,   -372, &
                   816,   -696,   -696,   -264,   -264,   3084,      6,     60,    -48,    384,      6,    -48,     60,   -372, &
                     6,     60,    168,   -372,    384,  -3072,    -48,   -480,    384,    -48,     60,   -480,   -372,   -426, &
                   -48,      6,    -48,   -480,    384,  -3072,    -48,    384,   -480,   2976,    -48,   -480,  -1344,   2976, &
                 -3072,  24576,    384,   3840,  -3072,    384,   -480,   3840,   2976,   3408,    384,    -48,   -264,   -804, &
                   168,  -1344,   -372,   2976,   -696,   2652,   2652,   -804,   -804,   3030,   -372,   2976,   -318,    114, &
                  -480,     60,     60,   -480,   -372,   -426,    -48,      6]
  K1(  87,:) = [  -1344,    168,   2976,   -372,   -264,   -804,   2976,   -372,   -480,     60,   -318,    114,   -480,     60, &
                   -48,      6,   -372,   -426,   -696,   2652,   2652,   -804,   -804,   3030,   2976,   -372,   3408,   -426, &
                  3084,   3030,   -480,     60,   3840,   -480,    600,     60,    -48,      6,    384,    -48,     60,      6, &
                  -264,   -804,   -318,   -372,    114,   -426,   -480,     60,    -48,      6,   -372,   -426,    -48,      6, &
                   384,    -48,     60,      6,    384,    -48,  -3072,    384,   -480,    -48,    168,   -372,   -372,     60, &
                    60,      6,   3840,   -480,    384,    -48,   2976,   3408,    384,    -48,  -3072,    384,   -480,    -48, &
                 -3072,    384,  24576,  -3072,   3840,    384,  -1344,   2976,   2976,   -480,   -480,    -48,    816,   -696, &
                  -696,   -264,   -264,   3084,   -696,   2652,   -264,    168,   -318,   -372,   -264,   -318,   3084,   -372, &
                   600,     60,    168,   -372,   -372,     60,     60,      6]
  K1(  88,:) = [    168,   -264,   -372,   -318,   -696,   2652,   -372,   3084,     60,    600,   -264,   -318,     60,   -372, &
                     6,     60,    168,   -372,    816,   -696,   -696,   -264,   -264,   3084,   -372,   -318,   -426,    114, &
                  -264,   -804,     60,    600,   -480,   3840,     60,   -480,      6,     60,    -48,    384,      6,    -48, &
                  3084,   3030,   -372,   2976,   -426,   3408,     60,   -372,      6,     60,    168,   -372,      6,     60, &
                   -48,    384,      6,    -48,    -48,   -480,    384,  -3072,    -48,    384,   -372,   -426,     60,   -480, &
                     6,    -48,   -480,   2976,    -48,   -480,  -1344,   2976,    -48,   -480,    384,  -3072,    -48,    384, &
                   384,   3840,  -3072,  24576,    384,  -3072,   2976,   3408,   -480,   3840,    -48,    384,   -696,   2652, &
                  2652,   -804,   -804,   3030,   -264,   -804,    168,  -1344,   -372,   2976,   -318,    114,   -372,   2976, &
                    60,   -480,   -372,   -426,     60,   -480,      6,    -48]
  K1(  89,:) = [   -804,   2652,   3030,   -804,   -696,   2652,    114,   -318,     60,   -480,   -372,   2976,   -426,   -372, &
                     6,    -48,     60,   -480,   -264,   -804,    168,  -1344,   -372,   2976,   -264,   -696,   3084,   -264, &
                   816,   -696,   -318,   -264,    600,     60,   3084,   -372,   -372,    168,     60,      6,   -372,     60, &
                  -696,   2652,   -264,    168,   -318,   -372,   -426,   -372,      6,    -48,     60,   -480,   -372,    168, &
                    60,      6,   -372,     60,    -48,    384,   -480,    -48,  -3072,    384,      6,    -48,     60,      6, &
                   384,    -48,   3408,   2976,    -48,    384,   -480,   3840,   2976,  -1344,   -480,    -48,   2976,   -480, &
                   384,  -3072,   3840,    384,  24576,  -3072,    -48,    384,   -480,    -48,  -3072,    384,   3084,   3030, &
                  -372,   2976,   -426,   3408,   -264,   -804,   -318,   -372,    114,   -426,     60,   -480,    600,     60, &
                  3840,   -480,      6,    -48,     60,      6,    384,    -48]
  K1(  90,:) = [   -264,   -696,   3084,   -264,    816,   -696,   -318,   -264,    600,     60,   3084,   -372,   -372,    168, &
                    60,      6,   -372,     60,   -696,   2652,   -264,    168,   -318,   -372,   -804,   2652,   3030,   -804, &
                  -696,   2652,    114,   -318,     60,   -480,   -372,   2976,   -426,   -372,      6,    -48,     60,   -480, &
                  -264,   -804,    168,  -1344,   -372,   2976,   -372,    168,     60,      6,   -372,     60,   -426,   -372, &
                     6,    -48,     60,   -480,   -480,    -48,    -48,    384,    384,  -3072,     60,      6,      6,    -48, &
                   -48,    384,   2976,  -1344,   -480,    -48,   2976,   -480,   3408,   2976,    -48,    384,   -480,   3840, &
                  3840,    384,    384,  -3072,  -3072,  24576,   -480,    -48,    -48,    384,    384,  -3072,   -264,   -804, &
                  -318,   -372,    114,   -426,   3084,   3030,   -372,   2976,   -426,   3408,    600,     60,     60,   -480, &
                  -480,   3840,     60,      6,      6,    -48,    -48,    384]
  K1(  91,:) = [   3030,   3084,   -426,   3408,   -372,   2976,   -804,   -264,    114,   -426,   -318,   -372,      6,    -48, &
                    60,      6,    384,    -48,     60,   -480,    600,     60,   3840,   -480,   -804,   -264,   -372,   2976, &
                   168,  -1344,   2652,   -696,   -804,   3030,   2652,   -804,     60,   -480,   -372,   -426,    -48,      6, &
                  -372,   2976,   -318,    114,   -480,     60,   2652,   -696,   -318,   -372,   -264,    168,   -696,    816, &
                  -264,   3084,   -696,   -264,   -372,     60,    168,   -372,      6,     60,   3084,   -372,   -264,   -318, &
                    60,    600,    -48,    384,   -480,    -48,  -3072,    384,   -480,   3840,   2976,   3408,    384,    -48, &
                  2976,   -480,  -1344,   2976,    -48,   -480,  24576,  -3072,  -3072,    384,    384,   3840,      6,    -48, &
                    60,      6,    384,    -48,     60,   -480,   -372,   -426,    -48,      6,   -372,     60,    168,   -372, &
                     6,     60,  -3072,    384,    384,    -48,    -48,   -480]
  K1(  92,:) = [   -804,   -264,    114,   -426,   -318,   -372,   3030,   3084,   -426,   3408,   -372,   2976,     60,      6, &
                     6,    -48,    -48,    384,    600,     60,     60,   -480,   -480,   3840,   2652,   -696,   -318,   -372, &
                  -264,    168,   -696,    816,   -264,   3084,   -696,   -264,   -372,     60,    168,   -372,      6,     60, &
                  3084,   -372,   -264,   -318,     60,    600,   -804,   -264,   -372,   2976,    168,  -1344,   2652,   -696, &
                  -804,   3030,   2652,   -804,     60,   -480,   -372,   -426,    -48,      6,   -372,   2976,   -318,    114, &
                  -480,     60,   -480,    -48,    -48,    384,    384,  -3072,   2976,   -480,  -1344,   2976,    -48,   -480, &
                  -480,   3840,   2976,   3408,    384,    -48,  -3072,  24576,    384,   3840,  -3072,    384,     60,      6, &
                     6,    -48,    -48,    384,   -372,     60,    168,   -372,      6,     60,     60,   -480,   -372,   -426, &
                   -48,      6,    384,  -3072,    -48,   -480,    384,    -48]
  K1(  93,:) = [   -804,   -264,   -372,   2976,    168,  -1344,   2652,   -696,   -804,   3030,   2652,   -804,     60,   -480, &
                  -372,   -426,    -48,      6,   -372,   2976,   -318,    114,   -480,     60,   3030,   3084,   -426,   3408, &
                  -372,   2976,   -804,   -264,    114,   -426,   -318,   -372,      6,    -48,     60,      6,    384,    -48, &
                    60,   -480,    600,     60,   3840,   -480,   -696,    816,   -264,   3084,   -696,   -264,   2652,   -696, &
                  -318,   -372,   -264,    168,    168,   -372,   -372,     60,     60,      6,   -264,   -318,   3084,   -372, &
                   600,     60,   -480,   3840,   2976,   3408,    384,    -48,    -48,    384,   -480,    -48,  -3072,    384, &
                 -1344,   2976,   2976,   -480,   -480,    -48,  -3072,    384,  24576,  -3072,   3840,    384,     60,   -480, &
                  -372,   -426,    -48,      6,      6,    -48,     60,      6,    384,    -48,    168,   -372,   -372,     60, &
                    60,      6,    384,    -48,  -3072,    384,   -480,    -48]
  K1(  94,:) = [   2652,   -696,   -318,   -372,   -264,    168,   -696,    816,   -264,   3084,   -696,   -264,   -372,     60, &
                   168,   -372,      6,     60,   3084,   -372,   -264,   -318,     60,    600,   -804,   -264,    114,   -426, &
                  -318,   -372,   3030,   3084,   -426,   3408,   -372,   2976,     60,      6,      6,    -48,    -48,    384, &
                   600,     60,     60,   -480,   -480,   3840,   2652,   -696,   -804,   3030,   2652,   -804,   -804,   -264, &
                  -372,   2976,    168,  -1344,   -372,   -426,     60,   -480,      6,    -48,   -318,    114,   -372,   2976, &
                    60,   -480,   2976,   -480,  -1344,   2976,    -48,   -480,   -480,    -48,    -48,    384,    384,  -3072, &
                  2976,   3408,   -480,   3840,    -48,    384,    384,   3840,  -3072,  24576,    384,  -3072,   -372,     60, &
                   168,   -372,      6,     60,     60,      6,      6,    -48,    -48,    384,   -372,   -426,     60,   -480, &
                     6,    -48,    -48,   -480,    384,  -3072,    -48,    384]
  K1(  95,:) = [   2652,   -696,   -804,   3030,   2652,   -804,   -804,   -264,   -372,   2976,    168,  -1344,   -372,   -426, &
                    60,   -480,      6,    -48,   -318,    114,   -372,   2976,     60,   -480,   -696,    816,   -264,   3084, &
                  -696,   -264,   2652,   -696,   -318,   -372,   -264,    168,    168,   -372,   -372,     60,     60,      6, &
                  -264,   -318,   3084,   -372,    600,     60,   3030,   3084,   -426,   3408,   -372,   2976,   -804,   -264, &
                   114,   -426,   -318,   -372,      6,    -48,     60,      6,    384,    -48,     60,   -480,    600,     60, &
                  3840,   -480,   2976,   3408,   -480,   3840,    -48,    384,  -1344,   2976,   2976,   -480,   -480,    -48, &
                   -48,    384,   -480,    -48,  -3072,    384,    384,  -3072,   3840,    384,  24576,  -3072,   -372,   -426, &
                    60,   -480,      6,    -48,    168,   -372,   -372,     60,     60,      6,      6,    -48,     60,      6, &
                   384,    -48,    -48,    384,   -480,    -48,  -3072,    384]
  K1(  96,:) = [   -696,    816,   -264,   3084,   -696,   -264,   2652,   -696,   -318,   -372,   -264,    168,    168,   -372, &
                  -372,     60,     60,      6,   -264,   -318,   3084,   -372,    600,     60,   2652,   -696,   -804,   3030, &
                  2652,   -804,   -804,   -264,   -372,   2976,    168,  -1344,   -372,   -426,     60,   -480,      6,    -48, &
                  -318,    114,   -372,   2976,     60,   -480,   -804,   -264,    114,   -426,   -318,   -372,   3030,   3084, &
                  -426,   3408,   -372,   2976,     60,      6,      6,    -48,    -48,    384,    600,     60,     60,   -480, &
                  -480,   3840,  -1344,   2976,   2976,   -480,   -480,    -48,   2976,   3408,   -480,   3840,    -48,    384, &
                  -480,    -48,    -48,    384,    384,  -3072,   3840,    384,    384,  -3072,  -3072,  24576,    168,   -372, &
                  -372,     60,     60,      6,   -372,   -426,     60,   -480,      6,    -48,     60,      6,      6,    -48, &
                   -48,    384,   -480,    -48,    -48,    384,    384,  -3072]
  K1(  97,:) = [      6,    -48,     60,      6,    384,    -48,     60,   -480,   -372,   -426,    -48,      6,   -372,     60, &
                   168,   -372,      6,     60,  -3072,    384,    384,    -48,    -48,   -480,     60,   -480,    600,     60, &
                  3840,   -480,   -372,   2976,   3084,   3030,   3408,   -426,   -318,   -372,   -264,   -804,   -426,    114, &
                   384,    -48,    -48,      6,      6,     60,   -372,   2976,   -318,    114,   -480,     60,    168,  -1344, &
                  -264,   -804,   2976,   -372,   2652,   -804,   -696,   2652,   3030,   -804,    -48,      6,   -480,     60, &
                  -426,   -372,   3084,   -372,   -264,   -318,     60,    600,   -264,    168,   -696,   2652,   -372,   -318, &
                  -696,   -264,    816,   -696,   3084,   -264,      6,     60,     60,   -372,   -372,    168,  24576,  -3072, &
                 -3072,    384,    384,   3840,  -3072,    384,    384,    -48,    -48,   -480,    384,    -48,   3840,   -480, &
                  3408,   2976,    -48,   -480,   -480,   2976,   2976,  -1344]
  K1(  98,:) = [     60,      6,      6,    -48,    -48,    384,   -372,     60,    168,   -372,      6,     60,     60,   -480, &
                  -372,   -426,    -48,      6,    384,  -3072,    -48,   -480,    384,    -48,    600,     60,     60,   -480, &
                  -480,   3840,   -318,   -372,   -264,   -804,   -426,    114,   -372,   2976,   3084,   3030,   3408,   -426, &
                   -48,    384,      6,     60,    -48,      6,   3084,   -372,   -264,   -318,     60,    600,   -264,    168, &
                  -696,   2652,   -372,   -318,   -696,   -264,    816,   -696,   3084,   -264,      6,     60,     60,   -372, &
                  -372,    168,   -372,   2976,   -318,    114,   -480,     60,    168,  -1344,   -264,   -804,   2976,   -372, &
                  2652,   -804,   -696,   2652,   3030,   -804,    -48,      6,   -480,     60,   -426,   -372,  -3072,  24576, &
                   384,   3840,  -3072,    384,    384,  -3072,    -48,   -480,    384,    -48,    -48,   -480,   -480,   2976, &
                  2976,  -1344,    384,    -48,   3840,   -480,   3408,   2976]
  K1(  99,:) = [     60,   -480,   -372,   -426,    -48,      6,      6,    -48,     60,      6,    384,    -48,    168,   -372, &
                  -372,     60,     60,      6,    384,    -48,  -3072,    384,   -480,    -48,   -372,   2976,   -318,    114, &
                  -480,     60,    168,  -1344,   -264,   -804,   2976,   -372,   2652,   -804,   -696,   2652,   3030,   -804, &
                   -48,      6,   -480,     60,   -426,   -372,     60,   -480,    600,     60,   3840,   -480,   -372,   2976, &
                  3084,   3030,   3408,   -426,   -318,   -372,   -264,   -804,   -426,    114,    384,    -48,    -48,      6, &
                     6,     60,   -264,   -318,   3084,   -372,    600,     60,   -696,   -264,    816,   -696,   3084,   -264, &
                  -264,    168,   -696,   2652,   -372,   -318,     60,      6,   -372,    168,     60,   -372,  -3072,    384, &
                 24576,  -3072,   3840,    384,    384,    -48,   3840,   -480,   3408,   2976,  -3072,    384,    384,    -48, &
                   -48,   -480,   -480,    -48,   2976,  -1344,   -480,   2976]
  K1( 100,:) = [   -372,     60,    168,   -372,      6,     60,     60,      6,      6,    -48,    -48,    384,   -372,   -426, &
                    60,   -480,      6,    -48,    -48,   -480,    384,  -3072,    -48,    384,   3084,   -372,   -264,   -318, &
                    60,    600,   -264,    168,   -696,   2652,   -372,   -318,   -696,   -264,    816,   -696,   3084,   -264, &
                     6,     60,     60,   -372,   -372,    168,    600,     60,     60,   -480,   -480,   3840,   -318,   -372, &
                  -264,   -804,   -426,    114,   -372,   2976,   3084,   3030,   3408,   -426,    -48,    384,      6,     60, &
                   -48,      6,   -318,    114,   -372,   2976,     60,   -480,   2652,   -804,   -696,   2652,   3030,   -804, &
                   168,  -1344,   -264,   -804,   2976,   -372,      6,    -48,   -426,   -372,   -480,     60,    384,   3840, &
                 -3072,  24576,    384,  -3072,    -48,   -480,   -480,   2976,   2976,  -1344,    384,  -3072,    -48,   -480, &
                   384,    -48,    -48,    384,   3408,   2976,   3840,   -480]
  K1( 101,:) = [   -372,   -426,     60,   -480,      6,    -48,    168,   -372,   -372,     60,     60,      6,      6,    -48, &
                    60,      6,    384,    -48,    -48,    384,   -480,    -48,  -3072,    384,   -318,    114,   -372,   2976, &
                    60,   -480,   2652,   -804,   -696,   2652,   3030,   -804,    168,  -1344,   -264,   -804,   2976,   -372, &
                     6,    -48,   -426,   -372,   -480,     60,   -264,   -318,   3084,   -372,    600,     60,   -696,   -264, &
                   816,   -696,   3084,   -264,   -264,    168,   -696,   2652,   -372,   -318,     60,      6,   -372,    168, &
                    60,   -372,     60,   -480,    600,     60,   3840,   -480,   -372,   2976,   3084,   3030,   3408,   -426, &
                  -318,   -372,   -264,   -804,   -426,    114,    384,    -48,    -48,      6,      6,     60,    384,  -3072, &
                  3840,    384,  24576,  -3072,    -48,    384,   3408,   2976,   3840,   -480,   -480,    -48,   2976,  -1344, &
                  -480,   2976,  -3072,    384,    384,    -48,    -48,   -480]
  K1( 102,:) = [    168,   -372,   -372,     60,     60,      6,   -372,   -426,     60,   -480,      6,    -48,     60,      6, &
                     6,    -48,    -48,    384,   -480,    -48,    -48,    384,    384,  -3072,   -264,   -318,   3084,   -372, &
                   600,     60,   -696,   -264,    816,   -696,   3084,   -264,   -264,    168,   -696,   2652,   -372,   -318, &
                    60,      6,   -372,    168,     60,   -372,   -318,    114,   -372,   2976,     60,   -480,   2652,   -804, &
                  -696,   2652,   3030,   -804,    168,  -1344,   -264,   -804,   2976,   -372,      6,    -48,   -426,   -372, &
                  -480,     60,    600,     60,     60,   -480,   -480,   3840,   -318,   -372,   -264,   -804,   -426,    114, &
                  -372,   2976,   3084,   3030,   3408,   -426,    -48,    384,      6,     60,    -48,      6,   3840,    384, &
                   384,  -3072,  -3072,  24576,   -480,    -48,   2976,  -1344,   -480,   2976,    -48,    384,   3408,   2976, &
                  3840,   -480,    384,  -3072,    -48,   -480,    384,    -48]
  K1( 103,:) = [     60,   -480,    600,     60,   3840,   -480,   -372,   2976,   3084,   3030,   3408,   -426,   -318,   -372, &
                  -264,   -804,   -426,    114,    384,    -48,    -48,      6,      6,     60,      6,    -48,     60,      6, &
                   384,    -48,     60,   -480,   -372,   -426,    -48,      6,   -372,     60,    168,   -372,      6,     60, &
                 -3072,    384,    384,    -48,    -48,   -480,    168,  -1344,   -264,   -804,   2976,   -372,   -372,   2976, &
                  -318,    114,   -480,     60,   -696,   2652,   2652,   -804,   -804,   3030,   -480,     60,    -48,      6, &
                  -372,   -426,   -264,    168,   -696,   2652,   -372,   -318,   3084,   -372,   -264,   -318,     60,    600, &
                   816,   -696,   -696,   -264,   -264,   3084,     60,   -372,      6,     60,    168,   -372,  -3072,    384, &
                   384,    -48,    -48,   -480,  24576,  -3072,  -3072,    384,    384,   3840,   3840,   -480,    384,    -48, &
                  2976,   3408,   -480,   2976,    -48,   -480,  -1344,   2976]
  K1( 104,:) = [    600,     60,     60,   -480,   -480,   3840,   -318,   -372,   -264,   -804,   -426,    114,   -372,   2976, &
                  3084,   3030,   3408,   -426,    -48,    384,      6,     60,    -48,      6,     60,      6,      6,    -48, &
                   -48,    384,   -372,     60,    168,   -372,      6,     60,     60,   -480,   -372,   -426,    -48,      6, &
                   384,  -3072,    -48,   -480,    384,    -48,   -264,    168,   -696,   2652,   -372,   -318,   3084,   -372, &
                  -264,   -318,     60,    600,    816,   -696,   -696,   -264,   -264,   3084,     60,   -372,      6,     60, &
                   168,   -372,    168,  -1344,   -264,   -804,   2976,   -372,   -372,   2976,   -318,    114,   -480,     60, &
                  -696,   2652,   2652,   -804,   -804,   3030,   -480,     60,    -48,      6,   -372,   -426,    384,  -3072, &
                   -48,   -480,    384,    -48,  -3072,  24576,    384,   3840,  -3072,    384,   -480,   2976,    -48,   -480, &
                 -1344,   2976,   3840,   -480,    384,    -48,   2976,   3408]
  K1( 105,:) = [   -372,   2976,   -318,    114,   -480,     60,    168,  -1344,   -264,   -804,   2976,   -372,   2652,   -804, &
                  -696,   2652,   3030,   -804,    -48,      6,   -480,     60,   -426,   -372,     60,   -480,   -372,   -426, &
                   -48,      6,      6,    -48,     60,      6,    384,    -48,    168,   -372,   -372,     60,     60,      6, &
                   384,    -48,  -3072,    384,   -480,    -48,   -372,   2976,   3084,   3030,   3408,   -426,     60,   -480, &
                   600,     60,   3840,   -480,   -264,   -804,   -318,   -372,    114,   -426,    -48,      6,    384,    -48, &
                    60,      6,   -696,   -264,    816,   -696,   3084,   -264,   -264,   -318,   3084,   -372,    600,     60, &
                  -696,   2652,   -264,    168,   -318,   -372,   -372,    168,     60,      6,   -372,     60,    384,    -48, &
                  3840,   -480,   3408,   2976,  -3072,    384,  24576,  -3072,   3840,    384,    384,    -48,  -3072,    384, &
                  -480,    -48,   2976,  -1344,   -480,    -48,   2976,   -480]
  K1( 106,:) = [   3084,   -372,   -264,   -318,     60,    600,   -264,    168,   -696,   2652,   -372,   -318,   -696,   -264, &
                   816,   -696,   3084,   -264,      6,     60,     60,   -372,   -372,    168,   -372,     60,    168,   -372, &
                     6,     60,     60,      6,      6,    -48,    -48,    384,   -372,   -426,     60,   -480,      6,    -48, &
                   -48,   -480,    384,  -3072,    -48,    384,   -318,   -372,   -264,   -804,   -426,    114,    600,     60, &
                    60,   -480,   -480,   3840,   3084,   3030,   -372,   2976,   -426,   3408,      6,     60,    -48,    384, &
                     6,    -48,   2652,   -804,   -696,   2652,   3030,   -804,   -318,    114,   -372,   2976,     60,   -480, &
                  -264,   -804,    168,  -1344,   -372,   2976,   -426,   -372,      6,    -48,     60,   -480,    -48,   -480, &
                  -480,   2976,   2976,  -1344,    384,   3840,  -3072,  24576,    384,  -3072,    -48,   -480,    384,  -3072, &
                   -48,    384,   3408,   2976,    -48,    384,   -480,   3840]
  K1( 107,:) = [   -318,    114,   -372,   2976,     60,   -480,   2652,   -804,   -696,   2652,   3030,   -804,    168,  -1344, &
                  -264,   -804,   2976,   -372,      6,    -48,   -426,   -372,   -480,     60,   -372,   -426,     60,   -480, &
                     6,    -48,    168,   -372,   -372,     60,     60,      6,      6,    -48,     60,      6,    384,    -48, &
                   -48,    384,   -480,    -48,  -3072,    384,   -696,   -264,    816,   -696,   3084,   -264,   -264,   -318, &
                  3084,   -372,    600,     60,   -696,   2652,   -264,    168,   -318,   -372,   -372,    168,     60,      6, &
                  -372,     60,   -372,   2976,   3084,   3030,   3408,   -426,     60,   -480,    600,     60,   3840,   -480, &
                  -264,   -804,   -318,   -372,    114,   -426,    -48,      6,    384,    -48,     60,      6,    -48,    384, &
                  3408,   2976,   3840,   -480,    384,  -3072,   3840,    384,  24576,  -3072,   2976,  -1344,   -480,    -48, &
                  2976,   -480,    384,    -48,  -3072,    384,   -480,    -48]
  K1( 108,:) = [   -264,   -318,   3084,   -372,    600,     60,   -696,   -264,    816,   -696,   3084,   -264,   -264,    168, &
                  -696,   2652,   -372,   -318,     60,      6,   -372,    168,     60,   -372,    168,   -372,   -372,     60, &
                    60,      6,   -372,   -426,     60,   -480,      6,    -48,     60,      6,      6,    -48,    -48,    384, &
                  -480,    -48,    -48,    384,    384,  -3072,   2652,   -804,   -696,   2652,   3030,   -804,   -318,    114, &
                  -372,   2976,     60,   -480,   -264,   -804,    168,  -1344,   -372,   2976,   -426,   -372,      6,    -48, &
                    60,   -480,   -318,   -372,   -264,   -804,   -426,    114,    600,     60,     60,   -480,   -480,   3840, &
                  3084,   3030,   -372,   2976,   -426,   3408,      6,     60,    -48,    384,      6,    -48,   -480,    -48, &
                  2976,  -1344,   -480,   2976,   3840,    384,    384,  -3072,  -3072,  24576,   3408,   2976,    -48,    384, &
                  -480,   3840,    -48,   -480,    384,  -3072,    -48,    384]
  K1( 109,:) = [   -372,   2976,   3084,   3030,   3408,   -426,     60,   -480,    600,     60,   3840,   -480,   -264,   -804, &
                  -318,   -372,    114,   -426,    -48,      6,    384,    -48,     60,      6,    168,  -1344,   -264,   -804, &
                  2976,   -372,   -372,   2976,   -318,    114,   -480,     60,   -696,   2652,   2652,   -804,   -804,   3030, &
                  -480,     60,    -48,      6,   -372,   -426,      6,    -48,     60,      6,    384,    -48,     60,   -480, &
                  -372,   -426,    -48,      6,   -372,     60,    168,   -372,      6,     60,  -3072,    384,    384,    -48, &
                   -48,   -480,   -696,   2652,   -264,    168,   -318,   -372,    816,   -696,   -696,   -264,   -264,   3084, &
                  3084,   -372,   -264,   -318,     60,    600,   -372,     60,    168,   -372,      6,     60,    384,    -48, &
                 -3072,    384,   -480,    -48,   3840,   -480,    384,    -48,   2976,   3408,  24576,  -3072,  -3072,    384, &
                   384,   3840,   2976,   -480,  -1344,   2976,    -48,   -480]
  K1( 110,:) = [   -318,   -372,   -264,   -804,   -426,    114,    600,     60,     60,   -480,   -480,   3840,   3084,   3030, &
                  -372,   2976,   -426,   3408,      6,     60,    -48,    384,      6,    -48,   -264,    168,   -696,   2652, &
                  -372,   -318,   3084,   -372,   -264,   -318,     60,    600,    816,   -696,   -696,   -264,   -264,   3084, &
                    60,   -372,      6,     60,    168,   -372,     60,      6,      6,    -48,    -48,    384,   -372,     60, &
                   168,   -372,      6,     60,     60,   -480,   -372,   -426,    -48,      6,    384,  -3072,    -48,   -480, &
                   384,    -48,   -264,   -804,    168,  -1344,   -372,   2976,   -696,   2652,   2652,   -804,   -804,   3030, &
                  -372,   2976,   -318,    114,   -480,     60,     60,   -480,   -372,   -426,    -48,      6,    -48,   -480, &
                   384,  -3072,    -48,    384,   -480,   2976,    -48,   -480,  -1344,   2976,  -3072,  24576,    384,   3840, &
                 -3072,    384,   -480,   3840,   2976,   3408,    384,    -48]
  K1( 111,:) = [    168,  -1344,   -264,   -804,   2976,   -372,   -372,   2976,   -318,    114,   -480,     60,   -696,   2652, &
                  2652,   -804,   -804,   3030,   -480,     60,    -48,      6,   -372,   -426,   -372,   2976,   3084,   3030, &
                  3408,   -426,     60,   -480,    600,     60,   3840,   -480,   -264,   -804,   -318,   -372,    114,   -426, &
                   -48,      6,    384,    -48,     60,      6,     60,   -480,   -372,   -426,    -48,      6,      6,    -48, &
                    60,      6,    384,    -48,    168,   -372,   -372,     60,     60,      6,    384,    -48,  -3072,    384, &
                  -480,    -48,    816,   -696,   -696,   -264,   -264,   3084,   -696,   2652,   -264,    168,   -318,   -372, &
                  -264,   -318,   3084,   -372,    600,     60,    168,   -372,   -372,     60,     60,      6,   3840,   -480, &
                   384,    -48,   2976,   3408,    384,    -48,  -3072,    384,   -480,    -48,  -3072,    384,  24576,  -3072, &
                  3840,    384,  -1344,   2976,   2976,   -480,   -480,    -48]
  K1( 112,:) = [   -264,    168,   -696,   2652,   -372,   -318,   3084,   -372,   -264,   -318,     60,    600,    816,   -696, &
                  -696,   -264,   -264,   3084,     60,   -372,      6,     60,    168,   -372,   -318,   -372,   -264,   -804, &
                  -426,    114,    600,     60,     60,   -480,   -480,   3840,   3084,   3030,   -372,   2976,   -426,   3408, &
                     6,     60,    -48,    384,      6,    -48,   -372,     60,    168,   -372,      6,     60,     60,      6, &
                     6,    -48,    -48,    384,   -372,   -426,     60,   -480,      6,    -48,    -48,   -480,    384,  -3072, &
                   -48,    384,   -696,   2652,   2652,   -804,   -804,   3030,   -264,   -804,    168,  -1344,   -372,   2976, &
                  -318,    114,   -372,   2976,     60,   -480,   -372,   -426,     60,   -480,      6,    -48,   -480,   2976, &
                   -48,   -480,  -1344,   2976,    -48,   -480,    384,  -3072,    -48,    384,    384,   3840,  -3072,  24576, &
                   384,  -3072,   2976,   3408,   -480,   3840,    -48,    384]
  K1( 113,:) = [   2652,   -804,   -696,   2652,   3030,   -804,   -318,    114,   -372,   2976,     60,   -480,   -264,   -804, &
                   168,  -1344,   -372,   2976,   -426,   -372,      6,    -48,     60,   -480,   -696,   -264,    816,   -696, &
                  3084,   -264,   -264,   -318,   3084,   -372,    600,     60,   -696,   2652,   -264,    168,   -318,   -372, &
                  -372,    168,     60,      6,   -372,     60,   -372,   -426,     60,   -480,      6,    -48,    168,   -372, &
                  -372,     60,     60,      6,      6,    -48,     60,      6,    384,    -48,    -48,    384,   -480,    -48, &
                 -3072,    384,   3084,   3030,   -372,   2976,   -426,   3408,   -264,   -804,   -318,   -372,    114,   -426, &
                    60,   -480,    600,     60,   3840,   -480,      6,    -48,     60,      6,    384,    -48,   3408,   2976, &
                   -48,    384,   -480,   3840,   2976,  -1344,   -480,    -48,   2976,   -480,    384,  -3072,   3840,    384, &
                 24576,  -3072,    -48,    384,   -480,    -48,  -3072,    384]
  K1( 114,:) = [   -696,   -264,    816,   -696,   3084,   -264,   -264,   -318,   3084,   -372,    600,     60,   -696,   2652, &
                  -264,    168,   -318,   -372,   -372,    168,     60,      6,   -372,     60,   2652,   -804,   -696,   2652, &
                  3030,   -804,   -318,    114,   -372,   2976,     60,   -480,   -264,   -804,    168,  -1344,   -372,   2976, &
                  -426,   -372,      6,    -48,     60,   -480,    168,   -372,   -372,     60,     60,      6,   -372,   -426, &
                    60,   -480,      6,    -48,     60,      6,      6,    -48,    -48,    384,   -480,    -48,    -48,    384, &
                   384,  -3072,   -264,   -804,   -318,   -372,    114,   -426,   3084,   3030,   -372,   2976,   -426,   3408, &
                   600,     60,     60,   -480,   -480,   3840,     60,      6,      6,    -48,    -48,    384,   2976,  -1344, &
                  -480,    -48,   2976,   -480,   3408,   2976,    -48,    384,   -480,   3840,   3840,    384,    384,  -3072, &
                 -3072,  24576,   -480,    -48,    -48,    384,    384,  -3072]
  K1( 115,:) = [   3084,   3030,   -372,   2976,   -426,   3408,   -264,   -804,   -318,   -372,    114,   -426,     60,   -480, &
                   600,     60,   3840,   -480,      6,    -48,     60,      6,    384,    -48,   -264,   -804,    168,  -1344, &
                  -372,   2976,   -696,   2652,   2652,   -804,   -804,   3030,   -372,   2976,   -318,    114,   -480,     60, &
                    60,   -480,   -372,   -426,    -48,      6,   -696,   2652,   -264,    168,   -318,   -372,    816,   -696, &
                  -696,   -264,   -264,   3084,   3084,   -372,   -264,   -318,     60,    600,   -372,     60,    168,   -372, &
                     6,     60,      6,    -48,     60,      6,    384,    -48,     60,   -480,   -372,   -426,    -48,      6, &
                  -372,     60,    168,   -372,      6,     60,  -3072,    384,    384,    -48,    -48,   -480,    -48,    384, &
                  -480,    -48,  -3072,    384,   -480,   3840,   2976,   3408,    384,    -48,   2976,   -480,  -1344,   2976, &
                   -48,   -480,  24576,  -3072,  -3072,    384,    384,   3840]
  K1( 116,:) = [   -264,   -804,   -318,   -372,    114,   -426,   3084,   3030,   -372,   2976,   -426,   3408,    600,     60, &
                    60,   -480,   -480,   3840,     60,      6,      6,    -48,    -48,    384,   -696,   2652,   -264,    168, &
                  -318,   -372,    816,   -696,   -696,   -264,   -264,   3084,   3084,   -372,   -264,   -318,     60,    600, &
                  -372,     60,    168,   -372,      6,     60,   -264,   -804,    168,  -1344,   -372,   2976,   -696,   2652, &
                  2652,   -804,   -804,   3030,   -372,   2976,   -318,    114,   -480,     60,     60,   -480,   -372,   -426, &
                   -48,      6,     60,      6,      6,    -48,    -48,    384,   -372,     60,    168,   -372,      6,     60, &
                    60,   -480,   -372,   -426,    -48,      6,    384,  -3072,    -48,   -480,    384,    -48,   -480,    -48, &
                   -48,    384,    384,  -3072,   2976,   -480,  -1344,   2976,    -48,   -480,   -480,   3840,   2976,   3408, &
                   384,    -48,  -3072,  24576,    384,   3840,  -3072,    384]
  K1( 117,:) = [   -264,   -804,    168,  -1344,   -372,   2976,   -696,   2652,   2652,   -804,   -804,   3030,   -372,   2976, &
                  -318,    114,   -480,     60,     60,   -480,   -372,   -426,    -48,      6,   3084,   3030,   -372,   2976, &
                  -426,   3408,   -264,   -804,   -318,   -372,    114,   -426,     60,   -480,    600,     60,   3840,   -480, &
                     6,    -48,     60,      6,    384,    -48,    816,   -696,   -696,   -264,   -264,   3084,   -696,   2652, &
                  -264,    168,   -318,   -372,   -264,   -318,   3084,   -372,    600,     60,    168,   -372,   -372,     60, &
                    60,      6,     60,   -480,   -372,   -426,    -48,      6,      6,    -48,     60,      6,    384,    -48, &
                   168,   -372,   -372,     60,     60,      6,    384,    -48,  -3072,    384,   -480,    -48,   -480,   3840, &
                  2976,   3408,    384,    -48,    -48,    384,   -480,    -48,  -3072,    384,  -1344,   2976,   2976,   -480, &
                  -480,    -48,  -3072,    384,  24576,  -3072,   3840,    384]
  K1( 118,:) = [   -696,   2652,   -264,    168,   -318,   -372,    816,   -696,   -696,   -264,   -264,   3084,   3084,   -372, &
                  -264,   -318,     60,    600,   -372,     60,    168,   -372,      6,     60,   -264,   -804,   -318,   -372, &
                   114,   -426,   3084,   3030,   -372,   2976,   -426,   3408,    600,     60,     60,   -480,   -480,   3840, &
                    60,      6,      6,    -48,    -48,    384,   -696,   2652,   2652,   -804,   -804,   3030,   -264,   -804, &
                   168,  -1344,   -372,   2976,   -318,    114,   -372,   2976,     60,   -480,   -372,   -426,     60,   -480, &
                     6,    -48,   -372,     60,    168,   -372,      6,     60,     60,      6,      6,    -48,    -48,    384, &
                  -372,   -426,     60,   -480,      6,    -48,    -48,   -480,    384,  -3072,    -48,    384,   2976,   -480, &
                 -1344,   2976,    -48,   -480,   -480,    -48,    -48,    384,    384,  -3072,   2976,   3408,   -480,   3840, &
                   -48,    384,    384,   3840,  -3072,  24576,    384,  -3072]
  K1( 119,:) = [   -696,   2652,   2652,   -804,   -804,   3030,   -264,   -804,    168,  -1344,   -372,   2976,   -318,    114, &
                  -372,   2976,     60,   -480,   -372,   -426,     60,   -480,      6,    -48,    816,   -696,   -696,   -264, &
                  -264,   3084,   -696,   2652,   -264,    168,   -318,   -372,   -264,   -318,   3084,   -372,    600,     60, &
                   168,   -372,   -372,     60,     60,      6,   3084,   3030,   -372,   2976,   -426,   3408,   -264,   -804, &
                  -318,   -372,    114,   -426,     60,   -480,    600,     60,   3840,   -480,      6,    -48,     60,      6, &
                   384,    -48,   -372,   -426,     60,   -480,      6,    -48,    168,   -372,   -372,     60,     60,      6, &
                     6,    -48,     60,      6,    384,    -48,    -48,    384,   -480,    -48,  -3072,    384,   2976,   3408, &
                  -480,   3840,    -48,    384,  -1344,   2976,   2976,   -480,   -480,    -48,    -48,    384,   -480,    -48, &
                 -3072,    384,    384,  -3072,   3840,    384,  24576,  -3072]
  K1( 120,:) = [    816,   -696,   -696,   -264,   -264,   3084,   -696,   2652,   -264,    168,   -318,   -372,   -264,   -318, &
                  3084,   -372,    600,     60,    168,   -372,   -372,     60,     60,      6,   -696,   2652,   2652,   -804, &
                  -804,   3030,   -264,   -804,    168,  -1344,   -372,   2976,   -318,    114,   -372,   2976,     60,   -480, &
                  -372,   -426,     60,   -480,      6,    -48,   -264,   -804,   -318,   -372,    114,   -426,   3084,   3030, &
                  -372,   2976,   -426,   3408,    600,     60,     60,   -480,   -480,   3840,     60,      6,      6,    -48, &
                   -48,    384,    168,   -372,   -372,     60,     60,      6,   -372,   -426,     60,   -480,      6,    -48, &
                    60,      6,      6,    -48,    -48,    384,   -480,    -48,    -48,    384,    384,  -3072,  -1344,   2976, &
                  2976,   -480,   -480,    -48,   2976,   3408,   -480,   3840,    -48,    384,   -480,    -48,    -48,    384, &
                   384,  -3072,   3840,    384,    384,  -3072,  -3072,  24576]
  K1( 121,:) = [  32768,  -4096,  -4096,    512,    512,   5120,  -4096,    512,    512,    -64,    -64,   -640,    512,    -64, &
                  5120,   -640,   4544,   3968,    -64,   -640,   -640,   3968,   3968,  -1792,  -4096,    512,    512,    -64, &
                   -64,   -640,    512,    -64,    -64,      8,      8,     80,    -64,      8,   -640,     80,   -568,   -496, &
                     8,     80,     80,   -496,   -496,    224,    512,    -64,    -64,      8,      8,     80,   5120,   -640, &
                  -640,     80,     80,    800,   4544,   -568,   3968,   -496,   4040,   4112,   -568,    152,   -496,   -424, &
                 -1072,   -352,    -64,      8,   -640,     80,   -568,   -496,   -640,     80,   3968,   -496,    152,   -424, &
                  3968,   -496,  -1792,    224,  -1072,   -352,   4040,  -1072,  -1072,   3536,   3536,   -928,      8,     80, &
                    80,   -496,   -496,    224,     80,    800,   -496,   4112,   -424,   -352,   -496,   -424,    224,   -352, &
                  3536,   -928,   4112,   -352,   -352,   -928,   -928,   1088]
  K1( 122,:) = [  -4096,  32768,    512,   5120,  -4096,    512,    512,  -4096,    -64,   -640,    512,    -64,    -64,   -640, &
                  -640,   3968,   3968,  -1792,    512,    -64,   5120,   -640,   4544,   3968,    512,  -4096,    -64,   -640, &
                   512,    -64,    -64,    512,      8,     80,    -64,      8,      8,     80,     80,   -496,   -496,    224, &
                   -64,      8,   -640,     80,   -568,   -496,    -64,    512,      8,     80,    -64,      8,   -640,   5120, &
                    80,    800,   -640,     80,   -568,    152,   -496,   -424,  -1072,   -352,   4544,   -568,   3968,   -496, &
                  4040,   4112,      8,     80,     80,   -496,   -496,    224,     80,    800,   -496,   4112,   -424,   -352, &
                  -496,   -424,    224,   -352,   3536,   -928,   4112,   -352,   -352,   -928,   -928,   1088,    -64,      8, &
                  -640,     80,   -568,   -496,   -640,     80,   3968,   -496,    152,   -424,   3968,   -496,  -1792,    224, &
                 -1072,   -352,   4040,  -1072,  -1072,   3536,   3536,   -928]
  K1( 123,:) = [  -4096,    512,  32768,  -4096,   5120,    512,    512,    -64,   5120,   -640,   4544,   3968,  -4096,    512, &
                   512,    -64,    -64,   -640,   -640,    -64,   3968,  -1792,   -640,   3968,    512,    -64,  -4096,    512, &
                  -640,    -64,    -64,      8,   -640,     80,   -568,   -496,    512,    -64,    -64,      8,      8,     80, &
                    80,      8,   -496,    224,     80,   -496,    -64,      8,   -640,     80,   -568,   -496,   -640,     80, &
                  3968,   -496,    152,   -424,   3968,   -496,  -1792,    224,  -1072,   -352,   4040,  -1072,  -1072,   3536, &
                  3536,   -928,    512,    -64,    -64,      8,      8,     80,   5120,   -640,   -640,     80,     80,    800, &
                  4544,   -568,   3968,   -496,   4040,   4112,   -568,    152,   -496,   -424,  -1072,   -352,     80,      8, &
                  -496,    224,     80,   -496,    800,     80,   -424,   -352,   -496,   4112,   4112,   -352,   -352,   -928, &
                  -928,   1088,   -496,   -424,    224,   -352,   3536,   -928]
  K1( 124,:) = [    512,   5120,  -4096,  32768,    512,  -4096,    -64,   -640,   -640,   3968,   3968,  -1792,    512,  -4096, &
                   -64,   -640,    512,    -64,    -64,    512,   4544,   3968,   5120,   -640,    -64,   -640,    512,  -4096, &
                   -64,    512,      8,     80,     80,   -496,   -496,    224,    -64,    512,      8,     80,    -64,      8, &
                     8,    -64,   -568,   -496,   -640,     80,      8,     80,     80,   -496,   -496,    224,     80,    800, &
                  -496,   4112,   -424,   -352,   -496,   -424,    224,   -352,   3536,   -928,   4112,   -352,   -352,   -928, &
                  -928,   1088,    -64,    512,      8,     80,    -64,      8,   -640,   5120,     80,    800,   -640,     80, &
                  -568,    152,   -496,   -424,  -1072,   -352,   4544,   -568,   3968,   -496,   4040,   4112,      8,    -64, &
                  -568,   -496,   -640,     80,     80,   -640,    152,   -424,   3968,   -496,   4040,  -1072,  -1072,   3536, &
                  3536,   -928,   3968,   -496,  -1792,    224,  -1072,   -352]
  K1( 125,:) = [    512,  -4096,   5120,    512,  32768,  -4096,    -64,    512,   4544,   3968,   5120,   -640,   -640,    -64, &
                  3968,  -1792,   -640,   3968,  -4096,    512,    512,    -64,    -64,   -640,    -64,    512,   -640,    -64, &
                 -4096,    512,      8,    -64,   -568,   -496,   -640,     80,     80,      8,   -496,    224,     80,   -496, &
                   512,    -64,    -64,      8,      8,     80,      8,    -64,   -568,   -496,   -640,     80,     80,   -640, &
                   152,   -424,   3968,   -496,   4040,  -1072,  -1072,   3536,   3536,   -928,   3968,   -496,  -1792,    224, &
                 -1072,   -352,     80,      8,   -496,    224,     80,   -496,    800,     80,   -424,   -352,   -496,   4112, &
                  4112,   -352,   -352,   -928,   -928,   1088,   -496,   -424,    224,   -352,   3536,   -928,    512,    -64, &
                   -64,      8,      8,     80,   5120,   -640,   -640,     80,     80,    800,   4544,   -568,   3968,   -496, &
                  4040,   4112,   -568,    152,   -496,   -424,  -1072,   -352]
  K1( 126,:) = [   5120,    512,    512,  -4096,  -4096,  32768,   -640,    -64,   3968,  -1792,   -640,   3968,    -64,    512, &
                  4544,   3968,   5120,   -640,    512,  -4096,    -64,   -640,    512,    -64,   -640,    -64,    -64,    512, &
                   512,  -4096,     80,      8,   -496,    224,     80,   -496,      8,    -64,   -568,   -496,   -640,     80, &
                   -64,    512,      8,     80,    -64,      8,     80,      8,   -496,    224,     80,   -496,    800,     80, &
                  -424,   -352,   -496,   4112,   4112,   -352,   -352,   -928,   -928,   1088,   -496,   -424,    224,   -352, &
                  3536,   -928,      8,    -64,   -568,   -496,   -640,     80,     80,   -640,    152,   -424,   3968,   -496, &
                  4040,  -1072,  -1072,   3536,   3536,   -928,   3968,   -496,  -1792,    224,  -1072,   -352,    -64,    512, &
                     8,     80,    -64,      8,   -640,   5120,     80,    800,   -640,     80,   -568,    152,   -496,   -424, &
                 -1072,   -352,   4544,   -568,   3968,   -496,   4040,   4112]
  K1( 127,:) = [  -4096,    512,    512,    -64,    -64,   -640,  32768,  -4096,  -4096,    512,    512,   5120,   5120,   -640, &
                   512,    -64,   3968,   4544,   -640,   3968,    -64,   -640,  -1792,   3968,    512,    -64,    -64,      8, &
                     8,     80,   5120,   -640,   -640,     80,     80,    800,   4544,   -568,   3968,   -496,   4040,   4112, &
                  -568,    152,   -496,   -424,  -1072,   -352,  -4096,    512,    512,    -64,    -64,   -640,    512,    -64, &
                   -64,      8,      8,     80,    -64,      8,   -640,     80,   -568,   -496,      8,     80,     80,   -496, &
                  -496,    224,   -640,     80,    -64,      8,   -496,   -568,   3968,   -496,  -1792,    224,  -1072,   -352, &
                  -640,     80,   3968,   -496,    152,   -424,  -1072,   4040,   3536,   -928,  -1072,   3536,     80,   -496, &
                     8,     80,    224,   -496,   -496,   -424,    224,   -352,   3536,   -928,     80,    800,   -496,   4112, &
                  -424,   -352,   -352,   4112,   -928,   1088,   -352,   -928]
  K1( 128,:) = [    512,  -4096,    -64,   -640,    512,    -64,  -4096,  32768,    512,   5120,  -4096,    512,   -640,   3968, &
                   -64,   -640,  -1792,   3968,   5120,   -640,    512,    -64,   3968,   4544,    -64,    512,      8,     80, &
                   -64,      8,   -640,   5120,     80,    800,   -640,     80,   -568,    152,   -496,   -424,  -1072,   -352, &
                  4544,   -568,   3968,   -496,   4040,   4112,    512,  -4096,    -64,   -640,    512,    -64,    -64,    512, &
                     8,     80,    -64,      8,      8,     80,     80,   -496,   -496,    224,    -64,      8,   -640,     80, &
                  -568,   -496,     80,   -496,      8,     80,    224,   -496,   -496,   -424,    224,   -352,   3536,   -928, &
                    80,    800,   -496,   4112,   -424,   -352,   -352,   4112,   -928,   1088,   -352,   -928,   -640,     80, &
                   -64,      8,   -496,   -568,   3968,   -496,  -1792,    224,  -1072,   -352,   -640,     80,   3968,   -496, &
                   152,   -424,  -1072,   4040,   3536,   -928,  -1072,   3536]
  K1( 129,:) = [    512,    -64,   5120,   -640,   4544,   3968,  -4096,    512,  32768,  -4096,   5120,    512,    512,    -64, &
                 -4096,    512,   -640,    -64,   3968,  -1792,   -640,    -64,   3968,   -640,    -64,      8,   -640,     80, &
                  -568,   -496,   -640,     80,   3968,   -496,    152,   -424,   3968,   -496,  -1792,    224,  -1072,   -352, &
                  4040,  -1072,  -1072,   3536,   3536,   -928,    512,    -64,  -4096,    512,   -640,    -64,    -64,      8, &
                  -640,     80,   -568,   -496,    512,    -64,    -64,      8,      8,     80,     80,      8,   -496,    224, &
                    80,   -496,    -64,      8,    512,    -64,     80,      8,   4544,   -568,   3968,   -496,   4040,   4112, &
                  5120,   -640,   -640,     80,     80,    800,    152,   -568,  -1072,   -352,   -496,   -424,   -496,    224, &
                    80,      8,   -496,     80,   4112,   -352,   -352,   -928,   -928,   1088,    800,     80,   -424,   -352, &
                  -496,   4112,   -424,   -496,   3536,   -928,    224,   -352]
  K1( 130,:) = [    -64,   -640,   -640,   3968,   3968,  -1792,    512,   5120,  -4096,  32768,    512,  -4096,    -64,   -640, &
                   512,  -4096,    -64,    512,   4544,   3968,    -64,    512,   -640,   5120,      8,     80,     80,   -496, &
                  -496,    224,     80,    800,   -496,   4112,   -424,   -352,   -496,   -424,    224,   -352,   3536,   -928, &
                  4112,   -352,   -352,   -928,   -928,   1088,    -64,   -640,    512,  -4096,    -64,    512,      8,     80, &
                    80,   -496,   -496,    224,    -64,    512,      8,     80,    -64,      8,      8,    -64,   -568,   -496, &
                  -640,     80,      8,     80,    -64,    512,      8,    -64,   -568,    152,   -496,   -424,  -1072,   -352, &
                  -640,   5120,     80,    800,   -640,     80,   -568,   4544,   4040,   4112,   3968,   -496,   -568,   -496, &
                     8,    -64,     80,   -640,   4040,  -1072,  -1072,   3536,   3536,   -928,     80,   -640,    152,   -424, &
                  3968,   -496,   -496,   3968,  -1072,   -352,  -1792,    224]
  K1( 131,:) = [    -64,    512,   4544,   3968,   5120,   -640,    512,  -4096,   5120,    512,  32768,  -4096,   3968,  -1792, &
                  -640,    -64,   3968,   -640,    512,    -64,  -4096,    512,   -640,    -64,      8,    -64,   -568,   -496, &
                  -640,     80,     80,   -640,    152,   -424,   3968,   -496,   4040,  -1072,  -1072,   3536,   3536,   -928, &
                  3968,   -496,  -1792,    224,  -1072,   -352,    -64,    512,   -640,    -64,  -4096,    512,      8,    -64, &
                  -568,   -496,   -640,     80,     80,      8,   -496,    224,     80,   -496,    512,    -64,    -64,      8, &
                     8,     80,   -496,    224,     80,      8,   -496,     80,   4112,   -352,   -352,   -928,   -928,   1088, &
                   800,     80,   -424,   -352,   -496,   4112,   -424,   -496,   3536,   -928,    224,   -352,    -64,      8, &
                   512,    -64,     80,      8,   4544,   -568,   3968,   -496,   4040,   4112,   5120,   -640,   -640,     80, &
                    80,    800,    152,   -568,  -1072,   -352,   -496,   -424]
  K1( 132,:) = [   -640,    -64,   3968,  -1792,   -640,   3968,   5120,    512,    512,  -4096,  -4096,  32768,   4544,   3968, &
                   -64,    512,   -640,   5120,    -64,   -640,    512,  -4096,    -64,    512,     80,      8,   -496,    224, &
                    80,   -496,    800,     80,   -424,   -352,   -496,   4112,   4112,   -352,   -352,   -928,   -928,   1088, &
                  -496,   -424,    224,   -352,   3536,   -928,   -640,    -64,    -64,    512,    512,  -4096,     80,      8, &
                  -496,    224,     80,   -496,      8,    -64,   -568,   -496,   -640,     80,    -64,    512,      8,     80, &
                   -64,      8,   -568,   -496,      8,    -64,     80,   -640,   4040,  -1072,  -1072,   3536,   3536,   -928, &
                    80,   -640,    152,   -424,   3968,   -496,   -496,   3968,  -1072,   -352,  -1792,    224,      8,     80, &
                   -64,    512,      8,    -64,   -568,    152,   -496,   -424,  -1072,   -352,   -640,   5120,     80,    800, &
                  -640,     80,   -568,   4544,   4040,   4112,   3968,   -496]
  K1( 133,:) = [    512,    -64,  -4096,    512,   -640,    -64,   5120,   -640,    512,    -64,   3968,   4544,  32768,  -4096, &
                 -4096,    512,    512,   5120,   3968,   -640,  -1792,   3968,    -64,   -640,    -64,      8,    512,    -64, &
                    80,      8,   4544,   -568,   3968,   -496,   4040,   4112,   5120,   -640,   -640,     80,     80,    800, &
                   152,   -568,  -1072,   -352,   -496,   -424,   -640,     80,    -64,      8,   -496,   -568,   3968,   -496, &
                 -1792,    224,  -1072,   -352,   -640,     80,   3968,   -496,    152,   -424,  -1072,   4040,   3536,   -928, &
                 -1072,   3536,  -4096,    512,    512,    -64,    -64,   -640,    512,    -64,    -64,      8,      8,     80, &
                   -64,      8,   -640,     80,   -568,   -496,      8,     80,     80,   -496,   -496,    224,   -496,     80, &
                   224,   -496,      8,     80,   -424,   -496,   3536,   -928,    224,   -352,   -352,   4112,   -928,   1088, &
                  -352,   -928,     80,    800,   -496,   4112,   -424,   -352]
  K1( 134,:) = [    -64,   -640,    512,  -4096,    -64,    512,   -640,   3968,    -64,   -640,  -1792,   3968,  -4096,  32768, &
                   512,   5120,  -4096,    512,   -640,   5120,   3968,   4544,    512,    -64,      8,     80,    -64,    512, &
                     8,    -64,   -568,    152,   -496,   -424,  -1072,   -352,   -640,   5120,     80,    800,   -640,     80, &
                  -568,   4544,   4040,   4112,   3968,   -496,     80,   -496,      8,     80,    224,   -496,   -496,   -424, &
                   224,   -352,   3536,   -928,     80,    800,   -496,   4112,   -424,   -352,   -352,   4112,   -928,   1088, &
                  -352,   -928,    512,  -4096,    -64,   -640,    512,    -64,    -64,    512,      8,     80,    -64,      8, &
                     8,     80,     80,   -496,   -496,    224,    -64,      8,   -640,     80,   -568,   -496,     80,   -640, &
                  -496,   -568,    -64,      8,   -496,   3968,  -1072,   -352,  -1792,    224,  -1072,   4040,   3536,   -928, &
                 -1072,   3536,   -640,     80,   3968,   -496,    152,   -424]
  K1( 135,:) = [   5120,   -640,    512,    -64,   3968,   4544,    512,    -64,  -4096,    512,   -640,    -64,  -4096,    512, &
                 32768,  -4096,   5120,    512,  -1792,   3968,   3968,   -640,   -640,    -64,   -640,     80,    -64,      8, &
                  -496,   -568,   3968,   -496,  -1792,    224,  -1072,   -352,   -640,     80,   3968,   -496,    152,   -424, &
                 -1072,   4040,   3536,   -928,  -1072,   3536,    -64,      8,    512,    -64,     80,      8,   4544,   -568, &
                  3968,   -496,   4040,   4112,   5120,   -640,   -640,     80,     80,    800,    152,   -568,  -1072,   -352, &
                  -496,   -424,    512,    -64,  -4096,    512,   -640,    -64,    -64,      8,   -640,     80,   -568,   -496, &
                   512,    -64,    -64,      8,      8,     80,     80,      8,   -496,    224,     80,   -496,    224,   -496, &
                  -496,     80,     80,      8,   -352,   4112,   -928,   1088,   -352,   -928,   -424,   -496,   3536,   -928, &
                   224,   -352,    800,     80,   -424,   -352,   -496,   4112]
  K1( 136,:) = [   -640,   3968,    -64,   -640,  -1792,   3968,    -64,   -640,    512,  -4096,    -64,    512,    512,   5120, &
                 -4096,  32768,    512,  -4096,   3968,   4544,   -640,   5120,    -64,    512,     80,   -496,      8,     80, &
                   224,   -496,   -496,   -424,    224,   -352,   3536,   -928,     80,    800,   -496,   4112,   -424,   -352, &
                  -352,   4112,   -928,   1088,   -352,   -928,      8,     80,    -64,    512,      8,    -64,   -568,    152, &
                  -496,   -424,  -1072,   -352,   -640,   5120,     80,    800,   -640,     80,   -568,   4544,   4040,   4112, &
                  3968,   -496,    -64,   -640,    512,  -4096,    -64,    512,      8,     80,     80,   -496,   -496,    224, &
                   -64,    512,      8,     80,    -64,      8,      8,    -64,   -568,   -496,   -640,     80,   -496,   -568, &
                    80,   -640,      8,    -64,  -1072,   4040,   3536,   -928,  -1072,   3536,   -496,   3968,  -1072,   -352, &
                 -1792,    224,     80,   -640,    152,   -424,   3968,   -496]
  K1( 137,:) = [   4544,   3968,    -64,    512,   -640,   5120,   3968,  -1792,   -640,    -64,   3968,   -640,    512,  -4096, &
                  5120,    512,  32768,  -4096,    -64,    512,   -640,    -64,  -4096,    512,   -568,   -496,      8,    -64, &
                    80,   -640,   4040,  -1072,  -1072,   3536,   3536,   -928,     80,   -640,    152,   -424,   3968,   -496, &
                  -496,   3968,  -1072,   -352,  -1792,    224,   -496,    224,     80,      8,   -496,     80,   4112,   -352, &
                  -352,   -928,   -928,   1088,    800,     80,   -424,   -352,   -496,   4112,   -424,   -496,   3536,   -928, &
                   224,   -352,    -64,    512,   -640,    -64,  -4096,    512,      8,    -64,   -568,   -496,   -640,     80, &
                    80,      8,   -496,    224,     80,   -496,    512,    -64,    -64,      8,      8,     80,      8,    -64, &
                    80,      8,    512,    -64,   -568,   4544,   4040,   4112,   3968,   -496,    152,   -568,  -1072,   -352, &
                  -496,   -424,   5120,   -640,   -640,     80,     80,    800]
  K1( 138,:) = [   3968,  -1792,   -640,    -64,   3968,   -640,   4544,   3968,    -64,    512,   -640,   5120,   5120,    512, &
                   512,  -4096,  -4096,  32768,   -640,    -64,    -64,    512,    512,  -4096,   -496,    224,     80,      8, &
                  -496,     80,   4112,   -352,   -352,   -928,   -928,   1088,    800,     80,   -424,   -352,   -496,   4112, &
                  -424,   -496,   3536,   -928,    224,   -352,   -568,   -496,      8,    -64,     80,   -640,   4040,  -1072, &
                 -1072,   3536,   3536,   -928,     80,   -640,    152,   -424,   3968,   -496,   -496,   3968,  -1072,   -352, &
                 -1792,    224,   -640,    -64,    -64,    512,    512,  -4096,     80,      8,   -496,    224,     80,   -496, &
                     8,    -64,   -568,   -496,   -640,     80,    -64,    512,      8,     80,    -64,      8,     80,      8, &
                     8,    -64,    -64,    512,    152,   -568,  -1072,   -352,   -496,   -424,   -568,   4544,   4040,   4112, &
                  3968,   -496,   -640,   5120,     80,    800,   -640,     80]
  K1( 139,:) = [    -64,    512,   -640,    -64,  -4096,    512,   -640,   5120,   3968,   4544,    512,    -64,   3968,   -640, &
                 -1792,   3968,    -64,   -640,  32768,  -4096,  -4096,    512,    512,   5120,      8,    -64,     80,      8, &
                   512,    -64,   -568,   4544,   4040,   4112,   3968,   -496,    152,   -568,  -1072,   -352,   -496,   -424, &
                  5120,   -640,   -640,     80,     80,    800,     80,   -640,   -496,   -568,    -64,      8,   -496,   3968, &
                 -1072,   -352,  -1792,    224,  -1072,   4040,   3536,   -928,  -1072,   3536,   -640,     80,   3968,   -496, &
                   152,   -424,   -496,     80,    224,   -496,      8,     80,   -424,   -496,   3536,   -928,    224,   -352, &
                  -352,   4112,   -928,   1088,   -352,   -928,     80,    800,   -496,   4112,   -424,   -352,  -4096,    512, &
                   512,    -64,    -64,   -640,    512,    -64,    -64,      8,      8,     80,    -64,      8,   -640,     80, &
                  -568,   -496,      8,     80,     80,   -496,   -496,    224]
  K1( 140,:) = [   -640,    -64,    -64,    512,    512,  -4096,   3968,   -640,  -1792,   3968,    -64,   -640,   -640,   5120, &
                  3968,   4544,    512,    -64,  -4096,  32768,    512,   5120,  -4096,    512,     80,      8,      8,    -64, &
                   -64,    512,    152,   -568,  -1072,   -352,   -496,   -424,   -568,   4544,   4040,   4112,   3968,   -496, &
                  -640,   5120,     80,    800,   -640,     80,   -496,     80,    224,   -496,      8,     80,   -424,   -496, &
                  3536,   -928,    224,   -352,   -352,   4112,   -928,   1088,   -352,   -928,     80,    800,   -496,   4112, &
                  -424,   -352,     80,   -640,   -496,   -568,    -64,      8,   -496,   3968,  -1072,   -352,  -1792,    224, &
                 -1072,   4040,   3536,   -928,  -1072,   3536,   -640,     80,   3968,   -496,    152,   -424,    512,  -4096, &
                   -64,   -640,    512,    -64,    -64,    512,      8,     80,    -64,      8,      8,     80,     80,   -496, &
                  -496,    224,    -64,      8,   -640,     80,   -568,   -496]
  K1( 141,:) = [   -640,   5120,   3968,   4544,    512,    -64,    -64,    512,   -640,    -64,  -4096,    512,  -1792,   3968, &
                  3968,   -640,   -640,    -64,  -4096,    512,  32768,  -4096,   5120,    512,     80,   -640,   -496,   -568, &
                   -64,      8,   -496,   3968,  -1072,   -352,  -1792,    224,  -1072,   4040,   3536,   -928,  -1072,   3536, &
                  -640,     80,   3968,   -496,    152,   -424,      8,    -64,     80,      8,    512,    -64,   -568,   4544, &
                  4040,   4112,   3968,   -496,    152,   -568,  -1072,   -352,   -496,   -424,   5120,   -640,   -640,     80, &
                    80,    800,    224,   -496,   -496,     80,     80,      8,   -352,   4112,   -928,   1088,   -352,   -928, &
                  -424,   -496,   3536,   -928,    224,   -352,    800,     80,   -424,   -352,   -496,   4112,    512,    -64, &
                 -4096,    512,   -640,    -64,    -64,      8,   -640,     80,   -568,   -496,    512,    -64,    -64,      8, &
                     8,     80,     80,      8,   -496,    224,     80,   -496]
  K1( 142,:) = [   3968,   -640,  -1792,   3968,    -64,   -640,   -640,    -64,    -64,    512,    512,  -4096,   3968,   4544, &
                  -640,   5120,    -64,    512,    512,   5120,  -4096,  32768,    512,  -4096,   -496,     80,    224,   -496, &
                     8,     80,   -424,   -496,   3536,   -928,    224,   -352,   -352,   4112,   -928,   1088,   -352,   -928, &
                    80,    800,   -496,   4112,   -424,   -352,     80,      8,      8,    -64,    -64,    512,    152,   -568, &
                 -1072,   -352,   -496,   -424,   -568,   4544,   4040,   4112,   3968,   -496,   -640,   5120,     80,    800, &
                  -640,     80,   -496,   -568,     80,   -640,      8,    -64,  -1072,   4040,   3536,   -928,  -1072,   3536, &
                  -496,   3968,  -1072,   -352,  -1792,    224,     80,   -640,    152,   -424,   3968,   -496,    -64,   -640, &
                   512,  -4096,    -64,    512,      8,     80,     80,   -496,   -496,    224,    -64,    512,      8,     80, &
                   -64,      8,      8,    -64,   -568,   -496,   -640,     80]
  K1( 143,:) = [   3968,   4544,   -640,   5120,    -64,    512,  -1792,   3968,   3968,   -640,   -640,    -64,    -64,    512, &
                  -640,    -64,  -4096,    512,    512,  -4096,   5120,    512,  32768,  -4096,   -496,   -568,     80,   -640, &
                     8,    -64,  -1072,   4040,   3536,   -928,  -1072,   3536,   -496,   3968,  -1072,   -352,  -1792,    224, &
                    80,   -640,    152,   -424,   3968,   -496,    224,   -496,   -496,     80,     80,      8,   -352,   4112, &
                  -928,   1088,   -352,   -928,   -424,   -496,   3536,   -928,    224,   -352,    800,     80,   -424,   -352, &
                  -496,   4112,      8,    -64,     80,      8,    512,    -64,   -568,   4544,   4040,   4112,   3968,   -496, &
                   152,   -568,  -1072,   -352,   -496,   -424,   5120,   -640,   -640,     80,     80,    800,    -64,    512, &
                  -640,    -64,  -4096,    512,      8,    -64,   -568,   -496,   -640,     80,     80,      8,   -496,    224, &
                    80,   -496,    512,    -64,    -64,      8,      8,     80]
  K1( 144,:) = [  -1792,   3968,   3968,   -640,   -640,    -64,   3968,   4544,   -640,   5120,    -64,    512,   -640,    -64, &
                   -64,    512,    512,  -4096,   5120,    512,    512,  -4096,  -4096,  32768,    224,   -496,   -496,     80, &
                    80,      8,   -352,   4112,   -928,   1088,   -352,   -928,   -424,   -496,   3536,   -928,    224,   -352, &
                   800,     80,   -424,   -352,   -496,   4112,   -496,   -568,     80,   -640,      8,    -64,  -1072,   4040, &
                  3536,   -928,  -1072,   3536,   -496,   3968,  -1072,   -352,  -1792,    224,     80,   -640,    152,   -424, &
                  3968,   -496,     80,      8,      8,    -64,    -64,    512,    152,   -568,  -1072,   -352,   -496,   -424, &
                  -568,   4544,   4040,   4112,   3968,   -496,   -640,   5120,     80,    800,   -640,     80,   -640,    -64, &
                   -64,    512,    512,  -4096,     80,      8,   -496,    224,     80,   -496,      8,    -64,   -568,   -496, &
                  -640,     80,    -64,    512,      8,     80,    -64,      8]
  K1( 145,:) = [  -4096,    512,    512,    -64,    -64,   -640,    512,    -64,    -64,      8,      8,     80,    -64,      8, &
                  -640,     80,   -568,   -496,      8,     80,     80,   -496,   -496,    224,  32768,  -4096,  -4096,    512, &
                   512,   5120,  -4096,    512,    512,    -64,    -64,   -640,    512,    -64,   5120,   -640,   4544,   3968, &
                   -64,   -640,   -640,   3968,   3968,  -1792,   5120,   -640,   -640,     80,     80,    800,    512,    -64, &
                   -64,      8,      8,     80,   3968,   -496,   4544,   -568,   4112,   4040,   -496,   -424,   -568,    152, &
                  -352,  -1072,   -640,     80,   3968,   -496,    152,   -424,    -64,      8,   -640,     80,   -568,   -496, &
                 -1792,    224,   3968,   -496,   -352,  -1072,  -1072,   3536,   4040,  -1072,   -928,   3536,     80,    800, &
                  -496,   4112,   -424,   -352,      8,     80,     80,   -496,   -496,    224,    224,   -352,   -496,   -424, &
                  -928,   3536,   -352,   -928,   4112,   -352,   1088,   -928]
  K1( 146,:) = [    512,  -4096,    -64,   -640,    512,    -64,    -64,    512,      8,     80,    -64,      8,      8,     80, &
                    80,   -496,   -496,    224,    -64,      8,   -640,     80,   -568,   -496,  -4096,  32768,    512,   5120, &
                 -4096,    512,    512,  -4096,    -64,   -640,    512,    -64,    -64,   -640,   -640,   3968,   3968,  -1792, &
                   512,    -64,   5120,   -640,   4544,   3968,   -640,   5120,     80,    800,   -640,     80,    -64,    512, &
                     8,     80,    -64,      8,   -496,   -424,   -568,    152,   -352,  -1072,   3968,   -496,   4544,   -568, &
                  4112,   4040,     80,    800,   -496,   4112,   -424,   -352,      8,     80,     80,   -496,   -496,    224, &
                   224,   -352,   -496,   -424,   -928,   3536,   -352,   -928,   4112,   -352,   1088,   -928,   -640,     80, &
                  3968,   -496,    152,   -424,    -64,      8,   -640,     80,   -568,   -496,  -1792,    224,   3968,   -496, &
                  -352,  -1072,  -1072,   3536,   4040,  -1072,   -928,   3536]
  K1( 147,:) = [    512,    -64,  -4096,    512,   -640,    -64,    -64,      8,   -640,     80,   -568,   -496,    512,    -64, &
                   -64,      8,      8,     80,     80,      8,   -496,    224,     80,   -496,  -4096,    512,  32768,  -4096, &
                  5120,    512,    512,    -64,   5120,   -640,   4544,   3968,  -4096,    512,    512,    -64,    -64,   -640, &
                  -640,    -64,   3968,  -1792,   -640,   3968,   -640,     80,   3968,   -496,    152,   -424,    -64,      8, &
                  -640,     80,   -568,   -496,  -1792,    224,   3968,   -496,   -352,  -1072,  -1072,   3536,   4040,  -1072, &
                  -928,   3536,   5120,   -640,   -640,     80,     80,    800,    512,    -64,    -64,      8,      8,     80, &
                  3968,   -496,   4544,   -568,   4112,   4040,   -496,   -424,   -568,    152,   -352,  -1072,    800,     80, &
                  -424,   -352,   -496,   4112,     80,      8,   -496,    224,     80,   -496,   -352,   -928,   4112,   -352, &
                  1088,   -928,    224,   -352,   -496,   -424,   -928,   3536]
  K1( 148,:) = [    -64,   -640,    512,  -4096,    -64,    512,      8,     80,     80,   -496,   -496,    224,    -64,    512, &
                     8,     80,    -64,      8,      8,    -64,   -568,   -496,   -640,     80,    512,   5120,  -4096,  32768, &
                   512,  -4096,    -64,   -640,   -640,   3968,   3968,  -1792,    512,  -4096,    -64,   -640,    512,    -64, &
                   -64,    512,   4544,   3968,   5120,   -640,     80,    800,   -496,   4112,   -424,   -352,      8,     80, &
                    80,   -496,   -496,    224,    224,   -352,   -496,   -424,   -928,   3536,   -352,   -928,   4112,   -352, &
                  1088,   -928,   -640,   5120,     80,    800,   -640,     80,    -64,    512,      8,     80,    -64,      8, &
                  -496,   -424,   -568,    152,   -352,  -1072,   3968,   -496,   4544,   -568,   4112,   4040,     80,   -640, &
                   152,   -424,   3968,   -496,      8,    -64,   -568,   -496,   -640,     80,  -1072,   3536,   4040,  -1072, &
                  -928,   3536,  -1792,    224,   3968,   -496,   -352,  -1072]
  K1( 149,:) = [    -64,    512,   -640,    -64,  -4096,    512,      8,    -64,   -568,   -496,   -640,     80,     80,      8, &
                  -496,    224,     80,   -496,    512,    -64,    -64,      8,      8,     80,    512,  -4096,   5120,    512, &
                 32768,  -4096,    -64,    512,   4544,   3968,   5120,   -640,   -640,    -64,   3968,  -1792,   -640,   3968, &
                 -4096,    512,    512,    -64,    -64,   -640,     80,   -640,    152,   -424,   3968,   -496,      8,    -64, &
                  -568,   -496,   -640,     80,  -1072,   3536,   4040,  -1072,   -928,   3536,  -1792,    224,   3968,   -496, &
                  -352,  -1072,    800,     80,   -424,   -352,   -496,   4112,     80,      8,   -496,    224,     80,   -496, &
                  -352,   -928,   4112,   -352,   1088,   -928,    224,   -352,   -496,   -424,   -928,   3536,   5120,   -640, &
                  -640,     80,     80,    800,    512,    -64,    -64,      8,      8,     80,   3968,   -496,   4544,   -568, &
                  4112,   4040,   -496,   -424,   -568,    152,   -352,  -1072]
  K1( 150,:) = [   -640,    -64,    -64,    512,    512,  -4096,     80,      8,   -496,    224,     80,   -496,      8,    -64, &
                  -568,   -496,   -640,     80,    -64,    512,      8,     80,    -64,      8,   5120,    512,    512,  -4096, &
                 -4096,  32768,   -640,    -64,   3968,  -1792,   -640,   3968,    -64,    512,   4544,   3968,   5120,   -640, &
                   512,  -4096,    -64,   -640,    512,    -64,    800,     80,   -424,   -352,   -496,   4112,     80,      8, &
                  -496,    224,     80,   -496,   -352,   -928,   4112,   -352,   1088,   -928,    224,   -352,   -496,   -424, &
                  -928,   3536,     80,   -640,    152,   -424,   3968,   -496,      8,    -64,   -568,   -496,   -640,     80, &
                 -1072,   3536,   4040,  -1072,   -928,   3536,  -1792,    224,   3968,   -496,   -352,  -1072,   -640,   5120, &
                    80,    800,   -640,     80,    -64,    512,      8,     80,    -64,      8,   -496,   -424,   -568,    152, &
                  -352,  -1072,   3968,   -496,   4544,   -568,   4112,   4040]
  K1( 151,:) = [    512,    -64,    -64,      8,      8,     80,   5120,   -640,   -640,     80,     80,    800,   4544,   -568, &
                  3968,   -496,   4040,   4112,   -568,    152,   -496,   -424,  -1072,   -352,  -4096,    512,    512,    -64, &
                   -64,   -640,  32768,  -4096,  -4096,    512,    512,   5120,   5120,   -640,    512,    -64,   3968,   4544, &
                  -640,   3968,    -64,   -640,  -1792,   3968,    512,    -64,    -64,      8,      8,     80,  -4096,    512, &
                   512,    -64,    -64,   -640,   -640,     80,    -64,      8,   -496,   -568,     80,   -496,      8,     80, &
                   224,   -496,   3968,   -496,  -1792,    224,  -1072,   -352,   -640,     80,    -64,      8,   -496,   -568, &
                  3968,   -496,   -640,     80,   -424,    152,   3536,   -928,  -1072,   4040,   3536,  -1072,   -496,   -424, &
                   224,   -352,   3536,   -928,     80,   -496,      8,     80,    224,   -496,   -496,   4112,     80,    800, &
                  -352,   -424,   -928,   1088,   -352,   4112,   -928,   -352]
  K1( 152,:) = [    -64,    512,      8,     80,    -64,      8,   -640,   5120,     80,    800,   -640,     80,   -568,    152, &
                  -496,   -424,  -1072,   -352,   4544,   -568,   3968,   -496,   4040,   4112,    512,  -4096,    -64,   -640, &
                   512,    -64,  -4096,  32768,    512,   5120,  -4096,    512,   -640,   3968,    -64,   -640,  -1792,   3968, &
                  5120,   -640,    512,    -64,   3968,   4544,    -64,    512,      8,     80,    -64,      8,    512,  -4096, &
                   -64,   -640,    512,    -64,     80,   -496,      8,     80,    224,   -496,   -640,     80,    -64,      8, &
                  -496,   -568,   -496,   -424,    224,   -352,   3536,   -928,     80,   -496,      8,     80,    224,   -496, &
                  -496,   4112,     80,    800,   -352,   -424,   -928,   1088,   -352,   4112,   -928,   -352,   3968,   -496, &
                 -1792,    224,  -1072,   -352,   -640,     80,    -64,      8,   -496,   -568,   3968,   -496,   -640,     80, &
                  -424,    152,   3536,   -928,  -1072,   4040,   3536,  -1072]
  K1( 153,:) = [    -64,      8,   -640,     80,   -568,   -496,   -640,     80,   3968,   -496,    152,   -424,   3968,   -496, &
                 -1792,    224,  -1072,   -352,   4040,  -1072,  -1072,   3536,   3536,   -928,    512,    -64,   5120,   -640, &
                  4544,   3968,  -4096,    512,  32768,  -4096,   5120,    512,    512,    -64,  -4096,    512,   -640,    -64, &
                  3968,  -1792,   -640,    -64,   3968,   -640,    -64,      8,   -640,     80,   -568,   -496,    512,    -64, &
                 -4096,    512,   -640,    -64,    -64,      8,    512,    -64,     80,      8,   -496,    224,     80,      8, &
                  -496,     80,   4544,   -568,   3968,   -496,   4040,   4112,    -64,      8,    512,    -64,     80,      8, &
                  -640,     80,   5120,   -640,    800,     80,  -1072,   -352,    152,   -568,   -424,   -496,   4112,   -352, &
                  -352,   -928,   -928,   1088,   -496,    224,     80,      8,   -496,     80,   -424,   -352,    800,     80, &
                  4112,   -496,   3536,   -928,   -424,   -496,   -352,    224]
  K1( 154,:) = [      8,     80,     80,   -496,   -496,    224,     80,    800,   -496,   4112,   -424,   -352,   -496,   -424, &
                   224,   -352,   3536,   -928,   4112,   -352,   -352,   -928,   -928,   1088,    -64,   -640,   -640,   3968, &
                  3968,  -1792,    512,   5120,  -4096,  32768,    512,  -4096,    -64,   -640,    512,  -4096,    -64,    512, &
                  4544,   3968,    -64,    512,   -640,   5120,      8,     80,     80,   -496,   -496,    224,    -64,   -640, &
                   512,  -4096,    -64,    512,      8,     80,    -64,    512,      8,    -64,   -568,   -496,      8,    -64, &
                    80,   -640,   -568,    152,   -496,   -424,  -1072,   -352,      8,     80,    -64,    512,      8,    -64, &
                    80,    800,   -640,   5120,     80,   -640,   4040,   4112,   -568,   4544,   -496,   3968,   4040,  -1072, &
                 -1072,   3536,   3536,   -928,   -568,   -496,      8,    -64,     80,   -640,    152,   -424,     80,   -640, &
                  -496,   3968,  -1072,   -352,   -496,   3968,    224,  -1792]
  K1( 155,:) = [      8,    -64,   -568,   -496,   -640,     80,     80,   -640,    152,   -424,   3968,   -496,   4040,  -1072, &
                 -1072,   3536,   3536,   -928,   3968,   -496,  -1792,    224,  -1072,   -352,    -64,    512,   4544,   3968, &
                  5120,   -640,    512,  -4096,   5120,    512,  32768,  -4096,   3968,  -1792,   -640,    -64,   3968,   -640, &
                   512,    -64,  -4096,    512,   -640,    -64,      8,    -64,   -568,   -496,   -640,     80,    -64,    512, &
                  -640,    -64,  -4096,    512,   -496,    224,     80,      8,   -496,     80,    -64,      8,    512,    -64, &
                    80,      8,   4112,   -352,   -352,   -928,   -928,   1088,   -496,    224,     80,      8,   -496,     80, &
                  -424,   -352,    800,     80,   4112,   -496,   3536,   -928,   -424,   -496,   -352,    224,   4544,   -568, &
                  3968,   -496,   4040,   4112,    -64,      8,    512,    -64,     80,      8,   -640,     80,   5120,   -640, &
                   800,     80,  -1072,   -352,    152,   -568,   -424,   -496]
  K1( 156,:) = [     80,      8,   -496,    224,     80,   -496,    800,     80,   -424,   -352,   -496,   4112,   4112,   -352, &
                  -352,   -928,   -928,   1088,   -496,   -424,    224,   -352,   3536,   -928,   -640,    -64,   3968,  -1792, &
                  -640,   3968,   5120,    512,    512,  -4096,  -4096,  32768,   4544,   3968,    -64,    512,   -640,   5120, &
                   -64,   -640,    512,  -4096,    -64,    512,     80,      8,   -496,    224,     80,   -496,   -640,    -64, &
                   -64,    512,    512,  -4096,   -568,   -496,      8,    -64,     80,   -640,      8,     80,    -64,    512, &
                     8,    -64,   4040,  -1072,  -1072,   3536,   3536,   -928,   -568,   -496,      8,    -64,     80,   -640, &
                   152,   -424,     80,   -640,   -496,   3968,  -1072,   -352,   -496,   3968,    224,  -1792,   -568,    152, &
                  -496,   -424,  -1072,   -352,      8,     80,    -64,    512,      8,    -64,     80,    800,   -640,   5120, &
                    80,   -640,   4040,   4112,   -568,   4544,   -496,   3968]
  K1( 157,:) = [    -64,      8,    512,    -64,     80,      8,   4544,   -568,   3968,   -496,   4040,   4112,   5120,   -640, &
                  -640,     80,     80,    800,    152,   -568,  -1072,   -352,   -496,   -424,    512,    -64,  -4096,    512, &
                  -640,    -64,   5120,   -640,    512,    -64,   3968,   4544,  32768,  -4096,  -4096,    512,    512,   5120, &
                  3968,   -640,  -1792,   3968,    -64,   -640,   3968,   -496,  -1792,    224,  -1072,   -352,   -640,     80, &
                   -64,      8,   -496,   -568,   3968,   -496,   -640,     80,   -424,    152,   3536,   -928,  -1072,   4040, &
                  3536,  -1072,    512,    -64,    -64,      8,      8,     80,  -4096,    512,    512,    -64,    -64,   -640, &
                  -640,     80,    -64,      8,   -496,   -568,     80,   -496,      8,     80,    224,   -496,   -424,   -496, &
                  3536,   -928,    224,   -352,   -496,     80,    224,   -496,      8,     80,   -928,   1088,   -352,   4112, &
                  -928,   -352,   -496,   4112,     80,    800,   -352,   -424]
  K1( 158,:) = [      8,     80,    -64,    512,      8,    -64,   -568,    152,   -496,   -424,  -1072,   -352,   -640,   5120, &
                    80,    800,   -640,     80,   -568,   4544,   4040,   4112,   3968,   -496,    -64,   -640,    512,  -4096, &
                   -64,    512,   -640,   3968,    -64,   -640,  -1792,   3968,  -4096,  32768,    512,   5120,  -4096,    512, &
                  -640,   5120,   3968,   4544,    512,    -64,   -496,   -424,    224,   -352,   3536,   -928,     80,   -496, &
                     8,     80,    224,   -496,   -496,   4112,     80,    800,   -352,   -424,   -928,   1088,   -352,   4112, &
                  -928,   -352,    -64,    512,      8,     80,    -64,      8,    512,  -4096,    -64,   -640,    512,    -64, &
                    80,   -496,      8,     80,    224,   -496,   -640,     80,    -64,      8,   -496,   -568,   -496,   3968, &
                 -1072,   -352,  -1792,    224,     80,   -640,   -496,   -568,    -64,      8,   3536,   -928,  -1072,   4040, &
                  3536,  -1072,   3968,   -496,   -640,     80,   -424,    152]
  K1( 159,:) = [   -640,     80,    -64,      8,   -496,   -568,   3968,   -496,  -1792,    224,  -1072,   -352,   -640,     80, &
                  3968,   -496,    152,   -424,  -1072,   4040,   3536,   -928,  -1072,   3536,   5120,   -640,    512,    -64, &
                  3968,   4544,    512,    -64,  -4096,    512,   -640,    -64,  -4096,    512,  32768,  -4096,   5120,    512, &
                 -1792,   3968,   3968,   -640,   -640,    -64,   4544,   -568,   3968,   -496,   4040,   4112,    -64,      8, &
                   512,    -64,     80,      8,   -640,     80,   5120,   -640,    800,     80,  -1072,   -352,    152,   -568, &
                  -424,   -496,    -64,      8,   -640,     80,   -568,   -496,    512,    -64,  -4096,    512,   -640,    -64, &
                   -64,      8,    512,    -64,     80,      8,   -496,    224,     80,      8,   -496,     80,   -352,   4112, &
                  -928,   1088,   -352,   -928,    224,   -496,   -496,     80,     80,      8,   3536,   -928,   -424,   -496, &
                  -352,    224,   -424,   -352,    800,     80,   4112,   -496]
  K1( 160,:) = [     80,   -496,      8,     80,    224,   -496,   -496,   -424,    224,   -352,   3536,   -928,     80,    800, &
                  -496,   4112,   -424,   -352,   -352,   4112,   -928,   1088,   -352,   -928,   -640,   3968,    -64,   -640, &
                 -1792,   3968,    -64,   -640,    512,  -4096,    -64,    512,    512,   5120,  -4096,  32768,    512,  -4096, &
                  3968,   4544,   -640,   5120,    -64,    512,   -568,    152,   -496,   -424,  -1072,   -352,      8,     80, &
                   -64,    512,      8,    -64,     80,    800,   -640,   5120,     80,   -640,   4040,   4112,   -568,   4544, &
                  -496,   3968,      8,     80,     80,   -496,   -496,    224,    -64,   -640,    512,  -4096,    -64,    512, &
                     8,     80,    -64,    512,      8,    -64,   -568,   -496,      8,    -64,     80,   -640,  -1072,   4040, &
                  3536,   -928,  -1072,   3536,   -496,   -568,     80,   -640,      8,    -64,  -1072,   -352,   -496,   3968, &
                   224,  -1792,    152,   -424,     80,   -640,   -496,   3968]
  K1( 161,:) = [   -568,   -496,      8,    -64,     80,   -640,   4040,  -1072,  -1072,   3536,   3536,   -928,     80,   -640, &
                   152,   -424,   3968,   -496,   -496,   3968,  -1072,   -352,  -1792,    224,   4544,   3968,    -64,    512, &
                  -640,   5120,   3968,  -1792,   -640,    -64,   3968,   -640,    512,  -4096,   5120,    512,  32768,  -4096, &
                   -64,    512,   -640,    -64,  -4096,    512,   4112,   -352,   -352,   -928,   -928,   1088,   -496,    224, &
                    80,      8,   -496,     80,   -424,   -352,    800,     80,   4112,   -496,   3536,   -928,   -424,   -496, &
                  -352,    224,      8,    -64,   -568,   -496,   -640,     80,    -64,    512,   -640,    -64,  -4096,    512, &
                  -496,    224,     80,      8,   -496,     80,    -64,      8,    512,    -64,     80,      8,   -568,   4544, &
                  4040,   4112,   3968,   -496,      8,    -64,     80,      8,    512,    -64,  -1072,   -352,    152,   -568, &
                  -424,   -496,   -640,     80,   5120,   -640,    800,     80]
  K1( 162,:) = [   -496,    224,     80,      8,   -496,     80,   4112,   -352,   -352,   -928,   -928,   1088,    800,     80, &
                  -424,   -352,   -496,   4112,   -424,   -496,   3536,   -928,    224,   -352,   3968,  -1792,   -640,    -64, &
                  3968,   -640,   4544,   3968,    -64,    512,   -640,   5120,   5120,    512,    512,  -4096,  -4096,  32768, &
                  -640,    -64,    -64,    512,    512,  -4096,   4040,  -1072,  -1072,   3536,   3536,   -928,   -568,   -496, &
                     8,    -64,     80,   -640,    152,   -424,     80,   -640,   -496,   3968,  -1072,   -352,   -496,   3968, &
                   224,  -1792,     80,      8,   -496,    224,     80,   -496,   -640,    -64,    -64,    512,    512,  -4096, &
                  -568,   -496,      8,    -64,     80,   -640,      8,     80,    -64,    512,      8,    -64,    152,   -568, &
                 -1072,   -352,   -496,   -424,     80,      8,      8,    -64,    -64,    512,   4040,   4112,   -568,   4544, &
                  -496,   3968,     80,    800,   -640,   5120,     80,   -640]
  K1( 163,:) = [      8,    -64,     80,      8,    512,    -64,   -568,   4544,   4040,   4112,   3968,   -496,    152,   -568, &
                 -1072,   -352,   -496,   -424,   5120,   -640,   -640,     80,     80,    800,    -64,    512,   -640,    -64, &
                 -4096,    512,   -640,   5120,   3968,   4544,    512,    -64,   3968,   -640,  -1792,   3968,    -64,   -640, &
                 32768,  -4096,  -4096,    512,    512,   5120,   -496,   3968,  -1072,   -352,  -1792,    224,     80,   -640, &
                  -496,   -568,    -64,      8,   3536,   -928,  -1072,   4040,   3536,  -1072,   3968,   -496,   -640,     80, &
                  -424,    152,   -424,   -496,   3536,   -928,    224,   -352,   -496,     80,    224,   -496,      8,     80, &
                  -928,   1088,   -352,   4112,   -928,   -352,   -496,   4112,     80,    800,   -352,   -424,    512,    -64, &
                   -64,      8,      8,     80,  -4096,    512,    512,    -64,    -64,   -640,   -640,     80,    -64,      8, &
                  -496,   -568,     80,   -496,      8,     80,    224,   -496]
  K1( 164,:) = [     80,      8,      8,    -64,    -64,    512,    152,   -568,  -1072,   -352,   -496,   -424,   -568,   4544, &
                  4040,   4112,   3968,   -496,   -640,   5120,     80,    800,   -640,     80,   -640,    -64,    -64,    512, &
                   512,  -4096,   3968,   -640,  -1792,   3968,    -64,   -640,   -640,   5120,   3968,   4544,    512,    -64, &
                 -4096,  32768,    512,   5120,  -4096,    512,   -424,   -496,   3536,   -928,    224,   -352,   -496,     80, &
                   224,   -496,      8,     80,   -928,   1088,   -352,   4112,   -928,   -352,   -496,   4112,     80,    800, &
                  -352,   -424,   -496,   3968,  -1072,   -352,  -1792,    224,     80,   -640,   -496,   -568,    -64,      8, &
                  3536,   -928,  -1072,   4040,   3536,  -1072,   3968,   -496,   -640,     80,   -424,    152,    -64,    512, &
                     8,     80,    -64,      8,    512,  -4096,    -64,   -640,    512,    -64,     80,   -496,      8,     80, &
                   224,   -496,   -640,     80,    -64,      8,   -496,   -568]
  K1( 165,:) = [     80,   -640,   -496,   -568,    -64,      8,   -496,   3968,  -1072,   -352,  -1792,    224,  -1072,   4040, &
                  3536,   -928,  -1072,   3536,   -640,     80,   3968,   -496,    152,   -424,   -640,   5120,   3968,   4544, &
                   512,    -64,    -64,    512,   -640,    -64,  -4096,    512,  -1792,   3968,   3968,   -640,   -640,    -64, &
                 -4096,    512,  32768,  -4096,   5120,    512,   -568,   4544,   4040,   4112,   3968,   -496,      8,    -64, &
                    80,      8,    512,    -64,  -1072,   -352,    152,   -568,   -424,   -496,   -640,     80,   5120,   -640, &
                   800,     80,   -352,   4112,   -928,   1088,   -352,   -928,    224,   -496,   -496,     80,     80,      8, &
                  3536,   -928,   -424,   -496,   -352,    224,   -424,   -352,    800,     80,   4112,   -496,    -64,      8, &
                  -640,     80,   -568,   -496,    512,    -64,  -4096,    512,   -640,    -64,    -64,      8,    512,    -64, &
                    80,      8,   -496,    224,     80,      8,   -496,     80]
  K1( 166,:) = [   -496,     80,    224,   -496,      8,     80,   -424,   -496,   3536,   -928,    224,   -352,   -352,   4112, &
                  -928,   1088,   -352,   -928,     80,    800,   -496,   4112,   -424,   -352,   3968,   -640,  -1792,   3968, &
                   -64,   -640,   -640,    -64,    -64,    512,    512,  -4096,   3968,   4544,   -640,   5120,    -64,    512, &
                   512,   5120,  -4096,  32768,    512,  -4096,    152,   -568,  -1072,   -352,   -496,   -424,     80,      8, &
                     8,    -64,    -64,    512,   4040,   4112,   -568,   4544,   -496,   3968,     80,    800,   -640,   5120, &
                    80,   -640,  -1072,   4040,   3536,   -928,  -1072,   3536,   -496,   -568,     80,   -640,      8,    -64, &
                 -1072,   -352,   -496,   3968,    224,  -1792,    152,   -424,     80,   -640,   -496,   3968,      8,     80, &
                    80,   -496,   -496,    224,    -64,   -640,    512,  -4096,    -64,    512,      8,     80,    -64,    512, &
                     8,    -64,   -568,   -496,      8,    -64,     80,   -640]
  K1( 167,:) = [   -496,   -568,     80,   -640,      8,    -64,  -1072,   4040,   3536,   -928,  -1072,   3536,   -496,   3968, &
                 -1072,   -352,  -1792,    224,     80,   -640,    152,   -424,   3968,   -496,   3968,   4544,   -640,   5120, &
                   -64,    512,  -1792,   3968,   3968,   -640,   -640,    -64,    -64,    512,   -640,    -64,  -4096,    512, &
                   512,  -4096,   5120,    512,  32768,  -4096,   -352,   4112,   -928,   1088,   -352,   -928,    224,   -496, &
                  -496,     80,     80,      8,   3536,   -928,   -424,   -496,   -352,    224,   -424,   -352,    800,     80, &
                  4112,   -496,   -568,   4544,   4040,   4112,   3968,   -496,      8,    -64,     80,      8,    512,    -64, &
                 -1072,   -352,    152,   -568,   -424,   -496,   -640,     80,   5120,   -640,    800,     80,      8,    -64, &
                  -568,   -496,   -640,     80,    -64,    512,   -640,    -64,  -4096,    512,   -496,    224,     80,      8, &
                  -496,     80,    -64,      8,    512,    -64,     80,      8]
  K1( 168,:) = [    224,   -496,   -496,     80,     80,      8,   -352,   4112,   -928,   1088,   -352,   -928,   -424,   -496, &
                  3536,   -928,    224,   -352,    800,     80,   -424,   -352,   -496,   4112,  -1792,   3968,   3968,   -640, &
                  -640,    -64,   3968,   4544,   -640,   5120,    -64,    512,   -640,    -64,    -64,    512,    512,  -4096, &
                  5120,    512,    512,  -4096,  -4096,  32768,  -1072,   4040,   3536,   -928,  -1072,   3536,   -496,   -568, &
                    80,   -640,      8,    -64,  -1072,   -352,   -496,   3968,    224,  -1792,    152,   -424,     80,   -640, &
                  -496,   3968,    152,   -568,  -1072,   -352,   -496,   -424,     80,      8,      8,    -64,    -64,    512, &
                  4040,   4112,   -568,   4544,   -496,   3968,     80,    800,   -640,   5120,     80,   -640,     80,      8, &
                  -496,    224,     80,   -496,   -640,    -64,    -64,    512,    512,  -4096,   -568,   -496,      8,    -64, &
                    80,   -640,      8,     80,    -64,    512,      8,    -64]
  K1( 169,:) = [    512,    -64,    -64,      8,      8,     80,  -4096,    512,    512,    -64,    -64,   -640,   -640,     80, &
                   -64,      8,   -496,   -568,     80,   -496,      8,     80,    224,   -496,   5120,   -640,   -640,     80, &
                    80,    800,    512,    -64,    -64,      8,      8,     80,   3968,   -496,   4544,   -568,   4112,   4040, &
                  -496,   -424,   -568,    152,   -352,  -1072,  32768,  -4096,  -4096,    512,    512,   5120,  -4096,    512, &
                   512,    -64,    -64,   -640,    512,    -64,   5120,   -640,   4544,   3968,    -64,   -640,   -640,   3968, &
                  3968,  -1792,   3968,   -496,   -640,     80,   -424,    152,  -1792,    224,   3968,   -496,   -352,  -1072, &
                   -64,      8,   -640,     80,   -568,   -496,   3536,  -1072,   -928,   3536,   4040,  -1072,   -496,   4112, &
                    80,    800,   -352,   -424,    224,   -352,   -496,   -424,   -928,   3536,      8,     80,     80,   -496, &
                  -496,    224,   -928,   -352,   1088,   -928,   4112,   -352]
  K1( 170,:) = [    -64,    512,      8,     80,    -64,      8,    512,  -4096,    -64,   -640,    512,    -64,     80,   -496, &
                     8,     80,    224,   -496,   -640,     80,    -64,      8,   -496,   -568,   -640,   5120,     80,    800, &
                  -640,     80,    -64,    512,      8,     80,    -64,      8,   -496,   -424,   -568,    152,   -352,  -1072, &
                  3968,   -496,   4544,   -568,   4112,   4040,  -4096,  32768,    512,   5120,  -4096,    512,    512,  -4096, &
                   -64,   -640,    512,    -64,    -64,   -640,   -640,   3968,   3968,  -1792,    512,    -64,   5120,   -640, &
                  4544,   3968,   -496,   4112,     80,    800,   -352,   -424,    224,   -352,   -496,   -424,   -928,   3536, &
                     8,     80,     80,   -496,   -496,    224,   -928,   -352,   1088,   -928,   4112,   -352,   3968,   -496, &
                  -640,     80,   -424,    152,  -1792,    224,   3968,   -496,   -352,  -1072,    -64,      8,   -640,     80, &
                  -568,   -496,   3536,  -1072,   -928,   3536,   4040,  -1072]
  K1( 171,:) = [    -64,      8,   -640,     80,   -568,   -496,    512,    -64,  -4096,    512,   -640,    -64,    -64,      8, &
                   512,    -64,     80,      8,   -496,    224,     80,      8,   -496,     80,   -640,     80,   3968,   -496, &
                   152,   -424,    -64,      8,   -640,     80,   -568,   -496,  -1792,    224,   3968,   -496,   -352,  -1072, &
                 -1072,   3536,   4040,  -1072,   -928,   3536,  -4096,    512,  32768,  -4096,   5120,    512,    512,    -64, &
                  5120,   -640,   4544,   3968,  -4096,    512,    512,    -64,    -64,   -640,   -640,    -64,   3968,  -1792, &
                  -640,   3968,   -640,     80,   5120,   -640,    800,     80,   3968,   -496,   4544,   -568,   4112,   4040, &
                   512,    -64,    -64,      8,      8,     80,   -424,   -496,   -352,  -1072,   -568,    152,   -424,   -352, &
                   800,     80,   4112,   -496,   -352,   -928,   4112,   -352,   1088,   -928,     80,      8,   -496,    224, &
                    80,   -496,   -352,    224,   -928,   3536,   -496,   -424]
  K1( 172,:) = [      8,     80,     80,   -496,   -496,    224,    -64,   -640,    512,  -4096,    -64,    512,      8,     80, &
                   -64,    512,      8,    -64,   -568,   -496,      8,    -64,     80,   -640,     80,    800,   -496,   4112, &
                  -424,   -352,      8,     80,     80,   -496,   -496,    224,    224,   -352,   -496,   -424,   -928,   3536, &
                  -352,   -928,   4112,   -352,   1088,   -928,    512,   5120,  -4096,  32768,    512,  -4096,    -64,   -640, &
                  -640,   3968,   3968,  -1792,    512,  -4096,    -64,   -640,    512,    -64,    -64,    512,   4544,   3968, &
                  5120,   -640,     80,    800,   -640,   5120,     80,   -640,   -496,   -424,   -568,    152,   -352,  -1072, &
                   -64,    512,      8,     80,    -64,      8,   -496,   3968,   4112,   4040,   4544,   -568,    152,   -424, &
                    80,   -640,   -496,   3968,  -1072,   3536,   4040,  -1072,   -928,   3536,      8,    -64,   -568,   -496, &
                  -640,     80,    224,  -1792,   -352,  -1072,   3968,   -496]
  K1( 173,:) = [      8,    -64,   -568,   -496,   -640,     80,    -64,    512,   -640,    -64,  -4096,    512,   -496,    224, &
                    80,      8,   -496,     80,    -64,      8,    512,    -64,     80,      8,     80,   -640,    152,   -424, &
                  3968,   -496,      8,    -64,   -568,   -496,   -640,     80,  -1072,   3536,   4040,  -1072,   -928,   3536, &
                 -1792,    224,   3968,   -496,   -352,  -1072,    512,  -4096,   5120,    512,  32768,  -4096,    -64,    512, &
                  4544,   3968,   5120,   -640,   -640,    -64,   3968,  -1792,   -640,   3968,  -4096,    512,    512,    -64, &
                   -64,   -640,   -424,   -352,    800,     80,   4112,   -496,   -352,   -928,   4112,   -352,   1088,   -928, &
                    80,      8,   -496,    224,     80,   -496,   -352,    224,   -928,   3536,   -496,   -424,   -640,     80, &
                  5120,   -640,    800,     80,   3968,   -496,   4544,   -568,   4112,   4040,    512,    -64,    -64,      8, &
                     8,     80,   -424,   -496,   -352,  -1072,   -568,    152]
  K1( 174,:) = [     80,      8,   -496,    224,     80,   -496,   -640,    -64,    -64,    512,    512,  -4096,   -568,   -496, &
                     8,    -64,     80,   -640,      8,     80,    -64,    512,      8,    -64,    800,     80,   -424,   -352, &
                  -496,   4112,     80,      8,   -496,    224,     80,   -496,   -352,   -928,   4112,   -352,   1088,   -928, &
                   224,   -352,   -496,   -424,   -928,   3536,   5120,    512,    512,  -4096,  -4096,  32768,   -640,    -64, &
                  3968,  -1792,   -640,   3968,    -64,    512,   4544,   3968,   5120,   -640,    512,  -4096,    -64,   -640, &
                   512,    -64,    152,   -424,     80,   -640,   -496,   3968,  -1072,   3536,   4040,  -1072,   -928,   3536, &
                     8,    -64,   -568,   -496,   -640,     80,    224,  -1792,   -352,  -1072,   3968,   -496,     80,    800, &
                  -640,   5120,     80,   -640,   -496,   -424,   -568,    152,   -352,  -1072,    -64,    512,      8,     80, &
                   -64,      8,   -496,   3968,   4112,   4040,   4544,   -568]
  K1( 175,:) = [   5120,   -640,   -640,     80,     80,    800,    512,    -64,    -64,      8,      8,     80,   3968,   -496, &
                  4544,   -568,   4112,   4040,   -496,   -424,   -568,    152,   -352,  -1072,    512,    -64,    -64,      8, &
                     8,     80,  -4096,    512,    512,    -64,    -64,   -640,   -640,     80,    -64,      8,   -496,   -568, &
                    80,   -496,      8,     80,    224,   -496,  -4096,    512,    512,    -64,    -64,   -640,  32768,  -4096, &
                 -4096,    512,    512,   5120,   5120,   -640,    512,    -64,   3968,   4544,   -640,   3968,    -64,   -640, &
                 -1792,   3968,  -1792,    224,   3968,   -496,   -352,  -1072,   3968,   -496,   -640,     80,   -424,    152, &
                  -640,     80,    -64,      8,   -496,   -568,   -928,   3536,   3536,  -1072,  -1072,   4040,    224,   -352, &
                  -496,   -424,   -928,   3536,   -496,   4112,     80,    800,   -352,   -424,     80,   -496,      8,     80, &
                   224,   -496,   1088,   -928,   -928,   -352,   -352,   4112]
  K1( 176,:) = [   -640,   5120,     80,    800,   -640,     80,    -64,    512,      8,     80,    -64,      8,   -496,   -424, &
                  -568,    152,   -352,  -1072,   3968,   -496,   4544,   -568,   4112,   4040,    -64,    512,      8,     80, &
                   -64,      8,    512,  -4096,    -64,   -640,    512,    -64,     80,   -496,      8,     80,    224,   -496, &
                  -640,     80,    -64,      8,   -496,   -568,    512,  -4096,    -64,   -640,    512,    -64,  -4096,  32768, &
                   512,   5120,  -4096,    512,   -640,   3968,    -64,   -640,  -1792,   3968,   5120,   -640,    512,    -64, &
                  3968,   4544,    224,   -352,   -496,   -424,   -928,   3536,   -496,   4112,     80,    800,   -352,   -424, &
                    80,   -496,      8,     80,    224,   -496,   1088,   -928,   -928,   -352,   -352,   4112,  -1792,    224, &
                  3968,   -496,   -352,  -1072,   3968,   -496,   -640,     80,   -424,    152,   -640,     80,    -64,      8, &
                  -496,   -568,   -928,   3536,   3536,  -1072,  -1072,   4040]
  K1( 177,:) = [   -640,     80,   3968,   -496,    152,   -424,    -64,      8,   -640,     80,   -568,   -496,  -1792,    224, &
                  3968,   -496,   -352,  -1072,  -1072,   3536,   4040,  -1072,   -928,   3536,    -64,      8,   -640,     80, &
                  -568,   -496,    512,    -64,  -4096,    512,   -640,    -64,    -64,      8,    512,    -64,     80,      8, &
                  -496,    224,     80,      8,   -496,     80,    512,    -64,   5120,   -640,   4544,   3968,  -4096,    512, &
                 32768,  -4096,   5120,    512,    512,    -64,  -4096,    512,   -640,    -64,   3968,  -1792,   -640,    -64, &
                  3968,   -640,   3968,   -496,   4544,   -568,   4112,   4040,   -640,     80,   5120,   -640,    800,     80, &
                   -64,      8,    512,    -64,     80,      8,   -352,  -1072,   -424,   -496,    152,   -568,   -352,   -928, &
                  4112,   -352,   1088,   -928,   -424,   -352,    800,     80,   4112,   -496,   -496,    224,     80,      8, &
                  -496,     80,   -928,   3536,   -352,    224,   -424,   -496]
  K1( 178,:) = [     80,    800,   -496,   4112,   -424,   -352,      8,     80,     80,   -496,   -496,    224,    224,   -352, &
                  -496,   -424,   -928,   3536,   -352,   -928,   4112,   -352,   1088,   -928,      8,     80,     80,   -496, &
                  -496,    224,    -64,   -640,    512,  -4096,    -64,    512,      8,     80,    -64,    512,      8,    -64, &
                  -568,   -496,      8,    -64,     80,   -640,    -64,   -640,   -640,   3968,   3968,  -1792,    512,   5120, &
                 -4096,  32768,    512,  -4096,    -64,   -640,    512,  -4096,    -64,    512,   4544,   3968,    -64,    512, &
                  -640,   5120,   -496,   -424,   -568,    152,   -352,  -1072,     80,    800,   -640,   5120,     80,   -640, &
                     8,     80,    -64,    512,      8,    -64,   4112,   4040,   -496,   3968,   -568,   4544,  -1072,   3536, &
                  4040,  -1072,   -928,   3536,    152,   -424,     80,   -640,   -496,   3968,   -568,   -496,      8,    -64, &
                    80,   -640,   -352,  -1072,    224,  -1792,   -496,   3968]
  K1( 179,:) = [     80,   -640,    152,   -424,   3968,   -496,      8,    -64,   -568,   -496,   -640,     80,  -1072,   3536, &
                  4040,  -1072,   -928,   3536,  -1792,    224,   3968,   -496,   -352,  -1072,      8,    -64,   -568,   -496, &
                  -640,     80,    -64,    512,   -640,    -64,  -4096,    512,   -496,    224,     80,      8,   -496,     80, &
                   -64,      8,    512,    -64,     80,      8,    -64,    512,   4544,   3968,   5120,   -640,    512,  -4096, &
                  5120,    512,  32768,  -4096,   3968,  -1792,   -640,    -64,   3968,   -640,    512,    -64,  -4096,    512, &
                  -640,    -64,   -352,   -928,   4112,   -352,   1088,   -928,   -424,   -352,    800,     80,   4112,   -496, &
                  -496,    224,     80,      8,   -496,     80,   -928,   3536,   -352,    224,   -424,   -496,   3968,   -496, &
                  4544,   -568,   4112,   4040,   -640,     80,   5120,   -640,    800,     80,    -64,      8,    512,    -64, &
                    80,      8,   -352,  -1072,   -424,   -496,    152,   -568]
  K1( 180,:) = [    800,     80,   -424,   -352,   -496,   4112,     80,      8,   -496,    224,     80,   -496,   -352,   -928, &
                  4112,   -352,   1088,   -928,    224,   -352,   -496,   -424,   -928,   3536,     80,      8,   -496,    224, &
                    80,   -496,   -640,    -64,    -64,    512,    512,  -4096,   -568,   -496,      8,    -64,     80,   -640, &
                     8,     80,    -64,    512,      8,    -64,   -640,    -64,   3968,  -1792,   -640,   3968,   5120,    512, &
                   512,  -4096,  -4096,  32768,   4544,   3968,    -64,    512,   -640,   5120,    -64,   -640,    512,  -4096, &
                   -64,    512,  -1072,   3536,   4040,  -1072,   -928,   3536,    152,   -424,     80,   -640,   -496,   3968, &
                  -568,   -496,      8,    -64,     80,   -640,   -352,  -1072,    224,  -1792,   -496,   3968,   -496,   -424, &
                  -568,    152,   -352,  -1072,     80,    800,   -640,   5120,     80,   -640,      8,     80,    -64,    512, &
                     8,    -64,   4112,   4040,   -496,   3968,   -568,   4544]
  K1( 181,:) = [   4544,   -568,   3968,   -496,   4040,   4112,    -64,      8,    512,    -64,     80,      8,   -640,     80, &
                  5120,   -640,    800,     80,  -1072,   -352,    152,   -568,   -424,   -496,   3968,   -496,  -1792,    224, &
                 -1072,   -352,   -640,     80,    -64,      8,   -496,   -568,   3968,   -496,   -640,     80,   -424,    152, &
                  3536,   -928,  -1072,   4040,   3536,  -1072,    512,    -64,  -4096,    512,   -640,    -64,   5120,   -640, &
                   512,    -64,   3968,   4544,  32768,  -4096,  -4096,    512,    512,   5120,   3968,   -640,  -1792,   3968, &
                   -64,   -640,    -64,      8,    512,    -64,     80,      8,   -640,     80,    -64,      8,   -496,   -568, &
                 -4096,    512,    512,    -64,    -64,   -640,   -496,     80,    224,   -496,      8,     80,   3536,   -928, &
                  -424,   -496,   -352,    224,   -928,   1088,   -352,   4112,   -928,   -352,   -496,     80,    224,   -496, &
                     8,     80,   4112,   -496,   -352,   -424,     80,    800]
  K1( 182,:) = [   -568,    152,   -496,   -424,  -1072,   -352,      8,     80,    -64,    512,      8,    -64,     80,    800, &
                  -640,   5120,     80,   -640,   4040,   4112,   -568,   4544,   -496,   3968,   -496,   -424,    224,   -352, &
                  3536,   -928,     80,   -496,      8,     80,    224,   -496,   -496,   4112,     80,    800,   -352,   -424, &
                  -928,   1088,   -352,   4112,   -928,   -352,    -64,   -640,    512,  -4096,    -64,    512,   -640,   3968, &
                   -64,   -640,  -1792,   3968,  -4096,  32768,    512,   5120,  -4096,    512,   -640,   5120,   3968,   4544, &
                   512,    -64,      8,     80,    -64,    512,      8,    -64,     80,   -496,      8,     80,    224,   -496, &
                   512,  -4096,    -64,   -640,    512,    -64,     80,   -640,   -496,   -568,    -64,      8,  -1072,   -352, &
                  -496,   3968,    224,  -1792,   3536,   -928,  -1072,   4040,   3536,  -1072,     80,   -640,   -496,   -568, &
                   -64,      8,   -496,   3968,   -424,    152,   -640,     80]
  K1( 183,:) = [   3968,   -496,  -1792,    224,  -1072,   -352,   -640,     80,    -64,      8,   -496,   -568,   3968,   -496, &
                  -640,     80,   -424,    152,   3536,   -928,  -1072,   4040,   3536,  -1072,   4544,   -568,   3968,   -496, &
                  4040,   4112,    -64,      8,    512,    -64,     80,      8,   -640,     80,   5120,   -640,    800,     80, &
                 -1072,   -352,    152,   -568,   -424,   -496,   5120,   -640,    512,    -64,   3968,   4544,    512,    -64, &
                 -4096,    512,   -640,    -64,  -4096,    512,  32768,  -4096,   5120,    512,  -1792,   3968,   3968,   -640, &
                  -640,    -64,   -640,     80,    -64,      8,   -496,   -568,    -64,      8,    512,    -64,     80,      8, &
                   512,    -64,  -4096,    512,   -640,    -64,    224,   -496,   -496,     80,     80,      8,   -928,   1088, &
                  -352,   4112,   -928,   -352,   3536,   -928,   -424,   -496,   -352,    224,    224,   -496,   -496,     80, &
                    80,      8,   -352,   -424,   4112,   -496,    800,     80]
  K1( 184,:) = [   -496,   -424,    224,   -352,   3536,   -928,     80,   -496,      8,     80,    224,   -496,   -496,   4112, &
                    80,    800,   -352,   -424,   -928,   1088,   -352,   4112,   -928,   -352,   -568,    152,   -496,   -424, &
                 -1072,   -352,      8,     80,    -64,    512,      8,    -64,     80,    800,   -640,   5120,     80,   -640, &
                  4040,   4112,   -568,   4544,   -496,   3968,   -640,   3968,    -64,   -640,  -1792,   3968,    -64,   -640, &
                   512,  -4096,    -64,    512,    512,   5120,  -4096,  32768,    512,  -4096,   3968,   4544,   -640,   5120, &
                   -64,    512,     80,   -496,      8,     80,    224,   -496,      8,     80,    -64,    512,      8,    -64, &
                   -64,   -640,    512,  -4096,    -64,    512,   -496,   -568,     80,   -640,      8,    -64,   3536,   -928, &
                 -1072,   4040,   3536,  -1072,  -1072,   -352,   -496,   3968,    224,  -1792,   -496,   -568,     80,   -640, &
                     8,    -64,   -424,    152,   -496,   3968,     80,   -640]
  K1( 185,:) = [   4040,  -1072,  -1072,   3536,   3536,   -928,   -568,   -496,      8,    -64,     80,   -640,    152,   -424, &
                    80,   -640,   -496,   3968,  -1072,   -352,   -496,   3968,    224,  -1792,   4112,   -352,   -352,   -928, &
                  -928,   1088,   -496,    224,     80,      8,   -496,     80,   -424,   -352,    800,     80,   4112,   -496, &
                  3536,   -928,   -424,   -496,   -352,    224,   4544,   3968,    -64,    512,   -640,   5120,   3968,  -1792, &
                  -640,    -64,   3968,   -640,    512,  -4096,   5120,    512,  32768,  -4096,    -64,    512,   -640,    -64, &
                 -4096,    512,   -568,   -496,      8,    -64,     80,   -640,   -496,    224,     80,      8,   -496,     80, &
                   -64,    512,   -640,    -64,  -4096,    512,      8,    -64,     80,      8,    512,    -64,   4040,   4112, &
                  -568,   4544,   -496,   3968,  -1072,   -352,    152,   -568,   -424,   -496,      8,    -64,     80,      8, &
                   512,    -64,     80,   -640,    800,     80,   5120,   -640]
  K1( 186,:) = [   4112,   -352,   -352,   -928,   -928,   1088,   -496,    224,     80,      8,   -496,     80,   -424,   -352, &
                   800,     80,   4112,   -496,   3536,   -928,   -424,   -496,   -352,    224,   4040,  -1072,  -1072,   3536, &
                  3536,   -928,   -568,   -496,      8,    -64,     80,   -640,    152,   -424,     80,   -640,   -496,   3968, &
                 -1072,   -352,   -496,   3968,    224,  -1792,   3968,  -1792,   -640,    -64,   3968,   -640,   4544,   3968, &
                   -64,    512,   -640,   5120,   5120,    512,    512,  -4096,  -4096,  32768,   -640,    -64,    -64,    512, &
                   512,  -4096,   -496,    224,     80,      8,   -496,     80,   -568,   -496,      8,    -64,     80,   -640, &
                  -640,    -64,    -64,    512,    512,  -4096,     80,      8,      8,    -64,    -64,    512,  -1072,   -352, &
                   152,   -568,   -424,   -496,   4040,   4112,   -568,   4544,   -496,   3968,     80,      8,      8,    -64, &
                   -64,    512,    800,     80,     80,   -640,   -640,   5120]
  K1( 187,:) = [   -568,   4544,   4040,   4112,   3968,   -496,      8,    -64,     80,      8,    512,    -64,  -1072,   -352, &
                   152,   -568,   -424,   -496,   -640,     80,   5120,   -640,    800,     80,   -496,   3968,  -1072,   -352, &
                 -1792,    224,     80,   -640,   -496,   -568,    -64,      8,   3536,   -928,  -1072,   4040,   3536,  -1072, &
                  3968,   -496,   -640,     80,   -424,    152,    -64,    512,   -640,    -64,  -4096,    512,   -640,   5120, &
                  3968,   4544,    512,    -64,   3968,   -640,  -1792,   3968,    -64,   -640,  32768,  -4096,  -4096,    512, &
                   512,   5120,   3536,   -928,   -424,   -496,   -352,    224,   -928,   1088,   -352,   4112,   -928,   -352, &
                  -496,     80,    224,   -496,      8,     80,   4112,   -496,   -352,   -424,     80,    800,    -64,      8, &
                   512,    -64,     80,      8,   -640,     80,    -64,      8,   -496,   -568,  -4096,    512,    512,    -64, &
                   -64,   -640,   -496,     80,    224,   -496,      8,     80]
  K1( 188,:) = [    152,   -568,  -1072,   -352,   -496,   -424,     80,      8,      8,    -64,    -64,    512,   4040,   4112, &
                  -568,   4544,   -496,   3968,     80,    800,   -640,   5120,     80,   -640,   -424,   -496,   3536,   -928, &
                   224,   -352,   -496,     80,    224,   -496,      8,     80,   -928,   1088,   -352,   4112,   -928,   -352, &
                  -496,   4112,     80,    800,   -352,   -424,   -640,    -64,    -64,    512,    512,  -4096,   3968,   -640, &
                 -1792,   3968,    -64,   -640,   -640,   5120,   3968,   4544,    512,    -64,  -4096,  32768,    512,   5120, &
                 -4096,    512,  -1072,   -352,   -496,   3968,    224,  -1792,   3536,   -928,  -1072,   4040,   3536,  -1072, &
                    80,   -640,   -496,   -568,    -64,      8,   -496,   3968,   -424,    152,   -640,     80,      8,     80, &
                   -64,    512,      8,    -64,     80,   -496,      8,     80,    224,   -496,    512,  -4096,    -64,   -640, &
                   512,    -64,     80,   -640,   -496,   -568,    -64,      8]
  K1( 189,:) = [   -496,   3968,  -1072,   -352,  -1792,    224,     80,   -640,   -496,   -568,    -64,      8,   3536,   -928, &
                 -1072,   4040,   3536,  -1072,   3968,   -496,   -640,     80,   -424,    152,   -568,   4544,   4040,   4112, &
                  3968,   -496,      8,    -64,     80,      8,    512,    -64,  -1072,   -352,    152,   -568,   -424,   -496, &
                  -640,     80,   5120,   -640,    800,     80,   -640,   5120,   3968,   4544,    512,    -64,    -64,    512, &
                  -640,    -64,  -4096,    512,  -1792,   3968,   3968,   -640,   -640,    -64,  -4096,    512,  32768,  -4096, &
                  5120,    512,   -928,   1088,   -352,   4112,   -928,   -352,   3536,   -928,   -424,   -496,   -352,    224, &
                   224,   -496,   -496,     80,     80,      8,   -352,   -424,   4112,   -496,    800,     80,   -640,     80, &
                   -64,      8,   -496,   -568,    -64,      8,    512,    -64,     80,      8,    512,    -64,  -4096,    512, &
                  -640,    -64,    224,   -496,   -496,     80,     80,      8]
  K1( 190,:) = [   -424,   -496,   3536,   -928,    224,   -352,   -496,     80,    224,   -496,      8,     80,   -928,   1088, &
                  -352,   4112,   -928,   -352,   -496,   4112,     80,    800,   -352,   -424,    152,   -568,  -1072,   -352, &
                  -496,   -424,     80,      8,      8,    -64,    -64,    512,   4040,   4112,   -568,   4544,   -496,   3968, &
                    80,    800,   -640,   5120,     80,   -640,   3968,   -640,  -1792,   3968,    -64,   -640,   -640,    -64, &
                   -64,    512,    512,  -4096,   3968,   4544,   -640,   5120,    -64,    512,    512,   5120,  -4096,  32768, &
                   512,  -4096,   3536,   -928,  -1072,   4040,   3536,  -1072,  -1072,   -352,   -496,   3968,    224,  -1792, &
                  -496,   -568,     80,   -640,      8,    -64,   -424,    152,   -496,   3968,     80,   -640,     80,   -496, &
                     8,     80,    224,   -496,      8,     80,    -64,    512,      8,    -64,    -64,   -640,    512,  -4096, &
                   -64,    512,   -496,   -568,     80,   -640,      8,    -64]
  K1( 191,:) = [  -1072,   4040,   3536,   -928,  -1072,   3536,   -496,   -568,     80,   -640,      8,    -64,  -1072,   -352, &
                  -496,   3968,    224,  -1792,    152,   -424,     80,   -640,   -496,   3968,   -352,   4112,   -928,   1088, &
                  -352,   -928,    224,   -496,   -496,     80,     80,      8,   3536,   -928,   -424,   -496,   -352,    224, &
                  -424,   -352,    800,     80,   4112,   -496,   3968,   4544,   -640,   5120,    -64,    512,  -1792,   3968, &
                  3968,   -640,   -640,    -64,    -64,    512,   -640,    -64,  -4096,    512,    512,  -4096,   5120,    512, &
                 32768,  -4096,   4040,   4112,   -568,   4544,   -496,   3968,  -1072,   -352,    152,   -568,   -424,   -496, &
                     8,    -64,     80,      8,    512,    -64,     80,   -640,    800,     80,   5120,   -640,   -568,   -496, &
                     8,    -64,     80,   -640,   -496,    224,     80,      8,   -496,     80,    -64,    512,   -640,    -64, &
                 -4096,    512,      8,    -64,     80,      8,    512,    -64]
  K1( 192,:) = [   -352,   4112,   -928,   1088,   -352,   -928,    224,   -496,   -496,     80,     80,      8,   3536,   -928, &
                  -424,   -496,   -352,    224,   -424,   -352,    800,     80,   4112,   -496,  -1072,   4040,   3536,   -928, &
                 -1072,   3536,   -496,   -568,     80,   -640,      8,    -64,  -1072,   -352,   -496,   3968,    224,  -1792, &
                   152,   -424,     80,   -640,   -496,   3968,  -1792,   3968,   3968,   -640,   -640,    -64,   3968,   4544, &
                  -640,   5120,    -64,    512,   -640,    -64,    -64,    512,    512,  -4096,   5120,    512,    512,  -4096, &
                 -4096,  32768,  -1072,   -352,    152,   -568,   -424,   -496,   4040,   4112,   -568,   4544,   -496,   3968, &
                    80,      8,      8,    -64,    -64,    512,    800,     80,     80,   -640,   -640,   5120,   -496,    224, &
                    80,      8,   -496,     80,   -568,   -496,      8,    -64,     80,   -640,   -640,    -64,    -64,    512, &
                   512,  -4096,     80,      8,      8,    -64,    -64,    512]
  K1( 193,:) = [    -64,      8,    512,    -64,     80,      8,   -640,     80,    -64,      8,   -496,   -568,  -4096,    512, &
                   512,    -64,    -64,   -640,   -496,     80,    224,   -496,      8,     80,   -640,     80,   5120,   -640, &
                   800,     80,   3968,   -496,   4544,   -568,   4112,   4040,    512,    -64,    -64,      8,      8,     80, &
                  -424,   -496,   -352,  -1072,   -568,    152,   3968,   -496,   -640,     80,   -424,    152,  -1792,    224, &
                  3968,   -496,   -352,  -1072,    -64,      8,   -640,     80,   -568,   -496,   3536,  -1072,   -928,   3536, &
                  4040,  -1072,  32768,  -4096,  -4096,    512,    512,   5120,  -4096,    512,    512,    -64,    -64,   -640, &
                   512,    -64,   5120,   -640,   4544,   3968,    -64,   -640,   -640,   3968,   3968,  -1792,   4112,   -496, &
                  -352,   -424,     80,    800,   -352,    224,   -928,   3536,   -496,   -424,   -928,   -352,   1088,   -928, &
                  4112,   -352,      8,     80,     80,   -496,   -496,    224]
  K1( 194,:) = [      8,     80,    -64,    512,      8,    -64,     80,   -496,      8,     80,    224,   -496,    512,  -4096, &
                   -64,   -640,    512,    -64,     80,   -640,   -496,   -568,    -64,      8,     80,    800,   -640,   5120, &
                    80,   -640,   -496,   -424,   -568,    152,   -352,  -1072,    -64,    512,      8,     80,    -64,      8, &
                  -496,   3968,   4112,   4040,   4544,   -568,   -496,   4112,     80,    800,   -352,   -424,    224,   -352, &
                  -496,   -424,   -928,   3536,      8,     80,     80,   -496,   -496,    224,   -928,   -352,   1088,   -928, &
                  4112,   -352,  -4096,  32768,    512,   5120,  -4096,    512,    512,  -4096,    -64,   -640,    512,    -64, &
                   -64,   -640,   -640,   3968,   3968,  -1792,    512,    -64,   5120,   -640,   4544,   3968,   -496,   3968, &
                  -424,    152,   -640,     80,    224,  -1792,   -352,  -1072,   3968,   -496,   3536,  -1072,   -928,   3536, &
                  4040,  -1072,    -64,      8,   -640,     80,   -568,   -496]
  K1( 195,:) = [   -640,     80,    -64,      8,   -496,   -568,    -64,      8,    512,    -64,     80,      8,    512,    -64, &
                 -4096,    512,   -640,    -64,    224,   -496,   -496,     80,     80,      8,   3968,   -496,   -640,     80, &
                  -424,    152,  -1792,    224,   3968,   -496,   -352,  -1072,    -64,      8,   -640,     80,   -568,   -496, &
                  3536,  -1072,   -928,   3536,   4040,  -1072,   -640,     80,   5120,   -640,    800,     80,   3968,   -496, &
                  4544,   -568,   4112,   4040,    512,    -64,    -64,      8,      8,     80,   -424,   -496,   -352,  -1072, &
                  -568,    152,  -4096,    512,  32768,  -4096,   5120,    512,    512,    -64,   5120,   -640,   4544,   3968, &
                 -4096,    512,    512,    -64,    -64,   -640,   -640,    -64,   3968,  -1792,   -640,   3968,   -352,   -424, &
                  4112,   -496,    800,     80,   -928,   -352,   1088,   -928,   4112,   -352,   -352,    224,   -928,   3536, &
                  -496,   -424,     80,      8,   -496,    224,     80,   -496]
  K1( 196,:) = [     80,   -496,      8,     80,    224,   -496,      8,     80,    -64,    512,      8,    -64,    -64,   -640, &
                   512,  -4096,    -64,    512,   -496,   -568,     80,   -640,      8,    -64,   -496,   4112,     80,    800, &
                  -352,   -424,    224,   -352,   -496,   -424,   -928,   3536,      8,     80,     80,   -496,   -496,    224, &
                  -928,   -352,   1088,   -928,   4112,   -352,     80,    800,   -640,   5120,     80,   -640,   -496,   -424, &
                  -568,    152,   -352,  -1072,    -64,    512,      8,     80,    -64,      8,   -496,   3968,   4112,   4040, &
                  4544,   -568,    512,   5120,  -4096,  32768,    512,  -4096,    -64,   -640,   -640,   3968,   3968,  -1792, &
                   512,  -4096,    -64,   -640,    512,    -64,    -64,    512,   4544,   3968,   5120,   -640,   -424,    152, &
                  -496,   3968,     80,   -640,   3536,  -1072,   -928,   3536,   4040,  -1072,    224,  -1792,   -352,  -1072, &
                  3968,   -496,      8,    -64,   -568,   -496,   -640,     80]
  K1( 197,:) = [   -568,   -496,      8,    -64,     80,   -640,   -496,    224,     80,      8,   -496,     80,    -64,    512, &
                  -640,    -64,  -4096,    512,      8,    -64,     80,      8,    512,    -64,    152,   -424,     80,   -640, &
                  -496,   3968,  -1072,   3536,   4040,  -1072,   -928,   3536,      8,    -64,   -568,   -496,   -640,     80, &
                   224,  -1792,   -352,  -1072,   3968,   -496,   -424,   -352,    800,     80,   4112,   -496,   -352,   -928, &
                  4112,   -352,   1088,   -928,     80,      8,   -496,    224,     80,   -496,   -352,    224,   -928,   3536, &
                  -496,   -424,    512,  -4096,   5120,    512,  32768,  -4096,    -64,    512,   4544,   3968,   5120,   -640, &
                  -640,    -64,   3968,  -1792,   -640,   3968,  -4096,    512,    512,    -64,    -64,   -640,     80,   -640, &
                   800,     80,   5120,   -640,   -496,   3968,   4112,   4040,   4544,   -568,   -424,   -496,   -352,  -1072, &
                  -568,    152,    512,    -64,    -64,      8,      8,     80]
  K1( 198,:) = [   -496,    224,     80,      8,   -496,     80,   -568,   -496,      8,    -64,     80,   -640,   -640,    -64, &
                   -64,    512,    512,  -4096,     80,      8,      8,    -64,    -64,    512,   -424,   -352,    800,     80, &
                  4112,   -496,   -352,   -928,   4112,   -352,   1088,   -928,     80,      8,   -496,    224,     80,   -496, &
                  -352,    224,   -928,   3536,   -496,   -424,    152,   -424,     80,   -640,   -496,   3968,  -1072,   3536, &
                  4040,  -1072,   -928,   3536,      8,    -64,   -568,   -496,   -640,     80,    224,  -1792,   -352,  -1072, &
                  3968,   -496,   5120,    512,    512,  -4096,  -4096,  32768,   -640,    -64,   3968,  -1792,   -640,   3968, &
                   -64,    512,   4544,   3968,   5120,   -640,    512,  -4096,    -64,   -640,    512,    -64,    800,     80, &
                    80,   -640,   -640,   5120,   -424,   -496,   -352,  -1072,   -568,    152,   -496,   3968,   4112,   4040, &
                  4544,   -568,    -64,    512,      8,     80,    -64,      8]
  K1( 199,:) = [   -640,     80,   5120,   -640,    800,     80,   3968,   -496,   4544,   -568,   4112,   4040,    512,    -64, &
                   -64,      8,      8,     80,   -424,   -496,   -352,  -1072,   -568,    152,    -64,      8,    512,    -64, &
                    80,      8,   -640,     80,    -64,      8,   -496,   -568,  -4096,    512,    512,    -64,    -64,   -640, &
                  -496,     80,    224,   -496,      8,     80,  -1792,    224,   3968,   -496,   -352,  -1072,   3968,   -496, &
                  -640,     80,   -424,    152,   -640,     80,    -64,      8,   -496,   -568,   -928,   3536,   3536,  -1072, &
                 -1072,   4040,  -4096,    512,    512,    -64,    -64,   -640,  32768,  -4096,  -4096,    512,    512,   5120, &
                  5120,   -640,    512,    -64,   3968,   4544,   -640,   3968,    -64,   -640,  -1792,   3968,   -352,    224, &
                  -928,   3536,   -496,   -424,   4112,   -496,   -352,   -424,     80,    800,   1088,   -928,   -928,   -352, &
                  -352,   4112,     80,   -496,      8,     80,    224,   -496]
  K1( 200,:) = [     80,    800,   -640,   5120,     80,   -640,   -496,   -424,   -568,    152,   -352,  -1072,    -64,    512, &
                     8,     80,    -64,      8,   -496,   3968,   4112,   4040,   4544,   -568,      8,     80,    -64,    512, &
                     8,    -64,     80,   -496,      8,     80,    224,   -496,    512,  -4096,    -64,   -640,    512,    -64, &
                    80,   -640,   -496,   -568,    -64,      8,    224,   -352,   -496,   -424,   -928,   3536,   -496,   4112, &
                    80,    800,   -352,   -424,     80,   -496,      8,     80,    224,   -496,   1088,   -928,   -928,   -352, &
                  -352,   4112,    512,  -4096,    -64,   -640,    512,    -64,  -4096,  32768,    512,   5120,  -4096,    512, &
                  -640,   3968,    -64,   -640,  -1792,   3968,   5120,   -640,    512,    -64,   3968,   4544,    224,  -1792, &
                  -352,  -1072,   3968,   -496,   -496,   3968,   -424,    152,   -640,     80,   -928,   3536,   3536,  -1072, &
                 -1072,   4040,   -640,     80,    -64,      8,   -496,   -568]
  K1( 201,:) = [   3968,   -496,   -640,     80,   -424,    152,  -1792,    224,   3968,   -496,   -352,  -1072,    -64,      8, &
                  -640,     80,   -568,   -496,   3536,  -1072,   -928,   3536,   4040,  -1072,   -640,     80,    -64,      8, &
                  -496,   -568,    -64,      8,    512,    -64,     80,      8,    512,    -64,  -4096,    512,   -640,    -64, &
                   224,   -496,   -496,     80,     80,      8,   3968,   -496,   4544,   -568,   4112,   4040,   -640,     80, &
                  5120,   -640,    800,     80,    -64,      8,    512,    -64,     80,      8,   -352,  -1072,   -424,   -496, &
                   152,   -568,    512,    -64,   5120,   -640,   4544,   3968,  -4096,    512,  32768,  -4096,   5120,    512, &
                   512,    -64,  -4096,    512,   -640,    -64,   3968,  -1792,   -640,    -64,   3968,   -640,   -928,   -352, &
                  1088,   -928,   4112,   -352,   -352,   -424,   4112,   -496,    800,     80,   -928,   3536,   -352,    224, &
                  -424,   -496,   -496,    224,     80,      8,   -496,     80]
  K1( 202,:) = [   -496,   4112,     80,    800,   -352,   -424,    224,   -352,   -496,   -424,   -928,   3536,      8,     80, &
                    80,   -496,   -496,    224,   -928,   -352,   1088,   -928,   4112,   -352,     80,   -496,      8,     80, &
                   224,   -496,      8,     80,    -64,    512,      8,    -64,    -64,   -640,    512,  -4096,    -64,    512, &
                  -496,   -568,     80,   -640,      8,    -64,   -496,   -424,   -568,    152,   -352,  -1072,     80,    800, &
                  -640,   5120,     80,   -640,      8,     80,    -64,    512,      8,    -64,   4112,   4040,   -496,   3968, &
                  -568,   4544,    -64,   -640,   -640,   3968,   3968,  -1792,    512,   5120,  -4096,  32768,    512,  -4096, &
                   -64,   -640,    512,  -4096,    -64,    512,   4544,   3968,    -64,    512,   -640,   5120,   3536,  -1072, &
                  -928,   3536,   4040,  -1072,   -424,    152,   -496,   3968,     80,   -640,   -352,  -1072,    224,  -1792, &
                  -496,   3968,   -568,   -496,      8,    -64,     80,   -640]
  K1( 203,:) = [    152,   -424,     80,   -640,   -496,   3968,  -1072,   3536,   4040,  -1072,   -928,   3536,      8,    -64, &
                  -568,   -496,   -640,     80,    224,  -1792,   -352,  -1072,   3968,   -496,   -568,   -496,      8,    -64, &
                    80,   -640,   -496,    224,     80,      8,   -496,     80,    -64,    512,   -640,    -64,  -4096,    512, &
                     8,    -64,     80,      8,    512,    -64,   -352,   -928,   4112,   -352,   1088,   -928,   -424,   -352, &
                   800,     80,   4112,   -496,   -496,    224,     80,      8,   -496,     80,   -928,   3536,   -352,    224, &
                  -424,   -496,    -64,    512,   4544,   3968,   5120,   -640,    512,  -4096,   5120,    512,  32768,  -4096, &
                  3968,  -1792,   -640,    -64,   3968,   -640,    512,    -64,  -4096,    512,   -640,    -64,   -496,   3968, &
                  4112,   4040,   4544,   -568,     80,   -640,    800,     80,   5120,   -640,   -352,  -1072,   -424,   -496, &
                   152,   -568,    -64,      8,    512,    -64,     80,      8]
  K1( 204,:) = [   -424,   -352,    800,     80,   4112,   -496,   -352,   -928,   4112,   -352,   1088,   -928,     80,      8, &
                  -496,    224,     80,   -496,   -352,    224,   -928,   3536,   -496,   -424,   -496,    224,     80,      8, &
                  -496,     80,   -568,   -496,      8,    -64,     80,   -640,   -640,    -64,    -64,    512,    512,  -4096, &
                    80,      8,      8,    -64,    -64,    512,  -1072,   3536,   4040,  -1072,   -928,   3536,    152,   -424, &
                    80,   -640,   -496,   3968,   -568,   -496,      8,    -64,     80,   -640,   -352,  -1072,    224,  -1792, &
                  -496,   3968,   -640,    -64,   3968,  -1792,   -640,   3968,   5120,    512,    512,  -4096,  -4096,  32768, &
                  4544,   3968,    -64,    512,   -640,   5120,    -64,   -640,    512,  -4096,    -64,    512,   -424,   -496, &
                  -352,  -1072,   -568,    152,    800,     80,     80,   -640,   -640,   5120,   4112,   4040,   -496,   3968, &
                  -568,   4544,      8,     80,    -64,    512,      8,    -64]
  K1( 205,:) = [   3968,   -496,   4544,   -568,   4112,   4040,   -640,     80,   5120,   -640,    800,     80,    -64,      8, &
                   512,    -64,     80,      8,   -352,  -1072,   -424,   -496,    152,   -568,  -1792,    224,   3968,   -496, &
                  -352,  -1072,   3968,   -496,   -640,     80,   -424,    152,   -640,     80,    -64,      8,   -496,   -568, &
                  -928,   3536,   3536,  -1072,  -1072,   4040,    -64,      8,    512,    -64,     80,      8,   -640,     80, &
                   -64,      8,   -496,   -568,  -4096,    512,    512,    -64,    -64,   -640,   -496,     80,    224,   -496, &
                     8,     80,    512,    -64,  -4096,    512,   -640,    -64,   5120,   -640,    512,    -64,   3968,   4544, &
                 32768,  -4096,  -4096,    512,    512,   5120,   3968,   -640,  -1792,   3968,    -64,   -640,   -928,   3536, &
                  -352,    224,   -424,   -496,   1088,   -928,   -928,   -352,   -352,   4112,   4112,   -496,   -352,   -424, &
                    80,    800,   -496,     80,    224,   -496,      8,     80]
  K1( 206,:) = [   -496,   -424,   -568,    152,   -352,  -1072,     80,    800,   -640,   5120,     80,   -640,      8,     80, &
                   -64,    512,      8,    -64,   4112,   4040,   -496,   3968,   -568,   4544,    224,   -352,   -496,   -424, &
                  -928,   3536,   -496,   4112,     80,    800,   -352,   -424,     80,   -496,      8,     80,    224,   -496, &
                  1088,   -928,   -928,   -352,   -352,   4112,      8,     80,    -64,    512,      8,    -64,     80,   -496, &
                     8,     80,    224,   -496,    512,  -4096,    -64,   -640,    512,    -64,     80,   -640,   -496,   -568, &
                   -64,      8,    -64,   -640,    512,  -4096,    -64,    512,   -640,   3968,    -64,   -640,  -1792,   3968, &
                 -4096,  32768,    512,   5120,  -4096,    512,   -640,   5120,   3968,   4544,    512,    -64,   -352,  -1072, &
                   224,  -1792,   -496,   3968,   -928,   3536,   3536,  -1072,  -1072,   4040,   -496,   3968,   -424,    152, &
                  -640,     80,     80,   -640,   -496,   -568,    -64,      8]
  K1( 207,:) = [  -1792,    224,   3968,   -496,   -352,  -1072,   3968,   -496,   -640,     80,   -424,    152,   -640,     80, &
                   -64,      8,   -496,   -568,   -928,   3536,   3536,  -1072,  -1072,   4040,   3968,   -496,   4544,   -568, &
                  4112,   4040,   -640,     80,   5120,   -640,    800,     80,    -64,      8,    512,    -64,     80,      8, &
                  -352,  -1072,   -424,   -496,    152,   -568,   -640,     80,    -64,      8,   -496,   -568,    -64,      8, &
                   512,    -64,     80,      8,    512,    -64,  -4096,    512,   -640,    -64,    224,   -496,   -496,     80, &
                    80,      8,   5120,   -640,    512,    -64,   3968,   4544,    512,    -64,  -4096,    512,   -640,    -64, &
                 -4096,    512,  32768,  -4096,   5120,    512,  -1792,   3968,   3968,   -640,   -640,    -64,   1088,   -928, &
                  -928,   -352,   -352,   4112,   -928,   3536,   -352,    224,   -424,   -496,   -352,   -424,   4112,   -496, &
                   800,     80,    224,   -496,   -496,     80,     80,      8]
  K1( 208,:) = [    224,   -352,   -496,   -424,   -928,   3536,   -496,   4112,     80,    800,   -352,   -424,     80,   -496, &
                     8,     80,    224,   -496,   1088,   -928,   -928,   -352,   -352,   4112,   -496,   -424,   -568,    152, &
                  -352,  -1072,     80,    800,   -640,   5120,     80,   -640,      8,     80,    -64,    512,      8,    -64, &
                  4112,   4040,   -496,   3968,   -568,   4544,     80,   -496,      8,     80,    224,   -496,      8,     80, &
                   -64,    512,      8,    -64,    -64,   -640,    512,  -4096,    -64,    512,   -496,   -568,     80,   -640, &
                     8,    -64,   -640,   3968,    -64,   -640,  -1792,   3968,    -64,   -640,    512,  -4096,    -64,    512, &
                   512,   5120,  -4096,  32768,    512,  -4096,   3968,   4544,   -640,   5120,    -64,    512,   -928,   3536, &
                  3536,  -1072,  -1072,   4040,   -352,  -1072,    224,  -1792,   -496,   3968,   -424,    152,   -496,   3968, &
                    80,   -640,   -496,   -568,     80,   -640,      8,    -64]
  K1( 209,:) = [  -1072,   3536,   4040,  -1072,   -928,   3536,    152,   -424,     80,   -640,   -496,   3968,   -568,   -496, &
                     8,    -64,     80,   -640,   -352,  -1072,    224,  -1792,   -496,   3968,   -352,   -928,   4112,   -352, &
                  1088,   -928,   -424,   -352,    800,     80,   4112,   -496,   -496,    224,     80,      8,   -496,     80, &
                  -928,   3536,   -352,    224,   -424,   -496,   -568,   -496,      8,    -64,     80,   -640,   -496,    224, &
                    80,      8,   -496,     80,    -64,    512,   -640,    -64,  -4096,    512,      8,    -64,     80,      8, &
                   512,    -64,   4544,   3968,    -64,    512,   -640,   5120,   3968,  -1792,   -640,    -64,   3968,   -640, &
                   512,  -4096,   5120,    512,  32768,  -4096,    -64,    512,   -640,    -64,  -4096,    512,   4112,   4040, &
                  -496,   3968,   -568,   4544,   -352,  -1072,   -424,   -496,    152,   -568,     80,   -640,    800,     80, &
                  5120,   -640,      8,    -64,     80,      8,    512,    -64]
  K1( 210,:) = [   -352,   -928,   4112,   -352,   1088,   -928,   -424,   -352,    800,     80,   4112,   -496,   -496,    224, &
                    80,      8,   -496,     80,   -928,   3536,   -352,    224,   -424,   -496,  -1072,   3536,   4040,  -1072, &
                  -928,   3536,    152,   -424,     80,   -640,   -496,   3968,   -568,   -496,      8,    -64,     80,   -640, &
                  -352,  -1072,    224,  -1792,   -496,   3968,   -496,    224,     80,      8,   -496,     80,   -568,   -496, &
                     8,    -64,     80,   -640,   -640,    -64,    -64,    512,    512,  -4096,     80,      8,      8,    -64, &
                   -64,    512,   3968,  -1792,   -640,    -64,   3968,   -640,   4544,   3968,    -64,    512,   -640,   5120, &
                  5120,    512,    512,  -4096,  -4096,  32768,   -640,    -64,    -64,    512,    512,  -4096,   -352,  -1072, &
                  -424,   -496,    152,   -568,   4112,   4040,   -496,   3968,   -568,   4544,    800,     80,     80,   -640, &
                  -640,   5120,     80,      8,      8,    -64,    -64,    512]
  K1( 211,:) = [   4040,   4112,   -568,   4544,   -496,   3968,  -1072,   -352,    152,   -568,   -424,   -496,      8,    -64, &
                    80,      8,    512,    -64,     80,   -640,    800,     80,   5120,   -640,  -1072,   -352,   -496,   3968, &
                   224,  -1792,   3536,   -928,  -1072,   4040,   3536,  -1072,     80,   -640,   -496,   -568,    -64,      8, &
                  -496,   3968,   -424,    152,   -640,     80,   3536,   -928,   -424,   -496,   -352,    224,   -928,   1088, &
                  -352,   4112,   -928,   -352,   -496,     80,    224,   -496,      8,     80,   4112,   -496,   -352,   -424, &
                    80,    800,    -64,    512,   -640,    -64,  -4096,    512,   -640,   5120,   3968,   4544,    512,    -64, &
                  3968,   -640,  -1792,   3968,    -64,   -640,  32768,  -4096,  -4096,    512,    512,   5120,      8,    -64, &
                    80,      8,    512,    -64,     80,   -640,   -496,   -568,    -64,      8,   -496,     80,    224,   -496, &
                     8,     80,  -4096,    512,    512,    -64,    -64,   -640]
  K1( 212,:) = [  -1072,   -352,    152,   -568,   -424,   -496,   4040,   4112,   -568,   4544,   -496,   3968,     80,      8, &
                     8,    -64,    -64,    512,    800,     80,     80,   -640,   -640,   5120,   3536,   -928,   -424,   -496, &
                  -352,    224,   -928,   1088,   -352,   4112,   -928,   -352,   -496,     80,    224,   -496,      8,     80, &
                  4112,   -496,   -352,   -424,     80,    800,  -1072,   -352,   -496,   3968,    224,  -1792,   3536,   -928, &
                 -1072,   4040,   3536,  -1072,     80,   -640,   -496,   -568,    -64,      8,   -496,   3968,   -424,    152, &
                  -640,     80,   -640,    -64,    -64,    512,    512,  -4096,   3968,   -640,  -1792,   3968,    -64,   -640, &
                  -640,   5120,   3968,   4544,    512,    -64,  -4096,  32768,    512,   5120,  -4096,    512,     80,      8, &
                     8,    -64,    -64,    512,   -496,     80,    224,   -496,      8,     80,     80,   -640,   -496,   -568, &
                   -64,      8,    512,  -4096,    -64,   -640,    512,    -64]
  K1( 213,:) = [  -1072,   -352,   -496,   3968,    224,  -1792,   3536,   -928,  -1072,   4040,   3536,  -1072,     80,   -640, &
                  -496,   -568,    -64,      8,   -496,   3968,   -424,    152,   -640,     80,   4040,   4112,   -568,   4544, &
                  -496,   3968,  -1072,   -352,    152,   -568,   -424,   -496,      8,    -64,     80,      8,    512,    -64, &
                    80,   -640,    800,     80,   5120,   -640,   -928,   1088,   -352,   4112,   -928,   -352,   3536,   -928, &
                  -424,   -496,   -352,    224,    224,   -496,   -496,     80,     80,      8,   -352,   -424,   4112,   -496, &
                   800,     80,   -640,   5120,   3968,   4544,    512,    -64,    -64,    512,   -640,    -64,  -4096,    512, &
                 -1792,   3968,   3968,   -640,   -640,    -64,  -4096,    512,  32768,  -4096,   5120,    512,     80,   -640, &
                  -496,   -568,    -64,      8,      8,    -64,     80,      8,    512,    -64,    224,   -496,   -496,     80, &
                    80,      8,    512,    -64,  -4096,    512,   -640,    -64]
  K1( 214,:) = [   3536,   -928,   -424,   -496,   -352,    224,   -928,   1088,   -352,   4112,   -928,   -352,   -496,     80, &
                   224,   -496,      8,     80,   4112,   -496,   -352,   -424,     80,    800,  -1072,   -352,    152,   -568, &
                  -424,   -496,   4040,   4112,   -568,   4544,   -496,   3968,     80,      8,      8,    -64,    -64,    512, &
                   800,     80,     80,   -640,   -640,   5120,   3536,   -928,  -1072,   4040,   3536,  -1072,  -1072,   -352, &
                  -496,   3968,    224,  -1792,   -496,   -568,     80,   -640,      8,    -64,   -424,    152,   -496,   3968, &
                    80,   -640,   3968,   -640,  -1792,   3968,    -64,   -640,   -640,    -64,    -64,    512,    512,  -4096, &
                  3968,   4544,   -640,   5120,    -64,    512,    512,   5120,  -4096,  32768,    512,  -4096,   -496,     80, &
                   224,   -496,      8,     80,     80,      8,      8,    -64,    -64,    512,   -496,   -568,     80,   -640, &
                     8,    -64,    -64,   -640,    512,  -4096,    -64,    512]
  K1( 215,:) = [   3536,   -928,  -1072,   4040,   3536,  -1072,  -1072,   -352,   -496,   3968,    224,  -1792,   -496,   -568, &
                    80,   -640,      8,    -64,   -424,    152,   -496,   3968,     80,   -640,   -928,   1088,   -352,   4112, &
                  -928,   -352,   3536,   -928,   -424,   -496,   -352,    224,    224,   -496,   -496,     80,     80,      8, &
                  -352,   -424,   4112,   -496,    800,     80,   4040,   4112,   -568,   4544,   -496,   3968,  -1072,   -352, &
                   152,   -568,   -424,   -496,      8,    -64,     80,      8,    512,    -64,     80,   -640,    800,     80, &
                  5120,   -640,   3968,   4544,   -640,   5120,    -64,    512,  -1792,   3968,   3968,   -640,   -640,    -64, &
                   -64,    512,   -640,    -64,  -4096,    512,    512,  -4096,   5120,    512,  32768,  -4096,   -496,   -568, &
                    80,   -640,      8,    -64,    224,   -496,   -496,     80,     80,      8,      8,    -64,     80,      8, &
                   512,    -64,    -64,    512,   -640,    -64,  -4096,    512]
  K1( 216,:) = [   -928,   1088,   -352,   4112,   -928,   -352,   3536,   -928,   -424,   -496,   -352,    224,    224,   -496, &
                  -496,     80,     80,      8,   -352,   -424,   4112,   -496,    800,     80,   3536,   -928,  -1072,   4040, &
                  3536,  -1072,  -1072,   -352,   -496,   3968,    224,  -1792,   -496,   -568,     80,   -640,      8,    -64, &
                  -424,    152,   -496,   3968,     80,   -640,  -1072,   -352,    152,   -568,   -424,   -496,   4040,   4112, &
                  -568,   4544,   -496,   3968,     80,      8,      8,    -64,    -64,    512,    800,     80,     80,   -640, &
                  -640,   5120,  -1792,   3968,   3968,   -640,   -640,    -64,   3968,   4544,   -640,   5120,    -64,    512, &
                  -640,    -64,    -64,    512,    512,  -4096,   5120,    512,    512,  -4096,  -4096,  32768,    224,   -496, &
                  -496,     80,     80,      8,   -496,   -568,     80,   -640,      8,    -64,     80,      8,      8,    -64, &
                   -64,    512,   -640,    -64,    -64,    512,    512,  -4096]
  K1( 217,:) = [      8,    -64,     80,      8,    512,    -64,     80,   -640,   -496,   -568,    -64,      8,   -496,     80, &
                   224,   -496,      8,     80,  -4096,    512,    512,    -64,    -64,   -640,     80,   -640,    800,     80, &
                  5120,   -640,   -496,   3968,   4112,   4040,   4544,   -568,   -424,   -496,   -352,  -1072,   -568,    152, &
                   512,    -64,    -64,      8,      8,     80,   -496,   3968,   -424,    152,   -640,     80,    224,  -1792, &
                  -352,  -1072,   3968,   -496,   3536,  -1072,   -928,   3536,   4040,  -1072,    -64,      8,   -640,     80, &
                  -568,   -496,   4112,   -496,   -352,   -424,     80,    800,   -352,    224,   -928,   3536,   -496,   -424, &
                  -928,   -352,   1088,   -928,   4112,   -352,      8,     80,     80,   -496,   -496,    224,  32768,  -4096, &
                 -4096,    512,    512,   5120,  -4096,    512,    512,    -64,    -64,   -640,    512,    -64,   5120,   -640, &
                  4544,   3968,    -64,   -640,   -640,   3968,   3968,  -1792]
  K1( 218,:) = [     80,      8,      8,    -64,    -64,    512,   -496,     80,    224,   -496,      8,     80,     80,   -640, &
                  -496,   -568,    -64,      8,    512,  -4096,    -64,   -640,    512,    -64,    800,     80,     80,   -640, &
                  -640,   5120,   -424,   -496,   -352,  -1072,   -568,    152,   -496,   3968,   4112,   4040,   4544,   -568, &
                   -64,    512,      8,     80,    -64,      8,   4112,   -496,   -352,   -424,     80,    800,   -352,    224, &
                  -928,   3536,   -496,   -424,   -928,   -352,   1088,   -928,   4112,   -352,      8,     80,     80,   -496, &
                  -496,    224,   -496,   3968,   -424,    152,   -640,     80,    224,  -1792,   -352,  -1072,   3968,   -496, &
                  3536,  -1072,   -928,   3536,   4040,  -1072,    -64,      8,   -640,     80,   -568,   -496,  -4096,  32768, &
                   512,   5120,  -4096,    512,    512,  -4096,    -64,   -640,    512,    -64,    -64,   -640,   -640,   3968, &
                  3968,  -1792,    512,    -64,   5120,   -640,   4544,   3968]
  K1( 219,:) = [     80,   -640,   -496,   -568,    -64,      8,      8,    -64,     80,      8,    512,    -64,    224,   -496, &
                  -496,     80,     80,      8,    512,    -64,  -4096,    512,   -640,    -64,   -496,   3968,   -424,    152, &
                  -640,     80,    224,  -1792,   -352,  -1072,   3968,   -496,   3536,  -1072,   -928,   3536,   4040,  -1072, &
                   -64,      8,   -640,     80,   -568,   -496,     80,   -640,    800,     80,   5120,   -640,   -496,   3968, &
                  4112,   4040,   4544,   -568,   -424,   -496,   -352,  -1072,   -568,    152,    512,    -64,    -64,      8, &
                     8,     80,   -352,   -424,   4112,   -496,    800,     80,   -928,   -352,   1088,   -928,   4112,   -352, &
                  -352,    224,   -928,   3536,   -496,   -424,     80,      8,   -496,    224,     80,   -496,  -4096,    512, &
                 32768,  -4096,   5120,    512,    512,    -64,   5120,   -640,   4544,   3968,  -4096,    512,    512,    -64, &
                   -64,   -640,   -640,    -64,   3968,  -1792,   -640,   3968]
  K1( 220,:) = [   -496,     80,    224,   -496,      8,     80,     80,      8,      8,    -64,    -64,    512,   -496,   -568, &
                    80,   -640,      8,    -64,    -64,   -640,    512,  -4096,    -64,    512,   4112,   -496,   -352,   -424, &
                    80,    800,   -352,    224,   -928,   3536,   -496,   -424,   -928,   -352,   1088,   -928,   4112,   -352, &
                     8,     80,     80,   -496,   -496,    224,    800,     80,     80,   -640,   -640,   5120,   -424,   -496, &
                  -352,  -1072,   -568,    152,   -496,   3968,   4112,   4040,   4544,   -568,    -64,    512,      8,     80, &
                   -64,      8,   -424,    152,   -496,   3968,     80,   -640,   3536,  -1072,   -928,   3536,   4040,  -1072, &
                   224,  -1792,   -352,  -1072,   3968,   -496,      8,    -64,   -568,   -496,   -640,     80,    512,   5120, &
                 -4096,  32768,    512,  -4096,    -64,   -640,   -640,   3968,   3968,  -1792,    512,  -4096,    -64,   -640, &
                   512,    -64,    -64,    512,   4544,   3968,   5120,   -640]
  K1( 221,:) = [   -496,   -568,     80,   -640,      8,    -64,    224,   -496,   -496,     80,     80,      8,      8,    -64, &
                    80,      8,    512,    -64,    -64,    512,   -640,    -64,  -4096,    512,   -424,    152,   -496,   3968, &
                    80,   -640,   3536,  -1072,   -928,   3536,   4040,  -1072,    224,  -1792,   -352,  -1072,   3968,   -496, &
                     8,    -64,   -568,   -496,   -640,     80,   -352,   -424,   4112,   -496,    800,     80,   -928,   -352, &
                  1088,   -928,   4112,   -352,   -352,    224,   -928,   3536,   -496,   -424,     80,      8,   -496,    224, &
                    80,   -496,     80,   -640,    800,     80,   5120,   -640,   -496,   3968,   4112,   4040,   4544,   -568, &
                  -424,   -496,   -352,  -1072,   -568,    152,    512,    -64,    -64,      8,      8,     80,    512,  -4096, &
                  5120,    512,  32768,  -4096,    -64,    512,   4544,   3968,   5120,   -640,   -640,    -64,   3968,  -1792, &
                  -640,   3968,  -4096,    512,    512,    -64,    -64,   -640]
  K1( 222,:) = [    224,   -496,   -496,     80,     80,      8,   -496,   -568,     80,   -640,      8,    -64,     80,      8, &
                     8,    -64,    -64,    512,   -640,    -64,    -64,    512,    512,  -4096,   -352,   -424,   4112,   -496, &
                   800,     80,   -928,   -352,   1088,   -928,   4112,   -352,   -352,    224,   -928,   3536,   -496,   -424, &
                    80,      8,   -496,    224,     80,   -496,   -424,    152,   -496,   3968,     80,   -640,   3536,  -1072, &
                  -928,   3536,   4040,  -1072,    224,  -1792,   -352,  -1072,   3968,   -496,      8,    -64,   -568,   -496, &
                  -640,     80,    800,     80,     80,   -640,   -640,   5120,   -424,   -496,   -352,  -1072,   -568,    152, &
                  -496,   3968,   4112,   4040,   4544,   -568,    -64,    512,      8,     80,    -64,      8,   5120,    512, &
                   512,  -4096,  -4096,  32768,   -640,    -64,   3968,  -1792,   -640,   3968,    -64,    512,   4544,   3968, &
                  5120,   -640,    512,  -4096,    -64,   -640,    512,    -64]
  K1( 223,:) = [     80,   -640,    800,     80,   5120,   -640,   -496,   3968,   4112,   4040,   4544,   -568,   -424,   -496, &
                  -352,  -1072,   -568,    152,    512,    -64,    -64,      8,      8,     80,      8,    -64,     80,      8, &
                   512,    -64,     80,   -640,   -496,   -568,    -64,      8,   -496,     80,    224,   -496,      8,     80, &
                 -4096,    512,    512,    -64,    -64,   -640,    224,  -1792,   -352,  -1072,   3968,   -496,   -496,   3968, &
                  -424,    152,   -640,     80,   -928,   3536,   3536,  -1072,  -1072,   4040,   -640,     80,    -64,      8, &
                  -496,   -568,   -352,    224,   -928,   3536,   -496,   -424,   4112,   -496,   -352,   -424,     80,    800, &
                  1088,   -928,   -928,   -352,   -352,   4112,     80,   -496,      8,     80,    224,   -496,  -4096,    512, &
                   512,    -64,    -64,   -640,  32768,  -4096,  -4096,    512,    512,   5120,   5120,   -640,    512,    -64, &
                  3968,   4544,   -640,   3968,    -64,   -640,  -1792,   3968]
  K1( 224,:) = [    800,     80,     80,   -640,   -640,   5120,   -424,   -496,   -352,  -1072,   -568,    152,   -496,   3968, &
                  4112,   4040,   4544,   -568,    -64,    512,      8,     80,    -64,      8,     80,      8,      8,    -64, &
                   -64,    512,   -496,     80,    224,   -496,      8,     80,     80,   -640,   -496,   -568,    -64,      8, &
                   512,  -4096,    -64,   -640,    512,    -64,   -352,    224,   -928,   3536,   -496,   -424,   4112,   -496, &
                  -352,   -424,     80,    800,   1088,   -928,   -928,   -352,   -352,   4112,     80,   -496,      8,     80, &
                   224,   -496,    224,  -1792,   -352,  -1072,   3968,   -496,   -496,   3968,   -424,    152,   -640,     80, &
                  -928,   3536,   3536,  -1072,  -1072,   4040,   -640,     80,    -64,      8,   -496,   -568,    512,  -4096, &
                   -64,   -640,    512,    -64,  -4096,  32768,    512,   5120,  -4096,    512,   -640,   3968,    -64,   -640, &
                 -1792,   3968,   5120,   -640,    512,    -64,   3968,   4544]
  K1( 225,:) = [   -496,   3968,   -424,    152,   -640,     80,    224,  -1792,   -352,  -1072,   3968,   -496,   3536,  -1072, &
                  -928,   3536,   4040,  -1072,    -64,      8,   -640,     80,   -568,   -496,     80,   -640,   -496,   -568, &
                   -64,      8,      8,    -64,     80,      8,    512,    -64,    224,   -496,   -496,     80,     80,      8, &
                   512,    -64,  -4096,    512,   -640,    -64,   -496,   3968,   4112,   4040,   4544,   -568,     80,   -640, &
                   800,     80,   5120,   -640,   -352,  -1072,   -424,   -496,    152,   -568,    -64,      8,    512,    -64, &
                    80,      8,   -928,   -352,   1088,   -928,   4112,   -352,   -352,   -424,   4112,   -496,    800,     80, &
                  -928,   3536,   -352,    224,   -424,   -496,   -496,    224,     80,      8,   -496,     80,    512,    -64, &
                  5120,   -640,   4544,   3968,  -4096,    512,  32768,  -4096,   5120,    512,    512,    -64,  -4096,    512, &
                  -640,    -64,   3968,  -1792,   -640,    -64,   3968,   -640]
  K1( 226,:) = [   4112,   -496,   -352,   -424,     80,    800,   -352,    224,   -928,   3536,   -496,   -424,   -928,   -352, &
                  1088,   -928,   4112,   -352,      8,     80,     80,   -496,   -496,    224,   -496,     80,    224,   -496, &
                     8,     80,     80,      8,      8,    -64,    -64,    512,   -496,   -568,     80,   -640,      8,    -64, &
                   -64,   -640,    512,  -4096,    -64,    512,   -424,   -496,   -352,  -1072,   -568,    152,    800,     80, &
                    80,   -640,   -640,   5120,   4112,   4040,   -496,   3968,   -568,   4544,      8,     80,    -64,    512, &
                     8,    -64,   3536,  -1072,   -928,   3536,   4040,  -1072,   -424,    152,   -496,   3968,     80,   -640, &
                  -352,  -1072,    224,  -1792,   -496,   3968,   -568,   -496,      8,    -64,     80,   -640,    -64,   -640, &
                  -640,   3968,   3968,  -1792,    512,   5120,  -4096,  32768,    512,  -4096,    -64,   -640,    512,  -4096, &
                   -64,    512,   4544,   3968,    -64,    512,   -640,   5120]
  K1( 227,:) = [   -424,    152,   -496,   3968,     80,   -640,   3536,  -1072,   -928,   3536,   4040,  -1072,    224,  -1792, &
                  -352,  -1072,   3968,   -496,      8,    -64,   -568,   -496,   -640,     80,   -496,   -568,     80,   -640, &
                     8,    -64,    224,   -496,   -496,     80,     80,      8,      8,    -64,     80,      8,    512,    -64, &
                   -64,    512,   -640,    -64,  -4096,    512,   -928,   -352,   1088,   -928,   4112,   -352,   -352,   -424, &
                  4112,   -496,    800,     80,   -928,   3536,   -352,    224,   -424,   -496,   -496,    224,     80,      8, &
                  -496,     80,   -496,   3968,   4112,   4040,   4544,   -568,     80,   -640,    800,     80,   5120,   -640, &
                  -352,  -1072,   -424,   -496,    152,   -568,    -64,      8,    512,    -64,     80,      8,    -64,    512, &
                  4544,   3968,   5120,   -640,    512,  -4096,   5120,    512,  32768,  -4096,   3968,  -1792,   -640,    -64, &
                  3968,   -640,    512,    -64,  -4096,    512,   -640,    -64]
  K1( 228,:) = [   -352,   -424,   4112,   -496,    800,     80,   -928,   -352,   1088,   -928,   4112,   -352,   -352,    224, &
                  -928,   3536,   -496,   -424,     80,      8,   -496,    224,     80,   -496,    224,   -496,   -496,     80, &
                    80,      8,   -496,   -568,     80,   -640,      8,    -64,     80,      8,      8,    -64,    -64,    512, &
                  -640,    -64,    -64,    512,    512,  -4096,   3536,  -1072,   -928,   3536,   4040,  -1072,   -424,    152, &
                  -496,   3968,     80,   -640,   -352,  -1072,    224,  -1792,   -496,   3968,   -568,   -496,      8,    -64, &
                    80,   -640,   -424,   -496,   -352,  -1072,   -568,    152,    800,     80,     80,   -640,   -640,   5120, &
                  4112,   4040,   -496,   3968,   -568,   4544,      8,     80,    -64,    512,      8,    -64,   -640,    -64, &
                  3968,  -1792,   -640,   3968,   5120,    512,    512,  -4096,  -4096,  32768,   4544,   3968,    -64,    512, &
                  -640,   5120,    -64,   -640,    512,  -4096,    -64,    512]
  K1( 229,:) = [   -496,   3968,   4112,   4040,   4544,   -568,     80,   -640,    800,     80,   5120,   -640,   -352,  -1072, &
                  -424,   -496,    152,   -568,    -64,      8,    512,    -64,     80,      8,    224,  -1792,   -352,  -1072, &
                  3968,   -496,   -496,   3968,   -424,    152,   -640,     80,   -928,   3536,   3536,  -1072,  -1072,   4040, &
                  -640,     80,    -64,      8,   -496,   -568,      8,    -64,     80,      8,    512,    -64,     80,   -640, &
                  -496,   -568,    -64,      8,   -496,     80,    224,   -496,      8,     80,  -4096,    512,    512,    -64, &
                   -64,   -640,   -928,   3536,   -352,    224,   -424,   -496,   1088,   -928,   -928,   -352,   -352,   4112, &
                  4112,   -496,   -352,   -424,     80,    800,   -496,     80,    224,   -496,      8,     80,    512,    -64, &
                 -4096,    512,   -640,    -64,   5120,   -640,    512,    -64,   3968,   4544,  32768,  -4096,  -4096,    512, &
                   512,   5120,   3968,   -640,  -1792,   3968,    -64,   -640]
  K1( 230,:) = [   -424,   -496,   -352,  -1072,   -568,    152,    800,     80,     80,   -640,   -640,   5120,   4112,   4040, &
                  -496,   3968,   -568,   4544,      8,     80,    -64,    512,      8,    -64,   -352,    224,   -928,   3536, &
                  -496,   -424,   4112,   -496,   -352,   -424,     80,    800,   1088,   -928,   -928,   -352,   -352,   4112, &
                    80,   -496,      8,     80,    224,   -496,     80,      8,      8,    -64,    -64,    512,   -496,     80, &
                   224,   -496,      8,     80,     80,   -640,   -496,   -568,    -64,      8,    512,  -4096,    -64,   -640, &
                   512,    -64,   -352,  -1072,    224,  -1792,   -496,   3968,   -928,   3536,   3536,  -1072,  -1072,   4040, &
                  -496,   3968,   -424,    152,   -640,     80,     80,   -640,   -496,   -568,    -64,      8,    -64,   -640, &
                   512,  -4096,    -64,    512,   -640,   3968,    -64,   -640,  -1792,   3968,  -4096,  32768,    512,   5120, &
                 -4096,    512,   -640,   5120,   3968,   4544,    512,    -64]
  K1( 231,:) = [    224,  -1792,   -352,  -1072,   3968,   -496,   -496,   3968,   -424,    152,   -640,     80,   -928,   3536, &
                  3536,  -1072,  -1072,   4040,   -640,     80,    -64,      8,   -496,   -568,   -496,   3968,   4112,   4040, &
                  4544,   -568,     80,   -640,    800,     80,   5120,   -640,   -352,  -1072,   -424,   -496,    152,   -568, &
                   -64,      8,    512,    -64,     80,      8,     80,   -640,   -496,   -568,    -64,      8,      8,    -64, &
                    80,      8,    512,    -64,    224,   -496,   -496,     80,     80,      8,    512,    -64,  -4096,    512, &
                  -640,    -64,   1088,   -928,   -928,   -352,   -352,   4112,   -928,   3536,   -352,    224,   -424,   -496, &
                  -352,   -424,   4112,   -496,    800,     80,    224,   -496,   -496,     80,     80,      8,   5120,   -640, &
                   512,    -64,   3968,   4544,    512,    -64,  -4096,    512,   -640,    -64,  -4096,    512,  32768,  -4096, &
                  5120,    512,  -1792,   3968,   3968,   -640,   -640,    -64]
  K1( 232,:) = [   -352,    224,   -928,   3536,   -496,   -424,   4112,   -496,   -352,   -424,     80,    800,   1088,   -928, &
                  -928,   -352,   -352,   4112,     80,   -496,      8,     80,    224,   -496,   -424,   -496,   -352,  -1072, &
                  -568,    152,    800,     80,     80,   -640,   -640,   5120,   4112,   4040,   -496,   3968,   -568,   4544, &
                     8,     80,    -64,    512,      8,    -64,   -496,     80,    224,   -496,      8,     80,     80,      8, &
                     8,    -64,    -64,    512,   -496,   -568,     80,   -640,      8,    -64,    -64,   -640,    512,  -4096, &
                   -64,    512,   -928,   3536,   3536,  -1072,  -1072,   4040,   -352,  -1072,    224,  -1792,   -496,   3968, &
                  -424,    152,   -496,   3968,     80,   -640,   -496,   -568,     80,   -640,      8,    -64,   -640,   3968, &
                   -64,   -640,  -1792,   3968,    -64,   -640,    512,  -4096,    -64,    512,    512,   5120,  -4096,  32768, &
                   512,  -4096,   3968,   4544,   -640,   5120,    -64,    512]
  K1( 233,:) = [   3536,  -1072,   -928,   3536,   4040,  -1072,   -424,    152,   -496,   3968,     80,   -640,   -352,  -1072, &
                   224,  -1792,   -496,   3968,   -568,   -496,      8,    -64,     80,   -640,   -928,   -352,   1088,   -928, &
                  4112,   -352,   -352,   -424,   4112,   -496,    800,     80,   -928,   3536,   -352,    224,   -424,   -496, &
                  -496,    224,     80,      8,   -496,     80,   -496,   -568,     80,   -640,      8,    -64,    224,   -496, &
                  -496,     80,     80,      8,      8,    -64,     80,      8,    512,    -64,    -64,    512,   -640,    -64, &
                 -4096,    512,   4112,   4040,   -496,   3968,   -568,   4544,   -352,  -1072,   -424,   -496,    152,   -568, &
                    80,   -640,    800,     80,   5120,   -640,      8,    -64,     80,      8,    512,    -64,   4544,   3968, &
                   -64,    512,   -640,   5120,   3968,  -1792,   -640,    -64,   3968,   -640,    512,  -4096,   5120,    512, &
                 32768,  -4096,    -64,    512,   -640,    -64,  -4096,    512]
  K1( 234,:) = [   -928,   -352,   1088,   -928,   4112,   -352,   -352,   -424,   4112,   -496,    800,     80,   -928,   3536, &
                  -352,    224,   -424,   -496,   -496,    224,     80,      8,   -496,     80,   3536,  -1072,   -928,   3536, &
                  4040,  -1072,   -424,    152,   -496,   3968,     80,   -640,   -352,  -1072,    224,  -1792,   -496,   3968, &
                  -568,   -496,      8,    -64,     80,   -640,    224,   -496,   -496,     80,     80,      8,   -496,   -568, &
                    80,   -640,      8,    -64,     80,      8,      8,    -64,    -64,    512,   -640,    -64,    -64,    512, &
                   512,  -4096,   -352,  -1072,   -424,   -496,    152,   -568,   4112,   4040,   -496,   3968,   -568,   4544, &
                   800,     80,     80,   -640,   -640,   5120,     80,      8,      8,    -64,    -64,    512,   3968,  -1792, &
                  -640,    -64,   3968,   -640,   4544,   3968,    -64,    512,   -640,   5120,   5120,    512,    512,  -4096, &
                 -4096,  32768,   -640,    -64,    -64,    512,    512,  -4096]
  K1( 235,:) = [   4112,   4040,   -496,   3968,   -568,   4544,   -352,  -1072,   -424,   -496,    152,   -568,     80,   -640, &
                   800,     80,   5120,   -640,      8,    -64,     80,      8,    512,    -64,   -352,  -1072,    224,  -1792, &
                  -496,   3968,   -928,   3536,   3536,  -1072,  -1072,   4040,   -496,   3968,   -424,    152,   -640,     80, &
                    80,   -640,   -496,   -568,    -64,      8,   -928,   3536,   -352,    224,   -424,   -496,   1088,   -928, &
                  -928,   -352,   -352,   4112,   4112,   -496,   -352,   -424,     80,    800,   -496,     80,    224,   -496, &
                     8,     80,      8,    -64,     80,      8,    512,    -64,     80,   -640,   -496,   -568,    -64,      8, &
                  -496,     80,    224,   -496,      8,     80,  -4096,    512,    512,    -64,    -64,   -640,    -64,    512, &
                  -640,    -64,  -4096,    512,   -640,   5120,   3968,   4544,    512,    -64,   3968,   -640,  -1792,   3968, &
                   -64,   -640,  32768,  -4096,  -4096,    512,    512,   5120]
  K1( 236,:) = [   -352,  -1072,   -424,   -496,    152,   -568,   4112,   4040,   -496,   3968,   -568,   4544,    800,     80, &
                    80,   -640,   -640,   5120,     80,      8,      8,    -64,    -64,    512,   -928,   3536,   -352,    224, &
                  -424,   -496,   1088,   -928,   -928,   -352,   -352,   4112,   4112,   -496,   -352,   -424,     80,    800, &
                  -496,     80,    224,   -496,      8,     80,   -352,  -1072,    224,  -1792,   -496,   3968,   -928,   3536, &
                  3536,  -1072,  -1072,   4040,   -496,   3968,   -424,    152,   -640,     80,     80,   -640,   -496,   -568, &
                   -64,      8,     80,      8,      8,    -64,    -64,    512,   -496,     80,    224,   -496,      8,     80, &
                    80,   -640,   -496,   -568,    -64,      8,    512,  -4096,    -64,   -640,    512,    -64,   -640,    -64, &
                   -64,    512,    512,  -4096,   3968,   -640,  -1792,   3968,    -64,   -640,   -640,   5120,   3968,   4544, &
                   512,    -64,  -4096,  32768,    512,   5120,  -4096,    512]
  K1( 237,:) = [   -352,  -1072,    224,  -1792,   -496,   3968,   -928,   3536,   3536,  -1072,  -1072,   4040,   -496,   3968, &
                  -424,    152,   -640,     80,     80,   -640,   -496,   -568,    -64,      8,   4112,   4040,   -496,   3968, &
                  -568,   4544,   -352,  -1072,   -424,   -496,    152,   -568,     80,   -640,    800,     80,   5120,   -640, &
                     8,    -64,     80,      8,    512,    -64,   1088,   -928,   -928,   -352,   -352,   4112,   -928,   3536, &
                  -352,    224,   -424,   -496,   -352,   -424,   4112,   -496,    800,     80,    224,   -496,   -496,     80, &
                    80,      8,     80,   -640,   -496,   -568,    -64,      8,      8,    -64,     80,      8,    512,    -64, &
                   224,   -496,   -496,     80,     80,      8,    512,    -64,  -4096,    512,   -640,    -64,   -640,   5120, &
                  3968,   4544,    512,    -64,    -64,    512,   -640,    -64,  -4096,    512,  -1792,   3968,   3968,   -640, &
                  -640,    -64,  -4096,    512,  32768,  -4096,   5120,    512]
  K1( 238,:) = [   -928,   3536,   -352,    224,   -424,   -496,   1088,   -928,   -928,   -352,   -352,   4112,   4112,   -496, &
                  -352,   -424,     80,    800,   -496,     80,    224,   -496,      8,     80,   -352,  -1072,   -424,   -496, &
                   152,   -568,   4112,   4040,   -496,   3968,   -568,   4544,    800,     80,     80,   -640,   -640,   5120, &
                    80,      8,      8,    -64,    -64,    512,   -928,   3536,   3536,  -1072,  -1072,   4040,   -352,  -1072, &
                   224,  -1792,   -496,   3968,   -424,    152,   -496,   3968,     80,   -640,   -496,   -568,     80,   -640, &
                     8,    -64,   -496,     80,    224,   -496,      8,     80,     80,      8,      8,    -64,    -64,    512, &
                  -496,   -568,     80,   -640,      8,    -64,    -64,   -640,    512,  -4096,    -64,    512,   3968,   -640, &
                 -1792,   3968,    -64,   -640,   -640,    -64,    -64,    512,    512,  -4096,   3968,   4544,   -640,   5120, &
                   -64,    512,    512,   5120,  -4096,  32768,    512,  -4096]
  K1( 239,:) = [   -928,   3536,   3536,  -1072,  -1072,   4040,   -352,  -1072,    224,  -1792,   -496,   3968,   -424,    152, &
                  -496,   3968,     80,   -640,   -496,   -568,     80,   -640,      8,    -64,   1088,   -928,   -928,   -352, &
                  -352,   4112,   -928,   3536,   -352,    224,   -424,   -496,   -352,   -424,   4112,   -496,    800,     80, &
                   224,   -496,   -496,     80,     80,      8,   4112,   4040,   -496,   3968,   -568,   4544,   -352,  -1072, &
                  -424,   -496,    152,   -568,     80,   -640,    800,     80,   5120,   -640,      8,    -64,     80,      8, &
                   512,    -64,   -496,   -568,     80,   -640,      8,    -64,    224,   -496,   -496,     80,     80,      8, &
                     8,    -64,     80,      8,    512,    -64,    -64,    512,   -640,    -64,  -4096,    512,   3968,   4544, &
                  -640,   5120,    -64,    512,  -1792,   3968,   3968,   -640,   -640,    -64,    -64,    512,   -640,    -64, &
                 -4096,    512,    512,  -4096,   5120,    512,  32768,  -4096]
  K1( 240,:) = [   1088,   -928,   -928,   -352,   -352,   4112,   -928,   3536,   -352,    224,   -424,   -496,   -352,   -424, &
                  4112,   -496,    800,     80,    224,   -496,   -496,     80,     80,      8,   -928,   3536,   3536,  -1072, &
                 -1072,   4040,   -352,  -1072,    224,  -1792,   -496,   3968,   -424,    152,   -496,   3968,     80,   -640, &
                  -496,   -568,     80,   -640,      8,    -64,   -352,  -1072,   -424,   -496,    152,   -568,   4112,   4040, &
                  -496,   3968,   -568,   4544,    800,     80,     80,   -640,   -640,   5120,     80,      8,      8,    -64, &
                   -64,    512,    224,   -496,   -496,     80,     80,      8,   -496,   -568,     80,   -640,      8,    -64, &
                    80,      8,      8,    -64,    -64,    512,   -640,    -64,    -64,    512,    512,  -4096,  -1792,   3968, &
                  3968,   -640,   -640,    -64,   3968,   4544,   -640,   5120,    -64,    512,   -640,    -64,    -64,    512, &
                   512,  -4096,   5120,    512,    512,  -4096,  -4096,  32768]
  K1( 241,:) = [      1,     10,     10,    -62,    -62,     28,     10,    100,    -62,    514,    -53,    -44,    -62,    -53, &
                    28,    -44,    442,   -116,    514,    -44,    -44,   -116,   -116,    136,     10,    100,    100,   -620, &
                  -620,    280,    -62,   -620,    514,  -4094,   -125,    532,    -53,     37,    -44,    532,    451,   -188, &
                  -125,   -602,    -35,   -188,    -26,   -584,    -62,   -620,    -53,   -125,     37,   -602,     28,    280, &
                   -44,    532,   -602,    136,    442,    451,   -116,   -188,  -3590,   1036,    451,   -107,    -26,    -98, &
                   388,     -8,    514,   -125,    -44,    -35,    451,    -26,    -44,   -602,   -116,   -188,   -107,    -98, &
                  -116,    -26,    136,   -584,    388,     -8,  -3590,    388,    388,    316,    316,   -728,  -4094,    532, &
                   532,   -188,   -188,   -584,    532,    136,   -188,   1036,    -98,     -8,   -188,    -98,   -584,     -8, &
                   316,   -728,   1036,     -8,     -8,   -728,   -728,    496]
  K1( 242,:) = [     10,      1,    -62,     28,     10,    -62,    100,     10,    -53,    -44,    -62,    514,    514,    -44, &
                   -44,   -116,   -116,    136,    -62,    -53,     28,    -44,    442,   -116,    100,     10,   -620,    280, &
                   100,   -620,   -620,    -62,   -125,    532,    514,  -4094,   -125,   -602,    -35,   -188,    -26,   -584, &
                   -53,     37,    -44,    532,    451,   -188,   -620,    -62,     37,   -602,    -53,   -125,    280,     28, &
                  -602,    136,    -44,    532,    451,   -107,    -26,    -98,    388,     -8,    442,    451,   -116,   -188, &
                 -3590,   1036,  -4094,    532,    532,   -188,   -188,   -584,    532,    136,   -188,   1036,    -98,     -8, &
                  -188,    -98,   -584,     -8,    316,   -728,   1036,     -8,     -8,   -728,   -728,    496,    514,   -125, &
                   -44,    -35,    451,    -26,    -44,   -602,   -116,   -188,   -107,    -98,   -116,    -26,    136,   -584, &
                   388,     -8,  -3590,    388,    388,    316,    316,   -728]
  K1( 243,:) = [     10,    -62,      1,     10,     28,    -62,    -62,    -53,     28,    -44,    442,   -116,     10,    100, &
                   -62,    514,    -53,    -44,    -44,    514,   -116,    136,    -44,   -116,    100,   -620,     10,    100, &
                   280,   -620,    -53,     37,    -44,    532,    451,   -188,    -62,   -620,    514,  -4094,   -125,    532, &
                  -602,   -125,    -26,   -584,    -35,   -188,    514,   -125,    -44,    -35,    451,    -26,    -44,   -602, &
                  -116,   -188,   -107,    -98,   -116,    -26,    136,   -584,    388,     -8,  -3590,    388,    388,    316, &
                   316,   -728,    -62,   -620,    -53,   -125,     37,   -602,     28,    280,    -44,    532,   -602,    136, &
                   442,    451,   -116,   -188,  -3590,   1036,    451,   -107,    -26,    -98,    388,     -8,    532,  -4094, &
                  -188,   -584,    532,   -188,    136,    532,    -98,     -8,   -188,   1036,   1036,     -8,     -8,   -728, &
                  -728,    496,   -188,    -98,   -584,     -8,    316,   -728]
  K1( 244,:) = [    -62,     28,     10,      1,    -62,     10,    514,    -44,    -44,   -116,   -116,    136,    100,     10, &
                   -53,    -44,    -62,    514,    -53,    -62,    442,   -116,     28,    -44,   -620,    280,    100,     10, &
                  -620,    100,   -125,   -602,    -35,   -188,    -26,   -584,   -620,    -62,   -125,    532,    514,  -4094, &
                    37,    -53,    451,   -188,    -44,    532,  -4094,    532,    532,   -188,   -188,   -584,    532,    136, &
                  -188,   1036,    -98,     -8,   -188,    -98,   -584,     -8,    316,   -728,   1036,     -8,     -8,   -728, &
                  -728,    496,   -620,    -62,     37,   -602,    -53,   -125,    280,     28,   -602,    136,    -44,    532, &
                   451,   -107,    -26,    -98,    388,     -8,    442,    451,   -116,   -188,  -3590,   1036,   -125,    514, &
                   451,    -26,    -44,    -35,   -602,    -44,   -107,    -98,   -116,   -188,  -3590,    388,    388,    316, &
                   316,   -728,   -116,    -26,    136,   -584,    388,     -8]
  K1( 245,:) = [    -62,     10,     28,    -62,      1,     10,    -53,    -62,    442,   -116,     28,    -44,    -44,    514, &
                  -116,    136,    -44,   -116,     10,    100,    -62,    514,    -53,    -44,   -620,    100,    280,   -620, &
                    10,    100,     37,    -53,    451,   -188,    -44,    532,   -602,   -125,    -26,   -584,    -35,   -188, &
                   -62,   -620,    514,  -4094,   -125,    532,   -125,    514,    451,    -26,    -44,    -35,   -602,    -44, &
                  -107,    -98,   -116,   -188,  -3590,    388,    388,    316,    316,   -728,   -116,    -26,    136,   -584, &
                   388,     -8,    532,  -4094,   -188,   -584,    532,   -188,    136,    532,    -98,     -8,   -188,   1036, &
                  1036,     -8,     -8,   -728,   -728,    496,   -188,    -98,   -584,     -8,    316,   -728,    -62,   -620, &
                   -53,   -125,     37,   -602,     28,    280,    -44,    532,   -602,    136,    442,    451,   -116,   -188, &
                 -3590,   1036,    451,   -107,    -26,    -98,    388,     -8]
  K1( 246,:) = [     28,    -62,    -62,     10,     10,      1,    -44,    514,   -116,    136,    -44,   -116,    -53,    -62, &
                   442,   -116,     28,    -44,    100,     10,    -53,    -44,    -62,    514,    280,   -620,   -620,    100, &
                   100,     10,   -602,   -125,    -26,   -584,    -35,   -188,     37,    -53,    451,   -188,    -44,    532, &
                  -620,    -62,   -125,    532,    514,  -4094,    532,  -4094,   -188,   -584,    532,   -188,    136,    532, &
                   -98,     -8,   -188,   1036,   1036,     -8,     -8,   -728,   -728,    496,   -188,    -98,   -584,     -8, &
                   316,   -728,   -125,    514,    451,    -26,    -44,    -35,   -602,    -44,   -107,    -98,   -116,   -188, &
                 -3590,    388,    388,    316,    316,   -728,   -116,    -26,    136,   -584,    388,     -8,   -620,    -62, &
                    37,   -602,    -53,   -125,    280,     28,   -602,    136,    -44,    532,    451,   -107,    -26,    -98, &
                   388,     -8,    442,    451,   -116,   -188,  -3590,   1036]
  K1( 247,:) = [     10,    100,    -62,    514,    -53,    -44,      1,     10,     10,    -62,    -62,     28,     28,    -44, &
                   -62,    -53,   -116,    442,    -44,   -116,    514,    -44,    136,   -116,    -62,   -620,    -53,   -125, &
                    37,   -602,     28,    280,    -44,    532,   -602,    136,    442,    451,   -116,   -188,  -3590,   1036, &
                   451,   -107,    -26,    -98,    388,     -8,     10,    100,    100,   -620,   -620,    280,    -62,   -620, &
                   514,  -4094,   -125,    532,    -53,     37,    -44,    532,    451,   -188,   -125,   -602,    -35,   -188, &
                   -26,   -584,    -44,    -35,    514,   -125,    -26,    451,   -116,    -26,    136,   -584,    388,     -8, &
                   -44,   -602,   -116,   -188,   -107,    -98,    388,  -3590,    316,   -728,    388,    316,    532,   -188, &
                 -4094,    532,   -584,   -188,   -188,    -98,   -584,     -8,    316,   -728,    532,    136,   -188,   1036, &
                   -98,     -8,     -8,   1036,   -728,    496,     -8,   -728]
  K1( 248,:) = [    100,     10,    -53,    -44,    -62,    514,     10,      1,    -62,     28,     10,    -62,    -44,   -116, &
                   514,    -44,    136,   -116,     28,    -44,    -62,    -53,   -116,    442,   -620,    -62,     37,   -602, &
                   -53,   -125,    280,     28,   -602,    136,    -44,    532,    451,   -107,    -26,    -98,    388,     -8, &
                   442,    451,   -116,   -188,  -3590,   1036,    100,     10,   -620,    280,    100,   -620,   -620,    -62, &
                  -125,    532,    514,  -4094,   -125,   -602,    -35,   -188,    -26,   -584,    -53,     37,    -44,    532, &
                   451,   -188,    532,   -188,  -4094,    532,   -584,   -188,   -188,    -98,   -584,     -8,    316,   -728, &
                   532,    136,   -188,   1036,    -98,     -8,     -8,   1036,   -728,    496,     -8,   -728,    -44,    -35, &
                   514,   -125,    -26,    451,   -116,    -26,    136,   -584,    388,     -8,    -44,   -602,   -116,   -188, &
                  -107,    -98,    388,  -3590,    316,   -728,    388,    316]
  K1( 249,:) = [    -62,    -53,     28,    -44,    442,   -116,     10,    -62,      1,     10,     28,    -62,    -62,    514, &
                    10,    100,    -44,    -53,   -116,    136,    -44,    514,   -116,    -44,    514,   -125,    -44,    -35, &
                   451,    -26,    -44,   -602,   -116,   -188,   -107,    -98,   -116,    -26,    136,   -584,    388,     -8, &
                 -3590,    388,    388,    316,    316,   -728,    100,   -620,     10,    100,    280,   -620,    -53,     37, &
                   -44,    532,    451,   -188,    -62,   -620,    514,  -4094,   -125,    532,   -602,   -125,    -26,   -584, &
                   -35,   -188,    -53,   -125,    -62,   -620,   -602,     37,    442,    451,   -116,   -188,  -3590,   1036, &
                    28,    280,    -44,    532,   -602,    136,   -107,    451,    388,     -8,    -26,    -98,   -188,   -584, &
                   532,  -4094,   -188,    532,   1036,     -8,     -8,   -728,   -728,    496,    136,    532,    -98,     -8, &
                  -188,   1036,    -98,   -188,    316,   -728,   -584,     -8]
  K1( 250,:) = [    514,    -44,    -44,   -116,   -116,    136,    -62,     28,     10,      1,    -62,     10,    -53,    -44, &
                   100,     10,    514,    -62,    442,   -116,    -53,    -62,    -44,     28,  -4094,    532,    532,   -188, &
                  -188,   -584,    532,    136,   -188,   1036,    -98,     -8,   -188,    -98,   -584,     -8,    316,   -728, &
                  1036,     -8,     -8,   -728,   -728,    496,   -620,    280,    100,     10,   -620,    100,   -125,   -602, &
                   -35,   -188,    -26,   -584,   -620,    -62,   -125,    532,    514,  -4094,     37,    -53,    451,   -188, &
                   -44,    532,     37,   -602,   -620,    -62,   -125,    -53,    451,   -107,    -26,    -98,    388,     -8, &
                   280,     28,   -602,    136,    -44,    532,    451,    442,  -3590,   1036,   -116,   -188,    451,    -26, &
                  -125,    514,    -35,    -44,  -3590,    388,    388,    316,    316,   -728,   -602,    -44,   -107,    -98, &
                  -116,   -188,    -26,   -116,    388,     -8,    136,   -584]
  K1( 251,:) = [    -53,    -62,    442,   -116,     28,    -44,    -62,     10,     28,    -62,      1,     10,   -116,    136, &
                   -44,    514,   -116,    -44,    -62,    514,     10,    100,    -44,    -53,   -125,    514,    451,    -26, &
                   -44,    -35,   -602,    -44,   -107,    -98,   -116,   -188,  -3590,    388,    388,    316,    316,   -728, &
                  -116,    -26,    136,   -584,    388,     -8,   -620,    100,    280,   -620,     10,    100,     37,    -53, &
                   451,   -188,    -44,    532,   -602,   -125,    -26,   -584,    -35,   -188,    -62,   -620,    514,  -4094, &
                  -125,    532,   -188,   -584,    532,  -4094,   -188,    532,   1036,     -8,     -8,   -728,   -728,    496, &
                   136,    532,    -98,     -8,   -188,   1036,    -98,   -188,    316,   -728,   -584,     -8,    -53,   -125, &
                   -62,   -620,   -602,     37,    442,    451,   -116,   -188,  -3590,   1036,     28,    280,    -44,    532, &
                  -602,    136,   -107,    451,    388,     -8,    -26,    -98]
  K1( 252,:) = [    -44,    514,   -116,    136,    -44,   -116,     28,    -62,    -62,     10,     10,      1,    442,   -116, &
                   -53,    -62,    -44,     28,    -53,    -44,    100,     10,    514,    -62,    532,  -4094,   -188,   -584, &
                   532,   -188,    136,    532,    -98,     -8,   -188,   1036,   1036,     -8,     -8,   -728,   -728,    496, &
                  -188,    -98,   -584,     -8,    316,   -728,    280,   -620,   -620,    100,    100,     10,   -602,   -125, &
                   -26,   -584,    -35,   -188,     37,    -53,    451,   -188,    -44,    532,   -620,    -62,   -125,    532, &
                   514,  -4094,    451,    -26,   -125,    514,    -35,    -44,  -3590,    388,    388,    316,    316,   -728, &
                  -602,    -44,   -107,    -98,   -116,   -188,    -26,   -116,    388,     -8,    136,   -584,     37,   -602, &
                  -620,    -62,   -125,    -53,    451,   -107,    -26,    -98,    388,     -8,    280,     28,   -602,    136, &
                   -44,    532,    451,    442,  -3590,   1036,   -116,   -188]
  K1( 253,:) = [    -62,    514,     10,    100,    -44,    -53,     28,    -44,    -62,    -53,   -116,    442,      1,     10, &
                    10,    -62,    -62,     28,   -116,    -44,    136,   -116,    514,    -44,    -53,   -125,    -62,   -620, &
                  -602,     37,    442,    451,   -116,   -188,  -3590,   1036,     28,    280,    -44,    532,   -602,    136, &
                  -107,    451,    388,     -8,    -26,    -98,    -44,    -35,    514,   -125,    -26,    451,   -116,    -26, &
                   136,   -584,    388,     -8,    -44,   -602,   -116,   -188,   -107,    -98,    388,  -3590,    316,   -728, &
                   388,    316,     10,    100,    100,   -620,   -620,    280,    -62,   -620,    514,  -4094,   -125,    532, &
                   -53,     37,    -44,    532,    451,   -188,   -125,   -602,    -35,   -188,    -26,   -584,   -188,    532, &
                  -584,   -188,  -4094,    532,    -98,   -188,    316,   -728,   -584,     -8,     -8,   1036,   -728,    496, &
                    -8,   -728,    532,    136,   -188,   1036,    -98,     -8]
  K1( 254,:) = [    -53,    -44,    100,     10,    514,    -62,    -44,   -116,    514,    -44,    136,   -116,     10,      1, &
                   -62,     28,     10,    -62,    -44,     28,   -116,    442,    -62,    -53,     37,   -602,   -620,    -62, &
                  -125,    -53,    451,   -107,    -26,    -98,    388,     -8,    280,     28,   -602,    136,    -44,    532, &
                   451,    442,  -3590,   1036,   -116,   -188,    532,   -188,  -4094,    532,   -584,   -188,   -188,    -98, &
                  -584,     -8,    316,   -728,    532,    136,   -188,   1036,    -98,     -8,     -8,   1036,   -728,    496, &
                    -8,   -728,    100,     10,   -620,    280,    100,   -620,   -620,    -62,   -125,    532,    514,  -4094, &
                  -125,   -602,    -35,   -188,    -26,   -584,    -53,     37,    -44,    532,    451,   -188,    -35,    -44, &
                   -26,    451,    514,   -125,    -26,   -116,    388,     -8,    136,   -584,    388,  -3590,    316,   -728, &
                   388,    316,    -44,   -602,   -116,   -188,   -107,    -98]
  K1( 255,:) = [     28,    -44,    -62,    -53,   -116,    442,    -62,    514,     10,    100,    -44,    -53,     10,    -62, &
                     1,     10,     28,    -62,    136,   -116,   -116,    -44,    -44,    514,    -44,    -35,    514,   -125, &
                   -26,    451,   -116,    -26,    136,   -584,    388,     -8,    -44,   -602,   -116,   -188,   -107,    -98, &
                   388,  -3590,    316,   -728,    388,    316,    -53,   -125,    -62,   -620,   -602,     37,    442,    451, &
                  -116,   -188,  -3590,   1036,     28,    280,    -44,    532,   -602,    136,   -107,    451,    388,     -8, &
                   -26,    -98,    100,   -620,     10,    100,    280,   -620,    -53,     37,    -44,    532,    451,   -188, &
                   -62,   -620,    514,  -4094,   -125,    532,   -602,   -125,    -26,   -584,    -35,   -188,   -584,   -188, &
                  -188,    532,    532,  -4094,     -8,   1036,   -728,    496,     -8,   -728,    -98,   -188,    316,   -728, &
                  -584,     -8,    136,    532,    -98,     -8,   -188,   1036]
  K1( 256,:) = [    -44,   -116,    514,    -44,    136,   -116,    -53,    -44,    100,     10,    514,    -62,    -62,     28, &
                    10,      1,    -62,     10,   -116,    442,    -44,     28,    -53,    -62,    532,   -188,  -4094,    532, &
                  -584,   -188,   -188,    -98,   -584,     -8,    316,   -728,    532,    136,   -188,   1036,    -98,     -8, &
                    -8,   1036,   -728,    496,     -8,   -728,     37,   -602,   -620,    -62,   -125,    -53,    451,   -107, &
                   -26,    -98,    388,     -8,    280,     28,   -602,    136,    -44,    532,    451,    442,  -3590,   1036, &
                  -116,   -188,   -620,    280,    100,     10,   -620,    100,   -125,   -602,    -35,   -188,    -26,   -584, &
                  -620,    -62,   -125,    532,    514,  -4094,     37,    -53,    451,   -188,    -44,    532,    -26,    451, &
                   -35,    -44,   -125,    514,    388,  -3590,    316,   -728,    388,    316,    -26,   -116,    388,     -8, &
                   136,   -584,   -602,    -44,   -107,    -98,   -116,   -188]
  K1( 257,:) = [    442,   -116,    -53,    -62,    -44,     28,   -116,    136,    -44,    514,   -116,    -44,    -62,     10, &
                    28,    -62,      1,     10,    514,    -62,    -44,    -53,     10,    100,    451,    -26,   -125,    514, &
                   -35,    -44,  -3590,    388,    388,    316,    316,   -728,   -602,    -44,   -107,    -98,   -116,   -188, &
                   -26,   -116,    388,     -8,    136,   -584,   -188,   -584,    532,  -4094,   -188,    532,   1036,     -8, &
                    -8,   -728,   -728,    496,    136,    532,    -98,     -8,   -188,   1036,    -98,   -188,    316,   -728, &
                  -584,     -8,   -620,    100,    280,   -620,     10,    100,     37,    -53,    451,   -188,    -44,    532, &
                  -602,   -125,    -26,   -584,    -35,   -188,    -62,   -620,    514,  -4094,   -125,    532,   -125,    -53, &
                  -602,     37,    -62,   -620,    451,    442,  -3590,   1036,   -116,   -188,   -107,    451,    388,     -8, &
                   -26,    -98,     28,    280,    -44,    532,   -602,    136]
  K1( 258,:) = [   -116,    136,    -44,    514,   -116,    -44,    442,   -116,    -53,    -62,    -44,     28,     28,    -62, &
                   -62,     10,     10,      1,    -44,    -53,    514,    -62,    100,     10,   -188,   -584,    532,  -4094, &
                  -188,    532,   1036,     -8,     -8,   -728,   -728,    496,    136,    532,    -98,     -8,   -188,   1036, &
                   -98,   -188,    316,   -728,   -584,     -8,    451,    -26,   -125,    514,    -35,    -44,  -3590,    388, &
                   388,    316,    316,   -728,   -602,    -44,   -107,    -98,   -116,   -188,    -26,   -116,    388,     -8, &
                   136,   -584,    280,   -620,   -620,    100,    100,     10,   -602,   -125,    -26,   -584,    -35,   -188, &
                    37,    -53,    451,   -188,    -44,    532,   -620,    -62,   -125,    532,    514,  -4094,   -602,     37, &
                  -125,    -53,   -620,    -62,   -107,    451,    388,     -8,    -26,    -98,    451,    442,  -3590,   1036, &
                  -116,   -188,    280,     28,   -602,    136,    -44,    532]
  K1( 259,:) = [    514,    -62,    -44,    -53,     10,    100,    -44,     28,   -116,    442,    -62,    -53,   -116,    -44, &
                   136,   -116,    514,    -44,      1,     10,     10,    -62,    -62,     28,   -125,    -53,   -602,     37, &
                   -62,   -620,    451,    442,  -3590,   1036,   -116,   -188,   -107,    451,    388,     -8,    -26,    -98, &
                    28,    280,    -44,    532,   -602,    136,    -35,    -44,    -26,    451,    514,   -125,    -26,   -116, &
                   388,     -8,    136,   -584,    388,  -3590,    316,   -728,    388,    316,    -44,   -602,   -116,   -188, &
                  -107,    -98,   -188,    532,   -584,   -188,  -4094,    532,    -98,   -188,    316,   -728,   -584,     -8, &
                    -8,   1036,   -728,    496,     -8,   -728,    532,    136,   -188,   1036,    -98,     -8,     10,    100, &
                   100,   -620,   -620,    280,    -62,   -620,    514,  -4094,   -125,    532,    -53,     37,    -44,    532, &
                   451,   -188,   -125,   -602,    -35,   -188,    -26,   -584]
  K1( 260,:) = [    -44,    -53,    514,    -62,    100,     10,   -116,    -44,    136,   -116,    514,    -44,    -44,     28, &
                  -116,    442,    -62,    -53,     10,      1,    -62,     28,     10,    -62,   -602,     37,   -125,    -53, &
                  -620,    -62,   -107,    451,    388,     -8,    -26,    -98,    451,    442,  -3590,   1036,   -116,   -188, &
                   280,     28,   -602,    136,    -44,    532,   -188,    532,   -584,   -188,  -4094,    532,    -98,   -188, &
                   316,   -728,   -584,     -8,     -8,   1036,   -728,    496,     -8,   -728,    532,    136,   -188,   1036, &
                   -98,     -8,    -35,    -44,    -26,    451,    514,   -125,    -26,   -116,    388,     -8,    136,   -584, &
                   388,  -3590,    316,   -728,    388,    316,    -44,   -602,   -116,   -188,   -107,    -98,    100,     10, &
                  -620,    280,    100,   -620,   -620,    -62,   -125,    532,    514,  -4094,   -125,   -602,    -35,   -188, &
                   -26,   -584,    -53,     37,    -44,    532,    451,   -188]
  K1( 261,:) = [    -44,     28,   -116,    442,    -62,    -53,    514,    -62,    -44,    -53,     10,    100,    136,   -116, &
                  -116,    -44,    -44,    514,     10,    -62,      1,     10,     28,    -62,    -35,    -44,    -26,    451, &
                   514,   -125,    -26,   -116,    388,     -8,    136,   -584,    388,  -3590,    316,   -728,    388,    316, &
                   -44,   -602,   -116,   -188,   -107,    -98,   -125,    -53,   -602,     37,    -62,   -620,    451,    442, &
                 -3590,   1036,   -116,   -188,   -107,    451,    388,     -8,    -26,    -98,     28,    280,    -44,    532, &
                  -602,    136,   -584,   -188,   -188,    532,    532,  -4094,     -8,   1036,   -728,    496,     -8,   -728, &
                   -98,   -188,    316,   -728,   -584,     -8,    136,    532,    -98,     -8,   -188,   1036,    100,   -620, &
                    10,    100,    280,   -620,    -53,     37,    -44,    532,    451,   -188,    -62,   -620,    514,  -4094, &
                  -125,    532,   -602,   -125,    -26,   -584,    -35,   -188]
  K1( 262,:) = [   -116,    -44,    136,   -116,    514,    -44,    -44,    -53,    514,    -62,    100,     10,   -116,    442, &
                   -44,     28,    -53,    -62,    -62,     28,     10,      1,    -62,     10,   -188,    532,   -584,   -188, &
                 -4094,    532,    -98,   -188,    316,   -728,   -584,     -8,     -8,   1036,   -728,    496,     -8,   -728, &
                   532,    136,   -188,   1036,    -98,     -8,   -602,     37,   -125,    -53,   -620,    -62,   -107,    451, &
                   388,     -8,    -26,    -98,    451,    442,  -3590,   1036,   -116,   -188,    280,     28,   -602,    136, &
                   -44,    532,    -26,    451,    -35,    -44,   -125,    514,    388,  -3590,    316,   -728,    388,    316, &
                   -26,   -116,    388,     -8,    136,   -584,   -602,    -44,   -107,    -98,   -116,   -188,   -620,    280, &
                   100,     10,   -620,    100,   -125,   -602,    -35,   -188,    -26,   -584,   -620,    -62,   -125,    532, &
                   514,  -4094,     37,    -53,    451,   -188,    -44,    532]
  K1( 263,:) = [   -116,    442,    -44,     28,    -53,    -62,    136,   -116,   -116,    -44,    -44,    514,    514,    -62, &
                   -44,    -53,     10,    100,    -62,     10,     28,    -62,      1,     10,    -26,    451,    -35,    -44, &
                  -125,    514,    388,  -3590,    316,   -728,    388,    316,    -26,   -116,    388,     -8,    136,   -584, &
                  -602,    -44,   -107,    -98,   -116,   -188,   -584,   -188,   -188,    532,    532,  -4094,     -8,   1036, &
                  -728,    496,     -8,   -728,    -98,   -188,    316,   -728,   -584,     -8,    136,    532,    -98,     -8, &
                  -188,   1036,   -125,    -53,   -602,     37,    -62,   -620,    451,    442,  -3590,   1036,   -116,   -188, &
                  -107,    451,    388,     -8,    -26,    -98,     28,    280,    -44,    532,   -602,    136,   -620,    100, &
                   280,   -620,     10,    100,     37,    -53,    451,   -188,    -44,    532,   -602,   -125,    -26,   -584, &
                   -35,   -188,    -62,   -620,    514,  -4094,   -125,    532]
  K1( 264,:) = [    136,   -116,   -116,    -44,    -44,    514,   -116,    442,    -44,     28,    -53,    -62,    -44,    -53, &
                   514,    -62,    100,     10,     28,    -62,    -62,     10,     10,      1,   -584,   -188,   -188,    532, &
                   532,  -4094,     -8,   1036,   -728,    496,     -8,   -728,    -98,   -188,    316,   -728,   -584,     -8, &
                   136,    532,    -98,     -8,   -188,   1036,    -26,    451,    -35,    -44,   -125,    514,    388,  -3590, &
                   316,   -728,    388,    316,    -26,   -116,    388,     -8,    136,   -584,   -602,    -44,   -107,    -98, &
                  -116,   -188,   -602,     37,   -125,    -53,   -620,    -62,   -107,    451,    388,     -8,    -26,    -98, &
                   451,    442,  -3590,   1036,   -116,   -188,    280,     28,   -602,    136,    -44,    532,    280,   -620, &
                  -620,    100,    100,     10,   -602,   -125,    -26,   -584,    -35,   -188,     37,    -53,    451,   -188, &
                   -44,    532,   -620,    -62,   -125,    532,    514,  -4094]
  K1( 265,:) = [     10,    100,    100,   -620,   -620,    280,    -62,   -620,    514,  -4094,   -125,    532,    -53,     37, &
                   -44,    532,    451,   -188,   -125,   -602,    -35,   -188,    -26,   -584,      1,     10,     10,    -62, &
                   -62,     28,     10,    100,    -62,    514,    -53,    -44,    -62,    -53,     28,    -44,    442,   -116, &
                   514,    -44,    -44,   -116,   -116,    136,     28,    280,    -44,    532,   -602,    136,    -62,   -620, &
                   -53,   -125,     37,   -602,   -116,   -188,    442,    451,   1036,  -3590,    -26,    -98,    451,   -107, &
                    -8,    388,    -44,   -602,   -116,   -188,   -107,    -98,    514,   -125,    -44,    -35,    451,    -26, &
                   136,   -584,   -116,    -26,     -8,    388,    388,    316,  -3590,    388,   -728,    316,    532,    136, &
                  -188,   1036,    -98,     -8,  -4094,    532,    532,   -188,   -188,   -584,   -584,     -8,   -188,    -98, &
                  -728,    316,     -8,   -728,   1036,     -8,    496,   -728]
  K1( 266,:) = [    100,     10,   -620,    280,    100,   -620,   -620,    -62,   -125,    532,    514,  -4094,   -125,   -602, &
                   -35,   -188,    -26,   -584,    -53,     37,    -44,    532,    451,   -188,     10,      1,    -62,     28, &
                    10,    -62,    100,     10,    -53,    -44,    -62,    514,    514,    -44,    -44,   -116,   -116,    136, &
                   -62,    -53,     28,    -44,    442,   -116,    280,     28,   -602,    136,    -44,    532,   -620,    -62, &
                    37,   -602,    -53,   -125,    -26,    -98,    451,   -107,     -8,    388,   -116,   -188,    442,    451, &
                  1036,  -3590,    532,    136,   -188,   1036,    -98,     -8,  -4094,    532,    532,   -188,   -188,   -584, &
                  -584,     -8,   -188,    -98,   -728,    316,     -8,   -728,   1036,     -8,    496,   -728,    -44,   -602, &
                  -116,   -188,   -107,    -98,    514,   -125,    -44,    -35,    451,    -26,    136,   -584,   -116,    -26, &
                    -8,    388,    388,    316,  -3590,    388,   -728,    316]
  K1( 267,:) = [    100,   -620,     10,    100,    280,   -620,    -53,     37,    -44,    532,    451,   -188,    -62,   -620, &
                   514,  -4094,   -125,    532,   -602,   -125,    -26,   -584,    -35,   -188,     10,    -62,      1,     10, &
                    28,    -62,    -62,    -53,     28,    -44,    442,   -116,     10,    100,    -62,    514,    -53,    -44, &
                   -44,    514,   -116,    136,    -44,   -116,    -44,   -602,   -116,   -188,   -107,    -98,    514,   -125, &
                   -44,    -35,    451,    -26,    136,   -584,   -116,    -26,     -8,    388,    388,    316,  -3590,    388, &
                  -728,    316,     28,    280,    -44,    532,   -602,    136,    -62,   -620,    -53,   -125,     37,   -602, &
                  -116,   -188,    442,    451,   1036,  -3590,    -26,    -98,    451,   -107,     -8,    388,    136,    532, &
                   -98,     -8,   -188,   1036,    532,  -4094,   -188,   -584,    532,   -188,     -8,   -728,   1036,     -8, &
                   496,   -728,   -584,     -8,   -188,    -98,   -728,    316]
  K1( 268,:) = [   -620,    280,    100,     10,   -620,    100,   -125,   -602,    -35,   -188,    -26,   -584,   -620,    -62, &
                  -125,    532,    514,  -4094,     37,    -53,    451,   -188,    -44,    532,    -62,     28,     10,      1, &
                   -62,     10,    514,    -44,    -44,   -116,   -116,    136,    100,     10,    -53,    -44,    -62,    514, &
                   -53,    -62,    442,   -116,     28,    -44,    532,    136,   -188,   1036,    -98,     -8,  -4094,    532, &
                   532,   -188,   -188,   -584,   -584,     -8,   -188,    -98,   -728,    316,     -8,   -728,   1036,     -8, &
                   496,   -728,    280,     28,   -602,    136,    -44,    532,   -620,    -62,     37,   -602,    -53,   -125, &
                   -26,    -98,    451,   -107,     -8,    388,   -116,   -188,    442,    451,   1036,  -3590,   -602,    -44, &
                  -107,    -98,   -116,   -188,   -125,    514,    451,    -26,    -44,    -35,    388,    316,  -3590,    388, &
                  -728,    316,    136,   -584,   -116,    -26,     -8,    388]
  K1( 269,:) = [   -620,    100,    280,   -620,     10,    100,     37,    -53,    451,   -188,    -44,    532,   -602,   -125, &
                   -26,   -584,    -35,   -188,    -62,   -620,    514,  -4094,   -125,    532,    -62,     10,     28,    -62, &
                     1,     10,    -53,    -62,    442,   -116,     28,    -44,    -44,    514,   -116,    136,    -44,   -116, &
                    10,    100,    -62,    514,    -53,    -44,   -602,    -44,   -107,    -98,   -116,   -188,   -125,    514, &
                   451,    -26,    -44,    -35,    388,    316,  -3590,    388,   -728,    316,    136,   -584,   -116,    -26, &
                    -8,    388,    136,    532,    -98,     -8,   -188,   1036,    532,  -4094,   -188,   -584,    532,   -188, &
                    -8,   -728,   1036,     -8,    496,   -728,   -584,     -8,   -188,    -98,   -728,    316,     28,    280, &
                   -44,    532,   -602,    136,    -62,   -620,    -53,   -125,     37,   -602,   -116,   -188,    442,    451, &
                  1036,  -3590,    -26,    -98,    451,   -107,     -8,    388]
  K1( 270,:) = [    280,   -620,   -620,    100,    100,     10,   -602,   -125,    -26,   -584,    -35,   -188,     37,    -53, &
                   451,   -188,    -44,    532,   -620,    -62,   -125,    532,    514,  -4094,     28,    -62,    -62,     10, &
                    10,      1,    -44,    514,   -116,    136,    -44,   -116,    -53,    -62,    442,   -116,     28,    -44, &
                   100,     10,    -53,    -44,    -62,    514,    136,    532,    -98,     -8,   -188,   1036,    532,  -4094, &
                  -188,   -584,    532,   -188,     -8,   -728,   1036,     -8,    496,   -728,   -584,     -8,   -188,    -98, &
                  -728,    316,   -602,    -44,   -107,    -98,   -116,   -188,   -125,    514,    451,    -26,    -44,    -35, &
                   388,    316,  -3590,    388,   -728,    316,    136,   -584,   -116,    -26,     -8,    388,    280,     28, &
                  -602,    136,    -44,    532,   -620,    -62,     37,   -602,    -53,   -125,    -26,    -98,    451,   -107, &
                    -8,    388,   -116,   -188,    442,    451,   1036,  -3590]
  K1( 271,:) = [    -62,   -620,    -53,   -125,     37,   -602,     28,    280,    -44,    532,   -602,    136,    442,    451, &
                  -116,   -188,  -3590,   1036,    451,   -107,    -26,    -98,    388,     -8,     10,    100,    -62,    514, &
                   -53,    -44,      1,     10,     10,    -62,    -62,     28,     28,    -44,    -62,    -53,   -116,    442, &
                   -44,   -116,    514,    -44,    136,   -116,    -62,   -620,    514,  -4094,   -125,    532,     10,    100, &
                   100,   -620,   -620,    280,    -44,    532,    -53,     37,   -188,    451,    -35,   -188,   -125,   -602, &
                  -584,    -26,   -116,    -26,    136,   -584,    388,     -8,    -44,    -35,    514,   -125,    -26,    451, &
                  -116,   -188,    -44,   -602,    -98,   -107,    316,   -728,    388,  -3590,    316,    388,   -188,    -98, &
                  -584,     -8,    316,   -728,    532,   -188,  -4094,    532,   -584,   -188,   -188,   1036,    532,    136, &
                    -8,    -98,   -728,    496,     -8,   1036,   -728,     -8]
  K1( 272,:) = [   -620,    -62,     37,   -602,    -53,   -125,    280,     28,   -602,    136,    -44,    532,    451,   -107, &
                   -26,    -98,    388,     -8,    442,    451,   -116,   -188,  -3590,   1036,    100,     10,    -53,    -44, &
                   -62,    514,     10,      1,    -62,     28,     10,    -62,    -44,   -116,    514,    -44,    136,   -116, &
                    28,    -44,    -62,    -53,   -116,    442,   -620,    -62,   -125,    532,    514,  -4094,    100,     10, &
                  -620,    280,    100,   -620,    -35,   -188,   -125,   -602,   -584,    -26,    -44,    532,    -53,     37, &
                  -188,    451,   -188,    -98,   -584,     -8,    316,   -728,    532,   -188,  -4094,    532,   -584,   -188, &
                  -188,   1036,    532,    136,     -8,    -98,   -728,    496,     -8,   1036,   -728,     -8,   -116,    -26, &
                   136,   -584,    388,     -8,    -44,    -35,    514,   -125,    -26,    451,   -116,   -188,    -44,   -602, &
                   -98,   -107,    316,   -728,    388,  -3590,    316,    388]
  K1( 273,:) = [    514,   -125,    -44,    -35,    451,    -26,    -44,   -602,   -116,   -188,   -107,    -98,   -116,    -26, &
                   136,   -584,    388,     -8,  -3590,    388,    388,    316,    316,   -728,    -62,    -53,     28,    -44, &
                   442,   -116,     10,    -62,      1,     10,     28,    -62,    -62,    514,     10,    100,    -44,    -53, &
                  -116,    136,    -44,    514,   -116,    -44,    -53,     37,    -44,    532,    451,   -188,    100,   -620, &
                    10,    100,    280,   -620,    514,  -4094,    -62,   -620,    532,   -125,    -26,   -584,   -602,   -125, &
                  -188,    -35,    442,    451,   -116,   -188,  -3590,   1036,    -53,   -125,    -62,   -620,   -602,     37, &
                   -44,    532,     28,    280,    136,   -602,    388,     -8,   -107,    451,    -98,    -26,   1036,     -8, &
                    -8,   -728,   -728,    496,   -188,   -584,    532,  -4094,   -188,    532,    -98,     -8,    136,    532, &
                  1036,   -188,    316,   -728,    -98,   -188,     -8,   -584]
  K1( 274,:) = [  -4094,    532,    532,   -188,   -188,   -584,    532,    136,   -188,   1036,    -98,     -8,   -188,    -98, &
                  -584,     -8,    316,   -728,   1036,     -8,     -8,   -728,   -728,    496,    514,    -44,    -44,   -116, &
                  -116,    136,    -62,     28,     10,      1,    -62,     10,    -53,    -44,    100,     10,    514,    -62, &
                   442,   -116,    -53,    -62,    -44,     28,   -125,   -602,    -35,   -188,    -26,   -584,   -620,    280, &
                   100,     10,   -620,    100,   -125,    532,   -620,    -62,  -4094,    514,    451,   -188,     37,    -53, &
                   532,    -44,    451,   -107,    -26,    -98,    388,     -8,     37,   -602,   -620,    -62,   -125,    -53, &
                  -602,    136,    280,     28,    532,    -44,  -3590,   1036,    451,    442,   -188,   -116,  -3590,    388, &
                   388,    316,    316,   -728,    451,    -26,   -125,    514,    -35,    -44,   -107,    -98,   -602,    -44, &
                  -188,   -116,    388,     -8,    -26,   -116,   -584,    136]
  K1( 275,:) = [   -125,    514,    451,    -26,    -44,    -35,   -602,    -44,   -107,    -98,   -116,   -188,  -3590,    388, &
                   388,    316,    316,   -728,   -116,    -26,    136,   -584,    388,     -8,    -53,    -62,    442,   -116, &
                    28,    -44,    -62,     10,     28,    -62,      1,     10,   -116,    136,    -44,    514,   -116,    -44, &
                   -62,    514,     10,    100,    -44,    -53,     37,    -53,    451,   -188,    -44,    532,   -620,    100, &
                   280,   -620,     10,    100,    -26,   -584,   -602,   -125,   -188,    -35,    514,  -4094,    -62,   -620, &
                   532,   -125,   1036,     -8,     -8,   -728,   -728,    496,   -188,   -584,    532,  -4094,   -188,    532, &
                   -98,     -8,    136,    532,   1036,   -188,    316,   -728,    -98,   -188,     -8,   -584,    442,    451, &
                  -116,   -188,  -3590,   1036,    -53,   -125,    -62,   -620,   -602,     37,    -44,    532,     28,    280, &
                   136,   -602,    388,     -8,   -107,    451,    -98,    -26]
  K1( 276,:) = [    532,  -4094,   -188,   -584,    532,   -188,    136,    532,    -98,     -8,   -188,   1036,   1036,     -8, &
                    -8,   -728,   -728,    496,   -188,    -98,   -584,     -8,    316,   -728,    -44,    514,   -116,    136, &
                   -44,   -116,     28,    -62,    -62,     10,     10,      1,    442,   -116,    -53,    -62,    -44,     28, &
                   -53,    -44,    100,     10,    514,    -62,   -602,   -125,    -26,   -584,    -35,   -188,    280,   -620, &
                  -620,    100,    100,     10,    451,   -188,     37,    -53,    532,    -44,   -125,    532,   -620,    -62, &
                 -4094,    514,  -3590,    388,    388,    316,    316,   -728,    451,    -26,   -125,    514,    -35,    -44, &
                  -107,    -98,   -602,    -44,   -188,   -116,    388,     -8,    -26,   -116,   -584,    136,    451,   -107, &
                   -26,    -98,    388,     -8,     37,   -602,   -620,    -62,   -125,    -53,   -602,    136,    280,     28, &
                   532,    -44,  -3590,   1036,    451,    442,   -188,   -116]
  K1( 277,:) = [    -53,   -125,    -62,   -620,   -602,     37,    442,    451,   -116,   -188,  -3590,   1036,     28,    280, &
                   -44,    532,   -602,    136,   -107,    451,    388,     -8,    -26,    -98,    -62,    514,     10,    100, &
                   -44,    -53,     28,    -44,    -62,    -53,   -116,    442,      1,     10,     10,    -62,    -62,     28, &
                  -116,    -44,    136,   -116,    514,    -44,   -116,    -26,    136,   -584,    388,     -8,    -44,    -35, &
                   514,   -125,    -26,    451,   -116,   -188,    -44,   -602,    -98,   -107,    316,   -728,    388,  -3590, &
                   316,    388,    -62,   -620,    514,  -4094,   -125,    532,     10,    100,    100,   -620,   -620,    280, &
                   -44,    532,    -53,     37,   -188,    451,    -35,   -188,   -125,   -602,   -584,    -26,    -98,   -188, &
                   316,   -728,   -584,     -8,   -188,    532,   -584,   -188,  -4094,    532,   -728,    496,     -8,   1036, &
                  -728,     -8,   -188,   1036,    532,    136,     -8,    -98]
  K1( 278,:) = [     37,   -602,   -620,    -62,   -125,    -53,    451,   -107,    -26,    -98,    388,     -8,    280,     28, &
                  -602,    136,    -44,    532,    451,    442,  -3590,   1036,   -116,   -188,    -53,    -44,    100,     10, &
                   514,    -62,    -44,   -116,    514,    -44,    136,   -116,     10,      1,    -62,     28,     10,    -62, &
                   -44,     28,   -116,    442,    -62,    -53,   -188,    -98,   -584,     -8,    316,   -728,    532,   -188, &
                 -4094,    532,   -584,   -188,   -188,   1036,    532,    136,     -8,    -98,   -728,    496,     -8,   1036, &
                  -728,     -8,   -620,    -62,   -125,    532,    514,  -4094,    100,     10,   -620,    280,    100,   -620, &
                   -35,   -188,   -125,   -602,   -584,    -26,    -44,    532,    -53,     37,   -188,    451,    -26,   -116, &
                   388,     -8,    136,   -584,    -35,    -44,    -26,    451,    514,   -125,    316,   -728,    388,  -3590, &
                   316,    388,   -116,   -188,    -44,   -602,    -98,   -107]
  K1( 279,:) = [    -44,    -35,    514,   -125,    -26,    451,   -116,    -26,    136,   -584,    388,     -8,    -44,   -602, &
                  -116,   -188,   -107,    -98,    388,  -3590,    316,   -728,    388,    316,     28,    -44,    -62,    -53, &
                  -116,    442,    -62,    514,     10,    100,    -44,    -53,     10,    -62,      1,     10,     28,    -62, &
                   136,   -116,   -116,    -44,    -44,    514,    442,    451,   -116,   -188,  -3590,   1036,    -53,   -125, &
                   -62,   -620,   -602,     37,    -44,    532,     28,    280,    136,   -602,    388,     -8,   -107,    451, &
                   -98,    -26,    -53,     37,    -44,    532,    451,   -188,    100,   -620,     10,    100,    280,   -620, &
                   514,  -4094,    -62,   -620,    532,   -125,    -26,   -584,   -602,   -125,   -188,    -35,     -8,   1036, &
                  -728,    496,     -8,   -728,   -584,   -188,   -188,    532,    532,  -4094,    316,   -728,    -98,   -188, &
                    -8,   -584,    -98,     -8,    136,    532,   1036,   -188]
  K1( 280,:) = [    532,   -188,  -4094,    532,   -584,   -188,   -188,    -98,   -584,     -8,    316,   -728,    532,    136, &
                  -188,   1036,    -98,     -8,     -8,   1036,   -728,    496,     -8,   -728,    -44,   -116,    514,    -44, &
                   136,   -116,    -53,    -44,    100,     10,    514,    -62,    -62,     28,     10,      1,    -62,     10, &
                  -116,    442,    -44,     28,    -53,    -62,    451,   -107,    -26,    -98,    388,     -8,     37,   -602, &
                  -620,    -62,   -125,    -53,   -602,    136,    280,     28,    532,    -44,  -3590,   1036,    451,    442, &
                  -188,   -116,   -125,   -602,    -35,   -188,    -26,   -584,   -620,    280,    100,     10,   -620,    100, &
                  -125,    532,   -620,    -62,  -4094,    514,    451,   -188,     37,    -53,    532,    -44,    388,  -3590, &
                   316,   -728,    388,    316,    -26,    451,    -35,    -44,   -125,    514,    388,     -8,    -26,   -116, &
                  -584,    136,   -107,    -98,   -602,    -44,   -188,   -116]
  K1( 281,:) = [    451,    -26,   -125,    514,    -35,    -44,  -3590,    388,    388,    316,    316,   -728,   -602,    -44, &
                  -107,    -98,   -116,   -188,    -26,   -116,    388,     -8,    136,   -584,    442,   -116,    -53,    -62, &
                   -44,     28,   -116,    136,    -44,    514,   -116,    -44,    -62,     10,     28,    -62,      1,     10, &
                   514,    -62,    -44,    -53,     10,    100,   1036,     -8,     -8,   -728,   -728,    496,   -188,   -584, &
                   532,  -4094,   -188,    532,    -98,     -8,    136,    532,   1036,   -188,    316,   -728,    -98,   -188, &
                    -8,   -584,     37,    -53,    451,   -188,    -44,    532,   -620,    100,    280,   -620,     10,    100, &
                   -26,   -584,   -602,   -125,   -188,    -35,    514,  -4094,    -62,   -620,    532,   -125,    451,    442, &
                 -3590,   1036,   -116,   -188,   -125,    -53,   -602,     37,    -62,   -620,    388,     -8,   -107,    451, &
                   -98,    -26,    -44,    532,     28,    280,    136,   -602]
  K1( 282,:) = [   -188,   -584,    532,  -4094,   -188,    532,   1036,     -8,     -8,   -728,   -728,    496,    136,    532, &
                   -98,     -8,   -188,   1036,    -98,   -188,    316,   -728,   -584,     -8,   -116,    136,    -44,    514, &
                  -116,    -44,    442,   -116,    -53,    -62,    -44,     28,     28,    -62,    -62,     10,     10,      1, &
                   -44,    -53,    514,    -62,    100,     10,  -3590,    388,    388,    316,    316,   -728,    451,    -26, &
                  -125,    514,    -35,    -44,   -107,    -98,   -602,    -44,   -188,   -116,    388,     -8,    -26,   -116, &
                  -584,    136,   -602,   -125,    -26,   -584,    -35,   -188,    280,   -620,   -620,    100,    100,     10, &
                   451,   -188,     37,    -53,    532,    -44,   -125,    532,   -620,    -62,  -4094,    514,   -107,    451, &
                   388,     -8,    -26,    -98,   -602,     37,   -125,    -53,   -620,    -62,  -3590,   1036,    451,    442, &
                  -188,   -116,   -602,    136,    280,     28,    532,    -44]
  K1( 283,:) = [   -125,    -53,   -602,     37,    -62,   -620,    451,    442,  -3590,   1036,   -116,   -188,   -107,    451, &
                   388,     -8,    -26,    -98,     28,    280,    -44,    532,   -602,    136,    514,    -62,    -44,    -53, &
                    10,    100,    -44,     28,   -116,    442,    -62,    -53,   -116,    -44,    136,   -116,    514,    -44, &
                     1,     10,     10,    -62,    -62,     28,    -26,   -116,    388,     -8,    136,   -584,    -35,    -44, &
                   -26,    451,    514,   -125,    316,   -728,    388,  -3590,    316,    388,   -116,   -188,    -44,   -602, &
                   -98,   -107,    -98,   -188,    316,   -728,   -584,     -8,   -188,    532,   -584,   -188,  -4094,    532, &
                  -728,    496,     -8,   1036,   -728,     -8,   -188,   1036,    532,    136,     -8,    -98,    -62,   -620, &
                   514,  -4094,   -125,    532,     10,    100,    100,   -620,   -620,    280,    -44,    532,    -53,     37, &
                  -188,    451,    -35,   -188,   -125,   -602,   -584,    -26]
  K1( 284,:) = [   -602,     37,   -125,    -53,   -620,    -62,   -107,    451,    388,     -8,    -26,    -98,    451,    442, &
                 -3590,   1036,   -116,   -188,    280,     28,   -602,    136,    -44,    532,    -44,    -53,    514,    -62, &
                   100,     10,   -116,    -44,    136,   -116,    514,    -44,    -44,     28,   -116,    442,    -62,    -53, &
                    10,      1,    -62,     28,     10,    -62,    -98,   -188,    316,   -728,   -584,     -8,   -188,    532, &
                  -584,   -188,  -4094,    532,   -728,    496,     -8,   1036,   -728,     -8,   -188,   1036,    532,    136, &
                    -8,    -98,    -26,   -116,    388,     -8,    136,   -584,    -35,    -44,    -26,    451,    514,   -125, &
                   316,   -728,    388,  -3590,    316,    388,   -116,   -188,    -44,   -602,    -98,   -107,   -620,    -62, &
                  -125,    532,    514,  -4094,    100,     10,   -620,    280,    100,   -620,    -35,   -188,   -125,   -602, &
                  -584,    -26,    -44,    532,    -53,     37,   -188,    451]
  K1( 285,:) = [    -35,    -44,    -26,    451,    514,   -125,    -26,   -116,    388,     -8,    136,   -584,    388,  -3590, &
                   316,   -728,    388,    316,    -44,   -602,   -116,   -188,   -107,    -98,    -44,     28,   -116,    442, &
                   -62,    -53,    514,    -62,    -44,    -53,     10,    100,    136,   -116,   -116,    -44,    -44,    514, &
                    10,    -62,      1,     10,     28,    -62,    451,    442,  -3590,   1036,   -116,   -188,   -125,    -53, &
                  -602,     37,    -62,   -620,    388,     -8,   -107,    451,    -98,    -26,    -44,    532,     28,    280, &
                   136,   -602,     -8,   1036,   -728,    496,     -8,   -728,   -584,   -188,   -188,    532,    532,  -4094, &
                   316,   -728,    -98,   -188,     -8,   -584,    -98,     -8,    136,    532,   1036,   -188,    -53,     37, &
                   -44,    532,    451,   -188,    100,   -620,     10,    100,    280,   -620,    514,  -4094,    -62,   -620, &
                   532,   -125,    -26,   -584,   -602,   -125,   -188,    -35]
  K1( 286,:) = [   -188,    532,   -584,   -188,  -4094,    532,    -98,   -188,    316,   -728,   -584,     -8,     -8,   1036, &
                  -728,    496,     -8,   -728,    532,    136,   -188,   1036,    -98,     -8,   -116,    -44,    136,   -116, &
                   514,    -44,    -44,    -53,    514,    -62,    100,     10,   -116,    442,    -44,     28,    -53,    -62, &
                   -62,     28,     10,      1,    -62,     10,   -107,    451,    388,     -8,    -26,    -98,   -602,     37, &
                  -125,    -53,   -620,    -62,  -3590,   1036,    451,    442,   -188,   -116,   -602,    136,    280,     28, &
                   532,    -44,    388,  -3590,    316,   -728,    388,    316,    -26,    451,    -35,    -44,   -125,    514, &
                   388,     -8,    -26,   -116,   -584,    136,   -107,    -98,   -602,    -44,   -188,   -116,   -125,   -602, &
                   -35,   -188,    -26,   -584,   -620,    280,    100,     10,   -620,    100,   -125,    532,   -620,    -62, &
                 -4094,    514,    451,   -188,     37,    -53,    532,    -44]
  K1( 287,:) = [    -26,    451,    -35,    -44,   -125,    514,    388,  -3590,    316,   -728,    388,    316,    -26,   -116, &
                   388,     -8,    136,   -584,   -602,    -44,   -107,    -98,   -116,   -188,   -116,    442,    -44,     28, &
                   -53,    -62,    136,   -116,   -116,    -44,    -44,    514,    514,    -62,    -44,    -53,     10,    100, &
                   -62,     10,     28,    -62,      1,     10,     -8,   1036,   -728,    496,     -8,   -728,   -584,   -188, &
                  -188,    532,    532,  -4094,    316,   -728,    -98,   -188,     -8,   -584,    -98,     -8,    136,    532, &
                  1036,   -188,    451,    442,  -3590,   1036,   -116,   -188,   -125,    -53,   -602,     37,    -62,   -620, &
                   388,     -8,   -107,    451,    -98,    -26,    -44,    532,     28,    280,    136,   -602,     37,    -53, &
                   451,   -188,    -44,    532,   -620,    100,    280,   -620,     10,    100,    -26,   -584,   -602,   -125, &
                  -188,    -35,    514,  -4094,    -62,   -620,    532,   -125]
  K1( 288,:) = [   -584,   -188,   -188,    532,    532,  -4094,     -8,   1036,   -728,    496,     -8,   -728,    -98,   -188, &
                   316,   -728,   -584,     -8,    136,    532,    -98,     -8,   -188,   1036,    136,   -116,   -116,    -44, &
                   -44,    514,   -116,    442,    -44,     28,    -53,    -62,    -44,    -53,    514,    -62,    100,     10, &
                    28,    -62,    -62,     10,     10,      1,    388,  -3590,    316,   -728,    388,    316,    -26,    451, &
                   -35,    -44,   -125,    514,    388,     -8,    -26,   -116,   -584,    136,   -107,    -98,   -602,    -44, &
                  -188,   -116,   -107,    451,    388,     -8,    -26,    -98,   -602,     37,   -125,    -53,   -620,    -62, &
                 -3590,   1036,    451,    442,   -188,   -116,   -602,    136,    280,     28,    532,    -44,   -602,   -125, &
                   -26,   -584,    -35,   -188,    280,   -620,   -620,    100,    100,     10,    451,   -188,     37,    -53, &
                   532,    -44,   -125,    532,   -620,    -62,  -4094,    514]
  K1( 289,:) = [    -62,   -620,    514,  -4094,   -125,    532,     10,    100,    100,   -620,   -620,    280,    -44,    532, &
                   -53,     37,   -188,    451,    -35,   -188,   -125,   -602,   -584,    -26,     28,    280,    -44,    532, &
                  -602,    136,    -62,   -620,    -53,   -125,     37,   -602,   -116,   -188,    442,    451,   1036,  -3590, &
                   -26,    -98,    451,   -107,     -8,    388,      1,     10,     10,    -62,    -62,     28,     10,    100, &
                   -62,    514,    -53,    -44,    -62,    -53,     28,    -44,    442,   -116,    514,    -44,    -44,   -116, &
                  -116,    136,   -116,   -188,    -44,   -602,    -98,   -107,    136,   -584,   -116,    -26,     -8,    388, &
                   514,   -125,    -44,    -35,    451,    -26,    316,    388,   -728,    316,  -3590,    388,   -188,   1036, &
                   532,    136,     -8,    -98,   -584,     -8,   -188,    -98,   -728,    316,  -4094,    532,    532,   -188, &
                  -188,   -584,   -728,     -8,    496,   -728,   1036,     -8]
  K1( 290,:) = [   -620,    -62,   -125,    532,    514,  -4094,    100,     10,   -620,    280,    100,   -620,    -35,   -188, &
                  -125,   -602,   -584,    -26,    -44,    532,    -53,     37,   -188,    451,    280,     28,   -602,    136, &
                   -44,    532,   -620,    -62,     37,   -602,    -53,   -125,    -26,    -98,    451,   -107,     -8,    388, &
                  -116,   -188,    442,    451,   1036,  -3590,     10,      1,    -62,     28,     10,    -62,    100,     10, &
                   -53,    -44,    -62,    514,    514,    -44,    -44,   -116,   -116,    136,    -62,    -53,     28,    -44, &
                   442,   -116,   -188,   1036,    532,    136,     -8,    -98,   -584,     -8,   -188,    -98,   -728,    316, &
                 -4094,    532,    532,   -188,   -188,   -584,   -728,     -8,    496,   -728,   1036,     -8,   -116,   -188, &
                   -44,   -602,    -98,   -107,    136,   -584,   -116,    -26,     -8,    388,    514,   -125,    -44,    -35, &
                   451,    -26,    316,    388,   -728,    316,  -3590,    388]
  K1( 291,:) = [    -53,     37,    -44,    532,    451,   -188,    100,   -620,     10,    100,    280,   -620,    514,  -4094, &
                   -62,   -620,    532,   -125,    -26,   -584,   -602,   -125,   -188,    -35,    -44,   -602,   -116,   -188, &
                  -107,    -98,    514,   -125,    -44,    -35,    451,    -26,    136,   -584,   -116,    -26,     -8,    388, &
                   388,    316,  -3590,    388,   -728,    316,     10,    -62,      1,     10,     28,    -62,    -62,    -53, &
                    28,    -44,    442,   -116,     10,    100,    -62,    514,    -53,    -44,    -44,    514,   -116,    136, &
                   -44,   -116,    -44,    532,     28,    280,    136,   -602,   -116,   -188,    442,    451,   1036,  -3590, &
                   -62,   -620,    -53,   -125,     37,   -602,    -98,    -26,     -8,    388,    451,   -107,    -98,     -8, &
                   136,    532,   1036,   -188,     -8,   -728,   1036,     -8,    496,   -728,    532,  -4094,   -188,   -584, &
                   532,   -188,     -8,   -584,   -728,    316,   -188,    -98]
  K1( 292,:) = [   -125,   -602,    -35,   -188,    -26,   -584,   -620,    280,    100,     10,   -620,    100,   -125,    532, &
                  -620,    -62,  -4094,    514,    451,   -188,     37,    -53,    532,    -44,    532,    136,   -188,   1036, &
                   -98,     -8,  -4094,    532,    532,   -188,   -188,   -584,   -584,     -8,   -188,    -98,   -728,    316, &
                    -8,   -728,   1036,     -8,    496,   -728,    -62,     28,     10,      1,    -62,     10,    514,    -44, &
                   -44,   -116,   -116,    136,    100,     10,    -53,    -44,    -62,    514,    -53,    -62,    442,   -116, &
                    28,    -44,   -602,    136,    280,     28,    532,    -44,    -26,    -98,    451,   -107,     -8,    388, &
                  -620,    -62,     37,   -602,    -53,   -125,   -188,   -116,   1036,  -3590,    442,    451,   -107,    -98, &
                  -602,    -44,   -188,   -116,    388,    316,  -3590,    388,   -728,    316,   -125,    514,    451,    -26, &
                   -44,    -35,   -584,    136,     -8,    388,   -116,    -26]
  K1( 293,:) = [     37,    -53,    451,   -188,    -44,    532,   -620,    100,    280,   -620,     10,    100,    -26,   -584, &
                  -602,   -125,   -188,    -35,    514,  -4094,    -62,   -620,    532,   -125,   -602,    -44,   -107,    -98, &
                  -116,   -188,   -125,    514,    451,    -26,    -44,    -35,    388,    316,  -3590,    388,   -728,    316, &
                   136,   -584,   -116,    -26,     -8,    388,    -62,     10,     28,    -62,      1,     10,    -53,    -62, &
                   442,   -116,     28,    -44,    -44,    514,   -116,    136,    -44,   -116,     10,    100,    -62,    514, &
                   -53,    -44,    -98,     -8,    136,    532,   1036,   -188,     -8,   -728,   1036,     -8,    496,   -728, &
                   532,  -4094,   -188,   -584,    532,   -188,     -8,   -584,   -728,    316,   -188,    -98,    -44,    532, &
                    28,    280,    136,   -602,   -116,   -188,    442,    451,   1036,  -3590,    -62,   -620,    -53,   -125, &
                    37,   -602,    -98,    -26,     -8,    388,    451,   -107]
  K1( 294,:) = [   -602,   -125,    -26,   -584,    -35,   -188,    280,   -620,   -620,    100,    100,     10,    451,   -188, &
                    37,    -53,    532,    -44,   -125,    532,   -620,    -62,  -4094,    514,    136,    532,    -98,     -8, &
                  -188,   1036,    532,  -4094,   -188,   -584,    532,   -188,     -8,   -728,   1036,     -8,    496,   -728, &
                  -584,     -8,   -188,    -98,   -728,    316,     28,    -62,    -62,     10,     10,      1,    -44,    514, &
                  -116,    136,    -44,   -116,    -53,    -62,    442,   -116,     28,    -44,    100,     10,    -53,    -44, &
                   -62,    514,   -107,    -98,   -602,    -44,   -188,   -116,    388,    316,  -3590,    388,   -728,    316, &
                  -125,    514,    451,    -26,    -44,    -35,   -584,    136,     -8,    388,   -116,    -26,   -602,    136, &
                   280,     28,    532,    -44,    -26,    -98,    451,   -107,     -8,    388,   -620,    -62,     37,   -602, &
                   -53,   -125,   -188,   -116,   1036,  -3590,    442,    451]
  K1( 295,:) = [     28,    280,    -44,    532,   -602,    136,    -62,   -620,    -53,   -125,     37,   -602,   -116,   -188, &
                   442,    451,   1036,  -3590,    -26,    -98,    451,   -107,     -8,    388,    -62,   -620,    514,  -4094, &
                  -125,    532,     10,    100,    100,   -620,   -620,    280,    -44,    532,    -53,     37,   -188,    451, &
                   -35,   -188,   -125,   -602,   -584,    -26,     10,    100,    -62,    514,    -53,    -44,      1,     10, &
                    10,    -62,    -62,     28,     28,    -44,    -62,    -53,   -116,    442,    -44,   -116,    514,    -44, &
                   136,   -116,    136,   -584,   -116,    -26,     -8,    388,   -116,   -188,    -44,   -602,    -98,   -107, &
                   -44,    -35,    514,   -125,    -26,    451,   -728,    316,    316,    388,    388,  -3590,   -584,     -8, &
                  -188,    -98,   -728,    316,   -188,   1036,    532,    136,     -8,    -98,    532,   -188,  -4094,    532, &
                  -584,   -188,    496,   -728,   -728,     -8,     -8,   1036]
  K1( 296,:) = [    280,     28,   -602,    136,    -44,    532,   -620,    -62,     37,   -602,    -53,   -125,    -26,    -98, &
                   451,   -107,     -8,    388,   -116,   -188,    442,    451,   1036,  -3590,   -620,    -62,   -125,    532, &
                   514,  -4094,    100,     10,   -620,    280,    100,   -620,    -35,   -188,   -125,   -602,   -584,    -26, &
                   -44,    532,    -53,     37,   -188,    451,    100,     10,    -53,    -44,    -62,    514,     10,      1, &
                   -62,     28,     10,    -62,    -44,   -116,    514,    -44,    136,   -116,     28,    -44,    -62,    -53, &
                  -116,    442,   -584,     -8,   -188,    -98,   -728,    316,   -188,   1036,    532,    136,     -8,    -98, &
                   532,   -188,  -4094,    532,   -584,   -188,    496,   -728,   -728,     -8,     -8,   1036,    136,   -584, &
                  -116,    -26,     -8,    388,   -116,   -188,    -44,   -602,    -98,   -107,    -44,    -35,    514,   -125, &
                   -26,    451,   -728,    316,    316,    388,    388,  -3590]
  K1( 297,:) = [    -44,   -602,   -116,   -188,   -107,    -98,    514,   -125,    -44,    -35,    451,    -26,    136,   -584, &
                  -116,    -26,     -8,    388,    388,    316,  -3590,    388,   -728,    316,    -53,     37,    -44,    532, &
                   451,   -188,    100,   -620,     10,    100,    280,   -620,    514,  -4094,    -62,   -620,    532,   -125, &
                   -26,   -584,   -602,   -125,   -188,    -35,    -62,    -53,     28,    -44,    442,   -116,     10,    -62, &
                     1,     10,     28,    -62,    -62,    514,     10,    100,    -44,    -53,   -116,    136,    -44,    514, &
                  -116,    -44,   -116,   -188,    442,    451,   1036,  -3590,    -44,    532,     28,    280,    136,   -602, &
                   -53,   -125,    -62,   -620,   -602,     37,     -8,    388,    -98,    -26,   -107,    451,     -8,   -728, &
                  1036,     -8,    496,   -728,    -98,     -8,    136,    532,   1036,   -188,   -188,   -584,    532,  -4094, &
                  -188,    532,   -728,    316,     -8,   -584,    -98,   -188]
  K1( 298,:) = [    532,    136,   -188,   1036,    -98,     -8,  -4094,    532,    532,   -188,   -188,   -584,   -584,     -8, &
                  -188,    -98,   -728,    316,     -8,   -728,   1036,     -8,    496,   -728,   -125,   -602,    -35,   -188, &
                   -26,   -584,   -620,    280,    100,     10,   -620,    100,   -125,    532,   -620,    -62,  -4094,    514, &
                   451,   -188,     37,    -53,    532,    -44,    514,    -44,    -44,   -116,   -116,    136,    -62,     28, &
                    10,      1,    -62,     10,    -53,    -44,    100,     10,    514,    -62,    442,   -116,    -53,    -62, &
                   -44,     28,    -26,    -98,    451,   -107,     -8,    388,   -602,    136,    280,     28,    532,    -44, &
                    37,   -602,   -620,    -62,   -125,    -53,   1036,  -3590,   -188,   -116,    451,    442,    388,    316, &
                 -3590,    388,   -728,    316,   -107,    -98,   -602,    -44,   -188,   -116,    451,    -26,   -125,    514, &
                   -35,    -44,     -8,    388,   -584,    136,    -26,   -116]
  K1( 299,:) = [   -602,    -44,   -107,    -98,   -116,   -188,   -125,    514,    451,    -26,    -44,    -35,    388,    316, &
                 -3590,    388,   -728,    316,    136,   -584,   -116,    -26,     -8,    388,     37,    -53,    451,   -188, &
                   -44,    532,   -620,    100,    280,   -620,     10,    100,    -26,   -584,   -602,   -125,   -188,    -35, &
                   514,  -4094,    -62,   -620,    532,   -125,    -53,    -62,    442,   -116,     28,    -44,    -62,     10, &
                    28,    -62,      1,     10,   -116,    136,    -44,    514,   -116,    -44,    -62,    514,     10,    100, &
                   -44,    -53,     -8,   -728,   1036,     -8,    496,   -728,    -98,     -8,    136,    532,   1036,   -188, &
                  -188,   -584,    532,  -4094,   -188,    532,   -728,    316,     -8,   -584,    -98,   -188,   -116,   -188, &
                   442,    451,   1036,  -3590,    -44,    532,     28,    280,    136,   -602,    -53,   -125,    -62,   -620, &
                  -602,     37,     -8,    388,    -98,    -26,   -107,    451]
  K1( 300,:) = [    136,    532,    -98,     -8,   -188,   1036,    532,  -4094,   -188,   -584,    532,   -188,     -8,   -728, &
                  1036,     -8,    496,   -728,   -584,     -8,   -188,    -98,   -728,    316,   -602,   -125,    -26,   -584, &
                   -35,   -188,    280,   -620,   -620,    100,    100,     10,    451,   -188,     37,    -53,    532,    -44, &
                  -125,    532,   -620,    -62,  -4094,    514,    -44,    514,   -116,    136,    -44,   -116,     28,    -62, &
                   -62,     10,     10,      1,    442,   -116,    -53,    -62,    -44,     28,    -53,    -44,    100,     10, &
                   514,    -62,    388,    316,  -3590,    388,   -728,    316,   -107,    -98,   -602,    -44,   -188,   -116, &
                   451,    -26,   -125,    514,    -35,    -44,     -8,    388,   -584,    136,    -26,   -116,    -26,    -98, &
                   451,   -107,     -8,    388,   -602,    136,    280,     28,    532,    -44,     37,   -602,   -620,    -62, &
                  -125,    -53,   1036,  -3590,   -188,   -116,    451,    442]
  K1( 301,:) = [    442,    451,   -116,   -188,  -3590,   1036,    -53,   -125,    -62,   -620,   -602,     37,    -44,    532, &
                    28,    280,    136,   -602,    388,     -8,   -107,    451,    -98,    -26,   -116,    -26,    136,   -584, &
                   388,     -8,    -44,    -35,    514,   -125,    -26,    451,   -116,   -188,    -44,   -602,    -98,   -107, &
                   316,   -728,    388,  -3590,    316,    388,    -62,    514,     10,    100,    -44,    -53,     28,    -44, &
                   -62,    -53,   -116,    442,      1,     10,     10,    -62,    -62,     28,   -116,    -44,    136,   -116, &
                   514,    -44,    514,  -4094,    -62,   -620,    532,   -125,    -44,    532,    -53,     37,   -188,    451, &
                    10,    100,    100,   -620,   -620,    280,   -188,    -35,   -584,    -26,   -125,   -602,    316,   -728, &
                   -98,   -188,     -8,   -584,   -728,    496,     -8,   1036,   -728,     -8,   -188,    532,   -584,   -188, &
                 -4094,    532,   1036,   -188,     -8,    -98,    532,    136]
  K1( 302,:) = [    451,   -107,    -26,    -98,    388,     -8,     37,   -602,   -620,    -62,   -125,    -53,   -602,    136, &
                   280,     28,    532,    -44,  -3590,   1036,    451,    442,   -188,   -116,   -188,    -98,   -584,     -8, &
                   316,   -728,    532,   -188,  -4094,    532,   -584,   -188,   -188,   1036,    532,    136,     -8,    -98, &
                  -728,    496,     -8,   1036,   -728,     -8,    -53,    -44,    100,     10,    514,    -62,    -44,   -116, &
                   514,    -44,    136,   -116,     10,      1,    -62,     28,     10,    -62,    -44,     28,   -116,    442, &
                   -62,    -53,   -125,    532,   -620,    -62,  -4094,    514,    -35,   -188,   -125,   -602,   -584,    -26, &
                   100,     10,   -620,    280,    100,   -620,    532,    -44,   -188,    451,    -53,     37,    388,     -8, &
                   -26,   -116,   -584,    136,    316,   -728,    388,  -3590,    316,    388,    -35,    -44,    -26,    451, &
                   514,   -125,   -188,   -116,    -98,   -107,    -44,   -602]
  K1( 303,:) = [   -116,    -26,    136,   -584,    388,     -8,    -44,    -35,    514,   -125,    -26,    451,   -116,   -188, &
                   -44,   -602,    -98,   -107,    316,   -728,    388,  -3590,    316,    388,    442,    451,   -116,   -188, &
                 -3590,   1036,    -53,   -125,    -62,   -620,   -602,     37,    -44,    532,     28,    280,    136,   -602, &
                   388,     -8,   -107,    451,    -98,    -26,     28,    -44,    -62,    -53,   -116,    442,    -62,    514, &
                    10,    100,    -44,    -53,     10,    -62,      1,     10,     28,    -62,    136,   -116,   -116,    -44, &
                   -44,    514,    -44,    532,    -53,     37,   -188,    451,    514,  -4094,    -62,   -620,    532,   -125, &
                   100,   -620,     10,    100,    280,   -620,   -584,    -26,   -188,    -35,   -602,   -125,   -728,    496, &
                    -8,   1036,   -728,     -8,    316,   -728,    -98,   -188,     -8,   -584,   -584,   -188,   -188,    532, &
                   532,  -4094,     -8,    -98,   1036,   -188,    136,    532]
  K1( 304,:) = [   -188,    -98,   -584,     -8,    316,   -728,    532,   -188,  -4094,    532,   -584,   -188,   -188,   1036, &
                   532,    136,     -8,    -98,   -728,    496,     -8,   1036,   -728,     -8,    451,   -107,    -26,    -98, &
                   388,     -8,     37,   -602,   -620,    -62,   -125,    -53,   -602,    136,    280,     28,    532,    -44, &
                 -3590,   1036,    451,    442,   -188,   -116,    -44,   -116,    514,    -44,    136,   -116,    -53,    -44, &
                   100,     10,    514,    -62,    -62,     28,     10,      1,    -62,     10,   -116,    442,    -44,     28, &
                   -53,    -62,    -35,   -188,   -125,   -602,   -584,    -26,   -125,    532,   -620,    -62,  -4094,    514, &
                  -620,    280,    100,     10,   -620,    100,   -188,    451,    532,    -44,     37,    -53,    316,   -728, &
                   388,  -3590,    316,    388,    388,     -8,    -26,   -116,   -584,    136,    -26,    451,    -35,    -44, &
                  -125,    514,    -98,   -107,   -188,   -116,   -602,    -44]
  K1( 305,:) = [  -3590,    388,    388,    316,    316,   -728,    451,    -26,   -125,    514,    -35,    -44,   -107,    -98, &
                  -602,    -44,   -188,   -116,    388,     -8,    -26,   -116,   -584,    136,   1036,     -8,     -8,   -728, &
                  -728,    496,   -188,   -584,    532,  -4094,   -188,    532,    -98,     -8,    136,    532,   1036,   -188, &
                   316,   -728,    -98,   -188,     -8,   -584,    442,   -116,    -53,    -62,    -44,     28,   -116,    136, &
                   -44,    514,   -116,    -44,    -62,     10,     28,    -62,      1,     10,    514,    -62,    -44,    -53, &
                    10,    100,    451,   -188,     37,    -53,    532,    -44,    -26,   -584,   -602,   -125,   -188,    -35, &
                  -620,    100,    280,   -620,     10,    100,  -4094,    514,    532,   -125,    -62,   -620,  -3590,   1036, &
                   451,    442,   -188,   -116,    388,     -8,   -107,    451,    -98,    -26,   -125,    -53,   -602,     37, &
                   -62,   -620,    532,    -44,    136,   -602,     28,    280]
  K1( 306,:) = [   1036,     -8,     -8,   -728,   -728,    496,   -188,   -584,    532,  -4094,   -188,    532,    -98,     -8, &
                   136,    532,   1036,   -188,    316,   -728,    -98,   -188,     -8,   -584,  -3590,    388,    388,    316, &
                   316,   -728,    451,    -26,   -125,    514,    -35,    -44,   -107,    -98,   -602,    -44,   -188,   -116, &
                   388,     -8,    -26,   -116,   -584,    136,   -116,    136,    -44,    514,   -116,    -44,    442,   -116, &
                   -53,    -62,    -44,     28,     28,    -62,    -62,     10,     10,      1,    -44,    -53,    514,    -62, &
                   100,     10,    -26,   -584,   -602,   -125,   -188,    -35,    451,   -188,     37,    -53,    532,    -44, &
                   280,   -620,   -620,    100,    100,     10,    532,   -125,  -4094,    514,   -620,    -62,    388,     -8, &
                  -107,    451,    -98,    -26,  -3590,   1036,    451,    442,   -188,   -116,   -602,     37,   -125,    -53, &
                  -620,    -62,    136,   -602,    532,    -44,    280,     28]
  K1( 307,:) = [    451,    442,  -3590,   1036,   -116,   -188,   -125,    -53,   -602,     37,    -62,   -620,    388,     -8, &
                  -107,    451,    -98,    -26,    -44,    532,     28,    280,    136,   -602,    -26,   -116,    388,     -8, &
                   136,   -584,    -35,    -44,    -26,    451,    514,   -125,    316,   -728,    388,  -3590,    316,    388, &
                  -116,   -188,    -44,   -602,    -98,   -107,    514,    -62,    -44,    -53,     10,    100,    -44,     28, &
                  -116,    442,    -62,    -53,   -116,    -44,    136,   -116,    514,    -44,      1,     10,     10,    -62, &
                   -62,     28,    316,   -728,    -98,   -188,     -8,   -584,   -728,    496,     -8,   1036,   -728,     -8, &
                  -188,    532,   -584,   -188,  -4094,    532,   1036,   -188,     -8,    -98,    532,    136,    514,  -4094, &
                   -62,   -620,    532,   -125,    -44,    532,    -53,     37,   -188,    451,     10,    100,    100,   -620, &
                  -620,    280,   -188,    -35,   -584,    -26,   -125,   -602]
  K1( 308,:) = [   -107,    451,    388,     -8,    -26,    -98,   -602,     37,   -125,    -53,   -620,    -62,  -3590,   1036, &
                   451,    442,   -188,   -116,   -602,    136,    280,     28,    532,    -44,    -98,   -188,    316,   -728, &
                  -584,     -8,   -188,    532,   -584,   -188,  -4094,    532,   -728,    496,     -8,   1036,   -728,     -8, &
                  -188,   1036,    532,    136,     -8,    -98,    -44,    -53,    514,    -62,    100,     10,   -116,    -44, &
                   136,   -116,    514,    -44,    -44,     28,   -116,    442,    -62,    -53,     10,      1,    -62,     28, &
                    10,    -62,    388,     -8,    -26,   -116,   -584,    136,    316,   -728,    388,  -3590,    316,    388, &
                   -35,    -44,    -26,    451,    514,   -125,   -188,   -116,    -98,   -107,    -44,   -602,   -125,    532, &
                  -620,    -62,  -4094,    514,    -35,   -188,   -125,   -602,   -584,    -26,    100,     10,   -620,    280, &
                   100,   -620,    532,    -44,   -188,    451,    -53,     37]
  K1( 309,:) = [    -26,   -116,    388,     -8,    136,   -584,    -35,    -44,    -26,    451,    514,   -125,    316,   -728, &
                   388,  -3590,    316,    388,   -116,   -188,    -44,   -602,    -98,   -107,    451,    442,  -3590,   1036, &
                  -116,   -188,   -125,    -53,   -602,     37,    -62,   -620,    388,     -8,   -107,    451,    -98,    -26, &
                   -44,    532,     28,    280,    136,   -602,    -44,     28,   -116,    442,    -62,    -53,    514,    -62, &
                   -44,    -53,     10,    100,    136,   -116,   -116,    -44,    -44,    514,     10,    -62,      1,     10, &
                    28,    -62,   -728,    496,     -8,   1036,   -728,     -8,    316,   -728,    -98,   -188,     -8,   -584, &
                  -584,   -188,   -188,    532,    532,  -4094,     -8,    -98,   1036,   -188,    136,    532,    -44,    532, &
                   -53,     37,   -188,    451,    514,  -4094,    -62,   -620,    532,   -125,    100,   -620,     10,    100, &
                   280,   -620,   -584,    -26,   -188,    -35,   -602,   -125]
  K1( 310,:) = [    -98,   -188,    316,   -728,   -584,     -8,   -188,    532,   -584,   -188,  -4094,    532,   -728,    496, &
                    -8,   1036,   -728,     -8,   -188,   1036,    532,    136,     -8,    -98,   -107,    451,    388,     -8, &
                   -26,    -98,   -602,     37,   -125,    -53,   -620,    -62,  -3590,   1036,    451,    442,   -188,   -116, &
                  -602,    136,    280,     28,    532,    -44,   -116,    -44,    136,   -116,    514,    -44,    -44,    -53, &
                   514,    -62,    100,     10,   -116,    442,    -44,     28,    -53,    -62,    -62,     28,     10,      1, &
                   -62,     10,    316,   -728,    388,  -3590,    316,    388,    388,     -8,    -26,   -116,   -584,    136, &
                   -26,    451,    -35,    -44,   -125,    514,    -98,   -107,   -188,   -116,   -602,    -44,    -35,   -188, &
                  -125,   -602,   -584,    -26,   -125,    532,   -620,    -62,  -4094,    514,   -620,    280,    100,     10, &
                  -620,    100,   -188,    451,    532,    -44,     37,    -53]
  K1( 311,:) = [    388,  -3590,    316,   -728,    388,    316,    -26,    451,    -35,    -44,   -125,    514,    388,     -8, &
                   -26,   -116,   -584,    136,   -107,    -98,   -602,    -44,   -188,   -116,     -8,   1036,   -728,    496, &
                    -8,   -728,   -584,   -188,   -188,    532,    532,  -4094,    316,   -728,    -98,   -188,     -8,   -584, &
                   -98,     -8,    136,    532,   1036,   -188,   -116,    442,    -44,     28,    -53,    -62,    136,   -116, &
                  -116,    -44,    -44,    514,    514,    -62,    -44,    -53,     10,    100,    -62,     10,     28,    -62, &
                     1,     10,  -3590,   1036,    451,    442,   -188,   -116,    388,     -8,   -107,    451,    -98,    -26, &
                  -125,    -53,   -602,     37,    -62,   -620,    532,    -44,    136,   -602,     28,    280,    451,   -188, &
                    37,    -53,    532,    -44,    -26,   -584,   -602,   -125,   -188,    -35,   -620,    100,    280,   -620, &
                    10,    100,  -4094,    514,    532,   -125,    -62,   -620]
  K1( 312,:) = [     -8,   1036,   -728,    496,     -8,   -728,   -584,   -188,   -188,    532,    532,  -4094,    316,   -728, &
                   -98,   -188,     -8,   -584,    -98,     -8,    136,    532,   1036,   -188,    388,  -3590,    316,   -728, &
                   388,    316,    -26,    451,    -35,    -44,   -125,    514,    388,     -8,    -26,   -116,   -584,    136, &
                  -107,    -98,   -602,    -44,   -188,   -116,    136,   -116,   -116,    -44,    -44,    514,   -116,    442, &
                   -44,     28,    -53,    -62,    -44,    -53,    514,    -62,    100,     10,     28,    -62,    -62,     10, &
                    10,      1,    388,     -8,   -107,    451,    -98,    -26,  -3590,   1036,    451,    442,   -188,   -116, &
                  -602,     37,   -125,    -53,   -620,    -62,    136,   -602,    532,    -44,    280,     28,    -26,   -584, &
                  -602,   -125,   -188,    -35,    451,   -188,     37,    -53,    532,    -44,    280,   -620,   -620,    100, &
                   100,     10,    532,   -125,  -4094,    514,   -620,    -62]
  K1( 313,:) = [    514,  -4094,    -62,   -620,    532,   -125,    -44,    532,    -53,     37,   -188,    451,     10,    100, &
                   100,   -620,   -620,    280,   -188,    -35,   -584,    -26,   -125,   -602,    -44,    532,     28,    280, &
                   136,   -602,   -116,   -188,    442,    451,   1036,  -3590,    -62,   -620,    -53,   -125,     37,   -602, &
                   -98,    -26,     -8,    388,    451,   -107,   -116,   -188,    -44,   -602,    -98,   -107,    136,   -584, &
                  -116,    -26,     -8,    388,    514,   -125,    -44,    -35,    451,    -26,    316,    388,   -728,    316, &
                 -3590,    388,      1,     10,     10,    -62,    -62,     28,     10,    100,    -62,    514,    -53,    -44, &
                   -62,    -53,     28,    -44,    442,   -116,    514,    -44,    -44,   -116,   -116,    136,   1036,   -188, &
                    -8,    -98,    532,    136,     -8,   -584,   -728,    316,   -188,    -98,   -728,     -8,    496,   -728, &
                  1036,     -8,  -4094,    532,    532,   -188,   -188,   -584]
  K1( 314,:) = [   -125,    532,   -620,    -62,  -4094,    514,    -35,   -188,   -125,   -602,   -584,    -26,    100,     10, &
                  -620,    280,    100,   -620,    532,    -44,   -188,    451,    -53,     37,   -602,    136,    280,     28, &
                   532,    -44,    -26,    -98,    451,   -107,     -8,    388,   -620,    -62,     37,   -602,    -53,   -125, &
                  -188,   -116,   1036,  -3590,    442,    451,   -188,   1036,    532,    136,     -8,    -98,   -584,     -8, &
                  -188,    -98,   -728,    316,  -4094,    532,    532,   -188,   -188,   -584,   -728,     -8,    496,   -728, &
                  1036,     -8,     10,      1,    -62,     28,     10,    -62,    100,     10,    -53,    -44,    -62,    514, &
                   514,    -44,    -44,   -116,   -116,    136,    -62,    -53,     28,    -44,    442,   -116,   -188,   -116, &
                   -98,   -107,    -44,   -602,   -584,    136,     -8,    388,   -116,    -26,    316,    388,   -728,    316, &
                 -3590,    388,    514,   -125,    -44,    -35,    451,    -26]
  K1( 315,:) = [    -44,    532,    -53,     37,   -188,    451,    514,  -4094,    -62,   -620,    532,   -125,    100,   -620, &
                    10,    100,    280,   -620,   -584,    -26,   -188,    -35,   -602,   -125,   -116,   -188,    -44,   -602, &
                   -98,   -107,    136,   -584,   -116,    -26,     -8,    388,    514,   -125,    -44,    -35,    451,    -26, &
                   316,    388,   -728,    316,  -3590,    388,    -44,    532,     28,    280,    136,   -602,   -116,   -188, &
                   442,    451,   1036,  -3590,    -62,   -620,    -53,   -125,     37,   -602,    -98,    -26,     -8,    388, &
                   451,   -107,     10,    -62,      1,     10,     28,    -62,    -62,    -53,     28,    -44,    442,   -116, &
                    10,    100,    -62,    514,    -53,    -44,    -44,    514,   -116,    136,    -44,   -116,     -8,    -98, &
                  1036,   -188,    136,    532,   -728,     -8,    496,   -728,   1036,     -8,     -8,   -584,   -728,    316, &
                  -188,    -98,    532,  -4094,   -188,   -584,    532,   -188]
  K1( 316,:) = [    -35,   -188,   -125,   -602,   -584,    -26,   -125,    532,   -620,    -62,  -4094,    514,   -620,    280, &
                   100,     10,   -620,    100,   -188,    451,    532,    -44,     37,    -53,   -188,   1036,    532,    136, &
                    -8,    -98,   -584,     -8,   -188,    -98,   -728,    316,  -4094,    532,    532,   -188,   -188,   -584, &
                  -728,     -8,    496,   -728,   1036,     -8,   -602,    136,    280,     28,    532,    -44,    -26,    -98, &
                   451,   -107,     -8,    388,   -620,    -62,     37,   -602,    -53,   -125,   -188,   -116,   1036,  -3590, &
                   442,    451,    -62,     28,     10,      1,    -62,     10,    514,    -44,    -44,   -116,   -116,    136, &
                   100,     10,    -53,    -44,    -62,    514,    -53,    -62,    442,   -116,     28,    -44,    -98,   -107, &
                  -188,   -116,   -602,    -44,    316,    388,   -728,    316,  -3590,    388,   -584,    136,     -8,    388, &
                  -116,    -26,   -125,    514,    451,    -26,    -44,    -35]
  K1( 317,:) = [    451,   -188,     37,    -53,    532,    -44,    -26,   -584,   -602,   -125,   -188,    -35,   -620,    100, &
                   280,   -620,     10,    100,  -4094,    514,    532,   -125,    -62,   -620,   -107,    -98,   -602,    -44, &
                  -188,   -116,    388,    316,  -3590,    388,   -728,    316,   -125,    514,    451,    -26,    -44,    -35, &
                  -584,    136,     -8,    388,   -116,    -26,    -98,     -8,    136,    532,   1036,   -188,     -8,   -728, &
                  1036,     -8,    496,   -728,    532,  -4094,   -188,   -584,    532,   -188,     -8,   -584,   -728,    316, &
                  -188,    -98,    -62,     10,     28,    -62,      1,     10,    -53,    -62,    442,   -116,     28,    -44, &
                   -44,    514,   -116,    136,    -44,   -116,     10,    100,    -62,    514,    -53,    -44,    532,    -44, &
                   136,   -602,     28,    280,   -188,   -116,   1036,  -3590,    442,    451,    -98,    -26,     -8,    388, &
                   451,   -107,    -62,   -620,    -53,   -125,     37,   -602]
  K1( 318,:) = [    -26,   -584,   -602,   -125,   -188,    -35,    451,   -188,     37,    -53,    532,    -44,    280,   -620, &
                  -620,    100,    100,     10,    532,   -125,  -4094,    514,   -620,    -62,    -98,     -8,    136,    532, &
                  1036,   -188,     -8,   -728,   1036,     -8,    496,   -728,    532,  -4094,   -188,   -584,    532,   -188, &
                    -8,   -584,   -728,    316,   -188,    -98,   -107,    -98,   -602,    -44,   -188,   -116,    388,    316, &
                 -3590,    388,   -728,    316,   -125,    514,    451,    -26,    -44,    -35,   -584,    136,     -8,    388, &
                  -116,    -26,     28,    -62,    -62,     10,     10,      1,    -44,    514,   -116,    136,    -44,   -116, &
                   -53,    -62,    442,   -116,     28,    -44,    100,     10,    -53,    -44,    -62,    514,    136,   -602, &
                   532,    -44,    280,     28,    -98,    -26,     -8,    388,    451,   -107,   -188,   -116,   1036,  -3590, &
                   442,    451,   -620,    -62,     37,   -602,    -53,   -125]
  K1( 319,:) = [    -44,    532,     28,    280,    136,   -602,   -116,   -188,    442,    451,   1036,  -3590,    -62,   -620, &
                   -53,   -125,     37,   -602,    -98,    -26,     -8,    388,    451,   -107,    514,  -4094,    -62,   -620, &
                   532,   -125,    -44,    532,    -53,     37,   -188,    451,     10,    100,    100,   -620,   -620,    280, &
                  -188,    -35,   -584,    -26,   -125,   -602,    136,   -584,   -116,    -26,     -8,    388,   -116,   -188, &
                   -44,   -602,    -98,   -107,    -44,    -35,    514,   -125,    -26,    451,   -728,    316,    316,    388, &
                   388,  -3590,     10,    100,    -62,    514,    -53,    -44,      1,     10,     10,    -62,    -62,     28, &
                    28,    -44,    -62,    -53,   -116,    442,    -44,   -116,    514,    -44,    136,   -116,     -8,   -584, &
                  -728,    316,   -188,    -98,   1036,   -188,     -8,    -98,    532,    136,    496,   -728,   -728,     -8, &
                    -8,   1036,    532,   -188,  -4094,    532,   -584,   -188]
  K1( 320,:) = [   -602,    136,    280,     28,    532,    -44,    -26,    -98,    451,   -107,     -8,    388,   -620,    -62, &
                    37,   -602,    -53,   -125,   -188,   -116,   1036,  -3590,    442,    451,   -125,    532,   -620,    -62, &
                 -4094,    514,    -35,   -188,   -125,   -602,   -584,    -26,    100,     10,   -620,    280,    100,   -620, &
                   532,    -44,   -188,    451,    -53,     37,   -584,     -8,   -188,    -98,   -728,    316,   -188,   1036, &
                   532,    136,     -8,    -98,    532,   -188,  -4094,    532,   -584,   -188,    496,   -728,   -728,     -8, &
                    -8,   1036,    100,     10,    -53,    -44,    -62,    514,     10,      1,    -62,     28,     10,    -62, &
                   -44,   -116,    514,    -44,    136,   -116,     28,    -44,    -62,    -53,   -116,    442,   -584,    136, &
                    -8,    388,   -116,    -26,   -188,   -116,    -98,   -107,    -44,   -602,   -728,    316,    316,    388, &
                   388,  -3590,    -44,    -35,    514,   -125,    -26,    451]
  K1( 321,:) = [   -116,   -188,    -44,   -602,    -98,   -107,    136,   -584,   -116,    -26,     -8,    388,    514,   -125, &
                   -44,    -35,    451,    -26,    316,    388,   -728,    316,  -3590,    388,    -44,    532,    -53,     37, &
                  -188,    451,    514,  -4094,    -62,   -620,    532,   -125,    100,   -620,     10,    100,    280,   -620, &
                  -584,    -26,   -188,    -35,   -602,   -125,   -116,   -188,    442,    451,   1036,  -3590,    -44,    532, &
                    28,    280,    136,   -602,    -53,   -125,    -62,   -620,   -602,     37,     -8,    388,    -98,    -26, &
                  -107,    451,    -62,    -53,     28,    -44,    442,   -116,     10,    -62,      1,     10,     28,    -62, &
                   -62,    514,     10,    100,    -44,    -53,   -116,    136,    -44,    514,   -116,    -44,   -728,     -8, &
                   496,   -728,   1036,     -8,     -8,    -98,   1036,   -188,    136,    532,   -728,    316,     -8,   -584, &
                   -98,   -188,   -188,   -584,    532,  -4094,   -188,    532]
  K1( 322,:) = [   -188,   1036,    532,    136,     -8,    -98,   -584,     -8,   -188,    -98,   -728,    316,  -4094,    532, &
                   532,   -188,   -188,   -584,   -728,     -8,    496,   -728,   1036,     -8,    -35,   -188,   -125,   -602, &
                  -584,    -26,   -125,    532,   -620,    -62,  -4094,    514,   -620,    280,    100,     10,   -620,    100, &
                  -188,    451,    532,    -44,     37,    -53,    -26,    -98,    451,   -107,     -8,    388,   -602,    136, &
                   280,     28,    532,    -44,     37,   -602,   -620,    -62,   -125,    -53,   1036,  -3590,   -188,   -116, &
                   451,    442,    514,    -44,    -44,   -116,   -116,    136,    -62,     28,     10,      1,    -62,     10, &
                   -53,    -44,    100,     10,    514,    -62,    442,   -116,    -53,    -62,    -44,     28,    316,    388, &
                  -728,    316,  -3590,    388,    -98,   -107,   -188,   -116,   -602,    -44,     -8,    388,   -584,    136, &
                   -26,   -116,    451,    -26,   -125,    514,    -35,    -44]
  K1( 323,:) = [   -107,    -98,   -602,    -44,   -188,   -116,    388,    316,  -3590,    388,   -728,    316,   -125,    514, &
                   451,    -26,    -44,    -35,   -584,    136,     -8,    388,   -116,    -26,    451,   -188,     37,    -53, &
                   532,    -44,    -26,   -584,   -602,   -125,   -188,    -35,   -620,    100,    280,   -620,     10,    100, &
                 -4094,    514,    532,   -125,    -62,   -620,     -8,   -728,   1036,     -8,    496,   -728,    -98,     -8, &
                   136,    532,   1036,   -188,   -188,   -584,    532,  -4094,   -188,    532,   -728,    316,     -8,   -584, &
                   -98,   -188,    -53,    -62,    442,   -116,     28,    -44,    -62,     10,     28,    -62,      1,     10, &
                  -116,    136,    -44,    514,   -116,    -44,    -62,    514,     10,    100,    -44,    -53,   -188,   -116, &
                  1036,  -3590,    442,    451,    532,    -44,    136,   -602,     28,    280,     -8,    388,    -98,    -26, &
                  -107,    451,    -53,   -125,    -62,   -620,   -602,     37]
  K1( 324,:) = [    -98,     -8,    136,    532,   1036,   -188,     -8,   -728,   1036,     -8,    496,   -728,    532,  -4094, &
                  -188,   -584,    532,   -188,     -8,   -584,   -728,    316,   -188,    -98,    -26,   -584,   -602,   -125, &
                  -188,    -35,    451,   -188,     37,    -53,    532,    -44,    280,   -620,   -620,    100,    100,     10, &
                   532,   -125,  -4094,    514,   -620,    -62,    388,    316,  -3590,    388,   -728,    316,   -107,    -98, &
                  -602,    -44,   -188,   -116,    451,    -26,   -125,    514,    -35,    -44,     -8,    388,   -584,    136, &
                   -26,   -116,    -44,    514,   -116,    136,    -44,   -116,     28,    -62,    -62,     10,     10,      1, &
                   442,   -116,    -53,    -62,    -44,     28,    -53,    -44,    100,     10,    514,    -62,    -98,    -26, &
                    -8,    388,    451,   -107,    136,   -602,    532,    -44,    280,     28,   1036,  -3590,   -188,   -116, &
                   451,    442,     37,   -602,   -620,    -62,   -125,    -53]
  K1( 325,:) = [   -116,   -188,    442,    451,   1036,  -3590,    -44,    532,     28,    280,    136,   -602,    -53,   -125, &
                   -62,   -620,   -602,     37,     -8,    388,    -98,    -26,   -107,    451,    136,   -584,   -116,    -26, &
                    -8,    388,   -116,   -188,    -44,   -602,    -98,   -107,    -44,    -35,    514,   -125,    -26,    451, &
                  -728,    316,    316,    388,    388,  -3590,    514,  -4094,    -62,   -620,    532,   -125,    -44,    532, &
                   -53,     37,   -188,    451,     10,    100,    100,   -620,   -620,    280,   -188,    -35,   -584,    -26, &
                  -125,   -602,    -62,    514,     10,    100,    -44,    -53,     28,    -44,    -62,    -53,   -116,    442, &
                     1,     10,     10,    -62,    -62,     28,   -116,    -44,    136,   -116,    514,    -44,   -728,    316, &
                    -8,   -584,    -98,   -188,    496,   -728,   -728,     -8,     -8,   1036,   1036,   -188,     -8,    -98, &
                   532,    136,   -188,    532,   -584,   -188,  -4094,    532]
  K1( 326,:) = [    -26,    -98,    451,   -107,     -8,    388,   -602,    136,    280,     28,    532,    -44,     37,   -602, &
                  -620,    -62,   -125,    -53,   1036,  -3590,   -188,   -116,    451,    442,   -584,     -8,   -188,    -98, &
                  -728,    316,   -188,   1036,    532,    136,     -8,    -98,    532,   -188,  -4094,    532,   -584,   -188, &
                   496,   -728,   -728,     -8,     -8,   1036,   -125,    532,   -620,    -62,  -4094,    514,    -35,   -188, &
                  -125,   -602,   -584,    -26,    100,     10,   -620,    280,    100,   -620,    532,    -44,   -188,    451, &
                   -53,     37,    -53,    -44,    100,     10,    514,    -62,    -44,   -116,    514,    -44,    136,   -116, &
                    10,      1,    -62,     28,     10,    -62,    -44,     28,   -116,    442,    -62,    -53,     -8,    388, &
                  -584,    136,    -26,   -116,   -728,    316,    316,    388,    388,  -3590,   -188,   -116,    -98,   -107, &
                   -44,   -602,    -35,    -44,    -26,    451,    514,   -125]
  K1( 327,:) = [    136,   -584,   -116,    -26,     -8,    388,   -116,   -188,    -44,   -602,    -98,   -107,    -44,    -35, &
                   514,   -125,    -26,    451,   -728,    316,    316,    388,    388,  -3590,   -116,   -188,    442,    451, &
                  1036,  -3590,    -44,    532,     28,    280,    136,   -602,    -53,   -125,    -62,   -620,   -602,     37, &
                    -8,    388,    -98,    -26,   -107,    451,    -44,    532,    -53,     37,   -188,    451,    514,  -4094, &
                   -62,   -620,    532,   -125,    100,   -620,     10,    100,    280,   -620,   -584,    -26,   -188,    -35, &
                  -602,   -125,     28,    -44,    -62,    -53,   -116,    442,    -62,    514,     10,    100,    -44,    -53, &
                    10,    -62,      1,     10,     28,    -62,    136,   -116,   -116,    -44,    -44,    514,    496,   -728, &
                  -728,     -8,     -8,   1036,   -728,    316,     -8,   -584,    -98,   -188,     -8,    -98,   1036,   -188, &
                   136,    532,   -584,   -188,   -188,    532,    532,  -4094]
  K1( 328,:) = [   -584,     -8,   -188,    -98,   -728,    316,   -188,   1036,    532,    136,     -8,    -98,    532,   -188, &
                 -4094,    532,   -584,   -188,    496,   -728,   -728,     -8,     -8,   1036,    -26,    -98,    451,   -107, &
                    -8,    388,   -602,    136,    280,     28,    532,    -44,     37,   -602,   -620,    -62,   -125,    -53, &
                  1036,  -3590,   -188,   -116,    451,    442,    -35,   -188,   -125,   -602,   -584,    -26,   -125,    532, &
                  -620,    -62,  -4094,    514,   -620,    280,    100,     10,   -620,    100,   -188,    451,    532,    -44, &
                    37,    -53,    -44,   -116,    514,    -44,    136,   -116,    -53,    -44,    100,     10,    514,    -62, &
                   -62,     28,     10,      1,    -62,     10,   -116,    442,    -44,     28,    -53,    -62,   -728,    316, &
                   316,    388,    388,  -3590,     -8,    388,   -584,    136,    -26,   -116,    -98,   -107,   -188,   -116, &
                  -602,    -44,    -26,    451,    -35,    -44,   -125,    514]
  K1( 329,:) = [    388,    316,  -3590,    388,   -728,    316,   -107,    -98,   -602,    -44,   -188,   -116,    451,    -26, &
                  -125,    514,    -35,    -44,     -8,    388,   -584,    136,    -26,   -116,     -8,   -728,   1036,     -8, &
                   496,   -728,    -98,     -8,    136,    532,   1036,   -188,   -188,   -584,    532,  -4094,   -188,    532, &
                  -728,    316,     -8,   -584,    -98,   -188,    451,   -188,     37,    -53,    532,    -44,    -26,   -584, &
                  -602,   -125,   -188,    -35,   -620,    100,    280,   -620,     10,    100,  -4094,    514,    532,   -125, &
                   -62,   -620,    442,   -116,    -53,    -62,    -44,     28,   -116,    136,    -44,    514,   -116,    -44, &
                   -62,     10,     28,    -62,      1,     10,    514,    -62,    -44,    -53,     10,    100,   1036,  -3590, &
                  -188,   -116,    451,    442,     -8,    388,    -98,    -26,   -107,    451,    532,    -44,    136,   -602, &
                    28,    280,   -125,    -53,   -602,     37,    -62,   -620]
  K1( 330,:) = [     -8,   -728,   1036,     -8,    496,   -728,    -98,     -8,    136,    532,   1036,   -188,   -188,   -584, &
                   532,  -4094,   -188,    532,   -728,    316,     -8,   -584,    -98,   -188,    388,    316,  -3590,    388, &
                  -728,    316,   -107,    -98,   -602,    -44,   -188,   -116,    451,    -26,   -125,    514,    -35,    -44, &
                    -8,    388,   -584,    136,    -26,   -116,    -26,   -584,   -602,   -125,   -188,    -35,    451,   -188, &
                    37,    -53,    532,    -44,    280,   -620,   -620,    100,    100,     10,    532,   -125,  -4094,    514, &
                  -620,    -62,   -116,    136,    -44,    514,   -116,    -44,    442,   -116,    -53,    -62,    -44,     28, &
                    28,    -62,    -62,     10,     10,      1,    -44,    -53,    514,    -62,    100,     10,     -8,    388, &
                   -98,    -26,   -107,    451,   1036,  -3590,   -188,   -116,    451,    442,    136,   -602,    532,    -44, &
                   280,     28,   -602,     37,   -125,    -53,   -620,    -62]
  K1( 331,:) = [  -3590,   1036,    451,    442,   -188,   -116,    388,     -8,   -107,    451,    -98,    -26,   -125,    -53, &
                  -602,     37,    -62,   -620,    532,    -44,    136,   -602,     28,    280,    388,     -8,    -26,   -116, &
                  -584,    136,    316,   -728,    388,  -3590,    316,    388,    -35,    -44,    -26,    451,    514,   -125, &
                  -188,   -116,    -98,   -107,    -44,   -602,    316,   -728,    -98,   -188,     -8,   -584,   -728,    496, &
                    -8,   1036,   -728,     -8,   -188,    532,   -584,   -188,  -4094,    532,   1036,   -188,     -8,    -98, &
                   532,    136,    514,    -62,    -44,    -53,     10,    100,    -44,     28,   -116,    442,    -62,    -53, &
                  -116,    -44,    136,   -116,    514,    -44,      1,     10,     10,    -62,    -62,     28,  -4094,    514, &
                   532,   -125,    -62,   -620,    532,    -44,   -188,    451,    -53,     37,   -188,    -35,   -584,    -26, &
                  -125,   -602,     10,    100,    100,   -620,   -620,    280]
  K1( 332,:) = [    388,     -8,   -107,    451,    -98,    -26,  -3590,   1036,    451,    442,   -188,   -116,   -602,     37, &
                  -125,    -53,   -620,    -62,    136,   -602,    532,    -44,    280,     28,    316,   -728,    -98,   -188, &
                    -8,   -584,   -728,    496,     -8,   1036,   -728,     -8,   -188,    532,   -584,   -188,  -4094,    532, &
                  1036,   -188,     -8,    -98,    532,    136,    388,     -8,    -26,   -116,   -584,    136,    316,   -728, &
                   388,  -3590,    316,    388,    -35,    -44,    -26,    451,    514,   -125,   -188,   -116,    -98,   -107, &
                   -44,   -602,    -44,    -53,    514,    -62,    100,     10,   -116,    -44,    136,   -116,    514,    -44, &
                   -44,     28,   -116,    442,    -62,    -53,     10,      1,    -62,     28,     10,    -62,    532,   -125, &
                 -4094,    514,   -620,    -62,   -188,    -35,   -584,    -26,   -125,   -602,    532,    -44,   -188,    451, &
                   -53,     37,    100,     10,   -620,    280,    100,   -620]
  K1( 333,:) = [    388,     -8,    -26,   -116,   -584,    136,    316,   -728,    388,  -3590,    316,    388,    -35,    -44, &
                   -26,    451,    514,   -125,   -188,   -116,    -98,   -107,    -44,   -602,  -3590,   1036,    451,    442, &
                  -188,   -116,    388,     -8,   -107,    451,    -98,    -26,   -125,    -53,   -602,     37,    -62,   -620, &
                   532,    -44,    136,   -602,     28,    280,   -728,    496,     -8,   1036,   -728,     -8,    316,   -728, &
                   -98,   -188,     -8,   -584,   -584,   -188,   -188,    532,    532,  -4094,     -8,    -98,   1036,   -188, &
                   136,    532,    -44,     28,   -116,    442,    -62,    -53,    514,    -62,    -44,    -53,     10,    100, &
                   136,   -116,   -116,    -44,    -44,    514,     10,    -62,      1,     10,     28,    -62,    532,    -44, &
                  -188,    451,    -53,     37,  -4094,    514,    532,   -125,    -62,   -620,   -584,    -26,   -188,    -35, &
                  -602,   -125,    100,   -620,     10,    100,    280,   -620]
  K1( 334,:) = [    316,   -728,    -98,   -188,     -8,   -584,   -728,    496,     -8,   1036,   -728,     -8,   -188,    532, &
                  -584,   -188,  -4094,    532,   1036,   -188,     -8,    -98,    532,    136,    388,     -8,   -107,    451, &
                   -98,    -26,  -3590,   1036,    451,    442,   -188,   -116,   -602,     37,   -125,    -53,   -620,    -62, &
                   136,   -602,    532,    -44,    280,     28,    316,   -728,    388,  -3590,    316,    388,    388,     -8, &
                   -26,   -116,   -584,    136,    -26,    451,    -35,    -44,   -125,    514,    -98,   -107,   -188,   -116, &
                  -602,    -44,   -116,    -44,    136,   -116,    514,    -44,    -44,    -53,    514,    -62,    100,     10, &
                  -116,    442,    -44,     28,    -53,    -62,    -62,     28,     10,      1,    -62,     10,   -188,    -35, &
                  -584,    -26,   -125,   -602,    532,   -125,  -4094,    514,   -620,    -62,   -188,    451,    532,    -44, &
                    37,    -53,   -620,    280,    100,     10,   -620,    100]
  K1( 335,:) = [    316,   -728,    388,  -3590,    316,    388,    388,     -8,    -26,   -116,   -584,    136,    -26,    451, &
                   -35,    -44,   -125,    514,    -98,   -107,   -188,   -116,   -602,    -44,   -728,    496,     -8,   1036, &
                  -728,     -8,    316,   -728,    -98,   -188,     -8,   -584,   -584,   -188,   -188,    532,    532,  -4094, &
                    -8,    -98,   1036,   -188,    136,    532,  -3590,   1036,    451,    442,   -188,   -116,    388,     -8, &
                  -107,    451,    -98,    -26,   -125,    -53,   -602,     37,    -62,   -620,    532,    -44,    136,   -602, &
                    28,    280,   -116,    442,    -44,     28,    -53,    -62,    136,   -116,   -116,    -44,    -44,    514, &
                   514,    -62,    -44,    -53,     10,    100,    -62,     10,     28,    -62,      1,     10,   -188,    451, &
                   532,    -44,     37,    -53,   -584,    -26,   -188,    -35,   -602,   -125,  -4094,    514,    532,   -125, &
                   -62,   -620,   -620,    100,    280,   -620,     10,    100]
  K1( 336,:) = [   -728,    496,     -8,   1036,   -728,     -8,    316,   -728,    -98,   -188,     -8,   -584,   -584,   -188, &
                  -188,    532,    532,  -4094,     -8,    -98,   1036,   -188,    136,    532,    316,   -728,    388,  -3590, &
                   316,    388,    388,     -8,    -26,   -116,   -584,    136,    -26,    451,    -35,    -44,   -125,    514, &
                   -98,   -107,   -188,   -116,   -602,    -44,    388,     -8,   -107,    451,    -98,    -26,  -3590,   1036, &
                   451,    442,   -188,   -116,   -602,     37,   -125,    -53,   -620,    -62,    136,   -602,    532,    -44, &
                   280,     28,    136,   -116,   -116,    -44,    -44,    514,   -116,    442,    -44,     28,    -53,    -62, &
                   -44,    -53,    514,    -62,    100,     10,     28,    -62,    -62,     10,     10,      1,   -584,    -26, &
                  -188,    -35,   -602,   -125,   -188,    451,    532,    -44,     37,    -53,    532,   -125,  -4094,    514, &
                  -620,    -62,    280,   -620,   -620,    100,    100,     10]
  K1( 337,:) = [  -4094,    514,    532,   -125,    -62,   -620,    532,    -44,   -188,    451,    -53,     37,   -188,    -35, &
                  -584,    -26,   -125,   -602,     10,    100,    100,   -620,   -620,    280,    532,    -44,    136,   -602, &
                    28,    280,   -188,   -116,   1036,  -3590,    442,    451,    -98,    -26,     -8,    388,    451,   -107, &
                   -62,   -620,    -53,   -125,     37,   -602,   -188,   -116,    -98,   -107,    -44,   -602,   -584,    136, &
                    -8,    388,   -116,    -26,    316,    388,   -728,    316,  -3590,    388,    514,   -125,    -44,    -35, &
                   451,    -26,   1036,   -188,     -8,    -98,    532,    136,     -8,   -584,   -728,    316,   -188,    -98, &
                  -728,     -8,    496,   -728,   1036,     -8,  -4094,    532,    532,   -188,   -188,   -584,      1,     10, &
                    10,    -62,    -62,     28,     10,    100,    -62,    514,    -53,    -44,    -62,    -53,     28,    -44, &
                   442,   -116,    514,    -44,    -44,   -116,   -116,    136]
  K1( 338,:) = [    532,   -125,  -4094,    514,   -620,    -62,   -188,    -35,   -584,    -26,   -125,   -602,    532,    -44, &
                  -188,    451,    -53,     37,    100,     10,   -620,    280,    100,   -620,    136,   -602,    532,    -44, &
                   280,     28,    -98,    -26,     -8,    388,    451,   -107,   -188,   -116,   1036,  -3590,    442,    451, &
                  -620,    -62,     37,   -602,    -53,   -125,   1036,   -188,     -8,    -98,    532,    136,     -8,   -584, &
                  -728,    316,   -188,    -98,   -728,     -8,    496,   -728,   1036,     -8,  -4094,    532,    532,   -188, &
                  -188,   -584,   -188,   -116,    -98,   -107,    -44,   -602,   -584,    136,     -8,    388,   -116,    -26, &
                   316,    388,   -728,    316,  -3590,    388,    514,   -125,    -44,    -35,    451,    -26,     10,      1, &
                   -62,     28,     10,    -62,    100,     10,    -53,    -44,    -62,    514,    514,    -44,    -44,   -116, &
                  -116,    136,    -62,    -53,     28,    -44,    442,   -116]
  K1( 339,:) = [    532,    -44,   -188,    451,    -53,     37,  -4094,    514,    532,   -125,    -62,   -620,   -584,    -26, &
                  -188,    -35,   -602,   -125,    100,   -620,     10,    100,    280,   -620,   -188,   -116,    -98,   -107, &
                   -44,   -602,   -584,    136,     -8,    388,   -116,    -26,    316,    388,   -728,    316,  -3590,    388, &
                   514,   -125,    -44,    -35,    451,    -26,    532,    -44,    136,   -602,     28,    280,   -188,   -116, &
                  1036,  -3590,    442,    451,    -98,    -26,     -8,    388,    451,   -107,    -62,   -620,    -53,   -125, &
                    37,   -602,     -8,    -98,   1036,   -188,    136,    532,   -728,     -8,    496,   -728,   1036,     -8, &
                    -8,   -584,   -728,    316,   -188,    -98,    532,  -4094,   -188,   -584,    532,   -188,     10,    -62, &
                     1,     10,     28,    -62,    -62,    -53,     28,    -44,    442,   -116,     10,    100,    -62,    514, &
                   -53,    -44,    -44,    514,   -116,    136,    -44,   -116]
  K1( 340,:) = [   -188,    -35,   -584,    -26,   -125,   -602,    532,   -125,  -4094,    514,   -620,    -62,   -188,    451, &
                   532,    -44,     37,    -53,   -620,    280,    100,     10,   -620,    100,   1036,   -188,     -8,    -98, &
                   532,    136,     -8,   -584,   -728,    316,   -188,    -98,   -728,     -8,    496,   -728,   1036,     -8, &
                 -4094,    532,    532,   -188,   -188,   -584,    136,   -602,    532,    -44,    280,     28,    -98,    -26, &
                    -8,    388,    451,   -107,   -188,   -116,   1036,  -3590,    442,    451,   -620,    -62,     37,   -602, &
                   -53,   -125,    -98,   -107,   -188,   -116,   -602,    -44,    316,    388,   -728,    316,  -3590,    388, &
                  -584,    136,     -8,    388,   -116,    -26,   -125,    514,    451,    -26,    -44,    -35,    -62,     28, &
                    10,      1,    -62,     10,    514,    -44,    -44,   -116,   -116,    136,    100,     10,    -53,    -44, &
                   -62,    514,    -53,    -62,    442,   -116,     28,    -44]
  K1( 341,:) = [   -188,    451,    532,    -44,     37,    -53,   -584,    -26,   -188,    -35,   -602,   -125,  -4094,    514, &
                   532,   -125,    -62,   -620,   -620,    100,    280,   -620,     10,    100,    -98,   -107,   -188,   -116, &
                  -602,    -44,    316,    388,   -728,    316,  -3590,    388,   -584,    136,     -8,    388,   -116,    -26, &
                  -125,    514,    451,    -26,    -44,    -35,     -8,    -98,   1036,   -188,    136,    532,   -728,     -8, &
                   496,   -728,   1036,     -8,     -8,   -584,   -728,    316,   -188,    -98,    532,  -4094,   -188,   -584, &
                   532,   -188,    532,    -44,    136,   -602,     28,    280,   -188,   -116,   1036,  -3590,    442,    451, &
                   -98,    -26,     -8,    388,    451,   -107,    -62,   -620,    -53,   -125,     37,   -602,    -62,     10, &
                    28,    -62,      1,     10,    -53,    -62,    442,   -116,     28,    -44,    -44,    514,   -116,    136, &
                   -44,   -116,     10,    100,    -62,    514,    -53,    -44]
  K1( 342,:) = [   -584,    -26,   -188,    -35,   -602,   -125,   -188,    451,    532,    -44,     37,    -53,    532,   -125, &
                 -4094,    514,   -620,    -62,    280,   -620,   -620,    100,    100,     10,     -8,    -98,   1036,   -188, &
                   136,    532,   -728,     -8,    496,   -728,   1036,     -8,     -8,   -584,   -728,    316,   -188,    -98, &
                   532,  -4094,   -188,   -584,    532,   -188,    -98,   -107,   -188,   -116,   -602,    -44,    316,    388, &
                  -728,    316,  -3590,    388,   -584,    136,     -8,    388,   -116,    -26,   -125,    514,    451,    -26, &
                   -44,    -35,    136,   -602,    532,    -44,    280,     28,    -98,    -26,     -8,    388,    451,   -107, &
                  -188,   -116,   1036,  -3590,    442,    451,   -620,    -62,     37,   -602,    -53,   -125,     28,    -62, &
                   -62,     10,     10,      1,    -44,    514,   -116,    136,    -44,   -116,    -53,    -62,    442,   -116, &
                    28,    -44,    100,     10,    -53,    -44,    -62,    514]
  K1( 343,:) = [    532,    -44,    136,   -602,     28,    280,   -188,   -116,   1036,  -3590,    442,    451,    -98,    -26, &
                    -8,    388,    451,   -107,    -62,   -620,    -53,   -125,     37,   -602,  -4094,    514,    532,   -125, &
                   -62,   -620,    532,    -44,   -188,    451,    -53,     37,   -188,    -35,   -584,    -26,   -125,   -602, &
                    10,    100,    100,   -620,   -620,    280,   -584,    136,     -8,    388,   -116,    -26,   -188,   -116, &
                   -98,   -107,    -44,   -602,   -728,    316,    316,    388,    388,  -3590,    -44,    -35,    514,   -125, &
                   -26,    451,     -8,   -584,   -728,    316,   -188,    -98,   1036,   -188,     -8,    -98,    532,    136, &
                   496,   -728,   -728,     -8,     -8,   1036,    532,   -188,  -4094,    532,   -584,   -188,     10,    100, &
                   -62,    514,    -53,    -44,      1,     10,     10,    -62,    -62,     28,     28,    -44,    -62,    -53, &
                  -116,    442,    -44,   -116,    514,    -44,    136,   -116]
  K1( 344,:) = [    136,   -602,    532,    -44,    280,     28,    -98,    -26,     -8,    388,    451,   -107,   -188,   -116, &
                  1036,  -3590,    442,    451,   -620,    -62,     37,   -602,    -53,   -125,    532,   -125,  -4094,    514, &
                  -620,    -62,   -188,    -35,   -584,    -26,   -125,   -602,    532,    -44,   -188,    451,    -53,     37, &
                   100,     10,   -620,    280,    100,   -620,     -8,   -584,   -728,    316,   -188,    -98,   1036,   -188, &
                    -8,    -98,    532,    136,    496,   -728,   -728,     -8,     -8,   1036,    532,   -188,  -4094,    532, &
                  -584,   -188,   -584,    136,     -8,    388,   -116,    -26,   -188,   -116,    -98,   -107,    -44,   -602, &
                  -728,    316,    316,    388,    388,  -3590,    -44,    -35,    514,   -125,    -26,    451,    100,     10, &
                   -53,    -44,    -62,    514,     10,      1,    -62,     28,     10,    -62,    -44,   -116,    514,    -44, &
                   136,   -116,     28,    -44,    -62,    -53,   -116,    442]
  K1( 345,:) = [   -188,   -116,    -98,   -107,    -44,   -602,   -584,    136,     -8,    388,   -116,    -26,    316,    388, &
                  -728,    316,  -3590,    388,    514,   -125,    -44,    -35,    451,    -26,    532,    -44,   -188,    451, &
                   -53,     37,  -4094,    514,    532,   -125,    -62,   -620,   -584,    -26,   -188,    -35,   -602,   -125, &
                   100,   -620,     10,    100,    280,   -620,   -188,   -116,   1036,  -3590,    442,    451,    532,    -44, &
                   136,   -602,     28,    280,     -8,    388,    -98,    -26,   -107,    451,    -53,   -125,    -62,   -620, &
                  -602,     37,   -728,     -8,    496,   -728,   1036,     -8,     -8,    -98,   1036,   -188,    136,    532, &
                  -728,    316,     -8,   -584,    -98,   -188,   -188,   -584,    532,  -4094,   -188,    532,    -62,    -53, &
                    28,    -44,    442,   -116,     10,    -62,      1,     10,     28,    -62,    -62,    514,     10,    100, &
                   -44,    -53,   -116,    136,    -44,    514,   -116,    -44]
  K1( 346,:) = [   1036,   -188,     -8,    -98,    532,    136,     -8,   -584,   -728,    316,   -188,    -98,   -728,     -8, &
                   496,   -728,   1036,     -8,  -4094,    532,    532,   -188,   -188,   -584,   -188,    -35,   -584,    -26, &
                  -125,   -602,    532,   -125,  -4094,    514,   -620,    -62,   -188,    451,    532,    -44,     37,    -53, &
                  -620,    280,    100,     10,   -620,    100,    -98,    -26,     -8,    388,    451,   -107,    136,   -602, &
                   532,    -44,    280,     28,   1036,  -3590,   -188,   -116,    451,    442,     37,   -602,   -620,    -62, &
                  -125,    -53,    316,    388,   -728,    316,  -3590,    388,    -98,   -107,   -188,   -116,   -602,    -44, &
                    -8,    388,   -584,    136,    -26,   -116,    451,    -26,   -125,    514,    -35,    -44,    514,    -44, &
                   -44,   -116,   -116,    136,    -62,     28,     10,      1,    -62,     10,    -53,    -44,    100,     10, &
                   514,    -62,    442,   -116,    -53,    -62,    -44,     28]
  K1( 347,:) = [    -98,   -107,   -188,   -116,   -602,    -44,    316,    388,   -728,    316,  -3590,    388,   -584,    136, &
                    -8,    388,   -116,    -26,   -125,    514,    451,    -26,    -44,    -35,   -188,    451,    532,    -44, &
                    37,    -53,   -584,    -26,   -188,    -35,   -602,   -125,  -4094,    514,    532,   -125,    -62,   -620, &
                  -620,    100,    280,   -620,     10,    100,   -728,     -8,    496,   -728,   1036,     -8,     -8,    -98, &
                  1036,   -188,    136,    532,   -728,    316,     -8,   -584,    -98,   -188,   -188,   -584,    532,  -4094, &
                  -188,    532,   -188,   -116,   1036,  -3590,    442,    451,    532,    -44,    136,   -602,     28,    280, &
                    -8,    388,    -98,    -26,   -107,    451,    -53,   -125,    -62,   -620,   -602,     37,    -53,    -62, &
                   442,   -116,     28,    -44,    -62,     10,     28,    -62,      1,     10,   -116,    136,    -44,    514, &
                  -116,    -44,    -62,    514,     10,    100,    -44,    -53]
  K1( 348,:) = [     -8,    -98,   1036,   -188,    136,    532,   -728,     -8,    496,   -728,   1036,     -8,     -8,   -584, &
                  -728,    316,   -188,    -98,    532,  -4094,   -188,   -584,    532,   -188,   -584,    -26,   -188,    -35, &
                  -602,   -125,   -188,    451,    532,    -44,     37,    -53,    532,   -125,  -4094,    514,   -620,    -62, &
                   280,   -620,   -620,    100,    100,     10,    316,    388,   -728,    316,  -3590,    388,    -98,   -107, &
                  -188,   -116,   -602,    -44,     -8,    388,   -584,    136,    -26,   -116,    451,    -26,   -125,    514, &
                   -35,    -44,    -98,    -26,     -8,    388,    451,   -107,    136,   -602,    532,    -44,    280,     28, &
                  1036,  -3590,   -188,   -116,    451,    442,     37,   -602,   -620,    -62,   -125,    -53,    -44,    514, &
                  -116,    136,    -44,   -116,     28,    -62,    -62,     10,     10,      1,    442,   -116,    -53,    -62, &
                   -44,     28,    -53,    -44,    100,     10,    514,    -62]
  K1( 349,:) = [   -188,   -116,   1036,  -3590,    442,    451,    532,    -44,    136,   -602,     28,    280,     -8,    388, &
                   -98,    -26,   -107,    451,    -53,   -125,    -62,   -620,   -602,     37,   -584,    136,     -8,    388, &
                  -116,    -26,   -188,   -116,    -98,   -107,    -44,   -602,   -728,    316,    316,    388,    388,  -3590, &
                   -44,    -35,    514,   -125,    -26,    451,  -4094,    514,    532,   -125,    -62,   -620,    532,    -44, &
                  -188,    451,    -53,     37,   -188,    -35,   -584,    -26,   -125,   -602,     10,    100,    100,   -620, &
                  -620,    280,   -728,    316,     -8,   -584,    -98,   -188,    496,   -728,   -728,     -8,     -8,   1036, &
                  1036,   -188,     -8,    -98,    532,    136,   -188,    532,   -584,   -188,  -4094,    532,    -62,    514, &
                    10,    100,    -44,    -53,     28,    -44,    -62,    -53,   -116,    442,      1,     10,     10,    -62, &
                   -62,     28,   -116,    -44,    136,   -116,    514,    -44]
  K1( 350,:) = [    -98,    -26,     -8,    388,    451,   -107,    136,   -602,    532,    -44,    280,     28,   1036,  -3590, &
                  -188,   -116,    451,    442,     37,   -602,   -620,    -62,   -125,    -53,     -8,   -584,   -728,    316, &
                  -188,    -98,   1036,   -188,     -8,    -98,    532,    136,    496,   -728,   -728,     -8,     -8,   1036, &
                   532,   -188,  -4094,    532,   -584,   -188,    532,   -125,  -4094,    514,   -620,    -62,   -188,    -35, &
                  -584,    -26,   -125,   -602,    532,    -44,   -188,    451,    -53,     37,    100,     10,   -620,    280, &
                   100,   -620,     -8,    388,   -584,    136,    -26,   -116,   -728,    316,    316,    388,    388,  -3590, &
                  -188,   -116,    -98,   -107,    -44,   -602,    -35,    -44,    -26,    451,    514,   -125,    -53,    -44, &
                   100,     10,    514,    -62,    -44,   -116,    514,    -44,    136,   -116,     10,      1,    -62,     28, &
                    10,    -62,    -44,     28,   -116,    442,    -62,    -53]
  K1( 351,:) = [   -584,    136,     -8,    388,   -116,    -26,   -188,   -116,    -98,   -107,    -44,   -602,   -728,    316, &
                   316,    388,    388,  -3590,    -44,    -35,    514,   -125,    -26,    451,   -188,   -116,   1036,  -3590, &
                   442,    451,    532,    -44,    136,   -602,     28,    280,     -8,    388,    -98,    -26,   -107,    451, &
                   -53,   -125,    -62,   -620,   -602,     37,    532,    -44,   -188,    451,    -53,     37,  -4094,    514, &
                   532,   -125,    -62,   -620,   -584,    -26,   -188,    -35,   -602,   -125,    100,   -620,     10,    100, &
                   280,   -620,    496,   -728,   -728,     -8,     -8,   1036,   -728,    316,     -8,   -584,    -98,   -188, &
                    -8,    -98,   1036,   -188,    136,    532,   -584,   -188,   -188,    532,    532,  -4094,     28,    -44, &
                   -62,    -53,   -116,    442,    -62,    514,     10,    100,    -44,    -53,     10,    -62,      1,     10, &
                    28,    -62,    136,   -116,   -116,    -44,    -44,    514]
  K1( 352,:) = [     -8,   -584,   -728,    316,   -188,    -98,   1036,   -188,     -8,    -98,    532,    136,    496,   -728, &
                  -728,     -8,     -8,   1036,    532,   -188,  -4094,    532,   -584,   -188,    -98,    -26,     -8,    388, &
                   451,   -107,    136,   -602,    532,    -44,    280,     28,   1036,  -3590,   -188,   -116,    451,    442, &
                    37,   -602,   -620,    -62,   -125,    -53,   -188,    -35,   -584,    -26,   -125,   -602,    532,   -125, &
                 -4094,    514,   -620,    -62,   -188,    451,    532,    -44,     37,    -53,   -620,    280,    100,     10, &
                  -620,    100,   -728,    316,    316,    388,    388,  -3590,     -8,    388,   -584,    136,    -26,   -116, &
                   -98,   -107,   -188,   -116,   -602,    -44,    -26,    451,    -35,    -44,   -125,    514,    -44,   -116, &
                   514,    -44,    136,   -116,    -53,    -44,    100,     10,    514,    -62,    -62,     28,     10,      1, &
                   -62,     10,   -116,    442,    -44,     28,    -53,    -62]
  K1( 353,:) = [    316,    388,   -728,    316,  -3590,    388,    -98,   -107,   -188,   -116,   -602,    -44,     -8,    388, &
                  -584,    136,    -26,   -116,    451,    -26,   -125,    514,    -35,    -44,   -728,     -8,    496,   -728, &
                  1036,     -8,     -8,    -98,   1036,   -188,    136,    532,   -728,    316,     -8,   -584,    -98,   -188, &
                  -188,   -584,    532,  -4094,   -188,    532,   -188,    451,    532,    -44,     37,    -53,   -584,    -26, &
                  -188,    -35,   -602,   -125,  -4094,    514,    532,   -125,    -62,   -620,   -620,    100,    280,   -620, &
                    10,    100,   1036,  -3590,   -188,   -116,    451,    442,     -8,    388,    -98,    -26,   -107,    451, &
                   532,    -44,    136,   -602,     28,    280,   -125,    -53,   -602,     37,    -62,   -620,    442,   -116, &
                   -53,    -62,    -44,     28,   -116,    136,    -44,    514,   -116,    -44,    -62,     10,     28,    -62, &
                     1,     10,    514,    -62,    -44,    -53,     10,    100]
  K1( 354,:) = [   -728,     -8,    496,   -728,   1036,     -8,     -8,    -98,   1036,   -188,    136,    532,   -728,    316, &
                    -8,   -584,    -98,   -188,   -188,   -584,    532,  -4094,   -188,    532,    316,    388,   -728,    316, &
                 -3590,    388,    -98,   -107,   -188,   -116,   -602,    -44,     -8,    388,   -584,    136,    -26,   -116, &
                   451,    -26,   -125,    514,    -35,    -44,   -584,    -26,   -188,    -35,   -602,   -125,   -188,    451, &
                   532,    -44,     37,    -53,    532,   -125,  -4094,    514,   -620,    -62,    280,   -620,   -620,    100, &
                   100,     10,     -8,    388,    -98,    -26,   -107,    451,   1036,  -3590,   -188,   -116,    451,    442, &
                   136,   -602,    532,    -44,    280,     28,   -602,     37,   -125,    -53,   -620,    -62,   -116,    136, &
                   -44,    514,   -116,    -44,    442,   -116,    -53,    -62,    -44,     28,     28,    -62,    -62,     10, &
                    10,      1,    -44,    -53,    514,    -62,    100,     10]
  K1( 355,:) = [   1036,  -3590,   -188,   -116,    451,    442,     -8,    388,    -98,    -26,   -107,    451,    532,    -44, &
                   136,   -602,     28,    280,   -125,    -53,   -602,     37,    -62,   -620,     -8,    388,   -584,    136, &
                   -26,   -116,   -728,    316,    316,    388,    388,  -3590,   -188,   -116,    -98,   -107,    -44,   -602, &
                   -35,    -44,    -26,    451,    514,   -125,   -728,    316,     -8,   -584,    -98,   -188,    496,   -728, &
                  -728,     -8,     -8,   1036,   1036,   -188,     -8,    -98,    532,    136,   -188,    532,   -584,   -188, &
                 -4094,    532,  -4094,    514,    532,   -125,    -62,   -620,    532,    -44,   -188,    451,    -53,     37, &
                  -188,    -35,   -584,    -26,   -125,   -602,     10,    100,    100,   -620,   -620,    280,    514,    -62, &
                   -44,    -53,     10,    100,    -44,     28,   -116,    442,    -62,    -53,   -116,    -44,    136,   -116, &
                   514,    -44,      1,     10,     10,    -62,    -62,     28]
  K1( 356,:) = [     -8,    388,    -98,    -26,   -107,    451,   1036,  -3590,   -188,   -116,    451,    442,    136,   -602, &
                   532,    -44,    280,     28,   -602,     37,   -125,    -53,   -620,    -62,   -728,    316,     -8,   -584, &
                   -98,   -188,    496,   -728,   -728,     -8,     -8,   1036,   1036,   -188,     -8,    -98,    532,    136, &
                  -188,    532,   -584,   -188,  -4094,    532,     -8,    388,   -584,    136,    -26,   -116,   -728,    316, &
                   316,    388,    388,  -3590,   -188,   -116,    -98,   -107,    -44,   -602,    -35,    -44,    -26,    451, &
                   514,   -125,    532,   -125,  -4094,    514,   -620,    -62,   -188,    -35,   -584,    -26,   -125,   -602, &
                   532,    -44,   -188,    451,    -53,     37,    100,     10,   -620,    280,    100,   -620,    -44,    -53, &
                   514,    -62,    100,     10,   -116,    -44,    136,   -116,    514,    -44,    -44,     28,   -116,    442, &
                   -62,    -53,     10,      1,    -62,     28,     10,    -62]
  K1( 357,:) = [     -8,    388,   -584,    136,    -26,   -116,   -728,    316,    316,    388,    388,  -3590,   -188,   -116, &
                   -98,   -107,    -44,   -602,    -35,    -44,    -26,    451,    514,   -125,   1036,  -3590,   -188,   -116, &
                   451,    442,     -8,    388,    -98,    -26,   -107,    451,    532,    -44,    136,   -602,     28,    280, &
                  -125,    -53,   -602,     37,    -62,   -620,    496,   -728,   -728,     -8,     -8,   1036,   -728,    316, &
                    -8,   -584,    -98,   -188,     -8,    -98,   1036,   -188,    136,    532,   -584,   -188,   -188,    532, &
                   532,  -4094,    532,    -44,   -188,    451,    -53,     37,  -4094,    514,    532,   -125,    -62,   -620, &
                  -584,    -26,   -188,    -35,   -602,   -125,    100,   -620,     10,    100,    280,   -620,    -44,     28, &
                  -116,    442,    -62,    -53,    514,    -62,    -44,    -53,     10,    100,    136,   -116,   -116,    -44, &
                   -44,    514,     10,    -62,      1,     10,     28,    -62]
  K1( 358,:) = [   -728,    316,     -8,   -584,    -98,   -188,    496,   -728,   -728,     -8,     -8,   1036,   1036,   -188, &
                    -8,    -98,    532,    136,   -188,    532,   -584,   -188,  -4094,    532,     -8,    388,    -98,    -26, &
                  -107,    451,   1036,  -3590,   -188,   -116,    451,    442,    136,   -602,    532,    -44,    280,     28, &
                  -602,     37,   -125,    -53,   -620,    -62,   -728,    316,    316,    388,    388,  -3590,     -8,    388, &
                  -584,    136,    -26,   -116,    -98,   -107,   -188,   -116,   -602,    -44,    -26,    451,    -35,    -44, &
                  -125,    514,   -188,    -35,   -584,    -26,   -125,   -602,    532,   -125,  -4094,    514,   -620,    -62, &
                  -188,    451,    532,    -44,     37,    -53,   -620,    280,    100,     10,   -620,    100,   -116,    -44, &
                   136,   -116,    514,    -44,    -44,    -53,    514,    -62,    100,     10,   -116,    442,    -44,     28, &
                   -53,    -62,    -62,     28,     10,      1,    -62,     10]
  K1( 359,:) = [   -728,    316,    316,    388,    388,  -3590,     -8,    388,   -584,    136,    -26,   -116,    -98,   -107, &
                  -188,   -116,   -602,    -44,    -26,    451,    -35,    -44,   -125,    514,    496,   -728,   -728,     -8, &
                    -8,   1036,   -728,    316,     -8,   -584,    -98,   -188,     -8,    -98,   1036,   -188,    136,    532, &
                  -584,   -188,   -188,    532,    532,  -4094,   1036,  -3590,   -188,   -116,    451,    442,     -8,    388, &
                   -98,    -26,   -107,    451,    532,    -44,    136,   -602,     28,    280,   -125,    -53,   -602,     37, &
                   -62,   -620,   -188,    451,    532,    -44,     37,    -53,   -584,    -26,   -188,    -35,   -602,   -125, &
                 -4094,    514,    532,   -125,    -62,   -620,   -620,    100,    280,   -620,     10,    100,   -116,    442, &
                   -44,     28,    -53,    -62,    136,   -116,   -116,    -44,    -44,    514,    514,    -62,    -44,    -53, &
                    10,    100,    -62,     10,     28,    -62,      1,     10]
  K1( 360,:) = [    496,   -728,   -728,     -8,     -8,   1036,   -728,    316,     -8,   -584,    -98,   -188,     -8,    -98, &
                  1036,   -188,    136,    532,   -584,   -188,   -188,    532,    532,  -4094,   -728,    316,    316,    388, &
                   388,  -3590,     -8,    388,   -584,    136,    -26,   -116,    -98,   -107,   -188,   -116,   -602,    -44, &
                   -26,    451,    -35,    -44,   -125,    514,     -8,    388,    -98,    -26,   -107,    451,   1036,  -3590, &
                  -188,   -116,    451,    442,    136,   -602,    532,    -44,    280,     28,   -602,     37,   -125,    -53, &
                  -620,    -62,   -584,    -26,   -188,    -35,   -602,   -125,   -188,    451,    532,    -44,     37,    -53, &
                   532,   -125,  -4094,    514,   -620,    -62,    280,   -620,   -620,    100,    100,     10,    136,   -116, &
                  -116,    -44,    -44,    514,   -116,    442,    -44,     28,    -53,    -62,    -44,    -53,    514,    -62, &
                   100,     10,     28,    -62,    -62,     10,     10,      1]
  K1( 361,:) = [  32768,  -4096,  -4096,    512,    512,   5120,  -4096,    512,    512,    -64,    -64,   -640,    512,    -64, &
                  5120,   -640,   4544,   3968,    -64,   -640,   -640,   3968,   3968,  -1792,  -4096,    512,    512,    -64, &
                   -64,   -640,    512,    -64,    -64,      8,      8,     80,    -64,      8,   -640,     80,   -568,   -496, &
                     8,     80,     80,   -496,   -496,    224,    512,    -64,    -64,      8,      8,     80,   5120,   -640, &
                  -640,     80,     80,    800,   4544,   -568,   3968,   -496,   4040,   4112,   -568,    152,   -496,   -424, &
                 -1072,   -352,    -64,      8,   -640,     80,   -568,   -496,   -640,     80,   3968,   -496,    152,   -424, &
                  3968,   -496,  -1792,    224,  -1072,   -352,   4040,  -1072,  -1072,   3536,   3536,   -928,      8,     80, &
                    80,   -496,   -496,    224,     80,    800,   -496,   4112,   -424,   -352,   -496,   -424,    224,   -352, &
                  3536,   -928,   4112,   -352,   -352,   -928,   -928,   1088]
  K1( 362,:) = [  -4096,  32768,    512,   5120,  -4096,    512,    512,  -4096,    -64,   -640,    512,    -64,    -64,   -640, &
                  -640,   3968,   3968,  -1792,    512,    -64,   5120,   -640,   4544,   3968,    512,  -4096,    -64,   -640, &
                   512,    -64,    -64,    512,      8,     80,    -64,      8,      8,     80,     80,   -496,   -496,    224, &
                   -64,      8,   -640,     80,   -568,   -496,    -64,    512,      8,     80,    -64,      8,   -640,   5120, &
                    80,    800,   -640,     80,   -568,    152,   -496,   -424,  -1072,   -352,   4544,   -568,   3968,   -496, &
                  4040,   4112,      8,     80,     80,   -496,   -496,    224,     80,    800,   -496,   4112,   -424,   -352, &
                  -496,   -424,    224,   -352,   3536,   -928,   4112,   -352,   -352,   -928,   -928,   1088,    -64,      8, &
                  -640,     80,   -568,   -496,   -640,     80,   3968,   -496,    152,   -424,   3968,   -496,  -1792,    224, &
                 -1072,   -352,   4040,  -1072,  -1072,   3536,   3536,   -928]
  K1( 363,:) = [  -4096,    512,  32768,  -4096,   5120,    512,    512,    -64,   5120,   -640,   4544,   3968,  -4096,    512, &
                   512,    -64,    -64,   -640,   -640,    -64,   3968,  -1792,   -640,   3968,    512,    -64,  -4096,    512, &
                  -640,    -64,    -64,      8,   -640,     80,   -568,   -496,    512,    -64,    -64,      8,      8,     80, &
                    80,      8,   -496,    224,     80,   -496,    -64,      8,   -640,     80,   -568,   -496,   -640,     80, &
                  3968,   -496,    152,   -424,   3968,   -496,  -1792,    224,  -1072,   -352,   4040,  -1072,  -1072,   3536, &
                  3536,   -928,    512,    -64,    -64,      8,      8,     80,   5120,   -640,   -640,     80,     80,    800, &
                  4544,   -568,   3968,   -496,   4040,   4112,   -568,    152,   -496,   -424,  -1072,   -352,     80,      8, &
                  -496,    224,     80,   -496,    800,     80,   -424,   -352,   -496,   4112,   4112,   -352,   -352,   -928, &
                  -928,   1088,   -496,   -424,    224,   -352,   3536,   -928]
  K1( 364,:) = [    512,   5120,  -4096,  32768,    512,  -4096,    -64,   -640,   -640,   3968,   3968,  -1792,    512,  -4096, &
                   -64,   -640,    512,    -64,    -64,    512,   4544,   3968,   5120,   -640,    -64,   -640,    512,  -4096, &
                   -64,    512,      8,     80,     80,   -496,   -496,    224,    -64,    512,      8,     80,    -64,      8, &
                     8,    -64,   -568,   -496,   -640,     80,      8,     80,     80,   -496,   -496,    224,     80,    800, &
                  -496,   4112,   -424,   -352,   -496,   -424,    224,   -352,   3536,   -928,   4112,   -352,   -352,   -928, &
                  -928,   1088,    -64,    512,      8,     80,    -64,      8,   -640,   5120,     80,    800,   -640,     80, &
                  -568,    152,   -496,   -424,  -1072,   -352,   4544,   -568,   3968,   -496,   4040,   4112,      8,    -64, &
                  -568,   -496,   -640,     80,     80,   -640,    152,   -424,   3968,   -496,   4040,  -1072,  -1072,   3536, &
                  3536,   -928,   3968,   -496,  -1792,    224,  -1072,   -352]
  K1( 365,:) = [    512,  -4096,   5120,    512,  32768,  -4096,    -64,    512,   4544,   3968,   5120,   -640,   -640,    -64, &
                  3968,  -1792,   -640,   3968,  -4096,    512,    512,    -64,    -64,   -640,    -64,    512,   -640,    -64, &
                 -4096,    512,      8,    -64,   -568,   -496,   -640,     80,     80,      8,   -496,    224,     80,   -496, &
                   512,    -64,    -64,      8,      8,     80,      8,    -64,   -568,   -496,   -640,     80,     80,   -640, &
                   152,   -424,   3968,   -496,   4040,  -1072,  -1072,   3536,   3536,   -928,   3968,   -496,  -1792,    224, &
                 -1072,   -352,     80,      8,   -496,    224,     80,   -496,    800,     80,   -424,   -352,   -496,   4112, &
                  4112,   -352,   -352,   -928,   -928,   1088,   -496,   -424,    224,   -352,   3536,   -928,    512,    -64, &
                   -64,      8,      8,     80,   5120,   -640,   -640,     80,     80,    800,   4544,   -568,   3968,   -496, &
                  4040,   4112,   -568,    152,   -496,   -424,  -1072,   -352]
  K1( 366,:) = [   5120,    512,    512,  -4096,  -4096,  32768,   -640,    -64,   3968,  -1792,   -640,   3968,    -64,    512, &
                  4544,   3968,   5120,   -640,    512,  -4096,    -64,   -640,    512,    -64,   -640,    -64,    -64,    512, &
                   512,  -4096,     80,      8,   -496,    224,     80,   -496,      8,    -64,   -568,   -496,   -640,     80, &
                   -64,    512,      8,     80,    -64,      8,     80,      8,   -496,    224,     80,   -496,    800,     80, &
                  -424,   -352,   -496,   4112,   4112,   -352,   -352,   -928,   -928,   1088,   -496,   -424,    224,   -352, &
                  3536,   -928,      8,    -64,   -568,   -496,   -640,     80,     80,   -640,    152,   -424,   3968,   -496, &
                  4040,  -1072,  -1072,   3536,   3536,   -928,   3968,   -496,  -1792,    224,  -1072,   -352,    -64,    512, &
                     8,     80,    -64,      8,   -640,   5120,     80,    800,   -640,     80,   -568,    152,   -496,   -424, &
                 -1072,   -352,   4544,   -568,   3968,   -496,   4040,   4112]
  K1( 367,:) = [  -4096,    512,    512,    -64,    -64,   -640,  32768,  -4096,  -4096,    512,    512,   5120,   5120,   -640, &
                   512,    -64,   3968,   4544,   -640,   3968,    -64,   -640,  -1792,   3968,    512,    -64,    -64,      8, &
                     8,     80,   5120,   -640,   -640,     80,     80,    800,   4544,   -568,   3968,   -496,   4040,   4112, &
                  -568,    152,   -496,   -424,  -1072,   -352,  -4096,    512,    512,    -64,    -64,   -640,    512,    -64, &
                   -64,      8,      8,     80,    -64,      8,   -640,     80,   -568,   -496,      8,     80,     80,   -496, &
                  -496,    224,   -640,     80,    -64,      8,   -496,   -568,   3968,   -496,  -1792,    224,  -1072,   -352, &
                  -640,     80,   3968,   -496,    152,   -424,  -1072,   4040,   3536,   -928,  -1072,   3536,     80,   -496, &
                     8,     80,    224,   -496,   -496,   -424,    224,   -352,   3536,   -928,     80,    800,   -496,   4112, &
                  -424,   -352,   -352,   4112,   -928,   1088,   -352,   -928]
  K1( 368,:) = [    512,  -4096,    -64,   -640,    512,    -64,  -4096,  32768,    512,   5120,  -4096,    512,   -640,   3968, &
                   -64,   -640,  -1792,   3968,   5120,   -640,    512,    -64,   3968,   4544,    -64,    512,      8,     80, &
                   -64,      8,   -640,   5120,     80,    800,   -640,     80,   -568,    152,   -496,   -424,  -1072,   -352, &
                  4544,   -568,   3968,   -496,   4040,   4112,    512,  -4096,    -64,   -640,    512,    -64,    -64,    512, &
                     8,     80,    -64,      8,      8,     80,     80,   -496,   -496,    224,    -64,      8,   -640,     80, &
                  -568,   -496,     80,   -496,      8,     80,    224,   -496,   -496,   -424,    224,   -352,   3536,   -928, &
                    80,    800,   -496,   4112,   -424,   -352,   -352,   4112,   -928,   1088,   -352,   -928,   -640,     80, &
                   -64,      8,   -496,   -568,   3968,   -496,  -1792,    224,  -1072,   -352,   -640,     80,   3968,   -496, &
                   152,   -424,  -1072,   4040,   3536,   -928,  -1072,   3536]
  K1( 369,:) = [    512,    -64,   5120,   -640,   4544,   3968,  -4096,    512,  32768,  -4096,   5120,    512,    512,    -64, &
                 -4096,    512,   -640,    -64,   3968,  -1792,   -640,    -64,   3968,   -640,    -64,      8,   -640,     80, &
                  -568,   -496,   -640,     80,   3968,   -496,    152,   -424,   3968,   -496,  -1792,    224,  -1072,   -352, &
                  4040,  -1072,  -1072,   3536,   3536,   -928,    512,    -64,  -4096,    512,   -640,    -64,    -64,      8, &
                  -640,     80,   -568,   -496,    512,    -64,    -64,      8,      8,     80,     80,      8,   -496,    224, &
                    80,   -496,    -64,      8,    512,    -64,     80,      8,   4544,   -568,   3968,   -496,   4040,   4112, &
                  5120,   -640,   -640,     80,     80,    800,    152,   -568,  -1072,   -352,   -496,   -424,   -496,    224, &
                    80,      8,   -496,     80,   4112,   -352,   -352,   -928,   -928,   1088,    800,     80,   -424,   -352, &
                  -496,   4112,   -424,   -496,   3536,   -928,    224,   -352]
  K1( 370,:) = [    -64,   -640,   -640,   3968,   3968,  -1792,    512,   5120,  -4096,  32768,    512,  -4096,    -64,   -640, &
                   512,  -4096,    -64,    512,   4544,   3968,    -64,    512,   -640,   5120,      8,     80,     80,   -496, &
                  -496,    224,     80,    800,   -496,   4112,   -424,   -352,   -496,   -424,    224,   -352,   3536,   -928, &
                  4112,   -352,   -352,   -928,   -928,   1088,    -64,   -640,    512,  -4096,    -64,    512,      8,     80, &
                    80,   -496,   -496,    224,    -64,    512,      8,     80,    -64,      8,      8,    -64,   -568,   -496, &
                  -640,     80,      8,     80,    -64,    512,      8,    -64,   -568,    152,   -496,   -424,  -1072,   -352, &
                  -640,   5120,     80,    800,   -640,     80,   -568,   4544,   4040,   4112,   3968,   -496,   -568,   -496, &
                     8,    -64,     80,   -640,   4040,  -1072,  -1072,   3536,   3536,   -928,     80,   -640,    152,   -424, &
                  3968,   -496,   -496,   3968,  -1072,   -352,  -1792,    224]
  K1( 371,:) = [    -64,    512,   4544,   3968,   5120,   -640,    512,  -4096,   5120,    512,  32768,  -4096,   3968,  -1792, &
                  -640,    -64,   3968,   -640,    512,    -64,  -4096,    512,   -640,    -64,      8,    -64,   -568,   -496, &
                  -640,     80,     80,   -640,    152,   -424,   3968,   -496,   4040,  -1072,  -1072,   3536,   3536,   -928, &
                  3968,   -496,  -1792,    224,  -1072,   -352,    -64,    512,   -640,    -64,  -4096,    512,      8,    -64, &
                  -568,   -496,   -640,     80,     80,      8,   -496,    224,     80,   -496,    512,    -64,    -64,      8, &
                     8,     80,   -496,    224,     80,      8,   -496,     80,   4112,   -352,   -352,   -928,   -928,   1088, &
                   800,     80,   -424,   -352,   -496,   4112,   -424,   -496,   3536,   -928,    224,   -352,    -64,      8, &
                   512,    -64,     80,      8,   4544,   -568,   3968,   -496,   4040,   4112,   5120,   -640,   -640,     80, &
                    80,    800,    152,   -568,  -1072,   -352,   -496,   -424]
  K1( 372,:) = [   -640,    -64,   3968,  -1792,   -640,   3968,   5120,    512,    512,  -4096,  -4096,  32768,   4544,   3968, &
                   -64,    512,   -640,   5120,    -64,   -640,    512,  -4096,    -64,    512,     80,      8,   -496,    224, &
                    80,   -496,    800,     80,   -424,   -352,   -496,   4112,   4112,   -352,   -352,   -928,   -928,   1088, &
                  -496,   -424,    224,   -352,   3536,   -928,   -640,    -64,    -64,    512,    512,  -4096,     80,      8, &
                  -496,    224,     80,   -496,      8,    -64,   -568,   -496,   -640,     80,    -64,    512,      8,     80, &
                   -64,      8,   -568,   -496,      8,    -64,     80,   -640,   4040,  -1072,  -1072,   3536,   3536,   -928, &
                    80,   -640,    152,   -424,   3968,   -496,   -496,   3968,  -1072,   -352,  -1792,    224,      8,     80, &
                   -64,    512,      8,    -64,   -568,    152,   -496,   -424,  -1072,   -352,   -640,   5120,     80,    800, &
                  -640,     80,   -568,   4544,   4040,   4112,   3968,   -496]
  K1( 373,:) = [    512,    -64,  -4096,    512,   -640,    -64,   5120,   -640,    512,    -64,   3968,   4544,  32768,  -4096, &
                 -4096,    512,    512,   5120,   3968,   -640,  -1792,   3968,    -64,   -640,    -64,      8,    512,    -64, &
                    80,      8,   4544,   -568,   3968,   -496,   4040,   4112,   5120,   -640,   -640,     80,     80,    800, &
                   152,   -568,  -1072,   -352,   -496,   -424,   -640,     80,    -64,      8,   -496,   -568,   3968,   -496, &
                 -1792,    224,  -1072,   -352,   -640,     80,   3968,   -496,    152,   -424,  -1072,   4040,   3536,   -928, &
                 -1072,   3536,  -4096,    512,    512,    -64,    -64,   -640,    512,    -64,    -64,      8,      8,     80, &
                   -64,      8,   -640,     80,   -568,   -496,      8,     80,     80,   -496,   -496,    224,   -496,     80, &
                   224,   -496,      8,     80,   -424,   -496,   3536,   -928,    224,   -352,   -352,   4112,   -928,   1088, &
                  -352,   -928,     80,    800,   -496,   4112,   -424,   -352]
  K1( 374,:) = [    -64,   -640,    512,  -4096,    -64,    512,   -640,   3968,    -64,   -640,  -1792,   3968,  -4096,  32768, &
                   512,   5120,  -4096,    512,   -640,   5120,   3968,   4544,    512,    -64,      8,     80,    -64,    512, &
                     8,    -64,   -568,    152,   -496,   -424,  -1072,   -352,   -640,   5120,     80,    800,   -640,     80, &
                  -568,   4544,   4040,   4112,   3968,   -496,     80,   -496,      8,     80,    224,   -496,   -496,   -424, &
                   224,   -352,   3536,   -928,     80,    800,   -496,   4112,   -424,   -352,   -352,   4112,   -928,   1088, &
                  -352,   -928,    512,  -4096,    -64,   -640,    512,    -64,    -64,    512,      8,     80,    -64,      8, &
                     8,     80,     80,   -496,   -496,    224,    -64,      8,   -640,     80,   -568,   -496,     80,   -640, &
                  -496,   -568,    -64,      8,   -496,   3968,  -1072,   -352,  -1792,    224,  -1072,   4040,   3536,   -928, &
                 -1072,   3536,   -640,     80,   3968,   -496,    152,   -424]
  K1( 375,:) = [   5120,   -640,    512,    -64,   3968,   4544,    512,    -64,  -4096,    512,   -640,    -64,  -4096,    512, &
                 32768,  -4096,   5120,    512,  -1792,   3968,   3968,   -640,   -640,    -64,   -640,     80,    -64,      8, &
                  -496,   -568,   3968,   -496,  -1792,    224,  -1072,   -352,   -640,     80,   3968,   -496,    152,   -424, &
                 -1072,   4040,   3536,   -928,  -1072,   3536,    -64,      8,    512,    -64,     80,      8,   4544,   -568, &
                  3968,   -496,   4040,   4112,   5120,   -640,   -640,     80,     80,    800,    152,   -568,  -1072,   -352, &
                  -496,   -424,    512,    -64,  -4096,    512,   -640,    -64,    -64,      8,   -640,     80,   -568,   -496, &
                   512,    -64,    -64,      8,      8,     80,     80,      8,   -496,    224,     80,   -496,    224,   -496, &
                  -496,     80,     80,      8,   -352,   4112,   -928,   1088,   -352,   -928,   -424,   -496,   3536,   -928, &
                   224,   -352,    800,     80,   -424,   -352,   -496,   4112]
  K1( 376,:) = [   -640,   3968,    -64,   -640,  -1792,   3968,    -64,   -640,    512,  -4096,    -64,    512,    512,   5120, &
                 -4096,  32768,    512,  -4096,   3968,   4544,   -640,   5120,    -64,    512,     80,   -496,      8,     80, &
                   224,   -496,   -496,   -424,    224,   -352,   3536,   -928,     80,    800,   -496,   4112,   -424,   -352, &
                  -352,   4112,   -928,   1088,   -352,   -928,      8,     80,    -64,    512,      8,    -64,   -568,    152, &
                  -496,   -424,  -1072,   -352,   -640,   5120,     80,    800,   -640,     80,   -568,   4544,   4040,   4112, &
                  3968,   -496,    -64,   -640,    512,  -4096,    -64,    512,      8,     80,     80,   -496,   -496,    224, &
                   -64,    512,      8,     80,    -64,      8,      8,    -64,   -568,   -496,   -640,     80,   -496,   -568, &
                    80,   -640,      8,    -64,  -1072,   4040,   3536,   -928,  -1072,   3536,   -496,   3968,  -1072,   -352, &
                 -1792,    224,     80,   -640,    152,   -424,   3968,   -496]
  K1( 377,:) = [   4544,   3968,    -64,    512,   -640,   5120,   3968,  -1792,   -640,    -64,   3968,   -640,    512,  -4096, &
                  5120,    512,  32768,  -4096,    -64,    512,   -640,    -64,  -4096,    512,   -568,   -496,      8,    -64, &
                    80,   -640,   4040,  -1072,  -1072,   3536,   3536,   -928,     80,   -640,    152,   -424,   3968,   -496, &
                  -496,   3968,  -1072,   -352,  -1792,    224,   -496,    224,     80,      8,   -496,     80,   4112,   -352, &
                  -352,   -928,   -928,   1088,    800,     80,   -424,   -352,   -496,   4112,   -424,   -496,   3536,   -928, &
                   224,   -352,    -64,    512,   -640,    -64,  -4096,    512,      8,    -64,   -568,   -496,   -640,     80, &
                    80,      8,   -496,    224,     80,   -496,    512,    -64,    -64,      8,      8,     80,      8,    -64, &
                    80,      8,    512,    -64,   -568,   4544,   4040,   4112,   3968,   -496,    152,   -568,  -1072,   -352, &
                  -496,   -424,   5120,   -640,   -640,     80,     80,    800]
  K1( 378,:) = [   3968,  -1792,   -640,    -64,   3968,   -640,   4544,   3968,    -64,    512,   -640,   5120,   5120,    512, &
                   512,  -4096,  -4096,  32768,   -640,    -64,    -64,    512,    512,  -4096,   -496,    224,     80,      8, &
                  -496,     80,   4112,   -352,   -352,   -928,   -928,   1088,    800,     80,   -424,   -352,   -496,   4112, &
                  -424,   -496,   3536,   -928,    224,   -352,   -568,   -496,      8,    -64,     80,   -640,   4040,  -1072, &
                 -1072,   3536,   3536,   -928,     80,   -640,    152,   -424,   3968,   -496,   -496,   3968,  -1072,   -352, &
                 -1792,    224,   -640,    -64,    -64,    512,    512,  -4096,     80,      8,   -496,    224,     80,   -496, &
                     8,    -64,   -568,   -496,   -640,     80,    -64,    512,      8,     80,    -64,      8,     80,      8, &
                     8,    -64,    -64,    512,    152,   -568,  -1072,   -352,   -496,   -424,   -568,   4544,   4040,   4112, &
                  3968,   -496,   -640,   5120,     80,    800,   -640,     80]
  K1( 379,:) = [    -64,    512,   -640,    -64,  -4096,    512,   -640,   5120,   3968,   4544,    512,    -64,   3968,   -640, &
                 -1792,   3968,    -64,   -640,  32768,  -4096,  -4096,    512,    512,   5120,      8,    -64,     80,      8, &
                   512,    -64,   -568,   4544,   4040,   4112,   3968,   -496,    152,   -568,  -1072,   -352,   -496,   -424, &
                  5120,   -640,   -640,     80,     80,    800,     80,   -640,   -496,   -568,    -64,      8,   -496,   3968, &
                 -1072,   -352,  -1792,    224,  -1072,   4040,   3536,   -928,  -1072,   3536,   -640,     80,   3968,   -496, &
                   152,   -424,   -496,     80,    224,   -496,      8,     80,   -424,   -496,   3536,   -928,    224,   -352, &
                  -352,   4112,   -928,   1088,   -352,   -928,     80,    800,   -496,   4112,   -424,   -352,  -4096,    512, &
                   512,    -64,    -64,   -640,    512,    -64,    -64,      8,      8,     80,    -64,      8,   -640,     80, &
                  -568,   -496,      8,     80,     80,   -496,   -496,    224]
  K1( 380,:) = [   -640,    -64,    -64,    512,    512,  -4096,   3968,   -640,  -1792,   3968,    -64,   -640,   -640,   5120, &
                  3968,   4544,    512,    -64,  -4096,  32768,    512,   5120,  -4096,    512,     80,      8,      8,    -64, &
                   -64,    512,    152,   -568,  -1072,   -352,   -496,   -424,   -568,   4544,   4040,   4112,   3968,   -496, &
                  -640,   5120,     80,    800,   -640,     80,   -496,     80,    224,   -496,      8,     80,   -424,   -496, &
                  3536,   -928,    224,   -352,   -352,   4112,   -928,   1088,   -352,   -928,     80,    800,   -496,   4112, &
                  -424,   -352,     80,   -640,   -496,   -568,    -64,      8,   -496,   3968,  -1072,   -352,  -1792,    224, &
                 -1072,   4040,   3536,   -928,  -1072,   3536,   -640,     80,   3968,   -496,    152,   -424,    512,  -4096, &
                   -64,   -640,    512,    -64,    -64,    512,      8,     80,    -64,      8,      8,     80,     80,   -496, &
                  -496,    224,    -64,      8,   -640,     80,   -568,   -496]
  K1( 381,:) = [   -640,   5120,   3968,   4544,    512,    -64,    -64,    512,   -640,    -64,  -4096,    512,  -1792,   3968, &
                  3968,   -640,   -640,    -64,  -4096,    512,  32768,  -4096,   5120,    512,     80,   -640,   -496,   -568, &
                   -64,      8,   -496,   3968,  -1072,   -352,  -1792,    224,  -1072,   4040,   3536,   -928,  -1072,   3536, &
                  -640,     80,   3968,   -496,    152,   -424,      8,    -64,     80,      8,    512,    -64,   -568,   4544, &
                  4040,   4112,   3968,   -496,    152,   -568,  -1072,   -352,   -496,   -424,   5120,   -640,   -640,     80, &
                    80,    800,    224,   -496,   -496,     80,     80,      8,   -352,   4112,   -928,   1088,   -352,   -928, &
                  -424,   -496,   3536,   -928,    224,   -352,    800,     80,   -424,   -352,   -496,   4112,    512,    -64, &
                 -4096,    512,   -640,    -64,    -64,      8,   -640,     80,   -568,   -496,    512,    -64,    -64,      8, &
                     8,     80,     80,      8,   -496,    224,     80,   -496]
  K1( 382,:) = [   3968,   -640,  -1792,   3968,    -64,   -640,   -640,    -64,    -64,    512,    512,  -4096,   3968,   4544, &
                  -640,   5120,    -64,    512,    512,   5120,  -4096,  32768,    512,  -4096,   -496,     80,    224,   -496, &
                     8,     80,   -424,   -496,   3536,   -928,    224,   -352,   -352,   4112,   -928,   1088,   -352,   -928, &
                    80,    800,   -496,   4112,   -424,   -352,     80,      8,      8,    -64,    -64,    512,    152,   -568, &
                 -1072,   -352,   -496,   -424,   -568,   4544,   4040,   4112,   3968,   -496,   -640,   5120,     80,    800, &
                  -640,     80,   -496,   -568,     80,   -640,      8,    -64,  -1072,   4040,   3536,   -928,  -1072,   3536, &
                  -496,   3968,  -1072,   -352,  -1792,    224,     80,   -640,    152,   -424,   3968,   -496,    -64,   -640, &
                   512,  -4096,    -64,    512,      8,     80,     80,   -496,   -496,    224,    -64,    512,      8,     80, &
                   -64,      8,      8,    -64,   -568,   -496,   -640,     80]
  K1( 383,:) = [   3968,   4544,   -640,   5120,    -64,    512,  -1792,   3968,   3968,   -640,   -640,    -64,    -64,    512, &
                  -640,    -64,  -4096,    512,    512,  -4096,   5120,    512,  32768,  -4096,   -496,   -568,     80,   -640, &
                     8,    -64,  -1072,   4040,   3536,   -928,  -1072,   3536,   -496,   3968,  -1072,   -352,  -1792,    224, &
                    80,   -640,    152,   -424,   3968,   -496,    224,   -496,   -496,     80,     80,      8,   -352,   4112, &
                  -928,   1088,   -352,   -928,   -424,   -496,   3536,   -928,    224,   -352,    800,     80,   -424,   -352, &
                  -496,   4112,      8,    -64,     80,      8,    512,    -64,   -568,   4544,   4040,   4112,   3968,   -496, &
                   152,   -568,  -1072,   -352,   -496,   -424,   5120,   -640,   -640,     80,     80,    800,    -64,    512, &
                  -640,    -64,  -4096,    512,      8,    -64,   -568,   -496,   -640,     80,     80,      8,   -496,    224, &
                    80,   -496,    512,    -64,    -64,      8,      8,     80]
  K1( 384,:) = [  -1792,   3968,   3968,   -640,   -640,    -64,   3968,   4544,   -640,   5120,    -64,    512,   -640,    -64, &
                   -64,    512,    512,  -4096,   5120,    512,    512,  -4096,  -4096,  32768,    224,   -496,   -496,     80, &
                    80,      8,   -352,   4112,   -928,   1088,   -352,   -928,   -424,   -496,   3536,   -928,    224,   -352, &
                   800,     80,   -424,   -352,   -496,   4112,   -496,   -568,     80,   -640,      8,    -64,  -1072,   4040, &
                  3536,   -928,  -1072,   3536,   -496,   3968,  -1072,   -352,  -1792,    224,     80,   -640,    152,   -424, &
                  3968,   -496,     80,      8,      8,    -64,    -64,    512,    152,   -568,  -1072,   -352,   -496,   -424, &
                  -568,   4544,   4040,   4112,   3968,   -496,   -640,   5120,     80,    800,   -640,     80,   -640,    -64, &
                   -64,    512,    512,  -4096,     80,      8,   -496,    224,     80,   -496,      8,    -64,   -568,   -496, &
                  -640,     80,    -64,    512,      8,     80,    -64,      8]
  K1( 385,:) = [  -4096,    512,    512,    -64,    -64,   -640,    512,    -64,    -64,      8,      8,     80,    -64,      8, &
                  -640,     80,   -568,   -496,      8,     80,     80,   -496,   -496,    224,  32768,  -4096,  -4096,    512, &
                   512,   5120,  -4096,    512,    512,    -64,    -64,   -640,    512,    -64,   5120,   -640,   4544,   3968, &
                   -64,   -640,   -640,   3968,   3968,  -1792,   5120,   -640,   -640,     80,     80,    800,    512,    -64, &
                   -64,      8,      8,     80,   3968,   -496,   4544,   -568,   4112,   4040,   -496,   -424,   -568,    152, &
                  -352,  -1072,   -640,     80,   3968,   -496,    152,   -424,    -64,      8,   -640,     80,   -568,   -496, &
                 -1792,    224,   3968,   -496,   -352,  -1072,  -1072,   3536,   4040,  -1072,   -928,   3536,     80,    800, &
                  -496,   4112,   -424,   -352,      8,     80,     80,   -496,   -496,    224,    224,   -352,   -496,   -424, &
                  -928,   3536,   -352,   -928,   4112,   -352,   1088,   -928]
  K1( 386,:) = [    512,  -4096,    -64,   -640,    512,    -64,    -64,    512,      8,     80,    -64,      8,      8,     80, &
                    80,   -496,   -496,    224,    -64,      8,   -640,     80,   -568,   -496,  -4096,  32768,    512,   5120, &
                 -4096,    512,    512,  -4096,    -64,   -640,    512,    -64,    -64,   -640,   -640,   3968,   3968,  -1792, &
                   512,    -64,   5120,   -640,   4544,   3968,   -640,   5120,     80,    800,   -640,     80,    -64,    512, &
                     8,     80,    -64,      8,   -496,   -424,   -568,    152,   -352,  -1072,   3968,   -496,   4544,   -568, &
                  4112,   4040,     80,    800,   -496,   4112,   -424,   -352,      8,     80,     80,   -496,   -496,    224, &
                   224,   -352,   -496,   -424,   -928,   3536,   -352,   -928,   4112,   -352,   1088,   -928,   -640,     80, &
                  3968,   -496,    152,   -424,    -64,      8,   -640,     80,   -568,   -496,  -1792,    224,   3968,   -496, &
                  -352,  -1072,  -1072,   3536,   4040,  -1072,   -928,   3536]
  K1( 387,:) = [    512,    -64,  -4096,    512,   -640,    -64,    -64,      8,   -640,     80,   -568,   -496,    512,    -64, &
                   -64,      8,      8,     80,     80,      8,   -496,    224,     80,   -496,  -4096,    512,  32768,  -4096, &
                  5120,    512,    512,    -64,   5120,   -640,   4544,   3968,  -4096,    512,    512,    -64,    -64,   -640, &
                  -640,    -64,   3968,  -1792,   -640,   3968,   -640,     80,   3968,   -496,    152,   -424,    -64,      8, &
                  -640,     80,   -568,   -496,  -1792,    224,   3968,   -496,   -352,  -1072,  -1072,   3536,   4040,  -1072, &
                  -928,   3536,   5120,   -640,   -640,     80,     80,    800,    512,    -64,    -64,      8,      8,     80, &
                  3968,   -496,   4544,   -568,   4112,   4040,   -496,   -424,   -568,    152,   -352,  -1072,    800,     80, &
                  -424,   -352,   -496,   4112,     80,      8,   -496,    224,     80,   -496,   -352,   -928,   4112,   -352, &
                  1088,   -928,    224,   -352,   -496,   -424,   -928,   3536]
  K1( 388,:) = [    -64,   -640,    512,  -4096,    -64,    512,      8,     80,     80,   -496,   -496,    224,    -64,    512, &
                     8,     80,    -64,      8,      8,    -64,   -568,   -496,   -640,     80,    512,   5120,  -4096,  32768, &
                   512,  -4096,    -64,   -640,   -640,   3968,   3968,  -1792,    512,  -4096,    -64,   -640,    512,    -64, &
                   -64,    512,   4544,   3968,   5120,   -640,     80,    800,   -496,   4112,   -424,   -352,      8,     80, &
                    80,   -496,   -496,    224,    224,   -352,   -496,   -424,   -928,   3536,   -352,   -928,   4112,   -352, &
                  1088,   -928,   -640,   5120,     80,    800,   -640,     80,    -64,    512,      8,     80,    -64,      8, &
                  -496,   -424,   -568,    152,   -352,  -1072,   3968,   -496,   4544,   -568,   4112,   4040,     80,   -640, &
                   152,   -424,   3968,   -496,      8,    -64,   -568,   -496,   -640,     80,  -1072,   3536,   4040,  -1072, &
                  -928,   3536,  -1792,    224,   3968,   -496,   -352,  -1072]
  K1( 389,:) = [    -64,    512,   -640,    -64,  -4096,    512,      8,    -64,   -568,   -496,   -640,     80,     80,      8, &
                  -496,    224,     80,   -496,    512,    -64,    -64,      8,      8,     80,    512,  -4096,   5120,    512, &
                 32768,  -4096,    -64,    512,   4544,   3968,   5120,   -640,   -640,    -64,   3968,  -1792,   -640,   3968, &
                 -4096,    512,    512,    -64,    -64,   -640,     80,   -640,    152,   -424,   3968,   -496,      8,    -64, &
                  -568,   -496,   -640,     80,  -1072,   3536,   4040,  -1072,   -928,   3536,  -1792,    224,   3968,   -496, &
                  -352,  -1072,    800,     80,   -424,   -352,   -496,   4112,     80,      8,   -496,    224,     80,   -496, &
                  -352,   -928,   4112,   -352,   1088,   -928,    224,   -352,   -496,   -424,   -928,   3536,   5120,   -640, &
                  -640,     80,     80,    800,    512,    -64,    -64,      8,      8,     80,   3968,   -496,   4544,   -568, &
                  4112,   4040,   -496,   -424,   -568,    152,   -352,  -1072]
  K1( 390,:) = [   -640,    -64,    -64,    512,    512,  -4096,     80,      8,   -496,    224,     80,   -496,      8,    -64, &
                  -568,   -496,   -640,     80,    -64,    512,      8,     80,    -64,      8,   5120,    512,    512,  -4096, &
                 -4096,  32768,   -640,    -64,   3968,  -1792,   -640,   3968,    -64,    512,   4544,   3968,   5120,   -640, &
                   512,  -4096,    -64,   -640,    512,    -64,    800,     80,   -424,   -352,   -496,   4112,     80,      8, &
                  -496,    224,     80,   -496,   -352,   -928,   4112,   -352,   1088,   -928,    224,   -352,   -496,   -424, &
                  -928,   3536,     80,   -640,    152,   -424,   3968,   -496,      8,    -64,   -568,   -496,   -640,     80, &
                 -1072,   3536,   4040,  -1072,   -928,   3536,  -1792,    224,   3968,   -496,   -352,  -1072,   -640,   5120, &
                    80,    800,   -640,     80,    -64,    512,      8,     80,    -64,      8,   -496,   -424,   -568,    152, &
                  -352,  -1072,   3968,   -496,   4544,   -568,   4112,   4040]
  K1( 391,:) = [    512,    -64,    -64,      8,      8,     80,   5120,   -640,   -640,     80,     80,    800,   4544,   -568, &
                  3968,   -496,   4040,   4112,   -568,    152,   -496,   -424,  -1072,   -352,  -4096,    512,    512,    -64, &
                   -64,   -640,  32768,  -4096,  -4096,    512,    512,   5120,   5120,   -640,    512,    -64,   3968,   4544, &
                  -640,   3968,    -64,   -640,  -1792,   3968,    512,    -64,    -64,      8,      8,     80,  -4096,    512, &
                   512,    -64,    -64,   -640,   -640,     80,    -64,      8,   -496,   -568,     80,   -496,      8,     80, &
                   224,   -496,   3968,   -496,  -1792,    224,  -1072,   -352,   -640,     80,    -64,      8,   -496,   -568, &
                  3968,   -496,   -640,     80,   -424,    152,   3536,   -928,  -1072,   4040,   3536,  -1072,   -496,   -424, &
                   224,   -352,   3536,   -928,     80,   -496,      8,     80,    224,   -496,   -496,   4112,     80,    800, &
                  -352,   -424,   -928,   1088,   -352,   4112,   -928,   -352]
  K1( 392,:) = [    -64,    512,      8,     80,    -64,      8,   -640,   5120,     80,    800,   -640,     80,   -568,    152, &
                  -496,   -424,  -1072,   -352,   4544,   -568,   3968,   -496,   4040,   4112,    512,  -4096,    -64,   -640, &
                   512,    -64,  -4096,  32768,    512,   5120,  -4096,    512,   -640,   3968,    -64,   -640,  -1792,   3968, &
                  5120,   -640,    512,    -64,   3968,   4544,    -64,    512,      8,     80,    -64,      8,    512,  -4096, &
                   -64,   -640,    512,    -64,     80,   -496,      8,     80,    224,   -496,   -640,     80,    -64,      8, &
                  -496,   -568,   -496,   -424,    224,   -352,   3536,   -928,     80,   -496,      8,     80,    224,   -496, &
                  -496,   4112,     80,    800,   -352,   -424,   -928,   1088,   -352,   4112,   -928,   -352,   3968,   -496, &
                 -1792,    224,  -1072,   -352,   -640,     80,    -64,      8,   -496,   -568,   3968,   -496,   -640,     80, &
                  -424,    152,   3536,   -928,  -1072,   4040,   3536,  -1072]
  K1( 393,:) = [    -64,      8,   -640,     80,   -568,   -496,   -640,     80,   3968,   -496,    152,   -424,   3968,   -496, &
                 -1792,    224,  -1072,   -352,   4040,  -1072,  -1072,   3536,   3536,   -928,    512,    -64,   5120,   -640, &
                  4544,   3968,  -4096,    512,  32768,  -4096,   5120,    512,    512,    -64,  -4096,    512,   -640,    -64, &
                  3968,  -1792,   -640,    -64,   3968,   -640,    -64,      8,   -640,     80,   -568,   -496,    512,    -64, &
                 -4096,    512,   -640,    -64,    -64,      8,    512,    -64,     80,      8,   -496,    224,     80,      8, &
                  -496,     80,   4544,   -568,   3968,   -496,   4040,   4112,    -64,      8,    512,    -64,     80,      8, &
                  -640,     80,   5120,   -640,    800,     80,  -1072,   -352,    152,   -568,   -424,   -496,   4112,   -352, &
                  -352,   -928,   -928,   1088,   -496,    224,     80,      8,   -496,     80,   -424,   -352,    800,     80, &
                  4112,   -496,   3536,   -928,   -424,   -496,   -352,    224]
  K1( 394,:) = [      8,     80,     80,   -496,   -496,    224,     80,    800,   -496,   4112,   -424,   -352,   -496,   -424, &
                   224,   -352,   3536,   -928,   4112,   -352,   -352,   -928,   -928,   1088,    -64,   -640,   -640,   3968, &
                  3968,  -1792,    512,   5120,  -4096,  32768,    512,  -4096,    -64,   -640,    512,  -4096,    -64,    512, &
                  4544,   3968,    -64,    512,   -640,   5120,      8,     80,     80,   -496,   -496,    224,    -64,   -640, &
                   512,  -4096,    -64,    512,      8,     80,    -64,    512,      8,    -64,   -568,   -496,      8,    -64, &
                    80,   -640,   -568,    152,   -496,   -424,  -1072,   -352,      8,     80,    -64,    512,      8,    -64, &
                    80,    800,   -640,   5120,     80,   -640,   4040,   4112,   -568,   4544,   -496,   3968,   4040,  -1072, &
                 -1072,   3536,   3536,   -928,   -568,   -496,      8,    -64,     80,   -640,    152,   -424,     80,   -640, &
                  -496,   3968,  -1072,   -352,   -496,   3968,    224,  -1792]
  K1( 395,:) = [      8,    -64,   -568,   -496,   -640,     80,     80,   -640,    152,   -424,   3968,   -496,   4040,  -1072, &
                 -1072,   3536,   3536,   -928,   3968,   -496,  -1792,    224,  -1072,   -352,    -64,    512,   4544,   3968, &
                  5120,   -640,    512,  -4096,   5120,    512,  32768,  -4096,   3968,  -1792,   -640,    -64,   3968,   -640, &
                   512,    -64,  -4096,    512,   -640,    -64,      8,    -64,   -568,   -496,   -640,     80,    -64,    512, &
                  -640,    -64,  -4096,    512,   -496,    224,     80,      8,   -496,     80,    -64,      8,    512,    -64, &
                    80,      8,   4112,   -352,   -352,   -928,   -928,   1088,   -496,    224,     80,      8,   -496,     80, &
                  -424,   -352,    800,     80,   4112,   -496,   3536,   -928,   -424,   -496,   -352,    224,   4544,   -568, &
                  3968,   -496,   4040,   4112,    -64,      8,    512,    -64,     80,      8,   -640,     80,   5120,   -640, &
                   800,     80,  -1072,   -352,    152,   -568,   -424,   -496]
  K1( 396,:) = [     80,      8,   -496,    224,     80,   -496,    800,     80,   -424,   -352,   -496,   4112,   4112,   -352, &
                  -352,   -928,   -928,   1088,   -496,   -424,    224,   -352,   3536,   -928,   -640,    -64,   3968,  -1792, &
                  -640,   3968,   5120,    512,    512,  -4096,  -4096,  32768,   4544,   3968,    -64,    512,   -640,   5120, &
                   -64,   -640,    512,  -4096,    -64,    512,     80,      8,   -496,    224,     80,   -496,   -640,    -64, &
                   -64,    512,    512,  -4096,   -568,   -496,      8,    -64,     80,   -640,      8,     80,    -64,    512, &
                     8,    -64,   4040,  -1072,  -1072,   3536,   3536,   -928,   -568,   -496,      8,    -64,     80,   -640, &
                   152,   -424,     80,   -640,   -496,   3968,  -1072,   -352,   -496,   3968,    224,  -1792,   -568,    152, &
                  -496,   -424,  -1072,   -352,      8,     80,    -64,    512,      8,    -64,     80,    800,   -640,   5120, &
                    80,   -640,   4040,   4112,   -568,   4544,   -496,   3968]
  K1( 397,:) = [    -64,      8,    512,    -64,     80,      8,   4544,   -568,   3968,   -496,   4040,   4112,   5120,   -640, &
                  -640,     80,     80,    800,    152,   -568,  -1072,   -352,   -496,   -424,    512,    -64,  -4096,    512, &
                  -640,    -64,   5120,   -640,    512,    -64,   3968,   4544,  32768,  -4096,  -4096,    512,    512,   5120, &
                  3968,   -640,  -1792,   3968,    -64,   -640,   3968,   -496,  -1792,    224,  -1072,   -352,   -640,     80, &
                   -64,      8,   -496,   -568,   3968,   -496,   -640,     80,   -424,    152,   3536,   -928,  -1072,   4040, &
                  3536,  -1072,    512,    -64,    -64,      8,      8,     80,  -4096,    512,    512,    -64,    -64,   -640, &
                  -640,     80,    -64,      8,   -496,   -568,     80,   -496,      8,     80,    224,   -496,   -424,   -496, &
                  3536,   -928,    224,   -352,   -496,     80,    224,   -496,      8,     80,   -928,   1088,   -352,   4112, &
                  -928,   -352,   -496,   4112,     80,    800,   -352,   -424]
  K1( 398,:) = [      8,     80,    -64,    512,      8,    -64,   -568,    152,   -496,   -424,  -1072,   -352,   -640,   5120, &
                    80,    800,   -640,     80,   -568,   4544,   4040,   4112,   3968,   -496,    -64,   -640,    512,  -4096, &
                   -64,    512,   -640,   3968,    -64,   -640,  -1792,   3968,  -4096,  32768,    512,   5120,  -4096,    512, &
                  -640,   5120,   3968,   4544,    512,    -64,   -496,   -424,    224,   -352,   3536,   -928,     80,   -496, &
                     8,     80,    224,   -496,   -496,   4112,     80,    800,   -352,   -424,   -928,   1088,   -352,   4112, &
                  -928,   -352,    -64,    512,      8,     80,    -64,      8,    512,  -4096,    -64,   -640,    512,    -64, &
                    80,   -496,      8,     80,    224,   -496,   -640,     80,    -64,      8,   -496,   -568,   -496,   3968, &
                 -1072,   -352,  -1792,    224,     80,   -640,   -496,   -568,    -64,      8,   3536,   -928,  -1072,   4040, &
                  3536,  -1072,   3968,   -496,   -640,     80,   -424,    152]
  K1( 399,:) = [   -640,     80,    -64,      8,   -496,   -568,   3968,   -496,  -1792,    224,  -1072,   -352,   -640,     80, &
                  3968,   -496,    152,   -424,  -1072,   4040,   3536,   -928,  -1072,   3536,   5120,   -640,    512,    -64, &
                  3968,   4544,    512,    -64,  -4096,    512,   -640,    -64,  -4096,    512,  32768,  -4096,   5120,    512, &
                 -1792,   3968,   3968,   -640,   -640,    -64,   4544,   -568,   3968,   -496,   4040,   4112,    -64,      8, &
                   512,    -64,     80,      8,   -640,     80,   5120,   -640,    800,     80,  -1072,   -352,    152,   -568, &
                  -424,   -496,    -64,      8,   -640,     80,   -568,   -496,    512,    -64,  -4096,    512,   -640,    -64, &
                   -64,      8,    512,    -64,     80,      8,   -496,    224,     80,      8,   -496,     80,   -352,   4112, &
                  -928,   1088,   -352,   -928,    224,   -496,   -496,     80,     80,      8,   3536,   -928,   -424,   -496, &
                  -352,    224,   -424,   -352,    800,     80,   4112,   -496]
  K1( 400,:) = [     80,   -496,      8,     80,    224,   -496,   -496,   -424,    224,   -352,   3536,   -928,     80,    800, &
                  -496,   4112,   -424,   -352,   -352,   4112,   -928,   1088,   -352,   -928,   -640,   3968,    -64,   -640, &
                 -1792,   3968,    -64,   -640,    512,  -4096,    -64,    512,    512,   5120,  -4096,  32768,    512,  -4096, &
                  3968,   4544,   -640,   5120,    -64,    512,   -568,    152,   -496,   -424,  -1072,   -352,      8,     80, &
                   -64,    512,      8,    -64,     80,    800,   -640,   5120,     80,   -640,   4040,   4112,   -568,   4544, &
                  -496,   3968,      8,     80,     80,   -496,   -496,    224,    -64,   -640,    512,  -4096,    -64,    512, &
                     8,     80,    -64,    512,      8,    -64,   -568,   -496,      8,    -64,     80,   -640,  -1072,   4040, &
                  3536,   -928,  -1072,   3536,   -496,   -568,     80,   -640,      8,    -64,  -1072,   -352,   -496,   3968, &
                   224,  -1792,    152,   -424,     80,   -640,   -496,   3968]
  K1( 401,:) = [   -568,   -496,      8,    -64,     80,   -640,   4040,  -1072,  -1072,   3536,   3536,   -928,     80,   -640, &
                   152,   -424,   3968,   -496,   -496,   3968,  -1072,   -352,  -1792,    224,   4544,   3968,    -64,    512, &
                  -640,   5120,   3968,  -1792,   -640,    -64,   3968,   -640,    512,  -4096,   5120,    512,  32768,  -4096, &
                   -64,    512,   -640,    -64,  -4096,    512,   4112,   -352,   -352,   -928,   -928,   1088,   -496,    224, &
                    80,      8,   -496,     80,   -424,   -352,    800,     80,   4112,   -496,   3536,   -928,   -424,   -496, &
                  -352,    224,      8,    -64,   -568,   -496,   -640,     80,    -64,    512,   -640,    -64,  -4096,    512, &
                  -496,    224,     80,      8,   -496,     80,    -64,      8,    512,    -64,     80,      8,   -568,   4544, &
                  4040,   4112,   3968,   -496,      8,    -64,     80,      8,    512,    -64,  -1072,   -352,    152,   -568, &
                  -424,   -496,   -640,     80,   5120,   -640,    800,     80]
  K1( 402,:) = [   -496,    224,     80,      8,   -496,     80,   4112,   -352,   -352,   -928,   -928,   1088,    800,     80, &
                  -424,   -352,   -496,   4112,   -424,   -496,   3536,   -928,    224,   -352,   3968,  -1792,   -640,    -64, &
                  3968,   -640,   4544,   3968,    -64,    512,   -640,   5120,   5120,    512,    512,  -4096,  -4096,  32768, &
                  -640,    -64,    -64,    512,    512,  -4096,   4040,  -1072,  -1072,   3536,   3536,   -928,   -568,   -496, &
                     8,    -64,     80,   -640,    152,   -424,     80,   -640,   -496,   3968,  -1072,   -352,   -496,   3968, &
                   224,  -1792,     80,      8,   -496,    224,     80,   -496,   -640,    -64,    -64,    512,    512,  -4096, &
                  -568,   -496,      8,    -64,     80,   -640,      8,     80,    -64,    512,      8,    -64,    152,   -568, &
                 -1072,   -352,   -496,   -424,     80,      8,      8,    -64,    -64,    512,   4040,   4112,   -568,   4544, &
                  -496,   3968,     80,    800,   -640,   5120,     80,   -640]
  K1( 403,:) = [      8,    -64,     80,      8,    512,    -64,   -568,   4544,   4040,   4112,   3968,   -496,    152,   -568, &
                 -1072,   -352,   -496,   -424,   5120,   -640,   -640,     80,     80,    800,    -64,    512,   -640,    -64, &
                 -4096,    512,   -640,   5120,   3968,   4544,    512,    -64,   3968,   -640,  -1792,   3968,    -64,   -640, &
                 32768,  -4096,  -4096,    512,    512,   5120,   -496,   3968,  -1072,   -352,  -1792,    224,     80,   -640, &
                  -496,   -568,    -64,      8,   3536,   -928,  -1072,   4040,   3536,  -1072,   3968,   -496,   -640,     80, &
                  -424,    152,   -424,   -496,   3536,   -928,    224,   -352,   -496,     80,    224,   -496,      8,     80, &
                  -928,   1088,   -352,   4112,   -928,   -352,   -496,   4112,     80,    800,   -352,   -424,    512,    -64, &
                   -64,      8,      8,     80,  -4096,    512,    512,    -64,    -64,   -640,   -640,     80,    -64,      8, &
                  -496,   -568,     80,   -496,      8,     80,    224,   -496]
  K1( 404,:) = [     80,      8,      8,    -64,    -64,    512,    152,   -568,  -1072,   -352,   -496,   -424,   -568,   4544, &
                  4040,   4112,   3968,   -496,   -640,   5120,     80,    800,   -640,     80,   -640,    -64,    -64,    512, &
                   512,  -4096,   3968,   -640,  -1792,   3968,    -64,   -640,   -640,   5120,   3968,   4544,    512,    -64, &
                 -4096,  32768,    512,   5120,  -4096,    512,   -424,   -496,   3536,   -928,    224,   -352,   -496,     80, &
                   224,   -496,      8,     80,   -928,   1088,   -352,   4112,   -928,   -352,   -496,   4112,     80,    800, &
                  -352,   -424,   -496,   3968,  -1072,   -352,  -1792,    224,     80,   -640,   -496,   -568,    -64,      8, &
                  3536,   -928,  -1072,   4040,   3536,  -1072,   3968,   -496,   -640,     80,   -424,    152,    -64,    512, &
                     8,     80,    -64,      8,    512,  -4096,    -64,   -640,    512,    -64,     80,   -496,      8,     80, &
                   224,   -496,   -640,     80,    -64,      8,   -496,   -568]
  K1( 405,:) = [     80,   -640,   -496,   -568,    -64,      8,   -496,   3968,  -1072,   -352,  -1792,    224,  -1072,   4040, &
                  3536,   -928,  -1072,   3536,   -640,     80,   3968,   -496,    152,   -424,   -640,   5120,   3968,   4544, &
                   512,    -64,    -64,    512,   -640,    -64,  -4096,    512,  -1792,   3968,   3968,   -640,   -640,    -64, &
                 -4096,    512,  32768,  -4096,   5120,    512,   -568,   4544,   4040,   4112,   3968,   -496,      8,    -64, &
                    80,      8,    512,    -64,  -1072,   -352,    152,   -568,   -424,   -496,   -640,     80,   5120,   -640, &
                   800,     80,   -352,   4112,   -928,   1088,   -352,   -928,    224,   -496,   -496,     80,     80,      8, &
                  3536,   -928,   -424,   -496,   -352,    224,   -424,   -352,    800,     80,   4112,   -496,    -64,      8, &
                  -640,     80,   -568,   -496,    512,    -64,  -4096,    512,   -640,    -64,    -64,      8,    512,    -64, &
                    80,      8,   -496,    224,     80,      8,   -496,     80]
  K1( 406,:) = [   -496,     80,    224,   -496,      8,     80,   -424,   -496,   3536,   -928,    224,   -352,   -352,   4112, &
                  -928,   1088,   -352,   -928,     80,    800,   -496,   4112,   -424,   -352,   3968,   -640,  -1792,   3968, &
                   -64,   -640,   -640,    -64,    -64,    512,    512,  -4096,   3968,   4544,   -640,   5120,    -64,    512, &
                   512,   5120,  -4096,  32768,    512,  -4096,    152,   -568,  -1072,   -352,   -496,   -424,     80,      8, &
                     8,    -64,    -64,    512,   4040,   4112,   -568,   4544,   -496,   3968,     80,    800,   -640,   5120, &
                    80,   -640,  -1072,   4040,   3536,   -928,  -1072,   3536,   -496,   -568,     80,   -640,      8,    -64, &
                 -1072,   -352,   -496,   3968,    224,  -1792,    152,   -424,     80,   -640,   -496,   3968,      8,     80, &
                    80,   -496,   -496,    224,    -64,   -640,    512,  -4096,    -64,    512,      8,     80,    -64,    512, &
                     8,    -64,   -568,   -496,      8,    -64,     80,   -640]
  K1( 407,:) = [   -496,   -568,     80,   -640,      8,    -64,  -1072,   4040,   3536,   -928,  -1072,   3536,   -496,   3968, &
                 -1072,   -352,  -1792,    224,     80,   -640,    152,   -424,   3968,   -496,   3968,   4544,   -640,   5120, &
                   -64,    512,  -1792,   3968,   3968,   -640,   -640,    -64,    -64,    512,   -640,    -64,  -4096,    512, &
                   512,  -4096,   5120,    512,  32768,  -4096,   -352,   4112,   -928,   1088,   -352,   -928,    224,   -496, &
                  -496,     80,     80,      8,   3536,   -928,   -424,   -496,   -352,    224,   -424,   -352,    800,     80, &
                  4112,   -496,   -568,   4544,   4040,   4112,   3968,   -496,      8,    -64,     80,      8,    512,    -64, &
                 -1072,   -352,    152,   -568,   -424,   -496,   -640,     80,   5120,   -640,    800,     80,      8,    -64, &
                  -568,   -496,   -640,     80,    -64,    512,   -640,    -64,  -4096,    512,   -496,    224,     80,      8, &
                  -496,     80,    -64,      8,    512,    -64,     80,      8]
  K1( 408,:) = [    224,   -496,   -496,     80,     80,      8,   -352,   4112,   -928,   1088,   -352,   -928,   -424,   -496, &
                  3536,   -928,    224,   -352,    800,     80,   -424,   -352,   -496,   4112,  -1792,   3968,   3968,   -640, &
                  -640,    -64,   3968,   4544,   -640,   5120,    -64,    512,   -640,    -64,    -64,    512,    512,  -4096, &
                  5120,    512,    512,  -4096,  -4096,  32768,  -1072,   4040,   3536,   -928,  -1072,   3536,   -496,   -568, &
                    80,   -640,      8,    -64,  -1072,   -352,   -496,   3968,    224,  -1792,    152,   -424,     80,   -640, &
                  -496,   3968,    152,   -568,  -1072,   -352,   -496,   -424,     80,      8,      8,    -64,    -64,    512, &
                  4040,   4112,   -568,   4544,   -496,   3968,     80,    800,   -640,   5120,     80,   -640,     80,      8, &
                  -496,    224,     80,   -496,   -640,    -64,    -64,    512,    512,  -4096,   -568,   -496,      8,    -64, &
                    80,   -640,      8,     80,    -64,    512,      8,    -64]
  K1( 409,:) = [    512,    -64,    -64,      8,      8,     80,  -4096,    512,    512,    -64,    -64,   -640,   -640,     80, &
                   -64,      8,   -496,   -568,     80,   -496,      8,     80,    224,   -496,   5120,   -640,   -640,     80, &
                    80,    800,    512,    -64,    -64,      8,      8,     80,   3968,   -496,   4544,   -568,   4112,   4040, &
                  -496,   -424,   -568,    152,   -352,  -1072,  32768,  -4096,  -4096,    512,    512,   5120,  -4096,    512, &
                   512,    -64,    -64,   -640,    512,    -64,   5120,   -640,   4544,   3968,    -64,   -640,   -640,   3968, &
                  3968,  -1792,   3968,   -496,   -640,     80,   -424,    152,  -1792,    224,   3968,   -496,   -352,  -1072, &
                   -64,      8,   -640,     80,   -568,   -496,   3536,  -1072,   -928,   3536,   4040,  -1072,   -496,   4112, &
                    80,    800,   -352,   -424,    224,   -352,   -496,   -424,   -928,   3536,      8,     80,     80,   -496, &
                  -496,    224,   -928,   -352,   1088,   -928,   4112,   -352]
  K1( 410,:) = [    -64,    512,      8,     80,    -64,      8,    512,  -4096,    -64,   -640,    512,    -64,     80,   -496, &
                     8,     80,    224,   -496,   -640,     80,    -64,      8,   -496,   -568,   -640,   5120,     80,    800, &
                  -640,     80,    -64,    512,      8,     80,    -64,      8,   -496,   -424,   -568,    152,   -352,  -1072, &
                  3968,   -496,   4544,   -568,   4112,   4040,  -4096,  32768,    512,   5120,  -4096,    512,    512,  -4096, &
                   -64,   -640,    512,    -64,    -64,   -640,   -640,   3968,   3968,  -1792,    512,    -64,   5120,   -640, &
                  4544,   3968,   -496,   4112,     80,    800,   -352,   -424,    224,   -352,   -496,   -424,   -928,   3536, &
                     8,     80,     80,   -496,   -496,    224,   -928,   -352,   1088,   -928,   4112,   -352,   3968,   -496, &
                  -640,     80,   -424,    152,  -1792,    224,   3968,   -496,   -352,  -1072,    -64,      8,   -640,     80, &
                  -568,   -496,   3536,  -1072,   -928,   3536,   4040,  -1072]
  K1( 411,:) = [    -64,      8,   -640,     80,   -568,   -496,    512,    -64,  -4096,    512,   -640,    -64,    -64,      8, &
                   512,    -64,     80,      8,   -496,    224,     80,      8,   -496,     80,   -640,     80,   3968,   -496, &
                   152,   -424,    -64,      8,   -640,     80,   -568,   -496,  -1792,    224,   3968,   -496,   -352,  -1072, &
                 -1072,   3536,   4040,  -1072,   -928,   3536,  -4096,    512,  32768,  -4096,   5120,    512,    512,    -64, &
                  5120,   -640,   4544,   3968,  -4096,    512,    512,    -64,    -64,   -640,   -640,    -64,   3968,  -1792, &
                  -640,   3968,   -640,     80,   5120,   -640,    800,     80,   3968,   -496,   4544,   -568,   4112,   4040, &
                   512,    -64,    -64,      8,      8,     80,   -424,   -496,   -352,  -1072,   -568,    152,   -424,   -352, &
                   800,     80,   4112,   -496,   -352,   -928,   4112,   -352,   1088,   -928,     80,      8,   -496,    224, &
                    80,   -496,   -352,    224,   -928,   3536,   -496,   -424]
  K1( 412,:) = [      8,     80,     80,   -496,   -496,    224,    -64,   -640,    512,  -4096,    -64,    512,      8,     80, &
                   -64,    512,      8,    -64,   -568,   -496,      8,    -64,     80,   -640,     80,    800,   -496,   4112, &
                  -424,   -352,      8,     80,     80,   -496,   -496,    224,    224,   -352,   -496,   -424,   -928,   3536, &
                  -352,   -928,   4112,   -352,   1088,   -928,    512,   5120,  -4096,  32768,    512,  -4096,    -64,   -640, &
                  -640,   3968,   3968,  -1792,    512,  -4096,    -64,   -640,    512,    -64,    -64,    512,   4544,   3968, &
                  5120,   -640,     80,    800,   -640,   5120,     80,   -640,   -496,   -424,   -568,    152,   -352,  -1072, &
                   -64,    512,      8,     80,    -64,      8,   -496,   3968,   4112,   4040,   4544,   -568,    152,   -424, &
                    80,   -640,   -496,   3968,  -1072,   3536,   4040,  -1072,   -928,   3536,      8,    -64,   -568,   -496, &
                  -640,     80,    224,  -1792,   -352,  -1072,   3968,   -496]
  K1( 413,:) = [      8,    -64,   -568,   -496,   -640,     80,    -64,    512,   -640,    -64,  -4096,    512,   -496,    224, &
                    80,      8,   -496,     80,    -64,      8,    512,    -64,     80,      8,     80,   -640,    152,   -424, &
                  3968,   -496,      8,    -64,   -568,   -496,   -640,     80,  -1072,   3536,   4040,  -1072,   -928,   3536, &
                 -1792,    224,   3968,   -496,   -352,  -1072,    512,  -4096,   5120,    512,  32768,  -4096,    -64,    512, &
                  4544,   3968,   5120,   -640,   -640,    -64,   3968,  -1792,   -640,   3968,  -4096,    512,    512,    -64, &
                   -64,   -640,   -424,   -352,    800,     80,   4112,   -496,   -352,   -928,   4112,   -352,   1088,   -928, &
                    80,      8,   -496,    224,     80,   -496,   -352,    224,   -928,   3536,   -496,   -424,   -640,     80, &
                  5120,   -640,    800,     80,   3968,   -496,   4544,   -568,   4112,   4040,    512,    -64,    -64,      8, &
                     8,     80,   -424,   -496,   -352,  -1072,   -568,    152]
  K1( 414,:) = [     80,      8,   -496,    224,     80,   -496,   -640,    -64,    -64,    512,    512,  -4096,   -568,   -496, &
                     8,    -64,     80,   -640,      8,     80,    -64,    512,      8,    -64,    800,     80,   -424,   -352, &
                  -496,   4112,     80,      8,   -496,    224,     80,   -496,   -352,   -928,   4112,   -352,   1088,   -928, &
                   224,   -352,   -496,   -424,   -928,   3536,   5120,    512,    512,  -4096,  -4096,  32768,   -640,    -64, &
                  3968,  -1792,   -640,   3968,    -64,    512,   4544,   3968,   5120,   -640,    512,  -4096,    -64,   -640, &
                   512,    -64,    152,   -424,     80,   -640,   -496,   3968,  -1072,   3536,   4040,  -1072,   -928,   3536, &
                     8,    -64,   -568,   -496,   -640,     80,    224,  -1792,   -352,  -1072,   3968,   -496,     80,    800, &
                  -640,   5120,     80,   -640,   -496,   -424,   -568,    152,   -352,  -1072,    -64,    512,      8,     80, &
                   -64,      8,   -496,   3968,   4112,   4040,   4544,   -568]
  K1( 415,:) = [   5120,   -640,   -640,     80,     80,    800,    512,    -64,    -64,      8,      8,     80,   3968,   -496, &
                  4544,   -568,   4112,   4040,   -496,   -424,   -568,    152,   -352,  -1072,    512,    -64,    -64,      8, &
                     8,     80,  -4096,    512,    512,    -64,    -64,   -640,   -640,     80,    -64,      8,   -496,   -568, &
                    80,   -496,      8,     80,    224,   -496,  -4096,    512,    512,    -64,    -64,   -640,  32768,  -4096, &
                 -4096,    512,    512,   5120,   5120,   -640,    512,    -64,   3968,   4544,   -640,   3968,    -64,   -640, &
                 -1792,   3968,  -1792,    224,   3968,   -496,   -352,  -1072,   3968,   -496,   -640,     80,   -424,    152, &
                  -640,     80,    -64,      8,   -496,   -568,   -928,   3536,   3536,  -1072,  -1072,   4040,    224,   -352, &
                  -496,   -424,   -928,   3536,   -496,   4112,     80,    800,   -352,   -424,     80,   -496,      8,     80, &
                   224,   -496,   1088,   -928,   -928,   -352,   -352,   4112]
  K1( 416,:) = [   -640,   5120,     80,    800,   -640,     80,    -64,    512,      8,     80,    -64,      8,   -496,   -424, &
                  -568,    152,   -352,  -1072,   3968,   -496,   4544,   -568,   4112,   4040,    -64,    512,      8,     80, &
                   -64,      8,    512,  -4096,    -64,   -640,    512,    -64,     80,   -496,      8,     80,    224,   -496, &
                  -640,     80,    -64,      8,   -496,   -568,    512,  -4096,    -64,   -640,    512,    -64,  -4096,  32768, &
                   512,   5120,  -4096,    512,   -640,   3968,    -64,   -640,  -1792,   3968,   5120,   -640,    512,    -64, &
                  3968,   4544,    224,   -352,   -496,   -424,   -928,   3536,   -496,   4112,     80,    800,   -352,   -424, &
                    80,   -496,      8,     80,    224,   -496,   1088,   -928,   -928,   -352,   -352,   4112,  -1792,    224, &
                  3968,   -496,   -352,  -1072,   3968,   -496,   -640,     80,   -424,    152,   -640,     80,    -64,      8, &
                  -496,   -568,   -928,   3536,   3536,  -1072,  -1072,   4040]
  K1( 417,:) = [   -640,     80,   3968,   -496,    152,   -424,    -64,      8,   -640,     80,   -568,   -496,  -1792,    224, &
                  3968,   -496,   -352,  -1072,  -1072,   3536,   4040,  -1072,   -928,   3536,    -64,      8,   -640,     80, &
                  -568,   -496,    512,    -64,  -4096,    512,   -640,    -64,    -64,      8,    512,    -64,     80,      8, &
                  -496,    224,     80,      8,   -496,     80,    512,    -64,   5120,   -640,   4544,   3968,  -4096,    512, &
                 32768,  -4096,   5120,    512,    512,    -64,  -4096,    512,   -640,    -64,   3968,  -1792,   -640,    -64, &
                  3968,   -640,   3968,   -496,   4544,   -568,   4112,   4040,   -640,     80,   5120,   -640,    800,     80, &
                   -64,      8,    512,    -64,     80,      8,   -352,  -1072,   -424,   -496,    152,   -568,   -352,   -928, &
                  4112,   -352,   1088,   -928,   -424,   -352,    800,     80,   4112,   -496,   -496,    224,     80,      8, &
                  -496,     80,   -928,   3536,   -352,    224,   -424,   -496]
  K1( 418,:) = [     80,    800,   -496,   4112,   -424,   -352,      8,     80,     80,   -496,   -496,    224,    224,   -352, &
                  -496,   -424,   -928,   3536,   -352,   -928,   4112,   -352,   1088,   -928,      8,     80,     80,   -496, &
                  -496,    224,    -64,   -640,    512,  -4096,    -64,    512,      8,     80,    -64,    512,      8,    -64, &
                  -568,   -496,      8,    -64,     80,   -640,    -64,   -640,   -640,   3968,   3968,  -1792,    512,   5120, &
                 -4096,  32768,    512,  -4096,    -64,   -640,    512,  -4096,    -64,    512,   4544,   3968,    -64,    512, &
                  -640,   5120,   -496,   -424,   -568,    152,   -352,  -1072,     80,    800,   -640,   5120,     80,   -640, &
                     8,     80,    -64,    512,      8,    -64,   4112,   4040,   -496,   3968,   -568,   4544,  -1072,   3536, &
                  4040,  -1072,   -928,   3536,    152,   -424,     80,   -640,   -496,   3968,   -568,   -496,      8,    -64, &
                    80,   -640,   -352,  -1072,    224,  -1792,   -496,   3968]
  K1( 419,:) = [     80,   -640,    152,   -424,   3968,   -496,      8,    -64,   -568,   -496,   -640,     80,  -1072,   3536, &
                  4040,  -1072,   -928,   3536,  -1792,    224,   3968,   -496,   -352,  -1072,      8,    -64,   -568,   -496, &
                  -640,     80,    -64,    512,   -640,    -64,  -4096,    512,   -496,    224,     80,      8,   -496,     80, &
                   -64,      8,    512,    -64,     80,      8,    -64,    512,   4544,   3968,   5120,   -640,    512,  -4096, &
                  5120,    512,  32768,  -4096,   3968,  -1792,   -640,    -64,   3968,   -640,    512,    -64,  -4096,    512, &
                  -640,    -64,   -352,   -928,   4112,   -352,   1088,   -928,   -424,   -352,    800,     80,   4112,   -496, &
                  -496,    224,     80,      8,   -496,     80,   -928,   3536,   -352,    224,   -424,   -496,   3968,   -496, &
                  4544,   -568,   4112,   4040,   -640,     80,   5120,   -640,    800,     80,    -64,      8,    512,    -64, &
                    80,      8,   -352,  -1072,   -424,   -496,    152,   -568]
  K1( 420,:) = [    800,     80,   -424,   -352,   -496,   4112,     80,      8,   -496,    224,     80,   -496,   -352,   -928, &
                  4112,   -352,   1088,   -928,    224,   -352,   -496,   -424,   -928,   3536,     80,      8,   -496,    224, &
                    80,   -496,   -640,    -64,    -64,    512,    512,  -4096,   -568,   -496,      8,    -64,     80,   -640, &
                     8,     80,    -64,    512,      8,    -64,   -640,    -64,   3968,  -1792,   -640,   3968,   5120,    512, &
                   512,  -4096,  -4096,  32768,   4544,   3968,    -64,    512,   -640,   5120,    -64,   -640,    512,  -4096, &
                   -64,    512,  -1072,   3536,   4040,  -1072,   -928,   3536,    152,   -424,     80,   -640,   -496,   3968, &
                  -568,   -496,      8,    -64,     80,   -640,   -352,  -1072,    224,  -1792,   -496,   3968,   -496,   -424, &
                  -568,    152,   -352,  -1072,     80,    800,   -640,   5120,     80,   -640,      8,     80,    -64,    512, &
                     8,    -64,   4112,   4040,   -496,   3968,   -568,   4544]
  K1( 421,:) = [   4544,   -568,   3968,   -496,   4040,   4112,    -64,      8,    512,    -64,     80,      8,   -640,     80, &
                  5120,   -640,    800,     80,  -1072,   -352,    152,   -568,   -424,   -496,   3968,   -496,  -1792,    224, &
                 -1072,   -352,   -640,     80,    -64,      8,   -496,   -568,   3968,   -496,   -640,     80,   -424,    152, &
                  3536,   -928,  -1072,   4040,   3536,  -1072,    512,    -64,  -4096,    512,   -640,    -64,   5120,   -640, &
                   512,    -64,   3968,   4544,  32768,  -4096,  -4096,    512,    512,   5120,   3968,   -640,  -1792,   3968, &
                   -64,   -640,    -64,      8,    512,    -64,     80,      8,   -640,     80,    -64,      8,   -496,   -568, &
                 -4096,    512,    512,    -64,    -64,   -640,   -496,     80,    224,   -496,      8,     80,   3536,   -928, &
                  -424,   -496,   -352,    224,   -928,   1088,   -352,   4112,   -928,   -352,   -496,     80,    224,   -496, &
                     8,     80,   4112,   -496,   -352,   -424,     80,    800]
  K1( 422,:) = [   -568,    152,   -496,   -424,  -1072,   -352,      8,     80,    -64,    512,      8,    -64,     80,    800, &
                  -640,   5120,     80,   -640,   4040,   4112,   -568,   4544,   -496,   3968,   -496,   -424,    224,   -352, &
                  3536,   -928,     80,   -496,      8,     80,    224,   -496,   -496,   4112,     80,    800,   -352,   -424, &
                  -928,   1088,   -352,   4112,   -928,   -352,    -64,   -640,    512,  -4096,    -64,    512,   -640,   3968, &
                   -64,   -640,  -1792,   3968,  -4096,  32768,    512,   5120,  -4096,    512,   -640,   5120,   3968,   4544, &
                   512,    -64,      8,     80,    -64,    512,      8,    -64,     80,   -496,      8,     80,    224,   -496, &
                   512,  -4096,    -64,   -640,    512,    -64,     80,   -640,   -496,   -568,    -64,      8,  -1072,   -352, &
                  -496,   3968,    224,  -1792,   3536,   -928,  -1072,   4040,   3536,  -1072,     80,   -640,   -496,   -568, &
                   -64,      8,   -496,   3968,   -424,    152,   -640,     80]
  K1( 423,:) = [   3968,   -496,  -1792,    224,  -1072,   -352,   -640,     80,    -64,      8,   -496,   -568,   3968,   -496, &
                  -640,     80,   -424,    152,   3536,   -928,  -1072,   4040,   3536,  -1072,   4544,   -568,   3968,   -496, &
                  4040,   4112,    -64,      8,    512,    -64,     80,      8,   -640,     80,   5120,   -640,    800,     80, &
                 -1072,   -352,    152,   -568,   -424,   -496,   5120,   -640,    512,    -64,   3968,   4544,    512,    -64, &
                 -4096,    512,   -640,    -64,  -4096,    512,  32768,  -4096,   5120,    512,  -1792,   3968,   3968,   -640, &
                  -640,    -64,   -640,     80,    -64,      8,   -496,   -568,    -64,      8,    512,    -64,     80,      8, &
                   512,    -64,  -4096,    512,   -640,    -64,    224,   -496,   -496,     80,     80,      8,   -928,   1088, &
                  -352,   4112,   -928,   -352,   3536,   -928,   -424,   -496,   -352,    224,    224,   -496,   -496,     80, &
                    80,      8,   -352,   -424,   4112,   -496,    800,     80]
  K1( 424,:) = [   -496,   -424,    224,   -352,   3536,   -928,     80,   -496,      8,     80,    224,   -496,   -496,   4112, &
                    80,    800,   -352,   -424,   -928,   1088,   -352,   4112,   -928,   -352,   -568,    152,   -496,   -424, &
                 -1072,   -352,      8,     80,    -64,    512,      8,    -64,     80,    800,   -640,   5120,     80,   -640, &
                  4040,   4112,   -568,   4544,   -496,   3968,   -640,   3968,    -64,   -640,  -1792,   3968,    -64,   -640, &
                   512,  -4096,    -64,    512,    512,   5120,  -4096,  32768,    512,  -4096,   3968,   4544,   -640,   5120, &
                   -64,    512,     80,   -496,      8,     80,    224,   -496,      8,     80,    -64,    512,      8,    -64, &
                   -64,   -640,    512,  -4096,    -64,    512,   -496,   -568,     80,   -640,      8,    -64,   3536,   -928, &
                 -1072,   4040,   3536,  -1072,  -1072,   -352,   -496,   3968,    224,  -1792,   -496,   -568,     80,   -640, &
                     8,    -64,   -424,    152,   -496,   3968,     80,   -640]
  K1( 425,:) = [   4040,  -1072,  -1072,   3536,   3536,   -928,   -568,   -496,      8,    -64,     80,   -640,    152,   -424, &
                    80,   -640,   -496,   3968,  -1072,   -352,   -496,   3968,    224,  -1792,   4112,   -352,   -352,   -928, &
                  -928,   1088,   -496,    224,     80,      8,   -496,     80,   -424,   -352,    800,     80,   4112,   -496, &
                  3536,   -928,   -424,   -496,   -352,    224,   4544,   3968,    -64,    512,   -640,   5120,   3968,  -1792, &
                  -640,    -64,   3968,   -640,    512,  -4096,   5120,    512,  32768,  -4096,    -64,    512,   -640,    -64, &
                 -4096,    512,   -568,   -496,      8,    -64,     80,   -640,   -496,    224,     80,      8,   -496,     80, &
                   -64,    512,   -640,    -64,  -4096,    512,      8,    -64,     80,      8,    512,    -64,   4040,   4112, &
                  -568,   4544,   -496,   3968,  -1072,   -352,    152,   -568,   -424,   -496,      8,    -64,     80,      8, &
                   512,    -64,     80,   -640,    800,     80,   5120,   -640]
  K1( 426,:) = [   4112,   -352,   -352,   -928,   -928,   1088,   -496,    224,     80,      8,   -496,     80,   -424,   -352, &
                   800,     80,   4112,   -496,   3536,   -928,   -424,   -496,   -352,    224,   4040,  -1072,  -1072,   3536, &
                  3536,   -928,   -568,   -496,      8,    -64,     80,   -640,    152,   -424,     80,   -640,   -496,   3968, &
                 -1072,   -352,   -496,   3968,    224,  -1792,   3968,  -1792,   -640,    -64,   3968,   -640,   4544,   3968, &
                   -64,    512,   -640,   5120,   5120,    512,    512,  -4096,  -4096,  32768,   -640,    -64,    -64,    512, &
                   512,  -4096,   -496,    224,     80,      8,   -496,     80,   -568,   -496,      8,    -64,     80,   -640, &
                  -640,    -64,    -64,    512,    512,  -4096,     80,      8,      8,    -64,    -64,    512,  -1072,   -352, &
                   152,   -568,   -424,   -496,   4040,   4112,   -568,   4544,   -496,   3968,     80,      8,      8,    -64, &
                   -64,    512,    800,     80,     80,   -640,   -640,   5120]
  K1( 427,:) = [   -568,   4544,   4040,   4112,   3968,   -496,      8,    -64,     80,      8,    512,    -64,  -1072,   -352, &
                   152,   -568,   -424,   -496,   -640,     80,   5120,   -640,    800,     80,   -496,   3968,  -1072,   -352, &
                 -1792,    224,     80,   -640,   -496,   -568,    -64,      8,   3536,   -928,  -1072,   4040,   3536,  -1072, &
                  3968,   -496,   -640,     80,   -424,    152,    -64,    512,   -640,    -64,  -4096,    512,   -640,   5120, &
                  3968,   4544,    512,    -64,   3968,   -640,  -1792,   3968,    -64,   -640,  32768,  -4096,  -4096,    512, &
                   512,   5120,   3536,   -928,   -424,   -496,   -352,    224,   -928,   1088,   -352,   4112,   -928,   -352, &
                  -496,     80,    224,   -496,      8,     80,   4112,   -496,   -352,   -424,     80,    800,    -64,      8, &
                   512,    -64,     80,      8,   -640,     80,    -64,      8,   -496,   -568,  -4096,    512,    512,    -64, &
                   -64,   -640,   -496,     80,    224,   -496,      8,     80]
  K1( 428,:) = [    152,   -568,  -1072,   -352,   -496,   -424,     80,      8,      8,    -64,    -64,    512,   4040,   4112, &
                  -568,   4544,   -496,   3968,     80,    800,   -640,   5120,     80,   -640,   -424,   -496,   3536,   -928, &
                   224,   -352,   -496,     80,    224,   -496,      8,     80,   -928,   1088,   -352,   4112,   -928,   -352, &
                  -496,   4112,     80,    800,   -352,   -424,   -640,    -64,    -64,    512,    512,  -4096,   3968,   -640, &
                 -1792,   3968,    -64,   -640,   -640,   5120,   3968,   4544,    512,    -64,  -4096,  32768,    512,   5120, &
                 -4096,    512,  -1072,   -352,   -496,   3968,    224,  -1792,   3536,   -928,  -1072,   4040,   3536,  -1072, &
                    80,   -640,   -496,   -568,    -64,      8,   -496,   3968,   -424,    152,   -640,     80,      8,     80, &
                   -64,    512,      8,    -64,     80,   -496,      8,     80,    224,   -496,    512,  -4096,    -64,   -640, &
                   512,    -64,     80,   -640,   -496,   -568,    -64,      8]
  K1( 429,:) = [   -496,   3968,  -1072,   -352,  -1792,    224,     80,   -640,   -496,   -568,    -64,      8,   3536,   -928, &
                 -1072,   4040,   3536,  -1072,   3968,   -496,   -640,     80,   -424,    152,   -568,   4544,   4040,   4112, &
                  3968,   -496,      8,    -64,     80,      8,    512,    -64,  -1072,   -352,    152,   -568,   -424,   -496, &
                  -640,     80,   5120,   -640,    800,     80,   -640,   5120,   3968,   4544,    512,    -64,    -64,    512, &
                  -640,    -64,  -4096,    512,  -1792,   3968,   3968,   -640,   -640,    -64,  -4096,    512,  32768,  -4096, &
                  5120,    512,   -928,   1088,   -352,   4112,   -928,   -352,   3536,   -928,   -424,   -496,   -352,    224, &
                   224,   -496,   -496,     80,     80,      8,   -352,   -424,   4112,   -496,    800,     80,   -640,     80, &
                   -64,      8,   -496,   -568,    -64,      8,    512,    -64,     80,      8,    512,    -64,  -4096,    512, &
                  -640,    -64,    224,   -496,   -496,     80,     80,      8]
  K1( 430,:) = [   -424,   -496,   3536,   -928,    224,   -352,   -496,     80,    224,   -496,      8,     80,   -928,   1088, &
                  -352,   4112,   -928,   -352,   -496,   4112,     80,    800,   -352,   -424,    152,   -568,  -1072,   -352, &
                  -496,   -424,     80,      8,      8,    -64,    -64,    512,   4040,   4112,   -568,   4544,   -496,   3968, &
                    80,    800,   -640,   5120,     80,   -640,   3968,   -640,  -1792,   3968,    -64,   -640,   -640,    -64, &
                   -64,    512,    512,  -4096,   3968,   4544,   -640,   5120,    -64,    512,    512,   5120,  -4096,  32768, &
                   512,  -4096,   3536,   -928,  -1072,   4040,   3536,  -1072,  -1072,   -352,   -496,   3968,    224,  -1792, &
                  -496,   -568,     80,   -640,      8,    -64,   -424,    152,   -496,   3968,     80,   -640,     80,   -496, &
                     8,     80,    224,   -496,      8,     80,    -64,    512,      8,    -64,    -64,   -640,    512,  -4096, &
                   -64,    512,   -496,   -568,     80,   -640,      8,    -64]
  K1( 431,:) = [  -1072,   4040,   3536,   -928,  -1072,   3536,   -496,   -568,     80,   -640,      8,    -64,  -1072,   -352, &
                  -496,   3968,    224,  -1792,    152,   -424,     80,   -640,   -496,   3968,   -352,   4112,   -928,   1088, &
                  -352,   -928,    224,   -496,   -496,     80,     80,      8,   3536,   -928,   -424,   -496,   -352,    224, &
                  -424,   -352,    800,     80,   4112,   -496,   3968,   4544,   -640,   5120,    -64,    512,  -1792,   3968, &
                  3968,   -640,   -640,    -64,    -64,    512,   -640,    -64,  -4096,    512,    512,  -4096,   5120,    512, &
                 32768,  -4096,   4040,   4112,   -568,   4544,   -496,   3968,  -1072,   -352,    152,   -568,   -424,   -496, &
                     8,    -64,     80,      8,    512,    -64,     80,   -640,    800,     80,   5120,   -640,   -568,   -496, &
                     8,    -64,     80,   -640,   -496,    224,     80,      8,   -496,     80,    -64,    512,   -640,    -64, &
                 -4096,    512,      8,    -64,     80,      8,    512,    -64]
  K1( 432,:) = [   -352,   4112,   -928,   1088,   -352,   -928,    224,   -496,   -496,     80,     80,      8,   3536,   -928, &
                  -424,   -496,   -352,    224,   -424,   -352,    800,     80,   4112,   -496,  -1072,   4040,   3536,   -928, &
                 -1072,   3536,   -496,   -568,     80,   -640,      8,    -64,  -1072,   -352,   -496,   3968,    224,  -1792, &
                   152,   -424,     80,   -640,   -496,   3968,  -1792,   3968,   3968,   -640,   -640,    -64,   3968,   4544, &
                  -640,   5120,    -64,    512,   -640,    -64,    -64,    512,    512,  -4096,   5120,    512,    512,  -4096, &
                 -4096,  32768,  -1072,   -352,    152,   -568,   -424,   -496,   4040,   4112,   -568,   4544,   -496,   3968, &
                    80,      8,      8,    -64,    -64,    512,    800,     80,     80,   -640,   -640,   5120,   -496,    224, &
                    80,      8,   -496,     80,   -568,   -496,      8,    -64,     80,   -640,   -640,    -64,    -64,    512, &
                   512,  -4096,     80,      8,      8,    -64,    -64,    512]
  K1( 433,:) = [    -64,      8,    512,    -64,     80,      8,   -640,     80,    -64,      8,   -496,   -568,  -4096,    512, &
                   512,    -64,    -64,   -640,   -496,     80,    224,   -496,      8,     80,   -640,     80,   5120,   -640, &
                   800,     80,   3968,   -496,   4544,   -568,   4112,   4040,    512,    -64,    -64,      8,      8,     80, &
                  -424,   -496,   -352,  -1072,   -568,    152,   3968,   -496,   -640,     80,   -424,    152,  -1792,    224, &
                  3968,   -496,   -352,  -1072,    -64,      8,   -640,     80,   -568,   -496,   3536,  -1072,   -928,   3536, &
                  4040,  -1072,  32768,  -4096,  -4096,    512,    512,   5120,  -4096,    512,    512,    -64,    -64,   -640, &
                   512,    -64,   5120,   -640,   4544,   3968,    -64,   -640,   -640,   3968,   3968,  -1792,   4112,   -496, &
                  -352,   -424,     80,    800,   -352,    224,   -928,   3536,   -496,   -424,   -928,   -352,   1088,   -928, &
                  4112,   -352,      8,     80,     80,   -496,   -496,    224]
  K1( 434,:) = [      8,     80,    -64,    512,      8,    -64,     80,   -496,      8,     80,    224,   -496,    512,  -4096, &
                   -64,   -640,    512,    -64,     80,   -640,   -496,   -568,    -64,      8,     80,    800,   -640,   5120, &
                    80,   -640,   -496,   -424,   -568,    152,   -352,  -1072,    -64,    512,      8,     80,    -64,      8, &
                  -496,   3968,   4112,   4040,   4544,   -568,   -496,   4112,     80,    800,   -352,   -424,    224,   -352, &
                  -496,   -424,   -928,   3536,      8,     80,     80,   -496,   -496,    224,   -928,   -352,   1088,   -928, &
                  4112,   -352,  -4096,  32768,    512,   5120,  -4096,    512,    512,  -4096,    -64,   -640,    512,    -64, &
                   -64,   -640,   -640,   3968,   3968,  -1792,    512,    -64,   5120,   -640,   4544,   3968,   -496,   3968, &
                  -424,    152,   -640,     80,    224,  -1792,   -352,  -1072,   3968,   -496,   3536,  -1072,   -928,   3536, &
                  4040,  -1072,    -64,      8,   -640,     80,   -568,   -496]
  K1( 435,:) = [   -640,     80,    -64,      8,   -496,   -568,    -64,      8,    512,    -64,     80,      8,    512,    -64, &
                 -4096,    512,   -640,    -64,    224,   -496,   -496,     80,     80,      8,   3968,   -496,   -640,     80, &
                  -424,    152,  -1792,    224,   3968,   -496,   -352,  -1072,    -64,      8,   -640,     80,   -568,   -496, &
                  3536,  -1072,   -928,   3536,   4040,  -1072,   -640,     80,   5120,   -640,    800,     80,   3968,   -496, &
                  4544,   -568,   4112,   4040,    512,    -64,    -64,      8,      8,     80,   -424,   -496,   -352,  -1072, &
                  -568,    152,  -4096,    512,  32768,  -4096,   5120,    512,    512,    -64,   5120,   -640,   4544,   3968, &
                 -4096,    512,    512,    -64,    -64,   -640,   -640,    -64,   3968,  -1792,   -640,   3968,   -352,   -424, &
                  4112,   -496,    800,     80,   -928,   -352,   1088,   -928,   4112,   -352,   -352,    224,   -928,   3536, &
                  -496,   -424,     80,      8,   -496,    224,     80,   -496]
  K1( 436,:) = [     80,   -496,      8,     80,    224,   -496,      8,     80,    -64,    512,      8,    -64,    -64,   -640, &
                   512,  -4096,    -64,    512,   -496,   -568,     80,   -640,      8,    -64,   -496,   4112,     80,    800, &
                  -352,   -424,    224,   -352,   -496,   -424,   -928,   3536,      8,     80,     80,   -496,   -496,    224, &
                  -928,   -352,   1088,   -928,   4112,   -352,     80,    800,   -640,   5120,     80,   -640,   -496,   -424, &
                  -568,    152,   -352,  -1072,    -64,    512,      8,     80,    -64,      8,   -496,   3968,   4112,   4040, &
                  4544,   -568,    512,   5120,  -4096,  32768,    512,  -4096,    -64,   -640,   -640,   3968,   3968,  -1792, &
                   512,  -4096,    -64,   -640,    512,    -64,    -64,    512,   4544,   3968,   5120,   -640,   -424,    152, &
                  -496,   3968,     80,   -640,   3536,  -1072,   -928,   3536,   4040,  -1072,    224,  -1792,   -352,  -1072, &
                  3968,   -496,      8,    -64,   -568,   -496,   -640,     80]
  K1( 437,:) = [   -568,   -496,      8,    -64,     80,   -640,   -496,    224,     80,      8,   -496,     80,    -64,    512, &
                  -640,    -64,  -4096,    512,      8,    -64,     80,      8,    512,    -64,    152,   -424,     80,   -640, &
                  -496,   3968,  -1072,   3536,   4040,  -1072,   -928,   3536,      8,    -64,   -568,   -496,   -640,     80, &
                   224,  -1792,   -352,  -1072,   3968,   -496,   -424,   -352,    800,     80,   4112,   -496,   -352,   -928, &
                  4112,   -352,   1088,   -928,     80,      8,   -496,    224,     80,   -496,   -352,    224,   -928,   3536, &
                  -496,   -424,    512,  -4096,   5120,    512,  32768,  -4096,    -64,    512,   4544,   3968,   5120,   -640, &
                  -640,    -64,   3968,  -1792,   -640,   3968,  -4096,    512,    512,    -64,    -64,   -640,     80,   -640, &
                   800,     80,   5120,   -640,   -496,   3968,   4112,   4040,   4544,   -568,   -424,   -496,   -352,  -1072, &
                  -568,    152,    512,    -64,    -64,      8,      8,     80]
  K1( 438,:) = [   -496,    224,     80,      8,   -496,     80,   -568,   -496,      8,    -64,     80,   -640,   -640,    -64, &
                   -64,    512,    512,  -4096,     80,      8,      8,    -64,    -64,    512,   -424,   -352,    800,     80, &
                  4112,   -496,   -352,   -928,   4112,   -352,   1088,   -928,     80,      8,   -496,    224,     80,   -496, &
                  -352,    224,   -928,   3536,   -496,   -424,    152,   -424,     80,   -640,   -496,   3968,  -1072,   3536, &
                  4040,  -1072,   -928,   3536,      8,    -64,   -568,   -496,   -640,     80,    224,  -1792,   -352,  -1072, &
                  3968,   -496,   5120,    512,    512,  -4096,  -4096,  32768,   -640,    -64,   3968,  -1792,   -640,   3968, &
                   -64,    512,   4544,   3968,   5120,   -640,    512,  -4096,    -64,   -640,    512,    -64,    800,     80, &
                    80,   -640,   -640,   5120,   -424,   -496,   -352,  -1072,   -568,    152,   -496,   3968,   4112,   4040, &
                  4544,   -568,    -64,    512,      8,     80,    -64,      8]
  K1( 439,:) = [   -640,     80,   5120,   -640,    800,     80,   3968,   -496,   4544,   -568,   4112,   4040,    512,    -64, &
                   -64,      8,      8,     80,   -424,   -496,   -352,  -1072,   -568,    152,    -64,      8,    512,    -64, &
                    80,      8,   -640,     80,    -64,      8,   -496,   -568,  -4096,    512,    512,    -64,    -64,   -640, &
                  -496,     80,    224,   -496,      8,     80,  -1792,    224,   3968,   -496,   -352,  -1072,   3968,   -496, &
                  -640,     80,   -424,    152,   -640,     80,    -64,      8,   -496,   -568,   -928,   3536,   3536,  -1072, &
                 -1072,   4040,  -4096,    512,    512,    -64,    -64,   -640,  32768,  -4096,  -4096,    512,    512,   5120, &
                  5120,   -640,    512,    -64,   3968,   4544,   -640,   3968,    -64,   -640,  -1792,   3968,   -352,    224, &
                  -928,   3536,   -496,   -424,   4112,   -496,   -352,   -424,     80,    800,   1088,   -928,   -928,   -352, &
                  -352,   4112,     80,   -496,      8,     80,    224,   -496]
  K1( 440,:) = [     80,    800,   -640,   5120,     80,   -640,   -496,   -424,   -568,    152,   -352,  -1072,    -64,    512, &
                     8,     80,    -64,      8,   -496,   3968,   4112,   4040,   4544,   -568,      8,     80,    -64,    512, &
                     8,    -64,     80,   -496,      8,     80,    224,   -496,    512,  -4096,    -64,   -640,    512,    -64, &
                    80,   -640,   -496,   -568,    -64,      8,    224,   -352,   -496,   -424,   -928,   3536,   -496,   4112, &
                    80,    800,   -352,   -424,     80,   -496,      8,     80,    224,   -496,   1088,   -928,   -928,   -352, &
                  -352,   4112,    512,  -4096,    -64,   -640,    512,    -64,  -4096,  32768,    512,   5120,  -4096,    512, &
                  -640,   3968,    -64,   -640,  -1792,   3968,   5120,   -640,    512,    -64,   3968,   4544,    224,  -1792, &
                  -352,  -1072,   3968,   -496,   -496,   3968,   -424,    152,   -640,     80,   -928,   3536,   3536,  -1072, &
                 -1072,   4040,   -640,     80,    -64,      8,   -496,   -568]
  K1( 441,:) = [   3968,   -496,   -640,     80,   -424,    152,  -1792,    224,   3968,   -496,   -352,  -1072,    -64,      8, &
                  -640,     80,   -568,   -496,   3536,  -1072,   -928,   3536,   4040,  -1072,   -640,     80,    -64,      8, &
                  -496,   -568,    -64,      8,    512,    -64,     80,      8,    512,    -64,  -4096,    512,   -640,    -64, &
                   224,   -496,   -496,     80,     80,      8,   3968,   -496,   4544,   -568,   4112,   4040,   -640,     80, &
                  5120,   -640,    800,     80,    -64,      8,    512,    -64,     80,      8,   -352,  -1072,   -424,   -496, &
                   152,   -568,    512,    -64,   5120,   -640,   4544,   3968,  -4096,    512,  32768,  -4096,   5120,    512, &
                   512,    -64,  -4096,    512,   -640,    -64,   3968,  -1792,   -640,    -64,   3968,   -640,   -928,   -352, &
                  1088,   -928,   4112,   -352,   -352,   -424,   4112,   -496,    800,     80,   -928,   3536,   -352,    224, &
                  -424,   -496,   -496,    224,     80,      8,   -496,     80]
  K1( 442,:) = [   -496,   4112,     80,    800,   -352,   -424,    224,   -352,   -496,   -424,   -928,   3536,      8,     80, &
                    80,   -496,   -496,    224,   -928,   -352,   1088,   -928,   4112,   -352,     80,   -496,      8,     80, &
                   224,   -496,      8,     80,    -64,    512,      8,    -64,    -64,   -640,    512,  -4096,    -64,    512, &
                  -496,   -568,     80,   -640,      8,    -64,   -496,   -424,   -568,    152,   -352,  -1072,     80,    800, &
                  -640,   5120,     80,   -640,      8,     80,    -64,    512,      8,    -64,   4112,   4040,   -496,   3968, &
                  -568,   4544,    -64,   -640,   -640,   3968,   3968,  -1792,    512,   5120,  -4096,  32768,    512,  -4096, &
                   -64,   -640,    512,  -4096,    -64,    512,   4544,   3968,    -64,    512,   -640,   5120,   3536,  -1072, &
                  -928,   3536,   4040,  -1072,   -424,    152,   -496,   3968,     80,   -640,   -352,  -1072,    224,  -1792, &
                  -496,   3968,   -568,   -496,      8,    -64,     80,   -640]
  K1( 443,:) = [    152,   -424,     80,   -640,   -496,   3968,  -1072,   3536,   4040,  -1072,   -928,   3536,      8,    -64, &
                  -568,   -496,   -640,     80,    224,  -1792,   -352,  -1072,   3968,   -496,   -568,   -496,      8,    -64, &
                    80,   -640,   -496,    224,     80,      8,   -496,     80,    -64,    512,   -640,    -64,  -4096,    512, &
                     8,    -64,     80,      8,    512,    -64,   -352,   -928,   4112,   -352,   1088,   -928,   -424,   -352, &
                   800,     80,   4112,   -496,   -496,    224,     80,      8,   -496,     80,   -928,   3536,   -352,    224, &
                  -424,   -496,    -64,    512,   4544,   3968,   5120,   -640,    512,  -4096,   5120,    512,  32768,  -4096, &
                  3968,  -1792,   -640,    -64,   3968,   -640,    512,    -64,  -4096,    512,   -640,    -64,   -496,   3968, &
                  4112,   4040,   4544,   -568,     80,   -640,    800,     80,   5120,   -640,   -352,  -1072,   -424,   -496, &
                   152,   -568,    -64,      8,    512,    -64,     80,      8]
  K1( 444,:) = [   -424,   -352,    800,     80,   4112,   -496,   -352,   -928,   4112,   -352,   1088,   -928,     80,      8, &
                  -496,    224,     80,   -496,   -352,    224,   -928,   3536,   -496,   -424,   -496,    224,     80,      8, &
                  -496,     80,   -568,   -496,      8,    -64,     80,   -640,   -640,    -64,    -64,    512,    512,  -4096, &
                    80,      8,      8,    -64,    -64,    512,  -1072,   3536,   4040,  -1072,   -928,   3536,    152,   -424, &
                    80,   -640,   -496,   3968,   -568,   -496,      8,    -64,     80,   -640,   -352,  -1072,    224,  -1792, &
                  -496,   3968,   -640,    -64,   3968,  -1792,   -640,   3968,   5120,    512,    512,  -4096,  -4096,  32768, &
                  4544,   3968,    -64,    512,   -640,   5120,    -64,   -640,    512,  -4096,    -64,    512,   -424,   -496, &
                  -352,  -1072,   -568,    152,    800,     80,     80,   -640,   -640,   5120,   4112,   4040,   -496,   3968, &
                  -568,   4544,      8,     80,    -64,    512,      8,    -64]
  K1( 445,:) = [   3968,   -496,   4544,   -568,   4112,   4040,   -640,     80,   5120,   -640,    800,     80,    -64,      8, &
                   512,    -64,     80,      8,   -352,  -1072,   -424,   -496,    152,   -568,  -1792,    224,   3968,   -496, &
                  -352,  -1072,   3968,   -496,   -640,     80,   -424,    152,   -640,     80,    -64,      8,   -496,   -568, &
                  -928,   3536,   3536,  -1072,  -1072,   4040,    -64,      8,    512,    -64,     80,      8,   -640,     80, &
                   -64,      8,   -496,   -568,  -4096,    512,    512,    -64,    -64,   -640,   -496,     80,    224,   -496, &
                     8,     80,    512,    -64,  -4096,    512,   -640,    -64,   5120,   -640,    512,    -64,   3968,   4544, &
                 32768,  -4096,  -4096,    512,    512,   5120,   3968,   -640,  -1792,   3968,    -64,   -640,   -928,   3536, &
                  -352,    224,   -424,   -496,   1088,   -928,   -928,   -352,   -352,   4112,   4112,   -496,   -352,   -424, &
                    80,    800,   -496,     80,    224,   -496,      8,     80]
  K1( 446,:) = [   -496,   -424,   -568,    152,   -352,  -1072,     80,    800,   -640,   5120,     80,   -640,      8,     80, &
                   -64,    512,      8,    -64,   4112,   4040,   -496,   3968,   -568,   4544,    224,   -352,   -496,   -424, &
                  -928,   3536,   -496,   4112,     80,    800,   -352,   -424,     80,   -496,      8,     80,    224,   -496, &
                  1088,   -928,   -928,   -352,   -352,   4112,      8,     80,    -64,    512,      8,    -64,     80,   -496, &
                     8,     80,    224,   -496,    512,  -4096,    -64,   -640,    512,    -64,     80,   -640,   -496,   -568, &
                   -64,      8,    -64,   -640,    512,  -4096,    -64,    512,   -640,   3968,    -64,   -640,  -1792,   3968, &
                 -4096,  32768,    512,   5120,  -4096,    512,   -640,   5120,   3968,   4544,    512,    -64,   -352,  -1072, &
                   224,  -1792,   -496,   3968,   -928,   3536,   3536,  -1072,  -1072,   4040,   -496,   3968,   -424,    152, &
                  -640,     80,     80,   -640,   -496,   -568,    -64,      8]
  K1( 447,:) = [  -1792,    224,   3968,   -496,   -352,  -1072,   3968,   -496,   -640,     80,   -424,    152,   -640,     80, &
                   -64,      8,   -496,   -568,   -928,   3536,   3536,  -1072,  -1072,   4040,   3968,   -496,   4544,   -568, &
                  4112,   4040,   -640,     80,   5120,   -640,    800,     80,    -64,      8,    512,    -64,     80,      8, &
                  -352,  -1072,   -424,   -496,    152,   -568,   -640,     80,    -64,      8,   -496,   -568,    -64,      8, &
                   512,    -64,     80,      8,    512,    -64,  -4096,    512,   -640,    -64,    224,   -496,   -496,     80, &
                    80,      8,   5120,   -640,    512,    -64,   3968,   4544,    512,    -64,  -4096,    512,   -640,    -64, &
                 -4096,    512,  32768,  -4096,   5120,    512,  -1792,   3968,   3968,   -640,   -640,    -64,   1088,   -928, &
                  -928,   -352,   -352,   4112,   -928,   3536,   -352,    224,   -424,   -496,   -352,   -424,   4112,   -496, &
                   800,     80,    224,   -496,   -496,     80,     80,      8]
  K1( 448,:) = [    224,   -352,   -496,   -424,   -928,   3536,   -496,   4112,     80,    800,   -352,   -424,     80,   -496, &
                     8,     80,    224,   -496,   1088,   -928,   -928,   -352,   -352,   4112,   -496,   -424,   -568,    152, &
                  -352,  -1072,     80,    800,   -640,   5120,     80,   -640,      8,     80,    -64,    512,      8,    -64, &
                  4112,   4040,   -496,   3968,   -568,   4544,     80,   -496,      8,     80,    224,   -496,      8,     80, &
                   -64,    512,      8,    -64,    -64,   -640,    512,  -4096,    -64,    512,   -496,   -568,     80,   -640, &
                     8,    -64,   -640,   3968,    -64,   -640,  -1792,   3968,    -64,   -640,    512,  -4096,    -64,    512, &
                   512,   5120,  -4096,  32768,    512,  -4096,   3968,   4544,   -640,   5120,    -64,    512,   -928,   3536, &
                  3536,  -1072,  -1072,   4040,   -352,  -1072,    224,  -1792,   -496,   3968,   -424,    152,   -496,   3968, &
                    80,   -640,   -496,   -568,     80,   -640,      8,    -64]
  K1( 449,:) = [  -1072,   3536,   4040,  -1072,   -928,   3536,    152,   -424,     80,   -640,   -496,   3968,   -568,   -496, &
                     8,    -64,     80,   -640,   -352,  -1072,    224,  -1792,   -496,   3968,   -352,   -928,   4112,   -352, &
                  1088,   -928,   -424,   -352,    800,     80,   4112,   -496,   -496,    224,     80,      8,   -496,     80, &
                  -928,   3536,   -352,    224,   -424,   -496,   -568,   -496,      8,    -64,     80,   -640,   -496,    224, &
                    80,      8,   -496,     80,    -64,    512,   -640,    -64,  -4096,    512,      8,    -64,     80,      8, &
                   512,    -64,   4544,   3968,    -64,    512,   -640,   5120,   3968,  -1792,   -640,    -64,   3968,   -640, &
                   512,  -4096,   5120,    512,  32768,  -4096,    -64,    512,   -640,    -64,  -4096,    512,   4112,   4040, &
                  -496,   3968,   -568,   4544,   -352,  -1072,   -424,   -496,    152,   -568,     80,   -640,    800,     80, &
                  5120,   -640,      8,    -64,     80,      8,    512,    -64]
  K1( 450,:) = [   -352,   -928,   4112,   -352,   1088,   -928,   -424,   -352,    800,     80,   4112,   -496,   -496,    224, &
                    80,      8,   -496,     80,   -928,   3536,   -352,    224,   -424,   -496,  -1072,   3536,   4040,  -1072, &
                  -928,   3536,    152,   -424,     80,   -640,   -496,   3968,   -568,   -496,      8,    -64,     80,   -640, &
                  -352,  -1072,    224,  -1792,   -496,   3968,   -496,    224,     80,      8,   -496,     80,   -568,   -496, &
                     8,    -64,     80,   -640,   -640,    -64,    -64,    512,    512,  -4096,     80,      8,      8,    -64, &
                   -64,    512,   3968,  -1792,   -640,    -64,   3968,   -640,   4544,   3968,    -64,    512,   -640,   5120, &
                  5120,    512,    512,  -4096,  -4096,  32768,   -640,    -64,    -64,    512,    512,  -4096,   -352,  -1072, &
                  -424,   -496,    152,   -568,   4112,   4040,   -496,   3968,   -568,   4544,    800,     80,     80,   -640, &
                  -640,   5120,     80,      8,      8,    -64,    -64,    512]
  K1( 451,:) = [   4040,   4112,   -568,   4544,   -496,   3968,  -1072,   -352,    152,   -568,   -424,   -496,      8,    -64, &
                    80,      8,    512,    -64,     80,   -640,    800,     80,   5120,   -640,  -1072,   -352,   -496,   3968, &
                   224,  -1792,   3536,   -928,  -1072,   4040,   3536,  -1072,     80,   -640,   -496,   -568,    -64,      8, &
                  -496,   3968,   -424,    152,   -640,     80,   3536,   -928,   -424,   -496,   -352,    224,   -928,   1088, &
                  -352,   4112,   -928,   -352,   -496,     80,    224,   -496,      8,     80,   4112,   -496,   -352,   -424, &
                    80,    800,    -64,    512,   -640,    -64,  -4096,    512,   -640,   5120,   3968,   4544,    512,    -64, &
                  3968,   -640,  -1792,   3968,    -64,   -640,  32768,  -4096,  -4096,    512,    512,   5120,      8,    -64, &
                    80,      8,    512,    -64,     80,   -640,   -496,   -568,    -64,      8,   -496,     80,    224,   -496, &
                     8,     80,  -4096,    512,    512,    -64,    -64,   -640]
  K1( 452,:) = [  -1072,   -352,    152,   -568,   -424,   -496,   4040,   4112,   -568,   4544,   -496,   3968,     80,      8, &
                     8,    -64,    -64,    512,    800,     80,     80,   -640,   -640,   5120,   3536,   -928,   -424,   -496, &
                  -352,    224,   -928,   1088,   -352,   4112,   -928,   -352,   -496,     80,    224,   -496,      8,     80, &
                  4112,   -496,   -352,   -424,     80,    800,  -1072,   -352,   -496,   3968,    224,  -1792,   3536,   -928, &
                 -1072,   4040,   3536,  -1072,     80,   -640,   -496,   -568,    -64,      8,   -496,   3968,   -424,    152, &
                  -640,     80,   -640,    -64,    -64,    512,    512,  -4096,   3968,   -640,  -1792,   3968,    -64,   -640, &
                  -640,   5120,   3968,   4544,    512,    -64,  -4096,  32768,    512,   5120,  -4096,    512,     80,      8, &
                     8,    -64,    -64,    512,   -496,     80,    224,   -496,      8,     80,     80,   -640,   -496,   -568, &
                   -64,      8,    512,  -4096,    -64,   -640,    512,    -64]
  K1( 453,:) = [  -1072,   -352,   -496,   3968,    224,  -1792,   3536,   -928,  -1072,   4040,   3536,  -1072,     80,   -640, &
                  -496,   -568,    -64,      8,   -496,   3968,   -424,    152,   -640,     80,   4040,   4112,   -568,   4544, &
                  -496,   3968,  -1072,   -352,    152,   -568,   -424,   -496,      8,    -64,     80,      8,    512,    -64, &
                    80,   -640,    800,     80,   5120,   -640,   -928,   1088,   -352,   4112,   -928,   -352,   3536,   -928, &
                  -424,   -496,   -352,    224,    224,   -496,   -496,     80,     80,      8,   -352,   -424,   4112,   -496, &
                   800,     80,   -640,   5120,   3968,   4544,    512,    -64,    -64,    512,   -640,    -64,  -4096,    512, &
                 -1792,   3968,   3968,   -640,   -640,    -64,  -4096,    512,  32768,  -4096,   5120,    512,     80,   -640, &
                  -496,   -568,    -64,      8,      8,    -64,     80,      8,    512,    -64,    224,   -496,   -496,     80, &
                    80,      8,    512,    -64,  -4096,    512,   -640,    -64]
  K1( 454,:) = [   3536,   -928,   -424,   -496,   -352,    224,   -928,   1088,   -352,   4112,   -928,   -352,   -496,     80, &
                   224,   -496,      8,     80,   4112,   -496,   -352,   -424,     80,    800,  -1072,   -352,    152,   -568, &
                  -424,   -496,   4040,   4112,   -568,   4544,   -496,   3968,     80,      8,      8,    -64,    -64,    512, &
                   800,     80,     80,   -640,   -640,   5120,   3536,   -928,  -1072,   4040,   3536,  -1072,  -1072,   -352, &
                  -496,   3968,    224,  -1792,   -496,   -568,     80,   -640,      8,    -64,   -424,    152,   -496,   3968, &
                    80,   -640,   3968,   -640,  -1792,   3968,    -64,   -640,   -640,    -64,    -64,    512,    512,  -4096, &
                  3968,   4544,   -640,   5120,    -64,    512,    512,   5120,  -4096,  32768,    512,  -4096,   -496,     80, &
                   224,   -496,      8,     80,     80,      8,      8,    -64,    -64,    512,   -496,   -568,     80,   -640, &
                     8,    -64,    -64,   -640,    512,  -4096,    -64,    512]
  K1( 455,:) = [   3536,   -928,  -1072,   4040,   3536,  -1072,  -1072,   -352,   -496,   3968,    224,  -1792,   -496,   -568, &
                    80,   -640,      8,    -64,   -424,    152,   -496,   3968,     80,   -640,   -928,   1088,   -352,   4112, &
                  -928,   -352,   3536,   -928,   -424,   -496,   -352,    224,    224,   -496,   -496,     80,     80,      8, &
                  -352,   -424,   4112,   -496,    800,     80,   4040,   4112,   -568,   4544,   -496,   3968,  -1072,   -352, &
                   152,   -568,   -424,   -496,      8,    -64,     80,      8,    512,    -64,     80,   -640,    800,     80, &
                  5120,   -640,   3968,   4544,   -640,   5120,    -64,    512,  -1792,   3968,   3968,   -640,   -640,    -64, &
                   -64,    512,   -640,    -64,  -4096,    512,    512,  -4096,   5120,    512,  32768,  -4096,   -496,   -568, &
                    80,   -640,      8,    -64,    224,   -496,   -496,     80,     80,      8,      8,    -64,     80,      8, &
                   512,    -64,    -64,    512,   -640,    -64,  -4096,    512]
  K1( 456,:) = [   -928,   1088,   -352,   4112,   -928,   -352,   3536,   -928,   -424,   -496,   -352,    224,    224,   -496, &
                  -496,     80,     80,      8,   -352,   -424,   4112,   -496,    800,     80,   3536,   -928,  -1072,   4040, &
                  3536,  -1072,  -1072,   -352,   -496,   3968,    224,  -1792,   -496,   -568,     80,   -640,      8,    -64, &
                  -424,    152,   -496,   3968,     80,   -640,  -1072,   -352,    152,   -568,   -424,   -496,   4040,   4112, &
                  -568,   4544,   -496,   3968,     80,      8,      8,    -64,    -64,    512,    800,     80,     80,   -640, &
                  -640,   5120,  -1792,   3968,   3968,   -640,   -640,    -64,   3968,   4544,   -640,   5120,    -64,    512, &
                  -640,    -64,    -64,    512,    512,  -4096,   5120,    512,    512,  -4096,  -4096,  32768,    224,   -496, &
                  -496,     80,     80,      8,   -496,   -568,     80,   -640,      8,    -64,     80,      8,      8,    -64, &
                   -64,    512,   -640,    -64,    -64,    512,    512,  -4096]
  K1( 457,:) = [      8,    -64,     80,      8,    512,    -64,     80,   -640,   -496,   -568,    -64,      8,   -496,     80, &
                   224,   -496,      8,     80,  -4096,    512,    512,    -64,    -64,   -640,     80,   -640,    800,     80, &
                  5120,   -640,   -496,   3968,   4112,   4040,   4544,   -568,   -424,   -496,   -352,  -1072,   -568,    152, &
                   512,    -64,    -64,      8,      8,     80,   -496,   3968,   -424,    152,   -640,     80,    224,  -1792, &
                  -352,  -1072,   3968,   -496,   3536,  -1072,   -928,   3536,   4040,  -1072,    -64,      8,   -640,     80, &
                  -568,   -496,   4112,   -496,   -352,   -424,     80,    800,   -352,    224,   -928,   3536,   -496,   -424, &
                  -928,   -352,   1088,   -928,   4112,   -352,      8,     80,     80,   -496,   -496,    224,  32768,  -4096, &
                 -4096,    512,    512,   5120,  -4096,    512,    512,    -64,    -64,   -640,    512,    -64,   5120,   -640, &
                  4544,   3968,    -64,   -640,   -640,   3968,   3968,  -1792]
  K1( 458,:) = [     80,      8,      8,    -64,    -64,    512,   -496,     80,    224,   -496,      8,     80,     80,   -640, &
                  -496,   -568,    -64,      8,    512,  -4096,    -64,   -640,    512,    -64,    800,     80,     80,   -640, &
                  -640,   5120,   -424,   -496,   -352,  -1072,   -568,    152,   -496,   3968,   4112,   4040,   4544,   -568, &
                   -64,    512,      8,     80,    -64,      8,   4112,   -496,   -352,   -424,     80,    800,   -352,    224, &
                  -928,   3536,   -496,   -424,   -928,   -352,   1088,   -928,   4112,   -352,      8,     80,     80,   -496, &
                  -496,    224,   -496,   3968,   -424,    152,   -640,     80,    224,  -1792,   -352,  -1072,   3968,   -496, &
                  3536,  -1072,   -928,   3536,   4040,  -1072,    -64,      8,   -640,     80,   -568,   -496,  -4096,  32768, &
                   512,   5120,  -4096,    512,    512,  -4096,    -64,   -640,    512,    -64,    -64,   -640,   -640,   3968, &
                  3968,  -1792,    512,    -64,   5120,   -640,   4544,   3968]
  K1( 459,:) = [     80,   -640,   -496,   -568,    -64,      8,      8,    -64,     80,      8,    512,    -64,    224,   -496, &
                  -496,     80,     80,      8,    512,    -64,  -4096,    512,   -640,    -64,   -496,   3968,   -424,    152, &
                  -640,     80,    224,  -1792,   -352,  -1072,   3968,   -496,   3536,  -1072,   -928,   3536,   4040,  -1072, &
                   -64,      8,   -640,     80,   -568,   -496,     80,   -640,    800,     80,   5120,   -640,   -496,   3968, &
                  4112,   4040,   4544,   -568,   -424,   -496,   -352,  -1072,   -568,    152,    512,    -64,    -64,      8, &
                     8,     80,   -352,   -424,   4112,   -496,    800,     80,   -928,   -352,   1088,   -928,   4112,   -352, &
                  -352,    224,   -928,   3536,   -496,   -424,     80,      8,   -496,    224,     80,   -496,  -4096,    512, &
                 32768,  -4096,   5120,    512,    512,    -64,   5120,   -640,   4544,   3968,  -4096,    512,    512,    -64, &
                   -64,   -640,   -640,    -64,   3968,  -1792,   -640,   3968]
  K1( 460,:) = [   -496,     80,    224,   -496,      8,     80,     80,      8,      8,    -64,    -64,    512,   -496,   -568, &
                    80,   -640,      8,    -64,    -64,   -640,    512,  -4096,    -64,    512,   4112,   -496,   -352,   -424, &
                    80,    800,   -352,    224,   -928,   3536,   -496,   -424,   -928,   -352,   1088,   -928,   4112,   -352, &
                     8,     80,     80,   -496,   -496,    224,    800,     80,     80,   -640,   -640,   5120,   -424,   -496, &
                  -352,  -1072,   -568,    152,   -496,   3968,   4112,   4040,   4544,   -568,    -64,    512,      8,     80, &
                   -64,      8,   -424,    152,   -496,   3968,     80,   -640,   3536,  -1072,   -928,   3536,   4040,  -1072, &
                   224,  -1792,   -352,  -1072,   3968,   -496,      8,    -64,   -568,   -496,   -640,     80,    512,   5120, &
                 -4096,  32768,    512,  -4096,    -64,   -640,   -640,   3968,   3968,  -1792,    512,  -4096,    -64,   -640, &
                   512,    -64,    -64,    512,   4544,   3968,   5120,   -640]
  K1( 461,:) = [   -496,   -568,     80,   -640,      8,    -64,    224,   -496,   -496,     80,     80,      8,      8,    -64, &
                    80,      8,    512,    -64,    -64,    512,   -640,    -64,  -4096,    512,   -424,    152,   -496,   3968, &
                    80,   -640,   3536,  -1072,   -928,   3536,   4040,  -1072,    224,  -1792,   -352,  -1072,   3968,   -496, &
                     8,    -64,   -568,   -496,   -640,     80,   -352,   -424,   4112,   -496,    800,     80,   -928,   -352, &
                  1088,   -928,   4112,   -352,   -352,    224,   -928,   3536,   -496,   -424,     80,      8,   -496,    224, &
                    80,   -496,     80,   -640,    800,     80,   5120,   -640,   -496,   3968,   4112,   4040,   4544,   -568, &
                  -424,   -496,   -352,  -1072,   -568,    152,    512,    -64,    -64,      8,      8,     80,    512,  -4096, &
                  5120,    512,  32768,  -4096,    -64,    512,   4544,   3968,   5120,   -640,   -640,    -64,   3968,  -1792, &
                  -640,   3968,  -4096,    512,    512,    -64,    -64,   -640]
  K1( 462,:) = [    224,   -496,   -496,     80,     80,      8,   -496,   -568,     80,   -640,      8,    -64,     80,      8, &
                     8,    -64,    -64,    512,   -640,    -64,    -64,    512,    512,  -4096,   -352,   -424,   4112,   -496, &
                   800,     80,   -928,   -352,   1088,   -928,   4112,   -352,   -352,    224,   -928,   3536,   -496,   -424, &
                    80,      8,   -496,    224,     80,   -496,   -424,    152,   -496,   3968,     80,   -640,   3536,  -1072, &
                  -928,   3536,   4040,  -1072,    224,  -1792,   -352,  -1072,   3968,   -496,      8,    -64,   -568,   -496, &
                  -640,     80,    800,     80,     80,   -640,   -640,   5120,   -424,   -496,   -352,  -1072,   -568,    152, &
                  -496,   3968,   4112,   4040,   4544,   -568,    -64,    512,      8,     80,    -64,      8,   5120,    512, &
                   512,  -4096,  -4096,  32768,   -640,    -64,   3968,  -1792,   -640,   3968,    -64,    512,   4544,   3968, &
                  5120,   -640,    512,  -4096,    -64,   -640,    512,    -64]
  K1( 463,:) = [     80,   -640,    800,     80,   5120,   -640,   -496,   3968,   4112,   4040,   4544,   -568,   -424,   -496, &
                  -352,  -1072,   -568,    152,    512,    -64,    -64,      8,      8,     80,      8,    -64,     80,      8, &
                   512,    -64,     80,   -640,   -496,   -568,    -64,      8,   -496,     80,    224,   -496,      8,     80, &
                 -4096,    512,    512,    -64,    -64,   -640,    224,  -1792,   -352,  -1072,   3968,   -496,   -496,   3968, &
                  -424,    152,   -640,     80,   -928,   3536,   3536,  -1072,  -1072,   4040,   -640,     80,    -64,      8, &
                  -496,   -568,   -352,    224,   -928,   3536,   -496,   -424,   4112,   -496,   -352,   -424,     80,    800, &
                  1088,   -928,   -928,   -352,   -352,   4112,     80,   -496,      8,     80,    224,   -496,  -4096,    512, &
                   512,    -64,    -64,   -640,  32768,  -4096,  -4096,    512,    512,   5120,   5120,   -640,    512,    -64, &
                  3968,   4544,   -640,   3968,    -64,   -640,  -1792,   3968]
  K1( 464,:) = [    800,     80,     80,   -640,   -640,   5120,   -424,   -496,   -352,  -1072,   -568,    152,   -496,   3968, &
                  4112,   4040,   4544,   -568,    -64,    512,      8,     80,    -64,      8,     80,      8,      8,    -64, &
                   -64,    512,   -496,     80,    224,   -496,      8,     80,     80,   -640,   -496,   -568,    -64,      8, &
                   512,  -4096,    -64,   -640,    512,    -64,   -352,    224,   -928,   3536,   -496,   -424,   4112,   -496, &
                  -352,   -424,     80,    800,   1088,   -928,   -928,   -352,   -352,   4112,     80,   -496,      8,     80, &
                   224,   -496,    224,  -1792,   -352,  -1072,   3968,   -496,   -496,   3968,   -424,    152,   -640,     80, &
                  -928,   3536,   3536,  -1072,  -1072,   4040,   -640,     80,    -64,      8,   -496,   -568,    512,  -4096, &
                   -64,   -640,    512,    -64,  -4096,  32768,    512,   5120,  -4096,    512,   -640,   3968,    -64,   -640, &
                 -1792,   3968,   5120,   -640,    512,    -64,   3968,   4544]
  K1( 465,:) = [   -496,   3968,   -424,    152,   -640,     80,    224,  -1792,   -352,  -1072,   3968,   -496,   3536,  -1072, &
                  -928,   3536,   4040,  -1072,    -64,      8,   -640,     80,   -568,   -496,     80,   -640,   -496,   -568, &
                   -64,      8,      8,    -64,     80,      8,    512,    -64,    224,   -496,   -496,     80,     80,      8, &
                   512,    -64,  -4096,    512,   -640,    -64,   -496,   3968,   4112,   4040,   4544,   -568,     80,   -640, &
                   800,     80,   5120,   -640,   -352,  -1072,   -424,   -496,    152,   -568,    -64,      8,    512,    -64, &
                    80,      8,   -928,   -352,   1088,   -928,   4112,   -352,   -352,   -424,   4112,   -496,    800,     80, &
                  -928,   3536,   -352,    224,   -424,   -496,   -496,    224,     80,      8,   -496,     80,    512,    -64, &
                  5120,   -640,   4544,   3968,  -4096,    512,  32768,  -4096,   5120,    512,    512,    -64,  -4096,    512, &
                  -640,    -64,   3968,  -1792,   -640,    -64,   3968,   -640]
  K1( 466,:) = [   4112,   -496,   -352,   -424,     80,    800,   -352,    224,   -928,   3536,   -496,   -424,   -928,   -352, &
                  1088,   -928,   4112,   -352,      8,     80,     80,   -496,   -496,    224,   -496,     80,    224,   -496, &
                     8,     80,     80,      8,      8,    -64,    -64,    512,   -496,   -568,     80,   -640,      8,    -64, &
                   -64,   -640,    512,  -4096,    -64,    512,   -424,   -496,   -352,  -1072,   -568,    152,    800,     80, &
                    80,   -640,   -640,   5120,   4112,   4040,   -496,   3968,   -568,   4544,      8,     80,    -64,    512, &
                     8,    -64,   3536,  -1072,   -928,   3536,   4040,  -1072,   -424,    152,   -496,   3968,     80,   -640, &
                  -352,  -1072,    224,  -1792,   -496,   3968,   -568,   -496,      8,    -64,     80,   -640,    -64,   -640, &
                  -640,   3968,   3968,  -1792,    512,   5120,  -4096,  32768,    512,  -4096,    -64,   -640,    512,  -4096, &
                   -64,    512,   4544,   3968,    -64,    512,   -640,   5120]
  K1( 467,:) = [   -424,    152,   -496,   3968,     80,   -640,   3536,  -1072,   -928,   3536,   4040,  -1072,    224,  -1792, &
                  -352,  -1072,   3968,   -496,      8,    -64,   -568,   -496,   -640,     80,   -496,   -568,     80,   -640, &
                     8,    -64,    224,   -496,   -496,     80,     80,      8,      8,    -64,     80,      8,    512,    -64, &
                   -64,    512,   -640,    -64,  -4096,    512,   -928,   -352,   1088,   -928,   4112,   -352,   -352,   -424, &
                  4112,   -496,    800,     80,   -928,   3536,   -352,    224,   -424,   -496,   -496,    224,     80,      8, &
                  -496,     80,   -496,   3968,   4112,   4040,   4544,   -568,     80,   -640,    800,     80,   5120,   -640, &
                  -352,  -1072,   -424,   -496,    152,   -568,    -64,      8,    512,    -64,     80,      8,    -64,    512, &
                  4544,   3968,   5120,   -640,    512,  -4096,   5120,    512,  32768,  -4096,   3968,  -1792,   -640,    -64, &
                  3968,   -640,    512,    -64,  -4096,    512,   -640,    -64]
  K1( 468,:) = [   -352,   -424,   4112,   -496,    800,     80,   -928,   -352,   1088,   -928,   4112,   -352,   -352,    224, &
                  -928,   3536,   -496,   -424,     80,      8,   -496,    224,     80,   -496,    224,   -496,   -496,     80, &
                    80,      8,   -496,   -568,     80,   -640,      8,    -64,     80,      8,      8,    -64,    -64,    512, &
                  -640,    -64,    -64,    512,    512,  -4096,   3536,  -1072,   -928,   3536,   4040,  -1072,   -424,    152, &
                  -496,   3968,     80,   -640,   -352,  -1072,    224,  -1792,   -496,   3968,   -568,   -496,      8,    -64, &
                    80,   -640,   -424,   -496,   -352,  -1072,   -568,    152,    800,     80,     80,   -640,   -640,   5120, &
                  4112,   4040,   -496,   3968,   -568,   4544,      8,     80,    -64,    512,      8,    -64,   -640,    -64, &
                  3968,  -1792,   -640,   3968,   5120,    512,    512,  -4096,  -4096,  32768,   4544,   3968,    -64,    512, &
                  -640,   5120,    -64,   -640,    512,  -4096,    -64,    512]
  K1( 469,:) = [   -496,   3968,   4112,   4040,   4544,   -568,     80,   -640,    800,     80,   5120,   -640,   -352,  -1072, &
                  -424,   -496,    152,   -568,    -64,      8,    512,    -64,     80,      8,    224,  -1792,   -352,  -1072, &
                  3968,   -496,   -496,   3968,   -424,    152,   -640,     80,   -928,   3536,   3536,  -1072,  -1072,   4040, &
                  -640,     80,    -64,      8,   -496,   -568,      8,    -64,     80,      8,    512,    -64,     80,   -640, &
                  -496,   -568,    -64,      8,   -496,     80,    224,   -496,      8,     80,  -4096,    512,    512,    -64, &
                   -64,   -640,   -928,   3536,   -352,    224,   -424,   -496,   1088,   -928,   -928,   -352,   -352,   4112, &
                  4112,   -496,   -352,   -424,     80,    800,   -496,     80,    224,   -496,      8,     80,    512,    -64, &
                 -4096,    512,   -640,    -64,   5120,   -640,    512,    -64,   3968,   4544,  32768,  -4096,  -4096,    512, &
                   512,   5120,   3968,   -640,  -1792,   3968,    -64,   -640]
  K1( 470,:) = [   -424,   -496,   -352,  -1072,   -568,    152,    800,     80,     80,   -640,   -640,   5120,   4112,   4040, &
                  -496,   3968,   -568,   4544,      8,     80,    -64,    512,      8,    -64,   -352,    224,   -928,   3536, &
                  -496,   -424,   4112,   -496,   -352,   -424,     80,    800,   1088,   -928,   -928,   -352,   -352,   4112, &
                    80,   -496,      8,     80,    224,   -496,     80,      8,      8,    -64,    -64,    512,   -496,     80, &
                   224,   -496,      8,     80,     80,   -640,   -496,   -568,    -64,      8,    512,  -4096,    -64,   -640, &
                   512,    -64,   -352,  -1072,    224,  -1792,   -496,   3968,   -928,   3536,   3536,  -1072,  -1072,   4040, &
                  -496,   3968,   -424,    152,   -640,     80,     80,   -640,   -496,   -568,    -64,      8,    -64,   -640, &
                   512,  -4096,    -64,    512,   -640,   3968,    -64,   -640,  -1792,   3968,  -4096,  32768,    512,   5120, &
                 -4096,    512,   -640,   5120,   3968,   4544,    512,    -64]
  K1( 471,:) = [    224,  -1792,   -352,  -1072,   3968,   -496,   -496,   3968,   -424,    152,   -640,     80,   -928,   3536, &
                  3536,  -1072,  -1072,   4040,   -640,     80,    -64,      8,   -496,   -568,   -496,   3968,   4112,   4040, &
                  4544,   -568,     80,   -640,    800,     80,   5120,   -640,   -352,  -1072,   -424,   -496,    152,   -568, &
                   -64,      8,    512,    -64,     80,      8,     80,   -640,   -496,   -568,    -64,      8,      8,    -64, &
                    80,      8,    512,    -64,    224,   -496,   -496,     80,     80,      8,    512,    -64,  -4096,    512, &
                  -640,    -64,   1088,   -928,   -928,   -352,   -352,   4112,   -928,   3536,   -352,    224,   -424,   -496, &
                  -352,   -424,   4112,   -496,    800,     80,    224,   -496,   -496,     80,     80,      8,   5120,   -640, &
                   512,    -64,   3968,   4544,    512,    -64,  -4096,    512,   -640,    -64,  -4096,    512,  32768,  -4096, &
                  5120,    512,  -1792,   3968,   3968,   -640,   -640,    -64]
  K1( 472,:) = [   -352,    224,   -928,   3536,   -496,   -424,   4112,   -496,   -352,   -424,     80,    800,   1088,   -928, &
                  -928,   -352,   -352,   4112,     80,   -496,      8,     80,    224,   -496,   -424,   -496,   -352,  -1072, &
                  -568,    152,    800,     80,     80,   -640,   -640,   5120,   4112,   4040,   -496,   3968,   -568,   4544, &
                     8,     80,    -64,    512,      8,    -64,   -496,     80,    224,   -496,      8,     80,     80,      8, &
                     8,    -64,    -64,    512,   -496,   -568,     80,   -640,      8,    -64,    -64,   -640,    512,  -4096, &
                   -64,    512,   -928,   3536,   3536,  -1072,  -1072,   4040,   -352,  -1072,    224,  -1792,   -496,   3968, &
                  -424,    152,   -496,   3968,     80,   -640,   -496,   -568,     80,   -640,      8,    -64,   -640,   3968, &
                   -64,   -640,  -1792,   3968,    -64,   -640,    512,  -4096,    -64,    512,    512,   5120,  -4096,  32768, &
                   512,  -4096,   3968,   4544,   -640,   5120,    -64,    512]
  K1( 473,:) = [   3536,  -1072,   -928,   3536,   4040,  -1072,   -424,    152,   -496,   3968,     80,   -640,   -352,  -1072, &
                   224,  -1792,   -496,   3968,   -568,   -496,      8,    -64,     80,   -640,   -928,   -352,   1088,   -928, &
                  4112,   -352,   -352,   -424,   4112,   -496,    800,     80,   -928,   3536,   -352,    224,   -424,   -496, &
                  -496,    224,     80,      8,   -496,     80,   -496,   -568,     80,   -640,      8,    -64,    224,   -496, &
                  -496,     80,     80,      8,      8,    -64,     80,      8,    512,    -64,    -64,    512,   -640,    -64, &
                 -4096,    512,   4112,   4040,   -496,   3968,   -568,   4544,   -352,  -1072,   -424,   -496,    152,   -568, &
                    80,   -640,    800,     80,   5120,   -640,      8,    -64,     80,      8,    512,    -64,   4544,   3968, &
                   -64,    512,   -640,   5120,   3968,  -1792,   -640,    -64,   3968,   -640,    512,  -4096,   5120,    512, &
                 32768,  -4096,    -64,    512,   -640,    -64,  -4096,    512]
  K1( 474,:) = [   -928,   -352,   1088,   -928,   4112,   -352,   -352,   -424,   4112,   -496,    800,     80,   -928,   3536, &
                  -352,    224,   -424,   -496,   -496,    224,     80,      8,   -496,     80,   3536,  -1072,   -928,   3536, &
                  4040,  -1072,   -424,    152,   -496,   3968,     80,   -640,   -352,  -1072,    224,  -1792,   -496,   3968, &
                  -568,   -496,      8,    -64,     80,   -640,    224,   -496,   -496,     80,     80,      8,   -496,   -568, &
                    80,   -640,      8,    -64,     80,      8,      8,    -64,    -64,    512,   -640,    -64,    -64,    512, &
                   512,  -4096,   -352,  -1072,   -424,   -496,    152,   -568,   4112,   4040,   -496,   3968,   -568,   4544, &
                   800,     80,     80,   -640,   -640,   5120,     80,      8,      8,    -64,    -64,    512,   3968,  -1792, &
                  -640,    -64,   3968,   -640,   4544,   3968,    -64,    512,   -640,   5120,   5120,    512,    512,  -4096, &
                 -4096,  32768,   -640,    -64,    -64,    512,    512,  -4096]
  K1( 475,:) = [   4112,   4040,   -496,   3968,   -568,   4544,   -352,  -1072,   -424,   -496,    152,   -568,     80,   -640, &
                   800,     80,   5120,   -640,      8,    -64,     80,      8,    512,    -64,   -352,  -1072,    224,  -1792, &
                  -496,   3968,   -928,   3536,   3536,  -1072,  -1072,   4040,   -496,   3968,   -424,    152,   -640,     80, &
                    80,   -640,   -496,   -568,    -64,      8,   -928,   3536,   -352,    224,   -424,   -496,   1088,   -928, &
                  -928,   -352,   -352,   4112,   4112,   -496,   -352,   -424,     80,    800,   -496,     80,    224,   -496, &
                     8,     80,      8,    -64,     80,      8,    512,    -64,     80,   -640,   -496,   -568,    -64,      8, &
                  -496,     80,    224,   -496,      8,     80,  -4096,    512,    512,    -64,    -64,   -640,    -64,    512, &
                  -640,    -64,  -4096,    512,   -640,   5120,   3968,   4544,    512,    -64,   3968,   -640,  -1792,   3968, &
                   -64,   -640,  32768,  -4096,  -4096,    512,    512,   5120]
  K1( 476,:) = [   -352,  -1072,   -424,   -496,    152,   -568,   4112,   4040,   -496,   3968,   -568,   4544,    800,     80, &
                    80,   -640,   -640,   5120,     80,      8,      8,    -64,    -64,    512,   -928,   3536,   -352,    224, &
                  -424,   -496,   1088,   -928,   -928,   -352,   -352,   4112,   4112,   -496,   -352,   -424,     80,    800, &
                  -496,     80,    224,   -496,      8,     80,   -352,  -1072,    224,  -1792,   -496,   3968,   -928,   3536, &
                  3536,  -1072,  -1072,   4040,   -496,   3968,   -424,    152,   -640,     80,     80,   -640,   -496,   -568, &
                   -64,      8,     80,      8,      8,    -64,    -64,    512,   -496,     80,    224,   -496,      8,     80, &
                    80,   -640,   -496,   -568,    -64,      8,    512,  -4096,    -64,   -640,    512,    -64,   -640,    -64, &
                   -64,    512,    512,  -4096,   3968,   -640,  -1792,   3968,    -64,   -640,   -640,   5120,   3968,   4544, &
                   512,    -64,  -4096,  32768,    512,   5120,  -4096,    512]
  K1( 477,:) = [   -352,  -1072,    224,  -1792,   -496,   3968,   -928,   3536,   3536,  -1072,  -1072,   4040,   -496,   3968, &
                  -424,    152,   -640,     80,     80,   -640,   -496,   -568,    -64,      8,   4112,   4040,   -496,   3968, &
                  -568,   4544,   -352,  -1072,   -424,   -496,    152,   -568,     80,   -640,    800,     80,   5120,   -640, &
                     8,    -64,     80,      8,    512,    -64,   1088,   -928,   -928,   -352,   -352,   4112,   -928,   3536, &
                  -352,    224,   -424,   -496,   -352,   -424,   4112,   -496,    800,     80,    224,   -496,   -496,     80, &
                    80,      8,     80,   -640,   -496,   -568,    -64,      8,      8,    -64,     80,      8,    512,    -64, &
                   224,   -496,   -496,     80,     80,      8,    512,    -64,  -4096,    512,   -640,    -64,   -640,   5120, &
                  3968,   4544,    512,    -64,    -64,    512,   -640,    -64,  -4096,    512,  -1792,   3968,   3968,   -640, &
                  -640,    -64,  -4096,    512,  32768,  -4096,   5120,    512]
  K1( 478,:) = [   -928,   3536,   -352,    224,   -424,   -496,   1088,   -928,   -928,   -352,   -352,   4112,   4112,   -496, &
                  -352,   -424,     80,    800,   -496,     80,    224,   -496,      8,     80,   -352,  -1072,   -424,   -496, &
                   152,   -568,   4112,   4040,   -496,   3968,   -568,   4544,    800,     80,     80,   -640,   -640,   5120, &
                    80,      8,      8,    -64,    -64,    512,   -928,   3536,   3536,  -1072,  -1072,   4040,   -352,  -1072, &
                   224,  -1792,   -496,   3968,   -424,    152,   -496,   3968,     80,   -640,   -496,   -568,     80,   -640, &
                     8,    -64,   -496,     80,    224,   -496,      8,     80,     80,      8,      8,    -64,    -64,    512, &
                  -496,   -568,     80,   -640,      8,    -64,    -64,   -640,    512,  -4096,    -64,    512,   3968,   -640, &
                 -1792,   3968,    -64,   -640,   -640,    -64,    -64,    512,    512,  -4096,   3968,   4544,   -640,   5120, &
                   -64,    512,    512,   5120,  -4096,  32768,    512,  -4096]
  K1( 479,:) = [   -928,   3536,   3536,  -1072,  -1072,   4040,   -352,  -1072,    224,  -1792,   -496,   3968,   -424,    152, &
                  -496,   3968,     80,   -640,   -496,   -568,     80,   -640,      8,    -64,   1088,   -928,   -928,   -352, &
                  -352,   4112,   -928,   3536,   -352,    224,   -424,   -496,   -352,   -424,   4112,   -496,    800,     80, &
                   224,   -496,   -496,     80,     80,      8,   4112,   4040,   -496,   3968,   -568,   4544,   -352,  -1072, &
                  -424,   -496,    152,   -568,     80,   -640,    800,     80,   5120,   -640,      8,    -64,     80,      8, &
                   512,    -64,   -496,   -568,     80,   -640,      8,    -64,    224,   -496,   -496,     80,     80,      8, &
                     8,    -64,     80,      8,    512,    -64,    -64,    512,   -640,    -64,  -4096,    512,   3968,   4544, &
                  -640,   5120,    -64,    512,  -1792,   3968,   3968,   -640,   -640,    -64,    -64,    512,   -640,    -64, &
                 -4096,    512,    512,  -4096,   5120,    512,  32768,  -4096]
  K1( 480,:) = [   1088,   -928,   -928,   -352,   -352,   4112,   -928,   3536,   -352,    224,   -424,   -496,   -352,   -424, &
                  4112,   -496,    800,     80,    224,   -496,   -496,     80,     80,      8,   -928,   3536,   3536,  -1072, &
                 -1072,   4040,   -352,  -1072,    224,  -1792,   -496,   3968,   -424,    152,   -496,   3968,     80,   -640, &
                  -496,   -568,     80,   -640,      8,    -64,   -352,  -1072,   -424,   -496,    152,   -568,   4112,   4040, &
                  -496,   3968,   -568,   4544,    800,     80,     80,   -640,   -640,   5120,     80,      8,      8,    -64, &
                   -64,    512,    224,   -496,   -496,     80,     80,      8,   -496,   -568,     80,   -640,      8,    -64, &
                    80,      8,      8,    -64,    -64,    512,   -640,    -64,    -64,    512,    512,  -4096,  -1792,   3968, &
                  3968,   -640,   -640,    -64,   3968,   4544,   -640,   5120,    -64,    512,   -640,    -64,    -64,    512, &
                   512,  -4096,   5120,    512,    512,  -4096,  -4096,  32768]
  K1( 481,:) = [     -9,    -90,    -90,    558,    558,   -252,    -90,   -900,    558,  -4626,    477,    396,    558,    477, &
                  -252,    396,  -3978,   1044,  -4626,    396,    396,   1044,   1044,  -1224,     -9,    -90,    -90,    558, &
                   558,   -252,     -9,    -90,     -9,     -9,     72,    -90,     72,     -9,    -90,    -90,   -576,    558, &
                  -576,     72,     -9,    558,     72,   -252,     72,    720,     -9,    639,    -90,    558,    -90,   -900, &
                   -90,    -90,    720,   -900,   -576,   -657,    558,    558,   4608,  -4626,   -495,    153,    -90,    477, &
                  -576,    396,   -576,     72,     72,     -9,     -9,    -90,     -9,    639,    558,    558,     72,    477, &
                    72,   -738,   -252,   -252,   -576,    396,   3960,  -1224,     -9,  -3978,     72,   1044,   4608,   -576, &
                  -576,     72,     72,    720,   -657,   -738,    639,  -4626,     -9,    396,    153,     72,    558,    396, &
                    72,   1044,  -1224,   -576,    -90,   1044,    720,  -1224]
  K1( 482,:) = [    -90,     -9,    558,   -252,    -90,    558,   -900,    -90,    477,    396,    558,  -4626,  -4626,    396, &
                   396,   1044,   1044,  -1224,    558,    477,   -252,    396,  -3978,   1044,    -90,     -9,    558,   -252, &
                   -90,    558,    -90,     -9,     72,    -90,     -9,     -9,   -576,     72,     -9,    558,     72,   -252, &
                    72,     -9,    -90,    -90,   -576,    558,    720,     72,    -90,    558,     -9,    639,   -900,    -90, &
                   720,   -900,    -90,    -90,   -495,    153,    -90,    477,   -576,    396,   -576,   -657,    558,    558, &
                  4608,  -4626,   4608,   -576,   -576,     72,     72,    720,   -657,   -738,    639,  -4626,     -9,    396, &
                   153,     72,    558,    396,     72,   1044,  -1224,   -576,    -90,   1044,    720,  -1224,   -576,     72, &
                    72,     -9,     -9,    -90,     -9,    639,    558,    558,     72,    477,     72,   -738,   -252,   -252, &
                  -576,    396,   3960,  -1224,     -9,  -3978,     72,   1044]
  K1( 483,:) = [    -90,    558,     -9,    -90,   -252,    558,    558,    477,   -252,    396,  -3978,   1044,    -90,   -900, &
                   558,  -4626,    477,    396,    396,  -4626,   1044,  -1224,    396,   1044,    -90,    558,     -9,    -90, &
                  -252,    558,     72,     -9,    -90,    -90,   -576,    558,     -9,    -90,     -9,     -9,     72,    -90, &
                    72,   -576,     72,   -252,     -9,    558,   -576,     72,     72,     -9,     -9,    -90,     -9,    639, &
                   558,    558,     72,    477,     72,   -738,   -252,   -252,   -576,    396,   3960,  -1224,     -9,  -3978, &
                    72,   1044,     72,    720,     -9,    639,    -90,    558,    -90,   -900,    -90,    -90,    720,   -900, &
                  -576,   -657,    558,    558,   4608,  -4626,   -495,    153,    -90,    477,   -576,    396,   -576,   4608, &
                    72,    720,   -576,     72,   -738,   -657,     -9,    396,    639,  -4626,  -1224,   -576,    -90,   1044, &
                   720,  -1224,    153,     72,    558,    396,     72,   1044]
  K1( 484,:) = [    558,   -252,    -90,     -9,    558,    -90,  -4626,    396,    396,   1044,   1044,  -1224,   -900,    -90, &
                   477,    396,    558,  -4626,    477,    558,  -3978,   1044,   -252,    396,    558,   -252,    -90,     -9, &
                   558,    -90,   -576,     72,     -9,    558,     72,   -252,    -90,     -9,     72,    -90,     -9,     -9, &
                    -9,     72,   -576,    558,    -90,    -90,   4608,   -576,   -576,     72,     72,    720,   -657,   -738, &
                   639,  -4626,     -9,    396,    153,     72,    558,    396,     72,   1044,  -1224,   -576,    -90,   1044, &
                   720,  -1224,    720,     72,    -90,    558,     -9,    639,   -900,    -90,    720,   -900,    -90,    -90, &
                  -495,    153,    -90,    477,   -576,    396,   -576,   -657,    558,    558,   4608,  -4626,     72,   -576, &
                    -9,    -90,     72,     -9,    639,     -9,     72,    477,    558,    558,   3960,  -1224,     -9,  -3978, &
                    72,   1044,     72,   -738,   -252,   -252,   -576,    396]
  K1( 485,:) = [    558,    -90,   -252,    558,     -9,    -90,    477,    558,  -3978,   1044,   -252,    396,    396,  -4626, &
                  1044,  -1224,    396,   1044,    -90,   -900,    558,  -4626,    477,    396,    558,    -90,   -252,    558, &
                    -9,    -90,     -9,     72,   -576,    558,    -90,    -90,     72,   -576,     72,   -252,     -9,    558, &
                    -9,    -90,     -9,     -9,     72,    -90,     72,   -576,     -9,    -90,     72,     -9,    639,     -9, &
                    72,    477,    558,    558,   3960,  -1224,     -9,  -3978,     72,   1044,     72,   -738,   -252,   -252, &
                  -576,    396,   -576,   4608,     72,    720,   -576,     72,   -738,   -657,     -9,    396,    639,  -4626, &
                 -1224,   -576,    -90,   1044,    720,  -1224,    153,     72,    558,    396,     72,   1044,     72,    720, &
                    -9,    639,    -90,    558,    -90,   -900,    -90,    -90,    720,   -900,   -576,   -657,    558,    558, &
                  4608,  -4626,   -495,    153,    -90,    477,   -576,    396]
  K1( 486,:) = [   -252,    558,    558,    -90,    -90,     -9,    396,  -4626,   1044,  -1224,    396,   1044,    477,    558, &
                 -3978,   1044,   -252,    396,   -900,    -90,    477,    396,    558,  -4626,   -252,    558,    558,    -90, &
                   -90,     -9,     72,   -576,     72,   -252,     -9,    558,     -9,     72,   -576,    558,    -90,    -90, &
                   -90,     -9,     72,    -90,     -9,     -9,   -576,   4608,     72,    720,   -576,     72,   -738,   -657, &
                    -9,    396,    639,  -4626,  -1224,   -576,    -90,   1044,    720,  -1224,    153,     72,    558,    396, &
                    72,   1044,     72,   -576,     -9,    -90,     72,     -9,    639,     -9,     72,    477,    558,    558, &
                  3960,  -1224,     -9,  -3978,     72,   1044,     72,   -738,   -252,   -252,   -576,    396,    720,     72, &
                   -90,    558,     -9,    639,   -900,    -90,    720,   -900,    -90,    -90,   -495,    153,    -90,    477, &
                  -576,    396,   -576,   -657,    558,    558,   4608,  -4626]
  K1( 487,:) = [    -90,   -900,    558,  -4626,    477,    396,     -9,    -90,    -90,    558,    558,   -252,   -252,    396, &
                   558,    477,   1044,  -3978,    396,   1044,  -4626,    396,  -1224,   1044,     72,    720,     -9,    639, &
                   -90,    558,    -90,   -900,    -90,    -90,    720,   -900,   -576,   -657,    558,    558,   4608,  -4626, &
                  -495,    153,    -90,    477,   -576,    396,     -9,    -90,    -90,    558,    558,   -252,     -9,    -90, &
                    -9,     -9,     72,    -90,     72,     -9,    -90,    -90,   -576,    558,   -576,     72,     -9,    558, &
                    72,   -252,     72,     -9,   -576,     72,    -90,     -9,     72,   -738,   -252,   -252,   -576,    396, &
                    -9,    639,    558,    558,     72,    477,  -1224,   3960,     72,   1044,     -9,  -3978,   -576,     72, &
                  4608,   -576,    720,     72,    153,     72,    558,    396,     72,   1044,   -657,   -738,    639,  -4626, &
                    -9,    396,   -576,  -1224,    720,  -1224,    -90,   1044]
  K1( 488,:) = [   -900,    -90,    477,    396,    558,  -4626,    -90,     -9,    558,   -252,    -90,    558,    396,   1044, &
                 -4626,    396,  -1224,   1044,   -252,    396,    558,    477,   1044,  -3978,    720,     72,    -90,    558, &
                    -9,    639,   -900,    -90,    720,   -900,    -90,    -90,   -495,    153,    -90,    477,   -576,    396, &
                  -576,   -657,    558,    558,   4608,  -4626,    -90,     -9,    558,   -252,    -90,    558,    -90,     -9, &
                    72,    -90,     -9,     -9,   -576,     72,     -9,    558,     72,   -252,     72,     -9,    -90,    -90, &
                  -576,    558,   -576,     72,   4608,   -576,    720,     72,    153,     72,    558,    396,     72,   1044, &
                  -657,   -738,    639,  -4626,     -9,    396,   -576,  -1224,    720,  -1224,    -90,   1044,     72,     -9, &
                  -576,     72,    -90,     -9,     72,   -738,   -252,   -252,   -576,    396,     -9,    639,    558,    558, &
                    72,    477,  -1224,   3960,     72,   1044,     -9,  -3978]
  K1( 489,:) = [    558,    477,   -252,    396,  -3978,   1044,    -90,    558,     -9,    -90,   -252,    558,    558,  -4626, &
                   -90,   -900,    396,    477,   1044,  -1224,    396,  -4626,   1044,    396,   -576,     72,     72,     -9, &
                    -9,    -90,     -9,    639,    558,    558,     72,    477,     72,   -738,   -252,   -252,   -576,    396, &
                  3960,  -1224,     -9,  -3978,     72,   1044,    -90,    558,     -9,    -90,   -252,    558,     72,     -9, &
                   -90,    -90,   -576,    558,     -9,    -90,     -9,     -9,     72,    -90,     72,   -576,     72,   -252, &
                    -9,    558,     -9,    639,     72,    720,    558,    -90,   -576,   -657,    558,    558,   4608,  -4626, &
                   -90,   -900,    -90,    -90,    720,   -900,    153,   -495,   -576,    396,    -90,    477,     72,    720, &
                  -576,   4608,     72,   -576,  -1224,   -576,    -90,   1044,    720,  -1224,   -738,   -657,     -9,    396, &
                   639,  -4626,     72,    153,     72,   1044,    558,    396]
  K1( 490,:) = [  -4626,    396,    396,   1044,   1044,  -1224,    558,   -252,    -90,     -9,    558,    -90,    477,    396, &
                  -900,    -90,  -4626,    558,  -3978,   1044,    477,    558,    396,   -252,   4608,   -576,   -576,     72, &
                    72,    720,   -657,   -738,    639,  -4626,     -9,    396,    153,     72,    558,    396,     72,   1044, &
                 -1224,   -576,    -90,   1044,    720,  -1224,    558,   -252,    -90,     -9,    558,    -90,   -576,     72, &
                    -9,    558,     72,   -252,    -90,     -9,     72,    -90,     -9,     -9,     -9,     72,   -576,    558, &
                   -90,    -90,    -90,    558,    720,     72,    639,     -9,   -495,    153,    -90,    477,   -576,    396, &
                  -900,    -90,    720,   -900,    -90,    -90,   -657,   -576,   4608,  -4626,    558,    558,     -9,    -90, &
                    72,   -576,     -9,     72,   3960,  -1224,     -9,  -3978,     72,   1044,    639,     -9,     72,    477, &
                   558,    558,   -738,     72,   -576,    396,   -252,   -252]
  K1( 491,:) = [    477,    558,  -3978,   1044,   -252,    396,    558,    -90,   -252,    558,     -9,    -90,   1044,  -1224, &
                   396,  -4626,   1044,    396,    558,  -4626,    -90,   -900,    396,    477,     72,   -576,     -9,    -90, &
                    72,     -9,    639,     -9,     72,    477,    558,    558,   3960,  -1224,     -9,  -3978,     72,   1044, &
                    72,   -738,   -252,   -252,   -576,    396,    558,    -90,   -252,    558,     -9,    -90,     -9,     72, &
                  -576,    558,    -90,    -90,     72,   -576,     72,   -252,     -9,    558,     -9,    -90,     -9,     -9, &
                    72,    -90,     72,    720,   -576,   4608,     72,   -576,  -1224,   -576,    -90,   1044,    720,  -1224, &
                  -738,   -657,     -9,    396,    639,  -4626,     72,    153,     72,   1044,    558,    396,     -9,    639, &
                    72,    720,    558,    -90,   -576,   -657,    558,    558,   4608,  -4626,    -90,   -900,    -90,    -90, &
                   720,   -900,    153,   -495,   -576,    396,    -90,    477]
  K1( 492,:) = [    396,  -4626,   1044,  -1224,    396,   1044,   -252,    558,    558,    -90,    -90,     -9,  -3978,   1044, &
                   477,    558,    396,   -252,    477,    396,   -900,    -90,  -4626,    558,   -576,   4608,     72,    720, &
                  -576,     72,   -738,   -657,     -9,    396,    639,  -4626,  -1224,   -576,    -90,   1044,    720,  -1224, &
                   153,     72,    558,    396,     72,   1044,   -252,    558,    558,    -90,    -90,     -9,     72,   -576, &
                    72,   -252,     -9,    558,     -9,     72,   -576,    558,    -90,    -90,    -90,     -9,     72,    -90, &
                    -9,     -9,     -9,    -90,     72,   -576,     -9,     72,   3960,  -1224,     -9,  -3978,     72,   1044, &
                   639,     -9,     72,    477,    558,    558,   -738,     72,   -576,    396,   -252,   -252,    -90,    558, &
                   720,     72,    639,     -9,   -495,    153,    -90,    477,   -576,    396,   -900,    -90,    720,   -900, &
                   -90,    -90,   -657,   -576,   4608,  -4626,    558,    558]
  K1( 493,:) = [    558,  -4626,    -90,   -900,    396,    477,   -252,    396,    558,    477,   1044,  -3978,     -9,    -90, &
                   -90,    558,    558,   -252,   1044,    396,  -1224,   1044,  -4626,    396,     -9,    639,     72,    720, &
                   558,    -90,   -576,   -657,    558,    558,   4608,  -4626,    -90,   -900,    -90,    -90,    720,   -900, &
                   153,   -495,   -576,    396,    -90,    477,     72,     -9,   -576,     72,    -90,     -9,     72,   -738, &
                  -252,   -252,   -576,    396,     -9,    639,    558,    558,     72,    477,  -1224,   3960,     72,   1044, &
                    -9,  -3978,     -9,    -90,    -90,    558,    558,   -252,     -9,    -90,     -9,     -9,     72,    -90, &
                    72,     -9,    -90,    -90,   -576,    558,   -576,     72,     -9,    558,     72,   -252,     72,   -576, &
                   720,     72,   4608,   -576,     72,    153,     72,   1044,    558,    396,   -576,  -1224,    720,  -1224, &
                   -90,   1044,   -657,   -738,    639,  -4626,     -9,    396]
  K1( 494,:) = [    477,    396,   -900,    -90,  -4626,    558,    396,   1044,  -4626,    396,  -1224,   1044,    -90,     -9, &
                   558,   -252,    -90,    558,    396,   -252,   1044,  -3978,    558,    477,    -90,    558,    720,     72, &
                   639,     -9,   -495,    153,    -90,    477,   -576,    396,   -900,    -90,    720,   -900,    -90,    -90, &
                  -657,   -576,   4608,  -4626,    558,    558,   -576,     72,   4608,   -576,    720,     72,    153,     72, &
                   558,    396,     72,   1044,   -657,   -738,    639,  -4626,     -9,    396,   -576,  -1224,    720,  -1224, &
                   -90,   1044,    -90,     -9,    558,   -252,    -90,    558,    -90,     -9,     72,    -90,     -9,     -9, &
                  -576,     72,     -9,    558,     72,   -252,     72,     -9,    -90,    -90,   -576,    558,     -9,     72, &
                   -90,     -9,   -576,     72,   -738,     72,   -576,    396,   -252,   -252,  -1224,   3960,     72,   1044, &
                    -9,  -3978,     -9,    639,    558,    558,     72,    477]
  K1( 495,:) = [   -252,    396,    558,    477,   1044,  -3978,    558,  -4626,    -90,   -900,    396,    477,    -90,    558, &
                    -9,    -90,   -252,    558,  -1224,   1044,   1044,    396,    396,  -4626,     72,     -9,   -576,     72, &
                   -90,     -9,     72,   -738,   -252,   -252,   -576,    396,     -9,    639,    558,    558,     72,    477, &
                 -1224,   3960,     72,   1044,     -9,  -3978,     -9,    639,     72,    720,    558,    -90,   -576,   -657, &
                   558,    558,   4608,  -4626,    -90,   -900,    -90,    -90,    720,   -900,    153,   -495,   -576,    396, &
                   -90,    477,    -90,    558,     -9,    -90,   -252,    558,     72,     -9,    -90,    -90,   -576,    558, &
                    -9,    -90,     -9,     -9,     72,    -90,     72,   -576,     72,   -252,     -9,    558,    720,     72, &
                    72,   -576,   -576,   4608,   -576,  -1224,    720,  -1224,    -90,   1044,     72,    153,     72,   1044, &
                   558,    396,   -738,   -657,     -9,    396,    639,  -4626]
  K1( 496,:) = [    396,   1044,  -4626,    396,  -1224,   1044,    477,    396,   -900,    -90,  -4626,    558,    558,   -252, &
                   -90,     -9,    558,    -90,   1044,  -3978,    396,   -252,    477,    558,   -576,     72,   4608,   -576, &
                   720,     72,    153,     72,    558,    396,     72,   1044,   -657,   -738,    639,  -4626,     -9,    396, &
                  -576,  -1224,    720,  -1224,    -90,   1044,    -90,    558,    720,     72,    639,     -9,   -495,    153, &
                   -90,    477,   -576,    396,   -900,    -90,    720,   -900,    -90,    -90,   -657,   -576,   4608,  -4626, &
                   558,    558,    558,   -252,    -90,     -9,    558,    -90,   -576,     72,     -9,    558,     72,   -252, &
                   -90,     -9,     72,    -90,     -9,     -9,     -9,     72,   -576,    558,    -90,    -90,    -90,     -9, &
                    -9,     72,     72,   -576,  -1224,   3960,     72,   1044,     -9,  -3978,   -738,     72,   -576,    396, &
                  -252,   -252,    639,     -9,     72,    477,    558,    558]
  K1( 497,:) = [  -3978,   1044,    477,    558,    396,   -252,   1044,  -1224,    396,  -4626,   1044,    396,    558,    -90, &
                  -252,    558,     -9,    -90,  -4626,    558,    396,    477,    -90,   -900,     -9,    -90,     72,   -576, &
                    -9,     72,   3960,  -1224,     -9,  -3978,     72,   1044,    639,     -9,     72,    477,    558,    558, &
                  -738,     72,   -576,    396,   -252,   -252,     72,    720,   -576,   4608,     72,   -576,  -1224,   -576, &
                   -90,   1044,    720,  -1224,   -738,   -657,     -9,    396,    639,  -4626,     72,    153,     72,   1044, &
                   558,    396,    558,    -90,   -252,    558,     -9,    -90,     -9,     72,   -576,    558,    -90,    -90, &
                    72,   -576,     72,   -252,     -9,    558,     -9,    -90,     -9,     -9,     72,    -90,    639,     -9, &
                   558,    -90,     72,    720,   -657,   -576,   4608,  -4626,    558,    558,    153,   -495,   -576,    396, &
                   -90,    477,    -90,   -900,    -90,    -90,    720,   -900]
  K1( 498,:) = [   1044,  -1224,    396,  -4626,   1044,    396,  -3978,   1044,    477,    558,    396,   -252,   -252,    558, &
                   558,    -90,    -90,     -9,    396,    477,  -4626,    558,   -900,    -90,     72,    720,   -576,   4608, &
                    72,   -576,  -1224,   -576,    -90,   1044,    720,  -1224,   -738,   -657,     -9,    396,    639,  -4626, &
                    72,    153,     72,   1044,    558,    396,     -9,    -90,     72,   -576,     -9,     72,   3960,  -1224, &
                    -9,  -3978,     72,   1044,    639,     -9,     72,    477,    558,    558,   -738,     72,   -576,    396, &
                  -252,   -252,   -252,    558,    558,    -90,    -90,     -9,     72,   -576,     72,   -252,     -9,    558, &
                    -9,     72,   -576,    558,    -90,    -90,    -90,     -9,     72,    -90,     -9,     -9,    558,    -90, &
                   639,     -9,    720,     72,    153,   -495,   -576,    396,    -90,    477,   -657,   -576,   4608,  -4626, &
                   558,    558,   -900,    -90,    720,   -900,    -90,    -90]
  K1( 499,:) = [  -4626,    558,    396,    477,    -90,   -900,    396,   -252,   1044,  -3978,    558,    477,   1044,    396, &
                 -1224,   1044,  -4626,    396,     -9,    -90,    -90,    558,    558,   -252,    639,     -9,    558,    -90, &
                    72,    720,   -657,   -576,   4608,  -4626,    558,    558,    153,   -495,   -576,    396,    -90,    477, &
                   -90,   -900,    -90,    -90,    720,   -900,     -9,     72,    -90,     -9,   -576,     72,   -738,     72, &
                  -576,    396,   -252,   -252,  -1224,   3960,     72,   1044,     -9,  -3978,     -9,    639,    558,    558, &
                    72,    477,     72,   -576,    720,     72,   4608,   -576,     72,    153,     72,   1044,    558,    396, &
                  -576,  -1224,    720,  -1224,    -90,   1044,   -657,   -738,    639,  -4626,     -9,    396,     -9,    -90, &
                   -90,    558,    558,   -252,     -9,    -90,     -9,     -9,     72,    -90,     72,     -9,    -90,    -90, &
                  -576,    558,   -576,     72,     -9,    558,     72,   -252]
  K1( 500,:) = [    396,    477,  -4626,    558,   -900,    -90,   1044,    396,  -1224,   1044,  -4626,    396,    396,   -252, &
                  1044,  -3978,    558,    477,    -90,     -9,    558,   -252,    -90,    558,    558,    -90,    639,     -9, &
                   720,     72,    153,   -495,   -576,    396,    -90,    477,   -657,   -576,   4608,  -4626,    558,    558, &
                  -900,    -90,    720,   -900,    -90,    -90,     72,   -576,    720,     72,   4608,   -576,     72,    153, &
                    72,   1044,    558,    396,   -576,  -1224,    720,  -1224,    -90,   1044,   -657,   -738,    639,  -4626, &
                    -9,    396,     -9,     72,    -90,     -9,   -576,     72,   -738,     72,   -576,    396,   -252,   -252, &
                 -1224,   3960,     72,   1044,     -9,  -3978,     -9,    639,    558,    558,     72,    477,    -90,     -9, &
                   558,   -252,    -90,    558,    -90,     -9,     72,    -90,     -9,     -9,   -576,     72,     -9,    558, &
                    72,   -252,     72,     -9,    -90,    -90,   -576,    558]
  K1( 501,:) = [    396,   -252,   1044,  -3978,    558,    477,  -4626,    558,    396,    477,    -90,   -900,  -1224,   1044, &
                  1044,    396,    396,  -4626,    -90,    558,     -9,    -90,   -252,    558,     -9,     72,    -90,     -9, &
                  -576,     72,   -738,     72,   -576,    396,   -252,   -252,  -1224,   3960,     72,   1044,     -9,  -3978, &
                    -9,    639,    558,    558,     72,    477,    639,     -9,    558,    -90,     72,    720,   -657,   -576, &
                  4608,  -4626,    558,    558,    153,   -495,   -576,    396,    -90,    477,    -90,   -900,    -90,    -90, &
                   720,   -900,    720,     72,     72,   -576,   -576,   4608,   -576,  -1224,    720,  -1224,    -90,   1044, &
                    72,    153,     72,   1044,    558,    396,   -738,   -657,     -9,    396,    639,  -4626,    -90,    558, &
                    -9,    -90,   -252,    558,     72,     -9,    -90,    -90,   -576,    558,     -9,    -90,     -9,     -9, &
                    72,    -90,     72,   -576,     72,   -252,     -9,    558]
  K1( 502,:) = [   1044,    396,  -1224,   1044,  -4626,    396,    396,    477,  -4626,    558,   -900,    -90,   1044,  -3978, &
                   396,   -252,    477,    558,    558,   -252,    -90,     -9,    558,    -90,     72,   -576,    720,     72, &
                  4608,   -576,     72,    153,     72,   1044,    558,    396,   -576,  -1224,    720,  -1224,    -90,   1044, &
                  -657,   -738,    639,  -4626,     -9,    396,    558,    -90,    639,     -9,    720,     72,    153,   -495, &
                  -576,    396,    -90,    477,   -657,   -576,   4608,  -4626,    558,    558,   -900,    -90,    720,   -900, &
                   -90,    -90,    -90,     -9,     -9,     72,     72,   -576,  -1224,   3960,     72,   1044,     -9,  -3978, &
                  -738,     72,   -576,    396,   -252,   -252,    639,     -9,     72,    477,    558,    558,    558,   -252, &
                   -90,     -9,    558,    -90,   -576,     72,     -9,    558,     72,   -252,    -90,     -9,     72,    -90, &
                    -9,     -9,     -9,     72,   -576,    558,    -90,    -90]
  K1( 503,:) = [   1044,  -3978,    396,   -252,    477,    558,  -1224,   1044,   1044,    396,    396,  -4626,  -4626,    558, &
                   396,    477,    -90,   -900,    558,    -90,   -252,    558,     -9,    -90,    -90,     -9,     -9,     72, &
                    72,   -576,  -1224,   3960,     72,   1044,     -9,  -3978,   -738,     72,   -576,    396,   -252,   -252, &
                   639,     -9,     72,    477,    558,    558,    720,     72,     72,   -576,   -576,   4608,   -576,  -1224, &
                   720,  -1224,    -90,   1044,     72,    153,     72,   1044,    558,    396,   -738,   -657,     -9,    396, &
                   639,  -4626,    639,     -9,    558,    -90,     72,    720,   -657,   -576,   4608,  -4626,    558,    558, &
                   153,   -495,   -576,    396,    -90,    477,    -90,   -900,    -90,    -90,    720,   -900,    558,    -90, &
                  -252,    558,     -9,    -90,     -9,     72,   -576,    558,    -90,    -90,     72,   -576,     72,   -252, &
                    -9,    558,     -9,    -90,     -9,     -9,     72,    -90]
  K1( 504,:) = [  -1224,   1044,   1044,    396,    396,  -4626,   1044,  -3978,    396,   -252,    477,    558,    396,    477, &
                 -4626,    558,   -900,    -90,   -252,    558,    558,    -90,    -90,     -9,    720,     72,     72,   -576, &
                  -576,   4608,   -576,  -1224,    720,  -1224,    -90,   1044,     72,    153,     72,   1044,    558,    396, &
                  -738,   -657,     -9,    396,    639,  -4626,    -90,     -9,     -9,     72,     72,   -576,  -1224,   3960, &
                    72,   1044,     -9,  -3978,   -738,     72,   -576,    396,   -252,   -252,    639,     -9,     72,    477, &
                   558,    558,    558,    -90,    639,     -9,    720,     72,    153,   -495,   -576,    396,    -90,    477, &
                  -657,   -576,   4608,  -4626,    558,    558,   -900,    -90,    720,   -900,    -90,    -90,   -252,    558, &
                   558,    -90,    -90,     -9,     72,   -576,     72,   -252,     -9,    558,     -9,     72,   -576,    558, &
                   -90,    -90,    -90,     -9,     72,    -90,     -9,     -9]
  K1( 505,:) = [     -9,    -90,    -90,    558,    558,   -252,     72,    720,   -576,   4608,     72,   -576,     -9,    -90, &
                    72,   -576,     -9,     72,    639,    558,     -9,     72,    -90,    720,     72,    720,    720,  -4464, &
                 -4464,   2016,     72,    720,     72,     72,   -576,    720,   -576,     72,    720,    720,   4608,  -4464, &
                  4608,   -576,     72,  -4464,   -576,   2016,     72,    720,    153,   -495,   -657,    882,     -9,    -90, &
                    -9,     -9,     72,    -90,   -576,   -495,    639,    639,   4608,  -4545,    234,   -414,     -9,   -171, &
                  -576,   1206,    153,   -657,   -495,   -414,    153,   -495,     72,     -9,    -90,    -90,   -576,    558, &
                    72,    882,    558,    558,   -576,   1206,  -1143,   4041,     72,   1206,     72,  -3978,   -495,    882, &
                  -414,   4041,   -495,   -414,   -576,     72,     -9,    558,     72,   -252,   -576,   -495,    -90,    477, &
                    72,  -3978,    234,   -414,    720,    396,    720,   1044]
  K1( 506,:) = [    -90,     -9,    558,   -252,    -90,    558,    720,     72,     72,   -576,   -576,   4608,    639,    558, &
                    -9,     72,    -90,    720,     -9,    -90,     72,   -576,     -9,     72,    720,     72,  -4464,   2016, &
                   720,  -4464,    720,     72,   -576,    720,     72,     72,   4608,   -576,     72,  -4464,   -576,   2016, &
                  -576,     72,    720,    720,   4608,  -4464,    720,     72,   -657,    882,    153,   -495,    -90,     -9, &
                    72,    -90,     -9,     -9,    234,   -414,     -9,   -171,   -576,   1206,   -576,   -495,    639,    639, &
                  4608,  -4545,   -495,    882,   -414,   4041,   -495,   -414,   -576,     72,     -9,    558,     72,   -252, &
                  -576,   -495,    -90,    477,     72,  -3978,    234,   -414,    720,    396,    720,   1044,    153,   -657, &
                  -495,   -414,    153,   -495,     72,     -9,    -90,    -90,   -576,    558,     72,    882,    558,    558, &
                  -576,   1206,  -1143,   4041,     72,   1206,     72,  -3978]
  K1( 507,:) = [    -90,    558,     -9,    -90,   -252,    558,     -9,    -90,     72,   -576,     -9,     72,     72,    720, &
                  -576,   4608,     72,   -576,    558,    639,    -90,    720,     -9,     72,    720,  -4464,     72,    720, &
                  2016,  -4464,   -576,     72,    720,    720,   4608,  -4464,     72,    720,     72,     72,   -576,    720, &
                  -576,   4608,   -576,   2016,     72,  -4464,    153,   -657,   -495,   -414,    153,   -495,     72,     -9, &
                   -90,    -90,   -576,    558,     72,    882,    558,    558,   -576,   1206,  -1143,   4041,     72,   1206, &
                    72,  -3978,     72,    720,    153,   -495,   -657,    882,     -9,    -90,     -9,     -9,     72,    -90, &
                  -576,   -495,    639,    639,   4608,  -4545,    234,   -414,     -9,   -171,   -576,   1206,    882,   -495, &
                  -495,   -414,   -414,   4041,     72,   -576,     72,   -252,     -9,    558,    234,   -414,    720,    396, &
                   720,   1044,   -576,   -495,    -90,    477,     72,  -3978]
  K1( 508,:) = [    558,   -252,    -90,     -9,    558,    -90,    639,    558,     -9,     72,    -90,    720,    720,     72, &
                    72,   -576,   -576,   4608,    -90,     -9,     -9,     72,     72,   -576,  -4464,   2016,    720,     72, &
                 -4464,    720,   4608,   -576,     72,  -4464,   -576,   2016,    720,     72,   -576,    720,     72,     72, &
                    72,   -576,   4608,  -4464,    720,    720,   -495,    882,   -414,   4041,   -495,   -414,   -576,     72, &
                    -9,    558,     72,   -252,   -576,   -495,    -90,    477,     72,  -3978,    234,   -414,    720,    396, &
                   720,   1044,    720,     72,   -657,    882,    153,   -495,    -90,     -9,     72,    -90,     -9,     -9, &
                   234,   -414,     -9,   -171,   -576,   1206,   -576,   -495,    639,    639,   4608,  -4545,   -657,    153, &
                   153,   -495,   -495,   -414,     -9,     72,   -576,    558,    -90,    -90,  -1143,   4041,     72,   1206, &
                    72,  -3978,     72,    882,    558,    558,   -576,   1206]
  K1( 509,:) = [    558,    -90,   -252,    558,     -9,    -90,    -90,     -9,     -9,     72,     72,   -576,    558,    639, &
                   -90,    720,     -9,     72,     72,    720,   -576,   4608,     72,   -576,  -4464,    720,   2016,  -4464, &
                    72,    720,     72,   -576,   4608,  -4464,    720,    720,   -576,   4608,   -576,   2016,     72,  -4464, &
                    72,    720,     72,     72,   -576,    720,   -657,    153,    153,   -495,   -495,   -414,     -9,     72, &
                  -576,    558,    -90,    -90,  -1143,   4041,     72,   1206,     72,  -3978,     72,    882,    558,    558, &
                  -576,   1206,    882,   -495,   -495,   -414,   -414,   4041,     72,   -576,     72,   -252,     -9,    558, &
                   234,   -414,    720,    396,    720,   1044,   -576,   -495,    -90,    477,     72,  -3978,     72,    720, &
                   153,   -495,   -657,    882,     -9,    -90,     -9,     -9,     72,    -90,   -576,   -495,    639,    639, &
                  4608,  -4545,    234,   -414,     -9,   -171,   -576,   1206]
  K1( 510,:) = [   -252,    558,    558,    -90,    -90,     -9,    558,    639,    -90,    720,     -9,     72,    -90,     -9, &
                    -9,     72,     72,   -576,    720,     72,     72,   -576,   -576,   4608,   2016,  -4464,  -4464,    720, &
                   720,     72,   -576,   4608,   -576,   2016,     72,  -4464,     72,   -576,   4608,  -4464,    720,    720, &
                   720,     72,   -576,    720,     72,     72,    882,   -495,   -495,   -414,   -414,   4041,     72,   -576, &
                    72,   -252,     -9,    558,    234,   -414,    720,    396,    720,   1044,   -576,   -495,    -90,    477, &
                    72,  -3978,   -657,    153,    153,   -495,   -495,   -414,     -9,     72,   -576,    558,    -90,    -90, &
                 -1143,   4041,     72,   1206,     72,  -3978,     72,    882,    558,    558,   -576,   1206,    720,     72, &
                  -657,    882,    153,   -495,    -90,     -9,     72,    -90,     -9,     -9,    234,   -414,     -9,   -171, &
                  -576,   1206,   -576,   -495,    639,    639,   4608,  -4545]
  K1( 511,:) = [     -9,    -90,     72,   -576,     -9,     72,    -90,   -900,     -9,   -657,    639,   -738,   -576,   -495, &
                    72,    153,   3960,  -1224,   -657,    153,   -738,     72,  -1224,   -576,     72,    720,   -576,   4608, &
                    72,   -576,   -576,  -5760,   -576,   -576,   4608,  -5760,   -576,  -1224,     72,     72,   4608,  -5112, &
                 -1224,   3960,   -576,    720,   -576,  -4464,     -9,    -90,     72,   -576,     -9,     72,     72,    720, &
                    72,     72,   -576,    720,     72,    153,     -9,     -9,   -576,    639,    153,   -495,     72,    -90, &
                    72,    558,   -576,    234,     72,   -576,  -1143,    234,     72,    153,     -9,     -9,   -576,    639, &
                    -9,   -657,    -90,    -90,     72,   -171,   3960,  -1224,     72,  -4545,     -9,   1206,   -495,   -414, &
                   882,   -495,   4041,   -414,    153,   -495,     72,    -90,     72,    558,   -657,   -576,    720,   -900, &
                    -9,    477,  -1224,   -576,    720,  -4626,    -90,    396]
  K1( 512,:) = [    -90,     -9,     -9,     72,     72,   -576,   -900,    -90,    639,   -738,     -9,   -657,   -657,    153, &
                  -738,     72,  -1224,   -576,   -576,   -495,     72,    153,   3960,  -1224,    720,     72,     72,   -576, &
                  -576,   4608,  -5760,   -576,   4608,  -5760,   -576,   -576,  -1224,   3960,   -576,    720,   -576,  -4464, &
                  -576,  -1224,     72,     72,   4608,  -5112,    -90,     -9,     -9,     72,     72,   -576,    720,     72, &
                  -576,    720,     72,     72,    153,   -495,     72,    -90,     72,    558,     72,    153,     -9,     -9, &
                  -576,    639,   -495,   -414,    882,   -495,   4041,   -414,    153,   -495,     72,    -90,     72,    558, &
                  -657,   -576,    720,   -900,     -9,    477,  -1224,   -576,    720,  -4626,    -90,    396,   -576,    234, &
                    72,   -576,  -1143,    234,     72,    153,     -9,     -9,   -576,    639,     -9,   -657,    -90,    -90, &
                    72,   -171,   3960,  -1224,     72,  -4545,     -9,   1206]
  K1( 513,:) = [     -9,     72,    -90,     -9,   -576,     72,    -90,    720,    558,    639,     72,     -9,    558,    -90, &
                  -252,    558,     -9,    -90,   4608,   -576,   -576,     72,     72,    720,     72,   -576,    720,     72, &
                  4608,   -576,   -576,   4608,   4608,   4608,   4608,   -576,     72,   -576,   -576,   -576,   -576,     72, &
                  4608,   -576,   -576,     72,     72,    720,     -9,     72,    -90,     -9,   -576,     72,     72,   -576, &
                  -576,   -576,   -576,     72,     -9,     72,     72,     72,     72,     -9,   -576,     72,     72,     -9, &
                    -9,    -90,    639,     -9,    558,    -90,     72,    720,     -9,     72,     72,     72,     72,     -9, &
                   -90,    720,    720,    720,    720,    -90,     72,    720,     -9,    639,    -90,    558,   4608,   -576, &
                  -576,     72,     72,    720,   -576,     72,     72,     -9,     -9,    -90,     72,     -9,    720,    -90, &
                   639,    558,     -9,    -90,    -90,    558,    558,   -252]
  K1( 514,:) = [     -9,    -90,    -90,    558,    558,   -252,    -90,   -900,    558,  -4626,    477,    396,    558,    477, &
                  -252,    396,  -3978,   1044,  -4626,    396,    396,   1044,   1044,  -1224,     72,    720,    720,  -4464, &
                 -4464,   2016,   -576,  -5760,   4608, -36864,   -576,   4608,     72,    720,   -576,   4608,     72,   -576, &
                 -5112,  -4464,     72,   -576,    720,  -5760,     -9,    -90,    -90,    558,    558,   -252,     72,    720, &
                  -576,   4608,     72,   -576,     -9,    -90,     72,   -576,     -9,     72,    639,    558,     -9,     72, &
                   -90,    720,    639,   -171,    558,    477,   1206,    396,     -9,    -90,     72,   -576,     -9,     72, &
                   -90,   -900,    720,  -5760,    -90,    720,  -4545,  -4626,    639,  -5112,    558,  -4464,  -4545,   1206, &
                  1206,  -3978,  -3978,   1044,    639,    558,     -9,     72,    -90,    720,   -171,    477,    -90,    720, &
                   558,  -4464,   1206,    396,    558,  -4464,   -252,   2016]
  K1( 515,:) = [     72,     -9,   -576,     72,    -90,     -9,    720,    -90,     72,     -9,    558,    639,   4608,   -576, &
                  -576,     72,     72,    720,    558,    -90,   -252,    558,     -9,    -90,   -576,     72,   4608,   -576, &
                   720,     72,   4608,   -576,   4608,   -576,   4608,   4608,   4608,   -576,   -576,     72,     72,    720, &
                    72,   -576,   -576,   -576,   -576,     72,     72,     -9,   -576,     72,    -90,     -9,   -576,     72, &
                  -576,     72,   -576,   -576,   -576,     72,     72,     -9,     -9,    -90,     -9,     72,     72,     72, &
                    72,     -9,   4608,   -576,   -576,     72,     72,    720,   -576,     72,     72,     -9,     -9,    -90, &
                    72,     -9,    720,    -90,    639,    558,     -9,    -90,    -90,    558,    558,   -252,    639,     -9, &
                   558,    -90,     72,    720,     -9,     72,     72,     72,     72,     -9,    -90,    720,    720,    720, &
                   720,    -90,     72,    720,     -9,    639,    -90,    558]
  K1( 516,:) = [    -90,     -9,    558,   -252,    -90,    558,   -900,    -90,    477,    396,    558,  -4626,  -4626,    396, &
                   396,   1044,   1044,  -1224,    558,    477,   -252,    396,  -3978,   1044,    720,     72,  -4464,   2016, &
                   720,  -4464,  -5760,   -576,   -576,   4608,   4608, -36864,  -5112,  -4464,     72,   -576,    720,  -5760, &
                    72,    720,   -576,   4608,     72,   -576,    -90,     -9,    558,   -252,    -90,    558,    720,     72, &
                    72,   -576,   -576,   4608,    639,    558,     -9,     72,    -90,    720,     -9,    -90,     72,   -576, &
                    -9,     72,  -4545,   1206,   1206,  -3978,  -3978,   1044,    639,    558,     -9,     72,    -90,    720, &
                  -171,    477,    -90,    720,    558,  -4464,   1206,    396,    558,  -4464,   -252,   2016,    639,   -171, &
                   558,    477,   1206,    396,     -9,    -90,     72,   -576,     -9,     72,    -90,   -900,    720,  -5760, &
                   -90,    720,  -4545,  -4626,    639,  -5112,    558,  -4464]
  K1( 517,:) = [     72,   -576,     -9,    -90,     72,     -9,   -576,   -495,     72,    153,   3960,  -1224,    -90,   -900, &
                    -9,   -657,    639,   -738,    153,   -657,  -1224,   -576,   -738,     72,   -576,   4608,     72,    720, &
                  -576,     72,   -576,  -1224,     72,     72,   4608,  -5112,   -576,  -5760,   -576,   -576,   4608,  -5760, &
                  3960,  -1224,   -576,  -4464,   -576,    720,   -576,    234,     72,   -576,  -1143,    234,     72,    153, &
                    -9,     -9,   -576,    639,     -9,   -657,    -90,    -90,     72,   -171,   3960,  -1224,     72,  -4545, &
                    -9,   1206,     -9,    -90,     72,   -576,     -9,     72,     72,    720,     72,     72,   -576,    720, &
                    72,    153,     -9,     -9,   -576,    639,    153,   -495,     72,    -90,     72,    558,   -414,   -495, &
                  4041,   -414,    882,   -495,   -495,    153,     72,    558,     72,    -90,  -1224,   -576,    720,  -4626, &
                   -90,    396,   -657,   -576,    720,   -900,     -9,    477]
  K1( 518,:) = [     -9,     72,    -90,     -9,   -576,     72,   -657,    153,   -738,     72,  -1224,   -576,   -900,    -90, &
                   639,   -738,     -9,   -657,   -495,   -576,   3960,  -1224,     72,    153,     72,   -576,    720,     72, &
                  4608,   -576,  -1224,   3960,   -576,    720,   -576,  -4464,  -5760,   -576,   4608,  -5760,   -576,   -576, &
                 -1224,   -576,   4608,  -5112,     72,     72,   -495,   -414,    882,   -495,   4041,   -414,    153,   -495, &
                    72,    -90,     72,    558,   -657,   -576,    720,   -900,     -9,    477,  -1224,   -576,    720,  -4626, &
                   -90,    396,    -90,     -9,     -9,     72,     72,   -576,    720,     72,   -576,    720,     72,     72, &
                   153,   -495,     72,    -90,     72,    558,     72,    153,     -9,     -9,   -576,    639,    234,   -576, &
                 -1143,    234,     72,   -576,    153,     72,   -576,    639,     -9,     -9,   3960,  -1224,     72,  -4545, &
                    -9,   1206,     -9,   -657,    -90,    -90,     72,   -171]
  K1( 519,:) = [    -90,     -9,     -9,     72,     72,   -576,    558,    -90,   -252,    558,     -9,    -90,    -90,    720, &
                   558,    639,     72,     -9,   -576,   4608,     72,    720,   -576,     72,    720,     72,     72,   -576, &
                  -576,   4608,     72,   -576,   -576,   -576,   -576,     72,   -576,   4608,   4608,   4608,   4608,   -576, &
                  -576,   4608,     72,    720,   -576,     72,    639,     -9,    558,    -90,     72,    720,     -9,     72, &
                    72,     72,     72,     -9,    -90,    720,    720,    720,    720,    -90,     72,    720,     -9,    639, &
                   -90,    558,     -9,     72,    -90,     -9,   -576,     72,     72,   -576,   -576,   -576,   -576,     72, &
                    -9,     72,     72,     72,     72,     -9,   -576,     72,     72,     -9,     -9,    -90,   -576,   4608, &
                    72,    720,   -576,     72,     72,   -576,     -9,    -90,     72,     -9,     -9,    -90,    -90,    558, &
                   558,   -252,     72,     -9,    720,    -90,    639,    558]
  K1( 520,:) = [    -90,    558,     -9,    -90,   -252,    558,    558,    477,   -252,    396,  -3978,   1044,    -90,   -900, &
                   558,  -4626,    477,    396,    396,  -4626,   1044,  -1224,    396,   1044,    720,  -4464,     72,    720, &
                  2016,  -4464,     72,    720,   -576,   4608,     72,   -576,   -576,  -5760,   4608, -36864,   -576,   4608, &
                 -4464,  -5112,    720,  -5760,     72,   -576,    639,   -171,    558,    477,   1206,    396,     -9,    -90, &
                    72,   -576,     -9,     72,    -90,   -900,    720,  -5760,    -90,    720,  -4545,  -4626,    639,  -5112, &
                   558,  -4464,     -9,    -90,    -90,    558,    558,   -252,     72,    720,   -576,   4608,     72,   -576, &
                    -9,    -90,     72,   -576,     -9,     72,    639,    558,     -9,     72,    -90,    720,   1206,  -4545, &
                 -3978,   1044,   1206,  -3978,    558,    639,    -90,    720,     -9,     72,   1206,    396,    558,  -4464, &
                  -252,   2016,   -171,    477,    -90,    720,    558,  -4464]
  K1( 521,:) = [   -576,     72,     72,     -9,     -9,    -90,   4608,   -576,   -576,     72,     72,    720,    720,    -90, &
                    72,     -9,    558,    639,    -90,    558,     -9,    -90,   -252,    558,   4608,   -576,   -576,     72, &
                    72,    720,   4608,   -576,   -576,     72,     72,    720,   4608,   -576,   4608,   -576,   4608,   4608, &
                  -576,     72,   -576,     72,   -576,   -576,   4608,   -576,   -576,     72,     72,    720,   -576,     72, &
                    72,     -9,     -9,    -90,     72,     -9,    720,    -90,    639,    558,     -9,    -90,    -90,    558, &
                   558,   -252,     72,     -9,   -576,     72,    -90,     -9,   -576,     72,   -576,     72,   -576,   -576, &
                  -576,     72,     72,     -9,     -9,    -90,     -9,     72,     72,     72,     72,     -9,     -9,    639, &
                    72,    720,    558,    -90,     72,     -9,     72,     -9,     72,     72,     72,    720,     -9,    639, &
                   -90,    558,    -90,    720,    720,    720,    720,    -90]
  K1( 522,:) = [    558,   -252,    -90,     -9,    558,    -90,  -4626,    396,    396,   1044,   1044,  -1224,   -900,    -90, &
                   477,    396,    558,  -4626,    477,    558,  -3978,   1044,   -252,    396,  -4464,   2016,    720,     72, &
                 -4464,    720,  -5112,  -4464,     72,   -576,    720,  -5760,  -5760,   -576,   -576,   4608,   4608, -36864, &
                   720,     72,     72,   -576,   -576,   4608,  -4545,   1206,   1206,  -3978,  -3978,   1044,    639,    558, &
                    -9,     72,    -90,    720,   -171,    477,    -90,    720,    558,  -4464,   1206,    396,    558,  -4464, &
                  -252,   2016,    -90,     -9,    558,   -252,    -90,    558,    720,     72,     72,   -576,   -576,   4608, &
                   639,    558,     -9,     72,    -90,    720,     -9,    -90,     72,   -576,     -9,     72,   -171,    639, &
                  1206,    396,    558,    477,    -90,     -9,     -9,     72,     72,   -576,  -4545,  -4626,    639,  -5112, &
                   558,  -4464,    -90,   -900,    720,  -5760,    -90,    720]
  K1( 523,:) = [   -576,     72,     72,     -9,     -9,    -90,   -495,   -576,   3960,  -1224,     72,    153,    153,   -657, &
                 -1224,   -576,   -738,     72,    -90,   -900,     -9,   -657,    639,   -738,   4608,   -576,   -576,     72, &
                    72,    720,  -1224,   -576,   4608,  -5112,     72,     72,   3960,  -1224,   -576,  -4464,   -576,    720, &
                  -576,  -5760,   -576,   -576,   4608,  -5760,    234,   -576,  -1143,    234,     72,   -576,    153,     72, &
                  -576,    639,     -9,     -9,   3960,  -1224,     72,  -4545,     -9,   1206,     -9,   -657,    -90,    -90, &
                    72,   -171,   -414,   -495,   4041,   -414,    882,   -495,   -495,    153,     72,    558,     72,    -90, &
                 -1224,   -576,    720,  -4626,    -90,    396,   -657,   -576,    720,   -900,     -9,    477,     -9,    -90, &
                    72,   -576,     -9,     72,     72,    720,     72,     72,   -576,    720,     72,    153,     -9,     -9, &
                  -576,    639,    153,   -495,     72,    -90,     72,    558]
  K1( 524,:) = [     72,     -9,   -576,     72,    -90,     -9,    153,   -657,  -1224,   -576,   -738,     72,   -495,   -576, &
                  3960,  -1224,     72,    153,   -900,    -90,    639,   -738,     -9,   -657,   -576,     72,   4608,   -576, &
                   720,     72,   3960,  -1224,   -576,  -4464,   -576,    720,  -1224,   -576,   4608,  -5112,     72,     72, &
                 -5760,   -576,   4608,  -5760,   -576,   -576,   -414,   -495,   4041,   -414,    882,   -495,   -495,    153, &
                    72,    558,     72,    -90,  -1224,   -576,    720,  -4626,    -90,    396,   -657,   -576,    720,   -900, &
                    -9,    477,    234,   -576,  -1143,    234,     72,   -576,    153,     72,   -576,    639,     -9,     -9, &
                  3960,  -1224,     72,  -4545,     -9,   1206,     -9,   -657,    -90,    -90,     72,   -171,    -90,     -9, &
                    -9,     72,     72,   -576,    720,     72,   -576,    720,     72,     72,    153,   -495,     72,    -90, &
                    72,    558,     72,    153,     -9,     -9,   -576,    639]
  K1( 525,:) = [     -9,    -90,     72,   -576,     -9,     72,    -90,    558,     -9,    -90,   -252,    558,   -576,   4608, &
                    72,    720,   -576,     72,    -90,    720,    558,    639,     72,     -9,     72,    720,   -576,   4608, &
                    72,   -576,   -576,     72,   -576,     72,   -576,   -576,   -576,   4608,     72,    720,   -576,     72, &
                  -576,   4608,   4608,   4608,   4608,   -576,     -9,    639,     72,    720,    558,    -90,     72,     -9, &
                    72,     -9,     72,     72,     72,    720,     -9,    639,    -90,    558,    -90,    720,    720,    720, &
                   720,    -90,   -576,   4608,     72,    720,   -576,     72,     72,   -576,     -9,    -90,     72,     -9, &
                    -9,    -90,    -90,    558,    558,   -252,     72,     -9,    720,    -90,    639,    558,     -9,     72, &
                   -90,     -9,   -576,     72,     72,   -576,   -576,   -576,   -576,     72,     -9,     72,     72,     72, &
                    72,     -9,   -576,     72,     72,     -9,     -9,    -90]
  K1( 526,:) = [    558,    -90,   -252,    558,     -9,    -90,    477,    558,  -3978,   1044,   -252,    396,    396,  -4626, &
                  1044,  -1224,    396,   1044,    -90,   -900,    558,  -4626,    477,    396,  -4464,    720,   2016,  -4464, &
                    72,    720,    720,     72,     72,   -576,   -576,   4608,  -4464,  -5112,    720,  -5760,     72,   -576, &
                  -576,  -5760,   4608, -36864,   -576,   4608,   -171,    639,   1206,    396,    558,    477,    -90,     -9, &
                    -9,     72,     72,   -576,  -4545,  -4626,    639,  -5112,    558,  -4464,    -90,   -900,    720,  -5760, &
                   -90,    720,   1206,  -4545,  -3978,   1044,   1206,  -3978,    558,    639,    -90,    720,     -9,     72, &
                  1206,    396,    558,  -4464,   -252,   2016,   -171,    477,    -90,    720,    558,  -4464,     -9,    -90, &
                   -90,    558,    558,   -252,     72,    720,   -576,   4608,     72,   -576,     -9,    -90,     72,   -576, &
                    -9,     72,    639,    558,     -9,     72,    -90,    720]
  K1( 527,:) = [     72,   -576,     -9,    -90,     72,     -9,   -576,   4608,     72,    720,   -576,     72,    -90,    558, &
                    -9,    -90,   -252,    558,    720,    -90,     72,     -9,    558,    639,   -576,   4608,     72,    720, &
                  -576,     72,   -576,   4608,     72,    720,   -576,     72,   -576,     72,   -576,     72,   -576,   -576, &
                  4608,   -576,   4608,   -576,   4608,   4608,   -576,   4608,     72,    720,   -576,     72,     72,   -576, &
                    -9,    -90,     72,     -9,     -9,    -90,    -90,    558,    558,   -252,     72,     -9,    720,    -90, &
                   639,    558,     -9,    639,     72,    720,    558,    -90,     72,     -9,     72,     -9,     72,     72, &
                    72,    720,     -9,    639,    -90,    558,    -90,    720,    720,    720,    720,    -90,     72,     -9, &
                  -576,     72,    -90,     -9,   -576,     72,   -576,     72,   -576,   -576,   -576,     72,     72,     -9, &
                    -9,    -90,     -9,     72,     72,     72,     72,     -9]
  K1( 528,:) = [   -252,    558,    558,    -90,    -90,     -9,    396,  -4626,   1044,  -1224,    396,   1044,    477,    558, &
                 -3978,   1044,   -252,    396,   -900,    -90,    477,    396,    558,  -4626,   2016,  -4464,  -4464,    720, &
                   720,     72,  -4464,  -5112,    720,  -5760,     72,   -576,    720,     72,     72,   -576,   -576,   4608, &
                 -5760,   -576,   -576,   4608,   4608, -36864,   1206,  -4545,  -3978,   1044,   1206,  -3978,    558,    639, &
                   -90,    720,     -9,     72,   1206,    396,    558,  -4464,   -252,   2016,   -171,    477,    -90,    720, &
                   558,  -4464,   -171,    639,   1206,    396,    558,    477,    -90,     -9,     -9,     72,     72,   -576, &
                 -4545,  -4626,    639,  -5112,    558,  -4464,    -90,   -900,    720,  -5760,    -90,    720,    -90,     -9, &
                   558,   -252,    -90,    558,    720,     72,     72,   -576,   -576,   4608,    639,    558,     -9,     72, &
                   -90,    720,     -9,    -90,     72,   -576,     -9,     72]
  K1( 529,:) = [     72,    720,   -576,   4608,     72,   -576,     -9,    -90,    -90,    558,    558,   -252,     72,   -576, &
                    -9,    -90,     72,     -9,     -9,     72,    639,    558,    720,    -90,     72,    720,    153,   -495, &
                  -657,    882,     -9,    -90,     -9,     -9,     72,    -90,   -576,   -495,    639,    639,   4608,  -4545, &
                   234,   -414,     -9,   -171,   -576,   1206,     72,    720,    720,  -4464,  -4464,   2016,     72,    720, &
                    72,     72,   -576,    720,   -576,     72,    720,    720,   4608,  -4464,   4608,   -576,     72,  -4464, &
                  -576,   2016,   -495,   -414,    153,   -657,   -495,    153,     72,    882,    558,    558,   -576,   1206, &
                    72,     -9,    -90,    -90,   -576,    558,   4041,  -1143,     72,  -3978,     72,   1206,   -414,   4041, &
                  -495,    882,   -414,   -495,   -576,   -495,    -90,    477,     72,  -3978,   -576,     72,     -9,    558, &
                    72,   -252,   -414,    234,    720,   1044,    720,    396]
  K1( 530,:) = [    720,     72,     72,   -576,   -576,   4608,    -90,     -9,    558,   -252,    -90,    558,     -9,     72, &
                   639,    558,    720,    -90,     72,   -576,     -9,    -90,     72,     -9,    720,     72,   -657,    882, &
                   153,   -495,    -90,     -9,     72,    -90,     -9,     -9,    234,   -414,     -9,   -171,   -576,   1206, &
                  -576,   -495,    639,    639,   4608,  -4545,    720,     72,  -4464,   2016,    720,  -4464,    720,     72, &
                  -576,    720,     72,     72,   4608,   -576,     72,  -4464,   -576,   2016,   -576,     72,    720,    720, &
                  4608,  -4464,   -414,   4041,   -495,    882,   -414,   -495,   -576,   -495,    -90,    477,     72,  -3978, &
                  -576,     72,     -9,    558,     72,   -252,   -414,    234,    720,   1044,    720,    396,   -495,   -414, &
                   153,   -657,   -495,    153,     72,    882,    558,    558,   -576,   1206,     72,     -9,    -90,    -90, &
                  -576,    558,   4041,  -1143,     72,  -3978,     72,   1206]
  K1( 531,:) = [     -9,    -90,     72,   -576,     -9,     72,    -90,    558,     -9,    -90,   -252,    558,   -576,   4608, &
                    72,    720,   -576,     72,    -90,    720,    558,    639,     72,     -9,    153,   -657,   -495,   -414, &
                   153,   -495,     72,     -9,    -90,    -90,   -576,    558,     72,    882,    558,    558,   -576,   1206, &
                 -1143,   4041,     72,   1206,     72,  -3978,    720,  -4464,     72,    720,   2016,  -4464,   -576,     72, &
                   720,    720,   4608,  -4464,     72,    720,     72,     72,   -576,    720,   -576,   4608,   -576,   2016, &
                    72,  -4464,    153,   -495,     72,    720,    882,   -657,   -576,   -495,    639,    639,   4608,  -4545, &
                    -9,    -90,     -9,     -9,     72,    -90,   -414,    234,   -576,   1206,     -9,   -171,   -495,   -414, &
                   882,   -495,   4041,   -414,    234,   -414,    720,    396,    720,   1044,     72,   -576,     72,   -252, &
                    -9,    558,   -495,   -576,     72,  -3978,    -90,    477]
  K1( 532,:) = [    639,    558,     -9,     72,    -90,    720,    558,   -252,    -90,     -9,    558,    -90,     72,   -576, &
                   720,     72,   4608,   -576,     -9,     72,    -90,     -9,   -576,     72,   -495,    882,   -414,   4041, &
                  -495,   -414,   -576,     72,     -9,    558,     72,   -252,   -576,   -495,    -90,    477,     72,  -3978, &
                   234,   -414,    720,    396,    720,   1044,  -4464,   2016,    720,     72,  -4464,    720,   4608,   -576, &
                    72,  -4464,   -576,   2016,    720,     72,   -576,    720,     72,     72,     72,   -576,   4608,  -4464, &
                   720,    720,   -657,    882,    720,     72,   -495,    153,    234,   -414,     -9,   -171,   -576,   1206, &
                   -90,     -9,     72,    -90,     -9,     -9,   -495,   -576,   4608,  -4545,    639,    639,    153,   -495, &
                  -657,    153,   -414,   -495,  -1143,   4041,     72,   1206,     72,  -3978,     -9,     72,   -576,    558, &
                   -90,    -90,    882,     72,   -576,   1206,    558,    558]
  K1( 533,:) = [    -90,     -9,     -9,     72,     72,   -576,    558,    -90,   -252,    558,     -9,    -90,    -90,    720, &
                   558,    639,     72,     -9,   -576,   4608,     72,    720,   -576,     72,   -657,    153,    153,   -495, &
                  -495,   -414,     -9,     72,   -576,    558,    -90,    -90,  -1143,   4041,     72,   1206,     72,  -3978, &
                    72,    882,    558,    558,   -576,   1206,  -4464,    720,   2016,  -4464,     72,    720,     72,   -576, &
                  4608,  -4464,    720,    720,   -576,   4608,   -576,   2016,     72,  -4464,     72,    720,     72,     72, &
                  -576,    720,   -495,   -414,    882,   -495,   4041,   -414,    234,   -414,    720,    396,    720,   1044, &
                    72,   -576,     72,   -252,     -9,    558,   -495,   -576,     72,  -3978,    -90,    477,    153,   -495, &
                    72,    720,    882,   -657,   -576,   -495,    639,    639,   4608,  -4545,     -9,    -90,     -9,     -9, &
                    72,    -90,   -414,    234,   -576,   1206,     -9,   -171]
  K1( 534,:) = [    558,    639,    -90,    720,     -9,     72,   -252,    558,    558,    -90,    -90,     -9,     -9,     72, &
                   -90,     -9,   -576,     72,     72,   -576,    720,     72,   4608,   -576,    882,   -495,   -495,   -414, &
                  -414,   4041,     72,   -576,     72,   -252,     -9,    558,    234,   -414,    720,    396,    720,   1044, &
                  -576,   -495,    -90,    477,     72,  -3978,   2016,  -4464,  -4464,    720,    720,     72,   -576,   4608, &
                  -576,   2016,     72,  -4464,     72,   -576,   4608,  -4464,    720,    720,    720,     72,   -576,    720, &
                    72,     72,    153,   -495,   -657,    153,   -414,   -495,  -1143,   4041,     72,   1206,     72,  -3978, &
                    -9,     72,   -576,    558,    -90,    -90,    882,     72,   -576,   1206,    558,    558,   -657,    882, &
                   720,     72,   -495,    153,    234,   -414,     -9,   -171,   -576,   1206,    -90,     -9,     72,    -90, &
                    -9,     -9,   -495,   -576,   4608,  -4545,    639,    639]
  K1( 535,:) = [    -90,   -900,     -9,   -657,    639,   -738,     -9,    -90,     72,   -576,     -9,     72,     72,    153, &
                  -576,   -495,  -1224,   3960,   -738,     72,   -657,    153,   -576,  -1224,     -9,    -90,     72,   -576, &
                    -9,     72,     72,    720,     72,     72,   -576,    720,     72,    153,     -9,     -9,   -576,    639, &
                   153,   -495,     72,    -90,     72,    558,     72,    720,   -576,   4608,     72,   -576,   -576,  -5760, &
                  -576,   -576,   4608,  -5760,   -576,  -1224,     72,     72,   4608,  -5112,  -1224,   3960,   -576,    720, &
                  -576,  -4464,     72,   -576,   -576,    234,    234,  -1143,     -9,   -657,    -90,    -90,     72,   -171, &
                    72,    153,     -9,     -9,   -576,    639,  -1224,   3960,     -9,   1206,     72,  -4545,    882,   -495, &
                  -495,   -414,   -414,   4041,   -657,   -576,    720,   -900,     -9,    477,    153,   -495,     72,    -90, &
                    72,    558,   -576,  -1224,    -90,    396,    720,  -4626]
  K1( 536,:) = [   -900,    -90,    639,   -738,     -9,   -657,    -90,     -9,     -9,     72,     72,   -576,   -738,     72, &
                  -657,    153,   -576,  -1224,     72,    153,   -576,   -495,  -1224,   3960,    -90,     -9,     -9,     72, &
                    72,   -576,    720,     72,   -576,    720,     72,     72,    153,   -495,     72,    -90,     72,    558, &
                    72,    153,     -9,     -9,   -576,    639,    720,     72,     72,   -576,   -576,   4608,  -5760,   -576, &
                  4608,  -5760,   -576,   -576,  -1224,   3960,   -576,    720,   -576,  -4464,   -576,  -1224,     72,     72, &
                  4608,  -5112,    882,   -495,   -495,   -414,   -414,   4041,   -657,   -576,    720,   -900,     -9,    477, &
                   153,   -495,     72,    -90,     72,    558,   -576,  -1224,    -90,    396,    720,  -4626,     72,   -576, &
                  -576,    234,    234,  -1143,     -9,   -657,    -90,    -90,     72,   -171,     72,    153,     -9,     -9, &
                  -576,    639,  -1224,   3960,     -9,   1206,     72,  -4545]
  K1( 537,:) = [    -90,    720,    558,    639,     72,     -9,     -9,     72,    -90,     -9,   -576,     72,   -252,    558, &
                   558,    -90,    -90,     -9,   -576,     72,   4608,   -576,    720,     72,     -9,     72,    -90,     -9, &
                  -576,     72,     72,   -576,   -576,   -576,   -576,     72,     -9,     72,     72,     72,     72,     -9, &
                  -576,     72,     72,     -9,     -9,    -90,     72,   -576,    720,     72,   4608,   -576,   -576,   4608, &
                  4608,   4608,   4608,   -576,     72,   -576,   -576,   -576,   -576,     72,   4608,   -576,   -576,     72, &
                    72,    720,    558,    -90,    639,     -9,    720,     72,    -90,    720,    720,    720,    720,    -90, &
                    -9,     72,     72,     72,     72,     -9,    720,     72,    -90,    558,     -9,    639,   -576,     72, &
                  4608,   -576,    720,     72,     72,     -9,    720,    -90,    639,    558,   -576,     72,     72,     -9, &
                    -9,    -90,    -90,     -9,    558,   -252,    -90,    558]
  K1( 538,:) = [    -90,   -900,    558,  -4626,    477,    396,     -9,    -90,    -90,    558,    558,   -252,   -252,    396, &
                   558,    477,   1044,  -3978,    396,   1044,  -4626,    396,  -1224,   1044,     -9,    -90,    -90,    558, &
                   558,   -252,     72,    720,   -576,   4608,     72,   -576,     -9,    -90,     72,   -576,     -9,     72, &
                   639,    558,     -9,     72,    -90,    720,     72,    720,    720,  -4464,  -4464,   2016,   -576,  -5760, &
                  4608, -36864,   -576,   4608,     72,    720,   -576,   4608,     72,   -576,  -5112,  -4464,     72,   -576, &
                   720,  -5760,    558,    477,    639,   -171,    396,   1206,    -90,   -900,    720,  -5760,    -90,    720, &
                    -9,    -90,     72,   -576,     -9,     72,  -4626,  -4545,    558,  -4464,    639,  -5112,   1206,  -3978, &
                 -4545,   1206,   1044,  -3978,   -171,    477,    -90,    720,    558,  -4464,    639,    558,     -9,     72, &
                   -90,    720,    396,   1206,   -252,   2016,    558,  -4464]
  K1( 539,:) = [    720,    -90,     72,     -9,    558,    639,     72,     -9,   -576,     72,    -90,     -9,   -576,     72, &
                  4608,   -576,    720,     72,   -252,    558,    558,    -90,    -90,     -9,     72,     -9,   -576,     72, &
                   -90,     -9,   -576,     72,   -576,     72,   -576,   -576,   -576,     72,     72,     -9,     -9,    -90, &
                    -9,     72,     72,     72,     72,     -9,   -576,     72,   4608,   -576,    720,     72,   4608,   -576, &
                  4608,   -576,   4608,   4608,   4608,   -576,   -576,     72,     72,    720,     72,   -576,   -576,   -576, &
                  -576,     72,   -576,     72,   4608,   -576,    720,     72,     72,     -9,    720,    -90,    639,    558, &
                  -576,     72,     72,     -9,     -9,    -90,    -90,     -9,    558,   -252,    -90,    558,    558,    -90, &
                   639,     -9,    720,     72,    -90,    720,    720,    720,    720,    -90,     -9,     72,     72,     72, &
                    72,     -9,    720,     72,    -90,    558,     -9,    639]
  K1( 540,:) = [   -900,    -90,    477,    396,    558,  -4626,    -90,     -9,    558,   -252,    -90,    558,    396,   1044, &
                 -4626,    396,  -1224,   1044,   -252,    396,    558,    477,   1044,  -3978,    -90,     -9,    558,   -252, &
                   -90,    558,    720,     72,     72,   -576,   -576,   4608,    639,    558,     -9,     72,    -90,    720, &
                    -9,    -90,     72,   -576,     -9,     72,    720,     72,  -4464,   2016,    720,  -4464,  -5760,   -576, &
                  -576,   4608,   4608, -36864,  -5112,  -4464,     72,   -576,    720,  -5760,     72,    720,   -576,   4608, &
                    72,   -576,   1206,  -3978,  -4545,   1206,   1044,  -3978,   -171,    477,    -90,    720,    558,  -4464, &
                   639,    558,     -9,     72,    -90,    720,    396,   1206,   -252,   2016,    558,  -4464,    558,    477, &
                   639,   -171,    396,   1206,    -90,   -900,    720,  -5760,    -90,    720,     -9,    -90,     72,   -576, &
                    -9,     72,  -4626,  -4545,    558,  -4464,    639,  -5112]
  K1( 541,:) = [   -576,   -495,     72,    153,   3960,  -1224,     72,   -576,     -9,    -90,     72,     -9,     -9,   -657, &
                   -90,   -900,   -738,    639,  -1224,   -576,    153,   -657,     72,   -738,   -576,    234,     72,   -576, &
                 -1143,    234,     72,    153,     -9,     -9,   -576,    639,     -9,   -657,    -90,    -90,     72,   -171, &
                  3960,  -1224,     72,  -4545,     -9,   1206,   -576,   4608,     72,    720,   -576,     72,   -576,  -1224, &
                    72,     72,   4608,  -5112,   -576,  -5760,   -576,   -576,   4608,  -5760,   3960,  -1224,   -576,  -4464, &
                  -576,    720,     72,   -576,     -9,    -90,     72,     -9,     72,    153,     -9,     -9,   -576,    639, &
                    72,    720,     72,     72,   -576,    720,   -495,    153,     72,    558,     72,    -90,   4041,   -414, &
                  -414,   -495,   -495,    882,  -1224,   -576,    720,  -4626,    -90,    396,   -495,    153,     72,    558, &
                    72,    -90,   -576,   -657,     -9,    477,    720,   -900]
  K1( 542,:) = [   -657,    153,   -738,     72,  -1224,   -576,     -9,     72,    -90,     -9,   -576,     72,    639,   -738, &
                  -900,    -90,   -657,     -9,   3960,  -1224,   -495,   -576,    153,     72,   -495,   -414,    882,   -495, &
                  4041,   -414,    153,   -495,     72,    -90,     72,    558,   -657,   -576,    720,   -900,     -9,    477, &
                 -1224,   -576,    720,  -4626,    -90,    396,     72,   -576,    720,     72,   4608,   -576,  -1224,   3960, &
                  -576,    720,   -576,  -4464,  -5760,   -576,   4608,  -5760,   -576,   -576,  -1224,   -576,   4608,  -5112, &
                    72,     72,     -9,     72,    -90,     -9,   -576,     72,    153,   -495,     72,    -90,     72,    558, &
                   720,     72,   -576,    720,     72,     72,    153,     72,   -576,    639,     -9,     -9,  -1143,    234, &
                   234,   -576,   -576,     72,   3960,  -1224,     72,  -4545,     -9,   1206,    153,     72,   -576,    639, &
                    -9,     -9,   -657,     -9,     72,   -171,    -90,    -90]
  K1( 543,:) = [    558,    -90,   -252,    558,     -9,    -90,    -90,     -9,     -9,     72,     72,   -576,    558,    639, &
                   -90,    720,     -9,     72,     72,    720,   -576,   4608,     72,   -576,    639,     -9,    558,    -90, &
                    72,    720,     -9,     72,     72,     72,     72,     -9,    -90,    720,    720,    720,    720,    -90, &
                    72,    720,     -9,    639,    -90,    558,    720,     72,     72,   -576,   -576,   4608,     72,   -576, &
                  -576,   -576,   -576,     72,   -576,   4608,   4608,   4608,   4608,   -576,   -576,   4608,     72,    720, &
                  -576,     72,    -90,     -9,     -9,     72,     72,   -576,     -9,     72,     72,     72,     72,     -9, &
                    72,   -576,   -576,   -576,   -576,     72,     72,   -576,     -9,    -90,     72,     -9,     72,    720, &
                  -576,   4608,     72,   -576,     -9,    -90,    -90,    558,    558,   -252,     72,   -576,     -9,    -90, &
                    72,     -9,     -9,     72,    639,    558,    720,    -90]
  K1( 544,:) = [    558,    477,   -252,    396,  -3978,   1044,    -90,    558,     -9,    -90,   -252,    558,    558,  -4626, &
                   -90,   -900,    396,    477,   1044,  -1224,    396,  -4626,   1044,    396,    639,   -171,    558,    477, &
                  1206,    396,     -9,    -90,     72,   -576,     -9,     72,    -90,   -900,    720,  -5760,    -90,    720, &
                 -4545,  -4626,    639,  -5112,    558,  -4464,    720,  -4464,     72,    720,   2016,  -4464,     72,    720, &
                  -576,   4608,     72,   -576,   -576,  -5760,   4608, -36864,   -576,   4608,  -4464,  -5112,    720,  -5760, &
                    72,   -576,    -90,    558,     -9,    -90,   -252,    558,     -9,    -90,     72,   -576,     -9,     72, &
                    72,    720,   -576,   4608,     72,   -576,    558,    639,    -90,    720,     -9,     72,  -3978,   1044, &
                  1206,  -4545,  -3978,   1206,   1206,    396,    558,  -4464,   -252,   2016,    558,    639,    -90,    720, &
                    -9,     72,    477,   -171,    558,  -4464,    -90,    720]
  K1( 545,:) = [   4608,   -576,   -576,     72,     72,    720,   -576,     72,     72,     -9,     -9,    -90,     72,     -9, &
                   720,    -90,    639,    558,     -9,    -90,    -90,    558,    558,   -252,   4608,   -576,   -576,     72, &
                    72,    720,   -576,     72,     72,     -9,     -9,    -90,     72,     -9,    720,    -90,    639,    558, &
                    -9,    -90,    -90,    558,    558,   -252,   4608,   -576,   -576,     72,     72,    720,   4608,   -576, &
                  -576,     72,     72,    720,   4608,   -576,   4608,   -576,   4608,   4608,   -576,     72,   -576,     72, &
                  -576,   -576,   -576,     72,     72,     -9,     -9,    -90,   -576,     72,     72,     -9,     -9,    -90, &
                  -576,     72,   -576,     72,   -576,   -576,     72,     -9,     72,     -9,     72,     72,     72,    720, &
                    -9,    639,    -90,    558,     72,    720,     -9,    639,    -90,    558,     72,     -9,     72,     -9, &
                    72,     72,    720,    -90,    720,    -90,    720,    720]
  K1( 546,:) = [  -4626,    396,    396,   1044,   1044,  -1224,    558,   -252,    -90,     -9,    558,    -90,    477,    396, &
                  -900,    -90,  -4626,    558,  -3978,   1044,    477,    558,    396,   -252,  -4545,   1206,   1206,  -3978, &
                 -3978,   1044,    639,    558,     -9,     72,    -90,    720,   -171,    477,    -90,    720,    558,  -4464, &
                  1206,    396,    558,  -4464,   -252,   2016,  -4464,   2016,    720,     72,  -4464,    720,  -5112,  -4464, &
                    72,   -576,    720,  -5760,  -5760,   -576,   -576,   4608,   4608, -36864,    720,     72,     72,   -576, &
                  -576,   4608,    558,   -252,    -90,     -9,    558,    -90,    639,    558,     -9,     72,    -90,    720, &
                   720,     72,     72,   -576,   -576,   4608,    -90,     -9,     -9,     72,     72,   -576,   1206,    396, &
                  -171,    639,    477,    558,  -4545,  -4626,    639,  -5112,    558,  -4464,    -90,     -9,     -9,     72, &
                    72,   -576,   -900,    -90,    -90,    720,    720,  -5760]
  K1( 547,:) = [   -495,   -576,   3960,  -1224,     72,    153,   -576,     72,     72,     -9,     -9,    -90,  -1224,   -576, &
                   153,   -657,     72,   -738,     -9,   -657,    -90,   -900,   -738,    639,    234,   -576,  -1143,    234, &
                    72,   -576,    153,     72,   -576,    639,     -9,     -9,   3960,  -1224,     72,  -4545,     -9,   1206, &
                    -9,   -657,    -90,    -90,     72,   -171,   4608,   -576,   -576,     72,     72,    720,  -1224,   -576, &
                  4608,  -5112,     72,     72,   3960,  -1224,   -576,  -4464,   -576,    720,   -576,  -5760,   -576,   -576, &
                  4608,  -5760,   4041,   -414,   -414,   -495,   -495,    882,  -1224,   -576,    720,  -4626,    -90,    396, &
                  -495,    153,     72,    558,     72,    -90,   -576,   -657,     -9,    477,    720,   -900,     72,   -576, &
                    -9,    -90,     72,     -9,     72,    153,     -9,     -9,   -576,    639,     72,    720,     72,     72, &
                  -576,    720,   -495,    153,     72,    558,     72,    -90]
  K1( 548,:) = [    153,   -657,  -1224,   -576,   -738,     72,     72,     -9,   -576,     72,    -90,     -9,   3960,  -1224, &
                  -495,   -576,    153,     72,    639,   -738,   -900,    -90,   -657,     -9,   -414,   -495,   4041,   -414, &
                   882,   -495,   -495,    153,     72,    558,     72,    -90,  -1224,   -576,    720,  -4626,    -90,    396, &
                  -657,   -576,    720,   -900,     -9,    477,   -576,     72,   4608,   -576,    720,     72,   3960,  -1224, &
                  -576,  -4464,   -576,    720,  -1224,   -576,   4608,  -5112,     72,     72,  -5760,   -576,   4608,  -5760, &
                  -576,   -576,  -1143,    234,    234,   -576,   -576,     72,   3960,  -1224,     72,  -4545,     -9,   1206, &
                   153,     72,   -576,    639,     -9,     -9,   -657,     -9,     72,   -171,    -90,    -90,     -9,     72, &
                   -90,     -9,   -576,     72,    153,   -495,     72,    -90,     72,    558,    720,     72,   -576,    720, &
                    72,     72,    153,     72,   -576,    639,     -9,     -9]
  K1( 549,:) = [    -90,    558,     -9,    -90,   -252,    558,     -9,    -90,     72,   -576,     -9,     72,     72,    720, &
                  -576,   4608,     72,   -576,    558,    639,    -90,    720,     -9,     72,     -9,    639,     72,    720, &
                   558,    -90,     72,     -9,     72,     -9,     72,     72,     72,    720,     -9,    639,    -90,    558, &
                   -90,    720,    720,    720,    720,    -90,     72,    720,   -576,   4608,     72,   -576,   -576,     72, &
                  -576,     72,   -576,   -576,   -576,   4608,     72,    720,   -576,     72,   -576,   4608,   4608,   4608, &
                  4608,   -576,     72,    720,   -576,   4608,     72,   -576,     -9,    -90,    -90,    558,    558,   -252, &
                    72,   -576,     -9,    -90,     72,     -9,     -9,     72,    639,    558,    720,    -90,    -90,     -9, &
                    -9,     72,     72,   -576,     -9,     72,     72,     72,     72,     -9,     72,   -576,   -576,   -576, &
                  -576,     72,     72,   -576,     -9,    -90,     72,     -9]
  K1( 550,:) = [    477,    558,  -3978,   1044,   -252,    396,    558,    -90,   -252,    558,     -9,    -90,   1044,  -1224, &
                   396,  -4626,   1044,    396,    558,  -4626,    -90,   -900,    396,    477,   -171,    639,   1206,    396, &
                   558,    477,    -90,     -9,     -9,     72,     72,   -576,  -4545,  -4626,    639,  -5112,    558,  -4464, &
                   -90,   -900,    720,  -5760,    -90,    720,  -4464,    720,   2016,  -4464,     72,    720,    720,     72, &
                    72,   -576,   -576,   4608,  -4464,  -5112,    720,  -5760,     72,   -576,   -576,  -5760,   4608, -36864, &
                  -576,   4608,  -3978,   1044,   1206,  -4545,  -3978,   1206,   1206,    396,    558,  -4464,   -252,   2016, &
                   558,    639,    -90,    720,     -9,     72,    477,   -171,    558,  -4464,    -90,    720,    -90,    558, &
                    -9,    -90,   -252,    558,     -9,    -90,     72,   -576,     -9,     72,     72,    720,   -576,   4608, &
                    72,   -576,    558,    639,    -90,    720,     -9,     72]
  K1( 551,:) = [   -576,   4608,     72,    720,   -576,     72,     72,   -576,     -9,    -90,     72,     -9,     -9,    -90, &
                   -90,    558,    558,   -252,     72,     -9,    720,    -90,    639,    558,   -576,   4608,     72,    720, &
                  -576,     72,     72,   -576,     -9,    -90,     72,     -9,     -9,    -90,    -90,    558,    558,   -252, &
                    72,     -9,    720,    -90,    639,    558,   -576,   4608,     72,    720,   -576,     72,   -576,   4608, &
                    72,    720,   -576,     72,   -576,     72,   -576,     72,   -576,   -576,   4608,   -576,   4608,   -576, &
                  4608,   4608,     72,    720,     -9,    639,    -90,    558,     72,    720,     -9,    639,    -90,    558, &
                    72,     -9,     72,     -9,     72,     72,    720,    -90,    720,    -90,    720,    720,   -576,     72, &
                    72,     -9,     -9,    -90,   -576,     72,     72,     -9,     -9,    -90,   -576,     72,   -576,     72, &
                  -576,   -576,     72,     -9,     72,     -9,     72,     72]
  K1( 552,:) = [    396,  -4626,   1044,  -1224,    396,   1044,   -252,    558,    558,    -90,    -90,     -9,  -3978,   1044, &
                   477,    558,    396,   -252,    477,    396,   -900,    -90,  -4626,    558,   1206,  -4545,  -3978,   1044, &
                  1206,  -3978,    558,    639,    -90,    720,     -9,     72,   1206,    396,    558,  -4464,   -252,   2016, &
                  -171,    477,    -90,    720,    558,  -4464,   2016,  -4464,  -4464,    720,    720,     72,  -4464,  -5112, &
                   720,  -5760,     72,   -576,    720,     72,     72,   -576,   -576,   4608,  -5760,   -576,   -576,   4608, &
                  4608, -36864,   1206,    396,   -171,    639,    477,    558,  -4545,  -4626,    639,  -5112,    558,  -4464, &
                   -90,     -9,     -9,     72,     72,   -576,   -900,    -90,    -90,    720,    720,  -5760,    558,   -252, &
                   -90,     -9,    558,    -90,    639,    558,     -9,     72,    -90,    720,    720,     72,     72,   -576, &
                  -576,   4608,    -90,     -9,     -9,     72,     72,   -576]
  K1( 553,:) = [   -576,   4608,     72,    720,   -576,     72,     72,   -576,     -9,    -90,     72,     -9,     -9,    -90, &
                   -90,    558,    558,   -252,     72,     -9,    720,    -90,    639,    558,    153,   -495,     72,    720, &
                   882,   -657,   -576,   -495,    639,    639,   4608,  -4545,     -9,    -90,     -9,     -9,     72,    -90, &
                  -414,    234,   -576,   1206,     -9,   -171,   -495,   -414,    153,   -657,   -495,    153,     72,    882, &
                   558,    558,   -576,   1206,     72,     -9,    -90,    -90,   -576,    558,   4041,  -1143,     72,  -3978, &
                    72,   1206,     72,    720,    720,  -4464,  -4464,   2016,     72,    720,     72,     72,   -576,    720, &
                  -576,     72,    720,    720,   4608,  -4464,   4608,   -576,     72,  -4464,   -576,   2016,   4041,   -414, &
                  -414,   -495,   -495,    882,   -495,   -576,     72,  -3978,    -90,    477,   -414,    234,    720,   1044, &
                   720,    396,   -576,     72,     -9,    558,     72,   -252]
  K1( 554,:) = [     72,   -576,    720,     72,   4608,   -576,     -9,     72,    639,    558,    720,    -90,    -90,     -9, &
                   558,   -252,    -90,    558,   -576,     72,     72,     -9,     -9,    -90,   -657,    882,    720,     72, &
                  -495,    153,    234,   -414,     -9,   -171,   -576,   1206,    -90,     -9,     72,    -90,     -9,     -9, &
                  -495,   -576,   4608,  -4545,    639,    639,   -414,   4041,   -495,    882,   -414,   -495,   -576,   -495, &
                   -90,    477,     72,  -3978,   -576,     72,     -9,    558,     72,   -252,   -414,    234,    720,   1044, &
                   720,    396,    720,     72,  -4464,   2016,    720,  -4464,    720,     72,   -576,    720,     72,     72, &
                  4608,   -576,     72,  -4464,   -576,   2016,   -576,     72,    720,    720,   4608,  -4464,   -414,   -495, &
                  -495,    153,    153,   -657,    882,     72,   -576,   1206,    558,    558,   4041,  -1143,     72,  -3978, &
                    72,   1206,     72,     -9,    -90,    -90,   -576,    558]
  K1( 555,:) = [     72,   -576,     -9,    -90,     72,     -9,   -576,   4608,     72,    720,   -576,     72,    -90,    558, &
                    -9,    -90,   -252,    558,    720,    -90,     72,     -9,    558,    639,   -495,   -414,    153,   -657, &
                  -495,    153,     72,    882,    558,    558,   -576,   1206,     72,     -9,    -90,    -90,   -576,    558, &
                  4041,  -1143,     72,  -3978,     72,   1206,    153,   -495,     72,    720,    882,   -657,   -576,   -495, &
                   639,    639,   4608,  -4545,     -9,    -90,     -9,     -9,     72,    -90,   -414,    234,   -576,   1206, &
                    -9,   -171,    720,  -4464,     72,    720,   2016,  -4464,   -576,     72,    720,    720,   4608,  -4464, &
                    72,    720,     72,     72,   -576,    720,   -576,   4608,   -576,   2016,     72,  -4464,   -414,   -495, &
                  4041,   -414,    882,   -495,   -414,    234,    720,   1044,    720,    396,   -495,   -576,     72,  -3978, &
                   -90,    477,     72,   -576,     72,   -252,     -9,    558]
  K1( 556,:) = [     -9,     72,    639,    558,    720,    -90,     72,   -576,    720,     72,   4608,   -576,    558,   -252, &
                   -90,     -9,    558,    -90,     72,     -9,   -576,     72,    -90,     -9,   -414,   4041,   -495,    882, &
                  -414,   -495,   -576,   -495,    -90,    477,     72,  -3978,   -576,     72,     -9,    558,     72,   -252, &
                  -414,    234,    720,   1044,    720,    396,   -657,    882,    720,     72,   -495,    153,    234,   -414, &
                    -9,   -171,   -576,   1206,    -90,     -9,     72,    -90,     -9,     -9,   -495,   -576,   4608,  -4545, &
                   639,    639,  -4464,   2016,    720,     72,  -4464,    720,   4608,   -576,     72,  -4464,   -576,   2016, &
                   720,     72,   -576,    720,     72,     72,     72,   -576,   4608,  -4464,    720,    720,   -495,    153, &
                  -414,   -495,   -657,    153,   4041,  -1143,     72,  -3978,     72,   1206,    882,     72,   -576,   1206, &
                   558,    558,     -9,     72,   -576,    558,    -90,    -90]
  K1( 557,:) = [     -9,     72,    -90,     -9,   -576,     72,    -90,    720,    558,    639,     72,     -9,    558,    -90, &
                  -252,    558,     -9,    -90,   4608,   -576,   -576,     72,     72,    720,    153,   -495,   -657,    153, &
                  -414,   -495,  -1143,   4041,     72,   1206,     72,  -3978,     -9,     72,   -576,    558,    -90,    -90, &
                   882,     72,   -576,   1206,    558,    558,   -495,   -414,    882,   -495,   4041,   -414,    234,   -414, &
                   720,    396,    720,   1044,     72,   -576,     72,   -252,     -9,    558,   -495,   -576,     72,  -3978, &
                   -90,    477,  -4464,    720,   2016,  -4464,     72,    720,     72,   -576,   4608,  -4464,    720,    720, &
                  -576,   4608,   -576,   2016,     72,  -4464,     72,    720,     72,     72,   -576,    720,   -495,    153, &
                   882,   -657,     72,    720,   -495,   -576,   4608,  -4545,    639,    639,   -414,    234,   -576,   1206, &
                    -9,   -171,     -9,    -90,     -9,     -9,     72,    -90]
  K1( 558,:) = [    -90,    720,    558,    639,     72,     -9,     -9,     72,    -90,     -9,   -576,     72,   -252,    558, &
                   558,    -90,    -90,     -9,   -576,     72,   4608,   -576,    720,     72,   -495,   -414,    882,   -495, &
                  4041,   -414,    234,   -414,    720,    396,    720,   1044,     72,   -576,     72,   -252,     -9,    558, &
                  -495,   -576,     72,  -3978,    -90,    477,    153,   -495,   -657,    153,   -414,   -495,  -1143,   4041, &
                    72,   1206,     72,  -3978,     -9,     72,   -576,    558,    -90,    -90,    882,     72,   -576,   1206, &
                   558,    558,   2016,  -4464,  -4464,    720,    720,     72,   -576,   4608,   -576,   2016,     72,  -4464, &
                    72,   -576,   4608,  -4464,    720,    720,    720,     72,   -576,    720,     72,     72,    882,   -657, &
                  -495,    153,    720,     72,   -414,    234,   -576,   1206,     -9,   -171,   -495,   -576,   4608,  -4545, &
                   639,    639,    -90,     -9,     72,    -90,     -9,     -9]
  K1( 559,:) = [     -9,   -657,    -90,   -900,   -738,    639,     72,    153,   -576,   -495,  -1224,   3960,     -9,    -90, &
                    72,   -576,     -9,     72,     72,   -738,   -576,  -1224,   -657,    153,     72,   -576,     -9,    -90, &
                    72,     -9,     72,    153,     -9,     -9,   -576,    639,     72,    720,     72,     72,   -576,    720, &
                  -495,    153,     72,    558,     72,    -90,     72,   -576,   -576,    234,    234,  -1143,     -9,   -657, &
                   -90,    -90,     72,   -171,     72,    153,     -9,     -9,   -576,    639,  -1224,   3960,     -9,   1206, &
                    72,  -4545,     72,    720,   -576,   4608,     72,   -576,   -576,  -5760,   -576,   -576,   4608,  -5760, &
                  -576,  -1224,     72,     72,   4608,  -5112,  -1224,   3960,   -576,    720,   -576,  -4464,   -495,    882, &
                  -414,   4041,   -495,   -414,   -576,   -657,     -9,    477,    720,   -900,   -576,  -1224,    -90,    396, &
                   720,  -4626,    153,   -495,     72,    -90,     72,    558]
  K1( 560,:) = [    639,   -738,   -900,    -90,   -657,     -9,   -738,     72,   -657,    153,   -576,  -1224,    -90,     -9, &
                    -9,     72,     72,   -576,    153,     72,  -1224,   3960,   -576,   -495,     -9,     72,    -90,     -9, &
                  -576,     72,    153,   -495,     72,    -90,     72,    558,    720,     72,   -576,    720,     72,     72, &
                   153,     72,   -576,    639,     -9,     -9,    882,   -495,   -495,   -414,   -414,   4041,   -657,   -576, &
                   720,   -900,     -9,    477,    153,   -495,     72,    -90,     72,    558,   -576,  -1224,    -90,    396, &
                   720,  -4626,    720,     72,     72,   -576,   -576,   4608,  -5760,   -576,   4608,  -5760,   -576,   -576, &
                 -1224,   3960,   -576,    720,   -576,  -4464,   -576,  -1224,     72,     72,   4608,  -5112,   -576,     72, &
                   234,  -1143,   -576,    234,   -657,     -9,     72,   -171,    -90,    -90,  -1224,   3960,     -9,   1206, &
                    72,  -4545,     72,    153,     -9,     -9,   -576,    639]
  K1( 561,:) = [    558,    639,    -90,    720,     -9,     72,   -252,    558,    558,    -90,    -90,     -9,     -9,     72, &
                   -90,     -9,   -576,     72,     72,   -576,    720,     72,   4608,   -576,    -90,     -9,     -9,     72, &
                    72,   -576,     -9,     72,     72,     72,     72,     -9,     72,   -576,   -576,   -576,   -576,     72, &
                    72,   -576,     -9,    -90,     72,     -9,    558,    -90,    639,     -9,    720,     72,    -90,    720, &
                   720,    720,    720,    -90,     -9,     72,     72,     72,     72,     -9,    720,     72,    -90,    558, &
                    -9,    639,     72,   -576,    720,     72,   4608,   -576,   -576,   4608,   4608,   4608,   4608,   -576, &
                    72,   -576,   -576,   -576,   -576,     72,   4608,   -576,   -576,     72,     72,    720,     72,   -576, &
                   720,     72,   4608,   -576,     -9,     72,    639,    558,    720,    -90,    -90,     -9,    558,   -252, &
                   -90,    558,   -576,     72,     72,     -9,     -9,    -90]
  K1( 562,:) = [    558,  -4626,    -90,   -900,    396,    477,   -252,    396,    558,    477,   1044,  -3978,     -9,    -90, &
                   -90,    558,    558,   -252,   1044,    396,  -1224,   1044,  -4626,    396,    -90,    558,     -9,    -90, &
                  -252,    558,     -9,    -90,     72,   -576,     -9,     72,     72,    720,   -576,   4608,     72,   -576, &
                   558,    639,    -90,    720,     -9,     72,    558,    477,    639,   -171,    396,   1206,    -90,   -900, &
                   720,  -5760,    -90,    720,     -9,    -90,     72,   -576,     -9,     72,  -4626,  -4545,    558,  -4464, &
                   639,  -5112,     72,    720,    720,  -4464,  -4464,   2016,   -576,  -5760,   4608, -36864,   -576,   4608, &
                    72,    720,   -576,   4608,     72,   -576,  -5112,  -4464,     72,   -576,    720,  -5760,  -3978,   1206, &
                  1044,  -3978,  -4545,   1206,    477,   -171,    558,  -4464,    -90,    720,    396,   1206,   -252,   2016, &
                   558,  -4464,    639,    558,     -9,     72,    -90,    720]
  K1( 563,:) = [     72,     -9,    720,    -90,    639,    558,   -576,     72,   4608,   -576,    720,     72,     72,     -9, &
                  -576,     72,    -90,     -9,    558,   -252,    -90,     -9,    558,    -90,   -576,     72,     72,     -9, &
                    -9,    -90,   -576,     72,     72,     -9,     -9,    -90,   -576,     72,   -576,     72,   -576,   -576, &
                    72,     -9,     72,     -9,     72,     72,   -576,     72,   4608,   -576,    720,     72,     72,     -9, &
                   720,    -90,    639,    558,   -576,     72,     72,     -9,     -9,    -90,    -90,     -9,    558,   -252, &
                   -90,    558,   -576,     72,   4608,   -576,    720,     72,   4608,   -576,   4608,   -576,   4608,   4608, &
                  4608,   -576,   -576,     72,     72,    720,     72,   -576,   -576,   -576,   -576,     72,    -90,    558, &
                   720,     72,    639,     -9,    720,    -90,    720,    -90,    720,    720,    720,     72,    -90,    558, &
                    -9,    639,     -9,     72,     72,     72,     72,     -9]
  K1( 564,:) = [    477,    396,   -900,    -90,  -4626,    558,    396,   1044,  -4626,    396,  -1224,   1044,    -90,     -9, &
                   558,   -252,    -90,    558,    396,   -252,   1044,  -3978,    558,    477,    558,   -252,    -90,     -9, &
                   558,    -90,    639,    558,     -9,     72,    -90,    720,    720,     72,     72,   -576,   -576,   4608, &
                   -90,     -9,     -9,     72,     72,   -576,   1206,  -3978,  -4545,   1206,   1044,  -3978,   -171,    477, &
                   -90,    720,    558,  -4464,    639,    558,     -9,     72,    -90,    720,    396,   1206,   -252,   2016, &
                   558,  -4464,    720,     72,  -4464,   2016,    720,  -4464,  -5760,   -576,   -576,   4608,   4608, -36864, &
                 -5112,  -4464,     72,   -576,    720,  -5760,     72,    720,   -576,   4608,     72,   -576,    477,    558, &
                   396,   1206,    639,   -171,   -900,    -90,    -90,    720,    720,  -5760,  -4626,  -4545,    558,  -4464, &
                   639,  -5112,     -9,    -90,     72,   -576,     -9,     72]
  K1( 565,:) = [     72,    153,   -576,   -495,  -1224,   3960,     -9,   -657,    -90,   -900,   -738,    639,     72,   -576, &
                    -9,    -90,     72,     -9,   -576,  -1224,     72,   -738,    153,   -657,     72,   -576,   -576,    234, &
                   234,  -1143,     -9,   -657,    -90,    -90,     72,   -171,     72,    153,     -9,     -9,   -576,    639, &
                 -1224,   3960,     -9,   1206,     72,  -4545,     72,   -576,     -9,    -90,     72,     -9,     72,    153, &
                    -9,     -9,   -576,    639,     72,    720,     72,     72,   -576,    720,   -495,    153,     72,    558, &
                    72,    -90,   -576,   4608,     72,    720,   -576,     72,   -576,  -1224,     72,     72,   4608,  -5112, &
                  -576,  -5760,   -576,   -576,   4608,  -5760,   3960,  -1224,   -576,  -4464,   -576,    720,   -414,   4041, &
                  -495,    882,   -414,   -495,   -576,  -1224,    -90,    396,    720,  -4626,   -576,   -657,     -9,    477, &
                   720,   -900,   -495,    153,     72,    558,     72,    -90]
  K1( 566,:) = [   -738,     72,   -657,    153,   -576,  -1224,    639,   -738,   -900,    -90,   -657,     -9,     -9,     72, &
                   -90,     -9,   -576,     72,  -1224,   3960,    153,     72,   -495,   -576,    882,   -495,   -495,   -414, &
                  -414,   4041,   -657,   -576,    720,   -900,     -9,    477,    153,   -495,     72,    -90,     72,    558, &
                  -576,  -1224,    -90,    396,    720,  -4626,     -9,     72,    -90,     -9,   -576,     72,    153,   -495, &
                    72,    -90,     72,    558,    720,     72,   -576,    720,     72,     72,    153,     72,   -576,    639, &
                    -9,     -9,     72,   -576,    720,     72,   4608,   -576,  -1224,   3960,   -576,    720,   -576,  -4464, &
                 -5760,   -576,   4608,  -5760,   -576,   -576,  -1224,   -576,   4608,  -5112,     72,     72,    234,  -1143, &
                  -576,     72,    234,   -576,  -1224,   3960,     -9,   1206,     72,  -4545,   -657,     -9,     72,   -171, &
                   -90,    -90,    153,     72,   -576,    639,     -9,     -9]
  K1( 567,:) = [   -252,    558,    558,    -90,    -90,     -9,    558,    639,    -90,    720,     -9,     72,    -90,     -9, &
                    -9,     72,     72,   -576,    720,     72,     72,   -576,   -576,   4608,    558,    -90,    639,     -9, &
                   720,     72,    -90,    720,    720,    720,    720,    -90,     -9,     72,     72,     72,     72,     -9, &
                   720,     72,    -90,    558,     -9,    639,    -90,     -9,     -9,     72,     72,   -576,     -9,     72, &
                    72,     72,     72,     -9,     72,   -576,   -576,   -576,   -576,     72,     72,   -576,     -9,    -90, &
                    72,     -9,    720,     72,     72,   -576,   -576,   4608,     72,   -576,   -576,   -576,   -576,     72, &
                  -576,   4608,   4608,   4608,   4608,   -576,   -576,   4608,     72,    720,   -576,     72,    720,     72, &
                    72,   -576,   -576,   4608,    -90,     -9,    558,   -252,    -90,    558,     -9,     72,    639,    558, &
                   720,    -90,     72,   -576,     -9,    -90,     72,     -9]
  K1( 568,:) = [   -252,    396,    558,    477,   1044,  -3978,    558,  -4626,    -90,   -900,    396,    477,    -90,    558, &
                    -9,    -90,   -252,    558,  -1224,   1044,   1044,    396,    396,  -4626,    558,    477,    639,   -171, &
                   396,   1206,    -90,   -900,    720,  -5760,    -90,    720,     -9,    -90,     72,   -576,     -9,     72, &
                 -4626,  -4545,    558,  -4464,    639,  -5112,    -90,    558,     -9,    -90,   -252,    558,     -9,    -90, &
                    72,   -576,     -9,     72,     72,    720,   -576,   4608,     72,   -576,    558,    639,    -90,    720, &
                    -9,     72,    720,  -4464,     72,    720,   2016,  -4464,     72,    720,   -576,   4608,     72,   -576, &
                  -576,  -5760,   4608, -36864,   -576,   4608,  -4464,  -5112,    720,  -5760,     72,   -576,   1044,  -3978, &
                 -3978,   1206,   1206,  -4545,    396,   1206,   -252,   2016,    558,  -4464,    477,   -171,    558,  -4464, &
                   -90,    720,    558,    639,    -90,    720,     -9,     72]
  K1( 569,:) = [   -576,     72,   4608,   -576,    720,     72,     72,     -9,    720,    -90,    639,    558,   -576,     72, &
                    72,     -9,     -9,    -90,    -90,     -9,    558,   -252,    -90,    558,   -576,     72,   4608,   -576, &
                   720,     72,     72,     -9,    720,    -90,    639,    558,   -576,     72,     72,     -9,     -9,    -90, &
                   -90,     -9,    558,   -252,    -90,    558,   -576,     72,     72,     -9,     -9,    -90,   -576,     72, &
                    72,     -9,     -9,    -90,   -576,     72,   -576,     72,   -576,   -576,     72,     -9,     72,     -9, &
                    72,     72,   4608,   -576,   -576,     72,     72,    720,   4608,   -576,   -576,     72,     72,    720, &
                  4608,   -576,   4608,   -576,   4608,   4608,   -576,     72,   -576,     72,   -576,   -576,    720,     72, &
                   -90,    558,     -9,    639,    720,     72,    -90,    558,     -9,    639,    720,    -90,    720,    -90, &
                   720,    720,     72,     -9,     72,     -9,     72,     72]
  K1( 570,:) = [    396,   1044,  -4626,    396,  -1224,   1044,    477,    396,   -900,    -90,  -4626,    558,    558,   -252, &
                   -90,     -9,    558,    -90,   1044,  -3978,    396,   -252,    477,    558,   1206,  -3978,  -4545,   1206, &
                  1044,  -3978,   -171,    477,    -90,    720,    558,  -4464,    639,    558,     -9,     72,    -90,    720, &
                   396,   1206,   -252,   2016,    558,  -4464,    558,   -252,    -90,     -9,    558,    -90,    639,    558, &
                    -9,     72,    -90,    720,    720,     72,     72,   -576,   -576,   4608,    -90,     -9,     -9,     72, &
                    72,   -576,  -4464,   2016,    720,     72,  -4464,    720,  -5112,  -4464,     72,   -576,    720,  -5760, &
                 -5760,   -576,   -576,   4608,   4608, -36864,    720,     72,     72,   -576,   -576,   4608,    396,   1206, &
                   477,    558,   -171,    639,  -4626,  -4545,    558,  -4464,    639,  -5112,   -900,    -90,    -90,    720, &
                   720,  -5760,    -90,     -9,     -9,     72,     72,   -576]
  K1( 571,:) = [   3960,  -1224,   -495,   -576,    153,     72,  -1224,   -576,    153,   -657,     72,   -738,   -576,     72, &
                    72,     -9,     -9,    -90,   -657,     -9,   -738,    639,    -90,   -900,  -1143,    234,    234,   -576, &
                  -576,     72,   3960,  -1224,     72,  -4545,     -9,   1206,    153,     72,   -576,    639,     -9,     -9, &
                  -657,     -9,     72,   -171,    -90,    -90,   4041,   -414,   -414,   -495,   -495,    882,  -1224,   -576, &
                   720,  -4626,    -90,    396,   -495,    153,     72,    558,     72,    -90,   -576,   -657,     -9,    477, &
                   720,   -900,   4608,   -576,   -576,     72,     72,    720,  -1224,   -576,   4608,  -5112,     72,     72, &
                  3960,  -1224,   -576,  -4464,   -576,    720,   -576,  -5760,   -576,   -576,   4608,  -5760,   -576,     72, &
                    72,     -9,     -9,    -90,    153,     72,   -576,    639,     -9,     -9,   -495,    153,     72,    558, &
                    72,    -90,     72,    720,     72,     72,   -576,    720]
  K1( 572,:) = [  -1224,   -576,    153,   -657,     72,   -738,   3960,  -1224,   -495,   -576,    153,     72,     72,     -9, &
                  -576,     72,    -90,     -9,   -738,    639,   -657,     -9,   -900,    -90,   4041,   -414,   -414,   -495, &
                  -495,    882,  -1224,   -576,    720,  -4626,    -90,    396,   -495,    153,     72,    558,     72,    -90, &
                  -576,   -657,     -9,    477,    720,   -900,  -1143,    234,    234,   -576,   -576,     72,   3960,  -1224, &
                    72,  -4545,     -9,   1206,    153,     72,   -576,    639,     -9,     -9,   -657,     -9,     72,   -171, &
                   -90,    -90,   -576,     72,   4608,   -576,    720,     72,   3960,  -1224,   -576,  -4464,   -576,    720, &
                 -1224,   -576,   4608,  -5112,     72,     72,  -5760,   -576,   4608,  -5760,   -576,   -576,     72,     -9, &
                  -576,     72,    -90,     -9,   -495,    153,     72,    558,     72,    -90,    153,     72,   -576,    639, &
                    -9,     -9,    720,     72,   -576,    720,     72,     72]
  K1( 573,:) = [     -9,    -90,    -90,    558,    558,   -252,     72,    720,   -576,   4608,     72,   -576,     -9,    -90, &
                    72,   -576,     -9,     72,    639,    558,     -9,     72,    -90,    720,     72,    720,     -9,    639, &
                   -90,    558,     72,    720,     -9,    639,    -90,    558,     72,     -9,     72,     -9,     72,     72, &
                   720,    -90,    720,    -90,    720,    720,     72,    720,   -576,   4608,     72,   -576,     -9,    -90, &
                   -90,    558,    558,   -252,     72,   -576,     -9,    -90,     72,     -9,     -9,     72,    639,    558, &
                   720,    -90,     72,    720,   -576,   4608,     72,   -576,   -576,     72,   -576,     72,   -576,   -576, &
                  -576,   4608,     72,    720,   -576,     72,   -576,   4608,   4608,   4608,   4608,   -576,     -9,    -90, &
                    72,   -576,     -9,     72,     72,     -9,     72,     -9,     72,     72,     72,   -576,     -9,    -90, &
                    72,     -9,     72,   -576,   -576,   -576,   -576,     72]
  K1( 574,:) = [  -3978,   1044,    477,    558,    396,   -252,   1044,  -1224,    396,  -4626,   1044,    396,    558,    -90, &
                  -252,    558,     -9,    -90,  -4626,    558,    396,    477,    -90,   -900,   1206,    396,   -171,    639, &
                   477,    558,  -4545,  -4626,    639,  -5112,    558,  -4464,    -90,     -9,     -9,     72,     72,   -576, &
                  -900,    -90,    -90,    720,    720,  -5760,  -3978,   1044,   1206,  -4545,  -3978,   1206,   1206,    396, &
                   558,  -4464,   -252,   2016,    558,    639,    -90,    720,     -9,     72,    477,   -171,    558,  -4464, &
                   -90,    720,  -4464,    720,   2016,  -4464,     72,    720,    720,     72,     72,   -576,   -576,   4608, &
                 -4464,  -5112,    720,  -5760,     72,   -576,   -576,  -5760,   4608, -36864,   -576,   4608,    558,    -90, &
                  -252,    558,     -9,    -90,    -90,     -9,     -9,     72,     72,   -576,    558,    639,    -90,    720, &
                    -9,     72,     72,    720,   -576,   4608,     72,   -576]
  K1( 575,:) = [     72,    720,   -576,   4608,     72,   -576,     -9,    -90,    -90,    558,    558,   -252,     72,   -576, &
                    -9,    -90,     72,     -9,     -9,     72,    639,    558,    720,    -90,     72,    720,   -576,   4608, &
                    72,   -576,     -9,    -90,    -90,    558,    558,   -252,     72,   -576,     -9,    -90,     72,     -9, &
                    -9,     72,    639,    558,    720,    -90,     72,    720,     -9,    639,    -90,    558,     72,    720, &
                    -9,    639,    -90,    558,     72,     -9,     72,     -9,     72,     72,    720,    -90,    720,    -90, &
                   720,    720,   -576,   4608,     72,    720,   -576,     72,   -576,   4608,     72,    720,   -576,     72, &
                  -576,     72,   -576,     72,   -576,   -576,   4608,   -576,   4608,   -576,   4608,   4608,     72,   -576, &
                    -9,    -90,     72,     -9,     72,   -576,     -9,    -90,     72,     -9,     72,     -9,     72,     -9, &
                    72,     72,   -576,     72,   -576,     72,   -576,   -576]
  K1( 576,:) = [   1044,  -1224,    396,  -4626,   1044,    396,  -3978,   1044,    477,    558,    396,   -252,   -252,    558, &
                   558,    -90,    -90,     -9,    396,    477,  -4626,    558,   -900,    -90,  -3978,   1044,   1206,  -4545, &
                 -3978,   1206,   1206,    396,    558,  -4464,   -252,   2016,    558,    639,    -90,    720,     -9,     72, &
                   477,   -171,    558,  -4464,    -90,    720,   1206,    396,   -171,    639,    477,    558,  -4545,  -4626, &
                   639,  -5112,    558,  -4464,    -90,     -9,     -9,     72,     72,   -576,   -900,    -90,    -90,    720, &
                   720,  -5760,   2016,  -4464,  -4464,    720,    720,     72,  -4464,  -5112,    720,  -5760,     72,   -576, &
                   720,     72,     72,   -576,   -576,   4608,  -5760,   -576,   -576,   4608,   4608, -36864,   -252,    558, &
                   558,    -90,    -90,     -9,    558,    639,    -90,    720,     -9,     72,    -90,     -9,     -9,     72, &
                    72,   -576,    720,     72,     72,   -576,   -576,   4608]
  K1( 577,:) = [   4608,   -576,   -576,     72,     72,    720,   -576,     72,     72,     -9,     -9,    -90,     72,     -9, &
                   720,    -90,    639,    558,     -9,    -90,    -90,    558,    558,   -252,   -495,    153,    882,   -657, &
                    72,    720,   -495,   -576,   4608,  -4545,    639,    639,   -414,    234,   -576,   1206,     -9,   -171, &
                    -9,    -90,     -9,     -9,     72,    -90,   -414,   -495,   -495,    153,    153,   -657,    882,     72, &
                  -576,   1206,    558,    558,   4041,  -1143,     72,  -3978,     72,   1206,     72,     -9,    -90,    -90, &
                  -576,    558,   4041,   -414,   -414,   -495,   -495,    882,   -495,   -576,     72,  -3978,    -90,    477, &
                  -414,    234,    720,   1044,    720,    396,   -576,     72,     -9,    558,     72,   -252,     72,    720, &
                   720,  -4464,  -4464,   2016,     72,    720,     72,     72,   -576,    720,   -576,     72,    720,    720, &
                  4608,  -4464,   4608,   -576,     72,  -4464,   -576,   2016]
  K1( 578,:) = [   -576,     72,   4608,   -576,    720,     72,     72,     -9,    720,    -90,    639,    558,   -576,     72, &
                    72,     -9,     -9,    -90,    -90,     -9,    558,   -252,    -90,    558,    882,   -657,   -495,    153, &
                   720,     72,   -414,    234,   -576,   1206,     -9,   -171,   -495,   -576,   4608,  -4545,    639,    639, &
                   -90,     -9,     72,    -90,     -9,     -9,   4041,   -414,   -414,   -495,   -495,    882,   -495,   -576, &
                    72,  -3978,    -90,    477,   -414,    234,    720,   1044,    720,    396,   -576,     72,     -9,    558, &
                    72,   -252,   -414,   -495,   -495,    153,    153,   -657,    882,     72,   -576,   1206,    558,    558, &
                  4041,  -1143,     72,  -3978,     72,   1206,     72,     -9,    -90,    -90,   -576,    558,    720,     72, &
                 -4464,   2016,    720,  -4464,    720,     72,   -576,    720,     72,     72,   4608,   -576,     72,  -4464, &
                  -576,   2016,   -576,     72,    720,    720,   4608,  -4464]
  K1( 579,:) = [   -576,     72,     72,     -9,     -9,    -90,   4608,   -576,   -576,     72,     72,    720,    720,    -90, &
                    72,     -9,    558,    639,    -90,    558,     -9,    -90,   -252,    558,   -414,   -495,   -495,    153, &
                   153,   -657,    882,     72,   -576,   1206,    558,    558,   4041,  -1143,     72,  -3978,     72,   1206, &
                    72,     -9,    -90,    -90,   -576,    558,   -495,    153,    882,   -657,     72,    720,   -495,   -576, &
                  4608,  -4545,    639,    639,   -414,    234,   -576,   1206,     -9,   -171,     -9,    -90,     -9,     -9, &
                    72,    -90,   -414,   -495,   4041,   -414,    882,   -495,   -414,    234,    720,   1044,    720,    396, &
                  -495,   -576,     72,  -3978,    -90,    477,     72,   -576,     72,   -252,     -9,    558,    720,  -4464, &
                    72,    720,   2016,  -4464,   -576,     72,    720,    720,   4608,  -4464,     72,    720,     72,     72, &
                  -576,    720,   -576,   4608,   -576,   2016,     72,  -4464]
  K1( 580,:) = [     72,     -9,    720,    -90,    639,    558,   -576,     72,   4608,   -576,    720,     72,     72,     -9, &
                  -576,     72,    -90,     -9,    558,   -252,    -90,     -9,    558,    -90,   4041,   -414,   -414,   -495, &
                  -495,    882,   -495,   -576,     72,  -3978,    -90,    477,   -414,    234,    720,   1044,    720,    396, &
                  -576,     72,     -9,    558,     72,   -252,    882,   -657,   -495,    153,    720,     72,   -414,    234, &
                  -576,   1206,     -9,   -171,   -495,   -576,   4608,  -4545,    639,    639,    -90,     -9,     72,    -90, &
                    -9,     -9,   -495,    153,   -414,   -495,   -657,    153,   4041,  -1143,     72,  -3978,     72,   1206, &
                   882,     72,   -576,   1206,    558,    558,     -9,     72,   -576,    558,    -90,    -90,  -4464,   2016, &
                   720,     72,  -4464,    720,   4608,   -576,     72,  -4464,   -576,   2016,    720,     72,   -576,    720, &
                    72,     72,     72,   -576,   4608,  -4464,    720,    720]
  K1( 581,:) = [     72,     -9,   -576,     72,    -90,     -9,    720,    -90,     72,     -9,    558,    639,   4608,   -576, &
                  -576,     72,     72,    720,    558,    -90,   -252,    558,     -9,    -90,   -495,    153,   -414,   -495, &
                  -657,    153,   4041,  -1143,     72,  -3978,     72,   1206,    882,     72,   -576,   1206,    558,    558, &
                    -9,     72,   -576,    558,    -90,    -90,   -414,   -495,   4041,   -414,    882,   -495,   -414,    234, &
                   720,   1044,    720,    396,   -495,   -576,     72,  -3978,    -90,    477,     72,   -576,     72,   -252, &
                    -9,    558,   -495,    153,    882,   -657,     72,    720,   -495,   -576,   4608,  -4545,    639,    639, &
                  -414,    234,   -576,   1206,     -9,   -171,     -9,    -90,     -9,     -9,     72,    -90,  -4464,    720, &
                  2016,  -4464,     72,    720,     72,   -576,   4608,  -4464,    720,    720,   -576,   4608,   -576,   2016, &
                    72,  -4464,     72,    720,     72,     72,   -576,    720]
  K1( 582,:) = [    720,    -90,     72,     -9,    558,    639,     72,     -9,   -576,     72,    -90,     -9,   -576,     72, &
                  4608,   -576,    720,     72,   -252,    558,    558,    -90,    -90,     -9,   -414,   -495,   4041,   -414, &
                   882,   -495,   -414,    234,    720,   1044,    720,    396,   -495,   -576,     72,  -3978,    -90,    477, &
                    72,   -576,     72,   -252,     -9,    558,   -495,    153,   -414,   -495,   -657,    153,   4041,  -1143, &
                    72,  -3978,     72,   1206,    882,     72,   -576,   1206,    558,    558,     -9,     72,   -576,    558, &
                   -90,    -90,    882,   -657,   -495,    153,    720,     72,   -414,    234,   -576,   1206,     -9,   -171, &
                  -495,   -576,   4608,  -4545,    639,    639,    -90,     -9,     72,    -90,     -9,     -9,   2016,  -4464, &
                 -4464,    720,    720,     72,   -576,   4608,   -576,   2016,     72,  -4464,     72,   -576,   4608,  -4464, &
                   720,    720,    720,     72,   -576,    720,     72,     72]
  K1( 583,:) = [   -657,     -9,   -738,    639,    -90,   -900,    153,     72,  -1224,   3960,   -576,   -495,     72,   -738, &
                  -576,  -1224,   -657,    153,     -9,    -90,     72,   -576,     -9,     72,   -576,     72,     72,     -9, &
                    -9,    -90,    153,     72,   -576,    639,     -9,     -9,   -495,    153,     72,    558,     72,    -90, &
                    72,    720,     72,     72,   -576,    720,   -576,     72,    234,  -1143,   -576,    234,   -657,     -9, &
                    72,   -171,    -90,    -90,  -1224,   3960,     -9,   1206,     72,  -4545,     72,    153,     -9,     -9, &
                  -576,    639,   -495,    882,   -414,   4041,   -495,   -414,   -576,   -657,     -9,    477,    720,   -900, &
                  -576,  -1224,    -90,    396,    720,  -4626,    153,   -495,     72,    -90,     72,    558,     72,    720, &
                  -576,   4608,     72,   -576,   -576,  -5760,   -576,   -576,   4608,  -5760,   -576,  -1224,     72,     72, &
                  4608,  -5112,  -1224,   3960,   -576,    720,   -576,  -4464]
  K1( 584,:) = [   -738,    639,   -657,     -9,   -900,    -90,     72,   -738,   -576,  -1224,   -657,    153,    153,     72, &
                 -1224,   3960,   -576,   -495,    -90,     -9,     -9,     72,     72,   -576,     72,     -9,   -576,     72, &
                   -90,     -9,   -495,    153,     72,    558,     72,    -90,    153,     72,   -576,    639,     -9,     -9, &
                   720,     72,   -576,    720,     72,     72,   -495,    882,   -414,   4041,   -495,   -414,   -576,   -657, &
                    -9,    477,    720,   -900,   -576,  -1224,    -90,    396,    720,  -4626,    153,   -495,     72,    -90, &
                    72,    558,   -576,     72,    234,  -1143,   -576,    234,   -657,     -9,     72,   -171,    -90,    -90, &
                 -1224,   3960,     -9,   1206,     72,  -4545,     72,    153,     -9,     -9,   -576,    639,    720,     72, &
                    72,   -576,   -576,   4608,  -5760,   -576,   4608,  -5760,   -576,   -576,  -1224,   3960,   -576,    720, &
                  -576,  -4464,   -576,  -1224,     72,     72,   4608,  -5112]
  K1( 585,:) = [    639,    558,     -9,     72,    -90,    720,    558,   -252,    -90,     -9,    558,    -90,     72,   -576, &
                   720,     72,   4608,   -576,     -9,     72,    -90,     -9,   -576,     72,     -9,    -90,     72,   -576, &
                    -9,     72,     72,     -9,     72,     -9,     72,     72,     72,   -576,     -9,    -90,     72,     -9, &
                    72,   -576,   -576,   -576,   -576,     72,    -90,    558,    720,     72,    639,     -9,    720,    -90, &
                   720,    -90,    720,    720,    720,     72,    -90,    558,     -9,    639,     -9,     72,     72,     72, &
                    72,     -9,     72,   -576,    720,     72,   4608,   -576,     -9,     72,    639,    558,    720,    -90, &
                   -90,     -9,    558,   -252,    -90,    558,   -576,     72,     72,     -9,     -9,    -90,     72,   -576, &
                   720,     72,   4608,   -576,   -576,   4608,   4608,   4608,   4608,   -576,     72,   -576,   -576,   -576, &
                  -576,     72,   4608,   -576,   -576,     72,     72,    720]
  K1( 586,:) = [  -4626,    558,    396,    477,    -90,   -900,    396,   -252,   1044,  -3978,    558,    477,   1044,    396, &
                 -1224,   1044,  -4626,    396,     -9,    -90,    -90,    558,    558,   -252,    558,    -90,   -252,    558, &
                    -9,    -90,    -90,     -9,     -9,     72,     72,   -576,    558,    639,    -90,    720,     -9,     72, &
                    72,    720,   -576,   4608,     72,   -576,    477,    558,    396,   1206,    639,   -171,   -900,    -90, &
                   -90,    720,    720,  -5760,  -4626,  -4545,    558,  -4464,    639,  -5112,     -9,    -90,     72,   -576, &
                    -9,     72,  -3978,   1206,   1044,  -3978,  -4545,   1206,    477,   -171,    558,  -4464,    -90,    720, &
                   396,   1206,   -252,   2016,    558,  -4464,    639,    558,     -9,     72,    -90,    720,     72,    720, &
                   720,  -4464,  -4464,   2016,   -576,  -5760,   4608, -36864,   -576,   4608,     72,    720,   -576,   4608, &
                    72,   -576,  -5112,  -4464,     72,   -576,    720,  -5760]
  K1( 587,:) = [     -9,     72,    639,    558,    720,    -90,     72,   -576,    720,     72,   4608,   -576,    558,   -252, &
                   -90,     -9,    558,    -90,     72,     -9,   -576,     72,    -90,     -9,     72,   -576,     -9,    -90, &
                    72,     -9,     72,   -576,     -9,    -90,     72,     -9,     72,     -9,     72,     -9,     72,     72, &
                  -576,     72,   -576,     72,   -576,   -576,     72,   -576,    720,     72,   4608,   -576,     -9,     72, &
                   639,    558,    720,    -90,    -90,     -9,    558,   -252,    -90,    558,   -576,     72,     72,     -9, &
                    -9,    -90,    -90,    558,    720,     72,    639,     -9,    720,    -90,    720,    -90,    720,    720, &
                   720,     72,    -90,    558,     -9,    639,     -9,     72,     72,     72,     72,     -9,   -576,     72, &
                  4608,   -576,    720,     72,   4608,   -576,   4608,   -576,   4608,   4608,   4608,   -576,   -576,     72, &
                    72,    720,     72,   -576,   -576,   -576,   -576,     72]
  K1( 588,:) = [    396,    477,  -4626,    558,   -900,    -90,   1044,    396,  -1224,   1044,  -4626,    396,    396,   -252, &
                  1044,  -3978,    558,    477,    -90,     -9,    558,   -252,    -90,    558,   -252,    558,    558,    -90, &
                   -90,     -9,    558,    639,    -90,    720,     -9,     72,    -90,     -9,     -9,     72,     72,   -576, &
                   720,     72,     72,   -576,   -576,   4608,  -3978,   1206,   1044,  -3978,  -4545,   1206,    477,   -171, &
                   558,  -4464,    -90,    720,    396,   1206,   -252,   2016,    558,  -4464,    639,    558,     -9,     72, &
                   -90,    720,    477,    558,    396,   1206,    639,   -171,   -900,    -90,    -90,    720,    720,  -5760, &
                 -4626,  -4545,    558,  -4464,    639,  -5112,     -9,    -90,     72,   -576,     -9,     72,    720,     72, &
                 -4464,   2016,    720,  -4464,  -5760,   -576,   -576,   4608,   4608, -36864,  -5112,  -4464,     72,   -576, &
                   720,  -5760,     72,    720,   -576,   4608,     72,   -576]
  K1( 589,:) = [    153,     72,  -1224,   3960,   -576,   -495,   -657,     -9,   -738,    639,    -90,   -900,   -576,  -1224, &
                    72,   -738,    153,   -657,     72,   -576,     -9,    -90,     72,     -9,   -576,     72,    234,  -1143, &
                  -576,    234,   -657,     -9,     72,   -171,    -90,    -90,  -1224,   3960,     -9,   1206,     72,  -4545, &
                    72,    153,     -9,     -9,   -576,    639,   -576,     72,     72,     -9,     -9,    -90,    153,     72, &
                  -576,    639,     -9,     -9,   -495,    153,     72,    558,     72,    -90,     72,    720,     72,     72, &
                  -576,    720,   -414,   4041,   -495,    882,   -414,   -495,   -576,  -1224,    -90,    396,    720,  -4626, &
                  -576,   -657,     -9,    477,    720,   -900,   -495,    153,     72,    558,     72,    -90,   -576,   4608, &
                    72,    720,   -576,     72,   -576,  -1224,     72,     72,   4608,  -5112,   -576,  -5760,   -576,   -576, &
                  4608,  -5760,   3960,  -1224,   -576,  -4464,   -576,    720]
  K1( 590,:) = [     72,   -738,   -576,  -1224,   -657,    153,   -738,    639,   -657,     -9,   -900,    -90,  -1224,   3960, &
                   153,     72,   -495,   -576,     -9,     72,    -90,     -9,   -576,     72,   -495,    882,   -414,   4041, &
                  -495,   -414,   -576,   -657,     -9,    477,    720,   -900,   -576,  -1224,    -90,    396,    720,  -4626, &
                   153,   -495,     72,    -90,     72,    558,     72,     -9,   -576,     72,    -90,     -9,   -495,    153, &
                    72,    558,     72,    -90,    153,     72,   -576,    639,     -9,     -9,    720,     72,   -576,    720, &
                    72,     72,    234,  -1143,   -576,     72,    234,   -576,  -1224,   3960,     -9,   1206,     72,  -4545, &
                  -657,     -9,     72,   -171,    -90,    -90,    153,     72,   -576,    639,     -9,     -9,     72,   -576, &
                   720,     72,   4608,   -576,  -1224,   3960,   -576,    720,   -576,  -4464,  -5760,   -576,   4608,  -5760, &
                  -576,   -576,  -1224,   -576,   4608,  -5112,     72,     72]
  K1( 591,:) = [    558,   -252,    -90,     -9,    558,    -90,    639,    558,     -9,     72,    -90,    720,    720,     72, &
                    72,   -576,   -576,   4608,    -90,     -9,     -9,     72,     72,   -576,    -90,    558,    720,     72, &
                   639,     -9,    720,    -90,    720,    -90,    720,    720,    720,     72,    -90,    558,     -9,    639, &
                    -9,     72,     72,     72,     72,     -9,     -9,    -90,     72,   -576,     -9,     72,     72,     -9, &
                    72,     -9,     72,     72,     72,   -576,     -9,    -90,     72,     -9,     72,   -576,   -576,   -576, &
                  -576,     72,    720,     72,     72,   -576,   -576,   4608,    -90,     -9,    558,   -252,    -90,    558, &
                    -9,     72,    639,    558,    720,    -90,     72,   -576,     -9,    -90,     72,     -9,    720,     72, &
                    72,   -576,   -576,   4608,     72,   -576,   -576,   -576,   -576,     72,   -576,   4608,   4608,   4608, &
                  4608,   -576,   -576,   4608,     72,    720,   -576,     72]
  K1( 592,:) = [    396,   -252,   1044,  -3978,    558,    477,  -4626,    558,    396,    477,    -90,   -900,  -1224,   1044, &
                  1044,    396,    396,  -4626,    -90,    558,     -9,    -90,   -252,    558,    477,    558,    396,   1206, &
                   639,   -171,   -900,    -90,    -90,    720,    720,  -5760,  -4626,  -4545,    558,  -4464,    639,  -5112, &
                    -9,    -90,     72,   -576,     -9,     72,    558,    -90,   -252,    558,     -9,    -90,    -90,     -9, &
                    -9,     72,     72,   -576,    558,    639,    -90,    720,     -9,     72,     72,    720,   -576,   4608, &
                    72,   -576,   1044,  -3978,  -3978,   1206,   1206,  -4545,    396,   1206,   -252,   2016,    558,  -4464, &
                   477,   -171,    558,  -4464,    -90,    720,    558,    639,    -90,    720,     -9,     72,    720,  -4464, &
                    72,    720,   2016,  -4464,     72,    720,   -576,   4608,     72,   -576,   -576,  -5760,   4608, -36864, &
                  -576,   4608,  -4464,  -5112,    720,  -5760,     72,   -576]
  K1( 593,:) = [     72,   -576,    720,     72,   4608,   -576,     -9,     72,    639,    558,    720,    -90,    -90,     -9, &
                   558,   -252,    -90,    558,   -576,     72,     72,     -9,     -9,    -90,     72,   -576,    720,     72, &
                  4608,   -576,     -9,     72,    639,    558,    720,    -90,    -90,     -9,    558,   -252,    -90,    558, &
                  -576,     72,     72,     -9,     -9,    -90,     72,   -576,     -9,    -90,     72,     -9,     72,   -576, &
                    -9,    -90,     72,     -9,     72,     -9,     72,     -9,     72,     72,   -576,     72,   -576,     72, &
                  -576,   -576,    720,     72,    -90,    558,     -9,    639,    720,     72,    -90,    558,     -9,    639, &
                   720,    -90,    720,    -90,    720,    720,     72,     -9,     72,     -9,     72,     72,   4608,   -576, &
                  -576,     72,     72,    720,   4608,   -576,   -576,     72,     72,    720,   4608,   -576,   4608,   -576, &
                  4608,   4608,   -576,     72,   -576,     72,   -576,   -576]
  K1( 594,:) = [   1044,    396,  -1224,   1044,  -4626,    396,    396,    477,  -4626,    558,   -900,    -90,   1044,  -3978, &
                   396,   -252,    477,    558,    558,   -252,    -90,     -9,    558,    -90,  -3978,   1206,   1044,  -3978, &
                 -4545,   1206,    477,   -171,    558,  -4464,    -90,    720,    396,   1206,   -252,   2016,    558,  -4464, &
                   639,    558,     -9,     72,    -90,    720,   -252,    558,    558,    -90,    -90,     -9,    558,    639, &
                   -90,    720,     -9,     72,    -90,     -9,     -9,     72,     72,   -576,    720,     72,     72,   -576, &
                  -576,   4608,    396,   1206,    477,    558,   -171,    639,  -4626,  -4545,    558,  -4464,    639,  -5112, &
                  -900,    -90,    -90,    720,    720,  -5760,    -90,     -9,     -9,     72,     72,   -576,  -4464,   2016, &
                   720,     72,  -4464,    720,  -5112,  -4464,     72,   -576,    720,  -5760,  -5760,   -576,   -576,   4608, &
                  4608, -36864,    720,     72,     72,   -576,   -576,   4608]
  K1( 595,:) = [  -1224,   3960,    153,     72,   -495,   -576,   -576,  -1224,     72,   -738,    153,   -657,   -657,     -9, &
                  -738,    639,    -90,   -900,   -576,     72,     72,     -9,     -9,    -90,    234,  -1143,   -576,     72, &
                   234,   -576,  -1224,   3960,     -9,   1206,     72,  -4545,   -657,     -9,     72,   -171,    -90,    -90, &
                   153,     72,   -576,    639,     -9,     -9,   -414,   4041,   -495,    882,   -414,   -495,   -576,  -1224, &
                   -90,    396,    720,  -4626,   -576,   -657,     -9,    477,    720,   -900,   -495,    153,     72,    558, &
                    72,    -90,   -576,     72,     72,     -9,     -9,    -90,    153,     72,   -576,    639,     -9,     -9, &
                  -495,    153,     72,    558,     72,    -90,     72,    720,     72,     72,   -576,    720,   4608,   -576, &
                  -576,     72,     72,    720,  -1224,   -576,   4608,  -5112,     72,     72,   3960,  -1224,   -576,  -4464, &
                  -576,    720,   -576,  -5760,   -576,   -576,   4608,  -5760]
  K1( 596,:) = [   -576,  -1224,     72,   -738,    153,   -657,  -1224,   3960,    153,     72,   -495,   -576,   -738,    639, &
                  -657,     -9,   -900,    -90,     72,     -9,   -576,     72,    -90,     -9,   -414,   4041,   -495,    882, &
                  -414,   -495,   -576,  -1224,    -90,    396,    720,  -4626,   -576,   -657,     -9,    477,    720,   -900, &
                  -495,    153,     72,    558,     72,    -90,    234,  -1143,   -576,     72,    234,   -576,  -1224,   3960, &
                    -9,   1206,     72,  -4545,   -657,     -9,     72,   -171,    -90,    -90,    153,     72,   -576,    639, &
                    -9,     -9,     72,     -9,   -576,     72,    -90,     -9,   -495,    153,     72,    558,     72,    -90, &
                   153,     72,   -576,    639,     -9,     -9,    720,     72,   -576,    720,     72,     72,   -576,     72, &
                  4608,   -576,    720,     72,   3960,  -1224,   -576,  -4464,   -576,    720,  -1224,   -576,   4608,  -5112, &
                    72,     72,  -5760,   -576,   4608,  -5760,   -576,   -576]
  K1( 597,:) = [    -90,     -9,    558,   -252,    -90,    558,    720,     72,     72,   -576,   -576,   4608,    639,    558, &
                    -9,     72,    -90,    720,     -9,    -90,     72,   -576,     -9,     72,    720,     72,    -90,    558, &
                    -9,    639,    720,     72,    -90,    558,     -9,    639,    720,    -90,    720,    -90,    720,    720, &
                    72,     -9,     72,     -9,     72,     72,    720,     72,     72,   -576,   -576,   4608,    -90,     -9, &
                   558,   -252,    -90,    558,     -9,     72,    639,    558,    720,    -90,     72,   -576,     -9,    -90, &
                    72,     -9,     -9,    -90,     72,   -576,     -9,     72,     72,     -9,     72,     -9,     72,     72, &
                    72,   -576,     -9,    -90,     72,     -9,     72,   -576,   -576,   -576,   -576,     72,     72,    720, &
                  -576,   4608,     72,   -576,   -576,     72,   -576,     72,   -576,   -576,   -576,   4608,     72,    720, &
                  -576,     72,   -576,   4608,   4608,   4608,   4608,   -576]
  K1( 598,:) = [   1044,  -3978,    396,   -252,    477,    558,  -1224,   1044,   1044,    396,    396,  -4626,  -4626,    558, &
                   396,    477,    -90,   -900,    558,    -90,   -252,    558,     -9,    -90,    396,   1206,    477,    558, &
                  -171,    639,  -4626,  -4545,    558,  -4464,    639,  -5112,   -900,    -90,    -90,    720,    720,  -5760, &
                   -90,     -9,     -9,     72,     72,   -576,   1044,  -3978,  -3978,   1206,   1206,  -4545,    396,   1206, &
                  -252,   2016,    558,  -4464,    477,   -171,    558,  -4464,    -90,    720,    558,    639,    -90,    720, &
                    -9,     72,    558,    -90,   -252,    558,     -9,    -90,    -90,     -9,     -9,     72,     72,   -576, &
                   558,    639,    -90,    720,     -9,     72,     72,    720,   -576,   4608,     72,   -576,  -4464,    720, &
                  2016,  -4464,     72,    720,    720,     72,     72,   -576,   -576,   4608,  -4464,  -5112,    720,  -5760, &
                    72,   -576,   -576,  -5760,   4608, -36864,   -576,   4608]
  K1( 599,:) = [    720,     72,     72,   -576,   -576,   4608,    -90,     -9,    558,   -252,    -90,    558,     -9,     72, &
                   639,    558,    720,    -90,     72,   -576,     -9,    -90,     72,     -9,    720,     72,     72,   -576, &
                  -576,   4608,    -90,     -9,    558,   -252,    -90,    558,     -9,     72,    639,    558,    720,    -90, &
                    72,   -576,     -9,    -90,     72,     -9,    720,     72,    -90,    558,     -9,    639,    720,     72, &
                   -90,    558,     -9,    639,    720,    -90,    720,    -90,    720,    720,     72,     -9,     72,     -9, &
                    72,     72,     72,   -576,     -9,    -90,     72,     -9,     72,   -576,     -9,    -90,     72,     -9, &
                    72,     -9,     72,     -9,     72,     72,   -576,     72,   -576,     72,   -576,   -576,   -576,   4608, &
                    72,    720,   -576,     72,   -576,   4608,     72,    720,   -576,     72,   -576,     72,   -576,     72, &
                  -576,   -576,   4608,   -576,   4608,   -576,   4608,   4608]
  K1( 600,:) = [  -1224,   1044,   1044,    396,    396,  -4626,   1044,  -3978,    396,   -252,    477,    558,    396,    477, &
                 -4626,    558,   -900,    -90,   -252,    558,    558,    -90,    -90,     -9,   1044,  -3978,  -3978,   1206, &
                  1206,  -4545,    396,   1206,   -252,   2016,    558,  -4464,    477,   -171,    558,  -4464,    -90,    720, &
                   558,    639,    -90,    720,     -9,     72,    396,   1206,    477,    558,   -171,    639,  -4626,  -4545, &
                   558,  -4464,    639,  -5112,   -900,    -90,    -90,    720,    720,  -5760,    -90,     -9,     -9,     72, &
                    72,   -576,   -252,    558,    558,    -90,    -90,     -9,    558,    639,    -90,    720,     -9,     72, &
                   -90,     -9,     -9,     72,     72,   -576,    720,     72,     72,   -576,   -576,   4608,   2016,  -4464, &
                 -4464,    720,    720,     72,  -4464,  -5112,    720,  -5760,     72,   -576,    720,     72,     72,   -576, &
                  -576,   4608,  -5760,   -576,   -576,   4608,   4608, -36864]
  K1( 601,:) = [ -36864,   4608,   4608,   -576,   -576,  -5760,   4608,   -576,   -576,     72,     72,    720,   -576,     72, &
                 -5760,    720,  -5112,  -4464,     72,    720,    720,  -4464,  -4464,   2016,   4608,   -576,   -576,     72, &
                    72,    720,   -576,     72,     72,     -9,     -9,    -90,     72,     -9,    720,    -90,    639,    558, &
                    -9,    -90,    -90,    558,    558,   -252,   -576,     72,     72,     -9,     -9,    -90,  -5760,    720, &
                   720,    -90,    -90,   -900,  -5112,    639,  -4464,    558,  -4545,  -4626,    639,   -171,    558,    477, &
                  1206,    396,     72,     -9,    720,    -90,    639,    558,    720,    -90,  -4464,    558,   -171,    477, &
                 -4464,    558,   2016,   -252,   1206,    396,  -4545,   1206,   1206,  -3978,  -3978,   1044,     -9,    -90, &
                   -90,    558,    558,   -252,    -90,   -900,    558,  -4626,    477,    396,    558,    477,   -252,    396, &
                 -3978,   1044,  -4626,    396,    396,   1044,   1044,  -1224]
  K1( 602,:) = [   4608, -36864,   -576,  -5760,   4608,   -576,   -576,   4608,     72,    720,   -576,     72,     72,    720, &
                   720,  -4464,  -4464,   2016,   -576,     72,  -5760,    720,  -5112,  -4464,   -576,   4608,     72,    720, &
                  -576,     72,     72,   -576,     -9,    -90,     72,     -9,     -9,    -90,    -90,    558,    558,   -252, &
                    72,     -9,    720,    -90,    639,    558,     72,   -576,     -9,    -90,     72,     -9,    720,  -5760, &
                   -90,   -900,    720,    -90,    639,   -171,    558,    477,   1206,    396,  -5112,    639,  -4464,    558, &
                 -4545,  -4626,     -9,    -90,    -90,    558,    558,   -252,    -90,   -900,    558,  -4626,    477,    396, &
                   558,    477,   -252,    396,  -3978,   1044,  -4626,    396,    396,   1044,   1044,  -1224,     72,     -9, &
                   720,    -90,    639,    558,    720,    -90,  -4464,    558,   -171,    477,  -4464,    558,   2016,   -252, &
                  1206,    396,  -4545,   1206,   1206,  -3978,  -3978,   1044]
  K1( 603,:) = [   4608,   -576, -36864,   4608,  -5760,   -576,   -576,     72,  -5760,    720,  -5112,  -4464,   4608,   -576, &
                  -576,     72,     72,    720,    720,     72,  -4464,   2016,    720,  -4464,   -576,     72,   4608,   -576, &
                   720,     72,     72,     -9,    720,    -90,    639,    558,   -576,     72,     72,     -9,     -9,    -90, &
                   -90,     -9,    558,   -252,    -90,    558,     72,     -9,    720,    -90,    639,    558,    720,    -90, &
                 -4464,    558,   -171,    477,  -4464,    558,   2016,   -252,   1206,    396,  -4545,   1206,   1206,  -3978, &
                 -3978,   1044,   -576,     72,     72,     -9,     -9,    -90,  -5760,    720,    720,    -90,    -90,   -900, &
                 -5112,    639,  -4464,    558,  -4545,  -4626,    639,   -171,    558,    477,   1206,    396,    -90,     -9, &
                   558,   -252,    -90,    558,   -900,    -90,    477,    396,    558,  -4626,  -4626,    396,    396,   1044, &
                  1044,  -1224,    558,    477,   -252,    396,  -3978,   1044]
  K1( 604,:) = [   -576,  -5760,   4608, -36864,   -576,   4608,     72,    720,    720,  -4464,  -4464,   2016,   -576,   4608, &
                    72,    720,   -576,     72,     72,   -576,  -5112,  -4464,  -5760,    720,     72,    720,   -576,   4608, &
                    72,   -576,     -9,    -90,    -90,    558,    558,   -252,     72,   -576,     -9,    -90,     72,     -9, &
                    -9,     72,    639,    558,    720,    -90,     -9,    -90,    -90,    558,    558,   -252,    -90,   -900, &
                   558,  -4626,    477,    396,    558,    477,   -252,    396,  -3978,   1044,  -4626,    396,    396,   1044, &
                  1044,  -1224,     72,   -576,     -9,    -90,     72,     -9,    720,  -5760,    -90,   -900,    720,    -90, &
                   639,   -171,    558,    477,   1206,    396,  -5112,    639,  -4464,    558,  -4545,  -4626,     -9,     72, &
                   639,    558,    720,    -90,    -90,    720,   -171,    477,  -4464,    558,  -4545,   1206,   1206,  -3978, &
                 -3978,   1044,  -4464,    558,   2016,   -252,   1206,    396]
  K1( 605,:) = [   -576,   4608,  -5760,   -576, -36864,   4608,     72,   -576,  -5112,  -4464,  -5760,    720,    720,     72, &
                 -4464,   2016,    720,  -4464,   4608,   -576,   -576,     72,     72,    720,     72,   -576,    720,     72, &
                  4608,   -576,     -9,     72,    639,    558,    720,    -90,    -90,     -9,    558,   -252,    -90,    558, &
                  -576,     72,     72,     -9,     -9,    -90,     -9,     72,    639,    558,    720,    -90,    -90,    720, &
                  -171,    477,  -4464,    558,  -4545,   1206,   1206,  -3978,  -3978,   1044,  -4464,    558,   2016,   -252, &
                  1206,    396,    -90,     -9,    558,   -252,    -90,    558,   -900,    -90,    477,    396,    558,  -4626, &
                 -4626,    396,    396,   1044,   1044,  -1224,    558,    477,   -252,    396,  -3978,   1044,   -576,     72, &
                    72,     -9,     -9,    -90,  -5760,    720,    720,    -90,    -90,   -900,  -5112,    639,  -4464,    558, &
                 -4545,  -4626,    639,   -171,    558,    477,   1206,    396]
  K1( 606,:) = [  -5760,   -576,   -576,   4608,   4608, -36864,    720,     72,  -4464,   2016,    720,  -4464,     72,   -576, &
                 -5112,  -4464,  -5760,    720,   -576,   4608,     72,    720,   -576,     72,    720,     72,     72,   -576, &
                  -576,   4608,    -90,     -9,    558,   -252,    -90,    558,     -9,     72,    639,    558,    720,    -90, &
                    72,   -576,     -9,    -90,     72,     -9,    -90,     -9,    558,   -252,    -90,    558,   -900,    -90, &
                   477,    396,    558,  -4626,  -4626,    396,    396,   1044,   1044,  -1224,    558,    477,   -252,    396, &
                 -3978,   1044,     -9,     72,    639,    558,    720,    -90,    -90,    720,   -171,    477,  -4464,    558, &
                 -4545,   1206,   1206,  -3978,  -3978,   1044,  -4464,    558,   2016,   -252,   1206,    396,     72,   -576, &
                    -9,    -90,     72,     -9,    720,  -5760,    -90,   -900,    720,    -90,    639,   -171,    558,    477, &
                  1206,    396,  -5112,    639,  -4464,    558,  -4545,  -4626]
  K1( 607,:) = [   4608,   -576,   -576,     72,     72,    720, -36864,   4608,   4608,   -576,   -576,  -5760,  -5760,    720, &
                  -576,     72,  -4464,  -5112,    720,  -4464,     72,    720,   2016,  -4464,   -576,     72,     72,     -9, &
                    -9,    -90,  -5760,    720,    720,    -90,    -90,   -900,  -5112,    639,  -4464,    558,  -4545,  -4626, &
                   639,   -171,    558,    477,   1206,    396,   4608,   -576,   -576,     72,     72,    720,   -576,     72, &
                    72,     -9,     -9,    -90,     72,     -9,    720,    -90,    639,    558,     -9,    -90,    -90,    558, &
                   558,   -252,    720,    -90,     72,     -9,    558,    639,  -4464,    558,   2016,   -252,   1206,    396, &
                   720,    -90,  -4464,    558,   -171,    477,   1206,  -4545,  -3978,   1044,   1206,  -3978,    -90,    558, &
                    -9,    -90,   -252,    558,    558,    477,   -252,    396,  -3978,   1044,    -90,   -900,    558,  -4626, &
                   477,    396,    396,  -4626,   1044,  -1224,    396,   1044]
  K1( 608,:) = [   -576,   4608,     72,    720,   -576,     72,   4608, -36864,   -576,  -5760,   4608,   -576,    720,  -4464, &
                    72,    720,   2016,  -4464,  -5760,    720,   -576,     72,  -4464,  -5112,     72,   -576,     -9,    -90, &
                    72,     -9,    720,  -5760,    -90,   -900,    720,    -90,    639,   -171,    558,    477,   1206,    396, &
                 -5112,    639,  -4464,    558,  -4545,  -4626,   -576,   4608,     72,    720,   -576,     72,     72,   -576, &
                    -9,    -90,     72,     -9,     -9,    -90,    -90,    558,    558,   -252,     72,     -9,    720,    -90, &
                   639,    558,    -90,    558,     -9,    -90,   -252,    558,    558,    477,   -252,    396,  -3978,   1044, &
                   -90,   -900,    558,  -4626,    477,    396,    396,  -4626,   1044,  -1224,    396,   1044,    720,    -90, &
                    72,     -9,    558,    639,  -4464,    558,   2016,   -252,   1206,    396,    720,    -90,  -4464,    558, &
                  -171,    477,   1206,  -4545,  -3978,   1044,   1206,  -3978]
  K1( 609,:) = [   -576,     72,  -5760,    720,  -5112,  -4464,   4608,   -576, -36864,   4608,  -5760,   -576,   -576,     72, &
                  4608,   -576,    720,     72,  -4464,   2016,    720,     72,  -4464,    720,     72,     -9,    720,    -90, &
                   639,    558,    720,    -90,  -4464,    558,   -171,    477,  -4464,    558,   2016,   -252,   1206,    396, &
                 -4545,   1206,   1206,  -3978,  -3978,   1044,   -576,     72,   4608,   -576,    720,     72,     72,     -9, &
                   720,    -90,    639,    558,   -576,     72,     72,     -9,     -9,    -90,    -90,     -9,    558,   -252, &
                   -90,    558,     72,     -9,   -576,     72,    -90,     -9,  -5112,    639,  -4464,    558,  -4545,  -4626, &
                 -5760,    720,    720,    -90,    -90,   -900,   -171,    639,   1206,    396,    558,    477,    558,   -252, &
                   -90,     -9,    558,    -90,  -4626,    396,    396,   1044,   1044,  -1224,   -900,    -90,    477,    396, &
                   558,  -4626,    477,    558,  -3978,   1044,   -252,    396]
  K1( 610,:) = [     72,    720,    720,  -4464,  -4464,   2016,   -576,  -5760,   4608, -36864,   -576,   4608,     72,    720, &
                  -576,   4608,     72,   -576,  -5112,  -4464,     72,   -576,    720,  -5760,     -9,    -90,    -90,    558, &
                   558,   -252,    -90,   -900,    558,  -4626,    477,    396,    558,    477,   -252,    396,  -3978,   1044, &
                 -4626,    396,    396,   1044,   1044,  -1224,     72,    720,   -576,   4608,     72,   -576,     -9,    -90, &
                   -90,    558,    558,   -252,     72,   -576,     -9,    -90,     72,     -9,     -9,     72,    639,    558, &
                   720,    -90,     -9,    -90,     72,   -576,     -9,     72,    639,   -171,    558,    477,   1206,    396, &
                   720,  -5760,    -90,   -900,    720,    -90,    639,  -5112,  -4545,  -4626,  -4464,    558,    639,    558, &
                    -9,     72,    -90,    720,  -4545,   1206,   1206,  -3978,  -3978,   1044,    -90,    720,   -171,    477, &
                 -4464,    558,    558,  -4464,   1206,    396,   2016,   -252]
  K1( 611,:) = [     72,   -576,  -5112,  -4464,  -5760,    720,   -576,   4608,  -5760,   -576, -36864,   4608,  -4464,   2016, &
                   720,     72,  -4464,    720,   -576,     72,   4608,   -576,    720,     72,     -9,     72,    639,    558, &
                   720,    -90,    -90,    720,   -171,    477,  -4464,    558,  -4545,   1206,   1206,  -3978,  -3978,   1044, &
                 -4464,    558,   2016,   -252,   1206,    396,     72,   -576,    720,     72,   4608,   -576,     -9,     72, &
                   639,    558,    720,    -90,    -90,     -9,    558,   -252,    -90,    558,   -576,     72,     72,     -9, &
                    -9,    -90,    558,   -252,    -90,     -9,    558,    -90,  -4626,    396,    396,   1044,   1044,  -1224, &
                  -900,    -90,    477,    396,    558,  -4626,    477,    558,  -3978,   1044,   -252,    396,     72,     -9, &
                  -576,     72,    -90,     -9,  -5112,    639,  -4464,    558,  -4545,  -4626,  -5760,    720,    720,    -90, &
                   -90,   -900,   -171,    639,   1206,    396,    558,    477]
  K1( 612,:) = [    720,     72,  -4464,   2016,    720,  -4464,  -5760,   -576,   -576,   4608,   4608, -36864,  -5112,  -4464, &
                    72,   -576,    720,  -5760,     72,    720,   -576,   4608,     72,   -576,    -90,     -9,    558,   -252, &
                   -90,    558,   -900,    -90,    477,    396,    558,  -4626,  -4626,    396,    396,   1044,   1044,  -1224, &
                   558,    477,   -252,    396,  -3978,   1044,    720,     72,     72,   -576,   -576,   4608,    -90,     -9, &
                   558,   -252,    -90,    558,     -9,     72,    639,    558,    720,    -90,     72,   -576,     -9,    -90, &
                    72,     -9,    639,    558,     -9,     72,    -90,    720,  -4545,   1206,   1206,  -3978,  -3978,   1044, &
                   -90,    720,   -171,    477,  -4464,    558,    558,  -4464,   1206,    396,   2016,   -252,     -9,    -90, &
                    72,   -576,     -9,     72,    639,   -171,    558,    477,   1206,    396,    720,  -5760,    -90,   -900, &
                   720,    -90,    639,  -5112,  -4545,  -4626,  -4464,    558]
  K1( 613,:) = [   -576,     72,   4608,   -576,    720,     72,  -5760,    720,   -576,     72,  -4464,  -5112, -36864,   4608, &
                  4608,   -576,   -576,  -5760,  -4464,    720,   2016,  -4464,     72,    720,     72,     -9,   -576,     72, &
                   -90,     -9,  -5112,    639,  -4464,    558,  -4545,  -4626,  -5760,    720,    720,    -90,    -90,   -900, &
                  -171,    639,   1206,    396,    558,    477,    720,    -90,     72,     -9,    558,    639,  -4464,    558, &
                  2016,   -252,   1206,    396,    720,    -90,  -4464,    558,   -171,    477,   1206,  -4545,  -3978,   1044, &
                  1206,  -3978,   4608,   -576,   -576,     72,     72,    720,   -576,     72,     72,     -9,     -9,    -90, &
                    72,     -9,    720,    -90,    639,    558,     -9,    -90,    -90,    558,    558,   -252,    558,    -90, &
                  -252,    558,     -9,    -90,    477,    558,  -3978,   1044,   -252,    396,    396,  -4626,   1044,  -1224, &
                   396,   1044,    -90,   -900,    558,  -4626,    477,    396]
  K1( 614,:) = [     72,    720,   -576,   4608,     72,   -576,    720,  -4464,     72,    720,   2016,  -4464,   4608, -36864, &
                  -576,  -5760,   4608,   -576,    720,  -5760,  -4464,  -5112,   -576,     72,     -9,    -90,     72,   -576, &
                    -9,     72,    639,   -171,    558,    477,   1206,    396,    720,  -5760,    -90,   -900,    720,    -90, &
                   639,  -5112,  -4545,  -4626,  -4464,    558,    -90,    558,     -9,    -90,   -252,    558,    558,    477, &
                  -252,    396,  -3978,   1044,    -90,   -900,    558,  -4626,    477,    396,    396,  -4626,   1044,  -1224, &
                   396,   1044,   -576,   4608,     72,    720,   -576,     72,     72,   -576,     -9,    -90,     72,     -9, &
                    -9,    -90,    -90,    558,    558,   -252,     72,     -9,    720,    -90,    639,    558,    -90,    720, &
                   558,    639,     72,     -9,    558,  -4464,   1206,    396,   2016,   -252,   1206,  -4545,  -3978,   1044, &
                  1206,  -3978,    720,    -90,  -4464,    558,   -171,    477]
  K1( 615,:) = [  -5760,    720,   -576,     72,  -4464,  -5112,   -576,     72,   4608,   -576,    720,     72,   4608,   -576, &
                -36864,   4608,  -5760,   -576,   2016,  -4464,  -4464,    720,    720,     72,    720,    -90,     72,     -9, &
                   558,    639,  -4464,    558,   2016,   -252,   1206,    396,    720,    -90,  -4464,    558,   -171,    477, &
                  1206,  -4545,  -3978,   1044,   1206,  -3978,     72,     -9,   -576,     72,    -90,     -9,  -5112,    639, &
                 -4464,    558,  -4545,  -4626,  -5760,    720,    720,    -90,    -90,   -900,   -171,    639,   1206,    396, &
                   558,    477,   -576,     72,   4608,   -576,    720,     72,     72,     -9,    720,    -90,    639,    558, &
                  -576,     72,     72,     -9,     -9,    -90,    -90,     -9,    558,   -252,    -90,    558,   -252,    558, &
                   558,    -90,    -90,     -9,    396,  -4626,   1044,  -1224,    396,   1044,    477,    558,  -3978,   1044, &
                  -252,    396,   -900,    -90,    477,    396,    558,  -4626]
  K1( 616,:) = [    720,  -4464,     72,    720,   2016,  -4464,     72,    720,   -576,   4608,     72,   -576,   -576,  -5760, &
                  4608, -36864,   -576,   4608,  -4464,  -5112,    720,  -5760,     72,   -576,    -90,    558,     -9,    -90, &
                  -252,    558,    558,    477,   -252,    396,  -3978,   1044,    -90,   -900,    558,  -4626,    477,    396, &
                   396,  -4626,   1044,  -1224,    396,   1044,     -9,    -90,     72,   -576,     -9,     72,    639,   -171, &
                   558,    477,   1206,    396,    720,  -5760,    -90,   -900,    720,    -90,    639,  -5112,  -4545,  -4626, &
                 -4464,    558,     72,    720,   -576,   4608,     72,   -576,     -9,    -90,    -90,    558,    558,   -252, &
                    72,   -576,     -9,    -90,     72,     -9,     -9,     72,    639,    558,    720,    -90,    558,    639, &
                   -90,    720,     -9,     72,   1206,  -4545,  -3978,   1044,   1206,  -3978,    558,  -4464,   1206,    396, &
                  2016,   -252,    -90,    720,   -171,    477,  -4464,    558]
  K1( 617,:) = [  -5112,  -4464,     72,   -576,    720,  -5760,  -4464,   2016,    720,     72,  -4464,    720,   -576,   4608, &
                 -5760,   -576, -36864,   4608,     72,   -576,    720,     72,   4608,   -576,    639,    558,     -9,     72, &
                   -90,    720,  -4545,   1206,   1206,  -3978,  -3978,   1044,    -90,    720,   -171,    477,  -4464,    558, &
                   558,  -4464,   1206,    396,   2016,   -252,    558,   -252,    -90,     -9,    558,    -90,  -4626,    396, &
                   396,   1044,   1044,  -1224,   -900,    -90,    477,    396,    558,  -4626,    477,    558,  -3978,   1044, &
                  -252,    396,     72,   -576,    720,     72,   4608,   -576,     -9,     72,    639,    558,    720,    -90, &
                   -90,     -9,    558,   -252,    -90,    558,   -576,     72,     72,     -9,     -9,    -90,     -9,     72, &
                   -90,     -9,   -576,     72,    639,  -5112,  -4545,  -4626,  -4464,    558,   -171,    639,   1206,    396, &
                   558,    477,  -5760,    720,    720,    -90,    -90,   -900]
  K1( 618,:) = [  -4464,   2016,    720,     72,  -4464,    720,  -5112,  -4464,     72,   -576,    720,  -5760,  -5760,   -576, &
                  -576,   4608,   4608, -36864,    720,     72,     72,   -576,   -576,   4608,    558,   -252,    -90,     -9, &
                   558,    -90,  -4626,    396,    396,   1044,   1044,  -1224,   -900,    -90,    477,    396,    558,  -4626, &
                   477,    558,  -3978,   1044,   -252,    396,    639,    558,     -9,     72,    -90,    720,  -4545,   1206, &
                  1206,  -3978,  -3978,   1044,    -90,    720,   -171,    477,  -4464,    558,    558,  -4464,   1206,    396, &
                  2016,   -252,    720,     72,     72,   -576,   -576,   4608,    -90,     -9,    558,   -252,    -90,    558, &
                    -9,     72,    639,    558,    720,    -90,     72,   -576,     -9,    -90,     72,     -9,    -90,     -9, &
                    -9,     72,     72,   -576,   -171,    639,   1206,    396,    558,    477,    639,  -5112,  -4545,  -4626, &
                 -4464,    558,    720,  -5760,    -90,   -900,    720,    -90]
  K1( 619,:) = [     72,   -576,    720,     72,   4608,   -576,    720,  -5760,  -4464,  -5112,   -576,     72,  -4464,    720, &
                  2016,  -4464,     72,    720, -36864,   4608,   4608,   -576,   -576,  -5760,     -9,     72,    -90,     -9, &
                  -576,     72,    639,  -5112,  -4545,  -4626,  -4464,    558,   -171,    639,   1206,    396,    558,    477, &
                 -5760,    720,    720,    -90,    -90,   -900,    -90,    720,    558,    639,     72,     -9,    558,  -4464, &
                  1206,    396,   2016,   -252,   1206,  -4545,  -3978,   1044,   1206,  -3978,    720,    -90,  -4464,    558, &
                  -171,    477,    558,    -90,   -252,    558,     -9,    -90,    477,    558,  -3978,   1044,   -252,    396, &
                   396,  -4626,   1044,  -1224,    396,   1044,    -90,   -900,    558,  -4626,    477,    396,   4608,   -576, &
                  -576,     72,     72,    720,   -576,     72,     72,     -9,     -9,    -90,     72,     -9,    720,    -90, &
                   639,    558,     -9,    -90,    -90,    558,    558,   -252]
  K1( 620,:) = [    720,     72,     72,   -576,   -576,   4608,  -4464,    720,   2016,  -4464,     72,    720,    720,  -5760, &
                 -4464,  -5112,   -576,     72,   4608, -36864,   -576,  -5760,   4608,   -576,    -90,     -9,     -9,     72, &
                    72,   -576,   -171,    639,   1206,    396,    558,    477,    639,  -5112,  -4545,  -4626,  -4464,    558, &
                   720,  -5760,    -90,   -900,    720,    -90,    558,    -90,   -252,    558,     -9,    -90,    477,    558, &
                 -3978,   1044,   -252,    396,    396,  -4626,   1044,  -1224,    396,   1044,    -90,   -900,    558,  -4626, &
                   477,    396,    -90,    720,    558,    639,     72,     -9,    558,  -4464,   1206,    396,   2016,   -252, &
                  1206,  -4545,  -3978,   1044,   1206,  -3978,    720,    -90,  -4464,    558,   -171,    477,   -576,   4608, &
                    72,    720,   -576,     72,     72,   -576,     -9,    -90,     72,     -9,     -9,    -90,    -90,    558, &
                   558,   -252,     72,     -9,    720,    -90,    639,    558]
  K1( 621,:) = [    720,  -5760,  -4464,  -5112,   -576,     72,     72,   -576,    720,     72,   4608,   -576,   2016,  -4464, &
                 -4464,    720,    720,     72,   4608,   -576, -36864,   4608,  -5760,   -576,    -90,    720,    558,    639, &
                    72,     -9,    558,  -4464,   1206,    396,   2016,   -252,   1206,  -4545,  -3978,   1044,   1206,  -3978, &
                   720,    -90,  -4464,    558,   -171,    477,     -9,     72,    -90,     -9,   -576,     72,    639,  -5112, &
                 -4545,  -4626,  -4464,    558,   -171,    639,   1206,    396,    558,    477,  -5760,    720,    720,    -90, &
                   -90,   -900,   -252,    558,    558,    -90,    -90,     -9,    396,  -4626,   1044,  -1224,    396,   1044, &
                   477,    558,  -3978,   1044,   -252,    396,   -900,    -90,    477,    396,    558,  -4626,   -576,     72, &
                  4608,   -576,    720,     72,     72,     -9,    720,    -90,    639,    558,   -576,     72,     72,     -9, &
                    -9,    -90,    -90,     -9,    558,   -252,    -90,    558]
  K1( 622,:) = [  -4464,    720,   2016,  -4464,     72,    720,    720,     72,     72,   -576,   -576,   4608,  -4464,  -5112, &
                   720,  -5760,     72,   -576,   -576,  -5760,   4608, -36864,   -576,   4608,    558,    -90,   -252,    558, &
                    -9,    -90,    477,    558,  -3978,   1044,   -252,    396,    396,  -4626,   1044,  -1224,    396,   1044, &
                   -90,   -900,    558,  -4626,    477,    396,    -90,     -9,     -9,     72,     72,   -576,   -171,    639, &
                  1206,    396,    558,    477,    639,  -5112,  -4545,  -4626,  -4464,    558,    720,  -5760,    -90,   -900, &
                   720,    -90,    558,    639,    -90,    720,     -9,     72,   1206,  -4545,  -3978,   1044,   1206,  -3978, &
                   558,  -4464,   1206,    396,   2016,   -252,    -90,    720,   -171,    477,  -4464,    558,     72,    720, &
                  -576,   4608,     72,   -576,     -9,    -90,    -90,    558,    558,   -252,     72,   -576,     -9,    -90, &
                    72,     -9,     -9,     72,    639,    558,    720,    -90]
  K1( 623,:) = [  -4464,  -5112,    720,  -5760,     72,   -576,   2016,  -4464,  -4464,    720,    720,     72,     72,   -576, &
                   720,     72,   4608,   -576,   -576,   4608,  -5760,   -576, -36864,   4608,    558,    639,    -90,    720, &
                    -9,     72,   1206,  -4545,  -3978,   1044,   1206,  -3978,    558,  -4464,   1206,    396,   2016,   -252, &
                   -90,    720,   -171,    477,  -4464,    558,   -252,    558,    558,    -90,    -90,     -9,    396,  -4626, &
                  1044,  -1224,    396,   1044,    477,    558,  -3978,   1044,   -252,    396,   -900,    -90,    477,    396, &
                   558,  -4626,     -9,     72,    -90,     -9,   -576,     72,    639,  -5112,  -4545,  -4626,  -4464,    558, &
                  -171,    639,   1206,    396,    558,    477,  -5760,    720,    720,    -90,    -90,   -900,     72,   -576, &
                   720,     72,   4608,   -576,     -9,     72,    639,    558,    720,    -90,    -90,     -9,    558,   -252, &
                   -90,    558,   -576,     72,     72,     -9,     -9,    -90]
  K1( 624,:) = [   2016,  -4464,  -4464,    720,    720,     72,  -4464,  -5112,    720,  -5760,     72,   -576,    720,     72, &
                    72,   -576,   -576,   4608,  -5760,   -576,   -576,   4608,   4608, -36864,   -252,    558,    558,    -90, &
                   -90,     -9,    396,  -4626,   1044,  -1224,    396,   1044,    477,    558,  -3978,   1044,   -252,    396, &
                  -900,    -90,    477,    396,    558,  -4626,    558,    639,    -90,    720,     -9,     72,   1206,  -4545, &
                 -3978,   1044,   1206,  -3978,    558,  -4464,   1206,    396,   2016,   -252,    -90,    720,   -171,    477, &
                 -4464,    558,    -90,     -9,     -9,     72,     72,   -576,   -171,    639,   1206,    396,    558,    477, &
                   639,  -5112,  -4545,  -4626,  -4464,    558,    720,  -5760,    -90,   -900,    720,    -90,    720,     72, &
                    72,   -576,   -576,   4608,    -90,     -9,    558,   -252,    -90,    558,     -9,     72,    639,    558, &
                   720,    -90,     72,   -576,     -9,    -90,     72,     -9]
  K1( 625,:) = [   4608,   -576,   -576,     72,     72,    720,   -576,     72,     72,     -9,     -9,    -90,     72,     -9, &
                   720,    -90,    639,    558,     -9,    -90,    -90,    558,    558,   -252,   4608,   -576,   -576,     72, &
                    72,    720,   -576,     72,     72,     -9,     -9,    -90,     72,     -9,    720,    -90,    639,    558, &
                    -9,    -90,    -90,    558,    558,   -252,   4608,   -576,   -576,     72,     72,    720,   4608,   -576, &
                  -576,     72,     72,    720,   4608,   -576,   4608,   -576,   4608,   4608,   -576,     72,   -576,     72, &
                  -576,   -576,   -576,     72,     72,     -9,     -9,    -90,   -576,     72,     72,     -9,     -9,    -90, &
                  -576,     72,   -576,     72,   -576,   -576,     72,     -9,     72,     -9,     72,     72,     72,    720, &
                    -9,    639,    -90,    558,     72,    720,     -9,    639,    -90,    558,     72,     -9,     72,     -9, &
                    72,     72,    720,    -90,    720,    -90,    720,    720]
  K1( 626,:) = [   -576,   4608,     72,    720,   -576,     72,     72,   -576,     -9,    -90,     72,     -9,     -9,    -90, &
                   -90,    558,    558,   -252,     72,     -9,    720,    -90,    639,    558,   -576,   4608,     72,    720, &
                  -576,     72,     72,   -576,     -9,    -90,     72,     -9,     -9,    -90,    -90,    558,    558,   -252, &
                    72,     -9,    720,    -90,    639,    558,   -576,   4608,     72,    720,   -576,     72,   -576,   4608, &
                    72,    720,   -576,     72,   -576,     72,   -576,     72,   -576,   -576,   4608,   -576,   4608,   -576, &
                  4608,   4608,     72,    720,     -9,    639,    -90,    558,     72,    720,     -9,    639,    -90,    558, &
                    72,     -9,     72,     -9,     72,     72,    720,    -90,    720,    -90,    720,    720,   -576,     72, &
                    72,     -9,     -9,    -90,   -576,     72,     72,     -9,     -9,    -90,   -576,     72,   -576,     72, &
                  -576,   -576,     72,     -9,     72,     -9,     72,     72]
  K1( 627,:) = [   -576,     72,   4608,   -576,    720,     72,     72,     -9,    720,    -90,    639,    558,   -576,     72, &
                    72,     -9,     -9,    -90,    -90,     -9,    558,   -252,    -90,    558,   -576,     72,   4608,   -576, &
                   720,     72,     72,     -9,    720,    -90,    639,    558,   -576,     72,     72,     -9,     -9,    -90, &
                   -90,     -9,    558,   -252,    -90,    558,   -576,     72,     72,     -9,     -9,    -90,   -576,     72, &
                    72,     -9,     -9,    -90,   -576,     72,   -576,     72,   -576,   -576,     72,     -9,     72,     -9, &
                    72,     72,   4608,   -576,   -576,     72,     72,    720,   4608,   -576,   -576,     72,     72,    720, &
                  4608,   -576,   4608,   -576,   4608,   4608,   -576,     72,   -576,     72,   -576,   -576,    720,     72, &
                   -90,    558,     -9,    639,    720,     72,    -90,    558,     -9,    639,    720,    -90,    720,    -90, &
                   720,    720,     72,     -9,     72,     -9,     72,     72]
  K1( 628,:) = [     72,    720,   -576,   4608,     72,   -576,     -9,    -90,    -90,    558,    558,   -252,     72,   -576, &
                    -9,    -90,     72,     -9,     -9,     72,    639,    558,    720,    -90,     72,    720,   -576,   4608, &
                    72,   -576,     -9,    -90,    -90,    558,    558,   -252,     72,   -576,     -9,    -90,     72,     -9, &
                    -9,     72,    639,    558,    720,    -90,     72,    720,     -9,    639,    -90,    558,     72,    720, &
                    -9,    639,    -90,    558,     72,     -9,     72,     -9,     72,     72,    720,    -90,    720,    -90, &
                   720,    720,   -576,   4608,     72,    720,   -576,     72,   -576,   4608,     72,    720,   -576,     72, &
                  -576,     72,   -576,     72,   -576,   -576,   4608,   -576,   4608,   -576,   4608,   4608,     72,   -576, &
                    -9,    -90,     72,     -9,     72,   -576,     -9,    -90,     72,     -9,     72,     -9,     72,     -9, &
                    72,     72,   -576,     72,   -576,     72,   -576,   -576]
  K1( 629,:) = [     72,   -576,    720,     72,   4608,   -576,     -9,     72,    639,    558,    720,    -90,    -90,     -9, &
                   558,   -252,    -90,    558,   -576,     72,     72,     -9,     -9,    -90,     72,   -576,    720,     72, &
                  4608,   -576,     -9,     72,    639,    558,    720,    -90,    -90,     -9,    558,   -252,    -90,    558, &
                  -576,     72,     72,     -9,     -9,    -90,     72,   -576,     -9,    -90,     72,     -9,     72,   -576, &
                    -9,    -90,     72,     -9,     72,     -9,     72,     -9,     72,     72,   -576,     72,   -576,     72, &
                  -576,   -576,    720,     72,    -90,    558,     -9,    639,    720,     72,    -90,    558,     -9,    639, &
                   720,    -90,    720,    -90,    720,    720,     72,     -9,     72,     -9,     72,     72,   4608,   -576, &
                  -576,     72,     72,    720,   4608,   -576,   -576,     72,     72,    720,   4608,   -576,   4608,   -576, &
                  4608,   4608,   -576,     72,   -576,     72,   -576,   -576]
  K1( 630,:) = [    720,     72,     72,   -576,   -576,   4608,    -90,     -9,    558,   -252,    -90,    558,     -9,     72, &
                   639,    558,    720,    -90,     72,   -576,     -9,    -90,     72,     -9,    720,     72,     72,   -576, &
                  -576,   4608,    -90,     -9,    558,   -252,    -90,    558,     -9,     72,    639,    558,    720,    -90, &
                    72,   -576,     -9,    -90,     72,     -9,    720,     72,    -90,    558,     -9,    639,    720,     72, &
                   -90,    558,     -9,    639,    720,    -90,    720,    -90,    720,    720,     72,     -9,     72,     -9, &
                    72,     72,     72,   -576,     -9,    -90,     72,     -9,     72,   -576,     -9,    -90,     72,     -9, &
                    72,     -9,     72,     -9,     72,     72,   -576,     72,   -576,     72,   -576,   -576,   -576,   4608, &
                    72,    720,   -576,     72,   -576,   4608,     72,    720,   -576,     72,   -576,     72,   -576,     72, &
                  -576,   -576,   4608,   -576,   4608,   -576,   4608,   4608]
  K1( 631,:) = [   -576,     72,     72,     -9,     -9,    -90,  -5760,    720,    720,    -90,    -90,   -900,  -5112,    639, &
                 -4464,    558,  -4545,  -4626,    639,   -171,    558,    477,   1206,    396,   -576,     72,     72,     -9, &
                    -9,    -90,   -576,     72,     72,     -9,     -9,    -90,   -576,     72,   -576,     72,   -576,   -576, &
                    72,     -9,     72,     -9,     72,     72,   4608,   -576,   -576,     72,     72,    720,  -5760,    720, &
                   720,    -90,    -90,   -900,  -1224,    153,     72,     -9,   -495,   -657,    153,   -657,     -9,    639, &
                   882,   -738,   4608,   -576,   -576,     72,     72,    720,  -1224,    153,   4608,   -576,    234,   -495, &
                  3960,   -495,   -576,     72,   -414,    153,   3960,  -1224,  -1143,   3960,   4041,  -1224,   -576,     72, &
                    72,     -9,     -9,    -90,    153,   -657,   -576,   -657,   -576,    153,   -495,   -576,     72,   -738, &
                  -495,     72,  -1224,   -576,    234,  -1224,   -414,   -576]
  K1( 632,:) = [     72,   -576,     -9,    -90,     72,     -9,    720,  -5760,    -90,   -900,    720,    -90,    639,   -171, &
                   558,    477,   1206,    396,  -5112,    639,  -4464,    558,  -4545,  -4626,     72,   -576,     -9,    -90, &
                    72,     -9,     72,   -576,     -9,    -90,     72,     -9,     72,     -9,     72,     -9,     72,     72, &
                  -576,     72,   -576,     72,   -576,   -576,   -576,   4608,     72,    720,   -576,     72,    720,  -5760, &
                   -90,   -900,    720,    -90,    153,   -657,     -9,    639,    882,   -738,  -1224,    153,     72,     -9, &
                  -495,   -657,   -576,     72,     72,     -9,     -9,    -90,    153,   -657,   -576,   -657,   -576,    153, &
                  -495,   -576,     72,   -738,   -495,     72,  -1224,   -576,    234,  -1224,   -414,   -576,   4608,   -576, &
                  -576,     72,     72,    720,  -1224,    153,   4608,   -576,    234,   -495,   3960,   -495,   -576,     72, &
                  -414,    153,   3960,  -1224,  -1143,   3960,   4041,  -1224]
  K1( 633,:) = [     72,     -9,    720,    -90,    639,    558,    720,    -90,  -4464,    558,   -171,    477,  -4464,    558, &
                  2016,   -252,   1206,    396,  -4545,   1206,   1206,  -3978,  -3978,   1044,     72,     -9,    720,    -90, &
                   639,    558,     72,     -9,     72,     -9,     72,     72,   -576,     72,    720,    -90,    153,     -9, &
                  -576,     72,    153,   -576,   -495,     72,   -576,     72,     72,     -9,     -9,    -90,    720,    -90, &
                   720,    -90,    720,    720,   4608,   -576,  -4464,    558,   -495,    639,    234,   -576,   -657,     72, &
                  -414,     -9,   4608,   -576,   -576,     72,     72,    720,     72,     -9,  -4464,    558,   -657,    -90, &
                  -576,     72,   2016,   -252,    882,    558,  -1143,    234,    153,     -9,   -495,    -90,   4608,   -576, &
                  -576,     72,     72,    720,   -495,    882,   -495,   4608,   -414,   -576,   -414,   -495,    882,   -576, &
                  4041,     72,   4041,   -414,   -495,     72,   -414,    720]
  K1( 634,:) = [     -9,    -90,    -90,    558,    558,   -252,    -90,   -900,    558,  -4626,    477,    396,    558,    477, &
                  -252,    396,  -3978,   1044,  -4626,    396,    396,   1044,   1044,  -1224,     -9,    -90,    -90,    558, &
                   558,   -252,     -9,    -90,     -9,     -9,     72,    -90,     72,     -9,    -90,    -90,   -576,    558, &
                  -576,     72,     -9,    558,     72,   -252,     72,    720,     -9,    639,    -90,    558,    -90,   -900, &
                   -90,    -90,    720,   -900,   -576,   -657,    558,    558,   4608,  -4626,   -495,    153,    -90,    477, &
                  -576,    396,   -576,     72,     72,     -9,     -9,    -90,     -9,    639,    558,    558,     72,    477, &
                    72,   -738,   -252,   -252,   -576,    396,   3960,  -1224,     -9,  -3978,     72,   1044,   4608,   -576, &
                  -576,     72,     72,    720,   -657,   -738,    639,  -4626,     -9,    396,    153,     72,    558,    396, &
                    72,   1044,  -1224,   -576,    -90,   1044,    720,  -1224]
  K1( 635,:) = [     -9,     72,    639,    558,    720,    -90,    -90,    720,   -171,    477,  -4464,    558,  -4545,   1206, &
                  1206,  -3978,  -3978,   1044,  -4464,    558,   2016,   -252,   1206,    396,     -9,     72,    639,    558, &
                   720,    -90,     -9,     72,     72,     72,     72,     -9,   -576,     72,    153,   -576,   -495,     72, &
                  -576,     72,    720,    -90,    153,     -9,     72,   -576,     -9,    -90,     72,     -9,    -90,    720, &
                   720,    720,    720,    -90,    234,   -576,   -657,     72,   -414,     -9,   4608,   -576,  -4464,    558, &
                  -495,    639,   4608,   -576,   -576,     72,     72,    720,   -495,    882,   -495,   4608,   -414,   -576, &
                  -414,   -495,    882,   -576,   4041,     72,   4041,   -414,   -495,     72,   -414,    720,   4608,   -576, &
                  -576,     72,     72,    720,     72,     -9,  -4464,    558,   -657,    -90,   -576,     72,   2016,   -252, &
                   882,    558,  -1143,    234,    153,     -9,   -495,    -90]
  K1( 636,:) = [    -90,     -9,    558,   -252,    -90,    558,   -900,    -90,    477,    396,    558,  -4626,  -4626,    396, &
                   396,   1044,   1044,  -1224,    558,    477,   -252,    396,  -3978,   1044,    -90,     -9,    558,   -252, &
                   -90,    558,    -90,     -9,     72,    -90,     -9,     -9,   -576,     72,     -9,    558,     72,   -252, &
                    72,     -9,    -90,    -90,   -576,    558,    720,     72,    -90,    558,     -9,    639,   -900,    -90, &
                   720,   -900,    -90,    -90,   -495,    153,    -90,    477,   -576,    396,   -576,   -657,    558,    558, &
                  4608,  -4626,   4608,   -576,   -576,     72,     72,    720,   -657,   -738,    639,  -4626,     -9,    396, &
                   153,     72,    558,    396,     72,   1044,  -1224,   -576,    -90,   1044,    720,  -1224,   -576,     72, &
                    72,     -9,     -9,    -90,     -9,    639,    558,    558,     72,    477,     72,   -738,   -252,   -252, &
                  -576,    396,   3960,  -1224,     -9,  -3978,     72,   1044]
  K1( 637,:) = [     72,     -9,   -576,     72,    -90,     -9,  -5112,    639,  -4464,    558,  -4545,  -4626,  -5760,    720, &
                   720,    -90,    -90,   -900,   -171,    639,   1206,    396,    558,    477,     72,     -9,   -576,     72, &
                   -90,     -9,   -576,     72,   -576,     72,   -576,   -576,   -576,     72,     72,     -9,     -9,    -90, &
                    -9,     72,     72,     72,     72,     -9,   4608,   -576,   -576,     72,     72,    720,  -1224,    153, &
                  4608,   -576,    234,   -495,   3960,   -495,   -576,     72,   -414,    153,   3960,  -1224,  -1143,   3960, &
                  4041,  -1224,   4608,   -576,   -576,     72,     72,    720,  -5760,    720,    720,    -90,    -90,   -900, &
                 -1224,    153,     72,     -9,   -495,   -657,    153,   -657,     -9,    639,    882,   -738,     72,   -576, &
                    -9,    -90,     72,     -9,   -657,    153,   -576,    153,   -576,   -657,  -1224,   -576,    234,  -1224, &
                  -414,   -576,   -495,   -576,     72,   -738,   -495,     72]
  K1( 638,:) = [     -9,    -90,     72,   -576,     -9,     72,    639,   -171,    558,    477,   1206,    396,    720,  -5760, &
                   -90,   -900,    720,    -90,    639,  -5112,  -4545,  -4626,  -4464,    558,     -9,    -90,     72,   -576, &
                    -9,     72,     72,     -9,     72,     -9,     72,     72,     72,   -576,     -9,    -90,     72,     -9, &
                    72,   -576,   -576,   -576,   -576,     72,   -576,     72,     72,     -9,     -9,    -90,    153,   -657, &
                  -576,   -657,   -576,    153,   -495,   -576,     72,   -738,   -495,     72,  -1224,   -576,    234,  -1224, &
                  -414,   -576,   -576,   4608,     72,    720,   -576,     72,    720,  -5760,    -90,   -900,    720,    -90, &
                   153,   -657,     -9,    639,    882,   -738,  -1224,    153,     72,     -9,   -495,   -657,   -576,   4608, &
                    72,    720,   -576,     72,    153,  -1224,    234,   -495,   4608,   -576,   3960,  -1224,  -1143,   3960, &
                  4041,  -1224,   3960,   -495,   -576,     72,   -414,    153]
  K1( 639,:) = [    720,    -90,     72,     -9,    558,    639,  -4464,    558,   2016,   -252,   1206,    396,    720,    -90, &
                 -4464,    558,   -171,    477,   1206,  -4545,  -3978,   1044,   1206,  -3978,    720,    -90,     72,     -9, &
                   558,    639,   -576,     72,    720,    -90,    153,     -9,     72,     -9,     72,     -9,     72,     72, &
                    72,   -576,   -495,     72,    153,   -576,   4608,   -576,   -576,     72,     72,    720,     72,     -9, &
                 -4464,    558,   -657,    -90,   -576,     72,   2016,   -252,    882,    558,  -1143,    234,    153,     -9, &
                  -495,    -90,   -576,     72,     72,     -9,     -9,    -90,    720,    -90,    720,    -90,    720,    720, &
                  4608,   -576,  -4464,    558,   -495,    639,    234,   -576,   -657,     72,   -414,     -9,   -576,   4608, &
                    72,    720,   -576,     72,    882,   -495,   -414,   -576,   -495,   4608,   4041,   -414,   -495,     72, &
                  -414,    720,   -414,   -495,    882,   -576,   4041,     72]
  K1( 640,:) = [    -90,    558,     -9,    -90,   -252,    558,    558,    477,   -252,    396,  -3978,   1044,    -90,   -900, &
                   558,  -4626,    477,    396,    396,  -4626,   1044,  -1224,    396,   1044,    -90,    558,     -9,    -90, &
                  -252,    558,     72,     -9,    -90,    -90,   -576,    558,     -9,    -90,     -9,     -9,     72,    -90, &
                    72,   -576,     72,   -252,     -9,    558,   -576,     72,     72,     -9,     -9,    -90,     -9,    639, &
                   558,    558,     72,    477,     72,   -738,   -252,   -252,   -576,    396,   3960,  -1224,     -9,  -3978, &
                    72,   1044,     72,    720,     -9,    639,    -90,    558,    -90,   -900,    -90,    -90,    720,   -900, &
                  -576,   -657,    558,    558,   4608,  -4626,   -495,    153,    -90,    477,   -576,    396,   -576,   4608, &
                    72,    720,   -576,     72,   -738,   -657,     -9,    396,    639,  -4626,  -1224,   -576,    -90,   1044, &
                   720,  -1224,    153,     72,    558,    396,     72,   1044]
  K1( 641,:) = [    639,    558,     -9,     72,    -90,    720,  -4545,   1206,   1206,  -3978,  -3978,   1044,    -90,    720, &
                  -171,    477,  -4464,    558,    558,  -4464,   1206,    396,   2016,   -252,    639,    558,     -9,     72, &
                   -90,    720,   -576,     72,    153,   -576,   -495,     72,     -9,     72,     72,     72,     72,     -9, &
                    72,   -576,    153,     -9,    720,    -90,   4608,   -576,   -576,     72,     72,    720,   -495,    882, &
                  -495,   4608,   -414,   -576,   -414,   -495,    882,   -576,   4041,     72,   4041,   -414,   -495,     72, &
                  -414,    720,     72,   -576,     -9,    -90,     72,     -9,    -90,    720,    720,    720,    720,    -90, &
                   234,   -576,   -657,     72,   -414,     -9,   4608,   -576,  -4464,    558,   -495,    639,   -576,   4608, &
                    72,    720,   -576,     72,     -9,     72,   -657,    -90,  -4464,    558,  -1143,    234,    153,     -9, &
                  -495,    -90,   -576,     72,   2016,   -252,    882,    558]
  K1( 642,:) = [    558,   -252,    -90,     -9,    558,    -90,  -4626,    396,    396,   1044,   1044,  -1224,   -900,    -90, &
                   477,    396,    558,  -4626,    477,    558,  -3978,   1044,   -252,    396,    558,   -252,    -90,     -9, &
                   558,    -90,   -576,     72,     -9,    558,     72,   -252,    -90,     -9,     72,    -90,     -9,     -9, &
                    -9,     72,   -576,    558,    -90,    -90,   4608,   -576,   -576,     72,     72,    720,   -657,   -738, &
                   639,  -4626,     -9,    396,    153,     72,    558,    396,     72,   1044,  -1224,   -576,    -90,   1044, &
                   720,  -1224,    720,     72,    -90,    558,     -9,    639,   -900,    -90,    720,   -900,    -90,    -90, &
                  -495,    153,    -90,    477,   -576,    396,   -576,   -657,    558,    558,   4608,  -4626,     72,   -576, &
                    -9,    -90,     72,     -9,    639,     -9,     72,    477,    558,    558,   3960,  -1224,     -9,  -3978, &
                    72,   1044,     72,   -738,   -252,   -252,   -576,    396]
  K1( 643,:) = [     -9,     72,    -90,     -9,   -576,     72,    639,  -5112,  -4545,  -4626,  -4464,    558,   -171,    639, &
                  1206,    396,    558,    477,  -5760,    720,    720,    -90,    -90,   -900,     -9,     72,    -90,     -9, &
                  -576,     72,     72,   -576,   -576,   -576,   -576,     72,     -9,     72,     72,     72,     72,     -9, &
                  -576,     72,     72,     -9,     -9,    -90,   -576,   4608,     72,    720,   -576,     72,    153,  -1224, &
                   234,   -495,   4608,   -576,   3960,  -1224,  -1143,   3960,   4041,  -1224,   3960,   -495,   -576,     72, &
                  -414,    153,     72,   -576,     -9,    -90,     72,     -9,   -657,    153,   -576,    153,   -576,   -657, &
                 -1224,   -576,    234,  -1224,   -414,   -576,   -495,   -576,     72,   -738,   -495,     72,   4608,   -576, &
                  -576,     72,     72,    720,  -5760,    720,    720,    -90,    -90,   -900,  -1224,    153,     72,     -9, &
                  -495,   -657,    153,   -657,     -9,    639,    882,   -738]
  K1( 644,:) = [    -90,     -9,     -9,     72,     72,   -576,   -171,    639,   1206,    396,    558,    477,    639,  -5112, &
                 -4545,  -4626,  -4464,    558,    720,  -5760,    -90,   -900,    720,    -90,    -90,     -9,     -9,     72, &
                    72,   -576,     -9,     72,     72,     72,     72,     -9,     72,   -576,   -576,   -576,   -576,     72, &
                    72,   -576,     -9,    -90,     72,     -9,     72,   -576,     -9,    -90,     72,     -9,   -657,    153, &
                  -576,    153,   -576,   -657,  -1224,   -576,    234,  -1224,   -414,   -576,   -495,   -576,     72,   -738, &
                  -495,     72,   -576,   4608,     72,    720,   -576,     72,    153,  -1224,    234,   -495,   4608,   -576, &
                  3960,  -1224,  -1143,   3960,   4041,  -1224,   3960,   -495,   -576,     72,   -414,    153,   -576,   4608, &
                    72,    720,   -576,     72,    720,  -5760,    -90,   -900,    720,    -90,    153,   -657,     -9,    639, &
                   882,   -738,  -1224,    153,     72,     -9,   -495,   -657]
  K1( 645,:) = [    -90,    720,    558,    639,     72,     -9,    558,  -4464,   1206,    396,   2016,   -252,   1206,  -4545, &
                 -3978,   1044,   1206,  -3978,    720,    -90,  -4464,    558,   -171,    477,    -90,    720,    558,    639, &
                    72,     -9,     72,   -576,    153,     -9,    720,    -90,     72,   -576,   -495,     72,    153,   -576, &
                    72,     -9,     72,     -9,     72,     72,   -576,   4608,     72,    720,   -576,     72,     -9,     72, &
                  -657,    -90,  -4464,    558,  -1143,    234,    153,     -9,   -495,    -90,   -576,     72,   2016,   -252, &
                   882,    558,   -576,   4608,     72,    720,   -576,     72,    882,   -495,   -414,   -576,   -495,   4608, &
                  4041,   -414,   -495,     72,   -414,    720,   -414,   -495,    882,   -576,   4041,     72,   -576,     72, &
                    72,     -9,     -9,    -90,    720,    -90,    720,    -90,    720,    720,   4608,   -576,  -4464,    558, &
                  -495,    639,    234,   -576,   -657,     72,   -414,     -9]
  K1( 646,:) = [    558,    -90,   -252,    558,     -9,    -90,    477,    558,  -3978,   1044,   -252,    396,    396,  -4626, &
                  1044,  -1224,    396,   1044,    -90,   -900,    558,  -4626,    477,    396,    558,    -90,   -252,    558, &
                    -9,    -90,     -9,     72,   -576,    558,    -90,    -90,     72,   -576,     72,   -252,     -9,    558, &
                    -9,    -90,     -9,     -9,     72,    -90,     72,   -576,     -9,    -90,     72,     -9,    639,     -9, &
                    72,    477,    558,    558,   3960,  -1224,     -9,  -3978,     72,   1044,     72,   -738,   -252,   -252, &
                  -576,    396,   -576,   4608,     72,    720,   -576,     72,   -738,   -657,     -9,    396,    639,  -4626, &
                 -1224,   -576,    -90,   1044,    720,  -1224,    153,     72,    558,    396,     72,   1044,     72,    720, &
                    -9,    639,    -90,    558,    -90,   -900,    -90,    -90,    720,   -900,   -576,   -657,    558,    558, &
                  4608,  -4626,   -495,    153,    -90,    477,   -576,    396]
  K1( 647,:) = [    558,    639,    -90,    720,     -9,     72,   1206,  -4545,  -3978,   1044,   1206,  -3978,    558,  -4464, &
                  1206,    396,   2016,   -252,    -90,    720,   -171,    477,  -4464,    558,    558,    639,    -90,    720, &
                    -9,     72,     72,   -576,   -495,     72,    153,   -576,     72,   -576,    153,     -9,    720,    -90, &
                    -9,     72,     72,     72,     72,     -9,   -576,   4608,     72,    720,   -576,     72,    882,   -495, &
                  -414,   -576,   -495,   4608,   4041,   -414,   -495,     72,   -414,    720,   -414,   -495,    882,   -576, &
                  4041,     72,   -576,   4608,     72,    720,   -576,     72,     -9,     72,   -657,    -90,  -4464,    558, &
                 -1143,    234,    153,     -9,   -495,    -90,   -576,     72,   2016,   -252,    882,    558,     72,   -576, &
                    -9,    -90,     72,     -9,    -90,    720,    720,    720,    720,    -90,    234,   -576,   -657,     72, &
                  -414,     -9,   4608,   -576,  -4464,    558,   -495,    639]
  K1( 648,:) = [   -252,    558,    558,    -90,    -90,     -9,    396,  -4626,   1044,  -1224,    396,   1044,    477,    558, &
                 -3978,   1044,   -252,    396,   -900,    -90,    477,    396,    558,  -4626,   -252,    558,    558,    -90, &
                   -90,     -9,     72,   -576,     72,   -252,     -9,    558,     -9,     72,   -576,    558,    -90,    -90, &
                   -90,     -9,     72,    -90,     -9,     -9,   -576,   4608,     72,    720,   -576,     72,   -738,   -657, &
                    -9,    396,    639,  -4626,  -1224,   -576,    -90,   1044,    720,  -1224,    153,     72,    558,    396, &
                    72,   1044,     72,   -576,     -9,    -90,     72,     -9,    639,     -9,     72,    477,    558,    558, &
                  3960,  -1224,     -9,  -3978,     72,   1044,     72,   -738,   -252,   -252,   -576,    396,    720,     72, &
                   -90,    558,     -9,    639,   -900,    -90,    720,   -900,    -90,    -90,   -495,    153,    -90,    477, &
                  -576,    396,   -576,   -657,    558,    558,   4608,  -4626]
  K1( 649,:) = [   -576,     72,     72,     -9,     -9,    -90,   4608,   -576,   -576,     72,     72,    720,    720,    -90, &
                    72,     -9,    558,    639,    -90,    558,     -9,    -90,   -252,    558,   4608,   -576,   -576,     72, &
                    72,    720,   4608,   -576,   -576,     72,     72,    720,   4608,   -576,   4608,   -576,   4608,   4608, &
                  -576,     72,   -576,     72,   -576,   -576,   4608,   -576,   -576,     72,     72,    720,   -576,     72, &
                    72,     -9,     -9,    -90,     72,     -9,    720,    -90,    639,    558,     -9,    -90,    -90,    558, &
                   558,   -252,     72,     -9,   -576,     72,    -90,     -9,   -576,     72,   -576,     72,   -576,   -576, &
                  -576,     72,     72,     -9,     -9,    -90,     -9,     72,     72,     72,     72,     -9,     -9,    639, &
                    72,    720,    558,    -90,     72,     -9,     72,     -9,     72,     72,     72,    720,     -9,    639, &
                   -90,    558,    -90,    720,    720,    720,    720,    -90]
  K1( 650,:) = [     72,   -576,     -9,    -90,     72,     -9,   -576,   4608,     72,    720,   -576,     72,    -90,    558, &
                    -9,    -90,   -252,    558,    720,    -90,     72,     -9,    558,    639,   -576,   4608,     72,    720, &
                  -576,     72,   -576,   4608,     72,    720,   -576,     72,   -576,     72,   -576,     72,   -576,   -576, &
                  4608,   -576,   4608,   -576,   4608,   4608,   -576,   4608,     72,    720,   -576,     72,     72,   -576, &
                    -9,    -90,     72,     -9,     -9,    -90,    -90,    558,    558,   -252,     72,     -9,    720,    -90, &
                   639,    558,     -9,    639,     72,    720,    558,    -90,     72,     -9,     72,     -9,     72,     72, &
                    72,    720,     -9,    639,    -90,    558,    -90,    720,    720,    720,    720,    -90,     72,     -9, &
                  -576,     72,    -90,     -9,   -576,     72,   -576,     72,   -576,   -576,   -576,     72,     72,     -9, &
                    -9,    -90,     -9,     72,     72,     72,     72,     -9]
  K1( 651,:) = [     72,     -9,    720,    -90,    639,    558,   -576,     72,   4608,   -576,    720,     72,     72,     -9, &
                  -576,     72,    -90,     -9,    558,   -252,    -90,     -9,    558,    -90,   -576,     72,     72,     -9, &
                    -9,    -90,   -576,     72,     72,     -9,     -9,    -90,   -576,     72,   -576,     72,   -576,   -576, &
                    72,     -9,     72,     -9,     72,     72,   -576,     72,   4608,   -576,    720,     72,     72,     -9, &
                   720,    -90,    639,    558,   -576,     72,     72,     -9,     -9,    -90,    -90,     -9,    558,   -252, &
                   -90,    558,   -576,     72,   4608,   -576,    720,     72,   4608,   -576,   4608,   -576,   4608,   4608, &
                  4608,   -576,   -576,     72,     72,    720,     72,   -576,   -576,   -576,   -576,     72,    -90,    558, &
                   720,     72,    639,     -9,    720,    -90,    720,    -90,    720,    720,    720,     72,    -90,    558, &
                    -9,    639,     -9,     72,     72,     72,     72,     -9]
  K1( 652,:) = [     -9,    -90,    -90,    558,    558,   -252,     72,    720,   -576,   4608,     72,   -576,     -9,    -90, &
                    72,   -576,     -9,     72,    639,    558,     -9,     72,    -90,    720,     72,    720,     -9,    639, &
                   -90,    558,     72,    720,     -9,    639,    -90,    558,     72,     -9,     72,     -9,     72,     72, &
                   720,    -90,    720,    -90,    720,    720,     72,    720,   -576,   4608,     72,   -576,     -9,    -90, &
                   -90,    558,    558,   -252,     72,   -576,     -9,    -90,     72,     -9,     -9,     72,    639,    558, &
                   720,    -90,     72,    720,   -576,   4608,     72,   -576,   -576,     72,   -576,     72,   -576,   -576, &
                  -576,   4608,     72,    720,   -576,     72,   -576,   4608,   4608,   4608,   4608,   -576,     -9,    -90, &
                    72,   -576,     -9,     72,     72,     -9,     72,     -9,     72,     72,     72,   -576,     -9,    -90, &
                    72,     -9,     72,   -576,   -576,   -576,   -576,     72]
  K1( 653,:) = [     -9,     72,    639,    558,    720,    -90,     72,   -576,    720,     72,   4608,   -576,    558,   -252, &
                   -90,     -9,    558,    -90,     72,     -9,   -576,     72,    -90,     -9,     72,   -576,     -9,    -90, &
                    72,     -9,     72,   -576,     -9,    -90,     72,     -9,     72,     -9,     72,     -9,     72,     72, &
                  -576,     72,   -576,     72,   -576,   -576,     72,   -576,    720,     72,   4608,   -576,     -9,     72, &
                   639,    558,    720,    -90,    -90,     -9,    558,   -252,    -90,    558,   -576,     72,     72,     -9, &
                    -9,    -90,    -90,    558,    720,     72,    639,     -9,    720,    -90,    720,    -90,    720,    720, &
                   720,     72,    -90,    558,     -9,    639,     -9,     72,     72,     72,     72,     -9,   -576,     72, &
                  4608,   -576,    720,     72,   4608,   -576,   4608,   -576,   4608,   4608,   4608,   -576,   -576,     72, &
                    72,    720,     72,   -576,   -576,   -576,   -576,     72]
  K1( 654,:) = [    -90,     -9,    558,   -252,    -90,    558,    720,     72,     72,   -576,   -576,   4608,    639,    558, &
                    -9,     72,    -90,    720,     -9,    -90,     72,   -576,     -9,     72,    720,     72,    -90,    558, &
                    -9,    639,    720,     72,    -90,    558,     -9,    639,    720,    -90,    720,    -90,    720,    720, &
                    72,     -9,     72,     -9,     72,     72,    720,     72,     72,   -576,   -576,   4608,    -90,     -9, &
                   558,   -252,    -90,    558,     -9,     72,    639,    558,    720,    -90,     72,   -576,     -9,    -90, &
                    72,     -9,     -9,    -90,     72,   -576,     -9,     72,     72,     -9,     72,     -9,     72,     72, &
                    72,   -576,     -9,    -90,     72,     -9,     72,   -576,   -576,   -576,   -576,     72,     72,    720, &
                  -576,   4608,     72,   -576,   -576,     72,   -576,     72,   -576,   -576,   -576,   4608,     72,    720, &
                  -576,     72,   -576,   4608,   4608,   4608,   4608,   -576]
  K1( 655,:) = [  -5760,    720,    720,    -90,    -90,   -900,   -576,     72,     72,     -9,     -9,    -90,  -4464,    558, &
                 -5112,    639,  -4626,  -4545,    558,    477,    639,   -171,    396,   1206,   4608,   -576,   -576,     72, &
                    72,    720,  -5760,    720,    720,    -90,    -90,   -900,  -1224,    153,     72,     -9,   -495,   -657, &
                   153,   -657,     -9,    639,    882,   -738,   -576,     72,     72,     -9,     -9,    -90,   -576,     72, &
                    72,     -9,     -9,    -90,   -576,     72,   -576,     72,   -576,   -576,     72,     -9,     72,     -9, &
                    72,     72,   -576,     72,   4608,   -576,    720,     72,   3960,   -495,   -576,     72,   -414,    153, &
                 -1224,    153,   4608,   -576,    234,   -495,  -1224,   3960,   4041,  -1224,  -1143,   3960,     72,     -9, &
                  -576,     72,    -90,     -9,   -495,   -576,     72,   -738,   -495,     72,    153,   -657,   -576,   -657, &
                  -576,    153,   -576,  -1224,   -414,   -576,    234,  -1224]
  K1( 656,:) = [    720,  -5760,    -90,   -900,    720,    -90,     72,   -576,     -9,    -90,     72,     -9,    558,    477, &
                   639,   -171,    396,   1206,  -4464,    558,  -5112,    639,  -4626,  -4545,   -576,   4608,     72,    720, &
                  -576,     72,    720,  -5760,    -90,   -900,    720,    -90,    153,   -657,     -9,    639,    882,   -738, &
                 -1224,    153,     72,     -9,   -495,   -657,     72,   -576,     -9,    -90,     72,     -9,     72,   -576, &
                    -9,    -90,     72,     -9,     72,     -9,     72,     -9,     72,     72,   -576,     72,   -576,     72, &
                  -576,   -576,     72,     -9,   -576,     72,    -90,     -9,   -495,   -576,     72,   -738,   -495,     72, &
                   153,   -657,   -576,   -657,   -576,    153,   -576,  -1224,   -414,   -576,    234,  -1224,   -576,     72, &
                  4608,   -576,    720,     72,   3960,   -495,   -576,     72,   -414,    153,  -1224,    153,   4608,   -576, &
                   234,   -495,  -1224,   3960,   4041,  -1224,  -1143,   3960]
  K1( 657,:) = [    720,    -90,  -4464,    558,   -171,    477,     72,     -9,    720,    -90,    639,    558,   2016,   -252, &
                 -4464,    558,    396,   1206,   1206,  -3978,  -4545,   1206,   1044,  -3978,   -576,     72,     72,     -9, &
                    -9,    -90,    720,    -90,    720,    -90,    720,    720,   4608,   -576,  -4464,    558,   -495,    639, &
                   234,   -576,   -657,     72,   -414,     -9,     72,     -9,    720,    -90,    639,    558,     72,     -9, &
                    72,     -9,     72,     72,   -576,     72,    720,    -90,    153,     -9,   -576,     72,    153,   -576, &
                  -495,     72,   -576,     72,   4608,   -576,    720,     72,   -576,     72,   2016,   -252,    882,    558, &
                    72,     -9,  -4464,    558,   -657,    -90,    234,  -1143,   -495,    -90,    153,     -9,   -576,     72, &
                  4608,   -576,    720,     72,   -414,   -495,    882,   -576,   4041,     72,   -495,    882,   -495,   4608, &
                  -414,   -576,   -414,   4041,   -414,    720,   -495,     72]
  K1( 658,:) = [    -90,   -900,    558,  -4626,    477,    396,     -9,    -90,    -90,    558,    558,   -252,   -252,    396, &
                   558,    477,   1044,  -3978,    396,   1044,  -4626,    396,  -1224,   1044,     72,    720,     -9,    639, &
                   -90,    558,    -90,   -900,    -90,    -90,    720,   -900,   -576,   -657,    558,    558,   4608,  -4626, &
                  -495,    153,    -90,    477,   -576,    396,     -9,    -90,    -90,    558,    558,   -252,     -9,    -90, &
                    -9,     -9,     72,    -90,     72,     -9,    -90,    -90,   -576,    558,   -576,     72,     -9,    558, &
                    72,   -252,     72,     -9,   -576,     72,    -90,     -9,     72,   -738,   -252,   -252,   -576,    396, &
                    -9,    639,    558,    558,     72,    477,  -1224,   3960,     72,   1044,     -9,  -3978,   -576,     72, &
                  4608,   -576,    720,     72,    153,     72,    558,    396,     72,   1044,   -657,   -738,    639,  -4626, &
                    -9,    396,   -576,  -1224,    720,  -1224,    -90,   1044]
  K1( 659,:) = [    -90,    720,   -171,    477,  -4464,    558,     -9,     72,    639,    558,    720,    -90,   1206,  -3978, &
                 -4545,   1206,   1044,  -3978,   2016,   -252,  -4464,    558,    396,   1206,     72,   -576,     -9,    -90, &
                    72,     -9,    -90,    720,    720,    720,    720,    -90,    234,   -576,   -657,     72,   -414,     -9, &
                  4608,   -576,  -4464,    558,   -495,    639,     -9,     72,    639,    558,    720,    -90,     -9,     72, &
                    72,     72,     72,     -9,   -576,     72,    153,   -576,   -495,     72,   -576,     72,    720,    -90, &
                   153,     -9,   -576,     72,   4608,   -576,    720,     72,   -414,   -495,    882,   -576,   4041,     72, &
                  -495,    882,   -495,   4608,   -414,   -576,   -414,   4041,   -414,    720,   -495,     72,   -576,     72, &
                  4608,   -576,    720,     72,   -576,     72,   2016,   -252,    882,    558,     72,     -9,  -4464,    558, &
                  -657,    -90,    234,  -1143,   -495,    -90,    153,     -9]
  K1( 660,:) = [   -900,    -90,    477,    396,    558,  -4626,    -90,     -9,    558,   -252,    -90,    558,    396,   1044, &
                 -4626,    396,  -1224,   1044,   -252,    396,    558,    477,   1044,  -3978,    720,     72,    -90,    558, &
                    -9,    639,   -900,    -90,    720,   -900,    -90,    -90,   -495,    153,    -90,    477,   -576,    396, &
                  -576,   -657,    558,    558,   4608,  -4626,    -90,     -9,    558,   -252,    -90,    558,    -90,     -9, &
                    72,    -90,     -9,     -9,   -576,     72,     -9,    558,     72,   -252,     72,     -9,    -90,    -90, &
                  -576,    558,   -576,     72,   4608,   -576,    720,     72,    153,     72,    558,    396,     72,   1044, &
                  -657,   -738,    639,  -4626,     -9,    396,   -576,  -1224,    720,  -1224,    -90,   1044,     72,     -9, &
                  -576,     72,    -90,     -9,     72,   -738,   -252,   -252,   -576,    396,     -9,    639,    558,    558, &
                    72,    477,  -1224,   3960,     72,   1044,     -9,  -3978]
  K1( 661,:) = [  -5112,    639,  -4464,    558,  -4545,  -4626,     72,     -9,   -576,     72,    -90,     -9,    720,    -90, &
                 -5760,    720,   -900,    -90,   1206,    396,   -171,    639,    477,    558,   4608,   -576,   -576,     72, &
                    72,    720,  -1224,    153,   4608,   -576,    234,   -495,   3960,   -495,   -576,     72,   -414,    153, &
                  3960,  -1224,  -1143,   3960,   4041,  -1224,     72,     -9,   -576,     72,    -90,     -9,   -576,     72, &
                  -576,     72,   -576,   -576,   -576,     72,     72,     -9,     -9,    -90,     -9,     72,     72,     72, &
                    72,     -9,   -576,     72,   4608,   -576,    720,     72,  -1224,    153,     72,     -9,   -495,   -657, &
                 -5760,    720,    720,    -90,    -90,   -900,   -657,    153,    882,   -738,     -9,    639,     -9,    -90, &
                    72,   -576,     -9,     72,  -1224,   -576,    234,  -1224,   -414,   -576,   -657,    153,   -576,    153, &
                  -576,   -657,   -576,   -495,   -495,     72,     72,   -738]
  K1( 662,:) = [    639,   -171,    558,    477,   1206,    396,     -9,    -90,     72,   -576,     -9,     72,    -90,   -900, &
                   720,  -5760,    -90,    720,  -4545,  -4626,    639,  -5112,    558,  -4464,   -576,     72,     72,     -9, &
                    -9,    -90,    153,   -657,   -576,   -657,   -576,    153,   -495,   -576,     72,   -738,   -495,     72, &
                 -1224,   -576,    234,  -1224,   -414,   -576,     -9,    -90,     72,   -576,     -9,     72,     72,     -9, &
                    72,     -9,     72,     72,     72,   -576,     -9,    -90,     72,     -9,     72,   -576,   -576,   -576, &
                  -576,     72,     72,    720,   -576,   4608,     72,   -576,    153,   -657,     -9,    639,    882,   -738, &
                   720,  -5760,    -90,   -900,    720,    -90,    153,  -1224,   -495,   -657,     72,     -9,     72,    720, &
                  -576,   4608,     72,   -576,   3960,  -1224,  -1143,   3960,   4041,  -1224,    153,  -1224,    234,   -495, &
                  4608,   -576,   -495,   3960,   -414,    153,   -576,     72]
  K1( 663,:) = [  -4464,    558,   2016,   -252,   1206,    396,    720,    -90,     72,     -9,    558,    639,  -4464,    558, &
                   720,    -90,    477,   -171,  -3978,   1044,   1206,  -4545,  -3978,   1206,   4608,   -576,   -576,     72, &
                    72,    720,     72,     -9,  -4464,    558,   -657,    -90,   -576,     72,   2016,   -252,    882,    558, &
                 -1143,    234,    153,     -9,   -495,    -90,    720,    -90,     72,     -9,    558,    639,   -576,     72, &
                   720,    -90,    153,     -9,     72,     -9,     72,     -9,     72,     72,     72,   -576,   -495,     72, &
                   153,   -576,     72,     -9,   -576,     72,    -90,     -9,   4608,   -576,  -4464,    558,   -495,    639, &
                   720,    -90,    720,    -90,    720,    720,   -576,    234,   -414,     -9,   -657,     72,     72,    720, &
                  -576,   4608,     72,   -576,   4041,   -414,   -495,     72,   -414,    720,    882,   -495,   -414,   -576, &
                  -495,   4608,   -495,   -414,   4041,     72,    882,   -576]
  K1( 664,:) = [    558,    477,   -252,    396,  -3978,   1044,    -90,    558,     -9,    -90,   -252,    558,    558,  -4626, &
                   -90,   -900,    396,    477,   1044,  -1224,    396,  -4626,   1044,    396,   -576,     72,     72,     -9, &
                    -9,    -90,     -9,    639,    558,    558,     72,    477,     72,   -738,   -252,   -252,   -576,    396, &
                  3960,  -1224,     -9,  -3978,     72,   1044,    -90,    558,     -9,    -90,   -252,    558,     72,     -9, &
                   -90,    -90,   -576,    558,     -9,    -90,     -9,     -9,     72,    -90,     72,   -576,     72,   -252, &
                    -9,    558,     -9,    639,     72,    720,    558,    -90,   -576,   -657,    558,    558,   4608,  -4626, &
                   -90,   -900,    -90,    -90,    720,   -900,    153,   -495,   -576,    396,    -90,    477,     72,    720, &
                  -576,   4608,     72,   -576,  -1224,   -576,    -90,   1044,    720,  -1224,   -738,   -657,     -9,    396, &
                   639,  -4626,     72,    153,     72,   1044,    558,    396]
  K1( 665,:) = [  -4545,   1206,   1206,  -3978,  -3978,   1044,    639,    558,     -9,     72,    -90,    720,   -171,    477, &
                   -90,    720,    558,  -4464,   1206,    396,    558,  -4464,   -252,   2016,   4608,   -576,   -576,     72, &
                    72,    720,   -495,    882,   -495,   4608,   -414,   -576,   -414,   -495,    882,   -576,   4041,     72, &
                  4041,   -414,   -495,     72,   -414,    720,    639,    558,     -9,     72,    -90,    720,   -576,     72, &
                   153,   -576,   -495,     72,     -9,     72,     72,     72,     72,     -9,     72,   -576,    153,     -9, &
                   720,    -90,     -9,    -90,     72,   -576,     -9,     72,    234,   -576,   -657,     72,   -414,     -9, &
                   -90,    720,    720,    720,    720,    -90,   -576,   4608,   -495,    639,  -4464,    558,     72,    720, &
                  -576,   4608,     72,   -576,  -1143,    234,    153,     -9,   -495,    -90,     -9,     72,   -657,    -90, &
                 -4464,    558,     72,   -576,    882,    558,   2016,   -252]
  K1( 666,:) = [  -4626,    396,    396,   1044,   1044,  -1224,    558,   -252,    -90,     -9,    558,    -90,    477,    396, &
                  -900,    -90,  -4626,    558,  -3978,   1044,    477,    558,    396,   -252,   4608,   -576,   -576,     72, &
                    72,    720,   -657,   -738,    639,  -4626,     -9,    396,    153,     72,    558,    396,     72,   1044, &
                 -1224,   -576,    -90,   1044,    720,  -1224,    558,   -252,    -90,     -9,    558,    -90,   -576,     72, &
                    -9,    558,     72,   -252,    -90,     -9,     72,    -90,     -9,     -9,     -9,     72,   -576,    558, &
                   -90,    -90,    -90,    558,    720,     72,    639,     -9,   -495,    153,    -90,    477,   -576,    396, &
                  -900,    -90,    720,   -900,    -90,    -90,   -657,   -576,   4608,  -4626,    558,    558,     -9,    -90, &
                    72,   -576,     -9,     72,   3960,  -1224,     -9,  -3978,     72,   1044,    639,     -9,     72,    477, &
                   558,    558,   -738,     72,   -576,    396,   -252,   -252]
  K1( 667,:) = [    639,  -5112,  -4545,  -4626,  -4464,    558,     -9,     72,    -90,     -9,   -576,     72,   1206,    396, &
                  -171,    639,    477,    558,    720,    -90,  -5760,    720,   -900,    -90,   -576,   4608,     72,    720, &
                  -576,     72,    153,  -1224,    234,   -495,   4608,   -576,   3960,  -1224,  -1143,   3960,   4041,  -1224, &
                  3960,   -495,   -576,     72,   -414,    153,     -9,     72,    -90,     -9,   -576,     72,     72,   -576, &
                  -576,   -576,   -576,     72,     -9,     72,     72,     72,     72,     -9,   -576,     72,     72,     -9, &
                    -9,    -90,     -9,    -90,     72,   -576,     -9,     72,  -1224,   -576,    234,  -1224,   -414,   -576, &
                  -657,    153,   -576,    153,   -576,   -657,   -576,   -495,   -495,     72,     72,   -738,   -576,     72, &
                  4608,   -576,    720,     72,  -1224,    153,     72,     -9,   -495,   -657,  -5760,    720,    720,    -90, &
                   -90,   -900,   -657,    153,    882,   -738,     -9,    639]
  K1( 668,:) = [   -171,    639,   1206,    396,    558,    477,    -90,     -9,     -9,     72,     72,   -576,  -4545,  -4626, &
                   639,  -5112,    558,  -4464,    -90,   -900,    720,  -5760,    -90,    720,     72,   -576,     -9,    -90, &
                    72,     -9,   -657,    153,   -576,    153,   -576,   -657,  -1224,   -576,    234,  -1224,   -414,   -576, &
                  -495,   -576,     72,   -738,   -495,     72,    -90,     -9,     -9,     72,     72,   -576,     -9,     72, &
                    72,     72,     72,     -9,     72,   -576,   -576,   -576,   -576,     72,     72,   -576,     -9,    -90, &
                    72,     -9,     72,    720,   -576,   4608,     72,   -576,   3960,  -1224,  -1143,   3960,   4041,  -1224, &
                   153,  -1224,    234,   -495,   4608,   -576,   -495,   3960,   -414,    153,   -576,     72,     72,    720, &
                  -576,   4608,     72,   -576,    153,   -657,     -9,    639,    882,   -738,    720,  -5760,    -90,   -900, &
                   720,    -90,    153,  -1224,   -495,   -657,     72,     -9]
  K1( 669,:) = [    558,  -4464,   1206,    396,   2016,   -252,    -90,    720,    558,    639,     72,     -9,  -3978,   1044, &
                  1206,  -4545,  -3978,   1206,  -4464,    558,    720,    -90,    477,   -171,   -576,   4608,     72,    720, &
                  -576,     72,     -9,     72,   -657,    -90,  -4464,    558,  -1143,    234,    153,     -9,   -495,    -90, &
                  -576,     72,   2016,   -252,    882,    558,    -90,    720,    558,    639,     72,     -9,     72,   -576, &
                   153,     -9,    720,    -90,     72,   -576,   -495,     72,    153,   -576,     72,     -9,     72,     -9, &
                    72,     72,     72,    720,   -576,   4608,     72,   -576,   4041,   -414,   -495,     72,   -414,    720, &
                   882,   -495,   -414,   -576,   -495,   4608,   -495,   -414,   4041,     72,    882,   -576,     72,     -9, &
                  -576,     72,    -90,     -9,   4608,   -576,  -4464,    558,   -495,    639,    720,    -90,    720,    -90, &
                   720,    720,   -576,    234,   -414,     -9,   -657,     72]
  K1( 670,:) = [    477,    558,  -3978,   1044,   -252,    396,    558,    -90,   -252,    558,     -9,    -90,   1044,  -1224, &
                   396,  -4626,   1044,    396,    558,  -4626,    -90,   -900,    396,    477,     72,   -576,     -9,    -90, &
                    72,     -9,    639,     -9,     72,    477,    558,    558,   3960,  -1224,     -9,  -3978,     72,   1044, &
                    72,   -738,   -252,   -252,   -576,    396,    558,    -90,   -252,    558,     -9,    -90,     -9,     72, &
                  -576,    558,    -90,    -90,     72,   -576,     72,   -252,     -9,    558,     -9,    -90,     -9,     -9, &
                    72,    -90,     72,    720,   -576,   4608,     72,   -576,  -1224,   -576,    -90,   1044,    720,  -1224, &
                  -738,   -657,     -9,    396,    639,  -4626,     72,    153,     72,   1044,    558,    396,     -9,    639, &
                    72,    720,    558,    -90,   -576,   -657,    558,    558,   4608,  -4626,    -90,   -900,    -90,    -90, &
                   720,   -900,    153,   -495,   -576,    396,    -90,    477]
  K1( 671,:) = [   1206,  -4545,  -3978,   1044,   1206,  -3978,    558,    639,    -90,    720,     -9,     72,   1206,    396, &
                   558,  -4464,   -252,   2016,   -171,    477,    -90,    720,    558,  -4464,   -576,   4608,     72,    720, &
                  -576,     72,    882,   -495,   -414,   -576,   -495,   4608,   4041,   -414,   -495,     72,   -414,    720, &
                  -414,   -495,    882,   -576,   4041,     72,    558,    639,    -90,    720,     -9,     72,     72,   -576, &
                  -495,     72,    153,   -576,     72,   -576,    153,     -9,    720,    -90,     -9,     72,     72,     72, &
                    72,     -9,     72,    720,   -576,   4608,     72,   -576,  -1143,    234,    153,     -9,   -495,    -90, &
                    -9,     72,   -657,    -90,  -4464,    558,     72,   -576,    882,    558,   2016,   -252,     -9,    -90, &
                    72,   -576,     -9,     72,    234,   -576,   -657,     72,   -414,     -9,    -90,    720,    720,    720, &
                   720,    -90,   -576,   4608,   -495,    639,  -4464,    558]
  K1( 672,:) = [    396,  -4626,   1044,  -1224,    396,   1044,   -252,    558,    558,    -90,    -90,     -9,  -3978,   1044, &
                   477,    558,    396,   -252,    477,    396,   -900,    -90,  -4626,    558,   -576,   4608,     72,    720, &
                  -576,     72,   -738,   -657,     -9,    396,    639,  -4626,  -1224,   -576,    -90,   1044,    720,  -1224, &
                   153,     72,    558,    396,     72,   1044,   -252,    558,    558,    -90,    -90,     -9,     72,   -576, &
                    72,   -252,     -9,    558,     -9,     72,   -576,    558,    -90,    -90,    -90,     -9,     72,    -90, &
                    -9,     -9,     -9,    -90,     72,   -576,     -9,     72,   3960,  -1224,     -9,  -3978,     72,   1044, &
                   639,     -9,     72,    477,    558,    558,   -738,     72,   -576,    396,   -252,   -252,    -90,    558, &
                   720,     72,    639,     -9,   -495,    153,    -90,    477,   -576,    396,   -900,    -90,    720,   -900, &
                   -90,    -90,   -657,   -576,   4608,  -4626,    558,    558]
  K1( 673,:) = [     72,     -9,   -576,     72,    -90,     -9,    720,    -90,     72,     -9,    558,    639,   4608,   -576, &
                  -576,     72,     72,    720,    558,    -90,   -252,    558,     -9,    -90,   -576,     72,   4608,   -576, &
                   720,     72,   4608,   -576,   4608,   -576,   4608,   4608,   4608,   -576,   -576,     72,     72,    720, &
                    72,   -576,   -576,   -576,   -576,     72,     72,     -9,   -576,     72,    -90,     -9,   -576,     72, &
                  -576,     72,   -576,   -576,   -576,     72,     72,     -9,     -9,    -90,     -9,     72,     72,     72, &
                    72,     -9,   4608,   -576,   -576,     72,     72,    720,   -576,     72,     72,     -9,     -9,    -90, &
                    72,     -9,    720,    -90,    639,    558,     -9,    -90,    -90,    558,    558,   -252,    639,     -9, &
                   558,    -90,     72,    720,     -9,     72,     72,     72,     72,     -9,    -90,    720,    720,    720, &
                   720,    -90,     72,    720,     -9,    639,    -90,    558]
  K1( 674,:) = [     -9,    -90,     72,   -576,     -9,     72,    -90,    558,     -9,    -90,   -252,    558,   -576,   4608, &
                    72,    720,   -576,     72,    -90,    720,    558,    639,     72,     -9,     72,    720,   -576,   4608, &
                    72,   -576,   -576,     72,   -576,     72,   -576,   -576,   -576,   4608,     72,    720,   -576,     72, &
                  -576,   4608,   4608,   4608,   4608,   -576,     -9,    639,     72,    720,    558,    -90,     72,     -9, &
                    72,     -9,     72,     72,     72,    720,     -9,    639,    -90,    558,    -90,    720,    720,    720, &
                   720,    -90,   -576,   4608,     72,    720,   -576,     72,     72,   -576,     -9,    -90,     72,     -9, &
                    -9,    -90,    -90,    558,    558,   -252,     72,     -9,    720,    -90,    639,    558,     -9,     72, &
                   -90,     -9,   -576,     72,     72,   -576,   -576,   -576,   -576,     72,     -9,     72,     72,     72, &
                    72,     -9,   -576,     72,     72,     -9,     -9,    -90]
  K1( 675,:) = [    720,    -90,     72,     -9,    558,    639,     72,     -9,   -576,     72,    -90,     -9,   -576,     72, &
                  4608,   -576,    720,     72,   -252,    558,    558,    -90,    -90,     -9,     72,     -9,   -576,     72, &
                   -90,     -9,   -576,     72,   -576,     72,   -576,   -576,   -576,     72,     72,     -9,     -9,    -90, &
                    -9,     72,     72,     72,     72,     -9,   -576,     72,   4608,   -576,    720,     72,   4608,   -576, &
                  4608,   -576,   4608,   4608,   4608,   -576,   -576,     72,     72,    720,     72,   -576,   -576,   -576, &
                  -576,     72,   -576,     72,   4608,   -576,    720,     72,     72,     -9,    720,    -90,    639,    558, &
                  -576,     72,     72,     -9,     -9,    -90,    -90,     -9,    558,   -252,    -90,    558,    558,    -90, &
                   639,     -9,    720,     72,    -90,    720,    720,    720,    720,    -90,     -9,     72,     72,     72, &
                    72,     -9,    720,     72,    -90,    558,     -9,    639]
  K1( 676,:) = [    -90,    558,     -9,    -90,   -252,    558,     -9,    -90,     72,   -576,     -9,     72,     72,    720, &
                  -576,   4608,     72,   -576,    558,    639,    -90,    720,     -9,     72,     -9,    639,     72,    720, &
                   558,    -90,     72,     -9,     72,     -9,     72,     72,     72,    720,     -9,    639,    -90,    558, &
                   -90,    720,    720,    720,    720,    -90,     72,    720,   -576,   4608,     72,   -576,   -576,     72, &
                  -576,     72,   -576,   -576,   -576,   4608,     72,    720,   -576,     72,   -576,   4608,   4608,   4608, &
                  4608,   -576,     72,    720,   -576,   4608,     72,   -576,     -9,    -90,    -90,    558,    558,   -252, &
                    72,   -576,     -9,    -90,     72,     -9,     -9,     72,    639,    558,    720,    -90,    -90,     -9, &
                    -9,     72,     72,   -576,     -9,     72,     72,     72,     72,     -9,     72,   -576,   -576,   -576, &
                  -576,     72,     72,   -576,     -9,    -90,     72,     -9]
  K1( 677,:) = [    639,    558,     -9,     72,    -90,    720,    558,   -252,    -90,     -9,    558,    -90,     72,   -576, &
                   720,     72,   4608,   -576,     -9,     72,    -90,     -9,   -576,     72,     -9,    -90,     72,   -576, &
                    -9,     72,     72,     -9,     72,     -9,     72,     72,     72,   -576,     -9,    -90,     72,     -9, &
                    72,   -576,   -576,   -576,   -576,     72,    -90,    558,    720,     72,    639,     -9,    720,    -90, &
                   720,    -90,    720,    720,    720,     72,    -90,    558,     -9,    639,     -9,     72,     72,     72, &
                    72,     -9,     72,   -576,    720,     72,   4608,   -576,     -9,     72,    639,    558,    720,    -90, &
                   -90,     -9,    558,   -252,    -90,    558,   -576,     72,     72,     -9,     -9,    -90,     72,   -576, &
                   720,     72,   4608,   -576,   -576,   4608,   4608,   4608,   4608,   -576,     72,   -576,   -576,   -576, &
                  -576,     72,   4608,   -576,   -576,     72,     72,    720]
  K1( 678,:) = [    558,   -252,    -90,     -9,    558,    -90,    639,    558,     -9,     72,    -90,    720,    720,     72, &
                    72,   -576,   -576,   4608,    -90,     -9,     -9,     72,     72,   -576,    -90,    558,    720,     72, &
                   639,     -9,    720,    -90,    720,    -90,    720,    720,    720,     72,    -90,    558,     -9,    639, &
                    -9,     72,     72,     72,     72,     -9,     -9,    -90,     72,   -576,     -9,     72,     72,     -9, &
                    72,     -9,     72,     72,     72,   -576,     -9,    -90,     72,     -9,     72,   -576,   -576,   -576, &
                  -576,     72,    720,     72,     72,   -576,   -576,   4608,    -90,     -9,    558,   -252,    -90,    558, &
                    -9,     72,    639,    558,    720,    -90,     72,   -576,     -9,    -90,     72,     -9,    720,     72, &
                    72,   -576,   -576,   4608,     72,   -576,   -576,   -576,   -576,     72,   -576,   4608,   4608,   4608, &
                  4608,   -576,   -576,   4608,     72,    720,   -576,     72]
  K1( 679,:) = [    720,    -90,  -5760,    720,   -900,    -90,  -4464,    558,  -5112,    639,  -4626,  -4545,   -576,     72, &
                    72,     -9,     -9,    -90,    477,    558,    396,   1206,    639,   -171,   -576,     72,   4608,   -576, &
                   720,     72,  -1224,    153,     72,     -9,   -495,   -657,  -5760,    720,    720,    -90,    -90,   -900, &
                  -657,    153,    882,   -738,     -9,    639,   -576,     72,   4608,   -576,    720,     72,   3960,   -495, &
                  -576,     72,   -414,    153,  -1224,    153,   4608,   -576,    234,   -495,  -1224,   3960,   4041,  -1224, &
                 -1143,   3960,   -576,     72,     72,     -9,     -9,    -90,   -576,     72,     72,     -9,     -9,    -90, &
                  -576,     72,   -576,     72,   -576,   -576,     72,     -9,     72,     -9,     72,     72,     -9,     72, &
                   -90,     -9,   -576,     72,   -576,   -495,   -495,     72,     72,   -738,   -576,  -1224,   -414,   -576, &
                   234,  -1224,    153,   -657,   -576,   -657,   -576,    153]
  K1( 680,:) = [    -90,   -900,    720,  -5760,    -90,    720,    558,    477,    639,   -171,    396,   1206,     72,   -576, &
                    -9,    -90,     72,     -9,    558,  -4464,  -4626,  -4545,  -5112,    639,     72,    720,   -576,   4608, &
                    72,   -576,    153,   -657,     -9,    639,    882,   -738,    720,  -5760,    -90,   -900,    720,    -90, &
                   153,  -1224,   -495,   -657,     72,     -9,     72,     -9,   -576,     72,    -90,     -9,   -495,   -576, &
                    72,   -738,   -495,     72,    153,   -657,   -576,   -657,   -576,    153,   -576,  -1224,   -414,   -576, &
                   234,  -1224,     72,   -576,     -9,    -90,     72,     -9,     72,   -576,     -9,    -90,     72,     -9, &
                    72,     -9,     72,     -9,     72,     72,   -576,     72,   -576,     72,   -576,   -576,     72,   -576, &
                   720,     72,   4608,   -576,   -495,   3960,   -414,    153,   -576,     72,  -1224,   3960,   4041,  -1224, &
                 -1143,   3960,  -1224,    153,   4608,   -576,    234,   -495]
  K1( 681,:) = [  -4464,    558,    720,    -90,    477,   -171,   2016,   -252,  -4464,    558,    396,   1206,     72,     -9, &
                   720,    -90,    639,    558,  -3978,   1206,   1044,  -3978,  -4545,   1206,     72,     -9,   -576,     72, &
                   -90,     -9,   4608,   -576,  -4464,    558,   -495,    639,    720,    -90,    720,    -90,    720,    720, &
                  -576,    234,   -414,     -9,   -657,     72,   -576,     72,   4608,   -576,    720,     72,   -576,     72, &
                  2016,   -252,    882,    558,     72,     -9,  -4464,    558,   -657,    -90,    234,  -1143,   -495,    -90, &
                   153,     -9,     72,     -9,    720,    -90,    639,    558,     72,     -9,     72,     -9,     72,     72, &
                  -576,     72,    720,    -90,    153,     -9,   -576,     72,    153,   -576,   -495,     72,     72,   -576, &
                   720,     72,   4608,   -576,   -495,   -414,   4041,     72,    882,   -576,   -414,   4041,   -414,    720, &
                  -495,     72,   -495,    882,   -495,   4608,   -414,   -576]
  K1( 682,:) = [    558,  -4626,    -90,   -900,    396,    477,   -252,    396,    558,    477,   1044,  -3978,     -9,    -90, &
                   -90,    558,    558,   -252,   1044,    396,  -1224,   1044,  -4626,    396,     -9,    639,     72,    720, &
                   558,    -90,   -576,   -657,    558,    558,   4608,  -4626,    -90,   -900,    -90,    -90,    720,   -900, &
                   153,   -495,   -576,    396,    -90,    477,     72,     -9,   -576,     72,    -90,     -9,     72,   -738, &
                  -252,   -252,   -576,    396,     -9,    639,    558,    558,     72,    477,  -1224,   3960,     72,   1044, &
                    -9,  -3978,     -9,    -90,    -90,    558,    558,   -252,     -9,    -90,     -9,     -9,     72,    -90, &
                    72,     -9,    -90,    -90,   -576,    558,   -576,     72,     -9,    558,     72,   -252,     72,   -576, &
                   720,     72,   4608,   -576,     72,    153,     72,   1044,    558,    396,   -576,  -1224,    720,  -1224, &
                   -90,   1044,   -657,   -738,    639,  -4626,     -9,    396]
  K1( 683,:) = [   -171,    477,    -90,    720,    558,  -4464,   1206,  -3978,  -4545,   1206,   1044,  -3978,     -9,     72, &
                   639,    558,    720,    -90,   -252,   2016,    396,   1206,  -4464,    558,     -9,    -90,     72,   -576, &
                    -9,     72,    234,   -576,   -657,     72,   -414,     -9,    -90,    720,    720,    720,    720,    -90, &
                  -576,   4608,   -495,    639,  -4464,    558,   -576,     72,   4608,   -576,    720,     72,   -414,   -495, &
                   882,   -576,   4041,     72,   -495,    882,   -495,   4608,   -414,   -576,   -414,   4041,   -414,    720, &
                  -495,     72,     -9,     72,    639,    558,    720,    -90,     -9,     72,     72,     72,     72,     -9, &
                  -576,     72,    153,   -576,   -495,     72,   -576,     72,    720,    -90,    153,     -9,     72,   -576, &
                   720,     72,   4608,   -576,     72,   -576,    882,    558,   2016,   -252,    234,  -1143,   -495,    -90, &
                   153,     -9,     72,     -9,  -4464,    558,   -657,    -90]
  K1( 684,:) = [    477,    396,   -900,    -90,  -4626,    558,    396,   1044,  -4626,    396,  -1224,   1044,    -90,     -9, &
                   558,   -252,    -90,    558,    396,   -252,   1044,  -3978,    558,    477,    -90,    558,    720,     72, &
                   639,     -9,   -495,    153,    -90,    477,   -576,    396,   -900,    -90,    720,   -900,    -90,    -90, &
                  -657,   -576,   4608,  -4626,    558,    558,   -576,     72,   4608,   -576,    720,     72,    153,     72, &
                   558,    396,     72,   1044,   -657,   -738,    639,  -4626,     -9,    396,   -576,  -1224,    720,  -1224, &
                   -90,   1044,    -90,     -9,    558,   -252,    -90,    558,    -90,     -9,     72,    -90,     -9,     -9, &
                  -576,     72,     -9,    558,     72,   -252,     72,     -9,    -90,    -90,   -576,    558,     -9,     72, &
                   -90,     -9,   -576,     72,   -738,     72,   -576,    396,   -252,   -252,  -1224,   3960,     72,   1044, &
                    -9,  -3978,     -9,    639,    558,    558,     72,    477]
  K1( 685,:) = [  -4464,    558,  -5112,    639,  -4626,  -4545,    720,    -90,  -5760,    720,   -900,    -90,     72,     -9, &
                  -576,     72,    -90,     -9,    396,   1206,    477,    558,   -171,    639,   -576,     72,   4608,   -576, &
                   720,     72,   3960,   -495,   -576,     72,   -414,    153,  -1224,    153,   4608,   -576,    234,   -495, &
                 -1224,   3960,   4041,  -1224,  -1143,   3960,   -576,     72,   4608,   -576,    720,     72,  -1224,    153, &
                    72,     -9,   -495,   -657,  -5760,    720,    720,    -90,    -90,   -900,   -657,    153,    882,   -738, &
                    -9,    639,     72,     -9,   -576,     72,    -90,     -9,   -576,     72,   -576,     72,   -576,   -576, &
                  -576,     72,     72,     -9,     -9,    -90,     -9,     72,     72,     72,     72,     -9,    -90,     -9, &
                    -9,     72,     72,   -576,   -576,  -1224,   -414,   -576,    234,  -1224,   -576,   -495,   -495,     72, &
                    72,   -738,   -657,    153,   -576,    153,   -576,   -657]
  K1( 686,:) = [    558,    477,    639,   -171,    396,   1206,    -90,   -900,    720,  -5760,    -90,    720,     -9,    -90, &
                    72,   -576,     -9,     72,  -4626,  -4545,    558,  -4464,    639,  -5112,     72,     -9,   -576,     72, &
                   -90,     -9,   -495,   -576,     72,   -738,   -495,     72,    153,   -657,   -576,   -657,   -576,    153, &
                  -576,  -1224,   -414,   -576,    234,  -1224,     72,    720,   -576,   4608,     72,   -576,    153,   -657, &
                    -9,    639,    882,   -738,    720,  -5760,    -90,   -900,    720,    -90,    153,  -1224,   -495,   -657, &
                    72,     -9,     -9,    -90,     72,   -576,     -9,     72,     72,     -9,     72,     -9,     72,     72, &
                    72,   -576,     -9,    -90,     72,     -9,     72,   -576,   -576,   -576,   -576,     72,    720,     72, &
                    72,   -576,   -576,   4608,  -1224,   3960,   4041,  -1224,  -1143,   3960,   -495,   3960,   -414,    153, &
                  -576,     72,    153,  -1224,    234,   -495,   4608,   -576]
  K1( 687,:) = [   2016,   -252,  -4464,    558,    396,   1206,  -4464,    558,    720,    -90,    477,   -171,    720,    -90, &
                    72,     -9,    558,    639,   1044,  -3978,  -3978,   1206,   1206,  -4545,   -576,     72,   4608,   -576, &
                   720,     72,   -576,     72,   2016,   -252,    882,    558,     72,     -9,  -4464,    558,   -657,    -90, &
                   234,  -1143,   -495,    -90,    153,     -9,     72,     -9,   -576,     72,    -90,     -9,   4608,   -576, &
                 -4464,    558,   -495,    639,    720,    -90,    720,    -90,    720,    720,   -576,    234,   -414,     -9, &
                  -657,     72,    720,    -90,     72,     -9,    558,    639,   -576,     72,    720,    -90,    153,     -9, &
                    72,     -9,     72,     -9,     72,     72,     72,   -576,   -495,     72,    153,   -576,    720,     72, &
                    72,   -576,   -576,   4608,   -414,   4041,   -414,    720,   -495,     72,   -495,   -414,   4041,     72, &
                   882,   -576,    882,   -495,   -414,   -576,   -495,   4608]
  K1( 688,:) = [   -252,    396,    558,    477,   1044,  -3978,    558,  -4626,    -90,   -900,    396,    477,    -90,    558, &
                    -9,    -90,   -252,    558,  -1224,   1044,   1044,    396,    396,  -4626,     72,     -9,   -576,     72, &
                   -90,     -9,     72,   -738,   -252,   -252,   -576,    396,     -9,    639,    558,    558,     72,    477, &
                 -1224,   3960,     72,   1044,     -9,  -3978,     -9,    639,     72,    720,    558,    -90,   -576,   -657, &
                   558,    558,   4608,  -4626,    -90,   -900,    -90,    -90,    720,   -900,    153,   -495,   -576,    396, &
                   -90,    477,    -90,    558,     -9,    -90,   -252,    558,     72,     -9,    -90,    -90,   -576,    558, &
                    -9,    -90,     -9,     -9,     72,    -90,     72,   -576,     72,   -252,     -9,    558,    720,     72, &
                    72,   -576,   -576,   4608,   -576,  -1224,    720,  -1224,    -90,   1044,     72,    153,     72,   1044, &
                   558,    396,   -738,   -657,     -9,    396,    639,  -4626]
  K1( 689,:) = [   1206,  -3978,  -4545,   1206,   1044,  -3978,   -171,    477,    -90,    720,    558,  -4464,    639,    558, &
                    -9,     72,    -90,    720,    396,   1206,   -252,   2016,    558,  -4464,   -576,     72,   4608,   -576, &
                   720,     72,   -414,   -495,    882,   -576,   4041,     72,   -495,    882,   -495,   4608,   -414,   -576, &
                  -414,   4041,   -414,    720,   -495,     72,     -9,    -90,     72,   -576,     -9,     72,    234,   -576, &
                  -657,     72,   -414,     -9,    -90,    720,    720,    720,    720,    -90,   -576,   4608,   -495,    639, &
                 -4464,    558,    639,    558,     -9,     72,    -90,    720,   -576,     72,    153,   -576,   -495,     72, &
                    -9,     72,     72,     72,     72,     -9,     72,   -576,    153,     -9,    720,    -90,    720,     72, &
                    72,   -576,   -576,   4608,    234,  -1143,   -495,    -90,    153,     -9,     72,   -576,    882,    558, &
                  2016,   -252,     -9,     72,   -657,    -90,  -4464,    558]
  K1( 690,:) = [    396,   1044,  -4626,    396,  -1224,   1044,    477,    396,   -900,    -90,  -4626,    558,    558,   -252, &
                   -90,     -9,    558,    -90,   1044,  -3978,    396,   -252,    477,    558,   -576,     72,   4608,   -576, &
                   720,     72,    153,     72,    558,    396,     72,   1044,   -657,   -738,    639,  -4626,     -9,    396, &
                  -576,  -1224,    720,  -1224,    -90,   1044,    -90,    558,    720,     72,    639,     -9,   -495,    153, &
                   -90,    477,   -576,    396,   -900,    -90,    720,   -900,    -90,    -90,   -657,   -576,   4608,  -4626, &
                   558,    558,    558,   -252,    -90,     -9,    558,    -90,   -576,     72,     -9,    558,     72,   -252, &
                   -90,     -9,     72,    -90,     -9,     -9,     -9,     72,   -576,    558,    -90,    -90,    -90,     -9, &
                    -9,     72,     72,   -576,  -1224,   3960,     72,   1044,     -9,  -3978,   -738,     72,   -576,    396, &
                  -252,   -252,    639,     -9,     72,    477,    558,    558]
  K1( 691,:) = [  -4545,  -4626,    639,  -5112,    558,  -4464,   1206,    396,   -171,    639,    477,    558,     -9,     72, &
                   -90,     -9,   -576,     72,    -90,    720,   -900,    -90,  -5760,    720,     72,    720,   -576,   4608, &
                    72,   -576,   3960,  -1224,  -1143,   3960,   4041,  -1224,    153,  -1224,    234,   -495,   4608,   -576, &
                  -495,   3960,   -414,    153,   -576,     72,     -9,    -90,     72,   -576,     -9,     72,  -1224,   -576, &
                   234,  -1224,   -414,   -576,   -657,    153,   -576,    153,   -576,   -657,   -576,   -495,   -495,     72, &
                    72,   -738,     -9,     72,    -90,     -9,   -576,     72,     72,   -576,   -576,   -576,   -576,     72, &
                    -9,     72,     72,     72,     72,     -9,   -576,     72,     72,     -9,     -9,    -90,     72,   -576, &
                   720,     72,   4608,   -576,    153,  -1224,   -495,   -657,     72,     -9,   -657,    153,    882,   -738, &
                    -9,    639,  -5760,    720,    720,    -90,    -90,   -900]
  K1( 692,:) = [   1206,    396,   -171,    639,    477,    558,  -4545,  -4626,    639,  -5112,    558,  -4464,    -90,     -9, &
                    -9,     72,     72,   -576,   -900,    -90,    -90,    720,    720,  -5760,     -9,    -90,     72,   -576, &
                    -9,     72,  -1224,   -576,    234,  -1224,   -414,   -576,   -657,    153,   -576,    153,   -576,   -657, &
                  -576,   -495,   -495,     72,     72,   -738,     72,    720,   -576,   4608,     72,   -576,   3960,  -1224, &
                 -1143,   3960,   4041,  -1224,    153,  -1224,    234,   -495,   4608,   -576,   -495,   3960,   -414,    153, &
                  -576,     72,    -90,     -9,     -9,     72,     72,   -576,     -9,     72,     72,     72,     72,     -9, &
                    72,   -576,   -576,   -576,   -576,     72,     72,   -576,     -9,    -90,     72,     -9,    720,     72, &
                    72,   -576,   -576,   4608,   -657,    153,    882,   -738,     -9,    639,    153,  -1224,   -495,   -657, &
                    72,     -9,    720,  -5760,    -90,   -900,    720,    -90]
  K1( 693,:) = [   1206,    396,    558,  -4464,   -252,   2016,  -3978,   1044,   1206,  -4545,  -3978,   1206,    -90,    720, &
                   558,    639,     72,     -9,    558,  -4464,    477,   -171,    720,    -90,     72,    720,   -576,   4608, &
                    72,   -576,  -1143,    234,    153,     -9,   -495,    -90,     -9,     72,   -657,    -90,  -4464,    558, &
                    72,   -576,    882,    558,   2016,   -252,     72,    720,   -576,   4608,     72,   -576,   4041,   -414, &
                  -495,     72,   -414,    720,    882,   -495,   -414,   -576,   -495,   4608,   -495,   -414,   4041,     72, &
                   882,   -576,    -90,    720,    558,    639,     72,     -9,     72,   -576,    153,     -9,    720,    -90, &
                    72,   -576,   -495,     72,    153,   -576,     72,     -9,     72,     -9,     72,     72,     -9,     72, &
                   -90,     -9,   -576,     72,   -576,   4608,   -495,    639,  -4464,    558,   -576,    234,   -414,     -9, &
                  -657,     72,    720,    -90,    720,    -90,    720,    720]
  K1( 694,:) = [  -3978,   1044,    477,    558,    396,   -252,   1044,  -1224,    396,  -4626,   1044,    396,    558,    -90, &
                  -252,    558,     -9,    -90,  -4626,    558,    396,    477,    -90,   -900,     -9,    -90,     72,   -576, &
                    -9,     72,   3960,  -1224,     -9,  -3978,     72,   1044,    639,     -9,     72,    477,    558,    558, &
                  -738,     72,   -576,    396,   -252,   -252,     72,    720,   -576,   4608,     72,   -576,  -1224,   -576, &
                   -90,   1044,    720,  -1224,   -738,   -657,     -9,    396,    639,  -4626,     72,    153,     72,   1044, &
                   558,    396,    558,    -90,   -252,    558,     -9,    -90,     -9,     72,   -576,    558,    -90,    -90, &
                    72,   -576,     72,   -252,     -9,    558,     -9,    -90,     -9,     -9,     72,    -90,    639,     -9, &
                   558,    -90,     72,    720,   -657,   -576,   4608,  -4626,    558,    558,    153,   -495,   -576,    396, &
                   -90,    477,    -90,   -900,    -90,    -90,    720,   -900]
  K1( 695,:) = [  -3978,   1044,   1206,  -4545,  -3978,   1206,   1206,    396,    558,  -4464,   -252,   2016,    558,    639, &
                   -90,    720,     -9,     72,    477,   -171,    558,  -4464,    -90,    720,     72,    720,   -576,   4608, &
                    72,   -576,   4041,   -414,   -495,     72,   -414,    720,    882,   -495,   -414,   -576,   -495,   4608, &
                  -495,   -414,   4041,     72,    882,   -576,     72,    720,   -576,   4608,     72,   -576,  -1143,    234, &
                   153,     -9,   -495,    -90,     -9,     72,   -657,    -90,  -4464,    558,     72,   -576,    882,    558, &
                  2016,   -252,    558,    639,    -90,    720,     -9,     72,     72,   -576,   -495,     72,    153,   -576, &
                    72,   -576,    153,     -9,    720,    -90,     -9,     72,     72,     72,     72,     -9,    -90,     -9, &
                    -9,     72,     72,   -576,   -576,    234,   -414,     -9,   -657,     72,   -576,   4608,   -495,    639, &
                 -4464,    558,    -90,    720,    720,    720,    720,    -90]
  K1( 696,:) = [   1044,  -1224,    396,  -4626,   1044,    396,  -3978,   1044,    477,    558,    396,   -252,   -252,    558, &
                   558,    -90,    -90,     -9,    396,    477,  -4626,    558,   -900,    -90,     72,    720,   -576,   4608, &
                    72,   -576,  -1224,   -576,    -90,   1044,    720,  -1224,   -738,   -657,     -9,    396,    639,  -4626, &
                    72,    153,     72,   1044,    558,    396,     -9,    -90,     72,   -576,     -9,     72,   3960,  -1224, &
                    -9,  -3978,     72,   1044,    639,     -9,     72,    477,    558,    558,   -738,     72,   -576,    396, &
                  -252,   -252,   -252,    558,    558,    -90,    -90,     -9,     72,   -576,     72,   -252,     -9,    558, &
                    -9,     72,   -576,    558,    -90,    -90,    -90,     -9,     72,    -90,     -9,     -9,    558,    -90, &
                   639,     -9,    720,     72,    153,   -495,   -576,    396,    -90,    477,   -657,   -576,   4608,  -4626, &
                   558,    558,   -900,    -90,    720,   -900,    -90,    -90]
  K1( 697,:) = [     -9,     72,    -90,     -9,   -576,     72,    -90,    720,    558,    639,     72,     -9,    558,    -90, &
                  -252,    558,     -9,    -90,   4608,   -576,   -576,     72,     72,    720,     72,   -576,    720,     72, &
                  4608,   -576,   -576,   4608,   4608,   4608,   4608,   -576,     72,   -576,   -576,   -576,   -576,     72, &
                  4608,   -576,   -576,     72,     72,    720,     -9,     72,    -90,     -9,   -576,     72,     72,   -576, &
                  -576,   -576,   -576,     72,     -9,     72,     72,     72,     72,     -9,   -576,     72,     72,     -9, &
                    -9,    -90,    639,     -9,    558,    -90,     72,    720,     -9,     72,     72,     72,     72,     -9, &
                   -90,    720,    720,    720,    720,    -90,     72,    720,     -9,    639,    -90,    558,   4608,   -576, &
                  -576,     72,     72,    720,   -576,     72,     72,     -9,     -9,    -90,     72,     -9,    720,    -90, &
                   639,    558,     -9,    -90,    -90,    558,    558,   -252]
  K1( 698,:) = [    -90,     -9,     -9,     72,     72,   -576,    558,    -90,   -252,    558,     -9,    -90,    -90,    720, &
                   558,    639,     72,     -9,   -576,   4608,     72,    720,   -576,     72,    720,     72,     72,   -576, &
                  -576,   4608,     72,   -576,   -576,   -576,   -576,     72,   -576,   4608,   4608,   4608,   4608,   -576, &
                  -576,   4608,     72,    720,   -576,     72,    639,     -9,    558,    -90,     72,    720,     -9,     72, &
                    72,     72,     72,     -9,    -90,    720,    720,    720,    720,    -90,     72,    720,     -9,    639, &
                   -90,    558,     -9,     72,    -90,     -9,   -576,     72,     72,   -576,   -576,   -576,   -576,     72, &
                    -9,     72,     72,     72,     72,     -9,   -576,     72,     72,     -9,     -9,    -90,   -576,   4608, &
                    72,    720,   -576,     72,     72,   -576,     -9,    -90,     72,     -9,     -9,    -90,    -90,    558, &
                   558,   -252,     72,     -9,    720,    -90,    639,    558]
  K1( 699,:) = [    -90,    720,    558,    639,     72,     -9,     -9,     72,    -90,     -9,   -576,     72,   -252,    558, &
                   558,    -90,    -90,     -9,   -576,     72,   4608,   -576,    720,     72,     -9,     72,    -90,     -9, &
                  -576,     72,     72,   -576,   -576,   -576,   -576,     72,     -9,     72,     72,     72,     72,     -9, &
                  -576,     72,     72,     -9,     -9,    -90,     72,   -576,    720,     72,   4608,   -576,   -576,   4608, &
                  4608,   4608,   4608,   -576,     72,   -576,   -576,   -576,   -576,     72,   4608,   -576,   -576,     72, &
                    72,    720,    558,    -90,    639,     -9,    720,     72,    -90,    720,    720,    720,    720,    -90, &
                    -9,     72,     72,     72,     72,     -9,    720,     72,    -90,    558,     -9,    639,   -576,     72, &
                  4608,   -576,    720,     72,     72,     -9,    720,    -90,    639,    558,   -576,     72,     72,     -9, &
                    -9,    -90,    -90,     -9,    558,   -252,    -90,    558]
  K1( 700,:) = [    558,    -90,   -252,    558,     -9,    -90,    -90,     -9,     -9,     72,     72,   -576,    558,    639, &
                   -90,    720,     -9,     72,     72,    720,   -576,   4608,     72,   -576,    639,     -9,    558,    -90, &
                    72,    720,     -9,     72,     72,     72,     72,     -9,    -90,    720,    720,    720,    720,    -90, &
                    72,    720,     -9,    639,    -90,    558,    720,     72,     72,   -576,   -576,   4608,     72,   -576, &
                  -576,   -576,   -576,     72,   -576,   4608,   4608,   4608,   4608,   -576,   -576,   4608,     72,    720, &
                  -576,     72,    -90,     -9,     -9,     72,     72,   -576,     -9,     72,     72,     72,     72,     -9, &
                    72,   -576,   -576,   -576,   -576,     72,     72,   -576,     -9,    -90,     72,     -9,     72,    720, &
                  -576,   4608,     72,   -576,     -9,    -90,    -90,    558,    558,   -252,     72,   -576,     -9,    -90, &
                    72,     -9,     -9,     72,    639,    558,    720,    -90]
  K1( 701,:) = [    558,    639,    -90,    720,     -9,     72,   -252,    558,    558,    -90,    -90,     -9,     -9,     72, &
                   -90,     -9,   -576,     72,     72,   -576,    720,     72,   4608,   -576,    -90,     -9,     -9,     72, &
                    72,   -576,     -9,     72,     72,     72,     72,     -9,     72,   -576,   -576,   -576,   -576,     72, &
                    72,   -576,     -9,    -90,     72,     -9,    558,    -90,    639,     -9,    720,     72,    -90,    720, &
                   720,    720,    720,    -90,     -9,     72,     72,     72,     72,     -9,    720,     72,    -90,    558, &
                    -9,    639,     72,   -576,    720,     72,   4608,   -576,   -576,   4608,   4608,   4608,   4608,   -576, &
                    72,   -576,   -576,   -576,   -576,     72,   4608,   -576,   -576,     72,     72,    720,     72,   -576, &
                   720,     72,   4608,   -576,     -9,     72,    639,    558,    720,    -90,    -90,     -9,    558,   -252, &
                   -90,    558,   -576,     72,     72,     -9,     -9,    -90]
  K1( 702,:) = [   -252,    558,    558,    -90,    -90,     -9,    558,    639,    -90,    720,     -9,     72,    -90,     -9, &
                    -9,     72,     72,   -576,    720,     72,     72,   -576,   -576,   4608,    558,    -90,    639,     -9, &
                   720,     72,    -90,    720,    720,    720,    720,    -90,     -9,     72,     72,     72,     72,     -9, &
                   720,     72,    -90,    558,     -9,    639,    -90,     -9,     -9,     72,     72,   -576,     -9,     72, &
                    72,     72,     72,     -9,     72,   -576,   -576,   -576,   -576,     72,     72,   -576,     -9,    -90, &
                    72,     -9,    720,     72,     72,   -576,   -576,   4608,     72,   -576,   -576,   -576,   -576,     72, &
                  -576,   4608,   4608,   4608,   4608,   -576,   -576,   4608,     72,    720,   -576,     72,    720,     72, &
                    72,   -576,   -576,   4608,    -90,     -9,    558,   -252,    -90,    558,     -9,     72,    639,    558, &
                   720,    -90,     72,   -576,     -9,    -90,     72,     -9]
  K1( 703,:) = [    -90,    720,   -900,    -90,  -5760,    720,    558,  -4464,  -4626,  -4545,  -5112,    639,    477,    558, &
                   396,   1206,    639,   -171,   -576,     72,     72,     -9,     -9,    -90,     72,   -576,    720,     72, &
                  4608,   -576,    153,  -1224,   -495,   -657,     72,     -9,   -657,    153,    882,   -738,     -9,    639, &
                 -5760,    720,    720,    -90,    -90,   -900,     72,   -576,    720,     72,   4608,   -576,   -495,   3960, &
                  -414,    153,   -576,     72,  -1224,   3960,   4041,  -1224,  -1143,   3960,  -1224,    153,   4608,   -576, &
                   234,   -495,     -9,     72,    -90,     -9,   -576,     72,   -576,   -495,   -495,     72,     72,   -738, &
                  -576,  -1224,   -414,   -576,    234,  -1224,    153,   -657,   -576,   -657,   -576,    153,   -576,     72, &
                    72,     -9,     -9,    -90,   -576,     72,     72,     -9,     -9,    -90,   -576,     72,   -576,     72, &
                  -576,   -576,     72,     -9,     72,     -9,     72,     72]
  K1( 704,:) = [   -900,    -90,    -90,    720,    720,  -5760,    477,    558,    396,   1206,    639,   -171,    558,  -4464, &
                 -4626,  -4545,  -5112,    639,     72,   -576,     -9,    -90,     72,     -9,    720,     72,     72,   -576, &
                  -576,   4608,   -657,    153,    882,   -738,     -9,    639,    153,  -1224,   -495,   -657,     72,     -9, &
                   720,  -5760,    -90,   -900,    720,    -90,     -9,     72,    -90,     -9,   -576,     72,   -576,   -495, &
                  -495,     72,     72,   -738,   -576,  -1224,   -414,   -576,    234,  -1224,    153,   -657,   -576,   -657, &
                  -576,    153,     72,   -576,    720,     72,   4608,   -576,   -495,   3960,   -414,    153,   -576,     72, &
                 -1224,   3960,   4041,  -1224,  -1143,   3960,  -1224,    153,   4608,   -576,    234,   -495,     72,   -576, &
                    -9,    -90,     72,     -9,     72,   -576,     -9,    -90,     72,     -9,     72,     -9,     72,     -9, &
                    72,     72,   -576,     72,   -576,     72,   -576,   -576]
  K1( 705,:) = [    558,  -4464,    477,   -171,    720,    -90,   -252,   2016,    396,   1206,  -4464,    558,  -3978,   1206, &
                  1044,  -3978,  -4545,   1206,     72,     -9,    720,    -90,    639,    558,     -9,     72,    -90,     -9, &
                  -576,     72,   -576,   4608,   -495,    639,  -4464,    558,   -576,    234,   -414,     -9,   -657,     72, &
                   720,    -90,    720,    -90,    720,    720,     72,   -576,    720,     72,   4608,   -576,     72,   -576, &
                   882,    558,   2016,   -252,    234,  -1143,   -495,    -90,    153,     -9,     72,     -9,  -4464,    558, &
                  -657,    -90,     72,   -576,    720,     72,   4608,   -576,   -495,   -414,   4041,     72,    882,   -576, &
                  -414,   4041,   -414,    720,   -495,     72,   -495,    882,   -495,   4608,   -414,   -576,     72,     -9, &
                   720,    -90,    639,    558,     72,     -9,     72,     -9,     72,     72,   -576,     72,    720,    -90, &
                   153,     -9,   -576,     72,    153,   -576,   -495,     72]
  K1( 706,:) = [  -4626,    558,    396,    477,    -90,   -900,    396,   -252,   1044,  -3978,    558,    477,   1044,    396, &
                 -1224,   1044,  -4626,    396,     -9,    -90,    -90,    558,    558,   -252,    639,     -9,    558,    -90, &
                    72,    720,   -657,   -576,   4608,  -4626,    558,    558,    153,   -495,   -576,    396,    -90,    477, &
                   -90,   -900,    -90,    -90,    720,   -900,     -9,     72,    -90,     -9,   -576,     72,   -738,     72, &
                  -576,    396,   -252,   -252,  -1224,   3960,     72,   1044,     -9,  -3978,     -9,    639,    558,    558, &
                    72,    477,     72,   -576,    720,     72,   4608,   -576,     72,    153,     72,   1044,    558,    396, &
                  -576,  -1224,    720,  -1224,    -90,   1044,   -657,   -738,    639,  -4626,     -9,    396,     -9,    -90, &
                   -90,    558,    558,   -252,     -9,    -90,     -9,     -9,     72,    -90,     72,     -9,    -90,    -90, &
                  -576,    558,   -576,     72,     -9,    558,     72,   -252]
  K1( 707,:) = [    477,   -171,    558,  -4464,    -90,    720,  -3978,   1206,   1044,  -3978,  -4545,   1206,   -252,   2016, &
                   396,   1206,  -4464,    558,     -9,     72,    639,    558,    720,    -90,    -90,     -9,     -9,     72, &
                    72,   -576,   -576,    234,   -414,     -9,   -657,     72,   -576,   4608,   -495,    639,  -4464,    558, &
                   -90,    720,    720,    720,    720,    -90,     72,   -576,    720,     72,   4608,   -576,   -495,   -414, &
                  4041,     72,    882,   -576,   -414,   4041,   -414,    720,   -495,     72,   -495,    882,   -495,   4608, &
                  -414,   -576,     72,   -576,    720,     72,   4608,   -576,     72,   -576,    882,    558,   2016,   -252, &
                   234,  -1143,   -495,    -90,    153,     -9,     72,     -9,  -4464,    558,   -657,    -90,     -9,     72, &
                   639,    558,    720,    -90,     -9,     72,     72,     72,     72,     -9,   -576,     72,    153,   -576, &
                  -495,     72,   -576,     72,    720,    -90,    153,     -9]
  K1( 708,:) = [    396,    477,  -4626,    558,   -900,    -90,   1044,    396,  -1224,   1044,  -4626,    396,    396,   -252, &
                  1044,  -3978,    558,    477,    -90,     -9,    558,   -252,    -90,    558,    558,    -90,    639,     -9, &
                   720,     72,    153,   -495,   -576,    396,    -90,    477,   -657,   -576,   4608,  -4626,    558,    558, &
                  -900,    -90,    720,   -900,    -90,    -90,     72,   -576,    720,     72,   4608,   -576,     72,    153, &
                    72,   1044,    558,    396,   -576,  -1224,    720,  -1224,    -90,   1044,   -657,   -738,    639,  -4626, &
                    -9,    396,     -9,     72,    -90,     -9,   -576,     72,   -738,     72,   -576,    396,   -252,   -252, &
                 -1224,   3960,     72,   1044,     -9,  -3978,     -9,    639,    558,    558,     72,    477,    -90,     -9, &
                   558,   -252,    -90,    558,    -90,     -9,     72,    -90,     -9,     -9,   -576,     72,     -9,    558, &
                    72,   -252,     72,     -9,    -90,    -90,   -576,    558]
  K1( 709,:) = [    558,  -4464,  -4626,  -4545,  -5112,    639,    -90,    720,   -900,    -90,  -5760,    720,    396,   1206, &
                   477,    558,   -171,    639,     72,     -9,   -576,     72,    -90,     -9,     72,   -576,    720,     72, &
                  4608,   -576,   -495,   3960,   -414,    153,   -576,     72,  -1224,   3960,   4041,  -1224,  -1143,   3960, &
                 -1224,    153,   4608,   -576,    234,   -495,     72,   -576,    720,     72,   4608,   -576,    153,  -1224, &
                  -495,   -657,     72,     -9,   -657,    153,    882,   -738,     -9,    639,  -5760,    720,    720,    -90, &
                   -90,   -900,    -90,     -9,     -9,     72,     72,   -576,   -576,  -1224,   -414,   -576,    234,  -1224, &
                  -576,   -495,   -495,     72,     72,   -738,   -657,    153,   -576,    153,   -576,   -657,     72,     -9, &
                  -576,     72,    -90,     -9,   -576,     72,   -576,     72,   -576,   -576,   -576,     72,     72,     -9, &
                    -9,    -90,     -9,     72,     72,     72,     72,     -9]
  K1( 710,:) = [    477,    558,    396,   1206,    639,   -171,   -900,    -90,    -90,    720,    720,  -5760,  -4626,  -4545, &
                   558,  -4464,    639,  -5112,     -9,    -90,     72,   -576,     -9,     72,     -9,     72,    -90,     -9, &
                  -576,     72,   -576,   -495,   -495,     72,     72,   -738,   -576,  -1224,   -414,   -576,    234,  -1224, &
                   153,   -657,   -576,   -657,   -576,    153,    720,     72,     72,   -576,   -576,   4608,   -657,    153, &
                   882,   -738,     -9,    639,    153,  -1224,   -495,   -657,     72,     -9,    720,  -5760,    -90,   -900, &
                   720,    -90,    720,     72,     72,   -576,   -576,   4608,  -1224,   3960,   4041,  -1224,  -1143,   3960, &
                  -495,   3960,   -414,    153,   -576,     72,    153,  -1224,    234,   -495,   4608,   -576,     -9,    -90, &
                    72,   -576,     -9,     72,     72,     -9,     72,     -9,     72,     72,     72,   -576,     -9,    -90, &
                    72,     -9,     72,   -576,   -576,   -576,   -576,     72]
  K1( 711,:) = [   -252,   2016,    396,   1206,  -4464,    558,    558,  -4464,    477,   -171,    720,    -90,   1044,  -3978, &
                 -3978,   1206,   1206,  -4545,    720,    -90,     72,     -9,    558,    639,     72,   -576,    720,     72, &
                  4608,   -576,     72,   -576,    882,    558,   2016,   -252,    234,  -1143,   -495,    -90,    153,     -9, &
                    72,     -9,  -4464,    558,   -657,    -90,     -9,     72,    -90,     -9,   -576,     72,   -576,   4608, &
                  -495,    639,  -4464,    558,   -576,    234,   -414,     -9,   -657,     72,    720,    -90,    720,    -90, &
                   720,    720,    720,     72,     72,   -576,   -576,   4608,   -414,   4041,   -414,    720,   -495,     72, &
                  -495,   -414,   4041,     72,    882,   -576,    882,   -495,   -414,   -576,   -495,   4608,    720,    -90, &
                    72,     -9,    558,    639,   -576,     72,    720,    -90,    153,     -9,     72,     -9,     72,     -9, &
                    72,     72,     72,   -576,   -495,     72,    153,   -576]
  K1( 712,:) = [    396,   -252,   1044,  -3978,    558,    477,  -4626,    558,    396,    477,    -90,   -900,  -1224,   1044, &
                  1044,    396,    396,  -4626,    -90,    558,     -9,    -90,   -252,    558,     -9,     72,    -90,     -9, &
                  -576,     72,   -738,     72,   -576,    396,   -252,   -252,  -1224,   3960,     72,   1044,     -9,  -3978, &
                    -9,    639,    558,    558,     72,    477,    639,     -9,    558,    -90,     72,    720,   -657,   -576, &
                  4608,  -4626,    558,    558,    153,   -495,   -576,    396,    -90,    477,    -90,   -900,    -90,    -90, &
                   720,   -900,    720,     72,     72,   -576,   -576,   4608,   -576,  -1224,    720,  -1224,    -90,   1044, &
                    72,    153,     72,   1044,    558,    396,   -738,   -657,     -9,    396,    639,  -4626,    -90,    558, &
                    -9,    -90,   -252,    558,     72,     -9,    -90,    -90,   -576,    558,     -9,    -90,     -9,     -9, &
                    72,    -90,     72,   -576,     72,   -252,     -9,    558]
  K1( 713,:) = [  -3978,   1206,   1044,  -3978,  -4545,   1206,    477,   -171,    558,  -4464,    -90,    720,    396,   1206, &
                  -252,   2016,    558,  -4464,    639,    558,     -9,     72,    -90,    720,     72,   -576,    720,     72, &
                  4608,   -576,   -495,   -414,   4041,     72,    882,   -576,   -414,   4041,   -414,    720,   -495,     72, &
                  -495,    882,   -495,   4608,   -414,   -576,    -90,     -9,     -9,     72,     72,   -576,   -576,    234, &
                  -414,     -9,   -657,     72,   -576,   4608,   -495,    639,  -4464,    558,    -90,    720,    720,    720, &
                   720,    -90,    720,     72,     72,   -576,   -576,   4608,    234,  -1143,   -495,    -90,    153,     -9, &
                    72,   -576,    882,    558,   2016,   -252,     -9,     72,   -657,    -90,  -4464,    558,    639,    558, &
                    -9,     72,    -90,    720,   -576,     72,    153,   -576,   -495,     72,     -9,     72,     72,     72, &
                    72,     -9,     72,   -576,    153,     -9,    720,    -90]
  K1( 714,:) = [   1044,    396,  -1224,   1044,  -4626,    396,    396,    477,  -4626,    558,   -900,    -90,   1044,  -3978, &
                   396,   -252,    477,    558,    558,   -252,    -90,     -9,    558,    -90,     72,   -576,    720,     72, &
                  4608,   -576,     72,    153,     72,   1044,    558,    396,   -576,  -1224,    720,  -1224,    -90,   1044, &
                  -657,   -738,    639,  -4626,     -9,    396,    558,    -90,    639,     -9,    720,     72,    153,   -495, &
                  -576,    396,    -90,    477,   -657,   -576,   4608,  -4626,    558,    558,   -900,    -90,    720,   -900, &
                   -90,    -90,    -90,     -9,     -9,     72,     72,   -576,  -1224,   3960,     72,   1044,     -9,  -3978, &
                  -738,     72,   -576,    396,   -252,   -252,    639,     -9,     72,    477,    558,    558,    558,   -252, &
                   -90,     -9,    558,    -90,   -576,     72,     -9,    558,     72,   -252,    -90,     -9,     72,    -90, &
                    -9,     -9,     -9,     72,   -576,    558,    -90,    -90]
  K1( 715,:) = [  -4626,  -4545,    558,  -4464,    639,  -5112,    396,   1206,    477,    558,   -171,    639,    -90,    720, &
                  -900,    -90,  -5760,    720,     -9,     72,    -90,     -9,   -576,     72,    720,     72,     72,   -576, &
                  -576,   4608,  -1224,   3960,   4041,  -1224,  -1143,   3960,   -495,   3960,   -414,    153,   -576,     72, &
                   153,  -1224,    234,   -495,   4608,   -576,    -90,     -9,     -9,     72,     72,   -576,   -576,  -1224, &
                  -414,   -576,    234,  -1224,   -576,   -495,   -495,     72,     72,   -738,   -657,    153,   -576,    153, &
                  -576,   -657,     72,   -576,    720,     72,   4608,   -576,    153,  -1224,   -495,   -657,     72,     -9, &
                  -657,    153,    882,   -738,     -9,    639,  -5760,    720,    720,    -90,    -90,   -900,     -9,     72, &
                   -90,     -9,   -576,     72,     72,   -576,   -576,   -576,   -576,     72,     -9,     72,     72,     72, &
                    72,     -9,   -576,     72,     72,     -9,     -9,    -90]
  K1( 716,:) = [    396,   1206,    477,    558,   -171,    639,  -4626,  -4545,    558,  -4464,    639,  -5112,   -900,    -90, &
                   -90,    720,    720,  -5760,    -90,     -9,     -9,     72,     72,   -576,    -90,     -9,     -9,     72, &
                    72,   -576,   -576,  -1224,   -414,   -576,    234,  -1224,   -576,   -495,   -495,     72,     72,   -738, &
                  -657,    153,   -576,    153,   -576,   -657,    720,     72,     72,   -576,   -576,   4608,  -1224,   3960, &
                  4041,  -1224,  -1143,   3960,   -495,   3960,   -414,    153,   -576,     72,    153,  -1224,    234,   -495, &
                  4608,   -576,    720,     72,     72,   -576,   -576,   4608,   -657,    153,    882,   -738,     -9,    639, &
                   153,  -1224,   -495,   -657,     72,     -9,    720,  -5760,    -90,   -900,    720,    -90,    -90,     -9, &
                    -9,     72,     72,   -576,     -9,     72,     72,     72,     72,     -9,     72,   -576,   -576,   -576, &
                  -576,     72,     72,   -576,     -9,    -90,     72,     -9]
  K1( 717,:) = [    396,   1206,   -252,   2016,    558,  -4464,   1044,  -3978,  -3978,   1206,   1206,  -4545,    558,  -4464, &
                   477,   -171,    720,    -90,    -90,    720,    558,    639,     72,     -9,    720,     72,     72,   -576, &
                  -576,   4608,    234,  -1143,   -495,    -90,    153,     -9,     72,   -576,    882,    558,   2016,   -252, &
                    -9,     72,   -657,    -90,  -4464,    558,    720,     72,     72,   -576,   -576,   4608,   -414,   4041, &
                  -414,    720,   -495,     72,   -495,   -414,   4041,     72,    882,   -576,    882,   -495,   -414,   -576, &
                  -495,   4608,     -9,     72,    -90,     -9,   -576,     72,   -576,   4608,   -495,    639,  -4464,    558, &
                  -576,    234,   -414,     -9,   -657,     72,    720,    -90,    720,    -90,    720,    720,    -90,    720, &
                   558,    639,     72,     -9,     72,   -576,    153,     -9,    720,    -90,     72,   -576,   -495,     72, &
                   153,   -576,     72,     -9,     72,     -9,     72,     72]
  K1( 718,:) = [   1044,  -3978,    396,   -252,    477,    558,  -1224,   1044,   1044,    396,    396,  -4626,  -4626,    558, &
                   396,    477,    -90,   -900,    558,    -90,   -252,    558,     -9,    -90,    -90,     -9,     -9,     72, &
                    72,   -576,  -1224,   3960,     72,   1044,     -9,  -3978,   -738,     72,   -576,    396,   -252,   -252, &
                   639,     -9,     72,    477,    558,    558,    720,     72,     72,   -576,   -576,   4608,   -576,  -1224, &
                   720,  -1224,    -90,   1044,     72,    153,     72,   1044,    558,    396,   -738,   -657,     -9,    396, &
                   639,  -4626,    639,     -9,    558,    -90,     72,    720,   -657,   -576,   4608,  -4626,    558,    558, &
                   153,   -495,   -576,    396,    -90,    477,    -90,   -900,    -90,    -90,    720,   -900,    558,    -90, &
                  -252,    558,     -9,    -90,     -9,     72,   -576,    558,    -90,    -90,     72,   -576,     72,   -252, &
                    -9,    558,     -9,    -90,     -9,     -9,     72,    -90]
  K1( 719,:) = [   1044,  -3978,  -3978,   1206,   1206,  -4545,    396,   1206,   -252,   2016,    558,  -4464,    477,   -171, &
                   558,  -4464,    -90,    720,    558,    639,    -90,    720,     -9,     72,    720,     72,     72,   -576, &
                  -576,   4608,   -414,   4041,   -414,    720,   -495,     72,   -495,   -414,   4041,     72,    882,   -576, &
                   882,   -495,   -414,   -576,   -495,   4608,    720,     72,     72,   -576,   -576,   4608,    234,  -1143, &
                  -495,    -90,    153,     -9,     72,   -576,    882,    558,   2016,   -252,     -9,     72,   -657,    -90, &
                 -4464,    558,    -90,     -9,     -9,     72,     72,   -576,   -576,    234,   -414,     -9,   -657,     72, &
                  -576,   4608,   -495,    639,  -4464,    558,    -90,    720,    720,    720,    720,    -90,    558,    639, &
                   -90,    720,     -9,     72,     72,   -576,   -495,     72,    153,   -576,     72,   -576,    153,     -9, &
                   720,    -90,     -9,     72,     72,     72,     72,     -9]
  K1( 720,:) = [  -1224,   1044,   1044,    396,    396,  -4626,   1044,  -3978,    396,   -252,    477,    558,    396,    477, &
                 -4626,    558,   -900,    -90,   -252,    558,    558,    -90,    -90,     -9,    720,     72,     72,   -576, &
                  -576,   4608,   -576,  -1224,    720,  -1224,    -90,   1044,     72,    153,     72,   1044,    558,    396, &
                  -738,   -657,     -9,    396,    639,  -4626,    -90,     -9,     -9,     72,     72,   -576,  -1224,   3960, &
                    72,   1044,     -9,  -3978,   -738,     72,   -576,    396,   -252,   -252,    639,     -9,     72,    477, &
                   558,    558,    558,    -90,    639,     -9,    720,     72,    153,   -495,   -576,    396,    -90,    477, &
                  -657,   -576,   4608,  -4626,    558,    558,   -900,    -90,    720,   -900,    -90,    -90,   -252,    558, &
                   558,    -90,    -90,     -9,     72,   -576,     72,   -252,     -9,    558,     -9,     72,   -576,    558, &
                   -90,    -90,    -90,     -9,     72,    -90,     -9,     -9]
  K1( 721,:) = [  73728,  -9216,  -9216,   1152,   1152,  11520,  -9216,   1152,   1152,   -144,   -144,  -1440,   1152,   -144, &
                 11520,  -1440,  10224,   8928,   -144,  -1440,  -1440,   8928,   8928,  -4032,  -9216,   1152,   1152,   -144, &
                  -144,  -1440,   1152,   -144,   -144,     18,     18,    180,   -144,     18,  -1440,    180,  -1278,  -1116, &
                    18,    180,    180,  -1116,  -1116,    504,   1152,   -144,   -144,     18,     18,    180,  11520,  -1440, &
                 -1440,    180,    180,   1800,  10224,  -1278,   8928,  -1116,   9090,   9252,  -1278,    342,  -1116,   -954, &
                 -2412,   -792,   -144,     18,  -1440,    180,  -1278,  -1116,  -1440,    180,   8928,  -1116,    342,   -954, &
                  8928,  -1116,  -4032,    504,  -2412,   -792,   9090,  -2412,  -2412,   7956,   7956,  -2088,     18,    180, &
                   180,  -1116,  -1116,    504,    180,   1800,  -1116,   9252,   -954,   -792,  -1116,   -954,    504,   -792, &
                  7956,  -2088,   9252,   -792,   -792,  -2088,  -2088,   2448]
  K1( 722,:) = [  -9216,  73728,   1152,  11520,  -9216,   1152,   1152,  -9216,   -144,  -1440,   1152,   -144,   -144,  -1440, &
                 -1440,   8928,   8928,  -4032,   1152,   -144,  11520,  -1440,  10224,   8928,   1152,  -9216,   -144,  -1440, &
                  1152,   -144,   -144,   1152,     18,    180,   -144,     18,     18,    180,    180,  -1116,  -1116,    504, &
                  -144,     18,  -1440,    180,  -1278,  -1116,   -144,   1152,     18,    180,   -144,     18,  -1440,  11520, &
                   180,   1800,  -1440,    180,  -1278,    342,  -1116,   -954,  -2412,   -792,  10224,  -1278,   8928,  -1116, &
                  9090,   9252,     18,    180,    180,  -1116,  -1116,    504,    180,   1800,  -1116,   9252,   -954,   -792, &
                 -1116,   -954,    504,   -792,   7956,  -2088,   9252,   -792,   -792,  -2088,  -2088,   2448,   -144,     18, &
                 -1440,    180,  -1278,  -1116,  -1440,    180,   8928,  -1116,    342,   -954,   8928,  -1116,  -4032,    504, &
                 -2412,   -792,   9090,  -2412,  -2412,   7956,   7956,  -2088]
  K1( 723,:) = [  -9216,   1152,  73728,  -9216,  11520,   1152,   1152,   -144,  11520,  -1440,  10224,   8928,  -9216,   1152, &
                  1152,   -144,   -144,  -1440,  -1440,   -144,   8928,  -4032,  -1440,   8928,   1152,   -144,  -9216,   1152, &
                 -1440,   -144,   -144,     18,  -1440,    180,  -1278,  -1116,   1152,   -144,   -144,     18,     18,    180, &
                   180,     18,  -1116,    504,    180,  -1116,   -144,     18,  -1440,    180,  -1278,  -1116,  -1440,    180, &
                  8928,  -1116,    342,   -954,   8928,  -1116,  -4032,    504,  -2412,   -792,   9090,  -2412,  -2412,   7956, &
                  7956,  -2088,   1152,   -144,   -144,     18,     18,    180,  11520,  -1440,  -1440,    180,    180,   1800, &
                 10224,  -1278,   8928,  -1116,   9090,   9252,  -1278,    342,  -1116,   -954,  -2412,   -792,    180,     18, &
                 -1116,    504,    180,  -1116,   1800,    180,   -954,   -792,  -1116,   9252,   9252,   -792,   -792,  -2088, &
                 -2088,   2448,  -1116,   -954,    504,   -792,   7956,  -2088]
  K1( 724,:) = [   1152,  11520,  -9216,  73728,   1152,  -9216,   -144,  -1440,  -1440,   8928,   8928,  -4032,   1152,  -9216, &
                  -144,  -1440,   1152,   -144,   -144,   1152,  10224,   8928,  11520,  -1440,   -144,  -1440,   1152,  -9216, &
                  -144,   1152,     18,    180,    180,  -1116,  -1116,    504,   -144,   1152,     18,    180,   -144,     18, &
                    18,   -144,  -1278,  -1116,  -1440,    180,     18,    180,    180,  -1116,  -1116,    504,    180,   1800, &
                 -1116,   9252,   -954,   -792,  -1116,   -954,    504,   -792,   7956,  -2088,   9252,   -792,   -792,  -2088, &
                 -2088,   2448,   -144,   1152,     18,    180,   -144,     18,  -1440,  11520,    180,   1800,  -1440,    180, &
                 -1278,    342,  -1116,   -954,  -2412,   -792,  10224,  -1278,   8928,  -1116,   9090,   9252,     18,   -144, &
                 -1278,  -1116,  -1440,    180,    180,  -1440,    342,   -954,   8928,  -1116,   9090,  -2412,  -2412,   7956, &
                  7956,  -2088,   8928,  -1116,  -4032,    504,  -2412,   -792]
  K1( 725,:) = [   1152,  -9216,  11520,   1152,  73728,  -9216,   -144,   1152,  10224,   8928,  11520,  -1440,  -1440,   -144, &
                  8928,  -4032,  -1440,   8928,  -9216,   1152,   1152,   -144,   -144,  -1440,   -144,   1152,  -1440,   -144, &
                 -9216,   1152,     18,   -144,  -1278,  -1116,  -1440,    180,    180,     18,  -1116,    504,    180,  -1116, &
                  1152,   -144,   -144,     18,     18,    180,     18,   -144,  -1278,  -1116,  -1440,    180,    180,  -1440, &
                   342,   -954,   8928,  -1116,   9090,  -2412,  -2412,   7956,   7956,  -2088,   8928,  -1116,  -4032,    504, &
                 -2412,   -792,    180,     18,  -1116,    504,    180,  -1116,   1800,    180,   -954,   -792,  -1116,   9252, &
                  9252,   -792,   -792,  -2088,  -2088,   2448,  -1116,   -954,    504,   -792,   7956,  -2088,   1152,   -144, &
                  -144,     18,     18,    180,  11520,  -1440,  -1440,    180,    180,   1800,  10224,  -1278,   8928,  -1116, &
                  9090,   9252,  -1278,    342,  -1116,   -954,  -2412,   -792]
  K1( 726,:) = [  11520,   1152,   1152,  -9216,  -9216,  73728,  -1440,   -144,   8928,  -4032,  -1440,   8928,   -144,   1152, &
                 10224,   8928,  11520,  -1440,   1152,  -9216,   -144,  -1440,   1152,   -144,  -1440,   -144,   -144,   1152, &
                  1152,  -9216,    180,     18,  -1116,    504,    180,  -1116,     18,   -144,  -1278,  -1116,  -1440,    180, &
                  -144,   1152,     18,    180,   -144,     18,    180,     18,  -1116,    504,    180,  -1116,   1800,    180, &
                  -954,   -792,  -1116,   9252,   9252,   -792,   -792,  -2088,  -2088,   2448,  -1116,   -954,    504,   -792, &
                  7956,  -2088,     18,   -144,  -1278,  -1116,  -1440,    180,    180,  -1440,    342,   -954,   8928,  -1116, &
                  9090,  -2412,  -2412,   7956,   7956,  -2088,   8928,  -1116,  -4032,    504,  -2412,   -792,   -144,   1152, &
                    18,    180,   -144,     18,  -1440,  11520,    180,   1800,  -1440,    180,  -1278,    342,  -1116,   -954, &
                 -2412,   -792,  10224,  -1278,   8928,  -1116,   9090,   9252]
  K1( 727,:) = [  -9216,   1152,   1152,   -144,   -144,  -1440,  73728,  -9216,  -9216,   1152,   1152,  11520,  11520,  -1440, &
                  1152,   -144,   8928,  10224,  -1440,   8928,   -144,  -1440,  -4032,   8928,   1152,   -144,   -144,     18, &
                    18,    180,  11520,  -1440,  -1440,    180,    180,   1800,  10224,  -1278,   8928,  -1116,   9090,   9252, &
                 -1278,    342,  -1116,   -954,  -2412,   -792,  -9216,   1152,   1152,   -144,   -144,  -1440,   1152,   -144, &
                  -144,     18,     18,    180,   -144,     18,  -1440,    180,  -1278,  -1116,     18,    180,    180,  -1116, &
                 -1116,    504,  -1440,    180,   -144,     18,  -1116,  -1278,   8928,  -1116,  -4032,    504,  -2412,   -792, &
                 -1440,    180,   8928,  -1116,    342,   -954,  -2412,   9090,   7956,  -2088,  -2412,   7956,    180,  -1116, &
                    18,    180,    504,  -1116,  -1116,   -954,    504,   -792,   7956,  -2088,    180,   1800,  -1116,   9252, &
                  -954,   -792,   -792,   9252,  -2088,   2448,   -792,  -2088]
  K1( 728,:) = [   1152,  -9216,   -144,  -1440,   1152,   -144,  -9216,  73728,   1152,  11520,  -9216,   1152,  -1440,   8928, &
                  -144,  -1440,  -4032,   8928,  11520,  -1440,   1152,   -144,   8928,  10224,   -144,   1152,     18,    180, &
                  -144,     18,  -1440,  11520,    180,   1800,  -1440,    180,  -1278,    342,  -1116,   -954,  -2412,   -792, &
                 10224,  -1278,   8928,  -1116,   9090,   9252,   1152,  -9216,   -144,  -1440,   1152,   -144,   -144,   1152, &
                    18,    180,   -144,     18,     18,    180,    180,  -1116,  -1116,    504,   -144,     18,  -1440,    180, &
                 -1278,  -1116,    180,  -1116,     18,    180,    504,  -1116,  -1116,   -954,    504,   -792,   7956,  -2088, &
                   180,   1800,  -1116,   9252,   -954,   -792,   -792,   9252,  -2088,   2448,   -792,  -2088,  -1440,    180, &
                  -144,     18,  -1116,  -1278,   8928,  -1116,  -4032,    504,  -2412,   -792,  -1440,    180,   8928,  -1116, &
                   342,   -954,  -2412,   9090,   7956,  -2088,  -2412,   7956]
  K1( 729,:) = [   1152,   -144,  11520,  -1440,  10224,   8928,  -9216,   1152,  73728,  -9216,  11520,   1152,   1152,   -144, &
                 -9216,   1152,  -1440,   -144,   8928,  -4032,  -1440,   -144,   8928,  -1440,   -144,     18,  -1440,    180, &
                 -1278,  -1116,  -1440,    180,   8928,  -1116,    342,   -954,   8928,  -1116,  -4032,    504,  -2412,   -792, &
                  9090,  -2412,  -2412,   7956,   7956,  -2088,   1152,   -144,  -9216,   1152,  -1440,   -144,   -144,     18, &
                 -1440,    180,  -1278,  -1116,   1152,   -144,   -144,     18,     18,    180,    180,     18,  -1116,    504, &
                   180,  -1116,   -144,     18,   1152,   -144,    180,     18,  10224,  -1278,   8928,  -1116,   9090,   9252, &
                 11520,  -1440,  -1440,    180,    180,   1800,    342,  -1278,  -2412,   -792,  -1116,   -954,  -1116,    504, &
                   180,     18,  -1116,    180,   9252,   -792,   -792,  -2088,  -2088,   2448,   1800,    180,   -954,   -792, &
                 -1116,   9252,   -954,  -1116,   7956,  -2088,    504,   -792]
  K1( 730,:) = [   -144,  -1440,  -1440,   8928,   8928,  -4032,   1152,  11520,  -9216,  73728,   1152,  -9216,   -144,  -1440, &
                  1152,  -9216,   -144,   1152,  10224,   8928,   -144,   1152,  -1440,  11520,     18,    180,    180,  -1116, &
                 -1116,    504,    180,   1800,  -1116,   9252,   -954,   -792,  -1116,   -954,    504,   -792,   7956,  -2088, &
                  9252,   -792,   -792,  -2088,  -2088,   2448,   -144,  -1440,   1152,  -9216,   -144,   1152,     18,    180, &
                   180,  -1116,  -1116,    504,   -144,   1152,     18,    180,   -144,     18,     18,   -144,  -1278,  -1116, &
                 -1440,    180,     18,    180,   -144,   1152,     18,   -144,  -1278,    342,  -1116,   -954,  -2412,   -792, &
                 -1440,  11520,    180,   1800,  -1440,    180,  -1278,  10224,   9090,   9252,   8928,  -1116,  -1278,  -1116, &
                    18,   -144,    180,  -1440,   9090,  -2412,  -2412,   7956,   7956,  -2088,    180,  -1440,    342,   -954, &
                  8928,  -1116,  -1116,   8928,  -2412,   -792,  -4032,    504]
  K1( 731,:) = [   -144,   1152,  10224,   8928,  11520,  -1440,   1152,  -9216,  11520,   1152,  73728,  -9216,   8928,  -4032, &
                 -1440,   -144,   8928,  -1440,   1152,   -144,  -9216,   1152,  -1440,   -144,     18,   -144,  -1278,  -1116, &
                 -1440,    180,    180,  -1440,    342,   -954,   8928,  -1116,   9090,  -2412,  -2412,   7956,   7956,  -2088, &
                  8928,  -1116,  -4032,    504,  -2412,   -792,   -144,   1152,  -1440,   -144,  -9216,   1152,     18,   -144, &
                 -1278,  -1116,  -1440,    180,    180,     18,  -1116,    504,    180,  -1116,   1152,   -144,   -144,     18, &
                    18,    180,  -1116,    504,    180,     18,  -1116,    180,   9252,   -792,   -792,  -2088,  -2088,   2448, &
                  1800,    180,   -954,   -792,  -1116,   9252,   -954,  -1116,   7956,  -2088,    504,   -792,   -144,     18, &
                  1152,   -144,    180,     18,  10224,  -1278,   8928,  -1116,   9090,   9252,  11520,  -1440,  -1440,    180, &
                   180,   1800,    342,  -1278,  -2412,   -792,  -1116,   -954]
  K1( 732,:) = [  -1440,   -144,   8928,  -4032,  -1440,   8928,  11520,   1152,   1152,  -9216,  -9216,  73728,  10224,   8928, &
                  -144,   1152,  -1440,  11520,   -144,  -1440,   1152,  -9216,   -144,   1152,    180,     18,  -1116,    504, &
                   180,  -1116,   1800,    180,   -954,   -792,  -1116,   9252,   9252,   -792,   -792,  -2088,  -2088,   2448, &
                 -1116,   -954,    504,   -792,   7956,  -2088,  -1440,   -144,   -144,   1152,   1152,  -9216,    180,     18, &
                 -1116,    504,    180,  -1116,     18,   -144,  -1278,  -1116,  -1440,    180,   -144,   1152,     18,    180, &
                  -144,     18,  -1278,  -1116,     18,   -144,    180,  -1440,   9090,  -2412,  -2412,   7956,   7956,  -2088, &
                   180,  -1440,    342,   -954,   8928,  -1116,  -1116,   8928,  -2412,   -792,  -4032,    504,     18,    180, &
                  -144,   1152,     18,   -144,  -1278,    342,  -1116,   -954,  -2412,   -792,  -1440,  11520,    180,   1800, &
                 -1440,    180,  -1278,  10224,   9090,   9252,   8928,  -1116]
  K1( 733,:) = [   1152,   -144,  -9216,   1152,  -1440,   -144,  11520,  -1440,   1152,   -144,   8928,  10224,  73728,  -9216, &
                 -9216,   1152,   1152,  11520,   8928,  -1440,  -4032,   8928,   -144,  -1440,   -144,     18,   1152,   -144, &
                   180,     18,  10224,  -1278,   8928,  -1116,   9090,   9252,  11520,  -1440,  -1440,    180,    180,   1800, &
                   342,  -1278,  -2412,   -792,  -1116,   -954,  -1440,    180,   -144,     18,  -1116,  -1278,   8928,  -1116, &
                 -4032,    504,  -2412,   -792,  -1440,    180,   8928,  -1116,    342,   -954,  -2412,   9090,   7956,  -2088, &
                 -2412,   7956,  -9216,   1152,   1152,   -144,   -144,  -1440,   1152,   -144,   -144,     18,     18,    180, &
                  -144,     18,  -1440,    180,  -1278,  -1116,     18,    180,    180,  -1116,  -1116,    504,  -1116,    180, &
                   504,  -1116,     18,    180,   -954,  -1116,   7956,  -2088,    504,   -792,   -792,   9252,  -2088,   2448, &
                  -792,  -2088,    180,   1800,  -1116,   9252,   -954,   -792]
  K1( 734,:) = [   -144,  -1440,   1152,  -9216,   -144,   1152,  -1440,   8928,   -144,  -1440,  -4032,   8928,  -9216,  73728, &
                  1152,  11520,  -9216,   1152,  -1440,  11520,   8928,  10224,   1152,   -144,     18,    180,   -144,   1152, &
                    18,   -144,  -1278,    342,  -1116,   -954,  -2412,   -792,  -1440,  11520,    180,   1800,  -1440,    180, &
                 -1278,  10224,   9090,   9252,   8928,  -1116,    180,  -1116,     18,    180,    504,  -1116,  -1116,   -954, &
                   504,   -792,   7956,  -2088,    180,   1800,  -1116,   9252,   -954,   -792,   -792,   9252,  -2088,   2448, &
                  -792,  -2088,   1152,  -9216,   -144,  -1440,   1152,   -144,   -144,   1152,     18,    180,   -144,     18, &
                    18,    180,    180,  -1116,  -1116,    504,   -144,     18,  -1440,    180,  -1278,  -1116,    180,  -1440, &
                 -1116,  -1278,   -144,     18,  -1116,   8928,  -2412,   -792,  -4032,    504,  -2412,   9090,   7956,  -2088, &
                 -2412,   7956,  -1440,    180,   8928,  -1116,    342,   -954]
  K1( 735,:) = [  11520,  -1440,   1152,   -144,   8928,  10224,   1152,   -144,  -9216,   1152,  -1440,   -144,  -9216,   1152, &
                 73728,  -9216,  11520,   1152,  -4032,   8928,   8928,  -1440,  -1440,   -144,  -1440,    180,   -144,     18, &
                 -1116,  -1278,   8928,  -1116,  -4032,    504,  -2412,   -792,  -1440,    180,   8928,  -1116,    342,   -954, &
                 -2412,   9090,   7956,  -2088,  -2412,   7956,   -144,     18,   1152,   -144,    180,     18,  10224,  -1278, &
                  8928,  -1116,   9090,   9252,  11520,  -1440,  -1440,    180,    180,   1800,    342,  -1278,  -2412,   -792, &
                 -1116,   -954,   1152,   -144,  -9216,   1152,  -1440,   -144,   -144,     18,  -1440,    180,  -1278,  -1116, &
                  1152,   -144,   -144,     18,     18,    180,    180,     18,  -1116,    504,    180,  -1116,    504,  -1116, &
                 -1116,    180,    180,     18,   -792,   9252,  -2088,   2448,   -792,  -2088,   -954,  -1116,   7956,  -2088, &
                   504,   -792,   1800,    180,   -954,   -792,  -1116,   9252]
  K1( 736,:) = [  -1440,   8928,   -144,  -1440,  -4032,   8928,   -144,  -1440,   1152,  -9216,   -144,   1152,   1152,  11520, &
                 -9216,  73728,   1152,  -9216,   8928,  10224,  -1440,  11520,   -144,   1152,    180,  -1116,     18,    180, &
                   504,  -1116,  -1116,   -954,    504,   -792,   7956,  -2088,    180,   1800,  -1116,   9252,   -954,   -792, &
                  -792,   9252,  -2088,   2448,   -792,  -2088,     18,    180,   -144,   1152,     18,   -144,  -1278,    342, &
                 -1116,   -954,  -2412,   -792,  -1440,  11520,    180,   1800,  -1440,    180,  -1278,  10224,   9090,   9252, &
                  8928,  -1116,   -144,  -1440,   1152,  -9216,   -144,   1152,     18,    180,    180,  -1116,  -1116,    504, &
                  -144,   1152,     18,    180,   -144,     18,     18,   -144,  -1278,  -1116,  -1440,    180,  -1116,  -1278, &
                   180,  -1440,     18,   -144,  -2412,   9090,   7956,  -2088,  -2412,   7956,  -1116,   8928,  -2412,   -792, &
                 -4032,    504,    180,  -1440,    342,   -954,   8928,  -1116]
  K1( 737,:) = [  10224,   8928,   -144,   1152,  -1440,  11520,   8928,  -4032,  -1440,   -144,   8928,  -1440,   1152,  -9216, &
                 11520,   1152,  73728,  -9216,   -144,   1152,  -1440,   -144,  -9216,   1152,  -1278,  -1116,     18,   -144, &
                   180,  -1440,   9090,  -2412,  -2412,   7956,   7956,  -2088,    180,  -1440,    342,   -954,   8928,  -1116, &
                 -1116,   8928,  -2412,   -792,  -4032,    504,  -1116,    504,    180,     18,  -1116,    180,   9252,   -792, &
                  -792,  -2088,  -2088,   2448,   1800,    180,   -954,   -792,  -1116,   9252,   -954,  -1116,   7956,  -2088, &
                   504,   -792,   -144,   1152,  -1440,   -144,  -9216,   1152,     18,   -144,  -1278,  -1116,  -1440,    180, &
                   180,     18,  -1116,    504,    180,  -1116,   1152,   -144,   -144,     18,     18,    180,     18,   -144, &
                   180,     18,   1152,   -144,  -1278,  10224,   9090,   9252,   8928,  -1116,    342,  -1278,  -2412,   -792, &
                 -1116,   -954,  11520,  -1440,  -1440,    180,    180,   1800]
  K1( 738,:) = [   8928,  -4032,  -1440,   -144,   8928,  -1440,  10224,   8928,   -144,   1152,  -1440,  11520,  11520,   1152, &
                  1152,  -9216,  -9216,  73728,  -1440,   -144,   -144,   1152,   1152,  -9216,  -1116,    504,    180,     18, &
                 -1116,    180,   9252,   -792,   -792,  -2088,  -2088,   2448,   1800,    180,   -954,   -792,  -1116,   9252, &
                  -954,  -1116,   7956,  -2088,    504,   -792,  -1278,  -1116,     18,   -144,    180,  -1440,   9090,  -2412, &
                 -2412,   7956,   7956,  -2088,    180,  -1440,    342,   -954,   8928,  -1116,  -1116,   8928,  -2412,   -792, &
                 -4032,    504,  -1440,   -144,   -144,   1152,   1152,  -9216,    180,     18,  -1116,    504,    180,  -1116, &
                    18,   -144,  -1278,  -1116,  -1440,    180,   -144,   1152,     18,    180,   -144,     18,    180,     18, &
                    18,   -144,   -144,   1152,    342,  -1278,  -2412,   -792,  -1116,   -954,  -1278,  10224,   9090,   9252, &
                  8928,  -1116,  -1440,  11520,    180,   1800,  -1440,    180]
  K1( 739,:) = [   -144,   1152,  -1440,   -144,  -9216,   1152,  -1440,  11520,   8928,  10224,   1152,   -144,   8928,  -1440, &
                 -4032,   8928,   -144,  -1440,  73728,  -9216,  -9216,   1152,   1152,  11520,     18,   -144,    180,     18, &
                  1152,   -144,  -1278,  10224,   9090,   9252,   8928,  -1116,    342,  -1278,  -2412,   -792,  -1116,   -954, &
                 11520,  -1440,  -1440,    180,    180,   1800,    180,  -1440,  -1116,  -1278,   -144,     18,  -1116,   8928, &
                 -2412,   -792,  -4032,    504,  -2412,   9090,   7956,  -2088,  -2412,   7956,  -1440,    180,   8928,  -1116, &
                   342,   -954,  -1116,    180,    504,  -1116,     18,    180,   -954,  -1116,   7956,  -2088,    504,   -792, &
                  -792,   9252,  -2088,   2448,   -792,  -2088,    180,   1800,  -1116,   9252,   -954,   -792,  -9216,   1152, &
                  1152,   -144,   -144,  -1440,   1152,   -144,   -144,     18,     18,    180,   -144,     18,  -1440,    180, &
                 -1278,  -1116,     18,    180,    180,  -1116,  -1116,    504]
  K1( 740,:) = [  -1440,   -144,   -144,   1152,   1152,  -9216,   8928,  -1440,  -4032,   8928,   -144,  -1440,  -1440,  11520, &
                  8928,  10224,   1152,   -144,  -9216,  73728,   1152,  11520,  -9216,   1152,    180,     18,     18,   -144, &
                  -144,   1152,    342,  -1278,  -2412,   -792,  -1116,   -954,  -1278,  10224,   9090,   9252,   8928,  -1116, &
                 -1440,  11520,    180,   1800,  -1440,    180,  -1116,    180,    504,  -1116,     18,    180,   -954,  -1116, &
                  7956,  -2088,    504,   -792,   -792,   9252,  -2088,   2448,   -792,  -2088,    180,   1800,  -1116,   9252, &
                  -954,   -792,    180,  -1440,  -1116,  -1278,   -144,     18,  -1116,   8928,  -2412,   -792,  -4032,    504, &
                 -2412,   9090,   7956,  -2088,  -2412,   7956,  -1440,    180,   8928,  -1116,    342,   -954,   1152,  -9216, &
                  -144,  -1440,   1152,   -144,   -144,   1152,     18,    180,   -144,     18,     18,    180,    180,  -1116, &
                 -1116,    504,   -144,     18,  -1440,    180,  -1278,  -1116]
  K1( 741,:) = [  -1440,  11520,   8928,  10224,   1152,   -144,   -144,   1152,  -1440,   -144,  -9216,   1152,  -4032,   8928, &
                  8928,  -1440,  -1440,   -144,  -9216,   1152,  73728,  -9216,  11520,   1152,    180,  -1440,  -1116,  -1278, &
                  -144,     18,  -1116,   8928,  -2412,   -792,  -4032,    504,  -2412,   9090,   7956,  -2088,  -2412,   7956, &
                 -1440,    180,   8928,  -1116,    342,   -954,     18,   -144,    180,     18,   1152,   -144,  -1278,  10224, &
                  9090,   9252,   8928,  -1116,    342,  -1278,  -2412,   -792,  -1116,   -954,  11520,  -1440,  -1440,    180, &
                   180,   1800,    504,  -1116,  -1116,    180,    180,     18,   -792,   9252,  -2088,   2448,   -792,  -2088, &
                  -954,  -1116,   7956,  -2088,    504,   -792,   1800,    180,   -954,   -792,  -1116,   9252,   1152,   -144, &
                 -9216,   1152,  -1440,   -144,   -144,     18,  -1440,    180,  -1278,  -1116,   1152,   -144,   -144,     18, &
                    18,    180,    180,     18,  -1116,    504,    180,  -1116]
  K1( 742,:) = [   8928,  -1440,  -4032,   8928,   -144,  -1440,  -1440,   -144,   -144,   1152,   1152,  -9216,   8928,  10224, &
                 -1440,  11520,   -144,   1152,   1152,  11520,  -9216,  73728,   1152,  -9216,  -1116,    180,    504,  -1116, &
                    18,    180,   -954,  -1116,   7956,  -2088,    504,   -792,   -792,   9252,  -2088,   2448,   -792,  -2088, &
                   180,   1800,  -1116,   9252,   -954,   -792,    180,     18,     18,   -144,   -144,   1152,    342,  -1278, &
                 -2412,   -792,  -1116,   -954,  -1278,  10224,   9090,   9252,   8928,  -1116,  -1440,  11520,    180,   1800, &
                 -1440,    180,  -1116,  -1278,    180,  -1440,     18,   -144,  -2412,   9090,   7956,  -2088,  -2412,   7956, &
                 -1116,   8928,  -2412,   -792,  -4032,    504,    180,  -1440,    342,   -954,   8928,  -1116,   -144,  -1440, &
                  1152,  -9216,   -144,   1152,     18,    180,    180,  -1116,  -1116,    504,   -144,   1152,     18,    180, &
                  -144,     18,     18,   -144,  -1278,  -1116,  -1440,    180]
  K1( 743,:) = [   8928,  10224,  -1440,  11520,   -144,   1152,  -4032,   8928,   8928,  -1440,  -1440,   -144,   -144,   1152, &
                 -1440,   -144,  -9216,   1152,   1152,  -9216,  11520,   1152,  73728,  -9216,  -1116,  -1278,    180,  -1440, &
                    18,   -144,  -2412,   9090,   7956,  -2088,  -2412,   7956,  -1116,   8928,  -2412,   -792,  -4032,    504, &
                   180,  -1440,    342,   -954,   8928,  -1116,    504,  -1116,  -1116,    180,    180,     18,   -792,   9252, &
                 -2088,   2448,   -792,  -2088,   -954,  -1116,   7956,  -2088,    504,   -792,   1800,    180,   -954,   -792, &
                 -1116,   9252,     18,   -144,    180,     18,   1152,   -144,  -1278,  10224,   9090,   9252,   8928,  -1116, &
                   342,  -1278,  -2412,   -792,  -1116,   -954,  11520,  -1440,  -1440,    180,    180,   1800,   -144,   1152, &
                 -1440,   -144,  -9216,   1152,     18,   -144,  -1278,  -1116,  -1440,    180,    180,     18,  -1116,    504, &
                   180,  -1116,   1152,   -144,   -144,     18,     18,    180]
  K1( 744,:) = [  -4032,   8928,   8928,  -1440,  -1440,   -144,   8928,  10224,  -1440,  11520,   -144,   1152,  -1440,   -144, &
                  -144,   1152,   1152,  -9216,  11520,   1152,   1152,  -9216,  -9216,  73728,    504,  -1116,  -1116,    180, &
                   180,     18,   -792,   9252,  -2088,   2448,   -792,  -2088,   -954,  -1116,   7956,  -2088,    504,   -792, &
                  1800,    180,   -954,   -792,  -1116,   9252,  -1116,  -1278,    180,  -1440,     18,   -144,  -2412,   9090, &
                  7956,  -2088,  -2412,   7956,  -1116,   8928,  -2412,   -792,  -4032,    504,    180,  -1440,    342,   -954, &
                  8928,  -1116,    180,     18,     18,   -144,   -144,   1152,    342,  -1278,  -2412,   -792,  -1116,   -954, &
                 -1278,  10224,   9090,   9252,   8928,  -1116,  -1440,  11520,    180,   1800,  -1440,    180,  -1440,   -144, &
                  -144,   1152,   1152,  -9216,    180,     18,  -1116,    504,    180,  -1116,     18,   -144,  -1278,  -1116, &
                 -1440,    180,   -144,   1152,     18,    180,   -144,     18]
  K1( 745,:) = [  -9216,   1152,   1152,   -144,   -144,  -1440,   1152,   -144,   -144,     18,     18,    180,   -144,     18, &
                 -1440,    180,  -1278,  -1116,     18,    180,    180,  -1116,  -1116,    504,  73728,  -9216,  -9216,   1152, &
                  1152,  11520,  -9216,   1152,   1152,   -144,   -144,  -1440,   1152,   -144,  11520,  -1440,  10224,   8928, &
                  -144,  -1440,  -1440,   8928,   8928,  -4032,  11520,  -1440,  -1440,    180,    180,   1800,   1152,   -144, &
                  -144,     18,     18,    180,   8928,  -1116,  10224,  -1278,   9252,   9090,  -1116,   -954,  -1278,    342, &
                  -792,  -2412,  -1440,    180,   8928,  -1116,    342,   -954,   -144,     18,  -1440,    180,  -1278,  -1116, &
                 -4032,    504,   8928,  -1116,   -792,  -2412,  -2412,   7956,   9090,  -2412,  -2088,   7956,    180,   1800, &
                 -1116,   9252,   -954,   -792,     18,    180,    180,  -1116,  -1116,    504,    504,   -792,  -1116,   -954, &
                 -2088,   7956,   -792,  -2088,   9252,   -792,   2448,  -2088]
  K1( 746,:) = [   1152,  -9216,   -144,  -1440,   1152,   -144,   -144,   1152,     18,    180,   -144,     18,     18,    180, &
                   180,  -1116,  -1116,    504,   -144,     18,  -1440,    180,  -1278,  -1116,  -9216,  73728,   1152,  11520, &
                 -9216,   1152,   1152,  -9216,   -144,  -1440,   1152,   -144,   -144,  -1440,  -1440,   8928,   8928,  -4032, &
                  1152,   -144,  11520,  -1440,  10224,   8928,  -1440,  11520,    180,   1800,  -1440,    180,   -144,   1152, &
                    18,    180,   -144,     18,  -1116,   -954,  -1278,    342,   -792,  -2412,   8928,  -1116,  10224,  -1278, &
                  9252,   9090,    180,   1800,  -1116,   9252,   -954,   -792,     18,    180,    180,  -1116,  -1116,    504, &
                   504,   -792,  -1116,   -954,  -2088,   7956,   -792,  -2088,   9252,   -792,   2448,  -2088,  -1440,    180, &
                  8928,  -1116,    342,   -954,   -144,     18,  -1440,    180,  -1278,  -1116,  -4032,    504,   8928,  -1116, &
                  -792,  -2412,  -2412,   7956,   9090,  -2412,  -2088,   7956]
  K1( 747,:) = [   1152,   -144,  -9216,   1152,  -1440,   -144,   -144,     18,  -1440,    180,  -1278,  -1116,   1152,   -144, &
                  -144,     18,     18,    180,    180,     18,  -1116,    504,    180,  -1116,  -9216,   1152,  73728,  -9216, &
                 11520,   1152,   1152,   -144,  11520,  -1440,  10224,   8928,  -9216,   1152,   1152,   -144,   -144,  -1440, &
                 -1440,   -144,   8928,  -4032,  -1440,   8928,  -1440,    180,   8928,  -1116,    342,   -954,   -144,     18, &
                 -1440,    180,  -1278,  -1116,  -4032,    504,   8928,  -1116,   -792,  -2412,  -2412,   7956,   9090,  -2412, &
                 -2088,   7956,  11520,  -1440,  -1440,    180,    180,   1800,   1152,   -144,   -144,     18,     18,    180, &
                  8928,  -1116,  10224,  -1278,   9252,   9090,  -1116,   -954,  -1278,    342,   -792,  -2412,   1800,    180, &
                  -954,   -792,  -1116,   9252,    180,     18,  -1116,    504,    180,  -1116,   -792,  -2088,   9252,   -792, &
                  2448,  -2088,    504,   -792,  -1116,   -954,  -2088,   7956]
  K1( 748,:) = [   -144,  -1440,   1152,  -9216,   -144,   1152,     18,    180,    180,  -1116,  -1116,    504,   -144,   1152, &
                    18,    180,   -144,     18,     18,   -144,  -1278,  -1116,  -1440,    180,   1152,  11520,  -9216,  73728, &
                  1152,  -9216,   -144,  -1440,  -1440,   8928,   8928,  -4032,   1152,  -9216,   -144,  -1440,   1152,   -144, &
                  -144,   1152,  10224,   8928,  11520,  -1440,    180,   1800,  -1116,   9252,   -954,   -792,     18,    180, &
                   180,  -1116,  -1116,    504,    504,   -792,  -1116,   -954,  -2088,   7956,   -792,  -2088,   9252,   -792, &
                  2448,  -2088,  -1440,  11520,    180,   1800,  -1440,    180,   -144,   1152,     18,    180,   -144,     18, &
                 -1116,   -954,  -1278,    342,   -792,  -2412,   8928,  -1116,  10224,  -1278,   9252,   9090,    180,  -1440, &
                   342,   -954,   8928,  -1116,     18,   -144,  -1278,  -1116,  -1440,    180,  -2412,   7956,   9090,  -2412, &
                 -2088,   7956,  -4032,    504,   8928,  -1116,   -792,  -2412]
  K1( 749,:) = [   -144,   1152,  -1440,   -144,  -9216,   1152,     18,   -144,  -1278,  -1116,  -1440,    180,    180,     18, &
                 -1116,    504,    180,  -1116,   1152,   -144,   -144,     18,     18,    180,   1152,  -9216,  11520,   1152, &
                 73728,  -9216,   -144,   1152,  10224,   8928,  11520,  -1440,  -1440,   -144,   8928,  -4032,  -1440,   8928, &
                 -9216,   1152,   1152,   -144,   -144,  -1440,    180,  -1440,    342,   -954,   8928,  -1116,     18,   -144, &
                 -1278,  -1116,  -1440,    180,  -2412,   7956,   9090,  -2412,  -2088,   7956,  -4032,    504,   8928,  -1116, &
                  -792,  -2412,   1800,    180,   -954,   -792,  -1116,   9252,    180,     18,  -1116,    504,    180,  -1116, &
                  -792,  -2088,   9252,   -792,   2448,  -2088,    504,   -792,  -1116,   -954,  -2088,   7956,  11520,  -1440, &
                 -1440,    180,    180,   1800,   1152,   -144,   -144,     18,     18,    180,   8928,  -1116,  10224,  -1278, &
                  9252,   9090,  -1116,   -954,  -1278,    342,   -792,  -2412]
  K1( 750,:) = [  -1440,   -144,   -144,   1152,   1152,  -9216,    180,     18,  -1116,    504,    180,  -1116,     18,   -144, &
                 -1278,  -1116,  -1440,    180,   -144,   1152,     18,    180,   -144,     18,  11520,   1152,   1152,  -9216, &
                 -9216,  73728,  -1440,   -144,   8928,  -4032,  -1440,   8928,   -144,   1152,  10224,   8928,  11520,  -1440, &
                  1152,  -9216,   -144,  -1440,   1152,   -144,   1800,    180,   -954,   -792,  -1116,   9252,    180,     18, &
                 -1116,    504,    180,  -1116,   -792,  -2088,   9252,   -792,   2448,  -2088,    504,   -792,  -1116,   -954, &
                 -2088,   7956,    180,  -1440,    342,   -954,   8928,  -1116,     18,   -144,  -1278,  -1116,  -1440,    180, &
                 -2412,   7956,   9090,  -2412,  -2088,   7956,  -4032,    504,   8928,  -1116,   -792,  -2412,  -1440,  11520, &
                   180,   1800,  -1440,    180,   -144,   1152,     18,    180,   -144,     18,  -1116,   -954,  -1278,    342, &
                  -792,  -2412,   8928,  -1116,  10224,  -1278,   9252,   9090]
  K1( 751,:) = [   1152,   -144,   -144,     18,     18,    180,  11520,  -1440,  -1440,    180,    180,   1800,  10224,  -1278, &
                  8928,  -1116,   9090,   9252,  -1278,    342,  -1116,   -954,  -2412,   -792,  -9216,   1152,   1152,   -144, &
                  -144,  -1440,  73728,  -9216,  -9216,   1152,   1152,  11520,  11520,  -1440,   1152,   -144,   8928,  10224, &
                 -1440,   8928,   -144,  -1440,  -4032,   8928,   1152,   -144,   -144,     18,     18,    180,  -9216,   1152, &
                  1152,   -144,   -144,  -1440,  -1440,    180,   -144,     18,  -1116,  -1278,    180,  -1116,     18,    180, &
                   504,  -1116,   8928,  -1116,  -4032,    504,  -2412,   -792,  -1440,    180,   -144,     18,  -1116,  -1278, &
                  8928,  -1116,  -1440,    180,   -954,    342,   7956,  -2088,  -2412,   9090,   7956,  -2412,  -1116,   -954, &
                   504,   -792,   7956,  -2088,    180,  -1116,     18,    180,    504,  -1116,  -1116,   9252,    180,   1800, &
                  -792,   -954,  -2088,   2448,   -792,   9252,  -2088,   -792]
  K1( 752,:) = [   -144,   1152,     18,    180,   -144,     18,  -1440,  11520,    180,   1800,  -1440,    180,  -1278,    342, &
                 -1116,   -954,  -2412,   -792,  10224,  -1278,   8928,  -1116,   9090,   9252,   1152,  -9216,   -144,  -1440, &
                  1152,   -144,  -9216,  73728,   1152,  11520,  -9216,   1152,  -1440,   8928,   -144,  -1440,  -4032,   8928, &
                 11520,  -1440,   1152,   -144,   8928,  10224,   -144,   1152,     18,    180,   -144,     18,   1152,  -9216, &
                  -144,  -1440,   1152,   -144,    180,  -1116,     18,    180,    504,  -1116,  -1440,    180,   -144,     18, &
                 -1116,  -1278,  -1116,   -954,    504,   -792,   7956,  -2088,    180,  -1116,     18,    180,    504,  -1116, &
                 -1116,   9252,    180,   1800,   -792,   -954,  -2088,   2448,   -792,   9252,  -2088,   -792,   8928,  -1116, &
                 -4032,    504,  -2412,   -792,  -1440,    180,   -144,     18,  -1116,  -1278,   8928,  -1116,  -1440,    180, &
                  -954,    342,   7956,  -2088,  -2412,   9090,   7956,  -2412]
  K1( 753,:) = [   -144,     18,  -1440,    180,  -1278,  -1116,  -1440,    180,   8928,  -1116,    342,   -954,   8928,  -1116, &
                 -4032,    504,  -2412,   -792,   9090,  -2412,  -2412,   7956,   7956,  -2088,   1152,   -144,  11520,  -1440, &
                 10224,   8928,  -9216,   1152,  73728,  -9216,  11520,   1152,   1152,   -144,  -9216,   1152,  -1440,   -144, &
                  8928,  -4032,  -1440,   -144,   8928,  -1440,   -144,     18,  -1440,    180,  -1278,  -1116,   1152,   -144, &
                 -9216,   1152,  -1440,   -144,   -144,     18,   1152,   -144,    180,     18,  -1116,    504,    180,     18, &
                 -1116,    180,  10224,  -1278,   8928,  -1116,   9090,   9252,   -144,     18,   1152,   -144,    180,     18, &
                 -1440,    180,  11520,  -1440,   1800,    180,  -2412,   -792,    342,  -1278,   -954,  -1116,   9252,   -792, &
                  -792,  -2088,  -2088,   2448,  -1116,    504,    180,     18,  -1116,    180,   -954,   -792,   1800,    180, &
                  9252,  -1116,   7956,  -2088,   -954,  -1116,   -792,    504]
  K1( 754,:) = [     18,    180,    180,  -1116,  -1116,    504,    180,   1800,  -1116,   9252,   -954,   -792,  -1116,   -954, &
                   504,   -792,   7956,  -2088,   9252,   -792,   -792,  -2088,  -2088,   2448,   -144,  -1440,  -1440,   8928, &
                  8928,  -4032,   1152,  11520,  -9216,  73728,   1152,  -9216,   -144,  -1440,   1152,  -9216,   -144,   1152, &
                 10224,   8928,   -144,   1152,  -1440,  11520,     18,    180,    180,  -1116,  -1116,    504,   -144,  -1440, &
                  1152,  -9216,   -144,   1152,     18,    180,   -144,   1152,     18,   -144,  -1278,  -1116,     18,   -144, &
                   180,  -1440,  -1278,    342,  -1116,   -954,  -2412,   -792,     18,    180,   -144,   1152,     18,   -144, &
                   180,   1800,  -1440,  11520,    180,  -1440,   9090,   9252,  -1278,  10224,  -1116,   8928,   9090,  -2412, &
                 -2412,   7956,   7956,  -2088,  -1278,  -1116,     18,   -144,    180,  -1440,    342,   -954,    180,  -1440, &
                 -1116,   8928,  -2412,   -792,  -1116,   8928,    504,  -4032]
  K1( 755,:) = [     18,   -144,  -1278,  -1116,  -1440,    180,    180,  -1440,    342,   -954,   8928,  -1116,   9090,  -2412, &
                 -2412,   7956,   7956,  -2088,   8928,  -1116,  -4032,    504,  -2412,   -792,   -144,   1152,  10224,   8928, &
                 11520,  -1440,   1152,  -9216,  11520,   1152,  73728,  -9216,   8928,  -4032,  -1440,   -144,   8928,  -1440, &
                  1152,   -144,  -9216,   1152,  -1440,   -144,     18,   -144,  -1278,  -1116,  -1440,    180,   -144,   1152, &
                 -1440,   -144,  -9216,   1152,  -1116,    504,    180,     18,  -1116,    180,   -144,     18,   1152,   -144, &
                   180,     18,   9252,   -792,   -792,  -2088,  -2088,   2448,  -1116,    504,    180,     18,  -1116,    180, &
                  -954,   -792,   1800,    180,   9252,  -1116,   7956,  -2088,   -954,  -1116,   -792,    504,  10224,  -1278, &
                  8928,  -1116,   9090,   9252,   -144,     18,   1152,   -144,    180,     18,  -1440,    180,  11520,  -1440, &
                  1800,    180,  -2412,   -792,    342,  -1278,   -954,  -1116]
  K1( 756,:) = [    180,     18,  -1116,    504,    180,  -1116,   1800,    180,   -954,   -792,  -1116,   9252,   9252,   -792, &
                  -792,  -2088,  -2088,   2448,  -1116,   -954,    504,   -792,   7956,  -2088,  -1440,   -144,   8928,  -4032, &
                 -1440,   8928,  11520,   1152,   1152,  -9216,  -9216,  73728,  10224,   8928,   -144,   1152,  -1440,  11520, &
                  -144,  -1440,   1152,  -9216,   -144,   1152,    180,     18,  -1116,    504,    180,  -1116,  -1440,   -144, &
                  -144,   1152,   1152,  -9216,  -1278,  -1116,     18,   -144,    180,  -1440,     18,    180,   -144,   1152, &
                    18,   -144,   9090,  -2412,  -2412,   7956,   7956,  -2088,  -1278,  -1116,     18,   -144,    180,  -1440, &
                   342,   -954,    180,  -1440,  -1116,   8928,  -2412,   -792,  -1116,   8928,    504,  -4032,  -1278,    342, &
                 -1116,   -954,  -2412,   -792,     18,    180,   -144,   1152,     18,   -144,    180,   1800,  -1440,  11520, &
                   180,  -1440,   9090,   9252,  -1278,  10224,  -1116,   8928]
  K1( 757,:) = [   -144,     18,   1152,   -144,    180,     18,  10224,  -1278,   8928,  -1116,   9090,   9252,  11520,  -1440, &
                 -1440,    180,    180,   1800,    342,  -1278,  -2412,   -792,  -1116,   -954,   1152,   -144,  -9216,   1152, &
                 -1440,   -144,  11520,  -1440,   1152,   -144,   8928,  10224,  73728,  -9216,  -9216,   1152,   1152,  11520, &
                  8928,  -1440,  -4032,   8928,   -144,  -1440,   8928,  -1116,  -4032,    504,  -2412,   -792,  -1440,    180, &
                  -144,     18,  -1116,  -1278,   8928,  -1116,  -1440,    180,   -954,    342,   7956,  -2088,  -2412,   9090, &
                  7956,  -2412,   1152,   -144,   -144,     18,     18,    180,  -9216,   1152,   1152,   -144,   -144,  -1440, &
                 -1440,    180,   -144,     18,  -1116,  -1278,    180,  -1116,     18,    180,    504,  -1116,   -954,  -1116, &
                  7956,  -2088,    504,   -792,  -1116,    180,    504,  -1116,     18,    180,  -2088,   2448,   -792,   9252, &
                 -2088,   -792,  -1116,   9252,    180,   1800,   -792,   -954]
  K1( 758,:) = [     18,    180,   -144,   1152,     18,   -144,  -1278,    342,  -1116,   -954,  -2412,   -792,  -1440,  11520, &
                   180,   1800,  -1440,    180,  -1278,  10224,   9090,   9252,   8928,  -1116,   -144,  -1440,   1152,  -9216, &
                  -144,   1152,  -1440,   8928,   -144,  -1440,  -4032,   8928,  -9216,  73728,   1152,  11520,  -9216,   1152, &
                 -1440,  11520,   8928,  10224,   1152,   -144,  -1116,   -954,    504,   -792,   7956,  -2088,    180,  -1116, &
                    18,    180,    504,  -1116,  -1116,   9252,    180,   1800,   -792,   -954,  -2088,   2448,   -792,   9252, &
                 -2088,   -792,   -144,   1152,     18,    180,   -144,     18,   1152,  -9216,   -144,  -1440,   1152,   -144, &
                   180,  -1116,     18,    180,    504,  -1116,  -1440,    180,   -144,     18,  -1116,  -1278,  -1116,   8928, &
                 -2412,   -792,  -4032,    504,    180,  -1440,  -1116,  -1278,   -144,     18,   7956,  -2088,  -2412,   9090, &
                  7956,  -2412,   8928,  -1116,  -1440,    180,   -954,    342]
  K1( 759,:) = [  -1440,    180,   -144,     18,  -1116,  -1278,   8928,  -1116,  -4032,    504,  -2412,   -792,  -1440,    180, &
                  8928,  -1116,    342,   -954,  -2412,   9090,   7956,  -2088,  -2412,   7956,  11520,  -1440,   1152,   -144, &
                  8928,  10224,   1152,   -144,  -9216,   1152,  -1440,   -144,  -9216,   1152,  73728,  -9216,  11520,   1152, &
                 -4032,   8928,   8928,  -1440,  -1440,   -144,  10224,  -1278,   8928,  -1116,   9090,   9252,   -144,     18, &
                  1152,   -144,    180,     18,  -1440,    180,  11520,  -1440,   1800,    180,  -2412,   -792,    342,  -1278, &
                  -954,  -1116,   -144,     18,  -1440,    180,  -1278,  -1116,   1152,   -144,  -9216,   1152,  -1440,   -144, &
                  -144,     18,   1152,   -144,    180,     18,  -1116,    504,    180,     18,  -1116,    180,   -792,   9252, &
                 -2088,   2448,   -792,  -2088,    504,  -1116,  -1116,    180,    180,     18,   7956,  -2088,   -954,  -1116, &
                  -792,    504,   -954,   -792,   1800,    180,   9252,  -1116]
  K1( 760,:) = [    180,  -1116,     18,    180,    504,  -1116,  -1116,   -954,    504,   -792,   7956,  -2088,    180,   1800, &
                 -1116,   9252,   -954,   -792,   -792,   9252,  -2088,   2448,   -792,  -2088,  -1440,   8928,   -144,  -1440, &
                 -4032,   8928,   -144,  -1440,   1152,  -9216,   -144,   1152,   1152,  11520,  -9216,  73728,   1152,  -9216, &
                  8928,  10224,  -1440,  11520,   -144,   1152,  -1278,    342,  -1116,   -954,  -2412,   -792,     18,    180, &
                  -144,   1152,     18,   -144,    180,   1800,  -1440,  11520,    180,  -1440,   9090,   9252,  -1278,  10224, &
                 -1116,   8928,     18,    180,    180,  -1116,  -1116,    504,   -144,  -1440,   1152,  -9216,   -144,   1152, &
                    18,    180,   -144,   1152,     18,   -144,  -1278,  -1116,     18,   -144,    180,  -1440,  -2412,   9090, &
                  7956,  -2088,  -2412,   7956,  -1116,  -1278,    180,  -1440,     18,   -144,  -2412,   -792,  -1116,   8928, &
                   504,  -4032,    342,   -954,    180,  -1440,  -1116,   8928]
  K1( 761,:) = [  -1278,  -1116,     18,   -144,    180,  -1440,   9090,  -2412,  -2412,   7956,   7956,  -2088,    180,  -1440, &
                   342,   -954,   8928,  -1116,  -1116,   8928,  -2412,   -792,  -4032,    504,  10224,   8928,   -144,   1152, &
                 -1440,  11520,   8928,  -4032,  -1440,   -144,   8928,  -1440,   1152,  -9216,  11520,   1152,  73728,  -9216, &
                  -144,   1152,  -1440,   -144,  -9216,   1152,   9252,   -792,   -792,  -2088,  -2088,   2448,  -1116,    504, &
                   180,     18,  -1116,    180,   -954,   -792,   1800,    180,   9252,  -1116,   7956,  -2088,   -954,  -1116, &
                  -792,    504,     18,   -144,  -1278,  -1116,  -1440,    180,   -144,   1152,  -1440,   -144,  -9216,   1152, &
                 -1116,    504,    180,     18,  -1116,    180,   -144,     18,   1152,   -144,    180,     18,  -1278,  10224, &
                  9090,   9252,   8928,  -1116,     18,   -144,    180,     18,   1152,   -144,  -2412,   -792,    342,  -1278, &
                  -954,  -1116,  -1440,    180,  11520,  -1440,   1800,    180]
  K1( 762,:) = [  -1116,    504,    180,     18,  -1116,    180,   9252,   -792,   -792,  -2088,  -2088,   2448,   1800,    180, &
                  -954,   -792,  -1116,   9252,   -954,  -1116,   7956,  -2088,    504,   -792,   8928,  -4032,  -1440,   -144, &
                  8928,  -1440,  10224,   8928,   -144,   1152,  -1440,  11520,  11520,   1152,   1152,  -9216,  -9216,  73728, &
                 -1440,   -144,   -144,   1152,   1152,  -9216,   9090,  -2412,  -2412,   7956,   7956,  -2088,  -1278,  -1116, &
                    18,   -144,    180,  -1440,    342,   -954,    180,  -1440,  -1116,   8928,  -2412,   -792,  -1116,   8928, &
                   504,  -4032,    180,     18,  -1116,    504,    180,  -1116,  -1440,   -144,   -144,   1152,   1152,  -9216, &
                 -1278,  -1116,     18,   -144,    180,  -1440,     18,    180,   -144,   1152,     18,   -144,    342,  -1278, &
                 -2412,   -792,  -1116,   -954,    180,     18,     18,   -144,   -144,   1152,   9090,   9252,  -1278,  10224, &
                 -1116,   8928,    180,   1800,  -1440,  11520,    180,  -1440]
  K1( 763,:) = [     18,   -144,    180,     18,   1152,   -144,  -1278,  10224,   9090,   9252,   8928,  -1116,    342,  -1278, &
                 -2412,   -792,  -1116,   -954,  11520,  -1440,  -1440,    180,    180,   1800,   -144,   1152,  -1440,   -144, &
                 -9216,   1152,  -1440,  11520,   8928,  10224,   1152,   -144,   8928,  -1440,  -4032,   8928,   -144,  -1440, &
                 73728,  -9216,  -9216,   1152,   1152,  11520,  -1116,   8928,  -2412,   -792,  -4032,    504,    180,  -1440, &
                 -1116,  -1278,   -144,     18,   7956,  -2088,  -2412,   9090,   7956,  -2412,   8928,  -1116,  -1440,    180, &
                  -954,    342,   -954,  -1116,   7956,  -2088,    504,   -792,  -1116,    180,    504,  -1116,     18,    180, &
                 -2088,   2448,   -792,   9252,  -2088,   -792,  -1116,   9252,    180,   1800,   -792,   -954,   1152,   -144, &
                  -144,     18,     18,    180,  -9216,   1152,   1152,   -144,   -144,  -1440,  -1440,    180,   -144,     18, &
                 -1116,  -1278,    180,  -1116,     18,    180,    504,  -1116]
  K1( 764,:) = [    180,     18,     18,   -144,   -144,   1152,    342,  -1278,  -2412,   -792,  -1116,   -954,  -1278,  10224, &
                  9090,   9252,   8928,  -1116,  -1440,  11520,    180,   1800,  -1440,    180,  -1440,   -144,   -144,   1152, &
                  1152,  -9216,   8928,  -1440,  -4032,   8928,   -144,  -1440,  -1440,  11520,   8928,  10224,   1152,   -144, &
                 -9216,  73728,   1152,  11520,  -9216,   1152,   -954,  -1116,   7956,  -2088,    504,   -792,  -1116,    180, &
                   504,  -1116,     18,    180,  -2088,   2448,   -792,   9252,  -2088,   -792,  -1116,   9252,    180,   1800, &
                  -792,   -954,  -1116,   8928,  -2412,   -792,  -4032,    504,    180,  -1440,  -1116,  -1278,   -144,     18, &
                  7956,  -2088,  -2412,   9090,   7956,  -2412,   8928,  -1116,  -1440,    180,   -954,    342,   -144,   1152, &
                    18,    180,   -144,     18,   1152,  -9216,   -144,  -1440,   1152,   -144,    180,  -1116,     18,    180, &
                   504,  -1116,  -1440,    180,   -144,     18,  -1116,  -1278]
  K1( 765,:) = [    180,  -1440,  -1116,  -1278,   -144,     18,  -1116,   8928,  -2412,   -792,  -4032,    504,  -2412,   9090, &
                  7956,  -2088,  -2412,   7956,  -1440,    180,   8928,  -1116,    342,   -954,  -1440,  11520,   8928,  10224, &
                  1152,   -144,   -144,   1152,  -1440,   -144,  -9216,   1152,  -4032,   8928,   8928,  -1440,  -1440,   -144, &
                 -9216,   1152,  73728,  -9216,  11520,   1152,  -1278,  10224,   9090,   9252,   8928,  -1116,     18,   -144, &
                   180,     18,   1152,   -144,  -2412,   -792,    342,  -1278,   -954,  -1116,  -1440,    180,  11520,  -1440, &
                  1800,    180,   -792,   9252,  -2088,   2448,   -792,  -2088,    504,  -1116,  -1116,    180,    180,     18, &
                  7956,  -2088,   -954,  -1116,   -792,    504,   -954,   -792,   1800,    180,   9252,  -1116,   -144,     18, &
                 -1440,    180,  -1278,  -1116,   1152,   -144,  -9216,   1152,  -1440,   -144,   -144,     18,   1152,   -144, &
                   180,     18,  -1116,    504,    180,     18,  -1116,    180]
  K1( 766,:) = [  -1116,    180,    504,  -1116,     18,    180,   -954,  -1116,   7956,  -2088,    504,   -792,   -792,   9252, &
                 -2088,   2448,   -792,  -2088,    180,   1800,  -1116,   9252,   -954,   -792,   8928,  -1440,  -4032,   8928, &
                  -144,  -1440,  -1440,   -144,   -144,   1152,   1152,  -9216,   8928,  10224,  -1440,  11520,   -144,   1152, &
                  1152,  11520,  -9216,  73728,   1152,  -9216,    342,  -1278,  -2412,   -792,  -1116,   -954,    180,     18, &
                    18,   -144,   -144,   1152,   9090,   9252,  -1278,  10224,  -1116,   8928,    180,   1800,  -1440,  11520, &
                   180,  -1440,  -2412,   9090,   7956,  -2088,  -2412,   7956,  -1116,  -1278,    180,  -1440,     18,   -144, &
                 -2412,   -792,  -1116,   8928,    504,  -4032,    342,   -954,    180,  -1440,  -1116,   8928,     18,    180, &
                   180,  -1116,  -1116,    504,   -144,  -1440,   1152,  -9216,   -144,   1152,     18,    180,   -144,   1152, &
                    18,   -144,  -1278,  -1116,     18,   -144,    180,  -1440]
  K1( 767,:) = [  -1116,  -1278,    180,  -1440,     18,   -144,  -2412,   9090,   7956,  -2088,  -2412,   7956,  -1116,   8928, &
                 -2412,   -792,  -4032,    504,    180,  -1440,    342,   -954,   8928,  -1116,   8928,  10224,  -1440,  11520, &
                  -144,   1152,  -4032,   8928,   8928,  -1440,  -1440,   -144,   -144,   1152,  -1440,   -144,  -9216,   1152, &
                  1152,  -9216,  11520,   1152,  73728,  -9216,   -792,   9252,  -2088,   2448,   -792,  -2088,    504,  -1116, &
                 -1116,    180,    180,     18,   7956,  -2088,   -954,  -1116,   -792,    504,   -954,   -792,   1800,    180, &
                  9252,  -1116,  -1278,  10224,   9090,   9252,   8928,  -1116,     18,   -144,    180,     18,   1152,   -144, &
                 -2412,   -792,    342,  -1278,   -954,  -1116,  -1440,    180,  11520,  -1440,   1800,    180,     18,   -144, &
                 -1278,  -1116,  -1440,    180,   -144,   1152,  -1440,   -144,  -9216,   1152,  -1116,    504,    180,     18, &
                 -1116,    180,   -144,     18,   1152,   -144,    180,     18]
  K1( 768,:) = [    504,  -1116,  -1116,    180,    180,     18,   -792,   9252,  -2088,   2448,   -792,  -2088,   -954,  -1116, &
                  7956,  -2088,    504,   -792,   1800,    180,   -954,   -792,  -1116,   9252,  -4032,   8928,   8928,  -1440, &
                 -1440,   -144,   8928,  10224,  -1440,  11520,   -144,   1152,  -1440,   -144,   -144,   1152,   1152,  -9216, &
                 11520,   1152,   1152,  -9216,  -9216,  73728,  -2412,   9090,   7956,  -2088,  -2412,   7956,  -1116,  -1278, &
                   180,  -1440,     18,   -144,  -2412,   -792,  -1116,   8928,    504,  -4032,    342,   -954,    180,  -1440, &
                 -1116,   8928,    342,  -1278,  -2412,   -792,  -1116,   -954,    180,     18,     18,   -144,   -144,   1152, &
                  9090,   9252,  -1278,  10224,  -1116,   8928,    180,   1800,  -1440,  11520,    180,  -1440,    180,     18, &
                 -1116,    504,    180,  -1116,  -1440,   -144,   -144,   1152,   1152,  -9216,  -1278,  -1116,     18,   -144, &
                   180,  -1440,     18,    180,   -144,   1152,     18,   -144]
  K1( 769,:) = [   1152,   -144,   -144,     18,     18,    180,  -9216,   1152,   1152,   -144,   -144,  -1440,  -1440,    180, &
                  -144,     18,  -1116,  -1278,    180,  -1116,     18,    180,    504,  -1116,  11520,  -1440,  -1440,    180, &
                   180,   1800,   1152,   -144,   -144,     18,     18,    180,   8928,  -1116,  10224,  -1278,   9252,   9090, &
                 -1116,   -954,  -1278,    342,   -792,  -2412,  73728,  -9216,  -9216,   1152,   1152,  11520,  -9216,   1152, &
                  1152,   -144,   -144,  -1440,   1152,   -144,  11520,  -1440,  10224,   8928,   -144,  -1440,  -1440,   8928, &
                  8928,  -4032,   8928,  -1116,  -1440,    180,   -954,    342,  -4032,    504,   8928,  -1116,   -792,  -2412, &
                  -144,     18,  -1440,    180,  -1278,  -1116,   7956,  -2412,  -2088,   7956,   9090,  -2412,  -1116,   9252, &
                   180,   1800,   -792,   -954,    504,   -792,  -1116,   -954,  -2088,   7956,     18,    180,    180,  -1116, &
                 -1116,    504,  -2088,   -792,   2448,  -2088,   9252,   -792]
  K1( 770,:) = [   -144,   1152,     18,    180,   -144,     18,   1152,  -9216,   -144,  -1440,   1152,   -144,    180,  -1116, &
                    18,    180,    504,  -1116,  -1440,    180,   -144,     18,  -1116,  -1278,  -1440,  11520,    180,   1800, &
                 -1440,    180,   -144,   1152,     18,    180,   -144,     18,  -1116,   -954,  -1278,    342,   -792,  -2412, &
                  8928,  -1116,  10224,  -1278,   9252,   9090,  -9216,  73728,   1152,  11520,  -9216,   1152,   1152,  -9216, &
                  -144,  -1440,   1152,   -144,   -144,  -1440,  -1440,   8928,   8928,  -4032,   1152,   -144,  11520,  -1440, &
                 10224,   8928,  -1116,   9252,    180,   1800,   -792,   -954,    504,   -792,  -1116,   -954,  -2088,   7956, &
                    18,    180,    180,  -1116,  -1116,    504,  -2088,   -792,   2448,  -2088,   9252,   -792,   8928,  -1116, &
                 -1440,    180,   -954,    342,  -4032,    504,   8928,  -1116,   -792,  -2412,   -144,     18,  -1440,    180, &
                 -1278,  -1116,   7956,  -2412,  -2088,   7956,   9090,  -2412]
  K1( 771,:) = [   -144,     18,  -1440,    180,  -1278,  -1116,   1152,   -144,  -9216,   1152,  -1440,   -144,   -144,     18, &
                  1152,   -144,    180,     18,  -1116,    504,    180,     18,  -1116,    180,  -1440,    180,   8928,  -1116, &
                   342,   -954,   -144,     18,  -1440,    180,  -1278,  -1116,  -4032,    504,   8928,  -1116,   -792,  -2412, &
                 -2412,   7956,   9090,  -2412,  -2088,   7956,  -9216,   1152,  73728,  -9216,  11520,   1152,   1152,   -144, &
                 11520,  -1440,  10224,   8928,  -9216,   1152,   1152,   -144,   -144,  -1440,  -1440,   -144,   8928,  -4032, &
                 -1440,   8928,  -1440,    180,  11520,  -1440,   1800,    180,   8928,  -1116,  10224,  -1278,   9252,   9090, &
                  1152,   -144,   -144,     18,     18,    180,   -954,  -1116,   -792,  -2412,  -1278,    342,   -954,   -792, &
                  1800,    180,   9252,  -1116,   -792,  -2088,   9252,   -792,   2448,  -2088,    180,     18,  -1116,    504, &
                   180,  -1116,   -792,    504,  -2088,   7956,  -1116,   -954]
  K1( 772,:) = [     18,    180,    180,  -1116,  -1116,    504,   -144,  -1440,   1152,  -9216,   -144,   1152,     18,    180, &
                  -144,   1152,     18,   -144,  -1278,  -1116,     18,   -144,    180,  -1440,    180,   1800,  -1116,   9252, &
                  -954,   -792,     18,    180,    180,  -1116,  -1116,    504,    504,   -792,  -1116,   -954,  -2088,   7956, &
                  -792,  -2088,   9252,   -792,   2448,  -2088,   1152,  11520,  -9216,  73728,   1152,  -9216,   -144,  -1440, &
                 -1440,   8928,   8928,  -4032,   1152,  -9216,   -144,  -1440,   1152,   -144,   -144,   1152,  10224,   8928, &
                 11520,  -1440,    180,   1800,  -1440,  11520,    180,  -1440,  -1116,   -954,  -1278,    342,   -792,  -2412, &
                  -144,   1152,     18,    180,   -144,     18,  -1116,   8928,   9252,   9090,  10224,  -1278,    342,   -954, &
                   180,  -1440,  -1116,   8928,  -2412,   7956,   9090,  -2412,  -2088,   7956,     18,   -144,  -1278,  -1116, &
                 -1440,    180,    504,  -4032,   -792,  -2412,   8928,  -1116]
  K1( 773,:) = [     18,   -144,  -1278,  -1116,  -1440,    180,   -144,   1152,  -1440,   -144,  -9216,   1152,  -1116,    504, &
                   180,     18,  -1116,    180,   -144,     18,   1152,   -144,    180,     18,    180,  -1440,    342,   -954, &
                  8928,  -1116,     18,   -144,  -1278,  -1116,  -1440,    180,  -2412,   7956,   9090,  -2412,  -2088,   7956, &
                 -4032,    504,   8928,  -1116,   -792,  -2412,   1152,  -9216,  11520,   1152,  73728,  -9216,   -144,   1152, &
                 10224,   8928,  11520,  -1440,  -1440,   -144,   8928,  -4032,  -1440,   8928,  -9216,   1152,   1152,   -144, &
                  -144,  -1440,   -954,   -792,   1800,    180,   9252,  -1116,   -792,  -2088,   9252,   -792,   2448,  -2088, &
                   180,     18,  -1116,    504,    180,  -1116,   -792,    504,  -2088,   7956,  -1116,   -954,  -1440,    180, &
                 11520,  -1440,   1800,    180,   8928,  -1116,  10224,  -1278,   9252,   9090,   1152,   -144,   -144,     18, &
                    18,    180,   -954,  -1116,   -792,  -2412,  -1278,    342]
  K1( 774,:) = [    180,     18,  -1116,    504,    180,  -1116,  -1440,   -144,   -144,   1152,   1152,  -9216,  -1278,  -1116, &
                    18,   -144,    180,  -1440,     18,    180,   -144,   1152,     18,   -144,   1800,    180,   -954,   -792, &
                 -1116,   9252,    180,     18,  -1116,    504,    180,  -1116,   -792,  -2088,   9252,   -792,   2448,  -2088, &
                   504,   -792,  -1116,   -954,  -2088,   7956,  11520,   1152,   1152,  -9216,  -9216,  73728,  -1440,   -144, &
                  8928,  -4032,  -1440,   8928,   -144,   1152,  10224,   8928,  11520,  -1440,   1152,  -9216,   -144,  -1440, &
                  1152,   -144,    342,   -954,    180,  -1440,  -1116,   8928,  -2412,   7956,   9090,  -2412,  -2088,   7956, &
                    18,   -144,  -1278,  -1116,  -1440,    180,    504,  -4032,   -792,  -2412,   8928,  -1116,    180,   1800, &
                 -1440,  11520,    180,  -1440,  -1116,   -954,  -1278,    342,   -792,  -2412,   -144,   1152,     18,    180, &
                  -144,     18,  -1116,   8928,   9252,   9090,  10224,  -1278]
  K1( 775,:) = [  11520,  -1440,  -1440,    180,    180,   1800,   1152,   -144,   -144,     18,     18,    180,   8928,  -1116, &
                 10224,  -1278,   9252,   9090,  -1116,   -954,  -1278,    342,   -792,  -2412,   1152,   -144,   -144,     18, &
                    18,    180,  -9216,   1152,   1152,   -144,   -144,  -1440,  -1440,    180,   -144,     18,  -1116,  -1278, &
                   180,  -1116,     18,    180,    504,  -1116,  -9216,   1152,   1152,   -144,   -144,  -1440,  73728,  -9216, &
                 -9216,   1152,   1152,  11520,  11520,  -1440,   1152,   -144,   8928,  10224,  -1440,   8928,   -144,  -1440, &
                 -4032,   8928,  -4032,    504,   8928,  -1116,   -792,  -2412,   8928,  -1116,  -1440,    180,   -954,    342, &
                 -1440,    180,   -144,     18,  -1116,  -1278,  -2088,   7956,   7956,  -2412,  -2412,   9090,    504,   -792, &
                 -1116,   -954,  -2088,   7956,  -1116,   9252,    180,   1800,   -792,   -954,    180,  -1116,     18,    180, &
                   504,  -1116,   2448,  -2088,  -2088,   -792,   -792,   9252]
  K1( 776,:) = [  -1440,  11520,    180,   1800,  -1440,    180,   -144,   1152,     18,    180,   -144,     18,  -1116,   -954, &
                 -1278,    342,   -792,  -2412,   8928,  -1116,  10224,  -1278,   9252,   9090,   -144,   1152,     18,    180, &
                  -144,     18,   1152,  -9216,   -144,  -1440,   1152,   -144,    180,  -1116,     18,    180,    504,  -1116, &
                 -1440,    180,   -144,     18,  -1116,  -1278,   1152,  -9216,   -144,  -1440,   1152,   -144,  -9216,  73728, &
                  1152,  11520,  -9216,   1152,  -1440,   8928,   -144,  -1440,  -4032,   8928,  11520,  -1440,   1152,   -144, &
                  8928,  10224,    504,   -792,  -1116,   -954,  -2088,   7956,  -1116,   9252,    180,   1800,   -792,   -954, &
                   180,  -1116,     18,    180,    504,  -1116,   2448,  -2088,  -2088,   -792,   -792,   9252,  -4032,    504, &
                  8928,  -1116,   -792,  -2412,   8928,  -1116,  -1440,    180,   -954,    342,  -1440,    180,   -144,     18, &
                 -1116,  -1278,  -2088,   7956,   7956,  -2412,  -2412,   9090]
  K1( 777,:) = [  -1440,    180,   8928,  -1116,    342,   -954,   -144,     18,  -1440,    180,  -1278,  -1116,  -4032,    504, &
                  8928,  -1116,   -792,  -2412,  -2412,   7956,   9090,  -2412,  -2088,   7956,   -144,     18,  -1440,    180, &
                 -1278,  -1116,   1152,   -144,  -9216,   1152,  -1440,   -144,   -144,     18,   1152,   -144,    180,     18, &
                 -1116,    504,    180,     18,  -1116,    180,   1152,   -144,  11520,  -1440,  10224,   8928,  -9216,   1152, &
                 73728,  -9216,  11520,   1152,   1152,   -144,  -9216,   1152,  -1440,   -144,   8928,  -4032,  -1440,   -144, &
                  8928,  -1440,   8928,  -1116,  10224,  -1278,   9252,   9090,  -1440,    180,  11520,  -1440,   1800,    180, &
                  -144,     18,   1152,   -144,    180,     18,   -792,  -2412,   -954,  -1116,    342,  -1278,   -792,  -2088, &
                  9252,   -792,   2448,  -2088,   -954,   -792,   1800,    180,   9252,  -1116,  -1116,    504,    180,     18, &
                 -1116,    180,  -2088,   7956,   -792,    504,   -954,  -1116]
  K1( 778,:) = [    180,   1800,  -1116,   9252,   -954,   -792,     18,    180,    180,  -1116,  -1116,    504,    504,   -792, &
                 -1116,   -954,  -2088,   7956,   -792,  -2088,   9252,   -792,   2448,  -2088,     18,    180,    180,  -1116, &
                 -1116,    504,   -144,  -1440,   1152,  -9216,   -144,   1152,     18,    180,   -144,   1152,     18,   -144, &
                 -1278,  -1116,     18,   -144,    180,  -1440,   -144,  -1440,  -1440,   8928,   8928,  -4032,   1152,  11520, &
                 -9216,  73728,   1152,  -9216,   -144,  -1440,   1152,  -9216,   -144,   1152,  10224,   8928,   -144,   1152, &
                 -1440,  11520,  -1116,   -954,  -1278,    342,   -792,  -2412,    180,   1800,  -1440,  11520,    180,  -1440, &
                    18,    180,   -144,   1152,     18,   -144,   9252,   9090,  -1116,   8928,  -1278,  10224,  -2412,   7956, &
                  9090,  -2412,  -2088,   7956,    342,   -954,    180,  -1440,  -1116,   8928,  -1278,  -1116,     18,   -144, &
                   180,  -1440,   -792,  -2412,    504,  -4032,  -1116,   8928]
  K1( 779,:) = [    180,  -1440,    342,   -954,   8928,  -1116,     18,   -144,  -1278,  -1116,  -1440,    180,  -2412,   7956, &
                  9090,  -2412,  -2088,   7956,  -4032,    504,   8928,  -1116,   -792,  -2412,     18,   -144,  -1278,  -1116, &
                 -1440,    180,   -144,   1152,  -1440,   -144,  -9216,   1152,  -1116,    504,    180,     18,  -1116,    180, &
                  -144,     18,   1152,   -144,    180,     18,   -144,   1152,  10224,   8928,  11520,  -1440,   1152,  -9216, &
                 11520,   1152,  73728,  -9216,   8928,  -4032,  -1440,   -144,   8928,  -1440,   1152,   -144,  -9216,   1152, &
                 -1440,   -144,   -792,  -2088,   9252,   -792,   2448,  -2088,   -954,   -792,   1800,    180,   9252,  -1116, &
                 -1116,    504,    180,     18,  -1116,    180,  -2088,   7956,   -792,    504,   -954,  -1116,   8928,  -1116, &
                 10224,  -1278,   9252,   9090,  -1440,    180,  11520,  -1440,   1800,    180,   -144,     18,   1152,   -144, &
                   180,     18,   -792,  -2412,   -954,  -1116,    342,  -1278]
  K1( 780,:) = [   1800,    180,   -954,   -792,  -1116,   9252,    180,     18,  -1116,    504,    180,  -1116,   -792,  -2088, &
                  9252,   -792,   2448,  -2088,    504,   -792,  -1116,   -954,  -2088,   7956,    180,     18,  -1116,    504, &
                   180,  -1116,  -1440,   -144,   -144,   1152,   1152,  -9216,  -1278,  -1116,     18,   -144,    180,  -1440, &
                    18,    180,   -144,   1152,     18,   -144,  -1440,   -144,   8928,  -4032,  -1440,   8928,  11520,   1152, &
                  1152,  -9216,  -9216,  73728,  10224,   8928,   -144,   1152,  -1440,  11520,   -144,  -1440,   1152,  -9216, &
                  -144,   1152,  -2412,   7956,   9090,  -2412,  -2088,   7956,    342,   -954,    180,  -1440,  -1116,   8928, &
                 -1278,  -1116,     18,   -144,    180,  -1440,   -792,  -2412,    504,  -4032,  -1116,   8928,  -1116,   -954, &
                 -1278,    342,   -792,  -2412,    180,   1800,  -1440,  11520,    180,  -1440,     18,    180,   -144,   1152, &
                    18,   -144,   9252,   9090,  -1116,   8928,  -1278,  10224]
  K1( 781,:) = [  10224,  -1278,   8928,  -1116,   9090,   9252,   -144,     18,   1152,   -144,    180,     18,  -1440,    180, &
                 11520,  -1440,   1800,    180,  -2412,   -792,    342,  -1278,   -954,  -1116,   8928,  -1116,  -4032,    504, &
                 -2412,   -792,  -1440,    180,   -144,     18,  -1116,  -1278,   8928,  -1116,  -1440,    180,   -954,    342, &
                  7956,  -2088,  -2412,   9090,   7956,  -2412,   1152,   -144,  -9216,   1152,  -1440,   -144,  11520,  -1440, &
                  1152,   -144,   8928,  10224,  73728,  -9216,  -9216,   1152,   1152,  11520,   8928,  -1440,  -4032,   8928, &
                  -144,  -1440,   -144,     18,   1152,   -144,    180,     18,  -1440,    180,   -144,     18,  -1116,  -1278, &
                 -9216,   1152,   1152,   -144,   -144,  -1440,  -1116,    180,    504,  -1116,     18,    180,   7956,  -2088, &
                  -954,  -1116,   -792,    504,  -2088,   2448,   -792,   9252,  -2088,   -792,  -1116,    180,    504,  -1116, &
                    18,    180,   9252,  -1116,   -792,   -954,    180,   1800]
  K1( 782,:) = [  -1278,    342,  -1116,   -954,  -2412,   -792,     18,    180,   -144,   1152,     18,   -144,    180,   1800, &
                 -1440,  11520,    180,  -1440,   9090,   9252,  -1278,  10224,  -1116,   8928,  -1116,   -954,    504,   -792, &
                  7956,  -2088,    180,  -1116,     18,    180,    504,  -1116,  -1116,   9252,    180,   1800,   -792,   -954, &
                 -2088,   2448,   -792,   9252,  -2088,   -792,   -144,  -1440,   1152,  -9216,   -144,   1152,  -1440,   8928, &
                  -144,  -1440,  -4032,   8928,  -9216,  73728,   1152,  11520,  -9216,   1152,  -1440,  11520,   8928,  10224, &
                  1152,   -144,     18,    180,   -144,   1152,     18,   -144,    180,  -1116,     18,    180,    504,  -1116, &
                  1152,  -9216,   -144,  -1440,   1152,   -144,    180,  -1440,  -1116,  -1278,   -144,     18,  -2412,   -792, &
                 -1116,   8928,    504,  -4032,   7956,  -2088,  -2412,   9090,   7956,  -2412,    180,  -1440,  -1116,  -1278, &
                  -144,     18,  -1116,   8928,   -954,    342,  -1440,    180]
  K1( 783,:) = [   8928,  -1116,  -4032,    504,  -2412,   -792,  -1440,    180,   -144,     18,  -1116,  -1278,   8928,  -1116, &
                 -1440,    180,   -954,    342,   7956,  -2088,  -2412,   9090,   7956,  -2412,  10224,  -1278,   8928,  -1116, &
                  9090,   9252,   -144,     18,   1152,   -144,    180,     18,  -1440,    180,  11520,  -1440,   1800,    180, &
                 -2412,   -792,    342,  -1278,   -954,  -1116,  11520,  -1440,   1152,   -144,   8928,  10224,   1152,   -144, &
                 -9216,   1152,  -1440,   -144,  -9216,   1152,  73728,  -9216,  11520,   1152,  -4032,   8928,   8928,  -1440, &
                 -1440,   -144,  -1440,    180,   -144,     18,  -1116,  -1278,   -144,     18,   1152,   -144,    180,     18, &
                  1152,   -144,  -9216,   1152,  -1440,   -144,    504,  -1116,  -1116,    180,    180,     18,  -2088,   2448, &
                  -792,   9252,  -2088,   -792,   7956,  -2088,   -954,  -1116,   -792,    504,    504,  -1116,  -1116,    180, &
                   180,     18,   -792,   -954,   9252,  -1116,   1800,    180]
  K1( 784,:) = [  -1116,   -954,    504,   -792,   7956,  -2088,    180,  -1116,     18,    180,    504,  -1116,  -1116,   9252, &
                   180,   1800,   -792,   -954,  -2088,   2448,   -792,   9252,  -2088,   -792,  -1278,    342,  -1116,   -954, &
                 -2412,   -792,     18,    180,   -144,   1152,     18,   -144,    180,   1800,  -1440,  11520,    180,  -1440, &
                  9090,   9252,  -1278,  10224,  -1116,   8928,  -1440,   8928,   -144,  -1440,  -4032,   8928,   -144,  -1440, &
                  1152,  -9216,   -144,   1152,   1152,  11520,  -9216,  73728,   1152,  -9216,   8928,  10224,  -1440,  11520, &
                  -144,   1152,    180,  -1116,     18,    180,    504,  -1116,     18,    180,   -144,   1152,     18,   -144, &
                  -144,  -1440,   1152,  -9216,   -144,   1152,  -1116,  -1278,    180,  -1440,     18,   -144,   7956,  -2088, &
                 -2412,   9090,   7956,  -2412,  -2412,   -792,  -1116,   8928,    504,  -4032,  -1116,  -1278,    180,  -1440, &
                    18,   -144,   -954,    342,  -1116,   8928,    180,  -1440]
  K1( 785,:) = [   9090,  -2412,  -2412,   7956,   7956,  -2088,  -1278,  -1116,     18,   -144,    180,  -1440,    342,   -954, &
                   180,  -1440,  -1116,   8928,  -2412,   -792,  -1116,   8928,    504,  -4032,   9252,   -792,   -792,  -2088, &
                 -2088,   2448,  -1116,    504,    180,     18,  -1116,    180,   -954,   -792,   1800,    180,   9252,  -1116, &
                  7956,  -2088,   -954,  -1116,   -792,    504,  10224,   8928,   -144,   1152,  -1440,  11520,   8928,  -4032, &
                 -1440,   -144,   8928,  -1440,   1152,  -9216,  11520,   1152,  73728,  -9216,   -144,   1152,  -1440,   -144, &
                 -9216,   1152,  -1278,  -1116,     18,   -144,    180,  -1440,  -1116,    504,    180,     18,  -1116,    180, &
                  -144,   1152,  -1440,   -144,  -9216,   1152,     18,   -144,    180,     18,   1152,   -144,   9090,   9252, &
                 -1278,  10224,  -1116,   8928,  -2412,   -792,    342,  -1278,   -954,  -1116,     18,   -144,    180,     18, &
                  1152,   -144,    180,  -1440,   1800,    180,  11520,  -1440]
  K1( 786,:) = [   9252,   -792,   -792,  -2088,  -2088,   2448,  -1116,    504,    180,     18,  -1116,    180,   -954,   -792, &
                  1800,    180,   9252,  -1116,   7956,  -2088,   -954,  -1116,   -792,    504,   9090,  -2412,  -2412,   7956, &
                  7956,  -2088,  -1278,  -1116,     18,   -144,    180,  -1440,    342,   -954,    180,  -1440,  -1116,   8928, &
                 -2412,   -792,  -1116,   8928,    504,  -4032,   8928,  -4032,  -1440,   -144,   8928,  -1440,  10224,   8928, &
                  -144,   1152,  -1440,  11520,  11520,   1152,   1152,  -9216,  -9216,  73728,  -1440,   -144,   -144,   1152, &
                  1152,  -9216,  -1116,    504,    180,     18,  -1116,    180,  -1278,  -1116,     18,   -144,    180,  -1440, &
                 -1440,   -144,   -144,   1152,   1152,  -9216,    180,     18,     18,   -144,   -144,   1152,  -2412,   -792, &
                   342,  -1278,   -954,  -1116,   9090,   9252,  -1278,  10224,  -1116,   8928,    180,     18,     18,   -144, &
                  -144,   1152,   1800,    180,    180,  -1440,  -1440,  11520]
  K1( 787,:) = [  -1278,  10224,   9090,   9252,   8928,  -1116,     18,   -144,    180,     18,   1152,   -144,  -2412,   -792, &
                   342,  -1278,   -954,  -1116,  -1440,    180,  11520,  -1440,   1800,    180,  -1116,   8928,  -2412,   -792, &
                 -4032,    504,    180,  -1440,  -1116,  -1278,   -144,     18,   7956,  -2088,  -2412,   9090,   7956,  -2412, &
                  8928,  -1116,  -1440,    180,   -954,    342,   -144,   1152,  -1440,   -144,  -9216,   1152,  -1440,  11520, &
                  8928,  10224,   1152,   -144,   8928,  -1440,  -4032,   8928,   -144,  -1440,  73728,  -9216,  -9216,   1152, &
                  1152,  11520,   7956,  -2088,   -954,  -1116,   -792,    504,  -2088,   2448,   -792,   9252,  -2088,   -792, &
                 -1116,    180,    504,  -1116,     18,    180,   9252,  -1116,   -792,   -954,    180,   1800,   -144,     18, &
                  1152,   -144,    180,     18,  -1440,    180,   -144,     18,  -1116,  -1278,  -9216,   1152,   1152,   -144, &
                  -144,  -1440,  -1116,    180,    504,  -1116,     18,    180]
  K1( 788,:) = [    342,  -1278,  -2412,   -792,  -1116,   -954,    180,     18,     18,   -144,   -144,   1152,   9090,   9252, &
                 -1278,  10224,  -1116,   8928,    180,   1800,  -1440,  11520,    180,  -1440,   -954,  -1116,   7956,  -2088, &
                   504,   -792,  -1116,    180,    504,  -1116,     18,    180,  -2088,   2448,   -792,   9252,  -2088,   -792, &
                 -1116,   9252,    180,   1800,   -792,   -954,  -1440,   -144,   -144,   1152,   1152,  -9216,   8928,  -1440, &
                 -4032,   8928,   -144,  -1440,  -1440,  11520,   8928,  10224,   1152,   -144,  -9216,  73728,   1152,  11520, &
                 -9216,   1152,  -2412,   -792,  -1116,   8928,    504,  -4032,   7956,  -2088,  -2412,   9090,   7956,  -2412, &
                   180,  -1440,  -1116,  -1278,   -144,     18,  -1116,   8928,   -954,    342,  -1440,    180,     18,    180, &
                  -144,   1152,     18,   -144,    180,  -1116,     18,    180,    504,  -1116,   1152,  -9216,   -144,  -1440, &
                  1152,   -144,    180,  -1440,  -1116,  -1278,   -144,     18]
  K1( 789,:) = [  -1116,   8928,  -2412,   -792,  -4032,    504,    180,  -1440,  -1116,  -1278,   -144,     18,   7956,  -2088, &
                 -2412,   9090,   7956,  -2412,   8928,  -1116,  -1440,    180,   -954,    342,  -1278,  10224,   9090,   9252, &
                  8928,  -1116,     18,   -144,    180,     18,   1152,   -144,  -2412,   -792,    342,  -1278,   -954,  -1116, &
                 -1440,    180,  11520,  -1440,   1800,    180,  -1440,  11520,   8928,  10224,   1152,   -144,   -144,   1152, &
                 -1440,   -144,  -9216,   1152,  -4032,   8928,   8928,  -1440,  -1440,   -144,  -9216,   1152,  73728,  -9216, &
                 11520,   1152,  -2088,   2448,   -792,   9252,  -2088,   -792,   7956,  -2088,   -954,  -1116,   -792,    504, &
                   504,  -1116,  -1116,    180,    180,     18,   -792,   -954,   9252,  -1116,   1800,    180,  -1440,    180, &
                  -144,     18,  -1116,  -1278,   -144,     18,   1152,   -144,    180,     18,   1152,   -144,  -9216,   1152, &
                 -1440,   -144,    504,  -1116,  -1116,    180,    180,     18]
  K1( 790,:) = [   -954,  -1116,   7956,  -2088,    504,   -792,  -1116,    180,    504,  -1116,     18,    180,  -2088,   2448, &
                  -792,   9252,  -2088,   -792,  -1116,   9252,    180,   1800,   -792,   -954,    342,  -1278,  -2412,   -792, &
                 -1116,   -954,    180,     18,     18,   -144,   -144,   1152,   9090,   9252,  -1278,  10224,  -1116,   8928, &
                   180,   1800,  -1440,  11520,    180,  -1440,   8928,  -1440,  -4032,   8928,   -144,  -1440,  -1440,   -144, &
                  -144,   1152,   1152,  -9216,   8928,  10224,  -1440,  11520,   -144,   1152,   1152,  11520,  -9216,  73728, &
                  1152,  -9216,   7956,  -2088,  -2412,   9090,   7956,  -2412,  -2412,   -792,  -1116,   8928,    504,  -4032, &
                 -1116,  -1278,    180,  -1440,     18,   -144,   -954,    342,  -1116,   8928,    180,  -1440,    180,  -1116, &
                    18,    180,    504,  -1116,     18,    180,   -144,   1152,     18,   -144,   -144,  -1440,   1152,  -9216, &
                  -144,   1152,  -1116,  -1278,    180,  -1440,     18,   -144]
  K1( 791,:) = [  -2412,   9090,   7956,  -2088,  -2412,   7956,  -1116,  -1278,    180,  -1440,     18,   -144,  -2412,   -792, &
                 -1116,   8928,    504,  -4032,    342,   -954,    180,  -1440,  -1116,   8928,   -792,   9252,  -2088,   2448, &
                  -792,  -2088,    504,  -1116,  -1116,    180,    180,     18,   7956,  -2088,   -954,  -1116,   -792,    504, &
                  -954,   -792,   1800,    180,   9252,  -1116,   8928,  10224,  -1440,  11520,   -144,   1152,  -4032,   8928, &
                  8928,  -1440,  -1440,   -144,   -144,   1152,  -1440,   -144,  -9216,   1152,   1152,  -9216,  11520,   1152, &
                 73728,  -9216,   9090,   9252,  -1278,  10224,  -1116,   8928,  -2412,   -792,    342,  -1278,   -954,  -1116, &
                    18,   -144,    180,     18,   1152,   -144,    180,  -1440,   1800,    180,  11520,  -1440,  -1278,  -1116, &
                    18,   -144,    180,  -1440,  -1116,    504,    180,     18,  -1116,    180,   -144,   1152,  -1440,   -144, &
                 -9216,   1152,     18,   -144,    180,     18,   1152,   -144]
  K1( 792,:) = [   -792,   9252,  -2088,   2448,   -792,  -2088,    504,  -1116,  -1116,    180,    180,     18,   7956,  -2088, &
                  -954,  -1116,   -792,    504,   -954,   -792,   1800,    180,   9252,  -1116,  -2412,   9090,   7956,  -2088, &
                 -2412,   7956,  -1116,  -1278,    180,  -1440,     18,   -144,  -2412,   -792,  -1116,   8928,    504,  -4032, &
                   342,   -954,    180,  -1440,  -1116,   8928,  -4032,   8928,   8928,  -1440,  -1440,   -144,   8928,  10224, &
                 -1440,  11520,   -144,   1152,  -1440,   -144,   -144,   1152,   1152,  -9216,  11520,   1152,   1152,  -9216, &
                 -9216,  73728,  -2412,   -792,    342,  -1278,   -954,  -1116,   9090,   9252,  -1278,  10224,  -1116,   8928, &
                   180,     18,     18,   -144,   -144,   1152,   1800,    180,    180,  -1440,  -1440,  11520,  -1116,    504, &
                   180,     18,  -1116,    180,  -1278,  -1116,     18,   -144,    180,  -1440,  -1440,   -144,   -144,   1152, &
                  1152,  -9216,    180,     18,     18,   -144,   -144,   1152]
  K1( 793,:) = [   -144,     18,   1152,   -144,    180,     18,  -1440,    180,   -144,     18,  -1116,  -1278,  -9216,   1152, &
                  1152,   -144,   -144,  -1440,  -1116,    180,    504,  -1116,     18,    180,  -1440,    180,  11520,  -1440, &
                  1800,    180,   8928,  -1116,  10224,  -1278,   9252,   9090,   1152,   -144,   -144,     18,     18,    180, &
                  -954,  -1116,   -792,  -2412,  -1278,    342,   8928,  -1116,  -1440,    180,   -954,    342,  -4032,    504, &
                  8928,  -1116,   -792,  -2412,   -144,     18,  -1440,    180,  -1278,  -1116,   7956,  -2412,  -2088,   7956, &
                  9090,  -2412,  73728,  -9216,  -9216,   1152,   1152,  11520,  -9216,   1152,   1152,   -144,   -144,  -1440, &
                  1152,   -144,  11520,  -1440,  10224,   8928,   -144,  -1440,  -1440,   8928,   8928,  -4032,   9252,  -1116, &
                  -792,   -954,    180,   1800,   -792,    504,  -2088,   7956,  -1116,   -954,  -2088,   -792,   2448,  -2088, &
                  9252,   -792,     18,    180,    180,  -1116,  -1116,    504]
  K1( 794,:) = [     18,    180,   -144,   1152,     18,   -144,    180,  -1116,     18,    180,    504,  -1116,   1152,  -9216, &
                  -144,  -1440,   1152,   -144,    180,  -1440,  -1116,  -1278,   -144,     18,    180,   1800,  -1440,  11520, &
                   180,  -1440,  -1116,   -954,  -1278,    342,   -792,  -2412,   -144,   1152,     18,    180,   -144,     18, &
                 -1116,   8928,   9252,   9090,  10224,  -1278,  -1116,   9252,    180,   1800,   -792,   -954,    504,   -792, &
                 -1116,   -954,  -2088,   7956,     18,    180,    180,  -1116,  -1116,    504,  -2088,   -792,   2448,  -2088, &
                  9252,   -792,  -9216,  73728,   1152,  11520,  -9216,   1152,   1152,  -9216,   -144,  -1440,   1152,   -144, &
                  -144,  -1440,  -1440,   8928,   8928,  -4032,   1152,   -144,  11520,  -1440,  10224,   8928,  -1116,   8928, &
                  -954,    342,  -1440,    180,    504,  -4032,   -792,  -2412,   8928,  -1116,   7956,  -2412,  -2088,   7956, &
                  9090,  -2412,   -144,     18,  -1440,    180,  -1278,  -1116]
  K1( 795,:) = [  -1440,    180,   -144,     18,  -1116,  -1278,   -144,     18,   1152,   -144,    180,     18,   1152,   -144, &
                 -9216,   1152,  -1440,   -144,    504,  -1116,  -1116,    180,    180,     18,   8928,  -1116,  -1440,    180, &
                  -954,    342,  -4032,    504,   8928,  -1116,   -792,  -2412,   -144,     18,  -1440,    180,  -1278,  -1116, &
                  7956,  -2412,  -2088,   7956,   9090,  -2412,  -1440,    180,  11520,  -1440,   1800,    180,   8928,  -1116, &
                 10224,  -1278,   9252,   9090,   1152,   -144,   -144,     18,     18,    180,   -954,  -1116,   -792,  -2412, &
                 -1278,    342,  -9216,   1152,  73728,  -9216,  11520,   1152,   1152,   -144,  11520,  -1440,  10224,   8928, &
                 -9216,   1152,   1152,   -144,   -144,  -1440,  -1440,   -144,   8928,  -4032,  -1440,   8928,   -792,   -954, &
                  9252,  -1116,   1800,    180,  -2088,   -792,   2448,  -2088,   9252,   -792,   -792,    504,  -2088,   7956, &
                 -1116,   -954,    180,     18,  -1116,    504,    180,  -1116]
  K1( 796,:) = [    180,  -1116,     18,    180,    504,  -1116,     18,    180,   -144,   1152,     18,   -144,   -144,  -1440, &
                  1152,  -9216,   -144,   1152,  -1116,  -1278,    180,  -1440,     18,   -144,  -1116,   9252,    180,   1800, &
                  -792,   -954,    504,   -792,  -1116,   -954,  -2088,   7956,     18,    180,    180,  -1116,  -1116,    504, &
                 -2088,   -792,   2448,  -2088,   9252,   -792,    180,   1800,  -1440,  11520,    180,  -1440,  -1116,   -954, &
                 -1278,    342,   -792,  -2412,   -144,   1152,     18,    180,   -144,     18,  -1116,   8928,   9252,   9090, &
                 10224,  -1278,   1152,  11520,  -9216,  73728,   1152,  -9216,   -144,  -1440,  -1440,   8928,   8928,  -4032, &
                  1152,  -9216,   -144,  -1440,   1152,   -144,   -144,   1152,  10224,   8928,  11520,  -1440,   -954,    342, &
                 -1116,   8928,    180,  -1440,   7956,  -2412,  -2088,   7956,   9090,  -2412,    504,  -4032,   -792,  -2412, &
                  8928,  -1116,     18,   -144,  -1278,  -1116,  -1440,    180]
  K1( 797,:) = [  -1278,  -1116,     18,   -144,    180,  -1440,  -1116,    504,    180,     18,  -1116,    180,   -144,   1152, &
                 -1440,   -144,  -9216,   1152,     18,   -144,    180,     18,   1152,   -144,    342,   -954,    180,  -1440, &
                 -1116,   8928,  -2412,   7956,   9090,  -2412,  -2088,   7956,     18,   -144,  -1278,  -1116,  -1440,    180, &
                   504,  -4032,   -792,  -2412,   8928,  -1116,   -954,   -792,   1800,    180,   9252,  -1116,   -792,  -2088, &
                  9252,   -792,   2448,  -2088,    180,     18,  -1116,    504,    180,  -1116,   -792,    504,  -2088,   7956, &
                 -1116,   -954,   1152,  -9216,  11520,   1152,  73728,  -9216,   -144,   1152,  10224,   8928,  11520,  -1440, &
                 -1440,   -144,   8928,  -4032,  -1440,   8928,  -9216,   1152,   1152,   -144,   -144,  -1440,    180,  -1440, &
                  1800,    180,  11520,  -1440,  -1116,   8928,   9252,   9090,  10224,  -1278,   -954,  -1116,   -792,  -2412, &
                 -1278,    342,   1152,   -144,   -144,     18,     18,    180]
  K1( 798,:) = [  -1116,    504,    180,     18,  -1116,    180,  -1278,  -1116,     18,   -144,    180,  -1440,  -1440,   -144, &
                  -144,   1152,   1152,  -9216,    180,     18,     18,   -144,   -144,   1152,   -954,   -792,   1800,    180, &
                  9252,  -1116,   -792,  -2088,   9252,   -792,   2448,  -2088,    180,     18,  -1116,    504,    180,  -1116, &
                  -792,    504,  -2088,   7956,  -1116,   -954,    342,   -954,    180,  -1440,  -1116,   8928,  -2412,   7956, &
                  9090,  -2412,  -2088,   7956,     18,   -144,  -1278,  -1116,  -1440,    180,    504,  -4032,   -792,  -2412, &
                  8928,  -1116,  11520,   1152,   1152,  -9216,  -9216,  73728,  -1440,   -144,   8928,  -4032,  -1440,   8928, &
                  -144,   1152,  10224,   8928,  11520,  -1440,   1152,  -9216,   -144,  -1440,   1152,   -144,   1800,    180, &
                   180,  -1440,  -1440,  11520,   -954,  -1116,   -792,  -2412,  -1278,    342,  -1116,   8928,   9252,   9090, &
                 10224,  -1278,   -144,   1152,     18,    180,   -144,     18]
  K1( 799,:) = [  -1440,    180,  11520,  -1440,   1800,    180,   8928,  -1116,  10224,  -1278,   9252,   9090,   1152,   -144, &
                  -144,     18,     18,    180,   -954,  -1116,   -792,  -2412,  -1278,    342,   -144,     18,   1152,   -144, &
                   180,     18,  -1440,    180,   -144,     18,  -1116,  -1278,  -9216,   1152,   1152,   -144,   -144,  -1440, &
                 -1116,    180,    504,  -1116,     18,    180,  -4032,    504,   8928,  -1116,   -792,  -2412,   8928,  -1116, &
                 -1440,    180,   -954,    342,  -1440,    180,   -144,     18,  -1116,  -1278,  -2088,   7956,   7956,  -2412, &
                 -2412,   9090,  -9216,   1152,   1152,   -144,   -144,  -1440,  73728,  -9216,  -9216,   1152,   1152,  11520, &
                 11520,  -1440,   1152,   -144,   8928,  10224,  -1440,   8928,   -144,  -1440,  -4032,   8928,   -792,    504, &
                 -2088,   7956,  -1116,   -954,   9252,  -1116,   -792,   -954,    180,   1800,   2448,  -2088,  -2088,   -792, &
                  -792,   9252,    180,  -1116,     18,    180,    504,  -1116]
  K1( 800,:) = [    180,   1800,  -1440,  11520,    180,  -1440,  -1116,   -954,  -1278,    342,   -792,  -2412,   -144,   1152, &
                    18,    180,   -144,     18,  -1116,   8928,   9252,   9090,  10224,  -1278,     18,    180,   -144,   1152, &
                    18,   -144,    180,  -1116,     18,    180,    504,  -1116,   1152,  -9216,   -144,  -1440,   1152,   -144, &
                   180,  -1440,  -1116,  -1278,   -144,     18,    504,   -792,  -1116,   -954,  -2088,   7956,  -1116,   9252, &
                   180,   1800,   -792,   -954,    180,  -1116,     18,    180,    504,  -1116,   2448,  -2088,  -2088,   -792, &
                  -792,   9252,   1152,  -9216,   -144,  -1440,   1152,   -144,  -9216,  73728,   1152,  11520,  -9216,   1152, &
                 -1440,   8928,   -144,  -1440,  -4032,   8928,  11520,  -1440,   1152,   -144,   8928,  10224,    504,  -4032, &
                  -792,  -2412,   8928,  -1116,  -1116,   8928,   -954,    342,  -1440,    180,  -2088,   7956,   7956,  -2412, &
                 -2412,   9090,  -1440,    180,   -144,     18,  -1116,  -1278]
  K1( 801,:) = [   8928,  -1116,  -1440,    180,   -954,    342,  -4032,    504,   8928,  -1116,   -792,  -2412,   -144,     18, &
                 -1440,    180,  -1278,  -1116,   7956,  -2412,  -2088,   7956,   9090,  -2412,  -1440,    180,   -144,     18, &
                 -1116,  -1278,   -144,     18,   1152,   -144,    180,     18,   1152,   -144,  -9216,   1152,  -1440,   -144, &
                   504,  -1116,  -1116,    180,    180,     18,   8928,  -1116,  10224,  -1278,   9252,   9090,  -1440,    180, &
                 11520,  -1440,   1800,    180,   -144,     18,   1152,   -144,    180,     18,   -792,  -2412,   -954,  -1116, &
                   342,  -1278,   1152,   -144,  11520,  -1440,  10224,   8928,  -9216,   1152,  73728,  -9216,  11520,   1152, &
                  1152,   -144,  -9216,   1152,  -1440,   -144,   8928,  -4032,  -1440,   -144,   8928,  -1440,  -2088,   -792, &
                  2448,  -2088,   9252,   -792,   -792,   -954,   9252,  -1116,   1800,    180,  -2088,   7956,   -792,    504, &
                  -954,  -1116,  -1116,    504,    180,     18,  -1116,    180]
  K1( 802,:) = [  -1116,   9252,    180,   1800,   -792,   -954,    504,   -792,  -1116,   -954,  -2088,   7956,     18,    180, &
                   180,  -1116,  -1116,    504,  -2088,   -792,   2448,  -2088,   9252,   -792,    180,  -1116,     18,    180, &
                   504,  -1116,     18,    180,   -144,   1152,     18,   -144,   -144,  -1440,   1152,  -9216,   -144,   1152, &
                 -1116,  -1278,    180,  -1440,     18,   -144,  -1116,   -954,  -1278,    342,   -792,  -2412,    180,   1800, &
                 -1440,  11520,    180,  -1440,     18,    180,   -144,   1152,     18,   -144,   9252,   9090,  -1116,   8928, &
                 -1278,  10224,   -144,  -1440,  -1440,   8928,   8928,  -4032,   1152,  11520,  -9216,  73728,   1152,  -9216, &
                  -144,  -1440,   1152,  -9216,   -144,   1152,  10224,   8928,   -144,   1152,  -1440,  11520,   7956,  -2412, &
                 -2088,   7956,   9090,  -2412,   -954,    342,  -1116,   8928,    180,  -1440,   -792,  -2412,    504,  -4032, &
                 -1116,   8928,  -1278,  -1116,     18,   -144,    180,  -1440]
  K1( 803,:) = [    342,   -954,    180,  -1440,  -1116,   8928,  -2412,   7956,   9090,  -2412,  -2088,   7956,     18,   -144, &
                 -1278,  -1116,  -1440,    180,    504,  -4032,   -792,  -2412,   8928,  -1116,  -1278,  -1116,     18,   -144, &
                   180,  -1440,  -1116,    504,    180,     18,  -1116,    180,   -144,   1152,  -1440,   -144,  -9216,   1152, &
                    18,   -144,    180,     18,   1152,   -144,   -792,  -2088,   9252,   -792,   2448,  -2088,   -954,   -792, &
                  1800,    180,   9252,  -1116,  -1116,    504,    180,     18,  -1116,    180,  -2088,   7956,   -792,    504, &
                  -954,  -1116,   -144,   1152,  10224,   8928,  11520,  -1440,   1152,  -9216,  11520,   1152,  73728,  -9216, &
                  8928,  -4032,  -1440,   -144,   8928,  -1440,   1152,   -144,  -9216,   1152,  -1440,   -144,  -1116,   8928, &
                  9252,   9090,  10224,  -1278,    180,  -1440,   1800,    180,  11520,  -1440,   -792,  -2412,   -954,  -1116, &
                   342,  -1278,   -144,     18,   1152,   -144,    180,     18]
  K1( 804,:) = [   -954,   -792,   1800,    180,   9252,  -1116,   -792,  -2088,   9252,   -792,   2448,  -2088,    180,     18, &
                 -1116,    504,    180,  -1116,   -792,    504,  -2088,   7956,  -1116,   -954,  -1116,    504,    180,     18, &
                 -1116,    180,  -1278,  -1116,     18,   -144,    180,  -1440,  -1440,   -144,   -144,   1152,   1152,  -9216, &
                   180,     18,     18,   -144,   -144,   1152,  -2412,   7956,   9090,  -2412,  -2088,   7956,    342,   -954, &
                   180,  -1440,  -1116,   8928,  -1278,  -1116,     18,   -144,    180,  -1440,   -792,  -2412,    504,  -4032, &
                 -1116,   8928,  -1440,   -144,   8928,  -4032,  -1440,   8928,  11520,   1152,   1152,  -9216,  -9216,  73728, &
                 10224,   8928,   -144,   1152,  -1440,  11520,   -144,  -1440,   1152,  -9216,   -144,   1152,   -954,  -1116, &
                  -792,  -2412,  -1278,    342,   1800,    180,    180,  -1440,  -1440,  11520,   9252,   9090,  -1116,   8928, &
                 -1278,  10224,     18,    180,   -144,   1152,     18,   -144]
  K1( 805,:) = [   8928,  -1116,  10224,  -1278,   9252,   9090,  -1440,    180,  11520,  -1440,   1800,    180,   -144,     18, &
                  1152,   -144,    180,     18,   -792,  -2412,   -954,  -1116,    342,  -1278,  -4032,    504,   8928,  -1116, &
                  -792,  -2412,   8928,  -1116,  -1440,    180,   -954,    342,  -1440,    180,   -144,     18,  -1116,  -1278, &
                 -2088,   7956,   7956,  -2412,  -2412,   9090,   -144,     18,   1152,   -144,    180,     18,  -1440,    180, &
                  -144,     18,  -1116,  -1278,  -9216,   1152,   1152,   -144,   -144,  -1440,  -1116,    180,    504,  -1116, &
                    18,    180,   1152,   -144,  -9216,   1152,  -1440,   -144,  11520,  -1440,   1152,   -144,   8928,  10224, &
                 73728,  -9216,  -9216,   1152,   1152,  11520,   8928,  -1440,  -4032,   8928,   -144,  -1440,  -2088,   7956, &
                  -792,    504,   -954,  -1116,   2448,  -2088,  -2088,   -792,   -792,   9252,   9252,  -1116,   -792,   -954, &
                   180,   1800,  -1116,    180,    504,  -1116,     18,    180]
  K1( 806,:) = [  -1116,   -954,  -1278,    342,   -792,  -2412,    180,   1800,  -1440,  11520,    180,  -1440,     18,    180, &
                  -144,   1152,     18,   -144,   9252,   9090,  -1116,   8928,  -1278,  10224,    504,   -792,  -1116,   -954, &
                 -2088,   7956,  -1116,   9252,    180,   1800,   -792,   -954,    180,  -1116,     18,    180,    504,  -1116, &
                  2448,  -2088,  -2088,   -792,   -792,   9252,     18,    180,   -144,   1152,     18,   -144,    180,  -1116, &
                    18,    180,    504,  -1116,   1152,  -9216,   -144,  -1440,   1152,   -144,    180,  -1440,  -1116,  -1278, &
                  -144,     18,   -144,  -1440,   1152,  -9216,   -144,   1152,  -1440,   8928,   -144,  -1440,  -4032,   8928, &
                 -9216,  73728,   1152,  11520,  -9216,   1152,  -1440,  11520,   8928,  10224,   1152,   -144,   -792,  -2412, &
                   504,  -4032,  -1116,   8928,  -2088,   7956,   7956,  -2412,  -2412,   9090,  -1116,   8928,   -954,    342, &
                 -1440,    180,    180,  -1440,  -1116,  -1278,   -144,     18]
  K1( 807,:) = [  -4032,    504,   8928,  -1116,   -792,  -2412,   8928,  -1116,  -1440,    180,   -954,    342,  -1440,    180, &
                  -144,     18,  -1116,  -1278,  -2088,   7956,   7956,  -2412,  -2412,   9090,   8928,  -1116,  10224,  -1278, &
                  9252,   9090,  -1440,    180,  11520,  -1440,   1800,    180,   -144,     18,   1152,   -144,    180,     18, &
                  -792,  -2412,   -954,  -1116,    342,  -1278,  -1440,    180,   -144,     18,  -1116,  -1278,   -144,     18, &
                  1152,   -144,    180,     18,   1152,   -144,  -9216,   1152,  -1440,   -144,    504,  -1116,  -1116,    180, &
                   180,     18,  11520,  -1440,   1152,   -144,   8928,  10224,   1152,   -144,  -9216,   1152,  -1440,   -144, &
                 -9216,   1152,  73728,  -9216,  11520,   1152,  -4032,   8928,   8928,  -1440,  -1440,   -144,   2448,  -2088, &
                 -2088,   -792,   -792,   9252,  -2088,   7956,   -792,    504,   -954,  -1116,   -792,   -954,   9252,  -1116, &
                  1800,    180,    504,  -1116,  -1116,    180,    180,     18]
  K1( 808,:) = [    504,   -792,  -1116,   -954,  -2088,   7956,  -1116,   9252,    180,   1800,   -792,   -954,    180,  -1116, &
                    18,    180,    504,  -1116,   2448,  -2088,  -2088,   -792,   -792,   9252,  -1116,   -954,  -1278,    342, &
                  -792,  -2412,    180,   1800,  -1440,  11520,    180,  -1440,     18,    180,   -144,   1152,     18,   -144, &
                  9252,   9090,  -1116,   8928,  -1278,  10224,    180,  -1116,     18,    180,    504,  -1116,     18,    180, &
                  -144,   1152,     18,   -144,   -144,  -1440,   1152,  -9216,   -144,   1152,  -1116,  -1278,    180,  -1440, &
                    18,   -144,  -1440,   8928,   -144,  -1440,  -4032,   8928,   -144,  -1440,   1152,  -9216,   -144,   1152, &
                  1152,  11520,  -9216,  73728,   1152,  -9216,   8928,  10224,  -1440,  11520,   -144,   1152,  -2088,   7956, &
                  7956,  -2412,  -2412,   9090,   -792,  -2412,    504,  -4032,  -1116,   8928,   -954,    342,  -1116,   8928, &
                   180,  -1440,  -1116,  -1278,    180,  -1440,     18,   -144]
  K1( 809,:) = [  -2412,   7956,   9090,  -2412,  -2088,   7956,    342,   -954,    180,  -1440,  -1116,   8928,  -1278,  -1116, &
                    18,   -144,    180,  -1440,   -792,  -2412,    504,  -4032,  -1116,   8928,   -792,  -2088,   9252,   -792, &
                  2448,  -2088,   -954,   -792,   1800,    180,   9252,  -1116,  -1116,    504,    180,     18,  -1116,    180, &
                 -2088,   7956,   -792,    504,   -954,  -1116,  -1278,  -1116,     18,   -144,    180,  -1440,  -1116,    504, &
                   180,     18,  -1116,    180,   -144,   1152,  -1440,   -144,  -9216,   1152,     18,   -144,    180,     18, &
                  1152,   -144,  10224,   8928,   -144,   1152,  -1440,  11520,   8928,  -4032,  -1440,   -144,   8928,  -1440, &
                  1152,  -9216,  11520,   1152,  73728,  -9216,   -144,   1152,  -1440,   -144,  -9216,   1152,   9252,   9090, &
                 -1116,   8928,  -1278,  10224,   -792,  -2412,   -954,  -1116,    342,  -1278,    180,  -1440,   1800,    180, &
                 11520,  -1440,     18,   -144,    180,     18,   1152,   -144]
  K1( 810,:) = [   -792,  -2088,   9252,   -792,   2448,  -2088,   -954,   -792,   1800,    180,   9252,  -1116,  -1116,    504, &
                   180,     18,  -1116,    180,  -2088,   7956,   -792,    504,   -954,  -1116,  -2412,   7956,   9090,  -2412, &
                 -2088,   7956,    342,   -954,    180,  -1440,  -1116,   8928,  -1278,  -1116,     18,   -144,    180,  -1440, &
                  -792,  -2412,    504,  -4032,  -1116,   8928,  -1116,    504,    180,     18,  -1116,    180,  -1278,  -1116, &
                    18,   -144,    180,  -1440,  -1440,   -144,   -144,   1152,   1152,  -9216,    180,     18,     18,   -144, &
                  -144,   1152,   8928,  -4032,  -1440,   -144,   8928,  -1440,  10224,   8928,   -144,   1152,  -1440,  11520, &
                 11520,   1152,   1152,  -9216,  -9216,  73728,  -1440,   -144,   -144,   1152,   1152,  -9216,   -792,  -2412, &
                  -954,  -1116,    342,  -1278,   9252,   9090,  -1116,   8928,  -1278,  10224,   1800,    180,    180,  -1440, &
                 -1440,  11520,    180,     18,     18,   -144,   -144,   1152]
  K1( 811,:) = [   9090,   9252,  -1278,  10224,  -1116,   8928,  -2412,   -792,    342,  -1278,   -954,  -1116,     18,   -144, &
                   180,     18,   1152,   -144,    180,  -1440,   1800,    180,  11520,  -1440,  -2412,   -792,  -1116,   8928, &
                   504,  -4032,   7956,  -2088,  -2412,   9090,   7956,  -2412,    180,  -1440,  -1116,  -1278,   -144,     18, &
                 -1116,   8928,   -954,    342,  -1440,    180,   7956,  -2088,   -954,  -1116,   -792,    504,  -2088,   2448, &
                  -792,   9252,  -2088,   -792,  -1116,    180,    504,  -1116,     18,    180,   9252,  -1116,   -792,   -954, &
                   180,   1800,   -144,   1152,  -1440,   -144,  -9216,   1152,  -1440,  11520,   8928,  10224,   1152,   -144, &
                  8928,  -1440,  -4032,   8928,   -144,  -1440,  73728,  -9216,  -9216,   1152,   1152,  11520,     18,   -144, &
                   180,     18,   1152,   -144,    180,  -1440,  -1116,  -1278,   -144,     18,  -1116,    180,    504,  -1116, &
                    18,    180,  -9216,   1152,   1152,   -144,   -144,  -1440]
  K1( 812,:) = [  -2412,   -792,    342,  -1278,   -954,  -1116,   9090,   9252,  -1278,  10224,  -1116,   8928,    180,     18, &
                    18,   -144,   -144,   1152,   1800,    180,    180,  -1440,  -1440,  11520,   7956,  -2088,   -954,  -1116, &
                  -792,    504,  -2088,   2448,   -792,   9252,  -2088,   -792,  -1116,    180,    504,  -1116,     18,    180, &
                  9252,  -1116,   -792,   -954,    180,   1800,  -2412,   -792,  -1116,   8928,    504,  -4032,   7956,  -2088, &
                 -2412,   9090,   7956,  -2412,    180,  -1440,  -1116,  -1278,   -144,     18,  -1116,   8928,   -954,    342, &
                 -1440,    180,  -1440,   -144,   -144,   1152,   1152,  -9216,   8928,  -1440,  -4032,   8928,   -144,  -1440, &
                 -1440,  11520,   8928,  10224,   1152,   -144,  -9216,  73728,   1152,  11520,  -9216,   1152,    180,     18, &
                    18,   -144,   -144,   1152,  -1116,    180,    504,  -1116,     18,    180,    180,  -1440,  -1116,  -1278, &
                  -144,     18,   1152,  -9216,   -144,  -1440,   1152,   -144]
  K1( 813,:) = [  -2412,   -792,  -1116,   8928,    504,  -4032,   7956,  -2088,  -2412,   9090,   7956,  -2412,    180,  -1440, &
                 -1116,  -1278,   -144,     18,  -1116,   8928,   -954,    342,  -1440,    180,   9090,   9252,  -1278,  10224, &
                 -1116,   8928,  -2412,   -792,    342,  -1278,   -954,  -1116,     18,   -144,    180,     18,   1152,   -144, &
                   180,  -1440,   1800,    180,  11520,  -1440,  -2088,   2448,   -792,   9252,  -2088,   -792,   7956,  -2088, &
                  -954,  -1116,   -792,    504,    504,  -1116,  -1116,    180,    180,     18,   -792,   -954,   9252,  -1116, &
                  1800,    180,  -1440,  11520,   8928,  10224,   1152,   -144,   -144,   1152,  -1440,   -144,  -9216,   1152, &
                 -4032,   8928,   8928,  -1440,  -1440,   -144,  -9216,   1152,  73728,  -9216,  11520,   1152,    180,  -1440, &
                 -1116,  -1278,   -144,     18,     18,   -144,    180,     18,   1152,   -144,    504,  -1116,  -1116,    180, &
                   180,     18,   1152,   -144,  -9216,   1152,  -1440,   -144]
  K1( 814,:) = [   7956,  -2088,   -954,  -1116,   -792,    504,  -2088,   2448,   -792,   9252,  -2088,   -792,  -1116,    180, &
                   504,  -1116,     18,    180,   9252,  -1116,   -792,   -954,    180,   1800,  -2412,   -792,    342,  -1278, &
                  -954,  -1116,   9090,   9252,  -1278,  10224,  -1116,   8928,    180,     18,     18,   -144,   -144,   1152, &
                  1800,    180,    180,  -1440,  -1440,  11520,   7956,  -2088,  -2412,   9090,   7956,  -2412,  -2412,   -792, &
                 -1116,   8928,    504,  -4032,  -1116,  -1278,    180,  -1440,     18,   -144,   -954,    342,  -1116,   8928, &
                   180,  -1440,   8928,  -1440,  -4032,   8928,   -144,  -1440,  -1440,   -144,   -144,   1152,   1152,  -9216, &
                  8928,  10224,  -1440,  11520,   -144,   1152,   1152,  11520,  -9216,  73728,   1152,  -9216,  -1116,    180, &
                   504,  -1116,     18,    180,    180,     18,     18,   -144,   -144,   1152,  -1116,  -1278,    180,  -1440, &
                    18,   -144,   -144,  -1440,   1152,  -9216,   -144,   1152]
  K1( 815,:) = [   7956,  -2088,  -2412,   9090,   7956,  -2412,  -2412,   -792,  -1116,   8928,    504,  -4032,  -1116,  -1278, &
                   180,  -1440,     18,   -144,   -954,    342,  -1116,   8928,    180,  -1440,  -2088,   2448,   -792,   9252, &
                 -2088,   -792,   7956,  -2088,   -954,  -1116,   -792,    504,    504,  -1116,  -1116,    180,    180,     18, &
                  -792,   -954,   9252,  -1116,   1800,    180,   9090,   9252,  -1278,  10224,  -1116,   8928,  -2412,   -792, &
                   342,  -1278,   -954,  -1116,     18,   -144,    180,     18,   1152,   -144,    180,  -1440,   1800,    180, &
                 11520,  -1440,   8928,  10224,  -1440,  11520,   -144,   1152,  -4032,   8928,   8928,  -1440,  -1440,   -144, &
                  -144,   1152,  -1440,   -144,  -9216,   1152,   1152,  -9216,  11520,   1152,  73728,  -9216,  -1116,  -1278, &
                   180,  -1440,     18,   -144,    504,  -1116,  -1116,    180,    180,     18,     18,   -144,    180,     18, &
                  1152,   -144,   -144,   1152,  -1440,   -144,  -9216,   1152]
  K1( 816,:) = [  -2088,   2448,   -792,   9252,  -2088,   -792,   7956,  -2088,   -954,  -1116,   -792,    504,    504,  -1116, &
                 -1116,    180,    180,     18,   -792,   -954,   9252,  -1116,   1800,    180,   7956,  -2088,  -2412,   9090, &
                  7956,  -2412,  -2412,   -792,  -1116,   8928,    504,  -4032,  -1116,  -1278,    180,  -1440,     18,   -144, &
                  -954,    342,  -1116,   8928,    180,  -1440,  -2412,   -792,    342,  -1278,   -954,  -1116,   9090,   9252, &
                 -1278,  10224,  -1116,   8928,    180,     18,     18,   -144,   -144,   1152,   1800,    180,    180,  -1440, &
                 -1440,  11520,  -4032,   8928,   8928,  -1440,  -1440,   -144,   8928,  10224,  -1440,  11520,   -144,   1152, &
                 -1440,   -144,   -144,   1152,   1152,  -9216,  11520,   1152,   1152,  -9216,  -9216,  73728,    504,  -1116, &
                 -1116,    180,    180,     18,  -1116,  -1278,    180,  -1440,     18,   -144,    180,     18,     18,   -144, &
                  -144,   1152,  -1440,   -144,   -144,   1152,   1152,  -9216]
  K1( 817,:) = [     18,   -144,    180,     18,   1152,   -144,    180,  -1440,  -1116,  -1278,   -144,     18,  -1116,    180, &
                   504,  -1116,     18,    180,  -9216,   1152,   1152,   -144,   -144,  -1440,    180,  -1440,   1800,    180, &
                 11520,  -1440,  -1116,   8928,   9252,   9090,  10224,  -1278,   -954,  -1116,   -792,  -2412,  -1278,    342, &
                  1152,   -144,   -144,     18,     18,    180,  -1116,   8928,   -954,    342,  -1440,    180,    504,  -4032, &
                  -792,  -2412,   8928,  -1116,   7956,  -2412,  -2088,   7956,   9090,  -2412,   -144,     18,  -1440,    180, &
                 -1278,  -1116,   9252,  -1116,   -792,   -954,    180,   1800,   -792,    504,  -2088,   7956,  -1116,   -954, &
                 -2088,   -792,   2448,  -2088,   9252,   -792,     18,    180,    180,  -1116,  -1116,    504,  73728,  -9216, &
                 -9216,   1152,   1152,  11520,  -9216,   1152,   1152,   -144,   -144,  -1440,   1152,   -144,  11520,  -1440, &
                 10224,   8928,   -144,  -1440,  -1440,   8928,   8928,  -4032]
  K1( 818,:) = [    180,     18,     18,   -144,   -144,   1152,  -1116,    180,    504,  -1116,     18,    180,    180,  -1440, &
                 -1116,  -1278,   -144,     18,   1152,  -9216,   -144,  -1440,   1152,   -144,   1800,    180,    180,  -1440, &
                 -1440,  11520,   -954,  -1116,   -792,  -2412,  -1278,    342,  -1116,   8928,   9252,   9090,  10224,  -1278, &
                  -144,   1152,     18,    180,   -144,     18,   9252,  -1116,   -792,   -954,    180,   1800,   -792,    504, &
                 -2088,   7956,  -1116,   -954,  -2088,   -792,   2448,  -2088,   9252,   -792,     18,    180,    180,  -1116, &
                 -1116,    504,  -1116,   8928,   -954,    342,  -1440,    180,    504,  -4032,   -792,  -2412,   8928,  -1116, &
                  7956,  -2412,  -2088,   7956,   9090,  -2412,   -144,     18,  -1440,    180,  -1278,  -1116,  -9216,  73728, &
                  1152,  11520,  -9216,   1152,   1152,  -9216,   -144,  -1440,   1152,   -144,   -144,  -1440,  -1440,   8928, &
                  8928,  -4032,   1152,   -144,  11520,  -1440,  10224,   8928]
  K1( 819,:) = [    180,  -1440,  -1116,  -1278,   -144,     18,     18,   -144,    180,     18,   1152,   -144,    504,  -1116, &
                 -1116,    180,    180,     18,   1152,   -144,  -9216,   1152,  -1440,   -144,  -1116,   8928,   -954,    342, &
                 -1440,    180,    504,  -4032,   -792,  -2412,   8928,  -1116,   7956,  -2412,  -2088,   7956,   9090,  -2412, &
                  -144,     18,  -1440,    180,  -1278,  -1116,    180,  -1440,   1800,    180,  11520,  -1440,  -1116,   8928, &
                  9252,   9090,  10224,  -1278,   -954,  -1116,   -792,  -2412,  -1278,    342,   1152,   -144,   -144,     18, &
                    18,    180,   -792,   -954,   9252,  -1116,   1800,    180,  -2088,   -792,   2448,  -2088,   9252,   -792, &
                  -792,    504,  -2088,   7956,  -1116,   -954,    180,     18,  -1116,    504,    180,  -1116,  -9216,   1152, &
                 73728,  -9216,  11520,   1152,   1152,   -144,  11520,  -1440,  10224,   8928,  -9216,   1152,   1152,   -144, &
                  -144,  -1440,  -1440,   -144,   8928,  -4032,  -1440,   8928]
  K1( 820,:) = [  -1116,    180,    504,  -1116,     18,    180,    180,     18,     18,   -144,   -144,   1152,  -1116,  -1278, &
                   180,  -1440,     18,   -144,   -144,  -1440,   1152,  -9216,   -144,   1152,   9252,  -1116,   -792,   -954, &
                   180,   1800,   -792,    504,  -2088,   7956,  -1116,   -954,  -2088,   -792,   2448,  -2088,   9252,   -792, &
                    18,    180,    180,  -1116,  -1116,    504,   1800,    180,    180,  -1440,  -1440,  11520,   -954,  -1116, &
                  -792,  -2412,  -1278,    342,  -1116,   8928,   9252,   9090,  10224,  -1278,   -144,   1152,     18,    180, &
                  -144,     18,   -954,    342,  -1116,   8928,    180,  -1440,   7956,  -2412,  -2088,   7956,   9090,  -2412, &
                   504,  -4032,   -792,  -2412,   8928,  -1116,     18,   -144,  -1278,  -1116,  -1440,    180,   1152,  11520, &
                 -9216,  73728,   1152,  -9216,   -144,  -1440,  -1440,   8928,   8928,  -4032,   1152,  -9216,   -144,  -1440, &
                  1152,   -144,   -144,   1152,  10224,   8928,  11520,  -1440]
  K1( 821,:) = [  -1116,  -1278,    180,  -1440,     18,   -144,    504,  -1116,  -1116,    180,    180,     18,     18,   -144, &
                   180,     18,   1152,   -144,   -144,   1152,  -1440,   -144,  -9216,   1152,   -954,    342,  -1116,   8928, &
                   180,  -1440,   7956,  -2412,  -2088,   7956,   9090,  -2412,    504,  -4032,   -792,  -2412,   8928,  -1116, &
                    18,   -144,  -1278,  -1116,  -1440,    180,   -792,   -954,   9252,  -1116,   1800,    180,  -2088,   -792, &
                  2448,  -2088,   9252,   -792,   -792,    504,  -2088,   7956,  -1116,   -954,    180,     18,  -1116,    504, &
                   180,  -1116,    180,  -1440,   1800,    180,  11520,  -1440,  -1116,   8928,   9252,   9090,  10224,  -1278, &
                  -954,  -1116,   -792,  -2412,  -1278,    342,   1152,   -144,   -144,     18,     18,    180,   1152,  -9216, &
                 11520,   1152,  73728,  -9216,   -144,   1152,  10224,   8928,  11520,  -1440,  -1440,   -144,   8928,  -4032, &
                 -1440,   8928,  -9216,   1152,   1152,   -144,   -144,  -1440]
  K1( 822,:) = [    504,  -1116,  -1116,    180,    180,     18,  -1116,  -1278,    180,  -1440,     18,   -144,    180,     18, &
                    18,   -144,   -144,   1152,  -1440,   -144,   -144,   1152,   1152,  -9216,   -792,   -954,   9252,  -1116, &
                  1800,    180,  -2088,   -792,   2448,  -2088,   9252,   -792,   -792,    504,  -2088,   7956,  -1116,   -954, &
                   180,     18,  -1116,    504,    180,  -1116,   -954,    342,  -1116,   8928,    180,  -1440,   7956,  -2412, &
                 -2088,   7956,   9090,  -2412,    504,  -4032,   -792,  -2412,   8928,  -1116,     18,   -144,  -1278,  -1116, &
                 -1440,    180,   1800,    180,    180,  -1440,  -1440,  11520,   -954,  -1116,   -792,  -2412,  -1278,    342, &
                 -1116,   8928,   9252,   9090,  10224,  -1278,   -144,   1152,     18,    180,   -144,     18,  11520,   1152, &
                  1152,  -9216,  -9216,  73728,  -1440,   -144,   8928,  -4032,  -1440,   8928,   -144,   1152,  10224,   8928, &
                 11520,  -1440,   1152,  -9216,   -144,  -1440,   1152,   -144]
  K1( 823,:) = [    180,  -1440,   1800,    180,  11520,  -1440,  -1116,   8928,   9252,   9090,  10224,  -1278,   -954,  -1116, &
                  -792,  -2412,  -1278,    342,   1152,   -144,   -144,     18,     18,    180,     18,   -144,    180,     18, &
                  1152,   -144,    180,  -1440,  -1116,  -1278,   -144,     18,  -1116,    180,    504,  -1116,     18,    180, &
                 -9216,   1152,   1152,   -144,   -144,  -1440,    504,  -4032,   -792,  -2412,   8928,  -1116,  -1116,   8928, &
                  -954,    342,  -1440,    180,  -2088,   7956,   7956,  -2412,  -2412,   9090,  -1440,    180,   -144,     18, &
                 -1116,  -1278,   -792,    504,  -2088,   7956,  -1116,   -954,   9252,  -1116,   -792,   -954,    180,   1800, &
                  2448,  -2088,  -2088,   -792,   -792,   9252,    180,  -1116,     18,    180,    504,  -1116,  -9216,   1152, &
                  1152,   -144,   -144,  -1440,  73728,  -9216,  -9216,   1152,   1152,  11520,  11520,  -1440,   1152,   -144, &
                  8928,  10224,  -1440,   8928,   -144,  -1440,  -4032,   8928]
  K1( 824,:) = [   1800,    180,    180,  -1440,  -1440,  11520,   -954,  -1116,   -792,  -2412,  -1278,    342,  -1116,   8928, &
                  9252,   9090,  10224,  -1278,   -144,   1152,     18,    180,   -144,     18,    180,     18,     18,   -144, &
                  -144,   1152,  -1116,    180,    504,  -1116,     18,    180,    180,  -1440,  -1116,  -1278,   -144,     18, &
                  1152,  -9216,   -144,  -1440,   1152,   -144,   -792,    504,  -2088,   7956,  -1116,   -954,   9252,  -1116, &
                  -792,   -954,    180,   1800,   2448,  -2088,  -2088,   -792,   -792,   9252,    180,  -1116,     18,    180, &
                   504,  -1116,    504,  -4032,   -792,  -2412,   8928,  -1116,  -1116,   8928,   -954,    342,  -1440,    180, &
                 -2088,   7956,   7956,  -2412,  -2412,   9090,  -1440,    180,   -144,     18,  -1116,  -1278,   1152,  -9216, &
                  -144,  -1440,   1152,   -144,  -9216,  73728,   1152,  11520,  -9216,   1152,  -1440,   8928,   -144,  -1440, &
                 -4032,   8928,  11520,  -1440,   1152,   -144,   8928,  10224]
  K1( 825,:) = [  -1116,   8928,   -954,    342,  -1440,    180,    504,  -4032,   -792,  -2412,   8928,  -1116,   7956,  -2412, &
                 -2088,   7956,   9090,  -2412,   -144,     18,  -1440,    180,  -1278,  -1116,    180,  -1440,  -1116,  -1278, &
                  -144,     18,     18,   -144,    180,     18,   1152,   -144,    504,  -1116,  -1116,    180,    180,     18, &
                  1152,   -144,  -9216,   1152,  -1440,   -144,  -1116,   8928,   9252,   9090,  10224,  -1278,    180,  -1440, &
                  1800,    180,  11520,  -1440,   -792,  -2412,   -954,  -1116,    342,  -1278,   -144,     18,   1152,   -144, &
                   180,     18,  -2088,   -792,   2448,  -2088,   9252,   -792,   -792,   -954,   9252,  -1116,   1800,    180, &
                 -2088,   7956,   -792,    504,   -954,  -1116,  -1116,    504,    180,     18,  -1116,    180,   1152,   -144, &
                 11520,  -1440,  10224,   8928,  -9216,   1152,  73728,  -9216,  11520,   1152,   1152,   -144,  -9216,   1152, &
                 -1440,   -144,   8928,  -4032,  -1440,   -144,   8928,  -1440]
  K1( 826,:) = [   9252,  -1116,   -792,   -954,    180,   1800,   -792,    504,  -2088,   7956,  -1116,   -954,  -2088,   -792, &
                  2448,  -2088,   9252,   -792,     18,    180,    180,  -1116,  -1116,    504,  -1116,    180,    504,  -1116, &
                    18,    180,    180,     18,     18,   -144,   -144,   1152,  -1116,  -1278,    180,  -1440,     18,   -144, &
                  -144,  -1440,   1152,  -9216,   -144,   1152,   -954,  -1116,   -792,  -2412,  -1278,    342,   1800,    180, &
                   180,  -1440,  -1440,  11520,   9252,   9090,  -1116,   8928,  -1278,  10224,     18,    180,   -144,   1152, &
                    18,   -144,   7956,  -2412,  -2088,   7956,   9090,  -2412,   -954,    342,  -1116,   8928,    180,  -1440, &
                  -792,  -2412,    504,  -4032,  -1116,   8928,  -1278,  -1116,     18,   -144,    180,  -1440,   -144,  -1440, &
                 -1440,   8928,   8928,  -4032,   1152,  11520,  -9216,  73728,   1152,  -9216,   -144,  -1440,   1152,  -9216, &
                  -144,   1152,  10224,   8928,   -144,   1152,  -1440,  11520]
  K1( 827,:) = [   -954,    342,  -1116,   8928,    180,  -1440,   7956,  -2412,  -2088,   7956,   9090,  -2412,    504,  -4032, &
                  -792,  -2412,   8928,  -1116,     18,   -144,  -1278,  -1116,  -1440,    180,  -1116,  -1278,    180,  -1440, &
                    18,   -144,    504,  -1116,  -1116,    180,    180,     18,     18,   -144,    180,     18,   1152,   -144, &
                  -144,   1152,  -1440,   -144,  -9216,   1152,  -2088,   -792,   2448,  -2088,   9252,   -792,   -792,   -954, &
                  9252,  -1116,   1800,    180,  -2088,   7956,   -792,    504,   -954,  -1116,  -1116,    504,    180,     18, &
                 -1116,    180,  -1116,   8928,   9252,   9090,  10224,  -1278,    180,  -1440,   1800,    180,  11520,  -1440, &
                  -792,  -2412,   -954,  -1116,    342,  -1278,   -144,     18,   1152,   -144,    180,     18,   -144,   1152, &
                 10224,   8928,  11520,  -1440,   1152,  -9216,  11520,   1152,  73728,  -9216,   8928,  -4032,  -1440,   -144, &
                  8928,  -1440,   1152,   -144,  -9216,   1152,  -1440,   -144]
  K1( 828,:) = [   -792,   -954,   9252,  -1116,   1800,    180,  -2088,   -792,   2448,  -2088,   9252,   -792,   -792,    504, &
                 -2088,   7956,  -1116,   -954,    180,     18,  -1116,    504,    180,  -1116,    504,  -1116,  -1116,    180, &
                   180,     18,  -1116,  -1278,    180,  -1440,     18,   -144,    180,     18,     18,   -144,   -144,   1152, &
                 -1440,   -144,   -144,   1152,   1152,  -9216,   7956,  -2412,  -2088,   7956,   9090,  -2412,   -954,    342, &
                 -1116,   8928,    180,  -1440,   -792,  -2412,    504,  -4032,  -1116,   8928,  -1278,  -1116,     18,   -144, &
                   180,  -1440,   -954,  -1116,   -792,  -2412,  -1278,    342,   1800,    180,    180,  -1440,  -1440,  11520, &
                  9252,   9090,  -1116,   8928,  -1278,  10224,     18,    180,   -144,   1152,     18,   -144,  -1440,   -144, &
                  8928,  -4032,  -1440,   8928,  11520,   1152,   1152,  -9216,  -9216,  73728,  10224,   8928,   -144,   1152, &
                 -1440,  11520,   -144,  -1440,   1152,  -9216,   -144,   1152]
  K1( 829,:) = [  -1116,   8928,   9252,   9090,  10224,  -1278,    180,  -1440,   1800,    180,  11520,  -1440,   -792,  -2412, &
                  -954,  -1116,    342,  -1278,   -144,     18,   1152,   -144,    180,     18,    504,  -4032,   -792,  -2412, &
                  8928,  -1116,  -1116,   8928,   -954,    342,  -1440,    180,  -2088,   7956,   7956,  -2412,  -2412,   9090, &
                 -1440,    180,   -144,     18,  -1116,  -1278,     18,   -144,    180,     18,   1152,   -144,    180,  -1440, &
                 -1116,  -1278,   -144,     18,  -1116,    180,    504,  -1116,     18,    180,  -9216,   1152,   1152,   -144, &
                  -144,  -1440,  -2088,   7956,   -792,    504,   -954,  -1116,   2448,  -2088,  -2088,   -792,   -792,   9252, &
                  9252,  -1116,   -792,   -954,    180,   1800,  -1116,    180,    504,  -1116,     18,    180,   1152,   -144, &
                 -9216,   1152,  -1440,   -144,  11520,  -1440,   1152,   -144,   8928,  10224,  73728,  -9216,  -9216,   1152, &
                  1152,  11520,   8928,  -1440,  -4032,   8928,   -144,  -1440]
  K1( 830,:) = [   -954,  -1116,   -792,  -2412,  -1278,    342,   1800,    180,    180,  -1440,  -1440,  11520,   9252,   9090, &
                 -1116,   8928,  -1278,  10224,     18,    180,   -144,   1152,     18,   -144,   -792,    504,  -2088,   7956, &
                 -1116,   -954,   9252,  -1116,   -792,   -954,    180,   1800,   2448,  -2088,  -2088,   -792,   -792,   9252, &
                   180,  -1116,     18,    180,    504,  -1116,    180,     18,     18,   -144,   -144,   1152,  -1116,    180, &
                   504,  -1116,     18,    180,    180,  -1440,  -1116,  -1278,   -144,     18,   1152,  -9216,   -144,  -1440, &
                  1152,   -144,   -792,  -2412,    504,  -4032,  -1116,   8928,  -2088,   7956,   7956,  -2412,  -2412,   9090, &
                 -1116,   8928,   -954,    342,  -1440,    180,    180,  -1440,  -1116,  -1278,   -144,     18,   -144,  -1440, &
                  1152,  -9216,   -144,   1152,  -1440,   8928,   -144,  -1440,  -4032,   8928,  -9216,  73728,   1152,  11520, &
                 -9216,   1152,  -1440,  11520,   8928,  10224,   1152,   -144]
  K1( 831,:) = [    504,  -4032,   -792,  -2412,   8928,  -1116,  -1116,   8928,   -954,    342,  -1440,    180,  -2088,   7956, &
                  7956,  -2412,  -2412,   9090,  -1440,    180,   -144,     18,  -1116,  -1278,  -1116,   8928,   9252,   9090, &
                 10224,  -1278,    180,  -1440,   1800,    180,  11520,  -1440,   -792,  -2412,   -954,  -1116,    342,  -1278, &
                  -144,     18,   1152,   -144,    180,     18,    180,  -1440,  -1116,  -1278,   -144,     18,     18,   -144, &
                   180,     18,   1152,   -144,    504,  -1116,  -1116,    180,    180,     18,   1152,   -144,  -9216,   1152, &
                 -1440,   -144,   2448,  -2088,  -2088,   -792,   -792,   9252,  -2088,   7956,   -792,    504,   -954,  -1116, &
                  -792,   -954,   9252,  -1116,   1800,    180,    504,  -1116,  -1116,    180,    180,     18,  11520,  -1440, &
                  1152,   -144,   8928,  10224,   1152,   -144,  -9216,   1152,  -1440,   -144,  -9216,   1152,  73728,  -9216, &
                 11520,   1152,  -4032,   8928,   8928,  -1440,  -1440,   -144]
  K1( 832,:) = [   -792,    504,  -2088,   7956,  -1116,   -954,   9252,  -1116,   -792,   -954,    180,   1800,   2448,  -2088, &
                 -2088,   -792,   -792,   9252,    180,  -1116,     18,    180,    504,  -1116,   -954,  -1116,   -792,  -2412, &
                 -1278,    342,   1800,    180,    180,  -1440,  -1440,  11520,   9252,   9090,  -1116,   8928,  -1278,  10224, &
                    18,    180,   -144,   1152,     18,   -144,  -1116,    180,    504,  -1116,     18,    180,    180,     18, &
                    18,   -144,   -144,   1152,  -1116,  -1278,    180,  -1440,     18,   -144,   -144,  -1440,   1152,  -9216, &
                  -144,   1152,  -2088,   7956,   7956,  -2412,  -2412,   9090,   -792,  -2412,    504,  -4032,  -1116,   8928, &
                  -954,    342,  -1116,   8928,    180,  -1440,  -1116,  -1278,    180,  -1440,     18,   -144,  -1440,   8928, &
                  -144,  -1440,  -4032,   8928,   -144,  -1440,   1152,  -9216,   -144,   1152,   1152,  11520,  -9216,  73728, &
                  1152,  -9216,   8928,  10224,  -1440,  11520,   -144,   1152]
  K1( 833,:) = [   7956,  -2412,  -2088,   7956,   9090,  -2412,   -954,    342,  -1116,   8928,    180,  -1440,   -792,  -2412, &
                   504,  -4032,  -1116,   8928,  -1278,  -1116,     18,   -144,    180,  -1440,  -2088,   -792,   2448,  -2088, &
                  9252,   -792,   -792,   -954,   9252,  -1116,   1800,    180,  -2088,   7956,   -792,    504,   -954,  -1116, &
                 -1116,    504,    180,     18,  -1116,    180,  -1116,  -1278,    180,  -1440,     18,   -144,    504,  -1116, &
                 -1116,    180,    180,     18,     18,   -144,    180,     18,   1152,   -144,   -144,   1152,  -1440,   -144, &
                 -9216,   1152,   9252,   9090,  -1116,   8928,  -1278,  10224,   -792,  -2412,   -954,  -1116,    342,  -1278, &
                   180,  -1440,   1800,    180,  11520,  -1440,     18,   -144,    180,     18,   1152,   -144,  10224,   8928, &
                  -144,   1152,  -1440,  11520,   8928,  -4032,  -1440,   -144,   8928,  -1440,   1152,  -9216,  11520,   1152, &
                 73728,  -9216,   -144,   1152,  -1440,   -144,  -9216,   1152]
  K1( 834,:) = [  -2088,   -792,   2448,  -2088,   9252,   -792,   -792,   -954,   9252,  -1116,   1800,    180,  -2088,   7956, &
                  -792,    504,   -954,  -1116,  -1116,    504,    180,     18,  -1116,    180,   7956,  -2412,  -2088,   7956, &
                  9090,  -2412,   -954,    342,  -1116,   8928,    180,  -1440,   -792,  -2412,    504,  -4032,  -1116,   8928, &
                 -1278,  -1116,     18,   -144,    180,  -1440,    504,  -1116,  -1116,    180,    180,     18,  -1116,  -1278, &
                   180,  -1440,     18,   -144,    180,     18,     18,   -144,   -144,   1152,  -1440,   -144,   -144,   1152, &
                  1152,  -9216,   -792,  -2412,   -954,  -1116,    342,  -1278,   9252,   9090,  -1116,   8928,  -1278,  10224, &
                  1800,    180,    180,  -1440,  -1440,  11520,    180,     18,     18,   -144,   -144,   1152,   8928,  -4032, &
                 -1440,   -144,   8928,  -1440,  10224,   8928,   -144,   1152,  -1440,  11520,  11520,   1152,   1152,  -9216, &
                 -9216,  73728,  -1440,   -144,   -144,   1152,   1152,  -9216]
  K1( 835,:) = [   9252,   9090,  -1116,   8928,  -1278,  10224,   -792,  -2412,   -954,  -1116,    342,  -1278,    180,  -1440, &
                  1800,    180,  11520,  -1440,     18,   -144,    180,     18,   1152,   -144,   -792,  -2412,    504,  -4032, &
                 -1116,   8928,  -2088,   7956,   7956,  -2412,  -2412,   9090,  -1116,   8928,   -954,    342,  -1440,    180, &
                   180,  -1440,  -1116,  -1278,   -144,     18,  -2088,   7956,   -792,    504,   -954,  -1116,   2448,  -2088, &
                 -2088,   -792,   -792,   9252,   9252,  -1116,   -792,   -954,    180,   1800,  -1116,    180,    504,  -1116, &
                    18,    180,     18,   -144,    180,     18,   1152,   -144,    180,  -1440,  -1116,  -1278,   -144,     18, &
                 -1116,    180,    504,  -1116,     18,    180,  -9216,   1152,   1152,   -144,   -144,  -1440,   -144,   1152, &
                 -1440,   -144,  -9216,   1152,  -1440,  11520,   8928,  10224,   1152,   -144,   8928,  -1440,  -4032,   8928, &
                  -144,  -1440,  73728,  -9216,  -9216,   1152,   1152,  11520]
  K1( 836,:) = [   -792,  -2412,   -954,  -1116,    342,  -1278,   9252,   9090,  -1116,   8928,  -1278,  10224,   1800,    180, &
                   180,  -1440,  -1440,  11520,    180,     18,     18,   -144,   -144,   1152,  -2088,   7956,   -792,    504, &
                  -954,  -1116,   2448,  -2088,  -2088,   -792,   -792,   9252,   9252,  -1116,   -792,   -954,    180,   1800, &
                 -1116,    180,    504,  -1116,     18,    180,   -792,  -2412,    504,  -4032,  -1116,   8928,  -2088,   7956, &
                  7956,  -2412,  -2412,   9090,  -1116,   8928,   -954,    342,  -1440,    180,    180,  -1440,  -1116,  -1278, &
                  -144,     18,    180,     18,     18,   -144,   -144,   1152,  -1116,    180,    504,  -1116,     18,    180, &
                   180,  -1440,  -1116,  -1278,   -144,     18,   1152,  -9216,   -144,  -1440,   1152,   -144,  -1440,   -144, &
                  -144,   1152,   1152,  -9216,   8928,  -1440,  -4032,   8928,   -144,  -1440,  -1440,  11520,   8928,  10224, &
                  1152,   -144,  -9216,  73728,   1152,  11520,  -9216,   1152]
  K1( 837,:) = [   -792,  -2412,    504,  -4032,  -1116,   8928,  -2088,   7956,   7956,  -2412,  -2412,   9090,  -1116,   8928, &
                  -954,    342,  -1440,    180,    180,  -1440,  -1116,  -1278,   -144,     18,   9252,   9090,  -1116,   8928, &
                 -1278,  10224,   -792,  -2412,   -954,  -1116,    342,  -1278,    180,  -1440,   1800,    180,  11520,  -1440, &
                    18,   -144,    180,     18,   1152,   -144,   2448,  -2088,  -2088,   -792,   -792,   9252,  -2088,   7956, &
                  -792,    504,   -954,  -1116,   -792,   -954,   9252,  -1116,   1800,    180,    504,  -1116,  -1116,    180, &
                   180,     18,    180,  -1440,  -1116,  -1278,   -144,     18,     18,   -144,    180,     18,   1152,   -144, &
                   504,  -1116,  -1116,    180,    180,     18,   1152,   -144,  -9216,   1152,  -1440,   -144,  -1440,  11520, &
                  8928,  10224,   1152,   -144,   -144,   1152,  -1440,   -144,  -9216,   1152,  -4032,   8928,   8928,  -1440, &
                 -1440,   -144,  -9216,   1152,  73728,  -9216,  11520,   1152]
  K1( 838,:) = [  -2088,   7956,   -792,    504,   -954,  -1116,   2448,  -2088,  -2088,   -792,   -792,   9252,   9252,  -1116, &
                  -792,   -954,    180,   1800,  -1116,    180,    504,  -1116,     18,    180,   -792,  -2412,   -954,  -1116, &
                   342,  -1278,   9252,   9090,  -1116,   8928,  -1278,  10224,   1800,    180,    180,  -1440,  -1440,  11520, &
                   180,     18,     18,   -144,   -144,   1152,  -2088,   7956,   7956,  -2412,  -2412,   9090,   -792,  -2412, &
                   504,  -4032,  -1116,   8928,   -954,    342,  -1116,   8928,    180,  -1440,  -1116,  -1278,    180,  -1440, &
                    18,   -144,  -1116,    180,    504,  -1116,     18,    180,    180,     18,     18,   -144,   -144,   1152, &
                 -1116,  -1278,    180,  -1440,     18,   -144,   -144,  -1440,   1152,  -9216,   -144,   1152,   8928,  -1440, &
                 -4032,   8928,   -144,  -1440,  -1440,   -144,   -144,   1152,   1152,  -9216,   8928,  10224,  -1440,  11520, &
                  -144,   1152,   1152,  11520,  -9216,  73728,   1152,  -9216]
  K1( 839,:) = [  -2088,   7956,   7956,  -2412,  -2412,   9090,   -792,  -2412,    504,  -4032,  -1116,   8928,   -954,    342, &
                 -1116,   8928,    180,  -1440,  -1116,  -1278,    180,  -1440,     18,   -144,   2448,  -2088,  -2088,   -792, &
                  -792,   9252,  -2088,   7956,   -792,    504,   -954,  -1116,   -792,   -954,   9252,  -1116,   1800,    180, &
                   504,  -1116,  -1116,    180,    180,     18,   9252,   9090,  -1116,   8928,  -1278,  10224,   -792,  -2412, &
                  -954,  -1116,    342,  -1278,    180,  -1440,   1800,    180,  11520,  -1440,     18,   -144,    180,     18, &
                  1152,   -144,  -1116,  -1278,    180,  -1440,     18,   -144,    504,  -1116,  -1116,    180,    180,     18, &
                    18,   -144,    180,     18,   1152,   -144,   -144,   1152,  -1440,   -144,  -9216,   1152,   8928,  10224, &
                 -1440,  11520,   -144,   1152,  -4032,   8928,   8928,  -1440,  -1440,   -144,   -144,   1152,  -1440,   -144, &
                 -9216,   1152,   1152,  -9216,  11520,   1152,  73728,  -9216]
  K1( 840,:) = [   2448,  -2088,  -2088,   -792,   -792,   9252,  -2088,   7956,   -792,    504,   -954,  -1116,   -792,   -954, &
                  9252,  -1116,   1800,    180,    504,  -1116,  -1116,    180,    180,     18,  -2088,   7956,   7956,  -2412, &
                 -2412,   9090,   -792,  -2412,    504,  -4032,  -1116,   8928,   -954,    342,  -1116,   8928,    180,  -1440, &
                 -1116,  -1278,    180,  -1440,     18,   -144,   -792,  -2412,   -954,  -1116,    342,  -1278,   9252,   9090, &
                 -1116,   8928,  -1278,  10224,   1800,    180,    180,  -1440,  -1440,  11520,    180,     18,     18,   -144, &
                  -144,   1152,    504,  -1116,  -1116,    180,    180,     18,  -1116,  -1278,    180,  -1440,     18,   -144, &
                   180,     18,     18,   -144,   -144,   1152,  -1440,   -144,   -144,   1152,   1152,  -9216,  -4032,   8928, &
                  8928,  -1440,  -1440,   -144,   8928,  10224,  -1440,  11520,   -144,   1152,  -1440,   -144,   -144,   1152, &
                  1152,  -9216,  11520,   1152,   1152,  -9216,  -9216,  73728]
  K1( 841,:) = [     72,    720,    720,  -4464,  -4464,   2016,     72,    720,     72,     72,   -576,    720,   -576,     72, &
                   720,    720,   4608,  -4464,   4608,   -576,     72,  -4464,   -576,   2016,     -9,    -90,    -90,    558, &
                   558,   -252,     72,    720,   -576,   4608,     72,   -576,     -9,    -90,     72,   -576,     -9,     72, &
                   639,    558,     -9,     72,    -90,    720,     -9,    -90,     -9,     -9,     72,    -90,     72,    720, &
                   153,   -495,   -657,    882,    639,    639,   -576,   -495,  -4545,   4608,     -9,   -171,    234,   -414, &
                  1206,   -576,     72,     -9,    -90,    -90,   -576,    558,    153,   -657,   -495,   -414,    153,   -495, &
                   558,    558,     72,    882,   1206,   -576,     72,   1206,  -1143,   4041,  -3978,     72,   -576,     72, &
                    -9,    558,     72,   -252,   -495,    882,   -414,   4041,   -495,   -414,    -90,    477,   -576,   -495, &
                 -3978,     72,    720,    396,    234,   -414,   1044,    720]
  K1( 842,:) = [    720,     72,  -4464,   2016,    720,  -4464,    720,     72,   -576,    720,     72,     72,   4608,   -576, &
                    72,  -4464,   -576,   2016,   -576,     72,    720,    720,   4608,  -4464,    -90,     -9,    558,   -252, &
                   -90,    558,    720,     72,     72,   -576,   -576,   4608,    639,    558,     -9,     72,    -90,    720, &
                    -9,    -90,     72,   -576,     -9,     72,    -90,     -9,     72,    -90,     -9,     -9,    720,     72, &
                  -657,    882,    153,   -495,     -9,   -171,    234,   -414,   1206,   -576,    639,    639,   -576,   -495, &
                 -4545,   4608,   -576,     72,     -9,    558,     72,   -252,   -495,    882,   -414,   4041,   -495,   -414, &
                   -90,    477,   -576,   -495,  -3978,     72,    720,    396,    234,   -414,   1044,    720,     72,     -9, &
                   -90,    -90,   -576,    558,    153,   -657,   -495,   -414,    153,   -495,    558,    558,     72,    882, &
                  1206,   -576,     72,   1206,  -1143,   4041,  -3978,     72]
  K1( 843,:) = [    720,  -4464,     72,    720,   2016,  -4464,   -576,     72,    720,    720,   4608,  -4464,     72,    720, &
                    72,     72,   -576,    720,   -576,   4608,   -576,   2016,     72,  -4464,    -90,    558,     -9,    -90, &
                  -252,    558,     -9,    -90,     72,   -576,     -9,     72,     72,    720,   -576,   4608,     72,   -576, &
                   558,    639,    -90,    720,     -9,     72,     72,     -9,    -90,    -90,   -576,    558,    153,   -657, &
                  -495,   -414,    153,   -495,    558,    558,     72,    882,   1206,   -576,     72,   1206,  -1143,   4041, &
                 -3978,     72,     -9,    -90,     -9,     -9,     72,    -90,     72,    720,    153,   -495,   -657,    882, &
                   639,    639,   -576,   -495,  -4545,   4608,     -9,   -171,    234,   -414,   1206,   -576,     72,   -576, &
                    72,   -252,     -9,    558,    882,   -495,   -495,   -414,   -414,   4041,    720,    396,    234,   -414, &
                  1044,    720,    -90,    477,   -576,   -495,  -3978,     72]
  K1( 844,:) = [  -4464,   2016,    720,     72,  -4464,    720,   4608,   -576,     72,  -4464,   -576,   2016,    720,     72, &
                  -576,    720,     72,     72,     72,   -576,   4608,  -4464,    720,    720,    558,   -252,    -90,     -9, &
                   558,    -90,    639,    558,     -9,     72,    -90,    720,    720,     72,     72,   -576,   -576,   4608, &
                   -90,     -9,     -9,     72,     72,   -576,   -576,     72,     -9,    558,     72,   -252,   -495,    882, &
                  -414,   4041,   -495,   -414,    -90,    477,   -576,   -495,  -3978,     72,    720,    396,    234,   -414, &
                  1044,    720,    -90,     -9,     72,    -90,     -9,     -9,    720,     72,   -657,    882,    153,   -495, &
                    -9,   -171,    234,   -414,   1206,   -576,    639,    639,   -576,   -495,  -4545,   4608,     -9,     72, &
                  -576,    558,    -90,    -90,   -657,    153,    153,   -495,   -495,   -414,     72,   1206,  -1143,   4041, &
                 -3978,     72,    558,    558,     72,    882,   1206,   -576]
  K1( 845,:) = [  -4464,    720,   2016,  -4464,     72,    720,     72,   -576,   4608,  -4464,    720,    720,   -576,   4608, &
                  -576,   2016,     72,  -4464,     72,    720,     72,     72,   -576,    720,    558,    -90,   -252,    558, &
                    -9,    -90,    -90,     -9,     -9,     72,     72,   -576,    558,    639,    -90,    720,     -9,     72, &
                    72,    720,   -576,   4608,     72,   -576,     -9,     72,   -576,    558,    -90,    -90,   -657,    153, &
                   153,   -495,   -495,   -414,     72,   1206,  -1143,   4041,  -3978,     72,    558,    558,     72,    882, &
                  1206,   -576,     72,   -576,     72,   -252,     -9,    558,    882,   -495,   -495,   -414,   -414,   4041, &
                   720,    396,    234,   -414,   1044,    720,    -90,    477,   -576,   -495,  -3978,     72,     -9,    -90, &
                    -9,     -9,     72,    -90,     72,    720,    153,   -495,   -657,    882,    639,    639,   -576,   -495, &
                 -4545,   4608,     -9,   -171,    234,   -414,   1206,   -576]
  K1( 846,:) = [   2016,  -4464,  -4464,    720,    720,     72,   -576,   4608,   -576,   2016,     72,  -4464,     72,   -576, &
                  4608,  -4464,    720,    720,    720,     72,   -576,    720,     72,     72,   -252,    558,    558,    -90, &
                   -90,     -9,    558,    639,    -90,    720,     -9,     72,    -90,     -9,     -9,     72,     72,   -576, &
                   720,     72,     72,   -576,   -576,   4608,     72,   -576,     72,   -252,     -9,    558,    882,   -495, &
                  -495,   -414,   -414,   4041,    720,    396,    234,   -414,   1044,    720,    -90,    477,   -576,   -495, &
                 -3978,     72,     -9,     72,   -576,    558,    -90,    -90,   -657,    153,    153,   -495,   -495,   -414, &
                    72,   1206,  -1143,   4041,  -3978,     72,    558,    558,     72,    882,   1206,   -576,    -90,     -9, &
                    72,    -90,     -9,     -9,    720,     72,   -657,    882,    153,   -495,     -9,   -171,    234,   -414, &
                  1206,   -576,    639,    639,   -576,   -495,  -4545,   4608]
  K1( 847,:) = [     72,    720,   -576,   4608,     72,   -576,   -576,  -5760,   -576,   -576,   4608,  -5760,   -576,  -1224, &
                    72,     72,   4608,  -5112,  -1224,   3960,   -576,    720,   -576,  -4464,     -9,    -90,     72,   -576, &
                    -9,     72,    -90,   -900,     -9,   -657,    639,   -738,   -576,   -495,     72,    153,   3960,  -1224, &
                  -657,    153,   -738,     72,  -1224,   -576,     72,    720,     72,     72,   -576,    720,     -9,    -90, &
                    72,   -576,     -9,     72,     -9,     -9,     72,    153,    639,   -576,     72,    -90,    153,   -495, &
                   558,     72,     72,    153,     -9,     -9,   -576,    639,   -576,    234,     72,   -576,  -1143,    234, &
                   -90,    -90,     -9,   -657,   -171,     72,     72,  -4545,   3960,  -1224,   1206,     -9,    153,   -495, &
                    72,    -90,     72,    558,   -495,   -414,    882,   -495,   4041,   -414,    720,   -900,   -657,   -576, &
                   477,     -9,    720,  -4626,  -1224,   -576,    396,    -90]
  K1( 848,:) = [    720,     72,     72,   -576,   -576,   4608,  -5760,   -576,   4608,  -5760,   -576,   -576,  -1224,   3960, &
                  -576,    720,   -576,  -4464,   -576,  -1224,     72,     72,   4608,  -5112,    -90,     -9,     -9,     72, &
                    72,   -576,   -900,    -90,    639,   -738,     -9,   -657,   -657,    153,   -738,     72,  -1224,   -576, &
                  -576,   -495,     72,    153,   3960,  -1224,    720,     72,   -576,    720,     72,     72,    -90,     -9, &
                    -9,     72,     72,   -576,     72,    -90,    153,   -495,    558,     72,     -9,     -9,     72,    153, &
                   639,   -576,    153,   -495,     72,    -90,     72,    558,   -495,   -414,    882,   -495,   4041,   -414, &
                   720,   -900,   -657,   -576,    477,     -9,    720,  -4626,  -1224,   -576,    396,    -90,     72,    153, &
                    -9,     -9,   -576,    639,   -576,    234,     72,   -576,  -1143,    234,    -90,    -90,     -9,   -657, &
                  -171,     72,     72,  -4545,   3960,  -1224,   1206,     -9]
  K1( 849,:) = [     72,   -576,    720,     72,   4608,   -576,   -576,   4608,   4608,   4608,   4608,   -576,     72,   -576, &
                  -576,   -576,   -576,     72,   4608,   -576,   -576,     72,     72,    720,     -9,     72,    -90,     -9, &
                  -576,     72,    -90,    720,    558,    639,     72,     -9,    558,    -90,   -252,    558,     -9,    -90, &
                  4608,   -576,   -576,     72,     72,    720,     72,   -576,   -576,   -576,   -576,     72,     -9,     72, &
                   -90,     -9,   -576,     72,     72,     72,     -9,     72,     -9,     72,     72,     -9,   -576,     72, &
                   -90,     -9,     -9,     72,     72,     72,     72,     -9,    639,     -9,    558,    -90,     72,    720, &
                   720,    720,    -90,    720,    -90,    720,     -9,    639,     72,    720,    558,    -90,   -576,     72, &
                    72,     -9,     -9,    -90,   4608,   -576,   -576,     72,     72,    720,    720,    -90,     72,     -9, &
                   558,    639,    -90,    558,     -9,    -90,   -252,    558]
  K1( 850,:) = [     72,    720,    720,  -4464,  -4464,   2016,   -576,  -5760,   4608, -36864,   -576,   4608,     72,    720, &
                  -576,   4608,     72,   -576,  -5112,  -4464,     72,   -576,    720,  -5760,     -9,    -90,    -90,    558, &
                   558,   -252,    -90,   -900,    558,  -4626,    477,    396,    558,    477,   -252,    396,  -3978,   1044, &
                 -4626,    396,    396,   1044,   1044,  -1224,     72,    720,   -576,   4608,     72,   -576,     -9,    -90, &
                   -90,    558,    558,   -252,     72,   -576,     -9,    -90,     72,     -9,     -9,     72,    639,    558, &
                   720,    -90,     -9,    -90,     72,   -576,     -9,     72,    639,   -171,    558,    477,   1206,    396, &
                   720,  -5760,    -90,   -900,    720,    -90,    639,  -5112,  -4545,  -4626,  -4464,    558,    639,    558, &
                    -9,     72,    -90,    720,  -4545,   1206,   1206,  -3978,  -3978,   1044,    -90,    720,   -171,    477, &
                 -4464,    558,    558,  -4464,   1206,    396,   2016,   -252]
  K1( 851,:) = [   -576,     72,   4608,   -576,    720,     72,   4608,   -576,   4608,   -576,   4608,   4608,   4608,   -576, &
                  -576,     72,     72,    720,     72,   -576,   -576,   -576,   -576,     72,     72,     -9,   -576,     72, &
                   -90,     -9,    720,    -90,     72,     -9,    558,    639,   4608,   -576,   -576,     72,     72,    720, &
                   558,    -90,   -252,    558,     -9,    -90,   -576,     72,   -576,     72,   -576,   -576,     72,     -9, &
                  -576,     72,    -90,     -9,     72,     -9,   -576,     72,    -90,     -9,     72,     72,     -9,     72, &
                    -9,     72,   -576,     72,     72,     -9,     -9,    -90,   4608,   -576,   -576,     72,     72,    720, &
                   720,    -90,     72,     -9,    558,    639,    -90,    558,     -9,    -90,   -252,    558,     -9,     72, &
                    72,     72,     72,     -9,    639,     -9,    558,    -90,     72,    720,    720,    720,    -90,    720, &
                   -90,    720,     -9,    639,     72,    720,    558,    -90]
  K1( 852,:) = [    720,     72,  -4464,   2016,    720,  -4464,  -5760,   -576,   -576,   4608,   4608, -36864,  -5112,  -4464, &
                    72,   -576,    720,  -5760,     72,    720,   -576,   4608,     72,   -576,    -90,     -9,    558,   -252, &
                   -90,    558,   -900,    -90,    477,    396,    558,  -4626,  -4626,    396,    396,   1044,   1044,  -1224, &
                   558,    477,   -252,    396,  -3978,   1044,    720,     72,     72,   -576,   -576,   4608,    -90,     -9, &
                   558,   -252,    -90,    558,     -9,     72,    639,    558,    720,    -90,     72,   -576,     -9,    -90, &
                    72,     -9,    639,    558,     -9,     72,    -90,    720,  -4545,   1206,   1206,  -3978,  -3978,   1044, &
                   -90,    720,   -171,    477,  -4464,    558,    558,  -4464,   1206,    396,   2016,   -252,     -9,    -90, &
                    72,   -576,     -9,     72,    639,   -171,    558,    477,   1206,    396,    720,  -5760,    -90,   -900, &
                   720,    -90,    639,  -5112,  -4545,  -4626,  -4464,    558]
  K1( 853,:) = [   -576,   4608,     72,    720,   -576,     72,   -576,  -1224,     72,     72,   4608,  -5112,   -576,  -5760, &
                  -576,   -576,   4608,  -5760,   3960,  -1224,   -576,  -4464,   -576,    720,     72,   -576,     -9,    -90, &
                    72,     -9,   -576,   -495,     72,    153,   3960,  -1224,    -90,   -900,     -9,   -657,    639,   -738, &
                   153,   -657,  -1224,   -576,   -738,     72,     72,    153,     -9,     -9,   -576,    639,   -576,    234, &
                    72,   -576,  -1143,    234,    -90,    -90,     -9,   -657,   -171,     72,     72,  -4545,   3960,  -1224, &
                  1206,     -9,     72,    720,     72,     72,   -576,    720,     -9,    -90,     72,   -576,     -9,     72, &
                    -9,     -9,     72,    153,    639,   -576,     72,    -90,    153,   -495,    558,     72,   -495,    153, &
                    72,    558,     72,    -90,   -414,   -495,   4041,   -414,    882,   -495,    720,  -4626,  -1224,   -576, &
                   396,    -90,    720,   -900,   -657,   -576,    477,     -9]
  K1( 854,:) = [     72,   -576,    720,     72,   4608,   -576,  -1224,   3960,   -576,    720,   -576,  -4464,  -5760,   -576, &
                  4608,  -5760,   -576,   -576,  -1224,   -576,   4608,  -5112,     72,     72,     -9,     72,    -90,     -9, &
                  -576,     72,   -657,    153,   -738,     72,  -1224,   -576,   -900,    -90,    639,   -738,     -9,   -657, &
                  -495,   -576,   3960,  -1224,     72,    153,    153,   -495,     72,    -90,     72,    558,   -495,   -414, &
                   882,   -495,   4041,   -414,    720,   -900,   -657,   -576,    477,     -9,    720,  -4626,  -1224,   -576, &
                   396,    -90,    720,     72,   -576,    720,     72,     72,    -90,     -9,     -9,     72,     72,   -576, &
                    72,    -90,    153,   -495,    558,     72,     -9,     -9,     72,    153,    639,   -576,    153,     72, &
                  -576,    639,     -9,     -9,    234,   -576,  -1143,    234,     72,   -576,     72,  -4545,   3960,  -1224, &
                  1206,     -9,    -90,    -90,     -9,   -657,   -171,     72]
  K1( 855,:) = [    720,     72,     72,   -576,   -576,   4608,     72,   -576,   -576,   -576,   -576,     72,   -576,   4608, &
                  4608,   4608,   4608,   -576,   -576,   4608,     72,    720,   -576,     72,    -90,     -9,     -9,     72, &
                    72,   -576,    558,    -90,   -252,    558,     -9,    -90,    -90,    720,    558,    639,     72,     -9, &
                  -576,   4608,     72,    720,   -576,     72,     -9,     72,     72,     72,     72,     -9,    639,     -9, &
                   558,    -90,     72,    720,    720,    720,    -90,    720,    -90,    720,     -9,    639,     72,    720, &
                   558,    -90,     72,   -576,   -576,   -576,   -576,     72,     -9,     72,    -90,     -9,   -576,     72, &
                    72,     72,     -9,     72,     -9,     72,     72,     -9,   -576,     72,    -90,     -9,     72,   -576, &
                    -9,    -90,     72,     -9,   -576,   4608,     72,    720,   -576,     72,    -90,    558,     -9,    -90, &
                  -252,    558,    720,    -90,     72,     -9,    558,    639]
  K1( 856,:) = [    720,  -4464,     72,    720,   2016,  -4464,     72,    720,   -576,   4608,     72,   -576,   -576,  -5760, &
                  4608, -36864,   -576,   4608,  -4464,  -5112,    720,  -5760,     72,   -576,    -90,    558,     -9,    -90, &
                  -252,    558,    558,    477,   -252,    396,  -3978,   1044,    -90,   -900,    558,  -4626,    477,    396, &
                   396,  -4626,   1044,  -1224,    396,   1044,     -9,    -90,     72,   -576,     -9,     72,    639,   -171, &
                   558,    477,   1206,    396,    720,  -5760,    -90,   -900,    720,    -90,    639,  -5112,  -4545,  -4626, &
                 -4464,    558,     72,    720,   -576,   4608,     72,   -576,     -9,    -90,    -90,    558,    558,   -252, &
                    72,   -576,     -9,    -90,     72,     -9,     -9,     72,    639,    558,    720,    -90,    558,    639, &
                   -90,    720,     -9,     72,   1206,  -4545,  -3978,   1044,   1206,  -3978,    558,  -4464,   1206,    396, &
                  2016,   -252,    -90,    720,   -171,    477,  -4464,    558]
  K1( 857,:) = [   4608,   -576,   -576,     72,     72,    720,   4608,   -576,   -576,     72,     72,    720,   4608,   -576, &
                  4608,   -576,   4608,   4608,   -576,     72,   -576,     72,   -576,   -576,   -576,     72,     72,     -9, &
                    -9,    -90,   4608,   -576,   -576,     72,     72,    720,    720,    -90,     72,     -9,    558,    639, &
                   -90,    558,     -9,    -90,   -252,    558,   -576,     72,     72,     -9,     -9,    -90,   4608,   -576, &
                  -576,     72,     72,    720,    720,    -90,     72,     -9,    558,    639,    -90,    558,     -9,    -90, &
                  -252,    558,   -576,     72,   -576,     72,   -576,   -576,     72,     -9,   -576,     72,    -90,     -9, &
                    72,     -9,   -576,     72,    -90,     -9,     72,     72,     -9,     72,     -9,     72,     72,     -9, &
                    72,     -9,     72,     72,     -9,    639,     72,    720,    558,    -90,     -9,    639,     72,    720, &
                   558,    -90,    720,    720,    -90,    720,    -90,    720]
  K1( 858,:) = [  -4464,   2016,    720,     72,  -4464,    720,  -5112,  -4464,     72,   -576,    720,  -5760,  -5760,   -576, &
                  -576,   4608,   4608, -36864,    720,     72,     72,   -576,   -576,   4608,    558,   -252,    -90,     -9, &
                   558,    -90,  -4626,    396,    396,   1044,   1044,  -1224,   -900,    -90,    477,    396,    558,  -4626, &
                   477,    558,  -3978,   1044,   -252,    396,    639,    558,     -9,     72,    -90,    720,  -4545,   1206, &
                  1206,  -3978,  -3978,   1044,    -90,    720,   -171,    477,  -4464,    558,    558,  -4464,   1206,    396, &
                  2016,   -252,    720,     72,     72,   -576,   -576,   4608,    -90,     -9,    558,   -252,    -90,    558, &
                    -9,     72,    639,    558,    720,    -90,     72,   -576,     -9,    -90,     72,     -9,    -90,     -9, &
                    -9,     72,     72,   -576,   -171,    639,   1206,    396,    558,    477,    639,  -5112,  -4545,  -4626, &
                 -4464,    558,    720,  -5760,    -90,   -900,    720,    -90]
  K1( 859,:) = [   4608,   -576,   -576,     72,     72,    720,  -1224,   -576,   4608,  -5112,     72,     72,   3960,  -1224, &
                  -576,  -4464,   -576,    720,   -576,  -5760,   -576,   -576,   4608,  -5760,   -576,     72,     72,     -9, &
                    -9,    -90,   -495,   -576,   3960,  -1224,     72,    153,    153,   -657,  -1224,   -576,   -738,     72, &
                   -90,   -900,     -9,   -657,    639,   -738,    153,     72,   -576,    639,     -9,     -9,    234,   -576, &
                 -1143,    234,     72,   -576,     72,  -4545,   3960,  -1224,   1206,     -9,    -90,    -90,     -9,   -657, &
                  -171,     72,   -495,    153,     72,    558,     72,    -90,   -414,   -495,   4041,   -414,    882,   -495, &
                   720,  -4626,  -1224,   -576,    396,    -90,    720,   -900,   -657,   -576,    477,     -9,     72,    720, &
                    72,     72,   -576,    720,     -9,    -90,     72,   -576,     -9,     72,     -9,     -9,     72,    153, &
                   639,   -576,     72,    -90,    153,   -495,    558,     72]
  K1( 860,:) = [   -576,     72,   4608,   -576,    720,     72,   3960,  -1224,   -576,  -4464,   -576,    720,  -1224,   -576, &
                  4608,  -5112,     72,     72,  -5760,   -576,   4608,  -5760,   -576,   -576,     72,     -9,   -576,     72, &
                   -90,     -9,    153,   -657,  -1224,   -576,   -738,     72,   -495,   -576,   3960,  -1224,     72,    153, &
                  -900,    -90,    639,   -738,     -9,   -657,   -495,    153,     72,    558,     72,    -90,   -414,   -495, &
                  4041,   -414,    882,   -495,    720,  -4626,  -1224,   -576,    396,    -90,    720,   -900,   -657,   -576, &
                   477,     -9,    153,     72,   -576,    639,     -9,     -9,    234,   -576,  -1143,    234,     72,   -576, &
                    72,  -4545,   3960,  -1224,   1206,     -9,    -90,    -90,     -9,   -657,   -171,     72,    720,     72, &
                  -576,    720,     72,     72,    -90,     -9,     -9,     72,     72,   -576,     72,    -90,    153,   -495, &
                   558,     72,     -9,     -9,     72,    153,    639,   -576]
  K1( 861,:) = [     72,    720,   -576,   4608,     72,   -576,   -576,     72,   -576,     72,   -576,   -576,   -576,   4608, &
                    72,    720,   -576,     72,   -576,   4608,   4608,   4608,   4608,   -576,     -9,    -90,     72,   -576, &
                    -9,     72,    -90,    558,     -9,    -90,   -252,    558,   -576,   4608,     72,    720,   -576,     72, &
                   -90,    720,    558,    639,     72,     -9,     72,     -9,     72,     -9,     72,     72,     -9,    639, &
                    72,    720,    558,    -90,     -9,    639,     72,    720,    558,    -90,    720,    720,    -90,    720, &
                   -90,    720,     72,   -576,     -9,    -90,     72,     -9,   -576,   4608,     72,    720,   -576,     72, &
                   -90,    558,     -9,    -90,   -252,    558,    720,    -90,     72,     -9,    558,    639,     72,   -576, &
                  -576,   -576,   -576,     72,     -9,     72,    -90,     -9,   -576,     72,     72,     72,     -9,     72, &
                    -9,     72,     72,     -9,   -576,     72,    -90,     -9]
  K1( 862,:) = [  -4464,    720,   2016,  -4464,     72,    720,    720,     72,     72,   -576,   -576,   4608,  -4464,  -5112, &
                   720,  -5760,     72,   -576,   -576,  -5760,   4608, -36864,   -576,   4608,    558,    -90,   -252,    558, &
                    -9,    -90,    477,    558,  -3978,   1044,   -252,    396,    396,  -4626,   1044,  -1224,    396,   1044, &
                   -90,   -900,    558,  -4626,    477,    396,    -90,     -9,     -9,     72,     72,   -576,   -171,    639, &
                  1206,    396,    558,    477,    639,  -5112,  -4545,  -4626,  -4464,    558,    720,  -5760,    -90,   -900, &
                   720,    -90,    558,    639,    -90,    720,     -9,     72,   1206,  -4545,  -3978,   1044,   1206,  -3978, &
                   558,  -4464,   1206,    396,   2016,   -252,    -90,    720,   -171,    477,  -4464,    558,     72,    720, &
                  -576,   4608,     72,   -576,     -9,    -90,    -90,    558,    558,   -252,     72,   -576,     -9,    -90, &
                    72,     -9,     -9,     72,    639,    558,    720,    -90]
  K1( 863,:) = [   -576,   4608,     72,    720,   -576,     72,   -576,   4608,     72,    720,   -576,     72,   -576,     72, &
                  -576,     72,   -576,   -576,   4608,   -576,   4608,   -576,   4608,   4608,     72,   -576,     -9,    -90, &
                    72,     -9,   -576,   4608,     72,    720,   -576,     72,    -90,    558,     -9,    -90,   -252,    558, &
                   720,    -90,     72,     -9,    558,    639,     72,   -576,     -9,    -90,     72,     -9,   -576,   4608, &
                    72,    720,   -576,     72,    -90,    558,     -9,    -90,   -252,    558,    720,    -90,     72,     -9, &
                   558,    639,     72,     -9,     72,     -9,     72,     72,     -9,    639,     72,    720,    558,    -90, &
                    -9,    639,     72,    720,    558,    -90,    720,    720,    -90,    720,    -90,    720,   -576,     72, &
                  -576,     72,   -576,   -576,     72,     -9,   -576,     72,    -90,     -9,     72,     -9,   -576,     72, &
                   -90,     -9,     72,     72,     -9,     72,     -9,     72]
  K1( 864,:) = [   2016,  -4464,  -4464,    720,    720,     72,  -4464,  -5112,    720,  -5760,     72,   -576,    720,     72, &
                    72,   -576,   -576,   4608,  -5760,   -576,   -576,   4608,   4608, -36864,   -252,    558,    558,    -90, &
                   -90,     -9,    396,  -4626,   1044,  -1224,    396,   1044,    477,    558,  -3978,   1044,   -252,    396, &
                  -900,    -90,    477,    396,    558,  -4626,    558,    639,    -90,    720,     -9,     72,   1206,  -4545, &
                 -3978,   1044,   1206,  -3978,    558,  -4464,   1206,    396,   2016,   -252,    -90,    720,   -171,    477, &
                 -4464,    558,    -90,     -9,     -9,     72,     72,   -576,   -171,    639,   1206,    396,    558,    477, &
                   639,  -5112,  -4545,  -4626,  -4464,    558,    720,  -5760,    -90,   -900,    720,    -90,    720,     72, &
                    72,   -576,   -576,   4608,    -90,     -9,    558,   -252,    -90,    558,     -9,     72,    639,    558, &
                   720,    -90,     72,   -576,     -9,    -90,     72,     -9]
  K1( 865,:) = [     -9,    -90,    -90,    558,    558,   -252,     -9,    -90,     -9,     -9,     72,    -90,     72,     -9, &
                   -90,    -90,   -576,    558,   -576,     72,     -9,    558,     72,   -252,     -9,    -90,    -90,    558, &
                   558,   -252,    -90,   -900,    558,  -4626,    477,    396,    558,    477,   -252,    396,  -3978,   1044, &
                 -4626,    396,    396,   1044,   1044,  -1224,    -90,   -900,    -90,    -90,    720,   -900,     72,    720, &
                    -9,    639,    -90,    558,    558,    558,   -576,   -657,  -4626,   4608,    -90,    477,   -495,    153, &
                   396,   -576,     -9,    639,    558,    558,     72,    477,   -576,     72,     72,     -9,     -9,    -90, &
                  -252,   -252,     72,   -738,    396,   -576,     -9,  -3978,   3960,  -1224,   1044,     72,   -657,   -738, &
                   639,  -4626,     -9,    396,   4608,   -576,   -576,     72,     72,    720,    558,    396,    153,     72, &
                  1044,     72,    -90,   1044,  -1224,   -576,  -1224,    720]
  K1( 866,:) = [    -90,     -9,    558,   -252,    -90,    558,    -90,     -9,     72,    -90,     -9,     -9,   -576,     72, &
                    -9,    558,     72,   -252,     72,     -9,    -90,    -90,   -576,    558,    -90,     -9,    558,   -252, &
                   -90,    558,   -900,    -90,    477,    396,    558,  -4626,  -4626,    396,    396,   1044,   1044,  -1224, &
                   558,    477,   -252,    396,  -3978,   1044,   -900,    -90,    720,   -900,    -90,    -90,    720,     72, &
                   -90,    558,     -9,    639,    -90,    477,   -495,    153,    396,   -576,    558,    558,   -576,   -657, &
                 -4626,   4608,   -657,   -738,    639,  -4626,     -9,    396,   4608,   -576,   -576,     72,     72,    720, &
                   558,    396,    153,     72,   1044,     72,    -90,   1044,  -1224,   -576,  -1224,    720,     -9,    639, &
                   558,    558,     72,    477,   -576,     72,     72,     -9,     -9,    -90,   -252,   -252,     72,   -738, &
                   396,   -576,     -9,  -3978,   3960,  -1224,   1044,     72]
  K1( 867,:) = [    -90,    558,     -9,    -90,   -252,    558,     72,     -9,    -90,    -90,   -576,    558,     -9,    -90, &
                    -9,     -9,     72,    -90,     72,   -576,     72,   -252,     -9,    558,    -90,    558,     -9,    -90, &
                  -252,    558,    558,    477,   -252,    396,  -3978,   1044,    -90,   -900,    558,  -4626,    477,    396, &
                   396,  -4626,   1044,  -1224,    396,   1044,     -9,    639,    558,    558,     72,    477,   -576,     72, &
                    72,     -9,     -9,    -90,   -252,   -252,     72,   -738,    396,   -576,     -9,  -3978,   3960,  -1224, &
                  1044,     72,    -90,   -900,    -90,    -90,    720,   -900,     72,    720,     -9,    639,    -90,    558, &
                   558,    558,   -576,   -657,  -4626,   4608,    -90,    477,   -495,    153,    396,   -576,   -738,   -657, &
                    -9,    396,    639,  -4626,   -576,   4608,     72,    720,   -576,     72,    -90,   1044,  -1224,   -576, &
                 -1224,    720,    558,    396,    153,     72,   1044,     72]
  K1( 868,:) = [    558,   -252,    -90,     -9,    558,    -90,   -576,     72,     -9,    558,     72,   -252,    -90,     -9, &
                    72,    -90,     -9,     -9,     -9,     72,   -576,    558,    -90,    -90,    558,   -252,    -90,     -9, &
                   558,    -90,  -4626,    396,    396,   1044,   1044,  -1224,   -900,    -90,    477,    396,    558,  -4626, &
                   477,    558,  -3978,   1044,   -252,    396,   -657,   -738,    639,  -4626,     -9,    396,   4608,   -576, &
                  -576,     72,     72,    720,    558,    396,    153,     72,   1044,     72,    -90,   1044,  -1224,   -576, &
                 -1224,    720,   -900,    -90,    720,   -900,    -90,    -90,    720,     72,    -90,    558,     -9,    639, &
                   -90,    477,   -495,    153,    396,   -576,    558,    558,   -576,   -657,  -4626,   4608,    639,     -9, &
                    72,    477,    558,    558,     72,   -576,     -9,    -90,     72,     -9,     -9,  -3978,   3960,  -1224, &
                  1044,     72,   -252,   -252,     72,   -738,    396,   -576]
  K1( 869,:) = [    558,    -90,   -252,    558,     -9,    -90,     -9,     72,   -576,    558,    -90,    -90,     72,   -576, &
                    72,   -252,     -9,    558,     -9,    -90,     -9,     -9,     72,    -90,    558,    -90,   -252,    558, &
                    -9,    -90,    477,    558,  -3978,   1044,   -252,    396,    396,  -4626,   1044,  -1224,    396,   1044, &
                   -90,   -900,    558,  -4626,    477,    396,    639,     -9,     72,    477,    558,    558,     72,   -576, &
                    -9,    -90,     72,     -9,     -9,  -3978,   3960,  -1224,   1044,     72,   -252,   -252,     72,   -738, &
                   396,   -576,   -738,   -657,     -9,    396,    639,  -4626,   -576,   4608,     72,    720,   -576,     72, &
                   -90,   1044,  -1224,   -576,  -1224,    720,    558,    396,    153,     72,   1044,     72,    -90,   -900, &
                   -90,    -90,    720,   -900,     72,    720,     -9,    639,    -90,    558,    558,    558,   -576,   -657, &
                 -4626,   4608,    -90,    477,   -495,    153,    396,   -576]
  K1( 870,:) = [   -252,    558,    558,    -90,    -90,     -9,     72,   -576,     72,   -252,     -9,    558,     -9,     72, &
                  -576,    558,    -90,    -90,    -90,     -9,     72,    -90,     -9,     -9,   -252,    558,    558,    -90, &
                   -90,     -9,    396,  -4626,   1044,  -1224,    396,   1044,    477,    558,  -3978,   1044,   -252,    396, &
                  -900,    -90,    477,    396,    558,  -4626,   -738,   -657,     -9,    396,    639,  -4626,   -576,   4608, &
                    72,    720,   -576,     72,    -90,   1044,  -1224,   -576,  -1224,    720,    558,    396,    153,     72, &
                  1044,     72,    639,     -9,     72,    477,    558,    558,     72,   -576,     -9,    -90,     72,     -9, &
                    -9,  -3978,   3960,  -1224,   1044,     72,   -252,   -252,     72,   -738,    396,   -576,   -900,    -90, &
                   720,   -900,    -90,    -90,    720,     72,    -90,    558,     -9,    639,    -90,    477,   -495,    153, &
                   396,   -576,    558,    558,   -576,   -657,  -4626,   4608]
  K1( 871,:) = [     72,    720,     -9,    639,    -90,    558,    -90,   -900,    -90,    -90,    720,   -900,   -576,   -657, &
                   558,    558,   4608,  -4626,   -495,    153,    -90,    477,   -576,    396,    -90,   -900,    558,  -4626, &
                   477,    396,     -9,    -90,    -90,    558,    558,   -252,   -252,    396,    558,    477,   1044,  -3978, &
                   396,   1044,  -4626,    396,  -1224,   1044,     -9,    -90,     -9,     -9,     72,    -90,     -9,    -90, &
                   -90,    558,    558,   -252,    -90,    -90,     72,     -9,    558,   -576,     -9,    558,   -576,     72, &
                  -252,     72,     72,   -738,   -252,   -252,   -576,    396,     72,     -9,   -576,     72,    -90,     -9, &
                   558,    558,     -9,    639,    477,     72,     72,   1044,  -1224,   3960,  -3978,     -9,    153,     72, &
                   558,    396,     72,   1044,   -576,     72,   4608,   -576,    720,     72,    639,  -4626,   -657,   -738, &
                   396,     -9,    720,  -1224,   -576,  -1224,   1044,    -90]
  K1( 872,:) = [    720,     72,    -90,    558,     -9,    639,   -900,    -90,    720,   -900,    -90,    -90,   -495,    153, &
                   -90,    477,   -576,    396,   -576,   -657,    558,    558,   4608,  -4626,   -900,    -90,    477,    396, &
                   558,  -4626,    -90,     -9,    558,   -252,    -90,    558,    396,   1044,  -4626,    396,  -1224,   1044, &
                  -252,    396,    558,    477,   1044,  -3978,    -90,     -9,     72,    -90,     -9,     -9,    -90,     -9, &
                   558,   -252,    -90,    558,     -9,    558,   -576,     72,   -252,     72,    -90,    -90,     72,     -9, &
                   558,   -576,    153,     72,    558,    396,     72,   1044,   -576,     72,   4608,   -576,    720,     72, &
                   639,  -4626,   -657,   -738,    396,     -9,    720,  -1224,   -576,  -1224,   1044,    -90,     72,   -738, &
                  -252,   -252,   -576,    396,     72,     -9,   -576,     72,    -90,     -9,    558,    558,     -9,    639, &
                   477,     72,     72,   1044,  -1224,   3960,  -3978,     -9]
  K1( 873,:) = [   -576,     72,     72,     -9,     -9,    -90,     -9,    639,    558,    558,     72,    477,     72,   -738, &
                  -252,   -252,   -576,    396,   3960,  -1224,     -9,  -3978,     72,   1044,    558,    477,   -252,    396, &
                 -3978,   1044,    -90,    558,     -9,    -90,   -252,    558,    558,  -4626,    -90,   -900,    396,    477, &
                  1044,  -1224,    396,  -4626,   1044,    396,     72,     -9,    -90,    -90,   -576,    558,    -90,    558, &
                    -9,    -90,   -252,    558,     -9,     -9,     -9,    -90,    -90,     72,     72,   -252,     72,   -576, &
                   558,     -9,   -576,   -657,    558,    558,   4608,  -4626,     -9,    639,     72,    720,    558,    -90, &
                   -90,    -90,    -90,   -900,   -900,    720,   -576,    396,    153,   -495,    477,    -90,  -1224,   -576, &
                   -90,   1044,    720,  -1224,     72,    720,   -576,   4608,     72,   -576,     -9,    396,   -738,   -657, &
                 -4626,    639,     72,   1044,     72,    153,    396,    558]
  K1( 874,:) = [   4608,   -576,   -576,     72,     72,    720,   -657,   -738,    639,  -4626,     -9,    396,    153,     72, &
                   558,    396,     72,   1044,  -1224,   -576,    -90,   1044,    720,  -1224,  -4626,    396,    396,   1044, &
                  1044,  -1224,    558,   -252,    -90,     -9,    558,    -90,    477,    396,   -900,    -90,  -4626,    558, &
                 -3978,   1044,    477,    558,    396,   -252,   -576,     72,     -9,    558,     72,   -252,    558,   -252, &
                   -90,     -9,    558,    -90,     72,    -90,    -90,     -9,     -9,     -9,   -576,    558,     -9,     72, &
                   -90,    -90,   -495,    153,    -90,    477,   -576,    396,    -90,    558,    720,     72,    639,     -9, &
                   720,   -900,   -900,    -90,    -90,    -90,   4608,  -4626,   -657,   -576,    558,    558,   3960,  -1224, &
                    -9,  -3978,     72,   1044,     -9,    -90,     72,   -576,     -9,     72,     72,    477,    639,     -9, &
                   558,    558,   -576,    396,   -738,     72,   -252,   -252]
  K1( 875,:) = [     72,   -576,     -9,    -90,     72,     -9,    639,     -9,     72,    477,    558,    558,   3960,  -1224, &
                    -9,  -3978,     72,   1044,     72,   -738,   -252,   -252,   -576,    396,    477,    558,  -3978,   1044, &
                  -252,    396,    558,    -90,   -252,    558,     -9,    -90,   1044,  -1224,    396,  -4626,   1044,    396, &
                   558,  -4626,    -90,   -900,    396,    477,     -9,     72,   -576,    558,    -90,    -90,    558,    -90, &
                  -252,    558,     -9,    -90,     72,   -252,     72,   -576,    558,     -9,     -9,     -9,     -9,    -90, &
                   -90,     72,  -1224,   -576,    -90,   1044,    720,  -1224,     72,    720,   -576,   4608,     72,   -576, &
                    -9,    396,   -738,   -657,  -4626,    639,     72,   1044,     72,    153,    396,    558,   -576,   -657, &
                   558,    558,   4608,  -4626,     -9,    639,     72,    720,    558,    -90,    -90,    -90,    -90,   -900, &
                  -900,    720,   -576,    396,    153,   -495,    477,    -90]
  K1( 876,:) = [   -576,   4608,     72,    720,   -576,     72,   -738,   -657,     -9,    396,    639,  -4626,  -1224,   -576, &
                   -90,   1044,    720,  -1224,    153,     72,    558,    396,     72,   1044,    396,  -4626,   1044,  -1224, &
                   396,   1044,   -252,    558,    558,    -90,    -90,     -9,  -3978,   1044,    477,    558,    396,   -252, &
                   477,    396,   -900,    -90,  -4626,    558,     72,   -576,     72,   -252,     -9,    558,   -252,    558, &
                   558,    -90,    -90,     -9,   -576,    558,     -9,     72,    -90,    -90,     72,    -90,    -90,     -9, &
                    -9,     -9,   3960,  -1224,     -9,  -3978,     72,   1044,     -9,    -90,     72,   -576,     -9,     72, &
                    72,    477,    639,     -9,    558,    558,   -576,    396,   -738,     72,   -252,   -252,   -495,    153, &
                   -90,    477,   -576,    396,    -90,    558,    720,     72,    639,     -9,    720,   -900,   -900,    -90, &
                   -90,    -90,   4608,  -4626,   -657,   -576,    558,    558]
  K1( 877,:) = [     -9,    639,     72,    720,    558,    -90,   -576,   -657,    558,    558,   4608,  -4626,    -90,   -900, &
                   -90,    -90,    720,   -900,    153,   -495,   -576,    396,    -90,    477,    558,  -4626,    -90,   -900, &
                   396,    477,   -252,    396,    558,    477,   1044,  -3978,     -9,    -90,    -90,    558,    558,   -252, &
                  1044,    396,  -1224,   1044,  -4626,    396,     72,   -738,   -252,   -252,   -576,    396,     72,     -9, &
                  -576,     72,    -90,     -9,    558,    558,     -9,    639,    477,     72,     72,   1044,  -1224,   3960, &
                 -3978,     -9,     -9,    -90,     -9,     -9,     72,    -90,     -9,    -90,    -90,    558,    558,   -252, &
                   -90,    -90,     72,     -9,    558,   -576,     -9,    558,   -576,     72,   -252,     72,     72,    153, &
                    72,   1044,    558,    396,     72,   -576,    720,     72,   4608,   -576,    720,  -1224,   -576,  -1224, &
                  1044,    -90,    639,  -4626,   -657,   -738,    396,     -9]
  K1( 878,:) = [    -90,    558,    720,     72,    639,     -9,   -495,    153,    -90,    477,   -576,    396,   -900,    -90, &
                   720,   -900,    -90,    -90,   -657,   -576,   4608,  -4626,    558,    558,    477,    396,   -900,    -90, &
                 -4626,    558,    396,   1044,  -4626,    396,  -1224,   1044,    -90,     -9,    558,   -252,    -90,    558, &
                   396,   -252,   1044,  -3978,    558,    477,    153,     72,    558,    396,     72,   1044,   -576,     72, &
                  4608,   -576,    720,     72,    639,  -4626,   -657,   -738,    396,     -9,    720,  -1224,   -576,  -1224, &
                  1044,    -90,    -90,     -9,     72,    -90,     -9,     -9,    -90,     -9,    558,   -252,    -90,    558, &
                    -9,    558,   -576,     72,   -252,     72,    -90,    -90,     72,     -9,    558,   -576,   -738,     72, &
                  -576,    396,   -252,   -252,     -9,     72,    -90,     -9,   -576,     72,     72,   1044,  -1224,   3960, &
                 -3978,     -9,    558,    558,     -9,    639,    477,     72]
  K1( 879,:) = [     72,     -9,   -576,     72,    -90,     -9,     72,   -738,   -252,   -252,   -576,    396,     -9,    639, &
                   558,    558,     72,    477,  -1224,   3960,     72,   1044,     -9,  -3978,   -252,    396,    558,    477, &
                  1044,  -3978,    558,  -4626,    -90,   -900,    396,    477,    -90,    558,     -9,    -90,   -252,    558, &
                 -1224,   1044,   1044,    396,    396,  -4626,   -576,   -657,    558,    558,   4608,  -4626,     -9,    639, &
                    72,    720,    558,    -90,    -90,    -90,    -90,   -900,   -900,    720,   -576,    396,    153,   -495, &
                   477,    -90,     72,     -9,    -90,    -90,   -576,    558,    -90,    558,     -9,    -90,   -252,    558, &
                    -9,     -9,     -9,    -90,    -90,     72,     72,   -252,     72,   -576,    558,     -9,   -576,  -1224, &
                   720,  -1224,    -90,   1044,    720,     72,     72,   -576,   -576,   4608,     72,   1044,     72,    153, &
                   396,    558,     -9,    396,   -738,   -657,  -4626,    639]
  K1( 880,:) = [   -576,     72,   4608,   -576,    720,     72,    153,     72,    558,    396,     72,   1044,   -657,   -738, &
                   639,  -4626,     -9,    396,   -576,  -1224,    720,  -1224,    -90,   1044,    396,   1044,  -4626,    396, &
                 -1224,   1044,    477,    396,   -900,    -90,  -4626,    558,    558,   -252,    -90,     -9,    558,    -90, &
                  1044,  -3978,    396,   -252,    477,    558,   -495,    153,    -90,    477,   -576,    396,    -90,    558, &
                   720,     72,    639,     -9,    720,   -900,   -900,    -90,    -90,    -90,   4608,  -4626,   -657,   -576, &
                   558,    558,   -576,     72,     -9,    558,     72,   -252,    558,   -252,    -90,     -9,    558,    -90, &
                    72,    -90,    -90,     -9,     -9,     -9,   -576,    558,     -9,     72,    -90,    -90,  -1224,   3960, &
                    72,   1044,     -9,  -3978,    -90,     -9,     -9,     72,     72,   -576,   -576,    396,   -738,     72, &
                  -252,   -252,     72,    477,    639,     -9,    558,    558]
  K1( 881,:) = [     -9,    -90,     72,   -576,     -9,     72,   3960,  -1224,     -9,  -3978,     72,   1044,    639,     -9, &
                    72,    477,    558,    558,   -738,     72,   -576,    396,   -252,   -252,  -3978,   1044,    477,    558, &
                   396,   -252,   1044,  -1224,    396,  -4626,   1044,    396,    558,    -90,   -252,    558,     -9,    -90, &
                 -4626,    558,    396,    477,    -90,   -900,  -1224,   -576,    -90,   1044,    720,  -1224,     72,    720, &
                  -576,   4608,     72,   -576,     -9,    396,   -738,   -657,  -4626,    639,     72,   1044,     72,    153, &
                   396,    558,     -9,     72,   -576,    558,    -90,    -90,    558,    -90,   -252,    558,     -9,    -90, &
                    72,   -252,     72,   -576,    558,     -9,     -9,     -9,     -9,    -90,    -90,     72,   -657,   -576, &
                  4608,  -4626,    558,    558,    639,     -9,    558,    -90,     72,    720,   -576,    396,    153,   -495, &
                   477,    -90,    -90,    -90,    -90,   -900,   -900,    720]
  K1( 882,:) = [     72,    720,   -576,   4608,     72,   -576,  -1224,   -576,    -90,   1044,    720,  -1224,   -738,   -657, &
                    -9,    396,    639,  -4626,     72,    153,     72,   1044,    558,    396,   1044,  -1224,    396,  -4626, &
                  1044,    396,  -3978,   1044,    477,    558,    396,   -252,   -252,    558,    558,    -90,    -90,     -9, &
                   396,    477,  -4626,    558,   -900,    -90,   3960,  -1224,     -9,  -3978,     72,   1044,     -9,    -90, &
                    72,   -576,     -9,     72,     72,    477,    639,     -9,    558,    558,   -576,    396,   -738,     72, &
                  -252,   -252,     72,   -576,     72,   -252,     -9,    558,   -252,    558,    558,    -90,    -90,     -9, &
                  -576,    558,     -9,     72,    -90,    -90,     72,    -90,    -90,     -9,     -9,     -9,    153,   -495, &
                  -576,    396,    -90,    477,    558,    -90,    639,     -9,    720,     72,   4608,  -4626,   -657,   -576, &
                   558,    558,    720,   -900,   -900,    -90,    -90,    -90]
  K1( 883,:) = [    639,     -9,    558,    -90,     72,    720,   -657,   -576,   4608,  -4626,    558,    558,    153,   -495, &
                  -576,    396,    -90,    477,    -90,   -900,    -90,    -90,    720,   -900,  -4626,    558,    396,    477, &
                   -90,   -900,    396,   -252,   1044,  -3978,    558,    477,   1044,    396,  -1224,   1044,  -4626,    396, &
                    -9,    -90,    -90,    558,    558,   -252,   -738,     72,   -576,    396,   -252,   -252,     -9,     72, &
                   -90,     -9,   -576,     72,     72,   1044,  -1224,   3960,  -3978,     -9,    558,    558,     -9,    639, &
                   477,     72,     72,    153,     72,   1044,    558,    396,     72,   -576,    720,     72,   4608,   -576, &
                   720,  -1224,   -576,  -1224,   1044,    -90,    639,  -4626,   -657,   -738,    396,     -9,     -9,    -90, &
                    -9,     -9,     72,    -90,     -9,    -90,    -90,    558,    558,   -252,    -90,    -90,     72,     -9, &
                   558,   -576,     -9,    558,   -576,     72,   -252,     72]
  K1( 884,:) = [    558,    -90,    639,     -9,    720,     72,    153,   -495,   -576,    396,    -90,    477,   -657,   -576, &
                  4608,  -4626,    558,    558,   -900,    -90,    720,   -900,    -90,    -90,    396,    477,  -4626,    558, &
                  -900,    -90,   1044,    396,  -1224,   1044,  -4626,    396,    396,   -252,   1044,  -3978,    558,    477, &
                   -90,     -9,    558,   -252,    -90,    558,     72,    153,     72,   1044,    558,    396,     72,   -576, &
                   720,     72,   4608,   -576,    720,  -1224,   -576,  -1224,   1044,    -90,    639,  -4626,   -657,   -738, &
                   396,     -9,   -738,     72,   -576,    396,   -252,   -252,     -9,     72,    -90,     -9,   -576,     72, &
                    72,   1044,  -1224,   3960,  -3978,     -9,    558,    558,     -9,    639,    477,     72,    -90,     -9, &
                    72,    -90,     -9,     -9,    -90,     -9,    558,   -252,    -90,    558,     -9,    558,   -576,     72, &
                  -252,     72,    -90,    -90,     72,     -9,    558,   -576]
  K1( 885,:) = [     -9,     72,    -90,     -9,   -576,     72,   -738,     72,   -576,    396,   -252,   -252,  -1224,   3960, &
                    72,   1044,     -9,  -3978,     -9,    639,    558,    558,     72,    477,    396,   -252,   1044,  -3978, &
                   558,    477,  -4626,    558,    396,    477,    -90,   -900,  -1224,   1044,   1044,    396,    396,  -4626, &
                   -90,    558,     -9,    -90,   -252,    558,   -657,   -576,   4608,  -4626,    558,    558,    639,     -9, &
                   558,    -90,     72,    720,   -576,    396,    153,   -495,    477,    -90,    -90,    -90,    -90,   -900, &
                  -900,    720,   -576,  -1224,    720,  -1224,    -90,   1044,    720,     72,     72,   -576,   -576,   4608, &
                    72,   1044,     72,    153,    396,    558,     -9,    396,   -738,   -657,  -4626,    639,     72,     -9, &
                   -90,    -90,   -576,    558,    -90,    558,     -9,    -90,   -252,    558,     -9,     -9,     -9,    -90, &
                   -90,     72,     72,   -252,     72,   -576,    558,     -9]
  K1( 886,:) = [     72,   -576,    720,     72,   4608,   -576,     72,    153,     72,   1044,    558,    396,   -576,  -1224, &
                   720,  -1224,    -90,   1044,   -657,   -738,    639,  -4626,     -9,    396,   1044,    396,  -1224,   1044, &
                 -4626,    396,    396,    477,  -4626,    558,   -900,    -90,   1044,  -3978,    396,   -252,    477,    558, &
                   558,   -252,    -90,     -9,    558,    -90,    153,   -495,   -576,    396,    -90,    477,    558,    -90, &
                   639,     -9,    720,     72,   4608,  -4626,   -657,   -576,    558,    558,    720,   -900,   -900,    -90, &
                   -90,    -90,  -1224,   3960,     72,   1044,     -9,  -3978,    -90,     -9,     -9,     72,     72,   -576, &
                  -576,    396,   -738,     72,   -252,   -252,     72,    477,    639,     -9,    558,    558,   -576,     72, &
                    -9,    558,     72,   -252,    558,   -252,    -90,     -9,    558,    -90,     72,    -90,    -90,     -9, &
                    -9,     -9,   -576,    558,     -9,     72,    -90,    -90]
  K1( 887,:) = [    -90,     -9,     -9,     72,     72,   -576,  -1224,   3960,     72,   1044,     -9,  -3978,   -738,     72, &
                  -576,    396,   -252,   -252,    639,     -9,     72,    477,    558,    558,   1044,  -3978,    396,   -252, &
                   477,    558,  -1224,   1044,   1044,    396,    396,  -4626,  -4626,    558,    396,    477,    -90,   -900, &
                   558,    -90,   -252,    558,     -9,    -90,   -576,  -1224,    720,  -1224,    -90,   1044,    720,     72, &
                    72,   -576,   -576,   4608,     72,   1044,     72,    153,    396,    558,     -9,    396,   -738,   -657, &
                 -4626,    639,   -657,   -576,   4608,  -4626,    558,    558,    639,     -9,    558,    -90,     72,    720, &
                  -576,    396,    153,   -495,    477,    -90,    -90,    -90,    -90,   -900,   -900,    720,     -9,     72, &
                  -576,    558,    -90,    -90,    558,    -90,   -252,    558,     -9,    -90,     72,   -252,     72,   -576, &
                   558,     -9,     -9,     -9,     -9,    -90,    -90,     72]
  K1( 888,:) = [    720,     72,     72,   -576,   -576,   4608,   -576,  -1224,    720,  -1224,    -90,   1044,     72,    153, &
                    72,   1044,    558,    396,   -738,   -657,     -9,    396,    639,  -4626,  -1224,   1044,   1044,    396, &
                   396,  -4626,   1044,  -3978,    396,   -252,    477,    558,    396,    477,  -4626,    558,   -900,    -90, &
                  -252,    558,    558,    -90,    -90,     -9,  -1224,   3960,     72,   1044,     -9,  -3978,    -90,     -9, &
                    -9,     72,     72,   -576,   -576,    396,   -738,     72,   -252,   -252,     72,    477,    639,     -9, &
                   558,    558,    153,   -495,   -576,    396,    -90,    477,    558,    -90,    639,     -9,    720,     72, &
                  4608,  -4626,   -657,   -576,    558,    558,    720,   -900,   -900,    -90,    -90,    -90,     72,   -576, &
                    72,   -252,     -9,    558,   -252,    558,    558,    -90,    -90,     -9,   -576,    558,     -9,     72, &
                   -90,    -90,     72,    -90,    -90,     -9,     -9,     -9]
  K1( 889,:) = [     -9,    -90,     72,   -576,     -9,     72,     72,    720,     72,     72,   -576,    720,     72,    153, &
                    -9,     -9,   -576,    639,    153,   -495,     72,    -90,     72,    558,    -90,   -900,     -9,   -657, &
                   639,   -738,     -9,    -90,     72,   -576,     -9,     72,     72,    153,   -576,   -495,  -1224,   3960, &
                  -738,     72,   -657,    153,   -576,  -1224,   -576,  -5760,   -576,   -576,   4608,  -5760,     72,    720, &
                  -576,   4608,     72,   -576,     72,     72,   -576,  -1224,  -5112,   4608,   -576,    720,  -1224,   3960, &
                 -4464,   -576,     -9,   -657,    -90,    -90,     72,   -171,     72,   -576,   -576,    234,    234,  -1143, &
                    -9,     -9,     72,    153,    639,   -576,     -9,   1206,  -1224,   3960,  -4545,     72,   -657,   -576, &
                   720,   -900,     -9,    477,    882,   -495,   -495,   -414,   -414,   4041,     72,    -90,    153,   -495, &
                   558,     72,    -90,    396,   -576,  -1224,  -4626,    720]
  K1( 890,:) = [    -90,     -9,     -9,     72,     72,   -576,    720,     72,   -576,    720,     72,     72,    153,   -495, &
                    72,    -90,     72,    558,     72,    153,     -9,     -9,   -576,    639,   -900,    -90,    639,   -738, &
                    -9,   -657,    -90,     -9,     -9,     72,     72,   -576,   -738,     72,   -657,    153,   -576,  -1224, &
                    72,    153,   -576,   -495,  -1224,   3960,  -5760,   -576,   4608,  -5760,   -576,   -576,    720,     72, &
                    72,   -576,   -576,   4608,   -576,    720,  -1224,   3960,  -4464,   -576,     72,     72,   -576,  -1224, &
                 -5112,   4608,   -657,   -576,    720,   -900,     -9,    477,    882,   -495,   -495,   -414,   -414,   4041, &
                    72,    -90,    153,   -495,    558,     72,    -90,    396,   -576,  -1224,  -4626,    720,     -9,   -657, &
                   -90,    -90,     72,   -171,     72,   -576,   -576,    234,    234,  -1143,     -9,     -9,     72,    153, &
                   639,   -576,     -9,   1206,  -1224,   3960,  -4545,     72]
  K1( 891,:) = [     -9,     72,    -90,     -9,   -576,     72,     72,   -576,   -576,   -576,   -576,     72,     -9,     72, &
                    72,     72,     72,     -9,   -576,     72,     72,     -9,     -9,    -90,    -90,    720,    558,    639, &
                    72,     -9,     -9,     72,    -90,     -9,   -576,     72,   -252,    558,    558,    -90,    -90,     -9, &
                  -576,     72,   4608,   -576,    720,     72,   -576,   4608,   4608,   4608,   4608,   -576,     72,   -576, &
                   720,     72,   4608,   -576,   -576,   -576,     72,   -576,     72,   -576,   -576,     72,   4608,   -576, &
                   720,     72,    -90,    720,    720,    720,    720,    -90,    558,    -90,    639,     -9,    720,     72, &
                    72,     72,     -9,     72,     -9,     72,    -90,    558,    720,     72,    639,     -9,     72,     -9, &
                   720,    -90,    639,    558,   -576,     72,   4608,   -576,    720,     72,     72,     -9,   -576,     72, &
                   -90,     -9,    558,   -252,    -90,     -9,    558,    -90]
  K1( 892,:) = [     -9,    -90,    -90,    558,    558,   -252,     72,    720,   -576,   4608,     72,   -576,     -9,    -90, &
                    72,   -576,     -9,     72,    639,    558,     -9,     72,    -90,    720,    -90,   -900,    558,  -4626, &
                   477,    396,     -9,    -90,    -90,    558,    558,   -252,   -252,    396,    558,    477,   1044,  -3978, &
                   396,   1044,  -4626,    396,  -1224,   1044,   -576,  -5760,   4608, -36864,   -576,   4608,     72,    720, &
                   720,  -4464,  -4464,   2016,   -576,   4608,     72,    720,   -576,     72,     72,   -576,  -5112,  -4464, &
                 -5760,    720,    -90,   -900,    720,  -5760,    -90,    720,    558,    477,    639,   -171,    396,   1206, &
                    72,   -576,  