! 2
! The number above is the number of vamp routines for this process.
! This is needed by the build system.

#if 3 > 1
#ifndef USE_CHECK_qp
#define DUMMY_qp
#endif
#else
#ifndef USE_qp
#define DUMMY_qp
#endif
#endif

module ol_vamp_ppttj_ew_ttxbbxg_4_/**/REALKIND
  use KIND_TYPES, only: REALKIND
  implicit none
  real(REALKIND):: M2L0cache, M2L1cache
  contains

! **********************************************************************
  subroutine redbaseconstr()
! **********************************************************************
  use KIND_TYPES, only: REALKIND
  use ol_data_types_/**/REALKIND, only: basis
  use ol_parameters_decl_/**/QREALKIND ! masses
  use ol_tensor_sum_storage_ppttj_ew_ttxbbxg_4_/**/REALKIND
  use ofred_basis_construction_/**/REALKIND, only: construct_RedBasis, construct_redset4
  use ofred_basis_construction_/**/REALKIND, only: construct_redset5
  implicit none

  ! Define mass sets for reduction
  mass5set(0:4,1) = [nMB,nMB,nMH,nMT,nMH]
  mass5set(0:4,2) = [nMB,nMB,nMH,nMT,nMZ]
  mass5set(0:4,3) = [nMB,nMB,nMZ,nMT,nMH]
  mass5set(0:4,4) = [nMB,nMB,nMZ,nMT,nMZ]
  mass5set(0:4,5) = [nMT,nMT,nMW,nMB,nMW]
  mass5set(0:4,6) = [nMB,nMB,nMH,nMT,0]
  mass5set(0:4,7) = [nMB,nMB,nMZ,nMT,0]
  mass5set(0:4,8) = [nMB,nMB,0,nMT,nMH]
  mass5set(0:4,9) = [nMB,nMB,0,nMT,nMZ]
  mass5set(0:4,10) = [nMB,nMB,0,nMT,0]
  mass5set(0:4,11) = [nMT,nMT,nMH,nMT,nMW]
  mass5set(0:4,12) = [nMB,nMB,nMW,nMB,nMH]
  mass5set(0:4,13) = [nMT,nMT,nMZ,nMT,nMW]
  mass5set(0:4,14) = [nMB,nMB,nMW,nMB,nMZ]
  mass5set(0:4,15) = [nMB,nMB,nMW,nMB,0]
  mass5set(0:4,16) = [nMT,nMT,0,nMT,nMW]
  mass5set(0:4,17) = [nMT,nMT,nMH,nMB,nMW]
  mass5set(0:4,18) = [nMB,nMB,nMW,nMT,nMH]
  mass5set(0:4,19) = [nMT,nMT,nMZ,nMB,nMW]
  mass5set(0:4,20) = [nMB,nMB,nMW,nMT,nMZ]
  mass5set(0:4,21) = [nMT,nMT,0,nMB,nMW]
  mass5set(0:4,22) = [nMB,nMB,nMW,nMT,0]
  mass5set(0:4,23) = [nMT,nMT,nMH,nMB,nMH]
  mass5set(0:4,24) = [nMT,nMT,nMH,nMB,nMZ]
  mass5set(0:4,25) = [nMT,nMT,nMZ,nMB,nMH]
  mass5set(0:4,26) = [nMT,nMT,nMZ,nMB,nMZ]
  mass5set(0:4,27) = [nMB,nMB,nMW,nMT,nMW]
  mass5set(0:4,28) = [nMT,nMT,nMH,nMB,0]
  mass5set(0:4,29) = [nMT,nMT,nMZ,nMB,0]
  mass5set(0:4,30) = [nMT,nMT,0,nMB,nMH]
  mass5set(0:4,31) = [nMT,nMT,0,nMB,nMZ]
  mass5set(0:4,32) = [nMT,nMT,0,nMB,0]
mass4set(0:3,1) = [nMB,nMB,nMH,nMZ]
mass4set(0:3,2) = [nMB,nMB,nMZ,nMH]
mass4set(0:3,3) = [nMB,nMB,nMZ,nMZ]
mass4set(0:3,4) = [nMT,nMT,nMW,nMW]
mass4set(0:3,5) = [nMB,nMB,nMT,nMH]
mass4set(0:3,6) = [nMB,nMB,nMT,nMZ]
mass4set(0:3,7) = [nMB,nMB,nMT,0]
mass4set(0:3,8) = [nMT,nMT,nMT,nMW]
mass4set(0:3,9) = [nMT,nMT,nMH,nMW]
mass4set(0:3,10) = [nMB,nMB,nMB,nMH]
mass4set(0:3,11) = [nMB,nMB,nMW,nMH]
mass4set(0:3,12) = [nMT,nMT,nMZ,nMW]
mass4set(0:3,13) = [nMB,nMB,nMB,nMZ]
mass4set(0:3,14) = [nMB,nMB,nMW,nMZ]
mass4set(0:3,15) = [nMB,nMB,nMB,0]
mass4set(0:3,16) = [nMB,nMB,nMW,0]
mass4set(0:3,17) = [nMT,nMT,0,nMW]
mass4set(0:3,18) = [nMT,nMT,nMH,nMZ]
mass4set(0:3,19) = [nMT,nMT,nMZ,nMH]
mass4set(0:3,20) = [nMT,nMT,nMZ,nMZ]
mass4set(0:3,21) = [nMB,nMB,nMW,nMW]
mass4set(0:3,22) = [nMT,nMT,nMH,nMB]
mass4set(0:3,23) = [nMT,nMT,nMZ,nMB]
mass4set(0:3,24) = [nMT,nMT,0,nMB]
mass4set(0:3,25) = [nMB,nMB,nMH,nMT]
mass4set(0:3,26) = [nMB,nMB,nMZ,nMT]
mass4set(0:3,27) = [nMB,nMB,0,nMT]
mass4set(0:3,28) = [nMT,nMT,nMH,nMT]
mass4set(0:3,29) = [nMT,nMT,nMZ,nMT]
mass4set(0:3,30) = [nMB,nMB,nMW,nMB]
mass4set(0:3,31) = [nMT,nMT,0,nMT]
mass4set(0:3,32) = [nMH,nMB,nMH,nMT]
mass4set(0:3,33) = [nMZ,nMB,nMH,nMT]
mass4set(0:3,34) = [nMH,nMB,nMZ,nMT]
mass4set(0:3,35) = [nMZ,nMB,nMZ,nMT]
mass4set(0:3,36) = [nMW,nMT,nMW,nMB]
mass4set(0:3,37) = [nMT,nMT,nMW,nMB]
mass4set(0:3,38) = [0,nMB,nMH,nMT]
mass4set(0:3,39) = [0,nMB,nMZ,nMT]
mass4set(0:3,40) = [nMH,nMB,0,nMT]
mass4set(0:3,41) = [nMZ,nMB,0,nMT]
mass4set(0:3,42) = [0,nMB,0,nMT]
mass4set(0:3,43) = [nMW,nMT,nMH,nMT]
mass4set(0:3,44) = [nMH,nMB,nMW,nMB]
mass4set(0:3,45) = [nMW,nMT,nMZ,nMT]
mass4set(0:3,46) = [nMZ,nMB,nMW,nMB]
mass4set(0:3,47) = [0,nMB,nMW,nMB]
mass4set(0:3,48) = [nMW,nMT,0,nMT]
mass4set(0:3,49) = [nMW,nMT,nMH,nMB]
mass4set(0:3,50) = [nMH,nMB,nMW,nMT]
mass4set(0:3,51) = [nMB,nMB,nMW,nMT]
mass4set(0:3,52) = [nMW,nMT,nMZ,nMB]
mass4set(0:3,53) = [nMZ,nMB,nMW,nMT]
mass4set(0:3,54) = [nMW,nMT,0,nMB]
mass4set(0:3,55) = [0,nMB,nMW,nMT]
mass4set(0:3,56) = [nMH,nMT,nMH,nMB]
mass4set(0:3,57) = [nMZ,nMT,nMH,nMB]
mass4set(0:3,58) = [nMH,nMT,nMZ,nMB]
mass4set(0:3,59) = [nMZ,nMT,nMZ,nMB]
mass4set(0:3,60) = [nMW,nMB,nMW,nMT]
mass4set(0:3,61) = [0,nMT,nMH,nMB]
mass4set(0:3,62) = [0,nMT,nMZ,nMB]
mass4set(0:3,63) = [nMH,nMT,0,nMB]
mass4set(0:3,64) = [nMZ,nMT,0,nMB]
mass4set(0:3,65) = [0,nMT,0,nMB]
mass4set(0:3,66) = [nMB,nMH,nMT,nMH]
mass4set(0:3,67) = [nMB,nMB,nMH,nMH]
mass4set(0:3,68) = [nMB,nMH,nMT,nMZ]
mass4set(0:3,69) = [nMB,nMZ,nMT,nMH]
mass4set(0:3,70) = [nMB,nMZ,nMT,nMZ]
mass4set(0:3,71) = [nMT,nMW,nMB,nMW]
mass4set(0:3,72) = [nMT,nMT,nMB,nMW]
mass4set(0:3,73) = [nMB,nMH,nMT,0]
mass4set(0:3,74) = [nMB,nMB,nMH,0]
mass4set(0:3,75) = [nMB,nMZ,nMT,0]
mass4set(0:3,76) = [nMB,nMB,nMZ,0]
mass4set(0:3,77) = [nMB,0,nMT,nMH]
mass4set(0:3,78) = [nMB,nMB,0,nMH]
mass4set(0:3,79) = [nMB,0,nMT,nMZ]
mass4set(0:3,80) = [nMB,nMB,0,nMZ]
mass4set(0:3,81) = [nMB,0,nMT,0]
mass4set(0:3,82) = [nMB,nMB,0,0]
mass4set(0:3,83) = [nMT,nMH,nMT,nMW]
mass4set(0:3,84) = [nMB,nMW,nMB,nMH]
mass4set(0:3,85) = [nMT,nMZ,nMT,nMW]
mass4set(0:3,86) = [nMB,nMW,nMB,nMZ]
mass4set(0:3,87) = [nMB,nMW,nMB,0]
mass4set(0:3,88) = [nMT,0,nMT,nMW]
mass4set(0:3,89) = [nMT,nMH,nMB,nMW]
mass4set(0:3,90) = [nMB,nMW,nMT,nMH]
mass4set(0:3,91) = [nMT,nMZ,nMB,nMW]
mass4set(0:3,92) = [nMB,nMW,nMT,nMZ]
mass4set(0:3,93) = [nMT,0,nMB,nMW]
mass4set(0:3,94) = [nMB,nMW,nMT,0]
mass4set(0:3,95) = [nMT,nMH,nMB,nMH]
mass4set(0:3,96) = [nMT,nMT,nMB,nMH]
mass4set(0:3,97) = [nMT,nMT,nMH,nMH]
mass4set(0:3,98) = [nMT,nMH,nMB,nMZ]
mass4set(0:3,99) = [nMT,nMT,nMB,nMZ]
mass4set(0:3,100) = [nMT,nMZ,nMB,nMH]
mass4set(0:3,101) = [nMT,nMZ,nMB,nMZ]
mass4set(0:3,102) = [nMB,nMW,nMT,nMW]
mass4set(0:3,103) = [nMB,nMB,nMT,nMW]
mass4set(0:3,104) = [nMT,nMH,nMB,0]
mass4set(0:3,105) = [nMT,nMT,nMB,0]
mass4set(0:3,106) = [nMT,nMT,nMH,0]
mass4set(0:3,107) = [nMT,nMZ,nMB,0]
mass4set(0:3,108) = [nMT,nMT,nMZ,0]
mass4set(0:3,109) = [nMT,0,nMB,nMH]
mass4set(0:3,110) = [nMT,nMT,0,nMH]
mass4set(0:3,111) = [nMT,0,nMB,nMZ]
mass4set(0:3,112) = [nMT,nMT,0,nMZ]
mass4set(0:3,113) = [nMT,0,nMB,0]
mass4set(0:3,114) = [nMT,nMT,0,0]
mass4set(0:3,115) = [nMW,nMB,nMH,nMT]
mass4set(0:3,116) = [nMH,nMT,nMW,nMB]
mass4set(0:3,117) = [nMW,nMB,nMZ,nMT]
mass4set(0:3,118) = [nMZ,nMT,nMW,nMB]
mass4set(0:3,119) = [0,nMT,nMW,nMB]
mass4set(0:3,120) = [nMW,nMB,0,nMT]
mass4set(0:3,121) = [nMB,nMH,nMT,nMW]
mass4set(0:3,122) = [nMT,nMW,nMB,nMH]
mass4set(0:3,123) = [nMB,nMZ,nMT,nMW]
mass4set(0:3,124) = [nMT,nMW,nMB,nMZ]
mass4set(0:3,125) = [nMT,nMW,nMB,0]
mass4set(0:3,126) = [nMB,0,nMT,nMW]
  mass3set(0:2,1) = [nMZ,nMB,nMH]
  mass3set(0:2,2) = [nMB,nMB,nMH]
  mass3set(0:2,3) = [nMH,nMB,nMZ]
  mass3set(0:2,4) = [nMB,nMB,nMZ]
  mass3set(0:2,5) = [nMZ,nMB,nMZ]
  mass3set(0:2,6) = [nMW,nMT,nMW]
  mass3set(0:2,7) = [nMT,nMT,nMW]
  mass3set(0:2,8) = [nMH,nMB,nMT]
  mass3set(0:2,9) = [nMB,nMB,nMT]
  mass3set(0:2,10) = [nMZ,nMB,nMT]
  mass3set(0:2,11) = [0,nMB,nMT]
  mass3set(0:2,12) = [nMW,nMT,nMT]
  mass3set(0:2,13) = [nMT,nMT,nMT]
  mass3set(0:2,14) = [nMW,nMT,nMH]
  mass3set(0:2,15) = [nMT,nMT,nMH]
  mass3set(0:2,16) = [nMH,nMB,nMB]
  mass3set(0:2,17) = [nMB,nMB,nMB]
  mass3set(0:2,18) = [nMH,nMB,nMW]
  mass3set(0:2,19) = [nMB,nMB,nMW]
  mass3set(0:2,20) = [nMW,nMT,nMZ]
  mass3set(0:2,21) = [nMT,nMT,nMZ]
  mass3set(0:2,22) = [nMZ,nMB,nMB]
  mass3set(0:2,23) = [nMZ,nMB,nMW]
  mass3set(0:2,24) = [0,nMB,nMB]
  mass3set(0:2,25) = [0,nMB,nMW]
  mass3set(0:2,26) = [nMW,nMT,0]
  mass3set(0:2,27) = [nMT,nMT,0]
  mass3set(0:2,28) = [nMZ,nMT,nMH]
  mass3set(0:2,29) = [nMH,nMT,nMZ]
  mass3set(0:2,30) = [nMZ,nMT,nMZ]
  mass3set(0:2,31) = [nMW,nMB,nMW]
  mass3set(0:2,32) = [nMB,nMT,nMH]
  mass3set(0:2,33) = [nMB,nMT,nMZ]
  mass3set(0:2,34) = [nMB,nMT,0]
  mass3set(0:2,35) = [nMT,nMB,nMH]
  mass3set(0:2,36) = [nMT,nMB,nMZ]
  mass3set(0:2,37) = [nMT,nMB,0]
  mass3set(0:2,38) = [nMB,nMB,0]
  mass3set(0:2,39) = [nMZ,nMH,nMT]
  mass3set(0:2,40) = [nMH,nMZ,nMT]
  mass3set(0:2,41) = [nMZ,nMZ,nMT]
  mass3set(0:2,42) = [nMW,nMW,nMB]
  mass3set(0:2,43) = [nMB,nMH,nMT]
  mass3set(0:2,44) = [nMB,nMZ,nMT]
  mass3set(0:2,45) = [nMB,0,nMT]
  mass3set(0:2,46) = [nMW,nMH,nMT]
  mass3set(0:2,47) = [nMT,nMH,nMT]
  mass3set(0:2,48) = [nMH,nMW,nMB]
  mass3set(0:2,49) = [nMB,nMW,nMB]
  mass3set(0:2,50) = [nMW,nMZ,nMT]
  mass3set(0:2,51) = [nMT,nMZ,nMT]
  mass3set(0:2,52) = [nMZ,nMW,nMB]
  mass3set(0:2,53) = [0,nMW,nMB]
  mass3set(0:2,54) = [nMW,0,nMT]
  mass3set(0:2,55) = [nMT,0,nMT]
  mass3set(0:2,56) = [nMZ,nMH,nMB]
  mass3set(0:2,57) = [nMH,nMZ,nMB]
  mass3set(0:2,58) = [nMZ,nMZ,nMB]
  mass3set(0:2,59) = [nMW,nMW,nMT]
  mass3set(0:2,60) = [nMT,nMH,nMB]
  mass3set(0:2,61) = [nMT,nMT,nMB]
  mass3set(0:2,62) = [nMT,nMZ,nMB]
  mass3set(0:2,63) = [nMT,0,nMB]
  mass3set(0:2,64) = [nMB,nMH,nMZ]
  mass3set(0:2,65) = [nMB,nMZ,nMH]
  mass3set(0:2,66) = [nMB,nMZ,nMZ]
  mass3set(0:2,67) = [nMT,nMW,nMW]
  mass3set(0:2,68) = [nMT,nMH,nMW]
  mass3set(0:2,69) = [nMB,nMW,nMH]
  mass3set(0:2,70) = [nMT,nMZ,nMW]
  mass3set(0:2,71) = [nMB,nMW,nMZ]
  mass3set(0:2,72) = [nMB,nMW,0]
  mass3set(0:2,73) = [nMT,0,nMW]
  mass3set(0:2,74) = [nMT,nMH,nMZ]
  mass3set(0:2,75) = [nMT,nMZ,nMH]
  mass3set(0:2,76) = [nMT,nMZ,nMZ]
  mass3set(0:2,77) = [nMB,nMW,nMW]
  mass3set(0:2,78) = [nMH,nMT,nMB]
  mass3set(0:2,79) = [nMZ,nMT,nMB]
  mass3set(0:2,80) = [0,nMT,nMB]
  mass3set(0:2,81) = [nMW,nMB,nMH]
  mass3set(0:2,82) = [nMH,nMT,nMW]
  mass3set(0:2,83) = [nMW,nMB,nMZ]
  mass3set(0:2,84) = [nMZ,nMT,nMW]
  mass3set(0:2,85) = [0,nMT,nMW]
  mass3set(0:2,86) = [nMW,nMB,0]
  mass3set(0:2,87) = [nMH,nMH,nMT]
  mass3set(0:2,88) = [nMH,nMB,nMH]
  mass3set(0:2,89) = [nMB,nMT,nMW]
  mass3set(0:2,90) = [nMW,nMT,nMB]
  mass3set(0:2,91) = [nMT,nMW,nMB]
  mass3set(0:2,92) = [0,nMH,nMT]
  mass3set(0:2,93) = [0,nMB,nMH]
  mass3set(0:2,94) = [0,nMZ,nMT]
  mass3set(0:2,95) = [0,nMB,nMZ]
  mass3set(0:2,96) = [nMH,0,nMT]
  mass3set(0:2,97) = [nMH,nMB,0]
  mass3set(0:2,98) = [nMZ,0,nMT]
  mass3set(0:2,99) = [nMZ,nMB,0]
  mass3set(0:2,100) = [0,0,nMT]
  mass3set(0:2,101) = [0,nMB,0]
  mass3set(0:2,102) = [nMW,nMH,nMB]
  mass3set(0:2,103) = [nMT,nMB,nMW]
  mass3set(0:2,104) = [nMH,nMW,nMT]
  mass3set(0:2,105) = [nMB,nMW,nMT]
  mass3set(0:2,106) = [nMW,nMZ,nMB]
  mass3set(0:2,107) = [nMZ,nMW,nMT]
  mass3set(0:2,108) = [nMW,0,nMB]
  mass3set(0:2,109) = [0,nMW,nMT]
  mass3set(0:2,110) = [nMH,nMH,nMB]
  mass3set(0:2,111) = [nMH,nMT,nMH]
  mass3set(0:2,112) = [nMW,nMB,nMT]
  mass3set(0:2,113) = [0,nMH,nMB]
  mass3set(0:2,114) = [0,nMT,nMH]
  mass3set(0:2,115) = [0,nMZ,nMB]
  mass3set(0:2,116) = [0,nMT,nMZ]
  mass3set(0:2,117) = [nMH,0,nMB]
  mass3set(0:2,118) = [nMH,nMT,0]
  mass3set(0:2,119) = [nMZ,0,nMB]
  mass3set(0:2,120) = [nMZ,nMT,0]
  mass3set(0:2,121) = [0,0,nMB]
  mass3set(0:2,122) = [0,nMT,0]
  mass3set(0:2,123) = [nMB,nMH,nMH]
  mass3set(0:2,124) = [nMB,nMH,0]
  mass3set(0:2,125) = [nMB,nMZ,0]
  mass3set(0:2,126) = [nMB,0,nMH]
  mass3set(0:2,127) = [nMB,0,nMZ]
  mass3set(0:2,128) = [nMB,0,0]
  mass3set(0:2,129) = [nMT,nMH,nMH]
  mass3set(0:2,130) = [nMT,nMH,0]
  mass3set(0:2,131) = [nMT,nMZ,0]
  mass3set(0:2,132) = [nMT,0,nMH]
  mass3set(0:2,133) = [nMT,0,nMZ]
  mass3set(0:2,134) = [nMT,0,0]
  mass3set(0:2,135) = [nMB,nMH,nMW]
  mass3set(0:2,136) = [nMT,nMW,nMH]
  mass3set(0:2,137) = [nMB,nMZ,nMW]
  mass3set(0:2,138) = [nMT,nMW,nMZ]
  mass3set(0:2,139) = [nMT,nMW,0]
  mass3set(0:2,140) = [nMB,0,nMW]
mass2set(0:1,1) = [nMZ,nMH]
mass2set(0:1,2) = [nMZ,nMZ]
mass2set(0:1,3) = [nMW,nMW]
mass2set(0:1,4) = [nMT,nMB]
mass2set(0:1,5) = [nMB,nMT]
mass2set(0:1,6) = [nMT,nMT]
mass2set(0:1,7) = [nMW,nMH]
mass2set(0:1,8) = [nMB,nMB]
mass2set(0:1,9) = [nMW,nMZ]
mass2set(0:1,10) = [nMZ,nMW]
mass2set(0:1,11) = [0,nMW]
mass2set(0:1,12) = [nMW,0]
mass2set(0:1,13) = [nMH,nMW]
mass2set(0:1,14) = [nMH,nMZ]
mass2set(0:1,15) = [0,0]
mass2set(0:1,16) = [nME,nME]
mass2set(0:1,17) = [nMM,nMM]
mass2set(0:1,18) = [nML,nML]
mass2set(0:1,19) = [nME,0]
mass2set(0:1,20) = [nMM,0]
mass2set(0:1,21) = [nML,0]
mass2set(0:1,22) = [0,nME]
mass2set(0:1,23) = [0,nMM]
mass2set(0:1,24) = [0,nML]
mass2set(0:1,25) = [nMZ,nMB]
mass2set(0:1,26) = [nMB,nMH]
mass2set(0:1,27) = [nMH,nMB]
mass2set(0:1,28) = [nMB,nMZ]
mass2set(0:1,29) = [nMW,nMT]
mass2set(0:1,30) = [nMT,nMW]
mass2set(0:1,31) = [0,nMB]
mass2set(0:1,32) = [nMT,nMH]
mass2set(0:1,33) = [nMB,nMW]
mass2set(0:1,34) = [nMT,nMZ]
mass2set(0:1,35) = [nMT,0]
mass2set(0:1,36) = [nMZ,nMT]
mass2set(0:1,37) = [nMH,nMT]
mass2set(0:1,38) = [nMW,nMB]
mass2set(0:1,39) = [nMB,0]
mass2set(0:1,40) = [0,nMT]


  ! Compute reduction bases from external momentum pairs p1, p2 (in light cone rep)
  call construct_RedBasis(16,20,RedBasis(1))
  call construct_RedBasis(16,21,RedBasis(2))
  call construct_RedBasis(16,23,RedBasis(3))
  call construct_RedBasis(20,21,RedBasis(4))
  call construct_RedBasis(20,23,RedBasis(5))
  call construct_RedBasis(21,23,RedBasis(6))
  call construct_RedBasis(16,22,RedBasis(7))
  call construct_RedBasis(20,22,RedBasis(8))
  call construct_RedBasis(22,23,RedBasis(9))
  call construct_RedBasis(16,18,RedBasis(10))
  call construct_RedBasis(16,19,RedBasis(11))
  call construct_RedBasis(16,27,RedBasis(12))
  call construct_RedBasis(18,19,RedBasis(13))
  call construct_RedBasis(18,27,RedBasis(14))
  call construct_RedBasis(19,27,RedBasis(15))
  call construct_RedBasis(16,17,RedBasis(16))
  call construct_RedBasis(17,19,RedBasis(17))
  call construct_RedBasis(17,23,RedBasis(18))
  call construct_RedBasis(19,23,RedBasis(19))
  call construct_RedBasis(16,26,RedBasis(20))
  call construct_RedBasis(18,26,RedBasis(21))
  call construct_RedBasis(26,27,RedBasis(22))
  call construct_RedBasis(17,21,RedBasis(23))
  call construct_RedBasis(16,29,RedBasis(24))
  call construct_RedBasis(17,29,RedBasis(25))
  call construct_RedBasis(21,29,RedBasis(26))
  call construct_RedBasis(16,25,RedBasis(27))
  call construct_RedBasis(17,25,RedBasis(28))
  call construct_RedBasis(25,29,RedBasis(29))
  call construct_RedBasis(4,5,RedBasis(30))
  call construct_RedBasis(4,7,RedBasis(31))
  call construct_RedBasis(5,7,RedBasis(32))
  call construct_RedBasis(4,6,RedBasis(33))
  call construct_RedBasis(6,7,RedBasis(34))
  call construct_RedBasis(2,3,RedBasis(35))
  call construct_RedBasis(2,11,RedBasis(36))
  call construct_RedBasis(3,11,RedBasis(37))
  call construct_RedBasis(1,3,RedBasis(38))
  call construct_RedBasis(1,7,RedBasis(39))
  call construct_RedBasis(3,7,RedBasis(40))
  call construct_RedBasis(2,10,RedBasis(41))
  call construct_RedBasis(10,11,RedBasis(42))
  call construct_RedBasis(1,5,RedBasis(43))
  call construct_RedBasis(1,13,RedBasis(44))
  call construct_RedBasis(5,13,RedBasis(45))
  call construct_RedBasis(1,9,RedBasis(46))
  call construct_RedBasis(9,13,RedBasis(47))
  call construct_RedBasis(18,22,RedBasis(48))
  call construct_RedBasis(24,28,RedBasis(49))
  call construct_RedBasis(24,29,RedBasis(50))
  call construct_RedBasis(28,29,RedBasis(51))
  call construct_RedBasis(24,30,RedBasis(52))
  call construct_RedBasis(28,30,RedBasis(53))
  call construct_RedBasis(24,25,RedBasis(54))
  call construct_RedBasis(24,27,RedBasis(55))
  call construct_RedBasis(25,27,RedBasis(56))
  call construct_RedBasis(20,30,RedBasis(57))
  call construct_RedBasis(22,30,RedBasis(58))
  call construct_RedBasis(18,23,RedBasis(59))
  call construct_RedBasis(17,27,RedBasis(60))
  call construct_RedBasis(20,29,RedBasis(61))
  call construct_RedBasis(24,26,RedBasis(62))
  call construct_RedBasis(26,30,RedBasis(63))


  ! Compute scalars depending on a third momentum p3 (in light cone rep)
  call construct_redset5(16, 20, 21, 23, RedBasis(1), RedBasis(2), & 
 RedBasis(3), RedBasis(4),RedBasis(5), RedBasis(6), RedSet_5(1))
  call construct_redset5(16, 20, 22, 23, RedBasis(1), RedBasis(7), & 
 RedBasis(3), RedBasis(8),RedBasis(5), RedBasis(9), RedSet_5(2))
  call construct_redset5(16, 18, 19, 27, RedBasis(10), RedBasis(11), & 
 RedBasis(12), RedBasis(13),RedBasis(14), RedBasis(15), RedSet_5(3))
  call construct_redset5(16, 17, 19, 23, RedBasis(16), RedBasis(11), & 
 RedBasis(3), RedBasis(17),RedBasis(18), RedBasis(19), RedSet_5(4))
  call construct_redset5(16, 18, 26, 27, RedBasis(10), RedBasis(20), & 
 RedBasis(12), RedBasis(21),RedBasis(14), RedBasis(22), RedSet_5(5))
  call construct_redset5(16, 17, 21, 23, RedBasis(16), RedBasis(2), & 
 RedBasis(3), RedBasis(23),RedBasis(18), RedBasis(6), RedSet_5(6))
  call construct_redset5(16, 17, 21, 29, RedBasis(16), RedBasis(2), & 
 RedBasis(24), RedBasis(23),RedBasis(25), RedBasis(26), RedSet_5(7))
  call construct_redset5(16, 17, 25, 29, RedBasis(16), RedBasis(27), & 
 RedBasis(24), RedBasis(28),RedBasis(25), RedBasis(29), RedSet_5(8))
  call construct_redset4(20,21,23,RedBasis(4),RedBasis(5),RedBasis(6),RedSet_4(1))
  call construct_redset4(16,21,23,RedBasis(2),RedBasis(3),RedBasis(6),RedSet_4(2))
  call construct_redset4(16,20,23,RedBasis(1),RedBasis(3),RedBasis(5),RedSet_4(3))
  call construct_redset4(16,20,21,RedBasis(1),RedBasis(2),RedBasis(4),RedSet_4(4))
  call construct_redset4(4,5,7,RedBasis(30),RedBasis(31),RedBasis(32),RedSet_4(5))
  call construct_redset4(20,22,23,RedBasis(8),RedBasis(5),RedBasis(9),RedSet_4(6))
  call construct_redset4(16,22,23,RedBasis(7),RedBasis(3),RedBasis(9),RedSet_4(7))
  call construct_redset4(16,20,22,RedBasis(1),RedBasis(7),RedBasis(8),RedSet_4(8))
  call construct_redset4(4,6,7,RedBasis(33),RedBasis(31),RedBasis(34),RedSet_4(9))
  call construct_redset4(18,19,27,RedBasis(13),RedBasis(14),RedBasis(15),RedSet_4(10))
  call construct_redset4(16,19,27,RedBasis(11),RedBasis(12),RedBasis(15),RedSet_4(11))
  call construct_redset4(16,18,27,RedBasis(10),RedBasis(12),RedBasis(14),RedSet_4(12))
  call construct_redset4(16,18,19,RedBasis(10),RedBasis(11),RedBasis(13),RedSet_4(13))
  call construct_redset4(2,3,11,RedBasis(35),RedBasis(36),RedBasis(37),RedSet_4(14))
  call construct_redset4(17,19,23,RedBasis(17),RedBasis(18),RedBasis(19),RedSet_4(15))
  call construct_redset4(16,19,23,RedBasis(11),RedBasis(3),RedBasis(19),RedSet_4(16))
  call construct_redset4(16,17,23,RedBasis(16),RedBasis(3),RedBasis(18),RedSet_4(17))
  call construct_redset4(16,17,19,RedBasis(16),RedBasis(11),RedBasis(17),RedSet_4(18))
  call construct_redset4(1,3,7,RedBasis(38),RedBasis(39),RedBasis(40),RedSet_4(19))
  call construct_redset4(18,26,27,RedBasis(21),RedBasis(14),RedBasis(22),RedSet_4(20))
  call construct_redset4(16,26,27,RedBasis(20),RedBasis(12),RedBasis(22),RedSet_4(21))
  call construct_redset4(16,18,26,RedBasis(10),RedBasis(20),RedBasis(21),RedSet_4(22))
  call construct_redset4(2,10,11,RedBasis(41),RedBasis(36),RedBasis(42),RedSet_4(23))
  call construct_redset4(17,21,23,RedBasis(23),RedBasis(18),RedBasis(6),RedSet_4(24))
  call construct_redset4(16,17,21,RedBasis(16),RedBasis(2),RedBasis(23),RedSet_4(25))
  call construct_redset4(1,5,7,RedBasis(43),RedBasis(39),RedBasis(32),RedSet_4(26))
  call construct_redset4(17,21,29,RedBasis(23),RedBasis(25),RedBasis(26),RedSet_4(27))
  call construct_redset4(16,21,29,RedBasis(2),RedBasis(24),RedBasis(26),RedSet_4(28))
  call construct_redset4(16,17,29,RedBasis(16),RedBasis(24),RedBasis(25),RedSet_4(29))
  call construct_redset4(1,5,13,RedBasis(43),RedBasis(44),RedBasis(45),RedSet_4(30))
  call construct_redset4(17,25,29,RedBasis(28),RedBasis(25),RedBasis(29),RedSet_4(31))
  call construct_redset4(16,25,29,RedBasis(27),RedBasis(24),RedBasis(29),RedSet_4(32))
  call construct_redset4(16,17,25,RedBasis(16),RedBasis(27),RedBasis(28),RedSet_4(33))
  call construct_redset4(1,9,13,RedBasis(46),RedBasis(44),RedBasis(47),RedSet_4(34))
  call construct_redset4(16,18,22,RedBasis(10),RedBasis(7),RedBasis(48),RedSet_4(35))
  call construct_redset4(24,28,29,RedBasis(49),RedBasis(50),RedBasis(51),RedSet_4(36))
  call construct_redset4(24,28,30,RedBasis(49),RedBasis(52),RedBasis(53),RedSet_4(37))
  call construct_redset4(24,25,27,RedBasis(54),RedBasis(55),RedBasis(56),RedSet_4(38))
  call construct_redset4(20,22,30,RedBasis(8),RedBasis(57),RedBasis(58),RedSet_4(39))
  call construct_redset4(24,25,29,RedBasis(54),RedBasis(50),RedBasis(29),RedSet_4(40))
  call construct_redset4(18,19,23,RedBasis(13),RedBasis(59),RedBasis(19),RedSet_4(41))
  call construct_redset4(17,19,27,RedBasis(17),RedBasis(60),RedBasis(15),RedSet_4(42))
  call construct_redset4(18,22,23,RedBasis(48),RedBasis(59),RedBasis(9),RedSet_4(43))
  call construct_redset4(20,21,29,RedBasis(4),RedBasis(61),RedBasis(26),RedSet_4(44))
  call construct_redset4(24,26,27,RedBasis(62),RedBasis(55),RedBasis(22),RedSet_4(45))

end subroutine



! **********************************************************************
subroutine vamp(M)
! **********************************************************************
  use KIND_TYPES, only: REALKIND, intkind2
  use ol_data_types_/**/REALKIND, only: Hpolcont
  use ol_parameters_decl_/**/REALKIND ! masses
  use ol_parameters_init_/**/REALKIND, only: init_met
  use ol_parameters_init_/**/DREALKIND, only: channel_on
  use ol_external_ppttj_ew_ttxbbxg_4, only: & 
    & channel_number_ppttj_ew_ttxbbxg_4
  use ol_tensor_sum_storage_ppttj_ew_ttxbbxg_4_/**/REALKIND
  use ol_loop_storage_ppttj_ew_ttxbbxg_4_/**/DREALKIND, only: &
    merge_step, hel_states

  use ol_vamp_1_ppttj_ew_ttxbbxg_4_/**/REALKIND, only: vamp_1
  use ol_vamp_2_ppttj_ew_ttxbbxg_4_/**/REALKIND, only: vamp_2

  implicit none
  type(Hpolcont), intent(in) :: M(4,hel_states)

#ifdef LOOPSQUARED
  M = 0
#endif

  merge_step = 1
  ! Call subroutines for all branches to calculate loop coefficient tensors
  call channel_on(channel_number_ppttj_ew_ttxbbxg_4)
  call init_met(M2L1R1)
  call vamp_1(M)
  call vamp_2(M)


end subroutine vamp

! **********************************************************************
subroutine vamp2base(P_scatt, M2L0, M2L1, IRL1, M2L2, IRL2, mode)
! P_scatt(0:3,Npart) = external momenta
! M2tree = helicity-summed squared tree matrix element for top anti-top bottom anti-bottom glue -> 0
! M2loop0 = helicity-summed squared loop matrix element for top anti-top bottom anti-bottom glue -> 0
! M2loop1 = IR1, M2loop2 = IR2 are dummy values for the single and double poles
! IR0, IR1, IR2 = finite, single pole, and double pole IR contribution
! mode = 1 (default): full matrix element;
!        2: reuse and scale coefficients from the last call;
!        note that scalings cannot be reset
! **********************************************************************
  use KIND_TYPES, only: REALKIND, DREALKIND, intkind2
#ifdef PRECISION_dp
  use KIND_TYPES, only: QREALKIND, intkind2
#endif
  use ol_debug, only: ol_fatal
  use ol_generic, only: to_string
  use ol_external_ppttj_ew_ttxbbxg_4, only: &
    & external_perm_inv_ppttj_ew_ttxbbxg_4, &
    & average_factor_ppttj_ew_ttxbbxg_4, &
    & photonid_ppttj_ew_ttxbbxg_4
  use ol_colourmatrix_ppttj_ew_ttxbbxg_4_/**/REALKIND ! colmat_not_initialised, K1, K2, KL, KL2, KL2ct, KL2ct2
  use ol_kinematics_/**/REALKIND, only: init_kinematics, get_rmass2
  use ol_parameters_decl_/**/REALKIND ! parameters_status, scalefactor, <masses>
  ! tensorrankuse: for compatibility with old OL versions only insert if rank > 6
  use ol_parameters_init_/**/REALKIND, only: ensure_mp_loop_init
  use ol_init, only: set_parameter, parameters_flush
  use ol_loop_parameters_decl_/**/REALKIND, only: loop_parameters_status
  use ol_loop_parameters_decl_/**/DREALKIND, only: IR_is_on, ioperator_mode, CT_is_on
  use ol_ew_renormalisation_/**/REALKIND, only: photon_factors
  use ol_momenta_decl_/**/DREALKIND, only: momenta_nan_check
  use ol_momenta_decl_/**/REALKIND, only: QInvariantsMatrix
  use ol_tensor_sum_storage_ppttj_ew_ttxbbxg_4_/**/REALKIND, only: &
    & reset_tensor_sum, integrate_tensor_sum, scale_tensor_sum, HOL_memory_allocation_full, &
    HCL_memory_allocation, set_integral_masses_and_momenta, Tsum_memory_allocation, &
    HOL_memory_allocation_optimized
  use ol_tables_storage_ppttj_ew_ttxbbxg_4_/**/DREALKIND, only: HOL_m3_init
  use ol_loop_ppttj_ew_ttxbbxg_4_/**/REALKIND, only: amp2
  use ol_loop_ppttj_ew_ttxbbxg_4_/**/DREALKIND, only: init_merging_tables, update_merging_tables
  use ol_loop_storage_ppttj_ew_ttxbbxg_4_/**/REALKIND, only: &
    & fac_status_loop1, fac_status_loop2, M0_col1_helarray
  use ol_i_operator_/**/REALKIND, only: intdip
  use ol_loop_storage_ppttj_ew_ttxbbxg_4_/**/DREALKIND, only: ntryL, nhel, p_switch, &
    & dp_not_alloc, qp_not_alloc
  use ol_settings_ppttj_ew_ttxbbxg_4, only: hel_mem_opt
  use hol_initialisation_/**/REALKIND, only: G0_hol_initialisation
  use ol_h_vert_interface_/**/REALKIND
  use ol_h_prop_interface_/**/REALKIND
  implicit none

  real(DREALKIND), intent(in)  :: P_scatt(0:3,5)
  real(REALKIND),  intent(out) :: M2L0, M2L1, IRL1(0:2), M2L2, IRL2(0:4)
  integer, intent(in), optional :: mode
  real(REALKIND)       :: P(0:3,5)
  integer              :: i, j, colmatpos, recycle_mode, ofred_mode
  complex(REALKIND)    :: M0_col1(4), Mct(4)
  complex(REALKIND)    :: Mcol_loop(4)
  real(REALKIND)       :: M2colint(16), M2CC(5,5), M2CC_EW ! colour correlations
  integer              :: extmasses2(5)
  real(REALKIND)       :: M2hel, M2ct, M2L2ct, M2L2ct2, vdip, c_dip(0:2)
  real(REALKIND)       :: scalebackfactor
  real(REALKIND)       :: bornphotonfactor = rONE , loopphotonfactor = rZERO
  integer(intkind2) :: helstates

  ofred_mode = 1

  if (present(mode)) then
    recycle_mode = mode
  else
    recycle_mode = 1
  end if

  call parameters_flush()
  call ensure_mp_loop_init()



  M2L0     = 0
  M2L1     = 0
  M2ct     = 0
  M2colint = 0
  M2L2     = 0
  M2L2ct   = 0
  M2L2ct2  = 0
  IRL1     = 0
  IRL2     = 0
  extmasses2 = [ nMT, nMT, nMB, nMB, 0 ]

  if (momenta_nan_check(P_scatt) /= 0) return

  ! Here we calculate the tree level squared using the helicity bookkeeping subroutines
  ! The value of the tree level squared is M2L0
  ! The subtrees are also initialised
  call amp2(P_scatt, M2L0, .true., M2ct=M2ct, M2colint=M2colint)

  !The following part refers to the 1-loop calculation
#ifndef PRECISION_dp
  if (ntryL==1 .OR. qp_not_alloc) then
    call Tsum_memory_allocation()
  end if
#else
  if (ntryL==1 .OR. dp_not_alloc) then
    call Tsum_memory_allocation()
  end if
#endif

#ifdef LOOPSQUARED
  call integrate_tensor_sum(M2L1)
#else
  if (recycle_mode == 1 .or. ofred_mode == 1) call reset_tensor_sum()
#endif

  ! Construction of the basis used for the reduction
  call redbaseconstr()
  ! Memory allocation for the hol types is done just for the first phase space point
  ! Memory is reallocated when switching from double- to quad-precision for the first time
#ifndef PRECISION_dp
  if (ntryL==1 .OR. qp_not_alloc) then
    if(hel_mem_opt) then
      call HOL_memory_allocation_optimized()
    else
      call HOL_memory_allocation_full()
    end if
    call HCL_memory_allocation()
    qp_not_alloc = .FALSE.
  end if
#else
  if (ntryL==1 .OR. dp_not_alloc) then
    if(hel_mem_opt) then
      call HOL_memory_allocation_optimized()
    else
      call HOL_memory_allocation_full()
    end if
    call HCL_memory_allocation()
    dp_not_alloc = .FALSE.
  end if
#endif

  if(ntryL == 1) then
    !! m3 initialization done just for the first phase space point
    call HOL_m3_init()
    !! first temporary initialization of the merging tables
    call init_merging_tables(32,1824)
  end if

  call set_integral_masses_and_momenta()

  !! Call for the calculation of the born-loop interference
  if (recycle_mode == 1 .or. ofred_mode == 1) then
    call vamp(M0_col1_helarray)
  end if

  !! Merging tables are adjusted and allocated with the proper dimensionality
  if(ntryL == 1) call update_merging_tables(32)

  if(ntryL==1) ntryL = ntryL + 1

#ifdef PRECISION_dp
  p_switch = 1
#else
  p_switch = 2
#endif


#ifdef LOOPSQUARED
  M2L2 = (M2L2 + 2*M2L2ct + M2L2ct2) / &
         & average_factor_ppttj_ew_ttxbbxg_4
#else
  if (recycle_mode == 2 .and. ofred_mode == 0) then
    call scale_tensor_sum()
  end if
  call integrate_tensor_sum(M2L1)
#endif

  if (IR_is_on > 0) then
    do i = 1, 5
      do j = 1, i
        ! Why does this work without permuting the colour correlation matrices?
        M2CC(i,j) = M2colint(i*(i-1)/2+j)
      end do
    end do
    do j = 2, 5
      do i = 1, j-1
        M2CC(i,j) = M2CC(j,i)
      end do
    end do
    M2CC_EW = M2colint(5*(5+1)/2+1)
    call intdip(ioperator_mode, M2L0, M2CC, M2CC_EW, [2,2,2,2,1], [2,-2,-1,1,0]/3._/**/REALKIND, &
      & 5, get_rmass2(extmasses2), QInvariantsMatrix, vdip, c_dip, &
      & 1, &
      & [( photonid_ppttj_ew_ttxbbxg_4( &
      & external_perm_inv_ppttj_ew_ttxbbxg_4(i)), &
      & i=1, size(external_perm_inv_ppttj_ew_ttxbbxg_4))])
    IRL1(0) = c_dip(0) / average_factor_ppttj_ew_ttxbbxg_4
    IRL1(1) = c_dip(1) / average_factor_ppttj_ew_ttxbbxg_4
    IRL1(2) = c_dip(2) / average_factor_ppttj_ew_ttxbbxg_4
  else
    vdip = 0
    IRL1 = 0
  end if

  ! loop^2 IR contribution: not implemented
  IRL2 = 0

  ! photon factors
  call photon_factors(photonid_ppttj_ew_ttxbbxg_4, &
       & 1, bornphotonfactor, loopphotonfactor)
  M2L0 = bornphotonfactor * M2L0
  M2L1 = bornphotonfactor * M2L1
  IRL1 = bornphotonfactor * IRL1
  M2L2 = bornphotonfactor * M2L2
  IRL2 = bornphotonfactor * IRL2
  M2ct = bornphotonfactor * M2ct
  vdip = bornphotonfactor * vdip
  if (CT_is_on .gt. 0) M2ct = M2ct+M2L0*loopphotonfactor

  ! Colour and helicity average and symmetry factor of outgoing particles
  M2L0 = M2L0 / average_factor_ppttj_ew_ttxbbxg_4
  M2L1 = 2*(M2L1 + M2ct)
  if (IR_is_on > 1) then
    M2L1 = M2L1 + vdip
  end if
  M2L1 = M2L1 / average_factor_ppttj_ew_ttxbbxg_4

  ! check for NaN result
  if (M2L0 /= M2L0) then
    M2L0 = 0
  end if
  if (M2L1 /= M2L1) then
    M2L1 = 0
    M2L2 = 0
    IRL1 = 0
    IRL2 = 0
  end if

  scalebackfactor = scalefactor**(2*5-8)
  M2L0 = scalebackfactor * M2L0
  M2L1 = scalebackfactor * M2L1
  IRL1 = scalebackfactor * IRL1
  M2L2 = scalebackfactor * M2L2
  IRL2 = scalebackfactor * IRL2
  M2L0cache = M2L0
  M2L1cache = M2L1

end subroutine vamp2base


! **********************************************************************
subroutine ctamp2base(P_scatt, M2tree, M2ct)
! The part of vamp2 which calculates tree and counter-term
! matrix elements, but not the loop. R2 is deactivated.
! Does not calculate loop^2 counterterms/R2.
! P_scatt(0:3,Npart) = external momenta
! M2tree = helicity-summed squared tree matrix element for top anti-top bottom anti-bottom glue -> 0
! M2ct   = helicity-summed counterterm matrix element
! **********************************************************************
  use KIND_TYPES, only: REALKIND, DREALKIND
  use ol_external_ppttj_ew_ttxbbxg_4, only: &
    & photonid_ppttj_ew_ttxbbxg_4
  use ol_colourmatrix_ppttj_ew_ttxbbxg_4_/**/REALKIND, only: &
    & colmat_not_initialised, K1, K2
  use ol_parameters_decl_/**/REALKIND ! parameters_status, scalefactor, <masses>
  use ol_parameters_decl_/**/DREALKIND, only: do_ew_renorm
  use ol_loop_parameters_decl_/**/DREALKIND, only: &
    & loop_parameters_status, CT_is_on, R2_is_on, TP_is_on
  use ol_ew_renormalisation_/**/REALKIND, only: photon_factors
  use ol_init, only: set_parameter, parameters_flush
  use ol_parameters_init_/**/REALKIND, only: ensure_mp_loop_init
  use ol_loop_parameters_decl_/**/DREALKIND, only: DOI
  use ol_external_ppttj_ew_ttxbbxg_4, only: &
    & external_perm_inv_ppttj_ew_ttxbbxg_4, average_factor_ppttj_ew_ttxbbxg_4
  use ol_momenta_decl_/**/DREALKIND, only: momenta_nan_check
  use ol_kinematics_/**/REALKIND, only: init_kinematics
  use ol_loop_storage_ppttj_ew_ttxbbxg_4_/**/REALKIND, only: &
    & fac_status_loop1, fac_status_loop2
  use ol_loop_ppttj_ew_ttxbbxg_4_/**/REALKIND, only: amp2
  implicit none

  real(DREALKIND), intent(in)  :: P_scatt(0:3,5)
  real(REALKIND),  intent(out) :: M2tree, M2ct
  real(REALKIND)    :: P(0:3,5)
  real(REALKIND)    :: M2colint(16)
  integer           :: CT_on_bak, R2_on_bak, TP_on_bak
  real(REALKIND)    :: scalebackfactor, bornphotonfactor = rONE, loopphotonfactor = rZERO
  integer           :: DOI_bak

  M2tree = 0
  M2ct   = 0

  if (CT_is_on == 2) then
    call set_parameter("ct_on", 1)
  else if (CT_is_on == -1) then
    call set_parameter("ct_on", 0)
  end if
  DOI_bak = DOI
  DOI = 0

  if (momenta_nan_check(P_scatt) /= 0)  return

  ! Here we calculate the tree level squared using the helicity bookkeeping subroutines
  call amp2(P_scatt, M2tree, .false., M2ct=M2ct)

  ! photon factors
  call photon_factors(photonid_ppttj_ew_ttxbbxg_4, 1, bornphotonfactor, loopphotonfactor)
  M2tree = bornphotonfactor * M2tree
  M2ct = bornphotonfactor * M2ct
  if (CT_is_on .gt. 0) M2ct = M2ct+M2tree*loopphotonfactor

  DOI = DOI_bak

  scalebackfactor = scalefactor**(2*5-8)
  M2tree = scalebackfactor * M2tree / average_factor_ppttj_ew_ttxbbxg_4
  M2ct   = scalebackfactor * 2*M2ct / average_factor_ppttj_ew_ttxbbxg_4

end subroutine ctamp2base



! **********************************************************************
subroutine iopamp2base(P_scatt, M2L0, IRL1)
! P_scatt(0:3,Npart) = external momenta
! IR0, IR1, IR2 = finite, single pole, and double pole IR contribution
! **********************************************************************
  use KIND_TYPES, only: REALKIND, DREALKIND, intkind2
#ifdef PRECISION_dp
  use KIND_TYPES, only: QREALKIND, intkind2
#endif
  use ol_debug, only: ol_fatal
  use ol_generic, only: to_string
  use ol_external_ppttj_ew_ttxbbxg_4, only: &
    & external_perm_inv_ppttj_ew_ttxbbxg_4, &
    & average_factor_ppttj_ew_ttxbbxg_4, &
    & photonid_ppttj_ew_ttxbbxg_4
  use ol_colourmatrix_ppttj_ew_ttxbbxg_4_/**/REALKIND ! colmat_not_initialised, K1, K2, KL, KL2, KL2ct, KL2ct2
  use ol_kinematics_/**/REALKIND, only: init_kinematics, get_rmass2
  use ol_parameters_decl_/**/REALKIND ! parameters_status, scalefactor, <masses>
  ! tensorrankuse: for compatibility with old OL versions only insert if rank > 6
  use ol_parameters_init_/**/REALKIND, only: ensure_mp_loop_init
  use ol_init, only: set_parameter, parameters_flush
  use ol_loop_parameters_decl_/**/REALKIND, only: loop_parameters_status
  use ol_loop_parameters_decl_/**/DREALKIND, only: IR_is_on, ioperator_mode
  use ol_ew_renormalisation_/**/REALKIND, only: photon_factors
  use ol_momenta_decl_/**/DREALKIND, only: momenta_nan_check
  use ol_momenta_decl_/**/REALKIND, only: QInvariantsMatrix
  use ol_loop_ppttj_ew_ttxbbxg_4_/**/REALKIND, only: amp2
  use ol_i_operator_/**/REALKIND, only: intdip
  use ol_loop_storage_ppttj_ew_ttxbbxg_4_/**/REALKIND, only: &
    & fac_status_loop1, fac_status_loop2
  implicit none

  real(DREALKIND), intent(in)  :: P_scatt(0:3,5)
  real(REALKIND),  intent(out) :: M2L0, IRL1(0:2)
  real(REALKIND)       :: P(0:3,5)
  integer              :: i, j, colmatpos
  complex(REALKIND)    :: M0_col1(4), Mct(4)
  complex(REALKIND)    :: Mcol_loop(4)
  real(REALKIND)       :: M2colint(16), M2CC(5,5), M2CC_EW ! colour correlations
  integer              :: extmasses2(5)
  real(REALKIND)       :: M2ct, M2hel, vdip, c_dip(0:2)
  real(REALKIND)       :: scalebackfactor
  real(REALKIND)       :: bornphotonfactor = rONE , loopphotonfactor = rZERO
  integer(intkind2) :: helstates

  M2L0     = 0
  M2ct     = 0
  M2colint = 0
  IRL1     = 0
  extmasses2 = [ nMT, nMT, nMB, nMB, 0 ]

  if (momenta_nan_check(P_scatt) /= 0) return

  ! Here we calculate the tree level squared using the helicity bookkeeping subroutines
  call amp2(P_scatt, M2L0, .false., M2colint=M2colint)

  if (IR_is_on > 0) then
    do i = 1, 5
      do j = 1, i
        ! Why does this work without permuting the colour correlation matrices?
        M2CC(i,j) = M2colint(i*(i-1)/2+j)
      end do
    end do
    do j = 2, 5
      do i = 1, j-1
        M2CC(i,j) = M2CC(j,i)
      end do
    end do
    M2CC_EW = M2colint(5*(5+1)/2+1)
    call intdip(ioperator_mode, M2L0, M2CC, M2CC_EW, [2,2,2,2,1], [2,-2,-1,1,0]/3._/**/REALKIND, &
      & 5, get_rmass2(extmasses2), QInvariantsMatrix, vdip, c_dip, &
      & 1, &
      & [( photonid_ppttj_ew_ttxbbxg_4( &
      & external_perm_inv_ppttj_ew_ttxbbxg_4(i)), &
      & i=1, size(external_perm_inv_ppttj_ew_ttxbbxg_4))])
    IRL1(0) = c_dip(0) / average_factor_ppttj_ew_ttxbbxg_4
    IRL1(1) = c_dip(1) / average_factor_ppttj_ew_ttxbbxg_4
    IRL1(2) = c_dip(2) / average_factor_ppttj_ew_ttxbbxg_4
  else
    vdip = 0
    IRL1 = 0
  end if

  ! photon factors
  call photon_factors(photonid_ppttj_ew_ttxbbxg_4, &
       & 1, bornphotonfactor, loopphotonfactor)
  M2L0 = bornphotonfactor * M2L0
  IRL1 = bornphotonfactor * IRL1

  ! check for NaN result
  if (M2L0 /= M2L0) then
    M2L0 = 0
    IRL1 = 0
  end if

  scalebackfactor = scalefactor**(2*5-8)
  M2L0 = scalebackfactor * M2L0
  IRL1 = scalebackfactor * IRL1

end subroutine iopamp2base



! **********************************************************************
subroutine vamp2cache(P_scatt, M2L0, M2L1, corr)
! **********************************************************************
  use KIND_TYPES, only: REALKIND, DREALKIND, intkind2
  use ol_parameters_decl_/**/REALKIND ! parameters_status, scalefactor, <masses>
  use ol_loop_parameters_decl_/**/DREALKIND, only: CT_is_on
  use ol_external_ppttj_ew_ttxbbxg_4, only: & 
    & extcomb_perm_ppttj_ew_ttxbbxg_4, &
    & average_factor_ppttj_ew_ttxbbxg_4, &
    & photonid_ppttj_ew_ttxbbxg_4
  use ol_loop_storage_ppttj_ew_ttxbbxg_4_/**/REALKIND, only: M2ctcc, M0M1_hel_cc
  use ol_tensor_sum_storage_ppttj_ew_ttxbbxg_4_/**/REALKIND, only: reset_tensor_sum, &
    & integrate_tensor_sum
  use ol_debug, only: ol_fatal
  use ol_colourmatrix_ppttj_ew_ttxbbxg_4_/**/REALKIND, only: Cas
  use ol_data_types_/**/DREALKIND, only: correlator
  use ol_ew_renormalisation_/**/REALKIND, only: photon_factors
  implicit none
  real(DREALKIND), intent(in)  :: P_scatt(0:3,5)
  real(REALKIND),  intent(out) :: M2L0, M2L1
  real(REALKIND) :: M2L1cc(0:16)
  real(REALKIND)       :: bornphotonfactor = rONE , loopphotonfactor = rZERO
  type(correlator) :: corr
#if 5 > 3
  integer :: co, k, m, ind_cc_comb(5)
#else
  integer :: co, k, m
#endif
#if 1 > 0
  ind_cc_comb = [2,4,7,5,8]
  M2L1cc = 0
  !! Diagonal born-loop colour correlators
  co = 0
  do k = 1, 5
    co = co + k
    M2L1cc(co) = Cas(k)*M2L1cache
  end do
#if 5 > 3
  ! photon factors
  call photon_factors(photonid_ppttj_ew_ttxbbxg_4, &
       & 1, bornphotonfactor, loopphotonfactor)
  if (CT_is_on .gt. 0) M2ctcc = M2ctcc+M2L0cache*loopphotonfactor
  !! Independent colour correlators
  do k = 1, 5
    m = ind_cc_comb(k)
    call reset_tensor_sum()
    M2L1 = 0
    if(sum(abs(M0M1_hel_cc(:,:,m)%j)) == 0) then
      M2L1 = 0
    else
      call vamp(M0M1_hel_cc(:,:,m))
      call integrate_tensor_sum(M2L1)
    end if
    M2L1 = bornphotonfactor * M2L1
    M2L1cc(m) = 2*(M2L1 + M2ctcc(m))/average_factor_ppttj_ew_ttxbbxg_4
  end do
#endif
  !! Linearly dependent colour correlators
  M2L1cc(11) = -(M2L1cache*Cas(1)) - M2L1cc(2) - M2L1cc(4) - M2L1cc(7)
  M2L1cc(12) = -(M2L1cache*Cas(2)) - M2L1cc(2) - M2L1cc(5) - M2L1cc(8)
  M2L1cc(9) = -(M2L1cache*(Cas(1) + Cas(2) + Cas(3) + Cas(4) - Cas(5)))/2 - M2L1cc(2) - M2L1cc(4) - M2L1cc(5)  &
  - M2L1cc(7) - M2L1cc(8)
  M2L1cc(13) = (M2L1cache*(Cas(1) + Cas(2) - Cas(3) + Cas(4) - Cas(5)))/2 + M2L1cc(2) + M2L1cc(7) + M2L1cc(8)
  M2L1cc(14) = (M2L1cache*(Cas(1) + Cas(2) + Cas(3) - Cas(4) - Cas(5)))/2 + M2L1cc(2) + M2L1cc(4) + M2L1cc(5)
  
  do k = 1, 16
    corr%rescc(k) = M2L1cc(extcomb_perm_ppttj_ew_ttxbbxg_4(k))
  end do
  M2L0 = M2L0cache
  corr%rescc(0) = M2L1cache
  M2L1 = M2L1cache
#else
  call ol_fatal("born-loop colour correlators not available for process ppttj_ew_ttxbbxg_4")
#endif
end subroutine vamp2cache

! **********************************************************************
subroutine schsfamp2base(P_scatt, M2tree, i, j, M2hsf)
! P_scatt(0:3,Npart) = external momenta
! M2tree = helicity-summed squared tree matrix element for
!          top anti-top bottom anti-bottom glue -> 0
! M2hsf  = spin correlated hard scattering factor. Eq. (66) in 1011.3918
! **********************************************************************
  use KIND_TYPES, only: REALKIND, DREALKIND
  use ol_parameters_decl_/**/REALKIND, only: scalefactor
  use ol_parameters_init_/**/REALKIND, only: ensure_mp_init
  use ol_external_ppttj_ew_ttxbbxg_4, only: &
 &  average_factor_ppttj_ew_ttxbbxg_4, &
 &  photonid_ppttj_ew_ttxbbxg_4
  use ol_momenta_decl_/**/DREALKIND, only: momenta_nan_check
  use ol_loop_ppttj_ew_ttxbbxg_4_/**/REALKIND, only: hsfamp2
  use ol_ew_renormalisation_/**/REALKIND, only: photon_factors
  implicit none
  real(DREALKIND), intent(in) :: P_scatt(0:3,5)
  integer, intent(in) :: i, j
  real(REALKIND), intent(out) :: M2tree, M2hsf
  real(REALKIND) :: scalebackfactor, bornphotonfactor
  M2tree = 0
  M2hsf = 0
  call ensure_mp_init()
  if (momenta_nan_check(P_scatt) /= 0)  return
  call hsfamp2(P_scatt, M2tree, i, j, M2hsf)

  ! photon-factors
  call photon_factors(photonid_ppttj_ew_ttxbbxg_4, 0, bornphotonfactor)
  M2tree = bornphotonfactor * M2tree
  M2hsf = bornphotonfactor * M2hsf

  scalebackfactor = scalefactor**(2*5-8)
  M2tree = scalebackfactor * M2tree / average_factor_ppttj_ew_ttxbbxg_4
  M2hsf  = scalebackfactor * M2hsf / average_factor_ppttj_ew_ttxbbxg_4
end subroutine schsfamp2base

subroutine vamp2pc(P_scatt, M2L0, M2L1, IRL1, M2L2, IRL2, mode)
  ! polecheck routine: perform multiple calls of vamp2
  ! with different values of the UV/IR poles
  ! to determine the coefficients of the IR poles.
  use KIND_TYPES, only: REALKIND, DREALKIND
  use ol_parameters_decl_/**/DREALKIND, only: rZERO_dp => rZERO
  use ol_loop_parameters_decl_/**/REALKIND, only: &
    & de1_UV, de1_IR, de2_i_IR
  use ol_loop_parameters_decl_/**/DREALKIND, only: &
    & polescale_dp => polescale, polecheck_is, CT_is_on, IR_is_on
  use ol_init, only: set_parameter
  implicit none
  real(DREALKIND), intent(in)  :: P_scatt(:,:)
  real(REALKIND),  intent(out) :: M2L0, M2L1(0:2), IRL1(0:2), M2L2(0:4), IRL2(0:4)
  integer, intent(in), optional :: mode
  real(DREALKIND) :: poleUV1bak, poleIR1bak, poleIR2bak
  integer         :: CT_on_bak, IR_on_bak
  real(REALKIND)  :: M2L1_00, M2L1_10, M2L1_01, M2L1_20, M2L1_02, M2L1_11
  real(REALKIND)  :: M2L2_00, M2L2_10, M2L2_01, M2L2_20, M2L2_02, M2L2_11
  real(REALKIND)  :: IRL1x(0:2), IRL2x(0:4)

  if (polecheck_is == 0) then
    call vamp2base(P_scatt, M2L0, M2L1(0), IRL1, M2L2(0), IRL2, mode)
    if (IR_is_on == 2) then
      M2L1(1:2) = 0
      M2L2(1:4) = 0
    else
      M2L1(1:2) = -IRL1(1:2)
      M2L2(1:4) = -IRL2(1:4)
    end if
  else
    ! remember original parameters
    poleUV1bak = de1_UV
    poleIR1bak = de1_IR
    poleIR2bak = de2_i_IR
    CT_on_bak  = CT_is_on
    IR_on_bak  = IR_is_on
    ! three calls with different IR poles; IR subtractions are calculated but not added
    call set_parameter("pole_uv", rZERO_dp)
    call set_parameter("pole_ir1", rZERO_dp)
    call set_parameter("pole_ir2", rZERO_dp)
    call set_parameter("ct_on", 1)
    call set_parameter("ir_on", 1)
    call vamp2base(P_scatt, M2L0, M2L1_00, IRL1, M2L2_00, IRL2, mode)
    call set_parameter("pole_uv", polescale_dp)
    call set_parameter("pole_ir1", polescale_dp)
    call set_parameter("pole_ir2", rZERO_dp)
    call set_parameter("ir_on", 0)
    call vamp2base(P_scatt, M2L0, M2L1_10, IRL1x, M2L2_10, IRL2x, mode)
    call set_parameter("pole_uv", rZERO_dp)
    call set_parameter("pole_ir1", rZERO_dp)
    call set_parameter("pole_ir2", polescale_dp)
    call vamp2base(P_scatt, M2L0, M2L1_01, IRL1x, M2L2_01, IRL2x, mode)

    M2L1(0) = M2L1_00
    M2L1(1) = (M2L1_10 - M2L1_00)/polescale_dp
    M2L1(2) = (M2L1_01 - M2L1_00)/polescale_dp

#ifdef LOOPSQUARED
    call set_parameter("pole_uv", polescale_dp)
    call set_parameter("pole_ir1", 2*polescale_dp)
    call set_parameter("pole_ir2", rZERO_dp)
    call vamp2base(P_scatt, M2L0, M2L1_20, IRL1x, M2L2_20, IRL2x)
    call set_parameter("pole_uv", rZERO_dp)
    call set_parameter("pole_ir1", rZERO_dp)
    call set_parameter("pole_ir2", 2*polescale_dp)
    call vamp2base(P_scatt, M2L0, M2L1_02, IRL1x, M2L2_02, IRL2x)
    call set_parameter("pole_uv", rZERO_dp)
    call set_parameter("pole_ir1", polescale_dp)
    call set_parameter("pole_ir2", polescale_dp)
    call vamp2base(P_scatt, M2L0, M2L1_11, IRL1x, M2L2_11, IRL2x)

    M2L2(0) = M2L2_00
    M2L2(1) = (-3*M2L2_00 - M2L2_20 + 4*M2L2_10)/(2*polescale_dp)
    M2L2(2) = (-3*M2L2_00 + 4*M2L2_01 - M2L2_02)/(2*polescale_dp) + (M2L2_00 - 2*M2L2_10 + M2L2_20)/(2*polescale_dp**2)
    M2L2(3) = (M2L2_00 - M2L2_01 - M2L2_10 + M2L2_11)/polescale_dp**2
    M2L2(4) = (M2L2_00 + M2L2_02 - 2*M2L2_01)/(2*polescale_dp**2)
#endif
    ! restore original parameters
    call set_parameter("pole_uv", poleUV1bak)
    call set_parameter("pole_ir1", poleIR1bak)
    call set_parameter("pole_ir2", poleIR2bak)
    call set_parameter("ct_on", CT_on_bak)
    call set_parameter("ir_on", IR_on_bak)
    if (IR_on_bak == 2) then
      M2L1 = M2L1 + IRL1
      M2L2 = M2L2 + IRL2
    end if
  end if

end subroutine vamp2pc

end module ol_vamp_ppttj_ew_ttxbbxg_4_/**/REALKIND


#ifdef DUMMY_qp
module ol_vamp_ppttj_ew_ttxbbxg_4_/**/QREALKIND
  implicit none
  contains
  subroutine vamp2pc(P_scatt, M2L0, M2L1, IRL1, M2L2, IRL2, mode)
    ! Dummy quad precision routine. Throws an error if the process called but
    ! the process has not been compiled in quad precision.
    use KIND_TYPES, only: DREALKIND, QREALKIND
    use ol_debug, only: ol_fatal
    implicit none
    real(DREALKIND), intent(in)  :: P_scatt(:,:)
    real(QREALKIND),  intent(out) :: M2L0, M2L1(0:2), IRL1(0:2), M2L2(0:4), IRL2(0:4)
    integer, intent(in), optional :: mode
    call ol_fatal("Process ppttj_ew_ttxbbxg_4" &
      & // "has not been compiled in quad precision")
  end subroutine vamp2pc
end module ol_vamp_ppttj_ew_ttxbbxg_4_/**/QREALKIND
#endif


#ifdef PRECISION_dp

module ol_vamp_ppttj_ew_ttxbbxg_4
  use ol_parameters_decl_/**/DREALKIND, only: procname_length
  use ol_data_types_/**/DREALKIND, only: me_cache
  implicit none
  character(procname_length) :: processname = 'ppttj_ew_ttxbbxg_4'
  integer, save :: qp_eval = 0, killed = 0
  integer, save :: npoints(8) = 0
  integer, save :: stability_histogram(20) = 0, stability_histogram_qp(20) = 0
  type(me_cache), allocatable, target, save :: me_caches(:)
  contains

  subroutine finish_ppttj_ew_ttxbbxg_4()
    ! final update of the stability histogram and memory deallocation
    use KIND_TYPES, only: DREALKIND
!   use ol_data_types_/**/REALKIND, only: Hpolcont
!   use ol_tensor_sum_storage_ppttj_ew_ttxbbxg_4_/**/DREALKIND, only: HOL_memory_allocation
    use ol_stability, only: finish_histograms
    use ol_vamp_ppttj_ew_ttxbbxg_4_/**/DREALKIND, only: vamp
    use ol_tensor_sum_storage_ppttj_ew_ttxbbxg_4_/**/DREALKIND, only: &
      & HOL_memory_deallocation_/**/DREALKIND, HCL_memory_deallocation_/**/DREALKIND
#ifndef DUMMY_qp
    use ol_tensor_sum_storage_ppttj_ew_ttxbbxg_4_/**/QREALKIND, only: &
      & HOL_memory_deallocation_/**/QREALKIND, HCL_memory_deallocation_/**/QREALKIND
#endif
    use ol_loop_storage_ppttj_ew_ttxbbxg_4_/**/DREALKIND, only: &
      & dp_not_alloc, qp_not_alloc, merge_tables, merge_mism, merge_hels, merge_tables_on, A, &
      & M1helarray, M1helarray_ct, M0_col1_helarray, M0M1_hel_cc, hflip
      implicit none
      integer :: k
!   type(Hpolcont) :: Mdummy(4,32)
!   call HOL_memory_allocation()
!   call vamp(Mdummy)

    ! Memory is deallocated for both dp and/or qp stored hol coefficients
    if (.NOT. dp_not_alloc) then
      call HOL_memory_deallocation_/**/DREALKIND(0)
      call HCL_memory_deallocation_/**/DREALKIND(0)
    end if
#ifndef DUMMY_qp
    if (.NOT. qp_not_alloc) then
      call HOL_memory_deallocation_/**/QREALKIND(0)
      call HCL_memory_deallocation_/**/QREALKIND(0)
    end if
#endif

    if (merge_tables_on) then
      if (allocated(merge_tables)) deallocate(merge_tables)
      if (allocated(merge_mism)) deallocate(merge_mism)
      if (allocated(merge_hels)) deallocate(merge_hels)
      merge_tables_on = .false.
    end if

    if (allocated(A)) deallocate(A)
    if (allocated(M1helarray)) deallocate(M1helarray)
    if (allocated(M1helarray_ct)) deallocate(M1helarray_ct)
    if (allocated(M0_col1_helarray)) deallocate(M0_col1_helarray)
    if (allocated(M0M1_hel_cc)) deallocate(M0M1_hel_cc)
    if (allocated(hflip)) deallocate(hflip)

    if (allocated(me_caches)) then
      do k = 1, size(me_caches)
      if (allocated(me_caches(k)%psp)) deallocate(me_caches(k)%psp)
      if (allocated(me_caches(k)%me)) deallocate(me_caches(k)%me)
    end do
      if (allocated(me_caches)) deallocate(me_caches)
    end if
    call finish_histograms(processname, stability_histogram, stability_histogram_qp, npoints, qp_eval, killed)
  end subroutine finish_ppttj_ew_ttxbbxg_4


  subroutine vamp2(P_scatt, M2L0, M2L1, IRL1, M2L2, IRL2) &
      & bind(c,name="ol_f_vamp2_ppttj_ew_ttxbbxg_4")
    use KIND_TYPES, only: DREALKIND
    use ol_init, only: register_cleanup
    use ol_external_ppttj_ew_ttxbbxg_4, only: &
      & external_perm_ppttj_ew_ttxbbxg_4
    use ol_vamp_ppttj_ew_ttxbbxg_4_/**/DREALKIND, only: vamp2dp => vamp2pc
    use ol_vamp_ppttj_ew_ttxbbxg_4_/**/QREALKIND, only: vamp2qp => vamp2pc
    use ol_stability, only: vamp2generic
    implicit none
    real(DREALKIND), intent(in)  :: P_scatt(0:3,5)
    real(DREALKIND), intent(out) :: M2L0, M2L1(0:2), IRL1(0:2), M2L2(0:4), IRL2(0:4)
    real(DREALKIND), save :: abs_kfactor_threshold = 1, trigeff_local = 0, sum_M2tree = 0
    logical :: first_call = .true.
    if (first_call) then
      call register_cleanup(finish_ppttj_ew_ttxbbxg_4)
      first_call = .false.
    end if
    call vamp2generic(vamp2dp, vamp2qp, processname, P_scatt, M2L0, M2L1, IRL1, M2L2, IRL2, &
                    & abs_kfactor_threshold, trigeff_local, sum_M2tree, &
                    & npoints, qp_eval, killed, stability_histogram, stability_histogram_qp, &
                    & external_perm_ppttj_ew_ttxbbxg_4, me_caches)
  end subroutine vamp2


  subroutine ctamp2(P_scatt, M2tree, M2ct) &
      & bind(c,name="ol_f_ctamp2_ppttj_ew_ttxbbxg_4")
    use KIND_TYPES, only: DREALKIND
    use ol_vamp_ppttj_ew_ttxbbxg_4_/**/DREALKIND, only: ctamp2base
    implicit none
    real(DREALKIND), intent(in)  :: P_scatt(0:3,5)
    real(DREALKIND), intent(out) :: M2tree, M2ct
    call ctamp2base(P_scatt, M2tree, M2ct)
  end subroutine ctamp2


  subroutine iopamp2(P_scatt, M2tree, IRL1) &
      & bind(c,name="ol_f_iopamp2_ppttj_ew_ttxbbxg_4")
    use KIND_TYPES, only: DREALKIND
    use ol_vamp_ppttj_ew_ttxbbxg_4_/**/DREALKIND, only: iopamp2base
    implicit none
    real(DREALKIND), intent(in)  :: P_scatt(0:3,5)
    real(DREALKIND), intent(out) :: M2tree, IRL1(0:2)
    call iopamp2base(P_scatt, M2tree, IRL1)
  end subroutine iopamp2


  !Spin-Correlated Hard Scattering Factor
  subroutine schsfamp2(P_scatt, M2tree, i, j, M2hsf) &
      & bind(c,name="ol_f_schsfamp2_ppttj_ew_ttxbbxg_4")
    use KIND_TYPES, only: DREALKIND
    use ol_vamp_ppttj_ew_ttxbbxg_4_/**/DREALKIND, only: schsfamp2base
    implicit none
    real(DREALKIND), intent(in)  :: P_scatt(0:3,5)
    integer, intent(in)  :: i, j
    real(DREALKIND), intent(out) :: M2tree, M2hsf
    call schsfamp2base(P_scatt, M2tree, i, j, M2hsf)
  end subroutine schsfamp2

  subroutine vamp2_c(P_scatt, M2L0, M2L1, IRL1, M2L2, IRL2) &
      & bind(c,name="ol_vamp2_ppttj_ew_ttxbbxg_4")
    use KIND_TYPES, only: DREALKIND
    use, intrinsic :: iso_c_binding, only: c_double
    implicit none
    real(c_double), intent(in)  :: P_scatt(0:3,5)
    real(c_double), intent(out) :: M2L0, M2L1(0:2), IRL1(0:2), M2L2(0:4), IRL2(0:4)
    real(DREALKIND) :: f_p_scatt(0:3,5)
    real(DREALKIND) :: f_m2l0, f_m2l1(0:2), f_irl1(0:2), f_m2l2(0:4), f_irl2(0:4)
    f_p_scatt = P_scatt
    call vamp2(f_p_scatt, f_m2l0, f_m2l1, f_irl1, f_m2l2, f_irl2)
    M2L0 = f_m2l0
    M2L1 = f_m2l1
    IRL1 = f_irl1
    M2L2 = f_m2l2
    IRL2 = f_irl2
  end subroutine vamp2_c


  subroutine ctamp2_c(P_scatt, M2tree, M2ct) &
      & bind(c,name="ol_ctamp2_ppttj_ew_ttxbbxg_4")
    use KIND_TYPES, only: DREALKIND
    use, intrinsic :: iso_c_binding, only: c_double
    implicit none
    real(c_double), intent(in)  :: P_scatt(0:3,5)
    real(c_double), intent(out) :: M2tree, M2ct
    real(DREALKIND) :: f_p_scatt(0:3,5)
    real(DREALKIND) :: f_m2tree, f_m2ct
    f_p_scatt = P_scatt
    call ctamp2(f_p_scatt, f_m2tree, f_m2ct)
    M2tree = f_m2tree
    M2ct = f_m2ct
  end subroutine ctamp2_c

  !!! Interface for tree-loop correlators.
  subroutine vampcr2(P_scatt, M2L0, M2L1, M2L2, crtype, &
      & emitter, nextcombs, extcombs, mom, M2cc, M2munu) &
      & bind(c,name="ol_f_vampcr2_ppttj_ew_ttxbbxg_4")
    use KIND_TYPES, only: DREALKIND
    use ol_debug, only: ol_error
    use ol_vamp_ppttj_ew_ttxbbxg_4_/**/DREALKIND, only: vamp2cache
    use ol_data_types_/**/DREALKIND, only: correlator
    implicit none
    real(DREALKIND), intent(in)  :: P_scatt(0:3,5), mom(:)
    real(DREALKIND), intent(out) :: M2L0, M2L1, M2L2, M2cc(0:16)
    integer, intent(in) :: crtype, emitter, nextcombs, extcombs(nextcombs)
    real(DREALKIND), intent(out) :: M2munu(:,:)
    type(correlator) :: corr
    M2L0 = 0
    M2L1 = 0
    M2L2 = 0
    corr%type=crtype
    if(crtype == 11) then
      allocate(corr%rescc(0:16))
      call vamp2cache(P_scatt, M2L0, M2L1, corr=corr)
      M2cc = corr%rescc
      deallocate(corr%rescc)
    else
      call ol_error(1,"Correlator not available")
    end if
  end subroutine vampcr2

end module ol_vamp_ppttj_ew_ttxbbxg_4

! #ifdef PRECISION_dp
#endif
