
module ol_vamp_4_ppttj_ew_ttxaag_2_/**/REALKIND
contains

! **********************************************************************
subroutine vamp_4(M)
! P(0:3,nlegs) = incoming external momenta
! Uses tree structures 'wf', factors 'c', and denominators 'den' from loop_ppttj_ew_ttxaag_2.
! Sets colour stripped amplitudes A from the module loop_amplitudes_ppttj_ew_ttxaag_2.
! **********************************************************************
  use KIND_TYPES, only: REALKIND, QREALKIND, intkind2
  use ol_parameters_decl_/**/DREALKIND, only: l_switch
  use ol_parameters_decl_/**/QREALKIND ! masses
  use ol_vert_interface_/**/REALKIND
  use ol_prop_interface_/**/REALKIND
  use ol_last_step_/**/REALKIND
  use ol_tables_storage_ppttj_ew_ttxaag_2_/**/DREALKIND
  use ol_tensor_sum_storage_ppttj_ew_ttxaag_2_/**/REALKIND
  use ol_loop_handling_/**/REALKIND
  use ofred_reduction_/**/REALKIND, only: Hotf_4pt_reduction, Hotf_4pt_reduction_last
  use ofred_reduction_/**/REALKIND, only: Hotf_5pt_reduction, Hotf_5pt_reduction_last
  use ol_loop_reduction_/**/REALKIND, only: TI_bubble_red, TI_triangle_red
use ol_loop_reduction_/**/REALKIND, only: compute_scalar_box

  use ol_loop_storage_ppttj_ew_ttxaag_2_/**/REALKIND
#ifndef PRECISION_dp
  use ol_loop_storage_ppttj_ew_ttxaag_2_/**/DREALKIND, only: &
    & p_switch, Hel, merge_step, merge_mism, merge_tables, merge_hels, ntryL, hel_states
#endif
  use hol_initialisation_/**/REALKIND, only: G0_hol_initialisation
  use ol_h_vert_interface_/**/REALKIND
  use ol_h_prop_interface_/**/REALKIND
  use ol_h_last_step_/**/REALKIND
  use ol_merging_/**/REALKIND, only: ol_merge, ol_merge_tensors, ol_merge_last

  implicit none

  type(Hpolcont) :: Gcoeff(hel_states)
  type(Hpolcont), intent(in) :: M(1,hel_states)


#ifndef PRECISION_dp
  if (ntryL==1 .OR. p_switch == 1) Gcoeff(:)%hf = Hel(1:hel_states)
#else
  if (ntryL==1 .OR. p_switch == 2) Gcoeff(:)%hf = Hel(1:hel_states)
#endif

  ! =============================================
  call Hcheck_last_SV_V(ntryL,l_switch,G1H2(217),ex3(:),G1tensor(74),m3h2x1(:,690),heltab2x2(:,:,690))
  call Hcheck_last_VV_S(ntryL,l_switch,G1H2(228),ex3(:),G1tensor(63),m3h2x1(:,691),heltab2x2(:,:,691))
  call Hcheck_last_UV_W(ntryL,l_switch,G1H2(239),27,ex3(:),4,G2tensor(224),m3h2x1(:,692),heltab2x2(:,:,692))
  call Hcheck_last_QA_S(ntryL,l_switch,G2H4(17),wf4(:,4),G2tensor(422),ngH,m3h4x1(:,103),heltab2x4(:,:,443))
  call Hcheck_last_QA_S(ntryL,l_switch,G2H4(18),wf4(:,4),G2tensor(230),ngX,m3h4x1(:,104),heltab2x4(:,:,444))
  call Hcheck_last_QA_S(ntryL,l_switch,G2H4(19),wf4(:,4),G2tensor(425),ngPtb,m3h4x1(:,105),heltab2x4(:,:,445))
  call Hcheck_last_QA_V(ntryL,l_switch,G2H4(23),wf4(:,4),G2tensor(428),m3h4x1(:,106),heltab2x4(:,:,446))
  call Hcheck_last_QA_Z(ntryL,l_switch,G2H4(24),wf4(:,4),G2tensor(431),ngZu,m3h4x1(:,107),heltab2x4(:,:,447))
  call Hcheck_last_QA_W(ntryL,l_switch,G2H4(22),wf4(:,4),G2tensor(434),m3h4x1(:,108),heltab2x4(:,:,448))
  call Hloop_SA_Q(ntryL,G1H8(43),wf8(:,37),G1H1(1),ngH,m3h8x1(:,19),heltab2x8(:,:,255))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,nMT,G2tensor(437),n2h1(739))
  call Hloop_SA_Q(ntryL,G1H8(44),wf8(:,37),G1H1(1),ngX,m3h8x1(:,20),heltab2x8(:,:,256))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,nMT,G2tensor(476),n2h1(740))
  call Hloop_SA_Q(ntryL,G1H8(45),wf8(:,37),G1H1(1),ngPtb,m3h8x1(:,21),heltab2x8(:,:,257))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,nMB,G2tensor(260),n2h1(741))
  call Hloop_VA_Q(ntryL,G1H8(46),wf8(:,37),G1H1(1),m3h8x1(:,22),heltab2x8(:,:,258))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,nMT,G2tensor(443),n2h1(742))
  call Hloop_ZA_Q(ntryL,G1H8(47),wf8(:,37),G1H1(1),ngZu,m3h8x1(:,23),heltab2x8(:,:,259))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,nMT,G2tensor(266),n2h1(743))
  call Hloop_WA_Q(ntryL,G1H8(48),wf8(:,37),G1H1(1),m3h8x1(:,24),heltab2x8(:,:,260))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,nMB,G2tensor(446),n2h1(744))
  call Hcheck_last_SV_T(ntryL,l_switch,G1H2(337),27,ex3(:),4,G2tensor(485),m3h2x1(:,693),heltab2x2(:,:,693))
  call Hcheck_last_SV_V(ntryL,l_switch,G1H2(327),ex3(:),G1tensor(104),m3h2x1(:,694),heltab2x2(:,:,694))
  call Hcheck_last_VV_S(ntryL,l_switch,G1H2(13),ex3(:),G1tensor(116),m3h2x1(:,695),heltab2x2(:,:,695))
  call Hcheck_last_UW_V(ntryL,l_switch,G1H2(19),27,ex3(:),4,G2tensor(272),m3h2x1(:,696),heltab2x2(:,:,696))
  call Hloop_AV_Q(ntryL,G2H2(19),ex4(:),G2H1(1),m3h2x1(:,697),heltab2x2(:,:,697))
  call Hcheck_last_A_Q(ntryL,l_switch,G2H1(1),31,nME,G3tensor(9),n2h1(745))
  call Hloop_AV_Q(ntryL,G2H2(11),ex4(:),G2H1(1),m3h2x1(:,698),heltab2x2(:,:,698))
  call Hcheck_last_A_Q(ntryL,l_switch,G2H1(1),31,nMM,G3tensor(10),n2h1(746))
  call Hloop_AV_Q(ntryL,G2H2(7),ex4(:),G2H1(1),m3h2x1(:,699),heltab2x2(:,:,699))
  call Hcheck_last_A_Q(ntryL,l_switch,G2H1(1),31,nML,G3tensor(11),n2h1(747))
  call Hloop_QV_A(ntryL,G2H2(15),ex4(:),G2H1(1),m3h2x1(:,700),heltab2x2(:,:,700))
  call Hcheck_last_Q_A(ntryL,l_switch,G2H1(1),31,nME,G3tensor(12),n2h1(748))
  call Hloop_QV_A(ntryL,G2H2(31),ex4(:),G2H1(1),m3h2x1(:,701),heltab2x2(:,:,701))
  call Hcheck_last_Q_A(ntryL,l_switch,G2H1(1),31,nMM,G3tensor(13),n2h1(749))
  call Hloop_QV_A(ntryL,G2H2(112),ex4(:),G2H1(1),m3h2x1(:,702),heltab2x2(:,:,702))
  call Hcheck_last_Q_A(ntryL,l_switch,G2H1(1),31,nML,G3tensor(14),n2h1(750))
  call Hcheck_last_DV_C(ntryL,l_switch,G2H2(59),23,ex4(:),G3tensor(15),m3h2x1(:,703),heltab2x2(:,:,703))
  call Hcheck_last_CV_D(ntryL,l_switch,G2H2(51),23,ex4(:),8,G3tensor(16),m3h2x1(:,704),heltab2x2(:,:,704))
  call Hcheck_last_SV_V(ntryL,l_switch,G2H2(71),ex4(:),G2tensor(452),m3h2x1(:,705),heltab2x2(:,:,705))
  call Hcheck_last_VV_S(ntryL,l_switch,G2H2(21),ex4(:),G2tensor(278),m3h2x1(:,706),heltab2x2(:,:,706))
  call Hloop_AV_Q(ntryL,G2H2(156),ex4(:),G2H1(1),m3h2x1(:,707),heltab2x2(:,:,707))
  call Hcheck_last_A_Q(ntryL,l_switch,G2H1(1),31,0,G3tensor(17),n2h1(751))
  call Hloop_QV_A(ntryL,G2H2(75),ex4(:),G2H1(1),m3h2x1(:,708),heltab2x2(:,:,708))
  call Hcheck_last_Q_A(ntryL,l_switch,G2H1(1),31,0,G3tensor(18),n2h1(752))
  call ol_merge_tensors(G2tensor(552),[G2tensor(186),G2tensor(16),G1tensor(157),G1tensor(127),G0tensor(27),G0tensor(22)])
  call ol_merge_tensors(G2tensor(564),[G2tensor(555),G2tensor(204),G2tensor(192),G2tensor(20),G1tensor(14),G1tensor(174) &
    ,G0tensor(37),G0tensor(32)])
  call ol_merge_tensors(G2tensor(591),[G2tensor(588),G2tensor(567),G2tensor(558),G2tensor(207),G2tensor(195),G2tensor(24) &
    ,G1tensor(552),G1tensor(42),G1tensor(30),G0tensor(552),G0tensor(47),G0tensor(42)])
  call ol_merge_tensors(G2tensor(561),[G2tensor(201),G2tensor(28),G1tensor(62),G1tensor(102),G0tensor(57),G0tensor(52)])
  call ol_merge_tensors(G2tensor(26),[G2tensor(258),G2tensor(210),G2tensor(64),G2tensor(32),G1tensor(142),G1tensor(9),G1tensor(92) &
    ,G1tensor(78),G0tensor(142),G0tensor(103),G0tensor(67),G0tensor(62)])
  call ol_merge_tensors(G2tensor(46),[G2tensor(31),G2tensor(264),G2tensor(216),G2tensor(68),G2tensor(36),G1tensor(89) &
    ,G1tensor(172),G1tensor(144),G1tensor(81),G0tensor(147),G0tensor(113),G0tensor(77),G0tensor(72)])
  call ol_merge_tensors(G2tensor(239),[G2tensor(35),G2tensor(270),G2tensor(222),G2tensor(72),G2tensor(40),G1tensor(100) &
    ,G1tensor(46),G1tensor(140),G1tensor(128),G0tensor(152),G0tensor(123),G0tensor(87),G0tensor(82)])
  call ol_merge_tensors(G2tensor(42),[G2tensor(276),G2tensor(228),G2tensor(76),G2tensor(44),G1tensor(111),G1tensor(57) &
    ,G1tensor(170),G1tensor(33),G0tensor(157),G0tensor(133),G0tensor(97),G0tensor(92)])
  call ol_merge_tensors(G2tensor(528),[G2tensor(234),G2tensor(48),G1tensor(71),G1tensor(5),G0tensor(107),G0tensor(102)])
  call ol_merge_tensors(G2tensor(540),[G2tensor(531),G2tensor(252),G2tensor(240),G2tensor(52),G1tensor(34),G1tensor(22) &
    ,G0tensor(117),G0tensor(112)])
  call ol_merge_tensors(G2tensor(573),[G2tensor(570),G2tensor(543),G2tensor(534),G2tensor(255),G2tensor(243),G2tensor(56) &
    ,G1tensor(537),G1tensor(47),G1tensor(58),G0tensor(537),G0tensor(127),G0tensor(122)])
  call ol_merge_tensors(G2tensor(537),[G2tensor(249),G2tensor(60),G1tensor(160),G1tensor(53),G0tensor(137),G0tensor(132)])
  call ol_merge_tensors(G2tensor(347),[G2tensor(306),G2tensor(282),G2tensor(96),G2tensor(80),G1tensor(202),G1tensor(137) &
    ,G1tensor(173),G1tensor(133),G0tensor(202),G0tensor(167),G0tensor(162),G0tensor(23)])
  call ol_merge_tensors(G2tensor(11),[G2tensor(2),G2tensor(312),G2tensor(288),G2tensor(100),G2tensor(84),G1tensor(207) &
    ,G1tensor(166),G1tensor(149),G1tensor(6),G0tensor(207),G0tensor(177),G0tensor(172),G0tensor(33)])
  call ol_merge_tensors(G2tensor(515),[G2tensor(119),G2tensor(318),G2tensor(294),G2tensor(104),G2tensor(88),G1tensor(212) &
    ,G1tensor(187),G1tensor(182),G1tensor(32),G0tensor(212),G0tensor(187),G0tensor(182),G0tensor(43)])
  call ol_merge_tensors(G2tensor(184),[G2tensor(324),G2tensor(300),G2tensor(108),G2tensor(92),G1tensor(217),G1tensor(197) &
    ,G1tensor(192),G1tensor(54),G0tensor(217),G0tensor(197),G0tensor(192),G0tensor(53)])
  call ol_merge_tensors(G2tensor(224),[G2tensor(467),G2tensor(579),G2tensor(576),G2tensor(525),G2tensor(522),G2tensor(333) &
    ,G2tensor(330),G2tensor(112),G1tensor(63),G1tensor(74),G1tensor(542),G1tensor(227),G1tensor(222),G0tensor(542),G0tensor(227) &
    ,G0tensor(222)])
  call ol_merge_tensors(G2tensor(99),[G2tensor(95),G2tensor(585),G2tensor(582),G2tensor(513),G2tensor(510),G2tensor(339) &
    ,G2tensor(336),G2tensor(116),G1tensor(12),G1tensor(2),G1tensor(547),G1tensor(538),G1tensor(237),G1tensor(232),G0tensor(547) &
    ,G0tensor(538),G0tensor(237),G0tensor(232)])
  call ol_merge_tensors(G2tensor(272),[G2tensor(485),G2tensor(549),G2tensor(546),G2tensor(354),G2tensor(348),G2tensor(345) &
    ,G2tensor(342),G2tensor(122),G2tensor(121),G2tensor(120),G1tensor(116),G1tensor(104),G1tensor(242),G1tensor(37),G1tensor(7) &
    ,G0tensor(242),G0tensor(7),G0tensor(2)])
  call ol_merge_tensors(G2tensor(317),[G2tensor(311),G2tensor(519),G2tensor(516),G2tensor(369),G2tensor(366),G2tensor(363) &
    ,G2tensor(360),G2tensor(128),G2tensor(127),G2tensor(126),G1tensor(60),G1tensor(50),G1tensor(553),G1tensor(247),G1tensor(97) &
    ,G1tensor(67),G0tensor(553),G0tensor(247),G0tensor(17),G0tensor(12)])
  call ol_merge_tensors(G2tensor(539),[G2tensor(309),G2tensor(307),G2tensor(1),G1tensor(472),G1tensor(205),G1tensor(163) &
    ,G0tensor(472),G0tensor(205),G0tensor(28)])
  call ol_merge_tensors(G2tensor(254),[G2tensor(397),G2tensor(7),G1tensor(280),G1tensor(169),G0tensor(280),G0tensor(29)])
  call ol_merge_tensors(G2tensor(565),[G2tensor(562),G2tensor(556),G2tensor(553),G2tensor(541),G2tensor(538),G2tensor(532) &
    ,G2tensor(529),G2tensor(238),G2tensor(190),G2tensor(85),G2tensor(4),G1tensor(285),G1tensor(87),G1tensor(118),G1tensor(23) &
    ,G1tensor(72),G1tensor(24),G1tensor(175),G0tensor(285),G0tensor(140),G0tensor(120),G0tensor(110),G0tensor(60),G0tensor(40) &
    ,G0tensor(30)])
  call ol_merge_tensors(G2tensor(269),[G2tensor(542),G2tensor(315),G2tensor(313),G2tensor(10),G1tensor(482),G1tensor(210) &
    ,G1tensor(18),G0tensor(482),G0tensor(210),G0tensor(38)])
  call ol_merge_tensors(G2tensor(275),[G2tensor(248),G2tensor(400),G2tensor(13),G1tensor(290),G1tensor(20),G0tensor(290) &
    ,G0tensor(39)])
  call ol_merge_tensors(G2tensor(281),[G2tensor(536),G2tensor(364),G2tensor(361),G2tensor(321),G2tensor(319),G2tensor(17) &
    ,G1tensor(492),G1tensor(250),G1tensor(215),G1tensor(44),G0tensor(492),G0tensor(250),G0tensor(215),G0tensor(48)])
  call ol_merge_tensors(G2tensor(251),[G2tensor(233),G2tensor(403),G2tensor(382),G2tensor(376),G2tensor(165),G2tensor(162) &
    ,G2tensor(21),G1tensor(295),G1tensor(260),G1tensor(96),G1tensor(49),G0tensor(295),G0tensor(260),G0tensor(49),G0tensor(9)])
  call ol_merge_tensors(G2tensor(568),[G2tensor(559),G2tensor(544),G2tensor(535),G2tensor(247),G2tensor(199),G2tensor(105) &
    ,G2tensor(25),G1tensor(300),G1tensor(52),G1tensor(48),G0tensor(300),G0tensor(130),G0tensor(50)])
  call ol_merge_tensors(G2tensor(257),[G2tensor(327),G2tensor(325),G2tensor(29),G1tensor(502),G1tensor(220),G1tensor(66) &
    ,G0tensor(502),G0tensor(220),G0tensor(58)])
  call ol_merge_tensors(G2tensor(263),[G2tensor(406),G2tensor(33),G1tensor(305),G1tensor(68),G0tensor(305),G0tensor(59)])
  call ol_merge_tensors(G2tensor(439),[G2tensor(409),G2tensor(117),G2tensor(37),G1tensor(380),G1tensor(310),G1tensor(69) &
    ,G0tensor(380),G0tensor(310),G0tensor(68)])
  call ol_merge_tensors(G2tensor(478),[G2tensor(460),G2tensor(442),G2tensor(412),G2tensor(148),G2tensor(138),G2tensor(123) &
    ,G2tensor(41),G1tensor(385),G1tensor(315),G1tensor(199),G1tensor(177),G1tensor(143),G1tensor(3),G1tensor(122),G1tensor(98) &
    ,G0tensor(385),G0tensor(315),G0tensor(199),G0tensor(179),G0tensor(169),G0tensor(99),G0tensor(79),G0tensor(69)])
  call ol_merge_tensors(G2tensor(407),[G2tensor(323),G2tensor(262),G2tensor(214),G2tensor(129),G2tensor(45),G1tensor(390) &
    ,G1tensor(320),G1tensor(75),G0tensor(390),G0tensor(320),G0tensor(70)])
  call ol_merge_tensors(G2tensor(445),[G2tensor(415),G2tensor(130),G2tensor(49),G1tensor(395),G1tensor(325),G1tensor(120) &
    ,G0tensor(395),G0tensor(325),G0tensor(78)])
  call ol_merge_tensors(G2tensor(218),[G2tensor(458),G2tensor(512),G2tensor(332),G2tensor(268),G2tensor(220),G2tensor(131) &
    ,G2tensor(53),G1tensor(400),G1tensor(330),G1tensor(150),G0tensor(400),G0tensor(330),G0tensor(80)])
  call ol_merge_tensors(G2tensor(448),[G2tensor(418),G2tensor(132),G2tensor(57),G1tensor(405),G1tensor(335),G1tensor(21) &
    ,G0tensor(405),G0tensor(335),G0tensor(88)])
  call ol_merge_tensors(G2tensor(487),[G2tensor(469),G2tensor(451),G2tensor(421),G2tensor(153),G2tensor(143),G2tensor(133) &
    ,G2tensor(61),G1tensor(410),G1tensor(340),G1tensor(189),G1tensor(146),G0tensor(410),G0tensor(340),G0tensor(189) &
    ,G0tensor(89)])
  call ol_merge_tensors(G2tensor(416),[G2tensor(212),G2tensor(344),G2tensor(524),G2tensor(526),G2tensor(523),G2tensor(514) &
    ,G2tensor(511),G2tensor(274),G2tensor(226),G2tensor(134),G2tensor(65),G1tensor(415),G1tensor(345),G1tensor(240),G1tensor(230) &
    ,G1tensor(27),G0tensor(415),G0tensor(345),G0tensor(240),G0tensor(230),G0tensor(90)])
  call ol_merge_tensors(G2tensor(454),[G2tensor(424),G2tensor(135),G2tensor(69),G1tensor(420),G1tensor(350),G1tensor(176) &
    ,G0tensor(420),G0tensor(350),G0tensor(98)])
  call ol_merge_tensors(G2tensor(413),[G2tensor(338),G2tensor(280),G2tensor(232),G2tensor(136),G2tensor(73),G1tensor(425) &
    ,G1tensor(355),G1tensor(4),G0tensor(425),G0tensor(355),G0tensor(100)])
  call ol_merge_tensors(G2tensor(566),[G2tensor(261),G2tensor(259),G2tensor(77),G1tensor(387),G1tensor(94),G1tensor(65) &
    ,G0tensor(387),G0tensor(145),G0tensor(108)])
  call ol_merge_tensors(G2tensor(200),[G2tensor(427),G2tensor(81),G1tensor(360),G1tensor(35),G0tensor(360),G0tensor(109)])
  call ol_merge_tensors(G2tensor(221),[G2tensor(560),G2tensor(267),G2tensor(265),G2tensor(89),G1tensor(397),G1tensor(99) &
    ,G1tensor(39),G0tensor(397),G0tensor(150),G0tensor(118)])
  call ol_merge_tensors(G2tensor(71),[G2tensor(209),G2tensor(430),G2tensor(93),G1tensor(365),G1tensor(130),G0tensor(365) &
    ,G0tensor(119)])
  call ol_merge_tensors(G2tensor(227),[G2tensor(63),G2tensor(340),G2tensor(337),G2tensor(273),G2tensor(271),G2tensor(97) &
    ,G1tensor(412),G1tensor(235),G1tensor(105),G1tensor(51),G0tensor(412),G0tensor(235),G0tensor(155),G0tensor(128)])
  call ol_merge_tensors(G2tensor(206),[G2tensor(203),G2tensor(433),G2tensor(101),G1tensor(370),G1tensor(229),G1tensor(124) &
    ,G0tensor(370),G0tensor(229),G0tensor(129)])
  call ol_merge_tensors(G2tensor(215),[G2tensor(279),G2tensor(277),G2tensor(109),G1tensor(422),G1tensor(119),G1tensor(76) &
    ,G0tensor(422),G0tensor(160),G0tensor(138)])
  call ol_merge_tensors(G2tensor(67),[G2tensor(436),G2tensor(113),G1tensor(375),G1tensor(82),G0tensor(375),G0tensor(139)])
  call ol_merge_tensors(G2tensor(475),[G2tensor(457),G2tensor(147),G2tensor(137),G1tensor(470),G1tensor(430),G1tensor(141) &
    ,G0tensor(470),G0tensor(430),G0tensor(168)])
  call ol_merge_tensors(G2tensor(437),[G2tensor(362),G2tensor(310),G2tensor(286),G2tensor(149),G2tensor(139),G1tensor(475) &
    ,G1tensor(435),G1tensor(147),G0tensor(475),G0tensor(435),G0tensor(170)])
  call ol_merge_tensors(G2tensor(481),[G2tensor(463),G2tensor(150),G2tensor(140),G1tensor(480),G1tensor(440),G1tensor(171) &
    ,G0tensor(480),G0tensor(440),G0tensor(178)])
  call ol_merge_tensors(G2tensor(266),[G2tensor(476),G2tensor(389),G2tensor(377),G2tensor(316),G2tensor(292),G2tensor(151) &
    ,G2tensor(141),G1tensor(485),G1tensor(445),G1tensor(178),G0tensor(485),G0tensor(445),G0tensor(180)])
  call ol_merge_tensors(G2tensor(484),[G2tensor(466),G2tensor(152),G2tensor(142),G1tensor(490),G1tensor(450),G1tensor(188) &
    ,G0tensor(490),G0tensor(450),G0tensor(188)])
  call ol_merge_tensors(G2tensor(446),[G2tensor(260),G2tensor(392),G2tensor(380),G2tensor(550),G2tensor(547),G2tensor(520) &
    ,G2tensor(517),G2tensor(358),G2tensor(352),G2tensor(322),G2tensor(298),G2tensor(166),G2tensor(163),G2tensor(154),G2tensor(144) &
    ,G1tensor(495),G1tensor(455),G1tensor(265),G1tensor(190),G1tensor(115),G1tensor(55),G0tensor(495),G0tensor(455),G0tensor(265) &
    ,G0tensor(190),G0tensor(20),G0tensor(10)])
  call ol_merge_tensors(G2tensor(490),[G2tensor(472),G2tensor(155),G2tensor(145),G1tensor(500),G1tensor(460),G1tensor(198) &
    ,G0tensor(500),G0tensor(460),G0tensor(198)])
  call ol_merge_tensors(G2tensor(443),[G2tensor(356),G2tensor(328),G2tensor(304),G2tensor(156),G2tensor(146),G1tensor(505) &
    ,G1tensor(465),G1tensor(200),G0tensor(505),G0tensor(465),G0tensor(200)])
  call ol_merge_tensors(G2tensor(563),[G2tensor(551),G2tensor(493),G2tensor(157),G1tensor(510),G1tensor(228),G0tensor(510) &
    ,G0tensor(228)])
  call ol_merge_tensors(G2tensor(179),[G2tensor(587),G2tensor(496),G2tensor(158),G1tensor(515),G1tensor(238),G0tensor(515) &
    ,G0tensor(238)])
  call ol_merge_tensors(G2tensor(353),[G2tensor(180),G2tensor(499),G2tensor(159),G1tensor(520),G1tensor(239),G0tensor(520) &
    ,G0tensor(239)])
  call ol_merge_tensors(G2tensor(527),[G2tensor(75),G2tensor(502),G2tensor(379),G2tensor(373),G2tensor(164),G2tensor(161) &
    ,G2tensor(160),G1tensor(525),G1tensor(255),G1tensor(43),G0tensor(525),G0tensor(255),G0tensor(8)])
  call ol_merge_tensors(G2tensor(518),[G2tensor(548),G2tensor(505),G2tensor(391),G2tensor(385),G2tensor(171),G2tensor(169) &
    ,G2tensor(167),G1tensor(530),G1tensor(270),G1tensor(103),G0tensor(530),G0tensor(270),G0tensor(18)])
  call ol_merge_tensors(G2tensor(185),[G2tensor(368),G2tensor(508),G2tensor(394),G2tensor(388),G2tensor(172),G2tensor(170) &
    ,G2tensor(168),G1tensor(535),G1tensor(275),G1tensor(109),G0tensor(535),G0tensor(275),G0tensor(19)])
  call ol_merge_tensors(G2tensor(253),[G2tensor(250),G2tensor(241),G2tensor(237),G2tensor(235),G2tensor(205),G2tensor(202) &
    ,G2tensor(193),G2tensor(189),G2tensor(187),G1tensor(282),G1tensor(64),G1tensor(77),G1tensor(16),G1tensor(108),G1tensor(180) &
    ,G1tensor(145),G0tensor(282),G0tensor(135),G0tensor(115),G0tensor(105),G0tensor(55),G0tensor(35),G0tensor(25)])
  call ol_merge_tensors(G2tensor(256),[G2tensor(246),G2tensor(244),G2tensor(208),G2tensor(198),G2tensor(196),G1tensor(297) &
    ,G1tensor(41),G1tensor(38),G0tensor(297),G0tensor(125),G0tensor(45)])
  call ol_merge_tensors(G2tensor(213),[G2tensor(211),G1tensor(317),G1tensor(86),G0tensor(317),G0tensor(65)])
  call ol_merge_tensors(G2tensor(219),[G2tensor(217),G1tensor(327),G1tensor(114),G0tensor(327),G0tensor(75)])
  call ol_merge_tensors(G2tensor(334),[G2tensor(331),G2tensor(225),G2tensor(223),G1tensor(342),G1tensor(225),G1tensor(134) &
    ,G0tensor(342),G0tensor(225),G0tensor(85)])
  call ol_merge_tensors(G2tensor(231),[G2tensor(229),G1tensor(352),G1tensor(164),G0tensor(352),G0tensor(95)])
  call ol_merge_tensors(G2tensor(285),[G2tensor(283),G1tensor(432),G1tensor(131),G0tensor(432),G0tensor(165)])
  call ol_merge_tensors(G2tensor(291),[G2tensor(289),G1tensor(442),G1tensor(159),G0tensor(442),G0tensor(175)])
  call ol_merge_tensors(G2tensor(346),[G2tensor(343),G2tensor(297),G2tensor(295),G1tensor(452),G1tensor(245),G1tensor(185) &
    ,G0tensor(452),G0tensor(245),G0tensor(185)])
  call ol_merge_tensors(G2tensor(303),[G2tensor(301),G1tensor(462),G1tensor(195),G0tensor(462),G0tensor(195)])
  call ol_merge_tensors(G2tensor(370),[G2tensor(367),G2tensor(357),G2tensor(355),G2tensor(351),G2tensor(349),G1tensor(91) &
    ,G1tensor(61),G1tensor(262),G1tensor(85),G1tensor(25),G0tensor(262),G0tensor(15),G0tensor(5)])
  call ol_merge_tensors(G3tensor(16),[G3tensor(15),G3tensor(8),G3tensor(7),G3tensor(2),G3tensor(1),G2tensor(278),G2tensor(452) &
    ,G2tensor(378),G2tensor(372),G1tensor(543),G1tensor(252),G1tensor(13),G0tensor(543),G0tensor(252),G0tensor(3)])
  call ol_merge_tensors(G2tensor(188),[G2tensor(350),G2tensor(381),G2tensor(375),G1tensor(151),G1tensor(121),G1tensor(554) &
    ,G1tensor(257),G1tensor(19),G0tensor(554),G0tensor(257),G0tensor(4)])
  call ol_merge_tensors(G2tensor(107),[G2tensor(103),G2tensor(575),G2tensor(174),G2tensor(390),G2tensor(384),G1tensor(548) &
    ,G1tensor(267),G1tensor(73),G0tensor(548),G0tensor(267),G0tensor(13)])
  call ol_merge_tensors(G2tensor(176),[G2tensor(173),G2tensor(393),G2tensor(387),G1tensor(272),G1tensor(79),G0tensor(272) &
    ,G0tensor(14)])
  call ol_merge_tensors(G2tensor(182),[G2tensor(396),G1tensor(277),G1tensor(139),G0tensor(277),G0tensor(24)])
  call ol_merge_tensors(G2tensor(8),[G2tensor(545),G2tensor(399),G1tensor(287),G1tensor(8),G0tensor(287),G0tensor(34)])
  call ol_merge_tensors(G2tensor(125),[G2tensor(6),G2tensor(402),G1tensor(292),G1tensor(244),G1tensor(36),G0tensor(292) &
    ,G0tensor(244),G0tensor(44)])
  call ol_merge_tensors(G2tensor(183),[G2tensor(405),G1tensor(302),G1tensor(56),G0tensor(302),G0tensor(54)])
  call ol_merge_tensors(G2tensor(12),[G2tensor(408),G1tensor(307),G1tensor(80),G0tensor(307),G0tensor(63)])
  call ol_merge_tensors(G2tensor(74),[G2tensor(9),G2tensor(459),G2tensor(411),G1tensor(312),G1tensor(194),G1tensor(155) &
    ,G1tensor(129),G1tensor(162),G1tensor(138),G1tensor(84),G0tensor(312),G0tensor(194),G0tensor(174),G0tensor(164),G0tensor(94) &
    ,G0tensor(74),G0tensor(64)])
  call ol_merge_tensors(G2tensor(191),[G2tensor(414),G1tensor(322),G1tensor(110),G0tensor(322),G0tensor(73)])
  call ol_merge_tensors(G2tensor(554),[G2tensor(417),G1tensor(518),G1tensor(513),G1tensor(332),G1tensor(156),G0tensor(518) &
    ,G0tensor(513),G0tensor(332),G0tensor(83)])
  call ol_merge_tensors(G2tensor(86),[G2tensor(19),G2tensor(468),G2tensor(420),G1tensor(337),G1tensor(184),G1tensor(132) &
    ,G0tensor(337),G0tensor(184),G0tensor(84)])
  call ol_merge_tensors(G2tensor(557),[G2tensor(423),G1tensor(347),G1tensor(158),G0tensor(347),G0tensor(93)])
  call ol_merge_tensors(G2tensor(27),[G2tensor(426),G1tensor(357),G1tensor(10),G0tensor(357),G0tensor(104)])
  call ol_merge_tensors(G2tensor(47),[G2tensor(34),G2tensor(429),G1tensor(362),G1tensor(28),G0tensor(362),G0tensor(114)])
  call ol_merge_tensors(G2tensor(50),[G2tensor(38),G2tensor(432),G1tensor(367),G1tensor(224),G1tensor(40),G0tensor(367) &
    ,G0tensor(224),G0tensor(124)])
  call ol_merge_tensors(G2tensor(43),[G2tensor(435),G1tensor(372),G1tensor(59),G0tensor(372),G0tensor(134)])
  call ol_merge_tensors(G2tensor(530),[G2tensor(438),G1tensor(377),G1tensor(358),G1tensor(136),G0tensor(377),G0tensor(358) &
    ,G0tensor(143)])
  call ol_merge_tensors(G2tensor(30),[G2tensor(181),G2tensor(477),G2tensor(441),G1tensor(382),G1tensor(283),G1tensor(219) &
    ,G1tensor(209),G1tensor(204),G1tensor(117),G1tensor(95),G1tensor(106),G0tensor(382),G0tensor(283),G0tensor(219),G0tensor(209) &
    ,G0tensor(204),G0tensor(159),G0tensor(149),G0tensor(144)])
  call ol_merge_tensors(G2tensor(54),[G2tensor(444),G1tensor(392),G1tensor(363),G1tensor(93),G0tensor(392),G0tensor(363) &
    ,G0tensor(148)])
  call ol_merge_tensors(G2tensor(55),[G2tensor(447),G1tensor(508),G1tensor(402),G1tensor(368),G1tensor(167),G0tensor(508) &
    ,G0tensor(402),G0tensor(368),G0tensor(153)])
  call ol_merge_tensors(G2tensor(39),[G2tensor(3),G2tensor(486),G2tensor(450),G1tensor(407),G1tensor(298),G1tensor(214) &
    ,G1tensor(101),G0tensor(407),G0tensor(298),G0tensor(214),G0tensor(154)])
  call ol_merge_tensors(G2tensor(62),[G2tensor(453),G1tensor(417),G1tensor(373),G1tensor(113),G0tensor(417),G0tensor(373) &
    ,G0tensor(158)])
  call ol_merge_tensors(G2tensor(70),[G2tensor(456),G1tensor(427),G1tensor(125),G0tensor(427),G0tensor(163)])
  call ol_merge_tensors(G2tensor(79),[G2tensor(462),G1tensor(437),G1tensor(153),G0tensor(437),G0tensor(173)])
  call ol_merge_tensors(G2tensor(83),[G2tensor(465),G1tensor(533),G1tensor(528),G1tensor(447),G1tensor(183),G0tensor(533) &
    ,G0tensor(528),G0tensor(447),G0tensor(183)])
  call ol_merge_tensors(G2tensor(90),[G2tensor(471),G1tensor(457),G1tensor(193),G0tensor(457),G0tensor(193)])
  call ol_merge_tensors(G2tensor(94),[G2tensor(474),G1tensor(467),G1tensor(278),G1tensor(203),G0tensor(467),G0tensor(278) &
    ,G0tensor(203)])
  call ol_merge_tensors(G2tensor(106),[G2tensor(480),G1tensor(477),G1tensor(288),G1tensor(208),G0tensor(477),G0tensor(288) &
    ,G0tensor(208)])
  call ol_merge_tensors(G2tensor(110),[G2tensor(483),G1tensor(523),G1tensor(487),G1tensor(293),G1tensor(213),G0tensor(523) &
    ,G0tensor(487),G0tensor(293),G0tensor(213)])
  call ol_merge_tensors(G2tensor(335),[G2tensor(489),G1tensor(497),G1tensor(303),G1tensor(218),G0tensor(497),G0tensor(303) &
    ,G0tensor(218)])
  call ol_merge_tensors(G2tensor(115),[G2tensor(509),G2tensor(492),G1tensor(507),G1tensor(223),G0tensor(507),G0tensor(223)])
  call ol_merge_tensors(G2tensor(359),[G2tensor(341),G2tensor(495),G1tensor(512),G1tensor(233),G0tensor(512),G0tensor(233)])
  call ol_merge_tensors(G2tensor(124),[G2tensor(118),G2tensor(498),G1tensor(517),G1tensor(234),G0tensor(517),G0tensor(234)])
  call ol_merge_tensors(G2tensor(374),[G2tensor(371),G2tensor(501),G1tensor(522),G1tensor(273),G1tensor(268),G1tensor(243) &
    ,G0tensor(522),G0tensor(273),G0tensor(268),G0tensor(243)])
  call ol_merge_tensors(G2tensor(449),[G2tensor(419),G2tensor(504),G1tensor(527),G1tensor(258),G1tensor(253),G1tensor(248) &
    ,G0tensor(527),G0tensor(258),G0tensor(253),G0tensor(248)])
  call ol_merge_tensors(G2tensor(569),[G2tensor(440),G2tensor(507),G1tensor(532),G1tensor(249),G0tensor(532),G0tensor(249)])
  call ol_merge_tensors(G2tensor(434),[G2tensor(425),G2tensor(574),G2tensor(571),G1tensor(540),G0tensor(540)])
  call ol_merge_tensors(G2tensor(586),[G2tensor(583),G2tensor(580),G2tensor(577),G1tensor(31),G1tensor(1),G1tensor(550) &
    ,G1tensor(545),G0tensor(550),G0tensor(545)])
  call ol_merge_tensors(G2tensor(404),[G2tensor(398),G2tensor(592),G2tensor(589),G1tensor(555),G0tensor(555)])
  call ol_merge_tensors(G2tensor(197),[G2tensor(383),G1tensor(269),G1tensor(263),G1tensor(254),G0tensor(269),G0tensor(263) &
    ,G0tensor(254)])
  call ol_merge_tensors(G2tensor(410),[G2tensor(386),G1tensor(274),G1tensor(264),G1tensor(259),G0tensor(274),G0tensor(264) &
    ,G0tensor(259)])
  call ol_merge_tensors(G2tensor(15),[G2tensor(5),G1tensor(464),G1tensor(444),G1tensor(434),G1tensor(374),G1tensor(364) &
    ,G1tensor(359),G1tensor(354),G1tensor(329),G1tensor(319),G1tensor(314),G1tensor(304),G1tensor(289),G1tensor(284),G1tensor(279) &
    ,G0tensor(464),G0tensor(444),G0tensor(434),G0tensor(374),G0tensor(364),G0tensor(359),G0tensor(354),G0tensor(329),G0tensor(319) &
    ,G0tensor(314),G0tensor(304),G0tensor(289),G0tensor(284),G0tensor(279)])
  call ol_merge_tensors(G2tensor(22),[G2tensor(365),G1tensor(454),G1tensor(369),G1tensor(344),G1tensor(339),G1tensor(299) &
    ,G1tensor(294),G0tensor(454),G0tensor(369),G0tensor(344),G0tensor(339),G0tensor(299),G0tensor(294)])
  call ol_merge_tensors(G3tensor(5),[G3tensor(3),G1tensor(458),G1tensor(438),G1tensor(428),G1tensor(348),G1tensor(323) &
    ,G1tensor(313),G1tensor(308),G0tensor(458),G0tensor(438),G0tensor(428),G0tensor(348),G0tensor(323),G0tensor(313) &
    ,G0tensor(308)])
  call ol_merge_tensors(G2tensor(14),[G1tensor(318),G1tensor(309),G0tensor(318),G0tensor(309)])
  call ol_merge_tensors(G2tensor(18),[G1tensor(328),G1tensor(324),G0tensor(328),G0tensor(324)])
  call ol_merge_tensors(G3tensor(6),[G3tensor(4),G1tensor(448),G1tensor(338),G1tensor(333),G0tensor(448),G0tensor(338) &
    ,G0tensor(333)])
  call ol_merge_tensors(G2tensor(194),[G1tensor(509),G1tensor(343),G1tensor(334),G0tensor(509),G0tensor(343),G0tensor(334)])
  call ol_merge_tensors(G2tensor(23),[G1tensor(353),G1tensor(349),G0tensor(353),G0tensor(349)])
  call ol_merge_tensors(G2tensor(178),[G2tensor(175),G1tensor(498),G1tensor(478),G1tensor(468),G1tensor(418),G1tensor(393) &
    ,G1tensor(383),G1tensor(378),G0tensor(498),G0tensor(478),G0tensor(468),G0tensor(418),G0tensor(393),G0tensor(383) &
    ,G0tensor(378)])
  call ol_merge_tensors(G2tensor(51),[G1tensor(388),G1tensor(379),G0tensor(388),G0tensor(379)])
  call ol_merge_tensors(G2tensor(102),[G2tensor(242),G1tensor(504),G1tensor(484),G1tensor(474),G1tensor(424),G1tensor(399) &
    ,G1tensor(389),G1tensor(384),G0tensor(504),G0tensor(484),G0tensor(474),G0tensor(424),G0tensor(399),G0tensor(389) &
    ,G0tensor(384)])
  call ol_merge_tensors(G2tensor(533),[G1tensor(398),G1tensor(394),G0tensor(398),G0tensor(394)])
  call ol_merge_tensors(G2tensor(177),[G2tensor(581),G1tensor(488),G1tensor(408),G1tensor(403),G0tensor(488),G0tensor(408) &
    ,G0tensor(403)])
  call ol_merge_tensors(G2tensor(58),[G1tensor(514),G1tensor(413),G1tensor(404),G0tensor(514),G0tensor(413),G0tensor(404)])
  call ol_merge_tensors(G2tensor(111),[G2tensor(59),G1tensor(534),G1tensor(519),G1tensor(494),G1tensor(414),G1tensor(409) &
    ,G0tensor(534),G0tensor(519),G0tensor(494),G0tensor(414),G0tensor(409)])
  call ol_merge_tensors(G2tensor(66),[G1tensor(423),G1tensor(419),G0tensor(423),G0tensor(419)])
  call ol_merge_tensors(G2tensor(78),[G1tensor(433),G1tensor(429),G0tensor(433),G0tensor(429)])
  call ol_merge_tensors(G2tensor(82),[G1tensor(443),G1tensor(439),G0tensor(443),G0tensor(439)])
  call ol_merge_tensors(G2tensor(87),[G1tensor(524),G1tensor(453),G1tensor(449),G0tensor(524),G0tensor(453),G0tensor(449)])
  call ol_merge_tensors(G2tensor(91),[G1tensor(463),G1tensor(459),G0tensor(463),G0tensor(459)])
  call ol_merge_tensors(G2tensor(98),[G1tensor(473),G1tensor(469),G0tensor(473),G0tensor(469)])
  call ol_merge_tensors(G2tensor(329),[G1tensor(483),G1tensor(479),G0tensor(483),G0tensor(479)])
  call ol_merge_tensors(G2tensor(521),[G1tensor(529),G1tensor(493),G1tensor(489),G0tensor(529),G0tensor(493),G0tensor(489)])
  call ol_merge_tensors(G2tensor(114),[G1tensor(503),G1tensor(499),G0tensor(503),G0tensor(499)])
  call ol_merge_tensors(G2tensor(293),[G2tensor(287),G1tensor(90),G1tensor(26),G1tensor(544),G1tensor(539),G0tensor(544) &
    ,G0tensor(539)])
  call ol_merge_tensors(G2tensor(305),[G2tensor(299),G1tensor(549),G0tensor(549)])
  call ol_merge_tensors(G2tensor(245),[G2tensor(236)])
  call ol_merge_tensors(G2tensor(431),[G2tensor(230)])
  call ol_merge_tensors(G3tensor(12),[G3tensor(9)])
  call ol_merge_tensors(G3tensor(13),[G3tensor(10)])
  call ol_merge_tensors(G3tensor(14),[G3tensor(11)])
  call ol_merge_tensors(G3tensor(18),[G3tensor(17)])
  call TI_triangle_red(G2tensor(552),RedBasis(64),mass3set(:,1),G0tensor(1),G0tensor(6),G0tensor(11), &
    G0tensor(16),M2L1R1,[nMH,nMT],G0tensor(21),G0tensor(26))
  call TI_triangle_red(G2tensor(564),RedBasis(64),mass3set(:,2),G0tensor(31),G0tensor(36),G0tensor(41), &
    G0tensor(46),M2L1R1,[nMZ,nMT],G0tensor(51),G0tensor(56))
  call TI_triangle_red(G2tensor(591),RedBasis(64),mass3set(:,3),G0tensor(61),G0tensor(66),G0tensor(71), &
    G0tensor(76),M2L1R1,[nMW,nMB],G0tensor(81),G0tensor(86))
  call TI_triangle_red(G2tensor(561),RedBasis(64),mass3set(:,4),G0tensor(91),G0tensor(96),G0tensor(101), &
    G0tensor(106),M2L1R1,[nMT],G0tensor(111))
  call TI_triangle_red(G2tensor(26),RedBasis(62),mass3set(:,5),G0tensor(116),G0tensor(121),G0tensor(126), &
    G0tensor(131),M2L1R1,[nMT,nMH],G0tensor(136),G0tensor(141))
  call TI_triangle_red(G2tensor(46),RedBasis(62),mass3set(:,6),G0tensor(146),G0tensor(151),G0tensor(156), &
    G0tensor(161),M2L1R1,[nMT,nMZ],G0tensor(166),G0tensor(171))
  call TI_triangle_red(G2tensor(239),RedBasis(62),mass3set(:,7),G0tensor(176),G0tensor(181),G0tensor(186), &
    G0tensor(191),M2L1R1,[nMB,nMW],G0tensor(196),G0tensor(201))
  call TI_triangle_red(G2tensor(42),RedBasis(62),mass3set(:,8),G0tensor(206),G0tensor(211),G0tensor(216), &
    G0tensor(221),M2L1R1,[nMT],G0tensor(226))
  call TI_triangle_red(G2tensor(528),RedBasis(33),mass3set(:,1),G0tensor(231),G0tensor(236),G0tensor(241), &
    G0tensor(246),M2L1R1,[nMH,nMT],G0tensor(251),G0tensor(256))
  call TI_triangle_red(G2tensor(540),RedBasis(33),mass3set(:,2),G0tensor(261),G0tensor(266),G0tensor(271), &
    G0tensor(276),M2L1R1,[nMZ,nMT],G0tensor(281),G0tensor(286))
  call TI_triangle_red(G2tensor(573),RedBasis(33),mass3set(:,3),G0tensor(291),G0tensor(296),G0tensor(301), &
    G0tensor(306),M2L1R1,[nMW,nMB],G0tensor(311),G0tensor(316))
  call TI_triangle_red(G2tensor(537),RedBasis(33),mass3set(:,4),G0tensor(321),G0tensor(326),G0tensor(331), &
    G0tensor(336),M2L1R1,[nMT],G0tensor(341))
  call TI_triangle_red(G2tensor(347),RedBasis(58),mass3set(:,5),G0tensor(346),G0tensor(351),G0tensor(356), &
    G0tensor(361),M2L1R1,[nMT,nMH],G0tensor(366),G0tensor(371))
  call TI_triangle_red(G2tensor(11),RedBasis(58),mass3set(:,6),G0tensor(376),G0tensor(381),G0tensor(386), &
    G0tensor(391),M2L1R1,[nMT,nMZ],G0tensor(396),G0tensor(401))
  call TI_triangle_red(G2tensor(515),RedBasis(58),mass3set(:,7),G0tensor(406),G0tensor(411),G0tensor(416), &
    G0tensor(421),M2L1R1,[nMB,nMW],G0tensor(426),G0tensor(431))
  call TI_triangle_red(G2tensor(184),RedBasis(58),mass3set(:,8),G0tensor(436),G0tensor(441),G0tensor(446), &
    G0tensor(451),M2L1R1,[nMT],G0tensor(456))
  call TI_triangle_red(G2tensor(224),RedBasis(32),mass3set(:,9),G0tensor(461),G0tensor(466),G0tensor(471), &
    G0tensor(476),M2L1R1,[nMW,nMB],G0tensor(481),G0tensor(486))
  call TI_triangle_red(G2tensor(99),RedBasis(6),mass3set(:,9),G0tensor(491),G0tensor(496),G0tensor(501), &
    G0tensor(506),M2L1R1,[nMW,nMB],G0tensor(511),G0tensor(516))
  call TI_triangle_red(G2tensor(272),RedBasis(25),mass3set(:,9),G0tensor(521),G0tensor(526),G0tensor(531), &
    G0tensor(536),M2L1R1,[nMW,nMB],G0tensor(541),G0tensor(546))
  call TI_triangle_red(G2tensor(317),RedBasis(14),mass3set(:,9),G0tensor(551),G0tensor(27),G0tensor(22), &
    G0tensor(37),M2L1R1,[nMW,nMB],G0tensor(32),G0tensor(552))
  call TI_triangle_red(G2tensor(539),RedBasis(4),mass3set(:,5),G0tensor(47),G0tensor(42),G0tensor(57), &
    G0tensor(52),M2L1R1,[nMT,nMH],G0tensor(142),G0tensor(103))
  call TI_triangle_red(G2tensor(254),RedBasis(2),mass3set(:,5),G0tensor(67),G0tensor(62),G0tensor(147), &
    G0tensor(113),M2L1R1,[nMT,nMH],G0tensor(77),G0tensor(72))
  call TI_triangle_red(G2tensor(565),RedBasis(1),mass3set(:,10),G0tensor(152),G0tensor(123),G0tensor(87), &
    G0tensor(82),M2L1R1,[nMT],G0tensor(157))
  call TI_triangle_red(G2tensor(269),RedBasis(4),mass3set(:,6),G0tensor(133),G0tensor(97),G0tensor(92), &
    G0tensor(107),M2L1R1,[nMT,nMZ],G0tensor(102),G0tensor(117))
  call TI_triangle_red(G2tensor(275),RedBasis(2),mass3set(:,6),G0tensor(112),G0tensor(537),G0tensor(127), &
    G0tensor(122),M2L1R1,[nMT,nMZ],G0tensor(137),G0tensor(132))
  call TI_triangle_red(G2tensor(281),RedBasis(4),mass3set(:,7),G0tensor(202),G0tensor(167),G0tensor(162), &
    G0tensor(23),M2L1R1,[nMB,nMW],G0tensor(207),G0tensor(177))
  call TI_triangle_red(G2tensor(251),RedBasis(2),mass3set(:,7),G0tensor(172),G0tensor(33),G0tensor(212), &
    G0tensor(187),M2L1R1,[nMB,nMW],G0tensor(182),G0tensor(43))
  call TI_triangle_red(G2tensor(568),RedBasis(1),mass3set(:,11),G0tensor(217),G0tensor(197),G0tensor(192), &
    G0tensor(53),M2L1R1,[nMB],G0tensor(542))
  call TI_triangle_red(G2tensor(257),RedBasis(4),mass3set(:,8),G0tensor(227),G0tensor(222),G0tensor(547), &
    G0tensor(538),M2L1R1,[nMT],G0tensor(237))
  call TI_triangle_red(G2tensor(263),RedBasis(2),mass3set(:,8),G0tensor(232),G0tensor(242),G0tensor(7),G0tensor(2),M2L1R1,[nMT], &
    G0tensor(553))
  call TI_triangle_red(G2tensor(439),RedBasis(9),mass3set(:,12),G0tensor(247),G0tensor(17),G0tensor(12), &
    G0tensor(472),M2L1R1,[nMT,nMH],G0tensor(205),G0tensor(28))
  call TI_triangle_red(G2tensor(478),RedBasis(8),mass3set(:,10),G0tensor(280),G0tensor(29),G0tensor(285), &
    G0tensor(140),M2L1R1,[nMT],G0tensor(120))
  call TI_triangle_red(G2tensor(407),RedBasis(7),mass3set(:,5),G0tensor(110),G0tensor(60),G0tensor(40), &
    G0tensor(30),M2L1R1,[nMT,nMH],G0tensor(482),G0tensor(210))
  call TI_triangle_red(G2tensor(445),RedBasis(9),mass3set(:,13),G0tensor(38),G0tensor(290),G0tensor(39), &
    G0tensor(492),M2L1R1,[nMT,nMZ],G0tensor(250),G0tensor(215))
  call TI_triangle_red(G2tensor(218),RedBasis(7),mass3set(:,6),G0tensor(48),G0tensor(295),G0tensor(260), &
    G0tensor(49),M2L1R1,[nMT,nMZ],G0tensor(9),G0tensor(300))
  call TI_triangle_red(G2tensor(448),RedBasis(9),mass3set(:,14),G0tensor(130),G0tensor(50),G0tensor(502), &
    G0tensor(220),M2L1R1,[nMB,nMW],G0tensor(58),G0tensor(305))
  call TI_triangle_red(G2tensor(487),RedBasis(8),mass3set(:,11),G0tensor(59),G0tensor(380),G0tensor(310), &
    G0tensor(68),M2L1R1,[nMB],G0tensor(385))
  call TI_triangle_red(G2tensor(416),RedBasis(7),mass3set(:,7),G0tensor(315),G0tensor(199),G0tensor(179), &
    G0tensor(169),M2L1R1,[nMB,nMW],G0tensor(99),G0tensor(79))
  call TI_triangle_red(G2tensor(454),RedBasis(9),mass3set(:,15),G0tensor(69),G0tensor(390),G0tensor(320), &
    G0tensor(70),M2L1R1,[nMT],G0tensor(395))
  call TI_triangle_red(G2tensor(413),RedBasis(7),mass3set(:,8),G0tensor(325),G0tensor(78),G0tensor(400), &
    G0tensor(330),M2L1R1,[nMT],G0tensor(80))
  call TI_triangle_red(G2tensor(566),RedBasis(13),mass3set(:,5),G0tensor(405),G0tensor(335),G0tensor(88), &
    G0tensor(410),M2L1R1,[nMT,nMH],G0tensor(340),G0tensor(189))
  call TI_triangle_red(G2tensor(200),RedBasis(12),mass3set(:,5),G0tensor(89),G0tensor(415),G0tensor(345), &
    G0tensor(240),M2L1R1,[nMT,nMH],G0tensor(230),G0tensor(90))
  call TI_triangle_red(G2tensor(221),RedBasis(13),mass3set(:,6),G0tensor(420),G0tensor(350),G0tensor(98), &
    G0tensor(425),M2L1R1,[nMT,nMZ],G0tensor(355),G0tensor(100))
  call TI_triangle_red(G2tensor(71),RedBasis(12),mass3set(:,6),G0tensor(387),G0tensor(145),G0tensor(108), &
    G0tensor(360),M2L1R1,[nMT,nMZ],G0tensor(109),G0tensor(397))
  call TI_triangle_red(G2tensor(227),RedBasis(13),mass3set(:,7),G0tensor(150),G0tensor(118),G0tensor(365), &
    G0tensor(119),M2L1R1,[nMB,nMW],G0tensor(412),G0tensor(235))
  call TI_triangle_red(G2tensor(206),RedBasis(12),mass3set(:,7),G0tensor(155),G0tensor(128),G0tensor(370), &
    G0tensor(229),M2L1R1,[nMB,nMW],G0tensor(129),G0tensor(422))
  call TI_triangle_red(G2tensor(215),RedBasis(13),mass3set(:,8),G0tensor(160),G0tensor(138),G0tensor(375), &
    G0tensor(139),M2L1R1,[nMT],G0tensor(470))
  call TI_triangle_red(G2tensor(67),RedBasis(12),mass3set(:,8),G0tensor(430),G0tensor(168),G0tensor(475), &
    G0tensor(435),M2L1R1,[nMT],G0tensor(170))
  call TI_triangle_red(G2tensor(475),RedBasis(19),mass3set(:,12),G0tensor(480),G0tensor(440),G0tensor(178), &
    G0tensor(485),M2L1R1,[nMT,nMH],G0tensor(445),G0tensor(180))
  call TI_triangle_red(G2tensor(437),RedBasis(18),mass3set(:,5),G0tensor(490),G0tensor(450),G0tensor(188), &
    G0tensor(495),M2L1R1,[nMT,nMH],G0tensor(455),G0tensor(265))
  call TI_triangle_red(G2tensor(481),RedBasis(19),mass3set(:,13),G0tensor(190),G0tensor(20),G0tensor(10), &
    G0tensor(500),M2L1R1,[nMT,nMZ],G0tensor(460),G0tensor(198))
  call TI_triangle_red(G2tensor(266),RedBasis(18),mass3set(:,6),G0tensor(505),G0tensor(465),G0tensor(200), &
    G0tensor(510),M2L1R1,[nMT,nMZ],G0tensor(228),G0tensor(515))
  call TI_triangle_red(G2tensor(484),RedBasis(19),mass3set(:,14),G0tensor(238),G0tensor(520),G0tensor(239), &
    G0tensor(525),M2L1R1,[nMB,nMW],G0tensor(255),G0tensor(8))
  call TI_triangle_red(G2tensor(446),RedBasis(18),mass3set(:,7),G0tensor(530),G0tensor(270),G0tensor(18), &
    G0tensor(535),M2L1R1,[nMB,nMW],G0tensor(275),G0tensor(19))
  call TI_triangle_red(G2tensor(490),RedBasis(19),mass3set(:,15),G0tensor(282),G0tensor(135),G0tensor(115), &
    G0tensor(105),M2L1R1,[nMT],G0tensor(55))
  call TI_triangle_red(G2tensor(443),RedBasis(18),mass3set(:,8),G0tensor(35),G0tensor(25),G0tensor(297), &
    G0tensor(125),M2L1R1,[nMT],G0tensor(45))
  call TI_triangle_red(G2tensor(563),RedBasis(22),mass3set(:,16),G0tensor(317),G0tensor(65),G0tensor(327), &
    G0tensor(75),M2L1R1,[nMB,nMW],G0tensor(342),G0tensor(225))
  call TI_triangle_red(G2tensor(179),RedBasis(24),mass3set(:,16),G0tensor(85),G0tensor(352),G0tensor(95), &
    G0tensor(432),M2L1R1,[nMB,nMW],G0tensor(165),G0tensor(442))
  call TI_triangle_red(G2tensor(353),RedBasis(23),mass3set(:,7),G0tensor(175),G0tensor(452),G0tensor(245), &
    G0tensor(185),M2L1R1,[nMB,nMW],G0tensor(462),G0tensor(195))
  call TI_triangle_red(G2tensor(527),RedBasis(26),mass3set(:,16),G0tensor(262),G0tensor(15),G0tensor(5), &
    G0tensor(543),M2L1R1,[nMB,nMW],G0tensor(252),G0tensor(3))
  call TI_triangle_red(G2tensor(518),RedBasis(31),mass3set(:,16),G0tensor(554),G0tensor(257),G0tensor(4), &
    G0tensor(548),M2L1R1,[nMB,nMW],G0tensor(267),G0tensor(13))
  call TI_triangle_red(G2tensor(185),RedBasis(30),mass3set(:,7),G0tensor(272),G0tensor(14),G0tensor(277), &
    G0tensor(24),M2L1R1,[nMB,nMW],G0tensor(287),G0tensor(34))
  call TI_triangle_red(G2tensor(253),RedBasis(56),mass3set(:,10),G0tensor(292),G0tensor(244),G0tensor(44), &
    G0tensor(302),M2L1R1,[nMT],G0tensor(54))
  call TI_triangle_red(G2tensor(256),RedBasis(56),mass3set(:,11),G0tensor(307),G0tensor(63),G0tensor(312), &
    G0tensor(194),M2L1R1,[nMB],G0tensor(174))
  call TI_triangle_red(G2tensor(213),RedBasis(59),mass3set(:,5),G0tensor(164),G0tensor(94),G0tensor(74), &
    G0tensor(64),M2L1R1,[nMT,nMH],G0tensor(322),G0tensor(73))
  call TI_triangle_red(G2tensor(219),RedBasis(59),mass3set(:,6),G0tensor(518),G0tensor(513),G0tensor(332), &
    G0tensor(83),M2L1R1,[nMT,nMZ],G0tensor(337),G0tensor(184))
  call TI_triangle_red(G2tensor(334),RedBasis(59),mass3set(:,7),G0tensor(84),G0tensor(347),G0tensor(93), &
    G0tensor(357),M2L1R1,[nMB,nMW],G0tensor(104),G0tensor(362))
  call TI_triangle_red(G2tensor(231),RedBasis(59),mass3set(:,8),G0tensor(114),G0tensor(367),G0tensor(224), &
    G0tensor(124),M2L1R1,[nMT],G0tensor(372))
  call TI_triangle_red(G2tensor(285),RedBasis(63),mass3set(:,5),G0tensor(134),G0tensor(377),G0tensor(358), &
    G0tensor(143),M2L1R1,[nMT,nMH],G0tensor(382),G0tensor(283))
  call TI_triangle_red(G2tensor(291),RedBasis(63),mass3set(:,6),G0tensor(219),G0tensor(209),G0tensor(204), &
    G0tensor(159),M2L1R1,[nMT,nMZ],G0tensor(149),G0tensor(144))
  call TI_triangle_red(G2tensor(346),RedBasis(63),mass3set(:,7),G0tensor(392),G0tensor(363),G0tensor(148), &
    G0tensor(508),M2L1R1,[nMB,nMW],G0tensor(402),G0tensor(368))
  call TI_triangle_red(G2tensor(303),RedBasis(63),mass3set(:,8),G0tensor(153),G0tensor(407),G0tensor(298), &
    G0tensor(214),M2L1R1,[nMT],G0tensor(154))
  call TI_triangle_red(G2tensor(370),RedBasis(9),mass3set(:,9),G0tensor(417),G0tensor(373),G0tensor(158), &
    G0tensor(427),M2L1R1,[nMW,nMB],G0tensor(163),G0tensor(437))
  call TI_triangle_red(G3tensor(16),RedBasis(11),mass3set(:,17),G0tensor(173),G0tensor(533),G0tensor(528), &
    G0tensor(447),M2L1R1,[nMW],G0tensor(183))
  call TI_triangle_red(G2tensor(188),RedBasis(10),mass3set(:,9),G0tensor(457),G0tensor(193),G0tensor(467), &
    G0tensor(278),M2L1R1,[nMW,nMB],G0tensor(203),G0tensor(477))
  call TI_triangle_red(G2tensor(107),RedBasis(17),mass3set(:,17),G0tensor(288),G0tensor(208),G0tensor(523), &
    G0tensor(487),M2L1R1,[nMW],G0tensor(293))
  call TI_triangle_red(G2tensor(176),RedBasis(16),mass3set(:,9),G0tensor(213),G0tensor(497),G0tensor(303), &
    G0tensor(218),M2L1R1,[nMW,nMB],G0tensor(507),G0tensor(223))
  call TI_triangle_red(G2tensor(182),RedBasis(57),mass3set(:,5),G0tensor(512),G0tensor(233),G0tensor(517), &
    G0tensor(234),M2L1R1,[nMT,nMH],G0tensor(522),G0tensor(273))
  call TI_triangle_red(G2tensor(8),RedBasis(57),mass3set(:,6),G0tensor(268),G0tensor(243),G0tensor(527), &
    G0tensor(258),M2L1R1,[nMT,nMZ],G0tensor(253),G0tensor(248))
  call TI_triangle_red(G2tensor(125),RedBasis(57),mass3set(:,7),G0tensor(532),G0tensor(249),G0tensor(540), &
    G0tensor(550),M2L1R1,[nMB,nMW],G0tensor(545),G0tensor(555))
  call TI_triangle_red(G2tensor(183),RedBasis(57),mass3set(:,8),G0tensor(269),G0tensor(263),G0tensor(254), &
    G0tensor(274),M2L1R1,[nMT],G0tensor(264))
  call TI_triangle_red(G2tensor(12),RedBasis(25),mass3set(:,12),G0tensor(259),G0tensor(464),G0tensor(444), &
    G0tensor(434),M2L1R1,[nMT,nMH],G0tensor(374),G0tensor(364))
  call TI_triangle_red(G2tensor(74),RedBasis(60),mass3set(:,10),G0tensor(359),G0tensor(354),G0tensor(329), &
    G0tensor(319),M2L1R1,[nMT],G0tensor(314))
  call TI_triangle_red(G2tensor(191),RedBasis(25),mass3set(:,13),G0tensor(304),G0tensor(289),G0tensor(284), &
    G0tensor(279),M2L1R1,[nMT,nMZ],G0tensor(454),G0tensor(369))
  call TI_triangle_red(G2tensor(554),RedBasis(25),mass3set(:,14),G0tensor(344),G0tensor(339),G0tensor(299), &
    G0tensor(294),M2L1R1,[nMB,nMW],G0tensor(458),G0tensor(438))
  call TI_triangle_red(G2tensor(86),RedBasis(60),mass3set(:,11),G0tensor(428),G0tensor(348),G0tensor(323), &
    G0tensor(313),M2L1R1,[nMB],G0tensor(308))
  call TI_triangle_red(G2tensor(557),RedBasis(25),mass3set(:,15),G0tensor(318),G0tensor(309),G0tensor(328), &
    G0tensor(324),M2L1R1,[nMT],G0tensor(448))
  call TI_triangle_red(G2tensor(27),RedBasis(61),mass3set(:,5),G0tensor(338),G0tensor(333),G0tensor(509), &
    G0tensor(343),M2L1R1,[nMT,nMH],G0tensor(334),G0tensor(353))
  call TI_triangle_red(G2tensor(47),RedBasis(61),mass3set(:,6),G0tensor(349),G0tensor(498),G0tensor(478), &
    G0tensor(468),M2L1R1,[nMT,nMZ],G0tensor(418),G0tensor(393))
  call TI_triangle_red(G2tensor(50),RedBasis(61),mass3set(:,7),G0tensor(383),G0tensor(378),G0tensor(388), &
    G0tensor(379),M2L1R1,[nMB,nMW],G0tensor(504),G0tensor(484))
  call TI_triangle_red(G2tensor(43),RedBasis(61),mass3set(:,8),G0tensor(474),G0tensor(424),G0tensor(399), &
    G0tensor(389),M2L1R1,[nMT],G0tensor(384))
  call TI_triangle_red(G2tensor(530),RedBasis(14),mass3set(:,12),G0tensor(398),G0tensor(394),G0tensor(488), &
    G0tensor(408),M2L1R1,[nMT,nMH],G0tensor(403),G0tensor(514))
  call TI_triangle_red(G2tensor(30),RedBasis(5),mass3set(:,10),G0tensor(413),G0tensor(404),G0tensor(534), &
    G0tensor(519),M2L1R1,[nMT],G0tensor(494))
  call TI_triangle_red(G2tensor(54),RedBasis(14),mass3set(:,13),G0tensor(414),G0tensor(409),G0tensor(423), &
    G0tensor(419),M2L1R1,[nMT,nMZ],G0tensor(433),G0tensor(429))
  call TI_triangle_red(G2tensor(55),RedBasis(14),mass3set(:,14),G0tensor(443),G0tensor(439),G0tensor(524), &
    G0tensor(453),M2L1R1,[nMB,nMW],G0tensor(449),G0tensor(463))
  call TI_triangle_red(G2tensor(39),RedBasis(5),mass3set(:,11),G0tensor(459),G0tensor(473),G0tensor(469), &
    G0tensor(483),M2L1R1,[nMB],G0tensor(479))
  call TI_triangle_red(G2tensor(62),RedBasis(14),mass3set(:,15),G0tensor(529),G0tensor(493),G0tensor(489), &
    G0tensor(503),M2L1R1,[nMT],G0tensor(499))
  call TI_triangle_red(G2tensor(70),RedBasis(32),mass3set(:,12),G0tensor(544),G0tensor(539),G0tensor(549), &
    G0tensor(556),M2L1R1,[nMT,nMH],G0tensor(557),G0tensor(558))
  call TI_triangle_red(G2tensor(79),RedBasis(32),mass3set(:,13),G0tensor(559),G0tensor(560),G0tensor(561), &
    G0tensor(562),M2L1R1,[nMT,nMZ],G0tensor(563),G0tensor(564))
  call TI_triangle_red(G2tensor(83),RedBasis(32),mass3set(:,14),G0tensor(565),G0tensor(566),G0tensor(567), &
    G0tensor(568),M2L1R1,[nMB,nMW],G0tensor(569),G0tensor(570))
  call TI_triangle_red(G2tensor(90),RedBasis(32),mass3set(:,15),G0tensor(571),G0tensor(572),G0tensor(573), &
    G0tensor(574),M2L1R1,[nMT],G0tensor(575))
  call TI_triangle_red(G2tensor(94),RedBasis(6),mass3set(:,12),G0tensor(576),G0tensor(577),G0tensor(578), &
    G0tensor(579),M2L1R1,[nMT,nMH],G0tensor(580),G0tensor(581))
  call TI_triangle_red(G2tensor(106),RedBasis(6),mass3set(:,13),G0tensor(582),G0tensor(583),G0tensor(584), &
    G0tensor(585),M2L1R1,[nMT,nMZ],G0tensor(586),G0tensor(587))
  call TI_triangle_red(G2tensor(110),RedBasis(6),mass3set(:,14),G0tensor(588),G0tensor(589),G0tensor(590), &
    G0tensor(591),M2L1R1,[nMB,nMW],G0tensor(592),G0tensor(593))
  call TI_triangle_red(G2tensor(335),RedBasis(6),mass3set(:,15),G0tensor(594),G0tensor(595),G0tensor(596), &
    G0tensor(597),M2L1R1,[nMT],G0tensor(598))
  call TI_triangle_red(G2tensor(115),RedBasis(64),mass3set(:,16),G0tensor(599),G0tensor(600),G0tensor(601), &
    G0tensor(602),M2L1R1,[nMB,nMW],G0tensor(603),G0tensor(604))
  call TI_triangle_red(G2tensor(359),RedBasis(66),mass3set(:,16),G0tensor(605),G0tensor(606),G0tensor(607), &
    G0tensor(608),M2L1R1,[nMB,nMW],G0tensor(609),G0tensor(610))
  call TI_triangle_red(G2tensor(124),RedBasis(65),mass3set(:,7),G0tensor(611),G0tensor(612),G0tensor(613), &
    G0tensor(614),M2L1R1,[nMB,nMW],G0tensor(615),G0tensor(616))
  call TI_triangle_red(G2tensor(374),RedBasis(33),mass3set(:,16),G0tensor(617),G0tensor(618),G0tensor(619), &
    G0tensor(620),M2L1R1,[nMB,nMW],G0tensor(621),G0tensor(622))
  call TI_triangle_red(G2tensor(449),RedBasis(29),mass3set(:,16),G0tensor(623),G0tensor(624),G0tensor(625), &
    G0tensor(626),M2L1R1,[nMB,nMW],G0tensor(627),G0tensor(628))
  call TI_triangle_red(G2tensor(569),RedBasis(67),mass3set(:,7),G0tensor(629),G0tensor(630),G0tensor(631), &
    G0tensor(632),M2L1R1,[nMB,nMW],G0tensor(633),G0tensor(634))
  call TI_triangle_red(G2tensor(434),RedBasis(26),mass3set(:,3),G0tensor(635),G0tensor(636),G0tensor(637), &
    G0tensor(638),M2L1R1,[nMW,nMB],G0tensor(639),G0tensor(640))
  call TI_triangle_red(G2tensor(586),RedBasis(19),mass3set(:,9),G0tensor(641),G0tensor(642),G0tensor(643), &
    G0tensor(644),M2L1R1,[nMW,nMB],G0tensor(645),G0tensor(646))
  call TI_triangle_red(G2tensor(404),RedBasis(22),mass3set(:,3),G0tensor(647),G0tensor(648),G0tensor(649), &
    G0tensor(650),M2L1R1,[nMW,nMB],G0tensor(651),G0tensor(652))
  call TI_triangle_red(G2tensor(197),RedBasis(28),mass3set(:,16),G0tensor(653),G0tensor(654),G0tensor(655), &
    G0tensor(656),M2L1R1,[nMB,nMW],G0tensor(657),G0tensor(658))
  call TI_triangle_red(G2tensor(410),RedBasis(27),mass3set(:,7),G0tensor(659),G0tensor(660),G0tensor(661), &
    G0tensor(662),M2L1R1,[nMB,nMW],G0tensor(663),G0tensor(664))
  call TI_triangle_red(G2tensor(15),RedBasis(3),mass3set(:,10),G0tensor(665),G0tensor(666),G0tensor(667), &
    G0tensor(668),M2L1R1,[nMT],G0tensor(669))
  call TI_triangle_red(G2tensor(22),RedBasis(3),mass3set(:,11),G0tensor(670),G0tensor(671),G0tensor(672), &
    G0tensor(673),M2L1R1,[nMB],G0tensor(674))
  call TI_triangle_red(G3tensor(5),RedBasis(11),mass3set(:,10),G0tensor(675),G0tensor(676),G0tensor(677), &
    G0tensor(678),M2L1R1,[nMT],G0tensor(679))
  call TI_triangle_red(G2tensor(14),RedBasis(10),mass3set(:,12),G0tensor(680),G0tensor(681),G0tensor(682), &
    G0tensor(683),M2L1R1,[nMT,nMH],G0tensor(684),G0tensor(685))
  call TI_triangle_red(G2tensor(18),RedBasis(10),mass3set(:,13),G0tensor(686),G0tensor(687),G0tensor(688), &
    G0tensor(689),M2L1R1,[nMT,nMZ],G0tensor(690),G0tensor(691))
  call TI_triangle_red(G3tensor(6),RedBasis(11),mass3set(:,11),G0tensor(692),G0tensor(693),G0tensor(694), &
    G0tensor(695),M2L1R1,[nMB],G0tensor(696))
  call TI_triangle_red(G2tensor(194),RedBasis(10),mass3set(:,14),G0tensor(697),G0tensor(698),G0tensor(699), &
    G0tensor(700),M2L1R1,[nMB,nMW],G0tensor(701),G0tensor(702))
  call TI_triangle_red(G2tensor(23),RedBasis(10),mass3set(:,15),G0tensor(703),G0tensor(704),G0tensor(705), &
    G0tensor(706),M2L1R1,[nMT],G0tensor(707))
  call TI_triangle_red(G2tensor(178),RedBasis(17),mass3set(:,10),G0tensor(708),G0tensor(709),G0tensor(710), &
    G0tensor(711),M2L1R1,[nMT],G0tensor(712))
  call TI_triangle_red(G2tensor(51),RedBasis(16),mass3set(:,12),G0tensor(713),G0tensor(714),G0tensor(715), &
    G0tensor(716),M2L1R1,[nMT,nMH],G0tensor(717),G0tensor(718))
  call TI_triangle_red(G2tensor(102),RedBasis(15),mass3set(:,10),G0tensor(719),G0tensor(720),G0tensor(721), &
    G0tensor(722),M2L1R1,[nMT],G0tensor(723))
  call TI_triangle_red(G2tensor(533),RedBasis(16),mass3set(:,13),G0tensor(724),G0tensor(725),G0tensor(726), &
    G0tensor(727),M2L1R1,[nMT,nMZ],G0tensor(728),G0tensor(729))
  call TI_triangle_red(G2tensor(177),RedBasis(17),mass3set(:,11),G0tensor(730),G0tensor(731),G0tensor(732), &
    G0tensor(733),M2L1R1,[nMB],G0tensor(734))
  call TI_triangle_red(G2tensor(58),RedBasis(16),mass3set(:,14),G0tensor(735),G0tensor(736),G0tensor(737), &
    G0tensor(738),M2L1R1,[nMB,nMW],G0tensor(739),G0tensor(740))
  call TI_triangle_red(G2tensor(111),RedBasis(15),mass3set(:,11),G0tensor(741),G0tensor(742),G0tensor(743), &
    G0tensor(744),M2L1R1,[nMB],G0tensor(745))
  call TI_triangle_red(G2tensor(66),RedBasis(16),mass3set(:,15),G0tensor(746),G0tensor(747),G0tensor(748), &
    G0tensor(749),M2L1R1,[nMT],G0tensor(750))
  call TI_triangle_red(G2tensor(78),RedBasis(20),mass3set(:,12),G0tensor(751),G0tensor(752),G0tensor(753), &
    G0tensor(754),M2L1R1,[nMT,nMH],G0tensor(755),G0tensor(756))
  call TI_triangle_red(G2tensor(82),RedBasis(20),mass3set(:,13),G0tensor(757),G0tensor(758),G0tensor(759), &
    G0tensor(760),M2L1R1,[nMT,nMZ],G0tensor(761),G0tensor(762))
  call TI_triangle_red(G2tensor(87),RedBasis(20),mass3set(:,14),G0tensor(763),G0tensor(764),G0tensor(765), &
    G0tensor(766),M2L1R1,[nMB,nMW],G0tensor(767),G0tensor(768))
  call TI_triangle_red(G2tensor(91),RedBasis(20),mass3set(:,15),G0tensor(769),G0tensor(770),G0tensor(771), &
    G0tensor(772),M2L1R1,[nMT],G0tensor(773))
  call TI_triangle_red(G2tensor(98),RedBasis(21),mass3set(:,12),G0tensor(774),G0tensor(775),G0tensor(776), &
    G0tensor(777),M2L1R1,[nMT,nMH],G0tensor(778),G0tensor(779))
  call TI_triangle_red(G2tensor(329),RedBasis(21),mass3set(:,13),G0tensor(780),G0tensor(781),G0tensor(782), &
    G0tensor(783),M2L1R1,[nMT,nMZ],G0tensor(784),G0tensor(785))
  call TI_triangle_red(G2tensor(521),RedBasis(21),mass3set(:,14),G0tensor(786),G0tensor(787),G0tensor(788), &
    G0tensor(789),M2L1R1,[nMB,nMW],G0tensor(790),G0tensor(791))
  call TI_triangle_red(G2tensor(114),RedBasis(21),mass3set(:,15),G0tensor(792),G0tensor(793),G0tensor(794), &
    G0tensor(795),M2L1R1,[nMT],G0tensor(796))
  call TI_triangle_red(G2tensor(293),RedBasis(20),mass3set(:,9),G0tensor(797),G0tensor(798),G0tensor(799), &
    G0tensor(800),M2L1R1,[nMW,nMB],G0tensor(801),G0tensor(802))
  call TI_triangle_red(G2tensor(305),RedBasis(21),mass3set(:,9),G0tensor(803),G0tensor(804),G0tensor(805), &
    G0tensor(806),M2L1R1,[nMW,nMB],G0tensor(807),G0tensor(808))
  call TI_triangle_red(G2tensor(395),RedBasis(22),mass3set(:,1),G0tensor(809),G0tensor(810),G0tensor(811), &
    G0tensor(812),M2L1R1,[nMH,nMT],G0tensor(813),G0tensor(814))
  call TI_triangle_red(G2tensor(245),RedBasis(22),mass3set(:,2),G0tensor(815),G0tensor(816),G0tensor(817), &
    G0tensor(818),M2L1R1,[nMZ,nMT],G0tensor(819),G0tensor(820))
  call TI_triangle_red(G2tensor(401),RedBasis(22),mass3set(:,4),G0tensor(821),G0tensor(822),G0tensor(823), &
    G0tensor(824),M2L1R1,[nMT],G0tensor(825))
  call TI_triangle_red(G2tensor(422),RedBasis(26),mass3set(:,1),G0tensor(826),G0tensor(827),G0tensor(828), &
    G0tensor(829),M2L1R1,[nMH,nMT],G0tensor(830),G0tensor(831))
  call TI_triangle_red(G2tensor(431),RedBasis(26),mass3set(:,2),G0tensor(832),G0tensor(833),G0tensor(834), &
    G0tensor(835),M2L1R1,[nMZ,nMT],G0tensor(836),G0tensor(837))
  call TI_triangle_red(G2tensor(428),RedBasis(26),mass3set(:,4),G0tensor(838),G0tensor(839),G0tensor(840), &
    G0tensor(841),M2L1R1,[nMT],G0tensor(842))
  call TI_triangle_red(G3tensor(12),RedBasis(11),mass3set(:,18),G0tensor(843),G0tensor(844),G0tensor(845), &
    G0tensor(846),M2L1R1,[nME],G0tensor(847))
  call TI_triangle_red(G3tensor(13),RedBasis(11),mass3set(:,19),G0tensor(848),G0tensor(849),G0tensor(850), &
    G0tensor(851),M2L1R1,[nMM],G0tensor(852))
  call TI_triangle_red(G3tensor(14),RedBasis(11),mass3set(:,20),G0tensor(853),G0tensor(854),G0tensor(855), &
    G0tensor(856),M2L1R1,[nML],G0tensor(857))
  call TI_triangle_red(G3tensor(18),RedBasis(11),mass3set(:,21),G0tensor(858),G0tensor(859),G0tensor(860),G0tensor(861),M2L1R1)
  call ol_merge_tensors(T0sum(112),[G0tensor(1)])
  call ol_merge_tensors(T0sum(113),[G0tensor(31)])
  call ol_merge_tensors(T0sum(114),[G0tensor(61)])
  call ol_merge_tensors(T0sum(115),[G0tensor(91)])
  call ol_merge_tensors(T0sum(116),[G0tensor(116)])
  call ol_merge_tensors(T0sum(117),[G0tensor(146)])
  call ol_merge_tensors(T0sum(118),[G0tensor(176)])
  call ol_merge_tensors(T0sum(119),[G0tensor(206)])
  call ol_merge_tensors(T0sum(120),[G0tensor(231)])
  call ol_merge_tensors(T0sum(121),[G0tensor(261)])
  call ol_merge_tensors(T0sum(122),[G0tensor(291)])
  call ol_merge_tensors(T0sum(123),[G0tensor(321)])
  call ol_merge_tensors(T0sum(124),[G0tensor(346)])
  call ol_merge_tensors(T0sum(125),[G0tensor(376)])
  call ol_merge_tensors(T0sum(126),[G0tensor(406)])
  call ol_merge_tensors(T0sum(127),[G0tensor(436)])
  call ol_merge_tensors(T0sum(128),[G0tensor(461)])
  call ol_merge_tensors(T0sum(129),[G0tensor(491)])
  call ol_merge_tensors(T0sum(130),[G0tensor(521)])
  call ol_merge_tensors(T0sum(131),[G0tensor(551)])
  call ol_merge_tensors(T0sum(132),[G0tensor(47)])
  call ol_merge_tensors(T0sum(133),[G0tensor(67)])
  call ol_merge_tensors(T0sum(134),[G0tensor(152)])
  call ol_merge_tensors(T0sum(135),[G0tensor(133)])
  call ol_merge_tensors(T0sum(136),[G0tensor(112)])
  call ol_merge_tensors(T0sum(137),[G0tensor(202)])
  call ol_merge_tensors(T0sum(138),[G0tensor(172)])
  call ol_merge_tensors(T0sum(139),[G0tensor(217)])
  call ol_merge_tensors(T0sum(140),[G0tensor(227)])
  call ol_merge_tensors(T0sum(141),[G0tensor(232)])
  call ol_merge_tensors(T0sum(142),[G0tensor(247)])
  call ol_merge_tensors(T0sum(143),[G0tensor(280)])
  call ol_merge_tensors(T0sum(144),[G0tensor(110)])
  call ol_merge_tensors(T0sum(145),[G0tensor(38)])
  call ol_merge_tensors(T0sum(146),[G0tensor(48)])
  call ol_merge_tensors(T0sum(147),[G0tensor(130)])
  call ol_merge_tensors(T0sum(148),[G0tensor(59)])
  call ol_merge_tensors(T0sum(149),[G0tensor(315)])
  call ol_merge_tensors(T0sum(150),[G0tensor(69)])
  call ol_merge_tensors(T0sum(151),[G0tensor(325)])
  call ol_merge_tensors(T0sum(152),[G0tensor(405)])
  call ol_merge_tensors(T0sum(153),[G0tensor(89)])
  call ol_merge_tensors(T0sum(154),[G0tensor(420)])
  call ol_merge_tensors(T0sum(155),[G0tensor(387)])
  call ol_merge_tensors(T0sum(156),[G0tensor(150)])
  call ol_merge_tensors(T0sum(157),[G0tensor(155)])
  call ol_merge_tensors(T0sum(158),[G0tensor(160)])
  call ol_merge_tensors(T0sum(159),[G0tensor(430)])
  call ol_merge_tensors(T0sum(160),[G0tensor(480)])
  call ol_merge_tensors(T0sum(161),[G0tensor(490)])
  call ol_merge_tensors(T0sum(162),[G0tensor(190)])
  call ol_merge_tensors(T0sum(163),[G0tensor(505)])
  call ol_merge_tensors(T0sum(164),[G0tensor(238)])
  call ol_merge_tensors(T0sum(165),[G0tensor(530)])
  call ol_merge_tensors(T0sum(166),[G0tensor(282)])
  call ol_merge_tensors(T0sum(167),[G0tensor(35)])
  call ol_merge_tensors(T0sum(168),[G0tensor(317)])
  call ol_merge_tensors(T0sum(169),[G0tensor(85)])
  call ol_merge_tensors(T0sum(170),[G0tensor(175)])
  call ol_merge_tensors(T0sum(171),[G0tensor(262)])
  call ol_merge_tensors(T0sum(172),[G0tensor(554)])
  call ol_merge_tensors(T0sum(173),[G0tensor(272)])
  call ol_merge_tensors(T0sum(174),[G0tensor(292)])
  call ol_merge_tensors(T0sum(175),[G0tensor(307)])
  call ol_merge_tensors(T0sum(176),[G0tensor(164)])
  call ol_merge_tensors(T0sum(177),[G0tensor(518)])
  call ol_merge_tensors(T0sum(178),[G0tensor(84)])
  call ol_merge_tensors(T0sum(179),[G0tensor(114)])
  call ol_merge_tensors(T0sum(180),[G0tensor(134)])
  call ol_merge_tensors(T0sum(181),[G0tensor(219)])
  call ol_merge_tensors(T0sum(182),[G0tensor(392)])
  call ol_merge_tensors(T0sum(183),[G0tensor(153)])
  call ol_merge_tensors(T0sum(184),[G0tensor(417)])
  call ol_merge_tensors(T0sum(185),[G0tensor(173)])
  call ol_merge_tensors(T0sum(186),[G0tensor(457)])
  call ol_merge_tensors(T0sum(187),[G0tensor(288)])
  call ol_merge_tensors(T0sum(188),[G0tensor(213)])
  call ol_merge_tensors(T0sum(189),[G0tensor(512)])
  call ol_merge_tensors(T0sum(190),[G0tensor(268)])
  call ol_merge_tensors(T0sum(191),[G0tensor(532)])
  call ol_merge_tensors(T0sum(192),[G0tensor(269)])
  call ol_merge_tensors(T0sum(193),[G0tensor(259)])
  call ol_merge_tensors(T0sum(194),[G0tensor(359)])
  call ol_merge_tensors(T0sum(195),[G0tensor(304)])
  call ol_merge_tensors(T0sum(196),[G0tensor(344)])
  call ol_merge_tensors(T0sum(197),[G0tensor(428)])
  call ol_merge_tensors(T0sum(198),[G0tensor(318)])
  call ol_merge_tensors(T0sum(199),[G0tensor(338)])
  call ol_merge_tensors(T0sum(200),[G0tensor(349)])
  call ol_merge_tensors(T0sum(201),[G0tensor(383)])
  call ol_merge_tensors(T0sum(202),[G0tensor(474)])
  call ol_merge_tensors(T0sum(203),[G0tensor(398)])
  call ol_merge_tensors(T0sum(204),[G0tensor(413)])
  call ol_merge_tensors(T0sum(205),[G0tensor(414)])
  call ol_merge_tensors(T0sum(206),[G0tensor(443)])
  call ol_merge_tensors(T0sum(207),[G0tensor(459)])
  call ol_merge_tensors(T0sum(208),[G0tensor(529)])
  call ol_merge_tensors(T0sum(209),[G0tensor(544)])
  call ol_merge_tensors(T0sum(210),[G0tensor(559)])
  call ol_merge_tensors(T0sum(211),[G0tensor(565)])
  call ol_merge_tensors(T0sum(212),[G0tensor(571)])
  call ol_merge_tensors(T0sum(213),[G0tensor(576)])
  call ol_merge_tensors(T0sum(214),[G0tensor(582)])
  call ol_merge_tensors(T0sum(215),[G0tensor(588)])
  call ol_merge_tensors(T0sum(216),[G0tensor(594)])
  call ol_merge_tensors(T0sum(217),[G0tensor(599)])
  call ol_merge_tensors(T0sum(218),[G0tensor(605)])
  call ol_merge_tensors(T0sum(219),[G0tensor(611)])
  call ol_merge_tensors(T0sum(220),[G0tensor(617)])
  call ol_merge_tensors(T0sum(221),[G0tensor(623)])
  call ol_merge_tensors(T0sum(222),[G0tensor(629)])
  call ol_merge_tensors(T0sum(223),[G0tensor(635)])
  call ol_merge_tensors(T0sum(224),[G0tensor(641)])
  call ol_merge_tensors(T0sum(225),[G0tensor(647)])
  call ol_merge_tensors(T0sum(226),[G0tensor(653)])
  call ol_merge_tensors(T0sum(227),[G0tensor(659)])
  call ol_merge_tensors(T0sum(228),[G0tensor(665)])
  call ol_merge_tensors(T0sum(229),[G0tensor(670)])
  call ol_merge_tensors(T0sum(230),[G0tensor(675)])
  call ol_merge_tensors(T0sum(231),[G0tensor(680)])
  call ol_merge_tensors(T0sum(232),[G0tensor(686)])
  call ol_merge_tensors(T0sum(233),[G0tensor(692)])
  call ol_merge_tensors(T0sum(234),[G0tensor(697)])
  call ol_merge_tensors(T0sum(235),[G0tensor(703)])
  call ol_merge_tensors(T0sum(236),[G0tensor(708)])
  call ol_merge_tensors(T0sum(237),[G0tensor(713)])
  call ol_merge_tensors(T0sum(238),[G0tensor(719)])
  call ol_merge_tensors(T0sum(239),[G0tensor(724)])
  call ol_merge_tensors(T0sum(240),[G0tensor(730)])
  call ol_merge_tensors(T0sum(241),[G0tensor(735)])
  call ol_merge_tensors(T0sum(242),[G0tensor(741)])
  call ol_merge_tensors(T0sum(243),[G0tensor(746)])
  call ol_merge_tensors(T0sum(244),[G0tensor(751)])
  call ol_merge_tensors(T0sum(245),[G0tensor(757)])
  call ol_merge_tensors(T0sum(246),[G0tensor(763)])
  call ol_merge_tensors(T0sum(247),[G0tensor(769)])
  call ol_merge_tensors(T0sum(248),[G0tensor(774)])
  call ol_merge_tensors(T0sum(249),[G0tensor(780)])
  call ol_merge_tensors(T0sum(250),[G0tensor(786)])
  call ol_merge_tensors(T0sum(251),[G0tensor(792)])
  call ol_merge_tensors(T0sum(252),[G0tensor(797)])
  call ol_merge_tensors(T0sum(253),[G0tensor(803)])
  call ol_merge_tensors(T0sum(254),[G0tensor(809)])
  call ol_merge_tensors(T0sum(255),[G0tensor(815)])
  call ol_merge_tensors(T0sum(256),[G0tensor(821)])
  call ol_merge_tensors(T0sum(257),[G0tensor(826)])
  call ol_merge_tensors(T0sum(258),[G0tensor(832)])
  call ol_merge_tensors(T0sum(259),[G0tensor(838)])
  call ol_merge_tensors(T0sum(260),[G0tensor(843)])
  call ol_merge_tensors(T0sum(261),[G0tensor(848)])
  call ol_merge_tensors(T0sum(262),[G0tensor(853)])
  call ol_merge_tensors(T0sum(263),[G0tensor(858)])
  Gcoeff(:)%j = (c(12)*M(1,:)%j) * den(47)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(607),h0tab(:,607),[27,4],[nMW,nMW],3,1,wf8(:,13))
  call Hloop_VVS_S(ntryL,G0H32(1),ex4(:),wf8(:,13),G0H2(1),m4h2x8x2(:,1),heltab3x32(:,:,1))
  Gcoeff(:)%j = (c(12)*M(1,:)%j) * den(47)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(608),h0tab(:,608),[27,4],[nMW,nMW],3,1,wf8(:,13))
  call Hloop_VVS_S(ntryL,G0H32(1),ex4(:),wf8(:,13),G0H2(2),m4h2x8x2(:,2),heltab3x32(:,:,2))
  Gcoeff(:)%j = (c(12)*M(1,:)%j) * den(49)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(609),h0tab(:,609),[27,4],[nMW,nMW],3,1,wf8(:,39))
  call Hloop_VVS_S(ntryL,G0H32(1),ex4(:),wf8(:,39),G0H2(3),m4h2x8x2(:,3),heltab3x32(:,:,3))
  Gcoeff(:)%j = (-(c(12)*M(1,:)%j)) * den(49)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(610),h0tab(:,610),[27,4],[nMW,nMW],3,1,wf8(:,39))
  call Hloop_VVS_S(ntryL,G0H32(1),ex4(:),wf8(:,39),G0H2(4),m4h2x8x2(:,4),heltab3x32(:,:,4))
  Gcoeff(:)%j = (-(c(4)*M(1,:)%j)) * den(51)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(611),h0tab(:,611),[27,4],[nMW,nMW],3,1,wf8(:,40))
  call Hloop_SVV_S(ntryL,G0H32(1),ex4(:),wf8(:,40),G0H2(5),m4h2x8x2(:,5),heltab3x32(:,:,5))
  Gcoeff(:)%j = (c(31)*M(1,:)%j) * den(49)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(612),h0tab(:,612),[27,4],[nMW,nMW],3,1,wf8(:,41))
  call Hloop_SVV_S(ntryL,G0H32(1),ex4(:),wf8(:,41),G0H2(6),m4h2x8x2(:,6),heltab3x32(:,:,6))
  Gcoeff(:)%j = (-(c(3)*M(1,:)%j)) * den(51)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(613),h0tab(:,613),[27,4],[nMW,nMW],3,1,wf8(:,40))
  call Hloop_VWW_V(ntryL,G0H32(1),ex4(:),wf8(:,40),G0H2(7),m4h2x8x2(:,7),heltab3x32(:,:,7))
  Gcoeff(:)%j = (-(c(27)*M(1,:)%j)) * den(49)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(614),h0tab(:,614),[27,4],[nMW,nMW],3,1,wf8(:,41))
  call Hloop_VWW_V(ntryL,G0H32(1),ex4(:),wf8(:,41),G0H2(8),m4h2x8x2(:,8),heltab3x32(:,:,8))
  Gcoeff(:)%j = (c(12)*M(1,:)%j) * den(52)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(615),h0tab(:,615),[27,4],[nMW,nMW],3,1,wf8(:,14))
  call Hloop_VVS_S(ntryL,G0H32(1),ex4(:),wf8(:,14),G0H2(9),m4h2x8x2(:,9),heltab3x32(:,:,9))
  Gcoeff(:)%j = (c(12)*M(1,:)%j) * den(52)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(616),h0tab(:,616),[27,4],[nMW,nMW],3,1,wf8(:,14))
  call Hloop_VVS_S(ntryL,G0H32(1),ex4(:),wf8(:,14),G0H2(10),m4h2x8x2(:,10),heltab3x32(:,:,10))
  Gcoeff(:)%j = (c(12)*M(1,:)%j) * den(53)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(617),h0tab(:,617),[27,4],[nMW,nMW],3,1,wf8(:,42))
  call Hloop_VVS_S(ntryL,G0H32(1),ex4(:),wf8(:,42),G0H2(11),m4h2x8x2(:,11),heltab3x32(:,:,11))
  Gcoeff(:)%j = (-(c(12)*M(1,:)%j)) * den(53)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(618),h0tab(:,618),[27,4],[nMW,nMW],3,1,wf8(:,42))
  call Hloop_VVS_S(ntryL,G0H32(1),ex4(:),wf8(:,42),G0H2(12),m4h2x8x2(:,12),heltab3x32(:,:,12))
  Gcoeff(:)%j = (-(c(4)*M(1,:)%j)) * den(54)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(619),h0tab(:,619),[27,4],[nMW,nMW],3,1,wf8(:,43))
  call Hloop_SVV_S(ntryL,G0H32(1),ex4(:),wf8(:,43),G0H2(13),m4h2x8x2(:,13),heltab3x32(:,:,13))
  Gcoeff(:)%j = (c(31)*M(1,:)%j) * den(53)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(620),h0tab(:,620),[27,4],[nMW,nMW],3,1,wf8(:,44))
  call Hloop_SVV_S(ntryL,G0H32(1),ex4(:),wf8(:,44),G0H2(14),m4h2x8x2(:,14),heltab3x32(:,:,14))
  Gcoeff(:)%j = (-(c(3)*M(1,:)%j)) * den(54)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(621),h0tab(:,621),[27,4],[nMW,nMW],3,1,wf8(:,43))
  call Hloop_VWW_V(ntryL,G0H32(1),ex4(:),wf8(:,43),G0H2(15),m4h2x8x2(:,15),heltab3x32(:,:,15))
  Gcoeff(:)%j = (-(c(27)*M(1,:)%j)) * den(53)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(622),h0tab(:,622),[27,4],[nMW,nMW],3,1,wf8(:,44))
  call Hloop_VWW_V(ntryL,G0H32(1),ex4(:),wf8(:,44),G0H2(16),m4h2x8x2(:,16),heltab3x32(:,:,16))
  Gcoeff(:)%j = (c(12)*M(1,:)%j) * den(47)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(623),h0tab(:,623),[23,8],[nMW,nMW],3,1,wf8(:,13))
  call Hloop_VVS_S(ntryL,G0H32(1),ex3(:),wf8(:,13),G0H2(17),m4h2x8x2(:,17),heltab3x32(:,:,17))
  Gcoeff(:)%j = (c(12)*M(1,:)%j) * den(47)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(624),h0tab(:,624),[23,8],[nMW,nMW],3,1,wf8(:,13))
  call Hloop_VVS_S(ntryL,G0H32(1),ex3(:),wf8(:,13),G0H2(18),m4h2x8x2(:,18),heltab3x32(:,:,18))
  Gcoeff(:)%j = (c(12)*M(1,:)%j) * den(49)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(625),h0tab(:,625),[23,8],[nMW,nMW],3,1,wf8(:,39))
  call Hloop_VVS_S(ntryL,G0H32(1),ex3(:),wf8(:,39),G0H2(19),m4h2x8x2(:,19),heltab3x32(:,:,19))
  Gcoeff(:)%j = (-(c(12)*M(1,:)%j)) * den(49)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(626),h0tab(:,626),[23,8],[nMW,nMW],3,1,wf8(:,39))
  call Hloop_VVS_S(ntryL,G0H32(1),ex3(:),wf8(:,39),G0H2(20),m4h2x8x2(:,20),heltab3x32(:,:,20))
  Gcoeff(:)%j = (-(c(4)*M(1,:)%j)) * den(51)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(627),h0tab(:,627),[23,8],[nMW,nMW],3,1,wf8(:,40))
  call Hloop_SVV_S(ntryL,G0H32(1),ex3(:),wf8(:,40),G0H2(21),m4h2x8x2(:,21),heltab3x32(:,:,21))
  Gcoeff(:)%j = (c(31)*M(1,:)%j) * den(49)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(628),h0tab(:,628),[23,8],[nMW,nMW],3,1,wf8(:,41))
  call Hloop_SVV_S(ntryL,G0H32(1),ex3(:),wf8(:,41),G0H2(22),m4h2x8x2(:,22),heltab3x32(:,:,22))
  Gcoeff(:)%j = (-(c(3)*M(1,:)%j)) * den(51)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(629),h0tab(:,629),[23,8],[nMW,nMW],3,1,wf8(:,40))
  call Hloop_VWW_V(ntryL,G0H32(1),ex3(:),wf8(:,40),G0H2(23),m4h2x8x2(:,23),heltab3x32(:,:,23))
  Gcoeff(:)%j = (-(c(27)*M(1,:)%j)) * den(49)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(630),h0tab(:,630),[23,8],[nMW,nMW],3,1,wf8(:,41))
  call Hloop_VWW_V(ntryL,G0H32(1),ex3(:),wf8(:,41),G0H2(24),m4h2x8x2(:,24),heltab3x32(:,:,24))
  Gcoeff(:)%j = (c(12)*M(1,:)%j) * den(52)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(631),h0tab(:,631),[23,8],[nMW,nMW],3,1,wf8(:,14))
  call Hloop_VVS_S(ntryL,G0H32(1),ex3(:),wf8(:,14),G0H2(25),m4h2x8x2(:,25),heltab3x32(:,:,25))
  Gcoeff(:)%j = (c(12)*M(1,:)%j) * den(52)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(632),h0tab(:,632),[23,8],[nMW,nMW],3,1,wf8(:,14))
  call Hloop_VVS_S(ntryL,G0H32(1),ex3(:),wf8(:,14),G0H2(26),m4h2x8x2(:,26),heltab3x32(:,:,26))
  Gcoeff(:)%j = (c(12)*M(1,:)%j) * den(53)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(633),h0tab(:,633),[23,8],[nMW,nMW],3,1,wf8(:,42))
  call Hloop_VVS_S(ntryL,G0H32(1),ex3(:),wf8(:,42),G0H2(27),m4h2x8x2(:,27),heltab3x32(:,:,27))
  Gcoeff(:)%j = (-(c(12)*M(1,:)%j)) * den(53)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(634),h0tab(:,634),[23,8],[nMW,nMW],3,1,wf8(:,42))
  call Hloop_VVS_S(ntryL,G0H32(1),ex3(:),wf8(:,42),G0H2(28),m4h2x8x2(:,28),heltab3x32(:,:,28))
  Gcoeff(:)%j = (-(c(4)*M(1,:)%j)) * den(54)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(635),h0tab(:,635),[23,8],[nMW,nMW],3,1,wf8(:,43))
  call Hloop_SVV_S(ntryL,G0H32(1),ex3(:),wf8(:,43),G0H2(29),m4h2x8x2(:,29),heltab3x32(:,:,29))
  Gcoeff(:)%j = (c(31)*M(1,:)%j) * den(53)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(636),h0tab(:,636),[23,8],[nMW,nMW],3,1,wf8(:,44))
  call Hloop_SVV_S(ntryL,G0H32(1),ex3(:),wf8(:,44),G0H2(30),m4h2x8x2(:,30),heltab3x32(:,:,30))
  Gcoeff(:)%j = (-(c(3)*M(1,:)%j)) * den(54)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(637),h0tab(:,637),[23,8],[nMW,nMW],3,1,wf8(:,43))
  call Hloop_VWW_V(ntryL,G0H32(1),ex3(:),wf8(:,43),G0H2(31),m4h2x8x2(:,31),heltab3x32(:,:,31))
  Gcoeff(:)%j = (-(c(27)*M(1,:)%j)) * den(53)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(638),h0tab(:,638),[23,8],[nMW,nMW],3,1,wf8(:,44))
  call Hloop_VWW_V(ntryL,G0H32(1),ex3(:),wf8(:,44),G0H2(32),m4h2x8x2(:,32),heltab3x32(:,:,32))
  Gcoeff(:)%j = (c(23)*M(1,:)%j) * den(47)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(639),h0tab(:,639),[19,12],[nMW,nMW],3,1,wf8(:,13))
  call Hloop_SS_S(ntryL,G0H32(1),wf8(:,13),G0H4(2),m3h8x4(:,321),heltab2x32(:,:,607))
  Gcoeff(:)%j = (c(13)*M(1,:)%j) * den(47)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(640),h0tab(:,640),[19,12],[nMW,nMW],3,1,wf8(:,13))
  call Hloop_VS_V(ntryL,G0H32(1),wf8(:,13),G0H4(1),m3h8x4(:,322),heltab2x32(:,:,608))
  Gcoeff(:)%j = (-(c(4)*M(1,:)%j)) * den(51)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(641),h0tab(:,641),[19,12],[nMW,nMW],3,1,wf8(:,40))
  call Hloop_TV_S(ntryL,G0H32(1),0,wf8(:,40),19,G1H4(67),m3h8x4(:,323),heltab2x32(:,:,609))
  Gcoeff(:)%j = (c(31)*M(1,:)%j) * den(49)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(642),h0tab(:,642),[19,12],[nMW,nMW],3,1,wf8(:,41))
  call Hloop_TV_S(ntryL,G0H32(1),0,wf8(:,41),19,G1H4(29),m3h8x4(:,324),heltab2x32(:,:,610))
  Gcoeff(:)%j = (-(c(3)*M(1,:)%j)) * den(51)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(643),h0tab(:,643),[19,12],[nMW,nMW],3,1,wf8(:,40))
  call Hloop_UV_W(ntryL,G0H32(1),0,wf8(:,40),19,G1H4(75),m3h8x4(:,325),heltab2x32(:,:,611))
  Gcoeff(:)%j = (-(c(27)*M(1,:)%j)) * den(49)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(644),h0tab(:,644),[19,12],[nMW,nMW],3,1,wf8(:,41))
  call Hloop_UV_W(ntryL,G0H32(1),0,wf8(:,41),19,G1H4(171),m3h8x4(:,326),heltab2x32(:,:,612))
  Gcoeff(:)%j = (c(23)*M(1,:)%j) * den(52)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(645),h0tab(:,645),[19,12],[nMW,nMW],3,1,wf8(:,14))
  call Hloop_SS_S(ntryL,G0H32(1),wf8(:,14),G0H4(6),m3h8x4(:,327),heltab2x32(:,:,613))
  Gcoeff(:)%j = (c(13)*M(1,:)%j) * den(52)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(646),h0tab(:,646),[19,12],[nMW,nMW],3,1,wf8(:,14))
  call Hloop_VS_V(ntryL,G0H32(1),wf8(:,14),G0H4(7),m3h8x4(:,328),heltab2x32(:,:,614))
  Gcoeff(:)%j = (-(c(4)*M(1,:)%j)) * den(54)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(647),h0tab(:,647),[19,12],[nMW,nMW],3,1,wf8(:,43))
  call Hloop_TV_S(ntryL,G0H32(1),0,wf8(:,43),19,G1H4(135),m3h8x4(:,329),heltab2x32(:,:,615))
  Gcoeff(:)%j = (c(31)*M(1,:)%j) * den(53)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(648),h0tab(:,648),[19,12],[nMW,nMW],3,1,wf8(:,44))
  call Hloop_TV_S(ntryL,G0H32(1),0,wf8(:,44),19,G1H4(162),m3h8x4(:,330),heltab2x32(:,:,616))
  Gcoeff(:)%j = (-(c(3)*M(1,:)%j)) * den(54)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(649),h0tab(:,649),[19,12],[nMW,nMW],3,1,wf8(:,43))
  call Hloop_UV_W(ntryL,G0H32(1),0,wf8(:,43),19,G1H4(110),m3h8x4(:,331),heltab2x32(:,:,617))
  Gcoeff(:)%j = (-(c(27)*M(1,:)%j)) * den(53)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(650),h0tab(:,650),[19,12],[nMW,nMW],3,1,wf8(:,44))
  call Hloop_UV_W(ntryL,G0H32(1),0,wf8(:,44),19,G1H4(68),m3h8x4(:,332),heltab2x32(:,:,618))
  Gcoeff(:)%j = (-(c(24)*M(1,:)%j)) * den(21)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(651),h0tab(:,651),[21,10],[nMT,nMH],2,2,wf8(:,23),wf4(:,4))
  call Hloop_SQ_A(ntryL,G0H32(1),wf8(:,23),G0H4(8),ngH,m3h8x4(:,333),heltab2x32(:,:,619))
  call Hloop_Q_A(ntryL,G0H4(8),21,nMT,G1H4(142),n2h4(237))
  Gcoeff(:)%j = (c(24)*M(1,:)%j) * den(21)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(652),h0tab(:,652),[21,10],[nMT,nMZ],2,2,wf8(:,23),wf4(:,4))
  call Hloop_SQ_A(ntryL,G0H32(1),wf8(:,23),G0H4(9),ngX,m3h8x4(:,334),heltab2x32(:,:,620))
  call Hloop_Q_A(ntryL,G0H4(9),21,nMT,G1H4(14),n2h4(238))
  Gcoeff(:)%j = (c(18)*M(1,:)%j) * den(21)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(653),h0tab(:,653),[21,10],[nMB,nMW],2,2,wf8(:,23),wf4(:,4))
  call Hloop_SQ_A(ntryL,G0H32(1),wf8(:,23),G0H4(10),ngPbt,m3h8x4(:,335),heltab2x32(:,:,621))
  call Hloop_Q_A(ntryL,G0H4(10),21,nMB,G1H4(177),n2h4(239))
  Gcoeff(:)%j = (c(1)*M(1,:)%j) * den(21)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(654),h0tab(:,654),[21,10],[nMT,0],2,2,wf8(:,23),wf4(:,4))
  call Hloop_VQ_A(ntryL,G0H32(1),wf8(:,23),G0H4(11),m3h8x4(:,336),heltab2x32(:,:,622))
  call Hloop_Q_A(ntryL,G0H4(11),21,nMT,G1H4(141),n2h4(240))
  Gcoeff(:)%j = (c(2)*M(1,:)%j) * den(21)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(655),h0tab(:,655),[21,10],[nMT,nMZ],2,2,wf8(:,23),wf4(:,4))
  call Hloop_ZQ_A(ntryL,G0H32(1),wf8(:,23),G0H4(12),ngZu,m3h8x4(:,337),heltab2x32(:,:,623))
  call Hloop_Q_A(ntryL,G0H4(12),21,nMT,G1H4(163),n2h4(241))
  Gcoeff(:)%j = (c(9)*M(1,:)%j) * den(21)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(656),h0tab(:,656),[21,10],[nMB,nMW],2,2,wf8(:,23),wf4(:,4))
  call Hloop_WQ_A(ntryL,G0H32(1),wf8(:,23),G0H4(13),m3h8x4(:,338),heltab2x32(:,:,624))
  call Hloop_Q_A(ntryL,G0H4(13),21,nMB,G1H4(113),n2h4(242))
  Gcoeff(:)%j = (-(c(24)*M(1,:)%j)) * den(18)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(657),h0tab(:,657),[26,5],[nMT,nMH],2,2,wf8(:,22),wf4(:,3))
  call Hloop_SA_Q(ntryL,G0H32(1),wf8(:,22),G0H4(14),ngH,m3h8x4(:,339),heltab2x32(:,:,625))
  call Hloop_A_Q(ntryL,G0H4(14),26,nMT,G1H4(84),n2h4(243))
  Gcoeff(:)%j = (c(24)*M(1,:)%j) * den(18)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(658),h0tab(:,658),[26,5],[nMT,nMZ],2,2,wf8(:,22),wf4(:,3))
  call Hloop_SA_Q(ntryL,G0H32(1),wf8(:,22),G0H4(15),ngX,m3h8x4(:,340),heltab2x32(:,:,626))
  call Hloop_A_Q(ntryL,G0H4(15),26,nMT,G1H4(36),n2h4(244))
  Gcoeff(:)%j = (c(18)*M(1,:)%j) * den(18)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(659),h0tab(:,659),[26,5],[nMB,nMW],2,2,wf8(:,22),wf4(:,3))
  call Hloop_SA_Q(ntryL,G0H32(1),wf8(:,22),G0H4(16),ngPtb,m3h8x4(:,341),heltab2x32(:,:,627))
  call Hloop_A_Q(ntryL,G0H4(16),26,nMB,G1H4(81),n2h4(245))
  Gcoeff(:)%j = (c(1)*M(1,:)%j) * den(18)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(660),h0tab(:,660),[26,5],[nMT,0],2,2,wf8(:,22),wf4(:,3))
  call Hloop_VA_Q(ntryL,G0H32(1),wf8(:,22),G0H4(17),m3h8x4(:,342),heltab2x32(:,:,628))
  call Hloop_A_Q(ntryL,G0H4(17),26,nMT,G1H4(195),n2h4(246))
  Gcoeff(:)%j = (c(2)*M(1,:)%j) * den(18)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(661),h0tab(:,661),[26,5],[nMT,nMZ],2,2,wf8(:,22),wf4(:,3))
  call Hloop_ZA_Q(ntryL,G0H32(1),wf8(:,22),G0H4(18),ngZu,m3h8x4(:,343),heltab2x32(:,:,629))
  call Hloop_A_Q(ntryL,G0H4(18),26,nMT,G1H4(147),n2h4(247))
  Gcoeff(:)%j = (c(9)*M(1,:)%j) * den(18)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(662),h0tab(:,662),[26,5],[nMB,nMW],2,2,wf8(:,22),wf4(:,3))
  call Hloop_WA_Q(ntryL,G0H32(1),wf8(:,22),G0H4(19),m3h8x4(:,344),heltab2x32(:,:,630))
  call Hloop_A_Q(ntryL,G0H4(19),26,nMB,G1H4(164),n2h4(248))
  Gcoeff(:)%j = (-(c(24)*M(1,:)%j)) * den(26)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(663),h0tab(:,663),[18,13],[nMH,nMT],2,2,wf4(:,6),wf8(:,26))
  call Hloop_QA_S(ntryL,G0H32(1),wf4(:,6),G0H8(23),ngH,m3h4x8(:,117),heltab2x32(:,:,631))
  Gcoeff(:)%j = (c(24)*M(1,:)%j) * den(26)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(664),h0tab(:,664),[18,13],[nMZ,nMT],2,2,wf4(:,6),wf8(:,26))
  call Hloop_QA_S(ntryL,G0H32(1),wf4(:,6),G0H8(24),ngX,m3h4x8(:,118),heltab2x32(:,:,632))
  Gcoeff(:)%j = (c(18)*M(1,:)%j) * den(26)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(665),h0tab(:,665),[18,13],[nMW,nMB],2,2,wf4(:,6),wf8(:,26))
  call Hloop_QA_S(ntryL,G0H32(1),wf4(:,6),G0H8(25),ngPtb,m3h4x8(:,119),heltab2x32(:,:,633))
  Gcoeff(:)%j = (c(1)*M(1,:)%j) * den(26)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(666),h0tab(:,666),[18,13],[0,nMT],2,2,wf4(:,6),wf8(:,26))
  call Hloop_QA_V(ntryL,G0H32(1),wf4(:,6),G0H8(26),m3h4x8(:,120),heltab2x32(:,:,634))
  Gcoeff(:)%j = (c(2)*M(1,:)%j) * den(26)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(667),h0tab(:,667),[18,13],[nMZ,nMT],2,2,wf4(:,6),wf8(:,26))
  call Hloop_QA_Z(ntryL,G0H32(1),wf4(:,6),G0H8(28),ngZu,m3h4x8(:,121),heltab2x32(:,:,635))
  Gcoeff(:)%j = (c(9)*M(1,:)%j) * den(26)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(668),h0tab(:,668),[18,13],[nMW,nMB],2,2,wf4(:,6),wf8(:,26))
  call Hloop_QA_W(ntryL,G0H32(1),wf4(:,6),G0H8(29),m3h4x8(:,122),heltab2x32(:,:,636))
  Gcoeff(:)%j = (-(c(24)*M(1,:)%j)) * den(23)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(669),h0tab(:,669),[26,5],[nMT,nMH],2,2,wf8(:,25),wf4(:,3))
  call Hloop_SA_Q(ntryL,G0H32(1),wf8(:,25),G0H4(20),ngH,m3h8x4(:,345),heltab2x32(:,:,637))
  call Hloop_A_Q(ntryL,G0H4(20),26,nMT,G1H4(114),n2h4(249))
  Gcoeff(:)%j = (c(24)*M(1,:)%j) * den(23)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(670),h0tab(:,670),[26,5],[nMT,nMZ],2,2,wf8(:,25),wf4(:,3))
  call Hloop_SA_Q(ntryL,G0H32(1),wf8(:,25),G0H4(21),ngX,m3h8x4(:,346),heltab2x32(:,:,638))
  call Hloop_A_Q(ntryL,G0H4(21),26,nMT,G1H4(90),n2h4(250))
  Gcoeff(:)%j = (c(18)*M(1,:)%j) * den(23)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(671),h0tab(:,671),[26,5],[nMB,nMW],2,2,wf8(:,25),wf4(:,3))
  call Hloop_SA_Q(ntryL,G0H32(1),wf8(:,25),G0H4(22),ngPtb,m3h8x4(:,347),heltab2x32(:,:,639))
  call Hloop_A_Q(ntryL,G0H4(22),26,nMB,G1H4(37),n2h4(251))
  Gcoeff(:)%j = (c(1)*M(1,:)%j) * den(23)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(672),h0tab(:,672),[26,5],[nMT,0],2,2,wf8(:,25),wf4(:,3))
  call Hloop_VA_Q(ntryL,G0H32(1),wf8(:,25),G0H4(23),m3h8x4(:,348),heltab2x32(:,:,640))
  call Hloop_A_Q(ntryL,G0H4(23),26,nMT,G1H4(13),n2h4(252))
  Gcoeff(:)%j = (c(2)*M(1,:)%j) * den(23)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(673),h0tab(:,673),[26,5],[nMT,nMZ],2,2,wf8(:,25),wf4(:,3))
  call Hloop_ZA_Q(ntryL,G0H32(1),wf8(:,25),G0H4(24),ngZu,m3h8x4(:,349),heltab2x32(:,:,641))
  call Hloop_A_Q(ntryL,G0H4(24),26,nMT,G1H4(201),n2h4(253))
  Gcoeff(:)%j = (c(9)*M(1,:)%j) * den(23)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(674),h0tab(:,674),[26,5],[nMB,nMW],2,2,wf8(:,25),wf4(:,3))
  call Hloop_WA_Q(ntryL,G0H32(1),wf8(:,25),G0H4(69),m3h8x4(:,350),heltab2x32(:,:,642))
  call Hloop_A_Q(ntryL,G0H4(69),26,nMB,G1H4(154),n2h4(254))
  Gcoeff(:)%j = (-(c(24)*M(1,:)%j)) * den(32)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(675),h0tab(:,675),[25,6],[nMT,nMH],2,2,wf8(:,29),wf4(:,10))
  call Hloop_SQ_A(ntryL,G0H32(1),wf8(:,29),G0H4(25),ngH,m3h8x4(:,351),heltab2x32(:,:,643))
  call Hloop_Q_A(ntryL,G0H4(25),25,nMT,G1H4(170),n2h4(255))
  Gcoeff(:)%j = (c(24)*M(1,:)%j) * den(32)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(676),h0tab(:,676),[25,6],[nMT,nMZ],2,2,wf8(:,29),wf4(:,10))
  call Hloop_SQ_A(ntryL,G0H32(1),wf8(:,29),G0H4(70),ngX,m3h8x4(:,352),heltab2x32(:,:,644))
  call Hloop_Q_A(ntryL,G0H4(70),25,nMT,G1H4(115),n2h4(256))
  Gcoeff(:)%j = (c(18)*M(1,:)%j) * den(32)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(677),h0tab(:,677),[25,6],[nMB,nMW],2,2,wf8(:,29),wf4(:,10))
  call Hloop_SQ_A(ntryL,G0H32(1),wf8(:,29),G0H4(26),ngPbt,m3h8x4(:,353),heltab2x32(:,:,645))
  call Hloop_Q_A(ntryL,G0H4(26),25,nMB,G1H4(91),n2h4(257))
  Gcoeff(:)%j = (c(1)*M(1,:)%j) * den(32)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(678),h0tab(:,678),[25,6],[nMT,0],2,2,wf8(:,29),wf4(:,10))
  call Hloop_VQ_A(ntryL,G0H32(1),wf8(:,29),G0H4(77),m3h8x4(:,354),heltab2x32(:,:,646))
  call Hloop_Q_A(ntryL,G0H4(77),25,nMT,G1H4(35),n2h4(258))
  Gcoeff(:)%j = (c(2)*M(1,:)%j) * den(32)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(679),h0tab(:,679),[25,6],[nMT,nMZ],2,2,wf8(:,29),wf4(:,10))
  call Hloop_ZQ_A(ntryL,G0H32(1),wf8(:,29),G0H4(75),ngZu,m3h8x4(:,355),heltab2x32(:,:,647))
  call Hloop_Q_A(ntryL,G0H4(75),25,nMT,G1H4(17),n2h4(259))
  Gcoeff(:)%j = (c(9)*M(1,:)%j) * den(32)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(680),h0tab(:,680),[25,6],[nMB,nMW],2,2,wf8(:,29),wf4(:,10))
  call Hloop_WQ_A(ntryL,G0H32(1),wf8(:,29),G0H4(73),m3h8x4(:,356),heltab2x32(:,:,648))
  call Hloop_Q_A(ntryL,G0H4(73),25,nMB,G1H4(3),n2h4(260))
  Gcoeff(:)%j = (-(c(24)*M(1,:)%j)) * den(29)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(681),h0tab(:,681),[22,9],[nMT,nMH],2,2,wf8(:,28),wf4(:,9))
  call Hloop_SA_Q(ntryL,G0H32(1),wf8(:,28),G0H4(71),ngH,m3h8x4(:,357),heltab2x32(:,:,649))
  call Hloop_A_Q(ntryL,G0H4(71),22,nMT,G1H4(148),n2h4(261))
  Gcoeff(:)%j = (c(24)*M(1,:)%j) * den(29)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(682),h0tab(:,682),[22,9],[nMT,nMZ],2,2,wf8(:,28),wf4(:,9))
  call Hloop_SA_Q(ntryL,G0H32(1),wf8(:,28),G0H4(33),ngX,m3h8x4(:,358),heltab2x32(:,:,650))
  call Hloop_A_Q(ntryL,G0H4(33),22,nMT,G1H4(176),n2h4(262))
  Gcoeff(:)%j = (c(18)*M(1,:)%j) * den(29)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(683),h0tab(:,683),[22,9],[nMB,nMW],2,2,wf8(:,28),wf4(:,9))
  call Hloop_SA_Q(ntryL,G0H32(1),wf8(:,28),G0H4(31),ngPtb,m3h8x4(:,359),heltab2x32(:,:,651))
  call Hloop_A_Q(ntryL,G0H4(31),22,nMB,G1H4(116),n2h4(263))
  Gcoeff(:)%j = (c(1)*M(1,:)%j) * den(29)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(684),h0tab(:,684),[22,9],[nMT,0],2,2,wf8(:,28),wf4(:,9))
  call Hloop_VA_Q(ntryL,G0H32(1),wf8(:,28),G0H4(29),m3h8x4(:,360),heltab2x32(:,:,652))
  call Hloop_A_Q(ntryL,G0H4(29),22,nMT,G1H4(92),n2h4(264))
  Gcoeff(:)%j = (c(2)*M(1,:)%j) * den(29)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(685),h0tab(:,685),[22,9],[nMT,nMZ],2,2,wf8(:,28),wf4(:,9))
  call Hloop_ZA_Q(ntryL,G0H32(1),wf8(:,28),G0H4(27),ngZu,m3h8x4(:,361),heltab2x32(:,:,653))
  call Hloop_A_Q(ntryL,G0H4(27),22,nMT,G1H4(166),n2h4(265))
  Gcoeff(:)%j = (c(9)*M(1,:)%j) * den(29)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(686),h0tab(:,686),[22,9],[nMB,nMW],2,2,wf8(:,28),wf4(:,9))
  call Hloop_WA_Q(ntryL,G0H32(1),wf8(:,28),G0H4(78),m3h8x4(:,362),heltab2x32(:,:,654))
  call Hloop_A_Q(ntryL,G0H4(78),22,nMB,G1H4(18),n2h4(266))
  Gcoeff(:)%j = (-(c(24)*M(1,:)%j)) * den(37)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(687),h0tab(:,687),[25,6],[nMT,nMH],2,2,wf8(:,32),wf4(:,10))
  call Hloop_SQ_A(ntryL,G0H32(1),wf8(:,32),G0H4(76),ngH,m3h8x4(:,363),heltab2x32(:,:,655))
  call Hloop_Q_A(ntryL,G0H4(76),25,nMT,G1H4(1),n2h4(267))
  Gcoeff(:)%j = (c(24)*M(1,:)%j) * den(37)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(688),h0tab(:,688),[25,6],[nMT,nMZ],2,2,wf8(:,32),wf4(:,10))
  call Hloop_SQ_A(ntryL,G0H32(1),wf8(:,32),G0H4(74),ngX,m3h8x4(:,364),heltab2x32(:,:,656))
  call Hloop_Q_A(ntryL,G0H4(74),25,nMT,G1H4(50),n2h4(268))
  Gcoeff(:)%j = (c(18)*M(1,:)%j) * den(37)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(689),h0tab(:,689),[25,6],[nMB,nMW],2,2,wf8(:,32),wf4(:,10))
  call Hloop_SQ_A(ntryL,G0H32(1),wf8(:,32),G0H4(72),ngPbt,m3h8x4(:,365),heltab2x32(:,:,657))
  call Hloop_Q_A(ntryL,G0H4(72),25,nMB,G1H4(180),n2h4(269))
  Gcoeff(:)%j = (c(1)*M(1,:)%j) * den(37)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(690),h0tab(:,690),[25,6],[nMT,0],2,2,wf8(:,32),wf4(:,10))
  call Hloop_VQ_A(ntryL,G0H32(1),wf8(:,32),G0H4(34),m3h8x4(:,366),heltab2x32(:,:,658))
  call Hloop_Q_A(ntryL,G0H4(34),25,nMT,G1H4(119),n2h4(270))
  Gcoeff(:)%j = (c(2)*M(1,:)%j) * den(37)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(691),h0tab(:,691),[25,6],[nMT,nMZ],2,2,wf8(:,32),wf4(:,10))
  call Hloop_ZQ_A(ntryL,G0H32(1),wf8(:,32),G0H4(32),ngZu,m3h8x4(:,367),heltab2x32(:,:,659))
  call Hloop_Q_A(ntryL,G0H4(32),25,nMT,G1H4(95),n2h4(271))
  Gcoeff(:)%j = (c(9)*M(1,:)%j) * den(37)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(692),h0tab(:,692),[25,6],[nMB,nMW],2,2,wf8(:,32),wf4(:,10))
  call Hloop_WQ_A(ntryL,G0H32(1),wf8(:,32),G0H4(30),m3h8x4(:,368),heltab2x32(:,:,660))
  call Hloop_Q_A(ntryL,G0H4(30),25,nMB,G1H4(59),n2h4(272))
  Gcoeff(:)%j = (-(c(24)*M(1,:)%j)) * den(35)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(693),h0tab(:,693),[17,14],[nMH,nMT],2,2,wf4(:,12),wf8(:,31))
  call Hloop_AQ_S(ntryL,G0H32(1),wf4(:,12),G0H8(30),ngH,m3h4x8(:,123),heltab2x32(:,:,661))
  Gcoeff(:)%j = (c(24)*M(1,:)%j) * den(35)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(694),h0tab(:,694),[17,14],[nMZ,nMT],2,2,wf4(:,12),wf8(:,31))
  call Hloop_AQ_S(ntryL,G0H32(1),wf4(:,12),G0H8(1),ngX,m3h4x8(:,124),heltab2x32(:,:,662))
  Gcoeff(:)%j = (c(18)*M(1,:)%j) * den(35)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(695),h0tab(:,695),[17,14],[nMW,nMB],2,2,wf4(:,12),wf8(:,31))
  call Hloop_AQ_S(ntryL,G0H32(1),wf4(:,12),G0H8(2),ngPbt,m3h4x8(:,125),heltab2x32(:,:,663))
  Gcoeff(:)%j = (c(1)*M(1,:)%j) * den(35)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(696),h0tab(:,696),[17,14],[0,nMT],2,2,wf4(:,12),wf8(:,31))
  call Hloop_AQ_V(ntryL,G0H32(1),wf4(:,12),G0H8(3),m3h4x8(:,126),heltab2x32(:,:,664))
  Gcoeff(:)%j = (c(2)*M(1,:)%j) * den(35)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(697),h0tab(:,697),[17,14],[nMZ,nMT],2,2,wf4(:,12),wf8(:,31))
  call Hloop_AQ_Z(ntryL,G0H32(1),wf4(:,12),G0H8(11),ngZu,m3h4x8(:,127),heltab2x32(:,:,665))
  Gcoeff(:)%j = (c(9)*M(1,:)%j) * den(35)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(698),h0tab(:,698),[17,14],[nMW,nMB],2,2,wf4(:,12),wf8(:,31))
  call Hloop_AQ_W(ntryL,G0H32(1),wf4(:,12),G0H8(12),m3h4x8(:,128),heltab2x32(:,:,666))
  Gcoeff(:)%j = (-(c(24)*M(1,:)%j)) * den(41)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(699),h0tab(:,699),[18,13],[nMH,nMT],2,2,wf4(:,6),wf8(:,35))
  call Hloop_QA_S(ntryL,G0H32(1),wf4(:,6),G0H8(13),ngH,m3h4x8(:,129),heltab2x32(:,:,667))
  Gcoeff(:)%j = (c(24)*M(1,:)%j) * den(41)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(700),h0tab(:,700),[18,13],[nMZ,nMT],2,2,wf4(:,6),wf8(:,35))
  call Hloop_QA_S(ntryL,G0H32(1),wf4(:,6),G0H8(4),ngX,m3h4x8(:,130),heltab2x32(:,:,668))
  Gcoeff(:)%j = (c(18)*M(1,:)%j) * den(41)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(701),h0tab(:,701),[18,13],[nMW,nMB],2,2,wf4(:,6),wf8(:,35))
  call Hloop_QA_S(ntryL,G0H32(1),wf4(:,6),G0H8(5),ngPtb,m3h4x8(:,131),heltab2x32(:,:,669))
  Gcoeff(:)%j = (c(1)*M(1,:)%j) * den(41)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(702),h0tab(:,702),[18,13],[0,nMT],2,2,wf4(:,6),wf8(:,35))
  call Hloop_QA_V(ntryL,G0H32(1),wf4(:,6),G0H8(6),m3h4x8(:,132),heltab2x32(:,:,670))
  Gcoeff(:)%j = (c(2)*M(1,:)%j) * den(41)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(703),h0tab(:,703),[18,13],[nMZ,nMT],2,2,wf4(:,6),wf8(:,35))
  call Hloop_QA_Z(ntryL,G0H32(1),wf4(:,6),G0H8(8),ngZu,m3h4x8(:,133),heltab2x32(:,:,671))
  Gcoeff(:)%j = (c(9)*M(1,:)%j) * den(41)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(704),h0tab(:,704),[18,13],[nMW,nMB],2,2,wf4(:,6),wf8(:,35))
  call Hloop_QA_W(ntryL,G0H32(1),wf4(:,6),G0H8(9),m3h4x8(:,134),heltab2x32(:,:,672))
  Gcoeff(:)%j = (-(c(24)*M(1,:)%j)) * den(39)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(705),h0tab(:,705),[22,9],[nMT,nMH],2,2,wf8(:,34),wf4(:,9))
  call Hloop_SA_Q(ntryL,G0H32(1),wf8(:,34),G0H4(28),ngH,m3h8x4(:,369),heltab2x32(:,:,673))
  call Hloop_A_Q(ntryL,G0H4(28),22,nMT,G1H4(118),n2h4(273))
  Gcoeff(:)%j = (c(24)*M(1,:)%j) * den(39)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(706),h0tab(:,706),[22,9],[nMT,nMZ],2,2,wf8(:,34),wf4(:,9))
  call Hloop_SA_Q(ntryL,G0H32(1),wf8(:,34),G0H4(79),ngX,m3h8x4(:,370),heltab2x32(:,:,674))
  call Hloop_A_Q(ntryL,G0H4(79),22,nMT,G1H4(10),n2h4(274))
  Gcoeff(:)%j = (c(18)*M(1,:)%j) * den(39)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(707),h0tab(:,707),[22,9],[nMB,nMW],2,2,wf8(:,34),wf4(:,9))
  call Hloop_SA_Q(ntryL,G0H32(1),wf8(:,34),G0H4(35),ngPtb,m3h8x4(:,371),heltab2x32(:,:,675))
  call Hloop_A_Q(ntryL,G0H4(35),22,nMB,G1H4(153),n2h4(275))
  Gcoeff(:)%j = (c(1)*M(1,:)%j) * den(39)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(708),h0tab(:,708),[22,9],[nMT,0],2,2,wf8(:,34),wf4(:,9))
  call Hloop_VA_Q(ntryL,G0H32(1),wf8(:,34),G0H4(80),m3h8x4(:,372),heltab2x32(:,:,676))
  call Hloop_A_Q(ntryL,G0H4(80),22,nMT,G1H4(186),n2h4(276))
  Gcoeff(:)%j = (c(2)*M(1,:)%j) * den(39)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(709),h0tab(:,709),[22,9],[nMT,nMZ],2,2,wf8(:,34),wf4(:,9))
  call Hloop_ZA_Q(ntryL,G0H32(1),wf8(:,34),G0H4(36),ngZu,m3h8x4(:,373),heltab2x32(:,:,677))
  call Hloop_A_Q(ntryL,G0H4(36),22,nMT,G1H4(120),n2h4(277))
  Gcoeff(:)%j = (c(9)*M(1,:)%j) * den(39)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(710),h0tab(:,710),[22,9],[nMB,nMW],2,2,wf8(:,34),wf4(:,9))
  call Hloop_WA_Q(ntryL,G0H32(1),wf8(:,34),G0H4(87),m3h8x4(:,374),heltab2x32(:,:,678))
  call Hloop_A_Q(ntryL,G0H4(87),22,nMB,G1H4(96),n2h4(278))
  Gcoeff(:)%j = (-(c(24)*M(1,:)%j)) * den(45)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(711),h0tab(:,711),[21,10],[nMT,nMH],2,2,wf8(:,38),wf4(:,4))
  call Hloop_SQ_A(ntryL,G0H32(1),wf8(:,38),G0H4(85),ngH,m3h8x4(:,375),heltab2x32(:,:,679))
  call Hloop_Q_A(ntryL,G0H4(85),21,nMT,G1H4(55),n2h4(279))
  Gcoeff(:)%j = (c(24)*M(1,:)%j) * den(45)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(712),h0tab(:,712),[21,10],[nMT,nMZ],2,2,wf8(:,38),wf4(:,4))
  call Hloop_SQ_A(ntryL,G0H32(1),wf8(:,38),G0H4(43),ngX,m3h8x4(:,376),heltab2x32(:,:,680))
  call Hloop_Q_A(ntryL,G0H4(43),21,nMT,G1H4(109),n2h4(280))
  Gcoeff(:)%j = (c(18)*M(1,:)%j) * den(45)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(713),h0tab(:,713),[21,10],[nMB,nMW],2,2,wf8(:,38),wf4(:,4))
  call Hloop_SQ_A(ntryL,G0H32(1),wf8(:,38),G0H4(41),ngPbt,m3h8x4(:,377),heltab2x32(:,:,681))
  call Hloop_Q_A(ntryL,G0H4(41),21,nMB,G1H4(2),n2h4(281))
  Gcoeff(:)%j = (c(1)*M(1,:)%j) * den(45)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(714),h0tab(:,714),[21,10],[nMT,0],2,2,wf8(:,38),wf4(:,4))
  call Hloop_VQ_A(ntryL,G0H32(1),wf8(:,38),G0H4(88),m3h8x4(:,378),heltab2x32(:,:,682))
  call Hloop_Q_A(ntryL,G0H4(88),21,nMT,G1H4(53),n2h4(282))
  Gcoeff(:)%j = (c(2)*M(1,:)%j) * den(45)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(715),h0tab(:,715),[21,10],[nMT,nMZ],2,2,wf8(:,38),wf4(:,4))
  call Hloop_ZQ_A(ntryL,G0H32(1),wf8(:,38),G0H4(86),ngZu,m3h8x4(:,379),heltab2x32(:,:,683))
  call Hloop_Q_A(ntryL,G0H4(86),21,nMT,G1H4(223),n2h4(283))
  Gcoeff(:)%j = (c(9)*M(1,:)%j) * den(45)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(716),h0tab(:,716),[21,10],[nMB,nMW],2,2,wf8(:,38),wf4(:,4))
  call Hloop_WQ_A(ntryL,G0H32(1),wf8(:,38),G0H4(44),m3h8x4(:,380),heltab2x32(:,:,684))
  call Hloop_Q_A(ntryL,G0H4(44),21,nMB,G1H4(183),n2h4(284))
  Gcoeff(:)%j = (-(c(24)*M(1,:)%j)) * den(43)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(717),h0tab(:,717),[17,14],[nMH,nMT],2,2,wf4(:,12),wf8(:,37))
  call Hloop_AQ_S(ntryL,G0H32(1),wf4(:,12),G0H8(10),ngH,m3h4x8(:,135),heltab2x32(:,:,685))
  Gcoeff(:)%j = (c(24)*M(1,:)%j) * den(43)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(718),h0tab(:,718),[17,14],[nMZ,nMT],2,2,wf4(:,12),wf8(:,37))
  call Hloop_AQ_S(ntryL,G0H32(1),wf4(:,12),G0H8(14),ngX,m3h4x8(:,136),heltab2x32(:,:,686))
  Gcoeff(:)%j = (c(18)*M(1,:)%j) * den(43)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(719),h0tab(:,719),[17,14],[nMW,nMB],2,2,wf4(:,12),wf8(:,37))
  call Hloop_AQ_S(ntryL,G0H32(1),wf4(:,12),G0H8(15),ngPbt,m3h4x8(:,137),heltab2x32(:,:,687))
  Gcoeff(:)%j = (c(1)*M(1,:)%j) * den(43)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(720),h0tab(:,720),[17,14],[0,nMT],2,2,wf4(:,12),wf8(:,37))
  call Hloop_AQ_V(ntryL,G0H32(1),wf4(:,12),G0H8(16),m3h4x8(:,138),heltab2x32(:,:,688))
  Gcoeff(:)%j = (c(2)*M(1,:)%j) * den(43)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(721),h0tab(:,721),[17,14],[nMZ,nMT],2,2,wf4(:,12),wf8(:,37))
  call Hloop_AQ_Z(ntryL,G0H32(1),wf4(:,12),G0H8(18),ngZu,m3h4x8(:,139),heltab2x32(:,:,689))
  Gcoeff(:)%j = (c(9)*M(1,:)%j) * den(43)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(722),h0tab(:,722),[17,14],[nMW,nMB],2,2,wf4(:,12),wf8(:,37))
  call Hloop_AQ_W(ntryL,G0H32(1),wf4(:,12),G0H8(19),m3h4x8(:,140),heltab2x32(:,:,690))
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G0H2(12),[G0H2(11),G0H2(10),G0H2(9),G0H2(4),G0H2(3),G0H2(2) &
    ,G0H2(1)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G0H2(14),[G0H2(13),G0H2(6),G0H2(5)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G0H2(16),[G0H2(15),G0H2(8),G0H2(7)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G0H2(28),[G0H2(27),G0H2(26),G0H2(25),G0H2(20),G0H2(19) &
    ,G0H2(18),G0H2(17)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G0H2(30),[G0H2(29),G0H2(22),G0H2(21)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G0H2(32),[G0H2(31),G0H2(24),G0H2(23)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(162),[G1H4(135),G1H4(29),G1H4(67),G0H4(6),G0H4(2)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(68),[G1H4(110),G1H4(171),G1H4(75),G0H4(7),G0H4(1)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(55),[G1H4(142)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(109),[G1H4(14)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(2),[G1H4(177)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(53),[G1H4(141)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(223),[G1H4(163)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(183),[G1H4(113)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(114),[G1H4(84)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(90),[G1H4(36)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(37),[G1H4(81)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(13),[G1H4(195)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(201),[G1H4(147)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(154),[G1H4(164)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(1),[G1H4(170)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(50),[G1H4(115)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(180),[G1H4(91)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(119),[G1H4(35)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(95),[G1H4(17)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(59),[G1H4(3)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(118),[G1H4(148)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(10),[G1H4(176)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(153),[G1H4(116)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(186),[G1H4(92)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(120),[G1H4(166)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(96),[G1H4(18)])
  call Hcheck_last_SV_V(ntryL,l_switch,G0H2(12),ex3(:),G0tensor(1),m3h2x1(:,709),heltab2x2(:,:,709))
  call Hcheck_last_TV_S(ntryL,l_switch,G0H2(14),27,ex3(:),4,G1tensor(126),m3h2x1(:,710),heltab2x2(:,:,710))
  call Hcheck_last_UV_W(ntryL,l_switch,G0H2(16),27,ex3(:),4,G1tensor(15),m3h2x1(:,711),heltab2x2(:,:,711))
  call Hcheck_last_SV_V(ntryL,l_switch,G0H2(28),ex4(:),G0tensor(31),m3h2x1(:,712),heltab2x2(:,:,712))
  call Hcheck_last_TV_S(ntryL,l_switch,G0H2(30),23,ex4(:),8,G1tensor(152),m3h2x1(:,713),heltab2x2(:,:,713))
  call Hcheck_last_UV_W(ntryL,l_switch,G0H2(32),23,ex4(:),8,G1tensor(168),m3h2x1(:,714),heltab2x2(:,:,714))
  call Hcheck_last_SVV_S(ntryL,l_switch,G1H4(162),ex4(:),ex3(:),G1tensor(11),m4h2x2x1(:,5),heltab3x4(:,:,5))
  call Hcheck_last_VWW_V(ntryL,l_switch,G1H4(68),ex4(:),ex3(:),G1tensor(83),m4h2x2x1(:,6),heltab3x4(:,:,6))
  call Hcheck_last_QA_S(ntryL,l_switch,G1H4(55),wf4(:,4),G1tensor(17),ngH,m3h4x1(:,109),heltab2x4(:,:,449))
  call Hcheck_last_QA_S(ntryL,l_switch,G1H4(109),wf4(:,4),G1tensor(29),ngX,m3h4x1(:,110),heltab2x4(:,:,450))
  call Hcheck_last_QA_S(ntryL,l_switch,G1H4(2),wf4(:,4),G1tensor(112),ngPtb,m3h4x1(:,111),heltab2x4(:,:,451))
  call Hcheck_last_QA_V(ntryL,l_switch,G1H4(53),wf4(:,4),G1tensor(45),m3h4x1(:,112),heltab2x4(:,:,452))
  call Hcheck_last_QA_Z(ntryL,l_switch,G1H4(223),wf4(:,4),G1tensor(161),ngZu,m3h4x1(:,113),heltab2x4(:,:,453))
  call Hcheck_last_QA_W(ntryL,l_switch,G1H4(183),wf4(:,4),G1tensor(70),m3h4x1(:,114),heltab2x4(:,:,454))
  call Hcheck_last_AQ_S(ntryL,l_switch,G1H4(114),wf4(:,3),G1tensor(154),ngH,m3h4x1(:,115),heltab2x4(:,:,455))
  call Hcheck_last_AQ_S(ntryL,l_switch,G1H4(90),wf4(:,3),G1tensor(88),ngX,m3h4x1(:,116),heltab2x4(:,:,456))
  call Hcheck_last_AQ_S(ntryL,l_switch,G1H4(37),wf4(:,3),G1tensor(148),ngPbt,m3h4x1(:,117),heltab2x4(:,:,457))
  call Hcheck_last_AQ_V(ntryL,l_switch,G1H4(13),wf4(:,3),G1tensor(107),m3h4x1(:,118),heltab2x4(:,:,458))
  call Hcheck_last_AQ_Z(ntryL,l_switch,G1H4(201),wf4(:,3),G1tensor(123),ngZu,m3h4x1(:,119),heltab2x4(:,:,459))
  call Hcheck_last_AQ_W(ntryL,l_switch,G1H4(154),wf4(:,3),G1tensor(135),m3h4x1(:,120),heltab2x4(:,:,460))
  call Hloop_SQ_A(ntryL,G0H8(23),wf8(:,26),G0H1(1),ngH,m3h8x1(:,25),heltab2x8(:,:,261))
  call Hcheck_last_Q_A(ntryL,l_switch,G0H1(1),31,nMT,G1tensor(179),n2h1(753))
  call Hloop_SQ_A(ntryL,G0H8(24),wf8(:,26),G0H1(1),ngX,m3h8x1(:,26),heltab2x8(:,:,262))
  call Hcheck_last_Q_A(ntryL,l_switch,G0H1(1),31,nMT,G1tensor(165),n2h1(754))
  call Hloop_SQ_A(ntryL,G0H8(25),wf8(:,26),G0H1(1),ngPbt,m3h8x1(:,27),heltab2x8(:,:,263))
  call Hcheck_last_Q_A(ntryL,l_switch,G0H1(1),31,nMB,G1tensor(181),n2h1(755))
  call Hloop_VQ_A(ntryL,G0H8(26),wf8(:,26),G0H1(1),m3h8x1(:,28),heltab2x8(:,:,264))
  call Hcheck_last_Q_A(ntryL,l_switch,G0H1(1),31,nMT,G1tensor(186),n2h1(756))
  call Hloop_ZQ_A(ntryL,G0H8(28),wf8(:,26),G0H1(1),ngZu,m3h8x1(:,29),heltab2x8(:,:,265))
  call Hcheck_last_Q_A(ntryL,l_switch,G0H1(1),31,nMT,G1tensor(191),n2h1(757))
  call Hloop_WQ_A(ntryL,G0H8(29),wf8(:,26),G0H1(1),m3h8x1(:,30),heltab2x8(:,:,266))
  call Hcheck_last_Q_A(ntryL,l_switch,G0H1(1),31,nMB,G1tensor(196),n2h1(758))
  call Hcheck_last_QA_S(ntryL,l_switch,G1H4(1),wf4(:,10),G1tensor(201),ngH,m3h4x1(:,121),heltab2x4(:,:,461))
  call Hcheck_last_QA_S(ntryL,l_switch,G1H4(50),wf4(:,10),G1tensor(206),ngX,m3h4x1(:,122),heltab2x4(:,:,462))
  call Hcheck_last_QA_S(ntryL,l_switch,G1H4(180),wf4(:,10),G1tensor(211),ngPtb,m3h4x1(:,123),heltab2x4(:,:,463))
  call Hcheck_last_QA_V(ntryL,l_switch,G1H4(119),wf4(:,10),G1tensor(216),m3h4x1(:,124),heltab2x4(:,:,464))
  call Hcheck_last_QA_Z(ntryL,l_switch,G1H4(95),wf4(:,10),G1tensor(221),ngZu,m3h4x1(:,125),heltab2x4(:,:,465))
  call Hcheck_last_QA_W(ntryL,l_switch,G1H4(59),wf4(:,10),G1tensor(226),m3h4x1(:,126),heltab2x4(:,:,466))
  call Hcheck_last_AQ_S(ntryL,l_switch,G1H4(118),wf4(:,9),G1tensor(231),ngH,m3h4x1(:,127),heltab2x4(:,:,467))
  call Hcheck_last_AQ_S(ntryL,l_switch,G1H4(10),wf4(:,9),G1tensor(236),ngX,m3h4x1(:,128),heltab2x4(:,:,468))
  call Hcheck_last_AQ_S(ntryL,l_switch,G1H4(153),wf4(:,9),G1tensor(241),ngPbt,m3h4x1(:,129),heltab2x4(:,:,469))
  call Hcheck_last_AQ_V(ntryL,l_switch,G1H4(186),wf4(:,9),G1tensor(246),m3h4x1(:,130),heltab2x4(:,:,470))
  call Hcheck_last_AQ_Z(ntryL,l_switch,G1H4(120),wf4(:,9),G1tensor(251),ngZu,m3h4x1(:,131),heltab2x4(:,:,471))
  call Hcheck_last_AQ_W(ntryL,l_switch,G1H4(96),wf4(:,9),G1tensor(256),m3h4x1(:,132),heltab2x4(:,:,472))
  call Hloop_SA_Q(ntryL,G0H8(30),wf8(:,31),G0H1(1),ngH,m3h8x1(:,31),heltab2x8(:,:,267))
  call Hcheck_last_A_Q(ntryL,l_switch,G0H1(1),31,nMT,G1tensor(261),n2h1(759))
  call Hloop_SA_Q(ntryL,G0H8(1),wf8(:,31),G0H1(1),ngX,m3h8x1(:,32),heltab2x8(:,:,268))
  call Hcheck_last_A_Q(ntryL,l_switch,G0H1(1),31,nMT,G1tensor(266),n2h1(760))
  call Hloop_SA_Q(ntryL,G0H8(2),wf8(:,31),G0H1(1),ngPtb,m3h8x1(:,33),heltab2x8(:,:,269))
  call Hcheck_last_A_Q(ntryL,l_switch,G0H1(1),31,nMB,G1tensor(271),n2h1(761))
  call Hloop_VA_Q(ntryL,G0H8(3),wf8(:,31),G0H1(1),m3h8x1(:,34),heltab2x8(:,:,270))
  call Hcheck_last_A_Q(ntryL,l_switch,G0H1(1),31,nMT,G1tensor(276),n2h1(762))
  call Hloop_ZA_Q(ntryL,G0H8(11),wf8(:,31),G0H1(1),ngZu,m3h8x1(:,35),heltab2x8(:,:,271))
  call Hcheck_last_A_Q(ntryL,l_switch,G0H1(1),31,nMT,G1tensor(281),n2h1(763))
  call Hloop_WA_Q(ntryL,G0H8(12),wf8(:,31),G0H1(1),m3h8x1(:,36),heltab2x8(:,:,272))
  call Hcheck_last_A_Q(ntryL,l_switch,G0H1(1),31,nMB,G1tensor(286),n2h1(764))
  call Hloop_SQ_A(ntryL,G0H8(13),wf8(:,35),G0H1(1),ngH,m3h8x1(:,37),heltab2x8(:,:,273))
  call Hcheck_last_Q_A(ntryL,l_switch,G0H1(1),31,nMT,G1tensor(291),n2h1(765))
  call Hloop_SQ_A(ntryL,G0H8(4),wf8(:,35),G0H1(1),ngX,m3h8x1(:,38),heltab2x8(:,:,274))
  call Hcheck_last_Q_A(ntryL,l_switch,G0H1(1),31,nMT,G1tensor(296),n2h1(766))
  call Hloop_SQ_A(ntryL,G0H8(5),wf8(:,35),G0H1(1),ngPbt,m3h8x1(:,39),heltab2x8(:,:,275))
  call Hcheck_last_Q_A(ntryL,l_switch,G0H1(1),31,nMB,G1tensor(301),n2h1(767))
  call Hloop_VQ_A(ntryL,G0H8(6),wf8(:,35),G0H1(1),m3h8x1(:,40),heltab2x8(:,:,276))
  call Hcheck_last_Q_A(ntryL,l_switch,G0H1(1),31,nMT,G1tensor(306),n2h1(768))
  call Hloop_ZQ_A(ntryL,G0H8(8),wf8(:,35),G0H1(1),ngZu,m3h8x1(:,41),heltab2x8(:,:,277))
  call Hcheck_last_Q_A(ntryL,l_switch,G0H1(1),31,nMT,G1tensor(311),n2h1(769))
  call Hloop_WQ_A(ntryL,G0H8(9),wf8(:,35),G0H1(1),m3h8x1(:,42),heltab2x8(:,:,278))
  call Hcheck_last_Q_A(ntryL,l_switch,G0H1(1),31,nMB,G1tensor(316),n2h1(770))
  call Hloop_SA_Q(ntryL,G0H8(10),wf8(:,37),G0H1(1),ngH,m3h8x1(:,43),heltab2x8(:,:,279))
  call Hcheck_last_A_Q(ntryL,l_switch,G0H1(1),31,nMT,G1tensor(321),n2h1(771))
  call Hloop_SA_Q(ntryL,G0H8(14),wf8(:,37),G0H1(1),ngX,m3h8x1(:,44),heltab2x8(:,:,280))
  call Hcheck_last_A_Q(ntryL,l_switch,G0H1(1),31,nMT,G1tensor(326),n2h1(772))
  call Hloop_SA_Q(ntryL,G0H8(15),wf8(:,37),G0H1(1),ngPtb,m3h8x1(:,45),heltab2x8(:,:,281))
  call Hcheck_last_A_Q(ntryL,l_switch,G0H1(1),31,nMB,G1tensor(331),n2h1(773))
  call Hloop_VA_Q(ntryL,G0H8(16),wf8(:,37),G0H1(1),m3h8x1(:,46),heltab2x8(:,:,282))
  call Hcheck_last_A_Q(ntryL,l_switch,G0H1(1),31,nMT,G1tensor(336),n2h1(774))
  call Hloop_ZA_Q(ntryL,G0H8(18),wf8(:,37),G0H1(1),ngZu,m3h8x1(:,47),heltab2x8(:,:,283))
  call Hcheck_last_A_Q(ntryL,l_switch,G0H1(1),31,nMT,G1tensor(341),n2h1(775))
  call Hloop_WA_Q(ntryL,G0H8(19),wf8(:,37),G0H1(1),m3h8x1(:,48),heltab2x8(:,:,284))
  call Hcheck_last_A_Q(ntryL,l_switch,G0H1(1),31,nMB,G1tensor(346),n2h1(776))
  call ol_merge_tensors(G0tensor(839),[G0tensor(833),G0tensor(827),G0tensor(822),G0tensor(816),G0tensor(810),G0tensor(794) &
    ,G0tensor(782),G0tensor(776),G0tensor(748),G0tensor(726),G0tensor(721),G0tensor(715),G0tensor(710),G0tensor(676),G0tensor(573) &
    ,G0tensor(561),G0tensor(549),G0tensor(328),G0tensor(284),G0tensor(329),G0tensor(444),G0tensor(244),G0tensor(123),G0tensor(326) &
    ,G0tensor(266),G0tensor(236),G0tensor(96),G0tensor(36),G0tensor(6)])
  call ol_merge_tensors(G0tensor(377),[G0tensor(450),G0tensor(42),G0tensor(351),G0tensor(11)])
  call ol_merge_tensors(G1tensor(154),[G0tensor(233),G0tensor(62),G0tensor(16)])
  call ol_merge_tensors(G0tensor(830),[G0tensor(813),G0tensor(779),G0tensor(756),G0tensor(718),G0tensor(685),G0tensor(581) &
    ,G0tensor(558),G0tensor(514),G0tensor(353),G0tensor(364),G0tensor(273),G0tensor(283),G0tensor(73),G0tensor(265),G0tensor(180) &
    ,G0tensor(90),G0tensor(189),G0tensor(210),G0tensor(28),G0tensor(72),G0tensor(103),G0tensor(371),G0tensor(251),G0tensor(141) &
    ,G0tensor(21)])
  call ol_merge_tensors(G0tensor(842),[G0tensor(837),G0tensor(831),G0tensor(825),G0tensor(820),G0tensor(814),G0tensor(796) &
    ,G0tensor(784),G0tensor(778),G0tensor(773),G0tensor(761),G0tensor(755),G0tensor(750),G0tensor(728),G0tensor(723),G0tensor(717) &
    ,G0tensor(712),G0tensor(707),G0tensor(690),G0tensor(684),G0tensor(679),G0tensor(669),G0tensor(598),G0tensor(586),G0tensor(580) &
    ,G0tensor(575),G0tensor(563),G0tensor(557),G0tensor(499),G0tensor(433),G0tensor(494),G0tensor(403),G0tensor(384),G0tensor(418) &
    ,G0tensor(334),G0tensor(448),G0tensor(454),G0tensor(314),G0tensor(374),G0tensor(264),G0tensor(253),G0tensor(522),G0tensor(154) &
    ,G0tensor(149),G0tensor(382),G0tensor(372),G0tensor(337),G0tensor(322),G0tensor(54),G0tensor(45),G0tensor(55),G0tensor(228) &
    ,G0tensor(460),G0tensor(455),G0tensor(445),G0tensor(170),G0tensor(470),G0tensor(109),G0tensor(355),G0tensor(230),G0tensor(340) &
    ,G0tensor(80),G0tensor(395),G0tensor(9),G0tensor(250),G0tensor(482),G0tensor(120),G0tensor(205),G0tensor(553),G0tensor(237) &
    ,G0tensor(137),G0tensor(102),G0tensor(157),G0tensor(77),G0tensor(142),G0tensor(456),G0tensor(396),G0tensor(366),G0tensor(341) &
    ,G0tensor(286),G0tensor(256),G0tensor(226),G0tensor(166),G0tensor(136),G0tensor(111),G0tensor(56),G0tensor(26)])
  call ol_merge_tensors(G0tensor(209),[G0tensor(465),G0tensor(97),G0tensor(381),G0tensor(41)])
  call ol_merge_tensors(G1tensor(123),[G1tensor(88),G0tensor(243),G0tensor(537),G0tensor(46)])
  call ol_merge_tensors(G0tensor(836),[G0tensor(819),G0tensor(785),G0tensor(762),G0tensor(729),G0tensor(691),G0tensor(587) &
    ,G0tensor(564),G0tensor(429),G0tensor(393),G0tensor(369),G0tensor(248),G0tensor(144),G0tensor(184),G0tensor(515),G0tensor(198) &
    ,G0tensor(397),G0tensor(100),G0tensor(300),G0tensor(215),G0tensor(132),G0tensor(117),G0tensor(401),G0tensor(281),G0tensor(171) &
    ,G0tensor(51)])
  call ol_merge_tensors(G0tensor(788),[G0tensor(743),G0tensor(737),G0tensor(732),G0tensor(693),G0tensor(648),G0tensor(636) &
    ,G0tensor(567),G0tensor(323),G0tensor(299),G0tensor(63),G0tensor(197),G0tensor(296),G0tensor(66)])
  call ol_merge_tensors(G0tensor(373),[G0tensor(363),G0tensor(270),G0tensor(167),G0tensor(27),G0tensor(526),G0tensor(411) &
    ,G0tensor(71)])
  call ol_merge_tensors(G1tensor(135),[G1tensor(148),G0tensor(249),G0tensor(193),G0tensor(33),G0tensor(536),G0tensor(76)])
  call ol_merge_tensors(G0tensor(807),[G0tensor(801),G0tensor(791),G0tensor(768),G0tensor(740),G0tensor(702),G0tensor(664) &
    ,G0tensor(658),G0tensor(651),G0tensor(645),G0tensor(639),G0tensor(634),G0tensor(628),G0tensor(622),G0tensor(616),G0tensor(610) &
    ,G0tensor(604),G0tensor(593),G0tensor(570),G0tensor(463),G0tensor(484),G0tensor(438),G0tensor(555),G0tensor(507),G0tensor(293) &
    ,G0tensor(203),G0tensor(183),G0tensor(163),G0tensor(368),G0tensor(362),G0tensor(34),G0tensor(13),G0tensor(3),G0tensor(195) &
    ,G0tensor(442),G0tensor(225),G0tensor(19),G0tensor(8),G0tensor(422),G0tensor(235),G0tensor(79),G0tensor(305),G0tensor(43) &
    ,G0tensor(177),G0tensor(32),G0tensor(541),G0tensor(511),G0tensor(481),G0tensor(431),G0tensor(311),G0tensor(201) &
    ,G0tensor(81)])
  call ol_merge_tensors(G0tensor(808),[G0tensor(802),G0tensor(790),G0tensor(767),G0tensor(745),G0tensor(739),G0tensor(734) &
    ,G0tensor(701),G0tensor(696),G0tensor(674),G0tensor(663),G0tensor(657),G0tensor(652),G0tensor(646),G0tensor(640),G0tensor(633) &
    ,G0tensor(627),G0tensor(621),G0tensor(615),G0tensor(609),G0tensor(603),G0tensor(592),G0tensor(569),G0tensor(479),G0tensor(449) &
    ,G0tensor(504),G0tensor(308),G0tensor(458),G0tensor(545),G0tensor(223),G0tensor(477),G0tensor(437),G0tensor(402),G0tensor(104) &
    ,G0tensor(174),G0tensor(287),G0tensor(267),G0tensor(252),G0tensor(462),G0tensor(165),G0tensor(342),G0tensor(275),G0tensor(255) &
    ,G0tensor(129),G0tensor(412),G0tensor(99),G0tensor(385),G0tensor(58),G0tensor(542),G0tensor(182),G0tensor(207),G0tensor(552) &
    ,G0tensor(546),G0tensor(516),G0tensor(486),G0tensor(426),G0tensor(316),G0tensor(196),G0tensor(86)])
  call ol_merge_tensors(G0tensor(407),[G0tensor(25),G0tensor(222),G0tensor(441),G0tensor(101)])
  call ol_merge_tensors(G1tensor(107),[G0tensor(263),G0tensor(242),G0tensor(106)])
  call ol_merge_tensors(G0tensor(94),[G0tensor(335),G0tensor(60),G0tensor(241),G0tensor(121)])
  call ol_merge_tensors(G0tensor(394),[G0tensor(509),G0tensor(464),G0tensor(17),G0tensor(126)])
  call ol_merge_tensors(G0tensor(404),[G0tensor(354),G0tensor(44),G0tensor(29),G0tensor(451),G0tensor(391),G0tensor(361) &
    ,G0tensor(221),G0tensor(161),G0tensor(131)])
  call ol_merge_tensors(G0tensor(513),[G0tensor(350),G0tensor(295),G0tensor(271),G0tensor(151)])
  call ol_merge_tensors(G0tensor(409),[G0tensor(478),G0tensor(289),G0tensor(290),G0tensor(156)])
  call ol_merge_tensors(G0tensor(642),[G0tensor(347),G0tensor(118),G0tensor(199),G0tensor(496),G0tensor(466),G0tensor(301) &
    ,G0tensor(181)])
  call ol_merge_tensors(G0tensor(613),[G0tensor(607),G0tensor(601),G0tensor(439),G0tensor(388),G0tensor(339),G0tensor(50) &
    ,G0tensor(186)])
  call ol_merge_tensors(G0tensor(473),[G0tensor(348),G0tensor(312),G0tensor(380),G0tensor(421),G0tensor(191)])
  call ol_merge_tensors(G0tensor(367),[G0tensor(138),G0tensor(78),G0tensor(331),G0tensor(211)])
  call ol_merge_tensors(G0tensor(493),[G0tensor(399),G0tensor(309),G0tensor(390),G0tensor(216)])
  call ol_merge_tensors(G1tensor(201),[G0tensor(333),G0tensor(415),G0tensor(246)])
  call ol_merge_tensors(G1tensor(221),[G1tensor(206),G0tensor(498),G0tensor(145),G0tensor(276)])
  call ol_merge_tensors(G1tensor(226),[G1tensor(211),G0tensor(798),G0tensor(378),G0tensor(128),G0tensor(476),G0tensor(306)])
  call ol_merge_tensors(G1tensor(216),[G0tensor(424),G0tensor(168),G0tensor(336)])
  call ol_merge_tensors(G0tensor(577),[G0tensor(539),G0tensor(517),G0tensor(440),G0tensor(356)])
  call ol_merge_tensors(G0tensor(583),[G0tensor(560),G0tensor(527),G0tensor(20),G0tensor(386)])
  call ol_merge_tensors(G0tensor(661),[G0tensor(655),G0tensor(631),G0tensor(625),G0tensor(619),G0tensor(589),G0tensor(566) &
    ,G0tensor(540),G0tensor(520),G0tensor(416)])
  call ol_merge_tensors(G0tensor(595),[G0tensor(572),G0tensor(254),G0tensor(135),G0tensor(446)])
  call ol_merge_tensors(G1tensor(15),[G1tensor(126),G0tensor(1),G0tensor(805),G0tensor(618),G0tensor(600),G0tensor(303) &
    ,G0tensor(523),G0tensor(533),G0tensor(15),G0tensor(65),G0tensor(531),G0tensor(471)])
  call ol_merge_tensors(G1tensor(168),[G1tensor(152),G0tensor(31),G0tensor(799),G0tensor(624),G0tensor(606),G0tensor(208) &
    ,G0tensor(467),G0tensor(528),G0tensor(257),G0tensor(352),G0tensor(22),G0tensor(501)])
  call ol_merge_tensors(G1tensor(70),[G1tensor(112),G0tensor(804),G0tensor(637),G0tensor(612),G0tensor(452),G0tensor(506)])
  call ol_merge_tensors(G1tensor(256),[G1tensor(241),G0tensor(649),G0tensor(630),G0tensor(497),G0tensor(14),G0tensor(37)])
  call ol_merge_tensors(G0tensor(775),[G0tensor(579),G0tensor(147),G0tensor(57)])
  call ol_merge_tensors(G0tensor(720),[G0tensor(519),G0tensor(139),G0tensor(425),G0tensor(410),G0tensor(538),G0tensor(107) &
    ,G0tensor(87),G0tensor(52)])
  call ol_merge_tensors(G0tensor(722),[G0tensor(668),G0tensor(125),G0tensor(510),G0tensor(495),G0tensor(435),G0tensor(360) &
    ,G0tensor(240),G0tensor(330),G0tensor(49),G0tensor(30),G0tensor(140),G0tensor(2),G0tensor(122),G0tensor(82),G0tensor(113)])
  call ol_merge_tensors(G0tensor(781),[G0tensor(585),G0tensor(127),G0tensor(92)])
  call ol_merge_tensors(G0tensor(787),[G0tensor(626),G0tensor(591),G0tensor(5),G0tensor(212),G0tensor(162)])
  call ol_merge_tensors(G0tensor(742),[G0tensor(632),G0tensor(614),G0tensor(483),G0tensor(119),G0tensor(192),G0tensor(23)])
  call ol_merge_tensors(G0tensor(744),[G0tensor(673),G0tensor(662),G0tensor(24),G0tensor(185),G0tensor(535),G0tensor(229) &
    ,G0tensor(169),G0tensor(68),G0tensor(53),G0tensor(187)])
  call ol_merge_tensors(G0tensor(793),[G0tensor(597),G0tensor(7),G0tensor(547)])
  call ol_merge_tensors(G0tensor(711),[G0tensor(678),G0tensor(115),G0tensor(10),G0tensor(178),G0tensor(320),G0tensor(39) &
    ,G0tensor(285),G0tensor(12)])
  call ol_merge_tensors(G1tensor(291),[G1tensor(179),G0tensor(716),G0tensor(683),G0tensor(40),G0tensor(472)])
  call ol_merge_tensors(G1tensor(311),[G1tensor(296),G1tensor(191),G1tensor(165),G0tensor(727),G0tensor(689),G0tensor(260) &
    ,G0tensor(492)])
  call ol_merge_tensors(G0tensor(733),[G0tensor(695),G0tensor(239),G0tensor(310),G0tensor(502)])
  call ol_merge_tensors(G1tensor(316),[G1tensor(301),G1tensor(196),G1tensor(181),G0tensor(738),G0tensor(700),G0tensor(432) &
    ,G0tensor(75),G0tensor(179),G0tensor(220)])
  call ol_merge_tensors(G1tensor(306),[G1tensor(186),G0tensor(749),G0tensor(706),G0tensor(400),G0tensor(70)])
  call ol_merge_tensors(G0tensor(714),[G0tensor(408),G0tensor(345),G0tensor(88)])
  call ol_merge_tensors(G0tensor(725),[G0tensor(419),G0tensor(108),G0tensor(98)])
  call ol_merge_tensors(G0tensor(736),[G0tensor(608),G0tensor(453),G0tensor(327),G0tensor(370),G0tensor(365)])
  call ol_merge_tensors(G0tensor(747),[G0tensor(503),G0tensor(475),G0tensor(375)])
  call ol_merge_tensors(G1tensor(321),[G1tensor(261),G0tensor(777),G0tensor(754),G0tensor(188),G0tensor(485)])
  call ol_merge_tensors(G1tensor(341),[G1tensor(326),G1tensor(281),G1tensor(266),G0tensor(783),G0tensor(760),G0tensor(200) &
    ,G0tensor(500)])
  call ol_merge_tensors(G1tensor(346),[G1tensor(331),G1tensor(286),G1tensor(271),G0tensor(789),G0tensor(766),G0tensor(656) &
    ,G0tensor(548),G0tensor(543),G0tensor(18),G0tensor(525)])
  call ol_merge_tensors(G1tensor(336),[G1tensor(276),G0tensor(795),G0tensor(772),G0tensor(297),G0tensor(105)])
  call ol_merge_tensors(G0tensor(698),[G0tensor(602),G0tensor(294),G0tensor(93),G0tensor(245),G0tensor(95)])
  call ol_merge_tensors(G0tensor(764),[G0tensor(620),G0tensor(568),G0tensor(148),G0tensor(277),G0tensor(4)])
  call ol_merge_tensors(G0tensor(666),[G0tensor(389),G0tensor(468),G0tensor(343),G0tensor(319),G0tensor(274),G0tensor(258) &
    ,G0tensor(234),G0tensor(214),G0tensor(159),G0tensor(143),G0tensor(124),G0tensor(83),G0tensor(64),G0tensor(302)])
  call ol_merge_tensors(G0tensor(671),[G0tensor(379),G0tensor(313),G0tensor(550),G0tensor(508),G0tensor(357),G0tensor(194)])
  call ol_merge_tensors(G0tensor(681),[G0tensor(434),G0tensor(74)])
  call ol_merge_tensors(G0tensor(687),[G0tensor(279),G0tensor(332)])
  call ol_merge_tensors(G0tensor(704),[G0tensor(324),G0tensor(224)])
  call ol_merge_tensors(G0tensor(752),[G0tensor(556),G0tensor(358)])
  call ol_merge_tensors(G0tensor(758),[G0tensor(562),G0tensor(204)])
  call ol_merge_tensors(G0tensor(770),[G0tensor(574),G0tensor(298)])
  call ol_merge_tensors(G1tensor(83),[G1tensor(11),G0tensor(654),G0tensor(643),G0tensor(487),G0tensor(447),G0tensor(158)])
  call ol_merge_tensors(G0tensor(660),[G0tensor(650),G0tensor(218),G0tensor(278),G0tensor(427)])
  call ol_merge_tensors(G0tensor(771),[G0tensor(759),G0tensor(753),G0tensor(709),G0tensor(705),G0tensor(688),G0tensor(682) &
    ,G0tensor(677),G0tensor(667),G0tensor(596),G0tensor(584),G0tensor(578),G0tensor(489),G0tensor(423),G0tensor(534) &
    ,G0tensor(488)])
  call ol_merge_tensors(G0tensor(765),[G0tensor(731),G0tensor(699),G0tensor(694),G0tensor(672),G0tensor(590),G0tensor(469) &
    ,G0tensor(524)])
  call ol_merge_tensors(G0tensor(806),[G0tensor(800),G0tensor(644),G0tensor(638)])
  call ol_merge_tensors(G1tensor(231),[G0tensor(811)])
  call ol_merge_tensors(G1tensor(251),[G1tensor(236),G0tensor(817)])
  call ol_merge_tensors(G1tensor(246),[G0tensor(823)])
  call ol_merge_tensors(G1tensor(17),[G0tensor(828)])
  call ol_merge_tensors(G1tensor(161),[G1tensor(29),G0tensor(834)])
  call ol_merge_tensors(G1tensor(45),[G0tensor(840)])
call TI_bubble_red(G1tensor(154),26,mass2set(:,1),G0tensor(61),M2L1R1,G0tensor(91),G0tensor(116))
call TI_bubble_red(G1tensor(123),26,mass2set(:,2),G0tensor(146),M2L1R1,G0tensor(176),G0tensor(206))
call TI_bubble_red(G1tensor(135),26,mass2set(:,3),G0tensor(231),M2L1R1,G0tensor(261),G0tensor(291))
call TI_bubble_red(G1tensor(107),26,mass2set(:,4),G0tensor(321),M2L1R1,G0tensor(346))
call TI_bubble_red(G1tensor(201),25,mass2set(:,1),G0tensor(376),M2L1R1,G0tensor(406),G0tensor(436))
call TI_bubble_red(G1tensor(221),25,mass2set(:,2),G0tensor(461),M2L1R1,G0tensor(491),G0tensor(521))
call TI_bubble_red(G1tensor(226),25,mass2set(:,3),G0tensor(551),M2L1R1,G0tensor(47),G0tensor(67))
call TI_bubble_red(G1tensor(216),25,mass2set(:,4),G0tensor(152),M2L1R1,G0tensor(133))
call TI_bubble_red(G1tensor(15),27,mass2set(:,5),G0tensor(112),M2L1R1,G0tensor(202))
call TI_bubble_red(G1tensor(168),23,mass2set(:,5),G0tensor(172),M2L1R1,G0tensor(217))
call TI_bubble_red(G1tensor(70),21,mass2set(:,3),G0tensor(227),M2L1R1,G0tensor(232),G0tensor(247))
call TI_bubble_red(G1tensor(256),22,mass2set(:,3),G0tensor(280),M2L1R1,G0tensor(110),G0tensor(38))
call TI_bubble_red(G1tensor(291),18,mass2set(:,6),G0tensor(48),M2L1R1,G0tensor(130),G0tensor(59))
call TI_bubble_red(G1tensor(311),18,mass2set(:,7),G0tensor(315),M2L1R1,G0tensor(69),G0tensor(325))
call TI_bubble_red(G1tensor(316),18,mass2set(:,8),G0tensor(405),M2L1R1,G0tensor(89),G0tensor(420))
call TI_bubble_red(G1tensor(306),18,mass2set(:,9),G0tensor(387),M2L1R1,G0tensor(150))
call TI_bubble_red(G1tensor(321),17,mass2set(:,6),G0tensor(155),M2L1R1,G0tensor(160),G0tensor(430))
call TI_bubble_red(G1tensor(341),17,mass2set(:,7),G0tensor(480),M2L1R1,G0tensor(490),G0tensor(190))
call TI_bubble_red(G1tensor(346),17,mass2set(:,8),G0tensor(505),M2L1R1,G0tensor(238),G0tensor(530))
call TI_bubble_red(G1tensor(336),17,mass2set(:,9),G0tensor(282),M2L1R1,G0tensor(35))
call TI_bubble_red(G1tensor(83),19,mass2set(:,5),G0tensor(317),M2L1R1,G0tensor(85))
call TI_bubble_red(G1tensor(231),22,mass2set(:,1),G0tensor(175),M2L1R1,G0tensor(262),G0tensor(554))
call TI_bubble_red(G1tensor(251),22,mass2set(:,2),G0tensor(272),M2L1R1,G0tensor(292),G0tensor(307))
call TI_bubble_red(G1tensor(246),22,mass2set(:,4),G0tensor(164),M2L1R1,G0tensor(518))
call TI_bubble_red(G1tensor(17),21,mass2set(:,1),G0tensor(84),M2L1R1,G0tensor(114),G0tensor(134))
call TI_bubble_red(G1tensor(161),21,mass2set(:,2),G0tensor(219),M2L1R1,G0tensor(392),G0tensor(153))
call TI_bubble_red(G1tensor(45),21,mass2set(:,4),G0tensor(417),M2L1R1,G0tensor(173))
  call ol_merge_tensors(G0tensor(114),[G0tensor(262),G0tensor(430),G0tensor(59),G0tensor(406),G0tensor(830),G0tensor(91)])
  call ol_merge_tensors(G0tensor(173),[G0tensor(153),G0tensor(134),G0tensor(518),G0tensor(307),G0tensor(554),G0tensor(35) &
    ,G0tensor(490),G0tensor(160),G0tensor(150),G0tensor(69),G0tensor(130),G0tensor(133),G0tensor(521),G0tensor(436),G0tensor(346) &
    ,G0tensor(206),G0tensor(842),G0tensor(116)])
  call ol_merge_tensors(G0tensor(392),[G0tensor(292),G0tensor(190),G0tensor(325),G0tensor(491),G0tensor(836),G0tensor(176)])
  call ol_merge_tensors(G0tensor(85),[G0tensor(530),G0tensor(420),G0tensor(110),G0tensor(232),G0tensor(217),G0tensor(202) &
    ,G0tensor(47),G0tensor(807),G0tensor(261)])
  call ol_merge_tensors(G0tensor(238),[G0tensor(89),G0tensor(38),G0tensor(247),G0tensor(67),G0tensor(808),G0tensor(291)])
  call ol_merge_tensors(T0sum(264),[G0tensor(839)])
  call ol_merge_tensors(T0sum(265),[G0tensor(377)])
  call ol_merge_tensors(T0sum(266),[G0tensor(61)])
  call ol_merge_tensors(T0sum(267),[G0tensor(114)])
  call ol_merge_tensors(T0sum(268),[G0tensor(173)])
  call ol_merge_tensors(T0sum(269),[G0tensor(209)])
  call ol_merge_tensors(T0sum(270),[G0tensor(146)])
  call ol_merge_tensors(T0sum(271),[G0tensor(392)])
  call ol_merge_tensors(T0sum(272),[G0tensor(788)])
  call ol_merge_tensors(T0sum(273),[G0tensor(373)])
  call ol_merge_tensors(T0sum(274),[G0tensor(231)])
  call ol_merge_tensors(T0sum(275),[G0tensor(85)])
  call ol_merge_tensors(T0sum(276),[G0tensor(238)])
  call ol_merge_tensors(T0sum(277),[G0tensor(407)])
  call ol_merge_tensors(T0sum(278),[G0tensor(321)])
  call ol_merge_tensors(T0sum(279),[G0tensor(94)])
  call ol_merge_tensors(T0sum(280),[G0tensor(394)])
  call ol_merge_tensors(T0sum(281),[G0tensor(404)])
  call ol_merge_tensors(T0sum(282),[G0tensor(513)])
  call ol_merge_tensors(T0sum(283),[G0tensor(409)])
  call ol_merge_tensors(T0sum(284),[G0tensor(642)])
  call ol_merge_tensors(T0sum(285),[G0tensor(613)])
  call ol_merge_tensors(T0sum(286),[G0tensor(473)])
  call ol_merge_tensors(T0sum(287),[G0tensor(367)])
  call ol_merge_tensors(T0sum(288),[G0tensor(493)])
  call ol_merge_tensors(T0sum(289),[G0tensor(376)])
  call ol_merge_tensors(T0sum(290),[G0tensor(461)])
  call ol_merge_tensors(T0sum(291),[G0tensor(551)])
  call ol_merge_tensors(T0sum(292),[G0tensor(152)])
  call ol_merge_tensors(T0sum(293),[G0tensor(577)])
  call ol_merge_tensors(T0sum(294),[G0tensor(583)])
  call ol_merge_tensors(T0sum(295),[G0tensor(661)])
  call ol_merge_tensors(T0sum(296),[G0tensor(595)])
  call ol_merge_tensors(T0sum(297),[G0tensor(112)])
  call ol_merge_tensors(T0sum(298),[G0tensor(172)])
  call ol_merge_tensors(T0sum(299),[G0tensor(227)])
  call ol_merge_tensors(T0sum(300),[G0tensor(280)])
  call ol_merge_tensors(T0sum(301),[G0tensor(775)])
  call ol_merge_tensors(T0sum(302),[G0tensor(720)])
  call ol_merge_tensors(T0sum(303),[G0tensor(722)])
  call ol_merge_tensors(T0sum(304),[G0tensor(781)])
  call ol_merge_tensors(T0sum(305),[G0tensor(787)])
  call ol_merge_tensors(T0sum(306),[G0tensor(742)])
  call ol_merge_tensors(T0sum(307),[G0tensor(744)])
  call ol_merge_tensors(T0sum(308),[G0tensor(793)])
  call ol_merge_tensors(T0sum(309),[G0tensor(711)])
  call ol_merge_tensors(T0sum(310),[G0tensor(48)])
  call ol_merge_tensors(T0sum(311),[G0tensor(315)])
  call ol_merge_tensors(T0sum(312),[G0tensor(733)])
  call ol_merge_tensors(T0sum(313),[G0tensor(405)])
  call ol_merge_tensors(T0sum(314),[G0tensor(387)])
  call ol_merge_tensors(T0sum(315),[G0tensor(714)])
  call ol_merge_tensors(T0sum(316),[G0tensor(725)])
  call ol_merge_tensors(T0sum(317),[G0tensor(736)])
  call ol_merge_tensors(T0sum(318),[G0tensor(747)])
  call ol_merge_tensors(T0sum(319),[G0tensor(155)])
  call ol_merge_tensors(T0sum(320),[G0tensor(480)])
  call ol_merge_tensors(T0sum(321),[G0tensor(505)])
  call ol_merge_tensors(T0sum(322),[G0tensor(282)])
  call ol_merge_tensors(T0sum(323),[G0tensor(698)])
  call ol_merge_tensors(T0sum(324),[G0tensor(764)])
  call ol_merge_tensors(T0sum(325),[G0tensor(666)])
  call ol_merge_tensors(T0sum(326),[G0tensor(671)])
  call ol_merge_tensors(T0sum(327),[G0tensor(681)])
  call ol_merge_tensors(T0sum(328),[G0tensor(687)])
  call ol_merge_tensors(T0sum(329),[G0tensor(704)])
  call ol_merge_tensors(T0sum(330),[G0tensor(752)])
  call ol_merge_tensors(T0sum(331),[G0tensor(758)])
  call ol_merge_tensors(T0sum(332),[G0tensor(770)])
  call ol_merge_tensors(T0sum(333),[G0tensor(317)])
  call ol_merge_tensors(T0sum(334),[G0tensor(660)])
  call ol_merge_tensors(T0sum(335),[G0tensor(771)])
  call ol_merge_tensors(T0sum(336),[G0tensor(765)])
  call ol_merge_tensors(T0sum(337),[G0tensor(806)])
  call ol_merge_tensors(T0sum(338),[G0tensor(175)])
  call ol_merge_tensors(T0sum(339),[G0tensor(812)])
  call ol_merge_tensors(T0sum(340),[G0tensor(272)])
  call ol_merge_tensors(T0sum(341),[G0tensor(818)])
  call ol_merge_tensors(T0sum(342),[G0tensor(164)])
  call ol_merge_tensors(T0sum(343),[G0tensor(824)])
  call ol_merge_tensors(T0sum(344),[G0tensor(84)])
  call ol_merge_tensors(T0sum(345),[G0tensor(829)])
  call ol_merge_tensors(T0sum(346),[G0tensor(219)])
  call ol_merge_tensors(T0sum(347),[G0tensor(835)])
  call ol_merge_tensors(T0sum(348),[G0tensor(417)])
  call ol_merge_tensors(T0sum(349),[G0tensor(841)])
  call ol_merge_tensors(T0sum(350),[G0tensor(844)])
  call ol_merge_tensors(T0sum(351),[G0tensor(845)])
  call ol_merge_tensors(T0sum(352),[G0tensor(846)])
  call ol_merge_tensors(T0sum(353),[G0tensor(847)])
  call ol_merge_tensors(T0sum(354),[G0tensor(849)])
  call ol_merge_tensors(T0sum(355),[G0tensor(850)])
  call ol_merge_tensors(T0sum(356),[G0tensor(851)])
  call ol_merge_tensors(T0sum(357),[G0tensor(852)])
  call ol_merge_tensors(T0sum(358),[G0tensor(854)])
  call ol_merge_tensors(T0sum(359),[G0tensor(855)])
  call ol_merge_tensors(T0sum(360),[G0tensor(856)])
  call ol_merge_tensors(T0sum(361),[G0tensor(857)])
  call ol_merge_tensors(T0sum(362),[G0tensor(859)])
  call ol_merge_tensors(T0sum(363),[G0tensor(860)])
  call ol_merge_tensors(T0sum(364),[G0tensor(861)])


! Compute scalar Master integrals 

  call compute_scalar_box([ 17, 21, 29 ],masses2_61,RedSet_4(9),ScalarBoxes(1))
  call compute_scalar_box([ 16, 21, 29 ],masses2_49,RedSet_4(10),ScalarBoxes(2))
  call compute_scalar_box([ 16, 17, 29 ],masses2_49,RedSet_4(11),ScalarBoxes(3))
  call compute_scalar_box([ 16, 17, 21 ],masses2_49,RedSet_4(7),ScalarBoxes(4))
  call compute_scalar_box([ 1, 5, 13 ],masses2_61,RedSet_4(12),ScalarBoxes(5))
  call compute_scalar_box([ 17, 25, 29 ],masses2_61,RedSet_4(13),ScalarBoxes(6))
  call compute_scalar_box([ 16, 25, 29 ],masses2_49,RedSet_4(14),ScalarBoxes(7))
  call compute_scalar_box([ 16, 17, 25 ],masses2_49,RedSet_4(8),ScalarBoxes(8))
  call compute_scalar_box([ 1, 9, 13 ],masses2_61,RedSet_4(15),ScalarBoxes(9))
  call compute_scalar_box([ 20, 21, 23 ],masses2_53,RedSet_4(16),ScalarBoxes(10))
  call compute_scalar_box([ 16, 21, 23 ],masses2_53,RedSet_4(17),ScalarBoxes(11))
  call compute_scalar_box([ 16, 20, 23 ],masses2_56,RedSet_4(18),ScalarBoxes(12))
  call compute_scalar_box([ 16, 20, 21 ],masses2_55,RedSet_4(1),ScalarBoxes(13))
  call compute_scalar_box([ 4, 5, 7 ],masses2_53,RedSet_4(19),ScalarBoxes(14))
  call compute_scalar_box([ 20, 21, 23 ],masses2_58,RedSet_4(16),ScalarBoxes(15))
  call compute_scalar_box([ 16, 21, 23 ],masses2_58,RedSet_4(17),ScalarBoxes(16))
  call compute_scalar_box([ 16, 20, 21 ],masses2_57,RedSet_4(1),ScalarBoxes(17))
  call compute_scalar_box([ 4, 5, 7 ],masses2_58,RedSet_4(19),ScalarBoxes(18))
  call compute_scalar_box([ 20, 21, 23 ],masses2_48,RedSet_4(16),ScalarBoxes(19))
  call compute_scalar_box([ 16, 21, 23 ],masses2_48,RedSet_4(17),ScalarBoxes(20))
  call compute_scalar_box([ 16, 20, 23 ],masses2_45,RedSet_4(18),ScalarBoxes(21))
  call compute_scalar_box([ 16, 20, 21 ],masses2_46,RedSet_4(1),ScalarBoxes(22))
  call compute_scalar_box([ 4, 5, 7 ],masses2_48,RedSet_4(19),ScalarBoxes(23))
  call compute_scalar_box([ 20, 21, 23 ],masses2_52,RedSet_4(16),ScalarBoxes(24))
  call compute_scalar_box([ 16, 21, 23 ],masses2_52,RedSet_4(17),ScalarBoxes(25))
  call compute_scalar_box([ 16, 20, 21 ],masses2_54,RedSet_4(1),ScalarBoxes(26))
  call compute_scalar_box([ 4, 5, 7 ],masses2_52,RedSet_4(19),ScalarBoxes(27))
  call compute_scalar_box([ 18, 19, 23 ],masses2_51,RedSet_4(20),ScalarBoxes(28))
  call compute_scalar_box([ 16, 19, 23 ],masses2_56,RedSet_4(21),ScalarBoxes(29))
  call compute_scalar_box([ 16, 18, 23 ],masses2_53,RedSet_4(22),ScalarBoxes(30))
  call compute_scalar_box([ 16, 18, 19 ],masses2_53,RedSet_4(2),ScalarBoxes(31))
  call compute_scalar_box([ 2, 3, 7 ],masses2_51,RedSet_4(23),ScalarBoxes(32))
  call compute_scalar_box([ 18, 19, 23 ],masses2_62,RedSet_4(20),ScalarBoxes(33))
  call compute_scalar_box([ 16, 18, 23 ],masses2_58,RedSet_4(22),ScalarBoxes(34))
  call compute_scalar_box([ 16, 18, 19 ],masses2_58,RedSet_4(2),ScalarBoxes(35))
  call compute_scalar_box([ 2, 3, 7 ],masses2_62,RedSet_4(23),ScalarBoxes(36))
  call compute_scalar_box([ 18, 19, 23 ],masses2_59,RedSet_4(20),ScalarBoxes(37))
  call compute_scalar_box([ 16, 19, 23 ],masses2_45,RedSet_4(21),ScalarBoxes(38))
  call compute_scalar_box([ 16, 18, 23 ],masses2_48,RedSet_4(22),ScalarBoxes(39))
  call compute_scalar_box([ 16, 18, 19 ],masses2_48,RedSet_4(2),ScalarBoxes(40))
  call compute_scalar_box([ 2, 3, 7 ],masses2_59,RedSet_4(23),ScalarBoxes(41))
  call compute_scalar_box([ 18, 19, 23 ],masses2_44,RedSet_4(20),ScalarBoxes(42))
  call compute_scalar_box([ 16, 18, 23 ],masses2_52,RedSet_4(22),ScalarBoxes(43))
  call compute_scalar_box([ 16, 18, 19 ],masses2_52,RedSet_4(2),ScalarBoxes(44))
  call compute_scalar_box([ 2, 3, 7 ],masses2_44,RedSet_4(23),ScalarBoxes(45))
  call compute_scalar_box([ 20, 22, 23 ],masses2_53,RedSet_4(24),ScalarBoxes(46))
  call compute_scalar_box([ 16, 22, 23 ],masses2_53,RedSet_4(25),ScalarBoxes(47))
  call compute_scalar_box([ 16, 20, 22 ],masses2_55,RedSet_4(3),ScalarBoxes(48))
  call compute_scalar_box([ 4, 6, 7 ],masses2_53,RedSet_4(26),ScalarBoxes(49))
  call compute_scalar_box([ 20, 22, 23 ],masses2_58,RedSet_4(24),ScalarBoxes(50))
  call compute_scalar_box([ 16, 22, 23 ],masses2_58,RedSet_4(25),ScalarBoxes(51))
  call compute_scalar_box([ 16, 20, 22 ],masses2_57,RedSet_4(3),ScalarBoxes(52))
  call compute_scalar_box([ 4, 6, 7 ],masses2_58,RedSet_4(26),ScalarBoxes(53))
  call compute_scalar_box([ 20, 22, 23 ],masses2_48,RedSet_4(24),ScalarBoxes(54))
  call compute_scalar_box([ 16, 22, 23 ],masses2_48,RedSet_4(25),ScalarBoxes(55))
  call compute_scalar_box([ 16, 20, 22 ],masses2_46,RedSet_4(3),ScalarBoxes(56))
  call compute_scalar_box([ 4, 6, 7 ],masses2_48,RedSet_4(26),ScalarBoxes(57))
  call compute_scalar_box([ 20, 22, 23 ],masses2_52,RedSet_4(24),ScalarBoxes(58))
  call compute_scalar_box([ 16, 22, 23 ],masses2_52,RedSet_4(25),ScalarBoxes(59))
  call compute_scalar_box([ 16, 20, 22 ],masses2_54,RedSet_4(3),ScalarBoxes(60))
  call compute_scalar_box([ 4, 6, 7 ],masses2_52,RedSet_4(26),ScalarBoxes(61))
  call compute_scalar_box([ 18, 19, 27 ],masses2_51,RedSet_4(27),ScalarBoxes(62))
  call compute_scalar_box([ 16, 19, 27 ],masses2_56,RedSet_4(28),ScalarBoxes(63))
  call compute_scalar_box([ 16, 18, 27 ],masses2_53,RedSet_4(29),ScalarBoxes(64))
  call compute_scalar_box([ 2, 3, 11 ],masses2_51,RedSet_4(30),ScalarBoxes(65))
  call compute_scalar_box([ 18, 19, 27 ],masses2_62,RedSet_4(27),ScalarBoxes(66))
  call compute_scalar_box([ 16, 18, 27 ],masses2_58,RedSet_4(29),ScalarBoxes(67))
  call compute_scalar_box([ 2, 3, 11 ],masses2_62,RedSet_4(30),ScalarBoxes(68))
  call compute_scalar_box([ 18, 19, 27 ],masses2_59,RedSet_4(27),ScalarBoxes(69))
  call compute_scalar_box([ 16, 19, 27 ],masses2_45,RedSet_4(28),ScalarBoxes(70))
  call compute_scalar_box([ 16, 18, 27 ],masses2_48,RedSet_4(29),ScalarBoxes(71))
  call compute_scalar_box([ 2, 3, 11 ],masses2_59,RedSet_4(30),ScalarBoxes(72))
  call compute_scalar_box([ 18, 19, 27 ],masses2_44,RedSet_4(27),ScalarBoxes(73))
  call compute_scalar_box([ 16, 18, 27 ],masses2_52,RedSet_4(29),ScalarBoxes(74))
  call compute_scalar_box([ 2, 3, 11 ],masses2_44,RedSet_4(30),ScalarBoxes(75))
  call compute_scalar_box([ 17, 19, 23 ],masses2_51,RedSet_4(31),ScalarBoxes(76))
  call compute_scalar_box([ 16, 17, 23 ],masses2_53,RedSet_4(32),ScalarBoxes(77))
  call compute_scalar_box([ 16, 17, 19 ],masses2_53,RedSet_4(4),ScalarBoxes(78))
  call compute_scalar_box([ 1, 3, 7 ],masses2_51,RedSet_4(33),ScalarBoxes(79))
  call compute_scalar_box([ 17, 19, 23 ],masses2_62,RedSet_4(31),ScalarBoxes(80))
  call compute_scalar_box([ 16, 17, 23 ],masses2_58,RedSet_4(32),ScalarBoxes(81))
  call compute_scalar_box([ 16, 17, 19 ],masses2_58,RedSet_4(4),ScalarBoxes(82))
  call compute_scalar_box([ 1, 3, 7 ],masses2_62,RedSet_4(33),ScalarBoxes(83))
  call compute_scalar_box([ 17, 19, 23 ],masses2_59,RedSet_4(31),ScalarBoxes(84))
  call compute_scalar_box([ 16, 17, 23 ],masses2_48,RedSet_4(32),ScalarBoxes(85))
  call compute_scalar_box([ 16, 17, 19 ],masses2_48,RedSet_4(4),ScalarBoxes(86))
  call compute_scalar_box([ 1, 3, 7 ],masses2_59,RedSet_4(33),ScalarBoxes(87))
  call compute_scalar_box([ 17, 19, 23 ],masses2_44,RedSet_4(31),ScalarBoxes(88))
  call compute_scalar_box([ 16, 17, 23 ],masses2_52,RedSet_4(32),ScalarBoxes(89))
  call compute_scalar_box([ 16, 17, 19 ],masses2_52,RedSet_4(4),ScalarBoxes(90))
  call compute_scalar_box([ 1, 3, 7 ],masses2_44,RedSet_4(33),ScalarBoxes(91))
  call compute_scalar_box([ 17, 19, 27 ],masses2_51,RedSet_4(34),ScalarBoxes(92))
  call compute_scalar_box([ 16, 17, 27 ],masses2_53,RedSet_4(35),ScalarBoxes(93))
  call compute_scalar_box([ 1, 3, 11 ],masses2_51,RedSet_4(36),ScalarBoxes(94))
  call compute_scalar_box([ 17, 19, 27 ],masses2_62,RedSet_4(34),ScalarBoxes(95))
  call compute_scalar_box([ 16, 17, 27 ],masses2_58,RedSet_4(35),ScalarBoxes(96))
  call compute_scalar_box([ 1, 3, 11 ],masses2_62,RedSet_4(36),ScalarBoxes(97))
  call compute_scalar_box([ 17, 19, 27 ],masses2_59,RedSet_4(34),ScalarBoxes(98))
  call compute_scalar_box([ 16, 17, 27 ],masses2_48,RedSet_4(35),ScalarBoxes(99))
  call compute_scalar_box([ 1, 3, 11 ],masses2_59,RedSet_4(36),ScalarBoxes(100))
  call compute_scalar_box([ 17, 19, 27 ],masses2_44,RedSet_4(34),ScalarBoxes(101))
  call compute_scalar_box([ 16, 17, 27 ],masses2_52,RedSet_4(35),ScalarBoxes(102))
  call compute_scalar_box([ 1, 3, 11 ],masses2_44,RedSet_4(36),ScalarBoxes(103))
  call compute_scalar_box([ 18, 22, 23 ],masses2_60,RedSet_4(37),ScalarBoxes(104))
  call compute_scalar_box([ 16, 18, 22 ],masses2_49,RedSet_4(5),ScalarBoxes(105))
  call compute_scalar_box([ 2, 6, 7 ],masses2_60,RedSet_4(38),ScalarBoxes(106))
  call compute_scalar_box([ 18, 26, 27 ],masses2_60,RedSet_4(39),ScalarBoxes(107))
  call compute_scalar_box([ 16, 26, 27 ],masses2_48,RedSet_4(40),ScalarBoxes(108))
  call compute_scalar_box([ 16, 18, 26 ],masses2_49,RedSet_4(6),ScalarBoxes(109))
  call compute_scalar_box([ 2, 10, 11 ],masses2_60,RedSet_4(41),ScalarBoxes(110))
  call compute_scalar_box([ 17, 21, 23 ],masses2_60,RedSet_4(42),ScalarBoxes(111))
  call compute_scalar_box([ 1, 5, 7 ],masses2_60,RedSet_4(43),ScalarBoxes(112))
  call compute_scalar_box([ 17, 25, 27 ],masses2_60,RedSet_4(44),ScalarBoxes(113))
  call compute_scalar_box([ 16, 25, 27 ],masses2_48,RedSet_4(45),ScalarBoxes(114))
  call compute_scalar_box([ 1, 9, 11 ],masses2_60,RedSet_4(46),ScalarBoxes(115))
! end of process


end subroutine vamp_4

end module ol_vamp_4_ppttj_ew_ttxaag_2_/**/REALKIND
