
module ol_vamp_3_ppttj_ew_ttxggg_1_/**/REALKIND
contains

! **********************************************************************
subroutine vamp_3(M)
! P(0:3,nlegs) = incoming external momenta
! Uses tree structures 'wf', factors 'c', and denominators 'den' from loop_ppttj_ew_ttxggg_1.
! Sets colour stripped amplitudes A from the module loop_amplitudes_ppttj_ew_ttxggg_1.
! **********************************************************************
  use KIND_TYPES, only: REALKIND, QREALKIND, intkind2
  use ol_parameters_decl_/**/DREALKIND, only: l_switch
  use ol_parameters_decl_/**/QREALKIND ! masses
  use ol_vert_interface_/**/REALKIND
  use ol_prop_interface_/**/REALKIND
  use ol_last_step_/**/REALKIND
  use ol_tables_storage_ppttj_ew_ttxggg_1_/**/DREALKIND
  use ol_tensor_sum_storage_ppttj_ew_ttxggg_1_/**/REALKIND
  use ol_loop_handling_/**/REALKIND
  use ofred_reduction_/**/REALKIND, only: Hotf_4pt_reduction, Hotf_4pt_reduction_last
  use ofred_reduction_/**/REALKIND, only: Hotf_5pt_reduction, Hotf_5pt_reduction_last
  use ol_loop_reduction_/**/REALKIND, only: TI_bubble_red, TI_triangle_red
use ol_loop_reduction_/**/REALKIND, only: compute_scalar_box

  use ol_loop_storage_ppttj_ew_ttxggg_1_/**/REALKIND
#ifndef PRECISION_dp
  use ol_loop_storage_ppttj_ew_ttxggg_1_/**/DREALKIND, only: &
    & p_switch, Hel, merge_step, merge_mism, merge_tables, merge_hels, ntryL, hel_states
#endif
  use hol_initialisation_/**/REALKIND, only: G0_hol_initialisation
  use ol_h_vert_interface_/**/REALKIND
  use ol_h_prop_interface_/**/REALKIND
  use ol_h_last_step_/**/REALKIND
  use ol_merging_/**/REALKIND, only: ol_merge, ol_merge_tensors, ol_merge_last

  implicit none

  type(Hpolcont) :: Gcoeff(hel_states)
  type(Hpolcont), intent(in) :: M(11,hel_states)


#ifndef PRECISION_dp
  if (ntryL==1 .OR. p_switch == 1) Gcoeff(:)%hf = Hel(1:hel_states)
#else
  if (ntryL==1 .OR. p_switch == 2) Gcoeff(:)%hf = Hel(1:hel_states)
#endif

  ! =============================================
  call Hotf_4pt_reduction_last(G1tensor(351),RedSet_4(20),mass4set(:,12),  & 
G0tensor(360),G0tensor(361),G0tensor(362),G0tensor(363),G0tensor(364))
  call Hotf_4pt_reduction_last(G1tensor(356),RedSet_4(21),mass4set(:,5),  & 
G0tensor(365),G0tensor(366),G0tensor(367),G0tensor(368),G0tensor(369))
  call Hotf_4pt_reduction_last(G1tensor(361),RedSet_4(20),mass4set(:,13),  & 
G0tensor(370),G0tensor(371),G0tensor(372),G0tensor(373),G0tensor(374))
  call Hotf_4pt_reduction_last(G1tensor(366),RedSet_4(21),mass4set(:,6),  & 
G0tensor(375),G0tensor(376),G0tensor(377),G0tensor(378),G0tensor(379))
  call Hotf_4pt_reduction_last(G1tensor(371),RedSet_4(20),mass4set(:,14),  & 
G0tensor(380),G0tensor(381),G0tensor(382),G0tensor(383),G0tensor(384))
  call Hotf_4pt_reduction_last(G1tensor(376),RedSet_4(21),mass4set(:,7),  & 
G0tensor(385),G0tensor(386),G0tensor(387),G0tensor(388),G0tensor(389))
  call Hotf_4pt_reduction_last(G1tensor(381),RedSet_4(20),mass4set(:,15),  & 
G0tensor(390),G0tensor(391),G0tensor(392),G0tensor(393),G0tensor(394))
  call Hotf_4pt_reduction_last(G1tensor(386),RedSet_4(21),mass4set(:,8),  & 
G0tensor(395),G0tensor(396),G0tensor(397),G0tensor(398),G0tensor(399))
  call Hotf_4pt_reduction_last(G1tensor(391),RedSet_4(23),mass4set(:,12),  & 
G0tensor(400),G0tensor(401),G0tensor(402),G0tensor(403),G0tensor(404))
  call Hotf_4pt_reduction_last(G1tensor(396),RedSet_4(24),mass4set(:,5),  & 
G0tensor(405),G0tensor(406),G0tensor(407),G0tensor(408),G0tensor(409))
  call Hotf_4pt_reduction_last(G1tensor(401),RedSet_4(23),mass4set(:,13),  & 
G0tensor(410),G0tensor(411),G0tensor(412),G0tensor(413),G0tensor(414))
  call Hotf_4pt_reduction_last(G1tensor(406),RedSet_4(24),mass4set(:,6),  & 
G0tensor(415),G0tensor(416),G0tensor(417),G0tensor(418),G0tensor(419))
  call Hotf_4pt_reduction_last(G1tensor(411),RedSet_4(23),mass4set(:,14),  & 
G0tensor(420),G0tensor(421),G0tensor(422),G0tensor(423),G0tensor(424))
  call Hotf_4pt_reduction_last(G1tensor(416),RedSet_4(24),mass4set(:,7),  & 
G0tensor(425),G0tensor(426),G0tensor(427),G0tensor(428),G0tensor(429))
  call Hotf_4pt_reduction_last(G1tensor(421),RedSet_4(23),mass4set(:,15),  & 
G0tensor(430),G0tensor(431),G0tensor(432),G0tensor(433),G0tensor(434))
  call Hotf_4pt_reduction_last(G1tensor(426),RedSet_4(24),mass4set(:,8),  & 
G0tensor(435),G0tensor(436),G0tensor(437),G0tensor(438),G0tensor(439))
  call Hotf_4pt_reduction_last(G1tensor(431),RedSet_4(17),mass4set(:,11),  & 
G0tensor(440),G0tensor(441),G0tensor(442),G0tensor(443),G0tensor(444))
  call Hotf_4pt_reduction_last(G1tensor(472),RedSet_4(10),mass4set(:,11),  & 
G0tensor(445),G0tensor(446),G0tensor(447),G0tensor(448),G0tensor(449))
  call Hotf_4pt_reduction_last(G1tensor(477),RedSet_4(7),mass4set(:,11),  & 
G0tensor(450),G0tensor(451),G0tensor(452),G0tensor(453),G0tensor(454))
  call ol_merge_tensors(T0sum(1),[G0tensor(10)])
  call ol_merge_tensors(T0sum(2),[G0tensor(15)])
  call ol_merge_tensors(T0sum(3),[G0tensor(20)])
  call ol_merge_tensors(T0sum(4),[G0tensor(25)])
  call ol_merge_tensors(T0sum(5),[G0tensor(30)])
  call ol_merge_tensors(T0sum(6),[G0tensor(35)])
  call ol_merge_tensors(T0sum(7),[G0tensor(40)])
  call ol_merge_tensors(T0sum(8),[G0tensor(45)])
  call ol_merge_tensors(T0sum(9),[G0tensor(50)])
  call ol_merge_tensors(T0sum(10),[G0tensor(55)])
  call ol_merge_tensors(T0sum(11),[G0tensor(60)])
  call ol_merge_tensors(T0sum(12),[G0tensor(65)])
  call ol_merge_tensors(T0sum(13),[G0tensor(70)])
  call ol_merge_tensors(T0sum(14),[G0tensor(75)])
  call ol_merge_tensors(T0sum(15),[G0tensor(80)])
  call ol_merge_tensors(T0sum(16),[G0tensor(85)])
  call ol_merge_tensors(T0sum(17),[G0tensor(90)])
  call ol_merge_tensors(T0sum(18),[G0tensor(95)])
  call ol_merge_tensors(T0sum(19),[G0tensor(100)])
  call ol_merge_tensors(T0sum(20),[G0tensor(105)])
  call ol_merge_tensors(T0sum(21),[G0tensor(110)])
  call ol_merge_tensors(T0sum(22),[G0tensor(115)])
  call ol_merge_tensors(T0sum(23),[G0tensor(120)])
  call ol_merge_tensors(T0sum(24),[G0tensor(125)])
  call ol_merge_tensors(T0sum(25),[G0tensor(130)])
  call ol_merge_tensors(T0sum(26),[G0tensor(135)])
  call ol_merge_tensors(T0sum(27),[G0tensor(140)])
  call ol_merge_tensors(T0sum(28),[G0tensor(145)])
  call ol_merge_tensors(T0sum(29),[G0tensor(150)])
  call ol_merge_tensors(T0sum(30),[G0tensor(155)])
  call ol_merge_tensors(T0sum(31),[G0tensor(160)])
  call ol_merge_tensors(T0sum(32),[G0tensor(165)])
  call ol_merge_tensors(T0sum(33),[G0tensor(170)])
  call ol_merge_tensors(T0sum(34),[G0tensor(175)])
  call ol_merge_tensors(T0sum(35),[G0tensor(180)])
  call ol_merge_tensors(T0sum(36),[G0tensor(185)])
  call ol_merge_tensors(T0sum(37),[G0tensor(190)])
  call ol_merge_tensors(T0sum(38),[G0tensor(195)])
  call ol_merge_tensors(T0sum(39),[G0tensor(200)])
  call ol_merge_tensors(T0sum(40),[G0tensor(205)])
  call ol_merge_tensors(T0sum(41),[G0tensor(210)])
  call ol_merge_tensors(T0sum(42),[G0tensor(215)])
  call ol_merge_tensors(T0sum(43),[G0tensor(220)])
  call ol_merge_tensors(T0sum(44),[G0tensor(225)])
  call ol_merge_tensors(T0sum(45),[G0tensor(230)])
  call ol_merge_tensors(T0sum(46),[G0tensor(235)])
  call ol_merge_tensors(T0sum(47),[G0tensor(240)])
  call ol_merge_tensors(T0sum(48),[G0tensor(245)])
  call ol_merge_tensors(T0sum(49),[G0tensor(250)])
  call ol_merge_tensors(T0sum(50),[G0tensor(255)])
  call ol_merge_tensors(T0sum(51),[G0tensor(260)])
  call ol_merge_tensors(T0sum(52),[G0tensor(265)])
  call ol_merge_tensors(T0sum(53),[G0tensor(270)])
  call ol_merge_tensors(T0sum(54),[G0tensor(275)])
  call ol_merge_tensors(T0sum(55),[G0tensor(280)])
  call ol_merge_tensors(T0sum(56),[G0tensor(285)])
  call ol_merge_tensors(T0sum(57),[G0tensor(290)])
  call ol_merge_tensors(T0sum(58),[G0tensor(295)])
  call ol_merge_tensors(T0sum(59),[G0tensor(300)])
  call ol_merge_tensors(T0sum(60),[G0tensor(305)])
  call ol_merge_tensors(T0sum(61),[G0tensor(310)])
  call ol_merge_tensors(T0sum(62),[G0tensor(315)])
  call ol_merge_tensors(T0sum(63),[G0tensor(320)])
  call ol_merge_tensors(T0sum(64),[G0tensor(325)])
  call ol_merge_tensors(T0sum(65),[G0tensor(330)])
  call ol_merge_tensors(T0sum(66),[G0tensor(335)])
  call ol_merge_tensors(T0sum(67),[G0tensor(340)])
  call ol_merge_tensors(T0sum(68),[G0tensor(345)])
  call ol_merge_tensors(T0sum(69),[G0tensor(350)])
  call ol_merge_tensors(T0sum(70),[G0tensor(355)])
  call ol_merge_tensors(T0sum(71),[G0tensor(360)])
  call ol_merge_tensors(T0sum(72),[G0tensor(365)])
  call ol_merge_tensors(T0sum(73),[G0tensor(370)])
  call ol_merge_tensors(T0sum(74),[G0tensor(375)])
  call ol_merge_tensors(T0sum(75),[G0tensor(380)])
  call ol_merge_tensors(T0sum(76),[G0tensor(385)])
  call ol_merge_tensors(T0sum(77),[G0tensor(390)])
  call ol_merge_tensors(T0sum(78),[G0tensor(395)])
  call ol_merge_tensors(T0sum(79),[G0tensor(400)])
  call ol_merge_tensors(T0sum(80),[G0tensor(405)])
  call ol_merge_tensors(T0sum(81),[G0tensor(410)])
  call ol_merge_tensors(T0sum(82),[G0tensor(415)])
  call ol_merge_tensors(T0sum(83),[G0tensor(420)])
  call ol_merge_tensors(T0sum(84),[G0tensor(425)])
  call ol_merge_tensors(T0sum(85),[G0tensor(430)])
  call ol_merge_tensors(T0sum(86),[G0tensor(435)])
  call ol_merge_tensors(T0sum(87),[G0tensor(1)])
  call ol_merge_tensors(T0sum(88),[G0tensor(2)])
  call ol_merge_tensors(T0sum(89),[G0tensor(3)])
  call ol_merge_tensors(T0sum(90),[G0tensor(4)])
  call ol_merge_tensors(T0sum(91),[G0tensor(5)])
  call ol_merge_tensors(T0sum(92),[G0tensor(6)])
  call ol_merge_tensors(T0sum(93),[G0tensor(7)])
  call ol_merge_tensors(T0sum(94),[G0tensor(8)])
  call ol_merge_tensors(T0sum(95),[G0tensor(9)])
  call ol_merge_tensors(T0sum(96),[G0tensor(440)])
  call ol_merge_tensors(T0sum(97),[G0tensor(445)])
  call ol_merge_tensors(T0sum(98),[G0tensor(450)])
  Gcoeff(:)%j = (c(10)*(-M(1,:)%j+M(3,:)%j+M(5,:)%j-M(6,:)%j)) * den(27)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(217),h0tab(:,217),[28,1,2],[nMT,nMH,nMT],3,1,wf8(:,1))
  call Hloop_AV_Q(ntryL,G0H32(1),wf8(:,1),G0H4(1),m3h8x4(:,1),heltab2x32(:,:,217))
  call Hloop_A_Q(ntryL,G0H4(1),28,nMT,G1H4(145),n2h4(145))
  Gcoeff(:)%j = (c(10)*(M(1,:)%j-M(2,:)%j-M(4,:)%j+M(6,:)%j)) * den(27)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(218),h0tab(:,218),[28,1,2],[nMT,nMH,nMT],3,1,wf8(:,2))
  call Hloop_AV_Q(ntryL,G0H32(1),wf8(:,2),G0H4(2),m3h8x4(:,2),heltab2x32(:,:,218))
  call Hloop_A_Q(ntryL,G0H4(2),28,nMT,G1H4(146),n2h4(146))
  Gcoeff(:)%j = (c(10)*(M(2,:)%j-M(3,:)%j+M(4,:)%j-M(5,:)%j)) * den(27)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(219),h0tab(:,219),[28,1,2],[nMT,nMH,nMT],3,1,wf8(:,3))
  call Hloop_AV_Q(ntryL,G0H32(1),wf8(:,3),G0H4(3),m3h8x4(:,3),heltab2x32(:,:,219))
  call Hloop_A_Q(ntryL,G0H4(3),28,nMT,G1H4(149),n2h4(147))
  Gcoeff(:)%j = (c(10)*(M(1,:)%j-M(3,:)%j-M(5,:)%j+M(6,:)%j)) * den(27)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(220),h0tab(:,220),[28,1,2],[nMT,nMZ,nMT],3,1,wf8(:,1))
  call Hloop_AV_Q(ntryL,G0H32(1),wf8(:,1),G0H4(4),m3h8x4(:,4),heltab2x32(:,:,220))
  call Hloop_A_Q(ntryL,G0H4(4),28,nMT,G1H4(150),n2h4(148))
  Gcoeff(:)%j = (c(10)*(-M(1,:)%j+M(2,:)%j+M(4,:)%j-M(6,:)%j)) * den(27)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(221),h0tab(:,221),[28,1,2],[nMT,nMZ,nMT],3,1,wf8(:,2))
  call Hloop_AV_Q(ntryL,G0H32(1),wf8(:,2),G0H4(5),m3h8x4(:,5),heltab2x32(:,:,221))
  call Hloop_A_Q(ntryL,G0H4(5),28,nMT,G1H4(151),n2h4(149))
  Gcoeff(:)%j = (c(10)*(-M(2,:)%j+M(3,:)%j-M(4,:)%j+M(5,:)%j)) * den(27)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(222),h0tab(:,222),[28,1,2],[nMT,nMZ,nMT],3,1,wf8(:,3))
  call Hloop_AV_Q(ntryL,G0H32(1),wf8(:,3),G0H4(6),m3h8x4(:,6),heltab2x32(:,:,222))
  call Hloop_A_Q(ntryL,G0H4(6),28,nMT,G1H4(152),n2h4(150))
  Gcoeff(:)%j = (c(8)*(M(1,:)%j-M(3,:)%j-M(5,:)%j+M(6,:)%j)) * den(27)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(223),h0tab(:,223),[28,1,2],[nMB,nMW,nMB],3,1,wf8(:,1))
  call Hloop_AV_Q(ntryL,G0H32(1),wf8(:,1),G0H4(7),m3h8x4(:,7),heltab2x32(:,:,223))
  call Hloop_A_Q(ntryL,G0H4(7),28,nMB,G1H4(155),n2h4(151))
  Gcoeff(:)%j = (c(8)*(-M(1,:)%j+M(2,:)%j+M(4,:)%j-M(6,:)%j)) * den(27)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(224),h0tab(:,224),[28,1,2],[nMB,nMW,nMB],3,1,wf8(:,2))
  call Hloop_AV_Q(ntryL,G0H32(1),wf8(:,2),G0H4(8),m3h8x4(:,8),heltab2x32(:,:,224))
  call Hloop_A_Q(ntryL,G0H4(8),28,nMB,G1H4(156),n2h4(152))
  Gcoeff(:)%j = (c(8)*(-M(2,:)%j+M(3,:)%j-M(4,:)%j+M(5,:)%j)) * den(27)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(225),h0tab(:,225),[28,1,2],[nMB,nMW,nMB],3,1,wf8(:,3))
  call Hloop_AV_Q(ntryL,G0H32(1),wf8(:,3),G0H4(9),m3h8x4(:,9),heltab2x32(:,:,225))
  call Hloop_A_Q(ntryL,G0H4(9),28,nMB,G1H4(157),n2h4(153))
  Gcoeff(:)%j = (c(3)*(M(1,:)%j-M(3,:)%j-M(5,:)%j+M(6,:)%j)) * den(27)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(226),h0tab(:,226),[28,1,2],[nMT,0,nMT],3,1,wf8(:,1))
  call Hloop_AV_Q(ntryL,G0H32(1),wf8(:,1),G0H4(10),m3h8x4(:,10),heltab2x32(:,:,226))
  call Hloop_A_Q(ntryL,G0H4(10),28,nMT,G1H4(158),n2h4(154))
  Gcoeff(:)%j = (c(3)*(-M(1,:)%j+M(2,:)%j+M(4,:)%j-M(6,:)%j)) * den(27)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(227),h0tab(:,227),[28,1,2],[nMT,0,nMT],3,1,wf8(:,2))
  call Hloop_AV_Q(ntryL,G0H32(1),wf8(:,2),G0H4(11),m3h8x4(:,11),heltab2x32(:,:,227))
  call Hloop_A_Q(ntryL,G0H4(11),28,nMT,G1H4(162),n2h4(155))
  Gcoeff(:)%j = (c(3)*(-M(2,:)%j+M(3,:)%j-M(4,:)%j+M(5,:)%j)) * den(27)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(228),h0tab(:,228),[28,1,2],[nMT,0,nMT],3,1,wf8(:,3))
  call Hloop_AV_Q(ntryL,G0H32(1),wf8(:,3),G0H4(12),m3h8x4(:,12),heltab2x32(:,:,228))
  call Hloop_A_Q(ntryL,G0H4(12),28,nMT,G1H4(163),n2h4(156))
  Gcoeff(:)%j = (c(4)*(M(1,:)%j-M(3,:)%j-M(5,:)%j+M(6,:)%j)) * den(27)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(229),h0tab(:,229),[28,1,2],[nMT,nMZ,nMT],3,1,wf8(:,1))
  call Hloop_AV_Q(ntryL,G0H32(1),wf8(:,1),G0H4(1),m3h8x4(:,13),heltab2x32(:,:,229))
  call Hloop_A_Q(ntryL,G0H4(1),28,nMT,G1H4(164),n2h4(157))
  Gcoeff(:)%j = (c(4)*(-M(1,:)%j+M(2,:)%j+M(4,:)%j-M(6,:)%j)) * den(27)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(230),h0tab(:,230),[28,1,2],[nMT,nMZ,nMT],3,1,wf8(:,2))
  call Hloop_AV_Q(ntryL,G0H32(1),wf8(:,2),G0H4(2),m3h8x4(:,14),heltab2x32(:,:,230))
  call Hloop_A_Q(ntryL,G0H4(2),28,nMT,G1H4(167),n2h4(158))
  Gcoeff(:)%j = (c(4)*(-M(2,:)%j+M(3,:)%j-M(4,:)%j+M(5,:)%j)) * den(27)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(231),h0tab(:,231),[28,1,2],[nMT,nMZ,nMT],3,1,wf8(:,3))
  call Hloop_AV_Q(ntryL,G0H32(1),wf8(:,3),G0H4(3),m3h8x4(:,15),heltab2x32(:,:,231))
  call Hloop_A_Q(ntryL,G0H4(3),28,nMT,G1H4(1),n2h4(159))
  Gcoeff(:)%j = (c(6)*(M(1,:)%j-M(3,:)%j-M(5,:)%j+M(6,:)%j)) * den(27)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(232),h0tab(:,232),[28,1,2],[nMB,nMW,nMB],3,1,wf8(:,1))
  call Hloop_AV_Q(ntryL,G0H32(1),wf8(:,1),G0H4(4),m3h8x4(:,16),heltab2x32(:,:,232))
  call Hloop_A_Q(ntryL,G0H4(4),28,nMB,G1H4(2),n2h4(160))
  Gcoeff(:)%j = (c(6)*(-M(1,:)%j+M(2,:)%j+M(4,:)%j-M(6,:)%j)) * den(27)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(233),h0tab(:,233),[28,1,2],[nMB,nMW,nMB],3,1,wf8(:,2))
  call Hloop_AV_Q(ntryL,G0H32(1),wf8(:,2),G0H4(5),m3h8x4(:,17),heltab2x32(:,:,233))
  call Hloop_A_Q(ntryL,G0H4(5),28,nMB,G1H4(5),n2h4(161))
  Gcoeff(:)%j = (c(6)*(-M(2,:)%j+M(3,:)%j-M(4,:)%j+M(5,:)%j)) * den(27)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(234),h0tab(:,234),[28,1,2],[nMB,nMW,nMB],3,1,wf8(:,3))
  call Hloop_AV_Q(ntryL,G0H32(1),wf8(:,3),G0H4(6),m3h8x4(:,18),heltab2x32(:,:,234))
  call Hloop_A_Q(ntryL,G0H4(6),28,nMB,G1H4(6),n2h4(162))
  Gcoeff(:)%j = (c(23)*(-M(10,:)%j+M(11,:)%j)) * den(29)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(235),h0tab(:,235),[16,3,12],[nMT,nMT,nMT],3,2,wf4(:,19),wf4(:,2))
  call Hloop_AV_Q(ntryL,G0H32(1),ex5(:),G0H16(1),m3h2x16(:,169),heltab2x32(:,:,235))
  call Hloop_A_Q(ntryL,G0H16(1),16,nMT,G1H16(9),n2h16(169))
  Gcoeff(:)%j = (c(23)*(-M(10,:)%j+M(11,:)%j)) * den(29)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(236),h0tab(:,236),[16,3,12],[nMT,nMT,nMT],3,2,wf4(:,19),wf4(:,2))
  call Hloop_QV_A(ntryL,G0H32(1),ex5(:),G0H16(1),m3h2x16(:,170),heltab2x32(:,:,236))
  call Hloop_Q_A(ntryL,G0H16(1),16,nMT,G1H16(11),n2h16(170))
  Gcoeff(:)%j = (c(21)*(-M(10,:)%j+M(11,:)%j)) * den(29)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(237),h0tab(:,237),[16,3,12],[nMB,nMB,nMB],3,2,wf4(:,19),wf4(:,2))
  call Hloop_AV_Q(ntryL,G0H32(1),ex5(:),G0H16(1),m3h2x16(:,171),heltab2x32(:,:,237))
  call Hloop_A_Q(ntryL,G0H16(1),16,nMB,G1H16(33),n2h16(171))
  Gcoeff(:)%j = (c(21)*(-M(10,:)%j+M(11,:)%j)) * den(29)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(238),h0tab(:,238),[16,3,12],[nMB,nMB,nMB],3,2,wf4(:,19),wf4(:,2))
  call Hloop_QV_A(ntryL,G0H32(1),ex5(:),G0H16(1),m3h2x16(:,172),heltab2x32(:,:,238))
  call Hloop_Q_A(ntryL,G0H16(1),16,nMB,G1H16(35),n2h16(172))
  Gcoeff(:)%j = (c(23)*(M(10,:)%j-M(11,:)%j)) * den(30)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(239),h0tab(:,239),[16,3,12],[nMT,nMT,nMT],3,2,wf4(:,44),wf4(:,2))
  call Hloop_AV_Q(ntryL,G0H32(1),ex5(:),G0H16(1),m3h2x16(:,173),heltab2x32(:,:,239))
  call Hloop_A_Q(ntryL,G0H16(1),16,nMT,G1H16(57),n2h16(173))
  Gcoeff(:)%j = (c(23)*(M(10,:)%j-M(11,:)%j)) * den(30)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(240),h0tab(:,240),[16,3,12],[nMT,nMT,nMT],3,2,wf4(:,44),wf4(:,2))
  call Hloop_QV_A(ntryL,G0H32(1),ex5(:),G0H16(1),m3h2x16(:,174),heltab2x32(:,:,240))
  call Hloop_Q_A(ntryL,G0H16(1),16,nMT,G1H16(59),n2h16(174))
  Gcoeff(:)%j = (c(21)*(-M(10,:)%j+M(11,:)%j)) * den(30)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(241),h0tab(:,241),[16,3,12],[nMB,nMB,nMB],3,2,wf4(:,44),wf4(:,2))
  call Hloop_AV_Q(ntryL,G0H32(1),ex5(:),G0H16(1),m3h2x16(:,175),heltab2x32(:,:,241))
  call Hloop_A_Q(ntryL,G0H16(1),16,nMB,G1H16(1),n2h16(175))
  Gcoeff(:)%j = (c(21)*(-M(10,:)%j+M(11,:)%j)) * den(30)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(242),h0tab(:,242),[16,3,12],[nMB,nMB,nMB],3,2,wf4(:,44),wf4(:,2))
  call Hloop_QV_A(ntryL,G0H32(1),ex5(:),G0H16(1),m3h2x16(:,176),heltab2x32(:,:,242))
  call Hloop_Q_A(ntryL,G0H16(1),16,nMB,G1H16(2),n2h16(176))
  Gcoeff(:)%j = (c(13)*(M(10,:)%j-M(11,:)%j)) * den(3)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(243),h0tab(:,243),[16,3,12],[0,0,0],3,2,wf4(:,1),wf4(:,2))
  call Hloop_AV_Q(ntryL,G0H32(1),ex5(:),G0H16(1),m3h2x16(:,177),heltab2x32(:,:,243))
  call Hloop_A_Q(ntryL,G0H16(1),16,0,G1H16(3),n2h16(177))
  Gcoeff(:)%j = (c(12)*(M(10,:)%j-M(11,:)%j)) * den(3)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(244),h0tab(:,244),[16,3,12],[nMT,nMT,nMT],3,2,wf4(:,1),wf4(:,2))
  call Hloop_AV_Q(ntryL,G0H32(1),ex5(:),G0H16(1),m3h2x16(:,178),heltab2x32(:,:,244))
  call Hloop_A_Q(ntryL,G0H16(1),16,nMT,G1H16(4),n2h16(178))
  Gcoeff(:)%j = (c(13)*(M(10,:)%j-M(11,:)%j)) * den(3)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(245),h0tab(:,245),[16,3,12],[0,0,0],3,2,wf4(:,1),wf4(:,2))
  call Hloop_QV_A(ntryL,G0H32(1),ex5(:),G0H16(1),m3h2x16(:,179),heltab2x32(:,:,245))
  call Hloop_Q_A(ntryL,G0H16(1),16,0,G1H16(5),n2h16(179))
  Gcoeff(:)%j = (c(12)*(M(10,:)%j-M(11,:)%j)) * den(3)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(246),h0tab(:,246),[16,3,12],[nMT,nMT,nMT],3,2,wf4(:,1),wf4(:,2))
  call Hloop_QV_A(ntryL,G0H32(1),ex5(:),G0H16(1),m3h2x16(:,180),heltab2x32(:,:,246))
  call Hloop_Q_A(ntryL,G0H16(1),16,nMT,G1H16(6),n2h16(180))
  Gcoeff(:)%j = (c(12)*(-M(10,:)%j+M(11,:)%j)) * den(3)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(247),h0tab(:,247),[16,3,12],[0,0,0],3,2,wf4(:,1),wf4(:,2))
  call Hloop_AV_Q(ntryL,G0H32(1),ex5(:),G0H16(1),m3h2x16(:,181),heltab2x32(:,:,247))
  call Hloop_A_Q(ntryL,G0H16(1),16,0,G1H16(7),n2h16(181))
  Gcoeff(:)%j = (c(11)*(-M(10,:)%j+M(11,:)%j)) * den(3)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(248),h0tab(:,248),[16,3,12],[nMB,nMB,nMB],3,2,wf4(:,1),wf4(:,2))
  call Hloop_AV_Q(ntryL,G0H32(1),ex5(:),G0H16(1),m3h2x16(:,182),heltab2x32(:,:,248))
  call Hloop_A_Q(ntryL,G0H16(1),16,nMB,G1H16(8),n2h16(182))
  Gcoeff(:)%j = (c(12)*(-M(10,:)%j+M(11,:)%j)) * den(3)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(249),h0tab(:,249),[16,3,12],[0,0,0],3,2,wf4(:,1),wf4(:,2))
  call Hloop_QV_A(ntryL,G0H32(1),ex5(:),G0H16(1),m3h2x16(:,183),heltab2x32(:,:,249))
  call Hloop_Q_A(ntryL,G0H16(1),16,0,G1H16(13),n2h16(183))
  Gcoeff(:)%j = (c(11)*(-M(10,:)%j+M(11,:)%j)) * den(3)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(250),h0tab(:,250),[16,3,12],[nMB,nMB,nMB],3,2,wf4(:,1),wf4(:,2))
  call Hloop_QV_A(ntryL,G0H32(1),ex5(:),G0H16(1),m3h2x16(:,184),heltab2x32(:,:,250))
  call Hloop_Q_A(ntryL,G0H16(1),16,nMB,G1H16(10),n2h16(184))
  Gcoeff(:)%j = (c(15)*(M(10,:)%j-M(11,:)%j)) * den(30)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(251),h0tab(:,251),[16,3,12],[0,0,0],3,2,wf4(:,17),wf4(:,2))
  call Hloop_AV_Q(ntryL,G0H32(1),ex5(:),G0H16(1),m3h2x16(:,185),heltab2x32(:,:,251))
  call Hloop_A_Q(ntryL,G0H16(1),16,0,G1H16(15),n2h16(185))
  Gcoeff(:)%j = (c(14)*(M(10,:)%j-M(11,:)%j)) * den(30)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(252),h0tab(:,252),[16,3,12],[nMT,nMT,nMT],3,2,wf4(:,17),wf4(:,2))
  call Hloop_AV_Q(ntryL,G0H32(1),ex5(:),G0H16(1),m3h2x16(:,186),heltab2x32(:,:,252))
  call Hloop_A_Q(ntryL,G0H16(1),16,nMT,G1H16(12),n2h16(186))
  Gcoeff(:)%j = (c(15)*(M(10,:)%j-M(11,:)%j)) * den(30)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(253),h0tab(:,253),[16,3,12],[0,0,0],3,2,wf4(:,17),wf4(:,2))
  call Hloop_QV_A(ntryL,G0H32(1),ex5(:),G0H16(1),m3h2x16(:,187),heltab2x32(:,:,253))
  call Hloop_Q_A(ntryL,G0H16(1),16,0,G1H16(14),n2h16(187))
  Gcoeff(:)%j = (c(14)*(M(10,:)%j-M(11,:)%j)) * den(30)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(254),h0tab(:,254),[16,3,12],[nMT,nMT,nMT],3,2,wf4(:,17),wf4(:,2))
  call Hloop_QV_A(ntryL,G0H32(1),ex5(:),G0H16(1),m3h2x16(:,188),heltab2x32(:,:,254))
  call Hloop_Q_A(ntryL,G0H16(1),16,nMT,G1H16(16),n2h16(188))
  Gcoeff(:)%j = (c(15)*(M(10,:)%j-M(11,:)%j)) * den(30)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(255),h0tab(:,255),[16,3,12],[0,0,0],3,2,wf4(:,17),wf4(:,2))
  call Hloop_AV_Q(ntryL,G0H32(1),ex5(:),G0H16(1),m3h2x16(:,189),heltab2x32(:,:,255))
  call Hloop_A_Q(ntryL,G0H16(1),16,0,G1H16(17),n2h16(189))
  Gcoeff(:)%j = (c(14)*(M(10,:)%j-M(11,:)%j)) * den(30)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(256),h0tab(:,256),[16,3,12],[nMB,nMB,nMB],3,2,wf4(:,17),wf4(:,2))
  call Hloop_AV_Q(ntryL,G0H32(1),ex5(:),G0H16(1),m3h2x16(:,190),heltab2x32(:,:,256))
  call Hloop_A_Q(ntryL,G0H16(1),16,nMB,G1H16(18),n2h16(190))
  Gcoeff(:)%j = (c(15)*(M(10,:)%j-M(11,:)%j)) * den(30)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(257),h0tab(:,257),[16,3,12],[0,0,0],3,2,wf4(:,17),wf4(:,2))
  call Hloop_QV_A(ntryL,G0H32(1),ex5(:),G0H16(1),m3h2x16(:,191),heltab2x32(:,:,257))
  call Hloop_Q_A(ntryL,G0H16(1),16,0,G1H16(19),n2h16(191))
  Gcoeff(:)%j = (c(14)*(M(10,:)%j-M(11,:)%j)) * den(30)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(258),h0tab(:,258),[16,3,12],[nMB,nMB,nMB],3,2,wf4(:,17),wf4(:,2))
  call Hloop_QV_A(ntryL,G0H32(1),ex5(:),G0H16(1),m3h2x16(:,192),heltab2x32(:,:,258))
  call Hloop_Q_A(ntryL,G0H16(1),16,nMB,G1H16(20),n2h16(192))
  Gcoeff(:)%j = (c(23)*(M(10,:)%j-M(11,:)%j)) * den(31)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(259),h0tab(:,259),[20,3,8],[nMT,nMT,nMT],3,2,wf4(:,3),wf4(:,19))
  call Hloop_QV_A(ntryL,G0H32(1),wf4(:,3),G0H8(22),m3h4x8(:,49),heltab2x32(:,:,259))
  call Hloop_Q_A(ntryL,G0H8(22),20,nMT,G1H8(25),n2h8(93))
  Gcoeff(:)%j = (c(23)*(M(10,:)%j-M(11,:)%j)) * den(31)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(260),h0tab(:,260),[20,3,8],[nMT,nMT,nMT],3,2,wf4(:,3),wf4(:,19))
  call Hloop_AV_Q(ntryL,G0H32(1),wf4(:,3),G0H8(23),m3h4x8(:,50),heltab2x32(:,:,260))
  call Hloop_A_Q(ntryL,G0H8(23),20,nMT,G1H8(26),n2h8(94))
  Gcoeff(:)%j = (c(21)*(M(10,:)%j-M(11,:)%j)) * den(31)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(261),h0tab(:,261),[20,3,8],[nMB,nMB,nMB],3,2,wf4(:,3),wf4(:,19))
  call Hloop_QV_A(ntryL,G0H32(1),wf4(:,3),G0H8(24),m3h4x8(:,51),heltab2x32(:,:,261))
  call Hloop_Q_A(ntryL,G0H8(24),20,nMB,G1H8(27),n2h8(95))
  Gcoeff(:)%j = (c(21)*(M(10,:)%j-M(11,:)%j)) * den(31)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(262),h0tab(:,262),[20,3,8],[nMB,nMB,nMB],3,2,wf4(:,3),wf4(:,19))
  call Hloop_AV_Q(ntryL,G0H32(1),wf4(:,3),G0H8(25),m3h4x8(:,52),heltab2x32(:,:,262))
  call Hloop_A_Q(ntryL,G0H8(25),20,nMB,G1H8(28),n2h8(96))
  Gcoeff(:)%j = (c(23)*(-M(10,:)%j+M(11,:)%j)) * den(32)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(263),h0tab(:,263),[20,3,8],[nMT,nMT,nMT],3,2,wf4(:,3),wf4(:,44))
  call Hloop_QV_A(ntryL,G0H32(1),wf4(:,3),G0H8(1),m3h4x8(:,53),heltab2x32(:,:,263))
  call Hloop_Q_A(ntryL,G0H8(1),20,nMT,G1H8(29),n2h8(97))
  Gcoeff(:)%j = (c(23)*(-M(10,:)%j+M(11,:)%j)) * den(32)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(264),h0tab(:,264),[20,3,8],[nMT,nMT,nMT],3,2,wf4(:,3),wf4(:,44))
  call Hloop_AV_Q(ntryL,G0H32(1),wf4(:,3),G0H8(2),m3h4x8(:,54),heltab2x32(:,:,264))
  call Hloop_A_Q(ntryL,G0H8(2),20,nMT,G1H8(30),n2h8(98))
  Gcoeff(:)%j = (c(21)*(M(10,:)%j-M(11,:)%j)) * den(32)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(265),h0tab(:,265),[20,3,8],[nMB,nMB,nMB],3,2,wf4(:,3),wf4(:,44))
  call Hloop_QV_A(ntryL,G0H32(1),wf4(:,3),G0H8(3),m3h4x8(:,55),heltab2x32(:,:,265))
  call Hloop_Q_A(ntryL,G0H8(3),20,nMB,G1H8(31),n2h8(99))
  Gcoeff(:)%j = (c(21)*(M(10,:)%j-M(11,:)%j)) * den(32)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(266),h0tab(:,266),[20,3,8],[nMB,nMB,nMB],3,2,wf4(:,3),wf4(:,44))
  call Hloop_AV_Q(ntryL,G0H32(1),wf4(:,3),G0H8(4),m3h4x8(:,56),heltab2x32(:,:,266))
  call Hloop_A_Q(ntryL,G0H8(4),20,nMB,G1H8(32),n2h8(100))
  Gcoeff(:)%j = (c(13)*(-M(10,:)%j+M(11,:)%j)) * den(5)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(267),h0tab(:,267),[20,3,8],[0,0,0],3,2,wf4(:,3),wf4(:,1))
  call Hloop_QV_A(ntryL,G0H32(1),wf4(:,3),G0H8(5),m3h4x8(:,57),heltab2x32(:,:,267))
  call Hloop_Q_A(ntryL,G0H8(5),20,0,G1H8(33),n2h8(101))
  Gcoeff(:)%j = (c(12)*(-M(10,:)%j+M(11,:)%j)) * den(5)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(268),h0tab(:,268),[20,3,8],[nMT,nMT,nMT],3,2,wf4(:,3),wf4(:,1))
  call Hloop_QV_A(ntryL,G0H32(1),wf4(:,3),G0H8(6),m3h4x8(:,58),heltab2x32(:,:,268))
  call Hloop_Q_A(ntryL,G0H8(6),20,nMT,G1H8(34),n2h8(102))
  Gcoeff(:)%j = (c(13)*(-M(10,:)%j+M(11,:)%j)) * den(5)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(269),h0tab(:,269),[20,3,8],[0,0,0],3,2,wf4(:,3),wf4(:,1))
  call Hloop_AV_Q(ntryL,G0H32(1),wf4(:,3),G0H8(7),m3h4x8(:,59),heltab2x32(:,:,269))
  call Hloop_A_Q(ntryL,G0H8(7),20,0,G1H8(35),n2h8(103))
  Gcoeff(:)%j = (c(12)*(-M(10,:)%j+M(11,:)%j)) * den(5)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(270),h0tab(:,270),[20,3,8],[nMT,nMT,nMT],3,2,wf4(:,3),wf4(:,1))
  call Hloop_AV_Q(ntryL,G0H32(1),wf4(:,3),G0H8(8),m3h4x8(:,60),heltab2x32(:,:,270))
  call Hloop_A_Q(ntryL,G0H8(8),20,nMT,G1H8(36),n2h8(104))
  Gcoeff(:)%j = (c(12)*(M(10,:)%j-M(11,:)%j)) * den(5)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(271),h0tab(:,271),[20,3,8],[0,0,0],3,2,wf4(:,3),wf4(:,1))
  call Hloop_QV_A(ntryL,G0H32(1),wf4(:,3),G0H8(9),m3h4x8(:,61),heltab2x32(:,:,271))
  call Hloop_Q_A(ntryL,G0H8(9),20,0,G1H8(37),n2h8(105))
  Gcoeff(:)%j = (c(11)*(M(10,:)%j-M(11,:)%j)) * den(5)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(272),h0tab(:,272),[20,3,8],[nMB,nMB,nMB],3,2,wf4(:,3),wf4(:,1))
  call Hloop_QV_A(ntryL,G0H32(1),wf4(:,3),G0H8(10),m3h4x8(:,62),heltab2x32(:,:,272))
  call Hloop_Q_A(ntryL,G0H8(10),20,nMB,G1H8(38),n2h8(106))
  Gcoeff(:)%j = (c(12)*(M(10,:)%j-M(11,:)%j)) * den(5)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(273),h0tab(:,273),[20,3,8],[0,0,0],3,2,wf4(:,3),wf4(:,1))
  call Hloop_AV_Q(ntryL,G0H32(1),wf4(:,3),G0H8(11),m3h4x8(:,63),heltab2x32(:,:,273))
  call Hloop_A_Q(ntryL,G0H8(11),20,0,G1H8(39),n2h8(107))
  Gcoeff(:)%j = (c(11)*(M(10,:)%j-M(11,:)%j)) * den(5)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(274),h0tab(:,274),[20,3,8],[nMB,nMB,nMB],3,2,wf4(:,3),wf4(:,1))
  call Hloop_AV_Q(ntryL,G0H32(1),wf4(:,3),G0H8(12),m3h4x8(:,64),heltab2x32(:,:,274))
  call Hloop_A_Q(ntryL,G0H8(12),20,nMB,G1H8(40),n2h8(108))
  Gcoeff(:)%j = (c(15)*(-M(10,:)%j+M(11,:)%j)) * den(32)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(275),h0tab(:,275),[20,3,8],[0,0,0],3,2,wf4(:,3),wf4(:,17))
  call Hloop_QV_A(ntryL,G0H32(1),wf4(:,3),G0H8(13),m3h4x8(:,65),heltab2x32(:,:,275))
  call Hloop_Q_A(ntryL,G0H8(13),20,0,G1H8(41),n2h8(109))
  Gcoeff(:)%j = (c(14)*(-M(10,:)%j+M(11,:)%j)) * den(32)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(276),h0tab(:,276),[20,3,8],[nMT,nMT,nMT],3,2,wf4(:,3),wf4(:,17))
  call Hloop_QV_A(ntryL,G0H32(1),wf4(:,3),G0H8(14),m3h4x8(:,66),heltab2x32(:,:,276))
  call Hloop_Q_A(ntryL,G0H8(14),20,nMT,G1H8(42),n2h8(110))
  Gcoeff(:)%j = (c(15)*(-M(10,:)%j+M(11,:)%j)) * den(32)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(277),h0tab(:,277),[20,3,8],[0,0,0],3,2,wf4(:,3),wf4(:,17))
  call Hloop_AV_Q(ntryL,G0H32(1),wf4(:,3),G0H8(15),m3h4x8(:,67),heltab2x32(:,:,277))
  call Hloop_A_Q(ntryL,G0H8(15),20,0,G1H8(43),n2h8(111))
  Gcoeff(:)%j = (c(14)*(-M(10,:)%j+M(11,:)%j)) * den(32)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(278),h0tab(:,278),[20,3,8],[nMT,nMT,nMT],3,2,wf4(:,3),wf4(:,17))
  call Hloop_AV_Q(ntryL,G0H32(1),wf4(:,3),G0H8(16),m3h4x8(:,68),heltab2x32(:,:,278))
  call Hloop_A_Q(ntryL,G0H8(16),20,nMT,G1H8(44),n2h8(112))
  Gcoeff(:)%j = (c(15)*(-M(10,:)%j+M(11,:)%j)) * den(32)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(279),h0tab(:,279),[20,3,8],[0,0,0],3,2,wf4(:,3),wf4(:,17))
  call Hloop_QV_A(ntryL,G0H32(1),wf4(:,3),G0H8(17),m3h4x8(:,69),heltab2x32(:,:,279))
  call Hloop_Q_A(ntryL,G0H8(17),20,0,G1H8(45),n2h8(113))
  Gcoeff(:)%j = (c(14)*(-M(10,:)%j+M(11,:)%j)) * den(32)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(280),h0tab(:,280),[20,3,8],[nMB,nMB,nMB],3,2,wf4(:,3),wf4(:,17))
  call Hloop_QV_A(ntryL,G0H32(1),wf4(:,3),G0H8(18),m3h4x8(:,70),heltab2x32(:,:,280))
  call Hloop_Q_A(ntryL,G0H8(18),20,nMB,G1H8(46),n2h8(114))
  Gcoeff(:)%j = (c(15)*(-M(10,:)%j+M(11,:)%j)) * den(32)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(281),h0tab(:,281),[20,3,8],[0,0,0],3,2,wf4(:,3),wf4(:,17))
  call Hloop_AV_Q(ntryL,G0H32(1),wf4(:,3),G0H8(19),m3h4x8(:,71),heltab2x32(:,:,281))
  call Hloop_A_Q(ntryL,G0H8(19),20,0,G1H8(47),n2h8(115))
  Gcoeff(:)%j = (c(14)*(-M(10,:)%j+M(11,:)%j)) * den(32)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(282),h0tab(:,282),[20,3,8],[nMB,nMB,nMB],3,2,wf4(:,3),wf4(:,17))
  call Hloop_AV_Q(ntryL,G0H32(1),wf4(:,3),G0H8(20),m3h4x8(:,72),heltab2x32(:,:,282))
  call Hloop_A_Q(ntryL,G0H8(20),20,nMB,G1H8(48),n2h8(116))
  Gcoeff(:)%j = (c(23)*(-M(10,:)%j+M(11,:)%j)) * den(33)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(283),h0tab(:,283),[24,3,4],[nMT,nMT,nMT],3,2,wf4(:,4),wf4(:,19))
  call Hloop_QV_A(ntryL,G0H32(1),wf4(:,4),G0H8(21),m3h4x8(:,73),heltab2x32(:,:,283))
  call Hloop_Q_A(ntryL,G0H8(21),24,nMT,G1H8(49),n2h8(117))
  Gcoeff(:)%j = (c(23)*(-M(10,:)%j+M(11,:)%j)) * den(33)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(284),h0tab(:,284),[24,3,4],[nMT,nMT,nMT],3,2,wf4(:,4),wf4(:,19))
  call Hloop_AV_Q(ntryL,G0H32(1),wf4(:,4),G0H8(22),m3h4x8(:,74),heltab2x32(:,:,284))
  call Hloop_A_Q(ntryL,G0H8(22),24,nMT,G1H8(50),n2h8(118))
  Gcoeff(:)%j = (c(21)*(-M(10,:)%j+M(11,:)%j)) * den(33)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(285),h0tab(:,285),[24,3,4],[nMB,nMB,nMB],3,2,wf4(:,4),wf4(:,19))
  call Hloop_QV_A(ntryL,G0H32(1),wf4(:,4),G0H8(23),m3h4x8(:,75),heltab2x32(:,:,285))
  call Hloop_Q_A(ntryL,G0H8(23),24,nMB,G1H8(51),n2h8(119))
  Gcoeff(:)%j = (c(21)*(-M(10,:)%j+M(11,:)%j)) * den(33)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(286),h0tab(:,286),[24,3,4],[nMB,nMB,nMB],3,2,wf4(:,4),wf4(:,19))
  call Hloop_AV_Q(ntryL,G0H32(1),wf4(:,4),G0H8(24),m3h4x8(:,76),heltab2x32(:,:,286))
  call Hloop_A_Q(ntryL,G0H8(24),24,nMB,G1H8(52),n2h8(120))
  Gcoeff(:)%j = (c(23)*(M(10,:)%j-M(11,:)%j)) * den(34)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(287),h0tab(:,287),[24,3,4],[nMT,nMT,nMT],3,2,wf4(:,4),wf4(:,44))
  call Hloop_QV_A(ntryL,G0H32(1),wf4(:,4),G0H8(25),m3h4x8(:,77),heltab2x32(:,:,287))
  call Hloop_Q_A(ntryL,G0H8(25),24,nMT,G1H8(53),n2h8(121))
  Gcoeff(:)%j = (c(23)*(M(10,:)%j-M(11,:)%j)) * den(34)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(288),h0tab(:,288),[24,3,4],[nMT,nMT,nMT],3,2,wf4(:,4),wf4(:,44))
  call Hloop_AV_Q(ntryL,G0H32(1),wf4(:,4),G0H8(1),m3h4x8(:,78),heltab2x32(:,:,288))
  call Hloop_A_Q(ntryL,G0H8(1),24,nMT,G1H8(54),n2h8(122))
  Gcoeff(:)%j = (c(21)*(-M(10,:)%j+M(11,:)%j)) * den(34)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(289),h0tab(:,289),[24,3,4],[nMB,nMB,nMB],3,2,wf4(:,4),wf4(:,44))
  call Hloop_QV_A(ntryL,G0H32(1),wf4(:,4),G0H8(2),m3h4x8(:,79),heltab2x32(:,:,289))
  call Hloop_Q_A(ntryL,G0H8(2),24,nMB,G1H8(55),n2h8(123))
  Gcoeff(:)%j = (c(21)*(-M(10,:)%j+M(11,:)%j)) * den(34)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(290),h0tab(:,290),[24,3,4],[nMB,nMB,nMB],3,2,wf4(:,4),wf4(:,44))
  call Hloop_AV_Q(ntryL,G0H32(1),wf4(:,4),G0H8(3),m3h4x8(:,80),heltab2x32(:,:,290))
  call Hloop_A_Q(ntryL,G0H8(3),24,nMB,G1H8(56),n2h8(124))
  Gcoeff(:)%j = (c(13)*(M(10,:)%j-M(11,:)%j)) * den(7)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(291),h0tab(:,291),[24,3,4],[0,0,0],3,2,wf4(:,4),wf4(:,1))
  call Hloop_QV_A(ntryL,G0H32(1),wf4(:,4),G0H8(4),m3h4x8(:,81),heltab2x32(:,:,291))
  call Hloop_Q_A(ntryL,G0H8(4),24,0,G1H8(57),n2h8(125))
  Gcoeff(:)%j = (c(12)*(M(10,:)%j-M(11,:)%j)) * den(7)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(292),h0tab(:,292),[24,3,4],[nMT,nMT,nMT],3,2,wf4(:,4),wf4(:,1))
  call Hloop_QV_A(ntryL,G0H32(1),wf4(:,4),G0H8(5),m3h4x8(:,82),heltab2x32(:,:,292))
  call Hloop_Q_A(ntryL,G0H8(5),24,nMT,G1H8(58),n2h8(126))
  Gcoeff(:)%j = (c(13)*(M(10,:)%j-M(11,:)%j)) * den(7)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(293),h0tab(:,293),[24,3,4],[0,0,0],3,2,wf4(:,4),wf4(:,1))
  call Hloop_AV_Q(ntryL,G0H32(1),wf4(:,4),G0H8(6),m3h4x8(:,83),heltab2x32(:,:,293))
  call Hloop_A_Q(ntryL,G0H8(6),24,0,G1H8(59),n2h8(127))
  Gcoeff(:)%j = (c(12)*(M(10,:)%j-M(11,:)%j)) * den(7)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(294),h0tab(:,294),[24,3,4],[nMT,nMT,nMT],3,2,wf4(:,4),wf4(:,1))
  call Hloop_AV_Q(ntryL,G0H32(1),wf4(:,4),G0H8(7),m3h4x8(:,84),heltab2x32(:,:,294))
  call Hloop_A_Q(ntryL,G0H8(7),24,nMT,G1H8(60),n2h8(128))
  Gcoeff(:)%j = (c(12)*(-M(10,:)%j+M(11,:)%j)) * den(7)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(295),h0tab(:,295),[24,3,4],[0,0,0],3,2,wf4(:,4),wf4(:,1))
  call Hloop_QV_A(ntryL,G0H32(1),wf4(:,4),G0H8(8),m3h4x8(:,85),heltab2x32(:,:,295))
  call Hloop_Q_A(ntryL,G0H8(8),24,0,G1H8(1),n2h8(129))
  Gcoeff(:)%j = (c(11)*(-M(10,:)%j+M(11,:)%j)) * den(7)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(296),h0tab(:,296),[24,3,4],[nMB,nMB,nMB],3,2,wf4(:,4),wf4(:,1))
  call Hloop_QV_A(ntryL,G0H32(1),wf4(:,4),G0H8(9),m3h4x8(:,86),heltab2x32(:,:,296))
  call Hloop_Q_A(ntryL,G0H8(9),24,nMB,G1H8(2),n2h8(130))
  Gcoeff(:)%j = (c(12)*(-M(10,:)%j+M(11,:)%j)) * den(7)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(297),h0tab(:,297),[24,3,4],[0,0,0],3,2,wf4(:,4),wf4(:,1))
  call Hloop_AV_Q(ntryL,G0H32(1),wf4(:,4),G0H8(10),m3h4x8(:,87),heltab2x32(:,:,297))
  call Hloop_A_Q(ntryL,G0H8(10),24,0,G1H8(4),n2h8(131))
  Gcoeff(:)%j = (c(11)*(-M(10,:)%j+M(11,:)%j)) * den(7)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(298),h0tab(:,298),[24,3,4],[nMB,nMB,nMB],3,2,wf4(:,4),wf4(:,1))
  call Hloop_AV_Q(ntryL,G0H32(1),wf4(:,4),G0H8(11),m3h4x8(:,88),heltab2x32(:,:,298))
  call Hloop_A_Q(ntryL,G0H8(11),24,nMB,G1H8(5),n2h8(132))
  Gcoeff(:)%j = (c(15)*(M(10,:)%j-M(11,:)%j)) * den(34)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(299),h0tab(:,299),[24,3,4],[0,0,0],3,2,wf4(:,4),wf4(:,17))
  call Hloop_QV_A(ntryL,G0H32(1),wf4(:,4),G0H8(12),m3h4x8(:,89),heltab2x32(:,:,299))
  call Hloop_Q_A(ntryL,G0H8(12),24,0,G1H8(6),n2h8(133))
  Gcoeff(:)%j = (c(14)*(M(10,:)%j-M(11,:)%j)) * den(34)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(300),h0tab(:,300),[24,3,4],[nMT,nMT,nMT],3,2,wf4(:,4),wf4(:,17))
  call Hloop_QV_A(ntryL,G0H32(1),wf4(:,4),G0H8(13),m3h4x8(:,90),heltab2x32(:,:,300))
  call Hloop_Q_A(ntryL,G0H8(13),24,nMT,G1H8(7),n2h8(134))
  Gcoeff(:)%j = (c(15)*(M(10,:)%j-M(11,:)%j)) * den(34)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(301),h0tab(:,301),[24,3,4],[0,0,0],3,2,wf4(:,4),wf4(:,17))
  call Hloop_AV_Q(ntryL,G0H32(1),wf4(:,4),G0H8(14),m3h4x8(:,91),heltab2x32(:,:,301))
  call Hloop_A_Q(ntryL,G0H8(14),24,0,G1H8(9),n2h8(135))
  Gcoeff(:)%j = (c(14)*(M(10,:)%j-M(11,:)%j)) * den(34)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(302),h0tab(:,302),[24,3,4],[nMT,nMT,nMT],3,2,wf4(:,4),wf4(:,17))
  call Hloop_AV_Q(ntryL,G0H32(1),wf4(:,4),G0H8(15),m3h4x8(:,92),heltab2x32(:,:,302))
  call Hloop_A_Q(ntryL,G0H8(15),24,nMT,G1H8(10),n2h8(136))
  Gcoeff(:)%j = (c(15)*(M(10,:)%j-M(11,:)%j)) * den(34)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(303),h0tab(:,303),[24,3,4],[0,0,0],3,2,wf4(:,4),wf4(:,17))
  call Hloop_QV_A(ntryL,G0H32(1),wf4(:,4),G0H8(16),m3h4x8(:,93),heltab2x32(:,:,303))
  call Hloop_Q_A(ntryL,G0H8(16),24,0,G1H8(11),n2h8(137))
  Gcoeff(:)%j = (c(14)*(M(10,:)%j-M(11,:)%j)) * den(34)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(304),h0tab(:,304),[24,3,4],[nMB,nMB,nMB],3,2,wf4(:,4),wf4(:,17))
  call Hloop_QV_A(ntryL,G0H32(1),wf4(:,4),G0H8(17),m3h4x8(:,94),heltab2x32(:,:,304))
  call Hloop_Q_A(ntryL,G0H8(17),24,nMB,G1H8(12),n2h8(138))
  Gcoeff(:)%j = (c(15)*(M(10,:)%j-M(11,:)%j)) * den(34)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(305),h0tab(:,305),[24,3,4],[0,0,0],3,2,wf4(:,4),wf4(:,17))
  call Hloop_AV_Q(ntryL,G0H32(1),wf4(:,4),G0H8(18),m3h4x8(:,95),heltab2x32(:,:,305))
  call Hloop_A_Q(ntryL,G0H8(18),24,0,G1H8(14),n2h8(139))
  Gcoeff(:)%j = (c(14)*(M(10,:)%j-M(11,:)%j)) * den(34)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(306),h0tab(:,306),[24,3,4],[nMB,nMB,nMB],3,2,wf4(:,4),wf4(:,17))
  call Hloop_AV_Q(ntryL,G0H32(1),wf4(:,4),G0H8(19),m3h4x8(:,96),heltab2x32(:,:,306))
  call Hloop_A_Q(ntryL,G0H8(19),24,nMB,G1H8(15),n2h8(140))
  Gcoeff(:)%j = (-(c(10)*M(4,:)%j)) * den(10)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(307),h0tab(:,307),[16,5,10],[nMT,nMH,nMT],3,2,wf4(:,7),wf4(:,8))
  call Hloop_AV_Q(ntryL,G0H32(1),ex5(:),G0H16(1),m3h2x16(:,193),heltab2x32(:,:,307))
  call Hloop_A_Q(ntryL,G0H16(1),16,nMT,G1H16(21),n2h16(193))
  Gcoeff(:)%j = (c(10)*M(4,:)%j) * den(10)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(308),h0tab(:,308),[16,5,10],[nMT,nMZ,nMT],3,2,wf4(:,7),wf4(:,8))
  call Hloop_AV_Q(ntryL,G0H32(1),ex5(:),G0H16(1),m3h2x16(:,194),heltab2x32(:,:,308))
  call Hloop_A_Q(ntryL,G0H16(1),16,nMT,G1H16(22),n2h16(194))
  Gcoeff(:)%j = (c(8)*M(4,:)%j) * den(10)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(309),h0tab(:,309),[16,5,10],[nMB,nMW,nMB],3,2,wf4(:,7),wf4(:,8))
  call Hloop_AV_Q(ntryL,G0H32(1),ex5(:),G0H16(1),m3h2x16(:,195),heltab2x32(:,:,309))
  call Hloop_A_Q(ntryL,G0H16(1),16,nMB,G1H16(23),n2h16(195))
  Gcoeff(:)%j = (c(3)*M(4,:)%j) * den(10)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(310),h0tab(:,310),[16,5,10],[nMT,0,nMT],3,2,wf4(:,7),wf4(:,8))
  call Hloop_AV_Q(ntryL,G0H32(1),ex5(:),G0H16(1),m3h2x16(:,196),heltab2x32(:,:,310))
  call Hloop_A_Q(ntryL,G0H16(1),16,nMT,G1H16(24),n2h16(196))
  Gcoeff(:)%j = (c(4)*M(4,:)%j) * den(10)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(311),h0tab(:,311),[16,5,10],[nMT,nMZ,nMT],3,2,wf4(:,7),wf4(:,8))
  call Hloop_AV_Q(ntryL,G0H32(1),ex5(:),G0H16(1),m3h2x16(:,197),heltab2x32(:,:,311))
  call Hloop_A_Q(ntryL,G0H16(1),16,nMT,G1H16(25),n2h16(197))
  Gcoeff(:)%j = (c(6)*M(4,:)%j) * den(10)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(312),h0tab(:,312),[16,5,10],[nMB,nMW,nMB],3,2,wf4(:,7),wf4(:,8))
  call Hloop_AV_Q(ntryL,G0H32(1),ex5(:),G0H16(1),m3h2x16(:,198),heltab2x32(:,:,312))
  call Hloop_A_Q(ntryL,G0H16(1),16,nMB,G1H16(26),n2h16(198))
  Gcoeff(:)%j = (-(c(10)*M(6,:)%j)) * den(12)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(313),h0tab(:,313),[18,5,8],[nMH,nMT,nMT],3,2,wf4(:,10),wf4(:,7))
  call Hloop_QA_S(ntryL,G0H32(1),wf4(:,10),G0H8(20),ngH,m3h4x8(:,97),heltab2x32(:,:,313))
  Gcoeff(:)%j = (c(10)*M(6,:)%j) * den(12)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(314),h0tab(:,314),[18,5,8],[nMZ,nMT,nMT],3,2,wf4(:,10),wf4(:,7))
  call Hloop_QA_S(ntryL,G0H32(1),wf4(:,10),G0H8(21),ngX,m3h4x8(:,98),heltab2x32(:,:,314))
  Gcoeff(:)%j = (c(8)*M(6,:)%j) * den(12)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(315),h0tab(:,315),[18,5,8],[nMW,nMB,nMB],3,2,wf4(:,10),wf4(:,7))
  call Hloop_QA_S(ntryL,G0H32(1),wf4(:,10),G0H8(22),ngPtb,m3h4x8(:,99),heltab2x32(:,:,315))
  Gcoeff(:)%j = (c(3)*M(6,:)%j) * den(12)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(316),h0tab(:,316),[18,5,8],[0,nMT,nMT],3,2,wf4(:,10),wf4(:,7))
  call Hloop_QA_V(ntryL,G0H32(1),wf4(:,10),G0H8(23),m3h4x8(:,100),heltab2x32(:,:,316))
  Gcoeff(:)%j = (c(4)*M(6,:)%j) * den(12)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(317),h0tab(:,317),[18,5,8],[nMZ,nMT,nMT],3,2,wf4(:,10),wf4(:,7))
  call Hloop_QA_Z(ntryL,G0H32(1),wf4(:,10),G0H8(24),ngZu,m3h4x8(:,101),heltab2x32(:,:,317))
  Gcoeff(:)%j = (c(6)*M(6,:)%j) * den(12)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(318),h0tab(:,318),[18,5,8],[nMW,nMB,nMB],3,2,wf4(:,10),wf4(:,7))
  call Hloop_QA_W(ntryL,G0H32(1),wf4(:,10),G0H8(25),m3h4x8(:,102),heltab2x32(:,:,318))
  Gcoeff(:)%j = (c(9)*(M(4,:)%j-M(6,:)%j)) * den(13)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(319),h0tab(:,319),[24,2,5],[nMT,nMH,nMT],3,2,wf4(:,4),wf4(:,7))
  call Hloop_QV_A(ntryL,G0H32(1),wf4(:,4),G0H8(1),m3h4x8(:,103),heltab2x32(:,:,319))
  call Hloop_Q_A(ntryL,G0H8(1),24,nMT,G1H8(16),n2h8(141))
  Gcoeff(:)%j = (c(9)*(-M(4,:)%j+M(6,:)%j)) * den(13)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(320),h0tab(:,320),[24,2,5],[nMT,nMZ,nMT],3,2,wf4(:,4),wf4(:,7))
  call Hloop_QV_A(ntryL,G0H32(1),wf4(:,4),G0H8(2),m3h4x8(:,104),heltab2x32(:,:,320))
  call Hloop_Q_A(ntryL,G0H8(2),24,nMT,G1H8(17),n2h8(142))
  Gcoeff(:)%j = (c(7)*(-M(4,:)%j+M(6,:)%j)) * den(13)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(321),h0tab(:,321),[24,2,5],[nMB,nMW,nMB],3,2,wf4(:,4),wf4(:,7))
  call Hloop_QV_A(ntryL,G0H32(1),wf4(:,4),G0H8(3),m3h4x8(:,105),heltab2x32(:,:,321))
  call Hloop_Q_A(ntryL,G0H8(3),24,nMB,G1H8(19),n2h8(143))
  Gcoeff(:)%j = (c(1)*(-M(4,:)%j+M(6,:)%j)) * den(13)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(322),h0tab(:,322),[24,2,5],[nMT,0,nMT],3,2,wf4(:,4),wf4(:,7))
  call Hloop_QV_A(ntryL,G0H32(1),wf4(:,4),G0H8(4),m3h4x8(:,106),heltab2x32(:,:,322))
  call Hloop_Q_A(ntryL,G0H8(4),24,nMT,G1H8(20),n2h8(144))
  Gcoeff(:)%j = (c(2)*(-M(4,:)%j+M(6,:)%j)) * den(13)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(323),h0tab(:,323),[24,2,5],[nMT,nMZ,nMT],3,2,wf4(:,4),wf4(:,7))
  call Hloop_QV_A(ntryL,G0H32(1),wf4(:,4),G0H8(5),m3h4x8(:,107),heltab2x32(:,:,323))
  call Hloop_Q_A(ntryL,G0H8(5),24,nMT,G1H8(21),n2h8(145))
  Gcoeff(:)%j = (c(5)*(-M(4,:)%j+M(6,:)%j)) * den(13)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(324),h0tab(:,324),[24,2,5],[nMB,nMW,nMB],3,2,wf4(:,4),wf4(:,7))
  call Hloop_QV_A(ntryL,G0H32(1),wf4(:,4),G0H8(6),m3h4x8(:,108),heltab2x32(:,:,324))
  call Hloop_Q_A(ntryL,G0H8(6),24,nMB,G1H8(22),n2h8(146))
  Gcoeff(:)%j = (c(24)*M(9,:)%j) * den(96)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(325),h0tab(:,325),[16,7,8],[nMT,nMT,nMT],3,1,wf8(:,31))
  call Hloop_AV_Q(ntryL,G0H32(1),ex5(:),G0H16(1),m3h2x16(:,199),heltab2x32(:,:,325))
  call Hloop_A_Q(ntryL,G0H16(1),16,nMT,G1H16(27),n2h16(199))
  Gcoeff(:)%j = (c(24)*M(9,:)%j) * den(96)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(326),h0tab(:,326),[16,7,8],[nMT,nMT,nMT],3,1,wf8(:,31))
  call Hloop_QV_A(ntryL,G0H32(1),ex5(:),G0H16(1),m3h2x16(:,200),heltab2x32(:,:,326))
  call Hloop_Q_A(ntryL,G0H16(1),16,nMT,G1H16(28),n2h16(200))
  Gcoeff(:)%j = (c(22)*M(9,:)%j) * den(96)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(327),h0tab(:,327),[16,7,8],[nMB,nMB,nMB],3,1,wf8(:,31))
  call Hloop_AV_Q(ntryL,G0H32(1),ex5(:),G0H16(1),m3h2x16(:,201),heltab2x32(:,:,327))
  call Hloop_A_Q(ntryL,G0H16(1),16,nMB,G1H16(29),n2h16(201))
  Gcoeff(:)%j = (c(22)*M(9,:)%j) * den(96)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(328),h0tab(:,328),[16,7,8],[nMB,nMB,nMB],3,1,wf8(:,31))
  call Hloop_QV_A(ntryL,G0H32(1),ex5(:),G0H16(1),m3h2x16(:,202),heltab2x32(:,:,328))
  call Hloop_Q_A(ntryL,G0H16(1),16,nMB,G1H16(30),n2h16(202))
  Gcoeff(:)%j = (-(c(24)*M(9,:)%j)) * den(98)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(329),h0tab(:,329),[16,7,8],[nMT,nMT,nMT],3,1,wf8(:,98))
  call Hloop_AV_Q(ntryL,G0H32(1),ex5(:),G0H16(1),m3h2x16(:,203),heltab2x32(:,:,329))
  call Hloop_A_Q(ntryL,G0H16(1),16,nMT,G1H16(31),n2h16(203))
  Gcoeff(:)%j = (-(c(24)*M(9,:)%j)) * den(98)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(330),h0tab(:,330),[16,7,8],[nMT,nMT,nMT],3,1,wf8(:,98))
  call Hloop_QV_A(ntryL,G0H32(1),ex5(:),G0H16(1),m3h2x16(:,204),heltab2x32(:,:,330))
  call Hloop_Q_A(ntryL,G0H16(1),16,nMT,G1H16(32),n2h16(204))
  Gcoeff(:)%j = (c(22)*M(9,:)%j) * den(98)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(331),h0tab(:,331),[16,7,8],[nMB,nMB,nMB],3,1,wf8(:,98))
  call Hloop_AV_Q(ntryL,G0H32(1),ex5(:),G0H16(1),m3h2x16(:,205),heltab2x32(:,:,331))
  call Hloop_A_Q(ntryL,G0H16(1),16,nMB,G1H16(37),n2h16(205))
  Gcoeff(:)%j = (c(22)*M(9,:)%j) * den(98)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(332),h0tab(:,332),[16,7,8],[nMB,nMB,nMB],3,1,wf8(:,98))
  call Hloop_QV_A(ntryL,G0H32(1),ex5(:),G0H16(1),m3h2x16(:,206),heltab2x32(:,:,332))
  call Hloop_Q_A(ntryL,G0H16(1),16,nMB,G1H16(34),n2h16(206))
  Gcoeff(:)%j = (-(c(18)*M(9,:)%j)) * den(100)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(333),h0tab(:,333),[16,7,8],[0,0,0],3,1,wf8(:,9))
  call Hloop_AV_Q(ntryL,G0H32(1),ex5(:),G0H16(1),m3h2x16(:,207),heltab2x32(:,:,333))
  call Hloop_A_Q(ntryL,G0H16(1),16,0,G1H16(39),n2h16(207))
  Gcoeff(:)%j = (-(c(17)*M(9,:)%j)) * den(100)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(334),h0tab(:,334),[16,7,8],[nMT,nMT,nMT],3,1,wf8(:,9))
  call Hloop_AV_Q(ntryL,G0H32(1),ex5(:),G0H16(1),m3h2x16(:,208),heltab2x32(:,:,334))
  call Hloop_A_Q(ntryL,G0H16(1),16,nMT,G1H16(36),n2h16(208))
  Gcoeff(:)%j = (-(c(18)*M(9,:)%j)) * den(100)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(335),h0tab(:,335),[16,7,8],[0,0,0],3,1,wf8(:,9))
  call Hloop_QV_A(ntryL,G0H32(1),ex5(:),G0H16(1),m3h2x16(:,209),heltab2x32(:,:,335))
  call Hloop_Q_A(ntryL,G0H16(1),16,0,G1H16(38),n2h16(209))
  Gcoeff(:)%j = (-(c(17)*M(9,:)%j)) * den(100)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(336),h0tab(:,336),[16,7,8],[nMT,nMT,nMT],3,1,wf8(:,9))
  call Hloop_QV_A(ntryL,G0H32(1),ex5(:),G0H16(1),m3h2x16(:,210),heltab2x32(:,:,336))
  call Hloop_Q_A(ntryL,G0H16(1),16,nMT,G1H16(40),n2h16(210))
  Gcoeff(:)%j = (c(17)*M(9,:)%j) * den(100)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(337),h0tab(:,337),[16,7,8],[0,0,0],3,1,wf8(:,9))
  call Hloop_AV_Q(ntryL,G0H32(1),ex5(:),G0H16(1),m3h2x16(:,211),heltab2x32(:,:,337))
  call Hloop_A_Q(ntryL,G0H16(1),16,0,G1H16(41),n2h16(211))
  Gcoeff(:)%j = (c(16)*M(9,:)%j) * den(100)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(338),h0tab(:,338),[16,7,8],[nMB,nMB,nMB],3,1,wf8(:,9))
  call Hloop_AV_Q(ntryL,G0H32(1),ex5(:),G0H16(1),m3h2x16(:,212),heltab2x32(:,:,338))
  call Hloop_A_Q(ntryL,G0H16(1),16,nMB,G1H16(42),n2h16(212))
  Gcoeff(:)%j = (c(17)*M(9,:)%j) * den(100)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(339),h0tab(:,339),[16,7,8],[0,0,0],3,1,wf8(:,9))
  call Hloop_QV_A(ntryL,G0H32(1),ex5(:),G0H16(1),m3h2x16(:,213),heltab2x32(:,:,339))
  call Hloop_Q_A(ntryL,G0H16(1),16,0,G1H16(43),n2h16(213))
  Gcoeff(:)%j = (c(16)*M(9,:)%j) * den(100)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(340),h0tab(:,340),[16,7,8],[nMB,nMB,nMB],3,1,wf8(:,9))
  call Hloop_QV_A(ntryL,G0H32(1),ex5(:),G0H16(1),m3h2x16(:,214),heltab2x32(:,:,340))
  call Hloop_Q_A(ntryL,G0H16(1),16,nMB,G1H16(44),n2h16(214))
  Gcoeff(:)%j = (-(c(20)*M(9,:)%j)) * den(98)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(341),h0tab(:,341),[16,7,8],[0,0,0],3,1,wf8(:,32))
  call Hloop_AV_Q(ntryL,G0H32(1),ex5(:),G0H16(1),m3h2x16(:,215),heltab2x32(:,:,341))
  call Hloop_A_Q(ntryL,G0H16(1),16,0,G1H16(45),n2h16(215))
  Gcoeff(:)%j = (-(c(19)*M(9,:)%j)) * den(98)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(342),h0tab(:,342),[16,7,8],[nMT,nMT,nMT],3,1,wf8(:,32))
  call Hloop_AV_Q(ntryL,G0H32(1),ex5(:),G0H16(1),m3h2x16(:,216),heltab2x32(:,:,342))
  call Hloop_A_Q(ntryL,G0H16(1),16,nMT,G1H16(46),n2h16(216))
  Gcoeff(:)%j = (-(c(20)*M(9,:)%j)) * den(98)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(343),h0tab(:,343),[16,7,8],[0,0,0],3,1,wf8(:,32))
  call Hloop_QV_A(ntryL,G0H32(1),ex5(:),G0H16(1),m3h2x16(:,217),heltab2x32(:,:,343))
  call Hloop_Q_A(ntryL,G0H16(1),16,0,G1H16(47),n2h16(217))
  Gcoeff(:)%j = (-(c(19)*M(9,:)%j)) * den(98)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(344),h0tab(:,344),[16,7,8],[nMT,nMT,nMT],3,1,wf8(:,32))
  call Hloop_QV_A(ntryL,G0H32(1),ex5(:),G0H16(1),m3h2x16(:,218),heltab2x32(:,:,344))
  call Hloop_Q_A(ntryL,G0H16(1),16,nMT,G1H16(48),n2h16(218))
  Gcoeff(:)%j = (-(c(20)*M(9,:)%j)) * den(98)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(345),h0tab(:,345),[16,7,8],[0,0,0],3,1,wf8(:,32))
  call Hloop_AV_Q(ntryL,G0H32(1),ex5(:),G0H16(1),m3h2x16(:,219),heltab2x32(:,:,345))
  call Hloop_A_Q(ntryL,G0H16(1),16,0,G1H16(49),n2h16(219))
  Gcoeff(:)%j = (-(c(19)*M(9,:)%j)) * den(98)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(346),h0tab(:,346),[16,7,8],[nMB,nMB,nMB],3,1,wf8(:,32))
  call Hloop_AV_Q(ntryL,G0H32(1),ex5(:),G0H16(1),m3h2x16(:,220),heltab2x32(:,:,346))
  call Hloop_A_Q(ntryL,G0H16(1),16,nMB,G1H16(50),n2h16(220))
  Gcoeff(:)%j = (-(c(20)*M(9,:)%j)) * den(98)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(347),h0tab(:,347),[16,7,8],[0,0,0],3,1,wf8(:,32))
  call Hloop_QV_A(ntryL,G0H32(1),ex5(:),G0H16(1),m3h2x16(:,221),heltab2x32(:,:,347))
  call Hloop_Q_A(ntryL,G0H16(1),16,0,G1H16(51),n2h16(221))
  Gcoeff(:)%j = (-(c(19)*M(9,:)%j)) * den(98)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(348),h0tab(:,348),[16,7,8],[nMB,nMB,nMB],3,1,wf8(:,32))
  call Hloop_QV_A(ntryL,G0H32(1),ex5(:),G0H16(1),m3h2x16(:,222),heltab2x32(:,:,348))
  call Hloop_Q_A(ntryL,G0H16(1),16,nMB,G1H16(52),n2h16(222))
  Gcoeff(:)%j = (-(c(10)*M(6,:)%j)) * den(62)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(349),h0tab(:,349),[16,2,13],[nMT,nMH,nMT],3,1,wf8(:,73))
  call Hloop_QV_A(ntryL,G0H32(1),ex5(:),G0H16(1),m3h2x16(:,223),heltab2x32(:,:,349))
  call Hloop_Q_A(ntryL,G0H16(1),16,nMT,G1H16(53),n2h16(223))
  Gcoeff(:)%j = (c(10)*M(6,:)%j) * den(62)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(350),h0tab(:,350),[16,2,13],[nMT,nMZ,nMT],3,1,wf8(:,73))
  call Hloop_QV_A(ntryL,G0H32(1),ex5(:),G0H16(1),m3h2x16(:,224),heltab2x32(:,:,350))
  call Hloop_Q_A(ntryL,G0H16(1),16,nMT,G1H16(54),n2h16(224))
  Gcoeff(:)%j = (c(8)*M(6,:)%j) * den(62)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(351),h0tab(:,351),[16,2,13],[nMB,nMW,nMB],3,1,wf8(:,73))
  call Hloop_QV_A(ntryL,G0H32(1),ex5(:),G0H16(1),m3h2x16(:,225),heltab2x32(:,:,351))
  call Hloop_Q_A(ntryL,G0H16(1),16,nMB,G1H16(55),n2h16(225))
  Gcoeff(:)%j = (c(3)*M(6,:)%j) * den(62)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(352),h0tab(:,352),[16,2,13],[nMT,0,nMT],3,1,wf8(:,73))
  call Hloop_QV_A(ntryL,G0H32(1),ex5(:),G0H16(1),m3h2x16(:,226),heltab2x32(:,:,352))
  call Hloop_Q_A(ntryL,G0H16(1),16,nMT,G1H16(56),n2h16(226))
  Gcoeff(:)%j = (c(4)*M(6,:)%j) * den(62)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(353),h0tab(:,353),[16,2,13],[nMT,nMZ,nMT],3,1,wf8(:,73))
  call Hloop_QV_A(ntryL,G0H32(1),ex5(:),G0H16(1),m3h2x16(:,227),heltab2x32(:,:,353))
  call Hloop_Q_A(ntryL,G0H16(1),16,nMT,G1H16(61),n2h16(227))
  Gcoeff(:)%j = (c(6)*M(6,:)%j) * den(62)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(354),h0tab(:,354),[16,2,13],[nMB,nMW,nMB],3,1,wf8(:,73))
  call Hloop_QV_A(ntryL,G0H32(1),ex5(:),G0H16(1),m3h2x16(:,228),heltab2x32(:,:,354))
  call Hloop_Q_A(ntryL,G0H16(1),16,nMB,G1H16(58),n2h16(228))
  Gcoeff(:)%j = (-(c(10)*M(4,:)%j)) * den(57)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(355),h0tab(:,355),[21,2,8],[nMH,nMT,nMT],3,1,wf8(:,70))
  call Hloop_AQ_S(ntryL,G0H32(1),wf8(:,70),G0H4(7),ngH,m3h8x4(:,19),heltab2x32(:,:,355))
  Gcoeff(:)%j = (c(10)*M(4,:)%j) * den(57)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(356),h0tab(:,356),[21,2,8],[nMZ,nMT,nMT],3,1,wf8(:,70))
  call Hloop_AQ_S(ntryL,G0H32(1),wf8(:,70),G0H4(8),ngX,m3h8x4(:,20),heltab2x32(:,:,356))
  Gcoeff(:)%j = (c(8)*M(4,:)%j) * den(57)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(357),h0tab(:,357),[21,2,8],[nMW,nMB,nMB],3,1,wf8(:,70))
  call Hloop_AQ_S(ntryL,G0H32(1),wf8(:,70),G0H4(9),ngPbt,m3h8x4(:,21),heltab2x32(:,:,357))
  Gcoeff(:)%j = (c(3)*M(4,:)%j) * den(57)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(358),h0tab(:,358),[21,2,8],[0,nMT,nMT],3,1,wf8(:,70))
  call Hloop_AQ_V(ntryL,G0H32(1),wf8(:,70),G0H4(10),m3h8x4(:,22),heltab2x32(:,:,358))
  Gcoeff(:)%j = (c(4)*M(4,:)%j) * den(57)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(359),h0tab(:,359),[21,2,8],[nMZ,nMT,nMT],3,1,wf8(:,70))
  call Hloop_AQ_Z(ntryL,G0H32(1),wf8(:,70),G0H4(11),ngZu,m3h8x4(:,23),heltab2x32(:,:,359))
  Gcoeff(:)%j = (c(6)*M(4,:)%j) * den(57)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(360),h0tab(:,360),[21,2,8],[nMW,nMB,nMB],3,1,wf8(:,70))
  call Hloop_AQ_W(ntryL,G0H32(1),wf8(:,70),G0H4(12),m3h8x4(:,24),heltab2x32(:,:,360))
  Gcoeff(:)%j = (-(c(10)*M(2,:)%j)) * den(16)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(361),h0tab(:,361),[16,6,9],[nMT,nMH,nMT],3,2,wf4(:,14),wf4(:,13))
  call Hloop_QV_A(ntryL,G0H32(1),ex5(:),G0H16(1),m3h2x16(:,229),heltab2x32(:,:,361))
  call Hloop_Q_A(ntryL,G0H16(1),16,nMT,G1H16(63),n2h16(229))
  Gcoeff(:)%j = (c(10)*M(2,:)%j) * den(16)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(362),h0tab(:,362),[16,6,9],[nMT,nMZ,nMT],3,2,wf4(:,14),wf4(:,13))
  call Hloop_QV_A(ntryL,G0H32(1),ex5(:),G0H16(1),m3h2x16(:,230),heltab2x32(:,:,362))
  call Hloop_Q_A(ntryL,G0H16(1),16,nMT,G1H16(60),n2h16(230))
  Gcoeff(:)%j = (c(8)*M(2,:)%j) * den(16)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(363),h0tab(:,363),[16,6,9],[nMB,nMW,nMB],3,2,wf4(:,14),wf4(:,13))
  call Hloop_QV_A(ntryL,G0H32(1),ex5(:),G0H16(1),m3h2x16(:,231),heltab2x32(:,:,363))
  call Hloop_Q_A(ntryL,G0H16(1),16,nMB,G1H16(62),n2h16(231))
  Gcoeff(:)%j = (c(3)*M(2,:)%j) * den(16)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(364),h0tab(:,364),[16,6,9],[nMT,0,nMT],3,2,wf4(:,14),wf4(:,13))
  call Hloop_QV_A(ntryL,G0H32(1),ex5(:),G0H16(1),m3h2x16(:,232),heltab2x32(:,:,364))
  call Hloop_Q_A(ntryL,G0H16(1),16,nMT,G1H16(64),n2h16(232))
  Gcoeff(:)%j = (c(4)*M(2,:)%j) * den(16)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(365),h0tab(:,365),[16,6,9],[nMT,nMZ,nMT],3,2,wf4(:,14),wf4(:,13))
  call Hloop_QV_A(ntryL,G0H32(1),ex5(:),G0H16(1),m3h2x16(:,233),heltab2x32(:,:,365))
  call Hloop_Q_A(ntryL,G0H16(1),16,nMT,G1H16(65),n2h16(233))
  Gcoeff(:)%j = (c(6)*M(2,:)%j) * den(16)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(366),h0tab(:,366),[16,6,9],[nMB,nMW,nMB],3,2,wf4(:,14),wf4(:,13))
  call Hloop_QV_A(ntryL,G0H32(1),ex5(:),G0H16(1),m3h2x16(:,234),heltab2x32(:,:,366))
  call Hloop_Q_A(ntryL,G0H16(1),16,nMB,G1H16(66),n2h16(234))
  Gcoeff(:)%j = (-(c(10)*M(1,:)%j)) * den(18)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(367),h0tab(:,367),[17,6,8],[nMH,nMT,nMT],3,2,wf4(:,16),wf4(:,14))
  call Hloop_AQ_S(ntryL,G0H32(1),wf4(:,16),G0H8(7),ngH,m3h4x8(:,109),heltab2x32(:,:,367))
  Gcoeff(:)%j = (c(10)*M(1,:)%j) * den(18)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(368),h0tab(:,368),[17,6,8],[nMZ,nMT,nMT],3,2,wf4(:,16),wf4(:,14))
  call Hloop_AQ_S(ntryL,G0H32(1),wf4(:,16),G0H8(8),ngX,m3h4x8(:,110),heltab2x32(:,:,368))
  Gcoeff(:)%j = (c(8)*M(1,:)%j) * den(18)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(369),h0tab(:,369),[17,6,8],[nMW,nMB,nMB],3,2,wf4(:,16),wf4(:,14))
  call Hloop_AQ_S(ntryL,G0H32(1),wf4(:,16),G0H8(9),ngPbt,m3h4x8(:,111),heltab2x32(:,:,369))
  Gcoeff(:)%j = (c(3)*M(1,:)%j) * den(18)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(370),h0tab(:,370),[17,6,8],[0,nMT,nMT],3,2,wf4(:,16),wf4(:,14))
  call Hloop_AQ_V(ntryL,G0H32(1),wf4(:,16),G0H8(10),m3h4x8(:,112),heltab2x32(:,:,370))
  Gcoeff(:)%j = (c(4)*M(1,:)%j) * den(18)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(371),h0tab(:,371),[17,6,8],[nMZ,nMT,nMT],3,2,wf4(:,16),wf4(:,14))
  call Hloop_AQ_Z(ntryL,G0H32(1),wf4(:,16),G0H8(11),ngZu,m3h4x8(:,113),heltab2x32(:,:,371))
  Gcoeff(:)%j = (c(6)*M(1,:)%j) * den(18)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(372),h0tab(:,372),[17,6,8],[nMW,nMB,nMB],3,2,wf4(:,16),wf4(:,14))
  call Hloop_AQ_W(ntryL,G0H32(1),wf4(:,16),G0H8(12),m3h4x8(:,114),heltab2x32(:,:,372))
  Gcoeff(:)%j = (c(9)*(M(1,:)%j-M(2,:)%j)) * den(19)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(373),h0tab(:,373),[24,1,6],[nMT,nMH,nMT],3,2,wf4(:,4),wf4(:,14))
  call Hloop_AV_Q(ntryL,G0H32(1),wf4(:,4),G0H8(13),m3h4x8(:,115),heltab2x32(:,:,373))
  call Hloop_A_Q(ntryL,G0H8(13),24,nMT,G1H8(24),n2h8(147))
  Gcoeff(:)%j = (c(9)*(-M(1,:)%j+M(2,:)%j)) * den(19)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(374),h0tab(:,374),[24,1,6],[nMT,nMZ,nMT],3,2,wf4(:,4),wf4(:,14))
  call Hloop_AV_Q(ntryL,G0H32(1),wf4(:,4),G0H8(14),m3h4x8(:,116),heltab2x32(:,:,374))
  call Hloop_A_Q(ntryL,G0H8(14),24,nMT,G1H8(61),n2h8(148))
  Gcoeff(:)%j = (c(7)*(-M(1,:)%j+M(2,:)%j)) * den(19)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(375),h0tab(:,375),[24,1,6],[nMB,nMW,nMB],3,2,wf4(:,4),wf4(:,14))
  call Hloop_AV_Q(ntryL,G0H32(1),wf4(:,4),G0H8(15),m3h4x8(:,117),heltab2x32(:,:,375))
  call Hloop_A_Q(ntryL,G0H8(15),24,nMB,G1H8(62),n2h8(149))
  Gcoeff(:)%j = (c(1)*(-M(1,:)%j+M(2,:)%j)) * den(19)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(376),h0tab(:,376),[24,1,6],[nMT,0,nMT],3,2,wf4(:,4),wf4(:,14))
  call Hloop_AV_Q(ntryL,G0H32(1),wf4(:,4),G0H8(16),m3h4x8(:,118),heltab2x32(:,:,376))
  call Hloop_A_Q(ntryL,G0H8(16),24,nMT,G1H8(63),n2h8(150))
  Gcoeff(:)%j = (c(2)*(-M(1,:)%j+M(2,:)%j)) * den(19)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(377),h0tab(:,377),[24,1,6],[nMT,nMZ,nMT],3,2,wf4(:,4),wf4(:,14))
  call Hloop_AV_Q(ntryL,G0H32(1),wf4(:,4),G0H8(17),m3h4x8(:,119),heltab2x32(:,:,377))
  call Hloop_A_Q(ntryL,G0H8(17),24,nMT,G1H8(65),n2h8(151))
  Gcoeff(:)%j = (c(5)*(-M(1,:)%j+M(2,:)%j)) * den(19)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(378),h0tab(:,378),[24,1,6],[nMB,nMW,nMB],3,2,wf4(:,4),wf4(:,14))
  call Hloop_AV_Q(ntryL,G0H32(1),wf4(:,4),G0H8(18),m3h4x8(:,120),heltab2x32(:,:,378))
  call Hloop_A_Q(ntryL,G0H8(18),24,nMB,G1H8(66),n2h8(152))
  Gcoeff(:)%j = (c(24)*M(9,:)%j) * den(101)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(379),h0tab(:,379),[16,7,8],[nMT,nMT,nMT],3,1,wf8(:,35))
  call Hloop_AV_Q(ntryL,G0H32(1),ex5(:),G0H16(1),m3h2x16(:,235),heltab2x32(:,:,379))
  call Hloop_A_Q(ntryL,G0H16(1),16,nMT,G1H16(67),n2h16(235))
  Gcoeff(:)%j = (c(24)*M(9,:)%j) * den(101)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(380),h0tab(:,380),[16,7,8],[nMT,nMT,nMT],3,1,wf8(:,35))
  call Hloop_QV_A(ntryL,G0H32(1),ex5(:),G0H16(1),m3h2x16(:,236),heltab2x32(:,:,380))
  call Hloop_Q_A(ntryL,G0H16(1),16,nMT,G1H16(68),n2h16(236))
  Gcoeff(:)%j = (c(22)*M(9,:)%j) * den(101)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(381),h0tab(:,381),[16,7,8],[nMB,nMB,nMB],3,1,wf8(:,35))
  call Hloop_AV_Q(ntryL,G0H32(1),ex5(:),G0H16(1),m3h2x16(:,237),heltab2x32(:,:,381))
  call Hloop_A_Q(ntryL,G0H16(1),16,nMB,G1H16(69),n2h16(237))
  Gcoeff(:)%j = (c(22)*M(9,:)%j) * den(101)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(382),h0tab(:,382),[16,7,8],[nMB,nMB,nMB],3,1,wf8(:,35))
  call Hloop_QV_A(ntryL,G0H32(1),ex5(:),G0H16(1),m3h2x16(:,238),heltab2x32(:,:,382))
  call Hloop_Q_A(ntryL,G0H16(1),16,nMB,G1H16(70),n2h16(238))
  Gcoeff(:)%j = (-(c(24)*M(9,:)%j)) * den(102)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(383),h0tab(:,383),[16,7,8],[nMT,nMT,nMT],3,1,wf8(:,99))
  call Hloop_AV_Q(ntryL,G0H32(1),ex5(:),G0H16(1),m3h2x16(:,239),heltab2x32(:,:,383))
  call Hloop_A_Q(ntryL,G0H16(1),16,nMT,G1H16(71),n2h16(239))
  Gcoeff(:)%j = (-(c(24)*M(9,:)%j)) * den(102)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(384),h0tab(:,384),[16,7,8],[nMT,nMT,nMT],3,1,wf8(:,99))
  call Hloop_QV_A(ntryL,G0H32(1),ex5(:),G0H16(1),m3h2x16(:,240),heltab2x32(:,:,384))
  call Hloop_Q_A(ntryL,G0H16(1),16,nMT,G1H16(72),n2h16(240))
  Gcoeff(:)%j = (c(22)*M(9,:)%j) * den(102)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(385),h0tab(:,385),[16,7,8],[nMB,nMB,nMB],3,1,wf8(:,99))
  call Hloop_AV_Q(ntryL,G0H32(1),ex5(:),G0H16(1),m3h2x16(:,241),heltab2x32(:,:,385))
  call Hloop_A_Q(ntryL,G0H16(1),16,nMB,G1H16(73),n2h16(241))
  Gcoeff(:)%j = (c(22)*M(9,:)%j) * den(102)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(386),h0tab(:,386),[16,7,8],[nMB,nMB,nMB],3,1,wf8(:,99))
  call Hloop_QV_A(ntryL,G0H32(1),ex5(:),G0H16(1),m3h2x16(:,242),heltab2x32(:,:,386))
  call Hloop_Q_A(ntryL,G0H16(1),16,nMB,G1H16(74),n2h16(242))
  Gcoeff(:)%j = (-(c(18)*M(9,:)%j)) * den(103)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(387),h0tab(:,387),[16,7,8],[0,0,0],3,1,wf8(:,12))
  call Hloop_AV_Q(ntryL,G0H32(1),ex5(:),G0H16(1),m3h2x16(:,243),heltab2x32(:,:,387))
  call Hloop_A_Q(ntryL,G0H16(1),16,0,G1H16(75),n2h16(243))
  Gcoeff(:)%j = (-(c(17)*M(9,:)%j)) * den(103)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(388),h0tab(:,388),[16,7,8],[nMT,nMT,nMT],3,1,wf8(:,12))
  call Hloop_AV_Q(ntryL,G0H32(1),ex5(:),G0H16(1),m3h2x16(:,244),heltab2x32(:,:,388))
  call Hloop_A_Q(ntryL,G0H16(1),16,nMT,G1H16(76),n2h16(244))
  Gcoeff(:)%j = (-(c(18)*M(9,:)%j)) * den(103)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(389),h0tab(:,389),[16,7,8],[0,0,0],3,1,wf8(:,12))
  call Hloop_QV_A(ntryL,G0H32(1),ex5(:),G0H16(1),m3h2x16(:,245),heltab2x32(:,:,389))
  call Hloop_Q_A(ntryL,G0H16(1),16,0,G1H16(77),n2h16(245))
  Gcoeff(:)%j = (-(c(17)*M(9,:)%j)) * den(103)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(390),h0tab(:,390),[16,7,8],[nMT,nMT,nMT],3,1,wf8(:,12))
  call Hloop_QV_A(ntryL,G0H32(1),ex5(:),G0H16(1),m3h2x16(:,246),heltab2x32(:,:,390))
  call Hloop_Q_A(ntryL,G0H16(1),16,nMT,G1H16(78),n2h16(246))
  Gcoeff(:)%j = (c(17)*M(9,:)%j) * den(103)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(391),h0tab(:,391),[16,7,8],[0,0,0],3,1,wf8(:,12))
  call Hloop_AV_Q(ntryL,G0H32(1),ex5(:),G0H16(1),m3h2x16(:,247),heltab2x32(:,:,391))
  call Hloop_A_Q(ntryL,G0H16(1),16,0,G1H16(79),n2h16(247))
  Gcoeff(:)%j = (c(16)*M(9,:)%j) * den(103)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(392),h0tab(:,392),[16,7,8],[nMB,nMB,nMB],3,1,wf8(:,12))
  call Hloop_AV_Q(ntryL,G0H32(1),ex5(:),G0H16(1),m3h2x16(:,248),heltab2x32(:,:,392))
  call Hloop_A_Q(ntryL,G0H16(1),16,nMB,G1H16(80),n2h16(248))
  Gcoeff(:)%j = (c(17)*M(9,:)%j) * den(103)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(393),h0tab(:,393),[16,7,8],[0,0,0],3,1,wf8(:,12))
  call Hloop_QV_A(ntryL,G0H32(1),ex5(:),G0H16(1),m3h2x16(:,249),heltab2x32(:,:,393))
  call Hloop_Q_A(ntryL,G0H16(1),16,0,G1H16(81),n2h16(249))
  Gcoeff(:)%j = (c(16)*M(9,:)%j) * den(103)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(394),h0tab(:,394),[16,7,8],[nMB,nMB,nMB],3,1,wf8(:,12))
  call Hloop_QV_A(ntryL,G0H32(1),ex5(:),G0H16(1),m3h2x16(:,250),heltab2x32(:,:,394))
  call Hloop_Q_A(ntryL,G0H16(1),16,nMB,G1H16(82),n2h16(250))
  Gcoeff(:)%j = (-(c(20)*M(9,:)%j)) * den(102)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(395),h0tab(:,395),[16,7,8],[0,0,0],3,1,wf8(:,36))
  call Hloop_AV_Q(ntryL,G0H32(1),ex5(:),G0H16(1),m3h2x16(:,251),heltab2x32(:,:,395))
  call Hloop_A_Q(ntryL,G0H16(1),16,0,G1H16(83),n2h16(251))
  Gcoeff(:)%j = (-(c(19)*M(9,:)%j)) * den(102)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(396),h0tab(:,396),[16,7,8],[nMT,nMT,nMT],3,1,wf8(:,36))
  call Hloop_AV_Q(ntryL,G0H32(1),ex5(:),G0H16(1),m3h2x16(:,252),heltab2x32(:,:,396))
  call Hloop_A_Q(ntryL,G0H16(1),16,nMT,G1H16(84),n2h16(252))
  Gcoeff(:)%j = (-(c(20)*M(9,:)%j)) * den(102)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(397),h0tab(:,397),[16,7,8],[0,0,0],3,1,wf8(:,36))
  call Hloop_QV_A(ntryL,G0H32(1),ex5(:),G0H16(1),m3h2x16(:,253),heltab2x32(:,:,397))
  call Hloop_Q_A(ntryL,G0H16(1),16,0,G1H16(85),n2h16(253))
  Gcoeff(:)%j = (-(c(19)*M(9,:)%j)) * den(102)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(398),h0tab(:,398),[16,7,8],[nMT,nMT,nMT],3,1,wf8(:,36))
  call Hloop_QV_A(ntryL,G0H32(1),ex5(:),G0H16(1),m3h2x16(:,254),heltab2x32(:,:,398))
  call Hloop_Q_A(ntryL,G0H16(1),16,nMT,G1H16(86),n2h16(254))
  Gcoeff(:)%j = (-(c(20)*M(9,:)%j)) * den(102)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(399),h0tab(:,399),[16,7,8],[0,0,0],3,1,wf8(:,36))
  call Hloop_AV_Q(ntryL,G0H32(1),ex5(:),G0H16(1),m3h2x16(:,255),heltab2x32(:,:,399))
  call Hloop_A_Q(ntryL,G0H16(1),16,0,G1H16(87),n2h16(255))
  Gcoeff(:)%j = (-(c(19)*M(9,:)%j)) * den(102)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(400),h0tab(:,400),[16,7,8],[nMB,nMB,nMB],3,1,wf8(:,36))
  call Hloop_AV_Q(ntryL,G0H32(1),ex5(:),G0H16(1),m3h2x16(:,256),heltab2x32(:,:,400))
  call Hloop_A_Q(ntryL,G0H16(1),16,nMB,G1H16(88),n2h16(256))
  Gcoeff(:)%j = (-(c(20)*M(9,:)%j)) * den(102)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(401),h0tab(:,401),[16,7,8],[0,0,0],3,1,wf8(:,36))
  call Hloop_QV_A(ntryL,G0H32(1),ex5(:),G0H16(1),m3h2x16(:,257),heltab2x32(:,:,401))
  call Hloop_Q_A(ntryL,G0H16(1),16,0,G1H16(89),n2h16(257))
  Gcoeff(:)%j = (-(c(19)*M(9,:)%j)) * den(102)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(402),h0tab(:,402),[16,7,8],[nMB,nMB,nMB],3,1,wf8(:,36))
  call Hloop_QV_A(ntryL,G0H32(1),ex5(:),G0H16(1),m3h2x16(:,258),heltab2x32(:,:,402))
  call Hloop_Q_A(ntryL,G0H16(1),16,nMB,G1H16(90),n2h16(258))
  Gcoeff(:)%j = (-(c(10)*M(1,:)%j)) * den(73)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(403),h0tab(:,403),[16,1,14],[nMT,nMH,nMT],3,1,wf8(:,80))
  call Hloop_AV_Q(ntryL,G0H32(1),ex5(:),G0H16(1),m3h2x16(:,259),heltab2x32(:,:,403))
  call Hloop_A_Q(ntryL,G0H16(1),16,nMT,G1H16(91),n2h16(259))
  Gcoeff(:)%j = (c(10)*M(1,:)%j) * den(73)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(404),h0tab(:,404),[16,1,14],[nMT,nMZ,nMT],3,1,wf8(:,80))
  call Hloop_AV_Q(ntryL,G0H32(1),ex5(:),G0H16(1),m3h2x16(:,260),heltab2x32(:,:,404))
  call Hloop_A_Q(ntryL,G0H16(1),16,nMT,G1H16(92),n2h16(260))
  Gcoeff(:)%j = (c(8)*M(1,:)%j) * den(73)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(405),h0tab(:,405),[16,1,14],[nMB,nMW,nMB],3,1,wf8(:,80))
  call Hloop_AV_Q(ntryL,G0H32(1),ex5(:),G0H16(1),m3h2x16(:,261),heltab2x32(:,:,405))
  call Hloop_A_Q(ntryL,G0H16(1),16,nMB,G1H16(93),n2h16(261))
  Gcoeff(:)%j = (c(3)*M(1,:)%j) * den(73)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(406),h0tab(:,406),[16,1,14],[nMT,0,nMT],3,1,wf8(:,80))
  call Hloop_AV_Q(ntryL,G0H32(1),ex5(:),G0H16(1),m3h2x16(:,262),heltab2x32(:,:,406))
  call Hloop_A_Q(ntryL,G0H16(1),16,nMT,G1H16(94),n2h16(262))
  Gcoeff(:)%j = (c(4)*M(1,:)%j) * den(73)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(407),h0tab(:,407),[16,1,14],[nMT,nMZ,nMT],3,1,wf8(:,80))
  call Hloop_AV_Q(ntryL,G0H32(1),ex5(:),G0H16(1),m3h2x16(:,263),heltab2x32(:,:,407))
  call Hloop_A_Q(ntryL,G0H16(1),16,nMT,G1H16(95),n2h16(263))
  Gcoeff(:)%j = (c(6)*M(1,:)%j) * den(73)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(408),h0tab(:,408),[16,1,14],[nMB,nMW,nMB],3,1,wf8(:,80))
  call Hloop_AV_Q(ntryL,G0H32(1),ex5(:),G0H16(1),m3h2x16(:,264),heltab2x32(:,:,408))
  call Hloop_A_Q(ntryL,G0H16(1),16,nMB,G1H16(96),n2h16(264))
  Gcoeff(:)%j = (-(c(10)*M(2,:)%j)) * den(67)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(409),h0tab(:,409),[22,1,8],[nMH,nMT,nMT],3,1,wf8(:,77))
  call Hloop_QA_S(ntryL,G0H32(1),wf8(:,77),G0H4(1),ngH,m3h8x4(:,25),heltab2x32(:,:,409))
  Gcoeff(:)%j = (c(10)*M(2,:)%j) * den(67)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(410),h0tab(:,410),[22,1,8],[nMZ,nMT,nMT],3,1,wf8(:,77))
  call Hloop_QA_S(ntryL,G0H32(1),wf8(:,77),G0H4(2),ngX,m3h8x4(:,26),heltab2x32(:,:,410))
  Gcoeff(:)%j = (c(8)*M(2,:)%j) * den(67)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(411),h0tab(:,411),[22,1,8],[nMW,nMB,nMB],3,1,wf8(:,77))
  call Hloop_QA_S(ntryL,G0H32(1),wf8(:,77),G0H4(3),ngPtb,m3h8x4(:,27),heltab2x32(:,:,411))
  Gcoeff(:)%j = (c(3)*M(2,:)%j) * den(67)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(412),h0tab(:,412),[22,1,8],[0,nMT,nMT],3,1,wf8(:,77))
  call Hloop_QA_V(ntryL,G0H32(1),wf8(:,77),G0H4(4),m3h8x4(:,28),heltab2x32(:,:,412))
  Gcoeff(:)%j = (c(4)*M(2,:)%j) * den(67)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(413),h0tab(:,413),[22,1,8],[nMZ,nMT,nMT],3,1,wf8(:,77))
  call Hloop_QA_Z(ntryL,G0H32(1),wf8(:,77),G0H4(5),ngZu,m3h8x4(:,29),heltab2x32(:,:,413))
  Gcoeff(:)%j = (c(6)*M(2,:)%j) * den(67)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(414),h0tab(:,414),[22,1,8],[nMW,nMB,nMB],3,1,wf8(:,77))
  call Hloop_QA_W(ntryL,G0H32(1),wf8(:,77),G0H4(6),m3h8x4(:,30),heltab2x32(:,:,414))
  Gcoeff(:)%j = (-(c(10)*M(5,:)%j)) * den(20)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(415),h0tab(:,415),[18,4,9],[nMT,nMT,nMH],3,2,wf4(:,10),wf4(:,13))
  call Hloop_SA_Q(ntryL,G0H32(1),wf4(:,10),G0H8(19),ngH,m3h4x8(:,121),heltab2x32(:,:,415))
  call Hloop_A_Q(ntryL,G0H8(19),18,nMT,G1H8(67),n2h8(153))
  Gcoeff(:)%j = (c(10)*M(5,:)%j) * den(20)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(416),h0tab(:,416),[18,4,9],[nMT,nMT,nMZ],3,2,wf4(:,10),wf4(:,13))
  call Hloop_SA_Q(ntryL,G0H32(1),wf4(:,10),G0H8(1),ngX,m3h4x8(:,122),heltab2x32(:,:,416))
  call Hloop_A_Q(ntryL,G0H8(1),18,nMT,G1H8(68),n2h8(154))
  Gcoeff(:)%j = (c(8)*M(5,:)%j) * den(20)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(417),h0tab(:,417),[18,4,9],[nMB,nMB,nMW],3,2,wf4(:,10),wf4(:,13))
  call Hloop_SA_Q(ntryL,G0H32(1),wf4(:,10),G0H8(2),ngPtb,m3h4x8(:,123),heltab2x32(:,:,417))
  call Hloop_A_Q(ntryL,G0H8(2),18,nMB,G1H8(70),n2h8(155))
  Gcoeff(:)%j = (c(3)*M(5,:)%j) * den(20)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(418),h0tab(:,418),[18,4,9],[nMT,nMT,0],3,2,wf4(:,10),wf4(:,13))
  call Hloop_VA_Q(ntryL,G0H32(1),wf4(:,10),G0H8(3),m3h4x8(:,124),heltab2x32(:,:,418))
  call Hloop_A_Q(ntryL,G0H8(3),18,nMT,G1H8(71),n2h8(156))
  Gcoeff(:)%j = (c(4)*M(5,:)%j) * den(20)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(419),h0tab(:,419),[18,4,9],[nMT,nMT,nMZ],3,2,wf4(:,10),wf4(:,13))
  call Hloop_ZA_Q(ntryL,G0H32(1),wf4(:,10),G0H8(4),ngZu,m3h4x8(:,125),heltab2x32(:,:,419))
  call Hloop_A_Q(ntryL,G0H8(4),18,nMT,G1H8(72),n2h8(157))
  Gcoeff(:)%j = (c(6)*M(5,:)%j) * den(20)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(420),h0tab(:,420),[18,4,9],[nMB,nMB,nMW],3,2,wf4(:,10),wf4(:,13))
  call Hloop_WA_Q(ntryL,G0H32(1),wf4(:,10),G0H8(5),m3h4x8(:,126),heltab2x32(:,:,420))
  call Hloop_A_Q(ntryL,G0H8(5),18,nMB,G1H8(73),n2h8(158))
  Gcoeff(:)%j = (c(9)*(M(2,:)%j-M(5,:)%j)) * den(21)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(421),h0tab(:,421),[20,2,9],[nMT,nMH,nMT],3,2,wf4(:,3),wf4(:,13))
  call Hloop_QV_A(ntryL,G0H32(1),wf4(:,3),G0H8(6),m3h4x8(:,127),heltab2x32(:,:,421))
  call Hloop_Q_A(ntryL,G0H8(6),20,nMT,G1H8(75),n2h8(159))
  Gcoeff(:)%j = (c(9)*(-M(2,:)%j+M(5,:)%j)) * den(21)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(422),h0tab(:,422),[20,2,9],[nMT,nMZ,nMT],3,2,wf4(:,3),wf4(:,13))
  call Hloop_QV_A(ntryL,G0H32(1),wf4(:,3),G0H8(13),m3h4x8(:,128),heltab2x32(:,:,422))
  call Hloop_Q_A(ntryL,G0H8(13),20,nMT,G1H8(76),n2h8(160))
  Gcoeff(:)%j = (c(7)*(-M(2,:)%j+M(5,:)%j)) * den(21)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(423),h0tab(:,423),[20,2,9],[nMB,nMW,nMB],3,2,wf4(:,3),wf4(:,13))
  call Hloop_QV_A(ntryL,G0H32(1),wf4(:,3),G0H8(14),m3h4x8(:,129),heltab2x32(:,:,423))
  call Hloop_Q_A(ntryL,G0H8(14),20,nMB,G1H8(77),n2h8(161))
  Gcoeff(:)%j = (c(1)*(-M(2,:)%j+M(5,:)%j)) * den(21)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(424),h0tab(:,424),[20,2,9],[nMT,0,nMT],3,2,wf4(:,3),wf4(:,13))
  call Hloop_QV_A(ntryL,G0H32(1),wf4(:,3),G0H8(15),m3h4x8(:,130),heltab2x32(:,:,424))
  call Hloop_Q_A(ntryL,G0H8(15),20,nMT,G1H8(78),n2h8(162))
  Gcoeff(:)%j = (c(2)*(-M(2,:)%j+M(5,:)%j)) * den(21)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(425),h0tab(:,425),[20,2,9],[nMT,nMZ,nMT],3,2,wf4(:,3),wf4(:,13))
  call Hloop_QV_A(ntryL,G0H32(1),wf4(:,3),G0H8(16),m3h4x8(:,131),heltab2x32(:,:,425))
  call Hloop_Q_A(ntryL,G0H8(16),20,nMT,G1H8(80),n2h8(163))
  Gcoeff(:)%j = (c(5)*(-M(2,:)%j+M(5,:)%j)) * den(21)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(426),h0tab(:,426),[20,2,9],[nMB,nMW,nMB],3,2,wf4(:,3),wf4(:,13))
  call Hloop_QV_A(ntryL,G0H32(1),wf4(:,3),G0H8(17),m3h4x8(:,132),heltab2x32(:,:,426))
  call Hloop_Q_A(ntryL,G0H8(17),20,nMB,G1H8(81),n2h8(164))
  Gcoeff(:)%j = (c(24)*M(8,:)%j) * den(105)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(427),h0tab(:,427),[16,4,11],[nMT,nMT,nMT],3,1,wf8(:,38))
  call Hloop_QV_A(ntryL,G0H32(1),ex5(:),G0H16(1),m3h2x16(:,265),heltab2x32(:,:,427))
  call Hloop_Q_A(ntryL,G0H16(1),16,nMT,G1H16(97),n2h16(265))
  Gcoeff(:)%j = (c(24)*M(8,:)%j) * den(105)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(428),h0tab(:,428),[16,4,11],[nMT,nMT,nMT],3,1,wf8(:,38))
  call Hloop_AV_Q(ntryL,G0H32(1),ex5(:),G0H16(1),m3h2x16(:,266),heltab2x32(:,:,428))
  call Hloop_A_Q(ntryL,G0H16(1),16,nMT,G1H16(98),n2h16(266))
  Gcoeff(:)%j = (c(22)*M(8,:)%j) * den(105)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(429),h0tab(:,429),[16,4,11],[nMB,nMB,nMB],3,1,wf8(:,38))
  call Hloop_QV_A(ntryL,G0H32(1),ex5(:),G0H16(1),m3h2x16(:,267),heltab2x32(:,:,429))
  call Hloop_Q_A(ntryL,G0H16(1),16,nMB,G1H16(99),n2h16(267))
  Gcoeff(:)%j = (c(22)*M(8,:)%j) * den(105)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(430),h0tab(:,430),[16,4,11],[nMB,nMB,nMB],3,1,wf8(:,38))
  call Hloop_AV_Q(ntryL,G0H32(1),ex5(:),G0H16(1),m3h2x16(:,268),heltab2x32(:,:,430))
  call Hloop_A_Q(ntryL,G0H16(1),16,nMB,G1H16(100),n2h16(268))
  Gcoeff(:)%j = (-(c(24)*M(8,:)%j)) * den(107)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(431),h0tab(:,431),[16,4,11],[nMT,nMT,nMT],3,1,wf8(:,100))
  call Hloop_QV_A(ntryL,G0H32(1),ex5(:),G0H16(1),m3h2x16(:,269),heltab2x32(:,:,431))
  call Hloop_Q_A(ntryL,G0H16(1),16,nMT,G1H16(101),n2h16(269))
  Gcoeff(:)%j = (-(c(24)*M(8,:)%j)) * den(107)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(432),h0tab(:,432),[16,4,11],[nMT,nMT,nMT],3,1,wf8(:,100))
  call Hloop_AV_Q(ntryL,G0H32(1),ex5(:),G0H16(1),m3h2x16(:,270),heltab2x32(:,:,432))
  call Hloop_A_Q(ntryL,G0H16(1),16,nMT,G1H16(102),n2h16(270))
  Gcoeff(:)%j = (c(22)*M(8,:)%j) * den(107)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(433),h0tab(:,433),[16,4,11],[nMB,nMB,nMB],3,1,wf8(:,100))
  call Hloop_QV_A(ntryL,G0H32(1),ex5(:),G0H16(1),m3h2x16(:,271),heltab2x32(:,:,433))
  call Hloop_Q_A(ntryL,G0H16(1),16,nMB,G1H16(103),n2h16(271))
  Gcoeff(:)%j = (c(22)*M(8,:)%j) * den(107)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(434),h0tab(:,434),[16,4,11],[nMB,nMB,nMB],3,1,wf8(:,100))
  call Hloop_AV_Q(ntryL,G0H32(1),ex5(:),G0H16(1),m3h2x16(:,272),heltab2x32(:,:,434))
  call Hloop_A_Q(ntryL,G0H16(1),16,nMB,G1H16(104),n2h16(272))
  Gcoeff(:)%j = (-(c(18)*M(8,:)%j)) * den(109)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(435),h0tab(:,435),[16,4,11],[0,0,0],3,1,wf8(:,14))
  call Hloop_QV_A(ntryL,G0H32(1),ex5(:),G0H16(1),m3h2x16(:,273),heltab2x32(:,:,435))
  call Hloop_Q_A(ntryL,G0H16(1),16,0,G1H16(105),n2h16(273))
  Gcoeff(:)%j = (-(c(17)*M(8,:)%j)) * den(109)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(436),h0tab(:,436),[16,4,11],[nMT,nMT,nMT],3,1,wf8(:,14))
  call Hloop_QV_A(ntryL,G0H32(1),ex5(:),G0H16(1),m3h2x16(:,274),heltab2x32(:,:,436))
  call Hloop_Q_A(ntryL,G0H16(1),16,nMT,G1H16(106),n2h16(274))
  Gcoeff(:)%j = (-(c(18)*M(8,:)%j)) * den(109)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(437),h0tab(:,437),[16,4,11],[0,0,0],3,1,wf8(:,14))
  call Hloop_AV_Q(ntryL,G0H32(1),ex5(:),G0H16(1),m3h2x16(:,275),heltab2x32(:,:,437))
  call Hloop_A_Q(ntryL,G0H16(1),16,0,G1H16(107),n2h16(275))
  Gcoeff(:)%j = (-(c(17)*M(8,:)%j)) * den(109)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(438),h0tab(:,438),[16,4,11],[nMT,nMT,nMT],3,1,wf8(:,14))
  call Hloop_AV_Q(ntryL,G0H32(1),ex5(:),G0H16(1),m3h2x16(:,276),heltab2x32(:,:,438))
  call Hloop_A_Q(ntryL,G0H16(1),16,nMT,G1H16(108),n2h16(276))
  Gcoeff(:)%j = (c(17)*M(8,:)%j) * den(109)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(439),h0tab(:,439),[16,4,11],[0,0,0],3,1,wf8(:,14))
  call Hloop_QV_A(ntryL,G0H32(1),ex5(:),G0H16(1),m3h2x16(:,277),heltab2x32(:,:,439))
  call Hloop_Q_A(ntryL,G0H16(1),16,0,G1H16(109),n2h16(277))
  Gcoeff(:)%j = (c(16)*M(8,:)%j) * den(109)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(440),h0tab(:,440),[16,4,11],[nMB,nMB,nMB],3,1,wf8(:,14))
  call Hloop_QV_A(ntryL,G0H32(1),ex5(:),G0H16(1),m3h2x16(:,278),heltab2x32(:,:,440))
  call Hloop_Q_A(ntryL,G0H16(1),16,nMB,G1H16(110),n2h16(278))
  Gcoeff(:)%j = (c(17)*M(8,:)%j) * den(109)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(441),h0tab(:,441),[16,4,11],[0,0,0],3,1,wf8(:,14))
  call Hloop_AV_Q(ntryL,G0H32(1),ex5(:),G0H16(1),m3h2x16(:,279),heltab2x32(:,:,441))
  call Hloop_A_Q(ntryL,G0H16(1),16,0,G1H16(111),n2h16(279))
  Gcoeff(:)%j = (c(16)*M(8,:)%j) * den(109)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(442),h0tab(:,442),[16,4,11],[nMB,nMB,nMB],3,1,wf8(:,14))
  call Hloop_AV_Q(ntryL,G0H32(1),ex5(:),G0H16(1),m3h2x16(:,280),heltab2x32(:,:,442))
  call Hloop_A_Q(ntryL,G0H16(1),16,nMB,G1H16(112),n2h16(280))
  Gcoeff(:)%j = (-(c(20)*M(8,:)%j)) * den(107)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(443),h0tab(:,443),[16,4,11],[0,0,0],3,1,wf8(:,39))
  call Hloop_QV_A(ntryL,G0H32(1),ex5(:),G0H16(1),m3h2x16(:,281),heltab2x32(:,:,443))
  call Hloop_Q_A(ntryL,G0H16(1),16,0,G1H16(113),n2h16(281))
  Gcoeff(:)%j = (-(c(19)*M(8,:)%j)) * den(107)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(444),h0tab(:,444),[16,4,11],[nMT,nMT,nMT],3,1,wf8(:,39))
  call Hloop_QV_A(ntryL,G0H32(1),ex5(:),G0H16(1),m3h2x16(:,282),heltab2x32(:,:,444))
  call Hloop_Q_A(ntryL,G0H16(1),16,nMT,G1H16(114),n2h16(282))
  Gcoeff(:)%j = (-(c(20)*M(8,:)%j)) * den(107)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(445),h0tab(:,445),[16,4,11],[0,0,0],3,1,wf8(:,39))
  call Hloop_AV_Q(ntryL,G0H32(1),ex5(:),G0H16(1),m3h2x16(:,283),heltab2x32(:,:,445))
  call Hloop_A_Q(ntryL,G0H16(1),16,0,G1H16(115),n2h16(283))
  Gcoeff(:)%j = (-(c(19)*M(8,:)%j)) * den(107)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(446),h0tab(:,446),[16,4,11],[nMT,nMT,nMT],3,1,wf8(:,39))
  call Hloop_AV_Q(ntryL,G0H32(1),ex5(:),G0H16(1),m3h2x16(:,284),heltab2x32(:,:,446))
  call Hloop_A_Q(ntryL,G0H16(1),16,nMT,G1H16(116),n2h16(284))
  Gcoeff(:)%j = (-(c(20)*M(8,:)%j)) * den(107)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(447),h0tab(:,447),[16,4,11],[0,0,0],3,1,wf8(:,39))
  call Hloop_QV_A(ntryL,G0H32(1),ex5(:),G0H16(1),m3h2x16(:,285),heltab2x32(:,:,447))
  call Hloop_Q_A(ntryL,G0H16(1),16,0,G1H16(117),n2h16(285))
  Gcoeff(:)%j = (-(c(19)*M(8,:)%j)) * den(107)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(448),h0tab(:,448),[16,4,11],[nMB,nMB,nMB],3,1,wf8(:,39))
  call Hloop_QV_A(ntryL,G0H32(1),ex5(:),G0H16(1),m3h2x16(:,286),heltab2x32(:,:,448))
  call Hloop_Q_A(ntryL,G0H16(1),16,nMB,G1H16(118),n2h16(286))
  Gcoeff(:)%j = (-(c(20)*M(8,:)%j)) * den(107)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(449),h0tab(:,449),[16,4,11],[0,0,0],3,1,wf8(:,39))
  call Hloop_AV_Q(ntryL,G0H32(1),ex5(:),G0H16(1),m3h2x16(:,287),heltab2x32(:,:,449))
  call Hloop_A_Q(ntryL,G0H16(1),16,0,G1H16(119),n2h16(287))
  Gcoeff(:)%j = (-(c(19)*M(8,:)%j)) * den(107)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(450),h0tab(:,450),[16,4,11],[nMB,nMB,nMB],3,1,wf8(:,39))
  call Hloop_AV_Q(ntryL,G0H32(1),ex5(:),G0H16(1),m3h2x16(:,288),heltab2x32(:,:,450))
  call Hloop_A_Q(ntryL,G0H16(1),16,nMB,G1H16(120),n2h16(288))
  Gcoeff(:)%j = (-(c(10)*M(5,:)%j)) * den(81)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(451),h0tab(:,451),[16,2,13],[nMT,nMH,nMT],3,1,wf8(:,86))
  call Hloop_QV_A(ntryL,G0H32(1),ex5(:),G0H16(1),m3h2x16(:,289),heltab2x32(:,:,451))
  call Hloop_Q_A(ntryL,G0H16(1),16,nMT,G1H16(121),n2h16(289))
  Gcoeff(:)%j = (c(10)*M(5,:)%j) * den(81)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(452),h0tab(:,452),[16,2,13],[nMT,nMZ,nMT],3,1,wf8(:,86))
  call Hloop_QV_A(ntryL,G0H32(1),ex5(:),G0H16(1),m3h2x16(:,290),heltab2x32(:,:,452))
  call Hloop_Q_A(ntryL,G0H16(1),16,nMT,G1H16(122),n2h16(290))
  Gcoeff(:)%j = (c(8)*M(5,:)%j) * den(81)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(453),h0tab(:,453),[16,2,13],[nMB,nMW,nMB],3,1,wf8(:,86))
  call Hloop_QV_A(ntryL,G0H32(1),ex5(:),G0H16(1),m3h2x16(:,291),heltab2x32(:,:,453))
  call Hloop_Q_A(ntryL,G0H16(1),16,nMB,G1H16(123),n2h16(291))
  Gcoeff(:)%j = (c(3)*M(5,:)%j) * den(81)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(454),h0tab(:,454),[16,2,13],[nMT,0,nMT],3,1,wf8(:,86))
  call Hloop_QV_A(ntryL,G0H32(1),ex5(:),G0H16(1),m3h2x16(:,292),heltab2x32(:,:,454))
  call Hloop_Q_A(ntryL,G0H16(1),16,nMT,G1H16(124),n2h16(292))
  Gcoeff(:)%j = (c(4)*M(5,:)%j) * den(81)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(455),h0tab(:,455),[16,2,13],[nMT,nMZ,nMT],3,1,wf8(:,86))
  call Hloop_QV_A(ntryL,G0H32(1),ex5(:),G0H16(1),m3h2x16(:,293),heltab2x32(:,:,455))
  call Hloop_Q_A(ntryL,G0H16(1),16,nMT,G1H16(125),n2h16(293))
  Gcoeff(:)%j = (c(6)*M(5,:)%j) * den(81)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(456),h0tab(:,456),[16,2,13],[nMB,nMW,nMB],3,1,wf8(:,86))
  call Hloop_QV_A(ntryL,G0H32(1),ex5(:),G0H16(1),m3h2x16(:,294),heltab2x32(:,:,456))
  call Hloop_Q_A(ntryL,G0H16(1),16,nMB,G1H16(126),n2h16(294))
  Gcoeff(:)%j = (-(c(10)*M(2,:)%j)) * den(70)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(457),h0tab(:,457),[25,2,4],[nMH,nMT,nMT],3,1,wf8(:,78))
  call Hloop_AQ_S(ntryL,G0H32(1),wf8(:,78),G0H4(13),ngH,m3h8x4(:,31),heltab2x32(:,:,457))
  Gcoeff(:)%j = (c(10)*M(2,:)%j) * den(70)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(458),h0tab(:,458),[25,2,4],[nMZ,nMT,nMT],3,1,wf8(:,78))
  call Hloop_AQ_S(ntryL,G0H32(1),wf8(:,78),G0H4(14),ngX,m3h8x4(:,32),heltab2x32(:,:,458))
  Gcoeff(:)%j = (c(8)*M(2,:)%j) * den(70)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(459),h0tab(:,459),[25,2,4],[nMW,nMB,nMB],3,1,wf8(:,78))
  call Hloop_AQ_S(ntryL,G0H32(1),wf8(:,78),G0H4(15),ngPbt,m3h8x4(:,33),heltab2x32(:,:,459))
  Gcoeff(:)%j = (c(3)*M(2,:)%j) * den(70)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(460),h0tab(:,460),[25,2,4],[0,nMT,nMT],3,1,wf8(:,78))
  call Hloop_AQ_V(ntryL,G0H32(1),wf8(:,78),G0H4(16),m3h8x4(:,34),heltab2x32(:,:,460))
  Gcoeff(:)%j = (c(4)*M(2,:)%j) * den(70)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(461),h0tab(:,461),[25,2,4],[nMZ,nMT,nMT],3,1,wf8(:,78))
  call Hloop_AQ_Z(ntryL,G0H32(1),wf8(:,78),G0H4(17),ngZu,m3h8x4(:,35),heltab2x32(:,:,461))
  Gcoeff(:)%j = (c(6)*M(2,:)%j) * den(70)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(462),h0tab(:,462),[25,2,4],[nMW,nMB,nMB],3,1,wf8(:,78))
  call Hloop_AQ_W(ntryL,G0H32(1),wf8(:,78),G0H4(18),m3h8x4(:,36),heltab2x32(:,:,462))
  Gcoeff(:)%j = (-(c(10)*M(3,:)%j)) * den(22)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(463),h0tab(:,463),[17,4,10],[nMT,nMT,nMH],3,2,wf4(:,16),wf4(:,8))
  call Hloop_SQ_A(ntryL,G0H32(1),wf4(:,16),G0H8(18),ngH,m3h4x8(:,133),heltab2x32(:,:,463))
  call Hloop_Q_A(ntryL,G0H8(18),17,nMT,G1H8(82),n2h8(165))
  Gcoeff(:)%j = (c(10)*M(3,:)%j) * den(22)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(464),h0tab(:,464),[17,4,10],[nMT,nMT,nMZ],3,2,wf4(:,16),wf4(:,8))
  call Hloop_SQ_A(ntryL,G0H32(1),wf4(:,16),G0H8(19),ngX,m3h4x8(:,134),heltab2x32(:,:,464))
  call Hloop_Q_A(ntryL,G0H8(19),17,nMT,G1H8(83),n2h8(166))
  Gcoeff(:)%j = (c(8)*M(3,:)%j) * den(22)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(465),h0tab(:,465),[17,4,10],[nMB,nMB,nMW],3,2,wf4(:,16),wf4(:,8))
  call Hloop_SQ_A(ntryL,G0H32(1),wf4(:,16),G0H8(1),ngPbt,m3h4x8(:,135),heltab2x32(:,:,465))
  call Hloop_Q_A(ntryL,G0H8(1),17,nMB,G1H8(85),n2h8(167))
  Gcoeff(:)%j = (c(3)*M(3,:)%j) * den(22)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(466),h0tab(:,466),[17,4,10],[nMT,nMT,0],3,2,wf4(:,16),wf4(:,8))
  call Hloop_VQ_A(ntryL,G0H32(1),wf4(:,16),G0H8(2),m3h4x8(:,136),heltab2x32(:,:,466))
  call Hloop_Q_A(ntryL,G0H8(2),17,nMT,G1H8(86),n2h8(168))
  Gcoeff(:)%j = (c(4)*M(3,:)%j) * den(22)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(467),h0tab(:,467),[17,4,10],[nMT,nMT,nMZ],3,2,wf4(:,16),wf4(:,8))
  call Hloop_ZQ_A(ntryL,G0H32(1),wf4(:,16),G0H8(3),ngZu,m3h4x8(:,137),heltab2x32(:,:,467))
  call Hloop_Q_A(ntryL,G0H8(3),17,nMT,G1H8(87),n2h8(169))
  Gcoeff(:)%j = (c(6)*M(3,:)%j) * den(22)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(468),h0tab(:,468),[17,4,10],[nMB,nMB,nMW],3,2,wf4(:,16),wf4(:,8))
  call Hloop_WQ_A(ntryL,G0H32(1),wf4(:,16),G0H8(4),m3h4x8(:,138),heltab2x32(:,:,468))
  call Hloop_Q_A(ntryL,G0H8(4),17,nMB,G1H8(88),n2h8(170))
  Gcoeff(:)%j = (c(9)*(M(3,:)%j-M(4,:)%j)) * den(23)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(469),h0tab(:,469),[20,1,10],[nMT,nMH,nMT],3,2,wf4(:,3),wf4(:,8))
  call Hloop_AV_Q(ntryL,G0H32(1),wf4(:,3),G0H8(5),m3h4x8(:,139),heltab2x32(:,:,469))
  call Hloop_A_Q(ntryL,G0H8(5),20,nMT,G1H8(90),n2h8(171))
  Gcoeff(:)%j = (c(9)*(-M(3,:)%j+M(4,:)%j)) * den(23)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(470),h0tab(:,470),[20,1,10],[nMT,nMZ,nMT],3,2,wf4(:,3),wf4(:,8))
  call Hloop_AV_Q(ntryL,G0H32(1),wf4(:,3),G0H8(6),m3h4x8(:,140),heltab2x32(:,:,470))
  call Hloop_A_Q(ntryL,G0H8(6),20,nMT,G1H8(91),n2h8(172))
  Gcoeff(:)%j = (c(7)*(-M(3,:)%j+M(4,:)%j)) * den(23)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(471),h0tab(:,471),[20,1,10],[nMB,nMW,nMB],3,2,wf4(:,3),wf4(:,8))
  call Hloop_AV_Q(ntryL,G0H32(1),wf4(:,3),G0H8(13),m3h4x8(:,141),heltab2x32(:,:,471))
  call Hloop_A_Q(ntryL,G0H8(13),20,nMB,G1H8(92),n2h8(173))
  Gcoeff(:)%j = (c(1)*(-M(3,:)%j+M(4,:)%j)) * den(23)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(472),h0tab(:,472),[20,1,10],[nMT,0,nMT],3,2,wf4(:,3),wf4(:,8))
  call Hloop_AV_Q(ntryL,G0H32(1),wf4(:,3),G0H8(14),m3h4x8(:,142),heltab2x32(:,:,472))
  call Hloop_A_Q(ntryL,G0H8(14),20,nMT,G1H8(93),n2h8(174))
  Gcoeff(:)%j = (c(2)*(-M(3,:)%j+M(4,:)%j)) * den(23)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(473),h0tab(:,473),[20,1,10],[nMT,nMZ,nMT],3,2,wf4(:,3),wf4(:,8))
  call Hloop_AV_Q(ntryL,G0H32(1),wf4(:,3),G0H8(15),m3h4x8(:,143),heltab2x32(:,:,473))
  call Hloop_A_Q(ntryL,G0H8(15),20,nMT,G1H8(95),n2h8(175))
  Gcoeff(:)%j = (c(5)*(-M(3,:)%j+M(4,:)%j)) * den(23)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(474),h0tab(:,474),[20,1,10],[nMB,nMW,nMB],3,2,wf4(:,3),wf4(:,8))
  call Hloop_AV_Q(ntryL,G0H32(1),wf4(:,3),G0H8(16),m3h4x8(:,144),heltab2x32(:,:,474))
  call Hloop_A_Q(ntryL,G0H8(16),20,nMB,G1H8(96),n2h8(176))
  Gcoeff(:)%j = (c(24)*M(8,:)%j) * den(110)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(475),h0tab(:,475),[16,4,11],[nMT,nMT,nMT],3,1,wf8(:,41))
  call Hloop_QV_A(ntryL,G0H32(1),ex5(:),G0H16(1),m3h2x16(:,295),heltab2x32(:,:,475))
  call Hloop_Q_A(ntryL,G0H16(1),16,nMT,G1H16(127),n2h16(295))
  Gcoeff(:)%j = (c(24)*M(8,:)%j) * den(110)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(476),h0tab(:,476),[16,4,11],[nMT,nMT,nMT],3,1,wf8(:,41))
  call Hloop_AV_Q(ntryL,G0H32(1),ex5(:),G0H16(1),m3h2x16(:,296),heltab2x32(:,:,476))
  call Hloop_A_Q(ntryL,G0H16(1),16,nMT,G1H16(128),n2h16(296))
  Gcoeff(:)%j = (c(22)*M(8,:)%j) * den(110)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(477),h0tab(:,477),[16,4,11],[nMB,nMB,nMB],3,1,wf8(:,41))
  call Hloop_QV_A(ntryL,G0H32(1),ex5(:),G0H16(1),m3h2x16(:,297),heltab2x32(:,:,477))
  call Hloop_Q_A(ntryL,G0H16(1),16,nMB,G1H16(129),n2h16(297))
  Gcoeff(:)%j = (c(22)*M(8,:)%j) * den(110)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(478),h0tab(:,478),[16,4,11],[nMB,nMB,nMB],3,1,wf8(:,41))
  call Hloop_AV_Q(ntryL,G0H32(1),ex5(:),G0H16(1),m3h2x16(:,298),heltab2x32(:,:,478))
  call Hloop_A_Q(ntryL,G0H16(1),16,nMB,G1H16(130),n2h16(298))
  Gcoeff(:)%j = (-(c(24)*M(8,:)%j)) * den(111)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(479),h0tab(:,479),[16,4,11],[nMT,nMT,nMT],3,1,wf8(:,101))
  call Hloop_QV_A(ntryL,G0H32(1),ex5(:),G0H16(1),m3h2x16(:,299),heltab2x32(:,:,479))
  call Hloop_Q_A(ntryL,G0H16(1),16,nMT,G1H16(131),n2h16(299))
  Gcoeff(:)%j = (-(c(24)*M(8,:)%j)) * den(111)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(480),h0tab(:,480),[16,4,11],[nMT,nMT,nMT],3,1,wf8(:,101))
  call Hloop_AV_Q(ntryL,G0H32(1),ex5(:),G0H16(1),m3h2x16(:,300),heltab2x32(:,:,480))
  call Hloop_A_Q(ntryL,G0H16(1),16,nMT,G1H16(132),n2h16(300))
  Gcoeff(:)%j = (c(22)*M(8,:)%j) * den(111)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(481),h0tab(:,481),[16,4,11],[nMB,nMB,nMB],3,1,wf8(:,101))
  call Hloop_QV_A(ntryL,G0H32(1),ex5(:),G0H16(1),m3h2x16(:,301),heltab2x32(:,:,481))
  call Hloop_Q_A(ntryL,G0H16(1),16,nMB,G1H16(133),n2h16(301))
  Gcoeff(:)%j = (c(22)*M(8,:)%j) * den(111)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(482),h0tab(:,482),[16,4,11],[nMB,nMB,nMB],3,1,wf8(:,101))
  call Hloop_AV_Q(ntryL,G0H32(1),ex5(:),G0H16(1),m3h2x16(:,302),heltab2x32(:,:,482))
  call Hloop_A_Q(ntryL,G0H16(1),16,nMB,G1H16(134),n2h16(302))
  Gcoeff(:)%j = (-(c(18)*M(8,:)%j)) * den(112)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(483),h0tab(:,483),[16,4,11],[0,0,0],3,1,wf8(:,16))
  call Hloop_QV_A(ntryL,G0H32(1),ex5(:),G0H16(1),m3h2x16(:,303),heltab2x32(:,:,483))
  call Hloop_Q_A(ntryL,G0H16(1),16,0,G1H16(135),n2h16(303))
  Gcoeff(:)%j = (-(c(17)*M(8,:)%j)) * den(112)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(484),h0tab(:,484),[16,4,11],[nMT,nMT,nMT],3,1,wf8(:,16))
  call Hloop_QV_A(ntryL,G0H32(1),ex5(:),G0H16(1),m3h2x16(:,304),heltab2x32(:,:,484))
  call Hloop_Q_A(ntryL,G0H16(1),16,nMT,G1H16(136),n2h16(304))
  Gcoeff(:)%j = (-(c(18)*M(8,:)%j)) * den(112)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(485),h0tab(:,485),[16,4,11],[0,0,0],3,1,wf8(:,16))
  call Hloop_AV_Q(ntryL,G0H32(1),ex5(:),G0H16(1),m3h2x16(:,305),heltab2x32(:,:,485))
  call Hloop_A_Q(ntryL,G0H16(1),16,0,G1H16(137),n2h16(305))
  Gcoeff(:)%j = (-(c(17)*M(8,:)%j)) * den(112)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(486),h0tab(:,486),[16,4,11],[nMT,nMT,nMT],3,1,wf8(:,16))
  call Hloop_AV_Q(ntryL,G0H32(1),ex5(:),G0H16(1),m3h2x16(:,306),heltab2x32(:,:,486))
  call Hloop_A_Q(ntryL,G0H16(1),16,nMT,G1H16(138),n2h16(306))
  Gcoeff(:)%j = (c(17)*M(8,:)%j) * den(112)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(487),h0tab(:,487),[16,4,11],[0,0,0],3,1,wf8(:,16))
  call Hloop_QV_A(ntryL,G0H32(1),ex5(:),G0H16(1),m3h2x16(:,307),heltab2x32(:,:,487))
  call Hloop_Q_A(ntryL,G0H16(1),16,0,G1H16(139),n2h16(307))
  Gcoeff(:)%j = (c(16)*M(8,:)%j) * den(112)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(488),h0tab(:,488),[16,4,11],[nMB,nMB,nMB],3,1,wf8(:,16))
  call Hloop_QV_A(ntryL,G0H32(1),ex5(:),G0H16(1),m3h2x16(:,308),heltab2x32(:,:,488))
  call Hloop_Q_A(ntryL,G0H16(1),16,nMB,G1H16(140),n2h16(308))
  Gcoeff(:)%j = (c(17)*M(8,:)%j) * den(112)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(489),h0tab(:,489),[16,4,11],[0,0,0],3,1,wf8(:,16))
  call Hloop_AV_Q(ntryL,G0H32(1),ex5(:),G0H16(1),m3h2x16(:,309),heltab2x32(:,:,489))
  call Hloop_A_Q(ntryL,G0H16(1),16,0,G1H16(141),n2h16(309))
  Gcoeff(:)%j = (c(16)*M(8,:)%j) * den(112)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(490),h0tab(:,490),[16,4,11],[nMB,nMB,nMB],3,1,wf8(:,16))
  call Hloop_AV_Q(ntryL,G0H32(1),ex5(:),G0H16(1),m3h2x16(:,310),heltab2x32(:,:,490))
  call Hloop_A_Q(ntryL,G0H16(1),16,nMB,G1H16(142),n2h16(310))
  Gcoeff(:)%j = (-(c(20)*M(8,:)%j)) * den(111)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(491),h0tab(:,491),[16,4,11],[0,0,0],3,1,wf8(:,42))
  call Hloop_QV_A(ntryL,G0H32(1),ex5(:),G0H16(1),m3h2x16(:,311),heltab2x32(:,:,491))
  call Hloop_Q_A(ntryL,G0H16(1),16,0,G1H16(143),n2h16(311))
  Gcoeff(:)%j = (-(c(19)*M(8,:)%j)) * den(111)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(492),h0tab(:,492),[16,4,11],[nMT,nMT,nMT],3,1,wf8(:,42))
  call Hloop_QV_A(ntryL,G0H32(1),ex5(:),G0H16(1),m3h2x16(:,312),heltab2x32(:,:,492))
  call Hloop_Q_A(ntryL,G0H16(1),16,nMT,G1H16(144),n2h16(312))
  Gcoeff(:)%j = (-(c(20)*M(8,:)%j)) * den(111)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(493),h0tab(:,493),[16,4,11],[0,0,0],3,1,wf8(:,42))
  call Hloop_AV_Q(ntryL,G0H32(1),ex5(:),G0H16(1),m3h2x16(:,313),heltab2x32(:,:,493))
  call Hloop_A_Q(ntryL,G0H16(1),16,0,G1H16(145),n2h16(313))
  Gcoeff(:)%j = (-(c(19)*M(8,:)%j)) * den(111)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(494),h0tab(:,494),[16,4,11],[nMT,nMT,nMT],3,1,wf8(:,42))
  call Hloop_AV_Q(ntryL,G0H32(1),ex5(:),G0H16(1),m3h2x16(:,314),heltab2x32(:,:,494))
  call Hloop_A_Q(ntryL,G0H16(1),16,nMT,G1H16(146),n2h16(314))
  Gcoeff(:)%j = (-(c(20)*M(8,:)%j)) * den(111)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(495),h0tab(:,495),[16,4,11],[0,0,0],3,1,wf8(:,42))
  call Hloop_QV_A(ntryL,G0H32(1),ex5(:),G0H16(1),m3h2x16(:,315),heltab2x32(:,:,495))
  call Hloop_Q_A(ntryL,G0H16(1),16,0,G1H16(147),n2h16(315))
  Gcoeff(:)%j = (-(c(19)*M(8,:)%j)) * den(111)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(496),h0tab(:,496),[16,4,11],[nMB,nMB,nMB],3,1,wf8(:,42))
  call Hloop_QV_A(ntryL,G0H32(1),ex5(:),G0H16(1),m3h2x16(:,316),heltab2x32(:,:,496))
  call Hloop_Q_A(ntryL,G0H16(1),16,nMB,G1H16(148),n2h16(316))
  Gcoeff(:)%j = (-(c(20)*M(8,:)%j)) * den(111)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(497),h0tab(:,497),[16,4,11],[0,0,0],3,1,wf8(:,42))
  call Hloop_AV_Q(ntryL,G0H32(1),ex5(:),G0H16(1),m3h2x16(:,317),heltab2x32(:,:,497))
  call Hloop_A_Q(ntryL,G0H16(1),16,0,G1H16(149),n2h16(317))
  Gcoeff(:)%j = (-(c(19)*M(8,:)%j)) * den(111)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(498),h0tab(:,498),[16,4,11],[nMB,nMB,nMB],3,1,wf8(:,42))
  call Hloop_AV_Q(ntryL,G0H32(1),ex5(:),G0H16(1),m3h2x16(:,318),heltab2x32(:,:,498))
  call Hloop_A_Q(ntryL,G0H16(1),16,nMB,G1H16(150),n2h16(318))
  Gcoeff(:)%j = (-(c(10)*M(3,:)%j)) * den(85)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(499),h0tab(:,499),[16,1,14],[nMT,nMH,nMT],3,1,wf8(:,90))
  call Hloop_AV_Q(ntryL,G0H32(1),ex5(:),G0H16(1),m3h2x16(:,319),heltab2x32(:,:,499))
  call Hloop_A_Q(ntryL,G0H16(1),16,nMT,G1H16(151),n2h16(319))
  Gcoeff(:)%j = (c(10)*M(3,:)%j) * den(85)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(500),h0tab(:,500),[16,1,14],[nMT,nMZ,nMT],3,1,wf8(:,90))
  call Hloop_AV_Q(ntryL,G0H32(1),ex5(:),G0H16(1),m3h2x16(:,320),heltab2x32(:,:,500))
  call Hloop_A_Q(ntryL,G0H16(1),16,nMT,G1H16(152),n2h16(320))
  Gcoeff(:)%j = (c(8)*M(3,:)%j) * den(85)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(501),h0tab(:,501),[16,1,14],[nMB,nMW,nMB],3,1,wf8(:,90))
  call Hloop_AV_Q(ntryL,G0H32(1),ex5(:),G0H16(1),m3h2x16(:,321),heltab2x32(:,:,501))
  call Hloop_A_Q(ntryL,G0H16(1),16,nMB,G1H16(153),n2h16(321))
  Gcoeff(:)%j = (c(3)*M(3,:)%j) * den(85)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(502),h0tab(:,502),[16,1,14],[nMT,0,nMT],3,1,wf8(:,90))
  call Hloop_AV_Q(ntryL,G0H32(1),ex5(:),G0H16(1),m3h2x16(:,322),heltab2x32(:,:,502))
  call Hloop_A_Q(ntryL,G0H16(1),16,nMT,G1H16(154),n2h16(322))
  Gcoeff(:)%j = (c(4)*M(3,:)%j) * den(85)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(503),h0tab(:,503),[16,1,14],[nMT,nMZ,nMT],3,1,wf8(:,90))
  call Hloop_AV_Q(ntryL,G0H32(1),ex5(:),G0H16(1),m3h2x16(:,323),heltab2x32(:,:,503))
  call Hloop_A_Q(ntryL,G0H16(1),16,nMT,G1H16(155),n2h16(323))
  Gcoeff(:)%j = (c(6)*M(3,:)%j) * den(85)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(504),h0tab(:,504),[16,1,14],[nMB,nMW,nMB],3,1,wf8(:,90))
  call Hloop_AV_Q(ntryL,G0H32(1),ex5(:),G0H16(1),m3h2x16(:,324),heltab2x32(:,:,504))
  call Hloop_A_Q(ntryL,G0H16(1),16,nMB,G1H16(156),n2h16(324))
  Gcoeff(:)%j = (-(c(10)*M(4,:)%j)) * den(54)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(505),h0tab(:,505),[26,1,4],[nMH,nMT,nMT],3,1,wf8(:,69))
  call Hloop_QA_S(ntryL,G0H32(1),wf8(:,69),G0H4(19),ngH,m3h8x4(:,37),heltab2x32(:,:,505))
  Gcoeff(:)%j = (c(10)*M(4,:)%j) * den(54)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(506),h0tab(:,506),[26,1,4],[nMZ,nMT,nMT],3,1,wf8(:,69))
  call Hloop_QA_S(ntryL,G0H32(1),wf8(:,69),G0H4(20),ngX,m3h8x4(:,38),heltab2x32(:,:,506))
  Gcoeff(:)%j = (c(8)*M(4,:)%j) * den(54)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(507),h0tab(:,507),[26,1,4],[nMW,nMB,nMB],3,1,wf8(:,69))
  call Hloop_QA_S(ntryL,G0H32(1),wf8(:,69),G0H4(21),ngPtb,m3h8x4(:,39),heltab2x32(:,:,507))
  Gcoeff(:)%j = (c(3)*M(4,:)%j) * den(54)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(508),h0tab(:,508),[26,1,4],[0,nMT,nMT],3,1,wf8(:,69))
  call Hloop_QA_V(ntryL,G0H32(1),wf8(:,69),G0H4(22),m3h8x4(:,40),heltab2x32(:,:,508))
  Gcoeff(:)%j = (c(4)*M(4,:)%j) * den(54)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(509),h0tab(:,509),[26,1,4],[nMZ,nMT,nMT],3,1,wf8(:,69))
  call Hloop_QA_Z(ntryL,G0H32(1),wf8(:,69),G0H4(23),ngZu,m3h8x4(:,41),heltab2x32(:,:,509))
  Gcoeff(:)%j = (c(6)*M(4,:)%j) * den(54)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(510),h0tab(:,510),[26,1,4],[nMW,nMB,nMB],3,1,wf8(:,69))
  call Hloop_QA_W(ntryL,G0H32(1),wf8(:,69),G0H4(24),m3h8x4(:,42),heltab2x32(:,:,510))
  Gcoeff(:)%j = (c(9)*(M(1,:)%j-M(3,:)%j)) * den(24)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(511),h0tab(:,511),[17,2,12],[nMH,nMT,nMT],3,2,wf4(:,16),wf4(:,2))
  call Hloop_AQ_S(ntryL,G0H32(1),wf4(:,16),G0H8(17),ngH,m3h4x8(:,145),heltab2x32(:,:,511))
  Gcoeff(:)%j = (c(9)*(-M(1,:)%j+M(3,:)%j)) * den(24)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(512),h0tab(:,512),[17,2,12],[nMZ,nMT,nMT],3,2,wf4(:,16),wf4(:,2))
  call Hloop_AQ_S(ntryL,G0H32(1),wf4(:,16),G0H8(18),ngX,m3h4x8(:,146),heltab2x32(:,:,512))
  Gcoeff(:)%j = (c(7)*(-M(1,:)%j+M(3,:)%j)) * den(24)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(513),h0tab(:,513),[17,2,12],[nMW,nMB,nMB],3,2,wf4(:,16),wf4(:,2))
  call Hloop_AQ_S(ntryL,G0H32(1),wf4(:,16),G0H8(19),ngPbt,m3h4x8(:,147),heltab2x32(:,:,513))
  Gcoeff(:)%j = (c(1)*(-M(1,:)%j+M(3,:)%j)) * den(24)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(514),h0tab(:,514),[17,2,12],[0,nMT,nMT],3,2,wf4(:,16),wf4(:,2))
  call Hloop_AQ_V(ntryL,G0H32(1),wf4(:,16),G0H8(1),m3h4x8(:,148),heltab2x32(:,:,514))
  Gcoeff(:)%j = (c(2)*(-M(1,:)%j+M(3,:)%j)) * den(24)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(515),h0tab(:,515),[17,2,12],[nMZ,nMT,nMT],3,2,wf4(:,16),wf4(:,2))
  call Hloop_AQ_Z(ntryL,G0H32(1),wf4(:,16),G0H8(2),ngZu,m3h4x8(:,149),heltab2x32(:,:,515))
  Gcoeff(:)%j = (c(5)*(-M(1,:)%j+M(3,:)%j)) * den(24)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(516),h0tab(:,516),[17,2,12],[nMW,nMB,nMB],3,2,wf4(:,16),wf4(:,2))
  call Hloop_AQ_W(ntryL,G0H32(1),wf4(:,16),G0H8(3),m3h4x8(:,150),heltab2x32(:,:,516))
  Gcoeff(:)%j = (c(9)*(M(5,:)%j-M(6,:)%j)) * den(25)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(517),h0tab(:,517),[18,1,12],[nMH,nMT,nMT],3,2,wf4(:,10),wf4(:,2))
  call Hloop_QA_S(ntryL,G0H32(1),wf4(:,10),G0H8(4),ngH,m3h4x8(:,151),heltab2x32(:,:,517))
  Gcoeff(:)%j = (c(9)*(-M(5,:)%j+M(6,:)%j)) * den(25)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(518),h0tab(:,518),[18,1,12],[nMZ,nMT,nMT],3,2,wf4(:,10),wf4(:,2))
  call Hloop_QA_S(ntryL,G0H32(1),wf4(:,10),G0H8(5),ngX,m3h4x8(:,152),heltab2x32(:,:,518))
  Gcoeff(:)%j = (c(7)*(-M(5,:)%j+M(6,:)%j)) * den(25)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(519),h0tab(:,519),[18,1,12],[nMW,nMB,nMB],3,2,wf4(:,10),wf4(:,2))
  call Hloop_QA_S(ntryL,G0H32(1),wf4(:,10),G0H8(6),ngPtb,m3h4x8(:,153),heltab2x32(:,:,519))
  Gcoeff(:)%j = (c(1)*(-M(5,:)%j+M(6,:)%j)) * den(25)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(520),h0tab(:,520),[18,1,12],[0,nMT,nMT],3,2,wf4(:,10),wf4(:,2))
  call Hloop_QA_V(ntryL,G0H32(1),wf4(:,10),G0H8(13),m3h4x8(:,154),heltab2x32(:,:,520))
  Gcoeff(:)%j = (c(2)*(-M(5,:)%j+M(6,:)%j)) * den(25)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(521),h0tab(:,521),[18,1,12],[nMZ,nMT,nMT],3,2,wf4(:,10),wf4(:,2))
  call Hloop_QA_Z(ntryL,G0H32(1),wf4(:,10),G0H8(14),ngZu,m3h4x8(:,155),heltab2x32(:,:,521))
  Gcoeff(:)%j = (c(5)*(-M(5,:)%j+M(6,:)%j)) * den(25)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(522),h0tab(:,522),[18,1,12],[nMW,nMB,nMB],3,2,wf4(:,10),wf4(:,2))
  call Hloop_QA_W(ntryL,G0H32(1),wf4(:,10),G0H8(15),m3h4x8(:,156),heltab2x32(:,:,522))
  Gcoeff(:)%j = (c(9)*(M(5,:)%j-M(6,:)%j)) * den(93)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(523),h0tab(:,523),[16,2,13],[nMT,nMH,nMT],3,1,wf8(:,97))
  call Hloop_QV_A(ntryL,G0H32(1),ex5(:),G0H16(1),m3h2x16(:,325),heltab2x32(:,:,523))
  call Hloop_Q_A(ntryL,G0H16(1),16,nMT,G1H16(157),n2h16(325))
  Gcoeff(:)%j = (c(9)*(-M(5,:)%j+M(6,:)%j)) * den(93)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(524),h0tab(:,524),[16,2,13],[nMT,nMZ,nMT],3,1,wf8(:,97))
  call Hloop_QV_A(ntryL,G0H32(1),ex5(:),G0H16(1),m3h2x16(:,326),heltab2x32(:,:,524))
  call Hloop_Q_A(ntryL,G0H16(1),16,nMT,G1H16(158),n2h16(326))
  Gcoeff(:)%j = (c(7)*(-M(5,:)%j+M(6,:)%j)) * den(93)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(525),h0tab(:,525),[16,2,13],[nMB,nMW,nMB],3,1,wf8(:,97))
  call Hloop_QV_A(ntryL,G0H32(1),ex5(:),G0H16(1),m3h2x16(:,327),heltab2x32(:,:,525))
  call Hloop_Q_A(ntryL,G0H16(1),16,nMB,G1H16(159),n2h16(327))
  Gcoeff(:)%j = (c(1)*(-M(5,:)%j+M(6,:)%j)) * den(93)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(526),h0tab(:,526),[16,2,13],[nMT,0,nMT],3,1,wf8(:,97))
  call Hloop_QV_A(ntryL,G0H32(1),ex5(:),G0H16(1),m3h2x16(:,328),heltab2x32(:,:,526))
  call Hloop_Q_A(ntryL,G0H16(1),16,nMT,G1H16(160),n2h16(328))
  Gcoeff(:)%j = (c(2)*(-M(5,:)%j+M(6,:)%j)) * den(93)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(527),h0tab(:,527),[16,2,13],[nMT,nMZ,nMT],3,1,wf8(:,97))
  call Hloop_QV_A(ntryL,G0H32(1),ex5(:),G0H16(1),m3h2x16(:,329),heltab2x32(:,:,527))
  call Hloop_Q_A(ntryL,G0H16(1),16,nMT,G1H16(161),n2h16(329))
  Gcoeff(:)%j = (c(5)*(-M(5,:)%j+M(6,:)%j)) * den(93)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(528),h0tab(:,528),[16,2,13],[nMB,nMW,nMB],3,1,wf8(:,97))
  call Hloop_QV_A(ntryL,G0H32(1),ex5(:),G0H16(1),m3h2x16(:,330),heltab2x32(:,:,528))
  call Hloop_Q_A(ntryL,G0H16(1),16,nMB,G1H16(162),n2h16(330))
  Gcoeff(:)%j = (c(9)*(M(1,:)%j-M(3,:)%j)) * den(91)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(529),h0tab(:,529),[16,1,14],[nMT,nMH,nMT],3,1,wf8(:,95))
  call Hloop_AV_Q(ntryL,G0H32(1),ex5(:),G0H16(1),m3h2x16(:,331),heltab2x32(:,:,529))
  call Hloop_A_Q(ntryL,G0H16(1),16,nMT,G1H16(163),n2h16(331))
  Gcoeff(:)%j = (c(9)*(-M(1,:)%j+M(3,:)%j)) * den(91)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(530),h0tab(:,530),[16,1,14],[nMT,nMZ,nMT],3,1,wf8(:,95))
  call Hloop_AV_Q(ntryL,G0H32(1),ex5(:),G0H16(1),m3h2x16(:,332),heltab2x32(:,:,530))
  call Hloop_A_Q(ntryL,G0H16(1),16,nMT,G1H16(164),n2h16(332))
  Gcoeff(:)%j = (c(7)*(-M(1,:)%j+M(3,:)%j)) * den(91)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(531),h0tab(:,531),[16,1,14],[nMB,nMW,nMB],3,1,wf8(:,95))
  call Hloop_AV_Q(ntryL,G0H32(1),ex5(:),G0H16(1),m3h2x16(:,333),heltab2x32(:,:,531))
  call Hloop_A_Q(ntryL,G0H16(1),16,nMB,G1H16(165),n2h16(333))
  Gcoeff(:)%j = (c(1)*(-M(1,:)%j+M(3,:)%j)) * den(91)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(532),h0tab(:,532),[16,1,14],[nMT,0,nMT],3,1,wf8(:,95))
  call Hloop_AV_Q(ntryL,G0H32(1),ex5(:),G0H16(1),m3h2x16(:,334),heltab2x32(:,:,532))
  call Hloop_A_Q(ntryL,G0H16(1),16,nMT,G1H16(166),n2h16(334))
  Gcoeff(:)%j = (c(2)*(-M(1,:)%j+M(3,:)%j)) * den(91)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(533),h0tab(:,533),[16,1,14],[nMT,nMZ,nMT],3,1,wf8(:,95))
  call Hloop_AV_Q(ntryL,G0H32(1),ex5(:),G0H16(1),m3h2x16(:,335),heltab2x32(:,:,533))
  call Hloop_A_Q(ntryL,G0H16(1),16,nMT,G1H16(167),n2h16(335))
  Gcoeff(:)%j = (c(5)*(-M(1,:)%j+M(3,:)%j)) * den(91)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(534),h0tab(:,534),[16,1,14],[nMB,nMW,nMB],3,1,wf8(:,95))
  call Hloop_AV_Q(ntryL,G0H32(1),ex5(:),G0H16(1),m3h2x16(:,336),heltab2x32(:,:,534))
  call Hloop_A_Q(ntryL,G0H16(1),16,nMB,G1H16(168),n2h16(336))
  Gcoeff(:)%j = (c(10)*(-M(1,:)%j+M(3,:)%j+M(5,:)%j-M(6,:)%j)) * den(113)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(535),h0tab(:,535),[28,1,2],[nMT,nMH,nMT],3,1,wf8(:,102))
  call Hloop_AV_Q(ntryL,G0H32(1),wf8(:,102),G0H4(25),m3h8x4(:,43),heltab2x32(:,:,535))
  call Hloop_A_Q(ntryL,G0H4(25),28,nMT,G1H4(8),n2h4(163))
  Gcoeff(:)%j = (c(10)*(M(1,:)%j-M(3,:)%j-M(5,:)%j+M(6,:)%j)) * den(113)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(536),h0tab(:,536),[28,1,2],[nMT,nMZ,nMT],3,1,wf8(:,102))
  call Hloop_AV_Q(ntryL,G0H32(1),wf8(:,102),G0H4(25),m3h8x4(:,44),heltab2x32(:,:,536))
  call Hloop_A_Q(ntryL,G0H4(25),28,nMT,G1H4(11),n2h4(164))
  Gcoeff(:)%j = (c(8)*(M(1,:)%j-M(3,:)%j-M(5,:)%j+M(6,:)%j)) * den(113)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(537),h0tab(:,537),[28,1,2],[nMB,nMW,nMB],3,1,wf8(:,102))
  call Hloop_AV_Q(ntryL,G0H32(1),wf8(:,102),G0H4(25),m3h8x4(:,45),heltab2x32(:,:,537))
  call Hloop_A_Q(ntryL,G0H4(25),28,nMB,G1H4(12),n2h4(165))
  Gcoeff(:)%j = (c(3)*(M(1,:)%j-M(3,:)%j-M(5,:)%j+M(6,:)%j)) * den(113)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(538),h0tab(:,538),[28,1,2],[nMT,0,nMT],3,1,wf8(:,102))
  call Hloop_AV_Q(ntryL,G0H32(1),wf8(:,102),G0H4(25),m3h8x4(:,46),heltab2x32(:,:,538))
  call Hloop_A_Q(ntryL,G0H4(25),28,nMT,G1H4(13),n2h4(166))
  Gcoeff(:)%j = (c(4)*(M(1,:)%j-M(3,:)%j-M(5,:)%j+M(6,:)%j)) * den(113)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(539),h0tab(:,539),[28,1,2],[nMT,nMZ,nMT],3,1,wf8(:,102))
  call Hloop_AV_Q(ntryL,G0H32(1),wf8(:,102),G0H4(25),m3h8x4(:,47),heltab2x32(:,:,539))
  call Hloop_A_Q(ntryL,G0H4(25),28,nMT,G1H4(17),n2h4(167))
  Gcoeff(:)%j = (c(6)*(M(1,:)%j-M(3,:)%j-M(5,:)%j+M(6,:)%j)) * den(113)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(540),h0tab(:,540),[28,1,2],[nMB,nMW,nMB],3,1,wf8(:,102))
  call Hloop_AV_Q(ntryL,G0H32(1),wf8(:,102),G0H4(25),m3h8x4(:,48),heltab2x32(:,:,540))
  call Hloop_A_Q(ntryL,G0H4(25),28,nMB,G1H4(18),n2h4(168))
  Gcoeff(:)%j = (c(24)*M(7,:)%j) * den(115)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(541),h0tab(:,541),[19,4,8],[nMT,nMT,nMT],3,1,wf8(:,43))
  call Hloop_AS_Q(ntryL,G0H32(1),wf8(:,43),G0H4(25),ngH,m3h8x4(:,49),heltab2x32(:,:,541))
  call Hloop_A_Q(ntryL,G0H4(25),19,nMT,G1H4(19),n2h4(169))
  Gcoeff(:)%j = (c(24)*M(7,:)%j) * den(115)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(542),h0tab(:,542),[19,4,8],[nMT,nMT,nMT],3,1,wf8(:,43))
  call Hloop_QS_A(ntryL,G0H32(1),wf8(:,43),G0H4(25),ngH,m3h8x4(:,50),heltab2x32(:,:,542))
  call Hloop_Q_A(ntryL,G0H4(25),19,nMT,G1H4(20),n2h4(170))
  Gcoeff(:)%j = (c(22)*M(7,:)%j) * den(115)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(543),h0tab(:,543),[19,4,8],[nMB,nMB,nMB],3,1,wf8(:,43))
  call Hloop_AS_Q(ntryL,G0H32(1),wf8(:,43),G0H4(25),ngH,m3h8x4(:,51),heltab2x32(:,:,543))
  call Hloop_A_Q(ntryL,G0H4(25),19,nMB,G1H4(24),n2h4(171))
  Gcoeff(:)%j = (c(22)*M(7,:)%j) * den(115)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(544),h0tab(:,544),[19,4,8],[nMB,nMB,nMB],3,1,wf8(:,43))
  call Hloop_QS_A(ntryL,G0H32(1),wf8(:,43),G0H4(25),ngH,m3h8x4(:,52),heltab2x32(:,:,544))
  call Hloop_Q_A(ntryL,G0H4(25),19,nMB,G1H4(25),n2h4(172))
  Gcoeff(:)%j = (-(c(24)*M(7,:)%j)) * den(117)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(545),h0tab(:,545),[19,4,8],[nMT,nMT,nMT],3,1,wf8(:,103))
  call Hloop_AS_Q(ntryL,G0H32(1),wf8(:,103),G0H4(25),ngX,m3h8x4(:,53),heltab2x32(:,:,545))
  call Hloop_A_Q(ntryL,G0H4(25),19,nMT,G1H4(26),n2h4(173))
  Gcoeff(:)%j = (-(c(24)*M(7,:)%j)) * den(117)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(546),h0tab(:,546),[19,4,8],[nMT,nMT,nMT],3,1,wf8(:,103))
  call Hloop_QS_A(ntryL,G0H32(1),wf8(:,103),G0H4(25),ngX,m3h8x4(:,54),heltab2x32(:,:,546))
  call Hloop_Q_A(ntryL,G0H4(25),19,nMT,G1H4(29),n2h4(174))
  Gcoeff(:)%j = (c(22)*M(7,:)%j) * den(117)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(547),h0tab(:,547),[19,4,8],[nMB,nMB,nMB],3,1,wf8(:,103))
  call Hloop_AS_Q(ntryL,G0H32(1),wf8(:,103),G0H4(25),ngX,m3h8x4(:,55),heltab2x32(:,:,547))
  call Hloop_A_Q(ntryL,G0H4(25),19,nMB,G1H4(31),n2h4(175))
  Gcoeff(:)%j = (c(22)*M(7,:)%j) * den(117)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(548),h0tab(:,548),[19,4,8],[nMB,nMB,nMB],3,1,wf8(:,103))
  call Hloop_QS_A(ntryL,G0H32(1),wf8(:,103),G0H4(25),ngX,m3h8x4(:,56),heltab2x32(:,:,548))
  call Hloop_Q_A(ntryL,G0H4(25),19,nMB,G1H4(32),n2h4(176))
  Gcoeff(:)%j = (-(c(18)*M(7,:)%j)) * den(119)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(549),h0tab(:,549),[19,4,8],[0,0,0],3,1,wf8(:,17))
  call Hloop_AV_Q(ntryL,G0H32(1),wf8(:,17),G0H4(25),m3h8x4(:,57),heltab2x32(:,:,549))
  call Hloop_A_Q(ntryL,G0H4(25),19,0,G1H4(35),n2h4(177))
  Gcoeff(:)%j = (-(c(17)*M(7,:)%j)) * den(119)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(550),h0tab(:,550),[19,4,8],[nMT,nMT,nMT],3,1,wf8(:,17))
  call Hloop_AV_Q(ntryL,G0H32(1),wf8(:,17),G0H4(25),m3h8x4(:,58),heltab2x32(:,:,550))
  call Hloop_A_Q(ntryL,G0H4(25),19,nMT,G1H4(36),n2h4(178))
  Gcoeff(:)%j = (-(c(18)*M(7,:)%j)) * den(119)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(551),h0tab(:,551),[19,4,8],[0,0,0],3,1,wf8(:,17))
  call Hloop_QV_A(ntryL,G0H32(1),wf8(:,17),G0H4(25),m3h8x4(:,59),heltab2x32(:,:,551))
  call Hloop_Q_A(ntryL,G0H4(25),19,0,G1H4(38),n2h4(179))
  Gcoeff(:)%j = (-(c(17)*M(7,:)%j)) * den(119)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(552),h0tab(:,552),[19,4,8],[nMT,nMT,nMT],3,1,wf8(:,17))
  call Hloop_QV_A(ntryL,G0H32(1),wf8(:,17),G0H4(25),m3h8x4(:,60),heltab2x32(:,:,552))
  call Hloop_Q_A(ntryL,G0H4(25),19,nMT,G1H4(41),n2h4(180))
  Gcoeff(:)%j = (c(17)*M(7,:)%j) * den(119)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(553),h0tab(:,553),[19,4,8],[0,0,0],3,1,wf8(:,17))
  call Hloop_AV_Q(ntryL,G0H32(1),wf8(:,17),G0H4(25),m3h8x4(:,61),heltab2x32(:,:,553))
  call Hloop_A_Q(ntryL,G0H4(25),19,0,G1H4(42),n2h4(181))
  Gcoeff(:)%j = (c(16)*M(7,:)%j) * den(119)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(554),h0tab(:,554),[19,4,8],[nMB,nMB,nMB],3,1,wf8(:,17))
  call Hloop_AV_Q(ntryL,G0H32(1),wf8(:,17),G0H4(25),m3h8x4(:,62),heltab2x32(:,:,554))
  call Hloop_A_Q(ntryL,G0H4(25),19,nMB,G1H4(43),n2h4(182))
  Gcoeff(:)%j = (c(17)*M(7,:)%j) * den(119)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(555),h0tab(:,555),[19,4,8],[0,0,0],3,1,wf8(:,17))
  call Hloop_QV_A(ntryL,G0H32(1),wf8(:,17),G0H4(25),m3h8x4(:,63),heltab2x32(:,:,555))
  call Hloop_Q_A(ntryL,G0H4(25),19,0,G1H4(47),n2h4(183))
  Gcoeff(:)%j = (c(16)*M(7,:)%j) * den(119)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(556),h0tab(:,556),[19,4,8],[nMB,nMB,nMB],3,1,wf8(:,17))
  call Hloop_QV_A(ntryL,G0H32(1),wf8(:,17),G0H4(25),m3h8x4(:,64),heltab2x32(:,:,556))
  call Hloop_Q_A(ntryL,G0H4(25),19,nMB,G1H4(48),n2h4(184))
  Gcoeff(:)%j = (-(c(20)*M(7,:)%j)) * den(117)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(557),h0tab(:,557),[19,4,8],[0,0,0],3,1,wf8(:,44))
  call Hloop_AZ_Q(ntryL,G0H32(1),wf8(:,44),G0H4(25),ngZu,m3h8x4(:,65),heltab2x32(:,:,557))
  call Hloop_A_Q(ntryL,G0H4(25),19,0,G1H4(49),n2h4(185))
  Gcoeff(:)%j = (-(c(19)*M(7,:)%j)) * den(117)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(558),h0tab(:,558),[19,4,8],[nMT,nMT,nMT],3,1,wf8(:,44))
  call Hloop_AZ_Q(ntryL,G0H32(1),wf8(:,44),G0H4(25),ngZu,m3h8x4(:,66),heltab2x32(:,:,558))
  call Hloop_A_Q(ntryL,G0H4(25),19,nMT,G1H4(50),n2h4(186))
  Gcoeff(:)%j = (-(c(20)*M(7,:)%j)) * den(117)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(559),h0tab(:,559),[19,4,8],[0,0,0],3,1,wf8(:,44))
  call Hloop_QZ_A(ntryL,G0H32(1),wf8(:,44),G0H4(25),ngZu,m3h8x4(:,67),heltab2x32(:,:,559))
  call Hloop_Q_A(ntryL,G0H4(25),19,0,G1H4(54),n2h4(187))
  Gcoeff(:)%j = (-(c(19)*M(7,:)%j)) * den(117)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(560),h0tab(:,560),[19,4,8],[nMT,nMT,nMT],3,1,wf8(:,44))
  call Hloop_QZ_A(ntryL,G0H32(1),wf8(:,44),G0H4(25),ngZu,m3h8x4(:,68),heltab2x32(:,:,560))
  call Hloop_Q_A(ntryL,G0H4(25),19,nMT,G1H4(55),n2h4(188))
  Gcoeff(:)%j = (-(c(20)*M(7,:)%j)) * den(117)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(561),h0tab(:,561),[19,4,8],[0,0,0],3,1,wf8(:,44))
  call Hloop_AZ_Q(ntryL,G0H32(1),wf8(:,44),G0H4(25),ngZd,m3h8x4(:,69),heltab2x32(:,:,561))
  call Hloop_A_Q(ntryL,G0H4(25),19,0,G1H4(56),n2h4(189))
  Gcoeff(:)%j = (-(c(19)*M(7,:)%j)) * den(117)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(562),h0tab(:,562),[19,4,8],[nMB,nMB,nMB],3,1,wf8(:,44))
  call Hloop_AZ_Q(ntryL,G0H32(1),wf8(:,44),G0H4(25),ngZd,m3h8x4(:,70),heltab2x32(:,:,562))
  call Hloop_A_Q(ntryL,G0H4(25),19,nMB,G1H4(59),n2h4(190))
  Gcoeff(:)%j = (-(c(20)*M(7,:)%j)) * den(117)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(563),h0tab(:,563),[19,4,8],[0,0,0],3,1,wf8(:,44))
  call Hloop_QZ_A(ntryL,G0H32(1),wf8(:,44),G0H4(25),ngZd,m3h8x4(:,71),heltab2x32(:,:,563))
  call Hloop_Q_A(ntryL,G0H4(25),19,0,G1H4(61),n2h4(191))
  Gcoeff(:)%j = (-(c(19)*M(7,:)%j)) * den(117)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(564),h0tab(:,564),[19,4,8],[nMB,nMB,nMB],3,1,wf8(:,44))
  call Hloop_QZ_A(ntryL,G0H32(1),wf8(:,44),G0H4(25),ngZd,m3h8x4(:,72),heltab2x32(:,:,564))
  call Hloop_Q_A(ntryL,G0H4(25),19,nMB,G1H4(62),n2h4(192))
  Gcoeff(:)%j = (-(c(10)*M(3,:)%j)) * den(87)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(565),h0tab(:,565),[21,2,8],[nMH,nMT,nMT],3,1,wf8(:,91))
  call Hloop_AQ_S(ntryL,G0H32(1),wf8(:,91),G0H4(25),ngH,m3h8x4(:,73),heltab2x32(:,:,565))
  Gcoeff(:)%j = (c(10)*M(3,:)%j) * den(87)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(566),h0tab(:,566),[21,2,8],[nMZ,nMT,nMT],3,1,wf8(:,91))
  call Hloop_AQ_S(ntryL,G0H32(1),wf8(:,91),G0H4(26),ngX,m3h8x4(:,74),heltab2x32(:,:,566))
  Gcoeff(:)%j = (c(8)*M(3,:)%j) * den(87)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(567),h0tab(:,567),[21,2,8],[nMW,nMB,nMB],3,1,wf8(:,91))
  call Hloop_AQ_S(ntryL,G0H32(1),wf8(:,91),G0H4(27),ngPbt,m3h8x4(:,75),heltab2x32(:,:,567))
  Gcoeff(:)%j = (c(3)*M(3,:)%j) * den(87)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(568),h0tab(:,568),[21,2,8],[0,nMT,nMT],3,1,wf8(:,91))
  call Hloop_AQ_V(ntryL,G0H32(1),wf8(:,91),G0H4(28),m3h8x4(:,76),heltab2x32(:,:,568))
  Gcoeff(:)%j = (c(4)*M(3,:)%j) * den(87)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(569),h0tab(:,569),[21,2,8],[nMZ,nMT,nMT],3,1,wf8(:,91))
  call Hloop_AQ_Z(ntryL,G0H32(1),wf8(:,91),G0H4(29),ngZu,m3h8x4(:,77),heltab2x32(:,:,569))
  Gcoeff(:)%j = (c(6)*M(3,:)%j) * den(87)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(570),h0tab(:,570),[21,2,8],[nMW,nMB,nMB],3,1,wf8(:,91))
  call Hloop_AQ_W(ntryL,G0H32(1),wf8(:,91),G0H4(30),m3h8x4(:,78),heltab2x32(:,:,570))
  Gcoeff(:)%j = (-(c(10)*M(1,:)%j)) * den(75)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(571),h0tab(:,571),[25,2,4],[nMH,nMT,nMT],3,1,wf8(:,81))
  call Hloop_AQ_S(ntryL,G0H32(1),wf8(:,81),G0H4(31),ngH,m3h8x4(:,79),heltab2x32(:,:,571))
  Gcoeff(:)%j = (c(10)*M(1,:)%j) * den(75)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(572),h0tab(:,572),[25,2,4],[nMZ,nMT,nMT],3,1,wf8(:,81))
  call Hloop_AQ_S(ntryL,G0H32(1),wf8(:,81),G0H4(32),ngX,m3h8x4(:,80),heltab2x32(:,:,572))
  Gcoeff(:)%j = (c(8)*M(1,:)%j) * den(75)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(573),h0tab(:,573),[25,2,4],[nMW,nMB,nMB],3,1,wf8(:,81))
  call Hloop_AQ_S(ntryL,G0H32(1),wf8(:,81),G0H4(33),ngPbt,m3h8x4(:,81),heltab2x32(:,:,573))
  Gcoeff(:)%j = (c(3)*M(1,:)%j) * den(75)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(574),h0tab(:,574),[25,2,4],[0,nMT,nMT],3,1,wf8(:,81))
  call Hloop_AQ_V(ntryL,G0H32(1),wf8(:,81),G0H4(34),m3h8x4(:,82),heltab2x32(:,:,574))
  Gcoeff(:)%j = (c(4)*M(1,:)%j) * den(75)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(575),h0tab(:,575),[25,2,4],[nMZ,nMT,nMT],3,1,wf8(:,81))
  call Hloop_AQ_Z(ntryL,G0H32(1),wf8(:,81),G0H4(35),ngZu,m3h8x4(:,83),heltab2x32(:,:,575))
  Gcoeff(:)%j = (c(6)*M(1,:)%j) * den(75)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(576),h0tab(:,576),[25,2,4],[nMW,nMB,nMB],3,1,wf8(:,81))
  call Hloop_AQ_W(ntryL,G0H32(1),wf8(:,81),G0H4(36),m3h8x4(:,84),heltab2x32(:,:,576))
  Gcoeff(:)%j = (c(24)*M(7,:)%j) * den(120)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(577),h0tab(:,577),[19,4,8],[nMT,nMT,nMT],3,1,wf8(:,45))
  call Hloop_AS_Q(ntryL,G0H32(1),wf8(:,45),G0H4(37),ngH,m3h8x4(:,85),heltab2x32(:,:,577))
  call Hloop_A_Q(ntryL,G0H4(37),19,nMT,G1H4(65),n2h4(193))
  Gcoeff(:)%j = (c(24)*M(7,:)%j) * den(120)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(578),h0tab(:,578),[19,4,8],[nMT,nMT,nMT],3,1,wf8(:,45))
  call Hloop_QS_A(ntryL,G0H32(1),wf8(:,45),G0H4(37),ngH,m3h8x4(:,86),heltab2x32(:,:,578))
  call Hloop_Q_A(ntryL,G0H4(37),19,nMT,G1H4(66),n2h4(194))
  Gcoeff(:)%j = (c(22)*M(7,:)%j) * den(120)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(579),h0tab(:,579),[19,4,8],[nMB,nMB,nMB],3,1,wf8(:,45))
  call Hloop_AS_Q(ntryL,G0H32(1),wf8(:,45),G0H4(37),ngH,m3h8x4(:,87),heltab2x32(:,:,579))
  call Hloop_A_Q(ntryL,G0H4(37),19,nMB,G1H4(4),n2h4(195))
  Gcoeff(:)%j = (c(22)*M(7,:)%j) * den(120)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(580),h0tab(:,580),[19,4,8],[nMB,nMB,nMB],3,1,wf8(:,45))
  call Hloop_QS_A(ntryL,G0H32(1),wf8(:,45),G0H4(37),ngH,m3h8x4(:,88),heltab2x32(:,:,580))
  call Hloop_Q_A(ntryL,G0H4(37),19,nMB,G1H4(9),n2h4(196))
  Gcoeff(:)%j = (-(c(24)*M(7,:)%j)) * den(121)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(581),h0tab(:,581),[19,4,8],[nMT,nMT,nMT],3,1,wf8(:,104))
  call Hloop_AS_Q(ntryL,G0H32(1),wf8(:,104),G0H4(37),ngX,m3h8x4(:,89),heltab2x32(:,:,581))
  call Hloop_A_Q(ntryL,G0H4(37),19,nMT,G1H4(10),n2h4(197))
  Gcoeff(:)%j = (-(c(24)*M(7,:)%j)) * den(121)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(582),h0tab(:,582),[19,4,8],[nMT,nMT,nMT],3,1,wf8(:,104))
  call Hloop_QS_A(ntryL,G0H32(1),wf8(:,104),G0H4(37),ngX,m3h8x4(:,90),heltab2x32(:,:,582))
  call Hloop_Q_A(ntryL,G0H4(37),19,nMT,G1H4(15),n2h4(198))
  Gcoeff(:)%j = (c(22)*M(7,:)%j) * den(121)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(583),h0tab(:,583),[19,4,8],[nMB,nMB,nMB],3,1,wf8(:,104))
  call Hloop_AS_Q(ntryL,G0H32(1),wf8(:,104),G0H4(37),ngX,m3h8x4(:,91),heltab2x32(:,:,583))
  call Hloop_A_Q(ntryL,G0H4(37),19,nMB,G1H4(21),n2h4(199))
  Gcoeff(:)%j = (c(22)*M(7,:)%j) * den(121)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(584),h0tab(:,584),[19,4,8],[nMB,nMB,nMB],3,1,wf8(:,104))
  call Hloop_QS_A(ntryL,G0H32(1),wf8(:,104),G0H4(37),ngX,m3h8x4(:,92),heltab2x32(:,:,584))
  call Hloop_Q_A(ntryL,G0H4(37),19,nMB,G1H4(22),n2h4(200))
  Gcoeff(:)%j = (-(c(18)*M(7,:)%j)) * den(122)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(585),h0tab(:,585),[19,4,8],[0,0,0],3,1,wf8(:,18))
  call Hloop_AV_Q(ntryL,G0H32(1),wf8(:,18),G0H4(37),m3h8x4(:,93),heltab2x32(:,:,585))
  call Hloop_A_Q(ntryL,G0H4(37),19,0,G1H4(52),n2h4(201))
  Gcoeff(:)%j = (-(c(17)*M(7,:)%j)) * den(122)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(586),h0tab(:,586),[19,4,8],[nMT,nMT,nMT],3,1,wf8(:,18))
  call Hloop_AV_Q(ntryL,G0H32(1),wf8(:,18),G0H4(37),m3h8x4(:,94),heltab2x32(:,:,586))
  call Hloop_A_Q(ntryL,G0H4(37),19,nMT,G1H4(57),n2h4(202))
  Gcoeff(:)%j = (-(c(18)*M(7,:)%j)) * den(122)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(587),h0tab(:,587),[19,4,8],[0,0,0],3,1,wf8(:,18))
  call Hloop_QV_A(ntryL,G0H32(1),wf8(:,18),G0H4(37),m3h8x4(:,95),heltab2x32(:,:,587))
  call Hloop_Q_A(ntryL,G0H4(37),19,0,G1H4(69),n2h4(203))
  Gcoeff(:)%j = (-(c(17)*M(7,:)%j)) * den(122)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(588),h0tab(:,588),[19,4,8],[nMT,nMT,nMT],3,1,wf8(:,18))
  call Hloop_QV_A(ntryL,G0H32(1),wf8(:,18),G0H4(37),m3h8x4(:,96),heltab2x32(:,:,588))
  call Hloop_Q_A(ntryL,G0H4(37),19,nMT,G1H4(70),n2h4(204))
  Gcoeff(:)%j = (c(17)*M(7,:)%j) * den(122)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(589),h0tab(:,589),[19,4,8],[0,0,0],3,1,wf8(:,18))
  call Hloop_AV_Q(ntryL,G0H32(1),wf8(:,18),G0H4(37),m3h8x4(:,97),heltab2x32(:,:,589))
  call Hloop_A_Q(ntryL,G0H4(37),19,0,G1H4(75),n2h4(205))
  Gcoeff(:)%j = (c(16)*M(7,:)%j) * den(122)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(590),h0tab(:,590),[19,4,8],[nMB,nMB,nMB],3,1,wf8(:,18))
  call Hloop_AV_Q(ntryL,G0H32(1),wf8(:,18),G0H4(37),m3h8x4(:,98),heltab2x32(:,:,590))
  call Hloop_A_Q(ntryL,G0H4(37),19,nMB,G1H4(82),n2h4(206))
  Gcoeff(:)%j = (c(17)*M(7,:)%j) * den(122)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(591),h0tab(:,591),[19,4,8],[0,0,0],3,1,wf8(:,18))
  call Hloop_QV_A(ntryL,G0H32(1),wf8(:,18),G0H4(37),m3h8x4(:,99),heltab2x32(:,:,591))
  call Hloop_Q_A(ntryL,G0H4(37),19,0,G1H4(87),n2h4(207))
  Gcoeff(:)%j = (c(16)*M(7,:)%j) * den(122)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(592),h0tab(:,592),[19,4,8],[nMB,nMB,nMB],3,1,wf8(:,18))
  call Hloop_QV_A(ntryL,G0H32(1),wf8(:,18),G0H4(37),m3h8x4(:,100),heltab2x32(:,:,592))
  call Hloop_Q_A(ntryL,G0H4(37),19,nMB,G1H4(88),n2h4(208))
  Gcoeff(:)%j = (-(c(20)*M(7,:)%j)) * den(121)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(593),h0tab(:,593),[19,4,8],[0,0,0],3,1,wf8(:,46))
  call Hloop_AZ_Q(ntryL,G0H32(1),wf8(:,46),G0H4(37),ngZu,m3h8x4(:,101),heltab2x32(:,:,593))
  call Hloop_A_Q(ntryL,G0H4(37),19,0,G1H4(99),n2h4(209))
  Gcoeff(:)%j = (-(c(19)*M(7,:)%j)) * den(121)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(594),h0tab(:,594),[19,4,8],[nMT,nMT,nMT],3,1,wf8(:,46))
  call Hloop_AZ_Q(ntryL,G0H32(1),wf8(:,46),G0H4(37),ngZu,m3h8x4(:,102),heltab2x32(:,:,594))
  call Hloop_A_Q(ntryL,G0H4(37),19,nMT,G1H4(118),n2h4(210))
  Gcoeff(:)%j = (-(c(20)*M(7,:)%j)) * den(121)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(595),h0tab(:,595),[19,4,8],[0,0,0],3,1,wf8(:,46))
  call Hloop_QZ_A(ntryL,G0H32(1),wf8(:,46),G0H4(37),ngZu,m3h8x4(:,103),heltab2x32(:,:,595))
  call Hloop_Q_A(ntryL,G0H4(37),19,0,G1H4(106),n2h4(211))
  Gcoeff(:)%j = (-(c(19)*M(7,:)%j)) * den(121)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(596),h0tab(:,596),[19,4,8],[nMT,nMT,nMT],3,1,wf8(:,46))
  call Hloop_QZ_A(ntryL,G0H32(1),wf8(:,46),G0H4(37),ngZu,m3h8x4(:,104),heltab2x32(:,:,596))
  call Hloop_Q_A(ntryL,G0H4(37),19,nMT,G1H4(105),n2h4(212))
  Gcoeff(:)%j = (-(c(20)*M(7,:)%j)) * den(121)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(597),h0tab(:,597),[19,4,8],[0,0,0],3,1,wf8(:,46))
  call Hloop_AZ_Q(ntryL,G0H32(1),wf8(:,46),G0H4(37),ngZd,m3h8x4(:,105),heltab2x32(:,:,597))
  call Hloop_A_Q(ntryL,G0H4(37),19,0,G1H4(115),n2h4(213))
  Gcoeff(:)%j = (-(c(19)*M(7,:)%j)) * den(121)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(598),h0tab(:,598),[19,4,8],[nMB,nMB,nMB],3,1,wf8(:,46))
  call Hloop_AZ_Q(ntryL,G0H32(1),wf8(:,46),G0H4(37),ngZd,m3h8x4(:,106),heltab2x32(:,:,598))
  call Hloop_A_Q(ntryL,G0H4(37),19,nMB,G1H4(111),n2h4(214))
  Gcoeff(:)%j = (-(c(20)*M(7,:)%j)) * den(121)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(599),h0tab(:,599),[19,4,8],[0,0,0],3,1,wf8(:,46))
  call Hloop_QZ_A(ntryL,G0H32(1),wf8(:,46),G0H4(37),ngZd,m3h8x4(:,107),heltab2x32(:,:,599))
  call Hloop_Q_A(ntryL,G0H4(37),19,0,G1H4(123),n2h4(215))
  Gcoeff(:)%j = (-(c(19)*M(7,:)%j)) * den(121)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(600),h0tab(:,600),[19,4,8],[nMB,nMB,nMB],3,1,wf8(:,46))
  call Hloop_QZ_A(ntryL,G0H32(1),wf8(:,46),G0H4(37),ngZd,m3h8x4(:,108),heltab2x32(:,:,600))
  call Hloop_Q_A(ntryL,G0H4(37),19,nMB,G1H4(142),n2h4(216))
  Gcoeff(:)%j = (-(c(10)*M(5,:)%j)) * den(79)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(601),h0tab(:,601),[22,1,8],[nMH,nMT,nMT],3,1,wf8(:,85))
  call Hloop_QA_S(ntryL,G0H32(1),wf8(:,85),G0H4(37),ngH,m3h8x4(:,109),heltab2x32(:,:,601))
  Gcoeff(:)%j = (c(10)*M(5,:)%j) * den(79)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(602),h0tab(:,602),[22,1,8],[nMZ,nMT,nMT],3,1,wf8(:,85))
  call Hloop_QA_S(ntryL,G0H32(1),wf8(:,85),G0H4(38),ngX,m3h8x4(:,110),heltab2x32(:,:,602))
  Gcoeff(:)%j = (c(8)*M(5,:)%j) * den(79)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(603),h0tab(:,603),[22,1,8],[nMW,nMB,nMB],3,1,wf8(:,85))
  call Hloop_QA_S(ntryL,G0H32(1),wf8(:,85),G0H4(39),ngPtb,m3h8x4(:,111),heltab2x32(:,:,603))
  Gcoeff(:)%j = (c(3)*M(5,:)%j) * den(79)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(604),h0tab(:,604),[22,1,8],[0,nMT,nMT],3,1,wf8(:,85))
  call Hloop_QA_V(ntryL,G0H32(1),wf8(:,85),G0H4(40),m3h8x4(:,112),heltab2x32(:,:,604))
  Gcoeff(:)%j = (c(4)*M(5,:)%j) * den(79)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(605),h0tab(:,605),[22,1,8],[nMZ,nMT,nMT],3,1,wf8(:,85))
  call Hloop_QA_Z(ntryL,G0H32(1),wf8(:,85),G0H4(41),ngZu,m3h8x4(:,113),heltab2x32(:,:,605))
  Gcoeff(:)%j = (c(6)*M(5,:)%j) * den(79)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(606),h0tab(:,606),[22,1,8],[nMW,nMB,nMB],3,1,wf8(:,85))
  call Hloop_QA_W(ntryL,G0H32(1),wf8(:,85),G0H4(42),m3h8x4(:,114),heltab2x32(:,:,606))
  Gcoeff(:)%j = (-(c(10)*M(6,:)%j)) * den(59)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(607),h0tab(:,607),[26,1,4],[nMH,nMT,nMT],3,1,wf8(:,72))
  call Hloop_QA_S(ntryL,G0H32(1),wf8(:,72),G0H4(43),ngH,m3h8x4(:,115),heltab2x32(:,:,607))
  Gcoeff(:)%j = (c(10)*M(6,:)%j) * den(59)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(608),h0tab(:,608),[26,1,4],[nMZ,nMT,nMT],3,1,wf8(:,72))
  call Hloop_QA_S(ntryL,G0H32(1),wf8(:,72),G0H4(44),ngX,m3h8x4(:,116),heltab2x32(:,:,608))
  Gcoeff(:)%j = (c(8)*M(6,:)%j) * den(59)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(609),h0tab(:,609),[26,1,4],[nMW,nMB,nMB],3,1,wf8(:,72))
  call Hloop_QA_S(ntryL,G0H32(1),wf8(:,72),G0H4(45),ngPtb,m3h8x4(:,117),heltab2x32(:,:,609))
  Gcoeff(:)%j = (c(3)*M(6,:)%j) * den(59)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(610),h0tab(:,610),[26,1,4],[0,nMT,nMT],3,1,wf8(:,72))
  call Hloop_QA_V(ntryL,G0H32(1),wf8(:,72),G0H4(46),m3h8x4(:,118),heltab2x32(:,:,610))
  Gcoeff(:)%j = (c(4)*M(6,:)%j) * den(59)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(611),h0tab(:,611),[26,1,4],[nMZ,nMT,nMT],3,1,wf8(:,72))
  call Hloop_QA_Z(ntryL,G0H32(1),wf8(:,72),G0H4(47),ngZu,m3h8x4(:,119),heltab2x32(:,:,611))
  Gcoeff(:)%j = (c(6)*M(6,:)%j) * den(59)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(612),h0tab(:,612),[26,1,4],[nMW,nMB,nMB],3,1,wf8(:,72))
  call Hloop_QA_W(ntryL,G0H32(1),wf8(:,72),G0H4(48),m3h8x4(:,120),heltab2x32(:,:,612))
  Gcoeff(:)%j = (c(9)*(M(3,:)%j-M(4,:)%j)) * den(89)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(613),h0tab(:,613),[21,2,8],[nMH,nMT,nMT],3,1,wf8(:,93))
  call Hloop_AQ_S(ntryL,G0H32(1),wf8(:,93),G0H4(49),ngH,m3h8x4(:,121),heltab2x32(:,:,613))
  Gcoeff(:)%j = (c(9)*(-M(3,:)%j+M(4,:)%j)) * den(89)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(614),h0tab(:,614),[21,2,8],[nMZ,nMT,nMT],3,1,wf8(:,93))
  call Hloop_AQ_S(ntryL,G0H32(1),wf8(:,93),G0H4(50),ngX,m3h8x4(:,122),heltab2x32(:,:,614))
  Gcoeff(:)%j = (c(7)*(-M(3,:)%j+M(4,:)%j)) * den(89)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(615),h0tab(:,615),[21,2,8],[nMW,nMB,nMB],3,1,wf8(:,93))
  call Hloop_AQ_S(ntryL,G0H32(1),wf8(:,93),G0H4(51),ngPbt,m3h8x4(:,123),heltab2x32(:,:,615))
  Gcoeff(:)%j = (c(1)*(-M(3,:)%j+M(4,:)%j)) * den(89)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(616),h0tab(:,616),[21,2,8],[0,nMT,nMT],3,1,wf8(:,93))
  call Hloop_AQ_V(ntryL,G0H32(1),wf8(:,93),G0H4(52),m3h8x4(:,124),heltab2x32(:,:,616))
  Gcoeff(:)%j = (c(2)*(-M(3,:)%j+M(4,:)%j)) * den(89)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(617),h0tab(:,617),[21,2,8],[nMZ,nMT,nMT],3,1,wf8(:,93))
  call Hloop_AQ_Z(ntryL,G0H32(1),wf8(:,93),G0H4(53),ngZu,m3h8x4(:,125),heltab2x32(:,:,617))
  Gcoeff(:)%j = (c(5)*(-M(3,:)%j+M(4,:)%j)) * den(89)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(618),h0tab(:,618),[21,2,8],[nMW,nMB,nMB],3,1,wf8(:,93))
  call Hloop_AQ_W(ntryL,G0H32(1),wf8(:,93),G0H4(54),m3h8x4(:,126),heltab2x32(:,:,618))
  Gcoeff(:)%j = (c(9)*(M(2,:)%j-M(5,:)%j)) * den(83)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(619),h0tab(:,619),[22,1,8],[nMH,nMT,nMT],3,1,wf8(:,88))
  call Hloop_QA_S(ntryL,G0H32(1),wf8(:,88),G0H4(55),ngH,m3h8x4(:,127),heltab2x32(:,:,619))
  Gcoeff(:)%j = (c(9)*(-M(2,:)%j+M(5,:)%j)) * den(83)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(620),h0tab(:,620),[22,1,8],[nMZ,nMT,nMT],3,1,wf8(:,88))
  call Hloop_QA_S(ntryL,G0H32(1),wf8(:,88),G0H4(56),ngX,m3h8x4(:,128),heltab2x32(:,:,620))
  Gcoeff(:)%j = (c(7)*(-M(2,:)%j+M(5,:)%j)) * den(83)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(621),h0tab(:,621),[22,1,8],[nMW,nMB,nMB],3,1,wf8(:,88))
  call Hloop_QA_S(ntryL,G0H32(1),wf8(:,88),G0H4(57),ngPtb,m3h8x4(:,129),heltab2x32(:,:,621))
  Gcoeff(:)%j = (c(1)*(-M(2,:)%j+M(5,:)%j)) * den(83)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(622),h0tab(:,622),[22,1,8],[0,nMT,nMT],3,1,wf8(:,88))
  call Hloop_QA_V(ntryL,G0H32(1),wf8(:,88),G0H4(58),m3h8x4(:,130),heltab2x32(:,:,622))
  Gcoeff(:)%j = (c(2)*(-M(2,:)%j+M(5,:)%j)) * den(83)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(623),h0tab(:,623),[22,1,8],[nMZ,nMT,nMT],3,1,wf8(:,88))
  call Hloop_QA_Z(ntryL,G0H32(1),wf8(:,88),G0H4(59),ngZu,m3h8x4(:,131),heltab2x32(:,:,623))
  Gcoeff(:)%j = (c(5)*(-M(2,:)%j+M(5,:)%j)) * den(83)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(624),h0tab(:,624),[22,1,8],[nMW,nMB,nMB],3,1,wf8(:,88))
  call Hloop_QA_W(ntryL,G0H32(1),wf8(:,88),G0H4(60),m3h8x4(:,132),heltab2x32(:,:,624))
  Gcoeff(:)%j = (c(10)*(M(2,:)%j-M(3,:)%j+M(4,:)%j-M(5,:)%j)) * den(123)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(625),h0tab(:,625),[28,1,2],[nMT,nMH,nMT],3,1,wf8(:,105))
  call Hloop_AV_Q(ntryL,G0H32(1),wf8(:,105),G0H4(61),m3h8x4(:,133),heltab2x32(:,:,625))
  call Hloop_A_Q(ntryL,G0H4(61),28,nMT,G1H4(130),n2h4(217))
  Gcoeff(:)%j = (c(10)*(-M(2,:)%j+M(3,:)%j-M(4,:)%j+M(5,:)%j)) * den(123)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(626),h0tab(:,626),[28,1,2],[nMT,nMZ,nMT],3,1,wf8(:,105))
  call Hloop_AV_Q(ntryL,G0H32(1),wf8(:,105),G0H4(61),m3h8x4(:,134),heltab2x32(:,:,626))
  call Hloop_A_Q(ntryL,G0H4(61),28,nMT,G1H4(129),n2h4(218))
  Gcoeff(:)%j = (c(8)*(-M(2,:)%j+M(3,:)%j-M(4,:)%j+M(5,:)%j)) * den(123)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(627),h0tab(:,627),[28,1,2],[nMB,nMW,nMB],3,1,wf8(:,105))
  call Hloop_AV_Q(ntryL,G0H32(1),wf8(:,105),G0H4(61),m3h8x4(:,135),heltab2x32(:,:,627))
  call Hloop_A_Q(ntryL,G0H4(61),28,nMB,G1H4(89),n2h4(219))
  Gcoeff(:)%j = (c(3)*(-M(2,:)%j+M(3,:)%j-M(4,:)%j+M(5,:)%j)) * den(123)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(628),h0tab(:,628),[28,1,2],[nMT,0,nMT],3,1,wf8(:,105))
  call Hloop_AV_Q(ntryL,G0H32(1),wf8(:,105),G0H4(61),m3h8x4(:,136),heltab2x32(:,:,628))
  call Hloop_A_Q(ntryL,G0H4(61),28,nMT,G1H4(135),n2h4(220))
  Gcoeff(:)%j = (c(4)*(-M(2,:)%j+M(3,:)%j-M(4,:)%j+M(5,:)%j)) * den(123)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(629),h0tab(:,629),[28,1,2],[nMT,nMZ,nMT],3,1,wf8(:,105))
  call Hloop_AV_Q(ntryL,G0H32(1),wf8(:,105),G0H4(61),m3h8x4(:,137),heltab2x32(:,:,629))
  call Hloop_A_Q(ntryL,G0H4(61),28,nMT,G1H4(147),n2h4(221))
  Gcoeff(:)%j = (c(6)*(-M(2,:)%j+M(3,:)%j-M(4,:)%j+M(5,:)%j)) * den(123)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(630),h0tab(:,630),[28,1,2],[nMB,nMW,nMB],3,1,wf8(:,105))
  call Hloop_AV_Q(ntryL,G0H32(1),wf8(:,105),G0H4(61),m3h8x4(:,138),heltab2x32(:,:,630))
  call Hloop_A_Q(ntryL,G0H4(61),28,nMB,G1H4(166),n2h4(222))
  Gcoeff(:)%j = (c(9)*(M(1,:)%j-M(2,:)%j)) * den(77)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(631),h0tab(:,631),[25,2,4],[nMH,nMT,nMT],3,1,wf8(:,83))
  call Hloop_AQ_S(ntryL,G0H32(1),wf8(:,83),G0H4(61),ngH,m3h8x4(:,139),heltab2x32(:,:,631))
  Gcoeff(:)%j = (c(9)*(-M(1,:)%j+M(2,:)%j)) * den(77)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(632),h0tab(:,632),[25,2,4],[nMZ,nMT,nMT],3,1,wf8(:,83))
  call Hloop_AQ_S(ntryL,G0H32(1),wf8(:,83),G0H4(62),ngX,m3h8x4(:,140),heltab2x32(:,:,632))
  Gcoeff(:)%j = (c(7)*(-M(1,:)%j+M(2,:)%j)) * den(77)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(633),h0tab(:,633),[25,2,4],[nMW,nMB,nMB],3,1,wf8(:,83))
  call Hloop_AQ_S(ntryL,G0H32(1),wf8(:,83),G0H4(63),ngPbt,m3h8x4(:,141),heltab2x32(:,:,633))
  Gcoeff(:)%j = (c(1)*(-M(1,:)%j+M(2,:)%j)) * den(77)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(634),h0tab(:,634),[25,2,4],[0,nMT,nMT],3,1,wf8(:,83))
  call Hloop_AQ_V(ntryL,G0H32(1),wf8(:,83),G0H4(64),m3h8x4(:,142),heltab2x32(:,:,634))
  Gcoeff(:)%j = (c(2)*(-M(1,:)%j+M(2,:)%j)) * den(77)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(635),h0tab(:,635),[25,2,4],[nMZ,nMT,nMT],3,1,wf8(:,83))
  call Hloop_AQ_Z(ntryL,G0H32(1),wf8(:,83),G0H4(65),ngZu,m3h8x4(:,143),heltab2x32(:,:,635))
  Gcoeff(:)%j = (c(5)*(-M(1,:)%j+M(2,:)%j)) * den(77)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(636),h0tab(:,636),[25,2,4],[nMW,nMB,nMB],3,1,wf8(:,83))
  call Hloop_AQ_W(ntryL,G0H32(1),wf8(:,83),G0H4(66),m3h8x4(:,144),heltab2x32(:,:,636))
  Gcoeff(:)%j = (c(9)*(M(4,:)%j-M(6,:)%j)) * den(64)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(637),h0tab(:,637),[26,1,4],[nMH,nMT,nMT],3,1,wf8(:,75))
  call Hloop_QA_S(ntryL,G0H32(1),wf8(:,75),G0H4(67),ngH,m3h8x4(:,145),heltab2x32(:,:,637))
  Gcoeff(:)%j = (c(9)*(-M(4,:)%j+M(6,:)%j)) * den(64)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(638),h0tab(:,638),[26,1,4],[nMZ,nMT,nMT],3,1,wf8(:,75))
  call Hloop_QA_S(ntryL,G0H32(1),wf8(:,75),G0H4(68),ngX,m3h8x4(:,146),heltab2x32(:,:,638))
  Gcoeff(:)%j = (c(7)*(-M(4,:)%j+M(6,:)%j)) * den(64)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(639),h0tab(:,639),[26,1,4],[nMW,nMB,nMB],3,1,wf8(:,75))
  call Hloop_QA_S(ntryL,G0H32(1),wf8(:,75),G0H4(69),ngPtb,m3h8x4(:,147),heltab2x32(:,:,639))
  Gcoeff(:)%j = (c(1)*(-M(4,:)%j+M(6,:)%j)) * den(64)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(640),h0tab(:,640),[26,1,4],[0,nMT,nMT],3,1,wf8(:,75))
  call Hloop_QA_V(ntryL,G0H32(1),wf8(:,75),G0H4(70),m3h8x4(:,148),heltab2x32(:,:,640))
  Gcoeff(:)%j = (c(2)*(-M(4,:)%j+M(6,:)%j)) * den(64)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(641),h0tab(:,641),[26,1,4],[nMZ,nMT,nMT],3,1,wf8(:,75))
  call Hloop_QA_Z(ntryL,G0H32(1),wf8(:,75),G0H4(71),ngZu,m3h8x4(:,149),heltab2x32(:,:,641))
  Gcoeff(:)%j = (c(5)*(-M(4,:)%j+M(6,:)%j)) * den(64)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(642),h0tab(:,642),[26,1,4],[nMW,nMB,nMB],3,1,wf8(:,75))
  call Hloop_QA_W(ntryL,G0H32(1),wf8(:,75),G0H4(72),m3h8x4(:,150),heltab2x32(:,:,642))
  Gcoeff(:)%j = (c(10)*(-M(1,:)%j+M(2,:)%j+M(4,:)%j-M(6,:)%j)) * den(124)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(643),h0tab(:,643),[28,1,2],[nMT,nMH,nMT],3,1,wf8(:,106))
  call Hloop_AV_Q(ntryL,G0H32(1),wf8(:,106),G0H4(73),m3h8x4(:,151),heltab2x32(:,:,643))
  call Hloop_A_Q(ntryL,G0H4(73),28,nMT,G1H4(154),n2h4(223))
  Gcoeff(:)%j = (c(10)*(M(1,:)%j-M(2,:)%j-M(4,:)%j+M(6,:)%j)) * den(124)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(644),h0tab(:,644),[28,1,2],[nMT,nMZ,nMT],3,1,wf8(:,106))
  call Hloop_AV_Q(ntryL,G0H32(1),wf8(:,106),G0H4(73),m3h8x4(:,152),heltab2x32(:,:,644))
  call Hloop_A_Q(ntryL,G0H4(73),28,nMT,G1H4(153),n2h4(224))
  Gcoeff(:)%j = (c(8)*(M(1,:)%j-M(2,:)%j-M(4,:)%j+M(6,:)%j)) * den(124)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(645),h0tab(:,645),[28,1,2],[nMB,nMW,nMB],3,1,wf8(:,106))
  call Hloop_AV_Q(ntryL,G0H32(1),wf8(:,106),G0H4(73),m3h8x4(:,153),heltab2x32(:,:,645))
  call Hloop_A_Q(ntryL,G0H4(73),28,nMB,G1H4(97),n2h4(225))
  Gcoeff(:)%j = (c(3)*(M(1,:)%j-M(2,:)%j-M(4,:)%j+M(6,:)%j)) * den(124)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(646),h0tab(:,646),[28,1,2],[nMT,0,nMT],3,1,wf8(:,106))
  call Hloop_AV_Q(ntryL,G0H32(1),wf8(:,106),G0H4(73),m3h8x4(:,154),heltab2x32(:,:,646))
  call Hloop_A_Q(ntryL,G0H4(73),28,nMT,G1H4(159),n2h4(226))
  Gcoeff(:)%j = (c(4)*(M(1,:)%j-M(2,:)%j-M(4,:)%j+M(6,:)%j)) * den(124)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(647),h0tab(:,647),[28,1,2],[nMT,nMZ,nMT],3,1,wf8(:,106))
  call Hloop_AV_Q(ntryL,G0H32(1),wf8(:,106),G0H4(73),m3h8x4(:,155),heltab2x32(:,:,647))
  call Hloop_A_Q(ntryL,G0H4(73),28,nMT,G1H4(131),n2h4(227))
  Gcoeff(:)%j = (c(6)*(M(1,:)%j-M(2,:)%j-M(4,:)%j+M(6,:)%j)) * den(124)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(648),h0tab(:,648),[28,1,2],[nMB,nMW,nMB],3,1,wf8(:,106))
  call Hloop_AV_Q(ntryL,G0H32(1),wf8(:,106),G0H4(73),m3h8x4(:,156),heltab2x32(:,:,648))
  call Hloop_A_Q(ntryL,G0H4(73),28,nMB,G1H4(67),n2h4(228))
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(105),[G1H4(70),G1H4(15),G1H4(66),G1H4(55),G1H4(41) &
    ,G1H4(29),G1H4(20),G1H4(161)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(142),[G1H4(88),G1H4(22),G1H4(9),G1H4(62),G1H4(48) &
    ,G1H4(32),G1H4(25),G1H4(168)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(118),[G1H4(57),G1H4(10),G1H4(65),G1H4(50),G1H4(36) &
    ,G1H4(26),G1H4(19),G1H4(23)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(111),[G1H4(82),G1H4(21),G1H4(4),G1H4(59),G1H4(43) &
    ,G1H4(31),G1H4(24),G1H4(30)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(115),[G1H4(99),G1H4(75),G1H4(52),G1H4(56),G1H4(49) &
    ,G1H4(42),G1H4(35),G1H4(3)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(123),[G1H4(106),G1H4(87),G1H4(69),G1H4(61),G1H4(54) &
    ,G1H4(47),G1H4(38),G1H4(16)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H8(25),[G1H8(3)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H8(26),[G1H8(8)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H8(27),[G1H8(13)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H8(28),[G1H8(18)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H8(29),[G1H8(23)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H8(30),[G1H8(64)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H8(31),[G1H8(69)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H8(32),[G1H8(74)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H8(37),[G1H8(33),G1H8(79)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H8(34),[G1H8(84)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H8(39),[G1H8(35),G1H8(89)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H8(36),[G1H8(94)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H8(38),[G1H8(99)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H8(40),[G1H8(104)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H8(41),[G1H8(109)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H8(42),[G1H8(114)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H8(43),[G1H8(119)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H8(44),[G1H8(124)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H8(45),[G1H8(129)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H8(46),[G1H8(134)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H8(47),[G1H8(139)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H8(48),[G1H8(144)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(154),[G1H4(130),G1H4(8),G1H4(149),G1H4(146),G1H4(145)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(153),[G1H4(129),G1H4(11),G1H4(152),G1H4(151),G1H4(150)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(97),[G1H4(89),G1H4(12),G1H4(157),G1H4(156),G1H4(155)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(159),[G1H4(135),G1H4(13),G1H4(163),G1H4(162),G1H4(158)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(131),[G1H4(147),G1H4(17),G1H4(1),G1H4(167),G1H4(164)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(67),[G1H4(166),G1H4(18),G1H4(6),G1H4(5),G1H4(2)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H16(7),[G1H16(3)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H16(13),[G1H16(5)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H8(1),[G1H8(57)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H8(4),[G1H8(59)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H16(41),[G1H16(39)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H16(43),[G1H16(38)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G0H4(49),[G0H4(25),G0H4(7)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G0H4(50),[G0H4(26),G0H4(8)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G0H4(51),[G0H4(27),G0H4(9)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G0H4(52),[G0H4(28),G0H4(10)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G0H4(53),[G0H4(29),G0H4(11)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G0H4(54),[G0H4(30),G0H4(12)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H16(79),[G1H16(75)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H16(81),[G1H16(77)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G0H4(55),[G0H4(37),G0H4(1)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G0H4(56),[G0H4(38),G0H4(2)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G0H4(57),[G0H4(39),G0H4(3)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G0H4(58),[G0H4(40),G0H4(4)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G0H4(59),[G0H4(41),G0H4(5)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G0H4(60),[G0H4(42),G0H4(6)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H16(109),[G1H16(105)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H16(111),[G1H16(107)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G0H4(61),[G0H4(31),G0H4(13)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G0H4(62),[G0H4(32),G0H4(14)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G0H4(63),[G0H4(33),G0H4(15)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G0H4(64),[G0H4(34),G0H4(16)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G0H4(65),[G0H4(35),G0H4(17)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G0H4(66),[G0H4(36),G0H4(18)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H16(139),[G1H16(135)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H16(141),[G1H16(137)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G0H4(67),[G0H4(43),G0H4(19)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G0H4(68),[G0H4(44),G0H4(20)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G0H4(69),[G0H4(45),G0H4(21)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G0H4(70),[G0H4(46),G0H4(22)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G0H4(71),[G0H4(47),G0H4(23)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G0H4(72),[G0H4(48),G0H4(24)])
  call Hloop_QV_A(ntryL,G1H4(105),ex3(:),G1H2(183),m3h2x2(:,225),heltab2x4(:,:,285))
  call Hloop_Q_A(ntryL,G1H2(183),23,nMT,G2H2(214),n2h2(297))
  call Hloop_QV_A(ntryL,G1H4(142),ex3(:),G1H2(200),m3h2x2(:,226),heltab2x4(:,:,286))
  call Hloop_Q_A(ntryL,G1H2(200),23,nMB,G2H2(196),n2h2(298))
  call Hloop_QV_A(ntryL,G1H4(7),ex4(:),G1H2(205),m3h2x2(:,227),heltab2x4(:,:,287))
  call Hloop_Q_A(ntryL,G1H2(205),27,nMT,G2H2(184),n2h2(299))
  call Hloop_QV_A(ntryL,G1H4(14),ex4(:),G1H2(216),m3h2x2(:,228),heltab2x4(:,:,288))
  call Hloop_Q_A(ntryL,G1H2(216),27,nMB,G2H2(19),n2h2(300))
  call Hloop_AV_Q(ntryL,G1H4(118),ex3(:),G1H2(221),m3h2x2(:,229),heltab2x4(:,:,289))
  call Hloop_A_Q(ntryL,G1H2(221),23,nMT,G2H2(15),n2h2(301))
  call Hloop_AV_Q(ntryL,G1H4(111),ex3(:),G1H2(222),m3h2x2(:,230),heltab2x4(:,:,290))
  call Hloop_A_Q(ntryL,G1H2(222),23,nMB,G2H2(7),n2h2(302))
  call Hloop_AV_Q(ntryL,G1H4(37),ex4(:),G1H2(233),m3h2x2(:,231),heltab2x4(:,:,291))
  call Hloop_A_Q(ntryL,G1H2(233),27,nMT,G2H2(3),n2h2(303))
  call Hloop_AV_Q(ntryL,G1H4(44),ex4(:),G1H2(238),m3h2x2(:,232),heltab2x4(:,:,292))
  call Hloop_A_Q(ntryL,G1H2(238),27,nMB,G2H2(220),n2h2(304))
  call Hloop_QV_A(ntryL,G1H4(53),ex4(:),G1H2(243),m3h2x2(:,233),heltab2x4(:,:,293))
  call Hloop_Q_A(ntryL,G1H2(243),27,0,G2H2(202),n2h2(305))
  call Hloop_AV_Q(ntryL,G1H4(60),ex4(:),G1H2(254),m3h2x2(:,234),heltab2x4(:,:,294))
  call Hloop_A_Q(ntryL,G1H2(254),27,0,G2H2(190),n2h2(306))
  call Hloop_AV_Q(ntryL,G1H4(115),ex3(:),G1H2(255),m3h2x2(:,235),heltab2x4(:,:,295))
  call Hloop_A_Q(ntryL,G1H2(255),23,0,G2H2(23),n2h2(307))
  call Hloop_QV_A(ntryL,G1H4(123),ex3(:),G1H2(260),m3h2x2(:,236),heltab2x4(:,:,296))
  call Hloop_Q_A(ntryL,G1H2(260),23,0,G2H2(11),n2h2(308))
  call Hloop_QS_A(ntryL,G1H8(25),wf4(:,19),G1H2(28),ngH,m3h4x2(:,113),heltab2x8(:,:,243))
  call Hloop_Q_A(ntryL,G1H2(28),23,nMT,G2H2(121),n2h2(309))
  call Hloop_AS_Q(ntryL,G1H8(26),wf4(:,19),G1H2(50),ngH,m3h4x2(:,114),heltab2x8(:,:,244))
  call Hloop_A_Q(ntryL,G1H2(50),23,nMT,G2H2(27),n2h2(310))
  call Hloop_QS_A(ntryL,G1H8(27),wf4(:,19),G1H2(61),ngH,m3h4x2(:,115),heltab2x8(:,:,245))
  call Hloop_Q_A(ntryL,G1H2(61),23,nMB,G2H2(122),n2h2(311))
  call Hloop_AS_Q(ntryL,G1H8(28),wf4(:,19),G1H2(105),ngH,m3h4x2(:,116),heltab2x8(:,:,246))
  call Hloop_A_Q(ntryL,G1H2(105),23,nMB,G2H2(125),n2h2(312))
  call Hloop_QS_A(ntryL,G1H8(29),wf4(:,44),G1H2(116),ngX,m3h4x2(:,117),heltab2x8(:,:,247))
  call Hloop_Q_A(ntryL,G1H2(116),23,nMT,G2H2(84),n2h2(313))
  call Hloop_AS_Q(ntryL,G1H8(30),wf4(:,44),G1H2(138),ngX,m3h4x2(:,118),heltab2x8(:,:,248))
  call Hloop_A_Q(ntryL,G1H2(138),23,nMT,G2H2(31),n2h2(314))
  call Hloop_QS_A(ntryL,G1H8(31),wf4(:,44),G1H2(182),ngX,m3h4x2(:,119),heltab2x8(:,:,249))
  call Hloop_Q_A(ntryL,G1H2(182),23,nMB,G2H2(123),n2h2(315))
  call Hloop_AS_Q(ntryL,G1H8(32),wf4(:,44),G1H2(193),ngX,m3h4x2(:,120),heltab2x8(:,:,250))
  call Hloop_A_Q(ntryL,G1H2(193),23,nMB,G2H2(126),n2h2(316))
  call Hloop_QV_A(ntryL,G1H8(37),wf4(:,1),G1H2(204),m3h4x2(:,121),heltab2x8(:,:,251))
  call Hloop_Q_A(ntryL,G1H2(204),23,0,G2H2(85),n2h2(317))
  call Hloop_QV_A(ntryL,G1H8(34),wf4(:,1),G1H2(248),m3h4x2(:,122),heltab2x8(:,:,252))
  call Hloop_Q_A(ntryL,G1H2(248),23,nMT,G2H2(35),n2h2(318))
  call Hloop_AV_Q(ntryL,G1H8(39),wf4(:,1),G1H2(1),m3h4x2(:,123),heltab2x8(:,:,253))
  call Hloop_A_Q(ntryL,G1H2(1),23,0,G2H2(124),n2h2(319))
  call Hloop_AV_Q(ntryL,G1H8(36),wf4(:,1),G1H2(2),m3h4x2(:,124),heltab2x8(:,:,254))
  call Hloop_A_Q(ntryL,G1H2(2),23,nMT,G2H2(39),n2h2(320))
  call Hloop_QV_A(ntryL,G1H8(38),wf4(:,1),G1H2(13),m3h4x2(:,125),heltab2x8(:,:,255))
  call Hloop_Q_A(ntryL,G1H2(13),23,nMB,G2H2(208),n2h2(321))
  call Hloop_AV_Q(ntryL,G1H8(40),wf4(:,1),G1H2(18),m3h4x2(:,126),heltab2x8(:,:,256))
  call Hloop_A_Q(ntryL,G1H2(18),23,nMB,G2H2(193),n2h2(322))
  call Hloop_QZ_A(ntryL,G1H8(41),wf4(:,17),G1H2(23),ngZu,m3h4x2(:,127),heltab2x8(:,:,257))
  call Hloop_Q_A(ntryL,G1H2(23),23,0,G2H2(181),n2h2(323))
  call Hloop_QZ_A(ntryL,G1H8(42),wf4(:,17),G1H2(34),ngZu,m3h4x2(:,128),heltab2x8(:,:,258))
  call Hloop_Q_A(ntryL,G1H2(34),23,nMT,G2H2(59),n2h2(324))
  call Hloop_AZ_Q(ntryL,G1H8(43),wf4(:,17),G1H2(35),ngZu,m3h4x2(:,129),heltab2x8(:,:,259))
  call Hloop_A_Q(ntryL,G1H2(35),23,0,G2H2(55),n2h2(325))
  call Hloop_AZ_Q(ntryL,G1H8(44),wf4(:,17),G1H2(40),ngZu,m3h4x2(:,130),heltab2x8(:,:,260))
  call Hloop_A_Q(ntryL,G1H2(40),23,nMT,G2H2(47),n2h2(326))
  call Hloop_QZ_A(ntryL,G1H8(45),wf4(:,17),G1H2(51),ngZd,m3h4x2(:,131),heltab2x8(:,:,261))
  call Hloop_Q_A(ntryL,G1H2(51),23,0,G2H2(43),n2h2(327))
  call Hloop_QZ_A(ntryL,G1H8(46),wf4(:,17),G1H2(56),ngZd,m3h4x2(:,132),heltab2x8(:,:,262))
  call Hloop_Q_A(ntryL,G1H2(56),23,nMB,G2H2(217),n2h2(328))
  call Hloop_AZ_Q(ntryL,G1H8(47),wf4(:,17),G1H2(57),ngZd,m3h4x2(:,133),heltab2x8(:,:,263))
  call Hloop_A_Q(ntryL,G1H2(57),23,0,G2H2(199),n2h2(329))
  call Hloop_AZ_Q(ntryL,G1H8(48),wf4(:,17),G1H2(68),ngZd,m3h4x2(:,134),heltab2x8(:,:,264))
  call Hloop_A_Q(ntryL,G1H2(68),23,nMB,G2H2(187),n2h2(330))
  call Hloop_AQ_S(ntryL,G1H4(154),ex1(:),G1H2(73),ngH,m3h2x2(:,237),heltab2x4(:,:,297))
  call Hloop_AQ_S(ntryL,G1H4(153),ex1(:),G1H2(78),ngX,m3h2x2(:,238),heltab2x4(:,:,298))
  call Hloop_AQ_S(ntryL,G1H4(97),ex1(:),G1H2(89),ngPbt,m3h2x2(:,239),heltab2x4(:,:,299))
  call Hloop_AQ_V(ntryL,G1H4(159),ex1(:),G1H2(90),m3h2x2(:,240),heltab2x4(:,:,300))
  call Hloop_AQ_Z(ntryL,G1H4(131),ex1(:),G1H2(95),ngZu,m3h2x2(:,241),heltab2x4(:,:,301))
  call Hloop_AQ_W(ntryL,G1H4(67),ex1(:),G1H2(106),m3h2x2(:,242),heltab2x4(:,:,302))
  call Hloop_AS_Q(ntryL,G1H16(9),wf4(:,19),G1H4(132),ngH,m3h4x4(:,57),heltab2x16(:,:,163))
  call Hloop_A_Q(ntryL,G1H4(132),19,nMT,G2H4(13),n2h4(229))
  call Hloop_QS_A(ntryL,G1H16(11),wf4(:,19),G1H4(71),ngH,m3h4x4(:,58),heltab2x16(:,:,164))
  call Hloop_Q_A(ntryL,G1H4(71),19,nMT,G2H4(7),n2h4(230))
  call Hloop_AS_Q(ntryL,G1H16(33),wf4(:,19),G1H4(134),ngH,m3h4x4(:,59),heltab2x16(:,:,165))
  call Hloop_A_Q(ntryL,G1H4(134),19,nMB,G2H4(35),n2h4(231))
  call Hloop_QS_A(ntryL,G1H16(35),wf4(:,19),G1H4(72),ngH,m3h4x4(:,60),heltab2x16(:,:,166))
  call Hloop_Q_A(ntryL,G1H4(72),19,nMB,G2H4(29),n2h4(232))
  call Hloop_AS_Q(ntryL,G1H16(57),wf4(:,44),G1H4(138),ngX,m3h4x4(:,61),heltab2x16(:,:,167))
  call Hloop_A_Q(ntryL,G1H4(138),19,nMT,G2H4(23),n2h4(233))
  call Hloop_QS_A(ntryL,G1H16(59),wf4(:,44),G1H4(74),ngX,m3h4x4(:,62),heltab2x16(:,:,168))
  call Hloop_Q_A(ntryL,G1H4(74),19,nMT,G2H4(14),n2h4(234))
  call Hloop_AS_Q(ntryL,G1H16(1),wf4(:,44),G1H4(103),ngX,m3h4x4(:,63),heltab2x16(:,:,169))
  call Hloop_A_Q(ntryL,G1H4(103),19,nMB,G2H4(11),n2h4(235))
  call Hloop_QS_A(ntryL,G1H16(2),wf4(:,44),G1H4(108),ngX,m3h4x4(:,64),heltab2x16(:,:,170))
  call Hloop_Q_A(ntryL,G1H4(108),19,nMB,G2H4(22),n2h4(236))
  call Hloop_AV_Q(ntryL,G1H16(7),wf4(:,1),G1H4(121),m3h4x4(:,65),heltab2x16(:,:,171))
  call Hloop_A_Q(ntryL,G1H4(121),19,0,G2H4(16),n2h4(237))
  call Hloop_AV_Q(ntryL,G1H16(4),wf4(:,1),G1H4(77),m3h4x4(:,66),heltab2x16(:,:,172))
  call Hloop_A_Q(ntryL,G1H4(77),19,nMT,G2H4(10),n2h4(238))
  call Hloop_QV_A(ntryL,G1H16(13),wf4(:,1),G1H4(125),m3h4x4(:,67),heltab2x16(:,:,173))
  call Hloop_Q_A(ntryL,G1H4(125),19,0,G2H4(9),n2h4(239))
  call Hloop_QV_A(ntryL,G1H16(6),wf4(:,1),G1H4(79),m3h4x4(:,68),heltab2x16(:,:,174))
  call Hloop_Q_A(ntryL,G1H4(79),19,nMT,G2H4(31),n2h4(240))
  call Hloop_AV_Q(ntryL,G1H16(8),wf4(:,1),G1H4(126),m3h4x4(:,69),heltab2x16(:,:,175))
  call Hloop_A_Q(ntryL,G1H4(126),19,nMB,G2H4(25),n2h4(241))
  call Hloop_QV_A(ntryL,G1H16(10),wf4(:,1),G1H4(83),m3h4x4(:,70),heltab2x16(:,:,176))
  call Hloop_Q_A(ntryL,G1H4(83),19,nMB,G2H4(26),n2h4(242))
  call Hloop_AZ_Q(ntryL,G1H16(15),wf4(:,17),G1H4(128),ngZu,m3h4x4(:,71),heltab2x16(:,:,177))
  call Hloop_A_Q(ntryL,G1H4(128),19,0,G2H4(36),n2h4(243))
  call Hloop_AZ_Q(ntryL,G1H16(12),wf4(:,17),G1H4(84),ngZu,m3h4x4(:,72),heltab2x16(:,:,178))
  call Hloop_A_Q(ntryL,G1H4(84),19,nMT,G2H4(30),n2h4(244))
  call Hloop_QZ_A(ntryL,G1H16(14),wf4(:,17),G1H4(120),ngZu,m3h4x4(:,73),heltab2x16(:,:,179))
  call Hloop_Q_A(ntryL,G1H4(120),19,0,G2H4(18),n2h4(245))
  call Hloop_QZ_A(ntryL,G1H16(16),wf4(:,17),G1H4(116),ngZu,m3h4x4(:,74),heltab2x16(:,:,180))
  call Hloop_Q_A(ntryL,G1H4(116),19,nMT,G2H4(15),n2h4(246))
  call Hloop_AZ_Q(ntryL,G1H16(17),wf4(:,17),G1H4(85),ngZd,m3h4x4(:,75),heltab2x16(:,:,181))
  call Hloop_A_Q(ntryL,G1H4(85),19,0,G2H4(12),n2h4(247))
  call Hloop_AZ_Q(ntryL,G1H16(18),wf4(:,17),G1H4(90),ngZd,m3h4x4(:,76),heltab2x16(:,:,182))
  call Hloop_A_Q(ntryL,G1H4(90),19,nMB,G2H4(24),n2h4(248))
  call Hloop_QZ_A(ntryL,G1H16(19),wf4(:,17),G1H4(95),ngZd,m3h4x4(:,77),heltab2x16(:,:,183))
  call Hloop_Q_A(ntryL,G1H4(95),19,0,G2H4(21),n2h4(249))
  call Hloop_QZ_A(ntryL,G1H16(20),wf4(:,17),G1H4(101),ngZd,m3h4x4(:,78),heltab2x16(:,:,184))
  call Hloop_Q_A(ntryL,G1H4(101),19,nMB,G2H4(34),n2h4(250))
  call Hloop_QS_A(ntryL,G1H8(49),wf4(:,19),G1H2(111),ngH,m3h4x2(:,135),heltab2x8(:,:,265))
  call Hloop_Q_A(ntryL,G1H2(111),27,nMT,G2H2(63),n2h2(331))
  call Hloop_AS_Q(ntryL,G1H8(50),wf4(:,19),G1H2(112),ngH,m3h4x2(:,136),heltab2x8(:,:,266))
  call Hloop_A_Q(ntryL,G1H2(112),27,nMT,G2H2(51),n2h2(332))
  call Hloop_QS_A(ntryL,G1H8(51),wf4(:,19),G1H2(123),ngH,m3h4x2(:,137),heltab2x8(:,:,267))
  call Hloop_Q_A(ntryL,G1H2(123),27,nMB,G2H2(25),n2h2(333))
  call Hloop_AS_Q(ntryL,G1H8(52),wf4(:,19),G1H2(128),ngH,m3h4x2(:,138),heltab2x8(:,:,268))
  call Hloop_A_Q(ntryL,G1H2(128),27,nMB,G2H2(67),n2h2(334))
  call Hloop_QS_A(ntryL,G1H8(53),wf4(:,44),G1H2(133),ngX,m3h4x2(:,139),heltab2x8(:,:,269))
  call Hloop_Q_A(ntryL,G1H2(133),27,nMT,G2H2(29),n2h2(335))
  call Hloop_AS_Q(ntryL,G1H8(54),wf4(:,44),G1H2(144),ngX,m3h4x2(:,140),heltab2x8(:,:,270))
  call Hloop_A_Q(ntryL,G1H2(144),27,nMT,G2H2(41),n2h2(336))
  call Hloop_QS_A(ntryL,G1H8(55),wf4(:,44),G1H2(145),ngX,m3h4x2(:,141),heltab2x8(:,:,271))
  call Hloop_Q_A(ntryL,G1H2(145),27,nMB,G2H2(108),n2h2(337))
  call Hloop_AS_Q(ntryL,G1H8(56),wf4(:,44),G1H2(150),ngX,m3h4x2(:,142),heltab2x8(:,:,272))
  call Hloop_A_Q(ntryL,G1H2(150),27,nMB,G2H2(71),n2h2(338))
  call Hloop_QV_A(ntryL,G1H8(1),wf4(:,1),G1H2(166),m3h4x2(:,143),heltab2x8(:,:,273))
  call Hloop_Q_A(ntryL,G1H2(166),27,0,G2H2(33),n2h2(339))
  call Hloop_QV_A(ntryL,G1H8(58),wf4(:,1),G1H2(172),m3h4x2(:,144),heltab2x8(:,:,274))
  call Hloop_Q_A(ntryL,G1H2(172),27,nMT,G2H2(57),n2h2(340))
  call Hloop_AV_Q(ntryL,G1H8(4),wf4(:,1),G1H2(177),m3h4x2(:,145),heltab2x8(:,:,275))
  call Hloop_A_Q(ntryL,G1H2(177),27,0,G2H2(109),n2h2(341))
  call Hloop_AV_Q(ntryL,G1H8(60),wf4(:,1),G1H2(189),m3h4x2(:,146),heltab2x8(:,:,276))
  call Hloop_A_Q(ntryL,G1H2(189),27,nMT,G2H2(75),n2h2(342))
  call Hloop_QV_A(ntryL,G1H8(2),wf4(:,1),G1H2(194),m3h4x2(:,147),heltab2x8(:,:,277))
  call Hloop_Q_A(ntryL,G1H2(194),27,nMB,G2H2(37),n2h2(343))
  call Hloop_AV_Q(ntryL,G1H8(5),wf4(:,1),G1H2(38),m3h4x2(:,148),heltab2x8(:,:,278))
  call Hloop_A_Q(ntryL,G1H2(38),27,nMB,G2H2(79),n2h2(344))
  call Hloop_QZ_A(ntryL,G1H8(6),wf4(:,17),G1H2(27),ngZu,m3h4x2(:,149),heltab2x8(:,:,279))
  call Hloop_Q_A(ntryL,G1H2(27),27,0,G2H2(127),n2h2(345))
  call Hloop_QZ_A(ntryL,G1H8(7),wf4(:,17),G1H2(49),ngZu,m3h4x2(:,150),heltab2x8(:,:,280))
  call Hloop_Q_A(ntryL,G1H2(49),27,nMT,G2H2(83),n2h2(346))
  call Hloop_AZ_Q(ntryL,G1H8(9),wf4(:,17),G1H2(60),ngZu,m3h4x2(:,151),heltab2x8(:,:,281))
  call Hloop_A_Q(ntryL,G1H2(60),27,0,G2H2(128),n2h2(347))
  call Hloop_AZ_Q(ntryL,G1H8(10),wf4(:,17),G1H2(126),ngZu,m3h4x2(:,152),heltab2x8(:,:,282))
  call Hloop_A_Q(ntryL,G1H2(126),27,nMT,G2H2(131),n2h2(348))
  call Hloop_QZ_A(ntryL,G1H8(11),wf4(:,17),G1H2(104),ngZd,m3h4x2(:,153),heltab2x8(:,:,283))
  call Hloop_Q_A(ntryL,G1H2(104),27,0,G2H2(96),n2h2(349))
  call Hloop_QZ_A(ntryL,G1H8(12),wf4(:,17),G1H2(93),ngZd,m3h4x2(:,154),heltab2x8(:,:,284))
  call Hloop_Q_A(ntryL,G1H2(93),27,nMB,G2H2(87),n2h2(350))
  call Hloop_AZ_Q(ntryL,G1H8(14),wf4(:,17),G1H2(137),ngZd,m3h4x2(:,155),heltab2x8(:,:,285))
  call Hloop_A_Q(ntryL,G1H2(137),27,0,G2H2(129),n2h2(351))
  call Hloop_AZ_Q(ntryL,G1H8(15),wf4(:,17),G1H2(102),ngZd,m3h4x2(:,156),heltab2x8(:,:,286))
  call Hloop_A_Q(ntryL,G1H2(102),27,nMB,G2H2(132),n2h2(352))
  call Hloop_AQ_S(ntryL,G1H16(21),wf4(:,7),G1H4(27),ngH,m3h4x4(:,79),heltab2x16(:,:,185))
  call Hloop_AQ_S(ntryL,G1H16(22),wf4(:,7),G1H4(28),ngX,m3h4x4(:,80),heltab2x16(:,:,186))
  call Hloop_AQ_S(ntryL,G1H16(23),wf4(:,7),G1H4(33),ngPbt,m3h4x4(:,81),heltab2x16(:,:,187))
  call Hloop_AQ_V(ntryL,G1H16(24),wf4(:,7),G1H4(58),m3h4x4(:,82),heltab2x16(:,:,188))
  call Hloop_AQ_Z(ntryL,G1H16(25),wf4(:,7),G1H4(46),ngZu,m3h4x4(:,83),heltab2x16(:,:,189))
  call Hloop_AQ_W(ntryL,G1H16(26),wf4(:,7),G1H4(40),m3h4x4(:,84),heltab2x16(:,:,190))
  call Hloop_SQ_A(ntryL,G0H8(20),wf4(:,7),G0H2(1),ngH,m3h4x2(:,157),heltab2x8(:,:,287))
  call Hloop_Q_A(ntryL,G0H2(1),23,nMT,G1H2(148),n2h2(353))
  call Hloop_SQ_A(ntryL,G0H8(21),wf4(:,7),G0H2(1),ngX,m3h4x2(:,158),heltab2x8(:,:,288))
  call Hloop_Q_A(ntryL,G0H2(1),23,nMT,G1H2(124),n2h2(354))
  call Hloop_SQ_A(ntryL,G0H8(22),wf4(:,7),G0H2(1),ngPbt,m3h4x2(:,159),heltab2x8(:,:,289))
  call Hloop_Q_A(ntryL,G0H2(1),23,nMB,G1H2(170),n2h2(355))
  call Hloop_VQ_A(ntryL,G0H8(23),wf4(:,7),G0H2(1),m3h4x2(:,160),heltab2x8(:,:,290))
  call Hloop_Q_A(ntryL,G0H2(1),23,nMT,G1H2(181),n2h2(356))
  call Hloop_ZQ_A(ntryL,G0H8(24),wf4(:,7),G0H2(1),ngZu,m3h4x2(:,161),heltab2x8(:,:,291))
  call Hloop_Q_A(ntryL,G0H2(1),23,nMT,G1H2(214),n2h2(357))
  call Hloop_WQ_A(ntryL,G0H8(25),wf4(:,7),G0H2(1),m3h4x2(:,162),heltab2x8(:,:,292))
  call Hloop_Q_A(ntryL,G0H2(1),23,nMB,G1H2(3),n2h2(358))
  call Hloop_QA_S(ntryL,G1H8(16),ex2(:),G1H4(107),ngH,m3h2x4(:,131),heltab2x8(:,:,293))
  call Hloop_QA_S(ntryL,G1H8(17),ex2(:),G1H4(51),ngX,m3h2x4(:,132),heltab2x8(:,:,294))
  call Hloop_QA_S(ntryL,G1H8(19),ex2(:),G1H4(139),ngPtb,m3h2x4(:,133),heltab2x8(:,:,295))
  call Hloop_QA_V(ntryL,G1H8(20),ex2(:),G1H4(144),m3h2x4(:,134),heltab2x8(:,:,296))
  call Hloop_QA_Z(ntryL,G1H8(21),ex2(:),G1H4(70),ngZu,m3h2x4(:,135),heltab2x8(:,:,297))
  call Hloop_QA_W(ntryL,G1H8(22),ex2(:),G1H4(15),m3h2x4(:,136),heltab2x8(:,:,298))
  call Hloop_AS_Q(ntryL,G1H16(27),wf8(:,31),G1H2(225),ngH,m3h8x2(:,1),heltab2x16(:,:,191))
  call Hloop_A_Q(ntryL,G1H2(225),23,nMT,G2H2(97),n2h2(359))
  call Hloop_QS_A(ntryL,G1H16(28),wf8(:,31),G1H2(25),ngH,m3h8x2(:,2),heltab2x16(:,:,192))
  call Hloop_Q_A(ntryL,G1H2(25),23,nMT,G2H2(91),n2h2(360))
  call Hloop_AS_Q(ntryL,G1H16(29),wf8(:,31),G1H2(247),ngH,m3h8x2(:,3),heltab2x16(:,:,193))
  call Hloop_A_Q(ntryL,G1H2(247),23,nMB,G2H2(130),n2h2(361))
  call Hloop_QS_A(ntryL,G1H16(30),wf8(:,31),G1H2(36),ngH,m3h8x2(:,4),heltab2x16(:,:,194))
  call Hloop_Q_A(ntryL,G1H2(36),23,nMB,G2H2(95),n2h2(362))
  call Hloop_AS_Q(ntryL,G1H16(31),wf8(:,98),G1H2(44),ngX,m3h8x2(:,5),heltab2x16(:,:,195))
  call Hloop_A_Q(ntryL,G1H2(44),23,nMT,G2H2(5),n2h2(363))
  call Hloop_QS_A(ntryL,G1H16(32),wf8(:,98),G1H2(22),ngX,m3h8x2(:,6),heltab2x16(:,:,196))
  call Hloop_Q_A(ntryL,G1H2(22),23,nMT,G2H2(99),n2h2(364))
  call Hloop_AS_Q(ntryL,G1H16(37),wf8(:,98),G1H2(11),ngX,m3h8x2(:,7),heltab2x16(:,:,197))
  call Hloop_A_Q(ntryL,G1H2(11),23,nMB,G2H2(9),n2h2(365))
  call Hloop_QS_A(ntryL,G1H16(34),wf8(:,98),G1H2(33),ngX,m3h8x2(:,8),heltab2x16(:,:,198))
  call Hloop_Q_A(ntryL,G1H2(33),23,nMB,G2H2(1),n2h2(366))
  call Hloop_AV_Q(ntryL,G1H16(41),wf8(:,9),G1H2(37),m3h8x2(:,9),heltab2x16(:,:,199))
  call Hloop_A_Q(ntryL,G1H2(37),23,0,G2H2(116),n2h2(367))
  call Hloop_AV_Q(ntryL,G1H16(36),wf8(:,9),G1H2(47),m3h8x2(:,10),heltab2x16(:,:,200))
  call Hloop_A_Q(ntryL,G1H2(47),23,nMT,G2H2(103),n2h2(368))
  call Hloop_QV_A(ntryL,G1H16(43),wf8(:,9),G1H2(48),m3h8x2(:,11),heltab2x16(:,:,201))
  call Hloop_Q_A(ntryL,G1H2(48),23,0,G2H2(45),n2h2(369))
  call Hloop_QV_A(ntryL,G1H16(40),wf8(:,9),G1H2(87),m3h8x2(:,12),heltab2x16(:,:,202))
  call Hloop_Q_A(ntryL,G1H2(87),23,nMT,G2H2(17),n2h2(370))
  call Hloop_AV_Q(ntryL,G1H16(42),wf8(:,9),G1H2(65),m3h8x2(:,13),heltab2x16(:,:,203))
  call Hloop_A_Q(ntryL,G1H2(65),23,nMB,G2H2(117),n2h2(371))
  call Hloop_QV_A(ntryL,G1H16(44),wf8(:,9),G1H2(69),m3h8x2(:,14),heltab2x16(:,:,204))
  call Hloop_Q_A(ntryL,G1H2(69),23,nMB,G2H2(107),n2h2(372))
  call Hloop_AZ_Q(ntryL,G1H16(45),wf8(:,32),G1H2(70),ngZu,m3h8x2(:,15),heltab2x16(:,:,205))
  call Hloop_A_Q(ntryL,G1H2(70),23,0,G2H2(49),n2h2(373))
  call Hloop_AZ_Q(ntryL,G1H16(46),wf8(:,32),G1H2(76),ngZu,m3h8x2(:,16),heltab2x16(:,:,206))
  call Hloop_A_Q(ntryL,G1H2(76),23,nMT,G2H2(111),n2h2(374))
  call Hloop_QZ_A(ntryL,G1H16(47),wf8(:,32),G1H2(132),ngZu,m3h8x2(:,17),heltab2x16(:,:,207))
  call Hloop_Q_A(ntryL,G1H2(132),23,0,G2H2(216),n2h2(375))
  call Hloop_QZ_A(ntryL,G1H16(48),wf8(:,32),G1H2(110),ngZu,m3h8x2(:,18),heltab2x16(:,:,208))
  call Hloop_Q_A(ntryL,G1H2(110),23,nMT,G2H2(198),n2h2(376))
  call Hloop_AZ_Q(ntryL,G1H16(49),wf8(:,32),G1H2(99),ngZd,m3h8x2(:,19),heltab2x16(:,:,209))
  call Hloop_A_Q(ntryL,G1H2(99),23,0,G2H2(186),n2h2(377))
  call Hloop_AZ_Q(ntryL,G1H16(50),wf8(:,32),G1H2(121),ngZd,m3h8x2(:,20),heltab2x16(:,:,210))
  call Hloop_A_Q(ntryL,G1H2(121),23,nMB,G2H2(12),n2h2(378))
  call Hloop_QZ_A(ntryL,G1H16(51),wf8(:,32),G1H2(125),ngZd,m3h8x2(:,21),heltab2x16(:,:,211))
  call Hloop_Q_A(ntryL,G1H2(125),23,0,G2H2(48),n2h2(379))
  call Hloop_QZ_A(ntryL,G1H16(52),wf8(:,32),G1H2(135),ngZd,m3h8x2(:,22),heltab2x16(:,:,212))
  call Hloop_Q_A(ntryL,G1H2(135),23,nMB,G2H2(222),n2h2(380))
  call Hloop_QA_S(ntryL,G1H16(53),ex2(:),G1H8(97),ngH,m3h2x8(:,107),heltab2x16(:,:,213))
  call Hloop_QA_S(ntryL,G1H16(54),ex2(:),G1H8(98),ngX,m3h2x8(:,108),heltab2x16(:,:,214))
  call Hloop_QA_S(ntryL,G1H16(55),ex2(:),G1H8(100),ngPtb,m3h2x8(:,109),heltab2x16(:,:,215))
  call Hloop_QA_V(ntryL,G1H16(56),ex2(:),G1H8(101),m3h2x8(:,110),heltab2x16(:,:,216))
  call Hloop_QA_Z(ntryL,G1H16(61),ex2(:),G1H8(102),ngZu,m3h2x8(:,111),heltab2x16(:,:,217))
  call Hloop_QA_W(ntryL,G1H16(58),ex2(:),G1H8(103),m3h2x8(:,112),heltab2x16(:,:,218))
  call Hloop_SA_Q(ntryL,G0H4(49),ex2(:),G0H2(1),ngH,m3h2x2(:,243),heltab2x4(:,:,303))
  call Hloop_A_Q(ntryL,G0H2(1),23,nMT,G1H2(136),n2h2(381))
  call Hloop_SA_Q(ntryL,G0H4(50),ex2(:),G0H2(1),ngX,m3h2x2(:,244),heltab2x4(:,:,304))
  call Hloop_A_Q(ntryL,G0H2(1),23,nMT,G1H2(175),n2h2(382))
  call Hloop_SA_Q(ntryL,G0H4(51),ex2(:),G0H2(1),ngPtb,m3h2x2(:,245),heltab2x4(:,:,305))
  call Hloop_A_Q(ntryL,G0H2(1),23,nMB,G1H2(153),n2h2(383))
  call Hloop_VA_Q(ntryL,G0H4(52),ex2(:),G0H2(1),m3h2x2(:,246),heltab2x4(:,:,306))
  call Hloop_A_Q(ntryL,G0H2(1),23,nMT,G1H2(157),n2h2(384))
  call Hloop_ZA_Q(ntryL,G0H4(53),ex2(:),G0H2(1),ngZu,m3h2x2(:,247),heltab2x4(:,:,307))
  call Hloop_A_Q(ntryL,G0H2(1),23,nMT,G1H2(158),n2h2(385))
  call Hloop_WA_Q(ntryL,G0H4(54),ex2(:),G0H2(1),m3h2x2(:,248),heltab2x4(:,:,308))
  call Hloop_A_Q(ntryL,G0H2(1),23,nMB,G1H2(164),n2h2(386))
  call Hloop_QA_S(ntryL,G1H16(63),wf4(:,14),G1H4(66),ngH,m3h4x4(:,85),heltab2x16(:,:,219))
  call Hloop_QA_S(ntryL,G1H16(60),wf4(:,14),G1H4(55),ngX,m3h4x4(:,86),heltab2x16(:,:,220))
  call Hloop_QA_S(ntryL,G1H16(62),wf4(:,14),G1H4(41),ngPtb,m3h4x4(:,87),heltab2x16(:,:,221))
  call Hloop_QA_V(ntryL,G1H16(64),wf4(:,14),G1H4(29),m3h4x4(:,88),heltab2x16(:,:,222))
  call Hloop_QA_Z(ntryL,G1H16(65),wf4(:,14),G1H4(20),ngZu,m3h4x4(:,89),heltab2x16(:,:,223))
  call Hloop_QA_W(ntryL,G1H16(66),wf4(:,14),G1H4(161),m3h4x4(:,90),heltab2x16(:,:,224))
  call Hloop_SA_Q(ntryL,G0H8(7),wf4(:,14),G0H2(1),ngH,m3h4x2(:,163),heltab2x8(:,:,299))
  call Hloop_A_Q(ntryL,G0H2(1),23,nMT,G1H2(213),n2h2(387))
  call Hloop_SA_Q(ntryL,G0H8(8),wf4(:,14),G0H2(1),ngX,m3h4x2(:,164),heltab2x8(:,:,300))
  call Hloop_A_Q(ntryL,G0H2(1),23,nMT,G1H2(191),n2h2(388))
  call Hloop_SA_Q(ntryL,G0H8(9),wf4(:,14),G0H2(1),ngPtb,m3h4x2(:,165),heltab2x8(:,:,301))
  call Hloop_A_Q(ntryL,G0H2(1),23,nMB,G1H2(180),n2h2(389))
  call Hloop_VA_Q(ntryL,G0H8(10),wf4(:,14),G0H2(1),m3h4x2(:,166),heltab2x8(:,:,302))
  call Hloop_A_Q(ntryL,G0H2(1),23,nMT,G1H2(186),n2h2(390))
  call Hloop_ZA_Q(ntryL,G0H8(11),wf4(:,14),G0H2(1),ngZu,m3h4x2(:,167),heltab2x8(:,:,303))
  call Hloop_A_Q(ntryL,G0H2(1),23,nMT,G1H2(190),n2h2(391))
  call Hloop_WA_Q(ntryL,G0H8(12),wf4(:,14),G0H2(1),m3h4x2(:,168),heltab2x8(:,:,304))
  call Hloop_A_Q(ntryL,G0H2(1),23,nMB,G1H2(201),n2h2(392))
  call Hloop_AQ_S(ntryL,G1H8(24),ex1(:),G1H4(88),ngH,m3h2x4(:,137),heltab2x8(:,:,305))
  call Hloop_AQ_S(ntryL,G1H8(61),ex1(:),G1H4(22),ngX,m3h2x4(:,138),heltab2x8(:,:,306))
  call Hloop_AQ_S(ntryL,G1H8(62),ex1(:),G1H4(9),ngPbt,m3h2x4(:,139),heltab2x8(:,:,307))
  call Hloop_AQ_V(ntryL,G1H8(63),ex1(:),G1H4(62),m3h2x4(:,140),heltab2x8(:,:,308))
  call Hloop_AQ_Z(ntryL,G1H8(65),ex1(:),G1H4(48),ngZu,m3h2x4(:,141),heltab2x8(:,:,309))
  call Hloop_AQ_W(ntryL,G1H8(66),ex1(:),G1H4(32),m3h2x4(:,142),heltab2x8(:,:,310))
  call Hloop_AS_Q(ntryL,G1H16(67),wf8(:,35),G1H2(212),ngH,m3h8x2(:,23),heltab2x16(:,:,225))
  call Hloop_A_Q(ntryL,G1H2(212),23,nMT,G2H2(204),n2h2(393))
  call Hloop_QS_A(ntryL,G1H16(68),wf8(:,35),G1H2(223),ngH,m3h8x2(:,24),heltab2x16(:,:,226))
  call Hloop_Q_A(ntryL,G1H2(223),23,nMT,G2H2(192),n2h2(394))
  call Hloop_AS_Q(ntryL,G1H16(69),wf8(:,35),G1H2(257),ngH,m3h8x2(:,25),heltab2x16(:,:,227))
  call Hloop_A_Q(ntryL,G1H2(257),23,nMB,G2H2(210),n2h2(395))
  call Hloop_QS_A(ntryL,G1H16(70),wf8(:,35),G1H2(263),ngH,m3h8x2(:,26),heltab2x16(:,:,228))
  call Hloop_Q_A(ntryL,G1H2(263),23,nMB,G2H2(195),n2h2(396))
  call Hloop_AS_Q(ntryL,G1H16(71),wf8(:,99),G1H2(241),ngX,m3h8x2(:,27),heltab2x16(:,:,229))
  call Hloop_A_Q(ntryL,G1H2(241),23,nMT,G2H2(183),n2h2(397))
  call Hloop_QS_A(ntryL,G1H16(72),wf8(:,99),G1H2(230),ngX,m3h8x2(:,28),heltab2x16(:,:,230))
  call Hloop_Q_A(ntryL,G1H2(230),23,nMT,G2H2(32),n2h2(398))
  call Hloop_AS_Q(ntryL,G1H16(73),wf8(:,99),G1H2(246),ngX,m3h8x2(:,29),heltab2x16(:,:,231))
  call Hloop_A_Q(ntryL,G1H2(246),23,nMB,G2H2(36),n2h2(399))
  call Hloop_QS_A(ntryL,G1H16(74),wf8(:,99),G1H2(252),ngX,m3h8x2(:,30),heltab2x16(:,:,232))
  call Hloop_Q_A(ntryL,G1H2(252),23,nMB,G2H2(219),n2h2(400))
  call Hloop_AV_Q(ntryL,G1H16(79),wf8(:,12),G1H2(256),m3h8x2(:,31),heltab2x16(:,:,233))
  call Hloop_A_Q(ntryL,G1H2(256),23,0,G2H2(201),n2h2(401))
  call Hloop_AV_Q(ntryL,G1H16(76),wf8(:,12),G1H2(83),m3h8x2(:,32),heltab2x16(:,:,234))
  call Hloop_A_Q(ntryL,G1H2(83),23,nMT,G2H2(189),n2h2(402))
  call Hloop_QV_A(ntryL,G1H16(81),wf8(:,12),G1H2(74),m3h8x2(:,33),heltab2x16(:,:,235))
  call Hloop_Q_A(ntryL,G1H2(74),23,0,G2H2(223),n2h2(403))
  call Hloop_QV_A(ntryL,G1H16(78),wf8(:,12),G1H2(8),m3h8x2(:,34),heltab2x16(:,:,236))
  call Hloop_Q_A(ntryL,G1H2(8),23,nMT,G2H2(205),n2h2(404))
  call Hloop_AV_Q(ntryL,G1H16(80),wf8(:,12),G1H2(19),m3h8x2(:,35),heltab2x16(:,:,237))
  call Hloop_A_Q(ntryL,G1H2(19),23,nMB,G2H2(225),n2h2(405))
  call Hloop_QV_A(ntryL,G1H16(82),wf8(:,12),G1H2(171),m3h8x2(:,36),heltab2x16(:,:,238))
  call Hloop_Q_A(ntryL,G1H2(171),23,nMB,G2H2(207),n2h2(406))
  call Hloop_AZ_Q(ntryL,G1H16(83),wf8(:,36),G1H2(96),ngZu,m3h8x2(:,37),heltab2x16(:,:,239))
  call Hloop_A_Q(ntryL,G1H2(96),23,0,G2H2(229),n2h2(407))
  call Hloop_AZ_Q(ntryL,G1H16(84),wf8(:,36),G1H2(107),ngZu,m3h8x2(:,38),heltab2x16(:,:,240))
  call Hloop_A_Q(ntryL,G1H2(107),23,nMT,G2H2(211),n2h2(408))
  call Hloop_QZ_A(ntryL,G1H16(85),wf8(:,36),G1H2(41),ngZu,m3h8x2(:,39),heltab2x16(:,:,241))
  call Hloop_Q_A(ntryL,G1H2(41),23,0,G2H2(231),n2h2(409))
  call Hloop_QZ_A(ntryL,G1H16(86),wf8(:,36),G1H2(129),ngZu,m3h8x2(:,40),heltab2x16(:,:,242))
  call Hloop_Q_A(ntryL,G1H2(129),23,nMT,G2H2(213),n2h2(410))
  call Hloop_AZ_Q(ntryL,G1H16(87),wf8(:,36),G1H2(266),ngZd,m3h8x2(:,41),heltab2x16(:,:,243))
  call Hloop_A_Q(ntryL,G1H2(266),23,0,G2H2(2),n2h2(411))
  call Hloop_AZ_Q(ntryL,G1H16(88),wf8(:,36),G1H2(267),ngZd,m3h8x2(:,42),heltab2x16(:,:,244))
  call Hloop_A_Q(ntryL,G1H2(267),23,nMB,G2H2(232),n2h2(412))
  call Hloop_QZ_A(ntryL,G1H16(89),wf8(:,36),G1H2(268),ngZd,m3h8x2(:,43),heltab2x16(:,:,245))
  call Hloop_Q_A(ntryL,G1H2(268),23,0,G2H2(6),n2h2(413))
  call Hloop_QZ_A(ntryL,G1H16(90),wf8(:,36),G1H2(271),ngZd,m3h8x2(:,44),heltab2x16(:,:,246))
  call Hloop_Q_A(ntryL,G1H2(271),23,nMB,G2H2(10),n2h2(414))
  call Hloop_AQ_S(ntryL,G1H16(91),ex1(:),G1H8(105),ngH,m3h2x8(:,113),heltab2x16(:,:,247))
  call Hloop_AQ_S(ntryL,G1H16(92),ex1(:),G1H8(106),ngX,m3h2x8(:,114),heltab2x16(:,:,248))
  call Hloop_AQ_S(ntryL,G1H16(93),ex1(:),G1H8(107),ngPbt,m3h2x8(:,115),heltab2x16(:,:,249))
  call Hloop_AQ_V(ntryL,G1H16(94),ex1(:),G1H8(108),m3h2x8(:,116),heltab2x16(:,:,250))
  call Hloop_AQ_Z(ntryL,G1H16(95),ex1(:),G1H8(110),ngZu,m3h2x8(:,117),heltab2x16(:,:,251))
  call Hloop_AQ_W(ntryL,G1H16(96),ex1(:),G1H8(111),m3h2x8(:,118),heltab2x16(:,:,252))
  call Hloop_SQ_A(ntryL,G0H4(55),ex1(:),G0H2(1),ngH,m3h2x2(:,249),heltab2x4(:,:,309))
  call Hloop_Q_A(ntryL,G0H2(1),23,nMT,G1H2(272),n2h2(415))
  call Hloop_SQ_A(ntryL,G0H4(56),ex1(:),G0H2(1),ngX,m3h2x2(:,250),heltab2x4(:,:,310))
  call Hloop_Q_A(ntryL,G0H2(1),23,nMT,G1H2(273),n2h2(416))
  call Hloop_SQ_A(ntryL,G0H4(57),ex1(:),G0H2(1),ngPbt,m3h2x2(:,251),heltab2x4(:,:,311))
  call Hloop_Q_A(ntryL,G0H2(1),23,nMB,G1H2(276),n2h2(417))
  call Hloop_VQ_A(ntryL,G0H4(58),ex1(:),G0H2(1),m3h2x2(:,252),heltab2x4(:,:,312))
  call Hloop_Q_A(ntryL,G0H2(1),23,nMT,G1H2(277),n2h2(418))
  call Hloop_ZQ_A(ntryL,G0H4(59),ex1(:),G0H2(1),ngZu,m3h2x2(:,253),heltab2x4(:,:,313))
  call Hloop_Q_A(ntryL,G0H2(1),23,nMT,G1H2(278),n2h2(419))
  call Hloop_WQ_A(ntryL,G0H4(60),ex1(:),G0H2(1),m3h2x2(:,254),heltab2x4(:,:,314))
  call Hloop_Q_A(ntryL,G0H2(1),23,nMB,G1H2(281),n2h2(420))
  call Hloop_AV_Q(ntryL,G1H8(67),ex3(:),G1H4(25),m3h2x4(:,143),heltab2x8(:,:,311))
  call Hloop_A_Q(ntryL,G1H4(25),22,nMT,G2H4(28),n2h4(251))
  call Hloop_AV_Q(ntryL,G1H8(68),ex3(:),G1H4(168),m3h2x4(:,144),heltab2x8(:,:,312))
  call Hloop_A_Q(ntryL,G1H4(168),22,nMT,G2H4(27),n2h4(252))
  call Hloop_AV_Q(ntryL,G1H8(70),ex3(:),G1H4(57),m3h2x4(:,145),heltab2x8(:,:,313))
  call Hloop_A_Q(ntryL,G1H4(57),22,nMB,G2H4(47),n2h4(253))
  call Hloop_AV_Q(ntryL,G1H8(71),ex3(:),G1H4(10),m3h2x4(:,146),heltab2x8(:,:,314))
  call Hloop_A_Q(ntryL,G1H4(10),22,nMT,G2H4(48),n2h4(254))
  call Hloop_AV_Q(ntryL,G1H8(72),ex3(:),G1H4(65),m3h2x4(:,147),heltab2x8(:,:,315))
  call Hloop_A_Q(ntryL,G1H4(65),22,nMT,G2H4(49),n2h4(255))
  call Hloop_AV_Q(ntryL,G1H8(73),ex3(:),G1H4(50),m3h2x4(:,148),heltab2x8(:,:,316))
  call Hloop_A_Q(ntryL,G1H4(50),22,nMB,G2H4(50),n2h4(256))
  call Hloop_QA_S(ntryL,G1H8(75),ex2(:),G1H4(36),ngH,m3h2x4(:,149),heltab2x8(:,:,317))
  call Hloop_QA_S(ntryL,G1H8(76),ex2(:),G1H4(26),ngX,m3h2x4(:,150),heltab2x8(:,:,318))
  call Hloop_QA_S(ntryL,G1H8(77),ex2(:),G1H4(19),ngPtb,m3h2x4(:,151),heltab2x8(:,:,319))
  call Hloop_QA_V(ntryL,G1H8(78),ex2(:),G1H4(23),m3h2x4(:,152),heltab2x8(:,:,320))
  call Hloop_QA_Z(ntryL,G1H8(80),ex2(:),G1H4(82),ngZu,m3h2x4(:,153),heltab2x8(:,:,321))
  call Hloop_QA_W(ntryL,G1H8(81),ex2(:),G1H4(21),m3h2x4(:,154),heltab2x8(:,:,322))
  call Hloop_QV_A(ntryL,G1H16(97),ex3(:),G1H8(112),m3h2x8(:,119),heltab2x16(:,:,253))
  call Hloop_Q_A(ntryL,G1H8(112),20,nMT,G2H8(23),n2h8(177))
  call Hloop_AV_Q(ntryL,G1H16(98),ex3(:),G1H8(113),m3h2x8(:,120),heltab2x16(:,:,254))
  call Hloop_A_Q(ntryL,G1H8(113),20,nMT,G2H8(24),n2h8(178))
  call Hloop_QV_A(ntryL,G1H16(99),ex3(:),G1H8(115),m3h2x8(:,121),heltab2x16(:,:,255))
  call Hloop_Q_A(ntryL,G1H8(115),20,nMB,G2H8(25),n2h8(179))
  call Hloop_AV_Q(ntryL,G1H16(100),ex3(:),G1H8(116),m3h2x8(:,122),heltab2x16(:,:,256))
  call Hloop_A_Q(ntryL,G1H8(116),20,nMB,G2H8(26),n2h8(180))
  call Hloop_QV_A(ntryL,G1H16(101),ex3(:),G1H8(117),m3h2x8(:,123),heltab2x16(:,:,257))
  call Hloop_Q_A(ntryL,G1H8(117),20,nMT,G2H8(27),n2h8(181))
  call Hloop_AV_Q(ntryL,G1H16(102),ex3(:),G1H8(118),m3h2x8(:,124),heltab2x16(:,:,258))
  call Hloop_A_Q(ntryL,G1H8(118),20,nMT,G2H8(28),n2h8(182))
  call Hloop_QV_A(ntryL,G1H16(103),ex3(:),G1H8(120),m3h2x8(:,125),heltab2x16(:,:,259))
  call Hloop_Q_A(ntryL,G1H8(120),20,nMB,G2H8(29),n2h8(183))
  call Hloop_AV_Q(ntryL,G1H16(104),ex3(:),G1H8(121),m3h2x8(:,126),heltab2x16(:,:,260))
  call Hloop_A_Q(ntryL,G1H8(121),20,nMB,G2H8(30),n2h8(184))
  call Hloop_QV_A(ntryL,G1H16(109),ex3(:),G1H8(122),m3h2x8(:,127),heltab2x16(:,:,261))
  call Hloop_Q_A(ntryL,G1H8(122),20,0,G2H8(31),n2h8(185))
  call Hloop_QV_A(ntryL,G1H16(106),ex3(:),G1H8(123),m3h2x8(:,128),heltab2x16(:,:,262))
  call Hloop_Q_A(ntryL,G1H8(123),20,nMT,G2H8(32),n2h8(186))
  call Hloop_AV_Q(ntryL,G1H16(111),ex3(:),G1H8(125),m3h2x8(:,129),heltab2x16(:,:,263))
  call Hloop_A_Q(ntryL,G1H8(125),20,0,G2H8(33),n2h8(187))
  call Hloop_AV_Q(ntryL,G1H16(108),ex3(:),G1H8(126),m3h2x8(:,130),heltab2x16(:,:,264))
  call Hloop_A_Q(ntryL,G1H8(126),20,nMT,G2H8(34),n2h8(188))
  call Hloop_QV_A(ntryL,G1H16(110),ex3(:),G1H8(127),m3h2x8(:,131),heltab2x16(:,:,265))
  call Hloop_Q_A(ntryL,G1H8(127),20,nMB,G2H8(1),n2h8(189))
  call Hloop_AV_Q(ntryL,G1H16(112),ex3(:),G1H8(128),m3h2x8(:,132),heltab2x16(:,:,266))
  call Hloop_A_Q(ntryL,G1H8(128),20,nMB,G2H8(2),n2h8(190))
  call Hloop_QV_A(ntryL,G1H16(113),ex3(:),G1H8(130),m3h2x8(:,133),heltab2x16(:,:,267))
  call Hloop_Q_A(ntryL,G1H8(130),20,0,G2H8(3),n2h8(191))
  call Hloop_QV_A(ntryL,G1H16(114),ex3(:),G1H8(131),m3h2x8(:,134),heltab2x16(:,:,268))
  call Hloop_Q_A(ntryL,G1H8(131),20,nMT,G2H8(4),n2h8(192))
  call Hloop_AV_Q(ntryL,G1H16(115),ex3(:),G1H8(132),m3h2x8(:,135),heltab2x16(:,:,269))
  call Hloop_A_Q(ntryL,G1H8(132),20,0,G2H8(5),n2h8(193))
  call Hloop_AV_Q(ntryL,G1H16(116),ex3(:),G1H8(133),m3h2x8(:,136),heltab2x16(:,:,270))
  call Hloop_A_Q(ntryL,G1H8(133),20,nMT,G2H8(6),n2h8(194))
  call Hloop_QV_A(ntryL,G1H16(117),ex3(:),G1H8(135),m3h2x8(:,137),heltab2x16(:,:,271))
  call Hloop_Q_A(ntryL,G1H8(135),20,0,G2H8(7),n2h8(195))
  call Hloop_QV_A(ntryL,G1H16(118),ex3(:),G1H8(136),m3h2x8(:,138),heltab2x16(:,:,272))
  call Hloop_Q_A(ntryL,G1H8(136),20,nMB,G2H8(8),n2h8(196))
  call Hloop_AV_Q(ntryL,G1H16(119),ex3(:),G1H8(137),m3h2x8(:,139),heltab2x16(:,:,273))
  call Hloop_A_Q(ntryL,G1H8(137),20,0,G2H8(9),n2h8(197))
  call Hloop_AV_Q(ntryL,G1H16(120),ex3(:),G1H8(138),m3h2x8(:,140),heltab2x16(:,:,274))
  call Hloop_A_Q(ntryL,G1H8(138),20,nMB,G2H8(10),n2h8(198))
  call Hloop_QA_S(ntryL,G1H16(121),ex2(:),G1H8(140),ngH,m3h2x8(:,141),heltab2x16(:,:,275))
  call Hloop_QA_S(ntryL,G1H16(122),ex2(:),G1H8(141),ngX,m3h2x8(:,142),heltab2x16(:,:,276))
  call Hloop_QA_S(ntryL,G1H16(123),ex2(:),G1H8(142),ngPtb,m3h2x8(:,143),heltab2x16(:,:,277))
  call Hloop_QA_V(ntryL,G1H16(124),ex2(:),G1H8(143),m3h2x8(:,144),heltab2x16(:,:,278))
  call Hloop_QA_Z(ntryL,G1H16(125),ex2(:),G1H8(145),ngZu,m3h2x8(:,145),heltab2x16(:,:,279))
  call Hloop_QA_W(ntryL,G1H16(126),ex2(:),G1H8(146),m3h2x8(:,146),heltab2x16(:,:,280))
  call Hloop_SA_Q(ntryL,G0H4(61),ex2(:),G0H2(1),ngH,m3h2x2(:,255),heltab2x4(:,:,315))
  call Hloop_A_Q(ntryL,G0H2(1),27,nMT,G1H2(282),n2h2(421))
  call Hloop_SA_Q(ntryL,G0H4(62),ex2(:),G0H2(1),ngX,m3h2x2(:,256),heltab2x4(:,:,316))
  call Hloop_A_Q(ntryL,G0H2(1),27,nMT,G1H2(283),n2h2(422))
  call Hloop_SA_Q(ntryL,G0H4(63),ex2(:),G0H2(1),ngPtb,m3h2x2(:,257),heltab2x4(:,:,317))
  call Hloop_A_Q(ntryL,G0H2(1),27,nMB,G1H2(286),n2h2(423))
  call Hloop_VA_Q(ntryL,G0H4(64),ex2(:),G0H2(1),m3h2x2(:,258),heltab2x4(:,:,318))
  call Hloop_A_Q(ntryL,G0H2(1),27,nMT,G1H2(287),n2h2(424))
  call Hloop_ZA_Q(ntryL,G0H4(65),ex2(:),G0H2(1),ngZu,m3h2x2(:,259),heltab2x4(:,:,319))
  call Hloop_A_Q(ntryL,G0H2(1),27,nMT,G1H2(288),n2h2(425))
  call Hloop_WA_Q(ntryL,G0H4(66),ex2(:),G0H2(1),m3h2x2(:,260),heltab2x4(:,:,320))
  call Hloop_A_Q(ntryL,G0H2(1),27,nMB,G1H2(291),n2h2(426))
  call Hloop_QV_A(ntryL,G1H8(82),ex3(:),G1H4(4),m3h2x4(:,155),heltab2x8(:,:,323))
  call Hloop_Q_A(ntryL,G1H4(4),21,nMT,G2H4(51),n2h4(257))
  call Hloop_QV_A(ntryL,G1H8(83),ex3(:),G1H4(59),m3h2x4(:,156),heltab2x8(:,:,324))
  call Hloop_Q_A(ntryL,G1H4(59),21,nMT,G2H4(52),n2h4(258))
  call Hloop_QV_A(ntryL,G1H8(85),ex3(:),G1H4(43),m3h2x4(:,157),heltab2x8(:,:,325))
  call Hloop_Q_A(ntryL,G1H4(43),21,nMB,G2H4(53),n2h4(259))
  call Hloop_QV_A(ntryL,G1H8(86),ex3(:),G1H4(31),m3h2x4(:,158),heltab2x8(:,:,326))
  call Hloop_Q_A(ntryL,G1H4(31),21,nMT,G2H4(54),n2h4(260))
  call Hloop_QV_A(ntryL,G1H8(87),ex3(:),G1H4(24),m3h2x4(:,159),heltab2x8(:,:,327))
  call Hloop_Q_A(ntryL,G1H4(24),21,nMT,G2H4(55),n2h4(261))
  call Hloop_QV_A(ntryL,G1H8(88),ex3(:),G1H4(30),m3h2x4(:,160),heltab2x8(:,:,328))
  call Hloop_Q_A(ntryL,G1H4(30),21,nMB,G2H4(56),n2h4(262))
  call Hloop_AQ_S(ntryL,G1H8(90),ex1(:),G1H4(99),ngH,m3h2x4(:,161),heltab2x8(:,:,329))
  call Hloop_AQ_S(ntryL,G1H8(91),ex1(:),G1H4(75),ngX,m3h2x4(:,162),heltab2x8(:,:,330))
  call Hloop_AQ_S(ntryL,G1H8(92),ex1(:),G1H4(52),ngPbt,m3h2x4(:,163),heltab2x8(:,:,331))
  call Hloop_AQ_V(ntryL,G1H8(93),ex1(:),G1H4(56),m3h2x4(:,164),heltab2x8(:,:,332))
  call Hloop_AQ_Z(ntryL,G1H8(95),ex1(:),G1H4(49),ngZu,m3h2x4(:,165),heltab2x8(:,:,333))
  call Hloop_AQ_W(ntryL,G1H8(96),ex1(:),G1H4(42),m3h2x4(:,166),heltab2x8(:,:,334))
  call Hloop_QV_A(ntryL,G1H16(127),ex3(:),G1H8(3),m3h2x8(:,147),heltab2x16(:,:,281))
  call Hloop_Q_A(ntryL,G1H8(3),20,nMT,G2H8(11),n2h8(199))
  call Hloop_AV_Q(ntryL,G1H16(128),ex3(:),G1H8(8),m3h2x8(:,148),heltab2x16(:,:,282))
  call Hloop_A_Q(ntryL,G1H8(8),20,nMT,G2H8(12),n2h8(200))
  call Hloop_QV_A(ntryL,G1H16(129),ex3(:),G1H8(13),m3h2x8(:,149),heltab2x16(:,:,283))
  call Hloop_Q_A(ntryL,G1H8(13),20,nMB,G2H8(13),n2h8(201))
  call Hloop_AV_Q(ntryL,G1H16(130),ex3(:),G1H8(18),m3h2x8(:,150),heltab2x16(:,:,284))
  call Hloop_A_Q(ntryL,G1H8(18),20,nMB,G2H8(14),n2h8(202))
  call Hloop_QV_A(ntryL,G1H16(131),ex3(:),G1H8(23),m3h2x8(:,151),heltab2x16(:,:,285))
  call Hloop_Q_A(ntryL,G1H8(23),20,nMT,G2H8(15),n2h8(203))
  call Hloop_AV_Q(ntryL,G1H16(132),ex3(:),G1H8(64),m3h2x8(:,152),heltab2x16(:,:,286))
  call Hloop_A_Q(ntryL,G1H8(64),20,nMT,G2H8(16),n2h8(204))
  call Hloop_QV_A(ntryL,G1H16(133),ex3(:),G1H8(69),m3h2x8(:,153),heltab2x16(:,:,287))
  call Hloop_Q_A(ntryL,G1H8(69),20,nMB,G2H8(17),n2h8(205))
  call Hloop_AV_Q(ntryL,G1H16(134),ex3(:),G1H8(74),m3h2x8(:,154),heltab2x16(:,:,288))
  call Hloop_A_Q(ntryL,G1H8(74),20,nMB,G2H8(18),n2h8(206))
  call Hloop_QV_A(ntryL,G1H16(139),ex3(:),G1H8(33),m3h2x8(:,155),heltab2x16(:,:,289))
  call Hloop_Q_A(ntryL,G1H8(33),20,0,G2H8(19),n2h8(207))
  call Hloop_QV_A(ntryL,G1H16(136),ex3(:),G1H8(79),m3h2x8(:,156),heltab2x16(:,:,290))
  call Hloop_Q_A(ntryL,G1H8(79),20,nMT,G2H8(20),n2h8(208))
  call Hloop_AV_Q(ntryL,G1H16(141),ex3(:),G1H8(84),m3h2x8(:,157),heltab2x16(:,:,291))
  call Hloop_A_Q(ntryL,G1H8(84),20,0,G2H8(21),n2h8(209))
  call Hloop_AV_Q(ntryL,G1H16(138),ex3(:),G1H8(35),m3h2x8(:,158),heltab2x16(:,:,292))
  call Hloop_A_Q(ntryL,G1H8(35),20,nMT,G2H8(22),n2h8(210))
  call Hloop_QV_A(ntryL,G1H16(140),ex3(:),G1H8(89),m3h2x8(:,159),heltab2x16(:,:,293))
  call Hloop_Q_A(ntryL,G1H8(89),20,nMB,G2H8(35),n2h8(211))
  call Hloop_AV_Q(ntryL,G1H16(142),ex3(:),G1H8(94),m3h2x8(:,160),heltab2x16(:,:,294))
  call Hloop_A_Q(ntryL,G1H8(94),20,nMB,G2H8(36),n2h8(212))
  call Hloop_QV_A(ntryL,G1H16(143),ex3(:),G1H8(99),m3h2x8(:,161),heltab2x16(:,:,295))
  call Hloop_Q_A(ntryL,G1H8(99),20,0,G2H8(37),n2h8(213))
  call Hloop_QV_A(ntryL,G1H16(144),ex3(:),G1H8(104),m3h2x8(:,162),heltab2x16(:,:,296))
  call Hloop_Q_A(ntryL,G1H8(104),20,nMT,G2H8(38),n2h8(214))
  call Hloop_AV_Q(ntryL,G1H16(145),ex3(:),G1H8(109),m3h2x8(:,163),heltab2x16(:,:,297))
  call Hloop_A_Q(ntryL,G1H8(109),20,0,G2H8(39),n2h8(215))
  call Hloop_AV_Q(ntryL,G1H16(146),ex3(:),G1H8(114),m3h2x8(:,164),heltab2x16(:,:,298))
  call Hloop_A_Q(ntryL,G1H8(114),20,nMT,G2H8(40),n2h8(216))
  call Hloop_QV_A(ntryL,G1H16(147),ex3(:),G1H8(119),m3h2x8(:,165),heltab2x16(:,:,299))
  call Hloop_Q_A(ntryL,G1H8(119),20,0,G2H8(41),n2h8(217))
  call Hloop_QV_A(ntryL,G1H16(148),ex3(:),G1H8(124),m3h2x8(:,166),heltab2x16(:,:,300))
  call Hloop_Q_A(ntryL,G1H8(124),20,nMB,G2H8(42),n2h8(218))
  call Hloop_AV_Q(ntryL,G1H16(149),ex3(:),G1H8(129),m3h2x8(:,167),heltab2x16(:,:,301))
  call Hloop_A_Q(ntryL,G1H8(129),20,0,G2H8(43),n2h8(219))
  call Hloop_AV_Q(ntryL,G1H16(150),ex3(:),G1H8(134),m3h2x8(:,168),heltab2x16(:,:,302))
  call Hloop_A_Q(ntryL,G1H8(134),20,nMB,G2H8(44),n2h8(220))
  call Hloop_AQ_S(ntryL,G1H16(151),ex1(:),G1H8(139),ngH,m3h2x8(:,169),heltab2x16(:,:,303))
  call Hloop_AQ_S(ntryL,G1H16(152),ex1(:),G1H8(144),ngX,m3h2x8(:,170),heltab2x16(:,:,304))
  call Hloop_AQ_S(ntryL,G1H16(153),ex1(:),G1H8(57),ngPbt,m3h2x8(:,171),heltab2x16(:,:,305))
  call Hloop_AQ_V(ntryL,G1H16(154),ex1(:),G1H8(59),m3h2x8(:,172),heltab2x16(:,:,306))
  call Hloop_AQ_Z(ntryL,G1H16(155),ex1(:),G1H8(25),ngZu,m3h2x8(:,173),heltab2x16(:,:,307))
  call Hloop_AQ_W(ntryL,G1H16(156),ex1(:),G1H8(26),m3h2x8(:,174),heltab2x16(:,:,308))
  call Hloop_SQ_A(ntryL,G0H4(67),ex1(:),G0H2(1),ngH,m3h2x2(:,261),heltab2x4(:,:,321))
  call Hloop_Q_A(ntryL,G0H2(1),27,nMT,G1H2(292),n2h2(427))
  call Hloop_SQ_A(ntryL,G0H4(68),ex1(:),G0H2(1),ngX,m3h2x2(:,262),heltab2x4(:,:,322))
  call Hloop_Q_A(ntryL,G0H2(1),27,nMT,G1H2(293),n2h2(428))
  call Hloop_SQ_A(ntryL,G0H4(69),ex1(:),G0H2(1),ngPbt,m3h2x2(:,263),heltab2x4(:,:,323))
  call Hloop_Q_A(ntryL,G0H2(1),27,nMB,G1H2(296),n2h2(429))
  call Hloop_VQ_A(ntryL,G0H4(70),ex1(:),G0H2(1),m3h2x2(:,264),heltab2x4(:,:,324))
  call Hloop_Q_A(ntryL,G0H2(1),27,nMT,G1H2(297),n2h2(430))
  call Hloop_ZQ_A(ntryL,G0H4(71),ex1(:),G0H2(1),ngZu,m3h2x2(:,265),heltab2x4(:,:,325))
  call Hloop_Q_A(ntryL,G0H2(1),27,nMT,G1H2(298),n2h2(431))
  call Hloop_WQ_A(ntryL,G0H4(72),ex1(:),G0H2(1),m3h2x2(:,266),heltab2x4(:,:,326))
  call Hloop_Q_A(ntryL,G0H2(1),27,nMB,G1H2(301),n2h2(432))
  call Hloop_SA_Q(ntryL,G0H8(17),ex2(:),G0H4(73),ngH,m3h2x4(:,167),heltab2x8(:,:,335))
  call Hloop_A_Q(ntryL,G0H4(73),19,nMT,G1H4(35),n2h4(263))
  call Hloop_SA_Q(ntryL,G0H8(18),ex2(:),G0H4(25),ngX,m3h2x4(:,168),heltab2x8(:,:,336))
  call Hloop_A_Q(ntryL,G0H4(25),19,nMT,G1H4(3),n2h4(264))
  call Hloop_SA_Q(ntryL,G0H8(19),ex2(:),G0H4(7),ngPtb,m3h2x4(:,169),heltab2x8(:,:,337))
  call Hloop_A_Q(ntryL,G0H4(7),19,nMB,G1H4(106),n2h4(265))
  call Hloop_VA_Q(ntryL,G0H8(1),ex2(:),G0H4(26),m3h2x4(:,170),heltab2x8(:,:,338))
  call Hloop_A_Q(ntryL,G0H4(26),19,nMT,G1H4(87),n2h4(266))
  call Hloop_ZA_Q(ntryL,G0H8(2),ex2(:),G0H4(8),ngZu,m3h2x4(:,171),heltab2x8(:,:,339))
  call Hloop_A_Q(ntryL,G0H4(8),19,nMT,G1H4(69),n2h4(267))
  call Hloop_WA_Q(ntryL,G0H8(3),ex2(:),G0H4(27),m3h2x4(:,172),heltab2x8(:,:,340))
  call Hloop_A_Q(ntryL,G0H4(27),19,nMB,G1H4(61),n2h4(268))
  call Hloop_SQ_A(ntryL,G0H8(4),ex1(:),G0H4(9),ngH,m3h2x4(:,173),heltab2x8(:,:,341))
  call Hloop_Q_A(ntryL,G0H4(9),19,nMT,G1H4(54),n2h4(269))
  call Hloop_SQ_A(ntryL,G0H8(5),ex1(:),G0H4(28),ngX,m3h2x4(:,174),heltab2x8(:,:,342))
  call Hloop_Q_A(ntryL,G0H4(28),19,nMT,G1H4(47),n2h4(270))
  call Hloop_SQ_A(ntryL,G0H8(6),ex1(:),G0H4(10),ngPbt,m3h2x4(:,175),heltab2x8(:,:,343))
  call Hloop_Q_A(ntryL,G0H4(10),19,nMB,G1H4(38),n2h4(271))
  call Hloop_VQ_A(ntryL,G0H8(13),ex1(:),G0H4(29),m3h2x4(:,176),heltab2x8(:,:,344))
  call Hloop_Q_A(ntryL,G0H4(29),19,nMT,G1H4(16),n2h4(272))
  call Hloop_ZQ_A(ntryL,G0H8(14),ex1(:),G0H4(11),ngZu,m3h2x4(:,177),heltab2x8(:,:,345))
  call Hloop_Q_A(ntryL,G0H4(11),19,nMT,G1H4(130),n2h4(273))
  call Hloop_WQ_A(ntryL,G0H8(15),ex1(:),G0H4(30),m3h2x4(:,178),heltab2x8(:,:,346))
  call Hloop_Q_A(ntryL,G0H4(30),19,nMB,G1H4(8),n2h4(274))
  call Hloop_QA_S(ntryL,G1H16(157),ex2(:),G1H8(27),ngH,m3h2x8(:,175),heltab2x16(:,:,309))
  call Hloop_QA_S(ntryL,G1H16(158),ex2(:),G1H8(28),ngX,m3h2x8(:,176),heltab2x16(:,:,310))
  call Hloop_QA_S(ntryL,G1H16(159),ex2(:),G1H8(29),ngPtb,m3h2x8(:,177),heltab2x16(:,:,311))
  call Hloop_QA_V(ntryL,G1H16(160),ex2(:),G1H8(30),m3h2x8(:,178),heltab2x16(:,:,312))
  call Hloop_QA_Z(ntryL,G1H16(161),ex2(:),G1H8(31),ngZu,m3h2x8(:,179),heltab2x16(:,:,313))
  call Hloop_QA_W(ntryL,G1H16(162),ex2(:),G1H8(32),m3h2x8(:,180),heltab2x16(:,:,314))
  call Hloop_AQ_S(ntryL,G1H16(163),ex1(:),G1H8(37),ngH,m3h2x8(:,181),heltab2x16(:,:,315))
  call Hloop_AQ_S(ntryL,G1H16(164),ex1(:),G1H8(34),ngX,m3h2x8(:,182),heltab2x16(:,:,316))
  call Hloop_AQ_S(ntryL,G1H16(165),ex1(:),G1H8(39),ngPbt,m3h2x8(:,183),heltab2x16(:,:,317))
  call Hloop_AQ_V(ntryL,G1H16(166),ex1(:),G1H8(36),m3h2x8(:,184),heltab2x16(:,:,318))
  call Hloop_AQ_Z(ntryL,G1H16(167),ex1(:),G1H8(38),ngZu,m3h2x8(:,185),heltab2x16(:,:,319))
  call Hloop_AQ_W(ntryL,G1H16(168),ex1(:),G1H8(40),m3h2x8(:,186),heltab2x16(:,:,320))
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(83),[G2H2(57),G2H2(29),G2H2(63),G1H2(139),G1H2(67) &
    ,G1H2(29)])
call HGT_OLR(G2H2(134),1,1,2)
call HGT_invQ_OLR(G2H2(134),2,5,2)
call HGT_OLR(G2H2(134),6,15,2)
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(134),[G2H2(83)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(213),[G2H2(205),G2H2(32),G2H2(192),G2H2(198),G2H2(17) &
    ,G2H2(99),G2H2(91),G2H2(227),G2H2(209),G2H2(194),G2H2(182),G2H2(135),G1H2(353),G1H2(347),G1H2(344),G1H2(327),G1H2(5),G1H2(161) &
    ,G1H2(84),G1H2(46)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(87),[G2H2(37),G2H2(108),G2H2(25),G1H2(101)])
call HGT_OLR(G2H2(138),1,1,2)
call HGT_invQ_OLR(G2H2(138),2,5,2)
call HGT_OLR(G2H2(138),6,15,2)
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(138),[G2H2(87)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(10),[G2H2(207),G2H2(219),G2H2(195),G2H2(222),G2H2(107) &
    ,G2H2(1),G2H2(95),G2H2(239),G2H2(218),G2H2(200),G2H2(188),G2H2(139),G1H2(350),G1H2(338),G1H2(159),G1H2(122)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(59),[G2H2(35),G2H2(84),G2H2(121),G1H2(146),G1H2(58) &
    ,G1H2(26),G1H2(16)])
call HGT_OLR(G2H2(142),1,1,2)
call HGT_invQ_OLR(G2H2(142),2,5,2)
call HGT_OLR(G2H2(142),6,15,2)
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(142),[G2H2(59)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(143),[G1H2(361),G1H2(179),G1H2(92),G1H2(59)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(217),[G2H2(208),G2H2(123),G2H2(122),G1H2(114) &
    ,G1H2(113)])
call HGT_OLR(G2H2(146),1,1,2)
call HGT_invQ_OLR(G2H2(146),2,5,2)
call HGT_OLR(G2H2(146),6,15,2)
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(146),[G2H2(217)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(147),[G1H2(372),G1H2(147)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(131),[G2H2(75),G2H2(41),G2H2(51),G1H2(215),G1H2(224) &
    ,G1H2(197)])
call HGT_OLR(G2H2(150),1,1,2)
call HGT_invQ_OLR(G2H2(150),2,5,2)
call HGT_OLR(G2H2(150),6,15,2)
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(150),[G2H2(131)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(211),[G2H2(189),G2H2(183),G2H2(204),G2H2(111),G2H2(103) &
    ,G2H2(5),G2H2(97),G2H2(233),G2H2(215),G2H2(197),G2H2(185),G2H2(151),G1H2(383),G1H2(319),G1H2(313),G1H2(310),G1H2(265) &
    ,G1H2(245),G1H2(208),G1H2(232)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(132),[G2H2(79),G2H2(71),G2H2(67),G1H2(259)])
call HGT_OLR(G2H2(154),1,1,2)
call HGT_invQ_OLR(G2H2(154),2,5,2)
call HGT_OLR(G2H2(154),6,15,2)
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(154),[G2H2(132)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(232),[G2H2(225),G2H2(36),G2H2(210),G2H2(12),G2H2(117) &
    ,G2H2(9),G2H2(130),G2H2(245),G2H2(221),G2H2(203),G2H2(191),G2H2(155),G1H2(394),G1H2(316),G1H2(85),G1H2(94)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(47),[G2H2(39),G2H2(31),G2H2(27),G1H2(300),G1H2(280) &
    ,G1H2(270),G1H2(227)])
call HGT_OLR(G2H2(158),1,1,2)
call HGT_invQ_OLR(G2H2(158),2,5,2)
call HGT_OLR(G2H2(158),6,15,2)
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(158),[G2H2(47)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(159),[G1H2(405),G1H2(305),G1H2(285),G1H2(275)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(187),[G2H2(193),G2H2(126),G2H2(125),G1H2(290),G1H2(72)])
call HGT_OLR(G2H2(162),1,1,2)
call HGT_invQ_OLR(G2H2(162),2,5,2)
call HGT_OLR(G2H2(162),6,15,2)
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(162),[G2H2(187)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(163),[G1H2(416),G1H2(295)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(43),[G2H2(181),G2H2(85),G1H2(140)])
call HGT_OLR(G2H2(166),1,1,2)
call HGT_invQ_OLR(G2H2(166),2,5,2)
call HGT_OLR(G2H2(166),6,15,2)
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(166),[G2H2(43)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(167),[G1H2(162)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(199),[G2H2(55),G2H2(124),G1H2(429)])
call HGT_OLR(G2H2(170),1,1,2)
call HGT_invQ_OLR(G2H2(170),2,5,2)
call HGT_OLR(G2H2(170),6,15,2)
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(170),[G2H2(199)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(171),[G1H2(217)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(129),[G2H2(128),G2H2(109)])
call HGT_OLR(G2H2(174),1,1,2)
call HGT_invQ_OLR(G2H2(174),2,5,2)
call HGT_OLR(G2H2(174),6,15,2)
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(174),[G2H2(129)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(2),[G2H2(229),G2H2(201),G2H2(186),G2H2(49),G2H2(116) &
    ,G2H2(242),G2H2(230),G2H2(212),G2H2(175),G1H2(430),G1H2(422)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(96),[G2H2(127),G2H2(33)])



end subroutine vamp_3

end module ol_vamp_3_ppttj_ew_ttxggg_1_/**/REALKIND
