
module ol_vamp_1_ppttj_ew_ttxbbxg_4_/**/REALKIND
contains

! **********************************************************************
subroutine vamp_1(M)
! P(0:3,nlegs) = incoming external momenta
! Uses tree structures 'wf', factors 'c', and denominators 'den' from loop_ppttj_ew_ttxbbxg_4.
! Sets colour stripped amplitudes A from the module loop_amplitudes_ppttj_ew_ttxbbxg_4.
! **********************************************************************
  use KIND_TYPES, only: REALKIND, QREALKIND, intkind2
  use ol_parameters_decl_/**/DREALKIND, only: l_switch
  use ol_parameters_decl_/**/QREALKIND ! masses
  use ol_vert_interface_/**/REALKIND
  use ol_prop_interface_/**/REALKIND
  use ol_last_step_/**/REALKIND
  use ol_tables_storage_ppttj_ew_ttxbbxg_4_/**/DREALKIND
  use ol_tensor_sum_storage_ppttj_ew_ttxbbxg_4_/**/REALKIND
  use ol_loop_handling_/**/REALKIND
  use ofred_reduction_/**/REALKIND, only: Hotf_4pt_reduction, Hotf_4pt_reduction_last
  use ofred_reduction_/**/REALKIND, only: Hotf_5pt_reduction, Hotf_5pt_reduction_last
  use ol_loop_reduction_/**/REALKIND, only: TI_bubble_red, TI_triangle_red
use ol_loop_reduction_/**/REALKIND, only: compute_scalar_box

  use ol_loop_storage_ppttj_ew_ttxbbxg_4_/**/REALKIND
#ifndef PRECISION_dp
  use ol_loop_storage_ppttj_ew_ttxbbxg_4_/**/DREALKIND, only: &
    & p_switch, Hel, merge_step, merge_mism, merge_tables, merge_hels, ntryL, hel_states
#endif
  use hol_initialisation_/**/REALKIND, only: G0_hol_initialisation
  use ol_h_vert_interface_/**/REALKIND
  use ol_h_prop_interface_/**/REALKIND
  use ol_h_last_step_/**/REALKIND
  use ol_merging_/**/REALKIND, only: ol_merge, ol_merge_tensors, ol_merge_last

  implicit none

  type(Hpolcont) :: Gcoeff(hel_states)
  type(Hpolcont), intent(in) :: M(4,hel_states)


#ifndef PRECISION_dp
  if (ntryL==1 .OR. p_switch == 1) Gcoeff(:)%hf = Hel(1:hel_states)
#else
  if (ntryL==1 .OR. p_switch == 2) Gcoeff(:)%hf = Hel(1:hel_states)
#endif

  ! =============================================


! Dressing, otf merging and otf reduction calls to build loop structures

  Gcoeff(:)%j = (c(33)*M(4,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1),h0tab(:,1),[16,4,1,2,8],[nMB,nMH,nMT,nMH,nMB],5,0)
  call Hloop_AV_Q(ntryL,G0H32(1),ex5(:),G0H16(1),m3h2x16(:,1),heltab2x32(:,:,1))
  call Hloop_A_Q(ntryL,G0H16(1),16,nMB,G1H16(1),n2h16(1))
  Gcoeff(:)%j = (c(33)*M(4,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(2),h0tab(:,2),[16,4,1,2,8],[nMB,nMH,nMT,nMZ,nMB],5,0)
  call Hloop_AV_Q(ntryL,G0H32(1),ex5(:),G0H16(1),m3h2x16(:,2),heltab2x32(:,:,2))
  call Hloop_A_Q(ntryL,G0H16(1),16,nMB,G1H16(2),n2h16(2))
  Gcoeff(:)%j = (c(33)*M(4,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(3),h0tab(:,3),[16,4,1,2,8],[nMB,nMZ,nMT,nMH,nMB],5,0)
  call Hloop_AV_Q(ntryL,G0H32(1),ex5(:),G0H16(1),m3h2x16(:,3),heltab2x32(:,:,3))
  call Hloop_A_Q(ntryL,G0H16(1),16,nMB,G1H16(3),n2h16(3))
  Gcoeff(:)%j = (c(33)*M(4,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(4),h0tab(:,4),[16,4,1,2,8],[nMB,nMZ,nMT,nMZ,nMB],5,0)
  call Hloop_AV_Q(ntryL,G0H32(1),ex5(:),G0H16(1),m3h2x16(:,4),heltab2x32(:,:,4))
  call Hloop_A_Q(ntryL,G0H16(1),16,nMB,G1H16(4),n2h16(4))
  Gcoeff(:)%j = (c(20)*M(4,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(5),h0tab(:,5),[16,4,1,2,8],[nMT,nMW,nMB,nMW,nMT],5,0)
  call Hloop_AV_Q(ntryL,G0H32(1),ex5(:),G0H16(1),m3h2x16(:,5),heltab2x32(:,:,5))
  call Hloop_A_Q(ntryL,G0H16(1),16,nMT,G1H16(5),n2h16(5))
  Gcoeff(:)%j = (c(84)*M(4,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(6),h0tab(:,6),[16,4,1,2,8],[nMB,nMH,nMT,0,nMB],5,0)
  call Hloop_AV_Q(ntryL,G0H32(1),ex5(:),G0H16(1),m3h2x16(:,6),heltab2x32(:,:,6))
  call Hloop_A_Q(ntryL,G0H16(1),16,nMB,G1H16(6),n2h16(6))
  Gcoeff(:)%j = (c(84)*M(4,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(7),h0tab(:,7),[16,4,1,2,8],[nMB,nMZ,nMT,0,nMB],5,0)
  call Hloop_AV_Q(ntryL,G0H32(1),ex5(:),G0H16(1),m3h2x16(:,7),heltab2x32(:,:,7))
  call Hloop_A_Q(ntryL,G0H16(1),16,nMB,G1H16(7),n2h16(7))
  Gcoeff(:)%j = (-(c(86)*M(4,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(8),h0tab(:,8),[16,4,1,2,8],[nMB,nMH,nMT,nMZ,nMB],5,0)
  call Hloop_AV_Q(ntryL,G0H32(1),ex5(:),G0H16(1),m3h2x16(:,8),heltab2x32(:,:,8))
  call Hloop_A_Q(ntryL,G0H16(1),16,nMB,G1H16(8),n2h16(8))
  Gcoeff(:)%j = (-(c(86)*M(4,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(9),h0tab(:,9),[16,4,1,2,8],[nMB,nMZ,nMT,nMZ,nMB],5,0)
  call Hloop_AV_Q(ntryL,G0H32(1),ex5(:),G0H16(1),m3h2x16(:,9),heltab2x32(:,:,9))
  call Hloop_A_Q(ntryL,G0H16(1),16,nMB,G1H16(9),n2h16(9))
  Gcoeff(:)%j = (c(38)*M(4,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(10),h0tab(:,10),[16,4,1,2,8],[nMT,nMW,nMB,nMW,nMT],5,0)
  call Hloop_AV_Q(ntryL,G0H32(1),ex5(:),G0H16(1),m3h2x16(:,10),heltab2x32(:,:,10))
  call Hloop_A_Q(ntryL,G0H16(1),16,nMT,G1H16(10),n2h16(10))
  Gcoeff(:)%j = (c(84)*M(4,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(11),h0tab(:,11),[16,4,1,2,8],[nMB,0,nMT,nMH,nMB],5,0)
  call Hloop_AV_Q(ntryL,G0H32(1),ex5(:),G0H16(1),m3h2x16(:,11),heltab2x32(:,:,11))
  call Hloop_A_Q(ntryL,G0H16(1),16,nMB,G1H16(11),n2h16(11))
  Gcoeff(:)%j = (c(84)*M(4,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(12),h0tab(:,12),[16,4,1,2,8],[nMB,0,nMT,nMZ,nMB],5,0)
  call Hloop_AV_Q(ntryL,G0H32(1),ex5(:),G0H16(1),m3h2x16(:,12),heltab2x32(:,:,12))
  call Hloop_A_Q(ntryL,G0H16(1),16,nMB,G1H16(12),n2h16(12))
  Gcoeff(:)%j = (-(c(86)*M(4,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(13),h0tab(:,13),[16,4,1,2,8],[nMB,nMZ,nMT,nMH,nMB],5,0)
  call Hloop_AV_Q(ntryL,G0H32(1),ex5(:),G0H16(1),m3h2x16(:,13),heltab2x32(:,:,13))
  call Hloop_A_Q(ntryL,G0H16(1),16,nMB,G1H16(13),n2h16(13))
  Gcoeff(:)%j = (-(c(86)*M(4,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(14),h0tab(:,14),[16,4,1,2,8],[nMB,nMZ,nMT,nMZ,nMB],5,0)
  call Hloop_AV_Q(ntryL,G0H32(1),ex5(:),G0H16(1),m3h2x16(:,14),heltab2x32(:,:,14))
  call Hloop_A_Q(ntryL,G0H16(1),16,nMB,G1H16(14),n2h16(14))
  Gcoeff(:)%j = (c(38)*M(4,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(15),h0tab(:,15),[16,4,1,2,8],[nMT,nMW,nMB,nMW,nMT],5,0)
  call Hloop_AV_Q(ntryL,G0H32(1),ex5(:),G0H16(1),m3h2x16(:,15),heltab2x32(:,:,15))
  call Hloop_A_Q(ntryL,G0H16(1),16,nMT,G1H16(15),n2h16(15))
  Gcoeff(:)%j = (c(2)*M(4,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(16),h0tab(:,16),[16,4,1,2,8],[nMB,0,nMT,0,nMB],5,0)
  call Hloop_AV_Q(ntryL,G0H32(1),ex5(:),G0H16(1),m3h2x16(:,16),heltab2x32(:,:,16))
  call Hloop_A_Q(ntryL,G0H16(1),16,nMB,G1H16(16),n2h16(16))
  Gcoeff(:)%j = (-(c(5)*M(4,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(17),h0tab(:,17),[16,4,1,2,8],[nMB,0,nMT,nMZ,nMB],5,0)
  call Hloop_AV_Q(ntryL,G0H32(1),ex5(:),G0H16(1),m3h2x16(:,17),heltab2x32(:,:,17))
  call Hloop_A_Q(ntryL,G0H16(1),16,nMB,G1H16(17),n2h16(17))
  Gcoeff(:)%j = (-(c(5)*M(4,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(18),h0tab(:,18),[16,4,1,2,8],[nMB,nMZ,nMT,0,nMB],5,0)
  call Hloop_AV_Q(ntryL,G0H32(1),ex5(:),G0H16(1),m3h2x16(:,18),heltab2x32(:,:,18))
  call Hloop_A_Q(ntryL,G0H16(1),16,nMB,G1H16(18),n2h16(18))
  Gcoeff(:)%j = (c(7)*M(4,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(19),h0tab(:,19),[16,4,1,2,8],[nMB,nMZ,nMT,nMZ,nMB],5,0)
  call Hloop_AV_Q(ntryL,G0H32(1),ex5(:),G0H16(1),m3h2x16(:,19),heltab2x32(:,:,19))
  call Hloop_A_Q(ntryL,G0H16(1),16,nMB,G1H16(19),n2h16(19))
  Gcoeff(:)%j = (c(12)*M(4,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(20),h0tab(:,20),[16,4,1,2,8],[nMT,nMW,nMB,nMW,nMT],5,0)
  call Hloop_AV_Q(ntryL,G0H32(1),ex5(:),G0H16(1),m3h2x16(:,20),heltab2x32(:,:,20))
  call Hloop_A_Q(ntryL,G0H16(1),16,nMT,G1H16(20),n2h16(20))
  Gcoeff(:)%j = (c(33)*M(4,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(21),h0tab(:,21),[16,4,2,1,8],[nMB,nMH,nMT,nMH,nMB],5,0)
  call Hloop_AV_Q(ntryL,G0H32(1),ex5(:),G0H16(1),m3h2x16(:,21),heltab2x32(:,:,21))
  call Hloop_A_Q(ntryL,G0H16(1),16,nMB,G1H16(21),n2h16(21))
  Gcoeff(:)%j = (c(33)*M(4,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(22),h0tab(:,22),[16,4,2,1,8],[nMB,nMZ,nMT,nMH,nMB],5,0)
  call Hloop_AV_Q(ntryL,G0H32(1),ex5(:),G0H16(1),m3h2x16(:,22),heltab2x32(:,:,22))
  call Hloop_A_Q(ntryL,G0H16(1),16,nMB,G1H16(22),n2h16(22))
  Gcoeff(:)%j = (c(33)*M(4,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(23),h0tab(:,23),[16,4,2,1,8],[nMB,nMH,nMT,nMZ,nMB],5,0)
  call Hloop_AV_Q(ntryL,G0H32(1),ex5(:),G0H16(1),m3h2x16(:,23),heltab2x32(:,:,23))
  call Hloop_A_Q(ntryL,G0H16(1),16,nMB,G1H16(23),n2h16(23))
  Gcoeff(:)%j = (c(33)*M(4,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(24),h0tab(:,24),[16,4,2,1,8],[nMB,nMZ,nMT,nMZ,nMB],5,0)
  call Hloop_AV_Q(ntryL,G0H32(1),ex5(:),G0H16(1),m3h2x16(:,24),heltab2x32(:,:,24))
  call Hloop_A_Q(ntryL,G0H16(1),16,nMB,G1H16(24),n2h16(24))
  Gcoeff(:)%j = (c(84)*M(4,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(25),h0tab(:,25),[16,4,2,1,8],[nMB,0,nMT,nMH,nMB],5,0)
  call Hloop_AV_Q(ntryL,G0H32(1),ex5(:),G0H16(1),m3h2x16(:,25),heltab2x32(:,:,25))
  call Hloop_A_Q(ntryL,G0H16(1),16,nMB,G1H16(25),n2h16(25))
  Gcoeff(:)%j = (c(84)*M(4,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(26),h0tab(:,26),[16,4,2,1,8],[nMB,0,nMT,nMZ,nMB],5,0)
  call Hloop_AV_Q(ntryL,G0H32(1),ex5(:),G0H16(1),m3h2x16(:,26),heltab2x32(:,:,26))
  call Hloop_A_Q(ntryL,G0H16(1),16,nMB,G1H16(26),n2h16(26))
  Gcoeff(:)%j = (-(c(86)*M(4,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(27),h0tab(:,27),[16,4,2,1,8],[nMB,nMZ,nMT,nMH,nMB],5,0)
  call Hloop_AV_Q(ntryL,G0H32(1),ex5(:),G0H16(1),m3h2x16(:,27),heltab2x32(:,:,27))
  call Hloop_A_Q(ntryL,G0H16(1),16,nMB,G1H16(27),n2h16(27))
  Gcoeff(:)%j = (-(c(86)*M(4,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(28),h0tab(:,28),[16,4,2,1,8],[nMB,nMZ,nMT,nMZ,nMB],5,0)
  call Hloop_AV_Q(ntryL,G0H32(1),ex5(:),G0H16(1),m3h2x16(:,28),heltab2x32(:,:,28))
  call Hloop_A_Q(ntryL,G0H16(1),16,nMB,G1H16(28),n2h16(28))
  Gcoeff(:)%j = (c(84)*M(4,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(29),h0tab(:,29),[16,4,2,1,8],[nMB,nMH,nMT,0,nMB],5,0)
  call Hloop_AV_Q(ntryL,G0H32(1),ex5(:),G0H16(1),m3h2x16(:,29),heltab2x32(:,:,29))
  call Hloop_A_Q(ntryL,G0H16(1),16,nMB,G1H16(29),n2h16(29))
  Gcoeff(:)%j = (c(84)*M(4,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(30),h0tab(:,30),[16,4,2,1,8],[nMB,nMZ,nMT,0,nMB],5,0)
  call Hloop_AV_Q(ntryL,G0H32(1),ex5(:),G0H16(1),m3h2x16(:,30),heltab2x32(:,:,30))
  call Hloop_A_Q(ntryL,G0H16(1),16,nMB,G1H16(30),n2h16(30))
  Gcoeff(:)%j = (-(c(86)*M(4,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(31),h0tab(:,31),[16,4,2,1,8],[nMB,nMH,nMT,nMZ,nMB],5,0)
  call Hloop_AV_Q(ntryL,G0H32(1),ex5(:),G0H16(1),m3h2x16(:,31),heltab2x32(:,:,31))
  call Hloop_A_Q(ntryL,G0H16(1),16,nMB,G1H16(31),n2h16(31))
  Gcoeff(:)%j = (-(c(86)*M(4,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(32),h0tab(:,32),[16,4,2,1,8],[nMB,nMZ,nMT,nMZ,nMB],5,0)
  call Hloop_AV_Q(ntryL,G0H32(1),ex5(:),G0H16(1),m3h2x16(:,32),heltab2x32(:,:,32))
  call Hloop_A_Q(ntryL,G0H16(1),16,nMB,G1H16(32),n2h16(32))
  Gcoeff(:)%j = (c(2)*M(4,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(33),h0tab(:,33),[16,4,2,1,8],[nMB,0,nMT,0,nMB],5,0)
  call Hloop_AV_Q(ntryL,G0H32(1),ex5(:),G0H16(1),m3h2x16(:,33),heltab2x32(:,:,33))
  call Hloop_A_Q(ntryL,G0H16(1),16,nMB,G1H16(33),n2h16(33))
  Gcoeff(:)%j = (-(c(5)*M(4,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(34),h0tab(:,34),[16,4,2,1,8],[nMB,nMZ,nMT,0,nMB],5,0)
  call Hloop_AV_Q(ntryL,G0H32(1),ex5(:),G0H16(1),m3h2x16(:,34),heltab2x32(:,:,34))
  call Hloop_A_Q(ntryL,G0H16(1),16,nMB,G1H16(34),n2h16(34))
  Gcoeff(:)%j = (-(c(5)*M(4,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(35),h0tab(:,35),[16,4,2,1,8],[nMB,0,nMT,nMZ,nMB],5,0)
  call Hloop_AV_Q(ntryL,G0H32(1),ex5(:),G0H16(1),m3h2x16(:,35),heltab2x32(:,:,35))
  call Hloop_A_Q(ntryL,G0H16(1),16,nMB,G1H16(35),n2h16(35))
  Gcoeff(:)%j = (c(7)*M(4,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(36),h0tab(:,36),[16,4,2,1,8],[nMB,nMZ,nMT,nMZ,nMB],5,0)
  call Hloop_AV_Q(ntryL,G0H32(1),ex5(:),G0H16(1),m3h2x16(:,36),heltab2x32(:,:,36))
  call Hloop_A_Q(ntryL,G0H16(1),16,nMB,G1H16(36),n2h16(36))
  Gcoeff(:)%j = (c(32)*M(2,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(37),h0tab(:,37),[16,2,1,8,4],[nMT,nMH,nMT,nMW,nMT],5,0)
  call Hloop_QV_A(ntryL,G0H32(1),ex5(:),G0H16(1),m3h2x16(:,37),heltab2x32(:,:,37))
  call Hloop_Q_A(ntryL,G0H16(1),16,nMT,G1H16(37),n2h16(37))
  Gcoeff(:)%j = (c(21)*M(2,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(38),h0tab(:,38),[16,2,1,8,4],[nMB,nMW,nMB,nMH,nMB],5,0)
  call Hloop_QV_A(ntryL,G0H32(1),ex5(:),G0H16(1),m3h2x16(:,38),heltab2x32(:,:,38))
  call Hloop_Q_A(ntryL,G0H16(1),16,nMB,G1H16(38),n2h16(38))
  Gcoeff(:)%j = (-(c(32)*M(2,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(39),h0tab(:,39),[16,2,1,8,4],[nMT,nMZ,nMT,nMW,nMT],5,0)
  call Hloop_QV_A(ntryL,G0H32(1),ex5(:),G0H16(1),m3h2x16(:,39),heltab2x32(:,:,39))
  call Hloop_Q_A(ntryL,G0H16(1),16,nMT,G1H16(39),n2h16(39))
  Gcoeff(:)%j = (-(c(21)*M(2,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(40),h0tab(:,40),[16,2,1,8,4],[nMB,nMW,nMB,nMZ,nMB],5,0)
  call Hloop_QV_A(ntryL,G0H32(1),ex5(:),G0H16(1),m3h2x16(:,40),heltab2x32(:,:,40))
  call Hloop_Q_A(ntryL,G0H16(1),16,nMB,G1H16(40),n2h16(40))
  Gcoeff(:)%j = (-(c(74)*M(2,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(41),h0tab(:,41),[16,2,1,8,4],[nMB,nMW,nMB,0,nMB],5,0)
  call Hloop_QV_A(ntryL,G0H32(1),ex5(:),G0H16(1),m3h2x16(:,41),heltab2x32(:,:,41))
  call Hloop_Q_A(ntryL,G0H16(1),16,nMB,G1H16(41),n2h16(41))
  Gcoeff(:)%j = (-(c(79)*M(2,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(42),h0tab(:,42),[16,2,1,8,4],[nMB,nMW,nMB,nMZ,nMB],5,0)
  call Hloop_QV_A(ntryL,G0H32(1),ex5(:),G0H16(1),m3h2x16(:,42),heltab2x32(:,:,42))
  call Hloop_Q_A(ntryL,G0H16(1),16,nMB,G1H16(42),n2h16(42))
  Gcoeff(:)%j = (c(46)*M(2,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(43),h0tab(:,43),[16,2,1,8,4],[nMT,nMH,nMT,nMW,nMT],5,0)
  call Hloop_QV_A(ntryL,G0H32(1),ex5(:),G0H16(1),m3h2x16(:,43),heltab2x32(:,:,43))
  call Hloop_Q_A(ntryL,G0H16(1),16,nMT,G1H16(43),n2h16(43))
  Gcoeff(:)%j = (-(c(46)*M(2,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(44),h0tab(:,44),[16,2,1,8,4],[nMT,nMZ,nMT,nMW,nMT],5,0)
  call Hloop_QV_A(ntryL,G0H32(1),ex5(:),G0H16(1),m3h2x16(:,44),heltab2x32(:,:,44))
  call Hloop_Q_A(ntryL,G0H16(1),16,nMT,G1H16(44),n2h16(44))
  Gcoeff(:)%j = (-(c(77)*M(2,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(45),h0tab(:,45),[16,2,1,8,4],[nMT,0,nMT,nMW,nMT],5,0)
  call Hloop_QV_A(ntryL,G0H32(1),ex5(:),G0H16(1),m3h2x16(:,45),heltab2x32(:,:,45))
  call Hloop_Q_A(ntryL,G0H16(1),16,nMT,G1H16(45),n2h16(45))
  Gcoeff(:)%j = (-(c(79)*M(2,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(46),h0tab(:,46),[16,2,1,8,4],[nMT,nMZ,nMT,nMW,nMT],5,0)
  call Hloop_QV_A(ntryL,G0H32(1),ex5(:),G0H16(1),m3h2x16(:,46),heltab2x32(:,:,46))
  call Hloop_Q_A(ntryL,G0H16(1),16,nMT,G1H16(46),n2h16(46))
  Gcoeff(:)%j = (c(40)*M(2,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(47),h0tab(:,47),[16,2,1,8,4],[nMB,nMW,nMB,nMH,nMB],5,0)
  call Hloop_QV_A(ntryL,G0H32(1),ex5(:),G0H16(1),m3h2x16(:,47),heltab2x32(:,:,47))
  call Hloop_Q_A(ntryL,G0H16(1),16,nMB,G1H16(47),n2h16(47))
  Gcoeff(:)%j = (-(c(40)*M(2,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(48),h0tab(:,48),[16,2,1,8,4],[nMB,nMW,nMB,nMZ,nMB],5,0)
  call Hloop_QV_A(ntryL,G0H32(1),ex5(:),G0H16(1),m3h2x16(:,48),heltab2x32(:,:,48))
  call Hloop_Q_A(ntryL,G0H16(1),16,nMB,G1H16(48),n2h16(48))
  Gcoeff(:)%j = (-(c(63)*M(2,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(49),h0tab(:,49),[16,2,1,8,4],[nMT,0,nMT,nMW,nMT],5,0)
  call Hloop_QV_A(ntryL,G0H32(1),ex5(:),G0H16(1),m3h2x16(:,49),heltab2x32(:,:,49))
  call Hloop_Q_A(ntryL,G0H16(1),16,nMT,G1H16(49),n2h16(49))
  Gcoeff(:)%j = (-(c(60)*M(2,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(50),h0tab(:,50),[16,2,1,8,4],[nMB,nMW,nMB,0,nMB],5,0)
  call Hloop_QV_A(ntryL,G0H32(1),ex5(:),G0H16(1),m3h2x16(:,50),heltab2x32(:,:,50))
  call Hloop_Q_A(ntryL,G0H16(1),16,nMB,G1H16(50),n2h16(50))
  Gcoeff(:)%j = (-(c(65)*M(2,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(51),h0tab(:,51),[16,2,1,8,4],[nMT,nMZ,nMT,nMW,nMT],5,0)
  call Hloop_QV_A(ntryL,G0H32(1),ex5(:),G0H16(1),m3h2x16(:,51),heltab2x32(:,:,51))
  call Hloop_Q_A(ntryL,G0H16(1),16,nMT,G1H16(51),n2h16(51))
  Gcoeff(:)%j = (-(c(65)*M(2,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(52),h0tab(:,52),[16,2,1,8,4],[nMB,nMW,nMB,nMZ,nMB],5,0)
  call Hloop_QV_A(ntryL,G0H32(1),ex5(:),G0H16(1),m3h2x16(:,52),heltab2x32(:,:,52))
  call Hloop_Q_A(ntryL,G0H16(1),16,nMB,G1H16(52),n2h16(52))
  Gcoeff(:)%j = (c(32)*M(3,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(53),h0tab(:,53),[16,1,2,4,8],[nMT,nMH,nMT,nMW,nMT],5,0)
  call Hloop_AV_Q(ntryL,G0H32(1),ex5(:),G0H16(1),m3h2x16(:,53),heltab2x32(:,:,53))
  call Hloop_A_Q(ntryL,G0H16(1),16,nMT,G1H16(53),n2h16(53))
  Gcoeff(:)%j = (c(21)*M(3,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(54),h0tab(:,54),[16,1,2,4,8],[nMB,nMW,nMB,nMH,nMB],5,0)
  call Hloop_AV_Q(ntryL,G0H32(1),ex5(:),G0H16(1),m3h2x16(:,54),heltab2x32(:,:,54))
  call Hloop_A_Q(ntryL,G0H16(1),16,nMB,G1H16(54),n2h16(54))
  Gcoeff(:)%j = (-(c(32)*M(3,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(55),h0tab(:,55),[16,1,2,4,8],[nMT,nMZ,nMT,nMW,nMT],5,0)
  call Hloop_AV_Q(ntryL,G0H32(1),ex5(:),G0H16(1),m3h2x16(:,55),heltab2x32(:,:,55))
  call Hloop_A_Q(ntryL,G0H16(1),16,nMT,G1H16(55),n2h16(55))
  Gcoeff(:)%j = (-(c(21)*M(3,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(56),h0tab(:,56),[16,1,2,4,8],[nMB,nMW,nMB,nMZ,nMB],5,0)
  call Hloop_AV_Q(ntryL,G0H32(1),ex5(:),G0H16(1),m3h2x16(:,56),heltab2x32(:,:,56))
  call Hloop_A_Q(ntryL,G0H16(1),16,nMB,G1H16(56),n2h16(56))
  Gcoeff(:)%j = (-(c(74)*M(3,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(57),h0tab(:,57),[16,1,2,4,8],[nMB,nMW,nMB,0,nMB],5,0)
  call Hloop_AV_Q(ntryL,G0H32(1),ex5(:),G0H16(1),m3h2x16(:,57),heltab2x32(:,:,57))
  call Hloop_A_Q(ntryL,G0H16(1),16,nMB,G1H16(57),n2h16(57))
  Gcoeff(:)%j = (-(c(79)*M(3,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(58),h0tab(:,58),[16,1,2,4,8],[nMB,nMW,nMB,nMZ,nMB],5,0)
  call Hloop_AV_Q(ntryL,G0H32(1),ex5(:),G0H16(1),m3h2x16(:,58),heltab2x32(:,:,58))
  call Hloop_A_Q(ntryL,G0H16(1),16,nMB,G1H16(58),n2h16(58))
  Gcoeff(:)%j = (c(46)*M(3,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(59),h0tab(:,59),[16,1,2,4,8],[nMT,nMH,nMT,nMW,nMT],5,0)
  call Hloop_AV_Q(ntryL,G0H32(1),ex5(:),G0H16(1),m3h2x16(:,59),heltab2x32(:,:,59))
  call Hloop_A_Q(ntryL,G0H16(1),16,nMT,G1H16(59),n2h16(59))
  Gcoeff(:)%j = (-(c(46)*M(3,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(60),h0tab(:,60),[16,1,2,4,8],[nMT,nMZ,nMT,nMW,nMT],5,0)
  call Hloop_AV_Q(ntryL,G0H32(1),ex5(:),G0H16(1),m3h2x16(:,60),heltab2x32(:,:,60))
  call Hloop_A_Q(ntryL,G0H16(1),16,nMT,G1H16(60),n2h16(60))
  Gcoeff(:)%j = (-(c(77)*M(3,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(61),h0tab(:,61),[16,1,2,4,8],[nMT,0,nMT,nMW,nMT],5,0)
  call Hloop_AV_Q(ntryL,G0H32(1),ex5(:),G0H16(1),m3h2x16(:,61),heltab2x32(:,:,61))
  call Hloop_A_Q(ntryL,G0H16(1),16,nMT,G1H16(61),n2h16(61))
  Gcoeff(:)%j = (-(c(79)*M(3,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(62),h0tab(:,62),[16,1,2,4,8],[nMT,nMZ,nMT,nMW,nMT],5,0)
  call Hloop_AV_Q(ntryL,G0H32(1),ex5(:),G0H16(1),m3h2x16(:,62),heltab2x32(:,:,62))
  call Hloop_A_Q(ntryL,G0H16(1),16,nMT,G1H16(62),n2h16(62))
  Gcoeff(:)%j = (c(40)*M(3,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(63),h0tab(:,63),[16,1,2,4,8],[nMB,nMW,nMB,nMH,nMB],5,0)
  call Hloop_AV_Q(ntryL,G0H32(1),ex5(:),G0H16(1),m3h2x16(:,63),heltab2x32(:,:,63))
  call Hloop_A_Q(ntryL,G0H16(1),16,nMB,G1H16(63),n2h16(63))
  Gcoeff(:)%j = (-(c(40)*M(3,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(64),h0tab(:,64),[16,1,2,4,8],[nMB,nMW,nMB,nMZ,nMB],5,0)
  call Hloop_AV_Q(ntryL,G0H32(1),ex5(:),G0H16(1),m3h2x16(:,64),heltab2x32(:,:,64))
  call Hloop_A_Q(ntryL,G0H16(1),16,nMB,G1H16(64),n2h16(64))
  Gcoeff(:)%j = (-(c(63)*M(3,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(65),h0tab(:,65),[16,1,2,4,8],[nMT,0,nMT,nMW,nMT],5,0)
  call Hloop_AV_Q(ntryL,G0H32(1),ex5(:),G0H16(1),m3h2x16(:,65),heltab2x32(:,:,65))
  call Hloop_A_Q(ntryL,G0H16(1),16,nMT,G1H16(65),n2h16(65))
  Gcoeff(:)%j = (-(c(60)*M(3,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(66),h0tab(:,66),[16,1,2,4,8],[nMB,nMW,nMB,0,nMB],5,0)
  call Hloop_AV_Q(ntryL,G0H32(1),ex5(:),G0H16(1),m3h2x16(:,66),heltab2x32(:,:,66))
  call Hloop_A_Q(ntryL,G0H16(1),16,nMB,G1H16(66),n2h16(66))
  Gcoeff(:)%j = (-(c(65)*M(3,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(67),h0tab(:,67),[16,1,2,4,8],[nMT,nMZ,nMT,nMW,nMT],5,0)
  call Hloop_AV_Q(ntryL,G0H32(1),ex5(:),G0H16(1),m3h2x16(:,67),heltab2x32(:,:,67))
  call Hloop_A_Q(ntryL,G0H16(1),16,nMT,G1H16(67),n2h16(67))
  Gcoeff(:)%j = (-(c(65)*M(3,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(68),h0tab(:,68),[16,1,2,4,8],[nMB,nMW,nMB,nMZ,nMB],5,0)
  call Hloop_AV_Q(ntryL,G0H32(1),ex5(:),G0H16(1),m3h2x16(:,68),heltab2x32(:,:,68))
  call Hloop_A_Q(ntryL,G0H16(1),16,nMB,G1H16(68),n2h16(68))
  Gcoeff(:)%j = (c(24)*M(2,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(69),h0tab(:,69),[16,2,8,1,4],[nMT,nMH,nMB,nMW,nMT],5,0)
  call Hloop_QV_A(ntryL,G0H32(1),ex5(:),G0H16(1),m3h2x16(:,69),heltab2x32(:,:,69))
  call Hloop_Q_A(ntryL,G0H16(1),16,nMT,G1H16(69),n2h16(69))
  Gcoeff(:)%j = (c(24)*M(2,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(70),h0tab(:,70),[16,2,8,1,4],[nMB,nMW,nMT,nMH,nMB],5,0)
  call Hloop_QV_A(ntryL,G0H32(1),ex5(:),G0H16(1),m3h2x16(:,70),heltab2x32(:,:,70))
  call Hloop_Q_A(ntryL,G0H16(1),16,nMB,G1H16(70),n2h16(70))
  Gcoeff(:)%j = (c(24)*M(2,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(71),h0tab(:,71),[16,2,8,1,4],[nMT,nMZ,nMB,nMW,nMT],5,0)
  call Hloop_QV_A(ntryL,G0H32(1),ex5(:),G0H16(1),m3h2x16(:,71),heltab2x32(:,:,71))
  call Hloop_Q_A(ntryL,G0H16(1),16,nMT,G1H16(71),n2h16(71))
  Gcoeff(:)%j = (c(24)*M(2,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(72),h0tab(:,72),[16,2,8,1,4],[nMB,nMW,nMT,nMZ,nMB],5,0)
  call Hloop_QV_A(ntryL,G0H32(1),ex5(:),G0H16(1),m3h2x16(:,72),heltab2x32(:,:,72))
  call Hloop_Q_A(ntryL,G0H16(1),16,nMB,G1H16(72),n2h16(72))
  Gcoeff(:)%j = (c(75)*M(2,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(73),h0tab(:,73),[16,2,8,1,4],[nMT,0,nMB,nMW,nMT],5,0)
  call Hloop_QV_A(ntryL,G0H32(1),ex5(:),G0H16(1),m3h2x16(:,73),heltab2x32(:,:,73))
  call Hloop_Q_A(ntryL,G0H16(1),16,nMT,G1H16(73),n2h16(73))
  Gcoeff(:)%j = (-(c(79)*M(2,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(74),h0tab(:,74),[16,2,8,1,4],[nMT,nMZ,nMB,nMW,nMT],5,0)
  call Hloop_QV_A(ntryL,G0H32(1),ex5(:),G0H16(1),m3h2x16(:,74),heltab2x32(:,:,74))
  call Hloop_Q_A(ntryL,G0H16(1),16,nMT,G1H16(74),n2h16(74))
  Gcoeff(:)%j = (c(44)*M(2,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(75),h0tab(:,75),[16,2,8,1,4],[nMB,nMW,nMT,nMH,nMB],5,0)
  call Hloop_QV_A(ntryL,G0H32(1),ex5(:),G0H16(1),m3h2x16(:,75),heltab2x32(:,:,75))
  call Hloop_Q_A(ntryL,G0H16(1),16,nMB,G1H16(75),n2h16(75))
  Gcoeff(:)%j = (c(44)*M(2,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(76),h0tab(:,76),[16,2,8,1,4],[nMB,nMW,nMT,nMZ,nMB],5,0)
  call Hloop_QV_A(ntryL,G0H32(1),ex5(:),G0H16(1),m3h2x16(:,76),heltab2x32(:,:,76))
  call Hloop_Q_A(ntryL,G0H16(1),16,nMB,G1H16(76),n2h16(76))
  Gcoeff(:)%j = (c(75)*M(2,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(77),h0tab(:,77),[16,2,8,1,4],[nMB,nMW,nMT,0,nMB],5,0)
  call Hloop_QV_A(ntryL,G0H32(1),ex5(:),G0H16(1),m3h2x16(:,77),heltab2x32(:,:,77))
  call Hloop_Q_A(ntryL,G0H16(1),16,nMB,G1H16(77),n2h16(77))
  Gcoeff(:)%j = (-(c(79)*M(2,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(78),h0tab(:,78),[16,2,8,1,4],[nMB,nMW,nMT,nMZ,nMB],5,0)
  call Hloop_QV_A(ntryL,G0H32(1),ex5(:),G0H16(1),m3h2x16(:,78),heltab2x32(:,:,78))
  call Hloop_Q_A(ntryL,G0H16(1),16,nMB,G1H16(78),n2h16(78))
  Gcoeff(:)%j = (c(44)*M(2,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(79),h0tab(:,79),[16,2,8,1,4],[nMT,nMH,nMB,nMW,nMT],5,0)
  call Hloop_QV_A(ntryL,G0H32(1),ex5(:),G0H16(1),m3h2x16(:,79),heltab2x32(:,:,79))
  call Hloop_Q_A(ntryL,G0H16(1),16,nMT,G1H16(79),n2h16(79))
  Gcoeff(:)%j = (c(44)*M(2,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(80),h0tab(:,80),[16,2,8,1,4],[nMT,nMZ,nMB,nMW,nMT],5,0)
  call Hloop_QV_A(ntryL,G0H32(1),ex5(:),G0H16(1),m3h2x16(:,80),heltab2x32(:,:,80))
  call Hloop_Q_A(ntryL,G0H16(1),16,nMT,G1H16(80),n2h16(80))
  Gcoeff(:)%j = (c(61)*M(2,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(81),h0tab(:,81),[16,2,8,1,4],[nMT,0,nMB,nMW,nMT],5,0)
  call Hloop_QV_A(ntryL,G0H32(1),ex5(:),G0H16(1),m3h2x16(:,81),heltab2x32(:,:,81))
  call Hloop_Q_A(ntryL,G0H16(1),16,nMT,G1H16(81),n2h16(81))
  Gcoeff(:)%j = (c(61)*M(2,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(82),h0tab(:,82),[16,2,8,1,4],[nMB,nMW,nMT,0,nMB],5,0)
  call Hloop_QV_A(ntryL,G0H32(1),ex5(:),G0H16(1),m3h2x16(:,82),heltab2x32(:,:,82))
  call Hloop_Q_A(ntryL,G0H16(1),16,nMB,G1H16(82),n2h16(82))
  Gcoeff(:)%j = (-(c(65)*M(2,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(83),h0tab(:,83),[16,2,8,1,4],[nMT,nMZ,nMB,nMW,nMT],5,0)
  call Hloop_QV_A(ntryL,G0H32(1),ex5(:),G0H16(1),m3h2x16(:,83),heltab2x32(:,:,83))
  call Hloop_Q_A(ntryL,G0H16(1),16,nMT,G1H16(83),n2h16(83))
  Gcoeff(:)%j = (-(c(65)*M(2,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(84),h0tab(:,84),[16,2,8,1,4],[nMB,nMW,nMT,nMZ,nMB],5,0)
  call Hloop_QV_A(ntryL,G0H32(1),ex5(:),G0H16(1),m3h2x16(:,84),heltab2x32(:,:,84))
  call Hloop_Q_A(ntryL,G0H16(1),16,nMB,G1H16(84),n2h16(84))
  Gcoeff(:)%j = (c(24)*M(3,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(85),h0tab(:,85),[16,1,4,2,8],[nMT,nMH,nMB,nMW,nMT],5,0)
  call Hloop_AV_Q(ntryL,G0H32(1),ex5(:),G0H16(1),m3h2x16(:,85),heltab2x32(:,:,85))
  call Hloop_A_Q(ntryL,G0H16(1),16,nMT,G1H16(85),n2h16(85))
  Gcoeff(:)%j = (c(24)*M(3,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(86),h0tab(:,86),[16,1,4,2,8],[nMB,nMW,nMT,nMH,nMB],5,0)
  call Hloop_AV_Q(ntryL,G0H32(1),ex5(:),G0H16(1),m3h2x16(:,86),heltab2x32(:,:,86))
  call Hloop_A_Q(ntryL,G0H16(1),16,nMB,G1H16(86),n2h16(86))
  Gcoeff(:)%j = (c(24)*M(3,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(87),h0tab(:,87),[16,1,4,2,8],[nMT,nMZ,nMB,nMW,nMT],5,0)
  call Hloop_AV_Q(ntryL,G0H32(1),ex5(:),G0H16(1),m3h2x16(:,87),heltab2x32(:,:,87))
  call Hloop_A_Q(ntryL,G0H16(1),16,nMT,G1H16(87),n2h16(87))
  Gcoeff(:)%j = (c(24)*M(3,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(88),h0tab(:,88),[16,1,4,2,8],[nMB,nMW,nMT,nMZ,nMB],5,0)
  call Hloop_AV_Q(ntryL,G0H32(1),ex5(:),G0H16(1),m3h2x16(:,88),heltab2x32(:,:,88))
  call Hloop_A_Q(ntryL,G0H16(1),16,nMB,G1H16(88),n2h16(88))
  Gcoeff(:)%j = (c(75)*M(3,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(89),h0tab(:,89),[16,1,4,2,8],[nMB,nMW,nMT,0,nMB],5,0)
  call Hloop_AV_Q(ntryL,G0H32(1),ex5(:),G0H16(1),m3h2x16(:,89),heltab2x32(:,:,89))
  call Hloop_A_Q(ntryL,G0H16(1),16,nMB,G1H16(89),n2h16(89))
  Gcoeff(:)%j = (-(c(79)*M(3,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(90),h0tab(:,90),[16,1,4,2,8],[nMB,nMW,nMT,nMZ,nMB],5,0)
  call Hloop_AV_Q(ntryL,G0H32(1),ex5(:),G0H16(1),m3h2x16(:,90),heltab2x32(:,:,90))
  call Hloop_A_Q(ntryL,G0H16(1),16,nMB,G1H16(90),n2h16(90))
  Gcoeff(:)%j = (c(44)*M(3,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(91),h0tab(:,91),[16,1,4,2,8],[nMT,nMH,nMB,nMW,nMT],5,0)
  call Hloop_AV_Q(ntryL,G0H32(1),ex5(:),G0H16(1),m3h2x16(:,91),heltab2x32(:,:,91))
  call Hloop_A_Q(ntryL,G0H16(1),16,nMT,G1H16(91),n2h16(91))
  Gcoeff(:)%j = (c(44)*M(3,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(92),h0tab(:,92),[16,1,4,2,8],[nMT,nMZ,nMB,nMW,nMT],5,0)
  call Hloop_AV_Q(ntryL,G0H32(1),ex5(:),G0H16(1),m3h2x16(:,92),heltab2x32(:,:,92))
  call Hloop_A_Q(ntryL,G0H16(1),16,nMT,G1H16(92),n2h16(92))
  Gcoeff(:)%j = (c(75)*M(3,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(93),h0tab(:,93),[16,1,4,2,8],[nMT,0,nMB,nMW,nMT],5,0)
  call Hloop_AV_Q(ntryL,G0H32(1),ex5(:),G0H16(1),m3h2x16(:,93),heltab2x32(:,:,93))
  call Hloop_A_Q(ntryL,G0H16(1),16,nMT,G1H16(93),n2h16(93))
  Gcoeff(:)%j = (-(c(79)*M(3,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(94),h0tab(:,94),[16,1,4,2,8],[nMT,nMZ,nMB,nMW,nMT],5,0)
  call Hloop_AV_Q(ntryL,G0H32(1),ex5(:),G0H16(1),m3h2x16(:,94),heltab2x32(:,:,94))
  call Hloop_A_Q(ntryL,G0H16(1),16,nMT,G1H16(94),n2h16(94))
  Gcoeff(:)%j = (c(44)*M(3,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(95),h0tab(:,95),[16,1,4,2,8],[nMB,nMW,nMT,nMH,nMB],5,0)
  call Hloop_AV_Q(ntryL,G0H32(1),ex5(:),G0H16(1),m3h2x16(:,95),heltab2x32(:,:,95))
  call Hloop_A_Q(ntryL,G0H16(1),16,nMB,G1H16(95),n2h16(95))
  Gcoeff(:)%j = (c(44)*M(3,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(96),h0tab(:,96),[16,1,4,2,8],[nMB,nMW,nMT,nMZ,nMB],5,0)
  call Hloop_AV_Q(ntryL,G0H32(1),ex5(:),G0H16(1),m3h2x16(:,96),heltab2x32(:,:,96))
  call Hloop_A_Q(ntryL,G0H16(1),16,nMB,G1H16(96),n2h16(96))
  Gcoeff(:)%j = (c(61)*M(3,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(97),h0tab(:,97),[16,1,4,2,8],[nMT,0,nMB,nMW,nMT],5,0)
  call Hloop_AV_Q(ntryL,G0H32(1),ex5(:),G0H16(1),m3h2x16(:,97),heltab2x32(:,:,97))
  call Hloop_A_Q(ntryL,G0H16(1),16,nMT,G1H16(97),n2h16(97))
  Gcoeff(:)%j = (c(61)*M(3,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(98),h0tab(:,98),[16,1,4,2,8],[nMB,nMW,nMT,0,nMB],5,0)
  call Hloop_AV_Q(ntryL,G0H32(1),ex5(:),G0H16(1),m3h2x16(:,98),heltab2x32(:,:,98))
  call Hloop_A_Q(ntryL,G0H16(1),16,nMB,G1H16(98),n2h16(98))
  Gcoeff(:)%j = (-(c(65)*M(3,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(99),h0tab(:,99),[16,1,4,2,8],[nMT,nMZ,nMB,nMW,nMT],5,0)
  call Hloop_AV_Q(ntryL,G0H32(1),ex5(:),G0H16(1),m3h2x16(:,99),heltab2x32(:,:,99))
  call Hloop_A_Q(ntryL,G0H16(1),16,nMT,G1H16(99),n2h16(99))
  Gcoeff(:)%j = (-(c(65)*M(3,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(100),h0tab(:,100),[16,1,4,2,8],[nMB,nMW,nMT,nMZ,nMB],5,0)
  call Hloop_AV_Q(ntryL,G0H32(1),ex5(:),G0H16(1),m3h2x16(:,100),heltab2x32(:,:,100))
  call Hloop_A_Q(ntryL,G0H16(1),16,nMB,G1H16(100),n2h16(100))
  Gcoeff(:)%j = (c(33)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(101),h0tab(:,101),[16,1,4,8,2],[nMT,nMH,nMB,nMH,nMT],5,0)
  call Hloop_AV_Q(ntryL,G0H32(1),ex5(:),G0H16(1),m3h2x16(:,101),heltab2x32(:,:,101))
  call Hloop_A_Q(ntryL,G0H16(1),16,nMT,G1H16(101),n2h16(101))
  Gcoeff(:)%j = (c(33)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(102),h0tab(:,102),[16,1,4,8,2],[nMT,nMH,nMB,nMZ,nMT],5,0)
  call Hloop_AV_Q(ntryL,G0H32(1),ex5(:),G0H16(1),m3h2x16(:,102),heltab2x32(:,:,102))
  call Hloop_A_Q(ntryL,G0H16(1),16,nMT,G1H16(102),n2h16(102))
  Gcoeff(:)%j = (c(33)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(103),h0tab(:,103),[16,1,4,8,2],[nMT,nMZ,nMB,nMH,nMT],5,0)
  call Hloop_AV_Q(ntryL,G0H32(1),ex5(:),G0H16(1),m3h2x16(:,103),heltab2x32(:,:,103))
  call Hloop_A_Q(ntryL,G0H16(1),16,nMT,G1H16(103),n2h16(103))
  Gcoeff(:)%j = (c(33)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(104),h0tab(:,104),[16,1,4,8,2],[nMT,nMZ,nMB,nMZ,nMT],5,0)
  call Hloop_AV_Q(ntryL,G0H32(1),ex5(:),G0H16(1),m3h2x16(:,104),heltab2x32(:,:,104))
  call Hloop_A_Q(ntryL,G0H16(1),16,nMT,G1H16(104),n2h16(104))
  Gcoeff(:)%j = (c(20)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(105),h0tab(:,105),[16,1,4,8,2],[nMB,nMW,nMT,nMW,nMB],5,0)
  call Hloop_AV_Q(ntryL,G0H32(1),ex5(:),G0H16(1),m3h2x16(:,105),heltab2x32(:,:,105))
  call Hloop_A_Q(ntryL,G0H16(1),16,nMB,G1H16(105),n2h16(105))
  Gcoeff(:)%j = (c(84)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(106),h0tab(:,106),[16,1,4,8,2],[nMT,nMH,nMB,0,nMT],5,0)
  call Hloop_AV_Q(ntryL,G0H32(1),ex5(:),G0H16(1),m3h2x16(:,106),heltab2x32(:,:,106))
  call Hloop_A_Q(ntryL,G0H16(1),16,nMT,G1H16(106),n2h16(106))
  Gcoeff(:)%j = (c(84)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(107),h0tab(:,107),[16,1,4,8,2],[nMT,nMZ,nMB,0,nMT],5,0)
  call Hloop_AV_Q(ntryL,G0H32(1),ex5(:),G0H16(1),m3h2x16(:,107),heltab2x32(:,:,107))
  call Hloop_A_Q(ntryL,G0H16(1),16,nMT,G1H16(107),n2h16(107))
  Gcoeff(:)%j = (-(c(86)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(108),h0tab(:,108),[16,1,4,8,2],[nMT,nMH,nMB,nMZ,nMT],5,0)
  call Hloop_AV_Q(ntryL,G0H32(1),ex5(:),G0H16(1),m3h2x16(:,108),heltab2x32(:,:,108))
  call Hloop_A_Q(ntryL,G0H16(1),16,nMT,G1H16(108),n2h16(108))
  Gcoeff(:)%j = (-(c(86)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(109),h0tab(:,109),[16,1,4,8,2],[nMT,nMZ,nMB,nMZ,nMT],5,0)
  call Hloop_AV_Q(ntryL,G0H32(1),ex5(:),G0H16(1),m3h2x16(:,109),heltab2x32(:,:,109))
  call Hloop_A_Q(ntryL,G0H16(1),16,nMT,G1H16(109),n2h16(109))
  Gcoeff(:)%j = (c(38)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(110),h0tab(:,110),[16,1,4,8,2],[nMB,nMW,nMT,nMW,nMB],5,0)
  call Hloop_AV_Q(ntryL,G0H32(1),ex5(:),G0H16(1),m3h2x16(:,110),heltab2x32(:,:,110))
  call Hloop_A_Q(ntryL,G0H16(1),16,nMB,G1H16(110),n2h16(110))
  Gcoeff(:)%j = (c(84)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(111),h0tab(:,111),[16,1,4,8,2],[nMT,0,nMB,nMH,nMT],5,0)
  call Hloop_AV_Q(ntryL,G0H32(1),ex5(:),G0H16(1),m3h2x16(:,111),heltab2x32(:,:,111))
  call Hloop_A_Q(ntryL,G0H16(1),16,nMT,G1H16(111),n2h16(111))
  Gcoeff(:)%j = (c(84)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(112),h0tab(:,112),[16,1,4,8,2],[nMT,0,nMB,nMZ,nMT],5,0)
  call Hloop_AV_Q(ntryL,G0H32(1),ex5(:),G0H16(1),m3h2x16(:,112),heltab2x32(:,:,112))
  call Hloop_A_Q(ntryL,G0H16(1),16,nMT,G1H16(112),n2h16(112))
  Gcoeff(:)%j = (-(c(86)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(113),h0tab(:,113),[16,1,4,8,2],[nMT,nMZ,nMB,nMH,nMT],5,0)
  call Hloop_AV_Q(ntryL,G0H32(1),ex5(:),G0H16(1),m3h2x16(:,113),heltab2x32(:,:,113))
  call Hloop_A_Q(ntryL,G0H16(1),16,nMT,G1H16(113),n2h16(113))
  Gcoeff(:)%j = (-(c(86)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(114),h0tab(:,114),[16,1,4,8,2],[nMT,nMZ,nMB,nMZ,nMT],5,0)
  call Hloop_AV_Q(ntryL,G0H32(1),ex5(:),G0H16(1),m3h2x16(:,114),heltab2x32(:,:,114))
  call Hloop_A_Q(ntryL,G0H16(1),16,nMT,G1H16(114),n2h16(114))
  Gcoeff(:)%j = (c(38)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(115),h0tab(:,115),[16,1,4,8,2],[nMB,nMW,nMT,nMW,nMB],5,0)
  call Hloop_AV_Q(ntryL,G0H32(1),ex5(:),G0H16(1),m3h2x16(:,115),heltab2x32(:,:,115))
  call Hloop_A_Q(ntryL,G0H16(1),16,nMB,G1H16(115),n2h16(115))
  Gcoeff(:)%j = (c(2)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(116),h0tab(:,116),[16,1,4,8,2],[nMT,0,nMB,0,nMT],5,0)
  call Hloop_AV_Q(ntryL,G0H32(1),ex5(:),G0H16(1),m3h2x16(:,116),heltab2x32(:,:,116))
  call Hloop_A_Q(ntryL,G0H16(1),16,nMT,G1H16(116),n2h16(116))
  Gcoeff(:)%j = (-(c(5)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(117),h0tab(:,117),[16,1,4,8,2],[nMT,0,nMB,nMZ,nMT],5,0)
  call Hloop_AV_Q(ntryL,G0H32(1),ex5(:),G0H16(1),m3h2x16(:,117),heltab2x32(:,:,117))
  call Hloop_A_Q(ntryL,G0H16(1),16,nMT,G1H16(117),n2h16(117))
  Gcoeff(:)%j = (-(c(5)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(118),h0tab(:,118),[16,1,4,8,2],[nMT,nMZ,nMB,0,nMT],5,0)
  call Hloop_AV_Q(ntryL,G0H32(1),ex5(:),G0H16(1),m3h2x16(:,118),heltab2x32(:,:,118))
  call Hloop_A_Q(ntryL,G0H16(1),16,nMT,G1H16(118),n2h16(118))
  Gcoeff(:)%j = (c(7)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(119),h0tab(:,119),[16,1,4,8,2],[nMT,nMZ,nMB,nMZ,nMT],5,0)
  call Hloop_AV_Q(ntryL,G0H32(1),ex5(:),G0H16(1),m3h2x16(:,119),heltab2x32(:,:,119))
  call Hloop_A_Q(ntryL,G0H16(1),16,nMT,G1H16(119),n2h16(119))
  Gcoeff(:)%j = (c(12)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(120),h0tab(:,120),[16,1,4,8,2],[nMB,nMW,nMT,nMW,nMB],5,0)
  call Hloop_AV_Q(ntryL,G0H32(1),ex5(:),G0H16(1),m3h2x16(:,120),heltab2x32(:,:,120))
  call Hloop_A_Q(ntryL,G0H16(1),16,nMB,G1H16(120),n2h16(120))
  Gcoeff(:)%j = (c(33)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(121),h0tab(:,121),[16,1,8,4,2],[nMT,nMH,nMB,nMH,nMT],5,0)
  call Hloop_AV_Q(ntryL,G0H32(1),ex5(:),G0H16(1),m3h2x16(:,121),heltab2x32(:,:,121))
  call Hloop_A_Q(ntryL,G0H16(1),16,nMT,G1H16(121),n2h16(121))
  Gcoeff(:)%j = (c(33)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(122),h0tab(:,122),[16,1,8,4,2],[nMT,nMH,nMB,nMZ,nMT],5,0)
  call Hloop_AV_Q(ntryL,G0H32(1),ex5(:),G0H16(1),m3h2x16(:,122),heltab2x32(:,:,122))
  call Hloop_A_Q(ntryL,G0H16(1),16,nMT,G1H16(122),n2h16(122))
  Gcoeff(:)%j = (c(33)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(123),h0tab(:,123),[16,1,8,4,2],[nMT,nMZ,nMB,nMH,nMT],5,0)
  call Hloop_AV_Q(ntryL,G0H32(1),ex5(:),G0H16(1),m3h2x16(:,123),heltab2x32(:,:,123))
  call Hloop_A_Q(ntryL,G0H16(1),16,nMT,G1H16(123),n2h16(123))
  Gcoeff(:)%j = (c(33)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(124),h0tab(:,124),[16,1,8,4,2],[nMT,nMZ,nMB,nMZ,nMT],5,0)
  call Hloop_AV_Q(ntryL,G0H32(1),ex5(:),G0H16(1),m3h2x16(:,124),heltab2x32(:,:,124))
  call Hloop_A_Q(ntryL,G0H16(1),16,nMT,G1H16(124),n2h16(124))
  Gcoeff(:)%j = (c(84)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(125),h0tab(:,125),[16,1,8,4,2],[nMT,nMH,nMB,0,nMT],5,0)
  call Hloop_AV_Q(ntryL,G0H32(1),ex5(:),G0H16(1),m3h2x16(:,125),heltab2x32(:,:,125))
  call Hloop_A_Q(ntryL,G0H16(1),16,nMT,G1H16(125),n2h16(125))
  Gcoeff(:)%j = (c(84)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(126),h0tab(:,126),[16,1,8,4,2],[nMT,nMZ,nMB,0,nMT],5,0)
  call Hloop_AV_Q(ntryL,G0H32(1),ex5(:),G0H16(1),m3h2x16(:,126),heltab2x32(:,:,126))
  call Hloop_A_Q(ntryL,G0H16(1),16,nMT,G1H16(126),n2h16(126))
  Gcoeff(:)%j = (-(c(86)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(127),h0tab(:,127),[16,1,8,4,2],[nMT,nMH,nMB,nMZ,nMT],5,0)
  call Hloop_AV_Q(ntryL,G0H32(1),ex5(:),G0H16(1),m3h2x16(:,127),heltab2x32(:,:,127))
  call Hloop_A_Q(ntryL,G0H16(1),16,nMT,G1H16(127),n2h16(127))
  Gcoeff(:)%j = (-(c(86)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(128),h0tab(:,128),[16,1,8,4,2],[nMT,nMZ,nMB,nMZ,nMT],5,0)
  call Hloop_AV_Q(ntryL,G0H32(1),ex5(:),G0H16(1),m3h2x16(:,128),heltab2x32(:,:,128))
  call Hloop_A_Q(ntryL,G0H16(1),16,nMT,G1H16(128),n2h16(128))
  Gcoeff(:)%j = (c(84)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(129),h0tab(:,129),[16,1,8,4,2],[nMT,0,nMB,nMH,nMT],5,0)
  call Hloop_AV_Q(ntryL,G0H32(1),ex5(:),G0H16(1),m3h2x16(:,129),heltab2x32(:,:,129))
  call Hloop_A_Q(ntryL,G0H16(1),16,nMT,G1H16(129),n2h16(129))
  Gcoeff(:)%j = (c(84)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(130),h0tab(:,130),[16,1,8,4,2],[nMT,0,nMB,nMZ,nMT],5,0)
  call Hloop_AV_Q(ntryL,G0H32(1),ex5(:),G0H16(1),m3h2x16(:,130),heltab2x32(:,:,130))
  call Hloop_A_Q(ntryL,G0H16(1),16,nMT,G1H16(130),n2h16(130))
  Gcoeff(:)%j = (-(c(86)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(131),h0tab(:,131),[16,1,8,4,2],[nMT,nMZ,nMB,nMH,nMT],5,0)
  call Hloop_AV_Q(ntryL,G0H32(1),ex5(:),G0H16(1),m3h2x16(:,131),heltab2x32(:,:,131))
  call Hloop_A_Q(ntryL,G0H16(1),16,nMT,G1H16(131),n2h16(131))
  Gcoeff(:)%j = (-(c(86)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(132),h0tab(:,132),[16,1,8,4,2],[nMT,nMZ,nMB,nMZ,nMT],5,0)
  call Hloop_AV_Q(ntryL,G0H32(1),ex5(:),G0H16(1),m3h2x16(:,132),heltab2x32(:,:,132))
  call Hloop_A_Q(ntryL,G0H16(1),16,nMT,G1H16(132),n2h16(132))
  Gcoeff(:)%j = (c(2)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(133),h0tab(:,133),[16,1,8,4,2],[nMT,0,nMB,0,nMT],5,0)
  call Hloop_AV_Q(ntryL,G0H32(1),ex5(:),G0H16(1),m3h2x16(:,133),heltab2x32(:,:,133))
  call Hloop_A_Q(ntryL,G0H16(1),16,nMT,G1H16(133),n2h16(133))
  Gcoeff(:)%j = (-(c(5)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(134),h0tab(:,134),[16,1,8,4,2],[nMT,0,nMB,nMZ,nMT],5,0)
  call Hloop_AV_Q(ntryL,G0H32(1),ex5(:),G0H16(1),m3h2x16(:,134),heltab2x32(:,:,134))
  call Hloop_A_Q(ntryL,G0H16(1),16,nMT,G1H16(134),n2h16(134))
  Gcoeff(:)%j = (-(c(5)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(135),h0tab(:,135),[16,1,8,4,2],[nMT,nMZ,nMB,0,nMT],5,0)
  call Hloop_AV_Q(ntryL,G0H32(1),ex5(:),G0H16(1),m3h2x16(:,135),heltab2x32(:,:,135))
  call Hloop_A_Q(ntryL,G0H16(1),16,nMT,G1H16(135),n2h16(135))
  Gcoeff(:)%j = (c(7)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(136),h0tab(:,136),[16,1,8,4,2],[nMT,nMZ,nMB,nMZ,nMT],5,0)
  call Hloop_AV_Q(ntryL,G0H32(1),ex5(:),G0H16(1),m3h2x16(:,136),heltab2x32(:,:,136))
  call Hloop_A_Q(ntryL,G0H16(1),16,nMT,G1H16(136),n2h16(136))
  call Hloop_AQ_S(ntryL,G1H16(1),ex3(:),G1H8(1),ngH,m3h2x8(:,1),heltab2x16(:,:,1))
  call Hloop_AQ_S(ntryL,G1H16(2),ex3(:),G1H8(2),ngH,m3h2x8(:,2),heltab2x16(:,:,2))
  call Hloop_AQ_S(ntryL,G1H16(3),ex3(:),G1H8(3),ngX,m3h2x8(:,3),heltab2x16(:,:,3))
  call Hloop_AQ_S(ntryL,G1H16(4),ex3(:),G1H8(4),ngX,m3h2x8(:,4),heltab2x16(:,:,4))
  call Hloop_AQ_S(ntryL,G1H16(5),ex3(:),G1H8(5),ngPtb,m3h2x8(:,5),heltab2x16(:,:,5))
  call Hloop_AQ_S(ntryL,G1H16(6),ex3(:),G1H8(6),ngH,m3h2x8(:,6),heltab2x16(:,:,6))
  call Hloop_AQ_S(ntryL,G1H16(7),ex3(:),G1H8(7),ngX,m3h2x8(:,7),heltab2x16(:,:,7))
  call Hloop_AQ_S(ntryL,G1H16(8),ex3(:),G1H8(8),ngH,m3h2x8(:,8),heltab2x16(:,:,8))
  call Hloop_AQ_S(ntryL,G1H16(9),ex3(:),G1H8(9),ngX,m3h2x8(:,9),heltab2x16(:,:,9))
  call Hloop_AQ_S(ntryL,G1H16(10),ex3(:),G1H8(10),ngPtb,m3h2x8(:,10),heltab2x16(:,:,10))
  call Hloop_AQ_V(ntryL,G1H16(11),ex3(:),G1H8(11),m3h2x8(:,11),heltab2x16(:,:,11))
  call Hloop_AQ_V(ntryL,G1H16(12),ex3(:),G1H8(12),m3h2x8(:,12),heltab2x16(:,:,12))
  call Hloop_AQ_Z(ntryL,G1H16(13),ex3(:),G1H8(13),ngZd,m3h2x8(:,13),heltab2x16(:,:,13))
  call Hloop_AQ_Z(ntryL,G1H16(14),ex3(:),G1H8(14),ngZd,m3h2x8(:,14),heltab2x16(:,:,14))
  call Hloop_AQ_W(ntryL,G1H16(15),ex3(:),G1H8(15),m3h2x8(:,15),heltab2x16(:,:,15))
  call Hloop_AQ_V(ntryL,G1H16(16),ex3(:),G1H8(16),m3h2x8(:,16),heltab2x16(:,:,16))
  call Hloop_AQ_V(ntryL,G1H16(17),ex3(:),G1H8(17),m3h2x8(:,17),heltab2x16(:,:,17))
  call Hloop_AQ_Z(ntryL,G1H16(18),ex3(:),G1H8(18),ngZd,m3h2x8(:,18),heltab2x16(:,:,18))
  call Hloop_AQ_Z(ntryL,G1H16(19),ex3(:),G1H8(19),ngZd,m3h2x8(:,19),heltab2x16(:,:,19))
  call Hloop_AQ_W(ntryL,G1H16(20),ex3(:),G1H8(20),m3h2x8(:,20),heltab2x16(:,:,20))
  call Hloop_AQ_S(ntryL,G1H16(21),ex3(:),G1H8(21),ngH,m3h2x8(:,21),heltab2x16(:,:,21))
  call Hloop_AQ_S(ntryL,G1H16(22),ex3(:),G1H8(22),ngX,m3h2x8(:,22),heltab2x16(:,:,22))
  call Hloop_AQ_S(ntryL,G1H16(23),ex3(:),G1H8(23),ngH,m3h2x8(:,23),heltab2x16(:,:,23))
  call Hloop_AQ_S(ntryL,G1H16(24),ex3(:),G1H8(24),ngX,m3h2x8(:,24),heltab2x16(:,:,24))
  call Hloop_AQ_V(ntryL,G1H16(25),ex3(:),G1H8(25),m3h2x8(:,25),heltab2x16(:,:,25))
  call Hloop_AQ_V(ntryL,G1H16(26),ex3(:),G1H8(26),m3h2x8(:,26),heltab2x16(:,:,26))
  call Hloop_AQ_Z(ntryL,G1H16(27),ex3(:),G1H8(27),ngZd,m3h2x8(:,27),heltab2x16(:,:,27))
  call Hloop_AQ_Z(ntryL,G1H16(28),ex3(:),G1H8(28),ngZd,m3h2x8(:,28),heltab2x16(:,:,28))
  call Hloop_AQ_S(ntryL,G1H16(29),ex3(:),G1H8(29),ngH,m3h2x8(:,29),heltab2x16(:,:,29))
  call Hloop_AQ_S(ntryL,G1H16(30),ex3(:),G1H8(30),ngX,m3h2x8(:,30),heltab2x16(:,:,30))
  call Hloop_AQ_S(ntryL,G1H16(31),ex3(:),G1H8(31),ngH,m3h2x8(:,31),heltab2x16(:,:,31))
  call Hloop_AQ_S(ntryL,G1H16(32),ex3(:),G1H8(32),ngX,m3h2x8(:,32),heltab2x16(:,:,32))
  call Hloop_AQ_V(ntryL,G1H16(33),ex3(:),G1H8(33),m3h2x8(:,33),heltab2x16(:,:,33))
  call Hloop_AQ_Z(ntryL,G1H16(34),ex3(:),G1H8(34),ngZd,m3h2x8(:,34),heltab2x16(:,:,34))
  call Hloop_AQ_V(ntryL,G1H16(35),ex3(:),G1H8(35),m3h2x8(:,35),heltab2x16(:,:,35))
  call Hloop_AQ_Z(ntryL,G1H16(36),ex3(:),G1H8(36),ngZd,m3h2x8(:,36),heltab2x16(:,:,36))
  call Hloop_QA_S(ntryL,G1H16(37),ex2(:),G1H8(37),ngH,m3h2x8(:,37),heltab2x16(:,:,37))
  call Hloop_QA_S(ntryL,G1H16(38),ex2(:),G1H8(38),ngPtb,m3h2x8(:,38),heltab2x16(:,:,38))
  call Hloop_QA_S(ntryL,G1H16(39),ex2(:),G1H8(39),ngX,m3h2x8(:,39),heltab2x16(:,:,39))
  call Hloop_QA_S(ntryL,G1H16(40),ex2(:),G1H8(40),ngPtb,m3h2x8(:,40),heltab2x16(:,:,40))
  call Hloop_QA_S(ntryL,G1H16(41),ex2(:),G1H8(41),ngPtb,m3h2x8(:,41),heltab2x16(:,:,41))
  call Hloop_QA_S(ntryL,G1H16(42),ex2(:),G1H8(42),ngPtb,m3h2x8(:,42),heltab2x16(:,:,42))
  call Hloop_QA_S(ntryL,G1H16(43),ex2(:),G1H8(43),ngH,m3h2x8(:,43),heltab2x16(:,:,43))
  call Hloop_QA_S(ntryL,G1H16(44),ex2(:),G1H8(44),ngX,m3h2x8(:,44),heltab2x16(:,:,44))
  call Hloop_QA_V(ntryL,G1H16(45),ex2(:),G1H8(45),m3h2x8(:,45),heltab2x16(:,:,45))
  call Hloop_QA_Z(ntryL,G1H16(46),ex2(:),G1H8(46),ngZu,m3h2x8(:,46),heltab2x16(:,:,46))
  call Hloop_QA_W(ntryL,G1H16(47),ex2(:),G1H8(47),m3h2x8(:,47),heltab2x16(:,:,47))
  call Hloop_QA_W(ntryL,G1H16(48),ex2(:),G1H8(48),m3h2x8(:,48),heltab2x16(:,:,48))
  call Hloop_QA_V(ntryL,G1H16(49),ex2(:),G1H8(49),m3h2x8(:,49),heltab2x16(:,:,49))
  call Hloop_QA_W(ntryL,G1H16(50),ex2(:),G1H8(50),m3h2x8(:,50),heltab2x16(:,:,50))
  call Hloop_QA_Z(ntryL,G1H16(51),ex2(:),G1H8(51),ngZu,m3h2x8(:,51),heltab2x16(:,:,51))
  call Hloop_QA_W(ntryL,G1H16(52),ex2(:),G1H8(52),m3h2x8(:,52),heltab2x16(:,:,52))
  call Hloop_AQ_S(ntryL,G1H16(53),ex1(:),G1H8(53),ngH,m3h2x8(:,53),heltab2x16(:,:,53))
  call Hloop_AQ_S(ntryL,G1H16(54),ex1(:),G1H8(54),ngPbt,m3h2x8(:,54),heltab2x16(:,:,54))
  call Hloop_AQ_S(ntryL,G1H16(55),ex1(:),G1H8(55),ngX,m3h2x8(:,55),heltab2x16(:,:,55))
  call Hloop_AQ_S(ntryL,G1H16(56),ex1(:),G1H8(56),ngPbt,m3h2x8(:,56),heltab2x16(:,:,56))
  call Hloop_AQ_S(ntryL,G1H16(57),ex1(:),G1H8(57),ngPbt,m3h2x8(:,57),heltab2x16(:,:,57))
  call Hloop_AQ_S(ntryL,G1H16(58),ex1(:),G1H8(58),ngPbt,m3h2x8(:,58),heltab2x16(:,:,58))
  call Hloop_AQ_S(ntryL,G1H16(59),ex1(:),G1H8(59),ngH,m3h2x8(:,59),heltab2x16(:,:,59))
  call Hloop_AQ_S(ntryL,G1H16(60),ex1(:),G1H8(60),ngX,m3h2x8(:,60),heltab2x16(:,:,60))
  call Hloop_AQ_V(ntryL,G1H16(61),ex1(:),G1H8(61),m3h2x8(:,61),heltab2x16(:,:,61))
  call Hloop_AQ_Z(ntryL,G1H16(62),ex1(:),G1H8(62),ngZu,m3h2x8(:,62),heltab2x16(:,:,62))
  call Hloop_AQ_W(ntryL,G1H16(63),ex1(:),G1H8(63),m3h2x8(:,63),heltab2x16(:,:,63))
  call Hloop_AQ_W(ntryL,G1H16(64),ex1(:),G1H8(64),m3h2x8(:,64),heltab2x16(:,:,64))
  call Hloop_AQ_V(ntryL,G1H16(65),ex1(:),G1H8(65),m3h2x8(:,65),heltab2x16(:,:,65))
  call Hloop_AQ_W(ntryL,G1H16(66),ex1(:),G1H8(66),m3h2x8(:,66),heltab2x16(:,:,66))
  call Hloop_AQ_Z(ntryL,G1H16(67),ex1(:),G1H8(67),ngZu,m3h2x8(:,67),heltab2x16(:,:,67))
  call Hloop_AQ_W(ntryL,G1H16(68),ex1(:),G1H8(68),m3h2x8(:,68),heltab2x16(:,:,68))
  call Hloop_QA_S(ntryL,G1H16(69),ex2(:),G1H8(69),ngH,m3h2x8(:,69),heltab2x16(:,:,69))
  call Hloop_QA_S(ntryL,G1H16(70),ex2(:),G1H8(70),ngPtb,m3h2x8(:,70),heltab2x16(:,:,70))
  call Hloop_QA_S(ntryL,G1H16(71),ex2(:),G1H8(71),ngX,m3h2x8(:,71),heltab2x16(:,:,71))
  call Hloop_QA_S(ntryL,G1H16(72),ex2(:),G1H8(72),ngPtb,m3h2x8(:,72),heltab2x16(:,:,72))
  call Hloop_QA_V(ntryL,G1H16(73),ex2(:),G1H8(73),m3h2x8(:,73),heltab2x16(:,:,73))
  call Hloop_QA_Z(ntryL,G1H16(74),ex2(:),G1H8(74),ngZu,m3h2x8(:,74),heltab2x16(:,:,74))
  call Hloop_QA_W(ntryL,G1H16(75),ex2(:),G1H8(75),m3h2x8(:,75),heltab2x16(:,:,75))
  call Hloop_QA_W(ntryL,G1H16(76),ex2(:),G1H8(76),m3h2x8(:,76),heltab2x16(:,:,76))
  call Hloop_QA_S(ntryL,G1H16(77),ex2(:),G1H8(77),ngPtb,m3h2x8(:,77),heltab2x16(:,:,77))
  call Hloop_QA_S(ntryL,G1H16(78),ex2(:),G1H8(78),ngPtb,m3h2x8(:,78),heltab2x16(:,:,78))
  call Hloop_QA_S(ntryL,G1H16(79),ex2(:),G1H8(79),ngH,m3h2x8(:,79),heltab2x16(:,:,79))
  call Hloop_QA_S(ntryL,G1H16(80),ex2(:),G1H8(80),ngX,m3h2x8(:,80),heltab2x16(:,:,80))
  call Hloop_QA_V(ntryL,G1H16(81),ex2(:),G1H8(81),m3h2x8(:,81),heltab2x16(:,:,81))
  call Hloop_QA_W(ntryL,G1H16(82),ex2(:),G1H8(82),m3h2x8(:,82),heltab2x16(:,:,82))
  call Hloop_QA_Z(ntryL,G1H16(83),ex2(:),G1H8(83),ngZu,m3h2x8(:,83),heltab2x16(:,:,83))
  call Hloop_QA_W(ntryL,G1H16(84),ex2(:),G1H8(84),m3h2x8(:,84),heltab2x16(:,:,84))
  call Hloop_AQ_S(ntryL,G1H16(85),ex1(:),G1H8(85),ngH,m3h2x8(:,85),heltab2x16(:,:,85))
  call Hloop_AQ_S(ntryL,G1H16(86),ex1(:),G1H8(86),ngPbt,m3h2x8(:,86),heltab2x16(:,:,86))
  call Hloop_AQ_S(ntryL,G1H16(87),ex1(:),G1H8(87),ngX,m3h2x8(:,87),heltab2x16(:,:,87))
  call Hloop_AQ_S(ntryL,G1H16(88),ex1(:),G1H8(88),ngPbt,m3h2x8(:,88),heltab2x16(:,:,88))
  call Hloop_AQ_S(ntryL,G1H16(89),ex1(:),G1H8(89),ngPbt,m3h2x8(:,89),heltab2x16(:,:,89))
  call Hloop_AQ_S(ntryL,G1H16(90),ex1(:),G1H8(90),ngPbt,m3h2x8(:,90),heltab2x16(:,:,90))
  call Hloop_AQ_S(ntryL,G1H16(91),ex1(:),G1H8(91),ngH,m3h2x8(:,91),heltab2x16(:,:,91))
  call Hloop_AQ_S(ntryL,G1H16(92),ex1(:),G1H8(92),ngX,m3h2x8(:,92),heltab2x16(:,:,92))
  call Hloop_AQ_V(ntryL,G1H16(93),ex1(:),G1H8(93),m3h2x8(:,93),heltab2x16(:,:,93))
  call Hloop_AQ_Z(ntryL,G1H16(94),ex1(:),G1H8(94),ngZu,m3h2x8(:,94),heltab2x16(:,:,94))
  call Hloop_AQ_W(ntryL,G1H16(95),ex1(:),G1H8(95),m3h2x8(:,95),heltab2x16(:,:,95))
  call Hloop_AQ_W(ntryL,G1H16(96),ex1(:),G1H8(96),m3h2x8(:,96),heltab2x16(:,:,96))
  call Hloop_AQ_V(ntryL,G1H16(97),ex1(:),G1H8(97),m3h2x8(:,97),heltab2x16(:,:,97))
  call Hloop_AQ_W(ntryL,G1H16(98),ex1(:),G1H8(98),m3h2x8(:,98),heltab2x16(:,:,98))
  call Hloop_AQ_Z(ntryL,G1H16(99),ex1(:),G1H8(99),ngZu,m3h2x8(:,99),heltab2x16(:,:,99))
  call Hloop_AQ_W(ntryL,G1H16(100),ex1(:),G1H8(100),m3h2x8(:,100),heltab2x16(:,:,100))
  call Hloop_AQ_S(ntryL,G1H16(101),ex1(:),G1H8(101),ngH,m3h2x8(:,101),heltab2x16(:,:,101))
  call Hloop_AQ_S(ntryL,G1H16(102),ex1(:),G1H8(102),ngH,m3h2x8(:,102),heltab2x16(:,:,102))
  call Hloop_AQ_S(ntryL,G1H16(103),ex1(:),G1H8(103),ngX,m3h2x8(:,103),heltab2x16(:,:,103))
  call Hloop_AQ_S(ntryL,G1H16(104),ex1(:),G1H8(104),ngX,m3h2x8(:,104),heltab2x16(:,:,104))
  call Hloop_AQ_S(ntryL,G1H16(105),ex1(:),G1H8(105),ngPbt,m3h2x8(:,105),heltab2x16(:,:,105))
  call Hloop_AQ_S(ntryL,G1H16(106),ex1(:),G1H8(106),ngH,m3h2x8(:,106),heltab2x16(:,:,106))
  call Hloop_AQ_S(ntryL,G1H16(107),ex1(:),G1H8(107),ngX,m3h2x8(:,107),heltab2x16(:,:,107))
  call Hloop_AQ_S(ntryL,G1H16(108),ex1(:),G1H8(108),ngH,m3h2x8(:,108),heltab2x16(:,:,108))
  call Hloop_AQ_S(ntryL,G1H16(109),ex1(:),G1H8(109),ngX,m3h2x8(:,109),heltab2x16(:,:,109))
  call Hloop_AQ_S(ntryL,G1H16(110),ex1(:),G1H8(110),ngPbt,m3h2x8(:,110),heltab2x16(:,:,110))
  call Hloop_AQ_V(ntryL,G1H16(111),ex1(:),G1H8(111),m3h2x8(:,111),heltab2x16(:,:,111))
  call Hloop_AQ_V(ntryL,G1H16(112),ex1(:),G1H8(112),m3h2x8(:,112),heltab2x16(:,:,112))
  call Hloop_AQ_Z(ntryL,G1H16(113),ex1(:),G1H8(113),ngZu,m3h2x8(:,113),heltab2x16(:,:,113))
  call Hloop_AQ_Z(ntryL,G1H16(114),ex1(:),G1H8(114),ngZu,m3h2x8(:,114),heltab2x16(:,:,114))
  call Hloop_AQ_W(ntryL,G1H16(115),ex1(:),G1H8(115),m3h2x8(:,115),heltab2x16(:,:,115))
  call Hloop_AQ_V(ntryL,G1H16(116),ex1(:),G1H8(116),m3h2x8(:,116),heltab2x16(:,:,116))
  call Hloop_AQ_V(ntryL,G1H16(117),ex1(:),G1H8(117),m3h2x8(:,117),heltab2x16(:,:,117))
  call Hloop_AQ_Z(ntryL,G1H16(118),ex1(:),G1H8(118),ngZu,m3h2x8(:,118),heltab2x16(:,:,118))
  call Hloop_AQ_Z(ntryL,G1H16(119),ex1(:),G1H8(119),ngZu,m3h2x8(:,119),heltab2x16(:,:,119))
  call Hloop_AQ_W(ntryL,G1H16(120),ex1(:),G1H8(120),m3h2x8(:,120),heltab2x16(:,:,120))
  call Hloop_AQ_S(ntryL,G1H16(121),ex1(:),G1H8(121),ngH,m3h2x8(:,121),heltab2x16(:,:,121))
  call Hloop_AQ_S(ntryL,G1H16(122),ex1(:),G1H8(122),ngH,m3h2x8(:,122),heltab2x16(:,:,122))
  call Hloop_AQ_S(ntryL,G1H16(123),ex1(:),G1H8(123),ngX,m3h2x8(:,123),heltab2x16(:,:,123))
  call Hloop_AQ_S(ntryL,G1H16(124),ex1(:),G1H8(124),ngX,m3h2x8(:,124),heltab2x16(:,:,124))
  call Hloop_AQ_S(ntryL,G1H16(125),ex1(:),G1H8(125),ngH,m3h2x8(:,125),heltab2x16(:,:,125))
  call Hloop_AQ_S(ntryL,G1H16(126),ex1(:),G1H8(126),ngX,m3h2x8(:,126),heltab2x16(:,:,126))
  call Hloop_AQ_S(ntryL,G1H16(127),ex1(:),G1H8(127),ngH,m3h2x8(:,127),heltab2x16(:,:,127))
  call Hloop_AQ_S(ntryL,G1H16(128),ex1(:),G1H8(128),ngX,m3h2x8(:,128),heltab2x16(:,:,128))
  call Hloop_AQ_V(ntryL,G1H16(129),ex1(:),G1H8(129),m3h2x8(:,129),heltab2x16(:,:,129))
  call Hloop_AQ_V(ntryL,G1H16(130),ex1(:),G1H8(130),m3h2x8(:,130),heltab2x16(:,:,130))
  call Hloop_AQ_Z(ntryL,G1H16(131),ex1(:),G1H8(131),ngZu,m3h2x8(:,131),heltab2x16(:,:,131))
  call Hloop_AQ_Z(ntryL,G1H16(132),ex1(:),G1H8(132),ngZu,m3h2x8(:,132),heltab2x16(:,:,132))
  call Hloop_AQ_V(ntryL,G1H16(133),ex1(:),G1H8(133),m3h2x8(:,133),heltab2x16(:,:,133))
  call Hloop_AQ_V(ntryL,G1H16(134),ex1(:),G1H8(134),m3h2x8(:,134),heltab2x16(:,:,134))
  call Hloop_AQ_Z(ntryL,G1H16(135),ex1(:),G1H8(135),ngZu,m3h2x8(:,135),heltab2x16(:,:,135))
  call Hloop_AQ_Z(ntryL,G1H16(136),ex1(:),G1H8(136),ngZu,m3h2x8(:,136),heltab2x16(:,:,136))
  call Hloop_SQ_A(ntryL,G1H8(1),ex1(:),G1H4(1),ngH,m3h2x4(:,1),heltab2x8(:,:,1))
  call Hloop_Q_A(ntryL,G1H4(1),21,nMT,G2H4(1),n2h4(1))
  call Hloop_SQ_A(ntryL,G1H8(2),ex1(:),G1H4(1),ngH,m3h2x4(:,2),heltab2x8(:,:,2))
  call Hloop_Q_A(ntryL,G1H4(1),21,nMT,G2H4(2),n2h4(2))
  call Hloop_SQ_A(ntryL,G1H8(3),ex1(:),G1H4(1),ngX,m3h2x4(:,3),heltab2x8(:,:,3))
  call Hloop_Q_A(ntryL,G1H4(1),21,nMT,G2H4(3),n2h4(3))
  call Hloop_SQ_A(ntryL,G1H8(4),ex1(:),G1H4(1),ngX,m3h2x4(:,4),heltab2x8(:,:,4))
  call Hloop_Q_A(ntryL,G1H4(1),21,nMT,G2H4(4),n2h4(4))
  call Hloop_SQ_A(ntryL,G1H8(5),ex1(:),G1H4(1),ngPbt,m3h2x4(:,5),heltab2x8(:,:,5))
  call Hloop_Q_A(ntryL,G1H4(1),21,nMB,G2H4(5),n2h4(5))
  call Hloop_SQ_A(ntryL,G1H8(6),ex1(:),G1H4(1),ngH,m3h2x4(:,6),heltab2x8(:,:,6))
  call Hloop_Q_A(ntryL,G1H4(1),21,nMT,G2H4(6),n2h4(6))
  call Hloop_SQ_A(ntryL,G1H8(7),ex1(:),G1H4(1),ngX,m3h2x4(:,7),heltab2x8(:,:,7))
  call Hloop_Q_A(ntryL,G1H4(1),21,nMT,G2H4(7),n2h4(7))
  call Hloop_SQ_A(ntryL,G1H8(8),ex1(:),G1H4(1),ngH,m3h2x4(:,8),heltab2x8(:,:,8))
  call Hloop_Q_A(ntryL,G1H4(1),21,nMT,G2H4(8),n2h4(8))
  call Hloop_SQ_A(ntryL,G1H8(9),ex1(:),G1H4(1),ngX,m3h2x4(:,9),heltab2x8(:,:,9))
  call Hloop_Q_A(ntryL,G1H4(1),21,nMT,G2H4(9),n2h4(9))
  call Hloop_SQ_A(ntryL,G1H8(10),ex1(:),G1H4(1),ngPbt,m3h2x4(:,10),heltab2x8(:,:,10))
  call Hloop_Q_A(ntryL,G1H4(1),21,nMB,G2H4(10),n2h4(10))
  call Hloop_VQ_A(ntryL,G1H8(11),ex1(:),G1H4(1),m3h2x4(:,11),heltab2x8(:,:,11))
  call Hloop_Q_A(ntryL,G1H4(1),21,nMT,G2H4(11),n2h4(11))
  call Hloop_VQ_A(ntryL,G1H8(12),ex1(:),G1H4(1),m3h2x4(:,12),heltab2x8(:,:,12))
  call Hloop_Q_A(ntryL,G1H4(1),21,nMT,G2H4(12),n2h4(12))
  call Hloop_ZQ_A(ntryL,G1H8(13),ex1(:),G1H4(1),ngZu,m3h2x4(:,13),heltab2x8(:,:,13))
  call Hloop_Q_A(ntryL,G1H4(1),21,nMT,G2H4(13),n2h4(13))
  call Hloop_ZQ_A(ntryL,G1H8(14),ex1(:),G1H4(1),ngZu,m3h2x4(:,14),heltab2x8(:,:,14))
  call Hloop_Q_A(ntryL,G1H4(1),21,nMT,G2H4(14),n2h4(14))
  call Hloop_WQ_A(ntryL,G1H8(15),ex1(:),G1H4(1),m3h2x4(:,15),heltab2x8(:,:,15))
  call Hloop_Q_A(ntryL,G1H4(1),21,nMB,G2H4(15),n2h4(15))
  call Hloop_VQ_A(ntryL,G1H8(16),ex1(:),G1H4(1),m3h2x4(:,16),heltab2x8(:,:,16))
  call Hloop_Q_A(ntryL,G1H4(1),21,nMT,G2H4(16),n2h4(16))
  call Hloop_VQ_A(ntryL,G1H8(17),ex1(:),G1H4(1),m3h2x4(:,17),heltab2x8(:,:,17))
  call Hloop_Q_A(ntryL,G1H4(1),21,nMT,G2H4(17),n2h4(17))
  call Hloop_ZQ_A(ntryL,G1H8(18),ex1(:),G1H4(1),ngZu,m3h2x4(:,18),heltab2x8(:,:,18))
  call Hloop_Q_A(ntryL,G1H4(1),21,nMT,G2H4(18),n2h4(18))
  call Hloop_ZQ_A(ntryL,G1H8(19),ex1(:),G1H4(1),ngZu,m3h2x4(:,19),heltab2x8(:,:,19))
  call Hloop_Q_A(ntryL,G1H4(1),21,nMT,G2H4(19),n2h4(19))
  call Hloop_WQ_A(ntryL,G1H8(20),ex1(:),G1H4(1),m3h2x4(:,20),heltab2x8(:,:,20))
  call Hloop_Q_A(ntryL,G1H4(1),21,nMB,G2H4(20),n2h4(20))
  call Hloop_SA_Q(ntryL,G1H8(21),ex2(:),G1H4(1),ngH,m3h2x4(:,21),heltab2x8(:,:,21))
  call Hloop_A_Q(ntryL,G1H4(1),22,nMT,G2H4(21),n2h4(21))
  call Hloop_SA_Q(ntryL,G1H8(22),ex2(:),G1H4(1),ngX,m3h2x4(:,22),heltab2x8(:,:,22))
  call Hloop_A_Q(ntryL,G1H4(1),22,nMT,G2H4(22),n2h4(22))
  call Hloop_SA_Q(ntryL,G1H8(23),ex2(:),G1H4(1),ngH,m3h2x4(:,23),heltab2x8(:,:,23))
  call Hloop_A_Q(ntryL,G1H4(1),22,nMT,G2H4(23),n2h4(23))
  call Hloop_SA_Q(ntryL,G1H8(24),ex2(:),G1H4(1),ngX,m3h2x4(:,24),heltab2x8(:,:,24))
  call Hloop_A_Q(ntryL,G1H4(1),22,nMT,G2H4(24),n2h4(24))
  call Hloop_VA_Q(ntryL,G1H8(25),ex2(:),G1H4(1),m3h2x4(:,25),heltab2x8(:,:,25))
  call Hloop_A_Q(ntryL,G1H4(1),22,nMT,G2H4(25),n2h4(25))
  call Hloop_VA_Q(ntryL,G1H8(26),ex2(:),G1H4(1),m3h2x4(:,26),heltab2x8(:,:,26))
  call Hloop_A_Q(ntryL,G1H4(1),22,nMT,G2H4(26),n2h4(26))
  call Hloop_ZA_Q(ntryL,G1H8(27),ex2(:),G1H4(1),ngZu,m3h2x4(:,27),heltab2x8(:,:,27))
  call Hloop_A_Q(ntryL,G1H4(1),22,nMT,G2H4(27),n2h4(27))
  call Hloop_ZA_Q(ntryL,G1H8(28),ex2(:),G1H4(1),ngZu,m3h2x4(:,28),heltab2x8(:,:,28))
  call Hloop_A_Q(ntryL,G1H4(1),22,nMT,G2H4(28),n2h4(28))
  call Hloop_SA_Q(ntryL,G1H8(29),ex2(:),G1H4(1),ngH,m3h2x4(:,29),heltab2x8(:,:,29))
  call Hloop_A_Q(ntryL,G1H4(1),22,nMT,G2H4(29),n2h4(29))
  call Hloop_SA_Q(ntryL,G1H8(30),ex2(:),G1H4(1),ngX,m3h2x4(:,30),heltab2x8(:,:,30))
  call Hloop_A_Q(ntryL,G1H4(1),22,nMT,G2H4(30),n2h4(30))
  call Hloop_SA_Q(ntryL,G1H8(31),ex2(:),G1H4(1),ngH,m3h2x4(:,31),heltab2x8(:,:,31))
  call Hloop_A_Q(ntryL,G1H4(1),22,nMT,G2H4(31),n2h4(31))
  call Hloop_SA_Q(ntryL,G1H8(32),ex2(:),G1H4(1),ngX,m3h2x4(:,32),heltab2x8(:,:,32))
  call Hloop_A_Q(ntryL,G1H4(1),22,nMT,G2H4(32),n2h4(32))
  call Hloop_VA_Q(ntryL,G1H8(33),ex2(:),G1H4(1),m3h2x4(:,33),heltab2x8(:,:,33))
  call Hloop_A_Q(ntryL,G1H4(1),22,nMT,G2H4(33),n2h4(33))
  call Hloop_ZA_Q(ntryL,G1H8(34),ex2(:),G1H4(1),ngZu,m3h2x4(:,34),heltab2x8(:,:,34))
  call Hloop_A_Q(ntryL,G1H4(1),22,nMT,G2H4(34),n2h4(34))
  call Hloop_VA_Q(ntryL,G1H8(35),ex2(:),G1H4(1),m3h2x4(:,35),heltab2x8(:,:,35))
  call Hloop_A_Q(ntryL,G1H4(1),22,nMT,G2H4(35),n2h4(35))
  call Hloop_ZA_Q(ntryL,G1H8(36),ex2(:),G1H4(1),ngZu,m3h2x4(:,36),heltab2x8(:,:,36))
  call Hloop_A_Q(ntryL,G1H4(1),22,nMT,G2H4(36),n2h4(36))
  call Hloop_SQ_A(ntryL,G1H8(37),ex1(:),G1H4(1),ngH,m3h2x4(:,37),heltab2x8(:,:,37))
  call Hloop_Q_A(ntryL,G1H4(1),19,nMT,G2H4(37),n2h4(37))
  call Hloop_SQ_A(ntryL,G1H8(38),ex1(:),G1H4(1),ngPbt,m3h2x4(:,38),heltab2x8(:,:,38))
  call Hloop_Q_A(ntryL,G1H4(1),19,nMB,G2H4(38),n2h4(38))
  call Hloop_SQ_A(ntryL,G1H8(39),ex1(:),G1H4(1),ngX,m3h2x4(:,39),heltab2x8(:,:,39))
  call Hloop_Q_A(ntryL,G1H4(1),19,nMT,G2H4(39),n2h4(39))
  call Hloop_SQ_A(ntryL,G1H8(40),ex1(:),G1H4(1),ngPbt,m3h2x4(:,40),heltab2x8(:,:,40))
  call Hloop_Q_A(ntryL,G1H4(1),19,nMB,G2H4(40),n2h4(40))
  call Hloop_SQ_A(ntryL,G1H8(41),ex1(:),G1H4(1),ngPbt,m3h2x4(:,41),heltab2x8(:,:,41))
  call Hloop_Q_A(ntryL,G1H4(1),19,nMB,G2H4(41),n2h4(41))
  call Hloop_SQ_A(ntryL,G1H8(42),ex1(:),G1H4(1),ngPbt,m3h2x4(:,42),heltab2x8(:,:,42))
  call Hloop_Q_A(ntryL,G1H4(1),19,nMB,G2H4(42),n2h4(42))
  call Hloop_SQ_A(ntryL,G1H8(43),ex1(:),G1H4(1),ngH,m3h2x4(:,43),heltab2x8(:,:,43))
  call Hloop_Q_A(ntryL,G1H4(1),19,nMT,G2H4(43),n2h4(43))
  call Hloop_SQ_A(ntryL,G1H8(44),ex1(:),G1H4(1),ngX,m3h2x4(:,44),heltab2x8(:,:,44))
  call Hloop_Q_A(ntryL,G1H4(1),19,nMT,G2H4(44),n2h4(44))
  call Hloop_VQ_A(ntryL,G1H8(45),ex1(:),G1H4(1),m3h2x4(:,45),heltab2x8(:,:,45))
  call Hloop_Q_A(ntryL,G1H4(1),19,nMT,G2H4(45),n2h4(45))
  call Hloop_ZQ_A(ntryL,G1H8(46),ex1(:),G1H4(1),ngZu,m3h2x4(:,46),heltab2x8(:,:,46))
  call Hloop_Q_A(ntryL,G1H4(1),19,nMT,G2H4(46),n2h4(46))
  call Hloop_WQ_A(ntryL,G1H8(47),ex1(:),G1H4(1),m3h2x4(:,47),heltab2x8(:,:,47))
  call Hloop_Q_A(ntryL,G1H4(1),19,nMB,G2H4(47),n2h4(47))
  call Hloop_WQ_A(ntryL,G1H8(48),ex1(:),G1H4(1),m3h2x4(:,48),heltab2x8(:,:,48))
  call Hloop_Q_A(ntryL,G1H4(1),19,nMB,G2H4(48),n2h4(48))
  call Hloop_VQ_A(ntryL,G1H8(49),ex1(:),G1H4(1),m3h2x4(:,49),heltab2x8(:,:,49))
  call Hloop_Q_A(ntryL,G1H4(1),19,nMT,G2H4(49),n2h4(49))
  call Hloop_WQ_A(ntryL,G1H8(50),ex1(:),G1H4(1),m3h2x4(:,50),heltab2x8(:,:,50))
  call Hloop_Q_A(ntryL,G1H4(1),19,nMB,G2H4(50),n2h4(50))
  call Hloop_ZQ_A(ntryL,G1H8(51),ex1(:),G1H4(1),ngZu,m3h2x4(:,51),heltab2x8(:,:,51))
  call Hloop_Q_A(ntryL,G1H4(1),19,nMT,G2H4(51),n2h4(51))
  call Hloop_WQ_A(ntryL,G1H8(52),ex1(:),G1H4(1),m3h2x4(:,52),heltab2x8(:,:,52))
  call Hloop_Q_A(ntryL,G1H4(1),19,nMB,G2H4(52),n2h4(52))
  call Hloop_SA_Q(ntryL,G1H8(53),ex2(:),G1H4(1),ngH,m3h2x4(:,53),heltab2x8(:,:,53))
  call Hloop_A_Q(ntryL,G1H4(1),19,nMT,G2H4(53),n2h4(53))
  call Hloop_SA_Q(ntryL,G1H8(54),ex2(:),G1H4(1),ngPtb,m3h2x4(:,54),heltab2x8(:,:,54))
  call Hloop_A_Q(ntryL,G1H4(1),19,nMB,G2H4(54),n2h4(54))
  call Hloop_SA_Q(ntryL,G1H8(55),ex2(:),G1H4(1),ngX,m3h2x4(:,55),heltab2x8(:,:,55))
  call Hloop_A_Q(ntryL,G1H4(1),19,nMT,G2H4(55),n2h4(55))
  call Hloop_SA_Q(ntryL,G1H8(56),ex2(:),G1H4(1),ngPtb,m3h2x4(:,56),heltab2x8(:,:,56))
  call Hloop_A_Q(ntryL,G1H4(1),19,nMB,G2H4(56),n2h4(56))
  call Hloop_SA_Q(ntryL,G1H8(57),ex2(:),G1H4(1),ngPtb,m3h2x4(:,57),heltab2x8(:,:,57))
  call Hloop_A_Q(ntryL,G1H4(1),19,nMB,G2H4(57),n2h4(57))
  call Hloop_SA_Q(ntryL,G1H8(58),ex2(:),G1H4(1),ngPtb,m3h2x4(:,58),heltab2x8(:,:,58))
  call Hloop_A_Q(ntryL,G1H4(1),19,nMB,G2H4(58),n2h4(58))
  call Hloop_SA_Q(ntryL,G1H8(59),ex2(:),G1H4(1),ngH,m3h2x4(:,59),heltab2x8(:,:,59))
  call Hloop_A_Q(ntryL,G1H4(1),19,nMT,G2H4(59),n2h4(59))
  call Hloop_SA_Q(ntryL,G1H8(60),ex2(:),G1H4(1),ngX,m3h2x4(:,60),heltab2x8(:,:,60))
  call Hloop_A_Q(ntryL,G1H4(1),19,nMT,G2H4(60),n2h4(60))
  call Hloop_VA_Q(ntryL,G1H8(61),ex2(:),G1H4(1),m3h2x4(:,61),heltab2x8(:,:,61))
  call Hloop_A_Q(ntryL,G1H4(1),19,nMT,G2H4(61),n2h4(61))
  call Hloop_ZA_Q(ntryL,G1H8(62),ex2(:),G1H4(1),ngZu,m3h2x4(:,62),heltab2x8(:,:,62))
  call Hloop_A_Q(ntryL,G1H4(1),19,nMT,G2H4(62),n2h4(62))
  call Hloop_WA_Q(ntryL,G1H8(63),ex2(:),G1H4(1),m3h2x4(:,63),heltab2x8(:,:,63))
  call Hloop_A_Q(ntryL,G1H4(1),19,nMB,G2H4(63),n2h4(63))
  call Hloop_WA_Q(ntryL,G1H8(64),ex2(:),G1H4(1),m3h2x4(:,64),heltab2x8(:,:,64))
  call Hloop_A_Q(ntryL,G1H4(1),19,nMB,G2H4(64),n2h4(64))
  call Hloop_VA_Q(ntryL,G1H8(65),ex2(:),G1H4(1),m3h2x4(:,65),heltab2x8(:,:,65))
  call Hloop_A_Q(ntryL,G1H4(1),19,nMT,G2H4(65),n2h4(65))
  call Hloop_WA_Q(ntryL,G1H8(66),ex2(:),G1H4(1),m3h2x4(:,66),heltab2x8(:,:,66))
  call Hloop_A_Q(ntryL,G1H4(1),19,nMB,G2H4(66),n2h4(66))
  call Hloop_ZA_Q(ntryL,G1H8(67),ex2(:),G1H4(1),ngZu,m3h2x4(:,67),heltab2x8(:,:,67))
  call Hloop_A_Q(ntryL,G1H4(1),19,nMT,G2H4(67),n2h4(67))
  call Hloop_WA_Q(ntryL,G1H8(68),ex2(:),G1H4(1),m3h2x4(:,68),heltab2x8(:,:,68))
  call Hloop_A_Q(ntryL,G1H4(1),19,nMB,G2H4(68),n2h4(68))
  call Hloop_SA_Q(ntryL,G1H8(69),ex4(:),G1H4(1),ngH,m3h2x4(:,69),heltab2x8(:,:,69))
  call Hloop_A_Q(ntryL,G1H4(1),26,nMB,G2H4(69),n2h4(69))
  call Hloop_SA_Q(ntryL,G1H8(70),ex4(:),G1H4(1),ngPbt,m3h2x4(:,70),heltab2x8(:,:,70))
  call Hloop_A_Q(ntryL,G1H4(1),26,nMT,G2H4(70),n2h4(70))
  call Hloop_SA_Q(ntryL,G1H8(71),ex4(:),G1H4(1),ngX,m3h2x4(:,71),heltab2x8(:,:,71))
  call Hloop_A_Q(ntryL,G1H4(1),26,nMB,G2H4(71),n2h4(71))
  call Hloop_SA_Q(ntryL,G1H8(72),ex4(:),G1H4(1),ngPbt,m3h2x4(:,72),heltab2x8(:,:,72))
  call Hloop_A_Q(ntryL,G1H4(1),26,nMT,G2H4(72),n2h4(72))
  call Hloop_VA_Q(ntryL,G1H8(73),ex4(:),G1H4(1),m3h2x4(:,73),heltab2x8(:,:,73))
  call Hloop_A_Q(ntryL,G1H4(1),26,nMB,G2H4(73),n2h4(73))
  call Hloop_ZA_Q(ntryL,G1H8(74),ex4(:),G1H4(1),ngZd,m3h2x4(:,74),heltab2x8(:,:,74))
  call Hloop_A_Q(ntryL,G1H4(1),26,nMB,G2H4(74),n2h4(74))
  call Hloop_WA_Q(ntryL,G1H8(75),ex4(:),G1H4(1),m3h2x4(:,75),heltab2x8(:,:,75))
  call Hloop_A_Q(ntryL,G1H4(1),26,nMT,G2H4(75),n2h4(75))
  call Hloop_WA_Q(ntryL,G1H8(76),ex4(:),G1H4(1),m3h2x4(:,76),heltab2x8(:,:,76))
  call Hloop_A_Q(ntryL,G1H4(1),26,nMT,G2H4(76),n2h4(76))
  call Hloop_SA_Q(ntryL,G1H8(77),ex4(:),G1H4(1),ngPbt,m3h2x4(:,77),heltab2x8(:,:,77))
  call Hloop_A_Q(ntryL,G1H4(1),26,nMT,G2H4(77),n2h4(77))
  call Hloop_SA_Q(ntryL,G1H8(78),ex4(:),G1H4(1),ngPbt,m3h2x4(:,78),heltab2x8(:,:,78))
  call Hloop_A_Q(ntryL,G1H4(1),26,nMT,G2H4(78),n2h4(78))
  call Hloop_SA_Q(ntryL,G1H8(79),ex4(:),G1H4(1),ngH,m3h2x4(:,79),heltab2x8(:,:,79))
  call Hloop_A_Q(ntryL,G1H4(1),26,nMB,G2H4(79),n2h4(79))
  call Hloop_SA_Q(ntryL,G1H8(80),ex4(:),G1H4(1),ngX,m3h2x4(:,80),heltab2x8(:,:,80))
  call Hloop_A_Q(ntryL,G1H4(1),26,nMB,G2H4(80),n2h4(80))
  call Hloop_VA_Q(ntryL,G1H8(81),ex4(:),G1H4(1),m3h2x4(:,81),heltab2x8(:,:,81))
  call Hloop_A_Q(ntryL,G1H4(1),26,nMB,G2H4(81),n2h4(81))
  call Hloop_WA_Q(ntryL,G1H8(82),ex4(:),G1H4(1),m3h2x4(:,82),heltab2x8(:,:,82))
  call Hloop_A_Q(ntryL,G1H4(1),26,nMT,G2H4(82),n2h4(82))
  call Hloop_ZA_Q(ntryL,G1H8(83),ex4(:),G1H4(1),ngZd,m3h2x4(:,83),heltab2x8(:,:,83))
  call Hloop_A_Q(ntryL,G1H4(1),26,nMB,G2H4(83),n2h4(83))
  call Hloop_WA_Q(ntryL,G1H8(84),ex4(:),G1H4(1),m3h2x4(:,84),heltab2x8(:,:,84))
  call Hloop_A_Q(ntryL,G1H4(1),26,nMT,G2H4(84),n2h4(84))
  call Hloop_SQ_A(ntryL,G1H8(85),ex3(:),G1H4(1),ngH,m3h2x4(:,85),heltab2x8(:,:,85))
  call Hloop_Q_A(ntryL,G1H4(1),21,nMB,G2H4(85),n2h4(85))
  call Hloop_SQ_A(ntryL,G1H8(86),ex3(:),G1H4(1),ngPtb,m3h2x4(:,86),heltab2x8(:,:,86))
  call Hloop_Q_A(ntryL,G1H4(1),21,nMT,G2H4(86),n2h4(86))
  call Hloop_SQ_A(ntryL,G1H8(87),ex3(:),G1H4(1),ngX,m3h2x4(:,87),heltab2x8(:,:,87))
  call Hloop_Q_A(ntryL,G1H4(1),21,nMB,G2H4(87),n2h4(87))
  call Hloop_SQ_A(ntryL,G1H8(88),ex3(:),G1H4(1),ngPtb,m3h2x4(:,88),heltab2x8(:,:,88))
  call Hloop_Q_A(ntryL,G1H4(1),21,nMT,G2H4(88),n2h4(88))
  call Hloop_SQ_A(ntryL,G1H8(89),ex3(:),G1H4(1),ngPtb,m3h2x4(:,89),heltab2x8(:,:,89))
  call Hloop_Q_A(ntryL,G1H4(1),21,nMT,G2H4(89),n2h4(89))
  call Hloop_SQ_A(ntryL,G1H8(90),ex3(:),G1H4(1),ngPtb,m3h2x4(:,90),heltab2x8(:,:,90))
  call Hloop_Q_A(ntryL,G1H4(1),21,nMT,G2H4(90),n2h4(90))
  call Hloop_SQ_A(ntryL,G1H8(91),ex3(:),G1H4(1),ngH,m3h2x4(:,91),heltab2x8(:,:,91))
  call Hloop_Q_A(ntryL,G1H4(1),21,nMB,G2H4(91),n2h4(91))
  call Hloop_SQ_A(ntryL,G1H8(92),ex3(:),G1H4(1),ngX,m3h2x4(:,92),heltab2x8(:,:,92))
  call Hloop_Q_A(ntryL,G1H4(1),21,nMB,G2H4(92),n2h4(92))
  call Hloop_VQ_A(ntryL,G1H8(93),ex3(:),G1H4(1),m3h2x4(:,93),heltab2x8(:,:,93))
  call Hloop_Q_A(ntryL,G1H4(1),21,nMB,G2H4(93),n2h4(93))
  call Hloop_ZQ_A(ntryL,G1H8(94),ex3(:),G1H4(1),ngZd,m3h2x4(:,94),heltab2x8(:,:,94))
  call Hloop_Q_A(ntryL,G1H4(1),21,nMB,G2H4(94),n2h4(94))
  call Hloop_WQ_A(ntryL,G1H8(95),ex3(:),G1H4(1),m3h2x4(:,95),heltab2x8(:,:,95))
  call Hloop_Q_A(ntryL,G1H4(1),21,nMT,G2H4(95),n2h4(95))
  call Hloop_WQ_A(ntryL,G1H8(96),ex3(:),G1H4(1),m3h2x4(:,96),heltab2x8(:,:,96))
  call Hloop_Q_A(ntryL,G1H4(1),21,nMT,G2H4(96),n2h4(96))
  call Hloop_VQ_A(ntryL,G1H8(97),ex3(:),G1H4(1),m3h2x4(:,97),heltab2x8(:,:,97))
  call Hloop_Q_A(ntryL,G1H4(1),21,nMB,G2H4(97),n2h4(97))
  call Hloop_WQ_A(ntryL,G1H8(98),ex3(:),G1H4(1),m3h2x4(:,98),heltab2x8(:,:,98))
  call Hloop_Q_A(ntryL,G1H4(1),21,nMT,G2H4(98),n2h4(98))
  call Hloop_ZQ_A(ntryL,G1H8(99),ex3(:),G1H4(1),ngZd,m3h2x4(:,99),heltab2x8(:,:,99))
  call Hloop_Q_A(ntryL,G1H4(1),21,nMB,G2H4(99),n2h4(99))
  call Hloop_WQ_A(ntryL,G1H8(100),ex3(:),G1H4(1),m3h2x4(:,100),heltab2x8(:,:,100))
  call Hloop_Q_A(ntryL,G1H4(1),21,nMT,G2H4(100),n2h4(100))
  call Hloop_SQ_A(ntryL,G1H8(101),ex3(:),G1H4(1),ngH,m3h2x4(:,101),heltab2x8(:,:,101))
  call Hloop_Q_A(ntryL,G1H4(1),21,nMB,G2H4(101),n2h4(101))
  call Hloop_SQ_A(ntryL,G1H8(102),ex3(:),G1H4(1),ngH,m3h2x4(:,102),heltab2x8(:,:,102))
  call Hloop_Q_A(ntryL,G1H4(1),21,nMB,G2H4(102),n2h4(102))
  call Hloop_SQ_A(ntryL,G1H8(103),ex3(:),G1H4(1),ngX,m3h2x4(:,103),heltab2x8(:,:,103))
  call Hloop_Q_A(ntryL,G1H4(1),21,nMB,G2H4(103),n2h4(103))
  call Hloop_SQ_A(ntryL,G1H8(104),ex3(:),G1H4(1),ngX,m3h2x4(:,104),heltab2x8(:,:,104))
  call Hloop_Q_A(ntryL,G1H4(1),21,nMB,G2H4(104),n2h4(104))
  call Hloop_SQ_A(ntryL,G1H8(105),ex3(:),G1H4(1),ngPtb,m3h2x4(:,105),heltab2x8(:,:,105))
  call Hloop_Q_A(ntryL,G1H4(1),21,nMT,G2H4(105),n2h4(105))
  call Hloop_SQ_A(ntryL,G1H8(106),ex3(:),G1H4(1),ngH,m3h2x4(:,106),heltab2x8(:,:,106))
  call Hloop_Q_A(ntryL,G1H4(1),21,nMB,G2H4(106),n2h4(106))
  call Hloop_SQ_A(ntryL,G1H8(107),ex3(:),G1H4(1),ngX,m3h2x4(:,107),heltab2x8(:,:,107))
  call Hloop_Q_A(ntryL,G1H4(1),21,nMB,G2H4(107),n2h4(107))
  call Hloop_SQ_A(ntryL,G1H8(108),ex3(:),G1H4(1),ngH,m3h2x4(:,108),heltab2x8(:,:,108))
  call Hloop_Q_A(ntryL,G1H4(1),21,nMB,G2H4(108),n2h4(108))
  call Hloop_SQ_A(ntryL,G1H8(109),ex3(:),G1H4(1),ngX,m3h2x4(:,109),heltab2x8(:,:,109))
  call Hloop_Q_A(ntryL,G1H4(1),21,nMB,G2H4(109),n2h4(109))
  call Hloop_SQ_A(ntryL,G1H8(110),ex3(:),G1H4(1),ngPtb,m3h2x4(:,110),heltab2x8(:,:,110))
  call Hloop_Q_A(ntryL,G1H4(1),21,nMT,G2H4(110),n2h4(110))
  call Hloop_VQ_A(ntryL,G1H8(111),ex3(:),G1H4(1),m3h2x4(:,111),heltab2x8(:,:,111))
  call Hloop_Q_A(ntryL,G1H4(1),21,nMB,G2H4(111),n2h4(111))
  call Hloop_VQ_A(ntryL,G1H8(112),ex3(:),G1H4(1),m3h2x4(:,112),heltab2x8(:,:,112))
  call Hloop_Q_A(ntryL,G1H4(1),21,nMB,G2H4(112),n2h4(112))
  call Hloop_ZQ_A(ntryL,G1H8(113),ex3(:),G1H4(1),ngZd,m3h2x4(:,113),heltab2x8(:,:,113))
  call Hloop_Q_A(ntryL,G1H4(1),21,nMB,G2H4(113),n2h4(113))
  call Hloop_ZQ_A(ntryL,G1H8(114),ex3(:),G1H4(1),ngZd,m3h2x4(:,114),heltab2x8(:,:,114))
  call Hloop_Q_A(ntryL,G1H4(1),21,nMB,G2H4(114),n2h4(114))
  call Hloop_WQ_A(ntryL,G1H8(115),ex3(:),G1H4(1),m3h2x4(:,115),heltab2x8(:,:,115))
  call Hloop_Q_A(ntryL,G1H4(1),21,nMT,G2H4(115),n2h4(115))
  call Hloop_VQ_A(ntryL,G1H8(116),ex3(:),G1H4(1),m3h2x4(:,116),heltab2x8(:,:,116))
  call Hloop_Q_A(ntryL,G1H4(1),21,nMB,G2H4(116),n2h4(116))
  call Hloop_VQ_A(ntryL,G1H8(117),ex3(:),G1H4(1),m3h2x4(:,117),heltab2x8(:,:,117))
  call Hloop_Q_A(ntryL,G1H4(1),21,nMB,G2H4(117),n2h4(117))
  call Hloop_ZQ_A(ntryL,G1H8(118),ex3(:),G1H4(1),ngZd,m3h2x4(:,118),heltab2x8(:,:,118))
  call Hloop_Q_A(ntryL,G1H4(1),21,nMB,G2H4(118),n2h4(118))
  call Hloop_ZQ_A(ntryL,G1H8(119),ex3(:),G1H4(1),ngZd,m3h2x4(:,119),heltab2x8(:,:,119))
  call Hloop_Q_A(ntryL,G1H4(1),21,nMB,G2H4(119),n2h4(119))
  call Hloop_WQ_A(ntryL,G1H8(120),ex3(:),G1H4(1),m3h2x4(:,120),heltab2x8(:,:,120))
  call Hloop_Q_A(ntryL,G1H4(1),21,nMT,G2H4(120),n2h4(120))
  call Hloop_SA_Q(ntryL,G1H8(121),ex4(:),G1H4(1),ngH,m3h2x4(:,121),heltab2x8(:,:,121))
  call Hloop_A_Q(ntryL,G1H4(1),25,nMB,G2H4(121),n2h4(121))
  call Hloop_SA_Q(ntryL,G1H8(122),ex4(:),G1H4(1),ngH,m3h2x4(:,122),heltab2x8(:,:,122))
  call Hloop_A_Q(ntryL,G1H4(1),25,nMB,G2H4(122),n2h4(122))
  call Hloop_SA_Q(ntryL,G1H8(123),ex4(:),G1H4(1),ngX,m3h2x4(:,123),heltab2x8(:,:,123))
  call Hloop_A_Q(ntryL,G1H4(1),25,nMB,G2H4(123),n2h4(123))
  call Hloop_SA_Q(ntryL,G1H8(124),ex4(:),G1H4(1),ngX,m3h2x4(:,124),heltab2x8(:,:,124))
  call Hloop_A_Q(ntryL,G1H4(1),25,nMB,G2H4(124),n2h4(124))
  call Hloop_SA_Q(ntryL,G1H8(125),ex4(:),G1H4(1),ngH,m3h2x4(:,125),heltab2x8(:,:,125))
  call Hloop_A_Q(ntryL,G1H4(1),25,nMB,G2H4(125),n2h4(125))
  call Hloop_SA_Q(ntryL,G1H8(126),ex4(:),G1H4(1),ngX,m3h2x4(:,126),heltab2x8(:,:,126))
  call Hloop_A_Q(ntryL,G1H4(1),25,nMB,G2H4(126),n2h4(126))
  call Hloop_SA_Q(ntryL,G1H8(127),ex4(:),G1H4(1),ngH,m3h2x4(:,127),heltab2x8(:,:,127))
  call Hloop_A_Q(ntryL,G1H4(1),25,nMB,G2H4(127),n2h4(127))
  call Hloop_SA_Q(ntryL,G1H8(128),ex4(:),G1H4(1),ngX,m3h2x4(:,128),heltab2x8(:,:,128))
  call Hloop_A_Q(ntryL,G1H4(1),25,nMB,G2H4(128),n2h4(128))
  call Hloop_VA_Q(ntryL,G1H8(129),ex4(:),G1H4(1),m3h2x4(:,129),heltab2x8(:,:,129))
  call Hloop_A_Q(ntryL,G1H4(1),25,nMB,G2H4(129),n2h4(129))
  call Hloop_VA_Q(ntryL,G1H8(130),ex4(:),G1H4(1),m3h2x4(:,130),heltab2x8(:,:,130))
  call Hloop_A_Q(ntryL,G1H4(1),25,nMB,G2H4(130),n2h4(130))
  call Hloop_ZA_Q(ntryL,G1H8(131),ex4(:),G1H4(1),ngZd,m3h2x4(:,131),heltab2x8(:,:,131))
  call Hloop_A_Q(ntryL,G1H4(1),25,nMB,G2H4(131),n2h4(131))
  call Hloop_ZA_Q(ntryL,G1H8(132),ex4(:),G1H4(1),ngZd,m3h2x4(:,132),heltab2x8(:,:,132))
  call Hloop_A_Q(ntryL,G1H4(1),25,nMB,G2H4(132),n2h4(132))
  call Hloop_VA_Q(ntryL,G1H8(133),ex4(:),G1H4(1),m3h2x4(:,133),heltab2x8(:,:,133))
  call Hloop_A_Q(ntryL,G1H4(1),25,nMB,G2H4(133),n2h4(133))
  call Hloop_VA_Q(ntryL,G1H8(134),ex4(:),G1H4(1),m3h2x4(:,134),heltab2x8(:,:,134))
  call Hloop_A_Q(ntryL,G1H4(1),25,nMB,G2H4(134),n2h4(134))
  call Hloop_ZA_Q(ntryL,G1H8(135),ex4(:),G1H4(1),ngZd,m3h2x4(:,135),heltab2x8(:,:,135))
  call Hloop_A_Q(ntryL,G1H4(1),25,nMB,G2H4(135),n2h4(135))
  call Hloop_ZA_Q(ntryL,G1H8(136),ex4(:),G1H4(1),ngZd,m3h2x4(:,136),heltab2x8(:,:,136))
  call Hloop_A_Q(ntryL,G1H4(1),25,nMB,G2H4(136),n2h4(136))
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(13),[G2H4(3)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(14),[G2H4(4)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(15),[G2H4(5)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(18),[G2H4(7)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(19),[G2H4(9)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(20),[G2H4(10)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(27),[G2H4(22)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(28),[G2H4(24)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(34),[G2H4(30)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(36),[G2H4(32)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(47),[G2H4(38)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(46),[G2H4(39)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(48),[G2H4(40)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(50),[G2H4(41)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(52),[G2H4(42)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(51),[G2H4(44)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(63),[G2H4(54)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(62),[G2H4(55)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(64),[G2H4(56)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(66),[G2H4(57)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(68),[G2H4(58)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(67),[G2H4(60)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(75),[G2H4(70)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(74),[G2H4(71)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(76),[G2H4(72)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(82),[G2H4(77)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(84),[G2H4(78)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(83),[G2H4(80)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(95),[G2H4(86)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(94),[G2H4(87)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(96),[G2H4(88)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(98),[G2H4(89)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(100),[G2H4(90)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(99),[G2H4(92)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(113),[G2H4(103)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(114),[G2H4(104)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(115),[G2H4(105)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(118),[G2H4(107)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(119),[G2H4(109)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(120),[G2H4(110)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(131),[G2H4(123)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(132),[G2H4(124)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(135),[G2H4(126)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(136),[G2H4(128)])
  call Hloop_QA_S(ntryL,G2H4(1),ex2(:),G2H2(1),ngH,m3h2x2(:,1),heltab2x4(:,:,1))
  call Hloop_QA_S(ntryL,G2H4(2),ex2(:),G2H2(2),ngX,m3h2x2(:,2),heltab2x4(:,:,2))
  call Hloop_QA_S(ntryL,G2H4(13),ex2(:),G2H2(3),ngH,m3h2x2(:,3),heltab2x4(:,:,3))
  call Hloop_QA_S(ntryL,G2H4(14),ex2(:),G2H2(4),ngX,m3h2x2(:,4),heltab2x4(:,:,4))
  call Hloop_QA_S(ntryL,G2H4(15),ex2(:),G2H2(5),ngPtb,m3h2x2(:,5),heltab2x4(:,:,5))
  call Hloop_QA_V(ntryL,G2H4(6),ex2(:),G2H2(6),m3h2x2(:,6),heltab2x4(:,:,6))
  call Hloop_QA_V(ntryL,G2H4(18),ex2(:),G2H2(7),m3h2x2(:,7),heltab2x4(:,:,7))
  call Hloop_QA_Z(ntryL,G2H4(8),ex2(:),G2H2(8),ngZu,m3h2x2(:,8),heltab2x4(:,:,8))
  call Hloop_QA_Z(ntryL,G2H4(19),ex2(:),G2H2(9),ngZu,m3h2x2(:,9),heltab2x4(:,:,9))
  call Hloop_QA_W(ntryL,G2H4(20),ex2(:),G2H2(10),m3h2x2(:,10),heltab2x4(:,:,10))
  call Hloop_QA_S(ntryL,G2H4(11),ex2(:),G2H2(11),ngH,m3h2x2(:,11),heltab2x4(:,:,11))
  call Hloop_QA_S(ntryL,G2H4(12),ex2(:),G2H2(12),ngX,m3h2x2(:,12),heltab2x4(:,:,12))
  call Hloop_QA_V(ntryL,G2H4(16),ex2(:),G2H2(13),m3h2x2(:,13),heltab2x4(:,:,13))
  call Hloop_QA_Z(ntryL,G2H4(17),ex2(:),G2H2(14),ngZu,m3h2x2(:,14),heltab2x4(:,:,14))
  call Hloop_AQ_S(ntryL,G2H4(21),ex1(:),G2H2(15),ngH,m3h2x2(:,15),heltab2x4(:,:,15))
  call Hloop_AQ_S(ntryL,G2H4(27),ex1(:),G2H2(16),ngH,m3h2x2(:,16),heltab2x4(:,:,16))
  call Hloop_AQ_S(ntryL,G2H4(23),ex1(:),G2H2(17),ngX,m3h2x2(:,17),heltab2x4(:,:,17))
  call Hloop_AQ_S(ntryL,G2H4(28),ex1(:),G2H2(18),ngX,m3h2x2(:,18),heltab2x4(:,:,18))
  call Hloop_AQ_S(ntryL,G2H4(25),ex1(:),G2H2(19),ngH,m3h2x2(:,19),heltab2x4(:,:,19))
  call Hloop_AQ_S(ntryL,G2H4(26),ex1(:),G2H2(20),ngX,m3h2x2(:,20),heltab2x4(:,:,20))
  call Hloop_AQ_V(ntryL,G2H4(29),ex1(:),G2H2(21),m3h2x2(:,21),heltab2x4(:,:,21))
  call Hloop_AQ_V(ntryL,G2H4(34),ex1(:),G2H2(22),m3h2x2(:,22),heltab2x4(:,:,22))
  call Hloop_AQ_Z(ntryL,G2H4(31),ex1(:),G2H2(23),ngZu,m3h2x2(:,23),heltab2x4(:,:,23))
  call Hloop_AQ_Z(ntryL,G2H4(36),ex1(:),G2H2(24),ngZu,m3h2x2(:,24),heltab2x4(:,:,24))
  call Hloop_AQ_V(ntryL,G2H4(33),ex1(:),G2H2(25),m3h2x2(:,25),heltab2x4(:,:,25))
  call Hloop_AQ_Z(ntryL,G2H4(35),ex1(:),G2H2(26),ngZu,m3h2x2(:,26),heltab2x4(:,:,26))
  call Hloop_QA_S(ntryL,G2H4(37),ex4(:),G2H2(27),ngPbt,m3h2x2(:,27),heltab2x4(:,:,27))
  call Hloop_QA_S(ntryL,G2H4(47),ex4(:),G2H2(28),ngH,m3h2x2(:,28),heltab2x4(:,:,28))
  call Hloop_QA_S(ntryL,G2H4(46),ex4(:),G2H2(29),ngPbt,m3h2x2(:,29),heltab2x4(:,:,29))
  call Hloop_QA_S(ntryL,G2H4(48),ex4(:),G2H2(30),ngX,m3h2x2(:,30),heltab2x4(:,:,30))
  call Hloop_QA_V(ntryL,G2H4(50),ex4(:),G2H2(31),m3h2x2(:,31),heltab2x4(:,:,31))
  call Hloop_QA_Z(ntryL,G2H4(52),ex4(:),G2H2(32),ngZd,m3h2x2(:,32),heltab2x4(:,:,32))
  call Hloop_QA_W(ntryL,G2H4(43),ex4(:),G2H2(33),m3h2x2(:,33),heltab2x4(:,:,33))
  call Hloop_QA_W(ntryL,G2H4(51),ex4(:),G2H2(34),m3h2x2(:,34),heltab2x4(:,:,34))
  call Hloop_QA_S(ntryL,G2H4(45),ex4(:),G2H2(35),ngPbt,m3h2x2(:,35),heltab2x4(:,:,35))
  call Hloop_QA_W(ntryL,G2H4(49),ex4(:),G2H2(36),m3h2x2(:,36),heltab2x4(:,:,36))
  call Hloop_AQ_S(ntryL,G2H4(53),ex3(:),G2H2(37),ngPtb,m3h2x2(:,37),heltab2x4(:,:,37))
  call Hloop_AQ_S(ntryL,G2H4(63),ex3(:),G2H2(38),ngH,m3h2x2(:,38),heltab2x4(:,:,38))
  call Hloop_AQ_S(ntryL,G2H4(62),ex3(:),G2H2(39),ngPtb,m3h2x2(:,39),heltab2x4(:,:,39))
  call Hloop_AQ_S(ntryL,G2H4(64),ex3(:),G2H2(40),ngX,m3h2x2(:,40),heltab2x4(:,:,40))
  call Hloop_AQ_V(ntryL,G2H4(66),ex3(:),G2H2(41),m3h2x2(:,41),heltab2x4(:,:,41))
  call Hloop_AQ_Z(ntryL,G2H4(68),ex3(:),G2H2(42),ngZd,m3h2x2(:,42),heltab2x4(:,:,42))
  call Hloop_AQ_W(ntryL,G2H4(59),ex3(:),G2H2(43),m3h2x2(:,43),heltab2x4(:,:,43))
  call Hloop_AQ_W(ntryL,G2H4(67),ex3(:),G2H2(44),m3h2x2(:,44),heltab2x4(:,:,44))
  call Hloop_AQ_S(ntryL,G2H4(61),ex3(:),G2H2(45),ngPtb,m3h2x2(:,45),heltab2x4(:,:,45))
  call Hloop_AQ_W(ntryL,G2H4(65),ex3(:),G2H2(46),m3h2x2(:,46),heltab2x4(:,:,46))
  call Hloop_AQ_S(ntryL,G2H4(69),ex1(:),G2H2(47),ngPbt,m3h2x2(:,47),heltab2x4(:,:,47))
  call Hloop_AQ_S(ntryL,G2H4(75),ex1(:),G2H2(48),ngH,m3h2x2(:,48),heltab2x4(:,:,48))
  call Hloop_AQ_S(ntryL,G2H4(74),ex1(:),G2H2(49),ngPbt,m3h2x2(:,49),heltab2x4(:,:,49))
  call Hloop_AQ_S(ntryL,G2H4(76),ex1(:),G2H2(50),ngX,m3h2x2(:,50),heltab2x4(:,:,50))
  call Hloop_AQ_S(ntryL,G2H4(73),ex1(:),G2H2(51),ngPbt,m3h2x2(:,51),heltab2x4(:,:,51))
  call Hloop_AQ_V(ntryL,G2H4(82),ex1(:),G2H2(52),m3h2x2(:,52),heltab2x4(:,:,52))
  call Hloop_AQ_Z(ntryL,G2H4(84),ex1(:),G2H2(53),ngZu,m3h2x2(:,53),heltab2x4(:,:,53))
  call Hloop_AQ_W(ntryL,G2H4(79),ex1(:),G2H2(54),m3h2x2(:,54),heltab2x4(:,:,54))
  call Hloop_AQ_W(ntryL,G2H4(83),ex1(:),G2H2(55),m3h2x2(:,55),heltab2x4(:,:,55))
  call Hloop_AQ_W(ntryL,G2H4(81),ex1(:),G2H2(56),m3h2x2(:,56),heltab2x4(:,:,56))
  call Hloop_QA_S(ntryL,G2H4(85),ex2(:),G2H2(57),ngPtb,m3h2x2(:,57),heltab2x4(:,:,57))
  call Hloop_QA_S(ntryL,G2H4(95),ex2(:),G2H2(58),ngH,m3h2x2(:,58),heltab2x4(:,:,58))
  call Hloop_QA_S(ntryL,G2H4(94),ex2(:),G2H2(59),ngPtb,m3h2x2(:,59),heltab2x4(:,:,59))
  call Hloop_QA_S(ntryL,G2H4(96),ex2(:),G2H2(60),ngX,m3h2x2(:,60),heltab2x4(:,:,60))
  call Hloop_QA_V(ntryL,G2H4(98),ex2(:),G2H2(61),m3h2x2(:,61),heltab2x4(:,:,61))
  call Hloop_QA_Z(ntryL,G2H4(100),ex2(:),G2H2(62),ngZu,m3h2x2(:,62),heltab2x4(:,:,62))
  call Hloop_QA_W(ntryL,G2H4(91),ex2(:),G2H2(63),m3h2x2(:,63),heltab2x4(:,:,63))
  call Hloop_QA_W(ntryL,G2H4(99),ex2(:),G2H2(64),m3h2x2(:,64),heltab2x4(:,:,64))
  call Hloop_QA_S(ntryL,G2H4(93),ex2(:),G2H2(65),ngPtb,m3h2x2(:,65),heltab2x4(:,:,65))
  call Hloop_QA_W(ntryL,G2H4(97),ex2(:),G2H2(66),m3h2x2(:,66),heltab2x4(:,:,66))
  call Hloop_QA_S(ntryL,G2H4(101),ex4(:),G2H2(67),ngH,m3h2x2(:,67),heltab2x4(:,:,67))
  call Hloop_QA_S(ntryL,G2H4(102),ex4(:),G2H2(68),ngX,m3h2x2(:,68),heltab2x4(:,:,68))
  call Hloop_QA_S(ntryL,G2H4(113),ex4(:),G2H2(69),ngH,m3h2x2(:,69),heltab2x4(:,:,69))
  call Hloop_QA_S(ntryL,G2H4(114),ex4(:),G2H2(70),ngX,m3h2x2(:,70),heltab2x4(:,:,70))
  call Hloop_QA_S(ntryL,G2H4(115),ex4(:),G2H2(71),ngPbt,m3h2x2(:,71),heltab2x4(:,:,71))
  call Hloop_QA_V(ntryL,G2H4(106),ex4(:),G2H2(72),m3h2x2(:,72),heltab2x4(:,:,72))
  call Hloop_QA_V(ntryL,G2H4(118),ex4(:),G2H2(73),m3h2x2(:,73),heltab2x4(:,:,73))
  call Hloop_QA_Z(ntryL,G2H4(108),ex4(:),G2H2(74),ngZd,m3h2x2(:,74),heltab2x4(:,:,74))
  call Hloop_QA_Z(ntryL,G2H4(119),ex4(:),G2H2(75),ngZd,m3h2x2(:,75),heltab2x4(:,:,75))
  call Hloop_QA_W(ntryL,G2H4(120),ex4(:),G2H2(76),m3h2x2(:,76),heltab2x4(:,:,76))
  call Hloop_QA_S(ntryL,G2H4(111),ex4(:),G2H2(77),ngH,m3h2x2(:,77),heltab2x4(:,:,77))
  call Hloop_QA_S(ntryL,G2H4(112),ex4(:),G2H2(78),ngX,m3h2x2(:,78),heltab2x4(:,:,78))
  call Hloop_QA_V(ntryL,G2H4(116),ex4(:),G2H2(79),m3h2x2(:,79),heltab2x4(:,:,79))
  call Hloop_QA_Z(ntryL,G2H4(117),ex4(:),G2H2(80),ngZd,m3h2x2(:,80),heltab2x4(:,:,80))
  call Hloop_AQ_S(ntryL,G2H4(121),ex3(:),G2H2(81),ngH,m3h2x2(:,81),heltab2x4(:,:,81))
  call Hloop_AQ_S(ntryL,G2H4(122),ex3(:),G2H2(82),ngX,m3h2x2(:,82),heltab2x4(:,:,82))
  call Hloop_AQ_S(ntryL,G2H4(131),ex3(:),G2H2(83),ngH,m3h2x2(:,83),heltab2x4(:,:,83))
  call Hloop_AQ_S(ntryL,G2H4(132),ex3(:),G2H2(84),ngX,m3h2x2(:,84),heltab2x4(:,:,84))
  call Hloop_AQ_V(ntryL,G2H4(125),ex3(:),G2H2(85),m3h2x2(:,85),heltab2x4(:,:,85))
  call Hloop_AQ_V(ntryL,G2H4(135),ex3(:),G2H2(86),m3h2x2(:,86),heltab2x4(:,:,86))
  call Hloop_AQ_Z(ntryL,G2H4(127),ex3(:),G2H2(87),ngZd,m3h2x2(:,87),heltab2x4(:,:,87))
  call Hloop_AQ_Z(ntryL,G2H4(136),ex3(:),G2H2(88),ngZd,m3h2x2(:,88),heltab2x4(:,:,88))
  call Hloop_AQ_S(ntryL,G2H4(129),ex3(:),G2H2(89),ngH,m3h2x2(:,89),heltab2x4(:,:,89))
  call Hloop_AQ_S(ntryL,G2H4(130),ex3(:),G2H2(90),ngX,m3h2x2(:,90),heltab2x4(:,:,90))
  call Hloop_AQ_V(ntryL,G2H4(133),ex3(:),G2H2(91),m3h2x2(:,91),heltab2x4(:,:,91))
  call Hloop_AQ_Z(ntryL,G2H4(134),ex3(:),G2H2(92),ngZd,m3h2x2(:,92),heltab2x4(:,:,92))
  call Hotf_5pt_reduction(G2H2(1),RedSet_5(1),mass5set(:,1),  & 
G1H2(1),G1H2(2),G1H2(3),G1H2(4),G1H2(5),G1H2(6),2)
  call HG1shiftOLR(G1H2(2),8,2)
  call Hotf_5pt_reduction(G2H2(2),RedSet_5(1),mass5set(:,2),  & 
G1H2(7),G1H2(8),G1H2(9),G1H2(10),G1H2(11),G1H2(12),2)
  call HG1shiftOLR(G1H2(8),8,2)
  call Hotf_5pt_reduction(G2H2(3),RedSet_5(1),mass5set(:,3),  & 
G1H2(13),G1H2(14),G1H2(15),G1H2(16),G1H2(17),G1H2(18),2)
  call HG1shiftOLR(G1H2(14),8,2)
  call Hotf_5pt_reduction(G2H2(4),RedSet_5(1),mass5set(:,4),  & 
G1H2(19),G1H2(20),G1H2(21),G1H2(22),G1H2(23),G1H2(24),2)
  call HG1shiftOLR(G1H2(20),8,2)
  call Hotf_5pt_reduction(G2H2(5),RedSet_5(1),mass5set(:,5),  & 
G1H2(25),G1H2(26),G1H2(27),G1H2(28),G1H2(29),G1H2(30),2)
  call HG1shiftOLR(G1H2(26),8,2)
  call Hotf_5pt_reduction(G2H2(6),RedSet_5(1),mass5set(:,6),  & 
G1H2(31),G1H2(32),G1H2(33),G1H2(34),G1H2(35),G1H2(36),2)
  call HG1shiftOLR(G1H2(32),8,2)
  call Hotf_5pt_reduction(G2H2(7),RedSet_5(1),mass5set(:,7),  & 
G1H2(37),G1H2(38),G1H2(39),G1H2(40),G1H2(41),G1H2(42),2)
  call HG1shiftOLR(G1H2(38),8,2)
  call Hotf_5pt_reduction(G2H2(8),RedSet_5(1),mass5set(:,2),  & 
G1H2(43),G1H2(44),G1H2(45),G1H2(46),G1H2(47),G1H2(48),2)
  call HG1shiftOLR(G1H2(44),8,2)
  call Hotf_5pt_reduction(G2H2(9),RedSet_5(1),mass5set(:,4),  & 
G1H2(49),G1H2(50),G1H2(51),G1H2(52),G1H2(53),G1H2(54),2)
  call HG1shiftOLR(G1H2(50),8,2)
  call Hotf_5pt_reduction(G2H2(10),RedSet_5(1),mass5set(:,5),  & 
G1H2(55),G1H2(56),G1H2(57),G1H2(58),G1H2(59),G1H2(60),2)
  call HG1shiftOLR(G1H2(56),8,2)
  call Hotf_5pt_reduction(G2H2(11),RedSet_5(1),mass5set(:,8),  & 
G1H2(61),G1H2(62),G1H2(63),G1H2(64),G1H2(65),G1H2(66),2)
  call HG1shiftOLR(G1H2(62),8,2)
  call Hotf_5pt_reduction(G2H2(12),RedSet_5(1),mass5set(:,9),  & 
G1H2(67),G1H2(68),G1H2(69),G1H2(70),G1H2(71),G1H2(72),2)
  call HG1shiftOLR(G1H2(68),8,2)
  call Hotf_5pt_reduction(G2H2(13),RedSet_5(1),mass5set(:,10),  & 
G1H2(73),G1H2(74),G1H2(75),G1H2(76),G1H2(77),G1H2(78),2)
  call HG1shiftOLR(G1H2(74),8,2)
  call Hotf_5pt_reduction(G2H2(14),RedSet_5(1),mass5set(:,9),  & 
G1H2(79),G1H2(80),G1H2(81),G1H2(82),G1H2(83),G1H2(84),2)
  call HG1shiftOLR(G1H2(80),8,2)
  call Hotf_5pt_reduction(G2H2(15),RedSet_5(2),mass5set(:,1),  & 
G1H2(85),G1H2(86),G1H2(87),G1H2(88),G1H2(89),G1H2(90),2)
  call HG1shiftOLR(G1H2(86),8,2)
  call Hotf_5pt_reduction(G2H2(16),RedSet_5(2),mass5set(:,3),  & 
G1H2(91),G1H2(92),G1H2(93),G1H2(94),G1H2(95),G1H2(96),2)
  call HG1shiftOLR(G1H2(92),8,2)
  call Hotf_5pt_reduction(G2H2(17),RedSet_5(2),mass5set(:,2),  & 
G1H2(97),G1H2(98),G1H2(99),G1H2(100),G1H2(101),G1H2(102),2)
  call HG1shiftOLR(G1H2(98),8,2)
  call Hotf_5pt_reduction(G2H2(18),RedSet_5(2),mass5set(:,4),  & 
G1H2(103),G1H2(104),G1H2(105),G1H2(106),G1H2(107),G1H2(108),2)
  call HG1shiftOLR(G1H2(104),8,2)
  call Hotf_5pt_reduction(G2H2(19),RedSet_5(2),mass5set(:,8),  & 
G1H2(109),G1H2(110),G1H2(111),G1H2(112),G1H2(113),G1H2(114),2)
  call HG1shiftOLR(G1H2(110),8,2)
  call Hotf_5pt_reduction(G2H2(20),RedSet_5(2),mass5set(:,9),  & 
G1H2(115),G1H2(116),G1H2(117),G1H2(118),G1H2(119),G1H2(120),2)
  call HG1shiftOLR(G1H2(116),8,2)
  call Hotf_5pt_reduction(G2H2(21),RedSet_5(2),mass5set(:,6),  & 
G1H2(121),G1H2(122),G1H2(123),G1H2(124),G1H2(125),G1H2(126),2)
  call HG1shiftOLR(G1H2(122),8,2)
  call Hotf_5pt_reduction(G2H2(22),RedSet_5(2),mass5set(:,7),  & 
G1H2(127),G1H2(128),G1H2(129),G1H2(130),G1H2(131),G1H2(132),2)
  call HG1shiftOLR(G1H2(128),8,2)
  call Hotf_5pt_reduction(G2H2(23),RedSet_5(2),mass5set(:,2),  & 
G1H2(133),G1H2(134),G1H2(135),G1H2(136),G1H2(137),G1H2(138),2)
  call HG1shiftOLR(G1H2(134),8,2)
  call Hotf_5pt_reduction(G2H2(24),RedSet_5(2),mass5set(:,4),  & 
G1H2(139),G1H2(140),G1H2(141),G1H2(142),G1H2(143),G1H2(144),2)
  call HG1shiftOLR(G1H2(140),8,2)
  call Hotf_5pt_reduction(G2H2(25),RedSet_5(2),mass5set(:,10),  & 
G1H2(145),G1H2(146),G1H2(147),G1H2(148),G1H2(149),G1H2(150),2)
  call HG1shiftOLR(G1H2(146),8,2)
  call Hotf_5pt_reduction(G2H2(26),RedSet_5(2),mass5set(:,9),  & 
G1H2(151),G1H2(152),G1H2(153),G1H2(154),G1H2(155),G1H2(156),2)
  call HG1shiftOLR(G1H2(152),8,2)
  call Hotf_5pt_reduction(G2H2(27),RedSet_5(3),mass5set(:,11),  & 
G1H2(157),G1H2(158),G1H2(159),G1H2(160),G1H2(161),G1H2(162),2)
  call HG1shiftOLR(G1H2(158),4,2)
  call Hotf_5pt_reduction(G2H2(28),RedSet_5(3),mass5set(:,12),  & 
G1H2(163),G1H2(164),G1H2(165),G1H2(166),G1H2(167),G1H2(168),2)
  call HG1shiftOLR(G1H2(164),4,2)
  call Hotf_5pt_reduction(G2H2(29),RedSet_5(3),mass5set(:,13),  & 
G1H2(169),G1H2(170),G1H2(171),G1H2(172),G1H2(173),G1H2(174),2)
  call HG1shiftOLR(G1H2(170),4,2)
  call Hotf_5pt_reduction(G2H2(30),RedSet_5(3),mass5set(:,14),  & 
G1H2(175),G1H2(176),G1H2(177),G1H2(178),G1H2(179),G1H2(180),2)
  call HG1shiftOLR(G1H2(176),4,2)
  call Hotf_5pt_reduction(G2H2(31),RedSet_5(3),mass5set(:,15),  & 
G1H2(181),G1H2(182),G1H2(183),G1H2(184),G1H2(185),G1H2(186),2)
  call HG1shiftOLR(G1H2(182),4,2)
  call Hotf_5pt_reduction(G2H2(32),RedSet_5(3),mass5set(:,14),  & 
G1H2(187),G1H2(188),G1H2(189),G1H2(190),G1H2(191),G1H2(192),2)
  call HG1shiftOLR(G1H2(188),4,2)
  call Hotf_5pt_reduction(G2H2(33),RedSet_5(3),mass5set(:,11),  & 
G1H2(193),G1H2(194),G1H2(195),G1H2(196),G1H2(197),G1H2(198),2)
  call HG1shiftOLR(G1H2(194),4,2)
  call Hotf_5pt_reduction(G2H2(34),RedSet_5(3),mass5set(:,13),  & 
G1H2(199),G1H2(200),G1H2(201),G1H2(202),G1H2(203),G1H2(204),2)
  call HG1shiftOLR(G1H2(200),4,2)
  call Hotf_5pt_reduction(G2H2(35),RedSet_5(3),mass5set(:,16),  & 
G1H2(205),G1H2(206),G1H2(207),G1H2(208),G1H2(209),G1H2(210),2)
  call HG1shiftOLR(G1H2(206),4,2)
  call Hotf_5pt_reduction(G2H2(36),RedSet_5(3),mass5set(:,16),  & 
G1H2(211),G1H2(212),G1H2(213),G1H2(214),G1H2(215),G1H2(216),2)
  call HG1shiftOLR(G1H2(212),4,2)
  call Hotf_5pt_reduction(G2H2(37),RedSet_5(4),mass5set(:,11),  & 
G1H2(217),G1H2(218),G1H2(219),G1H2(220),G1H2(221),G1H2(222),2)
  call HG1shiftOLR(G1H2(218),8,2)
  call Hotf_5pt_reduction(G2H2(38),RedSet_5(4),mass5set(:,12),  & 
G1H2(223),G1H2(224),G1H2(225),G1H2(226),G1H2(227),G1H2(228),2)
  call HG1shiftOLR(G1H2(224),8,2)
  call Hotf_5pt_reduction(G2H2(39),RedSet_5(4),mass5set(:,13),  & 
G1H2(229),G1H2(230),G1H2(231),G1H2(232),G1H2(233),G1H2(234),2)
  call HG1shiftOLR(G1H2(230),8,2)
  call Hotf_5pt_reduction(G2H2(40),RedSet_5(4),mass5set(:,14),  & 
G1H2(235),G1H2(236),G1H2(237),G1H2(238),G1H2(239),G1H2(240),2)
  call HG1shiftOLR(G1H2(236),8,2)
  call Hotf_5pt_reduction(G2H2(41),RedSet_5(4),mass5set(:,15),  & 
G1H2(241),G1H2(242),G1H2(243),G1H2(244),G1H2(245),G1H2(246),2)
  call HG1shiftOLR(G1H2(242),8,2)
  call Hotf_5pt_reduction(G2H2(42),RedSet_5(4),mass5set(:,14),  & 
G1H2(247),G1H2(248),G1H2(249),G1H2(250),G1H2(251),G1H2(252),2)
  call HG1shiftOLR(G1H2(248),8,2)
  call Hotf_5pt_reduction(G2H2(43),RedSet_5(4),mass5set(:,11),  & 
G1H2(253),G1H2(254),G1H2(255),G1H2(256),G1H2(257),G1H2(258),2)
  call HG1shiftOLR(G1H2(254),8,2)
  call Hotf_5pt_reduction(G2H2(44),RedSet_5(4),mass5set(:,13),  & 
G1H2(259),G1H2(260),G1H2(261),G1H2(262),G1H2(263),G1H2(264),2)
  call HG1shiftOLR(G1H2(260),8,2)
  call Hotf_5pt_reduction(G2H2(45),RedSet_5(4),mass5set(:,16),  & 
G1H2(265),G1H2(266),G1H2(267),G1H2(268),G1H2(269),G1H2(270),2)
  call HG1shiftOLR(G1H2(266),8,2)
  call Hotf_5pt_reduction(G2H2(46),RedSet_5(4),mass5set(:,16),  & 
G1H2(271),G1H2(272),G1H2(273),G1H2(274),G1H2(275),G1H2(276),2)
  call HG1shiftOLR(G1H2(272),8,2)
  call Hotf_5pt_reduction(G2H2(47),RedSet_5(5),mass5set(:,17),  & 
G1H2(277),G1H2(278),G1H2(279),G1H2(280),G1H2(281),G1H2(282),2)
  call HG1shiftOLR(G1H2(278),4,2)
  call Hotf_5pt_reduction(G2H2(48),RedSet_5(5),mass5set(:,18),  & 
G1H2(283),G1H2(284),G1H2(285),G1H2(286),G1H2(287),G1H2(288),2)
  call HG1shiftOLR(G1H2(284),4,2)
  call Hotf_5pt_reduction(G2H2(49),RedSet_5(5),mass5set(:,19),  & 
G1H2(289),G1H2(290),G1H2(291),G1H2(292),G1H2(293),G1H2(294),2)
  call HG1shiftOLR(G1H2(290),4,2)
  call Hotf_5pt_reduction(G2H2(50),RedSet_5(5),mass5set(:,20),  & 
G1H2(295),G1H2(296),G1H2(297),G1H2(298),G1H2(299),G1H2(300),2)
  call HG1shiftOLR(G1H2(296),4,2)
  call Hotf_5pt_reduction(G2H2(51),RedSet_5(5),mass5set(:,21),  & 
G1H2(301),G1H2(302),G1H2(303),G1H2(304),G1H2(305),G1H2(306),2)
  call HG1shiftOLR(G1H2(302),4,2)
  call Hotf_5pt_reduction(G2H2(52),RedSet_5(5),mass5set(:,22),  & 
G1H2(307),G1H2(308),G1H2(309),G1H2(310),G1H2(311),G1H2(312),2)
  call HG1shiftOLR(G1H2(308),4,2)
  call Hotf_5pt_reduction(G2H2(53),RedSet_5(5),mass5set(:,20),  & 
G1H2(313),G1H2(314),G1H2(315),G1H2(316),G1H2(317),G1H2(318),2)
  call HG1shiftOLR(G1H2(314),4,2)
  call Hotf_5pt_reduction(G2H2(54),RedSet_5(5),mass5set(:,17),  & 
G1H2(319),G1H2(320),G1H2(321),G1H2(322),G1H2(323),G1H2(324),2)
  call HG1shiftOLR(G1H2(320),4,2)
  call Hotf_5pt_reduction(G2H2(55),RedSet_5(5),mass5set(:,19),  & 
G1H2(325),G1H2(326),G1H2(327),G1H2(328),G1H2(329),G1H2(330),2)
  call HG1shiftOLR(G1H2(326),4,2)
  call Hotf_5pt_reduction(G2H2(56),RedSet_5(5),mass5set(:,21),  & 
G1H2(331),G1H2(332),G1H2(333),G1H2(334),G1H2(335),G1H2(336),2)
  call HG1shiftOLR(G1H2(332),4,2)
  call Hotf_5pt_reduction(G2H2(57),RedSet_5(6),mass5set(:,17),  & 
G1H2(337),G1H2(338),G1H2(339),G1H2(340),G1H2(341),G1H2(342),2)
  call HG1shiftOLR(G1H2(338),8,2)
  call Hotf_5pt_reduction(G2H2(58),RedSet_5(6),mass5set(:,18),  & 
G1H2(343),G1H2(344),G1H2(345),G1H2(346),G1H2(347),G1H2(348),2)
  call HG1shiftOLR(G1H2(344),8,2)
  call Hotf_5pt_reduction(G2H2(59),RedSet_5(6),mass5set(:,19),  & 
G1H2(349),G1H2(350),G1H2(351),G1H2(352),G1H2(353),G1H2(354),2)
  call HG1shiftOLR(G1H2(350),8,2)
  call Hotf_5pt_reduction(G2H2(60),RedSet_5(6),mass5set(:,20),  & 
G1H2(355),G1H2(356),G1H2(357),G1H2(358),G1H2(359),G1H2(360),2)
  call HG1shiftOLR(G1H2(356),8,2)
  call Hotf_5pt_reduction(G2H2(61),RedSet_5(6),mass5set(:,22),  & 
G1H2(361),G1H2(362),G1H2(363),G1H2(364),G1H2(365),G1H2(366),2)
  call HG1shiftOLR(G1H2(362),8,2)
  call Hotf_5pt_reduction(G2H2(62),RedSet_5(6),mass5set(:,20),  & 
G1H2(367),G1H2(368),G1H2(369),G1H2(370),G1H2(371),G1H2(372),2)
  call HG1shiftOLR(G1H2(368),8,2)
  call Hotf_5pt_reduction(G2H2(63),RedSet_5(6),mass5set(:,17),  & 
G1H2(373),G1H2(374),G1H2(375),G1H2(376),G1H2(377),G1H2(378),2)
  call HG1shiftOLR(G1H2(374),8,2)
  call Hotf_5pt_reduction(G2H2(64),RedSet_5(6),mass5set(:,19),  & 
G1H2(379),G1H2(380),G1H2(381),G1H2(382),G1H2(383),G1H2(384),2)
  call HG1shiftOLR(G1H2(380),8,2)
  call Hotf_5pt_reduction(G2H2(65),RedSet_5(6),mass5set(:,21),  & 
G1H2(385),G1H2(386),G1H2(387),G1H2(388),G1H2(389),G1H2(390),2)
  call HG1shiftOLR(G1H2(386),8,2)
  call Hotf_5pt_reduction(G2H2(66),RedSet_5(6),mass5set(:,21),  & 
G1H2(391),G1H2(392),G1H2(393),G1H2(394),G1H2(395),G1H2(396),2)
  call HG1shiftOLR(G1H2(392),8,2)
  call Hotf_5pt_reduction(G2H2(67),RedSet_5(7),mass5set(:,23),  & 
G1H2(397),G1H2(398),G1H2(399),G1H2(400),G1H2(401),G1H2(402),2)
  call HG1shiftOLR(G1H2(398),2,2)
  call Hotf_5pt_reduction(G2H2(68),RedSet_5(7),mass5set(:,24),  & 
G1H2(403),G1H2(404),G1H2(405),G1H2(406),G1H2(407),G1H2(408),2)
  call HG1shiftOLR(G1H2(404),2,2)
  call Hotf_5pt_reduction(G2H2(69),RedSet_5(7),mass5set(:,25),  & 
G1H2(409),G1H2(410),G1H2(411),G1H2(412),G1H2(413),G1H2(414),2)
  call HG1shiftOLR(G1H2(410),2,2)
  call Hotf_5pt_reduction(G2H2(70),RedSet_5(7),mass5set(:,26),  & 
G1H2(415),G1H2(416),G1H2(417),G1H2(418),G1H2(419),G1H2(420),2)
  call HG1shiftOLR(G1H2(416),2,2)
  call Hotf_5pt_reduction(G2H2(71),RedSet_5(7),mass5set(:,27),  & 
G1H2(421),G1H2(422),G1H2(423),G1H2(424),G1H2(425),G1H2(426),2)
  call HG1shiftOLR(G1H2(422),2,2)
  call Hotf_5pt_reduction(G2H2(72),RedSet_5(7),mass5set(:,28),  & 
G1H2(427),G1H2(428),G1H2(429),G1H2(430),G1H2(431),G1H2(432),2)
  call HG1shiftOLR(G1H2(428),2,2)
  call Hotf_5pt_reduction(G2H2(73),RedSet_5(7),mass5set(:,29),  & 
G1H2(433),G1H2(434),G1H2(435),G1H2(436),G1H2(437),G1H2(438),2)
  call HG1shiftOLR(G1H2(434),2,2)
  call Hotf_5pt_reduction(G2H2(74),RedSet_5(7),mass5set(:,24),  & 
G1H2(439),G1H2(440),G1H2(441),G1H2(442),G1H2(443),G1H2(444),2)
  call HG1shiftOLR(G1H2(440),2,2)
  call Hotf_5pt_reduction(G2H2(75),RedSet_5(7),mass5set(:,26),  & 
G1H2(445),G1H2(446),G1H2(447),G1H2(448),G1H2(449),G1H2(450),2)
  call HG1shiftOLR(G1H2(446),2,2)
  call Hotf_5pt_reduction(G2H2(76),RedSet_5(7),mass5set(:,27),  & 
G1H2(451),G1H2(452),G1H2(453),G1H2(454),G1H2(455),G1H2(456),2)
  call HG1shiftOLR(G1H2(452),2,2)
  call Hotf_5pt_reduction(G2H2(77),RedSet_5(7),mass5set(:,30),  & 
G1H2(457),G1H2(458),G1H2(459),G1H2(460),G1H2(461),G1H2(462),2)
  call HG1shiftOLR(G1H2(458),2,2)
  call Hotf_5pt_reduction(G2H2(78),RedSet_5(7),mass5set(:,31),  & 
G1H2(463),G1H2(464),G1H2(465),G1H2(466),G1H2(467),G1H2(468),2)
  call HG1shiftOLR(G1H2(464),2,2)
  call Hotf_5pt_reduction(G2H2(79),RedSet_5(7),mass5set(:,32),  & 
G1H2(469),G1H2(470),G1H2(471),G1H2(472),G1H2(473),G1H2(474),2)
  call HG1shiftOLR(G1H2(470),2,2)
  call Hotf_5pt_reduction(G2H2(80),RedSet_5(7),mass5set(:,31),  & 
G1H2(475),G1H2(476),G1H2(477),G1H2(478),G1H2(479),G1H2(480),2)
  call HG1shiftOLR(G1H2(476),2,2)
  call Hotf_5pt_reduction(G2H2(81),RedSet_5(8),mass5set(:,23),  & 
G1H2(481),G1H2(482),G1H2(483),G1H2(484),G1H2(485),G1H2(486),2)
  call HG1shiftOLR(G1H2(482),2,2)
  call Hotf_5pt_reduction(G2H2(82),RedSet_5(8),mass5set(:,24),  & 
G1H2(487),G1H2(488),G1H2(489),G1H2(490),G1H2(491),G1H2(492),2)
  call HG1shiftOLR(G1H2(488),2,2)
  call Hotf_5pt_reduction(G2H2(83),RedSet_5(8),mass5set(:,25),  & 
G1H2(493),G1H2(494),G1H2(495),G1H2(496),G1H2(497),G1H2(498),2)
  call HG1shiftOLR(G1H2(494),2,2)
  call Hotf_5pt_reduction(G2H2(84),RedSet_5(8),mass5set(:,26),  & 
G1H2(499),G1H2(500),G1H2(501),G1H2(502),G1H2(503),G1H2(504),2)
  call HG1shiftOLR(G1H2(500),2,2)
  call Hotf_5pt_reduction(G2H2(85),RedSet_5(8),mass5set(:,28),  & 
G1H2(505),G1H2(506),G1H2(507),G1H2(508),G1H2(509),G1H2(510),2)
  call HG1shiftOLR(G1H2(506),2,2)
  call Hotf_5pt_reduction(G2H2(86),RedSet_5(8),mass5set(:,29),  & 
G1H2(511),G1H2(512),G1H2(513),G1H2(514),G1H2(515),G1H2(516),2)
  call HG1shiftOLR(G1H2(512),2,2)
  call Hotf_5pt_reduction(G2H2(87),RedSet_5(8),mass5set(:,24),  & 
G1H2(517),G1H2(518),G1H2(519),G1H2(520),G1H2(521),G1H2(522),2)
  call HG1shiftOLR(G1H2(518),2,2)
  call Hotf_5pt_reduction(G2H2(88),RedSet_5(8),mass5set(:,26),  & 
G1H2(523),G1H2(524),G1H2(525),G1H2(526),G1H2(527),G1H2(528),2)
  call HG1shiftOLR(G1H2(524),2,2)
  call Hotf_5pt_reduction(G2H2(89),RedSet_5(8),mass5set(:,30),  & 
G1H2(529),G1H2(530),G1H2(531),G1H2(532),G1H2(533),G1H2(534),2)
  call HG1shiftOLR(G1H2(530),2,2)
  call Hotf_5pt_reduction(G2H2(90),RedSet_5(8),mass5set(:,31),  & 
G1H2(535),G1H2(536),G1H2(537),G1H2(538),G1H2(539),G1H2(540),2)
  call HG1shiftOLR(G1H2(536),2,2)
  call Hotf_5pt_reduction(G2H2(91),RedSet_5(8),mass5set(:,32),  & 
G1H2(541),G1H2(542),G1H2(543),G1H2(544),G1H2(545),G1H2(546),2)
  call HG1shiftOLR(G1H2(542),2,2)
  call Hotf_5pt_reduction(G2H2(92),RedSet_5(8),mass5set(:,31),  & 
G1H2(547),G1H2(548),G1H2(549),G1H2(550),G1H2(551),G1H2(552),2)
  call HG1shiftOLR(G1H2(548),2,2)
  call Hloop_SA_Q(ntryL,G1H2(1),ex4(:),G1H1(1),ngH,m3h2x1(:,1),heltab2x2(:,:,1))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,nMB,G2tensor(1),n2h1(1))
  call Hloop_SA_Q(ntryL,G1H2(2),ex4(:),G1H1(1),ngH,m3h2x1(:,2),heltab2x2(:,:,2))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),8,nMB,G2tensor(2),n2h1(2))
  call Hloop_SA_Q(ntryL,G1H2(6),ex4(:),G1H1(1),ngH,m3h2x1(:,3),heltab2x2(:,:,3))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,nMB,G2tensor(3),n2h1(3))
  call Hloop_SA_Q(ntryL,G1H2(7),ex4(:),G1H1(1),ngX,m3h2x1(:,4),heltab2x2(:,:,4))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,nMB,G2tensor(4),n2h1(4))
  call Hloop_SA_Q(ntryL,G1H2(8),ex4(:),G1H1(1),ngX,m3h2x1(:,5),heltab2x2(:,:,5))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),8,nMB,G2tensor(5),n2h1(5))
  call Hloop_SA_Q(ntryL,G1H2(12),ex4(:),G1H1(1),ngX,m3h2x1(:,6),heltab2x2(:,:,6))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,nMB,G2tensor(6),n2h1(6))
  call Hloop_SA_Q(ntryL,G1H2(13),ex4(:),G1H1(1),ngH,m3h2x1(:,7),heltab2x2(:,:,7))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,nMB,G2tensor(7),n2h1(7))
  call Hloop_SA_Q(ntryL,G1H2(14),ex4(:),G1H1(1),ngH,m3h2x1(:,8),heltab2x2(:,:,8))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),8,nMB,G2tensor(8),n2h1(8))
  call Hloop_SA_Q(ntryL,G1H2(18),ex4(:),G1H1(1),ngH,m3h2x1(:,9),heltab2x2(:,:,9))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,nMB,G2tensor(9),n2h1(9))
  call Hloop_SA_Q(ntryL,G1H2(19),ex4(:),G1H1(1),ngX,m3h2x1(:,10),heltab2x2(:,:,10))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,nMB,G2tensor(10),n2h1(10))
  call Hloop_SA_Q(ntryL,G1H2(20),ex4(:),G1H1(1),ngX,m3h2x1(:,11),heltab2x2(:,:,11))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),8,nMB,G2tensor(11),n2h1(11))
  call Hloop_SA_Q(ntryL,G1H2(24),ex4(:),G1H1(1),ngX,m3h2x1(:,12),heltab2x2(:,:,12))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,nMB,G2tensor(12),n2h1(12))
  call Hloop_SA_Q(ntryL,G1H2(25),ex4(:),G1H1(1),ngPbt,m3h2x1(:,13),heltab2x2(:,:,13))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,nMT,G2tensor(13),n2h1(13))
  call Hloop_SA_Q(ntryL,G1H2(26),ex4(:),G1H1(1),ngPbt,m3h2x1(:,14),heltab2x2(:,:,14))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),8,nMT,G2tensor(14),n2h1(14))
  call Hloop_SA_Q(ntryL,G1H2(30),ex4(:),G1H1(1),ngPbt,m3h2x1(:,15),heltab2x2(:,:,15))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,nMT,G2tensor(15),n2h1(15))
  call Hloop_VA_Q(ntryL,G1H2(31),ex4(:),G1H1(1),m3h2x1(:,16),heltab2x2(:,:,16))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,nMB,G2tensor(16),n2h1(16))
  call Hloop_VA_Q(ntryL,G1H2(32),ex4(:),G1H1(1),m3h2x1(:,17),heltab2x2(:,:,17))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),8,nMB,G2tensor(17),n2h1(17))
  call Hloop_VA_Q(ntryL,G1H2(36),ex4(:),G1H1(1),m3h2x1(:,18),heltab2x2(:,:,18))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,nMB,G2tensor(18),n2h1(18))
  call Hloop_VA_Q(ntryL,G1H2(37),ex4(:),G1H1(1),m3h2x1(:,19),heltab2x2(:,:,19))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,nMB,G2tensor(19),n2h1(19))
  call Hloop_VA_Q(ntryL,G1H2(38),ex4(:),G1H1(1),m3h2x1(:,20),heltab2x2(:,:,20))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),8,nMB,G2tensor(20),n2h1(20))
  call Hloop_VA_Q(ntryL,G1H2(42),ex4(:),G1H1(1),m3h2x1(:,21),heltab2x2(:,:,21))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,nMB,G2tensor(21),n2h1(21))
  call Hloop_ZA_Q(ntryL,G1H2(43),ex4(:),G1H1(1),ngZd,m3h2x1(:,22),heltab2x2(:,:,22))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,nMB,G2tensor(22),n2h1(22))
  call Hloop_ZA_Q(ntryL,G1H2(44),ex4(:),G1H1(1),ngZd,m3h2x1(:,23),heltab2x2(:,:,23))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),8,nMB,G2tensor(23),n2h1(23))
  call Hloop_ZA_Q(ntryL,G1H2(48),ex4(:),G1H1(1),ngZd,m3h2x1(:,24),heltab2x2(:,:,24))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,nMB,G2tensor(24),n2h1(24))
  call Hloop_ZA_Q(ntryL,G1H2(49),ex4(:),G1H1(1),ngZd,m3h2x1(:,25),heltab2x2(:,:,25))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,nMB,G2tensor(25),n2h1(25))
  call Hloop_ZA_Q(ntryL,G1H2(50),ex4(:),G1H1(1),ngZd,m3h2x1(:,26),heltab2x2(:,:,26))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),8,nMB,G2tensor(26),n2h1(26))
  call Hloop_ZA_Q(ntryL,G1H2(54),ex4(:),G1H1(1),ngZd,m3h2x1(:,27),heltab2x2(:,:,27))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,nMB,G2tensor(27),n2h1(27))
  call Hloop_WA_Q(ntryL,G1H2(55),ex4(:),G1H1(1),m3h2x1(:,28),heltab2x2(:,:,28))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,nMT,G2tensor(28),n2h1(28))
  call Hloop_WA_Q(ntryL,G1H2(56),ex4(:),G1H1(1),m3h2x1(:,29),heltab2x2(:,:,29))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),8,nMT,G2tensor(29),n2h1(29))
  call Hloop_WA_Q(ntryL,G1H2(60),ex4(:),G1H1(1),m3h2x1(:,30),heltab2x2(:,:,30))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,nMT,G2tensor(30),n2h1(30))
  call Hloop_SA_Q(ntryL,G1H2(61),ex4(:),G1H1(1),ngH,m3h2x1(:,31),heltab2x2(:,:,31))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,nMB,G2tensor(31),n2h1(31))
  call Hloop_SA_Q(ntryL,G1H2(62),ex4(:),G1H1(1),ngH,m3h2x1(:,32),heltab2x2(:,:,32))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),8,nMB,G2tensor(32),n2h1(32))
  call Hloop_SA_Q(ntryL,G1H2(66),ex4(:),G1H1(1),ngH,m3h2x1(:,33),heltab2x2(:,:,33))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,nMB,G2tensor(33),n2h1(33))
  call Hloop_SA_Q(ntryL,G1H2(67),ex4(:),G1H1(1),ngX,m3h2x1(:,34),heltab2x2(:,:,34))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,nMB,G2tensor(34),n2h1(34))
  call Hloop_SA_Q(ntryL,G1H2(68),ex4(:),G1H1(1),ngX,m3h2x1(:,35),heltab2x2(:,:,35))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),8,nMB,G2tensor(35),n2h1(35))
  call Hloop_SA_Q(ntryL,G1H2(72),ex4(:),G1H1(1),ngX,m3h2x1(:,36),heltab2x2(:,:,36))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,nMB,G2tensor(36),n2h1(36))
  call Hloop_VA_Q(ntryL,G1H2(73),ex4(:),G1H1(1),m3h2x1(:,37),heltab2x2(:,:,37))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,nMB,G2tensor(37),n2h1(37))
  call Hloop_VA_Q(ntryL,G1H2(74),ex4(:),G1H1(1),m3h2x1(:,38),heltab2x2(:,:,38))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),8,nMB,G2tensor(38),n2h1(38))
  call Hloop_VA_Q(ntryL,G1H2(78),ex4(:),G1H1(1),m3h2x1(:,39),heltab2x2(:,:,39))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,nMB,G2tensor(39),n2h1(39))
  call Hloop_ZA_Q(ntryL,G1H2(79),ex4(:),G1H1(1),ngZd,m3h2x1(:,40),heltab2x2(:,:,40))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,nMB,G2tensor(40),n2h1(40))
  call Hloop_ZA_Q(ntryL,G1H2(80),ex4(:),G1H1(1),ngZd,m3h2x1(:,41),heltab2x2(:,:,41))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),8,nMB,G2tensor(41),n2h1(41))
  call Hloop_ZA_Q(ntryL,G1H2(84),ex4(:),G1H1(1),ngZd,m3h2x1(:,42),heltab2x2(:,:,42))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,nMB,G2tensor(42),n2h1(42))
  call Hloop_SA_Q(ntryL,G1H2(85),ex4(:),G1H1(1),ngH,m3h2x1(:,43),heltab2x2(:,:,43))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,nMB,G2tensor(43),n2h1(43))
  call Hloop_SA_Q(ntryL,G1H2(86),ex4(:),G1H1(1),ngH,m3h2x1(:,44),heltab2x2(:,:,44))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),8,nMB,G2tensor(44),n2h1(44))
  call Hloop_SA_Q(ntryL,G1H2(90),ex4(:),G1H1(1),ngH,m3h2x1(:,45),heltab2x2(:,:,45))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,nMB,G2tensor(45),n2h1(45))
  call Hloop_SA_Q(ntryL,G1H2(91),ex4(:),G1H1(1),ngH,m3h2x1(:,46),heltab2x2(:,:,46))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,nMB,G2tensor(46),n2h1(46))
  call Hloop_SA_Q(ntryL,G1H2(92),ex4(:),G1H1(1),ngH,m3h2x1(:,47),heltab2x2(:,:,47))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),8,nMB,G2tensor(47),n2h1(47))
  call Hloop_SA_Q(ntryL,G1H2(96),ex4(:),G1H1(1),ngH,m3h2x1(:,48),heltab2x2(:,:,48))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,nMB,G2tensor(48),n2h1(48))
  call Hloop_SA_Q(ntryL,G1H2(97),ex4(:),G1H1(1),ngX,m3h2x1(:,49),heltab2x2(:,:,49))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,nMB,G2tensor(49),n2h1(49))
  call Hloop_SA_Q(ntryL,G1H2(98),ex4(:),G1H1(1),ngX,m3h2x1(:,50),heltab2x2(:,:,50))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),8,nMB,G2tensor(50),n2h1(50))
  call Hloop_SA_Q(ntryL,G1H2(102),ex4(:),G1H1(1),ngX,m3h2x1(:,51),heltab2x2(:,:,51))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,nMB,G2tensor(51),n2h1(51))
  call Hloop_SA_Q(ntryL,G1H2(103),ex4(:),G1H1(1),ngX,m3h2x1(:,52),heltab2x2(:,:,52))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,nMB,G2tensor(52),n2h1(52))
  call Hloop_SA_Q(ntryL,G1H2(104),ex4(:),G1H1(1),ngX,m3h2x1(:,53),heltab2x2(:,:,53))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),8,nMB,G2tensor(53),n2h1(53))
  call Hloop_SA_Q(ntryL,G1H2(108),ex4(:),G1H1(1),ngX,m3h2x1(:,54),heltab2x2(:,:,54))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,nMB,G2tensor(54),n2h1(54))
  call Hloop_SA_Q(ntryL,G1H2(109),ex4(:),G1H1(1),ngH,m3h2x1(:,55),heltab2x2(:,:,55))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,nMB,G2tensor(55),n2h1(55))
  call Hloop_SA_Q(ntryL,G1H2(110),ex4(:),G1H1(1),ngH,m3h2x1(:,56),heltab2x2(:,:,56))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),8,nMB,G2tensor(56),n2h1(56))
  call Hloop_SA_Q(ntryL,G1H2(114),ex4(:),G1H1(1),ngH,m3h2x1(:,57),heltab2x2(:,:,57))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,nMB,G2tensor(57),n2h1(57))
  call Hloop_SA_Q(ntryL,G1H2(115),ex4(:),G1H1(1),ngX,m3h2x1(:,58),heltab2x2(:,:,58))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,nMB,G2tensor(58),n2h1(58))
  call Hloop_SA_Q(ntryL,G1H2(116),ex4(:),G1H1(1),ngX,m3h2x1(:,59),heltab2x2(:,:,59))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),8,nMB,G2tensor(59),n2h1(59))
  call Hloop_SA_Q(ntryL,G1H2(120),ex4(:),G1H1(1),ngX,m3h2x1(:,60),heltab2x2(:,:,60))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,nMB,G2tensor(60),n2h1(60))
  call Hloop_VA_Q(ntryL,G1H2(121),ex4(:),G1H1(1),m3h2x1(:,61),heltab2x2(:,:,61))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,nMB,G2tensor(61),n2h1(61))
  call Hloop_VA_Q(ntryL,G1H2(122),ex4(:),G1H1(1),m3h2x1(:,62),heltab2x2(:,:,62))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),8,nMB,G2tensor(62),n2h1(62))
  call Hloop_VA_Q(ntryL,G1H2(126),ex4(:),G1H1(1),m3h2x1(:,63),heltab2x2(:,:,63))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,nMB,G2tensor(63),n2h1(63))
  call Hloop_VA_Q(ntryL,G1H2(127),ex4(:),G1H1(1),m3h2x1(:,64),heltab2x2(:,:,64))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,nMB,G2tensor(64),n2h1(64))
  call Hloop_VA_Q(ntryL,G1H2(128),ex4(:),G1H1(1),m3h2x1(:,65),heltab2x2(:,:,65))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),8,nMB,G2tensor(65),n2h1(65))
  call Hloop_VA_Q(ntryL,G1H2(132),ex4(:),G1H1(1),m3h2x1(:,66),heltab2x2(:,:,66))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,nMB,G2tensor(66),n2h1(66))
  call Hloop_ZA_Q(ntryL,G1H2(133),ex4(:),G1H1(1),ngZd,m3h2x1(:,67),heltab2x2(:,:,67))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,nMB,G2tensor(67),n2h1(67))
  call Hloop_ZA_Q(ntryL,G1H2(134),ex4(:),G1H1(1),ngZd,m3h2x1(:,68),heltab2x2(:,:,68))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),8,nMB,G2tensor(68),n2h1(68))
  call Hloop_ZA_Q(ntryL,G1H2(138),ex4(:),G1H1(1),ngZd,m3h2x1(:,69),heltab2x2(:,:,69))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,nMB,G2tensor(69),n2h1(69))
  call Hloop_ZA_Q(ntryL,G1H2(139),ex4(:),G1H1(1),ngZd,m3h2x1(:,70),heltab2x2(:,:,70))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,nMB,G2tensor(70),n2h1(70))
  call Hloop_ZA_Q(ntryL,G1H2(140),ex4(:),G1H1(1),ngZd,m3h2x1(:,71),heltab2x2(:,:,71))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),8,nMB,G2tensor(71),n2h1(71))
  call Hloop_ZA_Q(ntryL,G1H2(144),ex4(:),G1H1(1),ngZd,m3h2x1(:,72),heltab2x2(:,:,72))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,nMB,G2tensor(72),n2h1(72))
  call Hloop_VA_Q(ntryL,G1H2(145),ex4(:),G1H1(1),m3h2x1(:,73),heltab2x2(:,:,73))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,nMB,G2tensor(73),n2h1(73))
  call Hloop_VA_Q(ntryL,G1H2(146),ex4(:),G1H1(1),m3h2x1(:,74),heltab2x2(:,:,74))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),8,nMB,G2tensor(74),n2h1(74))
  call Hloop_VA_Q(ntryL,G1H2(150),ex4(:),G1H1(1),m3h2x1(:,75),heltab2x2(:,:,75))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,nMB,G2tensor(75),n2h1(75))
  call Hloop_ZA_Q(ntryL,G1H2(151),ex4(:),G1H1(1),ngZd,m3h2x1(:,76),heltab2x2(:,:,76))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,nMB,G2tensor(76),n2h1(76))
  call Hloop_ZA_Q(ntryL,G1H2(152),ex4(:),G1H1(1),ngZd,m3h2x1(:,77),heltab2x2(:,:,77))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),8,nMB,G2tensor(77),n2h1(77))
  call Hloop_ZA_Q(ntryL,G1H2(156),ex4(:),G1H1(1),ngZd,m3h2x1(:,78),heltab2x2(:,:,78))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,nMB,G2tensor(78),n2h1(78))
  call Hloop_SQ_A(ntryL,G1H2(157),ex3(:),G1H1(1),ngPtb,m3h2x1(:,79),heltab2x2(:,:,79))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,nMT,G2tensor(79),n2h1(79))
  call Hloop_SQ_A(ntryL,G1H2(158),ex3(:),G1H1(1),ngPtb,m3h2x1(:,80),heltab2x2(:,:,80))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),4,nMT,G2tensor(80),n2h1(80))
  call Hloop_SQ_A(ntryL,G1H2(162),ex3(:),G1H1(1),ngPtb,m3h2x1(:,81),heltab2x2(:,:,81))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,nMT,G2tensor(81),n2h1(81))
  call Hloop_SQ_A(ntryL,G1H2(163),ex3(:),G1H1(1),ngH,m3h2x1(:,82),heltab2x2(:,:,82))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,nMB,G2tensor(82),n2h1(82))
  call Hloop_SQ_A(ntryL,G1H2(164),ex3(:),G1H1(1),ngH,m3h2x1(:,83),heltab2x2(:,:,83))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),4,nMB,G2tensor(83),n2h1(83))
  call Hloop_SQ_A(ntryL,G1H2(168),ex3(:),G1H1(1),ngH,m3h2x1(:,84),heltab2x2(:,:,84))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,nMB,G2tensor(84),n2h1(84))
  call Hloop_SQ_A(ntryL,G1H2(169),ex3(:),G1H1(1),ngPtb,m3h2x1(:,85),heltab2x2(:,:,85))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,nMT,G2tensor(85),n2h1(85))
  call Hloop_SQ_A(ntryL,G1H2(170),ex3(:),G1H1(1),ngPtb,m3h2x1(:,86),heltab2x2(:,:,86))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),4,nMT,G2tensor(86),n2h1(86))
  call Hloop_SQ_A(ntryL,G1H2(174),ex3(:),G1H1(1),ngPtb,m3h2x1(:,87),heltab2x2(:,:,87))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,nMT,G2tensor(87),n2h1(87))
  call Hloop_SQ_A(ntryL,G1H2(175),ex3(:),G1H1(1),ngX,m3h2x1(:,88),heltab2x2(:,:,88))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,nMB,G2tensor(88),n2h1(88))
  call Hloop_SQ_A(ntryL,G1H2(176),ex3(:),G1H1(1),ngX,m3h2x1(:,89),heltab2x2(:,:,89))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),4,nMB,G2tensor(89),n2h1(89))
  call Hloop_SQ_A(ntryL,G1H2(180),ex3(:),G1H1(1),ngX,m3h2x1(:,90),heltab2x2(:,:,90))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,nMB,G2tensor(90),n2h1(90))
  call Hloop_VQ_A(ntryL,G1H2(181),ex3(:),G1H1(1),m3h2x1(:,91),heltab2x2(:,:,91))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,nMB,G2tensor(91),n2h1(91))
  call Hloop_VQ_A(ntryL,G1H2(182),ex3(:),G1H1(1),m3h2x1(:,92),heltab2x2(:,:,92))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),4,nMB,G2tensor(92),n2h1(92))
  call Hloop_VQ_A(ntryL,G1H2(186),ex3(:),G1H1(1),m3h2x1(:,93),heltab2x2(:,:,93))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,nMB,G2tensor(93),n2h1(93))
  call Hloop_ZQ_A(ntryL,G1H2(187),ex3(:),G1H1(1),ngZd,m3h2x1(:,94),heltab2x2(:,:,94))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,nMB,G2tensor(94),n2h1(94))
  call Hloop_ZQ_A(ntryL,G1H2(188),ex3(:),G1H1(1),ngZd,m3h2x1(:,95),heltab2x2(:,:,95))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),4,nMB,G2tensor(95),n2h1(95))
  call Hloop_ZQ_A(ntryL,G1H2(192),ex3(:),G1H1(1),ngZd,m3h2x1(:,96),heltab2x2(:,:,96))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,nMB,G2tensor(96),n2h1(96))
  call Hloop_WQ_A(ntryL,G1H2(193),ex3(:),G1H1(1),m3h2x1(:,97),heltab2x2(:,:,97))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,nMT,G2tensor(97),n2h1(97))
  call Hloop_WQ_A(ntryL,G1H2(194),ex3(:),G1H1(1),m3h2x1(:,98),heltab2x2(:,:,98))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),4,nMT,G2tensor(98),n2h1(98))
  call Hloop_WQ_A(ntryL,G1H2(198),ex3(:),G1H1(1),m3h2x1(:,99),heltab2x2(:,:,99))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,nMT,G2tensor(99),n2h1(99))
  call Hloop_WQ_A(ntryL,G1H2(199),ex3(:),G1H1(1),m3h2x1(:,100),heltab2x2(:,:,100))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,nMT,G2tensor(100),n2h1(100))
  call Hloop_WQ_A(ntryL,G1H2(200),ex3(:),G1H1(1),m3h2x1(:,101),heltab2x2(:,:,101))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),4,nMT,G2tensor(101),n2h1(101))
  call Hloop_WQ_A(ntryL,G1H2(204),ex3(:),G1H1(1),m3h2x1(:,102),heltab2x2(:,:,102))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,nMT,G2tensor(102),n2h1(102))
  call Hloop_SQ_A(ntryL,G1H2(205),ex3(:),G1H1(1),ngPtb,m3h2x1(:,103),heltab2x2(:,:,103))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,nMT,G2tensor(103),n2h1(103))
  call Hloop_SQ_A(ntryL,G1H2(206),ex3(:),G1H1(1),ngPtb,m3h2x1(:,104),heltab2x2(:,:,104))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),4,nMT,G2tensor(104),n2h1(104))
  call Hloop_SQ_A(ntryL,G1H2(210),ex3(:),G1H1(1),ngPtb,m3h2x1(:,105),heltab2x2(:,:,105))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,nMT,G2tensor(105),n2h1(105))
  call Hloop_WQ_A(ntryL,G1H2(211),ex3(:),G1H1(1),m3h2x1(:,106),heltab2x2(:,:,106))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,nMT,G2tensor(106),n2h1(106))
  call Hloop_WQ_A(ntryL,G1H2(212),ex3(:),G1H1(1),m3h2x1(:,107),heltab2x2(:,:,107))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),4,nMT,G2tensor(107),n2h1(107))
  call Hloop_WQ_A(ntryL,G1H2(216),ex3(:),G1H1(1),m3h2x1(:,108),heltab2x2(:,:,108))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,nMT,G2tensor(108),n2h1(108))
  call Hloop_SA_Q(ntryL,G1H2(217),ex4(:),G1H1(1),ngPbt,m3h2x1(:,109),heltab2x2(:,:,109))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,nMT,G2tensor(109),n2h1(109))
  call Hloop_SA_Q(ntryL,G1H2(218),ex4(:),G1H1(1),ngPbt,m3h2x1(:,110),heltab2x2(:,:,110))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),8,nMT,G2tensor(110),n2h1(110))
  call Hloop_SA_Q(ntryL,G1H2(222),ex4(:),G1H1(1),ngPbt,m3h2x1(:,111),heltab2x2(:,:,111))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,nMT,G2tensor(111),n2h1(111))
  call Hloop_SA_Q(ntryL,G1H2(223),ex4(:),G1H1(1),ngH,m3h2x1(:,112),heltab2x2(:,:,112))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,nMB,G2tensor(112),n2h1(112))
  call Hloop_SA_Q(ntryL,G1H2(224),ex4(:),G1H1(1),ngH,m3h2x1(:,113),heltab2x2(:,:,113))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),8,nMB,G2tensor(113),n2h1(113))
  call Hloop_SA_Q(ntryL,G1H2(228),ex4(:),G1H1(1),ngH,m3h2x1(:,114),heltab2x2(:,:,114))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,nMB,G2tensor(114),n2h1(114))
  call Hloop_SA_Q(ntryL,G1H2(229),ex4(:),G1H1(1),ngPbt,m3h2x1(:,115),heltab2x2(:,:,115))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,nMT,G2tensor(115),n2h1(115))
  call Hloop_SA_Q(ntryL,G1H2(230),ex4(:),G1H1(1),ngPbt,m3h2x1(:,116),heltab2x2(:,:,116))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),8,nMT,G2tensor(116),n2h1(116))
  call Hloop_SA_Q(ntryL,G1H2(234),ex4(:),G1H1(1),ngPbt,m3h2x1(:,117),heltab2x2(:,:,117))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,nMT,G2tensor(117),n2h1(117))
  call Hloop_SA_Q(ntryL,G1H2(235),ex4(:),G1H1(1),ngX,m3h2x1(:,118),heltab2x2(:,:,118))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,nMB,G2tensor(118),n2h1(118))
  call Hloop_SA_Q(ntryL,G1H2(236),ex4(:),G1H1(1),ngX,m3h2x1(:,119),heltab2x2(:,:,119))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),8,nMB,G2tensor(119),n2h1(119))
  call Hloop_SA_Q(ntryL,G1H2(240),ex4(:),G1H1(1),ngX,m3h2x1(:,120),heltab2x2(:,:,120))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,nMB,G2tensor(120),n2h1(120))
  call Hloop_VA_Q(ntryL,G1H2(241),ex4(:),G1H1(1),m3h2x1(:,121),heltab2x2(:,:,121))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,nMB,G2tensor(121),n2h1(121))
  call Hloop_VA_Q(ntryL,G1H2(242),ex4(:),G1H1(1),m3h2x1(:,122),heltab2x2(:,:,122))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),8,nMB,G2tensor(122),n2h1(122))
  call Hloop_VA_Q(ntryL,G1H2(246),ex4(:),G1H1(1),m3h2x1(:,123),heltab2x2(:,:,123))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,nMB,G2tensor(123),n2h1(123))
  call Hloop_ZA_Q(ntryL,G1H2(247),ex4(:),G1H1(1),ngZd,m3h2x1(:,124),heltab2x2(:,:,124))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,nMB,G2tensor(124),n2h1(124))
  call Hloop_ZA_Q(ntryL,G1H2(248),ex4(:),G1H1(1),ngZd,m3h2x1(:,125),heltab2x2(:,:,125))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),8,nMB,G2tensor(125),n2h1(125))
  call Hloop_ZA_Q(ntryL,G1H2(252),ex4(:),G1H1(1),ngZd,m3h2x1(:,126),heltab2x2(:,:,126))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,nMB,G2tensor(126),n2h1(126))
  call Hloop_WA_Q(ntryL,G1H2(253),ex4(:),G1H1(1),m3h2x1(:,127),heltab2x2(:,:,127))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,nMT,G2tensor(127),n2h1(127))
  call Hloop_WA_Q(ntryL,G1H2(254),ex4(:),G1H1(1),m3h2x1(:,128),heltab2x2(:,:,128))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),8,nMT,G2tensor(128),n2h1(128))
  call Hloop_WA_Q(ntryL,G1H2(258),ex4(:),G1H1(1),m3h2x1(:,129),heltab2x2(:,:,129))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,nMT,G2tensor(129),n2h1(129))
  call Hloop_WA_Q(ntryL,G1H2(259),ex4(:),G1H1(1),m3h2x1(:,130),heltab2x2(:,:,130))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,nMT,G2tensor(130),n2h1(130))
  call Hloop_WA_Q(ntryL,G1H2(260),ex4(:),G1H1(1),m3h2x1(:,131),heltab2x2(:,:,131))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),8,nMT,G2tensor(131),n2h1(131))
  call Hloop_WA_Q(ntryL,G1H2(264),ex4(:),G1H1(1),m3h2x1(:,132),heltab2x2(:,:,132))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,nMT,G2tensor(132),n2h1(132))
  call Hloop_SA_Q(ntryL,G1H2(265),ex4(:),G1H1(1),ngPbt,m3h2x1(:,133),heltab2x2(:,:,133))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,nMT,G2tensor(133),n2h1(133))
  call Hloop_SA_Q(ntryL,G1H2(266),ex4(:),G1H1(1),ngPbt,m3h2x1(:,134),heltab2x2(:,:,134))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),8,nMT,G2tensor(134),n2h1(134))
  call Hloop_SA_Q(ntryL,G1H2(270),ex4(:),G1H1(1),ngPbt,m3h2x1(:,135),heltab2x2(:,:,135))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,nMT,G2tensor(135),n2h1(135))
  call Hloop_WA_Q(ntryL,G1H2(271),ex4(:),G1H1(1),m3h2x1(:,136),heltab2x2(:,:,136))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,nMT,G2tensor(136),n2h1(136))
  call Hloop_WA_Q(ntryL,G1H2(272),ex4(:),G1H1(1),m3h2x1(:,137),heltab2x2(:,:,137))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),8,nMT,G2tensor(137),n2h1(137))
  call Hloop_WA_Q(ntryL,G1H2(276),ex4(:),G1H1(1),m3h2x1(:,138),heltab2x2(:,:,138))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,nMT,G2tensor(138),n2h1(138))
  call Hloop_SQ_A(ntryL,G1H2(277),ex3(:),G1H1(1),ngPtb,m3h2x1(:,139),heltab2x2(:,:,139))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,nMT,G2tensor(139),n2h1(139))
  call Hloop_SQ_A(ntryL,G1H2(278),ex3(:),G1H1(1),ngPtb,m3h2x1(:,140),heltab2x2(:,:,140))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),4,nMT,G2tensor(140),n2h1(140))
  call Hloop_SQ_A(ntryL,G1H2(282),ex3(:),G1H1(1),ngPtb,m3h2x1(:,141),heltab2x2(:,:,141))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,nMT,G2tensor(141),n2h1(141))
  call Hloop_SQ_A(ntryL,G1H2(283),ex3(:),G1H1(1),ngH,m3h2x1(:,142),heltab2x2(:,:,142))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,nMB,G2tensor(142),n2h1(142))
  call Hloop_SQ_A(ntryL,G1H2(284),ex3(:),G1H1(1),ngH,m3h2x1(:,143),heltab2x2(:,:,143))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),4,nMB,G2tensor(143),n2h1(143))
  call Hloop_SQ_A(ntryL,G1H2(288),ex3(:),G1H1(1),ngH,m3h2x1(:,144),heltab2x2(:,:,144))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,nMB,G2tensor(144),n2h1(144))
  call Hloop_SQ_A(ntryL,G1H2(289),ex3(:),G1H1(1),ngPtb,m3h2x1(:,145),heltab2x2(:,:,145))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,nMT,G2tensor(145),n2h1(145))
  call Hloop_SQ_A(ntryL,G1H2(290),ex3(:),G1H1(1),ngPtb,m3h2x1(:,146),heltab2x2(:,:,146))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),4,nMT,G2tensor(146),n2h1(146))
  call Hloop_SQ_A(ntryL,G1H2(294),ex3(:),G1H1(1),ngPtb,m3h2x1(:,147),heltab2x2(:,:,147))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,nMT,G2tensor(147),n2h1(147))
  call Hloop_SQ_A(ntryL,G1H2(295),ex3(:),G1H1(1),ngX,m3h2x1(:,148),heltab2x2(:,:,148))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,nMB,G2tensor(148),n2h1(148))
  call Hloop_SQ_A(ntryL,G1H2(296),ex3(:),G1H1(1),ngX,m3h2x1(:,149),heltab2x2(:,:,149))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),4,nMB,G2tensor(149),n2h1(149))
  call Hloop_SQ_A(ntryL,G1H2(300),ex3(:),G1H1(1),ngX,m3h2x1(:,150),heltab2x2(:,:,150))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,nMB,G2tensor(150),n2h1(150))
  call Hloop_SQ_A(ntryL,G1H2(301),ex3(:),G1H1(1),ngPtb,m3h2x1(:,151),heltab2x2(:,:,151))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,nMT,G2tensor(151),n2h1(151))
  call Hloop_SQ_A(ntryL,G1H2(302),ex3(:),G1H1(1),ngPtb,m3h2x1(:,152),heltab2x2(:,:,152))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),4,nMT,G2tensor(152),n2h1(152))
  call Hloop_SQ_A(ntryL,G1H2(306),ex3(:),G1H1(1),ngPtb,m3h2x1(:,153),heltab2x2(:,:,153))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,nMT,G2tensor(153),n2h1(153))
  call Hloop_VQ_A(ntryL,G1H2(307),ex3(:),G1H1(1),m3h2x1(:,154),heltab2x2(:,:,154))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,nMB,G2tensor(154),n2h1(154))
  call Hloop_VQ_A(ntryL,G1H2(308),ex3(:),G1H1(1),m3h2x1(:,155),heltab2x2(:,:,155))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),4,nMB,G2tensor(155),n2h1(155))
  call Hloop_VQ_A(ntryL,G1H2(312),ex3(:),G1H1(1),m3h2x1(:,156),heltab2x2(:,:,156))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,nMB,G2tensor(156),n2h1(156))
  call Hloop_ZQ_A(ntryL,G1H2(313),ex3(:),G1H1(1),ngZd,m3h2x1(:,157),heltab2x2(:,:,157))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,nMB,G2tensor(157),n2h1(157))
  call Hloop_ZQ_A(ntryL,G1H2(314),ex3(:),G1H1(1),ngZd,m3h2x1(:,158),heltab2x2(:,:,158))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),4,nMB,G2tensor(158),n2h1(158))
  call Hloop_ZQ_A(ntryL,G1H2(318),ex3(:),G1H1(1),ngZd,m3h2x1(:,159),heltab2x2(:,:,159))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,nMB,G2tensor(159),n2h1(159))
  call Hloop_WQ_A(ntryL,G1H2(319),ex3(:),G1H1(1),m3h2x1(:,160),heltab2x2(:,:,160))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,nMT,G2tensor(160),n2h1(160))
  call Hloop_WQ_A(ntryL,G1H2(320),ex3(:),G1H1(1),m3h2x1(:,161),heltab2x2(:,:,161))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),4,nMT,G2tensor(161),n2h1(161))
  call Hloop_WQ_A(ntryL,G1H2(324),ex3(:),G1H1(1),m3h2x1(:,162),heltab2x2(:,:,162))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,nMT,G2tensor(162),n2h1(162))
  call Hloop_WQ_A(ntryL,G1H2(325),ex3(:),G1H1(1),m3h2x1(:,163),heltab2x2(:,:,163))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,nMT,G2tensor(163),n2h1(163))
  call Hloop_WQ_A(ntryL,G1H2(326),ex3(:),G1H1(1),m3h2x1(:,164),heltab2x2(:,:,164))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),4,nMT,G2tensor(164),n2h1(164))
  call Hloop_WQ_A(ntryL,G1H2(330),ex3(:),G1H1(1),m3h2x1(:,165),heltab2x2(:,:,165))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,nMT,G2tensor(165),n2h1(165))
  call Hloop_WQ_A(ntryL,G1H2(331),ex3(:),G1H1(1),m3h2x1(:,166),heltab2x2(:,:,166))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,nMT,G2tensor(166),n2h1(166))
  call Hloop_WQ_A(ntryL,G1H2(332),ex3(:),G1H1(1),m3h2x1(:,167),heltab2x2(:,:,167))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),4,nMT,G2tensor(167),n2h1(167))
  call Hloop_WQ_A(ntryL,G1H2(336),ex3(:),G1H1(1),m3h2x1(:,168),heltab2x2(:,:,168))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,nMT,G2tensor(168),n2h1(168))
  call Hloop_SA_Q(ntryL,G1H2(337),ex4(:),G1H1(1),ngPbt,m3h2x1(:,169),heltab2x2(:,:,169))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,nMT,G2tensor(169),n2h1(169))
  call Hloop_SA_Q(ntryL,G1H2(338),ex4(:),G1H1(1),ngPbt,m3h2x1(:,170),heltab2x2(:,:,170))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),8,nMT,G2tensor(170),n2h1(170))
  call Hloop_SA_Q(ntryL,G1H2(342),ex4(:),G1H1(1),ngPbt,m3h2x1(:,171),heltab2x2(:,:,171))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,nMT,G2tensor(171),n2h1(171))
  call Hloop_SA_Q(ntryL,G1H2(343),ex4(:),G1H1(1),ngH,m3h2x1(:,172),heltab2x2(:,:,172))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,nMB,G2tensor(172),n2h1(172))
  call Hloop_SA_Q(ntryL,G1H2(344),ex4(:),G1H1(1),ngH,m3h2x1(:,173),heltab2x2(:,:,173))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),8,nMB,G2tensor(173),n2h1(173))
  call Hloop_SA_Q(ntryL,G1H2(348),ex4(:),G1H1(1),ngH,m3h2x1(:,174),heltab2x2(:,:,174))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,nMB,G2tensor(174),n2h1(174))
  call Hloop_SA_Q(ntryL,G1H2(349),ex4(:),G1H1(1),ngPbt,m3h2x1(:,175),heltab2x2(:,:,175))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,nMT,G2tensor(175),n2h1(175))
  call Hloop_SA_Q(ntryL,G1H2(350),ex4(:),G1H1(1),ngPbt,m3h2x1(:,176),heltab2x2(:,:,176))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),8,nMT,G2tensor(176),n2h1(176))
  call Hloop_SA_Q(ntryL,G1H2(354),ex4(:),G1H1(1),ngPbt,m3h2x1(:,177),heltab2x2(:,:,177))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,nMT,G2tensor(177),n2h1(177))
  call Hloop_SA_Q(ntryL,G1H2(355),ex4(:),G1H1(1),ngX,m3h2x1(:,178),heltab2x2(:,:,178))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,nMB,G2tensor(178),n2h1(178))
  call Hloop_SA_Q(ntryL,G1H2(356),ex4(:),G1H1(1),ngX,m3h2x1(:,179),heltab2x2(:,:,179))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),8,nMB,G2tensor(179),n2h1(179))
  call Hloop_SA_Q(ntryL,G1H2(360),ex4(:),G1H1(1),ngX,m3h2x1(:,180),heltab2x2(:,:,180))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,nMB,G2tensor(180),n2h1(180))
  call Hloop_VA_Q(ntryL,G1H2(361),ex4(:),G1H1(1),m3h2x1(:,181),heltab2x2(:,:,181))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,nMB,G2tensor(181),n2h1(181))
  call Hloop_VA_Q(ntryL,G1H2(362),ex4(:),G1H1(1),m3h2x1(:,182),heltab2x2(:,:,182))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),8,nMB,G2tensor(182),n2h1(182))
  call Hloop_VA_Q(ntryL,G1H2(366),ex4(:),G1H1(1),m3h2x1(:,183),heltab2x2(:,:,183))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,nMB,G2tensor(183),n2h1(183))
  call Hloop_ZA_Q(ntryL,G1H2(367),ex4(:),G1H1(1),ngZd,m3h2x1(:,184),heltab2x2(:,:,184))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,nMB,G2tensor(184),n2h1(184))
  call Hloop_ZA_Q(ntryL,G1H2(368),ex4(:),G1H1(1),ngZd,m3h2x1(:,185),heltab2x2(:,:,185))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),8,nMB,G2tensor(185),n2h1(185))
  call Hloop_ZA_Q(ntryL,G1H2(372),ex4(:),G1H1(1),ngZd,m3h2x1(:,186),heltab2x2(:,:,186))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,nMB,G2tensor(186),n2h1(186))
  call Hloop_WA_Q(ntryL,G1H2(373),ex4(:),G1H1(1),m3h2x1(:,187),heltab2x2(:,:,187))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,nMT,G2tensor(187),n2h1(187))
  call Hloop_WA_Q(ntryL,G1H2(374),ex4(:),G1H1(1),m3h2x1(:,188),heltab2x2(:,:,188))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),8,nMT,G2tensor(188),n2h1(188))
  call Hloop_WA_Q(ntryL,G1H2(378),ex4(:),G1H1(1),m3h2x1(:,189),heltab2x2(:,:,189))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,nMT,G2tensor(189),n2h1(189))
  call Hloop_WA_Q(ntryL,G1H2(379),ex4(:),G1H1(1),m3h2x1(:,190),heltab2x2(:,:,190))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,nMT,G2tensor(190),n2h1(190))
  call Hloop_WA_Q(ntryL,G1H2(380),ex4(:),G1H1(1),m3h2x1(:,191),heltab2x2(:,:,191))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),8,nMT,G2tensor(191),n2h1(191))
  call Hloop_WA_Q(ntryL,G1H2(384),ex4(:),G1H1(1),m3h2x1(:,192),heltab2x2(:,:,192))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,nMT,G2tensor(192),n2h1(192))
  call Hloop_SA_Q(ntryL,G1H2(385),ex4(:),G1H1(1),ngPbt,m3h2x1(:,193),heltab2x2(:,:,193))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,nMT,G2tensor(193),n2h1(193))
  call Hloop_SA_Q(ntryL,G1H2(386),ex4(:),G1H1(1),ngPbt,m3h2x1(:,194),heltab2x2(:,:,194))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),8,nMT,G2tensor(194),n2h1(194))
  call Hloop_SA_Q(ntryL,G1H2(390),ex4(:),G1H1(1),ngPbt,m3h2x1(:,195),heltab2x2(:,:,195))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,nMT,G2tensor(195),n2h1(195))
  call Hloop_WA_Q(ntryL,G1H2(391),ex4(:),G1H1(1),m3h2x1(:,196),heltab2x2(:,:,196))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,nMT,G2tensor(196),n2h1(196))
  call Hloop_WA_Q(ntryL,G1H2(392),ex4(:),G1H1(1),m3h2x1(:,197),heltab2x2(:,:,197))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),8,nMT,G2tensor(197),n2h1(197))
  call Hloop_WA_Q(ntryL,G1H2(396),ex4(:),G1H1(1),m3h2x1(:,198),heltab2x2(:,:,198))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,nMT,G2tensor(198),n2h1(198))
  call Hloop_SA_Q(ntryL,G1H2(397),ex2(:),G1H1(1),ngH,m3h2x1(:,199),heltab2x2(:,:,199))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,nMT,G2tensor(199),n2h1(199))
  call Hloop_SA_Q(ntryL,G1H2(398),ex2(:),G1H1(1),ngH,m3h2x1(:,200),heltab2x2(:,:,200))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),2,nMT,G2tensor(200),n2h1(200))
  call Hloop_SA_Q(ntryL,G1H2(402),ex2(:),G1H1(1),ngH,m3h2x1(:,201),heltab2x2(:,:,201))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,nMT,G2tensor(201),n2h1(201))
  call Hloop_SA_Q(ntryL,G1H2(403),ex2(:),G1H1(1),ngX,m3h2x1(:,202),heltab2x2(:,:,202))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,nMT,G2tensor(202),n2h1(202))
  call Hloop_SA_Q(ntryL,G1H2(404),ex2(:),G1H1(1),ngX,m3h2x1(:,203),heltab2x2(:,:,203))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),2,nMT,G2tensor(203),n2h1(203))
  call Hloop_SA_Q(ntryL,G1H2(408),ex2(:),G1H1(1),ngX,m3h2x1(:,204),heltab2x2(:,:,204))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,nMT,G2tensor(204),n2h1(204))
  call Hloop_SA_Q(ntryL,G1H2(409),ex2(:),G1H1(1),ngH,m3h2x1(:,205),heltab2x2(:,:,205))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,nMT,G2tensor(205),n2h1(205))
  call Hloop_SA_Q(ntryL,G1H2(410),ex2(:),G1H1(1),ngH,m3h2x1(:,206),heltab2x2(:,:,206))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),2,nMT,G2tensor(206),n2h1(206))
  call Hloop_SA_Q(ntryL,G1H2(414),ex2(:),G1H1(1),ngH,m3h2x1(:,207),heltab2x2(:,:,207))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,nMT,G2tensor(207),n2h1(207))
  call Hloop_SA_Q(ntryL,G1H2(415),ex2(:),G1H1(1),ngX,m3h2x1(:,208),heltab2x2(:,:,208))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,nMT,G2tensor(208),n2h1(208))
  call Hloop_SA_Q(ntryL,G1H2(416),ex2(:),G1H1(1),ngX,m3h2x1(:,209),heltab2x2(:,:,209))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),2,nMT,G2tensor(209),n2h1(209))
  call Hloop_SA_Q(ntryL,G1H2(420),ex2(:),G1H1(1),ngX,m3h2x1(:,210),heltab2x2(:,:,210))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,nMT,G2tensor(210),n2h1(210))
  call Hloop_SA_Q(ntryL,G1H2(421),ex2(:),G1H1(1),ngPtb,m3h2x1(:,211),heltab2x2(:,:,211))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,nMB,G2tensor(211),n2h1(211))
  call Hloop_SA_Q(ntryL,G1H2(422),ex2(:),G1H1(1),ngPtb,m3h2x1(:,212),heltab2x2(:,:,212))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),2,nMB,G2tensor(212),n2h1(212))
  call Hloop_SA_Q(ntryL,G1H2(426),ex2(:),G1H1(1),ngPtb,m3h2x1(:,213),heltab2x2(:,:,213))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,nMB,G2tensor(213),n2h1(213))
  call Hloop_VA_Q(ntryL,G1H2(427),ex2(:),G1H1(1),m3h2x1(:,214),heltab2x2(:,:,214))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,nMT,G2tensor(214),n2h1(214))
  call Hloop_VA_Q(ntryL,G1H2(428),ex2(:),G1H1(1),m3h2x1(:,215),heltab2x2(:,:,215))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),2,nMT,G2tensor(215),n2h1(215))
  call Hloop_VA_Q(ntryL,G1H2(432),ex2(:),G1H1(1),m3h2x1(:,216),heltab2x2(:,:,216))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,nMT,G2tensor(216),n2h1(216))
  call Hloop_VA_Q(ntryL,G1H2(433),ex2(:),G1H1(1),m3h2x1(:,217),heltab2x2(:,:,217))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,nMT,G2tensor(217),n2h1(217))
  call Hloop_VA_Q(ntryL,G1H2(434),ex2(:),G1H1(1),m3h2x1(:,218),heltab2x2(:,:,218))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),2,nMT,G2tensor(218),n2h1(218))
  call Hloop_VA_Q(ntryL,G1H2(438),ex2(:),G1H1(1),m3h2x1(:,219),heltab2x2(:,:,219))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,nMT,G2tensor(219),n2h1(219))
  call Hloop_ZA_Q(ntryL,G1H2(439),ex2(:),G1H1(1),ngZu,m3h2x1(:,220),heltab2x2(:,:,220))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,nMT,G2tensor(220),n2h1(220))
  call Hloop_ZA_Q(ntryL,G1H2(440),ex2(:),G1H1(1),ngZu,m3h2x1(:,221),heltab2x2(:,:,221))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),2,nMT,G2tensor(221),n2h1(221))
  call Hloop_ZA_Q(ntryL,G1H2(444),ex2(:),G1H1(1),ngZu,m3h2x1(:,222),heltab2x2(:,:,222))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,nMT,G2tensor(222),n2h1(222))
  call Hloop_ZA_Q(ntryL,G1H2(445),ex2(:),G1H1(1),ngZu,m3h2x1(:,223),heltab2x2(:,:,223))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,nMT,G2tensor(223),n2h1(223))
  call Hloop_ZA_Q(ntryL,G1H2(446),ex2(:),G1H1(1),ngZu,m3h2x1(:,224),heltab2x2(:,:,224))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),2,nMT,G2tensor(224),n2h1(224))
  call Hloop_ZA_Q(ntryL,G1H2(450),ex2(:),G1H1(1),ngZu,m3h2x1(:,225),heltab2x2(:,:,225))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,nMT,G2tensor(225),n2h1(225))
  call Hloop_WA_Q(ntryL,G1H2(451),ex2(:),G1H1(1),m3h2x1(:,226),heltab2x2(:,:,226))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,nMB,G2tensor(226),n2h1(226))
  call Hloop_WA_Q(ntryL,G1H2(452),ex2(:),G1H1(1),m3h2x1(:,227),heltab2x2(:,:,227))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),2,nMB,G2tensor(227),n2h1(227))
  call Hloop_WA_Q(ntryL,G1H2(456),ex2(:),G1H1(1),m3h2x1(:,228),heltab2x2(:,:,228))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,nMB,G2tensor(228),n2h1(228))
  call Hloop_SA_Q(ntryL,G1H2(457),ex2(:),G1H1(1),ngH,m3h2x1(:,229),heltab2x2(:,:,229))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,nMT,G2tensor(229),n2h1(229))
  call Hloop_SA_Q(ntryL,G1H2(458),ex2(:),G1H1(1),ngH,m3h2x1(:,230),heltab2x2(:,:,230))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),2,nMT,G2tensor(230),n2h1(230))
  call Hloop_SA_Q(ntryL,G1H2(462),ex2(:),G1H1(1),ngH,m3h2x1(:,231),heltab2x2(:,:,231))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,nMT,G2tensor(231),n2h1(231))
  call Hloop_SA_Q(ntryL,G1H2(463),ex2(:),G1H1(1),ngX,m3h2x1(:,232),heltab2x2(:,:,232))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,nMT,G2tensor(232),n2h1(232))
  call Hloop_SA_Q(ntryL,G1H2(464),ex2(:),G1H1(1),ngX,m3h2x1(:,233),heltab2x2(:,:,233))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),2,nMT,G2tensor(233),n2h1(233))
  call Hloop_SA_Q(ntryL,G1H2(468),ex2(:),G1H1(1),ngX,m3h2x1(:,234),heltab2x2(:,:,234))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,nMT,G2tensor(234),n2h1(234))
  call Hloop_VA_Q(ntryL,G1H2(469),ex2(:),G1H1(1),m3h2x1(:,235),heltab2x2(:,:,235))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,nMT,G2tensor(235),n2h1(235))
  call Hloop_VA_Q(ntryL,G1H2(470),ex2(:),G1H1(1),m3h2x1(:,236),heltab2x2(:,:,236))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),2,nMT,G2tensor(236),n2h1(236))
  call Hloop_VA_Q(ntryL,G1H2(474),ex2(:),G1H1(1),m3h2x1(:,237),heltab2x2(:,:,237))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,nMT,G2tensor(237),n2h1(237))
  call Hloop_ZA_Q(ntryL,G1H2(475),ex2(:),G1H1(1),ngZu,m3h2x1(:,238),heltab2x2(:,:,238))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,nMT,G2tensor(238),n2h1(238))
  call Hloop_ZA_Q(ntryL,G1H2(476),ex2(:),G1H1(1),ngZu,m3h2x1(:,239),heltab2x2(:,:,239))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),2,nMT,G2tensor(239),n2h1(239))
  call Hloop_ZA_Q(ntryL,G1H2(480),ex2(:),G1H1(1),ngZu,m3h2x1(:,240),heltab2x2(:,:,240))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,nMT,G2tensor(240),n2h1(240))
  call Hloop_SA_Q(ntryL,G1H2(481),ex2(:),G1H1(1),ngH,m3h2x1(:,241),heltab2x2(:,:,241))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,nMT,G2tensor(241),n2h1(241))
  call Hloop_SA_Q(ntryL,G1H2(482),ex2(:),G1H1(1),ngH,m3h2x1(:,242),heltab2x2(:,:,242))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),2,nMT,G2tensor(242),n2h1(242))
  call Hloop_SA_Q(ntryL,G1H2(486),ex2(:),G1H1(1),ngH,m3h2x1(:,243),heltab2x2(:,:,243))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,nMT,G2tensor(243),n2h1(243))
  call Hloop_SA_Q(ntryL,G1H2(487),ex2(:),G1H1(1),ngX,m3h2x1(:,244),heltab2x2(:,:,244))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,nMT,G2tensor(244),n2h1(244))
  call Hloop_SA_Q(ntryL,G1H2(488),ex2(:),G1H1(1),ngX,m3h2x1(:,245),heltab2x2(:,:,245))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),2,nMT,G2tensor(245),n2h1(245))
  call Hloop_SA_Q(ntryL,G1H2(492),ex2(:),G1H1(1),ngX,m3h2x1(:,246),heltab2x2(:,:,246))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,nMT,G2tensor(246),n2h1(246))
  call Hloop_SA_Q(ntryL,G1H2(493),ex2(:),G1H1(1),ngH,m3h2x1(:,247),heltab2x2(:,:,247))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,nMT,G2tensor(247),n2h1(247))
  call Hloop_SA_Q(ntryL,G1H2(494),ex2(:),G1H1(1),ngH,m3h2x1(:,248),heltab2x2(:,:,248))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),2,nMT,G2tensor(248),n2h1(248))
  call Hloop_SA_Q(ntryL,G1H2(498),ex2(:),G1H1(1),ngH,m3h2x1(:,249),heltab2x2(:,:,249))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,nMT,G2tensor(249),n2h1(249))
  call Hloop_SA_Q(ntryL,G1H2(499),ex2(:),G1H1(1),ngX,m3h2x1(:,250),heltab2x2(:,:,250))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,nMT,G2tensor(250),n2h1(250))
  call Hloop_SA_Q(ntryL,G1H2(500),ex2(:),G1H1(1),ngX,m3h2x1(:,251),heltab2x2(:,:,251))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),2,nMT,G2tensor(251),n2h1(251))
  call Hloop_SA_Q(ntryL,G1H2(504),ex2(:),G1H1(1),ngX,m3h2x1(:,252),heltab2x2(:,:,252))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,nMT,G2tensor(252),n2h1(252))
  call Hloop_VA_Q(ntryL,G1H2(505),ex2(:),G1H1(1),m3h2x1(:,253),heltab2x2(:,:,253))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,nMT,G2tensor(253),n2h1(253))
  call Hloop_VA_Q(ntryL,G1H2(506),ex2(:),G1H1(1),m3h2x1(:,254),heltab2x2(:,:,254))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),2,nMT,G2tensor(254),n2h1(254))
  call Hloop_VA_Q(ntryL,G1H2(510),ex2(:),G1H1(1),m3h2x1(:,255),heltab2x2(:,:,255))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,nMT,G2tensor(255),n2h1(255))
  call Hloop_VA_Q(ntryL,G1H2(511),ex2(:),G1H1(1),m3h2x1(:,256),heltab2x2(:,:,256))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,nMT,G2tensor(256),n2h1(256))
  call Hloop_VA_Q(ntryL,G1H2(512),ex2(:),G1H1(1),m3h2x1(:,257),heltab2x2(:,:,257))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),2,nMT,G2tensor(257),n2h1(257))
  call Hloop_VA_Q(ntryL,G1H2(516),ex2(:),G1H1(1),m3h2x1(:,258),heltab2x2(:,:,258))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,nMT,G2tensor(258),n2h1(258))
  call Hloop_ZA_Q(ntryL,G1H2(517),ex2(:),G1H1(1),ngZu,m3h2x1(:,259),heltab2x2(:,:,259))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,nMT,G2tensor(259),n2h1(259))
  call Hloop_ZA_Q(ntryL,G1H2(518),ex2(:),G1H1(1),ngZu,m3h2x1(:,260),heltab2x2(:,:,260))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),2,nMT,G2tensor(260),n2h1(260))
  call Hloop_ZA_Q(ntryL,G1H2(522),ex2(:),G1H1(1),ngZu,m3h2x1(:,261),heltab2x2(:,:,261))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,nMT,G2tensor(261),n2h1(261))
  call Hloop_ZA_Q(ntryL,G1H2(523),ex2(:),G1H1(1),ngZu,m3h2x1(:,262),heltab2x2(:,:,262))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,nMT,G2tensor(262),n2h1(262))
  call Hloop_ZA_Q(ntryL,G1H2(524),ex2(:),G1H1(1),ngZu,m3h2x1(:,263),heltab2x2(:,:,263))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),2,nMT,G2tensor(263),n2h1(263))
  call Hloop_ZA_Q(ntryL,G1H2(528),ex2(:),G1H1(1),ngZu,m3h2x1(:,264),heltab2x2(:,:,264))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,nMT,G2tensor(264),n2h1(264))
  call Hloop_SA_Q(ntryL,G1H2(529),ex2(:),G1H1(1),ngH,m3h2x1(:,265),heltab2x2(:,:,265))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,nMT,G2tensor(265),n2h1(265))
  call Hloop_SA_Q(ntryL,G1H2(530),ex2(:),G1H1(1),ngH,m3h2x1(:,266),heltab2x2(:,:,266))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),2,nMT,G2tensor(266),n2h1(266))
  call Hloop_SA_Q(ntryL,G1H2(534),ex2(:),G1H1(1),ngH,m3h2x1(:,267),heltab2x2(:,:,267))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,nMT,G2tensor(267),n2h1(267))
  call Hloop_SA_Q(ntryL,G1H2(535),ex2(:),G1H1(1),ngX,m3h2x1(:,268),heltab2x2(:,:,268))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,nMT,G2tensor(268),n2h1(268))
  call Hloop_SA_Q(ntryL,G1H2(536),ex2(:),G1H1(1),ngX,m3h2x1(:,269),heltab2x2(:,:,269))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),2,nMT,G2tensor(269),n2h1(269))
  call Hloop_SA_Q(ntryL,G1H2(540),ex2(:),G1H1(1),ngX,m3h2x1(:,270),heltab2x2(:,:,270))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,nMT,G2tensor(270),n2h1(270))
  call Hloop_VA_Q(ntryL,G1H2(541),ex2(:),G1H1(1),m3h2x1(:,271),heltab2x2(:,:,271))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,nMT,G2tensor(271),n2h1(271))
  call Hloop_VA_Q(ntryL,G1H2(542),ex2(:),G1H1(1),m3h2x1(:,272),heltab2x2(:,:,272))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),2,nMT,G2tensor(272),n2h1(272))
  call Hloop_VA_Q(ntryL,G1H2(546),ex2(:),G1H1(1),m3h2x1(:,273),heltab2x2(:,:,273))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,nMT,G2tensor(273),n2h1(273))
  call Hloop_ZA_Q(ntryL,G1H2(547),ex2(:),G1H1(1),ngZu,m3h2x1(:,274),heltab2x2(:,:,274))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,nMT,G2tensor(274),n2h1(274))
  call Hloop_ZA_Q(ntryL,G1H2(548),ex2(:),G1H1(1),ngZu,m3h2x1(:,275),heltab2x2(:,:,275))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),2,nMT,G2tensor(275),n2h1(275))
  call Hloop_ZA_Q(ntryL,G1H2(552),ex2(:),G1H1(1),ngZu,m3h2x1(:,276),heltab2x2(:,:,276))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,nMT,G2tensor(276),n2h1(276))
  call ol_merge_tensors(G2tensor(22),[G2tensor(4)])
  call ol_merge_tensors(G2tensor(25),[G2tensor(10)])
  call ol_merge_tensors(G2tensor(28),[G2tensor(13)])
  call ol_merge_tensors(G2tensor(40),[G2tensor(34)])
  call ol_merge_tensors(G2tensor(67),[G2tensor(49)])
  call ol_merge_tensors(G2tensor(70),[G2tensor(52)])
  call ol_merge_tensors(G2tensor(76),[G2tensor(58)])
  call ol_merge_tensors(G2tensor(97),[G2tensor(79)])
  call ol_merge_tensors(G2tensor(100),[G2tensor(85)])
  call ol_merge_tensors(G2tensor(94),[G2tensor(88)])
  call ol_merge_tensors(G2tensor(106),[G2tensor(103)])
  call ol_merge_tensors(G2tensor(127),[G2tensor(109)])
  call ol_merge_tensors(G2tensor(130),[G2tensor(115)])
  call ol_merge_tensors(G2tensor(124),[G2tensor(118)])
  call ol_merge_tensors(G2tensor(136),[G2tensor(133)])
  call ol_merge_tensors(G2tensor(160),[G2tensor(139)])
  call ol_merge_tensors(G2tensor(163),[G2tensor(145)])
  call ol_merge_tensors(G2tensor(157),[G2tensor(148)])
  call ol_merge_tensors(G2tensor(166),[G2tensor(151)])
  call ol_merge_tensors(G2tensor(187),[G2tensor(169)])
  call ol_merge_tensors(G2tensor(190),[G2tensor(175)])
  call ol_merge_tensors(G2tensor(184),[G2tensor(178)])
  call ol_merge_tensors(G2tensor(196),[G2tensor(193)])
  call ol_merge_tensors(G2tensor(220),[G2tensor(202)])
  call ol_merge_tensors(G2tensor(223),[G2tensor(208)])
  call ol_merge_tensors(G2tensor(226),[G2tensor(211)])
  call ol_merge_tensors(G2tensor(238),[G2tensor(232)])
  call ol_merge_tensors(G2tensor(259),[G2tensor(244)])
  call ol_merge_tensors(G2tensor(262),[G2tensor(250)])
  call ol_merge_tensors(G2tensor(274),[G2tensor(268)])
  call Hotf_5pt_reduction_last(G2tensor(1),RedSet_5(1),mass5set(:,1),  & 
G1tensor(1),G1tensor(2),G1tensor(3),G1tensor(4),G1tensor(5),G1tensor(6))
  call G_TensorShift(G1tensor(2),8)
  call Hotf_5pt_reduction_last(G2tensor(22),RedSet_5(1),mass5set(:,2),  & 
G1tensor(7),G1tensor(8),G1tensor(9),G1tensor(10),G1tensor(11),G1tensor(12))
  call G_TensorShift(G1tensor(8),8)
  call Hotf_5pt_reduction_last(G2tensor(7),RedSet_5(1),mass5set(:,3),  & 
G1tensor(13),G1tensor(14),G1tensor(15),G1tensor(16),G1tensor(17),G1tensor(18))
  call G_TensorShift(G1tensor(14),8)
  call Hotf_5pt_reduction_last(G2tensor(25),RedSet_5(1),mass5set(:,4),  & 
G1tensor(19),G1tensor(20),G1tensor(21),G1tensor(22),G1tensor(23),G1tensor(24))
  call G_TensorShift(G1tensor(20),8)
  call Hotf_5pt_reduction_last(G2tensor(28),RedSet_5(1),mass5set(:,5),  & 
G1tensor(25),G1tensor(26),G1tensor(27),G1tensor(28),G1tensor(29),G1tensor(30))
  call G_TensorShift(G1tensor(26),8)
  call Hotf_5pt_reduction_last(G2tensor(16),RedSet_5(1),mass5set(:,6),  & 
G1tensor(31),G1tensor(32),G1tensor(33),G1tensor(34),G1tensor(35),G1tensor(36))
  call G_TensorShift(G1tensor(32),8)
  call Hotf_5pt_reduction_last(G2tensor(19),RedSet_5(1),mass5set(:,7),  & 
G1tensor(37),G1tensor(38),G1tensor(39),G1tensor(40),G1tensor(41),G1tensor(42))
  call G_TensorShift(G1tensor(38),8)
  call Hotf_5pt_reduction_last(G2tensor(31),RedSet_5(1),mass5set(:,8),  & 
G1tensor(43),G1tensor(44),G1tensor(45),G1tensor(46),G1tensor(47),G1tensor(48))
  call G_TensorShift(G1tensor(44),8)
  call Hotf_5pt_reduction_last(G2tensor(40),RedSet_5(1),mass5set(:,9),  & 
G1tensor(49),G1tensor(50),G1tensor(51),G1tensor(52),G1tensor(53),G1tensor(54))
  call G_TensorShift(G1tensor(50),8)
  call Hotf_5pt_reduction_last(G2tensor(37),RedSet_5(1),mass5set(:,10),  & 
G1tensor(55),G1tensor(56),G1tensor(57),G1tensor(58),G1tensor(59),G1tensor(60))
  call G_TensorShift(G1tensor(56),8)
  call Hotf_5pt_reduction_last(G2tensor(43),RedSet_5(2),mass5set(:,1),  & 
G1tensor(61),G1tensor(62),G1tensor(63),G1tensor(64),G1tensor(65),G1tensor(66))
  call G_TensorShift(G1tensor(62),8)
  call Hotf_5pt_reduction_last(G2tensor(46),RedSet_5(2),mass5set(:,3),  & 
G1tensor(67),G1tensor(68),G1tensor(69),G1tensor(70),G1tensor(71),G1tensor(72))
  call G_TensorShift(G1tensor(68),8)
  call Hotf_5pt_reduction_last(G2tensor(67),RedSet_5(2),mass5set(:,2),  & 
G1tensor(73),G1tensor(74),G1tensor(75),G1tensor(76),G1tensor(77),G1tensor(78))
  call G_TensorShift(G1tensor(74),8)
  call Hotf_5pt_reduction_last(G2tensor(70),RedSet_5(2),mass5set(:,4),  & 
G1tensor(79),G1tensor(80),G1tensor(81),G1tensor(82),G1tensor(83),G1tensor(84))
  call G_TensorShift(G1tensor(80),8)
  call Hotf_5pt_reduction_last(G2tensor(55),RedSet_5(2),mass5set(:,8),  & 
G1tensor(85),G1tensor(86),G1tensor(87),G1tensor(88),G1tensor(89),G1tensor(90))
  call G_TensorShift(G1tensor(86),8)
  call Hotf_5pt_reduction_last(G2tensor(76),RedSet_5(2),mass5set(:,9),  & 
G1tensor(91),G1tensor(92),G1tensor(93),G1tensor(94),G1tensor(95),G1tensor(96))
  call G_TensorShift(G1tensor(92),8)
  call Hotf_5pt_reduction_last(G2tensor(61),RedSet_5(2),mass5set(:,6),  & 
G1tensor(97),G1tensor(98),G1tensor(99),G1tensor(100),G1tensor(101),G1tensor(102))
  call G_TensorShift(G1tensor(98),8)
  call Hotf_5pt_reduction_last(G2tensor(64),RedSet_5(2),mass5set(:,7),  & 
G1tensor(103),G1tensor(104),G1tensor(105),G1tensor(106),G1tensor(107),G1tensor(108))
  call G_TensorShift(G1tensor(104),8)
  call Hotf_5pt_reduction_last(G2tensor(73),RedSet_5(2),mass5set(:,10),  & 
G1tensor(109),G1tensor(110),G1tensor(111),G1tensor(112),G1tensor(113),G1tensor(114))
  call G_TensorShift(G1tensor(110),8)
  call Hotf_5pt_reduction_last(G2tensor(97),RedSet_5(3),mass5set(:,11),  & 
G1tensor(115),G1tensor(116),G1tensor(117),G1tensor(118),G1tensor(119),G1tensor(120))
  call G_TensorShift(G1tensor(116),4)
  call Hotf_5pt_reduction_last(G2tensor(82),RedSet_5(3),mass5set(:,12),  & 
G1tensor(121),G1tensor(122),G1tensor(123),G1tensor(124),G1tensor(125),G1tensor(126))
  call G_TensorShift(G1tensor(122),4)
  call Hotf_5pt_reduction_last(G2tensor(100),RedSet_5(3),mass5set(:,13),  & 
G1tensor(127),G1tensor(128),G1tensor(129),G1tensor(130),G1tensor(131),G1tensor(132))
  call G_TensorShift(G1tensor(128),4)
  call Hotf_5pt_reduction_last(G2tensor(94),RedSet_5(3),mass5set(:,14),  & 
G1tensor(133),G1tensor(134),G1tensor(135),G1tensor(136),G1tensor(137),G1tensor(138))
  call G_TensorShift(G1tensor(134),4)
  call Hotf_5pt_reduction_last(G2tensor(91),RedSet_5(3),mass5set(:,15),  & 
G1tensor(139),G1tensor(140),G1tensor(141),G1tensor(142),G1tensor(143),G1tensor(144))
  call G_TensorShift(G1tensor(140),4)
  call Hotf_5pt_reduction_last(G2tensor(106),RedSet_5(3),mass5set(:,16),  & 
G1tensor(145),G1tensor(146),G1tensor(147),G1tensor(148),G1tensor(149),G1tensor(150))
  call G_TensorShift(G1tensor(146),4)
  call Hotf_5pt_reduction_last(G2tensor(127),RedSet_5(4),mass5set(:,11),  & 
G1tensor(151),G1tensor(152),G1tensor(153),G1tensor(154),G1tensor(155),G1tensor(156))
  call G_TensorShift(G1tensor(152),8)
  call Hotf_5pt_reduction_last(G2tensor(112),RedSet_5(4),mass5set(:,12),  & 
G1tensor(157),G1tensor(158),G1tensor(159),G1tensor(160),G1tensor(161),G1tensor(162))
  call G_TensorShift(G1tensor(158),8)
  call Hotf_5pt_reduction_last(G2tensor(130),RedSet_5(4),mass5set(:,13),  & 
G1tensor(163),G1tensor(164),G1tensor(165),G1tensor(166),G1tensor(167),G1tensor(168))
  call G_TensorShift(G1tensor(164),8)
  call Hotf_5pt_reduction_last(G2tensor(124),RedSet_5(4),mass5set(:,14),  & 
G1tensor(169),G1tensor(170),G1tensor(171),G1tensor(172),G1tensor(173),G1tensor(174))
  call G_TensorShift(G1tensor(170),8)
  call Hotf_5pt_reduction_last(G2tensor(121),RedSet_5(4),mass5set(:,15),  & 
G1tensor(175),G1tensor(176),G1tensor(177),G1tensor(178),G1tensor(179),G1tensor(180))
  call G_TensorShift(G1tensor(176),8)
  call Hotf_5pt_reduction_last(G2tensor(136),RedSet_5(4),mass5set(:,16),  & 
G1tensor(181),G1tensor(182),G1tensor(183),G1tensor(184),G1tensor(185),G1tensor(186))
  call G_TensorShift(G1tensor(182),8)
  call Hotf_5pt_reduction_last(G2tensor(160),RedSet_5(5),mass5set(:,17),  & 
G1tensor(187),G1tensor(188),G1tensor(189),G1tensor(190),G1tensor(191),G1tensor(192))
  call G_TensorShift(G1tensor(188),4)
  call Hotf_5pt_reduction_last(G2tensor(142),RedSet_5(5),mass5set(:,18),  & 
G1tensor(193),G1tensor(194),G1tensor(195),G1tensor(196),G1tensor(197),G1tensor(198))
  call G_TensorShift(G1tensor(194),4)
  call Hotf_5pt_reduction_last(G2tensor(163),RedSet_5(5),mass5set(:,19),  & 
G1tensor(199),G1tensor(200),G1tensor(201),G1tensor(202),G1tensor(203),G1tensor(204))
  call G_TensorShift(G1tensor(200),4)
  call Hotf_5pt_reduction_last(G2tensor(157),RedSet_5(5),mass5set(:,20),  & 
G1tensor(205),G1tensor(206),G1tensor(207),G1tensor(208),G1tensor(209),G1tensor(210))
  call G_TensorShift(G1tensor(206),4)
  call Hotf_5pt_reduction_last(G2tensor(166),RedSet_5(5),mass5set(:,21),  & 
G1tensor(211),G1tensor(212),G1tensor(213),G1tensor(214),G1tensor(215),G1tensor(216))
  call G_TensorShift(G1tensor(212),4)
  call Hotf_5pt_reduction_last(G2tensor(154),RedSet_5(5),mass5set(:,22),  & 
G1tensor(217),G1tensor(218),G1tensor(219),G1tensor(220),G1tensor(221),G1tensor(222))
  call G_TensorShift(G1tensor(218),4)
  call Hotf_5pt_reduction_last(G2tensor(187),RedSet_5(6),mass5set(:,17),  & 
G1tensor(223),G1tensor(224),G1tensor(225),G1tensor(226),G1tensor(227),G1tensor(228))
  call G_TensorShift(G1tensor(224),8)
  call Hotf_5pt_reduction_last(G2tensor(172),RedSet_5(6),mass5set(:,18),  & 
G1tensor(229),G1tensor(230),G1tensor(231),G1tensor(232),G1tensor(233),G1tensor(234))
  call G_TensorShift(G1tensor(230),8)
  call Hotf_5pt_reduction_last(G2tensor(190),RedSet_5(6),mass5set(:,19),  & 
G1tensor(235),G1tensor(236),G1tensor(237),G1tensor(238),G1tensor(239),G1tensor(240))
  call G_TensorShift(G1tensor(236),8)
  call Hotf_5pt_reduction_last(G2tensor(184),RedSet_5(6),mass5set(:,20),  & 
G1tensor(241),G1tensor(242),G1tensor(243),G1tensor(244),G1tensor(245),G1tensor(246))
  call G_TensorShift(G1tensor(242),8)
  call Hotf_5pt_reduction_last(G2tensor(181),RedSet_5(6),mass5set(:,22),  & 
G1tensor(247),G1tensor(248),G1tensor(249),G1tensor(250),G1tensor(251),G1tensor(252))
  call G_TensorShift(G1tensor(248),8)
  call Hotf_5pt_reduction_last(G2tensor(196),RedSet_5(6),mass5set(:,21),  & 
G1tensor(253),G1tensor(254),G1tensor(255),G1tensor(256),G1tensor(257),G1tensor(258))
  call G_TensorShift(G1tensor(254),8)
  call Hotf_5pt_reduction_last(G2tensor(199),RedSet_5(7),mass5set(:,23),  & 
G1tensor(259),G1tensor(260),G1tensor(261),G1tensor(262),G1tensor(263),G1tensor(264))
  call G_TensorShift(G1tensor(260),2)
  call Hotf_5pt_reduction_last(G2tensor(220),RedSet_5(7),mass5set(:,24),  & 
G1tensor(265),G1tensor(266),G1tensor(267),G1tensor(268),G1tensor(269),G1tensor(270))
  call G_TensorShift(G1tensor(266),2)
  call Hotf_5pt_reduction_last(G2tensor(205),RedSet_5(7),mass5set(:,25),  & 
G1tensor(271),G1tensor(272),G1tensor(273),G1tensor(274),G1tensor(275),G1tensor(276))
  call G_TensorShift(G1tensor(272),2)
  call Hotf_5pt_reduction_last(G2tensor(223),RedSet_5(7),mass5set(:,26),  & 
G1tensor(277),G1tensor(278),G1tensor(279),G1tensor(280),G1tensor(281),G1tensor(282))
  call G_TensorShift(G1tensor(278),2)
  call Hotf_5pt_reduction_last(G2tensor(226),RedSet_5(7),mass5set(:,27),  & 
G1tensor(283),G1tensor(284),G1tensor(285),G1tensor(286),G1tensor(287),G1tensor(288))
  call G_TensorShift(G1tensor(284),2)
  call Hotf_5pt_reduction_last(G2tensor(214),RedSet_5(7),mass5set(:,28),  & 
G1tensor(289),G1tensor(290),G1tensor(291),G1tensor(292),G1tensor(293),G1tensor(294))
  call G_TensorShift(G1tensor(290),2)
  call Hotf_5pt_reduction_last(G2tensor(217),RedSet_5(7),mass5set(:,29),  & 
G1tensor(295),G1tensor(296),G1tensor(297),G1tensor(298),G1tensor(299),G1tensor(300))
  call G_TensorShift(G1tensor(296),2)
  call Hotf_5pt_reduction_last(G2tensor(229),RedSet_5(7),mass5set(:,30),  & 
G1tensor(301),G1tensor(302),G1tensor(303),G1tensor(304),G1tensor(305),G1tensor(306))
  call G_TensorShift(G1tensor(302),2)
  call Hotf_5pt_reduction_last(G2tensor(238),RedSet_5(7),mass5set(:,31),  & 
G1tensor(307),G1tensor(308),G1tensor(309),G1tensor(310),G1tensor(311),G1tensor(312))
  call G_TensorShift(G1tensor(308),2)
  call Hotf_5pt_reduction_last(G2tensor(235),RedSet_5(7),mass5set(:,32),  & 
G1tensor(313),G1tensor(314),G1tensor(315),G1tensor(316),G1tensor(317),G1tensor(318))
  call G_TensorShift(G1tensor(314),2)
  call Hotf_5pt_reduction_last(G2tensor(241),RedSet_5(8),mass5set(:,23),  & 
G1tensor(319),G1tensor(320),G1tensor(321),G1tensor(322),G1tensor(323),G1tensor(324))
  call G_TensorShift(G1tensor(320),2)
  call Hotf_5pt_reduction_last(G2tensor(259),RedSet_5(8),mass5set(:,24),  & 
G1tensor(325),G1tensor(326),G1tensor(327),G1tensor(328),G1tensor(329),G1tensor(330))
  call G_TensorShift(G1tensor(326),2)
  call Hotf_5pt_reduction_last(G2tensor(247),RedSet_5(8),mass5set(:,25),  & 
G1tensor(331),G1tensor(332),G1tensor(333),G1tensor(334),G1tensor(335),G1tensor(336))
  call G_TensorShift(G1tensor(332),2)
  call Hotf_5pt_reduction_last(G2tensor(262),RedSet_5(8),mass5set(:,26),  & 
G1tensor(337),G1tensor(338),G1tensor(339),G1tensor(340),G1tensor(341),G1tensor(342))
  call G_TensorShift(G1tensor(338),2)
  call Hotf_5pt_reduction_last(G2tensor(253),RedSet_5(8),mass5set(:,28),  & 
G1tensor(343),G1tensor(344),G1tensor(345),G1tensor(346),G1tensor(347),G1tensor(348))
  call G_TensorShift(G1tensor(344),2)
  call Hotf_5pt_reduction_last(G2tensor(256),RedSet_5(8),mass5set(:,29),  & 
G1tensor(349),G1tensor(350),G1tensor(351),G1tensor(352),G1tensor(353),G1tensor(354))
  call G_TensorShift(G1tensor(350),2)
  call Hotf_5pt_reduction_last(G2tensor(265),RedSet_5(8),mass5set(:,30),  & 
G1tensor(355),G1tensor(356),G1tensor(357),G1tensor(358),G1tensor(359),G1tensor(360))
  call G_TensorShift(G1tensor(356),2)
  call Hotf_5pt_reduction_last(G2tensor(274),RedSet_5(8),mass5set(:,31),  & 
G1tensor(361),G1tensor(362),G1tensor(363),G1tensor(364),G1tensor(365),G1tensor(366))
  call G_TensorShift(G1tensor(362),2)
  call Hotf_5pt_reduction_last(G2tensor(271),RedSet_5(8),mass5set(:,32),  & 
G1tensor(367),G1tensor(368),G1tensor(369),G1tensor(370),G1tensor(371),G1tensor(372))
  call G_TensorShift(G1tensor(368),2)
  call ol_merge_tensors(T1sum(1),[G1tensor(1)])
  call ol_merge_tensors(T1sum(2),[G1tensor(7)])
  call ol_merge_tensors(T1sum(3),[G1tensor(13)])
  call ol_merge_tensors(T1sum(4),[G1tensor(19)])
  call ol_merge_tensors(T1sum(5),[G1tensor(25)])
  call ol_merge_tensors(T1sum(6),[G1tensor(31)])
  call ol_merge_tensors(T1sum(7),[G1tensor(37)])
  call ol_merge_tensors(T1sum(8),[G1tensor(43)])
  call ol_merge_tensors(T1sum(9),[G1tensor(49)])
  call ol_merge_tensors(T1sum(10),[G1tensor(55)])
  call ol_merge_tensors(T1sum(11),[G1tensor(61)])
  call ol_merge_tensors(T1sum(12),[G1tensor(67)])
  call ol_merge_tensors(T1sum(13),[G1tensor(73)])
  call ol_merge_tensors(T1sum(14),[G1tensor(79)])
  call ol_merge_tensors(T1sum(15),[G1tensor(85)])
  call ol_merge_tensors(T1sum(16),[G1tensor(91)])
  call ol_merge_tensors(T1sum(17),[G1tensor(97)])
  call ol_merge_tensors(T1sum(18),[G1tensor(103)])
  call ol_merge_tensors(T1sum(19),[G1tensor(109)])
  call ol_merge_tensors(T1sum(20),[G1tensor(115)])
  call ol_merge_tensors(T1sum(21),[G1tensor(121)])
  call ol_merge_tensors(T1sum(22),[G1tensor(127)])
  call ol_merge_tensors(T1sum(23),[G1tensor(133)])
  call ol_merge_tensors(T1sum(24),[G1tensor(139)])
  call ol_merge_tensors(T1sum(25),[G1tensor(145)])
  call ol_merge_tensors(T1sum(26),[G1tensor(151)])
  call ol_merge_tensors(T1sum(27),[G1tensor(157)])
  call ol_merge_tensors(T1sum(28),[G1tensor(163)])
  call ol_merge_tensors(T1sum(29),[G1tensor(169)])
  call ol_merge_tensors(T1sum(30),[G1tensor(175)])
  call ol_merge_tensors(T1sum(31),[G1tensor(181)])
  call ol_merge_tensors(T1sum(32),[G1tensor(187)])
  call ol_merge_tensors(T1sum(33),[G1tensor(193)])
  call ol_merge_tensors(T1sum(34),[G1tensor(199)])
  call ol_merge_tensors(T1sum(35),[G1tensor(205)])
  call ol_merge_tensors(T1sum(36),[G1tensor(211)])
  call ol_merge_tensors(T1sum(37),[G1tensor(217)])
  call ol_merge_tensors(T1sum(38),[G1tensor(223)])
  call ol_merge_tensors(T1sum(39),[G1tensor(229)])
  call ol_merge_tensors(T1sum(40),[G1tensor(235)])
  call ol_merge_tensors(T1sum(41),[G1tensor(241)])
  call ol_merge_tensors(T1sum(42),[G1tensor(247)])
  call ol_merge_tensors(T1sum(43),[G1tensor(253)])
  call ol_merge_tensors(T1sum(44),[G1tensor(259)])
  call ol_merge_tensors(T1sum(45),[G1tensor(265)])
  call ol_merge_tensors(T1sum(46),[G1tensor(271)])
  call ol_merge_tensors(T1sum(47),[G1tensor(277)])
  call ol_merge_tensors(T1sum(48),[G1tensor(283)])
  call ol_merge_tensors(T1sum(49),[G1tensor(289)])
  call ol_merge_tensors(T1sum(50),[G1tensor(295)])
  call ol_merge_tensors(T1sum(51),[G1tensor(301)])
  call ol_merge_tensors(T1sum(52),[G1tensor(307)])
  call ol_merge_tensors(T1sum(53),[G1tensor(313)])
  call ol_merge_tensors(T1sum(54),[G1tensor(319)])
  call ol_merge_tensors(T1sum(55),[G1tensor(325)])
  call ol_merge_tensors(T1sum(56),[G1tensor(331)])
  call ol_merge_tensors(T1sum(57),[G1tensor(337)])
  call ol_merge_tensors(T1sum(58),[G1tensor(343)])
  call ol_merge_tensors(T1sum(59),[G1tensor(349)])
  call ol_merge_tensors(T1sum(60),[G1tensor(355)])
  call ol_merge_tensors(T1sum(61),[G1tensor(361)])
  call ol_merge_tensors(T1sum(62),[G1tensor(367)])
  Gcoeff(:)%j = (c(25)*M(4,:)%j) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(137),h0tab(:,137),[16,3,8,4],[nMB,nMB,nMH,nMB],4,1,wf4(:,1))
  call Hloop_QV_A(ntryL,G0H32(1),ex5(:),G0H16(1),m3h2x16(:,137),heltab2x32(:,:,137))
  call Hloop_Q_A(ntryL,G0H16(1),16,nMB,G1H16(1),n2h16(137))
  Gcoeff(:)%j = (-(c(25)*M(4,:)%j)) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(138),h0tab(:,138),[16,3,8,4],[nMB,nMB,nMZ,nMB],4,1,wf4(:,1))
  call Hloop_QV_A(ntryL,G0H32(1),ex5(:),G0H16(1),m3h2x16(:,138),heltab2x32(:,:,138))
  call Hloop_Q_A(ntryL,G0H16(1),16,nMB,G1H16(2),n2h16(138))
  Gcoeff(:)%j = (-(c(32)*M(4,:)%j)) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(139),h0tab(:,139),[16,3,8,4],[nMT,nMT,nMW,nMT],4,1,wf4(:,1))
  call Hloop_QV_A(ntryL,G0H32(1),ex5(:),G0H16(1),m3h2x16(:,139),heltab2x32(:,:,139))
  call Hloop_Q_A(ntryL,G0H16(1),16,nMT,G1H16(3),n2h16(139))
  Gcoeff(:)%j = (c(25)*M(4,:)%j) * den(4)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(140),h0tab(:,140),[16,3,8,4],[nMB,nMB,nMH,nMB],4,1,wf4(:,4))
  call Hloop_QV_A(ntryL,G0H32(1),ex5(:),G0H16(1),m3h2x16(:,140),heltab2x32(:,:,140))
  call Hloop_Q_A(ntryL,G0H16(1),16,nMB,G1H16(4),n2h16(140))
  Gcoeff(:)%j = (-(c(25)*M(4,:)%j)) * den(4)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(141),h0tab(:,141),[16,3,8,4],[nMB,nMB,nMZ,nMB],4,1,wf4(:,4))
  call Hloop_QV_A(ntryL,G0H32(1),ex5(:),G0H16(1),m3h2x16(:,141),heltab2x32(:,:,141))
  call Hloop_Q_A(ntryL,G0H16(1),16,nMB,G1H16(5),n2h16(141))
  Gcoeff(:)%j = (c(32)*M(4,:)%j) * den(4)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(142),h0tab(:,142),[16,3,8,4],[nMT,nMT,nMW,nMT],4,1,wf4(:,4))
  call Hloop_QV_A(ntryL,G0H32(1),ex5(:),G0H16(1),m3h2x16(:,142),heltab2x32(:,:,142))
  call Hloop_Q_A(ntryL,G0H16(1),16,nMT,G1H16(6),n2h16(142))
  Gcoeff(:)%j = (-(c(83)*M(4,:)%j)) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(143),h0tab(:,143),[16,3,8,4],[nMB,nMB,0,nMB],4,1,wf4(:,1))
  call Hloop_QV_A(ntryL,G0H32(1),ex5(:),G0H16(1),m3h2x16(:,143),heltab2x32(:,:,143))
  call Hloop_Q_A(ntryL,G0H16(1),16,nMB,G1H16(7),n2h16(143))
  Gcoeff(:)%j = (-(c(86)*M(4,:)%j)) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(144),h0tab(:,144),[16,3,8,4],[nMB,nMB,nMZ,nMB],4,1,wf4(:,1))
  call Hloop_QV_A(ntryL,G0H32(1),ex5(:),G0H16(1),m3h2x16(:,144),heltab2x32(:,:,144))
  call Hloop_Q_A(ntryL,G0H16(1),16,nMB,G1H16(8),n2h16(144))
  Gcoeff(:)%j = (-(c(46)*M(4,:)%j)) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(145),h0tab(:,145),[16,3,8,4],[nMT,nMT,nMW,nMT],4,1,wf4(:,1))
  call Hloop_QV_A(ntryL,G0H32(1),ex5(:),G0H16(1),m3h2x16(:,145),heltab2x32(:,:,145))
  call Hloop_Q_A(ntryL,G0H16(1),16,nMT,G1H16(9),n2h16(145))
  Gcoeff(:)%j = (-(c(83)*M(4,:)%j)) * den(4)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(146),h0tab(:,146),[16,3,8,4],[nMB,nMB,0,nMB],4,1,wf4(:,4))
  call Hloop_QV_A(ntryL,G0H32(1),ex5(:),G0H16(1),m3h2x16(:,146),heltab2x32(:,:,146))
  call Hloop_Q_A(ntryL,G0H16(1),16,nMB,G1H16(10),n2h16(146))
  Gcoeff(:)%j = (-(c(86)*M(4,:)%j)) * den(4)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(147),h0tab(:,147),[16,3,8,4],[nMB,nMB,nMZ,nMB],4,1,wf4(:,4))
  call Hloop_QV_A(ntryL,G0H32(1),ex5(:),G0H16(1),m3h2x16(:,147),heltab2x32(:,:,147))
  call Hloop_Q_A(ntryL,G0H16(1),16,nMB,G1H16(11),n2h16(147))
  Gcoeff(:)%j = (c(46)*M(4,:)%j) * den(4)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(148),h0tab(:,148),[16,3,8,4],[nMT,nMT,nMW,nMT],4,1,wf4(:,4))
  call Hloop_QV_A(ntryL,G0H32(1),ex5(:),G0H16(1),m3h2x16(:,148),heltab2x32(:,:,148))
  call Hloop_Q_A(ntryL,G0H16(1),16,nMT,G1H16(12),n2h16(148))
  Gcoeff(:)%j = (c(80)*M(4,:)%j) * den(6)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(149),h0tab(:,149),[16,3,8,4],[nMB,nMB,nMH,nMB],4,1,wf4(:,5))
  call Hloop_QV_A(ntryL,G0H32(1),ex5(:),G0H16(1),m3h2x16(:,149),heltab2x32(:,:,149))
  call Hloop_Q_A(ntryL,G0H16(1),16,nMB,G1H16(13),n2h16(149))
  Gcoeff(:)%j = (-(c(80)*M(4,:)%j)) * den(6)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(150),h0tab(:,150),[16,3,8,4],[nMB,nMB,nMZ,nMB],4,1,wf4(:,5))
  call Hloop_QV_A(ntryL,G0H32(1),ex5(:),G0H16(1),m3h2x16(:,150),heltab2x32(:,:,150))
  call Hloop_Q_A(ntryL,G0H16(1),16,nMB,G1H16(14),n2h16(150))
  Gcoeff(:)%j = (c(77)*M(4,:)%j) * den(6)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(151),h0tab(:,151),[16,3,8,4],[nMT,nMT,nMW,nMT],4,1,wf4(:,5))
  call Hloop_QV_A(ntryL,G0H32(1),ex5(:),G0H16(1),m3h2x16(:,151),heltab2x32(:,:,151))
  call Hloop_Q_A(ntryL,G0H16(1),16,nMT,G1H16(15),n2h16(151))
  Gcoeff(:)%j = (-(c(81)*M(4,:)%j)) * den(4)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(152),h0tab(:,152),[16,3,8,4],[nMB,nMB,nMH,nMB],4,1,wf4(:,6))
  call Hloop_QV_A(ntryL,G0H32(1),ex5(:),G0H16(1),m3h2x16(:,152),heltab2x32(:,:,152))
  call Hloop_Q_A(ntryL,G0H16(1),16,nMB,G1H16(16),n2h16(152))
  Gcoeff(:)%j = (c(81)*M(4,:)%j) * den(4)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(153),h0tab(:,153),[16,3,8,4],[nMB,nMB,nMZ,nMB],4,1,wf4(:,6))
  call Hloop_QV_A(ntryL,G0H32(1),ex5(:),G0H16(1),m3h2x16(:,153),heltab2x32(:,:,153))
  call Hloop_Q_A(ntryL,G0H16(1),16,nMB,G1H16(17),n2h16(153))
  Gcoeff(:)%j = (c(79)*M(4,:)%j) * den(4)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(154),h0tab(:,154),[16,3,8,4],[nMT,nMT,nMW,nMT],4,1,wf4(:,6))
  call Hloop_QV_A(ntryL,G0H32(1),ex5(:),G0H16(1),m3h2x16(:,154),heltab2x32(:,:,154))
  call Hloop_Q_A(ntryL,G0H16(1),16,nMT,G1H16(18),n2h16(154))
  Gcoeff(:)%j = (-(c(1)*M(4,:)%j)) * den(6)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(155),h0tab(:,155),[16,3,8,4],[nMB,nMB,0,nMB],4,1,wf4(:,5))
  call Hloop_QV_A(ntryL,G0H32(1),ex5(:),G0H16(1),m3h2x16(:,155),heltab2x32(:,:,155))
  call Hloop_Q_A(ntryL,G0H16(1),16,nMB,G1H16(19),n2h16(155))
  Gcoeff(:)%j = (-(c(5)*M(4,:)%j)) * den(6)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(156),h0tab(:,156),[16,3,8,4],[nMB,nMB,nMZ,nMB],4,1,wf4(:,5))
  call Hloop_QV_A(ntryL,G0H32(1),ex5(:),G0H16(1),m3h2x16(:,156),heltab2x32(:,:,156))
  call Hloop_Q_A(ntryL,G0H16(1),16,nMB,G1H16(20),n2h16(156))
  Gcoeff(:)%j = (c(63)*M(4,:)%j) * den(6)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(157),h0tab(:,157),[16,3,8,4],[nMT,nMT,nMW,nMT],4,1,wf4(:,5))
  call Hloop_QV_A(ntryL,G0H32(1),ex5(:),G0H16(1),m3h2x16(:,157),heltab2x32(:,:,157))
  call Hloop_Q_A(ntryL,G0H16(1),16,nMT,G1H16(21),n2h16(157))
  Gcoeff(:)%j = (c(4)*M(4,:)%j) * den(4)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(158),h0tab(:,158),[16,3,8,4],[nMB,nMB,0,nMB],4,1,wf4(:,6))
  call Hloop_QV_A(ntryL,G0H32(1),ex5(:),G0H16(1),m3h2x16(:,158),heltab2x32(:,:,158))
  call Hloop_Q_A(ntryL,G0H16(1),16,nMB,G1H16(22),n2h16(158))
  Gcoeff(:)%j = (c(7)*M(4,:)%j) * den(4)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(159),h0tab(:,159),[16,3,8,4],[nMB,nMB,nMZ,nMB],4,1,wf4(:,6))
  call Hloop_QV_A(ntryL,G0H32(1),ex5(:),G0H16(1),m3h2x16(:,159),heltab2x32(:,:,159))
  call Hloop_Q_A(ntryL,G0H16(1),16,nMB,G1H16(23),n2h16(159))
  Gcoeff(:)%j = (c(65)*M(4,:)%j) * den(4)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(160),h0tab(:,160),[16,3,8,4],[nMT,nMT,nMW,nMT],4,1,wf4(:,6))
  call Hloop_QV_A(ntryL,G0H32(1),ex5(:),G0H16(1),m3h2x16(:,160),heltab2x32(:,:,160))
  call Hloop_Q_A(ntryL,G0H16(1),16,nMT,G1H16(24),n2h16(160))
  Gcoeff(:)%j = (c(25)*M(4,:)%j) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(161),h0tab(:,161),[16,3,4,8],[nMB,nMB,nMH,nMB],4,1,wf4(:,1))
  call Hloop_AV_Q(ntryL,G0H32(1),ex5(:),G0H16(1),m3h2x16(:,161),heltab2x32(:,:,161))
  call Hloop_A_Q(ntryL,G0H16(1),16,nMB,G1H16(25),n2h16(161))
  Gcoeff(:)%j = (-(c(25)*M(4,:)%j)) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(162),h0tab(:,162),[16,3,4,8],[nMB,nMB,nMZ,nMB],4,1,wf4(:,1))
  call Hloop_AV_Q(ntryL,G0H32(1),ex5(:),G0H16(1),m3h2x16(:,162),heltab2x32(:,:,162))
  call Hloop_A_Q(ntryL,G0H16(1),16,nMB,G1H16(26),n2h16(162))
  Gcoeff(:)%j = (-(c(32)*M(4,:)%j)) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(163),h0tab(:,163),[16,3,4,8],[nMT,nMT,nMW,nMT],4,1,wf4(:,1))
  call Hloop_AV_Q(ntryL,G0H32(1),ex5(:),G0H16(1),m3h2x16(:,163),heltab2x32(:,:,163))
  call Hloop_A_Q(ntryL,G0H16(1),16,nMT,G1H16(27),n2h16(163))
  Gcoeff(:)%j = (c(25)*M(4,:)%j) * den(4)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(164),h0tab(:,164),[16,3,4,8],[nMB,nMB,nMH,nMB],4,1,wf4(:,4))
  call Hloop_AV_Q(ntryL,G0H32(1),ex5(:),G0H16(1),m3h2x16(:,164),heltab2x32(:,:,164))
  call Hloop_A_Q(ntryL,G0H16(1),16,nMB,G1H16(28),n2h16(164))
  Gcoeff(:)%j = (-(c(25)*M(4,:)%j)) * den(4)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(165),h0tab(:,165),[16,3,4,8],[nMB,nMB,nMZ,nMB],4,1,wf4(:,4))
  call Hloop_AV_Q(ntryL,G0H32(1),ex5(:),G0H16(1),m3h2x16(:,165),heltab2x32(:,:,165))
  call Hloop_A_Q(ntryL,G0H16(1),16,nMB,G1H16(29),n2h16(165))
  Gcoeff(:)%j = (c(32)*M(4,:)%j) * den(4)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(166),h0tab(:,166),[16,3,4,8],[nMT,nMT,nMW,nMT],4,1,wf4(:,4))
  call Hloop_AV_Q(ntryL,G0H32(1),ex5(:),G0H16(1),m3h2x16(:,166),heltab2x32(:,:,166))
  call Hloop_A_Q(ntryL,G0H16(1),16,nMT,G1H16(30),n2h16(166))
  Gcoeff(:)%j = (-(c(83)*M(4,:)%j)) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(167),h0tab(:,167),[16,3,4,8],[nMB,nMB,0,nMB],4,1,wf4(:,1))
  call Hloop_AV_Q(ntryL,G0H32(1),ex5(:),G0H16(1),m3h2x16(:,167),heltab2x32(:,:,167))
  call Hloop_A_Q(ntryL,G0H16(1),16,nMB,G1H16(31),n2h16(167))
  Gcoeff(:)%j = (-(c(86)*M(4,:)%j)) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(168),h0tab(:,168),[16,3,4,8],[nMB,nMB,nMZ,nMB],4,1,wf4(:,1))
  call Hloop_AV_Q(ntryL,G0H32(1),ex5(:),G0H16(1),m3h2x16(:,168),heltab2x32(:,:,168))
  call Hloop_A_Q(ntryL,G0H16(1),16,nMB,G1H16(32),n2h16(168))
  Gcoeff(:)%j = (-(c(46)*M(4,:)%j)) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(169),h0tab(:,169),[16,3,4,8],[nMT,nMT,nMW,nMT],4,1,wf4(:,1))
  call Hloop_AV_Q(ntryL,G0H32(1),ex5(:),G0H16(1),m3h2x16(:,169),heltab2x32(:,:,169))
  call Hloop_A_Q(ntryL,G0H16(1),16,nMT,G1H16(33),n2h16(169))
  Gcoeff(:)%j = (-(c(83)*M(4,:)%j)) * den(4)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(170),h0tab(:,170),[16,3,4,8],[nMB,nMB,0,nMB],4,1,wf4(:,4))
  call Hloop_AV_Q(ntryL,G0H32(1),ex5(:),G0H16(1),m3h2x16(:,170),heltab2x32(:,:,170))
  call Hloop_A_Q(ntryL,G0H16(1),16,nMB,G1H16(34),n2h16(170))
  Gcoeff(:)%j = (-(c(86)*M(4,:)%j)) * den(4)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(171),h0tab(:,171),[16,3,4,8],[nMB,nMB,nMZ,nMB],4,1,wf4(:,4))
  call Hloop_AV_Q(ntryL,G0H32(1),ex5(:),G0H16(1),m3h2x16(:,171),heltab2x32(:,:,171))
  call Hloop_A_Q(ntryL,G0H16(1),16,nMB,G1H16(35),n2h16(171))
  Gcoeff(:)%j = (c(46)*M(4,:)%j) * den(4)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(172),h0tab(:,172),[16,3,4,8],[nMT,nMT,nMW,nMT],4,1,wf4(:,4))
  call Hloop_AV_Q(ntryL,G0H32(1),ex5(:),G0H16(1),m3h2x16(:,172),heltab2x32(:,:,172))
  call Hloop_A_Q(ntryL,G0H16(1),16,nMT,G1H16(36),n2h16(172))
  Gcoeff(:)%j = (c(80)*M(4,:)%j) * den(6)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(173),h0tab(:,173),[16,3,4,8],[nMB,nMB,nMH,nMB],4,1,wf4(:,5))
  call Hloop_AV_Q(ntryL,G0H32(1),ex5(:),G0H16(1),m3h2x16(:,173),heltab2x32(:,:,173))
  call Hloop_A_Q(ntryL,G0H16(1),16,nMB,G1H16(37),n2h16(173))
  Gcoeff(:)%j = (-(c(80)*M(4,:)%j)) * den(6)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(174),h0tab(:,174),[16,3,4,8],[nMB,nMB,nMZ,nMB],4,1,wf4(:,5))
  call Hloop_AV_Q(ntryL,G0H32(1),ex5(:),G0H16(1),m3h2x16(:,174),heltab2x32(:,:,174))
  call Hloop_A_Q(ntryL,G0H16(1),16,nMB,G1H16(38),n2h16(174))
  Gcoeff(:)%j = (c(77)*M(4,:)%j) * den(6)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(175),h0tab(:,175),[16,3,4,8],[nMT,nMT,nMW,nMT],4,1,wf4(:,5))
  call Hloop_AV_Q(ntryL,G0H32(1),ex5(:),G0H16(1),m3h2x16(:,175),heltab2x32(:,:,175))
  call Hloop_A_Q(ntryL,G0H16(1),16,nMT,G1H16(39),n2h16(175))
  Gcoeff(:)%j = (-(c(81)*M(4,:)%j)) * den(4)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(176),h0tab(:,176),[16,3,4,8],[nMB,nMB,nMH,nMB],4,1,wf4(:,6))
  call Hloop_AV_Q(ntryL,G0H32(1),ex5(:),G0H16(1),m3h2x16(:,176),heltab2x32(:,:,176))
  call Hloop_A_Q(ntryL,G0H16(1),16,nMB,G1H16(40),n2h16(176))
  Gcoeff(:)%j = (c(81)*M(4,:)%j) * den(4)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(177),h0tab(:,177),[16,3,4,8],[nMB,nMB,nMZ,nMB],4,1,wf4(:,6))
  call Hloop_AV_Q(ntryL,G0H32(1),ex5(:),G0H16(1),m3h2x16(:,177),heltab2x32(:,:,177))
  call Hloop_A_Q(ntryL,G0H16(1),16,nMB,G1H16(41),n2h16(177))
  Gcoeff(:)%j = (c(79)*M(4,:)%j) * den(4)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(178),h0tab(:,178),[16,3,4,8],[nMT,nMT,nMW,nMT],4,1,wf4(:,6))
  call Hloop_AV_Q(ntryL,G0H32(1),ex5(:),G0H16(1),m3h2x16(:,178),heltab2x32(:,:,178))
  call Hloop_A_Q(ntryL,G0H16(1),16,nMT,G1H16(42),n2h16(178))
  Gcoeff(:)%j = (-(c(1)*M(4,:)%j)) * den(6)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(179),h0tab(:,179),[16,3,4,8],[nMB,nMB,0,nMB],4,1,wf4(:,5))
  call Hloop_AV_Q(ntryL,G0H32(1),ex5(:),G0H16(1),m3h2x16(:,179),heltab2x32(:,:,179))
  call Hloop_A_Q(ntryL,G0H16(1),16,nMB,G1H16(43),n2h16(179))
  Gcoeff(:)%j = (-(c(5)*M(4,:)%j)) * den(6)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(180),h0tab(:,180),[16,3,4,8],[nMB,nMB,nMZ,nMB],4,1,wf4(:,5))
  call Hloop_AV_Q(ntryL,G0H32(1),ex5(:),G0H16(1),m3h2x16(:,180),heltab2x32(:,:,180))
  call Hloop_A_Q(ntryL,G0H16(1),16,nMB,G1H16(44),n2h16(180))
  Gcoeff(:)%j = (c(63)*M(4,:)%j) * den(6)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(181),h0tab(:,181),[16,3,4,8],[nMT,nMT,nMW,nMT],4,1,wf4(:,5))
  call Hloop_AV_Q(ntryL,G0H32(1),ex5(:),G0H16(1),m3h2x16(:,181),heltab2x32(:,:,181))
  call Hloop_A_Q(ntryL,G0H16(1),16,nMT,G1H16(45),n2h16(181))
  Gcoeff(:)%j = (c(4)*M(4,:)%j) * den(4)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(182),h0tab(:,182),[16,3,4,8],[nMB,nMB,0,nMB],4,1,wf4(:,6))
  call Hloop_AV_Q(ntryL,G0H32(1),ex5(:),G0H16(1),m3h2x16(:,182),heltab2x32(:,:,182))
  call Hloop_A_Q(ntryL,G0H16(1),16,nMB,G1H16(46),n2h16(182))
  Gcoeff(:)%j = (c(7)*M(4,:)%j) * den(4)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(183),h0tab(:,183),[16,3,4,8],[nMB,nMB,nMZ,nMB],4,1,wf4(:,6))
  call Hloop_AV_Q(ntryL,G0H32(1),ex5(:),G0H16(1),m3h2x16(:,183),heltab2x32(:,:,183))
  call Hloop_A_Q(ntryL,G0H16(1),16,nMB,G1H16(47),n2h16(183))
  Gcoeff(:)%j = (c(65)*M(4,:)%j) * den(4)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(184),h0tab(:,184),[16,3,4,8],[nMT,nMT,nMW,nMT],4,1,wf4(:,6))
  call Hloop_AV_Q(ntryL,G0H32(1),ex5(:),G0H16(1),m3h2x16(:,184),heltab2x32(:,:,184))
  call Hloop_A_Q(ntryL,G0H16(1),16,nMT,G1H16(48),n2h16(184))
  Gcoeff(:)%j = (c(28)*M(4,:)%j) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(185),h0tab(:,185),[16,4,3,8],[nMB,nMH,nMH,nMB],4,1,wf4(:,1))
  call Hloop_AV_Q(ntryL,G0H32(1),ex5(:),G0H16(1),m3h2x16(:,185),heltab2x32(:,:,185))
  call Hloop_A_Q(ntryL,G0H16(1),16,nMB,G1H16(49),n2h16(185))
  Gcoeff(:)%j = (-(c(27)*M(4,:)%j)) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(186),h0tab(:,186),[16,4,3,8],[nMB,nMZ,nMZ,nMB],4,1,wf4(:,1))
  call Hloop_AV_Q(ntryL,G0H32(1),ex5(:),G0H16(1),m3h2x16(:,186),heltab2x32(:,:,186))
  call Hloop_A_Q(ntryL,G0H16(1),16,nMB,G1H16(50),n2h16(186))
  Gcoeff(:)%j = (-(c(26)*M(4,:)%j)) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(187),h0tab(:,187),[16,4,3,8],[nMT,nMW,nMW,nMT],4,1,wf4(:,1))
  call Hloop_AV_Q(ntryL,G0H32(1),ex5(:),G0H16(1),m3h2x16(:,187),heltab2x32(:,:,187))
  call Hloop_A_Q(ntryL,G0H16(1),16,nMT,G1H16(51),n2h16(187))
  Gcoeff(:)%j = (c(27)*M(4,:)%j) * den(4)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(188),h0tab(:,188),[16,4,3,8],[nMB,nMH,nMZ,nMB],4,1,wf4(:,4))
  call Hloop_AV_Q(ntryL,G0H32(1),ex5(:),G0H16(1),m3h2x16(:,188),heltab2x32(:,:,188))
  call Hloop_A_Q(ntryL,G0H16(1),16,nMB,G1H16(52),n2h16(188))
  Gcoeff(:)%j = (c(27)*M(4,:)%j) * den(4)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(189),h0tab(:,189),[16,4,3,8],[nMB,nMZ,nMH,nMB],4,1,wf4(:,4))
  call Hloop_AV_Q(ntryL,G0H32(1),ex5(:),G0H16(1),m3h2x16(:,189),heltab2x32(:,:,189))
  call Hloop_A_Q(ntryL,G0H16(1),16,nMB,G1H16(53),n2h16(189))
  Gcoeff(:)%j = (c(57)*M(4,:)%j) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(190),h0tab(:,190),[16,4,3,8],[nMB,nMZ,nMZ,nMB],4,1,wf4(:,1))
  call Hloop_AV_Q(ntryL,G0H32(1),ex5(:),G0H16(1),m3h2x16(:,190),heltab2x32(:,:,190))
  call Hloop_A_Q(ntryL,G0H16(1),16,nMB,G1H16(54),n2h16(190))
  Gcoeff(:)%j = (-(c(42)*M(4,:)%j)) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(191),h0tab(:,191),[16,4,3,8],[nMT,nMW,nMW,nMT],4,1,wf4(:,1))
  call Hloop_AV_Q(ntryL,G0H32(1),ex5(:),G0H16(1),m3h2x16(:,191),heltab2x32(:,:,191))
  call Hloop_A_Q(ntryL,G0H16(1),16,nMT,G1H16(55),n2h16(191))
  Gcoeff(:)%j = (-(c(57)*M(4,:)%j)) * den(4)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(192),h0tab(:,192),[16,4,3,8],[nMB,nMH,nMZ,nMB],4,1,wf4(:,4))
  call Hloop_AV_Q(ntryL,G0H32(1),ex5(:),G0H16(1),m3h2x16(:,192),heltab2x32(:,:,192))
  call Hloop_A_Q(ntryL,G0H16(1),16,nMB,G1H16(56),n2h16(192))
  Gcoeff(:)%j = (c(42)*M(4,:)%j) * den(4)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(193),h0tab(:,193),[16,4,3,8],[nMT,nMW,nMW,nMT],4,1,wf4(:,4))
  call Hloop_AV_Q(ntryL,G0H32(1),ex5(:),G0H16(1),m3h2x16(:,193),heltab2x32(:,:,193))
  call Hloop_A_Q(ntryL,G0H16(1),16,nMT,G1H16(57),n2h16(193))
  Gcoeff(:)%j = (c(57)*M(4,:)%j) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(194),h0tab(:,194),[16,4,3,8],[nMB,nMZ,nMZ,nMB],4,1,wf4(:,1))
  call Hloop_AV_Q(ntryL,G0H32(1),ex5(:),G0H16(1),m3h2x16(:,194),heltab2x32(:,:,194))
  call Hloop_A_Q(ntryL,G0H16(1),16,nMB,G1H16(58),n2h16(194))
  Gcoeff(:)%j = (-(c(42)*M(4,:)%j)) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(195),h0tab(:,195),[16,4,3,8],[nMT,nMW,nMW,nMT],4,1,wf4(:,1))
  call Hloop_AV_Q(ntryL,G0H32(1),ex5(:),G0H16(1),m3h2x16(:,195),heltab2x32(:,:,195))
  call Hloop_A_Q(ntryL,G0H16(1),16,nMT,G1H16(59),n2h16(195))
  Gcoeff(:)%j = (-(c(57)*M(4,:)%j)) * den(4)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(196),h0tab(:,196),[16,4,3,8],[nMB,nMZ,nMH,nMB],4,1,wf4(:,4))
  call Hloop_AV_Q(ntryL,G0H32(1),ex5(:),G0H16(1),m3h2x16(:,196),heltab2x32(:,:,196))
  call Hloop_A_Q(ntryL,G0H16(1),16,nMB,G1H16(60),n2h16(196))
  Gcoeff(:)%j = (-(c(42)*M(4,:)%j)) * den(4)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(197),h0tab(:,197),[16,4,3,8],[nMT,nMW,nMW,nMT],4,1,wf4(:,4))
  call Hloop_AV_Q(ntryL,G0H32(1),ex5(:),G0H16(1),m3h2x16(:,197),heltab2x32(:,:,197))
  call Hloop_A_Q(ntryL,G0H16(1),16,nMT,G1H16(61),n2h16(197))
  Gcoeff(:)%j = (-(c(73)*M(4,:)%j)) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(198),h0tab(:,198),[16,4,3,8],[nMB,nMZ,nMZ,nMB],4,1,wf4(:,1))
  call Hloop_AV_Q(ntryL,G0H32(1),ex5(:),G0H16(1),m3h2x16(:,198),heltab2x32(:,:,198))
  call Hloop_A_Q(ntryL,G0H16(1),16,nMB,G1H16(62),n2h16(198))
  Gcoeff(:)%j = (-(c(15)*M(4,:)%j)) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(199),h0tab(:,199),[16,4,3,8],[nMT,nMW,nMW,nMT],4,1,wf4(:,1))
  call Hloop_AV_Q(ntryL,G0H32(1),ex5(:),G0H16(1),m3h2x16(:,199),heltab2x32(:,:,199))
  call Hloop_A_Q(ntryL,G0H16(1),16,nMT,G1H16(63),n2h16(199))
  Gcoeff(:)%j = (c(78)*M(4,:)%j) * den(6)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(200),h0tab(:,200),[16,4,3,8],[nMT,nMW,nMW,nMT],4,1,wf4(:,5))
  call Hloop_AV_Q(ntryL,G0H32(1),ex5(:),G0H16(1),m3h2x16(:,200),heltab2x32(:,:,200))
  call Hloop_A_Q(ntryL,G0H16(1),16,nMT,G1H16(64),n2h16(200))
  Gcoeff(:)%j = (c(55)*M(4,:)%j) * den(4)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(201),h0tab(:,201),[16,4,3,8],[nMB,nMH,nMZ,nMB],4,1,wf4(:,6))
  call Hloop_AV_Q(ntryL,G0H32(1),ex5(:),G0H16(1),m3h2x16(:,201),heltab2x32(:,:,201))
  call Hloop_A_Q(ntryL,G0H16(1),16,nMB,G1H16(65),n2h16(201))
  Gcoeff(:)%j = (c(55)*M(4,:)%j) * den(4)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(202),h0tab(:,202),[16,4,3,8],[nMB,nMZ,nMH,nMB],4,1,wf4(:,6))
  call Hloop_AV_Q(ntryL,G0H32(1),ex5(:),G0H16(1),m3h2x16(:,202),heltab2x32(:,:,202))
  call Hloop_A_Q(ntryL,G0H16(1),16,nMB,G1H16(66),n2h16(202))
  Gcoeff(:)%j = (-(c(104)*M(4,:)%j)) * den(4)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(203),h0tab(:,203),[16,4,3,8],[nMT,nMW,nMW,nMT],4,1,wf4(:,6))
  call Hloop_AV_Q(ntryL,G0H32(1),ex5(:),G0H16(1),m3h2x16(:,203),heltab2x32(:,:,203))
  call Hloop_A_Q(ntryL,G0H16(1),16,nMT,G1H16(67),n2h16(203))
  Gcoeff(:)%j = (c(64)*M(4,:)%j) * den(6)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(204),h0tab(:,204),[16,4,3,8],[nMT,nMW,nMW,nMT],4,1,wf4(:,5))
  call Hloop_AV_Q(ntryL,G0H32(1),ex5(:),G0H16(1),m3h2x16(:,204),heltab2x32(:,:,204))
  call Hloop_A_Q(ntryL,G0H16(1),16,nMT,G1H16(68),n2h16(204))
  Gcoeff(:)%j = (-(c(70)*M(4,:)%j)) * den(4)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(205),h0tab(:,205),[16,4,3,8],[nMB,nMH,nMZ,nMB],4,1,wf4(:,6))
  call Hloop_AV_Q(ntryL,G0H32(1),ex5(:),G0H16(1),m3h2x16(:,205),heltab2x32(:,:,205))
  call Hloop_A_Q(ntryL,G0H16(1),16,nMB,G1H16(69),n2h16(205))
  Gcoeff(:)%j = (-(c(92)*M(4,:)%j)) * den(4)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(206),h0tab(:,206),[16,4,3,8],[nMT,nMW,nMW,nMT],4,1,wf4(:,6))
  call Hloop_AV_Q(ntryL,G0H32(1),ex5(:),G0H16(1),m3h2x16(:,206),heltab2x32(:,:,206))
  call Hloop_A_Q(ntryL,G0H16(1),16,nMT,G1H16(70),n2h16(206))
  Gcoeff(:)%j = (-(c(64)*M(4,:)%j)) * den(6)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(207),h0tab(:,207),[16,4,3,8],[nMT,nMW,nMW,nMT],4,1,wf4(:,5))
  call Hloop_AV_Q(ntryL,G0H32(1),ex5(:),G0H16(1),m3h2x16(:,207),heltab2x32(:,:,207))
  call Hloop_A_Q(ntryL,G0H16(1),16,nMT,G1H16(71),n2h16(207))
  Gcoeff(:)%j = (-(c(70)*M(4,:)%j)) * den(4)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(208),h0tab(:,208),[16,4,3,8],[nMB,nMZ,nMH,nMB],4,1,wf4(:,6))
  call Hloop_AV_Q(ntryL,G0H32(1),ex5(:),G0H16(1),m3h2x16(:,208),heltab2x32(:,:,208))
  call Hloop_A_Q(ntryL,G0H16(1),16,nMB,G1H16(72),n2h16(208))
  Gcoeff(:)%j = (c(92)*M(4,:)%j) * den(4)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(209),h0tab(:,209),[16,4,3,8],[nMT,nMW,nMW,nMT],4,1,wf4(:,6))
  call Hloop_AV_Q(ntryL,G0H32(1),ex5(:),G0H16(1),m3h2x16(:,209),heltab2x32(:,:,209))
  call Hloop_A_Q(ntryL,G0H16(1),16,nMT,G1H16(73),n2h16(209))
  Gcoeff(:)%j = (c(64)*M(4,:)%j) * den(6)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(210),h0tab(:,210),[16,4,3,8],[nMT,nMW,nMW,nMT],4,1,wf4(:,5))
  call Hloop_AV_Q(ntryL,G0H32(1),ex5(:),G0H16(1),m3h2x16(:,210),heltab2x32(:,:,210))
  call Hloop_A_Q(ntryL,G0H16(1),16,nMT,G1H16(74),n2h16(210))
  Gcoeff(:)%j = (c(48)*M(4,:)%j) * den(4)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(211),h0tab(:,211),[16,4,3,8],[nMT,nMW,nMW,nMT],4,1,wf4(:,6))
  call Hloop_AV_Q(ntryL,G0H32(1),ex5(:),G0H16(1),m3h2x16(:,211),heltab2x32(:,:,211))
  call Hloop_A_Q(ntryL,G0H16(1),16,nMT,G1H16(75),n2h16(211))
  Gcoeff(:)%j = (c(24)*M(3,:)%j) * den(13)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(212),h0tab(:,212),[16,1,8,6],[nMT,nMH,nMB,nMT],4,1,wf4(:,10))
  call Hloop_AV_Q(ntryL,G0H32(1),ex5(:),G0H16(1),m3h2x16(:,212),heltab2x32(:,:,212))
  call Hloop_A_Q(ntryL,G0H16(1),16,nMT,G1H16(76),n2h16(212))
  Gcoeff(:)%j = (c(24)*M(3,:)%j) * den(13)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(213),h0tab(:,213),[16,1,8,6],[nMT,nMZ,nMB,nMT],4,1,wf4(:,10))
  call Hloop_AV_Q(ntryL,G0H32(1),ex5(:),G0H16(1),m3h2x16(:,213),heltab2x32(:,:,213))
  call Hloop_A_Q(ntryL,G0H16(1),16,nMT,G1H16(77),n2h16(213))
  Gcoeff(:)%j = (c(75)*M(3,:)%j) * den(13)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(214),h0tab(:,214),[16,1,8,6],[nMT,0,nMB,nMT],4,1,wf4(:,10))
  call Hloop_AV_Q(ntryL,G0H32(1),ex5(:),G0H16(1),m3h2x16(:,214),heltab2x32(:,:,214))
  call Hloop_A_Q(ntryL,G0H16(1),16,nMT,G1H16(78),n2h16(214))
  Gcoeff(:)%j = (-(c(79)*M(3,:)%j)) * den(13)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(215),h0tab(:,215),[16,1,8,6],[nMT,nMZ,nMB,nMT],4,1,wf4(:,10))
  call Hloop_AV_Q(ntryL,G0H32(1),ex5(:),G0H16(1),m3h2x16(:,215),heltab2x32(:,:,215))
  call Hloop_A_Q(ntryL,G0H16(1),16,nMT,G1H16(79),n2h16(215))
  Gcoeff(:)%j = (c(44)*M(3,:)%j) * den(13)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(216),h0tab(:,216),[16,1,8,6],[nMT,nMH,nMB,nMT],4,1,wf4(:,12))
  call Hloop_AV_Q(ntryL,G0H32(1),ex5(:),G0H16(1),m3h2x16(:,216),heltab2x32(:,:,216))
  call Hloop_A_Q(ntryL,G0H16(1),16,nMT,G1H16(80),n2h16(216))
  Gcoeff(:)%j = (c(44)*M(3,:)%j) * den(13)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(217),h0tab(:,217),[16,1,8,6],[nMT,nMZ,nMB,nMT],4,1,wf4(:,12))
  call Hloop_AV_Q(ntryL,G0H32(1),ex5(:),G0H16(1),m3h2x16(:,217),heltab2x32(:,:,217))
  call Hloop_A_Q(ntryL,G0H16(1),16,nMT,G1H16(81),n2h16(217))
  Gcoeff(:)%j = (c(61)*M(3,:)%j) * den(13)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(218),h0tab(:,218),[16,1,8,6],[nMT,0,nMB,nMT],4,1,wf4(:,12))
  call Hloop_AV_Q(ntryL,G0H32(1),ex5(:),G0H16(1),m3h2x16(:,218),heltab2x32(:,:,218))
  call Hloop_A_Q(ntryL,G0H16(1),16,nMT,G1H16(82),n2h16(218))
  Gcoeff(:)%j = (-(c(65)*M(3,:)%j)) * den(13)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(219),h0tab(:,219),[16,1,8,6],[nMT,nMZ,nMB,nMT],4,1,wf4(:,12))
  call Hloop_AV_Q(ntryL,G0H32(1),ex5(:),G0H16(1),m3h2x16(:,219),heltab2x32(:,:,219))
  call Hloop_A_Q(ntryL,G0H16(1),16,nMT,G1H16(83),n2h16(219))
  Gcoeff(:)%j = (c(24)*M(3,:)%j) * den(13)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(220),h0tab(:,220),[16,6,1,8],[nMB,nMT,nMH,nMB],4,1,wf4(:,10))
  call Hloop_AV_Q(ntryL,G0H32(1),ex5(:),G0H16(1),m3h2x16(:,220),heltab2x32(:,:,220))
  call Hloop_A_Q(ntryL,G0H16(1),16,nMB,G1H16(84),n2h16(220))
  Gcoeff(:)%j = (c(24)*M(3,:)%j) * den(13)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(221),h0tab(:,221),[16,6,1,8],[nMB,nMT,nMZ,nMB],4,1,wf4(:,10))
  call Hloop_AV_Q(ntryL,G0H32(1),ex5(:),G0H16(1),m3h2x16(:,221),heltab2x32(:,:,221))
  call Hloop_A_Q(ntryL,G0H16(1),16,nMB,G1H16(85),n2h16(221))
  Gcoeff(:)%j = (c(75)*M(3,:)%j) * den(13)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(222),h0tab(:,222),[16,6,1,8],[nMB,nMT,0,nMB],4,1,wf4(:,10))
  call Hloop_AV_Q(ntryL,G0H32(1),ex5(:),G0H16(1),m3h2x16(:,222),heltab2x32(:,:,222))
  call Hloop_A_Q(ntryL,G0H16(1),16,nMB,G1H16(86),n2h16(222))
  Gcoeff(:)%j = (-(c(79)*M(3,:)%j)) * den(13)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(223),h0tab(:,223),[16,6,1,8],[nMB,nMT,nMZ,nMB],4,1,wf4(:,10))
  call Hloop_AV_Q(ntryL,G0H32(1),ex5(:),G0H16(1),m3h2x16(:,223),heltab2x32(:,:,223))
  call Hloop_A_Q(ntryL,G0H16(1),16,nMB,G1H16(87),n2h16(223))
  Gcoeff(:)%j = (c(44)*M(3,:)%j) * den(13)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(224),h0tab(:,224),[16,6,1,8],[nMB,nMT,nMH,nMB],4,1,wf4(:,12))
  call Hloop_AV_Q(ntryL,G0H32(1),ex5(:),G0H16(1),m3h2x16(:,224),heltab2x32(:,:,224))
  call Hloop_A_Q(ntryL,G0H16(1),16,nMB,G1H16(88),n2h16(224))
  Gcoeff(:)%j = (c(44)*M(3,:)%j) * den(13)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(225),h0tab(:,225),[16,6,1,8],[nMB,nMT,nMZ,nMB],4,1,wf4(:,12))
  call Hloop_AV_Q(ntryL,G0H32(1),ex5(:),G0H16(1),m3h2x16(:,225),heltab2x32(:,:,225))
  call Hloop_A_Q(ntryL,G0H16(1),16,nMB,G1H16(89),n2h16(225))
  Gcoeff(:)%j = (c(61)*M(3,:)%j) * den(13)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(226),h0tab(:,226),[16,6,1,8],[nMB,nMT,0,nMB],4,1,wf4(:,12))
  call Hloop_AV_Q(ntryL,G0H32(1),ex5(:),G0H16(1),m3h2x16(:,226),heltab2x32(:,:,226))
  call Hloop_A_Q(ntryL,G0H16(1),16,nMB,G1H16(90),n2h16(226))
  Gcoeff(:)%j = (-(c(65)*M(3,:)%j)) * den(13)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(227),h0tab(:,227),[16,6,1,8],[nMB,nMT,nMZ,nMB],4,1,wf4(:,12))
  call Hloop_AV_Q(ntryL,G0H32(1),ex5(:),G0H16(1),m3h2x16(:,227),heltab2x32(:,:,227))
  call Hloop_A_Q(ntryL,G0H16(1),16,nMB,G1H16(91),n2h16(227))
  Gcoeff(:)%j = (c(26)*M(3,:)%j) * den(13)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(228),h0tab(:,228),[16,1,6,8],[nMT,nMH,nMW,nMT],4,1,wf4(:,10))
  call Hloop_AV_Q(ntryL,G0H32(1),ex5(:),G0H16(1),m3h2x16(:,228),heltab2x32(:,:,228))
  call Hloop_A_Q(ntryL,G0H16(1),16,nMT,G1H16(92),n2h16(228))
  Gcoeff(:)%j = (c(22)*M(3,:)%j) * den(13)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(229),h0tab(:,229),[16,1,6,8],[nMB,nMW,nMH,nMB],4,1,wf4(:,10))
  call Hloop_AV_Q(ntryL,G0H32(1),ex5(:),G0H16(1),m3h2x16(:,229),heltab2x32(:,:,229))
  call Hloop_A_Q(ntryL,G0H16(1),16,nMB,G1H16(93),n2h16(229))
  Gcoeff(:)%j = (c(76)*M(3,:)%j) * den(13)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(230),h0tab(:,230),[16,1,6,8],[nMB,nMW,0,nMB],4,1,wf4(:,10))
  call Hloop_AV_Q(ntryL,G0H32(1),ex5(:),G0H16(1),m3h2x16(:,230),heltab2x32(:,:,230))
  call Hloop_A_Q(ntryL,G0H16(1),16,nMB,G1H16(94),n2h16(230))
  Gcoeff(:)%j = (c(104)*M(3,:)%j) * den(13)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(231),h0tab(:,231),[16,1,6,8],[nMB,nMW,nMZ,nMB],4,1,wf4(:,10))
  call Hloop_AV_Q(ntryL,G0H32(1),ex5(:),G0H16(1),m3h2x16(:,231),heltab2x32(:,:,231))
  call Hloop_A_Q(ntryL,G0H16(1),16,nMB,G1H16(95),n2h16(231))
  Gcoeff(:)%j = (c(42)*M(3,:)%j) * den(13)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(232),h0tab(:,232),[16,1,6,8],[nMT,nMH,nMW,nMT],4,1,wf4(:,10))
  call Hloop_AV_Q(ntryL,G0H32(1),ex5(:),G0H16(1),m3h2x16(:,232),heltab2x32(:,:,232))
  call Hloop_A_Q(ntryL,G0H16(1),16,nMT,G1H16(96),n2h16(232))
  Gcoeff(:)%j = (-(c(42)*M(3,:)%j)) * den(13)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(233),h0tab(:,233),[16,1,6,8],[nMT,nMZ,nMW,nMT],4,1,wf4(:,10))
  call Hloop_AV_Q(ntryL,G0H32(1),ex5(:),G0H16(1),m3h2x16(:,233),heltab2x32(:,:,233))
  call Hloop_A_Q(ntryL,G0H16(1),16,nMT,G1H16(97),n2h16(233))
  Gcoeff(:)%j = (-(c(78)*M(3,:)%j)) * den(13)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(234),h0tab(:,234),[16,1,6,8],[nMT,0,nMW,nMT],4,1,wf4(:,10))
  call Hloop_AV_Q(ntryL,G0H32(1),ex5(:),G0H16(1),m3h2x16(:,234),heltab2x32(:,:,234))
  call Hloop_A_Q(ntryL,G0H16(1),16,nMT,G1H16(98),n2h16(234))
  Gcoeff(:)%j = (c(104)*M(3,:)%j) * den(13)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(235),h0tab(:,235),[16,1,6,8],[nMT,nMZ,nMW,nMT],4,1,wf4(:,10))
  call Hloop_AV_Q(ntryL,G0H32(1),ex5(:),G0H16(1),m3h2x16(:,235),heltab2x32(:,:,235))
  call Hloop_A_Q(ntryL,G0H16(1),16,nMT,G1H16(99),n2h16(235))
  Gcoeff(:)%j = (c(39)*M(3,:)%j) * den(13)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(236),h0tab(:,236),[16,1,6,8],[nMB,nMW,nMH,nMB],4,1,wf4(:,10))
  call Hloop_AV_Q(ntryL,G0H32(1),ex5(:),G0H16(1),m3h2x16(:,236),heltab2x32(:,:,236))
  call Hloop_A_Q(ntryL,G0H16(1),16,nMB,G1H16(100),n2h16(236))
  Gcoeff(:)%j = (c(39)*M(3,:)%j) * den(13)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(237),h0tab(:,237),[16,1,6,8],[nMB,nMW,nMZ,nMB],4,1,wf4(:,10))
  call Hloop_AV_Q(ntryL,G0H32(1),ex5(:),G0H16(1),m3h2x16(:,237),heltab2x32(:,:,237))
  call Hloop_A_Q(ntryL,G0H16(1),16,nMB,G1H16(101),n2h16(237))
  Gcoeff(:)%j = (-(c(64)*M(3,:)%j)) * den(13)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(238),h0tab(:,238),[16,1,6,8],[nMT,0,nMW,nMT],4,1,wf4(:,10))
  call Hloop_AV_Q(ntryL,G0H32(1),ex5(:),G0H16(1),m3h2x16(:,238),heltab2x32(:,:,238))
  call Hloop_A_Q(ntryL,G0H16(1),16,nMT,G1H16(102),n2h16(238))
  Gcoeff(:)%j = (c(62)*M(3,:)%j) * den(13)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(239),h0tab(:,239),[16,1,6,8],[nMB,nMW,0,nMB],4,1,wf4(:,10))
  call Hloop_AV_Q(ntryL,G0H32(1),ex5(:),G0H16(1),m3h2x16(:,239),heltab2x32(:,:,239))
  call Hloop_A_Q(ntryL,G0H16(1),16,nMB,G1H16(103),n2h16(239))
  Gcoeff(:)%j = (c(92)*M(3,:)%j) * den(13)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(240),h0tab(:,240),[16,1,6,8],[nMT,nMZ,nMW,nMT],4,1,wf4(:,10))
  call Hloop_AV_Q(ntryL,G0H32(1),ex5(:),G0H16(1),m3h2x16(:,240),heltab2x32(:,:,240))
  call Hloop_A_Q(ntryL,G0H16(1),16,nMT,G1H16(104),n2h16(240))
  Gcoeff(:)%j = (c(92)*M(3,:)%j) * den(13)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(241),h0tab(:,241),[16,1,6,8],[nMB,nMW,nMZ,nMB],4,1,wf4(:,10))
  call Hloop_AV_Q(ntryL,G0H32(1),ex5(:),G0H16(1),m3h2x16(:,241),heltab2x32(:,:,241))
  call Hloop_A_Q(ntryL,G0H16(1),16,nMB,G1H16(105),n2h16(241))
  Gcoeff(:)%j = (c(42)*M(3,:)%j) * den(13)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(242),h0tab(:,242),[16,1,6,8],[nMT,nMH,nMW,nMT],4,1,wf4(:,12))
  call Hloop_AV_Q(ntryL,G0H32(1),ex5(:),G0H16(1),m3h2x16(:,242),heltab2x32(:,:,242))
  call Hloop_A_Q(ntryL,G0H16(1),16,nMT,G1H16(106),n2h16(242))
  Gcoeff(:)%j = (c(39)*M(3,:)%j) * den(13)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(243),h0tab(:,243),[16,1,6,8],[nMB,nMW,nMH,nMB],4,1,wf4(:,12))
  call Hloop_AV_Q(ntryL,G0H32(1),ex5(:),G0H16(1),m3h2x16(:,243),heltab2x32(:,:,243))
  call Hloop_A_Q(ntryL,G0H16(1),16,nMB,G1H16(107),n2h16(243))
  Gcoeff(:)%j = (c(42)*M(3,:)%j) * den(13)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(244),h0tab(:,244),[16,1,6,8],[nMT,nMZ,nMW,nMT],4,1,wf4(:,12))
  call Hloop_AV_Q(ntryL,G0H32(1),ex5(:),G0H16(1),m3h2x16(:,244),heltab2x32(:,:,244))
  call Hloop_A_Q(ntryL,G0H16(1),16,nMT,G1H16(108),n2h16(244))
  Gcoeff(:)%j = (-(c(39)*M(3,:)%j)) * den(13)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(245),h0tab(:,245),[16,1,6,8],[nMB,nMW,nMZ,nMB],4,1,wf4(:,12))
  call Hloop_AV_Q(ntryL,G0H32(1),ex5(:),G0H16(1),m3h2x16(:,245),heltab2x32(:,:,245))
  call Hloop_A_Q(ntryL,G0H16(1),16,nMB,G1H16(109),n2h16(245))
  Gcoeff(:)%j = (-(c(62)*M(3,:)%j)) * den(13)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(246),h0tab(:,246),[16,1,6,8],[nMB,nMW,0,nMB],4,1,wf4(:,12))
  call Hloop_AV_Q(ntryL,G0H32(1),ex5(:),G0H16(1),m3h2x16(:,246),heltab2x32(:,:,246))
  call Hloop_A_Q(ntryL,G0H16(1),16,nMB,G1H16(110),n2h16(246))
  Gcoeff(:)%j = (-(c(92)*M(3,:)%j)) * den(13)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(247),h0tab(:,247),[16,1,6,8],[nMB,nMW,nMZ,nMB],4,1,wf4(:,12))
  call Hloop_AV_Q(ntryL,G0H32(1),ex5(:),G0H16(1),m3h2x16(:,247),heltab2x32(:,:,247))
  call Hloop_A_Q(ntryL,G0H16(1),16,nMB,G1H16(111),n2h16(247))
  Gcoeff(:)%j = (c(15)*M(3,:)%j) * den(13)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(248),h0tab(:,248),[16,1,6,8],[nMT,nMH,nMW,nMT],4,1,wf4(:,12))
  call Hloop_AV_Q(ntryL,G0H32(1),ex5(:),G0H16(1),m3h2x16(:,248),heltab2x32(:,:,248))
  call Hloop_A_Q(ntryL,G0H16(1),16,nMT,G1H16(112),n2h16(248))
  Gcoeff(:)%j = (c(64)*M(3,:)%j) * den(13)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(249),h0tab(:,249),[16,1,6,8],[nMT,0,nMW,nMT],4,1,wf4(:,12))
  call Hloop_AV_Q(ntryL,G0H32(1),ex5(:),G0H16(1),m3h2x16(:,249),heltab2x32(:,:,249))
  call Hloop_A_Q(ntryL,G0H16(1),16,nMT,G1H16(113),n2h16(249))
  Gcoeff(:)%j = (-(c(92)*M(3,:)%j)) * den(13)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(250),h0tab(:,250),[16,1,6,8],[nMT,nMZ,nMW,nMT],4,1,wf4(:,12))
  call Hloop_AV_Q(ntryL,G0H32(1),ex5(:),G0H16(1),m3h2x16(:,250),heltab2x32(:,:,250))
  call Hloop_A_Q(ntryL,G0H16(1),16,nMT,G1H16(114),n2h16(250))
  Gcoeff(:)%j = (c(14)*M(3,:)%j) * den(13)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(251),h0tab(:,251),[16,1,6,8],[nMB,nMW,nMH,nMB],4,1,wf4(:,12))
  call Hloop_AV_Q(ntryL,G0H32(1),ex5(:),G0H16(1),m3h2x16(:,251),heltab2x32(:,:,251))
  call Hloop_A_Q(ntryL,G0H16(1),16,nMB,G1H16(115),n2h16(251))
  Gcoeff(:)%j = (-(c(64)*M(3,:)%j)) * den(13)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(252),h0tab(:,252),[16,1,6,8],[nMT,0,nMW,nMT],4,1,wf4(:,12))
  call Hloop_AV_Q(ntryL,G0H32(1),ex5(:),G0H16(1),m3h2x16(:,252),heltab2x32(:,:,252))
  call Hloop_A_Q(ntryL,G0H16(1),16,nMT,G1H16(116),n2h16(252))
  Gcoeff(:)%j = (c(62)*M(3,:)%j) * den(13)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(253),h0tab(:,253),[16,1,6,8],[nMB,nMW,0,nMB],4,1,wf4(:,12))
  call Hloop_AV_Q(ntryL,G0H32(1),ex5(:),G0H16(1),m3h2x16(:,253),heltab2x32(:,:,253))
  call Hloop_A_Q(ntryL,G0H16(1),16,nMB,G1H16(117),n2h16(253))
  Gcoeff(:)%j = (-(c(48)*M(3,:)%j)) * den(13)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(254),h0tab(:,254),[16,1,6,8],[nMT,nMZ,nMW,nMT],4,1,wf4(:,12))
  call Hloop_AV_Q(ntryL,G0H32(1),ex5(:),G0H16(1),m3h2x16(:,254),heltab2x32(:,:,254))
  call Hloop_A_Q(ntryL,G0H16(1),16,nMT,G1H16(118),n2h16(254))
  Gcoeff(:)%j = (-(c(48)*M(3,:)%j)) * den(13)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(255),h0tab(:,255),[16,1,6,8],[nMB,nMW,nMZ,nMB],4,1,wf4(:,12))
  call Hloop_AV_Q(ntryL,G0H32(1),ex5(:),G0H16(1),m3h2x16(:,255),heltab2x32(:,:,255))
  call Hloop_A_Q(ntryL,G0H16(1),16,nMB,G1H16(119),n2h16(255))
  Gcoeff(:)%j = (c(24)*M(2,:)%j) * den(16)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(256),h0tab(:,256),[16,2,4,9],[nMT,nMH,nMB,nMT],4,1,wf4(:,13))
  call Hloop_QV_A(ntryL,G0H32(1),ex5(:),G0H16(1),m3h2x16(:,256),heltab2x32(:,:,256))
  call Hloop_Q_A(ntryL,G0H16(1),16,nMT,G1H16(120),n2h16(256))
  Gcoeff(:)%j = (c(24)*M(2,:)%j) * den(16)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(257),h0tab(:,257),[16,2,4,9],[nMT,nMZ,nMB,nMT],4,1,wf4(:,13))
  call Hloop_QV_A(ntryL,G0H32(1),ex5(:),G0H16(1),m3h2x16(:,257),heltab2x32(:,:,257))
  call Hloop_Q_A(ntryL,G0H16(1),16,nMT,G1H16(121),n2h16(257))
  Gcoeff(:)%j = (c(75)*M(2,:)%j) * den(16)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(258),h0tab(:,258),[16,2,4,9],[nMT,0,nMB,nMT],4,1,wf4(:,13))
  call Hloop_QV_A(ntryL,G0H32(1),ex5(:),G0H16(1),m3h2x16(:,258),heltab2x32(:,:,258))
  call Hloop_Q_A(ntryL,G0H16(1),16,nMT,G1H16(122),n2h16(258))
  Gcoeff(:)%j = (-(c(79)*M(2,:)%j)) * den(16)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(259),h0tab(:,259),[16,2,4,9],[nMT,nMZ,nMB,nMT],4,1,wf4(:,13))
  call Hloop_QV_A(ntryL,G0H32(1),ex5(:),G0H16(1),m3h2x16(:,259),heltab2x32(:,:,259))
  call Hloop_Q_A(ntryL,G0H16(1),16,nMT,G1H16(123),n2h16(259))
  Gcoeff(:)%j = (c(44)*M(2,:)%j) * den(16)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(260),h0tab(:,260),[16,2,4,9],[nMT,nMH,nMB,nMT],4,1,wf4(:,16))
  call Hloop_QV_A(ntryL,G0H32(1),ex5(:),G0H16(1),m3h2x16(:,260),heltab2x32(:,:,260))
  call Hloop_Q_A(ntryL,G0H16(1),16,nMT,G1H16(124),n2h16(260))
  Gcoeff(:)%j = (c(44)*M(2,:)%j) * den(16)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(261),h0tab(:,261),[16,2,4,9],[nMT,nMZ,nMB,nMT],4,1,wf4(:,16))
  call Hloop_QV_A(ntryL,G0H32(1),ex5(:),G0H16(1),m3h2x16(:,261),heltab2x32(:,:,261))
  call Hloop_Q_A(ntryL,G0H16(1),16,nMT,G1H16(125),n2h16(261))
  Gcoeff(:)%j = (c(61)*M(2,:)%j) * den(16)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(262),h0tab(:,262),[16,2,4,9],[nMT,0,nMB,nMT],4,1,wf4(:,16))
  call Hloop_QV_A(ntryL,G0H32(1),ex5(:),G0H16(1),m3h2x16(:,262),heltab2x32(:,:,262))
  call Hloop_Q_A(ntryL,G0H16(1),16,nMT,G1H16(126),n2h16(262))
  Gcoeff(:)%j = (-(c(65)*M(2,:)%j)) * den(16)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(263),h0tab(:,263),[16,2,4,9],[nMT,nMZ,nMB,nMT],4,1,wf4(:,16))
  call Hloop_QV_A(ntryL,G0H32(1),ex5(:),G0H16(1),m3h2x16(:,263),heltab2x32(:,:,263))
  call Hloop_Q_A(ntryL,G0H16(1),16,nMT,G1H16(127),n2h16(263))
  Gcoeff(:)%j = (c(24)*M(2,:)%j) * den(16)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(264),h0tab(:,264),[16,4,2,9],[nMB,nMH,nMT,nMB],4,1,wf4(:,13))
  call Hloop_AV_Q(ntryL,G0H32(1),ex5(:),G0H16(1),m3h2x16(:,264),heltab2x32(:,:,264))
  call Hloop_A_Q(ntryL,G0H16(1),16,nMB,G1H16(128),n2h16(264))
  Gcoeff(:)%j = (c(24)*M(2,:)%j) * den(16)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(265),h0tab(:,265),[16,4,2,9],[nMB,nMZ,nMT,nMB],4,1,wf4(:,13))
  call Hloop_AV_Q(ntryL,G0H32(1),ex5(:),G0H16(1),m3h2x16(:,265),heltab2x32(:,:,265))
  call Hloop_A_Q(ntryL,G0H16(1),16,nMB,G1H16(129),n2h16(265))
  Gcoeff(:)%j = (c(75)*M(2,:)%j) * den(16)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(266),h0tab(:,266),[16,4,2,9],[nMB,0,nMT,nMB],4,1,wf4(:,13))
  call Hloop_AV_Q(ntryL,G0H32(1),ex5(:),G0H16(1),m3h2x16(:,266),heltab2x32(:,:,266))
  call Hloop_A_Q(ntryL,G0H16(1),16,nMB,G1H16(130),n2h16(266))
  Gcoeff(:)%j = (-(c(79)*M(2,:)%j)) * den(16)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(267),h0tab(:,267),[16,4,2,9],[nMB,nMZ,nMT,nMB],4,1,wf4(:,13))
  call Hloop_AV_Q(ntryL,G0H32(1),ex5(:),G0H16(1),m3h2x16(:,267),heltab2x32(:,:,267))
  call Hloop_A_Q(ntryL,G0H16(1),16,nMB,G1H16(131),n2h16(267))
  Gcoeff(:)%j = (c(44)*M(2,:)%j) * den(16)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(268),h0tab(:,268),[16,4,2,9],[nMB,nMH,nMT,nMB],4,1,wf4(:,16))
  call Hloop_AV_Q(ntryL,G0H32(1),ex5(:),G0H16(1),m3h2x16(:,268),heltab2x32(:,:,268))
  call Hloop_A_Q(ntryL,G0H16(1),16,nMB,G1H16(132),n2h16(268))
  Gcoeff(:)%j = (c(44)*M(2,:)%j) * den(16)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(269),h0tab(:,269),[16,4,2,9],[nMB,nMZ,nMT,nMB],4,1,wf4(:,16))
  call Hloop_AV_Q(ntryL,G0H32(1),ex5(:),G0H16(1),m3h2x16(:,269),heltab2x32(:,:,269))
  call Hloop_A_Q(ntryL,G0H16(1),16,nMB,G1H16(133),n2h16(269))
  Gcoeff(:)%j = (c(61)*M(2,:)%j) * den(16)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(270),h0tab(:,270),[16,4,2,9],[nMB,0,nMT,nMB],4,1,wf4(:,16))
  call Hloop_AV_Q(ntryL,G0H32(1),ex5(:),G0H16(1),m3h2x16(:,270),heltab2x32(:,:,270))
  call Hloop_A_Q(ntryL,G0H16(1),16,nMB,G1H16(134),n2h16(270))
  Gcoeff(:)%j = (-(c(65)*M(2,:)%j)) * den(16)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(271),h0tab(:,271),[16,4,2,9],[nMB,nMZ,nMT,nMB],4,1,wf4(:,16))
  call Hloop_AV_Q(ntryL,G0H32(1),ex5(:),G0H16(1),m3h2x16(:,271),heltab2x32(:,:,271))
  call Hloop_A_Q(ntryL,G0H16(1),16,nMB,G1H16(135),n2h16(271))
  Gcoeff(:)%j = (c(26)*M(2,:)%j) * den(16)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(272),h0tab(:,272),[16,2,9,4],[nMT,nMH,nMW,nMT],4,1,wf4(:,13))
  call Hloop_QV_A(ntryL,G0H32(1),ex5(:),G0H16(1),m3h2x16(:,272),heltab2x32(:,:,272))
  call Hloop_Q_A(ntryL,G0H16(1),16,nMT,G1H16(136),n2h16(272))
  Gcoeff(:)%j = (c(22)*M(2,:)%j) * den(16)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(273),h0tab(:,273),[16,2,9,4],[nMB,nMW,nMH,nMB],4,1,wf4(:,13))
  call Hloop_QV_A(ntryL,G0H32(1),ex5(:),G0H16(1),m3h2x16(:,273),heltab2x32(:,:,273))
  call Hloop_Q_A(ntryL,G0H16(1),16,nMB,G1H16(137),n2h16(273))
  Gcoeff(:)%j = (c(76)*M(2,:)%j) * den(16)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(274),h0tab(:,274),[16,2,9,4],[nMB,nMW,0,nMB],4,1,wf4(:,13))
  call Hloop_QV_A(ntryL,G0H32(1),ex5(:),G0H16(1),m3h2x16(:,274),heltab2x32(:,:,274))
  call Hloop_Q_A(ntryL,G0H16(1),16,nMB,G1H16(138),n2h16(274))
  Gcoeff(:)%j = (c(104)*M(2,:)%j) * den(16)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(275),h0tab(:,275),[16,2,9,4],[nMB,nMW,nMZ,nMB],4,1,wf4(:,13))
  call Hloop_QV_A(ntryL,G0H32(1),ex5(:),G0H16(1),m3h2x16(:,275),heltab2x32(:,:,275))
  call Hloop_Q_A(ntryL,G0H16(1),16,nMB,G1H16(139),n2h16(275))
  Gcoeff(:)%j = (c(42)*M(2,:)%j) * den(16)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(276),h0tab(:,276),[16,2,9,4],[nMT,nMH,nMW,nMT],4,1,wf4(:,13))
  call Hloop_QV_A(ntryL,G0H32(1),ex5(:),G0H16(1),m3h2x16(:,276),heltab2x32(:,:,276))
  call Hloop_Q_A(ntryL,G0H16(1),16,nMT,G1H16(140),n2h16(276))
  Gcoeff(:)%j = (c(42)*M(2,:)%j) * den(16)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(277),h0tab(:,277),[16,2,9,4],[nMT,nMZ,nMW,nMT],4,1,wf4(:,13))
  call Hloop_QV_A(ntryL,G0H32(1),ex5(:),G0H16(1),m3h2x16(:,277),heltab2x32(:,:,277))
  call Hloop_Q_A(ntryL,G0H16(1),16,nMT,G1H16(141),n2h16(277))
  Gcoeff(:)%j = (-(c(78)*M(2,:)%j)) * den(16)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(278),h0tab(:,278),[16,2,9,4],[nMT,0,nMW,nMT],4,1,wf4(:,13))
  call Hloop_QV_A(ntryL,G0H32(1),ex5(:),G0H16(1),m3h2x16(:,278),heltab2x32(:,:,278))
  call Hloop_Q_A(ntryL,G0H16(1),16,nMT,G1H16(142),n2h16(278))
  Gcoeff(:)%j = (c(104)*M(2,:)%j) * den(16)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(279),h0tab(:,279),[16,2,9,4],[nMT,nMZ,nMW,nMT],4,1,wf4(:,13))
  call Hloop_QV_A(ntryL,G0H32(1),ex5(:),G0H16(1),m3h2x16(:,279),heltab2x32(:,:,279))
  call Hloop_Q_A(ntryL,G0H16(1),16,nMT,G1H16(143),n2h16(279))
  Gcoeff(:)%j = (c(39)*M(2,:)%j) * den(16)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(280),h0tab(:,280),[16,2,9,4],[nMB,nMW,nMH,nMB],4,1,wf4(:,13))
  call Hloop_QV_A(ntryL,G0H32(1),ex5(:),G0H16(1),m3h2x16(:,280),heltab2x32(:,:,280))
  call Hloop_Q_A(ntryL,G0H16(1),16,nMB,G1H16(144),n2h16(280))
  Gcoeff(:)%j = (-(c(39)*M(2,:)%j)) * den(16)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(281),h0tab(:,281),[16,2,9,4],[nMB,nMW,nMZ,nMB],4,1,wf4(:,13))
  call Hloop_QV_A(ntryL,G0H32(1),ex5(:),G0H16(1),m3h2x16(:,281),heltab2x32(:,:,281))
  call Hloop_Q_A(ntryL,G0H16(1),16,nMB,G1H16(145),n2h16(281))
  Gcoeff(:)%j = (c(64)*M(2,:)%j) * den(16)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(282),h0tab(:,282),[16,2,9,4],[nMT,0,nMW,nMT],4,1,wf4(:,13))
  call Hloop_QV_A(ntryL,G0H32(1),ex5(:),G0H16(1),m3h2x16(:,282),heltab2x32(:,:,282))
  call Hloop_Q_A(ntryL,G0H16(1),16,nMT,G1H16(146),n2h16(282))
  Gcoeff(:)%j = (-(c(62)*M(2,:)%j)) * den(16)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(283),h0tab(:,283),[16,2,9,4],[nMB,nMW,0,nMB],4,1,wf4(:,13))
  call Hloop_QV_A(ntryL,G0H32(1),ex5(:),G0H16(1),m3h2x16(:,283),heltab2x32(:,:,283))
  call Hloop_Q_A(ntryL,G0H16(1),16,nMB,G1H16(147),n2h16(283))
  Gcoeff(:)%j = (-(c(92)*M(2,:)%j)) * den(16)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(284),h0tab(:,284),[16,2,9,4],[nMT,nMZ,nMW,nMT],4,1,wf4(:,13))
  call Hloop_QV_A(ntryL,G0H32(1),ex5(:),G0H16(1),m3h2x16(:,284),heltab2x32(:,:,284))
  call Hloop_Q_A(ntryL,G0H16(1),16,nMT,G1H16(148),n2h16(284))
  Gcoeff(:)%j = (-(c(92)*M(2,:)%j)) * den(16)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(285),h0tab(:,285),[16,2,9,4],[nMB,nMW,nMZ,nMB],4,1,wf4(:,13))
  call Hloop_QV_A(ntryL,G0H32(1),ex5(:),G0H16(1),m3h2x16(:,285),heltab2x32(:,:,285))
  call Hloop_Q_A(ntryL,G0H16(1),16,nMB,G1H16(149),n2h16(285))
  Gcoeff(:)%j = (c(42)*M(2,:)%j) * den(16)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(286),h0tab(:,286),[16,2,9,4],[nMT,nMH,nMW,nMT],4,1,wf4(:,16))
  call Hloop_QV_A(ntryL,G0H32(1),ex5(:),G0H16(1),m3h2x16(:,286),heltab2x32(:,:,286))
  call Hloop_Q_A(ntryL,G0H16(1),16,nMT,G1H16(150),n2h16(286))
  Gcoeff(:)%j = (c(39)*M(2,:)%j) * den(16)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(287),h0tab(:,287),[16,2,9,4],[nMB,nMW,nMH,nMB],4,1,wf4(:,16))
  call Hloop_QV_A(ntryL,G0H32(1),ex5(:),G0H16(1),m3h2x16(:,287),heltab2x32(:,:,287))
  call Hloop_Q_A(ntryL,G0H16(1),16,nMB,G1H16(151),n2h16(287))
  Gcoeff(:)%j = (-(c(42)*M(2,:)%j)) * den(16)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(288),h0tab(:,288),[16,2,9,4],[nMT,nMZ,nMW,nMT],4,1,wf4(:,16))
  call Hloop_QV_A(ntryL,G0H32(1),ex5(:),G0H16(1),m3h2x16(:,288),heltab2x32(:,:,288))
  call Hloop_Q_A(ntryL,G0H16(1),16,nMT,G1H16(152),n2h16(288))
  Gcoeff(:)%j = (c(39)*M(2,:)%j) * den(16)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(289),h0tab(:,289),[16,2,9,4],[nMB,nMW,nMZ,nMB],4,1,wf4(:,16))
  call Hloop_QV_A(ntryL,G0H32(1),ex5(:),G0H16(1),m3h2x16(:,289),heltab2x32(:,:,289))
  call Hloop_Q_A(ntryL,G0H16(1),16,nMB,G1H16(153),n2h16(289))
  Gcoeff(:)%j = (c(62)*M(2,:)%j) * den(16)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(290),h0tab(:,290),[16,2,9,4],[nMB,nMW,0,nMB],4,1,wf4(:,16))
  call Hloop_QV_A(ntryL,G0H32(1),ex5(:),G0H16(1),m3h2x16(:,290),heltab2x32(:,:,290))
  call Hloop_Q_A(ntryL,G0H16(1),16,nMB,G1H16(154),n2h16(290))
  Gcoeff(:)%j = (c(92)*M(2,:)%j) * den(16)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(291),h0tab(:,291),[16,2,9,4],[nMB,nMW,nMZ,nMB],4,1,wf4(:,16))
  call Hloop_QV_A(ntryL,G0H32(1),ex5(:),G0H16(1),m3h2x16(:,291),heltab2x32(:,:,291))
  call Hloop_Q_A(ntryL,G0H16(1),16,nMB,G1H16(155),n2h16(291))
  Gcoeff(:)%j = (c(15)*M(2,:)%j) * den(16)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(292),h0tab(:,292),[16,2,9,4],[nMT,nMH,nMW,nMT],4,1,wf4(:,16))
  call Hloop_QV_A(ntryL,G0H32(1),ex5(:),G0H16(1),m3h2x16(:,292),heltab2x32(:,:,292))
  call Hloop_Q_A(ntryL,G0H16(1),16,nMT,G1H16(156),n2h16(292))
  Gcoeff(:)%j = (-(c(64)*M(2,:)%j)) * den(16)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(293),h0tab(:,293),[16,2,9,4],[nMT,0,nMW,nMT],4,1,wf4(:,16))
  call Hloop_QV_A(ntryL,G0H32(1),ex5(:),G0H16(1),m3h2x16(:,293),heltab2x32(:,:,293))
  call Hloop_Q_A(ntryL,G0H16(1),16,nMT,G1H16(157),n2h16(293))
  Gcoeff(:)%j = (c(92)*M(2,:)%j) * den(16)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(294),h0tab(:,294),[16,2,9,4],[nMT,nMZ,nMW,nMT],4,1,wf4(:,16))
  call Hloop_QV_A(ntryL,G0H32(1),ex5(:),G0H16(1),m3h2x16(:,294),heltab2x32(:,:,294))
  call Hloop_Q_A(ntryL,G0H16(1),16,nMT,G1H16(158),n2h16(294))
  Gcoeff(:)%j = (c(14)*M(2,:)%j) * den(16)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(295),h0tab(:,295),[16,2,9,4],[nMB,nMW,nMH,nMB],4,1,wf4(:,16))
  call Hloop_QV_A(ntryL,G0H32(1),ex5(:),G0H16(1),m3h2x16(:,295),heltab2x32(:,:,295))
  call Hloop_Q_A(ntryL,G0H16(1),16,nMB,G1H16(159),n2h16(295))
  Gcoeff(:)%j = (-(c(64)*M(2,:)%j)) * den(16)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(296),h0tab(:,296),[16,2,9,4],[nMT,0,nMW,nMT],4,1,wf4(:,16))
  call Hloop_QV_A(ntryL,G0H32(1),ex5(:),G0H16(1),m3h2x16(:,296),heltab2x32(:,:,296))
  call Hloop_Q_A(ntryL,G0H16(1),16,nMT,G1H16(160),n2h16(296))
  Gcoeff(:)%j = (c(62)*M(2,:)%j) * den(16)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(297),h0tab(:,297),[16,2,9,4],[nMB,nMW,0,nMB],4,1,wf4(:,16))
  call Hloop_QV_A(ntryL,G0H32(1),ex5(:),G0H16(1),m3h2x16(:,297),heltab2x32(:,:,297))
  call Hloop_Q_A(ntryL,G0H16(1),16,nMB,G1H16(161),n2h16(297))
  Gcoeff(:)%j = (-(c(48)*M(2,:)%j)) * den(16)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(298),h0tab(:,298),[16,2,9,4],[nMT,nMZ,nMW,nMT],4,1,wf4(:,16))
  call Hloop_QV_A(ntryL,G0H32(1),ex5(:),G0H16(1),m3h2x16(:,298),heltab2x32(:,:,298))
  call Hloop_Q_A(ntryL,G0H16(1),16,nMT,G1H16(162),n2h16(298))
  Gcoeff(:)%j = (-(c(48)*M(2,:)%j)) * den(16)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(299),h0tab(:,299),[16,2,9,4],[nMB,nMW,nMZ,nMB],4,1,wf4(:,16))
  call Hloop_QV_A(ntryL,G0H32(1),ex5(:),G0H16(1),m3h2x16(:,299),heltab2x32(:,:,299))
  call Hloop_Q_A(ntryL,G0H16(1),16,nMB,G1H16(163),n2h16(299))
  Gcoeff(:)%j = (c(36)*M(1,:)%j) * den(20)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(300),h0tab(:,300),[16,1,2,12],[nMT,nMH,nMT,nMT],4,1,wf4(:,17))
  call Hloop_AV_Q(ntryL,G0H32(1),ex5(:),G0H16(1),m3h2x16(:,300),heltab2x32(:,:,300))
  call Hloop_A_Q(ntryL,G0H16(1),16,nMT,G1H16(164),n2h16(300))
  Gcoeff(:)%j = (-(c(36)*M(1,:)%j)) * den(20)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(301),h0tab(:,301),[16,1,2,12],[nMT,nMZ,nMT,nMT],4,1,wf4(:,17))
  call Hloop_AV_Q(ntryL,G0H32(1),ex5(:),G0H16(1),m3h2x16(:,301),heltab2x32(:,:,301))
  call Hloop_A_Q(ntryL,G0H16(1),16,nMT,G1H16(165),n2h16(301))
  Gcoeff(:)%j = (-(c(21)*M(1,:)%j)) * den(20)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(302),h0tab(:,302),[16,1,2,12],[nMB,nMW,nMB,nMB],4,1,wf4(:,17))
  call Hloop_AV_Q(ntryL,G0H32(1),ex5(:),G0H16(1),m3h2x16(:,302),heltab2x32(:,:,302))
  call Hloop_A_Q(ntryL,G0H16(1),16,nMB,G1H16(166),n2h16(302))
  Gcoeff(:)%j = (c(36)*M(1,:)%j) * den(22)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(303),h0tab(:,303),[16,1,2,12],[nMT,nMH,nMT,nMT],4,1,wf4(:,18))
  call Hloop_AV_Q(ntryL,G0H32(1),ex5(:),G0H16(1),m3h2x16(:,303),heltab2x32(:,:,303))
  call Hloop_A_Q(ntryL,G0H16(1),16,nMT,G1H16(167),n2h16(303))
  Gcoeff(:)%j = (-(c(36)*M(1,:)%j)) * den(22)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(304),h0tab(:,304),[16,1,2,12],[nMT,nMZ,nMT,nMT],4,1,wf4(:,18))
  call Hloop_AV_Q(ntryL,G0H32(1),ex5(:),G0H16(1),m3h2x16(:,304),heltab2x32(:,:,304))
  call Hloop_A_Q(ntryL,G0H16(1),16,nMT,G1H16(168),n2h16(304))
  Gcoeff(:)%j = (c(21)*M(1,:)%j) * den(22)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(305),h0tab(:,305),[16,1,2,12],[nMB,nMW,nMB,nMB],4,1,wf4(:,18))
  call Hloop_AV_Q(ntryL,G0H32(1),ex5(:),G0H16(1),m3h2x16(:,305),heltab2x32(:,:,305))
  call Hloop_A_Q(ntryL,G0H16(1),16,nMB,G1H16(169),n2h16(305))
  Gcoeff(:)%j = (-(c(85)*M(1,:)%j)) * den(20)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(306),h0tab(:,306),[16,1,2,12],[nMT,0,nMT,nMT],4,1,wf4(:,17))
  call Hloop_AV_Q(ntryL,G0H32(1),ex5(:),G0H16(1),m3h2x16(:,306),heltab2x32(:,:,306))
  call Hloop_A_Q(ntryL,G0H16(1),16,nMT,G1H16(170),n2h16(306))
  Gcoeff(:)%j = (-(c(86)*M(1,:)%j)) * den(20)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(307),h0tab(:,307),[16,1,2,12],[nMT,nMZ,nMT,nMT],4,1,wf4(:,17))
  call Hloop_AV_Q(ntryL,G0H32(1),ex5(:),G0H16(1),m3h2x16(:,307),heltab2x32(:,:,307))
  call Hloop_A_Q(ntryL,G0H16(1),16,nMT,G1H16(171),n2h16(307))
  Gcoeff(:)%j = (-(c(40)*M(1,:)%j)) * den(20)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(308),h0tab(:,308),[16,1,2,12],[nMB,nMW,nMB,nMB],4,1,wf4(:,17))
  call Hloop_AV_Q(ntryL,G0H32(1),ex5(:),G0H16(1),m3h2x16(:,308),heltab2x32(:,:,308))
  call Hloop_A_Q(ntryL,G0H16(1),16,nMB,G1H16(172),n2h16(308))
  Gcoeff(:)%j = (-(c(85)*M(1,:)%j)) * den(22)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(309),h0tab(:,309),[16,1,2,12],[nMT,0,nMT,nMT],4,1,wf4(:,18))
  call Hloop_AV_Q(ntryL,G0H32(1),ex5(:),G0H16(1),m3h2x16(:,309),heltab2x32(:,:,309))
  call Hloop_A_Q(ntryL,G0H16(1),16,nMT,G1H16(173),n2h16(309))
  Gcoeff(:)%j = (-(c(86)*M(1,:)%j)) * den(22)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(310),h0tab(:,310),[16,1,2,12],[nMT,nMZ,nMT,nMT],4,1,wf4(:,18))
  call Hloop_AV_Q(ntryL,G0H32(1),ex5(:),G0H16(1),m3h2x16(:,310),heltab2x32(:,:,310))
  call Hloop_A_Q(ntryL,G0H16(1),16,nMT,G1H16(174),n2h16(310))
  Gcoeff(:)%j = (c(40)*M(1,:)%j) * den(22)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(311),h0tab(:,311),[16,1,2,12],[nMB,nMW,nMB,nMB],4,1,wf4(:,18))
  call Hloop_AV_Q(ntryL,G0H32(1),ex5(:),G0H16(1),m3h2x16(:,311),heltab2x32(:,:,311))
  call Hloop_A_Q(ntryL,G0H16(1),16,nMB,G1H16(175),n2h16(311))
  Gcoeff(:)%j = (c(88)*M(1,:)%j) * den(24)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(312),h0tab(:,312),[16,1,2,12],[nMT,nMH,nMT,nMT],4,1,wf4(:,19))
  call Hloop_AV_Q(ntryL,G0H32(1),ex5(:),G0H16(1),m3h2x16(:,312),heltab2x32(:,:,312))
  call Hloop_A_Q(ntryL,G0H16(1),16,nMT,G1H16(176),n2h16(312))
  Gcoeff(:)%j = (-(c(88)*M(1,:)%j)) * den(24)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(313),h0tab(:,313),[16,1,2,12],[nMT,nMZ,nMT,nMT],4,1,wf4(:,19))
  call Hloop_AV_Q(ntryL,G0H32(1),ex5(:),G0H16(1),m3h2x16(:,313),heltab2x32(:,:,313))
  call Hloop_A_Q(ntryL,G0H16(1),16,nMT,G1H16(177),n2h16(313))
  Gcoeff(:)%j = (c(74)*M(1,:)%j) * den(24)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(314),h0tab(:,314),[16,1,2,12],[nMB,nMW,nMB,nMB],4,1,wf4(:,19))
  call Hloop_AV_Q(ntryL,G0H32(1),ex5(:),G0H16(1),m3h2x16(:,314),heltab2x32(:,:,314))
  call Hloop_A_Q(ntryL,G0H16(1),16,nMB,G1H16(178),n2h16(314))
  Gcoeff(:)%j = (-(c(89)*M(1,:)%j)) * den(22)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(315),h0tab(:,315),[16,1,2,12],[nMT,nMH,nMT,nMT],4,1,wf4(:,20))
  call Hloop_AV_Q(ntryL,G0H32(1),ex5(:),G0H16(1),m3h2x16(:,315),heltab2x32(:,:,315))
  call Hloop_A_Q(ntryL,G0H16(1),16,nMT,G1H16(179),n2h16(315))
  Gcoeff(:)%j = (c(89)*M(1,:)%j) * den(22)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(316),h0tab(:,316),[16,1,2,12],[nMT,nMZ,nMT,nMT],4,1,wf4(:,20))
  call Hloop_AV_Q(ntryL,G0H32(1),ex5(:),G0H16(1),m3h2x16(:,316),heltab2x32(:,:,316))
  call Hloop_A_Q(ntryL,G0H16(1),16,nMT,G1H16(180),n2h16(316))
  Gcoeff(:)%j = (c(79)*M(1,:)%j) * den(22)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(317),h0tab(:,317),[16,1,2,12],[nMB,nMW,nMB,nMB],4,1,wf4(:,20))
  call Hloop_AV_Q(ntryL,G0H32(1),ex5(:),G0H16(1),m3h2x16(:,317),heltab2x32(:,:,317))
  call Hloop_A_Q(ntryL,G0H16(1),16,nMB,G1H16(181),n2h16(317))
  Gcoeff(:)%j = (-(c(3)*M(1,:)%j)) * den(24)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(318),h0tab(:,318),[16,1,2,12],[nMT,0,nMT,nMT],4,1,wf4(:,19))
  call Hloop_AV_Q(ntryL,G0H32(1),ex5(:),G0H16(1),m3h2x16(:,318),heltab2x32(:,:,318))
  call Hloop_A_Q(ntryL,G0H16(1),16,nMT,G1H16(182),n2h16(318))
  Gcoeff(:)%j = (-(c(5)*M(1,:)%j)) * den(24)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(319),h0tab(:,319),[16,1,2,12],[nMT,nMZ,nMT,nMT],4,1,wf4(:,19))
  call Hloop_AV_Q(ntryL,G0H32(1),ex5(:),G0H16(1),m3h2x16(:,319),heltab2x32(:,:,319))
  call Hloop_A_Q(ntryL,G0H16(1),16,nMT,G1H16(183),n2h16(319))
  Gcoeff(:)%j = (c(60)*M(1,:)%j) * den(24)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(320),h0tab(:,320),[16,1,2,12],[nMB,nMW,nMB,nMB],4,1,wf4(:,19))
  call Hloop_AV_Q(ntryL,G0H32(1),ex5(:),G0H16(1),m3h2x16(:,320),heltab2x32(:,:,320))
  call Hloop_A_Q(ntryL,G0H16(1),16,nMB,G1H16(184),n2h16(320))
  Gcoeff(:)%j = (c(6)*M(1,:)%j) * den(22)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(321),h0tab(:,321),[16,1,2,12],[nMT,0,nMT,nMT],4,1,wf4(:,20))
  call Hloop_AV_Q(ntryL,G0H32(1),ex5(:),G0H16(1),m3h2x16(:,321),heltab2x32(:,:,321))
  call Hloop_A_Q(ntryL,G0H16(1),16,nMT,G1H16(185),n2h16(321))
  Gcoeff(:)%j = (c(7)*M(1,:)%j) * den(22)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(322),h0tab(:,322),[16,1,2,12],[nMT,nMZ,nMT,nMT],4,1,wf4(:,20))
  call Hloop_AV_Q(ntryL,G0H32(1),ex5(:),G0H16(1),m3h2x16(:,322),heltab2x32(:,:,322))
  call Hloop_A_Q(ntryL,G0H16(1),16,nMT,G1H16(186),n2h16(322))
  Gcoeff(:)%j = (c(65)*M(1,:)%j) * den(22)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(323),h0tab(:,323),[16,1,2,12],[nMB,nMW,nMB,nMB],4,1,wf4(:,20))
  call Hloop_AV_Q(ntryL,G0H32(1),ex5(:),G0H16(1),m3h2x16(:,323),heltab2x32(:,:,323))
  call Hloop_A_Q(ntryL,G0H16(1),16,nMB,G1H16(187),n2h16(323))
  Gcoeff(:)%j = (c(36)*M(1,:)%j) * den(20)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(324),h0tab(:,324),[16,2,1,12],[nMT,nMH,nMT,nMT],4,1,wf4(:,17))
  call Hloop_QV_A(ntryL,G0H32(1),ex5(:),G0H16(1),m3h2x16(:,324),heltab2x32(:,:,324))
  call Hloop_Q_A(ntryL,G0H16(1),16,nMT,G1H16(188),n2h16(324))
  Gcoeff(:)%j = (-(c(36)*M(1,:)%j)) * den(20)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(325),h0tab(:,325),[16,2,1,12],[nMT,nMZ,nMT,nMT],4,1,wf4(:,17))
  call Hloop_QV_A(ntryL,G0H32(1),ex5(:),G0H16(1),m3h2x16(:,325),heltab2x32(:,:,325))
  call Hloop_Q_A(ntryL,G0H16(1),16,nMT,G1H16(189),n2h16(325))
  Gcoeff(:)%j = (-(c(21)*M(1,:)%j)) * den(20)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(326),h0tab(:,326),[16,2,1,12],[nMB,nMW,nMB,nMB],4,1,wf4(:,17))
  call Hloop_QV_A(ntryL,G0H32(1),ex5(:),G0H16(1),m3h2x16(:,326),heltab2x32(:,:,326))
  call Hloop_Q_A(ntryL,G0H16(1),16,nMB,G1H16(190),n2h16(326))
  Gcoeff(:)%j = (c(36)*M(1,:)%j) * den(22)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(327),h0tab(:,327),[16,2,1,12],[nMT,nMH,nMT,nMT],4,1,wf4(:,18))
  call Hloop_QV_A(ntryL,G0H32(1),ex5(:),G0H16(1),m3h2x16(:,327),heltab2x32(:,:,327))
  call Hloop_Q_A(ntryL,G0H16(1),16,nMT,G1H16(191),n2h16(327))
  Gcoeff(:)%j = (-(c(36)*M(1,:)%j)) * den(22)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(328),h0tab(:,328),[16,2,1,12],[nMT,nMZ,nMT,nMT],4,1,wf4(:,18))
  call Hloop_QV_A(ntryL,G0H32(1),ex5(:),G0H16(1),m3h2x16(:,328),heltab2x32(:,:,328))
  call Hloop_Q_A(ntryL,G0H16(1),16,nMT,G1H16(192),n2h16(328))
  Gcoeff(:)%j = (c(21)*M(1,:)%j) * den(22)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(329),h0tab(:,329),[16,2,1,12],[nMB,nMW,nMB,nMB],4,1,wf4(:,18))
  call Hloop_QV_A(ntryL,G0H32(1),ex5(:),G0H16(1),m3h2x16(:,329),heltab2x32(:,:,329))
  call Hloop_Q_A(ntryL,G0H16(1),16,nMB,G1H16(193),n2h16(329))
  Gcoeff(:)%j = (-(c(85)*M(1,:)%j)) * den(20)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(330),h0tab(:,330),[16,2,1,12],[nMT,0,nMT,nMT],4,1,wf4(:,17))
  call Hloop_QV_A(ntryL,G0H32(1),ex5(:),G0H16(1),m3h2x16(:,330),heltab2x32(:,:,330))
  call Hloop_Q_A(ntryL,G0H16(1),16,nMT,G1H16(194),n2h16(330))
  Gcoeff(:)%j = (-(c(86)*M(1,:)%j)) * den(20)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(331),h0tab(:,331),[16,2,1,12],[nMT,nMZ,nMT,nMT],4,1,wf4(:,17))
  call Hloop_QV_A(ntryL,G0H32(1),ex5(:),G0H16(1),m3h2x16(:,331),heltab2x32(:,:,331))
  call Hloop_Q_A(ntryL,G0H16(1),16,nMT,G1H16(195),n2h16(331))
  Gcoeff(:)%j = (-(c(40)*M(1,:)%j)) * den(20)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(332),h0tab(:,332),[16,2,1,12],[nMB,nMW,nMB,nMB],4,1,wf4(:,17))
  call Hloop_QV_A(ntryL,G0H32(1),ex5(:),G0H16(1),m3h2x16(:,332),heltab2x32(:,:,332))
  call Hloop_Q_A(ntryL,G0H16(1),16,nMB,G1H16(196),n2h16(332))
  Gcoeff(:)%j = (-(c(85)*M(1,:)%j)) * den(22)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(333),h0tab(:,333),[16,2,1,12],[nMT,0,nMT,nMT],4,1,wf4(:,18))
  call Hloop_QV_A(ntryL,G0H32(1),ex5(:),G0H16(1),m3h2x16(:,333),heltab2x32(:,:,333))
  call Hloop_Q_A(ntryL,G0H16(1),16,nMT,G1H16(197),n2h16(333))
  Gcoeff(:)%j = (-(c(86)*M(1,:)%j)) * den(22)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(334),h0tab(:,334),[16,2,1,12],[nMT,nMZ,nMT,nMT],4,1,wf4(:,18))
  call Hloop_QV_A(ntryL,G0H32(1),ex5(:),G0H16(1),m3h2x16(:,334),heltab2x32(:,:,334))
  call Hloop_Q_A(ntryL,G0H16(1),16,nMT,G1H16(198),n2h16(334))
  Gcoeff(:)%j = (c(40)*M(1,:)%j) * den(22)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(335),h0tab(:,335),[16,2,1,12],[nMB,nMW,nMB,nMB],4,1,wf4(:,18))
  call Hloop_QV_A(ntryL,G0H32(1),ex5(:),G0H16(1),m3h2x16(:,335),heltab2x32(:,:,335))
  call Hloop_Q_A(ntryL,G0H16(1),16,nMB,G1H16(199),n2h16(335))
  Gcoeff(:)%j = (c(88)*M(1,:)%j) * den(24)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(336),h0tab(:,336),[16,2,1,12],[nMT,nMH,nMT,nMT],4,1,wf4(:,19))
  call Hloop_QV_A(ntryL,G0H32(1),ex5(:),G0H16(1),m3h2x16(:,336),heltab2x32(:,:,336))
  call Hloop_Q_A(ntryL,G0H16(1),16,nMT,G1H16(200),n2h16(336))
  Gcoeff(:)%j = (-(c(88)*M(1,:)%j)) * den(24)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(337),h0tab(:,337),[16,2,1,12],[nMT,nMZ,nMT,nMT],4,1,wf4(:,19))
  call Hloop_QV_A(ntryL,G0H32(1),ex5(:),G0H16(1),m3h2x16(:,337),heltab2x32(:,:,337))
  call Hloop_Q_A(ntryL,G0H16(1),16,nMT,G1H16(201),n2h16(337))
  Gcoeff(:)%j = (c(74)*M(1,:)%j) * den(24)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(338),h0tab(:,338),[16,2,1,12],[nMB,nMW,nMB,nMB],4,1,wf4(:,19))
  call Hloop_QV_A(ntryL,G0H32(1),ex5(:),G0H16(1),m3h2x16(:,338),heltab2x32(:,:,338))
  call Hloop_Q_A(ntryL,G0H16(1),16,nMB,G1H16(202),n2h16(338))
  Gcoeff(:)%j = (-(c(89)*M(1,:)%j)) * den(22)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(339),h0tab(:,339),[16,2,1,12],[nMT,nMH,nMT,nMT],4,1,wf4(:,20))
  call Hloop_QV_A(ntryL,G0H32(1),ex5(:),G0H16(1),m3h2x16(:,339),heltab2x32(:,:,339))
  call Hloop_Q_A(ntryL,G0H16(1),16,nMT,G1H16(203),n2h16(339))
  Gcoeff(:)%j = (c(89)*M(1,:)%j) * den(22)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(340),h0tab(:,340),[16,2,1,12],[nMT,nMZ,nMT,nMT],4,1,wf4(:,20))
  call Hloop_QV_A(ntryL,G0H32(1),ex5(:),G0H16(1),m3h2x16(:,340),heltab2x32(:,:,340))
  call Hloop_Q_A(ntryL,G0H16(1),16,nMT,G1H16(204),n2h16(340))
  Gcoeff(:)%j = (c(79)*M(1,:)%j) * den(22)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(341),h0tab(:,341),[16,2,1,12],[nMB,nMW,nMB,nMB],4,1,wf4(:,20))
  call Hloop_QV_A(ntryL,G0H32(1),ex5(:),G0H16(1),m3h2x16(:,341),heltab2x32(:,:,341))
  call Hloop_Q_A(ntryL,G0H16(1),16,nMB,G1H16(205),n2h16(341))
  Gcoeff(:)%j = (-(c(3)*M(1,:)%j)) * den(24)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(342),h0tab(:,342),[16,2,1,12],[nMT,0,nMT,nMT],4,1,wf4(:,19))
  call Hloop_QV_A(ntryL,G0H32(1),ex5(:),G0H16(1),m3h2x16(:,342),heltab2x32(:,:,342))
  call Hloop_Q_A(ntryL,G0H16(1),16,nMT,G1H16(206),n2h16(342))
  Gcoeff(:)%j = (-(c(5)*M(1,:)%j)) * den(24)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(343),h0tab(:,343),[16,2,1,12],[nMT,nMZ,nMT,nMT],4,1,wf4(:,19))
  call Hloop_QV_A(ntryL,G0H32(1),ex5(:),G0H16(1),m3h2x16(:,343),heltab2x32(:,:,343))
  call Hloop_Q_A(ntryL,G0H16(1),16,nMT,G1H16(207),n2h16(343))
  Gcoeff(:)%j = (c(60)*M(1,:)%j) * den(24)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(344),h0tab(:,344),[16,2,1,12],[nMB,nMW,nMB,nMB],4,1,wf4(:,19))
  call Hloop_QV_A(ntryL,G0H32(1),ex5(:),G0H16(1),m3h2x16(:,344),heltab2x32(:,:,344))
  call Hloop_Q_A(ntryL,G0H16(1),16,nMB,G1H16(208),n2h16(344))
  Gcoeff(:)%j = (c(6)*M(1,:)%j) * den(22)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(345),h0tab(:,345),[16,2,1,12],[nMT,0,nMT,nMT],4,1,wf4(:,20))
  call Hloop_QV_A(ntryL,G0H32(1),ex5(:),G0H16(1),m3h2x16(:,345),heltab2x32(:,:,345))
  call Hloop_Q_A(ntryL,G0H16(1),16,nMT,G1H16(209),n2h16(345))
  Gcoeff(:)%j = (c(7)*M(1,:)%j) * den(22)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(346),h0tab(:,346),[16,2,1,12],[nMT,nMZ,nMT,nMT],4,1,wf4(:,20))
  call Hloop_QV_A(ntryL,G0H32(1),ex5(:),G0H16(1),m3h2x16(:,346),heltab2x32(:,:,346))
  call Hloop_Q_A(ntryL,G0H16(1),16,nMT,G1H16(210),n2h16(346))
  Gcoeff(:)%j = (c(65)*M(1,:)%j) * den(22)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(347),h0tab(:,347),[16,2,1,12],[nMB,nMW,nMB,nMB],4,1,wf4(:,20))
  call Hloop_QV_A(ntryL,G0H32(1),ex5(:),G0H16(1),m3h2x16(:,347),heltab2x32(:,:,347))
  call Hloop_Q_A(ntryL,G0H16(1),16,nMB,G1H16(211),n2h16(347))
  Gcoeff(:)%j = (c(35)*M(1,:)%j) * den(20)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(348),h0tab(:,348),[16,1,12,2],[nMT,nMH,nMH,nMT],4,1,wf4(:,17))
  call Hloop_AV_Q(ntryL,G0H32(1),ex5(:),G0H16(1),m3h2x16(:,348),heltab2x32(:,:,348))
  call Hloop_A_Q(ntryL,G0H16(1),16,nMT,G1H16(212),n2h16(348))
  Gcoeff(:)%j = (-(c(34)*M(1,:)%j)) * den(20)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(349),h0tab(:,349),[16,1,12,2],[nMT,nMZ,nMZ,nMT],4,1,wf4(:,17))
  call Hloop_AV_Q(ntryL,G0H32(1),ex5(:),G0H16(1),m3h2x16(:,349),heltab2x32(:,:,349))
  call Hloop_A_Q(ntryL,G0H16(1),16,nMT,G1H16(213),n2h16(349))
  Gcoeff(:)%j = (-(c(22)*M(1,:)%j)) * den(20)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(350),h0tab(:,350),[16,1,12,2],[nMB,nMW,nMW,nMB],4,1,wf4(:,17))
  call Hloop_AV_Q(ntryL,G0H32(1),ex5(:),G0H16(1),m3h2x16(:,350),heltab2x32(:,:,350))
  call Hloop_A_Q(ntryL,G0H16(1),16,nMB,G1H16(214),n2h16(350))
  Gcoeff(:)%j = (c(34)*M(1,:)%j) * den(22)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(351),h0tab(:,351),[16,1,12,2],[nMT,nMH,nMZ,nMT],4,1,wf4(:,18))
  call Hloop_AV_Q(ntryL,G0H32(1),ex5(:),G0H16(1),m3h2x16(:,351),heltab2x32(:,:,351))
  call Hloop_A_Q(ntryL,G0H16(1),16,nMT,G1H16(215),n2h16(351))
  Gcoeff(:)%j = (c(34)*M(1,:)%j) * den(22)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(352),h0tab(:,352),[16,1,12,2],[nMT,nMZ,nMH,nMT],4,1,wf4(:,18))
  call Hloop_AV_Q(ntryL,G0H32(1),ex5(:),G0H16(1),m3h2x16(:,352),heltab2x32(:,:,352))
  call Hloop_A_Q(ntryL,G0H16(1),16,nMT,G1H16(216),n2h16(352))
  Gcoeff(:)%j = (-(c(57)*M(1,:)%j)) * den(20)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(353),h0tab(:,353),[16,1,12,2],[nMT,nMZ,nMZ,nMT],4,1,wf4(:,17))
  call Hloop_AV_Q(ntryL,G0H32(1),ex5(:),G0H16(1),m3h2x16(:,353),heltab2x32(:,:,353))
  call Hloop_A_Q(ntryL,G0H16(1),16,nMT,G1H16(217),n2h16(353))
  Gcoeff(:)%j = (-(c(39)*M(1,:)%j)) * den(20)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(354),h0tab(:,354),[16,1,12,2],[nMB,nMW,nMW,nMB],4,1,wf4(:,17))
  call Hloop_AV_Q(ntryL,G0H32(1),ex5(:),G0H16(1),m3h2x16(:,354),heltab2x32(:,:,354))
  call Hloop_A_Q(ntryL,G0H16(1),16,nMB,G1H16(218),n2h16(354))
  Gcoeff(:)%j = (c(57)*M(1,:)%j) * den(22)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(355),h0tab(:,355),[16,1,12,2],[nMT,nMH,nMZ,nMT],4,1,wf4(:,18))
  call Hloop_AV_Q(ntryL,G0H32(1),ex5(:),G0H16(1),m3h2x16(:,355),heltab2x32(:,:,355))
  call Hloop_A_Q(ntryL,G0H16(1),16,nMT,G1H16(219),n2h16(355))
  Gcoeff(:)%j = (c(39)*M(1,:)%j) * den(22)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(356),h0tab(:,356),[16,1,12,2],[nMB,nMW,nMW,nMB],4,1,wf4(:,18))
  call Hloop_AV_Q(ntryL,G0H32(1),ex5(:),G0H16(1),m3h2x16(:,356),heltab2x32(:,:,356))
  call Hloop_A_Q(ntryL,G0H16(1),16,nMB,G1H16(220),n2h16(356))
  Gcoeff(:)%j = (-(c(57)*M(1,:)%j)) * den(20)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(357),h0tab(:,357),[16,1,12,2],[nMT,nMZ,nMZ,nMT],4,1,wf4(:,17))
  call Hloop_AV_Q(ntryL,G0H32(1),ex5(:),G0H16(1),m3h2x16(:,357),heltab2x32(:,:,357))
  call Hloop_A_Q(ntryL,G0H16(1),16,nMT,G1H16(221),n2h16(357))
  Gcoeff(:)%j = (-(c(39)*M(1,:)%j)) * den(20)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(358),h0tab(:,358),[16,1,12,2],[nMB,nMW,nMW,nMB],4,1,wf4(:,17))
  call Hloop_AV_Q(ntryL,G0H32(1),ex5(:),G0H16(1),m3h2x16(:,358),heltab2x32(:,:,358))
  call Hloop_A_Q(ntryL,G0H16(1),16,nMB,G1H16(222),n2h16(358))
  Gcoeff(:)%j = (c(57)*M(1,:)%j) * den(22)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(359),h0tab(:,359),[16,1,12,2],[nMT,nMZ,nMH,nMT],4,1,wf4(:,18))
  call Hloop_AV_Q(ntryL,G0H32(1),ex5(:),G0H16(1),m3h2x16(:,359),heltab2x32(:,:,359))
  call Hloop_A_Q(ntryL,G0H16(1),16,nMT,G1H16(223),n2h16(359))
  Gcoeff(:)%j = (-(c(39)*M(1,:)%j)) * den(22)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(360),h0tab(:,360),[16,1,12,2],[nMB,nMW,nMW,nMB],4,1,wf4(:,18))
  call Hloop_AV_Q(ntryL,G0H32(1),ex5(:),G0H16(1),m3h2x16(:,360),heltab2x32(:,:,360))
  call Hloop_A_Q(ntryL,G0H16(1),16,nMB,G1H16(224),n2h16(360))
  Gcoeff(:)%j = (-(c(70)*M(1,:)%j)) * den(20)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(361),h0tab(:,361),[16,1,12,2],[nMT,nMZ,nMZ,nMT],4,1,wf4(:,17))
  call Hloop_AV_Q(ntryL,G0H32(1),ex5(:),G0H16(1),m3h2x16(:,361),heltab2x32(:,:,361))
  call Hloop_A_Q(ntryL,G0H16(1),16,nMT,G1H16(225),n2h16(361))
  Gcoeff(:)%j = (-(c(14)*M(1,:)%j)) * den(20)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(362),h0tab(:,362),[16,1,12,2],[nMB,nMW,nMW,nMB],4,1,wf4(:,17))
  call Hloop_AV_Q(ntryL,G0H32(1),ex5(:),G0H16(1),m3h2x16(:,362),heltab2x32(:,:,362))
  call Hloop_A_Q(ntryL,G0H16(1),16,nMB,G1H16(226),n2h16(362))
  Gcoeff(:)%j = (-(c(76)*M(1,:)%j)) * den(24)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(363),h0tab(:,363),[16,1,12,2],[nMB,nMW,nMW,nMB],4,1,wf4(:,19))
  call Hloop_AV_Q(ntryL,G0H32(1),ex5(:),G0H16(1),m3h2x16(:,363),heltab2x32(:,:,363))
  call Hloop_A_Q(ntryL,G0H16(1),16,nMB,G1H16(227),n2h16(363))
  Gcoeff(:)%j = (-(c(59)*M(1,:)%j)) * den(22)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(364),h0tab(:,364),[16,1,12,2],[nMT,nMH,nMZ,nMT],4,1,wf4(:,20))
  call Hloop_AV_Q(ntryL,G0H32(1),ex5(:),G0H16(1),m3h2x16(:,364),heltab2x32(:,:,364))
  call Hloop_A_Q(ntryL,G0H16(1),16,nMT,G1H16(228),n2h16(364))
  Gcoeff(:)%j = (-(c(59)*M(1,:)%j)) * den(22)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(365),h0tab(:,365),[16,1,12,2],[nMT,nMZ,nMH,nMT],4,1,wf4(:,20))
  call Hloop_AV_Q(ntryL,G0H32(1),ex5(:),G0H16(1),m3h2x16(:,365),heltab2x32(:,:,365))
  call Hloop_A_Q(ntryL,G0H16(1),16,nMT,G1H16(229),n2h16(365))
  Gcoeff(:)%j = (-(c(104)*M(1,:)%j)) * den(22)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(366),h0tab(:,366),[16,1,12,2],[nMB,nMW,nMW,nMB],4,1,wf4(:,20))
  call Hloop_AV_Q(ntryL,G0H32(1),ex5(:),G0H16(1),m3h2x16(:,366),heltab2x32(:,:,366))
  call Hloop_A_Q(ntryL,G0H16(1),16,nMB,G1H16(230),n2h16(366))
  Gcoeff(:)%j = (c(62)*M(1,:)%j) * den(24)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(367),h0tab(:,367),[16,1,12,2],[nMB,nMW,nMW,nMB],4,1,wf4(:,19))
  call Hloop_AV_Q(ntryL,G0H32(1),ex5(:),G0H16(1),m3h2x16(:,367),heltab2x32(:,:,367))
  call Hloop_A_Q(ntryL,G0H16(1),16,nMB,G1H16(231),n2h16(367))
  Gcoeff(:)%j = (-(c(73)*M(1,:)%j)) * den(22)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(368),h0tab(:,368),[16,1,12,2],[nMT,nMH,nMZ,nMT],4,1,wf4(:,20))
  call Hloop_AV_Q(ntryL,G0H32(1),ex5(:),G0H16(1),m3h2x16(:,368),heltab2x32(:,:,368))
  call Hloop_A_Q(ntryL,G0H16(1),16,nMT,G1H16(232),n2h16(368))
  Gcoeff(:)%j = (c(92)*M(1,:)%j) * den(22)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(369),h0tab(:,369),[16,1,12,2],[nMB,nMW,nMW,nMB],4,1,wf4(:,20))
  call Hloop_AV_Q(ntryL,G0H32(1),ex5(:),G0H16(1),m3h2x16(:,369),heltab2x32(:,:,369))
  call Hloop_A_Q(ntryL,G0H16(1),16,nMB,G1H16(233),n2h16(369))
  Gcoeff(:)%j = (-(c(62)*M(1,:)%j)) * den(24)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(370),h0tab(:,370),[16,1,12,2],[nMB,nMW,nMW,nMB],4,1,wf4(:,19))
  call Hloop_AV_Q(ntryL,G0H32(1),ex5(:),G0H16(1),m3h2x16(:,370),heltab2x32(:,:,370))
  call Hloop_A_Q(ntryL,G0H16(1),16,nMB,G1H16(234),n2h16(370))
  Gcoeff(:)%j = (-(c(73)*M(1,:)%j)) * den(22)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(371),h0tab(:,371),[16,1,12,2],[nMT,nMZ,nMH,nMT],4,1,wf4(:,20))
  call Hloop_AV_Q(ntryL,G0H32(1),ex5(:),G0H16(1),m3h2x16(:,371),heltab2x32(:,:,371))
  call Hloop_A_Q(ntryL,G0H16(1),16,nMT,G1H16(235),n2h16(371))
  Gcoeff(:)%j = (-(c(92)*M(1,:)%j)) * den(22)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(372),h0tab(:,372),[16,1,12,2],[nMB,nMW,nMW,nMB],4,1,wf4(:,20))
  call Hloop_AV_Q(ntryL,G0H32(1),ex5(:),G0H16(1),m3h2x16(:,372),heltab2x32(:,:,372))
  call Hloop_A_Q(ntryL,G0H16(1),16,nMB,G1H16(236),n2h16(372))
  Gcoeff(:)%j = (-(c(62)*M(1,:)%j)) * den(24)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(373),h0tab(:,373),[16,1,12,2],[nMB,nMW,nMW,nMB],4,1,wf4(:,19))
  call Hloop_AV_Q(ntryL,G0H32(1),ex5(:),G0H16(1),m3h2x16(:,373),heltab2x32(:,:,373))
  call Hloop_A_Q(ntryL,G0H16(1),16,nMB,G1H16(237),n2h16(373))
  Gcoeff(:)%j = (c(48)*M(1,:)%j) * den(22)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(374),h0tab(:,374),[16,1,12,2],[nMB,nMW,nMW,nMB],4,1,wf4(:,20))
  call Hloop_AV_Q(ntryL,G0H32(1),ex5(:),G0H16(1),m3h2x16(:,374),heltab2x32(:,:,374))
  call Hloop_A_Q(ntryL,G0H16(1),16,nMB,G1H16(238),n2h16(374))
  Gcoeff(:)%j = (c(24)*M(3,:)%j) * den(12)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(375),h0tab(:,375),[17,4,2,8],[nMW,nMT,nMH,nMB],4,1,wf4(:,11))
  call Hloop_AQ_S(ntryL,G0H32(1),wf4(:,11),G0H8(1),ngPbt,m3h4x8(:,1),heltab2x32(:,:,375))
  Gcoeff(:)%j = (c(24)*M(3,:)%j) * den(12)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(376),h0tab(:,376),[17,4,2,8],[nMH,nMB,nMW,nMT],4,1,wf4(:,11))
  call Hloop_AQ_S(ntryL,G0H32(1),wf4(:,11),G0H8(2),ngH,m3h4x8(:,2),heltab2x32(:,:,376))
  Gcoeff(:)%j = (c(24)*M(3,:)%j) * den(12)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(377),h0tab(:,377),[17,4,2,8],[nMW,nMT,nMZ,nMB],4,1,wf4(:,11))
  call Hloop_AQ_S(ntryL,G0H32(1),wf4(:,11),G0H8(3),ngPbt,m3h4x8(:,3),heltab2x32(:,:,377))
  Gcoeff(:)%j = (c(24)*M(3,:)%j) * den(12)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(378),h0tab(:,378),[17,4,2,8],[nMZ,nMB,nMW,nMT],4,1,wf4(:,11))
  call Hloop_AQ_S(ntryL,G0H32(1),wf4(:,11),G0H8(4),ngX,m3h4x8(:,4),heltab2x32(:,:,378))
  Gcoeff(:)%j = (c(75)*M(3,:)%j) * den(12)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(379),h0tab(:,379),[17,4,2,8],[0,nMB,nMW,nMT],4,1,wf4(:,11))
  call Hloop_AQ_V(ntryL,G0H32(1),wf4(:,11),G0H8(5),m3h4x8(:,5),heltab2x32(:,:,379))
  Gcoeff(:)%j = (-(c(79)*M(3,:)%j)) * den(12)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(380),h0tab(:,380),[17,4,2,8],[nMZ,nMB,nMW,nMT],4,1,wf4(:,11))
  call Hloop_AQ_Z(ntryL,G0H32(1),wf4(:,11),G0H8(6),ngZu,m3h4x8(:,6),heltab2x32(:,:,380))
  Gcoeff(:)%j = (c(44)*M(3,:)%j) * den(12)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(381),h0tab(:,381),[17,4,2,8],[nMW,nMT,nMH,nMB],4,1,wf4(:,11))
  call Hloop_AQ_W(ntryL,G0H32(1),wf4(:,11),G0H8(7),m3h4x8(:,7),heltab2x32(:,:,381))
  Gcoeff(:)%j = (c(44)*M(3,:)%j) * den(12)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(382),h0tab(:,382),[17,4,2,8],[nMW,nMT,nMZ,nMB],4,1,wf4(:,11))
  call Hloop_AQ_W(ntryL,G0H32(1),wf4(:,11),G0H8(8),m3h4x8(:,8),heltab2x32(:,:,382))
  Gcoeff(:)%j = (c(75)*M(3,:)%j) * den(12)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(383),h0tab(:,383),[17,4,2,8],[nMW,nMT,0,nMB],4,1,wf4(:,11))
  call Hloop_AQ_S(ntryL,G0H32(1),wf4(:,11),G0H8(9),ngPbt,m3h4x8(:,9),heltab2x32(:,:,383))
  Gcoeff(:)%j = (-(c(79)*M(3,:)%j)) * den(12)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(384),h0tab(:,384),[17,4,2,8],[nMW,nMT,nMZ,nMB],4,1,wf4(:,11))
  call Hloop_AQ_S(ntryL,G0H32(1),wf4(:,11),G0H8(10),ngPbt,m3h4x8(:,10),heltab2x32(:,:,384))
  Gcoeff(:)%j = (c(44)*M(3,:)%j) * den(12)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(385),h0tab(:,385),[17,4,2,8],[nMH,nMB,nMW,nMT],4,1,wf4(:,11))
  call Hloop_AQ_S(ntryL,G0H32(1),wf4(:,11),G0H8(11),ngH,m3h4x8(:,11),heltab2x32(:,:,385))
  Gcoeff(:)%j = (c(44)*M(3,:)%j) * den(12)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(386),h0tab(:,386),[17,4,2,8],[nMZ,nMB,nMW,nMT],4,1,wf4(:,11))
  call Hloop_AQ_S(ntryL,G0H32(1),wf4(:,11),G0H8(12),ngX,m3h4x8(:,12),heltab2x32(:,:,386))
  Gcoeff(:)%j = (c(61)*M(3,:)%j) * den(12)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(387),h0tab(:,387),[17,4,2,8],[nMW,nMT,0,nMB],4,1,wf4(:,11))
  call Hloop_AQ_W(ntryL,G0H32(1),wf4(:,11),G0H8(13),m3h4x8(:,13),heltab2x32(:,:,387))
  Gcoeff(:)%j = (c(61)*M(3,:)%j) * den(12)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(388),h0tab(:,388),[17,4,2,8],[0,nMB,nMW,nMT],4,1,wf4(:,11))
  call Hloop_AQ_V(ntryL,G0H32(1),wf4(:,11),G0H8(14),m3h4x8(:,14),heltab2x32(:,:,388))
  Gcoeff(:)%j = (-(c(65)*M(3,:)%j)) * den(12)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(389),h0tab(:,389),[17,4,2,8],[nMW,nMT,nMZ,nMB],4,1,wf4(:,11))
  call Hloop_AQ_W(ntryL,G0H32(1),wf4(:,11),G0H8(15),m3h4x8(:,15),heltab2x32(:,:,389))
  Gcoeff(:)%j = (-(c(65)*M(3,:)%j)) * den(12)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(390),h0tab(:,390),[17,4,2,8],[nMZ,nMB,nMW,nMT],4,1,wf4(:,11))
  call Hloop_AQ_Z(ntryL,G0H32(1),wf4(:,11),G0H8(16),ngZu,m3h4x8(:,16),heltab2x32(:,:,390))
  Gcoeff(:)%j = (c(32)*M(3,:)%j) * den(12)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(391),h0tab(:,391),[17,2,4,8],[nMH,nMT,nMW,nMT],4,1,wf4(:,11))
  call Hloop_AQ_S(ntryL,G0H32(1),wf4(:,11),G0H8(17),ngH,m3h4x8(:,17),heltab2x32(:,:,391))
  Gcoeff(:)%j = (c(21)*M(3,:)%j) * den(12)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(392),h0tab(:,392),[17,2,4,8],[nMW,nMB,nMH,nMB],4,1,wf4(:,11))
  call Hloop_AQ_S(ntryL,G0H32(1),wf4(:,11),G0H8(18),ngPbt,m3h4x8(:,18),heltab2x32(:,:,392))
  Gcoeff(:)%j = (-(c(32)*M(3,:)%j)) * den(12)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(393),h0tab(:,393),[17,2,4,8],[nMZ,nMT,nMW,nMT],4,1,wf4(:,11))
  call Hloop_AQ_S(ntryL,G0H32(1),wf4(:,11),G0H8(19),ngX,m3h4x8(:,19),heltab2x32(:,:,393))
  Gcoeff(:)%j = (-(c(21)*M(3,:)%j)) * den(12)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(394),h0tab(:,394),[17,2,4,8],[nMW,nMB,nMZ,nMB],4,1,wf4(:,11))
  call Hloop_AQ_S(ntryL,G0H32(1),wf4(:,11),G0H8(20),ngPbt,m3h4x8(:,20),heltab2x32(:,:,394))
  Gcoeff(:)%j = (c(33)*M(1,:)%j) * den(12)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(395),h0tab(:,395),[17,2,4,8],[nMT,nMH,nMB,nMH],4,1,wf4(:,11))
  call Hloop_SQ_A(ntryL,G0H32(1),wf4(:,11),G0H8(21),ngH,m3h4x8(:,21),heltab2x32(:,:,395))
  call Hloop_Q_A(ntryL,G0H8(21),17,nMT,G1H8(1),n2h8(1))
  Gcoeff(:)%j = (c(33)*M(1,:)%j) * den(12)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(396),h0tab(:,396),[17,2,4,8],[nMT,nMH,nMB,nMZ],4,1,wf4(:,11))
  call Hloop_SQ_A(ntryL,G0H32(1),wf4(:,11),G0H8(21),ngX,m3h4x8(:,22),heltab2x32(:,:,396))
  call Hloop_Q_A(ntryL,G0H8(21),17,nMT,G1H8(2),n2h8(2))
  Gcoeff(:)%j = (c(33)*M(1,:)%j) * den(12)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(397),h0tab(:,397),[17,2,4,8],[nMT,nMZ,nMB,nMH],4,1,wf4(:,11))
  call Hloop_SQ_A(ntryL,G0H32(1),wf4(:,11),G0H8(21),ngH,m3h4x8(:,23),heltab2x32(:,:,397))
  call Hloop_Q_A(ntryL,G0H8(21),17,nMT,G1H8(3),n2h8(3))
  Gcoeff(:)%j = (c(33)*M(1,:)%j) * den(12)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(398),h0tab(:,398),[17,2,4,8],[nMT,nMZ,nMB,nMZ],4,1,wf4(:,11))
  call Hloop_SQ_A(ntryL,G0H32(1),wf4(:,11),G0H8(21),ngX,m3h4x8(:,24),heltab2x32(:,:,398))
  call Hloop_Q_A(ntryL,G0H8(21),17,nMT,G1H8(4),n2h8(4))
  Gcoeff(:)%j = (-(c(74)*M(3,:)%j)) * den(12)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(399),h0tab(:,399),[17,2,4,8],[nMW,nMB,0,nMB],4,1,wf4(:,11))
  call Hloop_AQ_S(ntryL,G0H32(1),wf4(:,11),G0H8(21),ngPbt,m3h4x8(:,25),heltab2x32(:,:,399))
  Gcoeff(:)%j = (-(c(79)*M(3,:)%j)) * den(12)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(400),h0tab(:,400),[17,2,4,8],[nMW,nMB,nMZ,nMB],4,1,wf4(:,11))
  call Hloop_AQ_S(ntryL,G0H32(1),wf4(:,11),G0H8(22),ngPbt,m3h4x8(:,26),heltab2x32(:,:,400))
  Gcoeff(:)%j = (c(46)*M(3,:)%j) * den(12)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(401),h0tab(:,401),[17,2,4,8],[nMH,nMT,nMW,nMT],4,1,wf4(:,11))
  call Hloop_AQ_S(ntryL,G0H32(1),wf4(:,11),G0H8(23),ngH,m3h4x8(:,27),heltab2x32(:,:,401))
  Gcoeff(:)%j = (-(c(46)*M(3,:)%j)) * den(12)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(402),h0tab(:,402),[17,2,4,8],[nMZ,nMT,nMW,nMT],4,1,wf4(:,11))
  call Hloop_AQ_S(ntryL,G0H32(1),wf4(:,11),G0H8(24),ngX,m3h4x8(:,28),heltab2x32(:,:,402))
  Gcoeff(:)%j = (-(c(77)*M(3,:)%j)) * den(12)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(403),h0tab(:,403),[17,2,4,8],[0,nMT,nMW,nMT],4,1,wf4(:,11))
  call Hloop_AQ_V(ntryL,G0H32(1),wf4(:,11),G0H8(25),m3h4x8(:,29),heltab2x32(:,:,403))
  Gcoeff(:)%j = (-(c(79)*M(3,:)%j)) * den(12)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(404),h0tab(:,404),[17,2,4,8],[nMZ,nMT,nMW,nMT],4,1,wf4(:,11))
  call Hloop_AQ_Z(ntryL,G0H32(1),wf4(:,11),G0H8(26),ngZu,m3h4x8(:,30),heltab2x32(:,:,404))
  Gcoeff(:)%j = (c(40)*M(3,:)%j) * den(12)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(405),h0tab(:,405),[17,2,4,8],[nMW,nMB,nMH,nMB],4,1,wf4(:,11))
  call Hloop_AQ_W(ntryL,G0H32(1),wf4(:,11),G0H8(27),m3h4x8(:,31),heltab2x32(:,:,405))
  Gcoeff(:)%j = (-(c(40)*M(3,:)%j)) * den(12)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(406),h0tab(:,406),[17,2,4,8],[nMW,nMB,nMZ,nMB],4,1,wf4(:,11))
  call Hloop_AQ_W(ntryL,G0H32(1),wf4(:,11),G0H8(28),m3h4x8(:,32),heltab2x32(:,:,406))
  Gcoeff(:)%j = (c(84)*M(1,:)%j) * den(12)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(407),h0tab(:,407),[17,2,4,8],[nMT,nMH,nMB,0],4,1,wf4(:,11))
  call Hloop_VQ_A(ntryL,G0H32(1),wf4(:,11),G0H8(29),m3h4x8(:,33),heltab2x32(:,:,407))
  call Hloop_Q_A(ntryL,G0H8(29),17,nMT,G1H8(5),n2h8(5))
  Gcoeff(:)%j = (c(84)*M(1,:)%j) * den(12)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(408),h0tab(:,408),[17,2,4,8],[nMT,nMZ,nMB,0],4,1,wf4(:,11))
  call Hloop_VQ_A(ntryL,G0H32(1),wf4(:,11),G0H8(29),m3h4x8(:,34),heltab2x32(:,:,408))
  call Hloop_Q_A(ntryL,G0H8(29),17,nMT,G1H8(6),n2h8(6))
  Gcoeff(:)%j = (-(c(86)*M(1,:)%j)) * den(12)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(409),h0tab(:,409),[17,2,4,8],[nMT,nMH,nMB,nMZ],4,1,wf4(:,11))
  call Hloop_ZQ_A(ntryL,G0H32(1),wf4(:,11),G0H8(29),ngZu,m3h4x8(:,35),heltab2x32(:,:,409))
  call Hloop_Q_A(ntryL,G0H8(29),17,nMT,G1H8(7),n2h8(7))
  Gcoeff(:)%j = (-(c(86)*M(1,:)%j)) * den(12)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(410),h0tab(:,410),[17,2,4,8],[nMT,nMZ,nMB,nMZ],4,1,wf4(:,11))
  call Hloop_ZQ_A(ntryL,G0H32(1),wf4(:,11),G0H8(29),ngZu,m3h4x8(:,36),heltab2x32(:,:,410))
  call Hloop_Q_A(ntryL,G0H8(29),17,nMT,G1H8(8),n2h8(8))
  Gcoeff(:)%j = (c(84)*M(1,:)%j) * den(12)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(411),h0tab(:,411),[17,2,4,8],[nMT,0,nMB,nMH],4,1,wf4(:,11))
  call Hloop_SQ_A(ntryL,G0H32(1),wf4(:,11),G0H8(29),ngH,m3h4x8(:,37),heltab2x32(:,:,411))
  call Hloop_Q_A(ntryL,G0H8(29),17,nMT,G1H8(9),n2h8(9))
  Gcoeff(:)%j = (c(84)*M(1,:)%j) * den(12)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(412),h0tab(:,412),[17,2,4,8],[nMT,0,nMB,nMZ],4,1,wf4(:,11))
  call Hloop_SQ_A(ntryL,G0H32(1),wf4(:,11),G0H8(29),ngX,m3h4x8(:,38),heltab2x32(:,:,412))
  call Hloop_Q_A(ntryL,G0H8(29),17,nMT,G1H8(10),n2h8(10))
  Gcoeff(:)%j = (-(c(86)*M(1,:)%j)) * den(12)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(413),h0tab(:,413),[17,2,4,8],[nMT,nMZ,nMB,nMH],4,1,wf4(:,11))
  call Hloop_SQ_A(ntryL,G0H32(1),wf4(:,11),G0H8(29),ngH,m3h4x8(:,39),heltab2x32(:,:,413))
  call Hloop_Q_A(ntryL,G0H8(29),17,nMT,G1H8(11),n2h8(11))
  Gcoeff(:)%j = (-(c(86)*M(1,:)%j)) * den(12)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(414),h0tab(:,414),[17,2,4,8],[nMT,nMZ,nMB,nMZ],4,1,wf4(:,11))
  call Hloop_SQ_A(ntryL,G0H32(1),wf4(:,11),G0H8(29),ngX,m3h4x8(:,40),heltab2x32(:,:,414))
  call Hloop_Q_A(ntryL,G0H8(29),17,nMT,G1H8(12),n2h8(12))
  Gcoeff(:)%j = (-(c(63)*M(3,:)%j)) * den(12)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(415),h0tab(:,415),[17,2,4,8],[0,nMT,nMW,nMT],4,1,wf4(:,11))
  call Hloop_AQ_V(ntryL,G0H32(1),wf4(:,11),G0H8(29),m3h4x8(:,41),heltab2x32(:,:,415))
  Gcoeff(:)%j = (-(c(60)*M(3,:)%j)) * den(12)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(416),h0tab(:,416),[17,2,4,8],[nMW,nMB,0,nMB],4,1,wf4(:,11))
  call Hloop_AQ_W(ntryL,G0H32(1),wf4(:,11),G0H8(30),m3h4x8(:,42),heltab2x32(:,:,416))
  Gcoeff(:)%j = (-(c(65)*M(3,:)%j)) * den(12)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(417),h0tab(:,417),[17,2,4,8],[nMZ,nMT,nMW,nMT],4,1,wf4(:,11))
  call Hloop_AQ_Z(ntryL,G0H32(1),wf4(:,11),G0H8(31),ngZu,m3h4x8(:,43),heltab2x32(:,:,417))
  Gcoeff(:)%j = (-(c(65)*M(3,:)%j)) * den(12)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(418),h0tab(:,418),[17,2,4,8],[nMW,nMB,nMZ,nMB],4,1,wf4(:,11))
  call Hloop_AQ_W(ntryL,G0H32(1),wf4(:,11),G0H8(32),m3h4x8(:,44),heltab2x32(:,:,418))
  Gcoeff(:)%j = (c(2)*M(1,:)%j) * den(12)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(419),h0tab(:,419),[17,2,4,8],[nMT,0,nMB,0],4,1,wf4(:,11))
  call Hloop_VQ_A(ntryL,G0H32(1),wf4(:,11),G0H8(33),m3h4x8(:,45),heltab2x32(:,:,419))
  call Hloop_Q_A(ntryL,G0H8(33),17,nMT,G1H8(13),n2h8(13))
  Gcoeff(:)%j = (-(c(5)*M(1,:)%j)) * den(12)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(420),h0tab(:,420),[17,2,4,8],[nMT,0,nMB,nMZ],4,1,wf4(:,11))
  call Hloop_ZQ_A(ntryL,G0H32(1),wf4(:,11),G0H8(33),ngZu,m3h4x8(:,46),heltab2x32(:,:,420))
  call Hloop_Q_A(ntryL,G0H8(33),17,nMT,G1H8(14),n2h8(14))
  Gcoeff(:)%j = (-(c(5)*M(1,:)%j)) * den(12)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(421),h0tab(:,421),[17,2,4,8],[nMT,nMZ,nMB,0],4,1,wf4(:,11))
  call Hloop_VQ_A(ntryL,G0H32(1),wf4(:,11),G0H8(33),m3h4x8(:,47),heltab2x32(:,:,421))
  call Hloop_Q_A(ntryL,G0H8(33),17,nMT,G1H8(15),n2h8(15))
  Gcoeff(:)%j = (c(7)*M(1,:)%j) * den(12)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(422),h0tab(:,422),[17,2,4,8],[nMT,nMZ,nMB,nMZ],4,1,wf4(:,11))
  call Hloop_ZQ_A(ntryL,G0H32(1),wf4(:,11),G0H8(33),ngZu,m3h4x8(:,48),heltab2x32(:,:,422))
  call Hloop_Q_A(ntryL,G0H8(33),17,nMT,G1H8(16),n2h8(16))
  Gcoeff(:)%j = (c(33)*M(1,:)%j) * den(12)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(423),h0tab(:,423),[17,2,8,4],[nMT,nMH,nMB,nMH],4,1,wf4(:,11))
  call Hloop_SQ_A(ntryL,G0H32(1),wf4(:,11),G0H8(33),ngH,m3h4x8(:,49),heltab2x32(:,:,423))
  call Hloop_Q_A(ntryL,G0H8(33),17,nMT,G1H8(17),n2h8(17))
  Gcoeff(:)%j = (c(33)*M(1,:)%j) * den(12)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(424),h0tab(:,424),[17,2,8,4],[nMT,nMH,nMB,nMZ],4,1,wf4(:,11))
  call Hloop_SQ_A(ntryL,G0H32(1),wf4(:,11),G0H8(33),ngX,m3h4x8(:,50),heltab2x32(:,:,424))
  call Hloop_Q_A(ntryL,G0H8(33),17,nMT,G1H8(18),n2h8(18))
  Gcoeff(:)%j = (c(33)*M(1,:)%j) * den(12)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(425),h0tab(:,425),[17,2,8,4],[nMT,nMZ,nMB,nMH],4,1,wf4(:,11))
  call Hloop_SQ_A(ntryL,G0H32(1),wf4(:,11),G0H8(33),ngH,m3h4x8(:,51),heltab2x32(:,:,425))
  call Hloop_Q_A(ntryL,G0H8(33),17,nMT,G1H8(19),n2h8(19))
  Gcoeff(:)%j = (c(33)*M(1,:)%j) * den(12)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(426),h0tab(:,426),[17,2,8,4],[nMT,nMZ,nMB,nMZ],4,1,wf4(:,11))
  call Hloop_SQ_A(ntryL,G0H32(1),wf4(:,11),G0H8(33),ngX,m3h4x8(:,52),heltab2x32(:,:,426))
  call Hloop_Q_A(ntryL,G0H8(33),17,nMT,G1H8(20),n2h8(20))
  Gcoeff(:)%j = (c(20)*M(1,:)%j) * den(12)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(427),h0tab(:,427),[17,2,8,4],[nMB,nMW,nMT,nMW],4,1,wf4(:,11))
  call Hloop_SQ_A(ntryL,G0H32(1),wf4(:,11),G0H8(33),ngPbt,m3h4x8(:,53),heltab2x32(:,:,427))
  call Hloop_Q_A(ntryL,G0H8(33),17,nMB,G1H8(21),n2h8(21))
  Gcoeff(:)%j = (c(84)*M(1,:)%j) * den(12)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(428),h0tab(:,428),[17,2,8,4],[nMT,nMH,nMB,0],4,1,wf4(:,11))
  call Hloop_VQ_A(ntryL,G0H32(1),wf4(:,11),G0H8(33),m3h4x8(:,54),heltab2x32(:,:,428))
  call Hloop_Q_A(ntryL,G0H8(33),17,nMT,G1H8(22),n2h8(22))
  Gcoeff(:)%j = (c(84)*M(1,:)%j) * den(12)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(429),h0tab(:,429),[17,2,8,4],[nMT,nMZ,nMB,0],4,1,wf4(:,11))
  call Hloop_VQ_A(ntryL,G0H32(1),wf4(:,11),G0H8(33),m3h4x8(:,55),heltab2x32(:,:,429))
  call Hloop_Q_A(ntryL,G0H8(33),17,nMT,G1H8(23),n2h8(23))
  Gcoeff(:)%j = (-(c(86)*M(1,:)%j)) * den(12)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(430),h0tab(:,430),[17,2,8,4],[nMT,nMH,nMB,nMZ],4,1,wf4(:,11))
  call Hloop_ZQ_A(ntryL,G0H32(1),wf4(:,11),G0H8(33),ngZu,m3h4x8(:,56),heltab2x32(:,:,430))
  call Hloop_Q_A(ntryL,G0H8(33),17,nMT,G1H8(24),n2h8(24))
  Gcoeff(:)%j = (-(c(86)*M(1,:)%j)) * den(12)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(431),h0tab(:,431),[17,2,8,4],[nMT,nMZ,nMB,nMZ],4,1,wf4(:,11))
  call Hloop_ZQ_A(ntryL,G0H32(1),wf4(:,11),G0H8(33),ngZu,m3h4x8(:,57),heltab2x32(:,:,431))
  call Hloop_Q_A(ntryL,G0H8(33),17,nMT,G1H8(25),n2h8(25))
  Gcoeff(:)%j = (c(38)*M(1,:)%j) * den(12)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(432),h0tab(:,432),[17,2,8,4],[nMB,nMW,nMT,nMW],4,1,wf4(:,11))
  call Hloop_WQ_A(ntryL,G0H32(1),wf4(:,11),G0H8(33),m3h4x8(:,58),heltab2x32(:,:,432))
  call Hloop_Q_A(ntryL,G0H8(33),17,nMB,G1H8(26),n2h8(26))
  Gcoeff(:)%j = (c(84)*M(1,:)%j) * den(12)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(433),h0tab(:,433),[17,2,8,4],[nMT,0,nMB,nMH],4,1,wf4(:,11))
  call Hloop_SQ_A(ntryL,G0H32(1),wf4(:,11),G0H8(33),ngH,m3h4x8(:,59),heltab2x32(:,:,433))
  call Hloop_Q_A(ntryL,G0H8(33),17,nMT,G1H8(27),n2h8(27))
  Gcoeff(:)%j = (c(84)*M(1,:)%j) * den(12)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(434),h0tab(:,434),[17,2,8,4],[nMT,0,nMB,nMZ],4,1,wf4(:,11))
  call Hloop_SQ_A(ntryL,G0H32(1),wf4(:,11),G0H8(33),ngX,m3h4x8(:,60),heltab2x32(:,:,434))
  call Hloop_Q_A(ntryL,G0H8(33),17,nMT,G1H8(28),n2h8(28))
  Gcoeff(:)%j = (-(c(86)*M(1,:)%j)) * den(12)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(435),h0tab(:,435),[17,2,8,4],[nMT,nMZ,nMB,nMH],4,1,wf4(:,11))
  call Hloop_SQ_A(ntryL,G0H32(1),wf4(:,11),G0H8(33),ngH,m3h4x8(:,61),heltab2x32(:,:,435))
  call Hloop_Q_A(ntryL,G0H8(33),17,nMT,G1H8(29),n2h8(29))
  Gcoeff(:)%j = (-(c(86)*M(1,:)%j)) * den(12)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(436),h0tab(:,436),[17,2,8,4],[nMT,nMZ,nMB,nMZ],4,1,wf4(:,11))
  call Hloop_SQ_A(ntryL,G0H32(1),wf4(:,11),G0H8(33),ngX,m3h4x8(:,62),heltab2x32(:,:,436))
  call Hloop_Q_A(ntryL,G0H8(33),17,nMT,G1H8(30),n2h8(30))
  Gcoeff(:)%j = (c(38)*M(1,:)%j) * den(12)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(437),h0tab(:,437),[17,2,8,4],[nMB,nMW,nMT,nMW],4,1,wf4(:,11))
  call Hloop_SQ_A(ntryL,G0H32(1),wf4(:,11),G0H8(33),ngPbt,m3h4x8(:,63),heltab2x32(:,:,437))
  call Hloop_Q_A(ntryL,G0H8(33),17,nMB,G1H8(31),n2h8(31))
  Gcoeff(:)%j = (c(2)*M(1,:)%j) * den(12)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(438),h0tab(:,438),[17,2,8,4],[nMT,0,nMB,0],4,1,wf4(:,11))
  call Hloop_VQ_A(ntryL,G0H32(1),wf4(:,11),G0H8(33),m3h4x8(:,64),heltab2x32(:,:,438))
  call Hloop_Q_A(ntryL,G0H8(33),17,nMT,G1H8(32),n2h8(32))
  Gcoeff(:)%j = (-(c(5)*M(1,:)%j)) * den(12)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(439),h0tab(:,439),[17,2,8,4],[nMT,0,nMB,nMZ],4,1,wf4(:,11))
  call Hloop_ZQ_A(ntryL,G0H32(1),wf4(:,11),G0H8(33),ngZu,m3h4x8(:,65),heltab2x32(:,:,439))
  call Hloop_Q_A(ntryL,G0H8(33),17,nMT,G1H8(33),n2h8(33))
  Gcoeff(:)%j = (-(c(5)*M(1,:)%j)) * den(12)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(440),h0tab(:,440),[17,2,8,4],[nMT,nMZ,nMB,0],4,1,wf4(:,11))
  call Hloop_VQ_A(ntryL,G0H32(1),wf4(:,11),G0H8(33),m3h4x8(:,66),heltab2x32(:,:,440))
  call Hloop_Q_A(ntryL,G0H8(33),17,nMT,G1H8(34),n2h8(34))
  Gcoeff(:)%j = (c(7)*M(1,:)%j) * den(12)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(441),h0tab(:,441),[17,2,8,4],[nMT,nMZ,nMB,nMZ],4,1,wf4(:,11))
  call Hloop_ZQ_A(ntryL,G0H32(1),wf4(:,11),G0H8(33),ngZu,m3h4x8(:,67),heltab2x32(:,:,441))
  call Hloop_Q_A(ntryL,G0H8(33),17,nMT,G1H8(35),n2h8(35))
  Gcoeff(:)%j = (c(12)*M(1,:)%j) * den(12)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(442),h0tab(:,442),[17,2,8,4],[nMB,nMW,nMT,nMW],4,1,wf4(:,11))
  call Hloop_WQ_A(ntryL,G0H32(1),wf4(:,11),G0H8(33),m3h4x8(:,68),heltab2x32(:,:,442))
  call Hloop_Q_A(ntryL,G0H8(33),17,nMB,G1H8(36),n2h8(36))
  Gcoeff(:)%j = (c(24)*M(2,:)%j) * den(17)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(443),h0tab(:,443),[18,4,1,8],[nMB,nMH,nMT,nMW],4,1,wf4(:,15))
  call Hloop_SA_Q(ntryL,G0H32(1),wf4(:,15),G0H8(33),ngPtb,m3h4x8(:,69),heltab2x32(:,:,443))
  call Hloop_A_Q(ntryL,G0H8(33),18,nMB,G1H8(37),n2h8(37))
  Gcoeff(:)%j = (c(24)*M(2,:)%j) * den(17)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(444),h0tab(:,444),[18,4,1,8],[nMT,nMW,nMB,nMH],4,1,wf4(:,15))
  call Hloop_SA_Q(ntryL,G0H32(1),wf4(:,15),G0H8(33),ngH,m3h4x8(:,70),heltab2x32(:,:,444))
  call Hloop_A_Q(ntryL,G0H8(33),18,nMT,G1H8(38),n2h8(38))
  Gcoeff(:)%j = (c(24)*M(2,:)%j) * den(17)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(445),h0tab(:,445),[18,4,1,8],[nMB,nMZ,nMT,nMW],4,1,wf4(:,15))
  call Hloop_SA_Q(ntryL,G0H32(1),wf4(:,15),G0H8(33),ngPtb,m3h4x8(:,71),heltab2x32(:,:,445))
  call Hloop_A_Q(ntryL,G0H8(33),18,nMB,G1H8(39),n2h8(39))
  Gcoeff(:)%j = (c(24)*M(2,:)%j) * den(17)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(446),h0tab(:,446),[18,4,1,8],[nMT,nMW,nMB,nMZ],4,1,wf4(:,15))
  call Hloop_SA_Q(ntryL,G0H32(1),wf4(:,15),G0H8(33),ngX,m3h4x8(:,72),heltab2x32(:,:,446))
  call Hloop_A_Q(ntryL,G0H8(33),18,nMT,G1H8(40),n2h8(40))
  Gcoeff(:)%j = (c(75)*M(2,:)%j) * den(17)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(447),h0tab(:,447),[18,4,1,8],[nMT,nMW,nMB,0],4,1,wf4(:,15))
  call Hloop_VA_Q(ntryL,G0H32(1),wf4(:,15),G0H8(33),m3h4x8(:,73),heltab2x32(:,:,447))
  call Hloop_A_Q(ntryL,G0H8(33),18,nMT,G1H8(41),n2h8(41))
  Gcoeff(:)%j = (-(c(79)*M(2,:)%j)) * den(17)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(448),h0tab(:,448),[18,4,1,8],[nMT,nMW,nMB,nMZ],4,1,wf4(:,15))
  call Hloop_ZA_Q(ntryL,G0H32(1),wf4(:,15),G0H8(33),ngZu,m3h4x8(:,74),heltab2x32(:,:,448))
  call Hloop_A_Q(ntryL,G0H8(33),18,nMT,G1H8(42),n2h8(42))
  Gcoeff(:)%j = (c(44)*M(2,:)%j) * den(17)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(449),h0tab(:,449),[18,4,1,8],[nMB,nMH,nMT,nMW],4,1,wf4(:,15))
  call Hloop_WA_Q(ntryL,G0H32(1),wf4(:,15),G0H8(33),m3h4x8(:,75),heltab2x32(:,:,449))
  call Hloop_A_Q(ntryL,G0H8(33),18,nMB,G1H8(43),n2h8(43))
  Gcoeff(:)%j = (c(44)*M(2,:)%j) * den(17)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(450),h0tab(:,450),[18,4,1,8],[nMB,nMZ,nMT,nMW],4,1,wf4(:,15))
  call Hloop_WA_Q(ntryL,G0H32(1),wf4(:,15),G0H8(33),m3h4x8(:,76),heltab2x32(:,:,450))
  call Hloop_A_Q(ntryL,G0H8(33),18,nMB,G1H8(44),n2h8(44))
  Gcoeff(:)%j = (c(75)*M(2,:)%j) * den(17)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(451),h0tab(:,451),[18,4,1,8],[nMB,0,nMT,nMW],4,1,wf4(:,15))
  call Hloop_SA_Q(ntryL,G0H32(1),wf4(:,15),G0H8(33),ngPtb,m3h4x8(:,77),heltab2x32(:,:,451))
  call Hloop_A_Q(ntryL,G0H8(33),18,nMB,G1H8(45),n2h8(45))
  Gcoeff(:)%j = (-(c(79)*M(2,:)%j)) * den(17)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(452),h0tab(:,452),[18,4,1,8],[nMB,nMZ,nMT,nMW],4,1,wf4(:,15))
  call Hloop_SA_Q(ntryL,G0H32(1),wf4(:,15),G0H8(33),ngPtb,m3h4x8(:,78),heltab2x32(:,:,452))
  call Hloop_A_Q(ntryL,G0H8(33),18,nMB,G1H8(46),n2h8(46))
  Gcoeff(:)%j = (c(44)*M(2,:)%j) * den(17)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(453),h0tab(:,453),[18,4,1,8],[nMT,nMW,nMB,nMH],4,1,wf4(:,15))
  call Hloop_SA_Q(ntryL,G0H32(1),wf4(:,15),G0H8(33),ngH,m3h4x8(:,79),heltab2x32(:,:,453))
  call Hloop_A_Q(ntryL,G0H8(33),18,nMT,G1H8(47),n2h8(47))
  Gcoeff(:)%j = (c(44)*M(2,:)%j) * den(17)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(454),h0tab(:,454),[18,4,1,8],[nMT,nMW,nMB,nMZ],4,1,wf4(:,15))
  call Hloop_SA_Q(ntryL,G0H32(1),wf4(:,15),G0H8(33),ngX,m3h4x8(:,80),heltab2x32(:,:,454))
  call Hloop_A_Q(ntryL,G0H8(33),18,nMT,G1H8(48),n2h8(48))
  Gcoeff(:)%j = (c(61)*M(2,:)%j) * den(17)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(455),h0tab(:,455),[18,4,1,8],[nMB,0,nMT,nMW],4,1,wf4(:,15))
  call Hloop_WA_Q(ntryL,G0H32(1),wf4(:,15),G0H8(33),m3h4x8(:,81),heltab2x32(:,:,455))
  call Hloop_A_Q(ntryL,G0H8(33),18,nMB,G1H8(49),n2h8(49))
  Gcoeff(:)%j = (c(61)*M(2,:)%j) * den(17)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(456),h0tab(:,456),[18,4,1,8],[nMT,nMW,nMB,0],4,1,wf4(:,15))
  call Hloop_VA_Q(ntryL,G0H32(1),wf4(:,15),G0H8(33),m3h4x8(:,82),heltab2x32(:,:,456))
  call Hloop_A_Q(ntryL,G0H8(33),18,nMT,G1H8(50),n2h8(50))
  Gcoeff(:)%j = (-(c(65)*M(2,:)%j)) * den(17)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(457),h0tab(:,457),[18,4,1,8],[nMB,nMZ,nMT,nMW],4,1,wf4(:,15))
  call Hloop_WA_Q(ntryL,G0H32(1),wf4(:,15),G0H8(33),m3h4x8(:,83),heltab2x32(:,:,457))
  call Hloop_A_Q(ntryL,G0H8(33),18,nMB,G1H8(51),n2h8(51))
  Gcoeff(:)%j = (-(c(65)*M(2,:)%j)) * den(17)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(458),h0tab(:,458),[18,4,1,8],[nMT,nMW,nMB,nMZ],4,1,wf4(:,15))
  call Hloop_ZA_Q(ntryL,G0H32(1),wf4(:,15),G0H8(33),ngZu,m3h4x8(:,84),heltab2x32(:,:,458))
  call Hloop_A_Q(ntryL,G0H8(33),18,nMT,G1H8(52),n2h8(52))
  Gcoeff(:)%j = (c(33)*M(1,:)%j) * den(17)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(459),h0tab(:,459),[18,1,4,8],[nMT,nMH,nMB,nMH],4,1,wf4(:,15))
  call Hloop_SA_Q(ntryL,G0H32(1),wf4(:,15),G0H8(33),ngH,m3h4x8(:,85),heltab2x32(:,:,459))
  call Hloop_A_Q(ntryL,G0H8(33),18,nMT,G1H8(53),n2h8(53))
  Gcoeff(:)%j = (c(33)*M(1,:)%j) * den(17)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(460),h0tab(:,460),[18,1,4,8],[nMT,nMH,nMB,nMZ],4,1,wf4(:,15))
  call Hloop_SA_Q(ntryL,G0H32(1),wf4(:,15),G0H8(33),ngX,m3h4x8(:,86),heltab2x32(:,:,460))
  call Hloop_A_Q(ntryL,G0H8(33),18,nMT,G1H8(54),n2h8(54))
  Gcoeff(:)%j = (c(33)*M(1,:)%j) * den(17)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(461),h0tab(:,461),[18,1,4,8],[nMT,nMZ,nMB,nMH],4,1,wf4(:,15))
  call Hloop_SA_Q(ntryL,G0H32(1),wf4(:,15),G0H8(33),ngH,m3h4x8(:,87),heltab2x32(:,:,461))
  call Hloop_A_Q(ntryL,G0H8(33),18,nMT,G1H8(55),n2h8(55))
  Gcoeff(:)%j = (c(33)*M(1,:)%j) * den(17)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(462),h0tab(:,462),[18,1,4,8],[nMT,nMZ,nMB,nMZ],4,1,wf4(:,15))
  call Hloop_SA_Q(ntryL,G0H32(1),wf4(:,15),G0H8(33),ngX,m3h4x8(:,88),heltab2x32(:,:,462))
  call Hloop_A_Q(ntryL,G0H8(33),18,nMT,G1H8(56),n2h8(56))
  Gcoeff(:)%j = (c(20)*M(1,:)%j) * den(17)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(463),h0tab(:,463),[18,1,4,8],[nMB,nMW,nMT,nMW],4,1,wf4(:,15))
  call Hloop_SA_Q(ntryL,G0H32(1),wf4(:,15),G0H8(33),ngPtb,m3h4x8(:,89),heltab2x32(:,:,463))
  call Hloop_A_Q(ntryL,G0H8(33),18,nMB,G1H8(57),n2h8(57))
  Gcoeff(:)%j = (c(84)*M(1,:)%j) * den(17)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(464),h0tab(:,464),[18,1,4,8],[nMT,nMH,nMB,0],4,1,wf4(:,15))
  call Hloop_VA_Q(ntryL,G0H32(1),wf4(:,15),G0H8(33),m3h4x8(:,90),heltab2x32(:,:,464))
  call Hloop_A_Q(ntryL,G0H8(33),18,nMT,G1H8(58),n2h8(58))
  Gcoeff(:)%j = (c(84)*M(1,:)%j) * den(17)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(465),h0tab(:,465),[18,1,4,8],[nMT,nMZ,nMB,0],4,1,wf4(:,15))
  call Hloop_VA_Q(ntryL,G0H32(1),wf4(:,15),G0H8(33),m3h4x8(:,91),heltab2x32(:,:,465))
  call Hloop_A_Q(ntryL,G0H8(33),18,nMT,G1H8(59),n2h8(59))
  Gcoeff(:)%j = (-(c(86)*M(1,:)%j)) * den(17)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(466),h0tab(:,466),[18,1,4,8],[nMT,nMH,nMB,nMZ],4,1,wf4(:,15))
  call Hloop_ZA_Q(ntryL,G0H32(1),wf4(:,15),G0H8(33),ngZu,m3h4x8(:,92),heltab2x32(:,:,466))
  call Hloop_A_Q(ntryL,G0H8(33),18,nMT,G1H8(60),n2h8(60))
  Gcoeff(:)%j = (-(c(86)*M(1,:)%j)) * den(17)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(467),h0tab(:,467),[18,1,4,8],[nMT,nMZ,nMB,nMZ],4,1,wf4(:,15))
  call Hloop_ZA_Q(ntryL,G0H32(1),wf4(:,15),G0H8(33),ngZu,m3h4x8(:,93),heltab2x32(:,:,467))
  call Hloop_A_Q(ntryL,G0H8(33),18,nMT,G1H8(61),n2h8(61))
  Gcoeff(:)%j = (c(38)*M(1,:)%j) * den(17)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(468),h0tab(:,468),[18,1,4,8],[nMB,nMW,nMT,nMW],4,1,wf4(:,15))
  call Hloop_WA_Q(ntryL,G0H32(1),wf4(:,15),G0H8(33),m3h4x8(:,94),heltab2x32(:,:,468))
  call Hloop_A_Q(ntryL,G0H8(33),18,nMB,G1H8(62),n2h8(62))
  Gcoeff(:)%j = (c(84)*M(1,:)%j) * den(17)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(469),h0tab(:,469),[18,1,4,8],[nMT,0,nMB,nMH],4,1,wf4(:,15))
  call Hloop_SA_Q(ntryL,G0H32(1),wf4(:,15),G0H8(33),ngH,m3h4x8(:,95),heltab2x32(:,:,469))
  call Hloop_A_Q(ntryL,G0H8(33),18,nMT,G1H8(63),n2h8(63))
  Gcoeff(:)%j = (c(84)*M(1,:)%j) * den(17)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(470),h0tab(:,470),[18,1,4,8],[nMT,0,nMB,nMZ],4,1,wf4(:,15))
  call Hloop_SA_Q(ntryL,G0H32(1),wf4(:,15),G0H8(33),ngX,m3h4x8(:,96),heltab2x32(:,:,470))
  call Hloop_A_Q(ntryL,G0H8(33),18,nMT,G1H8(64),n2h8(64))
  Gcoeff(:)%j = (-(c(86)*M(1,:)%j)) * den(17)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(471),h0tab(:,471),[18,1,4,8],[nMT,nMZ,nMB,nMH],4,1,wf4(:,15))
  call Hloop_SA_Q(ntryL,G0H32(1),wf4(:,15),G0H8(33),ngH,m3h4x8(:,97),heltab2x32(:,:,471))
  call Hloop_A_Q(ntryL,G0H8(33),18,nMT,G1H8(65),n2h8(65))
  Gcoeff(:)%j = (-(c(86)*M(1,:)%j)) * den(17)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(472),h0tab(:,472),[18,1,4,8],[nMT,nMZ,nMB,nMZ],4,1,wf4(:,15))
  call Hloop_SA_Q(ntryL,G0H32(1),wf4(:,15),G0H8(33),ngX,m3h4x8(:,98),heltab2x32(:,:,472))
  call Hloop_A_Q(ntryL,G0H8(33),18,nMT,G1H8(66),n2h8(66))
  Gcoeff(:)%j = (c(38)*M(1,:)%j) * den(17)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(473),h0tab(:,473),[18,1,4,8],[nMB,nMW,nMT,nMW],4,1,wf4(:,15))
  call Hloop_SA_Q(ntryL,G0H32(1),wf4(:,15),G0H8(33),ngPtb,m3h4x8(:,99),heltab2x32(:,:,473))
  call Hloop_A_Q(ntryL,G0H8(33),18,nMB,G1H8(67),n2h8(67))
  Gcoeff(:)%j = (c(2)*M(1,:)%j) * den(17)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(474),h0tab(:,474),[18,1,4,8],[nMT,0,nMB,0],4,1,wf4(:,15))
  call Hloop_VA_Q(ntryL,G0H32(1),wf4(:,15),G0H8(33),m3h4x8(:,100),heltab2x32(:,:,474))
  call Hloop_A_Q(ntryL,G0H8(33),18,nMT,G1H8(68),n2h8(68))
  Gcoeff(:)%j = (-(c(5)*M(1,:)%j)) * den(17)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(475),h0tab(:,475),[18,1,4,8],[nMT,0,nMB,nMZ],4,1,wf4(:,15))
  call Hloop_ZA_Q(ntryL,G0H32(1),wf4(:,15),G0H8(33),ngZu,m3h4x8(:,101),heltab2x32(:,:,475))
  call Hloop_A_Q(ntryL,G0H8(33),18,nMT,G1H8(69),n2h8(69))
  Gcoeff(:)%j = (-(c(5)*M(1,:)%j)) * den(17)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(476),h0tab(:,476),[18,1,4,8],[nMT,nMZ,nMB,0],4,1,wf4(:,15))
  call Hloop_VA_Q(ntryL,G0H32(1),wf4(:,15),G0H8(33),m3h4x8(:,102),heltab2x32(:,:,476))
  call Hloop_A_Q(ntryL,G0H8(33),18,nMT,G1H8(70),n2h8(70))
  Gcoeff(:)%j = (c(7)*M(1,:)%j) * den(17)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(477),h0tab(:,477),[18,1,4,8],[nMT,nMZ,nMB,nMZ],4,1,wf4(:,15))
  call Hloop_ZA_Q(ntryL,G0H32(1),wf4(:,15),G0H8(33),ngZu,m3h4x8(:,103),heltab2x32(:,:,477))
  call Hloop_A_Q(ntryL,G0H8(33),18,nMT,G1H8(71),n2h8(71))
  Gcoeff(:)%j = (c(12)*M(1,:)%j) * den(17)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(478),h0tab(:,478),[18,1,4,8],[nMB,nMW,nMT,nMW],4,1,wf4(:,15))
  call Hloop_WA_Q(ntryL,G0H32(1),wf4(:,15),G0H8(33),m3h4x8(:,104),heltab2x32(:,:,478))
  call Hloop_A_Q(ntryL,G0H8(33),18,nMB,G1H8(72),n2h8(72))
  Gcoeff(:)%j = (c(32)*M(2,:)%j) * den(17)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(479),h0tab(:,479),[18,1,8,4],[nMH,nMT,nMW,nMT],4,1,wf4(:,15))
  call Hloop_QA_S(ntryL,G0H32(1),wf4(:,15),G0H8(33),ngH,m3h4x8(:,105),heltab2x32(:,:,479))
  Gcoeff(:)%j = (c(21)*M(2,:)%j) * den(17)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(480),h0tab(:,480),[18,1,8,4],[nMW,nMB,nMH,nMB],4,1,wf4(:,15))
  call Hloop_QA_S(ntryL,G0H32(1),wf4(:,15),G0H8(34),ngPtb,m3h4x8(:,106),heltab2x32(:,:,480))
  Gcoeff(:)%j = (-(c(32)*M(2,:)%j)) * den(17)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(481),h0tab(:,481),[18,1,8,4],[nMZ,nMT,nMW,nMT],4,1,wf4(:,15))
  call Hloop_QA_S(ntryL,G0H32(1),wf4(:,15),G0H8(35),ngX,m3h4x8(:,107),heltab2x32(:,:,481))
  Gcoeff(:)%j = (-(c(21)*M(2,:)%j)) * den(17)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(482),h0tab(:,482),[18,1,8,4],[nMW,nMB,nMZ,nMB],4,1,wf4(:,15))
  call Hloop_QA_S(ntryL,G0H32(1),wf4(:,15),G0H8(36),ngPtb,m3h4x8(:,108),heltab2x32(:,:,482))
  Gcoeff(:)%j = (c(33)*M(1,:)%j) * den(17)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(483),h0tab(:,483),[18,1,8,4],[nMT,nMH,nMB,nMH],4,1,wf4(:,15))
  call Hloop_SA_Q(ntryL,G0H32(1),wf4(:,15),G0H8(37),ngH,m3h4x8(:,109),heltab2x32(:,:,483))
  call Hloop_A_Q(ntryL,G0H8(37),18,nMT,G1H8(73),n2h8(73))
  Gcoeff(:)%j = (c(33)*M(1,:)%j) * den(17)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(484),h0tab(:,484),[18,1,8,4],[nMT,nMH,nMB,nMZ],4,1,wf4(:,15))
  call Hloop_SA_Q(ntryL,G0H32(1),wf4(:,15),G0H8(37),ngX,m3h4x8(:,110),heltab2x32(:,:,484))
  call Hloop_A_Q(ntryL,G0H8(37),18,nMT,G1H8(74),n2h8(74))
  Gcoeff(:)%j = (c(33)*M(1,:)%j) * den(17)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(485),h0tab(:,485),[18,1,8,4],[nMT,nMZ,nMB,nMH],4,1,wf4(:,15))
  call Hloop_SA_Q(ntryL,G0H32(1),wf4(:,15),G0H8(37),ngH,m3h4x8(:,111),heltab2x32(:,:,485))
  call Hloop_A_Q(ntryL,G0H8(37),18,nMT,G1H8(75),n2h8(75))
  Gcoeff(:)%j = (c(33)*M(1,:)%j) * den(17)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(486),h0tab(:,486),[18,1,8,4],[nMT,nMZ,nMB,nMZ],4,1,wf4(:,15))
  call Hloop_SA_Q(ntryL,G0H32(1),wf4(:,15),G0H8(37),ngX,m3h4x8(:,112),heltab2x32(:,:,486))
  call Hloop_A_Q(ntryL,G0H8(37),18,nMT,G1H8(76),n2h8(76))
  Gcoeff(:)%j = (-(c(74)*M(2,:)%j)) * den(17)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(487),h0tab(:,487),[18,1,8,4],[nMW,nMB,0,nMB],4,1,wf4(:,15))
  call Hloop_QA_S(ntryL,G0H32(1),wf4(:,15),G0H8(37),ngPtb,m3h4x8(:,113),heltab2x32(:,:,487))
  Gcoeff(:)%j = (-(c(79)*M(2,:)%j)) * den(17)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(488),h0tab(:,488),[18,1,8,4],[nMW,nMB,nMZ,nMB],4,1,wf4(:,15))
  call Hloop_QA_S(ntryL,G0H32(1),wf4(:,15),G0H8(38),ngPtb,m3h4x8(:,114),heltab2x32(:,:,488))
  Gcoeff(:)%j = (c(46)*M(2,:)%j) * den(17)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(489),h0tab(:,489),[18,1,8,4],[nMH,nMT,nMW,nMT],4,1,wf4(:,15))
  call Hloop_QA_S(ntryL,G0H32(1),wf4(:,15),G0H8(39),ngH,m3h4x8(:,115),heltab2x32(:,:,489))
  Gcoeff(:)%j = (-(c(46)*M(2,:)%j)) * den(17)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(490),h0tab(:,490),[18,1,8,4],[nMZ,nMT,nMW,nMT],4,1,wf4(:,15))
  call Hloop_QA_S(ntryL,G0H32(1),wf4(:,15),G0H8(40),ngX,m3h4x8(:,116),heltab2x32(:,:,490))
  Gcoeff(:)%j = (-(c(77)*M(2,:)%j)) * den(17)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(491),h0tab(:,491),[18,1,8,4],[0,nMT,nMW,nMT],4,1,wf4(:,15))
  call Hloop_QA_V(ntryL,G0H32(1),wf4(:,15),G0H8(41),m3h4x8(:,117),heltab2x32(:,:,491))
  Gcoeff(:)%j = (-(c(79)*M(2,:)%j)) * den(17)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(492),h0tab(:,492),[18,1,8,4],[nMZ,nMT,nMW,nMT],4,1,wf4(:,15))
  call Hloop_QA_Z(ntryL,G0H32(1),wf4(:,15),G0H8(42),ngZu,m3h4x8(:,118),heltab2x32(:,:,492))
  Gcoeff(:)%j = (c(40)*M(2,:)%j) * den(17)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(493),h0tab(:,493),[18,1,8,4],[nMW,nMB,nMH,nMB],4,1,wf4(:,15))
  call Hloop_QA_W(ntryL,G0H32(1),wf4(:,15),G0H8(43),m3h4x8(:,119),heltab2x32(:,:,493))
  Gcoeff(:)%j = (-(c(40)*M(2,:)%j)) * den(17)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(494),h0tab(:,494),[18,1,8,4],[nMW,nMB,nMZ,nMB],4,1,wf4(:,15))
  call Hloop_QA_W(ntryL,G0H32(1),wf4(:,15),G0H8(44),m3h4x8(:,120),heltab2x32(:,:,494))
  Gcoeff(:)%j = (c(84)*M(1,:)%j) * den(17)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(495),h0tab(:,495),[18,1,8,4],[nMT,nMH,nMB,0],4,1,wf4(:,15))
  call Hloop_VA_Q(ntryL,G0H32(1),wf4(:,15),G0H8(45),m3h4x8(:,121),heltab2x32(:,:,495))
  call Hloop_A_Q(ntryL,G0H8(45),18,nMT,G1H8(77),n2h8(77))
  Gcoeff(:)%j = (c(84)*M(1,:)%j) * den(17)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(496),h0tab(:,496),[18,1,8,4],[nMT,nMZ,nMB,0],4,1,wf4(:,15))
  call Hloop_VA_Q(ntryL,G0H32(1),wf4(:,15),G0H8(45),m3h4x8(:,122),heltab2x32(:,:,496))
  call Hloop_A_Q(ntryL,G0H8(45),18,nMT,G1H8(78),n2h8(78))
  Gcoeff(:)%j = (-(c(86)*M(1,:)%j)) * den(17)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(497),h0tab(:,497),[18,1,8,4],[nMT,nMH,nMB,nMZ],4,1,wf4(:,15))
  call Hloop_ZA_Q(ntryL,G0H32(1),wf4(:,15),G0H8(45),ngZu,m3h4x8(:,123),heltab2x32(:,:,497))
  call Hloop_A_Q(ntryL,G0H8(45),18,nMT,G1H8(79),n2h8(79))
  Gcoeff(:)%j = (-(c(86)*M(1,:)%j)) * den(17)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(498),h0tab(:,498),[18,1,8,4],[nMT,nMZ,nMB,nMZ],4,1,wf4(:,15))
  call Hloop_ZA_Q(ntryL,G0H32(1),wf4(:,15),G0H8(45),ngZu,m3h4x8(:,124),heltab2x32(:,:,498))
  call Hloop_A_Q(ntryL,G0H8(45),18,nMT,G1H8(80),n2h8(80))
  Gcoeff(:)%j = (c(84)*M(1,:)%j) * den(17)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(499),h0tab(:,499),[18,1,8,4],[nMT,0,nMB,nMH],4,1,wf4(:,15))
  call Hloop_SA_Q(ntryL,G0H32(1),wf4(:,15),G0H8(45),ngH,m3h4x8(:,125),heltab2x32(:,:,499))
  call Hloop_A_Q(ntryL,G0H8(45),18,nMT,G1H8(81),n2h8(81))
  Gcoeff(:)%j = (c(84)*M(1,:)%j) * den(17)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(500),h0tab(:,500),[18,1,8,4],[nMT,0,nMB,nMZ],4,1,wf4(:,15))
  call Hloop_SA_Q(ntryL,G0H32(1),wf4(:,15),G0H8(45),ngX,m3h4x8(:,126),heltab2x32(:,:,500))
  call Hloop_A_Q(ntryL,G0H8(45),18,nMT,G1H8(82),n2h8(82))
  Gcoeff(:)%j = (-(c(86)*M(1,:)%j)) * den(17)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(501),h0tab(:,501),[18,1,8,4],[nMT,nMZ,nMB,nMH],4,1,wf4(:,15))
  call Hloop_SA_Q(ntryL,G0H32(1),wf4(:,15),G0H8(45),ngH,m3h4x8(:,127),heltab2x32(:,:,501))
  call Hloop_A_Q(ntryL,G0H8(45),18,nMT,G1H8(83),n2h8(83))
  Gcoeff(:)%j = (-(c(86)*M(1,:)%j)) * den(17)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(502),h0tab(:,502),[18,1,8,4],[nMT,nMZ,nMB,nMZ],4,1,wf4(:,15))
  call Hloop_SA_Q(ntryL,G0H32(1),wf4(:,15),G0H8(45),ngX,m3h4x8(:,128),heltab2x32(:,:,502))
  call Hloop_A_Q(ntryL,G0H8(45),18,nMT,G1H8(84),n2h8(84))
  Gcoeff(:)%j = (-(c(63)*M(2,:)%j)) * den(17)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(503),h0tab(:,503),[18,1,8,4],[0,nMT,nMW,nMT],4,1,wf4(:,15))
  call Hloop_QA_V(ntryL,G0H32(1),wf4(:,15),G0H8(45),m3h4x8(:,129),heltab2x32(:,:,503))
  Gcoeff(:)%j = (-(c(60)*M(2,:)%j)) * den(17)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(504),h0tab(:,504),[18,1,8,4],[nMW,nMB,0,nMB],4,1,wf4(:,15))
  call Hloop_QA_W(ntryL,G0H32(1),wf4(:,15),G0H8(46),m3h4x8(:,130),heltab2x32(:,:,504))
  Gcoeff(:)%j = (-(c(65)*M(2,:)%j)) * den(17)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(505),h0tab(:,505),[18,1,8,4],[nMZ,nMT,nMW,nMT],4,1,wf4(:,15))
  call Hloop_QA_Z(ntryL,G0H32(1),wf4(:,15),G0H8(47),ngZu,m3h4x8(:,131),heltab2x32(:,:,505))
  Gcoeff(:)%j = (-(c(65)*M(2,:)%j)) * den(17)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(506),h0tab(:,506),[18,1,8,4],[nMW,nMB,nMZ,nMB],4,1,wf4(:,15))
  call Hloop_QA_W(ntryL,G0H32(1),wf4(:,15),G0H8(48),m3h4x8(:,132),heltab2x32(:,:,506))
  Gcoeff(:)%j = (c(2)*M(1,:)%j) * den(17)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(507),h0tab(:,507),[18,1,8,4],[nMT,0,nMB,0],4,1,wf4(:,15))
  call Hloop_VA_Q(ntryL,G0H32(1),wf4(:,15),G0H8(49),m3h4x8(:,133),heltab2x32(:,:,507))
  call Hloop_A_Q(ntryL,G0H8(49),18,nMT,G1H8(85),n2h8(85))
  Gcoeff(:)%j = (-(c(5)*M(1,:)%j)) * den(17)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(508),h0tab(:,508),[18,1,8,4],[nMT,0,nMB,nMZ],4,1,wf4(:,15))
  call Hloop_ZA_Q(ntryL,G0H32(1),wf4(:,15),G0H8(49),ngZu,m3h4x8(:,134),heltab2x32(:,:,508))
  call Hloop_A_Q(ntryL,G0H8(49),18,nMT,G1H8(86),n2h8(86))
  Gcoeff(:)%j = (-(c(5)*M(1,:)%j)) * den(17)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(509),h0tab(:,509),[18,1,8,4],[nMT,nMZ,nMB,0],4,1,wf4(:,15))
  call Hloop_VA_Q(ntryL,G0H32(1),wf4(:,15),G0H8(49),m3h4x8(:,135),heltab2x32(:,:,509))
  call Hloop_A_Q(ntryL,G0H8(49),18,nMT,G1H8(87),n2h8(87))
  Gcoeff(:)%j = (c(7)*M(1,:)%j) * den(17)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(510),h0tab(:,510),[18,1,8,4],[nMT,nMZ,nMB,nMZ],4,1,wf4(:,15))
  call Hloop_ZA_Q(ntryL,G0H32(1),wf4(:,15),G0H8(49),ngZu,m3h4x8(:,136),heltab2x32(:,:,510))
  call Hloop_A_Q(ntryL,G0H8(49),18,nMT,G1H8(88),n2h8(88))
  Gcoeff(:)%j = (c(33)*M(4,:)%j) * den(2)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(511),h0tab(:,511),[20,2,1,8],[nMH,nMT,nMH,nMB],4,1,wf4(:,3))
  call Hloop_AQ_S(ntryL,G0H32(1),wf4(:,3),G0H8(49),ngH,m3h4x8(:,137),heltab2x32(:,:,511))
  Gcoeff(:)%j = (c(33)*M(4,:)%j) * den(2)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(512),h0tab(:,512),[20,2,1,8],[nMZ,nMT,nMH,nMB],4,1,wf4(:,3))
  call Hloop_AQ_S(ntryL,G0H32(1),wf4(:,3),G0H8(50),ngX,m3h4x8(:,138),heltab2x32(:,:,512))
  Gcoeff(:)%j = (c(33)*M(4,:)%j) * den(2)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(513),h0tab(:,513),[20,2,1,8],[nMH,nMT,nMZ,nMB],4,1,wf4(:,3))
  call Hloop_AQ_S(ntryL,G0H32(1),wf4(:,3),G0H8(51),ngH,m3h4x8(:,139),heltab2x32(:,:,513))
  Gcoeff(:)%j = (c(33)*M(4,:)%j) * den(2)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(514),h0tab(:,514),[20,2,1,8],[nMZ,nMT,nMZ,nMB],4,1,wf4(:,3))
  call Hloop_AQ_S(ntryL,G0H32(1),wf4(:,3),G0H8(52),ngX,m3h4x8(:,140),heltab2x32(:,:,514))
  Gcoeff(:)%j = (c(32)*M(2,:)%j) * den(2)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(515),h0tab(:,515),[20,2,1,8],[nMT,nMH,nMT,nMW],4,1,wf4(:,3))
  call Hloop_SQ_A(ntryL,G0H32(1),wf4(:,3),G0H8(53),ngPtb,m3h4x8(:,141),heltab2x32(:,:,515))
  call Hloop_Q_A(ntryL,G0H8(53),20,nMT,G1H8(89),n2h8(89))
  Gcoeff(:)%j = (c(21)*M(2,:)%j) * den(2)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(516),h0tab(:,516),[20,2,1,8],[nMB,nMW,nMB,nMH],4,1,wf4(:,3))
  call Hloop_SQ_A(ntryL,G0H32(1),wf4(:,3),G0H8(53),ngH,m3h4x8(:,142),heltab2x32(:,:,516))
  call Hloop_Q_A(ntryL,G0H8(53),20,nMB,G1H8(90),n2h8(90))
  Gcoeff(:)%j = (-(c(32)*M(2,:)%j)) * den(2)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(517),h0tab(:,517),[20,2,1,8],[nMT,nMZ,nMT,nMW],4,1,wf4(:,3))
  call Hloop_SQ_A(ntryL,G0H32(1),wf4(:,3),G0H8(53),ngPtb,m3h4x8(:,143),heltab2x32(:,:,517))
  call Hloop_Q_A(ntryL,G0H8(53),20,nMT,G1H8(91),n2h8(91))
  Gcoeff(:)%j = (-(c(21)*M(2,:)%j)) * den(2)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(518),h0tab(:,518),[20,2,1,8],[nMB,nMW,nMB,nMZ],4,1,wf4(:,3))
  call Hloop_SQ_A(ntryL,G0H32(1),wf4(:,3),G0H8(53),ngX,m3h4x8(:,144),heltab2x32(:,:,518))
  call Hloop_Q_A(ntryL,G0H8(53),20,nMB,G1H8(92),n2h8(92))
  Gcoeff(:)%j = (c(84)*M(4,:)%j) * den(2)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(519),h0tab(:,519),[20,2,1,8],[0,nMT,nMH,nMB],4,1,wf4(:,3))
  call Hloop_AQ_V(ntryL,G0H32(1),wf4(:,3),G0H8(53),m3h4x8(:,145),heltab2x32(:,:,519))
  Gcoeff(:)%j = (c(84)*M(4,:)%j) * den(2)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(520),h0tab(:,520),[20,2,1,8],[0,nMT,nMZ,nMB],4,1,wf4(:,3))
  call Hloop_AQ_V(ntryL,G0H32(1),wf4(:,3),G0H8(54),m3h4x8(:,146),heltab2x32(:,:,520))
  Gcoeff(:)%j = (-(c(86)*M(4,:)%j)) * den(2)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(521),h0tab(:,521),[20,2,1,8],[nMZ,nMT,nMH,nMB],4,1,wf4(:,3))
  call Hloop_AQ_Z(ntryL,G0H32(1),wf4(:,3),G0H8(55),ngZd,m3h4x8(:,147),heltab2x32(:,:,521))
  Gcoeff(:)%j = (-(c(86)*M(4,:)%j)) * den(2)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(522),h0tab(:,522),[20,2,1,8],[nMZ,nMT,nMZ,nMB],4,1,wf4(:,3))
  call Hloop_AQ_Z(ntryL,G0H32(1),wf4(:,3),G0H8(56),ngZd,m3h4x8(:,148),heltab2x32(:,:,522))
  Gcoeff(:)%j = (c(84)*M(4,:)%j) * den(2)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(523),h0tab(:,523),[20,2,1,8],[nMH,nMT,0,nMB],4,1,wf4(:,3))
  call Hloop_AQ_S(ntryL,G0H32(1),wf4(:,3),G0H8(57),ngH,m3h4x8(:,149),heltab2x32(:,:,523))
  Gcoeff(:)%j = (c(84)*M(4,:)%j) * den(2)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(524),h0tab(:,524),[20,2,1,8],[nMZ,nMT,0,nMB],4,1,wf4(:,3))
  call Hloop_AQ_S(ntryL,G0H32(1),wf4(:,3),G0H8(58),ngX,m3h4x8(:,150),heltab2x32(:,:,524))
  Gcoeff(:)%j = (-(c(86)*M(4,:)%j)) * den(2)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(525),h0tab(:,525),[20,2,1,8],[nMH,nMT,nMZ,nMB],4,1,wf4(:,3))
  call Hloop_AQ_S(ntryL,G0H32(1),wf4(:,3),G0H8(59),ngH,m3h4x8(:,151),heltab2x32(:,:,525))
  Gcoeff(:)%j = (-(c(86)*M(4,:)%j)) * den(2)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(526),h0tab(:,526),[20,2,1,8],[nMZ,nMT,nMZ,nMB],4,1,wf4(:,3))
  call Hloop_AQ_S(ntryL,G0H32(1),wf4(:,3),G0H8(60),ngX,m3h4x8(:,152),heltab2x32(:,:,526))
  Gcoeff(:)%j = (-(c(74)*M(2,:)%j)) * den(2)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(527),h0tab(:,527),[20,2,1,8],[nMB,nMW,nMB,0],4,1,wf4(:,3))
  call Hloop_VQ_A(ntryL,G0H32(1),wf4(:,3),G0H8(61),m3h4x8(:,153),heltab2x32(:,:,527))
  call Hloop_Q_A(ntryL,G0H8(61),20,nMB,G1H8(93),n2h8(93))
  Gcoeff(:)%j = (-(c(79)*M(2,:)%j)) * den(2)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(528),h0tab(:,528),[20,2,1,8],[nMB,nMW,nMB,nMZ],4,1,wf4(:,3))
  call Hloop_ZQ_A(ntryL,G0H32(1),wf4(:,3),G0H8(61),ngZd,m3h4x8(:,154),heltab2x32(:,:,528))
  call Hloop_Q_A(ntryL,G0H8(61),20,nMB,G1H8(94),n2h8(94))
  Gcoeff(:)%j = (c(46)*M(2,:)%j) * den(2)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(529),h0tab(:,529),[20,2,1,8],[nMT,nMH,nMT,nMW],4,1,wf4(:,3))
  call Hloop_WQ_A(ntryL,G0H32(1),wf4(:,3),G0H8(61),m3h4x8(:,155),heltab2x32(:,:,529))
  call Hloop_Q_A(ntryL,G0H8(61),20,nMT,G1H8(95),n2h8(95))
  Gcoeff(:)%j = (-(c(46)*M(2,:)%j)) * den(2)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(530),h0tab(:,530),[20,2,1,8],[nMT,nMZ,nMT,nMW],4,1,wf4(:,3))
  call Hloop_WQ_A(ntryL,G0H32(1),wf4(:,3),G0H8(61),m3h4x8(:,156),heltab2x32(:,:,530))
  call Hloop_Q_A(ntryL,G0H8(61),20,nMT,G1H8(96),n2h8(96))
  Gcoeff(:)%j = (-(c(77)*M(2,:)%j)) * den(2)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(531),h0tab(:,531),[20,2,1,8],[nMT,0,nMT,nMW],4,1,wf4(:,3))
  call Hloop_SQ_A(ntryL,G0H32(1),wf4(:,3),G0H8(61),ngPtb,m3h4x8(:,157),heltab2x32(:,:,531))
  call Hloop_Q_A(ntryL,G0H8(61),20,nMT,G1H8(97),n2h8(97))
  Gcoeff(:)%j = (-(c(79)*M(2,:)%j)) * den(2)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(532),h0tab(:,532),[20,2,1,8],[nMT,nMZ,nMT,nMW],4,1,wf4(:,3))
  call Hloop_SQ_A(ntryL,G0H32(1),wf4(:,3),G0H8(61),ngPtb,m3h4x8(:,158),heltab2x32(:,:,532))
  call Hloop_Q_A(ntryL,G0H8(61),20,nMT,G1H8(98),n2h8(98))
  Gcoeff(:)%j = (c(40)*M(2,:)%j) * den(2)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(533),h0tab(:,533),[20,2,1,8],[nMB,nMW,nMB,nMH],4,1,wf4(:,3))
  call Hloop_SQ_A(ntryL,G0H32(1),wf4(:,3),G0H8(61),ngH,m3h4x8(:,159),heltab2x32(:,:,533))
  call Hloop_Q_A(ntryL,G0H8(61),20,nMB,G1H8(99),n2h8(99))
  Gcoeff(:)%j = (-(c(40)*M(2,:)%j)) * den(2)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(534),h0tab(:,534),[20,2,1,8],[nMB,nMW,nMB,nMZ],4,1,wf4(:,3))
  call Hloop_SQ_A(ntryL,G0H32(1),wf4(:,3),G0H8(61),ngX,m3h4x8(:,160),heltab2x32(:,:,534))
  call Hloop_Q_A(ntryL,G0H8(61),20,nMB,G1H8(100),n2h8(100))
  Gcoeff(:)%j = (c(2)*M(4,:)%j) * den(2)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(535),h0tab(:,535),[20,2,1,8],[0,nMT,0,nMB],4,1,wf4(:,3))
  call Hloop_AQ_V(ntryL,G0H32(1),wf4(:,3),G0H8(61),m3h4x8(:,161),heltab2x32(:,:,535))
  Gcoeff(:)%j = (-(c(5)*M(4,:)%j)) * den(2)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(536),h0tab(:,536),[20,2,1,8],[nMZ,nMT,0,nMB],4,1,wf4(:,3))
  call Hloop_AQ_Z(ntryL,G0H32(1),wf4(:,3),G0H8(62),ngZd,m3h4x8(:,162),heltab2x32(:,:,536))
  Gcoeff(:)%j = (-(c(5)*M(4,:)%j)) * den(2)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(537),h0tab(:,537),[20,2,1,8],[0,nMT,nMZ,nMB],4,1,wf4(:,3))
  call Hloop_AQ_V(ntryL,G0H32(1),wf4(:,3),G0H8(63),m3h4x8(:,163),heltab2x32(:,:,537))
  Gcoeff(:)%j = (c(7)*M(4,:)%j) * den(2)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(538),h0tab(:,538),[20,2,1,8],[nMZ,nMT,nMZ,nMB],4,1,wf4(:,3))
  call Hloop_AQ_Z(ntryL,G0H32(1),wf4(:,3),G0H8(64),ngZd,m3h4x8(:,164),heltab2x32(:,:,538))
  Gcoeff(:)%j = (-(c(63)*M(2,:)%j)) * den(2)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(539),h0tab(:,539),[20,2,1,8],[nMT,0,nMT,nMW],4,1,wf4(:,3))
  call Hloop_WQ_A(ntryL,G0H32(1),wf4(:,3),G0H8(65),m3h4x8(:,165),heltab2x32(:,:,539))
  call Hloop_Q_A(ntryL,G0H8(65),20,nMT,G1H8(101),n2h8(101))
  Gcoeff(:)%j = (-(c(60)*M(2,:)%j)) * den(2)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(540),h0tab(:,540),[20,2,1,8],[nMB,nMW,nMB,0],4,1,wf4(:,3))
  call Hloop_VQ_A(ntryL,G0H32(1),wf4(:,3),G0H8(65),m3h4x8(:,166),heltab2x32(:,:,540))
  call Hloop_Q_A(ntryL,G0H8(65),20,nMB,G1H8(102),n2h8(102))
  Gcoeff(:)%j = (-(c(65)*M(2,:)%j)) * den(2)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(541),h0tab(:,541),[20,2,1,8],[nMT,nMZ,nMT,nMW],4,1,wf4(:,3))
  call Hloop_WQ_A(ntryL,G0H32(1),wf4(:,3),G0H8(65),m3h4x8(:,167),heltab2x32(:,:,541))
  call Hloop_Q_A(ntryL,G0H8(65),20,nMT,G1H8(103),n2h8(103))
  Gcoeff(:)%j = (-(c(65)*M(2,:)%j)) * den(2)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(542),h0tab(:,542),[20,2,1,8],[nMB,nMW,nMB,nMZ],4,1,wf4(:,3))
  call Hloop_ZQ_A(ntryL,G0H32(1),wf4(:,3),G0H8(65),ngZd,m3h4x8(:,168),heltab2x32(:,:,542))
  call Hloop_Q_A(ntryL,G0H8(65),20,nMB,G1H8(104),n2h8(104))
  Gcoeff(:)%j = (c(33)*M(4,:)%j) * den(2)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(543),h0tab(:,543),[20,1,2,8],[nMH,nMT,nMH,nMB],4,1,wf4(:,3))
  call Hloop_AQ_S(ntryL,G0H32(1),wf4(:,3),G0H8(65),ngH,m3h4x8(:,169),heltab2x32(:,:,543))
  Gcoeff(:)%j = (c(33)*M(4,:)%j) * den(2)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(544),h0tab(:,544),[20,1,2,8],[nMH,nMT,nMZ,nMB],4,1,wf4(:,3))
  call Hloop_AQ_S(ntryL,G0H32(1),wf4(:,3),G0H8(66),ngH,m3h4x8(:,170),heltab2x32(:,:,544))
  Gcoeff(:)%j = (c(33)*M(4,:)%j) * den(2)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(545),h0tab(:,545),[20,1,2,8],[nMZ,nMT,nMH,nMB],4,1,wf4(:,3))
  call Hloop_AQ_S(ntryL,G0H32(1),wf4(:,3),G0H8(67),ngX,m3h4x8(:,171),heltab2x32(:,:,545))
  Gcoeff(:)%j = (c(33)*M(4,:)%j) * den(2)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(546),h0tab(:,546),[20,1,2,8],[nMZ,nMT,nMZ,nMB],4,1,wf4(:,3))
  call Hloop_AQ_S(ntryL,G0H32(1),wf4(:,3),G0H8(68),ngX,m3h4x8(:,172),heltab2x32(:,:,546))
  Gcoeff(:)%j = (c(20)*M(4,:)%j) * den(2)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(547),h0tab(:,547),[20,1,2,8],[nMW,nMB,nMW,nMT],4,1,wf4(:,3))
  call Hloop_AQ_S(ntryL,G0H32(1),wf4(:,3),G0H8(69),ngPtb,m3h4x8(:,173),heltab2x32(:,:,547))
  Gcoeff(:)%j = (c(84)*M(4,:)%j) * den(2)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(548),h0tab(:,548),[20,1,2,8],[nMH,nMT,0,nMB],4,1,wf4(:,3))
  call Hloop_AQ_S(ntryL,G0H32(1),wf4(:,3),G0H8(70),ngH,m3h4x8(:,174),heltab2x32(:,:,548))
  Gcoeff(:)%j = (c(84)*M(4,:)%j) * den(2)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(549),h0tab(:,549),[20,1,2,8],[nMZ,nMT,0,nMB],4,1,wf4(:,3))
  call Hloop_AQ_S(ntryL,G0H32(1),wf4(:,3),G0H8(71),ngX,m3h4x8(:,175),heltab2x32(:,:,549))
  Gcoeff(:)%j = (-(c(86)*M(4,:)%j)) * den(2)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(550),h0tab(:,550),[20,1,2,8],[nMH,nMT,nMZ,nMB],4,1,wf4(:,3))
  call Hloop_AQ_S(ntryL,G0H32(1),wf4(:,3),G0H8(72),ngH,m3h4x8(:,176),heltab2x32(:,:,550))
  Gcoeff(:)%j = (-(c(86)*M(4,:)%j)) * den(2)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(551),h0tab(:,551),[20,1,2,8],[nMZ,nMT,nMZ,nMB],4,1,wf4(:,3))
  call Hloop_AQ_S(ntryL,G0H32(1),wf4(:,3),G0H8(73),ngX,m3h4x8(:,177),heltab2x32(:,:,551))
  Gcoeff(:)%j = (c(38)*M(4,:)%j) * den(2)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(552),h0tab(:,552),[20,1,2,8],[nMW,nMB,nMW,nMT],4,1,wf4(:,3))
  call Hloop_AQ_S(ntryL,G0H32(1),wf4(:,3),G0H8(74),ngPtb,m3h4x8(:,178),heltab2x32(:,:,552))
  Gcoeff(:)%j = (c(84)*M(4,:)%j) * den(2)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(553),h0tab(:,553),[20,1,2,8],[0,nMT,nMH,nMB],4,1,wf4(:,3))
  call Hloop_AQ_V(ntryL,G0H32(1),wf4(:,3),G0H8(75),m3h4x8(:,179),heltab2x32(:,:,553))
  Gcoeff(:)%j = (c(84)*M(4,:)%j) * den(2)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(554),h0tab(:,554),[20,1,2,8],[0,nMT,nMZ,nMB],4,1,wf4(:,3))
  call Hloop_AQ_V(ntryL,G0H32(1),wf4(:,3),G0H8(76),m3h4x8(:,180),heltab2x32(:,:,554))
  Gcoeff(:)%j = (-(c(86)*M(4,:)%j)) * den(2)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(555),h0tab(:,555),[20,1,2,8],[nMZ,nMT,nMH,nMB],4,1,wf4(:,3))
  call Hloop_AQ_Z(ntryL,G0H32(1),wf4(:,3),G0H8(77),ngZd,m3h4x8(:,181),heltab2x32(:,:,555))
  Gcoeff(:)%j = (-(c(86)*M(4,:)%j)) * den(2)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(556),h0tab(:,556),[20,1,2,8],[nMZ,nMT,nMZ,nMB],4,1,wf4(:,3))
  call Hloop_AQ_Z(ntryL,G0H32(1),wf4(:,3),G0H8(78),ngZd,m3h4x8(:,182),heltab2x32(:,:,556))
  Gcoeff(:)%j = (c(38)*M(4,:)%j) * den(2)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(557),h0tab(:,557),[20,1,2,8],[nMW,nMB,nMW,nMT],4,1,wf4(:,3))
  call Hloop_AQ_W(ntryL,G0H32(1),wf4(:,3),G0H8(79),m3h4x8(:,183),heltab2x32(:,:,557))
  Gcoeff(:)%j = (c(2)*M(4,:)%j) * den(2)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(558),h0tab(:,558),[20,1,2,8],[0,nMT,0,nMB],4,1,wf4(:,3))
  call Hloop_AQ_V(ntryL,G0H32(1),wf4(:,3),G0H8(80),m3h4x8(:,184),heltab2x32(:,:,558))
  Gcoeff(:)%j = (-(c(5)*M(4,:)%j)) * den(2)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(559),h0tab(:,559),[20,1,2,8],[0,nMT,nMZ,nMB],4,1,wf4(:,3))
  call Hloop_AQ_V(ntryL,G0H32(1),wf4(:,3),G0H8(81),m3h4x8(:,185),heltab2x32(:,:,559))
  Gcoeff(:)%j = (-(c(5)*M(4,:)%j)) * den(2)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(560),h0tab(:,560),[20,1,2,8],[nMZ,nMT,0,nMB],4,1,wf4(:,3))
  call Hloop_AQ_Z(ntryL,G0H32(1),wf4(:,3),G0H8(82),ngZd,m3h4x8(:,186),heltab2x32(:,:,560))
  Gcoeff(:)%j = (c(7)*M(4,:)%j) * den(2)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(561),h0tab(:,561),[20,1,2,8],[nMZ,nMT,nMZ,nMB],4,1,wf4(:,3))
  call Hloop_AQ_Z(ntryL,G0H32(1),wf4(:,3),G0H8(83),ngZd,m3h4x8(:,187),heltab2x32(:,:,561))
  Gcoeff(:)%j = (c(12)*M(4,:)%j) * den(2)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(562),h0tab(:,562),[20,1,2,8],[nMW,nMB,nMW,nMT],4,1,wf4(:,3))
  call Hloop_AQ_W(ntryL,G0H32(1),wf4(:,3),G0H8(84),m3h4x8(:,188),heltab2x32(:,:,562))
  Gcoeff(:)%j = (c(24)*M(2,:)%j) * den(2)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(563),h0tab(:,563),[20,1,8,2],[nMH,nMT,nMW,nMB],4,1,wf4(:,3))
  call Hloop_AQ_S(ntryL,G0H32(1),wf4(:,3),G0H8(85),ngH,m3h4x8(:,189),heltab2x32(:,:,563))
  Gcoeff(:)%j = (c(24)*M(2,:)%j) * den(2)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(564),h0tab(:,564),[20,1,8,2],[nMW,nMB,nMH,nMT],4,1,wf4(:,3))
  call Hloop_AQ_S(ntryL,G0H32(1),wf4(:,3),G0H8(86),ngPtb,m3h4x8(:,190),heltab2x32(:,:,564))
  Gcoeff(:)%j = (c(24)*M(2,:)%j) * den(2)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(565),h0tab(:,565),[20,1,8,2],[nMZ,nMT,nMW,nMB],4,1,wf4(:,3))
  call Hloop_AQ_S(ntryL,G0H32(1),wf4(:,3),G0H8(87),ngX,m3h4x8(:,191),heltab2x32(:,:,565))
  Gcoeff(:)%j = (c(24)*M(2,:)%j) * den(2)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(566),h0tab(:,566),[20,1,8,2],[nMW,nMB,nMZ,nMT],4,1,wf4(:,3))
  call Hloop_AQ_S(ntryL,G0H32(1),wf4(:,3),G0H8(88),ngPtb,m3h4x8(:,192),heltab2x32(:,:,566))
  Gcoeff(:)%j = (c(75)*M(2,:)%j) * den(2)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(567),h0tab(:,567),[20,1,8,2],[nMW,nMB,0,nMT],4,1,wf4(:,3))
  call Hloop_AQ_S(ntryL,G0H32(1),wf4(:,3),G0H8(89),ngPtb,m3h4x8(:,193),heltab2x32(:,:,567))
  Gcoeff(:)%j = (-(c(79)*M(2,:)%j)) * den(2)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(568),h0tab(:,568),[20,1,8,2],[nMW,nMB,nMZ,nMT],4,1,wf4(:,3))
  call Hloop_AQ_S(ntryL,G0H32(1),wf4(:,3),G0H8(90),ngPtb,m3h4x8(:,194),heltab2x32(:,:,568))
  Gcoeff(:)%j = (c(44)*M(2,:)%j) * den(2)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(569),h0tab(:,569),[20,1,8,2],[nMH,nMT,nMW,nMB],4,1,wf4(:,3))
  call Hloop_AQ_S(ntryL,G0H32(1),wf4(:,3),G0H8(91),ngH,m3h4x8(:,195),heltab2x32(:,:,569))
  Gcoeff(:)%j = (c(44)*M(2,:)%j) * den(2)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(570),h0tab(:,570),[20,1,8,2],[nMZ,nMT,nMW,nMB],4,1,wf4(:,3))
  call Hloop_AQ_S(ntryL,G0H32(1),wf4(:,3),G0H8(92),ngX,m3h4x8(:,196),heltab2x32(:,:,570))
  Gcoeff(:)%j = (c(75)*M(2,:)%j) * den(2)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(571),h0tab(:,571),[20,1,8,2],[0,nMT,nMW,nMB],4,1,wf4(:,3))
  call Hloop_AQ_V(ntryL,G0H32(1),wf4(:,3),G0H8(93),m3h4x8(:,197),heltab2x32(:,:,571))
  Gcoeff(:)%j = (-(c(79)*M(2,:)%j)) * den(2)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(572),h0tab(:,572),[20,1,8,2],[nMZ,nMT,nMW,nMB],4,1,wf4(:,3))
  call Hloop_AQ_Z(ntryL,G0H32(1),wf4(:,3),G0H8(94),ngZd,m3h4x8(:,198),heltab2x32(:,:,572))
  Gcoeff(:)%j = (c(44)*M(2,:)%j) * den(2)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(573),h0tab(:,573),[20,1,8,2],[nMW,nMB,nMH,nMT],4,1,wf4(:,3))
  call Hloop_AQ_W(ntryL,G0H32(1),wf4(:,3),G0H8(95),m3h4x8(:,199),heltab2x32(:,:,573))
  Gcoeff(:)%j = (c(44)*M(2,:)%j) * den(2)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(574),h0tab(:,574),[20,1,8,2],[nMW,nMB,nMZ,nMT],4,1,wf4(:,3))
  call Hloop_AQ_W(ntryL,G0H32(1),wf4(:,3),G0H8(96),m3h4x8(:,200),heltab2x32(:,:,574))
  Gcoeff(:)%j = (c(61)*M(2,:)%j) * den(2)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(575),h0tab(:,575),[20,1,8,2],[0,nMT,nMW,nMB],4,1,wf4(:,3))
  call Hloop_AQ_V(ntryL,G0H32(1),wf4(:,3),G0H8(97),m3h4x8(:,201),heltab2x32(:,:,575))
  Gcoeff(:)%j = (c(61)*M(2,:)%j) * den(2)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(576),h0tab(:,576),[20,1,8,2],[nMW,nMB,0,nMT],4,1,wf4(:,3))
  call Hloop_AQ_W(ntryL,G0H32(1),wf4(:,3),G0H8(98),m3h4x8(:,202),heltab2x32(:,:,576))
  Gcoeff(:)%j = (-(c(65)*M(2,:)%j)) * den(2)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(577),h0tab(:,577),[20,1,8,2],[nMZ,nMT,nMW,nMB],4,1,wf4(:,3))
  call Hloop_AQ_Z(ntryL,G0H32(1),wf4(:,3),G0H8(99),ngZd,m3h4x8(:,203),heltab2x32(:,:,577))
  Gcoeff(:)%j = (-(c(65)*M(2,:)%j)) * den(2)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(578),h0tab(:,578),[20,1,8,2],[nMW,nMB,nMZ,nMT],4,1,wf4(:,3))
  call Hloop_AQ_W(ntryL,G0H32(1),wf4(:,3),G0H8(100),m3h4x8(:,204),heltab2x32(:,:,578))
  Gcoeff(:)%j = (c(33)*M(4,:)%j) * den(8)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(579),h0tab(:,579),[24,2,1,4],[nMH,nMT,nMH,nMB],4,1,wf4(:,8))
  call Hloop_QA_S(ntryL,G0H32(1),wf4(:,8),G0H8(101),ngH,m3h4x8(:,205),heltab2x32(:,:,579))
  Gcoeff(:)%j = (c(33)*M(4,:)%j) * den(8)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(580),h0tab(:,580),[24,2,1,4],[nMZ,nMT,nMH,nMB],4,1,wf4(:,8))
  call Hloop_QA_S(ntryL,G0H32(1),wf4(:,8),G0H8(102),ngX,m3h4x8(:,206),heltab2x32(:,:,580))
  Gcoeff(:)%j = (c(33)*M(4,:)%j) * den(8)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(581),h0tab(:,581),[24,2,1,4],[nMH,nMT,nMZ,nMB],4,1,wf4(:,8))
  call Hloop_QA_S(ntryL,G0H32(1),wf4(:,8),G0H8(103),ngH,m3h4x8(:,207),heltab2x32(:,:,581))
  Gcoeff(:)%j = (c(33)*M(4,:)%j) * den(8)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(582),h0tab(:,582),[24,2,1,4],[nMZ,nMT,nMZ,nMB],4,1,wf4(:,8))
  call Hloop_QA_S(ntryL,G0H32(1),wf4(:,8),G0H8(104),ngX,m3h4x8(:,208),heltab2x32(:,:,582))
  Gcoeff(:)%j = (c(20)*M(4,:)%j) * den(8)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(583),h0tab(:,583),[24,2,1,4],[nMW,nMB,nMW,nMT],4,1,wf4(:,8))
  call Hloop_QA_S(ntryL,G0H32(1),wf4(:,8),G0H8(105),ngPbt,m3h4x8(:,209),heltab2x32(:,:,583))
  Gcoeff(:)%j = (c(84)*M(4,:)%j) * den(8)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(584),h0tab(:,584),[24,2,1,4],[0,nMT,nMH,nMB],4,1,wf4(:,8))
  call Hloop_QA_V(ntryL,G0H32(1),wf4(:,8),G0H8(106),m3h4x8(:,210),heltab2x32(:,:,584))
  Gcoeff(:)%j = (c(84)*M(4,:)%j) * den(8)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(585),h0tab(:,585),[24,2,1,4],[0,nMT,nMZ,nMB],4,1,wf4(:,8))
  call Hloop_QA_V(ntryL,G0H32(1),wf4(:,8),G0H8(107),m3h4x8(:,211),heltab2x32(:,:,585))
  Gcoeff(:)%j = (-(c(86)*M(4,:)%j)) * den(8)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(586),h0tab(:,586),[24,2,1,4],[nMZ,nMT,nMH,nMB],4,1,wf4(:,8))
  call Hloop_QA_Z(ntryL,G0H32(1),wf4(:,8),G0H8(108),ngZd,m3h4x8(:,212),heltab2x32(:,:,586))
  Gcoeff(:)%j = (-(c(86)*M(4,:)%j)) * den(8)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(587),h0tab(:,587),[24,2,1,4],[nMZ,nMT,nMZ,nMB],4,1,wf4(:,8))
  call Hloop_QA_Z(ntryL,G0H32(1),wf4(:,8),G0H8(109),ngZd,m3h4x8(:,213),heltab2x32(:,:,587))
  Gcoeff(:)%j = (c(38)*M(4,:)%j) * den(8)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(588),h0tab(:,588),[24,2,1,4],[nMW,nMB,nMW,nMT],4,1,wf4(:,8))
  call Hloop_QA_W(ntryL,G0H32(1),wf4(:,8),G0H8(110),m3h4x8(:,214),heltab2x32(:,:,588))
  Gcoeff(:)%j = (c(84)*M(4,:)%j) * den(8)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(589),h0tab(:,589),[24,2,1,4],[nMH,nMT,0,nMB],4,1,wf4(:,8))
  call Hloop_QA_S(ntryL,G0H32(1),wf4(:,8),G0H8(111),ngH,m3h4x8(:,215),heltab2x32(:,:,589))
  Gcoeff(:)%j = (c(84)*M(4,:)%j) * den(8)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(590),h0tab(:,590),[24,2,1,4],[nMZ,nMT,0,nMB],4,1,wf4(:,8))
  call Hloop_QA_S(ntryL,G0H32(1),wf4(:,8),G0H8(112),ngX,m3h4x8(:,216),heltab2x32(:,:,590))
  Gcoeff(:)%j = (-(c(86)*M(4,:)%j)) * den(8)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(591),h0tab(:,591),[24,2,1,4],[nMH,nMT,nMZ,nMB],4,1,wf4(:,8))
  call Hloop_QA_S(ntryL,G0H32(1),wf4(:,8),G0H8(113),ngH,m3h4x8(:,217),heltab2x32(:,:,591))
  Gcoeff(:)%j = (-(c(86)*M(4,:)%j)) * den(8)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(592),h0tab(:,592),[24,2,1,4],[nMZ,nMT,nMZ,nMB],4,1,wf4(:,8))
  call Hloop_QA_S(ntryL,G0H32(1),wf4(:,8),G0H8(114),ngX,m3h4x8(:,218),heltab2x32(:,:,592))
  Gcoeff(:)%j = (c(38)*M(4,:)%j) * den(8)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(593),h0tab(:,593),[24,2,1,4],[nMW,nMB,nMW,nMT],4,1,wf4(:,8))
  call Hloop_QA_S(ntryL,G0H32(1),wf4(:,8),G0H8(115),ngPbt,m3h4x8(:,219),heltab2x32(:,:,593))
  Gcoeff(:)%j = (c(2)*M(4,:)%j) * den(8)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(594),h0tab(:,594),[24,2,1,4],[0,nMT,0,nMB],4,1,wf4(:,8))
  call Hloop_QA_V(ntryL,G0H32(1),wf4(:,8),G0H8(116),m3h4x8(:,220),heltab2x32(:,:,594))
  Gcoeff(:)%j = (-(c(5)*M(4,:)%j)) * den(8)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(595),h0tab(:,595),[24,2,1,4],[nMZ,nMT,0,nMB],4,1,wf4(:,8))
  call Hloop_QA_Z(ntryL,G0H32(1),wf4(:,8),G0H8(117),ngZd,m3h4x8(:,221),heltab2x32(:,:,595))
  Gcoeff(:)%j = (-(c(5)*M(4,:)%j)) * den(8)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(596),h0tab(:,596),[24,2,1,4],[0,nMT,nMZ,nMB],4,1,wf4(:,8))
  call Hloop_QA_V(ntryL,G0H32(1),wf4(:,8),G0H8(118),m3h4x8(:,222),heltab2x32(:,:,596))
  Gcoeff(:)%j = (c(7)*M(4,:)%j) * den(8)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(597),h0tab(:,597),[24,2,1,4],[nMZ,nMT,nMZ,nMB],4,1,wf4(:,8))
  call Hloop_QA_Z(ntryL,G0H32(1),wf4(:,8),G0H8(119),ngZd,m3h4x8(:,223),heltab2x32(:,:,597))
  Gcoeff(:)%j = (c(12)*M(4,:)%j) * den(8)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(598),h0tab(:,598),[24,2,1,4],[nMW,nMB,nMW,nMT],4,1,wf4(:,8))
  call Hloop_QA_W(ntryL,G0H32(1),wf4(:,8),G0H8(120),m3h4x8(:,224),heltab2x32(:,:,598))
  Gcoeff(:)%j = (c(33)*M(4,:)%j) * den(8)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(599),h0tab(:,599),[24,1,2,4],[nMH,nMT,nMH,nMB],4,1,wf4(:,8))
  call Hloop_QA_S(ntryL,G0H32(1),wf4(:,8),G0H8(121),ngH,m3h4x8(:,225),heltab2x32(:,:,599))
  Gcoeff(:)%j = (c(33)*M(4,:)%j) * den(8)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(600),h0tab(:,600),[24,1,2,4],[nMH,nMT,nMZ,nMB],4,1,wf4(:,8))
  call Hloop_QA_S(ntryL,G0H32(1),wf4(:,8),G0H8(122),ngH,m3h4x8(:,226),heltab2x32(:,:,600))
  Gcoeff(:)%j = (c(33)*M(4,:)%j) * den(8)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(601),h0tab(:,601),[24,1,2,4],[nMZ,nMT,nMH,nMB],4,1,wf4(:,8))
  call Hloop_QA_S(ntryL,G0H32(1),wf4(:,8),G0H8(123),ngX,m3h4x8(:,227),heltab2x32(:,:,601))
  Gcoeff(:)%j = (c(33)*M(4,:)%j) * den(8)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(602),h0tab(:,602),[24,1,2,4],[nMZ,nMT,nMZ,nMB],4,1,wf4(:,8))
  call Hloop_QA_S(ntryL,G0H32(1),wf4(:,8),G0H8(124),ngX,m3h4x8(:,228),heltab2x32(:,:,602))
  Gcoeff(:)%j = (c(32)*M(3,:)%j) * den(8)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(603),h0tab(:,603),[24,1,2,4],[nMT,nMH,nMT,nMW],4,1,wf4(:,8))
  call Hloop_SA_Q(ntryL,G0H32(1),wf4(:,8),G0H8(125),ngPbt,m3h4x8(:,229),heltab2x32(:,:,603))
  call Hloop_A_Q(ntryL,G0H8(125),24,nMT,G1H8(105),n2h8(105))
  Gcoeff(:)%j = (c(21)*M(3,:)%j) * den(8)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(604),h0tab(:,604),[24,1,2,4],[nMB,nMW,nMB,nMH],4,1,wf4(:,8))
  call Hloop_SA_Q(ntryL,G0H32(1),wf4(:,8),G0H8(125),ngH,m3h4x8(:,230),heltab2x32(:,:,604))
  call Hloop_A_Q(ntryL,G0H8(125),24,nMB,G1H8(106),n2h8(106))
  Gcoeff(:)%j = (-(c(32)*M(3,:)%j)) * den(8)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(605),h0tab(:,605),[24,1,2,4],[nMT,nMZ,nMT,nMW],4,1,wf4(:,8))
  call Hloop_SA_Q(ntryL,G0H32(1),wf4(:,8),G0H8(125),ngPbt,m3h4x8(:,231),heltab2x32(:,:,605))
  call Hloop_A_Q(ntryL,G0H8(125),24,nMT,G1H8(107),n2h8(107))
  Gcoeff(:)%j = (-(c(21)*M(3,:)%j)) * den(8)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(606),h0tab(:,606),[24,1,2,4],[nMB,nMW,nMB,nMZ],4,1,wf4(:,8))
  call Hloop_SA_Q(ntryL,G0H32(1),wf4(:,8),G0H8(125),ngX,m3h4x8(:,232),heltab2x32(:,:,606))
  call Hloop_A_Q(ntryL,G0H8(125),24,nMB,G1H8(108),n2h8(108))
  Gcoeff(:)%j = (c(84)*M(4,:)%j) * den(8)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(607),h0tab(:,607),[24,1,2,4],[nMH,nMT,0,nMB],4,1,wf4(:,8))
  call Hloop_QA_S(ntryL,G0H32(1),wf4(:,8),G0H8(125),ngH,m3h4x8(:,233),heltab2x32(:,:,607))
  Gcoeff(:)%j = (c(84)*M(4,:)%j) * den(8)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(608),h0tab(:,608),[24,1,2,4],[nMZ,nMT,0,nMB],4,1,wf4(:,8))
  call Hloop_QA_S(ntryL,G0H32(1),wf4(:,8),G0H8(126),ngX,m3h4x8(:,234),heltab2x32(:,:,608))
  Gcoeff(:)%j = (-(c(86)*M(4,:)%j)) * den(8)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(609),h0tab(:,609),[24,1,2,4],[nMH,nMT,nMZ,nMB],4,1,wf4(:,8))
  call Hloop_QA_S(ntryL,G0H32(1),wf4(:,8),G0H8(127),ngH,m3h4x8(:,235),heltab2x32(:,:,609))
  Gcoeff(:)%j = (-(c(86)*M(4,:)%j)) * den(8)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(610),h0tab(:,610),[24,1,2,4],[nMZ,nMT,nMZ,nMB],4,1,wf4(:,8))
  call Hloop_QA_S(ntryL,G0H32(1),wf4(:,8),G0H8(128),ngX,m3h4x8(:,236),heltab2x32(:,:,610))
  Gcoeff(:)%j = (c(84)*M(4,:)%j) * den(8)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(611),h0tab(:,611),[24,1,2,4],[0,nMT,nMH,nMB],4,1,wf4(:,8))
  call Hloop_QA_V(ntryL,G0H32(1),wf4(:,8),G0H8(129),m3h4x8(:,237),heltab2x32(:,:,611))
  Gcoeff(:)%j = (c(84)*M(4,:)%j) * den(8)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(612),h0tab(:,612),[24,1,2,4],[0,nMT,nMZ,nMB],4,1,wf4(:,8))
  call Hloop_QA_V(ntryL,G0H32(1),wf4(:,8),G0H8(130),m3h4x8(:,238),heltab2x32(:,:,612))
  Gcoeff(:)%j = (-(c(86)*M(4,:)%j)) * den(8)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(613),h0tab(:,613),[24,1,2,4],[nMZ,nMT,nMH,nMB],4,1,wf4(:,8))
  call Hloop_QA_Z(ntryL,G0H32(1),wf4(:,8),G0H8(131),ngZd,m3h4x8(:,239),heltab2x32(:,:,613))
  Gcoeff(:)%j = (-(c(86)*M(4,:)%j)) * den(8)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(614),h0tab(:,614),[24,1,2,4],[nMZ,nMT,nMZ,nMB],4,1,wf4(:,8))
  call Hloop_QA_Z(ntryL,G0H32(1),wf4(:,8),G0H8(132),ngZd,m3h4x8(:,240),heltab2x32(:,:,614))
  Gcoeff(:)%j = (-(c(74)*M(3,:)%j)) * den(8)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(615),h0tab(:,615),[24,1,2,4],[nMB,nMW,nMB,0],4,1,wf4(:,8))
  call Hloop_VA_Q(ntryL,G0H32(1),wf4(:,8),G0H8(133),m3h4x8(:,241),heltab2x32(:,:,615))
  call Hloop_A_Q(ntryL,G0H8(133),24,nMB,G1H8(109),n2h8(109))
  Gcoeff(:)%j = (-(c(79)*M(3,:)%j)) * den(8)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(616),h0tab(:,616),[24,1,2,4],[nMB,nMW,nMB,nMZ],4,1,wf4(:,8))
  call Hloop_ZA_Q(ntryL,G0H32(1),wf4(:,8),G0H8(133),ngZd,m3h4x8(:,242),heltab2x32(:,:,616))
  call Hloop_A_Q(ntryL,G0H8(133),24,nMB,G1H8(110),n2h8(110))
  Gcoeff(:)%j = (c(46)*M(3,:)%j) * den(8)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(617),h0tab(:,617),[24,1,2,4],[nMT,nMH,nMT,nMW],4,1,wf4(:,8))
  call Hloop_WA_Q(ntryL,G0H32(1),wf4(:,8),G0H8(133),m3h4x8(:,243),heltab2x32(:,:,617))
  call Hloop_A_Q(ntryL,G0H8(133),24,nMT,G1H8(111),n2h8(111))
  Gcoeff(:)%j = (-(c(46)*M(3,:)%j)) * den(8)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(618),h0tab(:,618),[24,1,2,4],[nMT,nMZ,nMT,nMW],4,1,wf4(:,8))
  call Hloop_WA_Q(ntryL,G0H32(1),wf4(:,8),G0H8(133),m3h4x8(:,244),heltab2x32(:,:,618))
  call Hloop_A_Q(ntryL,G0H8(133),24,nMT,G1H8(112),n2h8(112))
  Gcoeff(:)%j = (-(c(77)*M(3,:)%j)) * den(8)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(619),h0tab(:,619),[24,1,2,4],[nMT,0,nMT,nMW],4,1,wf4(:,8))
  call Hloop_SA_Q(ntryL,G0H32(1),wf4(:,8),G0H8(133),ngPbt,m3h4x8(:,245),heltab2x32(:,:,619))
  call Hloop_A_Q(ntryL,G0H8(133),24,nMT,G1H8(113),n2h8(113))
  Gcoeff(:)%j = (-(c(79)*M(3,:)%j)) * den(8)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(620),h0tab(:,620),[24,1,2,4],[nMT,nMZ,nMT,nMW],4,1,wf4(:,8))
  call Hloop_SA_Q(ntryL,G0H32(1),wf4(:,8),G0H8(133),ngPbt,m3h4x8(:,246),heltab2x32(:,:,620))
  call Hloop_A_Q(ntryL,G0H8(133),24,nMT,G1H8(114),n2h8(114))
  Gcoeff(:)%j = (c(40)*M(3,:)%j) * den(8)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(621),h0tab(:,621),[24,1,2,4],[nMB,nMW,nMB,nMH],4,1,wf4(:,8))
  call Hloop_SA_Q(ntryL,G0H32(1),wf4(:,8),G0H8(133),ngH,m3h4x8(:,247),heltab2x32(:,:,621))
  call Hloop_A_Q(ntryL,G0H8(133),24,nMB,G1H8(115),n2h8(115))
  Gcoeff(:)%j = (-(c(40)*M(3,:)%j)) * den(8)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(622),h0tab(:,622),[24,1,2,4],[nMB,nMW,nMB,nMZ],4,1,wf4(:,8))
  call Hloop_SA_Q(ntryL,G0H32(1),wf4(:,8),G0H8(133),ngX,m3h4x8(:,248),heltab2x32(:,:,622))
  call Hloop_A_Q(ntryL,G0H8(133),24,nMB,G1H8(116),n2h8(116))
  Gcoeff(:)%j = (c(2)*M(4,:)%j) * den(8)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(623),h0tab(:,623),[24,1,2,4],[0,nMT,0,nMB],4,1,wf4(:,8))
  call Hloop_QA_V(ntryL,G0H32(1),wf4(:,8),G0H8(133),m3h4x8(:,249),heltab2x32(:,:,623))
  Gcoeff(:)%j = (-(c(5)*M(4,:)%j)) * den(8)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(624),h0tab(:,624),[24,1,2,4],[0,nMT,nMZ,nMB],4,1,wf4(:,8))
  call Hloop_QA_V(ntryL,G0H32(1),wf4(:,8),G0H8(134),m3h4x8(:,250),heltab2x32(:,:,624))
  Gcoeff(:)%j = (-(c(5)*M(4,:)%j)) * den(8)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(625),h0tab(:,625),[24,1,2,4],[nMZ,nMT,0,nMB],4,1,wf4(:,8))
  call Hloop_QA_Z(ntryL,G0H32(1),wf4(:,8),G0H8(135),ngZd,m3h4x8(:,251),heltab2x32(:,:,625))
  Gcoeff(:)%j = (c(7)*M(4,:)%j) * den(8)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(626),h0tab(:,626),[24,1,2,4],[nMZ,nMT,nMZ,nMB],4,1,wf4(:,8))
  call Hloop_QA_Z(ntryL,G0H32(1),wf4(:,8),G0H8(136),ngZd,m3h4x8(:,252),heltab2x32(:,:,626))
  Gcoeff(:)%j = (-(c(63)*M(3,:)%j)) * den(8)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(627),h0tab(:,627),[24,1,2,4],[nMT,0,nMT,nMW],4,1,wf4(:,8))
  call Hloop_WA_Q(ntryL,G0H32(1),wf4(:,8),G0H8(137),m3h4x8(:,253),heltab2x32(:,:,627))
  call Hloop_A_Q(ntryL,G0H8(137),24,nMT,G1H8(117),n2h8(117))
  Gcoeff(:)%j = (-(c(60)*M(3,:)%j)) * den(8)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(628),h0tab(:,628),[24,1,2,4],[nMB,nMW,nMB,0],4,1,wf4(:,8))
  call Hloop_VA_Q(ntryL,G0H32(1),wf4(:,8),G0H8(137),m3h4x8(:,254),heltab2x32(:,:,628))
  call Hloop_A_Q(ntryL,G0H8(137),24,nMB,G1H8(118),n2h8(118))
  Gcoeff(:)%j = (-(c(65)*M(3,:)%j)) * den(8)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(629),h0tab(:,629),[24,1,2,4],[nMT,nMZ,nMT,nMW],4,1,wf4(:,8))
  call Hloop_WA_Q(ntryL,G0H32(1),wf4(:,8),G0H8(137),m3h4x8(:,255),heltab2x32(:,:,629))
  call Hloop_A_Q(ntryL,G0H8(137),24,nMT,G1H8(119),n2h8(119))
  Gcoeff(:)%j = (-(c(65)*M(3,:)%j)) * den(8)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(630),h0tab(:,630),[24,1,2,4],[nMB,nMW,nMB,nMZ],4,1,wf4(:,8))
  call Hloop_ZA_Q(ntryL,G0H32(1),wf4(:,8),G0H8(137),ngZd,m3h4x8(:,256),heltab2x32(:,:,630))
  call Hloop_A_Q(ntryL,G0H8(137),24,nMB,G1H8(120),n2h8(120))
  Gcoeff(:)%j = (c(24)*M(3,:)%j) * den(8)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(631),h0tab(:,631),[24,1,4,2],[nMT,nMH,nMB,nMW],4,1,wf4(:,8))
  call Hloop_SA_Q(ntryL,G0H32(1),wf4(:,8),G0H8(137),ngPbt,m3h4x8(:,257),heltab2x32(:,:,631))
  call Hloop_A_Q(ntryL,G0H8(137),24,nMT,G1H8(121),n2h8(121))
  Gcoeff(:)%j = (c(24)*M(3,:)%j) * den(8)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(632),h0tab(:,632),[24,1,4,2],[nMB,nMW,nMT,nMH],4,1,wf4(:,8))
  call Hloop_SA_Q(ntryL,G0H32(1),wf4(:,8),G0H8(137),ngH,m3h4x8(:,258),heltab2x32(:,:,632))
  call Hloop_A_Q(ntryL,G0H8(137),24,nMB,G1H8(122),n2h8(122))
  Gcoeff(:)%j = (c(24)*M(3,:)%j) * den(8)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(633),h0tab(:,633),[24,1,4,2],[nMT,nMZ,nMB,nMW],4,1,wf4(:,8))
  call Hloop_SA_Q(ntryL,G0H32(1),wf4(:,8),G0H8(137),ngPbt,m3h4x8(:,259),heltab2x32(:,:,633))
  call Hloop_A_Q(ntryL,G0H8(137),24,nMT,G1H8(123),n2h8(123))
  Gcoeff(:)%j = (c(24)*M(3,:)%j) * den(8)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(634),h0tab(:,634),[24,1,4,2],[nMB,nMW,nMT,nMZ],4,1,wf4(:,8))
  call Hloop_SA_Q(ntryL,G0H32(1),wf4(:,8),G0H8(137),ngX,m3h4x8(:,260),heltab2x32(:,:,634))
  call Hloop_A_Q(ntryL,G0H8(137),24,nMB,G1H8(124),n2h8(124))
  Gcoeff(:)%j = (c(75)*M(3,:)%j) * den(8)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(635),h0tab(:,635),[24,1,4,2],[nMB,nMW,nMT,0],4,1,wf4(:,8))
  call Hloop_VA_Q(ntryL,G0H32(1),wf4(:,8),G0H8(137),m3h4x8(:,261),heltab2x32(:,:,635))
  call Hloop_A_Q(ntryL,G0H8(137),24,nMB,G1H8(125),n2h8(125))
  Gcoeff(:)%j = (-(c(79)*M(3,:)%j)) * den(8)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(636),h0tab(:,636),[24,1,4,2],[nMB,nMW,nMT,nMZ],4,1,wf4(:,8))
  call Hloop_ZA_Q(ntryL,G0H32(1),wf4(:,8),G0H8(137),ngZd,m3h4x8(:,262),heltab2x32(:,:,636))
  call Hloop_A_Q(ntryL,G0H8(137),24,nMB,G1H8(126),n2h8(126))
  Gcoeff(:)%j = (c(44)*M(3,:)%j) * den(8)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(637),h0tab(:,637),[24,1,4,2],[nMT,nMH,nMB,nMW],4,1,wf4(:,8))
  call Hloop_WA_Q(ntryL,G0H32(1),wf4(:,8),G0H8(137),m3h4x8(:,263),heltab2x32(:,:,637))
  call Hloop_A_Q(ntryL,G0H8(137),24,nMT,G1H8(127),n2h8(127))
  Gcoeff(:)%j = (c(44)*M(3,:)%j) * den(8)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(638),h0tab(:,638),[24,1,4,2],[nMT,nMZ,nMB,nMW],4,1,wf4(:,8))
  call Hloop_WA_Q(ntryL,G0H32(1),wf4(:,8),G0H8(137),m3h4x8(:,264),heltab2x32(:,:,638))
  call Hloop_A_Q(ntryL,G0H8(137),24,nMT,G1H8(128),n2h8(128))
  Gcoeff(:)%j = (c(75)*M(3,:)%j) * den(8)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(639),h0tab(:,639),[24,1,4,2],[nMT,0,nMB,nMW],4,1,wf4(:,8))
  call Hloop_SA_Q(ntryL,G0H32(1),wf4(:,8),G0H8(137),ngPbt,m3h4x8(:,265),heltab2x32(:,:,639))
  call Hloop_A_Q(ntryL,G0H8(137),24,nMT,G1H8(129),n2h8(129))
  Gcoeff(:)%j = (-(c(79)*M(3,:)%j)) * den(8)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(640),h0tab(:,640),[24,1,4,2],[nMT,nMZ,nMB,nMW],4,1,wf4(:,8))
  call Hloop_SA_Q(ntryL,G0H32(1),wf4(:,8),G0H8(137),ngPbt,m3h4x8(:,266),heltab2x32(:,:,640))
  call Hloop_A_Q(ntryL,G0H8(137),24,nMT,G1H8(130),n2h8(130))
  Gcoeff(:)%j = (c(44)*M(3,:)%j) * den(8)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(641),h0tab(:,641),[24,1,4,2],[nMB,nMW,nMT,nMH],4,1,wf4(:,8))
  call Hloop_SA_Q(ntryL,G0H32(1),wf4(:,8),G0H8(137),ngH,m3h4x8(:,267),heltab2x32(:,:,641))
  call Hloop_A_Q(ntryL,G0H8(137),24,nMB,G1H8(131),n2h8(131))
  Gcoeff(:)%j = (c(44)*M(3,:)%j) * den(8)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(642),h0tab(:,642),[24,1,4,2],[nMB,nMW,nMT,nMZ],4,1,wf4(:,8))
  call Hloop_SA_Q(ntryL,G0H32(1),wf4(:,8),G0H8(137),ngX,m3h4x8(:,268),heltab2x32(:,:,642))
  call Hloop_A_Q(ntryL,G0H8(137),24,nMB,G1H8(132),n2h8(132))
  Gcoeff(:)%j = (c(61)*M(3,:)%j) * den(8)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(643),h0tab(:,643),[24,1,4,2],[nMT,0,nMB,nMW],4,1,wf4(:,8))
  call Hloop_WA_Q(ntryL,G0H32(1),wf4(:,8),G0H8(137),m3h4x8(:,269),heltab2x32(:,:,643))
  call Hloop_A_Q(ntryL,G0H8(137),24,nMT,G1H8(133),n2h8(133))
  Gcoeff(:)%j = (c(61)*M(3,:)%j) * den(8)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(644),h0tab(:,644),[24,1,4,2],[nMB,nMW,nMT,0],4,1,wf4(:,8))
  call Hloop_VA_Q(ntryL,G0H32(1),wf4(:,8),G0H8(137),m3h4x8(:,270),heltab2x32(:,:,644))
  call Hloop_A_Q(ntryL,G0H8(137),24,nMB,G1H8(134),n2h8(134))
  Gcoeff(:)%j = (-(c(65)*M(3,:)%j)) * den(8)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(645),h0tab(:,645),[24,1,4,2],[nMT,nMZ,nMB,nMW],4,1,wf4(:,8))
  call Hloop_WA_Q(ntryL,G0H32(1),wf4(:,8),G0H8(137),m3h4x8(:,271),heltab2x32(:,:,645))
  call Hloop_A_Q(ntryL,G0H8(137),24,nMT,G1H8(135),n2h8(135))
  Gcoeff(:)%j = (-(c(65)*M(3,:)%j)) * den(8)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(646),h0tab(:,646),[24,1,4,2],[nMB,nMW,nMT,nMZ],4,1,wf4(:,8))
  call Hloop_ZA_Q(ntryL,G0H32(1),wf4(:,8),G0H8(137),ngZd,m3h4x8(:,272),heltab2x32(:,:,646))
  call Hloop_A_Q(ntryL,G0H8(137),24,nMB,G1H8(136),n2h8(136))
  call Hloop_QS_A(ntryL,G1H16(1),wf4(:,1),G1H4(1),ngH,m3h4x4(:,1),heltab2x16(:,:,137))
  call Hloop_Q_A(ntryL,G1H4(1),19,nMB,G2H4(3),n2h4(137))
  call Hloop_QS_A(ntryL,G1H16(2),wf4(:,1),G1H4(1),ngH,m3h4x4(:,2),heltab2x16(:,:,138))
  call Hloop_Q_A(ntryL,G1H4(1),19,nMB,G2H4(4),n2h4(138))
  call Hloop_QS_A(ntryL,G1H16(3),wf4(:,1),G1H4(1),ngH,m3h4x4(:,3),heltab2x16(:,:,139))
  call Hloop_Q_A(ntryL,G1H4(1),19,nMT,G2H4(5),n2h4(139))
  call Hloop_QS_A(ntryL,G1H16(4),wf4(:,4),G1H4(1),ngX,m3h4x4(:,4),heltab2x16(:,:,140))
  call Hloop_Q_A(ntryL,G1H4(1),19,nMB,G2H4(7),n2h4(140))
  call Hloop_QS_A(ntryL,G1H16(5),wf4(:,4),G1H4(1),ngX,m3h4x4(:,5),heltab2x16(:,:,141))
  call Hloop_Q_A(ntryL,G1H4(1),19,nMB,G2H4(9),n2h4(141))
  call Hloop_QS_A(ntryL,G1H16(6),wf4(:,4),G1H4(1),ngX,m3h4x4(:,6),heltab2x16(:,:,142))
  call Hloop_Q_A(ntryL,G1H4(1),19,nMT,G2H4(10),n2h4(142))
  call Hloop_QS_A(ntryL,G1H16(7),wf4(:,1),G1H4(1),ngH,m3h4x4(:,7),heltab2x16(:,:,143))
  call Hloop_Q_A(ntryL,G1H4(1),19,nMB,G2H4(22),n2h4(143))
  call Hloop_QS_A(ntryL,G1H16(8),wf4(:,1),G1H4(1),ngH,m3h4x4(:,8),heltab2x16(:,:,144))
  call Hloop_Q_A(ntryL,G1H4(1),19,nMB,G2H4(24),n2h4(144))
  call Hloop_QS_A(ntryL,G1H16(9),wf4(:,1),G1H4(1),ngH,m3h4x4(:,9),heltab2x16(:,:,145))
  call Hloop_Q_A(ntryL,G1H4(1),19,nMT,G2H4(30),n2h4(145))
  call Hloop_QS_A(ntryL,G1H16(10),wf4(:,4),G1H4(1),ngX,m3h4x4(:,10),heltab2x16(:,:,146))
  call Hloop_Q_A(ntryL,G1H4(1),19,nMB,G2H4(32),n2h4(146))
  call Hloop_QS_A(ntryL,G1H16(11),wf4(:,4),G1H4(1),ngX,m3h4x4(:,11),heltab2x16(:,:,147))
  call Hloop_Q_A(ntryL,G1H4(1),19,nMB,G2H4(38),n2h4(147))
  call Hloop_QS_A(ntryL,G1H16(12),wf4(:,4),G1H4(1),ngX,m3h4x4(:,12),heltab2x16(:,:,148))
  call Hloop_Q_A(ntryL,G1H4(1),19,nMT,G2H4(39),n2h4(148))
  call Hloop_QV_A(ntryL,G1H16(13),wf4(:,5),G1H4(1),m3h4x4(:,13),heltab2x16(:,:,149))
  call Hloop_Q_A(ntryL,G1H4(1),19,nMB,G2H4(40),n2h4(149))
  call Hloop_QV_A(ntryL,G1H16(14),wf4(:,5),G1H4(1),m3h4x4(:,14),heltab2x16(:,:,150))
  call Hloop_Q_A(ntryL,G1H4(1),19,nMB,G2H4(41),n2h4(150))
  call Hloop_QV_A(ntryL,G1H16(15),wf4(:,5),G1H4(1),m3h4x4(:,15),heltab2x16(:,:,151))
  call Hloop_Q_A(ntryL,G1H4(1),19,nMT,G2H4(42),n2h4(151))
  call Hloop_QZ_A(ntryL,G1H16(16),wf4(:,6),G1H4(1),ngZd,m3h4x4(:,16),heltab2x16(:,:,152))
  call Hloop_Q_A(ntryL,G1H4(1),19,nMB,G2H4(44),n2h4(152))
  call Hloop_QZ_A(ntryL,G1H16(17),wf4(:,6),G1H4(1),ngZd,m3h4x4(:,17),heltab2x16(:,:,153))
  call Hloop_Q_A(ntryL,G1H4(1),19,nMB,G2H4(54),n2h4(153))
  call Hloop_QZ_A(ntryL,G1H16(18),wf4(:,6),G1H4(1),ngZu,m3h4x4(:,18),heltab2x16(:,:,154))
  call Hloop_Q_A(ntryL,G1H4(1),19,nMT,G2H4(55),n2h4(154))
  call Hloop_QV_A(ntryL,G1H16(19),wf4(:,5),G1H4(1),m3h4x4(:,19),heltab2x16(:,:,155))
  call Hloop_Q_A(ntryL,G1H4(1),19,nMB,G2H4(56),n2h4(155))
  call Hloop_QV_A(ntryL,G1H16(20),wf4(:,5),G1H4(1),m3h4x4(:,20),heltab2x16(:,:,156))
  call Hloop_Q_A(ntryL,G1H4(1),19,nMB,G2H4(57),n2h4(156))
  call Hloop_QV_A(ntryL,G1H16(21),wf4(:,5),G1H4(1),m3h4x4(:,21),heltab2x16(:,:,157))
  call Hloop_Q_A(ntryL,G1H4(1),19,nMT,G2H4(58),n2h4(157))
  call Hloop_QZ_A(ntryL,G1H16(22),wf4(:,6),G1H4(1),ngZd,m3h4x4(:,22),heltab2x16(:,:,158))
  call Hloop_Q_A(ntryL,G1H4(1),19,nMB,G2H4(60),n2h4(158))
  call Hloop_QZ_A(ntryL,G1H16(23),wf4(:,6),G1H4(1),ngZd,m3h4x4(:,23),heltab2x16(:,:,159))
  call Hloop_Q_A(ntryL,G1H4(1),19,nMB,G2H4(70),n2h4(159))
  call Hloop_QZ_A(ntryL,G1H16(24),wf4(:,6),G1H4(1),ngZu,m3h4x4(:,24),heltab2x16(:,:,160))
  call Hloop_Q_A(ntryL,G1H4(1),19,nMT,G2H4(71),n2h4(160))
  call Hloop_AS_Q(ntryL,G1H16(25),wf4(:,1),G1H4(1),ngH,m3h4x4(:,25),heltab2x16(:,:,161))
  call Hloop_A_Q(ntryL,G1H4(1),19,nMB,G2H4(72),n2h4(161))
  call Hloop_AS_Q(ntryL,G1H16(26),wf4(:,1),G1H4(1),ngH,m3h4x4(:,26),heltab2x16(:,:,162))
  call Hloop_A_Q(ntryL,G1H4(1),19,nMB,G2H4(77),n2h4(162))
  call Hloop_AS_Q(ntryL,G1H16(27),wf4(:,1),G1H4(1),ngH,m3h4x4(:,27),heltab2x16(:,:,163))
  call Hloop_A_Q(ntryL,G1H4(1),19,nMT,G2H4(78),n2h4(163))
  call Hloop_AS_Q(ntryL,G1H16(28),wf4(:,4),G1H4(1),ngX,m3h4x4(:,28),heltab2x16(:,:,164))
  call Hloop_A_Q(ntryL,G1H4(1),19,nMB,G2H4(80),n2h4(164))
  call Hloop_AS_Q(ntryL,G1H16(29),wf4(:,4),G1H4(1),ngX,m3h4x4(:,29),heltab2x16(:,:,165))
  call Hloop_A_Q(ntryL,G1H4(1),19,nMB,G2H4(86),n2h4(165))
  call Hloop_AS_Q(ntryL,G1H16(30),wf4(:,4),G1H4(1),ngX,m3h4x4(:,30),heltab2x16(:,:,166))
  call Hloop_A_Q(ntryL,G1H4(1),19,nMT,G2H4(87),n2h4(166))
  call Hloop_AS_Q(ntryL,G1H16(31),wf4(:,1),G1H4(1),ngH,m3h4x4(:,31),heltab2x16(:,:,167))
  call Hloop_A_Q(ntryL,G1H4(1),19,nMB,G2H4(88),n2h4(167))
  call Hloop_AS_Q(ntryL,G1H16(32),wf4(:,1),G1H4(1),ngH,m3h4x4(:,32),heltab2x16(:,:,168))
  call Hloop_A_Q(ntryL,G1H4(1),19,nMB,G2H4(89),n2h4(168))
  call Hloop_AS_Q(ntryL,G1H16(33),wf4(:,1),G1H4(1),ngH,m3h4x4(:,33),heltab2x16(:,:,169))
  call Hloop_A_Q(ntryL,G1H4(1),19,nMT,G2H4(90),n2h4(169))
  call Hloop_AS_Q(ntryL,G1H16(34),wf4(:,4),G1H4(1),ngX,m3h4x4(:,34),heltab2x16(:,:,170))
  call Hloop_A_Q(ntryL,G1H4(1),19,nMB,G2H4(92),n2h4(170))
  call Hloop_AS_Q(ntryL,G1H16(35),wf4(:,4),G1H4(1),ngX,m3h4x4(:,35),heltab2x16(:,:,171))
  call Hloop_A_Q(ntryL,G1H4(1),19,nMB,G2H4(103),n2h4(171))
  call Hloop_AS_Q(ntryL,G1H16(36),wf4(:,4),G1H4(1),ngX,m3h4x4(:,36),heltab2x16(:,:,172))
  call Hloop_A_Q(ntryL,G1H4(1),19,nMT,G2H4(104),n2h4(172))
  call Hloop_AV_Q(ntryL,G1H16(37),wf4(:,5),G1H4(1),m3h4x4(:,37),heltab2x16(:,:,173))
  call Hloop_A_Q(ntryL,G1H4(1),19,nMB,G2H4(105),n2h4(173))
  call Hloop_AV_Q(ntryL,G1H16(38),wf4(:,5),G1H4(1),m3h4x4(:,38),heltab2x16(:,:,174))
  call Hloop_A_Q(ntryL,G1H4(1),19,nMB,G2H4(107),n2h4(174))
  call Hloop_AV_Q(ntryL,G1H16(39),wf4(:,5),G1H4(1),m3h4x4(:,39),heltab2x16(:,:,175))
  call Hloop_A_Q(ntryL,G1H4(1),19,nMT,G2H4(109),n2h4(175))
  call Hloop_AZ_Q(ntryL,G1H16(40),wf4(:,6),G1H4(1),ngZd,m3h4x4(:,40),heltab2x16(:,:,176))
  call Hloop_A_Q(ntryL,G1H4(1),19,nMB,G2H4(110),n2h4(176))
  call Hloop_AZ_Q(ntryL,G1H16(41),wf4(:,6),G1H4(1),ngZd,m3h4x4(:,41),heltab2x16(:,:,177))
  call Hloop_A_Q(ntryL,G1H4(1),19,nMB,G2H4(123),n2h4(177))
  call Hloop_AZ_Q(ntryL,G1H16(42),wf4(:,6),G1H4(1),ngZu,m3h4x4(:,42),heltab2x16(:,:,178))
  call Hloop_A_Q(ntryL,G1H4(1),19,nMT,G2H4(124),n2h4(178))
  call Hloop_AV_Q(ntryL,G1H16(43),wf4(:,5),G1H4(1),m3h4x4(:,43),heltab2x16(:,:,179))
  call Hloop_A_Q(ntryL,G1H4(1),19,nMB,G2H4(126),n2h4(179))
  call Hloop_AV_Q(ntryL,G1H16(44),wf4(:,5),G1H4(1),m3h4x4(:,44),heltab2x16(:,:,180))
  call Hloop_A_Q(ntryL,G1H4(1),19,nMB,G2H4(128),n2h4(180))
  call Hloop_AV_Q(ntryL,G1H16(45),wf4(:,5),G1H4(1),m3h4x4(:,45),heltab2x16(:,:,181))
  call Hloop_A_Q(ntryL,G1H4(1),19,nMT,G2H4(1),n2h4(181))
  call Hloop_AZ_Q(ntryL,G1H16(46),wf4(:,6),G1H4(1),ngZd,m3h4x4(:,46),heltab2x16(:,:,182))
  call Hloop_A_Q(ntryL,G1H4(1),19,nMB,G2H4(2),n2h4(182))
  call Hloop_AZ_Q(ntryL,G1H16(47),wf4(:,6),G1H4(1),ngZd,m3h4x4(:,47),heltab2x16(:,:,183))
  call Hloop_A_Q(ntryL,G1H4(1),19,nMB,G2H4(13),n2h4(183))
  call Hloop_AZ_Q(ntryL,G1H16(48),wf4(:,6),G1H4(1),ngZu,m3h4x4(:,48),heltab2x16(:,:,184))
  call Hloop_A_Q(ntryL,G1H4(1),19,nMT,G2H4(14),n2h4(184))
  call Hloop_AQ_S(ntryL,G1H16(49),ex3(:),G1H8(137),ngH,m3h2x8(:,137),heltab2x16(:,:,185))
  call Hloop_AQ_S(ntryL,G1H16(50),ex3(:),G1H8(138),ngX,m3h2x8(:,138),heltab2x16(:,:,186))
  call Hloop_AQ_S(ntryL,G1H16(51),ex3(:),G1H8(139),ngPtb,m3h2x8(:,139),heltab2x16(:,:,187))
  call Hloop_AQ_S(ntryL,G1H16(52),ex3(:),G1H8(140),ngH,m3h2x8(:,140),heltab2x16(:,:,188))
  call Hloop_AQ_S(ntryL,G1H16(53),ex3(:),G1H8(141),ngX,m3h2x8(:,141),heltab2x16(:,:,189))
  call Hloop_AQ_S(ntryL,G1H16(54),ex3(:),G1H8(142),ngX,m3h2x8(:,142),heltab2x16(:,:,190))
  call Hloop_AQ_S(ntryL,G1H16(55),ex3(:),G1H8(143),ngPtb,m3h2x8(:,143),heltab2x16(:,:,191))
  call Hloop_AQ_S(ntryL,G1H16(56),ex3(:),G1H8(144),ngH,m3h2x8(:,144),heltab2x16(:,:,192))
  call Hloop_AQ_S(ntryL,G1H16(57),ex3(:),G1H8(145),ngPtb,m3h2x8(:,145),heltab2x16(:,:,193))
  call Hloop_AQ_Z(ntryL,G1H16(58),ex3(:),G1H8(146),ngZd,m3h2x8(:,146),heltab2x16(:,:,194))
  call Hloop_AQ_W(ntryL,G1H16(59),ex3(:),G1H8(147),m3h2x8(:,147),heltab2x16(:,:,195))
  call Hloop_AQ_Z(ntryL,G1H16(60),ex3(:),G1H8(148),ngZd,m3h2x8(:,148),heltab2x16(:,:,196))
  call Hloop_AQ_W(ntryL,G1H16(61),ex3(:),G1H8(149),m3h2x8(:,149),heltab2x16(:,:,197))
  call Hloop_AQ_Z(ntryL,G1H16(62),ex3(:),G1H8(150),ngZd,m3h2x8(:,150),heltab2x16(:,:,198))
  call Hloop_AQ_W(ntryL,G1H16(63),ex3(:),G1H8(151),m3h2x8(:,151),heltab2x16(:,:,199))
  call Hloop_AQ_S(ntryL,G1H16(64),ex3(:),G1H8(152),ngPtb,m3h2x8(:,152),heltab2x16(:,:,200))
  call Hloop_AQ_S(ntryL,G1H16(65),ex3(:),G1H8(153),ngH,m3h2x8(:,153),heltab2x16(:,:,201))
  call Hloop_AQ_S(ntryL,G1H16(66),ex3(:),G1H8(154),ngX,m3h2x8(:,154),heltab2x16(:,:,202))
  call Hloop_AQ_S(ntryL,G1H16(67),ex3(:),G1H8(155),ngPtb,m3h2x8(:,155),heltab2x16(:,:,203))
  call Hloop_AQ_S(ntryL,G1H16(68),ex3(:),G1H8(156),ngPtb,m3h2x8(:,156),heltab2x16(:,:,204))
  call Hloop_AQ_S(ntryL,G1H16(69),ex3(:),G1H8(157),ngH,m3h2x8(:,157),heltab2x16(:,:,205))
  call Hloop_AQ_S(ntryL,G1H16(70),ex3(:),G1H8(158),ngPtb,m3h2x8(:,158),heltab2x16(:,:,206))
  call Hloop_AQ_W(ntryL,G1H16(71),ex3(:),G1H8(159),m3h2x8(:,159),heltab2x16(:,:,207))
  call Hloop_AQ_Z(ntryL,G1H16(72),ex3(:),G1H8(160),ngZd,m3h2x8(:,160),heltab2x16(:,:,208))
  call Hloop_AQ_W(ntryL,G1H16(73),ex3(:),G1H8(161),m3h2x8(:,161),heltab2x16(:,:,209))
  call Hloop_AQ_W(ntryL,G1H16(74),ex3(:),G1H8(162),m3h2x8(:,162),heltab2x16(:,:,210))
  call Hloop_AQ_W(ntryL,G1H16(75),ex3(:),G1H8(163),m3h2x8(:,163),heltab2x16(:,:,211))
  call Hloop_AQ_S(ntryL,G1H16(76),ex1(:),G1H8(164),ngH,m3h2x8(:,164),heltab2x16(:,:,212))
  call Hloop_AQ_S(ntryL,G1H16(77),ex1(:),G1H8(165),ngX,m3h2x8(:,165),heltab2x16(:,:,213))
  call Hloop_AQ_V(ntryL,G1H16(78),ex1(:),G1H8(166),m3h2x8(:,166),heltab2x16(:,:,214))
  call Hloop_AQ_Z(ntryL,G1H16(79),ex1(:),G1H8(167),ngZu,m3h2x8(:,167),heltab2x16(:,:,215))
  call Hloop_AQ_S(ntryL,G1H16(80),ex1(:),G1H8(168),ngH,m3h2x8(:,168),heltab2x16(:,:,216))
  call Hloop_AQ_S(ntryL,G1H16(81),ex1(:),G1H8(169),ngX,m3h2x8(:,169),heltab2x16(:,:,217))
  call Hloop_AQ_V(ntryL,G1H16(82),ex1(:),G1H8(170),m3h2x8(:,170),heltab2x16(:,:,218))
  call Hloop_AQ_Z(ntryL,G1H16(83),ex1(:),G1H8(171),ngZu,m3h2x8(:,171),heltab2x16(:,:,219))
  call Hloop_AS_Q(ntryL,G1H16(84),wf4(:,10),G1H4(1),ngPbt,m3h4x4(:,49),heltab2x16(:,:,220))
  call Hloop_A_Q(ntryL,G1H4(1),22,nMT,G2H4(15),n2h4(185))
  call Hloop_AS_Q(ntryL,G1H16(85),wf4(:,10),G1H4(1),ngPbt,m3h4x4(:,50),heltab2x16(:,:,221))
  call Hloop_A_Q(ntryL,G1H4(1),22,nMT,G2H4(6),n2h4(186))
  call Hloop_AS_Q(ntryL,G1H16(86),wf4(:,10),G1H4(1),ngPbt,m3h4x4(:,51),heltab2x16(:,:,222))
  call Hloop_A_Q(ntryL,G1H4(1),22,nMT,G2H4(18),n2h4(187))
  call Hloop_AS_Q(ntryL,G1H16(87),wf4(:,10),G1H4(1),ngPbt,m3h4x4(:,52),heltab2x16(:,:,223))
  call Hloop_A_Q(ntryL,G1H4(1),22,nMT,G2H4(8),n2h4(188))
  call Hloop_AW_Q(ntryL,G1H16(88),wf4(:,12),G1H4(1),m3h4x4(:,53),heltab2x16(:,:,224))
  call Hloop_A_Q(ntryL,G1H4(1),22,nMT,G2H4(19),n2h4(189))
  call Hloop_AW_Q(ntryL,G1H16(89),wf4(:,12),G1H4(1),m3h4x4(:,54),heltab2x16(:,:,225))
  call Hloop_A_Q(ntryL,G1H4(1),22,nMT,G2H4(20),n2h4(190))
  call Hloop_AW_Q(ntryL,G1H16(90),wf4(:,12),G1H4(1),m3h4x4(:,55),heltab2x16(:,:,226))
  call Hloop_A_Q(ntryL,G1H4(1),22,nMT,G2H4(11),n2h4(191))
  call Hloop_AW_Q(ntryL,G1H16(91),wf4(:,12),G1H4(1),m3h4x4(:,56),heltab2x16(:,:,227))
  call Hloop_A_Q(ntryL,G1H4(1),22,nMT,G2H4(12),n2h4(192))
  call Hloop_AQ_S(ntryL,G1H16(92),ex1(:),G1H8(172),ngH,m3h2x8(:,172),heltab2x16(:,:,228))
  call Hloop_AQ_S(ntryL,G1H16(93),ex1(:),G1H8(173),ngPbt,m3h2x8(:,173),heltab2x16(:,:,229))
  call Hloop_AQ_S(ntryL,G1H16(94),ex1(:),G1H8(174),ngPbt,m3h2x8(:,174),heltab2x16(:,:,230))
  call Hloop_AQ_S(ntryL,G1H16(95),ex1(:),G1H8(175),ngPbt,m3h2x8(:,175),heltab2x16(:,:,231))
  call Hloop_AQ_S(ntryL,G1H16(96),ex1(:),G1H8(176),ngH,m3h2x8(:,176),heltab2x16(:,:,232))
  call Hloop_AQ_S(ntryL,G1H16(97),ex1(:),G1H8(177),ngX,m3h2x8(:,177),heltab2x16(:,:,233))
  call Hloop_AQ_V(ntryL,G1H16(98),ex1(:),G1H8(178),m3h2x8(:,178),heltab2x16(:,:,234))
  call Hloop_AQ_Z(ntryL,G1H16(99),ex1(:),G1H8(179),ngZu,m3h2x8(:,179),heltab2x16(:,:,235))
  call Hloop_AQ_W(ntryL,G1H16(100),ex1(:),G1H8(180),m3h2x8(:,180),heltab2x16(:,:,236))
  call Hloop_AQ_W(ntryL,G1H16(101),ex1(:),G1H8(181),m3h2x8(:,181),heltab2x16(:,:,237))
  call Hloop_AQ_V(ntryL,G1H16(102),ex1(:),G1H8(182),m3h2x8(:,182),heltab2x16(:,:,238))
  call Hloop_AQ_W(ntryL,G1H16(103),ex1(:),G1H8(183),m3h2x8(:,183),heltab2x16(:,:,239))
  call Hloop_AQ_Z(ntryL,G1H16(104),ex1(:),G1H8(184),ngZu,m3h2x8(:,184),heltab2x16(:,:,240))
  call Hloop_AQ_W(ntryL,G1H16(105),ex1(:),G1H8(185),m3h2x8(:,185),heltab2x16(:,:,241))
  call Hloop_AQ_S(ntryL,G1H16(106),ex1(:),G1H8(186),ngH,m3h2x8(:,186),heltab2x16(:,:,242))
  call Hloop_AQ_S(ntryL,G1H16(107),ex1(:),G1H8(187),ngPbt,m3h2x8(:,187),heltab2x16(:,:,243))
  call Hloop_AQ_S(ntryL,G1H16(108),ex1(:),G1H8(188),ngX,m3h2x8(:,188),heltab2x16(:,:,244))
  call Hloop_AQ_S(ntryL,G1H16(109),ex1(:),G1H8(189),ngPbt,m3h2x8(:,189),heltab2x16(:,:,245))
  call Hloop_AQ_S(ntryL,G1H16(110),ex1(:),G1H8(190),ngPbt,m3h2x8(:,190),heltab2x16(:,:,246))
  call Hloop_AQ_S(ntryL,G1H16(111),ex1(:),G1H8(191),ngPbt,m3h2x8(:,191),heltab2x16(:,:,247))
  call Hloop_AQ_S(ntryL,G1H16(112),ex1(:),G1H8(192),ngH,m3h2x8(:,192),heltab2x16(:,:,248))
  call Hloop_AQ_V(ntryL,G1H16(113),ex1(:),G1H8(193),m3h2x8(:,193),heltab2x16(:,:,249))
  call Hloop_AQ_Z(ntryL,G1H16(114),ex1(:),G1H8(194),ngZu,m3h2x8(:,194),heltab2x16(:,:,250))
  call Hloop_AQ_W(ntryL,G1H16(115),ex1(:),G1H8(195),m3h2x8(:,195),heltab2x16(:,:,251))
  call Hloop_AQ_V(ntryL,G1H16(116),ex1(:),G1H8(196),m3h2x8(:,196),heltab2x16(:,:,252))
  call Hloop_AQ_W(ntryL,G1H16(117),ex1(:),G1H8(197),m3h2x8(:,197),heltab2x16(:,:,253))
  call Hloop_AQ_Z(ntryL,G1H16(118),ex1(:),G1H8(198),ngZu,m3h2x8(:,198),heltab2x16(:,:,254))
  call Hloop_AQ_W(ntryL,G1H16(119),ex1(:),G1H8(199),m3h2x8(:,199),heltab2x16(:,:,255))
  call Hloop_QA_S(ntryL,G1H16(120),ex2(:),G1H8(200),ngH,m3h2x8(:,200),heltab2x16(:,:,256))
  call Hloop_QA_S(ntryL,G1H16(121),ex2(:),G1H8(201),ngX,m3h2x8(:,201),heltab2x16(:,:,257))
  call Hloop_QA_V(ntryL,G1H16(122),ex2(:),G1H8(202),m3h2x8(:,202),heltab2x16(:,:,258))
  call Hloop_QA_Z(ntryL,G1H16(123),ex2(:),G1H8(203),ngZu,m3h2x8(:,203),heltab2x16(:,:,259))
  call Hloop_QA_S(ntryL,G1H16(124),ex2(:),G1H8(204),ngH,m3h2x8(:,204),heltab2x16(:,:,260))
  call Hloop_QA_S(ntryL,G1H16(125),ex2(:),G1H8(205),ngX,m3h2x8(:,205),heltab2x16(:,:,261))
  call Hloop_QA_V(ntryL,G1H16(126),ex2(:),G1H8(206),m3h2x8(:,206),heltab2x16(:,:,262))
  call Hloop_QA_Z(ntryL,G1H16(127),ex2(:),G1H8(207),ngZu,m3h2x8(:,207),heltab2x16(:,:,263))
  call Hloop_AQ_S(ntryL,G1H16(128),ex3(:),G1H8(208),ngH,m3h2x8(:,208),heltab2x16(:,:,264))
  call Hloop_AQ_S(ntryL,G1H16(129),ex3(:),G1H8(209),ngX,m3h2x8(:,209),heltab2x16(:,:,265))
  call Hloop_AQ_V(ntryL,G1H16(130),ex3(:),G1H8(210),m3h2x8(:,210),heltab2x16(:,:,266))
  call Hloop_AQ_Z(ntryL,G1H16(131),ex3(:),G1H8(211),ngZd,m3h2x8(:,211),heltab2x16(:,:,267))
  call Hloop_AQ_S(ntryL,G1H16(132),ex3(:),G1H8(212),ngH,m3h2x8(:,212),heltab2x16(:,:,268))
  call Hloop_AQ_S(ntryL,G1H16(133),ex3(:),G1H8(213),ngX,m3h2x8(:,213),heltab2x16(:,:,269))
  call Hloop_AQ_V(ntryL,G1H16(134),ex3(:),G1H8(214),m3h2x8(:,214),heltab2x16(:,:,270))
  call Hloop_AQ_Z(ntryL,G1H16(135),ex3(:),G1H8(215),ngZd,m3h2x8(:,215),heltab2x16(:,:,271))
  call Hloop_QA_S(ntryL,G1H16(136),ex2(:),G1H8(216),ngH,m3h2x8(:,216),heltab2x16(:,:,272))
  call Hloop_QA_S(ntryL,G1H16(137),ex2(:),G1H8(217),ngPtb,m3h2x8(:,217),heltab2x16(:,:,273))
  call Hloop_QA_S(ntryL,G1H16(138),ex2(:),G1H8(218),ngPtb,m3h2x8(:,218),heltab2x16(:,:,274))
  call Hloop_QA_S(ntryL,G1H16(139),ex2(:),G1H8(219),ngPtb,m3h2x8(:,219),heltab2x16(:,:,275))
  call Hloop_QA_S(ntryL,G1H16(140),ex2(:),G1H8(220),ngH,m3h2x8(:,220),heltab2x16(:,:,276))
  call Hloop_QA_S(ntryL,G1H16(141),ex2(:),G1H8(221),ngX,m3h2x8(:,221),heltab2x16(:,:,277))
  call Hloop_QA_V(ntryL,G1H16(142),ex2(:),G1H8(222),m3h2x8(:,222),heltab2x16(:,:,278))
  call Hloop_QA_Z(ntryL,G1H16(143),ex2(:),G1H8(223),ngZu,m3h2x8(:,223),heltab2x16(:,:,279))
  call Hloop_QA_W(ntryL,G1H16(144),ex2(:),G1H8(224),m3h2x8(:,224),heltab2x16(:,:,280))
  call Hloop_QA_W(ntryL,G1H16(145),ex2(:),G1H8(225),m3h2x8(:,225),heltab2x16(:,:,281))
  call Hloop_QA_V(ntryL,G1H16(146),ex2(:),G1H8(226),m3h2x8(:,226),heltab2x16(:,:,282))
  call Hloop_QA_W(ntryL,G1H16(147),ex2(:),G1H8(227),m3h2x8(:,227),heltab2x16(:,:,283))
  call Hloop_QA_Z(ntryL,G1H16(148),ex2(:),G1H8(228),ngZu,m3h2x8(:,228),heltab2x16(:,:,284))
  call Hloop_QA_W(ntryL,G1H16(149),ex2(:),G1H8(229),m3h2x8(:,229),heltab2x16(:,:,285))
  call Hloop_QA_S(ntryL,G1H16(150),ex2(:),G1H8(230),ngH,m3h2x8(:,230),heltab2x16(:,:,286))
  call Hloop_QA_S(ntryL,G1H16(151),ex2(:),G1H8(231),ngPtb,m3h2x8(:,231),heltab2x16(:,:,287))
  call Hloop_QA_S(ntryL,G1H16(152),ex2(:),G1H8(232),ngX,m3h2x8(:,232),heltab2x16(:,:,288))
  call Hloop_QA_S(ntryL,G1H16(153),ex2(:),G1H8(233),ngPtb,m3h2x8(:,233),heltab2x16(:,:,289))
  call Hloop_QA_S(ntryL,G1H16(154),ex2(:),G1H8(234),ngPtb,m3h2x8(:,234),heltab2x16(:,:,290))
  call Hloop_QA_S(ntryL,G1H16(155),ex2(:),G1H8(235),ngPtb,m3h2x8(:,235),heltab2x16(:,:,291))
  call Hloop_QA_S(ntryL,G1H16(156),ex2(:),G1H8(236),ngH,m3h2x8(:,236),heltab2x16(:,:,292))
  call Hloop_QA_V(ntryL,G1H16(157),ex2(:),G1H8(237),m3h2x8(:,237),heltab2x16(:,:,293))
  call Hloop_QA_Z(ntryL,G1H16(158),ex2(:),G1H8(238),ngZu,m3h2x8(:,238),heltab2x16(:,:,294))
  call Hloop_QA_W(ntryL,G1H16(159),ex2(:),G1H8(239),m3h2x8(:,239),heltab2x16(:,:,295))
  call Hloop_QA_V(ntryL,G1H16(160),ex2(:),G1H8(240),m3h2x8(:,240),heltab2x16(:,:,296))
  call Hloop_QA_W(ntryL,G1H16(161),ex2(:),G1H8(241),m3h2x8(:,241),heltab2x16(:,:,297))
  call Hloop_QA_Z(ntryL,G1H16(162),ex2(:),G1H8(242),ngZu,m3h2x8(:,242),heltab2x16(:,:,298))
  call Hloop_QA_W(ntryL,G1H16(163),ex2(:),G1H8(243),m3h2x8(:,243),heltab2x16(:,:,299))
  call Hloop_AQ_S(ntryL,G1H16(164),ex1(:),G1H8(244),ngH,m3h2x8(:,244),heltab2x16(:,:,300))
  call Hloop_AQ_S(ntryL,G1H16(165),ex1(:),G1H8(245),ngX,m3h2x8(:,245),heltab2x16(:,:,301))
  call Hloop_AQ_S(ntryL,G1H16(166),ex1(:),G1H8(246),ngPbt,m3h2x8(:,246),heltab2x16(:,:,302))
  call Hloop_AQ_S(ntryL,G1H16(167),ex1(:),G1H8(247),ngH,m3h2x8(:,247),heltab2x16(:,:,303))
  call Hloop_AQ_S(ntryL,G1H16(168),ex1(:),G1H8(248),ngX,m3h2x8(:,248),heltab2x16(:,:,304))
  call Hloop_AQ_S(ntryL,G1H16(169),ex1(:),G1H8(249),ngPbt,m3h2x8(:,249),heltab2x16(:,:,305))
  call Hloop_AQ_V(ntryL,G1H16(170),ex1(:),G1H8(250),m3h2x8(:,250),heltab2x16(:,:,306))
  call Hloop_AQ_Z(ntryL,G1H16(171),ex1(:),G1H8(251),ngZu,m3h2x8(:,251),heltab2x16(:,:,307))
  call Hloop_AQ_W(ntryL,G1H16(172),ex1(:),G1H8(252),m3h2x8(:,252),heltab2x16(:,:,308))
  call Hloop_AQ_V(ntryL,G1H16(173),ex1(:),G1H8(253),m3h2x8(:,253),heltab2x16(:,:,309))
  call Hloop_AQ_Z(ntryL,G1H16(174),ex1(:),G1H8(254),ngZu,m3h2x8(:,254),heltab2x16(:,:,310))
  call Hloop_AQ_W(ntryL,G1H16(175),ex1(:),G1H8(255),m3h2x8(:,255),heltab2x16(:,:,311))
  call Hloop_AQ_S(ntryL,G1H16(176),ex1(:),G1H8(256),ngH,m3h2x8(:,256),heltab2x16(:,:,312))
  call Hloop_AQ_S(ntryL,G1H16(177),ex1(:),G1H8(257),ngX,m3h2x8(:,257),heltab2x16(:,:,313))
  call Hloop_AQ_S(ntryL,G1H16(178),ex1(:),G1H8(258),ngPbt,m3h2x8(:,258),heltab2x16(:,:,314))
  call Hloop_AQ_S(ntryL,G1H16(179),ex1(:),G1H8(259),ngH,m3h2x8(:,259),heltab2x16(:,:,315))
  call Hloop_AQ_S(ntryL,G1H16(180),ex1(:),G1H8(260),ngX,m3h2x8(:,260),heltab2x16(:,:,316))
  call Hloop_AQ_S(ntryL,G1H16(181),ex1(:),G1H8(261),ngPbt,m3h2x8(:,261),heltab2x16(:,:,317))
  call Hloop_AQ_V(ntryL,G1H16(182),ex1(:),G1H8(262),m3h2x8(:,262),heltab2x16(:,:,318))
  call Hloop_AQ_Z(ntryL,G1H16(183),ex1(:),G1H8(263),ngZu,m3h2x8(:,263),heltab2x16(:,:,319))
  call Hloop_AQ_W(ntryL,G1H16(184),ex1(:),G1H8(264),m3h2x8(:,264),heltab2x16(:,:,320))
  call Hloop_AQ_V(ntryL,G1H16(185),ex1(:),G1H8(265),m3h2x8(:,265),heltab2x16(:,:,321))
  call Hloop_AQ_Z(ntryL,G1H16(186),ex1(:),G1H8(266),ngZu,m3h2x8(:,266),heltab2x16(:,:,322))
  call Hloop_AQ_W(ntryL,G1H16(187),ex1(:),G1H8(267),m3h2x8(:,267),heltab2x16(:,:,323))
  call Hloop_QA_S(ntryL,G1H16(188),ex2(:),G1H8(268),ngH,m3h2x8(:,268),heltab2x16(:,:,324))
  call Hloop_QA_S(ntryL,G1H16(189),ex2(:),G1H8(269),ngX,m3h2x8(:,269),heltab2x16(:,:,325))
  call Hloop_QA_S(ntryL,G1H16(190),ex2(:),G1H8(270),ngPtb,m3h2x8(:,270),heltab2x16(:,:,326))
  call Hloop_QA_S(ntryL,G1H16(191),ex2(:),G1H8(271),ngH,m3h2x8(:,271),heltab2x16(:,:,327))
  call Hloop_QA_S(ntryL,G1H16(192),ex2(:),G1H8(272),ngX,m3h2x8(:,272),heltab2x16(:,:,328))
  call Hloop_QA_S(ntryL,G1H16(193),ex2(:),G1H8(273),ngPtb,m3h2x8(:,273),heltab2x16(:,:,329))
  call Hloop_QA_V(ntryL,G1H16(194),ex2(:),G1H8(274),m3h2x8(:,274),heltab2x16(:,:,330))
  call Hloop_QA_Z(ntryL,G1H16(195),ex2(:),G1H8(275),ngZu,m3h2x8(:,275),heltab2x16(:,:,331))
  call Hloop_QA_W(ntryL,G1H16(196),ex2(:),G1H8(276),m3h2x8(:,276),heltab2x16(:,:,332))
  call Hloop_QA_V(ntryL,G1H16(197),ex2(:),G1H8(277),m3h2x8(:,277),heltab2x16(:,:,333))
  call Hloop_QA_Z(ntryL,G1H16(198),ex2(:),G1H8(278),ngZu,m3h2x8(:,278),heltab2x16(:,:,334))
  call Hloop_QA_W(ntryL,G1H16(199),ex2(:),G1H8(279),m3h2x8(:,279),heltab2x16(:,:,335))
  call Hloop_QA_S(ntryL,G1H16(200),ex2(:),G1H8(280),ngH,m3h2x8(:,280),heltab2x16(:,:,336))
  call Hloop_QA_S(ntryL,G1H16(201),ex2(:),G1H8(281),ngX,m3h2x8(:,281),heltab2x16(:,:,337))
  call Hloop_QA_S(ntryL,G1H16(202),ex2(:),G1H8(282),ngPtb,m3h2x8(:,282),heltab2x16(:,:,338))
  call Hloop_QA_S(ntryL,G1H16(203),ex2(:),G1H8(283),ngH,m3h2x8(:,283),heltab2x16(:,:,339))
  call Hloop_QA_S(ntryL,G1H16(204),ex2(:),G1H8(284),ngX,m3h2x8(:,284),heltab2x16(:,:,340))
  call Hloop_QA_S(ntryL,G1H16(205),ex2(:),G1H8(285),ngPtb,m3h2x8(:,285),heltab2x16(:,:,341))
  call Hloop_QA_V(ntryL,G1H16(206),ex2(:),G1H8(286),m3h2x8(:,286),heltab2x16(:,:,342))
  call Hloop_QA_Z(ntryL,G1H16(207),ex2(:),G1H8(287),ngZu,m3h2x8(:,287),heltab2x16(:,:,343))
  call Hloop_QA_W(ntryL,G1H16(208),ex2(:),G1H8(288),m3h2x8(:,288),heltab2x16(:,:,344))
  call Hloop_QA_V(ntryL,G1H16(209),ex2(:),G1H8(289),m3h2x8(:,289),heltab2x16(:,:,345))
  call Hloop_QA_Z(ntryL,G1H16(210),ex2(:),G1H8(290),ngZu,m3h2x8(:,290),heltab2x16(:,:,346))
  call Hloop_QA_W(ntryL,G1H16(211),ex2(:),G1H8(291),m3h2x8(:,291),heltab2x16(:,:,347))
  call Hloop_AQ_S(ntryL,G1H16(212),ex1(:),G1H8(292),ngH,m3h2x8(:,292),heltab2x16(:,:,348))
  call Hloop_AQ_S(ntryL,G1H16(213),ex1(:),G1H8(293),ngX,m3h2x8(:,293),heltab2x16(:,:,349))
  call Hloop_AQ_S(ntryL,G1H16(214),ex1(:),G1H8(294),ngPbt,m3h2x8(:,294),heltab2x16(:,:,350))
  call Hloop_AQ_S(ntryL,G1H16(215),ex1(:),G1H8(295),ngH,m3h2x8(:,295),heltab2x16(:,:,351))
  call Hloop_AQ_S(ntryL,G1H16(216),ex1(:),G1H8(296),ngX,m3h2x8(:,296),heltab2x16(:,:,352))
  call Hloop_AQ_S(ntryL,G1H16(217),ex1(:),G1H8(297),ngX,m3h2x8(:,297),heltab2x16(:,:,353))
  call Hloop_AQ_S(ntryL,G1H16(218),ex1(:),G1H8(298),ngPbt,m3h2x8(:,298),heltab2x16(:,:,354))
  call Hloop_AQ_S(ntryL,G1H16(219),ex1(:),G1H8(299),ngH,m3h2x8(:,299),heltab2x16(:,:,355))
  call Hloop_AQ_S(ntryL,G1H16(220),ex1(:),G1H8(300),ngPbt,m3h2x8(:,300),heltab2x16(:,:,356))
  call Hloop_AQ_Z(ntryL,G1H16(221),ex1(:),G1H8(301),ngZu,m3h2x8(:,301),heltab2x16(:,:,357))
  call Hloop_AQ_W(ntryL,G1H16(222),ex1(:),G1H8(302),m3h2x8(:,302),heltab2x16(:,:,358))
  call Hloop_AQ_Z(ntryL,G1H16(223),ex1(:),G1H8(303),ngZu,m3h2x8(:,303),heltab2x16(:,:,359))
  call Hloop_AQ_W(ntryL,G1H16(224),ex1(:),G1H8(304),m3h2x8(:,304),heltab2x16(:,:,360))
  call Hloop_AQ_Z(ntryL,G1H16(225),ex1(:),G1H8(305),ngZu,m3h2x8(:,305),heltab2x16(:,:,361))
  call Hloop_AQ_W(ntryL,G1H16(226),ex1(:),G1H8(306),m3h2x8(:,306),heltab2x16(:,:,362))
  call Hloop_AQ_S(ntryL,G1H16(227),ex1(:),G1H8(307),ngPbt,m3h2x8(:,307),heltab2x16(:,:,363))
  call Hloop_AQ_S(ntryL,G1H16(228),ex1(:),G1H8(308),ngH,m3h2x8(:,308),heltab2x16(:,:,364))
  call Hloop_AQ_S(ntryL,G1H16(229),ex1(:),G1H8(309),ngX,m3h2x8(:,309),heltab2x16(:,:,365))
  call Hloop_AQ_S(ntryL,G1H16(230),ex1(:),G1H8(310),ngPbt,m3h2x8(:,310),heltab2x16(:,:,366))
  call Hloop_AQ_S(ntryL,G1H16(231),ex1(:),G1H8(311),ngPbt,m3h2x8(:,311),heltab2x16(:,:,367))
  call Hloop_AQ_S(ntryL,G1H16(232),ex1(:),G1H8(312),ngH,m3h2x8(:,312),heltab2x16(:,:,368))
  call Hloop_AQ_S(ntryL,G1H16(233),ex1(:),G1H8(313),ngPbt,m3h2x8(:,313),heltab2x16(:,:,369))
  call Hloop_AQ_W(ntryL,G1H16(234),ex1(:),G1H8(314),m3h2x8(:,314),heltab2x16(:,:,370))
  call Hloop_AQ_Z(ntryL,G1H16(235),ex1(:),G1H8(315),ngZu,m3h2x8(:,315),heltab2x16(:,:,371))
  call Hloop_AQ_W(ntryL,G1H16(236),ex1(:),G1H8(316),m3h2x8(:,316),heltab2x16(:,:,372))
  call Hloop_AQ_W(ntryL,G1H16(237),ex1(:),G1H8(317),m3h2x8(:,317),heltab2x16(:,:,373))
  call Hloop_AQ_W(ntryL,G1H16(238),ex1(:),G1H8(318),m3h2x8(:,318),heltab2x16(:,:,374))
  call Hloop_SQ_A(ntryL,G0H8(1),ex3(:),G0H4(1),ngPtb,m3h2x4(:,137),heltab2x8(:,:,137))
  call Hloop_Q_A(ntryL,G0H4(1),21,nMT,G1H4(1),n2h4(193))
  call Hloop_SQ_A(ntryL,G0H8(2),ex3(:),G0H4(1),ngH,m3h2x4(:,138),heltab2x8(:,:,138))
  call Hloop_Q_A(ntryL,G0H4(1),21,nMB,G1H4(2),n2h4(194))
  call Hloop_SQ_A(ntryL,G0H8(3),ex3(:),G0H4(1),ngPtb,m3h2x4(:,139),heltab2x8(:,:,139))
  call Hloop_Q_A(ntryL,G0H4(1),21,nMT,G1H4(3),n2h4(195))
  call Hloop_SQ_A(ntryL,G0H8(4),ex3(:),G0H4(1),ngX,m3h2x4(:,140),heltab2x8(:,:,140))
  call Hloop_Q_A(ntryL,G0H4(1),21,nMB,G1H4(4),n2h4(196))
  call Hloop_VQ_A(ntryL,G0H8(5),ex3(:),G0H4(1),m3h2x4(:,141),heltab2x8(:,:,141))
  call Hloop_Q_A(ntryL,G0H4(1),21,nMB,G1H4(5),n2h4(197))
  call Hloop_ZQ_A(ntryL,G0H8(6),ex3(:),G0H4(1),ngZd,m3h2x4(:,142),heltab2x8(:,:,142))
  call Hloop_Q_A(ntryL,G0H4(1),21,nMB,G1H4(6),n2h4(198))
  call Hloop_WQ_A(ntryL,G0H8(7),ex3(:),G0H4(1),m3h2x4(:,143),heltab2x8(:,:,143))
  call Hloop_Q_A(ntryL,G0H4(1),21,nMT,G1H4(7),n2h4(199))
  call Hloop_WQ_A(ntryL,G0H8(8),ex3(:),G0H4(1),m3h2x4(:,144),heltab2x8(:,:,144))
  call Hloop_Q_A(ntryL,G0H4(1),21,nMT,G1H4(8),n2h4(200))
  call Hloop_SQ_A(ntryL,G0H8(9),ex3(:),G0H4(1),ngPtb,m3h2x4(:,145),heltab2x8(:,:,145))
  call Hloop_Q_A(ntryL,G0H4(1),21,nMT,G1H4(9),n2h4(201))
  call Hloop_SQ_A(ntryL,G0H8(10),ex3(:),G0H4(1),ngPtb,m3h2x4(:,146),heltab2x8(:,:,146))
  call Hloop_Q_A(ntryL,G0H4(1),21,nMT,G1H4(10),n2h4(202))
  call Hloop_SQ_A(ntryL,G0H8(11),ex3(:),G0H4(1),ngH,m3h2x4(:,147),heltab2x8(:,:,147))
  call Hloop_Q_A(ntryL,G0H4(1),21,nMB,G1H4(11),n2h4(203))
  call Hloop_SQ_A(ntryL,G0H8(12),ex3(:),G0H4(1),ngX,m3h2x4(:,148),heltab2x8(:,:,148))
  call Hloop_Q_A(ntryL,G0H4(1),21,nMB,G1H4(12),n2h4(204))
  call Hloop_WQ_A(ntryL,G0H8(13),ex3(:),G0H4(1),m3h2x4(:,149),heltab2x8(:,:,149))
  call Hloop_Q_A(ntryL,G0H4(1),21,nMT,G1H4(13),n2h4(205))
  call Hloop_VQ_A(ntryL,G0H8(14),ex3(:),G0H4(1),m3h2x4(:,150),heltab2x8(:,:,150))
  call Hloop_Q_A(ntryL,G0H4(1),21,nMB,G1H4(14),n2h4(206))
  call Hloop_WQ_A(ntryL,G0H8(15),ex3(:),G0H4(1),m3h2x4(:,151),heltab2x8(:,:,151))
  call Hloop_Q_A(ntryL,G0H4(1),21,nMT,G1H4(15),n2h4(207))
  call Hloop_ZQ_A(ntryL,G0H8(16),ex3(:),G0H4(1),ngZd,m3h2x4(:,152),heltab2x8(:,:,152))
  call Hloop_Q_A(ntryL,G0H4(1),21,nMB,G1H4(16),n2h4(208))
  call Hloop_SA_Q(ntryL,G0H8(17),ex2(:),G0H4(1),ngH,m3h2x4(:,153),heltab2x8(:,:,153))
  call Hloop_A_Q(ntryL,G0H4(1),19,nMT,G1H4(17),n2h4(209))
  call Hloop_SA_Q(ntryL,G0H8(18),ex2(:),G0H4(1),ngPtb,m3h2x4(:,154),heltab2x8(:,:,154))
  call Hloop_A_Q(ntryL,G0H4(1),19,nMB,G1H4(18),n2h4(210))
  call Hloop_SA_Q(ntryL,G0H8(19),ex2(:),G0H4(1),ngX,m3h2x4(:,155),heltab2x8(:,:,155))
  call Hloop_A_Q(ntryL,G0H4(1),19,nMT,G1H4(19),n2h4(211))
  call Hloop_SA_Q(ntryL,G0H8(20),ex2(:),G0H4(1),ngPtb,m3h2x4(:,156),heltab2x8(:,:,156))
  call Hloop_A_Q(ntryL,G0H4(1),19,nMB,G1H4(20),n2h4(212))
  call Hloop_QA_S(ntryL,G1H8(1),ex2(:),G1H4(21),ngH,m3h2x4(:,157),heltab2x8(:,:,157))
  call Hloop_QA_S(ntryL,G1H8(2),ex2(:),G1H4(22),ngH,m3h2x4(:,158),heltab2x8(:,:,158))
  call Hloop_QA_S(ntryL,G1H8(3),ex2(:),G1H4(23),ngX,m3h2x4(:,159),heltab2x8(:,:,159))
  call Hloop_QA_S(ntryL,G1H8(4),ex2(:),G1H4(24),ngX,m3h2x4(:,160),heltab2x8(:,:,160))
  call Hloop_SA_Q(ntryL,G0H8(21),ex2(:),G0H4(1),ngPtb,m3h2x4(:,161),heltab2x8(:,:,161))
  call Hloop_A_Q(ntryL,G0H4(1),19,nMB,G1H4(25),n2h4(213))
  call Hloop_SA_Q(ntryL,G0H8(22),ex2(:),G0H4(1),ngPtb,m3h2x4(:,162),heltab2x8(:,:,162))
  call Hloop_A_Q(ntryL,G0H4(1),19,nMB,G1H4(26),n2h4(214))
  call Hloop_SA_Q(ntryL,G0H8(23),ex2(:),G0H4(1),ngH,m3h2x4(:,163),heltab2x8(:,:,163))
  call Hloop_A_Q(ntryL,G0H4(1),19,nMT,G1H4(27),n2h4(215))
  call Hloop_SA_Q(ntryL,G0H8(24),ex2(:),G0H4(1),ngX,m3h2x4(:,164),heltab2x8(:,:,164))
  call Hloop_A_Q(ntryL,G0H4(1),19,nMT,G1H4(28),n2h4(216))
  call Hloop_VA_Q(ntryL,G0H8(25),ex2(:),G0H4(1),m3h2x4(:,165),heltab2x8(:,:,165))
  call Hloop_A_Q(ntryL,G0H4(1),19,nMT,G1H4(29),n2h4(217))
  call Hloop_ZA_Q(ntryL,G0H8(26),ex2(:),G0H4(1),ngZu,m3h2x4(:,166),heltab2x8(:,:,166))
  call Hloop_A_Q(ntryL,G0H4(1),19,nMT,G1H4(30),n2h4(218))
  call Hloop_WA_Q(ntryL,G0H8(27),ex2(:),G0H4(1),m3h2x4(:,167),heltab2x8(:,:,167))
  call Hloop_A_Q(ntryL,G0H4(1),19,nMB,G1H4(31),n2h4(219))
  call Hloop_WA_Q(ntryL,G0H8(28),ex2(:),G0H4(1),m3h2x4(:,168),heltab2x8(:,:,168))
  call Hloop_A_Q(ntryL,G0H4(1),19,nMB,G1H4(32),n2h4(220))
  call Hloop_QA_S(ntryL,G1H8(5),ex2(:),G1H4(33),ngH,m3h2x4(:,169),heltab2x8(:,:,169))
  call Hloop_QA_S(ntryL,G1H8(6),ex2(:),G1H4(34),ngX,m3h2x4(:,170),heltab2x8(:,:,170))
  call Hloop_QA_S(ntryL,G1H8(7),ex2(:),G1H4(35),ngH,m3h2x4(:,171),heltab2x8(:,:,171))
  call Hloop_QA_S(ntryL,G1H8(8),ex2(:),G1H4(36),ngX,m3h2x4(:,172),heltab2x8(:,:,172))
  call Hloop_QA_V(ntryL,G1H8(9),ex2(:),G1H4(37),m3h2x4(:,173),heltab2x8(:,:,173))
  call Hloop_QA_V(ntryL,G1H8(10),ex2(:),G1H4(38),m3h2x4(:,174),heltab2x8(:,:,174))
  call Hloop_QA_Z(ntryL,G1H8(11),ex2(:),G1H4(39),ngZu,m3h2x4(:,175),heltab2x8(:,:,175))
  call Hloop_QA_Z(ntryL,G1H8(12),ex2(:),G1H4(40),ngZu,m3h2x4(:,176),heltab2x8(:,:,176))
  call Hloop_VA_Q(ntryL,G0H8(29),ex2(:),G0H4(1),m3h2x4(:,177),heltab2x8(:,:,177))
  call Hloop_A_Q(ntryL,G0H4(1),19,nMT,G1H4(41),n2h4(221))
  call Hloop_WA_Q(ntryL,G0H8(30),ex2(:),G0H4(1),m3h2x4(:,178),heltab2x8(:,:,178))
  call Hloop_A_Q(ntryL,G0H4(1),19,nMB,G1H4(42),n2h4(222))
  call Hloop_ZA_Q(ntryL,G0H8(31),ex2(:),G0H4(1),ngZu,m3h2x4(:,179),heltab2x8(:,:,179))
  call Hloop_A_Q(ntryL,G0H4(1),19,nMT,G1H4(43),n2h4(223))
  call Hloop_WA_Q(ntryL,G0H8(32),ex2(:),G0H4(1),m3h2x4(:,180),heltab2x8(:,:,180))
  call Hloop_A_Q(ntryL,G0H4(1),19,nMB,G1H4(44),n2h4(224))
  call Hloop_QA_V(ntryL,G1H8(13),ex2(:),G1H4(45),m3h2x4(:,181),heltab2x8(:,:,181))
  call Hloop_QA_V(ntryL,G1H8(14),ex2(:),G1H4(46),m3h2x4(:,182),heltab2x8(:,:,182))
  call Hloop_QA_Z(ntryL,G1H8(15),ex2(:),G1H4(47),ngZu,m3h2x4(:,183),heltab2x8(:,:,183))
  call Hloop_QA_Z(ntryL,G1H8(16),ex2(:),G1H4(48),ngZu,m3h2x4(:,184),heltab2x8(:,:,184))
  call Hloop_QA_S(ntryL,G1H8(17),ex2(:),G1H4(49),ngH,m3h2x4(:,185),heltab2x8(:,:,185))
  call Hloop_QA_S(ntryL,G1H8(18),ex2(:),G1H4(50),ngH,m3h2x4(:,186),heltab2x8(:,:,186))
  call Hloop_QA_S(ntryL,G1H8(19),ex2(:),G1H4(51),ngX,m3h2x4(:,187),heltab2x8(:,:,187))
  call Hloop_QA_S(ntryL,G1H8(20),ex2(:),G1H4(52),ngX,m3h2x4(:,188),heltab2x8(:,:,188))
  call Hloop_QA_S(ntryL,G1H8(21),ex2(:),G1H4(53),ngPtb,m3h2x4(:,189),heltab2x8(:,:,189))
  call Hloop_QA_S(ntryL,G1H8(22),ex2(:),G1H4(54),ngH,m3h2x4(:,190),heltab2x8(:,:,190))
  call Hloop_QA_S(ntryL,G1H8(23),ex2(:),G1H4(55),ngX,m3h2x4(:,191),heltab2x8(:,:,191))
  call Hloop_QA_S(ntryL,G1H8(24),ex2(:),G1H4(56),ngH,m3h2x4(:,192),heltab2x8(:,:,192))
  call Hloop_QA_S(ntryL,G1H8(25),ex2(:),G1H4(57),ngX,m3h2x4(:,193),heltab2x8(:,:,193))
  call Hloop_QA_S(ntryL,G1H8(26),ex2(:),G1H4(58),ngPtb,m3h2x4(:,194),heltab2x8(:,:,194))
  call Hloop_QA_V(ntryL,G1H8(27),ex2(:),G1H4(59),m3h2x4(:,195),heltab2x8(:,:,195))
  call Hloop_QA_V(ntryL,G1H8(28),ex2(:),G1H4(60),m3h2x4(:,196),heltab2x8(:,:,196))
  call Hloop_QA_Z(ntryL,G1H8(29),ex2(:),G1H4(61),ngZu,m3h2x4(:,197),heltab2x8(:,:,197))
  call Hloop_QA_Z(ntryL,G1H8(30),ex2(:),G1H4(62),ngZu,m3h2x4(:,198),heltab2x8(:,:,198))
  call Hloop_QA_W(ntryL,G1H8(31),ex2(:),G1H4(63),m3h2x4(:,199),heltab2x8(:,:,199))
  call Hloop_QA_V(ntryL,G1H8(32),ex2(:),G1H4(64),m3h2x4(:,200),heltab2x8(:,:,200))
  call Hloop_QA_V(ntryL,G1H8(33),ex2(:),G1H4(65),m3h2x4(:,201),heltab2x8(:,:,201))
  call Hloop_QA_Z(ntryL,G1H8(34),ex2(:),G1H4(66),ngZu,m3h2x4(:,202),heltab2x8(:,:,202))
  call Hloop_QA_Z(ntryL,G1H8(35),ex2(:),G1H4(67),ngZu,m3h2x4(:,203),heltab2x8(:,:,203))
  call Hloop_QA_W(ntryL,G1H8(36),ex2(:),G1H4(68),m3h2x4(:,204),heltab2x8(:,:,204))
  call Hloop_AQ_S(ntryL,G1H8(37),ex3(:),G1H4(69),ngH,m3h2x4(:,205),heltab2x8(:,:,205))
  call Hloop_AQ_S(ntryL,G1H8(38),ex3(:),G1H4(70),ngPtb,m3h2x4(:,206),heltab2x8(:,:,206))
  call Hloop_AQ_S(ntryL,G1H8(39),ex3(:),G1H4(71),ngX,m3h2x4(:,207),heltab2x8(:,:,207))
  call Hloop_AQ_S(ntryL,G1H8(40),ex3(:),G1H4(72),ngPtb,m3h2x4(:,208),heltab2x8(:,:,208))
  call Hloop_AQ_S(ntryL,G1H8(41),ex3(:),G1H4(73),ngPtb,m3h2x4(:,209),heltab2x8(:,:,209))
  call Hloop_AQ_S(ntryL,G1H8(42),ex3(:),G1H4(74),ngPtb,m3h2x4(:,210),heltab2x8(:,:,210))
  call Hloop_AQ_S(ntryL,G1H8(43),ex3(:),G1H4(75),ngH,m3h2x4(:,211),heltab2x8(:,:,211))
  call Hloop_AQ_S(ntryL,G1H8(44),ex3(:),G1H4(76),ngX,m3h2x4(:,212),heltab2x8(:,:,212))
  call Hloop_AQ_V(ntryL,G1H8(45),ex3(:),G1H4(77),m3h2x4(:,213),heltab2x8(:,:,213))
  call Hloop_AQ_Z(ntryL,G1H8(46),ex3(:),G1H4(78),ngZd,m3h2x4(:,214),heltab2x8(:,:,214))
  call Hloop_AQ_W(ntryL,G1H8(47),ex3(:),G1H4(79),m3h2x4(:,215),heltab2x8(:,:,215))
  call Hloop_AQ_W(ntryL,G1H8(48),ex3(:),G1H4(80),m3h2x4(:,216),heltab2x8(:,:,216))
  call Hloop_AQ_V(ntryL,G1H8(49),ex3(:),G1H4(81),m3h2x4(:,217),heltab2x8(:,:,217))
  call Hloop_AQ_W(ntryL,G1H8(50),ex3(:),G1H4(82),m3h2x4(:,218),heltab2x8(:,:,218))
  call Hloop_AQ_Z(ntryL,G1H8(51),ex3(:),G1H4(83),ngZd,m3h2x4(:,219),heltab2x8(:,:,219))
  call Hloop_AQ_W(ntryL,G1H8(52),ex3(:),G1H4(84),m3h2x4(:,220),heltab2x8(:,:,220))
  call Hloop_AQ_S(ntryL,G1H8(53),ex1(:),G1H4(85),ngH,m3h2x4(:,221),heltab2x8(:,:,221))
  call Hloop_AQ_S(ntryL,G1H8(54),ex1(:),G1H4(86),ngH,m3h2x4(:,222),heltab2x8(:,:,222))
  call Hloop_AQ_S(ntryL,G1H8(55),ex1(:),G1H4(87),ngX,m3h2x4(:,223),heltab2x8(:,:,223))
  call Hloop_AQ_S(ntryL,G1H8(56),ex1(:),G1H4(88),ngX,m3h2x4(:,224),heltab2x8(:,:,224))
  call Hloop_AQ_S(ntryL,G1H8(57),ex1(:),G1H4(89),ngPbt,m3h2x4(:,225),heltab2x8(:,:,225))
  call Hloop_AQ_S(ntryL,G1H8(58),ex1(:),G1H4(90),ngH,m3h2x4(:,226),heltab2x8(:,:,226))
  call Hloop_AQ_S(ntryL,G1H8(59),ex1(:),G1H4(91),ngX,m3h2x4(:,227),heltab2x8(:,:,227))
  call Hloop_AQ_S(ntryL,G1H8(60),ex1(:),G1H4(92),ngH,m3h2x4(:,228),heltab2x8(:,:,228))
  call Hloop_AQ_S(ntryL,G1H8(61),ex1(:),G1H4(93),ngX,m3h2x4(:,229),heltab2x8(:,:,229))
  call Hloop_AQ_S(ntryL,G1H8(62),ex1(:),G1H4(94),ngPbt,m3h2x4(:,230),heltab2x8(:,:,230))
  call Hloop_AQ_V(ntryL,G1H8(63),ex1(:),G1H4(95),m3h2x4(:,231),heltab2x8(:,:,231))
  call Hloop_AQ_V(ntryL,G1H8(64),ex1(:),G1H4(96),m3h2x4(:,232),heltab2x8(:,:,232))
  call Hloop_AQ_Z(ntryL,G1H8(65),ex1(:),G1H4(97),ngZu,m3h2x4(:,233),heltab2x8(:,:,233))
  call Hloop_AQ_Z(ntryL,G1H8(66),ex1(:),G1H4(98),ngZu,m3h2x4(:,234),heltab2x8(:,:,234))
  call Hloop_AQ_W(ntryL,G1H8(67),ex1(:),G1H4(99),m3h2x4(:,235),heltab2x8(:,:,235))
  call Hloop_AQ_V(ntryL,G1H8(68),ex1(:),G1H4(100),m3h2x4(:,236),heltab2x8(:,:,236))
  call Hloop_AQ_V(ntryL,G1H8(69),ex1(:),G1H4(101),m3h2x4(:,237),heltab2x8(:,:,237))
  call Hloop_AQ_Z(ntryL,G1H8(70),ex1(:),G1H4(102),ngZu,m3h2x4(:,238),heltab2x8(:,:,238))
  call Hloop_AQ_Z(ntryL,G1H8(71),ex1(:),G1H4(103),ngZu,m3h2x4(:,239),heltab2x8(:,:,239))
  call Hloop_AQ_W(ntryL,G1H8(72),ex1(:),G1H4(104),m3h2x4(:,240),heltab2x8(:,:,240))
  call Hloop_SQ_A(ntryL,G0H8(33),ex1(:),G0H4(1),ngH,m3h2x4(:,241),heltab2x8(:,:,241))
  call Hloop_Q_A(ntryL,G0H4(1),19,nMT,G1H4(105),n2h4(225))
  call Hloop_SQ_A(ntryL,G0H8(34),ex1(:),G0H4(1),ngPbt,m3h2x4(:,242),heltab2x8(:,:,242))
  call Hloop_Q_A(ntryL,G0H4(1),19,nMB,G1H4(106),n2h4(226))
  call Hloop_SQ_A(ntryL,G0H8(35),ex1(:),G0H4(1),ngX,m3h2x4(:,243),heltab2x8(:,:,243))
  call Hloop_Q_A(ntryL,G0H4(1),19,nMT,G1H4(107),n2h4(227))
  call Hloop_SQ_A(ntryL,G0H8(36),ex1(:),G0H4(1),ngPbt,m3h2x4(:,244),heltab2x8(:,:,244))
  call Hloop_Q_A(ntryL,G0H4(1),19,nMB,G1H4(108),n2h4(228))
  call Hloop_AQ_S(ntryL,G1H8(73),ex1(:),G1H4(109),ngH,m3h2x4(:,245),heltab2x8(:,:,245))
  call Hloop_AQ_S(ntryL,G1H8(74),ex1(:),G1H4(110),ngH,m3h2x4(:,246),heltab2x8(:,:,246))
  call Hloop_AQ_S(ntryL,G1H8(75),ex1(:),G1H4(111),ngX,m3h2x4(:,247),heltab2x8(:,:,247))
  call Hloop_AQ_S(ntryL,G1H8(76),ex1(:),G1H4(112),ngX,m3h2x4(:,248),heltab2x8(:,:,248))
  call Hloop_SQ_A(ntryL,G0H8(37),ex1(:),G0H4(1),ngPbt,m3h2x4(:,249),heltab2x8(:,:,249))
  call Hloop_Q_A(ntryL,G0H4(1),19,nMB,G1H4(113),n2h4(229))
  call Hloop_SQ_A(ntryL,G0H8(38),ex1(:),G0H4(1),ngPbt,m3h2x4(:,250),heltab2x8(:,:,250))
  call Hloop_Q_A(ntryL,G0H4(1),19,nMB,G1H4(114),n2h4(230))
  call Hloop_SQ_A(ntryL,G0H8(39),ex1(:),G0H4(1),ngH,m3h2x4(:,251),heltab2x8(:,:,251))
  call Hloop_Q_A(ntryL,G0H4(1),19,nMT,G1H4(115),n2h4(231))
  call Hloop_SQ_A(ntryL,G0H8(40),ex1(:),G0H4(1),ngX,m3h2x4(:,252),heltab2x8(:,:,252))
  call Hloop_Q_A(ntryL,G0H4(1),19,nMT,G1H4(116),n2h4(232))
  call Hloop_VQ_A(ntryL,G0H8(41),ex1(:),G0H4(1),m3h2x4(:,253),heltab2x8(:,:,253))
  call Hloop_Q_A(ntryL,G0H4(1),19,nMT,G1H4(117),n2h4(233))
  call Hloop_ZQ_A(ntryL,G0H8(42),ex1(:),G0H4(1),ngZu,m3h2x4(:,254),heltab2x8(:,:,254))
  call Hloop_Q_A(ntryL,G0H4(1),19,nMT,G1H4(118),n2h4(234))
  call Hloop_WQ_A(ntryL,G0H8(43),ex1(:),G0H4(1),m3h2x4(:,255),heltab2x8(:,:,255))
  call Hloop_Q_A(ntryL,G0H4(1),19,nMB,G1H4(119),n2h4(235))
  call Hloop_WQ_A(ntryL,G0H8(44),ex1(:),G0H4(1),m3h2x4(:,256),heltab2x8(:,:,256))
  call Hloop_Q_A(ntryL,G0H4(1),19,nMB,G1H4(120),n2h4(236))
  call Hloop_AQ_S(ntryL,G1H8(77),ex1(:),G1H4(121),ngH,m3h2x4(:,257),heltab2x8(:,:,257))
  call Hloop_AQ_S(ntryL,G1H8(78),ex1(:),G1H4(122),ngX,m3h2x4(:,258),heltab2x8(:,:,258))
  call Hloop_AQ_S(ntryL,G1H8(79),ex1(:),G1H4(123),ngH,m3h2x4(:,259),heltab2x8(:,:,259))
  call Hloop_AQ_S(ntryL,G1H8(80),ex1(:),G1H4(124),ngX,m3h2x4(:,260),heltab2x8(:,:,260))
  call Hloop_AQ_V(ntryL,G1H8(81),ex1(:),G1H4(125),m3h2x4(:,261),heltab2x8(:,:,261))
  call Hloop_AQ_V(ntryL,G1H8(82),ex1(:),G1H4(126),m3h2x4(:,262),heltab2x8(:,:,262))
  call Hloop_AQ_Z(ntryL,G1H8(83),ex1(:),G1H4(127),ngZu,m3h2x4(:,263),heltab2x8(:,:,263))
  call Hloop_AQ_Z(ntryL,G1H8(84),ex1(:),G1H4(128),ngZu,m3h2x4(:,264),heltab2x8(:,:,264))
  call Hloop_VQ_A(ntryL,G0H8(45),ex1(:),G0H4(1),m3h2x4(:,265),heltab2x8(:,:,265))
  call Hloop_Q_A(ntryL,G0H4(1),19,nMT,G1H4(129),n2h4(237))
  call Hloop_WQ_A(ntryL,G0H8(46),ex1(:),G0H4(1),m3h2x4(:,266),heltab2x8(:,:,266))
  call Hloop_Q_A(ntryL,G0H4(1),19,nMB,G1H4(130),n2h4(238))
  call Hloop_ZQ_A(ntryL,G0H8(47),ex1(:),G0H4(1),ngZu,m3h2x4(:,267),heltab2x8(:,:,267))
  call Hloop_Q_A(ntryL,G0H4(1),19,nMT,G1H4(131),n2h4(239))
  call Hloop_WQ_A(ntryL,G0H8(48),ex1(:),G0H4(1),m3h2x4(:,268),heltab2x8(:,:,268))
  call Hloop_Q_A(ntryL,G0H4(1),19,nMB,G1H4(132),n2h4(240))
  call Hloop_AQ_V(ntryL,G1H8(85),ex1(:),G1H4(133),m3h2x4(:,269),heltab2x8(:,:,269))
  call Hloop_AQ_V(ntryL,G1H8(86),ex1(:),G1H4(134),m3h2x4(:,270),heltab2x8(:,:,270))
  call Hloop_AQ_Z(ntryL,G1H8(87),ex1(:),G1H4(135),ngZu,m3h2x4(:,271),heltab2x8(:,:,271))
  call Hloop_AQ_Z(ntryL,G1H8(88),ex1(:),G1H4(136),ngZu,m3h2x4(:,272),heltab2x8(:,:,272))
  call Hloop_SA_Q(ntryL,G0H8(49),ex2(:),G0H4(1),ngH,m3h2x4(:,273),heltab2x8(:,:,273))
  call Hloop_A_Q(ntryL,G0H4(1),22,nMT,G1H4(137),n2h4(241))
  call Hloop_SA_Q(ntryL,G0H8(50),ex2(:),G0H4(1),ngX,m3h2x4(:,274),heltab2x8(:,:,274))
  call Hloop_A_Q(ntryL,G0H4(1),22,nMT,G1H4(138),n2h4(242))
  call Hloop_SA_Q(ntryL,G0H8(51),ex2(:),G0H4(1),ngH,m3h2x4(:,275),heltab2x8(:,:,275))
  call Hloop_A_Q(ntryL,G0H4(1),22,nMT,G1H4(139),n2h4(243))
  call Hloop_SA_Q(ntryL,G0H8(52),ex2(:),G0H4(1),ngX,m3h2x4(:,276),heltab2x8(:,:,276))
  call Hloop_A_Q(ntryL,G0H4(1),22,nMT,G1H4(140),n2h4(244))
  call Hloop_QA_S(ntryL,G1H8(89),ex2(:),G1H4(141),ngH,m3h2x4(:,277),heltab2x8(:,:,277))
  call Hloop_QA_S(ntryL,G1H8(90),ex2(:),G1H4(142),ngPtb,m3h2x4(:,278),heltab2x8(:,:,278))
  call Hloop_QA_S(ntryL,G1H8(91),ex2(:),G1H4(143),ngX,m3h2x4(:,279),heltab2x8(:,:,279))
  call Hloop_QA_S(ntryL,G1H8(92),ex2(:),G1H4(144),ngPtb,m3h2x4(:,280),heltab2x8(:,:,280))
  call Hloop_VA_Q(ntryL,G0H8(53),ex2(:),G0H4(1),m3h2x4(:,281),heltab2x8(:,:,281))
  call Hloop_A_Q(ntryL,G0H4(1),22,nMT,G1H4(145),n2h4(245))
  call Hloop_VA_Q(ntryL,G0H8(54),ex2(:),G0H4(1),m3h2x4(:,282),heltab2x8(:,:,282))
  call Hloop_A_Q(ntryL,G0H4(1),22,nMT,G1H4(146),n2h4(246))
  call Hloop_ZA_Q(ntryL,G0H8(55),ex2(:),G0H4(1),ngZu,m3h2x4(:,283),heltab2x8(:,:,283))
  call Hloop_A_Q(ntryL,G0H4(1),22,nMT,G1H4(147),n2h4(247))
  call Hloop_ZA_Q(ntryL,G0H8(56),ex2(:),G0H4(1),ngZu,m3h2x4(:,284),heltab2x8(:,:,284))
  call Hloop_A_Q(ntryL,G0H4(1),22,nMT,G1H4(148),n2h4(248))
  call Hloop_SA_Q(ntryL,G0H8(57),ex2(:),G0H4(1),ngH,m3h2x4(:,285),heltab2x8(:,:,285))
  call Hloop_A_Q(ntryL,G0H4(1),22,nMT,G1H4(149),n2h4(249))
  call Hloop_SA_Q(ntryL,G0H8(58),ex2(:),G0H4(1),ngX,m3h2x4(:,286),heltab2x8(:,:,286))
  call Hloop_A_Q(ntryL,G0H4(1),22,nMT,G1H4(150),n2h4(250))
  call Hloop_SA_Q(ntryL,G0H8(59),ex2(:),G0H4(1),ngH,m3h2x4(:,287),heltab2x8(:,:,287))
  call Hloop_A_Q(ntryL,G0H4(1),22,nMT,G1H4(151),n2h4(251))
  call Hloop_SA_Q(ntryL,G0H8(60),ex2(:),G0H4(1),ngX,m3h2x4(:,288),heltab2x8(:,:,288))
  call Hloop_A_Q(ntryL,G0H4(1),22,nMT,G1H4(152),n2h4(252))
  call Hloop_QA_S(ntryL,G1H8(93),ex2(:),G1H4(153),ngPtb,m3h2x4(:,289),heltab2x8(:,:,289))
  call Hloop_QA_S(ntryL,G1H8(94),ex2(:),G1H4(154),ngPtb,m3h2x4(:,290),heltab2x8(:,:,290))
  call Hloop_QA_S(ntryL,G1H8(95),ex2(:),G1H4(155),ngH,m3h2x4(:,291),heltab2x8(:,:,291))
  call Hloop_QA_S(ntryL,G1H8(96),ex2(:),G1H4(156),ngX,m3h2x4(:,292),heltab2x8(:,:,292))
  call Hloop_QA_V(ntryL,G1H8(97),ex2(:),G1H4(157),m3h2x4(:,293),heltab2x8(:,:,293))
  call Hloop_QA_Z(ntryL,G1H8(98),ex2(:),G1H4(158),ngZu,m3h2x4(:,294),heltab2x8(:,:,294))
  call Hloop_QA_W(ntryL,G1H8(99),ex2(:),G1H4(159),m3h2x4(:,295),heltab2x8(:,:,295))
  call Hloop_QA_W(ntryL,G1H8(100),ex2(:),G1H4(160),m3h2x4(:,296),heltab2x8(:,:,296))
  call Hloop_VA_Q(ntryL,G0H8(61),ex2(:),G0H4(1),m3h2x4(:,297),heltab2x8(:,:,297))
  call Hloop_A_Q(ntryL,G0H4(1),22,nMT,G1H4(161),n2h4(253))
  call Hloop_ZA_Q(ntryL,G0H8(62),ex2(:),G0H4(1),ngZu,m3h2x4(:,298),heltab2x8(:,:,298))
  call Hloop_A_Q(ntryL,G0H4(1),22,nMT,G1H4(162),n2h4(254))
  call Hloop_VA_Q(ntryL,G0H8(63),ex2(:),G0H4(1),m3h2x4(:,299),heltab2x8(:,:,299))
  call Hloop_A_Q(ntryL,G0H4(1),22,nMT,G1H4(163),n2h4(255))
  call Hloop_ZA_Q(ntryL,G0H8(64),ex2(:),G0H4(1),ngZu,m3h2x4(:,300),heltab2x8(:,:,300))
  call Hloop_A_Q(ntryL,G0H4(1),22,nMT,G1H4(164),n2h4(256))
  call Hloop_QA_V(ntryL,G1H8(101),ex2(:),G1H4(165),m3h2x4(:,301),heltab2x8(:,:,301))
  call Hloop_QA_W(ntryL,G1H8(102),ex2(:),G1H4(166),m3h2x4(:,302),heltab2x8(:,:,302))
  call Hloop_QA_Z(ntryL,G1H8(103),ex2(:),G1H4(167),ngZu,m3h2x4(:,303),heltab2x8(:,:,303))
  call Hloop_QA_W(ntryL,G1H8(104),ex2(:),G1H4(168),m3h2x4(:,304),heltab2x8(:,:,304))
  call Hloop_SQ_A(ntryL,G0H8(65),ex1(:),G0H4(1),ngH,m3h2x4(:,305),heltab2x8(:,:,305))
  call Hloop_Q_A(ntryL,G0H4(1),21,nMT,G1H4(169),n2h4(257))
  call Hloop_SQ_A(ntryL,G0H8(66),ex1(:),G0H4(1),ngH,m3h2x4(:,306),heltab2x8(:,:,306))
  call Hloop_Q_A(ntryL,G0H4(1),21,nMT,G1H4(170),n2h4(258))
  call Hloop_SQ_A(ntryL,G0H8(67),ex1(:),G0H4(1),ngX,m3h2x4(:,307),heltab2x8(:,:,307))
  call Hloop_Q_A(ntryL,G0H4(1),21,nMT,G1H4(171),n2h4(259))
  call Hloop_SQ_A(ntryL,G0H8(68),ex1(:),G0H4(1),ngX,m3h2x4(:,308),heltab2x8(:,:,308))
  call Hloop_Q_A(ntryL,G0H4(1),21,nMT,G1H4(172),n2h4(260))
  call Hloop_SQ_A(ntryL,G0H8(69),ex1(:),G0H4(1),ngPbt,m3h2x4(:,309),heltab2x8(:,:,309))
  call Hloop_Q_A(ntryL,G0H4(1),21,nMB,G1H4(173),n2h4(261))
  call Hloop_SQ_A(ntryL,G0H8(70),ex1(:),G0H4(1),ngH,m3h2x4(:,310),heltab2x8(:,:,310))
  call Hloop_Q_A(ntryL,G0H4(1),21,nMT,G1H4(174),n2h4(262))
  call Hloop_SQ_A(ntryL,G0H8(71),ex1(:),G0H4(1),ngX,m3h2x4(:,311),heltab2x8(:,:,311))
  call Hloop_Q_A(ntryL,G0H4(1),21,nMT,G1H4(175),n2h4(263))
  call Hloop_SQ_A(ntryL,G0H8(72),ex1(:),G0H4(1),ngH,m3h2x4(:,312),heltab2x8(:,:,312))
  call Hloop_Q_A(ntryL,G0H4(1),21,nMT,G1H4(176),n2h4(264))
  call Hloop_SQ_A(ntryL,G0H8(73),ex1(:),G0H4(1),ngX,m3h2x4(:,313),heltab2x8(:,:,313))
  call Hloop_Q_A(ntryL,G0H4(1),21,nMT,G1H4(177),n2h4(265))
  call Hloop_SQ_A(ntryL,G0H8(74),ex1(:),G0H4(1),ngPbt,m3h2x4(:,314),heltab2x8(:,:,314))
  call Hloop_Q_A(ntryL,G0H4(1),21,nMB,G1H4(178),n2h4(266))
  call Hloop_VQ_A(ntryL,G0H8(75),ex1(:),G0H4(1),m3h2x4(:,315),heltab2x8(:,:,315))
  call Hloop_Q_A(ntryL,G0H4(1),21,nMT,G1H4(179),n2h4(267))
  call Hloop_VQ_A(ntryL,G0H8(76),ex1(:),G0H4(1),m3h2x4(:,316),heltab2x8(:,:,316))
  call Hloop_Q_A(ntryL,G0H4(1),21,nMT,G1H4(180),n2h4(268))
  call Hloop_ZQ_A(ntryL,G0H8(77),ex1(:),G0H4(1),ngZu,m3h2x4(:,317),heltab2x8(:,:,317))
  call Hloop_Q_A(ntryL,G0H4(1),21,nMT,G1H4(181),n2h4(269))
  call Hloop_ZQ_A(ntryL,G0H8(78),ex1(:),G0H4(1),ngZu,m3h2x4(:,318),heltab2x8(:,:,318))
  call Hloop_Q_A(ntryL,G0H4(1),21,nMT,G1H4(182),n2h4(270))
  call Hloop_WQ_A(ntryL,G0H8(79),ex1(:),G0H4(1),m3h2x4(:,319),heltab2x8(:,:,319))
  call Hloop_Q_A(ntryL,G0H4(1),21,nMB,G1H4(183),n2h4(271))
  call Hloop_VQ_A(ntryL,G0H8(80),ex1(:),G0H4(1),m3h2x4(:,320),heltab2x8(:,:,320))
  call Hloop_Q_A(ntryL,G0H4(1),21,nMT,G1H4(184),n2h4(272))
  call Hloop_VQ_A(ntryL,G0H8(81),ex1(:),G0H4(1),m3h2x4(:,321),heltab2x8(:,:,321))
  call Hloop_Q_A(ntryL,G0H4(1),21,nMT,G1H4(185),n2h4(273))
  call Hloop_ZQ_A(ntryL,G0H8(82),ex1(:),G0H4(1),ngZu,m3h2x4(:,322),heltab2x8(:,:,322))
  call Hloop_Q_A(ntryL,G0H4(1),21,nMT,G1H4(186),n2h4(274))
  call Hloop_ZQ_A(ntryL,G0H8(83),ex1(:),G0H4(1),ngZu,m3h2x4(:,323),heltab2x8(:,:,323))
  call Hloop_Q_A(ntryL,G0H4(1),21,nMT,G1H4(187),n2h4(275))
  call Hloop_WQ_A(ntryL,G0H8(84),ex1(:),G0H4(1),m3h2x4(:,324),heltab2x8(:,:,324))
  call Hloop_Q_A(ntryL,G0H4(1),21,nMB,G1H4(188),n2h4(276))
  call Hloop_SQ_A(ntryL,G0H8(85),ex1(:),G0H4(1),ngH,m3h2x4(:,325),heltab2x8(:,:,325))
  call Hloop_Q_A(ntryL,G0H4(1),21,nMT,G1H4(189),n2h4(277))
  call Hloop_SQ_A(ntryL,G0H8(86),ex1(:),G0H4(1),ngPbt,m3h2x4(:,326),heltab2x8(:,:,326))
  call Hloop_Q_A(ntryL,G0H4(1),21,nMB,G1H4(190),n2h4(278))
  call Hloop_SQ_A(ntryL,G0H8(87),ex1(:),G0H4(1),ngX,m3h2x4(:,327),heltab2x8(:,:,327))
  call Hloop_Q_A(ntryL,G0H4(1),21,nMT,G1H4(191),n2h4(279))
  call Hloop_SQ_A(ntryL,G0H8(88),ex1(:),G0H4(1),ngPbt,m3h2x4(:,328),heltab2x8(:,:,328))
  call Hloop_Q_A(ntryL,G0H4(1),21,nMB,G1H4(192),n2h4(280))
  call Hloop_SQ_A(ntryL,G0H8(89),ex1(:),G0H4(1),ngPbt,m3h2x4(:,329),heltab2x8(:,:,329))
  call Hloop_Q_A(ntryL,G0H4(1),21,nMB,G1H4(193),n2h4(281))
  call Hloop_SQ_A(ntryL,G0H8(90),ex1(:),G0H4(1),ngPbt,m3h2x4(:,330),heltab2x8(:,:,330))
  call Hloop_Q_A(ntryL,G0H4(1),21,nMB,G1H4(194),n2h4(282))
  call Hloop_SQ_A(ntryL,G0H8(91),ex1(:),G0H4(1),ngH,m3h2x4(:,331),heltab2x8(:,:,331))
  call Hloop_Q_A(ntryL,G0H4(1),21,nMT,G1H4(195),n2h4(283))
  call Hloop_SQ_A(ntryL,G0H8(92),ex1(:),G0H4(1),ngX,m3h2x4(:,332),heltab2x8(:,:,332))
  call Hloop_Q_A(ntryL,G0H4(1),21,nMT,G1H4(196),n2h4(284))
  call Hloop_VQ_A(ntryL,G0H8(93),ex1(:),G0H4(1),m3h2x4(:,333),heltab2x8(:,:,333))
  call Hloop_Q_A(ntryL,G0H4(1),21,nMT,G1H4(197),n2h4(285))
  call Hloop_ZQ_A(ntryL,G0H8(94),ex1(:),G0H4(1),ngZu,m3h2x4(:,334),heltab2x8(:,:,334))
  call Hloop_Q_A(ntryL,G0H4(1),21,nMT,G1H4(198),n2h4(286))
  call Hloop_WQ_A(ntryL,G0H8(95),ex1(:),G0H4(1),m3h2x4(:,335),heltab2x8(:,:,335))
  call Hloop_Q_A(ntryL,G0H4(1),21,nMB,G1H4(199),n2h4(287))
  call Hloop_WQ_A(ntryL,G0H8(96),ex1(:),G0H4(1),m3h2x4(:,336),heltab2x8(:,:,336))
  call Hloop_Q_A(ntryL,G0H4(1),21,nMB,G1H4(200),n2h4(288))
  call Hloop_VQ_A(ntryL,G0H8(97),ex1(:),G0H4(1),m3h2x4(:,337),heltab2x8(:,:,337))
  call Hloop_Q_A(ntryL,G0H4(1),21,nMT,G1H4(201),n2h4(289))
  call Hloop_WQ_A(ntryL,G0H8(98),ex1(:),G0H4(1),m3h2x4(:,338),heltab2x8(:,:,338))
  call Hloop_Q_A(ntryL,G0H4(1),21,nMB,G1H4(202),n2h4(290))
  call Hloop_ZQ_A(ntryL,G0H8(99),ex1(:),G0H4(1),ngZu,m3h2x4(:,339),heltab2x8(:,:,339))
  call Hloop_Q_A(ntryL,G0H4(1),21,nMT,G1H4(203),n2h4(291))
  call Hloop_WQ_A(ntryL,G0H8(100),ex1(:),G0H4(1),m3h2x4(:,340),heltab2x8(:,:,340))
  call Hloop_Q_A(ntryL,G0H4(1),21,nMB,G1H4(204),n2h4(292))
  call Hloop_SA_Q(ntryL,G0H8(101),ex2(:),G0H4(1),ngH,m3h2x4(:,341),heltab2x8(:,:,341))
  call Hloop_A_Q(ntryL,G0H4(1),26,nMT,G1H4(205),n2h4(293))
  call Hloop_SA_Q(ntryL,G0H8(102),ex2(:),G0H4(1),ngX,m3h2x4(:,342),heltab2x8(:,:,342))
  call Hloop_A_Q(ntryL,G0H4(1),26,nMT,G1H4(206),n2h4(294))
  call Hloop_SA_Q(ntryL,G0H8(103),ex2(:),G0H4(1),ngH,m3h2x4(:,343),heltab2x8(:,:,343))
  call Hloop_A_Q(ntryL,G0H4(1),26,nMT,G1H4(207),n2h4(295))
  call Hloop_SA_Q(ntryL,G0H8(104),ex2(:),G0H4(1),ngX,m3h2x4(:,344),heltab2x8(:,:,344))
  call Hloop_A_Q(ntryL,G0H4(1),26,nMT,G1H4(208),n2h4(296))
  call Hloop_SA_Q(ntryL,G0H8(105),ex2(:),G0H4(1),ngPtb,m3h2x4(:,345),heltab2x8(:,:,345))
  call Hloop_A_Q(ntryL,G0H4(1),26,nMB,G1H4(209),n2h4(297))
  call Hloop_VA_Q(ntryL,G0H8(106),ex2(:),G0H4(1),m3h2x4(:,346),heltab2x8(:,:,346))
  call Hloop_A_Q(ntryL,G0H4(1),26,nMT,G1H4(210),n2h4(298))
  call Hloop_VA_Q(ntryL,G0H8(107),ex2(:),G0H4(1),m3h2x4(:,347),heltab2x8(:,:,347))
  call Hloop_A_Q(ntryL,G0H4(1),26,nMT,G1H4(211),n2h4(299))
  call Hloop_ZA_Q(ntryL,G0H8(108),ex2(:),G0H4(1),ngZu,m3h2x4(:,348),heltab2x8(:,:,348))
  call Hloop_A_Q(ntryL,G0H4(1),26,nMT,G1H4(212),n2h4(300))
  call Hloop_ZA_Q(ntryL,G0H8(109),ex2(:),G0H4(1),ngZu,m3h2x4(:,349),heltab2x8(:,:,349))
  call Hloop_A_Q(ntryL,G0H4(1),26,nMT,G1H4(213),n2h4(301))
  call Hloop_WA_Q(ntryL,G0H8(110),ex2(:),G0H4(1),m3h2x4(:,350),heltab2x8(:,:,350))
  call Hloop_A_Q(ntryL,G0H4(1),26,nMB,G1H4(214),n2h4(302))
  call Hloop_SA_Q(ntryL,G0H8(111),ex2(:),G0H4(1),ngH,m3h2x4(:,351),heltab2x8(:,:,351))
  call Hloop_A_Q(ntryL,G0H4(1),26,nMT,G1H4(215),n2h4(303))
  call Hloop_SA_Q(ntryL,G0H8(112),ex2(:),G0H4(1),ngX,m3h2x4(:,352),heltab2x8(:,:,352))
  call Hloop_A_Q(ntryL,G0H4(1),26,nMT,G1H4(216),n2h4(304))
  call Hloop_SA_Q(ntryL,G0H8(113),ex2(:),G0H4(1),ngH,m3h2x4(:,353),heltab2x8(:,:,353))
  call Hloop_A_Q(ntryL,G0H4(1),26,nMT,G1H4(217),n2h4(305))
  call Hloop_SA_Q(ntryL,G0H8(114),ex2(:),G0H4(1),ngX,m3h2x4(:,354),heltab2x8(:,:,354))
  call Hloop_A_Q(ntryL,G0H4(1),26,nMT,G1H4(218),n2h4(306))
  call Hloop_SA_Q(ntryL,G0H8(115),ex2(:),G0H4(1),ngPtb,m3h2x4(:,355),heltab2x8(:,:,355))
  call Hloop_A_Q(ntryL,G0H4(1),26,nMB,G1H4(219),n2h4(307))
  call Hloop_VA_Q(ntryL,G0H8(116),ex2(:),G0H4(1),m3h2x4(:,356),heltab2x8(:,:,356))
  call Hloop_A_Q(ntryL,G0H4(1),26,nMT,G1H4(220),n2h4(308))
  call Hloop_ZA_Q(ntryL,G0H8(117),ex2(:),G0H4(1),ngZu,m3h2x4(:,357),heltab2x8(:,:,357))
  call Hloop_A_Q(ntryL,G0H4(1),26,nMT,G1H4(221),n2h4(309))
  call Hloop_VA_Q(ntryL,G0H8(118),ex2(:),G0H4(1),m3h2x4(:,358),heltab2x8(:,:,358))
  call Hloop_A_Q(ntryL,G0H4(1),26,nMT,G1H4(222),n2h4(310))
  call Hloop_ZA_Q(ntryL,G0H8(119),ex2(:),G0H4(1),ngZu,m3h2x4(:,359),heltab2x8(:,:,359))
  call Hloop_A_Q(ntryL,G0H4(1),26,nMT,G1H4(223),n2h4(311))
  call Hloop_WA_Q(ntryL,G0H8(120),ex2(:),G0H4(1),m3h2x4(:,360),heltab2x8(:,:,360))
  call Hloop_A_Q(ntryL,G0H4(1),26,nMB,G1H4(224),n2h4(312))
  call Hloop_SQ_A(ntryL,G0H8(121),ex1(:),G0H4(1),ngH,m3h2x4(:,361),heltab2x8(:,:,361))
  call Hloop_Q_A(ntryL,G0H4(1),25,nMT,G1H4(225),n2h4(313))
  call Hloop_SQ_A(ntryL,G0H8(122),ex1(:),G0H4(1),ngH,m3h2x4(:,362),heltab2x8(:,:,362))
  call Hloop_Q_A(ntryL,G0H4(1),25,nMT,G1H4(226),n2h4(314))
  call Hloop_SQ_A(ntryL,G0H8(123),ex1(:),G0H4(1),ngX,m3h2x4(:,363),heltab2x8(:,:,363))
  call Hloop_Q_A(ntryL,G0H4(1),25,nMT,G1H4(227),n2h4(315))
  call Hloop_SQ_A(ntryL,G0H8(124),ex1(:),G0H4(1),ngX,m3h2x4(:,364),heltab2x8(:,:,364))
  call Hloop_Q_A(ntryL,G0H4(1),25,nMT,G1H4(228),n2h4(316))
  call Hloop_AQ_S(ntryL,G1H8(105),ex1(:),G1H4(229),ngH,m3h2x4(:,365),heltab2x8(:,:,365))
  call Hloop_AQ_S(ntryL,G1H8(106),ex1(:),G1H4(230),ngPbt,m3h2x4(:,366),heltab2x8(:,:,366))
  call Hloop_AQ_S(ntryL,G1H8(107),ex1(:),G1H4(231),ngX,m3h2x4(:,367),heltab2x8(:,:,367))
  call Hloop_AQ_S(ntryL,G1H8(108),ex1(:),G1H4(232),ngPbt,m3h2x4(:,368),heltab2x8(:,:,368))
  call Hloop_SQ_A(ntryL,G0H8(125),ex1(:),G0H4(1),ngH,m3h2x4(:,369),heltab2x8(:,:,369))
  call Hloop_Q_A(ntryL,G0H4(1),25,nMT,G1H4(233),n2h4(317))
  call Hloop_SQ_A(ntryL,G0H8(126),ex1(:),G0H4(1),ngX,m3h2x4(:,370),heltab2x8(:,:,370))
  call Hloop_Q_A(ntryL,G0H4(1),25,nMT,G1H4(234),n2h4(318))
  call Hloop_SQ_A(ntryL,G0H8(127),ex1(:),G0H4(1),ngH,m3h2x4(:,371),heltab2x8(:,:,371))
  call Hloop_Q_A(ntryL,G0H4(1),25,nMT,G1H4(235),n2h4(319))
  call Hloop_SQ_A(ntryL,G0H8(128),ex1(:),G0H4(1),ngX,m3h2x4(:,372),heltab2x8(:,:,372))
  call Hloop_Q_A(ntryL,G0H4(1),25,nMT,G1H4(236),n2h4(320))
  call Hloop_VQ_A(ntryL,G0H8(129),ex1(:),G0H4(1),m3h2x4(:,373),heltab2x8(:,:,373))
  call Hloop_Q_A(ntryL,G0H4(1),25,nMT,G1H4(237),n2h4(321))
  call Hloop_VQ_A(ntryL,G0H8(130),ex1(:),G0H4(1),m3h2x4(:,374),heltab2x8(:,:,374))
  call Hloop_Q_A(ntryL,G0H4(1),25,nMT,G1H4(238),n2h4(322))
  call Hloop_ZQ_A(ntryL,G0H8(131),ex1(:),G0H4(1),ngZu,m3h2x4(:,375),heltab2x8(:,:,375))
  call Hloop_Q_A(ntryL,G0H4(1),25,nMT,G1H4(239),n2h4(323))
  call Hloop_ZQ_A(ntryL,G0H8(132),ex1(:),G0H4(1),ngZu,m3h2x4(:,376),heltab2x8(:,:,376))
  call Hloop_Q_A(ntryL,G0H4(1),25,nMT,G1H4(240),n2h4(324))
  call Hloop_AQ_S(ntryL,G1H8(109),ex1(:),G1H4(241),ngPbt,m3h2x4(:,377),heltab2x8(:,:,377))
  call Hloop_AQ_S(ntryL,G1H8(110),ex1(:),G1H4(242),ngPbt,m3h2x4(:,378),heltab2x8(:,:,378))
  call Hloop_AQ_S(ntryL,G1H8(111),ex1(:),G1H4(243),ngH,m3h2x4(:,379),heltab2x8(:,:,379))
  call Hloop_AQ_S(ntryL,G1H8(112),ex1(:),G1H4(244),ngX,m3h2x4(:,380),heltab2x8(:,:,380))
  call Hloop_AQ_V(ntryL,G1H8(113),ex1(:),G1H4(245),m3h2x4(:,381),heltab2x8(:,:,381))
  call Hloop_AQ_Z(ntryL,G1H8(114),ex1(:),G1H4(246),ngZu,m3h2x4(:,382),heltab2x8(:,:,382))
  call Hloop_AQ_W(ntryL,G1H8(115),ex1(:),G1H4(247),m3h2x4(:,383),heltab2x8(:,:,383))
  call Hloop_AQ_W(ntryL,G1H8(116),ex1(:),G1H4(248),m3h2x4(:,384),heltab2x8(:,:,384))
  call Hloop_VQ_A(ntryL,G0H8(133),ex1(:),G0H4(1),m3h2x4(:,385),heltab2x8(:,:,385))
  call Hloop_Q_A(ntryL,G0H4(1),25,nMT,G1H4(249),n2h4(325))
  call Hloop_VQ_A(ntryL,G0H8(134),ex1(:),G0H4(1),m3h2x4(:,386),heltab2x8(:,:,386))
  call Hloop_Q_A(ntryL,G0H4(1),25,nMT,G1H4(250),n2h4(326))
  call Hloop_ZQ_A(ntryL,G0H8(135),ex1(:),G0H4(1),ngZu,m3h2x4(:,387),heltab2x8(:,:,387))
  call Hloop_Q_A(ntryL,G0H4(1),25,nMT,G1H4(251),n2h4(327))
  call Hloop_ZQ_A(ntryL,G0H8(136),ex1(:),G0H4(1),ngZu,m3h2x4(:,388),heltab2x8(:,:,388))
  call Hloop_Q_A(ntryL,G0H4(1),25,nMT,G1H4(252),n2h4(328))
  call Hloop_AQ_V(ntryL,G1H8(117),ex1(:),G1H4(253),m3h2x4(:,389),heltab2x8(:,:,389))
  call Hloop_AQ_W(ntryL,G1H8(118),ex1(:),G1H4(254),m3h2x4(:,390),heltab2x8(:,:,390))
  call Hloop_AQ_Z(ntryL,G1H8(119),ex1(:),G1H4(255),ngZu,m3h2x4(:,391),heltab2x8(:,:,391))
  call Hloop_AQ_W(ntryL,G1H8(120),ex1(:),G1H4(256),m3h2x4(:,392),heltab2x8(:,:,392))
  call Hloop_AQ_S(ntryL,G1H8(121),ex1(:),G1H4(257),ngH,m3h2x4(:,393),heltab2x8(:,:,393))
  call Hloop_AQ_S(ntryL,G1H8(122),ex1(:),G1H4(258),ngPbt,m3h2x4(:,394),heltab2x8(:,:,394))
  call Hloop_AQ_S(ntryL,G1H8(123),ex1(:),G1H4(259),ngX,m3h2x4(:,395),heltab2x8(:,:,395))
  call Hloop_AQ_S(ntryL,G1H8(124),ex1(:),G1H4(260),ngPbt,m3h2x4(:,396),heltab2x8(:,:,396))
  call Hloop_AQ_S(ntryL,G1H8(125),ex1(:),G1H4(261),ngPbt,m3h2x4(:,397),heltab2x8(:,:,397))
  call Hloop_AQ_S(ntryL,G1H8(126),ex1(:),G1H4(262),ngPbt,m3h2x4(:,398),heltab2x8(:,:,398))
  call Hloop_AQ_S(ntryL,G1H8(127),ex1(:),G1H4(263),ngH,m3h2x4(:,399),heltab2x8(:,:,399))
  call Hloop_AQ_S(ntryL,G1H8(128),ex1(:),G1H4(264),ngX,m3h2x4(:,400),heltab2x8(:,:,400))
  call Hloop_AQ_V(ntryL,G1H8(129),ex1(:),G1H4(265),m3h2x4(:,401),heltab2x8(:,:,401))
  call Hloop_AQ_Z(ntryL,G1H8(130),ex1(:),G1H4(266),ngZu,m3h2x4(:,402),heltab2x8(:,:,402))
  call Hloop_AQ_W(ntryL,G1H8(131),ex1(:),G1H4(267),m3h2x4(:,403),heltab2x8(:,:,403))
  call Hloop_AQ_W(ntryL,G1H8(132),ex1(:),G1H4(268),m3h2x4(:,404),heltab2x8(:,:,404))
  call Hloop_AQ_V(ntryL,G1H8(133),ex1(:),G1H4(269),m3h2x4(:,405),heltab2x8(:,:,405))
  call Hloop_AQ_W(ntryL,G1H8(134),ex1(:),G1H4(270),m3h2x4(:,406),heltab2x8(:,:,406))
  call Hloop_AQ_Z(ntryL,G1H8(135),ex1(:),G1H4(271),ngZu,m3h2x4(:,407),heltab2x8(:,:,407))
  call Hloop_AQ_W(ntryL,G1H8(136),ex1(:),G1H4(272),m3h2x4(:,408),heltab2x8(:,:,408))
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(44),[G2H4(40),G2H4(7),G2H4(3)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(54),[G2H4(41),G2H4(9),G2H4(4)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(55),[G2H4(42),G2H4(10),G2H4(5)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(60),[G2H4(56),G2H4(32),G2H4(22)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(70),[G2H4(57),G2H4(38),G2H4(24)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(71),[G2H4(58),G2H4(39),G2H4(30)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(110),[G2H4(105),G2H4(80),G2H4(72)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(123),[G2H4(107),G2H4(86),G2H4(77)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(124),[G2H4(109),G2H4(87),G2H4(78)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(2),[G2H4(126),G2H4(92),G2H4(88)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(13),[G2H4(128),G2H4(103),G2H4(89)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(14),[G2H4(1),G2H4(104),G2H4(90)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(19),[G2H4(15)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(20),[G2H4(6)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(11),[G2H4(18)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(12),[G2H4(8)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(7),[G1H4(1)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(8),[G1H4(3)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(6),[G1H4(4)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(13),[G1H4(9)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(15),[G1H4(10)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(16),[G1H4(12)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(31),[G1H4(18)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(30),[G1H4(19)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(32),[G1H4(20)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(42),[G1H4(25)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(44),[G1H4(26)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(43),[G1H4(28)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(119),[G1H4(106)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(118),[G1H4(107)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(120),[G1H4(108)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(130),[G1H4(113)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(132),[G1H4(114)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(131),[G1H4(116)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(147),[G1H4(138)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(148),[G1H4(140)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(162),[G1H4(150)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(164),[G1H4(152)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(181),[G1H4(171)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(182),[G1H4(172)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(183),[G1H4(173)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(186),[G1H4(175)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(187),[G1H4(177)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(188),[G1H4(178)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(199),[G1H4(190)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(198),[G1H4(191)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(200),[G1H4(192)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(202),[G1H4(193)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(204),[G1H4(194)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(203),[G1H4(196)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(212),[G1H4(206)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(213),[G1H4(208)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(214),[G1H4(209)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(221),[G1H4(216)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(223),[G1H4(218)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(224),[G1H4(219)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(239),[G1H4(227)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(240),[G1H4(228)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(251),[G1H4(234)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(252),[G1H4(236)])
  call Hloop_QA_S(ntryL,G2H4(44),ex4(:),G2H2(1),ngH,m3h2x2(:,93),heltab2x4(:,:,93))
  call Hloop_QA_S(ntryL,G2H4(54),ex4(:),G2H2(2),ngX,m3h2x2(:,94),heltab2x4(:,:,94))
  call Hloop_QA_S(ntryL,G2H4(55),ex4(:),G2H2(3),ngPbt,m3h2x2(:,95),heltab2x4(:,:,95))
  call Hloop_QA_V(ntryL,G2H4(60),ex4(:),G2H2(4),m3h2x2(:,96),heltab2x4(:,:,96))
  call Hloop_QA_Z(ntryL,G2H4(70),ex4(:),G2H2(5),ngZd,m3h2x2(:,97),heltab2x4(:,:,97))
  call Hloop_QA_W(ntryL,G2H4(71),ex4(:),G2H2(6),m3h2x2(:,98),heltab2x4(:,:,98))
  call Hloop_AQ_S(ntryL,G2H4(110),ex3(:),G2H2(7),ngH,m3h2x2(:,99),heltab2x4(:,:,99))
  call Hloop_AQ_S(ntryL,G2H4(123),ex3(:),G2H2(8),ngX,m3h2x2(:,100),heltab2x4(:,:,100))
  call Hloop_AQ_S(ntryL,G2H4(124),ex3(:),G2H2(9),ngPtb,m3h2x2(:,101),heltab2x4(:,:,101))
  call Hloop_AQ_V(ntryL,G2H4(2),ex3(:),G2H2(10),m3h2x2(:,102),heltab2x4(:,:,102))
  call Hloop_AQ_Z(ntryL,G2H4(13),ex3(:),G2H2(11),ngZd,m3h2x2(:,103),heltab2x4(:,:,103))
  call Hloop_AQ_W(ntryL,G2H4(14),ex3(:),G2H2(12),m3h2x2(:,104),heltab2x4(:,:,104))
  call Hloop_SS_S(ntryL,G1H8(137),wf4(:,1),G1H2(1),m3h4x2(:,1),heltab2x8(:,:,409))
  call Hloop_SS_S(ntryL,G1H8(138),wf4(:,1),G1H2(2),m3h4x2(:,2),heltab2x8(:,:,410))
  call Hloop_SS_S(ntryL,G1H8(139),wf4(:,1),G1H2(6),m3h4x2(:,3),heltab2x8(:,:,411))
  call Hloop_SS_S(ntryL,G1H8(140),wf4(:,4),G1H2(7),m3h4x2(:,4),heltab2x8(:,:,412))
  call Hloop_SS_S(ntryL,G1H8(141),wf4(:,4),G1H2(8),m3h4x2(:,5),heltab2x8(:,:,413))
  call Hloop_ST_V(ntryL,G1H8(142),20,wf4(:,1),3,G2H2(13),m3h4x2(:,6),heltab2x8(:,:,414))
  call Hloop_ST_V(ntryL,G1H8(143),20,wf4(:,1),3,G2H2(14),m3h4x2(:,7),heltab2x8(:,:,415))
  call Hloop_TS_V(ntryL,G1H8(144),20,wf4(:,4),3,G2H2(15),m3h4x2(:,8),heltab2x8(:,:,416))
  call Hloop_ST_V(ntryL,G1H8(145),20,wf4(:,4),3,G2H2(16),m3h4x2(:,9),heltab2x8(:,:,417))
  call Hloop_VT_S(ntryL,G1H8(146),20,wf4(:,1),3,G2H2(17),m3h4x2(:,10),heltab2x8(:,:,418))
  call Hloop_VT_S(ntryL,G1H8(147),20,wf4(:,1),3,G2H2(18),m3h4x2(:,11),heltab2x8(:,:,419))
  call Hloop_VS_T(ntryL,G1H8(148),20,wf4(:,4),3,G2H2(19),m3h4x2(:,12),heltab2x8(:,:,420))
  call Hloop_VT_S(ntryL,G1H8(149),20,wf4(:,4),3,G2H2(20),m3h4x2(:,13),heltab2x8(:,:,421))
  call Hloop_VS_V(ntryL,G1H8(150),wf4(:,1),G1H2(12),m3h4x2(:,14),heltab2x8(:,:,422))
  call Hloop_VS_V(ntryL,G1H8(151),wf4(:,1),G1H2(13),m3h4x2(:,15),heltab2x8(:,:,423))
  call Hloop_TV_S(ntryL,G1H8(152),20,wf4(:,5),3,G2H2(21),m3h4x2(:,16),heltab2x8(:,:,424))
  call Hloop_TV_S(ntryL,G1H8(153),20,wf4(:,6),3,G2H2(22),m3h4x2(:,17),heltab2x8(:,:,425))
  call Hloop_SV_T(ntryL,G1H8(154),20,wf4(:,6),3,G2H2(23),m3h4x2(:,18),heltab2x8(:,:,426))
  call Hloop_TV_S(ntryL,G1H8(155),20,wf4(:,6),3,G2H2(24),m3h4x2(:,19),heltab2x8(:,:,427))
  call Hloop_SV_V(ntryL,G1H8(156),wf4(:,5),G1H2(14),m3h4x2(:,20),heltab2x8(:,:,428))
  call Hloop_SV_V(ntryL,G1H8(157),wf4(:,6),G1H2(18),m3h4x2(:,21),heltab2x8(:,:,429))
  call Hloop_SV_V(ntryL,G1H8(158),wf4(:,6),G1H2(19),m3h4x2(:,22),heltab2x8(:,:,430))
  call Hloop_VV_S(ntryL,G1H8(159),wf4(:,5),G1H2(20),m3h4x2(:,23),heltab2x8(:,:,431))
  call Hloop_VV_S(ntryL,G1H8(160),wf4(:,6),G1H2(24),m3h4x2(:,24),heltab2x8(:,:,432))
  call Hloop_VV_S(ntryL,G1H8(161),wf4(:,6),G1H2(25),m3h4x2(:,25),heltab2x8(:,:,433))
  call Hloop_UV_W(ntryL,G1H8(162),20,wf4(:,5),3,G2H2(25),m3h4x2(:,26),heltab2x8(:,:,434))
  call Hloop_UV_W(ntryL,G1H8(163),20,wf4(:,6),3,G2H2(26),m3h4x2(:,27),heltab2x8(:,:,435))
  call Hloop_SA_Q(ntryL,G1H8(164),ex4(:),G1H4(1),ngH,m3h2x4(:,409),heltab2x8(:,:,436))
  call Hloop_A_Q(ntryL,G1H4(1),25,nMB,G2H4(16),n2h4(329))
  call Hloop_SA_Q(ntryL,G1H8(165),ex4(:),G1H4(3),ngX,m3h2x4(:,410),heltab2x8(:,:,437))
  call Hloop_A_Q(ntryL,G1H4(3),25,nMB,G2H4(17),n2h4(330))
  call Hloop_VA_Q(ntryL,G1H8(166),ex4(:),G1H4(4),m3h2x4(:,411),heltab2x8(:,:,438))
  call Hloop_A_Q(ntryL,G1H4(4),25,nMB,G2H4(21),n2h4(331))
  call Hloop_ZA_Q(ntryL,G1H8(167),ex4(:),G1H4(9),ngZd,m3h2x4(:,412),heltab2x8(:,:,439))
  call Hloop_A_Q(ntryL,G1H4(9),25,nMB,G2H4(27),n2h4(332))
  call Hloop_SA_Q(ntryL,G1H8(168),ex4(:),G1H4(10),ngH,m3h2x4(:,413),heltab2x8(:,:,440))
  call Hloop_A_Q(ntryL,G1H4(10),25,nMB,G2H4(23),n2h4(333))
  call Hloop_SA_Q(ntryL,G1H8(169),ex4(:),G1H4(12),ngX,m3h2x4(:,414),heltab2x8(:,:,441))
  call Hloop_A_Q(ntryL,G1H4(12),25,nMB,G2H4(28),n2h4(334))
  call Hloop_VA_Q(ntryL,G1H8(170),ex4(:),G1H4(18),m3h2x4(:,415),heltab2x8(:,:,442))
  call Hloop_A_Q(ntryL,G1H4(18),25,nMB,G2H4(25),n2h4(335))
  call Hloop_ZA_Q(ntryL,G1H8(171),ex4(:),G1H4(19),ngZd,m3h2x4(:,416),heltab2x8(:,:,443))
  call Hloop_A_Q(ntryL,G1H4(19),25,nMB,G2H4(26),n2h4(336))
  call Hloop_AQ_S(ntryL,G2H4(19),ex1(:),G2H2(27),ngH,m3h2x2(:,105),heltab2x4(:,:,105))
  call Hloop_AQ_S(ntryL,G2H4(20),ex1(:),G2H2(28),ngX,m3h2x2(:,106),heltab2x4(:,:,106))
  call Hloop_AQ_V(ntryL,G2H4(11),ex1(:),G2H2(29),m3h2x2(:,107),heltab2x4(:,:,107))
  call Hloop_AQ_Z(ntryL,G2H4(12),ex1(:),G2H2(30),ngZu,m3h2x2(:,108),heltab2x4(:,:,108))
  call Hloop_SS_S(ntryL,G1H8(172),wf4(:,10),G1H2(26),m3h4x2(:,28),heltab2x8(:,:,444))
  call Hloop_SS_S(ntryL,G1H8(173),wf4(:,10),G1H2(30),m3h4x2(:,29),heltab2x8(:,:,445))
  call Hloop_ST_V(ntryL,G1H8(174),17,wf4(:,10),6,G2H2(31),m3h4x2(:,30),heltab2x8(:,:,446))
  call Hloop_ST_V(ntryL,G1H8(175),17,wf4(:,10),6,G2H2(32),m3h4x2(:,31),heltab2x8(:,:,447))
  call Hloop_TS_V(ntryL,G1H8(176),17,wf4(:,10),6,G2H2(33),m3h4x2(:,32),heltab2x8(:,:,448))
  call Hloop_TS_V(ntryL,G1H8(177),17,wf4(:,10),6,G2H2(34),m3h4x2(:,33),heltab2x8(:,:,449))
  call Hloop_VT_S(ntryL,G1H8(178),17,wf4(:,10),6,G2H2(35),m3h4x2(:,34),heltab2x8(:,:,450))
  call Hloop_VT_S(ntryL,G1H8(179),17,wf4(:,10),6,G2H2(36),m3h4x2(:,35),heltab2x8(:,:,451))
  call Hloop_VS_T(ntryL,G1H8(180),17,wf4(:,10),6,G2H2(37),m3h4x2(:,36),heltab2x8(:,:,452))
  call Hloop_VS_T(ntryL,G1H8(181),17,wf4(:,10),6,G2H2(38),m3h4x2(:,37),heltab2x8(:,:,453))
  call Hloop_VS_V(ntryL,G1H8(182),wf4(:,10),G1H2(31),m3h4x2(:,38),heltab2x8(:,:,454))
  call Hloop_VS_V(ntryL,G1H8(183),wf4(:,10),G1H2(32),m3h4x2(:,39),heltab2x8(:,:,455))
  call Hloop_VS_V(ntryL,G1H8(184),wf4(:,10),G1H2(36),m3h4x2(:,40),heltab2x8(:,:,456))
  call Hloop_VS_V(ntryL,G1H8(185),wf4(:,10),G1H2(37),m3h4x2(:,41),heltab2x8(:,:,457))
  call Hloop_TV_S(ntryL,G1H8(186),17,wf4(:,12),6,G2H2(39),m3h4x2(:,42),heltab2x8(:,:,458))
  call Hloop_SV_T(ntryL,G1H8(187),17,wf4(:,12),6,G2H2(40),m3h4x2(:,43),heltab2x8(:,:,459))
  call Hloop_TV_S(ntryL,G1H8(188),17,wf4(:,12),6,G2H2(41),m3h4x2(:,44),heltab2x8(:,:,460))
  call Hloop_SV_T(ntryL,G1H8(189),17,wf4(:,12),6,G2H2(42),m3h4x2(:,45),heltab2x8(:,:,461))
  call Hloop_SV_V(ntryL,G1H8(190),wf4(:,12),G1H2(38),m3h4x2(:,46),heltab2x8(:,:,462))
  call Hloop_SV_V(ntryL,G1H8(191),wf4(:,12),G1H2(42),m3h4x2(:,47),heltab2x8(:,:,463))
  call Hloop_SV_V(ntryL,G1H8(192),wf4(:,12),G1H2(43),m3h4x2(:,48),heltab2x8(:,:,464))
  call Hloop_VV_S(ntryL,G1H8(193),wf4(:,12),G1H2(44),m3h4x2(:,49),heltab2x8(:,:,465))
  call Hloop_VV_S(ntryL,G1H8(194),wf4(:,12),G1H2(48),m3h4x2(:,50),heltab2x8(:,:,466))
  call Hloop_VV_S(ntryL,G1H8(195),wf4(:,12),G1H2(49),m3h4x2(:,51),heltab2x8(:,:,467))
  call Hloop_UW_V(ntryL,G1H8(196),17,wf4(:,12),6,G2H2(43),m3h4x2(:,52),heltab2x8(:,:,468))
  call Hloop_UV_W(ntryL,G1H8(197),17,wf4(:,12),6,G2H2(44),m3h4x2(:,53),heltab2x8(:,:,469))
  call Hloop_UW_V(ntryL,G1H8(198),17,wf4(:,12),6,G2H2(45),m3h4x2(:,54),heltab2x8(:,:,470))
  call Hloop_UV_W(ntryL,G1H8(199),17,wf4(:,12),6,G2H2(46),m3h4x2(:,55),heltab2x8(:,:,471))
  call Hloop_SQ_A(ntryL,G1H8(200),ex3(:),G1H4(20),ngH,m3h2x4(:,417),heltab2x8(:,:,472))
  call Hloop_Q_A(ntryL,G1H4(20),22,nMB,G2H4(29),n2h4(337))
  call Hloop_SQ_A(ntryL,G1H8(201),ex3(:),G1H4(25),ngX,m3h2x4(:,418),heltab2x8(:,:,473))
  call Hloop_Q_A(ntryL,G1H4(25),22,nMB,G2H4(34),n2h4(338))
  call Hloop_VQ_A(ntryL,G1H8(202),ex3(:),G1H4(26),m3h2x4(:,419),heltab2x8(:,:,474))
  call Hloop_Q_A(ntryL,G1H4(26),22,nMB,G2H4(31),n2h4(339))
  call Hloop_ZQ_A(ntryL,G1H8(203),ex3(:),G1H4(28),ngZd,m3h2x4(:,420),heltab2x8(:,:,475))
  call Hloop_Q_A(ntryL,G1H4(28),22,nMB,G2H4(36),n2h4(340))
  call Hloop_SQ_A(ntryL,G1H8(204),ex3(:),G1H4(106),ngH,m3h2x4(:,421),heltab2x8(:,:,476))
  call Hloop_Q_A(ntryL,G1H4(106),22,nMB,G2H4(33),n2h4(341))
  call Hloop_SQ_A(ntryL,G1H8(205),ex3(:),G1H4(107),ngX,m3h2x4(:,422),heltab2x8(:,:,477))
  call Hloop_Q_A(ntryL,G1H4(107),22,nMB,G2H4(35),n2h4(342))
  call Hloop_VQ_A(ntryL,G1H8(206),ex3(:),G1H4(108),m3h2x4(:,423),heltab2x8(:,:,478))
  call Hloop_Q_A(ntryL,G1H4(108),22,nMB,G2H4(37),n2h4(343))
  call Hloop_ZQ_A(ntryL,G1H8(207),ex3(:),G1H4(113),ngZd,m3h2x4(:,424),heltab2x8(:,:,479))
  call Hloop_Q_A(ntryL,G1H4(113),22,nMB,G2H4(47),n2h4(344))
  call Hloop_SA_Q(ntryL,G1H8(208),ex2(:),G1H4(114),ngH,m3h2x4(:,425),heltab2x8(:,:,480))
  call Hloop_A_Q(ntryL,G1H4(114),22,nMT,G2H4(46),n2h4(345))
  call Hloop_SA_Q(ntryL,G1H8(209),ex2(:),G1H4(116),ngX,m3h2x4(:,426),heltab2x8(:,:,481))
  call Hloop_A_Q(ntryL,G1H4(116),22,nMT,G2H4(48),n2h4(346))
  call Hloop_VA_Q(ntryL,G1H8(210),ex2(:),G1H4(138),m3h2x4(:,427),heltab2x8(:,:,482))
  call Hloop_A_Q(ntryL,G1H4(138),22,nMT,G2H4(50),n2h4(347))
  call Hloop_ZA_Q(ntryL,G1H8(211),ex2(:),G1H4(140),ngZu,m3h2x4(:,428),heltab2x8(:,:,483))
  call Hloop_A_Q(ntryL,G1H4(140),22,nMT,G2H4(52),n2h4(348))
  call Hloop_SA_Q(ntryL,G1H8(212),ex2(:),G1H4(150),ngH,m3h2x4(:,429),heltab2x8(:,:,484))
  call Hloop_A_Q(ntryL,G1H4(150),22,nMT,G2H4(43),n2h4(349))
  call Hloop_SA_Q(ntryL,G1H8(213),ex2(:),G1H4(152),ngX,m3h2x4(:,430),heltab2x8(:,:,485))
  call Hloop_A_Q(ntryL,G1H4(152),22,nMT,G2H4(51),n2h4(350))
  call Hloop_VA_Q(ntryL,G1H8(214),ex2(:),G1H4(171),m3h2x4(:,431),heltab2x8(:,:,486))
  call Hloop_A_Q(ntryL,G1H4(171),22,nMT,G2H4(45),n2h4(351))
  call Hloop_ZA_Q(ntryL,G1H8(215),ex2(:),G1H4(172),ngZu,m3h2x4(:,432),heltab2x8(:,:,487))
  call Hloop_A_Q(ntryL,G1H4(172),22,nMT,G2H4(49),n2h4(352))
  call Hloop_SS_S(ntryL,G1H8(216),wf4(:,13),G1H2(50),m3h4x2(:,56),heltab2x8(:,:,488))
  call Hloop_SS_S(ntryL,G1H8(217),wf4(:,13),G1H2(54),m3h4x2(:,57),heltab2x8(:,:,489))
  call Hloop_TS_V(ntryL,G1H8(218),18,wf4(:,13),9,G2H2(47),m3h4x2(:,58),heltab2x8(:,:,490))
  call Hloop_TS_V(ntryL,G1H8(219),18,wf4(:,13),9,G2H2(48),m3h4x2(:,59),heltab2x8(:,:,491))
  call Hloop_TS_V(ntryL,G1H8(220),18,wf4(:,13),9,G2H2(49),m3h4x2(:,60),heltab2x8(:,:,492))
  call Hloop_TS_V(ntryL,G1H8(221),18,wf4(:,13),9,G2H2(50),m3h4x2(:,61),heltab2x8(:,:,493))
  call Hloop_VS_T(ntryL,G1H8(222),18,wf4(:,13),9,G2H2(51),m3h4x2(:,62),heltab2x8(:,:,494))
  call Hloop_VS_T(ntryL,G1H8(223),18,wf4(:,13),9,G2H2(52),m3h4x2(:,63),heltab2x8(:,:,495))
  call Hloop_VS_T(ntryL,G1H8(224),18,wf4(:,13),9,G2H2(53),m3h4x2(:,64),heltab2x8(:,:,496))
  call Hloop_VS_T(ntryL,G1H8(225),18,wf4(:,13),9,G2H2(54),m3h4x2(:,65),heltab2x8(:,:,497))
  call Hloop_VS_V(ntryL,G1H8(226),wf4(:,13),G1H2(55),m3h4x2(:,66),heltab2x8(:,:,498))
  call Hloop_VS_V(ntryL,G1H8(227),wf4(:,13),G1H2(56),m3h4x2(:,67),heltab2x8(:,:,499))
  call Hloop_VS_V(ntryL,G1H8(228),wf4(:,13),G1H2(60),m3h4x2(:,68),heltab2x8(:,:,500))
  call Hloop_VS_V(ntryL,G1H8(229),wf4(:,13),G1H2(61),m3h4x2(:,69),heltab2x8(:,:,501))
  call Hloop_TV_S(ntryL,G1H8(230),18,wf4(:,16),9,G2H2(55),m3h4x2(:,70),heltab2x8(:,:,502))
  call Hloop_SV_T(ntryL,G1H8(231),18,wf4(:,16),9,G2H2(56),m3h4x2(:,71),heltab2x8(:,:,503))
  call Hloop_TV_S(ntryL,G1H8(232),18,wf4(:,16),9,G2H2(57),m3h4x2(:,72),heltab2x8(:,:,504))
  call Hloop_SV_T(ntryL,G1H8(233),18,wf4(:,16),9,G2H2(58),m3h4x2(:,73),heltab2x8(:,:,505))
  call Hloop_SV_V(ntryL,G1H8(234),wf4(:,16),G1H2(62),m3h4x2(:,74),heltab2x8(:,:,506))
  call Hloop_SV_V(ntryL,G1H8(235),wf4(:,16),G1H2(66),m3h4x2(:,75),heltab2x8(:,:,507))
  call Hloop_SV_V(ntryL,G1H8(236),wf4(:,16),G1H2(67),m3h4x2(:,76),heltab2x8(:,:,508))
  call Hloop_VV_S(ntryL,G1H8(237),wf4(:,16),G1H2(68),m3h4x2(:,77),heltab2x8(:,:,509))
  call Hloop_VV_S(ntryL,G1H8(238),wf4(:,16),G1H2(72),m3h4x2(:,78),heltab2x8(:,:,510))
  call Hloop_VV_S(ntryL,G1H8(239),wf4(:,16),G1H2(73),m3h4x2(:,79),heltab2x8(:,:,511))
  call Hloop_UV_W(ntryL,G1H8(240),18,wf4(:,16),9,G2H2(59),m3h4x2(:,80),heltab2x8(:,:,512))
  call Hloop_UW_V(ntryL,G1H8(241),18,wf4(:,16),9,G2H2(60),m3h4x2(:,81),heltab2x8(:,:,513))
  call Hloop_UV_W(ntryL,G1H8(242),18,wf4(:,16),9,G2H2(61),m3h4x2(:,82),heltab2x8(:,:,514))
  call Hloop_UW_V(ntryL,G1H8(243),18,wf4(:,16),9,G2H2(62),m3h4x2(:,83),heltab2x8(:,:,515))
  call Hloop_SA_Q(ntryL,G1H8(244),ex2(:),G1H4(173),ngH,m3h2x4(:,433),heltab2x8(:,:,516))
  call Hloop_A_Q(ntryL,G1H4(173),19,nMT,G2H4(53),n2h4(353))
  call Hloop_SA_Q(ntryL,G1H8(245),ex2(:),G1H4(175),ngX,m3h2x4(:,434),heltab2x8(:,:,517))
  call Hloop_A_Q(ntryL,G1H4(175),19,nMT,G2H4(63),n2h4(354))
  call Hloop_SA_Q(ntryL,G1H8(246),ex2(:),G1H4(177),ngPtb,m3h2x4(:,435),heltab2x8(:,:,518))
  call Hloop_A_Q(ntryL,G1H4(177),19,nMB,G2H4(62),n2h4(355))
  call Hloop_SA_Q(ntryL,G1H8(247),ex2(:),G1H4(178),ngH,m3h2x4(:,436),heltab2x8(:,:,519))
  call Hloop_A_Q(ntryL,G1H4(178),19,nMT,G2H4(64),n2h4(356))
  call Hloop_SA_Q(ntryL,G1H8(248),ex2(:),G1H4(190),ngX,m3h2x4(:,437),heltab2x8(:,:,520))
  call Hloop_A_Q(ntryL,G1H4(190),19,nMT,G2H4(66),n2h4(357))
  call Hloop_SA_Q(ntryL,G1H8(249),ex2(:),G1H4(191),ngPtb,m3h2x4(:,438),heltab2x8(:,:,521))
  call Hloop_A_Q(ntryL,G1H4(191),19,nMB,G2H4(68),n2h4(358))
  call Hloop_VA_Q(ntryL,G1H8(250),ex2(:),G1H4(192),m3h2x4(:,439),heltab2x8(:,:,522))
  call Hloop_A_Q(ntryL,G1H4(192),19,nMT,G2H4(59),n2h4(359))
  call Hloop_ZA_Q(ntryL,G1H8(251),ex2(:),G1H4(193),ngZu,m3h2x4(:,440),heltab2x8(:,:,523))
  call Hloop_A_Q(ntryL,G1H4(193),19,nMT,G2H4(67),n2h4(360))
  call Hloop_WA_Q(ntryL,G1H8(252),ex2(:),G1H4(194),m3h2x4(:,441),heltab2x8(:,:,524))
  call Hloop_A_Q(ntryL,G1H4(194),19,nMB,G2H4(61),n2h4(361))
  call Hloop_VA_Q(ntryL,G1H8(253),ex2(:),G1H4(196),m3h2x4(:,442),heltab2x8(:,:,525))
  call Hloop_A_Q(ntryL,G1H4(196),19,nMT,G2H4(65),n2h4(362))
  call Hloop_ZA_Q(ntryL,G1H8(254),ex2(:),G1H4(206),ngZu,m3h2x4(:,443),heltab2x8(:,:,526))
  call Hloop_A_Q(ntryL,G1H4(206),19,nMT,G2H4(69),n2h4(363))
  call Hloop_WA_Q(ntryL,G1H8(255),ex2(:),G1H4(208),m3h2x4(:,444),heltab2x8(:,:,527))
  call Hloop_A_Q(ntryL,G1H4(208),19,nMB,G2H4(75),n2h4(364))
  call Hloop_SA_Q(ntryL,G1H8(256),ex2(:),G1H4(209),ngH,m3h2x4(:,445),heltab2x8(:,:,528))
  call Hloop_A_Q(ntryL,G1H4(209),19,nMT,G2H4(74),n2h4(365))
  call Hloop_SA_Q(ntryL,G1H8(257),ex2(:),G1H4(216),ngX,m3h2x4(:,446),heltab2x8(:,:,529))
  call Hloop_A_Q(ntryL,G1H4(216),19,nMT,G2H4(76),n2h4(366))
  call Hloop_SA_Q(ntryL,G1H8(258),ex2(:),G1H4(218),ngPtb,m3h2x4(:,447),heltab2x8(:,:,530))
  call Hloop_A_Q(ntryL,G1H4(218),19,nMB,G2H4(73),n2h4(367))
  call Hloop_SA_Q(ntryL,G1H8(259),ex2(:),G1H4(219),ngH,m3h2x4(:,448),heltab2x8(:,:,531))
  call Hloop_A_Q(ntryL,G1H4(219),19,nMT,G2H4(82),n2h4(368))
  call Hloop_SA_Q(ntryL,G1H8(260),ex2(:),G1H4(227),ngX,m3h2x4(:,449),heltab2x8(:,:,532))
  call Hloop_A_Q(ntryL,G1H4(227),19,nMT,G2H4(84),n2h4(369))
  call Hloop_SA_Q(ntryL,G1H8(261),ex2(:),G1H4(228),ngPtb,m3h2x4(:,450),heltab2x8(:,:,533))
  call Hloop_A_Q(ntryL,G1H4(228),19,nMB,G2H4(79),n2h4(370))
  call Hloop_VA_Q(ntryL,G1H8(262),ex2(:),G1H4(234),m3h2x4(:,451),heltab2x8(:,:,534))
  call Hloop_A_Q(ntryL,G1H4(234),19,nMT,G2H4(83),n2h4(371))
  call Hloop_ZA_Q(ntryL,G1H8(263),ex2(:),G1H4(236),ngZu,m3h2x4(:,452),heltab2x8(:,:,535))
  call Hloop_A_Q(ntryL,G1H4(236),19,nMT,G2H4(81),n2h4(372))
  call Hloop_WA_Q(ntryL,G1H8(264),ex2(:),G1H4(1),m3h2x4(:,453),heltab2x8(:,:,536))
  call Hloop_A_Q(ntryL,G1H4(1),19,nMB,G2H4(85),n2h4(373))
  call Hloop_VA_Q(ntryL,G1H8(265),ex2(:),G1H4(3),m3h2x4(:,454),heltab2x8(:,:,537))
  call Hloop_A_Q(ntryL,G1H4(3),19,nMT,G2H4(95),n2h4(374))
  call Hloop_ZA_Q(ntryL,G1H8(266),ex2(:),G1H4(4),ngZu,m3h2x4(:,455),heltab2x8(:,:,538))
  call Hloop_A_Q(ntryL,G1H4(4),19,nMT,G2H4(94),n2h4(375))
  call Hloop_WA_Q(ntryL,G1H8(267),ex2(:),G1H4(9),m3h2x4(:,456),heltab2x8(:,:,539))
  call Hloop_A_Q(ntryL,G1H4(9),19,nMB,G2H4(96),n2h4(376))
  call Hloop_SQ_A(ntryL,G1H8(268),ex1(:),G1H4(10),ngH,m3h2x4(:,457),heltab2x8(:,:,540))
  call Hloop_Q_A(ntryL,G1H4(10),19,nMT,G2H4(98),n2h4(377))
  call Hloop_SQ_A(ntryL,G1H8(269),ex1(:),G1H4(12),ngX,m3h2x4(:,458),heltab2x8(:,:,541))
  call Hloop_Q_A(ntryL,G1H4(12),19,nMT,G2H4(100),n2h4(378))
  call Hloop_SQ_A(ntryL,G1H8(270),ex1(:),G1H4(18),ngPbt,m3h2x4(:,459),heltab2x8(:,:,542))
  call Hloop_Q_A(ntryL,G1H4(18),19,nMB,G2H4(91),n2h4(379))
  call Hloop_SQ_A(ntryL,G1H8(271),ex1(:),G1H4(19),ngH,m3h2x4(:,460),heltab2x8(:,:,543))
  call Hloop_Q_A(ntryL,G1H4(19),19,nMT,G2H4(99),n2h4(380))
  call Hloop_SQ_A(ntryL,G1H8(272),ex1(:),G1H4(20),ngX,m3h2x4(:,461),heltab2x8(:,:,544))
  call Hloop_Q_A(ntryL,G1H4(20),19,nMT,G2H4(93),n2h4(381))
  call Hloop_SQ_A(ntryL,G1H8(273),ex1(:),G1H4(25),ngPbt,m3h2x4(:,462),heltab2x8(:,:,545))
  call Hloop_Q_A(ntryL,G1H4(25),19,nMB,G2H4(97),n2h4(382))
  call Hloop_VQ_A(ntryL,G1H8(274),ex1(:),G1H4(26),m3h2x4(:,463),heltab2x8(:,:,546))
  call Hloop_Q_A(ntryL,G1H4(26),19,nMT,G2H4(101),n2h4(383))
  call Hloop_ZQ_A(ntryL,G1H8(275),ex1(:),G1H4(28),ngZu,m3h2x4(:,464),heltab2x8(:,:,547))
  call Hloop_Q_A(ntryL,G1H4(28),19,nMT,G2H4(102),n2h4(384))
  call Hloop_WQ_A(ntryL,G1H8(276),ex1(:),G1H4(106),m3h2x4(:,465),heltab2x8(:,:,548))
  call Hloop_Q_A(ntryL,G1H4(106),19,nMB,G2H4(113),n2h4(385))
  call Hloop_VQ_A(ntryL,G1H8(277),ex1(:),G1H4(107),m3h2x4(:,466),heltab2x8(:,:,549))
  call Hloop_Q_A(ntryL,G1H4(107),19,nMT,G2H4(114),n2h4(386))
  call Hloop_ZQ_A(ntryL,G1H8(278),ex1(:),G1H4(108),ngZu,m3h2x4(:,467),heltab2x8(:,:,550))
  call Hloop_Q_A(ntryL,G1H4(108),19,nMT,G2H4(115),n2h4(387))
  call Hloop_WQ_A(ntryL,G1H8(279),ex1(:),G1H4(113),m3h2x4(:,468),heltab2x8(:,:,551))
  call Hloop_Q_A(ntryL,G1H4(113),19,nMB,G2H4(106),n2h4(388))
  call Hloop_SQ_A(ntryL,G1H8(280),ex1(:),G1H4(114),ngH,m3h2x4(:,469),heltab2x8(:,:,552))
  call Hloop_Q_A(ntryL,G1H4(114),19,nMT,G2H4(118),n2h4(389))
  call Hloop_SQ_A(ntryL,G1H8(281),ex1(:),G1H4(116),ngX,m3h2x4(:,470),heltab2x8(:,:,553))
  call Hloop_Q_A(ntryL,G1H4(116),19,nMT,G2H4(108),n2h4(390))
  call Hloop_SQ_A(ntryL,G1H8(282),ex1(:),G1H4(138),ngPbt,m3h2x4(:,471),heltab2x8(:,:,554))
  call Hloop_Q_A(ntryL,G1H4(138),19,nMB,G2H4(119),n2h4(391))
  call Hloop_SQ_A(ntryL,G1H8(283),ex1(:),G1H4(140),ngH,m3h2x4(:,472),heltab2x8(:,:,555))
  call Hloop_Q_A(ntryL,G1H4(140),19,nMT,G2H4(120),n2h4(392))
  call Hloop_SQ_A(ntryL,G1H8(284),ex1(:),G1H4(150),ngX,m3h2x4(:,473),heltab2x8(:,:,556))
  call Hloop_Q_A(ntryL,G1H4(150),19,nMT,G2H4(111),n2h4(393))
  call Hloop_SQ_A(ntryL,G1H8(285),ex1(:),G1H4(152),ngPbt,m3h2x4(:,474),heltab2x8(:,:,557))
  call Hloop_Q_A(ntryL,G1H4(152),19,nMB,G2H4(112),n2h4(394))
  call Hloop_VQ_A(ntryL,G1H8(286),ex1(:),G1H4(171),m3h2x4(:,475),heltab2x8(:,:,558))
  call Hloop_Q_A(ntryL,G1H4(171),19,nMT,G2H4(116),n2h4(395))
  call Hloop_ZQ_A(ntryL,G1H8(287),ex1(:),G1H4(172),ngZu,m3h2x4(:,476),heltab2x8(:,:,559))
  call Hloop_Q_A(ntryL,G1H4(172),19,nMT,G2H4(117),n2h4(396))
  call Hloop_WQ_A(ntryL,G1H8(288),ex1(:),G1H4(173),m3h2x4(:,477),heltab2x8(:,:,560))
  call Hloop_Q_A(ntryL,G1H4(173),19,nMB,G2H4(121),n2h4(397))
  call Hloop_VQ_A(ntryL,G1H8(289),ex1(:),G1H4(175),m3h2x4(:,478),heltab2x8(:,:,561))
  call Hloop_Q_A(ntryL,G1H4(175),19,nMT,G2H4(122),n2h4(398))
  call Hloop_ZQ_A(ntryL,G1H8(290),ex1(:),G1H4(177),ngZu,m3h2x4(:,479),heltab2x8(:,:,562))
  call Hloop_Q_A(ntryL,G1H4(177),19,nMT,G2H4(131),n2h4(399))
  call Hloop_WQ_A(ntryL,G1H8(291),ex1(:),G1H4(178),m3h2x4(:,480),heltab2x8(:,:,563))
  call Hloop_Q_A(ntryL,G1H4(178),19,nMB,G2H4(132),n2h4(400))
  call Hloop_SS_S(ntryL,G1H8(292),wf4(:,17),G1H2(74),m3h4x2(:,84),heltab2x8(:,:,564))
  call Hloop_SS_S(ntryL,G1H8(293),wf4(:,17),G1H2(78),m3h4x2(:,85),heltab2x8(:,:,565))
  call Hloop_SS_S(ntryL,G1H8(294),wf4(:,17),G1H2(79),m3h4x2(:,86),heltab2x8(:,:,566))
  call Hloop_SS_S(ntryL,G1H8(295),wf4(:,18),G1H2(80),m3h4x2(:,87),heltab2x8(:,:,567))
  call Hloop_SS_S(ntryL,G1H8(296),wf4(:,18),G1H2(84),m3h4x2(:,88),heltab2x8(:,:,568))
  call Hloop_ST_V(ntryL,G1H8(297),17,wf4(:,17),12,G2H2(63),m3h4x2(:,89),heltab2x8(:,:,569))
  call Hloop_ST_V(ntryL,G1H8(298),17,wf4(:,17),12,G2H2(64),m3h4x2(:,90),heltab2x8(:,:,570))
  call Hloop_TS_V(ntryL,G1H8(299),17,wf4(:,18),12,G2H2(65),m3h4x2(:,91),heltab2x8(:,:,571))
  call Hloop_ST_V(ntryL,G1H8(300),17,wf4(:,18),12,G2H2(66),m3h4x2(:,92),heltab2x8(:,:,572))
  call Hloop_VT_S(ntryL,G1H8(301),17,wf4(:,17),12,G2H2(67),m3h4x2(:,93),heltab2x8(:,:,573))
  call Hloop_VT_S(ntryL,G1H8(302),17,wf4(:,17),12,G2H2(68),m3h4x2(:,94),heltab2x8(:,:,574))
  call Hloop_VS_T(ntryL,G1H8(303),17,wf4(:,18),12,G2H2(69),m3h4x2(:,95),heltab2x8(:,:,575))
  call Hloop_VT_S(ntryL,G1H8(304),17,wf4(:,18),12,G2H2(70),m3h4x2(:,96),heltab2x8(:,:,576))
  call Hloop_VS_V(ntryL,G1H8(305),wf4(:,17),G1H2(85),m3h4x2(:,97),heltab2x8(:,:,577))
  call Hloop_VS_V(ntryL,G1H8(306),wf4(:,17),G1H2(86),m3h4x2(:,98),heltab2x8(:,:,578))
  call Hloop_SV_T(ntryL,G1H8(307),17,wf4(:,19),12,G2H2(71),m3h4x2(:,99),heltab2x8(:,:,579))
  call Hloop_TV_S(ntryL,G1H8(308),17,wf4(:,20),12,G2H2(72),m3h4x2(:,100),heltab2x8(:,:,580))
  call Hloop_SV_T(ntryL,G1H8(309),17,wf4(:,20),12,G2H2(73),m3h4x2(:,101),heltab2x8(:,:,581))
  call Hloop_SV_T(ntryL,G1H8(310),17,wf4(:,20),12,G2H2(74),m3h4x2(:,102),heltab2x8(:,:,582))
  call Hloop_SV_V(ntryL,G1H8(311),wf4(:,19),G1H2(90),m3h4x2(:,103),heltab2x8(:,:,583))
  call Hloop_SV_V(ntryL,G1H8(312),wf4(:,20),G1H2(91),m3h4x2(:,104),heltab2x8(:,:,584))
  call Hloop_SV_V(ntryL,G1H8(313),wf4(:,20),G1H2(92),m3h4x2(:,105),heltab2x8(:,:,585))
  call Hloop_VV_S(ntryL,G1H8(314),wf4(:,19),G1H2(96),m3h4x2(:,106),heltab2x8(:,:,586))
  call Hloop_VV_S(ntryL,G1H8(315),wf4(:,20),G1H2(97),m3h4x2(:,107),heltab2x8(:,:,587))
  call Hloop_VV_S(ntryL,G1H8(316),wf4(:,20),G1H2(98),m3h4x2(:,108),heltab2x8(:,:,588))
  call Hloop_UW_V(ntryL,G1H8(317),17,wf4(:,19),12,G2H2(75),m3h4x2(:,109),heltab2x8(:,:,589))
  call Hloop_UW_V(ntryL,G1H8(318),17,wf4(:,20),12,G2H2(76),m3h4x2(:,110),heltab2x8(:,:,590))
  call Hloop_QA_S(ntryL,G1H4(7),ex2(:),G1H2(102),ngH,m3h2x2(:,109),heltab2x4(:,:,109))
  call Hloop_QA_S(ntryL,G1H4(2),ex2(:),G1H2(103),ngPtb,m3h2x2(:,110),heltab2x4(:,:,110))
  call Hloop_QA_S(ntryL,G1H4(8),ex2(:),G1H2(104),ngX,m3h2x2(:,111),heltab2x4(:,:,111))
  call Hloop_QA_S(ntryL,G1H4(6),ex2(:),G1H2(108),ngPtb,m3h2x2(:,112),heltab2x4(:,:,112))
  call Hloop_QA_S(ntryL,G1H4(5),ex2(:),G1H2(109),ngPtb,m3h2x2(:,113),heltab2x4(:,:,113))
  call Hloop_QA_V(ntryL,G1H4(13),ex2(:),G1H2(110),m3h2x2(:,114),heltab2x4(:,:,114))
  call Hloop_QA_Z(ntryL,G1H4(15),ex2(:),G1H2(114),ngZu,m3h2x2(:,115),heltab2x4(:,:,115))
  call Hloop_QA_W(ntryL,G1H4(11),ex2(:),G1H2(115),m3h2x2(:,116),heltab2x4(:,:,116))
  call Hloop_QA_W(ntryL,G1H4(16),ex2(:),G1H2(116),m3h2x2(:,117),heltab2x4(:,:,117))
  call Hloop_QA_W(ntryL,G1H4(14),ex2(:),G1H2(120),m3h2x2(:,118),heltab2x4(:,:,118))
  call Hloop_AQ_S(ntryL,G1H4(17),ex3(:),G1H2(121),ngPtb,m3h2x2(:,119),heltab2x4(:,:,119))
  call Hloop_AQ_S(ntryL,G1H4(31),ex3(:),G1H2(122),ngH,m3h2x2(:,120),heltab2x4(:,:,120))
  call Hloop_AQ_S(ntryL,G1H4(30),ex3(:),G1H2(126),ngPtb,m3h2x2(:,121),heltab2x4(:,:,121))
  call Hloop_AQ_S(ntryL,G1H4(32),ex3(:),G1H2(127),ngX,m3h2x2(:,122),heltab2x4(:,:,122))
  call Hloop_SQ_A(ntryL,G1H4(21),ex3(:),G1H2(128),ngH,m3h2x2(:,123),heltab2x4(:,:,123))
  call Hloop_Q_A(ntryL,G1H2(128),23,nMB,G2H2(77),n2h2(1))
  call Hloop_SQ_A(ntryL,G1H4(22),ex3(:),G1H2(132),ngH,m3h2x2(:,124),heltab2x4(:,:,124))
  call Hloop_Q_A(ntryL,G1H2(132),23,nMB,G2H2(78),n2h2(2))
  call Hloop_SQ_A(ntryL,G1H4(23),ex3(:),G1H2(133),ngX,m3h2x2(:,125),heltab2x4(:,:,125))
  call Hloop_Q_A(ntryL,G1H2(133),23,nMB,G2H2(79),n2h2(3))
  call Hloop_SQ_A(ntryL,G1H4(24),ex3(:),G1H2(134),ngX,m3h2x2(:,126),heltab2x4(:,:,126))
  call Hloop_Q_A(ntryL,G1H2(134),23,nMB,G2H2(80),n2h2(4))
  call Hloop_AQ_V(ntryL,G1H4(42),ex3(:),G1H2(138),m3h2x2(:,127),heltab2x4(:,:,127))
  call Hloop_AQ_Z(ntryL,G1H4(44),ex3(:),G1H2(139),ngZd,m3h2x2(:,128),heltab2x4(:,:,128))
  call Hloop_AQ_W(ntryL,G1H4(27),ex3(:),G1H2(140),m3h2x2(:,129),heltab2x4(:,:,129))
  call Hloop_AQ_W(ntryL,G1H4(43),ex3(:),G1H2(144),m3h2x2(:,130),heltab2x4(:,:,130))
  call Hloop_AQ_S(ntryL,G1H4(29),ex3(:),G1H2(145),ngPtb,m3h2x2(:,131),heltab2x4(:,:,131))
  call Hloop_SQ_A(ntryL,G1H4(33),ex3(:),G1H2(146),ngH,m3h2x2(:,132),heltab2x4(:,:,132))
  call Hloop_Q_A(ntryL,G1H2(146),23,nMB,G2H2(81),n2h2(5))
  call Hloop_SQ_A(ntryL,G1H4(34),ex3(:),G1H2(150),ngX,m3h2x2(:,133),heltab2x4(:,:,133))
  call Hloop_Q_A(ntryL,G1H2(150),23,nMB,G2H2(82),n2h2(6))
  call Hloop_SQ_A(ntryL,G1H4(35),ex3(:),G1H2(151),ngH,m3h2x2(:,134),heltab2x4(:,:,134))
  call Hloop_Q_A(ntryL,G1H2(151),23,nMB,G2H2(83),n2h2(7))
  call Hloop_SQ_A(ntryL,G1H4(36),ex3(:),G1H2(152),ngX,m3h2x2(:,135),heltab2x4(:,:,135))
  call Hloop_Q_A(ntryL,G1H2(152),23,nMB,G2H2(84),n2h2(8))
  call Hloop_VQ_A(ntryL,G1H4(37),ex3(:),G1H2(156),m3h2x2(:,136),heltab2x4(:,:,136))
  call Hloop_Q_A(ntryL,G1H2(156),23,nMB,G2H2(85),n2h2(9))
  call Hloop_VQ_A(ntryL,G1H4(38),ex3(:),G1H2(157),m3h2x2(:,137),heltab2x4(:,:,137))
  call Hloop_Q_A(ntryL,G1H2(157),23,nMB,G2H2(86),n2h2(10))
  call Hloop_ZQ_A(ntryL,G1H4(39),ex3(:),G1H2(158),ngZd,m3h2x2(:,138),heltab2x4(:,:,138))
  call Hloop_Q_A(ntryL,G1H2(158),23,nMB,G2H2(87),n2h2(11))
  call Hloop_ZQ_A(ntryL,G1H4(40),ex3(:),G1H2(162),ngZd,m3h2x2(:,139),heltab2x4(:,:,139))
  call Hloop_Q_A(ntryL,G1H2(162),23,nMB,G2H2(88),n2h2(12))
  call Hloop_AQ_W(ntryL,G1H4(41),ex3(:),G1H2(163),m3h2x2(:,140),heltab2x4(:,:,140))
  call Hloop_VQ_A(ntryL,G1H4(45),ex3(:),G1H2(164),m3h2x2(:,141),heltab2x4(:,:,141))
  call Hloop_Q_A(ntryL,G1H2(164),23,nMB,G2H2(89),n2h2(13))
  call Hloop_VQ_A(ntryL,G1H4(46),ex3(:),G1H2(168),m3h2x2(:,142),heltab2x4(:,:,142))
  call Hloop_Q_A(ntryL,G1H2(168),23,nMB,G2H2(90),n2h2(14))
  call Hloop_ZQ_A(ntryL,G1H4(47),ex3(:),G1H2(169),ngZd,m3h2x2(:,143),heltab2x4(:,:,143))
  call Hloop_Q_A(ntryL,G1H2(169),23,nMB,G2H2(91),n2h2(15))
  call Hloop_ZQ_A(ntryL,G1H4(48),ex3(:),G1H2(170),ngZd,m3h2x2(:,144),heltab2x4(:,:,144))
  call Hloop_Q_A(ntryL,G1H2(170),23,nMB,G2H2(92),n2h2(16))
  call Hloop_SA_Q(ntryL,G1H4(49),ex4(:),G1H2(174),ngH,m3h2x2(:,145),heltab2x4(:,:,145))
  call Hloop_A_Q(ntryL,G1H2(174),27,nMB,G2H2(93),n2h2(17))
  call Hloop_SA_Q(ntryL,G1H4(50),ex4(:),G1H2(175),ngH,m3h2x2(:,146),heltab2x4(:,:,146))
  call Hloop_A_Q(ntryL,G1H2(175),27,nMB,G2H2(94),n2h2(18))
  call Hloop_SA_Q(ntryL,G1H4(51),ex4(:),G1H2(176),ngX,m3h2x2(:,147),heltab2x4(:,:,147))
  call Hloop_A_Q(ntryL,G1H2(176),27,nMB,G2H2(95),n2h2(19))
  call Hloop_SA_Q(ntryL,G1H4(52),ex4(:),G1H2(180),ngX,m3h2x2(:,148),heltab2x4(:,:,148))
  call Hloop_A_Q(ntryL,G1H2(180),27,nMB,G2H2(96),n2h2(20))
  call Hloop_SA_Q(ntryL,G1H4(53),ex4(:),G1H2(181),ngPbt,m3h2x2(:,149),heltab2x4(:,:,149))
  call Hloop_A_Q(ntryL,G1H2(181),27,nMT,G2H2(97),n2h2(21))
  call Hloop_SA_Q(ntryL,G1H4(54),ex4(:),G1H2(182),ngH,m3h2x2(:,150),heltab2x4(:,:,150))
  call Hloop_A_Q(ntryL,G1H2(182),27,nMB,G2H2(98),n2h2(22))
  call Hloop_SA_Q(ntryL,G1H4(55),ex4(:),G1H2(186),ngX,m3h2x2(:,151),heltab2x4(:,:,151))
  call Hloop_A_Q(ntryL,G1H2(186),27,nMB,G2H2(99),n2h2(23))
  call Hloop_SA_Q(ntryL,G1H4(56),ex4(:),G1H2(187),ngH,m3h2x2(:,152),heltab2x4(:,:,152))
  call Hloop_A_Q(ntryL,G1H2(187),27,nMB,G2H2(100),n2h2(24))
  call Hloop_SA_Q(ntryL,G1H4(57),ex4(:),G1H2(188),ngX,m3h2x2(:,153),heltab2x4(:,:,153))
  call Hloop_A_Q(ntryL,G1H2(188),27,nMB,G2H2(101),n2h2(25))
  call Hloop_SA_Q(ntryL,G1H4(58),ex4(:),G1H2(192),ngPbt,m3h2x2(:,154),heltab2x4(:,:,154))
  call Hloop_A_Q(ntryL,G1H2(192),27,nMT,G2H2(102),n2h2(26))
  call Hloop_VA_Q(ntryL,G1H4(59),ex4(:),G1H2(193),m3h2x2(:,155),heltab2x4(:,:,155))
  call Hloop_A_Q(ntryL,G1H2(193),27,nMB,G2H2(103),n2h2(27))
  call Hloop_VA_Q(ntryL,G1H4(60),ex4(:),G1H2(194),m3h2x2(:,156),heltab2x4(:,:,156))
  call Hloop_A_Q(ntryL,G1H2(194),27,nMB,G2H2(104),n2h2(28))
  call Hloop_ZA_Q(ntryL,G1H4(61),ex4(:),G1H2(198),ngZd,m3h2x2(:,157),heltab2x4(:,:,157))
  call Hloop_A_Q(ntryL,G1H2(198),27,nMB,G2H2(105),n2h2(29))
  call Hloop_ZA_Q(ntryL,G1H4(62),ex4(:),G1H2(199),ngZd,m3h2x2(:,158),heltab2x4(:,:,158))
  call Hloop_A_Q(ntryL,G1H2(199),27,nMB,G2H2(106),n2h2(30))
  call Hloop_WA_Q(ntryL,G1H4(63),ex4(:),G1H2(200),m3h2x2(:,159),heltab2x4(:,:,159))
  call Hloop_A_Q(ntryL,G1H2(200),27,nMT,G2H2(107),n2h2(31))
  call Hloop_VA_Q(ntryL,G1H4(64),ex4(:),G1H2(204),m3h2x2(:,160),heltab2x4(:,:,160))
  call Hloop_A_Q(ntryL,G1H2(204),27,nMB,G2H2(108),n2h2(32))
  call Hloop_VA_Q(ntryL,G1H4(65),ex4(:),G1H2(205),m3h2x2(:,161),heltab2x4(:,:,161))
  call Hloop_A_Q(ntryL,G1H2(205),27,nMB,G2H2(109),n2h2(33))
  call Hloop_ZA_Q(ntryL,G1H4(66),ex4(:),G1H2(206),ngZd,m3h2x2(:,162),heltab2x4(:,:,162))
  call Hloop_A_Q(ntryL,G1H2(206),27,nMB,G2H2(110),n2h2(34))
  call Hloop_ZA_Q(ntryL,G1H4(67),ex4(:),G1H2(210),ngZd,m3h2x2(:,163),heltab2x4(:,:,163))
  call Hloop_A_Q(ntryL,G1H2(210),27,nMB,G2H2(111),n2h2(35))
  call Hloop_WA_Q(ntryL,G1H4(68),ex4(:),G1H2(211),m3h2x2(:,164),heltab2x4(:,:,164))
  call Hloop_A_Q(ntryL,G1H2(211),27,nMT,G2H2(112),n2h2(36))
  call Hloop_SQ_A(ntryL,G1H4(69),ex1(:),G1H2(212),ngH,m3h2x2(:,165),heltab2x4(:,:,165))
  call Hloop_Q_A(ntryL,G1H2(212),23,nMT,G2H2(113),n2h2(37))
  call Hloop_SQ_A(ntryL,G1H4(70),ex1(:),G1H2(216),ngPbt,m3h2x2(:,166),heltab2x4(:,:,166))
  call Hloop_Q_A(ntryL,G1H2(216),23,nMB,G2H2(114),n2h2(38))
  call Hloop_SQ_A(ntryL,G1H4(71),ex1(:),G1H2(217),ngX,m3h2x2(:,167),heltab2x4(:,:,167))
  call Hloop_Q_A(ntryL,G1H2(217),23,nMT,G2H2(115),n2h2(39))
  call Hloop_SQ_A(ntryL,G1H4(72),ex1(:),G1H2(218),ngPbt,m3h2x2(:,168),heltab2x4(:,:,168))
  call Hloop_Q_A(ntryL,G1H2(218),23,nMB,G2H2(116),n2h2(40))
  call Hloop_SQ_A(ntryL,G1H4(73),ex1(:),G1H2(222),ngPbt,m3h2x2(:,169),heltab2x4(:,:,169))
  call Hloop_Q_A(ntryL,G1H2(222),23,nMB,G2H2(117),n2h2(41))
  call Hloop_SQ_A(ntryL,G1H4(74),ex1(:),G1H2(223),ngPbt,m3h2x2(:,170),heltab2x4(:,:,170))
  call Hloop_Q_A(ntryL,G1H2(223),23,nMB,G2H2(118),n2h2(42))
  call Hloop_SQ_A(ntryL,G1H4(75),ex1(:),G1H2(224),ngH,m3h2x2(:,171),heltab2x4(:,:,171))
  call Hloop_Q_A(ntryL,G1H2(224),23,nMT,G2H2(119),n2h2(43))
  call Hloop_SQ_A(ntryL,G1H4(76),ex1(:),G1H2(228),ngX,m3h2x2(:,172),heltab2x4(:,:,172))
  call Hloop_Q_A(ntryL,G1H2(228),23,nMT,G2H2(120),n2h2(44))
  call Hloop_VQ_A(ntryL,G1H4(77),ex1(:),G1H2(229),m3h2x2(:,173),heltab2x4(:,:,173))
  call Hloop_Q_A(ntryL,G1H2(229),23,nMT,G2H2(121),n2h2(45))
  call Hloop_ZQ_A(ntryL,G1H4(78),ex1(:),G1H2(230),ngZu,m3h2x2(:,174),heltab2x4(:,:,174))
  call Hloop_Q_A(ntryL,G1H2(230),23,nMT,G2H2(122),n2h2(46))
  call Hloop_WQ_A(ntryL,G1H4(79),ex1(:),G1H2(234),m3h2x2(:,175),heltab2x4(:,:,175))
  call Hloop_Q_A(ntryL,G1H2(234),23,nMB,G2H2(123),n2h2(47))
  call Hloop_WQ_A(ntryL,G1H4(80),ex1(:),G1H2(235),m3h2x2(:,176),heltab2x4(:,:,176))
  call Hloop_Q_A(ntryL,G1H2(235),23,nMB,G2H2(124),n2h2(48))
  call Hloop_VQ_A(ntryL,G1H4(81),ex1(:),G1H2(236),m3h2x2(:,177),heltab2x4(:,:,177))
  call Hloop_Q_A(ntryL,G1H2(236),23,nMT,G2H2(125),n2h2(49))
  call Hloop_WQ_A(ntryL,G1H4(82),ex1(:),G1H2(240),m3h2x2(:,178),heltab2x4(:,:,178))
  call Hloop_Q_A(ntryL,G1H2(240),23,nMB,G2H2(126),n2h2(50))
  call Hloop_ZQ_A(ntryL,G1H4(83),ex1(:),G1H2(241),ngZu,m3h2x2(:,179),heltab2x4(:,:,179))
  call Hloop_Q_A(ntryL,G1H2(241),23,nMT,G2H2(127),n2h2(51))
  call Hloop_WQ_A(ntryL,G1H4(84),ex1(:),G1H2(242),m3h2x2(:,180),heltab2x4(:,:,180))
  call Hloop_Q_A(ntryL,G1H2(242),23,nMB,G2H2(128),n2h2(52))
  call Hloop_SQ_A(ntryL,G1H4(85),ex3(:),G1H2(246),ngH,m3h2x2(:,181),heltab2x4(:,:,181))
  call Hloop_Q_A(ntryL,G1H2(246),23,nMB,G2H2(129),n2h2(53))
  call Hloop_SQ_A(ntryL,G1H4(86),ex3(:),G1H2(247),ngH,m3h2x2(:,182),heltab2x4(:,:,182))
  call Hloop_Q_A(ntryL,G1H2(247),23,nMB,G2H2(130),n2h2(54))
  call Hloop_SQ_A(ntryL,G1H4(87),ex3(:),G1H2(248),ngX,m3h2x2(:,183),heltab2x4(:,:,183))
  call Hloop_Q_A(ntryL,G1H2(248),23,nMB,G2H2(131),n2h2(55))
  call Hloop_SQ_A(ntryL,G1H4(88),ex3(:),G1H2(252),ngX,m3h2x2(:,184),heltab2x4(:,:,184))
  call Hloop_Q_A(ntryL,G1H2(252),23,nMB,G2H2(132),n2h2(56))
  call Hloop_SQ_A(ntryL,G1H4(89),ex3(:),G1H2(253),ngPtb,m3h2x2(:,185),heltab2x4(:,:,185))
  call Hloop_Q_A(ntryL,G1H2(253),23,nMT,G2H2(133),n2h2(57))
  call Hloop_SQ_A(ntryL,G1H4(90),ex3(:),G1H2(254),ngH,m3h2x2(:,186),heltab2x4(:,:,186))
  call Hloop_Q_A(ntryL,G1H2(254),23,nMB,G2H2(134),n2h2(58))
  call Hloop_SQ_A(ntryL,G1H4(91),ex3(:),G1H2(258),ngX,m3h2x2(:,187),heltab2x4(:,:,187))
  call Hloop_Q_A(ntryL,G1H2(258),23,nMB,G2H2(135),n2h2(59))
  call Hloop_SQ_A(ntryL,G1H4(92),ex3(:),G1H2(259),ngH,m3h2x2(:,188),heltab2x4(:,:,188))
  call Hloop_Q_A(ntryL,G1H2(259),23,nMB,G2H2(136),n2h2(60))
  call Hloop_SQ_A(ntryL,G1H4(93),ex3(:),G1H2(260),ngX,m3h2x2(:,189),heltab2x4(:,:,189))
  call Hloop_Q_A(ntryL,G1H2(260),23,nMB,G2H2(137),n2h2(61))
  call Hloop_SQ_A(ntryL,G1H4(94),ex3(:),G1H2(264),ngPtb,m3h2x2(:,190),heltab2x4(:,:,190))
  call Hloop_Q_A(ntryL,G1H2(264),23,nMT,G2H2(138),n2h2(62))
  call Hloop_VQ_A(ntryL,G1H4(95),ex3(:),G1H2(265),m3h2x2(:,191),heltab2x4(:,:,191))
  call Hloop_Q_A(ntryL,G1H2(265),23,nMB,G2H2(139),n2h2(63))
  call Hloop_VQ_A(ntryL,G1H4(96),ex3(:),G1H2(266),m3h2x2(:,192),heltab2x4(:,:,192))
  call Hloop_Q_A(ntryL,G1H2(266),23,nMB,G2H2(140),n2h2(64))
  call Hloop_ZQ_A(ntryL,G1H4(97),ex3(:),G1H2(270),ngZd,m3h2x2(:,193),heltab2x4(:,:,193))
  call Hloop_Q_A(ntryL,G1H2(270),23,nMB,G2H2(141),n2h2(65))
  call Hloop_ZQ_A(ntryL,G1H4(98),ex3(:),G1H2(271),ngZd,m3h2x2(:,194),heltab2x4(:,:,194))
  call Hloop_Q_A(ntryL,G1H2(271),23,nMB,G2H2(142),n2h2(66))
  call Hloop_WQ_A(ntryL,G1H4(99),ex3(:),G1H2(272),m3h2x2(:,195),heltab2x4(:,:,195))
  call Hloop_Q_A(ntryL,G1H2(272),23,nMT,G2H2(143),n2h2(67))
  call Hloop_VQ_A(ntryL,G1H4(100),ex3(:),G1H2(276),m3h2x2(:,196),heltab2x4(:,:,196))
  call Hloop_Q_A(ntryL,G1H2(276),23,nMB,G2H2(144),n2h2(68))
  call Hloop_VQ_A(ntryL,G1H4(101),ex3(:),G1H2(277),m3h2x2(:,197),heltab2x4(:,:,197))
  call Hloop_Q_A(ntryL,G1H2(277),23,nMB,G2H2(145),n2h2(69))
  call Hloop_ZQ_A(ntryL,G1H4(102),ex3(:),G1H2(278),ngZd,m3h2x2(:,198),heltab2x4(:,:,198))
  call Hloop_Q_A(ntryL,G1H2(278),23,nMB,G2H2(146),n2h2(70))
  call Hloop_ZQ_A(ntryL,G1H4(103),ex3(:),G1H2(282),ngZd,m3h2x2(:,199),heltab2x4(:,:,199))
  call Hloop_Q_A(ntryL,G1H2(282),23,nMB,G2H2(147),n2h2(71))
  call Hloop_WQ_A(ntryL,G1H4(104),ex3(:),G1H2(283),m3h2x2(:,200),heltab2x4(:,:,200))
  call Hloop_Q_A(ntryL,G1H2(283),23,nMT,G2H2(148),n2h2(72))
  call Hloop_QA_S(ntryL,G1H4(105),ex4(:),G1H2(284),ngPbt,m3h2x2(:,201),heltab2x4(:,:,201))
  call Hloop_QA_S(ntryL,G1H4(119),ex4(:),G1H2(288),ngH,m3h2x2(:,202),heltab2x4(:,:,202))
  call Hloop_QA_S(ntryL,G1H4(118),ex4(:),G1H2(289),ngPbt,m3h2x2(:,203),heltab2x4(:,:,203))
  call Hloop_QA_S(ntryL,G1H4(120),ex4(:),G1H2(290),ngX,m3h2x2(:,204),heltab2x4(:,:,204))
  call Hloop_SA_Q(ntryL,G1H4(109),ex4(:),G1H2(294),ngH,m3h2x2(:,205),heltab2x4(:,:,205))
  call Hloop_A_Q(ntryL,G1H2(294),27,nMB,G2H2(149),n2h2(73))
  call Hloop_SA_Q(ntryL,G1H4(110),ex4(:),G1H2(295),ngH,m3h2x2(:,206),heltab2x4(:,:,206))
  call Hloop_A_Q(ntryL,G1H2(295),27,nMB,G2H2(150),n2h2(74))
  call Hloop_SA_Q(ntryL,G1H4(111),ex4(:),G1H2(296),ngX,m3h2x2(:,207),heltab2x4(:,:,207))
  call Hloop_A_Q(ntryL,G1H2(296),27,nMB,G2H2(151),n2h2(75))
  call Hloop_SA_Q(ntryL,G1H4(112),ex4(:),G1H2(300),ngX,m3h2x2(:,208),heltab2x4(:,:,208))
  call Hloop_A_Q(ntryL,G1H2(300),27,nMB,G2H2(152),n2h2(76))
  call Hloop_QA_V(ntryL,G1H4(130),ex4(:),G1H2(301),m3h2x2(:,209),heltab2x4(:,:,209))
  call Hloop_QA_Z(ntryL,G1H4(132),ex4(:),G1H2(302),ngZd,m3h2x2(:,210),heltab2x4(:,:,210))
  call Hloop_QA_W(ntryL,G1H4(115),ex4(:),G1H2(306),m3h2x2(:,211),heltab2x4(:,:,211))
  call Hloop_QA_W(ntryL,G1H4(131),ex4(:),G1H2(307),m3h2x2(:,212),heltab2x4(:,:,212))
  call Hloop_QA_S(ntryL,G1H4(117),ex4(:),G1H2(308),ngPbt,m3h2x2(:,213),heltab2x4(:,:,213))
  call Hloop_SA_Q(ntryL,G1H4(121),ex4(:),G1H2(312),ngH,m3h2x2(:,214),heltab2x4(:,:,214))
  call Hloop_A_Q(ntryL,G1H2(312),27,nMB,G2H2(153),n2h2(77))
  call Hloop_SA_Q(ntryL,G1H4(122),ex4(:),G1H2(313),ngX,m3h2x2(:,215),heltab2x4(:,:,215))
  call Hloop_A_Q(ntryL,G1H2(313),27,nMB,G2H2(154),n2h2(78))
  call Hloop_SA_Q(ntryL,G1H4(123),ex4(:),G1H2(314),ngH,m3h2x2(:,216),heltab2x4(:,:,216))
  call Hloop_A_Q(ntryL,G1H2(314),27,nMB,G2H2(155),n2h2(79))
  call Hloop_SA_Q(ntryL,G1H4(124),ex4(:),G1H2(318),ngX,m3h2x2(:,217),heltab2x4(:,:,217))
  call Hloop_A_Q(ntryL,G1H2(318),27,nMB,G2H2(156),n2h2(80))
  call Hloop_VA_Q(ntryL,G1H4(125),ex4(:),G1H2(319),m3h2x2(:,218),heltab2x4(:,:,218))
  call Hloop_A_Q(ntryL,G1H2(319),27,nMB,G2H2(157),n2h2(81))
  call Hloop_VA_Q(ntryL,G1H4(126),ex4(:),G1H2(320),m3h2x2(:,219),heltab2x4(:,:,219))
  call Hloop_A_Q(ntryL,G1H2(320),27,nMB,G2H2(158),n2h2(82))
  call Hloop_ZA_Q(ntryL,G1H4(127),ex4(:),G1H2(324),ngZd,m3h2x2(:,220),heltab2x4(:,:,220))
  call Hloop_A_Q(ntryL,G1H2(324),27,nMB,G2H2(159),n2h2(83))
  call Hloop_ZA_Q(ntryL,G1H4(128),ex4(:),G1H2(325),ngZd,m3h2x2(:,221),heltab2x4(:,:,221))
  call Hloop_A_Q(ntryL,G1H2(325),27,nMB,G2H2(160),n2h2(84))
  call Hloop_QA_W(ntryL,G1H4(129),ex4(:),G1H2(326),m3h2x2(:,222),heltab2x4(:,:,222))
  call Hloop_VA_Q(ntryL,G1H4(133),ex4(:),G1H2(330),m3h2x2(:,223),heltab2x4(:,:,223))
  call Hloop_A_Q(ntryL,G1H2(330),27,nMB,G2H2(161),n2h2(85))
  call Hloop_VA_Q(ntryL,G1H4(134),ex4(:),G1H2(331),m3h2x2(:,224),heltab2x4(:,:,224))
  call Hloop_A_Q(ntryL,G1H2(331),27,nMB,G2H2(162),n2h2(86))
  call Hloop_ZA_Q(ntryL,G1H4(135),ex4(:),G1H2(332),ngZd,m3h2x2(:,225),heltab2x4(:,:,225))
  call Hloop_A_Q(ntryL,G1H2(332),27,nMB,G2H2(163),n2h2(87))
  call Hloop_ZA_Q(ntryL,G1H4(136),ex4(:),G1H2(336),ngZd,m3h2x2(:,226),heltab2x4(:,:,226))
  call Hloop_A_Q(ntryL,G1H2(336),27,nMB,G2H2(164),n2h2(88))
  call Hloop_AQ_S(ntryL,G1H4(137),ex1(:),G1H2(337),ngH,m3h2x2(:,227),heltab2x4(:,:,227))
  call Hloop_AQ_S(ntryL,G1H4(147),ex1(:),G1H2(338),ngH,m3h2x2(:,228),heltab2x4(:,:,228))
  call Hloop_AQ_S(ntryL,G1H4(139),ex1(:),G1H2(342),ngX,m3h2x2(:,229),heltab2x4(:,:,229))
  call Hloop_AQ_S(ntryL,G1H4(148),ex1(:),G1H2(343),ngX,m3h2x2(:,230),heltab2x4(:,:,230))
  call Hloop_SQ_A(ntryL,G1H4(141),ex1(:),G1H2(344),ngH,m3h2x2(:,231),heltab2x4(:,:,231))
  call Hloop_Q_A(ntryL,G1H2(344),23,nMT,G2H2(165),n2h2(89))
  call Hloop_SQ_A(ntryL,G1H4(142),ex1(:),G1H2(348),ngPbt,m3h2x2(:,232),heltab2x4(:,:,232))
  call Hloop_Q_A(ntryL,G1H2(348),23,nMB,G2H2(166),n2h2(90))
  call Hloop_SQ_A(ntryL,G1H4(143),ex1(:),G1H2(349),ngX,m3h2x2(:,233),heltab2x4(:,:,233))
  call Hloop_Q_A(ntryL,G1H2(349),23,nMT,G2H2(167),n2h2(91))
  call Hloop_SQ_A(ntryL,G1H4(144),ex1(:),G1H2(350),ngPbt,m3h2x2(:,234),heltab2x4(:,:,234))
  call Hloop_Q_A(ntryL,G1H2(350),23,nMB,G2H2(168),n2h2(92))
  call Hloop_AQ_S(ntryL,G1H4(145),ex1(:),G1H2(354),ngH,m3h2x2(:,235),heltab2x4(:,:,235))
  call Hloop_AQ_S(ntryL,G1H4(146),ex1(:),G1H2(355),ngX,m3h2x2(:,236),heltab2x4(:,:,236))
  call Hloop_AQ_V(ntryL,G1H4(149),ex1(:),G1H2(356),m3h2x2(:,237),heltab2x4(:,:,237))
  call Hloop_AQ_V(ntryL,G1H4(162),ex1(:),G1H2(360),m3h2x2(:,238),heltab2x4(:,:,238))
  call Hloop_AQ_Z(ntryL,G1H4(151),ex1(:),G1H2(361),ngZu,m3h2x2(:,239),heltab2x4(:,:,239))
  call Hloop_AQ_Z(ntryL,G1H4(164),ex1(:),G1H2(362),ngZu,m3h2x2(:,240),heltab2x4(:,:,240))
  call Hloop_SQ_A(ntryL,G1H4(153),ex1(:),G1H2(366),ngPbt,m3h2x2(:,241),heltab2x4(:,:,241))
  call Hloop_Q_A(ntryL,G1H2(366),23,nMB,G2H2(169),n2h2(93))
  call Hloop_SQ_A(ntryL,G1H4(154),ex1(:),G1H2(367),ngPbt,m3h2x2(:,242),heltab2x4(:,:,242))
  call Hloop_Q_A(ntryL,G1H2(367),23,nMB,G2H2(170),n2h2(94))
  call Hloop_SQ_A(ntryL,G1H4(155),ex1(:),G1H2(368),ngH,m3h2x2(:,243),heltab2x4(:,:,243))
  call Hloop_Q_A(ntryL,G1H2(368),23,nMT,G2H2(171),n2h2(95))
  call Hloop_SQ_A(ntryL,G1H4(156),ex1(:),G1H2(372),ngX,m3h2x2(:,244),heltab2x4(:,:,244))
  call Hloop_Q_A(ntryL,G1H2(372),23,nMT,G2H2(172),n2h2(96))
  call Hloop_VQ_A(ntryL,G1H4(157),ex1(:),G1H2(373),m3h2x2(:,245),heltab2x4(:,:,245))
  call Hloop_Q_A(ntryL,G1H2(373),23,nMT,G2H2(173),n2h2(97))
  call Hloop_ZQ_A(ntryL,G1H4(158),ex1(:),G1H2(374),ngZu,m3h2x2(:,246),heltab2x4(:,:,246))
  call Hloop_Q_A(ntryL,G1H2(374),23,nMT,G2H2(174),n2h2(98))
  call Hloop_WQ_A(ntryL,G1H4(159),ex1(:),G1H2(378),m3h2x2(:,247),heltab2x4(:,:,247))
  call Hloop_Q_A(ntryL,G1H2(378),23,nMB,G2H2(175),n2h2(99))
  call Hloop_WQ_A(ntryL,G1H4(160),ex1(:),G1H2(379),m3h2x2(:,248),heltab2x4(:,:,248))
  call Hloop_Q_A(ntryL,G1H2(379),23,nMB,G2H2(176),n2h2(100))
  call Hloop_AQ_V(ntryL,G1H4(161),ex1(:),G1H2(380),m3h2x2(:,249),heltab2x4(:,:,249))
  call Hloop_AQ_Z(ntryL,G1H4(163),ex1(:),G1H2(384),ngZu,m3h2x2(:,250),heltab2x4(:,:,250))
  call Hloop_VQ_A(ntryL,G1H4(165),ex1(:),G1H2(385),m3h2x2(:,251),heltab2x4(:,:,251))
  call Hloop_Q_A(ntryL,G1H2(385),23,nMT,G2H2(177),n2h2(101))
  call Hloop_WQ_A(ntryL,G1H4(166),ex1(:),G1H2(386),m3h2x2(:,252),heltab2x4(:,:,252))
  call Hloop_Q_A(ntryL,G1H2(386),23,nMB,G2H2(178),n2h2(102))
  call Hloop_ZQ_A(ntryL,G1H4(167),ex1(:),G1H2(390),ngZu,m3h2x2(:,253),heltab2x4(:,:,253))
  call Hloop_Q_A(ntryL,G1H2(390),23,nMT,G2H2(179),n2h2(103))
  call Hloop_WQ_A(ntryL,G1H4(168),ex1(:),G1H2(391),m3h2x2(:,254),heltab2x4(:,:,254))
  call Hloop_Q_A(ntryL,G1H2(391),23,nMB,G2H2(180),n2h2(104))
  call Hloop_QA_S(ntryL,G1H4(169),ex2(:),G1H2(392),ngH,m3h2x2(:,255),heltab2x4(:,:,255))
  call Hloop_QA_S(ntryL,G1H4(170),ex2(:),G1H2(396),ngX,m3h2x2(:,256),heltab2x4(:,:,256))
  call Hloop_QA_S(ntryL,G1H4(181),ex2(:),G1H2(397),ngH,m3h2x2(:,257),heltab2x4(:,:,257))
  call Hloop_QA_S(ntryL,G1H4(182),ex2(:),G1H2(398),ngX,m3h2x2(:,258),heltab2x4(:,:,258))
  call Hloop_QA_S(ntryL,G1H4(183),ex2(:),G1H2(402),ngPtb,m3h2x2(:,259),heltab2x4(:,:,259))
  call Hloop_QA_V(ntryL,G1H4(174),ex2(:),G1H2(403),m3h2x2(:,260),heltab2x4(:,:,260))
  call Hloop_QA_V(ntryL,G1H4(186),ex2(:),G1H2(404),m3h2x2(:,261),heltab2x4(:,:,261))
  call Hloop_QA_Z(ntryL,G1H4(176),ex2(:),G1H2(408),ngZu,m3h2x2(:,262),heltab2x4(:,:,262))
  call Hloop_QA_Z(ntryL,G1H4(187),ex2(:),G1H2(409),ngZu,m3h2x2(:,263),heltab2x4(:,:,263))
  call Hloop_QA_W(ntryL,G1H4(188),ex2(:),G1H2(410),m3h2x2(:,264),heltab2x4(:,:,264))
  call Hloop_QA_S(ntryL,G1H4(179),ex2(:),G1H2(414),ngH,m3h2x2(:,265),heltab2x4(:,:,265))
  call Hloop_QA_S(ntryL,G1H4(180),ex2(:),G1H2(415),ngX,m3h2x2(:,266),heltab2x4(:,:,266))
  call Hloop_QA_V(ntryL,G1H4(184),ex2(:),G1H2(416),m3h2x2(:,267),heltab2x4(:,:,267))
  call Hloop_QA_Z(ntryL,G1H4(185),ex2(:),G1H2(420),ngZu,m3h2x2(:,268),heltab2x4(:,:,268))
  call Hloop_QA_S(ntryL,G1H4(189),ex4(:),G1H2(421),ngPbt,m3h2x2(:,269),heltab2x4(:,:,269))
  call Hloop_QA_S(ntryL,G1H4(199),ex4(:),G1H2(422),ngH,m3h2x2(:,270),heltab2x4(:,:,270))
  call Hloop_QA_S(ntryL,G1H4(198),ex4(:),G1H2(426),ngPbt,m3h2x2(:,271),heltab2x4(:,:,271))
  call Hloop_QA_S(ntryL,G1H4(200),ex4(:),G1H2(427),ngX,m3h2x2(:,272),heltab2x4(:,:,272))
  call Hloop_QA_V(ntryL,G1H4(202),ex4(:),G1H2(428),m3h2x2(:,273),heltab2x4(:,:,273))
  call Hloop_QA_Z(ntryL,G1H4(204),ex4(:),G1H2(432),ngZd,m3h2x2(:,274),heltab2x4(:,:,274))
  call Hloop_QA_W(ntryL,G1H4(195),ex4(:),G1H2(433),m3h2x2(:,275),heltab2x4(:,:,275))
  call Hloop_QA_W(ntryL,G1H4(203),ex4(:),G1H2(434),m3h2x2(:,276),heltab2x4(:,:,276))
  call Hloop_QA_S(ntryL,G1H4(197),ex4(:),G1H2(438),ngPbt,m3h2x2(:,277),heltab2x4(:,:,277))
  call Hloop_QA_W(ntryL,G1H4(201),ex4(:),G1H2(439),m3h2x2(:,278),heltab2x4(:,:,278))
  call Hloop_AQ_S(ntryL,G1H4(205),ex1(:),G1H2(440),ngH,m3h2x2(:,279),heltab2x4(:,:,279))
  call Hloop_AQ_S(ntryL,G1H4(212),ex1(:),G1H2(444),ngH,m3h2x2(:,280),heltab2x4(:,:,280))
  call Hloop_AQ_S(ntryL,G1H4(207),ex1(:),G1H2(445),ngX,m3h2x2(:,281),heltab2x4(:,:,281))
  call Hloop_AQ_S(ntryL,G1H4(213),ex1(:),G1H2(446),ngX,m3h2x2(:,282),heltab2x4(:,:,282))
  call Hloop_AQ_S(ntryL,G1H4(214),ex1(:),G1H2(450),ngPbt,m3h2x2(:,283),heltab2x4(:,:,283))
  call Hloop_AQ_S(ntryL,G1H4(210),ex1(:),G1H2(451),ngH,m3h2x2(:,284),heltab2x4(:,:,284))
  call Hloop_AQ_S(ntryL,G1H4(211),ex1(:),G1H2(452),ngX,m3h2x2(:,285),heltab2x4(:,:,285))
  call Hloop_AQ_V(ntryL,G1H4(215),ex1(:),G1H2(456),m3h2x2(:,286),heltab2x4(:,:,286))
  call Hloop_AQ_V(ntryL,G1H4(221),ex1(:),G1H2(457),m3h2x2(:,287),heltab2x4(:,:,287))
  call Hloop_AQ_Z(ntryL,G1H4(217),ex1(:),G1H2(458),ngZu,m3h2x2(:,288),heltab2x4(:,:,288))
  call Hloop_AQ_Z(ntryL,G1H4(223),ex1(:),G1H2(462),ngZu,m3h2x2(:,289),heltab2x4(:,:,289))
  call Hloop_AQ_W(ntryL,G1H4(224),ex1(:),G1H2(463),m3h2x2(:,290),heltab2x4(:,:,290))
  call Hloop_AQ_V(ntryL,G1H4(220),ex1(:),G1H2(464),m3h2x2(:,291),heltab2x4(:,:,291))
  call Hloop_AQ_Z(ntryL,G1H4(222),ex1(:),G1H2(468),ngZu,m3h2x2(:,292),heltab2x4(:,:,292))
  call Hloop_QA_S(ntryL,G1H4(225),ex2(:),G1H2(469),ngH,m3h2x2(:,293),heltab2x4(:,:,293))
  call Hloop_QA_S(ntryL,G1H4(226),ex2(:),G1H2(470),ngX,m3h2x2(:,294),heltab2x4(:,:,294))
  call Hloop_QA_S(ntryL,G1H4(239),ex2(:),G1H2(474),ngH,m3h2x2(:,295),heltab2x4(:,:,295))
  call Hloop_QA_S(ntryL,G1H4(240),ex2(:),G1H2(475),ngX,m3h2x2(:,296),heltab2x4(:,:,296))
  call Hloop_SA_Q(ntryL,G1H4(229),ex2(:),G1H2(476),ngH,m3h2x2(:,297),heltab2x4(:,:,297))
  call Hloop_A_Q(ntryL,G1H2(476),27,nMT,G2H2(181),n2h2(105))
  call Hloop_SA_Q(ntryL,G1H4(230),ex2(:),G1H2(480),ngPtb,m3h2x2(:,298),heltab2x4(:,:,298))
  call Hloop_A_Q(ntryL,G1H2(480),27,nMB,G2H2(182),n2h2(106))
  call Hloop_SA_Q(ntryL,G1H4(231),ex2(:),G1H2(481),ngX,m3h2x2(:,299),heltab2x4(:,:,299))
  call Hloop_A_Q(ntryL,G1H2(481),27,nMT,G2H2(183),n2h2(107))
  call Hloop_SA_Q(ntryL,G1H4(232),ex2(:),G1H2(482),ngPtb,m3h2x2(:,300),heltab2x4(:,:,300))
  call Hloop_A_Q(ntryL,G1H2(482),27,nMB,G2H2(184),n2h2(108))
  call Hloop_QA_V(ntryL,G1H4(233),ex2(:),G1H2(486),m3h2x2(:,301),heltab2x4(:,:,301))
  call Hloop_QA_V(ntryL,G1H4(251),ex2(:),G1H2(487),m3h2x2(:,302),heltab2x4(:,:,302))
  call Hloop_QA_Z(ntryL,G1H4(235),ex2(:),G1H2(488),ngZu,m3h2x2(:,303),heltab2x4(:,:,303))
  call Hloop_QA_Z(ntryL,G1H4(252),ex2(:),G1H2(492),ngZu,m3h2x2(:,304),heltab2x4(:,:,304))
  call Hloop_QA_S(ntryL,G1H4(237),ex2(:),G1H2(493),ngH,m3h2x2(:,305),heltab2x4(:,:,305))
  call Hloop_QA_S(ntryL,G1H4(238),ex2(:),G1H2(494),ngX,m3h2x2(:,306),heltab2x4(:,:,306))
  call Hloop_SA_Q(ntryL,G1H4(241),ex2(:),G1H2(498),ngPtb,m3h2x2(:,307),heltab2x4(:,:,307))
  call Hloop_A_Q(ntryL,G1H2(498),27,nMB,G2H2(185),n2h2(109))
  call Hloop_SA_Q(ntryL,G1H4(242),ex2(:),G1H2(499),ngPtb,m3h2x2(:,308),heltab2x4(:,:,308))
  call Hloop_A_Q(ntryL,G1H2(499),27,nMB,G2H2(186),n2h2(110))
  call Hloop_SA_Q(ntryL,G1H4(243),ex2(:),G1H2(500),ngH,m3h2x2(:,309),heltab2x4(:,:,309))
  call Hloop_A_Q(ntryL,G1H2(500),27,nMT,G2H2(187),n2h2(111))
  call Hloop_SA_Q(ntryL,G1H4(244),ex2(:),G1H2(504),ngX,m3h2x2(:,310),heltab2x4(:,:,310))
  call Hloop_A_Q(ntryL,G1H2(504),27,nMT,G2H2(188),n2h2(112))
  call Hloop_VA_Q(ntryL,G1H4(245),ex2(:),G1H2(505),m3h2x2(:,311),heltab2x4(:,:,311))
  call Hloop_A_Q(ntryL,G1H2(505),27,nMT,G2H2(189),n2h2(113))
  call Hloop_ZA_Q(ntryL,G1H4(246),ex2(:),G1H2(506),ngZu,m3h2x2(:,312),heltab2x4(:,:,312))
  call Hloop_A_Q(ntryL,G1H2(506),27,nMT,G2H2(190),n2h2(114))
  call Hloop_WA_Q(ntryL,G1H4(247),ex2(:),G1H2(510),m3h2x2(:,313),heltab2x4(:,:,313))
  call Hloop_A_Q(ntryL,G1H2(510),27,nMB,G2H2(191),n2h2(115))
  call Hloop_WA_Q(ntryL,G1H4(248),ex2(:),G1H2(511),m3h2x2(:,314),heltab2x4(:,:,314))
  call Hloop_A_Q(ntryL,G1H2(511),27,nMB,G2H2(192),n2h2(116))
  call Hloop_QA_V(ntryL,G1H4(249),ex2(:),G1H2(512),m3h2x2(:,315),heltab2x4(:,:,315))
  call Hloop_QA_Z(ntryL,G1H4(250),ex2(:),G1H2(516),ngZu,m3h2x2(:,316),heltab2x4(:,:,316))
  call Hloop_VA_Q(ntryL,G1H4(253),ex2(:),G1H2(517),m3h2x2(:,317),heltab2x4(:,:,317))
  call Hloop_A_Q(ntryL,G1H2(517),27,nMT,G2H2(193),n2h2(117))
  call Hloop_WA_Q(ntryL,G1H4(254),ex2(:),G1H2(518),m3h2x2(:,318),heltab2x4(:,:,318))
  call Hloop_A_Q(ntryL,G1H2(518),27,nMB,G2H2(194),n2h2(118))
  call Hloop_ZA_Q(ntryL,G1H4(255),ex2(:),G1H2(522),ngZu,m3h2x2(:,319),heltab2x4(:,:,319))
  call Hloop_A_Q(ntryL,G1H2(522),27,nMT,G2H2(195),n2h2(119))
  call Hloop_WA_Q(ntryL,G1H4(256),ex2(:),G1H2(523),m3h2x2(:,320),heltab2x4(:,:,320))
  call Hloop_A_Q(ntryL,G1H2(523),27,nMB,G2H2(196),n2h2(120))
  call Hloop_SQ_A(ntryL,G1H4(257),ex3(:),G1H2(524),ngH,m3h2x2(:,321),heltab2x4(:,:,321))
  call Hloop_Q_A(ntryL,G1H2(524),29,nMB,G2H2(197),n2h2(121))
  call Hloop_SQ_A(ntryL,G1H4(258),ex3(:),G1H2(528),ngPtb,m3h2x2(:,322),heltab2x4(:,:,322))
  call Hloop_Q_A(ntryL,G1H2(528),29,nMT,G2H2(198),n2h2(122))
  call Hloop_SQ_A(ntryL,G1H4(259),ex3(:),G1H2(529),ngX,m3h2x2(:,323),heltab2x4(:,:,323))
  call Hloop_Q_A(ntryL,G1H2(529),29,nMB,G2H2(199),n2h2(123))
  call Hloop_SQ_A(ntryL,G1H4(260),ex3(:),G1H2(530),ngPtb,m3h2x2(:,324),heltab2x4(:,:,324))
  call Hloop_Q_A(ntryL,G1H2(530),29,nMT,G2H2(200),n2h2(124))
  call Hloop_SQ_A(ntryL,G1H4(261),ex3(:),G1H2(534),ngPtb,m3h2x2(:,325),heltab2x4(:,:,325))
  call Hloop_Q_A(ntryL,G1H2(534),29,nMT,G2H2(201),n2h2(125))
  call Hloop_SQ_A(ntryL,G1H4(262),ex3(:),G1H2(535),ngPtb,m3h2x2(:,326),heltab2x4(:,:,326))
  call Hloop_Q_A(ntryL,G1H2(535),29,nMT,G2H2(202),n2h2(126))
  call Hloop_SQ_A(ntryL,G1H4(263),ex3(:),G1H2(536),ngH,m3h2x2(:,327),heltab2x4(:,:,327))
  call Hloop_Q_A(ntryL,G1H2(536),29,nMB,G2H2(203),n2h2(127))
  call Hloop_SQ_A(ntryL,G1H4(264),ex3(:),G1H2(540),ngX,m3h2x2(:,328),heltab2x4(:,:,328))
  call Hloop_Q_A(ntryL,G1H2(540),29,nMB,G2H2(204),n2h2(128))
  call Hloop_VQ_A(ntryL,G1H4(265),ex3(:),G1H2(541),m3h2x2(:,329),heltab2x4(:,:,329))
  call Hloop_Q_A(ntryL,G1H2(541),29,nMB,G2H2(205),n2h2(129))
  call Hloop_ZQ_A(ntryL,G1H4(266),ex3(:),G1H2(542),ngZd,m3h2x2(:,330),heltab2x4(:,:,330))
  call Hloop_Q_A(ntryL,G1H2(542),29,nMB,G2H2(206),n2h2(130))
  call Hloop_WQ_A(ntryL,G1H4(267),ex3(:),G1H2(546),m3h2x2(:,331),heltab2x4(:,:,331))
  call Hloop_Q_A(ntryL,G1H2(546),29,nMT,G2H2(207),n2h2(131))
  call Hloop_WQ_A(ntryL,G1H4(268),ex3(:),G1H2(547),m3h2x2(:,332),heltab2x4(:,:,332))
  call Hloop_Q_A(ntryL,G1H2(547),29,nMT,G2H2(208),n2h2(132))
  call Hloop_VQ_A(ntryL,G1H4(269),ex3(:),G1H2(548),m3h2x2(:,333),heltab2x4(:,:,333))
  call Hloop_Q_A(ntryL,G1H2(548),29,nMB,G2H2(209),n2h2(133))
  call Hloop_WQ_A(ntryL,G1H4(270),ex3(:),G1H2(552),m3h2x2(:,334),heltab2x4(:,:,334))
  call Hloop_Q_A(ntryL,G1H2(552),29,nMT,G2H2(210),n2h2(134))
  call Hloop_ZQ_A(ntryL,G1H4(271),ex3(:),G1H2(128),ngZd,m3h2x2(:,335),heltab2x4(:,:,335))
  call Hloop_Q_A(ntryL,G1H2(128),29,nMB,G2H2(211),n2h2(135))
  call Hloop_WQ_A(ntryL,G1H4(272),ex3(:),G1H2(132),m3h2x2(:,336),heltab2x4(:,:,336))
  call Hloop_Q_A(ntryL,G1H2(132),29,nMT,G2H2(212),n2h2(136))
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(392),[G1H2(3)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(346),[G1H2(64),G1H2(16),G1H2(4)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(1),[G1H2(89),G1H2(5)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(396),[G1H2(9)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(358),[G1H2(70),G1H2(22),G1H2(10)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(22),[G1H2(7),G1H2(101),G1H2(11)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(397),[G1H2(15)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(23),[G2H2(19),G1H2(24),G1H2(8),G1H2(95),G1H2(17)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(398),[G1H2(21)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(17),[G1H2(2),G1H2(107),G1H2(23)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(402),[G1H2(27)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(388),[G1H2(352),G1H2(340),G1H2(28)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(24),[G2H2(21),G2H2(20),G2H2(18),G1H2(25),G1H2(20),G1H2(6) &
    ,G1H2(29)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(403),[G1H2(33)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(364),[G1H2(76),G1H2(40),G1H2(34)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(125),[G1H2(35)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(404),[G1H2(39)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(131),[G1H2(41)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(408),[G1H2(45)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(370),[G1H2(82),G1H2(52),G1H2(46)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(15),[G1H2(18),G1H2(137),G1H2(47)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(409),[G1H2(51)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(13),[G1H2(12),G1H2(143),G1H2(53)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(410),[G1H2(57)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(394),[G1H2(382),G1H2(376),G1H2(58)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(26),[G2H2(25),G2H2(16),G2H2(14),G1H2(19),G1H2(14) &
    ,G1H2(13),G1H2(59)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(414),[G1H2(63)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(113),[G1H2(65)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(415),[G1H2(69)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(119),[G1H2(71)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(416),[G1H2(75)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(149),[G1H2(77)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(420),[G1H2(81)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(155),[G1H2(83)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(337),[G1H2(87)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(27),[G1H2(112),G1H2(94),G1H2(88)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(338),[G1H2(93)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(342),[G1H2(99)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(28),[G1H2(118),G1H2(106),G1H2(100)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(343),[G1H2(105)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(354),[G1H2(111)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(355),[G1H2(117)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(356),[G1H2(123)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(29),[G1H2(148),G1H2(130),G1H2(124)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(360),[G1H2(129)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(361),[G1H2(135)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(30),[G1H2(154),G1H2(142),G1H2(136)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(362),[G1H2(141)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(380),[G1H2(147)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(384),[G1H2(153)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(284),[G1H2(159)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(3),[G1H2(208),G1H2(172),G1H2(160)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(55),[G1H2(50),G1H2(281),G1H2(161)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(288),[G1H2(165)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(1),[G1H2(166)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(56),[G2H2(53),G1H2(73),G1H2(54),G1H2(287),G1H2(167)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(289),[G1H2(171)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(57),[G2H2(52),G1H2(72),G1H2(293),G1H2(173)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(290),[G1H2(177)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(2),[G1H2(178)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(58),[G2H2(54),G1H2(299),G1H2(179)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(301),[G1H2(183)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(4),[G1H2(184)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(60),[G2H2(47),G1H2(62),G1H2(56),G1H2(311),G1H2(185)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(302),[G1H2(189)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(5),[G1H2(190)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(62),[G2H2(48),G1H2(66),G1H2(61),G1H2(317),G1H2(191)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(306),[G1H2(195)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(6),[G1H2(214),G1H2(202),G1H2(196)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(49),[G1H2(67),G1H2(323),G1H2(197)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(307),[G1H2(201)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(61),[G2H2(50),G1H2(60),G1H2(329),G1H2(203)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(308),[G1H2(207)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(51),[G1H2(68),G1H2(305),G1H2(209)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(326),[G1H2(213)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(59),[G1H2(55),G1H2(335),G1H2(215)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(121),[G1H2(219)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(9),[G1H2(268),G1H2(232),G1H2(220)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(39),[G1H2(26),G1H2(341),G1H2(221)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(122),[G1H2(225)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(7),[G1H2(226)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(40),[G2H2(37),G1H2(49),G1H2(30),G1H2(347),G1H2(227)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(126),[G1H2(231)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(41),[G2H2(36),G1H2(48),G1H2(353),G1H2(233)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(127),[G1H2(237)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(8),[G1H2(238)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(42),[G2H2(38),G1H2(359),G1H2(239)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(138),[G1H2(243)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(10),[G1H2(244)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(44),[G2H2(31),G1H2(38),G1H2(32),G1H2(365),G1H2(245)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(139),[G1H2(249)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(11),[G1H2(250)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(46),[G2H2(32),G1H2(42),G1H2(37),G1H2(371),G1H2(251)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(140),[G1H2(255)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(12),[G1H2(274),G1H2(262),G1H2(256)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(33),[G1H2(43),G1H2(377),G1H2(257)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(144),[G1H2(261)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(45),[G2H2(34),G1H2(36),G1H2(383),G1H2(263)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(145),[G1H2(267)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(35),[G1H2(44),G1H2(389),G1H2(269)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(163),[G1H2(273)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(43),[G1H2(31),G1H2(395),G1H2(275)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(304),[G1H2(292),G1H2(280)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(334),[G1H2(328),G1H2(322)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(103),[G1H2(339)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(102),[G1H2(345)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(108),[G1H2(351)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(104),[G1H2(357)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(110),[G1H2(363)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(114),[G1H2(369)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(115),[G1H2(375)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(116),[G1H2(381)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(109),[G1H2(387)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(120),[G1H2(393)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(460),[G1H2(412),G1H2(400)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(74),[G1H2(485),G1H2(401)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(466),[G1H2(418),G1H2(406)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(72),[G1H2(80),G1H2(491),G1H2(407)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(73),[G2H2(69),G1H2(97),G1H2(84),G1H2(497),G1H2(413)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(67),[G1H2(78),G1H2(503),G1H2(419)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(74),[G2H2(71),G2H2(70),G2H2(68),G1H2(98),G1H2(96) &
    ,G1H2(79),G1H2(425)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(472),[G1H2(436),G1H2(430)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(509),[G1H2(431)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(515),[G1H2(437)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(478),[G1H2(448),G1H2(442)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(65),[G1H2(91),G1H2(521),G1H2(443)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(63),[G1H2(85),G1H2(527),G1H2(449)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(76),[G2H2(75),G2H2(66),G2H2(64),G1H2(92),G1H2(90) &
    ,G1H2(86),G1H2(455)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(533),[G1H2(461)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(539),[G1H2(467)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(545),[G1H2(473)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(551),[G1H2(479)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(532),[G1H2(496),G1H2(484)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(538),[G1H2(502),G1H2(490)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(544),[G1H2(514),G1H2(508)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(550),[G1H2(526),G1H2(520)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(27),[G2H4(17)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(26),[G2H4(28)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(36),[G2H4(34)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(47),[G2H4(35)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(52),[G2H4(48)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(49),[G2H4(51)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(67),[G2H4(63)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(61),[G2H4(62)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(69),[G2H4(66)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(75),[G2H4(68)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(81),[G2H4(76)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(85),[G2H4(73)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(94),[G2H4(84)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(96),[G2H4(79)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(102),[G2H4(100)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(113),[G2H4(91)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(115),[G2H4(93)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(106),[G2H4(97)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(117),[G2H4(108)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(121),[G2H4(119)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(131),[G2H4(111)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(132),[G2H4(112)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(87),[G2H2(79)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(88),[G2H2(80)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(91),[G2H2(82)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(92),[G2H2(84)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(105),[G2H2(95)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(106),[G2H2(96)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(107),[G2H2(97)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(110),[G2H2(99)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(111),[G2H2(101)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(112),[G2H2(102)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(123),[G2H2(114)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(122),[G2H2(115)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(124),[G2H2(116)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(126),[G2H2(117)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(128),[G2H2(118)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(127),[G2H2(120)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(141),[G2H2(131)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(142),[G2H2(132)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(143),[G2H2(133)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(146),[G2H2(135)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(147),[G2H2(137)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(148),[G2H2(138)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(159),[G2H2(151)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(160),[G2H2(152)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(163),[G2H2(154)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(164),[G2H2(156)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(175),[G2H2(166)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(174),[G2H2(167)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(176),[G2H2(168)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(178),[G2H2(169)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(180),[G2H2(170)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(179),[G2H2(172)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(191),[G2H2(182)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(190),[G2H2(183)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(192),[G2H2(184)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(194),[G2H2(185)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(196),[G2H2(186)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(195),[G2H2(188)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(207),[G2H2(198)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(206),[G2H2(199)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(208),[G2H2(200)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(210),[G2H2(201)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(212),[G2H2(202)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(211),[G2H2(204)])
  call Hloop_SA_Q(ntryL,G1H2(392),ex4(:),G1H1(1),ngH,m3h2x1(:,277),heltab2x2(:,:,277))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,nMB,G2tensor(4),n2h1(277))
  call Hloop_SA_Q(ntryL,G1H2(346),ex4(:),G1H1(1),ngH,m3h2x1(:,278),heltab2x2(:,:,278))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,nMB,G2tensor(10),n2h1(278))
  call Hloop_SA_Q(ntryL,G1H2(1),ex4(:),G1H1(1),ngH,m3h2x1(:,279),heltab2x2(:,:,279))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,nMB,G2tensor(13),n2h1(279))
  call Hloop_SA_Q(ntryL,G1H2(396),ex4(:),G1H1(1),ngX,m3h2x1(:,280),heltab2x2(:,:,280))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,nMB,G2tensor(34),n2h1(280))
  call Hloop_SA_Q(ntryL,G1H2(358),ex4(:),G1H1(1),ngX,m3h2x1(:,281),heltab2x2(:,:,281))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,nMB,G2tensor(49),n2h1(281))
  call Hotf_4pt_reduction(G2H2(22),RedSet_4(3),mass4set(:,1),  & 
G1H2(133),G1H2(134),G1H2(146),G1H2(150),G1H2(151),2)
  call HG1shiftOLR(G1H2(134),8,2)
  call Hloop_SA_Q(ntryL,G1H2(397),ex4(:),G1H1(1),ngH,m3h2x1(:,282),heltab2x2(:,:,282))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,nMB,G2tensor(52),n2h1(282))
  call Hotf_4pt_reduction(G2H2(23),RedSet_4(3),mass4set(:,2),  & 
G1H2(152),G1H2(156),G1H2(157),G1H2(158),G1H2(162),2)
  call HG1shiftOLR(G1H2(156),8,2)
  call Hloop_SA_Q(ntryL,G1H2(398),ex4(:),G1H1(1),ngX,m3h2x1(:,283),heltab2x2(:,:,283))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,nMB,G2tensor(58),n2h1(283))
  call Hotf_4pt_reduction(G2H2(17),RedSet_4(3),mass4set(:,3),  & 
G1H2(164),G1H2(168),G1H2(169),G1H2(170),G1H2(174),2)
  call HG1shiftOLR(G1H2(168),8,2)
  call Hloop_SA_Q(ntryL,G1H2(402),ex4(:),G1H1(1),ngPbt,m3h2x1(:,284),heltab2x2(:,:,284))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,nMT,G2tensor(79),n2h1(284))
  call Hloop_SA_Q(ntryL,G1H2(388),ex4(:),G1H1(1),ngPbt,m3h2x1(:,285),heltab2x2(:,:,285))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,nMT,G2tensor(85),n2h1(285))
  call Hotf_4pt_reduction(G2H2(24),RedSet_4(3),mass4set(:,4),  & 
G1H2(175),G1H2(176),G1H2(180),G1H2(181),G1H2(182),2)
  call HG1shiftOLR(G1H2(176),8,2)
  call Hloop_VA_Q(ntryL,G1H2(403),ex4(:),G1H1(1),m3h2x1(:,286),heltab2x2(:,:,286))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,nMB,G2tensor(88),n2h1(286))
  call Hloop_VA_Q(ntryL,G1H2(364),ex4(:),G1H1(1),m3h2x1(:,287),heltab2x2(:,:,287))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,nMB,G2tensor(103),n2h1(287))
  call Hloop_VA_Q(ntryL,G1H2(125),ex4(:),G1H1(1),m3h2x1(:,288),heltab2x2(:,:,288))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,nMB,G2tensor(109),n2h1(288))
  call Hloop_VA_Q(ntryL,G1H2(404),ex4(:),G1H1(1),m3h2x1(:,289),heltab2x2(:,:,289))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,nMB,G2tensor(115),n2h1(289))
  call Hloop_VA_Q(ntryL,G1H2(131),ex4(:),G1H1(1),m3h2x1(:,290),heltab2x2(:,:,290))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,nMB,G2tensor(118),n2h1(290))
  call Hloop_ZA_Q(ntryL,G1H2(408),ex4(:),G1H1(1),ngZd,m3h2x1(:,291),heltab2x2(:,:,291))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,nMB,G2tensor(133),n2h1(291))
  call Hloop_ZA_Q(ntryL,G1H2(370),ex4(:),G1H1(1),ngZd,m3h2x1(:,292),heltab2x2(:,:,292))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,nMB,G2tensor(139),n2h1(292))
  call Hotf_4pt_reduction(G2H2(15),RedSet_4(3),mass4set(:,1),  & 
G1H2(186),G1H2(187),G1H2(188),G1H2(192),G1H2(193),2)
  call HG1shiftOLR(G1H2(187),8,2)
  call Hloop_ZA_Q(ntryL,G1H2(409),ex4(:),G1H1(1),ngZd,m3h2x1(:,293),heltab2x2(:,:,293))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,nMB,G2tensor(145),n2h1(293))
  call Hotf_4pt_reduction(G2H2(13),RedSet_4(3),mass4set(:,3),  & 
G1H2(194),G1H2(198),G1H2(199),G1H2(200),G1H2(204),2)
  call HG1shiftOLR(G1H2(198),8,2)
  call Hloop_WA_Q(ntryL,G1H2(410),ex4(:),G1H1(1),m3h2x1(:,294),heltab2x2(:,:,294))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,nMT,G2tensor(148),n2h1(294))
  call Hloop_WA_Q(ntryL,G1H2(394),ex4(:),G1H1(1),m3h2x1(:,295),heltab2x2(:,:,295))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,nMT,G2tensor(151),n2h1(295))
  call Hotf_4pt_reduction(G2H2(26),RedSet_4(3),mass4set(:,4),  & 
G1H2(205),G1H2(206),G1H2(210),G1H2(211),G1H2(212),2)
  call HG1shiftOLR(G1H2(206),8,2)
  call Hloop_SA_Q(ntryL,G1H2(414),ex4(:),G1H1(1),ngH,m3h2x1(:,296),heltab2x2(:,:,296))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,nMB,G2tensor(169),n2h1(296))
  call Hloop_SA_Q(ntryL,G1H2(113),ex4(:),G1H1(1),ngH,m3h2x1(:,297),heltab2x2(:,:,297))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,nMB,G2tensor(175),n2h1(297))
  call Hloop_SA_Q(ntryL,G1H2(415),ex4(:),G1H1(1),ngX,m3h2x1(:,298),heltab2x2(:,:,298))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,nMB,G2tensor(178),n2h1(298))
  call Hloop_SA_Q(ntryL,G1H2(119),ex4(:),G1H1(1),ngX,m3h2x1(:,299),heltab2x2(:,:,299))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,nMB,G2tensor(193),n2h1(299))
  call Hloop_VA_Q(ntryL,G1H2(416),ex4(:),G1H1(1),m3h2x1(:,300),heltab2x2(:,:,300))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,nMB,G2tensor(202),n2h1(300))
  call Hloop_VA_Q(ntryL,G1H2(149),ex4(:),G1H1(1),m3h2x1(:,301),heltab2x2(:,:,301))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,nMB,G2tensor(208),n2h1(301))
  call Hloop_ZA_Q(ntryL,G1H2(420),ex4(:),G1H1(1),ngZd,m3h2x1(:,302),heltab2x2(:,:,302))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,nMB,G2tensor(211),n2h1(302))
  call Hloop_ZA_Q(ntryL,G1H2(155),ex4(:),G1H1(1),ngZd,m3h2x1(:,303),heltab2x2(:,:,303))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,nMB,G2tensor(232),n2h1(303))
  call Hloop_SA_Q(ntryL,G1H2(337),ex4(:),G1H1(1),ngH,m3h2x1(:,304),heltab2x2(:,:,304))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,nMB,G2tensor(244),n2h1(304))
  call Hotf_4pt_reduction(G2H2(27),RedSet_4(7),mass4set(:,5),  & 
G1H2(216),G1H2(217),G1H2(218),G1H2(222),G1H2(223),2)
  call HG1shiftOLR(G1H2(217),8,2)
  call Hloop_SA_Q(ntryL,G1H2(338),ex4(:),G1H1(1),ngH,m3h2x1(:,305),heltab2x2(:,:,305))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,nMB,G2tensor(250),n2h1(305))
  call Hloop_SA_Q(ntryL,G1H2(342),ex4(:),G1H1(1),ngX,m3h2x1(:,306),heltab2x2(:,:,306))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,nMB,G2tensor(268),n2h1(306))
  call Hotf_4pt_reduction(G2H2(28),RedSet_4(7),mass4set(:,6),  & 
G1H2(224),G1H2(228),G1H2(229),G1H2(230),G1H2(234),2)
  call HG1shiftOLR(G1H2(228),8,2)
  call Hloop_SA_Q(ntryL,G1H2(343),ex4(:),G1H1(1),ngX,m3h2x1(:,307),heltab2x2(:,:,307))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,nMB,G2tensor(1),n2h1(307))
  call Hloop_SA_Q(ntryL,G1H2(354),ex4(:),G1H1(1),ngH,m3h2x1(:,308),heltab2x2(:,:,308))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,nMB,G2tensor(22),n2h1(308))
  call Hloop_SA_Q(ntryL,G1H2(355),ex4(:),G1H1(1),ngX,m3h2x1(:,309),heltab2x2(:,:,309))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,nMB,G2tensor(7),n2h1(309))
  call Hloop_VA_Q(ntryL,G1H2(356),ex4(:),G1H1(1),m3h2x1(:,310),heltab2x2(:,:,310))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,nMB,G2tensor(25),n2h1(310))
  call Hotf_4pt_reduction(G2H2(29),RedSet_4(7),mass4set(:,7),  & 
G1H2(235),G1H2(236),G1H2(240),G1H2(241),G1H2(242),2)
  call HG1shiftOLR(G1H2(236),8,2)
  call Hloop_VA_Q(ntryL,G1H2(360),ex4(:),G1H1(1),m3h2x1(:,311),heltab2x2(:,:,311))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,nMB,G2tensor(28),n2h1(311))
  call Hloop_ZA_Q(ntryL,G1H2(361),ex4(:),G1H1(1),ngZd,m3h2x1(:,312),heltab2x2(:,:,312))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,nMB,G2tensor(16),n2h1(312))
  call Hotf_4pt_reduction(G2H2(30),RedSet_4(7),mass4set(:,6),  & 
G1H2(246),G1H2(247),G1H2(248),G1H2(252),G1H2(253),2)
  call HG1shiftOLR(G1H2(247),8,2)
  call Hloop_ZA_Q(ntryL,G1H2(362),ex4(:),G1H1(1),ngZd,m3h2x1(:,313),heltab2x2(:,:,313))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,nMB,G2tensor(19),n2h1(313))
  call Hloop_VA_Q(ntryL,G1H2(380),ex4(:),G1H1(1),m3h2x1(:,314),heltab2x2(:,:,314))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,nMB,G2tensor(31),n2h1(314))
  call Hloop_ZA_Q(ntryL,G1H2(384),ex4(:),G1H1(1),ngZd,m3h2x1(:,315),heltab2x2(:,:,315))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,nMB,G2tensor(40),n2h1(315))
  call Hloop_SQ_A(ntryL,G1H2(284),ex3(:),G1H1(1),ngPtb,m3h2x1(:,316),heltab2x2(:,:,316))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,nMT,G2tensor(37),n2h1(316))
  call Hotf_4pt_reduction(G2H2(3),RedSet_4(11),mass4set(:,8),  & 
G1H2(254),G1H2(258),G1H2(259),G1H2(260),G1H2(264),2)
  call HG1shiftOLR(G1H2(258),4,2)
  call Hotf_4pt_reduction(G2H2(55),RedSet_4(12),mass4set(:,9),  & 
G1H2(265),G1H2(266),G1H2(270),G1H2(271),G1H2(272),2)
  call HG1shiftOLR(G1H2(266),4,2)
  call Hloop_SQ_A(ntryL,G1H2(288),ex3(:),G1H1(1),ngH,m3h2x1(:,317),heltab2x2(:,:,317))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,nMB,G2tensor(43),n2h1(317))
  call Hotf_4pt_reduction(G2H2(1),RedSet_4(11),mass4set(:,10),  & 
G1H2(276),G1H2(277),G1H2(278),G1H2(282),G1H2(283),2)
  call HG1shiftOLR(G1H2(277),4,2)
  call Hotf_4pt_reduction(G2H2(56),RedSet_4(12),mass4set(:,11),  & 
G1H2(294),G1H2(295),G1H2(296),G1H2(300),G1H2(312),2)
  call HG1shiftOLR(G1H2(295),4,2)
  call Hloop_SQ_A(ntryL,G1H2(289),ex3(:),G1H1(1),ngPtb,m3h2x1(:,318),heltab2x2(:,:,318))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,nMT,G2tensor(46),n2h1(318))
  call Hotf_4pt_reduction(G2H2(57),RedSet_4(12),mass4set(:,12),  & 
G1H2(313),G1H2(314),G1H2(318),G1H2(319),G1H2(320),2)
  call HG1shiftOLR(G1H2(314),4,2)
  call Hloop_SQ_A(ntryL,G1H2(290),ex3(:),G1H1(1),ngX,m3h2x1(:,319),heltab2x2(:,:,319))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,nMB,G2tensor(67),n2h1(319))
  call Hotf_4pt_reduction(G2H2(2),RedSet_4(11),mass4set(:,13),  & 
G1H2(324),G1H2(325),G1H2(330),G1H2(331),G1H2(332),2)
  call HG1shiftOLR(G1H2(325),4,2)
  call Hotf_4pt_reduction(G2H2(58),RedSet_4(12),mass4set(:,14),  & 
G1H2(336),G1H2(344),G1H2(348),G1H2(349),G1H2(350),2)
  call HG1shiftOLR(G1H2(344),4,2)
  call Hloop_VQ_A(ntryL,G1H2(301),ex3(:),G1H1(1),m3h2x1(:,320),heltab2x2(:,:,320))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,nMB,G2tensor(70),n2h1(320))
  call Hotf_4pt_reduction(G2H2(4),RedSet_4(11),mass4set(:,15),  & 
G1H2(366),G1H2(367),G1H2(368),G1H2(372),G1H2(373),2)
  call HG1shiftOLR(G1H2(367),4,2)
  call Hotf_4pt_reduction(G2H2(60),RedSet_4(12),mass4set(:,16),  & 
G1H2(374),G1H2(378),G1H2(379),G1H2(385),G1H2(386),2)
  call HG1shiftOLR(G1H2(378),4,2)
  call Hloop_ZQ_A(ntryL,G1H2(302),ex3(:),G1H1(1),ngZd,m3h2x1(:,321),heltab2x2(:,:,321))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,nMB,G2tensor(55),n2h1(321))
  call Hotf_4pt_reduction(G2H2(5),RedSet_4(11),mass4set(:,13),  & 
G1H2(390),G1H2(391),G1H2(476),G1H2(480),G1H2(481),2)
  call HG1shiftOLR(G1H2(391),4,2)
  call Hotf_4pt_reduction(G2H2(62),RedSet_4(12),mass4set(:,14),  & 
G1H2(482),G1H2(498),G1H2(499),G1H2(500),G1H2(504),2)
  call HG1shiftOLR(G1H2(498),4,2)
  call Hloop_WQ_A(ntryL,G1H2(306),ex3(:),G1H1(1),m3h2x1(:,322),heltab2x2(:,:,322))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,nMT,G2tensor(76),n2h1(322))
  call Hotf_4pt_reduction(G2H2(6),RedSet_4(11),mass4set(:,8),  & 
G1H2(505),G1H2(506),G1H2(510),G1H2(511),G1H2(517),2)
  call HG1shiftOLR(G1H2(506),4,2)
  call Hotf_4pt_reduction(G2H2(49),RedSet_4(12),mass4set(:,9),  & 
G1H2(518),G1H2(522),G1H2(523),G1H2(524),G1H2(528),2)
  call HG1shiftOLR(G1H2(522),4,2)
  call Hloop_WQ_A(ntryL,G1H2(307),ex3(:),G1H1(1),m3h2x1(:,323),heltab2x2(:,:,323))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,nMT,G2tensor(61),n2h1(323))
  call Hotf_4pt_reduction(G2H2(61),RedSet_4(12),mass4set(:,12),  & 
G1H2(529),G1H2(530),G1H2(534),G1H2(535),G1H2(536),2)
  call HG1shiftOLR(G1H2(530),4,2)
  call Hloop_SQ_A(ntryL,G1H2(308),ex3(:),G1H1(1),ngPtb,m3h2x1(:,324),heltab2x2(:,:,324))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,nMT,G2tensor(64),n2h1(324))
  call Hotf_4pt_reduction(G2H2(51),RedSet_4(12),mass4set(:,17),  & 
G1H2(540),G1H2(541),G1H2(542),G1H2(546),G1H2(547),2)
  call HG1shiftOLR(G1H2(541),4,2)
  call Hloop_WQ_A(ntryL,G1H2(326),ex3(:),G1H1(1),m3h2x1(:,325),heltab2x2(:,:,325))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,nMT,G2tensor(73),n2h1(325))
  call Hotf_4pt_reduction(G2H2(59),RedSet_4(12),mass4set(:,17),  & 
G1H2(548),G1H2(552),G1H2(128),G1H2(132),G1H2(3),2)
  call HG1shiftOLR(G1H2(552),4,2)
  call Hloop_SA_Q(ntryL,G1H2(121),ex4(:),G1H1(1),ngPbt,m3h2x1(:,326),heltab2x2(:,:,326))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,nMT,G2tensor(97),n2h1(326))
  call Hotf_4pt_reduction(G2H2(9),RedSet_4(16),mass4set(:,8),  & 
G1H2(64),G1H2(16),G1H2(4),G1H2(89),G1H2(5),2)
  call HG1shiftOLR(G1H2(16),8,2)
  call Hotf_4pt_reduction(G2H2(39),RedSet_4(17),mass4set(:,9),  & 
G1H2(9),G1H2(70),G1H2(22),G1H2(10),G1H2(7),2)
  call HG1shiftOLR(G1H2(70),8,2)
  call Hloop_SA_Q(ntryL,G1H2(122),ex4(:),G1H1(1),ngH,m3h2x1(:,327),heltab2x2(:,:,327))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,nMB,G2tensor(82),n2h1(327))
  call Hotf_4pt_reduction(G2H2(7),RedSet_4(16),mass4set(:,10),  & 
G1H2(101),G1H2(11),G1H2(15),G1H2(24),G1H2(8),2)
  call HG1shiftOLR(G1H2(11),8,2)
  call Hotf_4pt_reduction(G2H2(40),RedSet_4(17),mass4set(:,11),  & 
G1H2(95),G1H2(17),G1H2(21),G1H2(2),G1H2(107),2)
  call HG1shiftOLR(G1H2(17),8,2)
  call Hloop_SA_Q(ntryL,G1H2(126),ex4(:),G1H1(1),ngPbt,m3h2x1(:,328),heltab2x2(:,:,328))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,nMT,G2tensor(100),n2h1(328))
  call Hotf_4pt_reduction(G2H2(41),RedSet_4(17),mass4set(:,12),  & 
G1H2(23),G1H2(27),G1H2(352),G1H2(340),G1H2(28),2)
  call HG1shiftOLR(G1H2(27),8,2)
  call Hloop_SA_Q(ntryL,G1H2(127),ex4(:),G1H1(1),ngX,m3h2x1(:,329),heltab2x2(:,:,329))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,nMB,G2tensor(94),n2h1(329))
  call Hotf_4pt_reduction(G2H2(8),RedSet_4(16),mass4set(:,13),  & 
G1H2(25),G1H2(20),G1H2(6),G1H2(29),G1H2(33),2)
  call HG1shiftOLR(G1H2(20),8,2)
  call Hotf_4pt_reduction(G2H2(42),RedSet_4(17),mass4set(:,14),  & 
G1H2(76),G1H2(40),G1H2(34),G1H2(35),G1H2(39),2)
  call HG1shiftOLR(G1H2(40),8,2)
  call Hloop_VA_Q(ntryL,G1H2(138),ex4(:),G1H1(1),m3h2x1(:,330),heltab2x2(:,:,330))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,nMB,G2tensor(91),n2h1(330))
  call Hotf_4pt_reduction(G2H2(10),RedSet_4(16),mass4set(:,15),  & 
G1H2(41),G1H2(45),G1H2(82),G1H2(52),G1H2(46),2)
  call HG1shiftOLR(G1H2(45),8,2)
  call Hotf_4pt_reduction(G2H2(44),RedSet_4(17),mass4set(:,16),  & 
G1H2(18),G1H2(137),G1H2(47),G1H2(51),G1H2(12),2)
  call HG1shiftOLR(G1H2(137),8,2)
  call Hloop_ZA_Q(ntryL,G1H2(139),ex4(:),G1H1(1),ngZd,m3h2x1(:,331),heltab2x2(:,:,331))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,nMB,G2tensor(106),n2h1(331))
  call Hotf_4pt_reduction(G2H2(11),RedSet_4(16),mass4set(:,13),  & 
G1H2(143),G1H2(53),G1H2(57),G1H2(382),G1H2(376),2)
  call HG1shiftOLR(G1H2(53),8,2)
  call Hotf_4pt_reduction(G2H2(46),RedSet_4(17),mass4set(:,14),  & 
G1H2(58),G1H2(19),G1H2(14),G1H2(13),G1H2(59),2)
  call HG1shiftOLR(G1H2(19),8,2)
  call Hloop_WA_Q(ntryL,G1H2(140),ex4(:),G1H1(1),m3h2x1(:,332),heltab2x2(:,:,332))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,nMT,G2tensor(127),n2h1(332))
  call Hotf_4pt_reduction(G2H2(12),RedSet_4(16),mass4set(:,8),  & 
G1H2(63),G1H2(65),G1H2(69),G1H2(71),G1H2(75),2)
  call HG1shiftOLR(G1H2(65),8,2)
  call Hotf_4pt_reduction(G2H2(33),RedSet_4(17),mass4set(:,9),  & 
G1H2(77),G1H2(81),G1H2(83),G1H2(87),G1H2(112),2)
  call HG1shiftOLR(G1H2(81),8,2)
  call Hloop_WA_Q(ntryL,G1H2(144),ex4(:),G1H1(1),m3h2x1(:,333),heltab2x2(:,:,333))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,nMT,G2tensor(112),n2h1(333))
  call Hotf_4pt_reduction(G2H2(45),RedSet_4(17),mass4set(:,12),  & 
G1H2(94),G1H2(88),G1H2(93),G1H2(99),G1H2(118),2)
  call HG1shiftOLR(G1H2(88),8,2)
  call Hloop_SA_Q(ntryL,G1H2(145),ex4(:),G1H1(1),ngPbt,m3h2x1(:,334),heltab2x2(:,:,334))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,nMT,G2tensor(130),n2h1(334))
  call Hotf_4pt_reduction(G2H2(35),RedSet_4(17),mass4set(:,17),  & 
G1H2(106),G1H2(100),G1H2(105),G1H2(111),G1H2(117),2)
  call HG1shiftOLR(G1H2(100),8,2)
  call Hloop_WA_Q(ntryL,G1H2(163),ex4(:),G1H1(1),m3h2x1(:,335),heltab2x2(:,:,335))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,nMT,G2tensor(124),n2h1(335))
  call Hotf_4pt_reduction(G2H2(43),RedSet_4(17),mass4set(:,17),  & 
G1H2(123),G1H2(148),G1H2(130),G1H2(124),G1H2(129),2)
  call HG1shiftOLR(G1H2(148),8,2)
  call Hloop_SQ_A(ntryL,G1H2(279),ex3(:),G1H1(1),ngPtb,m3h2x1(:,336),heltab2x2(:,:,336))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,nMT,G2tensor(121),n2h1(336))
  call Hloop_SQ_A(ntryL,G1H2(304),ex3(:),G1H1(1),ngPtb,m3h2x1(:,337),heltab2x2(:,:,337))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,nMT,G2tensor(136),n2h1(337))
  call Hloop_SQ_A(ntryL,G1H2(285),ex3(:),G1H1(1),ngH,m3h2x1(:,338),heltab2x2(:,:,338))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,nMB,G2tensor(160),n2h1(338))
  call Hloop_SQ_A(ntryL,G1H2(286),ex3(:),G1H1(1),ngH,m3h2x1(:,339),heltab2x2(:,:,339))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,nMB,G2tensor(142),n2h1(339))
  call Hloop_SQ_A(ntryL,G1H2(291),ex3(:),G1H1(1),ngPtb,m3h2x1(:,340),heltab2x2(:,:,340))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,nMT,G2tensor(163),n2h1(340))
  call Hloop_SQ_A(ntryL,G1H2(297),ex3(:),G1H1(1),ngX,m3h2x1(:,341),heltab2x2(:,:,341))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,nMB,G2tensor(157),n2h1(341))
  call Hloop_SQ_A(ntryL,G1H2(298),ex3(:),G1H1(1),ngX,m3h2x1(:,342),heltab2x2(:,:,342))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,nMB,G2tensor(166),n2h1(342))
  call Hloop_SQ_A(ntryL,G1H2(303),ex3(:),G1H1(1),ngPtb,m3h2x1(:,343),heltab2x2(:,:,343))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,nMT,G2tensor(154),n2h1(343))
  call Hloop_VQ_A(ntryL,G1H2(309),ex3(:),G1H1(1),m3h2x1(:,344),heltab2x2(:,:,344))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,nMB,G2tensor(187),n2h1(344))
  call Hloop_VQ_A(ntryL,G1H2(310),ex3(:),G1H1(1),m3h2x1(:,345),heltab2x2(:,:,345))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,nMB,G2tensor(172),n2h1(345))
  call Hloop_ZQ_A(ntryL,G1H2(315),ex3(:),G1H1(1),ngZd,m3h2x1(:,346),heltab2x2(:,:,346))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,nMB,G2tensor(190),n2h1(346))
  call Hloop_ZQ_A(ntryL,G1H2(316),ex3(:),G1H1(1),ngZd,m3h2x1(:,347),heltab2x2(:,:,347))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,nMB,G2tensor(184),n2h1(347))
  call Hloop_WQ_A(ntryL,G1H2(321),ex3(:),G1H1(1),m3h2x1(:,348),heltab2x2(:,:,348))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,nMT,G2tensor(181),n2h1(348))
  call Hloop_WQ_A(ntryL,G1H2(334),ex3(:),G1H1(1),m3h2x1(:,349),heltab2x2(:,:,349))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,nMT,G2tensor(196),n2h1(349))
  call Hloop_WQ_A(ntryL,G1H2(327),ex3(:),G1H1(1),m3h2x1(:,350),heltab2x2(:,:,350))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,nMT,G2tensor(199),n2h1(350))
  call Hloop_WQ_A(ntryL,G1H2(333),ex3(:),G1H1(1),m3h2x1(:,351),heltab2x2(:,:,351))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,nMT,G2tensor(220),n2h1(351))
  call Hloop_SA_Q(ntryL,G1H2(103),ex4(:),G1H1(1),ngPbt,m3h2x1(:,352),heltab2x2(:,:,352))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,nMT,G2tensor(205),n2h1(352))
  call Hloop_SA_Q(ntryL,G1H2(102),ex4(:),G1H1(1),ngH,m3h2x1(:,353),heltab2x2(:,:,353))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,nMB,G2tensor(223),n2h1(353))
  call Hloop_SA_Q(ntryL,G1H2(108),ex4(:),G1H1(1),ngPbt,m3h2x1(:,354),heltab2x2(:,:,354))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,nMT,G2tensor(226),n2h1(354))
  call Hloop_SA_Q(ntryL,G1H2(104),ex4(:),G1H1(1),ngX,m3h2x1(:,355),heltab2x2(:,:,355))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,nMB,G2tensor(214),n2h1(355))
  call Hloop_VA_Q(ntryL,G1H2(110),ex4(:),G1H1(1),m3h2x1(:,356),heltab2x2(:,:,356))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,nMB,G2tensor(217),n2h1(356))
  call Hloop_ZA_Q(ntryL,G1H2(114),ex4(:),G1H1(1),ngZd,m3h2x1(:,357),heltab2x2(:,:,357))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,nMB,G2tensor(229),n2h1(357))
  call Hloop_WA_Q(ntryL,G1H2(115),ex4(:),G1H1(1),m3h2x1(:,358),heltab2x2(:,:,358))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,nMT,G2tensor(238),n2h1(358))
  call Hloop_WA_Q(ntryL,G1H2(116),ex4(:),G1H1(1),m3h2x1(:,359),heltab2x2(:,:,359))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,nMT,G2tensor(235),n2h1(359))
  call Hloop_SA_Q(ntryL,G1H2(109),ex4(:),G1H1(1),ngPbt,m3h2x1(:,360),heltab2x2(:,:,360))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,nMT,G2tensor(241),n2h1(360))
  call Hloop_WA_Q(ntryL,G1H2(120),ex4(:),G1H1(1),m3h2x1(:,361),heltab2x2(:,:,361))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,nMT,G2tensor(259),n2h1(361))
  call Hloop_SA_Q(ntryL,G1H2(399),ex2(:),G1H1(1),ngH,m3h2x1(:,362),heltab2x2(:,:,362))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,nMT,G2tensor(247),n2h1(362))
  call Hloop_SA_Q(ntryL,G1H2(460),ex2(:),G1H1(1),ngH,m3h2x1(:,363),heltab2x2(:,:,363))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,nMT,G2tensor(262),n2h1(363))
  call Hloop_SA_Q(ntryL,G1H2(74),ex2(:),G1H1(1),ngH,m3h2x1(:,364),heltab2x2(:,:,364))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,nMT,G2tensor(253),n2h1(364))
  call Hloop_SA_Q(ntryL,G1H2(405),ex2(:),G1H1(1),ngX,m3h2x1(:,365),heltab2x2(:,:,365))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,nMT,G2tensor(256),n2h1(365))
  call Hloop_SA_Q(ntryL,G1H2(466),ex2(:),G1H1(1),ngX,m3h2x1(:,366),heltab2x2(:,:,366))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,nMT,G2tensor(265),n2h1(366))
  call Hotf_4pt_reduction(G2H2(72),RedSet_4(29),mass4set(:,18),  & 
G1H2(135),G1H2(154),G1H2(142),G1H2(136),G1H2(141),2)
  call HG1shiftOLR(G1H2(154),2,2)
  call Hloop_SA_Q(ntryL,G1H2(411),ex2(:),G1H1(1),ngH,m3h2x1(:,367),heltab2x2(:,:,367))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,nMT,G2tensor(274),n2h1(367))
  call Hotf_4pt_reduction(G2H2(73),RedSet_4(29),mass4set(:,19),  & 
G1H2(147),G1H2(153),G1H2(159),G1H2(208),G1H2(172),2)
  call HG1shiftOLR(G1H2(153),2,2)
  call Hloop_SA_Q(ntryL,G1H2(417),ex2(:),G1H1(1),ngX,m3h2x1(:,368),heltab2x2(:,:,368))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,nMT,G2tensor(271),n2h1(368))
  call Hotf_4pt_reduction(G2H2(67),RedSet_4(29),mass4set(:,20),  & 
G1H2(160),G1H2(50),G1H2(281),G1H2(161),G1H2(165),2)
  call HG1shiftOLR(G1H2(50),2,2)
  call Hloop_SA_Q(ntryL,G1H2(423),ex2(:),G1H1(1),ngPtb,m3h2x1(:,369),heltab2x2(:,:,369))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,nMB,G2tensor(277),n2h1(369))
  call Hloop_SA_Q(ntryL,G1H2(424),ex2(:),G1H1(1),ngPtb,m3h2x1(:,370),heltab2x2(:,:,370))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,nMB,G2tensor(278),n2h1(370))
  call Hotf_4pt_reduction(G2H2(74),RedSet_4(29),mass4set(:,21),  & 
G1H2(166),G1H2(73),G1H2(54),G1H2(287),G1H2(167),2)
  call HG1shiftOLR(G1H2(73),2,2)
  call Hloop_VA_Q(ntryL,G1H2(429),ex2(:),G1H1(1),m3h2x1(:,371),heltab2x2(:,:,371))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,nMT,G2tensor(279),n2h1(371))
  call Hloop_VA_Q(ntryL,G1H2(472),ex2(:),G1H1(1),m3h2x1(:,372),heltab2x2(:,:,372))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,nMT,G2tensor(280),n2h1(372))
  call Hloop_VA_Q(ntryL,G1H2(509),ex2(:),G1H1(1),m3h2x1(:,373),heltab2x2(:,:,373))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,nMT,G2tensor(281),n2h1(373))
  call Hloop_VA_Q(ntryL,G1H2(435),ex2(:),G1H1(1),m3h2x1(:,374),heltab2x2(:,:,374))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,nMT,G2tensor(282),n2h1(374))
  call Hloop_VA_Q(ntryL,G1H2(515),ex2(:),G1H1(1),m3h2x1(:,375),heltab2x2(:,:,375))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,nMT,G2tensor(283),n2h1(375))
  call Hloop_ZA_Q(ntryL,G1H2(441),ex2(:),G1H1(1),ngZu,m3h2x1(:,376),heltab2x2(:,:,376))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,nMT,G2tensor(284),n2h1(376))
  call Hloop_ZA_Q(ntryL,G1H2(478),ex2(:),G1H1(1),ngZu,m3h2x1(:,377),heltab2x2(:,:,377))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,nMT,G2tensor(285),n2h1(377))
  call Hotf_4pt_reduction(G2H2(65),RedSet_4(29),mass4set(:,18),  & 
G1H2(171),G1H2(72),G1H2(293),G1H2(173),G1H2(177),2)
  call HG1shiftOLR(G1H2(72),2,2)
  call Hloop_ZA_Q(ntryL,G1H2(447),ex2(:),G1H1(1),ngZu,m3h2x1(:,378),heltab2x2(:,:,378))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,nMT,G2tensor(286),n2h1(378))
  call Hotf_4pt_reduction(G2H2(63),RedSet_4(29),mass4set(:,20),  & 
G1H2(178),G1H2(299),G1H2(179),G1H2(183),G1H2(184),2)
  call HG1shiftOLR(G1H2(299),2,2)
  call Hloop_WA_Q(ntryL,G1H2(453),ex2(:),G1H1(1),m3h2x1(:,379),heltab2x2(:,:,379))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,nMB,G2tensor(287),n2h1(379))
  call Hloop_WA_Q(ntryL,G1H2(454),ex2(:),G1H1(1),m3h2x1(:,380),heltab2x2(:,:,380))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,nMB,G2tensor(288),n2h1(380))
  call Hotf_4pt_reduction(G2H2(76),RedSet_4(29),mass4set(:,21),  & 
G1H2(62),G1H2(56),G1H2(311),G1H2(185),G1H2(189),2)
  call HG1shiftOLR(G1H2(56),2,2)
  call Hloop_SA_Q(ntryL,G1H2(459),ex2(:),G1H1(1),ngH,m3h2x1(:,381),heltab2x2(:,:,381))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,nMT,G2tensor(289),n2h1(381))
  call Hloop_SA_Q(ntryL,G1H2(533),ex2(:),G1H1(1),ngH,m3h2x1(:,382),heltab2x2(:,:,382))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,nMT,G2tensor(290),n2h1(382))
  call Hloop_SA_Q(ntryL,G1H2(465),ex2(:),G1H1(1),ngX,m3h2x1(:,383),heltab2x2(:,:,383))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,nMT,G2tensor(291),n2h1(383))
  call Hloop_SA_Q(ntryL,G1H2(539),ex2(:),G1H1(1),ngX,m3h2x1(:,384),heltab2x2(:,:,384))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,nMT,G2tensor(292),n2h1(384))
  call Hloop_VA_Q(ntryL,G1H2(471),ex2(:),G1H1(1),m3h2x1(:,385),heltab2x2(:,:,385))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,nMT,G2tensor(293),n2h1(385))
  call Hloop_VA_Q(ntryL,G1H2(545),ex2(:),G1H1(1),m3h2x1(:,386),heltab2x2(:,:,386))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,nMT,G2tensor(294),n2h1(386))
  call Hloop_ZA_Q(ntryL,G1H2(477),ex2(:),G1H1(1),ngZu,m3h2x1(:,387),heltab2x2(:,:,387))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,nMT,G2tensor(295),n2h1(387))
  call Hloop_ZA_Q(ntryL,G1H2(551),ex2(:),G1H1(1),ngZu,m3h2x1(:,388),heltab2x2(:,:,388))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,nMT,G2tensor(296),n2h1(388))
  call Hloop_SA_Q(ntryL,G1H2(483),ex2(:),G1H1(1),ngH,m3h2x1(:,389),heltab2x2(:,:,389))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,nMT,G2tensor(297),n2h1(389))
  call Hloop_SA_Q(ntryL,G1H2(532),ex2(:),G1H1(1),ngH,m3h2x1(:,390),heltab2x2(:,:,390))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,nMT,G2tensor(298),n2h1(390))
  call Hloop_SA_Q(ntryL,G1H2(489),ex2(:),G1H1(1),ngX,m3h2x1(:,391),heltab2x2(:,:,391))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,nMT,G2tensor(299),n2h1(391))
  call Hloop_SA_Q(ntryL,G1H2(538),ex2(:),G1H1(1),ngX,m3h2x1(:,392),heltab2x2(:,:,392))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,nMT,G2tensor(300),n2h1(392))
  call Hloop_SA_Q(ntryL,G1H2(495),ex2(:),G1H1(1),ngH,m3h2x1(:,393),heltab2x2(:,:,393))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,nMT,G2tensor(301),n2h1(393))
  call Hloop_SA_Q(ntryL,G1H2(501),ex2(:),G1H1(1),ngX,m3h2x1(:,394),heltab2x2(:,:,394))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,nMT,G2tensor(302),n2h1(394))
  call Hloop_VA_Q(ntryL,G1H2(507),ex2(:),G1H1(1),m3h2x1(:,395),heltab2x2(:,:,395))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,nMT,G2tensor(303),n2h1(395))
  call Hloop_VA_Q(ntryL,G1H2(544),ex2(:),G1H1(1),m3h2x1(:,396),heltab2x2(:,:,396))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,nMT,G2tensor(304),n2h1(396))
  call Hloop_VA_Q(ntryL,G1H2(513),ex2(:),G1H1(1),m3h2x1(:,397),heltab2x2(:,:,397))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,nMT,G2tensor(305),n2h1(397))
  call Hloop_ZA_Q(ntryL,G1H2(519),ex2(:),G1H1(1),ngZu,m3h2x1(:,398),heltab2x2(:,:,398))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,nMT,G2tensor(306),n2h1(398))
  call Hloop_ZA_Q(ntryL,G1H2(550),ex2(:),G1H1(1),ngZu,m3h2x1(:,399),heltab2x2(:,:,399))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,nMT,G2tensor(307),n2h1(399))
  call Hloop_ZA_Q(ntryL,G1H2(525),ex2(:),G1H1(1),ngZu,m3h2x1(:,400),heltab2x2(:,:,400))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,nMT,G2tensor(308),n2h1(400))
  call Hloop_SA_Q(ntryL,G1H2(531),ex2(:),G1H1(1),ngH,m3h2x1(:,401),heltab2x2(:,:,401))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,nMT,G2tensor(309),n2h1(401))
  call Hloop_SA_Q(ntryL,G1H2(537),ex2(:),G1H1(1),ngX,m3h2x1(:,402),heltab2x2(:,:,402))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,nMT,G2tensor(310),n2h1(402))
  call Hloop_VA_Q(ntryL,G1H2(543),ex2(:),G1H1(1),m3h2x1(:,403),heltab2x2(:,:,403))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,nMT,G2tensor(311),n2h1(403))
  call Hloop_ZA_Q(ntryL,G1H2(549),ex2(:),G1H1(1),ngZu,m3h2x1(:,404),heltab2x2(:,:,404))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,nMT,G2tensor(312),n2h1(404))
  call Hotf_4pt_reduction(G2H4(16),RedSet_4(33),mass4set(:,22),  & 
G1H4(190),G1H4(191),G1H4(192),G1H4(193),G1H4(194),4)
  call HG1shiftOLR(G1H4(191),6,4)
  call Hotf_4pt_reduction(G2H4(27),RedSet_4(33),mass4set(:,23),  & 
G1H4(196),G1H4(206),G1H4(208),G1H4(209),G1H4(216),4)
  call HG1shiftOLR(G1H4(206),6,4)
  call Hotf_4pt_reduction(G2H4(21),RedSet_4(33),mass4set(:,24),  & 
G1H4(218),G1H4(219),G1H4(227),G1H4(228),G1H4(234),4)
  call HG1shiftOLR(G1H4(219),6,4)
  call Hotf_4pt_reduction(G2H4(23),RedSet_4(33),mass4set(:,22),  & 
G1H4(236),G1H4(1),G1H4(3),G1H4(4),G1H4(9),4)
  call HG1shiftOLR(G1H4(1),6,4)
  call Hotf_4pt_reduction(G2H4(26),RedSet_4(33),mass4set(:,23),  & 
G1H4(10),G1H4(12),G1H4(18),G1H4(19),G1H4(20),4)
  call HG1shiftOLR(G1H4(12),6,4)
  call Hotf_4pt_reduction(G2H4(25),RedSet_4(33),mass4set(:,24),  & 
G1H4(25),G1H4(26),G1H4(28),G1H4(106),G1H4(107),4)
  call HG1shiftOLR(G1H4(26),6,4)
  call Hotf_4pt_reduction(G2H4(29),RedSet_4(35),mass4set(:,22),  & 
G1H4(108),G1H4(113),G1H4(114),G1H4(116),G1H4(138),4)
  call HG1shiftOLR(G1H4(113),9,4)
  call Hotf_4pt_reduction(G2H4(36),RedSet_4(35),mass4set(:,23),  & 
G1H4(140),G1H4(150),G1H4(152),G1H4(171),G1H4(172),4)
  call HG1shiftOLR(G1H4(150),9,4)
  call Hotf_4pt_reduction(G2H4(31),RedSet_4(35),mass4set(:,24),  & 
G1H4(173),G1H4(175),G1H4(177),G1H4(178),G1H4(7),4)
  call HG1shiftOLR(G1H4(175),9,4)
  call Hotf_4pt_reduction(G2H4(33),RedSet_4(35),mass4set(:,22),  & 
G1H4(2),G1H4(8),G1H4(6),G1H4(5),G1H4(13),4)
  call HG1shiftOLR(G1H4(8),9,4)
  call Hotf_4pt_reduction(G2H4(47),RedSet_4(35),mass4set(:,23),  & 
G1H4(15),G1H4(11),G1H4(16),G1H4(14),G1H4(17),4)
  call HG1shiftOLR(G1H4(11),9,4)
  call Hotf_4pt_reduction(G2H4(37),RedSet_4(35),mass4set(:,24),  & 
G1H4(31),G1H4(30),G1H4(32),G1H4(21),G1H4(22),4)
  call HG1shiftOLR(G1H4(30),9,4)
  call Hotf_4pt_reduction(G2H4(46),RedSet_4(8),mass4set(:,25),  & 
G1H4(23),G1H4(24),G1H4(42),G1H4(44),G1H4(27),4)
  call HG1shiftOLR(G1H4(24),9,4)
  call Hotf_4pt_reduction(G2H4(52),RedSet_4(8),mass4set(:,26),  & 
G1H4(43),G1H4(29),G1H4(33),G1H4(34),G1H4(35),4)
  call HG1shiftOLR(G1H4(29),9,4)
  call Hotf_4pt_reduction(G2H4(50),RedSet_4(8),mass4set(:,27),  & 
G1H4(36),G1H4(37),G1H4(38),G1H4(39),G1H4(40),4)
  call HG1shiftOLR(G1H4(37),9,4)
  call Hotf_4pt_reduction(G2H4(43),RedSet_4(8),mass4set(:,25),  & 
G1H4(41),G1H4(45),G1H4(46),G1H4(47),G1H4(48),4)
  call HG1shiftOLR(G1H4(45),9,4)
  call Hotf_4pt_reduction(G2H4(49),RedSet_4(8),mass4set(:,26),  & 
G1H4(49),G1H4(50),G1H4(51),G1H4(52),G1H4(53),4)
  call HG1shiftOLR(G1H4(50),9,4)
  call Hotf_4pt_reduction(G2H4(45),RedSet_4(8),mass4set(:,27),  & 
G1H4(54),G1H4(55),G1H4(56),G1H4(57),G1H4(58),4)
  call HG1shiftOLR(G1H4(55),9,4)
  call Hotf_4pt_reduction(G2H4(53),RedSet_4(18),mass4set(:,28),  & 
G1H4(59),G1H4(60),G1H4(61),G1H4(62),G1H4(63),4)
  call HG1shiftOLR(G1H4(60),12,4)
  call Hotf_4pt_reduction(G2H4(67),RedSet_4(18),mass4set(:,29),  & 
G1H4(64),G1H4(65),G1H4(66),G1H4(67),G1H4(68),4)
  call HG1shiftOLR(G1H4(65),12,4)
  call Hotf_4pt_reduction(G2H4(61),RedSet_4(18),mass4set(:,30),  & 
G1H4(69),G1H4(70),G1H4(71),G1H4(72),G1H4(73),4)
  call HG1shiftOLR(G1H4(70),12,4)
  call Hotf_4pt_reduction(G2H4(64),RedSet_4(18),mass4set(:,28),  & 
G1H4(74),G1H4(75),G1H4(76),G1H4(77),G1H4(78),4)
  call HG1shiftOLR(G1H4(75),12,4)
  call Hotf_4pt_reduction(G2H4(69),RedSet_4(18),mass4set(:,29),  & 
G1H4(79),G1H4(80),G1H4(81),G1H4(82),G1H4(83),4)
  call HG1shiftOLR(G1H4(80),12,4)
  call Hotf_4pt_reduction(G2H4(75),RedSet_4(18),mass4set(:,30),  & 
G1H4(84),G1H4(85),G1H4(86),G1H4(87),G1H4(88),4)
  call HG1shiftOLR(G1H4(85),12,4)
  call Hotf_4pt_reduction(G2H4(59),RedSet_4(18),mass4set(:,31),  & 
G1H4(89),G1H4(90),G1H4(91),G1H4(92),G1H4(93),4)
  call HG1shiftOLR(G1H4(90),12,4)
  call Hotf_4pt_reduction(G2H4(65),RedSet_4(18),mass4set(:,31),  & 
G1H4(94),G1H4(95),G1H4(96),G1H4(97),G1H4(98),4)
  call HG1shiftOLR(G1H4(95),12,4)
  call Hotf_4pt_reduction(G2H4(74),RedSet_4(18),mass4set(:,28),  & 
G1H4(99),G1H4(100),G1H4(101),G1H4(102),G1H4(103),4)
  call HG1shiftOLR(G1H4(100),12,4)
  call Hotf_4pt_reduction(G2H4(81),RedSet_4(18),mass4set(:,29),  & 
G1H4(104),G1H4(105),G1H4(119),G1H4(118),G1H4(120),4)
  call HG1shiftOLR(G1H4(105),12,4)
  call Hotf_4pt_reduction(G2H4(85),RedSet_4(18),mass4set(:,30),  & 
G1H4(109),G1H4(110),G1H4(111),G1H4(112),G1H4(130),4)
  call HG1shiftOLR(G1H4(110),12,4)
  call Hotf_4pt_reduction(G2H4(82),RedSet_4(18),mass4set(:,28),  & 
G1H4(132),G1H4(115),G1H4(131),G1H4(117),G1H4(121),4)
  call HG1shiftOLR(G1H4(115),12,4)
  call Hotf_4pt_reduction(G2H4(94),RedSet_4(18),mass4set(:,29),  & 
G1H4(122),G1H4(123),G1H4(124),G1H4(125),G1H4(126),4)
  call HG1shiftOLR(G1H4(123),12,4)
  call Hotf_4pt_reduction(G2H4(96),RedSet_4(18),mass4set(:,30),  & 
G1H4(127),G1H4(128),G1H4(129),G1H4(133),G1H4(134),4)
  call HG1shiftOLR(G1H4(128),12,4)
  call Hotf_4pt_reduction(G2H4(83),RedSet_4(18),mass4set(:,31),  & 
G1H4(135),G1H4(136),G1H4(137),G1H4(147),G1H4(139),4)
  call HG1shiftOLR(G1H4(136),12,4)
  call Hotf_4pt_reduction(G2H4(95),RedSet_4(18),mass4set(:,31),  & 
G1H4(148),G1H4(141),G1H4(142),G1H4(143),G1H4(144),4)
  call HG1shiftOLR(G1H4(141),12,4)
  call Hotf_4pt_reduction(G2H4(98),RedSet_4(13),mass4set(:,28),  & 
G1H4(145),G1H4(146),G1H4(149),G1H4(162),G1H4(151),4)
  call HG1shiftOLR(G1H4(146),12,4)
  call Hotf_4pt_reduction(G2H4(102),RedSet_4(13),mass4set(:,29),  & 
G1H4(164),G1H4(153),G1H4(154),G1H4(155),G1H4(156),4)
  call HG1shiftOLR(G1H4(153),12,4)
  call Hotf_4pt_reduction(G2H4(113),RedSet_4(13),mass4set(:,30),  & 
G1H4(157),G1H4(158),G1H4(159),G1H4(160),G1H4(161),4)
  call HG1shiftOLR(G1H4(158),12,4)
  call Hotf_4pt_reduction(G2H4(99),RedSet_4(13),mass4set(:,28),  & 
G1H4(163),G1H4(165),G1H4(166),G1H4(167),G1H4(168),4)
  call HG1shiftOLR(G1H4(165),12,4)
  call Hotf_4pt_reduction(G2H4(115),RedSet_4(13),mass4set(:,29),  & 
G1H4(169),G1H4(170),G1H4(181),G1H4(182),G1H4(183),4)
  call HG1shiftOLR(G1H4(170),12,4)
  call Hotf_4pt_reduction(G2H4(106),RedSet_4(13),mass4set(:,30),  & 
G1H4(174),G1H4(186),G1H4(176),G1H4(187),G1H4(188),4)
  call HG1shiftOLR(G1H4(186),12,4)
  call Hotf_4pt_reduction(G2H4(101),RedSet_4(13),mass4set(:,31),  & 
G1H4(179),G1H4(180),G1H4(184),G1H4(185),G1H4(189),4)
  call HG1shiftOLR(G1H4(180),12,4)
  call Hotf_4pt_reduction(G2H4(114),RedSet_4(13),mass4set(:,31),  & 
G1H4(199),G1H4(198),G1H4(200),G1H4(202),G1H4(204),4)
  call HG1shiftOLR(G1H4(198),12,4)
  call Hotf_4pt_reduction(G2H4(118),RedSet_4(13),mass4set(:,28),  & 
G1H4(195),G1H4(203),G1H4(197),G1H4(201),G1H4(205),4)
  call HG1shiftOLR(G1H4(203),12,4)
  call Hotf_4pt_reduction(G2H4(117),RedSet_4(13),mass4set(:,29),  & 
G1H4(212),G1H4(207),G1H4(213),G1H4(214),G1H4(210),4)
  call HG1shiftOLR(G1H4(207),12,4)
  call Hotf_4pt_reduction(G2H4(121),RedSet_4(13),mass4set(:,30),  & 
G1H4(211),G1H4(215),G1H4(221),G1H4(217),G1H4(223),4)
  call HG1shiftOLR(G1H4(215),12,4)
  call Hotf_4pt_reduction(G2H4(120),RedSet_4(13),mass4set(:,28),  & 
G1H4(224),G1H4(220),G1H4(222),G1H4(225),G1H4(226),4)
  call HG1shiftOLR(G1H4(220),12,4)
  call Hotf_4pt_reduction(G2H4(131),RedSet_4(13),mass4set(:,29),  & 
G1H4(239),G1H4(240),G1H4(229),G1H4(230),G1H4(231),4)
  call HG1shiftOLR(G1H4(240),12,4)
  call Hotf_4pt_reduction(G2H4(132),RedSet_4(13),mass4set(:,30),  & 
G1H4(232),G1H4(233),G1H4(251),G1H4(235),G1H4(252),4)
  call HG1shiftOLR(G1H4(233),12,4)
  call Hotf_4pt_reduction(G2H4(116),RedSet_4(13),mass4set(:,31),  & 
G1H4(237),G1H4(238),G1H4(241),G1H4(242),G1H4(243),4)
  call HG1shiftOLR(G1H4(238),12,4)
  call Hotf_4pt_reduction(G2H4(122),RedSet_4(13),mass4set(:,31),  & 
G1H4(244),G1H4(245),G1H4(246),G1H4(247),G1H4(248),4)
  call HG1shiftOLR(G1H4(245),12,4)
  call Hcheck_last_QA_S(ntryL,l_switch,G2H2(77),ex4(:),G2tensor(313),ngH,m3h2x1(:,405),heltab2x2(:,:,405))
  call Hcheck_last_QA_S(ntryL,l_switch,G2H2(78),ex4(:),G2tensor(314),ngX,m3h2x1(:,406),heltab2x2(:,:,406))
  call Hcheck_last_QA_S(ntryL,l_switch,G2H2(87),ex4(:),G2tensor(315),ngH,m3h2x1(:,407),heltab2x2(:,:,407))
  call Hcheck_last_QA_S(ntryL,l_switch,G2H2(88),ex4(:),G2tensor(316),ngX,m3h2x1(:,408),heltab2x2(:,:,408))
  call Hcheck_last_QA_V(ntryL,l_switch,G2H2(81),ex4(:),G2tensor(317),m3h2x1(:,409),heltab2x2(:,:,409))
  call Hcheck_last_QA_V(ntryL,l_switch,G2H2(91),ex4(:),G2tensor(318),m3h2x1(:,410),heltab2x2(:,:,410))
  call Hcheck_last_QA_Z(ntryL,l_switch,G2H2(83),ex4(:),G2tensor(319),ngZd,m3h2x1(:,411),heltab2x2(:,:,411))
  call Hcheck_last_QA_Z(ntryL,l_switch,G2H2(92),ex4(:),G2tensor(320),ngZd,m3h2x1(:,412),heltab2x2(:,:,412))
  call Hcheck_last_QA_S(ntryL,l_switch,G2H2(85),ex4(:),G2tensor(321),ngH,m3h2x1(:,413),heltab2x2(:,:,413))
  call Hcheck_last_QA_S(ntryL,l_switch,G2H2(86),ex4(:),G2tensor(322),ngX,m3h2x1(:,414),heltab2x2(:,:,414))
  call Hcheck_last_QA_V(ntryL,l_switch,G2H2(89),ex4(:),G2tensor(323),m3h2x1(:,415),heltab2x2(:,:,415))
  call Hcheck_last_QA_Z(ntryL,l_switch,G2H2(90),ex4(:),G2tensor(324),ngZd,m3h2x1(:,416),heltab2x2(:,:,416))
  call Hcheck_last_AQ_S(ntryL,l_switch,G2H2(93),ex3(:),G2tensor(325),ngH,m3h2x1(:,417),heltab2x2(:,:,417))
  call Hcheck_last_AQ_S(ntryL,l_switch,G2H2(94),ex3(:),G2tensor(326),ngX,m3h2x1(:,418),heltab2x2(:,:,418))
  call Hcheck_last_AQ_S(ntryL,l_switch,G2H2(105),ex3(:),G2tensor(327),ngH,m3h2x1(:,419),heltab2x2(:,:,419))
  call Hcheck_last_AQ_S(ntryL,l_switch,G2H2(106),ex3(:),G2tensor(328),ngX,m3h2x1(:,420),heltab2x2(:,:,420))
  call Hcheck_last_AQ_S(ntryL,l_switch,G2H2(107),ex3(:),G2tensor(329),ngPtb,m3h2x1(:,421),heltab2x2(:,:,421))
  call Hcheck_last_AQ_V(ntryL,l_switch,G2H2(98),ex3(:),G2tensor(330),m3h2x1(:,422),heltab2x2(:,:,422))
  call Hcheck_last_AQ_V(ntryL,l_switch,G2H2(110),ex3(:),G2tensor(331),m3h2x1(:,423),heltab2x2(:,:,423))
  call Hcheck_last_AQ_Z(ntryL,l_switch,G2H2(100),ex3(:),G2tensor(332),ngZd,m3h2x1(:,424),heltab2x2(:,:,424))
  call Hcheck_last_AQ_Z(ntryL,l_switch,G2H2(111),ex3(:),G2tensor(333),ngZd,m3h2x1(:,425),heltab2x2(:,:,425))
  call Hcheck_last_AQ_W(ntryL,l_switch,G2H2(112),ex3(:),G2tensor(334),m3h2x1(:,426),heltab2x2(:,:,426))
  call Hcheck_last_AQ_S(ntryL,l_switch,G2H2(103),ex3(:),G2tensor(335),ngH,m3h2x1(:,427),heltab2x2(:,:,427))
  call Hcheck_last_AQ_S(ntryL,l_switch,G2H2(104),ex3(:),G2tensor(336),ngX,m3h2x1(:,428),heltab2x2(:,:,428))
  call Hcheck_last_AQ_V(ntryL,l_switch,G2H2(108),ex3(:),G2tensor(337),m3h2x1(:,429),heltab2x2(:,:,429))
  call Hcheck_last_AQ_Z(ntryL,l_switch,G2H2(109),ex3(:),G2tensor(338),ngZd,m3h2x1(:,430),heltab2x2(:,:,430))
  call Hcheck_last_QA_S(ntryL,l_switch,G2H2(113),ex4(:),G2tensor(339),ngPbt,m3h2x1(:,431),heltab2x2(:,:,431))
  call Hcheck_last_QA_S(ntryL,l_switch,G2H2(123),ex4(:),G2tensor(340),ngH,m3h2x1(:,432),heltab2x2(:,:,432))
  call Hcheck_last_QA_S(ntryL,l_switch,G2H2(122),ex4(:),G2tensor(341),ngPbt,m3h2x1(:,433),heltab2x2(:,:,433))
  call Hcheck_last_QA_S(ntryL,l_switch,G2H2(124),ex4(:),G2tensor(342),ngX,m3h2x1(:,434),heltab2x2(:,:,434))
  call Hcheck_last_QA_V(ntryL,l_switch,G2H2(126),ex4(:),G2tensor(343),m3h2x1(:,435),heltab2x2(:,:,435))
  call Hcheck_last_QA_Z(ntryL,l_switch,G2H2(128),ex4(:),G2tensor(344),ngZd,m3h2x1(:,436),heltab2x2(:,:,436))
  call Hcheck_last_QA_W(ntryL,l_switch,G2H2(119),ex4(:),G2tensor(345),m3h2x1(:,437),heltab2x2(:,:,437))
  call Hcheck_last_QA_W(ntryL,l_switch,G2H2(127),ex4(:),G2tensor(346),m3h2x1(:,438),heltab2x2(:,:,438))
  call Hcheck_last_QA_S(ntryL,l_switch,G2H2(121),ex4(:),G2tensor(347),ngPbt,m3h2x1(:,439),heltab2x2(:,:,439))
  call Hcheck_last_QA_W(ntryL,l_switch,G2H2(125),ex4(:),G2tensor(348),m3h2x1(:,440),heltab2x2(:,:,440))
  call Hcheck_last_QA_S(ntryL,l_switch,G2H2(129),ex4(:),G2tensor(349),ngH,m3h2x1(:,441),heltab2x2(:,:,441))
  call Hcheck_last_QA_S(ntryL,l_switch,G2H2(130),ex4(:),G2tensor(350),ngX,m3h2x1(:,442),heltab2x2(:,:,442))
  call Hcheck_last_QA_S(ntryL,l_switch,G2H2(141),ex4(:),G2tensor(351),ngH,m3h2x1(:,443),heltab2x2(:,:,443))
  call Hcheck_last_QA_S(ntryL,l_switch,G2H2(142),ex4(:),G2tensor(352),ngX,m3h2x1(:,444),heltab2x2(:,:,444))
  call Hcheck_last_QA_S(ntryL,l_switch,G2H2(143),ex4(:),G2tensor(353),ngPbt,m3h2x1(:,445),heltab2x2(:,:,445))
  call Hcheck_last_QA_V(ntryL,l_switch,G2H2(134),ex4(:),G2tensor(354),m3h2x1(:,446),heltab2x2(:,:,446))
  call Hcheck_last_QA_V(ntryL,l_switch,G2H2(146),ex4(:),G2tensor(355),m3h2x1(:,447),heltab2x2(:,:,447))
  call Hcheck_last_QA_Z(ntryL,l_switch,G2H2(136),ex4(:),G2tensor(356),ngZd,m3h2x1(:,448),heltab2x2(:,:,448))
  call Hcheck_last_QA_Z(ntryL,l_switch,G2H2(147),ex4(:),G2tensor(357),ngZd,m3h2x1(:,449),heltab2x2(:,:,449))
  call Hcheck_last_QA_W(ntryL,l_switch,G2H2(148),ex4(:),G2tensor(358),m3h2x1(:,450),heltab2x2(:,:,450))
  call Hcheck_last_QA_S(ntryL,l_switch,G2H2(139),ex4(:),G2tensor(359),ngH,m3h2x1(:,451),heltab2x2(:,:,451))
  call Hcheck_last_QA_S(ntryL,l_switch,G2H2(140),ex4(:),G2tensor(360),ngX,m3h2x1(:,452),heltab2x2(:,:,452))
  call Hcheck_last_QA_V(ntryL,l_switch,G2H2(144),ex4(:),G2tensor(361),m3h2x1(:,453),heltab2x2(:,:,453))
  call Hcheck_last_QA_Z(ntryL,l_switch,G2H2(145),ex4(:),G2tensor(362),ngZd,m3h2x1(:,454),heltab2x2(:,:,454))
  call Hcheck_last_AQ_S(ntryL,l_switch,G2H2(149),ex3(:),G2tensor(363),ngH,m3h2x1(:,455),heltab2x2(:,:,455))
  call Hcheck_last_AQ_S(ntryL,l_switch,G2H2(150),ex3(:),G2tensor(364),ngX,m3h2x1(:,456),heltab2x2(:,:,456))
  call Hcheck_last_AQ_S(ntryL,l_switch,G2H2(159),ex3(:),G2tensor(365),ngH,m3h2x1(:,457),heltab2x2(:,:,457))
  call Hcheck_last_AQ_S(ntryL,l_switch,G2H2(160),ex3(:),G2tensor(366),ngX,m3h2x1(:,458),heltab2x2(:,:,458))
  call Hcheck_last_AQ_V(ntryL,l_switch,G2H2(153),ex3(:),G2tensor(367),m3h2x1(:,459),heltab2x2(:,:,459))
  call Hcheck_last_AQ_V(ntryL,l_switch,G2H2(163),ex3(:),G2tensor(368),m3h2x1(:,460),heltab2x2(:,:,460))
  call Hcheck_last_AQ_Z(ntryL,l_switch,G2H2(155),ex3(:),G2tensor(369),ngZd,m3h2x1(:,461),heltab2x2(:,:,461))
  call Hcheck_last_AQ_Z(ntryL,l_switch,G2H2(164),ex3(:),G2tensor(370),ngZd,m3h2x1(:,462),heltab2x2(:,:,462))
  call Hcheck_last_AQ_S(ntryL,l_switch,G2H2(157),ex3(:),G2tensor(371),ngH,m3h2x1(:,463),heltab2x2(:,:,463))
  call Hcheck_last_AQ_S(ntryL,l_switch,G2H2(158),ex3(:),G2tensor(372),ngX,m3h2x1(:,464),heltab2x2(:,:,464))
  call Hcheck_last_AQ_V(ntryL,l_switch,G2H2(161),ex3(:),G2tensor(373),m3h2x1(:,465),heltab2x2(:,:,465))
  call Hcheck_last_AQ_Z(ntryL,l_switch,G2H2(162),ex3(:),G2tensor(374),ngZd,m3h2x1(:,466),heltab2x2(:,:,466))
  call Hcheck_last_QA_S(ntryL,l_switch,G2H2(165),ex4(:),G2tensor(375),ngPbt,m3h2x1(:,467),heltab2x2(:,:,467))
  call Hcheck_last_QA_S(ntryL,l_switch,G2H2(175),ex4(:),G2tensor(376),ngH,m3h2x1(:,468),heltab2x2(:,:,468))
  call Hcheck_last_QA_S(ntryL,l_switch,G2H2(174),ex4(:),G2tensor(377),ngPbt,m3h2x1(:,469),heltab2x2(:,:,469))
  call Hcheck_last_QA_S(ntryL,l_switch,G2H2(176),ex4(:),G2tensor(378),ngX,m3h2x1(:,470),heltab2x2(:,:,470))
  call Hcheck_last_QA_V(ntryL,l_switch,G2H2(178),ex4(:),G2tensor(379),m3h2x1(:,471),heltab2x2(:,:,471))
  call Hcheck_last_QA_Z(ntryL,l_switch,G2H2(180),ex4(:),G2tensor(380),ngZd,m3h2x1(:,472),heltab2x2(:,:,472))
  call Hcheck_last_QA_W(ntryL,l_switch,G2H2(171),ex4(:),G2tensor(381),m3h2x1(:,473),heltab2x2(:,:,473))
  call Hcheck_last_QA_W(ntryL,l_switch,G2H2(179),ex4(:),G2tensor(382),m3h2x1(:,474),heltab2x2(:,:,474))
  call Hcheck_last_QA_S(ntryL,l_switch,G2H2(173),ex4(:),G2tensor(383),ngPbt,m3h2x1(:,475),heltab2x2(:,:,475))
  call Hcheck_last_QA_W(ntryL,l_switch,G2H2(177),ex4(:),G2tensor(384),m3h2x1(:,476),heltab2x2(:,:,476))
  call Hloop_SA_Q(ntryL,G1H2(421),ex2(:),G1H1(1),ngPtb,m3h2x1(:,477),heltab2x2(:,:,477))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,nMB,G2tensor(385),n2h1(405))
  call Hloop_SA_Q(ntryL,G1H2(422),ex2(:),G1H1(1),ngH,m3h2x1(:,478),heltab2x2(:,:,478))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,nMT,G2tensor(386),n2h1(406))
  call Hloop_SA_Q(ntryL,G1H2(426),ex2(:),G1H1(1),ngPtb,m3h2x1(:,479),heltab2x2(:,:,479))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,nMB,G2tensor(387),n2h1(407))
  call Hloop_SA_Q(ntryL,G1H2(427),ex2(:),G1H1(1),ngX,m3h2x1(:,480),heltab2x2(:,:,480))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,nMT,G2tensor(388),n2h1(408))
  call Hloop_VA_Q(ntryL,G1H2(428),ex2(:),G1H1(1),m3h2x1(:,481),heltab2x2(:,:,481))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,nMT,G2tensor(389),n2h1(409))
  call Hloop_ZA_Q(ntryL,G1H2(432),ex2(:),G1H1(1),ngZu,m3h2x1(:,482),heltab2x2(:,:,482))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,nMT,G2tensor(390),n2h1(410))
  call Hloop_WA_Q(ntryL,G1H2(433),ex2(:),G1H1(1),m3h2x1(:,483),heltab2x2(:,:,483))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,nMB,G2tensor(391),n2h1(411))
  call Hloop_WA_Q(ntryL,G1H2(434),ex2(:),G1H1(1),m3h2x1(:,484),heltab2x2(:,:,484))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,nMB,G2tensor(392),n2h1(412))
  call Hloop_SA_Q(ntryL,G1H2(438),ex2(:),G1H1(1),ngPtb,m3h2x1(:,485),heltab2x2(:,:,485))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,nMB,G2tensor(393),n2h1(413))
  call Hloop_WA_Q(ntryL,G1H2(439),ex2(:),G1H1(1),m3h2x1(:,486),heltab2x2(:,:,486))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,nMB,G2tensor(394),n2h1(414))
  call Hloop_SQ_A(ntryL,G1H2(440),ex3(:),G1H1(1),ngH,m3h2x1(:,487),heltab2x2(:,:,487))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,nMB,G2tensor(395),n2h1(415))
  call Hloop_SQ_A(ntryL,G1H2(444),ex3(:),G1H1(1),ngH,m3h2x1(:,488),heltab2x2(:,:,488))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,nMB,G2tensor(396),n2h1(416))
  call Hloop_SQ_A(ntryL,G1H2(445),ex3(:),G1H1(1),ngX,m3h2x1(:,489),heltab2x2(:,:,489))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,nMB,G2tensor(397),n2h1(417))
  call Hloop_SQ_A(ntryL,G1H2(446),ex3(:),G1H1(1),ngX,m3h2x1(:,490),heltab2x2(:,:,490))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,nMB,G2tensor(398),n2h1(418))
  call Hloop_SQ_A(ntryL,G1H2(450),ex3(:),G1H1(1),ngPtb,m3h2x1(:,491),heltab2x2(:,:,491))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,nMT,G2tensor(399),n2h1(419))
  call Hloop_SQ_A(ntryL,G1H2(451),ex3(:),G1H1(1),ngH,m3h2x1(:,492),heltab2x2(:,:,492))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,nMB,G2tensor(400),n2h1(420))
  call Hloop_SQ_A(ntryL,G1H2(452),ex3(:),G1H1(1),ngX,m3h2x1(:,493),heltab2x2(:,:,493))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,nMB,G2tensor(401),n2h1(421))
  call Hloop_VQ_A(ntryL,G1H2(456),ex3(:),G1H1(1),m3h2x1(:,494),heltab2x2(:,:,494))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,nMB,G2tensor(402),n2h1(422))
  call Hloop_VQ_A(ntryL,G1H2(457),ex3(:),G1H1(1),m3h2x1(:,495),heltab2x2(:,:,495))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,nMB,G2tensor(403),n2h1(423))
  call Hloop_ZQ_A(ntryL,G1H2(458),ex3(:),G1H1(1),ngZd,m3h2x1(:,496),heltab2x2(:,:,496))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,nMB,G2tensor(404),n2h1(424))
  call Hloop_ZQ_A(ntryL,G1H2(462),ex3(:),G1H1(1),ngZd,m3h2x1(:,497),heltab2x2(:,:,497))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,nMB,G2tensor(405),n2h1(425))
  call Hloop_WQ_A(ntryL,G1H2(463),ex3(:),G1H1(1),m3h2x1(:,498),heltab2x2(:,:,498))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,nMT,G2tensor(406),n2h1(426))
  call Hloop_VQ_A(ntryL,G1H2(464),ex3(:),G1H1(1),m3h2x1(:,499),heltab2x2(:,:,499))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,nMB,G2tensor(407),n2h1(427))
  call Hloop_ZQ_A(ntryL,G1H2(468),ex3(:),G1H1(1),ngZd,m3h2x1(:,500),heltab2x2(:,:,500))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,nMB,G2tensor(408),n2h1(428))
  call Hloop_SQ_A(ntryL,G1H2(469),ex3(:),G1H1(1),ngH,m3h2x1(:,501),heltab2x2(:,:,501))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,nMB,G2tensor(409),n2h1(429))
  call Hloop_SQ_A(ntryL,G1H2(470),ex3(:),G1H1(1),ngX,m3h2x1(:,502),heltab2x2(:,:,502))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,nMB,G2tensor(410),n2h1(430))
  call Hloop_SQ_A(ntryL,G1H2(474),ex3(:),G1H1(1),ngH,m3h2x1(:,503),heltab2x2(:,:,503))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,nMB,G2tensor(411),n2h1(431))
  call Hloop_SQ_A(ntryL,G1H2(475),ex3(:),G1H1(1),ngX,m3h2x1(:,504),heltab2x2(:,:,504))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,nMB,G2tensor(412),n2h1(432))
  call Hcheck_last_AQ_S(ntryL,l_switch,G2H2(181),ex3(:),G2tensor(413),ngPtb,m3h2x1(:,505),heltab2x2(:,:,505))
  call Hcheck_last_AQ_S(ntryL,l_switch,G2H2(191),ex3(:),G2tensor(414),ngH,m3h2x1(:,506),heltab2x2(:,:,506))
  call Hcheck_last_AQ_S(ntryL,l_switch,G2H2(190),ex3(:),G2tensor(415),ngPtb,m3h2x1(:,507),heltab2x2(:,:,507))
  call Hcheck_last_AQ_S(ntryL,l_switch,G2H2(192),ex3(:),G2tensor(416),ngX,m3h2x1(:,508),heltab2x2(:,:,508))
  call Hloop_VQ_A(ntryL,G1H2(486),ex3(:),G1H1(1),m3h2x1(:,509),heltab2x2(:,:,509))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,nMB,G2tensor(417),n2h1(433))
  call Hloop_VQ_A(ntryL,G1H2(487),ex3(:),G1H1(1),m3h2x1(:,510),heltab2x2(:,:,510))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,nMB,G2tensor(418),n2h1(434))
  call Hloop_ZQ_A(ntryL,G1H2(488),ex3(:),G1H1(1),ngZd,m3h2x1(:,511),heltab2x2(:,:,511))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,nMB,G2tensor(419),n2h1(435))
  call Hloop_ZQ_A(ntryL,G1H2(492),ex3(:),G1H1(1),ngZd,m3h2x1(:,512),heltab2x2(:,:,512))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,nMB,G2tensor(420),n2h1(436))
  call Hloop_SQ_A(ntryL,G1H2(493),ex3(:),G1H1(1),ngH,m3h2x1(:,513),heltab2x2(:,:,513))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,nMB,G2tensor(421),n2h1(437))
  call Hloop_SQ_A(ntryL,G1H2(494),ex3(:),G1H1(1),ngX,m3h2x1(:,514),heltab2x2(:,:,514))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,nMB,G2tensor(422),n2h1(438))
  call Hcheck_last_AQ_V(ntryL,l_switch,G2H2(194),ex3(:),G2tensor(423),m3h2x1(:,515),heltab2x2(:,:,515))
  call Hcheck_last_AQ_Z(ntryL,l_switch,G2H2(196),ex3(:),G2tensor(424),ngZd,m3h2x1(:,516),heltab2x2(:,:,516))
  call Hcheck_last_AQ_W(ntryL,l_switch,G2H2(187),ex3(:),G2tensor(425),m3h2x1(:,517),heltab2x2(:,:,517))
  call Hcheck_last_AQ_W(ntryL,l_switch,G2H2(195),ex3(:),G2tensor(426),m3h2x1(:,518),heltab2x2(:,:,518))
  call Hcheck_last_AQ_S(ntryL,l_switch,G2H2(189),ex3(:),G2tensor(427),ngPtb,m3h2x1(:,519),heltab2x2(:,:,519))
  call Hloop_VQ_A(ntryL,G1H2(512),ex3(:),G1H1(1),m3h2x1(:,520),heltab2x2(:,:,520))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,nMB,G2tensor(428),n2h1(439))
  call Hloop_ZQ_A(ntryL,G1H2(516),ex3(:),G1H1(1),ngZd,m3h2x1(:,521),heltab2x2(:,:,521))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,nMB,G2tensor(429),n2h1(440))
  call Hcheck_last_AQ_W(ntryL,l_switch,G2H2(193),ex3(:),G2tensor(430),m3h2x1(:,522),heltab2x2(:,:,522))
  call Hcheck_last_QA_S(ntryL,l_switch,G2H2(197),ex2(:),G2tensor(431),ngPtb,m3h2x1(:,523),heltab2x2(:,:,523))
  call Hcheck_last_QA_S(ntryL,l_switch,G2H2(207),ex2(:),G2tensor(432),ngH,m3h2x1(:,524),heltab2x2(:,:,524))
  call Hcheck_last_QA_S(ntryL,l_switch,G2H2(206),ex2(:),G2tensor(433),ngPtb,m3h2x1(:,525),heltab2x2(:,:,525))
  call Hcheck_last_QA_S(ntryL,l_switch,G2H2(208),ex2(:),G2tensor(434),ngX,m3h2x1(:,526),heltab2x2(:,:,526))
  call Hcheck_last_QA_V(ntryL,l_switch,G2H2(210),ex2(:),G2tensor(435),m3h2x1(:,527),heltab2x2(:,:,527))
  call Hcheck_last_QA_Z(ntryL,l_switch,G2H2(212),ex2(:),G2tensor(436),ngZu,m3h2x1(:,528),heltab2x2(:,:,528))
  call Hcheck_last_QA_W(ntryL,l_switch,G2H2(203),ex2(:),G2tensor(437),m3h2x1(:,529),heltab2x2(:,:,529))
  call Hcheck_last_QA_W(ntryL,l_switch,G2H2(211),ex2(:),G2tensor(438),m3h2x1(:,530),heltab2x2(:,:,530))
  call Hcheck_last_QA_S(ntryL,l_switch,G2H2(205),ex2(:),G2tensor(439),ngPtb,m3h2x1(:,531),heltab2x2(:,:,531))
  call Hcheck_last_QA_W(ntryL,l_switch,G2H2(209),ex2(:),G2tensor(440),m3h2x1(:,532),heltab2x2(:,:,532))
  call Hloop_SA_Q(ntryL,G1H2(133),ex4(:),G1H1(1),ngX,m3h2x1(:,533),heltab2x2(:,:,533))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,nMB,G2tensor(441),n2h1(441))
  call Hloop_SA_Q(ntryL,G1H2(134),ex4(:),G1H1(1),ngX,m3h2x1(:,534),heltab2x2(:,:,534))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),8,nMB,G2tensor(442),n2h1(442))
  call Hloop_SA_Q(ntryL,G1H2(151),ex4(:),G1H1(1),ngX,m3h2x1(:,535),heltab2x2(:,:,535))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,nMB,G2tensor(443),n2h1(443))
  call Hloop_SA_Q(ntryL,G1H2(152),ex4(:),G1H1(1),ngH,m3h2x1(:,536),heltab2x2(:,:,536))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,nMB,G2tensor(444),n2h1(444))
  call Hloop_SA_Q(ntryL,G1H2(156),ex4(:),G1H1(1),ngH,m3h2x1(:,537),heltab2x2(:,:,537))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),8,nMB,G2tensor(445),n2h1(445))
  call Hloop_SA_Q(ntryL,G1H2(162),ex4(:),G1H1(1),ngH,m3h2x1(:,538),heltab2x2(:,:,538))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,nMB,G2tensor(446),n2h1(446))
  call Hloop_SA_Q(ntryL,G1H2(164),ex4(:),G1H1(1),ngX,m3h2x1(:,539),heltab2x2(:,:,539))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,nMB,G2tensor(447),n2h1(447))
  call Hloop_SA_Q(ntryL,G1H2(168),ex4(:),G1H1(1),ngX,m3h2x1(:,540),heltab2x2(:,:,540))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),8,nMB,G2tensor(448),n2h1(448))
  call Hloop_SA_Q(ntryL,G1H2(174),ex4(:),G1H1(1),ngX,m3h2x1(:,541),heltab2x2(:,:,541))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,nMB,G2tensor(449),n2h1(449))
  call Hloop_SA_Q(ntryL,G1H2(175),ex4(:),G1H1(1),ngPbt,m3h2x1(:,542),heltab2x2(:,:,542))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,nMT,G2tensor(450),n2h1(450))
  call Hloop_SA_Q(ntryL,G1H2(176),ex4(:),G1H1(1),ngPbt,m3h2x1(:,543),heltab2x2(:,:,543))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),8,nMT,G2tensor(451),n2h1(451))
  call Hloop_SA_Q(ntryL,G1H2(182),ex4(:),G1H1(1),ngPbt,m3h2x1(:,544),heltab2x2(:,:,544))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,nMT,G2tensor(452),n2h1(452))
  call Hloop_ZA_Q(ntryL,G1H2(186),ex4(:),G1H1(1),ngZd,m3h2x1(:,545),heltab2x2(:,:,545))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,nMB,G2tensor(453),n2h1(453))
  call Hloop_ZA_Q(ntryL,G1H2(187),ex4(:),G1H1(1),ngZd,m3h2x1(:,546),heltab2x2(:,:,546))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),8,nMB,G2tensor(454),n2h1(454))
  call Hloop_ZA_Q(ntryL,G1H2(193),ex4(:),G1H1(1),ngZd,m3h2x1(:,547),heltab2x2(:,:,547))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,nMB,G2tensor(455),n2h1(455))
  call Hloop_ZA_Q(ntryL,G1H2(194),ex4(:),G1H1(1),ngZd,m3h2x1(:,548),heltab2x2(:,:,548))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,nMB,G2tensor(456),n2h1(456))
  call Hloop_ZA_Q(ntryL,G1H2(198),ex4(:),G1H1(1),ngZd,m3h2x1(:,549),heltab2x2(:,:,549))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),8,nMB,G2tensor(457),n2h1(457))
  call Hloop_ZA_Q(ntryL,G1H2(204),ex4(:),G1H1(1),ngZd,m3h2x1(:,550),heltab2x2(:,:,550))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,nMB,G2tensor(458),n2h1(458))
  call Hloop_WA_Q(ntryL,G1H2(205),ex4(:),G1H1(1),m3h2x1(:,551),heltab2x2(:,:,551))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,nMT,G2tensor(459),n2h1(459))
  call Hloop_WA_Q(ntryL,G1H2(206),ex4(:),G1H1(1),m3h2x1(:,552),heltab2x2(:,:,552))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),8,nMT,G2tensor(460),n2h1(460))
  call Hloop_WA_Q(ntryL,G1H2(212),ex4(:),G1H1(1),m3h2x1(:,553),heltab2x2(:,:,553))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,nMT,G2tensor(461),n2h1(461))
  call Hloop_SA_Q(ntryL,G1H2(216),ex4(:),G1H1(1),ngH,m3h2x1(:,554),heltab2x2(:,:,554))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,nMB,G2tensor(462),n2h1(462))
  call Hloop_SA_Q(ntryL,G1H2(217),ex4(:),G1H1(1),ngH,m3h2x1(:,555),heltab2x2(:,:,555))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),8,nMB,G2tensor(463),n2h1(463))
  call Hloop_SA_Q(ntryL,G1H2(223),ex4(:),G1H1(1),ngH,m3h2x1(:,556),heltab2x2(:,:,556))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,nMB,G2tensor(464),n2h1(464))
  call Hloop_SA_Q(ntryL,G1H2(224),ex4(:),G1H1(1),ngX,m3h2x1(:,557),heltab2x2(:,:,557))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,nMB,G2tensor(465),n2h1(465))
  call Hloop_SA_Q(ntryL,G1H2(228),ex4(:),G1H1(1),ngX,m3h2x1(:,558),heltab2x2(:,:,558))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),8,nMB,G2tensor(466),n2h1(466))
  call Hloop_SA_Q(ntryL,G1H2(234),ex4(:),G1H1(1),ngX,m3h2x1(:,559),heltab2x2(:,:,559))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,nMB,G2tensor(467),n2h1(467))
  call Hloop_VA_Q(ntryL,G1H2(235),ex4(:),G1H1(1),m3h2x1(:,560),heltab2x2(:,:,560))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,nMB,G2tensor(468),n2h1(468))
  call Hloop_VA_Q(ntryL,G1H2(236),ex4(:),G1H1(1),m3h2x1(:,561),heltab2x2(:,:,561))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),8,nMB,G2tensor(469),n2h1(469))
  call Hloop_VA_Q(ntryL,G1H2(242),ex4(:),G1H1(1),m3h2x1(:,562),heltab2x2(:,:,562))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,nMB,G2tensor(470),n2h1(470))
  call Hloop_ZA_Q(ntryL,G1H2(246),ex4(:),G1H1(1),ngZd,m3h2x1(:,563),heltab2x2(:,:,563))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,nMB,G2tensor(471),n2h1(471))
  call Hloop_ZA_Q(ntryL,G1H2(247),ex4(:),G1H1(1),ngZd,m3h2x1(:,564),heltab2x2(:,:,564))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),8,nMB,G2tensor(472),n2h1(472))
  call Hloop_ZA_Q(ntryL,G1H2(253),ex4(:),G1H1(1),ngZd,m3h2x1(:,565),heltab2x2(:,:,565))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,nMB,G2tensor(473),n2h1(473))
  call Hloop_SQ_A(ntryL,G1H2(254),ex3(:),G1H1(1),ngPtb,m3h2x1(:,566),heltab2x2(:,:,566))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,nMT,G2tensor(474),n2h1(474))
  call Hloop_SQ_A(ntryL,G1H2(258),ex3(:),G1H1(1),ngPtb,m3h2x1(:,567),heltab2x2(:,:,567))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),4,nMT,G2tensor(475),n2h1(475))
  call Hloop_SQ_A(ntryL,G1H2(264),ex3(:),G1H1(1),ngPtb,m3h2x1(:,568),heltab2x2(:,:,568))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,nMT,G2tensor(476),n2h1(476))
  call Hloop_SQ_A(ntryL,G1H2(265),ex3(:),G1H1(1),ngPtb,m3h2x1(:,569),heltab2x2(:,:,569))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,nMT,G2tensor(477),n2h1(477))
  call Hloop_SQ_A(ntryL,G1H2(266),ex3(:),G1H1(1),ngPtb,m3h2x1(:,570),heltab2x2(:,:,570))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),4,nMT,G2tensor(478),n2h1(478))
  call Hloop_SQ_A(ntryL,G1H2(272),ex3(:),G1H1(1),ngPtb,m3h2x1(:,571),heltab2x2(:,:,571))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,nMT,G2tensor(479),n2h1(479))
  call Hloop_SQ_A(ntryL,G1H2(276),ex3(:),G1H1(1),ngH,m3h2x1(:,572),heltab2x2(:,:,572))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,nMB,G2tensor(480),n2h1(480))
  call Hloop_SQ_A(ntryL,G1H2(277),ex3(:),G1H1(1),ngH,m3h2x1(:,573),heltab2x2(:,:,573))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),4,nMB,G2tensor(481),n2h1(481))
  call Hloop_SQ_A(ntryL,G1H2(283),ex3(:),G1H1(1),ngH,m3h2x1(:,574),heltab2x2(:,:,574))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,nMB,G2tensor(482),n2h1(482))
  call Hloop_SQ_A(ntryL,G1H2(294),ex3(:),G1H1(1),ngH,m3h2x1(:,575),heltab2x2(:,:,575))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,nMB,G2tensor(483),n2h1(483))
  call Hloop_SQ_A(ntryL,G1H2(295),ex3(:),G1H1(1),ngH,m3h2x1(:,576),heltab2x2(:,:,576))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),4,nMB,G2tensor(484),n2h1(484))
  call Hloop_SQ_A(ntryL,G1H2(312),ex3(:),G1H1(1),ngH,m3h2x1(:,577),heltab2x2(:,:,577))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,nMB,G2tensor(485),n2h1(485))
  call Hloop_SQ_A(ntryL,G1H2(313),ex3(:),G1H1(1),ngPtb,m3h2x1(:,578),heltab2x2(:,:,578))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,nMT,G2tensor(486),n2h1(486))
  call Hloop_SQ_A(ntryL,G1H2(314),ex3(:),G1H1(1),ngPtb,m3h2x1(:,579),heltab2x2(:,:,579))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),4,nMT,G2tensor(487),n2h1(487))
  call Hloop_SQ_A(ntryL,G1H2(320),ex3(:),G1H1(1),ngPtb,m3h2x1(:,580),heltab2x2(:,:,580))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,nMT,G2tensor(488),n2h1(488))
  call Hloop_SQ_A(ntryL,G1H2(324),ex3(:),G1H1(1),ngX,m3h2x1(:,581),heltab2x2(:,:,581))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,nMB,G2tensor(489),n2h1(489))
  call Hloop_SQ_A(ntryL,G1H2(325),ex3(:),G1H1(1),ngX,m3h2x1(:,582),heltab2x2(:,:,582))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),4,nMB,G2tensor(490),n2h1(490))
  call Hloop_SQ_A(ntryL,G1H2(332),ex3(:),G1H1(1),ngX,m3h2x1(:,583),heltab2x2(:,:,583))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,nMB,G2tensor(491),n2h1(491))
  call Hloop_SQ_A(ntryL,G1H2(336),ex3(:),G1H1(1),ngX,m3h2x1(:,584),heltab2x2(:,:,584))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,nMB,G2tensor(492),n2h1(492))
  call Hloop_SQ_A(ntryL,G1H2(344),ex3(:),G1H1(1),ngX,m3h2x1(:,585),heltab2x2(:,:,585))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),4,nMB,G2tensor(493),n2h1(493))
  call Hloop_SQ_A(ntryL,G1H2(350),ex3(:),G1H1(1),ngX,m3h2x1(:,586),heltab2x2(:,:,586))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,nMB,G2tensor(494),n2h1(494))
  call Hloop_VQ_A(ntryL,G1H2(366),ex3(:),G1H1(1),m3h2x1(:,587),heltab2x2(:,:,587))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,nMB,G2tensor(495),n2h1(495))
  call Hloop_VQ_A(ntryL,G1H2(367),ex3(:),G1H1(1),m3h2x1(:,588),heltab2x2(:,:,588))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),4,nMB,G2tensor(496),n2h1(496))
  call Hloop_VQ_A(ntryL,G1H2(373),ex3(:),G1H1(1),m3h2x1(:,589),heltab2x2(:,:,589))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,nMB,G2tensor(497),n2h1(497))
  call Hloop_VQ_A(ntryL,G1H2(374),ex3(:),G1H1(1),m3h2x1(:,590),heltab2x2(:,:,590))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,nMB,G2tensor(498),n2h1(498))
  call Hloop_VQ_A(ntryL,G1H2(378),ex3(:),G1H1(1),m3h2x1(:,591),heltab2x2(:,:,591))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),4,nMB,G2tensor(499),n2h1(499))
  call Hloop_VQ_A(ntryL,G1H2(386),ex3(:),G1H1(1),m3h2x1(:,592),heltab2x2(:,:,592))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,nMB,G2tensor(500),n2h1(500))
  call Hloop_ZQ_A(ntryL,G1H2(390),ex3(:),G1H1(1),ngZd,m3h2x1(:,593),heltab2x2(:,:,593))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,nMB,G2tensor(501),n2h1(501))
  call Hloop_ZQ_A(ntryL,G1H2(391),ex3(:),G1H1(1),ngZd,m3h2x1(:,594),heltab2x2(:,:,594))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),4,nMB,G2tensor(502),n2h1(502))
  call Hloop_ZQ_A(ntryL,G1H2(481),ex3(:),G1H1(1),ngZd,m3h2x1(:,595),heltab2x2(:,:,595))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,nMB,G2tensor(503),n2h1(503))
  call Hloop_ZQ_A(ntryL,G1H2(482),ex3(:),G1H1(1),ngZd,m3h2x1(:,596),heltab2x2(:,:,596))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,nMB,G2tensor(504),n2h1(504))
  call Hloop_ZQ_A(ntryL,G1H2(498),ex3(:),G1H1(1),ngZd,m3h2x1(:,597),heltab2x2(:,:,597))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),4,nMB,G2tensor(505),n2h1(505))
  call Hloop_ZQ_A(ntryL,G1H2(504),ex3(:),G1H1(1),ngZd,m3h2x1(:,598),heltab2x2(:,:,598))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,nMB,G2tensor(506),n2h1(506))
  call Hloop_WQ_A(ntryL,G1H2(505),ex3(:),G1H1(1),m3h2x1(:,599),heltab2x2(:,:,599))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,nMT,G2tensor(507),n2h1(507))
  call Hloop_WQ_A(ntryL,G1H2(506),ex3(:),G1H1(1),m3h2x1(:,600),heltab2x2(:,:,600))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),4,nMT,G2tensor(508),n2h1(508))
  call Hloop_WQ_A(ntryL,G1H2(517),ex3(:),G1H1(1),m3h2x1(:,601),heltab2x2(:,:,601))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,nMT,G2tensor(509),n2h1(509))
  call Hloop_WQ_A(ntryL,G1H2(518),ex3(:),G1H1(1),m3h2x1(:,602),heltab2x2(:,:,602))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,nMT,G2tensor(510),n2h1(510))
  call Hloop_WQ_A(ntryL,G1H2(522),ex3(:),G1H1(1),m3h2x1(:,603),heltab2x2(:,:,603))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),4,nMT,G2tensor(511),n2h1(511))
  call Hloop_WQ_A(ntryL,G1H2(528),ex3(:),G1H1(1),m3h2x1(:,604),heltab2x2(:,:,604))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,nMT,G2tensor(512),n2h1(512))
  call Hloop_WQ_A(ntryL,G1H2(529),ex3(:),G1H1(1),m3h2x1(:,605),heltab2x2(:,:,605))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,nMT,G2tensor(513),n2h1(513))
  call Hloop_WQ_A(ntryL,G1H2(530),ex3(:),G1H1(1),m3h2x1(:,606),heltab2x2(:,:,606))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),4,nMT,G2tensor(514),n2h1(514))
  call Hloop_WQ_A(ntryL,G1H2(536),ex3(:),G1H1(1),m3h2x1(:,607),heltab2x2(:,:,607))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,nMT,G2tensor(515),n2h1(515))
  call Hloop_SQ_A(ntryL,G1H2(540),ex3(:),G1H1(1),ngPtb,m3h2x1(:,608),heltab2x2(:,:,608))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,nMT,G2tensor(516),n2h1(516))
  call Hloop_SQ_A(ntryL,G1H2(541),ex3(:),G1H1(1),ngPtb,m3h2x1(:,609),heltab2x2(:,:,609))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),4,nMT,G2tensor(517),n2h1(517))
  call Hloop_SQ_A(ntryL,G1H2(547),ex3(:),G1H1(1),ngPtb,m3h2x1(:,610),heltab2x2(:,:,610))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,nMT,G2tensor(518),n2h1(518))
  call Hloop_WQ_A(ntryL,G1H2(548),ex3(:),G1H1(1),m3h2x1(:,611),heltab2x2(:,:,611))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,nMT,G2tensor(519),n2h1(519))
  call Hloop_WQ_A(ntryL,G1H2(552),ex3(:),G1H1(1),m3h2x1(:,612),heltab2x2(:,:,612))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),4,nMT,G2tensor(520),n2h1(520))
  call Hloop_WQ_A(ntryL,G1H2(3),ex3(:),G1H1(1),m3h2x1(:,613),heltab2x2(:,:,613))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,nMT,G2tensor(521),n2h1(521))
  call Hloop_SA_Q(ntryL,G1H2(64),ex4(:),G1H1(1),ngPbt,m3h2x1(:,614),heltab2x2(:,:,614))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,nMT,G2tensor(522),n2h1(522))
  call Hloop_SA_Q(ntryL,G1H2(16),ex4(:),G1H1(1),ngPbt,m3h2x1(:,615),heltab2x2(:,:,615))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),8,nMT,G2tensor(523),n2h1(523))
  call Hloop_SA_Q(ntryL,G1H2(5),ex4(:),G1H1(1),ngPbt,m3h2x1(:,616),heltab2x2(:,:,616))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,nMT,G2tensor(524),n2h1(524))
  call Hloop_SA_Q(ntryL,G1H2(9),ex4(:),G1H1(1),ngPbt,m3h2x1(:,617),heltab2x2(:,:,617))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,nMT,G2tensor(525),n2h1(525))
  call Hloop_SA_Q(ntryL,G1H2(70),ex4(:),G1H1(1),ngPbt,m3h2x1(:,618),heltab2x2(:,:,618))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),8,nMT,G2tensor(526),n2h1(526))
  call Hloop_SA_Q(ntryL,G1H2(7),ex4(:),G1H1(1),ngPbt,m3h2x1(:,619),heltab2x2(:,:,619))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,nMT,G2tensor(527),n2h1(527))
  call Hloop_SA_Q(ntryL,G1H2(101),ex4(:),G1H1(1),ngH,m3h2x1(:,620),heltab2x2(:,:,620))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,nMB,G2tensor(528),n2h1(528))
  call Hloop_SA_Q(ntryL,G1H2(11),ex4(:),G1H1(1),ngH,m3h2x1(:,621),heltab2x2(:,:,621))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),8,nMB,G2tensor(529),n2h1(529))
  call Hloop_SA_Q(ntryL,G1H2(8),ex4(:),G1H1(1),ngH,m3h2x1(:,622),heltab2x2(:,:,622))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,nMB,G2tensor(530),n2h1(530))
  call Hloop_SA_Q(ntryL,G1H2(95),ex4(:),G1H1(1),ngH,m3h2x1(:,623),heltab2x2(:,:,623))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,nMB,G2tensor(531),n2h1(531))
  call Hloop_SA_Q(ntryL,G1H2(17),ex4(:),G1H1(1),ngH,m3h2x1(:,624),heltab2x2(:,:,624))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),8,nMB,G2tensor(532),n2h1(532))
  call Hloop_SA_Q(ntryL,G1H2(107),ex4(:),G1H1(1),ngH,m3h2x1(:,625),heltab2x2(:,:,625))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,nMB,G2tensor(533),n2h1(533))
  call Hloop_SA_Q(ntryL,G1H2(23),ex4(:),G1H1(1),ngPbt,m3h2x1(:,626),heltab2x2(:,:,626))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,nMT,G2tensor(534),n2h1(534))
  call Hloop_SA_Q(ntryL,G1H2(27),ex4(:),G1H1(1),ngPbt,m3h2x1(:,627),heltab2x2(:,:,627))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),8,nMT,G2tensor(535),n2h1(535))
  call Hloop_SA_Q(ntryL,G1H2(28),ex4(:),G1H1(1),ngPbt,m3h2x1(:,628),heltab2x2(:,:,628))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,nMT,G2tensor(536),n2h1(536))
  call Hloop_SA_Q(ntryL,G1H2(25),ex4(:),G1H1(1),ngX,m3h2x1(:,629),heltab2x2(:,:,629))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,nMB,G2tensor(537),n2h1(537))
  call Hloop_SA_Q(ntryL,G1H2(20),ex4(:),G1H1(1),ngX,m3h2x1(:,630),heltab2x2(:,:,630))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),8,nMB,G2tensor(538),n2h1(538))
  call Hloop_SA_Q(ntryL,G1H2(33),ex4(:),G1H1(1),ngX,m3h2x1(:,631),heltab2x2(:,:,631))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,nMB,G2tensor(539),n2h1(539))
  call Hloop_SA_Q(ntryL,G1H2(76),ex4(:),G1H1(1),ngX,m3h2x1(:,632),heltab2x2(:,:,632))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,nMB,G2tensor(540),n2h1(540))
  call Hloop_SA_Q(ntryL,G1H2(40),ex4(:),G1H1(1),ngX,m3h2x1(:,633),heltab2x2(:,:,633))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),8,nMB,G2tensor(541),n2h1(541))
  call Hloop_SA_Q(ntryL,G1H2(39),ex4(:),G1H1(1),ngX,m3h2x1(:,634),heltab2x2(:,:,634))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,nMB,G2tensor(542),n2h1(542))
  call Hloop_VA_Q(ntryL,G1H2(41),ex4(:),G1H1(1),m3h2x1(:,635),heltab2x2(:,:,635))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,nMB,G2tensor(543),n2h1(543))
  call Hloop_VA_Q(ntryL,G1H2(45),ex4(:),G1H1(1),m3h2x1(:,636),heltab2x2(:,:,636))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),8,nMB,G2tensor(544),n2h1(544))
  call Hloop_VA_Q(ntryL,G1H2(46),ex4(:),G1H1(1),m3h2x1(:,637),heltab2x2(:,:,637))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,nMB,G2tensor(545),n2h1(545))
  call Hloop_VA_Q(ntryL,G1H2(18),ex4(:),G1H1(1),m3h2x1(:,638),heltab2x2(:,:,638))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,nMB,G2tensor(546),n2h1(546))
  call Hloop_VA_Q(ntryL,G1H2(137),ex4(:),G1H1(1),m3h2x1(:,639),heltab2x2(:,:,639))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),8,nMB,G2tensor(547),n2h1(547))
  call Hloop_VA_Q(ntryL,G1H2(12),ex4(:),G1H1(1),m3h2x1(:,640),heltab2x2(:,:,640))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,nMB,G2tensor(548),n2h1(548))
  call Hloop_ZA_Q(ntryL,G1H2(143),ex4(:),G1H1(1),ngZd,m3h2x1(:,641),heltab2x2(:,:,641))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,nMB,G2tensor(549),n2h1(549))
  call Hloop_ZA_Q(ntryL,G1H2(53),ex4(:),G1H1(1),ngZd,m3h2x1(:,642),heltab2x2(:,:,642))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),8,nMB,G2tensor(550),n2h1(550))
  call Hloop_ZA_Q(ntryL,G1H2(376),ex4(:),G1H1(1),ngZd,m3h2x1(:,643),heltab2x2(:,:,643))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,nMB,G2tensor(551),n2h1(551))
  call Hloop_ZA_Q(ntryL,G1H2(58),ex4(:),G1H1(1),ngZd,m3h2x1(:,644),heltab2x2(:,:,644))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,nMB,G2tensor(552),n2h1(552))
  call Hloop_ZA_Q(ntryL,G1H2(19),ex4(:),G1H1(1),ngZd,m3h2x1(:,645),heltab2x2(:,:,645))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),8,nMB,G2tensor(553),n2h1(553))
  call Hloop_ZA_Q(ntryL,G1H2(59),ex4(:),G1H1(1),ngZd,m3h2x1(:,646),heltab2x2(:,:,646))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,nMB,G2tensor(554),n2h1(554))
  call Hloop_WA_Q(ntryL,G1H2(63),ex4(:),G1H1(1),m3h2x1(:,647),heltab2x2(:,:,647))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,nMT,G2tensor(555),n2h1(555))
  call Hloop_WA_Q(ntryL,G1H2(65),ex4(:),G1H1(1),m3h2x1(:,648),heltab2x2(:,:,648))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),8,nMT,G2tensor(556),n2h1(556))
  call Hloop_WA_Q(ntryL,G1H2(75),ex4(:),G1H1(1),m3h2x1(:,649),heltab2x2(:,:,649))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,nMT,G2tensor(557),n2h1(557))
  call Hloop_WA_Q(ntryL,G1H2(77),ex4(:),G1H1(1),m3h2x1(:,650),heltab2x2(:,:,650))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,nMT,G2tensor(558),n2h1(558))
  call Hloop_WA_Q(ntryL,G1H2(81),ex4(:),G1H1(1),m3h2x1(:,651),heltab2x2(:,:,651))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),8,nMT,G2tensor(559),n2h1(559))
  call Hloop_WA_Q(ntryL,G1H2(112),ex4(:),G1H1(1),m3h2x1(:,652),heltab2x2(:,:,652))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,nMT,G2tensor(560),n2h1(560))
  call Hloop_WA_Q(ntryL,G1H2(94),ex4(:),G1H1(1),m3h2x1(:,653),heltab2x2(:,:,653))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,nMT,G2tensor(561),n2h1(561))
  call Hloop_WA_Q(ntryL,G1H2(88),ex4(:),G1H1(1),m3h2x1(:,654),heltab2x2(:,:,654))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),8,nMT,G2tensor(562),n2h1(562))
  call Hloop_WA_Q(ntryL,G1H2(118),ex4(:),G1H1(1),m3h2x1(:,655),heltab2x2(:,:,655))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,nMT,G2tensor(563),n2h1(563))
  call Hloop_SA_Q(ntryL,G1H2(106),ex4(:),G1H1(1),ngPbt,m3h2x1(:,656),heltab2x2(:,:,656))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,nMT,G2tensor(564),n2h1(564))
  call Hloop_SA_Q(ntryL,G1H2(100),ex4(:),G1H1(1),ngPbt,m3h2x1(:,657),heltab2x2(:,:,657))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),8,nMT,G2tensor(565),n2h1(565))
  call Hloop_SA_Q(ntryL,G1H2(117),ex4(:),G1H1(1),ngPbt,m3h2x1(:,658),heltab2x2(:,:,658))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,nMT,G2tensor(566),n2h1(566))
  call Hloop_WA_Q(ntryL,G1H2(123),ex4(:),G1H1(1),m3h2x1(:,659),heltab2x2(:,:,659))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,nMT,G2tensor(567),n2h1(567))
  call Hloop_WA_Q(ntryL,G1H2(148),ex4(:),G1H1(1),m3h2x1(:,660),heltab2x2(:,:,660))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),8,nMT,G2tensor(568),n2h1(568))
  call Hloop_WA_Q(ntryL,G1H2(129),ex4(:),G1H1(1),m3h2x1(:,661),heltab2x2(:,:,661))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,nMT,G2tensor(569),n2h1(569))
  call Hloop_SA_Q(ntryL,G1H2(135),ex2(:),G1H1(1),ngX,m3h2x1(:,662),heltab2x2(:,:,662))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,nMT,G2tensor(570),n2h1(570))
  call Hloop_SA_Q(ntryL,G1H2(154),ex2(:),G1H1(1),ngX,m3h2x1(:,663),heltab2x2(:,:,663))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),2,nMT,G2tensor(571),n2h1(571))
  call Hloop_SA_Q(ntryL,G1H2(141),ex2(:),G1H1(1),ngX,m3h2x1(:,664),heltab2x2(:,:,664))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,nMT,G2tensor(572),n2h1(572))
  call Hloop_SA_Q(ntryL,G1H2(147),ex2(:),G1H1(1),ngH,m3h2x1(:,665),heltab2x2(:,:,665))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,nMT,G2tensor(573),n2h1(573))
  call Hloop_SA_Q(ntryL,G1H2(153),ex2(:),G1H1(1),ngH,m3h2x1(:,666),heltab2x2(:,:,666))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),2,nMT,G2tensor(574),n2h1(574))
  call Hloop_SA_Q(ntryL,G1H2(172),ex2(:),G1H1(1),ngH,m3h2x1(:,667),heltab2x2(:,:,667))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,nMT,G2tensor(575),n2h1(575))
  call Hloop_SA_Q(ntryL,G1H2(160),ex2(:),G1H1(1),ngX,m3h2x1(:,668),heltab2x2(:,:,668))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,nMT,G2tensor(576),n2h1(576))
  call Hloop_SA_Q(ntryL,G1H2(50),ex2(:),G1H1(1),ngX,m3h2x1(:,669),heltab2x2(:,:,669))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),2,nMT,G2tensor(577),n2h1(577))
  call Hloop_SA_Q(ntryL,G1H2(165),ex2(:),G1H1(1),ngX,m3h2x1(:,670),heltab2x2(:,:,670))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,nMT,G2tensor(578),n2h1(578))
  call Hloop_SA_Q(ntryL,G1H2(166),ex2(:),G1H1(1),ngPtb,m3h2x1(:,671),heltab2x2(:,:,671))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,nMB,G2tensor(579),n2h1(579))
  call Hloop_SA_Q(ntryL,G1H2(73),ex2(:),G1H1(1),ngPtb,m3h2x1(:,672),heltab2x2(:,:,672))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),2,nMB,G2tensor(580),n2h1(580))
  call Hloop_SA_Q(ntryL,G1H2(167),ex2(:),G1H1(1),ngPtb,m3h2x1(:,673),heltab2x2(:,:,673))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,nMB,G2tensor(581),n2h1(581))
  call Hloop_ZA_Q(ntryL,G1H2(171),ex2(:),G1H1(1),ngZu,m3h2x1(:,674),heltab2x2(:,:,674))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,nMT,G2tensor(582),n2h1(582))
  call Hloop_ZA_Q(ntryL,G1H2(72),ex2(:),G1H1(1),ngZu,m3h2x1(:,675),heltab2x2(:,:,675))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),2,nMT,G2tensor(583),n2h1(583))
  call Hloop_ZA_Q(ntryL,G1H2(177),ex2(:),G1H1(1),ngZu,m3h2x1(:,676),heltab2x2(:,:,676))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,nMT,G2tensor(584),n2h1(584))
  call Hloop_ZA_Q(ntryL,G1H2(178),ex2(:),G1H1(1),ngZu,m3h2x1(:,677),heltab2x2(:,:,677))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,nMT,G2tensor(585),n2h1(585))
  call Hloop_ZA_Q(ntryL,G1H2(299),ex2(:),G1H1(1),ngZu,m3h2x1(:,678),heltab2x2(:,:,678))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),2,nMT,G2tensor(586),n2h1(586))
  call Hloop_ZA_Q(ntryL,G1H2(184),ex2(:),G1H1(1),ngZu,m3h2x1(:,679),heltab2x2(:,:,679))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,nMT,G2tensor(587),n2h1(587))
  call Hloop_WA_Q(ntryL,G1H2(62),ex2(:),G1H1(1),m3h2x1(:,680),heltab2x2(:,:,680))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,nMB,G2tensor(588),n2h1(588))
  call Hloop_WA_Q(ntryL,G1H2(56),ex2(:),G1H1(1),m3h2x1(:,681),heltab2x2(:,:,681))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),2,nMB,G2tensor(589),n2h1(589))
  call Hloop_WA_Q(ntryL,G1H2(189),ex2(:),G1H1(1),m3h2x1(:,682),heltab2x2(:,:,682))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,nMB,G2tensor(590),n2h1(590))
  call Hloop_AS_Q(ntryL,G1H4(190),wf4(:,10),G1H1(1),ngPbt,m3h4x1(:,1),heltab2x4(:,:,337))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,nMT,G2tensor(591),n2h1(591))
  call Hloop_AS_Q(ntryL,G1H4(191),wf4(:,10),G1H1(1),ngPbt,m3h4x1(:,2),heltab2x4(:,:,338))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),6,nMT,G2tensor(592),n2h1(592))
  call Hloop_AS_Q(ntryL,G1H4(194),wf4(:,10),G1H1(1),ngPbt,m3h4x1(:,3),heltab2x4(:,:,339))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,nMT,G2tensor(593),n2h1(593))
  call Hloop_AS_Q(ntryL,G1H4(196),wf4(:,10),G1H1(1),ngPbt,m3h4x1(:,4),heltab2x4(:,:,340))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,nMT,G2tensor(594),n2h1(594))
  call Hloop_AS_Q(ntryL,G1H4(206),wf4(:,10),G1H1(1),ngPbt,m3h4x1(:,5),heltab2x4(:,:,341))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),6,nMT,G2tensor(595),n2h1(595))
  call Hloop_AS_Q(ntryL,G1H4(216),wf4(:,10),G1H1(1),ngPbt,m3h4x1(:,6),heltab2x4(:,:,342))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,nMT,G2tensor(596),n2h1(596))
  call Hloop_AS_Q(ntryL,G1H4(218),wf4(:,10),G1H1(1),ngPbt,m3h4x1(:,7),heltab2x4(:,:,343))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,nMT,G2tensor(597),n2h1(597))
  call Hloop_AS_Q(ntryL,G1H4(219),wf4(:,10),G1H1(1),ngPbt,m3h4x1(:,8),heltab2x4(:,:,344))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),6,nMT,G2tensor(598),n2h1(598))
  call Hloop_AS_Q(ntryL,G1H4(234),wf4(:,10),G1H1(1),ngPbt,m3h4x1(:,9),heltab2x4(:,:,345))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,nMT,G2tensor(599),n2h1(599))
  call Hloop_AW_Q(ntryL,G1H4(236),wf4(:,12),G1H1(1),m3h4x1(:,10),heltab2x4(:,:,346))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,nMT,G2tensor(600),n2h1(600))
  call Hloop_AW_Q(ntryL,G1H4(1),wf4(:,12),G1H1(1),m3h4x1(:,11),heltab2x4(:,:,347))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),6,nMT,G2tensor(601),n2h1(601))
  call Hloop_AW_Q(ntryL,G1H4(9),wf4(:,12),G1H1(1),m3h4x1(:,12),heltab2x4(:,:,348))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,nMT,G2tensor(602),n2h1(602))
  call Hloop_AW_Q(ntryL,G1H4(10),wf4(:,12),G1H1(1),m3h4x1(:,13),heltab2x4(:,:,349))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,nMT,G2tensor(603),n2h1(603))
  call Hloop_AW_Q(ntryL,G1H4(12),wf4(:,12),G1H1(1),m3h4x1(:,14),heltab2x4(:,:,350))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),6,nMT,G2tensor(604),n2h1(604))
  call Hloop_AW_Q(ntryL,G1H4(20),wf4(:,12),G1H1(1),m3h4x1(:,15),heltab2x4(:,:,351))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,nMT,G2tensor(605),n2h1(605))
  call Hloop_AW_Q(ntryL,G1H4(25),wf4(:,12),G1H1(1),m3h4x1(:,16),heltab2x4(:,:,352))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,nMT,G2tensor(606),n2h1(606))
  call Hloop_AW_Q(ntryL,G1H4(26),wf4(:,12),G1H1(1),m3h4x1(:,17),heltab2x4(:,:,353))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),6,nMT,G2tensor(607),n2h1(607))
  call Hloop_AW_Q(ntryL,G1H4(107),wf4(:,12),G1H1(1),m3h4x1(:,18),heltab2x4(:,:,354))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,nMT,G2tensor(608),n2h1(608))
  call Hloop_QS_A(ntryL,G1H4(108),wf4(:,13),G1H1(1),ngPtb,m3h4x1(:,19),heltab2x4(:,:,355))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,nMT,G2tensor(609),n2h1(609))
  call Hloop_QS_A(ntryL,G1H4(113),wf4(:,13),G1H1(1),ngPtb,m3h4x1(:,20),heltab2x4(:,:,356))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),9,nMT,G2tensor(610),n2h1(610))
  call Hloop_QS_A(ntryL,G1H4(138),wf4(:,13),G1H1(1),ngPtb,m3h4x1(:,21),heltab2x4(:,:,357))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,nMT,G2tensor(611),n2h1(611))
  call Hloop_QS_A(ntryL,G1H4(140),wf4(:,13),G1H1(1),ngPtb,m3h4x1(:,22),heltab2x4(:,:,358))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,nMT,G2tensor(612),n2h1(612))
  call Hloop_QS_A(ntryL,G1H4(150),wf4(:,13),G1H1(1),ngPtb,m3h4x1(:,23),heltab2x4(:,:,359))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),9,nMT,G2tensor(613),n2h1(613))
  call Hloop_QS_A(ntryL,G1H4(172),wf4(:,13),G1H1(1),ngPtb,m3h4x1(:,24),heltab2x4(:,:,360))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,nMT,G2tensor(614),n2h1(614))
  call Hloop_QS_A(ntryL,G1H4(173),wf4(:,13),G1H1(1),ngPtb,m3h4x1(:,25),heltab2x4(:,:,361))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,nMT,G2tensor(615),n2h1(615))
  call Hloop_QS_A(ntryL,G1H4(175),wf4(:,13),G1H1(1),ngPtb,m3h4x1(:,26),heltab2x4(:,:,362))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),9,nMT,G2tensor(616),n2h1(616))
  call Hloop_QS_A(ntryL,G1H4(7),wf4(:,13),G1H1(1),ngPtb,m3h4x1(:,27),heltab2x4(:,:,363))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,nMT,G2tensor(617),n2h1(617))
  call Hloop_QW_A(ntryL,G1H4(2),wf4(:,16),G1H1(1),m3h4x1(:,28),heltab2x4(:,:,364))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,nMT,G2tensor(618),n2h1(618))
  call Hloop_QW_A(ntryL,G1H4(8),wf4(:,16),G1H1(1),m3h4x1(:,29),heltab2x4(:,:,365))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),9,nMT,G2tensor(619),n2h1(619))
  call Hloop_QW_A(ntryL,G1H4(13),wf4(:,16),G1H1(1),m3h4x1(:,30),heltab2x4(:,:,366))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,nMT,G2tensor(620),n2h1(620))
  call Hloop_QW_A(ntryL,G1H4(15),wf4(:,16),G1H1(1),m3h4x1(:,31),heltab2x4(:,:,367))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,nMT,G2tensor(621),n2h1(621))
  call Hloop_QW_A(ntryL,G1H4(11),wf4(:,16),G1H1(1),m3h4x1(:,32),heltab2x4(:,:,368))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),9,nMT,G2tensor(622),n2h1(622))
  call Hloop_QW_A(ntryL,G1H4(17),wf4(:,16),G1H1(1),m3h4x1(:,33),heltab2x4(:,:,369))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,nMT,G2tensor(623),n2h1(623))
  call Hloop_QW_A(ntryL,G1H4(31),wf4(:,16),G1H1(1),m3h4x1(:,34),heltab2x4(:,:,370))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,nMT,G2tensor(624),n2h1(624))
  call Hloop_QW_A(ntryL,G1H4(30),wf4(:,16),G1H1(1),m3h4x1(:,35),heltab2x4(:,:,371))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),9,nMT,G2tensor(625),n2h1(625))
  call Hloop_QW_A(ntryL,G1H4(22),wf4(:,16),G1H1(1),m3h4x1(:,36),heltab2x4(:,:,372))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,nMT,G2tensor(626),n2h1(626))
  call Hloop_AS_Q(ntryL,G1H4(23),wf4(:,13),G1H1(1),ngPtb,m3h4x1(:,37),heltab2x4(:,:,373))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,nMB,G2tensor(627),n2h1(627))
  call Hloop_AS_Q(ntryL,G1H4(24),wf4(:,13),G1H1(1),ngPtb,m3h4x1(:,38),heltab2x4(:,:,374))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),9,nMB,G2tensor(628),n2h1(628))
  call Hloop_AS_Q(ntryL,G1H4(27),wf4(:,13),G1H1(1),ngPtb,m3h4x1(:,39),heltab2x4(:,:,375))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,nMB,G2tensor(629),n2h1(629))
  call Hloop_AS_Q(ntryL,G1H4(43),wf4(:,13),G1H1(1),ngPtb,m3h4x1(:,40),heltab2x4(:,:,376))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,nMB,G2tensor(630),n2h1(630))
  call Hloop_AS_Q(ntryL,G1H4(29),wf4(:,13),G1H1(1),ngPtb,m3h4x1(:,41),heltab2x4(:,:,377))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),9,nMB,G2tensor(631),n2h1(631))
  call Hloop_AS_Q(ntryL,G1H4(35),wf4(:,13),G1H1(1),ngPtb,m3h4x1(:,42),heltab2x4(:,:,378))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,nMB,G2tensor(632),n2h1(632))
  call Hloop_AS_Q(ntryL,G1H4(36),wf4(:,13),G1H1(1),ngPtb,m3h4x1(:,43),heltab2x4(:,:,379))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,nMB,G2tensor(633),n2h1(633))
  call Hloop_AS_Q(ntryL,G1H4(37),wf4(:,13),G1H1(1),ngPtb,m3h4x1(:,44),heltab2x4(:,:,380))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),9,nMB,G2tensor(634),n2h1(634))
  call Hloop_AS_Q(ntryL,G1H4(40),wf4(:,13),G1H1(1),ngPtb,m3h4x1(:,45),heltab2x4(:,:,381))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,nMB,G2tensor(635),n2h1(635))
  call Hloop_AW_Q(ntryL,G1H4(41),wf4(:,16),G1H1(1),m3h4x1(:,46),heltab2x4(:,:,382))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,nMB,G2tensor(636),n2h1(636))
  call Hloop_AW_Q(ntryL,G1H4(45),wf4(:,16),G1H1(1),m3h4x1(:,47),heltab2x4(:,:,383))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),9,nMB,G2tensor(637),n2h1(637))
  call Hloop_AW_Q(ntryL,G1H4(48),wf4(:,16),G1H1(1),m3h4x1(:,48),heltab2x4(:,:,384))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,nMB,G2tensor(638),n2h1(638))
  call Hloop_AW_Q(ntryL,G1H4(49),wf4(:,16),G1H1(1),m3h4x1(:,49),heltab2x4(:,:,385))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,nMB,G2tensor(639),n2h1(639))
  call Hloop_AW_Q(ntryL,G1H4(50),wf4(:,16),G1H1(1),m3h4x1(:,50),heltab2x4(:,:,386))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),9,nMB,G2tensor(640),n2h1(640))
  call Hloop_AW_Q(ntryL,G1H4(53),wf4(:,16),G1H1(1),m3h4x1(:,51),heltab2x4(:,:,387))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,nMB,G2tensor(641),n2h1(641))
  call Hloop_AW_Q(ntryL,G1H4(54),wf4(:,16),G1H1(1),m3h4x1(:,52),heltab2x4(:,:,388))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,nMB,G2tensor(642),n2h1(642))
  call Hloop_AW_Q(ntryL,G1H4(55),wf4(:,16),G1H1(1),m3h4x1(:,53),heltab2x4(:,:,389))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),9,nMB,G2tensor(643),n2h1(643))
  call Hloop_AW_Q(ntryL,G1H4(58),wf4(:,16),G1H1(1),m3h4x1(:,54),heltab2x4(:,:,390))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,nMB,G2tensor(644),n2h1(644))
  call Hloop_AS_Q(ntryL,G1H4(59),wf4(:,17),G1H1(1),ngH,m3h4x1(:,55),heltab2x4(:,:,391))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,nMT,G2tensor(645),n2h1(645))
  call Hloop_AS_Q(ntryL,G1H4(60),wf4(:,17),G1H1(1),ngH,m3h4x1(:,56),heltab2x4(:,:,392))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),12,nMT,G2tensor(646),n2h1(646))
  call Hloop_AS_Q(ntryL,G1H4(63),wf4(:,17),G1H1(1),ngH,m3h4x1(:,57),heltab2x4(:,:,393))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,nMT,G2tensor(647),n2h1(647))
  call Hloop_AS_Q(ntryL,G1H4(64),wf4(:,17),G1H1(1),ngH,m3h4x1(:,58),heltab2x4(:,:,394))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,nMT,G2tensor(648),n2h1(648))
  call Hloop_AS_Q(ntryL,G1H4(65),wf4(:,17),G1H1(1),ngH,m3h4x1(:,59),heltab2x4(:,:,395))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),12,nMT,G2tensor(649),n2h1(649))
  call Hloop_AS_Q(ntryL,G1H4(68),wf4(:,17),G1H1(1),ngH,m3h4x1(:,60),heltab2x4(:,:,396))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,nMT,G2tensor(650),n2h1(650))
  call Hloop_AS_Q(ntryL,G1H4(69),wf4(:,17),G1H1(1),ngH,m3h4x1(:,61),heltab2x4(:,:,397))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,nMB,G2tensor(651),n2h1(651))
  call Hloop_AS_Q(ntryL,G1H4(70),wf4(:,17),G1H1(1),ngH,m3h4x1(:,62),heltab2x4(:,:,398))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),12,nMB,G2tensor(652),n2h1(652))
  call Hloop_AS_Q(ntryL,G1H4(73),wf4(:,17),G1H1(1),ngH,m3h4x1(:,63),heltab2x4(:,:,399))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,nMB,G2tensor(653),n2h1(653))
  call Hloop_AS_Q(ntryL,G1H4(74),wf4(:,18),G1H1(1),ngX,m3h4x1(:,64),heltab2x4(:,:,400))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,nMT,G2tensor(654),n2h1(654))
  call Hloop_AS_Q(ntryL,G1H4(75),wf4(:,18),G1H1(1),ngX,m3h4x1(:,65),heltab2x4(:,:,401))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),12,nMT,G2tensor(655),n2h1(655))
  call Hloop_AS_Q(ntryL,G1H4(78),wf4(:,18),G1H1(1),ngX,m3h4x1(:,66),heltab2x4(:,:,402))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,nMT,G2tensor(656),n2h1(656))
  call Hloop_AS_Q(ntryL,G1H4(79),wf4(:,18),G1H1(1),ngX,m3h4x1(:,67),heltab2x4(:,:,403))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,nMT,G2tensor(657),n2h1(657))
  call Hloop_AS_Q(ntryL,G1H4(80),wf4(:,18),G1H1(1),ngX,m3h4x1(:,68),heltab2x4(:,:,404))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),12,nMT,G2tensor(658),n2h1(658))
  call Hloop_AS_Q(ntryL,G1H4(83),wf4(:,18),G1H1(1),ngX,m3h4x1(:,69),heltab2x4(:,:,405))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,nMT,G2tensor(659),n2h1(659))
  call Hloop_AS_Q(ntryL,G1H4(84),wf4(:,18),G1H1(1),ngX,m3h4x1(:,70),heltab2x4(:,:,406))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,nMB,G2tensor(660),n2h1(660))
  call Hloop_AS_Q(ntryL,G1H4(85),wf4(:,18),G1H1(1),ngX,m3h4x1(:,71),heltab2x4(:,:,407))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),12,nMB,G2tensor(661),n2h1(661))
  call Hloop_AS_Q(ntryL,G1H4(88),wf4(:,18),G1H1(1),ngX,m3h4x1(:,72),heltab2x4(:,:,408))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,nMB,G2tensor(662),n2h1(662))
  call Hloop_AS_Q(ntryL,G1H4(89),wf4(:,17),G1H1(1),ngH,m3h4x1(:,73),heltab2x4(:,:,409))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,nMT,G2tensor(663),n2h1(663))
  call Hloop_AS_Q(ntryL,G1H4(90),wf4(:,17),G1H1(1),ngH,m3h4x1(:,74),heltab2x4(:,:,410))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),12,nMT,G2tensor(664),n2h1(664))
  call Hloop_AS_Q(ntryL,G1H4(93),wf4(:,17),G1H1(1),ngH,m3h4x1(:,75),heltab2x4(:,:,411))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,nMT,G2tensor(665),n2h1(665))
  call Hloop_AS_Q(ntryL,G1H4(94),wf4(:,18),G1H1(1),ngX,m3h4x1(:,76),heltab2x4(:,:,412))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,nMT,G2tensor(666),n2h1(666))
  call Hloop_AS_Q(ntryL,G1H4(95),wf4(:,18),G1H1(1),ngX,m3h4x1(:,77),heltab2x4(:,:,413))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),12,nMT,G2tensor(667),n2h1(667))
  call Hloop_AS_Q(ntryL,G1H4(98),wf4(:,18),G1H1(1),ngX,m3h4x1(:,78),heltab2x4(:,:,414))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,nMT,G2tensor(668),n2h1(668))
  call Hloop_AV_Q(ntryL,G1H4(99),wf4(:,19),G1H1(1),m3h4x1(:,79),heltab2x4(:,:,415))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,nMT,G2tensor(669),n2h1(669))
  call Hloop_AV_Q(ntryL,G1H4(100),wf4(:,19),G1H1(1),m3h4x1(:,80),heltab2x4(:,:,416))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),12,nMT,G2tensor(670),n2h1(670))
  call Hloop_AV_Q(ntryL,G1H4(103),wf4(:,19),G1H1(1),m3h4x1(:,81),heltab2x4(:,:,417))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,nMT,G2tensor(671),n2h1(671))
  call Hloop_AV_Q(ntryL,G1H4(104),wf4(:,19),G1H1(1),m3h4x1(:,82),heltab2x4(:,:,418))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,nMT,G2tensor(672),n2h1(672))
  call Hloop_AV_Q(ntryL,G1H4(105),wf4(:,19),G1H1(1),m3h4x1(:,83),heltab2x4(:,:,419))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),12,nMT,G2tensor(673),n2h1(673))
  call Hloop_AV_Q(ntryL,G1H4(120),wf4(:,19),G1H1(1),m3h4x1(:,84),heltab2x4(:,:,420))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,nMT,G2tensor(674),n2h1(674))
  call Hloop_AV_Q(ntryL,G1H4(109),wf4(:,19),G1H1(1),m3h4x1(:,85),heltab2x4(:,:,421))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,nMB,G2tensor(675),n2h1(675))
  call Hloop_AV_Q(ntryL,G1H4(110),wf4(:,19),G1H1(1),m3h4x1(:,86),heltab2x4(:,:,422))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),12,nMB,G2tensor(676),n2h1(676))
  call Hloop_AV_Q(ntryL,G1H4(130),wf4(:,19),G1H1(1),m3h4x1(:,87),heltab2x4(:,:,423))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,nMB,G2tensor(677),n2h1(677))
  call Hloop_AZ_Q(ntryL,G1H4(132),wf4(:,20),G1H1(1),ngZu,m3h4x1(:,88),heltab2x4(:,:,424))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,nMT,G2tensor(678),n2h1(678))
  call Hloop_AZ_Q(ntryL,G1H4(115),wf4(:,20),G1H1(1),ngZu,m3h4x1(:,89),heltab2x4(:,:,425))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),12,nMT,G2tensor(679),n2h1(679))
  call Hloop_AZ_Q(ntryL,G1H4(121),wf4(:,20),G1H1(1),ngZu,m3h4x1(:,90),heltab2x4(:,:,426))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,nMT,G2tensor(680),n2h1(680))
  call Hloop_AZ_Q(ntryL,G1H4(122),wf4(:,20),G1H1(1),ngZu,m3h4x1(:,91),heltab2x4(:,:,427))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,nMT,G2tensor(681),n2h1(681))
  call Hloop_AZ_Q(ntryL,G1H4(123),wf4(:,20),G1H1(1),ngZu,m3h4x1(:,92),heltab2x4(:,:,428))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),12,nMT,G2tensor(682),n2h1(682))
  call Hloop_AZ_Q(ntryL,G1H4(126),wf4(:,20),G1H1(1),ngZu,m3h4x1(:,93),heltab2x4(:,:,429))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,nMT,G2tensor(683),n2h1(683))
  call Hloop_AZ_Q(ntryL,G1H4(127),wf4(:,20),G1H1(1),ngZd,m3h4x1(:,94),heltab2x4(:,:,430))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,nMB,G2tensor(684),n2h1(684))
  call Hloop_AZ_Q(ntryL,G1H4(128),wf4(:,20),G1H1(1),ngZd,m3h4x1(:,95),heltab2x4(:,:,431))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),12,nMB,G2tensor(685),n2h1(685))
  call Hloop_AZ_Q(ntryL,G1H4(134),wf4(:,20),G1H1(1),ngZd,m3h4x1(:,96),heltab2x4(:,:,432))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,nMB,G2tensor(686),n2h1(686))
  call Hloop_AV_Q(ntryL,G1H4(135),wf4(:,19),G1H1(1),m3h4x1(:,97),heltab2x4(:,:,433))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,nMT,G2tensor(687),n2h1(687))
  call Hloop_AV_Q(ntryL,G1H4(136),wf4(:,19),G1H1(1),m3h4x1(:,98),heltab2x4(:,:,434))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),12,nMT,G2tensor(688),n2h1(688))
  call Hloop_AV_Q(ntryL,G1H4(139),wf4(:,19),G1H1(1),m3h4x1(:,99),heltab2x4(:,:,435))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,nMT,G2tensor(689),n2h1(689))
  call Hloop_AZ_Q(ntryL,G1H4(148),wf4(:,20),G1H1(1),ngZu,m3h4x1(:,100),heltab2x4(:,:,436))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,nMT,G2tensor(690),n2h1(690))
  call Hloop_AZ_Q(ntryL,G1H4(141),wf4(:,20),G1H1(1),ngZu,m3h4x1(:,101),heltab2x4(:,:,437))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),12,nMT,G2tensor(691),n2h1(691))
  call Hloop_AZ_Q(ntryL,G1H4(144),wf4(:,20),G1H1(1),ngZu,m3h4x1(:,102),heltab2x4(:,:,438))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,nMT,G2tensor(692),n2h1(692))
  call Hloop_QS_A(ntryL,G1H4(145),wf4(:,17),G1H1(1),ngH,m3h4x1(:,103),heltab2x4(:,:,439))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,nMT,G2tensor(693),n2h1(693))
  call Hloop_QS_A(ntryL,G1H4(146),wf4(:,17),G1H1(1),ngH,m3h4x1(:,104),heltab2x4(:,:,440))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),12,nMT,G2tensor(694),n2h1(694))
  call Hloop_QS_A(ntryL,G1H4(151),wf4(:,17),G1H1(1),ngH,m3h4x1(:,105),heltab2x4(:,:,441))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,nMT,G2tensor(695),n2h1(695))
  call Hloop_QS_A(ntryL,G1H4(164),wf4(:,17),G1H1(1),ngH,m3h4x1(:,106),heltab2x4(:,:,442))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,nMT,G2tensor(696),n2h1(696))
  call Hloop_QS_A(ntryL,G1H4(153),wf4(:,17),G1H1(1),ngH,m3h4x1(:,107),heltab2x4(:,:,443))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),12,nMT,G2tensor(697),n2h1(697))
  call Hloop_QS_A(ntryL,G1H4(156),wf4(:,17),G1H1(1),ngH,m3h4x1(:,108),heltab2x4(:,:,444))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,nMT,G2tensor(698),n2h1(698))
  call Hloop_QS_A(ntryL,G1H4(157),wf4(:,17),G1H1(1),ngH,m3h4x1(:,109),heltab2x4(:,:,445))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,nMB,G2tensor(699),n2h1(699))
  call Hloop_QS_A(ntryL,G1H4(158),wf4(:,17),G1H1(1),ngH,m3h4x1(:,110),heltab2x4(:,:,446))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),12,nMB,G2tensor(700),n2h1(700))
  call Hloop_QS_A(ntryL,G1H4(161),wf4(:,17),G1H1(1),ngH,m3h4x1(:,111),heltab2x4(:,:,447))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,nMB,G2tensor(701),n2h1(701))
  call Hloop_QS_A(ntryL,G1H4(163),wf4(:,18),G1H1(1),ngX,m3h4x1(:,112),heltab2x4(:,:,448))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,nMT,G2tensor(702),n2h1(702))
  call Hloop_QS_A(ntryL,G1H4(165),wf4(:,18),G1H1(1),ngX,m3h4x1(:,113),heltab2x4(:,:,449))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),12,nMT,G2tensor(703),n2h1(703))
  call Hloop_QS_A(ntryL,G1H4(168),wf4(:,18),G1H1(1),ngX,m3h4x1(:,114),heltab2x4(:,:,450))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,nMT,G2tensor(704),n2h1(704))
  call Hloop_QS_A(ntryL,G1H4(169),wf4(:,18),G1H1(1),ngX,m3h4x1(:,115),heltab2x4(:,:,451))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,nMT,G2tensor(705),n2h1(705))
  call Hloop_QS_A(ntryL,G1H4(170),wf4(:,18),G1H1(1),ngX,m3h4x1(:,116),heltab2x4(:,:,452))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),12,nMT,G2tensor(706),n2h1(706))
  call Hloop_QS_A(ntryL,G1H4(183),wf4(:,18),G1H1(1),ngX,m3h4x1(:,117),heltab2x4(:,:,453))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,nMT,G2tensor(707),n2h1(707))
  call Hloop_QS_A(ntryL,G1H4(174),wf4(:,18),G1H1(1),ngX,m3h4x1(:,118),heltab2x4(:,:,454))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,nMB,G2tensor(708),n2h1(708))
  call Hloop_QS_A(ntryL,G1H4(186),wf4(:,18),G1H1(1),ngX,m3h4x1(:,119),heltab2x4(:,:,455))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),12,nMB,G2tensor(709),n2h1(709))
  call Hloop_QS_A(ntryL,G1H4(188),wf4(:,18),G1H1(1),ngX,m3h4x1(:,120),heltab2x4(:,:,456))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,nMB,G2tensor(710),n2h1(710))
  call Hloop_QS_A(ntryL,G1H4(179),wf4(:,17),G1H1(1),ngH,m3h4x1(:,121),heltab2x4(:,:,457))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,nMT,G2tensor(711),n2h1(711))
  call Hloop_QS_A(ntryL,G1H4(180),wf4(:,17),G1H1(1),ngH,m3h4x1(:,122),heltab2x4(:,:,458))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),12,nMT,G2tensor(712),n2h1(712))
  call Hloop_QS_A(ntryL,G1H4(189),wf4(:,17),G1H1(1),ngH,m3h4x1(:,123),heltab2x4(:,:,459))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,nMT,G2tensor(713),n2h1(713))
  call Hloop_QS_A(ntryL,G1H4(199),wf4(:,18),G1H1(1),ngX,m3h4x1(:,124),heltab2x4(:,:,460))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,nMT,G2tensor(714),n2h1(714))
  call Hloop_QS_A(ntryL,G1H4(198),wf4(:,18),G1H1(1),ngX,m3h4x1(:,125),heltab2x4(:,:,461))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),12,nMT,G2tensor(715),n2h1(715))
  call Hloop_QS_A(ntryL,G1H4(204),wf4(:,18),G1H1(1),ngX,m3h4x1(:,126),heltab2x4(:,:,462))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,nMT,G2tensor(716),n2h1(716))
  call Hloop_QV_A(ntryL,G1H4(195),wf4(:,19),G1H1(1),m3h4x1(:,127),heltab2x4(:,:,463))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,nMT,G2tensor(717),n2h1(717))
  call Hloop_QV_A(ntryL,G1H4(203),wf4(:,19),G1H1(1),m3h4x1(:,128),heltab2x4(:,:,464))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),12,nMT,G2tensor(718),n2h1(718))
  call Hloop_QV_A(ntryL,G1H4(205),wf4(:,19),G1H1(1),m3h4x1(:,129),heltab2x4(:,:,465))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,nMT,G2tensor(719),n2h1(719))
  call Hloop_QV_A(ntryL,G1H4(212),wf4(:,19),G1H1(1),m3h4x1(:,130),heltab2x4(:,:,466))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,nMT,G2tensor(720),n2h1(720))
  call Hloop_QV_A(ntryL,G1H4(207),wf4(:,19),G1H1(1),m3h4x1(:,131),heltab2x4(:,:,467))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),12,nMT,G2tensor(721),n2h1(721))
  call Hloop_QV_A(ntryL,G1H4(210),wf4(:,19),G1H1(1),m3h4x1(:,132),heltab2x4(:,:,468))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,nMT,G2tensor(722),n2h1(722))
  call Hloop_QV_A(ntryL,G1H4(211),wf4(:,19),G1H1(1),m3h4x1(:,133),heltab2x4(:,:,469))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,nMB,G2tensor(723),n2h1(723))
  call Hloop_QV_A(ntryL,G1H4(215),wf4(:,19),G1H1(1),m3h4x1(:,134),heltab2x4(:,:,470))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),12,nMB,G2tensor(724),n2h1(724))
  call Hloop_QV_A(ntryL,G1H4(223),wf4(:,19),G1H1(1),m3h4x1(:,135),heltab2x4(:,:,471))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,nMB,G2tensor(725),n2h1(725))
  call Hloop_QZ_A(ntryL,G1H4(224),wf4(:,20),G1H1(1),ngZu,m3h4x1(:,136),heltab2x4(:,:,472))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,nMT,G2tensor(726),n2h1(726))
  call Hloop_QZ_A(ntryL,G1H4(220),wf4(:,20),G1H1(1),ngZu,m3h4x1(:,137),heltab2x4(:,:,473))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),12,nMT,G2tensor(727),n2h1(727))
  call Hloop_QZ_A(ntryL,G1H4(226),wf4(:,20),G1H1(1),ngZu,m3h4x1(:,138),heltab2x4(:,:,474))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,nMT,G2tensor(728),n2h1(728))
  call Hloop_QZ_A(ntryL,G1H4(239),wf4(:,20),G1H1(1),ngZu,m3h4x1(:,139),heltab2x4(:,:,475))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,nMT,G2tensor(729),n2h1(729))
  call Hloop_QZ_A(ntryL,G1H4(240),wf4(:,20),G1H1(1),ngZu,m3h4x1(:,140),heltab2x4(:,:,476))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),12,nMT,G2tensor(730),n2h1(730))
  call Hloop_QZ_A(ntryL,G1H4(231),wf4(:,20),G1H1(1),ngZu,m3h4x1(:,141),heltab2x4(:,:,477))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,nMT,G2tensor(731),n2h1(731))
  call Hloop_QZ_A(ntryL,G1H4(232),wf4(:,20),G1H1(1),ngZd,m3h4x1(:,142),heltab2x4(:,:,478))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,nMB,G2tensor(732),n2h1(732))
  call Hloop_QZ_A(ntryL,G1H4(233),wf4(:,20),G1H1(1),ngZd,m3h4x1(:,143),heltab2x4(:,:,479))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),12,nMB,G2tensor(733),n2h1(733))
  call Hloop_QZ_A(ntryL,G1H4(252),wf4(:,20),G1H1(1),ngZd,m3h4x1(:,144),heltab2x4(:,:,480))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,nMB,G2tensor(734),n2h1(734))
  call Hloop_QV_A(ntryL,G1H4(237),wf4(:,19),G1H1(1),m3h4x1(:,145),heltab2x4(:,:,481))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,nMT,G2tensor(735),n2h1(735))
  call Hloop_QV_A(ntryL,G1H4(238),wf4(:,19),G1H1(1),m3h4x1(:,146),heltab2x4(:,:,482))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),12,nMT,G2tensor(736),n2h1(736))
  call Hloop_QV_A(ntryL,G1H4(243),wf4(:,19),G1H1(1),m3h4x1(:,147),heltab2x4(:,:,483))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,nMT,G2tensor(737),n2h1(737))
  call Hloop_QZ_A(ntryL,G1H4(244),wf4(:,20),G1H1(1),ngZu,m3h4x1(:,148),heltab2x4(:,:,484))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,nMT,G2tensor(738),n2h1(738))
  call Hloop_QZ_A(ntryL,G1H4(245),wf4(:,20),G1H1(1),ngZu,m3h4x1(:,149),heltab2x4(:,:,485))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),12,nMT,G2tensor(739),n2h1(739))
  call Hloop_QZ_A(ntryL,G1H4(248),wf4(:,20),G1H1(1),ngZu,m3h4x1(:,150),heltab2x4(:,:,486))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,nMT,G2tensor(740),n2h1(740))
  call ol_merge_tensors(G2tensor(2),[G1tensor(2)])
  call ol_merge_tensors(G2tensor(24),[G2tensor(18),G2tensor(6),G2tensor(3),G1tensor(36),G1tensor(12),G1tensor(6)])
  call ol_merge_tensors(G2tensor(23),[G2tensor(5),G1tensor(8)])
  call ol_merge_tensors(G2tensor(8),[G1tensor(14)])
  call ol_merge_tensors(G2tensor(27),[G2tensor(21),G2tensor(12),G2tensor(9),G1tensor(42),G1tensor(24),G1tensor(18)])
  call ol_merge_tensors(G2tensor(26),[G2tensor(11),G1tensor(20)])
  call ol_merge_tensors(G2tensor(29),[G2tensor(14),G1tensor(26)])
  call ol_merge_tensors(G2tensor(30),[G2tensor(15),G1tensor(30)])
  call ol_merge_tensors(G2tensor(17),[G1tensor(32)])
  call ol_merge_tensors(G2tensor(20),[G1tensor(38)])
  call ol_merge_tensors(G2tensor(32),[G1tensor(44)])
  call ol_merge_tensors(G2tensor(42),[G2tensor(39),G2tensor(36),G2tensor(33),G1tensor(60),G1tensor(54),G1tensor(48)])
  call ol_merge_tensors(G2tensor(41),[G2tensor(35),G1tensor(50)])
  call ol_merge_tensors(G2tensor(38),[G1tensor(56)])
  call ol_merge_tensors(G2tensor(44),[G1tensor(62)])
  call ol_merge_tensors(G2tensor(636),[G2tensor(627),G2tensor(69),G2tensor(63),G2tensor(51),G2tensor(45),G1tensor(102) &
    ,G1tensor(78),G1tensor(66)])
  call ol_merge_tensors(G2tensor(47),[G1tensor(68)])
  call ol_merge_tensors(G2tensor(639),[G2tensor(630),G2tensor(72),G2tensor(66),G2tensor(54),G2tensor(48),G1tensor(108) &
    ,G1tensor(84),G1tensor(72)])
  call ol_merge_tensors(G2tensor(68),[G2tensor(50),G1tensor(74)])
  call ol_merge_tensors(G2tensor(71),[G2tensor(53),G1tensor(80)])
  call ol_merge_tensors(G2tensor(56),[G1tensor(86)])
  call ol_merge_tensors(G2tensor(642),[G2tensor(633),G2tensor(78),G2tensor(75),G2tensor(60),G2tensor(57),G1tensor(114) &
    ,G1tensor(96),G1tensor(90)])
  call ol_merge_tensors(G2tensor(77),[G2tensor(59),G1tensor(92)])
  call ol_merge_tensors(G2tensor(62),[G1tensor(98)])
  call ol_merge_tensors(G2tensor(65),[G1tensor(104)])
  call ol_merge_tensors(G2tensor(74),[G1tensor(110)])
  call ol_merge_tensors(G2tensor(381),[G2tensor(375),G2tensor(98),G2tensor(80),G1tensor(116)])
  call ol_merge_tensors(G2tensor(726),[G2tensor(717),G2tensor(702),G2tensor(693),G2tensor(99),G2tensor(81),G1tensor(120)])
  call ol_merge_tensors(G2tensor(376),[G2tensor(83),G1tensor(122)])
  call ol_merge_tensors(G2tensor(732),[G2tensor(723),G2tensor(708),G2tensor(699),G2tensor(96),G2tensor(93),G2tensor(90) &
    ,G2tensor(84),G1tensor(144),G1tensor(138),G1tensor(126)])
  call ol_merge_tensors(G2tensor(382),[G2tensor(377),G2tensor(101),G2tensor(86),G1tensor(128)])
  call ol_merge_tensors(G2tensor(729),[G2tensor(720),G2tensor(705),G2tensor(696),G2tensor(102),G2tensor(87),G1tensor(132)])
  call ol_merge_tensors(G2tensor(380),[G2tensor(378),G2tensor(95),G2tensor(89),G1tensor(134)])
  call ol_merge_tensors(G2tensor(379),[G2tensor(92),G1tensor(140)])
  call ol_merge_tensors(G2tensor(384),[G2tensor(383),G2tensor(107),G2tensor(104),G1tensor(146)])
  call ol_merge_tensors(G2tensor(738),[G2tensor(735),G2tensor(714),G2tensor(711),G2tensor(108),G2tensor(105),G1tensor(150)])
  call ol_merge_tensors(G2tensor(425),[G2tensor(413),G2tensor(128),G2tensor(110),G1tensor(152)])
  call ol_merge_tensors(G2tensor(678),[G2tensor(669),G2tensor(654),G2tensor(645),G2tensor(129),G2tensor(111),G1tensor(156)])
  call ol_merge_tensors(G2tensor(414),[G2tensor(113),G1tensor(158)])
  call ol_merge_tensors(G2tensor(684),[G2tensor(675),G2tensor(660),G2tensor(651),G2tensor(126),G2tensor(123),G2tensor(120) &
    ,G2tensor(114),G1tensor(180),G1tensor(174),G1tensor(162)])
  call ol_merge_tensors(G2tensor(426),[G2tensor(415),G2tensor(131),G2tensor(116),G1tensor(164)])
  call ol_merge_tensors(G2tensor(681),[G2tensor(672),G2tensor(657),G2tensor(648),G2tensor(132),G2tensor(117),G1tensor(168)])
  call ol_merge_tensors(G2tensor(424),[G2tensor(416),G2tensor(125),G2tensor(119),G1tensor(170)])
  call ol_merge_tensors(G2tensor(423),[G2tensor(122),G1tensor(176)])
  call ol_merge_tensors(G2tensor(430),[G2tensor(427),G2tensor(137),G2tensor(134),G1tensor(182)])
  call ol_merge_tensors(G2tensor(690),[G2tensor(687),G2tensor(666),G2tensor(663),G2tensor(138),G2tensor(135),G1tensor(186)])
  call ol_merge_tensors(G2tensor(161),[G2tensor(140),G1tensor(188)])
  call ol_merge_tensors(G2tensor(162),[G2tensor(141),G1tensor(192)])
  call ol_merge_tensors(G2tensor(143),[G1tensor(194)])
  call ol_merge_tensors(G2tensor(159),[G2tensor(156),G2tensor(150),G2tensor(144),G1tensor(222),G1tensor(210),G1tensor(198)])
  call ol_merge_tensors(G2tensor(164),[G2tensor(146),G1tensor(200)])
  call ol_merge_tensors(G2tensor(165),[G2tensor(147),G1tensor(204)])
  call ol_merge_tensors(G2tensor(158),[G2tensor(149),G1tensor(206)])
  call ol_merge_tensors(G2tensor(167),[G2tensor(152),G1tensor(212)])
  call ol_merge_tensors(G2tensor(168),[G2tensor(153),G1tensor(216)])
  call ol_merge_tensors(G2tensor(155),[G1tensor(218)])
  call ol_merge_tensors(G2tensor(437),[G2tensor(431),G2tensor(188),G2tensor(170),G1tensor(224)])
  call ol_merge_tensors(G2tensor(222),[G2tensor(216),G2tensor(204),G2tensor(201),G2tensor(189),G2tensor(171),G1tensor(294) &
    ,G1tensor(270),G1tensor(264),G1tensor(228)])
  call ol_merge_tensors(G2tensor(432),[G2tensor(173),G1tensor(230)])
  call ol_merge_tensors(G2tensor(228),[G2tensor(213),G2tensor(186),G2tensor(183),G2tensor(180),G2tensor(174),G1tensor(288) &
    ,G1tensor(252),G1tensor(246),G1tensor(234)])
  call ol_merge_tensors(G2tensor(438),[G2tensor(433),G2tensor(191),G2tensor(176),G1tensor(236)])
  call ol_merge_tensors(G2tensor(225),[G2tensor(219),G2tensor(210),G2tensor(207),G2tensor(192),G2tensor(177),G1tensor(300) &
    ,G1tensor(282),G1tensor(276),G1tensor(240)])
  call ol_merge_tensors(G2tensor(436),[G2tensor(434),G2tensor(185),G2tensor(179),G1tensor(242)])
  call ol_merge_tensors(G2tensor(435),[G2tensor(182),G1tensor(248)])
  call ol_merge_tensors(G2tensor(440),[G2tensor(439),G2tensor(197),G2tensor(194),G1tensor(254)])
  call ol_merge_tensors(G2tensor(240),[G2tensor(237),G2tensor(234),G2tensor(231),G2tensor(198),G2tensor(195),G1tensor(318) &
    ,G1tensor(312),G1tensor(306),G1tensor(258)])
  call ol_merge_tensors(G2tensor(349),[G2tensor(200),G1tensor(260)])
  call ol_merge_tensors(G2tensor(356),[G2tensor(350),G2tensor(221),G2tensor(203),G1tensor(266)])
  call ol_merge_tensors(G2tensor(351),[G2tensor(206),G1tensor(272)])
  call ol_merge_tensors(G2tensor(357),[G2tensor(352),G2tensor(224),G2tensor(209),G1tensor(278)])
  call ol_merge_tensors(G2tensor(358),[G2tensor(353),G2tensor(227),G2tensor(212),G1tensor(284)])
  call ol_merge_tensors(G2tensor(354),[G2tensor(215),G1tensor(290)])
  call ol_merge_tensors(G2tensor(355),[G2tensor(218),G1tensor(296)])
  call ol_merge_tensors(G2tensor(359),[G2tensor(230),G1tensor(302)])
  call ol_merge_tensors(G2tensor(362),[G2tensor(360),G2tensor(239),G2tensor(233),G1tensor(308)])
  call ol_merge_tensors(G2tensor(361),[G2tensor(236),G1tensor(314)])
  call ol_merge_tensors(G2tensor(363),[G2tensor(242),G1tensor(320)])
  call ol_merge_tensors(G2tensor(600),[G2tensor(591),G2tensor(261),G2tensor(255),G2tensor(246),G2tensor(243),G1tensor(348) &
    ,G1tensor(330),G1tensor(324)])
  call ol_merge_tensors(G2tensor(369),[G2tensor(364),G2tensor(260),G2tensor(245),G1tensor(326)])
  call ol_merge_tensors(G2tensor(365),[G2tensor(248),G1tensor(332)])
  call ol_merge_tensors(G2tensor(603),[G2tensor(594),G2tensor(264),G2tensor(258),G2tensor(252),G2tensor(249),G1tensor(354) &
    ,G1tensor(342),G1tensor(336)])
  call ol_merge_tensors(G2tensor(370),[G2tensor(366),G2tensor(263),G2tensor(251),G1tensor(338)])
  call ol_merge_tensors(G2tensor(367),[G2tensor(254),G1tensor(344)])
  call ol_merge_tensors(G2tensor(368),[G2tensor(257),G1tensor(350)])
  call ol_merge_tensors(G2tensor(371),[G2tensor(266),G1tensor(356)])
  call ol_merge_tensors(G2tensor(606),[G2tensor(597),G2tensor(276),G2tensor(273),G2tensor(270),G2tensor(267),G1tensor(372) &
    ,G1tensor(366),G1tensor(360)])
  call ol_merge_tensors(G2tensor(374),[G2tensor(372),G2tensor(275),G2tensor(269),G1tensor(362)])
  call ol_merge_tensors(G2tensor(373),[G2tensor(272),G1tensor(368)])
  call ol_merge_tensors(G2tensor(4),[G1tensor(3)])
  call ol_merge_tensors(G2tensor(10),[G1tensor(232),G1tensor(46),G1tensor(16),G1tensor(4)])
  call ol_merge_tensors(G2tensor(13),[G1tensor(65),G1tensor(5)])
  call ol_merge_tensors(G2tensor(133),[G2tensor(34),G1tensor(9)])
  call ol_merge_tensors(G2tensor(139),[G2tensor(49),G1tensor(244),G1tensor(52),G1tensor(22),G1tensor(10)])
  call ol_merge_tensors(G2tensor(453),[G2tensor(441),G1tensor(77),G1tensor(11)])
  call ol_merge_tensors(G2tensor(52),[G1tensor(15)])
  call ol_merge_tensors(G2tensor(444),[G1tensor(71),G1tensor(17)])
  call ol_merge_tensors(G2tensor(145),[G2tensor(58),G1tensor(21)])
  call ol_merge_tensors(G2tensor(456),[G2tensor(447),G1tensor(83),G1tensor(23)])
  call ol_merge_tensors(G2tensor(148),[G2tensor(79),G1tensor(27)])
  call ol_merge_tensors(G2tensor(151),[G2tensor(85),G1tensor(256),G1tensor(238),G1tensor(226),G1tensor(28)])
  call ol_merge_tensors(G2tensor(459),[G2tensor(450),G1tensor(29)])
  call ol_merge_tensors(G2tensor(88),[G1tensor(33)])
  call ol_merge_tensors(G2tensor(103),[G1tensor(250),G1tensor(58),G1tensor(40),G1tensor(34)])
  call ol_merge_tensors(G2tensor(109),[G1tensor(101),G1tensor(35)])
  call ol_merge_tensors(G2tensor(115),[G1tensor(39)])
  call ol_merge_tensors(G2tensor(118),[G1tensor(107),G1tensor(41)])
  call ol_merge_tensors(G2tensor(169),[G1tensor(45)])
  call ol_merge_tensors(G2tensor(175),[G1tensor(89),G1tensor(47)])
  call ol_merge_tensors(G2tensor(211),[G2tensor(178),G1tensor(51)])
  call ol_merge_tensors(G2tensor(232),[G2tensor(193),G1tensor(95),G1tensor(53)])
  call ol_merge_tensors(G2tensor(202),[G1tensor(57)])
  call ol_merge_tensors(G2tensor(208),[G1tensor(113),G1tensor(59)])
  call ol_merge_tensors(G2tensor(244),[G1tensor(63)])
  call ol_merge_tensors(G2tensor(462),[G1tensor(88),G1tensor(70),G1tensor(64)])
  call ol_merge_tensors(G2tensor(250),[G1tensor(69)])
  call ol_merge_tensors(G2tensor(16),[G2tensor(268),G1tensor(75)])
  call ol_merge_tensors(G2tensor(471),[G2tensor(465),G1tensor(94),G1tensor(82),G1tensor(76)])
  call ol_merge_tensors(G2tensor(19),[G2tensor(1),G1tensor(81)])
  call ol_merge_tensors(G2tensor(22),[G1tensor(87)])
  call ol_merge_tensors(G2tensor(40),[G2tensor(7),G1tensor(93)])
  call ol_merge_tensors(G2tensor(25),[G1tensor(99)])
  call ol_merge_tensors(G2tensor(468),[G1tensor(112),G1tensor(106),G1tensor(100)])
  call ol_merge_tensors(G2tensor(28),[G1tensor(105)])
  call ol_merge_tensors(G2tensor(31),[G1tensor(111)])
  call ol_merge_tensors(G2tensor(76),[G2tensor(37),G1tensor(117)])
  call ol_merge_tensors(G2tensor(507),[G2tensor(474),G1tensor(148),G1tensor(130),G1tensor(118)])
  call ol_merge_tensors(G2tensor(510),[G2tensor(477),G1tensor(191),G1tensor(119)])
  call ol_merge_tensors(G2tensor(43),[G1tensor(123)])
  call ol_merge_tensors(G2tensor(480),[G1tensor(124)])
  call ol_merge_tensors(G2tensor(483),[G1tensor(197),G1tensor(125)])
  call ol_merge_tensors(G2tensor(61),[G2tensor(46),G1tensor(129)])
  call ol_merge_tensors(G2tensor(513),[G2tensor(486),G1tensor(203),G1tensor(131)])
  call ol_merge_tensors(G2tensor(55),[G2tensor(67),G1tensor(135)])
  call ol_merge_tensors(G2tensor(501),[G2tensor(489),G1tensor(136)])
  call ol_merge_tensors(G2tensor(504),[G2tensor(492),G1tensor(209),G1tensor(137)])
  call ol_merge_tensors(G2tensor(70),[G1tensor(141)])
  call ol_merge_tensors(G2tensor(495),[G1tensor(142)])
  call ol_merge_tensors(G2tensor(498),[G1tensor(221),G1tensor(143)])
  call ol_merge_tensors(G2tensor(73),[G2tensor(64),G1tensor(147)])
  call ol_merge_tensors(G2tensor(519),[G2tensor(516),G1tensor(215),G1tensor(149)])
  call ol_merge_tensors(G2tensor(127),[G2tensor(97),G1tensor(153)])
  call ol_merge_tensors(G2tensor(555),[G2tensor(522),G1tensor(184),G1tensor(166),G1tensor(154)])
  call ol_merge_tensors(G2tensor(558),[G2tensor(525),G1tensor(227),G1tensor(155)])
  call ol_merge_tensors(G2tensor(82),[G1tensor(159)])
  call ol_merge_tensors(G2tensor(528),[G1tensor(160)])
  call ol_merge_tensors(G2tensor(531),[G1tensor(233),G1tensor(161)])
  call ol_merge_tensors(G2tensor(112),[G2tensor(100),G1tensor(165)])
  call ol_merge_tensors(G2tensor(561),[G2tensor(534),G1tensor(239),G1tensor(167)])
  call ol_merge_tensors(G2tensor(106),[G2tensor(94),G1tensor(171)])
  call ol_merge_tensors(G2tensor(549),[G2tensor(537),G1tensor(172)])
  call ol_merge_tensors(G2tensor(552),[G2tensor(540),G1tensor(245),G1tensor(173)])
  call ol_merge_tensors(G2tensor(91),[G1tensor(177)])
  call ol_merge_tensors(G2tensor(543),[G1tensor(178)])
  call ol_merge_tensors(G2tensor(546),[G1tensor(251),G1tensor(179)])
  call ol_merge_tensors(G2tensor(124),[G2tensor(130),G1tensor(183)])
  call ol_merge_tensors(G2tensor(567),[G2tensor(564),G1tensor(257),G1tensor(185)])
  call ol_merge_tensors(G2tensor(181),[G2tensor(121),G1tensor(189)])
  call ol_merge_tensors(G2tensor(196),[G2tensor(136),G1tensor(214),G1tensor(202),G1tensor(190)])
  call ol_merge_tensors(G2tensor(160),[G1tensor(195)])
  call ol_merge_tensors(G2tensor(142),[G1tensor(196)])
  call ol_merge_tensors(G2tensor(199),[G2tensor(163),G1tensor(201)])
  call ol_merge_tensors(G2tensor(190),[G2tensor(157),G1tensor(207)])
  call ol_merge_tensors(G2tensor(184),[G2tensor(166),G1tensor(208)])
  call ol_merge_tensors(G2tensor(220),[G2tensor(154),G1tensor(213)])
  call ol_merge_tensors(G2tensor(187),[G1tensor(219)])
  call ol_merge_tensors(G2tensor(172),[G1tensor(220)])
  call ol_merge_tensors(G2tensor(238),[G2tensor(205),G1tensor(225)])
  call ol_merge_tensors(G2tensor(223),[G1tensor(231)])
  call ol_merge_tensors(G2tensor(235),[G2tensor(226),G1tensor(237)])
  call ol_merge_tensors(G2tensor(229),[G2tensor(214),G1tensor(243)])
  call ol_merge_tensors(G2tensor(217),[G1tensor(249)])
  call ol_merge_tensors(G2tensor(259),[G2tensor(241),G1tensor(255)])
  call ol_merge_tensors(G2tensor(247),[G1tensor(261)])
  call ol_merge_tensors(G2tensor(262),[G1tensor(304),G1tensor(274),G1tensor(262)])
  call ol_merge_tensors(G2tensor(253),[G1tensor(323),G1tensor(263)])
  call ol_merge_tensors(G2tensor(284),[G2tensor(256),G1tensor(267)])
  call ol_merge_tensors(G2tensor(285),[G2tensor(265),G1tensor(310),G1tensor(280),G1tensor(268)])
  call ol_merge_tensors(G2tensor(582),[G2tensor(570),G1tensor(329),G1tensor(269)])
  call ol_merge_tensors(G2tensor(274),[G1tensor(273)])
  call ol_merge_tensors(G2tensor(573),[G1tensor(335),G1tensor(275)])
  call ol_merge_tensors(G2tensor(286),[G2tensor(271),G1tensor(279)])
  call ol_merge_tensors(G2tensor(585),[G2tensor(576),G1tensor(341),G1tensor(281)])
  call ol_merge_tensors(G2tensor(287),[G2tensor(277),G1tensor(285)])
  call ol_merge_tensors(G2tensor(288),[G2tensor(278),G1tensor(286)])
  call ol_merge_tensors(G2tensor(588),[G2tensor(579),G1tensor(287)])
  call ol_merge_tensors(G2tensor(279),[G1tensor(291)])
  call ol_merge_tensors(G2tensor(280),[G1tensor(316),G1tensor(298),G1tensor(292)])
  call ol_merge_tensors(G2tensor(281),[G1tensor(347),G1tensor(293)])
  call ol_merge_tensors(G2tensor(282),[G1tensor(297)])
  call ol_merge_tensors(G2tensor(283),[G1tensor(353),G1tensor(299)])
  call ol_merge_tensors(G2tensor(289),[G1tensor(303)])
  call ol_merge_tensors(G2tensor(290),[G1tensor(359),G1tensor(305)])
  call ol_merge_tensors(G2tensor(295),[G2tensor(291),G1tensor(309)])
  call ol_merge_tensors(G2tensor(296),[G2tensor(292),G1tensor(365),G1tensor(311)])
  call ol_merge_tensors(G2tensor(293),[G1tensor(315)])
  call ol_merge_tensors(G2tensor(294),[G1tensor(371),G1tensor(317)])
  call ol_merge_tensors(G2tensor(297),[G1tensor(321)])
  call ol_merge_tensors(G2tensor(298),[G1tensor(358),G1tensor(334),G1tensor(322)])
  call ol_merge_tensors(G2tensor(306),[G2tensor(299),G1tensor(327)])
  call ol_merge_tensors(G2tensor(307),[G2tensor(300),G1tensor(364),G1tensor(340),G1tensor(328)])
  call ol_merge_tensors(G2tensor(301),[G1tensor(333)])
  call ol_merge_tensors(G2tensor(308),[G2tensor(302),G1tensor(339)])
  call ol_merge_tensors(G2tensor(303),[G1tensor(345)])
  call ol_merge_tensors(G2tensor(304),[G1tensor(370),G1tensor(352),G1tensor(346)])
  call ol_merge_tensors(G2tensor(305),[G1tensor(351)])
  call ol_merge_tensors(G2tensor(309),[G1tensor(357)])
  call ol_merge_tensors(G2tensor(312),[G2tensor(310),G1tensor(363)])
  call ol_merge_tensors(G2tensor(311),[G1tensor(369)])
  call ol_merge_tensors(G2tensor(319),[G2tensor(314)])
  call ol_merge_tensors(G2tensor(320),[G2tensor(316)])
  call ol_merge_tensors(G2tensor(324),[G2tensor(322)])
  call ol_merge_tensors(G2tensor(332),[G2tensor(326)])
  call ol_merge_tensors(G2tensor(333),[G2tensor(328)])
  call ol_merge_tensors(G2tensor(334),[G2tensor(329)])
  call ol_merge_tensors(G2tensor(338),[G2tensor(336)])
  call ol_merge_tensors(G2tensor(345),[G2tensor(339)])
  call ol_merge_tensors(G2tensor(346),[G2tensor(341)])
  call ol_merge_tensors(G2tensor(344),[G2tensor(342)])
  call ol_merge_tensors(G2tensor(348),[G2tensor(347)])
  call ol_merge_tensors(G2tensor(391),[G2tensor(385)])
  call ol_merge_tensors(G2tensor(392),[G2tensor(387)])
  call ol_merge_tensors(G2tensor(390),[G2tensor(388)])
  call ol_merge_tensors(G2tensor(394),[G2tensor(393)])
  call ol_merge_tensors(G2tensor(404),[G2tensor(397)])
  call ol_merge_tensors(G2tensor(405),[G2tensor(398)])
  call ol_merge_tensors(G2tensor(406),[G2tensor(399)])
  call ol_merge_tensors(G2tensor(408),[G2tensor(401)])
  call ol_merge_tensors(G2tensor(419),[G2tensor(410)])
  call ol_merge_tensors(G2tensor(420),[G2tensor(412)])
  call ol_merge_tensors(G2tensor(429),[G2tensor(422)])
  call ol_merge_tensors(G2tensor(618),[G2tensor(609)])
  call ol_merge_tensors(G2tensor(621),[G2tensor(612)])
  call ol_merge_tensors(G2tensor(624),[G2tensor(615)])
  call Hotf_4pt_reduction_last(G2tensor(2),RedSet_4(36),mass4set(:,32),  & 
G1tensor(1),G1tensor(7),G1tensor(13),G1tensor(19),G1tensor(25))
  call G_TensorShift(G1tensor(7),2)
  call Hotf_4pt_reduction_last(G2tensor(24),RedSet_4(4),mass4set(:,25),  & 
G1tensor(31),G1tensor(37),G1tensor(43),G1tensor(49),G1tensor(55))
  call G_TensorShift(G1tensor(37),10)
  call Hotf_4pt_reduction_last(G2tensor(23),RedSet_4(36),mass4set(:,33),  & 
G1tensor(61),G1tensor(67),G1tensor(73),G1tensor(79),G1tensor(85))
  call G_TensorShift(G1tensor(67),2)
  call Hotf_4pt_reduction_last(G2tensor(8),RedSet_4(36),mass4set(:,34),  & 
G1tensor(91),G1tensor(97),G1tensor(103),G1tensor(109),G1tensor(115))
  call G_TensorShift(G1tensor(97),2)
  call Hotf_4pt_reduction_last(G2tensor(27),RedSet_4(4),mass4set(:,26),  & 
G1tensor(121),G1tensor(127),G1tensor(133),G1tensor(139),G1tensor(145))
  call G_TensorShift(G1tensor(127),10)
  call Hotf_4pt_reduction_last(G2tensor(26),RedSet_4(36),mass4set(:,35),  & 
G1tensor(151),G1tensor(157),G1tensor(163),G1tensor(169),G1tensor(175))
  call G_TensorShift(G1tensor(157),2)
  call Hotf_4pt_reduction_last(G2tensor(29),RedSet_4(36),mass4set(:,36),  & 
G1tensor(181),G1tensor(187),G1tensor(193),G1tensor(199),G1tensor(205))
  call G_TensorShift(G1tensor(187),2)
  call Hotf_4pt_reduction_last(G2tensor(30),RedSet_4(4),mass4set(:,37),  & 
G1tensor(211),G1tensor(217),G1tensor(223),G1tensor(229),G1tensor(235))
  call G_TensorShift(G1tensor(217),10)
  call Hotf_4pt_reduction_last(G2tensor(17),RedSet_4(36),mass4set(:,38),  & 
G1tensor(241),G1tensor(247),G1tensor(253),G1tensor(259),G1tensor(265))
  call G_TensorShift(G1tensor(247),2)
  call Hotf_4pt_reduction_last(G2tensor(20),RedSet_4(36),mass4set(:,39),  & 
G1tensor(271),G1tensor(277),G1tensor(283),G1tensor(289),G1tensor(295))
  call G_TensorShift(G1tensor(277),2)
  call Hotf_4pt_reduction_last(G2tensor(32),RedSet_4(36),mass4set(:,40),  & 
G1tensor(301),G1tensor(307),G1tensor(313),G1tensor(319),G1tensor(325))
  call G_TensorShift(G1tensor(307),2)
  call Hotf_4pt_reduction_last(G2tensor(42),RedSet_4(4),mass4set(:,27),  & 
G1tensor(331),G1tensor(337),G1tensor(343),G1tensor(349),G1tensor(355))
  call G_TensorShift(G1tensor(337),10)
  call Hotf_4pt_reduction_last(G2tensor(41),RedSet_4(36),mass4set(:,41),  & 
G1tensor(361),G1tensor(367),G1tensor(2),G1tensor(36),G1tensor(12))
  call G_TensorShift(G1tensor(367),2)
  call Hotf_4pt_reduction_last(G2tensor(38),RedSet_4(36),mass4set(:,42),  & 
G1tensor(6),G1tensor(8),G1tensor(14),G1tensor(42),G1tensor(24))
  call G_TensorShift(G1tensor(8),2)
  call Hotf_4pt_reduction_last(G2tensor(44),RedSet_4(37),mass4set(:,32),  & 
G1tensor(18),G1tensor(20),G1tensor(26),G1tensor(30),G1tensor(32))
  call G_TensorShift(G1tensor(20),1)
  call Hotf_4pt_reduction_last(G2tensor(636),RedSet_4(8),mass4set(:,25),  & 
G1tensor(38),G1tensor(44),G1tensor(60),G1tensor(54),G1tensor(48))
  call G_TensorShift(G1tensor(44),9)
  call Hotf_4pt_reduction_last(G2tensor(47),RedSet_4(37),mass4set(:,34),  & 
G1tensor(50),G1tensor(56),G1tensor(62),G1tensor(102),G1tensor(78))
  call G_TensorShift(G1tensor(56),1)
  call Hotf_4pt_reduction_last(G2tensor(639),RedSet_4(8),mass4set(:,26),  & 
G1tensor(66),G1tensor(68),G1tensor(108),G1tensor(84),G1tensor(72))
  call G_TensorShift(G1tensor(68),9)
  call Hotf_4pt_reduction_last(G2tensor(68),RedSet_4(37),mass4set(:,33),  & 
G1tensor(74),G1tensor(80),G1tensor(86),G1tensor(114),G1tensor(96))
  call G_TensorShift(G1tensor(80),1)
  call Hotf_4pt_reduction_last(G2tensor(71),RedSet_4(37),mass4set(:,35),  & 
G1tensor(90),G1tensor(92),G1tensor(98),G1tensor(104),G1tensor(110))
  call G_TensorShift(G1tensor(92),1)
  call Hotf_4pt_reduction_last(G2tensor(56),RedSet_4(37),mass4set(:,40),  & 
G1tensor(116),G1tensor(120),G1tensor(122),G1tensor(144),G1tensor(138))
  call G_TensorShift(G1tensor(120),1)
  call Hotf_4pt_reduction_last(G2tensor(642),RedSet_4(8),mass4set(:,27),  & 
G1tensor(126),G1tensor(128),G1tensor(132),G1tensor(134),G1tensor(140))
  call G_TensorShift(G1tensor(128),9)
  call Hotf_4pt_reduction_last(G2tensor(77),RedSet_4(37),mass4set(:,41),  & 
G1tensor(146),G1tensor(150),G1tensor(152),G1tensor(156),G1tensor(158))
  call G_TensorShift(G1tensor(150),1)
  call Hotf_4pt_reduction_last(G2tensor(62),RedSet_4(37),mass4set(:,38),  & 
G1tensor(180),G1tensor(174),G1tensor(162),G1tensor(164),G1tensor(168))
  call G_TensorShift(G1tensor(174),1)
  call Hotf_4pt_reduction_last(G2tensor(65),RedSet_4(37),mass4set(:,39),  & 
G1tensor(170),G1tensor(176),G1tensor(182),G1tensor(186),G1tensor(188))
  call G_TensorShift(G1tensor(176),1)
  call Hotf_4pt_reduction_last(G2tensor(74),RedSet_4(37),mass4set(:,42),  & 
G1tensor(192),G1tensor(194),G1tensor(222),G1tensor(210),G1tensor(198))
  call G_TensorShift(G1tensor(194),1)
  call Hotf_4pt_reduction_last(G2tensor(381),RedSet_4(6),mass4set(:,43),  & 
G1tensor(200),G1tensor(204),G1tensor(206),G1tensor(212),G1tensor(216))
  call G_TensorShift(G1tensor(204),8)
  call Hotf_4pt_reduction_last(G2tensor(726),RedSet_4(13),mass4set(:,28),  & 
G1tensor(218),G1tensor(224),G1tensor(294),G1tensor(270),G1tensor(264))
  call G_TensorShift(G1tensor(224),12)
  call Hotf_4pt_reduction_last(G2tensor(376),RedSet_4(6),mass4set(:,44),  & 
G1tensor(228),G1tensor(230),G1tensor(288),G1tensor(252),G1tensor(246))
  call G_TensorShift(G1tensor(230),8)
  call Hotf_4pt_reduction_last(G2tensor(732),RedSet_4(13),mass4set(:,30),  & 
G1tensor(234),G1tensor(236),G1tensor(300),G1tensor(282),G1tensor(276))
  call G_TensorShift(G1tensor(236),12)
  call Hotf_4pt_reduction_last(G2tensor(382),RedSet_4(6),mass4set(:,45),  & 
G1tensor(240),G1tensor(242),G1tensor(248),G1tensor(254),G1tensor(318))
  call G_TensorShift(G1tensor(242),8)
  call Hotf_4pt_reduction_last(G2tensor(729),RedSet_4(13),mass4set(:,29),  & 
G1tensor(312),G1tensor(306),G1tensor(258),G1tensor(260),G1tensor(266))
  call G_TensorShift(G1tensor(306),12)
  call Hotf_4pt_reduction_last(G2tensor(380),RedSet_4(6),mass4set(:,46),  & 
G1tensor(272),G1tensor(278),G1tensor(284),G1tensor(290),G1tensor(296))
  call G_TensorShift(G1tensor(278),8)
  call Hotf_4pt_reduction_last(G2tensor(379),RedSet_4(6),mass4set(:,47),  & 
G1tensor(302),G1tensor(308),G1tensor(314),G1tensor(320),G1tensor(348))
  call G_TensorShift(G1tensor(308),8)
  call Hotf_4pt_reduction_last(G2tensor(384),RedSet_4(6),mass4set(:,48),  & 
G1tensor(330),G1tensor(324),G1tensor(326),G1tensor(332),G1tensor(354))
  call G_TensorShift(G1tensor(324),8)
  call Hotf_4pt_reduction_last(G2tensor(738),RedSet_4(13),mass4set(:,31),  & 
G1tensor(342),G1tensor(336),G1tensor(338),G1tensor(344),G1tensor(350))
  call G_TensorShift(G1tensor(336),12)
  call Hotf_4pt_reduction_last(G2tensor(425),RedSet_4(38),mass4set(:,43),  & 
G1tensor(356),G1tensor(372),G1tensor(366),G1tensor(360),G1tensor(362))
  call G_TensorShift(G1tensor(372),4)
  call Hotf_4pt_reduction_last(G2tensor(678),RedSet_4(18),mass4set(:,28),  & 
G1tensor(368),G1tensor(3),G1tensor(232),G1tensor(46),G1tensor(16))
  call G_TensorShift(G1tensor(3),12)
  call Hotf_4pt_reduction_last(G2tensor(414),RedSet_4(38),mass4set(:,44),  & 
G1tensor(4),G1tensor(65),G1tensor(5),G1tensor(9),G1tensor(244))
  call G_TensorShift(G1tensor(65),4)
  call Hotf_4pt_reduction_last(G2tensor(684),RedSet_4(18),mass4set(:,30),  & 
G1tensor(52),G1tensor(22),G1tensor(10),G1tensor(77),G1tensor(11))
  call G_TensorShift(G1tensor(22),12)
  call Hotf_4pt_reduction_last(G2tensor(426),RedSet_4(38),mass4set(:,45),  & 
G1tensor(15),G1tensor(71),G1tensor(17),G1tensor(21),G1tensor(83))
  call G_TensorShift(G1tensor(71),4)
  call Hotf_4pt_reduction_last(G2tensor(681),RedSet_4(18),mass4set(:,29),  & 
G1tensor(23),G1tensor(27),G1tensor(256),G1tensor(238),G1tensor(226))
  call G_TensorShift(G1tensor(27),12)
  call Hotf_4pt_reduction_last(G2tensor(424),RedSet_4(38),mass4set(:,46),  & 
G1tensor(28),G1tensor(29),G1tensor(33),G1tensor(250),G1tensor(58))
  call G_TensorShift(G1tensor(29),4)
  call Hotf_4pt_reduction_last(G2tensor(423),RedSet_4(38),mass4set(:,47),  & 
G1tensor(40),G1tensor(34),G1tensor(101),G1tensor(35),G1tensor(39))
  call G_TensorShift(G1tensor(34),4)
  call Hotf_4pt_reduction_last(G2tensor(430),RedSet_4(38),mass4set(:,48),  & 
G1tensor(107),G1tensor(41),G1tensor(45),G1tensor(89),G1tensor(47))
  call G_TensorShift(G1tensor(41),4)
  call Hotf_4pt_reduction_last(G2tensor(690),RedSet_4(18),mass4set(:,31),  & 
G1tensor(51),G1tensor(95),G1tensor(53),G1tensor(57),G1tensor(113))
  call G_TensorShift(G1tensor(95),12)
  call Hotf_4pt_reduction_last(G2tensor(161),RedSet_4(39),mass4set(:,49),  & 
G1tensor(59),G1tensor(63),G1tensor(88),G1tensor(70),G1tensor(64))
  call G_TensorShift(G1tensor(63),1)
  call Hotf_4pt_reduction_last(G2tensor(162),RedSet_4(22),mass4set(:,22),  & 
G1tensor(69),G1tensor(75),G1tensor(94),G1tensor(82),G1tensor(76))
  call G_TensorShift(G1tensor(75),5)
  call Hotf_4pt_reduction_last(G2tensor(143),RedSet_4(39),mass4set(:,50),  & 
G1tensor(81),G1tensor(87),G1tensor(93),G1tensor(99),G1tensor(112))
  call G_TensorShift(G1tensor(87),1)
  call Hotf_4pt_reduction_last(G2tensor(159),RedSet_4(22),mass4set(:,51),  & 
G1tensor(106),G1tensor(100),G1tensor(105),G1tensor(111),G1tensor(117))
  call G_TensorShift(G1tensor(100),5)
  call Hotf_4pt_reduction_last(G2tensor(164),RedSet_4(39),mass4set(:,52),  & 
G1tensor(148),G1tensor(130),G1tensor(118),G1tensor(191),G1tensor(119))
  call G_TensorShift(G1tensor(130),1)
  call Hotf_4pt_reduction_last(G2tensor(165),RedSet_4(22),mass4set(:,23),  & 
G1tensor(123),G1tensor(124),G1tensor(197),G1tensor(125),G1tensor(129))
  call G_TensorShift(G1tensor(124),5)
  call Hotf_4pt_reduction_last(G2tensor(158),RedSet_4(39),mass4set(:,53),  & 
G1tensor(203),G1tensor(131),G1tensor(135),G1tensor(136),G1tensor(209))
  call G_TensorShift(G1tensor(131),1)
  call Hotf_4pt_reduction_last(G2tensor(167),RedSet_4(39),mass4set(:,54),  & 
G1tensor(137),G1tensor(141),G1tensor(142),G1tensor(221),G1tensor(143))
  call G_TensorShift(G1tensor(141),1)
  call Hotf_4pt_reduction_last(G2tensor(168),RedSet_4(22),mass4set(:,24),  & 
G1tensor(147),G1tensor(215),G1tensor(149),G1tensor(153),G1tensor(184))
  call G_TensorShift(G1tensor(215),5)
  call Hotf_4pt_reduction_last(G2tensor(155),RedSet_4(39),mass4set(:,55),  & 
G1tensor(166),G1tensor(154),G1tensor(227),G1tensor(155),G1tensor(159))
  call G_TensorShift(G1tensor(154),1)
  call Hotf_4pt_reduction_last(G2tensor(437),RedSet_4(40),mass4set(:,49),  & 
G1tensor(160),G1tensor(233),G1tensor(161),G1tensor(165),G1tensor(239))
  call G_TensorShift(G1tensor(233),2)
  call Hotf_4pt_reduction_last(G2tensor(222),RedSet_4(25),mass4set(:,22),  & 
G1tensor(167),G1tensor(171),G1tensor(172),G1tensor(245),G1tensor(173))
  call G_TensorShift(G1tensor(171),10)
  call Hotf_4pt_reduction_last(G2tensor(432),RedSet_4(40),mass4set(:,50),  & 
G1tensor(177),G1tensor(178),G1tensor(251),G1tensor(179),G1tensor(183))
  call G_TensorShift(G1tensor(178),2)
  call Hotf_4pt_reduction_last(G2tensor(228),RedSet_4(25),mass4set(:,51),  & 
G1tensor(257),G1tensor(185),G1tensor(189),G1tensor(214),G1tensor(202))
  call G_TensorShift(G1tensor(185),10)
  call Hotf_4pt_reduction_last(G2tensor(438),RedSet_4(40),mass4set(:,52),  & 
G1tensor(190),G1tensor(195),G1tensor(196),G1tensor(201),G1tensor(207))
  call G_TensorShift(G1tensor(195),2)
  call Hotf_4pt_reduction_last(G2tensor(225),RedSet_4(25),mass4set(:,23),  & 
G1tensor(208),G1tensor(213),G1tensor(219),G1tensor(220),G1tensor(225))
  call G_TensorShift(G1tensor(213),10)
  call Hotf_4pt_reduction_last(G2tensor(436),RedSet_4(40),mass4set(:,53),  & 
G1tensor(231),G1tensor(237),G1tensor(243),G1tensor(249),G1tensor(255))
  call G_TensorShift(G1tensor(237),2)
  call Hotf_4pt_reduction_last(G2tensor(435),RedSet_4(40),mass4set(:,55),  & 
G1tensor(261),G1tensor(304),G1tensor(274),G1tensor(262),G1tensor(323))
  call G_TensorShift(G1tensor(304),2)
  call Hotf_4pt_reduction_last(G2tensor(440),RedSet_4(40),mass4set(:,54),  & 
G1tensor(263),G1tensor(267),G1tensor(310),G1tensor(280),G1tensor(268))
  call G_TensorShift(G1tensor(267),2)
  call Hotf_4pt_reduction_last(G2tensor(240),RedSet_4(25),mass4set(:,24),  & 
G1tensor(329),G1tensor(269),G1tensor(273),G1tensor(335),G1tensor(275))
  call G_TensorShift(G1tensor(269),10)
  call Hotf_4pt_reduction_last(G2tensor(349),RedSet_4(41),mass4set(:,56),  & 
G1tensor(279),G1tensor(341),G1tensor(281),G1tensor(285),G1tensor(286))
  call G_TensorShift(G1tensor(341),8)
  call Hotf_4pt_reduction_last(G2tensor(356),RedSet_4(41),mass4set(:,57),  & 
G1tensor(287),G1tensor(291),G1tensor(316),G1tensor(298),G1tensor(292))
  call G_TensorShift(G1tensor(291),8)
  call Hotf_4pt_reduction_last(G2tensor(351),RedSet_4(41),mass4set(:,58),  & 
G1tensor(347),G1tensor(293),G1tensor(297),G1tensor(353),G1tensor(299))
  call G_TensorShift(G1tensor(293),8)
  call Hotf_4pt_reduction_last(G2tensor(357),RedSet_4(41),mass4set(:,59),  & 
G1tensor(303),G1tensor(359),G1tensor(305),G1tensor(309),G1tensor(365))
  call G_TensorShift(G1tensor(359),8)
  call Hotf_4pt_reduction_last(G2tensor(358),RedSet_4(41),mass4set(:,60),  & 
G1tensor(311),G1tensor(315),G1tensor(371),G1tensor(317),G1tensor(321))
  call G_TensorShift(G1tensor(315),8)
  call Hotf_4pt_reduction_last(G2tensor(354),RedSet_4(41),mass4set(:,61),  & 
G1tensor(358),G1tensor(334),G1tensor(322),G1tensor(327),G1tensor(364))
  call G_TensorShift(G1tensor(334),8)
  call Hotf_4pt_reduction_last(G2tensor(355),RedSet_4(41),mass4set(:,62),  & 
G1tensor(340),G1tensor(328),G1tensor(333),G1tensor(339),G1tensor(345))
  call G_TensorShift(G1tensor(328),8)
  call Hotf_4pt_reduction_last(G2tensor(359),RedSet_4(41),mass4set(:,63),  & 
G1tensor(370),G1tensor(352),G1tensor(346),G1tensor(351),G1tensor(357))
  call G_TensorShift(G1tensor(352),8)
  call Hotf_4pt_reduction_last(G2tensor(362),RedSet_4(41),mass4set(:,64),  & 
G1tensor(363),G1tensor(369),G1tensor(373),G1tensor(374),G1tensor(375))
  call G_TensorShift(G1tensor(369),8)
  call Hotf_4pt_reduction_last(G2tensor(361),RedSet_4(41),mass4set(:,65),  & 
G1tensor(376),G1tensor(377),G1tensor(378),G1tensor(379),G1tensor(380))
  call G_TensorShift(G1tensor(377),8)
  call Hotf_4pt_reduction_last(G2tensor(363),RedSet_4(10),mass4set(:,56),  & 
G1tensor(381),G1tensor(382),G1tensor(383),G1tensor(384),G1tensor(385))
  call G_TensorShift(G1tensor(382),4)
  call Hotf_4pt_reduction_last(G2tensor(600),RedSet_4(33),mass4set(:,22),  & 
G1tensor(386),G1tensor(387),G1tensor(388),G1tensor(389),G1tensor(390))
  call G_TensorShift(G1tensor(387),6)
  call Hotf_4pt_reduction_last(G2tensor(369),RedSet_4(10),mass4set(:,57),  & 
G1tensor(391),G1tensor(392),G1tensor(393),G1tensor(394),G1tensor(395))
  call G_TensorShift(G1tensor(392),4)
  call Hotf_4pt_reduction_last(G2tensor(365),RedSet_4(10),mass4set(:,58),  & 
G1tensor(396),G1tensor(397),G1tensor(398),G1tensor(399),G1tensor(400))
  call G_TensorShift(G1tensor(397),4)
  call Hotf_4pt_reduction_last(G2tensor(603),RedSet_4(33),mass4set(:,23),  & 
G1tensor(401),G1tensor(402),G1tensor(403),G1tensor(404),G1tensor(405))
  call G_TensorShift(G1tensor(402),6)
  call Hotf_4pt_reduction_last(G2tensor(370),RedSet_4(10),mass4set(:,59),  & 
G1tensor(406),G1tensor(407),G1tensor(408),G1tensor(409),G1tensor(410))
  call G_TensorShift(G1tensor(407),4)
  call Hotf_4pt_reduction_last(G2tensor(367),RedSet_4(10),mass4set(:,61),  & 
G1tensor(411),G1tensor(412),G1tensor(413),G1tensor(414),G1tensor(415))
  call G_TensorShift(G1tensor(412),4)
  call Hotf_4pt_reduction_last(G2tensor(368),RedSet_4(10),mass4set(:,62),  & 
G1tensor(416),G1tensor(417),G1tensor(418),G1tensor(419),G1tensor(420))
  call G_TensorShift(G1tensor(417),4)
  call Hotf_4pt_reduction_last(G2tensor(371),RedSet_4(10),mass4set(:,63),  & 
G1tensor(421),G1tensor(422),G1tensor(423),G1tensor(424),G1tensor(425))
  call G_TensorShift(G1tensor(422),4)
  call Hotf_4pt_reduction_last(G2tensor(606),RedSet_4(33),mass4set(:,24),  & 
G1tensor(426),G1tensor(427),G1tensor(428),G1tensor(429),G1tensor(430))
  call G_TensorShift(G1tensor(427),6)
  call Hotf_4pt_reduction_last(G2tensor(374),RedSet_4(10),mass4set(:,64),  & 
G1tensor(431),G1tensor(432),G1tensor(433),G1tensor(434),G1tensor(435))
  call G_TensorShift(G1tensor(432),4)
  call Hotf_4pt_reduction_last(G2tensor(373),RedSet_4(10),mass4set(:,65),  & 
G1tensor(436),G1tensor(437),G1tensor(438),G1tensor(439),G1tensor(440))
  call G_TensorShift(G1tensor(437),4)
  call Hotf_4pt_reduction_last(G2tensor(4),RedSet_4(1),mass4set(:,66),  & 
G1tensor(441),G1tensor(442),G1tensor(443),G1tensor(444),G1tensor(445))
  call G_TensorShift(G1tensor(442),8)
  call Hotf_4pt_reduction_last(G2tensor(10),RedSet_4(2),mass4set(:,5),  & 
G1tensor(446),G1tensor(447),G1tensor(448),G1tensor(449),G1tensor(450))
  call G_TensorShift(G1tensor(447),8)
  call Hotf_4pt_reduction_last(G2tensor(13),RedSet_4(3),mass4set(:,67),  & 
G1tensor(451),G1tensor(452),G1tensor(453),G1tensor(454),G1tensor(455))
  call G_TensorShift(G1tensor(452),8)
  call Hotf_4pt_reduction_last(G2tensor(133),RedSet_4(1),mass4set(:,68),  & 
G1tensor(456),G1tensor(457),G1tensor(458),G1tensor(459),G1tensor(460))
  call G_TensorShift(G1tensor(457),8)
  call Hotf_4pt_reduction_last(G2tensor(139),RedSet_4(2),mass4set(:,6),  & 
G1tensor(461),G1tensor(462),G1tensor(463),G1tensor(464),G1tensor(465))
  call G_TensorShift(G1tensor(462),8)
  call Hotf_4pt_reduction_last(G2tensor(453),RedSet_4(3),mass4set(:,1),  & 
G1tensor(466),G1tensor(467),G1tensor(468),G1tensor(469),G1tensor(470))
  call G_TensorShift(G1tensor(467),8)
  call Hotf_4pt_reduction_last(G2tensor(52),RedSet_4(1),mass4set(:,69),  & 
G1tensor(471),G1tensor(472),G1tensor(473),G1tensor(474),G1tensor(475))
  call G_TensorShift(G1tensor(472),8)
  call Hotf_4pt_reduction_last(G2tensor(444),RedSet_4(3),mass4set(:,2),  & 
G1tensor(476),G1tensor(477),G1tensor(478),G1tensor(479),G1tensor(480))
  call G_TensorShift(G1tensor(477),8)
  call Hotf_4pt_reduction_last(G2tensor(145),RedSet_4(1),mass4set(:,70),  & 
G1tensor(481),G1tensor(482),G1tensor(483),G1tensor(484),G1tensor(485))
  call G_TensorShift(G1tensor(482),8)
  call Hotf_4pt_reduction_last(G2tensor(456),RedSet_4(3),mass4set(:,3),  & 
G1tensor(486),G1tensor(487),G1tensor(488),G1tensor(489),G1tensor(490))
  call G_TensorShift(G1tensor(487),8)
  call Hotf_4pt_reduction_last(G2tensor(148),RedSet_4(1),mass4set(:,71),  & 
G1tensor(491),G1tensor(492),G1tensor(493),G1tensor(494),G1tensor(495))
  call G_TensorShift(G1tensor(492),8)
  call Hotf_4pt_reduction_last(G2tensor(151),RedSet_4(2),mass4set(:,72),  & 
G1tensor(496),G1tensor(497),G1tensor(498),G1tensor(499),G1tensor(500))
  call G_TensorShift(G1tensor(497),8)
  call Hotf_4pt_reduction_last(G2tensor(459),RedSet_4(3),mass4set(:,4),  & 
G1tensor(501),G1tensor(502),G1tensor(503),G1tensor(504),G1tensor(505))
  call G_TensorShift(G1tensor(502),8)
  call Hotf_4pt_reduction_last(G2tensor(88),RedSet_4(1),mass4set(:,73),  & 
G1tensor(506),G1tensor(507),G1tensor(508),G1tensor(509),G1tensor(510))
  call G_TensorShift(G1tensor(507),8)
  call Hotf_4pt_reduction_last(G2tensor(103),RedSet_4(2),mass4set(:,7),  & 
G1tensor(511),G1tensor(512),G1tensor(513),G1tensor(514),G1tensor(515))
  call G_TensorShift(G1tensor(512),8)
  call Hotf_4pt_reduction_last(G2tensor(109),RedSet_4(3),mass4set(:,74),  & 
G1tensor(516),G1tensor(517),G1tensor(518),G1tensor(519),G1tensor(520))
  call G_TensorShift(G1tensor(517),8)
  call Hotf_4pt_reduction_last(G2tensor(115),RedSet_4(1),mass4set(:,75),  & 
G1tensor(521),G1tensor(522),G1tensor(523),G1tensor(524),G1tensor(525))
  call G_TensorShift(G1tensor(522),8)
  call Hotf_4pt_reduction_last(G2tensor(118),RedSet_4(3),mass4set(:,76),  & 
G1tensor(526),G1tensor(527),G1tensor(528),G1tensor(529),G1tensor(530))
  call G_TensorShift(G1tensor(527),8)
  call Hotf_4pt_reduction_last(G2tensor(169),RedSet_4(1),mass4set(:,77),  & 
G1tensor(531),G1tensor(532),G1tensor(533),G1tensor(534),G1tensor(535))
  call G_TensorShift(G1tensor(532),8)
  call Hotf_4pt_reduction_last(G2tensor(175),RedSet_4(3),mass4set(:,78),  & 
G1tensor(536),G1tensor(537),G1tensor(538),G1tensor(539),G1tensor(540))
  call G_TensorShift(G1tensor(537),8)
  call Hotf_4pt_reduction_last(G2tensor(211),RedSet_4(1),mass4set(:,79),  & 
G1tensor(541),G1tensor(542),G1tensor(543),G1tensor(544),G1tensor(545))
  call G_TensorShift(G1tensor(542),8)
  call Hotf_4pt_reduction_last(G2tensor(232),RedSet_4(3),mass4set(:,80),  & 
G1tensor(546),G1tensor(547),G1tensor(548),G1tensor(549),G1tensor(550))
  call G_TensorShift(G1tensor(547),8)
  call Hotf_4pt_reduction_last(G2tensor(202),RedSet_4(1),mass4set(:,81),  & 
G1tensor(551),G1tensor(552),G1tensor(553),G1tensor(554),G1tensor(555))
  call G_TensorShift(G1tensor(552),8)
  call Hotf_4pt_reduction_last(G2tensor(208),RedSet_4(3),mass4set(:,82),  & 
G1tensor(556),G1tensor(557),G1tensor(558),G1tensor(559),G1tensor(560))
  call G_TensorShift(G1tensor(557),8)
  call Hotf_4pt_reduction_last(G2tensor(244),RedSet_4(6),mass4set(:,66),  & 
G1tensor(561),G1tensor(562),G1tensor(563),G1tensor(564),G1tensor(565))
  call G_TensorShift(G1tensor(562),8)
  call Hotf_4pt_reduction_last(G2tensor(462),RedSet_4(7),mass4set(:,5),  & 
G1tensor(566),G1tensor(567),G1tensor(568),G1tensor(569),G1tensor(570))
  call G_TensorShift(G1tensor(567),8)
  call Hotf_4pt_reduction_last(G2tensor(250),RedSet_4(6),mass4set(:,69),  & 
G1tensor(571),G1tensor(572),G1tensor(573),G1tensor(574),G1tensor(575))
  call G_TensorShift(G1tensor(572),8)
  call Hotf_4pt_reduction_last(G2tensor(16),RedSet_4(6),mass4set(:,68),  & 
G1tensor(576),G1tensor(577),G1tensor(578),G1tensor(579),G1tensor(580))
  call G_TensorShift(G1tensor(577),8)
  call Hotf_4pt_reduction_last(G2tensor(471),RedSet_4(7),mass4set(:,6),  & 
G1tensor(581),G1tensor(582),G1tensor(583),G1tensor(584),G1tensor(585))
  call G_TensorShift(G1tensor(582),8)
  call Hotf_4pt_reduction_last(G2tensor(19),RedSet_4(6),mass4set(:,70),  & 
G1tensor(586),G1tensor(587),G1tensor(588),G1tensor(589),G1tensor(590))
  call G_TensorShift(G1tensor(587),8)
  call Hotf_4pt_reduction_last(G2tensor(22),RedSet_4(6),mass4set(:,77),  & 
G1tensor(591),G1tensor(592),G1tensor(593),G1tensor(594),G1tensor(595))
  call G_TensorShift(G1tensor(592),8)
  call Hotf_4pt_reduction_last(G2tensor(40),RedSet_4(6),mass4set(:,79),  & 
G1tensor(596),G1tensor(597),G1tensor(598),G1tensor(599),G1tensor(600))
  call G_TensorShift(G1tensor(597),8)
  call Hotf_4pt_reduction_last(G2tensor(25),RedSet_4(6),mass4set(:,73),  & 
G1tensor(601),G1tensor(602),G1tensor(603),G1tensor(604),G1tensor(605))
  call G_TensorShift(G1tensor(602),8)
  call Hotf_4pt_reduction_last(G2tensor(468),RedSet_4(7),mass4set(:,7),  & 
G1tensor(606),G1tensor(607),G1tensor(608),G1tensor(609),G1tensor(610))
  call G_TensorShift(G1tensor(607),8)
  call Hotf_4pt_reduction_last(G2tensor(28),RedSet_4(6),mass4set(:,75),  & 
G1tensor(611),G1tensor(612),G1tensor(613),G1tensor(614),G1tensor(615))
  call G_TensorShift(G1tensor(612),8)
  call Hotf_4pt_reduction_last(G2tensor(31),RedSet_4(6),mass4set(:,81),  & 
G1tensor(616),G1tensor(617),G1tensor(618),G1tensor(619),G1tensor(620))
  call G_TensorShift(G1tensor(617),8)
  call Hotf_4pt_reduction_last(G2tensor(76),RedSet_4(10),mass4set(:,83),  & 
G1tensor(621),G1tensor(622),G1tensor(623),G1tensor(624),G1tensor(625))
  call G_TensorShift(G1tensor(622),4)
  call Hotf_4pt_reduction_last(G2tensor(507),RedSet_4(11),mass4set(:,8),  & 
G1tensor(626),G1tensor(627),G1tensor(628),G1tensor(629),G1tensor(630))
  call G_TensorShift(G1tensor(627),4)
  call Hotf_4pt_reduction_last(G2tensor(510),RedSet_4(12),mass4set(:,9),  & 
G1tensor(631),G1tensor(632),G1tensor(633),G1tensor(634),G1tensor(635))
  call G_TensorShift(G1tensor(632),4)
  call Hotf_4pt_reduction_last(G2tensor(43),RedSet_4(10),mass4set(:,84),  & 
G1tensor(636),G1tensor(637),G1tensor(638),G1tensor(639),G1tensor(640))
  call G_TensorShift(G1tensor(637),4)
  call Hotf_4pt_reduction_last(G2tensor(480),RedSet_4(11),mass4set(:,10),  & 
G1tensor(641),G1tensor(642),G1tensor(643),G1tensor(644),G1tensor(645))
  call G_TensorShift(G1tensor(642),4)
  call Hotf_4pt_reduction_last(G2tensor(483),RedSet_4(12),mass4set(:,11),  & 
G1tensor(646),G1tensor(647),G1tensor(648),G1tensor(649),G1tensor(650))
  call G_TensorShift(G1tensor(647),4)
  call Hotf_4pt_reduction_last(G2tensor(61),RedSet_4(10),mass4set(:,85),  & 
G1tensor(651),G1tensor(652),G1tensor(653),G1tensor(654),G1tensor(655))
  call G_TensorShift(G1tensor(652),4)
  call Hotf_4pt_reduction_last(G2tensor(513),RedSet_4(12),mass4set(:,12),  & 
G1tensor(656),G1tensor(657),G1tensor(658),G1tensor(659),G1tensor(660))
  call G_TensorShift(G1tensor(657),4)
  call Hotf_4pt_reduction_last(G2tensor(55),RedSet_4(10),mass4set(:,86),  & 
G1tensor(661),G1tensor(662),G1tensor(663),G1tensor(664),G1tensor(665))
  call G_TensorShift(G1tensor(662),4)
  call Hotf_4pt_reduction_last(G2tensor(501),RedSet_4(11),mass4set(:,13),  & 
G1tensor(666),G1tensor(667),G1tensor(668),G1tensor(669),G1tensor(670))
  call G_TensorShift(G1tensor(667),4)
  call Hotf_4pt_reduction_last(G2tensor(504),RedSet_4(12),mass4set(:,14),  & 
G1tensor(671),G1tensor(672),G1tensor(673),G1tensor(674),G1tensor(675))
  call G_TensorShift(G1tensor(672),4)
  call Hotf_4pt_reduction_last(G2tensor(70),RedSet_4(10),mass4set(:,87),  & 
G1tensor(676),G1tensor(677),G1tensor(678),G1tensor(679),G1tensor(680))
  call G_TensorShift(G1tensor(677),4)
  call Hotf_4pt_reduction_last(G2tensor(495),RedSet_4(11),mass4set(:,15),  & 
G1tensor(681),G1tensor(682),G1tensor(683),G1tensor(684),G1tensor(685))
  call G_TensorShift(G1tensor(682),4)
  call Hotf_4pt_reduction_last(G2tensor(498),RedSet_4(12),mass4set(:,16),  & 
G1tensor(686),G1tensor(687),G1tensor(688),G1tensor(689),G1tensor(690))
  call G_TensorShift(G1tensor(687),4)
  call Hotf_4pt_reduction_last(G2tensor(73),RedSet_4(10),mass4set(:,88),  & 
G1tensor(691),G1tensor(692),G1tensor(693),G1tensor(694),G1tensor(695))
  call G_TensorShift(G1tensor(692),4)
  call Hotf_4pt_reduction_last(G2tensor(519),RedSet_4(12),mass4set(:,17),  & 
G1tensor(696),G1tensor(697),G1tensor(698),G1tensor(699),G1tensor(700))
  call G_TensorShift(G1tensor(697),4)
  call Hotf_4pt_reduction_last(G2tensor(127),RedSet_4(15),mass4set(:,83),  & 
G1tensor(701),G1tensor(702),G1tensor(703),G1tensor(704),G1tensor(705))
  call G_TensorShift(G1tensor(702),8)
  call Hotf_4pt_reduction_last(G2tensor(555),RedSet_4(16),mass4set(:,8),  & 
G1tensor(706),G1tensor(707),G1tensor(708),G1tensor(709),G1tensor(710))
  call G_TensorShift(G1tensor(707),8)
  call Hotf_4pt_reduction_last(G2tensor(558),RedSet_4(17),mass4set(:,9),  & 
G1tensor(711),G1tensor(712),G1tensor(713),G1tensor(714),G1tensor(715))
  call G_TensorShift(G1tensor(712),8)
  call Hotf_4pt_reduction_last(G2tensor(82),RedSet_4(15),mass4set(:,84),  & 
G1tensor(716),G1tensor(717),G1tensor(718),G1tensor(719),G1tensor(720))
  call G_TensorShift(G1tensor(717),8)
  call Hotf_4pt_reduction_last(G2tensor(528),RedSet_4(16),mass4set(:,10),  & 
G1tensor(721),G1tensor(722),G1tensor(723),G1tensor(724),G1tensor(725))
  call G_TensorShift(G1tensor(722),8)
  call Hotf_4pt_reduction_last(G2tensor(531),RedSet_4(17),mass4set(:,11),  & 
G1tensor(726),G1tensor(727),G1tensor(728),G1tensor(729),G1tensor(730))
  call G_TensorShift(G1tensor(727),8)
  call Hotf_4pt_reduction_last(G2tensor(112),RedSet_4(15),mass4set(:,85),  & 
G1tensor(731),G1tensor(732),G1tensor(733),G1tensor(734),G1tensor(735))
  call G_TensorShift(G1tensor(732),8)
  call Hotf_4pt_reduction_last(G2tensor(561),RedSet_4(17),mass4set(:,12),  & 
G1tensor(736),G1tensor(737),G1tensor(738),G1tensor(739),G1tensor(740))
  call G_TensorShift(G1tensor(737),8)
  call Hotf_4pt_reduction_last(G2tensor(106),RedSet_4(15),mass4set(:,86),  & 
G1tensor(741),G1tensor(742),G1tensor(743),G1tensor(744),G1tensor(745))
  call G_TensorShift(G1tensor(742),8)
  call Hotf_4pt_reduction_last(G2tensor(549),RedSet_4(16),mass4set(:,13),  & 
G1tensor(746),G1tensor(747),G1tensor(748),G1tensor(749),G1tensor(750))
  call G_TensorShift(G1tensor(747),8)
  call Hotf_4pt_reduction_last(G2tensor(552),RedSet_4(17),mass4set(:,14),  & 
G1tensor(751),G1tensor(752),G1tensor(753),G1tensor(754),G1tensor(755))
  call G_TensorShift(G1tensor(752),8)
  call Hotf_4pt_reduction_last(G2tensor(91),RedSet_4(15),mass4set(:,87),  & 
G1tensor(756),G1tensor(757),G1tensor(758),G1tensor(759),G1tensor(760))
  call G_TensorShift(G1tensor(757),8)
  call Hotf_4pt_reduction_last(G2tensor(543),RedSet_4(16),mass4set(:,15),  & 
G1tensor(761),G1tensor(762),G1tensor(763),G1tensor(764),G1tensor(765))
  call G_TensorShift(G1tensor(762),8)
  call Hotf_4pt_reduction_last(G2tensor(546),RedSet_4(17),mass4set(:,16),  & 
G1tensor(766),G1tensor(767),G1tensor(768),G1tensor(769),G1tensor(770))
  call G_TensorShift(G1tensor(767),8)
  call Hotf_4pt_reduction_last(G2tensor(124),RedSet_4(15),mass4set(:,88),  & 
G1tensor(771),G1tensor(772),G1tensor(773),G1tensor(774),G1tensor(775))
  call G_TensorShift(G1tensor(772),8)
  call Hotf_4pt_reduction_last(G2tensor(567),RedSet_4(17),mass4set(:,17),  & 
G1tensor(776),G1tensor(777),G1tensor(778),G1tensor(779),G1tensor(780))
  call G_TensorShift(G1tensor(777),8)
  call Hotf_4pt_reduction_last(G2tensor(181),RedSet_4(20),mass4set(:,89),  & 
G1tensor(781),G1tensor(782),G1tensor(783),G1tensor(784),G1tensor(785))
  call G_TensorShift(G1tensor(782),4)
  call Hotf_4pt_reduction_last(G2tensor(196),RedSet_4(21),mass4set(:,72),  & 
G1tensor(786),G1tensor(787),G1tensor(788),G1tensor(789),G1tensor(790))
  call G_TensorShift(G1tensor(787),4)
  call Hotf_4pt_reduction_last(G2tensor(160),RedSet_4(20),mass4set(:,90),  & 
G1tensor(791),G1tensor(792),G1tensor(793),G1tensor(794),G1tensor(795))
  call G_TensorShift(G1tensor(792),4)
  call Hotf_4pt_reduction_last(G2tensor(142),RedSet_4(21),mass4set(:,5),  & 
G1tensor(796),G1tensor(797),G1tensor(798),G1tensor(799),G1tensor(800))
  call G_TensorShift(G1tensor(797),4)
  call Hotf_4pt_reduction_last(G2tensor(199),RedSet_4(20),mass4set(:,91),  & 
G1tensor(801),G1tensor(802),G1tensor(803),G1tensor(804),G1tensor(805))
  call G_TensorShift(G1tensor(802),4)
  call Hotf_4pt_reduction_last(G2tensor(190),RedSet_4(20),mass4set(:,92),  & 
G1tensor(806),G1tensor(807),G1tensor(808),G1tensor(809),G1tensor(810))
  call G_TensorShift(G1tensor(807),4)
  call Hotf_4pt_reduction_last(G2tensor(184),RedSet_4(21),mass4set(:,6),  & 
G1tensor(811),G1tensor(812),G1tensor(813),G1tensor(814),G1tensor(815))
  call G_TensorShift(G1tensor(812),4)
  call Hotf_4pt_reduction_last(G2tensor(220),RedSet_4(20),mass4set(:,93),  & 
G1tensor(816),G1tensor(817),G1tensor(818),G1tensor(819),G1tensor(820))
  call G_TensorShift(G1tensor(817),4)
  call Hotf_4pt_reduction_last(G2tensor(187),RedSet_4(20),mass4set(:,94),  & 
G1tensor(821),G1tensor(822),G1tensor(823),G1tensor(824),G1tensor(825))
  call G_TensorShift(G1tensor(822),4)
  call Hotf_4pt_reduction_last(G2tensor(172),RedSet_4(21),mass4set(:,7),  & 
G1tensor(826),G1tensor(827),G1tensor(828),G1tensor(829),G1tensor(830))
  call G_TensorShift(G1tensor(827),4)
  call Hotf_4pt_reduction_last(G2tensor(238),RedSet_4(24),mass4set(:,89),  & 
G1tensor(831),G1tensor(832),G1tensor(833),G1tensor(834),G1tensor(835))
  call G_TensorShift(G1tensor(832),8)
  call Hotf_4pt_reduction_last(G2tensor(223),RedSet_4(24),mass4set(:,90),  & 
G1tensor(836),G1tensor(837),G1tensor(838),G1tensor(839),G1tensor(840))
  call G_TensorShift(G1tensor(837),8)
  call Hotf_4pt_reduction_last(G2tensor(235),RedSet_4(24),mass4set(:,91),  & 
G1tensor(841),G1tensor(842),G1tensor(843),G1tensor(844),G1tensor(845))
  call G_TensorShift(G1tensor(842),8)
  call Hotf_4pt_reduction_last(G2tensor(229),RedSet_4(24),mass4set(:,92),  & 
G1tensor(846),G1tensor(847),G1tensor(848),G1tensor(849),G1tensor(850))
  call G_TensorShift(G1tensor(847),8)
  call Hotf_4pt_reduction_last(G2tensor(217),RedSet_4(24),mass4set(:,94),  & 
G1tensor(851),G1tensor(852),G1tensor(853),G1tensor(854),G1tensor(855))
  call G_TensorShift(G1tensor(852),8)
  call Hotf_4pt_reduction_last(G2tensor(259),RedSet_4(24),mass4set(:,93),  & 
G1tensor(856),G1tensor(857),G1tensor(858),G1tensor(859),G1tensor(860))
  call G_TensorShift(G1tensor(857),8)
  call Hotf_4pt_reduction_last(G2tensor(247),RedSet_4(27),mass4set(:,95),  & 
G1tensor(861),G1tensor(862),G1tensor(863),G1tensor(864),G1tensor(865))
  call G_TensorShift(G1tensor(862),2)
  call Hotf_4pt_reduction_last(G2tensor(262),RedSet_4(28),mass4set(:,96),  & 
G1tensor(866),G1tensor(867),G1tensor(868),G1tensor(869),G1tensor(870))
  call G_TensorShift(G1tensor(867),2)
  call Hotf_4pt_reduction_last(G2tensor(253),RedSet_4(29),mass4set(:,97),  & 
G1tensor(871),G1tensor(872),G1tensor(873),G1tensor(874),G1tensor(875))
  call G_TensorShift(G1tensor(872),2)
  call Hotf_4pt_reduction_last(G2tensor(284),RedSet_4(27),mass4set(:,98),  & 
G1tensor(876),G1tensor(877),G1tensor(878),G1tensor(879),G1tensor(880))
  call G_TensorShift(G1tensor(877),2)
  call Hotf_4pt_reduction_last(G2tensor(285),RedSet_4(28),mass4set(:,99),  & 
G1tensor(881),G1tensor(882),G1tensor(883),G1tensor(884),G1tensor(885))
  call G_TensorShift(G1tensor(882),2)
  call Hotf_4pt_reduction_last(G2tensor(582),RedSet_4(29),mass4set(:,18),  & 
G1tensor(886),G1tensor(887),G1tensor(888),G1tensor(889),G1tensor(890))
  call G_TensorShift(G1tensor(887),2)
  call Hotf_4pt_reduction_last(G2tensor(274),RedSet_4(27),mass4set(:,100),  & 
G1tensor(891),G1tensor(892),G1tensor(893),G1tensor(894),G1tensor(895))
  call G_TensorShift(G1tensor(892),2)
  call Hotf_4pt_reduction_last(G2tensor(573),RedSet_4(29),mass4set(:,19),  & 
G1tensor(896),G1tensor(897),G1tensor(898),G1tensor(899),G1tensor(900))
  call G_TensorShift(G1tensor(897),2)
  call Hotf_4pt_reduction_last(G2tensor(286),RedSet_4(27),mass4set(:,101),  & 
G1tensor(901),G1tensor(902),G1tensor(903),G1tensor(904),G1tensor(905))
  call G_TensorShift(G1tensor(902),2)
  call Hotf_4pt_reduction_last(G2tensor(585),RedSet_4(29),mass4set(:,20),  & 
G1tensor(906),G1tensor(907),G1tensor(908),G1tensor(909),G1tensor(910))
  call G_TensorShift(G1tensor(907),2)
  call Hotf_4pt_reduction_last(G2tensor(287),RedSet_4(27),mass4set(:,102),  & 
G1tensor(911),G1tensor(912),G1tensor(913),G1tensor(914),G1tensor(915))
  call G_TensorShift(G1tensor(912),2)
  call Hotf_4pt_reduction_last(G2tensor(288),RedSet_4(28),mass4set(:,103),  & 
G1tensor(916),G1tensor(917),G1tensor(918),G1tensor(919),G1tensor(920))
  call G_TensorShift(G1tensor(917),2)
  call Hotf_4pt_reduction_last(G2tensor(588),RedSet_4(29),mass4set(:,21),  & 
G1tensor(921),G1tensor(922),G1tensor(923),G1tensor(924),G1tensor(925))
  call G_TensorShift(G1tensor(922),2)
  call Hotf_4pt_reduction_last(G2tensor(279),RedSet_4(27),mass4set(:,104),  & 
G1tensor(926),G1tensor(927),G1tensor(928),G1tensor(929),G1tensor(930))
  call G_TensorShift(G1tensor(927),2)
  call Hotf_4pt_reduction_last(G2tensor(280),RedSet_4(28),mass4set(:,105),  & 
G1tensor(931),G1tensor(932),G1tensor(933),G1tensor(934),G1tensor(935))
  call G_TensorShift(G1tensor(932),2)
  call Hotf_4pt_reduction_last(G2tensor(281),RedSet_4(29),mass4set(:,106),  & 
G1tensor(936),G1tensor(937),G1tensor(938),G1tensor(939),G1tensor(940))
  call G_TensorShift(G1tensor(937),2)
  call Hotf_4pt_reduction_last(G2tensor(282),RedSet_4(27),mass4set(:,107),  & 
G1tensor(941),G1tensor(942),G1tensor(943),G1tensor(944),G1tensor(945))
  call G_TensorShift(G1tensor(942),2)
  call Hotf_4pt_reduction_last(G2tensor(283),RedSet_4(29),mass4set(:,108),  & 
G1tensor(946),G1tensor(947),G1tensor(948),G1tensor(949),G1tensor(950))
  call G_TensorShift(G1tensor(947),2)
  call Hotf_4pt_reduction_last(G2tensor(289),RedSet_4(27),mass4set(:,109),  & 
G1tensor(951),G1tensor(952),G1tensor(953),G1tensor(954),G1tensor(955))
  call G_TensorShift(G1tensor(952),2)
  call Hotf_4pt_reduction_last(G2tensor(290),RedSet_4(29),mass4set(:,110),  & 
G1tensor(956),G1tensor(957),G1tensor(958),G1tensor(959),G1tensor(960))
  call G_TensorShift(G1tensor(957),2)
  call Hotf_4pt_reduction_last(G2tensor(295),RedSet_4(27),mass4set(:,111),  & 
G1tensor(961),G1tensor(962),G1tensor(963),G1tensor(964),G1tensor(965))
  call G_TensorShift(G1tensor(962),2)
  call Hotf_4pt_reduction_last(G2tensor(296),RedSet_4(29),mass4set(:,112),  & 
G1tensor(966),G1tensor(967),G1tensor(968),G1tensor(969),G1tensor(970))
  call G_TensorShift(G1tensor(967),2)
  call Hotf_4pt_reduction_last(G2tensor(293),RedSet_4(27),mass4set(:,113),  & 
G1tensor(971),G1tensor(972),G1tensor(973),G1tensor(974),G1tensor(975))
  call G_TensorShift(G1tensor(972),2)
  call Hotf_4pt_reduction_last(G2tensor(294),RedSet_4(29),mass4set(:,114),  & 
G1tensor(976),G1tensor(977),G1tensor(978),G1tensor(979),G1tensor(980))
  call G_TensorShift(G1tensor(977),2)
  call Hotf_4pt_reduction_last(G2tensor(297),RedSet_4(31),mass4set(:,95),  & 
G1tensor(981),G1tensor(982),G1tensor(983),G1tensor(984),G1tensor(985))
  call G_TensorShift(G1tensor(982),2)
  call Hotf_4pt_reduction_last(G2tensor(298),RedSet_4(32),mass4set(:,96),  & 
G1tensor(986),G1tensor(987),G1tensor(988),G1tensor(989),G1tensor(990))
  call G_TensorShift(G1tensor(987),2)
  call Hotf_4pt_reduction_last(G2tensor(306),RedSet_4(31),mass4set(:,98),  & 
G1tensor(991),G1tensor(992),G1tensor(993),G1tensor(994),G1tensor(995))
  call G_TensorShift(G1tensor(992),2)
  call Hotf_4pt_reduction_last(G2tensor(307),RedSet_4(32),mass4set(:,99),  & 
G1tensor(996),G1tensor(997),G1tensor(998),G1tensor(999),G1tensor(1000))
  call G_TensorShift(G1tensor(997),2)
  call Hotf_4pt_reduction_last(G2tensor(301),RedSet_4(31),mass4set(:,100),  & 
G1tensor(1001),G1tensor(1002),G1tensor(1003),G1tensor(1004),G1tensor(1005))
  call G_TensorShift(G1tensor(1002),2)
  call Hotf_4pt_reduction_last(G2tensor(308),RedSet_4(31),mass4set(:,101),  & 
G1tensor(1006),G1tensor(1007),G1tensor(1008),G1tensor(1009),G1tensor(1010))
  call G_TensorShift(G1tensor(1007),2)
  call Hotf_4pt_reduction_last(G2tensor(303),RedSet_4(31),mass4set(:,104),  & 
G1tensor(1011),G1tensor(1012),G1tensor(1013),G1tensor(1014),G1tensor(1015))
  call G_TensorShift(G1tensor(1012),2)
  call Hotf_4pt_reduction_last(G2tensor(304),RedSet_4(32),mass4set(:,105),  & 
G1tensor(1016),G1tensor(1017),G1tensor(1018),G1tensor(1019),G1tensor(1020))
  call G_TensorShift(G1tensor(1017),2)
  call Hotf_4pt_reduction_last(G2tensor(305),RedSet_4(31),mass4set(:,107),  & 
G1tensor(1021),G1tensor(1022),G1tensor(1023),G1tensor(1024),G1tensor(1025))
  call G_TensorShift(G1tensor(1022),2)
  call Hotf_4pt_reduction_last(G2tensor(309),RedSet_4(31),mass4set(:,109),  & 
G1tensor(1026),G1tensor(1027),G1tensor(1028),G1tensor(1029),G1tensor(1030))
  call G_TensorShift(G1tensor(1027),2)
  call Hotf_4pt_reduction_last(G2tensor(312),RedSet_4(31),mass4set(:,111),  & 
G1tensor(1031),G1tensor(1032),G1tensor(1033),G1tensor(1034),G1tensor(1035))
  call G_TensorShift(G1tensor(1032),2)
  call Hotf_4pt_reduction_last(G2tensor(311),RedSet_4(31),mass4set(:,113),  & 
G1tensor(1036),G1tensor(1037),G1tensor(1038),G1tensor(1039),G1tensor(1040))
  call G_TensorShift(G1tensor(1037),2)
  call Hotf_4pt_reduction_last(G2tensor(313),RedSet_4(15),mass4set(:,56),  & 
G1tensor(1041),G1tensor(1042),G1tensor(1043),G1tensor(1044),G1tensor(1045))
  call G_TensorShift(G1tensor(1042),8)
  call Hotf_4pt_reduction_last(G2tensor(319),RedSet_4(15),mass4set(:,57),  & 
G1tensor(1046),G1tensor(1047),G1tensor(1048),G1tensor(1049),G1tensor(1050))
  call G_TensorShift(G1tensor(1047),8)
  call Hotf_4pt_reduction_last(G2tensor(315),RedSet_4(15),mass4set(:,58),  & 
G1tensor(1051),G1tensor(1052),G1tensor(1053),G1tensor(1054),G1tensor(1055))
  call G_TensorShift(G1tensor(1052),8)
  call Hotf_4pt_reduction_last(G2tensor(320),RedSet_4(15),mass4set(:,59),  & 
G1tensor(1056),G1tensor(1057),G1tensor(1058),G1tensor(1059),G1tensor(1060))
  call G_TensorShift(G1tensor(1057),8)
  call Hotf_4pt_reduction_last(G2tensor(317),RedSet_4(15),mass4set(:,61),  & 
G1tensor(1061),G1tensor(1062),G1tensor(1063),G1tensor(1064),G1tensor(1065))
  call G_TensorShift(G1tensor(1062),8)
  call Hotf_4pt_reduction_last(G2tensor(318),RedSet_4(15),mass4set(:,62),  & 
G1tensor(1066),G1tensor(1067),G1tensor(1068),G1tensor(1069),G1tensor(1070))
  call G_TensorShift(G1tensor(1067),8)
  call Hotf_4pt_reduction_last(G2tensor(321),RedSet_4(15),mass4set(:,63),  & 
G1tensor(1071),G1tensor(1072),G1tensor(1073),G1tensor(1074),G1tensor(1075))
  call G_TensorShift(G1tensor(1072),8)
  call Hotf_4pt_reduction_last(G2tensor(324),RedSet_4(15),mass4set(:,64),  & 
G1tensor(1076),G1tensor(1077),G1tensor(1078),G1tensor(1079),G1tensor(1080))
  call G_TensorShift(G1tensor(1077),8)
  call Hotf_4pt_reduction_last(G2tensor(323),RedSet_4(15),mass4set(:,65),  & 
G1tensor(1081),G1tensor(1082),G1tensor(1083),G1tensor(1084),G1tensor(1085))
  call G_TensorShift(G1tensor(1082),8)
  call Hotf_4pt_reduction_last(G2tensor(325),RedSet_4(42),mass4set(:,56),  & 
G1tensor(1086),G1tensor(1087),G1tensor(1088),G1tensor(1089),G1tensor(1090))
  call G_TensorShift(G1tensor(1087),4)
  call Hotf_4pt_reduction_last(G2tensor(332),RedSet_4(42),mass4set(:,57),  & 
G1tensor(1091),G1tensor(1092),G1tensor(1093),G1tensor(1094),G1tensor(1095))
  call G_TensorShift(G1tensor(1092),4)
  call Hotf_4pt_reduction_last(G2tensor(327),RedSet_4(42),mass4set(:,58),  & 
G1tensor(1096),G1tensor(1097),G1tensor(1098),G1tensor(1099),G1tensor(1100))
  call G_TensorShift(G1tensor(1097),4)
  call Hotf_4pt_reduction_last(G2tensor(333),RedSet_4(42),mass4set(:,59),  & 
G1tensor(1101),G1tensor(1102),G1tensor(1103),G1tensor(1104),G1tensor(1105))
  call G_TensorShift(G1tensor(1102),4)
  call Hotf_4pt_reduction_last(G2tensor(334),RedSet_4(42),mass4set(:,60),  & 
G1tensor(1106),G1tensor(1107),G1tensor(1108),G1tensor(1109),G1tensor(1110))
  call G_TensorShift(G1tensor(1107),4)
  call Hotf_4pt_reduction_last(G2tensor(330),RedSet_4(42),mass4set(:,61),  & 
G1tensor(1111),G1tensor(1112),G1tensor(1113),G1tensor(1114),G1tensor(1115))
  call G_TensorShift(G1tensor(1112),4)
  call Hotf_4pt_reduction_last(G2tensor(331),RedSet_4(42),mass4set(:,62),  & 
G1tensor(1116),G1tensor(1117),G1tensor(1118),G1tensor(1119),G1tensor(1120))
  call G_TensorShift(G1tensor(1117),4)
  call Hotf_4pt_reduction_last(G2tensor(335),RedSet_4(42),mass4set(:,63),  & 
G1tensor(1121),G1tensor(1122),G1tensor(1123),G1tensor(1124),G1tensor(1125))
  call G_TensorShift(G1tensor(1122),4)
  call Hotf_4pt_reduction_last(G2tensor(338),RedSet_4(42),mass4set(:,64),  & 
G1tensor(1126),G1tensor(1127),G1tensor(1128),G1tensor(1129),G1tensor(1130))
  call G_TensorShift(G1tensor(1127),4)
  call Hotf_4pt_reduction_last(G2tensor(337),RedSet_4(42),mass4set(:,65),  & 
G1tensor(1131),G1tensor(1132),G1tensor(1133),G1tensor(1134),G1tensor(1135))
  call G_TensorShift(G1tensor(1132),4)
  call Hotf_4pt_reduction_last(G2tensor(345),RedSet_4(43),mass4set(:,115),  & 
G1tensor(1136),G1tensor(1137),G1tensor(1138),G1tensor(1139),G1tensor(1140))
  call G_TensorShift(G1tensor(1137),8)
  call Hotf_4pt_reduction_last(G2tensor(340),RedSet_4(43),mass4set(:,116),  & 
G1tensor(1141),G1tensor(1142),G1tensor(1143),G1tensor(1144),G1tensor(1145))
  call G_TensorShift(G1tensor(1142),8)
  call Hotf_4pt_reduction_last(G2tensor(346),RedSet_4(43),mass4set(:,117),  & 
G1tensor(1146),G1tensor(1147),G1tensor(1148),G1tensor(1149),G1tensor(1150))
  call G_TensorShift(G1tensor(1147),8)
  call Hotf_4pt_reduction_last(G2tensor(344),RedSet_4(43),mass4set(:,118),  & 
G1tensor(1151),G1tensor(1152),G1tensor(1153),G1tensor(1154),G1tensor(1155))
  call G_TensorShift(G1tensor(1152),8)
  call Hotf_4pt_reduction_last(G2tensor(343),RedSet_4(43),mass4set(:,119),  & 
G1tensor(1156),G1tensor(1157),G1tensor(1158),G1tensor(1159),G1tensor(1160))
  call G_TensorShift(G1tensor(1157),8)
  call Hotf_4pt_reduction_last(G2tensor(348),RedSet_4(43),mass4set(:,120),  & 
G1tensor(1161),G1tensor(1162),G1tensor(1163),G1tensor(1164),G1tensor(1165))
  call G_TensorShift(G1tensor(1162),8)
  call Hotf_4pt_reduction_last(G2tensor(391),RedSet_4(44),mass4set(:,121),  & 
G1tensor(1166),G1tensor(1167),G1tensor(1168),G1tensor(1169),G1tensor(1170))
  call G_TensorShift(G1tensor(1167),2)
  call Hotf_4pt_reduction_last(G2tensor(386),RedSet_4(44),mass4set(:,122),  & 
G1tensor(1171),G1tensor(1172),G1tensor(1173),G1tensor(1174),G1tensor(1175))
  call G_TensorShift(G1tensor(1172),2)
  call Hotf_4pt_reduction_last(G2tensor(392),RedSet_4(44),mass4set(:,123),  & 
G1tensor(1176),G1tensor(1177),G1tensor(1178),G1tensor(1179),G1tensor(1180))
  call G_TensorShift(G1tensor(1177),2)
  call Hotf_4pt_reduction_last(G2tensor(390),RedSet_4(44),mass4set(:,124),  & 
G1tensor(1181),G1tensor(1182),G1tensor(1183),G1tensor(1184),G1tensor(1185))
  call G_TensorShift(G1tensor(1182),2)
  call Hotf_4pt_reduction_last(G2tensor(389),RedSet_4(44),mass4set(:,125),  & 
G1tensor(1186),G1tensor(1187),G1tensor(1188),G1tensor(1189),G1tensor(1190))
  call G_TensorShift(G1tensor(1187),2)
  call Hotf_4pt_reduction_last(G2tensor(394),RedSet_4(44),mass4set(:,126),  & 
G1tensor(1191),G1tensor(1192),G1tensor(1193),G1tensor(1194),G1tensor(1195))
  call G_TensorShift(G1tensor(1192),2)
  call Hotf_4pt_reduction_last(G2tensor(395),RedSet_4(45),mass4set(:,66),  & 
G1tensor(1196),G1tensor(1197),G1tensor(1198),G1tensor(1199),G1tensor(1200))
  call G_TensorShift(G1tensor(1197),4)
  call Hotf_4pt_reduction_last(G2tensor(396),RedSet_4(45),mass4set(:,69),  & 
G1tensor(1201),G1tensor(1202),G1tensor(1203),G1tensor(1204),G1tensor(1205))
  call G_TensorShift(G1tensor(1202),4)
  call Hotf_4pt_reduction_last(G2tensor(404),RedSet_4(45),mass4set(:,68),  & 
G1tensor(1206),G1tensor(1207),G1tensor(1208),G1tensor(1209),G1tensor(1210))
  call G_TensorShift(G1tensor(1207),4)
  call Hotf_4pt_reduction_last(G2tensor(405),RedSet_4(45),mass4set(:,70),  & 
G1tensor(1211),G1tensor(1212),G1tensor(1213),G1tensor(1214),G1tensor(1215))
  call G_TensorShift(G1tensor(1212),4)
  call Hotf_4pt_reduction_last(G2tensor(406),RedSet_4(45),mass4set(:,71),  & 
G1tensor(1216),G1tensor(1217),G1tensor(1218),G1tensor(1219),G1tensor(1220))
  call G_TensorShift(G1tensor(1217),4)
  call Hotf_4pt_reduction_last(G2tensor(400),RedSet_4(45),mass4set(:,77),  & 
G1tensor(1221),G1tensor(1222),G1tensor(1223),G1tensor(1224),G1tensor(1225))
  call G_TensorShift(G1tensor(1222),4)
  call Hotf_4pt_reduction_last(G2tensor(408),RedSet_4(45),mass4set(:,79),  & 
G1tensor(1226),G1tensor(1227),G1tensor(1228),G1tensor(1229),G1tensor(1230))
  call G_TensorShift(G1tensor(1227),4)
  call Hotf_4pt_reduction_last(G2tensor(402),RedSet_4(45),mass4set(:,73),  & 
G1tensor(1231),G1tensor(1232),G1tensor(1233),G1tensor(1234),G1tensor(1235))
  call G_TensorShift(G1tensor(1232),4)
  call Hotf_4pt_reduction_last(G2tensor(403),RedSet_4(45),mass4set(:,75),  & 
G1tensor(1236),G1tensor(1237),G1tensor(1238),G1tensor(1239),G1tensor(1240))
  call G_TensorShift(G1tensor(1237),4)
  call Hotf_4pt_reduction_last(G2tensor(407),RedSet_4(45),mass4set(:,81),  & 
G1tensor(1241),G1tensor(1242),G1tensor(1243),G1tensor(1244),G1tensor(1245))
  call G_TensorShift(G1tensor(1242),4)
  call Hotf_4pt_reduction_last(G2tensor(409),RedSet_4(38),mass4set(:,66),  & 
G1tensor(1246),G1tensor(1247),G1tensor(1248),G1tensor(1249),G1tensor(1250))
  call G_TensorShift(G1tensor(1247),4)
  call Hotf_4pt_reduction_last(G2tensor(419),RedSet_4(38),mass4set(:,68),  & 
G1tensor(1251),G1tensor(1252),G1tensor(1253),G1tensor(1254),G1tensor(1255))
  call G_TensorShift(G1tensor(1252),4)
  call Hotf_4pt_reduction_last(G2tensor(411),RedSet_4(38),mass4set(:,69),  & 
G1tensor(1256),G1tensor(1257),G1tensor(1258),G1tensor(1259),G1tensor(1260))
  call G_TensorShift(G1tensor(1257),4)
  call Hotf_4pt_reduction_last(G2tensor(420),RedSet_4(38),mass4set(:,70),  & 
G1tensor(1261),G1tensor(1262),G1tensor(1263),G1tensor(1264),G1tensor(1265))
  call G_TensorShift(G1tensor(1262),4)
  call Hotf_4pt_reduction_last(G2tensor(417),RedSet_4(38),mass4set(:,73),  & 
G1tensor(1266),G1tensor(1267),G1tensor(1268),G1tensor(1269),G1tensor(1270))
  call G_TensorShift(G1tensor(1267),4)
  call Hotf_4pt_reduction_last(G2tensor(418),RedSet_4(38),mass4set(:,75),  & 
G1tensor(1271),G1tensor(1272),G1tensor(1273),G1tensor(1274),G1tensor(1275))
  call G_TensorShift(G1tensor(1272),4)
  call Hotf_4pt_reduction_last(G2tensor(421),RedSet_4(38),mass4set(:,77),  & 
G1tensor(1276),G1tensor(1277),G1tensor(1278),G1tensor(1279),G1tensor(1280))
  call G_TensorShift(G1tensor(1277),4)
  call Hotf_4pt_reduction_last(G2tensor(429),RedSet_4(38),mass4set(:,79),  & 
G1tensor(1281),G1tensor(1282),G1tensor(1283),G1tensor(1284),G1tensor(1285))
  call G_TensorShift(G1tensor(1282),4)
  call Hotf_4pt_reduction_last(G2tensor(428),RedSet_4(38),mass4set(:,81),  & 
G1tensor(1286),G1tensor(1287),G1tensor(1288),G1tensor(1289),G1tensor(1290))
  call G_TensorShift(G1tensor(1287),4)
  call Hotf_4pt_reduction_last(G2tensor(618),RedSet_4(35),mass4set(:,22),  & 
G1tensor(1291),G1tensor(1292),G1tensor(1293),G1tensor(1294),G1tensor(1295))
  call G_TensorShift(G1tensor(1292),9)
  call Hotf_4pt_reduction_last(G2tensor(621),RedSet_4(35),mass4set(:,23),  & 
G1tensor(1296),G1tensor(1297),G1tensor(1298),G1tensor(1299),G1tensor(1300))
  call G_TensorShift(G1tensor(1297),9)
  call Hotf_4pt_reduction_last(G2tensor(624),RedSet_4(35),mass4set(:,24),  & 
G1tensor(1301),G1tensor(1302),G1tensor(1303),G1tensor(1304),G1tensor(1305))
  call G_TensorShift(G1tensor(1302),9)
  call Hotf_4pt_reduction_last(G1tensor(1),RedSet_4(36),mass4set(:,32),  & 
G0tensor(1),G0tensor(2),G0tensor(3),G0tensor(4),G0tensor(5))
  call Hotf_4pt_reduction_last(G1tensor(31),RedSet_4(4),mass4set(:,25),  & 
G0tensor(6),G0tensor(7),G0tensor(8),G0tensor(9),G0tensor(10))
  call Hotf_4pt_reduction_last(G1tensor(61),RedSet_4(36),mass4set(:,33),  & 
G0tensor(11),G0tensor(12),G0tensor(13),G0tensor(14),G0tensor(15))
  call Hotf_4pt_reduction_last(G1tensor(91),RedSet_4(36),mass4set(:,34),  & 
G0tensor(16),G0tensor(17),G0tensor(18),G0tensor(19),G0tensor(20))
  call Hotf_4pt_reduction_last(G1tensor(121),RedSet_4(4),mass4set(:,26),  & 
G0tensor(21),G0tensor(22),G0tensor(23),G0tensor(24),G0tensor(25))
  call Hotf_4pt_reduction_last(G1tensor(151),RedSet_4(36),mass4set(:,35),  & 
G0tensor(26),G0tensor(27),G0tensor(28),G0tensor(29),G0tensor(30))
  call Hotf_4pt_reduction_last(G1tensor(181),RedSet_4(36),mass4set(:,36),  & 
G0tensor(31),G0tensor(32),G0tensor(33),G0tensor(34),G0tensor(35))
  call Hotf_4pt_reduction_last(G1tensor(211),RedSet_4(4),mass4set(:,37),  & 
G0tensor(36),G0tensor(37),G0tensor(38),G0tensor(39),G0tensor(40))
  call Hotf_4pt_reduction_last(G1tensor(241),RedSet_4(36),mass4set(:,38),  & 
G0tensor(41),G0tensor(42),G0tensor(43),G0tensor(44),G0tensor(45))
  call Hotf_4pt_reduction_last(G1tensor(271),RedSet_4(36),mass4set(:,39),  & 
G0tensor(46),G0tensor(47),G0tensor(48),G0tensor(49),G0tensor(50))
  call Hotf_4pt_reduction_last(G1tensor(301),RedSet_4(36),mass4set(:,40),  & 
G0tensor(51),G0tensor(52),G0tensor(53),G0tensor(54),G0tensor(55))
  call Hotf_4pt_reduction_last(G1tensor(331),RedSet_4(4),mass4set(:,27),  & 
G0tensor(56),G0tensor(57),G0tensor(58),G0tensor(59),G0tensor(60))
  call Hotf_4pt_reduction_last(G1tensor(361),RedSet_4(36),mass4set(:,41),  & 
G0tensor(61),G0tensor(62),G0tensor(63),G0tensor(64),G0tensor(65))
  call Hotf_4pt_reduction_last(G1tensor(6),RedSet_4(36),mass4set(:,42),  & 
G0tensor(66),G0tensor(67),G0tensor(68),G0tensor(69),G0tensor(70))
  call Hotf_4pt_reduction_last(G1tensor(18),RedSet_4(37),mass4set(:,32),  & 
G0tensor(71),G0tensor(72),G0tensor(73),G0tensor(74),G0tensor(75))
  call Hotf_4pt_reduction_last(G1tensor(38),RedSet_4(8),mass4set(:,25),  & 
G0tensor(76),G0tensor(77),G0tensor(78),G0tensor(79),G0tensor(80))
  call Hotf_4pt_reduction_last(G1tensor(50),RedSet_4(37),mass4set(:,34),  & 
G0tensor(81),G0tensor(82),G0tensor(83),G0tensor(84),G0tensor(85))
  call Hotf_4pt_reduction_last(G1tensor(66),RedSet_4(8),mass4set(:,26),  & 
G0tensor(86),G0tensor(87),G0tensor(88),G0tensor(89),G0tensor(90))
  call Hotf_4pt_reduction_last(G1tensor(74),RedSet_4(37),mass4set(:,33),  & 
G0tensor(91),G0tensor(92),G0tensor(93),G0tensor(94),G0tensor(95))
  call Hotf_4pt_reduction_last(G1tensor(90),RedSet_4(37),mass4set(:,35),  & 
G0tensor(96),G0tensor(97),G0tensor(98),G0tensor(99),G0tensor(100))
  call Hotf_4pt_reduction_last(G1tensor(116),RedSet_4(37),mass4set(:,40),  & 
G0tensor(101),G0tensor(102),G0tensor(103),G0tensor(104),G0tensor(105))
  call Hotf_4pt_reduction_last(G1tensor(126),RedSet_4(8),mass4set(:,27),  & 
G0tensor(106),G0tensor(107),G0tensor(108),G0tensor(109),G0tensor(110))
  call Hotf_4pt_reduction_last(G1tensor(146),RedSet_4(37),mass4set(:,41),  & 
G0tensor(111),G0tensor(112),G0tensor(113),G0tensor(114),G0tensor(115))
  call Hotf_4pt_reduction_last(G1tensor(180),RedSet_4(37),mass4set(:,38),  & 
G0tensor(116),G0tensor(117),G0tensor(118),G0tensor(119),G0tensor(120))
  call Hotf_4pt_reduction_last(G1tensor(170),RedSet_4(37),mass4set(:,39),  & 
G0tensor(121),G0tensor(122),G0tensor(123),G0tensor(124),G0tensor(125))
  call Hotf_4pt_reduction_last(G1tensor(192),RedSet_4(37),mass4set(:,42),  & 
G0tensor(126),G0tensor(127),G0tensor(128),G0tensor(129),G0tensor(130))
  call Hotf_4pt_reduction_last(G1tensor(200),RedSet_4(6),mass4set(:,43),  & 
G0tensor(131),G0tensor(132),G0tensor(133),G0tensor(134),G0tensor(135))
  call Hotf_4pt_reduction_last(G1tensor(218),RedSet_4(13),mass4set(:,28),  & 
G0tensor(136),G0tensor(137),G0tensor(138),G0tensor(139),G0tensor(140))
  call Hotf_4pt_reduction_last(G1tensor(228),RedSet_4(6),mass4set(:,44),  & 
G0tensor(141),G0tensor(142),G0tensor(143),G0tensor(144),G0tensor(145))
  call Hotf_4pt_reduction_last(G1tensor(234),RedSet_4(13),mass4set(:,30),  & 
G0tensor(146),G0tensor(147),G0tensor(148),G0tensor(149),G0tensor(150))
  call Hotf_4pt_reduction_last(G1tensor(240),RedSet_4(6),mass4set(:,45),  & 
G0tensor(151),G0tensor(152),G0tensor(153),G0tensor(154),G0tensor(155))
  call Hotf_4pt_reduction_last(G1tensor(312),RedSet_4(13),mass4set(:,29),  & 
G0tensor(156),G0tensor(157),G0tensor(158),G0tensor(159),G0tensor(160))
  call Hotf_4pt_reduction_last(G1tensor(272),RedSet_4(6),mass4set(:,46),  & 
G0tensor(161),G0tensor(162),G0tensor(163),G0tensor(164),G0tensor(165))
  call Hotf_4pt_reduction_last(G1tensor(302),RedSet_4(6),mass4set(:,47),  & 
G0tensor(166),G0tensor(167),G0tensor(168),G0tensor(169),G0tensor(170))
  call Hotf_4pt_reduction_last(G1tensor(330),RedSet_4(6),mass4set(:,48),  & 
G0tensor(171),G0tensor(172),G0tensor(173),G0tensor(174),G0tensor(175))
  call Hotf_4pt_reduction_last(G1tensor(342),RedSet_4(13),mass4set(:,31),  & 
G0tensor(176),G0tensor(177),G0tensor(178),G0tensor(179),G0tensor(180))
  call Hotf_4pt_reduction_last(G1tensor(356),RedSet_4(38),mass4set(:,43),  & 
G0tensor(181),G0tensor(182),G0tensor(183),G0tensor(184),G0tensor(185))
  call Hotf_4pt_reduction_last(G1tensor(368),RedSet_4(18),mass4set(:,28),  & 
G0tensor(186),G0tensor(187),G0tensor(188),G0tensor(189),G0tensor(190))
  call Hotf_4pt_reduction_last(G1tensor(4),RedSet_4(38),mass4set(:,44),  & 
G0tensor(191),G0tensor(192),G0tensor(193),G0tensor(194),G0tensor(195))
  call Hotf_4pt_reduction_last(G1tensor(52),RedSet_4(18),mass4set(:,30),  & 
G0tensor(196),G0tensor(197),G0tensor(198),G0tensor(199),G0tensor(200))
  call Hotf_4pt_reduction_last(G1tensor(15),RedSet_4(38),mass4set(:,45),  & 
G0tensor(201),G0tensor(202),G0tensor(203),G0tensor(204),G0tensor(205))
  call Hotf_4pt_reduction_last(G1tensor(23),RedSet_4(18),mass4set(:,29),  & 
G0tensor(206),G0tensor(207),G0tensor(208),G0tensor(209),G0tensor(210))
  call Hotf_4pt_reduction_last(G1tensor(28),RedSet_4(38),mass4set(:,46),  & 
G0tensor(211),G0tensor(212),G0tensor(213),G0tensor(214),G0tensor(215))
  call Hotf_4pt_reduction_last(G1tensor(40),RedSet_4(38),mass4set(:,47),  & 
G0tensor(216),G0tensor(217),G0tensor(218),G0tensor(219),G0tensor(220))
  call Hotf_4pt_reduction_last(G1tensor(107),RedSet_4(38),mass4set(:,48),  & 
G0tensor(221),G0tensor(222),G0tensor(223),G0tensor(224),G0tensor(225))
  call Hotf_4pt_reduction_last(G1tensor(51),RedSet_4(18),mass4set(:,31),  & 
G0tensor(226),G0tensor(227),G0tensor(228),G0tensor(229),G0tensor(230))
  call Hotf_4pt_reduction_last(G1tensor(59),RedSet_4(39),mass4set(:,49),  & 
G0tensor(231),G0tensor(232),G0tensor(233),G0tensor(234),G0tensor(235))
  call Hotf_4pt_reduction_last(G1tensor(69),RedSet_4(22),mass4set(:,22),  & 
G0tensor(236),G0tensor(237),G0tensor(238),G0tensor(239),G0tensor(240))
  call Hotf_4pt_reduction_last(G1tensor(81),RedSet_4(39),mass4set(:,50),  & 
G0tensor(241),G0tensor(242),G0tensor(243),G0tensor(244),G0tensor(245))
  call Hotf_4pt_reduction_last(G1tensor(106),RedSet_4(22),mass4set(:,51),  & 
G0tensor(246),G0tensor(247),G0tensor(248),G0tensor(249),G0tensor(250))
  call Hotf_4pt_reduction_last(G1tensor(148),RedSet_4(39),mass4set(:,52),  & 
G0tensor(251),G0tensor(252),G0tensor(253),G0tensor(254),G0tensor(255))
  call Hotf_4pt_reduction_last(G1tensor(123),RedSet_4(22),mass4set(:,23),  & 
G0tensor(256),G0tensor(257),G0tensor(258),G0tensor(259),G0tensor(260))
  call Hotf_4pt_reduction_last(G1tensor(203),RedSet_4(39),mass4set(:,53),  & 
G0tensor(261),G0tensor(262),G0tensor(263),G0tensor(264),G0tensor(265))
  call Hotf_4pt_reduction_last(G1tensor(137),RedSet_4(39),mass4set(:,54),  & 
G0tensor(266),G0tensor(267),G0tensor(268),G0tensor(269),G0tensor(270))
  call Hotf_4pt_reduction_last(G1tensor(147),RedSet_4(22),mass4set(:,24),  & 
G0tensor(271),G0tensor(272),G0tensor(273),G0tensor(274),G0tensor(275))
  call Hotf_4pt_reduction_last(G1tensor(166),RedSet_4(39),mass4set(:,55),  & 
G0tensor(276),G0tensor(277),G0tensor(278),G0tensor(279),G0tensor(280))
  call Hotf_4pt_reduction_last(G1tensor(160),RedSet_4(40),mass4set(:,49),  & 
G0tensor(281),G0tensor(282),G0tensor(283),G0tensor(284),G0tensor(285))
  call Hotf_4pt_reduction_last(G1tensor(167),RedSet_4(25),mass4set(:,22),  & 
G0tensor(286),G0tensor(287),G0tensor(288),G0tensor(289),G0tensor(290))
  call Hotf_4pt_reduction_last(G1tensor(177),RedSet_4(40),mass4set(:,50),  & 
G0tensor(291),G0tensor(292),G0tensor(293),G0tensor(294),G0tensor(295))
  call Hotf_4pt_reduction_last(G1tensor(257),RedSet_4(25),mass4set(:,51),  & 
G0tensor(296),G0tensor(297),G0tensor(298),G0tensor(299),G0tensor(300))
  call Hotf_4pt_reduction_last(G1tensor(190),RedSet_4(40),mass4set(:,52),  & 
G0tensor(301),G0tensor(302),G0tensor(303),G0tensor(304),G0tensor(305))
  call Hotf_4pt_reduction_last(G1tensor(208),RedSet_4(25),mass4set(:,23),  & 
G0tensor(306),G0tensor(307),G0tensor(308),G0tensor(309),G0tensor(310))
  call Hotf_4pt_reduction_last(G1tensor(231),RedSet_4(40),mass4set(:,53),  & 
G0tensor(311),G0tensor(312),G0tensor(313),G0tensor(314),G0tensor(315))
  call Hotf_4pt_reduction_last(G1tensor(261),RedSet_4(40),mass4set(:,55),  & 
G0tensor(316),G0tensor(317),G0tensor(318),G0tensor(319),G0tensor(320))
  call Hotf_4pt_reduction_last(G1tensor(263),RedSet_4(40),mass4set(:,54),  & 
G0tensor(321),G0tensor(322),G0tensor(323),G0tensor(324),G0tensor(325))
  call Hotf_4pt_reduction_last(G1tensor(329),RedSet_4(25),mass4set(:,24),  & 
G0tensor(326),G0tensor(327),G0tensor(328),G0tensor(329),G0tensor(330))
  call Hotf_4pt_reduction_last(G1tensor(279),RedSet_4(41),mass4set(:,56),  & 
G0tensor(331),G0tensor(332),G0tensor(333),G0tensor(334),G0tensor(335))
  call Hotf_4pt_reduction_last(G1tensor(287),RedSet_4(41),mass4set(:,57),  & 
G0tensor(336),G0tensor(337),G0tensor(338),G0tensor(339),G0tensor(340))
  call Hotf_4pt_reduction_last(G1tensor(347),RedSet_4(41),mass4set(:,58),  & 
G0tensor(341),G0tensor(342),G0tensor(343),G0tensor(344),G0tensor(345))
  call Hotf_4pt_reduction_last(G1tensor(303),RedSet_4(41),mass4set(:,59),  & 
G0tensor(346),G0tensor(347),G0tensor(348),G0tensor(349),G0tensor(350))
  call Hotf_4pt_reduction_last(G1tensor(311),RedSet_4(41),mass4set(:,60),  & 
G0tensor(351),G0tensor(352),G0tensor(353),G0tensor(354),G0tensor(355))
  call Hotf_4pt_reduction_last(G1tensor(358),RedSet_4(41),mass4set(:,61),  & 
G0tensor(356),G0tensor(357),G0tensor(358),G0tensor(359),G0tensor(360))
  call Hotf_4pt_reduction_last(G1tensor(340),RedSet_4(41),mass4set(:,62),  & 
G0tensor(361),G0tensor(362),G0tensor(363),G0tensor(364),G0tensor(365))
  call Hotf_4pt_reduction_last(G1tensor(370),RedSet_4(41),mass4set(:,63),  & 
G0tensor(366),G0tensor(367),G0tensor(368),G0tensor(369),G0tensor(370))
  call Hotf_4pt_reduction_last(G1tensor(363),RedSet_4(41),mass4set(:,64),  & 
G0tensor(371),G0tensor(372),G0tensor(373),G0tensor(374),G0tensor(375))
  call Hotf_4pt_reduction_last(G1tensor(376),RedSet_4(41),mass4set(:,65),  & 
G0tensor(376),G0tensor(377),G0tensor(378),G0tensor(379),G0tensor(380))
  call Hotf_4pt_reduction_last(G1tensor(381),RedSet_4(10),mass4set(:,56),  & 
G0tensor(381),G0tensor(382),G0tensor(383),G0tensor(384),G0tensor(385))
  call Hotf_4pt_reduction_last(G1tensor(386),RedSet_4(33),mass4set(:,22),  & 
G0tensor(386),G0tensor(387),G0tensor(388),G0tensor(389),G0tensor(390))
  call Hotf_4pt_reduction_last(G1tensor(391),RedSet_4(10),mass4set(:,57),  & 
G0tensor(391),G0tensor(392),G0tensor(393),G0tensor(394),G0tensor(395))
  call Hotf_4pt_reduction_last(G1tensor(396),RedSet_4(10),mass4set(:,58),  & 
G0tensor(396),G0tensor(397),G0tensor(398),G0tensor(399),G0tensor(400))
  call Hotf_4pt_reduction_last(G1tensor(401),RedSet_4(33),mass4set(:,23),  & 
G0tensor(401),G0tensor(402),G0tensor(403),G0tensor(404),G0tensor(405))
  call Hotf_4pt_reduction_last(G1tensor(406),RedSet_4(10),mass4set(:,59),  & 
G0tensor(406),G0tensor(407),G0tensor(408),G0tensor(409),G0tensor(410))
  call Hotf_4pt_reduction_last(G1tensor(411),RedSet_4(10),mass4set(:,61),  & 
G0tensor(411),G0tensor(412),G0tensor(413),G0tensor(414),G0tensor(415))
  call Hotf_4pt_reduction_last(G1tensor(416),RedSet_4(10),mass4set(:,62),  & 
G0tensor(416),G0tensor(417),G0tensor(418),G0tensor(419),G0tensor(420))
  call Hotf_4pt_reduction_last(G1tensor(421),RedSet_4(10),mass4set(:,63),  & 
G0tensor(421),G0tensor(422),G0tensor(423),G0tensor(424),G0tensor(425))
  call Hotf_4pt_reduction_last(G1tensor(426),RedSet_4(33),mass4set(:,24),  & 
G0tensor(426),G0tensor(427),G0tensor(428),G0tensor(429),G0tensor(430))
  call Hotf_4pt_reduction_last(G1tensor(431),RedSet_4(10),mass4set(:,64),  & 
G0tensor(431),G0tensor(432),G0tensor(433),G0tensor(434),G0tensor(435))
  call Hotf_4pt_reduction_last(G1tensor(436),RedSet_4(10),mass4set(:,65),  & 
G0tensor(436),G0tensor(437),G0tensor(438),G0tensor(439),G0tensor(440))
  call Hotf_4pt_reduction_last(G1tensor(441),RedSet_4(1),mass4set(:,66),  & 
G0tensor(441),G0tensor(442),G0tensor(443),G0tensor(444),G0tensor(445))
  call Hotf_4pt_reduction_last(G1tensor(446),RedSet_4(2),mass4set(:,5),  & 
G0tensor(446),G0tensor(447),G0tensor(448),G0tensor(449),G0tensor(450))
  call Hotf_4pt_reduction_last(G1tensor(451),RedSet_4(3),mass4set(:,67),  & 
G0tensor(451),G0tensor(452),G0tensor(453),G0tensor(454),G0tensor(455))
  call Hotf_4pt_reduction_last(G1tensor(456),RedSet_4(1),mass4set(:,68),  & 
G0tensor(456),G0tensor(457),G0tensor(458),G0tensor(459),G0tensor(460))
  call Hotf_4pt_reduction_last(G1tensor(461),RedSet_4(2),mass4set(:,6),  & 
G0tensor(461),G0tensor(462),G0tensor(463),G0tensor(464),G0tensor(465))
  call Hotf_4pt_reduction_last(G1tensor(466),RedSet_4(3),mass4set(:,1),  & 
G0tensor(466),G0tensor(467),G0tensor(468),G0tensor(469),G0tensor(470))
  call Hotf_4pt_reduction_last(G1tensor(471),RedSet_4(1),mass4set(:,69),  & 
G0tensor(471),G0tensor(472),G0tensor(473),G0tensor(474),G0tensor(475))
  call Hotf_4pt_reduction_last(G1tensor(476),RedSet_4(3),mass4set(:,2),  & 
G0tensor(476),G0tensor(477),G0tensor(478),G0tensor(479),G0tensor(480))
  call Hotf_4pt_reduction_last(G1tensor(481),RedSet_4(1),mass4set(:,70),  & 
G0tensor(481),G0tensor(482),G0tensor(483),G0tensor(484),G0tensor(485))
  call Hotf_4pt_reduction_last(G1tensor(486),RedSet_4(3),mass4set(:,3),  & 
G0tensor(486),G0tensor(487),G0tensor(488),G0tensor(489),G0tensor(490))
  call Hotf_4pt_reduction_last(G1tensor(491),RedSet_4(1),mass4set(:,71),  & 
G0tensor(491),G0tensor(492),G0tensor(493),G0tensor(494),G0tensor(495))
  call Hotf_4pt_reduction_last(G1tensor(496),RedSet_4(2),mass4set(:,72),  & 
G0tensor(496),G0tensor(497),G0tensor(498),G0tensor(499),G0tensor(500))
  call Hotf_4pt_reduction_last(G1tensor(501),RedSet_4(3),mass4set(:,4),  & 
G0tensor(501),G0tensor(502),G0tensor(503),G0tensor(504),G0tensor(505))
  call Hotf_4pt_reduction_last(G1tensor(506),RedSet_4(1),mass4set(:,73),  & 
G0tensor(506),G0tensor(507),G0tensor(508),G0tensor(509),G0tensor(510))
  call Hotf_4pt_reduction_last(G1tensor(511),RedSet_4(2),mass4set(:,7),  & 
G0tensor(511),G0tensor(512),G0tensor(513),G0tensor(514),G0tensor(515))
  call Hotf_4pt_reduction_last(G1tensor(516),RedSet_4(3),mass4set(:,74),  & 
G0tensor(516),G0tensor(517),G0tensor(518),G0tensor(519),G0tensor(520))
  call Hotf_4pt_reduction_last(G1tensor(521),RedSet_4(1),mass4set(:,75),  & 
G0tensor(521),G0tensor(522),G0tensor(523),G0tensor(524),G0tensor(525))
  call Hotf_4pt_reduction_last(G1tensor(526),RedSet_4(3),mass4set(:,76),  & 
G0tensor(526),G0tensor(527),G0tensor(528),G0tensor(529),G0tensor(530))
  call Hotf_4pt_reduction_last(G1tensor(531),RedSet_4(1),mass4set(:,77),  & 
G0tensor(531),G0tensor(532),G0tensor(533),G0tensor(534),G0tensor(535))
  call Hotf_4pt_reduction_last(G1tensor(536),RedSet_4(3),mass4set(:,78),  & 
G0tensor(536),G0tensor(537),G0tensor(538),G0tensor(539),G0tensor(540))
  call Hotf_4pt_reduction_last(G1tensor(541),RedSet_4(1),mass4set(:,79),  & 
G0tensor(541),G0tensor(542),G0tensor(543),G0tensor(544),G0tensor(545))
  call Hotf_4pt_reduction_last(G1tensor(546),RedSet_4(3),mass4set(:,80),  & 
G0tensor(546),G0tensor(547),G0tensor(548),G0tensor(549),G0tensor(550))
  call Hotf_4pt_reduction_last(G1tensor(551),RedSet_4(1),mass4set(:,81),  & 
G0tensor(551),G0tensor(552),G0tensor(553),G0tensor(554),G0tensor(555))
  call Hotf_4pt_reduction_last(G1tensor(556),RedSet_4(3),mass4set(:,82),  & 
G0tensor(556),G0tensor(557),G0tensor(558),G0tensor(559),G0tensor(560))
  call Hotf_4pt_reduction_last(G1tensor(561),RedSet_4(6),mass4set(:,66),  & 
G0tensor(561),G0tensor(562),G0tensor(563),G0tensor(564),G0tensor(565))
  call Hotf_4pt_reduction_last(G1tensor(566),RedSet_4(7),mass4set(:,5),  & 
G0tensor(566),G0tensor(567),G0tensor(568),G0tensor(569),G0tensor(570))
  call Hotf_4pt_reduction_last(G1tensor(571),RedSet_4(6),mass4set(:,69),  & 
G0tensor(571),G0tensor(572),G0tensor(573),G0tensor(574),G0tensor(575))
  call Hotf_4pt_reduction_last(G1tensor(576),RedSet_4(6),mass4set(:,68),  & 
G0tensor(576),G0tensor(577),G0tensor(578),G0tensor(579),G0tensor(580))
  call Hotf_4pt_reduction_last(G1tensor(581),RedSet_4(7),mass4set(:,6),  & 
G0tensor(581),G0tensor(582),G0tensor(583),G0tensor(584),G0tensor(585))
  call Hotf_4pt_reduction_last(G1tensor(586),RedSet_4(6),mass4set(:,70),  & 
G0tensor(586),G0tensor(587),G0tensor(588),G0tensor(589),G0tensor(590))
  call Hotf_4pt_reduction_last(G1tensor(591),RedSet_4(6),mass4set(:,77),  & 
G0tensor(591),G0tensor(592),G0tensor(593),G0tensor(594),G0tensor(595))
  call Hotf_4pt_reduction_last(G1tensor(596),RedSet_4(6),mass4set(:,79),  & 
G0tensor(596),G0tensor(597),G0tensor(598),G0tensor(599),G0tensor(600))
  call Hotf_4pt_reduction_last(G1tensor(601),RedSet_4(6),mass4set(:,73),  & 
G0tensor(601),G0tensor(602),G0tensor(603),G0tensor(604),G0tensor(605))
  call Hotf_4pt_reduction_last(G1tensor(606),RedSet_4(7),mass4set(:,7),  & 
G0tensor(606),G0tensor(607),G0tensor(608),G0tensor(609),G0tensor(610))
  call Hotf_4pt_reduction_last(G1tensor(611),RedSet_4(6),mass4set(:,75),  & 
G0tensor(611),G0tensor(612),G0tensor(613),G0tensor(614),G0tensor(615))
  call Hotf_4pt_reduction_last(G1tensor(616),RedSet_4(6),mass4set(:,81),  & 
G0tensor(616),G0tensor(617),G0tensor(618),G0tensor(619),G0tensor(620))
  call Hotf_4pt_reduction_last(G1tensor(621),RedSet_4(10),mass4set(:,83),  & 
G0tensor(621),G0tensor(622),G0tensor(623),G0tensor(624),G0tensor(625))
  call Hotf_4pt_reduction_last(G1tensor(626),RedSet_4(11),mass4set(:,8),  & 
G0tensor(626),G0tensor(627),G0tensor(628),G0tensor(629),G0tensor(630))
  call Hotf_4pt_reduction_last(G1tensor(631),RedSet_4(12),mass4set(:,9),  & 
G0tensor(631),G0tensor(632),G0tensor(633),G0tensor(634),G0tensor(635))
  call Hotf_4pt_reduction_last(G1tensor(636),RedSet_4(10),mass4set(:,84),  & 
G0tensor(636),G0tensor(637),G0tensor(638),G0tensor(639),G0tensor(640))
  call Hotf_4pt_reduction_last(G1tensor(641),RedSet_4(11),mass4set(:,10),  & 
G0tensor(641),G0tensor(642),G0tensor(643),G0tensor(644),G0tensor(645))
  call Hotf_4pt_reduction_last(G1tensor(646),RedSet_4(12),mass4set(:,11),  & 
G0tensor(646),G0tensor(647),G0tensor(648),G0tensor(649),G0tensor(650))
  call Hotf_4pt_reduction_last(G1tensor(651),RedSet_4(10),mass4set(:,85),  & 
G0tensor(651),G0tensor(652),G0tensor(653),G0tensor(654),G0tensor(655))
  call Hotf_4pt_reduction_last(G1tensor(656),RedSet_4(12),mass4set(:,12),  & 
G0tensor(656),G0tensor(657),G0tensor(658),G0tensor(659),G0tensor(660))
  call Hotf_4pt_reduction_last(G1tensor(661),RedSet_4(10),mass4set(:,86),  & 
G0tensor(661),G0tensor(662),G0tensor(663),G0tensor(664),G0tensor(665))
  call Hotf_4pt_reduction_last(G1tensor(666),RedSet_4(11),mass4set(:,13),  & 
G0tensor(666),G0tensor(667),G0tensor(668),G0tensor(669),G0tensor(670))
  call Hotf_4pt_reduction_last(G1tensor(671),RedSet_4(12),mass4set(:,14),  & 
G0tensor(671),G0tensor(672),G0tensor(673),G0tensor(674),G0tensor(675))
  call Hotf_4pt_reduction_last(G1tensor(676),RedSet_4(10),mass4set(:,87),  & 
G0tensor(676),G0tensor(677),G0tensor(678),G0tensor(679),G0tensor(680))
  call Hotf_4pt_reduction_last(G1tensor(681),RedSet_4(11),mass4set(:,15),  & 
G0tensor(681),G0tensor(682),G0tensor(683),G0tensor(684),G0tensor(685))
  call Hotf_4pt_reduction_last(G1tensor(686),RedSet_4(12),mass4set(:,16),  & 
G0tensor(686),G0tensor(687),G0tensor(688),G0tensor(689),G0tensor(690))
  call Hotf_4pt_reduction_last(G1tensor(691),RedSet_4(10),mass4set(:,88),  & 
G0tensor(691),G0tensor(692),G0tensor(693),G0tensor(694),G0tensor(695))
  call Hotf_4pt_reduction_last(G1tensor(696),RedSet_4(12),mass4set(:,17),  & 
G0tensor(696),G0tensor(697),G0tensor(698),G0tensor(699),G0tensor(700))
  call Hotf_4pt_reduction_last(G1tensor(701),RedSet_4(15),mass4set(:,83),  & 
G0tensor(701),G0tensor(702),G0tensor(703),G0tensor(704),G0tensor(705))
  call Hotf_4pt_reduction_last(G1tensor(706),RedSet_4(16),mass4set(:,8),  & 
G0tensor(706),G0tensor(707),G0tensor(708),G0tensor(709),G0tensor(710))
  call Hotf_4pt_reduction_last(G1tensor(711),RedSet_4(17),mass4set(:,9),  & 
G0tensor(711),G0tensor(712),G0tensor(713),G0tensor(714),G0tensor(715))
  call Hotf_4pt_reduction_last(G1tensor(716),RedSet_4(15),mass4set(:,84),  & 
G0tensor(716),G0tensor(717),G0tensor(718),G0tensor(719),G0tensor(720))
  call Hotf_4pt_reduction_last(G1tensor(721),RedSet_4(16),mass4set(:,10),  & 
G0tensor(721),G0tensor(722),G0tensor(723),G0tensor(724),G0tensor(725))
  call Hotf_4pt_reduction_last(G1tensor(726),RedSet_4(17),mass4set(:,11),  & 
G0tensor(726),G0tensor(727),G0tensor(728),G0tensor(729),G0tensor(730))
  call Hotf_4pt_reduction_last(G1tensor(731),RedSet_4(15),mass4set(:,85),  & 
G0tensor(731),G0tensor(732),G0tensor(733),G0tensor(734),G0tensor(735))
  call Hotf_4pt_reduction_last(G1tensor(736),RedSet_4(17),mass4set(:,12),  & 
G0tensor(736),G0tensor(737),G0tensor(738),G0tensor(739),G0tensor(740))
  call Hotf_4pt_reduction_last(G1tensor(741),RedSet_4(15),mass4set(:,86),  & 
G0tensor(741),G0tensor(742),G0tensor(743),G0tensor(744),G0tensor(745))
  call Hotf_4pt_reduction_last(G1tensor(746),RedSet_4(16),mass4set(:,13),  & 
G0tensor(746),G0tensor(747),G0tensor(748),G0tensor(749),G0tensor(750))
  call Hotf_4pt_reduction_last(G1tensor(751),RedSet_4(17),mass4set(:,14),  & 
G0tensor(751),G0tensor(752),G0tensor(753),G0tensor(754),G0tensor(755))
  call Hotf_4pt_reduction_last(G1tensor(756),RedSet_4(15),mass4set(:,87),  & 
G0tensor(756),G0tensor(757),G0tensor(758),G0tensor(759),G0tensor(760))
  call Hotf_4pt_reduction_last(G1tensor(761),RedSet_4(16),mass4set(:,15),  & 
G0tensor(761),G0tensor(762),G0tensor(763),G0tensor(764),G0tensor(765))
  call Hotf_4pt_reduction_last(G1tensor(766),RedSet_4(17),mass4set(:,16),  & 
G0tensor(766),G0tensor(767),G0tensor(768),G0tensor(769),G0tensor(770))
  call Hotf_4pt_reduction_last(G1tensor(771),RedSet_4(15),mass4set(:,88),  & 
G0tensor(771),G0tensor(772),G0tensor(773),G0tensor(774),G0tensor(775))
  call Hotf_4pt_reduction_last(G1tensor(776),RedSet_4(17),mass4set(:,17),  & 
G0tensor(776),G0tensor(777),G0tensor(778),G0tensor(779),G0tensor(780))
  call Hotf_4pt_reduction_last(G1tensor(781),RedSet_4(20),mass4set(:,89),  & 
G0tensor(781),G0tensor(782),G0tensor(783),G0tensor(784),G0tensor(785))
  call Hotf_4pt_reduction_last(G1tensor(786),RedSet_4(21),mass4set(:,72),  & 
G0tensor(786),G0tensor(787),G0tensor(788),G0tensor(789),G0tensor(790))
  call Hotf_4pt_reduction_last(G1tensor(791),RedSet_4(20),mass4set(:,90),  & 
G0tensor(791),G0tensor(792),G0tensor(793),G0tensor(794),G0tensor(795))
  call Hotf_4pt_reduction_last(G1tensor(796),RedSet_4(21),mass4set(:,5),  & 
G0tensor(796),G0tensor(797),G0tensor(798),G0tensor(799),G0tensor(800))
  call Hotf_4pt_reduction_last(G1tensor(801),RedSet_4(20),mass4set(:,91),  & 
G0tensor(801),G0tensor(802),G0tensor(803),G0tensor(804),G0tensor(805))
  call Hotf_4pt_reduction_last(G1tensor(806),RedSet_4(20),mass4set(:,92),  & 
G0tensor(806),G0tensor(807),G0tensor(808),G0tensor(809),G0tensor(810))
  call Hotf_4pt_reduction_last(G1tensor(811),RedSet_4(21),mass4set(:,6),  & 
G0tensor(811),G0tensor(812),G0tensor(813),G0tensor(814),G0tensor(815))
  call Hotf_4pt_reduction_last(G1tensor(816),RedSet_4(20),mass4set(:,93),  & 
G0tensor(816),G0tensor(817),G0tensor(818),G0tensor(819),G0tensor(820))
  call Hotf_4pt_reduction_last(G1tensor(821),RedSet_4(20),mass4set(:,94),  & 
G0tensor(821),G0tensor(822),G0tensor(823),G0tensor(824),G0tensor(825))
  call Hotf_4pt_reduction_last(G1tensor(826),RedSet_4(21),mass4set(:,7),  & 
G0tensor(826),G0tensor(827),G0tensor(828),G0tensor(829),G0tensor(830))
  call Hotf_4pt_reduction_last(G1tensor(831),RedSet_4(24),mass4set(:,89),  & 
G0tensor(831),G0tensor(832),G0tensor(833),G0tensor(834),G0tensor(835))
  call Hotf_4pt_reduction_last(G1tensor(836),RedSet_4(24),mass4set(:,90),  & 
G0tensor(836),G0tensor(837),G0tensor(838),G0tensor(839),G0tensor(840))
  call Hotf_4pt_reduction_last(G1tensor(841),RedSet_4(24),mass4set(:,91),  & 
G0tensor(841),G0tensor(842),G0tensor(843),G0tensor(844),G0tensor(845))
  call Hotf_4pt_reduction_last(G1tensor(846),RedSet_4(24),mass4set(:,92),  & 
G0tensor(846),G0tensor(847),G0tensor(848),G0tensor(849),G0tensor(850))
  call Hotf_4pt_reduction_last(G1tensor(851),RedSet_4(24),mass4set(:,94),  & 
G0tensor(851),G0tensor(852),G0tensor(853),G0tensor(854),G0tensor(855))
  call Hotf_4pt_reduction_last(G1tensor(856),RedSet_4(24),mass4set(:,93),  & 
G0tensor(856),G0tensor(857),G0tensor(858),G0tensor(859),G0tensor(860))
  call Hotf_4pt_reduction_last(G1tensor(861),RedSet_4(27),mass4set(:,95),  & 
G0tensor(861),G0tensor(862),G0tensor(863),G0tensor(864),G0tensor(865))
  call Hotf_4pt_reduction_last(G1tensor(866),RedSet_4(28),mass4set(:,96),  & 
G0tensor(866),G0tensor(867),G0tensor(868),G0tensor(869),G0tensor(870))
  call Hotf_4pt_reduction_last(G1tensor(871),RedSet_4(29),mass4set(:,97),  & 
G0tensor(871),G0tensor(872),G0tensor(873),G0tensor(874),G0tensor(875))
  call Hotf_4pt_reduction_last(G1tensor(876),RedSet_4(27),mass4set(:,98),  & 
G0tensor(876),G0tensor(877),G0tensor(878),G0tensor(879),G0tensor(880))
  call Hotf_4pt_reduction_last(G1tensor(881),RedSet_4(28),mass4set(:,99),  & 
G0tensor(881),G0tensor(882),G0tensor(883),G0tensor(884),G0tensor(885))
  call Hotf_4pt_reduction_last(G1tensor(886),RedSet_4(29),mass4set(:,18),  & 
G0tensor(886),G0tensor(887),G0tensor(888),G0tensor(889),G0tensor(890))
  call Hotf_4pt_reduction_last(G1tensor(891),RedSet_4(27),mass4set(:,100),  & 
G0tensor(891),G0tensor(892),G0tensor(893),G0tensor(894),G0tensor(895))
  call Hotf_4pt_reduction_last(G1tensor(896),RedSet_4(29),mass4set(:,19),  & 
G0tensor(896),G0tensor(897),G0tensor(898),G0tensor(899),G0tensor(900))
  call Hotf_4pt_reduction_last(G1tensor(901),RedSet_4(27),mass4set(:,101),  & 
G0tensor(901),G0tensor(902),G0tensor(903),G0tensor(904),G0tensor(905))
  call Hotf_4pt_reduction_last(G1tensor(906),RedSet_4(29),mass4set(:,20),  & 
G0tensor(906),G0tensor(907),G0tensor(908),G0tensor(909),G0tensor(910))
  call Hotf_4pt_reduction_last(G1tensor(911),RedSet_4(27),mass4set(:,102),  & 
G0tensor(911),G0tensor(912),G0tensor(913),G0tensor(914),G0tensor(915))
  call Hotf_4pt_reduction_last(G1tensor(916),RedSet_4(28),mass4set(:,103),  & 
G0tensor(916),G0tensor(917),G0tensor(918),G0tensor(919),G0tensor(920))
  call Hotf_4pt_reduction_last(G1tensor(921),RedSet_4(29),mass4set(:,21),  & 
G0tensor(921),G0tensor(922),G0tensor(923),G0tensor(924),G0tensor(925))
  call Hotf_4pt_reduction_last(G1tensor(926),RedSet_4(27),mass4set(:,104),  & 
G0tensor(926),G0tensor(927),G0tensor(928),G0tensor(929),G0tensor(930))
  call Hotf_4pt_reduction_last(G1tensor(931),RedSet_4(28),mass4set(:,105),  & 
G0tensor(931),G0tensor(932),G0tensor(933),G0tensor(934),G0tensor(935))
  call Hotf_4pt_reduction_last(G1tensor(936),RedSet_4(29),mass4set(:,106),  & 
G0tensor(936),G0tensor(937),G0tensor(938),G0tensor(939),G0tensor(940))
  call Hotf_4pt_reduction_last(G1tensor(941),RedSet_4(27),mass4set(:,107),  & 
G0tensor(941),G0tensor(942),G0tensor(943),G0tensor(944),G0tensor(945))
  call Hotf_4pt_reduction_last(G1tensor(946),RedSet_4(29),mass4set(:,108),  & 
G0tensor(946),G0tensor(947),G0tensor(948),G0tensor(949),G0tensor(950))
  call Hotf_4pt_reduction_last(G1tensor(951),RedSet_4(27),mass4set(:,109),  & 
G0tensor(951),G0tensor(952),G0tensor(953),G0tensor(954),G0tensor(955))
  call Hotf_4pt_reduction_last(G1tensor(956),RedSet_4(29),mass4set(:,110),  & 
G0tensor(956),G0tensor(957),G0tensor(958),G0tensor(959),G0tensor(960))
  call Hotf_4pt_reduction_last(G1tensor(961),RedSet_4(27),mass4set(:,111),  & 
G0tensor(961),G0tensor(962),G0tensor(963),G0tensor(964),G0tensor(965))
  call Hotf_4pt_reduction_last(G1tensor(966),RedSet_4(29),mass4set(:,112),  & 
G0tensor(966),G0tensor(967),G0tensor(968),G0tensor(969),G0tensor(970))
  call Hotf_4pt_reduction_last(G1tensor(971),RedSet_4(27),mass4set(:,113),  & 
G0tensor(971),G0tensor(972),G0tensor(973),G0tensor(974),G0tensor(975))
  call Hotf_4pt_reduction_last(G1tensor(976),RedSet_4(29),mass4set(:,114),  & 
G0tensor(976),G0tensor(977),G0tensor(978),G0tensor(979),G0tensor(980))
  call Hotf_4pt_reduction_last(G1tensor(981),RedSet_4(31),mass4set(:,95),  & 
G0tensor(981),G0tensor(982),G0tensor(983),G0tensor(984),G0tensor(985))
  call Hotf_4pt_reduction_last(G1tensor(986),RedSet_4(32),mass4set(:,96),  & 
G0tensor(986),G0tensor(987),G0tensor(988),G0tensor(989),G0tensor(990))
  call Hotf_4pt_reduction_last(G1tensor(991),RedSet_4(31),mass4set(:,98),  & 
G0tensor(991),G0tensor(992),G0tensor(993),G0tensor(994),G0tensor(995))
  call Hotf_4pt_reduction_last(G1tensor(996),RedSet_4(32),mass4set(:,99),  & 
G0tensor(996),G0tensor(997),G0tensor(998),G0tensor(999),G0tensor(1000))
  call Hotf_4pt_reduction_last(G1tensor(1001),RedSet_4(31),mass4set(:,100),  & 
G0tensor(1001),G0tensor(1002),G0tensor(1003),G0tensor(1004),G0tensor(1005))
  call Hotf_4pt_reduction_last(G1tensor(1006),RedSet_4(31),mass4set(:,101),  & 
G0tensor(1006),G0tensor(1007),G0tensor(1008),G0tensor(1009),G0tensor(1010))
  call Hotf_4pt_reduction_last(G1tensor(1011),RedSet_4(31),mass4set(:,104),  & 
G0tensor(1011),G0tensor(1012),G0tensor(1013),G0tensor(1014),G0tensor(1015))
  call Hotf_4pt_reduction_last(G1tensor(1016),RedSet_4(32),mass4set(:,105),  & 
G0tensor(1016),G0tensor(1017),G0tensor(1018),G0tensor(1019),G0tensor(1020))
  call Hotf_4pt_reduction_last(G1tensor(1021),RedSet_4(31),mass4set(:,107),  & 
G0tensor(1021),G0tensor(1022),G0tensor(1023),G0tensor(1024),G0tensor(1025))
  call Hotf_4pt_reduction_last(G1tensor(1026),RedSet_4(31),mass4set(:,109),  & 
G0tensor(1026),G0tensor(1027),G0tensor(1028),G0tensor(1029),G0tensor(1030))
  call Hotf_4pt_reduction_last(G1tensor(1031),RedSet_4(31),mass4set(:,111),  & 
G0tensor(1031),G0tensor(1032),G0tensor(1033),G0tensor(1034),G0tensor(1035))
  call Hotf_4pt_reduction_last(G1tensor(1036),RedSet_4(31),mass4set(:,113),  & 
G0tensor(1036),G0tensor(1037),G0tensor(1038),G0tensor(1039),G0tensor(1040))
  call Hotf_4pt_reduction_last(G1tensor(1041),RedSet_4(15),mass4set(:,56),  & 
G0tensor(1041),G0tensor(1042),G0tensor(1043),G0tensor(1044),G0tensor(1045))
  call Hotf_4pt_reduction_last(G1tensor(1046),RedSet_4(15),mass4set(:,57),  & 
G0tensor(1046),G0tensor(1047),G0tensor(1048),G0tensor(1049),G0tensor(1050))
  call Hotf_4pt_reduction_last(G1tensor(1051),RedSet_4(15),mass4set(:,58),  & 
G0tensor(1051),G0tensor(1052),G0tensor(1053),G0tensor(1054),G0tensor(1055))
  call Hotf_4pt_reduction_last(G1tensor(1056),RedSet_4(15),mass4set(:,59),  & 
G0tensor(1056),G0tensor(1057),G0tensor(1058),G0tensor(1059),G0tensor(1060))
  call Hotf_4pt_reduction_last(G1tensor(1061),RedSet_4(15),mass4set(:,61),  & 
G0tensor(1061),G0tensor(1062),G0tensor(1063),G0tensor(1064),G0tensor(1065))
  call Hotf_4pt_reduction_last(G1tensor(1066),RedSet_4(15),mass4set(:,62),  & 
G0tensor(1066),G0tensor(1067),G0tensor(1068),G0tensor(1069),G0tensor(1070))
  call Hotf_4pt_reduction_last(G1tensor(1071),RedSet_4(15),mass4set(:,63),  & 
G0tensor(1071),G0tensor(1072),G0tensor(1073),G0tensor(1074),G0tensor(1075))
  call Hotf_4pt_reduction_last(G1tensor(1076),RedSet_4(15),mass4set(:,64),  & 
G0tensor(1076),G0tensor(1077),G0tensor(1078),G0tensor(1079),G0tensor(1080))
  call Hotf_4pt_reduction_last(G1tensor(1081),RedSet_4(15),mass4set(:,65),  & 
G0tensor(1081),G0tensor(1082),G0tensor(1083),G0tensor(1084),G0tensor(1085))
  call Hotf_4pt_reduction_last(G1tensor(1086),RedSet_4(42),mass4set(:,56),  & 
G0tensor(1086),G0tensor(1087),G0tensor(1088),G0tensor(1089),G0tensor(1090))
  call Hotf_4pt_reduction_last(G1tensor(1091),RedSet_4(42),mass4set(:,57),  & 
G0tensor(1091),G0tensor(1092),G0tensor(1093),G0tensor(1094),G0tensor(1095))
  call Hotf_4pt_reduction_last(G1tensor(1096),RedSet_4(42),mass4set(:,58),  & 
G0tensor(1096),G0tensor(1097),G0tensor(1098),G0tensor(1099),G0tensor(1100))
  call Hotf_4pt_reduction_last(G1tensor(1101),RedSet_4(42),mass4set(:,59),  & 
G0tensor(1101),G0tensor(1102),G0tensor(1103),G0tensor(1104),G0tensor(1105))
  call Hotf_4pt_reduction_last(G1tensor(1106),RedSet_4(42),mass4set(:,60),  & 
G0tensor(1106),G0tensor(1107),G0tensor(1108),G0tensor(1109),G0tensor(1110))
  call Hotf_4pt_reduction_last(G1tensor(1111),RedSet_4(42),mass4set(:,61),  & 
G0tensor(1111),G0tensor(1112),G0tensor(1113),G0tensor(1114),G0tensor(1115))
  call Hotf_4pt_reduction_last(G1tensor(1116),RedSet_4(42),mass4set(:,62),  & 
G0tensor(1116),G0tensor(1117),G0tensor(1118),G0tensor(1119),G0tensor(1120))
  call Hotf_4pt_reduction_last(G1tensor(1121),RedSet_4(42),mass4set(:,63),  & 
G0tensor(1121),G0tensor(1122),G0tensor(1123),G0tensor(1124),G0tensor(1125))
  call Hotf_4pt_reduction_last(G1tensor(1126),RedSet_4(42),mass4set(:,64),  & 
G0tensor(1126),G0tensor(1127),G0tensor(1128),G0tensor(1129),G0tensor(1130))
  call Hotf_4pt_reduction_last(G1tensor(1131),RedSet_4(42),mass4set(:,65),  & 
G0tensor(1131),G0tensor(1132),G0tensor(1133),G0tensor(1134),G0tensor(1135))
  call Hotf_4pt_reduction_last(G1tensor(1136),RedSet_4(43),mass4set(:,115),  & 
G0tensor(1136),G0tensor(1137),G0tensor(1138),G0tensor(1139),G0tensor(1140))
  call Hotf_4pt_reduction_last(G1tensor(1141),RedSet_4(43),mass4set(:,116),  & 
G0tensor(1141),G0tensor(1142),G0tensor(1143),G0tensor(1144),G0tensor(1145))
  call Hotf_4pt_reduction_last(G1tensor(1146),RedSet_4(43),mass4set(:,117),  & 
G0tensor(1146),G0tensor(1147),G0tensor(1148),G0tensor(1149),G0tensor(1150))
  call Hotf_4pt_reduction_last(G1tensor(1151),RedSet_4(43),mass4set(:,118),  & 
G0tensor(1151),G0tensor(1152),G0tensor(1153),G0tensor(1154),G0tensor(1155))
  call Hotf_4pt_reduction_last(G1tensor(1156),RedSet_4(43),mass4set(:,119),  & 
G0tensor(1156),G0tensor(1157),G0tensor(1158),G0tensor(1159),G0tensor(1160))
  call Hotf_4pt_reduction_last(G1tensor(1161),RedSet_4(43),mass4set(:,120),  & 
G0tensor(1161),G0tensor(1162),G0tensor(1163),G0tensor(1164),G0tensor(1165))
  call Hotf_4pt_reduction_last(G1tensor(1166),RedSet_4(44),mass4set(:,121),  & 
G0tensor(1166),G0tensor(1167),G0tensor(1168),G0tensor(1169),G0tensor(1170))
  call Hotf_4pt_reduction_last(G1tensor(1171),RedSet_4(44),mass4set(:,122),  & 
G0tensor(1171),G0tensor(1172),G0tensor(1173),G0tensor(1174),G0tensor(1175))
  call Hotf_4pt_reduction_last(G1tensor(1176),RedSet_4(44),mass4set(:,123),  & 
G0tensor(1176),G0tensor(1177),G0tensor(1178),G0tensor(1179),G0tensor(1180))
  call Hotf_4pt_reduction_last(G1tensor(1181),RedSet_4(44),mass4set(:,124),  & 
G0tensor(1181),G0tensor(1182),G0tensor(1183),G0tensor(1184),G0tensor(1185))
  call Hotf_4pt_reduction_last(G1tensor(1186),RedSet_4(44),mass4set(:,125),  & 
G0tensor(1186),G0tensor(1187),G0tensor(1188),G0tensor(1189),G0tensor(1190))
  call Hotf_4pt_reduction_last(G1tensor(1191),RedSet_4(44),mass4set(:,126),  & 
G0tensor(1191),G0tensor(1192),G0tensor(1193),G0tensor(1194),G0tensor(1195))
  call Hotf_4pt_reduction_last(G1tensor(1196),RedSet_4(45),mass4set(:,66),  & 
G0tensor(1196),G0tensor(1197),G0tensor(1198),G0tensor(1199),G0tensor(1200))
  call Hotf_4pt_reduction_last(G1tensor(1201),RedSet_4(45),mass4set(:,69),  & 
G0tensor(1201),G0tensor(1202),G0tensor(1203),G0tensor(1204),G0tensor(1205))
  call Hotf_4pt_reduction_last(G1tensor(1206),RedSet_4(45),mass4set(:,68),  & 
G0tensor(1206),G0tensor(1207),G0tensor(1208),G0tensor(1209),G0tensor(1210))
  call Hotf_4pt_reduction_last(G1tensor(1211),RedSet_4(45),mass4set(:,70),  & 
G0tensor(1211),G0tensor(1212),G0tensor(1213),G0tensor(1214),G0tensor(1215))
  call Hotf_4pt_reduction_last(G1tensor(1216),RedSet_4(45),mass4set(:,71),  & 
G0tensor(1216),G0tensor(1217),G0tensor(1218),G0tensor(1219),G0tensor(1220))
  call Hotf_4pt_reduction_last(G1tensor(1221),RedSet_4(45),mass4set(:,77),  & 
G0tensor(1221),G0tensor(1222),G0tensor(1223),G0tensor(1224),G0tensor(1225))
  call Hotf_4pt_reduction_last(G1tensor(1226),RedSet_4(45),mass4set(:,79),  & 
G0tensor(1226),G0tensor(1227),G0tensor(1228),G0tensor(1229),G0tensor(1230))
  call Hotf_4pt_reduction_last(G1tensor(1231),RedSet_4(45),mass4set(:,73),  & 
G0tensor(1231),G0tensor(1232),G0tensor(1233),G0tensor(1234),G0tensor(1235))
  call Hotf_4pt_reduction_last(G1tensor(1236),RedSet_4(45),mass4set(:,75),  & 
G0tensor(1236),G0tensor(1237),G0tensor(1238),G0tensor(1239),G0tensor(1240))
  call Hotf_4pt_reduction_last(G1tensor(1241),RedSet_4(45),mass4set(:,81),  & 
G0tensor(1241),G0tensor(1242),G0tensor(1243),G0tensor(1244),G0tensor(1245))
  call Hotf_4pt_reduction_last(G1tensor(1246),RedSet_4(38),mass4set(:,66),  & 
G0tensor(1246),G0tensor(1247),G0tensor(1248),G0tensor(1249),G0tensor(1250))
  call Hotf_4pt_reduction_last(G1tensor(1251),RedSet_4(38),mass4set(:,68),  & 
G0tensor(1251),G0tensor(1252),G0tensor(1253),G0tensor(1254),G0tensor(1255))
  call Hotf_4pt_reduction_last(G1tensor(1256),RedSet_4(38),mass4set(:,69),  & 
G0tensor(1256),G0tensor(1257),G0tensor(1258),G0tensor(1259),G0tensor(1260))
  call Hotf_4pt_reduction_last(G1tensor(1261),RedSet_4(38),mass4set(:,70),  & 
G0tensor(1261),G0tensor(1262),G0tensor(1263),G0tensor(1264),G0tensor(1265))
  call Hotf_4pt_reduction_last(G1tensor(1266),RedSet_4(38),mass4set(:,73),  & 
G0tensor(1266),G0tensor(1267),G0tensor(1268),G0tensor(1269),G0tensor(1270))
  call Hotf_4pt_reduction_last(G1tensor(1271),RedSet_4(38),mass4set(:,75),  & 
G0tensor(1271),G0tensor(1272),G0tensor(1273),G0tensor(1274),G0tensor(1275))
  call Hotf_4pt_reduction_last(G1tensor(1276),RedSet_4(38),mass4set(:,77),  & 
G0tensor(1276),G0tensor(1277),G0tensor(1278),G0tensor(1279),G0tensor(1280))
  call Hotf_4pt_reduction_last(G1tensor(1281),RedSet_4(38),mass4set(:,79),  & 
G0tensor(1281),G0tensor(1282),G0tensor(1283),G0tensor(1284),G0tensor(1285))
  call Hotf_4pt_reduction_last(G1tensor(1286),RedSet_4(38),mass4set(:,81),  & 
G0tensor(1286),G0tensor(1287),G0tensor(1288),G0tensor(1289),G0tensor(1290))
  call Hotf_4pt_reduction_last(G1tensor(1291),RedSet_4(35),mass4set(:,22),  & 
G0tensor(1291),G0tensor(1292),G0tensor(1293),G0tensor(1294),G0tensor(1295))
  call Hotf_4pt_reduction_last(G1tensor(1296),RedSet_4(35),mass4set(:,23),  & 
G0tensor(1296),G0tensor(1297),G0tensor(1298),G0tensor(1299),G0tensor(1300))
  call Hotf_4pt_reduction_last(G1tensor(1301),RedSet_4(35),mass4set(:,24),  & 
G0tensor(1301),G0tensor(1302),G0tensor(1303),G0tensor(1304),G0tensor(1305))
  call ol_merge_tensors(T0sum(1),[G0tensor(1)])
  call ol_merge_tensors(T0sum(2),[G0tensor(6)])
  call ol_merge_tensors(T0sum(3),[G0tensor(11)])
  call ol_merge_tensors(T0sum(4),[G0tensor(16)])
  call ol_merge_tensors(T0sum(5),[G0tensor(21)])
  call ol_merge_tensors(T0sum(6),[G0tensor(26)])
  call ol_merge_tensors(T0sum(7),[G0tensor(31)])
  call ol_merge_tensors(T0sum(8),[G0tensor(36)])
  call ol_merge_tensors(T0sum(9),[G0tensor(41)])
  call ol_merge_tensors(T0sum(10),[G0tensor(46)])
  call ol_merge_tensors(T0sum(11),[G0tensor(51)])
  call ol_merge_tensors(T0sum(12),[G0tensor(56)])
  call ol_merge_tensors(T0sum(13),[G0tensor(61)])
  call ol_merge_tensors(T0sum(14),[G0tensor(66)])
  call ol_merge_tensors(T0sum(15),[G0tensor(71)])
  call ol_merge_tensors(T0sum(16),[G0tensor(76)])
  call ol_merge_tensors(T0sum(17),[G0tensor(81)])
  call ol_merge_tensors(T0sum(18),[G0tensor(86)])
  call ol_merge_tensors(T0sum(19),[G0tensor(91)])
  call ol_merge_tensors(T0sum(20),[G0tensor(96)])
  call ol_merge_tensors(T0sum(21),[G0tensor(101)])
  call ol_merge_tensors(T0sum(22),[G0tensor(106)])
  call ol_merge_tensors(T0sum(23),[G0tensor(111)])
  call ol_merge_tensors(T0sum(24),[G0tensor(116)])
  call ol_merge_tensors(T0sum(25),[G0tensor(121)])
  call ol_merge_tensors(T0sum(26),[G0tensor(126)])
  call ol_merge_tensors(T0sum(27),[G0tensor(131)])
  call ol_merge_tensors(T0sum(28),[G0tensor(136)])
  call ol_merge_tensors(T0sum(29),[G0tensor(141)])
  call ol_merge_tensors(T0sum(30),[G0tensor(146)])
  call ol_merge_tensors(T0sum(31),[G0tensor(151)])
  call ol_merge_tensors(T0sum(32),[G0tensor(156)])
  call ol_merge_tensors(T0sum(33),[G0tensor(161)])
  call ol_merge_tensors(T0sum(34),[G0tensor(166)])
  call ol_merge_tensors(T0sum(35),[G0tensor(171)])
  call ol_merge_tensors(T0sum(36),[G0tensor(176)])
  call ol_merge_tensors(T0sum(37),[G0tensor(181)])
  call ol_merge_tensors(T0sum(38),[G0tensor(186)])
  call ol_merge_tensors(T0sum(39),[G0tensor(191)])
  call ol_merge_tensors(T0sum(40),[G0tensor(196)])
  call ol_merge_tensors(T0sum(41),[G0tensor(201)])
  call ol_merge_tensors(T0sum(42),[G0tensor(206)])
  call ol_merge_tensors(T0sum(43),[G0tensor(211)])
  call ol_merge_tensors(T0sum(44),[G0tensor(216)])
  call ol_merge_tensors(T0sum(45),[G0tensor(221)])
  call ol_merge_tensors(T0sum(46),[G0tensor(226)])
  call ol_merge_tensors(T0sum(47),[G0tensor(231)])
  call ol_merge_tensors(T0sum(48),[G0tensor(236)])
  call ol_merge_tensors(T0sum(49),[G0tensor(241)])
  call ol_merge_tensors(T0sum(50),[G0tensor(246)])
  call ol_merge_tensors(T0sum(51),[G0tensor(251)])
  call ol_merge_tensors(T0sum(52),[G0tensor(256)])
  call ol_merge_tensors(T0sum(53),[G0tensor(261)])
  call ol_merge_tensors(T0sum(54),[G0tensor(266)])
  call ol_merge_tensors(T0sum(55),[G0tensor(271)])
  call ol_merge_tensors(T0sum(56),[G0tensor(276)])
  call ol_merge_tensors(T0sum(57),[G0tensor(281)])
  call ol_merge_tensors(T0sum(58),[G0tensor(286)])
  call ol_merge_tensors(T0sum(59),[G0tensor(291)])
  call ol_merge_tensors(T0sum(60),[G0tensor(296)])
  call ol_merge_tensors(T0sum(61),[G0tensor(301)])
  call ol_merge_tensors(T0sum(62),[G0tensor(306)])
  call ol_merge_tensors(T0sum(63),[G0tensor(311)])
  call ol_merge_tensors(T0sum(64),[G0tensor(316)])
  call ol_merge_tensors(T0sum(65),[G0tensor(321)])
  call ol_merge_tensors(T0sum(66),[G0tensor(326)])
  call ol_merge_tensors(T0sum(67),[G0tensor(331)])
  call ol_merge_tensors(T0sum(68),[G0tensor(336)])
  call ol_merge_tensors(T0sum(69),[G0tensor(341)])
  call ol_merge_tensors(T0sum(70),[G0tensor(346)])
  call ol_merge_tensors(T0sum(71),[G0tensor(351)])
  call ol_merge_tensors(T0sum(72),[G0tensor(356)])
  call ol_merge_tensors(T0sum(73),[G0tensor(361)])
  call ol_merge_tensors(T0sum(74),[G0tensor(366)])
  call ol_merge_tensors(T0sum(75),[G0tensor(371)])
  call ol_merge_tensors(T0sum(76),[G0tensor(376)])
  call ol_merge_tensors(T0sum(77),[G0tensor(381)])
  call ol_merge_tensors(T0sum(78),[G0tensor(386)])
  call ol_merge_tensors(T0sum(79),[G0tensor(391)])
  call ol_merge_tensors(T0sum(80),[G0tensor(396)])
  call ol_merge_tensors(T0sum(81),[G0tensor(401)])
  call ol_merge_tensors(T0sum(82),[G0tensor(406)])
  call ol_merge_tensors(T0sum(83),[G0tensor(411)])
  call ol_merge_tensors(T0sum(84),[G0tensor(416)])
  call ol_merge_tensors(T0sum(85),[G0tensor(421)])
  call ol_merge_tensors(T0sum(86),[G0tensor(426)])
  call ol_merge_tensors(T0sum(87),[G0tensor(431)])
  call ol_merge_tensors(T0sum(88),[G0tensor(436)])
  call ol_merge_tensors(T0sum(89),[G0tensor(441)])
  call ol_merge_tensors(T0sum(90),[G0tensor(446)])
  call ol_merge_tensors(T0sum(91),[G0tensor(451)])
  call ol_merge_tensors(T0sum(92),[G0tensor(456)])
  call ol_merge_tensors(T0sum(93),[G0tensor(461)])
  call ol_merge_tensors(T0sum(94),[G0tensor(466)])
  call ol_merge_tensors(T0sum(95),[G0tensor(471)])
  call ol_merge_tensors(T0sum(96),[G0tensor(476)])
  call ol_merge_tensors(T0sum(97),[G0tensor(481)])
  call ol_merge_tensors(T0sum(98),[G0tensor(486)])
  call ol_merge_tensors(T0sum(99),[G0tensor(491)])
  call ol_merge_tensors(T0sum(100),[G0tensor(496)])
  call ol_merge_tensors(T0sum(101),[G0tensor(501)])
  call ol_merge_tensors(T0sum(102),[G0tensor(506)])
  call ol_merge_tensors(T0sum(103),[G0tensor(511)])
  call ol_merge_tensors(T0sum(104),[G0tensor(516)])
  call ol_merge_tensors(T0sum(105),[G0tensor(521)])
  call ol_merge_tensors(T0sum(106),[G0tensor(526)])
  call ol_merge_tensors(T0sum(107),[G0tensor(531)])
  call ol_merge_tensors(T0sum(108),[G0tensor(536)])
  call ol_merge_tensors(T0sum(109),[G0tensor(541)])
  call ol_merge_tensors(T0sum(110),[G0tensor(546)])
  call ol_merge_tensors(T0sum(111),[G0tensor(551)])
  call ol_merge_tensors(T0sum(112),[G0tensor(556)])
  call ol_merge_tensors(T0sum(113),[G0tensor(561)])
  call ol_merge_tensors(T0sum(114),[G0tensor(566)])
  call ol_merge_tensors(T0sum(115),[G0tensor(571)])
  call ol_merge_tensors(T0sum(116),[G0tensor(576)])
  call ol_merge_tensors(T0sum(117),[G0tensor(581)])
  call ol_merge_tensors(T0sum(118),[G0tensor(586)])
  call ol_merge_tensors(T0sum(119),[G0tensor(591)])
  call ol_merge_tensors(T0sum(120),[G0tensor(596)])
  call ol_merge_tensors(T0sum(121),[G0tensor(601)])
  call ol_merge_tensors(T0sum(122),[G0tensor(606)])
  call ol_merge_tensors(T0sum(123),[G0tensor(611)])
  call ol_merge_tensors(T0sum(124),[G0tensor(616)])
  call ol_merge_tensors(T0sum(125),[G0tensor(621)])
  call ol_merge_tensors(T0sum(126),[G0tensor(626)])
  call ol_merge_tensors(T0sum(127),[G0tensor(631)])
  call ol_merge_tensors(T0sum(128),[G0tensor(636)])
  call ol_merge_tensors(T0sum(129),[G0tensor(641)])
  call ol_merge_tensors(T0sum(130),[G0tensor(646)])
  call ol_merge_tensors(T0sum(131),[G0tensor(651)])
  call ol_merge_tensors(T0sum(132),[G0tensor(656)])
  call ol_merge_tensors(T0sum(133),[G0tensor(661)])
  call ol_merge_tensors(T0sum(134),[G0tensor(666)])
  call ol_merge_tensors(T0sum(135),[G0tensor(671)])
  call ol_merge_tensors(T0sum(136),[G0tensor(676)])
  call ol_merge_tensors(T0sum(137),[G0tensor(681)])
  call ol_merge_tensors(T0sum(138),[G0tensor(686)])
  call ol_merge_tensors(T0sum(139),[G0tensor(691)])
  call ol_merge_tensors(T0sum(140),[G0tensor(696)])
  call ol_merge_tensors(T0sum(141),[G0tensor(701)])
  call ol_merge_tensors(T0sum(142),[G0tensor(706)])
  call ol_merge_tensors(T0sum(143),[G0tensor(711)])
  call ol_merge_tensors(T0sum(144),[G0tensor(716)])
  call ol_merge_tensors(T0sum(145),[G0tensor(721)])
  call ol_merge_tensors(T0sum(146),[G0tensor(726)])
  call ol_merge_tensors(T0sum(147),[G0tensor(731)])
  call ol_merge_tensors(T0sum(148),[G0tensor(736)])
  call ol_merge_tensors(T0sum(149),[G0tensor(741)])
  call ol_merge_tensors(T0sum(150),[G0tensor(746)])
  call ol_merge_tensors(T0sum(151),[G0tensor(751)])
  call ol_merge_tensors(T0sum(152),[G0tensor(756)])
  call ol_merge_tensors(T0sum(153),[G0tensor(761)])
  call ol_merge_tensors(T0sum(154),[G0tensor(766)])
  call ol_merge_tensors(T0sum(155),[G0tensor(771)])
  call ol_merge_tensors(T0sum(156),[G0tensor(776)])
  call ol_merge_tensors(T0sum(157),[G0tensor(781)])
  call ol_merge_tensors(T0sum(158),[G0tensor(786)])
  call ol_merge_tensors(T0sum(159),[G0tensor(791)])
  call ol_merge_tensors(T0sum(160),[G0tensor(796)])
  call ol_merge_tensors(T0sum(161),[G0tensor(801)])
  call ol_merge_tensors(T0sum(162),[G0tensor(806)])
  call ol_merge_tensors(T0sum(163),[G0tensor(811)])
  call ol_merge_tensors(T0sum(164),[G0tensor(816)])
  call ol_merge_tensors(T0sum(165),[G0tensor(821)])
  call ol_merge_tensors(T0sum(166),[G0tensor(826)])
  call ol_merge_tensors(T0sum(167),[G0tensor(831)])
  call ol_merge_tensors(T0sum(168),[G0tensor(836)])
  call ol_merge_tensors(T0sum(169),[G0tensor(841)])
  call ol_merge_tensors(T0sum(170),[G0tensor(846)])
  call ol_merge_tensors(T0sum(171),[G0tensor(851)])
  call ol_merge_tensors(T0sum(172),[G0tensor(856)])
  call ol_merge_tensors(T0sum(173),[G0tensor(861)])
  call ol_merge_tensors(T0sum(174),[G0tensor(866)])
  call ol_merge_tensors(T0sum(175),[G0tensor(871)])
  call ol_merge_tensors(T0sum(176),[G0tensor(876)])
  call ol_merge_tensors(T0sum(177),[G0tensor(881)])
  call ol_merge_tensors(T0sum(178),[G0tensor(886)])
  call ol_merge_tensors(T0sum(179),[G0tensor(891)])
  call ol_merge_tensors(T0sum(180),[G0tensor(896)])
  call ol_merge_tensors(T0sum(181),[G0tensor(901)])
  call ol_merge_tensors(T0sum(182),[G0tensor(906)])
  call ol_merge_tensors(T0sum(183),[G0tensor(911)])
  call ol_merge_tensors(T0sum(184),[G0tensor(916)])
  call ol_merge_tensors(T0sum(185),[G0tensor(921)])
  call ol_merge_tensors(T0sum(186),[G0tensor(926)])
  call ol_merge_tensors(T0sum(187),[G0tensor(931)])
  call ol_merge_tensors(T0sum(188),[G0tensor(936)])
  call ol_merge_tensors(T0sum(189),[G0tensor(941)])
  call ol_merge_tensors(T0sum(190),[G0tensor(946)])
  call ol_merge_tensors(T0sum(191),[G0tensor(951)])
  call ol_merge_tensors(T0sum(192),[G0tensor(956)])
  call ol_merge_tensors(T0sum(193),[G0tensor(961)])
  call ol_merge_tensors(T0sum(194),[G0tensor(966)])
  call ol_merge_tensors(T0sum(195),[G0tensor(971)])
  call ol_merge_tensors(T0sum(196),[G0tensor(976)])
  call ol_merge_tensors(T0sum(197),[G0tensor(981)])
  call ol_merge_tensors(T0sum(198),[G0tensor(986)])
  call ol_merge_tensors(T0sum(199),[G0tensor(991)])
  call ol_merge_tensors(T0sum(200),[G0tensor(996)])
  call ol_merge_tensors(T0sum(201),[G0tensor(1001)])
  call ol_merge_tensors(T0sum(202),[G0tensor(1006)])
  call ol_merge_tensors(T0sum(203),[G0tensor(1011)])
  call ol_merge_tensors(T0sum(204),[G0tensor(1016)])
  call ol_merge_tensors(T0sum(205),[G0tensor(1021)])
  call ol_merge_tensors(T0sum(206),[G0tensor(1026)])
  call ol_merge_tensors(T0sum(207),[G0tensor(1031)])
  call ol_merge_tensors(T0sum(208),[G0tensor(1036)])
  call ol_merge_tensors(T0sum(209),[G0tensor(1041)])
  call ol_merge_tensors(T0sum(210),[G0tensor(1046)])
  call ol_merge_tensors(T0sum(211),[G0tensor(1051)])
  call ol_merge_tensors(T0sum(212),[G0tensor(1056)])
  call ol_merge_tensors(T0sum(213),[G0tensor(1061)])
  call ol_merge_tensors(T0sum(214),[G0tensor(1066)])
  call ol_merge_tensors(T0sum(215),[G0tensor(1071)])
  call ol_merge_tensors(T0sum(216),[G0tensor(1076)])
  call ol_merge_tensors(T0sum(217),[G0tensor(1081)])
  call ol_merge_tensors(T0sum(218),[G0tensor(1086)])
  call ol_merge_tensors(T0sum(219),[G0tensor(1091)])
  call ol_merge_tensors(T0sum(220),[G0tensor(1096)])
  call ol_merge_tensors(T0sum(221),[G0tensor(1101)])
  call ol_merge_tensors(T0sum(222),[G0tensor(1106)])
  call ol_merge_tensors(T0sum(223),[G0tensor(1111)])
  call ol_merge_tensors(T0sum(224),[G0tensor(1116)])
  call ol_merge_tensors(T0sum(225),[G0tensor(1121)])
  call ol_merge_tensors(T0sum(226),[G0tensor(1126)])
  call ol_merge_tensors(T0sum(227),[G0tensor(1131)])
  call ol_merge_tensors(T0sum(228),[G0tensor(1136)])
  call ol_merge_tensors(T0sum(229),[G0tensor(1141)])
  call ol_merge_tensors(T0sum(230),[G0tensor(1146)])
  call ol_merge_tensors(T0sum(231),[G0tensor(1151)])
  call ol_merge_tensors(T0sum(232),[G0tensor(1156)])
  call ol_merge_tensors(T0sum(233),[G0tensor(1161)])
  call ol_merge_tensors(T0sum(234),[G0tensor(1166)])
  call ol_merge_tensors(T0sum(235),[G0tensor(1171)])
  call ol_merge_tensors(T0sum(236),[G0tensor(1176)])
  call ol_merge_tensors(T0sum(237),[G0tensor(1181)])
  call ol_merge_tensors(T0sum(238),[G0tensor(1186)])
  call ol_merge_tensors(T0sum(239),[G0tensor(1191)])
  call ol_merge_tensors(T0sum(240),[G0tensor(1196)])
  call ol_merge_tensors(T0sum(241),[G0tensor(1201)])
  call ol_merge_tensors(T0sum(242),[G0tensor(1206)])
  call ol_merge_tensors(T0sum(243),[G0tensor(1211)])
  call ol_merge_tensors(T0sum(244),[G0tensor(1216)])
  call ol_merge_tensors(T0sum(245),[G0tensor(1221)])
  call ol_merge_tensors(T0sum(246),[G0tensor(1226)])
  call ol_merge_tensors(T0sum(247),[G0tensor(1231)])
  call ol_merge_tensors(T0sum(248),[G0tensor(1236)])
  call ol_merge_tensors(T0sum(249),[G0tensor(1241)])
  call ol_merge_tensors(T0sum(250),[G0tensor(1246)])
  call ol_merge_tensors(T0sum(251),[G0tensor(1251)])
  call ol_merge_tensors(T0sum(252),[G0tensor(1256)])
  call ol_merge_tensors(T0sum(253),[G0tensor(1261)])
  call ol_merge_tensors(T0sum(254),[G0tensor(1266)])
  call ol_merge_tensors(T0sum(255),[G0tensor(1271)])
  call ol_merge_tensors(T0sum(256),[G0tensor(1276)])
  call ol_merge_tensors(T0sum(257),[G0tensor(1281)])
  call ol_merge_tensors(T0sum(258),[G0tensor(1286)])
  call ol_merge_tensors(T0sum(259),[G0tensor(1291)])
  call ol_merge_tensors(T0sum(260),[G0tensor(1296)])
  call ol_merge_tensors(T0sum(261),[G0tensor(1301)])
  Gcoeff(:)%j = (c(25)*M(4,:)%j) * den(3)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(647),h0tab(:,647),[20,3,8],[nMB,nMB,nMH],3,2,wf4(:,3),wf4(:,1))
  call Hloop_SQ_A(ntryL,G0H32(1),wf4(:,3),G0H8(137),ngH,m3h4x8(:,273),heltab2x32(:,:,647))
  call Hloop_Q_A(ntryL,G0H8(137),20,nMB,G1H8(1),n2h8(137))
  Gcoeff(:)%j = (-(c(25)*M(4,:)%j)) * den(3)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(648),h0tab(:,648),[20,3,8],[nMB,nMB,nMZ],3,2,wf4(:,3),wf4(:,1))
  call Hloop_SQ_A(ntryL,G0H32(1),wf4(:,3),G0H8(1),ngX,m3h4x8(:,274),heltab2x32(:,:,648))
  call Hloop_Q_A(ntryL,G0H8(1),20,nMB,G1H8(2),n2h8(138))
  Gcoeff(:)%j = (-(c(32)*M(4,:)%j)) * den(3)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(649),h0tab(:,649),[20,3,8],[nMT,nMT,nMW],3,2,wf4(:,3),wf4(:,1))
  call Hloop_SQ_A(ntryL,G0H32(1),wf4(:,3),G0H8(2),ngPtb,m3h4x8(:,275),heltab2x32(:,:,649))
  call Hloop_Q_A(ntryL,G0H8(2),20,nMT,G1H8(3),n2h8(139))
  Gcoeff(:)%j = (c(25)*M(4,:)%j) * den(5)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(650),h0tab(:,650),[20,3,8],[nMB,nMB,nMH],3,2,wf4(:,3),wf4(:,4))
  call Hloop_SQ_A(ntryL,G0H32(1),wf4(:,3),G0H8(3),ngH,m3h4x8(:,276),heltab2x32(:,:,650))
  call Hloop_Q_A(ntryL,G0H8(3),20,nMB,G1H8(4),n2h8(140))
  Gcoeff(:)%j = (-(c(25)*M(4,:)%j)) * den(5)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(651),h0tab(:,651),[20,3,8],[nMB,nMB,nMZ],3,2,wf4(:,3),wf4(:,4))
  call Hloop_SQ_A(ntryL,G0H32(1),wf4(:,3),G0H8(4),ngX,m3h4x8(:,277),heltab2x32(:,:,651))
  call Hloop_Q_A(ntryL,G0H8(4),20,nMB,G1H8(5),n2h8(141))
  Gcoeff(:)%j = (c(32)*M(4,:)%j) * den(5)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(652),h0tab(:,652),[20,3,8],[nMT,nMT,nMW],3,2,wf4(:,3),wf4(:,4))
  call Hloop_SQ_A(ntryL,G0H32(1),wf4(:,3),G0H8(5),ngPtb,m3h4x8(:,278),heltab2x32(:,:,652))
  call Hloop_Q_A(ntryL,G0H8(5),20,nMT,G1H8(6),n2h8(142))
  Gcoeff(:)%j = (c(28)*M(4,:)%j) * den(3)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(653),h0tab(:,653),[20,3,8],[nMH,nMH,nMB],3,2,wf4(:,3),wf4(:,1))
  call Hloop_AQ_S(ntryL,G0H32(1),wf4(:,3),G0H8(6),ngH,m3h4x8(:,279),heltab2x32(:,:,653))
  Gcoeff(:)%j = (-(c(27)*M(4,:)%j)) * den(3)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(654),h0tab(:,654),[20,3,8],[nMZ,nMZ,nMB],3,2,wf4(:,3),wf4(:,1))
  call Hloop_AQ_S(ntryL,G0H32(1),wf4(:,3),G0H8(7),ngX,m3h4x8(:,280),heltab2x32(:,:,654))
  Gcoeff(:)%j = (-(c(26)*M(4,:)%j)) * den(3)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(655),h0tab(:,655),[20,3,8],[nMW,nMW,nMT],3,2,wf4(:,3),wf4(:,1))
  call Hloop_AQ_S(ntryL,G0H32(1),wf4(:,3),G0H8(8),ngPtb,m3h4x8(:,281),heltab2x32(:,:,655))
  Gcoeff(:)%j = (c(27)*M(4,:)%j) * den(5)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(656),h0tab(:,656),[20,3,8],[nMZ,nMH,nMB],3,2,wf4(:,3),wf4(:,4))
  call Hloop_AQ_S(ntryL,G0H32(1),wf4(:,3),G0H8(9),ngX,m3h4x8(:,282),heltab2x32(:,:,656))
  Gcoeff(:)%j = (c(27)*M(4,:)%j) * den(5)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(657),h0tab(:,657),[20,3,8],[nMH,nMZ,nMB],3,2,wf4(:,3),wf4(:,4))
  call Hloop_AQ_S(ntryL,G0H32(1),wf4(:,3),G0H8(10),ngH,m3h4x8(:,283),heltab2x32(:,:,657))
  Gcoeff(:)%j = (-(c(83)*M(4,:)%j)) * den(3)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(658),h0tab(:,658),[20,3,8],[nMB,nMB,0],3,2,wf4(:,3),wf4(:,1))
  call Hloop_VQ_A(ntryL,G0H32(1),wf4(:,3),G0H8(11),m3h4x8(:,284),heltab2x32(:,:,658))
  call Hloop_Q_A(ntryL,G0H8(11),20,nMB,G1H8(7),n2h8(143))
  Gcoeff(:)%j = (-(c(86)*M(4,:)%j)) * den(3)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(659),h0tab(:,659),[20,3,8],[nMB,nMB,nMZ],3,2,wf4(:,3),wf4(:,1))
  call Hloop_ZQ_A(ntryL,G0H32(1),wf4(:,3),G0H8(12),ngZd,m3h4x8(:,285),heltab2x32(:,:,659))
  call Hloop_Q_A(ntryL,G0H8(12),20,nMB,G1H8(8),n2h8(144))
  Gcoeff(:)%j = (-(c(46)*M(4,:)%j)) * den(3)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(660),h0tab(:,660),[20,3,8],[nMT,nMT,nMW],3,2,wf4(:,3),wf4(:,1))
  call Hloop_WQ_A(ntryL,G0H32(1),wf4(:,3),G0H8(13),m3h4x8(:,286),heltab2x32(:,:,660))
  call Hloop_Q_A(ntryL,G0H8(13),20,nMT,G1H8(9),n2h8(145))
  Gcoeff(:)%j = (-(c(83)*M(4,:)%j)) * den(5)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(661),h0tab(:,661),[20,3,8],[nMB,nMB,0],3,2,wf4(:,3),wf4(:,4))
  call Hloop_VQ_A(ntryL,G0H32(1),wf4(:,3),G0H8(14),m3h4x8(:,287),heltab2x32(:,:,661))
  call Hloop_Q_A(ntryL,G0H8(14),20,nMB,G1H8(10),n2h8(146))
  Gcoeff(:)%j = (-(c(86)*M(4,:)%j)) * den(5)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(662),h0tab(:,662),[20,3,8],[nMB,nMB,nMZ],3,2,wf4(:,3),wf4(:,4))
  call Hloop_ZQ_A(ntryL,G0H32(1),wf4(:,3),G0H8(15),ngZd,m3h4x8(:,288),heltab2x32(:,:,662))
  call Hloop_Q_A(ntryL,G0H8(15),20,nMB,G1H8(11),n2h8(147))
  Gcoeff(:)%j = (c(46)*M(4,:)%j) * den(5)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(663),h0tab(:,663),[20,3,8],[nMT,nMT,nMW],3,2,wf4(:,3),wf4(:,4))
  call Hloop_WQ_A(ntryL,G0H32(1),wf4(:,3),G0H8(16),m3h4x8(:,289),heltab2x32(:,:,663))
  call Hloop_Q_A(ntryL,G0H8(16),20,nMT,G1H8(12),n2h8(148))
  Gcoeff(:)%j = (c(57)*M(4,:)%j) * den(3)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(664),h0tab(:,664),[20,3,8],[nMZ,nMZ,nMB],3,2,wf4(:,3),wf4(:,1))
  call Hloop_AQ_Z(ntryL,G0H32(1),wf4(:,3),G0H8(17),ngZd,m3h4x8(:,290),heltab2x32(:,:,664))
  Gcoeff(:)%j = (-(c(42)*M(4,:)%j)) * den(3)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(665),h0tab(:,665),[20,3,8],[nMW,nMW,nMT],3,2,wf4(:,3),wf4(:,1))
  call Hloop_AQ_W(ntryL,G0H32(1),wf4(:,3),G0H8(18),m3h4x8(:,291),heltab2x32(:,:,665))
  Gcoeff(:)%j = (-(c(57)*M(4,:)%j)) * den(5)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(666),h0tab(:,666),[20,3,8],[nMZ,nMH,nMB],3,2,wf4(:,3),wf4(:,4))
  call Hloop_AQ_Z(ntryL,G0H32(1),wf4(:,3),G0H8(19),ngZd,m3h4x8(:,292),heltab2x32(:,:,666))
  Gcoeff(:)%j = (-(c(42)*M(4,:)%j)) * den(5)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(667),h0tab(:,667),[20,3,8],[nMW,nMW,nMT],3,2,wf4(:,3),wf4(:,4))
  call Hloop_AQ_W(ntryL,G0H32(1),wf4(:,3),G0H8(20),m3h4x8(:,293),heltab2x32(:,:,667))
  Gcoeff(:)%j = (c(57)*M(4,:)%j) * den(3)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(668),h0tab(:,668),[20,3,8],[nMZ,nMZ,nMB],3,2,wf4(:,3),wf4(:,1))
  call Hloop_AQ_S(ntryL,G0H32(1),wf4(:,3),G0H8(21),ngX,m3h4x8(:,294),heltab2x32(:,:,668))
  Gcoeff(:)%j = (-(c(42)*M(4,:)%j)) * den(3)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(669),h0tab(:,669),[20,3,8],[nMW,nMW,nMT],3,2,wf4(:,3),wf4(:,1))
  call Hloop_AQ_S(ntryL,G0H32(1),wf4(:,3),G0H8(22),ngPtb,m3h4x8(:,295),heltab2x32(:,:,669))
  Gcoeff(:)%j = (-(c(57)*M(4,:)%j)) * den(5)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(670),h0tab(:,670),[20,3,8],[nMH,nMZ,nMB],3,2,wf4(:,3),wf4(:,4))
  call Hloop_AQ_S(ntryL,G0H32(1),wf4(:,3),G0H8(23),ngH,m3h4x8(:,296),heltab2x32(:,:,670))
  Gcoeff(:)%j = (c(42)*M(4,:)%j) * den(5)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(671),h0tab(:,671),[20,3,8],[nMW,nMW,nMT],3,2,wf4(:,3),wf4(:,4))
  call Hloop_AQ_S(ntryL,G0H32(1),wf4(:,3),G0H8(24),ngPtb,m3h4x8(:,297),heltab2x32(:,:,671))
  Gcoeff(:)%j = (-(c(73)*M(4,:)%j)) * den(3)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(672),h0tab(:,672),[20,3,8],[nMZ,nMZ,nMB],3,2,wf4(:,3),wf4(:,1))
  call Hloop_AQ_Z(ntryL,G0H32(1),wf4(:,3),G0H8(25),ngZd,m3h4x8(:,298),heltab2x32(:,:,672))
  Gcoeff(:)%j = (-(c(15)*M(4,:)%j)) * den(3)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(673),h0tab(:,673),[20,3,8],[nMW,nMW,nMT],3,2,wf4(:,3),wf4(:,1))
  call Hloop_AQ_W(ntryL,G0H32(1),wf4(:,3),G0H8(26),m3h4x8(:,299),heltab2x32(:,:,673))
  Gcoeff(:)%j = (c(80)*M(4,:)%j) * den(7)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(674),h0tab(:,674),[20,3,8],[nMB,nMB,nMH],3,2,wf4(:,3),wf4(:,5))
  call Hloop_SQ_A(ntryL,G0H32(1),wf4(:,3),G0H8(27),ngH,m3h4x8(:,300),heltab2x32(:,:,674))
  call Hloop_Q_A(ntryL,G0H8(27),20,nMB,G1H8(13),n2h8(149))
  Gcoeff(:)%j = (-(c(80)*M(4,:)%j)) * den(7)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(675),h0tab(:,675),[20,3,8],[nMB,nMB,nMZ],3,2,wf4(:,3),wf4(:,5))
  call Hloop_SQ_A(ntryL,G0H32(1),wf4(:,3),G0H8(28),ngX,m3h4x8(:,301),heltab2x32(:,:,675))
  call Hloop_Q_A(ntryL,G0H8(28),20,nMB,G1H8(14),n2h8(150))
  Gcoeff(:)%j = (c(77)*M(4,:)%j) * den(7)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(676),h0tab(:,676),[20,3,8],[nMT,nMT,nMW],3,2,wf4(:,3),wf4(:,5))
  call Hloop_SQ_A(ntryL,G0H32(1),wf4(:,3),G0H8(29),ngPtb,m3h4x8(:,302),heltab2x32(:,:,676))
  call Hloop_Q_A(ntryL,G0H8(29),20,nMT,G1H8(15),n2h8(151))
  Gcoeff(:)%j = (-(c(81)*M(4,:)%j)) * den(5)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(677),h0tab(:,677),[20,3,8],[nMB,nMB,nMH],3,2,wf4(:,3),wf4(:,6))
  call Hloop_SQ_A(ntryL,G0H32(1),wf4(:,3),G0H8(30),ngH,m3h4x8(:,303),heltab2x32(:,:,677))
  call Hloop_Q_A(ntryL,G0H8(30),20,nMB,G1H8(16),n2h8(152))
  Gcoeff(:)%j = (c(81)*M(4,:)%j) * den(5)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(678),h0tab(:,678),[20,3,8],[nMB,nMB,nMZ],3,2,wf4(:,3),wf4(:,6))
  call Hloop_SQ_A(ntryL,G0H32(1),wf4(:,3),G0H8(31),ngX,m3h4x8(:,304),heltab2x32(:,:,678))
  call Hloop_Q_A(ntryL,G0H8(31),20,nMB,G1H8(17),n2h8(153))
  Gcoeff(:)%j = (c(79)*M(4,:)%j) * den(5)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(679),h0tab(:,679),[20,3,8],[nMT,nMT,nMW],3,2,wf4(:,3),wf4(:,6))
  call Hloop_SQ_A(ntryL,G0H32(1),wf4(:,3),G0H8(32),ngPtb,m3h4x8(:,305),heltab2x32(:,:,679))
  call Hloop_Q_A(ntryL,G0H8(32),20,nMT,G1H8(18),n2h8(154))
  Gcoeff(:)%j = (c(78)*M(4,:)%j) * den(7)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(680),h0tab(:,680),[20,3,8],[nMW,nMW,nMT],3,2,wf4(:,3),wf4(:,5))
  call Hloop_AQ_S(ntryL,G0H32(1),wf4(:,3),G0H8(33),ngPtb,m3h4x8(:,306),heltab2x32(:,:,680))
  Gcoeff(:)%j = (c(55)*M(4,:)%j) * den(5)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(681),h0tab(:,681),[20,3,8],[nMZ,nMH,nMB],3,2,wf4(:,3),wf4(:,6))
  call Hloop_AQ_S(ntryL,G0H32(1),wf4(:,3),G0H8(34),ngX,m3h4x8(:,307),heltab2x32(:,:,681))
  Gcoeff(:)%j = (c(55)*M(4,:)%j) * den(5)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(682),h0tab(:,682),[20,3,8],[nMH,nMZ,nMB],3,2,wf4(:,3),wf4(:,6))
  call Hloop_AQ_S(ntryL,G0H32(1),wf4(:,3),G0H8(35),ngH,m3h4x8(:,308),heltab2x32(:,:,682))
  Gcoeff(:)%j = (-(c(104)*M(4,:)%j)) * den(5)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(683),h0tab(:,683),[20,3,8],[nMW,nMW,nMT],3,2,wf4(:,3),wf4(:,6))
  call Hloop_AQ_S(ntryL,G0H32(1),wf4(:,3),G0H8(36),ngPtb,m3h4x8(:,309),heltab2x32(:,:,683))
  Gcoeff(:)%j = (-(c(1)*M(4,:)%j)) * den(7)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(684),h0tab(:,684),[20,3,8],[nMB,nMB,0],3,2,wf4(:,3),wf4(:,5))
  call Hloop_VQ_A(ntryL,G0H32(1),wf4(:,3),G0H8(37),m3h4x8(:,310),heltab2x32(:,:,684))
  call Hloop_Q_A(ntryL,G0H8(37),20,nMB,G1H8(19),n2h8(155))
  Gcoeff(:)%j = (-(c(5)*M(4,:)%j)) * den(7)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(685),h0tab(:,685),[20,3,8],[nMB,nMB,nMZ],3,2,wf4(:,3),wf4(:,5))
  call Hloop_ZQ_A(ntryL,G0H32(1),wf4(:,3),G0H8(38),ngZd,m3h4x8(:,311),heltab2x32(:,:,685))
  call Hloop_Q_A(ntryL,G0H8(38),20,nMB,G1H8(20),n2h8(156))
  Gcoeff(:)%j = (c(63)*M(4,:)%j) * den(7)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(686),h0tab(:,686),[20,3,8],[nMT,nMT,nMW],3,2,wf4(:,3),wf4(:,5))
  call Hloop_WQ_A(ntryL,G0H32(1),wf4(:,3),G0H8(39),m3h4x8(:,312),heltab2x32(:,:,686))
  call Hloop_Q_A(ntryL,G0H8(39),20,nMT,G1H8(21),n2h8(157))
  Gcoeff(:)%j = (c(4)*M(4,:)%j) * den(5)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(687),h0tab(:,687),[20,3,8],[nMB,nMB,0],3,2,wf4(:,3),wf4(:,6))
  call Hloop_VQ_A(ntryL,G0H32(1),wf4(:,3),G0H8(40),m3h4x8(:,313),heltab2x32(:,:,687))
  call Hloop_Q_A(ntryL,G0H8(40),20,nMB,G1H8(22),n2h8(158))
  Gcoeff(:)%j = (c(7)*M(4,:)%j) * den(5)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(688),h0tab(:,688),[20,3,8],[nMB,nMB,nMZ],3,2,wf4(:,3),wf4(:,6))
  call Hloop_ZQ_A(ntryL,G0H32(1),wf4(:,3),G0H8(41),ngZd,m3h4x8(:,314),heltab2x32(:,:,688))
  call Hloop_Q_A(ntryL,G0H8(41),20,nMB,G1H8(23),n2h8(159))
  Gcoeff(:)%j = (c(65)*M(4,:)%j) * den(5)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(689),h0tab(:,689),[20,3,8],[nMT,nMT,nMW],3,2,wf4(:,3),wf4(:,6))
  call Hloop_WQ_A(ntryL,G0H32(1),wf4(:,3),G0H8(42),m3h4x8(:,315),heltab2x32(:,:,689))
  call Hloop_Q_A(ntryL,G0H8(42),20,nMT,G1H8(24),n2h8(160))
  Gcoeff(:)%j = (-(c(64)*M(4,:)%j)) * den(7)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(690),h0tab(:,690),[20,3,8],[nMW,nMW,nMT],3,2,wf4(:,3),wf4(:,5))
  call Hloop_AQ_W(ntryL,G0H32(1),wf4(:,3),G0H8(43),m3h4x8(:,316),heltab2x32(:,:,690))
  Gcoeff(:)%j = (-(c(70)*M(4,:)%j)) * den(5)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(691),h0tab(:,691),[20,3,8],[nMZ,nMH,nMB],3,2,wf4(:,3),wf4(:,6))
  call Hloop_AQ_Z(ntryL,G0H32(1),wf4(:,3),G0H8(44),ngZd,m3h4x8(:,317),heltab2x32(:,:,691))
  Gcoeff(:)%j = (c(92)*M(4,:)%j) * den(5)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(692),h0tab(:,692),[20,3,8],[nMW,nMW,nMT],3,2,wf4(:,3),wf4(:,6))
  call Hloop_AQ_W(ntryL,G0H32(1),wf4(:,3),G0H8(45),m3h4x8(:,318),heltab2x32(:,:,692))
  Gcoeff(:)%j = (c(64)*M(4,:)%j) * den(7)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(693),h0tab(:,693),[20,3,8],[nMW,nMW,nMT],3,2,wf4(:,3),wf4(:,5))
  call Hloop_AQ_S(ntryL,G0H32(1),wf4(:,3),G0H8(46),ngPtb,m3h4x8(:,319),heltab2x32(:,:,693))
  Gcoeff(:)%j = (-(c(70)*M(4,:)%j)) * den(5)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(694),h0tab(:,694),[20,3,8],[nMH,nMZ,nMB],3,2,wf4(:,3),wf4(:,6))
  call Hloop_AQ_S(ntryL,G0H32(1),wf4(:,3),G0H8(47),ngH,m3h4x8(:,320),heltab2x32(:,:,694))
  Gcoeff(:)%j = (-(c(92)*M(4,:)%j)) * den(5)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(695),h0tab(:,695),[20,3,8],[nMW,nMW,nMT],3,2,wf4(:,3),wf4(:,6))
  call Hloop_AQ_S(ntryL,G0H32(1),wf4(:,3),G0H8(48),ngPtb,m3h4x8(:,321),heltab2x32(:,:,695))
  Gcoeff(:)%j = (c(64)*M(4,:)%j) * den(7)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(696),h0tab(:,696),[20,3,8],[nMW,nMW,nMT],3,2,wf4(:,3),wf4(:,5))
  call Hloop_AQ_W(ntryL,G0H32(1),wf4(:,3),G0H8(49),m3h4x8(:,322),heltab2x32(:,:,696))
  Gcoeff(:)%j = (c(48)*M(4,:)%j) * den(5)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(697),h0tab(:,697),[20,3,8],[nMW,nMW,nMT],3,2,wf4(:,3),wf4(:,6))
  call Hloop_AQ_W(ntryL,G0H32(1),wf4(:,3),G0H8(50),m3h4x8(:,323),heltab2x32(:,:,697))
  Gcoeff(:)%j = (c(25)*M(4,:)%j) * den(9)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(698),h0tab(:,698),[24,3,4],[nMB,nMB,nMH],3,2,wf4(:,8),wf4(:,1))
  call Hloop_SA_Q(ntryL,G0H32(1),wf4(:,8),G0H8(51),ngH,m3h4x8(:,324),heltab2x32(:,:,698))
  call Hloop_A_Q(ntryL,G0H8(51),24,nMB,G1H8(25),n2h8(161))
  Gcoeff(:)%j = (-(c(25)*M(4,:)%j)) * den(9)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(699),h0tab(:,699),[24,3,4],[nMB,nMB,nMZ],3,2,wf4(:,8),wf4(:,1))
  call Hloop_SA_Q(ntryL,G0H32(1),wf4(:,8),G0H8(52),ngX,m3h4x8(:,325),heltab2x32(:,:,699))
  call Hloop_A_Q(ntryL,G0H8(52),24,nMB,G1H8(26),n2h8(162))
  Gcoeff(:)%j = (-(c(32)*M(4,:)%j)) * den(9)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(700),h0tab(:,700),[24,3,4],[nMT,nMT,nMW],3,2,wf4(:,8),wf4(:,1))
  call Hloop_SA_Q(ntryL,G0H32(1),wf4(:,8),G0H8(53),ngPbt,m3h4x8(:,326),heltab2x32(:,:,700))
  call Hloop_A_Q(ntryL,G0H8(53),24,nMT,G1H8(27),n2h8(163))
  Gcoeff(:)%j = (c(25)*M(4,:)%j) * den(10)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(701),h0tab(:,701),[24,3,4],[nMB,nMB,nMH],3,2,wf4(:,8),wf4(:,4))
  call Hloop_SA_Q(ntryL,G0H32(1),wf4(:,8),G0H8(54),ngH,m3h4x8(:,327),heltab2x32(:,:,701))
  call Hloop_A_Q(ntryL,G0H8(54),24,nMB,G1H8(28),n2h8(164))
  Gcoeff(:)%j = (-(c(25)*M(4,:)%j)) * den(10)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(702),h0tab(:,702),[24,3,4],[nMB,nMB,nMZ],3,2,wf4(:,8),wf4(:,4))
  call Hloop_SA_Q(ntryL,G0H32(1),wf4(:,8),G0H8(55),ngX,m3h4x8(:,328),heltab2x32(:,:,702))
  call Hloop_A_Q(ntryL,G0H8(55),24,nMB,G1H8(29),n2h8(165))
  Gcoeff(:)%j = (c(32)*M(4,:)%j) * den(10)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(703),h0tab(:,703),[24,3,4],[nMT,nMT,nMW],3,2,wf4(:,8),wf4(:,4))
  call Hloop_SA_Q(ntryL,G0H32(1),wf4(:,8),G0H8(56),ngPbt,m3h4x8(:,329),heltab2x32(:,:,703))
  call Hloop_A_Q(ntryL,G0H8(56),24,nMT,G1H8(30),n2h8(166))
  Gcoeff(:)%j = (c(28)*M(4,:)%j) * den(9)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(704),h0tab(:,704),[24,3,4],[nMH,nMH,nMB],3,2,wf4(:,8),wf4(:,1))
  call Hloop_QA_S(ntryL,G0H32(1),wf4(:,8),G0H8(57),ngH,m3h4x8(:,330),heltab2x32(:,:,704))
  Gcoeff(:)%j = (-(c(27)*M(4,:)%j)) * den(9)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(705),h0tab(:,705),[24,3,4],[nMZ,nMZ,nMB],3,2,wf4(:,8),wf4(:,1))
  call Hloop_QA_S(ntryL,G0H32(1),wf4(:,8),G0H8(58),ngX,m3h4x8(:,331),heltab2x32(:,:,705))
  Gcoeff(:)%j = (-(c(26)*M(4,:)%j)) * den(9)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(706),h0tab(:,706),[24,3,4],[nMW,nMW,nMT],3,2,wf4(:,8),wf4(:,1))
  call Hloop_QA_S(ntryL,G0H32(1),wf4(:,8),G0H8(59),ngPbt,m3h4x8(:,332),heltab2x32(:,:,706))
  Gcoeff(:)%j = (c(27)*M(4,:)%j) * den(10)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(707),h0tab(:,707),[24,3,4],[nMZ,nMH,nMB],3,2,wf4(:,8),wf4(:,4))
  call Hloop_QA_S(ntryL,G0H32(1),wf4(:,8),G0H8(60),ngX,m3h4x8(:,333),heltab2x32(:,:,707))
  Gcoeff(:)%j = (c(27)*M(4,:)%j) * den(10)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(708),h0tab(:,708),[24,3,4],[nMH,nMZ,nMB],3,2,wf4(:,8),wf4(:,4))
  call Hloop_QA_S(ntryL,G0H32(1),wf4(:,8),G0H8(61),ngH,m3h4x8(:,334),heltab2x32(:,:,708))
  Gcoeff(:)%j = (-(c(83)*M(4,:)%j)) * den(9)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(709),h0tab(:,709),[24,3,4],[nMB,nMB,0],3,2,wf4(:,8),wf4(:,1))
  call Hloop_VA_Q(ntryL,G0H32(1),wf4(:,8),G0H8(62),m3h4x8(:,335),heltab2x32(:,:,709))
  call Hloop_A_Q(ntryL,G0H8(62),24,nMB,G1H8(31),n2h8(167))
  Gcoeff(:)%j = (-(c(86)*M(4,:)%j)) * den(9)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(710),h0tab(:,710),[24,3,4],[nMB,nMB,nMZ],3,2,wf4(:,8),wf4(:,1))
  call Hloop_ZA_Q(ntryL,G0H32(1),wf4(:,8),G0H8(63),ngZd,m3h4x8(:,336),heltab2x32(:,:,710))
  call Hloop_A_Q(ntryL,G0H8(63),24,nMB,G1H8(32),n2h8(168))
  Gcoeff(:)%j = (-(c(46)*M(4,:)%j)) * den(9)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(711),h0tab(:,711),[24,3,4],[nMT,nMT,nMW],3,2,wf4(:,8),wf4(:,1))
  call Hloop_WA_Q(ntryL,G0H32(1),wf4(:,8),G0H8(64),m3h4x8(:,337),heltab2x32(:,:,711))
  call Hloop_A_Q(ntryL,G0H8(64),24,nMT,G1H8(33),n2h8(169))
  Gcoeff(:)%j = (-(c(83)*M(4,:)%j)) * den(10)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(712),h0tab(:,712),[24,3,4],[nMB,nMB,0],3,2,wf4(:,8),wf4(:,4))
  call Hloop_VA_Q(ntryL,G0H32(1),wf4(:,8),G0H8(65),m3h4x8(:,338),heltab2x32(:,:,712))
  call Hloop_A_Q(ntryL,G0H8(65),24,nMB,G1H8(34),n2h8(170))
  Gcoeff(:)%j = (-(c(86)*M(4,:)%j)) * den(10)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(713),h0tab(:,713),[24,3,4],[nMB,nMB,nMZ],3,2,wf4(:,8),wf4(:,4))
  call Hloop_ZA_Q(ntryL,G0H32(1),wf4(:,8),G0H8(66),ngZd,m3h4x8(:,339),heltab2x32(:,:,713))
  call Hloop_A_Q(ntryL,G0H8(66),24,nMB,G1H8(35),n2h8(171))
  Gcoeff(:)%j = (c(46)*M(4,:)%j) * den(10)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(714),h0tab(:,714),[24,3,4],[nMT,nMT,nMW],3,2,wf4(:,8),wf4(:,4))
  call Hloop_WA_Q(ntryL,G0H32(1),wf4(:,8),G0H8(67),m3h4x8(:,340),heltab2x32(:,:,714))
  call Hloop_A_Q(ntryL,G0H8(67),24,nMT,G1H8(36),n2h8(172))
  Gcoeff(:)%j = (c(57)*M(4,:)%j) * den(9)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(715),h0tab(:,715),[24,3,4],[nMZ,nMZ,nMB],3,2,wf4(:,8),wf4(:,1))
  call Hloop_QA_Z(ntryL,G0H32(1),wf4(:,8),G0H8(68),ngZd,m3h4x8(:,341),heltab2x32(:,:,715))
  Gcoeff(:)%j = (-(c(42)*M(4,:)%j)) * den(9)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(716),h0tab(:,716),[24,3,4],[nMW,nMW,nMT],3,2,wf4(:,8),wf4(:,1))
  call Hloop_QA_W(ntryL,G0H32(1),wf4(:,8),G0H8(69),m3h4x8(:,342),heltab2x32(:,:,716))
  Gcoeff(:)%j = (-(c(57)*M(4,:)%j)) * den(10)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(717),h0tab(:,717),[24,3,4],[nMZ,nMH,nMB],3,2,wf4(:,8),wf4(:,4))
  call Hloop_QA_Z(ntryL,G0H32(1),wf4(:,8),G0H8(70),ngZd,m3h4x8(:,343),heltab2x32(:,:,717))
  Gcoeff(:)%j = (c(42)*M(4,:)%j) * den(10)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(718),h0tab(:,718),[24,3,4],[nMW,nMW,nMT],3,2,wf4(:,8),wf4(:,4))
  call Hloop_QA_W(ntryL,G0H32(1),wf4(:,8),G0H8(71),m3h4x8(:,344),heltab2x32(:,:,718))
  Gcoeff(:)%j = (c(57)*M(4,:)%j) * den(9)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(719),h0tab(:,719),[24,3,4],[nMZ,nMZ,nMB],3,2,wf4(:,8),wf4(:,1))
  call Hloop_QA_S(ntryL,G0H32(1),wf4(:,8),G0H8(72),ngX,m3h4x8(:,345),heltab2x32(:,:,719))
  Gcoeff(:)%j = (-(c(42)*M(4,:)%j)) * den(9)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(720),h0tab(:,720),[24,3,4],[nMW,nMW,nMT],3,2,wf4(:,8),wf4(:,1))
  call Hloop_QA_S(ntryL,G0H32(1),wf4(:,8),G0H8(73),ngPbt,m3h4x8(:,346),heltab2x32(:,:,720))
  Gcoeff(:)%j = (-(c(57)*M(4,:)%j)) * den(10)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(721),h0tab(:,721),[24,3,4],[nMH,nMZ,nMB],3,2,wf4(:,8),wf4(:,4))
  call Hloop_QA_S(ntryL,G0H32(1),wf4(:,8),G0H8(74),ngH,m3h4x8(:,347),heltab2x32(:,:,721))
  Gcoeff(:)%j = (-(c(42)*M(4,:)%j)) * den(10)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(722),h0tab(:,722),[24,3,4],[nMW,nMW,nMT],3,2,wf4(:,8),wf4(:,4))
  call Hloop_QA_S(ntryL,G0H32(1),wf4(:,8),G0H8(75),ngPbt,m3h4x8(:,348),heltab2x32(:,:,722))
  Gcoeff(:)%j = (-(c(73)*M(4,:)%j)) * den(9)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(723),h0tab(:,723),[24,3,4],[nMZ,nMZ,nMB],3,2,wf4(:,8),wf4(:,1))
  call Hloop_QA_Z(ntryL,G0H32(1),wf4(:,8),G0H8(76),ngZd,m3h4x8(:,349),heltab2x32(:,:,723))
  Gcoeff(:)%j = (-(c(15)*M(4,:)%j)) * den(9)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(724),h0tab(:,724),[24,3,4],[nMW,nMW,nMT],3,2,wf4(:,8),wf4(:,1))
  call Hloop_QA_W(ntryL,G0H32(1),wf4(:,8),G0H8(77),m3h4x8(:,350),heltab2x32(:,:,724))
  Gcoeff(:)%j = (c(80)*M(4,:)%j) * den(11)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(725),h0tab(:,725),[24,3,4],[nMB,nMB,nMH],3,2,wf4(:,8),wf4(:,5))
  call Hloop_SA_Q(ntryL,G0H32(1),wf4(:,8),G0H8(78),ngH,m3h4x8(:,351),heltab2x32(:,:,725))
  call Hloop_A_Q(ntryL,G0H8(78),24,nMB,G1H8(37),n2h8(173))
  Gcoeff(:)%j = (-(c(80)*M(4,:)%j)) * den(11)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(726),h0tab(:,726),[24,3,4],[nMB,nMB,nMZ],3,2,wf4(:,8),wf4(:,5))
  call Hloop_SA_Q(ntryL,G0H32(1),wf4(:,8),G0H8(79),ngX,m3h4x8(:,352),heltab2x32(:,:,726))
  call Hloop_A_Q(ntryL,G0H8(79),24,nMB,G1H8(38),n2h8(174))
  Gcoeff(:)%j = (c(77)*M(4,:)%j) * den(11)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(727),h0tab(:,727),[24,3,4],[nMT,nMT,nMW],3,2,wf4(:,8),wf4(:,5))
  call Hloop_SA_Q(ntryL,G0H32(1),wf4(:,8),G0H8(80),ngPbt,m3h4x8(:,353),heltab2x32(:,:,727))
  call Hloop_A_Q(ntryL,G0H8(80),24,nMT,G1H8(39),n2h8(175))
  Gcoeff(:)%j = (-(c(81)*M(4,:)%j)) * den(10)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(728),h0tab(:,728),[24,3,4],[nMB,nMB,nMH],3,2,wf4(:,8),wf4(:,6))
  call Hloop_SA_Q(ntryL,G0H32(1),wf4(:,8),G0H8(81),ngH,m3h4x8(:,354),heltab2x32(:,:,728))
  call Hloop_A_Q(ntryL,G0H8(81),24,nMB,G1H8(40),n2h8(176))
  Gcoeff(:)%j = (c(81)*M(4,:)%j) * den(10)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(729),h0tab(:,729),[24,3,4],[nMB,nMB,nMZ],3,2,wf4(:,8),wf4(:,6))
  call Hloop_SA_Q(ntryL,G0H32(1),wf4(:,8),G0H8(82),ngX,m3h4x8(:,355),heltab2x32(:,:,729))
  call Hloop_A_Q(ntryL,G0H8(82),24,nMB,G1H8(41),n2h8(177))
  Gcoeff(:)%j = (c(79)*M(4,:)%j) * den(10)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(730),h0tab(:,730),[24,3,4],[nMT,nMT,nMW],3,2,wf4(:,8),wf4(:,6))
  call Hloop_SA_Q(ntryL,G0H32(1),wf4(:,8),G0H8(83),ngPbt,m3h4x8(:,356),heltab2x32(:,:,730))
  call Hloop_A_Q(ntryL,G0H8(83),24,nMT,G1H8(42),n2h8(178))
  Gcoeff(:)%j = (c(78)*M(4,:)%j) * den(11)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(731),h0tab(:,731),[24,3,4],[nMW,nMW,nMT],3,2,wf4(:,8),wf4(:,5))
  call Hloop_QA_S(ntryL,G0H32(1),wf4(:,8),G0H8(84),ngPbt,m3h4x8(:,357),heltab2x32(:,:,731))
  Gcoeff(:)%j = (c(55)*M(4,:)%j) * den(10)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(732),h0tab(:,732),[24,3,4],[nMZ,nMH,nMB],3,2,wf4(:,8),wf4(:,6))
  call Hloop_QA_S(ntryL,G0H32(1),wf4(:,8),G0H8(85),ngX,m3h4x8(:,358),heltab2x32(:,:,732))
  Gcoeff(:)%j = (c(55)*M(4,:)%j) * den(10)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(733),h0tab(:,733),[24,3,4],[nMH,nMZ,nMB],3,2,wf4(:,8),wf4(:,6))
  call Hloop_QA_S(ntryL,G0H32(1),wf4(:,8),G0H8(86),ngH,m3h4x8(:,359),heltab2x32(:,:,733))
  Gcoeff(:)%j = (-(c(104)*M(4,:)%j)) * den(10)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(734),h0tab(:,734),[24,3,4],[nMW,nMW,nMT],3,2,wf4(:,8),wf4(:,6))
  call Hloop_QA_S(ntryL,G0H32(1),wf4(:,8),G0H8(87),ngPbt,m3h4x8(:,360),heltab2x32(:,:,734))
  Gcoeff(:)%j = (-(c(1)*M(4,:)%j)) * den(11)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(735),h0tab(:,735),[24,3,4],[nMB,nMB,0],3,2,wf4(:,8),wf4(:,5))
  call Hloop_VA_Q(ntryL,G0H32(1),wf4(:,8),G0H8(88),m3h4x8(:,361),heltab2x32(:,:,735))
  call Hloop_A_Q(ntryL,G0H8(88),24,nMB,G1H8(43),n2h8(179))
  Gcoeff(:)%j = (-(c(5)*M(4,:)%j)) * den(11)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(736),h0tab(:,736),[24,3,4],[nMB,nMB,nMZ],3,2,wf4(:,8),wf4(:,5))
  call Hloop_ZA_Q(ntryL,G0H32(1),wf4(:,8),G0H8(89),ngZd,m3h4x8(:,362),heltab2x32(:,:,736))
  call Hloop_A_Q(ntryL,G0H8(89),24,nMB,G1H8(44),n2h8(180))
  Gcoeff(:)%j = (c(63)*M(4,:)%j) * den(11)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(737),h0tab(:,737),[24,3,4],[nMT,nMT,nMW],3,2,wf4(:,8),wf4(:,5))
  call Hloop_WA_Q(ntryL,G0H32(1),wf4(:,8),G0H8(90),m3h4x8(:,363),heltab2x32(:,:,737))
  call Hloop_A_Q(ntryL,G0H8(90),24,nMT,G1H8(45),n2h8(181))
  Gcoeff(:)%j = (c(4)*M(4,:)%j) * den(10)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(738),h0tab(:,738),[24,3,4],[nMB,nMB,0],3,2,wf4(:,8),wf4(:,6))
  call Hloop_VA_Q(ntryL,G0H32(1),wf4(:,8),G0H8(91),m3h4x8(:,364),heltab2x32(:,:,738))
  call Hloop_A_Q(ntryL,G0H8(91),24,nMB,G1H8(46),n2h8(182))
  Gcoeff(:)%j = (c(7)*M(4,:)%j) * den(10)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(739),h0tab(:,739),[24,3,4],[nMB,nMB,nMZ],3,2,wf4(:,8),wf4(:,6))
  call Hloop_ZA_Q(ntryL,G0H32(1),wf4(:,8),G0H8(92),ngZd,m3h4x8(:,365),heltab2x32(:,:,739))
  call Hloop_A_Q(ntryL,G0H8(92),24,nMB,G1H8(47),n2h8(183))
  Gcoeff(:)%j = (c(65)*M(4,:)%j) * den(10)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(740),h0tab(:,740),[24,3,4],[nMT,nMT,nMW],3,2,wf4(:,8),wf4(:,6))
  call Hloop_WA_Q(ntryL,G0H32(1),wf4(:,8),G0H8(93),m3h4x8(:,366),heltab2x32(:,:,740))
  call Hloop_A_Q(ntryL,G0H8(93),24,nMT,G1H8(48),n2h8(184))
  Gcoeff(:)%j = (c(64)*M(4,:)%j) * den(11)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(741),h0tab(:,741),[24,3,4],[nMW,nMW,nMT],3,2,wf4(:,8),wf4(:,5))
  call Hloop_QA_W(ntryL,G0H32(1),wf4(:,8),G0H8(94),m3h4x8(:,367),heltab2x32(:,:,741))
  Gcoeff(:)%j = (-(c(70)*M(4,:)%j)) * den(10)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(742),h0tab(:,742),[24,3,4],[nMZ,nMH,nMB],3,2,wf4(:,8),wf4(:,6))
  call Hloop_QA_Z(ntryL,G0H32(1),wf4(:,8),G0H8(95),ngZd,m3h4x8(:,368),heltab2x32(:,:,742))
  Gcoeff(:)%j = (-(c(92)*M(4,:)%j)) * den(10)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(743),h0tab(:,743),[24,3,4],[nMW,nMW,nMT],3,2,wf4(:,8),wf4(:,6))
  call Hloop_QA_W(ntryL,G0H32(1),wf4(:,8),G0H8(96),m3h4x8(:,369),heltab2x32(:,:,743))
  Gcoeff(:)%j = (-(c(64)*M(4,:)%j)) * den(11)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(744),h0tab(:,744),[24,3,4],[nMW,nMW,nMT],3,2,wf4(:,8),wf4(:,5))
  call Hloop_QA_S(ntryL,G0H32(1),wf4(:,8),G0H8(97),ngPbt,m3h4x8(:,370),heltab2x32(:,:,744))
  Gcoeff(:)%j = (-(c(70)*M(4,:)%j)) * den(10)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(745),h0tab(:,745),[24,3,4],[nMH,nMZ,nMB],3,2,wf4(:,8),wf4(:,6))
  call Hloop_QA_S(ntryL,G0H32(1),wf4(:,8),G0H8(98),ngH,m3h4x8(:,371),heltab2x32(:,:,745))
  Gcoeff(:)%j = (c(92)*M(4,:)%j) * den(10)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(746),h0tab(:,746),[24,3,4],[nMW,nMW,nMT],3,2,wf4(:,8),wf4(:,6))
  call Hloop_QA_S(ntryL,G0H32(1),wf4(:,8),G0H8(99),ngPbt,m3h4x8(:,372),heltab2x32(:,:,746))
  Gcoeff(:)%j = (c(64)*M(4,:)%j) * den(11)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(747),h0tab(:,747),[24,3,4],[nMW,nMW,nMT],3,2,wf4(:,8),wf4(:,5))
  call Hloop_QA_W(ntryL,G0H32(1),wf4(:,8),G0H8(100),m3h4x8(:,373),heltab2x32(:,:,747))
  Gcoeff(:)%j = (c(48)*M(4,:)%j) * den(10)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(748),h0tab(:,748),[24,3,4],[nMW,nMW,nMT],3,2,wf4(:,8),wf4(:,6))
  call Hloop_QA_W(ntryL,G0H32(1),wf4(:,8),G0H8(101),m3h4x8(:,374),heltab2x32(:,:,748))
  Gcoeff(:)%j = (c(25)*M(4,:)%j) * den(56)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(749),h0tab(:,749),[16,7,8],[nMB,nMH,nMB],3,1,wf8(:,85))
  call Hloop_AV_Q(ntryL,G0H32(1),ex5(:),G0H16(1),m3h2x16(:,375),heltab2x32(:,:,749))
  call Hloop_A_Q(ntryL,G0H16(1),16,nMB,G1H16(1),n2h16(375))
  Gcoeff(:)%j = (-(c(25)*M(4,:)%j)) * den(56)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(750),h0tab(:,750),[16,7,8],[nMB,nMZ,nMB],3,1,wf8(:,85))
  call Hloop_AV_Q(ntryL,G0H32(1),ex5(:),G0H16(1),m3h2x16(:,376),heltab2x32(:,:,750))
  call Hloop_A_Q(ntryL,G0H16(1),16,nMB,G1H16(2),n2h16(376))
  Gcoeff(:)%j = (-(c(24)*M(4,:)%j)) * den(56)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(751),h0tab(:,751),[16,7,8],[nMT,nMW,nMT],3,1,wf8(:,85))
  call Hloop_AV_Q(ntryL,G0H32(1),ex5(:),G0H16(1),m3h2x16(:,377),heltab2x32(:,:,751))
  call Hloop_A_Q(ntryL,G0H16(1),16,nMT,G1H16(3),n2h16(377))
  Gcoeff(:)%j = (c(25)*M(4,:)%j) * den(58)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(752),h0tab(:,752),[16,7,8],[nMB,nMH,nMB],3,1,wf8(:,86))
  call Hloop_AV_Q(ntryL,G0H32(1),ex5(:),G0H16(1),m3h2x16(:,378),heltab2x32(:,:,752))
  call Hloop_A_Q(ntryL,G0H16(1),16,nMB,G1H16(4),n2h16(378))
  Gcoeff(:)%j = (-(c(25)*M(4,:)%j)) * den(58)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(753),h0tab(:,753),[16,7,8],[nMB,nMZ,nMB],3,1,wf8(:,86))
  call Hloop_AV_Q(ntryL,G0H32(1),ex5(:),G0H16(1),m3h2x16(:,379),heltab2x32(:,:,753))
  call Hloop_A_Q(ntryL,G0H16(1),16,nMB,G1H16(5),n2h16(379))
  Gcoeff(:)%j = (-(c(24)*M(4,:)%j)) * den(58)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(754),h0tab(:,754),[16,7,8],[nMT,nMW,nMT],3,1,wf8(:,86))
  call Hloop_AV_Q(ntryL,G0H32(1),ex5(:),G0H16(1),m3h2x16(:,380),heltab2x32(:,:,754))
  call Hloop_A_Q(ntryL,G0H16(1),16,nMT,G1H16(6),n2h16(380))
  Gcoeff(:)%j = (-(c(83)*M(4,:)%j)) * den(56)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(755),h0tab(:,755),[16,7,8],[nMB,0,nMB],3,1,wf8(:,85))
  call Hloop_AV_Q(ntryL,G0H32(1),ex5(:),G0H16(1),m3h2x16(:,381),heltab2x32(:,:,755))
  call Hloop_A_Q(ntryL,G0H16(1),16,nMB,G1H16(7),n2h16(381))
  Gcoeff(:)%j = (-(c(86)*M(4,:)%j)) * den(56)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(756),h0tab(:,756),[16,7,8],[nMB,nMZ,nMB],3,1,wf8(:,85))
  call Hloop_AV_Q(ntryL,G0H32(1),ex5(:),G0H16(1),m3h2x16(:,382),heltab2x32(:,:,756))
  call Hloop_A_Q(ntryL,G0H16(1),16,nMB,G1H16(8),n2h16(382))
  Gcoeff(:)%j = (-(c(44)*M(4,:)%j)) * den(56)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(757),h0tab(:,757),[16,7,8],[nMT,nMW,nMT],3,1,wf8(:,85))
  call Hloop_AV_Q(ntryL,G0H32(1),ex5(:),G0H16(1),m3h2x16(:,383),heltab2x32(:,:,757))
  call Hloop_A_Q(ntryL,G0H16(1),16,nMT,G1H16(9),n2h16(383))
  Gcoeff(:)%j = (-(c(83)*M(4,:)%j)) * den(58)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(758),h0tab(:,758),[16,7,8],[nMB,0,nMB],3,1,wf8(:,86))
  call Hloop_AV_Q(ntryL,G0H32(1),ex5(:),G0H16(1),m3h2x16(:,384),heltab2x32(:,:,758))
  call Hloop_A_Q(ntryL,G0H16(1),16,nMB,G1H16(10),n2h16(384))
  Gcoeff(:)%j = (-(c(86)*M(4,:)%j)) * den(58)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(759),h0tab(:,759),[16,7,8],[nMB,nMZ,nMB],3,1,wf8(:,86))
  call Hloop_AV_Q(ntryL,G0H32(1),ex5(:),G0H16(1),m3h2x16(:,385),heltab2x32(:,:,759))
  call Hloop_A_Q(ntryL,G0H16(1),16,nMB,G1H16(11),n2h16(385))
  Gcoeff(:)%j = (-(c(44)*M(4,:)%j)) * den(58)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(760),h0tab(:,760),[16,7,8],[nMT,nMW,nMT],3,1,wf8(:,86))
  call Hloop_AV_Q(ntryL,G0H32(1),ex5(:),G0H16(1),m3h2x16(:,386),heltab2x32(:,:,760))
  call Hloop_A_Q(ntryL,G0H16(1),16,nMT,G1H16(12),n2h16(386))
  Gcoeff(:)%j = (c(80)*M(4,:)%j) * den(60)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(761),h0tab(:,761),[16,7,8],[nMB,nMH,nMB],3,1,wf8(:,87))
  call Hloop_AV_Q(ntryL,G0H32(1),ex5(:),G0H16(1),m3h2x16(:,387),heltab2x32(:,:,761))
  call Hloop_A_Q(ntryL,G0H16(1),16,nMB,G1H16(13),n2h16(387))
  Gcoeff(:)%j = (-(c(80)*M(4,:)%j)) * den(60)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(762),h0tab(:,762),[16,7,8],[nMB,nMZ,nMB],3,1,wf8(:,87))
  call Hloop_AV_Q(ntryL,G0H32(1),ex5(:),G0H16(1),m3h2x16(:,388),heltab2x32(:,:,762))
  call Hloop_A_Q(ntryL,G0H16(1),16,nMB,G1H16(14),n2h16(388))
  Gcoeff(:)%j = (-(c(75)*M(4,:)%j)) * den(60)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(763),h0tab(:,763),[16,7,8],[nMT,nMW,nMT],3,1,wf8(:,87))
  call Hloop_AV_Q(ntryL,G0H32(1),ex5(:),G0H16(1),m3h2x16(:,389),heltab2x32(:,:,763))
  call Hloop_A_Q(ntryL,G0H16(1),16,nMT,G1H16(15),n2h16(389))
  Gcoeff(:)%j = (-(c(81)*M(4,:)%j)) * den(58)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(764),h0tab(:,764),[16,7,8],[nMB,nMH,nMB],3,1,wf8(:,88))
  call Hloop_AV_Q(ntryL,G0H32(1),ex5(:),G0H16(1),m3h2x16(:,390),heltab2x32(:,:,764))
  call Hloop_A_Q(ntryL,G0H16(1),16,nMB,G1H16(16),n2h16(390))
  Gcoeff(:)%j = (c(81)*M(4,:)%j) * den(58)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(765),h0tab(:,765),[16,7,8],[nMB,nMZ,nMB],3,1,wf8(:,88))
  call Hloop_AV_Q(ntryL,G0H32(1),ex5(:),G0H16(1),m3h2x16(:,391),heltab2x32(:,:,765))
  call Hloop_A_Q(ntryL,G0H16(1),16,nMB,G1H16(17),n2h16(391))
  Gcoeff(:)%j = (c(79)*M(4,:)%j) * den(58)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(766),h0tab(:,766),[16,7,8],[nMT,nMW,nMT],3,1,wf8(:,88))
  call Hloop_AV_Q(ntryL,G0H32(1),ex5(:),G0H16(1),m3h2x16(:,392),heltab2x32(:,:,766))
  call Hloop_A_Q(ntryL,G0H16(1),16,nMT,G1H16(18),n2h16(392))
  Gcoeff(:)%j = (-(c(1)*M(4,:)%j)) * den(60)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(767),h0tab(:,767),[16,7,8],[nMB,0,nMB],3,1,wf8(:,87))
  call Hloop_AV_Q(ntryL,G0H32(1),ex5(:),G0H16(1),m3h2x16(:,393),heltab2x32(:,:,767))
  call Hloop_A_Q(ntryL,G0H16(1),16,nMB,G1H16(19),n2h16(393))
  Gcoeff(:)%j = (-(c(5)*M(4,:)%j)) * den(60)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(768),h0tab(:,768),[16,7,8],[nMB,nMZ,nMB],3,1,wf8(:,87))
  call Hloop_AV_Q(ntryL,G0H32(1),ex5(:),G0H16(1),m3h2x16(:,394),heltab2x32(:,:,768))
  call Hloop_A_Q(ntryL,G0H16(1),16,nMB,G1H16(20),n2h16(394))
  Gcoeff(:)%j = (-(c(61)*M(4,:)%j)) * den(60)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(769),h0tab(:,769),[16,7,8],[nMT,nMW,nMT],3,1,wf8(:,87))
  call Hloop_AV_Q(ntryL,G0H32(1),ex5(:),G0H16(1),m3h2x16(:,395),heltab2x32(:,:,769))
  call Hloop_A_Q(ntryL,G0H16(1),16,nMT,G1H16(21),n2h16(395))
  Gcoeff(:)%j = (c(4)*M(4,:)%j) * den(58)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(770),h0tab(:,770),[16,7,8],[nMB,0,nMB],3,1,wf8(:,88))
  call Hloop_AV_Q(ntryL,G0H32(1),ex5(:),G0H16(1),m3h2x16(:,396),heltab2x32(:,:,770))
  call Hloop_A_Q(ntryL,G0H16(1),16,nMB,G1H16(22),n2h16(396))
  Gcoeff(:)%j = (c(7)*M(4,:)%j) * den(58)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(771),h0tab(:,771),[16,7,8],[nMB,nMZ,nMB],3,1,wf8(:,88))
  call Hloop_AV_Q(ntryL,G0H32(1),ex5(:),G0H16(1),m3h2x16(:,397),heltab2x32(:,:,771))
  call Hloop_A_Q(ntryL,G0H16(1),16,nMB,G1H16(23),n2h16(397))
  Gcoeff(:)%j = (c(65)*M(4,:)%j) * den(58)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(772),h0tab(:,772),[16,7,8],[nMT,nMW,nMT],3,1,wf8(:,88))
  call Hloop_AV_Q(ntryL,G0H32(1),ex5(:),G0H16(1),m3h2x16(:,398),heltab2x32(:,:,772))
  call Hloop_A_Q(ntryL,G0H16(1),16,nMT,G1H16(24),n2h16(398))
  Gcoeff(:)%j = (c(25)*M(4,:)%j) * den(41)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(773),h0tab(:,773),[16,4,11],[nMB,nMH,nMB],3,1,wf8(:,77))
  call Hloop_AV_Q(ntryL,G0H32(1),ex5(:),G0H16(1),m3h2x16(:,399),heltab2x32(:,:,773))
  call Hloop_A_Q(ntryL,G0H16(1),16,nMB,G1H16(25),n2h16(399))
  Gcoeff(:)%j = (-(c(25)*M(4,:)%j)) * den(41)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(774),h0tab(:,774),[16,4,11],[nMB,nMZ,nMB],3,1,wf8(:,77))
  call Hloop_AV_Q(ntryL,G0H32(1),ex5(:),G0H16(1),m3h2x16(:,400),heltab2x32(:,:,774))
  call Hloop_A_Q(ntryL,G0H16(1),16,nMB,G1H16(26),n2h16(400))
  Gcoeff(:)%j = (-(c(24)*M(4,:)%j)) * den(41)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(775),h0tab(:,775),[16,4,11],[nMT,nMW,nMT],3,1,wf8(:,77))
  call Hloop_AV_Q(ntryL,G0H32(1),ex5(:),G0H16(1),m3h2x16(:,401),heltab2x32(:,:,775))
  call Hloop_A_Q(ntryL,G0H16(1),16,nMT,G1H16(27),n2h16(401))
  Gcoeff(:)%j = (c(25)*M(4,:)%j) * den(43)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(776),h0tab(:,776),[16,4,11],[nMB,nMH,nMB],3,1,wf8(:,78))
  call Hloop_AV_Q(ntryL,G0H32(1),ex5(:),G0H16(1),m3h2x16(:,402),heltab2x32(:,:,776))
  call Hloop_A_Q(ntryL,G0H16(1),16,nMB,G1H16(28),n2h16(402))
  Gcoeff(:)%j = (-(c(25)*M(4,:)%j)) * den(43)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(777),h0tab(:,777),[16,4,11],[nMB,nMZ,nMB],3,1,wf8(:,78))
  call Hloop_AV_Q(ntryL,G0H32(1),ex5(:),G0H16(1),m3h2x16(:,403),heltab2x32(:,:,777))
  call Hloop_A_Q(ntryL,G0H16(1),16,nMB,G1H16(29),n2h16(403))
  Gcoeff(:)%j = (-(c(24)*M(4,:)%j)) * den(43)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(778),h0tab(:,778),[16,4,11],[nMT,nMW,nMT],3,1,wf8(:,78))
  call Hloop_AV_Q(ntryL,G0H32(1),ex5(:),G0H16(1),m3h2x16(:,404),heltab2x32(:,:,778))
  call Hloop_A_Q(ntryL,G0H16(1),16,nMT,G1H16(30),n2h16(404))
  Gcoeff(:)%j = (-(c(83)*M(4,:)%j)) * den(41)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(779),h0tab(:,779),[16,4,11],[nMB,0,nMB],3,1,wf8(:,77))
  call Hloop_AV_Q(ntryL,G0H32(1),ex5(:),G0H16(1),m3h2x16(:,405),heltab2x32(:,:,779))
  call Hloop_A_Q(ntryL,G0H16(1),16,nMB,G1H16(31),n2h16(405))
  Gcoeff(:)%j = (-(c(86)*M(4,:)%j)) * den(41)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(780),h0tab(:,780),[16,4,11],[nMB,nMZ,nMB],3,1,wf8(:,77))
  call Hloop_AV_Q(ntryL,G0H32(1),ex5(:),G0H16(1),m3h2x16(:,406),heltab2x32(:,:,780))
  call Hloop_A_Q(ntryL,G0H16(1),16,nMB,G1H16(32),n2h16(406))
  Gcoeff(:)%j = (-(c(44)*M(4,:)%j)) * den(41)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(781),h0tab(:,781),[16,4,11],[nMT,nMW,nMT],3,1,wf8(:,77))
  call Hloop_AV_Q(ntryL,G0H32(1),ex5(:),G0H16(1),m3h2x16(:,407),heltab2x32(:,:,781))
  call Hloop_A_Q(ntryL,G0H16(1),16,nMT,G1H16(33),n2h16(407))
  Gcoeff(:)%j = (-(c(83)*M(4,:)%j)) * den(43)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(782),h0tab(:,782),[16,4,11],[nMB,0,nMB],3,1,wf8(:,78))
  call Hloop_AV_Q(ntryL,G0H32(1),ex5(:),G0H16(1),m3h2x16(:,408),heltab2x32(:,:,782))
  call Hloop_A_Q(ntryL,G0H16(1),16,nMB,G1H16(34),n2h16(408))
  Gcoeff(:)%j = (-(c(86)*M(4,:)%j)) * den(43)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(783),h0tab(:,783),[16,4,11],[nMB,nMZ,nMB],3,1,wf8(:,78))
  call Hloop_AV_Q(ntryL,G0H32(1),ex5(:),G0H16(1),m3h2x16(:,409),heltab2x32(:,:,783))
  call Hloop_A_Q(ntryL,G0H16(1),16,nMB,G1H16(35),n2h16(409))
  Gcoeff(:)%j = (-(c(44)*M(4,:)%j)) * den(43)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(784),h0tab(:,784),[16,4,11],[nMT,nMW,nMT],3,1,wf8(:,78))
  call Hloop_AV_Q(ntryL,G0H32(1),ex5(:),G0H16(1),m3h2x16(:,410),heltab2x32(:,:,784))
  call Hloop_A_Q(ntryL,G0H16(1),16,nMT,G1H16(36),n2h16(410))
  Gcoeff(:)%j = (c(80)*M(4,:)%j) * den(45)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(785),h0tab(:,785),[16,4,11],[nMB,nMH,nMB],3,1,wf8(:,79))
  call Hloop_AV_Q(ntryL,G0H32(1),ex5(:),G0H16(1),m3h2x16(:,411),heltab2x32(:,:,785))
  call Hloop_A_Q(ntryL,G0H16(1),16,nMB,G1H16(37),n2h16(411))
  Gcoeff(:)%j = (-(c(80)*M(4,:)%j)) * den(45)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(786),h0tab(:,786),[16,4,11],[nMB,nMZ,nMB],3,1,wf8(:,79))
  call Hloop_AV_Q(ntryL,G0H32(1),ex5(:),G0H16(1),m3h2x16(:,412),heltab2x32(:,:,786))
  call Hloop_A_Q(ntryL,G0H16(1),16,nMB,G1H16(38),n2h16(412))
  Gcoeff(:)%j = (-(c(75)*M(4,:)%j)) * den(45)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(787),h0tab(:,787),[16,4,11],[nMT,nMW,nMT],3,1,wf8(:,79))
  call Hloop_AV_Q(ntryL,G0H32(1),ex5(:),G0H16(1),m3h2x16(:,413),heltab2x32(:,:,787))
  call Hloop_A_Q(ntryL,G0H16(1),16,nMT,G1H16(39),n2h16(413))
  Gcoeff(:)%j = (-(c(81)*M(4,:)%j)) * den(43)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(788),h0tab(:,788),[16,4,11],[nMB,nMH,nMB],3,1,wf8(:,80))
  call Hloop_AV_Q(ntryL,G0H32(1),ex5(:),G0H16(1),m3h2x16(:,414),heltab2x32(:,:,788))
  call Hloop_A_Q(ntryL,G0H16(1),16,nMB,G1H16(40),n2h16(414))
  Gcoeff(:)%j = (c(81)*M(4,:)%j) * den(43)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(789),h0tab(:,789),[16,4,11],[nMB,nMZ,nMB],3,1,wf8(:,80))
  call Hloop_AV_Q(ntryL,G0H32(1),ex5(:),G0H16(1),m3h2x16(:,415),heltab2x32(:,:,789))
  call Hloop_A_Q(ntryL,G0H16(1),16,nMB,G1H16(41),n2h16(415))
  Gcoeff(:)%j = (c(79)*M(4,:)%j) * den(43)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(790),h0tab(:,790),[16,4,11],[nMT,nMW,nMT],3,1,wf8(:,80))
  call Hloop_AV_Q(ntryL,G0H32(1),ex5(:),G0H16(1),m3h2x16(:,416),heltab2x32(:,:,790))
  call Hloop_A_Q(ntryL,G0H16(1),16,nMT,G1H16(42),n2h16(416))
  Gcoeff(:)%j = (-(c(1)*M(4,:)%j)) * den(45)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(791),h0tab(:,791),[16,4,11],[nMB,0,nMB],3,1,wf8(:,79))
  call Hloop_AV_Q(ntryL,G0H32(1),ex5(:),G0H16(1),m3h2x16(:,417),heltab2x32(:,:,791))
  call Hloop_A_Q(ntryL,G0H16(1),16,nMB,G1H16(43),n2h16(417))
  Gcoeff(:)%j = (-(c(5)*M(4,:)%j)) * den(45)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(792),h0tab(:,792),[16,4,11],[nMB,nMZ,nMB],3,1,wf8(:,79))
  call Hloop_AV_Q(ntryL,G0H32(1),ex5(:),G0H16(1),m3h2x16(:,418),heltab2x32(:,:,792))
  call Hloop_A_Q(ntryL,G0H16(1),16,nMB,G1H16(44),n2h16(418))
  Gcoeff(:)%j = (-(c(61)*M(4,:)%j)) * den(45)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(793),h0tab(:,793),[16,4,11],[nMT,nMW,nMT],3,1,wf8(:,79))
  call Hloop_AV_Q(ntryL,G0H32(1),ex5(:),G0H16(1),m3h2x16(:,419),heltab2x32(:,:,793))
  call Hloop_A_Q(ntryL,G0H16(1),16,nMT,G1H16(45),n2h16(419))
  Gcoeff(:)%j = (c(4)*M(4,:)%j) * den(43)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(794),h0tab(:,794),[16,4,11],[nMB,0,nMB],3,1,wf8(:,80))
  call Hloop_AV_Q(ntryL,G0H32(1),ex5(:),G0H16(1),m3h2x16(:,420),heltab2x32(:,:,794))
  call Hloop_A_Q(ntryL,G0H16(1),16,nMB,G1H16(46),n2h16(420))
  Gcoeff(:)%j = (c(7)*M(4,:)%j) * den(43)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(795),h0tab(:,795),[16,4,11],[nMB,nMZ,nMB],3,1,wf8(:,80))
  call Hloop_AV_Q(ntryL,G0H32(1),ex5(:),G0H16(1),m3h2x16(:,421),heltab2x32(:,:,795))
  call Hloop_A_Q(ntryL,G0H16(1),16,nMB,G1H16(47),n2h16(421))
  Gcoeff(:)%j = (c(65)*M(4,:)%j) * den(43)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(796),h0tab(:,796),[16,4,11],[nMT,nMW,nMT],3,1,wf8(:,80))
  call Hloop_AV_Q(ntryL,G0H32(1),ex5(:),G0H16(1),m3h2x16(:,422),heltab2x32(:,:,796))
  call Hloop_A_Q(ntryL,G0H16(1),16,nMT,G1H16(48),n2h16(422))
  Gcoeff(:)%j = (c(24)*M(3,:)%j) * den(14)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(797),h0tab(:,797),[17,6,8],[nMT,nMB,nMH],3,2,wf4(:,11),wf4(:,10))
  call Hloop_SQ_A(ntryL,G0H32(1),wf4(:,11),G0H8(102),ngH,m3h4x8(:,375),heltab2x32(:,:,797))
  call Hloop_Q_A(ntryL,G0H8(102),17,nMT,G1H8(49),n2h8(185))
  Gcoeff(:)%j = (c(24)*M(3,:)%j) * den(14)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(798),h0tab(:,798),[17,6,8],[nMT,nMB,nMZ],3,2,wf4(:,11),wf4(:,10))
  call Hloop_SQ_A(ntryL,G0H32(1),wf4(:,11),G0H8(103),ngX,m3h4x8(:,376),heltab2x32(:,:,798))
  call Hloop_Q_A(ntryL,G0H8(103),17,nMT,G1H8(50),n2h8(186))
  Gcoeff(:)%j = (c(26)*M(3,:)%j) * den(14)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(799),h0tab(:,799),[17,6,8],[nMH,nMW,nMT],3,2,wf4(:,11),wf4(:,10))
  call Hloop_AQ_S(ntryL,G0H32(1),wf4(:,11),G0H8(104),ngH,m3h4x8(:,377),heltab2x32(:,:,799))
  Gcoeff(:)%j = (c(22)*M(3,:)%j) * den(14)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(800),h0tab(:,800),[17,6,8],[nMW,nMH,nMB],3,2,wf4(:,11),wf4(:,10))
  call Hloop_AQ_S(ntryL,G0H32(1),wf4(:,11),G0H8(105),ngPbt,m3h4x8(:,378),heltab2x32(:,:,800))
  Gcoeff(:)%j = (c(75)*M(3,:)%j) * den(14)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(801),h0tab(:,801),[17,6,8],[nMT,nMB,0],3,2,wf4(:,11),wf4(:,10))
  call Hloop_VQ_A(ntryL,G0H32(1),wf4(:,11),G0H8(106),m3h4x8(:,379),heltab2x32(:,:,801))
  call Hloop_Q_A(ntryL,G0H8(106),17,nMT,G1H8(51),n2h8(187))
  Gcoeff(:)%j = (-(c(79)*M(3,:)%j)) * den(14)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(802),h0tab(:,802),[17,6,8],[nMT,nMB,nMZ],3,2,wf4(:,11),wf4(:,10))
  call Hloop_ZQ_A(ntryL,G0H32(1),wf4(:,11),G0H8(107),ngZu,m3h4x8(:,380),heltab2x32(:,:,802))
  call Hloop_Q_A(ntryL,G0H8(107),17,nMT,G1H8(52),n2h8(188))
  Gcoeff(:)%j = (-(c(78)*M(3,:)%j)) * den(14)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(803),h0tab(:,803),[17,6,8],[0,nMW,nMT],3,2,wf4(:,11),wf4(:,10))
  call Hloop_AQ_V(ntryL,G0H32(1),wf4(:,11),G0H8(108),m3h4x8(:,381),heltab2x32(:,:,803))
  Gcoeff(:)%j = (c(104)*M(3,:)%j) * den(14)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(804),h0tab(:,804),[17,6,8],[nMZ,nMW,nMT],3,2,wf4(:,11),wf4(:,10))
  call Hloop_AQ_Z(ntryL,G0H32(1),wf4(:,11),G0H8(109),ngZu,m3h4x8(:,382),heltab2x32(:,:,804))
  Gcoeff(:)%j = (c(39)*M(3,:)%j) * den(14)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(805),h0tab(:,805),[17,6,8],[nMW,nMH,nMB],3,2,wf4(:,11),wf4(:,10))
  call Hloop_AQ_W(ntryL,G0H32(1),wf4(:,11),G0H8(110),m3h4x8(:,383),heltab2x32(:,:,805))
  Gcoeff(:)%j = (c(39)*M(3,:)%j) * den(14)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(806),h0tab(:,806),[17,6,8],[nMW,nMZ,nMB],3,2,wf4(:,11),wf4(:,10))
  call Hloop_AQ_W(ntryL,G0H32(1),wf4(:,11),G0H8(111),m3h4x8(:,384),heltab2x32(:,:,806))
  Gcoeff(:)%j = (c(76)*M(3,:)%j) * den(14)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(807),h0tab(:,807),[17,6,8],[nMW,0,nMB],3,2,wf4(:,11),wf4(:,10))
  call Hloop_AQ_S(ntryL,G0H32(1),wf4(:,11),G0H8(112),ngPbt,m3h4x8(:,385),heltab2x32(:,:,807))
  Gcoeff(:)%j = (c(104)*M(3,:)%j) * den(14)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(808),h0tab(:,808),[17,6,8],[nMW,nMZ,nMB],3,2,wf4(:,11),wf4(:,10))
  call Hloop_AQ_S(ntryL,G0H32(1),wf4(:,11),G0H8(113),ngPbt,m3h4x8(:,386),heltab2x32(:,:,808))
  Gcoeff(:)%j = (c(42)*M(3,:)%j) * den(14)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(809),h0tab(:,809),[17,6,8],[nMH,nMW,nMT],3,2,wf4(:,11),wf4(:,10))
  call Hloop_AQ_S(ntryL,G0H32(1),wf4(:,11),G0H8(114),ngH,m3h4x8(:,387),heltab2x32(:,:,809))
  Gcoeff(:)%j = (-(c(42)*M(3,:)%j)) * den(14)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(810),h0tab(:,810),[17,6,8],[nMZ,nMW,nMT],3,2,wf4(:,11),wf4(:,10))
  call Hloop_AQ_S(ntryL,G0H32(1),wf4(:,11),G0H8(115),ngX,m3h4x8(:,388),heltab2x32(:,:,810))
  Gcoeff(:)%j = (-(c(64)*M(3,:)%j)) * den(14)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(811),h0tab(:,811),[17,6,8],[0,nMW,nMT],3,2,wf4(:,11),wf4(:,10))
  call Hloop_AQ_V(ntryL,G0H32(1),wf4(:,11),G0H8(116),m3h4x8(:,389),heltab2x32(:,:,811))
  Gcoeff(:)%j = (c(62)*M(3,:)%j) * den(14)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(812),h0tab(:,812),[17,6,8],[nMW,0,nMB],3,2,wf4(:,11),wf4(:,10))
  call Hloop_AQ_W(ntryL,G0H32(1),wf4(:,11),G0H8(117),m3h4x8(:,390),heltab2x32(:,:,812))
  Gcoeff(:)%j = (c(92)*M(3,:)%j) * den(14)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(813),h0tab(:,813),[17,6,8],[nMZ,nMW,nMT],3,2,wf4(:,11),wf4(:,10))
  call Hloop_AQ_Z(ntryL,G0H32(1),wf4(:,11),G0H8(118),ngZu,m3h4x8(:,391),heltab2x32(:,:,813))
  Gcoeff(:)%j = (c(92)*M(3,:)%j) * den(14)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(814),h0tab(:,814),[17,6,8],[nMW,nMZ,nMB],3,2,wf4(:,11),wf4(:,10))
  call Hloop_AQ_W(ntryL,G0H32(1),wf4(:,11),G0H8(119),m3h4x8(:,392),heltab2x32(:,:,814))
  Gcoeff(:)%j = (c(44)*M(3,:)%j) * den(14)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(815),h0tab(:,815),[17,6,8],[nMT,nMB,nMH],3,2,wf4(:,11),wf4(:,12))
  call Hloop_SQ_A(ntryL,G0H32(1),wf4(:,11),G0H8(120),ngH,m3h4x8(:,393),heltab2x32(:,:,815))
  call Hloop_Q_A(ntryL,G0H8(120),17,nMT,G1H8(53),n2h8(189))
  Gcoeff(:)%j = (c(44)*M(3,:)%j) * den(14)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(816),h0tab(:,816),[17,6,8],[nMT,nMB,nMZ],3,2,wf4(:,11),wf4(:,12))
  call Hloop_SQ_A(ntryL,G0H32(1),wf4(:,11),G0H8(121),ngX,m3h4x8(:,394),heltab2x32(:,:,816))
  call Hloop_Q_A(ntryL,G0H8(121),17,nMT,G1H8(54),n2h8(190))
  Gcoeff(:)%j = (c(42)*M(3,:)%j) * den(14)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(817),h0tab(:,817),[17,6,8],[nMH,nMW,nMT],3,2,wf4(:,11),wf4(:,12))
  call Hloop_AQ_S(ntryL,G0H32(1),wf4(:,11),G0H8(122),ngH,m3h4x8(:,395),heltab2x32(:,:,817))
  Gcoeff(:)%j = (c(39)*M(3,:)%j) * den(14)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(818),h0tab(:,818),[17,6,8],[nMW,nMH,nMB],3,2,wf4(:,11),wf4(:,12))
  call Hloop_AQ_S(ntryL,G0H32(1),wf4(:,11),G0H8(123),ngPbt,m3h4x8(:,396),heltab2x32(:,:,818))
  Gcoeff(:)%j = (c(42)*M(3,:)%j) * den(14)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(819),h0tab(:,819),[17,6,8],[nMZ,nMW,nMT],3,2,wf4(:,11),wf4(:,12))
  call Hloop_AQ_S(ntryL,G0H32(1),wf4(:,11),G0H8(124),ngX,m3h4x8(:,397),heltab2x32(:,:,819))
  Gcoeff(:)%j = (-(c(39)*M(3,:)%j)) * den(14)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(820),h0tab(:,820),[17,6,8],[nMW,nMZ,nMB],3,2,wf4(:,11),wf4(:,12))
  call Hloop_AQ_S(ntryL,G0H32(1),wf4(:,11),G0H8(125),ngPbt,m3h4x8(:,398),heltab2x32(:,:,820))
  Gcoeff(:)%j = (c(61)*M(3,:)%j) * den(14)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(821),h0tab(:,821),[17,6,8],[nMT,nMB,0],3,2,wf4(:,11),wf4(:,12))
  call Hloop_VQ_A(ntryL,G0H32(1),wf4(:,11),G0H8(126),m3h4x8(:,399),heltab2x32(:,:,821))
  call Hloop_Q_A(ntryL,G0H8(126),17,nMT,G1H8(55),n2h8(191))
  Gcoeff(:)%j = (-(c(65)*M(3,:)%j)) * den(14)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(822),h0tab(:,822),[17,6,8],[nMT,nMB,nMZ],3,2,wf4(:,11),wf4(:,12))
  call Hloop_ZQ_A(ntryL,G0H32(1),wf4(:,11),G0H8(127),ngZu,m3h4x8(:,400),heltab2x32(:,:,822))
  call Hloop_Q_A(ntryL,G0H8(127),17,nMT,G1H8(56),n2h8(192))
  Gcoeff(:)%j = (c(64)*M(3,:)%j) * den(14)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(823),h0tab(:,823),[17,6,8],[0,nMW,nMT],3,2,wf4(:,11),wf4(:,12))
  call Hloop_AQ_V(ntryL,G0H32(1),wf4(:,11),G0H8(128),m3h4x8(:,401),heltab2x32(:,:,823))
  Gcoeff(:)%j = (-(c(92)*M(3,:)%j)) * den(14)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(824),h0tab(:,824),[17,6,8],[nMZ,nMW,nMT],3,2,wf4(:,11),wf4(:,12))
  call Hloop_AQ_Z(ntryL,G0H32(1),wf4(:,11),G0H8(129),ngZu,m3h4x8(:,402),heltab2x32(:,:,824))
  Gcoeff(:)%j = (c(14)*M(3,:)%j) * den(14)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(825),h0tab(:,825),[17,6,8],[nMW,nMH,nMB],3,2,wf4(:,11),wf4(:,12))
  call Hloop_AQ_W(ntryL,G0H32(1),wf4(:,11),G0H8(130),m3h4x8(:,403),heltab2x32(:,:,825))
  Gcoeff(:)%j = (-(c(62)*M(3,:)%j)) * den(14)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(826),h0tab(:,826),[17,6,8],[nMW,0,nMB],3,2,wf4(:,11),wf4(:,12))
  call Hloop_AQ_S(ntryL,G0H32(1),wf4(:,11),G0H8(131),ngPbt,m3h4x8(:,404),heltab2x32(:,:,826))
  Gcoeff(:)%j = (-(c(92)*M(3,:)%j)) * den(14)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(827),h0tab(:,827),[17,6,8],[nMW,nMZ,nMB],3,2,wf4(:,11),wf4(:,12))
  call Hloop_AQ_S(ntryL,G0H32(1),wf4(:,11),G0H8(132),ngPbt,m3h4x8(:,405),heltab2x32(:,:,827))
  Gcoeff(:)%j = (c(15)*M(3,:)%j) * den(14)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(828),h0tab(:,828),[17,6,8],[nMH,nMW,nMT],3,2,wf4(:,11),wf4(:,12))
  call Hloop_AQ_S(ntryL,G0H32(1),wf4(:,11),G0H8(133),ngH,m3h4x8(:,406),heltab2x32(:,:,828))
  Gcoeff(:)%j = (-(c(64)*M(3,:)%j)) * den(14)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(829),h0tab(:,829),[17,6,8],[0,nMW,nMT],3,2,wf4(:,11),wf4(:,12))
  call Hloop_AQ_V(ntryL,G0H32(1),wf4(:,11),G0H8(134),m3h4x8(:,407),heltab2x32(:,:,829))
  Gcoeff(:)%j = (c(62)*M(3,:)%j) * den(14)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(830),h0tab(:,830),[17,6,8],[nMW,0,nMB],3,2,wf4(:,11),wf4(:,12))
  call Hloop_AQ_W(ntryL,G0H32(1),wf4(:,11),G0H8(135),m3h4x8(:,408),heltab2x32(:,:,830))
  Gcoeff(:)%j = (-(c(48)*M(3,:)%j)) * den(14)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(831),h0tab(:,831),[17,6,8],[nMZ,nMW,nMT],3,2,wf4(:,11),wf4(:,12))
  call Hloop_AQ_Z(ntryL,G0H32(1),wf4(:,11),G0H8(136),ngZu,m3h4x8(:,409),heltab2x32(:,:,831))
  Gcoeff(:)%j = (-(c(48)*M(3,:)%j)) * den(14)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(832),h0tab(:,832),[17,6,8],[nMW,nMZ,nMB],3,2,wf4(:,11),wf4(:,12))
  call Hloop_AQ_W(ntryL,G0H32(1),wf4(:,11),G0H8(137),m3h4x8(:,410),heltab2x32(:,:,832))
  Gcoeff(:)%j = (c(24)*M(3,:)%j) * den(15)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(833),h0tab(:,833),[24,1,6],[nMH,nMT,nMB],3,2,wf4(:,8),wf4(:,10))
  call Hloop_QA_S(ntryL,G0H32(1),wf4(:,8),G0H8(1),ngH,m3h4x8(:,411),heltab2x32(:,:,833))
  Gcoeff(:)%j = (c(24)*M(3,:)%j) * den(15)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(834),h0tab(:,834),[24,1,6],[nMZ,nMT,nMB],3,2,wf4(:,8),wf4(:,10))
  call Hloop_QA_S(ntryL,G0H32(1),wf4(:,8),G0H8(2),ngX,m3h4x8(:,412),heltab2x32(:,:,834))
  Gcoeff(:)%j = (c(26)*M(3,:)%j) * den(15)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(835),h0tab(:,835),[24,1,6],[nMT,nMH,nMW],3,2,wf4(:,8),wf4(:,10))
  call Hloop_SA_Q(ntryL,G0H32(1),wf4(:,8),G0H8(3),ngPbt,m3h4x8(:,413),heltab2x32(:,:,835))
  call Hloop_A_Q(ntryL,G0H8(3),24,nMT,G1H8(57),n2h8(193))
  Gcoeff(:)%j = (c(22)*M(3,:)%j) * den(15)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(836),h0tab(:,836),[24,1,6],[nMB,nMW,nMH],3,2,wf4(:,8),wf4(:,10))
  call Hloop_SA_Q(ntryL,G0H32(1),wf4(:,8),G0H8(4),ngH,m3h4x8(:,414),heltab2x32(:,:,836))
  call Hloop_A_Q(ntryL,G0H8(4),24,nMB,G1H8(58),n2h8(194))
  Gcoeff(:)%j = (c(75)*M(3,:)%j) * den(15)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(837),h0tab(:,837),[24,1,6],[0,nMT,nMB],3,2,wf4(:,8),wf4(:,10))
  call Hloop_QA_V(ntryL,G0H32(1),wf4(:,8),G0H8(5),m3h4x8(:,415),heltab2x32(:,:,837))
  Gcoeff(:)%j = (-(c(79)*M(3,:)%j)) * den(15)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(838),h0tab(:,838),[24,1,6],[nMZ,nMT,nMB],3,2,wf4(:,8),wf4(:,10))
  call Hloop_QA_Z(ntryL,G0H32(1),wf4(:,8),G0H8(11),ngZd,m3h4x8(:,416),heltab2x32(:,:,838))
  Gcoeff(:)%j = (c(76)*M(3,:)%j) * den(15)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(839),h0tab(:,839),[24,1,6],[nMB,nMW,0],3,2,wf4(:,8),wf4(:,10))
  call Hloop_VA_Q(ntryL,G0H32(1),wf4(:,8),G0H8(12),m3h4x8(:,417),heltab2x32(:,:,839))
  call Hloop_A_Q(ntryL,G0H8(12),24,nMB,G1H8(59),n2h8(195))
  Gcoeff(:)%j = (c(104)*M(3,:)%j) * den(15)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(840),h0tab(:,840),[24,1,6],[nMB,nMW,nMZ],3,2,wf4(:,8),wf4(:,10))
  call Hloop_ZA_Q(ntryL,G0H32(1),wf4(:,8),G0H8(13),ngZd,m3h4x8(:,418),heltab2x32(:,:,840))
  call Hloop_A_Q(ntryL,G0H8(13),24,nMB,G1H8(60),n2h8(196))
  Gcoeff(:)%j = (c(42)*M(3,:)%j) * den(15)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(841),h0tab(:,841),[24,1,6],[nMT,nMH,nMW],3,2,wf4(:,8),wf4(:,10))
  call Hloop_WA_Q(ntryL,G0H32(1),wf4(:,8),G0H8(14),m3h4x8(:,419),heltab2x32(:,:,841))
  call Hloop_A_Q(ntryL,G0H8(14),24,nMT,G1H8(61),n2h8(197))
  Gcoeff(:)%j = (-(c(42)*M(3,:)%j)) * den(15)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(842),h0tab(:,842),[24,1,6],[nMT,nMZ,nMW],3,2,wf4(:,8),wf4(:,10))
  call Hloop_WA_Q(ntryL,G0H32(1),wf4(:,8),G0H8(15),m3h4x8(:,420),heltab2x32(:,:,842))
  call Hloop_A_Q(ntryL,G0H8(15),24,nMT,G1H8(62),n2h8(198))
  Gcoeff(:)%j = (-(c(78)*M(3,:)%j)) * den(15)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(843),h0tab(:,843),[24,1,6],[nMT,0,nMW],3,2,wf4(:,8),wf4(:,10))
  call Hloop_SA_Q(ntryL,G0H32(1),wf4(:,8),G0H8(16),ngPbt,m3h4x8(:,421),heltab2x32(:,:,843))
  call Hloop_A_Q(ntryL,G0H8(16),24,nMT,G1H8(63),n2h8(199))
  Gcoeff(:)%j = (c(104)*M(3,:)%j) * den(15)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(844),h0tab(:,844),[24,1,6],[nMT,nMZ,nMW],3,2,wf4(:,8),wf4(:,10))
  call Hloop_SA_Q(ntryL,G0H32(1),wf4(:,8),G0H8(27),ngPbt,m3h4x8(:,422),heltab2x32(:,:,844))
  call Hloop_A_Q(ntryL,G0H8(27),24,nMT,G1H8(64),n2h8(200))
  Gcoeff(:)%j = (c(39)*M(3,:)%j) * den(15)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(845),h0tab(:,845),[24,1,6],[nMB,nMW,nMH],3,2,wf4(:,8),wf4(:,10))
  call Hloop_SA_Q(ntryL,G0H32(1),wf4(:,8),G0H8(28),ngH,m3h4x8(:,423),heltab2x32(:,:,845))
  call Hloop_A_Q(ntryL,G0H8(28),24,nMB,G1H8(65),n2h8(201))
  Gcoeff(:)%j = (c(39)*M(3,:)%j) * den(15)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(846),h0tab(:,846),[24,1,6],[nMB,nMW,nMZ],3,2,wf4(:,8),wf4(:,10))
  call Hloop_SA_Q(ntryL,G0H32(1),wf4(:,8),G0H8(29),ngX,m3h4x8(:,424),heltab2x32(:,:,846))
  call Hloop_A_Q(ntryL,G0H8(29),24,nMB,G1H8(66),n2h8(202))
  Gcoeff(:)%j = (-(c(64)*M(3,:)%j)) * den(15)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(847),h0tab(:,847),[24,1,6],[nMT,0,nMW],3,2,wf4(:,8),wf4(:,10))
  call Hloop_WA_Q(ntryL,G0H32(1),wf4(:,8),G0H8(30),m3h4x8(:,425),heltab2x32(:,:,847))
  call Hloop_A_Q(ntryL,G0H8(30),24,nMT,G1H8(67),n2h8(203))
  Gcoeff(:)%j = (c(62)*M(3,:)%j) * den(15)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(848),h0tab(:,848),[24,1,6],[nMB,nMW,0],3,2,wf4(:,8),wf4(:,10))
  call Hloop_VA_Q(ntryL,G0H32(1),wf4(:,8),G0H8(31),m3h4x8(:,426),heltab2x32(:,:,848))
  call Hloop_A_Q(ntryL,G0H8(31),24,nMB,G1H8(68),n2h8(204))
  Gcoeff(:)%j = (c(92)*M(3,:)%j) * den(15)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(849),h0tab(:,849),[24,1,6],[nMT,nMZ,nMW],3,2,wf4(:,8),wf4(:,10))
  call Hloop_WA_Q(ntryL,G0H32(1),wf4(:,8),G0H8(32),m3h4x8(:,427),heltab2x32(:,:,849))
  call Hloop_A_Q(ntryL,G0H8(32),24,nMT,G1H8(69),n2h8(205))
  Gcoeff(:)%j = (c(92)*M(3,:)%j) * den(15)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(850),h0tab(:,850),[24,1,6],[nMB,nMW,nMZ],3,2,wf4(:,8),wf4(:,10))
  call Hloop_ZA_Q(ntryL,G0H32(1),wf4(:,8),G0H8(37),ngZd,m3h4x8(:,428),heltab2x32(:,:,850))
  call Hloop_A_Q(ntryL,G0H8(37),24,nMB,G1H8(70),n2h8(206))
  Gcoeff(:)%j = (c(44)*M(3,:)%j) * den(15)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(851),h0tab(:,851),[24,1,6],[nMH,nMT,nMB],3,2,wf4(:,8),wf4(:,12))
  call Hloop_QA_S(ntryL,G0H32(1),wf4(:,8),G0H8(38),ngH,m3h4x8(:,429),heltab2x32(:,:,851))
  Gcoeff(:)%j = (c(44)*M(3,:)%j) * den(15)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(852),h0tab(:,852),[24,1,6],[nMZ,nMT,nMB],3,2,wf4(:,8),wf4(:,12))
  call Hloop_QA_S(ntryL,G0H32(1),wf4(:,8),G0H8(39),ngX,m3h4x8(:,430),heltab2x32(:,:,852))
  Gcoeff(:)%j = (c(42)*M(3,:)%j) * den(15)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(853),h0tab(:,853),[24,1,6],[nMT,nMH,nMW],3,2,wf4(:,8),wf4(:,12))
  call Hloop_SA_Q(ntryL,G0H32(1),wf4(:,8),G0H8(40),ngPbt,m3h4x8(:,431),heltab2x32(:,:,853))
  call Hloop_A_Q(ntryL,G0H8(40),24,nMT,G1H8(71),n2h8(207))
  Gcoeff(:)%j = (c(39)*M(3,:)%j) * den(15)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(854),h0tab(:,854),[24,1,6],[nMB,nMW,nMH],3,2,wf4(:,8),wf4(:,12))
  call Hloop_SA_Q(ntryL,G0H32(1),wf4(:,8),G0H8(41),ngH,m3h4x8(:,432),heltab2x32(:,:,854))
  call Hloop_A_Q(ntryL,G0H8(41),24,nMB,G1H8(72),n2h8(208))
  Gcoeff(:)%j = (c(42)*M(3,:)%j) * den(15)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(855),h0tab(:,855),[24,1,6],[nMT,nMZ,nMW],3,2,wf4(:,8),wf4(:,12))
  call Hloop_SA_Q(ntryL,G0H32(1),wf4(:,8),G0H8(42),ngPbt,m3h4x8(:,433),heltab2x32(:,:,855))
  call Hloop_A_Q(ntryL,G0H8(42),24,nMT,G1H8(73),n2h8(209))
  Gcoeff(:)%j = (-(c(39)*M(3,:)%j)) * den(15)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(856),h0tab(:,856),[24,1,6],[nMB,nMW,nMZ],3,2,wf4(:,8),wf4(:,12))
  call Hloop_SA_Q(ntryL,G0H32(1),wf4(:,8),G0H8(51),ngX,m3h4x8(:,434),heltab2x32(:,:,856))
  call Hloop_A_Q(ntryL,G0H8(51),24,nMB,G1H8(74),n2h8(210))
  Gcoeff(:)%j = (c(61)*M(3,:)%j) * den(15)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(857),h0tab(:,857),[24,1,6],[0,nMT,nMB],3,2,wf4(:,8),wf4(:,12))
  call Hloop_QA_V(ntryL,G0H32(1),wf4(:,8),G0H8(52),m3h4x8(:,435),heltab2x32(:,:,857))
  Gcoeff(:)%j = (-(c(65)*M(3,:)%j)) * den(15)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(858),h0tab(:,858),[24,1,6],[nMZ,nMT,nMB],3,2,wf4(:,8),wf4(:,12))
  call Hloop_QA_Z(ntryL,G0H32(1),wf4(:,8),G0H8(53),ngZd,m3h4x8(:,436),heltab2x32(:,:,858))
  Gcoeff(:)%j = (-(c(62)*M(3,:)%j)) * den(15)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(859),h0tab(:,859),[24,1,6],[nMB,nMW,0],3,2,wf4(:,8),wf4(:,12))
  call Hloop_VA_Q(ntryL,G0H32(1),wf4(:,8),G0H8(54),m3h4x8(:,437),heltab2x32(:,:,859))
  call Hloop_A_Q(ntryL,G0H8(54),24,nMB,G1H8(75),n2h8(211))
  Gcoeff(:)%j = (-(c(92)*M(3,:)%j)) * den(15)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(860),h0tab(:,860),[24,1,6],[nMB,nMW,nMZ],3,2,wf4(:,8),wf4(:,12))
  call Hloop_ZA_Q(ntryL,G0H32(1),wf4(:,8),G0H8(55),ngZd,m3h4x8(:,438),heltab2x32(:,:,860))
  call Hloop_A_Q(ntryL,G0H8(55),24,nMB,G1H8(76),n2h8(212))
  Gcoeff(:)%j = (c(15)*M(3,:)%j) * den(15)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(861),h0tab(:,861),[24,1,6],[nMT,nMH,nMW],3,2,wf4(:,8),wf4(:,12))
  call Hloop_WA_Q(ntryL,G0H32(1),wf4(:,8),G0H8(56),m3h4x8(:,439),heltab2x32(:,:,861))
  call Hloop_A_Q(ntryL,G0H8(56),24,nMT,G1H8(77),n2h8(213))
  Gcoeff(:)%j = (c(64)*M(3,:)%j) * den(15)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(862),h0tab(:,862),[24,1,6],[nMT,0,nMW],3,2,wf4(:,8),wf4(:,12))
  call Hloop_SA_Q(ntryL,G0H32(1),wf4(:,8),G0H8(62),ngPbt,m3h4x8(:,440),heltab2x32(:,:,862))
  call Hloop_A_Q(ntryL,G0H8(62),24,nMT,G1H8(78),n2h8(214))
  Gcoeff(:)%j = (-(c(92)*M(3,:)%j)) * den(15)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(863),h0tab(:,863),[24,1,6],[nMT,nMZ,nMW],3,2,wf4(:,8),wf4(:,12))
  call Hloop_SA_Q(ntryL,G0H32(1),wf4(:,8),G0H8(63),ngPbt,m3h4x8(:,441),heltab2x32(:,:,863))
  call Hloop_A_Q(ntryL,G0H8(63),24,nMT,G1H8(79),n2h8(215))
  Gcoeff(:)%j = (c(14)*M(3,:)%j) * den(15)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(864),h0tab(:,864),[24,1,6],[nMB,nMW,nMH],3,2,wf4(:,8),wf4(:,12))
  call Hloop_SA_Q(ntryL,G0H32(1),wf4(:,8),G0H8(64),ngH,m3h4x8(:,442),heltab2x32(:,:,864))
  call Hloop_A_Q(ntryL,G0H8(64),24,nMB,G1H8(80),n2h8(216))
  Gcoeff(:)%j = (-(c(64)*M(3,:)%j)) * den(15)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(865),h0tab(:,865),[24,1,6],[nMT,0,nMW],3,2,wf4(:,8),wf4(:,12))
  call Hloop_WA_Q(ntryL,G0H32(1),wf4(:,8),G0H8(65),m3h4x8(:,443),heltab2x32(:,:,865))
  call Hloop_A_Q(ntryL,G0H8(65),24,nMT,G1H8(81),n2h8(217))
  Gcoeff(:)%j = (c(62)*M(3,:)%j) * den(15)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(866),h0tab(:,866),[24,1,6],[nMB,nMW,0],3,2,wf4(:,8),wf4(:,12))
  call Hloop_VA_Q(ntryL,G0H32(1),wf4(:,8),G0H8(66),m3h4x8(:,444),heltab2x32(:,:,866))
  call Hloop_A_Q(ntryL,G0H8(66),24,nMB,G1H8(82),n2h8(218))
  Gcoeff(:)%j = (-(c(48)*M(3,:)%j)) * den(15)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(867),h0tab(:,867),[24,1,6],[nMT,nMZ,nMW],3,2,wf4(:,8),wf4(:,12))
  call Hloop_WA_Q(ntryL,G0H32(1),wf4(:,8),G0H8(67),m3h4x8(:,445),heltab2x32(:,:,867))
  call Hloop_A_Q(ntryL,G0H8(67),24,nMT,G1H8(83),n2h8(219))
  Gcoeff(:)%j = (-(c(48)*M(3,:)%j)) * den(15)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(868),h0tab(:,868),[24,1,6],[nMB,nMW,nMZ],3,2,wf4(:,8),wf4(:,12))
  call Hloop_ZA_Q(ntryL,G0H32(1),wf4(:,8),G0H8(78),ngZd,m3h4x8(:,446),heltab2x32(:,:,868))
  call Hloop_A_Q(ntryL,G0H8(78),24,nMB,G1H8(84),n2h8(220))
  Gcoeff(:)%j = (c(21)*M(3,:)%j) * den(70)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(869),h0tab(:,869),[16,7,8],[nMB,nMH,nMB],3,1,wf8(:,95))
  call Hloop_AV_Q(ntryL,G0H32(1),ex5(:),G0H16(1),m3h2x16(:,423),heltab2x32(:,:,869))
  call Hloop_A_Q(ntryL,G0H16(1),16,nMB,G1H16(49),n2h16(423))
  Gcoeff(:)%j = (-(c(21)*M(3,:)%j)) * den(70)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(870),h0tab(:,870),[16,7,8],[nMB,nMZ,nMB],3,1,wf8(:,95))
  call Hloop_AV_Q(ntryL,G0H32(1),ex5(:),G0H16(1),m3h2x16(:,424),heltab2x32(:,:,870))
  call Hloop_A_Q(ntryL,G0H16(1),16,nMB,G1H16(50),n2h16(424))
  Gcoeff(:)%j = (-(c(20)*M(3,:)%j)) * den(70)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(871),h0tab(:,871),[16,7,8],[nMT,nMW,nMT],3,1,wf8(:,95))
  call Hloop_AV_Q(ntryL,G0H32(1),ex5(:),G0H16(1),m3h2x16(:,425),heltab2x32(:,:,871))
  call Hloop_A_Q(ntryL,G0H16(1),16,nMT,G1H16(51),n2h16(425))
  Gcoeff(:)%j = (-(c(74)*M(3,:)%j)) * den(70)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(872),h0tab(:,872),[16,7,8],[nMB,0,nMB],3,1,wf8(:,95))
  call Hloop_AV_Q(ntryL,G0H32(1),ex5(:),G0H16(1),m3h2x16(:,426),heltab2x32(:,:,872))
  call Hloop_A_Q(ntryL,G0H16(1),16,nMB,G1H16(52),n2h16(426))
  Gcoeff(:)%j = (-(c(79)*M(3,:)%j)) * den(70)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(873),h0tab(:,873),[16,7,8],[nMB,nMZ,nMB],3,1,wf8(:,95))
  call Hloop_AV_Q(ntryL,G0H32(1),ex5(:),G0H16(1),m3h2x16(:,427),heltab2x32(:,:,873))
  call Hloop_A_Q(ntryL,G0H16(1),16,nMB,G1H16(53),n2h16(427))
  Gcoeff(:)%j = (-(c(38)*M(3,:)%j)) * den(70)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(874),h0tab(:,874),[16,7,8],[nMT,nMW,nMT],3,1,wf8(:,95))
  call Hloop_AV_Q(ntryL,G0H32(1),ex5(:),G0H16(1),m3h2x16(:,428),heltab2x32(:,:,874))
  call Hloop_A_Q(ntryL,G0H16(1),16,nMT,G1H16(54),n2h16(428))
  Gcoeff(:)%j = (c(40)*M(3,:)%j) * den(70)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(875),h0tab(:,875),[16,7,8],[nMB,nMH,nMB],3,1,wf8(:,96))
  call Hloop_AV_Q(ntryL,G0H32(1),ex5(:),G0H16(1),m3h2x16(:,429),heltab2x32(:,:,875))
  call Hloop_A_Q(ntryL,G0H16(1),16,nMB,G1H16(55),n2h16(429))
  Gcoeff(:)%j = (-(c(40)*M(3,:)%j)) * den(70)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(876),h0tab(:,876),[16,7,8],[nMB,nMZ,nMB],3,1,wf8(:,96))
  call Hloop_AV_Q(ntryL,G0H32(1),ex5(:),G0H16(1),m3h2x16(:,430),heltab2x32(:,:,876))
  call Hloop_A_Q(ntryL,G0H16(1),16,nMB,G1H16(56),n2h16(430))
  Gcoeff(:)%j = (-(c(38)*M(3,:)%j)) * den(70)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(877),h0tab(:,877),[16,7,8],[nMT,nMW,nMT],3,1,wf8(:,96))
  call Hloop_AV_Q(ntryL,G0H32(1),ex5(:),G0H16(1),m3h2x16(:,431),heltab2x32(:,:,877))
  call Hloop_A_Q(ntryL,G0H16(1),16,nMT,G1H16(57),n2h16(431))
  Gcoeff(:)%j = (-(c(60)*M(3,:)%j)) * den(70)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(878),h0tab(:,878),[16,7,8],[nMB,0,nMB],3,1,wf8(:,96))
  call Hloop_AV_Q(ntryL,G0H32(1),ex5(:),G0H16(1),m3h2x16(:,432),heltab2x32(:,:,878))
  call Hloop_A_Q(ntryL,G0H16(1),16,nMB,G1H16(58),n2h16(432))
  Gcoeff(:)%j = (-(c(65)*M(3,:)%j)) * den(70)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(879),h0tab(:,879),[16,7,8],[nMB,nMZ,nMB],3,1,wf8(:,96))
  call Hloop_AV_Q(ntryL,G0H32(1),ex5(:),G0H16(1),m3h2x16(:,433),heltab2x32(:,:,879))
  call Hloop_A_Q(ntryL,G0H16(1),16,nMB,G1H16(59),n2h16(433))
  Gcoeff(:)%j = (-(c(12)*M(3,:)%j)) * den(70)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(880),h0tab(:,880),[16,7,8],[nMT,nMW,nMT],3,1,wf8(:,96))
  call Hloop_AV_Q(ntryL,G0H32(1),ex5(:),G0H16(1),m3h2x16(:,434),heltab2x32(:,:,880))
  call Hloop_A_Q(ntryL,G0H16(1),16,nMT,G1H16(60),n2h16(434))
  Gcoeff(:)%j = (c(32)*M(3,:)%j) * den(63)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(881),h0tab(:,881),[16,1,14],[nMT,nMH,nMT],3,1,wf8(:,90))
  call Hloop_AV_Q(ntryL,G0H32(1),ex5(:),G0H16(1),m3h2x16(:,435),heltab2x32(:,:,881))
  call Hloop_A_Q(ntryL,G0H16(1),16,nMT,G1H16(61),n2h16(435))
  Gcoeff(:)%j = (-(c(32)*M(3,:)%j)) * den(63)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(882),h0tab(:,882),[16,1,14],[nMT,nMZ,nMT],3,1,wf8(:,90))
  call Hloop_AV_Q(ntryL,G0H32(1),ex5(:),G0H16(1),m3h2x16(:,436),heltab2x32(:,:,882))
  call Hloop_A_Q(ntryL,G0H16(1),16,nMT,G1H16(62),n2h16(436))
  Gcoeff(:)%j = (-(c(20)*M(3,:)%j)) * den(63)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(883),h0tab(:,883),[16,1,14],[nMB,nMW,nMB],3,1,wf8(:,90))
  call Hloop_AV_Q(ntryL,G0H32(1),ex5(:),G0H16(1),m3h2x16(:,437),heltab2x32(:,:,883))
  call Hloop_A_Q(ntryL,G0H16(1),16,nMB,G1H16(63),n2h16(437))
  Gcoeff(:)%j = (-(c(77)*M(3,:)%j)) * den(63)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(884),h0tab(:,884),[16,1,14],[nMT,0,nMT],3,1,wf8(:,90))
  call Hloop_AV_Q(ntryL,G0H32(1),ex5(:),G0H16(1),m3h2x16(:,438),heltab2x32(:,:,884))
  call Hloop_A_Q(ntryL,G0H16(1),16,nMT,G1H16(64),n2h16(438))
  Gcoeff(:)%j = (-(c(79)*M(3,:)%j)) * den(63)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(885),h0tab(:,885),[16,1,14],[nMT,nMZ,nMT],3,1,wf8(:,90))
  call Hloop_AV_Q(ntryL,G0H32(1),ex5(:),G0H16(1),m3h2x16(:,439),heltab2x32(:,:,885))
  call Hloop_A_Q(ntryL,G0H16(1),16,nMT,G1H16(65),n2h16(439))
  Gcoeff(:)%j = (-(c(38)*M(3,:)%j)) * den(63)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(886),h0tab(:,886),[16,1,14],[nMB,nMW,nMB],3,1,wf8(:,90))
  call Hloop_AV_Q(ntryL,G0H32(1),ex5(:),G0H16(1),m3h2x16(:,440),heltab2x32(:,:,886))
  call Hloop_A_Q(ntryL,G0H16(1),16,nMB,G1H16(66),n2h16(440))
  Gcoeff(:)%j = (c(46)*M(3,:)%j) * den(63)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(887),h0tab(:,887),[16,1,14],[nMT,nMH,nMT],3,1,wf8(:,92))
  call Hloop_AV_Q(ntryL,G0H32(1),ex5(:),G0H16(1),m3h2x16(:,441),heltab2x32(:,:,887))
  call Hloop_A_Q(ntryL,G0H16(1),16,nMT,G1H16(67),n2h16(441))
  Gcoeff(:)%j = (-(c(46)*M(3,:)%j)) * den(63)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(888),h0tab(:,888),[16,1,14],[nMT,nMZ,nMT],3,1,wf8(:,92))
  call Hloop_AV_Q(ntryL,G0H32(1),ex5(:),G0H16(1),m3h2x16(:,442),heltab2x32(:,:,888))
  call Hloop_A_Q(ntryL,G0H16(1),16,nMT,G1H16(68),n2h16(442))
  Gcoeff(:)%j = (-(c(38)*M(3,:)%j)) * den(63)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(889),h0tab(:,889),[16,1,14],[nMB,nMW,nMB],3,1,wf8(:,92))
  call Hloop_AV_Q(ntryL,G0H32(1),ex5(:),G0H16(1),m3h2x16(:,443),heltab2x32(:,:,889))
  call Hloop_A_Q(ntryL,G0H16(1),16,nMB,G1H16(69),n2h16(443))
  Gcoeff(:)%j = (-(c(63)*M(3,:)%j)) * den(63)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(890),h0tab(:,890),[16,1,14],[nMT,0,nMT],3,1,wf8(:,92))
  call Hloop_AV_Q(ntryL,G0H32(1),ex5(:),G0H16(1),m3h2x16(:,444),heltab2x32(:,:,890))
  call Hloop_A_Q(ntryL,G0H16(1),16,nMT,G1H16(70),n2h16(444))
  Gcoeff(:)%j = (-(c(65)*M(3,:)%j)) * den(63)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(891),h0tab(:,891),[16,1,14],[nMT,nMZ,nMT],3,1,wf8(:,92))
  call Hloop_AV_Q(ntryL,G0H32(1),ex5(:),G0H16(1),m3h2x16(:,445),heltab2x32(:,:,891))
  call Hloop_A_Q(ntryL,G0H16(1),16,nMT,G1H16(71),n2h16(445))
  Gcoeff(:)%j = (-(c(12)*M(3,:)%j)) * den(63)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(892),h0tab(:,892),[16,1,14],[nMB,nMW,nMB],3,1,wf8(:,92))
  call Hloop_AV_Q(ntryL,G0H32(1),ex5(:),G0H16(1),m3h2x16(:,446),heltab2x32(:,:,892))
  call Hloop_A_Q(ntryL,G0H16(1),16,nMB,G1H16(72),n2h16(446))
  Gcoeff(:)%j = (c(24)*M(2,:)%j) * den(18)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(893),h0tab(:,893),[18,4,9],[nMH,nMB,nMT],3,2,wf4(:,15),wf4(:,13))
  call Hloop_QA_S(ntryL,G0H32(1),wf4(:,15),G0H8(79),ngH,m3h4x8(:,447),heltab2x32(:,:,893))
  Gcoeff(:)%j = (c(24)*M(2,:)%j) * den(18)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(894),h0tab(:,894),[18,4,9],[nMZ,nMB,nMT],3,2,wf4(:,15),wf4(:,13))
  call Hloop_QA_S(ntryL,G0H32(1),wf4(:,15),G0H8(80),ngX,m3h4x8(:,448),heltab2x32(:,:,894))
  Gcoeff(:)%j = (c(26)*M(2,:)%j) * den(18)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(895),h0tab(:,895),[18,4,9],[nMT,nMW,nMH],3,2,wf4(:,15),wf4(:,13))
  call Hloop_SA_Q(ntryL,G0H32(1),wf4(:,15),G0H8(81),ngH,m3h4x8(:,449),heltab2x32(:,:,895))
  call Hloop_A_Q(ntryL,G0H8(81),18,nMT,G1H8(85),n2h8(221))
  Gcoeff(:)%j = (c(22)*M(2,:)%j) * den(18)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(896),h0tab(:,896),[18,4,9],[nMB,nMH,nMW],3,2,wf4(:,15),wf4(:,13))
  call Hloop_SA_Q(ntryL,G0H32(1),wf4(:,15),G0H8(82),ngPtb,m3h4x8(:,450),heltab2x32(:,:,896))
  call Hloop_A_Q(ntryL,G0H8(82),18,nMB,G1H8(86),n2h8(222))
  Gcoeff(:)%j = (c(75)*M(2,:)%j) * den(18)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(897),h0tab(:,897),[18,4,9],[0,nMB,nMT],3,2,wf4(:,15),wf4(:,13))
  call Hloop_QA_V(ntryL,G0H32(1),wf4(:,15),G0H8(83),m3h4x8(:,451),heltab2x32(:,:,897))
  Gcoeff(:)%j = (-(c(79)*M(2,:)%j)) * den(18)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(898),h0tab(:,898),[18,4,9],[nMZ,nMB,nMT],3,2,wf4(:,15),wf4(:,13))
  call Hloop_QA_Z(ntryL,G0H32(1),wf4(:,15),G0H8(88),ngZu,m3h4x8(:,452),heltab2x32(:,:,898))
  Gcoeff(:)%j = (-(c(78)*M(2,:)%j)) * den(18)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(899),h0tab(:,899),[18,4,9],[nMT,nMW,0],3,2,wf4(:,15),wf4(:,13))
  call Hloop_VA_Q(ntryL,G0H32(1),wf4(:,15),G0H8(89),m3h4x8(:,453),heltab2x32(:,:,899))
  call Hloop_A_Q(ntryL,G0H8(89),18,nMT,G1H8(87),n2h8(223))
  Gcoeff(:)%j = (c(104)*M(2,:)%j) * den(18)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(900),h0tab(:,900),[18,4,9],[nMT,nMW,nMZ],3,2,wf4(:,15),wf4(:,13))
  call Hloop_ZA_Q(ntryL,G0H32(1),wf4(:,15),G0H8(90),ngZu,m3h4x8(:,454),heltab2x32(:,:,900))
  call Hloop_A_Q(ntryL,G0H8(90),18,nMT,G1H8(88),n2h8(224))
  Gcoeff(:)%j = (c(39)*M(2,:)%j) * den(18)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(901),h0tab(:,901),[18,4,9],[nMB,nMH,nMW],3,2,wf4(:,15),wf4(:,13))
  call Hloop_WA_Q(ntryL,G0H32(1),wf4(:,15),G0H8(91),m3h4x8(:,455),heltab2x32(:,:,901))
  call Hloop_A_Q(ntryL,G0H8(91),18,nMB,G1H8(89),n2h8(225))
  Gcoeff(:)%j = (-(c(39)*M(2,:)%j)) * den(18)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(902),h0tab(:,902),[18,4,9],[nMB,nMZ,nMW],3,2,wf4(:,15),wf4(:,13))
  call Hloop_WA_Q(ntryL,G0H32(1),wf4(:,15),G0H8(92),m3h4x8(:,456),heltab2x32(:,:,902))
  call Hloop_A_Q(ntryL,G0H8(92),18,nMB,G1H8(90),n2h8(226))
  Gcoeff(:)%j = (c(76)*M(2,:)%j) * den(18)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(903),h0tab(:,903),[18,4,9],[nMB,0,nMW],3,2,wf4(:,15),wf4(:,13))
  call Hloop_SA_Q(ntryL,G0H32(1),wf4(:,15),G0H8(93),ngPtb,m3h4x8(:,457),heltab2x32(:,:,903))
  call Hloop_A_Q(ntryL,G0H8(93),18,nMB,G1H8(91),n2h8(227))
  Gcoeff(:)%j = (c(104)*M(2,:)%j) * den(18)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(904),h0tab(:,904),[18,4,9],[nMB,nMZ,nMW],3,2,wf4(:,15),wf4(:,13))
  call Hloop_SA_Q(ntryL,G0H32(1),wf4(:,15),G0H8(102),ngPtb,m3h4x8(:,458),heltab2x32(:,:,904))
  call Hloop_A_Q(ntryL,G0H8(102),18,nMB,G1H8(92),n2h8(228))
  Gcoeff(:)%j = (c(42)*M(2,:)%j) * den(18)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(905),h0tab(:,905),[18,4,9],[nMT,nMW,nMH],3,2,wf4(:,15),wf4(:,13))
  call Hloop_SA_Q(ntryL,G0H32(1),wf4(:,15),G0H8(103),ngH,m3h4x8(:,459),heltab2x32(:,:,905))
  call Hloop_A_Q(ntryL,G0H8(103),18,nMT,G1H8(93),n2h8(229))
  Gcoeff(:)%j = (c(42)*M(2,:)%j) * den(18)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(906),h0tab(:,906),[18,4,9],[nMT,nMW,nMZ],3,2,wf4(:,15),wf4(:,13))
  call Hloop_SA_Q(ntryL,G0H32(1),wf4(:,15),G0H8(106),ngX,m3h4x8(:,460),heltab2x32(:,:,906))
  call Hloop_A_Q(ntryL,G0H8(106),18,nMT,G1H8(94),n2h8(230))
  Gcoeff(:)%j = (c(64)*M(2,:)%j) * den(18)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(907),h0tab(:,907),[18,4,9],[nMT,nMW,0],3,2,wf4(:,15),wf4(:,13))
  call Hloop_VA_Q(ntryL,G0H32(1),wf4(:,15),G0H8(107),m3h4x8(:,461),heltab2x32(:,:,907))
  call Hloop_A_Q(ntryL,G0H8(107),18,nMT,G1H8(95),n2h8(231))
  Gcoeff(:)%j = (-(c(62)*M(2,:)%j)) * den(18)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(908),h0tab(:,908),[18,4,9],[nMB,0,nMW],3,2,wf4(:,15),wf4(:,13))
  call Hloop_WA_Q(ntryL,G0H32(1),wf4(:,15),G0H8(120),m3h4x8(:,462),heltab2x32(:,:,908))
  call Hloop_A_Q(ntryL,G0H8(120),18,nMB,G1H8(96),n2h8(232))
  Gcoeff(:)%j = (-(c(92)*M(2,:)%j)) * den(18)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(909),h0tab(:,909),[18,4,9],[nMT,nMW,nMZ],3,2,wf4(:,15),wf4(:,13))
  call Hloop_ZA_Q(ntryL,G0H32(1),wf4(:,15),G0H8(121),ngZu,m3h4x8(:,463),heltab2x32(:,:,909))
  call Hloop_A_Q(ntryL,G0H8(121),18,nMT,G1H8(97),n2h8(233))
  Gcoeff(:)%j = (-(c(92)*M(2,:)%j)) * den(18)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(910),h0tab(:,910),[18,4,9],[nMB,nMZ,nMW],3,2,wf4(:,15),wf4(:,13))
  call Hloop_WA_Q(ntryL,G0H32(1),wf4(:,15),G0H8(126),m3h4x8(:,464),heltab2x32(:,:,910))
  call Hloop_A_Q(ntryL,G0H8(126),18,nMB,G1H8(98),n2h8(234))
  Gcoeff(:)%j = (c(44)*M(2,:)%j) * den(18)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(911),h0tab(:,911),[18,4,9],[nMH,nMB,nMT],3,2,wf4(:,15),wf4(:,16))
  call Hloop_QA_S(ntryL,G0H32(1),wf4(:,15),G0H8(127),ngH,m3h4x8(:,465),heltab2x32(:,:,911))
  Gcoeff(:)%j = (c(44)*M(2,:)%j) * den(18)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(912),h0tab(:,912),[18,4,9],[nMZ,nMB,nMT],3,2,wf4(:,15),wf4(:,16))
  call Hloop_QA_S(ntryL,G0H32(1),wf4(:,15),G0H8(3),ngX,m3h4x8(:,466),heltab2x32(:,:,912))
  Gcoeff(:)%j = (c(42)*M(2,:)%j) * den(18)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(913),h0tab(:,913),[18,4,9],[nMT,nMW,nMH],3,2,wf4(:,15),wf4(:,16))
  call Hloop_SA_Q(ntryL,G0H32(1),wf4(:,15),G0H8(4),ngH,m3h4x8(:,467),heltab2x32(:,:,913))
  call Hloop_A_Q(ntryL,G0H8(4),18,nMT,G1H8(99),n2h8(235))
  Gcoeff(:)%j = (c(39)*M(2,:)%j) * den(18)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(914),h0tab(:,914),[18,4,9],[nMB,nMH,nMW],3,2,wf4(:,15),wf4(:,16))
  call Hloop_SA_Q(ntryL,G0H32(1),wf4(:,15),G0H8(12),ngPtb,m3h4x8(:,468),heltab2x32(:,:,914))
  call Hloop_A_Q(ntryL,G0H8(12),18,nMB,G1H8(100),n2h8(236))
  Gcoeff(:)%j = (-(c(42)*M(2,:)%j)) * den(18)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(915),h0tab(:,915),[18,4,9],[nMT,nMW,nMZ],3,2,wf4(:,15),wf4(:,16))
  call Hloop_SA_Q(ntryL,G0H32(1),wf4(:,15),G0H8(13),ngX,m3h4x8(:,469),heltab2x32(:,:,915))
  call Hloop_A_Q(ntryL,G0H8(13),18,nMT,G1H8(101),n2h8(237))
  Gcoeff(:)%j = (c(39)*M(2,:)%j) * den(18)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(916),h0tab(:,916),[18,4,9],[nMB,nMZ,nMW],3,2,wf4(:,15),wf4(:,16))
  call Hloop_SA_Q(ntryL,G0H32(1),wf4(:,15),G0H8(14),ngPtb,m3h4x8(:,470),heltab2x32(:,:,916))
  call Hloop_A_Q(ntryL,G0H8(14),18,nMB,G1H8(102),n2h8(238))
  Gcoeff(:)%j = (c(61)*M(2,:)%j) * den(18)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(917),h0tab(:,917),[18,4,9],[0,nMB,nMT],3,2,wf4(:,15),wf4(:,16))
  call Hloop_QA_V(ntryL,G0H32(1),wf4(:,15),G0H8(15),m3h4x8(:,471),heltab2x32(:,:,917))
  Gcoeff(:)%j = (-(c(65)*M(2,:)%j)) * den(18)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(918),h0tab(:,918),[18,4,9],[nMZ,nMB,nMT],3,2,wf4(:,15),wf4(:,16))
  call Hloop_QA_Z(ntryL,G0H32(1),wf4(:,15),G0H8(16),ngZu,m3h4x8(:,472),heltab2x32(:,:,918))
  Gcoeff(:)%j = (-(c(64)*M(2,:)%j)) * den(18)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(919),h0tab(:,919),[18,4,9],[nMT,nMW,0],3,2,wf4(:,15),wf4(:,16))
  call Hloop_VA_Q(ntryL,G0H32(1),wf4(:,15),G0H8(27),m3h4x8(:,473),heltab2x32(:,:,919))
  call Hloop_A_Q(ntryL,G0H8(27),18,nMT,G1H8(103),n2h8(239))
  Gcoeff(:)%j = (c(92)*M(2,:)%j) * den(18)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(920),h0tab(:,920),[18,4,9],[nMT,nMW,nMZ],3,2,wf4(:,15),wf4(:,16))
  call Hloop_ZA_Q(ntryL,G0H32(1),wf4(:,15),G0H8(28),ngZu,m3h4x8(:,474),heltab2x32(:,:,920))
  call Hloop_A_Q(ntryL,G0H8(28),18,nMT,G1H8(104),n2h8(240))
  Gcoeff(:)%j = (c(14)*M(2,:)%j) * den(18)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(921),h0tab(:,921),[18,4,9],[nMB,nMH,nMW],3,2,wf4(:,15),wf4(:,16))
  call Hloop_WA_Q(ntryL,G0H32(1),wf4(:,15),G0H8(29),m3h4x8(:,475),heltab2x32(:,:,921))
  call Hloop_A_Q(ntryL,G0H8(29),18,nMB,G1H8(105),n2h8(241))
  Gcoeff(:)%j = (c(62)*M(2,:)%j) * den(18)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(922),h0tab(:,922),[18,4,9],[nMB,0,nMW],3,2,wf4(:,15),wf4(:,16))
  call Hloop_SA_Q(ntryL,G0H32(1),wf4(:,15),G0H8(30),ngPtb,m3h4x8(:,476),heltab2x32(:,:,922))
  call Hloop_A_Q(ntryL,G0H8(30),18,nMB,G1H8(106),n2h8(242))
  Gcoeff(:)%j = (c(92)*M(2,:)%j) * den(18)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(923),h0tab(:,923),[18,4,9],[nMB,nMZ,nMW],3,2,wf4(:,15),wf4(:,16))
  call Hloop_SA_Q(ntryL,G0H32(1),wf4(:,15),G0H8(31),ngPtb,m3h4x8(:,477),heltab2x32(:,:,923))
  call Hloop_A_Q(ntryL,G0H8(31),18,nMB,G1H8(107),n2h8(243))
  Gcoeff(:)%j = (c(15)*M(2,:)%j) * den(18)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(924),h0tab(:,924),[18,4,9],[nMT,nMW,nMH],3,2,wf4(:,15),wf4(:,16))
  call Hloop_SA_Q(ntryL,G0H32(1),wf4(:,15),G0H8(32),ngH,m3h4x8(:,478),heltab2x32(:,:,924))
  call Hloop_A_Q(ntryL,G0H8(32),18,nMT,G1H8(108),n2h8(244))
  Gcoeff(:)%j = (-(c(64)*M(2,:)%j)) * den(18)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(925),h0tab(:,925),[18,4,9],[nMT,nMW,0],3,2,wf4(:,15),wf4(:,16))
  call Hloop_VA_Q(ntryL,G0H32(1),wf4(:,15),G0H8(37),m3h4x8(:,479),heltab2x32(:,:,925))
  call Hloop_A_Q(ntryL,G0H8(37),18,nMT,G1H8(109),n2h8(245))
  Gcoeff(:)%j = (c(62)*M(2,:)%j) * den(18)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(926),h0tab(:,926),[18,4,9],[nMB,0,nMW],3,2,wf4(:,15),wf4(:,16))
  call Hloop_WA_Q(ntryL,G0H32(1),wf4(:,15),G0H8(40),m3h4x8(:,480),heltab2x32(:,:,926))
  call Hloop_A_Q(ntryL,G0H8(40),18,nMB,G1H8(110),n2h8(246))
  Gcoeff(:)%j = (-(c(48)*M(2,:)%j)) * den(18)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(927),h0tab(:,927),[18,4,9],[nMT,nMW,nMZ],3,2,wf4(:,15),wf4(:,16))
  call Hloop_ZA_Q(ntryL,G0H32(1),wf4(:,15),G0H8(41),ngZu,m3h4x8(:,481),heltab2x32(:,:,927))
  call Hloop_A_Q(ntryL,G0H8(41),18,nMT,G1H8(111),n2h8(247))
  Gcoeff(:)%j = (-(c(48)*M(2,:)%j)) * den(18)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(928),h0tab(:,928),[18,4,9],[nMB,nMZ,nMW],3,2,wf4(:,15),wf4(:,16))
  call Hloop_WA_Q(ntryL,G0H32(1),wf4(:,15),G0H8(42),m3h4x8(:,482),heltab2x32(:,:,928))
  call Hloop_A_Q(ntryL,G0H8(42),18,nMB,G1H8(112),n2h8(248))
  Gcoeff(:)%j = (c(24)*M(2,:)%j) * den(19)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(929),h0tab(:,929),[20,2,9],[nMH,nMT,nMB],3,2,wf4(:,3),wf4(:,13))
  call Hloop_AQ_S(ntryL,G0H32(1),wf4(:,3),G0H8(51),ngH,m3h4x8(:,483),heltab2x32(:,:,929))
  Gcoeff(:)%j = (c(24)*M(2,:)%j) * den(19)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(930),h0tab(:,930),[20,2,9],[nMZ,nMT,nMB],3,2,wf4(:,3),wf4(:,13))
  call Hloop_AQ_S(ntryL,G0H32(1),wf4(:,3),G0H8(54),ngX,m3h4x8(:,484),heltab2x32(:,:,930))
  Gcoeff(:)%j = (c(26)*M(2,:)%j) * den(19)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(931),h0tab(:,931),[20,2,9],[nMT,nMH,nMW],3,2,wf4(:,3),wf4(:,13))
  call Hloop_SQ_A(ntryL,G0H32(1),wf4(:,3),G0H8(55),ngPtb,m3h4x8(:,485),heltab2x32(:,:,931))
  call Hloop_Q_A(ntryL,G0H8(55),20,nMT,G1H8(113),n2h8(249))
  Gcoeff(:)%j = (c(22)*M(2,:)%j) * den(19)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(932),h0tab(:,932),[20,2,9],[nMB,nMW,nMH],3,2,wf4(:,3),wf4(:,13))
  call Hloop_SQ_A(ntryL,G0H32(1),wf4(:,3),G0H8(56),ngH,m3h4x8(:,486),heltab2x32(:,:,932))
  call Hloop_Q_A(ntryL,G0H8(56),20,nMB,G1H8(114),n2h8(250))
  Gcoeff(:)%j = (c(75)*M(2,:)%j) * den(19)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(933),h0tab(:,933),[20,2,9],[0,nMT,nMB],3,2,wf4(:,3),wf4(:,13))
  call Hloop_AQ_V(ntryL,G0H32(1),wf4(:,3),G0H8(62),m3h4x8(:,487),heltab2x32(:,:,933))
  Gcoeff(:)%j = (-(c(79)*M(2,:)%j)) * den(19)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(934),h0tab(:,934),[20,2,9],[nMZ,nMT,nMB],3,2,wf4(:,3),wf4(:,13))
  call Hloop_AQ_Z(ntryL,G0H32(1),wf4(:,3),G0H8(63),ngZd,m3h4x8(:,488),heltab2x32(:,:,934))
  Gcoeff(:)%j = (c(76)*M(2,:)%j) * den(19)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(935),h0tab(:,935),[20,2,9],[nMB,nMW,0],3,2,wf4(:,3),wf4(:,13))
  call Hloop_VQ_A(ntryL,G0H32(1),wf4(:,3),G0H8(64),m3h4x8(:,489),heltab2x32(:,:,935))
  call Hloop_Q_A(ntryL,G0H8(64),20,nMB,G1H8(115),n2h8(251))
  Gcoeff(:)%j = (c(104)*M(2,:)%j) * den(19)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(936),h0tab(:,936),[20,2,9],[nMB,nMW,nMZ],3,2,wf4(:,3),wf4(:,13))
  call Hloop_ZQ_A(ntryL,G0H32(1),wf4(:,3),G0H8(65),ngZd,m3h4x8(:,490),heltab2x32(:,:,936))
  call Hloop_Q_A(ntryL,G0H8(65),20,nMB,G1H8(116),n2h8(252))
  Gcoeff(:)%j = (c(42)*M(2,:)%j) * den(19)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(937),h0tab(:,937),[20,2,9],[nMT,nMH,nMW],3,2,wf4(:,3),wf4(:,13))
  call Hloop_WQ_A(ntryL,G0H32(1),wf4(:,3),G0H8(66),m3h4x8(:,491),heltab2x32(:,:,937))
  call Hloop_Q_A(ntryL,G0H8(66),20,nMT,G1H8(117),n2h8(253))
  Gcoeff(:)%j = (c(42)*M(2,:)%j) * den(19)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(938),h0tab(:,938),[20,2,9],[nMT,nMZ,nMW],3,2,wf4(:,3),wf4(:,13))
  call Hloop_WQ_A(ntryL,G0H32(1),wf4(:,3),G0H8(67),m3h4x8(:,492),heltab2x32(:,:,938))
  call Hloop_Q_A(ntryL,G0H8(67),20,nMT,G1H8(118),n2h8(254))
  Gcoeff(:)%j = (-(c(78)*M(2,:)%j)) * den(19)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(939),h0tab(:,939),[20,2,9],[nMT,0,nMW],3,2,wf4(:,3),wf4(:,13))
  call Hloop_SQ_A(ntryL,G0H32(1),wf4(:,3),G0H8(78),ngPtb,m3h4x8(:,493),heltab2x32(:,:,939))
  call Hloop_Q_A(ntryL,G0H8(78),20,nMT,G1H8(119),n2h8(255))
  Gcoeff(:)%j = (c(104)*M(2,:)%j) * den(19)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(940),h0tab(:,940),[20,2,9],[nMT,nMZ,nMW],3,2,wf4(:,3),wf4(:,13))
  call Hloop_SQ_A(ntryL,G0H32(1),wf4(:,3),G0H8(81),ngPtb,m3h4x8(:,494),heltab2x32(:,:,940))
  call Hloop_Q_A(ntryL,G0H8(81),20,nMT,G1H8(120),n2h8(256))
  Gcoeff(:)%j = (c(39)*M(2,:)%j) * den(19)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(941),h0tab(:,941),[20,2,9],[nMB,nMW,nMH],3,2,wf4(:,3),wf4(:,13))
  call Hloop_SQ_A(ntryL,G0H32(1),wf4(:,3),G0H8(82),ngH,m3h4x8(:,495),heltab2x32(:,:,941))
  call Hloop_Q_A(ntryL,G0H8(82),20,nMB,G1H8(121),n2h8(257))
  Gcoeff(:)%j = (-(c(39)*M(2,:)%j)) * den(19)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(942),h0tab(:,942),[20,2,9],[nMB,nMW,nMZ],3,2,wf4(:,3),wf4(:,13))
  call Hloop_SQ_A(ntryL,G0H32(1),wf4(:,3),G0H8(89),ngX,m3h4x8(:,496),heltab2x32(:,:,942))
  call Hloop_Q_A(ntryL,G0H8(89),20,nMB,G1H8(122),n2h8(258))
  Gcoeff(:)%j = (c(64)*M(2,:)%j) * den(19)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(943),h0tab(:,943),[20,2,9],[nMT,0,nMW],3,2,wf4(:,3),wf4(:,13))
  call Hloop_WQ_A(ntryL,G0H32(1),wf4(:,3),G0H8(90),m3h4x8(:,497),heltab2x32(:,:,943))
  call Hloop_Q_A(ntryL,G0H8(90),20,nMT,G1H8(123),n2h8(259))
  Gcoeff(:)%j = (-(c(62)*M(2,:)%j)) * den(19)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(944),h0tab(:,944),[20,2,9],[nMB,nMW,0],3,2,wf4(:,3),wf4(:,13))
  call Hloop_VQ_A(ntryL,G0H32(1),wf4(:,3),G0H8(91),m3h4x8(:,498),heltab2x32(:,:,944))
  call Hloop_Q_A(ntryL,G0H8(91),20,nMB,G1H8(124),n2h8(260))
  Gcoeff(:)%j = (-(c(92)*M(2,:)%j)) * den(19)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(945),h0tab(:,945),[20,2,9],[nMT,nMZ,nMW],3,2,wf4(:,3),wf4(:,13))
  call Hloop_WQ_A(ntryL,G0H32(1),wf4(:,3),G0H8(92),m3h4x8(:,499),heltab2x32(:,:,945))
  call Hloop_Q_A(ntryL,G0H8(92),20,nMT,G1H8(125),n2h8(261))
  Gcoeff(:)%j = (-(c(92)*M(2,:)%j)) * den(19)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(946),h0tab(:,946),[20,2,9],[nMB,nMW,nMZ],3,2,wf4(:,3),wf4(:,13))
  call Hloop_ZQ_A(ntryL,G0H32(1),wf4(:,3),G0H8(93),ngZd,m3h4x8(:,500),heltab2x32(:,:,946))
  call Hloop_Q_A(ntryL,G0H8(93),20,nMB,G1H8(126),n2h8(262))
  Gcoeff(:)%j = (c(44)*M(2,:)%j) * den(19)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(947),h0tab(:,947),[20,2,9],[nMH,nMT,nMB],3,2,wf4(:,3),wf4(:,16))
  call Hloop_AQ_S(ntryL,G0H32(1),wf4(:,3),G0H8(102),ngH,m3h4x8(:,501),heltab2x32(:,:,947))
  Gcoeff(:)%j = (c(44)*M(2,:)%j) * den(19)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(948),h0tab(:,948),[20,2,9],[nMZ,nMT,nMB],3,2,wf4(:,3),wf4(:,16))
  call Hloop_AQ_S(ntryL,G0H32(1),wf4(:,3),G0H8(103),ngX,m3h4x8(:,502),heltab2x32(:,:,948))
  Gcoeff(:)%j = (c(42)*M(2,:)%j) * den(19)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(949),h0tab(:,949),[20,2,9],[nMT,nMH,nMW],3,2,wf4(:,3),wf4(:,16))
  call Hloop_SQ_A(ntryL,G0H32(1),wf4(:,3),G0H8(106),ngPtb,m3h4x8(:,503),heltab2x32(:,:,949))
  call Hloop_Q_A(ntryL,G0H8(106),20,nMT,G1H8(127),n2h8(263))
  Gcoeff(:)%j = (c(39)*M(2,:)%j) * den(19)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(950),h0tab(:,950),[20,2,9],[nMB,nMW,nMH],3,2,wf4(:,3),wf4(:,16))
  call Hloop_SQ_A(ntryL,G0H32(1),wf4(:,3),G0H8(107),ngH,m3h4x8(:,504),heltab2x32(:,:,950))
  call Hloop_Q_A(ntryL,G0H8(107),20,nMB,G1H8(128),n2h8(264))
  Gcoeff(:)%j = (-(c(42)*M(2,:)%j)) * den(19)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(951),h0tab(:,951),[20,2,9],[nMT,nMZ,nMW],3,2,wf4(:,3),wf4(:,16))
  call Hloop_SQ_A(ntryL,G0H32(1),wf4(:,3),G0H8(120),ngPtb,m3h4x8(:,505),heltab2x32(:,:,951))
  call Hloop_Q_A(ntryL,G0H8(120),20,nMT,G1H8(129),n2h8(265))
  Gcoeff(:)%j = (c(39)*M(2,:)%j) * den(19)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(952),h0tab(:,952),[20,2,9],[nMB,nMW,nMZ],3,2,wf4(:,3),wf4(:,16))
  call Hloop_SQ_A(ntryL,G0H32(1),wf4(:,3),G0H8(121),ngX,m3h4x8(:,506),heltab2x32(:,:,952))
  call Hloop_Q_A(ntryL,G0H8(121),20,nMB,G1H8(130),n2h8(266))
  Gcoeff(:)%j = (c(61)*M(2,:)%j) * den(19)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(953),h0tab(:,953),[20,2,9],[0,nMT,nMB],3,2,wf4(:,3),wf4(:,16))
  call Hloop_AQ_V(ntryL,G0H32(1),wf4(:,3),G0H8(126),m3h4x8(:,507),heltab2x32(:,:,953))
  Gcoeff(:)%j = (-(c(65)*M(2,:)%j)) * den(19)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(954),h0tab(:,954),[20,2,9],[nMZ,nMT,nMB],3,2,wf4(:,3),wf4(:,16))
  call Hloop_AQ_Z(ntryL,G0H32(1),wf4(:,3),G0H8(4),ngZd,m3h4x8(:,508),heltab2x32(:,:,954))
  Gcoeff(:)%j = (c(62)*M(2,:)%j) * den(19)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(955),h0tab(:,955),[20,2,9],[nMB,nMW,0],3,2,wf4(:,3),wf4(:,16))
  call Hloop_VQ_A(ntryL,G0H32(1),wf4(:,3),G0H8(12),m3h4x8(:,509),heltab2x32(:,:,955))
  call Hloop_Q_A(ntryL,G0H8(12),20,nMB,G1H8(131),n2h8(267))
  Gcoeff(:)%j = (c(92)*M(2,:)%j) * den(19)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(956),h0tab(:,956),[20,2,9],[nMB,nMW,nMZ],3,2,wf4(:,3),wf4(:,16))
  call Hloop_ZQ_A(ntryL,G0H32(1),wf4(:,3),G0H8(13),ngZd,m3h4x8(:,510),heltab2x32(:,:,956))
  call Hloop_Q_A(ntryL,G0H8(13),20,nMB,G1H8(132),n2h8(268))
  Gcoeff(:)%j = (c(15)*M(2,:)%j) * den(19)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(957),h0tab(:,957),[20,2,9],[nMT,nMH,nMW],3,2,wf4(:,3),wf4(:,16))
  call Hloop_WQ_A(ntryL,G0H32(1),wf4(:,3),G0H8(14),m3h4x8(:,511),heltab2x32(:,:,957))
  call Hloop_Q_A(ntryL,G0H8(14),20,nMT,G1H8(133),n2h8(269))
  Gcoeff(:)%j = (-(c(64)*M(2,:)%j)) * den(19)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(958),h0tab(:,958),[20,2,9],[nMT,0,nMW],3,2,wf4(:,3),wf4(:,16))
  call Hloop_SQ_A(ntryL,G0H32(1),wf4(:,3),G0H8(27),ngPtb,m3h4x8(:,512),heltab2x32(:,:,958))
  call Hloop_Q_A(ntryL,G0H8(27),20,nMT,G1H8(134),n2h8(270))
  Gcoeff(:)%j = (c(92)*M(2,:)%j) * den(19)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(959),h0tab(:,959),[20,2,9],[nMT,nMZ,nMW],3,2,wf4(:,3),wf4(:,16))
  call Hloop_SQ_A(ntryL,G0H32(1),wf4(:,3),G0H8(28),ngPtb,m3h4x8(:,513),heltab2x32(:,:,959))
  call Hloop_Q_A(ntryL,G0H8(28),20,nMT,G1H8(135),n2h8(271))
  Gcoeff(:)%j = (c(14)*M(2,:)%j) * den(19)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(960),h0tab(:,960),[20,2,9],[nMB,nMW,nMH],3,2,wf4(:,3),wf4(:,16))
  call Hloop_SQ_A(ntryL,G0H32(1),wf4(:,3),G0H8(29),ngH,m3h4x8(:,514),heltab2x32(:,:,960))
  call Hloop_Q_A(ntryL,G0H8(29),20,nMB,G1H8(136),n2h8(272))
  Gcoeff(:)%j = (-(c(64)*M(2,:)%j)) * den(19)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(961),h0tab(:,961),[20,2,9],[nMT,0,nMW],3,2,wf4(:,3),wf4(:,16))
  call Hloop_WQ_A(ntryL,G0H32(1),wf4(:,3),G0H8(30),m3h4x8(:,515),heltab2x32(:,:,961))
  call Hloop_Q_A(ntryL,G0H8(30),20,nMT,G1H8(137),n2h8(273))
  Gcoeff(:)%j = (c(62)*M(2,:)%j) * den(19)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(962),h0tab(:,962),[20,2,9],[nMB,nMW,0],3,2,wf4(:,3),wf4(:,16))
  call Hloop_VQ_A(ntryL,G0H32(1),wf4(:,3),G0H8(31),m3h4x8(:,516),heltab2x32(:,:,962))
  call Hloop_Q_A(ntryL,G0H8(31),20,nMB,G1H8(138),n2h8(274))
  Gcoeff(:)%j = (-(c(48)*M(2,:)%j)) * den(19)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(963),h0tab(:,963),[20,2,9],[nMT,nMZ,nMW],3,2,wf4(:,3),wf4(:,16))
  call Hloop_WQ_A(ntryL,G0H32(1),wf4(:,3),G0H8(32),m3h4x8(:,517),heltab2x32(:,:,963))
  call Hloop_Q_A(ntryL,G0H8(32),20,nMT,G1H8(139),n2h8(275))
  Gcoeff(:)%j = (-(c(48)*M(2,:)%j)) * den(19)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(964),h0tab(:,964),[20,2,9],[nMB,nMW,nMZ],3,2,wf4(:,3),wf4(:,16))
  call Hloop_ZQ_A(ntryL,G0H32(1),wf4(:,3),G0H8(37),ngZd,m3h4x8(:,518),heltab2x32(:,:,964))
  call Hloop_Q_A(ntryL,G0H8(37),20,nMB,G1H8(140),n2h8(276))
  Gcoeff(:)%j = (c(21)*M(2,:)%j) * den(80)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(965),h0tab(:,965),[16,4,11],[nMB,nMH,nMB],3,1,wf8(:,103))
  call Hloop_AV_Q(ntryL,G0H32(1),ex5(:),G0H16(1),m3h2x16(:,447),heltab2x32(:,:,965))
  call Hloop_A_Q(ntryL,G0H16(1),16,nMB,G1H16(73),n2h16(447))
  Gcoeff(:)%j = (-(c(21)*M(2,:)%j)) * den(80)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(966),h0tab(:,966),[16,4,11],[nMB,nMZ,nMB],3,1,wf8(:,103))
  call Hloop_AV_Q(ntryL,G0H32(1),ex5(:),G0H16(1),m3h2x16(:,448),heltab2x32(:,:,966))
  call Hloop_A_Q(ntryL,G0H16(1),16,nMB,G1H16(74),n2h16(448))
  Gcoeff(:)%j = (-(c(20)*M(2,:)%j)) * den(80)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(967),h0tab(:,967),[16,4,11],[nMT,nMW,nMT],3,1,wf8(:,103))
  call Hloop_AV_Q(ntryL,G0H32(1),ex5(:),G0H16(1),m3h2x16(:,449),heltab2x32(:,:,967))
  call Hloop_A_Q(ntryL,G0H16(1),16,nMT,G1H16(75),n2h16(449))
  Gcoeff(:)%j = (-(c(74)*M(2,:)%j)) * den(80)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(968),h0tab(:,968),[16,4,11],[nMB,0,nMB],3,1,wf8(:,103))
  call Hloop_AV_Q(ntryL,G0H32(1),ex5(:),G0H16(1),m3h2x16(:,450),heltab2x32(:,:,968))
  call Hloop_A_Q(ntryL,G0H16(1),16,nMB,G1H16(76),n2h16(450))
  Gcoeff(:)%j = (-(c(79)*M(2,:)%j)) * den(80)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(969),h0tab(:,969),[16,4,11],[nMB,nMZ,nMB],3,1,wf8(:,103))
  call Hloop_AV_Q(ntryL,G0H32(1),ex5(:),G0H16(1),m3h2x16(:,451),heltab2x32(:,:,969))
  call Hloop_A_Q(ntryL,G0H16(1),16,nMB,G1H16(77),n2h16(451))
  Gcoeff(:)%j = (-(c(38)*M(2,:)%j)) * den(80)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(970),h0tab(:,970),[16,4,11],[nMT,nMW,nMT],3,1,wf8(:,103))
  call Hloop_AV_Q(ntryL,G0H32(1),ex5(:),G0H16(1),m3h2x16(:,452),heltab2x32(:,:,970))
  call Hloop_A_Q(ntryL,G0H16(1),16,nMT,G1H16(78),n2h16(452))
  Gcoeff(:)%j = (c(40)*M(2,:)%j) * den(80)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(971),h0tab(:,971),[16,4,11],[nMB,nMH,nMB],3,1,wf8(:,104))
  call Hloop_AV_Q(ntryL,G0H32(1),ex5(:),G0H16(1),m3h2x16(:,453),heltab2x32(:,:,971))
  call Hloop_A_Q(ntryL,G0H16(1),16,nMB,G1H16(79),n2h16(453))
  Gcoeff(:)%j = (-(c(40)*M(2,:)%j)) * den(80)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(972),h0tab(:,972),[16,4,11],[nMB,nMZ,nMB],3,1,wf8(:,104))
  call Hloop_AV_Q(ntryL,G0H32(1),ex5(:),G0H16(1),m3h2x16(:,454),heltab2x32(:,:,972))
  call Hloop_A_Q(ntryL,G0H16(1),16,nMB,G1H16(80),n2h16(454))
  Gcoeff(:)%j = (-(c(38)*M(2,:)%j)) * den(80)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(973),h0tab(:,973),[16,4,11],[nMT,nMW,nMT],3,1,wf8(:,104))
  call Hloop_AV_Q(ntryL,G0H32(1),ex5(:),G0H16(1),m3h2x16(:,455),heltab2x32(:,:,973))
  call Hloop_A_Q(ntryL,G0H16(1),16,nMT,G1H16(81),n2h16(455))
  Gcoeff(:)%j = (-(c(60)*M(2,:)%j)) * den(80)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(974),h0tab(:,974),[16,4,11],[nMB,0,nMB],3,1,wf8(:,104))
  call Hloop_AV_Q(ntryL,G0H32(1),ex5(:),G0H16(1),m3h2x16(:,456),heltab2x32(:,:,974))
  call Hloop_A_Q(ntryL,G0H16(1),16,nMB,G1H16(82),n2h16(456))
  Gcoeff(:)%j = (-(c(65)*M(2,:)%j)) * den(80)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(975),h0tab(:,975),[16,4,11],[nMB,nMZ,nMB],3,1,wf8(:,104))
  call Hloop_AV_Q(ntryL,G0H32(1),ex5(:),G0H16(1),m3h2x16(:,457),heltab2x32(:,:,975))
  call Hloop_A_Q(ntryL,G0H16(1),16,nMB,G1H16(83),n2h16(457))
  Gcoeff(:)%j = (-(c(12)*M(2,:)%j)) * den(80)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(976),h0tab(:,976),[16,4,11],[nMT,nMW,nMT],3,1,wf8(:,104))
  call Hloop_AV_Q(ntryL,G0H32(1),ex5(:),G0H16(1),m3h2x16(:,458),heltab2x32(:,:,976))
  call Hloop_A_Q(ntryL,G0H16(1),16,nMT,G1H16(84),n2h16(458))
  Gcoeff(:)%j = (c(32)*M(2,:)%j) * den(76)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(977),h0tab(:,977),[16,2,13],[nMT,nMH,nMT],3,1,wf8(:,99))
  call Hloop_QV_A(ntryL,G0H32(1),ex5(:),G0H16(1),m3h2x16(:,459),heltab2x32(:,:,977))
  call Hloop_Q_A(ntryL,G0H16(1),16,nMT,G1H16(85),n2h16(459))
  Gcoeff(:)%j = (-(c(32)*M(2,:)%j)) * den(76)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(978),h0tab(:,978),[16,2,13],[nMT,nMZ,nMT],3,1,wf8(:,99))
  call Hloop_QV_A(ntryL,G0H32(1),ex5(:),G0H16(1),m3h2x16(:,460),heltab2x32(:,:,978))
  call Hloop_Q_A(ntryL,G0H16(1),16,nMT,G1H16(86),n2h16(460))
  Gcoeff(:)%j = (-(c(20)*M(2,:)%j)) * den(76)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(979),h0tab(:,979),[16,2,13],[nMB,nMW,nMB],3,1,wf8(:,99))
  call Hloop_QV_A(ntryL,G0H32(1),ex5(:),G0H16(1),m3h2x16(:,461),heltab2x32(:,:,979))
  call Hloop_Q_A(ntryL,G0H16(1),16,nMB,G1H16(87),n2h16(461))
  Gcoeff(:)%j = (-(c(77)*M(2,:)%j)) * den(76)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(980),h0tab(:,980),[16,2,13],[nMT,0,nMT],3,1,wf8(:,99))
  call Hloop_QV_A(ntryL,G0H32(1),ex5(:),G0H16(1),m3h2x16(:,462),heltab2x32(:,:,980))
  call Hloop_Q_A(ntryL,G0H16(1),16,nMT,G1H16(88),n2h16(462))
  Gcoeff(:)%j = (-(c(79)*M(2,:)%j)) * den(76)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(981),h0tab(:,981),[16,2,13],[nMT,nMZ,nMT],3,1,wf8(:,99))
  call Hloop_QV_A(ntryL,G0H32(1),ex5(:),G0H16(1),m3h2x16(:,463),heltab2x32(:,:,981))
  call Hloop_Q_A(ntryL,G0H16(1),16,nMT,G1H16(89),n2h16(463))
  Gcoeff(:)%j = (-(c(38)*M(2,:)%j)) * den(76)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(982),h0tab(:,982),[16,2,13],[nMB,nMW,nMB],3,1,wf8(:,99))
  call Hloop_QV_A(ntryL,G0H32(1),ex5(:),G0H16(1),m3h2x16(:,464),heltab2x32(:,:,982))
  call Hloop_Q_A(ntryL,G0H16(1),16,nMB,G1H16(90),n2h16(464))
  Gcoeff(:)%j = (c(46)*M(2,:)%j) * den(76)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(983),h0tab(:,983),[16,2,13],[nMT,nMH,nMT],3,1,wf8(:,100))
  call Hloop_QV_A(ntryL,G0H32(1),ex5(:),G0H16(1),m3h2x16(:,465),heltab2x32(:,:,983))
  call Hloop_Q_A(ntryL,G0H16(1),16,nMT,G1H16(91),n2h16(465))
  Gcoeff(:)%j = (-(c(46)*M(2,:)%j)) * den(76)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(984),h0tab(:,984),[16,2,13],[nMT,nMZ,nMT],3,1,wf8(:,100))
  call Hloop_QV_A(ntryL,G0H32(1),ex5(:),G0H16(1),m3h2x16(:,466),heltab2x32(:,:,984))
  call Hloop_Q_A(ntryL,G0H16(1),16,nMT,G1H16(92),n2h16(466))
  Gcoeff(:)%j = (-(c(38)*M(2,:)%j)) * den(76)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(985),h0tab(:,985),[16,2,13],[nMB,nMW,nMB],3,1,wf8(:,100))
  call Hloop_QV_A(ntryL,G0H32(1),ex5(:),G0H16(1),m3h2x16(:,467),heltab2x32(:,:,985))
  call Hloop_Q_A(ntryL,G0H16(1),16,nMB,G1H16(93),n2h16(467))
  Gcoeff(:)%j = (-(c(63)*M(2,:)%j)) * den(76)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(986),h0tab(:,986),[16,2,13],[nMT,0,nMT],3,1,wf8(:,100))
  call Hloop_QV_A(ntryL,G0H32(1),ex5(:),G0H16(1),m3h2x16(:,468),heltab2x32(:,:,986))
  call Hloop_Q_A(ntryL,G0H16(1),16,nMT,G1H16(94),n2h16(468))
  Gcoeff(:)%j = (-(c(65)*M(2,:)%j)) * den(76)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(987),h0tab(:,987),[16,2,13],[nMT,nMZ,nMT],3,1,wf8(:,100))
  call Hloop_QV_A(ntryL,G0H32(1),ex5(:),G0H16(1),m3h2x16(:,469),heltab2x32(:,:,987))
  call Hloop_Q_A(ntryL,G0H16(1),16,nMT,G1H16(95),n2h16(469))
  Gcoeff(:)%j = (-(c(12)*M(2,:)%j)) * den(76)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(988),h0tab(:,988),[16,2,13],[nMB,nMW,nMB],3,1,wf8(:,100))
  call Hloop_QV_A(ntryL,G0H32(1),ex5(:),G0H16(1),m3h2x16(:,470),heltab2x32(:,:,988))
  call Hloop_Q_A(ntryL,G0H16(1),16,nMB,G1H16(96),n2h16(470))
  Gcoeff(:)%j = (c(36)*M(1,:)%j) * den(21)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(989),h0tab(:,989),[17,2,12],[nMH,nMT,nMT],3,2,wf4(:,11),wf4(:,17))
  call Hloop_AQ_S(ntryL,G0H32(1),wf4(:,11),G0H8(40),ngH,m3h4x8(:,519),heltab2x32(:,:,989))
  Gcoeff(:)%j = (-(c(36)*M(1,:)%j)) * den(21)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(990),h0tab(:,990),[17,2,12],[nMZ,nMT,nMT],3,2,wf4(:,11),wf4(:,17))
  call Hloop_AQ_S(ntryL,G0H32(1),wf4(:,11),G0H8(41),ngX,m3h4x8(:,520),heltab2x32(:,:,990))
  Gcoeff(:)%j = (-(c(21)*M(1,:)%j)) * den(21)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(991),h0tab(:,991),[17,2,12],[nMW,nMB,nMB],3,2,wf4(:,11),wf4(:,17))
  call Hloop_AQ_S(ntryL,G0H32(1),wf4(:,11),G0H8(42),ngPbt,m3h4x8(:,521),heltab2x32(:,:,991))
  Gcoeff(:)%j = (c(36)*M(1,:)%j) * den(23)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(992),h0tab(:,992),[17,2,12],[nMH,nMT,nMT],3,2,wf4(:,11),wf4(:,18))
  call Hloop_AQ_S(ntryL,G0H32(1),wf4(:,11),G0H8(55),ngH,m3h4x8(:,522),heltab2x32(:,:,992))
  Gcoeff(:)%j = (-(c(36)*M(1,:)%j)) * den(23)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(993),h0tab(:,993),[17,2,12],[nMZ,nMT,nMT],3,2,wf4(:,11),wf4(:,18))
  call Hloop_AQ_S(ntryL,G0H32(1),wf4(:,11),G0H8(56),ngX,m3h4x8(:,523),heltab2x32(:,:,993))
  Gcoeff(:)%j = (c(21)*M(1,:)%j) * den(23)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(994),h0tab(:,994),[17,2,12],[nMW,nMB,nMB],3,2,wf4(:,11),wf4(:,18))
  call Hloop_AQ_S(ntryL,G0H32(1),wf4(:,11),G0H8(64),ngPbt,m3h4x8(:,524),heltab2x32(:,:,994))
  Gcoeff(:)%j = (c(35)*M(1,:)%j) * den(21)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(995),h0tab(:,995),[17,2,12],[nMT,nMH,nMH],3,2,wf4(:,11),wf4(:,17))
  call Hloop_SQ_A(ntryL,G0H32(1),wf4(:,11),G0H8(65),ngH,m3h4x8(:,525),heltab2x32(:,:,995))
  call Hloop_Q_A(ntryL,G0H8(65),17,nMT,G1H8(141),n2h8(277))
  Gcoeff(:)%j = (-(c(34)*M(1,:)%j)) * den(21)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(996),h0tab(:,996),[17,2,12],[nMT,nMZ,nMZ],3,2,wf4(:,11),wf4(:,17))
  call Hloop_SQ_A(ntryL,G0H32(1),wf4(:,11),G0H8(66),ngX,m3h4x8(:,526),heltab2x32(:,:,996))
  call Hloop_Q_A(ntryL,G0H8(66),17,nMT,G1H8(142),n2h8(278))
  Gcoeff(:)%j = (-(c(22)*M(1,:)%j)) * den(21)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(997),h0tab(:,997),[17,2,12],[nMB,nMW,nMW],3,2,wf4(:,11),wf4(:,17))
  call Hloop_SQ_A(ntryL,G0H32(1),wf4(:,11),G0H8(67),ngPbt,m3h4x8(:,527),heltab2x32(:,:,997))
  call Hloop_Q_A(ntryL,G0H8(67),17,nMB,G1H8(143),n2h8(279))
  Gcoeff(:)%j = (c(34)*M(1,:)%j) * den(23)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(998),h0tab(:,998),[17,2,12],[nMT,nMH,nMZ],3,2,wf4(:,11),wf4(:,18))
  call Hloop_SQ_A(ntryL,G0H32(1),wf4(:,11),G0H8(78),ngX,m3h4x8(:,528),heltab2x32(:,:,998))
  call Hloop_Q_A(ntryL,G0H8(78),17,nMT,G1H8(144),n2h8(280))
  Gcoeff(:)%j = (c(34)*M(1,:)%j) * den(23)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(999),h0tab(:,999),[17,2,12],[nMT,nMZ,nMH],3,2,wf4(:,11),wf4(:,18))
  call Hloop_SQ_A(ntryL,G0H32(1),wf4(:,11),G0H8(81),ngH,m3h4x8(:,529),heltab2x32(:,:,999))
  call Hloop_Q_A(ntryL,G0H8(81),17,nMT,G1H8(145),n2h8(281))
  Gcoeff(:)%j = (-(c(85)*M(1,:)%j)) * den(21)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1000),h0tab(:,1000),[17,2,12],[0,nMT,nMT],3,2,wf4(:,11),wf4(:,17))
  call Hloop_AQ_V(ntryL,G0H32(1),wf4(:,11),G0H8(82),m3h4x8(:,530),heltab2x32(:,:,1000))
  Gcoeff(:)%j = (-(c(86)*M(1,:)%j)) * den(21)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1001),h0tab(:,1001),[17,2,12],[nMZ,nMT,nMT],3,2,wf4(:,11),wf4(:,17))
  call Hloop_AQ_Z(ntryL,G0H32(1),wf4(:,11),G0H8(89),ngZu,m3h4x8(:,531),heltab2x32(:,:,1001))
  Gcoeff(:)%j = (-(c(40)*M(1,:)%j)) * den(21)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1002),h0tab(:,1002),[17,2,12],[nMW,nMB,nMB],3,2,wf4(:,11),wf4(:,17))
  call Hloop_AQ_W(ntryL,G0H32(1),wf4(:,11),G0H8(90),m3h4x8(:,532),heltab2x32(:,:,1002))
  Gcoeff(:)%j = (-(c(85)*M(1,:)%j)) * den(23)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1003),h0tab(:,1003),[17,2,12],[0,nMT,nMT],3,2,wf4(:,11),wf4(:,18))
  call Hloop_AQ_V(ntryL,G0H32(1),wf4(:,11),G0H8(91),m3h4x8(:,533),heltab2x32(:,:,1003))
  Gcoeff(:)%j = (-(c(86)*M(1,:)%j)) * den(23)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1004),h0tab(:,1004),[17,2,12],[nMZ,nMT,nMT],3,2,wf4(:,11),wf4(:,18))
  call Hloop_AQ_Z(ntryL,G0H32(1),wf4(:,11),G0H8(92),ngZu,m3h4x8(:,534),heltab2x32(:,:,1004))
  Gcoeff(:)%j = (c(40)*M(1,:)%j) * den(23)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1005),h0tab(:,1005),[17,2,12],[nMW,nMB,nMB],3,2,wf4(:,11),wf4(:,18))
  call Hloop_AQ_W(ntryL,G0H32(1),wf4(:,11),G0H8(93),m3h4x8(:,535),heltab2x32(:,:,1005))
  Gcoeff(:)%j = (-(c(57)*M(1,:)%j)) * den(21)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1006),h0tab(:,1006),[17,2,12],[nMT,nMZ,nMZ],3,2,wf4(:,11),wf4(:,17))
  call Hloop_ZQ_A(ntryL,G0H32(1),wf4(:,11),G0H8(106),ngZu,m3h4x8(:,536),heltab2x32(:,:,1006))
  call Hloop_Q_A(ntryL,G0H8(106),17,nMT,G1H8(146),n2h8(282))
  Gcoeff(:)%j = (-(c(39)*M(1,:)%j)) * den(21)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1007),h0tab(:,1007),[17,2,12],[nMB,nMW,nMW],3,2,wf4(:,11),wf4(:,17))
  call Hloop_WQ_A(ntryL,G0H32(1),wf4(:,11),G0H8(107),m3h4x8(:,537),heltab2x32(:,:,1007))
  call Hloop_Q_A(ntryL,G0H8(107),17,nMB,G1H8(147),n2h8(283))
  Gcoeff(:)%j = (c(57)*M(1,:)%j) * den(23)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1008),h0tab(:,1008),[17,2,12],[nMT,nMH,nMZ],3,2,wf4(:,11),wf4(:,18))
  call Hloop_ZQ_A(ntryL,G0H32(1),wf4(:,11),G0H8(120),ngZu,m3h4x8(:,538),heltab2x32(:,:,1008))
  call Hloop_Q_A(ntryL,G0H8(120),17,nMT,G1H8(148),n2h8(284))
  Gcoeff(:)%j = (-(c(39)*M(1,:)%j)) * den(23)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1009),h0tab(:,1009),[17,2,12],[nMB,nMW,nMW],3,2,wf4(:,11),wf4(:,18))
  call Hloop_WQ_A(ntryL,G0H32(1),wf4(:,11),G0H8(121),m3h4x8(:,539),heltab2x32(:,:,1009))
  call Hloop_Q_A(ntryL,G0H8(121),17,nMB,G1H8(149),n2h8(285))
  Gcoeff(:)%j = (-(c(57)*M(1,:)%j)) * den(21)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1010),h0tab(:,1010),[17,2,12],[nMT,nMZ,nMZ],3,2,wf4(:,11),wf4(:,17))
  call Hloop_SQ_A(ntryL,G0H32(1),wf4(:,11),G0H8(12),ngX,m3h4x8(:,540),heltab2x32(:,:,1010))
  call Hloop_Q_A(ntryL,G0H8(12),17,nMT,G1H8(150),n2h8(286))
  Gcoeff(:)%j = (-(c(39)*M(1,:)%j)) * den(21)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1011),h0tab(:,1011),[17,2,12],[nMB,nMW,nMW],3,2,wf4(:,11),wf4(:,17))
  call Hloop_SQ_A(ntryL,G0H32(1),wf4(:,11),G0H8(13),ngPbt,m3h4x8(:,541),heltab2x32(:,:,1011))
  call Hloop_Q_A(ntryL,G0H8(13),17,nMB,G1H8(151),n2h8(287))
  Gcoeff(:)%j = (c(57)*M(1,:)%j) * den(23)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1012),h0tab(:,1012),[17,2,12],[nMT,nMZ,nMH],3,2,wf4(:,11),wf4(:,18))
  call Hloop_SQ_A(ntryL,G0H32(1),wf4(:,11),G0H8(14),ngH,m3h4x8(:,542),heltab2x32(:,:,1012))
  call Hloop_Q_A(ntryL,G0H8(14),17,nMT,G1H8(152),n2h8(288))
  Gcoeff(:)%j = (c(39)*M(1,:)%j) * den(23)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1013),h0tab(:,1013),[17,2,12],[nMB,nMW,nMW],3,2,wf4(:,11),wf4(:,18))
  call Hloop_SQ_A(ntryL,G0H32(1),wf4(:,11),G0H8(27),ngPbt,m3h4x8(:,543),heltab2x32(:,:,1013))
  call Hloop_Q_A(ntryL,G0H8(27),17,nMB,G1H8(153),n2h8(289))
  Gcoeff(:)%j = (-(c(70)*M(1,:)%j)) * den(21)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1014),h0tab(:,1014),[17,2,12],[nMT,nMZ,nMZ],3,2,wf4(:,11),wf4(:,17))
  call Hloop_ZQ_A(ntryL,G0H32(1),wf4(:,11),G0H8(28),ngZu,m3h4x8(:,544),heltab2x32(:,:,1014))
  call Hloop_Q_A(ntryL,G0H8(28),17,nMT,G1H8(154),n2h8(290))
  Gcoeff(:)%j = (-(c(14)*M(1,:)%j)) * den(21)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1015),h0tab(:,1015),[17,2,12],[nMB,nMW,nMW],3,2,wf4(:,11),wf4(:,17))
  call Hloop_WQ_A(ntryL,G0H32(1),wf4(:,11),G0H8(29),m3h4x8(:,545),heltab2x32(:,:,1015))
  call Hloop_Q_A(ntryL,G0H8(29),17,nMB,G1H8(155),n2h8(291))
  Gcoeff(:)%j = (c(88)*M(1,:)%j) * den(25)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1016),h0tab(:,1016),[17,2,12],[nMH,nMT,nMT],3,2,wf4(:,11),wf4(:,19))
  call Hloop_AQ_S(ntryL,G0H32(1),wf4(:,11),G0H8(30),ngH,m3h4x8(:,546),heltab2x32(:,:,1016))
  Gcoeff(:)%j = (-(c(88)*M(1,:)%j)) * den(25)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1017),h0tab(:,1017),[17,2,12],[nMZ,nMT,nMT],3,2,wf4(:,11),wf4(:,19))
  call Hloop_AQ_S(ntryL,G0H32(1),wf4(:,11),G0H8(31),ngX,m3h4x8(:,547),heltab2x32(:,:,1017))
  Gcoeff(:)%j = (c(74)*M(1,:)%j) * den(25)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1018),h0tab(:,1018),[17,2,12],[nMW,nMB,nMB],3,2,wf4(:,11),wf4(:,19))
  call Hloop_AQ_S(ntryL,G0H32(1),wf4(:,11),G0H8(32),ngPbt,m3h4x8(:,548),heltab2x32(:,:,1018))
  Gcoeff(:)%j = (-(c(89)*M(1,:)%j)) * den(23)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1019),h0tab(:,1019),[17,2,12],[nMH,nMT,nMT],3,2,wf4(:,11),wf4(:,20))
  call Hloop_AQ_S(ntryL,G0H32(1),wf4(:,11),G0H8(37),ngH,m3h4x8(:,549),heltab2x32(:,:,1019))
  Gcoeff(:)%j = (c(89)*M(1,:)%j) * den(23)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1020),h0tab(:,1020),[17,2,12],[nMZ,nMT,nMT],3,2,wf4(:,11),wf4(:,20))
  call Hloop_AQ_S(ntryL,G0H32(1),wf4(:,11),G0H8(65),ngX,m3h4x8(:,550),heltab2x32(:,:,1020))
  Gcoeff(:)%j = (c(79)*M(1,:)%j) * den(23)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1021),h0tab(:,1021),[17,2,12],[nMW,nMB,nMB],3,2,wf4(:,11),wf4(:,20))
  call Hloop_AQ_S(ntryL,G0H32(1),wf4(:,11),G0H8(66),ngPbt,m3h4x8(:,551),heltab2x32(:,:,1021))
  Gcoeff(:)%j = (-(c(76)*M(1,:)%j)) * den(25)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1022),h0tab(:,1022),[17,2,12],[nMB,nMW,nMW],3,2,wf4(:,11),wf4(:,19))
  call Hloop_SQ_A(ntryL,G0H32(1),wf4(:,11),G0H8(67),ngPbt,m3h4x8(:,552),heltab2x32(:,:,1022))
  call Hloop_Q_A(ntryL,G0H8(67),17,nMB,G1H8(156),n2h8(292))
  Gcoeff(:)%j = (-(c(59)*M(1,:)%j)) * den(23)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1023),h0tab(:,1023),[17,2,12],[nMT,nMH,nMZ],3,2,wf4(:,11),wf4(:,20))
  call Hloop_SQ_A(ntryL,G0H32(1),wf4(:,11),G0H8(78),ngX,m3h4x8(:,553),heltab2x32(:,:,1023))
  call Hloop_Q_A(ntryL,G0H8(78),17,nMT,G1H8(157),n2h8(293))
  Gcoeff(:)%j = (-(c(59)*M(1,:)%j)) * den(23)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1024),h0tab(:,1024),[17,2,12],[nMT,nMZ,nMH],3,2,wf4(:,11),wf4(:,20))
  call Hloop_SQ_A(ntryL,G0H32(1),wf4(:,11),G0H8(81),ngH,m3h4x8(:,554),heltab2x32(:,:,1024))
  call Hloop_Q_A(ntryL,G0H8(81),17,nMT,G1H8(158),n2h8(294))
  Gcoeff(:)%j = (-(c(104)*M(1,:)%j)) * den(23)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1025),h0tab(:,1025),[17,2,12],[nMB,nMW,nMW],3,2,wf4(:,11),wf4(:,20))
  call Hloop_SQ_A(ntryL,G0H32(1),wf4(:,11),G0H8(106),ngPbt,m3h4x8(:,555),heltab2x32(:,:,1025))
  call Hloop_Q_A(ntryL,G0H8(106),17,nMB,G1H8(159),n2h8(295))
  Gcoeff(:)%j = (-(c(3)*M(1,:)%j)) * den(25)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1026),h0tab(:,1026),[17,2,12],[0,nMT,nMT],3,2,wf4(:,11),wf4(:,19))
  call Hloop_AQ_V(ntryL,G0H32(1),wf4(:,11),G0H8(107),m3h4x8(:,556),heltab2x32(:,:,1026))
  Gcoeff(:)%j = (-(c(5)*M(1,:)%j)) * den(25)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1027),h0tab(:,1027),[17,2,12],[nMZ,nMT,nMT],3,2,wf4(:,11),wf4(:,19))
  call Hloop_AQ_Z(ntryL,G0H32(1),wf4(:,11),G0H8(120),ngZu,m3h4x8(:,557),heltab2x32(:,:,1027))
  Gcoeff(:)%j = (c(60)*M(1,:)%j) * den(25)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1028),h0tab(:,1028),[17,2,12],[nMW,nMB,nMB],3,2,wf4(:,11),wf4(:,19))
  call Hloop_AQ_W(ntryL,G0H32(1),wf4(:,11),G0H8(121),m3h4x8(:,558),heltab2x32(:,:,1028))
  Gcoeff(:)%j = (c(6)*M(1,:)%j) * den(23)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1029),h0tab(:,1029),[17,2,12],[0,nMT,nMT],3,2,wf4(:,11),wf4(:,20))
  call Hloop_AQ_V(ntryL,G0H32(1),wf4(:,11),G0H8(12),m3h4x8(:,559),heltab2x32(:,:,1029))
  Gcoeff(:)%j = (c(7)*M(1,:)%j) * den(23)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1030),h0tab(:,1030),[17,2,12],[nMZ,nMT,nMT],3,2,wf4(:,11),wf4(:,20))
  call Hloop_AQ_Z(ntryL,G0H32(1),wf4(:,11),G0H8(13),ngZu,m3h4x8(:,560),heltab2x32(:,:,1030))
  Gcoeff(:)%j = (c(65)*M(1,:)%j) * den(23)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1031),h0tab(:,1031),[17,2,12],[nMW,nMB,nMB],3,2,wf4(:,11),wf4(:,20))
  call Hloop_AQ_W(ntryL,G0H32(1),wf4(:,11),G0H8(14),m3h4x8(:,561),heltab2x32(:,:,1031))
  Gcoeff(:)%j = (-(c(62)*M(1,:)%j)) * den(25)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1032),h0tab(:,1032),[17,2,12],[nMB,nMW,nMW],3,2,wf4(:,11),wf4(:,19))
  call Hloop_WQ_A(ntryL,G0H32(1),wf4(:,11),G0H8(27),m3h4x8(:,562),heltab2x32(:,:,1032))
  call Hloop_Q_A(ntryL,G0H8(27),17,nMB,G1H8(160),n2h8(296))
  Gcoeff(:)%j = (-(c(73)*M(1,:)%j)) * den(23)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1033),h0tab(:,1033),[17,2,12],[nMT,nMH,nMZ],3,2,wf4(:,11),wf4(:,20))
  call Hloop_ZQ_A(ntryL,G0H32(1),wf4(:,11),G0H8(28),ngZu,m3h4x8(:,563),heltab2x32(:,:,1033))
  call Hloop_Q_A(ntryL,G0H8(28),17,nMT,G1H8(161),n2h8(297))
  Gcoeff(:)%j = (-(c(92)*M(1,:)%j)) * den(23)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1034),h0tab(:,1034),[17,2,12],[nMB,nMW,nMW],3,2,wf4(:,11),wf4(:,20))
  call Hloop_WQ_A(ntryL,G0H32(1),wf4(:,11),G0H8(29),m3h4x8(:,564),heltab2x32(:,:,1034))
  call Hloop_Q_A(ntryL,G0H8(29),17,nMB,G1H8(162),n2h8(298))
  Gcoeff(:)%j = (c(62)*M(1,:)%j) * den(25)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1035),h0tab(:,1035),[17,2,12],[nMB,nMW,nMW],3,2,wf4(:,11),wf4(:,19))
  call Hloop_SQ_A(ntryL,G0H32(1),wf4(:,11),G0H8(67),ngPbt,m3h4x8(:,565),heltab2x32(:,:,1035))
  call Hloop_Q_A(ntryL,G0H8(67),17,nMB,G1H8(163),n2h8(299))
  Gcoeff(:)%j = (-(c(73)*M(1,:)%j)) * den(23)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1036),h0tab(:,1036),[17,2,12],[nMT,nMZ,nMH],3,2,wf4(:,11),wf4(:,20))
  call Hloop_SQ_A(ntryL,G0H32(1),wf4(:,11),G0H8(78),ngH,m3h4x8(:,566),heltab2x32(:,:,1036))
  call Hloop_Q_A(ntryL,G0H8(78),17,nMT,G1H8(164),n2h8(300))
  Gcoeff(:)%j = (c(92)*M(1,:)%j) * den(23)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1037),h0tab(:,1037),[17,2,12],[nMB,nMW,nMW],3,2,wf4(:,11),wf4(:,20))
  call Hloop_SQ_A(ntryL,G0H32(1),wf4(:,11),G0H8(81),ngPbt,m3h4x8(:,567),heltab2x32(:,:,1037))
  call Hloop_Q_A(ntryL,G0H8(81),17,nMB,G1H8(165),n2h8(301))
  Gcoeff(:)%j = (-(c(62)*M(1,:)%j)) * den(25)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1038),h0tab(:,1038),[17,2,12],[nMB,nMW,nMW],3,2,wf4(:,11),wf4(:,19))
  call Hloop_WQ_A(ntryL,G0H32(1),wf4(:,11),G0H8(106),m3h4x8(:,568),heltab2x32(:,:,1038))
  call Hloop_Q_A(ntryL,G0H8(106),17,nMB,G1H8(166),n2h8(302))
  Gcoeff(:)%j = (c(48)*M(1,:)%j) * den(23)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1039),h0tab(:,1039),[17,2,12],[nMB,nMW,nMW],3,2,wf4(:,11),wf4(:,20))
  call Hloop_WQ_A(ntryL,G0H32(1),wf4(:,11),G0H8(27),m3h4x8(:,569),heltab2x32(:,:,1039))
  call Hloop_Q_A(ntryL,G0H8(27),17,nMB,G1H8(167),n2h8(303))
  Gcoeff(:)%j = (c(36)*M(1,:)%j) * den(26)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1040),h0tab(:,1040),[18,1,12],[nMH,nMT,nMT],3,2,wf4(:,15),wf4(:,17))
  call Hloop_QA_S(ntryL,G0H32(1),wf4(:,15),G0H8(28),ngH,m3h4x8(:,570),heltab2x32(:,:,1040))
  Gcoeff(:)%j = (-(c(36)*M(1,:)%j)) * den(26)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1041),h0tab(:,1041),[18,1,12],[nMZ,nMT,nMT],3,2,wf4(:,15),wf4(:,17))
  call Hloop_QA_S(ntryL,G0H32(1),wf4(:,15),G0H8(29),ngX,m3h4x8(:,571),heltab2x32(:,:,1041))
  Gcoeff(:)%j = (-(c(21)*M(1,:)%j)) * den(26)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1042),h0tab(:,1042),[18,1,12],[nMW,nMB,nMB],3,2,wf4(:,15),wf4(:,17))
  call Hloop_QA_S(ntryL,G0H32(1),wf4(:,15),G0H8(67),ngPtb,m3h4x8(:,572),heltab2x32(:,:,1042))
  Gcoeff(:)%j = (c(36)*M(1,:)%j) * den(27)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1043),h0tab(:,1043),[18,1,12],[nMH,nMT,nMT],3,2,wf4(:,15),wf4(:,18))
  call Hloop_QA_S(ntryL,G0H32(1),wf4(:,15),G0H8(78),ngH,m3h4x8(:,573),heltab2x32(:,:,1043))
  Gcoeff(:)%j = (-(c(36)*M(1,:)%j)) * den(27)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1044),h0tab(:,1044),[18,1,12],[nMZ,nMT,nMT],3,2,wf4(:,15),wf4(:,18))
  call Hloop_QA_S(ntryL,G0H32(1),wf4(:,15),G0H8(81),ngX,m3h4x8(:,574),heltab2x32(:,:,1044))
  Gcoeff(:)%j = (c(21)*M(1,:)%j) * den(27)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1045),h0tab(:,1045),[18,1,12],[nMW,nMB,nMB],3,2,wf4(:,15),wf4(:,18))
  call Hloop_QA_S(ntryL,G0H32(1),wf4(:,15),G0H8(106),ngPtb,m3h4x8(:,575),heltab2x32(:,:,1045))
  Gcoeff(:)%j = (c(35)*M(1,:)%j) * den(26)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1046),h0tab(:,1046),[18,1,12],[nMT,nMH,nMH],3,2,wf4(:,15),wf4(:,17))
  call Hloop_SA_Q(ntryL,G0H32(1),wf4(:,15),G0H8(27),ngH,m3h4x8(:,576),heltab2x32(:,:,1046))
  call Hloop_A_Q(ntryL,G0H8(27),18,nMT,G1H8(168),n2h8(304))
  Gcoeff(:)%j = (-(c(34)*M(1,:)%j)) * den(26)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1047),h0tab(:,1047),[18,1,12],[nMT,nMZ,nMZ],3,2,wf4(:,15),wf4(:,17))
  call Hloop_SA_Q(ntryL,G0H32(1),wf4(:,15),G0H8(27),ngX,m3h4x8(:,577),heltab2x32(:,:,1047))
  call Hloop_A_Q(ntryL,G0H8(27),18,nMT,G1H8(169),n2h8(305))
  Gcoeff(:)%j = (-(c(22)*M(1,:)%j)) * den(26)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1048),h0tab(:,1048),[18,1,12],[nMB,nMW,nMW],3,2,wf4(:,15),wf4(:,17))
  call Hloop_SA_Q(ntryL,G0H32(1),wf4(:,15),G0H8(27),ngPtb,m3h4x8(:,578),heltab2x32(:,:,1048))
  call Hloop_A_Q(ntryL,G0H8(27),18,nMB,G1H8(170),n2h8(306))
  Gcoeff(:)%j = (c(34)*M(1,:)%j) * den(27)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1049),h0tab(:,1049),[18,1,12],[nMT,nMH,nMZ],3,2,wf4(:,15),wf4(:,18))
  call Hloop_SA_Q(ntryL,G0H32(1),wf4(:,15),G0H8(27),ngX,m3h4x8(:,579),heltab2x32(:,:,1049))
  call Hloop_A_Q(ntryL,G0H8(27),18,nMT,G1H8(171),n2h8(307))
  Gcoeff(:)%j = (c(34)*M(1,:)%j) * den(27)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1050),h0tab(:,1050),[18,1,12],[nMT,nMZ,nMH],3,2,wf4(:,15),wf4(:,18))
  call Hloop_SA_Q(ntryL,G0H32(1),wf4(:,15),G0H8(27),ngH,m3h4x8(:,580),heltab2x32(:,:,1050))
  call Hloop_A_Q(ntryL,G0H8(27),18,nMT,G1H8(172),n2h8(308))
  Gcoeff(:)%j = (-(c(85)*M(1,:)%j)) * den(26)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1051),h0tab(:,1051),[18,1,12],[0,nMT,nMT],3,2,wf4(:,15),wf4(:,17))
  call Hloop_QA_V(ntryL,G0H32(1),wf4(:,15),G0H8(27),m3h4x8(:,581),heltab2x32(:,:,1051))
  Gcoeff(:)%j = (-(c(86)*M(1,:)%j)) * den(26)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1052),h0tab(:,1052),[18,1,12],[nMZ,nMT,nMT],3,2,wf4(:,15),wf4(:,17))
  call Hloop_QA_Z(ntryL,G0H32(1),wf4(:,15),G0H8(138),ngZu,m3h4x8(:,582),heltab2x32(:,:,1052))
  Gcoeff(:)%j = (-(c(40)*M(1,:)%j)) * den(26)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1053),h0tab(:,1053),[18,1,12],[nMW,nMB,nMB],3,2,wf4(:,15),wf4(:,17))
  call Hloop_QA_W(ntryL,G0H32(1),wf4(:,15),G0H8(139),m3h4x8(:,583),heltab2x32(:,:,1053))
  Gcoeff(:)%j = (-(c(85)*M(1,:)%j)) * den(27)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1054),h0tab(:,1054),[18,1,12],[0,nMT,nMT],3,2,wf4(:,15),wf4(:,18))
  call Hloop_QA_V(ntryL,G0H32(1),wf4(:,15),G0H8(140),m3h4x8(:,584),heltab2x32(:,:,1054))
  Gcoeff(:)%j = (-(c(86)*M(1,:)%j)) * den(27)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1055),h0tab(:,1055),[18,1,12],[nMZ,nMT,nMT],3,2,wf4(:,15),wf4(:,18))
  call Hloop_QA_Z(ntryL,G0H32(1),wf4(:,15),G0H8(141),ngZu,m3h4x8(:,585),heltab2x32(:,:,1055))
  Gcoeff(:)%j = (c(40)*M(1,:)%j) * den(27)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1056),h0tab(:,1056),[18,1,12],[nMW,nMB,nMB],3,2,wf4(:,15),wf4(:,18))
  call Hloop_QA_W(ntryL,G0H32(1),wf4(:,15),G0H8(142),m3h4x8(:,586),heltab2x32(:,:,1056))
  Gcoeff(:)%j = (-(c(57)*M(1,:)%j)) * den(26)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1057),h0tab(:,1057),[18,1,12],[nMT,nMZ,nMZ],3,2,wf4(:,15),wf4(:,17))
  call Hloop_ZA_Q(ntryL,G0H32(1),wf4(:,15),G0H8(143),ngZu,m3h4x8(:,587),heltab2x32(:,:,1057))
  call Hloop_A_Q(ntryL,G0H8(143),18,nMT,G1H8(173),n2h8(309))
  Gcoeff(:)%j = (-(c(39)*M(1,:)%j)) * den(26)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1058),h0tab(:,1058),[18,1,12],[nMB,nMW,nMW],3,2,wf4(:,15),wf4(:,17))
  call Hloop_WA_Q(ntryL,G0H32(1),wf4(:,15),G0H8(143),m3h4x8(:,588),heltab2x32(:,:,1058))
  call Hloop_A_Q(ntryL,G0H8(143),18,nMB,G1H8(174),n2h8(310))
  Gcoeff(:)%j = (c(57)*M(1,:)%j) * den(27)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1059),h0tab(:,1059),[18,1,12],[nMT,nMH,nMZ],3,2,wf4(:,15),wf4(:,18))
  call Hloop_ZA_Q(ntryL,G0H32(1),wf4(:,15),G0H8(143),ngZu,m3h4x8(:,589),heltab2x32(:,:,1059))
  call Hloop_A_Q(ntryL,G0H8(143),18,nMT,G1H8(175),n2h8(311))
  Gcoeff(:)%j = (c(39)*M(1,:)%j) * den(27)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1060),h0tab(:,1060),[18,1,12],[nMB,nMW,nMW],3,2,wf4(:,15),wf4(:,18))
  call Hloop_WA_Q(ntryL,G0H32(1),wf4(:,15),G0H8(143),m3h4x8(:,590),heltab2x32(:,:,1060))
  call Hloop_A_Q(ntryL,G0H8(143),18,nMB,G1H8(176),n2h8(312))
  Gcoeff(:)%j = (-(c(57)*M(1,:)%j)) * den(26)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1061),h0tab(:,1061),[18,1,12],[nMT,nMZ,nMZ],3,2,wf4(:,15),wf4(:,17))
  call Hloop_SA_Q(ntryL,G0H32(1),wf4(:,15),G0H8(143),ngX,m3h4x8(:,591),heltab2x32(:,:,1061))
  call Hloop_A_Q(ntryL,G0H8(143),18,nMT,G1H8(177),n2h8(313))
  Gcoeff(:)%j = (-(c(39)*M(1,:)%j)) * den(26)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1062),h0tab(:,1062),[18,1,12],[nMB,nMW,nMW],3,2,wf4(:,15),wf4(:,17))
  call Hloop_SA_Q(ntryL,G0H32(1),wf4(:,15),G0H8(143),ngPtb,m3h4x8(:,592),heltab2x32(:,:,1062))
  call Hloop_A_Q(ntryL,G0H8(143),18,nMB,G1H8(178),n2h8(314))
  Gcoeff(:)%j = (c(57)*M(1,:)%j) * den(27)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1063),h0tab(:,1063),[18,1,12],[nMT,nMZ,nMH],3,2,wf4(:,15),wf4(:,18))
  call Hloop_SA_Q(ntryL,G0H32(1),wf4(:,15),G0H8(143),ngH,m3h4x8(:,593),heltab2x32(:,:,1063))
  call Hloop_A_Q(ntryL,G0H8(143),18,nMT,G1H8(179),n2h8(315))
  Gcoeff(:)%j = (-(c(39)*M(1,:)%j)) * den(27)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1064),h0tab(:,1064),[18,1,12],[nMB,nMW,nMW],3,2,wf4(:,15),wf4(:,18))
  call Hloop_SA_Q(ntryL,G0H32(1),wf4(:,15),G0H8(143),ngPtb,m3h4x8(:,594),heltab2x32(:,:,1064))
  call Hloop_A_Q(ntryL,G0H8(143),18,nMB,G1H8(180),n2h8(316))
  Gcoeff(:)%j = (-(c(70)*M(1,:)%j)) * den(26)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1065),h0tab(:,1065),[18,1,12],[nMT,nMZ,nMZ],3,2,wf4(:,15),wf4(:,17))
  call Hloop_ZA_Q(ntryL,G0H32(1),wf4(:,15),G0H8(143),ngZu,m3h4x8(:,595),heltab2x32(:,:,1065))
  call Hloop_A_Q(ntryL,G0H8(143),18,nMT,G1H8(181),n2h8(317))
  Gcoeff(:)%j = (-(c(14)*M(1,:)%j)) * den(26)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1066),h0tab(:,1066),[18,1,12],[nMB,nMW,nMW],3,2,wf4(:,15),wf4(:,17))
  call Hloop_WA_Q(ntryL,G0H32(1),wf4(:,15),G0H8(143),m3h4x8(:,596),heltab2x32(:,:,1066))
  call Hloop_A_Q(ntryL,G0H8(143),18,nMB,G1H8(182),n2h8(318))
  Gcoeff(:)%j = (c(88)*M(1,:)%j) * den(28)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1067),h0tab(:,1067),[18,1,12],[nMH,nMT,nMT],3,2,wf4(:,15),wf4(:,19))
  call Hloop_QA_S(ntryL,G0H32(1),wf4(:,15),G0H8(143),ngH,m3h4x8(:,597),heltab2x32(:,:,1067))
  Gcoeff(:)%j = (-(c(88)*M(1,:)%j)) * den(28)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1068),h0tab(:,1068),[18,1,12],[nMZ,nMT,nMT],3,2,wf4(:,15),wf4(:,19))
  call Hloop_QA_S(ntryL,G0H32(1),wf4(:,15),G0H8(144),ngX,m3h4x8(:,598),heltab2x32(:,:,1068))
  Gcoeff(:)%j = (c(74)*M(1,:)%j) * den(28)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1069),h0tab(:,1069),[18,1,12],[nMW,nMB,nMB],3,2,wf4(:,15),wf4(:,19))
  call Hloop_QA_S(ntryL,G0H32(1),wf4(:,15),G0H8(145),ngPtb,m3h4x8(:,599),heltab2x32(:,:,1069))
  Gcoeff(:)%j = (-(c(89)*M(1,:)%j)) * den(27)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1070),h0tab(:,1070),[18,1,12],[nMH,nMT,nMT],3,2,wf4(:,15),wf4(:,20))
  call Hloop_QA_S(ntryL,G0H32(1),wf4(:,15),G0H8(146),ngH,m3h4x8(:,600),heltab2x32(:,:,1070))
  Gcoeff(:)%j = (c(89)*M(1,:)%j) * den(27)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1071),h0tab(:,1071),[18,1,12],[nMZ,nMT,nMT],3,2,wf4(:,15),wf4(:,20))
  call Hloop_QA_S(ntryL,G0H32(1),wf4(:,15),G0H8(147),ngX,m3h4x8(:,601),heltab2x32(:,:,1071))
  Gcoeff(:)%j = (c(79)*M(1,:)%j) * den(27)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1072),h0tab(:,1072),[18,1,12],[nMW,nMB,nMB],3,2,wf4(:,15),wf4(:,20))
  call Hloop_QA_S(ntryL,G0H32(1),wf4(:,15),G0H8(148),ngPtb,m3h4x8(:,602),heltab2x32(:,:,1072))
  Gcoeff(:)%j = (-(c(76)*M(1,:)%j)) * den(28)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1073),h0tab(:,1073),[18,1,12],[nMB,nMW,nMW],3,2,wf4(:,15),wf4(:,19))
  call Hloop_SA_Q(ntryL,G0H32(1),wf4(:,15),G0H8(149),ngPtb,m3h4x8(:,603),heltab2x32(:,:,1073))
  call Hloop_A_Q(ntryL,G0H8(149),18,nMB,G1H8(183),n2h8(319))
  Gcoeff(:)%j = (-(c(59)*M(1,:)%j)) * den(27)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1074),h0tab(:,1074),[18,1,12],[nMT,nMH,nMZ],3,2,wf4(:,15),wf4(:,20))
  call Hloop_SA_Q(ntryL,G0H32(1),wf4(:,15),G0H8(149),ngX,m3h4x8(:,604),heltab2x32(:,:,1074))
  call Hloop_A_Q(ntryL,G0H8(149),18,nMT,G1H8(184),n2h8(320))
  Gcoeff(:)%j = (-(c(59)*M(1,:)%j)) * den(27)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1075),h0tab(:,1075),[18,1,12],[nMT,nMZ,nMH],3,2,wf4(:,15),wf4(:,20))
  call Hloop_SA_Q(ntryL,G0H32(1),wf4(:,15),G0H8(149),ngH,m3h4x8(:,605),heltab2x32(:,:,1075))
  call Hloop_A_Q(ntryL,G0H8(149),18,nMT,G1H8(185),n2h8(321))
  Gcoeff(:)%j = (-(c(104)*M(1,:)%j)) * den(27)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1076),h0tab(:,1076),[18,1,12],[nMB,nMW,nMW],3,2,wf4(:,15),wf4(:,20))
  call Hloop_SA_Q(ntryL,G0H32(1),wf4(:,15),G0H8(149),ngPtb,m3h4x8(:,606),heltab2x32(:,:,1076))
  call Hloop_A_Q(ntryL,G0H8(149),18,nMB,G1H8(186),n2h8(322))
  Gcoeff(:)%j = (-(c(3)*M(1,:)%j)) * den(28)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1077),h0tab(:,1077),[18,1,12],[0,nMT,nMT],3,2,wf4(:,15),wf4(:,19))
  call Hloop_QA_V(ntryL,G0H32(1),wf4(:,15),G0H8(149),m3h4x8(:,607),heltab2x32(:,:,1077))
  Gcoeff(:)%j = (-(c(5)*M(1,:)%j)) * den(28)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1078),h0tab(:,1078),[18,1,12],[nMZ,nMT,nMT],3,2,wf4(:,15),wf4(:,19))
  call Hloop_QA_Z(ntryL,G0H32(1),wf4(:,15),G0H8(150),ngZu,m3h4x8(:,608),heltab2x32(:,:,1078))
  Gcoeff(:)%j = (c(60)*M(1,:)%j) * den(28)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1079),h0tab(:,1079),[18,1,12],[nMW,nMB,nMB],3,2,wf4(:,15),wf4(:,19))
  call Hloop_QA_W(ntryL,G0H32(1),wf4(:,15),G0H8(151),m3h4x8(:,609),heltab2x32(:,:,1079))
  Gcoeff(:)%j = (c(6)*M(1,:)%j) * den(27)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1080),h0tab(:,1080),[18,1,12],[0,nMT,nMT],3,2,wf4(:,15),wf4(:,20))
  call Hloop_QA_V(ntryL,G0H32(1),wf4(:,15),G0H8(152),m3h4x8(:,610),heltab2x32(:,:,1080))
  Gcoeff(:)%j = (c(7)*M(1,:)%j) * den(27)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1081),h0tab(:,1081),[18,1,12],[nMZ,nMT,nMT],3,2,wf4(:,15),wf4(:,20))
  call Hloop_QA_Z(ntryL,G0H32(1),wf4(:,15),G0H8(153),ngZu,m3h4x8(:,611),heltab2x32(:,:,1081))
  Gcoeff(:)%j = (c(65)*M(1,:)%j) * den(27)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1082),h0tab(:,1082),[18,1,12],[nMW,nMB,nMB],3,2,wf4(:,15),wf4(:,20))
  call Hloop_QA_W(ntryL,G0H32(1),wf4(:,15),G0H8(154),m3h4x8(:,612),heltab2x32(:,:,1082))
  Gcoeff(:)%j = (c(62)*M(1,:)%j) * den(28)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1083),h0tab(:,1083),[18,1,12],[nMB,nMW,nMW],3,2,wf4(:,15),wf4(:,19))
  call Hloop_WA_Q(ntryL,G0H32(1),wf4(:,15),G0H8(155),m3h4x8(:,613),heltab2x32(:,:,1083))
  call Hloop_A_Q(ntryL,G0H8(155),18,nMB,G1H8(187),n2h8(323))
  Gcoeff(:)%j = (-(c(73)*M(1,:)%j)) * den(27)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1084),h0tab(:,1084),[18,1,12],[nMT,nMH,nMZ],3,2,wf4(:,15),wf4(:,20))
  call Hloop_ZA_Q(ntryL,G0H32(1),wf4(:,15),G0H8(155),ngZu,m3h4x8(:,614),heltab2x32(:,:,1084))
  call Hloop_A_Q(ntryL,G0H8(155),18,nMT,G1H8(188),n2h8(324))
  Gcoeff(:)%j = (c(92)*M(1,:)%j) * den(27)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1085),h0tab(:,1085),[18,1,12],[nMB,nMW,nMW],3,2,wf4(:,15),wf4(:,20))
  call Hloop_WA_Q(ntryL,G0H32(1),wf4(:,15),G0H8(155),m3h4x8(:,615),heltab2x32(:,:,1085))
  call Hloop_A_Q(ntryL,G0H8(155),18,nMB,G1H8(189),n2h8(325))
  Gcoeff(:)%j = (-(c(62)*M(1,:)%j)) * den(28)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1086),h0tab(:,1086),[18,1,12],[nMB,nMW,nMW],3,2,wf4(:,15),wf4(:,19))
  call Hloop_SA_Q(ntryL,G0H32(1),wf4(:,15),G0H8(155),ngPtb,m3h4x8(:,616),heltab2x32(:,:,1086))
  call Hloop_A_Q(ntryL,G0H8(155),18,nMB,G1H8(190),n2h8(326))
  Gcoeff(:)%j = (-(c(73)*M(1,:)%j)) * den(27)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1087),h0tab(:,1087),[18,1,12],[nMT,nMZ,nMH],3,2,wf4(:,15),wf4(:,20))
  call Hloop_SA_Q(ntryL,G0H32(1),wf4(:,15),G0H8(155),ngH,m3h4x8(:,617),heltab2x32(:,:,1087))
  call Hloop_A_Q(ntryL,G0H8(155),18,nMT,G1H8(191),n2h8(327))
  Gcoeff(:)%j = (-(c(92)*M(1,:)%j)) * den(27)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1088),h0tab(:,1088),[18,1,12],[nMB,nMW,nMW],3,2,wf4(:,15),wf4(:,20))
  call Hloop_SA_Q(ntryL,G0H32(1),wf4(:,15),G0H8(155),ngPtb,m3h4x8(:,618),heltab2x32(:,:,1088))
  call Hloop_A_Q(ntryL,G0H8(155),18,nMB,G1H8(192),n2h8(328))
  Gcoeff(:)%j = (-(c(62)*M(1,:)%j)) * den(28)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1089),h0tab(:,1089),[18,1,12],[nMB,nMW,nMW],3,2,wf4(:,15),wf4(:,19))
  call Hloop_WA_Q(ntryL,G0H32(1),wf4(:,15),G0H8(155),m3h4x8(:,619),heltab2x32(:,:,1089))
  call Hloop_A_Q(ntryL,G0H8(155),18,nMB,G1H8(193),n2h8(329))
  Gcoeff(:)%j = (c(48)*M(1,:)%j) * den(27)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1090),h0tab(:,1090),[18,1,12],[nMB,nMW,nMW],3,2,wf4(:,15),wf4(:,20))
  call Hloop_WA_Q(ntryL,G0H32(1),wf4(:,15),G0H8(155),m3h4x8(:,620),heltab2x32(:,:,1090))
  call Hloop_A_Q(ntryL,G0H8(155),18,nMB,G1H8(194),n2h8(330))
  Gcoeff(:)%j = (c(36)*M(1,:)%j) * den(99)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1091),h0tab(:,1091),[16,2,13],[nMT,nMH,nMT],3,1,wf8(:,114))
  call Hloop_QV_A(ntryL,G0H32(1),ex5(:),G0H16(1),m3h2x16(:,471),heltab2x32(:,:,1091))
  call Hloop_Q_A(ntryL,G0H16(1),16,nMT,G1H16(97),n2h16(471))
  Gcoeff(:)%j = (-(c(36)*M(1,:)%j)) * den(99)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1092),h0tab(:,1092),[16,2,13],[nMT,nMZ,nMT],3,1,wf8(:,114))
  call Hloop_QV_A(ntryL,G0H32(1),ex5(:),G0H16(1),m3h2x16(:,472),heltab2x32(:,:,1092))
  call Hloop_Q_A(ntryL,G0H16(1),16,nMT,G1H16(98),n2h16(472))
  Gcoeff(:)%j = (-(c(24)*M(1,:)%j)) * den(99)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1093),h0tab(:,1093),[16,2,13],[nMB,nMW,nMB],3,1,wf8(:,114))
  call Hloop_QV_A(ntryL,G0H32(1),ex5(:),G0H16(1),m3h2x16(:,473),heltab2x32(:,:,1093))
  call Hloop_Q_A(ntryL,G0H16(1),16,nMB,G1H16(99),n2h16(473))
  Gcoeff(:)%j = (c(36)*M(1,:)%j) * den(101)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1094),h0tab(:,1094),[16,2,13],[nMT,nMH,nMT],3,1,wf8(:,116))
  call Hloop_QV_A(ntryL,G0H32(1),ex5(:),G0H16(1),m3h2x16(:,474),heltab2x32(:,:,1094))
  call Hloop_Q_A(ntryL,G0H16(1),16,nMT,G1H16(100),n2h16(474))
  Gcoeff(:)%j = (-(c(36)*M(1,:)%j)) * den(101)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1095),h0tab(:,1095),[16,2,13],[nMT,nMZ,nMT],3,1,wf8(:,116))
  call Hloop_QV_A(ntryL,G0H32(1),ex5(:),G0H16(1),m3h2x16(:,475),heltab2x32(:,:,1095))
  call Hloop_Q_A(ntryL,G0H16(1),16,nMT,G1H16(101),n2h16(475))
  Gcoeff(:)%j = (-(c(24)*M(1,:)%j)) * den(101)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1096),h0tab(:,1096),[16,2,13],[nMB,nMW,nMB],3,1,wf8(:,116))
  call Hloop_QV_A(ntryL,G0H32(1),ex5(:),G0H16(1),m3h2x16(:,476),heltab2x32(:,:,1096))
  call Hloop_Q_A(ntryL,G0H16(1),16,nMB,G1H16(102),n2h16(476))
  Gcoeff(:)%j = (-(c(85)*M(1,:)%j)) * den(99)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1097),h0tab(:,1097),[16,2,13],[nMT,0,nMT],3,1,wf8(:,114))
  call Hloop_QV_A(ntryL,G0H32(1),ex5(:),G0H16(1),m3h2x16(:,477),heltab2x32(:,:,1097))
  call Hloop_Q_A(ntryL,G0H16(1),16,nMT,G1H16(103),n2h16(477))
  Gcoeff(:)%j = (-(c(86)*M(1,:)%j)) * den(99)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1098),h0tab(:,1098),[16,2,13],[nMT,nMZ,nMT],3,1,wf8(:,114))
  call Hloop_QV_A(ntryL,G0H32(1),ex5(:),G0H16(1),m3h2x16(:,478),heltab2x32(:,:,1098))
  call Hloop_Q_A(ntryL,G0H16(1),16,nMT,G1H16(104),n2h16(478))
  Gcoeff(:)%j = (-(c(44)*M(1,:)%j)) * den(99)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1099),h0tab(:,1099),[16,2,13],[nMB,nMW,nMB],3,1,wf8(:,114))
  call Hloop_QV_A(ntryL,G0H32(1),ex5(:),G0H16(1),m3h2x16(:,479),heltab2x32(:,:,1099))
  call Hloop_Q_A(ntryL,G0H16(1),16,nMB,G1H16(105),n2h16(479))
  Gcoeff(:)%j = (-(c(85)*M(1,:)%j)) * den(101)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1100),h0tab(:,1100),[16,2,13],[nMT,0,nMT],3,1,wf8(:,116))
  call Hloop_QV_A(ntryL,G0H32(1),ex5(:),G0H16(1),m3h2x16(:,480),heltab2x32(:,:,1100))
  call Hloop_Q_A(ntryL,G0H16(1),16,nMT,G1H16(106),n2h16(480))
  Gcoeff(:)%j = (-(c(86)*M(1,:)%j)) * den(101)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1101),h0tab(:,1101),[16,2,13],[nMT,nMZ,nMT],3,1,wf8(:,116))
  call Hloop_QV_A(ntryL,G0H32(1),ex5(:),G0H16(1),m3h2x16(:,481),heltab2x32(:,:,1101))
  call Hloop_Q_A(ntryL,G0H16(1),16,nMT,G1H16(107),n2h16(481))
  Gcoeff(:)%j = (-(c(44)*M(1,:)%j)) * den(101)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1102),h0tab(:,1102),[16,2,13],[nMB,nMW,nMB],3,1,wf8(:,116))
  call Hloop_QV_A(ntryL,G0H32(1),ex5(:),G0H16(1),m3h2x16(:,482),heltab2x32(:,:,1102))
  call Hloop_Q_A(ntryL,G0H16(1),16,nMB,G1H16(108),n2h16(482))
  Gcoeff(:)%j = (c(88)*M(1,:)%j) * den(103)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1103),h0tab(:,1103),[16,2,13],[nMT,nMH,nMT],3,1,wf8(:,118))
  call Hloop_QV_A(ntryL,G0H32(1),ex5(:),G0H16(1),m3h2x16(:,483),heltab2x32(:,:,1103))
  call Hloop_Q_A(ntryL,G0H16(1),16,nMT,G1H16(109),n2h16(483))
  Gcoeff(:)%j = (-(c(88)*M(1,:)%j)) * den(103)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1104),h0tab(:,1104),[16,2,13],[nMT,nMZ,nMT],3,1,wf8(:,118))
  call Hloop_QV_A(ntryL,G0H32(1),ex5(:),G0H16(1),m3h2x16(:,484),heltab2x32(:,:,1104))
  call Hloop_Q_A(ntryL,G0H16(1),16,nMT,G1H16(110),n2h16(484))
  Gcoeff(:)%j = (-(c(75)*M(1,:)%j)) * den(103)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1105),h0tab(:,1105),[16,2,13],[nMB,nMW,nMB],3,1,wf8(:,118))
  call Hloop_QV_A(ntryL,G0H32(1),ex5(:),G0H16(1),m3h2x16(:,485),heltab2x32(:,:,1105))
  call Hloop_Q_A(ntryL,G0H16(1),16,nMB,G1H16(111),n2h16(485))
  Gcoeff(:)%j = (-(c(89)*M(1,:)%j)) * den(101)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1106),h0tab(:,1106),[16,2,13],[nMT,nMH,nMT],3,1,wf8(:,120))
  call Hloop_QV_A(ntryL,G0H32(1),ex5(:),G0H16(1),m3h2x16(:,486),heltab2x32(:,:,1106))
  call Hloop_Q_A(ntryL,G0H16(1),16,nMT,G1H16(112),n2h16(486))
  Gcoeff(:)%j = (c(89)*M(1,:)%j) * den(101)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1107),h0tab(:,1107),[16,2,13],[nMT,nMZ,nMT],3,1,wf8(:,120))
  call Hloop_QV_A(ntryL,G0H32(1),ex5(:),G0H16(1),m3h2x16(:,487),heltab2x32(:,:,1107))
  call Hloop_Q_A(ntryL,G0H16(1),16,nMT,G1H16(113),n2h16(487))
  Gcoeff(:)%j = (c(79)*M(1,:)%j) * den(101)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1108),h0tab(:,1108),[16,2,13],[nMB,nMW,nMB],3,1,wf8(:,120))
  call Hloop_QV_A(ntryL,G0H32(1),ex5(:),G0H16(1),m3h2x16(:,488),heltab2x32(:,:,1108))
  call Hloop_Q_A(ntryL,G0H16(1),16,nMB,G1H16(114),n2h16(488))
  Gcoeff(:)%j = (-(c(3)*M(1,:)%j)) * den(103)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1109),h0tab(:,1109),[16,2,13],[nMT,0,nMT],3,1,wf8(:,118))
  call Hloop_QV_A(ntryL,G0H32(1),ex5(:),G0H16(1),m3h2x16(:,489),heltab2x32(:,:,1109))
  call Hloop_Q_A(ntryL,G0H16(1),16,nMT,G1H16(115),n2h16(489))
  Gcoeff(:)%j = (-(c(5)*M(1,:)%j)) * den(103)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1110),h0tab(:,1110),[16,2,13],[nMT,nMZ,nMT],3,1,wf8(:,118))
  call Hloop_QV_A(ntryL,G0H32(1),ex5(:),G0H16(1),m3h2x16(:,490),heltab2x32(:,:,1110))
  call Hloop_Q_A(ntryL,G0H16(1),16,nMT,G1H16(116),n2h16(490))
  Gcoeff(:)%j = (-(c(61)*M(1,:)%j)) * den(103)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1111),h0tab(:,1111),[16,2,13],[nMB,nMW,nMB],3,1,wf8(:,118))
  call Hloop_QV_A(ntryL,G0H32(1),ex5(:),G0H16(1),m3h2x16(:,491),heltab2x32(:,:,1111))
  call Hloop_Q_A(ntryL,G0H16(1),16,nMB,G1H16(117),n2h16(491))
  Gcoeff(:)%j = (c(6)*M(1,:)%j) * den(101)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1112),h0tab(:,1112),[16,2,13],[nMT,0,nMT],3,1,wf8(:,120))
  call Hloop_QV_A(ntryL,G0H32(1),ex5(:),G0H16(1),m3h2x16(:,492),heltab2x32(:,:,1112))
  call Hloop_Q_A(ntryL,G0H16(1),16,nMT,G1H16(118),n2h16(492))
  Gcoeff(:)%j = (c(7)*M(1,:)%j) * den(101)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1113),h0tab(:,1113),[16,2,13],[nMT,nMZ,nMT],3,1,wf8(:,120))
  call Hloop_QV_A(ntryL,G0H32(1),ex5(:),G0H16(1),m3h2x16(:,493),heltab2x32(:,:,1113))
  call Hloop_Q_A(ntryL,G0H16(1),16,nMT,G1H16(119),n2h16(493))
  Gcoeff(:)%j = (c(65)*M(1,:)%j) * den(101)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1114),h0tab(:,1114),[16,2,13],[nMB,nMW,nMB],3,1,wf8(:,120))
  call Hloop_QV_A(ntryL,G0H32(1),ex5(:),G0H16(1),m3h2x16(:,494),heltab2x32(:,:,1114))
  call Hloop_Q_A(ntryL,G0H16(1),16,nMB,G1H16(120),n2h16(494))
  Gcoeff(:)%j = (c(36)*M(1,:)%j) * den(82)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1115),h0tab(:,1115),[16,1,14],[nMT,nMH,nMT],3,1,wf8(:,106))
  call Hloop_AV_Q(ntryL,G0H32(1),ex5(:),G0H16(1),m3h2x16(:,495),heltab2x32(:,:,1115))
  call Hloop_A_Q(ntryL,G0H16(1),16,nMT,G1H16(121),n2h16(495))
  Gcoeff(:)%j = (-(c(36)*M(1,:)%j)) * den(82)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1116),h0tab(:,1116),[16,1,14],[nMT,nMZ,nMT],3,1,wf8(:,106))
  call Hloop_AV_Q(ntryL,G0H32(1),ex5(:),G0H16(1),m3h2x16(:,496),heltab2x32(:,:,1116))
  call Hloop_A_Q(ntryL,G0H16(1),16,nMT,G1H16(122),n2h16(496))
  Gcoeff(:)%j = (-(c(24)*M(1,:)%j)) * den(82)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1117),h0tab(:,1117),[16,1,14],[nMB,nMW,nMB],3,1,wf8(:,106))
  call Hloop_AV_Q(ntryL,G0H32(1),ex5(:),G0H16(1),m3h2x16(:,497),heltab2x32(:,:,1117))
  call Hloop_A_Q(ntryL,G0H16(1),16,nMB,G1H16(123),n2h16(497))
  Gcoeff(:)%j = (c(36)*M(1,:)%j) * den(84)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1118),h0tab(:,1118),[16,1,14],[nMT,nMH,nMT],3,1,wf8(:,108))
  call Hloop_AV_Q(ntryL,G0H32(1),ex5(:),G0H16(1),m3h2x16(:,498),heltab2x32(:,:,1118))
  call Hloop_A_Q(ntryL,G0H16(1),16,nMT,G1H16(124),n2h16(498))
  Gcoeff(:)%j = (-(c(36)*M(1,:)%j)) * den(84)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1119),h0tab(:,1119),[16,1,14],[nMT,nMZ,nMT],3,1,wf8(:,108))
  call Hloop_AV_Q(ntryL,G0H32(1),ex5(:),G0H16(1),m3h2x16(:,499),heltab2x32(:,:,1119))
  call Hloop_A_Q(ntryL,G0H16(1),16,nMT,G1H16(125),n2h16(499))
  Gcoeff(:)%j = (-(c(24)*M(1,:)%j)) * den(84)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1120),h0tab(:,1120),[16,1,14],[nMB,nMW,nMB],3,1,wf8(:,108))
  call Hloop_AV_Q(ntryL,G0H32(1),ex5(:),G0H16(1),m3h2x16(:,500),heltab2x32(:,:,1120))
  call Hloop_A_Q(ntryL,G0H16(1),16,nMB,G1H16(126),n2h16(500))
  Gcoeff(:)%j = (-(c(85)*M(1,:)%j)) * den(82)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1121),h0tab(:,1121),[16,1,14],[nMT,0,nMT],3,1,wf8(:,106))
  call Hloop_AV_Q(ntryL,G0H32(1),ex5(:),G0H16(1),m3h2x16(:,501),heltab2x32(:,:,1121))
  call Hloop_A_Q(ntryL,G0H16(1),16,nMT,G1H16(127),n2h16(501))
  Gcoeff(:)%j = (-(c(86)*M(1,:)%j)) * den(82)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1122),h0tab(:,1122),[16,1,14],[nMT,nMZ,nMT],3,1,wf8(:,106))
  call Hloop_AV_Q(ntryL,G0H32(1),ex5(:),G0H16(1),m3h2x16(:,502),heltab2x32(:,:,1122))
  call Hloop_A_Q(ntryL,G0H16(1),16,nMT,G1H16(128),n2h16(502))
  Gcoeff(:)%j = (-(c(44)*M(1,:)%j)) * den(82)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1123),h0tab(:,1123),[16,1,14],[nMB,nMW,nMB],3,1,wf8(:,106))
  call Hloop_AV_Q(ntryL,G0H32(1),ex5(:),G0H16(1),m3h2x16(:,503),heltab2x32(:,:,1123))
  call Hloop_A_Q(ntryL,G0H16(1),16,nMB,G1H16(129),n2h16(503))
  Gcoeff(:)%j = (-(c(85)*M(1,:)%j)) * den(84)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1124),h0tab(:,1124),[16,1,14],[nMT,0,nMT],3,1,wf8(:,108))
  call Hloop_AV_Q(ntryL,G0H32(1),ex5(:),G0H16(1),m3h2x16(:,504),heltab2x32(:,:,1124))
  call Hloop_A_Q(ntryL,G0H16(1),16,nMT,G1H16(130),n2h16(504))
  Gcoeff(:)%j = (-(c(86)*M(1,:)%j)) * den(84)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1125),h0tab(:,1125),[16,1,14],[nMT,nMZ,nMT],3,1,wf8(:,108))
  call Hloop_AV_Q(ntryL,G0H32(1),ex5(:),G0H16(1),m3h2x16(:,505),heltab2x32(:,:,1125))
  call Hloop_A_Q(ntryL,G0H16(1),16,nMT,G1H16(131),n2h16(505))
  Gcoeff(:)%j = (-(c(44)*M(1,:)%j)) * den(84)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1126),h0tab(:,1126),[16,1,14],[nMB,nMW,nMB],3,1,wf8(:,108))
  call Hloop_AV_Q(ntryL,G0H32(1),ex5(:),G0H16(1),m3h2x16(:,506),heltab2x32(:,:,1126))
  call Hloop_A_Q(ntryL,G0H16(1),16,nMB,G1H16(132),n2h16(506))
  Gcoeff(:)%j = (c(88)*M(1,:)%j) * den(86)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1127),h0tab(:,1127),[16,1,14],[nMT,nMH,nMT],3,1,wf8(:,110))
  call Hloop_AV_Q(ntryL,G0H32(1),ex5(:),G0H16(1),m3h2x16(:,507),heltab2x32(:,:,1127))
  call Hloop_A_Q(ntryL,G0H16(1),16,nMT,G1H16(133),n2h16(507))
  Gcoeff(:)%j = (-(c(88)*M(1,:)%j)) * den(86)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1128),h0tab(:,1128),[16,1,14],[nMT,nMZ,nMT],3,1,wf8(:,110))
  call Hloop_AV_Q(ntryL,G0H32(1),ex5(:),G0H16(1),m3h2x16(:,508),heltab2x32(:,:,1128))
  call Hloop_A_Q(ntryL,G0H16(1),16,nMT,G1H16(134),n2h16(508))
  Gcoeff(:)%j = (-(c(75)*M(1,:)%j)) * den(86)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1129),h0tab(:,1129),[16,1,14],[nMB,nMW,nMB],3,1,wf8(:,110))
  call Hloop_AV_Q(ntryL,G0H32(1),ex5(:),G0H16(1),m3h2x16(:,509),heltab2x32(:,:,1129))
  call Hloop_A_Q(ntryL,G0H16(1),16,nMB,G1H16(135),n2h16(509))
  Gcoeff(:)%j = (-(c(89)*M(1,:)%j)) * den(84)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1130),h0tab(:,1130),[16,1,14],[nMT,nMH,nMT],3,1,wf8(:,112))
  call Hloop_AV_Q(ntryL,G0H32(1),ex5(:),G0H16(1),m3h2x16(:,510),heltab2x32(:,:,1130))
  call Hloop_A_Q(ntryL,G0H16(1),16,nMT,G1H16(136),n2h16(510))
  Gcoeff(:)%j = (c(89)*M(1,:)%j) * den(84)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1131),h0tab(:,1131),[16,1,14],[nMT,nMZ,nMT],3,1,wf8(:,112))
  call Hloop_AV_Q(ntryL,G0H32(1),ex5(:),G0H16(1),m3h2x16(:,511),heltab2x32(:,:,1131))
  call Hloop_A_Q(ntryL,G0H16(1),16,nMT,G1H16(137),n2h16(511))
  Gcoeff(:)%j = (c(79)*M(1,:)%j) * den(84)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1132),h0tab(:,1132),[16,1,14],[nMB,nMW,nMB],3,1,wf8(:,112))
  call Hloop_AV_Q(ntryL,G0H32(1),ex5(:),G0H16(1),m3h2x16(:,512),heltab2x32(:,:,1132))
  call Hloop_A_Q(ntryL,G0H16(1),16,nMB,G1H16(138),n2h16(512))
  Gcoeff(:)%j = (-(c(3)*M(1,:)%j)) * den(86)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1133),h0tab(:,1133),[16,1,14],[nMT,0,nMT],3,1,wf8(:,110))
  call Hloop_AV_Q(ntryL,G0H32(1),ex5(:),G0H16(1),m3h2x16(:,513),heltab2x32(:,:,1133))
  call Hloop_A_Q(ntryL,G0H16(1),16,nMT,G1H16(139),n2h16(513))
  Gcoeff(:)%j = (-(c(5)*M(1,:)%j)) * den(86)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1134),h0tab(:,1134),[16,1,14],[nMT,nMZ,nMT],3,1,wf8(:,110))
  call Hloop_AV_Q(ntryL,G0H32(1),ex5(:),G0H16(1),m3h2x16(:,514),heltab2x32(:,:,1134))
  call Hloop_A_Q(ntryL,G0H16(1),16,nMT,G1H16(140),n2h16(514))
  Gcoeff(:)%j = (-(c(61)*M(1,:)%j)) * den(86)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1135),h0tab(:,1135),[16,1,14],[nMB,nMW,nMB],3,1,wf8(:,110))
  call Hloop_AV_Q(ntryL,G0H32(1),ex5(:),G0H16(1),m3h2x16(:,515),heltab2x32(:,:,1135))
  call Hloop_A_Q(ntryL,G0H16(1),16,nMB,G1H16(141),n2h16(515))
  Gcoeff(:)%j = (c(6)*M(1,:)%j) * den(84)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1136),h0tab(:,1136),[16,1,14],[nMT,0,nMT],3,1,wf8(:,112))
  call Hloop_AV_Q(ntryL,G0H32(1),ex5(:),G0H16(1),m3h2x16(:,516),heltab2x32(:,:,1136))
  call Hloop_A_Q(ntryL,G0H16(1),16,nMT,G1H16(142),n2h16(516))
  Gcoeff(:)%j = (c(7)*M(1,:)%j) * den(84)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1137),h0tab(:,1137),[16,1,14],[nMT,nMZ,nMT],3,1,wf8(:,112))
  call Hloop_AV_Q(ntryL,G0H32(1),ex5(:),G0H16(1),m3h2x16(:,517),heltab2x32(:,:,1137))
  call Hloop_A_Q(ntryL,G0H16(1),16,nMT,G1H16(143),n2h16(517))
  Gcoeff(:)%j = (c(65)*M(1,:)%j) * den(84)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1138),h0tab(:,1138),[16,1,14],[nMB,nMW,nMB],3,1,wf8(:,112))
  call Hloop_AV_Q(ntryL,G0H32(1),ex5(:),G0H16(1),m3h2x16(:,518),heltab2x32(:,:,1138))
  call Hloop_A_Q(ntryL,G0H16(1),16,nMB,G1H16(144),n2h16(518))
  Gcoeff(:)%j = (c(25)*M(1,:)%j) * den(89)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1139),h0tab(:,1139),[19,4,8],[nMB,nMH,nMB],3,1,wf8(:,17))
  call Hloop_AS_Q(ntryL,G0H32(1),wf8(:,17),G0H4(1),ngH,m3h8x4(:,1),heltab2x32(:,:,1139))
  call Hloop_A_Q(ntryL,G0H4(1),19,nMB,G1H4(249),n2h4(401))
  Gcoeff(:)%j = (-(c(25)*M(1,:)%j)) * den(89)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1140),h0tab(:,1140),[19,4,8],[nMB,nMZ,nMB],3,1,wf8(:,17))
  call Hloop_AS_Q(ntryL,G0H32(1),wf8(:,17),G0H4(1),ngH,m3h8x4(:,2),heltab2x32(:,:,1140))
  call Hloop_A_Q(ntryL,G0H4(1),19,nMB,G1H4(250),n2h4(402))
  Gcoeff(:)%j = (-(c(32)*M(1,:)%j)) * den(89)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1141),h0tab(:,1141),[19,4,8],[nMT,nMW,nMT],3,1,wf8(:,17))
  call Hloop_AS_Q(ntryL,G0H32(1),wf8(:,17),G0H4(1),ngH,m3h8x4(:,3),heltab2x32(:,:,1141))
  call Hloop_A_Q(ntryL,G0H4(1),19,nMT,G1H4(253),n2h4(403))
  Gcoeff(:)%j = (c(25)*M(1,:)%j) * den(92)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1142),h0tab(:,1142),[19,4,8],[nMB,nMH,nMB],3,1,wf8(:,18))
  call Hloop_AS_Q(ntryL,G0H32(1),wf8(:,18),G0H4(1),ngX,m3h8x4(:,4),heltab2x32(:,:,1142))
  call Hloop_A_Q(ntryL,G0H4(1),19,nMB,G1H4(254),n2h4(404))
  Gcoeff(:)%j = (-(c(25)*M(1,:)%j)) * den(92)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1143),h0tab(:,1143),[19,4,8],[nMB,nMZ,nMB],3,1,wf8(:,18))
  call Hloop_AS_Q(ntryL,G0H32(1),wf8(:,18),G0H4(1),ngX,m3h8x4(:,5),heltab2x32(:,:,1143))
  call Hloop_A_Q(ntryL,G0H4(1),19,nMB,G1H4(255),n2h4(405))
  Gcoeff(:)%j = (c(32)*M(1,:)%j) * den(92)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1144),h0tab(:,1144),[19,4,8],[nMT,nMW,nMT],3,1,wf8(:,18))
  call Hloop_AS_Q(ntryL,G0H32(1),wf8(:,18),G0H4(1),ngX,m3h8x4(:,6),heltab2x32(:,:,1144))
  call Hloop_A_Q(ntryL,G0H4(1),19,nMT,G1H4(256),n2h4(406))
  Gcoeff(:)%j = (c(28)*M(1,:)%j) * den(89)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1145),h0tab(:,1145),[19,4,8],[nMH,nMB,nMH],3,1,wf8(:,17))
  call Hloop_SS_S(ntryL,G0H32(1),wf8(:,17),G0H4(1),m3h8x4(:,7),heltab2x32(:,:,1145))
  Gcoeff(:)%j = (-(c(27)*M(1,:)%j)) * den(89)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1146),h0tab(:,1146),[19,4,8],[nMZ,nMB,nMZ],3,1,wf8(:,17))
  call Hloop_SS_S(ntryL,G0H32(1),wf8(:,17),G0H4(2),m3h8x4(:,8),heltab2x32(:,:,1146))
  Gcoeff(:)%j = (-(c(26)*M(1,:)%j)) * den(89)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1147),h0tab(:,1147),[19,4,8],[nMW,nMT,nMW],3,1,wf8(:,17))
  call Hloop_SS_S(ntryL,G0H32(1),wf8(:,17),G0H4(3),m3h8x4(:,9),heltab2x32(:,:,1147))
  Gcoeff(:)%j = (c(27)*M(1,:)%j) * den(92)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1148),h0tab(:,1148),[19,4,8],[nMH,nMB,nMZ],3,1,wf8(:,18))
  call Hloop_SS_S(ntryL,G0H32(1),wf8(:,18),G0H4(4),m3h8x4(:,10),heltab2x32(:,:,1148))
  Gcoeff(:)%j = (c(27)*M(1,:)%j) * den(92)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1149),h0tab(:,1149),[19,4,8],[nMZ,nMB,nMH],3,1,wf8(:,18))
  call Hloop_SS_S(ntryL,G0H32(1),wf8(:,18),G0H4(5),m3h8x4(:,11),heltab2x32(:,:,1149))
  Gcoeff(:)%j = (-(c(83)*M(1,:)%j)) * den(89)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1150),h0tab(:,1150),[19,4,8],[nMB,0,nMB],3,1,wf8(:,17))
  call Hloop_AS_Q(ntryL,G0H32(1),wf8(:,17),G0H4(6),ngH,m3h8x4(:,12),heltab2x32(:,:,1150))
  call Hloop_A_Q(ntryL,G0H4(6),19,nMB,G1H4(257),n2h4(407))
  Gcoeff(:)%j = (-(c(86)*M(1,:)%j)) * den(89)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1151),h0tab(:,1151),[19,4,8],[nMB,nMZ,nMB],3,1,wf8(:,17))
  call Hloop_AS_Q(ntryL,G0H32(1),wf8(:,17),G0H4(6),ngH,m3h8x4(:,13),heltab2x32(:,:,1151))
  call Hloop_A_Q(ntryL,G0H4(6),19,nMB,G1H4(258),n2h4(408))
  Gcoeff(:)%j = (-(c(46)*M(1,:)%j)) * den(89)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1152),h0tab(:,1152),[19,4,8],[nMT,nMW,nMT],3,1,wf8(:,17))
  call Hloop_AS_Q(ntryL,G0H32(1),wf8(:,17),G0H4(6),ngH,m3h8x4(:,14),heltab2x32(:,:,1152))
  call Hloop_A_Q(ntryL,G0H4(6),19,nMT,G1H4(259),n2h4(409))
  Gcoeff(:)%j = (-(c(83)*M(1,:)%j)) * den(92)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1153),h0tab(:,1153),[19,4,8],[nMB,0,nMB],3,1,wf8(:,18))
  call Hloop_AS_Q(ntryL,G0H32(1),wf8(:,18),G0H4(6),ngX,m3h8x4(:,15),heltab2x32(:,:,1153))
  call Hloop_A_Q(ntryL,G0H4(6),19,nMB,G1H4(260),n2h4(410))
  Gcoeff(:)%j = (-(c(86)*M(1,:)%j)) * den(92)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1154),h0tab(:,1154),[19,4,8],[nMB,nMZ,nMB],3,1,wf8(:,18))
  call Hloop_AS_Q(ntryL,G0H32(1),wf8(:,18),G0H4(6),ngX,m3h8x4(:,16),heltab2x32(:,:,1154))
  call Hloop_A_Q(ntryL,G0H4(6),19,nMB,G1H4(261),n2h4(411))
  Gcoeff(:)%j = (c(46)*M(1,:)%j) * den(92)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1155),h0tab(:,1155),[19,4,8],[nMT,nMW,nMT],3,1,wf8(:,18))
  call Hloop_AS_Q(ntryL,G0H32(1),wf8(:,18),G0H4(6),ngX,m3h8x4(:,17),heltab2x32(:,:,1155))
  call Hloop_A_Q(ntryL,G0H4(6),19,nMT,G1H4(262),n2h4(412))
  Gcoeff(:)%j = (c(57)*M(1,:)%j) * den(89)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1156),h0tab(:,1156),[19,4,8],[nMZ,nMB,nMZ],3,1,wf8(:,17))
  call Hloop_VT_S(ntryL,G0H32(1),0,wf8(:,17),19,G1H4(263),m3h8x4(:,18),heltab2x32(:,:,1156))
  Gcoeff(:)%j = (-(c(42)*M(1,:)%j)) * den(89)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1157),h0tab(:,1157),[19,4,8],[nMW,nMT,nMW],3,1,wf8(:,17))
  call Hloop_VT_S(ntryL,G0H32(1),0,wf8(:,17),19,G1H4(264),m3h8x4(:,19),heltab2x32(:,:,1157))
  Gcoeff(:)%j = (-(c(57)*M(1,:)%j)) * den(92)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1158),h0tab(:,1158),[19,4,8],[nMH,nMB,nMZ],3,1,wf8(:,18))
  call Hloop_VS_T(ntryL,G0H32(1),0,wf8(:,18),19,G1H4(265),m3h8x4(:,20),heltab2x32(:,:,1158))
  Gcoeff(:)%j = (c(42)*M(1,:)%j) * den(92)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1159),h0tab(:,1159),[19,4,8],[nMW,nMT,nMW],3,1,wf8(:,18))
  call Hloop_VT_S(ntryL,G0H32(1),0,wf8(:,18),19,G1H4(266),m3h8x4(:,21),heltab2x32(:,:,1159))
  Gcoeff(:)%j = (c(57)*M(1,:)%j) * den(89)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1160),h0tab(:,1160),[19,4,8],[nMZ,nMB,nMZ],3,1,wf8(:,17))
  call Hloop_ST_V(ntryL,G0H32(1),0,wf8(:,17),19,G1H4(267),m3h8x4(:,22),heltab2x32(:,:,1160))
  Gcoeff(:)%j = (-(c(42)*M(1,:)%j)) * den(89)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1161),h0tab(:,1161),[19,4,8],[nMW,nMT,nMW],3,1,wf8(:,17))
  call Hloop_ST_V(ntryL,G0H32(1),0,wf8(:,17),19,G1H4(268),m3h8x4(:,23),heltab2x32(:,:,1161))
  Gcoeff(:)%j = (-(c(57)*M(1,:)%j)) * den(92)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1162),h0tab(:,1162),[19,4,8],[nMZ,nMB,nMH],3,1,wf8(:,18))
  call Hloop_TS_V(ntryL,G0H32(1),0,wf8(:,18),19,G1H4(269),m3h8x4(:,24),heltab2x32(:,:,1162))
  Gcoeff(:)%j = (-(c(42)*M(1,:)%j)) * den(92)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1163),h0tab(:,1163),[19,4,8],[nMW,nMT,nMW],3,1,wf8(:,18))
  call Hloop_ST_V(ntryL,G0H32(1),0,wf8(:,18),19,G1H4(270),m3h8x4(:,25),heltab2x32(:,:,1163))
  Gcoeff(:)%j = (-(c(73)*M(1,:)%j)) * den(89)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1164),h0tab(:,1164),[19,4,8],[nMZ,nMB,nMZ],3,1,wf8(:,17))
  call Hloop_VS_V(ntryL,G0H32(1),wf8(:,17),G0H4(6),m3h8x4(:,26),heltab2x32(:,:,1164))
  Gcoeff(:)%j = (-(c(15)*M(1,:)%j)) * den(89)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1165),h0tab(:,1165),[19,4,8],[nMW,nMT,nMW],3,1,wf8(:,17))
  call Hloop_VS_V(ntryL,G0H32(1),wf8(:,17),G0H4(7),m3h8x4(:,27),heltab2x32(:,:,1165))
  Gcoeff(:)%j = (c(80)*M(1,:)%j) * den(96)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1166),h0tab(:,1166),[19,4,8],[nMB,nMH,nMB],3,1,wf8(:,19))
  call Hloop_AV_Q(ntryL,G0H32(1),wf8(:,19),G0H4(8),m3h8x4(:,28),heltab2x32(:,:,1166))
  call Hloop_A_Q(ntryL,G0H4(8),19,nMB,G1H4(271),n2h4(413))
  Gcoeff(:)%j = (-(c(80)*M(1,:)%j)) * den(96)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1167),h0tab(:,1167),[19,4,8],[nMB,nMZ,nMB],3,1,wf8(:,19))
  call Hloop_AV_Q(ntryL,G0H32(1),wf8(:,19),G0H4(8),m3h8x4(:,29),heltab2x32(:,:,1167))
  call Hloop_A_Q(ntryL,G0H4(8),19,nMB,G1H4(272),n2h4(414))
  Gcoeff(:)%j = (c(77)*M(1,:)%j) * den(96)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1168),h0tab(:,1168),[19,4,8],[nMT,nMW,nMT],3,1,wf8(:,19))
  call Hloop_AV_Q(ntryL,G0H32(1),wf8(:,19),G0H4(8),m3h8x4(:,30),heltab2x32(:,:,1168))
  call Hloop_A_Q(ntryL,G0H4(8),19,nMT,G1H4(190),n2h4(415))
  Gcoeff(:)%j = (-(c(81)*M(1,:)%j)) * den(92)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1169),h0tab(:,1169),[19,4,8],[nMB,nMH,nMB],3,1,wf8(:,20))
  call Hloop_AZ_Q(ntryL,G0H32(1),wf8(:,20),G0H4(8),ngZd,m3h8x4(:,31),heltab2x32(:,:,1169))
  call Hloop_A_Q(ntryL,G0H4(8),19,nMB,G1H4(191),n2h4(416))
  Gcoeff(:)%j = (c(81)*M(1,:)%j) * den(92)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1170),h0tab(:,1170),[19,4,8],[nMB,nMZ,nMB],3,1,wf8(:,20))
  call Hloop_AZ_Q(ntryL,G0H32(1),wf8(:,20),G0H4(8),ngZd,m3h8x4(:,32),heltab2x32(:,:,1170))
  call Hloop_A_Q(ntryL,G0H4(8),19,nMB,G1H4(194),n2h4(417))
  Gcoeff(:)%j = (c(79)*M(1,:)%j) * den(92)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1171),h0tab(:,1171),[19,4,8],[nMT,nMW,nMT],3,1,wf8(:,20))
  call Hloop_AZ_Q(ntryL,G0H32(1),wf8(:,20),G0H4(8),ngZu,m3h8x4(:,33),heltab2x32(:,:,1171))
  call Hloop_A_Q(ntryL,G0H4(8),19,nMT,G1H4(196),n2h4(418))
  Gcoeff(:)%j = (c(78)*M(1,:)%j) * den(96)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1172),h0tab(:,1172),[19,4,8],[nMW,nMT,nMW],3,1,wf8(:,19))
  call Hloop_SV_T(ntryL,G0H32(1),0,wf8(:,19),19,G1H4(206),m3h8x4(:,34),heltab2x32(:,:,1172))
  Gcoeff(:)%j = (c(55)*M(1,:)%j) * den(92)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1173),h0tab(:,1173),[19,4,8],[nMH,nMB,nMZ],3,1,wf8(:,20))
  call Hloop_SV_T(ntryL,G0H32(1),0,wf8(:,20),19,G1H4(216),m3h8x4(:,35),heltab2x32(:,:,1173))
  Gcoeff(:)%j = (c(55)*M(1,:)%j) * den(92)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1174),h0tab(:,1174),[19,4,8],[nMZ,nMB,nMH],3,1,wf8(:,20))
  call Hloop_TV_S(ntryL,G0H32(1),0,wf8(:,20),19,G1H4(218),m3h8x4(:,36),heltab2x32(:,:,1174))
  Gcoeff(:)%j = (-(c(104)*M(1,:)%j)) * den(92)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1175),h0tab(:,1175),[19,4,8],[nMW,nMT,nMW],3,1,wf8(:,20))
  call Hloop_SV_T(ntryL,G0H32(1),0,wf8(:,20),19,G1H4(219),m3h8x4(:,37),heltab2x32(:,:,1175))
  Gcoeff(:)%j = (-(c(1)*M(1,:)%j)) * den(96)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1176),h0tab(:,1176),[19,4,8],[nMB,0,nMB],3,1,wf8(:,19))
  call Hloop_AV_Q(ntryL,G0H32(1),wf8(:,19),G0H4(8),m3h8x4(:,38),heltab2x32(:,:,1176))
  call Hloop_A_Q(ntryL,G0H4(8),19,nMB,G1H4(234),n2h4(419))
  Gcoeff(:)%j = (-(c(5)*M(1,:)%j)) * den(96)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1177),h0tab(:,1177),[19,4,8],[nMB,nMZ,nMB],3,1,wf8(:,19))
  call Hloop_AV_Q(ntryL,G0H32(1),wf8(:,19),G0H4(8),m3h8x4(:,39),heltab2x32(:,:,1177))
  call Hloop_A_Q(ntryL,G0H4(8),19,nMB,G1H4(236),n2h4(420))
  Gcoeff(:)%j = (c(63)*M(1,:)%j) * den(96)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1178),h0tab(:,1178),[19,4,8],[nMT,nMW,nMT],3,1,wf8(:,19))
  call Hloop_AV_Q(ntryL,G0H32(1),wf8(:,19),G0H4(8),m3h8x4(:,40),heltab2x32(:,:,1178))
  call Hloop_A_Q(ntryL,G0H4(8),19,nMT,G1H4(1),n2h4(421))
  Gcoeff(:)%j = (c(4)*M(1,:)%j) * den(92)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1179),h0tab(:,1179),[19,4,8],[nMB,0,nMB],3,1,wf8(:,20))
  call Hloop_AZ_Q(ntryL,G0H32(1),wf8(:,20),G0H4(8),ngZd,m3h8x4(:,41),heltab2x32(:,:,1179))
  call Hloop_A_Q(ntryL,G0H4(8),19,nMB,G1H4(9),n2h4(422))
  Gcoeff(:)%j = (c(7)*M(1,:)%j) * den(92)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1180),h0tab(:,1180),[19,4,8],[nMB,nMZ,nMB],3,1,wf8(:,20))
  call Hloop_AZ_Q(ntryL,G0H32(1),wf8(:,20),G0H4(8),ngZd,m3h8x4(:,42),heltab2x32(:,:,1180))
  call Hloop_A_Q(ntryL,G0H4(8),19,nMB,G1H4(10),n2h4(423))
  Gcoeff(:)%j = (c(65)*M(1,:)%j) * den(92)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1181),h0tab(:,1181),[19,4,8],[nMT,nMW,nMT],3,1,wf8(:,20))
  call Hloop_AZ_Q(ntryL,G0H32(1),wf8(:,20),G0H4(8),ngZu,m3h8x4(:,43),heltab2x32(:,:,1181))
  call Hloop_A_Q(ntryL,G0H4(8),19,nMT,G1H4(12),n2h4(424))
  Gcoeff(:)%j = (c(64)*M(1,:)%j) * den(96)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1182),h0tab(:,1182),[19,4,8],[nMW,nMT,nMW],3,1,wf8(:,19))
  call Hloop_VV_S(ntryL,G0H32(1),wf8(:,19),G0H4(8),m3h8x4(:,44),heltab2x32(:,:,1182))
  Gcoeff(:)%j = (-(c(70)*M(1,:)%j)) * den(92)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1183),h0tab(:,1183),[19,4,8],[nMH,nMB,nMZ],3,1,wf8(:,20))
  call Hloop_VV_S(ntryL,G0H32(1),wf8(:,20),G0H4(9),m3h8x4(:,45),heltab2x32(:,:,1183))
  Gcoeff(:)%j = (-(c(92)*M(1,:)%j)) * den(92)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1184),h0tab(:,1184),[19,4,8],[nMW,nMT,nMW],3,1,wf8(:,20))
  call Hloop_VV_S(ntryL,G0H32(1),wf8(:,20),G0H4(10),m3h8x4(:,46),heltab2x32(:,:,1184))
  Gcoeff(:)%j = (-(c(64)*M(1,:)%j)) * den(96)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1185),h0tab(:,1185),[19,4,8],[nMW,nMT,nMW],3,1,wf8(:,19))
  call Hloop_SV_V(ntryL,G0H32(1),wf8(:,19),G0H4(11),m3h8x4(:,47),heltab2x32(:,:,1185))
  Gcoeff(:)%j = (-(c(70)*M(1,:)%j)) * den(92)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1186),h0tab(:,1186),[19,4,8],[nMZ,nMB,nMH],3,1,wf8(:,20))
  call Hloop_SV_V(ntryL,G0H32(1),wf8(:,20),G0H4(12),m3h8x4(:,48),heltab2x32(:,:,1186))
  Gcoeff(:)%j = (c(92)*M(1,:)%j) * den(92)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1187),h0tab(:,1187),[19,4,8],[nMW,nMT,nMW],3,1,wf8(:,20))
  call Hloop_SV_V(ntryL,G0H32(1),wf8(:,20),G0H4(13),m3h8x4(:,49),heltab2x32(:,:,1187))
  Gcoeff(:)%j = (c(64)*M(1,:)%j) * den(96)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1188),h0tab(:,1188),[19,4,8],[nMW,nMT,nMW],3,1,wf8(:,19))
  call Hloop_UW_V(ntryL,G0H32(1),0,wf8(:,19),19,G1H4(20),m3h8x4(:,50),heltab2x32(:,:,1188))
  Gcoeff(:)%j = (c(48)*M(1,:)%j) * den(92)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1189),h0tab(:,1189),[19,4,8],[nMW,nMT,nMW],3,1,wf8(:,20))
  call Hloop_UW_V(ntryL,G0H32(1),0,wf8(:,20),19,G1H4(25),m3h8x4(:,51),heltab2x32(:,:,1189))
  Gcoeff(:)%j = (c(24)*M(3,:)%j) * den(66)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1190),h0tab(:,1190),[25,2,4],[nMT,nMH,nMB],3,1,wf8(:,9))
  call Hloop_QS_A(ntryL,G0H32(1),wf8(:,9),G0H4(14),ngPtb,m3h8x4(:,52),heltab2x32(:,:,1190))
  call Hloop_Q_A(ntryL,G0H4(14),25,nMT,G1H4(26),n2h4(425))
  Gcoeff(:)%j = (c(24)*M(3,:)%j) * den(66)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1191),h0tab(:,1191),[25,2,4],[nMT,nMZ,nMB],3,1,wf8(:,9))
  call Hloop_QS_A(ntryL,G0H32(1),wf8(:,9),G0H4(14),ngPtb,m3h8x4(:,53),heltab2x32(:,:,1191))
  call Hloop_Q_A(ntryL,G0H4(14),25,nMT,G1H4(107),n2h4(426))
  Gcoeff(:)%j = (c(26)*M(3,:)%j) * den(66)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1192),h0tab(:,1192),[25,2,4],[nMH,nMT,nMW],3,1,wf8(:,9))
  call Hloop_SS_S(ntryL,G0H32(1),wf8(:,9),G0H4(14),m3h8x4(:,54),heltab2x32(:,:,1192))
  Gcoeff(:)%j = (c(22)*M(3,:)%j) * den(66)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1193),h0tab(:,1193),[25,2,4],[nMW,nMB,nMH],3,1,wf8(:,9))
  call Hloop_SS_S(ntryL,G0H32(1),wf8(:,9),G0H4(15),m3h8x4(:,55),heltab2x32(:,:,1193))
  Gcoeff(:)%j = (c(75)*M(3,:)%j) * den(66)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1194),h0tab(:,1194),[25,2,4],[nMT,0,nMB],3,1,wf8(:,9))
  call Hloop_QS_A(ntryL,G0H32(1),wf8(:,9),G0H4(16),ngPtb,m3h8x4(:,56),heltab2x32(:,:,1194))
  call Hloop_Q_A(ntryL,G0H4(16),25,nMT,G1H4(108),n2h4(427))
  Gcoeff(:)%j = (-(c(79)*M(3,:)%j)) * den(66)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1195),h0tab(:,1195),[25,2,4],[nMT,nMZ,nMB],3,1,wf8(:,9))
  call Hloop_QS_A(ntryL,G0H32(1),wf8(:,9),G0H4(16),ngPtb,m3h8x4(:,57),heltab2x32(:,:,1195))
  call Hloop_Q_A(ntryL,G0H4(16),25,nMT,G1H4(113),n2h4(428))
  Gcoeff(:)%j = (c(76)*M(3,:)%j) * den(66)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1196),h0tab(:,1196),[25,2,4],[nMW,nMB,0],3,1,wf8(:,9))
  call Hloop_VS_T(ntryL,G0H32(1),0,wf8(:,9),25,G1H4(138),m3h8x4(:,58),heltab2x32(:,:,1196))
  Gcoeff(:)%j = (c(104)*M(3,:)%j) * den(66)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1197),h0tab(:,1197),[25,2,4],[nMW,nMB,nMZ],3,1,wf8(:,9))
  call Hloop_VS_T(ntryL,G0H32(1),0,wf8(:,9),25,G1H4(140),m3h8x4(:,59),heltab2x32(:,:,1197))
  Gcoeff(:)%j = (c(42)*M(3,:)%j) * den(66)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1198),h0tab(:,1198),[25,2,4],[nMH,nMT,nMW],3,1,wf8(:,9))
  call Hloop_VS_T(ntryL,G0H32(1),0,wf8(:,9),25,G1H4(150),m3h8x4(:,60),heltab2x32(:,:,1198))
  Gcoeff(:)%j = (c(42)*M(3,:)%j) * den(66)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1199),h0tab(:,1199),[25,2,4],[nMZ,nMT,nMW],3,1,wf8(:,9))
  call Hloop_VS_T(ntryL,G0H32(1),0,wf8(:,9),25,G1H4(172),m3h8x4(:,61),heltab2x32(:,:,1199))
  Gcoeff(:)%j = (-(c(78)*M(3,:)%j)) * den(66)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1200),h0tab(:,1200),[25,2,4],[0,nMT,nMW],3,1,wf8(:,9))
  call Hloop_TS_V(ntryL,G0H32(1),0,wf8(:,9),25,G1H4(173),m3h8x4(:,62),heltab2x32(:,:,1200))
  Gcoeff(:)%j = (c(104)*M(3,:)%j) * den(66)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1201),h0tab(:,1201),[25,2,4],[nMZ,nMT,nMW],3,1,wf8(:,9))
  call Hloop_TS_V(ntryL,G0H32(1),0,wf8(:,9),25,G1H4(175),m3h8x4(:,63),heltab2x32(:,:,1201))
  Gcoeff(:)%j = (c(39)*M(3,:)%j) * den(66)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1202),h0tab(:,1202),[25,2,4],[nMW,nMB,nMH],3,1,wf8(:,9))
  call Hloop_TS_V(ntryL,G0H32(1),0,wf8(:,9),25,G1H4(7),m3h8x4(:,64),heltab2x32(:,:,1202))
  Gcoeff(:)%j = (-(c(39)*M(3,:)%j)) * den(66)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1203),h0tab(:,1203),[25,2,4],[nMW,nMB,nMZ],3,1,wf8(:,9))
  call Hloop_TS_V(ntryL,G0H32(1),0,wf8(:,9),25,G1H4(2),m3h8x4(:,65),heltab2x32(:,:,1203))
  Gcoeff(:)%j = (c(64)*M(3,:)%j) * den(66)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1204),h0tab(:,1204),[25,2,4],[0,nMT,nMW],3,1,wf8(:,9))
  call Hloop_VS_V(ntryL,G0H32(1),wf8(:,9),G0H4(16),m3h8x4(:,66),heltab2x32(:,:,1204))
  Gcoeff(:)%j = (-(c(62)*M(3,:)%j)) * den(66)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1205),h0tab(:,1205),[25,2,4],[nMW,nMB,0],3,1,wf8(:,9))
  call Hloop_VS_V(ntryL,G0H32(1),wf8(:,9),G0H4(17),m3h8x4(:,67),heltab2x32(:,:,1205))
  Gcoeff(:)%j = (-(c(92)*M(3,:)%j)) * den(66)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1206),h0tab(:,1206),[25,2,4],[nMZ,nMT,nMW],3,1,wf8(:,9))
  call Hloop_VS_V(ntryL,G0H32(1),wf8(:,9),G0H4(18),m3h8x4(:,68),heltab2x32(:,:,1206))
  Gcoeff(:)%j = (-(c(92)*M(3,:)%j)) * den(66)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1207),h0tab(:,1207),[25,2,4],[nMW,nMB,nMZ],3,1,wf8(:,9))
  call Hloop_VS_V(ntryL,G0H32(1),wf8(:,9),G0H4(19),m3h8x4(:,69),heltab2x32(:,:,1207))
  Gcoeff(:)%j = (c(44)*M(3,:)%j) * den(66)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1208),h0tab(:,1208),[25,2,4],[nMT,nMH,nMB],3,1,wf8(:,10))
  call Hloop_QW_A(ntryL,G0H32(1),wf8(:,10),G0H4(20),m3h8x4(:,70),heltab2x32(:,:,1208))
  call Hloop_Q_A(ntryL,G0H4(20),25,nMT,G1H4(8),n2h4(429))
  Gcoeff(:)%j = (c(44)*M(3,:)%j) * den(66)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1209),h0tab(:,1209),[25,2,4],[nMT,nMZ,nMB],3,1,wf8(:,10))
  call Hloop_QW_A(ntryL,G0H32(1),wf8(:,10),G0H4(20),m3h8x4(:,71),heltab2x32(:,:,1209))
  call Hloop_Q_A(ntryL,G0H4(20),25,nMT,G1H4(13),n2h4(430))
  Gcoeff(:)%j = (c(42)*M(3,:)%j) * den(66)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1210),h0tab(:,1210),[25,2,4],[nMH,nMT,nMW],3,1,wf8(:,10))
  call Hloop_SV_T(ntryL,G0H32(1),0,wf8(:,10),25,G1H4(15),m3h8x4(:,72),heltab2x32(:,:,1210))
  Gcoeff(:)%j = (c(39)*M(3,:)%j) * den(66)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1211),h0tab(:,1211),[25,2,4],[nMW,nMB,nMH],3,1,wf8(:,10))
  call Hloop_TV_S(ntryL,G0H32(1),0,wf8(:,10),25,G1H4(11),m3h8x4(:,73),heltab2x32(:,:,1211))
  Gcoeff(:)%j = (-(c(42)*M(3,:)%j)) * den(66)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1212),h0tab(:,1212),[25,2,4],[nMZ,nMT,nMW],3,1,wf8(:,10))
  call Hloop_SV_T(ntryL,G0H32(1),0,wf8(:,10),25,G1H4(17),m3h8x4(:,74),heltab2x32(:,:,1212))
  Gcoeff(:)%j = (c(39)*M(3,:)%j) * den(66)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1213),h0tab(:,1213),[25,2,4],[nMW,nMB,nMZ],3,1,wf8(:,10))
  call Hloop_TV_S(ntryL,G0H32(1),0,wf8(:,10),25,G1H4(31),m3h8x4(:,75),heltab2x32(:,:,1213))
  Gcoeff(:)%j = (c(61)*M(3,:)%j) * den(66)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1214),h0tab(:,1214),[25,2,4],[nMT,0,nMB],3,1,wf8(:,10))
  call Hloop_QW_A(ntryL,G0H32(1),wf8(:,10),G0H4(20),m3h8x4(:,76),heltab2x32(:,:,1214))
  call Hloop_Q_A(ntryL,G0H4(20),25,nMT,G1H4(30),n2h4(431))
  Gcoeff(:)%j = (-(c(65)*M(3,:)%j)) * den(66)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1215),h0tab(:,1215),[25,2,4],[nMT,nMZ,nMB],3,1,wf8(:,10))
  call Hloop_QW_A(ntryL,G0H32(1),wf8(:,10),G0H4(20),m3h8x4(:,77),heltab2x32(:,:,1215))
  call Hloop_Q_A(ntryL,G0H4(20),25,nMT,G1H4(22),n2h4(432))
  Gcoeff(:)%j = (c(62)*M(3,:)%j) * den(66)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1216),h0tab(:,1216),[25,2,4],[nMW,nMB,0],3,1,wf8(:,10))
  call Hloop_VV_S(ntryL,G0H32(1),wf8(:,10),G0H4(20),m3h8x4(:,78),heltab2x32(:,:,1216))
  Gcoeff(:)%j = (c(92)*M(3,:)%j) * den(66)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1217),h0tab(:,1217),[25,2,4],[nMW,nMB,nMZ],3,1,wf8(:,10))
  call Hloop_VV_S(ntryL,G0H32(1),wf8(:,10),G0H4(21),m3h8x4(:,79),heltab2x32(:,:,1217))
  Gcoeff(:)%j = (c(15)*M(3,:)%j) * den(66)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1218),h0tab(:,1218),[25,2,4],[nMH,nMT,nMW],3,1,wf8(:,10))
  call Hloop_VV_S(ntryL,G0H32(1),wf8(:,10),G0H4(22),m3h8x4(:,80),heltab2x32(:,:,1218))
  Gcoeff(:)%j = (-(c(64)*M(3,:)%j)) * den(66)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1219),h0tab(:,1219),[25,2,4],[0,nMT,nMW],3,1,wf8(:,10))
  call Hloop_SV_V(ntryL,G0H32(1),wf8(:,10),G0H4(23),m3h8x4(:,81),heltab2x32(:,:,1219))
  Gcoeff(:)%j = (c(92)*M(3,:)%j) * den(66)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1220),h0tab(:,1220),[25,2,4],[nMZ,nMT,nMW],3,1,wf8(:,10))
  call Hloop_SV_V(ntryL,G0H32(1),wf8(:,10),G0H4(24),m3h8x4(:,82),heltab2x32(:,:,1220))
  Gcoeff(:)%j = (c(14)*M(3,:)%j) * den(66)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1221),h0tab(:,1221),[25,2,4],[nMW,nMB,nMH],3,1,wf8(:,10))
  call Hloop_SV_V(ntryL,G0H32(1),wf8(:,10),G0H4(25),m3h8x4(:,83),heltab2x32(:,:,1221))
  Gcoeff(:)%j = (-(c(64)*M(3,:)%j)) * den(66)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1222),h0tab(:,1222),[25,2,4],[0,nMT,nMW],3,1,wf8(:,10))
  call Hloop_UW_V(ntryL,G0H32(1),0,wf8(:,10),25,G1H4(23),m3h8x4(:,84),heltab2x32(:,:,1222))
  Gcoeff(:)%j = (c(62)*M(3,:)%j) * den(66)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1223),h0tab(:,1223),[25,2,4],[nMW,nMB,0],3,1,wf8(:,10))
  call Hloop_UV_W(ntryL,G0H32(1),0,wf8(:,10),25,G1H4(24),m3h8x4(:,85),heltab2x32(:,:,1223))
  Gcoeff(:)%j = (-(c(48)*M(3,:)%j)) * den(66)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1224),h0tab(:,1224),[25,2,4],[nMZ,nMT,nMW],3,1,wf8(:,10))
  call Hloop_UW_V(ntryL,G0H32(1),0,wf8(:,10),25,G1H4(27),m3h8x4(:,86),heltab2x32(:,:,1224))
  Gcoeff(:)%j = (-(c(48)*M(3,:)%j)) * den(66)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1225),h0tab(:,1225),[25,2,4],[nMW,nMB,nMZ],3,1,wf8(:,10))
  call Hloop_UV_W(ntryL,G0H32(1),0,wf8(:,10),25,G1H4(43),m3h8x4(:,87),heltab2x32(:,:,1225))
  Gcoeff(:)%j = (c(25)*M(1,:)%j) * den(105)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1226),h0tab(:,1226),[19,4,8],[nMB,nMH,nMB],3,1,wf8(:,21))
  call Hloop_AS_Q(ntryL,G0H32(1),wf8(:,21),G0H4(26),ngH,m3h8x4(:,88),heltab2x32(:,:,1226))
  call Hloop_A_Q(ntryL,G0H4(26),19,nMB,G1H4(29),n2h4(433))
  Gcoeff(:)%j = (-(c(25)*M(1,:)%j)) * den(105)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1227),h0tab(:,1227),[19,4,8],[nMB,nMZ,nMB],3,1,wf8(:,21))
  call Hloop_AS_Q(ntryL,G0H32(1),wf8(:,21),G0H4(26),ngH,m3h8x4(:,89),heltab2x32(:,:,1227))
  call Hloop_A_Q(ntryL,G0H4(26),19,nMB,G1H4(35),n2h4(434))
  Gcoeff(:)%j = (-(c(32)*M(1,:)%j)) * den(105)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1228),h0tab(:,1228),[19,4,8],[nMT,nMW,nMT],3,1,wf8(:,21))
  call Hloop_AS_Q(ntryL,G0H32(1),wf8(:,21),G0H4(26),ngH,m3h8x4(:,90),heltab2x32(:,:,1228))
  call Hloop_A_Q(ntryL,G0H4(26),19,nMT,G1H4(36),n2h4(435))
  Gcoeff(:)%j = (c(25)*M(1,:)%j) * den(107)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1229),h0tab(:,1229),[19,4,8],[nMB,nMH,nMB],3,1,wf8(:,22))
  call Hloop_AS_Q(ntryL,G0H32(1),wf8(:,22),G0H4(26),ngX,m3h8x4(:,91),heltab2x32(:,:,1229))
  call Hloop_A_Q(ntryL,G0H4(26),19,nMB,G1H4(37),n2h4(436))
  Gcoeff(:)%j = (-(c(25)*M(1,:)%j)) * den(107)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1230),h0tab(:,1230),[19,4,8],[nMB,nMZ,nMB],3,1,wf8(:,22))
  call Hloop_AS_Q(ntryL,G0H32(1),wf8(:,22),G0H4(26),ngX,m3h8x4(:,92),heltab2x32(:,:,1230))
  call Hloop_A_Q(ntryL,G0H4(26),19,nMB,G1H4(40),n2h4(437))
  Gcoeff(:)%j = (c(32)*M(1,:)%j) * den(107)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1231),h0tab(:,1231),[19,4,8],[nMT,nMW,nMT],3,1,wf8(:,22))
  call Hloop_AS_Q(ntryL,G0H32(1),wf8(:,22),G0H4(26),ngX,m3h8x4(:,93),heltab2x32(:,:,1231))
  call Hloop_A_Q(ntryL,G0H4(26),19,nMT,G1H4(41),n2h4(438))
  Gcoeff(:)%j = (c(28)*M(1,:)%j) * den(105)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1232),h0tab(:,1232),[19,4,8],[nMH,nMB,nMH],3,1,wf8(:,21))
  call Hloop_SS_S(ntryL,G0H32(1),wf8(:,21),G0H4(26),m3h8x4(:,94),heltab2x32(:,:,1232))
  Gcoeff(:)%j = (-(c(27)*M(1,:)%j)) * den(105)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1233),h0tab(:,1233),[19,4,8],[nMZ,nMB,nMZ],3,1,wf8(:,21))
  call Hloop_SS_S(ntryL,G0H32(1),wf8(:,21),G0H4(27),m3h8x4(:,95),heltab2x32(:,:,1233))
  Gcoeff(:)%j = (-(c(26)*M(1,:)%j)) * den(105)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1234),h0tab(:,1234),[19,4,8],[nMW,nMT,nMW],3,1,wf8(:,21))
  call Hloop_SS_S(ntryL,G0H32(1),wf8(:,21),G0H4(28),m3h8x4(:,96),heltab2x32(:,:,1234))
  Gcoeff(:)%j = (c(27)*M(1,:)%j) * den(107)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1235),h0tab(:,1235),[19,4,8],[nMH,nMB,nMZ],3,1,wf8(:,22))
  call Hloop_SS_S(ntryL,G0H32(1),wf8(:,22),G0H4(29),m3h8x4(:,97),heltab2x32(:,:,1235))
  Gcoeff(:)%j = (c(27)*M(1,:)%j) * den(107)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1236),h0tab(:,1236),[19,4,8],[nMZ,nMB,nMH],3,1,wf8(:,22))
  call Hloop_SS_S(ntryL,G0H32(1),wf8(:,22),G0H4(30),m3h8x4(:,98),heltab2x32(:,:,1236))
  Gcoeff(:)%j = (-(c(83)*M(1,:)%j)) * den(105)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1237),h0tab(:,1237),[19,4,8],[nMB,0,nMB],3,1,wf8(:,21))
  call Hloop_AS_Q(ntryL,G0H32(1),wf8(:,21),G0H4(31),ngH,m3h8x4(:,99),heltab2x32(:,:,1237))
  call Hloop_A_Q(ntryL,G0H4(31),19,nMB,G1H4(45),n2h4(439))
  Gcoeff(:)%j = (-(c(86)*M(1,:)%j)) * den(105)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1238),h0tab(:,1238),[19,4,8],[nMB,nMZ,nMB],3,1,wf8(:,21))
  call Hloop_AS_Q(ntryL,G0H32(1),wf8(:,21),G0H4(31),ngH,m3h8x4(:,100),heltab2x32(:,:,1238))
  call Hloop_A_Q(ntryL,G0H4(31),19,nMB,G1H4(48),n2h4(440))
  Gcoeff(:)%j = (-(c(46)*M(1,:)%j)) * den(105)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1239),h0tab(:,1239),[19,4,8],[nMT,nMW,nMT],3,1,wf8(:,21))
  call Hloop_AS_Q(ntryL,G0H32(1),wf8(:,21),G0H4(31),ngH,m3h8x4(:,101),heltab2x32(:,:,1239))
  call Hloop_A_Q(ntryL,G0H4(31),19,nMT,G1H4(49),n2h4(441))
  Gcoeff(:)%j = (-(c(83)*M(1,:)%j)) * den(107)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1240),h0tab(:,1240),[19,4,8],[nMB,0,nMB],3,1,wf8(:,22))
  call Hloop_AS_Q(ntryL,G0H32(1),wf8(:,22),G0H4(31),ngX,m3h8x4(:,102),heltab2x32(:,:,1240))
  call Hloop_A_Q(ntryL,G0H4(31),19,nMB,G1H4(50),n2h4(442))
  Gcoeff(:)%j = (-(c(86)*M(1,:)%j)) * den(107)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1241),h0tab(:,1241),[19,4,8],[nMB,nMZ,nMB],3,1,wf8(:,22))
  call Hloop_AS_Q(ntryL,G0H32(1),wf8(:,22),G0H4(31),ngX,m3h8x4(:,103),heltab2x32(:,:,1241))
  call Hloop_A_Q(ntryL,G0H4(31),19,nMB,G1H4(53),n2h4(443))
  Gcoeff(:)%j = (c(46)*M(1,:)%j) * den(107)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1242),h0tab(:,1242),[19,4,8],[nMT,nMW,nMT],3,1,wf8(:,22))
  call Hloop_AS_Q(ntryL,G0H32(1),wf8(:,22),G0H4(31),ngX,m3h8x4(:,104),heltab2x32(:,:,1242))
  call Hloop_A_Q(ntryL,G0H4(31),19,nMT,G1H4(54),n2h4(444))
  Gcoeff(:)%j = (c(57)*M(1,:)%j) * den(105)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1243),h0tab(:,1243),[19,4,8],[nMZ,nMB,nMZ],3,1,wf8(:,21))
  call Hloop_VT_S(ntryL,G0H32(1),0,wf8(:,21),19,G1H4(55),m3h8x4(:,105),heltab2x32(:,:,1243))
  Gcoeff(:)%j = (-(c(42)*M(1,:)%j)) * den(105)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1244),h0tab(:,1244),[19,4,8],[nMW,nMT,nMW],3,1,wf8(:,21))
  call Hloop_VT_S(ntryL,G0H32(1),0,wf8(:,21),19,G1H4(58),m3h8x4(:,106),heltab2x32(:,:,1244))
  Gcoeff(:)%j = (-(c(57)*M(1,:)%j)) * den(107)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1245),h0tab(:,1245),[19,4,8],[nMH,nMB,nMZ],3,1,wf8(:,22))
  call Hloop_VS_T(ntryL,G0H32(1),0,wf8(:,22),19,G1H4(59),m3h8x4(:,107),heltab2x32(:,:,1245))
  Gcoeff(:)%j = (c(42)*M(1,:)%j) * den(107)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1246),h0tab(:,1246),[19,4,8],[nMW,nMT,nMW],3,1,wf8(:,22))
  call Hloop_VT_S(ntryL,G0H32(1),0,wf8(:,22),19,G1H4(60),m3h8x4(:,108),heltab2x32(:,:,1246))
  Gcoeff(:)%j = (c(57)*M(1,:)%j) * den(105)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1247),h0tab(:,1247),[19,4,8],[nMZ,nMB,nMZ],3,1,wf8(:,21))
  call Hloop_ST_V(ntryL,G0H32(1),0,wf8(:,21),19,G1H4(63),m3h8x4(:,109),heltab2x32(:,:,1247))
  Gcoeff(:)%j = (-(c(42)*M(1,:)%j)) * den(105)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1248),h0tab(:,1248),[19,4,8],[nMW,nMT,nMW],3,1,wf8(:,21))
  call Hloop_ST_V(ntryL,G0H32(1),0,wf8(:,21),19,G1H4(64),m3h8x4(:,110),heltab2x32(:,:,1248))
  Gcoeff(:)%j = (-(c(57)*M(1,:)%j)) * den(107)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1249),h0tab(:,1249),[19,4,8],[nMZ,nMB,nMH],3,1,wf8(:,22))
  call Hloop_TS_V(ntryL,G0H32(1),0,wf8(:,22),19,G1H4(65),m3h8x4(:,111),heltab2x32(:,:,1249))
  Gcoeff(:)%j = (-(c(42)*M(1,:)%j)) * den(107)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1250),h0tab(:,1250),[19,4,8],[nMW,nMT,nMW],3,1,wf8(:,22))
  call Hloop_ST_V(ntryL,G0H32(1),0,wf8(:,22),19,G1H4(68),m3h8x4(:,112),heltab2x32(:,:,1250))
  Gcoeff(:)%j = (-(c(73)*M(1,:)%j)) * den(105)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1251),h0tab(:,1251),[19,4,8],[nMZ,nMB,nMZ],3,1,wf8(:,21))
  call Hloop_VS_V(ntryL,G0H32(1),wf8(:,21),G0H4(31),m3h8x4(:,113),heltab2x32(:,:,1251))
  Gcoeff(:)%j = (-(c(15)*M(1,:)%j)) * den(105)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1252),h0tab(:,1252),[19,4,8],[nMW,nMT,nMW],3,1,wf8(:,21))
  call Hloop_VS_V(ntryL,G0H32(1),wf8(:,21),G0H4(32),m3h8x4(:,114),heltab2x32(:,:,1252))
  Gcoeff(:)%j = (c(80)*M(1,:)%j) * den(110)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1253),h0tab(:,1253),[19,4,8],[nMB,nMH,nMB],3,1,wf8(:,23))
  call Hloop_AV_Q(ntryL,G0H32(1),wf8(:,23),G0H4(33),m3h8x4(:,115),heltab2x32(:,:,1253))
  call Hloop_A_Q(ntryL,G0H4(33),19,nMB,G1H4(69),n2h4(445))
  Gcoeff(:)%j = (-(c(80)*M(1,:)%j)) * den(110)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1254),h0tab(:,1254),[19,4,8],[nMB,nMZ,nMB],3,1,wf8(:,23))
  call Hloop_AV_Q(ntryL,G0H32(1),wf8(:,23),G0H4(33),m3h8x4(:,116),heltab2x32(:,:,1254))
  call Hloop_A_Q(ntryL,G0H4(33),19,nMB,G1H4(70),n2h4(446))
  Gcoeff(:)%j = (c(77)*M(1,:)%j) * den(110)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1255),h0tab(:,1255),[19,4,8],[nMT,nMW,nMT],3,1,wf8(:,23))
  call Hloop_AV_Q(ntryL,G0H32(1),wf8(:,23),G0H4(33),m3h8x4(:,117),heltab2x32(:,:,1255))
  call Hloop_A_Q(ntryL,G0H4(33),19,nMT,G1H4(73),n2h4(447))
  Gcoeff(:)%j = (-(c(81)*M(1,:)%j)) * den(107)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1256),h0tab(:,1256),[19,4,8],[nMB,nMH,nMB],3,1,wf8(:,24))
  call Hloop_AZ_Q(ntryL,G0H32(1),wf8(:,24),G0H4(33),ngZd,m3h8x4(:,118),heltab2x32(:,:,1256))
  call Hloop_A_Q(ntryL,G0H4(33),19,nMB,G1H4(74),n2h4(448))
  Gcoeff(:)%j = (c(81)*M(1,:)%j) * den(107)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1257),h0tab(:,1257),[19,4,8],[nMB,nMZ,nMB],3,1,wf8(:,24))
  call Hloop_AZ_Q(ntryL,G0H32(1),wf8(:,24),G0H4(33),ngZd,m3h8x4(:,119),heltab2x32(:,:,1257))
  call Hloop_A_Q(ntryL,G0H4(33),19,nMB,G1H4(75),n2h4(449))
  Gcoeff(:)%j = (c(79)*M(1,:)%j) * den(107)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1258),h0tab(:,1258),[19,4,8],[nMT,nMW,nMT],3,1,wf8(:,24))
  call Hloop_AZ_Q(ntryL,G0H32(1),wf8(:,24),G0H4(33),ngZu,m3h8x4(:,120),heltab2x32(:,:,1258))
  call Hloop_A_Q(ntryL,G0H4(33),19,nMT,G1H4(78),n2h4(450))
  Gcoeff(:)%j = (c(78)*M(1,:)%j) * den(110)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1259),h0tab(:,1259),[19,4,8],[nMW,nMT,nMW],3,1,wf8(:,23))
  call Hloop_SV_T(ntryL,G0H32(1),0,wf8(:,23),19,G1H4(79),m3h8x4(:,121),heltab2x32(:,:,1259))
  Gcoeff(:)%j = (c(55)*M(1,:)%j) * den(107)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1260),h0tab(:,1260),[19,4,8],[nMH,nMB,nMZ],3,1,wf8(:,24))
  call Hloop_SV_T(ntryL,G0H32(1),0,wf8(:,24),19,G1H4(80),m3h8x4(:,122),heltab2x32(:,:,1260))
  Gcoeff(:)%j = (c(55)*M(1,:)%j) * den(107)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1261),h0tab(:,1261),[19,4,8],[nMZ,nMB,nMH],3,1,wf8(:,24))
  call Hloop_TV_S(ntryL,G0H32(1),0,wf8(:,24),19,G1H4(83),m3h8x4(:,123),heltab2x32(:,:,1261))
  Gcoeff(:)%j = (-(c(104)*M(1,:)%j)) * den(107)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1262),h0tab(:,1262),[19,4,8],[nMW,nMT,nMW],3,1,wf8(:,24))
  call Hloop_SV_T(ntryL,G0H32(1),0,wf8(:,24),19,G1H4(84),m3h8x4(:,124),heltab2x32(:,:,1262))
  Gcoeff(:)%j = (-(c(1)*M(1,:)%j)) * den(110)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1263),h0tab(:,1263),[19,4,8],[nMB,0,nMB],3,1,wf8(:,23))
  call Hloop_AV_Q(ntryL,G0H32(1),wf8(:,23),G0H4(33),m3h8x4(:,125),heltab2x32(:,:,1263))
  call Hloop_A_Q(ntryL,G0H4(33),19,nMB,G1H4(85),n2h4(451))
  Gcoeff(:)%j = (-(c(5)*M(1,:)%j)) * den(110)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1264),h0tab(:,1264),[19,4,8],[nMB,nMZ,nMB],3,1,wf8(:,23))
  call Hloop_AV_Q(ntryL,G0H32(1),wf8(:,23),G0H4(33),m3h8x4(:,126),heltab2x32(:,:,1264))
  call Hloop_A_Q(ntryL,G0H4(33),19,nMB,G1H4(88),n2h4(452))
  Gcoeff(:)%j = (c(63)*M(1,:)%j) * den(110)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1265),h0tab(:,1265),[19,4,8],[nMT,nMW,nMT],3,1,wf8(:,23))
  call Hloop_AV_Q(ntryL,G0H32(1),wf8(:,23),G0H4(33),m3h8x4(:,127),heltab2x32(:,:,1265))
  call Hloop_A_Q(ntryL,G0H4(33),19,nMT,G1H4(89),n2h4(453))
  Gcoeff(:)%j = (c(4)*M(1,:)%j) * den(107)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1266),h0tab(:,1266),[19,4,8],[nMB,0,nMB],3,1,wf8(:,24))
  call Hloop_AZ_Q(ntryL,G0H32(1),wf8(:,24),G0H4(33),ngZd,m3h8x4(:,128),heltab2x32(:,:,1266))
  call Hloop_A_Q(ntryL,G0H4(33),19,nMB,G1H4(90),n2h4(454))
  Gcoeff(:)%j = (c(7)*M(1,:)%j) * den(107)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1267),h0tab(:,1267),[19,4,8],[nMB,nMZ,nMB],3,1,wf8(:,24))
  call Hloop_AZ_Q(ntryL,G0H32(1),wf8(:,24),G0H4(33),ngZd,m3h8x4(:,129),heltab2x32(:,:,1267))
  call Hloop_A_Q(ntryL,G0H4(33),19,nMB,G1H4(93),n2h4(455))
  Gcoeff(:)%j = (c(65)*M(1,:)%j) * den(107)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1268),h0tab(:,1268),[19,4,8],[nMT,nMW,nMT],3,1,wf8(:,24))
  call Hloop_AZ_Q(ntryL,G0H32(1),wf8(:,24),G0H4(33),ngZu,m3h8x4(:,130),heltab2x32(:,:,1268))
  call Hloop_A_Q(ntryL,G0H4(33),19,nMT,G1H4(94),n2h4(456))
  Gcoeff(:)%j = (c(64)*M(1,:)%j) * den(110)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1269),h0tab(:,1269),[19,4,8],[nMW,nMT,nMW],3,1,wf8(:,23))
  call Hloop_VV_S(ntryL,G0H32(1),wf8(:,23),G0H4(33),m3h8x4(:,131),heltab2x32(:,:,1269))
  Gcoeff(:)%j = (-(c(70)*M(1,:)%j)) * den(107)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1270),h0tab(:,1270),[19,4,8],[nMH,nMB,nMZ],3,1,wf8(:,24))
  call Hloop_VV_S(ntryL,G0H32(1),wf8(:,24),G0H4(34),m3h8x4(:,132),heltab2x32(:,:,1270))
  Gcoeff(:)%j = (-(c(92)*M(1,:)%j)) * den(107)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1271),h0tab(:,1271),[19,4,8],[nMW,nMT,nMW],3,1,wf8(:,24))
  call Hloop_VV_S(ntryL,G0H32(1),wf8(:,24),G0H4(35),m3h8x4(:,133),heltab2x32(:,:,1271))
  Gcoeff(:)%j = (-(c(64)*M(1,:)%j)) * den(110)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1272),h0tab(:,1272),[19,4,8],[nMW,nMT,nMW],3,1,wf8(:,23))
  call Hloop_SV_V(ntryL,G0H32(1),wf8(:,23),G0H4(36),m3h8x4(:,134),heltab2x32(:,:,1272))
  Gcoeff(:)%j = (-(c(70)*M(1,:)%j)) * den(107)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1273),h0tab(:,1273),[19,4,8],[nMZ,nMB,nMH],3,1,wf8(:,24))
  call Hloop_SV_V(ntryL,G0H32(1),wf8(:,24),G0H4(37),m3h8x4(:,135),heltab2x32(:,:,1273))
  Gcoeff(:)%j = (c(92)*M(1,:)%j) * den(107)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1274),h0tab(:,1274),[19,4,8],[nMW,nMT,nMW],3,1,wf8(:,24))
  call Hloop_SV_V(ntryL,G0H32(1),wf8(:,24),G0H4(38),m3h8x4(:,136),heltab2x32(:,:,1274))
  Gcoeff(:)%j = (c(64)*M(1,:)%j) * den(110)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1275),h0tab(:,1275),[19,4,8],[nMW,nMT,nMW],3,1,wf8(:,23))
  call Hloop_UW_V(ntryL,G0H32(1),0,wf8(:,23),19,G1H4(95),m3h8x4(:,137),heltab2x32(:,:,1275))
  Gcoeff(:)%j = (c(48)*M(1,:)%j) * den(107)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1276),h0tab(:,1276),[19,4,8],[nMW,nMT,nMW],3,1,wf8(:,24))
  call Hloop_UW_V(ntryL,G0H32(1),0,wf8(:,24),19,G1H4(98),m3h8x4(:,138),heltab2x32(:,:,1276))
  Gcoeff(:)%j = (c(24)*M(2,:)%j) * den(73)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1277),h0tab(:,1277),[22,1,8],[nMT,nMH,nMB],3,1,wf8(:,97))
  call Hloop_AS_Q(ntryL,G0H32(1),wf8(:,97),G0H4(39),ngPbt,m3h8x4(:,139),heltab2x32(:,:,1277))
  call Hloop_A_Q(ntryL,G0H4(39),22,nMT,G1H4(99),n2h4(457))
  Gcoeff(:)%j = (c(24)*M(2,:)%j) * den(73)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1278),h0tab(:,1278),[22,1,8],[nMT,nMZ,nMB],3,1,wf8(:,97))
  call Hloop_AS_Q(ntryL,G0H32(1),wf8(:,97),G0H4(39),ngPbt,m3h8x4(:,140),heltab2x32(:,:,1278))
  call Hloop_A_Q(ntryL,G0H4(39),22,nMT,G1H4(100),n2h4(458))
  Gcoeff(:)%j = (c(26)*M(2,:)%j) * den(73)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1279),h0tab(:,1279),[22,1,8],[nMH,nMT,nMW],3,1,wf8(:,97))
  call Hloop_SS_S(ntryL,G0H32(1),wf8(:,97),G0H4(39),m3h8x4(:,141),heltab2x32(:,:,1279))
  Gcoeff(:)%j = (c(22)*M(2,:)%j) * den(73)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1280),h0tab(:,1280),[22,1,8],[nMW,nMB,nMH],3,1,wf8(:,97))
  call Hloop_SS_S(ntryL,G0H32(1),wf8(:,97),G0H4(40),m3h8x4(:,142),heltab2x32(:,:,1280))
  Gcoeff(:)%j = (c(75)*M(2,:)%j) * den(73)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1281),h0tab(:,1281),[22,1,8],[nMT,0,nMB],3,1,wf8(:,97))
  call Hloop_AS_Q(ntryL,G0H32(1),wf8(:,97),G0H4(41),ngPbt,m3h8x4(:,143),heltab2x32(:,:,1281))
  call Hloop_A_Q(ntryL,G0H4(41),22,nMT,G1H4(103),n2h4(459))
  Gcoeff(:)%j = (-(c(79)*M(2,:)%j)) * den(73)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1282),h0tab(:,1282),[22,1,8],[nMT,nMZ,nMB],3,1,wf8(:,97))
  call Hloop_AS_Q(ntryL,G0H32(1),wf8(:,97),G0H4(41),ngPbt,m3h8x4(:,144),heltab2x32(:,:,1282))
  call Hloop_A_Q(ntryL,G0H4(41),22,nMT,G1H4(104),n2h4(460))
  Gcoeff(:)%j = (c(76)*M(2,:)%j) * den(73)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1283),h0tab(:,1283),[22,1,8],[nMW,nMB,0],3,1,wf8(:,97))
  call Hloop_VT_S(ntryL,G0H32(1),0,wf8(:,97),22,G1H4(105),m3h8x4(:,145),heltab2x32(:,:,1283))
  Gcoeff(:)%j = (c(104)*M(2,:)%j) * den(73)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1284),h0tab(:,1284),[22,1,8],[nMW,nMB,nMZ],3,1,wf8(:,97))
  call Hloop_VT_S(ntryL,G0H32(1),0,wf8(:,97),22,G1H4(120),m3h8x4(:,146),heltab2x32(:,:,1284))
  Gcoeff(:)%j = (c(42)*M(2,:)%j) * den(73)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1285),h0tab(:,1285),[22,1,8],[nMH,nMT,nMW],3,1,wf8(:,97))
  call Hloop_VS_T(ntryL,G0H32(1),0,wf8(:,97),22,G1H4(109),m3h8x4(:,147),heltab2x32(:,:,1285))
  Gcoeff(:)%j = (-(c(42)*M(2,:)%j)) * den(73)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1286),h0tab(:,1286),[22,1,8],[nMZ,nMT,nMW],3,1,wf8(:,97))
  call Hloop_VS_T(ntryL,G0H32(1),0,wf8(:,97),22,G1H4(110),m3h8x4(:,148),heltab2x32(:,:,1286))
  Gcoeff(:)%j = (-(c(78)*M(2,:)%j)) * den(73)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1287),h0tab(:,1287),[22,1,8],[0,nMT,nMW],3,1,wf8(:,97))
  call Hloop_ST_V(ntryL,G0H32(1),0,wf8(:,97),22,G1H4(130),m3h8x4(:,149),heltab2x32(:,:,1287))
  Gcoeff(:)%j = (c(104)*M(2,:)%j) * den(73)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1288),h0tab(:,1288),[22,1,8],[nMZ,nMT,nMW],3,1,wf8(:,97))
  call Hloop_ST_V(ntryL,G0H32(1),0,wf8(:,97),22,G1H4(132),m3h8x4(:,150),heltab2x32(:,:,1288))
  Gcoeff(:)%j = (c(39)*M(2,:)%j) * den(73)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1289),h0tab(:,1289),[22,1,8],[nMW,nMB,nMH],3,1,wf8(:,97))
  call Hloop_TS_V(ntryL,G0H32(1),0,wf8(:,97),22,G1H4(115),m3h8x4(:,151),heltab2x32(:,:,1289))
  Gcoeff(:)%j = (c(39)*M(2,:)%j) * den(73)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1290),h0tab(:,1290),[22,1,8],[nMW,nMB,nMZ],3,1,wf8(:,97))
  call Hloop_TS_V(ntryL,G0H32(1),0,wf8(:,97),22,G1H4(121),m3h8x4(:,152),heltab2x32(:,:,1290))
  Gcoeff(:)%j = (-(c(64)*M(2,:)%j)) * den(73)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1291),h0tab(:,1291),[22,1,8],[0,nMT,nMW],3,1,wf8(:,97))
  call Hloop_VS_V(ntryL,G0H32(1),wf8(:,97),G0H4(41),m3h8x4(:,153),heltab2x32(:,:,1291))
  Gcoeff(:)%j = (c(62)*M(2,:)%j) * den(73)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1292),h0tab(:,1292),[22,1,8],[nMW,nMB,0],3,1,wf8(:,97))
  call Hloop_VS_V(ntryL,G0H32(1),wf8(:,97),G0H4(42),m3h8x4(:,154),heltab2x32(:,:,1292))
  Gcoeff(:)%j = (c(92)*M(2,:)%j) * den(73)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1293),h0tab(:,1293),[22,1,8],[nMZ,nMT,nMW],3,1,wf8(:,97))
  call Hloop_VS_V(ntryL,G0H32(1),wf8(:,97),G0H4(43),m3h8x4(:,155),heltab2x32(:,:,1293))
  Gcoeff(:)%j = (c(92)*M(2,:)%j) * den(73)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1294),h0tab(:,1294),[22,1,8],[nMW,nMB,nMZ],3,1,wf8(:,97))
  call Hloop_VS_V(ntryL,G0H32(1),wf8(:,97),G0H4(44),m3h8x4(:,156),heltab2x32(:,:,1294))
  Gcoeff(:)%j = (c(44)*M(2,:)%j) * den(73)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1295),h0tab(:,1295),[22,1,8],[nMT,nMH,nMB],3,1,wf8(:,98))
  call Hloop_AW_Q(ntryL,G0H32(1),wf8(:,98),G0H4(45),m3h8x4(:,157),heltab2x32(:,:,1295))
  call Hloop_A_Q(ntryL,G0H4(45),22,nMT,G1H4(122),n2h4(461))
  Gcoeff(:)%j = (c(44)*M(2,:)%j) * den(73)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1296),h0tab(:,1296),[22,1,8],[nMT,nMZ,nMB],3,1,wf8(:,98))
  call Hloop_AW_Q(ntryL,G0H32(1),wf8(:,98),G0H4(45),m3h8x4(:,158),heltab2x32(:,:,1296))
  call Hloop_A_Q(ntryL,G0H4(45),22,nMT,G1H4(123),n2h4(462))
  Gcoeff(:)%j = (c(42)*M(2,:)%j) * den(73)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1297),h0tab(:,1297),[22,1,8],[nMH,nMT,nMW],3,1,wf8(:,98))
  call Hloop_SV_T(ntryL,G0H32(1),0,wf8(:,98),22,G1H4(126),m3h8x4(:,159),heltab2x32(:,:,1297))
  Gcoeff(:)%j = (c(39)*M(2,:)%j) * den(73)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1298),h0tab(:,1298),[22,1,8],[nMW,nMB,nMH],3,1,wf8(:,98))
  call Hloop_TV_S(ntryL,G0H32(1),0,wf8(:,98),22,G1H4(127),m3h8x4(:,160),heltab2x32(:,:,1298))
  Gcoeff(:)%j = (c(42)*M(2,:)%j) * den(73)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1299),h0tab(:,1299),[22,1,8],[nMZ,nMT,nMW],3,1,wf8(:,98))
  call Hloop_SV_T(ntryL,G0H32(1),0,wf8(:,98),22,G1H4(128),m3h8x4(:,161),heltab2x32(:,:,1299))
  Gcoeff(:)%j = (-(c(39)*M(2,:)%j)) * den(73)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1300),h0tab(:,1300),[22,1,8],[nMW,nMB,nMZ],3,1,wf8(:,98))
  call Hloop_TV_S(ntryL,G0H32(1),0,wf8(:,98),22,G1H4(134),m3h8x4(:,162),heltab2x32(:,:,1300))
  Gcoeff(:)%j = (c(61)*M(2,:)%j) * den(73)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1301),h0tab(:,1301),[22,1,8],[nMT,0,nMB],3,1,wf8(:,98))
  call Hloop_AW_Q(ntryL,G0H32(1),wf8(:,98),G0H4(45),m3h8x4(:,163),heltab2x32(:,:,1301))
  call Hloop_A_Q(ntryL,G0H4(45),22,nMT,G1H4(135),n2h4(463))
  Gcoeff(:)%j = (-(c(65)*M(2,:)%j)) * den(73)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1302),h0tab(:,1302),[22,1,8],[nMT,nMZ,nMB],3,1,wf8(:,98))
  call Hloop_AW_Q(ntryL,G0H32(1),wf8(:,98),G0H4(45),m3h8x4(:,164),heltab2x32(:,:,1302))
  call Hloop_A_Q(ntryL,G0H4(45),22,nMT,G1H4(136),n2h4(464))
  Gcoeff(:)%j = (-(c(62)*M(2,:)%j)) * den(73)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1303),h0tab(:,1303),[22,1,8],[nMW,nMB,0],3,1,wf8(:,98))
  call Hloop_VV_S(ntryL,G0H32(1),wf8(:,98),G0H4(45),m3h8x4(:,165),heltab2x32(:,:,1303))
  Gcoeff(:)%j = (-(c(92)*M(2,:)%j)) * den(73)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1304),h0tab(:,1304),[22,1,8],[nMW,nMB,nMZ],3,1,wf8(:,98))
  call Hloop_VV_S(ntryL,G0H32(1),wf8(:,98),G0H4(46),m3h8x4(:,166),heltab2x32(:,:,1304))
  Gcoeff(:)%j = (c(15)*M(2,:)%j) * den(73)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1305),h0tab(:,1305),[22,1,8],[nMH,nMT,nMW],3,1,wf8(:,98))
  call Hloop_VV_S(ntryL,G0H32(1),wf8(:,98),G0H4(47),m3h8x4(:,167),heltab2x32(:,:,1305))
  Gcoeff(:)%j = (c(64)*M(2,:)%j) * den(73)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1306),h0tab(:,1306),[22,1,8],[0,nMT,nMW],3,1,wf8(:,98))
  call Hloop_SV_V(ntryL,G0H32(1),wf8(:,98),G0H4(48),m3h8x4(:,168),heltab2x32(:,:,1306))
  Gcoeff(:)%j = (-(c(92)*M(2,:)%j)) * den(73)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1307),h0tab(:,1307),[22,1,8],[nMZ,nMT,nMW],3,1,wf8(:,98))
  call Hloop_SV_V(ntryL,G0H32(1),wf8(:,98),G0H4(49),m3h8x4(:,169),heltab2x32(:,:,1307))
  Gcoeff(:)%j = (c(14)*M(2,:)%j) * den(73)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1308),h0tab(:,1308),[22,1,8],[nMW,nMB,nMH],3,1,wf8(:,98))
  call Hloop_SV_V(ntryL,G0H32(1),wf8(:,98),G0H4(50),m3h8x4(:,170),heltab2x32(:,:,1308))
  Gcoeff(:)%j = (-(c(64)*M(2,:)%j)) * den(73)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1309),h0tab(:,1309),[22,1,8],[0,nMT,nMW],3,1,wf8(:,98))
  call Hloop_UV_W(ntryL,G0H32(1),0,wf8(:,98),22,G1H4(139),m3h8x4(:,171),heltab2x32(:,:,1309))
  Gcoeff(:)%j = (c(62)*M(2,:)%j) * den(73)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1310),h0tab(:,1310),[22,1,8],[nMW,nMB,0],3,1,wf8(:,98))
  call Hloop_UW_V(ntryL,G0H32(1),0,wf8(:,98),22,G1H4(148),m3h8x4(:,172),heltab2x32(:,:,1310))
  Gcoeff(:)%j = (-(c(48)*M(2,:)%j)) * den(73)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1311),h0tab(:,1311),[22,1,8],[nMZ,nMT,nMW],3,1,wf8(:,98))
  call Hloop_UV_W(ntryL,G0H32(1),0,wf8(:,98),22,G1H4(141),m3h8x4(:,173),heltab2x32(:,:,1311))
  Gcoeff(:)%j = (-(c(48)*M(2,:)%j)) * den(73)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1312),h0tab(:,1312),[22,1,8],[nMW,nMB,nMZ],3,1,wf8(:,98))
  call Hloop_UW_V(ntryL,G0H32(1),0,wf8(:,98),22,G1H4(144),m3h8x4(:,174),heltab2x32(:,:,1312))
  Gcoeff(:)%j = (c(24)*M(2,:)%j) * den(78)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1313),h0tab(:,1313),[22,1,8],[nMT,nMH,nMB],3,1,wf8(:,101))
  call Hloop_AS_Q(ntryL,G0H32(1),wf8(:,101),G0H4(51),ngPbt,m3h8x4(:,175),heltab2x32(:,:,1313))
  call Hloop_A_Q(ntryL,G0H4(51),22,nMT,G1H4(145),n2h4(465))
  Gcoeff(:)%j = (c(24)*M(2,:)%j) * den(78)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1314),h0tab(:,1314),[22,1,8],[nMT,nMZ,nMB],3,1,wf8(:,101))
  call Hloop_AS_Q(ntryL,G0H32(1),wf8(:,101),G0H4(51),ngPbt,m3h8x4(:,176),heltab2x32(:,:,1314))
  call Hloop_A_Q(ntryL,G0H4(51),22,nMT,G1H4(146),n2h4(466))
  Gcoeff(:)%j = (c(26)*M(2,:)%j) * den(78)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1315),h0tab(:,1315),[22,1,8],[nMH,nMT,nMW],3,1,wf8(:,101))
  call Hloop_SS_S(ntryL,G0H32(1),wf8(:,101),G0H4(51),m3h8x4(:,177),heltab2x32(:,:,1315))
  Gcoeff(:)%j = (c(22)*M(2,:)%j) * den(78)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1316),h0tab(:,1316),[22,1,8],[nMW,nMB,nMH],3,1,wf8(:,101))
  call Hloop_SS_S(ntryL,G0H32(1),wf8(:,101),G0H4(52),m3h8x4(:,178),heltab2x32(:,:,1316))
  Gcoeff(:)%j = (c(75)*M(2,:)%j) * den(78)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1317),h0tab(:,1317),[22,1,8],[nMT,0,nMB],3,1,wf8(:,101))
  call Hloop_AS_Q(ntryL,G0H32(1),wf8(:,101),G0H4(53),ngPbt,m3h8x4(:,179),heltab2x32(:,:,1317))
  call Hloop_A_Q(ntryL,G0H4(53),22,nMT,G1H4(151),n2h4(467))
  Gcoeff(:)%j = (-(c(79)*M(2,:)%j)) * den(78)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1318),h0tab(:,1318),[22,1,8],[nMT,nMZ,nMB],3,1,wf8(:,101))
  call Hloop_AS_Q(ntryL,G0H32(1),wf8(:,101),G0H4(53),ngPbt,m3h8x4(:,180),heltab2x32(:,:,1318))
  call Hloop_A_Q(ntryL,G0H4(53),22,nMT,G1H4(164),n2h4(468))
  Gcoeff(:)%j = (c(76)*M(2,:)%j) * den(78)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1319),h0tab(:,1319),[22,1,8],[nMW,nMB,0],3,1,wf8(:,101))
  call Hloop_VT_S(ntryL,G0H32(1),0,wf8(:,101),22,G1H4(153),m3h8x4(:,181),heltab2x32(:,:,1319))
  Gcoeff(:)%j = (c(104)*M(2,:)%j) * den(78)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1320),h0tab(:,1320),[22,1,8],[nMW,nMB,nMZ],3,1,wf8(:,101))
  call Hloop_VT_S(ntryL,G0H32(1),0,wf8(:,101),22,G1H4(156),m3h8x4(:,182),heltab2x32(:,:,1320))
  Gcoeff(:)%j = (c(42)*M(2,:)%j) * den(78)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1321),h0tab(:,1321),[22,1,8],[nMH,nMT,nMW],3,1,wf8(:,101))
  call Hloop_VS_T(ntryL,G0H32(1),0,wf8(:,101),22,G1H4(157),m3h8x4(:,183),heltab2x32(:,:,1321))
  Gcoeff(:)%j = (-(c(42)*M(2,:)%j)) * den(78)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1322),h0tab(:,1322),[22,1,8],[nMZ,nMT,nMW],3,1,wf8(:,101))
  call Hloop_VS_T(ntryL,G0H32(1),0,wf8(:,101),22,G1H4(158),m3h8x4(:,184),heltab2x32(:,:,1322))
  Gcoeff(:)%j = (-(c(78)*M(2,:)%j)) * den(78)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1323),h0tab(:,1323),[22,1,8],[0,nMT,nMW],3,1,wf8(:,101))
  call Hloop_ST_V(ntryL,G0H32(1),0,wf8(:,101),22,G1H4(161),m3h8x4(:,185),heltab2x32(:,:,1323))
  Gcoeff(:)%j = (c(104)*M(2,:)%j) * den(78)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1324),h0tab(:,1324),[22,1,8],[nMZ,nMT,nMW],3,1,wf8(:,101))
  call Hloop_ST_V(ntryL,G0H32(1),0,wf8(:,101),22,G1H4(163),m3h8x4(:,186),heltab2x32(:,:,1324))
  Gcoeff(:)%j = (c(39)*M(2,:)%j) * den(78)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1325),h0tab(:,1325),[22,1,8],[nMW,nMB,nMH],3,1,wf8(:,101))
  call Hloop_TS_V(ntryL,G0H32(1),0,wf8(:,101),22,G1H4(165),m3h8x4(:,187),heltab2x32(:,:,1325))
  Gcoeff(:)%j = (c(39)*M(2,:)%j) * den(78)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1326),h0tab(:,1326),[22,1,8],[nMW,nMB,nMZ],3,1,wf8(:,101))
  call Hloop_TS_V(ntryL,G0H32(1),0,wf8(:,101),22,G1H4(168),m3h8x4(:,188),heltab2x32(:,:,1326))
  Gcoeff(:)%j = (-(c(64)*M(2,:)%j)) * den(78)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1327),h0tab(:,1327),[22,1,8],[0,nMT,nMW],3,1,wf8(:,101))
  call Hloop_VS_V(ntryL,G0H32(1),wf8(:,101),G0H4(53),m3h8x4(:,189),heltab2x32(:,:,1327))
  Gcoeff(:)%j = (c(62)*M(2,:)%j) * den(78)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1328),h0tab(:,1328),[22,1,8],[nMW,nMB,0],3,1,wf8(:,101))
  call Hloop_VS_V(ntryL,G0H32(1),wf8(:,101),G0H4(54),m3h8x4(:,190),heltab2x32(:,:,1328))
  Gcoeff(:)%j = (c(92)*M(2,:)%j) * den(78)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1329),h0tab(:,1329),[22,1,8],[nMZ,nMT,nMW],3,1,wf8(:,101))
  call Hloop_VS_V(ntryL,G0H32(1),wf8(:,101),G0H4(55),m3h8x4(:,191),heltab2x32(:,:,1329))
  Gcoeff(:)%j = (c(92)*M(2,:)%j) * den(78)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1330),h0tab(:,1330),[22,1,8],[nMW,nMB,nMZ],3,1,wf8(:,101))
  call Hloop_VS_V(ntryL,G0H32(1),wf8(:,101),G0H4(56),m3h8x4(:,192),heltab2x32(:,:,1330))
  Gcoeff(:)%j = (c(44)*M(2,:)%j) * den(78)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1331),h0tab(:,1331),[22,1,8],[nMT,nMH,nMB],3,1,wf8(:,102))
  call Hloop_AW_Q(ntryL,G0H32(1),wf8(:,102),G0H4(57),m3h8x4(:,193),heltab2x32(:,:,1331))
  call Hloop_A_Q(ntryL,G0H4(57),22,nMT,G1H4(169),n2h4(469))
  Gcoeff(:)%j = (c(44)*M(2,:)%j) * den(78)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1332),h0tab(:,1332),[22,1,8],[nMT,nMZ,nMB],3,1,wf8(:,102))
  call Hloop_AW_Q(ntryL,G0H32(1),wf8(:,102),G0H4(57),m3h8x4(:,194),heltab2x32(:,:,1332))
  call Hloop_A_Q(ntryL,G0H4(57),22,nMT,G1H4(170),n2h4(470))
  Gcoeff(:)%j = (c(42)*M(2,:)%j) * den(78)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1333),h0tab(:,1333),[22,1,8],[nMH,nMT,nMW],3,1,wf8(:,102))
  call Hloop_SV_T(ntryL,G0H32(1),0,wf8(:,102),22,G1H4(183),m3h8x4(:,195),heltab2x32(:,:,1333))
  Gcoeff(:)%j = (c(39)*M(2,:)%j) * den(78)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1334),h0tab(:,1334),[22,1,8],[nMW,nMB,nMH],3,1,wf8(:,102))
  call Hloop_TV_S(ntryL,G0H32(1),0,wf8(:,102),22,G1H4(174),m3h8x4(:,196),heltab2x32(:,:,1334))
  Gcoeff(:)%j = (c(42)*M(2,:)%j) * den(78)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1335),h0tab(:,1335),[22,1,8],[nMZ,nMT,nMW],3,1,wf8(:,102))
  call Hloop_SV_T(ntryL,G0H32(1),0,wf8(:,102),22,G1H4(186),m3h8x4(:,197),heltab2x32(:,:,1335))
  Gcoeff(:)%j = (-(c(39)*M(2,:)%j)) * den(78)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1336),h0tab(:,1336),[22,1,8],[nMW,nMB,nMZ],3,1,wf8(:,102))
  call Hloop_TV_S(ntryL,G0H32(1),0,wf8(:,102),22,G1H4(188),m3h8x4(:,198),heltab2x32(:,:,1336))
  Gcoeff(:)%j = (c(61)*M(2,:)%j) * den(78)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1337),h0tab(:,1337),[22,1,8],[nMT,0,nMB],3,1,wf8(:,102))
  call Hloop_AW_Q(ntryL,G0H32(1),wf8(:,102),G0H4(57),m3h8x4(:,199),heltab2x32(:,:,1337))
  call Hloop_A_Q(ntryL,G0H4(57),22,nMT,G1H4(179),n2h4(471))
  Gcoeff(:)%j = (-(c(65)*M(2,:)%j)) * den(78)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1338),h0tab(:,1338),[22,1,8],[nMT,nMZ,nMB],3,1,wf8(:,102))
  call Hloop_AW_Q(ntryL,G0H32(1),wf8(:,102),G0H4(57),m3h8x4(:,200),heltab2x32(:,:,1338))
  call Hloop_A_Q(ntryL,G0H4(57),22,nMT,G1H4(180),n2h4(472))
  Gcoeff(:)%j = (-(c(62)*M(2,:)%j)) * den(78)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1339),h0tab(:,1339),[22,1,8],[nMW,nMB,0],3,1,wf8(:,102))
  call Hloop_VV_S(ntryL,G0H32(1),wf8(:,102),G0H4(57),m3h8x4(:,201),heltab2x32(:,:,1339))
  Gcoeff(:)%j = (-(c(92)*M(2,:)%j)) * den(78)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1340),h0tab(:,1340),[22,1,8],[nMW,nMB,nMZ],3,1,wf8(:,102))
  call Hloop_VV_S(ntryL,G0H32(1),wf8(:,102),G0H4(58),m3h8x4(:,202),heltab2x32(:,:,1340))
  Gcoeff(:)%j = (c(15)*M(2,:)%j) * den(78)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1341),h0tab(:,1341),[22,1,8],[nMH,nMT,nMW],3,1,wf8(:,102))
  call Hloop_VV_S(ntryL,G0H32(1),wf8(:,102),G0H4(59),m3h8x4(:,203),heltab2x32(:,:,1341))
  Gcoeff(:)%j = (c(64)*M(2,:)%j) * den(78)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1342),h0tab(:,1342),[22,1,8],[0,nMT,nMW],3,1,wf8(:,102))
  call Hloop_SV_V(ntryL,G0H32(1),wf8(:,102),G0H4(60),m3h8x4(:,204),heltab2x32(:,:,1342))
  Gcoeff(:)%j = (-(c(92)*M(2,:)%j)) * den(78)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1343),h0tab(:,1343),[22,1,8],[nMZ,nMT,nMW],3,1,wf8(:,102))
  call Hloop_SV_V(ntryL,G0H32(1),wf8(:,102),G0H4(61),m3h8x4(:,205),heltab2x32(:,:,1343))
  Gcoeff(:)%j = (c(14)*M(2,:)%j) * den(78)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1344),h0tab(:,1344),[22,1,8],[nMW,nMB,nMH],3,1,wf8(:,102))
  call Hloop_SV_V(ntryL,G0H32(1),wf8(:,102),G0H4(62),m3h8x4(:,206),heltab2x32(:,:,1344))
  Gcoeff(:)%j = (-(c(64)*M(2,:)%j)) * den(78)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1345),h0tab(:,1345),[22,1,8],[0,nMT,nMW],3,1,wf8(:,102))
  call Hloop_UV_W(ntryL,G0H32(1),0,wf8(:,102),22,G1H4(189),m3h8x4(:,207),heltab2x32(:,:,1345))
  Gcoeff(:)%j = (c(62)*M(2,:)%j) * den(78)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1346),h0tab(:,1346),[22,1,8],[nMW,nMB,0],3,1,wf8(:,102))
  call Hloop_UW_V(ntryL,G0H32(1),0,wf8(:,102),22,G1H4(199),m3h8x4(:,208),heltab2x32(:,:,1346))
  Gcoeff(:)%j = (-(c(48)*M(2,:)%j)) * den(78)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1347),h0tab(:,1347),[22,1,8],[nMZ,nMT,nMW],3,1,wf8(:,102))
  call Hloop_UV_W(ntryL,G0H32(1),0,wf8(:,102),22,G1H4(198),m3h8x4(:,209),heltab2x32(:,:,1347))
  Gcoeff(:)%j = (-(c(48)*M(2,:)%j)) * den(78)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1348),h0tab(:,1348),[22,1,8],[nMW,nMB,nMZ],3,1,wf8(:,102))
  call Hloop_UW_V(ntryL,G0H32(1),0,wf8(:,102),22,G1H4(204),m3h8x4(:,210),heltab2x32(:,:,1348))
  Gcoeff(:)%j = (c(36)*M(4,:)%j) * den(30)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1349),h0tab(:,1349),[28,1,2],[nMT,nMH,nMT],3,1,wf8(:,73))
  call Hloop_AS_Q(ntryL,G0H32(1),wf8(:,73),G0H4(63),ngH,m3h8x4(:,211),heltab2x32(:,:,1349))
  call Hloop_A_Q(ntryL,G0H4(63),28,nMT,G1H4(195),n2h4(473))
  Gcoeff(:)%j = (-(c(36)*M(4,:)%j)) * den(30)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1350),h0tab(:,1350),[28,1,2],[nMT,nMZ,nMT],3,1,wf8(:,73))
  call Hloop_AS_Q(ntryL,G0H32(1),wf8(:,73),G0H4(63),ngH,m3h8x4(:,212),heltab2x32(:,:,1350))
  call Hloop_A_Q(ntryL,G0H4(63),28,nMT,G1H4(203),n2h4(474))
  Gcoeff(:)%j = (-(c(21)*M(4,:)%j)) * den(30)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1351),h0tab(:,1351),[28,1,2],[nMB,nMW,nMB],3,1,wf8(:,73))
  call Hloop_AS_Q(ntryL,G0H32(1),wf8(:,73),G0H4(63),ngH,m3h8x4(:,213),heltab2x32(:,:,1351))
  call Hloop_A_Q(ntryL,G0H4(63),28,nMB,G1H4(205),n2h4(475))
  Gcoeff(:)%j = (c(36)*M(4,:)%j) * den(33)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1352),h0tab(:,1352),[28,1,2],[nMT,nMH,nMT],3,1,wf8(:,74))
  call Hloop_AS_Q(ntryL,G0H32(1),wf8(:,74),G0H4(63),ngX,m3h8x4(:,214),heltab2x32(:,:,1352))
  call Hloop_A_Q(ntryL,G0H4(63),28,nMT,G1H4(212),n2h4(476))
  Gcoeff(:)%j = (-(c(36)*M(4,:)%j)) * den(33)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1353),h0tab(:,1353),[28,1,2],[nMT,nMZ,nMT],3,1,wf8(:,74))
  call Hloop_AS_Q(ntryL,G0H32(1),wf8(:,74),G0H4(63),ngX,m3h8x4(:,215),heltab2x32(:,:,1353))
  call Hloop_A_Q(ntryL,G0H4(63),28,nMT,G1H4(207),n2h4(477))
  Gcoeff(:)%j = (c(21)*M(4,:)%j) * den(33)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1354),h0tab(:,1354),[28,1,2],[nMB,nMW,nMB],3,1,wf8(:,74))
  call Hloop_AS_Q(ntryL,G0H32(1),wf8(:,74),G0H4(63),ngX,m3h8x4(:,216),heltab2x32(:,:,1354))
  call Hloop_A_Q(ntryL,G0H4(63),28,nMB,G1H4(210),n2h4(478))
  Gcoeff(:)%j = (c(35)*M(4,:)%j) * den(30)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1355),h0tab(:,1355),[28,1,2],[nMH,nMT,nMH],3,1,wf8(:,73))
  call Hloop_SS_S(ntryL,G0H32(1),wf8(:,73),G0H4(63),m3h8x4(:,217),heltab2x32(:,:,1355))
  Gcoeff(:)%j = (-(c(34)*M(4,:)%j)) * den(30)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1356),h0tab(:,1356),[28,1,2],[nMZ,nMT,nMZ],3,1,wf8(:,73))
  call Hloop_SS_S(ntryL,G0H32(1),wf8(:,73),G0H4(64),m3h8x4(:,218),heltab2x32(:,:,1356))
  Gcoeff(:)%j = (-(c(22)*M(4,:)%j)) * den(30)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1357),h0tab(:,1357),[28,1,2],[nMW,nMB,nMW],3,1,wf8(:,73))
  call Hloop_SS_S(ntryL,G0H32(1),wf8(:,73),G0H4(65),m3h8x4(:,219),heltab2x32(:,:,1357))
  Gcoeff(:)%j = (c(34)*M(4,:)%j) * den(33)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1358),h0tab(:,1358),[28,1,2],[nMH,nMT,nMZ],3,1,wf8(:,74))
  call Hloop_SS_S(ntryL,G0H32(1),wf8(:,74),G0H4(66),m3h8x4(:,220),heltab2x32(:,:,1358))
  Gcoeff(:)%j = (c(34)*M(4,:)%j) * den(33)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1359),h0tab(:,1359),[28,1,2],[nMZ,nMT,nMH],3,1,wf8(:,74))
  call Hloop_SS_S(ntryL,G0H32(1),wf8(:,74),G0H4(67),m3h8x4(:,221),heltab2x32(:,:,1359))
  Gcoeff(:)%j = (-(c(85)*M(4,:)%j)) * den(30)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1360),h0tab(:,1360),[28,1,2],[nMT,0,nMT],3,1,wf8(:,73))
  call Hloop_AS_Q(ntryL,G0H32(1),wf8(:,73),G0H4(68),ngH,m3h8x4(:,222),heltab2x32(:,:,1360))
  call Hloop_A_Q(ntryL,G0H4(68),28,nMT,G1H4(211),n2h4(479))
  Gcoeff(:)%j = (-(c(86)*M(4,:)%j)) * den(30)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1361),h0tab(:,1361),[28,1,2],[nMT,nMZ,nMT],3,1,wf8(:,73))
  call Hloop_AS_Q(ntryL,G0H32(1),wf8(:,73),G0H4(68),ngH,m3h8x4(:,223),heltab2x32(:,:,1361))
  call Hloop_A_Q(ntryL,G0H4(68),28,nMT,G1H4(215),n2h4(480))
  Gcoeff(:)%j = (-(c(40)*M(4,:)%j)) * den(30)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1362),h0tab(:,1362),[28,1,2],[nMB,nMW,nMB],3,1,wf8(:,73))
  call Hloop_AS_Q(ntryL,G0H32(1),wf8(:,73),G0H4(68),ngH,m3h8x4(:,224),heltab2x32(:,:,1362))
  call Hloop_A_Q(ntryL,G0H4(68),28,nMB,G1H4(223),n2h4(481))
  Gcoeff(:)%j = (-(c(85)*M(4,:)%j)) * den(33)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1363),h0tab(:,1363),[28,1,2],[nMT,0,nMT],3,1,wf8(:,74))
  call Hloop_AS_Q(ntryL,G0H32(1),wf8(:,74),G0H4(68),ngX,m3h8x4(:,225),heltab2x32(:,:,1363))
  call Hloop_A_Q(ntryL,G0H4(68),28,nMT,G1H4(224),n2h4(482))
  Gcoeff(:)%j = (-(c(86)*M(4,:)%j)) * den(33)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1364),h0tab(:,1364),[28,1,2],[nMT,nMZ,nMT],3,1,wf8(:,74))
  call Hloop_AS_Q(ntryL,G0H32(1),wf8(:,74),G0H4(68),ngX,m3h8x4(:,226),heltab2x32(:,:,1364))
  call Hloop_A_Q(ntryL,G0H4(68),28,nMT,G1H4(220),n2h4(483))
  Gcoeff(:)%j = (c(40)*M(4,:)%j) * den(33)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1365),h0tab(:,1365),[28,1,2],[nMB,nMW,nMB],3,1,wf8(:,74))
  call Hloop_AS_Q(ntryL,G0H32(1),wf8(:,74),G0H4(68),ngX,m3h8x4(:,227),heltab2x32(:,:,1365))
  call Hloop_A_Q(ntryL,G0H4(68),28,nMB,G1H4(226),n2h4(484))
  Gcoeff(:)%j = (-(c(57)*M(4,:)%j)) * den(30)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1366),h0tab(:,1366),[28,1,2],[nMZ,nMT,nMZ],3,1,wf8(:,73))
  call Hloop_VT_S(ntryL,G0H32(1),0,wf8(:,73),28,G1H4(239),m3h8x4(:,228),heltab2x32(:,:,1366))
  Gcoeff(:)%j = (-(c(39)*M(4,:)%j)) * den(30)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1367),h0tab(:,1367),[28,1,2],[nMW,nMB,nMW],3,1,wf8(:,73))
  call Hloop_VT_S(ntryL,G0H32(1),0,wf8(:,73),28,G1H4(240),m3h8x4(:,229),heltab2x32(:,:,1367))
  Gcoeff(:)%j = (c(57)*M(4,:)%j) * den(33)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1368),h0tab(:,1368),[28,1,2],[nMH,nMT,nMZ],3,1,wf8(:,74))
  call Hloop_VS_T(ntryL,G0H32(1),0,wf8(:,74),28,G1H4(231),m3h8x4(:,230),heltab2x32(:,:,1368))
  Gcoeff(:)%j = (c(39)*M(4,:)%j) * den(33)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1369),h0tab(:,1369),[28,1,2],[nMW,nMB,nMW],3,1,wf8(:,74))
  call Hloop_VT_S(ntryL,G0H32(1),0,wf8(:,74),28,G1H4(232),m3h8x4(:,231),heltab2x32(:,:,1369))
  Gcoeff(:)%j = (-(c(57)*M(4,:)%j)) * den(30)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1370),h0tab(:,1370),[28,1,2],[nMZ,nMT,nMZ],3,1,wf8(:,73))
  call Hloop_ST_V(ntryL,G0H32(1),0,wf8(:,73),28,G1H4(233),m3h8x4(:,232),heltab2x32(:,:,1370))
  Gcoeff(:)%j = (-(c(39)*M(4,:)%j)) * den(30)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1371),h0tab(:,1371),[28,1,2],[nMW,nMB,nMW],3,1,wf8(:,73))
  call Hloop_ST_V(ntryL,G0H32(1),0,wf8(:,73),28,G1H4(252),m3h8x4(:,233),heltab2x32(:,:,1371))
  Gcoeff(:)%j = (c(57)*M(4,:)%j) * den(33)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1372),h0tab(:,1372),[28,1,2],[nMZ,nMT,nMH],3,1,wf8(:,74))
  call Hloop_TS_V(ntryL,G0H32(1),0,wf8(:,74),28,G1H4(237),m3h8x4(:,234),heltab2x32(:,:,1372))
  Gcoeff(:)%j = (-(c(39)*M(4,:)%j)) * den(33)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1373),h0tab(:,1373),[28,1,2],[nMW,nMB,nMW],3,1,wf8(:,74))
  call Hloop_ST_V(ntryL,G0H32(1),0,wf8(:,74),28,G1H4(238),m3h8x4(:,235),heltab2x32(:,:,1373))
  Gcoeff(:)%j = (-(c(70)*M(4,:)%j)) * den(30)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1374),h0tab(:,1374),[28,1,2],[nMZ,nMT,nMZ],3,1,wf8(:,73))
  call Hloop_VS_V(ntryL,G0H32(1),wf8(:,73),G0H4(68),m3h8x4(:,236),heltab2x32(:,:,1374))
  Gcoeff(:)%j = (-(c(14)*M(4,:)%j)) * den(30)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1375),h0tab(:,1375),[28,1,2],[nMW,nMB,nMW],3,1,wf8(:,73))
  call Hloop_VS_V(ntryL,G0H32(1),wf8(:,73),G0H4(69),m3h8x4(:,237),heltab2x32(:,:,1375))
  Gcoeff(:)%j = (c(88)*M(4,:)%j) * den(36)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1376),h0tab(:,1376),[28,1,2],[nMT,nMH,nMT],3,1,wf8(:,75))
  call Hloop_AV_Q(ntryL,G0H32(1),wf8(:,75),G0H4(70),m3h8x4(:,238),heltab2x32(:,:,1376))
  call Hloop_A_Q(ntryL,G0H4(70),28,nMT,G1H4(243),n2h4(485))
  Gcoeff(:)%j = (-(c(88)*M(4,:)%j)) * den(36)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1377),h0tab(:,1377),[28,1,2],[nMT,nMZ,nMT],3,1,wf8(:,75))
  call Hloop_AV_Q(ntryL,G0H32(1),wf8(:,75),G0H4(70),m3h8x4(:,239),heltab2x32(:,:,1377))
  call Hloop_A_Q(ntryL,G0H4(70),28,nMT,G1H4(244),n2h4(486))
  Gcoeff(:)%j = (c(74)*M(4,:)%j) * den(36)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1378),h0tab(:,1378),[28,1,2],[nMB,nMW,nMB],3,1,wf8(:,75))
  call Hloop_AV_Q(ntryL,G0H32(1),wf8(:,75),G0H4(70),m3h8x4(:,240),heltab2x32(:,:,1378))
  call Hloop_A_Q(ntryL,G0H4(70),28,nMB,G1H4(245),n2h4(487))
  Gcoeff(:)%j = (-(c(89)*M(4,:)%j)) * den(33)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1379),h0tab(:,1379),[28,1,2],[nMT,nMH,nMT],3,1,wf8(:,76))
  call Hloop_AZ_Q(ntryL,G0H32(1),wf8(:,76),G0H4(70),ngZu,m3h8x4(:,241),heltab2x32(:,:,1379))
  call Hloop_A_Q(ntryL,G0H4(70),28,nMT,G1H4(248),n2h4(488))
  Gcoeff(:)%j = (c(89)*M(4,:)%j) * den(33)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1380),h0tab(:,1380),[28,1,2],[nMT,nMZ,nMT],3,1,wf8(:,76))
  call Hloop_AZ_Q(ntryL,G0H32(1),wf8(:,76),G0H4(70),ngZu,m3h8x4(:,242),heltab2x32(:,:,1380))
  call Hloop_A_Q(ntryL,G0H4(70),28,nMT,G1H4(273),n2h4(489))
  Gcoeff(:)%j = (c(79)*M(4,:)%j) * den(33)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1381),h0tab(:,1381),[28,1,2],[nMB,nMW,nMB],3,1,wf8(:,76))
  call Hloop_AZ_Q(ntryL,G0H32(1),wf8(:,76),G0H4(70),ngZd,m3h8x4(:,243),heltab2x32(:,:,1381))
  call Hloop_A_Q(ntryL,G0H4(70),28,nMB,G1H4(274),n2h4(490))
  Gcoeff(:)%j = (-(c(76)*M(4,:)%j)) * den(36)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1382),h0tab(:,1382),[28,1,2],[nMW,nMB,nMW],3,1,wf8(:,75))
  call Hloop_TV_S(ntryL,G0H32(1),0,wf8(:,75),28,G1H4(275),m3h8x4(:,244),heltab2x32(:,:,1382))
  Gcoeff(:)%j = (-(c(59)*M(4,:)%j)) * den(33)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1383),h0tab(:,1383),[28,1,2],[nMH,nMT,nMZ],3,1,wf8(:,76))
  call Hloop_SV_T(ntryL,G0H32(1),0,wf8(:,76),28,G1H4(276),m3h8x4(:,245),heltab2x32(:,:,1383))
  Gcoeff(:)%j = (-(c(59)*M(4,:)%j)) * den(33)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1384),h0tab(:,1384),[28,1,2],[nMZ,nMT,nMH],3,1,wf8(:,76))
  call Hloop_TV_S(ntryL,G0H32(1),0,wf8(:,76),28,G1H4(277),m3h8x4(:,246),heltab2x32(:,:,1384))
  Gcoeff(:)%j = (-(c(104)*M(4,:)%j)) * den(33)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1385),h0tab(:,1385),[28,1,2],[nMW,nMB,nMW],3,1,wf8(:,76))
  call Hloop_TV_S(ntryL,G0H32(1),0,wf8(:,76),28,G1H4(278),m3h8x4(:,247),heltab2x32(:,:,1385))
  Gcoeff(:)%j = (-(c(3)*M(4,:)%j)) * den(36)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1386),h0tab(:,1386),[28,1,2],[nMT,0,nMT],3,1,wf8(:,75))
  call Hloop_AV_Q(ntryL,G0H32(1),wf8(:,75),G0H4(70),m3h8x4(:,248),heltab2x32(:,:,1386))
  call Hloop_A_Q(ntryL,G0H4(70),28,nMT,G1H4(279),n2h4(491))
  Gcoeff(:)%j = (-(c(5)*M(4,:)%j)) * den(36)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1387),h0tab(:,1387),[28,1,2],[nMT,nMZ,nMT],3,1,wf8(:,75))
  call Hloop_AV_Q(ntryL,G0H32(1),wf8(:,75),G0H4(70),m3h8x4(:,249),heltab2x32(:,:,1387))
  call Hloop_A_Q(ntryL,G0H4(70),28,nMT,G1H4(280),n2h4(492))
  Gcoeff(:)%j = (c(60)*M(4,:)%j) * den(36)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1388),h0tab(:,1388),[28,1,2],[nMB,nMW,nMB],3,1,wf8(:,75))
  call Hloop_AV_Q(ntryL,G0H32(1),wf8(:,75),G0H4(70),m3h8x4(:,250),heltab2x32(:,:,1388))
  call Hloop_A_Q(ntryL,G0H4(70),28,nMB,G1H4(281),n2h4(493))
  Gcoeff(:)%j = (c(6)*M(4,:)%j) * den(33)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1389),h0tab(:,1389),[28,1,2],[nMT,0,nMT],3,1,wf8(:,76))
  call Hloop_AZ_Q(ntryL,G0H32(1),wf8(:,76),G0H4(70),ngZu,m3h8x4(:,251),heltab2x32(:,:,1389))
  call Hloop_A_Q(ntryL,G0H4(70),28,nMT,G1H4(282),n2h4(494))
  Gcoeff(:)%j = (c(7)*M(4,:)%j) * den(33)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1390),h0tab(:,1390),[28,1,2],[nMT,nMZ,nMT],3,1,wf8(:,76))
  call Hloop_AZ_Q(ntryL,G0H32(1),wf8(:,76),G0H4(70),ngZu,m3h8x4(:,252),heltab2x32(:,:,1390))
  call Hloop_A_Q(ntryL,G0H4(70),28,nMT,G1H4(283),n2h4(495))
  Gcoeff(:)%j = (c(65)*M(4,:)%j) * den(33)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1391),h0tab(:,1391),[28,1,2],[nMB,nMW,nMB],3,1,wf8(:,76))
  call Hloop_AZ_Q(ntryL,G0H32(1),wf8(:,76),G0H4(70),ngZd,m3h8x4(:,253),heltab2x32(:,:,1391))
  call Hloop_A_Q(ntryL,G0H4(70),28,nMB,G1H4(284),n2h4(496))
  Gcoeff(:)%j = (c(62)*M(4,:)%j) * den(36)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1392),h0tab(:,1392),[28,1,2],[nMW,nMB,nMW],3,1,wf8(:,75))
  call Hloop_VV_S(ntryL,G0H32(1),wf8(:,75),G0H4(70),m3h8x4(:,254),heltab2x32(:,:,1392))
  Gcoeff(:)%j = (-(c(73)*M(4,:)%j)) * den(33)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1393),h0tab(:,1393),[28,1,2],[nMH,nMT,nMZ],3,1,wf8(:,76))
  call Hloop_VV_S(ntryL,G0H32(1),wf8(:,76),G0H4(71),m3h8x4(:,255),heltab2x32(:,:,1393))
  Gcoeff(:)%j = (c(92)*M(4,:)%j) * den(33)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1394),h0tab(:,1394),[28,1,2],[nMW,nMB,nMW],3,1,wf8(:,76))
  call Hloop_VV_S(ntryL,G0H32(1),wf8(:,76),G0H4(72),m3h8x4(:,256),heltab2x32(:,:,1394))
  Gcoeff(:)%j = (-(c(62)*M(4,:)%j)) * den(36)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1395),h0tab(:,1395),[28,1,2],[nMW,nMB,nMW],3,1,wf8(:,75))
  call Hloop_SV_V(ntryL,G0H32(1),wf8(:,75),G0H4(73),m3h8x4(:,257),heltab2x32(:,:,1395))
  Gcoeff(:)%j = (-(c(73)*M(4,:)%j)) * den(33)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1396),h0tab(:,1396),[28,1,2],[nMZ,nMT,nMH],3,1,wf8(:,76))
  call Hloop_SV_V(ntryL,G0H32(1),wf8(:,76),G0H4(74),m3h8x4(:,258),heltab2x32(:,:,1396))
  Gcoeff(:)%j = (-(c(92)*M(4,:)%j)) * den(33)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1397),h0tab(:,1397),[28,1,2],[nMW,nMB,nMW],3,1,wf8(:,76))
  call Hloop_SV_V(ntryL,G0H32(1),wf8(:,76),G0H4(75),m3h8x4(:,259),heltab2x32(:,:,1397))
  Gcoeff(:)%j = (-(c(62)*M(4,:)%j)) * den(36)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1398),h0tab(:,1398),[28,1,2],[nMW,nMB,nMW],3,1,wf8(:,75))
  call Hloop_UV_W(ntryL,G0H32(1),0,wf8(:,75),28,G1H4(285),m3h8x4(:,260),heltab2x32(:,:,1398))
  Gcoeff(:)%j = (c(48)*M(4,:)%j) * den(33)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1399),h0tab(:,1399),[28,1,2],[nMW,nMB,nMW],3,1,wf8(:,76))
  call Hloop_UV_W(ntryL,G0H32(1),0,wf8(:,76),28,G1H4(286),m3h8x4(:,261),heltab2x32(:,:,1399))
  Gcoeff(:)%j = (c(24)*M(3,:)%j) * den(68)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1400),h0tab(:,1400),[25,2,4],[nMT,nMH,nMB],3,1,wf8(:,93))
  call Hloop_QS_A(ntryL,G0H32(1),wf8(:,93),G0H4(76),ngPtb,m3h8x4(:,262),heltab2x32(:,:,1400))
  call Hloop_Q_A(ntryL,G0H4(76),25,nMT,G1H4(287),n2h4(497))
  Gcoeff(:)%j = (c(24)*M(3,:)%j) * den(68)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1401),h0tab(:,1401),[25,2,4],[nMT,nMZ,nMB],3,1,wf8(:,93))
  call Hloop_QS_A(ntryL,G0H32(1),wf8(:,93),G0H4(76),ngPtb,m3h8x4(:,263),heltab2x32(:,:,1401))
  call Hloop_Q_A(ntryL,G0H4(76),25,nMT,G1H4(288),n2h4(498))
  Gcoeff(:)%j = (c(26)*M(3,:)%j) * den(68)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1402),h0tab(:,1402),[25,2,4],[nMH,nMT,nMW],3,1,wf8(:,93))
  call Hloop_SS_S(ntryL,G0H32(1),wf8(:,93),G0H4(76),m3h8x4(:,264),heltab2x32(:,:,1402))
  Gcoeff(:)%j = (c(22)*M(3,:)%j) * den(68)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1403),h0tab(:,1403),[25,2,4],[nMW,nMB,nMH],3,1,wf8(:,93))
  call Hloop_SS_S(ntryL,G0H32(1),wf8(:,93),G0H4(77),m3h8x4(:,265),heltab2x32(:,:,1403))
  Gcoeff(:)%j = (c(75)*M(3,:)%j) * den(68)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1404),h0tab(:,1404),[25,2,4],[nMT,0,nMB],3,1,wf8(:,93))
  call Hloop_QS_A(ntryL,G0H32(1),wf8(:,93),G0H4(78),ngPtb,m3h8x4(:,266),heltab2x32(:,:,1404))
  call Hloop_Q_A(ntryL,G0H4(78),25,nMT,G1H4(289),n2h4(499))
  Gcoeff(:)%j = (-(c(79)*M(3,:)%j)) * den(68)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1405),h0tab(:,1405),[25,2,4],[nMT,nMZ,nMB],3,1,wf8(:,93))
  call Hloop_QS_A(ntryL,G0H32(1),wf8(:,93),G0H4(78),ngPtb,m3h8x4(:,267),heltab2x32(:,:,1405))
  call Hloop_Q_A(ntryL,G0H4(78),25,nMT,G1H4(290),n2h4(500))
  Gcoeff(:)%j = (c(76)*M(3,:)%j) * den(68)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1406),h0tab(:,1406),[25,2,4],[nMW,nMB,0],3,1,wf8(:,93))
  call Hloop_VS_T(ntryL,G0H32(1),0,wf8(:,93),25,G1H4(291),m3h8x4(:,268),heltab2x32(:,:,1406))
  Gcoeff(:)%j = (c(104)*M(3,:)%j) * den(68)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1407),h0tab(:,1407),[25,2,4],[nMW,nMB,nMZ],3,1,wf8(:,93))
  call Hloop_VS_T(ntryL,G0H32(1),0,wf8(:,93),25,G1H4(292),m3h8x4(:,269),heltab2x32(:,:,1407))
  Gcoeff(:)%j = (c(42)*M(3,:)%j) * den(68)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1408),h0tab(:,1408),[25,2,4],[nMH,nMT,nMW],3,1,wf8(:,93))
  call Hloop_VS_T(ntryL,G0H32(1),0,wf8(:,93),25,G1H4(293),m3h8x4(:,270),heltab2x32(:,:,1408))
  Gcoeff(:)%j = (c(42)*M(3,:)%j) * den(68)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1409),h0tab(:,1409),[25,2,4],[nMZ,nMT,nMW],3,1,wf8(:,93))
  call Hloop_VS_T(ntryL,G0H32(1),0,wf8(:,93),25,G1H4(294),m3h8x4(:,271),heltab2x32(:,:,1409))
  Gcoeff(:)%j = (-(c(78)*M(3,:)%j)) * den(68)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1410),h0tab(:,1410),[25,2,4],[0,nMT,nMW],3,1,wf8(:,93))
  call Hloop_TS_V(ntryL,G0H32(1),0,wf8(:,93),25,G1H4(295),m3h8x4(:,272),heltab2x32(:,:,1410))
  Gcoeff(:)%j = (c(104)*M(3,:)%j) * den(68)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1411),h0tab(:,1411),[25,2,4],[nMZ,nMT,nMW],3,1,wf8(:,93))
  call Hloop_TS_V(ntryL,G0H32(1),0,wf8(:,93),25,G1H4(296),m3h8x4(:,273),heltab2x32(:,:,1411))
  Gcoeff(:)%j = (c(39)*M(3,:)%j) * den(68)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1412),h0tab(:,1412),[25,2,4],[nMW,nMB,nMH],3,1,wf8(:,93))
  call Hloop_TS_V(ntryL,G0H32(1),0,wf8(:,93),25,G1H4(297),m3h8x4(:,274),heltab2x32(:,:,1412))
  Gcoeff(:)%j = (-(c(39)*M(3,:)%j)) * den(68)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1413),h0tab(:,1413),[25,2,4],[nMW,nMB,nMZ],3,1,wf8(:,93))
  call Hloop_TS_V(ntryL,G0H32(1),0,wf8(:,93),25,G1H4(298),m3h8x4(:,275),heltab2x32(:,:,1413))
  Gcoeff(:)%j = (c(64)*M(3,:)%j) * den(68)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1414),h0tab(:,1414),[25,2,4],[0,nMT,nMW],3,1,wf8(:,93))
  call Hloop_VS_V(ntryL,G0H32(1),wf8(:,93),G0H4(78),m3h8x4(:,276),heltab2x32(:,:,1414))
  Gcoeff(:)%j = (-(c(62)*M(3,:)%j)) * den(68)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1415),h0tab(:,1415),[25,2,4],[nMW,nMB,0],3,1,wf8(:,93))
  call Hloop_VS_V(ntryL,G0H32(1),wf8(:,93),G0H4(79),m3h8x4(:,277),heltab2x32(:,:,1415))
  Gcoeff(:)%j = (-(c(92)*M(3,:)%j)) * den(68)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1416),h0tab(:,1416),[25,2,4],[nMZ,nMT,nMW],3,1,wf8(:,93))
  call Hloop_VS_V(ntryL,G0H32(1),wf8(:,93),G0H4(80),m3h8x4(:,278),heltab2x32(:,:,1416))
  Gcoeff(:)%j = (-(c(92)*M(3,:)%j)) * den(68)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1417),h0tab(:,1417),[25,2,4],[nMW,nMB,nMZ],3,1,wf8(:,93))
  call Hloop_VS_V(ntryL,G0H32(1),wf8(:,93),G0H4(81),m3h8x4(:,279),heltab2x32(:,:,1417))
  Gcoeff(:)%j = (c(44)*M(3,:)%j) * den(68)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1418),h0tab(:,1418),[25,2,4],[nMT,nMH,nMB],3,1,wf8(:,94))
  call Hloop_QW_A(ntryL,G0H32(1),wf8(:,94),G0H4(82),m3h8x4(:,280),heltab2x32(:,:,1418))
  call Hloop_Q_A(ntryL,G0H4(82),25,nMT,G1H4(299),n2h4(501))
  Gcoeff(:)%j = (c(44)*M(3,:)%j) * den(68)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1419),h0tab(:,1419),[25,2,4],[nMT,nMZ,nMB],3,1,wf8(:,94))
  call Hloop_QW_A(ntryL,G0H32(1),wf8(:,94),G0H4(82),m3h8x4(:,281),heltab2x32(:,:,1419))
  call Hloop_Q_A(ntryL,G0H4(82),25,nMT,G1H4(300),n2h4(502))
  Gcoeff(:)%j = (c(42)*M(3,:)%j) * den(68)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1420),h0tab(:,1420),[25,2,4],[nMH,nMT,nMW],3,1,wf8(:,94))
  call Hloop_SV_T(ntryL,G0H32(1),0,wf8(:,94),25,G1H4(301),m3h8x4(:,282),heltab2x32(:,:,1420))
  Gcoeff(:)%j = (c(39)*M(3,:)%j) * den(68)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1421),h0tab(:,1421),[25,2,4],[nMW,nMB,nMH],3,1,wf8(:,94))
  call Hloop_TV_S(ntryL,G0H32(1),0,wf8(:,94),25,G1H4(302),m3h8x4(:,283),heltab2x32(:,:,1421))
  Gcoeff(:)%j = (-(c(42)*M(3,:)%j)) * den(68)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1422),h0tab(:,1422),[25,2,4],[nMZ,nMT,nMW],3,1,wf8(:,94))
  call Hloop_SV_T(ntryL,G0H32(1),0,wf8(:,94),25,G1H4(303),m3h8x4(:,284),heltab2x32(:,:,1422))
  Gcoeff(:)%j = (c(39)*M(3,:)%j) * den(68)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1423),h0tab(:,1423),[25,2,4],[nMW,nMB,nMZ],3,1,wf8(:,94))
  call Hloop_TV_S(ntryL,G0H32(1),0,wf8(:,94),25,G1H4(304),m3h8x4(:,285),heltab2x32(:,:,1423))
  Gcoeff(:)%j = (c(61)*M(3,:)%j) * den(68)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1424),h0tab(:,1424),[25,2,4],[nMT,0,nMB],3,1,wf8(:,94))
  call Hloop_QW_A(ntryL,G0H32(1),wf8(:,94),G0H4(82),m3h8x4(:,286),heltab2x32(:,:,1424))
  call Hloop_Q_A(ntryL,G0H4(82),25,nMT,G1H4(305),n2h4(503))
  Gcoeff(:)%j = (-(c(65)*M(3,:)%j)) * den(68)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1425),h0tab(:,1425),[25,2,4],[nMT,nMZ,nMB],3,1,wf8(:,94))
  call Hloop_QW_A(ntryL,G0H32(1),wf8(:,94),G0H4(82),m3h8x4(:,287),heltab2x32(:,:,1425))
  call Hloop_Q_A(ntryL,G0H4(82),25,nMT,G1H4(306),n2h4(504))
  Gcoeff(:)%j = (c(62)*M(3,:)%j) * den(68)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1426),h0tab(:,1426),[25,2,4],[nMW,nMB,0],3,1,wf8(:,94))
  call Hloop_VV_S(ntryL,G0H32(1),wf8(:,94),G0H4(82),m3h8x4(:,288),heltab2x32(:,:,1426))
  Gcoeff(:)%j = (c(92)*M(3,:)%j) * den(68)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1427),h0tab(:,1427),[25,2,4],[nMW,nMB,nMZ],3,1,wf8(:,94))
  call Hloop_VV_S(ntryL,G0H32(1),wf8(:,94),G0H4(83),m3h8x4(:,289),heltab2x32(:,:,1427))
  Gcoeff(:)%j = (c(15)*M(3,:)%j) * den(68)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1428),h0tab(:,1428),[25,2,4],[nMH,nMT,nMW],3,1,wf8(:,94))
  call Hloop_VV_S(ntryL,G0H32(1),wf8(:,94),G0H4(84),m3h8x4(:,290),heltab2x32(:,:,1428))
  Gcoeff(:)%j = (-(c(64)*M(3,:)%j)) * den(68)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1429),h0tab(:,1429),[25,2,4],[0,nMT,nMW],3,1,wf8(:,94))
  call Hloop_SV_V(ntryL,G0H32(1),wf8(:,94),G0H4(85),m3h8x4(:,291),heltab2x32(:,:,1429))
  Gcoeff(:)%j = (c(92)*M(3,:)%j) * den(68)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1430),h0tab(:,1430),[25,2,4],[nMZ,nMT,nMW],3,1,wf8(:,94))
  call Hloop_SV_V(ntryL,G0H32(1),wf8(:,94),G0H4(86),m3h8x4(:,292),heltab2x32(:,:,1430))
  Gcoeff(:)%j = (c(14)*M(3,:)%j) * den(68)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1431),h0tab(:,1431),[25,2,4],[nMW,nMB,nMH],3,1,wf8(:,94))
  call Hloop_SV_V(ntryL,G0H32(1),wf8(:,94),G0H4(87),m3h8x4(:,293),heltab2x32(:,:,1431))
  Gcoeff(:)%j = (-(c(64)*M(3,:)%j)) * den(68)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1432),h0tab(:,1432),[25,2,4],[0,nMT,nMW],3,1,wf8(:,94))
  call Hloop_UW_V(ntryL,G0H32(1),0,wf8(:,94),25,G1H4(307),m3h8x4(:,294),heltab2x32(:,:,1432))
  Gcoeff(:)%j = (c(62)*M(3,:)%j) * den(68)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1433),h0tab(:,1433),[25,2,4],[nMW,nMB,0],3,1,wf8(:,94))
  call Hloop_UV_W(ntryL,G0H32(1),0,wf8(:,94),25,G1H4(308),m3h8x4(:,295),heltab2x32(:,:,1433))
  Gcoeff(:)%j = (-(c(48)*M(3,:)%j)) * den(68)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1434),h0tab(:,1434),[25,2,4],[nMZ,nMT,nMW],3,1,wf8(:,94))
  call Hloop_UW_V(ntryL,G0H32(1),0,wf8(:,94),25,G1H4(309),m3h8x4(:,296),heltab2x32(:,:,1434))
  Gcoeff(:)%j = (-(c(48)*M(3,:)%j)) * den(68)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1435),h0tab(:,1435),[25,2,4],[nMW,nMB,nMZ],3,1,wf8(:,94))
  call Hloop_UV_W(ntryL,G0H32(1),0,wf8(:,94),25,G1H4(310),m3h8x4(:,297),heltab2x32(:,:,1435))
  Gcoeff(:)%j = (c(36)*M(4,:)%j) * den(47)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1436),h0tab(:,1436),[28,1,2],[nMT,nMH,nMT],3,1,wf8(:,81))
  call Hloop_AS_Q(ntryL,G0H32(1),wf8(:,81),G0H4(88),ngH,m3h8x4(:,298),heltab2x32(:,:,1436))
  call Hloop_A_Q(ntryL,G0H4(88),28,nMT,G1H4(311),n2h4(505))
  Gcoeff(:)%j = (-(c(36)*M(4,:)%j)) * den(47)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1437),h0tab(:,1437),[28,1,2],[nMT,nMZ,nMT],3,1,wf8(:,81))
  call Hloop_AS_Q(ntryL,G0H32(1),wf8(:,81),G0H4(88),ngH,m3h8x4(:,299),heltab2x32(:,:,1437))
  call Hloop_A_Q(ntryL,G0H4(88),28,nMT,G1H4(312),n2h4(506))
  Gcoeff(:)%j = (-(c(21)*M(4,:)%j)) * den(47)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1438),h0tab(:,1438),[28,1,2],[nMB,nMW,nMB],3,1,wf8(:,81))
  call Hloop_AS_Q(ntryL,G0H32(1),wf8(:,81),G0H4(88),ngH,m3h8x4(:,300),heltab2x32(:,:,1438))
  call Hloop_A_Q(ntryL,G0H4(88),28,nMB,G1H4(313),n2h4(507))
  Gcoeff(:)%j = (c(36)*M(4,:)%j) * den(49)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1439),h0tab(:,1439),[28,1,2],[nMT,nMH,nMT],3,1,wf8(:,82))
  call Hloop_AS_Q(ntryL,G0H32(1),wf8(:,82),G0H4(88),ngX,m3h8x4(:,301),heltab2x32(:,:,1439))
  call Hloop_A_Q(ntryL,G0H4(88),28,nMT,G1H4(314),n2h4(508))
  Gcoeff(:)%j = (-(c(36)*M(4,:)%j)) * den(49)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1440),h0tab(:,1440),[28,1,2],[nMT,nMZ,nMT],3,1,wf8(:,82))
  call Hloop_AS_Q(ntryL,G0H32(1),wf8(:,82),G0H4(88),ngX,m3h8x4(:,302),heltab2x32(:,:,1440))
  call Hloop_A_Q(ntryL,G0H4(88),28,nMT,G1H4(315),n2h4(509))
  Gcoeff(:)%j = (c(21)*M(4,:)%j) * den(49)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1441),h0tab(:,1441),[28,1,2],[nMB,nMW,nMB],3,1,wf8(:,82))
  call Hloop_AS_Q(ntryL,G0H32(1),wf8(:,82),G0H4(88),ngX,m3h8x4(:,303),heltab2x32(:,:,1441))
  call Hloop_A_Q(ntryL,G0H4(88),28,nMB,G1H4(316),n2h4(510))
  Gcoeff(:)%j = (c(35)*M(4,:)%j) * den(47)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1442),h0tab(:,1442),[28,1,2],[nMH,nMT,nMH],3,1,wf8(:,81))
  call Hloop_SS_S(ntryL,G0H32(1),wf8(:,81),G0H4(88),m3h8x4(:,304),heltab2x32(:,:,1442))
  Gcoeff(:)%j = (-(c(34)*M(4,:)%j)) * den(47)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1443),h0tab(:,1443),[28,1,2],[nMZ,nMT,nMZ],3,1,wf8(:,81))
  call Hloop_SS_S(ntryL,G0H32(1),wf8(:,81),G0H4(89),m3h8x4(:,305),heltab2x32(:,:,1443))
  Gcoeff(:)%j = (-(c(22)*M(4,:)%j)) * den(47)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1444),h0tab(:,1444),[28,1,2],[nMW,nMB,nMW],3,1,wf8(:,81))
  call Hloop_SS_S(ntryL,G0H32(1),wf8(:,81),G0H4(90),m3h8x4(:,306),heltab2x32(:,:,1444))
  Gcoeff(:)%j = (c(34)*M(4,:)%j) * den(49)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1445),h0tab(:,1445),[28,1,2],[nMH,nMT,nMZ],3,1,wf8(:,82))
  call Hloop_SS_S(ntryL,G0H32(1),wf8(:,82),G0H4(91),m3h8x4(:,307),heltab2x32(:,:,1445))
  Gcoeff(:)%j = (c(34)*M(4,:)%j) * den(49)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1446),h0tab(:,1446),[28,1,2],[nMZ,nMT,nMH],3,1,wf8(:,82))
  call Hloop_SS_S(ntryL,G0H32(1),wf8(:,82),G0H4(92),m3h8x4(:,308),heltab2x32(:,:,1446))
  Gcoeff(:)%j = (-(c(85)*M(4,:)%j)) * den(47)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1447),h0tab(:,1447),[28,1,2],[nMT,0,nMT],3,1,wf8(:,81))
  call Hloop_AS_Q(ntryL,G0H32(1),wf8(:,81),G0H4(93),ngH,m3h8x4(:,309),heltab2x32(:,:,1447))
  call Hloop_A_Q(ntryL,G0H4(93),28,nMT,G1H4(317),n2h4(511))
  Gcoeff(:)%j = (-(c(86)*M(4,:)%j)) * den(47)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1448),h0tab(:,1448),[28,1,2],[nMT,nMZ,nMT],3,1,wf8(:,81))
  call Hloop_AS_Q(ntryL,G0H32(1),wf8(:,81),G0H4(93),ngH,m3h8x4(:,310),heltab2x32(:,:,1448))
  call Hloop_A_Q(ntryL,G0H4(93),28,nMT,G1H4(318),n2h4(512))
  Gcoeff(:)%j = (-(c(40)*M(4,:)%j)) * den(47)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1449),h0tab(:,1449),[28,1,2],[nMB,nMW,nMB],3,1,wf8(:,81))
  call Hloop_AS_Q(ntryL,G0H32(1),wf8(:,81),G0H4(93),ngH,m3h8x4(:,311),heltab2x32(:,:,1449))
  call Hloop_A_Q(ntryL,G0H4(93),28,nMB,G1H4(319),n2h4(513))
  Gcoeff(:)%j = (-(c(85)*M(4,:)%j)) * den(49)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1450),h0tab(:,1450),[28,1,2],[nMT,0,nMT],3,1,wf8(:,82))
  call Hloop_AS_Q(ntryL,G0H32(1),wf8(:,82),G0H4(93),ngX,m3h8x4(:,312),heltab2x32(:,:,1450))
  call Hloop_A_Q(ntryL,G0H4(93),28,nMT,G1H4(320),n2h4(514))
  Gcoeff(:)%j = (-(c(86)*M(4,:)%j)) * den(49)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1451),h0tab(:,1451),[28,1,2],[nMT,nMZ,nMT],3,1,wf8(:,82))
  call Hloop_AS_Q(ntryL,G0H32(1),wf8(:,82),G0H4(93),ngX,m3h8x4(:,313),heltab2x32(:,:,1451))
  call Hloop_A_Q(ntryL,G0H4(93),28,nMT,G1H4(321),n2h4(515))
  Gcoeff(:)%j = (c(40)*M(4,:)%j) * den(49)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1452),h0tab(:,1452),[28,1,2],[nMB,nMW,nMB],3,1,wf8(:,82))
  call Hloop_AS_Q(ntryL,G0H32(1),wf8(:,82),G0H4(93),ngX,m3h8x4(:,314),heltab2x32(:,:,1452))
  call Hloop_A_Q(ntryL,G0H4(93),28,nMB,G1H4(322),n2h4(516))
  Gcoeff(:)%j = (-(c(57)*M(4,:)%j)) * den(47)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1453),h0tab(:,1453),[28,1,2],[nMZ,nMT,nMZ],3,1,wf8(:,81))
  call Hloop_VT_S(ntryL,G0H32(1),0,wf8(:,81),28,G1H4(323),m3h8x4(:,315),heltab2x32(:,:,1453))
  Gcoeff(:)%j = (-(c(39)*M(4,:)%j)) * den(47)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1454),h0tab(:,1454),[28,1,2],[nMW,nMB,nMW],3,1,wf8(:,81))
  call Hloop_VT_S(ntryL,G0H32(1),0,wf8(:,81),28,G1H4(324),m3h8x4(:,316),heltab2x32(:,:,1454))
  Gcoeff(:)%j = (c(57)*M(4,:)%j) * den(49)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1455),h0tab(:,1455),[28,1,2],[nMH,nMT,nMZ],3,1,wf8(:,82))
  call Hloop_VS_T(ntryL,G0H32(1),0,wf8(:,82),28,G1H4(325),m3h8x4(:,317),heltab2x32(:,:,1455))
  Gcoeff(:)%j = (c(39)*M(4,:)%j) * den(49)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1456),h0tab(:,1456),[28,1,2],[nMW,nMB,nMW],3,1,wf8(:,82))
  call Hloop_VT_S(ntryL,G0H32(1),0,wf8(:,82),28,G1H4(326),m3h8x4(:,318),heltab2x32(:,:,1456))
  Gcoeff(:)%j = (-(c(57)*M(4,:)%j)) * den(47)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1457),h0tab(:,1457),[28,1,2],[nMZ,nMT,nMZ],3,1,wf8(:,81))
  call Hloop_ST_V(ntryL,G0H32(1),0,wf8(:,81),28,G1H4(327),m3h8x4(:,319),heltab2x32(:,:,1457))
  Gcoeff(:)%j = (-(c(39)*M(4,:)%j)) * den(47)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1458),h0tab(:,1458),[28,1,2],[nMW,nMB,nMW],3,1,wf8(:,81))
  call Hloop_ST_V(ntryL,G0H32(1),0,wf8(:,81),28,G1H4(328),m3h8x4(:,320),heltab2x32(:,:,1458))
  Gcoeff(:)%j = (c(57)*M(4,:)%j) * den(49)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1459),h0tab(:,1459),[28,1,2],[nMZ,nMT,nMH],3,1,wf8(:,82))
  call Hloop_TS_V(ntryL,G0H32(1),0,wf8(:,82),28,G1H4(329),m3h8x4(:,321),heltab2x32(:,:,1459))
  Gcoeff(:)%j = (-(c(39)*M(4,:)%j)) * den(49)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1460),h0tab(:,1460),[28,1,2],[nMW,nMB,nMW],3,1,wf8(:,82))
  call Hloop_ST_V(ntryL,G0H32(1),0,wf8(:,82),28,G1H4(330),m3h8x4(:,322),heltab2x32(:,:,1460))
  Gcoeff(:)%j = (-(c(70)*M(4,:)%j)) * den(47)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1461),h0tab(:,1461),[28,1,2],[nMZ,nMT,nMZ],3,1,wf8(:,81))
  call Hloop_VS_V(ntryL,G0H32(1),wf8(:,81),G0H4(93),m3h8x4(:,323),heltab2x32(:,:,1461))
  Gcoeff(:)%j = (-(c(14)*M(4,:)%j)) * den(47)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1462),h0tab(:,1462),[28,1,2],[nMW,nMB,nMW],3,1,wf8(:,81))
  call Hloop_VS_V(ntryL,G0H32(1),wf8(:,81),G0H4(94),m3h8x4(:,324),heltab2x32(:,:,1462))
  Gcoeff(:)%j = (c(88)*M(4,:)%j) * den(51)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1463),h0tab(:,1463),[28,1,2],[nMT,nMH,nMT],3,1,wf8(:,83))
  call Hloop_AV_Q(ntryL,G0H32(1),wf8(:,83),G0H4(95),m3h8x4(:,325),heltab2x32(:,:,1463))
  call Hloop_A_Q(ntryL,G0H4(95),28,nMT,G1H4(331),n2h4(517))
  Gcoeff(:)%j = (-(c(88)*M(4,:)%j)) * den(51)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1464),h0tab(:,1464),[28,1,2],[nMT,nMZ,nMT],3,1,wf8(:,83))
  call Hloop_AV_Q(ntryL,G0H32(1),wf8(:,83),G0H4(95),m3h8x4(:,326),heltab2x32(:,:,1464))
  call Hloop_A_Q(ntryL,G0H4(95),28,nMT,G1H4(332),n2h4(518))
  Gcoeff(:)%j = (c(74)*M(4,:)%j) * den(51)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1465),h0tab(:,1465),[28,1,2],[nMB,nMW,nMB],3,1,wf8(:,83))
  call Hloop_AV_Q(ntryL,G0H32(1),wf8(:,83),G0H4(95),m3h8x4(:,327),heltab2x32(:,:,1465))
  call Hloop_A_Q(ntryL,G0H4(95),28,nMB,G1H4(333),n2h4(519))
  Gcoeff(:)%j = (-(c(89)*M(4,:)%j)) * den(49)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1466),h0tab(:,1466),[28,1,2],[nMT,nMH,nMT],3,1,wf8(:,84))
  call Hloop_AZ_Q(ntryL,G0H32(1),wf8(:,84),G0H4(95),ngZu,m3h8x4(:,328),heltab2x32(:,:,1466))
  call Hloop_A_Q(ntryL,G0H4(95),28,nMT,G1H4(334),n2h4(520))
  Gcoeff(:)%j = (c(89)*M(4,:)%j) * den(49)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1467),h0tab(:,1467),[28,1,2],[nMT,nMZ,nMT],3,1,wf8(:,84))
  call Hloop_AZ_Q(ntryL,G0H32(1),wf8(:,84),G0H4(95),ngZu,m3h8x4(:,329),heltab2x32(:,:,1467))
  call Hloop_A_Q(ntryL,G0H4(95),28,nMT,G1H4(335),n2h4(521))
  Gcoeff(:)%j = (c(79)*M(4,:)%j) * den(49)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1468),h0tab(:,1468),[28,1,2],[nMB,nMW,nMB],3,1,wf8(:,84))
  call Hloop_AZ_Q(ntryL,G0H32(1),wf8(:,84),G0H4(95),ngZd,m3h8x4(:,330),heltab2x32(:,:,1468))
  call Hloop_A_Q(ntryL,G0H4(95),28,nMB,G1H4(336),n2h4(522))
  Gcoeff(:)%j = (-(c(76)*M(4,:)%j)) * den(51)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1469),h0tab(:,1469),[28,1,2],[nMW,nMB,nMW],3,1,wf8(:,83))
  call Hloop_TV_S(ntryL,G0H32(1),0,wf8(:,83),28,G1H4(337),m3h8x4(:,331),heltab2x32(:,:,1469))
  Gcoeff(:)%j = (-(c(59)*M(4,:)%j)) * den(49)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1470),h0tab(:,1470),[28,1,2],[nMH,nMT,nMZ],3,1,wf8(:,84))
  call Hloop_SV_T(ntryL,G0H32(1),0,wf8(:,84),28,G1H4(338),m3h8x4(:,332),heltab2x32(:,:,1470))
  Gcoeff(:)%j = (-(c(59)*M(4,:)%j)) * den(49)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1471),h0tab(:,1471),[28,1,2],[nMZ,nMT,nMH],3,1,wf8(:,84))
  call Hloop_TV_S(ntryL,G0H32(1),0,wf8(:,84),28,G1H4(339),m3h8x4(:,333),heltab2x32(:,:,1471))
  Gcoeff(:)%j = (-(c(104)*M(4,:)%j)) * den(49)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1472),h0tab(:,1472),[28,1,2],[nMW,nMB,nMW],3,1,wf8(:,84))
  call Hloop_TV_S(ntryL,G0H32(1),0,wf8(:,84),28,G1H4(340),m3h8x4(:,334),heltab2x32(:,:,1472))
  Gcoeff(:)%j = (-(c(3)*M(4,:)%j)) * den(51)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1473),h0tab(:,1473),[28,1,2],[nMT,0,nMT],3,1,wf8(:,83))
  call Hloop_AV_Q(ntryL,G0H32(1),wf8(:,83),G0H4(95),m3h8x4(:,335),heltab2x32(:,:,1473))
  call Hloop_A_Q(ntryL,G0H4(95),28,nMT,G1H4(341),n2h4(523))
  Gcoeff(:)%j = (-(c(5)*M(4,:)%j)) * den(51)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1474),h0tab(:,1474),[28,1,2],[nMT,nMZ,nMT],3,1,wf8(:,83))
  call Hloop_AV_Q(ntryL,G0H32(1),wf8(:,83),G0H4(95),m3h8x4(:,336),heltab2x32(:,:,1474))
  call Hloop_A_Q(ntryL,G0H4(95),28,nMT,G1H4(342),n2h4(524))
  Gcoeff(:)%j = (c(60)*M(4,:)%j) * den(51)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1475),h0tab(:,1475),[28,1,2],[nMB,nMW,nMB],3,1,wf8(:,83))
  call Hloop_AV_Q(ntryL,G0H32(1),wf8(:,83),G0H4(95),m3h8x4(:,337),heltab2x32(:,:,1475))
  call Hloop_A_Q(ntryL,G0H4(95),28,nMB,G1H4(343),n2h4(525))
  Gcoeff(:)%j = (c(6)*M(4,:)%j) * den(49)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1476),h0tab(:,1476),[28,1,2],[nMT,0,nMT],3,1,wf8(:,84))
  call Hloop_AZ_Q(ntryL,G0H32(1),wf8(:,84),G0H4(95),ngZu,m3h8x4(:,338),heltab2x32(:,:,1476))
  call Hloop_A_Q(ntryL,G0H4(95),28,nMT,G1H4(344),n2h4(526))
  Gcoeff(:)%j = (c(7)*M(4,:)%j) * den(49)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1477),h0tab(:,1477),[28,1,2],[nMT,nMZ,nMT],3,1,wf8(:,84))
  call Hloop_AZ_Q(ntryL,G0H32(1),wf8(:,84),G0H4(95),ngZu,m3h8x4(:,339),heltab2x32(:,:,1477))
  call Hloop_A_Q(ntryL,G0H4(95),28,nMT,G1H4(345),n2h4(527))
  Gcoeff(:)%j = (c(65)*M(4,:)%j) * den(49)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1478),h0tab(:,1478),[28,1,2],[nMB,nMW,nMB],3,1,wf8(:,84))
  call Hloop_AZ_Q(ntryL,G0H32(1),wf8(:,84),G0H4(95),ngZd,m3h8x4(:,340),heltab2x32(:,:,1478))
  call Hloop_A_Q(ntryL,G0H4(95),28,nMB,G1H4(346),n2h4(528))
  Gcoeff(:)%j = (c(62)*M(4,:)%j) * den(51)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1479),h0tab(:,1479),[28,1,2],[nMW,nMB,nMW],3,1,wf8(:,83))
  call Hloop_VV_S(ntryL,G0H32(1),wf8(:,83),G0H4(95),m3h8x4(:,341),heltab2x32(:,:,1479))
  Gcoeff(:)%j = (-(c(73)*M(4,:)%j)) * den(49)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1480),h0tab(:,1480),[28,1,2],[nMH,nMT,nMZ],3,1,wf8(:,84))
  call Hloop_VV_S(ntryL,G0H32(1),wf8(:,84),G0H4(96),m3h8x4(:,342),heltab2x32(:,:,1480))
  Gcoeff(:)%j = (c(92)*M(4,:)%j) * den(49)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1481),h0tab(:,1481),[28,1,2],[nMW,nMB,nMW],3,1,wf8(:,84))
  call Hloop_VV_S(ntryL,G0H32(1),wf8(:,84),G0H4(97),m3h8x4(:,343),heltab2x32(:,:,1481))
  Gcoeff(:)%j = (-(c(62)*M(4,:)%j)) * den(51)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1482),h0tab(:,1482),[28,1,2],[nMW,nMB,nMW],3,1,wf8(:,83))
  call Hloop_SV_V(ntryL,G0H32(1),wf8(:,83),G0H4(98),m3h8x4(:,344),heltab2x32(:,:,1482))
  Gcoeff(:)%j = (-(c(73)*M(4,:)%j)) * den(49)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1483),h0tab(:,1483),[28,1,2],[nMZ,nMT,nMH],3,1,wf8(:,84))
  call Hloop_SV_V(ntryL,G0H32(1),wf8(:,84),G0H4(99),m3h8x4(:,345),heltab2x32(:,:,1483))
  Gcoeff(:)%j = (-(c(92)*M(4,:)%j)) * den(49)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1484),h0tab(:,1484),[28,1,2],[nMW,nMB,nMW],3,1,wf8(:,84))
  call Hloop_SV_V(ntryL,G0H32(1),wf8(:,84),G0H4(100),m3h8x4(:,346),heltab2x32(:,:,1484))
  Gcoeff(:)%j = (-(c(62)*M(4,:)%j)) * den(51)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1485),h0tab(:,1485),[28,1,2],[nMW,nMB,nMW],3,1,wf8(:,83))
  call Hloop_UV_W(ntryL,G0H32(1),0,wf8(:,83),28,G1H4(347),m3h8x4(:,347),heltab2x32(:,:,1485))
  Gcoeff(:)%j = (c(48)*M(4,:)%j) * den(49)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1486),h0tab(:,1486),[28,1,2],[nMW,nMB,nMW],3,1,wf8(:,84))
  call Hloop_UV_W(ntryL,G0H32(1),0,wf8(:,84),28,G1H4(348),m3h8x4(:,348),heltab2x32(:,:,1486))
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(74),[G1H4(69),G1H4(37),G1H4(29),G1H4(191),G1H4(271) &
    ,G1H4(254),G1H4(249)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(75),[G1H4(70),G1H4(40),G1H4(35),G1H4(194),G1H4(272) &
    ,G1H4(255),G1H4(250)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(78),[G1H4(73),G1H4(41),G1H4(36),G1H4(196),G1H4(190) &
    ,G1H4(256),G1H4(253)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G0H4(26),[G0H4(1)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G0H4(27),[G0H4(2)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(84),[G1H4(79),G1H4(219),G1H4(206),G0H4(28),G0H4(3)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(80),[G1H4(216),G0H4(29),G0H4(4)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(83),[G1H4(218),G0H4(30),G0H4(5)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(90),[G1H4(85),G1H4(50),G1H4(45),G1H4(9),G1H4(234) &
    ,G1H4(260),G1H4(257)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(93),[G1H4(88),G1H4(53),G1H4(48),G1H4(10),G1H4(236) &
    ,G1H4(261),G1H4(258)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(94),[G1H4(89),G1H4(54),G1H4(49),G1H4(12),G1H4(1) &
    ,G1H4(262),G1H4(259)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(55),[G1H4(263)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(60),[G1H4(58),G1H4(266),G1H4(264),G0H4(35),G0H4(33) &
    ,G0H4(10),G0H4(8)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(59),[G1H4(265),G0H4(34),G0H4(9)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(63),[G1H4(267)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(68),[G1H4(64),G1H4(270),G1H4(268),G0H4(38),G0H4(36) &
    ,G0H4(13),G0H4(11)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(65),[G1H4(269),G0H4(37),G0H4(12)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G0H4(31),[G0H4(6)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(98),[G1H4(95),G1H4(25),G1H4(20),G0H4(32),G0H4(7)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(299),[G1H4(287),G1H4(8),G1H4(26)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(300),[G1H4(288),G1H4(13),G1H4(107)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(301),[G1H4(15),G0H4(76),G0H4(14)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(302),[G1H4(11),G0H4(77),G0H4(15)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(305),[G1H4(289),G1H4(30),G1H4(108)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(306),[G1H4(290),G1H4(22),G1H4(113)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(291),[G1H4(138),G0H4(82),G0H4(20)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(292),[G1H4(140),G0H4(83),G0H4(21)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(293),[G1H4(150),G0H4(84),G0H4(22)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(294),[G1H4(172)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(295),[G1H4(173),G0H4(85),G0H4(23)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(296),[G1H4(175),G0H4(86),G0H4(24)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(297),[G1H4(7),G0H4(87),G0H4(25)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(298),[G1H4(2)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(307),[G1H4(23),G0H4(78),G0H4(16)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(308),[G1H4(24),G0H4(79),G0H4(17)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(309),[G1H4(27),G0H4(80),G0H4(18)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(310),[G1H4(43),G0H4(81),G0H4(19)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(303),[G1H4(17)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(304),[G1H4(31)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(169),[G1H4(145),G1H4(122),G1H4(99)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(170),[G1H4(146),G1H4(123),G1H4(100)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(183),[G1H4(126),G0H4(51),G0H4(39)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(174),[G1H4(127),G0H4(52),G0H4(40)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(179),[G1H4(151),G1H4(135),G1H4(103)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(180),[G1H4(164),G1H4(136),G1H4(104)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(153),[G1H4(105),G0H4(57),G0H4(45)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(156),[G1H4(120),G0H4(58),G0H4(46)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(157),[G1H4(109),G0H4(59),G0H4(47)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(158),[G1H4(110)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(161),[G1H4(130),G0H4(60),G0H4(48)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(163),[G1H4(132),G0H4(61),G0H4(49)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(165),[G1H4(115),G0H4(62),G0H4(50)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(168),[G1H4(121)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(189),[G1H4(139),G0H4(53),G0H4(41)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(199),[G1H4(148),G0H4(54),G0H4(42)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(198),[G1H4(141),G0H4(55),G0H4(43)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(204),[G1H4(144),G0H4(56),G0H4(44)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(186),[G1H4(128)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(188),[G1H4(134)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(334),[G1H4(331),G1H4(314),G1H4(311),G1H4(248),G1H4(243) &
    ,G1H4(212),G1H4(195)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(335),[G1H4(332),G1H4(315),G1H4(312),G1H4(273),G1H4(244) &
    ,G1H4(207),G1H4(203)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(336),[G1H4(333),G1H4(316),G1H4(313),G1H4(274),G1H4(245) &
    ,G1H4(210),G1H4(205)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G0H4(88),[G0H4(63)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G0H4(89),[G0H4(64)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(340),[G1H4(337),G1H4(278),G1H4(275),G0H4(90),G0H4(65)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(338),[G1H4(276),G0H4(91),G0H4(66)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(339),[G1H4(277),G0H4(92),G0H4(67)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(344),[G1H4(341),G1H4(320),G1H4(317),G1H4(282),G1H4(279) &
    ,G1H4(224),G1H4(211)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(345),[G1H4(342),G1H4(321),G1H4(318),G1H4(283),G1H4(280) &
    ,G1H4(220),G1H4(215)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(346),[G1H4(343),G1H4(322),G1H4(319),G1H4(284),G1H4(281) &
    ,G1H4(226),G1H4(223)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(323),[G1H4(239)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(326),[G1H4(324),G1H4(232),G1H4(240),G0H4(97),G0H4(95) &
    ,G0H4(72),G0H4(70)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(325),[G1H4(231),G0H4(96),G0H4(71)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(327),[G1H4(233)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(330),[G1H4(328),G1H4(238),G1H4(252),G0H4(100),G0H4(98) &
    ,G0H4(75),G0H4(73)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(329),[G1H4(237),G0H4(99),G0H4(74)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G0H4(93),[G0H4(68)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(348),[G1H4(347),G1H4(286),G1H4(285),G0H4(94),G0H4(69)])
  call Hloop_QS_A(ntryL,G1H8(1),wf4(:,1),G1H2(190),ngH,m3h4x2(:,111),heltab2x8(:,:,591))
  call Hloop_Q_A(ntryL,G1H2(190),23,nMB,G2H2(19),n2h2(137))
  call Hloop_QS_A(ntryL,G1H8(2),wf4(:,1),G1H2(66),ngH,m3h4x2(:,112),heltab2x8(:,:,592))
  call Hloop_Q_A(ntryL,G1H2(66),23,nMB,G2H2(21),n2h2(138))
  call Hloop_QS_A(ntryL,G1H8(3),wf4(:,1),G1H2(61),ngH,m3h4x2(:,113),heltab2x8(:,:,593))
  call Hloop_Q_A(ntryL,G1H2(61),23,nMT,G2H2(20),n2h2(139))
  call Hloop_QS_A(ntryL,G1H8(4),wf4(:,4),G1H2(317),ngX,m3h4x2(:,114),heltab2x8(:,:,594))
  call Hloop_Q_A(ntryL,G1H2(317),23,nMB,G2H2(18),n2h2(140))
  call Hloop_QS_A(ntryL,G1H8(5),wf4(:,4),G1H2(191),ngX,m3h4x2(:,115),heltab2x8(:,:,595))
  call Hloop_Q_A(ntryL,G1H2(191),23,nMB,G2H2(25),n2h2(141))
  call Hloop_QS_A(ntryL,G1H8(6),wf4(:,4),G1H2(195),ngX,m3h4x2(:,116),heltab2x8(:,:,596))
  call Hloop_Q_A(ntryL,G1H2(195),23,nMT,G2H2(16),n2h2(142))
  call Hloop_SS_S(ntryL,G0H8(6),wf4(:,1),G0H2(1),m3h4x2(:,117),heltab2x8(:,:,597))
  call Hloop_SS_S(ntryL,G0H8(7),wf4(:,1),G0H2(2),m3h4x2(:,118),heltab2x8(:,:,598))
  call Hloop_SS_S(ntryL,G0H8(8),wf4(:,1),G0H2(3),m3h4x2(:,119),heltab2x8(:,:,599))
  call Hloop_SS_S(ntryL,G0H8(9),wf4(:,4),G0H2(4),m3h4x2(:,120),heltab2x8(:,:,600))
  call Hloop_SS_S(ntryL,G0H8(10),wf4(:,4),G0H2(5),m3h4x2(:,121),heltab2x8(:,:,601))
  call Hloop_QS_A(ntryL,G1H8(7),wf4(:,1),G1H2(214),ngH,m3h4x2(:,122),heltab2x8(:,:,602))
  call Hloop_Q_A(ntryL,G1H2(214),23,nMB,G2H2(14),n2h2(143))
  call Hloop_QS_A(ntryL,G1H8(8),wf4(:,1),G1H2(202),ngH,m3h4x2(:,123),heltab2x8(:,:,603))
  call Hloop_Q_A(ntryL,G1H2(202),23,nMB,G2H2(53),n2h2(144))
  call Hloop_QS_A(ntryL,G1H8(9),wf4(:,1),G1H2(196),ngH,m3h4x2(:,124),heltab2x8(:,:,604))
  call Hloop_Q_A(ntryL,G1H2(196),23,nMT,G2H2(52),n2h2(145))
  call Hloop_QS_A(ntryL,G1H8(10),wf4(:,4),G1H2(67),ngX,m3h4x2(:,125),heltab2x8(:,:,605))
  call Hloop_Q_A(ntryL,G1H2(67),23,nMB,G2H2(54),n2h2(146))
  call Hloop_QS_A(ntryL,G1H8(11),wf4(:,4),G1H2(323),ngX,m3h4x2(:,126),heltab2x8(:,:,606))
  call Hloop_Q_A(ntryL,G1H2(323),23,nMB,G2H2(47),n2h2(147))
  call Hloop_QS_A(ntryL,G1H8(12),wf4(:,4),G1H2(197),ngX,m3h4x2(:,127),heltab2x8(:,:,607))
  call Hloop_Q_A(ntryL,G1H2(197),23,nMT,G2H2(48),n2h2(148))
  call Hloop_VT_S(ntryL,G0H8(17),20,wf4(:,1),3,G1H2(201),m3h4x2(:,128),heltab2x8(:,:,608))
  call Hloop_VT_S(ntryL,G0H8(18),20,wf4(:,1),3,G1H2(60),m3h4x2(:,129),heltab2x8(:,:,609))
  call Hloop_VS_T(ntryL,G0H8(19),20,wf4(:,4),3,G1H2(329),m3h4x2(:,130),heltab2x8(:,:,610))
  call Hloop_VT_S(ntryL,G0H8(20),20,wf4(:,4),3,G1H2(203),m3h4x2(:,131),heltab2x8(:,:,611))
  call Hloop_ST_V(ntryL,G0H8(21),20,wf4(:,1),3,G1H2(207),m3h4x2(:,132),heltab2x8(:,:,612))
  call Hloop_ST_V(ntryL,G0H8(22),20,wf4(:,1),3,G1H2(68),m3h4x2(:,133),heltab2x8(:,:,613))
  call Hloop_TS_V(ntryL,G0H8(23),20,wf4(:,4),3,G1H2(305),m3h4x2(:,134),heltab2x8(:,:,614))
  call Hloop_ST_V(ntryL,G0H8(24),20,wf4(:,4),3,G1H2(209),m3h4x2(:,135),heltab2x8(:,:,615))
  call Hloop_VS_V(ntryL,G0H8(25),wf4(:,1),G0H2(6),m3h4x2(:,136),heltab2x8(:,:,616))
  call Hloop_VS_V(ntryL,G0H8(26),wf4(:,1),G0H2(7),m3h4x2(:,137),heltab2x8(:,:,617))
  call Hloop_QV_A(ntryL,G1H8(13),wf4(:,5),G1H2(213),m3h4x2(:,138),heltab2x8(:,:,618))
  call Hloop_Q_A(ntryL,G1H2(213),23,nMB,G2H2(50),n2h2(149))
  call Hloop_QV_A(ntryL,G1H8(14),wf4(:,5),G1H2(55),m3h4x2(:,139),heltab2x8(:,:,619))
  call Hloop_Q_A(ntryL,G1H2(55),23,nMB,G2H2(37),n2h2(150))
  call Hloop_QV_A(ntryL,G1H8(15),wf4(:,5),G1H2(335),m3h4x2(:,140),heltab2x8(:,:,620))
  call Hloop_Q_A(ntryL,G1H2(335),23,nMT,G2H2(36),n2h2(151))
  call Hloop_QZ_A(ntryL,G1H8(16),wf4(:,6),G1H2(215),ngZd,m3h4x2(:,141),heltab2x8(:,:,621))
  call Hloop_Q_A(ntryL,G1H2(215),23,nMB,G2H2(38),n2h2(152))
  call Hloop_QZ_A(ntryL,G1H8(17),wf4(:,6),G1H2(219),ngZd,m3h4x2(:,142),heltab2x8(:,:,622))
  call Hloop_Q_A(ntryL,G1H2(219),23,nMB,G2H2(31),n2h2(153))
  call Hloop_QZ_A(ntryL,G1H8(18),wf4(:,6),G1H2(268),ngZu,m3h4x2(:,143),heltab2x8(:,:,623))
  call Hloop_Q_A(ntryL,G1H2(268),23,nMT,G2H2(32),n2h2(154))
  call Hloop_TV_S(ntryL,G0H8(33),20,wf4(:,5),3,G1H2(232),m3h4x2(:,144),heltab2x8(:,:,624))
  call Hloop_SV_T(ntryL,G0H8(34),20,wf4(:,6),3,G1H2(220),m3h4x2(:,145),heltab2x8(:,:,625))
  call Hloop_TV_S(ntryL,G0H8(35),20,wf4(:,6),3,G1H2(26),m3h4x2(:,146),heltab2x8(:,:,626))
  call Hloop_TV_S(ntryL,G0H8(36),20,wf4(:,6),3,G1H2(341),m3h4x2(:,147),heltab2x8(:,:,627))
  call Hloop_QV_A(ntryL,G1H8(19),wf4(:,5),G1H2(221),m3h4x2(:,148),heltab2x8(:,:,628))
  call Hloop_Q_A(ntryL,G1H2(221),23,nMB,G2H2(34),n2h2(155))
  call Hloop_QV_A(ntryL,G1H8(20),wf4(:,5),G1H2(225),m3h4x2(:,149),heltab2x8(:,:,629))
  call Hloop_Q_A(ntryL,G1H2(225),23,nMB,G2H2(69),n2h2(156))
  call Hloop_QV_A(ntryL,G1H8(21),wf4(:,5),G1H2(226),m3h4x2(:,150),heltab2x8(:,:,630))
  call Hloop_Q_A(ntryL,G1H2(226),23,nMT,G2H2(71),n2h2(157))
  call Hloop_QZ_A(ntryL,G1H8(22),wf4(:,6),G1H2(49),ngZd,m3h4x2(:,151),heltab2x8(:,:,631))
  call Hloop_Q_A(ntryL,G1H2(49),23,nMB,G2H2(70),n2h2(158))
  call Hloop_QZ_A(ntryL,G1H8(23),wf4(:,6),G1H2(30),ngZd,m3h4x2(:,152),heltab2x8(:,:,632))
  call Hloop_Q_A(ntryL,G1H2(30),23,nMB,G2H2(68),n2h2(159))
  call Hloop_QZ_A(ntryL,G1H8(24),wf4(:,6),G1H2(347),ngZu,m3h4x2(:,153),heltab2x8(:,:,633))
  call Hloop_Q_A(ntryL,G1H2(347),23,nMT,G2H2(75),n2h2(160))
  call Hloop_VV_S(ntryL,G0H8(43),wf4(:,5),G0H2(8),m3h4x2(:,154),heltab2x8(:,:,634))
  call Hloop_VV_S(ntryL,G0H8(44),wf4(:,6),G0H2(9),m3h4x2(:,155),heltab2x8(:,:,635))
  call Hloop_VV_S(ntryL,G0H8(45),wf4(:,6),G0H2(10),m3h4x2(:,156),heltab2x8(:,:,636))
  call Hloop_SV_V(ntryL,G0H8(46),wf4(:,5),G0H2(11),m3h4x2(:,157),heltab2x8(:,:,637))
  call Hloop_SV_V(ntryL,G0H8(47),wf4(:,6),G0H2(12),m3h4x2(:,158),heltab2x8(:,:,638))
  call Hloop_SV_V(ntryL,G0H8(48),wf4(:,6),G0H2(13),m3h4x2(:,159),heltab2x8(:,:,639))
  call Hloop_UV_W(ntryL,G0H8(49),20,wf4(:,5),3,G1H2(227),m3h4x2(:,160),heltab2x8(:,:,640))
  call Hloop_UV_W(ntryL,G0H8(50),20,wf4(:,6),3,G1H2(231),m3h4x2(:,161),heltab2x8(:,:,641))
  call Hloop_AS_Q(ntryL,G1H8(25),wf4(:,1),G1H2(48),ngH,m3h4x2(:,162),heltab2x8(:,:,642))
  call Hloop_A_Q(ntryL,G1H2(48),27,nMB,G2H2(66),n2h2(161))
  call Hloop_AS_Q(ntryL,G1H8(26),wf4(:,1),G1H2(353),ngH,m3h4x2(:,163),heltab2x8(:,:,643))
  call Hloop_A_Q(ntryL,G1H2(353),27,nMB,G2H2(64),n2h2(162))
  call Hloop_AS_Q(ntryL,G1H8(27),wf4(:,1),G1H2(233),ngH,m3h4x2(:,164),heltab2x8(:,:,644))
  call Hloop_A_Q(ntryL,G1H2(233),27,nMT,G2H2(79),n2h2(163))
  call Hloop_AS_Q(ntryL,G1H8(28),wf4(:,4),G1H2(237),ngX,m3h4x2(:,165),heltab2x8(:,:,645))
  call Hloop_A_Q(ntryL,G1H2(237),27,nMB,G2H2(80),n2h2(164))
  call Hloop_AS_Q(ntryL,G1H8(29),wf4(:,4),G1H2(238),ngX,m3h4x2(:,166),heltab2x8(:,:,646))
  call Hloop_A_Q(ntryL,G1H2(238),27,nMB,G2H2(82),n2h2(165))
  call Hloop_AS_Q(ntryL,G1H8(30),wf4(:,4),G1H2(359),ngX,m3h4x2(:,167),heltab2x8(:,:,647))
  call Hloop_A_Q(ntryL,G1H2(359),27,nMT,G2H2(84),n2h2(166))
  call Hloop_SS_S(ntryL,G0H8(57),wf4(:,1),G0H2(14),m3h4x2(:,168),heltab2x8(:,:,648))
  call Hloop_SS_S(ntryL,G0H8(58),wf4(:,1),G0H2(15),m3h4x2(:,169),heltab2x8(:,:,649))
  call Hloop_SS_S(ntryL,G0H8(59),wf4(:,1),G0H2(16),m3h4x2(:,170),heltab2x8(:,:,650))



end subroutine vamp_1

end module ol_vamp_1_ppttj_ew_ttxbbxg_4_/**/REALKIND
