
module ol_vamp_1_ppttj_ew_ttxbbxg_1_/**/REALKIND
contains

! **********************************************************************
subroutine vamp_1(M)
! P(0:3,nlegs) = incoming external momenta
! Uses tree structures 'wf', factors 'c', and denominators 'den' from loop_ppttj_ew_ttxbbxg_1.
! Sets colour stripped amplitudes A from the module loop_amplitudes_ppttj_ew_ttxbbxg_1.
! **********************************************************************
  use KIND_TYPES, only: REALKIND, QREALKIND, intkind2
  use ol_parameters_decl_/**/DREALKIND, only: l_switch
  use ol_parameters_decl_/**/QREALKIND ! masses
  use ol_vert_interface_/**/REALKIND
  use ol_prop_interface_/**/REALKIND
  use ol_last_step_/**/REALKIND
  use ol_tables_storage_ppttj_ew_ttxbbxg_1_/**/DREALKIND
  use ol_tensor_sum_storage_ppttj_ew_ttxbbxg_1_/**/REALKIND
  use ol_loop_handling_/**/REALKIND
  use ofred_reduction_/**/REALKIND, only: Hotf_4pt_reduction, Hotf_4pt_reduction_last
  use ofred_reduction_/**/REALKIND, only: Hotf_5pt_reduction, Hotf_5pt_reduction_last
  use ol_loop_reduction_/**/REALKIND, only: TI_bubble_red, TI_triangle_red
use ol_loop_reduction_/**/REALKIND, only: compute_scalar_box

  use ol_loop_storage_ppttj_ew_ttxbbxg_1_/**/REALKIND
#ifndef PRECISION_dp
  use ol_loop_storage_ppttj_ew_ttxbbxg_1_/**/DREALKIND, only: &
    & p_switch, Hel, merge_step, merge_mism, merge_tables, merge_hels, ntryL, hel_states
#endif
  use hol_initialisation_/**/REALKIND, only: G0_hol_initialisation
  use ol_h_vert_interface_/**/REALKIND
  use ol_h_prop_interface_/**/REALKIND
  use ol_h_last_step_/**/REALKIND
  use ol_merging_/**/REALKIND, only: ol_merge, ol_merge_tensors, ol_merge_last

  implicit none

  type(Hpolcont) :: Gcoeff(hel_states)
  type(Hpolcont), intent(in) :: M(8,hel_states)


#ifndef PRECISION_dp
  if (ntryL==1 .OR. p_switch == 1) Gcoeff(:)%hf = Hel(1:hel_states)
#else
  if (ntryL==1 .OR. p_switch == 2) Gcoeff(:)%hf = Hel(1:hel_states)
#endif

  ! =============================================


! Dressing, otf merging and otf reduction calls to build loop structures

  Gcoeff(:)%j = (-(c(53)*M(3,:)%j)+c(52)*M(7,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1),h0tab(:,1),[16,4,1,2,8],[nMB,nMH,nMT,0,nMB],5,0)
  call Hloop_AV_Q(ntryL,G0H32(1),ex5(:),G0H16(1),m3h2x16(:,1),heltab2x32(:,:,1))
  call Hloop_A_Q(ntryL,G0H16(1),16,nMB,G1H16(1),n2h16(1))
  Gcoeff(:)%j = (-(c(53)*M(3,:)%j)+c(52)*M(7,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(2),h0tab(:,2),[16,4,1,2,8],[nMB,nMZ,nMT,0,nMB],5,0)
  call Hloop_AV_Q(ntryL,G0H32(1),ex5(:),G0H16(1),m3h2x16(:,2),heltab2x32(:,:,2))
  call Hloop_A_Q(ntryL,G0H16(1),16,nMB,G1H16(2),n2h16(2))
  Gcoeff(:)%j = (-(c(53)*M(5,:)%j)+c(52)*M(7,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(3),h0tab(:,3),[16,4,1,2,8],[nMB,0,nMT,nMH,nMB],5,0)
  call Hloop_AV_Q(ntryL,G0H32(1),ex5(:),G0H16(1),m3h2x16(:,3),heltab2x32(:,:,3))
  call Hloop_A_Q(ntryL,G0H16(1),16,nMB,G1H16(3),n2h16(3))
  Gcoeff(:)%j = (-(c(53)*M(5,:)%j)+c(52)*M(7,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(4),h0tab(:,4),[16,4,1,2,8],[nMB,0,nMT,nMZ,nMB],5,0)
  call Hloop_AV_Q(ntryL,G0H32(1),ex5(:),G0H16(1),m3h2x16(:,4),heltab2x32(:,:,4))
  call Hloop_A_Q(ntryL,G0H16(1),16,nMB,G1H16(4),n2h16(4))
  Gcoeff(:)%j = (-(c(10)*M(3,:)%j)+c(9)*M(7,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(5),h0tab(:,5),[16,4,1,2,8],[nMB,0,nMT,0,nMB],5,0)
  call Hloop_AV_Q(ntryL,G0H32(1),ex5(:),G0H16(1),m3h2x16(:,5),heltab2x32(:,:,5))
  call Hloop_A_Q(ntryL,G0H16(1),16,nMB,G1H16(5),n2h16(5))
  Gcoeff(:)%j = (-(c(10)*M(5,:)%j)+c(9)*M(7,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(6),h0tab(:,6),[16,4,1,2,8],[nMB,0,nMT,0,nMB],5,0)
  call Hloop_AV_Q(ntryL,G0H32(1),ex5(:),G0H16(1),m3h2x16(:,6),heltab2x32(:,:,6))
  call Hloop_A_Q(ntryL,G0H16(1),16,nMB,G1H16(6),n2h16(6))
  Gcoeff(:)%j = (c(15)*M(3,:)%j-c(14)*M(7,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(7),h0tab(:,7),[16,4,1,2,8],[nMB,nMZ,nMT,0,nMB],5,0)
  call Hloop_AV_Q(ntryL,G0H32(1),ex5(:),G0H16(1),m3h2x16(:,7),heltab2x32(:,:,7))
  call Hloop_A_Q(ntryL,G0H16(1),16,nMB,G1H16(7),n2h16(7))
  Gcoeff(:)%j = (c(15)*M(5,:)%j-c(14)*M(7,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(8),h0tab(:,8),[16,4,1,2,8],[nMB,0,nMT,nMZ,nMB],5,0)
  call Hloop_AV_Q(ntryL,G0H32(1),ex5(:),G0H16(1),m3h2x16(:,8),heltab2x32(:,:,8))
  call Hloop_A_Q(ntryL,G0H16(1),16,nMB,G1H16(8),n2h16(8))
  Gcoeff(:)%j = (c(30)*M(2,:)%j+c(27)*(-M(4,:)%j-M(6,:)%j)+c(26)*M(8,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(9),h0tab(:,9),[16,4,1,2,8],[nMB,0,nMT,0,nMB],5,0)
  call Hloop_AV_Q(ntryL,G0H32(1),ex5(:),G0H16(1),m3h2x16(:,9),heltab2x32(:,:,9))
  call Hloop_A_Q(ntryL,G0H16(1),16,nMB,G1H16(9),n2h16(9))
  Gcoeff(:)%j = (c(50)*(-M(3,:)%j+M(5,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(10),h0tab(:,10),[16,2,1,4,8],[0,nMT,nMH,nMB,0],5,0)
  call Hloop_UV_W(ntryL,G0H32(1),0,ex5(:),16,G1H16(10),m3h2x16(:,10),heltab2x32(:,:,10))
  Gcoeff(:)%j = (c(50)*(-M(3,:)%j+M(5,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(11),h0tab(:,11),[16,2,1,4,8],[0,nMT,nMZ,nMB,0],5,0)
  call Hloop_UV_W(ntryL,G0H32(1),0,ex5(:),16,G1H16(11),m3h2x16(:,11),heltab2x32(:,:,11))
  Gcoeff(:)%j = (c(2)*(-M(3,:)%j+M(5,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(12),h0tab(:,12),[16,2,1,4,8],[0,nMT,0,nMB,0],5,0)
  call Hloop_UV_W(ntryL,G0H32(1),0,ex5(:),16,G1H16(12),m3h2x16(:,12),heltab2x32(:,:,12))
  Gcoeff(:)%j = (c(5)*(M(3,:)%j-M(5,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(13),h0tab(:,13),[16,2,1,4,8],[0,nMT,nMZ,nMB,0],5,0)
  call Hloop_UV_W(ntryL,G0H32(1),0,ex5(:),16,G1H16(13),m3h2x16(:,13),heltab2x32(:,:,13))
  Gcoeff(:)%j = (c(19)*(-M(4,:)%j+M(6,:)%j)+c(20)*(M(2,:)%j-M(8,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(14),h0tab(:,14),[16,2,1,4,8],[0,nMT,0,nMB,0],5,0)
  call Hloop_UV_W(ntryL,G0H32(1),0,ex5(:),16,G1H16(14),m3h2x16(:,14),heltab2x32(:,:,14))
  Gcoeff(:)%j = (-(c(53)*M(5,:)%j)+c(52)*M(7,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(15),h0tab(:,15),[16,4,2,1,8],[nMB,0,nMT,nMH,nMB],5,0)
  call Hloop_AV_Q(ntryL,G0H32(1),ex5(:),G0H16(1),m3h2x16(:,15),heltab2x32(:,:,15))
  call Hloop_A_Q(ntryL,G0H16(1),16,nMB,G1H16(15),n2h16(10))
  Gcoeff(:)%j = (-(c(53)*M(5,:)%j)+c(52)*M(7,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(16),h0tab(:,16),[16,4,2,1,8],[nMB,0,nMT,nMZ,nMB],5,0)
  call Hloop_AV_Q(ntryL,G0H32(1),ex5(:),G0H16(1),m3h2x16(:,16),heltab2x32(:,:,16))
  call Hloop_A_Q(ntryL,G0H16(1),16,nMB,G1H16(16),n2h16(11))
  Gcoeff(:)%j = (-(c(53)*M(3,:)%j)+c(52)*M(7,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(17),h0tab(:,17),[16,4,2,1,8],[nMB,nMH,nMT,0,nMB],5,0)
  call Hloop_AV_Q(ntryL,G0H32(1),ex5(:),G0H16(1),m3h2x16(:,17),heltab2x32(:,:,17))
  call Hloop_A_Q(ntryL,G0H16(1),16,nMB,G1H16(17),n2h16(12))
  Gcoeff(:)%j = (-(c(53)*M(3,:)%j)+c(52)*M(7,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(18),h0tab(:,18),[16,4,2,1,8],[nMB,nMZ,nMT,0,nMB],5,0)
  call Hloop_AV_Q(ntryL,G0H32(1),ex5(:),G0H16(1),m3h2x16(:,18),heltab2x32(:,:,18))
  call Hloop_A_Q(ntryL,G0H16(1),16,nMB,G1H16(18),n2h16(13))
  Gcoeff(:)%j = (-(c(10)*M(5,:)%j)+c(9)*M(7,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(19),h0tab(:,19),[16,4,2,1,8],[nMB,0,nMT,0,nMB],5,0)
  call Hloop_AV_Q(ntryL,G0H32(1),ex5(:),G0H16(1),m3h2x16(:,19),heltab2x32(:,:,19))
  call Hloop_A_Q(ntryL,G0H16(1),16,nMB,G1H16(19),n2h16(14))
  Gcoeff(:)%j = (-(c(10)*M(3,:)%j)+c(9)*M(7,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(20),h0tab(:,20),[16,4,2,1,8],[nMB,0,nMT,0,nMB],5,0)
  call Hloop_AV_Q(ntryL,G0H32(1),ex5(:),G0H16(1),m3h2x16(:,20),heltab2x32(:,:,20))
  call Hloop_A_Q(ntryL,G0H16(1),16,nMB,G1H16(20),n2h16(15))
  Gcoeff(:)%j = (c(15)*M(5,:)%j-c(14)*M(7,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(21),h0tab(:,21),[16,4,2,1,8],[nMB,0,nMT,nMZ,nMB],5,0)
  call Hloop_AV_Q(ntryL,G0H32(1),ex5(:),G0H16(1),m3h2x16(:,21),heltab2x32(:,:,21))
  call Hloop_A_Q(ntryL,G0H16(1),16,nMB,G1H16(21),n2h16(16))
  Gcoeff(:)%j = (c(15)*M(3,:)%j-c(14)*M(7,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(22),h0tab(:,22),[16,4,2,1,8],[nMB,nMZ,nMT,0,nMB],5,0)
  call Hloop_AV_Q(ntryL,G0H32(1),ex5(:),G0H16(1),m3h2x16(:,22),heltab2x32(:,:,22))
  call Hloop_A_Q(ntryL,G0H16(1),16,nMB,G1H16(22),n2h16(17))
  Gcoeff(:)%j = (c(27)*(-M(4,:)%j-M(6,:)%j)+c(26)*M(8,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(23),h0tab(:,23),[16,4,2,1,8],[nMB,0,nMT,0,nMB],5,0)
  call Hloop_AV_Q(ntryL,G0H32(1),ex5(:),G0H16(1),m3h2x16(:,23),heltab2x32(:,:,23))
  call Hloop_A_Q(ntryL,G0H16(1),16,nMB,G1H16(23),n2h16(18))
  Gcoeff(:)%j = (c(42)*(-M(1,:)%j+M(7,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(24),h0tab(:,24),[16,4,2,1,8],[0,nMB,nMW,nMB,0],5,0)
  call Hloop_UV_W(ntryL,G0H32(1),0,ex5(:),16,G1H16(24),m3h2x16(:,24),heltab2x32(:,:,24))
  Gcoeff(:)%j = (c(37)*(-M(1,:)%j+M(7,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(25),h0tab(:,25),[16,4,2,1,8],[0,nMB,nMW,nMB,0],5,0)
  call Hloop_UV_W(ntryL,G0H32(1),0,ex5(:),16,G1H16(25),m3h2x16(:,25),heltab2x32(:,:,25))
  Gcoeff(:)%j = (-(c(45)*M(1,:)%j)+c(44)*M(3,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(26),h0tab(:,26),[16,2,1,8,4],[nMB,nMW,nMB,0,nMB],5,0)
  call Hloop_QV_A(ntryL,G0H32(1),ex5(:),G0H16(1),m3h2x16(:,26),heltab2x32(:,:,26))
  call Hloop_Q_A(ntryL,G0H16(1),16,nMB,G1H16(26),n2h16(19))
  Gcoeff(:)%j = (c(44)*M(3,:)%j-c(45)*M(7,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(27),h0tab(:,27),[16,2,1,8,4],[nMT,0,nMT,nMW,nMT],5,0)
  call Hloop_QV_A(ntryL,G0H32(1),ex5(:),G0H16(1),m3h2x16(:,27),heltab2x32(:,:,27))
  call Hloop_Q_A(ntryL,G0H16(1),16,nMT,G1H16(27),n2h16(20))
  Gcoeff(:)%j = (c(39)*M(3,:)%j-c(40)*M(7,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(28),h0tab(:,28),[16,2,1,8,4],[nMT,0,nMT,nMW,nMT],5,0)
  call Hloop_QV_A(ntryL,G0H32(1),ex5(:),G0H16(1),m3h2x16(:,28),heltab2x32(:,:,28))
  call Hloop_Q_A(ntryL,G0H16(1),16,nMT,G1H16(28),n2h16(21))
  Gcoeff(:)%j = (-(c(40)*M(1,:)%j)+c(39)*M(3,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(29),h0tab(:,29),[16,2,1,8,4],[nMB,nMW,nMB,0,nMB],5,0)
  call Hloop_QV_A(ntryL,G0H32(1),ex5(:),G0H16(1),m3h2x16(:,29),heltab2x32(:,:,29))
  call Hloop_Q_A(ntryL,G0H16(1),16,nMB,G1H16(29),n2h16(22))
  Gcoeff(:)%j = (c(50)*(-M(3,:)%j+M(5,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(30),h0tab(:,30),[16,2,1,8,4],[0,nMT,nMH,nMB,0],5,0)
  call Hloop_UV_W(ntryL,G0H32(1),0,ex5(:),16,G1H16(30),m3h2x16(:,30),heltab2x32(:,:,30))
  Gcoeff(:)%j = (c(50)*(-M(3,:)%j+M(5,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(31),h0tab(:,31),[16,2,1,8,4],[0,nMT,nMZ,nMB,0],5,0)
  call Hloop_UV_W(ntryL,G0H32(1),0,ex5(:),16,G1H16(31),m3h2x16(:,31),heltab2x32(:,:,31))
  Gcoeff(:)%j = (c(2)*(-M(3,:)%j+M(5,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(32),h0tab(:,32),[16,2,1,8,4],[0,nMT,0,nMB,0],5,0)
  call Hloop_UV_W(ntryL,G0H32(1),0,ex5(:),16,G1H16(32),m3h2x16(:,32),heltab2x32(:,:,32))
  Gcoeff(:)%j = (c(5)*(M(3,:)%j-M(5,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(33),h0tab(:,33),[16,2,1,8,4],[0,nMT,nMZ,nMB,0],5,0)
  call Hloop_UV_W(ntryL,G0H32(1),0,ex5(:),16,G1H16(33),m3h2x16(:,33),heltab2x32(:,:,33))
  Gcoeff(:)%j = (c(21)*M(4,:)%j+c(19)*M(6,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(34),h0tab(:,34),[16,2,1,8,4],[0,nMT,0,nMB,0],5,0)
  call Hloop_UV_W(ntryL,G0H32(1),0,ex5(:),16,G1H16(34),m3h2x16(:,34),heltab2x32(:,:,34))
  Gcoeff(:)%j = (-(c(45)*M(1,:)%j)+c(44)*M(5,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(35),h0tab(:,35),[16,1,2,4,8],[nMB,nMW,nMB,0,nMB],5,0)
  call Hloop_AV_Q(ntryL,G0H32(1),ex5(:),G0H16(1),m3h2x16(:,35),heltab2x32(:,:,35))
  call Hloop_A_Q(ntryL,G0H16(1),16,nMB,G1H16(35),n2h16(23))
  Gcoeff(:)%j = (c(44)*M(5,:)%j-c(45)*M(7,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(36),h0tab(:,36),[16,1,2,4,8],[nMT,0,nMT,nMW,nMT],5,0)
  call Hloop_AV_Q(ntryL,G0H32(1),ex5(:),G0H16(1),m3h2x16(:,36),heltab2x32(:,:,36))
  call Hloop_A_Q(ntryL,G0H16(1),16,nMT,G1H16(36),n2h16(24))
  Gcoeff(:)%j = (c(39)*M(5,:)%j-c(40)*M(7,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(37),h0tab(:,37),[16,1,2,4,8],[nMT,0,nMT,nMW,nMT],5,0)
  call Hloop_AV_Q(ntryL,G0H32(1),ex5(:),G0H16(1),m3h2x16(:,37),heltab2x32(:,:,37))
  call Hloop_A_Q(ntryL,G0H16(1),16,nMT,G1H16(37),n2h16(25))
  Gcoeff(:)%j = (-(c(40)*M(1,:)%j)+c(39)*M(5,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(38),h0tab(:,38),[16,1,2,4,8],[nMB,nMW,nMB,0,nMB],5,0)
  call Hloop_AV_Q(ntryL,G0H32(1),ex5(:),G0H16(1),m3h2x16(:,38),heltab2x32(:,:,38))
  call Hloop_A_Q(ntryL,G0H16(1),16,nMB,G1H16(38),n2h16(26))
  Gcoeff(:)%j = (c(50)*(-M(3,:)%j+M(5,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(39),h0tab(:,39),[16,1,2,4,8],[0,nMT,nMH,nMB,0],5,0)
  call Hloop_UV_W(ntryL,G0H32(1),0,ex5(:),16,G1H16(39),m3h2x16(:,39),heltab2x32(:,:,39))
  Gcoeff(:)%j = (c(50)*(-M(3,:)%j+M(5,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(40),h0tab(:,40),[16,1,2,4,8],[0,nMT,nMZ,nMB,0],5,0)
  call Hloop_UV_W(ntryL,G0H32(1),0,ex5(:),16,G1H16(40),m3h2x16(:,40),heltab2x32(:,:,40))
  Gcoeff(:)%j = (c(2)*(-M(3,:)%j+M(5,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(41),h0tab(:,41),[16,1,2,4,8],[0,nMT,0,nMB,0],5,0)
  call Hloop_UV_W(ntryL,G0H32(1),0,ex5(:),16,G1H16(41),m3h2x16(:,41),heltab2x32(:,:,41))
  Gcoeff(:)%j = (c(5)*(M(3,:)%j-M(5,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(42),h0tab(:,42),[16,1,2,4,8],[0,nMT,nMZ,nMB,0],5,0)
  call Hloop_UV_W(ntryL,G0H32(1),0,ex5(:),16,G1H16(42),m3h2x16(:,42),heltab2x32(:,:,42))
  Gcoeff(:)%j = (-(c(19)*M(4,:)%j)-c(21)*M(6,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(43),h0tab(:,43),[16,1,2,4,8],[0,nMT,0,nMB,0],5,0)
  call Hloop_UV_W(ntryL,G0H32(1),0,ex5(:),16,G1H16(43),m3h2x16(:,43),heltab2x32(:,:,43))
  Gcoeff(:)%j = (c(50)*(-M(3,:)%j+M(5,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(44),h0tab(:,44),[16,1,2,8,4],[0,nMT,nMH,nMB,0],5,0)
  call Hloop_UV_W(ntryL,G0H32(1),0,ex5(:),16,G1H16(44),m3h2x16(:,44),heltab2x32(:,:,44))
  Gcoeff(:)%j = (c(50)*(-M(3,:)%j+M(5,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(45),h0tab(:,45),[16,1,2,8,4],[0,nMT,nMZ,nMB,0],5,0)
  call Hloop_UV_W(ntryL,G0H32(1),0,ex5(:),16,G1H16(45),m3h2x16(:,45),heltab2x32(:,:,45))
  Gcoeff(:)%j = (c(2)*(-M(3,:)%j+M(5,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(46),h0tab(:,46),[16,1,2,8,4],[0,nMT,0,nMB,0],5,0)
  call Hloop_UV_W(ntryL,G0H32(1),0,ex5(:),16,G1H16(46),m3h2x16(:,46),heltab2x32(:,:,46))
  Gcoeff(:)%j = (c(5)*(M(3,:)%j-M(5,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(47),h0tab(:,47),[16,1,2,8,4],[0,nMT,nMZ,nMB,0],5,0)
  call Hloop_UV_W(ntryL,G0H32(1),0,ex5(:),16,G1H16(47),m3h2x16(:,47),heltab2x32(:,:,47))
  Gcoeff(:)%j = (c(19)*(-M(4,:)%j+M(6,:)%j)+c(20)*(-M(2,:)%j+M(8,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(48),h0tab(:,48),[16,1,2,8,4],[0,nMT,0,nMB,0],5,0)
  call Hloop_UV_W(ntryL,G0H32(1),0,ex5(:),16,G1H16(48),m3h2x16(:,48),heltab2x32(:,:,48))
  Gcoeff(:)%j = (c(42)*(-M(1,:)%j+M(7,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(49),h0tab(:,49),[16,2,4,1,8],[0,nMT,nMW,nMB,0],5,0)
  call Hloop_UV_W(ntryL,G0H32(1),0,ex5(:),16,G1H16(49),m3h2x16(:,49),heltab2x32(:,:,49))
  Gcoeff(:)%j = (c(37)*(-M(1,:)%j+M(7,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(50),h0tab(:,50),[16,2,4,1,8],[0,nMT,nMW,nMB,0],5,0)
  call Hloop_UV_W(ntryL,G0H32(1),0,ex5(:),16,G1H16(50),m3h2x16(:,50),heltab2x32(:,:,50))
  Gcoeff(:)%j = (c(44)*M(3,:)%j-c(45)*M(7,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(51),h0tab(:,51),[16,2,8,1,4],[nMT,0,nMB,nMW,nMT],5,0)
  call Hloop_QV_A(ntryL,G0H32(1),ex5(:),G0H16(1),m3h2x16(:,51),heltab2x32(:,:,51))
  call Hloop_Q_A(ntryL,G0H16(1),16,nMT,G1H16(51),n2h16(27))
  Gcoeff(:)%j = (-(c(45)*M(1,:)%j)+c(44)*M(3,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(52),h0tab(:,52),[16,2,8,1,4],[nMB,nMW,nMT,0,nMB],5,0)
  call Hloop_QV_A(ntryL,G0H32(1),ex5(:),G0H16(1),m3h2x16(:,52),heltab2x32(:,:,52))
  call Hloop_Q_A(ntryL,G0H16(1),16,nMB,G1H16(52),n2h16(28))
  Gcoeff(:)%j = (c(39)*M(3,:)%j-c(40)*M(7,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(53),h0tab(:,53),[16,2,8,1,4],[nMT,0,nMB,nMW,nMT],5,0)
  call Hloop_QV_A(ntryL,G0H32(1),ex5(:),G0H16(1),m3h2x16(:,53),heltab2x32(:,:,53))
  call Hloop_Q_A(ntryL,G0H16(1),16,nMT,G1H16(53),n2h16(29))
  Gcoeff(:)%j = (-(c(40)*M(1,:)%j)+c(39)*M(3,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(54),h0tab(:,54),[16,2,8,1,4],[nMB,nMW,nMT,0,nMB],5,0)
  call Hloop_QV_A(ntryL,G0H32(1),ex5(:),G0H16(1),m3h2x16(:,54),heltab2x32(:,:,54))
  call Hloop_Q_A(ntryL,G0H16(1),16,nMB,G1H16(54),n2h16(30))
  Gcoeff(:)%j = (-(c(45)*M(1,:)%j)+c(44)*M(5,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(55),h0tab(:,55),[16,1,4,2,8],[nMB,nMW,nMT,0,nMB],5,0)
  call Hloop_AV_Q(ntryL,G0H32(1),ex5(:),G0H16(1),m3h2x16(:,55),heltab2x32(:,:,55))
  call Hloop_A_Q(ntryL,G0H16(1),16,nMB,G1H16(55),n2h16(31))
  Gcoeff(:)%j = (c(44)*M(5,:)%j-c(45)*M(7,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(56),h0tab(:,56),[16,1,4,2,8],[nMT,0,nMB,nMW,nMT],5,0)
  call Hloop_AV_Q(ntryL,G0H32(1),ex5(:),G0H16(1),m3h2x16(:,56),heltab2x32(:,:,56))
  call Hloop_A_Q(ntryL,G0H16(1),16,nMT,G1H16(56),n2h16(32))
  Gcoeff(:)%j = (c(39)*M(5,:)%j-c(40)*M(7,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(57),h0tab(:,57),[16,1,4,2,8],[nMT,0,nMB,nMW,nMT],5,0)
  call Hloop_AV_Q(ntryL,G0H32(1),ex5(:),G0H16(1),m3h2x16(:,57),heltab2x32(:,:,57))
  call Hloop_A_Q(ntryL,G0H16(1),16,nMT,G1H16(57),n2h16(33))
  Gcoeff(:)%j = (-(c(40)*M(1,:)%j)+c(39)*M(5,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(58),h0tab(:,58),[16,1,4,2,8],[nMB,nMW,nMT,0,nMB],5,0)
  call Hloop_AV_Q(ntryL,G0H32(1),ex5(:),G0H16(1),m3h2x16(:,58),heltab2x32(:,:,58))
  call Hloop_A_Q(ntryL,G0H16(1),16,nMB,G1H16(58),n2h16(34))
  Gcoeff(:)%j = (c(52)*M(1,:)%j-c(53)*M(5,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(59),h0tab(:,59),[16,1,4,8,2],[nMT,nMH,nMB,0,nMT],5,0)
  call Hloop_AV_Q(ntryL,G0H32(1),ex5(:),G0H16(1),m3h2x16(:,59),heltab2x32(:,:,59))
  call Hloop_A_Q(ntryL,G0H16(1),16,nMT,G1H16(59),n2h16(35))
  Gcoeff(:)%j = (c(52)*M(1,:)%j-c(53)*M(5,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(60),h0tab(:,60),[16,1,4,8,2],[nMT,nMZ,nMB,0,nMT],5,0)
  call Hloop_AV_Q(ntryL,G0H32(1),ex5(:),G0H16(1),m3h2x16(:,60),heltab2x32(:,:,60))
  call Hloop_A_Q(ntryL,G0H16(1),16,nMT,G1H16(60),n2h16(36))
  Gcoeff(:)%j = (c(52)*M(1,:)%j-c(53)*M(3,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(61),h0tab(:,61),[16,1,4,8,2],[nMT,0,nMB,nMH,nMT],5,0)
  call Hloop_AV_Q(ntryL,G0H32(1),ex5(:),G0H16(1),m3h2x16(:,61),heltab2x32(:,:,61))
  call Hloop_A_Q(ntryL,G0H16(1),16,nMT,G1H16(61),n2h16(37))
  Gcoeff(:)%j = (c(52)*M(1,:)%j-c(53)*M(3,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(62),h0tab(:,62),[16,1,4,8,2],[nMT,0,nMB,nMZ,nMT],5,0)
  call Hloop_AV_Q(ntryL,G0H32(1),ex5(:),G0H16(1),m3h2x16(:,62),heltab2x32(:,:,62))
  call Hloop_A_Q(ntryL,G0H16(1),16,nMT,G1H16(62),n2h16(38))
  Gcoeff(:)%j = (c(9)*M(1,:)%j-c(10)*M(5,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(63),h0tab(:,63),[16,1,4,8,2],[nMT,0,nMB,0,nMT],5,0)
  call Hloop_AV_Q(ntryL,G0H32(1),ex5(:),G0H16(1),m3h2x16(:,63),heltab2x32(:,:,63))
  call Hloop_A_Q(ntryL,G0H16(1),16,nMT,G1H16(63),n2h16(39))
  Gcoeff(:)%j = (c(9)*M(1,:)%j-c(10)*M(3,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(64),h0tab(:,64),[16,1,4,8,2],[nMT,0,nMB,0,nMT],5,0)
  call Hloop_AV_Q(ntryL,G0H32(1),ex5(:),G0H16(1),m3h2x16(:,64),heltab2x32(:,:,64))
  call Hloop_A_Q(ntryL,G0H16(1),16,nMT,G1H16(64),n2h16(40))
  Gcoeff(:)%j = (-(c(14)*M(1,:)%j)+c(15)*M(5,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(65),h0tab(:,65),[16,1,4,8,2],[nMT,nMZ,nMB,0,nMT],5,0)
  call Hloop_AV_Q(ntryL,G0H32(1),ex5(:),G0H16(1),m3h2x16(:,65),heltab2x32(:,:,65))
  call Hloop_A_Q(ntryL,G0H16(1),16,nMT,G1H16(65),n2h16(41))
  Gcoeff(:)%j = (-(c(14)*M(1,:)%j)+c(15)*M(3,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(66),h0tab(:,66),[16,1,4,8,2],[nMT,0,nMB,nMZ,nMT],5,0)
  call Hloop_AV_Q(ntryL,G0H32(1),ex5(:),G0H16(1),m3h2x16(:,66),heltab2x32(:,:,66))
  call Hloop_A_Q(ntryL,G0H16(1),16,nMT,G1H16(66),n2h16(42))
  Gcoeff(:)%j = (c(26)*M(2,:)%j+c(27)*(-M(4,:)%j-M(6,:)%j)+c(30)*M(8,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(67),h0tab(:,67),[16,1,4,8,2],[nMT,0,nMB,0,nMT],5,0)
  call Hloop_AV_Q(ntryL,G0H32(1),ex5(:),G0H16(1),m3h2x16(:,67),heltab2x32(:,:,67))
  call Hloop_A_Q(ntryL,G0H16(1),16,nMT,G1H16(67),n2h16(43))
  Gcoeff(:)%j = (c(42)*(M(1,:)%j-M(7,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(68),h0tab(:,68),[16,1,8,2,4],[0,nMT,nMW,nMB,0],5,0)
  call Hloop_UV_W(ntryL,G0H32(1),0,ex5(:),16,G1H16(68),m3h2x16(:,68),heltab2x32(:,:,68))
  Gcoeff(:)%j = (c(37)*(M(1,:)%j-M(7,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(69),h0tab(:,69),[16,1,8,2,4],[0,nMT,nMW,nMB,0],5,0)
  call Hloop_UV_W(ntryL,G0H32(1),0,ex5(:),16,G1H16(69),m3h2x16(:,69),heltab2x32(:,:,69))
  Gcoeff(:)%j = (c(52)*M(1,:)%j-c(53)*M(5,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(70),h0tab(:,70),[16,1,8,4,2],[nMT,nMH,nMB,0,nMT],5,0)
  call Hloop_AV_Q(ntryL,G0H32(1),ex5(:),G0H16(1),m3h2x16(:,70),heltab2x32(:,:,70))
  call Hloop_A_Q(ntryL,G0H16(1),16,nMT,G1H16(70),n2h16(44))
  Gcoeff(:)%j = (c(52)*M(1,:)%j-c(53)*M(5,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(71),h0tab(:,71),[16,1,8,4,2],[nMT,nMZ,nMB,0,nMT],5,0)
  call Hloop_AV_Q(ntryL,G0H32(1),ex5(:),G0H16(1),m3h2x16(:,71),heltab2x32(:,:,71))
  call Hloop_A_Q(ntryL,G0H16(1),16,nMT,G1H16(71),n2h16(45))
  Gcoeff(:)%j = (c(52)*M(1,:)%j-c(53)*M(3,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(72),h0tab(:,72),[16,1,8,4,2],[nMT,0,nMB,nMH,nMT],5,0)
  call Hloop_AV_Q(ntryL,G0H32(1),ex5(:),G0H16(1),m3h2x16(:,72),heltab2x32(:,:,72))
  call Hloop_A_Q(ntryL,G0H16(1),16,nMT,G1H16(72),n2h16(46))
  Gcoeff(:)%j = (c(52)*M(1,:)%j-c(53)*M(3,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(73),h0tab(:,73),[16,1,8,4,2],[nMT,0,nMB,nMZ,nMT],5,0)
  call Hloop_AV_Q(ntryL,G0H32(1),ex5(:),G0H16(1),m3h2x16(:,73),heltab2x32(:,:,73))
  call Hloop_A_Q(ntryL,G0H16(1),16,nMT,G1H16(73),n2h16(47))
  Gcoeff(:)%j = (c(9)*M(1,:)%j-c(10)*M(5,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(74),h0tab(:,74),[16,1,8,4,2],[nMT,0,nMB,0,nMT],5,0)
  call Hloop_AV_Q(ntryL,G0H32(1),ex5(:),G0H16(1),m3h2x16(:,74),heltab2x32(:,:,74))
  call Hloop_A_Q(ntryL,G0H16(1),16,nMT,G1H16(74),n2h16(48))
  Gcoeff(:)%j = (c(9)*M(1,:)%j-c(10)*M(3,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(75),h0tab(:,75),[16,1,8,4,2],[nMT,0,nMB,0,nMT],5,0)
  call Hloop_AV_Q(ntryL,G0H32(1),ex5(:),G0H16(1),m3h2x16(:,75),heltab2x32(:,:,75))
  call Hloop_A_Q(ntryL,G0H16(1),16,nMT,G1H16(75),n2h16(49))
  Gcoeff(:)%j = (-(c(14)*M(1,:)%j)+c(15)*M(5,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(76),h0tab(:,76),[16,1,8,4,2],[nMT,nMZ,nMB,0,nMT],5,0)
  call Hloop_AV_Q(ntryL,G0H32(1),ex5(:),G0H16(1),m3h2x16(:,76),heltab2x32(:,:,76))
  call Hloop_A_Q(ntryL,G0H16(1),16,nMT,G1H16(76),n2h16(50))
  Gcoeff(:)%j = (-(c(14)*M(1,:)%j)+c(15)*M(3,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(77),h0tab(:,77),[16,1,8,4,2],[nMT,0,nMB,nMZ,nMT],5,0)
  call Hloop_AV_Q(ntryL,G0H32(1),ex5(:),G0H16(1),m3h2x16(:,77),heltab2x32(:,:,77))
  call Hloop_A_Q(ntryL,G0H16(1),16,nMT,G1H16(77),n2h16(51))
  Gcoeff(:)%j = (c(26)*M(2,:)%j+c(27)*(-M(4,:)%j-M(6,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(78),h0tab(:,78),[16,1,8,4,2],[nMT,0,nMB,0,nMT],5,0)
  call Hloop_AV_Q(ntryL,G0H32(1),ex5(:),G0H16(1),m3h2x16(:,78),heltab2x32(:,:,78))
  call Hloop_A_Q(ntryL,G0H16(1),16,nMT,G1H16(78),n2h16(52))
  Gcoeff(:)%j = (c(42)*(M(1,:)%j-M(7,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(79),h0tab(:,79),[16,1,8,4,2],[0,nMT,nMW,nMT,0],5,0)
  call Hloop_UV_W(ntryL,G0H32(1),0,ex5(:),16,G1H16(79),m3h2x16(:,79),heltab2x32(:,:,79))
  Gcoeff(:)%j = (c(37)*(M(1,:)%j-M(7,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(80),h0tab(:,80),[16,1,8,4,2],[0,nMT,nMW,nMT,0],5,0)
  call Hloop_UV_W(ntryL,G0H32(1),0,ex5(:),16,G1H16(80),m3h2x16(:,80),heltab2x32(:,:,80))
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H16(9),[G1H16(6),G1H16(5)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H16(14),[G1H16(12)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H16(23),[G1H16(20),G1H16(19)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H16(34),[G1H16(32)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H16(43),[G1H16(41)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H16(48),[G1H16(46)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H16(67),[G1H16(64),G1H16(63)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H16(78),[G1H16(75),G1H16(74)])
  call Hloop_AQ_S(ntryL,G1H16(1),ex3(:),G1H8(1),ngH,m3h2x8(:,1),heltab2x16(:,:,1))
  call Hloop_AQ_S(ntryL,G1H16(2),ex3(:),G1H8(2),ngX,m3h2x8(:,2),heltab2x16(:,:,2))
  call Hloop_AQ_V(ntryL,G1H16(3),ex3(:),G1H8(3),m3h2x8(:,3),heltab2x16(:,:,3))
  call Hloop_AQ_V(ntryL,G1H16(4),ex3(:),G1H8(4),m3h2x8(:,4),heltab2x16(:,:,4))
  call Hloop_AQ_V(ntryL,G1H16(9),ex3(:),G1H8(5),m3h2x8(:,5),heltab2x16(:,:,5))
  call Hloop_AQ_Z(ntryL,G1H16(7),ex3(:),G1H8(6),ngZd,m3h2x8(:,6),heltab2x16(:,:,6))
  call Hloop_AQ_V(ntryL,G1H16(8),ex3(:),G1H8(7),m3h2x8(:,7),heltab2x16(:,:,7))
  call Hloop_VA_Q(ntryL,G1H16(10),ex2(:),G1H8(8),m3h2x8(:,8),heltab2x16(:,:,8))
  call Hloop_A_Q(ntryL,G1H8(8),18,nMT,G2H8(1),n2h8(1))
  call Hloop_VA_Q(ntryL,G1H16(11),ex2(:),G1H8(8),m3h2x8(:,9),heltab2x16(:,:,9))
  call Hloop_A_Q(ntryL,G1H8(8),18,nMT,G2H8(2),n2h8(2))
  call Hloop_VA_Q(ntryL,G1H16(14),ex2(:),G1H8(8),m3h2x8(:,10),heltab2x16(:,:,10))
  call Hloop_A_Q(ntryL,G1H8(8),18,nMT,G2H8(3),n2h8(3))
  call Hloop_VA_Q(ntryL,G1H16(13),ex2(:),G1H8(8),m3h2x8(:,11),heltab2x16(:,:,11))
  call Hloop_A_Q(ntryL,G1H8(8),18,nMT,G2H8(4),n2h8(4))
  call Hloop_AQ_V(ntryL,G1H16(15),ex3(:),G1H8(8),m3h2x8(:,12),heltab2x16(:,:,12))
  call Hloop_AQ_V(ntryL,G1H16(16),ex3(:),G1H8(9),m3h2x8(:,13),heltab2x16(:,:,13))
  call Hloop_AQ_S(ntryL,G1H16(17),ex3(:),G1H8(10),ngH,m3h2x8(:,14),heltab2x16(:,:,14))
  call Hloop_AQ_S(ntryL,G1H16(18),ex3(:),G1H8(11),ngX,m3h2x8(:,15),heltab2x16(:,:,15))
  call Hloop_AQ_V(ntryL,G1H16(23),ex3(:),G1H8(12),m3h2x8(:,16),heltab2x16(:,:,16))
  call Hloop_AQ_V(ntryL,G1H16(21),ex3(:),G1H8(13),m3h2x8(:,17),heltab2x16(:,:,17))
  call Hloop_AQ_Z(ntryL,G1H16(22),ex3(:),G1H8(14),ngZd,m3h2x8(:,18),heltab2x16(:,:,18))
  call Hloop_VQ_A(ntryL,G1H16(24),ex3(:),G1H8(15),m3h2x8(:,19),heltab2x16(:,:,19))
  call Hloop_Q_A(ntryL,G1H8(15),20,nMB,G2H8(5),n2h8(5))
  call Hloop_VQ_A(ntryL,G1H16(25),ex3(:),G1H8(15),m3h2x8(:,20),heltab2x16(:,:,20))
  call Hloop_Q_A(ntryL,G1H8(15),20,nMB,G2H8(6),n2h8(6))
  call Hloop_QA_S(ntryL,G1H16(26),ex2(:),G1H8(15),ngPtb,m3h2x8(:,21),heltab2x16(:,:,21))
  call Hloop_QA_V(ntryL,G1H16(27),ex2(:),G1H8(16),m3h2x8(:,22),heltab2x16(:,:,22))
  call Hloop_QA_V(ntryL,G1H16(28),ex2(:),G1H8(17),m3h2x8(:,23),heltab2x16(:,:,23))
  call Hloop_QA_W(ntryL,G1H16(29),ex2(:),G1H8(18),m3h2x8(:,24),heltab2x16(:,:,24))
  call Hloop_VA_Q(ntryL,G1H16(30),ex2(:),G1H8(19),m3h2x8(:,25),heltab2x16(:,:,25))
  call Hloop_A_Q(ntryL,G1H8(19),18,nMT,G2H8(7),n2h8(7))
  call Hloop_VA_Q(ntryL,G1H16(31),ex2(:),G1H8(19),m3h2x8(:,26),heltab2x16(:,:,26))
  call Hloop_A_Q(ntryL,G1H8(19),18,nMT,G2H8(8),n2h8(8))
  call Hloop_VA_Q(ntryL,G1H16(34),ex2(:),G1H8(19),m3h2x8(:,27),heltab2x16(:,:,27))
  call Hloop_A_Q(ntryL,G1H8(19),18,nMT,G2H8(9),n2h8(9))
  call Hloop_VA_Q(ntryL,G1H16(33),ex2(:),G1H8(19),m3h2x8(:,28),heltab2x16(:,:,28))
  call Hloop_A_Q(ntryL,G1H8(19),18,nMT,G2H8(10),n2h8(10))
  call Hloop_AQ_S(ntryL,G1H16(35),ex1(:),G1H8(19),ngPbt,m3h2x8(:,29),heltab2x16(:,:,29))
  call Hloop_AQ_V(ntryL,G1H16(36),ex1(:),G1H8(20),m3h2x8(:,30),heltab2x16(:,:,30))
  call Hloop_AQ_V(ntryL,G1H16(37),ex1(:),G1H8(21),m3h2x8(:,31),heltab2x16(:,:,31))
  call Hloop_AQ_W(ntryL,G1H16(38),ex1(:),G1H8(22),m3h2x8(:,32),heltab2x16(:,:,32))
  call Hloop_VQ_A(ntryL,G1H16(39),ex1(:),G1H8(23),m3h2x8(:,33),heltab2x16(:,:,33))
  call Hloop_Q_A(ntryL,G1H8(23),17,nMT,G2H8(11),n2h8(11))
  call Hloop_VQ_A(ntryL,G1H16(40),ex1(:),G1H8(23),m3h2x8(:,34),heltab2x16(:,:,34))
  call Hloop_Q_A(ntryL,G1H8(23),17,nMT,G2H8(12),n2h8(12))
  call Hloop_VQ_A(ntryL,G1H16(43),ex1(:),G1H8(23),m3h2x8(:,35),heltab2x16(:,:,35))
  call Hloop_Q_A(ntryL,G1H8(23),17,nMT,G2H8(13),n2h8(13))
  call Hloop_VQ_A(ntryL,G1H16(42),ex1(:),G1H8(23),m3h2x8(:,36),heltab2x16(:,:,36))
  call Hloop_Q_A(ntryL,G1H8(23),17,nMT,G2H8(14),n2h8(14))
  call Hloop_VQ_A(ntryL,G1H16(44),ex1(:),G1H8(23),m3h2x8(:,37),heltab2x16(:,:,37))
  call Hloop_Q_A(ntryL,G1H8(23),17,nMT,G2H8(15),n2h8(15))
  call Hloop_VQ_A(ntryL,G1H16(45),ex1(:),G1H8(23),m3h2x8(:,38),heltab2x16(:,:,38))
  call Hloop_Q_A(ntryL,G1H8(23),17,nMT,G2H8(16),n2h8(16))
  call Hloop_VQ_A(ntryL,G1H16(48),ex1(:),G1H8(23),m3h2x8(:,39),heltab2x16(:,:,39))
  call Hloop_Q_A(ntryL,G1H8(23),17,nMT,G2H8(17),n2h8(17))
  call Hloop_VQ_A(ntryL,G1H16(47),ex1(:),G1H8(23),m3h2x8(:,40),heltab2x16(:,:,40))
  call Hloop_Q_A(ntryL,G1H8(23),17,nMT,G2H8(18),n2h8(18))
  call Hloop_VA_Q(ntryL,G1H16(49),ex2(:),G1H8(23),m3h2x8(:,41),heltab2x16(:,:,41))
  call Hloop_A_Q(ntryL,G1H8(23),18,nMT,G2H8(19),n2h8(19))
  call Hloop_VA_Q(ntryL,G1H16(50),ex2(:),G1H8(23),m3h2x8(:,42),heltab2x16(:,:,42))
  call Hloop_A_Q(ntryL,G1H8(23),18,nMT,G2H8(20),n2h8(20))
  call Hloop_QA_V(ntryL,G1H16(51),ex2(:),G1H8(23),m3h2x8(:,43),heltab2x16(:,:,43))
  call Hloop_QA_S(ntryL,G1H16(52),ex2(:),G1H8(24),ngPtb,m3h2x8(:,44),heltab2x16(:,:,44))
  call Hloop_QA_V(ntryL,G1H16(53),ex2(:),G1H8(25),m3h2x8(:,45),heltab2x16(:,:,45))
  call Hloop_QA_W(ntryL,G1H16(54),ex2(:),G1H8(26),m3h2x8(:,46),heltab2x16(:,:,46))
  call Hloop_AQ_S(ntryL,G1H16(55),ex1(:),G1H8(27),ngPbt,m3h2x8(:,47),heltab2x16(:,:,47))
  call Hloop_AQ_V(ntryL,G1H16(56),ex1(:),G1H8(28),m3h2x8(:,48),heltab2x16(:,:,48))
  call Hloop_AQ_V(ntryL,G1H16(57),ex1(:),G1H8(29),m3h2x8(:,49),heltab2x16(:,:,49))
  call Hloop_AQ_W(ntryL,G1H16(58),ex1(:),G1H8(30),m3h2x8(:,50),heltab2x16(:,:,50))
  call Hloop_AQ_S(ntryL,G1H16(59),ex1(:),G1H8(31),ngH,m3h2x8(:,51),heltab2x16(:,:,51))
  call Hloop_AQ_S(ntryL,G1H16(60),ex1(:),G1H8(32),ngX,m3h2x8(:,52),heltab2x16(:,:,52))
  call Hloop_AQ_V(ntryL,G1H16(61),ex1(:),G1H8(33),m3h2x8(:,53),heltab2x16(:,:,53))
  call Hloop_AQ_V(ntryL,G1H16(62),ex1(:),G1H8(34),m3h2x8(:,54),heltab2x16(:,:,54))
  call Hloop_AQ_V(ntryL,G1H16(67),ex1(:),G1H8(35),m3h2x8(:,55),heltab2x16(:,:,55))
  call Hloop_AQ_Z(ntryL,G1H16(65),ex1(:),G1H8(36),ngZu,m3h2x8(:,56),heltab2x16(:,:,56))
  call Hloop_AQ_V(ntryL,G1H16(66),ex1(:),G1H8(37),m3h2x8(:,57),heltab2x16(:,:,57))
  call Hloop_VQ_A(ntryL,G1H16(68),ex1(:),G1H8(38),m3h2x8(:,58),heltab2x16(:,:,58))
  call Hloop_Q_A(ntryL,G1H8(38),17,nMT,G2H8(21),n2h8(21))
  call Hloop_VQ_A(ntryL,G1H16(69),ex1(:),G1H8(38),m3h2x8(:,59),heltab2x16(:,:,59))
  call Hloop_Q_A(ntryL,G1H8(38),17,nMT,G2H8(22),n2h8(22))
  call Hloop_AQ_S(ntryL,G1H16(70),ex1(:),G1H8(38),ngH,m3h2x8(:,60),heltab2x16(:,:,60))
  call Hloop_AQ_S(ntryL,G1H16(71),ex1(:),G1H8(39),ngX,m3h2x8(:,61),heltab2x16(:,:,61))
  call Hloop_AQ_V(ntryL,G1H16(72),ex1(:),G1H8(40),m3h2x8(:,62),heltab2x16(:,:,62))
  call Hloop_AQ_V(ntryL,G1H16(73),ex1(:),G1H8(41),m3h2x8(:,63),heltab2x16(:,:,63))
  call Hloop_AQ_V(ntryL,G1H16(78),ex1(:),G1H8(42),m3h2x8(:,64),heltab2x16(:,:,64))
  call Hloop_AQ_Z(ntryL,G1H16(76),ex1(:),G1H8(43),ngZu,m3h2x8(:,65),heltab2x16(:,:,65))
  call Hloop_AQ_V(ntryL,G1H16(77),ex1(:),G1H8(44),m3h2x8(:,66),heltab2x16(:,:,66))
  call Hloop_VQ_A(ntryL,G1H16(79),ex1(:),G1H8(45),m3h2x8(:,67),heltab2x16(:,:,67))
  call Hloop_Q_A(ntryL,G1H8(45),17,nMT,G2H8(23),n2h8(23))
  call Hloop_VQ_A(ntryL,G1H16(80),ex1(:),G1H8(45),m3h2x8(:,68),heltab2x16(:,:,68))
  call Hloop_Q_A(ntryL,G1H8(45),17,nMT,G2H8(24),n2h8(24))
  call Hloop_SQ_A(ntryL,G1H8(1),ex1(:),G1H4(1),ngH,m3h2x4(:,1),heltab2x8(:,:,1))
  call Hloop_Q_A(ntryL,G1H4(1),21,nMT,G2H4(1),n2h4(1))
  call Hloop_SQ_A(ntryL,G1H8(2),ex1(:),G1H4(1),ngX,m3h2x4(:,2),heltab2x8(:,:,2))
  call Hloop_Q_A(ntryL,G1H4(1),21,nMT,G2H4(2),n2h4(2))
  call Hloop_VQ_A(ntryL,G1H8(3),ex1(:),G1H4(1),m3h2x4(:,3),heltab2x8(:,:,3))
  call Hloop_Q_A(ntryL,G1H4(1),21,nMT,G2H4(3),n2h4(3))
  call Hloop_VQ_A(ntryL,G1H8(4),ex1(:),G1H4(1),m3h2x4(:,4),heltab2x8(:,:,4))
  call Hloop_Q_A(ntryL,G1H4(1),21,nMT,G2H4(4),n2h4(4))
  call Hloop_VQ_A(ntryL,G1H8(5),ex1(:),G1H4(1),m3h2x4(:,5),heltab2x8(:,:,5))
  call Hloop_Q_A(ntryL,G1H4(1),21,nMT,G2H4(5),n2h4(5))
  call Hloop_ZQ_A(ntryL,G1H8(6),ex1(:),G1H4(1),ngZu,m3h2x4(:,6),heltab2x8(:,:,6))
  call Hloop_Q_A(ntryL,G1H4(1),21,nMT,G2H4(6),n2h4(6))
  call Hloop_VQ_A(ntryL,G1H8(7),ex1(:),G1H4(1),m3h2x4(:,7),heltab2x8(:,:,7))
  call Hloop_Q_A(ntryL,G1H4(1),21,nMT,G2H4(7),n2h4(7))
  call Hloop_AQ_S(ntryL,G2H8(1),ex1(:),G2H4(8),ngH,m3h2x4(:,8),heltab2x8(:,:,8))
  call Hloop_AQ_S(ntryL,G2H8(2),ex1(:),G2H4(9),ngX,m3h2x4(:,9),heltab2x8(:,:,9))
  call Hloop_AQ_V(ntryL,G2H8(3),ex1(:),G2H4(10),m3h2x4(:,10),heltab2x8(:,:,10))
  call Hloop_AQ_Z(ntryL,G2H8(4),ex1(:),G2H4(11),ngZu,m3h2x4(:,11),heltab2x8(:,:,11))
  call Hloop_VA_Q(ntryL,G1H8(8),ex2(:),G1H4(1),m3h2x4(:,12),heltab2x8(:,:,12))
  call Hloop_A_Q(ntryL,G1H4(1),22,nMT,G2H4(12),n2h4(8))
  call Hloop_VA_Q(ntryL,G1H8(9),ex2(:),G1H4(1),m3h2x4(:,13),heltab2x8(:,:,13))
  call Hloop_A_Q(ntryL,G1H4(1),22,nMT,G2H4(13),n2h4(9))
  call Hloop_SA_Q(ntryL,G1H8(10),ex2(:),G1H4(1),ngH,m3h2x4(:,14),heltab2x8(:,:,14))
  call Hloop_A_Q(ntryL,G1H4(1),22,nMT,G2H4(14),n2h4(10))
  call Hloop_SA_Q(ntryL,G1H8(11),ex2(:),G1H4(1),ngX,m3h2x4(:,15),heltab2x8(:,:,15))
  call Hloop_A_Q(ntryL,G1H4(1),22,nMT,G2H4(15),n2h4(11))
  call Hloop_VA_Q(ntryL,G1H8(12),ex2(:),G1H4(1),m3h2x4(:,16),heltab2x8(:,:,16))
  call Hloop_A_Q(ntryL,G1H4(1),22,nMT,G2H4(16),n2h4(12))
  call Hloop_VA_Q(ntryL,G1H8(13),ex2(:),G1H4(1),m3h2x4(:,17),heltab2x8(:,:,17))
  call Hloop_A_Q(ntryL,G1H4(1),22,nMT,G2H4(17),n2h4(13))
  call Hloop_ZA_Q(ntryL,G1H8(14),ex2(:),G1H4(1),ngZu,m3h2x4(:,18),heltab2x8(:,:,18))
  call Hloop_A_Q(ntryL,G1H4(1),22,nMT,G2H4(18),n2h4(14))
  call Hloop_QA_S(ntryL,G2H8(5),ex2(:),G2H4(19),ngPtb,m3h2x4(:,19),heltab2x8(:,:,19))
  call Hloop_QA_W(ntryL,G2H8(6),ex2(:),G2H4(20),m3h2x4(:,20),heltab2x8(:,:,20))
  call Hloop_SQ_A(ntryL,G1H8(15),ex1(:),G1H4(1),ngPbt,m3h2x4(:,21),heltab2x8(:,:,21))
  call Hloop_Q_A(ntryL,G1H4(1),19,nMB,G2H4(21),n2h4(15))
  call Hloop_VQ_A(ntryL,G1H8(16),ex1(:),G1H4(1),m3h2x4(:,22),heltab2x8(:,:,22))
  call Hloop_Q_A(ntryL,G1H4(1),19,nMT,G2H4(22),n2h4(16))
  call Hloop_VQ_A(ntryL,G1H8(17),ex1(:),G1H4(1),m3h2x4(:,23),heltab2x8(:,:,23))
  call Hloop_Q_A(ntryL,G1H4(1),19,nMT,G2H4(23),n2h4(17))
  call Hloop_WQ_A(ntryL,G1H8(18),ex1(:),G1H4(1),m3h2x4(:,24),heltab2x8(:,:,24))
  call Hloop_Q_A(ntryL,G1H4(1),19,nMB,G2H4(24),n2h4(18))
  call Hloop_AQ_S(ntryL,G2H8(7),ex1(:),G2H4(25),ngH,m3h2x4(:,25),heltab2x8(:,:,25))
  call Hloop_AQ_S(ntryL,G2H8(8),ex1(:),G2H4(26),ngX,m3h2x4(:,26),heltab2x8(:,:,26))
  call Hloop_AQ_V(ntryL,G2H8(9),ex1(:),G2H4(27),m3h2x4(:,27),heltab2x8(:,:,27))
  call Hloop_AQ_Z(ntryL,G2H8(10),ex1(:),G2H4(28),ngZu,m3h2x4(:,28),heltab2x8(:,:,28))
  call Hloop_SA_Q(ntryL,G1H8(19),ex2(:),G1H4(1),ngPtb,m3h2x4(:,29),heltab2x8(:,:,29))
  call Hloop_A_Q(ntryL,G1H4(1),19,nMB,G2H4(29),n2h4(19))
  call Hloop_VA_Q(ntryL,G1H8(20),ex2(:),G1H4(1),m3h2x4(:,30),heltab2x8(:,:,30))
  call Hloop_A_Q(ntryL,G1H4(1),19,nMT,G2H4(30),n2h4(20))
  call Hloop_VA_Q(ntryL,G1H8(21),ex2(:),G1H4(1),m3h2x4(:,31),heltab2x8(:,:,31))
  call Hloop_A_Q(ntryL,G1H4(1),19,nMT,G2H4(31),n2h4(21))
  call Hloop_WA_Q(ntryL,G1H8(22),ex2(:),G1H4(1),m3h2x4(:,32),heltab2x8(:,:,32))
  call Hloop_A_Q(ntryL,G1H4(1),19,nMB,G2H4(32),n2h4(22))
  call Hloop_QA_S(ntryL,G2H8(11),ex2(:),G2H4(33),ngH,m3h2x4(:,33),heltab2x8(:,:,33))
  call Hloop_QA_S(ntryL,G2H8(12),ex2(:),G2H4(34),ngX,m3h2x4(:,34),heltab2x8(:,:,34))
  call Hloop_QA_V(ntryL,G2H8(13),ex2(:),G2H4(35),m3h2x4(:,35),heltab2x8(:,:,35))
  call Hloop_QA_Z(ntryL,G2H8(14),ex2(:),G2H4(36),ngZu,m3h2x4(:,36),heltab2x8(:,:,36))
  call Hloop_QA_S(ntryL,G2H8(15),ex2(:),G2H4(37),ngH,m3h2x4(:,37),heltab2x8(:,:,37))
  call Hloop_QA_S(ntryL,G2H8(16),ex2(:),G2H4(38),ngX,m3h2x4(:,38),heltab2x8(:,:,38))
  call Hloop_QA_V(ntryL,G2H8(17),ex2(:),G2H4(39),m3h2x4(:,39),heltab2x8(:,:,39))
  call Hloop_QA_Z(ntryL,G2H8(18),ex2(:),G2H4(40),ngZu,m3h2x4(:,40),heltab2x8(:,:,40))
  call Hloop_AQ_S(ntryL,G2H8(19),ex3(:),G2H4(41),ngPtb,m3h2x4(:,41),heltab2x8(:,:,41))
  call Hloop_AQ_W(ntryL,G2H8(20),ex3(:),G2H4(42),m3h2x4(:,42),heltab2x8(:,:,42))
  call Hloop_VA_Q(ntryL,G1H8(23),ex4(:),G1H4(1),m3h2x4(:,43),heltab2x8(:,:,43))
  call Hloop_A_Q(ntryL,G1H4(1),26,nMB,G2H4(43),n2h4(23))
  call Hloop_SA_Q(ntryL,G1H8(24),ex4(:),G1H4(1),ngPbt,m3h2x4(:,44),heltab2x8(:,:,44))
  call Hloop_A_Q(ntryL,G1H4(1),26,nMT,G2H4(44),n2h4(24))
  call Hloop_VA_Q(ntryL,G1H8(25),ex4(:),G1H4(1),m3h2x4(:,45),heltab2x8(:,:,45))
  call Hloop_A_Q(ntryL,G1H4(1),26,nMB,G2H4(45),n2h4(25))
  call Hloop_WA_Q(ntryL,G1H8(26),ex4(:),G1H4(1),m3h2x4(:,46),heltab2x8(:,:,46))
  call Hloop_A_Q(ntryL,G1H4(1),26,nMT,G2H4(46),n2h4(26))
  call Hloop_SQ_A(ntryL,G1H8(27),ex3(:),G1H4(1),ngPtb,m3h2x4(:,47),heltab2x8(:,:,47))
  call Hloop_Q_A(ntryL,G1H4(1),21,nMT,G2H4(47),n2h4(27))
  call Hloop_VQ_A(ntryL,G1H8(28),ex3(:),G1H4(1),m3h2x4(:,48),heltab2x8(:,:,48))
  call Hloop_Q_A(ntryL,G1H4(1),21,nMB,G2H4(48),n2h4(28))
  call Hloop_VQ_A(ntryL,G1H8(29),ex3(:),G1H4(1),m3h2x4(:,49),heltab2x8(:,:,49))
  call Hloop_Q_A(ntryL,G1H4(1),21,nMB,G2H4(49),n2h4(29))
  call Hloop_WQ_A(ntryL,G1H8(30),ex3(:),G1H4(1),m3h2x4(:,50),heltab2x8(:,:,50))
  call Hloop_Q_A(ntryL,G1H4(1),21,nMT,G2H4(50),n2h4(30))
  call Hloop_SQ_A(ntryL,G1H8(31),ex3(:),G1H4(1),ngH,m3h2x4(:,51),heltab2x8(:,:,51))
  call Hloop_Q_A(ntryL,G1H4(1),21,nMB,G2H4(51),n2h4(31))
  call Hloop_SQ_A(ntryL,G1H8(32),ex3(:),G1H4(1),ngX,m3h2x4(:,52),heltab2x8(:,:,52))
  call Hloop_Q_A(ntryL,G1H4(1),21,nMB,G2H4(52),n2h4(32))
  call Hloop_VQ_A(ntryL,G1H8(33),ex3(:),G1H4(1),m3h2x4(:,53),heltab2x8(:,:,53))
  call Hloop_Q_A(ntryL,G1H4(1),21,nMB,G2H4(53),n2h4(33))
  call Hloop_VQ_A(ntryL,G1H8(34),ex3(:),G1H4(1),m3h2x4(:,54),heltab2x8(:,:,54))
  call Hloop_Q_A(ntryL,G1H4(1),21,nMB,G2H4(54),n2h4(34))
  call Hloop_VQ_A(ntryL,G1H8(35),ex3(:),G1H4(1),m3h2x4(:,55),heltab2x8(:,:,55))
  call Hloop_Q_A(ntryL,G1H4(1),21,nMB,G2H4(55),n2h4(35))
  call Hloop_ZQ_A(ntryL,G1H8(36),ex3(:),G1H4(1),ngZd,m3h2x4(:,56),heltab2x8(:,:,56))
  call Hloop_Q_A(ntryL,G1H4(1),21,nMB,G2H4(56),n2h4(36))
  call Hloop_VQ_A(ntryL,G1H8(37),ex3(:),G1H4(1),m3h2x4(:,57),heltab2x8(:,:,57))
  call Hloop_Q_A(ntryL,G1H4(1),21,nMB,G2H4(57),n2h4(37))
  call Hloop_QA_S(ntryL,G2H8(21),ex4(:),G2H4(58),ngPbt,m3h2x4(:,58),heltab2x8(:,:,58))
  call Hloop_QA_W(ntryL,G2H8(22),ex4(:),G2H4(59),m3h2x4(:,59),heltab2x8(:,:,59))
  call Hloop_SA_Q(ntryL,G1H8(38),ex4(:),G1H4(1),ngH,m3h2x4(:,60),heltab2x8(:,:,60))
  call Hloop_A_Q(ntryL,G1H4(1),25,nMB,G2H4(60),n2h4(38))
  call Hloop_SA_Q(ntryL,G1H8(39),ex4(:),G1H4(1),ngX,m3h2x4(:,61),heltab2x8(:,:,61))
  call Hloop_A_Q(ntryL,G1H4(1),25,nMB,G2H4(61),n2h4(39))
  call Hloop_VA_Q(ntryL,G1H8(40),ex4(:),G1H4(1),m3h2x4(:,62),heltab2x8(:,:,62))
  call Hloop_A_Q(ntryL,G1H4(1),25,nMB,G2H4(62),n2h4(40))
  call Hloop_VA_Q(ntryL,G1H8(41),ex4(:),G1H4(1),m3h2x4(:,63),heltab2x8(:,:,63))
  call Hloop_A_Q(ntryL,G1H4(1),25,nMB,G2H4(63),n2h4(41))
  call Hloop_VA_Q(ntryL,G1H8(42),ex4(:),G1H4(1),m3h2x4(:,64),heltab2x8(:,:,64))
  call Hloop_A_Q(ntryL,G1H4(1),25,nMB,G2H4(64),n2h4(42))
  call Hloop_ZA_Q(ntryL,G1H8(43),ex4(:),G1H4(1),ngZd,m3h2x4(:,65),heltab2x8(:,:,65))
  call Hloop_A_Q(ntryL,G1H4(1),25,nMB,G2H4(65),n2h4(43))
  call Hloop_VA_Q(ntryL,G1H8(44),ex4(:),G1H4(1),m3h2x4(:,66),heltab2x8(:,:,66))
  call Hloop_A_Q(ntryL,G1H4(1),25,nMB,G2H4(66),n2h4(44))
  call Hloop_QA_S(ntryL,G2H8(23),ex4(:),G2H4(67),ngPbt,m3h2x4(:,67),heltab2x8(:,:,67))
  call Hloop_QA_W(ntryL,G2H8(24),ex4(:),G2H4(68),m3h2x4(:,68),heltab2x8(:,:,68))
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(6),[G2H4(2)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(18),[G2H4(15)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(24),[G2H4(21)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(32),[G2H4(29)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(46),[G2H4(44)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(50),[G2H4(47)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(56),[G2H4(52)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(65),[G2H4(61)])
  call Hloop_QA_V(ntryL,G2H4(1),ex2(:),G2H2(1),m3h2x2(:,1),heltab2x4(:,:,1))
  call Hloop_QA_V(ntryL,G2H4(6),ex2(:),G2H2(2),m3h2x2(:,2),heltab2x4(:,:,2))
  call Hloop_QA_S(ntryL,G2H4(3),ex2(:),G2H2(3),ngH,m3h2x2(:,3),heltab2x4(:,:,3))
  call Hloop_QA_S(ntryL,G2H4(4),ex2(:),G2H2(4),ngX,m3h2x2(:,4),heltab2x4(:,:,4))
  call Hloop_QA_V(ntryL,G2H4(5),ex2(:),G2H2(5),m3h2x2(:,5),heltab2x4(:,:,5))
  call Hloop_QA_Z(ntryL,G2H4(7),ex2(:),G2H2(6),ngZu,m3h2x2(:,6),heltab2x4(:,:,6))
  call Hotf_5pt_reduction(G2H4(8),RedSet_5(1),mass5set(:,1),  & 
G1H4(1),G1H4(2),G1H4(3),G1H4(4),G1H4(5),G1H4(6),4)
  call HG1shiftOLR(G1H4(2),8,4)
  call Hotf_5pt_reduction(G2H4(9),RedSet_5(1),mass5set(:,2),  & 
G1H4(7),G1H4(8),G1H4(9),G1H4(10),G1H4(11),G1H4(12),4)
  call HG1shiftOLR(G1H4(8),8,4)
  call Hotf_5pt_reduction(G2H4(10),RedSet_5(1),mass5set(:,3),  & 
G1H4(13),G1H4(14),G1H4(15),G1H4(16),G1H4(17),G1H4(18),4)
  call HG1shiftOLR(G1H4(14),8,4)
  call Hotf_5pt_reduction(G2H4(11),RedSet_5(1),mass5set(:,2),  & 
G1H4(19),G1H4(20),G1H4(21),G1H4(22),G1H4(23),G1H4(24),4)
  call HG1shiftOLR(G1H4(20),8,4)
  call Hloop_AQ_S(ntryL,G2H4(12),ex1(:),G2H2(7),ngH,m3h2x2(:,7),heltab2x4(:,:,7))
  call Hloop_AQ_S(ntryL,G2H4(13),ex1(:),G2H2(8),ngX,m3h2x2(:,8),heltab2x4(:,:,8))
  call Hloop_AQ_V(ntryL,G2H4(14),ex1(:),G2H2(9),m3h2x2(:,9),heltab2x4(:,:,9))
  call Hloop_AQ_V(ntryL,G2H4(18),ex1(:),G2H2(10),m3h2x2(:,10),heltab2x4(:,:,10))
  call Hloop_AQ_V(ntryL,G2H4(16),ex1(:),G2H2(11),m3h2x2(:,11),heltab2x4(:,:,11))
  call Hloop_AQ_Z(ntryL,G2H4(17),ex1(:),G2H2(12),ngZu,m3h2x2(:,12),heltab2x4(:,:,12))
  call Hotf_5pt_reduction(G2H4(19),RedSet_5(2),mass5set(:,4),  & 
G1H4(25),G1H4(26),G1H4(27),G1H4(28),G1H4(29),G1H4(30),4)
  call HG1shiftOLR(G1H4(26),8,4)
  call Hotf_5pt_reduction(G2H4(20),RedSet_5(2),mass5set(:,4),  & 
G1H4(31),G1H4(32),G1H4(33),G1H4(34),G1H4(35),G1H4(36),4)
  call HG1shiftOLR(G1H4(32),8,4)
  call Hloop_QA_V(ntryL,G2H4(24),ex4(:),G2H2(13),m3h2x2(:,13),heltab2x4(:,:,13))
  call Hloop_QA_S(ntryL,G2H4(22),ex4(:),G2H2(14),ngPbt,m3h2x2(:,14),heltab2x4(:,:,14))
  call Hloop_QA_W(ntryL,G2H4(23),ex4(:),G2H2(15),m3h2x2(:,15),heltab2x4(:,:,15))
  call Hotf_5pt_reduction(G2H4(25),RedSet_5(3),mass5set(:,1),  & 
G1H4(37),G1H4(38),G1H4(39),G1H4(40),G1H4(41),G1H4(42),4)
  call HG1shiftOLR(G1H4(38),4,4)
  call Hotf_5pt_reduction(G2H4(26),RedSet_5(3),mass5set(:,2),  & 
G1H4(43),G1H4(44),G1H4(45),G1H4(46),G1H4(47),G1H4(48),4)
  call HG1shiftOLR(G1H4(44),4,4)
  call Hotf_5pt_reduction(G2H4(27),RedSet_5(3),mass5set(:,3),  & 
G1H4(49),G1H4(50),G1H4(51),G1H4(52),G1H4(53),G1H4(54),4)
  call HG1shiftOLR(G1H4(50),4,4)
  call Hotf_5pt_reduction(G2H4(28),RedSet_5(3),mass5set(:,2),  & 
G1H4(55),G1H4(56),G1H4(57),G1H4(58),G1H4(59),G1H4(60),4)
  call HG1shiftOLR(G1H4(56),4,4)
  call Hloop_AQ_V(ntryL,G2H4(32),ex3(:),G2H2(16),m3h2x2(:,16),heltab2x4(:,:,16))
  call Hloop_AQ_S(ntryL,G2H4(30),ex3(:),G2H2(17),ngPtb,m3h2x2(:,17),heltab2x4(:,:,17))
  call Hloop_AQ_W(ntryL,G2H4(31),ex3(:),G2H2(18),m3h2x2(:,18),heltab2x4(:,:,18))
  call Hotf_5pt_reduction(G2H4(33),RedSet_5(4),mass5set(:,1),  & 
G1H4(61),G1H4(62),G1H4(63),G1H4(64),G1H4(65),G1H4(66),4)
  call HG1shiftOLR(G1H4(62),8,4)
  call Hotf_5pt_reduction(G2H4(34),RedSet_5(4),mass5set(:,2),  & 
G1H4(67),G1H4(68),G1H4(69),G1H4(70),G1H4(71),G1H4(72),4)
  call HG1shiftOLR(G1H4(68),8,4)
  call Hotf_5pt_reduction(G2H4(35),RedSet_5(4),mass5set(:,3),  & 
G1H4(73),G1H4(74),G1H4(75),G1H4(76),G1H4(77),G1H4(78),4)
  call HG1shiftOLR(G1H4(74),8,4)
  call Hotf_5pt_reduction(G2H4(36),RedSet_5(4),mass5set(:,2),  & 
G1H4(79),G1H4(80),G1H4(81),G1H4(82),G1H4(83),G1H4(84),4)
  call HG1shiftOLR(G1H4(80),8,4)
  call Hotf_5pt_reduction(G2H4(37),RedSet_5(5),mass5set(:,1),  & 
G1H4(85),G1H4(86),G1H4(87),G1H4(88),G1H4(89),G1H4(90),4)
  call HG1shiftOLR(G1H4(86),4,4)
  call Hotf_5pt_reduction(G2H4(38),RedSet_5(5),mass5set(:,2),  & 
G1H4(91),G1H4(92),G1H4(93),G1H4(94),G1H4(95),G1H4(96),4)
  call HG1shiftOLR(G1H4(92),4,4)
  call Hotf_5pt_reduction(G2H4(39),RedSet_5(5),mass5set(:,3),  & 
G1H4(97),G1H4(98),G1H4(99),G1H4(100),G1H4(101),G1H4(102),4)
  call HG1shiftOLR(G1H4(98),4,4)
  call Hotf_5pt_reduction(G2H4(40),RedSet_5(5),mass5set(:,2),  & 
G1H4(103),G1H4(104),G1H4(105),G1H4(106),G1H4(107),G1H4(108),4)
  call HG1shiftOLR(G1H4(104),4,4)
  call Hotf_5pt_reduction(G2H4(41),RedSet_5(6),mass5set(:,5),  & 
G1H4(109),G1H4(110),G1H4(111),G1H4(112),G1H4(113),G1H4(114),4)
  call HG1shiftOLR(G1H4(110),8,4)
  call Hotf_5pt_reduction(G2H4(42),RedSet_5(6),mass5set(:,5),  & 
G1H4(115),G1H4(116),G1H4(117),G1H4(118),G1H4(119),G1H4(120),4)
  call HG1shiftOLR(G1H4(116),8,4)
  call Hloop_AQ_S(ntryL,G2H4(43),ex1(:),G2H2(19),ngPbt,m3h2x2(:,19),heltab2x4(:,:,19))
  call Hloop_AQ_V(ntryL,G2H4(46),ex1(:),G2H2(20),m3h2x2(:,20),heltab2x4(:,:,20))
  call Hloop_AQ_W(ntryL,G2H4(45),ex1(:),G2H2(21),m3h2x2(:,21),heltab2x4(:,:,21))
  call Hloop_QA_V(ntryL,G2H4(50),ex2(:),G2H2(22),m3h2x2(:,22),heltab2x4(:,:,22))
  call Hloop_QA_S(ntryL,G2H4(48),ex2(:),G2H2(23),ngPtb,m3h2x2(:,23),heltab2x4(:,:,23))
  call Hloop_QA_W(ntryL,G2H4(49),ex2(:),G2H2(24),m3h2x2(:,24),heltab2x4(:,:,24))
  call Hloop_QA_V(ntryL,G2H4(51),ex4(:),G2H2(25),m3h2x2(:,25),heltab2x4(:,:,25))
  call Hloop_QA_V(ntryL,G2H4(56),ex4(:),G2H2(26),m3h2x2(:,26),heltab2x4(:,:,26))
  call Hloop_QA_S(ntryL,G2H4(53),ex4(:),G2H2(27),ngH,m3h2x2(:,27),heltab2x4(:,:,27))
  call Hloop_QA_S(ntryL,G2H4(54),ex4(:),G2H2(28),ngX,m3h2x2(:,28),heltab2x4(:,:,28))
  call Hloop_QA_V(ntryL,G2H4(55),ex4(:),G2H2(29),m3h2x2(:,29),heltab2x4(:,:,29))
  call Hloop_QA_Z(ntryL,G2H4(57),ex4(:),G2H2(30),ngZd,m3h2x2(:,30),heltab2x4(:,:,30))
  call Hotf_5pt_reduction(G2H4(58),RedSet_5(7),mass5set(:,5),  & 
G1H4(121),G1H4(122),G1H4(123),G1H4(124),G1H4(125),G1H4(126),4)
  call HG1shiftOLR(G1H4(122),4,4)
  call Hotf_5pt_reduction(G2H4(59),RedSet_5(7),mass5set(:,5),  & 
G1H4(127),G1H4(128),G1H4(129),G1H4(130),G1H4(131),G1H4(132),4)
  call HG1shiftOLR(G1H4(128),4,4)
  call Hloop_AQ_V(ntryL,G2H4(60),ex3(:),G2H2(31),m3h2x2(:,31),heltab2x4(:,:,31))
  call Hloop_AQ_V(ntryL,G2H4(65),ex3(:),G2H2(32),m3h2x2(:,32),heltab2x4(:,:,32))
  call Hloop_AQ_S(ntryL,G2H4(62),ex3(:),G2H2(33),ngH,m3h2x2(:,33),heltab2x4(:,:,33))
  call Hloop_AQ_S(ntryL,G2H4(63),ex3(:),G2H2(34),ngX,m3h2x2(:,34),heltab2x4(:,:,34))
  call Hloop_AQ_V(ntryL,G2H4(64),ex3(:),G2H2(35),m3h2x2(:,35),heltab2x4(:,:,35))
  call Hloop_AQ_Z(ntryL,G2H4(66),ex3(:),G2H2(36),ngZd,m3h2x2(:,36),heltab2x4(:,:,36))
  call Hotf_5pt_reduction(G2H4(67),RedSet_5(8),mass5set(:,6),  & 
G1H4(133),G1H4(134),G1H4(135),G1H4(136),G1H4(137),G1H4(138),4)
  call HG1shiftOLR(G1H4(134),2,4)
  call Hotf_5pt_reduction(G2H4(68),RedSet_5(8),mass5set(:,6),  & 
G1H4(139),G1H4(140),G1H4(141),G1H4(142),G1H4(143),G1H4(144),4)
  call HG1shiftOLR(G1H4(140),2,4)
  call Hloop_SQ_A(ntryL,G1H4(1),ex3(:),G1H2(1),ngH,m3h2x2(:,37),heltab2x4(:,:,37))
  call Hloop_Q_A(ntryL,G1H2(1),23,nMB,G2H2(37),n2h2(1))
call HGT_raise_alpha_OLR(G1H4(2),1,1,4)
call HGT_raise_alpha_invQ_OLR(G1H4(2),2,5,4)
  call Hloop_VA_Q(ntryL,G1H4(2),ex4(:),G1H2(1),m3h2x2(:,38),heltab2x4(:,:,38))
  call Hloop_SQ_A(ntryL,G1H4(5),ex3(:),G1H2(2),ngH,m3h2x2(:,39),heltab2x4(:,:,39))
  call Hloop_Q_A(ntryL,G1H2(2),23,nMB,G2H2(38),n2h2(2))
  call Hloop_SQ_A(ntryL,G1H4(6),ex3(:),G1H2(2),ngH,m3h2x2(:,40),heltab2x4(:,:,40))
  call Hloop_Q_A(ntryL,G1H2(2),23,nMB,G2H2(39),n2h2(3))
  call Hloop_SQ_A(ntryL,G1H4(7),ex3(:),G1H2(2),ngX,m3h2x2(:,41),heltab2x4(:,:,41))
  call Hloop_Q_A(ntryL,G1H2(2),23,nMB,G2H2(40),n2h2(4))
call HGT_raise_alpha_OLR(G1H4(8),1,1,4)
call HGT_raise_alpha_invQ_OLR(G1H4(8),2,5,4)
  call Hloop_VA_Q(ntryL,G1H4(8),ex4(:),G1H2(2),m3h2x2(:,42),heltab2x4(:,:,42))
  call Hloop_SQ_A(ntryL,G1H4(11),ex3(:),G1H2(3),ngX,m3h2x2(:,43),heltab2x4(:,:,43))
  call Hloop_Q_A(ntryL,G1H2(3),23,nMB,G2H2(41),n2h2(5))
  call Hloop_SQ_A(ntryL,G1H4(12),ex3(:),G1H2(3),ngX,m3h2x2(:,44),heltab2x4(:,:,44))
  call Hloop_Q_A(ntryL,G1H2(3),23,nMB,G2H2(42),n2h2(6))
  call Hloop_VQ_A(ntryL,G1H4(13),ex3(:),G1H2(3),m3h2x2(:,45),heltab2x4(:,:,45))
  call Hloop_Q_A(ntryL,G1H2(3),23,nMB,G2H2(43),n2h2(7))
call HGT_raise_alpha_OLR(G1H4(14),1,1,4)
call HGT_raise_alpha_invQ_OLR(G1H4(14),2,5,4)
  call Hloop_VA_Q(ntryL,G1H4(14),ex4(:),G1H2(3),m3h2x2(:,46),heltab2x4(:,:,46))
  call Hloop_VQ_A(ntryL,G1H4(17),ex3(:),G1H2(4),m3h2x2(:,47),heltab2x4(:,:,47))
  call Hloop_Q_A(ntryL,G1H2(4),23,nMB,G2H2(44),n2h2(8))
  call Hloop_VQ_A(ntryL,G1H4(18),ex3(:),G1H2(4),m3h2x2(:,48),heltab2x4(:,:,48))
  call Hloop_Q_A(ntryL,G1H2(4),23,nMB,G2H2(45),n2h2(9))
  call Hloop_ZQ_A(ntryL,G1H4(19),ex3(:),G1H2(4),ngZd,m3h2x2(:,49),heltab2x4(:,:,49))
  call Hloop_Q_A(ntryL,G1H2(4),23,nMB,G2H2(46),n2h2(10))
call HGT_raise_alpha_OLR(G1H4(20),1,1,4)
call HGT_raise_alpha_invQ_OLR(G1H4(20),2,5,4)
  call Hloop_VA_Q(ntryL,G1H4(20),ex4(:),G1H2(4),m3h2x2(:,50),heltab2x4(:,:,50))
  call Hloop_ZQ_A(ntryL,G1H4(23),ex3(:),G1H2(5),ngZd,m3h2x2(:,51),heltab2x4(:,:,51))
  call Hloop_Q_A(ntryL,G1H2(5),23,nMB,G2H2(47),n2h2(11))
  call Hloop_ZQ_A(ntryL,G1H4(24),ex3(:),G1H2(5),ngZd,m3h2x2(:,52),heltab2x4(:,:,52))
  call Hloop_Q_A(ntryL,G1H2(5),23,nMB,G2H2(48),n2h2(12))
  call Hloop_SQ_A(ntryL,G1H4(25),ex1(:),G1H2(5),ngPbt,m3h2x2(:,53),heltab2x4(:,:,53))
  call Hloop_Q_A(ntryL,G1H2(5),23,nMB,G2H2(49),n2h2(13))
call HGT_raise_alpha_OLR(G1H4(26),1,1,4)
call HGT_raise_alpha_invQ_OLR(G1H4(26),2,5,4)
  call Hloop_VA_Q(ntryL,G1H4(26),ex4(:),G1H2(5),m3h2x2(:,54),heltab2x4(:,:,54))
  call Hloop_SQ_A(ntryL,G1H4(29),ex1(:),G1H2(6),ngPbt,m3h2x2(:,55),heltab2x4(:,:,55))
  call Hloop_Q_A(ntryL,G1H2(6),23,nMB,G2H2(50),n2h2(14))
  call Hloop_SQ_A(ntryL,G1H4(30),ex1(:),G1H2(6),ngPbt,m3h2x2(:,56),heltab2x4(:,:,56))
  call Hloop_Q_A(ntryL,G1H2(6),23,nMB,G2H2(51),n2h2(15))
  call Hloop_WQ_A(ntryL,G1H4(31),ex1(:),G1H2(6),m3h2x2(:,57),heltab2x4(:,:,57))
  call Hloop_Q_A(ntryL,G1H2(6),23,nMB,G2H2(52),n2h2(16))
call HGT_raise_alpha_OLR(G1H4(32),1,1,4)
call HGT_raise_alpha_invQ_OLR(G1H4(32),2,5,4)
  call Hloop_VA_Q(ntryL,G1H4(32),ex4(:),G1H2(6),m3h2x2(:,58),heltab2x4(:,:,58))
  call Hloop_WQ_A(ntryL,G1H4(35),ex1(:),G1H2(7),m3h2x2(:,59),heltab2x4(:,:,59))
  call Hloop_Q_A(ntryL,G1H2(7),23,nMB,G2H2(53),n2h2(17))
  call Hloop_WQ_A(ntryL,G1H4(36),ex1(:),G1H2(7),m3h2x2(:,60),heltab2x4(:,:,60))
  call Hloop_Q_A(ntryL,G1H2(7),23,nMB,G2H2(54),n2h2(18))
  call Hloop_SA_Q(ntryL,G1H4(37),ex4(:),G1H2(7),ngH,m3h2x2(:,61),heltab2x4(:,:,61))
  call Hloop_A_Q(ntryL,G1H2(7),27,nMB,G2H2(55),n2h2(19))
call HGT_raise_alpha_OLR(G1H4(38),1,1,4)
call HGT_raise_alpha_invQ_OLR(G1H4(38),2,5,4)
  call Hloop_VQ_A(ntryL,G1H4(38),ex3(:),G1H2(7),m3h2x2(:,62),heltab2x4(:,:,62))
  call Hloop_SA_Q(ntryL,G1H4(41),ex4(:),G1H2(8),ngH,m3h2x2(:,63),heltab2x4(:,:,63))
  call Hloop_A_Q(ntryL,G1H2(8),27,nMB,G2H2(56),n2h2(20))
  call Hloop_SA_Q(ntryL,G1H4(42),ex4(:),G1H2(8),ngH,m3h2x2(:,64),heltab2x4(:,:,64))
  call Hloop_A_Q(ntryL,G1H2(8),27,nMB,G2H2(57),n2h2(21))
  call Hloop_SA_Q(ntryL,G1H4(43),ex4(:),G1H2(8),ngX,m3h2x2(:,65),heltab2x4(:,:,65))
  call Hloop_A_Q(ntryL,G1H2(8),27,nMB,G2H2(58),n2h2(22))
call HGT_raise_alpha_OLR(G1H4(44),1,1,4)
call HGT_raise_alpha_invQ_OLR(G1H4(44),2,5,4)
  call Hloop_VQ_A(ntryL,G1H4(44),ex3(:),G1H2(8),m3h2x2(:,66),heltab2x4(:,:,66))
  call Hloop_SA_Q(ntryL,G1H4(47),ex4(:),G1H2(9),ngX,m3h2x2(:,67),heltab2x4(:,:,67))
  call Hloop_A_Q(ntryL,G1H2(9),27,nMB,G2H2(59),n2h2(23))
  call Hloop_SA_Q(ntryL,G1H4(48),ex4(:),G1H2(9),ngX,m3h2x2(:,68),heltab2x4(:,:,68))
  call Hloop_A_Q(ntryL,G1H2(9),27,nMB,G2H2(60),n2h2(24))
  call Hloop_VA_Q(ntryL,G1H4(49),ex4(:),G1H2(9),m3h2x2(:,69),heltab2x4(:,:,69))
  call Hloop_A_Q(ntryL,G1H2(9),27,nMB,G2H2(61),n2h2(25))
call HGT_raise_alpha_OLR(G1H4(50),1,1,4)
call HGT_raise_alpha_invQ_OLR(G1H4(50),2,5,4)
  call Hloop_VQ_A(ntryL,G1H4(50),ex3(:),G1H2(9),m3h2x2(:,70),heltab2x4(:,:,70))
  call Hloop_VA_Q(ntryL,G1H4(53),ex4(:),G1H2(10),m3h2x2(:,71),heltab2x4(:,:,71))
  call Hloop_A_Q(ntryL,G1H2(10),27,nMB,G2H2(62),n2h2(26))
  call Hloop_VA_Q(ntryL,G1H4(54),ex4(:),G1H2(10),m3h2x2(:,72),heltab2x4(:,:,72))
  call Hloop_A_Q(ntryL,G1H2(10),27,nMB,G2H2(63),n2h2(27))
  call Hloop_ZA_Q(ntryL,G1H4(55),ex4(:),G1H2(10),ngZd,m3h2x2(:,73),heltab2x4(:,:,73))
  call Hloop_A_Q(ntryL,G1H2(10),27,nMB,G2H2(64),n2h2(28))
call HGT_raise_alpha_OLR(G1H4(56),1,1,4)
call HGT_raise_alpha_invQ_OLR(G1H4(56),2,5,4)
  call Hloop_VQ_A(ntryL,G1H4(56),ex3(:),G1H2(10),m3h2x2(:,74),heltab2x4(:,:,74))
  call Hloop_ZA_Q(ntryL,G1H4(59),ex4(:),G1H2(11),ngZd,m3h2x2(:,75),heltab2x4(:,:,75))
  call Hloop_A_Q(ntryL,G1H2(11),27,nMB,G2H2(65),n2h2(29))
  call Hloop_ZA_Q(ntryL,G1H4(60),ex4(:),G1H2(11),ngZd,m3h2x2(:,76),heltab2x4(:,:,76))
  call Hloop_A_Q(ntryL,G1H2(11),27,nMB,G2H2(66),n2h2(30))
  call Hloop_SQ_A(ntryL,G1H4(61),ex3(:),G1H2(11),ngH,m3h2x2(:,77),heltab2x4(:,:,77))
  call Hloop_Q_A(ntryL,G1H2(11),23,nMB,G2H2(67),n2h2(31))
call HGT_raise_alpha_OLR(G1H4(62),1,1,4)
call HGT_raise_alpha_invQ_OLR(G1H4(62),2,5,4)
  call Hloop_VA_Q(ntryL,G1H4(62),ex4(:),G1H2(11),m3h2x2(:,78),heltab2x4(:,:,78))
  call Hloop_SQ_A(ntryL,G1H4(65),ex3(:),G1H2(12),ngH,m3h2x2(:,79),heltab2x4(:,:,79))
  call Hloop_Q_A(ntryL,G1H2(12),23,nMB,G2H2(68),n2h2(32))
  call Hloop_SQ_A(ntryL,G1H4(66),ex3(:),G1H2(12),ngH,m3h2x2(:,80),heltab2x4(:,:,80))
  call Hloop_Q_A(ntryL,G1H2(12),23,nMB,G2H2(69),n2h2(33))
  call Hloop_SQ_A(ntryL,G1H4(67),ex3(:),G1H2(12),ngX,m3h2x2(:,81),heltab2x4(:,:,81))
  call Hloop_Q_A(ntryL,G1H2(12),23,nMB,G2H2(70),n2h2(34))
call HGT_raise_alpha_OLR(G1H4(68),1,1,4)
call HGT_raise_alpha_invQ_OLR(G1H4(68),2,5,4)
  call Hloop_VA_Q(ntryL,G1H4(68),ex4(:),G1H2(12),m3h2x2(:,82),heltab2x4(:,:,82))
  call Hloop_SQ_A(ntryL,G1H4(71),ex3(:),G1H2(13),ngX,m3h2x2(:,83),heltab2x4(:,:,83))
  call Hloop_Q_A(ntryL,G1H2(13),23,nMB,G2H2(71),n2h2(35))
  call Hloop_SQ_A(ntryL,G1H4(72),ex3(:),G1H2(13),ngX,m3h2x2(:,84),heltab2x4(:,:,84))
  call Hloop_Q_A(ntryL,G1H2(13),23,nMB,G2H2(72),n2h2(36))
  call Hloop_VQ_A(ntryL,G1H4(73),ex3(:),G1H2(13),m3h2x2(:,85),heltab2x4(:,:,85))
  call Hloop_Q_A(ntryL,G1H2(13),23,nMB,G2H2(73),n2h2(37))
call HGT_raise_alpha_OLR(G1H4(74),1,1,4)
call HGT_raise_alpha_invQ_OLR(G1H4(74),2,5,4)
  call Hloop_VA_Q(ntryL,G1H4(74),ex4(:),G1H2(13),m3h2x2(:,86),heltab2x4(:,:,86))
  call Hloop_VQ_A(ntryL,G1H4(77),ex3(:),G1H2(14),m3h2x2(:,87),heltab2x4(:,:,87))
  call Hloop_Q_A(ntryL,G1H2(14),23,nMB,G2H2(74),n2h2(38))
  call Hloop_VQ_A(ntryL,G1H4(78),ex3(:),G1H2(14),m3h2x2(:,88),heltab2x4(:,:,88))
  call Hloop_Q_A(ntryL,G1H2(14),23,nMB,G2H2(75),n2h2(39))
  call Hloop_ZQ_A(ntryL,G1H4(79),ex3(:),G1H2(14),ngZd,m3h2x2(:,89),heltab2x4(:,:,89))
  call Hloop_Q_A(ntryL,G1H2(14),23,nMB,G2H2(76),n2h2(40))
call HGT_raise_alpha_OLR(G1H4(80),1,1,4)
call HGT_raise_alpha_invQ_OLR(G1H4(80),2,5,4)
  call Hloop_VA_Q(ntryL,G1H4(80),ex4(:),G1H2(14),m3h2x2(:,90),heltab2x4(:,:,90))
  call Hloop_ZQ_A(ntryL,G1H4(83),ex3(:),G1H2(15),ngZd,m3h2x2(:,91),heltab2x4(:,:,91))
  call Hloop_Q_A(ntryL,G1H2(15),23,nMB,G2H2(77),n2h2(41))
  call Hloop_ZQ_A(ntryL,G1H4(84),ex3(:),G1H2(15),ngZd,m3h2x2(:,92),heltab2x4(:,:,92))
  call Hloop_Q_A(ntryL,G1H2(15),23,nMB,G2H2(78),n2h2(42))
  call Hloop_SA_Q(ntryL,G1H4(85),ex4(:),G1H2(15),ngH,m3h2x2(:,93),heltab2x4(:,:,93))
  call Hloop_A_Q(ntryL,G1H2(15),27,nMB,G2H2(79),n2h2(43))
call HGT_raise_alpha_OLR(G1H4(86),1,1,4)
call HGT_raise_alpha_invQ_OLR(G1H4(86),2,5,4)
  call Hloop_VQ_A(ntryL,G1H4(86),ex3(:),G1H2(15),m3h2x2(:,94),heltab2x4(:,:,94))
  call Hloop_SA_Q(ntryL,G1H4(89),ex4(:),G1H2(16),ngH,m3h2x2(:,95),heltab2x4(:,:,95))
  call Hloop_A_Q(ntryL,G1H2(16),27,nMB,G2H2(80),n2h2(44))
  call Hloop_SA_Q(ntryL,G1H4(90),ex4(:),G1H2(16),ngH,m3h2x2(:,96),heltab2x4(:,:,96))
  call Hloop_A_Q(ntryL,G1H2(16),27,nMB,G2H2(81),n2h2(45))
  call Hloop_SA_Q(ntryL,G1H4(91),ex4(:),G1H2(16),ngX,m3h2x2(:,97),heltab2x4(:,:,97))
  call Hloop_A_Q(ntryL,G1H2(16),27,nMB,G2H2(82),n2h2(46))
call HGT_raise_alpha_OLR(G1H4(92),1,1,4)
call HGT_raise_alpha_invQ_OLR(G1H4(92),2,5,4)
  call Hloop_VQ_A(ntryL,G1H4(92),ex3(:),G1H2(16),m3h2x2(:,98),heltab2x4(:,:,98))
  call Hloop_SA_Q(ntryL,G1H4(95),ex4(:),G1H2(17),ngX,m3h2x2(:,99),heltab2x4(:,:,99))
  call Hloop_A_Q(ntryL,G1H2(17),27,nMB,G2H2(83),n2h2(47))
  call Hloop_SA_Q(ntryL,G1H4(96),ex4(:),G1H2(17),ngX,m3h2x2(:,100),heltab2x4(:,:,100))
  call Hloop_A_Q(ntryL,G1H2(17),27,nMB,G2H2(84),n2h2(48))
  call Hloop_VA_Q(ntryL,G1H4(97),ex4(:),G1H2(17),m3h2x2(:,101),heltab2x4(:,:,101))
  call Hloop_A_Q(ntryL,G1H2(17),27,nMB,G2H2(85),n2h2(49))
call HGT_raise_alpha_OLR(G1H4(98),1,1,4)
call HGT_raise_alpha_invQ_OLR(G1H4(98),2,5,4)
  call Hloop_VQ_A(ntryL,G1H4(98),ex3(:),G1H2(17),m3h2x2(:,102),heltab2x4(:,:,102))
  call Hloop_VA_Q(ntryL,G1H4(101),ex4(:),G1H2(18),m3h2x2(:,103),heltab2x4(:,:,103))
  call Hloop_A_Q(ntryL,G1H2(18),27,nMB,G2H2(86),n2h2(50))
  call Hloop_VA_Q(ntryL,G1H4(102),ex4(:),G1H2(18),m3h2x2(:,104),heltab2x4(:,:,104))
  call Hloop_A_Q(ntryL,G1H2(18),27,nMB,G2H2(87),n2h2(51))
  call Hloop_ZA_Q(ntryL,G1H4(103),ex4(:),G1H2(18),ngZd,m3h2x2(:,105),heltab2x4(:,:,105))
  call Hloop_A_Q(ntryL,G1H2(18),27,nMB,G2H2(88),n2h2(52))
call HGT_raise_alpha_OLR(G1H4(104),1,1,4)
call HGT_raise_alpha_invQ_OLR(G1H4(104),2,5,4)
  call Hloop_VQ_A(ntryL,G1H4(104),ex3(:),G1H2(18),m3h2x2(:,106),heltab2x4(:,:,106))
  call Hloop_ZA_Q(ntryL,G1H4(107),ex4(:),G1H2(19),ngZd,m3h2x2(:,107),heltab2x4(:,:,107))
  call Hloop_A_Q(ntryL,G1H2(19),27,nMB,G2H2(89),n2h2(53))
  call Hloop_ZA_Q(ntryL,G1H4(108),ex4(:),G1H2(19),ngZd,m3h2x2(:,108),heltab2x4(:,:,108))
  call Hloop_A_Q(ntryL,G1H2(19),27,nMB,G2H2(90),n2h2(54))
  call Hloop_SQ_A(ntryL,G1H4(109),ex1(:),G1H2(19),ngPbt,m3h2x2(:,109),heltab2x4(:,:,109))
  call Hloop_Q_A(ntryL,G1H2(19),23,nMB,G2H2(91),n2h2(55))
call HGT_raise_alpha_OLR(G1H4(110),1,1,4)
call HGT_raise_alpha_invQ_OLR(G1H4(110),2,5,4)
  call Hloop_VA_Q(ntryL,G1H4(110),ex4(:),G1H2(19),m3h2x2(:,110),heltab2x4(:,:,110))
  call Hloop_SQ_A(ntryL,G1H4(113),ex1(:),G1H2(20),ngPbt,m3h2x2(:,111),heltab2x4(:,:,111))
  call Hloop_Q_A(ntryL,G1H2(20),23,nMB,G2H2(92),n2h2(56))
  call Hloop_SQ_A(ntryL,G1H4(114),ex1(:),G1H2(20),ngPbt,m3h2x2(:,112),heltab2x4(:,:,112))
  call Hloop_Q_A(ntryL,G1H2(20),23,nMB,G2H2(93),n2h2(57))
  call Hloop_WQ_A(ntryL,G1H4(115),ex1(:),G1H2(20),m3h2x2(:,113),heltab2x4(:,:,113))
  call Hloop_Q_A(ntryL,G1H2(20),23,nMB,G2H2(94),n2h2(58))
call HGT_raise_alpha_OLR(G1H4(116),1,1,4)
call HGT_raise_alpha_invQ_OLR(G1H4(116),2,5,4)
  call Hloop_VA_Q(ntryL,G1H4(116),ex4(:),G1H2(20),m3h2x2(:,114),heltab2x4(:,:,114))
  call Hloop_WQ_A(ntryL,G1H4(119),ex1(:),G1H2(21),m3h2x2(:,115),heltab2x4(:,:,115))
  call Hloop_Q_A(ntryL,G1H2(21),23,nMB,G2H2(95),n2h2(59))
  call Hloop_WQ_A(ntryL,G1H4(120),ex1(:),G1H2(21),m3h2x2(:,116),heltab2x4(:,:,116))
  call Hloop_Q_A(ntryL,G1H2(21),23,nMB,G2H2(96),n2h2(60))
  call Hloop_SA_Q(ntryL,G1H4(121),ex2(:),G1H2(21),ngPtb,m3h2x2(:,117),heltab2x4(:,:,117))
  call Hloop_A_Q(ntryL,G1H2(21),27,nMB,G2H2(97),n2h2(61))
call HGT_raise_alpha_OLR(G1H4(122),1,1,4)
call HGT_raise_alpha_invQ_OLR(G1H4(122),2,5,4)
  call Hloop_VQ_A(ntryL,G1H4(122),ex3(:),G1H2(21),m3h2x2(:,118),heltab2x4(:,:,118))
  call Hloop_SA_Q(ntryL,G1H4(125),ex2(:),G1H2(22),ngPtb,m3h2x2(:,119),heltab2x4(:,:,119))
  call Hloop_A_Q(ntryL,G1H2(22),27,nMB,G2H2(98),n2h2(62))
  call Hloop_SA_Q(ntryL,G1H4(126),ex2(:),G1H2(22),ngPtb,m3h2x2(:,120),heltab2x4(:,:,120))
  call Hloop_A_Q(ntryL,G1H2(22),27,nMB,G2H2(99),n2h2(63))
  call Hloop_WA_Q(ntryL,G1H4(127),ex2(:),G1H2(22),m3h2x2(:,121),heltab2x4(:,:,121))
  call Hloop_A_Q(ntryL,G1H2(22),27,nMB,G2H2(100),n2h2(64))
call HGT_raise_alpha_OLR(G1H4(128),1,1,4)
call HGT_raise_alpha_invQ_OLR(G1H4(128),2,5,4)
  call Hloop_VQ_A(ntryL,G1H4(128),ex3(:),G1H2(22),m3h2x2(:,122),heltab2x4(:,:,122))
  call Hloop_WA_Q(ntryL,G1H4(131),ex2(:),G1H2(23),m3h2x2(:,123),heltab2x4(:,:,123))
  call Hloop_A_Q(ntryL,G1H2(23),27,nMB,G2H2(101),n2h2(65))
  call Hloop_WA_Q(ntryL,G1H4(132),ex2(:),G1H2(23),m3h2x2(:,124),heltab2x4(:,:,124))
  call Hloop_A_Q(ntryL,G1H2(23),27,nMB,G2H2(102),n2h2(66))
  call Hloop_SQ_A(ntryL,G1H4(133),ex3(:),G1H2(23),ngPtb,m3h2x2(:,125),heltab2x4(:,:,125))
  call Hloop_Q_A(ntryL,G1H2(23),29,nMT,G2H2(103),n2h2(67))
call HGT_raise_alpha_OLR(G1H4(134),1,1,4)
call HGT_raise_alpha_invQ_OLR(G1H4(134),2,5,4)
  call Hloop_VA_Q(ntryL,G1H4(134),ex2(:),G1H2(23),m3h2x2(:,126),heltab2x4(:,:,126))
  call Hloop_SQ_A(ntryL,G1H4(137),ex3(:),G1H2(24),ngPtb,m3h2x2(:,127),heltab2x4(:,:,127))
  call Hloop_Q_A(ntryL,G1H2(24),29,nMT,G2H2(104),n2h2(68))
  call Hloop_SQ_A(ntryL,G1H4(138),ex3(:),G1H2(24),ngPtb,m3h2x2(:,128),heltab2x4(:,:,128))
  call Hloop_Q_A(ntryL,G1H2(24),29,nMT,G2H2(105),n2h2(69))
  call Hloop_WQ_A(ntryL,G1H4(139),ex3(:),G1H2(24),m3h2x2(:,129),heltab2x4(:,:,129))
  call Hloop_Q_A(ntryL,G1H2(24),29,nMT,G2H2(106),n2h2(70))
call HGT_raise_alpha_OLR(G1H4(140),1,1,4)
call HGT_raise_alpha_invQ_OLR(G1H4(140),2,5,4)
  call Hloop_VA_Q(ntryL,G1H4(140),ex2(:),G1H2(24),m3h2x2(:,130),heltab2x4(:,:,130))
  call Hloop_WQ_A(ntryL,G1H4(143),ex3(:),G1H2(25),m3h2x2(:,131),heltab2x4(:,:,131))
  call Hloop_Q_A(ntryL,G1H2(25),29,nMT,G2H2(107),n2h2(71))
  call Hloop_WQ_A(ntryL,G1H4(144),ex3(:),G1H2(25),m3h2x2(:,132),heltab2x4(:,:,132))
  call Hloop_Q_A(ntryL,G1H2(25),29,nMT,G2H2(108),n2h2(72))
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(46),[G2H2(40)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(48),[G2H2(42)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(52),[G2H2(49)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(54),[G2H2(51)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(64),[G2H2(58)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(66),[G2H2(60)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(76),[G2H2(70)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(78),[G2H2(72)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(88),[G2H2(82)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(90),[G2H2(84)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(94),[G2H2(91)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(96),[G2H2(93)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(100),[G2H2(97)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(102),[G2H2(99)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(106),[G2H2(103)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(108),[G2H2(105)])
  call Hotf_5pt_reduction(G2H2(1),RedSet_5(9),mass5set(:,7),  & 
G1H2(25),G1H2(26),G1H2(27),G1H2(28),G1H2(29),G1H2(30),2)
  call HG1shiftOLR(G1H2(26),8,2)
  call Hotf_5pt_reduction(G2H2(2),RedSet_5(9),mass5set(:,8),  & 
G1H2(31),G1H2(32),G1H2(33),G1H2(34),G1H2(35),G1H2(36),2)
  call HG1shiftOLR(G1H2(32),8,2)
  call Hotf_5pt_reduction(G2H2(3),RedSet_5(9),mass5set(:,9),  & 
G1H2(37),G1H2(38),G1H2(39),G1H2(40),G1H2(41),G1H2(42),2)
  call HG1shiftOLR(G1H2(38),8,2)
  call Hotf_5pt_reduction(G2H2(4),RedSet_5(9),mass5set(:,10),  & 
G1H2(43),G1H2(44),G1H2(45),G1H2(46),G1H2(47),G1H2(48),2)
  call HG1shiftOLR(G1H2(44),8,2)
  call Hotf_5pt_reduction(G2H2(5),RedSet_5(9),mass5set(:,11),  & 
G1H2(49),G1H2(50),G1H2(51),G1H2(52),G1H2(53),G1H2(54),2)
  call HG1shiftOLR(G1H2(50),8,2)
  call Hotf_5pt_reduction(G2H2(6),RedSet_5(9),mass5set(:,10),  & 
G1H2(55),G1H2(56),G1H2(57),G1H2(58),G1H2(59),G1H2(60),2)
  call HG1shiftOLR(G1H2(56),8,2)
  call Hotf_5pt_reduction(G2H2(7),RedSet_5(2),mass5set(:,9),  & 
G1H2(61),G1H2(62),G1H2(63),G1H2(64),G1H2(65),G1H2(66),2)
  call HG1shiftOLR(G1H2(62),8,2)
  call Hotf_5pt_reduction(G2H2(8),RedSet_5(2),mass5set(:,10),  & 
G1H2(67),G1H2(68),G1H2(69),G1H2(70),G1H2(71),G1H2(72),2)
  call HG1shiftOLR(G1H2(68),8,2)
  call Hotf_5pt_reduction(G2H2(9),RedSet_5(2),mass5set(:,7),  & 
G1H2(73),G1H2(74),G1H2(75),G1H2(76),G1H2(77),G1H2(78),2)
  call HG1shiftOLR(G1H2(74),8,2)
  call Hotf_5pt_reduction(G2H2(10),RedSet_5(2),mass5set(:,8),  & 
G1H2(79),G1H2(80),G1H2(81),G1H2(82),G1H2(83),G1H2(84),2)
  call HG1shiftOLR(G1H2(80),8,2)
  call Hotf_5pt_reduction(G2H2(11),RedSet_5(2),mass5set(:,11),  & 
G1H2(85),G1H2(86),G1H2(87),G1H2(88),G1H2(89),G1H2(90),2)
  call HG1shiftOLR(G1H2(86),8,2)
  call Hotf_5pt_reduction(G2H2(12),RedSet_5(2),mass5set(:,10),  & 
G1H2(91),G1H2(92),G1H2(93),G1H2(94),G1H2(95),G1H2(96),2)
  call HG1shiftOLR(G1H2(92),8,2)
  call Hotf_5pt_reduction(G2H2(13),RedSet_5(3),mass5set(:,12),  & 
G1H2(97),G1H2(98),G1H2(99),G1H2(100),G1H2(101),G1H2(102),2)
  call HG1shiftOLR(G1H2(98),4,2)
  call Hotf_5pt_reduction(G2H2(14),RedSet_5(3),mass5set(:,13),  & 
G1H2(103),G1H2(104),G1H2(105),G1H2(106),G1H2(107),G1H2(108),2)
  call HG1shiftOLR(G1H2(104),4,2)
  call Hotf_5pt_reduction(G2H2(15),RedSet_5(3),mass5set(:,13),  & 
G1H2(109),G1H2(110),G1H2(111),G1H2(112),G1H2(113),G1H2(114),2)
  call HG1shiftOLR(G1H2(110),4,2)
  call Hotf_5pt_reduction(G2H2(16),RedSet_5(4),mass5set(:,12),  & 
G1H2(115),G1H2(116),G1H2(117),G1H2(118),G1H2(119),G1H2(120),2)
  call HG1shiftOLR(G1H2(116),8,2)
  call Hotf_5pt_reduction(G2H2(17),RedSet_5(4),mass5set(:,13),  & 
G1H2(121),G1H2(122),G1H2(123),G1H2(124),G1H2(125),G1H2(126),2)
  call HG1shiftOLR(G1H2(122),8,2)
  call Hotf_5pt_reduction(G2H2(18),RedSet_5(4),mass5set(:,13),  & 
G1H2(127),G1H2(128),G1H2(129),G1H2(130),G1H2(131),G1H2(132),2)
  call HG1shiftOLR(G1H2(128),8,2)
  call Hotf_5pt_reduction(G2H2(19),RedSet_5(10),mass5set(:,14),  & 
G1H2(133),G1H2(134),G1H2(135),G1H2(136),G1H2(137),G1H2(138),2)
  call HG1shiftOLR(G1H2(134),4,2)
  call Hotf_5pt_reduction(G2H2(20),RedSet_5(10),mass5set(:,15),  & 
G1H2(139),G1H2(140),G1H2(141),G1H2(142),G1H2(143),G1H2(144),2)
  call HG1shiftOLR(G1H2(140),4,2)
  call Hotf_5pt_reduction(G2H2(21),RedSet_5(10),mass5set(:,14),  & 
G1H2(145),G1H2(146),G1H2(147),G1H2(148),G1H2(149),G1H2(150),2)
  call HG1shiftOLR(G1H2(146),4,2)
  call Hotf_5pt_reduction(G2H2(22),RedSet_5(11),mass5set(:,15),  & 
G1H2(151),G1H2(152),G1H2(153),G1H2(154),G1H2(155),G1H2(156),2)
  call HG1shiftOLR(G1H2(152),8,2)
  call Hotf_5pt_reduction(G2H2(23),RedSet_5(11),mass5set(:,14),  & 
G1H2(157),G1H2(158),G1H2(159),G1H2(160),G1H2(161),G1H2(162),2)
  call HG1shiftOLR(G1H2(158),8,2)
  call Hotf_5pt_reduction(G2H2(24),RedSet_5(11),mass5set(:,14),  & 
G1H2(163),G1H2(164),G1H2(165),G1H2(166),G1H2(167),G1H2(168),2)
  call HG1shiftOLR(G1H2(164),8,2)
  call Hotf_5pt_reduction(G2H2(25),RedSet_5(12),mass5set(:,16),  & 
G1H2(169),G1H2(170),G1H2(171),G1H2(172),G1H2(173),G1H2(174),2)
  call HG1shiftOLR(G1H2(170),2,2)
  call Hotf_5pt_reduction(G2H2(26),RedSet_5(12),mass5set(:,17),  & 
G1H2(175),G1H2(176),G1H2(177),G1H2(178),G1H2(179),G1H2(180),2)
  call HG1shiftOLR(G1H2(176),2,2)
  call Hotf_5pt_reduction(G2H2(27),RedSet_5(12),mass5set(:,18),  & 
G1H2(181),G1H2(182),G1H2(183),G1H2(184),G1H2(185),G1H2(186),2)
  call HG1shiftOLR(G1H2(182),2,2)
  call Hotf_5pt_reduction(G2H2(28),RedSet_5(12),mass5set(:,19),  & 
G1H2(187),G1H2(188),G1H2(189),G1H2(190),G1H2(191),G1H2(192),2)
  call HG1shiftOLR(G1H2(188),2,2)
  call Hotf_5pt_reduction(G2H2(29),RedSet_5(12),mass5set(:,20),  & 
G1H2(193),G1H2(194),G1H2(195),G1H2(196),G1H2(197),G1H2(198),2)
  call HG1shiftOLR(G1H2(194),2,2)
  call Hotf_5pt_reduction(G2H2(30),RedSet_5(12),mass5set(:,19),  & 
G1H2(199),G1H2(200),G1H2(201),G1H2(202),G1H2(203),G1H2(204),2)
  call HG1shiftOLR(G1H2(200),2,2)
  call Hotf_5pt_reduction(G2H2(31),RedSet_5(8),mass5set(:,16),  & 
G1H2(205),G1H2(206),G1H2(207),G1H2(208),G1H2(209),G1H2(210),2)
  call HG1shiftOLR(G1H2(206),2,2)
  call Hotf_5pt_reduction(G2H2(32),RedSet_5(8),mass5set(:,17),  & 
G1H2(211),G1H2(212),G1H2(213),G1H2(214),G1H2(215),G1H2(216),2)
  call HG1shiftOLR(G1H2(212),2,2)
  call Hotf_5pt_reduction(G2H2(33),RedSet_5(8),mass5set(:,18),  & 
G1H2(217),G1H2(218),G1H2(219),G1H2(220),G1H2(221),G1H2(222),2)
  call HG1shiftOLR(G1H2(218),2,2)
  call Hotf_5pt_reduction(G2H2(34),RedSet_5(8),mass5set(:,19),  & 
G1H2(223),G1H2(224),G1H2(225),G1H2(226),G1H2(227),G1H2(228),2)
  call HG1shiftOLR(G1H2(224),2,2)
  call Hotf_5pt_reduction(G2H2(35),RedSet_5(8),mass5set(:,20),  & 
G1H2(229),G1H2(230),G1H2(231),G1H2(232),G1H2(233),G1H2(234),2)
  call HG1shiftOLR(G1H2(230),2,2)
  call Hotf_5pt_reduction(G2H2(36),RedSet_5(8),mass5set(:,19),  & 
G1H2(235),G1H2(236),G1H2(237),G1H2(238),G1H2(239),G1H2(240),2)
  call HG1shiftOLR(G1H2(236),2,2)
  call Hcheck_last_QA_V(ntryL,l_switch,G2H2(37),ex4(:),G2tensor(1),m3h2x1(:,1),heltab2x2(:,:,1))
  call Hcheck_last_QA_V(ntryL,l_switch,G2H2(39),ex4(:),G2tensor(2),m3h2x1(:,2),heltab2x2(:,:,2))
  call Hcheck_last_QA_V(ntryL,l_switch,G2H2(46),ex4(:),G2tensor(3),m3h2x1(:,3),heltab2x2(:,:,3))
  call Hcheck_last_QA_V(ntryL,l_switch,G2H2(48),ex4(:),G2tensor(4),m3h2x1(:,4),heltab2x2(:,:,4))
  call Hcheck_last_QA_V(ntryL,l_switch,G2H2(43),ex4(:),G2tensor(5),m3h2x1(:,5),heltab2x2(:,:,5))
  call Hcheck_last_QA_V(ntryL,l_switch,G2H2(45),ex4(:),G2tensor(6),m3h2x1(:,6),heltab2x2(:,:,6))
  call Hcheck_last_QA_V(ntryL,l_switch,G2H2(52),ex4(:),G2tensor(7),m3h2x1(:,7),heltab2x2(:,:,7))
  call Hcheck_last_QA_V(ntryL,l_switch,G2H2(54),ex4(:),G2tensor(8),m3h2x1(:,8),heltab2x2(:,:,8))
  call Hcheck_last_AQ_V(ntryL,l_switch,G2H2(55),ex3(:),G2tensor(9),m3h2x1(:,9),heltab2x2(:,:,9))
  call Hcheck_last_AQ_V(ntryL,l_switch,G2H2(57),ex3(:),G2tensor(10),m3h2x1(:,10),heltab2x2(:,:,10))
  call Hcheck_last_AQ_V(ntryL,l_switch,G2H2(64),ex3(:),G2tensor(11),m3h2x1(:,11),heltab2x2(:,:,11))
  call Hcheck_last_AQ_V(ntryL,l_switch,G2H2(66),ex3(:),G2tensor(12),m3h2x1(:,12),heltab2x2(:,:,12))
  call Hcheck_last_AQ_V(ntryL,l_switch,G2H2(61),ex3(:),G2tensor(13),m3h2x1(:,13),heltab2x2(:,:,13))
  call Hcheck_last_AQ_V(ntryL,l_switch,G2H2(63),ex3(:),G2tensor(14),m3h2x1(:,14),heltab2x2(:,:,14))
  call Hcheck_last_QA_V(ntryL,l_switch,G2H2(67),ex4(:),G2tensor(15),m3h2x1(:,15),heltab2x2(:,:,15))
  call Hcheck_last_QA_V(ntryL,l_switch,G2H2(69),ex4(:),G2tensor(16),m3h2x1(:,16),heltab2x2(:,:,16))
  call Hcheck_last_QA_V(ntryL,l_switch,G2H2(76),ex4(:),G2tensor(17),m3h2x1(:,17),heltab2x2(:,:,17))
  call Hcheck_last_QA_V(ntryL,l_switch,G2H2(78),ex4(:),G2tensor(18),m3h2x1(:,18),heltab2x2(:,:,18))
  call Hcheck_last_QA_V(ntryL,l_switch,G2H2(73),ex4(:),G2tensor(19),m3h2x1(:,19),heltab2x2(:,:,19))
  call Hcheck_last_QA_V(ntryL,l_switch,G2H2(75),ex4(:),G2tensor(20),m3h2x1(:,20),heltab2x2(:,:,20))
  call Hcheck_last_AQ_V(ntryL,l_switch,G2H2(79),ex3(:),G2tensor(21),m3h2x1(:,21),heltab2x2(:,:,21))
  call Hcheck_last_AQ_V(ntryL,l_switch,G2H2(81),ex3(:),G2tensor(22),m3h2x1(:,22),heltab2x2(:,:,22))
  call Hcheck_last_AQ_V(ntryL,l_switch,G2H2(88),ex3(:),G2tensor(23),m3h2x1(:,23),heltab2x2(:,:,23))
  call Hcheck_last_AQ_V(ntryL,l_switch,G2H2(90),ex3(:),G2tensor(24),m3h2x1(:,24),heltab2x2(:,:,24))
  call Hcheck_last_AQ_V(ntryL,l_switch,G2H2(85),ex3(:),G2tensor(25),m3h2x1(:,25),heltab2x2(:,:,25))
  call Hcheck_last_AQ_V(ntryL,l_switch,G2H2(87),ex3(:),G2tensor(26),m3h2x1(:,26),heltab2x2(:,:,26))
  call Hcheck_last_QA_V(ntryL,l_switch,G2H2(94),ex4(:),G2tensor(27),m3h2x1(:,27),heltab2x2(:,:,27))
  call Hcheck_last_QA_V(ntryL,l_switch,G2H2(96),ex4(:),G2tensor(28),m3h2x1(:,28),heltab2x2(:,:,28))
  call Hcheck_last_AQ_V(ntryL,l_switch,G2H2(100),ex3(:),G2tensor(29),m3h2x1(:,29),heltab2x2(:,:,29))
  call Hcheck_last_AQ_V(ntryL,l_switch,G2H2(102),ex3(:),G2tensor(30),m3h2x1(:,30),heltab2x2(:,:,30))
  call Hcheck_last_QA_V(ntryL,l_switch,G2H2(106),ex2(:),G2tensor(31),m3h2x1(:,31),heltab2x2(:,:,31))
  call Hcheck_last_QA_V(ntryL,l_switch,G2H2(108),ex2(:),G2tensor(32),m3h2x1(:,32),heltab2x2(:,:,32))
  call Hloop_VA_Q(ntryL,G1H2(25),ex4(:),G1H1(1),m3h2x1(:,33),heltab2x2(:,:,33))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,nMB,G2tensor(33),n2h1(1))
  call Hloop_VA_Q(ntryL,G1H2(26),ex4(:),G1H1(1),m3h2x1(:,34),heltab2x2(:,:,34))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),8,nMB,G2tensor(34),n2h1(2))
  call Hloop_VA_Q(ntryL,G1H2(30),ex4(:),G1H1(1),m3h2x1(:,35),heltab2x2(:,:,35))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,nMB,G2tensor(35),n2h1(3))
  call Hloop_VA_Q(ntryL,G1H2(31),ex4(:),G1H1(1),m3h2x1(:,36),heltab2x2(:,:,36))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,nMB,G2tensor(36),n2h1(4))
  call Hloop_VA_Q(ntryL,G1H2(32),ex4(:),G1H1(1),m3h2x1(:,37),heltab2x2(:,:,37))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),8,nMB,G2tensor(37),n2h1(5))
  call Hloop_VA_Q(ntryL,G1H2(36),ex4(:),G1H1(1),m3h2x1(:,38),heltab2x2(:,:,38))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,nMB,G2tensor(38),n2h1(6))
  call Hloop_SA_Q(ntryL,G1H2(37),ex4(:),G1H1(1),ngH,m3h2x1(:,39),heltab2x2(:,:,39))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,nMB,G2tensor(39),n2h1(7))
  call Hloop_SA_Q(ntryL,G1H2(38),ex4(:),G1H1(1),ngH,m3h2x1(:,40),heltab2x2(:,:,40))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),8,nMB,G2tensor(40),n2h1(8))
  call Hloop_SA_Q(ntryL,G1H2(42),ex4(:),G1H1(1),ngH,m3h2x1(:,41),heltab2x2(:,:,41))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,nMB,G2tensor(41),n2h1(9))
  call Hloop_SA_Q(ntryL,G1H2(43),ex4(:),G1H1(1),ngX,m3h2x1(:,42),heltab2x2(:,:,42))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,nMB,G2tensor(42),n2h1(10))
  call Hloop_SA_Q(ntryL,G1H2(44),ex4(:),G1H1(1),ngX,m3h2x1(:,43),heltab2x2(:,:,43))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),8,nMB,G2tensor(43),n2h1(11))
  call Hloop_SA_Q(ntryL,G1H2(48),ex4(:),G1H1(1),ngX,m3h2x1(:,44),heltab2x2(:,:,44))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,nMB,G2tensor(44),n2h1(12))
  call Hloop_VA_Q(ntryL,G1H2(49),ex4(:),G1H1(1),m3h2x1(:,45),heltab2x2(:,:,45))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,nMB,G2tensor(45),n2h1(13))
  call Hloop_VA_Q(ntryL,G1H2(50),ex4(:),G1H1(1),m3h2x1(:,46),heltab2x2(:,:,46))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),8,nMB,G2tensor(46),n2h1(14))
  call Hloop_VA_Q(ntryL,G1H2(54),ex4(:),G1H1(1),m3h2x1(:,47),heltab2x2(:,:,47))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,nMB,G2tensor(47),n2h1(15))
  call Hloop_ZA_Q(ntryL,G1H2(55),ex4(:),G1H1(1),ngZd,m3h2x1(:,48),heltab2x2(:,:,48))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,nMB,G2tensor(48),n2h1(16))
  call Hloop_ZA_Q(ntryL,G1H2(56),ex4(:),G1H1(1),ngZd,m3h2x1(:,49),heltab2x2(:,:,49))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),8,nMB,G2tensor(49),n2h1(17))
  call Hloop_ZA_Q(ntryL,G1H2(60),ex4(:),G1H1(1),ngZd,m3h2x1(:,50),heltab2x2(:,:,50))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,nMB,G2tensor(50),n2h1(18))
  call Hloop_SA_Q(ntryL,G1H2(61),ex4(:),G1H1(1),ngH,m3h2x1(:,51),heltab2x2(:,:,51))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,nMB,G2tensor(51),n2h1(19))
  call Hloop_SA_Q(ntryL,G1H2(62),ex4(:),G1H1(1),ngH,m3h2x1(:,52),heltab2x2(:,:,52))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),8,nMB,G2tensor(52),n2h1(20))
  call Hloop_SA_Q(ntryL,G1H2(66),ex4(:),G1H1(1),ngH,m3h2x1(:,53),heltab2x2(:,:,53))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,nMB,G2tensor(53),n2h1(21))
  call Hloop_SA_Q(ntryL,G1H2(67),ex4(:),G1H1(1),ngX,m3h2x1(:,54),heltab2x2(:,:,54))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,nMB,G2tensor(54),n2h1(22))
  call Hloop_SA_Q(ntryL,G1H2(68),ex4(:),G1H1(1),ngX,m3h2x1(:,55),heltab2x2(:,:,55))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),8,nMB,G2tensor(55),n2h1(23))
  call Hloop_SA_Q(ntryL,G1H2(72),ex4(:),G1H1(1),ngX,m3h2x1(:,56),heltab2x2(:,:,56))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,nMB,G2tensor(56),n2h1(24))
  call Hloop_VA_Q(ntryL,G1H2(73),ex4(:),G1H1(1),m3h2x1(:,57),heltab2x2(:,:,57))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,nMB,G2tensor(57),n2h1(25))
  call Hloop_VA_Q(ntryL,G1H2(74),ex4(:),G1H1(1),m3h2x1(:,58),heltab2x2(:,:,58))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),8,nMB,G2tensor(58),n2h1(26))
  call Hloop_VA_Q(ntryL,G1H2(78),ex4(:),G1H1(1),m3h2x1(:,59),heltab2x2(:,:,59))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,nMB,G2tensor(59),n2h1(27))
  call Hloop_VA_Q(ntryL,G1H2(79),ex4(:),G1H1(1),m3h2x1(:,60),heltab2x2(:,:,60))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,nMB,G2tensor(60),n2h1(28))
  call Hloop_VA_Q(ntryL,G1H2(80),ex4(:),G1H1(1),m3h2x1(:,61),heltab2x2(:,:,61))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),8,nMB,G2tensor(61),n2h1(29))
  call Hloop_VA_Q(ntryL,G1H2(84),ex4(:),G1H1(1),m3h2x1(:,62),heltab2x2(:,:,62))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,nMB,G2tensor(62),n2h1(30))
  call Hloop_VA_Q(ntryL,G1H2(85),ex4(:),G1H1(1),m3h2x1(:,63),heltab2x2(:,:,63))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,nMB,G2tensor(63),n2h1(31))
  call Hloop_VA_Q(ntryL,G1H2(86),ex4(:),G1H1(1),m3h2x1(:,64),heltab2x2(:,:,64))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),8,nMB,G2tensor(64),n2h1(32))
  call Hloop_VA_Q(ntryL,G1H2(90),ex4(:),G1H1(1),m3h2x1(:,65),heltab2x2(:,:,65))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,nMB,G2tensor(65),n2h1(33))
  call Hloop_ZA_Q(ntryL,G1H2(91),ex4(:),G1H1(1),ngZd,m3h2x1(:,66),heltab2x2(:,:,66))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,nMB,G2tensor(66),n2h1(34))
  call Hloop_ZA_Q(ntryL,G1H2(92),ex4(:),G1H1(1),ngZd,m3h2x1(:,67),heltab2x2(:,:,67))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),8,nMB,G2tensor(67),n2h1(35))
  call Hloop_ZA_Q(ntryL,G1H2(96),ex4(:),G1H1(1),ngZd,m3h2x1(:,68),heltab2x2(:,:,68))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,nMB,G2tensor(68),n2h1(36))
  call Hloop_VQ_A(ntryL,G1H2(97),ex3(:),G1H1(1),m3h2x1(:,69),heltab2x2(:,:,69))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,nMB,G2tensor(69),n2h1(37))
  call Hloop_VQ_A(ntryL,G1H2(98),ex3(:),G1H1(1),m3h2x1(:,70),heltab2x2(:,:,70))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),4,nMB,G2tensor(70),n2h1(38))
  call Hloop_VQ_A(ntryL,G1H2(102),ex3(:),G1H1(1),m3h2x1(:,71),heltab2x2(:,:,71))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,nMB,G2tensor(71),n2h1(39))
  call Hloop_SQ_A(ntryL,G1H2(103),ex3(:),G1H1(1),ngPtb,m3h2x1(:,72),heltab2x2(:,:,72))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,nMT,G2tensor(72),n2h1(40))
  call Hloop_SQ_A(ntryL,G1H2(104),ex3(:),G1H1(1),ngPtb,m3h2x1(:,73),heltab2x2(:,:,73))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),4,nMT,G2tensor(73),n2h1(41))
  call Hloop_SQ_A(ntryL,G1H2(108),ex3(:),G1H1(1),ngPtb,m3h2x1(:,74),heltab2x2(:,:,74))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,nMT,G2tensor(74),n2h1(42))
  call Hloop_WQ_A(ntryL,G1H2(109),ex3(:),G1H1(1),m3h2x1(:,75),heltab2x2(:,:,75))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,nMT,G2tensor(75),n2h1(43))
  call Hloop_WQ_A(ntryL,G1H2(110),ex3(:),G1H1(1),m3h2x1(:,76),heltab2x2(:,:,76))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),4,nMT,G2tensor(76),n2h1(44))
  call Hloop_WQ_A(ntryL,G1H2(114),ex3(:),G1H1(1),m3h2x1(:,77),heltab2x2(:,:,77))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,nMT,G2tensor(77),n2h1(45))
  call Hloop_VA_Q(ntryL,G1H2(115),ex4(:),G1H1(1),m3h2x1(:,78),heltab2x2(:,:,78))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,nMB,G2tensor(78),n2h1(46))
  call Hloop_VA_Q(ntryL,G1H2(116),ex4(:),G1H1(1),m3h2x1(:,79),heltab2x2(:,:,79))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),8,nMB,G2tensor(79),n2h1(47))
  call Hloop_VA_Q(ntryL,G1H2(120),ex4(:),G1H1(1),m3h2x1(:,80),heltab2x2(:,:,80))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,nMB,G2tensor(80),n2h1(48))
  call Hloop_SA_Q(ntryL,G1H2(121),ex4(:),G1H1(1),ngPbt,m3h2x1(:,81),heltab2x2(:,:,81))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,nMT,G2tensor(81),n2h1(49))
  call Hloop_SA_Q(ntryL,G1H2(122),ex4(:),G1H1(1),ngPbt,m3h2x1(:,82),heltab2x2(:,:,82))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),8,nMT,G2tensor(82),n2h1(50))
  call Hloop_SA_Q(ntryL,G1H2(126),ex4(:),G1H1(1),ngPbt,m3h2x1(:,83),heltab2x2(:,:,83))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,nMT,G2tensor(83),n2h1(51))
  call Hloop_WA_Q(ntryL,G1H2(127),ex4(:),G1H1(1),m3h2x1(:,84),heltab2x2(:,:,84))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,nMT,G2tensor(84),n2h1(52))
  call Hloop_WA_Q(ntryL,G1H2(128),ex4(:),G1H1(1),m3h2x1(:,85),heltab2x2(:,:,85))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),8,nMT,G2tensor(85),n2h1(53))
  call Hloop_WA_Q(ntryL,G1H2(132),ex4(:),G1H1(1),m3h2x1(:,86),heltab2x2(:,:,86))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,nMT,G2tensor(86),n2h1(54))
  call Hloop_SQ_A(ntryL,G1H2(133),ex3(:),G1H1(1),ngPtb,m3h2x1(:,87),heltab2x2(:,:,87))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,nMT,G2tensor(87),n2h1(55))
  call Hloop_SQ_A(ntryL,G1H2(134),ex3(:),G1H1(1),ngPtb,m3h2x1(:,88),heltab2x2(:,:,88))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),4,nMT,G2tensor(88),n2h1(56))
  call Hloop_SQ_A(ntryL,G1H2(138),ex3(:),G1H1(1),ngPtb,m3h2x1(:,89),heltab2x2(:,:,89))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,nMT,G2tensor(89),n2h1(57))
  call Hloop_VQ_A(ntryL,G1H2(139),ex3(:),G1H1(1),m3h2x1(:,90),heltab2x2(:,:,90))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,nMB,G2tensor(90),n2h1(58))
  call Hloop_VQ_A(ntryL,G1H2(140),ex3(:),G1H1(1),m3h2x1(:,91),heltab2x2(:,:,91))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),4,nMB,G2tensor(91),n2h1(59))
  call Hloop_VQ_A(ntryL,G1H2(144),ex3(:),G1H1(1),m3h2x1(:,92),heltab2x2(:,:,92))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,nMB,G2tensor(92),n2h1(60))
  call Hloop_WQ_A(ntryL,G1H2(145),ex3(:),G1H1(1),m3h2x1(:,93),heltab2x2(:,:,93))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,nMT,G2tensor(93),n2h1(61))
  call Hloop_WQ_A(ntryL,G1H2(146),ex3(:),G1H1(1),m3h2x1(:,94),heltab2x2(:,:,94))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),4,nMT,G2tensor(94),n2h1(62))
  call Hloop_WQ_A(ntryL,G1H2(150),ex3(:),G1H1(1),m3h2x1(:,95),heltab2x2(:,:,95))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,nMT,G2tensor(95),n2h1(63))
  call Hloop_VA_Q(ntryL,G1H2(151),ex4(:),G1H1(1),m3h2x1(:,96),heltab2x2(:,:,96))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,nMB,G2tensor(96),n2h1(64))
  call Hloop_VA_Q(ntryL,G1H2(152),ex4(:),G1H1(1),m3h2x1(:,97),heltab2x2(:,:,97))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),8,nMB,G2tensor(97),n2h1(65))
  call Hloop_VA_Q(ntryL,G1H2(156),ex4(:),G1H1(1),m3h2x1(:,98),heltab2x2(:,:,98))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,nMB,G2tensor(98),n2h1(66))
  call Hloop_SA_Q(ntryL,G1H2(157),ex4(:),G1H1(1),ngPbt,m3h2x1(:,99),heltab2x2(:,:,99))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,nMT,G2tensor(99),n2h1(67))
  call Hloop_SA_Q(ntryL,G1H2(158),ex4(:),G1H1(1),ngPbt,m3h2x1(:,100),heltab2x2(:,:,100))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),8,nMT,G2tensor(100),n2h1(68))
  call Hloop_SA_Q(ntryL,G1H2(162),ex4(:),G1H1(1),ngPbt,m3h2x1(:,101),heltab2x2(:,:,101))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,nMT,G2tensor(101),n2h1(69))
  call Hloop_WA_Q(ntryL,G1H2(163),ex4(:),G1H1(1),m3h2x1(:,102),heltab2x2(:,:,102))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,nMT,G2tensor(102),n2h1(70))
  call Hloop_WA_Q(ntryL,G1H2(164),ex4(:),G1H1(1),m3h2x1(:,103),heltab2x2(:,:,103))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),8,nMT,G2tensor(103),n2h1(71))
  call Hloop_WA_Q(ntryL,G1H2(168),ex4(:),G1H1(1),m3h2x1(:,104),heltab2x2(:,:,104))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,nMT,G2tensor(104),n2h1(72))
  call Hloop_VA_Q(ntryL,G1H2(169),ex2(:),G1H1(1),m3h2x1(:,105),heltab2x2(:,:,105))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,nMT,G2tensor(105),n2h1(73))
  call Hloop_VA_Q(ntryL,G1H2(170),ex2(:),G1H1(1),m3h2x1(:,106),heltab2x2(:,:,106))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),2,nMT,G2tensor(106),n2h1(74))
  call Hloop_VA_Q(ntryL,G1H2(174),ex2(:),G1H1(1),m3h2x1(:,107),heltab2x2(:,:,107))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,nMT,G2tensor(107),n2h1(75))
  call Hloop_VA_Q(ntryL,G1H2(175),ex2(:),G1H1(1),m3h2x1(:,108),heltab2x2(:,:,108))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,nMT,G2tensor(108),n2h1(76))
  call Hloop_VA_Q(ntryL,G1H2(176),ex2(:),G1H1(1),m3h2x1(:,109),heltab2x2(:,:,109))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),2,nMT,G2tensor(109),n2h1(77))
  call Hloop_VA_Q(ntryL,G1H2(180),ex2(:),G1H1(1),m3h2x1(:,110),heltab2x2(:,:,110))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,nMT,G2tensor(110),n2h1(78))
  call Hloop_SA_Q(ntryL,G1H2(181),ex2(:),G1H1(1),ngH,m3h2x1(:,111),heltab2x2(:,:,111))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,nMT,G2tensor(111),n2h1(79))
  call Hloop_SA_Q(ntryL,G1H2(182),ex2(:),G1H1(1),ngH,m3h2x1(:,112),heltab2x2(:,:,112))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),2,nMT,G2tensor(112),n2h1(80))
  call Hloop_SA_Q(ntryL,G1H2(186),ex2(:),G1H1(1),ngH,m3h2x1(:,113),heltab2x2(:,:,113))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,nMT,G2tensor(113),n2h1(81))
  call Hloop_SA_Q(ntryL,G1H2(187),ex2(:),G1H1(1),ngX,m3h2x1(:,114),heltab2x2(:,:,114))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,nMT,G2tensor(114),n2h1(82))
  call Hloop_SA_Q(ntryL,G1H2(188),ex2(:),G1H1(1),ngX,m3h2x1(:,115),heltab2x2(:,:,115))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),2,nMT,G2tensor(115),n2h1(83))
  call Hloop_SA_Q(ntryL,G1H2(192),ex2(:),G1H1(1),ngX,m3h2x1(:,116),heltab2x2(:,:,116))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,nMT,G2tensor(116),n2h1(84))
  call Hloop_VA_Q(ntryL,G1H2(193),ex2(:),G1H1(1),m3h2x1(:,117),heltab2x2(:,:,117))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,nMT,G2tensor(117),n2h1(85))
  call Hloop_VA_Q(ntryL,G1H2(194),ex2(:),G1H1(1),m3h2x1(:,118),heltab2x2(:,:,118))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),2,nMT,G2tensor(118),n2h1(86))
  call Hloop_VA_Q(ntryL,G1H2(198),ex2(:),G1H1(1),m3h2x1(:,119),heltab2x2(:,:,119))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,nMT,G2tensor(119),n2h1(87))
  call Hloop_ZA_Q(ntryL,G1H2(199),ex2(:),G1H1(1),ngZu,m3h2x1(:,120),heltab2x2(:,:,120))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,nMT,G2tensor(120),n2h1(88))
  call Hloop_ZA_Q(ntryL,G1H2(200),ex2(:),G1H1(1),ngZu,m3h2x1(:,121),heltab2x2(:,:,121))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),2,nMT,G2tensor(121),n2h1(89))
  call Hloop_ZA_Q(ntryL,G1H2(204),ex2(:),G1H1(1),ngZu,m3h2x1(:,122),heltab2x2(:,:,122))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,nMT,G2tensor(122),n2h1(90))
  call Hloop_VA_Q(ntryL,G1H2(205),ex2(:),G1H1(1),m3h2x1(:,123),heltab2x2(:,:,123))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,nMT,G2tensor(123),n2h1(91))
  call Hloop_VA_Q(ntryL,G1H2(206),ex2(:),G1H1(1),m3h2x1(:,124),heltab2x2(:,:,124))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),2,nMT,G2tensor(124),n2h1(92))
  call Hloop_VA_Q(ntryL,G1H2(210),ex2(:),G1H1(1),m3h2x1(:,125),heltab2x2(:,:,125))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,nMT,G2tensor(125),n2h1(93))
  call Hloop_VA_Q(ntryL,G1H2(211),ex2(:),G1H1(1),m3h2x1(:,126),heltab2x2(:,:,126))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,nMT,G2tensor(126),n2h1(94))
  call Hloop_VA_Q(ntryL,G1H2(212),ex2(:),G1H1(1),m3h2x1(:,127),heltab2x2(:,:,127))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),2,nMT,G2tensor(127),n2h1(95))
  call Hloop_VA_Q(ntryL,G1H2(216),ex2(:),G1H1(1),m3h2x1(:,128),heltab2x2(:,:,128))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,nMT,G2tensor(128),n2h1(96))
  call Hloop_SA_Q(ntryL,G1H2(217),ex2(:),G1H1(1),ngH,m3h2x1(:,129),heltab2x2(:,:,129))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,nMT,G2tensor(129),n2h1(97))
  call Hloop_SA_Q(ntryL,G1H2(218),ex2(:),G1H1(1),ngH,m3h2x1(:,130),heltab2x2(:,:,130))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),2,nMT,G2tensor(130),n2h1(98))
  call Hloop_SA_Q(ntryL,G1H2(222),ex2(:),G1H1(1),ngH,m3h2x1(:,131),heltab2x2(:,:,131))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,nMT,G2tensor(131),n2h1(99))
  call Hloop_SA_Q(ntryL,G1H2(223),ex2(:),G1H1(1),ngX,m3h2x1(:,132),heltab2x2(:,:,132))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,nMT,G2tensor(132),n2h1(100))
  call Hloop_SA_Q(ntryL,G1H2(224),ex2(:),G1H1(1),ngX,m3h2x1(:,133),heltab2x2(:,:,133))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),2,nMT,G2tensor(133),n2h1(101))
  call Hloop_SA_Q(ntryL,G1H2(228),ex2(:),G1H1(1),ngX,m3h2x1(:,134),heltab2x2(:,:,134))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,nMT,G2tensor(134),n2h1(102))
  call Hloop_VA_Q(ntryL,G1H2(229),ex2(:),G1H1(1),m3h2x1(:,135),heltab2x2(:,:,135))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,nMT,G2tensor(135),n2h1(103))
  call Hloop_VA_Q(ntryL,G1H2(230),ex2(:),G1H1(1),m3h2x1(:,136),heltab2x2(:,:,136))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),2,nMT,G2tensor(136),n2h1(104))
  call Hloop_VA_Q(ntryL,G1H2(234),ex2(:),G1H1(1),m3h2x1(:,137),heltab2x2(:,:,137))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,nMT,G2tensor(137),n2h1(105))
  call Hloop_ZA_Q(ntryL,G1H2(235),ex2(:),G1H1(1),ngZu,m3h2x1(:,138),heltab2x2(:,:,138))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,nMT,G2tensor(138),n2h1(106))
  call Hloop_ZA_Q(ntryL,G1H2(236),ex2(:),G1H1(1),ngZu,m3h2x1(:,139),heltab2x2(:,:,139))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),2,nMT,G2tensor(139),n2h1(107))
  call Hloop_ZA_Q(ntryL,G1H2(240),ex2(:),G1H1(1),ngZu,m3h2x1(:,140),heltab2x2(:,:,140))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,nMT,G2tensor(140),n2h1(108))
  call ol_merge_tensors(G2tensor(48),[G2tensor(42)])
  call ol_merge_tensors(G2tensor(66),[G2tensor(54)])
  call ol_merge_tensors(G2tensor(75),[G2tensor(72)])
  call ol_merge_tensors(G2tensor(84),[G2tensor(81)])
  call ol_merge_tensors(G2tensor(93),[G2tensor(87)])
  call ol_merge_tensors(G2tensor(102),[G2tensor(99)])
  call ol_merge_tensors(G2tensor(120),[G2tensor(114)])
  call ol_merge_tensors(G2tensor(138),[G2tensor(132)])
  call Hotf_5pt_reduction_last(G2tensor(1),RedSet_5(1),mass5set(:,1),  & 
G1tensor(1),G1tensor(2),G1tensor(3),G1tensor(4),G1tensor(5),G1tensor(6))
  call G_TensorShift(G1tensor(2),8)
  call Hotf_5pt_reduction_last(G2tensor(3),RedSet_5(1),mass5set(:,2),  & 
G1tensor(7),G1tensor(8),G1tensor(9),G1tensor(10),G1tensor(11),G1tensor(12))
  call G_TensorShift(G1tensor(8),8)
  call Hotf_5pt_reduction_last(G2tensor(5),RedSet_5(1),mass5set(:,3),  & 
G1tensor(13),G1tensor(14),G1tensor(15),G1tensor(16),G1tensor(17),G1tensor(18))
  call G_TensorShift(G1tensor(14),8)
  call Hotf_5pt_reduction_last(G2tensor(7),RedSet_5(2),mass5set(:,4),  & 
G1tensor(19),G1tensor(20),G1tensor(21),G1tensor(22),G1tensor(23),G1tensor(24))
  call G_TensorShift(G1tensor(20),8)
  call Hotf_5pt_reduction_last(G2tensor(9),RedSet_5(3),mass5set(:,1),  & 
G1tensor(25),G1tensor(26),G1tensor(27),G1tensor(28),G1tensor(29),G1tensor(30))
  call G_TensorShift(G1tensor(26),4)
  call Hotf_5pt_reduction_last(G2tensor(11),RedSet_5(3),mass5set(:,2),  & 
G1tensor(31),G1tensor(32),G1tensor(33),G1tensor(34),G1tensor(35),G1tensor(36))
  call G_TensorShift(G1tensor(32),4)
  call Hotf_5pt_reduction_last(G2tensor(13),RedSet_5(3),mass5set(:,3),  & 
G1tensor(37),G1tensor(38),G1tensor(39),G1tensor(40),G1tensor(41),G1tensor(42))
  call G_TensorShift(G1tensor(38),4)
  call Hotf_5pt_reduction_last(G2tensor(15),RedSet_5(4),mass5set(:,1),  & 
G1tensor(43),G1tensor(44),G1tensor(45),G1tensor(46),G1tensor(47),G1tensor(48))
  call G_TensorShift(G1tensor(44),8)
  call Hotf_5pt_reduction_last(G2tensor(17),RedSet_5(4),mass5set(:,2),  & 
G1tensor(49),G1tensor(50),G1tensor(51),G1tensor(52),G1tensor(53),G1tensor(54))
  call G_TensorShift(G1tensor(50),8)
  call Hotf_5pt_reduction_last(G2tensor(19),RedSet_5(4),mass5set(:,3),  & 
G1tensor(55),G1tensor(56),G1tensor(57),G1tensor(58),G1tensor(59),G1tensor(60))
  call G_TensorShift(G1tensor(56),8)
  call Hotf_5pt_reduction_last(G2tensor(21),RedSet_5(5),mass5set(:,1),  & 
G1tensor(61),G1tensor(62),G1tensor(63),G1tensor(64),G1tensor(65),G1tensor(66))
  call G_TensorShift(G1tensor(62),4)
  call Hotf_5pt_reduction_last(G2tensor(23),RedSet_5(5),mass5set(:,2),  & 
G1tensor(67),G1tensor(68),G1tensor(69),G1tensor(70),G1tensor(71),G1tensor(72))
  call G_TensorShift(G1tensor(68),4)
  call Hotf_5pt_reduction_last(G2tensor(25),RedSet_5(5),mass5set(:,3),  & 
G1tensor(73),G1tensor(74),G1tensor(75),G1tensor(76),G1tensor(77),G1tensor(78))
  call G_TensorShift(G1tensor(74),4)
  call Hotf_5pt_reduction_last(G2tensor(27),RedSet_5(6),mass5set(:,5),  & 
G1tensor(79),G1tensor(80),G1tensor(81),G1tensor(82),G1tensor(83),G1tensor(84))
  call G_TensorShift(G1tensor(80),8)
  call Hotf_5pt_reduction_last(G2tensor(29),RedSet_5(7),mass5set(:,5),  & 
G1tensor(85),G1tensor(86),G1tensor(87),G1tensor(88),G1tensor(89),G1tensor(90))
  call G_TensorShift(G1tensor(86),4)
  call Hotf_5pt_reduction_last(G2tensor(31),RedSet_5(8),mass5set(:,6),  & 
G1tensor(91),G1tensor(92),G1tensor(93),G1tensor(94),G1tensor(95),G1tensor(96))
  call G_TensorShift(G1tensor(92),2)
  call Hotf_5pt_reduction_last(G2tensor(33),RedSet_5(9),mass5set(:,7),  & 
G1tensor(97),G1tensor(98),G1tensor(99),G1tensor(100),G1tensor(101),G1tensor(102))
  call G_TensorShift(G1tensor(98),8)
  call Hotf_5pt_reduction_last(G2tensor(36),RedSet_5(9),mass5set(:,8),  & 
G1tensor(103),G1tensor(104),G1tensor(105),G1tensor(106),G1tensor(107),G1tensor(108))
  call G_TensorShift(G1tensor(104),8)
  call Hotf_5pt_reduction_last(G2tensor(39),RedSet_5(9),mass5set(:,9),  & 
G1tensor(109),G1tensor(110),G1tensor(111),G1tensor(112),G1tensor(113),G1tensor(114))
  call G_TensorShift(G1tensor(110),8)
  call Hotf_5pt_reduction_last(G2tensor(48),RedSet_5(9),mass5set(:,10),  & 
G1tensor(115),G1tensor(116),G1tensor(117),G1tensor(118),G1tensor(119),G1tensor(120))
  call G_TensorShift(G1tensor(116),8)
  call Hotf_5pt_reduction_last(G2tensor(45),RedSet_5(9),mass5set(:,11),  & 
G1tensor(121),G1tensor(122),G1tensor(123),G1tensor(124),G1tensor(125),G1tensor(126))
  call G_TensorShift(G1tensor(122),8)
  call Hotf_5pt_reduction_last(G2tensor(51),RedSet_5(2),mass5set(:,9),  & 
G1tensor(127),G1tensor(128),G1tensor(129),G1tensor(130),G1tensor(131),G1tensor(132))
  call G_TensorShift(G1tensor(128),8)
  call Hotf_5pt_reduction_last(G2tensor(66),RedSet_5(2),mass5set(:,10),  & 
G1tensor(133),G1tensor(134),G1tensor(135),G1tensor(136),G1tensor(137),G1tensor(138))
  call G_TensorShift(G1tensor(134),8)
  call Hotf_5pt_reduction_last(G2tensor(57),RedSet_5(2),mass5set(:,7),  & 
G1tensor(139),G1tensor(140),G1tensor(141),G1tensor(142),G1tensor(143),G1tensor(144))
  call G_TensorShift(G1tensor(140),8)
  call Hotf_5pt_reduction_last(G2tensor(60),RedSet_5(2),mass5set(:,8),  & 
G1tensor(145),G1tensor(146),G1tensor(147),G1tensor(148),G1tensor(149),G1tensor(150))
  call G_TensorShift(G1tensor(146),8)
  call Hotf_5pt_reduction_last(G2tensor(63),RedSet_5(2),mass5set(:,11),  & 
G1tensor(151),G1tensor(152),G1tensor(153),G1tensor(154),G1tensor(155),G1tensor(156))
  call G_TensorShift(G1tensor(152),8)
  call Hotf_5pt_reduction_last(G2tensor(69),RedSet_5(3),mass5set(:,12),  & 
G1tensor(157),G1tensor(158),G1tensor(159),G1tensor(160),G1tensor(161),G1tensor(162))
  call G_TensorShift(G1tensor(158),4)
  call Hotf_5pt_reduction_last(G2tensor(75),RedSet_5(3),mass5set(:,13),  & 
G1tensor(163),G1tensor(164),G1tensor(165),G1tensor(166),G1tensor(167),G1tensor(168))
  call G_TensorShift(G1tensor(164),4)
  call Hotf_5pt_reduction_last(G2tensor(78),RedSet_5(4),mass5set(:,12),  & 
G1tensor(169),G1tensor(170),G1tensor(171),G1tensor(172),G1tensor(173),G1tensor(174))
  call G_TensorShift(G1tensor(170),8)
  call Hotf_5pt_reduction_last(G2tensor(84),RedSet_5(4),mass5set(:,13),  & 
G1tensor(175),G1tensor(176),G1tensor(177),G1tensor(178),G1tensor(179),G1tensor(180))
  call G_TensorShift(G1tensor(176),8)
  call Hotf_5pt_reduction_last(G2tensor(93),RedSet_5(10),mass5set(:,14),  & 
G1tensor(181),G1tensor(182),G1tensor(183),G1tensor(184),G1tensor(185),G1tensor(186))
  call G_TensorShift(G1tensor(182),4)
  call Hotf_5pt_reduction_last(G2tensor(90),RedSet_5(10),mass5set(:,15),  & 
G1tensor(187),G1tensor(188),G1tensor(189),G1tensor(190),G1tensor(191),G1tensor(192))
  call G_TensorShift(G1tensor(188),4)
  call Hotf_5pt_reduction_last(G2tensor(96),RedSet_5(11),mass5set(:,15),  & 
G1tensor(193),G1tensor(194),G1tensor(195),G1tensor(196),G1tensor(197),G1tensor(198))
  call G_TensorShift(G1tensor(194),8)
  call Hotf_5pt_reduction_last(G2tensor(102),RedSet_5(11),mass5set(:,14),  & 
G1tensor(199),G1tensor(200),G1tensor(201),G1tensor(202),G1tensor(203),G1tensor(204))
  call G_TensorShift(G1tensor(200),8)
  call Hotf_5pt_reduction_last(G2tensor(105),RedSet_5(12),mass5set(:,16),  & 
G1tensor(205),G1tensor(206),G1tensor(207),G1tensor(208),G1tensor(209),G1tensor(210))
  call G_TensorShift(G1tensor(206),2)
  call Hotf_5pt_reduction_last(G2tensor(108),RedSet_5(12),mass5set(:,17),  & 
G1tensor(211),G1tensor(212),G1tensor(213),G1tensor(214),G1tensor(215),G1tensor(216))
  call G_TensorShift(G1tensor(212),2)
  call Hotf_5pt_reduction_last(G2tensor(111),RedSet_5(12),mass5set(:,18),  & 
G1tensor(217),G1tensor(218),G1tensor(219),G1tensor(220),G1tensor(221),G1tensor(222))
  call G_TensorShift(G1tensor(218),2)
  call Hotf_5pt_reduction_last(G2tensor(120),RedSet_5(12),mass5set(:,19),  & 
G1tensor(223),G1tensor(224),G1tensor(225),G1tensor(226),G1tensor(227),G1tensor(228))
  call G_TensorShift(G1tensor(224),2)
  call Hotf_5pt_reduction_last(G2tensor(117),RedSet_5(12),mass5set(:,20),  & 
G1tensor(229),G1tensor(230),G1tensor(231),G1tensor(232),G1tensor(233),G1tensor(234))
  call G_TensorShift(G1tensor(230),2)
  call Hotf_5pt_reduction_last(G2tensor(123),RedSet_5(8),mass5set(:,16),  & 
G1tensor(235),G1tensor(236),G1tensor(237),G1tensor(238),G1tensor(239),G1tensor(240))
  call G_TensorShift(G1tensor(236),2)
  call Hotf_5pt_reduction_last(G2tensor(126),RedSet_5(8),mass5set(:,17),  & 
G1tensor(241),G1tensor(242),G1tensor(243),G1tensor(244),G1tensor(245),G1tensor(246))
  call G_TensorShift(G1tensor(242),2)
  call Hotf_5pt_reduction_last(G2tensor(129),RedSet_5(8),mass5set(:,18),  & 
G1tensor(247),G1tensor(248),G1tensor(249),G1tensor(250),G1tensor(251),G1tensor(252))
  call G_TensorShift(G1tensor(248),2)
  call Hotf_5pt_reduction_last(G2tensor(138),RedSet_5(8),mass5set(:,19),  & 
G1tensor(253),G1tensor(254),G1tensor(255),G1tensor(256),G1tensor(257),G1tensor(258))
  call G_TensorShift(G1tensor(254),2)
  call Hotf_5pt_reduction_last(G2tensor(135),RedSet_5(8),mass5set(:,20),  & 
G1tensor(259),G1tensor(260),G1tensor(261),G1tensor(262),G1tensor(263),G1tensor(264))
  call G_TensorShift(G1tensor(260),2)
  call ol_merge_tensors(T1sum(1),[G1tensor(1)])
  call ol_merge_tensors(T1sum(2),[G1tensor(7)])
  call ol_merge_tensors(T1sum(3),[G1tensor(13)])
  call ol_merge_tensors(T1sum(4),[G1tensor(19)])
  call ol_merge_tensors(T1sum(5),[G1tensor(25)])
  call ol_merge_tensors(T1sum(6),[G1tensor(31)])
  call ol_merge_tensors(T1sum(7),[G1tensor(37)])
  call ol_merge_tensors(T1sum(8),[G1tensor(43)])
  call ol_merge_tensors(T1sum(9),[G1tensor(49)])
  call ol_merge_tensors(T1sum(10),[G1tensor(55)])
  call ol_merge_tensors(T1sum(11),[G1tensor(61)])
  call ol_merge_tensors(T1sum(12),[G1tensor(67)])
  call ol_merge_tensors(T1sum(13),[G1tensor(73)])
  call ol_merge_tensors(T1sum(14),[G1tensor(79)])
  call ol_merge_tensors(T1sum(15),[G1tensor(85)])
  call ol_merge_tensors(T1sum(16),[G1tensor(91)])
  call ol_merge_tensors(T1sum(17),[G1tensor(97)])
  call ol_merge_tensors(T1sum(18),[G1tensor(103)])
  call ol_merge_tensors(T1sum(19),[G1tensor(109)])
  call ol_merge_tensors(T1sum(20),[G1tensor(115)])
  call ol_merge_tensors(T1sum(21),[G1tensor(121)])
  call ol_merge_tensors(T1sum(22),[G1tensor(127)])
  call ol_merge_tensors(T1sum(23),[G1tensor(133)])
  call ol_merge_tensors(T1sum(24),[G1tensor(139)])
  call ol_merge_tensors(T1sum(25),[G1tensor(145)])
  call ol_merge_tensors(T1sum(26),[G1tensor(151)])
  call ol_merge_tensors(T1sum(27),[G1tensor(157)])
  call ol_merge_tensors(T1sum(28),[G1tensor(163)])
  call ol_merge_tensors(T1sum(29),[G1tensor(169)])
  call ol_merge_tensors(T1sum(30),[G1tensor(175)])
  call ol_merge_tensors(T1sum(31),[G1tensor(181)])
  call ol_merge_tensors(T1sum(32),[G1tensor(187)])
  call ol_merge_tensors(T1sum(33),[G1tensor(193)])
  call ol_merge_tensors(T1sum(34),[G1tensor(199)])
  call ol_merge_tensors(T1sum(35),[G1tensor(205)])
  call ol_merge_tensors(T1sum(36),[G1tensor(211)])
  call ol_merge_tensors(T1sum(37),[G1tensor(217)])
  call ol_merge_tensors(T1sum(38),[G1tensor(223)])
  call ol_merge_tensors(T1sum(39),[G1tensor(229)])
  call ol_merge_tensors(T1sum(40),[G1tensor(235)])
  call ol_merge_tensors(T1sum(41),[G1tensor(241)])
  call ol_merge_tensors(T1sum(42),[G1tensor(247)])
  call ol_merge_tensors(T1sum(43),[G1tensor(253)])
  call ol_merge_tensors(T1sum(44),[G1tensor(259)])
  Gcoeff(:)%j = (c(52)*M(7,:)%j) * den(4)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(81),h0tab(:,81),[16,3,8,4],[nMB,nMB,0,nMB],4,1,wf4(:,3))
  call Hloop_QV_A(ntryL,G0H32(1),ex5(:),G0H16(1),m3h2x16(:,81),heltab2x32(:,:,81))
  call Hloop_Q_A(ntryL,G0H16(1),16,nMB,G1H16(6),n2h16(53))
  Gcoeff(:)%j = (c(52)*M(7,:)%j) * den(7)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(82),h0tab(:,82),[16,3,8,4],[nMB,nMB,0,nMB],4,1,wf4(:,6))
  call Hloop_QV_A(ntryL,G0H32(1),ex5(:),G0H16(1),m3h2x16(:,82),heltab2x32(:,:,82))
  call Hloop_Q_A(ntryL,G0H16(1),16,nMB,G1H16(5),n2h16(54))
  Gcoeff(:)%j = (-(c(49)*M(3,:)%j)+c(48)*M(7,:)%j) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(83),h0tab(:,83),[16,3,8,4],[nMB,nMB,nMH,nMB],4,1,wf4(:,1))
  call Hloop_QV_A(ntryL,G0H32(1),ex5(:),G0H16(1),m3h2x16(:,83),heltab2x32(:,:,83))
  call Hloop_Q_A(ntryL,G0H16(1),16,nMB,G1H16(12),n2h16(55))
  Gcoeff(:)%j = (c(49)*M(3,:)%j-c(48)*M(7,:)%j) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(84),h0tab(:,84),[16,3,8,4],[nMB,nMB,nMZ,nMB],4,1,wf4(:,1))
  call Hloop_QV_A(ntryL,G0H32(1),ex5(:),G0H16(1),m3h2x16(:,84),heltab2x32(:,:,84))
  call Hloop_Q_A(ntryL,G0H16(1),16,nMB,G1H16(20),n2h16(56))
  Gcoeff(:)%j = (c(45)*M(3,:)%j-c(44)*M(7,:)%j) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(85),h0tab(:,85),[16,3,8,4],[nMT,nMT,nMW,nMT],4,1,wf4(:,1))
  call Hloop_QV_A(ntryL,G0H32(1),ex5(:),G0H16(1),m3h2x16(:,85),heltab2x32(:,:,85))
  call Hloop_Q_A(ntryL,G0H16(1),16,nMT,G1H16(19),n2h16(57))
  Gcoeff(:)%j = (c(9)*M(7,:)%j) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(86),h0tab(:,86),[16,3,8,4],[nMB,nMB,0,nMB],4,1,wf4(:,1))
  call Hloop_QV_A(ntryL,G0H32(1),ex5(:),G0H16(1),m3h2x16(:,86),heltab2x32(:,:,86))
  call Hloop_Q_A(ntryL,G0H16(1),16,nMB,G1H16(32),n2h16(58))
  Gcoeff(:)%j = (-(c(14)*M(7,:)%j)) * den(7)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(87),h0tab(:,87),[16,3,8,4],[nMB,nMB,0,nMB],4,1,wf4(:,7))
  call Hloop_QV_A(ntryL,G0H32(1),ex5(:),G0H16(1),m3h2x16(:,87),heltab2x32(:,:,87))
  call Hloop_Q_A(ntryL,G0H16(1),16,nMB,G1H16(41),n2h16(59))
  Gcoeff(:)%j = (c(8)*M(3,:)%j-c(7)*M(7,:)%j) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(88),h0tab(:,88),[16,3,8,4],[nMB,nMB,0,nMB],4,1,wf4(:,1))
  call Hloop_QV_A(ntryL,G0H32(1),ex5(:),G0H16(1),m3h2x16(:,88),heltab2x32(:,:,88))
  call Hloop_Q_A(ntryL,G0H16(1),16,nMB,G1H16(46),n2h16(60))
  Gcoeff(:)%j = (c(15)*M(3,:)%j-c(14)*M(7,:)%j) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(89),h0tab(:,89),[16,3,8,4],[nMB,nMB,nMZ,nMB],4,1,wf4(:,1))
  call Hloop_QV_A(ntryL,G0H32(1),ex5(:),G0H16(1),m3h2x16(:,89),heltab2x32(:,:,89))
  call Hloop_Q_A(ntryL,G0H16(1),16,nMB,G1H16(64),n2h16(61))
  Gcoeff(:)%j = (c(40)*M(3,:)%j-c(39)*M(7,:)%j) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(90),h0tab(:,90),[16,3,8,4],[nMT,nMT,nMW,nMT],4,1,wf4(:,1))
  call Hloop_QV_A(ntryL,G0H32(1),ex5(:),G0H16(1),m3h2x16(:,90),heltab2x32(:,:,90))
  call Hloop_Q_A(ntryL,G0H16(1),16,nMT,G1H16(63),n2h16(62))
  Gcoeff(:)%j = (c(30)*M(2,:)%j-c(27)*M(4,:)%j+c(26)*M(8,:)%j) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(91),h0tab(:,91),[16,3,8,4],[nMB,nMB,0,nMB],4,1,wf4(:,1))
  call Hloop_QV_A(ntryL,G0H32(1),ex5(:),G0H16(1),m3h2x16(:,91),heltab2x32(:,:,91))
  call Hloop_Q_A(ntryL,G0H16(1),16,nMB,G1H16(75),n2h16(63))
  Gcoeff(:)%j = (c(35)*M(4,:)%j+c(30)*(M(2,:)%j-M(8,:)%j)) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(92),h0tab(:,92),[16,3,8,4],[0,0,nMB,0],4,1,wf4(:,1))
  call Hloop_UV_W(ntryL,G0H32(1),0,ex5(:),16,G1H16(74),m3h2x16(:,92),heltab2x32(:,:,92))
  Gcoeff(:)%j = (c(52)*M(7,:)%j) * den(4)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(93),h0tab(:,93),[16,3,4,8],[nMB,nMB,0,nMB],4,1,wf4(:,3))
  call Hloop_AV_Q(ntryL,G0H32(1),ex5(:),G0H16(1),m3h2x16(:,93),heltab2x32(:,:,93))
  call Hloop_A_Q(ntryL,G0H16(1),16,nMB,G1H16(1),n2h16(64))
  Gcoeff(:)%j = (c(52)*M(7,:)%j) * den(7)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(94),h0tab(:,94),[16,3,4,8],[nMB,nMB,0,nMB],4,1,wf4(:,6))
  call Hloop_AV_Q(ntryL,G0H32(1),ex5(:),G0H16(1),m3h2x16(:,94),heltab2x32(:,:,94))
  call Hloop_A_Q(ntryL,G0H16(1),16,nMB,G1H16(2),n2h16(65))
  Gcoeff(:)%j = (-(c(49)*M(5,:)%j)+c(48)*M(7,:)%j) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(95),h0tab(:,95),[16,3,4,8],[nMB,nMB,nMH,nMB],4,1,wf4(:,1))
  call Hloop_AV_Q(ntryL,G0H32(1),ex5(:),G0H16(1),m3h2x16(:,95),heltab2x32(:,:,95))
  call Hloop_A_Q(ntryL,G0H16(1),16,nMB,G1H16(3),n2h16(66))
  Gcoeff(:)%j = (c(49)*M(5,:)%j-c(48)*M(7,:)%j) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(96),h0tab(:,96),[16,3,4,8],[nMB,nMB,nMZ,nMB],4,1,wf4(:,1))
  call Hloop_AV_Q(ntryL,G0H32(1),ex5(:),G0H16(1),m3h2x16(:,96),heltab2x32(:,:,96))
  call Hloop_A_Q(ntryL,G0H16(1),16,nMB,G1H16(4),n2h16(67))
  Gcoeff(:)%j = (c(45)*M(5,:)%j-c(44)*M(7,:)%j) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(97),h0tab(:,97),[16,3,4,8],[nMT,nMT,nMW,nMT],4,1,wf4(:,1))
  call Hloop_AV_Q(ntryL,G0H32(1),ex5(:),G0H16(1),m3h2x16(:,97),heltab2x32(:,:,97))
  call Hloop_A_Q(ntryL,G0H16(1),16,nMT,G1H16(9),n2h16(68))
  Gcoeff(:)%j = (c(9)*M(7,:)%j) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(98),h0tab(:,98),[16,3,4,8],[nMB,nMB,0,nMB],4,1,wf4(:,1))
  call Hloop_AV_Q(ntryL,G0H32(1),ex5(:),G0H16(1),m3h2x16(:,98),heltab2x32(:,:,98))
  call Hloop_A_Q(ntryL,G0H16(1),16,nMB,G1H16(7),n2h16(69))
  Gcoeff(:)%j = (-(c(14)*M(7,:)%j)) * den(7)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(99),h0tab(:,99),[16,3,4,8],[nMB,nMB,0,nMB],4,1,wf4(:,7))
  call Hloop_AV_Q(ntryL,G0H32(1),ex5(:),G0H16(1),m3h2x16(:,99),heltab2x32(:,:,99))
  call Hloop_A_Q(ntryL,G0H16(1),16,nMB,G1H16(8),n2h16(70))
  Gcoeff(:)%j = (c(8)*M(5,:)%j-c(7)*M(7,:)%j) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(100),h0tab(:,100),[16,3,4,8],[nMB,nMB,0,nMB],4,1,wf4(:,1))
  call Hloop_AV_Q(ntryL,G0H32(1),ex5(:),G0H16(1),m3h2x16(:,100),heltab2x32(:,:,100))
  call Hloop_A_Q(ntryL,G0H16(1),16,nMB,G1H16(10),n2h16(71))
  Gcoeff(:)%j = (c(15)*M(5,:)%j-c(14)*M(7,:)%j) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(101),h0tab(:,101),[16,3,4,8],[nMB,nMB,nMZ,nMB],4,1,wf4(:,1))
  call Hloop_AV_Q(ntryL,G0H32(1),ex5(:),G0H16(1),m3h2x16(:,101),heltab2x32(:,:,101))
  call Hloop_A_Q(ntryL,G0H16(1),16,nMB,G1H16(11),n2h16(72))
  Gcoeff(:)%j = (c(40)*M(5,:)%j-c(39)*M(7,:)%j) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(102),h0tab(:,102),[16,3,4,8],[nMT,nMT,nMW,nMT],4,1,wf4(:,1))
  call Hloop_AV_Q(ntryL,G0H32(1),ex5(:),G0H16(1),m3h2x16(:,102),heltab2x32(:,:,102))
  call Hloop_A_Q(ntryL,G0H16(1),16,nMT,G1H16(14),n2h16(73))
  Gcoeff(:)%j = (c(30)*M(2,:)%j-c(27)*M(6,:)%j+c(26)*M(8,:)%j) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(103),h0tab(:,103),[16,3,4,8],[nMB,nMB,0,nMB],4,1,wf4(:,1))
  call Hloop_AV_Q(ntryL,G0H32(1),ex5(:),G0H16(1),m3h2x16(:,103),heltab2x32(:,:,103))
  call Hloop_A_Q(ntryL,G0H16(1),16,nMB,G1H16(13),n2h16(74))
  Gcoeff(:)%j = (c(35)*M(6,:)%j+c(30)*(M(2,:)%j-M(8,:)%j)) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(104),h0tab(:,104),[16,3,4,8],[0,0,nMB,0],4,1,wf4(:,1))
  call Hloop_UV_W(ntryL,G0H32(1),0,ex5(:),16,G1H16(15),m3h2x16(:,104),heltab2x32(:,:,104))
  Gcoeff(:)%j = (c(51)*M(7,:)%j) * den(4)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(105),h0tab(:,105),[16,4,3,8],[0,nMB,nMB,0],4,1,wf4(:,3))
  call Hloop_UV_W(ntryL,G0H32(1),0,ex5(:),16,G1H16(16),m3h2x16(:,105),heltab2x32(:,:,105))
  Gcoeff(:)%j = (c(51)*M(7,:)%j) * den(7)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(106),h0tab(:,106),[16,4,3,8],[0,nMB,nMB,0],4,1,wf4(:,6))
  call Hloop_UV_W(ntryL,G0H32(1),0,ex5(:),16,G1H16(17),m3h2x16(:,106),heltab2x32(:,:,106))
  Gcoeff(:)%j = (-(c(20)*M(2,:)%j)) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(107),h0tab(:,107),[16,4,3,8],[nMB,0,0,nMB],4,1,wf4(:,1))
  call Hloop_AV_Q(ntryL,G0H32(1),ex5(:),G0H16(1),m3h2x16(:,107),heltab2x32(:,:,107))
  call Hloop_A_Q(ntryL,G0H16(1),16,nMB,G1H16(18),n2h16(75))
  Gcoeff(:)%j = (c(3)*M(7,:)%j) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(108),h0tab(:,108),[16,4,3,8],[0,nMB,nMB,0],4,1,wf4(:,1))
  call Hloop_UV_W(ntryL,G0H32(1),0,ex5(:),16,G1H16(23),m3h2x16(:,108),heltab2x32(:,:,108))
  Gcoeff(:)%j = (-(c(6)*M(7,:)%j)) * den(7)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(109),h0tab(:,109),[16,4,3,8],[0,nMB,nMB,0],4,1,wf4(:,7))
  call Hloop_UV_W(ntryL,G0H32(1),0,ex5(:),16,G1H16(21),m3h2x16(:,109),heltab2x32(:,:,109))
  Gcoeff(:)%j = (c(20)*M(2,:)%j) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(110),h0tab(:,110),[16,4,3,8],[0,nMB,nMB,0],4,1,wf4(:,1))
  call Hloop_UV_W(ntryL,G0H32(1),0,ex5(:),16,G1H16(22),m3h2x16(:,110),heltab2x32(:,:,110))
  Gcoeff(:)%j = (c(44)*M(5,:)%j) * den(15)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(111),h0tab(:,111),[16,1,8,6],[nMT,0,nMB,nMT],4,1,wf4(:,11))
  call Hloop_AV_Q(ntryL,G0H32(1),ex5(:),G0H16(1),m3h2x16(:,111),heltab2x32(:,:,111))
  call Hloop_A_Q(ntryL,G0H16(1),16,nMT,G1H16(24),n2h16(76))
  Gcoeff(:)%j = (c(39)*M(5,:)%j) * den(15)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(112),h0tab(:,112),[16,1,8,6],[nMT,0,nMB,nMT],4,1,wf4(:,13))
  call Hloop_AV_Q(ntryL,G0H32(1),ex5(:),G0H16(1),m3h2x16(:,112),heltab2x32(:,:,112))
  call Hloop_A_Q(ntryL,G0H16(1),16,nMT,G1H16(25),n2h16(77))
  Gcoeff(:)%j = (c(44)*M(5,:)%j) * den(15)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(113),h0tab(:,113),[16,6,1,8],[nMB,nMT,0,nMB],4,1,wf4(:,11))
  call Hloop_AV_Q(ntryL,G0H32(1),ex5(:),G0H16(1),m3h2x16(:,113),heltab2x32(:,:,113))
  call Hloop_A_Q(ntryL,G0H16(1),16,nMB,G1H16(26),n2h16(78))
  Gcoeff(:)%j = (c(39)*M(5,:)%j) * den(15)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(114),h0tab(:,114),[16,6,1,8],[nMB,nMT,0,nMB],4,1,wf4(:,13))
  call Hloop_AV_Q(ntryL,G0H32(1),ex5(:),G0H16(1),m3h2x16(:,114),heltab2x32(:,:,114))
  call Hloop_A_Q(ntryL,G0H16(1),16,nMB,G1H16(27),n2h16(79))
  Gcoeff(:)%j = (c(43)*M(5,:)%j) * den(15)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(115),h0tab(:,115),[16,1,6,8],[0,nMT,nMB,0],4,1,wf4(:,11))
  call Hloop_UV_W(ntryL,G0H32(1),0,ex5(:),16,G1H16(28),m3h2x16(:,115),heltab2x32(:,:,115))
  Gcoeff(:)%j = (c(38)*M(5,:)%j) * den(15)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(116),h0tab(:,116),[16,1,6,8],[0,nMT,nMB,0],4,1,wf4(:,13))
  call Hloop_UV_W(ntryL,G0H32(1),0,ex5(:),16,G1H16(29),m3h2x16(:,116),heltab2x32(:,:,116))
  Gcoeff(:)%j = (c(44)*M(3,:)%j) * den(18)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(117),h0tab(:,117),[16,2,4,9],[nMT,0,nMB,nMT],4,1,wf4(:,14))
  call Hloop_QV_A(ntryL,G0H32(1),ex5(:),G0H16(1),m3h2x16(:,117),heltab2x32(:,:,117))
  call Hloop_Q_A(ntryL,G0H16(1),16,nMT,G1H16(30),n2h16(80))
  Gcoeff(:)%j = (c(39)*M(3,:)%j) * den(18)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(118),h0tab(:,118),[16,2,4,9],[nMT,0,nMB,nMT],4,1,wf4(:,17))
  call Hloop_QV_A(ntryL,G0H32(1),ex5(:),G0H16(1),m3h2x16(:,118),heltab2x32(:,:,118))
  call Hloop_Q_A(ntryL,G0H16(1),16,nMT,G1H16(31),n2h16(81))
  Gcoeff(:)%j = (c(44)*M(3,:)%j) * den(18)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(119),h0tab(:,119),[16,4,2,9],[nMB,0,nMT,nMB],4,1,wf4(:,14))
  call Hloop_AV_Q(ntryL,G0H32(1),ex5(:),G0H16(1),m3h2x16(:,119),heltab2x32(:,:,119))
  call Hloop_A_Q(ntryL,G0H16(1),16,nMB,G1H16(34),n2h16(82))
  Gcoeff(:)%j = (c(39)*M(3,:)%j) * den(18)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(120),h0tab(:,120),[16,4,2,9],[nMB,0,nMT,nMB],4,1,wf4(:,17))
  call Hloop_AV_Q(ntryL,G0H32(1),ex5(:),G0H16(1),m3h2x16(:,120),heltab2x32(:,:,120))
  call Hloop_A_Q(ntryL,G0H16(1),16,nMB,G1H16(33),n2h16(83))
  Gcoeff(:)%j = (-(c(43)*M(3,:)%j)) * den(18)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(121),h0tab(:,121),[16,2,9,4],[0,nMT,nMB,0],4,1,wf4(:,14))
  call Hloop_UV_W(ntryL,G0H32(1),0,ex5(:),16,G1H16(35),m3h2x16(:,121),heltab2x32(:,:,121))
  Gcoeff(:)%j = (-(c(38)*M(3,:)%j)) * den(18)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(122),h0tab(:,122),[16,2,9,4],[0,nMT,nMB,0],4,1,wf4(:,17))
  call Hloop_UV_W(ntryL,G0H32(1),0,ex5(:),16,G1H16(36),m3h2x16(:,122),heltab2x32(:,:,122))
  Gcoeff(:)%j = (c(52)*M(1,:)%j) * den(22)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(123),h0tab(:,123),[16,1,2,12],[nMT,0,nMT,nMT],4,1,wf4(:,18))
  call Hloop_AV_Q(ntryL,G0H32(1),ex5(:),G0H16(1),m3h2x16(:,123),heltab2x32(:,:,123))
  call Hloop_A_Q(ntryL,G0H16(1),16,nMT,G1H16(37),n2h16(84))
  Gcoeff(:)%j = (c(52)*M(1,:)%j) * den(24)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(124),h0tab(:,124),[16,1,2,12],[nMT,0,nMT,nMT],4,1,wf4(:,19))
  call Hloop_AV_Q(ntryL,G0H32(1),ex5(:),G0H16(1),m3h2x16(:,124),heltab2x32(:,:,124))
  call Hloop_A_Q(ntryL,G0H16(1),16,nMT,G1H16(38),n2h16(85))
  Gcoeff(:)%j = (c(56)*M(1,:)%j-c(57)*M(5,:)%j) * den(2)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(125),h0tab(:,125),[16,1,2,12],[nMT,nMH,nMT,nMT],4,1,wf4(:,2))
  call Hloop_AV_Q(ntryL,G0H32(1),ex5(:),G0H16(1),m3h2x16(:,125),heltab2x32(:,:,125))
  call Hloop_A_Q(ntryL,G0H16(1),16,nMT,G1H16(39),n2h16(86))
  Gcoeff(:)%j = (-(c(56)*M(1,:)%j)+c(57)*M(5,:)%j) * den(2)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(126),h0tab(:,126),[16,1,2,12],[nMT,nMZ,nMT,nMT],4,1,wf4(:,2))
  call Hloop_AV_Q(ntryL,G0H32(1),ex5(:),G0H16(1),m3h2x16(:,126),heltab2x32(:,:,126))
  call Hloop_A_Q(ntryL,G0H16(1),16,nMT,G1H16(40),n2h16(87))
  Gcoeff(:)%j = (-(c(44)*M(1,:)%j)+c(45)*M(5,:)%j) * den(2)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(127),h0tab(:,127),[16,1,2,12],[nMB,nMW,nMB,nMB],4,1,wf4(:,2))
  call Hloop_AV_Q(ntryL,G0H32(1),ex5(:),G0H16(1),m3h2x16(:,127),heltab2x32(:,:,127))
  call Hloop_A_Q(ntryL,G0H16(1),16,nMB,G1H16(43),n2h16(88))
  Gcoeff(:)%j = (c(9)*M(1,:)%j) * den(2)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(128),h0tab(:,128),[16,1,2,12],[nMT,0,nMT,nMT],4,1,wf4(:,2))
  call Hloop_AV_Q(ntryL,G0H32(1),ex5(:),G0H16(1),m3h2x16(:,128),heltab2x32(:,:,128))
  call Hloop_A_Q(ntryL,G0H16(1),16,nMT,G1H16(42),n2h16(89))
  Gcoeff(:)%j = (-(c(14)*M(1,:)%j)) * den(24)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(129),h0tab(:,129),[16,1,2,12],[nMT,0,nMT,nMT],4,1,wf4(:,20))
  call Hloop_AV_Q(ntryL,G0H32(1),ex5(:),G0H16(1),m3h2x16(:,129),heltab2x32(:,:,129))
  call Hloop_A_Q(ntryL,G0H16(1),16,nMT,G1H16(44),n2h16(90))
  Gcoeff(:)%j = (-(c(12)*M(1,:)%j)+c(13)*M(5,:)%j) * den(2)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(130),h0tab(:,130),[16,1,2,12],[nMT,0,nMT,nMT],4,1,wf4(:,2))
  call Hloop_AV_Q(ntryL,G0H32(1),ex5(:),G0H16(1),m3h2x16(:,130),heltab2x32(:,:,130))
  call Hloop_A_Q(ntryL,G0H16(1),16,nMT,G1H16(45),n2h16(91))
  Gcoeff(:)%j = (-(c(14)*M(1,:)%j)+c(15)*M(5,:)%j) * den(2)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(131),h0tab(:,131),[16,1,2,12],[nMT,nMZ,nMT,nMT],4,1,wf4(:,2))
  call Hloop_AV_Q(ntryL,G0H32(1),ex5(:),G0H16(1),m3h2x16(:,131),heltab2x32(:,:,131))
  call Hloop_A_Q(ntryL,G0H16(1),16,nMT,G1H16(48),n2h16(92))
  Gcoeff(:)%j = (-(c(39)*M(1,:)%j)+c(40)*M(5,:)%j) * den(2)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(132),h0tab(:,132),[16,1,2,12],[nMB,nMW,nMB,nMB],4,1,wf4(:,2))
  call Hloop_AV_Q(ntryL,G0H32(1),ex5(:),G0H16(1),m3h2x16(:,132),heltab2x32(:,:,132))
  call Hloop_A_Q(ntryL,G0H16(1),16,nMB,G1H16(47),n2h16(93))
  Gcoeff(:)%j = (c(26)*M(2,:)%j-c(27)*M(6,:)%j+c(30)*M(8,:)%j) * den(2)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(133),h0tab(:,133),[16,1,2,12],[nMT,0,nMT,nMT],4,1,wf4(:,2))
  call Hloop_AV_Q(ntryL,G0H32(1),ex5(:),G0H16(1),m3h2x16(:,133),heltab2x32(:,:,133))
  call Hloop_A_Q(ntryL,G0H16(1),16,nMT,G1H16(49),n2h16(94))
  Gcoeff(:)%j = (c(35)*M(6,:)%j+c(30)*(-M(2,:)%j+M(8,:)%j)) * den(2)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(134),h0tab(:,134),[16,1,2,12],[0,nMT,0,0],4,1,wf4(:,2))
  call Hloop_UV_W(ntryL,G0H32(1),0,ex5(:),16,G1H16(50),m3h2x16(:,134),heltab2x32(:,:,134))
  Gcoeff(:)%j = (c(52)*M(1,:)%j) * den(22)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(135),h0tab(:,135),[16,2,1,12],[nMT,0,nMT,nMT],4,1,wf4(:,18))
  call Hloop_QV_A(ntryL,G0H32(1),ex5(:),G0H16(1),m3h2x16(:,135),heltab2x32(:,:,135))
  call Hloop_Q_A(ntryL,G0H16(1),16,nMT,G1H16(51),n2h16(95))
  Gcoeff(:)%j = (c(52)*M(1,:)%j) * den(24)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(136),h0tab(:,136),[16,2,1,12],[nMT,0,nMT,nMT],4,1,wf4(:,19))
  call Hloop_QV_A(ntryL,G0H32(1),ex5(:),G0H16(1),m3h2x16(:,136),heltab2x32(:,:,136))
  call Hloop_Q_A(ntryL,G0H16(1),16,nMT,G1H16(52),n2h16(96))
  Gcoeff(:)%j = (c(56)*M(1,:)%j-c(57)*M(3,:)%j) * den(2)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(137),h0tab(:,137),[16,2,1,12],[nMT,nMH,nMT,nMT],4,1,wf4(:,2))
  call Hloop_QV_A(ntryL,G0H32(1),ex5(:),G0H16(1),m3h2x16(:,137),heltab2x32(:,:,137))
  call Hloop_Q_A(ntryL,G0H16(1),16,nMT,G1H16(53),n2h16(97))
  Gcoeff(:)%j = (-(c(56)*M(1,:)%j)+c(57)*M(3,:)%j) * den(2)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(138),h0tab(:,138),[16,2,1,12],[nMT,nMZ,nMT,nMT],4,1,wf4(:,2))
  call Hloop_QV_A(ntryL,G0H32(1),ex5(:),G0H16(1),m3h2x16(:,138),heltab2x32(:,:,138))
  call Hloop_Q_A(ntryL,G0H16(1),16,nMT,G1H16(54),n2h16(98))
  Gcoeff(:)%j = (-(c(44)*M(1,:)%j)+c(45)*M(3,:)%j) * den(2)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(139),h0tab(:,139),[16,2,1,12],[nMB,nMW,nMB,nMB],4,1,wf4(:,2))
  call Hloop_QV_A(ntryL,G0H32(1),ex5(:),G0H16(1),m3h2x16(:,139),heltab2x32(:,:,139))
  call Hloop_Q_A(ntryL,G0H16(1),16,nMB,G1H16(55),n2h16(99))
  Gcoeff(:)%j = (c(9)*M(1,:)%j) * den(2)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(140),h0tab(:,140),[16,2,1,12],[nMT,0,nMT,nMT],4,1,wf4(:,2))
  call Hloop_QV_A(ntryL,G0H32(1),ex5(:),G0H16(1),m3h2x16(:,140),heltab2x32(:,:,140))
  call Hloop_Q_A(ntryL,G0H16(1),16,nMT,G1H16(56),n2h16(100))
  Gcoeff(:)%j = (-(c(14)*M(1,:)%j)) * den(24)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(141),h0tab(:,141),[16,2,1,12],[nMT,0,nMT,nMT],4,1,wf4(:,20))
  call Hloop_QV_A(ntryL,G0H32(1),ex5(:),G0H16(1),m3h2x16(:,141),heltab2x32(:,:,141))
  call Hloop_Q_A(ntryL,G0H16(1),16,nMT,G1H16(57),n2h16(101))
  Gcoeff(:)%j = (-(c(12)*M(1,:)%j)+c(13)*M(3,:)%j) * den(2)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(142),h0tab(:,142),[16,2,1,12],[nMT,0,nMT,nMT],4,1,wf4(:,2))
  call Hloop_QV_A(ntryL,G0H32(1),ex5(:),G0H16(1),m3h2x16(:,142),heltab2x32(:,:,142))
  call Hloop_Q_A(ntryL,G0H16(1),16,nMT,G1H16(58),n2h16(102))
  Gcoeff(:)%j = (-(c(14)*M(1,:)%j)+c(15)*M(3,:)%j) * den(2)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(143),h0tab(:,143),[16,2,1,12],[nMT,nMZ,nMT,nMT],4,1,wf4(:,2))
  call Hloop_QV_A(ntryL,G0H32(1),ex5(:),G0H16(1),m3h2x16(:,143),heltab2x32(:,:,143))
  call Hloop_Q_A(ntryL,G0H16(1),16,nMT,G1H16(59),n2h16(103))
  Gcoeff(:)%j = (-(c(39)*M(1,:)%j)+c(40)*M(3,:)%j) * den(2)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(144),h0tab(:,144),[16,2,1,12],[nMB,nMW,nMB,nMB],4,1,wf4(:,2))
  call Hloop_QV_A(ntryL,G0H32(1),ex5(:),G0H16(1),m3h2x16(:,144),heltab2x32(:,:,144))
  call Hloop_Q_A(ntryL,G0H16(1),16,nMB,G1H16(60),n2h16(104))
  Gcoeff(:)%j = (c(26)*M(2,:)%j-c(27)*M(4,:)%j+c(30)*M(8,:)%j) * den(2)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(145),h0tab(:,145),[16,2,1,12],[nMT,0,nMT,nMT],4,1,wf4(:,2))
  call Hloop_QV_A(ntryL,G0H32(1),ex5(:),G0H16(1),m3h2x16(:,145),heltab2x32(:,:,145))
  call Hloop_Q_A(ntryL,G0H16(1),16,nMT,G1H16(61),n2h16(105))
  Gcoeff(:)%j = (c(35)*M(4,:)%j+c(30)*(-M(2,:)%j+M(8,:)%j)) * den(2)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(146),h0tab(:,146),[16,2,1,12],[0,nMT,0,0],4,1,wf4(:,2))
  call Hloop_UV_W(ntryL,G0H32(1),0,ex5(:),16,G1H16(62),m3h2x16(:,146),heltab2x32(:,:,146))
  Gcoeff(:)%j = (c(51)*M(1,:)%j) * den(22)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(147),h0tab(:,147),[16,1,12,2],[0,nMT,nMT,0],4,1,wf4(:,18))
  call Hloop_UV_W(ntryL,G0H32(1),0,ex5(:),16,G1H16(67),m3h2x16(:,147),heltab2x32(:,:,147))
  Gcoeff(:)%j = (c(51)*M(1,:)%j) * den(24)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(148),h0tab(:,148),[16,1,12,2],[0,nMT,nMT,0],4,1,wf4(:,19))
  call Hloop_UV_W(ntryL,G0H32(1),0,ex5(:),16,G1H16(65),m3h2x16(:,148),heltab2x32(:,:,148))
  Gcoeff(:)%j = (-(c(20)*M(8,:)%j)) * den(2)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(149),h0tab(:,149),[16,1,12,2],[nMT,0,0,nMT],4,1,wf4(:,2))
  call Hloop_AV_Q(ntryL,G0H32(1),ex5(:),G0H16(1),m3h2x16(:,149),heltab2x32(:,:,149))
  call Hloop_A_Q(ntryL,G0H16(1),16,nMT,G1H16(66),n2h16(106))
  Gcoeff(:)%j = (c(3)*M(1,:)%j) * den(2)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(150),h0tab(:,150),[16,1,12,2],[0,nMT,nMT,0],4,1,wf4(:,2))
  call Hloop_UV_W(ntryL,G0H32(1),0,ex5(:),16,G1H16(68),m3h2x16(:,150),heltab2x32(:,:,150))
  Gcoeff(:)%j = (-(c(6)*M(1,:)%j)) * den(24)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(151),h0tab(:,151),[16,1,12,2],[0,nMT,nMT,0],4,1,wf4(:,20))
  call Hloop_UV_W(ntryL,G0H32(1),0,ex5(:),16,G1H16(69),m3h2x16(:,151),heltab2x32(:,:,151))
  Gcoeff(:)%j = (c(20)*M(8,:)%j) * den(2)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(152),h0tab(:,152),[16,1,12,2],[0,nMT,nMT,0],4,1,wf4(:,2))
  call Hloop_UV_W(ntryL,G0H32(1),0,ex5(:),16,G1H16(70),m3h2x16(:,152),heltab2x32(:,:,152))
  Gcoeff(:)%j = (-(c(45)*M(1,:)%j)+c(44)*M(5,:)%j) * den(14)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(153),h0tab(:,153),[17,4,2,8],[0,nMB,nMW,nMT],4,1,wf4(:,12))
  call Hloop_AQ_V(ntryL,G0H32(1),wf4(:,12),G0H8(1),m3h4x8(:,1),heltab2x32(:,:,153))
  Gcoeff(:)%j = (-(c(45)*M(1,:)%j)+c(44)*M(5,:)%j) * den(14)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(154),h0tab(:,154),[17,4,2,8],[nMW,nMT,0,nMB],4,1,wf4(:,12))
  call Hloop_AQ_S(ntryL,G0H32(1),wf4(:,12),G0H8(2),ngPbt,m3h4x8(:,2),heltab2x32(:,:,154))
  Gcoeff(:)%j = (-(c(40)*M(1,:)%j)+c(39)*M(5,:)%j) * den(14)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(155),h0tab(:,155),[17,4,2,8],[nMW,nMT,0,nMB],4,1,wf4(:,12))
  call Hloop_AQ_W(ntryL,G0H32(1),wf4(:,12),G0H8(3),m3h4x8(:,3),heltab2x32(:,:,155))
  Gcoeff(:)%j = (-(c(40)*M(1,:)%j)+c(39)*M(5,:)%j) * den(14)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(156),h0tab(:,156),[17,4,2,8],[0,nMB,nMW,nMT],4,1,wf4(:,12))
  call Hloop_AQ_V(ntryL,G0H32(1),wf4(:,12),G0H8(4),m3h4x8(:,4),heltab2x32(:,:,156))
  Gcoeff(:)%j = (-(c(45)*M(1,:)%j)+c(44)*M(5,:)%j) * den(14)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(157),h0tab(:,157),[17,2,4,8],[nMW,nMB,0,nMB],4,1,wf4(:,12))
  call Hloop_AQ_S(ntryL,G0H32(1),wf4(:,12),G0H8(5),ngPbt,m3h4x8(:,5),heltab2x32(:,:,157))
  Gcoeff(:)%j = (-(c(45)*M(1,:)%j)+c(44)*M(5,:)%j) * den(14)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(158),h0tab(:,158),[17,2,4,8],[0,nMT,nMW,nMT],4,1,wf4(:,12))
  call Hloop_AQ_V(ntryL,G0H32(1),wf4(:,12),G0H8(6),m3h4x8(:,6),heltab2x32(:,:,158))
  Gcoeff(:)%j = (c(52)*M(1,:)%j-c(53)*M(5,:)%j) * den(14)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(159),h0tab(:,159),[17,2,4,8],[nMT,nMH,nMB,0],4,1,wf4(:,12))
  call Hloop_VQ_A(ntryL,G0H32(1),wf4(:,12),G0H8(7),m3h4x8(:,7),heltab2x32(:,:,159))
  call Hloop_Q_A(ntryL,G0H8(7),17,nMT,G1H8(45),n2h8(25))
  Gcoeff(:)%j = (c(52)*M(1,:)%j-c(53)*M(5,:)%j) * den(14)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(160),h0tab(:,160),[17,2,4,8],[nMT,nMZ,nMB,0],4,1,wf4(:,12))
  call Hloop_VQ_A(ntryL,G0H32(1),wf4(:,12),G0H8(7),m3h4x8(:,8),heltab2x32(:,:,160))
  call Hloop_Q_A(ntryL,G0H8(7),17,nMT,G1H8(1),n2h8(26))
  Gcoeff(:)%j = (c(52)*M(1,:)%j-c(53)*M(5,:)%j) * den(14)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(161),h0tab(:,161),[17,2,4,8],[nMT,0,nMB,nMH],4,1,wf4(:,12))
  call Hloop_SQ_A(ntryL,G0H32(1),wf4(:,12),G0H8(7),ngH,m3h4x8(:,9),heltab2x32(:,:,161))
  call Hloop_Q_A(ntryL,G0H8(7),17,nMT,G1H8(2),n2h8(27))
  Gcoeff(:)%j = (c(52)*M(1,:)%j-c(53)*M(5,:)%j) * den(14)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(162),h0tab(:,162),[17,2,4,8],[nMT,0,nMB,nMZ],4,1,wf4(:,12))
  call Hloop_SQ_A(ntryL,G0H32(1),wf4(:,12),G0H8(7),ngX,m3h4x8(:,10),heltab2x32(:,:,162))
  call Hloop_Q_A(ntryL,G0H8(7),17,nMT,G1H8(3),n2h8(28))
  Gcoeff(:)%j = (-(c(40)*M(1,:)%j)+c(39)*M(5,:)%j) * den(14)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(163),h0tab(:,163),[17,2,4,8],[0,nMT,nMW,nMT],4,1,wf4(:,12))
  call Hloop_AQ_V(ntryL,G0H32(1),wf4(:,12),G0H8(7),m3h4x8(:,11),heltab2x32(:,:,163))
  Gcoeff(:)%j = (-(c(40)*M(1,:)%j)+c(39)*M(5,:)%j) * den(14)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(164),h0tab(:,164),[17,2,4,8],[nMW,nMB,0,nMB],4,1,wf4(:,12))
  call Hloop_AQ_W(ntryL,G0H32(1),wf4(:,12),G0H8(8),m3h4x8(:,12),heltab2x32(:,:,164))
  Gcoeff(:)%j = (c(9)*M(1,:)%j-c(10)*M(5,:)%j) * den(14)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(165),h0tab(:,165),[17,2,4,8],[nMT,0,nMB,0],4,1,wf4(:,12))
  call Hloop_VQ_A(ntryL,G0H32(1),wf4(:,12),G0H8(9),m3h4x8(:,13),heltab2x32(:,:,165))
  call Hloop_Q_A(ntryL,G0H8(9),17,nMT,G1H8(4),n2h8(29))
  Gcoeff(:)%j = (c(9)*M(1,:)%j-c(10)*M(5,:)%j) * den(14)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(166),h0tab(:,166),[17,2,4,8],[nMT,0,nMB,0],4,1,wf4(:,12))
  call Hloop_VQ_A(ntryL,G0H32(1),wf4(:,12),G0H8(9),m3h4x8(:,14),heltab2x32(:,:,166))
  call Hloop_Q_A(ntryL,G0H8(9),17,nMT,G1H8(5),n2h8(30))
  Gcoeff(:)%j = (-(c(14)*M(1,:)%j)+c(15)*M(5,:)%j) * den(14)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(167),h0tab(:,167),[17,2,4,8],[nMT,nMZ,nMB,0],4,1,wf4(:,12))
  call Hloop_VQ_A(ntryL,G0H32(1),wf4(:,12),G0H8(9),m3h4x8(:,15),heltab2x32(:,:,167))
  call Hloop_Q_A(ntryL,G0H8(9),17,nMT,G1H8(6),n2h8(31))
  Gcoeff(:)%j = (-(c(14)*M(1,:)%j)+c(15)*M(5,:)%j) * den(14)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(168),h0tab(:,168),[17,2,4,8],[nMT,0,nMB,nMZ],4,1,wf4(:,12))
  call Hloop_ZQ_A(ntryL,G0H32(1),wf4(:,12),G0H8(9),ngZu,m3h4x8(:,16),heltab2x32(:,:,168))
  call Hloop_Q_A(ntryL,G0H8(9),17,nMT,G1H8(7),n2h8(32))
  Gcoeff(:)%j = (c(26)*M(2,:)%j+c(33)*M(6,:)%j) * den(14)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(169),h0tab(:,169),[17,2,4,8],[nMT,0,nMB,0],4,1,wf4(:,12))
  call Hloop_VQ_A(ntryL,G0H32(1),wf4(:,12),G0H8(9),m3h4x8(:,17),heltab2x32(:,:,169))
  call Hloop_Q_A(ntryL,G0H8(9),17,nMT,G1H8(8),n2h8(33))
  Gcoeff(:)%j = (c(52)*M(1,:)%j-c(53)*M(5,:)%j) * den(14)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(170),h0tab(:,170),[17,2,8,4],[nMT,nMH,nMB,0],4,1,wf4(:,12))
  call Hloop_VQ_A(ntryL,G0H32(1),wf4(:,12),G0H8(9),m3h4x8(:,18),heltab2x32(:,:,170))
  call Hloop_Q_A(ntryL,G0H8(9),17,nMT,G1H8(9),n2h8(34))
  Gcoeff(:)%j = (c(52)*M(1,:)%j-c(53)*M(5,:)%j) * den(14)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(171),h0tab(:,171),[17,2,8,4],[nMT,nMZ,nMB,0],4,1,wf4(:,12))
  call Hloop_VQ_A(ntryL,G0H32(1),wf4(:,12),G0H8(9),m3h4x8(:,19),heltab2x32(:,:,171))
  call Hloop_Q_A(ntryL,G0H8(9),17,nMT,G1H8(10),n2h8(35))
  Gcoeff(:)%j = (c(52)*M(1,:)%j-c(53)*M(5,:)%j) * den(14)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(172),h0tab(:,172),[17,2,8,4],[nMT,0,nMB,nMH],4,1,wf4(:,12))
  call Hloop_SQ_A(ntryL,G0H32(1),wf4(:,12),G0H8(9),ngH,m3h4x8(:,20),heltab2x32(:,:,172))
  call Hloop_Q_A(ntryL,G0H8(9),17,nMT,G1H8(11),n2h8(36))
  Gcoeff(:)%j = (c(52)*M(1,:)%j-c(53)*M(5,:)%j) * den(14)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(173),h0tab(:,173),[17,2,8,4],[nMT,0,nMB,nMZ],4,1,wf4(:,12))
  call Hloop_SQ_A(ntryL,G0H32(1),wf4(:,12),G0H8(9),ngX,m3h4x8(:,21),heltab2x32(:,:,173))
  call Hloop_Q_A(ntryL,G0H8(9),17,nMT,G1H8(12),n2h8(37))
  Gcoeff(:)%j = (c(9)*M(1,:)%j-c(10)*M(5,:)%j) * den(14)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(174),h0tab(:,174),[17,2,8,4],[nMT,0,nMB,0],4,1,wf4(:,12))
  call Hloop_VQ_A(ntryL,G0H32(1),wf4(:,12),G0H8(9),m3h4x8(:,22),heltab2x32(:,:,174))
  call Hloop_Q_A(ntryL,G0H8(9),17,nMT,G1H8(13),n2h8(38))
  Gcoeff(:)%j = (c(9)*M(1,:)%j-c(10)*M(5,:)%j) * den(14)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(175),h0tab(:,175),[17,2,8,4],[nMT,0,nMB,0],4,1,wf4(:,12))
  call Hloop_VQ_A(ntryL,G0H32(1),wf4(:,12),G0H8(9),m3h4x8(:,23),heltab2x32(:,:,175))
  call Hloop_Q_A(ntryL,G0H8(9),17,nMT,G1H8(14),n2h8(39))
  Gcoeff(:)%j = (-(c(14)*M(1,:)%j)+c(15)*M(5,:)%j) * den(14)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(176),h0tab(:,176),[17,2,8,4],[nMT,nMZ,nMB,0],4,1,wf4(:,12))
  call Hloop_VQ_A(ntryL,G0H32(1),wf4(:,12),G0H8(9),m3h4x8(:,24),heltab2x32(:,:,176))
  call Hloop_Q_A(ntryL,G0H8(9),17,nMT,G1H8(15),n2h8(40))
  Gcoeff(:)%j = (-(c(14)*M(1,:)%j)+c(15)*M(5,:)%j) * den(14)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(177),h0tab(:,177),[17,2,8,4],[nMT,0,nMB,nMZ],4,1,wf4(:,12))
  call Hloop_ZQ_A(ntryL,G0H32(1),wf4(:,12),G0H8(9),ngZu,m3h4x8(:,25),heltab2x32(:,:,177))
  call Hloop_Q_A(ntryL,G0H8(9),17,nMT,G1H8(16),n2h8(41))
  Gcoeff(:)%j = (c(31)*M(2,:)%j-c(28)*M(6,:)%j) * den(14)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(178),h0tab(:,178),[17,2,8,4],[nMT,0,nMB,0],4,1,wf4(:,12))
  call Hloop_VQ_A(ntryL,G0H32(1),wf4(:,12),G0H8(9),m3h4x8(:,26),heltab2x32(:,:,178))
  call Hloop_Q_A(ntryL,G0H8(9),17,nMT,G1H8(17),n2h8(42))
  Gcoeff(:)%j = (-(c(45)*M(1,:)%j)+c(44)*M(3,:)%j) * den(19)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(179),h0tab(:,179),[18,4,1,8],[nMT,nMW,nMB,0],4,1,wf4(:,16))
  call Hloop_VA_Q(ntryL,G0H32(1),wf4(:,16),G0H8(9),m3h4x8(:,27),heltab2x32(:,:,179))
  call Hloop_A_Q(ntryL,G0H8(9),18,nMT,G1H8(18),n2h8(43))
  Gcoeff(:)%j = (-(c(45)*M(1,:)%j)+c(44)*M(3,:)%j) * den(19)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(180),h0tab(:,180),[18,4,1,8],[nMB,0,nMT,nMW],4,1,wf4(:,16))
  call Hloop_SA_Q(ntryL,G0H32(1),wf4(:,16),G0H8(9),ngPtb,m3h4x8(:,28),heltab2x32(:,:,180))
  call Hloop_A_Q(ntryL,G0H8(9),18,nMB,G1H8(19),n2h8(44))
  Gcoeff(:)%j = (-(c(40)*M(1,:)%j)+c(39)*M(3,:)%j) * den(19)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(181),h0tab(:,181),[18,4,1,8],[nMT,nMW,nMB,0],4,1,wf4(:,16))
  call Hloop_VA_Q(ntryL,G0H32(1),wf4(:,16),G0H8(9),m3h4x8(:,29),heltab2x32(:,:,181))
  call Hloop_A_Q(ntryL,G0H8(9),18,nMT,G1H8(20),n2h8(45))
  Gcoeff(:)%j = (-(c(40)*M(1,:)%j)+c(39)*M(3,:)%j) * den(19)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(182),h0tab(:,182),[18,4,1,8],[nMB,0,nMT,nMW],4,1,wf4(:,16))
  call Hloop_WA_Q(ntryL,G0H32(1),wf4(:,16),G0H8(9),m3h4x8(:,30),heltab2x32(:,:,182))
  call Hloop_A_Q(ntryL,G0H8(9),18,nMB,G1H8(21),n2h8(46))
  Gcoeff(:)%j = (c(52)*M(1,:)%j-c(53)*M(3,:)%j) * den(19)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(183),h0tab(:,183),[18,1,4,8],[nMT,nMH,nMB,0],4,1,wf4(:,16))
  call Hloop_VA_Q(ntryL,G0H32(1),wf4(:,16),G0H8(9),m3h4x8(:,31),heltab2x32(:,:,183))
  call Hloop_A_Q(ntryL,G0H8(9),18,nMT,G1H8(22),n2h8(47))
  Gcoeff(:)%j = (c(52)*M(1,:)%j-c(53)*M(3,:)%j) * den(19)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(184),h0tab(:,184),[18,1,4,8],[nMT,nMZ,nMB,0],4,1,wf4(:,16))
  call Hloop_VA_Q(ntryL,G0H32(1),wf4(:,16),G0H8(9),m3h4x8(:,32),heltab2x32(:,:,184))
  call Hloop_A_Q(ntryL,G0H8(9),18,nMT,G1H8(23),n2h8(48))
  Gcoeff(:)%j = (c(52)*M(1,:)%j-c(53)*M(3,:)%j) * den(19)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(185),h0tab(:,185),[18,1,4,8],[nMT,0,nMB,nMH],4,1,wf4(:,16))
  call Hloop_SA_Q(ntryL,G0H32(1),wf4(:,16),G0H8(9),ngH,m3h4x8(:,33),heltab2x32(:,:,185))
  call Hloop_A_Q(ntryL,G0H8(9),18,nMT,G1H8(24),n2h8(49))
  Gcoeff(:)%j = (c(52)*M(1,:)%j-c(53)*M(3,:)%j) * den(19)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(186),h0tab(:,186),[18,1,4,8],[nMT,0,nMB,nMZ],4,1,wf4(:,16))
  call Hloop_SA_Q(ntryL,G0H32(1),wf4(:,16),G0H8(9),ngX,m3h4x8(:,34),heltab2x32(:,:,186))
  call Hloop_A_Q(ntryL,G0H8(9),18,nMT,G1H8(25),n2h8(50))
  Gcoeff(:)%j = (c(9)*M(1,:)%j-c(10)*M(3,:)%j) * den(19)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(187),h0tab(:,187),[18,1,4,8],[nMT,0,nMB,0],4,1,wf4(:,16))
  call Hloop_VA_Q(ntryL,G0H32(1),wf4(:,16),G0H8(9),m3h4x8(:,35),heltab2x32(:,:,187))
  call Hloop_A_Q(ntryL,G0H8(9),18,nMT,G1H8(26),n2h8(51))
  Gcoeff(:)%j = (c(9)*M(1,:)%j-c(10)*M(3,:)%j) * den(19)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(188),h0tab(:,188),[18,1,4,8],[nMT,0,nMB,0],4,1,wf4(:,16))
  call Hloop_VA_Q(ntryL,G0H32(1),wf4(:,16),G0H8(9),m3h4x8(:,36),heltab2x32(:,:,188))
  call Hloop_A_Q(ntryL,G0H8(9),18,nMT,G1H8(27),n2h8(52))
  Gcoeff(:)%j = (-(c(14)*M(1,:)%j)+c(15)*M(3,:)%j) * den(19)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(189),h0tab(:,189),[18,1,4,8],[nMT,nMZ,nMB,0],4,1,wf4(:,16))
  call Hloop_VA_Q(ntryL,G0H32(1),wf4(:,16),G0H8(9),m3h4x8(:,37),heltab2x32(:,:,189))
  call Hloop_A_Q(ntryL,G0H8(9),18,nMT,G1H8(28),n2h8(53))
  Gcoeff(:)%j = (-(c(14)*M(1,:)%j)+c(15)*M(3,:)%j) * den(19)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(190),h0tab(:,190),[18,1,4,8],[nMT,0,nMB,nMZ],4,1,wf4(:,16))
  call Hloop_ZA_Q(ntryL,G0H32(1),wf4(:,16),G0H8(9),ngZu,m3h4x8(:,38),heltab2x32(:,:,190))
  call Hloop_A_Q(ntryL,G0H8(9),18,nMT,G1H8(29),n2h8(54))
  Gcoeff(:)%j = (c(31)*M(2,:)%j-c(28)*M(4,:)%j) * den(19)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(191),h0tab(:,191),[18,1,4,8],[nMT,0,nMB,0],4,1,wf4(:,16))
  call Hloop_VA_Q(ntryL,G0H32(1),wf4(:,16),G0H8(9),m3h4x8(:,39),heltab2x32(:,:,191))
  call Hloop_A_Q(ntryL,G0H8(9),18,nMT,G1H8(30),n2h8(55))
  Gcoeff(:)%j = (-(c(45)*M(1,:)%j)+c(44)*M(3,:)%j) * den(19)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(192),h0tab(:,192),[18,1,8,4],[nMW,nMB,0,nMB],4,1,wf4(:,16))
  call Hloop_QA_S(ntryL,G0H32(1),wf4(:,16),G0H8(9),ngPtb,m3h4x8(:,40),heltab2x32(:,:,192))
  Gcoeff(:)%j = (-(c(45)*M(1,:)%j)+c(44)*M(3,:)%j) * den(19)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(193),h0tab(:,193),[18,1,8,4],[0,nMT,nMW,nMT],4,1,wf4(:,16))
  call Hloop_QA_V(ntryL,G0H32(1),wf4(:,16),G0H8(10),m3h4x8(:,41),heltab2x32(:,:,193))
  Gcoeff(:)%j = (c(52)*M(1,:)%j-c(53)*M(3,:)%j) * den(19)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(194),h0tab(:,194),[18,1,8,4],[nMT,nMH,nMB,0],4,1,wf4(:,16))
  call Hloop_VA_Q(ntryL,G0H32(1),wf4(:,16),G0H8(11),m3h4x8(:,42),heltab2x32(:,:,194))
  call Hloop_A_Q(ntryL,G0H8(11),18,nMT,G1H8(31),n2h8(56))
  Gcoeff(:)%j = (c(52)*M(1,:)%j-c(53)*M(3,:)%j) * den(19)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(195),h0tab(:,195),[18,1,8,4],[nMT,nMZ,nMB,0],4,1,wf4(:,16))
  call Hloop_VA_Q(ntryL,G0H32(1),wf4(:,16),G0H8(11),m3h4x8(:,43),heltab2x32(:,:,195))
  call Hloop_A_Q(ntryL,G0H8(11),18,nMT,G1H8(32),n2h8(57))
  Gcoeff(:)%j = (c(52)*M(1,:)%j-c(53)*M(3,:)%j) * den(19)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(196),h0tab(:,196),[18,1,8,4],[nMT,0,nMB,nMH],4,1,wf4(:,16))
  call Hloop_SA_Q(ntryL,G0H32(1),wf4(:,16),G0H8(11),ngH,m3h4x8(:,44),heltab2x32(:,:,196))
  call Hloop_A_Q(ntryL,G0H8(11),18,nMT,G1H8(33),n2h8(58))
  Gcoeff(:)%j = (c(52)*M(1,:)%j-c(53)*M(3,:)%j) * den(19)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(197),h0tab(:,197),[18,1,8,4],[nMT,0,nMB,nMZ],4,1,wf4(:,16))
  call Hloop_SA_Q(ntryL,G0H32(1),wf4(:,16),G0H8(11),ngX,m3h4x8(:,45),heltab2x32(:,:,197))
  call Hloop_A_Q(ntryL,G0H8(11),18,nMT,G1H8(34),n2h8(59))
  Gcoeff(:)%j = (-(c(40)*M(1,:)%j)+c(39)*M(3,:)%j) * den(19)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(198),h0tab(:,198),[18,1,8,4],[0,nMT,nMW,nMT],4,1,wf4(:,16))
  call Hloop_QA_V(ntryL,G0H32(1),wf4(:,16),G0H8(11),m3h4x8(:,46),heltab2x32(:,:,198))
  Gcoeff(:)%j = (-(c(40)*M(1,:)%j)+c(39)*M(3,:)%j) * den(19)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(199),h0tab(:,199),[18,1,8,4],[nMW,nMB,0,nMB],4,1,wf4(:,16))
  call Hloop_QA_W(ntryL,G0H32(1),wf4(:,16),G0H8(12),m3h4x8(:,47),heltab2x32(:,:,199))
  Gcoeff(:)%j = (c(9)*M(1,:)%j-c(10)*M(3,:)%j) * den(19)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(200),h0tab(:,200),[18,1,8,4],[nMT,0,nMB,0],4,1,wf4(:,16))
  call Hloop_VA_Q(ntryL,G0H32(1),wf4(:,16),G0H8(13),m3h4x8(:,48),heltab2x32(:,:,200))
  call Hloop_A_Q(ntryL,G0H8(13),18,nMT,G1H8(35),n2h8(60))
  Gcoeff(:)%j = (c(9)*M(1,:)%j-c(10)*M(3,:)%j) * den(19)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(201),h0tab(:,201),[18,1,8,4],[nMT,0,nMB,0],4,1,wf4(:,16))
  call Hloop_VA_Q(ntryL,G0H32(1),wf4(:,16),G0H8(13),m3h4x8(:,49),heltab2x32(:,:,201))
  call Hloop_A_Q(ntryL,G0H8(13),18,nMT,G1H8(36),n2h8(61))
  Gcoeff(:)%j = (-(c(14)*M(1,:)%j)+c(15)*M(3,:)%j) * den(19)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(202),h0tab(:,202),[18,1,8,4],[nMT,nMZ,nMB,0],4,1,wf4(:,16))
  call Hloop_VA_Q(ntryL,G0H32(1),wf4(:,16),G0H8(13),m3h4x8(:,50),heltab2x32(:,:,202))
  call Hloop_A_Q(ntryL,G0H8(13),18,nMT,G1H8(37),n2h8(62))
  Gcoeff(:)%j = (-(c(14)*M(1,:)%j)+c(15)*M(3,:)%j) * den(19)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(203),h0tab(:,203),[18,1,8,4],[nMT,0,nMB,nMZ],4,1,wf4(:,16))
  call Hloop_ZA_Q(ntryL,G0H32(1),wf4(:,16),G0H8(13),ngZu,m3h4x8(:,51),heltab2x32(:,:,203))
  call Hloop_A_Q(ntryL,G0H8(13),18,nMT,G1H8(38),n2h8(63))
  Gcoeff(:)%j = (c(26)*M(2,:)%j+c(33)*M(4,:)%j) * den(19)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(204),h0tab(:,204),[18,1,8,4],[nMT,0,nMB,0],4,1,wf4(:,16))
  call Hloop_VA_Q(ntryL,G0H32(1),wf4(:,16),G0H8(13),m3h4x8(:,52),heltab2x32(:,:,204))
  call Hloop_A_Q(ntryL,G0H8(13),18,nMT,G1H8(39),n2h8(64))
  Gcoeff(:)%j = (-(c(53)*M(3,:)%j)+c(52)*M(7,:)%j) * den(5)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(205),h0tab(:,205),[20,2,1,8],[0,nMT,nMH,nMB],4,1,wf4(:,5))
  call Hloop_AQ_V(ntryL,G0H32(1),wf4(:,5),G0H8(13),m3h4x8(:,53),heltab2x32(:,:,205))
  Gcoeff(:)%j = (-(c(53)*M(3,:)%j)+c(52)*M(7,:)%j) * den(5)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(206),h0tab(:,206),[20,2,1,8],[0,nMT,nMZ,nMB],4,1,wf4(:,5))
  call Hloop_AQ_V(ntryL,G0H32(1),wf4(:,5),G0H8(14),m3h4x8(:,54),heltab2x32(:,:,206))
  Gcoeff(:)%j = (-(c(53)*M(3,:)%j)+c(52)*M(7,:)%j) * den(5)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(207),h0tab(:,207),[20,2,1,8],[nMH,nMT,0,nMB],4,1,wf4(:,5))
  call Hloop_AQ_S(ntryL,G0H32(1),wf4(:,5),G0H8(15),ngH,m3h4x8(:,55),heltab2x32(:,:,207))
  Gcoeff(:)%j = (-(c(53)*M(3,:)%j)+c(52)*M(7,:)%j) * den(5)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(208),h0tab(:,208),[20,2,1,8],[nMZ,nMT,0,nMB],4,1,wf4(:,5))
  call Hloop_AQ_S(ntryL,G0H32(1),wf4(:,5),G0H8(16),ngX,m3h4x8(:,56),heltab2x32(:,:,208))
  Gcoeff(:)%j = (c(44)*M(3,:)%j-c(45)*M(7,:)%j) * den(5)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(209),h0tab(:,209),[20,2,1,8],[nMB,nMW,nMB,0],4,1,wf4(:,5))
  call Hloop_VQ_A(ntryL,G0H32(1),wf4(:,5),G0H8(17),m3h4x8(:,57),heltab2x32(:,:,209))
  call Hloop_Q_A(ntryL,G0H8(17),20,nMB,G1H8(40),n2h8(65))
  Gcoeff(:)%j = (c(44)*M(3,:)%j-c(45)*M(7,:)%j) * den(5)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(210),h0tab(:,210),[20,2,1,8],[nMT,0,nMT,nMW],4,1,wf4(:,5))
  call Hloop_SQ_A(ntryL,G0H32(1),wf4(:,5),G0H8(17),ngPtb,m3h4x8(:,58),heltab2x32(:,:,210))
  call Hloop_Q_A(ntryL,G0H8(17),20,nMT,G1H8(41),n2h8(66))
  Gcoeff(:)%j = (-(c(10)*M(3,:)%j)+c(9)*M(7,:)%j) * den(5)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(211),h0tab(:,211),[20,2,1,8],[0,nMT,0,nMB],4,1,wf4(:,5))
  call Hloop_AQ_V(ntryL,G0H32(1),wf4(:,5),G0H8(17),m3h4x8(:,59),heltab2x32(:,:,211))
  Gcoeff(:)%j = (-(c(10)*M(3,:)%j)+c(9)*M(7,:)%j) * den(5)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(212),h0tab(:,212),[20,2,1,8],[0,nMT,0,nMB],4,1,wf4(:,5))
  call Hloop_AQ_V(ntryL,G0H32(1),wf4(:,5),G0H8(18),m3h4x8(:,60),heltab2x32(:,:,212))
  Gcoeff(:)%j = (c(15)*M(3,:)%j-c(14)*M(7,:)%j) * den(5)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(213),h0tab(:,213),[20,2,1,8],[0,nMT,nMZ,nMB],4,1,wf4(:,5))
  call Hloop_AQ_V(ntryL,G0H32(1),wf4(:,5),G0H8(19),m3h4x8(:,61),heltab2x32(:,:,213))
  Gcoeff(:)%j = (c(15)*M(3,:)%j-c(14)*M(7,:)%j) * den(5)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(214),h0tab(:,214),[20,2,1,8],[nMZ,nMT,0,nMB],4,1,wf4(:,5))
  call Hloop_AQ_Z(ntryL,G0H32(1),wf4(:,5),G0H8(20),ngZd,m3h4x8(:,62),heltab2x32(:,:,214))
  Gcoeff(:)%j = (c(33)*M(4,:)%j+c(26)*M(8,:)%j) * den(5)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(215),h0tab(:,215),[20,2,1,8],[0,nMT,0,nMB],4,1,wf4(:,5))
  call Hloop_AQ_V(ntryL,G0H32(1),wf4(:,5),G0H8(21),m3h4x8(:,63),heltab2x32(:,:,215))
  Gcoeff(:)%j = (c(39)*M(3,:)%j-c(40)*M(7,:)%j) * den(5)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(216),h0tab(:,216),[20,2,1,8],[nMT,0,nMT,nMW],4,1,wf4(:,5))
  call Hloop_WQ_A(ntryL,G0H32(1),wf4(:,5),G0H8(22),m3h4x8(:,64),heltab2x32(:,:,216))
  call Hloop_Q_A(ntryL,G0H8(22),20,nMT,G1H8(42),n2h8(67))
  Gcoeff(:)%j = (c(39)*M(3,:)%j-c(40)*M(7,:)%j) * den(5)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(217),h0tab(:,217),[20,2,1,8],[nMB,nMW,nMB,0],4,1,wf4(:,5))
  call Hloop_VQ_A(ntryL,G0H32(1),wf4(:,5),G0H8(22),m3h4x8(:,65),heltab2x32(:,:,217))
  call Hloop_Q_A(ntryL,G0H8(22),20,nMB,G1H8(43),n2h8(68))
  Gcoeff(:)%j = (-(c(53)*M(3,:)%j)+c(52)*M(7,:)%j) * den(5)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(218),h0tab(:,218),[20,1,2,8],[nMH,nMT,0,nMB],4,1,wf4(:,5))
  call Hloop_AQ_S(ntryL,G0H32(1),wf4(:,5),G0H8(22),ngH,m3h4x8(:,66),heltab2x32(:,:,218))
  Gcoeff(:)%j = (-(c(53)*M(3,:)%j)+c(52)*M(7,:)%j) * den(5)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(219),h0tab(:,219),[20,1,2,8],[nMZ,nMT,0,nMB],4,1,wf4(:,5))
  call Hloop_AQ_S(ntryL,G0H32(1),wf4(:,5),G0H8(23),ngX,m3h4x8(:,67),heltab2x32(:,:,219))
  Gcoeff(:)%j = (-(c(53)*M(3,:)%j)+c(52)*M(7,:)%j) * den(5)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(220),h0tab(:,220),[20,1,2,8],[0,nMT,nMH,nMB],4,1,wf4(:,5))
  call Hloop_AQ_V(ntryL,G0H32(1),wf4(:,5),G0H8(24),m3h4x8(:,68),heltab2x32(:,:,220))
  Gcoeff(:)%j = (-(c(53)*M(3,:)%j)+c(52)*M(7,:)%j) * den(5)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(221),h0tab(:,221),[20,1,2,8],[0,nMT,nMZ,nMB],4,1,wf4(:,5))
  call Hloop_AQ_V(ntryL,G0H32(1),wf4(:,5),G0H8(25),m3h4x8(:,69),heltab2x32(:,:,221))
  Gcoeff(:)%j = (-(c(10)*M(3,:)%j)+c(9)*M(7,:)%j) * den(5)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(222),h0tab(:,222),[20,1,2,8],[0,nMT,0,nMB],4,1,wf4(:,5))
  call Hloop_AQ_V(ntryL,G0H32(1),wf4(:,5),G0H8(26),m3h4x8(:,70),heltab2x32(:,:,222))
  Gcoeff(:)%j = (-(c(10)*M(3,:)%j)+c(9)*M(7,:)%j) * den(5)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(223),h0tab(:,223),[20,1,2,8],[0,nMT,0,nMB],4,1,wf4(:,5))
  call Hloop_AQ_V(ntryL,G0H32(1),wf4(:,5),G0H8(27),m3h4x8(:,71),heltab2x32(:,:,223))
  Gcoeff(:)%j = (c(15)*M(3,:)%j-c(14)*M(7,:)%j) * den(5)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(224),h0tab(:,224),[20,1,2,8],[nMZ,nMT,0,nMB],4,1,wf4(:,5))
  call Hloop_AQ_Z(ntryL,G0H32(1),wf4(:,5),G0H8(28),ngZd,m3h4x8(:,72),heltab2x32(:,:,224))
  Gcoeff(:)%j = (c(15)*M(3,:)%j-c(14)*M(7,:)%j) * den(5)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(225),h0tab(:,225),[20,1,2,8],[0,nMT,nMZ,nMB],4,1,wf4(:,5))
  call Hloop_AQ_V(ntryL,G0H32(1),wf4(:,5),G0H8(29),m3h4x8(:,73),heltab2x32(:,:,225))
  Gcoeff(:)%j = (-(c(28)*M(4,:)%j)+c(31)*M(8,:)%j) * den(5)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(226),h0tab(:,226),[20,1,2,8],[0,nMT,0,nMB],4,1,wf4(:,5))
  call Hloop_AQ_V(ntryL,G0H32(1),wf4(:,5),G0H8(30),m3h4x8(:,74),heltab2x32(:,:,226))
  Gcoeff(:)%j = (c(44)*M(3,:)%j-c(45)*M(7,:)%j) * den(5)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(227),h0tab(:,227),[20,1,8,2],[nMW,nMB,0,nMT],4,1,wf4(:,5))
  call Hloop_AQ_S(ntryL,G0H32(1),wf4(:,5),G0H8(31),ngPtb,m3h4x8(:,75),heltab2x32(:,:,227))
  Gcoeff(:)%j = (c(44)*M(3,:)%j-c(45)*M(7,:)%j) * den(5)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(228),h0tab(:,228),[20,1,8,2],[0,nMT,nMW,nMB],4,1,wf4(:,5))
  call Hloop_AQ_V(ntryL,G0H32(1),wf4(:,5),G0H8(32),m3h4x8(:,76),heltab2x32(:,:,228))
  Gcoeff(:)%j = (c(39)*M(3,:)%j-c(40)*M(7,:)%j) * den(5)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(229),h0tab(:,229),[20,1,8,2],[0,nMT,nMW,nMB],4,1,wf4(:,5))
  call Hloop_AQ_V(ntryL,G0H32(1),wf4(:,5),G0H8(33),m3h4x8(:,77),heltab2x32(:,:,229))
  Gcoeff(:)%j = (c(39)*M(3,:)%j-c(40)*M(7,:)%j) * den(5)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(230),h0tab(:,230),[20,1,8,2],[nMW,nMB,0,nMT],4,1,wf4(:,5))
  call Hloop_AQ_W(ntryL,G0H32(1),wf4(:,5),G0H8(34),m3h4x8(:,78),heltab2x32(:,:,230))
  Gcoeff(:)%j = (-(c(53)*M(5,:)%j)+c(52)*M(7,:)%j) * den(10)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(231),h0tab(:,231),[24,2,1,4],[0,nMT,nMH,nMB],4,1,wf4(:,9))
  call Hloop_QA_V(ntryL,G0H32(1),wf4(:,9),G0H8(35),m3h4x8(:,79),heltab2x32(:,:,231))
  Gcoeff(:)%j = (-(c(53)*M(5,:)%j)+c(52)*M(7,:)%j) * den(10)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(232),h0tab(:,232),[24,2,1,4],[0,nMT,nMZ,nMB],4,1,wf4(:,9))
  call Hloop_QA_V(ntryL,G0H32(1),wf4(:,9),G0H8(36),m3h4x8(:,80),heltab2x32(:,:,232))
  Gcoeff(:)%j = (-(c(53)*M(5,:)%j)+c(52)*M(7,:)%j) * den(10)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(233),h0tab(:,233),[24,2,1,4],[nMH,nMT,0,nMB],4,1,wf4(:,9))
  call Hloop_QA_S(ntryL,G0H32(1),wf4(:,9),G0H8(37),ngH,m3h4x8(:,81),heltab2x32(:,:,233))
  Gcoeff(:)%j = (-(c(53)*M(5,:)%j)+c(52)*M(7,:)%j) * den(10)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(234),h0tab(:,234),[24,2,1,4],[nMZ,nMT,0,nMB],4,1,wf4(:,9))
  call Hloop_QA_S(ntryL,G0H32(1),wf4(:,9),G0H8(38),ngX,m3h4x8(:,82),heltab2x32(:,:,234))
  Gcoeff(:)%j = (-(c(10)*M(5,:)%j)+c(9)*M(7,:)%j) * den(10)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(235),h0tab(:,235),[24,2,1,4],[0,nMT,0,nMB],4,1,wf4(:,9))
  call Hloop_QA_V(ntryL,G0H32(1),wf4(:,9),G0H8(39),m3h4x8(:,83),heltab2x32(:,:,235))
  Gcoeff(:)%j = (-(c(10)*M(5,:)%j)+c(9)*M(7,:)%j) * den(10)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(236),h0tab(:,236),[24,2,1,4],[0,nMT,0,nMB],4,1,wf4(:,9))
  call Hloop_QA_V(ntryL,G0H32(1),wf4(:,9),G0H8(40),m3h4x8(:,84),heltab2x32(:,:,236))
  Gcoeff(:)%j = (c(15)*M(5,:)%j-c(14)*M(7,:)%j) * den(10)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(237),h0tab(:,237),[24,2,1,4],[0,nMT,nMZ,nMB],4,1,wf4(:,9))
  call Hloop_QA_V(ntryL,G0H32(1),wf4(:,9),G0H8(41),m3h4x8(:,85),heltab2x32(:,:,237))
  Gcoeff(:)%j = (c(15)*M(5,:)%j-c(14)*M(7,:)%j) * den(10)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(238),h0tab(:,238),[24,2,1,4],[nMZ,nMT,0,nMB],4,1,wf4(:,9))
  call Hloop_QA_Z(ntryL,G0H32(1),wf4(:,9),G0H8(42),ngZd,m3h4x8(:,86),heltab2x32(:,:,238))
  Gcoeff(:)%j = (-(c(28)*M(6,:)%j)+c(31)*M(8,:)%j) * den(10)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(239),h0tab(:,239),[24,2,1,4],[0,nMT,0,nMB],4,1,wf4(:,9))
  call Hloop_QA_V(ntryL,G0H32(1),wf4(:,9),G0H8(43),m3h4x8(:,87),heltab2x32(:,:,239))
  Gcoeff(:)%j = (-(c(53)*M(5,:)%j)+c(52)*M(7,:)%j) * den(10)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(240),h0tab(:,240),[24,1,2,4],[nMH,nMT,0,nMB],4,1,wf4(:,9))
  call Hloop_QA_S(ntryL,G0H32(1),wf4(:,9),G0H8(44),ngH,m3h4x8(:,88),heltab2x32(:,:,240))
  Gcoeff(:)%j = (-(c(53)*M(5,:)%j)+c(52)*M(7,:)%j) * den(10)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(241),h0tab(:,241),[24,1,2,4],[nMZ,nMT,0,nMB],4,1,wf4(:,9))
  call Hloop_QA_S(ntryL,G0H32(1),wf4(:,9),G0H8(45),ngX,m3h4x8(:,89),heltab2x32(:,:,241))
  Gcoeff(:)%j = (-(c(53)*M(5,:)%j)+c(52)*M(7,:)%j) * den(10)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(242),h0tab(:,242),[24,1,2,4],[0,nMT,nMH,nMB],4,1,wf4(:,9))
  call Hloop_QA_V(ntryL,G0H32(1),wf4(:,9),G0H8(46),m3h4x8(:,90),heltab2x32(:,:,242))
  Gcoeff(:)%j = (-(c(53)*M(5,:)%j)+c(52)*M(7,:)%j) * den(10)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(243),h0tab(:,243),[24,1,2,4],[0,nMT,nMZ,nMB],4,1,wf4(:,9))
  call Hloop_QA_V(ntryL,G0H32(1),wf4(:,9),G0H8(47),m3h4x8(:,91),heltab2x32(:,:,243))
  Gcoeff(:)%j = (c(44)*M(5,:)%j-c(45)*M(7,:)%j) * den(10)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(244),h0tab(:,244),[24,1,2,4],[nMB,nMW,nMB,0],4,1,wf4(:,9))
  call Hloop_VA_Q(ntryL,G0H32(1),wf4(:,9),G0H8(48),m3h4x8(:,92),heltab2x32(:,:,244))
  call Hloop_A_Q(ntryL,G0H8(48),24,nMB,G1H8(44),n2h8(69))
  Gcoeff(:)%j = (c(44)*M(5,:)%j-c(45)*M(7,:)%j) * den(10)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(245),h0tab(:,245),[24,1,2,4],[nMT,0,nMT,nMW],4,1,wf4(:,9))
  call Hloop_SA_Q(ntryL,G0H32(1),wf4(:,9),G0H8(48),ngPbt,m3h4x8(:,93),heltab2x32(:,:,245))
  call Hloop_A_Q(ntryL,G0H8(48),24,nMT,G1H8(46),n2h8(70))
  Gcoeff(:)%j = (-(c(10)*M(5,:)%j)+c(9)*M(7,:)%j) * den(10)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(246),h0tab(:,246),[24,1,2,4],[0,nMT,0,nMB],4,1,wf4(:,9))
  call Hloop_QA_V(ntryL,G0H32(1),wf4(:,9),G0H8(48),m3h4x8(:,94),heltab2x32(:,:,246))
  Gcoeff(:)%j = (-(c(10)*M(5,:)%j)+c(9)*M(7,:)%j) * den(10)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(247),h0tab(:,247),[24,1,2,4],[0,nMT,0,nMB],4,1,wf4(:,9))
  call Hloop_QA_V(ntryL,G0H32(1),wf4(:,9),G0H8(49),m3h4x8(:,95),heltab2x32(:,:,247))
  Gcoeff(:)%j = (c(15)*M(5,:)%j-c(14)*M(7,:)%j) * den(10)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(248),h0tab(:,248),[24,1,2,4],[nMZ,nMT,0,nMB],4,1,wf4(:,9))
  call Hloop_QA_Z(ntryL,G0H32(1),wf4(:,9),G0H8(50),ngZd,m3h4x8(:,96),heltab2x32(:,:,248))
  Gcoeff(:)%j = (c(15)*M(5,:)%j-c(14)*M(7,:)%j) * den(10)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(249),h0tab(:,249),[24,1,2,4],[0,nMT,nMZ,nMB],4,1,wf4(:,9))
  call Hloop_QA_V(ntryL,G0H32(1),wf4(:,9),G0H8(51),m3h4x8(:,97),heltab2x32(:,:,249))
  Gcoeff(:)%j = (c(33)*M(6,:)%j+c(26)*M(8,:)%j) * den(10)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(250),h0tab(:,250),[24,1,2,4],[0,nMT,0,nMB],4,1,wf4(:,9))
  call Hloop_QA_V(ntryL,G0H32(1),wf4(:,9),G0H8(52),m3h4x8(:,98),heltab2x32(:,:,250))
  Gcoeff(:)%j = (c(39)*M(5,:)%j-c(40)*M(7,:)%j) * den(10)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(251),h0tab(:,251),[24,1,2,4],[nMT,0,nMT,nMW],4,1,wf4(:,9))
  call Hloop_WA_Q(ntryL,G0H32(1),wf4(:,9),G0H8(53),m3h4x8(:,99),heltab2x32(:,:,251))
  call Hloop_A_Q(ntryL,G0H8(53),24,nMT,G1H8(47),n2h8(71))
  Gcoeff(:)%j = (c(39)*M(5,:)%j-c(40)*M(7,:)%j) * den(10)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(252),h0tab(:,252),[24,1,2,4],[nMB,nMW,nMB,0],4,1,wf4(:,9))
  call Hloop_VA_Q(ntryL,G0H32(1),wf4(:,9),G0H8(53),m3h4x8(:,100),heltab2x32(:,:,252))
  call Hloop_A_Q(ntryL,G0H8(53),24,nMB,G1H8(48),n2h8(72))
  Gcoeff(:)%j = (c(44)*M(5,:)%j-c(45)*M(7,:)%j) * den(10)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(253),h0tab(:,253),[24,1,4,2],[nMB,nMW,nMT,0],4,1,wf4(:,9))
  call Hloop_VA_Q(ntryL,G0H32(1),wf4(:,9),G0H8(53),m3h4x8(:,101),heltab2x32(:,:,253))
  call Hloop_A_Q(ntryL,G0H8(53),24,nMB,G1H8(49),n2h8(73))
  Gcoeff(:)%j = (c(44)*M(5,:)%j-c(45)*M(7,:)%j) * den(10)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(254),h0tab(:,254),[24,1,4,2],[nMT,0,nMB,nMW],4,1,wf4(:,9))
  call Hloop_SA_Q(ntryL,G0H32(1),wf4(:,9),G0H8(53),ngPbt,m3h4x8(:,102),heltab2x32(:,:,254))
  call Hloop_A_Q(ntryL,G0H8(53),24,nMT,G1H8(50),n2h8(74))
  Gcoeff(:)%j = (c(39)*M(5,:)%j-c(40)*M(7,:)%j) * den(10)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(255),h0tab(:,255),[24,1,4,2],[nMB,nMW,nMT,0],4,1,wf4(:,9))
  call Hloop_VA_Q(ntryL,G0H32(1),wf4(:,9),G0H8(53),m3h4x8(:,103),heltab2x32(:,:,255))
  call Hloop_A_Q(ntryL,G0H8(53),24,nMB,G1H8(51),n2h8(75))
  Gcoeff(:)%j = (c(39)*M(5,:)%j-c(40)*M(7,:)%j) * den(10)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(256),h0tab(:,256),[24,1,4,2],[nMT,0,nMB,nMW],4,1,wf4(:,9))
  call Hloop_WA_Q(ntryL,G0H32(1),wf4(:,9),G0H8(53),m3h4x8(:,104),heltab2x32(:,:,256))
  call Hloop_A_Q(ntryL,G0H8(53),24,nMT,G1H8(52),n2h8(76))
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H16(75),[G1H16(46),G1H16(32)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H16(13),[G1H16(10),G1H16(7)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H16(22),[G1H16(23)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H16(49),[G1H16(45),G1H16(42)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H16(61),[G1H16(58),G1H16(56)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H16(70),[G1H16(68)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H8(8),[G1H8(5),G1H8(4)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H8(17),[G1H8(14),G1H8(13)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H8(30),[G1H8(27),G1H8(26)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H8(39),[G1H8(36),G1H8(35)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G0H8(21),[G0H8(18),G0H8(17)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G0H8(30),[G0H8(27),G0H8(26)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G0H8(43),[G0H8(40),G0H8(39)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G0H8(52),[G0H8(49),G0H8(48)])
  call Hloop_QS_A(ntryL,G1H16(6),wf4(:,3),G1H4(1),ngH,m3h4x4(:,1),heltab2x16(:,:,69))
  call Hloop_Q_A(ntryL,G1H4(1),19,nMB,G2H4(2),n2h4(69))
  call Hloop_QS_A(ntryL,G1H16(5),wf4(:,6),G1H4(2),ngX,m3h4x4(:,2),heltab2x16(:,:,70))
  call Hloop_Q_A(ntryL,G1H4(2),19,nMB,G2H4(15),n2h4(70))
  call Hloop_QV_A(ntryL,G1H16(12),wf4(:,1),G1H4(5),m3h4x4(:,3),heltab2x16(:,:,71))
  call Hloop_Q_A(ntryL,G1H4(5),19,nMB,G2H4(21),n2h4(71))
  call Hloop_QV_A(ntryL,G1H16(20),wf4(:,1),G1H4(6),m3h4x4(:,4),heltab2x16(:,:,72))
  call Hloop_Q_A(ntryL,G1H4(6),19,nMB,G2H4(29),n2h4(72))
  call Hloop_QV_A(ntryL,G1H16(19),wf4(:,1),G1H4(7),m3h4x4(:,5),heltab2x16(:,:,73))
  call Hloop_Q_A(ntryL,G1H4(7),19,nMT,G2H4(44),n2h4(73))
  call Hloop_QV_A(ntryL,G1H16(75),wf4(:,1),G1H4(8),m3h4x4(:,6),heltab2x16(:,:,74))
  call Hloop_Q_A(ntryL,G1H4(8),19,nMB,G2H4(47),n2h4(74))
  call Hloop_QZ_A(ntryL,G1H16(41),wf4(:,7),G1H4(11),ngZd,m3h4x4(:,7),heltab2x16(:,:,75))
  call Hloop_Q_A(ntryL,G1H4(11),19,nMB,G2H4(52),n2h4(75))
  call Hloop_QV_A(ntryL,G1H16(64),wf4(:,1),G1H4(12),m3h4x4(:,8),heltab2x16(:,:,76))
  call Hloop_Q_A(ntryL,G1H4(12),19,nMB,G2H4(61),n2h4(76))
  call Hloop_QV_A(ntryL,G1H16(63),wf4(:,1),G1H4(13),m3h4x4(:,9),heltab2x16(:,:,77))
  call Hloop_Q_A(ntryL,G1H4(13),19,nMT,G2H4(1),n2h4(77))
  call Hloop_UV_W(ntryL,G1H16(74),16,wf4(:,1),3,G2H4(6),m3h4x4(:,10),heltab2x16(:,:,78))
  call Hloop_AS_Q(ntryL,G1H16(1),wf4(:,3),G1H4(14),ngH,m3h4x4(:,11),heltab2x16(:,:,79))
  call Hloop_A_Q(ntryL,G1H4(14),19,nMB,G2H4(3),n2h4(78))
  call Hloop_AS_Q(ntryL,G1H16(2),wf4(:,6),G1H4(17),ngX,m3h4x4(:,12),heltab2x16(:,:,80))
  call Hloop_A_Q(ntryL,G1H4(17),19,nMB,G2H4(4),n2h4(79))
  call Hloop_AV_Q(ntryL,G1H16(3),wf4(:,1),G1H4(18),m3h4x4(:,13),heltab2x16(:,:,81))
  call Hloop_A_Q(ntryL,G1H4(18),19,nMB,G2H4(5),n2h4(80))
  call Hloop_AV_Q(ntryL,G1H16(4),wf4(:,1),G1H4(19),m3h4x4(:,14),heltab2x16(:,:,82))
  call Hloop_A_Q(ntryL,G1H4(19),19,nMB,G2H4(7),n2h4(81))
  call Hloop_AV_Q(ntryL,G1H16(9),wf4(:,1),G1H4(20),m3h4x4(:,15),heltab2x16(:,:,83))
  call Hloop_A_Q(ntryL,G1H4(20),19,nMT,G2H4(8),n2h4(82))
  call Hloop_AV_Q(ntryL,G1H16(13),wf4(:,1),G1H4(23),m3h4x4(:,16),heltab2x16(:,:,84))
  call Hloop_A_Q(ntryL,G1H4(23),19,nMB,G2H4(9),n2h4(83))
  call Hloop_AZ_Q(ntryL,G1H16(8),wf4(:,7),G1H4(24),ngZd,m3h4x4(:,17),heltab2x16(:,:,85))
  call Hloop_A_Q(ntryL,G1H4(24),19,nMB,G2H4(10),n2h4(84))
  call Hloop_AV_Q(ntryL,G1H16(11),wf4(:,1),G1H4(25),m3h4x4(:,18),heltab2x16(:,:,86))
  call Hloop_A_Q(ntryL,G1H4(25),19,nMB,G2H4(11),n2h4(85))
  call Hloop_AV_Q(ntryL,G1H16(14),wf4(:,1),G1H4(26),m3h4x4(:,19),heltab2x16(:,:,87))
  call Hloop_A_Q(ntryL,G1H4(26),19,nMT,G2H4(12),n2h4(86))
  call Hloop_UV_W(ntryL,G1H16(15),16,wf4(:,1),3,G2H4(13),m3h4x4(:,20),heltab2x16(:,:,88))
  call Hloop_VQ_A(ntryL,G1H16(16),ex3(:),G1H8(5),m3h2x8(:,69),heltab2x16(:,:,89))
  call Hloop_Q_A(ntryL,G1H8(5),20,nMB,G2H8(1),n2h8(77))
  call Hloop_VQ_A(ntryL,G1H16(17),ex3(:),G1H8(4),m3h2x8(:,70),heltab2x16(:,:,90))
  call Hloop_Q_A(ntryL,G1H8(4),20,nMB,G2H8(2),n2h8(78))
  call Hloop_AQ_V(ntryL,G1H16(18),ex3(:),G1H8(14),m3h2x8(:,71),heltab2x16(:,:,91))
  call Hloop_VQ_A(ntryL,G1H16(22),ex3(:),G1H8(13),m3h2x8(:,72),heltab2x16(:,:,92))
  call Hloop_Q_A(ntryL,G1H8(13),20,nMB,G2H8(3),n2h8(79))
  call Hloop_VQ_A(ntryL,G1H16(21),ex3(:),G1H8(27),m3h2x8(:,73),heltab2x16(:,:,93))
  call Hloop_Q_A(ntryL,G1H8(27),20,nMB,G2H8(4),n2h8(80))
  call Hloop_AQ_V(ntryL,G1H16(24),ex1(:),G1H8(26),m3h2x8(:,74),heltab2x16(:,:,94))
  call Hloop_AQ_V(ntryL,G1H16(25),ex1(:),G1H8(36),m3h2x8(:,75),heltab2x16(:,:,95))
  call Hloop_AS_Q(ntryL,G1H16(26),wf4(:,11),G1H4(29),ngPbt,m3h4x4(:,21),heltab2x16(:,:,96))
  call Hloop_A_Q(ntryL,G1H4(29),22,nMT,G2H4(14),n2h4(87))
  call Hloop_AW_Q(ntryL,G1H16(27),wf4(:,13),G1H4(30),m3h4x4(:,22),heltab2x16(:,:,97))
  call Hloop_A_Q(ntryL,G1H4(30),22,nMT,G2H4(18),n2h4(88))
  call Hloop_VQ_A(ntryL,G1H16(28),ex1(:),G1H8(35),m3h2x8(:,76),heltab2x16(:,:,98))
  call Hloop_Q_A(ntryL,G1H8(35),17,nMT,G2H8(5),n2h8(81))
  call Hloop_VQ_A(ntryL,G1H16(29),ex1(:),G1H8(5),m3h2x8(:,77),heltab2x16(:,:,99))
  call Hloop_Q_A(ntryL,G1H8(5),17,nMT,G2H8(6),n2h8(82))
  call Hloop_QA_V(ntryL,G1H16(30),ex2(:),G1H8(4),m3h2x8(:,78),heltab2x16(:,:,100))
  call Hloop_QA_V(ntryL,G1H16(31),ex2(:),G1H8(13),m3h2x8(:,79),heltab2x16(:,:,101))
  call Hloop_AQ_V(ntryL,G1H16(34),ex3(:),G1H8(27),m3h2x8(:,80),heltab2x16(:,:,102))
  call Hloop_AQ_V(ntryL,G1H16(33),ex3(:),G1H8(35),m3h2x8(:,81),heltab2x16(:,:,103))
  call Hloop_VA_Q(ntryL,G1H16(35),ex2(:),G1H8(5),m3h2x8(:,82),heltab2x16(:,:,104))
  call Hloop_A_Q(ntryL,G1H8(5),18,nMT,G2H8(7),n2h8(83))
  call Hloop_VA_Q(ntryL,G1H16(36),ex2(:),G1H8(5),m3h2x8(:,83),heltab2x16(:,:,105))
  call Hloop_A_Q(ntryL,G1H8(5),18,nMT,G2H8(8),n2h8(84))
  call Hloop_AQ_V(ntryL,G1H16(37),ex1(:),G1H8(5),m3h2x8(:,84),heltab2x16(:,:,106))
  call Hloop_AQ_V(ntryL,G1H16(38),ex1(:),G1H8(53),m3h2x8(:,85),heltab2x16(:,:,107))
  call Hloop_AQ_S(ntryL,G1H16(39),ex1(:),G1H8(54),ngH,m3h2x8(:,86),heltab2x16(:,:,108))
  call Hloop_AQ_S(ntryL,G1H16(40),ex1(:),G1H8(55),ngX,m3h2x8(:,87),heltab2x16(:,:,109))
  call Hloop_AQ_S(ntryL,G1H16(43),ex1(:),G1H8(56),ngPbt,m3h2x8(:,88),heltab2x16(:,:,110))
  call Hloop_AQ_V(ntryL,G1H16(49),ex1(:),G1H8(57),m3h2x8(:,89),heltab2x16(:,:,111))
  call Hloop_AQ_V(ntryL,G1H16(44),ex1(:),G1H8(58),m3h2x8(:,90),heltab2x16(:,:,112))
  call Hloop_AQ_Z(ntryL,G1H16(48),ex1(:),G1H8(59),ngZu,m3h2x8(:,91),heltab2x16(:,:,113))
  call Hloop_AQ_W(ntryL,G1H16(47),ex1(:),G1H8(60),m3h2x8(:,92),heltab2x16(:,:,114))
  call Hloop_VQ_A(ntryL,G1H16(50),ex1(:),G1H8(61),m3h2x8(:,93),heltab2x16(:,:,115))
  call Hloop_Q_A(ntryL,G1H8(61),17,nMT,G2H8(9),n2h8(85))
  call Hloop_QA_V(ntryL,G1H16(51),ex2(:),G1H8(61),m3h2x8(:,94),heltab2x16(:,:,116))
  call Hloop_QA_V(ntryL,G1H16(52),ex2(:),G1H8(62),m3h2x8(:,95),heltab2x16(:,:,117))
  call Hloop_QA_S(ntryL,G1H16(53),ex2(:),G1H8(63),ngH,m3h2x8(:,96),heltab2x16(:,:,118))
  call Hloop_QA_S(ntryL,G1H16(54),ex2(:),G1H8(64),ngX,m3h2x8(:,97),heltab2x16(:,:,119))
  call Hloop_QA_S(ntryL,G1H16(55),ex2(:),G1H8(65),ngPtb,m3h2x8(:,98),heltab2x16(:,:,120))
  call Hloop_QA_V(ntryL,G1H16(61),ex2(:),G1H8(66),m3h2x8(:,99),heltab2x16(:,:,121))
  call Hloop_QA_V(ntryL,G1H16(57),ex2(:),G1H8(67),m3h2x8(:,100),heltab2x16(:,:,122))
  call Hloop_QA_Z(ntryL,G1H16(59),ex2(:),G1H8(68),ngZu,m3h2x8(:,101),heltab2x16(:,:,123))
  call Hloop_QA_W(ntryL,G1H16(60),ex2(:),G1H8(69),m3h2x8(:,102),heltab2x16(:,:,124))
  call Hloop_VA_Q(ntryL,G1H16(62),ex2(:),G1H8(70),m3h2x8(:,103),heltab2x16(:,:,125))
  call Hloop_A_Q(ntryL,G1H8(70),18,nMT,G2H8(10),n2h8(86))
  call Hloop_VQ_A(ntryL,G1H16(67),ex1(:),G1H8(70),m3h2x8(:,104),heltab2x16(:,:,126))
  call Hloop_Q_A(ntryL,G1H8(70),17,nMT,G2H8(11),n2h8(87))
  call Hloop_VQ_A(ntryL,G1H16(65),ex1(:),G1H8(70),m3h2x8(:,105),heltab2x16(:,:,127))
  call Hloop_Q_A(ntryL,G1H8(70),17,nMT,G2H8(12),n2h8(88))
  call Hloop_AQ_V(ntryL,G1H16(66),ex1(:),G1H8(70),m3h2x8(:,106),heltab2x16(:,:,128))
  call Hloop_VQ_A(ntryL,G1H16(70),ex1(:),G1H8(71),m3h2x8(:,107),heltab2x16(:,:,129))
  call Hloop_Q_A(ntryL,G1H8(71),17,nMT,G2H8(13),n2h8(89))
  call Hloop_VQ_A(ntryL,G1H16(69),ex1(:),G1H8(71),m3h2x8(:,108),heltab2x16(:,:,130))
  call Hloop_Q_A(ntryL,G1H8(71),17,nMT,G2H8(14),n2h8(90))
  call Hloop_VQ_A(ntryL,G0H8(1),ex3(:),G0H4(1),m3h2x4(:,69),heltab2x8(:,:,69))
  call Hloop_Q_A(ntryL,G0H4(1),21,nMB,G1H4(31),n2h4(89))
  call Hloop_SQ_A(ntryL,G0H8(2),ex3(:),G0H4(1),ngPtb,m3h2x4(:,70),heltab2x8(:,:,70))
  call Hloop_Q_A(ntryL,G0H4(1),21,nMT,G1H4(32),n2h4(90))
  call Hloop_WQ_A(ntryL,G0H8(3),ex3(:),G0H4(1),m3h2x4(:,71),heltab2x8(:,:,71))
  call Hloop_Q_A(ntryL,G0H4(1),21,nMT,G1H4(35),n2h4(91))
  call Hloop_VQ_A(ntryL,G0H8(4),ex3(:),G0H4(1),m3h2x4(:,72),heltab2x8(:,:,72))
  call Hloop_Q_A(ntryL,G0H4(1),21,nMB,G1H4(36),n2h4(92))
  call Hloop_SA_Q(ntryL,G0H8(5),ex2(:),G0H4(1),ngPtb,m3h2x4(:,73),heltab2x8(:,:,73))
  call Hloop_A_Q(ntryL,G0H4(1),19,nMB,G1H4(37),n2h4(93))
  call Hloop_VA_Q(ntryL,G0H8(6),ex2(:),G0H4(1),m3h2x4(:,74),heltab2x8(:,:,74))
  call Hloop_A_Q(ntryL,G0H4(1),19,nMT,G1H4(38),n2h4(94))
  call Hloop_QA_S(ntryL,G1H8(45),ex2(:),G1H4(41),ngH,m3h2x4(:,75),heltab2x8(:,:,75))
  call Hloop_QA_S(ntryL,G1H8(1),ex2(:),G1H4(42),ngX,m3h2x4(:,76),heltab2x8(:,:,76))
  call Hloop_QA_V(ntryL,G1H8(2),ex2(:),G1H4(43),m3h2x4(:,77),heltab2x8(:,:,77))
  call Hloop_QA_V(ntryL,G1H8(3),ex2(:),G1H4(44),m3h2x4(:,78),heltab2x8(:,:,78))
  call Hloop_VA_Q(ntryL,G0H8(7),ex2(:),G0H4(1),m3h2x4(:,79),heltab2x8(:,:,79))
  call Hloop_A_Q(ntryL,G0H4(1),19,nMT,G1H4(47),n2h4(95))
  call Hloop_WA_Q(ntryL,G0H8(8),ex2(:),G0H4(1),m3h2x4(:,80),heltab2x8(:,:,80))
  call Hloop_A_Q(ntryL,G0H4(1),19,nMB,G1H4(48),n2h4(96))
  call Hloop_QA_V(ntryL,G1H8(8),ex2(:),G1H4(49),m3h2x4(:,81),heltab2x8(:,:,81))
  call Hloop_QA_Z(ntryL,G1H8(6),ex2(:),G1H4(50),ngZu,m3h2x4(:,82),heltab2x8(:,:,82))
  call Hloop_QA_V(ntryL,G1H8(7),ex2(:),G1H4(53),m3h2x4(:,83),heltab2x8(:,:,83))
  call Hloop_QA_S(ntryL,G1H8(9),ex2(:),G1H4(54),ngH,m3h2x4(:,84),heltab2x8(:,:,84))
  call Hloop_QA_S(ntryL,G1H8(10),ex2(:),G1H4(55),ngX,m3h2x4(:,85),heltab2x8(:,:,85))
  call Hloop_QA_V(ntryL,G1H8(11),ex2(:),G1H4(56),m3h2x4(:,86),heltab2x8(:,:,86))
  call Hloop_QA_V(ntryL,G1H8(12),ex2(:),G1H4(59),m3h2x4(:,87),heltab2x8(:,:,87))
  call Hloop_QA_V(ntryL,G1H8(17),ex2(:),G1H4(60),m3h2x4(:,88),heltab2x8(:,:,88))
  call Hloop_QA_Z(ntryL,G1H8(15),ex2(:),G1H4(61),ngZu,m3h2x4(:,89),heltab2x8(:,:,89))
  call Hloop_QA_V(ntryL,G1H8(16),ex2(:),G1H4(62),m3h2x4(:,90),heltab2x8(:,:,90))
  call Hloop_AQ_S(ntryL,G1H8(18),ex3(:),G1H4(65),ngPtb,m3h2x4(:,91),heltab2x8(:,:,91))
  call Hloop_AQ_V(ntryL,G1H8(19),ex3(:),G1H4(66),m3h2x4(:,92),heltab2x8(:,:,92))
  call Hloop_AQ_W(ntryL,G1H8(20),ex3(:),G1H4(67),m3h2x4(:,93),heltab2x8(:,:,93))
  call Hloop_AQ_V(ntryL,G1H8(21),ex3(:),G1H4(68),m3h2x4(:,94),heltab2x8(:,:,94))
  call Hloop_AQ_S(ntryL,G1H8(22),ex1(:),G1H4(71),ngH,m3h2x4(:,95),heltab2x8(:,:,95))
  call Hloop_AQ_S(ntryL,G1H8(23),ex1(:),G1H4(72),ngX,m3h2x4(:,96),heltab2x8(:,:,96))
  call Hloop_AQ_V(ntryL,G1H8(24),ex1(:),G1H4(73),m3h2x4(:,97),heltab2x8(:,:,97))
  call Hloop_AQ_V(ntryL,G1H8(25),ex1(:),G1H4(74),m3h2x4(:,98),heltab2x8(:,:,98))
  call Hloop_AQ_V(ntryL,G1H8(30),ex1(:),G1H4(77),m3h2x4(:,99),heltab2x8(:,:,99))
  call Hloop_AQ_Z(ntryL,G1H8(28),ex1(:),G1H4(78),ngZu,m3h2x4(:,100),heltab2x8(:,:,100))
  call Hloop_AQ_V(ntryL,G1H8(29),ex1(:),G1H4(79),m3h2x4(:,101),heltab2x8(:,:,101))
  call Hloop_SQ_A(ntryL,G0H8(9),ex1(:),G0H4(1),ngPbt,m3h2x4(:,102),heltab2x8(:,:,102))
  call Hloop_Q_A(ntryL,G0H4(1),19,nMB,G1H4(80),n2h4(97))
  call Hloop_VQ_A(ntryL,G0H8(10),ex1(:),G0H4(1),m3h2x4(:,103),heltab2x8(:,:,103))
  call Hloop_Q_A(ntryL,G0H4(1),19,nMT,G1H4(83),n2h4(98))
  call Hloop_AQ_S(ntryL,G1H8(31),ex1(:),G1H4(84),ngH,m3h2x4(:,104),heltab2x8(:,:,104))
  call Hloop_AQ_S(ntryL,G1H8(32),ex1(:),G1H4(85),ngX,m3h2x4(:,105),heltab2x8(:,:,105))
  call Hloop_AQ_V(ntryL,G1H8(33),ex1(:),G1H4(86),m3h2x4(:,106),heltab2x8(:,:,106))
  call Hloop_AQ_V(ntryL,G1H8(34),ex1(:),G1H4(89),m3h2x4(:,107),heltab2x8(:,:,107))
  call Hloop_VQ_A(ntryL,G0H8(11),ex1(:),G0H4(1),m3h2x4(:,108),heltab2x8(:,:,108))
  call Hloop_Q_A(ntryL,G0H4(1),19,nMT,G1H4(90),n2h4(99))
  call Hloop_WQ_A(ntryL,G0H8(12),ex1(:),G0H4(1),m3h2x4(:,109),heltab2x8(:,:,109))
  call Hloop_Q_A(ntryL,G0H4(1),19,nMB,G1H4(91),n2h4(100))
  call Hloop_AQ_V(ntryL,G1H8(39),ex1(:),G1H4(92),m3h2x4(:,110),heltab2x8(:,:,110))
  call Hloop_AQ_Z(ntryL,G1H8(37),ex1(:),G1H4(95),ngZu,m3h2x4(:,111),heltab2x8(:,:,111))
  call Hloop_AQ_V(ntryL,G1H8(38),ex1(:),G1H4(96),m3h2x4(:,112),heltab2x8(:,:,112))
  call Hloop_VA_Q(ntryL,G0H8(13),ex2(:),G0H4(1),m3h2x4(:,113),heltab2x8(:,:,113))
  call Hloop_A_Q(ntryL,G0H4(1),22,nMT,G1H4(97),n2h4(101))
  call Hloop_VA_Q(ntryL,G0H8(14),ex2(:),G0H4(1),m3h2x4(:,114),heltab2x8(:,:,114))
  call Hloop_A_Q(ntryL,G0H4(1),22,nMT,G1H4(98),n2h4(102))
  call Hloop_SA_Q(ntryL,G0H8(15),ex2(:),G0H4(1),ngH,m3h2x4(:,115),heltab2x8(:,:,115))
  call Hloop_A_Q(ntryL,G0H4(1),22,nMT,G1H4(101),n2h4(103))
  call Hloop_SA_Q(ntryL,G0H8(16),ex2(:),G0H4(1),ngX,m3h2x4(:,116),heltab2x8(:,:,116))
  call Hloop_A_Q(ntryL,G0H4(1),22,nMT,G1H4(102),n2h4(104))
  call Hloop_QA_S(ntryL,G1H8(40),ex2(:),G1H4(103),ngPtb,m3h2x4(:,117),heltab2x8(:,:,117))
  call Hloop_QA_V(ntryL,G1H8(41),ex2(:),G1H4(104),m3h2x4(:,118),heltab2x8(:,:,118))
  call Hloop_VA_Q(ntryL,G0H8(21),ex2(:),G0H4(1),m3h2x4(:,119),heltab2x8(:,:,119))
  call Hloop_A_Q(ntryL,G0H4(1),22,nMT,G1H4(107),n2h4(105))
  call Hloop_VA_Q(ntryL,G0H8(19),ex2(:),G0H4(1),m3h2x4(:,120),heltab2x8(:,:,120))
  call Hloop_A_Q(ntryL,G0H4(1),22,nMT,G1H4(108),n2h4(106))
  call Hloop_ZA_Q(ntryL,G0H8(20),ex2(:),G0H4(1),ngZu,m3h2x4(:,121),heltab2x8(:,:,121))
  call Hloop_A_Q(ntryL,G0H4(1),22,nMT,G1H4(109),n2h4(107))
  call Hloop_QA_V(ntryL,G1H8(42),ex2(:),G1H4(110),m3h2x4(:,122),heltab2x8(:,:,122))
  call Hloop_QA_W(ntryL,G1H8(43),ex2(:),G1H4(113),m3h2x4(:,123),heltab2x8(:,:,123))
  call Hloop_SQ_A(ntryL,G0H8(22),ex1(:),G0H4(1),ngH,m3h2x4(:,124),heltab2x8(:,:,124))
  call Hloop_Q_A(ntryL,G0H4(1),21,nMT,G1H4(114),n2h4(108))
  call Hloop_SQ_A(ntryL,G0H8(23),ex1(:),G0H4(1),ngX,m3h2x4(:,125),heltab2x8(:,:,125))
  call Hloop_Q_A(ntryL,G0H4(1),21,nMT,G1H4(115),n2h4(109))
  call Hloop_VQ_A(ntryL,G0H8(24),ex1(:),G0H4(1),m3h2x4(:,126),heltab2x8(:,:,126))
  call Hloop_Q_A(ntryL,G0H4(1),21,nMT,G1H4(116),n2h4(110))
  call Hloop_VQ_A(ntryL,G0H8(25),ex1(:),G0H4(1),m3h2x4(:,127),heltab2x8(:,:,127))
  call Hloop_Q_A(ntryL,G0H4(1),21,nMT,G1H4(119),n2h4(111))
  call Hloop_VQ_A(ntryL,G0H8(30),ex1(:),G0H4(1),m3h2x4(:,128),heltab2x8(:,:,128))
  call Hloop_Q_A(ntryL,G0H4(1),21,nMT,G1H4(120),n2h4(112))
  call Hloop_ZQ_A(ntryL,G0H8(28),ex1(:),G0H4(1),ngZu,m3h2x4(:,129),heltab2x8(:,:,129))
  call Hloop_Q_A(ntryL,G0H4(1),21,nMT,G1H4(121),n2h4(113))
  call Hloop_VQ_A(ntryL,G0H8(29),ex1(:),G0H4(1),m3h2x4(:,130),heltab2x8(:,:,130))
  call Hloop_Q_A(ntryL,G0H4(1),21,nMT,G1H4(122),n2h4(114))
  call Hloop_SQ_A(ntryL,G0H8(31),ex1(:),G0H4(1),ngPbt,m3h2x4(:,131),heltab2x8(:,:,131))
  call Hloop_Q_A(ntryL,G0H4(1),21,nMB,G1H4(125),n2h4(115))
  call Hloop_VQ_A(ntryL,G0H8(32),ex1(:),G0H4(1),m3h2x4(:,132),heltab2x8(:,:,132))
  call Hloop_Q_A(ntryL,G0H4(1),21,nMT,G1H4(126),n2h4(116))
  call Hloop_VQ_A(ntryL,G0H8(33),ex1(:),G0H4(1),m3h2x4(:,133),heltab2x8(:,:,133))
  call Hloop_Q_A(ntryL,G0H4(1),21,nMT,G1H4(127),n2h4(117))
  call Hloop_WQ_A(ntryL,G0H8(34),ex1(:),G0H4(1),m3h2x4(:,134),heltab2x8(:,:,134))
  call Hloop_Q_A(ntryL,G0H4(1),21,nMB,G1H4(128),n2h4(118))
  call Hloop_VA_Q(ntryL,G0H8(35),ex2(:),G0H4(1),m3h2x4(:,135),heltab2x8(:,:,135))
  call Hloop_A_Q(ntryL,G0H4(1),26,nMT,G1H4(131),n2h4(119))
  call Hloop_VA_Q(ntryL,G0H8(36),ex2(:),G0H4(1),m3h2x4(:,136),heltab2x8(:,:,136))
  call Hloop_A_Q(ntryL,G0H4(1),26,nMT,G1H4(132),n2h4(120))
  call Hloop_SA_Q(ntryL,G0H8(37),ex2(:),G0H4(1),ngH,m3h2x4(:,137),heltab2x8(:,:,137))
  call Hloop_A_Q(ntryL,G0H4(1),26,nMT,G1H4(133),n2h4(121))
  call Hloop_SA_Q(ntryL,G0H8(38),ex2(:),G0H4(1),ngX,m3h2x4(:,138),heltab2x8(:,:,138))
  call Hloop_A_Q(ntryL,G0H4(1),26,nMT,G1H4(134),n2h4(122))
  call Hloop_VA_Q(ntryL,G0H8(43),ex2(:),G0H4(1),m3h2x4(:,139),heltab2x8(:,:,139))
  call Hloop_A_Q(ntryL,G0H4(1),26,nMT,G1H4(137),n2h4(123))
  call Hloop_VA_Q(ntryL,G0H8(41),ex2(:),G0H4(1),m3h2x4(:,140),heltab2x8(:,:,140))
  call Hloop_A_Q(ntryL,G0H4(1),26,nMT,G1H4(138),n2h4(124))
  call Hloop_ZA_Q(ntryL,G0H8(42),ex2(:),G0H4(1),ngZu,m3h2x4(:,141),heltab2x8(:,:,141))
  call Hloop_A_Q(ntryL,G0H4(1),26,nMT,G1H4(139),n2h4(125))
  call Hloop_SQ_A(ntryL,G0H8(44),ex1(:),G0H4(1),ngH,m3h2x4(:,142),heltab2x8(:,:,142))
  call Hloop_Q_A(ntryL,G0H4(1),25,nMT,G1H4(140),n2h4(126))
  call Hloop_SQ_A(ntryL,G0H8(45),ex1(:),G0H4(1),ngX,m3h2x4(:,143),heltab2x8(:,:,143))
  call Hloop_Q_A(ntryL,G0H4(1),25,nMT,G1H4(143),n2h4(127))
  call Hloop_VQ_A(ntryL,G0H8(46),ex1(:),G0H4(1),m3h2x4(:,144),heltab2x8(:,:,144))
  call Hloop_Q_A(ntryL,G0H4(1),25,nMT,G1H4(144),n2h4(128))
  call Hloop_VQ_A(ntryL,G0H8(47),ex1(:),G0H4(1),m3h2x4(:,145),heltab2x8(:,:,145))
  call Hloop_Q_A(ntryL,G0H4(1),25,nMT,G1H4(1),n2h4(129))
  call Hloop_AQ_S(ntryL,G1H8(44),ex1(:),G1H4(2),ngPbt,m3h2x4(:,146),heltab2x8(:,:,146))
  call Hloop_AQ_V(ntryL,G1H8(46),ex1(:),G1H4(5),m3h2x4(:,147),heltab2x8(:,:,147))
  call Hloop_VQ_A(ntryL,G0H8(52),ex1(:),G0H4(1),m3h2x4(:,148),heltab2x8(:,:,148))
  call Hloop_Q_A(ntryL,G0H4(1),25,nMT,G1H4(6),n2h4(130))
  call Hloop_ZQ_A(ntryL,G0H8(50),ex1(:),G0H4(1),ngZu,m3h2x4(:,149),heltab2x8(:,:,149))
  call Hloop_Q_A(ntryL,G0H4(1),25,nMT,G1H4(7),n2h4(131))
  call Hloop_VQ_A(ntryL,G0H8(51),ex1(:),G0H4(1),m3h2x4(:,150),heltab2x8(:,:,150))
  call Hloop_Q_A(ntryL,G0H4(1),25,nMT,G1H4(8),n2h4(132))
  call Hloop_AQ_V(ntryL,G1H8(47),ex1(:),G1H4(11),m3h2x4(:,151),heltab2x8(:,:,151))
  call Hloop_AQ_W(ntryL,G1H8(48),ex1(:),G1H4(12),m3h2x4(:,152),heltab2x8(:,:,152))
  call Hloop_AQ_S(ntryL,G1H8(49),ex1(:),G1H4(13),ngPbt,m3h2x4(:,153),heltab2x8(:,:,153))
  call Hloop_AQ_V(ntryL,G1H8(50),ex1(:),G1H4(14),m3h2x4(:,154),heltab2x8(:,:,154))
  call Hloop_AQ_W(ntryL,G1H8(51),ex1(:),G1H4(17),m3h2x4(:,155),heltab2x8(:,:,155))
  call Hloop_AQ_V(ntryL,G1H8(52),ex1(:),G1H4(18),m3h2x4(:,156),heltab2x8(:,:,156))
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(71),[G1H4(3)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(64),[G1H4(4)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(72),[G1H4(9)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(70),[G1H4(10)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(77),[G1H4(15)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(13),[G1H4(76),G1H4(16)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(78),[G1H4(21)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(82),[G1H4(22)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(103),[G1H4(27)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(112),[G1H4(28)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(113),[G1H4(33)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(118),[G1H4(34)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(84),[G1H4(39)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(88),[G1H4(40)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(85),[G1H4(45)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(94),[G1H4(46)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(92),[G1H4(51)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(6),[G1H4(100),G1H4(52)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(95),[G1H4(57)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(106),[G1H4(58)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(41),[G1H4(63)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(42),[G1H4(69)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(49),[G1H4(75)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(50),[G1H4(81)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(54),[G1H4(87)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(55),[G1H4(93)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(60),[G1H4(99)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(61),[G1H4(105)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(65),[G1H4(111)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(67),[G1H4(117)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(52),[G2H4(47),G2H4(15),G2H4(2)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(10),[G2H4(9),G2H4(4),G2H4(3)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(18),[G2H4(14)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(35),[G1H4(32)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(48),[G1H4(37)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(91),[G1H4(80)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(109),[G1H4(102)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(121),[G1H4(115)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(128),[G1H4(125)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(139),[G1H4(134)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(7),[G1H4(143)])
  call Hloop_SQ_A(ntryL,G1H4(71),ex3(:),G1H2(25),ngH,m3h2x2(:,133),heltab2x4(:,:,133))
  call Hloop_Q_A(ntryL,G1H2(25),23,nMB,G2H2(40),n2h2(73))
  call Hloop_SQ_A(ntryL,G1H4(64),ex3(:),G1H2(26),ngH,m3h2x2(:,134),heltab2x4(:,:,134))
  call Hloop_Q_A(ntryL,G1H2(26),23,nMB,G2H2(42),n2h2(74))
  call Hloop_SQ_A(ntryL,G1H4(72),ex3(:),G1H2(30),ngX,m3h2x2(:,135),heltab2x4(:,:,135))
  call Hloop_Q_A(ntryL,G1H2(30),23,nMB,G2H2(49),n2h2(75))
  call Hloop_SQ_A(ntryL,G1H4(70),ex3(:),G1H2(31),ngX,m3h2x2(:,136),heltab2x4(:,:,136))
  call Hloop_Q_A(ntryL,G1H2(31),23,nMB,G2H2(51),n2h2(76))
  call Hloop_VQ_A(ntryL,G1H4(77),ex3(:),G1H2(32),m3h2x2(:,137),heltab2x4(:,:,137))
  call Hloop_Q_A(ntryL,G1H2(32),23,nMB,G2H2(58),n2h2(77))
  call Hotf_4pt_reduction(G2H4(13),RedSet_4(2),mass4set(:,1),  & 
G1H4(19),G1H4(20),G1H4(23),G1H4(24),G1H4(25),4)
  call HG1shiftOLR(G1H4(20),8,4)
  call Hloop_ZQ_A(ntryL,G1H4(78),ex3(:),G1H2(36),ngZd,m3h2x2(:,138),heltab2x4(:,:,138))
  call Hloop_Q_A(ntryL,G1H2(36),23,nMB,G2H2(60),n2h2(78))
  call Hloop_ZQ_A(ntryL,G1H4(82),ex3(:),G1H2(37),ngZd,m3h2x2(:,139),heltab2x4(:,:,139))
  call Hloop_Q_A(ntryL,G1H2(37),23,nMB,G2H2(70),n2h2(79))
  call Hloop_SQ_A(ntryL,G1H4(103),ex1(:),G1H2(38),ngPbt,m3h2x2(:,140),heltab2x4(:,:,140))
  call Hloop_Q_A(ntryL,G1H2(38),23,nMB,G2H2(72),n2h2(80))
  call Hloop_SQ_A(ntryL,G1H4(112),ex1(:),G1H2(42),ngPbt,m3h2x2(:,141),heltab2x4(:,:,141))
  call Hloop_Q_A(ntryL,G1H2(42),23,nMB,G2H2(82),n2h2(81))
  call Hloop_WQ_A(ntryL,G1H4(113),ex1(:),G1H2(43),m3h2x2(:,142),heltab2x4(:,:,142))
  call Hloop_Q_A(ntryL,G1H2(43),23,nMB,G2H2(84),n2h2(82))
  call Hloop_WQ_A(ntryL,G1H4(118),ex1(:),G1H2(44),m3h2x2(:,143),heltab2x4(:,:,143))
  call Hloop_Q_A(ntryL,G1H2(44),23,nMB,G2H2(91),n2h2(83))
  call Hloop_SA_Q(ntryL,G1H4(84),ex4(:),G1H2(48),ngH,m3h2x2(:,144),heltab2x4(:,:,144))
  call Hloop_A_Q(ntryL,G1H2(48),27,nMB,G2H2(93),n2h2(84))
  call Hloop_SA_Q(ntryL,G1H4(88),ex4(:),G1H2(49),ngH,m3h2x2(:,145),heltab2x4(:,:,145))
  call Hloop_A_Q(ntryL,G1H2(49),27,nMB,G2H2(97),n2h2(85))
  call Hloop_SA_Q(ntryL,G1H4(85),ex4(:),G1H2(50),ngX,m3h2x2(:,146),heltab2x4(:,:,146))
  call Hloop_A_Q(ntryL,G1H2(50),27,nMB,G2H2(99),n2h2(86))
  call Hloop_SA_Q(ntryL,G1H4(94),ex4(:),G1H2(54),ngX,m3h2x2(:,147),heltab2x4(:,:,147))
  call Hloop_A_Q(ntryL,G1H2(54),27,nMB,G2H2(103),n2h2(87))
  call Hloop_VA_Q(ntryL,G1H4(92),ex4(:),G1H2(55),m3h2x2(:,148),heltab2x4(:,:,148))
  call Hloop_A_Q(ntryL,G1H2(55),27,nMB,G2H2(105),n2h2(88))
  call Hotf_4pt_reduction(G2H4(6),RedSet_4(12),mass4set(:,1),  & 
G1H4(26),G1H4(29),G1H4(30),G1H4(3),G1H4(4),4)
  call HG1shiftOLR(G1H4(29),4,4)
  call Hloop_ZA_Q(ntryL,G1H4(95),ex4(:),G1H2(56),ngZd,m3h2x2(:,149),heltab2x4(:,:,149))
  call Hloop_A_Q(ntryL,G1H2(56),27,nMB,G2H2(1),n2h2(89))
  call Hloop_ZA_Q(ntryL,G1H4(106),ex4(:),G1H2(60),ngZd,m3h2x2(:,150),heltab2x4(:,:,150))
  call Hloop_A_Q(ntryL,G1H2(60),27,nMB,G2H2(2),n2h2(90))
  call Hloop_SQ_A(ntryL,G1H4(41),ex3(:),G1H2(61),ngH,m3h2x2(:,151),heltab2x4(:,:,151))
  call Hloop_Q_A(ntryL,G1H2(61),23,nMB,G2H2(3),n2h2(91))
  call Hloop_SQ_A(ntryL,G1H4(42),ex3(:),G1H2(62),ngX,m3h2x2(:,152),heltab2x4(:,:,152))
  call Hloop_Q_A(ntryL,G1H2(62),23,nMB,G2H2(4),n2h2(92))
  call Hloop_VQ_A(ntryL,G1H4(49),ex3(:),G1H2(66),m3h2x2(:,153),heltab2x4(:,:,153))
  call Hloop_Q_A(ntryL,G1H2(66),23,nMB,G2H2(5),n2h2(93))
  call Hloop_ZQ_A(ntryL,G1H4(50),ex3(:),G1H2(67),ngZd,m3h2x2(:,154),heltab2x4(:,:,154))
  call Hloop_Q_A(ntryL,G1H2(67),23,nMB,G2H2(6),n2h2(94))
  call Hloop_SA_Q(ntryL,G1H4(54),ex4(:),G1H2(68),ngH,m3h2x2(:,155),heltab2x4(:,:,155))
  call Hloop_A_Q(ntryL,G1H2(68),27,nMB,G2H2(7),n2h2(95))
  call Hloop_SA_Q(ntryL,G1H4(55),ex4(:),G1H2(72),ngX,m3h2x2(:,156),heltab2x4(:,:,156))
  call Hloop_A_Q(ntryL,G1H2(72),27,nMB,G2H2(8),n2h2(96))
  call Hloop_VA_Q(ntryL,G1H4(60),ex4(:),G1H2(73),m3h2x2(:,157),heltab2x4(:,:,157))
  call Hloop_A_Q(ntryL,G1H2(73),27,nMB,G2H2(9),n2h2(97))
  call Hloop_ZA_Q(ntryL,G1H4(61),ex4(:),G1H2(74),ngZd,m3h2x2(:,158),heltab2x4(:,:,158))
  call Hloop_A_Q(ntryL,G1H2(74),27,nMB,G2H2(10),n2h2(98))
  call Hloop_SQ_A(ntryL,G1H4(65),ex1(:),G1H2(78),ngPbt,m3h2x2(:,159),heltab2x4(:,:,159))
  call Hloop_Q_A(ntryL,G1H2(78),23,nMB,G2H2(11),n2h2(99))
  call Hloop_WQ_A(ntryL,G1H4(67),ex1(:),G1H2(79),m3h2x2(:,160),heltab2x4(:,:,160))
  call Hloop_Q_A(ntryL,G1H2(79),23,nMB,G2H2(12),n2h2(100))
  call Hloop_SA_Q(ntryL,G1H4(123),ex2(:),G1H2(80),ngPtb,m3h2x2(:,161),heltab2x4(:,:,161))
  call Hloop_A_Q(ntryL,G1H2(80),27,nMB,G2H2(13),n2h2(101))
  call Hloop_SA_Q(ntryL,G1H4(124),ex2(:),G1H2(84),ngPtb,m3h2x2(:,162),heltab2x4(:,:,162))
  call Hloop_A_Q(ntryL,G1H2(84),27,nMB,G2H2(14),n2h2(102))
  call Hloop_WA_Q(ntryL,G1H4(129),ex2(:),G1H2(85),m3h2x2(:,163),heltab2x4(:,:,163))
  call Hloop_A_Q(ntryL,G1H2(85),27,nMB,G2H2(15),n2h2(103))
  call Hloop_WA_Q(ntryL,G1H4(130),ex2(:),G1H2(86),m3h2x2(:,164),heltab2x4(:,:,164))
  call Hloop_A_Q(ntryL,G1H2(86),27,nMB,G2H2(16),n2h2(104))
  call Hloop_SQ_A(ntryL,G1H4(135),ex3(:),G1H2(90),ngPtb,m3h2x2(:,165),heltab2x4(:,:,165))
  call Hloop_Q_A(ntryL,G1H2(90),29,nMT,G2H2(17),n2h2(105))
  call Hloop_SQ_A(ntryL,G1H4(136),ex3(:),G1H2(91),ngPtb,m3h2x2(:,166),heltab2x4(:,:,166))
  call Hloop_Q_A(ntryL,G1H2(91),29,nMT,G2H2(18),n2h2(106))
  call Hloop_WQ_A(ntryL,G1H4(141),ex3(:),G1H2(92),m3h2x2(:,167),heltab2x4(:,:,167))
  call Hloop_Q_A(ntryL,G1H2(92),29,nMT,G2H2(19),n2h2(107))
  call Hloop_WQ_A(ntryL,G1H4(142),ex3(:),G1H2(96),m3h2x2(:,168),heltab2x4(:,:,168))
  call Hloop_Q_A(ntryL,G1H2(96),29,nMT,G2H2(20),n2h2(108))
  call Hloop_QA_V(ntryL,G2H4(52),ex4(:),G2H2(21),m3h2x2(:,169),heltab2x4(:,:,169))
  call Hloop_QA_S(ntryL,G2H4(21),ex4(:),G2H2(22),ngH,m3h2x2(:,170),heltab2x4(:,:,170))
  call Hloop_QA_S(ntryL,G2H4(29),ex4(:),G2H2(23),ngX,m3h2x2(:,171),heltab2x4(:,:,171))
  call Hloop_QA_S(ntryL,G2H4(44),ex4(:),G2H2(24),ngPbt,m3h2x2(:,172),heltab2x4(:,:,172))
  call Hloop_QA_Z(ntryL,G2H4(61),ex4(:),G2H2(25),ngZd,m3h2x2(:,173),heltab2x4(:,:,173))
  call Hloop_QA_W(ntryL,G2H4(1),ex4(:),G2H2(26),m3h2x2(:,174),heltab2x4(:,:,174))
  call Hloop_AQ_V(ntryL,G2H4(10),ex3(:),G2H2(27),m3h2x2(:,175),heltab2x4(:,:,175))
  call Hloop_AQ_S(ntryL,G2H4(5),ex3(:),G2H2(28),ngH,m3h2x2(:,176),heltab2x4(:,:,176))
  call Hloop_AQ_S(ntryL,G2H4(7),ex3(:),G2H2(29),ngX,m3h2x2(:,177),heltab2x4(:,:,177))
  call Hloop_AQ_S(ntryL,G2H4(8),ex3(:),G2H2(30),ngPtb,m3h2x2(:,178),heltab2x4(:,:,178))
  call Hloop_AQ_Z(ntryL,G2H4(11),ex3(:),G2H2(31),ngZd,m3h2x2(:,179),heltab2x4(:,:,179))
  call Hloop_AQ_W(ntryL,G2H4(12),ex3(:),G2H2(32),m3h2x2(:,180),heltab2x4(:,:,180))
  call Hotf_4pt_reduction(G2H8(1),RedSet_4(8),mass4set(:,2),  & 
G1H8(71),G1H8(45),G1H8(1),G1H8(2),G1H8(3),8)
  call HG1shiftOLR(G1H8(45),8,8)
  call Hotf_4pt_reduction(G2H8(2),RedSet_4(8),mass4set(:,2),  & 
G1H8(8),G1H8(6),G1H8(7),G1H8(9),G1H8(10),8)
  call HG1shiftOLR(G1H8(6),8,8)
  call Hloop_UV_W(ntryL,G1H8(14),20,wf4(:,1),3,G2H2(33),m3h4x2(:,1),heltab2x8(:,:,157))
  call Hotf_4pt_reduction(G2H8(3),RedSet_4(8),mass4set(:,2),  & 
G1H8(11),G1H8(12),G1H8(17),G1H8(15),G1H8(16),8)
  call HG1shiftOLR(G1H8(12),8,8)
  call Hotf_4pt_reduction(G2H8(4),RedSet_4(8),mass4set(:,2),  & 
G1H8(18),G1H8(19),G1H8(20),G1H8(21),G1H8(22),8)
  call HG1shiftOLR(G1H8(19),8,8)
  call Hloop_VA_Q(ntryL,G1H8(26),ex4(:),G1H4(9),m3h2x4(:,157),heltab2x8(:,:,158))
  call Hloop_A_Q(ntryL,G1H4(9),25,nMB,G2H4(16),n2h4(133))
  call Hloop_VA_Q(ntryL,G1H8(36),ex4(:),G1H4(10),m3h2x4(:,158),heltab2x8(:,:,159))
  call Hloop_A_Q(ntryL,G1H4(10),25,nMB,G2H4(17),n2h4(134))
  call Hloop_AQ_V(ntryL,G2H4(18),ex1(:),G2H2(34),m3h2x2(:,181),heltab2x4(:,:,181))
  call Hotf_4pt_reduction(G2H8(5),RedSet_4(16),mass4set(:,3),  & 
G1H8(23),G1H8(24),G1H8(25),G1H8(30),G1H8(28),8)
  call HG1shiftOLR(G1H8(24),8,8)
  call Hotf_4pt_reduction(G2H8(6),RedSet_4(16),mass4set(:,3),  & 
G1H8(29),G1H8(31),G1H8(32),G1H8(33),G1H8(34),8)
  call HG1shiftOLR(G1H8(31),8,8)
  call Hloop_VQ_A(ntryL,G1H8(4),ex3(:),G1H4(15),m3h2x4(:,159),heltab2x8(:,:,160))
  call Hloop_Q_A(ntryL,G1H4(15),22,nMB,G2H4(19),n2h4(135))
  call Hloop_VQ_A(ntryL,G1H8(13),ex3(:),G1H4(76),m3h2x4(:,160),heltab2x8(:,:,161))
  call Hloop_Q_A(ntryL,G1H4(76),22,nMB,G2H4(20),n2h4(136))
  call Hloop_VA_Q(ntryL,G1H8(27),ex2(:),G1H4(16),m3h2x4(:,161),heltab2x8(:,:,162))
  call Hloop_A_Q(ntryL,G1H4(16),22,nMT,G2H4(24),n2h4(137))
  call Hloop_VA_Q(ntryL,G1H8(35),ex2(:),G1H4(21),m3h2x4(:,162),heltab2x8(:,:,163))
  call Hloop_A_Q(ntryL,G1H4(21),22,nMT,G2H4(22),n2h4(138))
  call Hotf_4pt_reduction(G2H8(7),RedSet_4(13),mass4set(:,3),  & 
G1H8(39),G1H8(37),G1H8(38),G1H8(40),G1H8(41),8)
  call HG1shiftOLR(G1H8(37),4,8)
  call Hotf_4pt_reduction(G2H8(8),RedSet_4(13),mass4set(:,3),  & 
G1H8(42),G1H8(43),G1H8(44),G1H8(46),G1H8(47),8)
  call HG1shiftOLR(G1H8(43),4,8)
  call Hloop_VA_Q(ntryL,G1H8(5),ex2(:),G1H4(22),m3h2x4(:,163),heltab2x8(:,:,164))
  call Hloop_A_Q(ntryL,G1H4(22),19,nMT,G2H4(23),n2h4(139))
  call Hloop_VA_Q(ntryL,G1H8(53),ex2(:),G1H4(27),m3h2x4(:,164),heltab2x8(:,:,165))
  call Hloop_A_Q(ntryL,G1H4(27),19,nMT,G2H4(25),n2h4(140))
  call Hloop_SA_Q(ntryL,G1H8(54),ex2(:),G1H4(28),ngH,m3h2x4(:,165),heltab2x8(:,:,166))
  call Hloop_A_Q(ntryL,G1H4(28),19,nMT,G2H4(26),n2h4(141))
  call Hloop_SA_Q(ntryL,G1H8(55),ex2(:),G1H4(33),ngX,m3h2x4(:,166),heltab2x8(:,:,167))
  call Hloop_A_Q(ntryL,G1H4(33),19,nMT,G2H4(27),n2h4(142))
  call Hloop_SA_Q(ntryL,G1H8(56),ex2(:),G1H4(34),ngPtb,m3h2x4(:,167),heltab2x8(:,:,168))
  call Hloop_A_Q(ntryL,G1H4(34),19,nMB,G2H4(28),n2h4(143))
  call Hloop_VA_Q(ntryL,G1H8(57),ex2(:),G1H4(39),m3h2x4(:,168),heltab2x8(:,:,169))
  call Hloop_A_Q(ntryL,G1H4(39),19,nMT,G2H4(32),n2h4(144))
  call Hloop_VA_Q(ntryL,G1H8(58),ex2(:),G1H4(40),m3h2x4(:,169),heltab2x8(:,:,170))
  call Hloop_A_Q(ntryL,G1H4(40),19,nMT,G2H4(30),n2h4(145))
  call Hloop_ZA_Q(ntryL,G1H8(59),ex2(:),G1H4(45),ngZu,m3h2x4(:,170),heltab2x8(:,:,171))
  call Hloop_A_Q(ntryL,G1H4(45),19,nMT,G2H4(31),n2h4(146))
  call Hloop_WA_Q(ntryL,G1H8(60),ex2(:),G1H4(46),m3h2x4(:,171),heltab2x8(:,:,172))
  call Hloop_A_Q(ntryL,G1H4(46),19,nMB,G2H4(33),n2h4(147))
  call Hloop_QA_V(ntryL,G2H8(9),ex2(:),G2H4(34),m3h2x4(:,172),heltab2x8(:,:,173))
  call Hloop_VQ_A(ntryL,G1H8(61),ex1(:),G1H4(51),m3h2x4(:,173),heltab2x8(:,:,174))
  call Hloop_Q_A(ntryL,G1H4(51),19,nMT,G2H4(35),n2h4(148))
  call Hloop_VQ_A(ntryL,G1H8(62),ex1(:),G1H4(100),m3h2x4(:,174),heltab2x8(:,:,175))
  call Hloop_Q_A(ntryL,G1H4(100),19,nMT,G2H4(36),n2h4(149))
  call Hloop_SQ_A(ntryL,G1H8(63),ex1(:),G1H4(52),ngH,m3h2x4(:,175),heltab2x8(:,:,176))
  call Hloop_Q_A(ntryL,G1H4(52),19,nMT,G2H4(37),n2h4(150))
  call Hloop_SQ_A(ntryL,G1H8(64),ex1(:),G1H4(57),ngX,m3h2x4(:,176),heltab2x8(:,:,177))
  call Hloop_Q_A(ntryL,G1H4(57),19,nMT,G2H4(38),n2h4(151))
  call Hloop_SQ_A(ntryL,G1H8(65),ex1(:),G1H4(58),ngPbt,m3h2x4(:,177),heltab2x8(:,:,178))
  call Hloop_Q_A(ntryL,G1H4(58),19,nMB,G2H4(39),n2h4(152))
  call Hloop_VQ_A(ntryL,G1H8(66),ex1(:),G1H4(63),m3h2x4(:,178),heltab2x8(:,:,179))
  call Hloop_Q_A(ntryL,G1H4(63),19,nMT,G2H4(40),n2h4(153))
  call Hloop_VQ_A(ntryL,G1H8(67),ex1(:),G1H4(69),m3h2x4(:,179),heltab2x8(:,:,180))
  call Hloop_Q_A(ntryL,G1H4(69),19,nMT,G2H4(41),n2h4(154))
  call Hloop_ZQ_A(ntryL,G1H8(68),ex1(:),G1H4(75),ngZu,m3h2x4(:,180),heltab2x8(:,:,181))
  call Hloop_Q_A(ntryL,G1H4(75),19,nMT,G2H4(42),n2h4(155))
  call Hloop_WQ_A(ntryL,G1H8(69),ex1(:),G1H4(81),m3h2x4(:,181),heltab2x8(:,:,182))
  call Hloop_Q_A(ntryL,G1H4(81),19,nMB,G2H4(43),n2h4(156))
  call Hloop_AQ_V(ntryL,G2H8(10),ex1(:),G2H4(46),m3h2x4(:,182),heltab2x8(:,:,183))
  call Hotf_4pt_reduction(G2H8(11),RedSet_4(31),mass4set(:,4),  & 
G1H8(48),G1H8(49),G1H8(50),G1H8(51),G1H8(52),8)
  call HG1shiftOLR(G1H8(49),2,8)
  call Hotf_4pt_reduction(G2H8(12),RedSet_4(31),mass4set(:,4),  & 
G1H8(14),G1H8(26),G1H8(36),G1H8(4),G1H8(13),8)
  call HG1shiftOLR(G1H8(26),2,8)
  call Hloop_UV_W(ntryL,G1H8(70),17,wf4(:,2),12,G2H2(35),m3h4x2(:,2),heltab2x8(:,:,184))
  call Hotf_4pt_reduction(G2H8(13),RedSet_4(31),mass4set(:,4),  & 
G1H8(27),G1H8(35),G1H8(5),G1H8(53),G1H8(54),8)
  call HG1shiftOLR(G1H8(35),2,8)
  call Hotf_4pt_reduction(G2H8(14),RedSet_4(31),mass4set(:,4),  & 
G1H8(55),G1H8(56),G1H8(57),G1H8(58),G1H8(59),8)
  call HG1shiftOLR(G1H8(56),2,8)
  call Hloop_QA_S(ntryL,G1H4(31),ex2(:),G1H2(97),ngPtb,m3h2x2(:,182),heltab2x4(:,:,182))
  call Hloop_QA_V(ntryL,G1H4(35),ex2(:),G1H2(98),m3h2x2(:,183),heltab2x4(:,:,183))
  call Hloop_QA_W(ntryL,G1H4(36),ex2(:),G1H2(102),m3h2x2(:,184),heltab2x4(:,:,184))
  call Hloop_AQ_V(ntryL,G1H4(48),ex3(:),G1H2(103),m3h2x2(:,185),heltab2x4(:,:,185))
  call Hloop_AQ_S(ntryL,G1H4(38),ex3(:),G1H2(104),ngPtb,m3h2x2(:,186),heltab2x4(:,:,186))
  call Hloop_VQ_A(ntryL,G1H4(43),ex3(:),G1H2(108),m3h2x2(:,187),heltab2x4(:,:,187))
  call Hloop_Q_A(ntryL,G1H2(108),23,nMB,G2H2(36),n2h2(109))
  call Hloop_VQ_A(ntryL,G1H4(44),ex3(:),G1H2(109),m3h2x2(:,188),heltab2x4(:,:,188))
  call Hloop_Q_A(ntryL,G1H2(109),23,nMB,G2H2(37),n2h2(110))
  call Hloop_AQ_W(ntryL,G1H4(47),ex3(:),G1H2(110),m3h2x2(:,189),heltab2x4(:,:,189))
  call Hloop_VQ_A(ntryL,G1H4(53),ex3(:),G1H2(114),m3h2x2(:,190),heltab2x4(:,:,190))
  call Hloop_Q_A(ntryL,G1H2(114),23,nMB,G2H2(39),n2h2(111))
  call Hloop_VA_Q(ntryL,G1H4(56),ex4(:),G1H2(115),m3h2x2(:,191),heltab2x4(:,:,191))
  call Hloop_A_Q(ntryL,G1H2(115),27,nMB,G2H2(46),n2h2(112))
  call Hloop_VA_Q(ntryL,G1H4(59),ex4(:),G1H2(116),m3h2x2(:,192),heltab2x4(:,:,192))
  call Hloop_A_Q(ntryL,G1H2(116),27,nMB,G2H2(48),n2h2(113))
  call Hloop_VA_Q(ntryL,G1H4(62),ex4(:),G1H2(120),m3h2x2(:,193),heltab2x4(:,:,193))
  call Hloop_A_Q(ntryL,G1H2(120),27,nMB,G2H2(43),n2h2(114))
  call Hloop_VQ_A(ntryL,G1H4(66),ex1(:),G1H2(121),m3h2x2(:,194),heltab2x4(:,:,194))
  call Hloop_Q_A(ntryL,G1H2(121),23,nMT,G2H2(45),n2h2(115))
  call Hloop_VQ_A(ntryL,G1H4(68),ex1(:),G1H2(122),m3h2x2(:,195),heltab2x4(:,:,195))
  call Hloop_Q_A(ntryL,G1H2(122),23,nMT,G2H2(52),n2h2(116))
  call Hloop_VQ_A(ntryL,G1H4(73),ex3(:),G1H2(126),m3h2x2(:,196),heltab2x4(:,:,196))
  call Hloop_Q_A(ntryL,G1H2(126),23,nMB,G2H2(54),n2h2(117))
  call Hloop_VQ_A(ntryL,G1H4(74),ex3(:),G1H2(127),m3h2x2(:,197),heltab2x4(:,:,197))
  call Hloop_Q_A(ntryL,G1H2(127),23,nMB,G2H2(55),n2h2(118))
  call Hloop_VQ_A(ntryL,G1H4(79),ex3(:),G1H2(128),m3h2x2(:,198),heltab2x4(:,:,198))
  call Hloop_Q_A(ntryL,G1H2(128),23,nMB,G2H2(57),n2h2(119))
  call Hloop_QA_V(ntryL,G1H4(91),ex4(:),G1H2(132),m3h2x2(:,199),heltab2x4(:,:,199))
  call Hloop_QA_S(ntryL,G1H4(83),ex4(:),G1H2(133),ngPbt,m3h2x2(:,200),heltab2x4(:,:,200))
  call Hloop_VA_Q(ntryL,G1H4(86),ex4(:),G1H2(134),m3h2x2(:,201),heltab2x4(:,:,201))
  call Hloop_A_Q(ntryL,G1H2(134),27,nMB,G2H2(64),n2h2(120))
  call Hloop_VA_Q(ntryL,G1H4(89),ex4(:),G1H2(138),m3h2x2(:,202),heltab2x4(:,:,202))
  call Hloop_A_Q(ntryL,G1H2(138),27,nMB,G2H2(66),n2h2(121))
  call Hloop_QA_W(ntryL,G1H4(90),ex4(:),G1H2(139),m3h2x2(:,203),heltab2x4(:,:,203))
  call Hloop_VA_Q(ntryL,G1H4(96),ex4(:),G1H2(140),m3h2x2(:,204),heltab2x4(:,:,204))
  call Hloop_A_Q(ntryL,G1H2(140),27,nMB,G2H2(61),n2h2(122))
  call Hloop_AQ_S(ntryL,G1H4(97),ex1(:),G1H2(144),ngH,m3h2x2(:,205),heltab2x4(:,:,205))
  call Hloop_AQ_S(ntryL,G1H4(98),ex1(:),G1H2(145),ngX,m3h2x2(:,206),heltab2x4(:,:,206))
  call Hloop_AQ_V(ntryL,G1H4(101),ex1(:),G1H2(146),m3h2x2(:,207),heltab2x4(:,:,207))
  call Hloop_AQ_V(ntryL,G1H4(109),ex1(:),G1H2(150),m3h2x2(:,208),heltab2x4(:,:,208))
  call Hloop_VQ_A(ntryL,G1H4(104),ex1(:),G1H2(151),m3h2x2(:,209),heltab2x4(:,:,209))
  call Hloop_Q_A(ntryL,G1H2(151),23,nMT,G2H2(63),n2h2(123))
  call Hloop_AQ_V(ntryL,G1H4(107),ex1(:),G1H2(152),m3h2x2(:,210),heltab2x4(:,:,210))
  call Hloop_AQ_Z(ntryL,G1H4(108),ex1(:),G1H2(156),ngZu,m3h2x2(:,211),heltab2x4(:,:,211))
  call Hloop_VQ_A(ntryL,G1H4(110),ex1(:),G1H2(157),m3h2x2(:,212),heltab2x4(:,:,212))
  call Hloop_Q_A(ntryL,G1H2(157),23,nMT,G2H2(67),n2h2(124))
  call Hloop_QA_V(ntryL,G1H4(114),ex2(:),G1H2(158),m3h2x2(:,213),heltab2x4(:,:,213))
  call Hloop_QA_V(ntryL,G1H4(121),ex2(:),G1H2(162),m3h2x2(:,214),heltab2x4(:,:,214))
  call Hloop_QA_S(ntryL,G1H4(116),ex2(:),G1H2(163),ngH,m3h2x2(:,215),heltab2x4(:,:,215))
  call Hloop_QA_S(ntryL,G1H4(119),ex2(:),G1H2(164),ngX,m3h2x2(:,216),heltab2x4(:,:,216))
  call Hloop_QA_V(ntryL,G1H4(120),ex2(:),G1H2(168),m3h2x2(:,217),heltab2x4(:,:,217))
  call Hloop_QA_Z(ntryL,G1H4(122),ex2(:),G1H2(169),ngZu,m3h2x2(:,218),heltab2x4(:,:,218))
  call Hloop_QA_V(ntryL,G1H4(128),ex4(:),G1H2(170),m3h2x2(:,219),heltab2x4(:,:,219))
  call Hloop_QA_S(ntryL,G1H4(126),ex4(:),G1H2(174),ngPbt,m3h2x2(:,220),heltab2x4(:,:,220))
  call Hloop_QA_W(ntryL,G1H4(127),ex4(:),G1H2(175),m3h2x2(:,221),heltab2x4(:,:,221))
  call Hloop_AQ_S(ntryL,G1H4(131),ex1(:),G1H2(176),ngH,m3h2x2(:,222),heltab2x4(:,:,222))
  call Hloop_AQ_S(ntryL,G1H4(132),ex1(:),G1H2(180),ngX,m3h2x2(:,223),heltab2x4(:,:,223))
  call Hloop_AQ_V(ntryL,G1H4(133),ex1(:),G1H2(181),m3h2x2(:,224),heltab2x4(:,:,224))
  call Hloop_AQ_V(ntryL,G1H4(139),ex1(:),G1H2(182),m3h2x2(:,225),heltab2x4(:,:,225))
  call Hloop_AQ_V(ntryL,G1H4(137),ex1(:),G1H2(186),m3h2x2(:,226),heltab2x4(:,:,226))
  call Hloop_AQ_Z(ntryL,G1H4(138),ex1(:),G1H2(187),ngZu,m3h2x2(:,227),heltab2x4(:,:,227))
  call Hloop_QA_V(ntryL,G1H4(140),ex2(:),G1H2(188),m3h2x2(:,228),heltab2x4(:,:,228))
  call Hloop_QA_V(ntryL,G1H4(7),ex2(:),G1H2(192),m3h2x2(:,229),heltab2x4(:,:,229))
  call Hloop_QA_S(ntryL,G1H4(144),ex2(:),G1H2(193),ngH,m3h2x2(:,230),heltab2x4(:,:,230))
  call Hloop_QA_S(ntryL,G1H4(1),ex2(:),G1H2(194),ngX,m3h2x2(:,231),heltab2x4(:,:,231))
  call Hloop_SA_Q(ntryL,G1H4(2),ex2(:),G1H2(198),ngPtb,m3h2x2(:,232),heltab2x4(:,:,232))
  call Hloop_A_Q(ntryL,G1H2(198),27,nMB,G2H2(69),n2h2(125))
  call Hloop_VA_Q(ntryL,G1H4(5),ex2(:),G1H2(199),m3h2x2(:,233),heltab2x4(:,:,233))
  call Hloop_A_Q(ntryL,G1H2(199),27,nMT,G2H2(76),n2h2(126))
  call Hloop_QA_V(ntryL,G1H4(6),ex2(:),G1H2(200),m3h2x2(:,234),heltab2x4(:,:,234))
  call Hloop_QA_Z(ntryL,G1H4(8),ex2(:),G1H2(204),ngZu,m3h2x2(:,235),heltab2x4(:,:,235))
  call Hloop_VA_Q(ntryL,G1H4(11),ex2(:),G1H2(205),m3h2x2(:,236),heltab2x4(:,:,236))
  call Hloop_A_Q(ntryL,G1H2(205),27,nMT,G2H2(78),n2h2(127))
  call Hloop_WA_Q(ntryL,G1H4(12),ex2(:),G1H2(206),m3h2x2(:,237),heltab2x4(:,:,237))
  call Hloop_A_Q(ntryL,G1H2(206),27,nMB,G2H2(73),n2h2(128))
  call Hloop_SQ_A(ntryL,G1H4(13),ex3(:),G1H2(210),ngPtb,m3h2x2(:,238),heltab2x4(:,:,238))
  call Hloop_Q_A(ntryL,G1H2(210),29,nMT,G2H2(75),n2h2(129))
  call Hloop_VQ_A(ntryL,G1H4(14),ex3(:),G1H2(211),m3h2x2(:,239),heltab2x4(:,:,239))
  call Hloop_Q_A(ntryL,G1H2(211),29,nMB,G2H2(79),n2h2(130))
  call Hloop_WQ_A(ntryL,G1H4(17),ex3(:),G1H2(212),m3h2x2(:,240),heltab2x4(:,:,240))
  call Hloop_Q_A(ntryL,G1H2(212),29,nMT,G2H2(81),n2h2(131))
  call Hloop_VQ_A(ntryL,G1H4(18),ex3(:),G1H2(216),m3h2x2(:,241),heltab2x4(:,:,241))
  call Hloop_Q_A(ntryL,G1H2(216),29,nMB,G2H2(88),n2h2(132))
  call Hloop_VQ_A(ntryL,G1H4(19),ex3(:),G1H2(217),m3h2x2(:,242),heltab2x4(:,:,242))
  call Hloop_Q_A(ntryL,G1H2(217),23,nMB,G2H2(90),n2h2(133))
call HGT_raise_alpha_OLR(G1H4(20),1,1,4)
call HGT_raise_alpha_invQ_OLR(G1H4(20),2,5,4)
  call Hloop_VA_Q(ntryL,G1H4(20),ex4(:),G1H2(218),m3h2x2(:,243),heltab2x4(:,:,243))
  call Hloop_VQ_A(ntryL,G1H4(24),ex3(:),G1H2(222),m3h2x2(:,244),heltab2x4(:,:,244))
  call Hloop_Q_A(ntryL,G1H2(222),23,nMB,G2H2(85),n2h2(134))
  call Hloop_VQ_A(ntryL,G1H4(25),ex3(:),G1H2(223),m3h2x2(:,245),heltab2x4(:,:,245))
  call Hloop_Q_A(ntryL,G1H2(223),23,nMB,G2H2(87),n2h2(135))
  call Hloop_VA_Q(ntryL,G1H4(26),ex4(:),G1H2(224),m3h2x2(:,246),heltab2x4(:,:,246))
  call Hloop_A_Q(ntryL,G1H2(224),27,nMB,G2H2(94),n2h2(136))
call HGT_raise_alpha_OLR(G1H4(29),1,1,4)
call HGT_raise_alpha_invQ_OLR(G1H4(29),2,5,4)
  call Hloop_VQ_A(ntryL,G1H4(29),ex3(:),G1H2(228),m3h2x2(:,247),heltab2x4(:,:,247))
  call Hloop_VA_Q(ntryL,G1H4(3),ex4(:),G1H2(229),m3h2x2(:,248),heltab2x4(:,:,248))
  call Hloop_A_Q(ntryL,G1H2(229),27,nMB,G2H2(96),n2h2(137))
  call Hloop_VA_Q(ntryL,G1H4(4),ex4(:),G1H2(230),m3h2x2(:,249),heltab2x4(:,:,249))
  call Hloop_A_Q(ntryL,G1H2(230),27,nMB,G2H2(100),n2h2(138))
  call Hloop_QS_A(ntryL,G1H8(71),wf4(:,3),G1H2(234),ngH,m3h4x2(:,3),heltab2x8(:,:,185))
  call Hloop_Q_A(ntryL,G1H2(234),23,nMB,G2H2(102),n2h2(139))
call HGT_raise_alpha_OLR(G1H8(45),1,1,8)
call HGT_raise_alpha_invQ_OLR(G1H8(45),2,5,8)
  call Hloop_VA_Q(ntryL,G1H8(45),ex4(:),G1H4(87),m3h2x4(:,183),heltab2x8(:,:,186))
  call Hloop_QS_A(ntryL,G1H8(2),wf4(:,3),G1H2(235),ngH,m3h4x2(:,4),heltab2x8(:,:,187))
  call Hloop_Q_A(ntryL,G1H2(235),23,nMB,G2H2(106),n2h2(140))
  call Hloop_QS_A(ntryL,G1H8(3),wf4(:,3),G1H2(236),ngH,m3h4x2(:,5),heltab2x8(:,:,188))
  call Hloop_Q_A(ntryL,G1H2(236),23,nMB,G2H2(108),n2h2(141))
  call Hloop_QS_A(ntryL,G1H8(8),wf4(:,6),G1H2(240),ngX,m3h4x2(:,6),heltab2x8(:,:,189))
  call Hloop_Q_A(ntryL,G1H2(240),23,nMB,G2H2(109),n2h2(142))
call HGT_raise_alpha_OLR(G1H8(6),1,1,8)
call HGT_raise_alpha_invQ_OLR(G1H8(6),2,5,8)
  call Hloop_VA_Q(ntryL,G1H8(6),ex4(:),G1H4(93),m3h2x4(:,184),heltab2x8(:,:,190))
  call Hloop_QS_A(ntryL,G1H8(9),wf4(:,6),G1H2(25),ngX,m3h4x2(:,7),heltab2x8(:,:,191))
  call Hloop_Q_A(ntryL,G1H2(25),23,nMB,G2H2(110),n2h2(143))
  call Hloop_QS_A(ntryL,G1H8(10),wf4(:,6),G1H2(26),ngX,m3h4x2(:,8),heltab2x8(:,:,192))
  call Hloop_Q_A(ntryL,G1H2(26),23,nMB,G2H2(111),n2h2(144))
  call Hloop_QV_A(ntryL,G1H8(11),wf4(:,1),G1H2(30),m3h4x2(:,9),heltab2x8(:,:,193))
  call Hloop_Q_A(ntryL,G1H2(30),23,nMB,G2H2(112),n2h2(145))
call HGT_raise_alpha_OLR(G1H8(12),1,1,8)
call HGT_raise_alpha_invQ_OLR(G1H8(12),2,5,8)
  call Hloop_VA_Q(ntryL,G1H8(12),ex4(:),G1H4(99),m3h2x4(:,185),heltab2x8(:,:,194))
  call Hloop_QV_A(ntryL,G1H8(15),wf4(:,1),G1H2(31),m3h4x2(:,10),heltab2x8(:,:,195))
  call Hloop_Q_A(ntryL,G1H2(31),23,nMB,G2H2(113),n2h2(146))
  call Hloop_QV_A(ntryL,G1H8(16),wf4(:,1),G1H2(32),m3h4x2(:,11),heltab2x8(:,:,196))
  call Hloop_Q_A(ntryL,G1H2(32),23,nMB,G2H2(114),n2h2(147))
  call Hloop_QZ_A(ntryL,G1H8(18),wf4(:,7),G1H2(36),ngZd,m3h4x2(:,12),heltab2x8(:,:,197))
  call Hloop_Q_A(ntryL,G1H2(36),23,nMB,G2H2(115),n2h2(148))
call HGT_raise_alpha_OLR(G1H8(19),1,1,8)
call HGT_raise_alpha_invQ_OLR(G1H8(19),2,5,8)
  call Hloop_VA_Q(ntryL,G1H8(19),ex4(:),G1H4(105),m3h2x4(:,186),heltab2x8(:,:,198))
  call Hloop_QZ_A(ntryL,G1H8(21),wf4(:,7),G1H2(37),ngZd,m3h4x2(:,13),heltab2x8(:,:,199))
  call Hloop_Q_A(ntryL,G1H2(37),23,nMB,G2H2(116),n2h2(149))
  call Hloop_QZ_A(ntryL,G1H8(22),wf4(:,7),G1H2(38),ngZd,m3h4x2(:,14),heltab2x8(:,:,200))
  call Hloop_Q_A(ntryL,G1H2(38),23,nMB,G2H2(117),n2h2(150))
  call Hloop_QS_A(ntryL,G1H8(23),wf4(:,11),G1H2(42),ngPbt,m3h4x2(:,15),heltab2x8(:,:,201))
  call Hloop_Q_A(ntryL,G1H2(42),23,nMB,G2H2(118),n2h2(151))
call HGT_raise_alpha_OLR(G1H8(24),1,1,8)
call HGT_raise_alpha_invQ_OLR(G1H8(24),2,5,8)
  call Hloop_VA_Q(ntryL,G1H8(24),ex4(:),G1H4(111),m3h2x4(:,187),heltab2x8(:,:,202))
  call Hloop_QS_A(ntryL,G1H8(30),wf4(:,11),G1H2(43),ngPbt,m3h4x2(:,16),heltab2x8(:,:,203))
  call Hloop_Q_A(ntryL,G1H2(43),23,nMB,G2H2(119),n2h2(152))
  call Hloop_QS_A(ntryL,G1H8(28),wf4(:,11),G1H2(44),ngPbt,m3h4x2(:,17),heltab2x8(:,:,204))
  call Hloop_Q_A(ntryL,G1H2(44),23,nMB,G2H2(120),n2h2(153))
  call Hloop_QW_A(ntryL,G1H8(29),wf4(:,13),G1H2(48),m3h4x2(:,18),heltab2x8(:,:,205))
  call Hloop_Q_A(ntryL,G1H2(48),23,nMB,G2H2(121),n2h2(154))
call HGT_raise_alpha_OLR(G1H8(31),1,1,8)
call HGT_raise_alpha_invQ_OLR(G1H8(31),2,5,8)
  call Hloop_VA_Q(ntryL,G1H8(31),ex4(:),G1H4(117),m3h2x4(:,188),heltab2x8(:,:,206))
  call Hloop_QW_A(ntryL,G1H8(33),wf4(:,13),G1H2(49),m3h4x2(:,19),heltab2x8(:,:,207))
  call Hloop_Q_A(ntryL,G1H2(49),23,nMB,G2H2(122),n2h2(155))
  call Hloop_QW_A(ntryL,G1H8(34),wf4(:,13),G1H2(50),m3h4x2(:,20),heltab2x8(:,:,208))
  call Hloop_Q_A(ntryL,G1H2(50),23,nMB,G2H2(123),n2h2(156))
  call Hloop_AS_Q(ntryL,G1H8(39),wf4(:,14),G1H2(54),ngPtb,m3h4x2(:,21),heltab2x8(:,:,209))
  call Hloop_A_Q(ntryL,G1H2(54),27,nMB,G2H2(124),n2h2(157))
call HGT_raise_alpha_OLR(G1H8(37),1,1,8)
call HGT_raise_alpha_invQ_OLR(G1H8(37),2,5,8)
  call Hloop_VQ_A(ntryL,G1H8(37),ex3(:),G1H4(32),m3h2x4(:,189),heltab2x8(:,:,210))
  call Hloop_AS_Q(ntryL,G1H8(40),wf4(:,14),G1H2(55),ngPtb,m3h4x2(:,22),heltab2x8(:,:,211))
  call Hloop_A_Q(ntryL,G1H2(55),27,nMB,G2H2(125),n2h2(158))
  call Hloop_AS_Q(ntryL,G1H8(41),wf4(:,14),G1H2(56),ngPtb,m3h4x2(:,23),heltab2x8(:,:,212))
  call Hloop_A_Q(ntryL,G1H2(56),27,nMB,G2H2(126),n2h2(159))
  call Hloop_AW_Q(ntryL,G1H8(42),wf4(:,17),G1H2(60),m3h4x2(:,24),heltab2x8(:,:,213))
  call Hloop_A_Q(ntryL,G1H2(60),27,nMB,G2H2(127),n2h2(160))
call HGT_raise_alpha_OLR(G1H8(43),1,1,8)
call HGT_raise_alpha_invQ_OLR(G1H8(43),2,5,8)
  call Hloop_VQ_A(ntryL,G1H8(43),ex3(:),G1H4(37),m3h2x4(:,190),heltab2x8(:,:,214))
  call Hloop_AW_Q(ntryL,G1H8(46),wf4(:,17),G1H2(61),m3h4x2(:,25),heltab2x8(:,:,215))
  call Hloop_A_Q(ntryL,G1H2(61),27,nMB,G2H2(128),n2h2(161))
  call Hloop_AW_Q(ntryL,G1H8(47),wf4(:,17),G1H2(62),m3h4x2(:,26),heltab2x8(:,:,216))
  call Hloop_A_Q(ntryL,G1H2(62),27,nMB,G2H2(129),n2h2(162))
  call Hloop_QS_A(ntryL,G1H8(48),wf4(:,18),G1H2(66),ngH,m3h4x2(:,27),heltab2x8(:,:,217))
  call Hloop_Q_A(ntryL,G1H2(66),29,nMT,G2H2(130),n2h2(163))
call HGT_raise_alpha_OLR(G1H8(49),1,1,8)
call HGT_raise_alpha_invQ_OLR(G1H8(49),2,5,8)
  call Hloop_VA_Q(ntryL,G1H8(49),ex2(:),G1H4(80),m3h2x4(:,191),heltab2x8(:,:,218))
  call Hloop_QS_A(ntryL,G1H8(51),wf4(:,18),G1H2(67),ngH,m3h4x2(:,28),heltab2x8(:,:,219))
  call Hloop_Q_A(ntryL,G1H2(67),29,nMT,G2H2(131),n2h2(164))
  call Hloop_QS_A(ntryL,G1H8(52),wf4(:,18),G1H2(68),ngH,m3h4x2(:,29),heltab2x8(:,:,220))
  call Hloop_Q_A(ntryL,G1H2(68),29,nMT,G2H2(132),n2h2(165))
  call Hloop_QS_A(ntryL,G1H8(14),wf4(:,19),G1H2(72),ngX,m3h4x2(:,30),heltab2x8(:,:,221))
  call Hloop_Q_A(ntryL,G1H2(72),29,nMT,G2H2(133),n2h2(166))
call HGT_raise_alpha_OLR(G1H8(26),1,1,8)
call HGT_raise_alpha_invQ_OLR(G1H8(26),2,5,8)
  call Hloop_VA_Q(ntryL,G1H8(26),ex2(:),G1H4(102),m3h2x4(:,192),heltab2x8(:,:,222))
  call Hloop_QS_A(ntryL,G1H8(4),wf4(:,19),G1H2(73),ngX,m3h4x2(:,31),heltab2x8(:,:,223))
  call Hloop_Q_A(ntryL,G1H2(73),29,nMT,G2H2(134),n2h2(167))
  call Hloop_QS_A(ntryL,G1H8(13),wf4(:,19),G1H2(74),ngX,m3h4x2(:,32),heltab2x8(:,:,224))
  call Hloop_Q_A(ntryL,G1H2(74),29,nMT,G2H2(135),n2h2(168))
  call Hloop_QV_A(ntryL,G1H8(27),wf4(:,2),G1H2(78),m3h4x2(:,33),heltab2x8(:,:,225))
  call Hloop_Q_A(ntryL,G1H2(78),29,nMT,G2H2(136),n2h2(169))
call HGT_raise_alpha_OLR(G1H8(35),1,1,8)
call HGT_raise_alpha_invQ_OLR(G1H8(35),2,5,8)
  call Hloop_VA_Q(ntryL,G1H8(35),ex2(:),G1H4(115),m3h2x4(:,193),heltab2x8(:,:,226))
  call Hloop_QV_A(ntryL,G1H8(53),wf4(:,2),G1H2(79),m3h4x2(:,34),heltab2x8(:,:,227))
  call Hloop_Q_A(ntryL,G1H2(79),29,nMT,G2H2(137),n2h2(170))
  call Hloop_QV_A(ntryL,G1H8(54),wf4(:,2),G1H2(80),m3h4x2(:,35),heltab2x8(:,:,228))
  call Hloop_Q_A(ntryL,G1H2(80),29,nMT,G2H2(138),n2h2(171))
  call Hloop_QZ_A(ntryL,G1H8(55),wf4(:,20),G1H2(84),ngZu,m3h4x2(:,36),heltab2x8(:,:,229))
  call Hloop_Q_A(ntryL,G1H2(84),29,nMT,G2H2(139),n2h2(172))
call HGT_raise_alpha_OLR(G1H8(56),1,1,8)
call HGT_raise_alpha_invQ_OLR(G1H8(56),2,5,8)
  call Hloop_VA_Q(ntryL,G1H8(56),ex2(:),G1H4(125),m3h2x4(:,194),heltab2x8(:,:,230))
  call Hloop_QZ_A(ntryL,G1H8(58),wf4(:,20),G1H2(85),ngZu,m3h4x2(:,37),heltab2x8(:,:,231))
  call Hloop_Q_A(ntryL,G1H2(85),29,nMT,G2H2(140),n2h2(173))
  call Hloop_QZ_A(ntryL,G1H8(59),wf4(:,20),G1H2(86),ngZu,m3h4x2(:,38),heltab2x8(:,:,232))
  call Hloop_Q_A(ntryL,G1H2(86),29,nMT,G2H2(141),n2h2(174))
call HGT_w2_OLR(G1H2(1),1,1,2)
call HGT_w2_invQ_OLR(G1H2(1),2,5,2)
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(1),[G1H2(176)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(95),[G2H2(92),G2H2(47),G2H2(44),G2H2(41),G2H2(38)])
call HGT_w2_OLR(G1H2(2),1,1,2)
call HGT_w2_invQ_OLR(G1H2(2),2,5,2)
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(2),[G1H2(180)])
call HGT_w2_OLR(G1H2(3),1,1,2)
call HGT_w2_invQ_OLR(G1H2(3),2,5,2)
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(3),[G1H2(186)])
call HGT_w2_OLR(G1H2(4),1,1,2)
call HGT_w2_invQ_OLR(G1H2(4),2,5,2)
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(4),[G1H2(187)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(115),[G2H2(112),G2H2(109),G2H2(102),G2H2(53),G2H2(50)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(144),[G1H2(63)])
call HGT_w2_OLR(G1H2(7),1,1,2)
call HGT_w2_invQ_OLR(G1H2(7),2,5,2)
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(7),[G1H2(144)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(127),[G2H2(124),G2H2(65),G2H2(62),G2H2(59),G2H2(56)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(145),[G1H2(69)])
call HGT_w2_OLR(G1H2(8),1,1,2)
call HGT_w2_invQ_OLR(G1H2(8),2,5,2)
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(8),[G1H2(145)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(152),[G1H2(87)])
call HGT_w2_OLR(G1H2(9),1,1,2)
call HGT_w2_invQ_OLR(G1H2(9),2,5,2)
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(9),[G1H2(152)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(156),[G1H2(93)])
call HGT_w2_OLR(G1H2(10),1,1,2)
call HGT_w2_invQ_OLR(G1H2(10),2,5,2)
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(10),[G1H2(156)])
call HGT_w2_OLR(G1H2(11),1,1,2)
call HGT_w2_invQ_OLR(G1H2(11),2,5,2)
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(11),[G1H2(193)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(121),[G2H2(118),G2H2(77),G2H2(74),G2H2(71),G2H2(68)])
call HGT_w2_OLR(G1H2(12),1,1,2)
call HGT_w2_invQ_OLR(G1H2(12),2,5,2)
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(12),[G1H2(194)])
call HGT_w2_OLR(G1H2(13),1,1,2)
call HGT_w2_invQ_OLR(G1H2(13),2,5,2)
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(13),[G1H2(200)])
call HGT_w2_OLR(G1H2(14),1,1,2)
call HGT_w2_invQ_OLR(G1H2(14),2,5,2)
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(14),[G1H2(204)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(163),[G1H2(39)])
call HGT_w2_OLR(G1H2(15),1,1,2)
call HGT_w2_invQ_OLR(G1H2(15),2,5,2)
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(15),[G1H2(163)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(101),[G2H2(98),G2H2(89),G2H2(86),G2H2(83),G2H2(80)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(164),[G1H2(45)])
call HGT_w2_OLR(G1H2(16),1,1,2)
call HGT_w2_invQ_OLR(G1H2(16),2,5,2)
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(16),[G1H2(164)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(168),[G1H2(51)])
call HGT_w2_OLR(G1H2(17),1,1,2)
call HGT_w2_invQ_OLR(G1H2(17),2,5,2)
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(17),[G1H2(168)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(169),[G1H2(57)])
call HGT_w2_OLR(G1H2(18),1,1,2)
call HGT_w2_invQ_OLR(G1H2(18),2,5,2)
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(18),[G1H2(169)])
call HGT_w2_OLR(G1H2(21),1,1,2)
call HGT_w2_invQ_OLR(G1H2(21),2,5,2)
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(21),[G1H2(174)])
call HGT_w2_OLR(G1H2(22),1,1,2)
call HGT_w2_invQ_OLR(G1H2(22),2,5,2)
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(22),[G1H2(175)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(133),[G1H2(105)])
call HGT_w2_OLR(G1H2(23),1,1,2)
call HGT_w2_invQ_OLR(G1H2(23),2,5,2)
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(23),[G1H2(133)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(139),[G2H2(136),G2H2(133),G2H2(130),G2H2(107) &
    ,G2H2(104)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(139),[G1H2(111)])
call HGT_w2_OLR(G1H2(24),1,1,2)
call HGT_w2_invQ_OLR(G1H2(24),2,5,2)
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(24),[G1H2(139)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(158),[G1H2(27)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(154),[G1H2(52),G1H2(34),G1H2(28)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(77),[G1H2(29)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(162),[G1H2(33)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(83),[G1H2(35)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(65),[G1H2(41)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(71),[G1H2(47)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(33),[G1H2(89),G1H2(53)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(95),[G1H2(59)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(146),[G1H2(75)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(34),[G1H2(88),G1H2(82),G1H2(76)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(150),[G1H2(81)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(132),[G1H2(99)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(21),[G1H2(100)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(143),[G1H2(101)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(24),[G1H2(106)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(137),[G1H2(107)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(26),[G1H2(112)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(149),[G1H2(113)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(103),[G1H2(117)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(27),[G1H2(118)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(155),[G1H2(119)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(104),[G1H2(123)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(30),[G1H2(124)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(161),[G1H2(125)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(110),[G1H2(129)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(32),[G1H2(130)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(167),[G1H2(131)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(98),[G1H2(153)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(97),[G1H2(159)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(102),[G1H2(165)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(196),[G1H2(178),G1H2(172)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(209),[G1H2(173)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(215),[G1H2(179)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(221),[G1H2(185)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(227),[G1H2(191)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(35),[G1H2(233),G1H2(197)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(239),[G1H2(203)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(232),[G1H2(214),G1H2(208)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(60),[G2H2(49)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(70),[G2H2(51)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(84),[G2H2(72)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(91),[G2H2(82)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(1),[G2H2(99)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(2),[G2H2(103)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(6),[G2H2(4)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(10),[G2H2(8)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(12),[G2H2(11)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(15),[G2H2(13)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(16),[G2H2(14)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(19),[G2H2(17)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(20),[G2H2(18)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(31),[G2H4(27)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(33),[G2H4(28)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(42),[G2H4(38)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(43),[G2H4(39)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(73),[G2H2(69)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(81),[G2H2(75)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(117),[G2H2(114),G2H2(111),G2H2(108)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(123),[G2H2(120)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(129),[G2H2(126)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(141),[G2H2(138),G2H2(135),G2H2(132)])
  call Hloop_SQ_A(ntryL,G1H2(1),ex3(:),G1H1(1),ngH,m3h2x1(:,141),heltab2x2(:,:,141))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,nMB,G2tensor(42),n2h1(109))
  call Hcheck_last_QA_V(ntryL,l_switch,G2H2(95),ex4(:),G2tensor(54),m3h2x1(:,142),heltab2x2(:,:,142))
  call Hloop_SQ_A(ntryL,G1H2(2),ex3(:),G1H1(1),ngX,m3h2x1(:,143),heltab2x2(:,:,143))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,nMB,G2tensor(72),n2h1(110))
  call Hloop_VQ_A(ntryL,G1H2(3),ex3(:),G1H1(1),m3h2x1(:,144),heltab2x2(:,:,144))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,nMB,G2tensor(81),n2h1(111))
  call Hloop_ZQ_A(ntryL,G1H2(4),ex3(:),G1H1(1),ngZd,m3h2x1(:,145),heltab2x2(:,:,145))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,nMB,G2tensor(87),n2h1(112))
call HGT_w2_OLR(G1H2(5),1,1,2)
call HGT_w2_invQ_OLR(G1H2(5),2,5,2)
  call Hloop_SQ_A(ntryL,G1H2(5),ex1(:),G1H1(1),ngPbt,m3h2x1(:,146),heltab2x2(:,:,146))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,nMB,G2tensor(99),n2h1(113))
  call Hcheck_last_QA_V(ntryL,l_switch,G2H2(115),ex4(:),G2tensor(114),m3h2x1(:,147),heltab2x2(:,:,147))
call HGT_w2_OLR(G1H2(6),1,1,2)
call HGT_w2_invQ_OLR(G1H2(6),2,5,2)
  call Hloop_WQ_A(ntryL,G1H2(6),ex1(:),G1H1(1),m3h2x1(:,148),heltab2x2(:,:,148))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,nMB,G2tensor(132),n2h1(114))
  call Hloop_SA_Q(ntryL,G1H2(7),ex4(:),G1H1(1),ngH,m3h2x1(:,149),heltab2x2(:,:,149))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,nMB,G2tensor(1),n2h1(115))
  call Hcheck_last_AQ_V(ntryL,l_switch,G2H2(127),ex3(:),G2tensor(3),m3h2x1(:,150),heltab2x2(:,:,150))
  call Hloop_SA_Q(ntryL,G1H2(8),ex4(:),G1H1(1),ngX,m3h2x1(:,151),heltab2x2(:,:,151))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,nMB,G2tensor(5),n2h1(116))
  call Hloop_VA_Q(ntryL,G1H2(9),ex4(:),G1H1(1),m3h2x1(:,152),heltab2x2(:,:,152))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,nMB,G2tensor(7),n2h1(117))
  call Hloop_ZA_Q(ntryL,G1H2(10),ex4(:),G1H1(1),ngZd,m3h2x1(:,153),heltab2x2(:,:,153))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,nMB,G2tensor(9),n2h1(118))
  call Hloop_SQ_A(ntryL,G1H2(11),ex3(:),G1H1(1),ngH,m3h2x1(:,154),heltab2x2(:,:,154))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,nMB,G2tensor(11),n2h1(119))
  call Hcheck_last_QA_V(ntryL,l_switch,G2H2(121),ex4(:),G2tensor(13),m3h2x1(:,155),heltab2x2(:,:,155))
  call Hloop_SQ_A(ntryL,G1H2(12),ex3(:),G1H1(1),ngX,m3h2x1(:,156),heltab2x2(:,:,156))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,nMB,G2tensor(15),n2h1(120))
  call Hloop_VQ_A(ntryL,G1H2(13),ex3(:),G1H1(1),m3h2x1(:,157),heltab2x2(:,:,157))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,nMB,G2tensor(17),n2h1(121))
  call Hloop_ZQ_A(ntryL,G1H2(14),ex3(:),G1H1(1),ngZd,m3h2x1(:,158),heltab2x2(:,:,158))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,nMB,G2tensor(19),n2h1(122))
  call Hloop_SA_Q(ntryL,G1H2(15),ex4(:),G1H1(1),ngH,m3h2x1(:,159),heltab2x2(:,:,159))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,nMB,G2tensor(21),n2h1(123))
  call Hcheck_last_AQ_V(ntryL,l_switch,G2H2(101),ex3(:),G2tensor(23),m3h2x1(:,160),heltab2x2(:,:,160))
  call Hloop_SA_Q(ntryL,G1H2(16),ex4(:),G1H1(1),ngX,m3h2x1(:,161),heltab2x2(:,:,161))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,nMB,G2tensor(25),n2h1(124))
  call Hloop_VA_Q(ntryL,G1H2(17),ex4(:),G1H1(1),m3h2x1(:,162),heltab2x2(:,:,162))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,nMB,G2tensor(27),n2h1(125))
  call Hloop_ZA_Q(ntryL,G1H2(18),ex4(:),G1H1(1),ngZd,m3h2x1(:,163),heltab2x2(:,:,163))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,nMB,G2tensor(29),n2h1(126))
call HGT_w2_OLR(G1H2(19),1,1,2)
call HGT_w2_invQ_OLR(G1H2(19),2,5,2)
  call Hloop_SQ_A(ntryL,G1H2(19),ex1(:),G1H1(1),ngPbt,m3h2x1(:,164),heltab2x2(:,:,164))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,nMB,G2tensor(31),n2h1(127))
call HGT_w2_OLR(G1H2(20),1,1,2)
call HGT_w2_invQ_OLR(G1H2(20),2,5,2)
  call Hloop_WQ_A(ntryL,G1H2(20),ex1(:),G1H1(1),m3h2x1(:,165),heltab2x2(:,:,165))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,nMB,G2tensor(33),n2h1(128))
  call Hloop_SA_Q(ntryL,G1H2(21),ex2(:),G1H1(1),ngPtb,m3h2x1(:,166),heltab2x2(:,:,166))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,nMB,G2tensor(36),n2h1(129))
  call Hloop_WA_Q(ntryL,G1H2(22),ex2(:),G1H1(1),m3h2x1(:,167),heltab2x2(:,:,167))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,nMB,G2tensor(39),n2h1(130))
  call Hloop_SQ_A(ntryL,G1H2(23),ex3(:),G1H1(1),ngPtb,m3h2x1(:,168),heltab2x2(:,:,168))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,nMT,G2tensor(48),n2h1(131))
  call Hcheck_last_QA_V(ntryL,l_switch,G2H2(139),ex2(:),G2tensor(45),m3h2x1(:,169),heltab2x2(:,:,169))
  call Hloop_WQ_A(ntryL,G1H2(24),ex3(:),G1H1(1),m3h2x1(:,170),heltab2x2(:,:,170))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,nMT,G2tensor(51),n2h1(132))
  call Hloop_VA_Q(ntryL,G1H2(158),ex4(:),G1H1(1),m3h2x1(:,171),heltab2x2(:,:,171))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,nMB,G2tensor(66),n2h1(133))
  call Hloop_VA_Q(ntryL,G1H2(154),ex4(:),G1H1(1),m3h2x1(:,172),heltab2x2(:,:,172))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,nMB,G2tensor(57),n2h1(134))
  call Hloop_VA_Q(ntryL,G1H2(77),ex4(:),G1H1(1),m3h2x1(:,173),heltab2x2(:,:,173))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,nMB,G2tensor(60),n2h1(135))
  call Hloop_VA_Q(ntryL,G1H2(162),ex4(:),G1H1(1),m3h2x1(:,174),heltab2x2(:,:,174))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,nMB,G2tensor(63),n2h1(136))
  call Hloop_VA_Q(ntryL,G1H2(83),ex4(:),G1H1(1),m3h2x1(:,175),heltab2x2(:,:,175))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,nMB,G2tensor(69),n2h1(137))
  call Hloop_SA_Q(ntryL,G1H2(40),ex4(:),G1H1(1),ngH,m3h2x1(:,176),heltab2x2(:,:,176))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,nMB,G2tensor(75),n2h1(138))
  call Hloop_SA_Q(ntryL,G1H2(65),ex4(:),G1H1(1),ngH,m3h2x1(:,177),heltab2x2(:,:,177))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,nMB,G2tensor(78),n2h1(139))
  call Hloop_SA_Q(ntryL,G1H2(46),ex4(:),G1H1(1),ngX,m3h2x1(:,178),heltab2x2(:,:,178))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,nMB,G2tensor(84),n2h1(140))
  call Hloop_SA_Q(ntryL,G1H2(71),ex4(:),G1H1(1),ngX,m3h2x1(:,179),heltab2x2(:,:,179))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,nMB,G2tensor(93),n2h1(141))
  call Hotf_4pt_reduction(G2H2(33),RedSet_4(8),mass4set(:,5),  & 
G1H2(90),G1H2(91),G1H2(92),G1H2(96),G1H2(108),2)
  call HG1shiftOLR(G1H2(91),8,2)
  call Hloop_ZA_Q(ntryL,G1H2(58),ex4(:),G1H1(1),ngZd,m3h2x1(:,180),heltab2x2(:,:,180))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,nMB,G2tensor(90),n2h1(142))
  call Hloop_ZA_Q(ntryL,G1H2(95),ex4(:),G1H1(1),ngZd,m3h2x1(:,181),heltab2x2(:,:,181))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,nMB,G2tensor(96),n2h1(143))
  call Hloop_SA_Q(ntryL,G1H2(64),ex4(:),G1H1(1),ngH,m3h2x1(:,182),heltab2x2(:,:,182))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,nMB,G2tensor(102),n2h1(144))
  call Hloop_SA_Q(ntryL,G1H2(70),ex4(:),G1H1(1),ngX,m3h2x1(:,183),heltab2x2(:,:,183))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,nMB,G2tensor(105),n2h1(145))
  call Hloop_VA_Q(ntryL,G1H2(146),ex4(:),G1H1(1),m3h2x1(:,184),heltab2x2(:,:,184))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,nMB,G2tensor(108),n2h1(146))
  call Hotf_4pt_reduction(G2H2(34),RedSet_4(7),mass4set(:,6),  & 
G1H2(109),G1H2(114),G1H2(115),G1H2(116),G1H2(120),2)
  call HG1shiftOLR(G1H2(114),8,2)
  call Hloop_VA_Q(ntryL,G1H2(150),ex4(:),G1H1(1),m3h2x1(:,185),heltab2x2(:,:,185))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,nMB,G2tensor(111),n2h1(147))
  call Hloop_ZA_Q(ntryL,G1H2(94),ex4(:),G1H1(1),ngZd,m3h2x1(:,186),heltab2x2(:,:,186))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,nMB,G2tensor(120),n2h1(148))
  call Hloop_VQ_A(ntryL,G1H2(132),ex3(:),G1H1(1),m3h2x1(:,187),heltab2x2(:,:,187))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,nMB,G2tensor(117),n2h1(149))
  call Hotf_4pt_reduction(G2H2(21),RedSet_4(12),mass4set(:,7),  & 
G1H2(121),G1H2(122),G1H2(126),G1H2(127),G1H2(128),2)
  call HG1shiftOLR(G1H2(122),4,2)
  call Hloop_VQ_A(ntryL,G1H2(143),ex3(:),G1H1(1),m3h2x1(:,188),heltab2x2(:,:,188))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,nMB,G2tensor(123),n2h1(150))
  call Hotf_4pt_reduction(G2H2(24),RedSet_4(12),mass4set(:,8),  & 
G1H2(134),G1H2(138),G1H2(140),G1H2(151),G1H2(157),2)
  call HG1shiftOLR(G1H2(138),4,2)
  call Hloop_SQ_A(ntryL,G1H2(137),ex3(:),G1H1(1),ngPtb,m3h2x1(:,189),heltab2x2(:,:,189))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,nMT,G2tensor(126),n2h1(151))
  call Hotf_4pt_reduction(G2H2(26),RedSet_4(12),mass4set(:,8),  & 
G1H2(198),G1H2(199),G1H2(205),G1H2(206),G1H2(210),2)
  call HG1shiftOLR(G1H2(199),4,2)
  call Hloop_WQ_A(ntryL,G1H2(149),ex3(:),G1H1(1),m3h2x1(:,190),heltab2x2(:,:,190))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,nMT,G2tensor(129),n2h1(152))
  call Hloop_VA_Q(ntryL,G1H2(103),ex4(:),G1H1(1),m3h2x1(:,191),heltab2x2(:,:,191))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,nMB,G2tensor(138),n2h1(153))
  call Hotf_4pt_reduction(G2H2(27),RedSet_4(2),mass4set(:,7),  & 
G1H2(211),G1H2(212),G1H2(216),G1H2(217),G1H2(222),2)
  call HG1shiftOLR(G1H2(212),8,2)
  call Hloop_VA_Q(ntryL,G1H2(155),ex4(:),G1H1(1),m3h2x1(:,192),heltab2x2(:,:,192))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,nMB,G2tensor(135),n2h1(154))
  call Hloop_SA_Q(ntryL,G1H2(104),ex4(:),G1H1(1),ngPbt,m3h2x1(:,193),heltab2x2(:,:,193))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,nMT,G2tensor(141),n2h1(155))
  call Hotf_4pt_reduction(G2H2(30),RedSet_4(2),mass4set(:,8),  & 
G1H2(223),G1H2(224),G1H2(229),G1H2(230),G1H2(234),2)
  call HG1shiftOLR(G1H2(224),8,2)
  call Hloop_SA_Q(ntryL,G1H2(161),ex4(:),G1H1(1),ngPbt,m3h2x1(:,194),heltab2x2(:,:,194))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,nMT,G2tensor(142),n2h1(156))
  call Hloop_WA_Q(ntryL,G1H2(110),ex4(:),G1H1(1),m3h2x1(:,195),heltab2x2(:,:,195))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,nMT,G2tensor(143),n2h1(157))
  call Hotf_4pt_reduction(G2H2(32),RedSet_4(2),mass4set(:,8),  & 
G1H2(235),G1H2(236),G1H2(240),G1H2(25),G1H2(26),2)
  call HG1shiftOLR(G1H2(236),8,2)
  call Hloop_WA_Q(ntryL,G1H2(167),ex4(:),G1H1(1),m3h2x1(:,196),heltab2x2(:,:,196))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,nMT,G2tensor(144),n2h1(158))
  call Hloop_SQ_A(ntryL,G1H2(135),ex3(:),G1H1(1),ngPtb,m3h2x1(:,197),heltab2x2(:,:,197))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,nMT,G2tensor(145),n2h1(159))
  call Hloop_SQ_A(ntryL,G1H2(136),ex3(:),G1H1(1),ngPtb,m3h2x1(:,198),heltab2x2(:,:,198))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,nMT,G2tensor(146),n2h1(160))
  call Hloop_VQ_A(ntryL,G1H2(141),ex3(:),G1H1(1),m3h2x1(:,199),heltab2x2(:,:,199))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,nMB,G2tensor(147),n2h1(161))
  call Hloop_VQ_A(ntryL,G1H2(142),ex3(:),G1H1(1),m3h2x1(:,200),heltab2x2(:,:,200))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,nMB,G2tensor(148),n2h1(162))
  call Hloop_WQ_A(ntryL,G1H2(147),ex3(:),G1H1(1),m3h2x1(:,201),heltab2x2(:,:,201))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,nMT,G2tensor(149),n2h1(163))
  call Hloop_WQ_A(ntryL,G1H2(148),ex3(:),G1H1(1),m3h2x1(:,202),heltab2x2(:,:,202))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,nMT,G2tensor(150),n2h1(164))
  call Hloop_VA_Q(ntryL,G1H2(98),ex4(:),G1H1(1),m3h2x1(:,203),heltab2x2(:,:,203))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,nMB,G2tensor(151),n2h1(165))
  call Hloop_SA_Q(ntryL,G1H2(97),ex4(:),G1H1(1),ngPbt,m3h2x1(:,204),heltab2x2(:,:,204))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,nMT,G2tensor(152),n2h1(166))
  call Hloop_SA_Q(ntryL,G1H2(160),ex4(:),G1H1(1),ngPbt,m3h2x1(:,205),heltab2x2(:,:,205))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,nMT,G2tensor(153),n2h1(167))
  call Hloop_WA_Q(ntryL,G1H2(102),ex4(:),G1H1(1),m3h2x1(:,206),heltab2x2(:,:,206))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,nMT,G2tensor(154),n2h1(168))
  call Hloop_WA_Q(ntryL,G1H2(166),ex4(:),G1H1(1),m3h2x1(:,207),heltab2x2(:,:,207))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,nMT,G2tensor(155),n2h1(169))
  call Hloop_VA_Q(ntryL,G1H2(171),ex2(:),G1H1(1),m3h2x1(:,208),heltab2x2(:,:,208))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,nMT,G2tensor(156),n2h1(170))
  call Hloop_VA_Q(ntryL,G1H2(196),ex2(:),G1H1(1),m3h2x1(:,209),heltab2x2(:,:,209))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,nMT,G2tensor(157),n2h1(171))
  call Hloop_VA_Q(ntryL,G1H2(209),ex2(:),G1H1(1),m3h2x1(:,210),heltab2x2(:,:,210))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,nMT,G2tensor(158),n2h1(172))
  call Hloop_VA_Q(ntryL,G1H2(177),ex2(:),G1H1(1),m3h2x1(:,211),heltab2x2(:,:,211))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,nMT,G2tensor(159),n2h1(173))
  call Hloop_VA_Q(ntryL,G1H2(215),ex2(:),G1H1(1),m3h2x1(:,212),heltab2x2(:,:,212))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,nMT,G2tensor(160),n2h1(174))
  call Hloop_SA_Q(ntryL,G1H2(183),ex2(:),G1H1(1),ngH,m3h2x1(:,213),heltab2x2(:,:,213))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,nMT,G2tensor(161),n2h1(175))
  call Hloop_SA_Q(ntryL,G1H2(184),ex2(:),G1H1(1),ngH,m3h2x1(:,214),heltab2x2(:,:,214))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,nMT,G2tensor(162),n2h1(176))
  call Hloop_SA_Q(ntryL,G1H2(221),ex2(:),G1H1(1),ngH,m3h2x1(:,215),heltab2x2(:,:,215))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,nMT,G2tensor(163),n2h1(177))
  call Hloop_SA_Q(ntryL,G1H2(189),ex2(:),G1H1(1),ngX,m3h2x1(:,216),heltab2x2(:,:,216))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,nMT,G2tensor(164),n2h1(178))
  call Hloop_SA_Q(ntryL,G1H2(190),ex2(:),G1H1(1),ngX,m3h2x1(:,217),heltab2x2(:,:,217))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,nMT,G2tensor(165),n2h1(179))
  call Hloop_SA_Q(ntryL,G1H2(227),ex2(:),G1H1(1),ngX,m3h2x1(:,218),heltab2x2(:,:,218))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,nMT,G2tensor(166),n2h1(180))
  call Hloop_VA_Q(ntryL,G1H2(195),ex2(:),G1H1(1),m3h2x1(:,219),heltab2x2(:,:,219))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,nMT,G2tensor(167),n2h1(181))
  call Hotf_4pt_reduction(G2H2(35),RedSet_4(31),mass4set(:,9),  & 
G1H2(30),G1H2(31),G1H2(32),G1H2(36),G1H2(37),2)
  call HG1shiftOLR(G1H2(31),2,2)
  call Hloop_ZA_Q(ntryL,G1H2(201),ex2(:),G1H1(1),ngZu,m3h2x1(:,220),heltab2x2(:,:,220))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,nMT,G2tensor(168),n2h1(182))
  call Hloop_ZA_Q(ntryL,G1H2(202),ex2(:),G1H1(1),ngZu,m3h2x1(:,221),heltab2x2(:,:,221))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,nMT,G2tensor(169),n2h1(183))
  call Hloop_ZA_Q(ntryL,G1H2(239),ex2(:),G1H1(1),ngZu,m3h2x1(:,222),heltab2x2(:,:,222))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,nMT,G2tensor(170),n2h1(184))
  call Hloop_VA_Q(ntryL,G1H2(207),ex2(:),G1H1(1),m3h2x1(:,223),heltab2x2(:,:,223))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,nMT,G2tensor(171),n2h1(185))
  call Hloop_VA_Q(ntryL,G1H2(232),ex2(:),G1H1(1),m3h2x1(:,224),heltab2x2(:,:,224))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,nMT,G2tensor(172),n2h1(186))
  call Hloop_VA_Q(ntryL,G1H2(213),ex2(:),G1H1(1),m3h2x1(:,225),heltab2x2(:,:,225))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,nMT,G2tensor(173),n2h1(187))
  call Hloop_SA_Q(ntryL,G1H2(219),ex2(:),G1H1(1),ngH,m3h2x1(:,226),heltab2x2(:,:,226))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,nMT,G2tensor(174),n2h1(188))
  call Hloop_SA_Q(ntryL,G1H2(220),ex2(:),G1H1(1),ngH,m3h2x1(:,227),heltab2x2(:,:,227))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,nMT,G2tensor(175),n2h1(189))
  call Hloop_SA_Q(ntryL,G1H2(225),ex2(:),G1H1(1),ngX,m3h2x1(:,228),heltab2x2(:,:,228))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,nMT,G2tensor(176),n2h1(190))
  call Hloop_SA_Q(ntryL,G1H2(226),ex2(:),G1H1(1),ngX,m3h2x1(:,229),heltab2x2(:,:,229))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,nMT,G2tensor(177),n2h1(191))
  call Hloop_VA_Q(ntryL,G1H2(231),ex2(:),G1H1(1),m3h2x1(:,230),heltab2x2(:,:,230))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,nMT,G2tensor(178),n2h1(192))
  call Hloop_ZA_Q(ntryL,G1H2(237),ex2(:),G1H1(1),ngZu,m3h2x1(:,231),heltab2x2(:,:,231))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,nMT,G2tensor(179),n2h1(193))
  call Hloop_ZA_Q(ntryL,G1H2(238),ex2(:),G1H1(1),ngZu,m3h2x1(:,232),heltab2x2(:,:,232))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,nMT,G2tensor(180),n2h1(194))
  call Hcheck_last_QA_V(ntryL,l_switch,G2H2(40),ex4(:),G2tensor(181),m3h2x1(:,233),heltab2x2(:,:,233))
  call Hcheck_last_QA_V(ntryL,l_switch,G2H2(42),ex4(:),G2tensor(182),m3h2x1(:,234),heltab2x2(:,:,234))
  call Hcheck_last_QA_V(ntryL,l_switch,G2H2(60),ex4(:),G2tensor(183),m3h2x1(:,235),heltab2x2(:,:,235))
  call Hcheck_last_QA_V(ntryL,l_switch,G2H2(70),ex4(:),G2tensor(184),m3h2x1(:,236),heltab2x2(:,:,236))
  call Hcheck_last_QA_V(ntryL,l_switch,G2H2(58),ex4(:),G2tensor(185),m3h2x1(:,237),heltab2x2(:,:,237))
  call Hcheck_last_QA_V(ntryL,l_switch,G2H2(84),ex4(:),G2tensor(186),m3h2x1(:,238),heltab2x2(:,:,238))
  call Hcheck_last_QA_V(ntryL,l_switch,G2H2(91),ex4(:),G2tensor(187),m3h2x1(:,239),heltab2x2(:,:,239))
  call Hcheck_last_AQ_V(ntryL,l_switch,G2H2(93),ex3(:),G2tensor(188),m3h2x1(:,240),heltab2x2(:,:,240))
  call Hcheck_last_AQ_V(ntryL,l_switch,G2H2(97),ex3(:),G2tensor(189),m3h2x1(:,241),heltab2x2(:,:,241))
  call Hcheck_last_AQ_V(ntryL,l_switch,G2H2(1),ex3(:),G2tensor(190),m3h2x1(:,242),heltab2x2(:,:,242))
  call Hcheck_last_AQ_V(ntryL,l_switch,G2H2(2),ex3(:),G2tensor(191),m3h2x1(:,243),heltab2x2(:,:,243))
  call Hcheck_last_AQ_V(ntryL,l_switch,G2H2(105),ex3(:),G2tensor(192),m3h2x1(:,244),heltab2x2(:,:,244))
  call Hcheck_last_QA_V(ntryL,l_switch,G2H2(3),ex4(:),G2tensor(193),m3h2x1(:,245),heltab2x2(:,:,245))
  call Hcheck_last_QA_V(ntryL,l_switch,G2H2(6),ex4(:),G2tensor(194),m3h2x1(:,246),heltab2x2(:,:,246))
  call Hcheck_last_QA_V(ntryL,l_switch,G2H2(5),ex4(:),G2tensor(195),m3h2x1(:,247),heltab2x2(:,:,247))
  call Hcheck_last_AQ_V(ntryL,l_switch,G2H2(7),ex3(:),G2tensor(196),m3h2x1(:,248),heltab2x2(:,:,248))
  call Hcheck_last_AQ_V(ntryL,l_switch,G2H2(10),ex3(:),G2tensor(197),m3h2x1(:,249),heltab2x2(:,:,249))
  call Hcheck_last_AQ_V(ntryL,l_switch,G2H2(9),ex3(:),G2tensor(198),m3h2x1(:,250),heltab2x2(:,:,250))
  call Hcheck_last_QA_V(ntryL,l_switch,G2H2(12),ex4(:),G2tensor(199),m3h2x1(:,251),heltab2x2(:,:,251))
  call Hcheck_last_AQ_V(ntryL,l_switch,G2H2(15),ex3(:),G2tensor(200),m3h2x1(:,252),heltab2x2(:,:,252))
  call Hcheck_last_AQ_V(ntryL,l_switch,G2H2(16),ex3(:),G2tensor(201),m3h2x1(:,253),heltab2x2(:,:,253))
  call Hcheck_last_QA_V(ntryL,l_switch,G2H2(19),ex2(:),G2tensor(202),m3h2x1(:,254),heltab2x2(:,:,254))
  call Hcheck_last_QA_V(ntryL,l_switch,G2H2(20),ex2(:),G2tensor(203),m3h2x1(:,255),heltab2x2(:,:,255))
  call Hotf_4pt_reduction(G2H2(22),RedSet_4(12),mass4set(:,10),  & 
G1H2(38),G1H2(42),G1H2(43),G1H2(44),G1H2(48),2)
  call HG1shiftOLR(G1H2(42),4,2)
  call Hotf_4pt_reduction(G2H2(23),RedSet_4(12),mass4set(:,11),  & 
G1H2(49),G1H2(50),G1H2(54),G1H2(55),G1H2(56),2)
  call HG1shiftOLR(G1H2(50),4,2)
  call Hotf_4pt_reduction(G2H2(25),RedSet_4(12),mass4set(:,11),  & 
G1H2(60),G1H2(61),G1H2(62),G1H2(66),G1H2(67),2)
  call HG1shiftOLR(G1H2(61),4,2)
  call Hotf_4pt_reduction(G2H2(28),RedSet_4(2),mass4set(:,10),  & 
G1H2(68),G1H2(72),G1H2(73),G1H2(74),G1H2(78),2)
  call HG1shiftOLR(G1H2(72),8,2)
  call Hotf_4pt_reduction(G2H2(29),RedSet_4(2),mass4set(:,11),  & 
G1H2(79),G1H2(80),G1H2(84),G1H2(85),G1H2(86),2)
  call HG1shiftOLR(G1H2(80),8,2)
  call Hotf_4pt_reduction(G2H2(31),RedSet_4(2),mass4set(:,11),  & 
G1H2(176),G1H2(180),G1H2(186),G1H2(187),G1H2(63),2)
  call HG1shiftOLR(G1H2(180),8,2)
  call Hotf_4pt_reduction(G2H4(16),RedSet_4(27),mass4set(:,12),  & 
G1H4(134),G1H4(143),G1H4(71),G1H4(64),G1H4(72),4)
  call HG1shiftOLR(G1H4(143),6,4)
  call Hotf_4pt_reduction(G2H4(17),RedSet_4(27),mass4set(:,12),  & 
G1H4(70),G1H4(77),G1H4(78),G1H4(82),G1H4(103),4)
  call HG1shiftOLR(G1H4(77),6,4)
  call Hotf_4pt_reduction(G2H4(19),RedSet_4(23),mass4set(:,12),  & 
G1H4(112),G1H4(113),G1H4(118),G1H4(84),G1H4(88),4)
  call HG1shiftOLR(G1H4(113),9,4)
  call Hotf_4pt_reduction(G2H4(20),RedSet_4(23),mass4set(:,12),  & 
G1H4(85),G1H4(94),G1H4(92),G1H4(95),G1H4(106),4)
  call HG1shiftOLR(G1H4(94),9,4)
  call Hotf_4pt_reduction(G2H4(24),RedSet_4(9),mass4set(:,13),  & 
G1H4(41),G1H4(42),G1H4(49),G1H4(50),G1H4(54),4)
  call HG1shiftOLR(G1H4(42),9,4)
  call Hotf_4pt_reduction(G2H4(22),RedSet_4(9),mass4set(:,13),  & 
G1H4(55),G1H4(60),G1H4(61),G1H4(65),G1H4(67),4)
  call HG1shiftOLR(G1H4(60),9,4)
  call Hotf_4pt_reduction(G2H4(23),RedSet_4(17),mass4set(:,14),  & 
G1H4(123),G1H4(124),G1H4(129),G1H4(130),G1H4(135),4)
  call HG1shiftOLR(G1H4(124),12,4)
  call Hotf_4pt_reduction(G2H4(25),RedSet_4(17),mass4set(:,14),  & 
G1H4(136),G1H4(141),G1H4(142),G1H4(9),G1H4(10),4)
  call HG1shiftOLR(G1H4(141),12,4)
  call Hotf_4pt_reduction(G2H4(26),RedSet_4(17),mass4set(:,15),  & 
G1H4(15),G1H4(76),G1H4(16),G1H4(21),G1H4(22),4)
  call HG1shiftOLR(G1H4(76),12,4)
  call Hotf_4pt_reduction(G2H4(31),RedSet_4(17),mass4set(:,16),  & 
G1H4(27),G1H4(28),G1H4(33),G1H4(34),G1H4(39),4)
  call HG1shiftOLR(G1H4(28),12,4)
  call Hotf_4pt_reduction(G2H4(33),RedSet_4(17),mass4set(:,17),  & 
G1H4(40),G1H4(45),G1H4(46),G1H4(51),G1H4(100),4)
  call HG1shiftOLR(G1H4(45),12,4)
  call Hotf_4pt_reduction(G2H4(32),RedSet_4(17),mass4set(:,14),  & 
G1H4(52),G1H4(57),G1H4(58),G1H4(63),G1H4(69),4)
  call HG1shiftOLR(G1H4(57),12,4)
  call Hotf_4pt_reduction(G2H4(30),RedSet_4(17),mass4set(:,14),  & 
G1H4(75),G1H4(81),G1H4(31),G1H4(35),G1H4(36),4)
  call HG1shiftOLR(G1H4(81),12,4)
  call Hotf_4pt_reduction(G2H4(34),RedSet_4(17),mass4set(:,18),  & 
G1H4(48),G1H4(38),G1H4(43),G1H4(44),G1H4(47),4)
  call HG1shiftOLR(G1H4(38),12,4)
  call Hotf_4pt_reduction(G2H4(35),RedSet_4(4),mass4set(:,14),  & 
G1H4(53),G1H4(56),G1H4(59),G1H4(62),G1H4(66),4)
  call HG1shiftOLR(G1H4(56),12,4)
  call Hotf_4pt_reduction(G2H4(36),RedSet_4(4),mass4set(:,14),  & 
G1H4(68),G1H4(73),G1H4(74),G1H4(79),G1H4(91),4)
  call HG1shiftOLR(G1H4(73),12,4)
  call Hotf_4pt_reduction(G2H4(37),RedSet_4(4),mass4set(:,15),  & 
G1H4(83),G1H4(86),G1H4(89),G1H4(90),G1H4(96),4)
  call HG1shiftOLR(G1H4(86),12,4)
  call Hotf_4pt_reduction(G2H4(42),RedSet_4(4),mass4set(:,16),  & 
G1H4(97),G1H4(98),G1H4(101),G1H4(109),G1H4(104),4)
  call HG1shiftOLR(G1H4(98),12,4)
  call Hotf_4pt_reduction(G2H4(43),RedSet_4(4),mass4set(:,17),  & 
G1H4(107),G1H4(108),G1H4(110),G1H4(114),G1H4(121),4)
  call HG1shiftOLR(G1H4(108),12,4)
  call Hotf_4pt_reduction(G2H4(40),RedSet_4(4),mass4set(:,14),  & 
G1H4(116),G1H4(119),G1H4(120),G1H4(122),G1H4(128),4)
  call HG1shiftOLR(G1H4(119),12,4)
  call Hotf_4pt_reduction(G2H4(41),RedSet_4(4),mass4set(:,14),  & 
G1H4(126),G1H4(127),G1H4(131),G1H4(132),G1H4(133),4)
  call HG1shiftOLR(G1H4(127),12,4)
  call Hotf_4pt_reduction(G2H4(46),RedSet_4(4),mass4set(:,18),  & 
G1H4(139),G1H4(137),G1H4(138),G1H4(140),G1H4(7),4)
  call HG1shiftOLR(G1H4(137),12,4)
  call Hcheck_last_QA_S(ntryL,l_switch,G2H2(36),ex4(:),G2tensor(204),ngH,m3h2x1(:,256),heltab2x2(:,:,256))
  call Hcheck_last_QA_S(ntryL,l_switch,G2H2(37),ex4(:),G2tensor(205),ngX,m3h2x1(:,257),heltab2x2(:,:,257))
  call Hcheck_last_QA_Z(ntryL,l_switch,G2H2(39),ex4(:),G2tensor(206),ngZd,m3h2x1(:,258),heltab2x2(:,:,258))
  call Hcheck_last_AQ_S(ntryL,l_switch,G2H2(46),ex3(:),G2tensor(207),ngH,m3h2x1(:,259),heltab2x2(:,:,259))
  call Hcheck_last_AQ_S(ntryL,l_switch,G2H2(48),ex3(:),G2tensor(208),ngX,m3h2x1(:,260),heltab2x2(:,:,260))
  call Hcheck_last_AQ_Z(ntryL,l_switch,G2H2(43),ex3(:),G2tensor(209),ngZd,m3h2x1(:,261),heltab2x2(:,:,261))
  call Hcheck_last_QA_S(ntryL,l_switch,G2H2(45),ex4(:),G2tensor(210),ngPbt,m3h2x1(:,262),heltab2x2(:,:,262))
  call Hcheck_last_QA_W(ntryL,l_switch,G2H2(52),ex4(:),G2tensor(211),m3h2x1(:,263),heltab2x2(:,:,263))
  call Hcheck_last_QA_S(ntryL,l_switch,G2H2(54),ex4(:),G2tensor(212),ngH,m3h2x1(:,264),heltab2x2(:,:,264))
  call Hcheck_last_QA_S(ntryL,l_switch,G2H2(55),ex4(:),G2tensor(213),ngX,m3h2x1(:,265),heltab2x2(:,:,265))
  call Hcheck_last_QA_Z(ntryL,l_switch,G2H2(57),ex4(:),G2tensor(214),ngZd,m3h2x1(:,266),heltab2x2(:,:,266))
  call Hcheck_last_AQ_S(ntryL,l_switch,G2H2(64),ex3(:),G2tensor(215),ngH,m3h2x1(:,267),heltab2x2(:,:,267))
  call Hcheck_last_AQ_S(ntryL,l_switch,G2H2(66),ex3(:),G2tensor(216),ngX,m3h2x1(:,268),heltab2x2(:,:,268))
  call Hcheck_last_AQ_Z(ntryL,l_switch,G2H2(61),ex3(:),G2tensor(217),ngZd,m3h2x1(:,269),heltab2x2(:,:,269))
  call Hcheck_last_QA_S(ntryL,l_switch,G2H2(63),ex4(:),G2tensor(218),ngPbt,m3h2x1(:,270),heltab2x2(:,:,270))
  call Hcheck_last_QA_W(ntryL,l_switch,G2H2(67),ex4(:),G2tensor(219),m3h2x1(:,271),heltab2x2(:,:,271))
  call Hloop_VA_Q(ntryL,G1H2(170),ex2(:),G1H1(1),m3h2x1(:,272),heltab2x2(:,:,272))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,nMT,G2tensor(220),n2h1(195))
  call Hloop_VQ_A(ntryL,G1H2(181),ex3(:),G1H1(1),m3h2x1(:,273),heltab2x2(:,:,273))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,nMB,G2tensor(221),n2h1(196))
  call Hloop_VQ_A(ntryL,G1H2(182),ex3(:),G1H1(1),m3h2x1(:,274),heltab2x2(:,:,274))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,nMB,G2tensor(222),n2h1(197))
  call Hloop_VQ_A(ntryL,G1H2(188),ex3(:),G1H1(1),m3h2x1(:,275),heltab2x2(:,:,275))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,nMB,G2tensor(223),n2h1(198))
  call Hloop_VQ_A(ntryL,G1H2(192),ex3(:),G1H1(1),m3h2x1(:,276),heltab2x2(:,:,276))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,nMB,G2tensor(224),n2h1(199))
  call Hcheck_last_AQ_V(ntryL,l_switch,G2H2(73),ex3(:),G2tensor(225),m3h2x1(:,277),heltab2x2(:,:,277))
  call Hcheck_last_AQ_S(ntryL,l_switch,G2H2(76),ex3(:),G2tensor(226),ngPtb,m3h2x1(:,278),heltab2x2(:,:,278))
  call Hcheck_last_AQ_W(ntryL,l_switch,G2H2(78),ex3(:),G2tensor(227),m3h2x1(:,279),heltab2x2(:,:,279))
  call Hcheck_last_QA_V(ntryL,l_switch,G2H2(81),ex2(:),G2tensor(228),m3h2x1(:,280),heltab2x2(:,:,280))
  call Hcheck_last_QA_S(ntryL,l_switch,G2H2(79),ex2(:),G2tensor(229),ngPtb,m3h2x1(:,281),heltab2x2(:,:,281))
  call Hcheck_last_QA_W(ntryL,l_switch,G2H2(88),ex2(:),G2tensor(230),m3h2x1(:,282),heltab2x2(:,:,282))
  call Hcheck_last_QA_V(ntryL,l_switch,G2H2(90),ex4(:),G2tensor(231),m3h2x1(:,283),heltab2x2(:,:,283))
  call Hcheck_last_QA_V(ntryL,l_switch,G2H2(87),ex4(:),G2tensor(232),m3h2x1(:,284),heltab2x2(:,:,284))
  call Hcheck_last_AQ_V(ntryL,l_switch,G2H2(94),ex3(:),G2tensor(233),m3h2x1(:,285),heltab2x2(:,:,285))
  call Hcheck_last_AQ_V(ntryL,l_switch,G2H2(100),ex3(:),G2tensor(234),m3h2x1(:,286),heltab2x2(:,:,286))
  call Hcheck_last_QA_V(ntryL,l_switch,G2H2(117),ex4(:),G2tensor(235),m3h2x1(:,287),heltab2x2(:,:,287))
  call Hcheck_last_QA_V(ntryL,l_switch,G2H2(123),ex4(:),G2tensor(236),m3h2x1(:,288),heltab2x2(:,:,288))
  call Hcheck_last_AQ_V(ntryL,l_switch,G2H2(129),ex3(:),G2tensor(237),m3h2x1(:,289),heltab2x2(:,:,289))
  call Hcheck_last_QA_V(ntryL,l_switch,G2H2(141),ex2(:),G2tensor(238),m3h2x1(:,290),heltab2x2(:,:,290))
  call Hloop_VA_Q(ntryL,G1H2(90),ex4(:),G1H1(1),m3h2x1(:,291),heltab2x2(:,:,291))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,nMB,G2tensor(239),n2h1(200))
  call Hloop_VA_Q(ntryL,G1H2(91),ex4(:),G1H1(1),m3h2x1(:,292),heltab2x2(:,:,292))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),8,nMB,G2tensor(240),n2h1(201))
  call Hloop_VA_Q(ntryL,G1H2(108),ex4(:),G1H1(1),m3h2x1(:,293),heltab2x2(:,:,293))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,nMB,G2tensor(241),n2h1(202))
  call Hloop_VA_Q(ntryL,G1H2(109),ex4(:),G1H1(1),m3h2x1(:,294),heltab2x2(:,:,294))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,nMB,G2tensor(242),n2h1(203))
  call Hloop_VA_Q(ntryL,G1H2(114),ex4(:),G1H1(1),m3h2x1(:,295),heltab2x2(:,:,295))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),8,nMB,G2tensor(243),n2h1(204))
  call Hloop_VA_Q(ntryL,G1H2(120),ex4(:),G1H1(1),m3h2x1(:,296),heltab2x2(:,:,296))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,nMB,G2tensor(244),n2h1(205))
  call Hloop_VQ_A(ntryL,G1H2(121),ex3(:),G1H1(1),m3h2x1(:,297),heltab2x2(:,:,297))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,nMB,G2tensor(245),n2h1(206))
  call Hloop_VQ_A(ntryL,G1H2(122),ex3(:),G1H1(1),m3h2x1(:,298),heltab2x2(:,:,298))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),4,nMB,G2tensor(246),n2h1(207))
  call Hloop_VQ_A(ntryL,G1H2(128),ex3(:),G1H1(1),m3h2x1(:,299),heltab2x2(:,:,299))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,nMB,G2tensor(247),n2h1(208))
  call Hloop_SQ_A(ntryL,G1H2(134),ex3(:),G1H1(1),ngPtb,m3h2x1(:,300),heltab2x2(:,:,300))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,nMT,G2tensor(248),n2h1(209))
  call Hloop_SQ_A(ntryL,G1H2(138),ex3(:),G1H1(1),ngPtb,m3h2x1(:,301),heltab2x2(:,:,301))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),4,nMT,G2tensor(249),n2h1(210))
  call Hloop_SQ_A(ntryL,G1H2(157),ex3(:),G1H1(1),ngPtb,m3h2x1(:,302),heltab2x2(:,:,302))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,nMT,G2tensor(250),n2h1(211))
  call Hloop_WQ_A(ntryL,G1H2(198),ex3(:),G1H1(1),m3h2x1(:,303),heltab2x2(:,:,303))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,nMT,G2tensor(251),n2h1(212))
  call Hloop_WQ_A(ntryL,G1H2(199),ex3(:),G1H1(1),m3h2x1(:,304),heltab2x2(:,:,304))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),4,nMT,G2tensor(252),n2h1(213))
  call Hloop_WQ_A(ntryL,G1H2(210),ex3(:),G1H1(1),m3h2x1(:,305),heltab2x2(:,:,305))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,nMT,G2tensor(253),n2h1(214))
  call Hloop_VA_Q(ntryL,G1H2(211),ex4(:),G1H1(1),m3h2x1(:,306),heltab2x2(:,:,306))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,nMB,G2tensor(254),n2h1(215))
  call Hloop_VA_Q(ntryL,G1H2(212),ex4(:),G1H1(1),m3h2x1(:,307),heltab2x2(:,:,307))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),8,nMB,G2tensor(255),n2h1(216))
  call Hloop_VA_Q(ntryL,G1H2(222),ex4(:),G1H1(1),m3h2x1(:,308),heltab2x2(:,:,308))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,nMB,G2tensor(256),n2h1(217))
  call Hloop_SA_Q(ntryL,G1H2(223),ex4(:),G1H1(1),ngPbt,m3h2x1(:,309),heltab2x2(:,:,309))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,nMT,G2tensor(257),n2h1(218))
  call Hloop_SA_Q(ntryL,G1H2(224),ex4(:),G1H1(1),ngPbt,m3h2x1(:,310),heltab2x2(:,:,310))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),8,nMT,G2tensor(258),n2h1(219))
  call Hloop_SA_Q(ntryL,G1H2(234),ex4(:),G1H1(1),ngPbt,m3h2x1(:,311),heltab2x2(:,:,311))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,nMT,G2tensor(259),n2h1(220))
  call Hloop_WA_Q(ntryL,G1H2(235),ex4(:),G1H1(1),m3h2x1(:,312),heltab2x2(:,:,312))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,nMT,G2tensor(260),n2h1(221))
  call Hloop_WA_Q(ntryL,G1H2(236),ex4(:),G1H1(1),m3h2x1(:,313),heltab2x2(:,:,313))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),8,nMT,G2tensor(261),n2h1(222))
  call Hloop_WA_Q(ntryL,G1H2(26),ex4(:),G1H1(1),m3h2x1(:,314),heltab2x2(:,:,314))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,nMT,G2tensor(262),n2h1(223))
  call Hloop_VA_Q(ntryL,G1H2(30),ex2(:),G1H1(1),m3h2x1(:,315),heltab2x2(:,:,315))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,nMT,G2tensor(263),n2h1(224))
  call Hloop_VA_Q(ntryL,G1H2(31),ex2(:),G1H1(1),m3h2x1(:,316),heltab2x2(:,:,316))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),2,nMT,G2tensor(264),n2h1(225))
  call Hloop_VA_Q(ntryL,G1H2(37),ex2(:),G1H1(1),m3h2x1(:,317),heltab2x2(:,:,317))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,nMT,G2tensor(265),n2h1(226))
  call Hloop_SQ_A(ntryL,G1H2(38),ex3(:),G1H1(1),ngH,m3h2x1(:,318),heltab2x2(:,:,318))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,nMB,G2tensor(266),n2h1(227))
  call Hloop_SQ_A(ntryL,G1H2(42),ex3(:),G1H1(1),ngH,m3h2x1(:,319),heltab2x2(:,:,319))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),4,nMB,G2tensor(267),n2h1(228))
  call Hloop_SQ_A(ntryL,G1H2(48),ex3(:),G1H1(1),ngH,m3h2x1(:,320),heltab2x2(:,:,320))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,nMB,G2tensor(268),n2h1(229))
  call Hloop_SQ_A(ntryL,G1H2(49),ex3(:),G1H1(1),ngX,m3h2x1(:,321),heltab2x2(:,:,321))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,nMB,G2tensor(269),n2h1(230))
  call Hloop_SQ_A(ntryL,G1H2(50),ex3(:),G1H1(1),ngX,m3h2x1(:,322),heltab2x2(:,:,322))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),4,nMB,G2tensor(270),n2h1(231))
  call Hloop_SQ_A(ntryL,G1H2(56),ex3(:),G1H1(1),ngX,m3h2x1(:,323),heltab2x2(:,:,323))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,nMB,G2tensor(271),n2h1(232))
  call Hloop_ZQ_A(ntryL,G1H2(60),ex3(:),G1H1(1),ngZd,m3h2x1(:,324),heltab2x2(:,:,324))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,nMB,G2tensor(272),n2h1(233))
  call Hloop_ZQ_A(ntryL,G1H2(61),ex3(:),G1H1(1),ngZd,m3h2x1(:,325),heltab2x2(:,:,325))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),4,nMB,G2tensor(273),n2h1(234))
  call Hloop_ZQ_A(ntryL,G1H2(67),ex3(:),G1H1(1),ngZd,m3h2x1(:,326),heltab2x2(:,:,326))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,nMB,G2tensor(274),n2h1(235))
  call Hloop_SA_Q(ntryL,G1H2(68),ex4(:),G1H1(1),ngH,m3h2x1(:,327),heltab2x2(:,:,327))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,nMB,G2tensor(275),n2h1(236))
  call Hloop_SA_Q(ntryL,G1H2(72),ex4(:),G1H1(1),ngH,m3h2x1(:,328),heltab2x2(:,:,328))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),8,nMB,G2tensor(276),n2h1(237))
  call Hloop_SA_Q(ntryL,G1H2(78),ex4(:),G1H1(1),ngH,m3h2x1(:,329),heltab2x2(:,:,329))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,nMB,G2tensor(277),n2h1(238))
  call Hloop_SA_Q(ntryL,G1H2(79),ex4(:),G1H1(1),ngX,m3h2x1(:,330),heltab2x2(:,:,330))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,nMB,G2tensor(278),n2h1(239))
  call Hloop_SA_Q(ntryL,G1H2(80),ex4(:),G1H1(1),ngX,m3h2x1(:,331),heltab2x2(:,:,331))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),8,nMB,G2tensor(279),n2h1(240))
  call Hloop_SA_Q(ntryL,G1H2(86),ex4(:),G1H1(1),ngX,m3h2x1(:,332),heltab2x2(:,:,332))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,nMB,G2tensor(280),n2h1(241))
  call Hloop_ZA_Q(ntryL,G1H2(176),ex4(:),G1H1(1),ngZd,m3h2x1(:,333),heltab2x2(:,:,333))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,nMB,G2tensor(281),n2h1(242))
  call Hloop_ZA_Q(ntryL,G1H2(180),ex4(:),G1H1(1),ngZd,m3h2x1(:,334),heltab2x2(:,:,334))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),8,nMB,G2tensor(282),n2h1(243))
  call Hloop_ZA_Q(ntryL,G1H2(63),ex4(:),G1H1(1),ngZd,m3h2x1(:,335),heltab2x2(:,:,335))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,nMB,G2tensor(283),n2h1(244))
  call Hloop_AS_Q(ntryL,G1H4(134),wf4(:,11),G1H1(1),ngPbt,m3h4x1(:,1),heltab2x4(:,:,250))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,nMT,G2tensor(284),n2h1(245))
  call Hloop_AS_Q(ntryL,G1H4(143),wf4(:,11),G1H1(1),ngPbt,m3h4x1(:,2),heltab2x4(:,:,251))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),6,nMT,G2tensor(285),n2h1(246))
  call Hloop_AS_Q(ntryL,G1H4(72),wf4(:,11),G1H1(1),ngPbt,m3h4x1(:,3),heltab2x4(:,:,252))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,nMT,G2tensor(286),n2h1(247))
  call Hloop_AW_Q(ntryL,G1H4(70),wf4(:,13),G1H1(1),m3h4x1(:,4),heltab2x4(:,:,253))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,nMT,G2tensor(287),n2h1(248))
  call Hloop_AW_Q(ntryL,G1H4(77),wf4(:,13),G1H1(1),m3h4x1(:,5),heltab2x4(:,:,254))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),6,nMT,G2tensor(288),n2h1(249))
  call Hloop_AW_Q(ntryL,G1H4(103),wf4(:,13),G1H1(1),m3h4x1(:,6),heltab2x4(:,:,255))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,nMT,G2tensor(289),n2h1(250))
  call Hloop_QS_A(ntryL,G1H4(112),wf4(:,14),G1H1(1),ngPtb,m3h4x1(:,7),heltab2x4(:,:,256))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,nMT,G2tensor(290),n2h1(251))
  call Hloop_QS_A(ntryL,G1H4(113),wf4(:,14),G1H1(1),ngPtb,m3h4x1(:,8),heltab2x4(:,:,257))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),9,nMT,G2tensor(291),n2h1(252))
  call Hloop_QS_A(ntryL,G1H4(88),wf4(:,14),G1H1(1),ngPtb,m3h4x1(:,9),heltab2x4(:,:,258))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,nMT,G2tensor(292),n2h1(253))
  call Hloop_QW_A(ntryL,G1H4(85),wf4(:,17),G1H1(1),m3h4x1(:,10),heltab2x4(:,:,259))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,nMT,G2tensor(293),n2h1(254))
  call Hloop_QW_A(ntryL,G1H4(94),wf4(:,17),G1H1(1),m3h4x1(:,11),heltab2x4(:,:,260))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),9,nMT,G2tensor(294),n2h1(255))
  call Hloop_QW_A(ntryL,G1H4(106),wf4(:,17),G1H1(1),m3h4x1(:,12),heltab2x4(:,:,261))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,nMT,G2tensor(295),n2h1(256))
  call Hloop_AS_Q(ntryL,G1H4(41),wf4(:,14),G1H1(1),ngPtb,m3h4x1(:,13),heltab2x4(:,:,262))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,nMB,G2tensor(296),n2h1(257))
  call Hloop_AS_Q(ntryL,G1H4(42),wf4(:,14),G1H1(1),ngPtb,m3h4x1(:,14),heltab2x4(:,:,263))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),9,nMB,G2tensor(297),n2h1(258))
  call Hloop_AS_Q(ntryL,G1H4(54),wf4(:,14),G1H1(1),ngPtb,m3h4x1(:,15),heltab2x4(:,:,264))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,nMB,G2tensor(298),n2h1(259))
  call Hloop_AW_Q(ntryL,G1H4(55),wf4(:,17),G1H1(1),m3h4x1(:,16),heltab2x4(:,:,265))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,nMB,G2tensor(299),n2h1(260))
  call Hloop_AW_Q(ntryL,G1H4(60),wf4(:,17),G1H1(1),m3h4x1(:,17),heltab2x4(:,:,266))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),9,nMB,G2tensor(300),n2h1(261))
  call Hloop_AW_Q(ntryL,G1H4(67),wf4(:,17),G1H1(1),m3h4x1(:,18),heltab2x4(:,:,267))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,nMB,G2tensor(301),n2h1(262))
  call Hloop_AS_Q(ntryL,G1H4(123),wf4(:,18),G1H1(1),ngH,m3h4x1(:,19),heltab2x4(:,:,268))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,nMT,G2tensor(302),n2h1(263))
  call Hloop_AS_Q(ntryL,G1H4(124),wf4(:,18),G1H1(1),ngH,m3h4x1(:,20),heltab2x4(:,:,269))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),12,nMT,G2tensor(303),n2h1(264))
  call Hloop_AS_Q(ntryL,G1H4(135),wf4(:,18),G1H1(1),ngH,m3h4x1(:,21),heltab2x4(:,:,270))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,nMT,G2tensor(304),n2h1(265))
  call Hloop_AS_Q(ntryL,G1H4(136),wf4(:,19),G1H1(1),ngX,m3h4x1(:,22),heltab2x4(:,:,271))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,nMT,G2tensor(305),n2h1(266))
  call Hloop_AS_Q(ntryL,G1H4(141),wf4(:,19),G1H1(1),ngX,m3h4x1(:,23),heltab2x4(:,:,272))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),12,nMT,G2tensor(306),n2h1(267))
  call Hloop_AS_Q(ntryL,G1H4(10),wf4(:,19),G1H1(1),ngX,m3h4x1(:,24),heltab2x4(:,:,273))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,nMT,G2tensor(307),n2h1(268))
  call Hloop_AV_Q(ntryL,G1H4(15),wf4(:,2),G1H1(1),m3h4x1(:,25),heltab2x4(:,:,274))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,nMT,G2tensor(308),n2h1(269))
  call Hloop_AV_Q(ntryL,G1H4(76),wf4(:,2),G1H1(1),m3h4x1(:,26),heltab2x4(:,:,275))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),12,nMT,G2tensor(309),n2h1(270))
  call Hloop_AV_Q(ntryL,G1H4(22),wf4(:,2),G1H1(1),m3h4x1(:,27),heltab2x4(:,:,276))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,nMT,G2tensor(310),n2h1(271))
  call Hloop_AV_Q(ntryL,G1H4(27),wf4(:,2),G1H1(1),m3h4x1(:,28),heltab2x4(:,:,277))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,nMT,G2tensor(311),n2h1(272))
  call Hloop_AV_Q(ntryL,G1H4(28),wf4(:,2),G1H1(1),m3h4x1(:,29),heltab2x4(:,:,278))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),12,nMT,G2tensor(312),n2h1(273))
  call Hloop_AV_Q(ntryL,G1H4(39),wf4(:,2),G1H1(1),m3h4x1(:,30),heltab2x4(:,:,279))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,nMT,G2tensor(313),n2h1(274))
  call Hloop_AV_Q(ntryL,G1H4(40),wf4(:,2),G1H1(1),m3h4x1(:,31),heltab2x4(:,:,280))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,nMB,G2tensor(314),n2h1(275))
  call Hloop_AV_Q(ntryL,G1H4(45),wf4(:,2),G1H1(1),m3h4x1(:,32),heltab2x4(:,:,281))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),12,nMB,G2tensor(315),n2h1(276))
  call Hloop_AV_Q(ntryL,G1H4(100),wf4(:,2),G1H1(1),m3h4x1(:,33),heltab2x4(:,:,282))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,nMB,G2tensor(316),n2h1(277))
  call Hloop_AV_Q(ntryL,G1H4(52),wf4(:,2),G1H1(1),m3h4x1(:,34),heltab2x4(:,:,283))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,nMT,G2tensor(317),n2h1(278))
  call Hloop_AV_Q(ntryL,G1H4(57),wf4(:,2),G1H1(1),m3h4x1(:,35),heltab2x4(:,:,284))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),12,nMT,G2tensor(318),n2h1(279))
  call Hloop_AV_Q(ntryL,G1H4(69),wf4(:,2),G1H1(1),m3h4x1(:,36),heltab2x4(:,:,285))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,nMT,G2tensor(319),n2h1(280))
  call Hloop_AZ_Q(ntryL,G1H4(75),wf4(:,20),G1H1(1),ngZu,m3h4x1(:,37),heltab2x4(:,:,286))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,nMT,G2tensor(320),n2h1(281))
  call Hloop_AZ_Q(ntryL,G1H4(81),wf4(:,20),G1H1(1),ngZu,m3h4x1(:,38),heltab2x4(:,:,287))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),12,nMT,G2tensor(321),n2h1(282))
  call Hloop_AZ_Q(ntryL,G1H4(36),wf4(:,20),G1H1(1),ngZu,m3h4x1(:,39),heltab2x4(:,:,288))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,nMT,G2tensor(322),n2h1(283))
  call Hcheck_last_UV_W(ntryL,l_switch,G1H4(48),19,wf4(:,2),12,G2tensor(323),m3h4x1(:,40),heltab2x4(:,:,289))
  call Hcheck_last_UV_W(ntryL,l_switch,G1H4(38),0,wf4(:,2),12,G2tensor(324),m3h4x1(:,41),heltab2x4(:,:,290))
  call Hcheck_last_UV_W(ntryL,l_switch,G1H4(47),19,wf4(:,2),12,G2tensor(325),m3h4x1(:,42),heltab2x4(:,:,291))
  call Hloop_QS_A(ntryL,G1H4(53),wf4(:,18),G1H1(1),ngH,m3h4x1(:,43),heltab2x4(:,:,292))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,nMT,G2tensor(326),n2h1(285))
  call Hloop_QS_A(ntryL,G1H4(56),wf4(:,18),G1H1(1),ngH,m3h4x1(:,44),heltab2x4(:,:,293))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),12,nMT,G2tensor(327),n2h1(286))
  call Hloop_QS_A(ntryL,G1H4(66),wf4(:,18),G1H1(1),ngH,m3h4x1(:,45),heltab2x4(:,:,294))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,nMT,G2tensor(328),n2h1(287))
  call Hloop_QS_A(ntryL,G1H4(68),wf4(:,19),G1H1(1),ngX,m3h4x1(:,46),heltab2x4(:,:,295))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,nMT,G2tensor(329),n2h1(288))
  call Hloop_QS_A(ntryL,G1H4(73),wf4(:,19),G1H1(1),ngX,m3h4x1(:,47),heltab2x4(:,:,296))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),12,nMT,G2tensor(330),n2h1(289))
  call Hloop_QS_A(ntryL,G1H4(91),wf4(:,19),G1H1(1),ngX,m3h4x1(:,48),heltab2x4(:,:,297))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,nMT,G2tensor(331),n2h1(290))
  call Hloop_QV_A(ntryL,G1H4(83),wf4(:,2),G1H1(1),m3h4x1(:,49),heltab2x4(:,:,298))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,nMT,G2tensor(332),n2h1(291))
  call Hloop_QV_A(ntryL,G1H4(86),wf4(:,2),G1H1(1),m3h4x1(:,50),heltab2x4(:,:,299))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),12,nMT,G2tensor(333),n2h1(292))
  call Hloop_QV_A(ntryL,G1H4(96),wf4(:,2),G1H1(1),m3h4x1(:,51),heltab2x4(:,:,300))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,nMT,G2tensor(334),n2h1(293))
  call Hloop_QV_A(ntryL,G1H4(97),wf4(:,2),G1H1(1),m3h4x1(:,52),heltab2x4(:,:,301))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,nMT,G2tensor(335),n2h1(294))
  call Hloop_QV_A(ntryL,G1H4(98),wf4(:,2),G1H1(1),m3h4x1(:,53),heltab2x4(:,:,302))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),12,nMT,G2tensor(336),n2h1(295))
  call Hloop_QV_A(ntryL,G1H4(104),wf4(:,2),G1H1(1),m3h4x1(:,54),heltab2x4(:,:,303))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,nMT,G2tensor(337),n2h1(296))
  call Hloop_QV_A(ntryL,G1H4(107),wf4(:,2),G1H1(1),m3h4x1(:,55),heltab2x4(:,:,304))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,nMB,G2tensor(338),n2h1(297))
  call Hloop_QV_A(ntryL,G1H4(108),wf4(:,2),G1H1(1),m3h4x1(:,56),heltab2x4(:,:,305))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),12,nMB,G2tensor(339),n2h1(298))
  call Hloop_QV_A(ntryL,G1H4(121),wf4(:,2),G1H1(1),m3h4x1(:,57),heltab2x4(:,:,306))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,nMB,G2tensor(340),n2h1(299))
  call Hloop_QV_A(ntryL,G1H4(116),wf4(:,2),G1H1(1),m3h4x1(:,58),heltab2x4(:,:,307))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,nMT,G2tensor(341),n2h1(300))
  call Hloop_QV_A(ntryL,G1H4(119),wf4(:,2),G1H1(1),m3h4x1(:,59),heltab2x4(:,:,308))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),12,nMT,G2tensor(342),n2h1(301))
  call Hloop_QV_A(ntryL,G1H4(128),wf4(:,2),G1H1(1),m3h4x1(:,60),heltab2x4(:,:,309))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,nMT,G2tensor(343),n2h1(302))
  call Hloop_QZ_A(ntryL,G1H4(126),wf4(:,20),G1H1(1),ngZu,m3h4x1(:,61),heltab2x4(:,:,310))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,nMT,G2tensor(344),n2h1(303))
  call Hloop_QZ_A(ntryL,G1H4(127),wf4(:,20),G1H1(1),ngZu,m3h4x1(:,62),heltab2x4(:,:,311))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),12,nMT,G2tensor(345),n2h1(304))
  call Hloop_QZ_A(ntryL,G1H4(133),wf4(:,20),G1H1(1),ngZu,m3h4x1(:,63),heltab2x4(:,:,312))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,nMT,G2tensor(346),n2h1(305))
  call Hcheck_last_UV_W(ntryL,l_switch,G1H4(139),19,wf4(:,2),12,G2tensor(347),m3h4x1(:,64),heltab2x4(:,:,313))
  call Hcheck_last_UV_W(ntryL,l_switch,G1H4(137),0,wf4(:,2),12,G2tensor(348),m3h4x1(:,65),heltab2x4(:,:,314))
  call Hcheck_last_UV_W(ntryL,l_switch,G1H4(7),19,wf4(:,2),12,G2tensor(349),m3h4x1(:,66),heltab2x4(:,:,315))
  call ol_merge_tensors(G2tensor(10),[G2tensor(2),G1tensor(30),G1tensor(6)])
  call ol_merge_tensors(G2tensor(12),[G2tensor(4),G1tensor(36),G1tensor(12)])
  call ol_merge_tensors(G2tensor(347),[G2tensor(14),G2tensor(6),G1tensor(42),G1tensor(18)])
  call ol_merge_tensors(G2tensor(8),[G1tensor(24)])
  call ol_merge_tensors(G2tensor(22),[G2tensor(16),G1tensor(66),G1tensor(48)])
  call ol_merge_tensors(G2tensor(24),[G2tensor(18),G1tensor(72),G1tensor(54)])
  call ol_merge_tensors(G2tensor(323),[G2tensor(26),G2tensor(20),G1tensor(78),G1tensor(60)])
  call ol_merge_tensors(G2tensor(28),[G1tensor(84)])
  call ol_merge_tensors(G2tensor(32),[G2tensor(30),G1tensor(96),G1tensor(90)])
  call ol_merge_tensors(G2tensor(34),[G1tensor(98)])
  call ol_merge_tensors(G2tensor(35),[G1tensor(102)])
  call ol_merge_tensors(G2tensor(37),[G1tensor(104)])
  call ol_merge_tensors(G2tensor(38),[G1tensor(108)])
  call ol_merge_tensors(G2tensor(40),[G1tensor(110)])
  call ol_merge_tensors(G2tensor(50),[G2tensor(47),G2tensor(44),G2tensor(41),G1tensor(126),G1tensor(120),G1tensor(114)])
  call ol_merge_tensors(G2tensor(49),[G2tensor(43),G1tensor(116)])
  call ol_merge_tensors(G2tensor(46),[G1tensor(122)])
  call ol_merge_tensors(G2tensor(52),[G1tensor(128)])
  call ol_merge_tensors(G2tensor(299),[G2tensor(296),G2tensor(68),G2tensor(65),G2tensor(56),G2tensor(53),G1tensor(156) &
    ,G1tensor(138),G1tensor(132)])
  call ol_merge_tensors(G2tensor(67),[G2tensor(55),G1tensor(134)])
  call ol_merge_tensors(G2tensor(58),[G1tensor(140)])
  call ol_merge_tensors(G2tensor(59),[G1tensor(144)])
  call ol_merge_tensors(G2tensor(61),[G1tensor(146)])
  call ol_merge_tensors(G2tensor(62),[G1tensor(150)])
  call ol_merge_tensors(G2tensor(64),[G1tensor(152)])
  call ol_merge_tensors(G2tensor(186),[G2tensor(70),G1tensor(158),G1tensor(21)])
  call ol_merge_tensors(G2tensor(338),[G2tensor(71),G1tensor(162)])
  call ol_merge_tensors(G2tensor(219),[G2tensor(218),G2tensor(76),G2tensor(73),G1tensor(164)])
  call ol_merge_tensors(G2tensor(344),[G2tensor(341),G2tensor(329),G2tensor(326),G2tensor(77),G2tensor(74),G1tensor(168)])
  call ol_merge_tensors(G2tensor(225),[G2tensor(79),G1tensor(170)])
  call ol_merge_tensors(G2tensor(314),[G2tensor(80),G1tensor(174)])
  call ol_merge_tensors(G2tensor(227),[G2tensor(226),G2tensor(85),G2tensor(82),G1tensor(176)])
  call ol_merge_tensors(G2tensor(320),[G2tensor(317),G2tensor(305),G2tensor(302),G2tensor(86),G2tensor(83),G1tensor(180)])
  call ol_merge_tensors(G2tensor(94),[G2tensor(88),G1tensor(182)])
  call ol_merge_tensors(G2tensor(95),[G2tensor(89),G1tensor(186)])
  call ol_merge_tensors(G2tensor(91),[G1tensor(188)])
  call ol_merge_tensors(G2tensor(92),[G1tensor(192)])
  call ol_merge_tensors(G2tensor(228),[G2tensor(97),G1tensor(194)])
  call ol_merge_tensors(G2tensor(98),[G1tensor(198)])
  call ol_merge_tensors(G2tensor(230),[G2tensor(229),G2tensor(103),G2tensor(100),G1tensor(200)])
  call ol_merge_tensors(G2tensor(122),[G2tensor(119),G2tensor(116),G2tensor(113),G2tensor(104),G2tensor(101),G1tensor(234) &
    ,G1tensor(228),G1tensor(222),G1tensor(204)])
  call ol_merge_tensors(G2tensor(181),[G2tensor(106),G1tensor(206),G1tensor(3)])
  call ol_merge_tensors(G2tensor(107),[G1tensor(210)])
  call ol_merge_tensors(G2tensor(183),[G2tensor(109),G1tensor(212),G1tensor(9)])
  call ol_merge_tensors(G2tensor(110),[G1tensor(216)])
  call ol_merge_tensors(G2tensor(212),[G2tensor(112),G1tensor(218)])
  call ol_merge_tensors(G2tensor(214),[G2tensor(213),G2tensor(121),G2tensor(115),G1tensor(224)])
  call ol_merge_tensors(G2tensor(185),[G2tensor(118),G1tensor(230),G1tensor(15)])
  call ol_merge_tensors(G2tensor(188),[G2tensor(124),G1tensor(236),G1tensor(27)])
  call ol_merge_tensors(G2tensor(125),[G1tensor(240)])
  call ol_merge_tensors(G2tensor(190),[G2tensor(127),G1tensor(242),G1tensor(33)])
  call ol_merge_tensors(G2tensor(128),[G1tensor(246)])
  call ol_merge_tensors(G2tensor(215),[G2tensor(130),G1tensor(248)])
  call ol_merge_tensors(G2tensor(287),[G2tensor(284),G2tensor(140),G2tensor(137),G2tensor(134),G2tensor(131),G1tensor(264) &
    ,G1tensor(258),G1tensor(252)])
  call ol_merge_tensors(G2tensor(217),[G2tensor(216),G2tensor(139),G2tensor(133),G1tensor(254)])
  call ol_merge_tensors(G2tensor(192),[G2tensor(136),G1tensor(260),G1tensor(39)])
  call ol_merge_tensors(G2tensor(42),[G1tensor(2)])
  call ol_merge_tensors(G2tensor(182),[G1tensor(46),G1tensor(4)])
  call ol_merge_tensors(G2tensor(54),[G1tensor(83),G1tensor(17),G1tensor(11),G1tensor(5)])
  call ol_merge_tensors(G2tensor(87),[G2tensor(72),G1tensor(8)])
  call ol_merge_tensors(G2tensor(184),[G1tensor(52),G1tensor(10)])
  call ol_merge_tensors(G2tensor(81),[G1tensor(14)])
  call ol_merge_tensors(G2tensor(231),[G1tensor(58),G1tensor(16)])
  call ol_merge_tensors(G2tensor(132),[G2tensor(99),G1tensor(20)])
  call ol_merge_tensors(G2tensor(187),[G1tensor(82),G1tensor(22)])
  call ol_merge_tensors(G2tensor(114),[G1tensor(23)])
  call ol_merge_tensors(G2tensor(1),[G1tensor(129),G1tensor(26)])
  call ol_merge_tensors(G2tensor(189),[G1tensor(64),G1tensor(28)])
  call ol_merge_tensors(G2tensor(3),[G1tensor(41),G1tensor(35),G1tensor(29)])
  call ol_merge_tensors(G2tensor(9),[G2tensor(5),G1tensor(135),G1tensor(32)])
  call ol_merge_tensors(G2tensor(191),[G1tensor(70),G1tensor(34)])
  call ol_merge_tensors(G2tensor(7),[G1tensor(153),G1tensor(38)])
  call ol_merge_tensors(G2tensor(233),[G1tensor(76),G1tensor(40)])
  call ol_merge_tensors(G2tensor(11),[G1tensor(44)])
  call ol_merge_tensors(G2tensor(193),[G1tensor(45)])
  call ol_merge_tensors(G2tensor(13),[G1tensor(59),G1tensor(53),G1tensor(47)])
  call ol_merge_tensors(G2tensor(19),[G2tensor(15),G1tensor(50)])
  call ol_merge_tensors(G2tensor(194),[G1tensor(51)])
  call ol_merge_tensors(G2tensor(17),[G1tensor(56)])
  call ol_merge_tensors(G2tensor(195),[G1tensor(57)])
  call ol_merge_tensors(G2tensor(21),[G1tensor(111),G1tensor(62)])
  call ol_merge_tensors(G2tensor(196),[G1tensor(63)])
  call ol_merge_tensors(G2tensor(23),[G1tensor(89),G1tensor(77),G1tensor(71),G1tensor(65)])
  call ol_merge_tensors(G2tensor(29),[G2tensor(25),G1tensor(117),G1tensor(68)])
  call ol_merge_tensors(G2tensor(197),[G1tensor(69)])
  call ol_merge_tensors(G2tensor(27),[G1tensor(123),G1tensor(74)])
  call ol_merge_tensors(G2tensor(198),[G1tensor(75)])
  call ol_merge_tensors(G2tensor(33),[G2tensor(31),G1tensor(80)])
  call ol_merge_tensors(G2tensor(199),[G1tensor(81)])
  call ol_merge_tensors(G2tensor(39),[G2tensor(36),G1tensor(86)])
  call ol_merge_tensors(G2tensor(200),[G1tensor(87)])
  call ol_merge_tensors(G2tensor(201),[G1tensor(88)])
  call ol_merge_tensors(G2tensor(51),[G2tensor(48),G1tensor(165),G1tensor(92)])
  call ol_merge_tensors(G2tensor(202),[G1tensor(93)])
  call ol_merge_tensors(G2tensor(203),[G1tensor(94)])
  call ol_merge_tensors(G2tensor(45),[G1tensor(95)])
  call ol_merge_tensors(G2tensor(66),[G1tensor(99)])
  call ol_merge_tensors(G2tensor(57),[G1tensor(196),G1tensor(124),G1tensor(106),G1tensor(100)])
  call ol_merge_tensors(G2tensor(60),[G1tensor(143),G1tensor(101)])
  call ol_merge_tensors(G2tensor(63),[G1tensor(105)])
  call ol_merge_tensors(G2tensor(69),[G1tensor(149),G1tensor(107)])
  call ol_merge_tensors(G2tensor(75),[G1tensor(112)])
  call ol_merge_tensors(G2tensor(78),[G1tensor(131),G1tensor(113)])
  call ol_merge_tensors(G2tensor(90),[G2tensor(84),G1tensor(118)])
  call ol_merge_tensors(G2tensor(96),[G2tensor(93),G1tensor(137),G1tensor(119)])
  call ol_merge_tensors(G2tensor(239),[G1tensor(155),G1tensor(125)])
  call ol_merge_tensors(G2tensor(102),[G1tensor(130)])
  call ol_merge_tensors(G2tensor(120),[G2tensor(105),G1tensor(136)])
  call ol_merge_tensors(G2tensor(108),[G1tensor(141)])
  call ol_merge_tensors(G2tensor(242),[G1tensor(154),G1tensor(148),G1tensor(142)])
  call ol_merge_tensors(G2tensor(111),[G1tensor(147)])
  call ol_merge_tensors(G2tensor(117),[G1tensor(159)])
  call ol_merge_tensors(G2tensor(245),[G1tensor(160)])
  call ol_merge_tensors(G2tensor(123),[G1tensor(191),G1tensor(161)])
  call ol_merge_tensors(G2tensor(251),[G2tensor(248),G1tensor(166)])
  call ol_merge_tensors(G2tensor(129),[G2tensor(126),G1tensor(185),G1tensor(167)])
  call ol_merge_tensors(G2tensor(138),[G1tensor(171)])
  call ol_merge_tensors(G2tensor(254),[G1tensor(172)])
  call ol_merge_tensors(G2tensor(135),[G1tensor(197),G1tensor(173)])
  call ol_merge_tensors(G2tensor(143),[G2tensor(141),G1tensor(177)])
  call ol_merge_tensors(G2tensor(260),[G2tensor(257),G1tensor(178)])
  call ol_merge_tensors(G2tensor(144),[G2tensor(142),G1tensor(203),G1tensor(179)])
  call ol_merge_tensors(G2tensor(149),[G2tensor(145),G1tensor(183)])
  call ol_merge_tensors(G2tensor(150),[G2tensor(146),G1tensor(184)])
  call ol_merge_tensors(G2tensor(147),[G1tensor(189)])
  call ol_merge_tensors(G2tensor(148),[G1tensor(190)])
  call ol_merge_tensors(G2tensor(151),[G1tensor(195)])
  call ol_merge_tensors(G2tensor(154),[G2tensor(152),G1tensor(201)])
  call ol_merge_tensors(G2tensor(155),[G2tensor(153),G1tensor(202)])
  call ol_merge_tensors(G2tensor(156),[G1tensor(207)])
  call ol_merge_tensors(G2tensor(157),[G1tensor(232),G1tensor(214),G1tensor(208)])
  call ol_merge_tensors(G2tensor(158),[G1tensor(239),G1tensor(209)])
  call ol_merge_tensors(G2tensor(159),[G1tensor(213)])
  call ol_merge_tensors(G2tensor(160),[G1tensor(245),G1tensor(215)])
  call ol_merge_tensors(G2tensor(161),[G1tensor(219)])
  call ol_merge_tensors(G2tensor(162),[G1tensor(220)])
  call ol_merge_tensors(G2tensor(163),[G1tensor(251),G1tensor(221)])
  call ol_merge_tensors(G2tensor(168),[G2tensor(164),G1tensor(225)])
  call ol_merge_tensors(G2tensor(169),[G2tensor(165),G1tensor(226)])
  call ol_merge_tensors(G2tensor(170),[G2tensor(166),G1tensor(257),G1tensor(227)])
  call ol_merge_tensors(G2tensor(167),[G1tensor(231)])
  call ol_merge_tensors(G2tensor(263),[G1tensor(263),G1tensor(233)])
  call ol_merge_tensors(G2tensor(171),[G1tensor(237)])
  call ol_merge_tensors(G2tensor(172),[G1tensor(262),G1tensor(244),G1tensor(238)])
  call ol_merge_tensors(G2tensor(173),[G1tensor(243)])
  call ol_merge_tensors(G2tensor(174),[G1tensor(249)])
  call ol_merge_tensors(G2tensor(175),[G1tensor(250)])
  call ol_merge_tensors(G2tensor(179),[G2tensor(176),G1tensor(255)])
  call ol_merge_tensors(G2tensor(180),[G2tensor(177),G1tensor(256)])
  call ol_merge_tensors(G2tensor(178),[G1tensor(261)])
  call ol_merge_tensors(G2tensor(206),[G2tensor(205)])
  call ol_merge_tensors(G2tensor(209),[G2tensor(208)])
  call ol_merge_tensors(G2tensor(211),[G2tensor(210)])
  call ol_merge_tensors(G2tensor(272),[G2tensor(269)])
  call ol_merge_tensors(G2tensor(281),[G2tensor(278)])
  call ol_merge_tensors(G2tensor(293),[G2tensor(290)])
  call Hotf_4pt_reduction_last(G2tensor(10),RedSet_4(4),mass4set(:,19),  & 
G1tensor(1),G1tensor(7),G1tensor(13),G1tensor(19),G1tensor(25))
  call G_TensorShift(G1tensor(7),12)
  call Hotf_4pt_reduction_last(G2tensor(12),RedSet_4(4),mass4set(:,20),  & 
G1tensor(31),G1tensor(37),G1tensor(43),G1tensor(49),G1tensor(55))
  call G_TensorShift(G1tensor(37),12)
  call Hotf_4pt_reduction_last(G2tensor(347),RedSet_4(4),mass4set(:,18),  & 
G1tensor(61),G1tensor(67),G1tensor(73),G1tensor(79),G1tensor(85))
  call G_TensorShift(G1tensor(67),12)
  call Hotf_4pt_reduction_last(G2tensor(8),RedSet_4(9),mass4set(:,21),  & 
G1tensor(91),G1tensor(97),G1tensor(103),G1tensor(109),G1tensor(115))
  call G_TensorShift(G1tensor(97),9)
  call Hotf_4pt_reduction_last(G2tensor(22),RedSet_4(17),mass4set(:,19),  & 
G1tensor(121),G1tensor(127),G1tensor(133),G1tensor(139),G1tensor(145))
  call G_TensorShift(G1tensor(127),12)
  call Hotf_4pt_reduction_last(G2tensor(24),RedSet_4(17),mass4set(:,20),  & 
G1tensor(151),G1tensor(157),G1tensor(163),G1tensor(169),G1tensor(175))
  call G_TensorShift(G1tensor(157),12)
  call Hotf_4pt_reduction_last(G2tensor(323),RedSet_4(17),mass4set(:,18),  & 
G1tensor(181),G1tensor(187),G1tensor(193),G1tensor(199),G1tensor(205))
  call G_TensorShift(G1tensor(187),12)
  call Hotf_4pt_reduction_last(G2tensor(28),RedSet_4(23),mass4set(:,22),  & 
G1tensor(211),G1tensor(217),G1tensor(223),G1tensor(229),G1tensor(235))
  call G_TensorShift(G1tensor(217),9)
  call Hotf_4pt_reduction_last(G2tensor(32),RedSet_4(27),mass4set(:,22),  & 
G1tensor(241),G1tensor(247),G1tensor(253),G1tensor(259),G1tensor(30))
  call G_TensorShift(G1tensor(247),6)
  call Hotf_4pt_reduction_last(G2tensor(34),RedSet_4(47),mass4set(:,23),  & 
G1tensor(6),G1tensor(36),G1tensor(12),G1tensor(42),G1tensor(18))
  call G_TensorShift(G1tensor(36),2)
  call Hotf_4pt_reduction_last(G2tensor(35),RedSet_4(35),mass4set(:,24),  & 
G1tensor(24),G1tensor(66),G1tensor(48),G1tensor(72),G1tensor(54))
  call G_TensorShift(G1tensor(66),10)
  call Hotf_4pt_reduction_last(G2tensor(37),RedSet_4(47),mass4set(:,25),  & 
G1tensor(78),G1tensor(60),G1tensor(84),G1tensor(96),G1tensor(90))
  call G_TensorShift(G1tensor(60),2)
  call Hotf_4pt_reduction_last(G2tensor(38),RedSet_4(35),mass4set(:,26),  & 
G1tensor(98),G1tensor(102),G1tensor(104),G1tensor(108),G1tensor(110))
  call G_TensorShift(G1tensor(102),10)
  call Hotf_4pt_reduction_last(G2tensor(40),RedSet_4(47),mass4set(:,27),  & 
G1tensor(126),G1tensor(120),G1tensor(114),G1tensor(116),G1tensor(122))
  call G_TensorShift(G1tensor(120),2)
  call Hotf_4pt_reduction_last(G2tensor(50),RedSet_4(35),mass4set(:,13),  & 
G1tensor(128),G1tensor(156),G1tensor(138),G1tensor(132),G1tensor(134))
  call G_TensorShift(G1tensor(156),10)
  call Hotf_4pt_reduction_last(G2tensor(49),RedSet_4(47),mass4set(:,28),  & 
G1tensor(140),G1tensor(144),G1tensor(146),G1tensor(150),G1tensor(152))
  call G_TensorShift(G1tensor(144),2)
  call Hotf_4pt_reduction_last(G2tensor(46),RedSet_4(47),mass4set(:,29),  & 
G1tensor(158),G1tensor(21),G1tensor(162),G1tensor(164),G1tensor(168))
  call G_TensorShift(G1tensor(21),2)
  call Hotf_4pt_reduction_last(G2tensor(52),RedSet_4(48),mass4set(:,27),  & 
G1tensor(170),G1tensor(174),G1tensor(176),G1tensor(180),G1tensor(182))
  call G_TensorShift(G1tensor(174),1)
  call Hotf_4pt_reduction_last(G2tensor(299),RedSet_4(9),mass4set(:,13),  & 
G1tensor(186),G1tensor(188),G1tensor(192),G1tensor(194),G1tensor(198))
  call G_TensorShift(G1tensor(188),9)
  call Hotf_4pt_reduction_last(G2tensor(67),RedSet_4(48),mass4set(:,28),  & 
G1tensor(200),G1tensor(234),G1tensor(228),G1tensor(222),G1tensor(204))
  call G_TensorShift(G1tensor(234),1)
  call Hotf_4pt_reduction_last(G2tensor(58),RedSet_4(48),mass4set(:,23),  & 
G1tensor(206),G1tensor(3),G1tensor(210),G1tensor(212),G1tensor(9))
  call G_TensorShift(G1tensor(3),1)
  call Hotf_4pt_reduction_last(G2tensor(59),RedSet_4(9),mass4set(:,24),  & 
G1tensor(216),G1tensor(218),G1tensor(224),G1tensor(230),G1tensor(15))
  call G_TensorShift(G1tensor(218),9)
  call Hotf_4pt_reduction_last(G2tensor(61),RedSet_4(48),mass4set(:,25),  & 
G1tensor(236),G1tensor(27),G1tensor(240),G1tensor(242),G1tensor(33))
  call G_TensorShift(G1tensor(27),1)
  call Hotf_4pt_reduction_last(G2tensor(62),RedSet_4(9),mass4set(:,26),  & 
G1tensor(246),G1tensor(248),G1tensor(264),G1tensor(258),G1tensor(252))
  call G_TensorShift(G1tensor(248),9)
  call Hotf_4pt_reduction_last(G2tensor(64),RedSet_4(48),mass4set(:,29),  & 
G1tensor(254),G1tensor(260),G1tensor(39),G1tensor(2),G1tensor(46))
  call G_TensorShift(G1tensor(260),1)
  call Hotf_4pt_reduction_last(G2tensor(186),RedSet_4(6),mass4set(:,30),  & 
G1tensor(4),G1tensor(83),G1tensor(17),G1tensor(11),G1tensor(5))
  call G_TensorShift(G1tensor(83),8)
  call Hotf_4pt_reduction_last(G2tensor(338),RedSet_4(4),mass4set(:,17),  & 
G1tensor(8),G1tensor(52),G1tensor(10),G1tensor(14),G1tensor(58))
  call G_TensorShift(G1tensor(52),12)
  call Hotf_4pt_reduction_last(G2tensor(219),RedSet_4(6),mass4set(:,31),  & 
G1tensor(16),G1tensor(20),G1tensor(82),G1tensor(22),G1tensor(23))
  call G_TensorShift(G1tensor(20),8)
  call Hotf_4pt_reduction_last(G2tensor(344),RedSet_4(4),mass4set(:,14),  & 
G1tensor(129),G1tensor(26),G1tensor(64),G1tensor(28),G1tensor(41))
  call G_TensorShift(G1tensor(26),12)
  call Hotf_4pt_reduction_last(G2tensor(225),RedSet_4(49),mass4set(:,30),  & 
G1tensor(35),G1tensor(29),G1tensor(135),G1tensor(32),G1tensor(70))
  call G_TensorShift(G1tensor(29),4)
  call Hotf_4pt_reduction_last(G2tensor(314),RedSet_4(17),mass4set(:,17),  & 
G1tensor(34),G1tensor(153),G1tensor(38),G1tensor(76),G1tensor(40))
  call G_TensorShift(G1tensor(153),12)
  call Hotf_4pt_reduction_last(G2tensor(227),RedSet_4(49),mass4set(:,31),  & 
G1tensor(44),G1tensor(45),G1tensor(59),G1tensor(53),G1tensor(47))
  call G_TensorShift(G1tensor(45),4)
  call Hotf_4pt_reduction_last(G2tensor(320),RedSet_4(17),mass4set(:,14),  & 
G1tensor(50),G1tensor(51),G1tensor(56),G1tensor(57),G1tensor(111))
  call G_TensorShift(G1tensor(51),12)
  call Hotf_4pt_reduction_last(G2tensor(94),RedSet_4(50),mass4set(:,32),  & 
G1tensor(62),G1tensor(63),G1tensor(89),G1tensor(77),G1tensor(71))
  call G_TensorShift(G1tensor(63),1)
  call Hotf_4pt_reduction_last(G2tensor(95),RedSet_4(39),mass4set(:,12),  & 
G1tensor(65),G1tensor(117),G1tensor(68),G1tensor(69),G1tensor(123))
  call G_TensorShift(G1tensor(117),5)
  call Hotf_4pt_reduction_last(G2tensor(91),RedSet_4(50),mass4set(:,33),  & 
G1tensor(74),G1tensor(75),G1tensor(80),G1tensor(81),G1tensor(86))
  call G_TensorShift(G1tensor(75),1)
  call Hotf_4pt_reduction_last(G2tensor(92),RedSet_4(39),mass4set(:,34),  & 
G1tensor(87),G1tensor(88),G1tensor(165),G1tensor(92),G1tensor(93))
  call G_TensorShift(G1tensor(88),5)
  call Hotf_4pt_reduction_last(G2tensor(228),RedSet_4(51),mass4set(:,33),  & 
G1tensor(94),G1tensor(95),G1tensor(99),G1tensor(196),G1tensor(124))
  call G_TensorShift(G1tensor(95),2)
  call Hotf_4pt_reduction_last(G2tensor(98),RedSet_4(42),mass4set(:,34),  & 
G1tensor(106),G1tensor(100),G1tensor(143),G1tensor(101),G1tensor(105))
  call G_TensorShift(G1tensor(100),10)
  call Hotf_4pt_reduction_last(G2tensor(230),RedSet_4(51),mass4set(:,32),  & 
G1tensor(149),G1tensor(107),G1tensor(112),G1tensor(131),G1tensor(113))
  call G_TensorShift(G1tensor(107),2)
  call Hotf_4pt_reduction_last(G2tensor(122),RedSet_4(42),mass4set(:,12),  & 
G1tensor(118),G1tensor(137),G1tensor(119),G1tensor(155),G1tensor(125))
  call G_TensorShift(G1tensor(137),10)
  call Hotf_4pt_reduction_last(G2tensor(181),RedSet_4(1),mass4set(:,35),  & 
G1tensor(130),G1tensor(136),G1tensor(141),G1tensor(154),G1tensor(148))
  call G_TensorShift(G1tensor(136),8)
  call Hotf_4pt_reduction_last(G2tensor(107),RedSet_4(42),mass4set(:,36),  & 
G1tensor(142),G1tensor(147),G1tensor(159),G1tensor(160),G1tensor(191))
  call G_TensorShift(G1tensor(147),10)
  call Hotf_4pt_reduction_last(G2tensor(183),RedSet_4(1),mass4set(:,37),  & 
G1tensor(161),G1tensor(166),G1tensor(185),G1tensor(167),G1tensor(171))
  call G_TensorShift(G1tensor(166),8)
  call Hotf_4pt_reduction_last(G2tensor(110),RedSet_4(42),mass4set(:,38),  & 
G1tensor(172),G1tensor(197),G1tensor(173),G1tensor(177),G1tensor(178))
  call G_TensorShift(G1tensor(197),10)
  call Hotf_4pt_reduction_last(G2tensor(212),RedSet_4(1),mass4set(:,39),  & 
G1tensor(203),G1tensor(179),G1tensor(183),G1tensor(184),G1tensor(189))
  call G_TensorShift(G1tensor(179),8)
  call Hotf_4pt_reduction_last(G2tensor(214),RedSet_4(1),mass4set(:,40),  & 
G1tensor(190),G1tensor(195),G1tensor(201),G1tensor(202),G1tensor(207))
  call G_TensorShift(G1tensor(195),8)
  call Hotf_4pt_reduction_last(G2tensor(185),RedSet_4(1),mass4set(:,41),  & 
G1tensor(232),G1tensor(214),G1tensor(208),G1tensor(239),G1tensor(209))
  call G_TensorShift(G1tensor(214),8)
  call Hotf_4pt_reduction_last(G2tensor(188),RedSet_4(11),mass4set(:,35),  & 
G1tensor(213),G1tensor(245),G1tensor(215),G1tensor(219),G1tensor(220))
  call G_TensorShift(G1tensor(245),4)
  call Hotf_4pt_reduction_last(G2tensor(125),RedSet_4(27),mass4set(:,36),  & 
G1tensor(251),G1tensor(221),G1tensor(225),G1tensor(226),G1tensor(257))
  call G_TensorShift(G1tensor(221),6)
  call Hotf_4pt_reduction_last(G2tensor(190),RedSet_4(11),mass4set(:,37),  & 
G1tensor(227),G1tensor(231),G1tensor(263),G1tensor(233),G1tensor(237))
  call G_TensorShift(G1tensor(231),4)
  call Hotf_4pt_reduction_last(G2tensor(128),RedSet_4(27),mass4set(:,38),  & 
G1tensor(262),G1tensor(244),G1tensor(238),G1tensor(243),G1tensor(249))
  call G_TensorShift(G1tensor(244),6)
  call Hotf_4pt_reduction_last(G2tensor(215),RedSet_4(11),mass4set(:,39),  & 
G1tensor(250),G1tensor(255),G1tensor(256),G1tensor(261),G1tensor(265))
  call G_TensorShift(G1tensor(255),4)
  call Hotf_4pt_reduction_last(G2tensor(287),RedSet_4(27),mass4set(:,12),  & 
G1tensor(266),G1tensor(267),G1tensor(268),G1tensor(269),G1tensor(270))
  call G_TensorShift(G1tensor(267),6)
  call Hotf_4pt_reduction_last(G2tensor(217),RedSet_4(11),mass4set(:,40),  & 
G1tensor(271),G1tensor(272),G1tensor(273),G1tensor(274),G1tensor(275))
  call G_TensorShift(G1tensor(272),4)
  call Hotf_4pt_reduction_last(G2tensor(192),RedSet_4(11),mass4set(:,41),  & 
G1tensor(276),G1tensor(277),G1tensor(278),G1tensor(279),G1tensor(280))
  call G_TensorShift(G1tensor(277),4)
  call Hotf_4pt_reduction_last(G2tensor(42),RedSet_4(52),mass4set(:,42),  & 
G1tensor(281),G1tensor(282),G1tensor(283),G1tensor(284),G1tensor(285))
  call G_TensorShift(G1tensor(282),4)
  call Hotf_4pt_reduction_last(G2tensor(182),RedSet_4(2),mass4set(:,43),  & 
G1tensor(286),G1tensor(287),G1tensor(288),G1tensor(289),G1tensor(290))
  call G_TensorShift(G1tensor(287),8)
  call Hotf_4pt_reduction_last(G2tensor(54),RedSet_4(3),mass4set(:,3),  & 
G1tensor(291),G1tensor(292),G1tensor(293),G1tensor(294),G1tensor(295))
  call G_TensorShift(G1tensor(292),8)
  call Hotf_4pt_reduction_last(G2tensor(87),RedSet_4(52),mass4set(:,44),  & 
G1tensor(296),G1tensor(297),G1tensor(298),G1tensor(299),G1tensor(300))
  call G_TensorShift(G1tensor(297),4)
  call Hotf_4pt_reduction_last(G2tensor(184),RedSet_4(2),mass4set(:,45),  & 
G1tensor(301),G1tensor(302),G1tensor(303),G1tensor(304),G1tensor(305))
  call G_TensorShift(G1tensor(302),8)
  call Hotf_4pt_reduction_last(G2tensor(81),RedSet_4(52),mass4set(:,46),  & 
G1tensor(306),G1tensor(307),G1tensor(308),G1tensor(309),G1tensor(310))
  call G_TensorShift(G1tensor(307),4)
  call Hotf_4pt_reduction_last(G2tensor(231),RedSet_4(2),mass4set(:,1),  & 
G1tensor(311),G1tensor(312),G1tensor(313),G1tensor(314),G1tensor(315))
  call G_TensorShift(G1tensor(312),8)
  call Hotf_4pt_reduction_last(G2tensor(132),RedSet_4(48),mass4set(:,47),  & 
G1tensor(316),G1tensor(317),G1tensor(318),G1tensor(319),G1tensor(320))
  call G_TensorShift(G1tensor(317),1)
  call Hotf_4pt_reduction_last(G2tensor(187),RedSet_4(7),mass4set(:,48),  & 
G1tensor(321),G1tensor(322),G1tensor(323),G1tensor(324),G1tensor(325))
  call G_TensorShift(G1tensor(322),8)
  call Hotf_4pt_reduction_last(G2tensor(114),RedSet_4(8),mass4set(:,2),  & 
G1tensor(326),G1tensor(327),G1tensor(328),G1tensor(329),G1tensor(330))
  call G_TensorShift(G1tensor(327),8)
  call Hotf_4pt_reduction_last(G2tensor(1),RedSet_4(6),mass4set(:,42),  & 
G1tensor(331),G1tensor(332),G1tensor(333),G1tensor(334),G1tensor(335))
  call G_TensorShift(G1tensor(332),8)
  call Hotf_4pt_reduction_last(G2tensor(189),RedSet_4(12),mass4set(:,43),  & 
G1tensor(336),G1tensor(337),G1tensor(338),G1tensor(339),G1tensor(340))
  call G_TensorShift(G1tensor(337),4)
  call Hotf_4pt_reduction_last(G2tensor(3),RedSet_4(13),mass4set(:,3),  & 
G1tensor(341),G1tensor(342),G1tensor(343),G1tensor(344),G1tensor(345))
  call G_TensorShift(G1tensor(342),4)
  call Hotf_4pt_reduction_last(G2tensor(9),RedSet_4(6),mass4set(:,44),  & 
G1tensor(346),G1tensor(347),G1tensor(348),G1tensor(349),G1tensor(350))
  call G_TensorShift(G1tensor(347),8)
  call Hotf_4pt_reduction_last(G2tensor(191),RedSet_4(12),mass4set(:,45),  & 
G1tensor(351),G1tensor(352),G1tensor(353),G1tensor(354),G1tensor(355))
  call G_TensorShift(G1tensor(352),4)
  call Hotf_4pt_reduction_last(G2tensor(7),RedSet_4(6),mass4set(:,46),  & 
G1tensor(356),G1tensor(357),G1tensor(358),G1tensor(359),G1tensor(360))
  call G_TensorShift(G1tensor(357),8)
  call Hotf_4pt_reduction_last(G2tensor(233),RedSet_4(12),mass4set(:,1),  & 
G1tensor(361),G1tensor(362),G1tensor(363),G1tensor(364),G1tensor(365))
  call G_TensorShift(G1tensor(362),4)
  call Hotf_4pt_reduction_last(G2tensor(11),RedSet_4(49),mass4set(:,42),  & 
G1tensor(366),G1tensor(367),G1tensor(368),G1tensor(369),G1tensor(370))
  call G_TensorShift(G1tensor(367),4)
  call Hotf_4pt_reduction_last(G2tensor(193),RedSet_4(15),mass4set(:,35),  & 
G1tensor(371),G1tensor(372),G1tensor(373),G1tensor(374),G1tensor(375))
  call G_TensorShift(G1tensor(372),8)
  call Hotf_4pt_reduction_last(G2tensor(13),RedSet_4(16),mass4set(:,3),  & 
G1tensor(376),G1tensor(377),G1tensor(378),G1tensor(379),G1tensor(380))
  call G_TensorShift(G1tensor(377),8)
  call Hotf_4pt_reduction_last(G2tensor(19),RedSet_4(49),mass4set(:,44),  & 
G1tensor(381),G1tensor(382),G1tensor(383),G1tensor(384),G1tensor(385))
  call G_TensorShift(G1tensor(382),4)
  call Hotf_4pt_reduction_last(G2tensor(194),RedSet_4(15),mass4set(:,37),  & 
G1tensor(386),G1tensor(387),G1tensor(388),G1tensor(389),G1tensor(390))
  call G_TensorShift(G1tensor(387),8)
  call Hotf_4pt_reduction_last(G2tensor(17),RedSet_4(49),mass4set(:,46),  & 
G1tensor(391),G1tensor(392),G1tensor(393),G1tensor(394),G1tensor(395))
  call G_TensorShift(G1tensor(392),4)
  call Hotf_4pt_reduction_last(G2tensor(195),RedSet_4(15),mass4set(:,41),  & 
G1tensor(396),G1tensor(397),G1tensor(398),G1tensor(399),G1tensor(400))
  call G_TensorShift(G1tensor(397),8)
  call Hotf_4pt_reduction_last(G2tensor(21),RedSet_4(33),mass4set(:,42),  & 
G1tensor(401),G1tensor(402),G1tensor(403),G1tensor(404),G1tensor(405))
  call G_TensorShift(G1tensor(402),8)
  call Hotf_4pt_reduction_last(G2tensor(196),RedSet_4(19),mass4set(:,35),  & 
G1tensor(406),G1tensor(407),G1tensor(408),G1tensor(409),G1tensor(410))
  call G_TensorShift(G1tensor(407),4)
  call Hotf_4pt_reduction_last(G2tensor(23),RedSet_4(20),mass4set(:,3),  & 
G1tensor(411),G1tensor(412),G1tensor(413),G1tensor(414),G1tensor(415))
  call G_TensorShift(G1tensor(412),4)
  call Hotf_4pt_reduction_last(G2tensor(29),RedSet_4(33),mass4set(:,44),  & 
G1tensor(416),G1tensor(417),G1tensor(418),G1tensor(419),G1tensor(420))
  call G_TensorShift(G1tensor(417),8)
  call Hotf_4pt_reduction_last(G2tensor(197),RedSet_4(19),mass4set(:,37),  & 
G1tensor(421),G1tensor(422),G1tensor(423),G1tensor(424),G1tensor(425))
  call G_TensorShift(G1tensor(422),4)
  call Hotf_4pt_reduction_last(G2tensor(27),RedSet_4(33),mass4set(:,46),  & 
G1tensor(426),G1tensor(427),G1tensor(428),G1tensor(429),G1tensor(430))
  call G_TensorShift(G1tensor(427),8)
  call Hotf_4pt_reduction_last(G2tensor(198),RedSet_4(19),mass4set(:,41),  & 
G1tensor(431),G1tensor(432),G1tensor(433),G1tensor(434),G1tensor(435))
  call G_TensorShift(G1tensor(432),4)
  call Hotf_4pt_reduction_last(G2tensor(33),RedSet_4(53),mass4set(:,49),  & 
G1tensor(436),G1tensor(437),G1tensor(438),G1tensor(439),G1tensor(440))
  call G_TensorShift(G1tensor(437),1)
  call Hotf_4pt_reduction_last(G2tensor(199),RedSet_4(22),mass4set(:,50),  & 
G1tensor(441),G1tensor(442),G1tensor(443),G1tensor(444),G1tensor(445))
  call G_TensorShift(G1tensor(442),8)
  call Hotf_4pt_reduction_last(G2tensor(39),RedSet_4(54),mass4set(:,49),  & 
G1tensor(446),G1tensor(447),G1tensor(448),G1tensor(449),G1tensor(450))
  call G_TensorShift(G1tensor(447),2)
  call Hotf_4pt_reduction_last(G2tensor(200),RedSet_4(25),mass4set(:,50),  & 
G1tensor(451),G1tensor(452),G1tensor(453),G1tensor(454),G1tensor(455))
  call G_TensorShift(G1tensor(452),4)
  call Hotf_4pt_reduction_last(G2tensor(201),RedSet_4(26),mass4set(:,48),  & 
G1tensor(456),G1tensor(457),G1tensor(458),G1tensor(459),G1tensor(460))
  call G_TensorShift(G1tensor(457),4)
  call Hotf_4pt_reduction_last(G2tensor(51),RedSet_4(11),mass4set(:,51),  & 
G1tensor(461),G1tensor(462),G1tensor(463),G1tensor(464),G1tensor(465))
  call G_TensorShift(G1tensor(462),4)
  call Hotf_4pt_reduction_last(G2tensor(202),RedSet_4(29),mass4set(:,52),  & 
G1tensor(466),G1tensor(467),G1tensor(468),G1tensor(469),G1tensor(470))
  call G_TensorShift(G1tensor(467),2)
  call Hotf_4pt_reduction_last(G2tensor(203),RedSet_4(30),mass4set(:,53),  & 
G1tensor(471),G1tensor(472),G1tensor(473),G1tensor(474),G1tensor(475))
  call G_TensorShift(G1tensor(472),2)
  call Hotf_4pt_reduction_last(G2tensor(45),RedSet_4(31),mass4set(:,4),  & 
G1tensor(476),G1tensor(477),G1tensor(478),G1tensor(479),G1tensor(480))
  call G_TensorShift(G1tensor(477),2)
  call Hotf_4pt_reduction_last(G2tensor(66),RedSet_4(33),mass4set(:,54),  & 
G1tensor(481),G1tensor(482),G1tensor(483),G1tensor(484),G1tensor(485))
  call G_TensorShift(G1tensor(482),8)
  call Hotf_4pt_reduction_last(G2tensor(57),RedSet_4(34),mass4set(:,6),  & 
G1tensor(486),G1tensor(487),G1tensor(488),G1tensor(489),G1tensor(490))
  call G_TensorShift(G1tensor(487),8)
  call Hotf_4pt_reduction_last(G2tensor(60),RedSet_4(8),mass4set(:,55),  & 
G1tensor(491),G1tensor(492),G1tensor(493),G1tensor(494),G1tensor(495))
  call G_TensorShift(G1tensor(492),8)
  call Hotf_4pt_reduction_last(G2tensor(63),RedSet_4(33),mass4set(:,56),  & 
G1tensor(496),G1tensor(497),G1tensor(498),G1tensor(499),G1tensor(500))
  call G_TensorShift(G1tensor(497),8)
  call Hotf_4pt_reduction_last(G2tensor(69),RedSet_4(8),mass4set(:,57),  & 
G1tensor(501),G1tensor(502),G1tensor(503),G1tensor(504),G1tensor(505))
  call G_TensorShift(G1tensor(502),8)
  call Hotf_4pt_reduction_last(G2tensor(75),RedSet_4(34),mass4set(:,58),  & 
G1tensor(506),G1tensor(507),G1tensor(508),G1tensor(509),G1tensor(510))
  call G_TensorShift(G1tensor(507),8)
  call Hotf_4pt_reduction_last(G2tensor(78),RedSet_4(8),mass4set(:,59),  & 
G1tensor(511),G1tensor(512),G1tensor(513),G1tensor(514),G1tensor(515))
  call G_TensorShift(G1tensor(512),8)
  call Hotf_4pt_reduction_last(G2tensor(90),RedSet_4(34),mass4set(:,60),  & 
G1tensor(516),G1tensor(517),G1tensor(518),G1tensor(519),G1tensor(520))
  call G_TensorShift(G1tensor(517),8)
  call Hotf_4pt_reduction_last(G2tensor(96),RedSet_4(8),mass4set(:,61),  & 
G1tensor(521),G1tensor(522),G1tensor(523),G1tensor(524),G1tensor(525))
  call G_TensorShift(G1tensor(522),8)
  call Hotf_4pt_reduction_last(G2tensor(239),RedSet_4(8),mass4set(:,5),  & 
G1tensor(526),G1tensor(527),G1tensor(528),G1tensor(529),G1tensor(530))
  call G_TensorShift(G1tensor(527),8)
  call Hotf_4pt_reduction_last(G2tensor(102),RedSet_4(7),mass4set(:,58),  & 
G1tensor(531),G1tensor(532),G1tensor(533),G1tensor(534),G1tensor(535))
  call G_TensorShift(G1tensor(532),8)
  call Hotf_4pt_reduction_last(G2tensor(120),RedSet_4(7),mass4set(:,60),  & 
G1tensor(536),G1tensor(537),G1tensor(538),G1tensor(539),G1tensor(540))
  call G_TensorShift(G1tensor(537),8)
  call Hotf_4pt_reduction_last(G2tensor(108),RedSet_4(6),mass4set(:,54),  & 
G1tensor(541),G1tensor(542),G1tensor(543),G1tensor(544),G1tensor(545))
  call G_TensorShift(G1tensor(542),8)
  call Hotf_4pt_reduction_last(G2tensor(242),RedSet_4(7),mass4set(:,6),  & 
G1tensor(546),G1tensor(547),G1tensor(548),G1tensor(549),G1tensor(550))
  call G_TensorShift(G1tensor(547),8)
  call Hotf_4pt_reduction_last(G2tensor(111),RedSet_4(6),mass4set(:,56),  & 
G1tensor(551),G1tensor(552),G1tensor(553),G1tensor(554),G1tensor(555))
  call G_TensorShift(G1tensor(552),8)
  call Hotf_4pt_reduction_last(G2tensor(117),RedSet_4(11),mass4set(:,62),  & 
G1tensor(556),G1tensor(557),G1tensor(558),G1tensor(559),G1tensor(560))
  call G_TensorShift(G1tensor(557),4)
  call Hotf_4pt_reduction_last(G2tensor(245),RedSet_4(12),mass4set(:,7),  & 
G1tensor(561),G1tensor(562),G1tensor(563),G1tensor(564),G1tensor(565))
  call G_TensorShift(G1tensor(562),4)
  call Hotf_4pt_reduction_last(G2tensor(123),RedSet_4(13),mass4set(:,63),  & 
G1tensor(566),G1tensor(567),G1tensor(568),G1tensor(569),G1tensor(570))
  call G_TensorShift(G1tensor(567),4)
  call Hotf_4pt_reduction_last(G2tensor(251),RedSet_4(12),mass4set(:,8),  & 
G1tensor(571),G1tensor(572),G1tensor(573),G1tensor(574),G1tensor(575))
  call G_TensorShift(G1tensor(572),4)
  call Hotf_4pt_reduction_last(G2tensor(129),RedSet_4(13),mass4set(:,64),  & 
G1tensor(576),G1tensor(577),G1tensor(578),G1tensor(579),G1tensor(580))
  call G_TensorShift(G1tensor(577),4)
  call Hotf_4pt_reduction_last(G2tensor(138),RedSet_4(15),mass4set(:,62),  & 
G1tensor(581),G1tensor(582),G1tensor(583),G1tensor(584),G1tensor(585))
  call G_TensorShift(G1tensor(582),8)
  call Hotf_4pt_reduction_last(G2tensor(254),RedSet_4(2),mass4set(:,7),  & 
G1tensor(586),G1tensor(587),G1tensor(588),G1tensor(589),G1tensor(590))
  call G_TensorShift(G1tensor(587),8)
  call Hotf_4pt_reduction_last(G2tensor(135),RedSet_4(16),mass4set(:,63),  & 
G1tensor(591),G1tensor(592),G1tensor(593),G1tensor(594),G1tensor(595))
  call G_TensorShift(G1tensor(592),8)
  call Hotf_4pt_reduction_last(G2tensor(143),RedSet_4(15),mass4set(:,51),  & 
G1tensor(596),G1tensor(597),G1tensor(598),G1tensor(599),G1tensor(600))
  call G_TensorShift(G1tensor(597),8)
  call Hotf_4pt_reduction_last(G2tensor(260),RedSet_4(2),mass4set(:,8),  & 
G1tensor(601),G1tensor(602),G1tensor(603),G1tensor(604),G1tensor(605))
  call G_TensorShift(G1tensor(602),8)
  call Hotf_4pt_reduction_last(G2tensor(144),RedSet_4(16),mass4set(:,64),  & 
G1tensor(606),G1tensor(607),G1tensor(608),G1tensor(609),G1tensor(610))
  call G_TensorShift(G1tensor(607),8)
  call Hotf_4pt_reduction_last(G2tensor(149),RedSet_4(37),mass4set(:,65),  & 
G1tensor(611),G1tensor(612),G1tensor(613),G1tensor(614),G1tensor(615))
  call G_TensorShift(G1tensor(612),4)
  call Hotf_4pt_reduction_last(G2tensor(150),RedSet_4(38),mass4set(:,66),  & 
G1tensor(616),G1tensor(617),G1tensor(618),G1tensor(619),G1tensor(620))
  call G_TensorShift(G1tensor(617),4)
  call Hotf_4pt_reduction_last(G2tensor(147),RedSet_4(37),mass4set(:,67),  & 
G1tensor(621),G1tensor(622),G1tensor(623),G1tensor(624),G1tensor(625))
  call G_TensorShift(G1tensor(622),4)
  call Hotf_4pt_reduction_last(G2tensor(148),RedSet_4(38),mass4set(:,6),  & 
G1tensor(626),G1tensor(627),G1tensor(628),G1tensor(629),G1tensor(630))
  call G_TensorShift(G1tensor(627),4)
  call Hotf_4pt_reduction_last(G2tensor(151),RedSet_4(41),mass4set(:,67),  & 
G1tensor(631),G1tensor(632),G1tensor(633),G1tensor(634),G1tensor(635))
  call G_TensorShift(G1tensor(632),8)
  call Hotf_4pt_reduction_last(G2tensor(154),RedSet_4(41),mass4set(:,65),  & 
G1tensor(636),G1tensor(637),G1tensor(638),G1tensor(639),G1tensor(640))
  call G_TensorShift(G1tensor(637),8)
  call Hotf_4pt_reduction_last(G2tensor(155),RedSet_4(34),mass4set(:,66),  & 
G1tensor(641),G1tensor(642),G1tensor(643),G1tensor(644),G1tensor(645))
  call G_TensorShift(G1tensor(642),8)
  call Hotf_4pt_reduction_last(G2tensor(156),RedSet_4(44),mass4set(:,68),  & 
G1tensor(646),G1tensor(647),G1tensor(648),G1tensor(649),G1tensor(650))
  call G_TensorShift(G1tensor(647),2)
  call Hotf_4pt_reduction_last(G2tensor(157),RedSet_4(45),mass4set(:,69),  & 
G1tensor(651),G1tensor(652),G1tensor(653),G1tensor(654),G1tensor(655))
  call G_TensorShift(G1tensor(652),2)
  call Hotf_4pt_reduction_last(G2tensor(158),RedSet_4(31),mass4set(:,70),  & 
G1tensor(656),G1tensor(657),G1tensor(658),G1tensor(659),G1tensor(660))
  call G_TensorShift(G1tensor(657),2)
  call Hotf_4pt_reduction_last(G2tensor(159),RedSet_4(44),mass4set(:,71),  & 
G1tensor(661),G1tensor(662),G1tensor(663),G1tensor(664),G1tensor(665))
  call G_TensorShift(G1tensor(662),2)
  call Hotf_4pt_reduction_last(G2tensor(160),RedSet_4(31),mass4set(:,72),  & 
G1tensor(666),G1tensor(667),G1tensor(668),G1tensor(669),G1tensor(670))
  call G_TensorShift(G1tensor(667),2)
  call Hotf_4pt_reduction_last(G2tensor(161),RedSet_4(44),mass4set(:,73),  & 
G1tensor(671),G1tensor(672),G1tensor(673),G1tensor(674),G1tensor(675))
  call G_TensorShift(G1tensor(672),2)
  call Hotf_4pt_reduction_last(G2tensor(162),RedSet_4(45),mass4set(:,74),  & 
G1tensor(676),G1tensor(677),G1tensor(678),G1tensor(679),G1tensor(680))
  call G_TensorShift(G1tensor(677),2)
  call Hotf_4pt_reduction_last(G2tensor(163),RedSet_4(31),mass4set(:,75),  & 
G1tensor(681),G1tensor(682),G1tensor(683),G1tensor(684),G1tensor(685))
  call G_TensorShift(G1tensor(682),2)
  call Hotf_4pt_reduction_last(G2tensor(168),RedSet_4(44),mass4set(:,76),  & 
G1tensor(686),G1tensor(687),G1tensor(688),G1tensor(689),G1tensor(690))
  call G_TensorShift(G1tensor(687),2)
  call Hotf_4pt_reduction_last(G2tensor(169),RedSet_4(45),mass4set(:,77),  & 
G1tensor(691),G1tensor(692),G1tensor(693),G1tensor(694),G1tensor(695))
  call G_TensorShift(G1tensor(692),2)
  call Hotf_4pt_reduction_last(G2tensor(170),RedSet_4(31),mass4set(:,78),  & 
G1tensor(696),G1tensor(697),G1tensor(698),G1tensor(699),G1tensor(700))
  call G_TensorShift(G1tensor(697),2)
  call Hotf_4pt_reduction_last(G2tensor(167),RedSet_4(44),mass4set(:,79),  & 
G1tensor(701),G1tensor(702),G1tensor(703),G1tensor(704),G1tensor(705))
  call G_TensorShift(G1tensor(702),2)
  call Hotf_4pt_reduction_last(G2tensor(263),RedSet_4(31),mass4set(:,9),  & 
G1tensor(706),G1tensor(707),G1tensor(708),G1tensor(709),G1tensor(710))
  call G_TensorShift(G1tensor(707),2)
  call Hotf_4pt_reduction_last(G2tensor(171),RedSet_4(29),mass4set(:,68),  & 
G1tensor(711),G1tensor(712),G1tensor(713),G1tensor(714),G1tensor(715))
  call G_TensorShift(G1tensor(712),2)
  call Hotf_4pt_reduction_last(G2tensor(172),RedSet_4(30),mass4set(:,69),  & 
G1tensor(716),G1tensor(717),G1tensor(718),G1tensor(719),G1tensor(720))
  call G_TensorShift(G1tensor(717),2)
  call Hotf_4pt_reduction_last(G2tensor(173),RedSet_4(29),mass4set(:,71),  & 
G1tensor(721),G1tensor(722),G1tensor(723),G1tensor(724),G1tensor(725))
  call G_TensorShift(G1tensor(722),2)
  call Hotf_4pt_reduction_last(G2tensor(174),RedSet_4(29),mass4set(:,73),  & 
G1tensor(726),G1tensor(727),G1tensor(728),G1tensor(729),G1tensor(730))
  call G_TensorShift(G1tensor(727),2)
  call Hotf_4pt_reduction_last(G2tensor(175),RedSet_4(30),mass4set(:,74),  & 
G1tensor(731),G1tensor(732),G1tensor(733),G1tensor(734),G1tensor(735))
  call G_TensorShift(G1tensor(732),2)
  call Hotf_4pt_reduction_last(G2tensor(179),RedSet_4(29),mass4set(:,76),  & 
G1tensor(736),G1tensor(737),G1tensor(738),G1tensor(739),G1tensor(740))
  call G_TensorShift(G1tensor(737),2)
  call Hotf_4pt_reduction_last(G2tensor(180),RedSet_4(30),mass4set(:,77),  & 
G1tensor(741),G1tensor(742),G1tensor(743),G1tensor(744),G1tensor(745))
  call G_TensorShift(G1tensor(742),2)
  call Hotf_4pt_reduction_last(G2tensor(178),RedSet_4(29),mass4set(:,79),  & 
G1tensor(746),G1tensor(747),G1tensor(748),G1tensor(749),G1tensor(750))
  call G_TensorShift(G1tensor(747),2)
  call Hotf_4pt_reduction_last(G2tensor(204),RedSet_4(15),mass4set(:,39),  & 
G1tensor(751),G1tensor(752),G1tensor(753),G1tensor(754),G1tensor(755))
  call G_TensorShift(G1tensor(752),8)
  call Hotf_4pt_reduction_last(G2tensor(206),RedSet_4(15),mass4set(:,40),  & 
G1tensor(756),G1tensor(757),G1tensor(758),G1tensor(759),G1tensor(760))
  call G_TensorShift(G1tensor(757),8)
  call Hotf_4pt_reduction_last(G2tensor(207),RedSet_4(19),mass4set(:,39),  & 
G1tensor(761),G1tensor(762),G1tensor(763),G1tensor(764),G1tensor(765))
  call G_TensorShift(G1tensor(762),4)
  call Hotf_4pt_reduction_last(G2tensor(209),RedSet_4(19),mass4set(:,40),  & 
G1tensor(766),G1tensor(767),G1tensor(768),G1tensor(769),G1tensor(770))
  call G_TensorShift(G1tensor(767),4)
  call Hotf_4pt_reduction_last(G2tensor(211),RedSet_4(22),mass4set(:,80),  & 
G1tensor(771),G1tensor(772),G1tensor(773),G1tensor(774),G1tensor(775))
  call G_TensorShift(G1tensor(772),8)
  call Hotf_4pt_reduction_last(G2tensor(220),RedSet_4(54),mass4set(:,81),  & 
G1tensor(776),G1tensor(777),G1tensor(778),G1tensor(779),G1tensor(780))
  call G_TensorShift(G1tensor(777),2)
  call Hotf_4pt_reduction_last(G2tensor(221),RedSet_4(52),mass4set(:,54),  & 
G1tensor(781),G1tensor(782),G1tensor(783),G1tensor(784),G1tensor(785))
  call G_TensorShift(G1tensor(782),4)
  call Hotf_4pt_reduction_last(G2tensor(222),RedSet_4(52),mass4set(:,56),  & 
G1tensor(786),G1tensor(787),G1tensor(788),G1tensor(789),G1tensor(790))
  call G_TensorShift(G1tensor(787),4)
  call Hotf_4pt_reduction_last(G2tensor(223),RedSet_4(49),mass4set(:,54),  & 
G1tensor(791),G1tensor(792),G1tensor(793),G1tensor(794),G1tensor(795))
  call G_TensorShift(G1tensor(792),4)
  call Hotf_4pt_reduction_last(G2tensor(224),RedSet_4(49),mass4set(:,56),  & 
G1tensor(796),G1tensor(797),G1tensor(798),G1tensor(799),G1tensor(800))
  call G_TensorShift(G1tensor(797),4)
  call Hotf_4pt_reduction_last(G2tensor(266),RedSet_4(12),mass4set(:,10),  & 
G1tensor(801),G1tensor(802),G1tensor(803),G1tensor(804),G1tensor(805))
  call G_TensorShift(G1tensor(802),4)
  call Hotf_4pt_reduction_last(G2tensor(272),RedSet_4(12),mass4set(:,11),  & 
G1tensor(806),G1tensor(807),G1tensor(808),G1tensor(809),G1tensor(810))
  call G_TensorShift(G1tensor(807),4)
  call Hotf_4pt_reduction_last(G2tensor(275),RedSet_4(2),mass4set(:,10),  & 
G1tensor(811),G1tensor(812),G1tensor(813),G1tensor(814),G1tensor(815))
  call G_TensorShift(G1tensor(812),8)
  call Hotf_4pt_reduction_last(G2tensor(281),RedSet_4(2),mass4set(:,11),  & 
G1tensor(816),G1tensor(817),G1tensor(818),G1tensor(819),G1tensor(820))
  call G_TensorShift(G1tensor(817),8)
  call Hotf_4pt_reduction_last(G2tensor(293),RedSet_4(23),mass4set(:,12),  & 
G1tensor(821),G1tensor(822),G1tensor(823),G1tensor(824),G1tensor(825))
  call G_TensorShift(G1tensor(822),9)
  call Hotf_4pt_reduction_last(G2tensor(308),RedSet_4(17),mass4set(:,15),  & 
G1tensor(826),G1tensor(827),G1tensor(828),G1tensor(829),G1tensor(830))
  call G_TensorShift(G1tensor(827),12)
  call Hotf_4pt_reduction_last(G2tensor(311),RedSet_4(17),mass4set(:,16),  & 
G1tensor(831),G1tensor(832),G1tensor(833),G1tensor(834),G1tensor(835))
  call G_TensorShift(G1tensor(832),12)
  call Hotf_4pt_reduction_last(G2tensor(332),RedSet_4(4),mass4set(:,15),  & 
G1tensor(836),G1tensor(837),G1tensor(838),G1tensor(839),G1tensor(840))
  call G_TensorShift(G1tensor(837),12)
  call Hotf_4pt_reduction_last(G2tensor(335),RedSet_4(4),mass4set(:,16),  & 
G1tensor(841),G1tensor(842),G1tensor(843),G1tensor(844),G1tensor(845))
  call G_TensorShift(G1tensor(842),12)
  call Hotf_4pt_reduction_last(G1tensor(1),RedSet_4(4),mass4set(:,19),  & 
G0tensor(1),G0tensor(2),G0tensor(3),G0tensor(4),G0tensor(5))
  call Hotf_4pt_reduction_last(G1tensor(31),RedSet_4(4),mass4set(:,20),  & 
G0tensor(6),G0tensor(7),G0tensor(8),G0tensor(9),G0tensor(10))
  call Hotf_4pt_reduction_last(G1tensor(61),RedSet_4(4),mass4set(:,18),  & 
G0tensor(11),G0tensor(12),G0tensor(13),G0tensor(14),G0tensor(15))
  call Hotf_4pt_reduction_last(G1tensor(91),RedSet_4(9),mass4set(:,21),  & 
G0tensor(16),G0tensor(17),G0tensor(18),G0tensor(19),G0tensor(20))
  call Hotf_4pt_reduction_last(G1tensor(121),RedSet_4(17),mass4set(:,19),  & 
G0tensor(21),G0tensor(22),G0tensor(23),G0tensor(24),G0tensor(25))
  call Hotf_4pt_reduction_last(G1tensor(151),RedSet_4(17),mass4set(:,20),  & 
G0tensor(26),G0tensor(27),G0tensor(28),G0tensor(29),G0tensor(30))
  call Hotf_4pt_reduction_last(G1tensor(181),RedSet_4(17),mass4set(:,18),  & 
G0tensor(31),G0tensor(32),G0tensor(33),G0tensor(34),G0tensor(35))
  call Hotf_4pt_reduction_last(G1tensor(211),RedSet_4(23),mass4set(:,22),  & 
G0tensor(36),G0tensor(37),G0tensor(38),G0tensor(39),G0tensor(40))
  call Hotf_4pt_reduction_last(G1tensor(241),RedSet_4(27),mass4set(:,22),  & 
G0tensor(41),G0tensor(42),G0tensor(43),G0tensor(44),G0tensor(45))
  call Hotf_4pt_reduction_last(G1tensor(6),RedSet_4(47),mass4set(:,23),  & 
G0tensor(46),G0tensor(47),G0tensor(48),G0tensor(49),G0tensor(50))
  call Hotf_4pt_reduction_last(G1tensor(24),RedSet_4(35),mass4set(:,24),  & 
G0tensor(51),G0tensor(52),G0tensor(53),G0tensor(54),G0tensor(55))
  call Hotf_4pt_reduction_last(G1tensor(78),RedSet_4(47),mass4set(:,25),  & 
G0tensor(56),G0tensor(57),G0tensor(58),G0tensor(59),G0tensor(60))
  call Hotf_4pt_reduction_last(G1tensor(98),RedSet_4(35),mass4set(:,26),  & 
G0tensor(61),G0tensor(62),G0tensor(63),G0tensor(64),G0tensor(65))
  call Hotf_4pt_reduction_last(G1tensor(126),RedSet_4(47),mass4set(:,27),  & 
G0tensor(66),G0tensor(67),G0tensor(68),G0tensor(69),G0tensor(70))
  call Hotf_4pt_reduction_last(G1tensor(128),RedSet_4(35),mass4set(:,13),  & 
G0tensor(71),G0tensor(72),G0tensor(73),G0tensor(74),G0tensor(75))
  call Hotf_4pt_reduction_last(G1tensor(140),RedSet_4(47),mass4set(:,28),  & 
G0tensor(76),G0tensor(77),G0tensor(78),G0tensor(79),G0tensor(80))
  call Hotf_4pt_reduction_last(G1tensor(158),RedSet_4(47),mass4set(:,29),  & 
G0tensor(81),G0tensor(82),G0tensor(83),G0tensor(84),G0tensor(85))
  call Hotf_4pt_reduction_last(G1tensor(170),RedSet_4(48),mass4set(:,27),  & 
G0tensor(86),G0tensor(87),G0tensor(88),G0tensor(89),G0tensor(90))
  call Hotf_4pt_reduction_last(G1tensor(186),RedSet_4(9),mass4set(:,13),  & 
G0tensor(91),G0tensor(92),G0tensor(93),G0tensor(94),G0tensor(95))
  call Hotf_4pt_reduction_last(G1tensor(200),RedSet_4(48),mass4set(:,28),  & 
G0tensor(96),G0tensor(97),G0tensor(98),G0tensor(99),G0tensor(100))
  call Hotf_4pt_reduction_last(G1tensor(206),RedSet_4(48),mass4set(:,23),  & 
G0tensor(101),G0tensor(102),G0tensor(103),G0tensor(104),G0tensor(105))
  call Hotf_4pt_reduction_last(G1tensor(216),RedSet_4(9),mass4set(:,24),  & 
G0tensor(106),G0tensor(107),G0tensor(108),G0tensor(109),G0tensor(110))
  call Hotf_4pt_reduction_last(G1tensor(236),RedSet_4(48),mass4set(:,25),  & 
G0tensor(111),G0tensor(112),G0tensor(113),G0tensor(114),G0tensor(115))
  call Hotf_4pt_reduction_last(G1tensor(246),RedSet_4(9),mass4set(:,26),  & 
G0tensor(116),G0tensor(117),G0tensor(118),G0tensor(119),G0tensor(120))
  call Hotf_4pt_reduction_last(G1tensor(254),RedSet_4(48),mass4set(:,29),  & 
G0tensor(121),G0tensor(122),G0tensor(123),G0tensor(124),G0tensor(125))
  call Hotf_4pt_reduction_last(G1tensor(4),RedSet_4(6),mass4set(:,30),  & 
G0tensor(126),G0tensor(127),G0tensor(128),G0tensor(129),G0tensor(130))
  call Hotf_4pt_reduction_last(G1tensor(8),RedSet_4(4),mass4set(:,17),  & 
G0tensor(131),G0tensor(132),G0tensor(133),G0tensor(134),G0tensor(135))
  call Hotf_4pt_reduction_last(G1tensor(16),RedSet_4(6),mass4set(:,31),  & 
G0tensor(136),G0tensor(137),G0tensor(138),G0tensor(139),G0tensor(140))
  call Hotf_4pt_reduction_last(G1tensor(129),RedSet_4(4),mass4set(:,14),  & 
G0tensor(141),G0tensor(142),G0tensor(143),G0tensor(144),G0tensor(145))
  call Hotf_4pt_reduction_last(G1tensor(35),RedSet_4(49),mass4set(:,30),  & 
G0tensor(146),G0tensor(147),G0tensor(148),G0tensor(149),G0tensor(150))
  call Hotf_4pt_reduction_last(G1tensor(34),RedSet_4(17),mass4set(:,17),  & 
G0tensor(151),G0tensor(152),G0tensor(153),G0tensor(154),G0tensor(155))
  call Hotf_4pt_reduction_last(G1tensor(44),RedSet_4(49),mass4set(:,31),  & 
G0tensor(156),G0tensor(157),G0tensor(158),G0tensor(159),G0tensor(160))
  call Hotf_4pt_reduction_last(G1tensor(50),RedSet_4(17),mass4set(:,14),  & 
G0tensor(161),G0tensor(162),G0tensor(163),G0tensor(164),G0tensor(165))
  call Hotf_4pt_reduction_last(G1tensor(62),RedSet_4(50),mass4set(:,32),  & 
G0tensor(166),G0tensor(167),G0tensor(168),G0tensor(169),G0tensor(170))
  call Hotf_4pt_reduction_last(G1tensor(65),RedSet_4(39),mass4set(:,12),  & 
G0tensor(171),G0tensor(172),G0tensor(173),G0tensor(174),G0tensor(175))
  call Hotf_4pt_reduction_last(G1tensor(74),RedSet_4(50),mass4set(:,33),  & 
G0tensor(176),G0tensor(177),G0tensor(178),G0tensor(179),G0tensor(180))
  call Hotf_4pt_reduction_last(G1tensor(87),RedSet_4(39),mass4set(:,34),  & 
G0tensor(181),G0tensor(182),G0tensor(183),G0tensor(184),G0tensor(185))
  call Hotf_4pt_reduction_last(G1tensor(94),RedSet_4(51),mass4set(:,33),  & 
G0tensor(186),G0tensor(187),G0tensor(188),G0tensor(189),G0tensor(190))
  call Hotf_4pt_reduction_last(G1tensor(106),RedSet_4(42),mass4set(:,34),  & 
G0tensor(191),G0tensor(192),G0tensor(193),G0tensor(194),G0tensor(195))
  call Hotf_4pt_reduction_last(G1tensor(149),RedSet_4(51),mass4set(:,32),  & 
G0tensor(196),G0tensor(197),G0tensor(198),G0tensor(199),G0tensor(200))
  call Hotf_4pt_reduction_last(G1tensor(118),RedSet_4(42),mass4set(:,12),  & 
G0tensor(201),G0tensor(202),G0tensor(203),G0tensor(204),G0tensor(205))
  call Hotf_4pt_reduction_last(G1tensor(130),RedSet_4(1),mass4set(:,35),  & 
G0tensor(206),G0tensor(207),G0tensor(208),G0tensor(209),G0tensor(210))
  call Hotf_4pt_reduction_last(G1tensor(142),RedSet_4(42),mass4set(:,36),  & 
G0tensor(211),G0tensor(212),G0tensor(213),G0tensor(214),G0tensor(215))
  call Hotf_4pt_reduction_last(G1tensor(161),RedSet_4(1),mass4set(:,37),  & 
G0tensor(216),G0tensor(217),G0tensor(218),G0tensor(219),G0tensor(220))
  call Hotf_4pt_reduction_last(G1tensor(172),RedSet_4(42),mass4set(:,38),  & 
G0tensor(221),G0tensor(222),G0tensor(223),G0tensor(224),G0tensor(225))
  call Hotf_4pt_reduction_last(G1tensor(203),RedSet_4(1),mass4set(:,39),  & 
G0tensor(226),G0tensor(227),G0tensor(228),G0tensor(229),G0tensor(230))
  call Hotf_4pt_reduction_last(G1tensor(190),RedSet_4(1),mass4set(:,40),  & 
G0tensor(231),G0tensor(232),G0tensor(233),G0tensor(234),G0tensor(235))
  call Hotf_4pt_reduction_last(G1tensor(232),RedSet_4(1),mass4set(:,41),  & 
G0tensor(236),G0tensor(237),G0tensor(238),G0tensor(239),G0tensor(240))
  call Hotf_4pt_reduction_last(G1tensor(213),RedSet_4(11),mass4set(:,35),  & 
G0tensor(241),G0tensor(242),G0tensor(243),G0tensor(244),G0tensor(245))
  call Hotf_4pt_reduction_last(G1tensor(251),RedSet_4(27),mass4set(:,36),  & 
G0tensor(246),G0tensor(247),G0tensor(248),G0tensor(249),G0tensor(250))
  call Hotf_4pt_reduction_last(G1tensor(227),RedSet_4(11),mass4set(:,37),  & 
G0tensor(251),G0tensor(252),G0tensor(253),G0tensor(254),G0tensor(255))
  call Hotf_4pt_reduction_last(G1tensor(262),RedSet_4(27),mass4set(:,38),  & 
G0tensor(256),G0tensor(257),G0tensor(258),G0tensor(259),G0tensor(260))
  call Hotf_4pt_reduction_last(G1tensor(250),RedSet_4(11),mass4set(:,39),  & 
G0tensor(261),G0tensor(262),G0tensor(263),G0tensor(264),G0tensor(265))
  call Hotf_4pt_reduction_last(G1tensor(266),RedSet_4(27),mass4set(:,12),  & 
G0tensor(266),G0tensor(267),G0tensor(268),G0tensor(269),G0tensor(270))
  call Hotf_4pt_reduction_last(G1tensor(271),RedSet_4(11),mass4set(:,40),  & 
G0tensor(271),G0tensor(272),G0tensor(273),G0tensor(274),G0tensor(275))
  call Hotf_4pt_reduction_last(G1tensor(276),RedSet_4(11),mass4set(:,41),  & 
G0tensor(276),G0tensor(277),G0tensor(278),G0tensor(279),G0tensor(280))
  call Hotf_4pt_reduction_last(G1tensor(281),RedSet_4(52),mass4set(:,42),  & 
G0tensor(281),G0tensor(282),G0tensor(283),G0tensor(284),G0tensor(285))
  call Hotf_4pt_reduction_last(G1tensor(286),RedSet_4(2),mass4set(:,43),  & 
G0tensor(286),G0tensor(287),G0tensor(288),G0tensor(289),G0tensor(290))
  call Hotf_4pt_reduction_last(G1tensor(291),RedSet_4(3),mass4set(:,3),  & 
G0tensor(291),G0tensor(292),G0tensor(293),G0tensor(294),G0tensor(295))
  call Hotf_4pt_reduction_last(G1tensor(296),RedSet_4(52),mass4set(:,44),  & 
G0tensor(296),G0tensor(297),G0tensor(298),G0tensor(299),G0tensor(300))
  call Hotf_4pt_reduction_last(G1tensor(301),RedSet_4(2),mass4set(:,45),  & 
G0tensor(301),G0tensor(302),G0tensor(303),G0tensor(304),G0tensor(305))
  call Hotf_4pt_reduction_last(G1tensor(306),RedSet_4(52),mass4set(:,46),  & 
G0tensor(306),G0tensor(307),G0tensor(308),G0tensor(309),G0tensor(310))
  call Hotf_4pt_reduction_last(G1tensor(311),RedSet_4(2),mass4set(:,1),  & 
G0tensor(311),G0tensor(312),G0tensor(313),G0tensor(314),G0tensor(315))
  call Hotf_4pt_reduction_last(G1tensor(316),RedSet_4(48),mass4set(:,47),  & 
G0tensor(316),G0tensor(317),G0tensor(318),G0tensor(319),G0tensor(320))
  call Hotf_4pt_reduction_last(G1tensor(321),RedSet_4(7),mass4set(:,48),  & 
G0tensor(321),G0tensor(322),G0tensor(323),G0tensor(324),G0tensor(325))
  call Hotf_4pt_reduction_last(G1tensor(326),RedSet_4(8),mass4set(:,2),  & 
G0tensor(326),G0tensor(327),G0tensor(328),G0tensor(329),G0tensor(330))
  call Hotf_4pt_reduction_last(G1tensor(331),RedSet_4(6),mass4set(:,42),  & 
G0tensor(331),G0tensor(332),G0tensor(333),G0tensor(334),G0tensor(335))
  call Hotf_4pt_reduction_last(G1tensor(336),RedSet_4(12),mass4set(:,43),  & 
G0tensor(336),G0tensor(337),G0tensor(338),G0tensor(339),G0tensor(340))
  call Hotf_4pt_reduction_last(G1tensor(341),RedSet_4(13),mass4set(:,3),  & 
G0tensor(341),G0tensor(342),G0tensor(343),G0tensor(344),G0tensor(345))
  call Hotf_4pt_reduction_last(G1tensor(346),RedSet_4(6),mass4set(:,44),  & 
G0tensor(346),G0tensor(347),G0tensor(348),G0tensor(349),G0tensor(350))
  call Hotf_4pt_reduction_last(G1tensor(351),RedSet_4(12),mass4set(:,45),  & 
G0tensor(351),G0tensor(352),G0tensor(353),G0tensor(354),G0tensor(355))
  call Hotf_4pt_reduction_last(G1tensor(356),RedSet_4(6),mass4set(:,46),  & 
G0tensor(356),G0tensor(357),G0tensor(358),G0tensor(359),G0tensor(360))
  call Hotf_4pt_reduction_last(G1tensor(361),RedSet_4(12),mass4set(:,1),  & 
G0tensor(361),G0tensor(362),G0tensor(363),G0tensor(364),G0tensor(365))
  call Hotf_4pt_reduction_last(G1tensor(366),RedSet_4(49),mass4set(:,42),  & 
G0tensor(366),G0tensor(367),G0tensor(368),G0tensor(369),G0tensor(370))
  call Hotf_4pt_reduction_last(G1tensor(371),RedSet_4(15),mass4set(:,35),  & 
G0tensor(371),G0tensor(372),G0tensor(373),G0tensor(374),G0tensor(375))
  call Hotf_4pt_reduction_last(G1tensor(376),RedSet_4(16),mass4set(:,3),  & 
G0tensor(376),G0tensor(377),G0tensor(378),G0tensor(379),G0tensor(380))
  call Hotf_4pt_reduction_last(G1tensor(381),RedSet_4(49),mass4set(:,44),  & 
G0tensor(381),G0tensor(382),G0tensor(383),G0tensor(384),G0tensor(385))
  call Hotf_4pt_reduction_last(G1tensor(386),RedSet_4(15),mass4set(:,37),  & 
G0tensor(386),G0tensor(387),G0tensor(388),G0tensor(389),G0tensor(390))
  call Hotf_4pt_reduction_last(G1tensor(391),RedSet_4(49),mass4set(:,46),  & 
G0tensor(391),G0tensor(392),G0tensor(393),G0tensor(394),G0tensor(395))
  call Hotf_4pt_reduction_last(G1tensor(396),RedSet_4(15),mass4set(:,41),  & 
G0tensor(396),G0tensor(397),G0tensor(398),G0tensor(399),G0tensor(400))
  call Hotf_4pt_reduction_last(G1tensor(401),RedSet_4(33),mass4set(:,42),  & 
G0tensor(401),G0tensor(402),G0tensor(403),G0tensor(404),G0tensor(405))
  call Hotf_4pt_reduction_last(G1tensor(406),RedSet_4(19),mass4set(:,35),  & 
G0tensor(406),G0tensor(407),G0tensor(408),G0tensor(409),G0tensor(410))
  call Hotf_4pt_reduction_last(G1tensor(411),RedSet_4(20),mass4set(:,3),  & 
G0tensor(411),G0tensor(412),G0tensor(413),G0tensor(414),G0tensor(415))
  call Hotf_4pt_reduction_last(G1tensor(416),RedSet_4(33),mass4set(:,44),  & 
G0tensor(416),G0tensor(417),G0tensor(418),G0tensor(419),G0tensor(420))
  call Hotf_4pt_reduction_last(G1tensor(421),RedSet_4(19),mass4set(:,37),  & 
G0tensor(421),G0tensor(422),G0tensor(423),G0tensor(424),G0tensor(425))
  call Hotf_4pt_reduction_last(G1tensor(426),RedSet_4(33),mass4set(:,46),  & 
G0tensor(426),G0tensor(427),G0tensor(428),G0tensor(429),G0tensor(430))
  call Hotf_4pt_reduction_last(G1tensor(431),RedSet_4(19),mass4set(:,41),  & 
G0tensor(431),G0tensor(432),G0tensor(433),G0tensor(434),G0tensor(435))
  call Hotf_4pt_reduction_last(G1tensor(436),RedSet_4(53),mass4set(:,49),  & 
G0tensor(436),G0tensor(437),G0tensor(438),G0tensor(439),G0tensor(440))
  call Hotf_4pt_reduction_last(G1tensor(441),RedSet_4(22),mass4set(:,50),  & 
G0tensor(441),G0tensor(442),G0tensor(443),G0tensor(444),G0tensor(445))
  call Hotf_4pt_reduction_last(G1tensor(446),RedSet_4(54),mass4set(:,49),  & 
G0tensor(446),G0tensor(447),G0tensor(448),G0tensor(449),G0tensor(450))
  call Hotf_4pt_reduction_last(G1tensor(451),RedSet_4(25),mass4set(:,50),  & 
G0tensor(451),G0tensor(452),G0tensor(453),G0tensor(454),G0tensor(455))
  call Hotf_4pt_reduction_last(G1tensor(456),RedSet_4(26),mass4set(:,48),  & 
G0tensor(456),G0tensor(457),G0tensor(458),G0tensor(459),G0tensor(460))
  call Hotf_4pt_reduction_last(G1tensor(461),RedSet_4(11),mass4set(:,51),  & 
G0tensor(461),G0tensor(462),G0tensor(463),G0tensor(464),G0tensor(465))
  call Hotf_4pt_reduction_last(G1tensor(466),RedSet_4(29),mass4set(:,52),  & 
G0tensor(466),G0tensor(467),G0tensor(468),G0tensor(469),G0tensor(470))
  call Hotf_4pt_reduction_last(G1tensor(471),RedSet_4(30),mass4set(:,53),  & 
G0tensor(471),G0tensor(472),G0tensor(473),G0tensor(474),G0tensor(475))
  call Hotf_4pt_reduction_last(G1tensor(476),RedSet_4(31),mass4set(:,4),  & 
G0tensor(476),G0tensor(477),G0tensor(478),G0tensor(479),G0tensor(480))
  call Hotf_4pt_reduction_last(G1tensor(481),RedSet_4(33),mass4set(:,54),  & 
G0tensor(481),G0tensor(482),G0tensor(483),G0tensor(484),G0tensor(485))
  call Hotf_4pt_reduction_last(G1tensor(486),RedSet_4(34),mass4set(:,6),  & 
G0tensor(486),G0tensor(487),G0tensor(488),G0tensor(489),G0tensor(490))
  call Hotf_4pt_reduction_last(G1tensor(491),RedSet_4(8),mass4set(:,55),  & 
G0tensor(491),G0tensor(492),G0tensor(493),G0tensor(494),G0tensor(495))
  call Hotf_4pt_reduction_last(G1tensor(496),RedSet_4(33),mass4set(:,56),  & 
G0tensor(496),G0tensor(497),G0tensor(498),G0tensor(499),G0tensor(500))
  call Hotf_4pt_reduction_last(G1tensor(501),RedSet_4(8),mass4set(:,57),  & 
G0tensor(501),G0tensor(502),G0tensor(503),G0tensor(504),G0tensor(505))
  call Hotf_4pt_reduction_last(G1tensor(506),RedSet_4(34),mass4set(:,58),  & 
G0tensor(506),G0tensor(507),G0tensor(508),G0tensor(509),G0tensor(510))
  call Hotf_4pt_reduction_last(G1tensor(511),RedSet_4(8),mass4set(:,59),  & 
G0tensor(511),G0tensor(512),G0tensor(513),G0tensor(514),G0tensor(515))
  call Hotf_4pt_reduction_last(G1tensor(516),RedSet_4(34),mass4set(:,60),  & 
G0tensor(516),G0tensor(517),G0tensor(518),G0tensor(519),G0tensor(520))
  call Hotf_4pt_reduction_last(G1tensor(521),RedSet_4(8),mass4set(:,61),  & 
G0tensor(521),G0tensor(522),G0tensor(523),G0tensor(524),G0tensor(525))
  call Hotf_4pt_reduction_last(G1tensor(526),RedSet_4(8),mass4set(:,5),  & 
G0tensor(526),G0tensor(527),G0tensor(528),G0tensor(529),G0tensor(530))
  call Hotf_4pt_reduction_last(G1tensor(531),RedSet_4(7),mass4set(:,58),  & 
G0tensor(531),G0tensor(532),G0tensor(533),G0tensor(534),G0tensor(535))
  call Hotf_4pt_reduction_last(G1tensor(536),RedSet_4(7),mass4set(:,60),  & 
G0tensor(536),G0tensor(537),G0tensor(538),G0tensor(539),G0tensor(540))
  call Hotf_4pt_reduction_last(G1tensor(541),RedSet_4(6),mass4set(:,54),  & 
G0tensor(541),G0tensor(542),G0tensor(543),G0tensor(544),G0tensor(545))
  call Hotf_4pt_reduction_last(G1tensor(546),RedSet_4(7),mass4set(:,6),  & 
G0tensor(546),G0tensor(547),G0tensor(548),G0tensor(549),G0tensor(550))
  call Hotf_4pt_reduction_last(G1tensor(551),RedSet_4(6),mass4set(:,56),  & 
G0tensor(551),G0tensor(552),G0tensor(553),G0tensor(554),G0tensor(555))
  call Hotf_4pt_reduction_last(G1tensor(556),RedSet_4(11),mass4set(:,62),  & 
G0tensor(556),G0tensor(557),G0tensor(558),G0tensor(559),G0tensor(560))
  call Hotf_4pt_reduction_last(G1tensor(561),RedSet_4(12),mass4set(:,7),  & 
G0tensor(561),G0tensor(562),G0tensor(563),G0tensor(564),G0tensor(565))
  call Hotf_4pt_reduction_last(G1tensor(566),RedSet_4(13),mass4set(:,63),  & 
G0tensor(566),G0tensor(567),G0tensor(568),G0tensor(569),G0tensor(570))
  call Hotf_4pt_reduction_last(G1tensor(571),RedSet_4(12),mass4set(:,8),  & 
G0tensor(571),G0tensor(572),G0tensor(573),G0tensor(574),G0tensor(575))
  call Hotf_4pt_reduction_last(G1tensor(576),RedSet_4(13),mass4set(:,64),  & 
G0tensor(576),G0tensor(577),G0tensor(578),G0tensor(579),G0tensor(580))
  call Hotf_4pt_reduction_last(G1tensor(581),RedSet_4(15),mass4set(:,62),  & 
G0tensor(581),G0tensor(582),G0tensor(583),G0tensor(584),G0tensor(585))
  call Hotf_4pt_reduction_last(G1tensor(586),RedSet_4(2),mass4set(:,7),  & 
G0tensor(586),G0tensor(587),G0tensor(588),G0tensor(589),G0tensor(590))
  call Hotf_4pt_reduction_last(G1tensor(591),RedSet_4(16),mass4set(:,63),  & 
G0tensor(591),G0tensor(592),G0tensor(593),G0tensor(594),G0tensor(595))
  call Hotf_4pt_reduction_last(G1tensor(596),RedSet_4(15),mass4set(:,51),  & 
G0tensor(596),G0tensor(597),G0tensor(598),G0tensor(599),G0tensor(600))
  call Hotf_4pt_reduction_last(G1tensor(601),RedSet_4(2),mass4set(:,8),  & 
G0tensor(601),G0tensor(602),G0tensor(603),G0tensor(604),G0tensor(605))
  call Hotf_4pt_reduction_last(G1tensor(606),RedSet_4(16),mass4set(:,64),  & 
G0tensor(606),G0tensor(607),G0tensor(608),G0tensor(609),G0tensor(610))
  call Hotf_4pt_reduction_last(G1tensor(611),RedSet_4(37),mass4set(:,65),  & 
G0tensor(611),G0tensor(612),G0tensor(613),G0tensor(614),G0tensor(615))
  call Hotf_4pt_reduction_last(G1tensor(616),RedSet_4(38),mass4set(:,66),  & 
G0tensor(616),G0tensor(617),G0tensor(618),G0tensor(619),G0tensor(620))
  call Hotf_4pt_reduction_last(G1tensor(621),RedSet_4(37),mass4set(:,67),  & 
G0tensor(621),G0tensor(622),G0tensor(623),G0tensor(624),G0tensor(625))
  call Hotf_4pt_reduction_last(G1tensor(626),RedSet_4(38),mass4set(:,6),  & 
G0tensor(626),G0tensor(627),G0tensor(628),G0tensor(629),G0tensor(630))
  call Hotf_4pt_reduction_last(G1tensor(631),RedSet_4(41),mass4set(:,67),  & 
G0tensor(631),G0tensor(632),G0tensor(633),G0tensor(634),G0tensor(635))
  call Hotf_4pt_reduction_last(G1tensor(636),RedSet_4(41),mass4set(:,65),  & 
G0tensor(636),G0tensor(637),G0tensor(638),G0tensor(639),G0tensor(640))
  call Hotf_4pt_reduction_last(G1tensor(641),RedSet_4(34),mass4set(:,66),  & 
G0tensor(641),G0tensor(642),G0tensor(643),G0tensor(644),G0tensor(645))
  call Hotf_4pt_reduction_last(G1tensor(646),RedSet_4(44),mass4set(:,68),  & 
G0tensor(646),G0tensor(647),G0tensor(648),G0tensor(649),G0tensor(650))
  call Hotf_4pt_reduction_last(G1tensor(651),RedSet_4(45),mass4set(:,69),  & 
G0tensor(651),G0tensor(652),G0tensor(653),G0tensor(654),G0tensor(655))
  call Hotf_4pt_reduction_last(G1tensor(656),RedSet_4(31),mass4set(:,70),  & 
G0tensor(656),G0tensor(657),G0tensor(658),G0tensor(659),G0tensor(660))
  call Hotf_4pt_reduction_last(G1tensor(661),RedSet_4(44),mass4set(:,71),  & 
G0tensor(661),G0tensor(662),G0tensor(663),G0tensor(664),G0tensor(665))
  call Hotf_4pt_reduction_last(G1tensor(666),RedSet_4(31),mass4set(:,72),  & 
G0tensor(666),G0tensor(667),G0tensor(668),G0tensor(669),G0tensor(670))
  call Hotf_4pt_reduction_last(G1tensor(671),RedSet_4(44),mass4set(:,73),  & 
G0tensor(671),G0tensor(672),G0tensor(673),G0tensor(674),G0tensor(675))
  call Hotf_4pt_reduction_last(G1tensor(676),RedSet_4(45),mass4set(:,74),  & 
G0tensor(676),G0tensor(677),G0tensor(678),G0tensor(679),G0tensor(680))
  call Hotf_4pt_reduction_last(G1tensor(681),RedSet_4(31),mass4set(:,75),  & 
G0tensor(681),G0tensor(682),G0tensor(683),G0tensor(684),G0tensor(685))
  call Hotf_4pt_reduction_last(G1tensor(686),RedSet_4(44),mass4set(:,76),  & 
G0tensor(686),G0tensor(687),G0tensor(688),G0tensor(689),G0tensor(690))
  call Hotf_4pt_reduction_last(G1tensor(691),RedSet_4(45),mass4set(:,77),  & 
G0tensor(691),G0tensor(692),G0tensor(693),G0tensor(694),G0tensor(695))
  call Hotf_4pt_reduction_last(G1tensor(696),RedSet_4(31),mass4set(:,78),  & 
G0tensor(696),G0tensor(697),G0tensor(698),G0tensor(699),G0tensor(700))
  call Hotf_4pt_reduction_last(G1tensor(701),RedSet_4(44),mass4set(:,79),  & 
G0tensor(701),G0tensor(702),G0tensor(703),G0tensor(704),G0tensor(705))
  call Hotf_4pt_reduction_last(G1tensor(706),RedSet_4(31),mass4set(:,9),  & 
G0tensor(706),G0tensor(707),G0tensor(708),G0tensor(709),G0tensor(710))
  call Hotf_4pt_reduction_last(G1tensor(711),RedSet_4(29),mass4set(:,68),  & 
G0tensor(711),G0tensor(712),G0tensor(713),G0tensor(714),G0tensor(715))
  call Hotf_4pt_reduction_last(G1tensor(716),RedSet_4(30),mass4set(:,69),  & 
G0tensor(716),G0tensor(717),G0tensor(718),G0tensor(719),G0tensor(720))
  call Hotf_4pt_reduction_last(G1tensor(721),RedSet_4(29),mass4set(:,71),  & 
G0tensor(721),G0tensor(722),G0tensor(723),G0tensor(724),G0tensor(725))
  call Hotf_4pt_reduction_last(G1tensor(726),RedSet_4(29),mass4set(:,73),  & 
G0tensor(726),G0tensor(727),G0tensor(728),G0tensor(729),G0tensor(730))
  call Hotf_4pt_reduction_last(G1tensor(731),RedSet_4(30),mass4set(:,74),  & 
G0tensor(731),G0tensor(732),G0tensor(733),G0tensor(734),G0tensor(735))
  call Hotf_4pt_reduction_last(G1tensor(736),RedSet_4(29),mass4set(:,76),  & 
G0tensor(736),G0tensor(737),G0tensor(738),G0tensor(739),G0tensor(740))
  call Hotf_4pt_reduction_last(G1tensor(741),RedSet_4(30),mass4set(:,77),  & 
G0tensor(741),G0tensor(742),G0tensor(743),G0tensor(744),G0tensor(745))
  call Hotf_4pt_reduction_last(G1tensor(746),RedSet_4(29),mass4set(:,79),  & 
G0tensor(746),G0tensor(747),G0tensor(748),G0tensor(749),G0tensor(750))
  call Hotf_4pt_reduction_last(G1tensor(751),RedSet_4(15),mass4set(:,39),  & 
G0tensor(751),G0tensor(752),G0tensor(753),G0tensor(754),G0tensor(755))
  call Hotf_4pt_reduction_last(G1tensor(756),RedSet_4(15),mass4set(:,40),  & 
G0tensor(756),G0tensor(757),G0tensor(758),G0tensor(759),G0tensor(760))
  call Hotf_4pt_reduction_last(G1tensor(761),RedSet_4(19),mass4set(:,39),  & 
G0tensor(761),G0tensor(762),G0tensor(763),G0tensor(764),G0tensor(765))
  call Hotf_4pt_reduction_last(G1tensor(766),RedSet_4(19),mass4set(:,40),  & 
G0tensor(766),G0tensor(767),G0tensor(768),G0tensor(769),G0tensor(770))
  call Hotf_4pt_reduction_last(G1tensor(771),RedSet_4(22),mass4set(:,80),  & 
G0tensor(771),G0tensor(772),G0tensor(773),G0tensor(774),G0tensor(775))
  call Hotf_4pt_reduction_last(G1tensor(776),RedSet_4(54),mass4set(:,81),  & 
G0tensor(776),G0tensor(777),G0tensor(778),G0tensor(779),G0tensor(780))
  call Hotf_4pt_reduction_last(G1tensor(781),RedSet_4(52),mass4set(:,54),  & 
G0tensor(781),G0tensor(782),G0tensor(783),G0tensor(784),G0tensor(785))
  call Hotf_4pt_reduction_last(G1tensor(786),RedSet_4(52),mass4set(:,56),  & 
G0tensor(786),G0tensor(787),G0tensor(788),G0tensor(789),G0tensor(790))
  call Hotf_4pt_reduction_last(G1tensor(791),RedSet_4(49),mass4set(:,54),  & 
G0tensor(791),G0tensor(792),G0tensor(793),G0tensor(794),G0tensor(795))
  call Hotf_4pt_reduction_last(G1tensor(796),RedSet_4(49),mass4set(:,56),  & 
G0tensor(796),G0tensor(797),G0tensor(798),G0tensor(799),G0tensor(800))
  call Hotf_4pt_reduction_last(G1tensor(801),RedSet_4(12),mass4set(:,10),  & 
G0tensor(801),G0tensor(802),G0tensor(803),G0tensor(804),G0tensor(805))
  call Hotf_4pt_reduction_last(G1tensor(806),RedSet_4(12),mass4set(:,11),  & 
G0tensor(806),G0tensor(807),G0tensor(808),G0tensor(809),G0tensor(810))
  call Hotf_4pt_reduction_last(G1tensor(811),RedSet_4(2),mass4set(:,10),  & 
G0tensor(811),G0tensor(812),G0tensor(813),G0tensor(814),G0tensor(815))
  call Hotf_4pt_reduction_last(G1tensor(816),RedSet_4(2),mass4set(:,11),  & 
G0tensor(816),G0tensor(817),G0tensor(818),G0tensor(819),G0tensor(820))
  call Hotf_4pt_reduction_last(G1tensor(821),RedSet_4(23),mass4set(:,12),  & 
G0tensor(821),G0tensor(822),G0tensor(823),G0tensor(824),G0tensor(825))
  call Hotf_4pt_reduction_last(G1tensor(826),RedSet_4(17),mass4set(:,15),  & 
G0tensor(826),G0tensor(827),G0tensor(828),G0tensor(829),G0tensor(830))
  call Hotf_4pt_reduction_last(G1tensor(831),RedSet_4(17),mass4set(:,16),  & 
G0tensor(831),G0tensor(832),G0tensor(833),G0tensor(834),G0tensor(835))
  call Hotf_4pt_reduction_last(G1tensor(836),RedSet_4(4),mass4set(:,15),  & 
G0tensor(836),G0tensor(837),G0tensor(838),G0tensor(839),G0tensor(840))
  call Hotf_4pt_reduction_last(G1tensor(841),RedSet_4(4),mass4set(:,16),  & 
G0tensor(841),G0tensor(842),G0tensor(843),G0tensor(844),G0tensor(845))
  call ol_merge_tensors(T0sum(1),[G0tensor(1)])
  call ol_merge_tensors(T0sum(2),[G0tensor(6)])
  call ol_merge_tensors(T0sum(3),[G0tensor(11)])
  call ol_merge_tensors(T0sum(4),[G0tensor(16)])
  call ol_merge_tensors(T0sum(5),[G0tensor(21)])
  call ol_merge_tensors(T0sum(6),[G0tensor(26)])
  call ol_merge_tensors(T0sum(7),[G0tensor(31)])
  call ol_merge_tensors(T0sum(8),[G0tensor(36)])
  call ol_merge_tensors(T0sum(9),[G0tensor(41)])
  call ol_merge_tensors(T0sum(10),[G0tensor(46)])
  call ol_merge_tensors(T0sum(11),[G0tensor(51)])
  call ol_merge_tensors(T0sum(12),[G0tensor(56)])
  call ol_merge_tensors(T0sum(13),[G0tensor(61)])
  call ol_merge_tensors(T0sum(14),[G0tensor(66)])
  call ol_merge_tensors(T0sum(15),[G0tensor(71)])
  call ol_merge_tensors(T0sum(16),[G0tensor(76)])
  call ol_merge_tensors(T0sum(17),[G0tensor(81)])
  call ol_merge_tensors(T0sum(18),[G0tensor(86)])
  call ol_merge_tensors(T0sum(19),[G0tensor(91)])
  call ol_merge_tensors(T0sum(20),[G0tensor(96)])
  call ol_merge_tensors(T0sum(21),[G0tensor(101)])
  call ol_merge_tensors(T0sum(22),[G0tensor(106)])
  call ol_merge_tensors(T0sum(23),[G0tensor(111)])
  call ol_merge_tensors(T0sum(24),[G0tensor(116)])
  call ol_merge_tensors(T0sum(25),[G0tensor(121)])
  call ol_merge_tensors(T0sum(26),[G0tensor(126)])
  call ol_merge_tensors(T0sum(27),[G0tensor(131)])
  call ol_merge_tensors(T0sum(28),[G0tensor(136)])
  call ol_merge_tensors(T0sum(29),[G0tensor(141)])
  call ol_merge_tensors(T0sum(30),[G0tensor(146)])
  call ol_merge_tensors(T0sum(31),[G0tensor(151)])
  call ol_merge_tensors(T0sum(32),[G0tensor(156)])
  call ol_merge_tensors(T0sum(33),[G0tensor(161)])
  call ol_merge_tensors(T0sum(34),[G0tensor(166)])
  call ol_merge_tensors(T0sum(35),[G0tensor(171)])
  call ol_merge_tensors(T0sum(36),[G0tensor(176)])
  call ol_merge_tensors(T0sum(37),[G0tensor(181)])
  call ol_merge_tensors(T0sum(38),[G0tensor(186)])
  call ol_merge_tensors(T0sum(39),[G0tensor(191)])
  call ol_merge_tensors(T0sum(40),[G0tensor(196)])
  call ol_merge_tensors(T0sum(41),[G0tensor(201)])
  call ol_merge_tensors(T0sum(42),[G0tensor(206)])
  call ol_merge_tensors(T0sum(43),[G0tensor(211)])
  call ol_merge_tensors(T0sum(44),[G0tensor(216)])
  call ol_merge_tensors(T0sum(45),[G0tensor(221)])
  call ol_merge_tensors(T0sum(46),[G0tensor(226)])
  call ol_merge_tensors(T0sum(47),[G0tensor(231)])
  call ol_merge_tensors(T0sum(48),[G0tensor(236)])
  call ol_merge_tensors(T0sum(49),[G0tensor(241)])
  call ol_merge_tensors(T0sum(50),[G0tensor(246)])
  call ol_merge_tensors(T0sum(51),[G0tensor(251)])
  call ol_merge_tensors(T0sum(52),[G0tensor(256)])
  call ol_merge_tensors(T0sum(53),[G0tensor(261)])
  call ol_merge_tensors(T0sum(54),[G0tensor(266)])
  call ol_merge_tensors(T0sum(55),[G0tensor(271)])
  call ol_merge_tensors(T0sum(56),[G0tensor(276)])
  call ol_merge_tensors(T0sum(57),[G0tensor(281)])
  call ol_merge_tensors(T0sum(58),[G0tensor(286)])
  call ol_merge_tensors(T0sum(59),[G0tensor(291)])
  call ol_merge_tensors(T0sum(60),[G0tensor(296)])
  call ol_merge_tensors(T0sum(61),[G0tensor(301)])
  call ol_merge_tensors(T0sum(62),[G0tensor(306)])
  call ol_merge_tensors(T0sum(63),[G0tensor(311)])
  call ol_merge_tensors(T0sum(64),[G0tensor(316)])
  call ol_merge_tensors(T0sum(65),[G0tensor(321)])
  call ol_merge_tensors(T0sum(66),[G0tensor(326)])
  call ol_merge_tensors(T0sum(67),[G0tensor(331)])
  call ol_merge_tensors(T0sum(68),[G0tensor(336)])
  call ol_merge_tensors(T0sum(69),[G0tensor(341)])
  call ol_merge_tensors(T0sum(70),[G0tensor(346)])
  call ol_merge_tensors(T0sum(71),[G0tensor(351)])
  call ol_merge_tensors(T0sum(72),[G0tensor(356)])
  call ol_merge_tensors(T0sum(73),[G0tensor(361)])
  call ol_merge_tensors(T0sum(74),[G0tensor(366)])
  call ol_merge_tensors(T0sum(75),[G0tensor(371)])
  call ol_merge_tensors(T0sum(76),[G0tensor(376)])
  call ol_merge_tensors(T0sum(77),[G0tensor(381)])
  call ol_merge_tensors(T0sum(78),[G0tensor(386)])
  call ol_merge_tensors(T0sum(79),[G0tensor(391)])
  call ol_merge_tensors(T0sum(80),[G0tensor(396)])
  call ol_merge_tensors(T0sum(81),[G0tensor(401)])
  call ol_merge_tensors(T0sum(82),[G0tensor(406)])
  call ol_merge_tensors(T0sum(83),[G0tensor(411)])
  call ol_merge_tensors(T0sum(84),[G0tensor(416)])
  call ol_merge_tensors(T0sum(85),[G0tensor(421)])
  call ol_merge_tensors(T0sum(86),[G0tensor(426)])
  call ol_merge_tensors(T0sum(87),[G0tensor(431)])
  call ol_merge_tensors(T0sum(88),[G0tensor(436)])
  call ol_merge_tensors(T0sum(89),[G0tensor(441)])
  call ol_merge_tensors(T0sum(90),[G0tensor(446)])
  call ol_merge_tensors(T0sum(91),[G0tensor(451)])
  call ol_merge_tensors(T0sum(92),[G0tensor(456)])
  call ol_merge_tensors(T0sum(93),[G0tensor(461)])
  call ol_merge_tensors(T0sum(94),[G0tensor(466)])
  call ol_merge_tensors(T0sum(95),[G0tensor(471)])
  call ol_merge_tensors(T0sum(96),[G0tensor(476)])
  call ol_merge_tensors(T0sum(97),[G0tensor(481)])
  call ol_merge_tensors(T0sum(98),[G0tensor(486)])
  call ol_merge_tensors(T0sum(99),[G0tensor(491)])
  call ol_merge_tensors(T0sum(100),[G0tensor(496)])
  call ol_merge_tensors(T0sum(101),[G0tensor(501)])
  call ol_merge_tensors(T0sum(102),[G0tensor(506)])
  call ol_merge_tensors(T0sum(103),[G0tensor(511)])
  call ol_merge_tensors(T0sum(104),[G0tensor(516)])
  call ol_merge_tensors(T0sum(105),[G0tensor(521)])
  call ol_merge_tensors(T0sum(106),[G0tensor(526)])
  call ol_merge_tensors(T0sum(107),[G0tensor(531)])
  call ol_merge_tensors(T0sum(108),[G0tensor(536)])
  call ol_merge_tensors(T0sum(109),[G0tensor(541)])
  call ol_merge_tensors(T0sum(110),[G0tensor(546)])
  call ol_merge_tensors(T0sum(111),[G0tensor(551)])
  call ol_merge_tensors(T0sum(112),[G0tensor(556)])
  call ol_merge_tensors(T0sum(113),[G0tensor(561)])
  call ol_merge_tensors(T0sum(114),[G0tensor(566)])
  call ol_merge_tensors(T0sum(115),[G0tensor(571)])
  call ol_merge_tensors(T0sum(116),[G0tensor(576)])
  call ol_merge_tensors(T0sum(117),[G0tensor(581)])
  call ol_merge_tensors(T0sum(118),[G0tensor(586)])
  call ol_merge_tensors(T0sum(119),[G0tensor(591)])
  call ol_merge_tensors(T0sum(120),[G0tensor(596)])
  call ol_merge_tensors(T0sum(121),[G0tensor(601)])
  call ol_merge_tensors(T0sum(122),[G0tensor(606)])
  call ol_merge_tensors(T0sum(123),[G0tensor(611)])
  call ol_merge_tensors(T0sum(124),[G0tensor(616)])
  call ol_merge_tensors(T0sum(125),[G0tensor(621)])
  call ol_merge_tensors(T0sum(126),[G0tensor(626)])
  call ol_merge_tensors(T0sum(127),[G0tensor(631)])
  call ol_merge_tensors(T0sum(128),[G0tensor(636)])
  call ol_merge_tensors(T0sum(129),[G0tensor(641)])
  call ol_merge_tensors(T0sum(130),[G0tensor(646)])
  call ol_merge_tensors(T0sum(131),[G0tensor(651)])
  call ol_merge_tensors(T0sum(132),[G0tensor(656)])
  call ol_merge_tensors(T0sum(133),[G0tensor(661)])
  call ol_merge_tensors(T0sum(134),[G0tensor(666)])
  call ol_merge_tensors(T0sum(135),[G0tensor(671)])
  call ol_merge_tensors(T0sum(136),[G0tensor(676)])
  call ol_merge_tensors(T0sum(137),[G0tensor(681)])
  call ol_merge_tensors(T0sum(138),[G0tensor(686)])
  call ol_merge_tensors(T0sum(139),[G0tensor(691)])
  call ol_merge_tensors(T0sum(140),[G0tensor(696)])
  call ol_merge_tensors(T0sum(141),[G0tensor(701)])
  call ol_merge_tensors(T0sum(142),[G0tensor(706)])
  call ol_merge_tensors(T0sum(143),[G0tensor(711)])
  call ol_merge_tensors(T0sum(144),[G0tensor(716)])
  call ol_merge_tensors(T0sum(145),[G0tensor(721)])
  call ol_merge_tensors(T0sum(146),[G0tensor(726)])
  call ol_merge_tensors(T0sum(147),[G0tensor(731)])
  call ol_merge_tensors(T0sum(148),[G0tensor(736)])
  call ol_merge_tensors(T0sum(149),[G0tensor(741)])
  call ol_merge_tensors(T0sum(150),[G0tensor(746)])
  call ol_merge_tensors(T0sum(151),[G0tensor(751)])
  call ol_merge_tensors(T0sum(152),[G0tensor(756)])
  call ol_merge_tensors(T0sum(153),[G0tensor(761)])
  call ol_merge_tensors(T0sum(154),[G0tensor(766)])
  call ol_merge_tensors(T0sum(155),[G0tensor(771)])
  call ol_merge_tensors(T0sum(156),[G0tensor(776)])
  call ol_merge_tensors(T0sum(157),[G0tensor(781)])
  call ol_merge_tensors(T0sum(158),[G0tensor(786)])
  call ol_merge_tensors(T0sum(159),[G0tensor(791)])
  call ol_merge_tensors(T0sum(160),[G0tensor(796)])
  call ol_merge_tensors(T0sum(161),[G0tensor(801)])
  call ol_merge_tensors(T0sum(162),[G0tensor(806)])
  call ol_merge_tensors(T0sum(163),[G0tensor(811)])
  call ol_merge_tensors(T0sum(164),[G0tensor(816)])
  call ol_merge_tensors(T0sum(165),[G0tensor(821)])
  call ol_merge_tensors(T0sum(166),[G0tensor(826)])
  call ol_merge_tensors(T0sum(167),[G0tensor(831)])
  call ol_merge_tensors(T0sum(168),[G0tensor(836)])
  call ol_merge_tensors(T0sum(169),[G0tensor(841)])
  Gcoeff(:)%j = (c(35)*M(6,:)%j+c(30)*(M(2,:)%j-M(8,:)%j)) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(257),h0tab(:,257),[19,4,8],[0,nMB,0],4,1,wf4(:,1))
  call Hloop_GGG_G_12(ntryL,G0H32(1),ex5(:),wf4(:,1),G0H4(1),m4h2x4x4(:,1),heltab3x32(:,:,1))
  Gcoeff(:)%j = (c(35)*M(4,:)%j+c(30)*(M(2,:)%j-M(8,:)%j)) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(258),h0tab(:,258),[19,4,8],[0,nMB,0],4,1,wf4(:,1))
  call Hloop_GGG_G_12(ntryL,G0H32(1),wf4(:,1),ex5(:),G0H4(2),m4h4x2x4(:,1),heltab3x32(:,:,2))
  Gcoeff(:)%j = (c(35)*(M(4,:)%j-M(6,:)%j)) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(259),h0tab(:,259),[19,4,8],[0,nMB,0],4,1,wf4(:,1))
  call Hloop_GGG_G_23(ntryL,G0H32(1),ex5(:),wf4(:,1),G0H4(3),m4h2x4x4(:,2),heltab3x32(:,:,3))
  Gcoeff(:)%j = (c(35)*M(4,:)%j+c(30)*(-M(2,:)%j+M(8,:)%j)) * den(2)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(260),h0tab(:,260),[28,1,2],[0,nMT,0],4,1,wf4(:,2))
  call Hloop_GGG_G_12(ntryL,G0H32(1),ex5(:),wf4(:,2),G0H4(4),m4h2x4x4(:,3),heltab3x32(:,:,4))
  Gcoeff(:)%j = (c(35)*M(6,:)%j+c(30)*(-M(2,:)%j+M(8,:)%j)) * den(2)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(261),h0tab(:,261),[28,1,2],[0,nMT,0],4,1,wf4(:,2))
  call Hloop_GGG_G_12(ntryL,G0H32(1),wf4(:,2),ex5(:),G0H4(5),m4h4x2x4(:,2),heltab3x32(:,:,5))
  Gcoeff(:)%j = (c(35)*(-M(4,:)%j+M(6,:)%j)) * den(2)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(262),h0tab(:,262),[28,1,2],[0,nMT,0],4,1,wf4(:,2))
  call Hloop_GGG_G_23(ntryL,G0H32(1),ex5(:),wf4(:,2),G0H4(6),m4h2x4x4(:,4),heltab3x32(:,:,6))
  Gcoeff(:)%j = (c(72)*M(7,:)%j) * den(30)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(263),h0tab(:,263),[16,3,12],[nMT,nMT,nMT],3,2,wf4(:,3),wf4(:,2))
  call Hloop_AV_Q(ntryL,G0H32(1),ex5(:),G0H16(1),m3h2x16(:,153),heltab2x32(:,:,257))
  call Hloop_A_Q(ntryL,G0H16(1),16,nMT,G1H16(71),n2h16(107))
  Gcoeff(:)%j = (c(72)*M(7,:)%j) * den(30)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(264),h0tab(:,264),[16,3,12],[nMT,nMT,nMT],3,2,wf4(:,3),wf4(:,2))
  call Hloop_QV_A(ntryL,G0H32(1),ex5(:),G0H16(1),m3h2x16(:,154),heltab2x32(:,:,258))
  call Hloop_Q_A(ntryL,G0H16(1),16,nMT,G1H16(72),n2h16(108))
  Gcoeff(:)%j = (c(71)*M(7,:)%j) * den(30)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(265),h0tab(:,265),[16,3,12],[nMB,nMB,nMB],3,2,wf4(:,3),wf4(:,2))
  call Hloop_AV_Q(ntryL,G0H32(1),ex5(:),G0H16(1),m3h2x16(:,155),heltab2x32(:,:,259))
  call Hloop_A_Q(ntryL,G0H16(1),16,nMB,G1H16(73),n2h16(109))
  Gcoeff(:)%j = (c(71)*M(7,:)%j) * den(30)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(266),h0tab(:,266),[16,3,12],[nMB,nMB,nMB],3,2,wf4(:,3),wf4(:,2))
  call Hloop_QV_A(ntryL,G0H32(1),ex5(:),G0H16(1),m3h2x16(:,156),heltab2x32(:,:,260))
  call Hloop_Q_A(ntryL,G0H16(1),16,nMB,G1H16(78),n2h16(110))
  Gcoeff(:)%j = (-(c(72)*M(7,:)%j)) * den(32)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(267),h0tab(:,267),[16,3,12],[nMT,nMT,nMT],3,2,wf4(:,6),wf4(:,2))
  call Hloop_AV_Q(ntryL,G0H32(1),ex5(:),G0H16(1),m3h2x16(:,157),heltab2x32(:,:,261))
  call Hloop_A_Q(ntryL,G0H16(1),16,nMT,G1H16(76),n2h16(111))
  Gcoeff(:)%j = (-(c(72)*M(7,:)%j)) * den(32)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(268),h0tab(:,268),[16,3,12],[nMT,nMT,nMT],3,2,wf4(:,6),wf4(:,2))
  call Hloop_QV_A(ntryL,G0H32(1),ex5(:),G0H16(1),m3h2x16(:,158),heltab2x32(:,:,262))
  call Hloop_Q_A(ntryL,G0H16(1),16,nMT,G1H16(77),n2h16(112))
  Gcoeff(:)%j = (c(71)*M(7,:)%j) * den(32)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(269),h0tab(:,269),[16,3,12],[nMB,nMB,nMB],3,2,wf4(:,6),wf4(:,2))
  call Hloop_AV_Q(ntryL,G0H32(1),ex5(:),G0H16(1),m3h2x16(:,159),heltab2x32(:,:,263))
  call Hloop_A_Q(ntryL,G0H16(1),16,nMB,G1H16(79),n2h16(113))
  Gcoeff(:)%j = (c(71)*M(7,:)%j) * den(32)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(270),h0tab(:,270),[16,3,12],[nMB,nMB,nMB],3,2,wf4(:,6),wf4(:,2))
  call Hloop_QV_A(ntryL,G0H32(1),ex5(:),G0H16(1),m3h2x16(:,160),heltab2x32(:,:,264))
  call Hloop_Q_A(ntryL,G0H16(1),16,nMB,G1H16(80),n2h16(114))
  Gcoeff(:)%j = (c(71)*M(1,:)%j) * den(31)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(271),h0tab(:,271),[16,3,12],[nMT,nMT,nMT],3,2,wf4(:,1),wf4(:,18))
  call Hloop_AV_Q(ntryL,G0H32(1),ex5(:),G0H16(1),m3h2x16(:,161),heltab2x32(:,:,265))
  call Hloop_A_Q(ntryL,G0H16(1),16,nMT,G1H16(46),n2h16(115))
  Gcoeff(:)%j = (c(71)*M(1,:)%j) * den(31)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(272),h0tab(:,272),[16,3,12],[nMT,nMT,nMT],3,2,wf4(:,1),wf4(:,18))
  call Hloop_QV_A(ntryL,G0H32(1),ex5(:),G0H16(1),m3h2x16(:,162),heltab2x32(:,:,266))
  call Hloop_Q_A(ntryL,G0H16(1),16,nMT,G1H16(32),n2h16(116))
  Gcoeff(:)%j = (c(70)*M(1,:)%j) * den(31)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(273),h0tab(:,273),[16,3,12],[nMB,nMB,nMB],3,2,wf4(:,1),wf4(:,18))
  call Hloop_AV_Q(ntryL,G0H32(1),ex5(:),G0H16(1),m3h2x16(:,163),heltab2x32(:,:,267))
  call Hloop_A_Q(ntryL,G0H16(1),16,nMB,G1H16(10),n2h16(117))
  Gcoeff(:)%j = (c(70)*M(1,:)%j) * den(31)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(274),h0tab(:,274),[16,3,12],[nMB,nMB,nMB],3,2,wf4(:,1),wf4(:,18))
  call Hloop_QV_A(ntryL,G0H32(1),ex5(:),G0H16(1),m3h2x16(:,164),heltab2x32(:,:,268))
  call Hloop_Q_A(ntryL,G0H16(1),16,nMB,G1H16(7),n2h16(118))
  Gcoeff(:)%j = (c(71)*M(1,:)%j) * den(33)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(275),h0tab(:,275),[16,3,12],[nMT,nMT,nMT],3,2,wf4(:,1),wf4(:,19))
  call Hloop_AV_Q(ntryL,G0H32(1),ex5(:),G0H16(1),m3h2x16(:,165),heltab2x32(:,:,269))
  call Hloop_A_Q(ntryL,G0H16(1),16,nMT,G1H16(23),n2h16(119))
  Gcoeff(:)%j = (c(71)*M(1,:)%j) * den(33)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(276),h0tab(:,276),[16,3,12],[nMT,nMT,nMT],3,2,wf4(:,1),wf4(:,19))
  call Hloop_QV_A(ntryL,G0H32(1),ex5(:),G0H16(1),m3h2x16(:,166),heltab2x32(:,:,270))
  call Hloop_Q_A(ntryL,G0H16(1),16,nMT,G1H16(45),n2h16(120))
  Gcoeff(:)%j = (-(c(70)*M(1,:)%j)) * den(33)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(277),h0tab(:,277),[16,3,12],[nMB,nMB,nMB],3,2,wf4(:,1),wf4(:,19))
  call Hloop_AV_Q(ntryL,G0H32(1),ex5(:),G0H16(1),m3h2x16(:,167),heltab2x32(:,:,271))
  call Hloop_A_Q(ntryL,G0H16(1),16,nMB,G1H16(42),n2h16(121))
  Gcoeff(:)%j = (-(c(70)*M(1,:)%j)) * den(33)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(278),h0tab(:,278),[16,3,12],[nMB,nMB,nMB],3,2,wf4(:,1),wf4(:,19))
  call Hloop_QV_A(ntryL,G0H32(1),ex5(:),G0H16(1),m3h2x16(:,168),heltab2x32(:,:,272))
  call Hloop_Q_A(ntryL,G0H16(1),16,nMB,G1H16(58),n2h16(122))
  Gcoeff(:)%j = (-(c(61)*M(7,:)%j)) * den(3)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(279),h0tab(:,279),[16,3,12],[0,0,0],3,2,wf4(:,1),wf4(:,2))
  call Hloop_AV_Q(ntryL,G0H32(1),ex5(:),G0H16(1),m3h2x16(:,169),heltab2x32(:,:,273))
  call Hloop_A_Q(ntryL,G0H16(1),16,0,G1H16(56),n2h16(123))
  Gcoeff(:)%j = (-(c(60)*M(7,:)%j)) * den(3)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(280),h0tab(:,280),[16,3,12],[nMT,nMT,nMT],3,2,wf4(:,1),wf4(:,2))
  call Hloop_AV_Q(ntryL,G0H32(1),ex5(:),G0H16(1),m3h2x16(:,170),heltab2x32(:,:,274))
  call Hloop_A_Q(ntryL,G0H16(1),16,nMT,G1H16(68),n2h16(124))
  Gcoeff(:)%j = (-(c(61)*M(7,:)%j)) * den(3)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(281),h0tab(:,281),[16,3,12],[0,0,0],3,2,wf4(:,1),wf4(:,2))
  call Hloop_QV_A(ntryL,G0H32(1),ex5(:),G0H16(1),m3h2x16(:,171),heltab2x32(:,:,275))
  call Hloop_Q_A(ntryL,G0H16(1),16,0,G1H16(6),n2h16(125))
  Gcoeff(:)%j = (-(c(60)*M(7,:)%j)) * den(3)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(282),h0tab(:,282),[16,3,12],[nMT,nMT,nMT],3,2,wf4(:,1),wf4(:,2))
  call Hloop_QV_A(ntryL,G0H32(1),ex5(:),G0H16(1),m3h2x16(:,172),heltab2x32(:,:,276))
  call Hloop_Q_A(ntryL,G0H16(1),16,nMT,G1H16(5),n2h16(126))
  Gcoeff(:)%j = (c(60)*M(7,:)%j) * den(3)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(283),h0tab(:,283),[16,3,12],[0,0,0],3,2,wf4(:,1),wf4(:,2))
  call Hloop_AV_Q(ntryL,G0H32(1),ex5(:),G0H16(1),m3h2x16(:,173),heltab2x32(:,:,277))
  call Hloop_A_Q(ntryL,G0H16(1),16,0,G1H16(12),n2h16(127))
  Gcoeff(:)%j = (c(59)*M(7,:)%j) * den(3)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(284),h0tab(:,284),[16,3,12],[nMB,nMB,nMB],3,2,wf4(:,1),wf4(:,2))
  call Hloop_AV_Q(ntryL,G0H32(1),ex5(:),G0H16(1),m3h2x16(:,174),heltab2x32(:,:,278))
  call Hloop_A_Q(ntryL,G0H16(1),16,nMB,G1H16(20),n2h16(128))
  Gcoeff(:)%j = (c(60)*M(7,:)%j) * den(3)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(285),h0tab(:,285),[16,3,12],[0,0,0],3,2,wf4(:,1),wf4(:,2))
  call Hloop_QV_A(ntryL,G0H32(1),ex5(:),G0H16(1),m3h2x16(:,175),heltab2x32(:,:,279))
  call Hloop_Q_A(ntryL,G0H16(1),16,0,G1H16(19),n2h16(129))
  Gcoeff(:)%j = (c(59)*M(7,:)%j) * den(3)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(286),h0tab(:,286),[16,3,12],[nMB,nMB,nMB],3,2,wf4(:,1),wf4(:,2))
  call Hloop_QV_A(ntryL,G0H32(1),ex5(:),G0H16(1),m3h2x16(:,176),heltab2x32(:,:,280))
  call Hloop_Q_A(ntryL,G0H16(1),16,nMB,G1H16(75),n2h16(130))
  Gcoeff(:)%j = (-(c(63)*M(7,:)%j)) * den(32)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(287),h0tab(:,287),[16,3,12],[0,0,0],3,2,wf4(:,7),wf4(:,2))
  call Hloop_AV_Q(ntryL,G0H32(1),ex5(:),G0H16(1),m3h2x16(:,177),heltab2x32(:,:,281))
  call Hloop_A_Q(ntryL,G0H16(1),16,0,G1H16(41),n2h16(131))
  Gcoeff(:)%j = (-(c(62)*M(7,:)%j)) * den(32)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(288),h0tab(:,288),[16,3,12],[nMT,nMT,nMT],3,2,wf4(:,7),wf4(:,2))
  call Hloop_AV_Q(ntryL,G0H32(1),ex5(:),G0H16(1),m3h2x16(:,178),heltab2x32(:,:,282))
  call Hloop_A_Q(ntryL,G0H16(1),16,nMT,G1H16(64),n2h16(132))
  Gcoeff(:)%j = (-(c(63)*M(7,:)%j)) * den(32)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(289),h0tab(:,289),[16,3,12],[0,0,0],3,2,wf4(:,7),wf4(:,2))
  call Hloop_QV_A(ntryL,G0H32(1),ex5(:),G0H16(1),m3h2x16(:,179),heltab2x32(:,:,283))
  call Hloop_Q_A(ntryL,G0H16(1),16,0,G1H16(63),n2h16(133))
  Gcoeff(:)%j = (-(c(62)*M(7,:)%j)) * den(32)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(290),h0tab(:,290),[16,3,12],[nMT,nMT,nMT],3,2,wf4(:,7),wf4(:,2))
  call Hloop_QV_A(ntryL,G0H32(1),ex5(:),G0H16(1),m3h2x16(:,180),heltab2x32(:,:,284))
  call Hloop_Q_A(ntryL,G0H16(1),16,nMT,G1H16(74),n2h16(134))
  Gcoeff(:)%j = (-(c(63)*M(7,:)%j)) * den(32)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(291),h0tab(:,291),[16,3,12],[0,0,0],3,2,wf4(:,7),wf4(:,2))
  call Hloop_AV_Q(ntryL,G0H32(1),ex5(:),G0H16(1),m3h2x16(:,181),heltab2x32(:,:,285))
  call Hloop_A_Q(ntryL,G0H16(1),16,0,G1H16(1),n2h16(135))
  Gcoeff(:)%j = (-(c(62)*M(7,:)%j)) * den(32)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(292),h0tab(:,292),[16,3,12],[nMB,nMB,nMB],3,2,wf4(:,7),wf4(:,2))
  call Hloop_AV_Q(ntryL,G0H32(1),ex5(:),G0H16(1),m3h2x16(:,182),heltab2x32(:,:,286))
  call Hloop_A_Q(ntryL,G0H16(1),16,nMB,G1H16(2),n2h16(136))
  Gcoeff(:)%j = (-(c(63)*M(7,:)%j)) * den(32)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(293),h0tab(:,293),[16,3,12],[0,0,0],3,2,wf4(:,7),wf4(:,2))
  call Hloop_QV_A(ntryL,G0H32(1),ex5(:),G0H16(1),m3h2x16(:,183),heltab2x32(:,:,287))
  call Hloop_Q_A(ntryL,G0H16(1),16,0,G1H16(3),n2h16(137))
  Gcoeff(:)%j = (-(c(62)*M(7,:)%j)) * den(32)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(294),h0tab(:,294),[16,3,12],[nMB,nMB,nMB],3,2,wf4(:,7),wf4(:,2))
  call Hloop_QV_A(ntryL,G0H32(1),ex5(:),G0H16(1),m3h2x16(:,184),heltab2x32(:,:,288))
  call Hloop_Q_A(ntryL,G0H16(1),16,nMB,G1H16(4),n2h16(138))
  Gcoeff(:)%j = (c(60)*M(1,:)%j) * den(3)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(295),h0tab(:,295),[16,3,12],[0,0,0],3,2,wf4(:,1),wf4(:,2))
  call Hloop_AV_Q(ntryL,G0H32(1),ex5(:),G0H16(1),m3h2x16(:,185),heltab2x32(:,:,289))
  call Hloop_A_Q(ntryL,G0H16(1),16,0,G1H16(9),n2h16(139))
  Gcoeff(:)%j = (c(59)*M(1,:)%j) * den(3)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(296),h0tab(:,296),[16,3,12],[nMT,nMT,nMT],3,2,wf4(:,1),wf4(:,2))
  call Hloop_AV_Q(ntryL,G0H32(1),ex5(:),G0H16(1),m3h2x16(:,186),heltab2x32(:,:,290))
  call Hloop_A_Q(ntryL,G0H16(1),16,nMT,G1H16(13),n2h16(140))
  Gcoeff(:)%j = (c(60)*M(1,:)%j) * den(3)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(297),h0tab(:,297),[16,3,12],[0,0,0],3,2,wf4(:,1),wf4(:,2))
  call Hloop_QV_A(ntryL,G0H32(1),ex5(:),G0H16(1),m3h2x16(:,187),heltab2x32(:,:,291))
  call Hloop_Q_A(ntryL,G0H16(1),16,0,G1H16(8),n2h16(141))
  Gcoeff(:)%j = (c(59)*M(1,:)%j) * den(3)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(298),h0tab(:,298),[16,3,12],[nMT,nMT,nMT],3,2,wf4(:,1),wf4(:,2))
  call Hloop_QV_A(ntryL,G0H32(1),ex5(:),G0H16(1),m3h2x16(:,188),heltab2x32(:,:,292))
  call Hloop_Q_A(ntryL,G0H16(1),16,nMT,G1H16(11),n2h16(142))
  Gcoeff(:)%j = (-(c(59)*M(1,:)%j)) * den(3)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(299),h0tab(:,299),[16,3,12],[0,0,0],3,2,wf4(:,1),wf4(:,2))
  call Hloop_AV_Q(ntryL,G0H32(1),ex5(:),G0H16(1),m3h2x16(:,189),heltab2x32(:,:,293))
  call Hloop_A_Q(ntryL,G0H16(1),16,0,G1H16(14),n2h16(143))
  Gcoeff(:)%j = (-(c(58)*M(1,:)%j)) * den(3)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(300),h0tab(:,300),[16,3,12],[nMB,nMB,nMB],3,2,wf4(:,1),wf4(:,2))
  call Hloop_AV_Q(ntryL,G0H32(1),ex5(:),G0H16(1),m3h2x16(:,190),heltab2x32(:,:,294))
  call Hloop_A_Q(ntryL,G0H16(1),16,nMB,G1H16(15),n2h16(144))
  Gcoeff(:)%j = (-(c(59)*M(1,:)%j)) * den(3)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(301),h0tab(:,301),[16,3,12],[0,0,0],3,2,wf4(:,1),wf4(:,2))
  call Hloop_QV_A(ntryL,G0H32(1),ex5(:),G0H16(1),m3h2x16(:,191),heltab2x32(:,:,295))
  call Hloop_Q_A(ntryL,G0H16(1),16,0,G1H16(16),n2h16(145))
  Gcoeff(:)%j = (-(c(58)*M(1,:)%j)) * den(3)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(302),h0tab(:,302),[16,3,12],[nMB,nMB,nMB],3,2,wf4(:,1),wf4(:,2))
  call Hloop_QV_A(ntryL,G0H32(1),ex5(:),G0H16(1),m3h2x16(:,192),heltab2x32(:,:,296))
  call Hloop_Q_A(ntryL,G0H16(1),16,nMB,G1H16(17),n2h16(146))
  Gcoeff(:)%j = (-(c(63)*M(1,:)%j)) * den(33)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(303),h0tab(:,303),[16,3,12],[0,0,0],3,2,wf4(:,1),wf4(:,20))
  call Hloop_AV_Q(ntryL,G0H32(1),ex5(:),G0H16(1),m3h2x16(:,193),heltab2x32(:,:,297))
  call Hloop_A_Q(ntryL,G0H16(1),16,0,G1H16(18),n2h16(147))
  Gcoeff(:)%j = (-(c(62)*M(1,:)%j)) * den(33)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(304),h0tab(:,304),[16,3,12],[nMT,nMT,nMT],3,2,wf4(:,1),wf4(:,20))
  call Hloop_AV_Q(ntryL,G0H32(1),ex5(:),G0H16(1),m3h2x16(:,194),heltab2x32(:,:,298))
  call Hloop_A_Q(ntryL,G0H16(1),16,nMT,G1H16(22),n2h16(148))
  Gcoeff(:)%j = (-(c(63)*M(1,:)%j)) * den(33)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(305),h0tab(:,305),[16,3,12],[0,0,0],3,2,wf4(:,1),wf4(:,20))
  call Hloop_QV_A(ntryL,G0H32(1),ex5(:),G0H16(1),m3h2x16(:,195),heltab2x32(:,:,299))
  call Hloop_Q_A(ntryL,G0H16(1),16,0,G1H16(21),n2h16(149))
  Gcoeff(:)%j = (-(c(62)*M(1,:)%j)) * den(33)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(306),h0tab(:,306),[16,3,12],[nMT,nMT,nMT],3,2,wf4(:,1),wf4(:,20))
  call Hloop_QV_A(ntryL,G0H32(1),ex5(:),G0H16(1),m3h2x16(:,196),heltab2x32(:,:,300))
  call Hloop_Q_A(ntryL,G0H16(1),16,nMT,G1H16(24),n2h16(150))
  Gcoeff(:)%j = (-(c(63)*M(1,:)%j)) * den(33)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(307),h0tab(:,307),[16,3,12],[0,0,0],3,2,wf4(:,1),wf4(:,20))
  call Hloop_AV_Q(ntryL,G0H32(1),ex5(:),G0H16(1),m3h2x16(:,197),heltab2x32(:,:,301))
  call Hloop_A_Q(ntryL,G0H16(1),16,0,G1H16(25),n2h16(151))
  Gcoeff(:)%j = (-(c(62)*M(1,:)%j)) * den(33)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(308),h0tab(:,308),[16,3,12],[nMB,nMB,nMB],3,2,wf4(:,1),wf4(:,20))
  call Hloop_AV_Q(ntryL,G0H32(1),ex5(:),G0H16(1),m3h2x16(:,198),heltab2x32(:,:,302))
  call Hloop_A_Q(ntryL,G0H16(1),16,nMB,G1H16(26),n2h16(152))
  Gcoeff(:)%j = (-(c(63)*M(1,:)%j)) * den(33)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(309),h0tab(:,309),[16,3,12],[0,0,0],3,2,wf4(:,1),wf4(:,20))
  call Hloop_QV_A(ntryL,G0H32(1),ex5(:),G0H16(1),m3h2x16(:,199),heltab2x32(:,:,303))
  call Hloop_Q_A(ntryL,G0H16(1),16,0,G1H16(27),n2h16(153))
  Gcoeff(:)%j = (-(c(62)*M(1,:)%j)) * den(33)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(310),h0tab(:,310),[16,3,12],[nMB,nMB,nMB],3,2,wf4(:,1),wf4(:,20))
  call Hloop_QV_A(ntryL,G0H32(1),ex5(:),G0H16(1),m3h2x16(:,200),heltab2x32(:,:,304))
  call Hloop_Q_A(ntryL,G0H16(1),16,nMB,G1H16(28),n2h16(154))
  Gcoeff(:)%j = (-(c(69)*M(6,:)%j)+c(68)*(M(2,:)%j+M(8,:)%j)) * den(3)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(311),h0tab(:,311),[16,3,12],[0,0,0],3,2,wf4(:,1),wf4(:,2))
  call Hloop_AV_Q(ntryL,G0H32(1),ex5(:),G0H16(1),m3h2x16(:,201),heltab2x32(:,:,305))
  call Hloop_A_Q(ntryL,G0H16(1),16,0,G1H16(29),n2h16(155))
  Gcoeff(:)%j = (-(c(67)*M(6,:)%j)+c(66)*(M(2,:)%j+M(8,:)%j)) * den(3)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(312),h0tab(:,312),[16,3,12],[nMT,nMT,nMT],3,2,wf4(:,1),wf4(:,2))
  call Hloop_AV_Q(ntryL,G0H32(1),ex5(:),G0H16(1),m3h2x16(:,202),heltab2x32(:,:,306))
  call Hloop_A_Q(ntryL,G0H16(1),16,nMT,G1H16(30),n2h16(156))
  Gcoeff(:)%j = (-(c(69)*M(4,:)%j)+c(68)*(M(2,:)%j+M(8,:)%j)) * den(3)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(313),h0tab(:,313),[16,3,12],[0,0,0],3,2,wf4(:,1),wf4(:,2))
  call Hloop_QV_A(ntryL,G0H32(1),ex5(:),G0H16(1),m3h2x16(:,203),heltab2x32(:,:,307))
  call Hloop_Q_A(ntryL,G0H16(1),16,0,G1H16(31),n2h16(157))
  Gcoeff(:)%j = (-(c(67)*M(4,:)%j)+c(66)*(M(2,:)%j+M(8,:)%j)) * den(3)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(314),h0tab(:,314),[16,3,12],[nMT,nMT,nMT],3,2,wf4(:,1),wf4(:,2))
  call Hloop_QV_A(ntryL,G0H32(1),ex5(:),G0H16(1),m3h2x16(:,204),heltab2x32(:,:,308))
  call Hloop_Q_A(ntryL,G0H16(1),16,nMT,G1H16(34),n2h16(158))
  Gcoeff(:)%j = (-(c(69)*M(6,:)%j)+c(68)*(M(2,:)%j+M(8,:)%j)) * den(3)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(315),h0tab(:,315),[16,3,12],[0,0,0],3,2,wf4(:,1),wf4(:,2))
  call Hloop_AV_Q(ntryL,G0H32(1),ex5(:),G0H16(1),m3h2x16(:,205),heltab2x32(:,:,309))
  call Hloop_A_Q(ntryL,G0H16(1),16,0,G1H16(33),n2h16(159))
  Gcoeff(:)%j = (-(c(67)*M(6,:)%j)+c(66)*(M(2,:)%j+M(8,:)%j)) * den(3)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(316),h0tab(:,316),[16,3,12],[nMB,nMB,nMB],3,2,wf4(:,1),wf4(:,2))
  call Hloop_AV_Q(ntryL,G0H32(1),ex5(:),G0H16(1),m3h2x16(:,206),heltab2x32(:,:,310))
  call Hloop_A_Q(ntryL,G0H16(1),16,nMB,G1H16(35),n2h16(160))
  Gcoeff(:)%j = (-(c(69)*M(4,:)%j)+c(68)*(M(2,:)%j+M(8,:)%j)) * den(3)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(317),h0tab(:,317),[16,3,12],[0,0,0],3,2,wf4(:,1),wf4(:,2))
  call Hloop_QV_A(ntryL,G0H32(1),ex5(:),G0H16(1),m3h2x16(:,207),heltab2x32(:,:,311))
  call Hloop_Q_A(ntryL,G0H16(1),16,0,G1H16(36),n2h16(161))
  Gcoeff(:)%j = (-(c(67)*M(4,:)%j)+c(66)*(M(2,:)%j+M(8,:)%j)) * den(3)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(318),h0tab(:,318),[16,3,12],[nMB,nMB,nMB],3,2,wf4(:,1),wf4(:,2))
  call Hloop_QV_A(ntryL,G0H32(1),ex5(:),G0H16(1),m3h2x16(:,208),heltab2x32(:,:,312))
  call Hloop_Q_A(ntryL,G0H16(1),16,nMB,G1H16(37),n2h16(162))
  Gcoeff(:)%j = (c(22)*(-M(4,:)%j+M(6,:)%j)) * den(3)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(319),h0tab(:,319),[16,3,12],[0,0,0],3,2,wf4(:,1),wf4(:,2))
  call Hloop_DV_C(ntryL,G0H32(1),0,ex5(:),G1H16(38),m3h2x16(:,209),heltab2x32(:,:,313))
  Gcoeff(:)%j = (c(22)*(M(4,:)%j-M(6,:)%j)) * den(3)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(320),h0tab(:,320),[16,3,12],[0,0,0],3,2,wf4(:,1),wf4(:,2))
  call Hloop_CV_D(ntryL,G0H32(1),0,ex5(:),16,G1H16(39),m3h2x16(:,210),heltab2x32(:,:,314))
  Gcoeff(:)%j = (c(22)*(M(4,:)%j-M(6,:)%j)) * den(3)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(321),h0tab(:,321),[16,3,12],[0,0,0],3,2,wf4(:,1),wf4(:,2))
  call Hloop_UV_W(ntryL,G0H32(1),0,ex5(:),16,G1H16(40),m3h2x16(:,211),heltab2x32(:,:,315))
  Gcoeff(:)%j = (-(c(54)*M(7,:)%j)) * den(6)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(322),h0tab(:,322),[20,3,8],[nMB,nMB,0],3,2,wf4(:,5),wf4(:,3))
  call Hloop_VQ_A(ntryL,G0H32(1),wf4(:,5),G0H8(53),m3h4x8(:,105),heltab2x32(:,:,316))
  call Hloop_Q_A(ntryL,G0H8(53),20,nMB,G1H8(60),n2h8(103))
  Gcoeff(:)%j = (-(c(54)*M(7,:)%j)) * den(8)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(323),h0tab(:,323),[20,3,8],[nMB,nMB,0],3,2,wf4(:,5),wf4(:,6))
  call Hloop_VQ_A(ntryL,G0H32(1),wf4(:,5),G0H8(18),m3h4x8(:,106),heltab2x32(:,:,317))
  call Hloop_Q_A(ntryL,G0H8(18),20,nMB,G1H8(61),n2h8(104))
  Gcoeff(:)%j = (-(c(49)*M(3,:)%j)+c(48)*M(7,:)%j) * den(9)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(324),h0tab(:,324),[20,3,8],[nMB,nMB,nMH],3,2,wf4(:,5),wf4(:,1))
  call Hloop_SQ_A(ntryL,G0H32(1),wf4(:,5),G0H8(17),ngH,m3h4x8(:,107),heltab2x32(:,:,318))
  call Hloop_Q_A(ntryL,G0H8(17),20,nMB,G1H8(62),n2h8(105))
  Gcoeff(:)%j = (c(49)*M(3,:)%j-c(48)*M(7,:)%j) * den(9)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(325),h0tab(:,325),[20,3,8],[nMB,nMB,nMZ],3,2,wf4(:,5),wf4(:,1))
  call Hloop_SQ_A(ntryL,G0H32(1),wf4(:,5),G0H8(27),ngX,m3h4x8(:,108),heltab2x32(:,:,319))
  call Hloop_Q_A(ntryL,G0H8(27),20,nMB,G1H8(63),n2h8(106))
  Gcoeff(:)%j = (c(45)*M(3,:)%j-c(44)*M(7,:)%j) * den(9)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(326),h0tab(:,326),[20,3,8],[nMT,nMT,nMW],3,2,wf4(:,5),wf4(:,1))
  call Hloop_SQ_A(ntryL,G0H32(1),wf4(:,5),G0H8(26),ngPtb,m3h4x8(:,109),heltab2x32(:,:,320))
  call Hloop_Q_A(ntryL,G0H8(26),20,nMT,G1H8(64),n2h8(107))
  Gcoeff(:)%j = (-(c(11)*M(7,:)%j)) * den(9)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(327),h0tab(:,327),[20,3,8],[nMB,nMB,0],3,2,wf4(:,5),wf4(:,1))
  call Hloop_VQ_A(ntryL,G0H32(1),wf4(:,5),G0H8(40),m3h4x8(:,110),heltab2x32(:,:,321))
  call Hloop_Q_A(ntryL,G0H8(40),20,nMB,G1H8(65),n2h8(108))
  Gcoeff(:)%j = (c(16)*M(7,:)%j) * den(8)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(328),h0tab(:,328),[20,3,8],[nMB,nMB,0],3,2,wf4(:,5),wf4(:,7))
  call Hloop_VQ_A(ntryL,G0H32(1),wf4(:,5),G0H8(39),m3h4x8(:,111),heltab2x32(:,:,322))
  call Hloop_Q_A(ntryL,G0H8(39),20,nMB,G1H8(66),n2h8(109))
  Gcoeff(:)%j = (c(8)*M(3,:)%j-c(7)*M(7,:)%j) * den(9)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(329),h0tab(:,329),[20,3,8],[nMB,nMB,0],3,2,wf4(:,5),wf4(:,1))
  call Hloop_VQ_A(ntryL,G0H32(1),wf4(:,5),G0H8(49),m3h4x8(:,112),heltab2x32(:,:,323))
  call Hloop_Q_A(ntryL,G0H8(49),20,nMB,G1H8(67),n2h8(110))
  Gcoeff(:)%j = (c(15)*M(3,:)%j-c(14)*M(7,:)%j) * den(9)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(330),h0tab(:,330),[20,3,8],[nMB,nMB,nMZ],3,2,wf4(:,5),wf4(:,1))
  call Hloop_ZQ_A(ntryL,G0H32(1),wf4(:,5),G0H8(48),ngZd,m3h4x8(:,113),heltab2x32(:,:,324))
  call Hloop_Q_A(ntryL,G0H8(48),20,nMB,G1H8(68),n2h8(111))
  Gcoeff(:)%j = (c(40)*M(3,:)%j-c(39)*M(7,:)%j) * den(9)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(331),h0tab(:,331),[20,3,8],[nMT,nMT,nMW],3,2,wf4(:,5),wf4(:,1))
  call Hloop_WQ_A(ntryL,G0H32(1),wf4(:,5),G0H8(1),m3h4x8(:,114),heltab2x32(:,:,325))
  call Hloop_Q_A(ntryL,G0H8(1),20,nMT,G1H8(69),n2h8(112))
  Gcoeff(:)%j = (-(c(27)*M(4,:)%j)+c(26)*M(8,:)%j) * den(9)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(332),h0tab(:,332),[20,3,8],[nMB,nMB,0],3,2,wf4(:,5),wf4(:,1))
  call Hloop_VQ_A(ntryL,G0H32(1),wf4(:,5),G0H8(2),m3h4x8(:,115),heltab2x32(:,:,326))
  call Hloop_Q_A(ntryL,G0H8(2),20,nMB,G1H8(70),n2h8(113))
  Gcoeff(:)%j = (c(22)*M(4,:)%j-c(20)*M(8,:)%j) * den(9)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(333),h0tab(:,333),[20,3,8],[0,0,nMB],3,2,wf4(:,5),wf4(:,1))
  call Hloop_AQ_V(ntryL,G0H32(1),wf4(:,5),G0H8(3),m3h4x8(:,116),heltab2x32(:,:,327))
  Gcoeff(:)%j = (-(c(54)*M(7,:)%j)) * den(11)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(334),h0tab(:,334),[24,3,4],[nMB,nMB,0],3,2,wf4(:,9),wf4(:,3))
  call Hloop_VA_Q(ntryL,G0H32(1),wf4(:,9),G0H8(4),m3h4x8(:,117),heltab2x32(:,:,328))
  call Hloop_A_Q(ntryL,G0H8(4),24,nMB,G1H8(71),n2h8(114))
  Gcoeff(:)%j = (-(c(54)*M(7,:)%j)) * den(12)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(335),h0tab(:,335),[24,3,4],[nMB,nMB,0],3,2,wf4(:,9),wf4(:,6))
  call Hloop_VA_Q(ntryL,G0H32(1),wf4(:,9),G0H8(5),m3h4x8(:,118),heltab2x32(:,:,329))
  call Hloop_A_Q(ntryL,G0H8(5),24,nMB,G1H8(45),n2h8(115))
  Gcoeff(:)%j = (-(c(49)*M(5,:)%j)+c(48)*M(7,:)%j) * den(13)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(336),h0tab(:,336),[24,3,4],[nMB,nMB,nMH],3,2,wf4(:,9),wf4(:,1))
  call Hloop_SA_Q(ntryL,G0H32(1),wf4(:,9),G0H8(6),ngH,m3h4x8(:,119),heltab2x32(:,:,330))
  call Hloop_A_Q(ntryL,G0H8(6),24,nMB,G1H8(2),n2h8(116))
  Gcoeff(:)%j = (c(49)*M(5,:)%j-c(48)*M(7,:)%j) * den(13)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(337),h0tab(:,337),[24,3,4],[nMB,nMB,nMZ],3,2,wf4(:,9),wf4(:,1))
  call Hloop_SA_Q(ntryL,G0H32(1),wf4(:,9),G0H8(7),ngX,m3h4x8(:,120),heltab2x32(:,:,331))
  call Hloop_A_Q(ntryL,G0H8(7),24,nMB,G1H8(3),n2h8(117))
  Gcoeff(:)%j = (c(45)*M(5,:)%j-c(44)*M(7,:)%j) * den(13)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(338),h0tab(:,338),[24,3,4],[nMT,nMT,nMW],3,2,wf4(:,9),wf4(:,1))
  call Hloop_SA_Q(ntryL,G0H32(1),wf4(:,9),G0H8(8),ngPbt,m3h4x8(:,121),heltab2x32(:,:,332))
  call Hloop_A_Q(ntryL,G0H8(8),24,nMT,G1H8(8),n2h8(118))
  Gcoeff(:)%j = (-(c(11)*M(7,:)%j)) * den(13)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(339),h0tab(:,339),[24,3,4],[nMB,nMB,0],3,2,wf4(:,9),wf4(:,1))
  call Hloop_VA_Q(ntryL,G0H32(1),wf4(:,9),G0H8(9),m3h4x8(:,122),heltab2x32(:,:,333))
  call Hloop_A_Q(ntryL,G0H8(9),24,nMB,G1H8(6),n2h8(119))
  Gcoeff(:)%j = (c(16)*M(7,:)%j) * den(12)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(340),h0tab(:,340),[24,3,4],[nMB,nMB,0],3,2,wf4(:,9),wf4(:,7))
  call Hloop_VA_Q(ntryL,G0H32(1),wf4(:,9),G0H8(10),m3h4x8(:,123),heltab2x32(:,:,334))
  call Hloop_A_Q(ntryL,G0H8(10),24,nMB,G1H8(9),n2h8(120))
  Gcoeff(:)%j = (c(8)*M(5,:)%j-c(7)*M(7,:)%j) * den(13)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(341),h0tab(:,341),[24,3,4],[nMB,nMB,0],3,2,wf4(:,9),wf4(:,1))
  call Hloop_VA_Q(ntryL,G0H32(1),wf4(:,9),G0H8(11),m3h4x8(:,124),heltab2x32(:,:,335))
  call Hloop_A_Q(ntryL,G0H8(11),24,nMB,G1H8(10),n2h8(121))
  Gcoeff(:)%j = (c(15)*M(5,:)%j-c(14)*M(7,:)%j) * den(13)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(342),h0tab(:,342),[24,3,4],[nMB,nMB,nMZ],3,2,wf4(:,9),wf4(:,1))
  call Hloop_ZA_Q(ntryL,G0H32(1),wf4(:,9),G0H8(12),ngZd,m3h4x8(:,125),heltab2x32(:,:,336))
  call Hloop_A_Q(ntryL,G0H8(12),24,nMB,G1H8(11),n2h8(122))
  Gcoeff(:)%j = (c(40)*M(5,:)%j-c(39)*M(7,:)%j) * den(13)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(343),h0tab(:,343),[24,3,4],[nMT,nMT,nMW],3,2,wf4(:,9),wf4(:,1))
  call Hloop_WA_Q(ntryL,G0H32(1),wf4(:,9),G0H8(13),m3h4x8(:,126),heltab2x32(:,:,337))
  call Hloop_A_Q(ntryL,G0H8(13),24,nMT,G1H8(12),n2h8(123))
  Gcoeff(:)%j = (-(c(27)*M(6,:)%j)+c(26)*M(8,:)%j) * den(13)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(344),h0tab(:,344),[24,3,4],[nMB,nMB,0],3,2,wf4(:,9),wf4(:,1))
  call Hloop_VA_Q(ntryL,G0H32(1),wf4(:,9),G0H8(14),m3h4x8(:,127),heltab2x32(:,:,338))
  call Hloop_A_Q(ntryL,G0H8(14),24,nMB,G1H8(15),n2h8(124))
  Gcoeff(:)%j = (-(c(22)*M(6,:)%j)+c(20)*M(8,:)%j) * den(13)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(345),h0tab(:,345),[24,3,4],[0,0,nMB],3,2,wf4(:,9),wf4(:,1))
  call Hloop_QA_V(ntryL,G0H32(1),wf4(:,9),G0H8(15),m3h4x8(:,128),heltab2x32(:,:,339))
  Gcoeff(:)%j = (c(52)*M(7,:)%j) * den(52)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(346),h0tab(:,346),[16,7,8],[nMB,0,nMB],3,1,wf8(:,96))
  call Hloop_AV_Q(ntryL,G0H32(1),ex5(:),G0H16(1),m3h2x16(:,212),heltab2x32(:,:,340))
  call Hloop_A_Q(ntryL,G0H16(1),16,nMB,G1H16(43),n2h16(163))
  Gcoeff(:)%j = (c(52)*M(7,:)%j) * den(54)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(347),h0tab(:,347),[16,7,8],[nMB,0,nMB],3,1,wf8(:,97))
  call Hloop_AV_Q(ntryL,G0H32(1),ex5(:),G0H16(1),m3h2x16(:,213),heltab2x32(:,:,341))
  call Hloop_A_Q(ntryL,G0H16(1),16,nMB,G1H16(49),n2h16(164))
  Gcoeff(:)%j = (c(51)*M(7,:)%j) * den(52)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(348),h0tab(:,348),[16,7,8],[0,nMB,0],3,1,wf8(:,96))
  call Hloop_UV_W(ntryL,G0H32(1),0,ex5(:),16,G1H16(44),m3h2x16(:,214),heltab2x32(:,:,342))
  Gcoeff(:)%j = (c(51)*M(7,:)%j) * den(54)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(349),h0tab(:,349),[16,7,8],[0,nMB,0],3,1,wf8(:,97))
  call Hloop_UV_W(ntryL,G0H32(1),0,ex5(:),16,G1H16(48),m3h2x16(:,215),heltab2x32(:,:,343))
  Gcoeff(:)%j = (-(c(49)*M(5,:)%j)+c(48)*M(7,:)%j) * den(56)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(350),h0tab(:,350),[16,7,8],[nMB,nMH,nMB],3,1,wf8(:,98))
  call Hloop_AV_Q(ntryL,G0H32(1),ex5(:),G0H16(1),m3h2x16(:,216),heltab2x32(:,:,344))
  call Hloop_A_Q(ntryL,G0H16(1),16,nMB,G1H16(47),n2h16(165))
  Gcoeff(:)%j = (c(49)*M(5,:)%j-c(48)*M(7,:)%j) * den(56)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(351),h0tab(:,351),[16,7,8],[nMB,nMZ,nMB],3,1,wf8(:,98))
  call Hloop_AV_Q(ntryL,G0H32(1),ex5(:),G0H16(1),m3h2x16(:,217),heltab2x32(:,:,345))
  call Hloop_A_Q(ntryL,G0H16(1),16,nMB,G1H16(50),n2h16(166))
  Gcoeff(:)%j = (c(45)*M(5,:)%j-c(44)*M(7,:)%j) * den(56)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(352),h0tab(:,352),[16,7,8],[nMT,nMW,nMT],3,1,wf8(:,98))
  call Hloop_AV_Q(ntryL,G0H32(1),ex5(:),G0H16(1),m3h2x16(:,218),heltab2x32(:,:,346))
  call Hloop_A_Q(ntryL,G0H16(1),16,nMT,G1H16(51),n2h16(167))
  Gcoeff(:)%j = (c(9)*M(7,:)%j) * den(56)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(353),h0tab(:,353),[16,7,8],[nMB,0,nMB],3,1,wf8(:,98))
  call Hloop_AV_Q(ntryL,G0H32(1),ex5(:),G0H16(1),m3h2x16(:,219),heltab2x32(:,:,347))
  call Hloop_A_Q(ntryL,G0H16(1),16,nMB,G1H16(52),n2h16(168))
  Gcoeff(:)%j = (-(c(14)*M(7,:)%j)) * den(54)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(354),h0tab(:,354),[16,7,8],[nMB,0,nMB],3,1,wf8(:,99))
  call Hloop_AV_Q(ntryL,G0H32(1),ex5(:),G0H16(1),m3h2x16(:,220),heltab2x32(:,:,348))
  call Hloop_A_Q(ntryL,G0H16(1),16,nMB,G1H16(53),n2h16(169))
  Gcoeff(:)%j = (c(8)*M(5,:)%j-c(7)*M(7,:)%j) * den(56)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(355),h0tab(:,355),[16,7,8],[nMB,0,nMB],3,1,wf8(:,98))
  call Hloop_AV_Q(ntryL,G0H32(1),ex5(:),G0H16(1),m3h2x16(:,221),heltab2x32(:,:,349))
  call Hloop_A_Q(ntryL,G0H16(1),16,nMB,G1H16(54),n2h16(170))
  Gcoeff(:)%j = (c(15)*M(5,:)%j-c(14)*M(7,:)%j) * den(56)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(356),h0tab(:,356),[16,7,8],[nMB,nMZ,nMB],3,1,wf8(:,98))
  call Hloop_AV_Q(ntryL,G0H32(1),ex5(:),G0H16(1),m3h2x16(:,222),heltab2x32(:,:,350))
  call Hloop_A_Q(ntryL,G0H16(1),16,nMB,G1H16(55),n2h16(171))
  Gcoeff(:)%j = (c(40)*M(5,:)%j-c(39)*M(7,:)%j) * den(56)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(357),h0tab(:,357),[16,7,8],[nMT,nMW,nMT],3,1,wf8(:,98))
  call Hloop_AV_Q(ntryL,G0H32(1),ex5(:),G0H16(1),m3h2x16(:,223),heltab2x32(:,:,351))
  call Hloop_A_Q(ntryL,G0H16(1),16,nMT,G1H16(61),n2h16(172))
  Gcoeff(:)%j = (-(c(27)*M(6,:)%j)+c(26)*M(8,:)%j) * den(56)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(358),h0tab(:,358),[16,7,8],[nMB,0,nMB],3,1,wf8(:,98))
  call Hloop_AV_Q(ntryL,G0H32(1),ex5(:),G0H16(1),m3h2x16(:,224),heltab2x32(:,:,352))
  call Hloop_A_Q(ntryL,G0H16(1),16,nMB,G1H16(57),n2h16(173))
  Gcoeff(:)%j = (c(3)*M(7,:)%j) * den(56)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(359),h0tab(:,359),[16,7,8],[0,nMB,0],3,1,wf8(:,98))
  call Hloop_UV_W(ntryL,G0H32(1),0,ex5(:),16,G1H16(59),m3h2x16(:,225),heltab2x32(:,:,353))
  Gcoeff(:)%j = (-(c(6)*M(7,:)%j)) * den(54)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(360),h0tab(:,360),[16,7,8],[0,nMB,0],3,1,wf8(:,99))
  call Hloop_UV_W(ntryL,G0H32(1),0,ex5(:),16,G1H16(60),m3h2x16(:,226),heltab2x32(:,:,354))
  Gcoeff(:)%j = (-(c(22)*M(6,:)%j)+c(20)*M(8,:)%j) * den(56)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(361),h0tab(:,361),[16,7,8],[0,nMB,0],3,1,wf8(:,98))
  call Hloop_UV_W(ntryL,G0H32(1),0,ex5(:),16,G1H16(62),m3h2x16(:,227),heltab2x32(:,:,355))
  Gcoeff(:)%j = (c(52)*M(7,:)%j) * den(43)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(362),h0tab(:,362),[16,4,11],[nMB,0,nMB],3,1,wf8(:,91))
  call Hloop_AV_Q(ntryL,G0H32(1),ex5(:),G0H16(1),m3h2x16(:,228),heltab2x32(:,:,356))
  call Hloop_A_Q(ntryL,G0H16(1),16,nMB,G1H16(67),n2h16(174))
  Gcoeff(:)%j = (c(52)*M(7,:)%j) * den(45)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(363),h0tab(:,363),[16,4,11],[nMB,0,nMB],3,1,wf8(:,92))
  call Hloop_AV_Q(ntryL,G0H32(1),ex5(:),G0H16(1),m3h2x16(:,229),heltab2x32(:,:,357))
  call Hloop_A_Q(ntryL,G0H16(1),16,nMB,G1H16(65),n2h16(175))
  Gcoeff(:)%j = (c(51)*M(7,:)%j) * den(43)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(364),h0tab(:,364),[16,4,11],[0,nMB,0],3,1,wf8(:,91))
  call Hloop_UV_W(ntryL,G0H32(1),0,ex5(:),16,G1H16(66),m3h2x16(:,230),heltab2x32(:,:,358))
  Gcoeff(:)%j = (c(51)*M(7,:)%j) * den(45)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(365),h0tab(:,365),[16,4,11],[0,nMB,0],3,1,wf8(:,92))
  call Hloop_UV_W(ntryL,G0H32(1),0,ex5(:),16,G1H16(70),m3h2x16(:,231),heltab2x32(:,:,359))
  Gcoeff(:)%j = (-(c(49)*M(3,:)%j)+c(48)*M(7,:)%j) * den(47)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(366),h0tab(:,366),[16,4,11],[nMB,nMH,nMB],3,1,wf8(:,93))
  call Hloop_AV_Q(ntryL,G0H32(1),ex5(:),G0H16(1),m3h2x16(:,232),heltab2x32(:,:,360))
  call Hloop_A_Q(ntryL,G0H16(1),16,nMB,G1H16(69),n2h16(176))
  Gcoeff(:)%j = (c(49)*M(3,:)%j-c(48)*M(7,:)%j) * den(47)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(367),h0tab(:,367),[16,4,11],[nMB,nMZ,nMB],3,1,wf8(:,93))
  call Hloop_AV_Q(ntryL,G0H32(1),ex5(:),G0H16(1),m3h2x16(:,233),heltab2x32(:,:,361))
  call Hloop_A_Q(ntryL,G0H16(1),16,nMB,G1H16(81),n2h16(177))
  Gcoeff(:)%j = (c(45)*M(3,:)%j-c(44)*M(7,:)%j) * den(47)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(368),h0tab(:,368),[16,4,11],[nMT,nMW,nMT],3,1,wf8(:,93))
  call Hloop_AV_Q(ntryL,G0H32(1),ex5(:),G0H16(1),m3h2x16(:,234),heltab2x32(:,:,362))
  call Hloop_A_Q(ntryL,G0H16(1),16,nMT,G1H16(82),n2h16(178))
  Gcoeff(:)%j = (c(9)*M(7,:)%j) * den(47)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(369),h0tab(:,369),[16,4,11],[nMB,0,nMB],3,1,wf8(:,93))
  call Hloop_AV_Q(ntryL,G0H32(1),ex5(:),G0H16(1),m3h2x16(:,235),heltab2x32(:,:,363))
  call Hloop_A_Q(ntryL,G0H16(1),16,nMB,G1H16(83),n2h16(179))
  Gcoeff(:)%j = (-(c(14)*M(7,:)%j)) * den(45)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(370),h0tab(:,370),[16,4,11],[nMB,0,nMB],3,1,wf8(:,94))
  call Hloop_AV_Q(ntryL,G0H32(1),ex5(:),G0H16(1),m3h2x16(:,236),heltab2x32(:,:,364))
  call Hloop_A_Q(ntryL,G0H16(1),16,nMB,G1H16(84),n2h16(180))
  Gcoeff(:)%j = (c(8)*M(3,:)%j-c(7)*M(7,:)%j) * den(47)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(371),h0tab(:,371),[16,4,11],[nMB,0,nMB],3,1,wf8(:,93))
  call Hloop_AV_Q(ntryL,G0H32(1),ex5(:),G0H16(1),m3h2x16(:,237),heltab2x32(:,:,365))
  call Hloop_A_Q(ntryL,G0H16(1),16,nMB,G1H16(85),n2h16(181))
  Gcoeff(:)%j = (c(15)*M(3,:)%j-c(14)*M(7,:)%j) * den(47)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(372),h0tab(:,372),[16,4,11],[nMB,nMZ,nMB],3,1,wf8(:,93))
  call Hloop_AV_Q(ntryL,G0H32(1),ex5(:),G0H16(1),m3h2x16(:,238),heltab2x32(:,:,366))
  call Hloop_A_Q(ntryL,G0H16(1),16,nMB,G1H16(86),n2h16(182))
  Gcoeff(:)%j = (c(40)*M(3,:)%j-c(39)*M(7,:)%j) * den(47)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(373),h0tab(:,373),[16,4,11],[nMT,nMW,nMT],3,1,wf8(:,93))
  call Hloop_AV_Q(ntryL,G0H32(1),ex5(:),G0H16(1),m3h2x16(:,239),heltab2x32(:,:,367))
  call Hloop_A_Q(ntryL,G0H16(1),16,nMT,G1H16(87),n2h16(183))
  Gcoeff(:)%j = (-(c(27)*M(4,:)%j)+c(26)*M(8,:)%j) * den(47)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(374),h0tab(:,374),[16,4,11],[nMB,0,nMB],3,1,wf8(:,93))
  call Hloop_AV_Q(ntryL,G0H32(1),ex5(:),G0H16(1),m3h2x16(:,240),heltab2x32(:,:,368))
  call Hloop_A_Q(ntryL,G0H16(1),16,nMB,G1H16(88),n2h16(184))
  Gcoeff(:)%j = (c(3)*M(7,:)%j) * den(47)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(375),h0tab(:,375),[16,4,11],[0,nMB,0],3,1,wf8(:,93))
  call Hloop_UV_W(ntryL,G0H32(1),0,ex5(:),16,G1H16(89),m3h2x16(:,241),heltab2x32(:,:,369))
  Gcoeff(:)%j = (-(c(6)*M(7,:)%j)) * den(45)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(376),h0tab(:,376),[16,4,11],[0,nMB,0],3,1,wf8(:,94))
  call Hloop_UV_W(ntryL,G0H32(1),0,ex5(:),16,G1H16(90),m3h2x16(:,242),heltab2x32(:,:,370))
  Gcoeff(:)%j = (-(c(22)*M(4,:)%j)+c(20)*M(8,:)%j) * den(47)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(377),h0tab(:,377),[16,4,11],[0,nMB,0],3,1,wf8(:,93))
  call Hloop_UV_W(ntryL,G0H32(1),0,ex5(:),16,G1H16(91),m3h2x16(:,243),heltab2x32(:,:,371))
  Gcoeff(:)%j = (c(47)*(M(3,:)%j-M(5,:)%j)) * den(38)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(378),h0tab(:,378),[19,4,8],[nMB,nMH,nMB],3,1,wf8(:,1))
  call Hloop_AV_Q(ntryL,G0H32(1),wf8(:,1),G0H4(7),m3h8x4(:,1),heltab2x32(:,:,372))
  call Hloop_A_Q(ntryL,G0H4(7),19,nMB,G1H4(144),n2h4(159))
  Gcoeff(:)%j = (c(47)*(-M(3,:)%j+M(5,:)%j)) * den(38)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(379),h0tab(:,379),[19,4,8],[nMB,nMZ,nMB],3,1,wf8(:,1))
  call Hloop_AV_Q(ntryL,G0H32(1),wf8(:,1),G0H4(7),m3h8x4(:,2),heltab2x32(:,:,373))
  call Hloop_A_Q(ntryL,G0H4(7),19,nMB,G1H4(1),n2h4(160))
  Gcoeff(:)%j = (c(42)*(-M(3,:)%j+M(5,:)%j)) * den(38)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(380),h0tab(:,380),[19,4,8],[nMT,nMW,nMT],3,1,wf8(:,1))
  call Hloop_AV_Q(ntryL,G0H32(1),wf8(:,1),G0H4(7),m3h8x4(:,3),heltab2x32(:,:,374))
  call Hloop_A_Q(ntryL,G0H4(7),19,nMT,G1H4(2),n2h4(161))
  Gcoeff(:)%j = (c(1)*(-M(3,:)%j+M(5,:)%j)) * den(38)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(381),h0tab(:,381),[19,4,8],[nMB,0,nMB],3,1,wf8(:,1))
  call Hloop_AV_Q(ntryL,G0H32(1),wf8(:,1),G0H4(7),m3h8x4(:,4),heltab2x32(:,:,375))
  call Hloop_A_Q(ntryL,G0H4(7),19,nMB,G1H4(5),n2h4(162))
  Gcoeff(:)%j = (c(5)*(-M(3,:)%j+M(5,:)%j)) * den(38)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(382),h0tab(:,382),[19,4,8],[nMB,nMZ,nMB],3,1,wf8(:,1))
  call Hloop_AV_Q(ntryL,G0H32(1),wf8(:,1),G0H4(7),m3h8x4(:,5),heltab2x32(:,:,376))
  call Hloop_A_Q(ntryL,G0H4(7),19,nMB,G1H4(6),n2h4(163))
  Gcoeff(:)%j = (c(37)*(-M(3,:)%j+M(5,:)%j)) * den(38)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(383),h0tab(:,383),[19,4,8],[nMT,nMW,nMT],3,1,wf8(:,1))
  call Hloop_AV_Q(ntryL,G0H32(1),wf8(:,1),G0H4(7),m3h8x4(:,6),heltab2x32(:,:,377))
  call Hloop_A_Q(ntryL,G0H4(7),19,nMT,G1H4(8),n2h4(164))
  Gcoeff(:)%j = (c(19)*(M(4,:)%j-M(6,:)%j)) * den(38)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(384),h0tab(:,384),[19,4,8],[nMB,0,nMB],3,1,wf8(:,1))
  call Hloop_AV_Q(ntryL,G0H32(1),wf8(:,1),G0H4(7),m3h8x4(:,7),heltab2x32(:,:,378))
  call Hloop_A_Q(ntryL,G0H4(7),19,nMB,G1H4(11),n2h4(165))
  Gcoeff(:)%j = (c(35)*(M(4,:)%j-M(6,:)%j)) * den(38)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(385),h0tab(:,385),[19,4,8],[0,nMB,0],3,1,wf8(:,1))
  call Hloop_UV_W(ntryL,G0H32(1),0,wf8(:,1),19,G1H4(12),m3h8x4(:,8),heltab2x32(:,:,379))
  Gcoeff(:)%j = (-(c(46)*M(5,:)%j)) * den(16)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(386),h0tab(:,386),[17,6,8],[nMT,nMB,0],3,2,wf4(:,12),wf4(:,11))
  call Hloop_VQ_A(ntryL,G0H32(1),wf4(:,12),G0H8(16),m3h4x8(:,129),heltab2x32(:,:,380))
  call Hloop_Q_A(ntryL,G0H8(16),17,nMT,G1H8(16),n2h8(125))
  Gcoeff(:)%j = (-(c(41)*M(5,:)%j)) * den(16)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(387),h0tab(:,387),[17,6,8],[nMT,nMB,0],3,2,wf4(:,12),wf4(:,13))
  call Hloop_VQ_A(ntryL,G0H32(1),wf4(:,12),G0H8(21),m3h4x8(:,130),heltab2x32(:,:,381))
  call Hloop_Q_A(ntryL,G0H8(21),17,nMT,G1H8(18),n2h8(126))
  Gcoeff(:)%j = (-(c(46)*M(5,:)%j)) * den(17)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(388),h0tab(:,388),[24,1,6],[0,nMT,nMB],3,2,wf4(:,9),wf4(:,11))
  call Hloop_QA_V(ntryL,G0H32(1),wf4(:,9),G0H8(19),m3h4x8(:,131),heltab2x32(:,:,382))
  Gcoeff(:)%j = (-(c(41)*M(5,:)%j)) * den(17)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(389),h0tab(:,389),[24,1,6],[0,nMT,nMB],3,2,wf4(:,9),wf4(:,13))
  call Hloop_QA_V(ntryL,G0H32(1),wf4(:,9),G0H8(20),m3h4x8(:,132),heltab2x32(:,:,383))
  Gcoeff(:)%j = (c(44)*M(5,:)%j) * den(61)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(390),h0tab(:,390),[16,7,8],[nMB,0,nMB],3,1,wf8(:,104))
  call Hloop_AV_Q(ntryL,G0H32(1),ex5(:),G0H16(1),m3h2x16(:,244),heltab2x32(:,:,384))
  call Hloop_A_Q(ntryL,G0H16(1),16,nMB,G1H16(92),n2h16(185))
  Gcoeff(:)%j = (c(43)*M(5,:)%j) * den(61)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(391),h0tab(:,391),[16,7,8],[0,nMB,0],3,1,wf8(:,104))
  call Hloop_UV_W(ntryL,G0H32(1),0,ex5(:),16,G1H16(93),m3h2x16(:,245),heltab2x32(:,:,385))
  Gcoeff(:)%j = (c(39)*M(5,:)%j) * den(61)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(392),h0tab(:,392),[16,7,8],[nMB,0,nMB],3,1,wf8(:,105))
  call Hloop_AV_Q(ntryL,G0H32(1),ex5(:),G0H16(1),m3h2x16(:,246),heltab2x32(:,:,386))
  call Hloop_A_Q(ntryL,G0H16(1),16,nMB,G1H16(94),n2h16(186))
  Gcoeff(:)%j = (c(38)*M(5,:)%j) * den(61)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(393),h0tab(:,393),[16,7,8],[0,nMB,0],3,1,wf8(:,105))
  call Hloop_UV_W(ntryL,G0H32(1),0,ex5(:),16,G1H16(95),m3h2x16(:,247),heltab2x32(:,:,387))
  Gcoeff(:)%j = (c(44)*M(5,:)%j) * den(59)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(394),h0tab(:,394),[16,1,14],[nMT,0,nMT],3,1,wf8(:,101))
  call Hloop_AV_Q(ntryL,G0H32(1),ex5(:),G0H16(1),m3h2x16(:,248),heltab2x32(:,:,388))
  call Hloop_A_Q(ntryL,G0H16(1),16,nMT,G1H16(96),n2h16(187))
  Gcoeff(:)%j = (c(43)*M(5,:)%j) * den(59)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(395),h0tab(:,395),[16,1,14],[0,nMT,0],3,1,wf8(:,101))
  call Hloop_UV_W(ntryL,G0H32(1),0,ex5(:),16,G1H16(97),m3h2x16(:,249),heltab2x32(:,:,389))
  Gcoeff(:)%j = (c(39)*M(5,:)%j) * den(59)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(396),h0tab(:,396),[16,1,14],[nMT,0,nMT],3,1,wf8(:,103))
  call Hloop_AV_Q(ntryL,G0H32(1),ex5(:),G0H16(1),m3h2x16(:,250),heltab2x32(:,:,390))
  call Hloop_A_Q(ntryL,G0H16(1),16,nMT,G1H16(98),n2h16(188))
  Gcoeff(:)%j = (c(38)*M(5,:)%j) * den(59)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(397),h0tab(:,397),[16,1,14],[0,nMT,0],3,1,wf8(:,103))
  call Hloop_UV_W(ntryL,G0H32(1),0,ex5(:),16,G1H16(99),m3h2x16(:,251),heltab2x32(:,:,391))
  Gcoeff(:)%j = (-(c(46)*M(3,:)%j)) * den(20)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(398),h0tab(:,398),[18,4,9],[0,nMB,nMT],3,2,wf4(:,16),wf4(:,14))
  call Hloop_QA_V(ntryL,G0H32(1),wf4(:,16),G0H8(22),m3h4x8(:,133),heltab2x32(:,:,392))
  Gcoeff(:)%j = (-(c(41)*M(3,:)%j)) * den(20)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(399),h0tab(:,399),[18,4,9],[0,nMB,nMT],3,2,wf4(:,16),wf4(:,17))
  call Hloop_QA_V(ntryL,G0H32(1),wf4(:,16),G0H8(23),m3h4x8(:,134),heltab2x32(:,:,393))
  Gcoeff(:)%j = (-(c(46)*M(3,:)%j)) * den(21)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(400),h0tab(:,400),[20,2,9],[0,nMT,nMB],3,2,wf4(:,5),wf4(:,14))
  call Hloop_AQ_V(ntryL,G0H32(1),wf4(:,5),G0H8(24),m3h4x8(:,135),heltab2x32(:,:,394))
  Gcoeff(:)%j = (-(c(41)*M(3,:)%j)) * den(21)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(401),h0tab(:,401),[20,2,9],[0,nMT,nMB],3,2,wf4(:,5),wf4(:,17))
  call Hloop_AQ_V(ntryL,G0H32(1),wf4(:,5),G0H8(25),m3h4x8(:,136),heltab2x32(:,:,395))
  Gcoeff(:)%j = (c(44)*M(3,:)%j) * den(66)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(402),h0tab(:,402),[16,4,11],[nMB,0,nMB],3,1,wf8(:,108))
  call Hloop_AV_Q(ntryL,G0H32(1),ex5(:),G0H16(1),m3h2x16(:,252),heltab2x32(:,:,396))
  call Hloop_A_Q(ntryL,G0H16(1),16,nMB,G1H16(100),n2h16(189))
  Gcoeff(:)%j = (c(43)*M(3,:)%j) * den(66)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(403),h0tab(:,403),[16,4,11],[0,nMB,0],3,1,wf8(:,108))
  call Hloop_UV_W(ntryL,G0H32(1),0,ex5(:),16,G1H16(101),m3h2x16(:,253),heltab2x32(:,:,397))
  Gcoeff(:)%j = (c(39)*M(3,:)%j) * den(66)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(404),h0tab(:,404),[16,4,11],[nMB,0,nMB],3,1,wf8(:,109))
  call Hloop_AV_Q(ntryL,G0H32(1),ex5(:),G0H16(1),m3h2x16(:,254),heltab2x32(:,:,398))
  call Hloop_A_Q(ntryL,G0H16(1),16,nMB,G1H16(102),n2h16(190))
  Gcoeff(:)%j = (c(38)*M(3,:)%j) * den(66)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(405),h0tab(:,405),[16,4,11],[0,nMB,0],3,1,wf8(:,109))
  call Hloop_UV_W(ntryL,G0H32(1),0,ex5(:),16,G1H16(103),m3h2x16(:,255),heltab2x32(:,:,399))
  Gcoeff(:)%j = (c(44)*M(3,:)%j) * den(64)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(406),h0tab(:,406),[16,2,13],[nMT,0,nMT],3,1,wf8(:,106))
  call Hloop_QV_A(ntryL,G0H32(1),ex5(:),G0H16(1),m3h2x16(:,256),heltab2x32(:,:,400))
  call Hloop_Q_A(ntryL,G0H16(1),16,nMT,G1H16(104),n2h16(191))
  Gcoeff(:)%j = (-(c(43)*M(3,:)%j)) * den(64)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(407),h0tab(:,407),[16,2,13],[0,nMT,0],3,1,wf8(:,106))
  call Hloop_UV_W(ntryL,G0H32(1),0,ex5(:),16,G1H16(105),m3h2x16(:,257),heltab2x32(:,:,401))
  Gcoeff(:)%j = (c(39)*M(3,:)%j) * den(64)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(408),h0tab(:,408),[16,2,13],[nMT,0,nMT],3,1,wf8(:,107))
  call Hloop_QV_A(ntryL,G0H32(1),ex5(:),G0H16(1),m3h2x16(:,258),heltab2x32(:,:,402))
  call Hloop_Q_A(ntryL,G0H16(1),16,nMT,G1H16(106),n2h16(192))
  Gcoeff(:)%j = (-(c(38)*M(3,:)%j)) * den(64)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(409),h0tab(:,409),[16,2,13],[0,nMT,0],3,1,wf8(:,107))
  call Hloop_UV_W(ntryL,G0H32(1),0,ex5(:),16,G1H16(107),m3h2x16(:,259),heltab2x32(:,:,403))
  Gcoeff(:)%j = (-(c(54)*M(1,:)%j)) * den(23)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(410),h0tab(:,410),[17,2,12],[0,nMT,nMT],3,2,wf4(:,12),wf4(:,18))
  call Hloop_AQ_V(ntryL,G0H32(1),wf4(:,12),G0H8(30),m3h4x8(:,137),heltab2x32(:,:,404))
  Gcoeff(:)%j = (-(c(54)*M(1,:)%j)) * den(25)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(411),h0tab(:,411),[17,2,12],[0,nMT,nMT],3,2,wf4(:,12),wf4(:,19))
  call Hloop_AQ_V(ntryL,G0H32(1),wf4(:,12),G0H8(28),m3h4x8(:,138),heltab2x32(:,:,405))
  Gcoeff(:)%j = (c(56)*M(1,:)%j-c(57)*M(5,:)%j) * den(26)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(412),h0tab(:,412),[17,2,12],[nMH,nMT,nMT],3,2,wf4(:,12),wf4(:,2))
  call Hloop_AQ_S(ntryL,G0H32(1),wf4(:,12),G0H8(29),ngH,m3h4x8(:,139),heltab2x32(:,:,406))
  Gcoeff(:)%j = (-(c(56)*M(1,:)%j)+c(57)*M(5,:)%j) * den(26)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(413),h0tab(:,413),[17,2,12],[nMZ,nMT,nMT],3,2,wf4(:,12),wf4(:,2))
  call Hloop_AQ_S(ntryL,G0H32(1),wf4(:,12),G0H8(31),ngX,m3h4x8(:,140),heltab2x32(:,:,407))
  Gcoeff(:)%j = (-(c(44)*M(1,:)%j)+c(45)*M(5,:)%j) * den(26)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(414),h0tab(:,414),[17,2,12],[nMW,nMB,nMB],3,2,wf4(:,12),wf4(:,2))
  call Hloop_AQ_S(ntryL,G0H32(1),wf4(:,12),G0H8(32),ngPbt,m3h4x8(:,141),heltab2x32(:,:,408))
  Gcoeff(:)%j = (-(c(11)*M(1,:)%j)) * den(26)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(415),h0tab(:,415),[17,2,12],[0,nMT,nMT],3,2,wf4(:,12),wf4(:,2))
  call Hloop_AQ_V(ntryL,G0H32(1),wf4(:,12),G0H8(33),m3h4x8(:,142),heltab2x32(:,:,409))
  Gcoeff(:)%j = (c(16)*M(1,:)%j) * den(25)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(416),h0tab(:,416),[17,2,12],[0,nMT,nMT],3,2,wf4(:,12),wf4(:,20))
  call Hloop_AQ_V(ntryL,G0H32(1),wf4(:,12),G0H8(34),m3h4x8(:,143),heltab2x32(:,:,410))
  Gcoeff(:)%j = (-(c(12)*M(1,:)%j)+c(13)*M(5,:)%j) * den(26)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(417),h0tab(:,417),[17,2,12],[0,nMT,nMT],3,2,wf4(:,12),wf4(:,2))
  call Hloop_AQ_V(ntryL,G0H32(1),wf4(:,12),G0H8(35),m3h4x8(:,144),heltab2x32(:,:,411))
  Gcoeff(:)%j = (-(c(14)*M(1,:)%j)+c(15)*M(5,:)%j) * den(26)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(418),h0tab(:,418),[17,2,12],[nMZ,nMT,nMT],3,2,wf4(:,12),wf4(:,2))
  call Hloop_AQ_Z(ntryL,G0H32(1),wf4(:,12),G0H8(36),ngZu,m3h4x8(:,145),heltab2x32(:,:,412))
  Gcoeff(:)%j = (-(c(39)*M(1,:)%j)+c(40)*M(5,:)%j) * den(26)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(419),h0tab(:,419),[17,2,12],[nMW,nMB,nMB],3,2,wf4(:,12),wf4(:,2))
  call Hloop_AQ_W(ntryL,G0H32(1),wf4(:,12),G0H8(37),m3h4x8(:,146),heltab2x32(:,:,413))
  Gcoeff(:)%j = (c(26)*M(2,:)%j-c(27)*M(6,:)%j) * den(26)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(420),h0tab(:,420),[17,2,12],[0,nMT,nMT],3,2,wf4(:,12),wf4(:,2))
  call Hloop_AQ_V(ntryL,G0H32(1),wf4(:,12),G0H8(38),m3h4x8(:,147),heltab2x32(:,:,414))
  Gcoeff(:)%j = (c(20)*M(2,:)%j-c(22)*M(6,:)%j) * den(26)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(421),h0tab(:,421),[17,2,12],[nMT,0,0],3,2,wf4(:,12),wf4(:,2))
  call Hloop_VQ_A(ntryL,G0H32(1),wf4(:,12),G0H8(43),m3h4x8(:,148),heltab2x32(:,:,415))
  call Hloop_Q_A(ntryL,G0H8(43),17,nMT,G1H8(19),n2h8(127))
  Gcoeff(:)%j = (-(c(54)*M(1,:)%j)) * den(27)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(422),h0tab(:,422),[18,1,12],[0,nMT,nMT],3,2,wf4(:,16),wf4(:,18))
  call Hloop_QA_V(ntryL,G0H32(1),wf4(:,16),G0H8(41),m3h4x8(:,149),heltab2x32(:,:,416))
  Gcoeff(:)%j = (-(c(54)*M(1,:)%j)) * den(28)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(423),h0tab(:,423),[18,1,12],[0,nMT,nMT],3,2,wf4(:,16),wf4(:,19))
  call Hloop_QA_V(ntryL,G0H32(1),wf4(:,16),G0H8(42),m3h4x8(:,150),heltab2x32(:,:,417))
  Gcoeff(:)%j = (c(56)*M(1,:)%j-c(57)*M(3,:)%j) * den(29)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(424),h0tab(:,424),[18,1,12],[nMH,nMT,nMT],3,2,wf4(:,16),wf4(:,2))
  call Hloop_QA_S(ntryL,G0H32(1),wf4(:,16),G0H8(44),ngH,m3h4x8(:,151),heltab2x32(:,:,418))
  Gcoeff(:)%j = (-(c(56)*M(1,:)%j)+c(57)*M(3,:)%j) * den(29)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(425),h0tab(:,425),[18,1,12],[nMZ,nMT,nMT],3,2,wf4(:,16),wf4(:,2))
  call Hloop_QA_S(ntryL,G0H32(1),wf4(:,16),G0H8(45),ngX,m3h4x8(:,152),heltab2x32(:,:,419))
  Gcoeff(:)%j = (-(c(44)*M(1,:)%j)+c(45)*M(3,:)%j) * den(29)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(426),h0tab(:,426),[18,1,12],[nMW,nMB,nMB],3,2,wf4(:,16),wf4(:,2))
  call Hloop_QA_S(ntryL,G0H32(1),wf4(:,16),G0H8(46),ngPtb,m3h4x8(:,153),heltab2x32(:,:,420))
  Gcoeff(:)%j = (-(c(11)*M(1,:)%j)) * den(29)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(427),h0tab(:,427),[18,1,12],[0,nMT,nMT],3,2,wf4(:,16),wf4(:,2))
  call Hloop_QA_V(ntryL,G0H32(1),wf4(:,16),G0H8(47),m3h4x8(:,154),heltab2x32(:,:,421))
  Gcoeff(:)%j = (c(16)*M(1,:)%j) * den(28)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(428),h0tab(:,428),[18,1,12],[0,nMT,nMT],3,2,wf4(:,16),wf4(:,20))
  call Hloop_QA_V(ntryL,G0H32(1),wf4(:,16),G0H8(52),m3h4x8(:,155),heltab2x32(:,:,422))
  Gcoeff(:)%j = (-(c(12)*M(1,:)%j)+c(13)*M(3,:)%j) * den(29)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(429),h0tab(:,429),[18,1,12],[0,nMT,nMT],3,2,wf4(:,16),wf4(:,2))
  call Hloop_QA_V(ntryL,G0H32(1),wf4(:,16),G0H8(50),m3h4x8(:,156),heltab2x32(:,:,423))
  Gcoeff(:)%j = (-(c(14)*M(1,:)%j)+c(15)*M(3,:)%j) * den(29)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(430),h0tab(:,430),[18,1,12],[nMZ,nMT,nMT],3,2,wf4(:,16),wf4(:,2))
  call Hloop_QA_Z(ntryL,G0H32(1),wf4(:,16),G0H8(51),ngZu,m3h4x8(:,157),heltab2x32(:,:,424))
  Gcoeff(:)%j = (-(c(39)*M(1,:)%j)+c(40)*M(3,:)%j) * den(29)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(431),h0tab(:,431),[18,1,12],[nMW,nMB,nMB],3,2,wf4(:,16),wf4(:,2))
  call Hloop_QA_W(ntryL,G0H32(1),wf4(:,16),G0H8(53),m3h4x8(:,158),heltab2x32(:,:,425))
  Gcoeff(:)%j = (c(26)*M(2,:)%j-c(27)*M(4,:)%j) * den(29)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(432),h0tab(:,432),[18,1,12],[0,nMT,nMT],3,2,wf4(:,16),wf4(:,2))
  call Hloop_QA_V(ntryL,G0H32(1),wf4(:,16),G0H8(18),m3h4x8(:,159),heltab2x32(:,:,426))
  Gcoeff(:)%j = (-(c(20)*M(2,:)%j)+c(22)*M(4,:)%j) * den(29)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(433),h0tab(:,433),[18,1,12],[nMT,0,0],3,2,wf4(:,16),wf4(:,2))
  call Hloop_VA_Q(ntryL,G0H32(1),wf4(:,16),G0H8(17),m3h4x8(:,160),heltab2x32(:,:,427))
  call Hloop_A_Q(ntryL,G0H8(17),18,nMT,G1H8(21),n2h8(128))
  Gcoeff(:)%j = (c(52)*M(1,:)%j) * den(76)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(434),h0tab(:,434),[16,2,13],[nMT,0,nMT],3,1,wf8(:,119))
  call Hloop_QV_A(ntryL,G0H32(1),ex5(:),G0H16(1),m3h2x16(:,260),heltab2x32(:,:,428))
  call Hloop_Q_A(ntryL,G0H16(1),16,nMT,G1H16(108),n2h16(193))
  Gcoeff(:)%j = (c(52)*M(1,:)%j) * den(78)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(435),h0tab(:,435),[16,2,13],[nMT,0,nMT],3,1,wf8(:,121))
  call Hloop_QV_A(ntryL,G0H32(1),ex5(:),G0H16(1),m3h2x16(:,261),heltab2x32(:,:,429))
  call Hloop_Q_A(ntryL,G0H16(1),16,nMT,G1H16(109),n2h16(194))
  Gcoeff(:)%j = (-(c(51)*M(1,:)%j)) * den(76)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(436),h0tab(:,436),[16,2,13],[0,nMT,0],3,1,wf8(:,119))
  call Hloop_UV_W(ntryL,G0H32(1),0,ex5(:),16,G1H16(110),m3h2x16(:,262),heltab2x32(:,:,430))
  Gcoeff(:)%j = (-(c(51)*M(1,:)%j)) * den(78)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(437),h0tab(:,437),[16,2,13],[0,nMT,0],3,1,wf8(:,121))
  call Hloop_UV_W(ntryL,G0H32(1),0,ex5(:),16,G1H16(111),m3h2x16(:,263),heltab2x32(:,:,431))
  Gcoeff(:)%j = (c(56)*M(1,:)%j-c(57)*M(3,:)%j) * den(80)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(438),h0tab(:,438),[16,2,13],[nMT,nMH,nMT],3,1,wf8(:,123))
  call Hloop_QV_A(ntryL,G0H32(1),ex5(:),G0H16(1),m3h2x16(:,264),heltab2x32(:,:,432))
  call Hloop_Q_A(ntryL,G0H16(1),16,nMT,G1H16(112),n2h16(195))
  Gcoeff(:)%j = (-(c(56)*M(1,:)%j)+c(57)*M(3,:)%j) * den(80)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(439),h0tab(:,439),[16,2,13],[nMT,nMZ,nMT],3,1,wf8(:,123))
  call Hloop_QV_A(ntryL,G0H32(1),ex5(:),G0H16(1),m3h2x16(:,265),heltab2x32(:,:,433))
  call Hloop_Q_A(ntryL,G0H16(1),16,nMT,G1H16(113),n2h16(196))
  Gcoeff(:)%j = (-(c(44)*M(1,:)%j)+c(45)*M(3,:)%j) * den(80)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(440),h0tab(:,440),[16,2,13],[nMB,nMW,nMB],3,1,wf8(:,123))
  call Hloop_QV_A(ntryL,G0H32(1),ex5(:),G0H16(1),m3h2x16(:,266),heltab2x32(:,:,434))
  call Hloop_Q_A(ntryL,G0H16(1),16,nMB,G1H16(114),n2h16(197))
  Gcoeff(:)%j = (c(9)*M(1,:)%j) * den(80)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(441),h0tab(:,441),[16,2,13],[nMT,0,nMT],3,1,wf8(:,123))
  call Hloop_QV_A(ntryL,G0H32(1),ex5(:),G0H16(1),m3h2x16(:,267),heltab2x32(:,:,435))
  call Hloop_Q_A(ntryL,G0H16(1),16,nMT,G1H16(115),n2h16(198))
  Gcoeff(:)%j = (-(c(14)*M(1,:)%j)) * den(78)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(442),h0tab(:,442),[16,2,13],[nMT,0,nMT],3,1,wf8(:,125))
  call Hloop_QV_A(ntryL,G0H32(1),ex5(:),G0H16(1),m3h2x16(:,268),heltab2x32(:,:,436))
  call Hloop_Q_A(ntryL,G0H16(1),16,nMT,G1H16(116),n2h16(199))
  Gcoeff(:)%j = (-(c(12)*M(1,:)%j)+c(13)*M(3,:)%j) * den(80)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(443),h0tab(:,443),[16,2,13],[nMT,0,nMT],3,1,wf8(:,123))
  call Hloop_QV_A(ntryL,G0H32(1),ex5(:),G0H16(1),m3h2x16(:,269),heltab2x32(:,:,437))
  call Hloop_Q_A(ntryL,G0H16(1),16,nMT,G1H16(117),n2h16(200))
  Gcoeff(:)%j = (-(c(14)*M(1,:)%j)+c(15)*M(3,:)%j) * den(80)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(444),h0tab(:,444),[16,2,13],[nMT,nMZ,nMT],3,1,wf8(:,123))
  call Hloop_QV_A(ntryL,G0H32(1),ex5(:),G0H16(1),m3h2x16(:,270),heltab2x32(:,:,438))
  call Hloop_Q_A(ntryL,G0H16(1),16,nMT,G1H16(118),n2h16(201))
  Gcoeff(:)%j = (-(c(39)*M(1,:)%j)+c(40)*M(3,:)%j) * den(80)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(445),h0tab(:,445),[16,2,13],[nMB,nMW,nMB],3,1,wf8(:,123))
  call Hloop_QV_A(ntryL,G0H32(1),ex5(:),G0H16(1),m3h2x16(:,271),heltab2x32(:,:,439))
  call Hloop_Q_A(ntryL,G0H16(1),16,nMB,G1H16(119),n2h16(202))
  Gcoeff(:)%j = (c(26)*M(2,:)%j-c(27)*M(4,:)%j) * den(80)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(446),h0tab(:,446),[16,2,13],[nMT,0,nMT],3,1,wf8(:,123))
  call Hloop_QV_A(ntryL,G0H32(1),ex5(:),G0H16(1),m3h2x16(:,272),heltab2x32(:,:,440))
  call Hloop_Q_A(ntryL,G0H16(1),16,nMT,G1H16(120),n2h16(203))
  Gcoeff(:)%j = (-(c(3)*M(1,:)%j)) * den(80)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(447),h0tab(:,447),[16,2,13],[0,nMT,0],3,1,wf8(:,123))
  call Hloop_UV_W(ntryL,G0H32(1),0,ex5(:),16,G1H16(121),m3h2x16(:,273),heltab2x32(:,:,441))
  Gcoeff(:)%j = (c(6)*M(1,:)%j) * den(78)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(448),h0tab(:,448),[16,2,13],[0,nMT,0],3,1,wf8(:,125))
  call Hloop_UV_W(ntryL,G0H32(1),0,ex5(:),16,G1H16(122),m3h2x16(:,274),heltab2x32(:,:,442))
  Gcoeff(:)%j = (-(c(20)*M(2,:)%j)+c(22)*M(4,:)%j) * den(80)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(449),h0tab(:,449),[16,2,13],[0,nMT,0],3,1,wf8(:,123))
  call Hloop_UV_W(ntryL,G0H32(1),0,ex5(:),16,G1H16(123),m3h2x16(:,275),heltab2x32(:,:,443))
  Gcoeff(:)%j = (c(52)*M(1,:)%j) * den(68)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(450),h0tab(:,450),[16,1,14],[nMT,0,nMT],3,1,wf8(:,111))
  call Hloop_AV_Q(ntryL,G0H32(1),ex5(:),G0H16(1),m3h2x16(:,276),heltab2x32(:,:,444))
  call Hloop_A_Q(ntryL,G0H16(1),16,nMT,G1H16(124),n2h16(204))
  Gcoeff(:)%j = (c(52)*M(1,:)%j) * den(70)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(451),h0tab(:,451),[16,1,14],[nMT,0,nMT],3,1,wf8(:,113))
  call Hloop_AV_Q(ntryL,G0H32(1),ex5(:),G0H16(1),m3h2x16(:,277),heltab2x32(:,:,445))
  call Hloop_A_Q(ntryL,G0H16(1),16,nMT,G1H16(125),n2h16(205))
  Gcoeff(:)%j = (c(51)*M(1,:)%j) * den(68)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(452),h0tab(:,452),[16,1,14],[0,nMT,0],3,1,wf8(:,111))
  call Hloop_UV_W(ntryL,G0H32(1),0,ex5(:),16,G1H16(126),m3h2x16(:,278),heltab2x32(:,:,446))
  Gcoeff(:)%j = (c(51)*M(1,:)%j) * den(70)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(453),h0tab(:,453),[16,1,14],[0,nMT,0],3,1,wf8(:,113))
  call Hloop_UV_W(ntryL,G0H32(1),0,ex5(:),16,G1H16(127),m3h2x16(:,279),heltab2x32(:,:,447))
  Gcoeff(:)%j = (c(56)*M(1,:)%j-c(57)*M(5,:)%j) * den(72)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(454),h0tab(:,454),[16,1,14],[nMT,nMH,nMT],3,1,wf8(:,115))
  call Hloop_AV_Q(ntryL,G0H32(1),ex5(:),G0H16(1),m3h2x16(:,280),heltab2x32(:,:,448))
  call Hloop_A_Q(ntryL,G0H16(1),16,nMT,G1H16(128),n2h16(206))
  Gcoeff(:)%j = (-(c(56)*M(1,:)%j)+c(57)*M(5,:)%j) * den(72)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(455),h0tab(:,455),[16,1,14],[nMT,nMZ,nMT],3,1,wf8(:,115))
  call Hloop_AV_Q(ntryL,G0H32(1),ex5(:),G0H16(1),m3h2x16(:,281),heltab2x32(:,:,449))
  call Hloop_A_Q(ntryL,G0H16(1),16,nMT,G1H16(129),n2h16(207))
  Gcoeff(:)%j = (-(c(44)*M(1,:)%j)+c(45)*M(5,:)%j) * den(72)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(456),h0tab(:,456),[16,1,14],[nMB,nMW,nMB],3,1,wf8(:,115))
  call Hloop_AV_Q(ntryL,G0H32(1),ex5(:),G0H16(1),m3h2x16(:,282),heltab2x32(:,:,450))
  call Hloop_A_Q(ntryL,G0H16(1),16,nMB,G1H16(130),n2h16(208))
  Gcoeff(:)%j = (c(9)*M(1,:)%j) * den(72)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(457),h0tab(:,457),[16,1,14],[nMT,0,nMT],3,1,wf8(:,115))
  call Hloop_AV_Q(ntryL,G0H32(1),ex5(:),G0H16(1),m3h2x16(:,283),heltab2x32(:,:,451))
  call Hloop_A_Q(ntryL,G0H16(1),16,nMT,G1H16(131),n2h16(209))
  Gcoeff(:)%j = (-(c(14)*M(1,:)%j)) * den(70)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(458),h0tab(:,458),[16,1,14],[nMT,0,nMT],3,1,wf8(:,117))
  call Hloop_AV_Q(ntryL,G0H32(1),ex5(:),G0H16(1),m3h2x16(:,284),heltab2x32(:,:,452))
  call Hloop_A_Q(ntryL,G0H16(1),16,nMT,G1H16(132),n2h16(210))
  Gcoeff(:)%j = (-(c(12)*M(1,:)%j)+c(13)*M(5,:)%j) * den(72)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(459),h0tab(:,459),[16,1,14],[nMT,0,nMT],3,1,wf8(:,115))
  call Hloop_AV_Q(ntryL,G0H32(1),ex5(:),G0H16(1),m3h2x16(:,285),heltab2x32(:,:,453))
  call Hloop_A_Q(ntryL,G0H16(1),16,nMT,G1H16(133),n2h16(211))
  Gcoeff(:)%j = (-(c(14)*M(1,:)%j)+c(15)*M(5,:)%j) * den(72)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(460),h0tab(:,460),[16,1,14],[nMT,nMZ,nMT],3,1,wf8(:,115))
  call Hloop_AV_Q(ntryL,G0H32(1),ex5(:),G0H16(1),m3h2x16(:,286),heltab2x32(:,:,454))
  call Hloop_A_Q(ntryL,G0H16(1),16,nMT,G1H16(134),n2h16(212))
  Gcoeff(:)%j = (-(c(39)*M(1,:)%j)+c(40)*M(5,:)%j) * den(72)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(461),h0tab(:,461),[16,1,14],[nMB,nMW,nMB],3,1,wf8(:,115))
  call Hloop_AV_Q(ntryL,G0H32(1),ex5(:),G0H16(1),m3h2x16(:,287),heltab2x32(:,:,455))
  call Hloop_A_Q(ntryL,G0H16(1),16,nMB,G1H16(135),n2h16(213))
  Gcoeff(:)%j = (c(26)*M(2,:)%j-c(27)*M(6,:)%j) * den(72)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(462),h0tab(:,462),[16,1,14],[nMT,0,nMT],3,1,wf8(:,115))
  call Hloop_AV_Q(ntryL,G0H32(1),ex5(:),G0H16(1),m3h2x16(:,288),heltab2x32(:,:,456))
  call Hloop_A_Q(ntryL,G0H16(1),16,nMT,G1H16(136),n2h16(214))
  Gcoeff(:)%j = (c(3)*M(1,:)%j) * den(72)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(463),h0tab(:,463),[16,1,14],[0,nMT,0],3,1,wf8(:,115))
  call Hloop_UV_W(ntryL,G0H32(1),0,ex5(:),16,G1H16(137),m3h2x16(:,289),heltab2x32(:,:,457))
  Gcoeff(:)%j = (-(c(6)*M(1,:)%j)) * den(70)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(464),h0tab(:,464),[16,1,14],[0,nMT,0],3,1,wf8(:,117))
  call Hloop_UV_W(ntryL,G0H32(1),0,ex5(:),16,G1H16(138),m3h2x16(:,290),heltab2x32(:,:,458))
  Gcoeff(:)%j = (c(20)*M(2,:)%j-c(22)*M(6,:)%j) * den(72)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(465),h0tab(:,465),[16,1,14],[0,nMT,0],3,1,wf8(:,115))
  call Hloop_UV_W(ntryL,G0H32(1),0,ex5(:),16,G1H16(139),m3h2x16(:,291),heltab2x32(:,:,459))
  Gcoeff(:)%j = (c(55)*(-M(3,:)%j+M(5,:)%j)) * den(35)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(466),h0tab(:,466),[28,1,2],[nMT,nMH,nMT],3,1,wf8(:,89))
  call Hloop_AV_Q(ntryL,G0H32(1),wf8(:,89),G0H4(7),m3h8x4(:,9),heltab2x32(:,:,460))
  call Hloop_A_Q(ntryL,G0H4(7),28,nMT,G1H4(13),n2h4(166))
  Gcoeff(:)%j = (c(55)*(M(3,:)%j-M(5,:)%j)) * den(35)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(467),h0tab(:,467),[28,1,2],[nMT,nMZ,nMT],3,1,wf8(:,89))
  call Hloop_AV_Q(ntryL,G0H32(1),wf8(:,89),G0H4(7),m3h8x4(:,10),heltab2x32(:,:,461))
  call Hloop_A_Q(ntryL,G0H4(7),28,nMT,G1H4(14),n2h4(167))
  Gcoeff(:)%j = (c(42)*(M(3,:)%j-M(5,:)%j)) * den(35)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(468),h0tab(:,468),[28,1,2],[nMB,nMW,nMB],3,1,wf8(:,89))
  call Hloop_AV_Q(ntryL,G0H32(1),wf8(:,89),G0H4(7),m3h8x4(:,11),heltab2x32(:,:,462))
  call Hloop_A_Q(ntryL,G0H4(7),28,nMB,G1H4(17),n2h4(168))
  Gcoeff(:)%j = (c(4)*(M(3,:)%j-M(5,:)%j)) * den(35)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(469),h0tab(:,469),[28,1,2],[nMT,0,nMT],3,1,wf8(:,89))
  call Hloop_AV_Q(ntryL,G0H32(1),wf8(:,89),G0H4(7),m3h8x4(:,12),heltab2x32(:,:,463))
  call Hloop_A_Q(ntryL,G0H4(7),28,nMT,G1H4(18),n2h4(169))
  Gcoeff(:)%j = (c(5)*(M(3,:)%j-M(5,:)%j)) * den(35)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(470),h0tab(:,470),[28,1,2],[nMT,nMZ,nMT],3,1,wf8(:,89))
  call Hloop_AV_Q(ntryL,G0H32(1),wf8(:,89),G0H4(7),m3h8x4(:,13),heltab2x32(:,:,464))
  call Hloop_A_Q(ntryL,G0H4(7),28,nMT,G1H4(19),n2h4(170))
  Gcoeff(:)%j = (c(37)*(M(3,:)%j-M(5,:)%j)) * den(35)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(471),h0tab(:,471),[28,1,2],[nMB,nMW,nMB],3,1,wf8(:,89))
  call Hloop_AV_Q(ntryL,G0H32(1),wf8(:,89),G0H4(7),m3h8x4(:,14),heltab2x32(:,:,465))
  call Hloop_A_Q(ntryL,G0H4(7),28,nMB,G1H4(20),n2h4(171))
  Gcoeff(:)%j = (c(19)*(-M(4,:)%j+M(6,:)%j)) * den(35)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(472),h0tab(:,472),[28,1,2],[nMT,0,nMT],3,1,wf8(:,89))
  call Hloop_AV_Q(ntryL,G0H32(1),wf8(:,89),G0H4(7),m3h8x4(:,15),heltab2x32(:,:,466))
  call Hloop_A_Q(ntryL,G0H4(7),28,nMT,G1H4(24),n2h4(172))
  Gcoeff(:)%j = (c(35)*(-M(4,:)%j+M(6,:)%j)) * den(35)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(473),h0tab(:,473),[28,1,2],[0,nMT,0],3,1,wf8(:,89))
  call Hloop_UV_W(ntryL,G0H32(1),0,wf8(:,89),28,G1H4(25),m3h8x4(:,16),heltab2x32(:,:,467))
  Gcoeff(:)%j = (-(c(54)*M(1,:)%j)) * den(85)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(474),h0tab(:,474),[19,4,8],[nMB,0,nMB],3,1,wf8(:,18))
  call Hloop_AS_Q(ntryL,G0H32(1),wf8(:,18),G0H4(7),ngH,m3h8x4(:,17),heltab2x32(:,:,468))
  call Hloop_A_Q(ntryL,G0H4(7),19,nMB,G1H4(26),n2h4(173))
  Gcoeff(:)%j = (-(c(54)*M(1,:)%j)) * den(87)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(475),h0tab(:,475),[19,4,8],[nMB,0,nMB],3,1,wf8(:,19))
  call Hloop_AS_Q(ntryL,G0H32(1),wf8(:,19),G0H4(7),ngX,m3h8x4(:,18),heltab2x32(:,:,469))
  call Hloop_A_Q(ntryL,G0H4(7),19,nMB,G1H4(29),n2h4(174))
  Gcoeff(:)%j = (c(48)*M(1,:)%j-c(49)*M(5,:)%j) * den(74)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(476),h0tab(:,476),[19,4,8],[nMB,nMH,nMB],3,1,wf8(:,20))
  call Hloop_AV_Q(ntryL,G0H32(1),wf8(:,20),G0H4(7),m3h8x4(:,19),heltab2x32(:,:,470))
  call Hloop_A_Q(ntryL,G0H4(7),19,nMB,G1H4(3),n2h4(175))
  Gcoeff(:)%j = (-(c(48)*M(1,:)%j)+c(49)*M(5,:)%j) * den(74)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(477),h0tab(:,477),[19,4,8],[nMB,nMZ,nMB],3,1,wf8(:,20))
  call Hloop_AV_Q(ntryL,G0H32(1),wf8(:,20),G0H4(7),m3h8x4(:,20),heltab2x32(:,:,471))
  call Hloop_A_Q(ntryL,G0H4(7),19,nMB,G1H4(4),n2h4(176))
  Gcoeff(:)%j = (-(c(44)*M(1,:)%j)+c(45)*M(5,:)%j) * den(74)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(478),h0tab(:,478),[19,4,8],[nMT,nMW,nMT],3,1,wf8(:,20))
  call Hloop_AV_Q(ntryL,G0H32(1),wf8(:,20),G0H4(7),m3h8x4(:,21),heltab2x32(:,:,472))
  call Hloop_A_Q(ntryL,G0H4(7),19,nMT,G1H4(134),n2h4(177))
  Gcoeff(:)%j = (-(c(11)*M(1,:)%j)) * den(74)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(479),h0tab(:,479),[19,4,8],[nMB,0,nMB],3,1,wf8(:,20))
  call Hloop_AV_Q(ntryL,G0H32(1),wf8(:,20),G0H4(7),m3h8x4(:,22),heltab2x32(:,:,473))
  call Hloop_A_Q(ntryL,G0H4(7),19,nMB,G1H4(143),n2h4(178))
  Gcoeff(:)%j = (c(16)*M(1,:)%j) * den(87)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(480),h0tab(:,480),[19,4,8],[nMB,0,nMB],3,1,wf8(:,21))
  call Hloop_AZ_Q(ntryL,G0H32(1),wf8(:,21),G0H4(7),ngZd,m3h8x4(:,23),heltab2x32(:,:,474))
  call Hloop_A_Q(ntryL,G0H4(7),19,nMB,G1H4(72),n2h4(179))
  Gcoeff(:)%j = (-(c(7)*M(1,:)%j)+c(8)*M(5,:)%j) * den(74)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(481),h0tab(:,481),[19,4,8],[nMB,0,nMB],3,1,wf8(:,20))
  call Hloop_AV_Q(ntryL,G0H32(1),wf8(:,20),G0H4(7),m3h8x4(:,24),heltab2x32(:,:,475))
  call Hloop_A_Q(ntryL,G0H4(7),19,nMB,G1H4(70),n2h4(180))
  Gcoeff(:)%j = (-(c(14)*M(1,:)%j)+c(15)*M(5,:)%j) * den(74)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(482),h0tab(:,482),[19,4,8],[nMB,nMZ,nMB],3,1,wf8(:,20))
  call Hloop_AV_Q(ntryL,G0H32(1),wf8(:,20),G0H4(7),m3h8x4(:,25),heltab2x32(:,:,476))
  call Hloop_A_Q(ntryL,G0H4(7),19,nMB,G1H4(77),n2h4(181))
  Gcoeff(:)%j = (-(c(39)*M(1,:)%j)+c(40)*M(5,:)%j) * den(74)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(483),h0tab(:,483),[19,4,8],[nMT,nMW,nMT],3,1,wf8(:,20))
  call Hloop_AV_Q(ntryL,G0H32(1),wf8(:,20),G0H4(7),m3h8x4(:,26),heltab2x32(:,:,477))
  call Hloop_A_Q(ntryL,G0H4(7),19,nMT,G1H4(103),n2h4(182))
  Gcoeff(:)%j = (c(26)*M(2,:)%j-c(27)*M(6,:)%j) * den(74)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(484),h0tab(:,484),[19,4,8],[nMB,0,nMB],3,1,wf8(:,20))
  call Hloop_AV_Q(ntryL,G0H32(1),wf8(:,20),G0H4(7),m3h8x4(:,27),heltab2x32(:,:,478))
  call Hloop_A_Q(ntryL,G0H4(7),19,nMB,G1H4(112),n2h4(183))
  Gcoeff(:)%j = (c(20)*M(2,:)%j-c(22)*M(6,:)%j) * den(74)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(485),h0tab(:,485),[19,4,8],[0,nMB,0],3,1,wf8(:,20))
  call Hloop_UV_W(ntryL,G0H32(1),0,wf8(:,20),19,G1H4(113),m3h8x4(:,28),heltab2x32(:,:,479))
  Gcoeff(:)%j = (-(c(46)*M(5,:)%j)) * den(89)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(486),h0tab(:,486),[25,2,4],[nMT,0,nMB],3,1,wf8(:,10))
  call Hloop_QS_A(ntryL,G0H32(1),wf8(:,10),G0H4(7),ngPtb,m3h8x4(:,29),heltab2x32(:,:,480))
  call Hloop_Q_A(ntryL,G0H4(7),25,nMT,G1H4(88),n2h4(184))
  Gcoeff(:)%j = (-(c(41)*M(5,:)%j)) * den(89)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(487),h0tab(:,487),[25,2,4],[nMT,0,nMB],3,1,wf8(:,11))
  call Hloop_QW_A(ntryL,G0H32(1),wf8(:,11),G0H4(7),m3h8x4(:,30),heltab2x32(:,:,481))
  call Hloop_Q_A(ntryL,G0H4(7),25,nMT,G1H4(85),n2h4(185))
  Gcoeff(:)%j = (-(c(54)*M(1,:)%j)) * den(90)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(488),h0tab(:,488),[19,4,8],[nMB,0,nMB],3,1,wf8(:,22))
  call Hloop_AS_Q(ntryL,G0H32(1),wf8(:,22),G0H4(7),ngH,m3h8x4(:,31),heltab2x32(:,:,482))
  call Hloop_A_Q(ntryL,G0H4(7),19,nMB,G1H4(94),n2h4(186))
  Gcoeff(:)%j = (-(c(54)*M(1,:)%j)) * den(91)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(489),h0tab(:,489),[19,4,8],[nMB,0,nMB],3,1,wf8(:,23))
  call Hloop_AS_Q(ntryL,G0H32(1),wf8(:,23),G0H4(7),ngX,m3h8x4(:,32),heltab2x32(:,:,483))
  call Hloop_A_Q(ntryL,G0H4(7),19,nMB,G1H4(106),n2h4(187))
  Gcoeff(:)%j = (c(48)*M(1,:)%j-c(49)*M(3,:)%j) * den(82)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(490),h0tab(:,490),[19,4,8],[nMB,nMH,nMB],3,1,wf8(:,24))
  call Hloop_AV_Q(ntryL,G0H32(1),wf8(:,24),G0H4(7),m3h8x4(:,33),heltab2x32(:,:,484))
  call Hloop_A_Q(ntryL,G0H4(7),19,nMB,G1H4(41),n2h4(188))
  Gcoeff(:)%j = (-(c(48)*M(1,:)%j)+c(49)*M(3,:)%j) * den(82)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(491),h0tab(:,491),[19,4,8],[nMB,nMZ,nMB],3,1,wf8(:,24))
  call Hloop_AV_Q(ntryL,G0H32(1),wf8(:,24),G0H4(7),m3h8x4(:,34),heltab2x32(:,:,485))
  call Hloop_A_Q(ntryL,G0H4(7),19,nMB,G1H4(42),n2h4(189))
  Gcoeff(:)%j = (-(c(44)*M(1,:)%j)+c(45)*M(3,:)%j) * den(82)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(492),h0tab(:,492),[19,4,8],[nMT,nMW,nMT],3,1,wf8(:,24))
  call Hloop_AV_Q(ntryL,G0H32(1),wf8(:,24),G0H4(7),m3h8x4(:,35),heltab2x32(:,:,486))
  call Hloop_A_Q(ntryL,G0H4(7),19,nMT,G1H4(54),n2h4(190))
  Gcoeff(:)%j = (-(c(11)*M(1,:)%j)) * den(82)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(493),h0tab(:,493),[19,4,8],[nMB,0,nMB],3,1,wf8(:,24))
  call Hloop_AV_Q(ntryL,G0H32(1),wf8(:,24),G0H4(7),m3h8x4(:,36),heltab2x32(:,:,487))
  call Hloop_A_Q(ntryL,G0H4(7),19,nMB,G1H4(55),n2h4(191))
  Gcoeff(:)%j = (c(16)*M(1,:)%j) * den(91)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(494),h0tab(:,494),[19,4,8],[nMB,0,nMB],3,1,wf8(:,25))
  call Hloop_AZ_Q(ntryL,G0H32(1),wf8(:,25),G0H4(7),ngZd,m3h8x4(:,37),heltab2x32(:,:,488))
  call Hloop_A_Q(ntryL,G0H4(7),19,nMB,G1H4(60),n2h4(192))
  Gcoeff(:)%j = (-(c(7)*M(1,:)%j)+c(8)*M(3,:)%j) * den(82)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(495),h0tab(:,495),[19,4,8],[nMB,0,nMB],3,1,wf8(:,24))
  call Hloop_AV_Q(ntryL,G0H32(1),wf8(:,24),G0H4(7),m3h8x4(:,38),heltab2x32(:,:,489))
  call Hloop_A_Q(ntryL,G0H4(7),19,nMB,G1H4(67),n2h4(193))
  Gcoeff(:)%j = (-(c(14)*M(1,:)%j)+c(15)*M(3,:)%j) * den(82)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(496),h0tab(:,496),[19,4,8],[nMB,nMZ,nMB],3,1,wf8(:,24))
  call Hloop_AV_Q(ntryL,G0H32(1),wf8(:,24),G0H4(7),m3h8x4(:,39),heltab2x32(:,:,490))
  call Hloop_A_Q(ntryL,G0H4(7),19,nMB,G1H4(123),n2h4(194))
  Gcoeff(:)%j = (-(c(39)*M(1,:)%j)+c(40)*M(3,:)%j) * den(82)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(497),h0tab(:,497),[19,4,8],[nMT,nMW,nMT],3,1,wf8(:,24))
  call Hloop_AV_Q(ntryL,G0H32(1),wf8(:,24),G0H4(7),m3h8x4(:,40),heltab2x32(:,:,491))
  call Hloop_A_Q(ntryL,G0H4(7),19,nMT,G1H4(124),n2h4(195))
  Gcoeff(:)%j = (c(26)*M(2,:)%j-c(27)*M(4,:)%j) * den(82)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(498),h0tab(:,498),[19,4,8],[nMB,0,nMB],3,1,wf8(:,24))
  call Hloop_AV_Q(ntryL,G0H32(1),wf8(:,24),G0H4(7),m3h8x4(:,41),heltab2x32(:,:,492))
  call Hloop_A_Q(ntryL,G0H4(7),19,nMB,G1H4(135),n2h4(196))
  Gcoeff(:)%j = (c(20)*M(2,:)%j-c(22)*M(4,:)%j) * den(82)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(499),h0tab(:,499),[19,4,8],[0,nMB,0],3,1,wf8(:,24))
  call Hloop_UV_W(ntryL,G0H32(1),0,wf8(:,24),19,G1H4(136),m3h8x4(:,42),heltab2x32(:,:,493))
  Gcoeff(:)%j = (-(c(46)*M(3,:)%j)) * den(93)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(500),h0tab(:,500),[22,1,8],[nMT,0,nMB],3,1,wf8(:,126))
  call Hloop_AS_Q(ntryL,G0H32(1),wf8(:,126),G0H4(7),ngPbt,m3h8x4(:,43),heltab2x32(:,:,494))
  call Hloop_A_Q(ntryL,G0H4(7),22,nMT,G1H4(141),n2h4(197))
  Gcoeff(:)%j = (-(c(41)*M(3,:)%j)) * den(93)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(501),h0tab(:,501),[22,1,8],[nMT,0,nMB],3,1,wf8(:,127))
  call Hloop_AW_Q(ntryL,G0H32(1),wf8(:,127),G0H4(7),m3h8x4(:,44),heltab2x32(:,:,495))
  call Hloop_A_Q(ntryL,G0H4(7),22,nMT,G1H4(10),n2h4(198))
  Gcoeff(:)%j = (-(c(46)*M(3,:)%j)) * den(94)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(502),h0tab(:,502),[22,1,8],[nMT,0,nMB],3,1,wf8(:,128))
  call Hloop_AS_Q(ntryL,G0H32(1),wf8(:,128),G0H4(7),ngPbt,m3h8x4(:,45),heltab2x32(:,:,496))
  call Hloop_A_Q(ntryL,G0H4(7),22,nMT,G1H4(15),n2h4(199))
  Gcoeff(:)%j = (-(c(41)*M(3,:)%j)) * den(94)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(503),h0tab(:,503),[22,1,8],[nMT,0,nMB],3,1,wf8(:,129))
  call Hloop_AW_Q(ntryL,G0H32(1),wf8(:,129),G0H4(7),m3h8x4(:,46),heltab2x32(:,:,497))
  call Hloop_A_Q(ntryL,G0H4(7),22,nMT,G1H4(76),n2h4(200))
  Gcoeff(:)%j = (-(c(54)*M(7,:)%j)) * den(96)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(504),h0tab(:,504),[28,1,2],[nMT,0,nMT],3,1,wf8(:,130))
  call Hloop_AS_Q(ntryL,G0H32(1),wf8(:,130),G0H4(7),ngH,m3h8x4(:,47),heltab2x32(:,:,498))
  call Hloop_A_Q(ntryL,G0H4(7),28,nMT,G1H4(22),n2h4(201))
  Gcoeff(:)%j = (-(c(54)*M(7,:)%j)) * den(98)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(505),h0tab(:,505),[28,1,2],[nMT,0,nMT],3,1,wf8(:,131))
  call Hloop_AS_Q(ntryL,G0H32(1),wf8(:,131),G0H4(7),ngX,m3h8x4(:,48),heltab2x32(:,:,499))
  call Hloop_A_Q(ntryL,G0H4(7),28,nMT,G1H4(27),n2h4(202))
  Gcoeff(:)%j = (-(c(57)*M(3,:)%j)+c(56)*M(7,:)%j) * den(40)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(506),h0tab(:,506),[28,1,2],[nMT,nMH,nMT],3,1,wf8(:,90))
  call Hloop_AV_Q(ntryL,G0H32(1),wf8(:,90),G0H4(7),m3h8x4(:,49),heltab2x32(:,:,500))
  call Hloop_A_Q(ntryL,G0H4(7),28,nMT,G1H4(28),n2h4(203))
  Gcoeff(:)%j = (c(57)*M(3,:)%j-c(56)*M(7,:)%j) * den(40)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(507),h0tab(:,507),[28,1,2],[nMT,nMZ,nMT],3,1,wf8(:,90))
  call Hloop_AV_Q(ntryL,G0H32(1),wf8(:,90),G0H4(7),m3h8x4(:,50),heltab2x32(:,:,501))
  call Hloop_A_Q(ntryL,G0H4(7),28,nMT,G1H4(39),n2h4(204))
  Gcoeff(:)%j = (c(45)*M(3,:)%j-c(44)*M(7,:)%j) * den(40)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(508),h0tab(:,508),[28,1,2],[nMB,nMW,nMB],3,1,wf8(:,90))
  call Hloop_AV_Q(ntryL,G0H32(1),wf8(:,90),G0H4(7),m3h8x4(:,51),heltab2x32(:,:,502))
  call Hloop_A_Q(ntryL,G0H4(7),28,nMB,G1H4(40),n2h4(205))
  Gcoeff(:)%j = (-(c(11)*M(7,:)%j)) * den(40)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(509),h0tab(:,509),[28,1,2],[nMT,0,nMT],3,1,wf8(:,90))
  call Hloop_AV_Q(ntryL,G0H32(1),wf8(:,90),G0H4(7),m3h8x4(:,52),heltab2x32(:,:,503))
  call Hloop_A_Q(ntryL,G0H4(7),28,nMT,G1H4(45),n2h4(206))
  Gcoeff(:)%j = (c(16)*M(7,:)%j) * den(98)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(510),h0tab(:,510),[28,1,2],[nMT,0,nMT],3,1,wf8(:,132))
  call Hloop_AZ_Q(ntryL,G0H32(1),wf8(:,132),G0H4(7),ngZu,m3h8x4(:,53),heltab2x32(:,:,504))
  call Hloop_A_Q(ntryL,G0H4(7),28,nMT,G1H4(100),n2h4(207))
  Gcoeff(:)%j = (c(13)*M(3,:)%j-c(12)*M(7,:)%j) * den(40)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(511),h0tab(:,511),[28,1,2],[nMT,0,nMT],3,1,wf8(:,90))
  call Hloop_AV_Q(ntryL,G0H32(1),wf8(:,90),G0H4(7),m3h8x4(:,54),heltab2x32(:,:,505))
  call Hloop_A_Q(ntryL,G0H4(7),28,nMT,G1H4(52),n2h4(208))
  Gcoeff(:)%j = (c(15)*M(3,:)%j-c(14)*M(7,:)%j) * den(40)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(512),h0tab(:,512),[28,1,2],[nMT,nMZ,nMT],3,1,wf8(:,90))
  call Hloop_AV_Q(ntryL,G0H32(1),wf8(:,90),G0H4(7),m3h8x4(:,55),heltab2x32(:,:,506))
  call Hloop_A_Q(ntryL,G0H4(7),28,nMT,G1H4(57),n2h4(209))
  Gcoeff(:)%j = (c(40)*M(3,:)%j-c(39)*M(7,:)%j) * den(40)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(513),h0tab(:,513),[28,1,2],[nMB,nMW,nMB],3,1,wf8(:,90))
  call Hloop_AV_Q(ntryL,G0H32(1),wf8(:,90),G0H4(7),m3h8x4(:,56),heltab2x32(:,:,507))
  call Hloop_A_Q(ntryL,G0H4(7),28,nMB,G1H4(69),n2h4(210))
  Gcoeff(:)%j = (-(c(27)*M(4,:)%j)+c(26)*M(8,:)%j) * den(40)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(514),h0tab(:,514),[28,1,2],[nMT,0,nMT],3,1,wf8(:,90))
  call Hloop_AV_Q(ntryL,G0H32(1),wf8(:,90),G0H4(7),m3h8x4(:,57),heltab2x32(:,:,508))
  call Hloop_A_Q(ntryL,G0H4(7),28,nMT,G1H4(75),n2h4(211))
  Gcoeff(:)%j = (-(c(22)*M(4,:)%j)+c(20)*M(8,:)%j) * den(40)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(515),h0tab(:,515),[28,1,2],[0,nMT,0],3,1,wf8(:,90))
  call Hloop_UV_W(ntryL,G0H32(1),0,wf8(:,90),28,G1H4(81),m3h8x4(:,58),heltab2x32(:,:,509))
  Gcoeff(:)%j = (-(c(46)*M(5,:)%j)) * den(99)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(516),h0tab(:,516),[25,2,4],[nMT,0,nMB],3,1,wf8(:,133))
  call Hloop_QS_A(ntryL,G0H32(1),wf8(:,133),G0H4(7),ngPtb,m3h8x4(:,59),heltab2x32(:,:,510))
  call Hloop_Q_A(ntryL,G0H4(7),25,nMT,G1H4(36),n2h4(212))
  Gcoeff(:)%j = (-(c(41)*M(5,:)%j)) * den(99)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(517),h0tab(:,517),[25,2,4],[nMT,0,nMB],3,1,wf8(:,134))
  call Hloop_QW_A(ntryL,G0H32(1),wf8(:,134),G0H4(7),m3h8x4(:,60),heltab2x32(:,:,511))
  call Hloop_Q_A(ntryL,G0H4(7),25,nMT,G1H4(48),n2h4(213))
  Gcoeff(:)%j = (-(c(54)*M(7,:)%j)) * den(100)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(518),h0tab(:,518),[28,1,2],[nMT,0,nMT],3,1,wf8(:,135))
  call Hloop_AS_Q(ntryL,G0H32(1),wf8(:,135),G0H4(7),ngH,m3h8x4(:,61),heltab2x32(:,:,512))
  call Hloop_A_Q(ntryL,G0H4(7),28,nMT,G1H4(38),n2h4(214))
  Gcoeff(:)%j = (-(c(54)*M(7,:)%j)) * den(101)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(519),h0tab(:,519),[28,1,2],[nMT,0,nMT],3,1,wf8(:,136))
  call Hloop_AS_Q(ntryL,G0H32(1),wf8(:,136),G0H4(7),ngX,m3h8x4(:,62),heltab2x32(:,:,513))
  call Hloop_A_Q(ntryL,G0H4(7),28,nMT,G1H4(47),n2h4(215))
  Gcoeff(:)%j = (-(c(57)*M(5,:)%j)+c(56)*M(7,:)%j) * den(49)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(520),h0tab(:,520),[28,1,2],[nMT,nMH,nMT],3,1,wf8(:,95))
  call Hloop_AV_Q(ntryL,G0H32(1),wf8(:,95),G0H4(7),m3h8x4(:,63),heltab2x32(:,:,514))
  call Hloop_A_Q(ntryL,G0H4(7),28,nMT,G1H4(53),n2h4(216))
  Gcoeff(:)%j = (c(57)*M(5,:)%j-c(56)*M(7,:)%j) * den(49)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(521),h0tab(:,521),[28,1,2],[nMT,nMZ,nMT],3,1,wf8(:,95))
  call Hloop_AV_Q(ntryL,G0H32(1),wf8(:,95),G0H4(7),m3h8x4(:,64),heltab2x32(:,:,515))
  call Hloop_A_Q(ntryL,G0H4(7),28,nMT,G1H4(56),n2h4(217))
  Gcoeff(:)%j = (c(45)*M(5,:)%j-c(44)*M(7,:)%j) * den(49)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(522),h0tab(:,522),[28,1,2],[nMB,nMW,nMB],3,1,wf8(:,95))
  call Hloop_AV_Q(ntryL,G0H32(1),wf8(:,95),G0H4(7),m3h8x4(:,65),heltab2x32(:,:,516))
  call Hloop_A_Q(ntryL,G0H4(7),28,nMB,G1H4(66),n2h4(218))
  Gcoeff(:)%j = (-(c(11)*M(7,:)%j)) * den(49)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(523),h0tab(:,523),[28,1,2],[nMT,0,nMT],3,1,wf8(:,95))
  call Hloop_AV_Q(ntryL,G0H32(1),wf8(:,95),G0H4(7),m3h8x4(:,66),heltab2x32(:,:,517))
  call Hloop_A_Q(ntryL,G0H4(7),28,nMT,G1H4(68),n2h4(219))
  Gcoeff(:)%j = (c(16)*M(7,:)%j) * den(101)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(524),h0tab(:,524),[28,1,2],[nMT,0,nMT],3,1,wf8(:,137))
  call Hloop_AZ_Q(ntryL,G0H32(1),wf8(:,137),G0H4(7),ngZu,m3h8x4(:,67),heltab2x32(:,:,518))
  call Hloop_A_Q(ntryL,G0H4(7),28,nMT,G1H4(73),n2h4(220))
  Gcoeff(:)%j = (c(13)*M(5,:)%j-c(12)*M(7,:)%j) * den(49)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(525),h0tab(:,525),[28,1,2],[nMT,0,nMT],3,1,wf8(:,95))
  call Hloop_AV_Q(ntryL,G0H32(1),wf8(:,95),G0H4(7),m3h8x4(:,68),heltab2x32(:,:,519))
  call Hloop_A_Q(ntryL,G0H4(7),28,nMT,G1H4(91),n2h4(221))
  Gcoeff(:)%j = (c(15)*M(5,:)%j-c(14)*M(7,:)%j) * den(49)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(526),h0tab(:,526),[28,1,2],[nMT,nMZ,nMT],3,1,wf8(:,95))
  call Hloop_AV_Q(ntryL,G0H32(1),wf8(:,95),G0H4(7),m3h8x4(:,69),heltab2x32(:,:,520))
  call Hloop_A_Q(ntryL,G0H4(7),28,nMT,G1H4(83),n2h4(222))
  Gcoeff(:)%j = (c(40)*M(5,:)%j-c(39)*M(7,:)%j) * den(49)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(527),h0tab(:,527),[28,1,2],[nMB,nMW,nMB],3,1,wf8(:,95))
  call Hloop_AV_Q(ntryL,G0H32(1),wf8(:,95),G0H4(7),m3h8x4(:,70),heltab2x32(:,:,521))
  call Hloop_A_Q(ntryL,G0H4(7),28,nMB,G1H4(86),n2h4(223))
  Gcoeff(:)%j = (-(c(27)*M(6,:)%j)+c(26)*M(8,:)%j) * den(49)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(528),h0tab(:,528),[28,1,2],[nMT,0,nMT],3,1,wf8(:,95))
  call Hloop_AV_Q(ntryL,G0H32(1),wf8(:,95),G0H4(7),m3h8x4(:,71),heltab2x32(:,:,522))
  call Hloop_A_Q(ntryL,G0H4(7),28,nMT,G1H4(96),n2h4(224))
  Gcoeff(:)%j = (-(c(22)*M(6,:)%j)+c(20)*M(8,:)%j) * den(49)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(529),h0tab(:,529),[28,1,2],[0,nMT,0],3,1,wf8(:,95))
  call Hloop_UV_W(ntryL,G0H32(1),0,wf8(:,95),28,G1H4(97),m3h8x4(:,72),heltab2x32(:,:,523))
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(136),[G1H4(113),G1H4(12),G1H4(23),G0H4(3),G0H4(2) &
    ,G0H4(1)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H8(60),[G1H8(1)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H8(61),[G1H8(7)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H8(70),[G1H8(67),G1H8(65),G1H8(17)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H8(66),[G1H8(20)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H8(16),[G1H8(25)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H8(18),[G1H8(32)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(97),[G1H4(81),G1H4(25),G0H4(6),G0H4(5),G0H4(4)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H16(33),[G1H16(29),G1H16(14),G1H16(9),G1H16(12),G1H16(56)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H16(30),[G1H16(13),G1H16(68)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H16(36),[G1H16(31),G1H16(16),G1H16(8),G1H16(19),G1H16(6)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H16(34),[G1H16(11),G1H16(5)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H16(35),[G1H16(15),G1H16(20)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H16(37),[G1H16(17),G1H16(75)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H8(15),[G1H8(10),G1H8(6)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H16(57),[G1H16(54),G1H16(52)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H16(62),[G1H16(59)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H16(88),[G1H16(85),G1H16(83)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H16(91),[G1H16(89)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(41),[G1H4(3),G1H4(144)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(42),[G1H4(4),G1H4(1)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(54),[G1H4(134),G1H4(2)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(135),[G1H4(67),G1H4(60),G1H4(55),G1H4(106),G1H4(94) &
    ,G1H4(112),G1H4(70),G1H4(72),G1H4(143),G1H4(29),G1H4(26),G1H4(11),G1H4(5)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(123),[G1H4(77),G1H4(6)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(124),[G1H4(103),G1H4(8)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G0H8(38),[G0H8(35),G0H8(33)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G0H8(18),[G0H8(50),G0H8(47)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H16(120),[G1H16(117),G1H16(115)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H16(123),[G1H16(121)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H16(136),[G1H16(133),G1H16(131)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H16(139),[G1H16(137)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(53),[G1H4(28),G1H4(13)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(56),[G1H4(39),G1H4(14)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(66),[G1H4(40),G1H4(17)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(96),[G1H4(91),G1H4(73),G1H4(68),G1H4(47),G1H4(38) &
    ,G1H4(75),G1H4(52),G1H4(100),G1H4(45),G1H4(27),G1H4(22),G1H4(24),G1H4(18)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(83),[G1H4(57),G1H4(19)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(86),[G1H4(69),G1H4(20)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(48),[G1H4(36),G1H4(85),G1H4(88)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(76),[G1H4(15),G1H4(10),G1H4(141)])
  call Hloop_VQ_A(ntryL,G1H4(136),ex3(:),G1H2(144),m3h2x2(:,250),heltab2x4(:,:,316))
  call Hloop_Q_A(ntryL,G1H2(144),23,nMB,G2H2(92),n2h2(175))
  call Hloop_VA_Q(ntryL,G1H4(30),ex4(:),G1H2(69),m3h2x2(:,251),heltab2x4(:,:,317))
  call Hloop_A_Q(ntryL,G1H2(69),27,nMB,G2H2(47),n2h2(176))
  call Hloop_QS_A(ntryL,G1H8(60),wf4(:,3),G1H2(145),ngH,m3h4x2(:,39),heltab2x8(:,:,233))
  call Hloop_Q_A(ntryL,G1H2(145),23,nMB,G2H2(44),n2h2(177))
  call Hloop_QS_A(ntryL,G1H8(61),wf4(:,6),G1H2(87),ngX,m3h4x2(:,40),heltab2x8(:,:,234))
  call Hloop_Q_A(ntryL,G1H2(87),23,nMB,G2H2(41),n2h2(178))
  call Hloop_QV_A(ntryL,G1H8(70),wf4(:,1),G1H2(152),m3h4x2(:,41),heltab2x8(:,:,235))
  call Hloop_Q_A(ntryL,G1H2(152),23,nMB,G2H2(38),n2h2(179))
  call Hloop_QZ_A(ntryL,G1H8(66),wf4(:,7),G1H2(93),ngZd,m3h4x2(:,42),heltab2x8(:,:,236))
  call Hloop_Q_A(ntryL,G1H2(93),23,nMB,G2H2(112),n2h2(180))
  call Hloop_QS_A(ntryL,G1H8(16),wf4(:,11),G1H2(156),ngPbt,m3h4x2(:,43),heltab2x8(:,:,237))
  call Hloop_Q_A(ntryL,G1H2(156),23,nMB,G2H2(109),n2h2(181))
  call Hloop_QW_A(ntryL,G1H8(18),wf4(:,13),G1H2(193),m3h4x2(:,44),heltab2x8(:,:,238))
  call Hloop_Q_A(ntryL,G1H2(193),23,nMB,G2H2(102),n2h2(182))
  call Hloop_AS_Q(ntryL,G1H8(38),wf4(:,14),G1H2(194),ngPtb,m3h4x2(:,45),heltab2x8(:,:,239))
  call Hloop_A_Q(ntryL,G1H2(194),27,nMB,G2H2(53),n2h2(183))
  call Hloop_AW_Q(ntryL,G1H8(44),wf4(:,17),G1H2(200),m3h4x2(:,46),heltab2x8(:,:,240))
  call Hloop_A_Q(ntryL,G1H2(200),27,nMB,G2H2(50),n2h2(184))
  call Hloop_QS_A(ntryL,G1H8(50),wf4(:,18),G1H2(204),ngH,m3h4x2(:,47),heltab2x8(:,:,241))
  call Hloop_Q_A(ntryL,G1H2(204),29,nMT,G2H2(124),n2h2(185))
  call Hloop_QS_A(ntryL,G1H8(36),wf4(:,19),G1H2(39),ngX,m3h4x2(:,48),heltab2x8(:,:,242))
  call Hloop_Q_A(ntryL,G1H2(39),29,nMT,G2H2(65),n2h2(186))
  call Hloop_QV_A(ntryL,G1H8(5),wf4(:,2),G1H2(163),m3h4x2(:,49),heltab2x8(:,:,243))
  call Hloop_Q_A(ntryL,G1H2(163),29,nMT,G2H2(62),n2h2(187))
  call Hloop_QZ_A(ntryL,G1H8(57),wf4(:,20),G1H2(45),ngZu,m3h4x2(:,50),heltab2x8(:,:,244))
  call Hloop_Q_A(ntryL,G1H2(45),29,nMT,G2H2(59),n2h2(188))
  call Hloop_VQ_A(ntryL,G1H4(97),ex1(:),G1H2(164),m3h2x2(:,252),heltab2x4(:,:,318))
  call Hloop_Q_A(ntryL,G1H2(164),29,nMT,G2H2(56),n2h2(189))
  call Hloop_AS_Q(ntryL,G1H16(71),wf4(:,3),G1H4(98),ngH,m3h4x4(:,23),heltab2x16(:,:,131))
  call Hloop_A_Q(ntryL,G1H4(98),19,nMT,G2H4(45),n2h4(225))
  call Hloop_QS_A(ntryL,G1H16(72),wf4(:,3),G1H4(104),ngH,m3h4x4(:,24),heltab2x16(:,:,132))
  call Hloop_Q_A(ntryL,G1H4(104),19,nMT,G2H4(50),n2h4(226))
  call Hloop_AS_Q(ntryL,G1H16(73),wf4(:,3),G1H4(107),ngH,m3h4x4(:,25),heltab2x16(:,:,133))
  call Hloop_A_Q(ntryL,G1H4(107),19,nMB,G2H4(48),n2h4(227))
  call Hloop_QS_A(ntryL,G1H16(78),wf4(:,3),G1H4(108),ngH,m3h4x4(:,26),heltab2x16(:,:,134))
  call Hloop_Q_A(ntryL,G1H4(108),19,nMB,G2H4(49),n2h4(228))
  call Hloop_AS_Q(ntryL,G1H16(76),wf4(:,6),G1H4(121),ngX,m3h4x4(:,27),heltab2x16(:,:,135))
  call Hloop_A_Q(ntryL,G1H4(121),19,nMT,G2H4(51),n2h4(229))
  call Hloop_QS_A(ntryL,G1H16(77),wf4(:,6),G1H4(116),ngX,m3h4x4(:,28),heltab2x16(:,:,136))
  call Hloop_Q_A(ntryL,G1H4(116),19,nMT,G2H4(56),n2h4(230))
  call Hloop_AS_Q(ntryL,G1H16(79),wf4(:,6),G1H4(119),ngX,m3h4x4(:,29),heltab2x16(:,:,137))
  call Hloop_A_Q(ntryL,G1H4(119),19,nMB,G2H4(53),n2h4(231))
  call Hloop_QS_A(ntryL,G1H16(80),wf4(:,6),G1H4(128),ngX,m3h4x4(:,30),heltab2x16(:,:,138))
  call Hloop_Q_A(ntryL,G1H4(128),19,nMB,G2H4(54),n2h4(232))
  call Hloop_AV_Q(ntryL,G1H16(46),wf4(:,1),G1H4(126),m3h4x4(:,31),heltab2x16(:,:,139))
  call Hloop_A_Q(ntryL,G1H4(126),19,nMT,G2H4(55),n2h4(233))
  call Hloop_QV_A(ntryL,G1H16(32),wf4(:,1),G1H4(127),m3h4x4(:,32),heltab2x16(:,:,140))
  call Hloop_Q_A(ntryL,G1H4(127),19,nMT,G2H4(57),n2h4(234))
  call Hloop_AV_Q(ntryL,G1H16(10),wf4(:,1),G1H4(133),m3h4x4(:,33),heltab2x16(:,:,141))
  call Hloop_A_Q(ntryL,G1H4(133),19,nMB,G2H4(58),n2h4(235))
  call Hloop_QV_A(ntryL,G1H16(7),wf4(:,1),G1H4(139),m3h4x4(:,34),heltab2x16(:,:,142))
  call Hloop_Q_A(ntryL,G1H4(139),19,nMB,G2H4(59),n2h4(236))
  call Hloop_AV_Q(ntryL,G1H16(23),wf4(:,1),G1H4(137),m3h4x4(:,35),heltab2x16(:,:,143))
  call Hloop_A_Q(ntryL,G1H4(137),19,nMT,G2H4(60),n2h4(237))
  call Hloop_QV_A(ntryL,G1H16(45),wf4(:,1),G1H4(7),m3h4x4(:,36),heltab2x16(:,:,144))
  call Hloop_Q_A(ntryL,G1H4(7),19,nMT,G2H4(65),n2h4(238))
  call Hloop_AV_Q(ntryL,G1H16(42),wf4(:,1),G1H4(113),m3h4x4(:,37),heltab2x16(:,:,145))
  call Hloop_A_Q(ntryL,G1H4(113),19,nMB,G2H4(62),n2h4(239))
  call Hloop_QV_A(ntryL,G1H16(58),wf4(:,1),G1H4(12),m3h4x4(:,38),heltab2x16(:,:,146))
  call Hloop_Q_A(ntryL,G1H4(12),19,nMB,G2H4(63),n2h4(240))
  call Hloop_AV_Q(ntryL,G1H16(33),wf4(:,1),G1H4(23),m3h4x4(:,39),heltab2x16(:,:,147))
  call Hloop_A_Q(ntryL,G1H4(23),19,0,G2H4(64),n2h4(241))
  call Hloop_AV_Q(ntryL,G1H16(30),wf4(:,1),G1H4(81),m3h4x4(:,40),heltab2x16(:,:,148))
  call Hloop_A_Q(ntryL,G1H4(81),19,nMT,G2H4(66),n2h4(242))
  call Hloop_QV_A(ntryL,G1H16(36),wf4(:,1),G1H4(25),m3h4x4(:,41),heltab2x16(:,:,149))
  call Hloop_Q_A(ntryL,G1H4(25),19,0,G2H4(67),n2h4(243))
  call Hloop_QV_A(ntryL,G1H16(34),wf4(:,1),G1H4(3),m3h4x4(:,42),heltab2x16(:,:,150))
  call Hloop_Q_A(ntryL,G1H4(3),19,nMT,G2H4(68),n2h4(244))
  call Hloop_AV_Q(ntryL,G1H16(35),wf4(:,1),G1H4(144),m3h4x4(:,43),heltab2x16(:,:,151))
  call Hloop_A_Q(ntryL,G1H4(144),19,nMB,G2H4(47),n2h4(245))
  call Hloop_QV_A(ntryL,G1H16(37),wf4(:,1),G1H4(4),m3h4x4(:,44),heltab2x16(:,:,152))
  call Hloop_Q_A(ntryL,G1H4(4),19,nMB,G2H4(15),n2h4(246))
  call Hloop_AZ_Q(ntryL,G1H16(41),wf4(:,7),G1H4(1),ngZu,m3h4x4(:,45),heltab2x16(:,:,153))
  call Hloop_A_Q(ntryL,G1H4(1),19,0,G2H4(2),n2h4(247))
  call Hloop_AZ_Q(ntryL,G1H16(64),wf4(:,7),G1H4(134),ngZu,m3h4x4(:,46),heltab2x16(:,:,154))
  call Hloop_A_Q(ntryL,G1H4(134),19,nMT,G2H4(9),n2h4(248))
  call Hloop_QZ_A(ntryL,G1H16(63),wf4(:,7),G1H4(2),ngZu,m3h4x4(:,47),heltab2x16(:,:,155))
  call Hloop_Q_A(ntryL,G1H4(2),19,0,G2H4(4),n2h4(249))
  call Hloop_QZ_A(ntryL,G1H16(74),wf4(:,7),G1H4(67),ngZu,m3h4x4(:,48),heltab2x16(:,:,156))
  call Hloop_Q_A(ntryL,G1H4(67),19,nMT,G2H4(3),n2h4(250))
  call Hloop_AZ_Q(ntryL,G1H16(1),wf4(:,7),G1H4(60),ngZd,m3h4x4(:,49),heltab2x16(:,:,157))
  call Hloop_A_Q(ntryL,G1H4(60),19,0,G2H4(14),n2h4(251))
  call Hloop_AZ_Q(ntryL,G1H16(2),wf4(:,7),G1H4(55),ngZd,m3h4x4(:,50),heltab2x16(:,:,158))
  call Hloop_A_Q(ntryL,G1H4(55),19,nMB,G2H4(13),n2h4(252))
  call Hloop_QZ_A(ntryL,G1H16(3),wf4(:,7),G1H4(106),ngZd,m3h4x4(:,51),heltab2x16(:,:,159))
  call Hloop_Q_A(ntryL,G1H4(106),19,0,G2H4(6),n2h4(253))
  call Hloop_QZ_A(ntryL,G1H16(4),wf4(:,7),G1H4(94),ngZd,m3h4x4(:,52),heltab2x16(:,:,160))
  call Hloop_Q_A(ntryL,G1H4(94),19,nMB,G2H4(52),n2h4(254))
  call Hloop_AV_Q(ntryL,G1H16(18),wf4(:,1),G1H4(112),m3h4x4(:,53),heltab2x16(:,:,161))
  call Hloop_A_Q(ntryL,G1H4(112),19,0,G2H4(21),n2h4(255))
  call Hloop_AV_Q(ntryL,G1H16(22),wf4(:,1),G1H4(70),m3h4x4(:,54),heltab2x16(:,:,162))
  call Hloop_A_Q(ntryL,G1H4(70),19,nMT,G2H4(29),n2h4(256))
  call Hloop_QV_A(ntryL,G1H16(21),wf4(:,1),G1H4(72),m3h4x4(:,55),heltab2x16(:,:,163))
  call Hloop_Q_A(ntryL,G1H4(72),19,0,G2H4(44),n2h4(257))
  call Hloop_QV_A(ntryL,G1H16(24),wf4(:,1),G1H4(143),m3h4x4(:,56),heltab2x16(:,:,164))
  call Hloop_Q_A(ntryL,G1H4(143),19,nMT,G2H4(61),n2h4(258))
  call Hloop_AV_Q(ntryL,G1H16(25),wf4(:,1),G1H4(29),m3h4x4(:,57),heltab2x16(:,:,165))
  call Hloop_A_Q(ntryL,G1H4(29),19,0,G2H4(1),n2h4(259))
  call Hloop_AV_Q(ntryL,G1H16(26),wf4(:,1),G1H4(26),m3h4x4(:,58),heltab2x16(:,:,166))
  call Hloop_A_Q(ntryL,G1H4(26),19,nMB,G2H4(10),n2h4(260))
  call Hloop_QV_A(ntryL,G1H16(27),wf4(:,1),G1H4(11),m3h4x4(:,59),heltab2x16(:,:,167))
  call Hloop_Q_A(ntryL,G1H4(11),19,0,G2H4(5),n2h4(261))
  call Hloop_QV_A(ntryL,G1H16(28),wf4(:,1),G1H4(5),m3h4x4(:,60),heltab2x16(:,:,168))
  call Hloop_Q_A(ntryL,G1H4(5),19,nMB,G2H4(7),n2h4(262))
  call Hloop_DV_C(ntryL,G1H16(38),16,wf4(:,1),G2H4(8),m3h4x4(:,61),heltab2x16(:,:,169))
  call Hloop_CV_D(ntryL,G1H16(39),16,wf4(:,1),3,G2H4(11),m3h4x4(:,62),heltab2x16(:,:,170))
  call Hloop_UV_W(ntryL,G1H16(40),16,wf4(:,1),3,G2H4(12),m3h4x4(:,63),heltab2x16(:,:,171))
  call Hloop_QV_A(ntryL,G1H8(62),wf4(:,1),G1H2(51),m3h4x2(:,51),heltab2x8(:,:,245))
  call Hloop_Q_A(ntryL,G1H2(51),23,nMB,G2H2(118),n2h2(190))
  call Hloop_QV_A(ntryL,G1H8(63),wf4(:,1),G1H2(168),m3h4x2(:,52),heltab2x8(:,:,246))
  call Hloop_Q_A(ntryL,G1H2(168),23,nMB,G2H2(77),n2h2(191))
  call Hloop_QV_A(ntryL,G1H8(64),wf4(:,1),G1H2(57),m3h4x2(:,53),heltab2x8(:,:,247))
  call Hloop_Q_A(ntryL,G1H2(57),23,nMT,G2H2(74),n2h2(192))
  call Hloop_QV_A(ntryL,G1H8(68),wf4(:,1),G1H2(169),m3h4x2(:,54),heltab2x8(:,:,248))
  call Hloop_Q_A(ntryL,G1H2(169),23,nMB,G2H2(71),n2h2(193))
  call Hloop_QV_A(ntryL,G1H8(69),wf4(:,1),G1H2(174),m3h4x2(:,55),heltab2x8(:,:,249))
  call Hloop_Q_A(ntryL,G1H2(174),23,nMT,G2H2(68),n2h2(194))
  call Hloop_UV_W(ntryL,G0H8(3),20,wf4(:,1),3,G1H2(175),m3h4x2(:,56),heltab2x8(:,:,250))
  call Hloop_AS_Q(ntryL,G1H8(71),wf4(:,3),G1H2(105),ngH,m3h4x2(:,57),heltab2x8(:,:,251))
  call Hloop_A_Q(ntryL,G1H2(105),27,nMB,G2H2(98),n2h2(195))
  call Hloop_AS_Q(ntryL,G1H8(45),wf4(:,6),G1H2(133),ngX,m3h4x2(:,58),heltab2x8(:,:,252))
  call Hloop_A_Q(ntryL,G1H2(133),27,nMB,G2H2(89),n2h2(196))
  call Hloop_AV_Q(ntryL,G1H8(2),wf4(:,1),G1H2(111),m3h4x2(:,59),heltab2x8(:,:,253))
  call Hloop_A_Q(ntryL,G1H2(111),27,nMB,G2H2(86),n2h2(197))
  call Hloop_AV_Q(ntryL,G1H8(3),wf4(:,1),G1H2(139),m3h4x2(:,60),heltab2x8(:,:,254))
  call Hloop_A_Q(ntryL,G1H2(139),27,nMB,G2H2(83),n2h2(198))
  call Hloop_AV_Q(ntryL,G1H8(8),wf4(:,1),G1H2(27),m3h4x2(:,61),heltab2x8(:,:,255))
  call Hloop_A_Q(ntryL,G1H2(27),27,nMT,G2H2(80),n2h2(199))
  call Hloop_AV_Q(ntryL,G1H8(15),wf4(:,1),G1H2(52),m3h4x2(:,62),heltab2x8(:,:,256))
  call Hloop_A_Q(ntryL,G1H2(52),27,nMB,G2H2(136),n2h2(200))
  call Hloop_AZ_Q(ntryL,G1H8(9),wf4(:,7),G1H2(34),ngZd,m3h4x2(:,63),heltab2x8(:,:,257))
  call Hloop_A_Q(ntryL,G1H2(34),27,nMB,G2H2(133),n2h2(201))
  call Hloop_AV_Q(ntryL,G1H8(11),wf4(:,1),G1H2(28),m3h4x2(:,64),heltab2x8(:,:,258))
  call Hloop_A_Q(ntryL,G1H2(28),27,nMB,G2H2(130),n2h2(202))
  call Hloop_AV_Q(ntryL,G1H8(12),wf4(:,1),G1H2(29),m3h4x2(:,65),heltab2x8(:,:,259))
  call Hloop_A_Q(ntryL,G1H2(29),27,nMT,G2H2(107),n2h2(203))
  call Hloop_UV_W(ntryL,G0H8(15),24,wf4(:,1),3,G1H2(33),m3h4x2(:,66),heltab2x8(:,:,260))
  call Hloop_AQ_V(ntryL,G1H16(43),wf8(:,96),G1H2(35),m3h8x2(:,1),heltab2x16(:,:,172))
  call Hloop_AQ_V(ntryL,G1H16(49),wf8(:,97),G1H2(41),m3h8x2(:,2),heltab2x16(:,:,173))
  call Hloop_VQ_A(ntryL,G1H16(44),wf8(:,96),G1H2(47),m3h8x2(:,3),heltab2x16(:,:,174))
  call Hloop_Q_A(ntryL,G1H2(47),23,nMB,G2H2(104),n2h2(204))
  call Hloop_VQ_A(ntryL,G1H16(48),wf8(:,97),G1H2(89),m3h8x2(:,4),heltab2x16(:,:,175))
  call Hloop_Q_A(ntryL,G1H2(89),23,nMB,G2H2(49),n2h2(205))
  call Hloop_AQ_S(ntryL,G1H16(47),wf8(:,98),G1H2(53),ngH,m3h8x2(:,5),heltab2x16(:,:,176))
  call Hloop_AQ_S(ntryL,G1H16(50),wf8(:,98),G1H2(59),ngX,m3h8x2(:,6),heltab2x16(:,:,177))
  call Hloop_AQ_S(ntryL,G1H16(51),wf8(:,98),G1H2(75),ngPtb,m3h8x2(:,7),heltab2x16(:,:,178))
  call Hloop_AQ_V(ntryL,G1H16(57),wf8(:,98),G1H2(88),m3h8x2(:,8),heltab2x16(:,:,179))
  call Hloop_AQ_V(ntryL,G1H16(53),wf8(:,99),G1H2(82),m3h8x2(:,9),heltab2x16(:,:,180))
  call Hloop_AQ_Z(ntryL,G1H16(55),wf8(:,98),G1H2(76),ngZd,m3h8x2(:,10),heltab2x16(:,:,181))
  call Hloop_AQ_W(ntryL,G1H16(61),wf8(:,98),G1H2(81),m3h8x2(:,11),heltab2x16(:,:,182))
  call Hloop_VQ_A(ntryL,G1H16(62),wf8(:,98),G1H2(99),m3h8x2(:,12),heltab2x16(:,:,183))
  call Hloop_Q_A(ntryL,G1H2(99),23,nMB,G2H2(51),n2h2(206))
  call Hloop_VQ_A(ntryL,G1H16(60),wf8(:,99),G1H2(100),m3h8x2(:,13),heltab2x16(:,:,184))
  call Hloop_Q_A(ntryL,G1H2(100),23,nMB,G2H2(72),n2h2(207))
  call Hloop_AQ_V(ntryL,G1H16(67),ex3(:),G1H8(22),m3h2x8(:,109),heltab2x16(:,:,185))
  call Hloop_AQ_V(ntryL,G1H16(65),ex3(:),G1H8(23),m3h2x8(:,110),heltab2x16(:,:,186))
  call Hloop_VQ_A(ntryL,G1H16(66),ex3(:),G1H8(24),m3h2x8(:,111),heltab2x16(:,:,187))
  call Hloop_Q_A(ntryL,G1H8(24),20,nMB,G2H8(15),n2h8(129))
  call Hloop_VQ_A(ntryL,G1H16(70),ex3(:),G1H8(30),m3h2x8(:,112),heltab2x16(:,:,188))
  call Hloop_Q_A(ntryL,G1H8(30),20,nMB,G2H8(16),n2h8(130))
  call Hloop_AQ_S(ntryL,G1H16(69),ex3(:),G1H8(28),ngH,m3h2x8(:,113),heltab2x16(:,:,189))
  call Hloop_AQ_S(ntryL,G1H16(81),ex3(:),G1H8(29),ngX,m3h2x8(:,114),heltab2x16(:,:,190))
  call Hloop_AQ_S(ntryL,G1H16(82),ex3(:),G1H8(31),ngPtb,m3h2x8(:,115),heltab2x16(:,:,191))
  call Hloop_AQ_V(ntryL,G1H16(88),ex3(:),G1H8(33),m3h2x8(:,116),heltab2x16(:,:,192))
  call Hloop_AQ_V(ntryL,G1H16(84),ex3(:),G1H8(34),m3h2x8(:,117),heltab2x16(:,:,193))
  call Hloop_AQ_Z(ntryL,G1H16(86),ex3(:),G1H8(39),ngZd,m3h2x8(:,118),heltab2x16(:,:,194))
  call Hloop_AQ_W(ntryL,G1H16(87),ex3(:),G1H8(37),m3h2x8(:,119),heltab2x16(:,:,195))
  call Hloop_VQ_A(ntryL,G1H16(91),ex3(:),G1H8(40),m3h2x8(:,120),heltab2x16(:,:,196))
  call Hloop_Q_A(ntryL,G1H8(40),20,nMB,G2H8(17),n2h8(131))
  call Hloop_VQ_A(ntryL,G1H16(90),ex3(:),G1H8(41),m3h2x8(:,121),heltab2x16(:,:,197))
  call Hloop_Q_A(ntryL,G1H8(41),20,nMB,G2H8(18),n2h8(132))
  call Hloop_AQ_S(ntryL,G1H4(41),ex3(:),G1H2(101),ngH,m3h2x2(:,253),heltab2x4(:,:,319))
  call Hloop_AQ_S(ntryL,G1H4(42),ex3(:),G1H2(106),ngX,m3h2x2(:,254),heltab2x4(:,:,320))
  call Hloop_AQ_S(ntryL,G1H4(54),ex3(:),G1H2(107),ngPtb,m3h2x2(:,255),heltab2x4(:,:,321))
  call Hloop_AQ_V(ntryL,G1H4(135),ex3(:),G1H2(112),m3h2x2(:,256),heltab2x4(:,:,322))
  call Hloop_AQ_Z(ntryL,G1H4(123),ex3(:),G1H2(113),ngZd,m3h2x2(:,257),heltab2x4(:,:,323))
  call Hloop_AQ_W(ntryL,G1H4(124),ex3(:),G1H2(117),m3h2x2(:,258),heltab2x4(:,:,324))
  call Hloop_VQ_A(ntryL,G0H8(19),ex1(:),G0H4(7),m3h2x4(:,195),heltab2x8(:,:,261))
  call Hloop_Q_A(ntryL,G0H4(7),25,nMT,G1H4(77),n2h4(263))
  call Hloop_VQ_A(ntryL,G0H8(20),ex1(:),G0H4(3),m3h2x4(:,196),heltab2x8(:,:,262))
  call Hloop_Q_A(ntryL,G0H4(3),25,nMT,G1H4(6),n2h4(264))
  call Hloop_AQ_V(ntryL,G1H16(92),wf8(:,104),G1H2(118),m3h8x2(:,14),heltab2x16(:,:,198))
  call Hloop_VQ_A(ntryL,G1H16(93),wf8(:,104),G1H2(119),m3h8x2(:,15),heltab2x16(:,:,199))
  call Hloop_Q_A(ntryL,G1H2(119),23,nMB,G2H2(82),n2h2(208))
  call Hloop_AQ_V(ntryL,G1H16(94),wf8(:,105),G1H2(123),m3h8x2(:,16),heltab2x16(:,:,200))
  call Hloop_VQ_A(ntryL,G1H16(95),wf8(:,105),G1H2(124),m3h8x2(:,17),heltab2x16(:,:,201))
  call Hloop_Q_A(ntryL,G1H2(124),23,nMB,G2H2(99),n2h2(209))
  call Hloop_AQ_V(ntryL,G1H16(96),ex1(:),G1H8(42),m3h2x8(:,122),heltab2x16(:,:,202))
  call Hloop_VQ_A(ntryL,G1H16(97),ex1(:),G1H8(43),m3h2x8(:,123),heltab2x16(:,:,203))
  call Hloop_Q_A(ntryL,G1H8(43),17,nMT,G2H8(19),n2h8(133))
  call Hloop_AQ_V(ntryL,G1H16(98),ex1(:),G1H8(46),m3h2x8(:,124),heltab2x16(:,:,204))
  call Hloop_VQ_A(ntryL,G1H16(99),ex1(:),G1H8(47),m3h2x8(:,125),heltab2x16(:,:,205))
  call Hloop_Q_A(ntryL,G1H8(47),17,nMT,G2H8(20),n2h8(134))
  call Hloop_VQ_A(ntryL,G0H8(22),ex3(:),G0H4(2),m3h2x4(:,197),heltab2x8(:,:,263))
  call Hloop_Q_A(ntryL,G0H4(2),22,nMB,G1H4(103),n2h4(265))
  call Hloop_VQ_A(ntryL,G0H8(23),ex3(:),G0H4(1),m3h2x4(:,198),heltab2x8(:,:,264))
  call Hloop_Q_A(ntryL,G0H4(1),22,nMB,G1H4(8),n2h4(266))
  call Hloop_VA_Q(ntryL,G0H8(24),ex2(:),G0H4(6),m3h2x4(:,199),heltab2x8(:,:,265))
  call Hloop_A_Q(ntryL,G0H4(6),22,nMT,G1H4(28),n2h4(267))
  call Hloop_VA_Q(ntryL,G0H8(25),ex2(:),G0H4(5),m3h2x4(:,200),heltab2x8(:,:,266))
  call Hloop_A_Q(ntryL,G0H4(5),22,nMT,G1H4(13),n2h4(268))
  call Hloop_AQ_V(ntryL,G1H16(100),ex3(:),G1H8(48),m3h2x8(:,126),heltab2x16(:,:,206))
  call Hloop_VQ_A(ntryL,G1H16(101),ex3(:),G1H8(49),m3h2x8(:,127),heltab2x16(:,:,207))
  call Hloop_Q_A(ntryL,G1H8(49),20,nMB,G2H8(21),n2h8(135))
  call Hloop_AQ_V(ntryL,G1H16(102),ex3(:),G1H8(51),m3h2x8(:,128),heltab2x16(:,:,208))
  call Hloop_VQ_A(ntryL,G1H16(103),ex3(:),G1H8(52),m3h2x8(:,129),heltab2x16(:,:,209))
  call Hloop_Q_A(ntryL,G1H8(52),20,nMB,G2H8(22),n2h8(136))
  call Hloop_QA_V(ntryL,G1H16(104),ex2(:),G1H8(14),m3h2x8(:,130),heltab2x16(:,:,210))
  call Hloop_VA_Q(ntryL,G1H16(105),ex2(:),G1H8(26),m3h2x8(:,131),heltab2x16(:,:,211))
  call Hloop_A_Q(ntryL,G1H8(26),18,nMT,G2H8(23),n2h8(137))
  call Hloop_QA_V(ntryL,G1H16(106),ex2(:),G1H8(4),m3h2x8(:,132),heltab2x16(:,:,212))
  call Hloop_VA_Q(ntryL,G1H16(107),ex2(:),G1H8(13),m3h2x8(:,133),heltab2x16(:,:,213))
  call Hloop_A_Q(ntryL,G1H8(13),18,nMT,G2H8(24),n2h8(138))
  call Hloop_VA_Q(ntryL,G0H8(30),ex2(:),G0H4(4),m3h2x4(:,201),heltab2x8(:,:,267))
  call Hloop_A_Q(ntryL,G0H4(4),19,nMT,G1H4(39),n2h4(269))
  call Hloop_VA_Q(ntryL,G0H8(28),ex2(:),G0H4(7),m3h2x4(:,202),heltab2x8(:,:,268))
  call Hloop_A_Q(ntryL,G0H4(7),19,nMT,G1H4(14),n2h4(270))
  call Hloop_SA_Q(ntryL,G0H8(29),ex2(:),G0H4(3),ngH,m3h2x4(:,203),heltab2x8(:,:,269))
  call Hloop_A_Q(ntryL,G0H4(3),19,nMT,G1H4(40),n2h4(271))
  call Hloop_SA_Q(ntryL,G0H8(31),ex2(:),G0H4(2),ngX,m3h2x4(:,204),heltab2x8(:,:,270))
  call Hloop_A_Q(ntryL,G0H4(2),19,nMT,G1H4(17),n2h4(272))
  call Hloop_SA_Q(ntryL,G0H8(32),ex2(:),G0H4(1),ngPtb,m3h2x4(:,205),heltab2x8(:,:,271))
  call Hloop_A_Q(ntryL,G0H4(1),19,nMB,G1H4(91),n2h4(273))
  call Hloop_VA_Q(ntryL,G0H8(38),ex2(:),G0H4(6),m3h2x4(:,206),heltab2x8(:,:,272))
  call Hloop_A_Q(ntryL,G0H4(6),19,nMT,G1H4(73),n2h4(274))
  call Hloop_VA_Q(ntryL,G0H8(34),ex2(:),G0H4(5),m3h2x4(:,207),heltab2x8(:,:,273))
  call Hloop_A_Q(ntryL,G0H4(5),19,nMT,G1H4(68),n2h4(275))
  call Hloop_ZA_Q(ntryL,G0H8(36),ex2(:),G0H4(4),ngZu,m3h2x4(:,208),heltab2x8(:,:,274))
  call Hloop_A_Q(ntryL,G0H4(4),19,nMT,G1H4(47),n2h4(276))
  call Hloop_WA_Q(ntryL,G0H8(37),ex2(:),G0H4(7),m3h2x4(:,209),heltab2x8(:,:,275))
  call Hloop_A_Q(ntryL,G0H4(7),19,nMB,G1H4(38),n2h4(277))
  call Hloop_QA_V(ntryL,G1H8(19),ex2(:),G1H4(75),m3h2x4(:,210),heltab2x8(:,:,276))
  call Hloop_VQ_A(ntryL,G0H8(41),ex1(:),G0H4(3),m3h2x4(:,211),heltab2x8(:,:,277))
  call Hloop_Q_A(ntryL,G0H4(3),19,nMT,G1H4(52),n2h4(278))
  call Hloop_VQ_A(ntryL,G0H8(42),ex1(:),G0H4(2),m3h2x4(:,212),heltab2x8(:,:,278))
  call Hloop_Q_A(ntryL,G0H4(2),19,nMT,G1H4(100),n2h4(279))
  call Hloop_SQ_A(ntryL,G0H8(44),ex1(:),G0H4(1),ngH,m3h2x4(:,213),heltab2x8(:,:,279))
  call Hloop_Q_A(ntryL,G0H4(1),19,nMT,G1H4(45),n2h4(280))
  call Hloop_SQ_A(ntryL,G0H8(45),ex1(:),G0H4(6),ngX,m3h2x4(:,214),heltab2x8(:,:,280))
  call Hloop_Q_A(ntryL,G0H4(6),19,nMT,G1H4(27),n2h4(281))
  call Hloop_SQ_A(ntryL,G0H8(46),ex1(:),G0H4(5),ngPbt,m3h2x4(:,215),heltab2x8(:,:,281))
  call Hloop_Q_A(ntryL,G0H4(5),19,nMB,G1H4(22),n2h4(282))
  call Hloop_VQ_A(ntryL,G0H8(18),ex1(:),G0H4(4),m3h2x4(:,216),heltab2x8(:,:,282))
  call Hloop_Q_A(ntryL,G0H4(4),19,nMT,G1H4(24),n2h4(283))
  call Hloop_VQ_A(ntryL,G0H8(52),ex1(:),G0H4(7),m3h2x4(:,217),heltab2x8(:,:,283))
  call Hloop_Q_A(ntryL,G0H4(7),19,nMT,G1H4(18),n2h4(284))
  call Hloop_ZQ_A(ntryL,G0H8(51),ex1(:),G0H4(3),ngZu,m3h2x4(:,218),heltab2x8(:,:,284))
  call Hloop_Q_A(ntryL,G0H4(3),19,nMT,G1H4(57),n2h4(285))
  call Hloop_WQ_A(ntryL,G0H8(53),ex1(:),G0H4(2),m3h2x4(:,219),heltab2x8(:,:,285))
  call Hloop_Q_A(ntryL,G0H4(2),19,nMB,G1H4(19),n2h4(286))
  call Hloop_AQ_V(ntryL,G1H8(21),ex1(:),G1H4(69),m3h2x4(:,220),heltab2x8(:,:,286))
  call Hloop_QA_V(ntryL,G1H16(108),ex2(:),G1H8(27),m3h2x8(:,134),heltab2x16(:,:,214))
  call Hloop_QA_V(ntryL,G1H16(109),ex2(:),G1H8(35),m3h2x8(:,135),heltab2x16(:,:,215))
  call Hloop_VA_Q(ntryL,G1H16(110),ex2(:),G1H8(53),m3h2x8(:,136),heltab2x16(:,:,216))
  call Hloop_A_Q(ntryL,G1H8(53),18,nMT,G2H8(1),n2h8(139))
  call Hloop_VA_Q(ntryL,G1H16(111),ex2(:),G1H8(54),m3h2x8(:,137),heltab2x16(:,:,217))
  call Hloop_A_Q(ntryL,G1H8(54),18,nMT,G2H8(2),n2h8(140))
  call Hloop_QA_S(ntryL,G1H16(112),ex2(:),G1H8(55),ngH,m3h2x8(:,138),heltab2x16(:,:,218))
  call Hloop_QA_S(ntryL,G1H16(113),ex2(:),G1H8(56),ngX,m3h2x8(:,139),heltab2x16(:,:,219))
  call Hloop_QA_S(ntryL,G1H16(114),ex2(:),G1H8(58),ngPtb,m3h2x8(:,140),heltab2x16(:,:,220))
  call Hloop_QA_V(ntryL,G1H16(120),ex2(:),G1H8(59),m3h2x8(:,141),heltab2x16(:,:,221))
  call Hloop_QA_V(ntryL,G1H16(116),ex2(:),G1H8(1),m3h2x8(:,142),heltab2x16(:,:,222))
  call Hloop_QA_Z(ntryL,G1H16(118),ex2(:),G1H8(7),ngZu,m3h2x8(:,143),heltab2x16(:,:,223))
  call Hloop_QA_W(ntryL,G1H16(119),ex2(:),G1H8(67),m3h2x8(:,144),heltab2x16(:,:,224))
  call Hloop_VA_Q(ntryL,G1H16(123),ex2(:),G1H8(65),m3h2x8(:,145),heltab2x16(:,:,225))
  call Hloop_A_Q(ntryL,G1H8(65),18,nMT,G2H8(3),n2h8(141))
  call Hloop_VA_Q(ntryL,G1H16(122),ex2(:),G1H8(17),m3h2x8(:,146),heltab2x16(:,:,226))
  call Hloop_A_Q(ntryL,G1H8(17),18,nMT,G2H8(4),n2h8(142))
  call Hloop_AQ_V(ntryL,G1H16(124),ex1(:),G1H8(20),m3h2x8(:,147),heltab2x16(:,:,227))
  call Hloop_AQ_V(ntryL,G1H16(125),ex1(:),G1H8(25),m3h2x8(:,148),heltab2x16(:,:,228))
  call Hloop_VQ_A(ntryL,G1H16(126),ex1(:),G1H8(32),m3h2x8(:,149),heltab2x16(:,:,229))
  call Hloop_Q_A(ntryL,G1H8(32),17,nMT,G2H8(5),n2h8(143))
  call Hloop_VQ_A(ntryL,G1H16(127),ex1(:),G1H8(10),m3h2x8(:,150),heltab2x16(:,:,230))
  call Hloop_Q_A(ntryL,G1H8(10),17,nMT,G2H8(6),n2h8(144))
  call Hloop_AQ_S(ntryL,G1H16(128),ex1(:),G1H8(6),ngH,m3h2x8(:,151),heltab2x16(:,:,231))
  call Hloop_AQ_S(ntryL,G1H16(129),ex1(:),G1H8(60),ngX,m3h2x8(:,152),heltab2x16(:,:,232))
  call Hloop_AQ_S(ntryL,G1H16(130),ex1(:),G1H8(61),ngPbt,m3h2x8(:,153),heltab2x16(:,:,233))
  call Hloop_AQ_V(ntryL,G1H16(136),ex1(:),G1H8(70),m3h2x8(:,154),heltab2x16(:,:,234))
  call Hloop_AQ_V(ntryL,G1H16(132),ex1(:),G1H8(66),m3h2x8(:,155),heltab2x16(:,:,235))
  call Hloop_AQ_Z(ntryL,G1H16(134),ex1(:),G1H8(16),ngZu,m3h2x8(:,156),heltab2x16(:,:,236))
  call Hloop_AQ_W(ntryL,G1H16(135),ex1(:),G1H8(18),m3h2x8(:,157),heltab2x16(:,:,237))
  call Hloop_VQ_A(ntryL,G1H16(139),ex1(:),G1H8(38),m3h2x8(:,158),heltab2x16(:,:,238))
  call Hloop_Q_A(ntryL,G1H8(38),17,nMT,G2H8(7),n2h8(145))
  call Hloop_VQ_A(ntryL,G1H16(138),ex1(:),G1H8(44),m3h2x8(:,159),heltab2x16(:,:,239))
  call Hloop_Q_A(ntryL,G1H8(44),17,nMT,G2H8(8),n2h8(146))
  call Hloop_AQ_S(ntryL,G1H4(53),ex1(:),G1H2(125),ngH,m3h2x2(:,259),heltab2x4(:,:,325))
  call Hloop_AQ_S(ntryL,G1H4(56),ex1(:),G1H2(129),ngX,m3h2x2(:,260),heltab2x4(:,:,326))
  call Hloop_AQ_S(ntryL,G1H4(66),ex1(:),G1H2(130),ngPbt,m3h2x2(:,261),heltab2x4(:,:,327))
  call Hloop_AQ_V(ntryL,G1H4(96),ex1(:),G1H2(131),m3h2x2(:,262),heltab2x4(:,:,328))
  call Hloop_AQ_Z(ntryL,G1H4(83),ex1(:),G1H2(153),ngZu,m3h2x2(:,263),heltab2x4(:,:,329))
  call Hloop_AQ_W(ntryL,G1H4(86),ex1(:),G1H2(159),m3h2x2(:,264),heltab2x4(:,:,330))
  call Hloop_QA_V(ntryL,G1H4(48),ex2(:),G1H2(165),m3h2x2(:,265),heltab2x4(:,:,331))
  call Hloop_AQ_V(ntryL,G1H4(76),ex1(:),G1H2(178),m3h2x2(:,266),heltab2x4(:,:,332))
call HGT_w2_OLR(G1H2(218),1,1,2)
call HGT_w2_invQ_OLR(G1H2(218),2,5,2)
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(218),[G1H2(33)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(99),[G2H2(82),G2H2(72),G2H2(51),G2H2(49),G2H2(104) &
    ,G2H2(122),G2H2(119),G2H2(116),G2H2(113),G2H2(110),G2H2(106),G2H2(85)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(175),[G1H2(92)])
call HGT_w2_OLR(G1H2(228),1,1,2)
call HGT_w2_invQ_OLR(G1H2(228),2,5,2)
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(228),[G1H2(175)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(128),[G2H2(125),G2H2(96)])
call HGT_w2_OLR(G1H4(111),1,1,4)
call HGT_w2_invQ_OLR(G1H4(111),2,5,4)
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(111),[G1H4(77)])
call HGT_w2_OLR(G1H4(117),1,1,4)
call HGT_w2_invQ_OLR(G1H4(117),2,5,4)
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(117),[G1H4(6)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(28),[G1H4(49)])
call HGT_w2_OLR(G1H4(32),1,1,4)
call HGT_w2_invQ_OLR(G1H4(32),2,5,4)
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(32),[G1H4(28)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(13),[G1H4(61)])
call HGT_w2_OLR(G1H4(37),1,1,4)
call HGT_w2_invQ_OLR(G1H4(37),2,5,4)
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(37),[G1H4(13)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(52),[G1H4(59)])
call HGT_w2_OLR(G1H4(80),1,1,4)
call HGT_w2_invQ_OLR(G1H4(80),2,5,4)
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(80),[G1H4(52)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(140),[G2H2(137),G2H2(134),G2H2(131)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(100),[G1H4(74)])
call HGT_w2_OLR(G1H4(102),1,1,4)
call HGT_w2_invQ_OLR(G1H4(102),2,5,4)
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(102),[G1H4(100)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(24),[G1H4(120)])
call HGT_w2_OLR(G1H4(115),1,1,4)
call HGT_w2_invQ_OLR(G1H4(115),2,5,4)
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(115),[G1H4(24)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(18),[G1H4(131)])
call HGT_w2_OLR(G1H4(125),1,1,4)
call HGT_w2_invQ_OLR(G1H4(125),2,5,4)
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(125),[G1H4(18)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(123),[G1H2(118),G1H2(82),G1H2(88),G1H2(41),G1H2(35) &
    ,G1H2(217),G1H2(116),G1H2(96)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(178),[G1H2(115)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(112),[G1H2(216)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(107),[G1H2(229)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(75),[G1H2(230)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(117),[G1H2(240)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(81),[G1H2(25)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(101),[G1H2(73)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(53),[G1H2(74)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(106),[G1H2(84)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(59),[G1H2(85)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(113),[G1H2(186)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(76),[G1H2(187)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(103),[G1H4(118)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(8),[G1H4(92)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(39),[G1H4(129)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(55),[G1H4(130)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(14),[G1H4(142)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(60),[G1H4(9)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(40),[G1H4(16)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(9),[G2H4(66),G2H4(51),G2H4(45),G1H4(63),G1H4(34) &
    ,G1H4(21)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(47),[G1H4(17),G1H4(33)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(38),[G1H4(91),G1H4(46)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(13),[G2H4(47),G2H4(53),G2H4(48),G1H4(51)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(73),[G1H4(58)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(68),[G1H4(31)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(29),[G1H4(35)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(75),[G1H4(43)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(12),[G1H4(140),G1H4(44)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(57),[G1H4(62)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(65),[G1H4(79)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(45),[G1H4(89)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(3),[G2H4(68),G2H4(56),G2H4(50),G1H4(122),G1H4(109) &
    ,G1H4(90)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(57),[G1H4(27),G1H4(101)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(19),[G1H4(22),G1H4(110)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(52),[G2H4(15),G2H4(54),G2H4(49),G1H4(114)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(61),[G1H4(132)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(69),[G1H4(138)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(112),[G2H2(38),G2H2(41),G2H2(44)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(102),[G2H2(109)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(50),[G2H2(53)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(59),[G2H2(62),G2H2(65),G2H2(124)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(14),[G2H4(2),G2H4(64)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(6),[G2H4(4),G2H4(67)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(133),[G2H2(136),G2H2(89),G2H2(98)])
  call Hloop_VQ_A(ntryL,G1H2(218),ex3(:),G1H1(1),m3h2x1(:,336),heltab2x2(:,:,336))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,nMB,G2tensor(2),n2h1(307))
  call Hcheck_last_QA_V(ntryL,l_switch,G2H2(99),ex4(:),G2tensor(4),m3h2x1(:,337),heltab2x2(:,:,337))
  call Hloop_VA_Q(ntryL,G1H2(228),ex4(:),G1H1(1),m3h2x1(:,338),heltab2x2(:,:,338))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,nMB,G2tensor(14),n2h1(308))
  call Hcheck_last_AQ_V(ntryL,l_switch,G2H2(128),ex3(:),G2tensor(6),m3h2x1(:,339),heltab2x2(:,:,339))
call HGT_w2_OLR(G1H4(87),1,1,4)
call HGT_w2_invQ_OLR(G1H4(87),2,5,4)
  call Hloop_QS_A(ntryL,G1H4(87),wf4(:,3),G1H1(1),ngH,m3h4x1(:,67),heltab2x4(:,:,333))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,nMB,G2tensor(16),n2h1(309))
call HGT_w2_OLR(G1H4(93),1,1,4)
call HGT_w2_invQ_OLR(G1H4(93),2,5,4)
  call Hloop_QS_A(ntryL,G1H4(93),wf4(:,6),G1H1(1),ngX,m3h4x1(:,68),heltab2x4(:,:,334))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,nMB,G2tensor(18),n2h1(310))
call HGT_w2_OLR(G1H4(99),1,1,4)
call HGT_w2_invQ_OLR(G1H4(99),2,5,4)
  call Hloop_QV_A(ntryL,G1H4(99),wf4(:,1),G1H1(1),m3h4x1(:,69),heltab2x4(:,:,335))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,nMB,G2tensor(26),n2h1(311))
call HGT_w2_OLR(G1H4(105),1,1,4)
call HGT_w2_invQ_OLR(G1H4(105),2,5,4)
  call Hloop_QZ_A(ntryL,G1H4(105),wf4(:,7),G1H1(1),ngZd,m3h4x1(:,70),heltab2x4(:,:,336))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,nMB,G2tensor(20),n2h1(312))
  call Hloop_QS_A(ntryL,G1H4(111),wf4(:,11),G1H1(1),ngPbt,m3h4x1(:,71),heltab2x4(:,:,337))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,nMB,G2tensor(30),n2h1(313))
  call Hloop_QW_A(ntryL,G1H4(117),wf4(:,13),G1H1(1),m3h4x1(:,72),heltab2x4(:,:,338))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,nMB,G2tensor(47),n2h1(314))
  call Hloop_AS_Q(ntryL,G1H4(32),wf4(:,14),G1H1(1),ngPtb,m3h4x1(:,73),heltab2x4(:,:,339))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,nMB,G2tensor(44),n2h1(315))
  call Hloop_AW_Q(ntryL,G1H4(37),wf4(:,17),G1H1(1),m3h4x1(:,74),heltab2x4(:,:,340))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,nMB,G2tensor(41),n2h1(316))
  call Hloop_QS_A(ntryL,G1H4(80),wf4(:,18),G1H1(1),ngH,m3h4x1(:,75),heltab2x4(:,:,341))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,nMT,G2tensor(43),n2h1(317))
  call Hcheck_last_QA_V(ntryL,l_switch,G2H2(140),ex2(:),G2tensor(296),m3h2x1(:,340),heltab2x2(:,:,340))
  call Hloop_QS_A(ntryL,G1H4(102),wf4(:,19),G1H1(1),ngX,m3h4x1(:,76),heltab2x4(:,:,342))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,nMT,G2tensor(68),n2h1(318))
  call Hloop_QV_A(ntryL,G1H4(115),wf4(:,2),G1H1(1),m3h4x1(:,77),heltab2x4(:,:,343))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,nMT,G2tensor(65),n2h1(319))
  call Hloop_QZ_A(ntryL,G1H4(125),wf4(:,20),G1H1(1),ngZu,m3h4x1(:,78),heltab2x4(:,:,344))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,nMT,G2tensor(56),n2h1(320))
  call Hloop_VA_Q(ntryL,G1H2(123),ex4(:),G1H1(1),m3h2x1(:,341),heltab2x2(:,:,341))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,nMB,G2tensor(53),n2h1(321))
  call Hloop_VA_Q(ntryL,G1H2(178),ex4(:),G1H1(1),m3h2x1(:,342),heltab2x2(:,:,342))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,nMB,G2tensor(55),n2h1(322))
  call Hloop_VQ_A(ntryL,G1H2(126),ex3(:),G1H1(1),m3h2x1(:,343),heltab2x2(:,:,343))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,nMB,G2tensor(70),n2h1(323))
  call Hloop_VQ_A(ntryL,G1H2(127),ex3(:),G1H1(1),m3h2x1(:,344),heltab2x2(:,:,344))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,nMB,G2tensor(71),n2h1(324))
  call Hloop_SQ_A(ntryL,G1H2(140),ex3(:),G1H1(1),ngPtb,m3h2x1(:,345),heltab2x2(:,:,345))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,nMT,G2tensor(218),n2h1(325))
  call Hloop_SQ_A(ntryL,G1H2(151),ex3(:),G1H1(1),ngPtb,m3h2x1(:,346),heltab2x2(:,:,346))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,nMT,G2tensor(76),n2h1(326))
  call Hloop_WQ_A(ntryL,G1H2(205),ex3(:),G1H1(1),m3h2x1(:,347),heltab2x2(:,:,347))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,nMT,G2tensor(73),n2h1(327))
  call Hloop_WQ_A(ntryL,G1H2(206),ex3(:),G1H1(1),m3h2x1(:,348),heltab2x2(:,:,348))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,nMT,G2tensor(341),n2h1(328))
  call Hloop_VA_Q(ntryL,G1H2(112),ex4(:),G1H1(1),m3h2x1(:,349),heltab2x2(:,:,349))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,nMB,G2tensor(329),n2h1(329))
  call Hloop_SA_Q(ntryL,G1H2(107),ex4(:),G1H1(1),ngPbt,m3h2x1(:,350),heltab2x2(:,:,350))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,nMT,G2tensor(326),n2h1(330))
  call Hloop_SA_Q(ntryL,G1H2(75),ex4(:),G1H1(1),ngPbt,m3h2x1(:,351),heltab2x2(:,:,351))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,nMT,G2tensor(77),n2h1(331))
  call Hloop_WA_Q(ntryL,G1H2(117),ex4(:),G1H1(1),m3h2x1(:,352),heltab2x2(:,:,352))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,nMT,G2tensor(74),n2h1(332))
  call Hloop_WA_Q(ntryL,G1H2(81),ex4(:),G1H1(1),m3h2x1(:,353),heltab2x2(:,:,353))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,nMT,G2tensor(79),n2h1(333))
  call Hloop_VA_Q(ntryL,G1H2(32),ex2(:),G1H1(1),m3h2x1(:,354),heltab2x2(:,:,354))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,nMT,G2tensor(80),n2h1(334))
  call Hloop_VA_Q(ntryL,G1H2(36),ex2(:),G1H1(1),m3h2x1(:,355),heltab2x2(:,:,355))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,nMT,G2tensor(226),n2h1(335))
  call Hloop_SQ_A(ntryL,G1H2(43),ex3(:),G1H1(1),ngH,m3h2x1(:,356),heltab2x2(:,:,356))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,nMB,G2tensor(85),n2h1(336))
  call Hloop_SQ_A(ntryL,G1H2(44),ex3(:),G1H1(1),ngH,m3h2x1(:,357),heltab2x2(:,:,357))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,nMB,G2tensor(82),n2h1(337))
  call Hloop_SQ_A(ntryL,G1H2(54),ex3(:),G1H1(1),ngX,m3h2x1(:,358),heltab2x2(:,:,358))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,nMB,G2tensor(317),n2h1(338))
  call Hloop_SQ_A(ntryL,G1H2(55),ex3(:),G1H1(1),ngX,m3h2x1(:,359),heltab2x2(:,:,359))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,nMB,G2tensor(305),n2h1(339))
  call Hloop_ZQ_A(ntryL,G1H2(62),ex3(:),G1H1(1),ngZd,m3h2x1(:,360),heltab2x2(:,:,360))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,nMB,G2tensor(302),n2h1(340))
  call Hloop_ZQ_A(ntryL,G1H2(66),ex3(:),G1H1(1),ngZd,m3h2x1(:,361),heltab2x2(:,:,361))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,nMB,G2tensor(86),n2h1(341))
  call Hloop_SA_Q(ntryL,G1H2(101),ex4(:),G1H1(1),ngH,m3h2x1(:,362),heltab2x2(:,:,362))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,nMB,G2tensor(83),n2h1(342))
  call Hloop_SA_Q(ntryL,G1H2(53),ex4(:),G1H1(1),ngH,m3h2x1(:,363),heltab2x2(:,:,363))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,nMB,G2tensor(88),n2h1(343))
  call Hloop_SA_Q(ntryL,G1H2(106),ex4(:),G1H1(1),ngX,m3h2x1(:,364),heltab2x2(:,:,364))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,nMB,G2tensor(89),n2h1(344))
  call Hloop_SA_Q(ntryL,G1H2(59),ex4(:),G1H1(1),ngX,m3h2x1(:,365),heltab2x2(:,:,365))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,nMB,G2tensor(97),n2h1(345))
  call Hloop_ZA_Q(ntryL,G1H2(113),ex4(:),G1H1(1),ngZd,m3h2x1(:,366),heltab2x2(:,:,366))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,nMB,G2tensor(229),n2h1(346))
  call Hloop_ZA_Q(ntryL,G1H2(76),ex4(:),G1H1(1),ngZd,m3h2x1(:,367),heltab2x2(:,:,367))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,nMB,G2tensor(103),n2h1(347))
  call Hloop_AS_Q(ntryL,G1H4(71),wf4(:,11),G1H1(1),ngPbt,m3h4x1(:,79),heltab2x4(:,:,345))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,nMT,G2tensor(100),n2h1(348))
  call Hloop_AS_Q(ntryL,G1H4(64),wf4(:,11),G1H1(1),ngPbt,m3h4x1(:,80),heltab2x4(:,:,346))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,nMT,G2tensor(119),n2h1(349))
  call Hloop_AW_Q(ntryL,G1H4(78),wf4(:,13),G1H1(1),m3h4x1(:,81),heltab2x4(:,:,347))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,nMT,G2tensor(116),n2h1(350))
  call Hloop_AW_Q(ntryL,G1H4(82),wf4(:,13),G1H1(1),m3h4x1(:,82),heltab2x4(:,:,348))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,nMT,G2tensor(113),n2h1(351))
  call Hloop_QS_A(ntryL,G1H4(103),wf4(:,14),G1H1(1),ngPtb,m3h4x1(:,83),heltab2x4(:,:,349))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,nMT,G2tensor(104),n2h1(352))
  call Hloop_QS_A(ntryL,G1H4(84),wf4(:,14),G1H1(1),ngPtb,m3h4x1(:,84),heltab2x4(:,:,350))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,nMT,G2tensor(101),n2h1(353))
  call Hloop_QW_A(ntryL,G1H4(8),wf4(:,17),G1H1(1),m3h4x1(:,85),heltab2x4(:,:,351))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,nMT,G2tensor(106),n2h1(354))
  call Hloop_QW_A(ntryL,G1H4(95),wf4(:,17),G1H1(1),m3h4x1(:,86),heltab2x4(:,:,352))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,nMT,G2tensor(109),n2h1(355))
  call Hloop_AS_Q(ntryL,G1H4(50),wf4(:,14),G1H1(1),ngPtb,m3h4x1(:,87),heltab2x4(:,:,353))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,nMB,G2tensor(112),n2h1(356))
  call Hloop_AW_Q(ntryL,G1H4(65),wf4(:,17),G1H1(1),m3h4x1(:,88),heltab2x4(:,:,354))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,nMB,G2tensor(213),n2h1(357))
  call Hloop_AS_Q(ntryL,G1H4(39),wf4(:,18),G1H1(1),ngH,m3h4x1(:,89),heltab2x4(:,:,355))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,nMT,G2tensor(121),n2h1(358))
  call Hloop_AS_Q(ntryL,G2H4(55),wf4(:,18),G2H1(1),ngH,m3h4x1(:,90),heltab2x4(:,:,356))
  call Hcheck_last_A_Q(ntryL,l_switch,G2H1(1),31,nMT,G3tensor(1),n2h1(359))
  call Hloop_AS_Q(ntryL,G1H4(14),wf4(:,19),G1H1(1),ngX,m3h4x1(:,91),heltab2x4(:,:,357))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,nMT,G2tensor(115),n2h1(360))
  call Hloop_AS_Q(ntryL,G2H4(60),wf4(:,19),G2H1(1),ngX,m3h4x1(:,92),heltab2x4(:,:,358))
  call Hcheck_last_A_Q(ntryL,l_switch,G2H1(1),31,nMT,G3tensor(2),n2h1(361))
  call Hloop_AV_Q(ntryL,G1H4(40),wf4(:,2),G1H1(1),m3h4x1(:,93),heltab2x4(:,:,359))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,nMT,G2tensor(118),n2h1(362))
  call Hloop_AV_Q(ntryL,G2H4(9),wf4(:,2),G2H1(1),m3h4x1(:,94),heltab2x4(:,:,360))
  call Hcheck_last_A_Q(ntryL,l_switch,G2H1(1),31,nMT,G3tensor(3),n2h1(363))
  call Hloop_AV_Q(ntryL,G1H4(47),wf4(:,2),G1H1(1),m3h4x1(:,95),heltab2x4(:,:,361))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,nMT,G2tensor(124),n2h1(364))
  call Hloop_AV_Q(ntryL,G1H4(38),wf4(:,2),G1H1(1),m3h4x1(:,96),heltab2x4(:,:,362))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,nMB,G2tensor(127),n2h1(365))
  call Hloop_AV_Q(ntryL,G2H4(13),wf4(:,2),G2H1(1),m3h4x1(:,97),heltab2x4(:,:,363))
  call Hcheck_last_A_Q(ntryL,l_switch,G2H1(1),31,nMB,G3tensor(4),n2h1(366))
  call Hloop_AV_Q(ntryL,G1H4(73),wf4(:,2),G1H1(1),m3h4x1(:,98),heltab2x4(:,:,364))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,nMT,G2tensor(130),n2h1(367))
  call Hloop_AZ_Q(ntryL,G1H4(68),wf4(:,20),G1H1(1),ngZu,m3h4x1(:,99),heltab2x4(:,:,365))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,nMT,G2tensor(284),n2h1(368))
  call Hloop_AZ_Q(ntryL,G2H4(29),wf4(:,20),G2H1(1),ngZu,m3h4x1(:,100),heltab2x4(:,:,366))
  call Hcheck_last_A_Q(ntryL,l_switch,G2H1(1),31,nMT,G3tensor(5),n2h1(369))
  call Hcheck_last_UV_W(ntryL,l_switch,G1H4(75),19,wf4(:,2),12,G2tensor(140),m3h4x1(:,101),heltab2x4(:,:,367))
  call Hcheck_last_UV_W(ntryL,l_switch,G2H4(12),19,wf4(:,2),12,G3tensor(6),m3h4x1(:,102),heltab2x4(:,:,368))
  call Hloop_QS_A(ntryL,G2H4(57),wf4(:,18),G2H1(1),ngH,m3h4x1(:,103),heltab2x4(:,:,369))
  call Hcheck_last_Q_A(ntryL,l_switch,G2H1(1),31,nMT,G3tensor(7),n2h1(370))
  call Hloop_QS_A(ntryL,G2H4(65),wf4(:,19),G2H1(1),ngX,m3h4x1(:,104),heltab2x4(:,:,370))
  call Hcheck_last_Q_A(ntryL,l_switch,G2H1(1),31,nMT,G3tensor(8),n2h1(371))
  call Hloop_QV_A(ntryL,G1H4(45),wf4(:,2),G1H1(1),m3h4x1(:,105),heltab2x4(:,:,371))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,nMT,G2tensor(137),n2h1(372))
  call Hloop_QV_A(ntryL,G2H4(3),wf4(:,2),G2H1(1),m3h4x1(:,106),heltab2x4(:,:,372))
  call Hcheck_last_Q_A(ntryL,l_switch,G2H1(1),31,nMT,G3tensor(9),n2h1(373))
  call Hloop_QV_A(ntryL,G1H4(57),wf4(:,2),G1H1(1),m3h4x1(:,107),heltab2x4(:,:,373))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,nMT,G2tensor(134),n2h1(374))
  call Hloop_QV_A(ntryL,G1H4(19),wf4(:,2),G1H1(1),m3h4x1(:,108),heltab2x4(:,:,374))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,nMB,G2tensor(131),n2h1(375))
  call Hloop_QV_A(ntryL,G2H4(52),wf4(:,2),G2H1(1),m3h4x1(:,109),heltab2x4(:,:,375))
  call Hcheck_last_Q_A(ntryL,l_switch,G2H1(1),31,nMB,G3tensor(10),n2h1(376))
  call Hloop_QZ_A(ntryL,G2H4(61),wf4(:,20),G2H1(1),ngZu,m3h4x1(:,110),heltab2x4(:,:,376))
  call Hcheck_last_Q_A(ntryL,l_switch,G2H1(1),31,nMT,G3tensor(11),n2h1(377))
  call Hcheck_last_UV_W(ntryL,l_switch,G1H4(69),19,wf4(:,2),12,G2tensor(216),m3h4x1(:,111),heltab2x4(:,:,377))
  call Hcheck_last_QA_V(ntryL,l_switch,G2H2(92),ex4(:),G2tensor(139),m3h2x1(:,368),heltab2x2(:,:,368))
  call Hcheck_last_AQ_V(ntryL,l_switch,G2H2(47),ex3(:),G2tensor(133),m3h2x1(:,369),heltab2x2(:,:,369))
  call Hcheck_last_QA_V(ntryL,l_switch,G2H2(112),ex4(:),G2tensor(136),m3h2x1(:,370),heltab2x2(:,:,370))
  call Hcheck_last_QA_V(ntryL,l_switch,G2H2(102),ex4(:),G2tensor(72),m3h2x1(:,371),heltab2x2(:,:,371))
  call Hcheck_last_AQ_V(ntryL,l_switch,G2H2(50),ex3(:),G2tensor(99),m3h2x1(:,372),heltab2x2(:,:,372))
  call Hcheck_last_QA_V(ntryL,l_switch,G2H2(59),ex2(:),G2tensor(5),m3h2x1(:,373),heltab2x2(:,:,373))
  call Hcheck_last_QA_V(ntryL,l_switch,G2H2(56),ex2(:),G2tensor(15),m3h2x1(:,374),heltab2x2(:,:,374))
  call Hloop_AS_Q(ntryL,G2H4(58),wf4(:,18),G2H1(1),ngH,m3h4x1(:,112),heltab2x4(:,:,378))
  call Hcheck_last_A_Q(ntryL,l_switch,G2H1(1),31,nMB,G3tensor(12),n2h1(378))
  call Hloop_QS_A(ntryL,G2H4(59),wf4(:,18),G2H1(1),ngH,m3h4x1(:,113),heltab2x4(:,:,379))
  call Hcheck_last_Q_A(ntryL,l_switch,G2H1(1),31,nMB,G3tensor(13),n2h1(379))
  call Hloop_AS_Q(ntryL,G2H4(62),wf4(:,19),G2H1(1),ngX,m3h4x1(:,114),heltab2x4(:,:,380))
  call Hcheck_last_A_Q(ntryL,l_switch,G2H1(1),31,nMB,G3tensor(14),n2h1(380))
  call Hloop_QS_A(ntryL,G2H4(63),wf4(:,19),G2H1(1),ngX,m3h4x1(:,115),heltab2x4(:,:,381))
  call Hcheck_last_Q_A(ntryL,l_switch,G2H1(1),31,nMB,G3tensor(15),n2h1(381))
  call Hloop_AV_Q(ntryL,G2H4(14),wf4(:,2),G2H1(1),m3h4x1(:,116),heltab2x4(:,:,382))
  call Hcheck_last_A_Q(ntryL,l_switch,G2H1(1),31,0,G3tensor(16),n2h1(382))
  call Hloop_QV_A(ntryL,G2H4(6),wf4(:,2),G2H1(1),m3h4x1(:,117),heltab2x4(:,:,383))
  call Hcheck_last_Q_A(ntryL,l_switch,G2H1(1),31,0,G3tensor(17),n2h1(383))
  call Hloop_AZ_Q(ntryL,G2H4(21),wf4(:,20),G2H1(1),ngZu,m3h4x1(:,118),heltab2x4(:,:,384))
  call Hcheck_last_A_Q(ntryL,l_switch,G2H1(1),31,0,G3tensor(18),n2h1(384))
  call Hloop_QZ_A(ntryL,G2H4(44),wf4(:,20),G2H1(1),ngZu,m3h4x1(:,119),heltab2x4(:,:,385))
  call Hcheck_last_Q_A(ntryL,l_switch,G2H1(1),31,0,G3tensor(19),n2h1(385))
  call Hloop_AZ_Q(ntryL,G2H4(1),wf4(:,20),G2H1(1),ngZd,m3h4x1(:,120),heltab2x4(:,:,386))
  call Hcheck_last_A_Q(ntryL,l_switch,G2H1(1),31,0,G3tensor(20),n2h1(386))
  call Hloop_AZ_Q(ntryL,G2H4(10),wf4(:,20),G2H1(1),ngZd,m3h4x1(:,121),heltab2x4(:,:,387))
  call Hcheck_last_A_Q(ntryL,l_switch,G2H1(1),31,nMB,G3tensor(21),n2h1(387))
  call Hloop_QZ_A(ntryL,G2H4(5),wf4(:,20),G2H1(1),ngZd,m3h4x1(:,122),heltab2x4(:,:,388))
  call Hcheck_last_Q_A(ntryL,l_switch,G2H1(1),31,0,G3tensor(22),n2h1(388))
  call Hloop_QZ_A(ntryL,G2H4(7),wf4(:,20),G2H1(1),ngZd,m3h4x1(:,123),heltab2x4(:,:,389))
  call Hcheck_last_Q_A(ntryL,l_switch,G2H1(1),31,nMB,G3tensor(23),n2h1(389))
  call Hcheck_last_DV_C(ntryL,l_switch,G2H4(8),19,wf4(:,2),G3tensor(24),m3h4x1(:,124),heltab2x4(:,:,390))
  call Hcheck_last_CV_D(ntryL,l_switch,G2H4(11),19,wf4(:,2),12,G3tensor(25),m3h4x1(:,125),heltab2x4(:,:,391))
  call Hcheck_last_QA_S(ntryL,l_switch,G2H2(118),ex4(:),G2tensor(25),ngH,m3h2x1(:,375),heltab2x2(:,:,375))
  call Hcheck_last_QA_S(ntryL,l_switch,G2H2(77),ex4(:),G2tensor(31),ngX,m3h2x1(:,376),heltab2x2(:,:,376))
  call Hcheck_last_QA_S(ntryL,l_switch,G2H2(74),ex4(:),G2tensor(36),ngPbt,m3h2x1(:,377),heltab2x2(:,:,377))
  call Hcheck_last_QA_Z(ntryL,l_switch,G2H2(71),ex4(:),G2tensor(48),ngZd,m3h2x1(:,378),heltab2x2(:,:,378))
  call Hcheck_last_QA_W(ntryL,l_switch,G2H2(68),ex4(:),G2tensor(84),m3h2x1(:,379),heltab2x2(:,:,379))
  call Hcheck_last_AQ_V(ntryL,l_switch,G2H2(133),ex3(:),G2tensor(93),m3h2x1(:,380),heltab2x2(:,:,380))
  call Hcheck_last_AQ_S(ntryL,l_switch,G2H2(86),ex3(:),G2tensor(105),ngH,m3h2x1(:,381),heltab2x2(:,:,381))
  call Hcheck_last_AQ_S(ntryL,l_switch,G2H2(83),ex3(:),G2tensor(248),ngX,m3h2x1(:,382),heltab2x2(:,:,382))
  call Hcheck_last_AQ_S(ntryL,l_switch,G2H2(80),ex3(:),G2tensor(126),ngPtb,m3h2x1(:,383),heltab2x2(:,:,383))
  call Hcheck_last_AQ_Z(ntryL,l_switch,G2H2(130),ex3(:),G2tensor(141),ngZd,m3h2x1(:,384),heltab2x2(:,:,384))
  call Hcheck_last_AQ_W(ntryL,l_switch,G2H2(107),ex3(:),G2tensor(257),m3h2x1(:,385),heltab2x2(:,:,385))
  call Hloop_VA_Q(ntryL,G1H8(22),wf8(:,91),G1H1(1),m3h8x1(:,1),heltab2x8(:,:,287))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,nMB,G2tensor(142),n2h1(390))
  call Hloop_VA_Q(ntryL,G1H8(23),wf8(:,92),G1H1(1),m3h8x1(:,2),heltab2x8(:,:,288))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,nMB,G2tensor(145),n2h1(391))
  call Hcheck_last_QA_V(ntryL,l_switch,G2H8(15),wf8(:,91),G2tensor(146),m3h8x1(:,3),heltab2x8(:,:,289))
  call Hcheck_last_QA_V(ntryL,l_switch,G2H8(16),wf8(:,92),G2tensor(152),m3h8x1(:,4),heltab2x8(:,:,290))
  call Hloop_SA_Q(ntryL,G1H8(28),wf8(:,93),G1H1(1),ngH,m3h8x1(:,5),heltab2x8(:,:,291))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,nMB,G2tensor(153),n2h1(392))
  call Hloop_SA_Q(ntryL,G1H8(29),wf8(:,93),G1H1(1),ngX,m3h8x1(:,6),heltab2x8(:,:,292))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,nMB,G2tensor(164),n2h1(393))
  call Hloop_SA_Q(ntryL,G1H8(31),wf8(:,93),G1H1(1),ngPbt,m3h8x1(:,7),heltab2x8(:,:,293))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,nMT,G2tensor(165),n2h1(394))
  call Hloop_VA_Q(ntryL,G1H8(33),wf8(:,93),G1H1(1),m3h8x1(:,8),heltab2x8(:,:,294))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,nMB,G2tensor(166),n2h1(395))
  call Hloop_VA_Q(ntryL,G1H8(34),wf8(:,94),G1H1(1),m3h8x1(:,9),heltab2x8(:,:,295))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,nMB,G2tensor(176),n2h1(396))
  call Hloop_ZA_Q(ntryL,G1H8(39),wf8(:,93),G1H1(1),ngZd,m3h8x1(:,10),heltab2x8(:,:,296))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,nMB,G2tensor(177),n2h1(397))
  call Hloop_WA_Q(ntryL,G1H8(37),wf8(:,93),G1H1(1),m3h8x1(:,11),heltab2x8(:,:,297))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,nMT,G2tensor(205),n2h1(398))
  call Hcheck_last_QA_V(ntryL,l_switch,G2H8(17),wf8(:,93),G2tensor(208),m3h8x1(:,12),heltab2x8(:,:,298))
  call Hcheck_last_QA_V(ntryL,l_switch,G2H8(18),wf8(:,94),G2tensor(210),m3h8x1(:,13),heltab2x8(:,:,299))
  call Hloop_VA_Q(ntryL,G1H8(42),wf8(:,101),G1H1(1),m3h8x1(:,14),heltab2x8(:,:,300))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,nMT,G2tensor(269),n2h1(399))
  call Hcheck_last_QA_V(ntryL,l_switch,G2H8(19),wf8(:,101),G2tensor(278),m3h8x1(:,15),heltab2x8(:,:,301))
  call Hloop_VA_Q(ntryL,G1H8(46),wf8(:,103),G1H1(1),m3h8x1(:,16),heltab2x8(:,:,302))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,nMT,G2tensor(290),n2h1(400))
  call Hcheck_last_QA_V(ntryL,l_switch,G2H8(20),wf8(:,103),G2tensor(10),m3h8x1(:,17),heltab2x8(:,:,303))
  call Hloop_VA_Q(ntryL,G1H8(48),wf8(:,108),G1H1(1),m3h8x1(:,18),heltab2x8(:,:,304))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,nMB,G2tensor(12),n2h1(401))
  call Hcheck_last_QA_V(ntryL,l_switch,G2H8(21),wf8(:,108),G2tensor(347),m3h8x1(:,19),heltab2x8(:,:,305))
  call Hloop_VA_Q(ntryL,G1H8(51),wf8(:,109),G1H1(1),m3h8x1(:,20),heltab2x8(:,:,306))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,nMB,G2tensor(8),n2h1(402))
  call Hcheck_last_QA_V(ntryL,l_switch,G2H8(22),wf8(:,109),G2tensor(22),m3h8x1(:,21),heltab2x8(:,:,307))
  call Hloop_VQ_A(ntryL,G1H8(14),wf8(:,106),G1H1(1),m3h8x1(:,22),heltab2x8(:,:,308))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,nMT,G2tensor(24),n2h1(403))
  call Hcheck_last_AQ_V(ntryL,l_switch,G2H8(23),wf8(:,106),G2tensor(323),m3h8x1(:,23),heltab2x8(:,:,309))
  call Hloop_VQ_A(ntryL,G1H8(4),wf8(:,107),G1H1(1),m3h8x1(:,24),heltab2x8(:,:,310))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,nMT,G2tensor(28),n2h1(404))
  call Hcheck_last_AQ_V(ntryL,l_switch,G2H8(24),wf8(:,107),G2tensor(32),m3h8x1(:,25),heltab2x8(:,:,311))
  call Hloop_VQ_A(ntryL,G1H8(27),wf8(:,119),G1H1(1),m3h8x1(:,26),heltab2x8(:,:,312))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,nMT,G2tensor(34),n2h1(405))
  call Hloop_VQ_A(ntryL,G1H8(35),wf8(:,121),G1H1(1),m3h8x1(:,27),heltab2x8(:,:,313))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,nMT,G2tensor(35),n2h1(406))
  call Hcheck_last_AQ_V(ntryL,l_switch,G2H8(1),wf8(:,119),G2tensor(37),m3h8x1(:,28),heltab2x8(:,:,314))
  call Hcheck_last_AQ_V(ntryL,l_switch,G2H8(2),wf8(:,121),G2tensor(38),m3h8x1(:,29),heltab2x8(:,:,315))
  call Hloop_SQ_A(ntryL,G1H8(55),wf8(:,123),G1H1(1),ngH,m3h8x1(:,30),heltab2x8(:,:,316))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,nMT,G2tensor(40),n2h1(407))
  call Hloop_SQ_A(ntryL,G1H8(56),wf8(:,123),G1H1(1),ngX,m3h8x1(:,31),heltab2x8(:,:,317))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,nMT,G2tensor(50),n2h1(408))
  call Hloop_SQ_A(ntryL,G1H8(58),wf8(:,123),G1H1(1),ngPbt,m3h8x1(:,32),heltab2x8(:,:,318))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,nMB,G2tensor(49),n2h1(409))
  call Hloop_VQ_A(ntryL,G1H8(59),wf8(:,123),G1H1(1),m3h8x1(:,33),heltab2x8(:,:,319))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,nMT,G2tensor(46),n2h1(410))
  call Hloop_VQ_A(ntryL,G1H8(1),wf8(:,125),G1H1(1),m3h8x1(:,34),heltab2x8(:,:,320))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,nMT,G2tensor(52),n2h1(411))
  call Hloop_ZQ_A(ntryL,G1H8(7),wf8(:,123),G1H1(1),ngZu,m3h8x1(:,35),heltab2x8(:,:,321))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,nMT,G2tensor(299),n2h1(412))
  call Hloop_WQ_A(ntryL,G1H8(67),wf8(:,123),G1H1(1),m3h8x1(:,36),heltab2x8(:,:,322))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,nMB,G2tensor(67),n2h1(413))
  call Hcheck_last_AQ_V(ntryL,l_switch,G2H8(3),wf8(:,123),G2tensor(58),m3h8x1(:,37),heltab2x8(:,:,323))
  call Hcheck_last_AQ_V(ntryL,l_switch,G2H8(4),wf8(:,125),G2tensor(59),m3h8x1(:,38),heltab2x8(:,:,324))
  call Hloop_VA_Q(ntryL,G1H8(20),wf8(:,111),G1H1(1),m3h8x1(:,39),heltab2x8(:,:,325))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,nMT,G2tensor(61),n2h1(414))
  call Hloop_VA_Q(ntryL,G1H8(25),wf8(:,113),G1H1(1),m3h8x1(:,40),heltab2x8(:,:,326))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,nMT,G2tensor(62),n2h1(415))
  call Hcheck_last_QA_V(ntryL,l_switch,G2H8(5),wf8(:,111),G2tensor(64),m3h8x1(:,41),heltab2x8(:,:,327))
  call Hcheck_last_QA_V(ntryL,l_switch,G2H8(6),wf8(:,113),G2tensor(186),m3h8x1(:,42),heltab2x8(:,:,328))
  call Hloop_SA_Q(ntryL,G1H8(6),wf8(:,115),G1H1(1),ngH,m3h8x1(:,43),heltab2x8(:,:,329))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,nMT,G2tensor(338),n2h1(416))
  call Hloop_SA_Q(ntryL,G1H8(60),wf8(:,115),G1H1(1),ngX,m3h8x1(:,44),heltab2x8(:,:,330))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,nMT,G2tensor(219),n2h1(417))
  call Hloop_SA_Q(ntryL,G1H8(61),wf8(:,115),G1H1(1),ngPtb,m3h8x1(:,45),heltab2x8(:,:,331))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,nMB,G2tensor(344),n2h1(418))
  call Hloop_VA_Q(ntryL,G1H8(70),wf8(:,115),G1H1(1),m3h8x1(:,46),heltab2x8(:,:,332))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,nMT,G2tensor(225),n2h1(419))
  call Hloop_VA_Q(ntryL,G1H8(66),wf8(:,117),G1H1(1),m3h8x1(:,47),heltab2x8(:,:,333))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,nMT,G2tensor(314),n2h1(420))
  call Hloop_ZA_Q(ntryL,G1H8(16),wf8(:,115),G1H1(1),ngZu,m3h8x1(:,48),heltab2x8(:,:,334))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,nMT,G2tensor(227),n2h1(421))
  call Hloop_WA_Q(ntryL,G1H8(18),wf8(:,115),G1H1(1),m3h8x1(:,49),heltab2x8(:,:,335))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,nMB,G2tensor(320),n2h1(422))
  call Hcheck_last_QA_V(ntryL,l_switch,G2H8(7),wf8(:,115),G2tensor(94),m3h8x1(:,50),heltab2x8(:,:,336))
  call Hcheck_last_QA_V(ntryL,l_switch,G2H8(8),wf8(:,117),G2tensor(95),m3h8x1(:,51),heltab2x8(:,:,337))
  call Hloop_SA_Q(ntryL,G1H2(125),ex2(:),G1H1(1),ngH,m3h2x1(:,386),heltab2x2(:,:,386))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,nMT,G2tensor(91),n2h1(423))
  call Hloop_SA_Q(ntryL,G1H2(129),ex2(:),G1H1(1),ngX,m3h2x1(:,387),heltab2x2(:,:,387))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,nMT,G2tensor(92),n2h1(424))
  call Hloop_SA_Q(ntryL,G1H2(130),ex2(:),G1H1(1),ngPtb,m3h2x1(:,388),heltab2x2(:,:,388))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,nMB,G2tensor(228),n2h1(425))
  call Hloop_VA_Q(ntryL,G1H2(131),ex2(:),G1H1(1),m3h2x1(:,389),heltab2x2(:,:,389))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,nMT,G2tensor(98),n2h1(426))
  call Hloop_ZA_Q(ntryL,G1H2(153),ex2(:),G1H1(1),ngZu,m3h2x1(:,390),heltab2x2(:,:,390))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,nMT,G2tensor(230),n2h1(427))
  call Hloop_WA_Q(ntryL,G1H2(159),ex2(:),G1H1(1),m3h2x1(:,391),heltab2x2(:,:,391))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,nMB,G2tensor(122),n2h1(428))
  call Hloop_VQ_A(ntryL,G1H2(165),ex3(:),G1H1(1),m3h2x1(:,392),heltab2x2(:,:,392))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,nMB,G2tensor(181),n2h1(429))
  call ol_merge_tensors(G3tensor(25),[G3tensor(24),G3tensor(22),G3tensor(20),G3tensor(19),G3tensor(18),G3tensor(17),G3tensor(16) &
    ,G3tensor(6),G2tensor(234),G2tensor(232),G1tensor(365),G1tensor(315),G1tensor(199),G1tensor(79),G0tensor(365),G0tensor(315) &
    ,G0tensor(34),G0tensor(14)])
  call ol_merge_tensors(G2tensor(22),[G2tensor(347),G2tensor(210),G2tensor(208),G2tensor(152),G2tensor(146),G2tensor(235) &
    ,G1tensor(330),G1tensor(115),G0tensor(330),G0tensor(20)])
  call ol_merge_tensors(G2tensor(95),[G2tensor(94),G2tensor(186),G2tensor(64),G2tensor(10),G2tensor(278),G2tensor(325) &
    ,G2tensor(238),G2tensor(236),G1tensor(480),G1tensor(415),G1tensor(380),G1tensor(30),G1tensor(205),G1tensor(175),G1tensor(145) &
    ,G0tensor(480),G0tensor(415),G0tensor(380),G0tensor(45),G0tensor(35),G0tensor(30),G0tensor(25)])
  call ol_merge_tensors(G2tensor(59),[G2tensor(58),G2tensor(38),G2tensor(37),G2tensor(32),G2tensor(323),G2tensor(349) &
    ,G2tensor(237),G1tensor(345),G1tensor(295),G1tensor(235),G1tensor(85),G1tensor(55),G1tensor(25),G0tensor(345),G0tensor(295) &
    ,G0tensor(40),G0tensor(15),G0tensor(10),G0tensor(5)])
  call ol_merge_tensors(G2tensor(240),[G1tensor(527),G1tensor(46),G1tensor(168),G0tensor(527),G0tensor(125),G0tensor(85)])
  call ol_merge_tensors(G2tensor(8),[G2tensor(12),G2tensor(176),G2tensor(166),G2tensor(145),G2tensor(142),G2tensor(301) &
    ,G2tensor(298),G2tensor(241),G1tensor(530),G1tensor(525),G1tensor(515),G1tensor(198),G1tensor(134),G0tensor(530),G0tensor(525) &
    ,G0tensor(515),G0tensor(95),G0tensor(75)])
  call ol_merge_tensors(G2tensor(243),[G1tensor(547),G1tensor(2),G1tensor(242),G1tensor(212),G0tensor(547),G0tensor(124) &
    ,G0tensor(114),G0tensor(104)])
  call ol_merge_tensors(G2tensor(213),[G2tensor(112),G2tensor(244),G1tensor(550),G1tensor(540),G1tensor(535),G1tensor(258) &
    ,G1tensor(230),G1tensor(194),G0tensor(550),G0tensor(540),G0tensor(535),G0tensor(119),G0tensor(109),G0tensor(94)])
  call ol_merge_tensors(G2tensor(136),[G2tensor(246),G1tensor(562),G1tensor(328),G1tensor(11),G0tensor(562),G0tensor(328) &
    ,G0tensor(129)])
  call ol_merge_tensors(G3tensor(23),[G3tensor(21),G3tensor(15),G3tensor(14),G3tensor(13),G3tensor(12),G3tensor(10),G3tensor(4) &
    ,G2tensor(283),G2tensor(280),G2tensor(277),G2tensor(274),G2tensor(271),G2tensor(268),G2tensor(256),G2tensor(247),G1tensor(820) &
    ,G1tensor(815),G1tensor(810),G1tensor(805),G1tensor(590),G1tensor(565),G1tensor(76),G1tensor(14),G0tensor(820),G0tensor(815) &
    ,G0tensor(810),G0tensor(805),G0tensor(590),G0tensor(565),G0tensor(154),G0tensor(134)])
  call ol_merge_tensors(G2tensor(84),[G2tensor(36),G2tensor(252),G2tensor(249),G1tensor(572),G1tensor(22),G0tensor(572) &
    ,G0tensor(139)])
  call ol_merge_tensors(G3tensor(11),[G3tensor(9),G3tensor(8),G3tensor(7),G3tensor(5),G3tensor(3),G3tensor(2),G3tensor(1) &
    ,G2tensor(262),G2tensor(259),G2tensor(253),G2tensor(250),G1tensor(844),G1tensor(839),G1tensor(834),G1tensor(829),G1tensor(605) &
    ,G1tensor(575),G1tensor(57),G1tensor(28),G0tensor(844),G0tensor(839),G0tensor(834),G0tensor(829),G0tensor(605),G0tensor(575) &
    ,G0tensor(164),G0tensor(144)])
  call ol_merge_tensors(G2tensor(93),[G2tensor(255),G1tensor(587),G1tensor(32),G0tensor(587),G0tensor(149)])
  call ol_merge_tensors(G2tensor(257),[G2tensor(126),G2tensor(261),G2tensor(258),G1tensor(602),G1tensor(53),G0tensor(602) &
    ,G0tensor(159)])
  call ol_merge_tensors(G2tensor(216),[G2tensor(264),G1tensor(707),G1tensor(280),G1tensor(209),G1tensor(73),G0tensor(707) &
    ,G0tensor(280),G0tensor(240),G0tensor(13)])
  call ol_merge_tensors(G2tensor(314),[G2tensor(225),G2tensor(62),G2tensor(61),G2tensor(290),G2tensor(269),G2tensor(322) &
    ,G2tensor(319),G2tensor(307),G2tensor(304),G2tensor(289),G2tensor(286),G2tensor(265),G1tensor(710),G1tensor(700),G1tensor(685) &
    ,G1tensor(610),G1tensor(270),G1tensor(125),G1tensor(111),G0tensor(710),G0tensor(700),G0tensor(685),G0tensor(610),G0tensor(270) &
    ,G0tensor(205),G0tensor(165)])
  call ol_merge_tensors(G2tensor(25),[G2tensor(267),G1tensor(802),G0tensor(802)])
  call ol_merge_tensors(G2tensor(48),[G2tensor(31),G2tensor(273),G2tensor(270),G1tensor(807),G0tensor(807)])
  call ol_merge_tensors(G2tensor(105),[G2tensor(276),G1tensor(812),G0tensor(812)])
  call ol_merge_tensors(G2tensor(141),[G2tensor(248),G2tensor(282),G2tensor(279),G1tensor(817),G0tensor(817)])
  call ol_merge_tensors(G2tensor(55),[G2tensor(288),G2tensor(285),G1tensor(553),G1tensor(548),G1tensor(543),G1tensor(358) &
    ,G1tensor(277),G1tensor(272),G1tensor(267),G1tensor(255),G0tensor(553),G0tensor(548),G0tensor(543),G0tensor(358),G0tensor(277) &
    ,G0tensor(272),G0tensor(267),G0tensor(262)])
  call ol_merge_tensors(G2tensor(181),[G2tensor(294),G2tensor(291),G1tensor(822),G1tensor(798),G1tensor(793),G1tensor(757) &
    ,G1tensor(752),G1tensor(397),G1tensor(393),G0tensor(822),G0tensor(798),G0tensor(793),G0tensor(757),G0tensor(752),G0tensor(397) &
    ,G0tensor(393)])
  call ol_merge_tensors(G2tensor(52),[G2tensor(46),G2tensor(35),G2tensor(34),G2tensor(28),G2tensor(24),G2tensor(346),G2tensor(343) &
    ,G2tensor(331),G2tensor(328),G2tensor(295),G2tensor(292),G1tensor(825),G1tensor(580),G1tensor(123),G1tensor(41),G0tensor(825) &
    ,G0tensor(580),G0tensor(175),G0tensor(145)])
  call ol_merge_tensors(G2tensor(300),[G2tensor(297),G1tensor(748),G1tensor(723),G1tensor(718),G1tensor(713),G1tensor(260) &
    ,G1tensor(234),G1tensor(188),G1tensor(174),G0tensor(748),G0tensor(723),G0tensor(718),G0tensor(713),G0tensor(122),G0tensor(97) &
    ,G0tensor(92),G0tensor(87)])
  call ol_merge_tensors(G2tensor(98),[G2tensor(321),G2tensor(318),G2tensor(306),G2tensor(303),G1tensor(51),G1tensor(45) &
    ,G0tensor(162),G0tensor(157)])
  call ol_merge_tensors(G2tensor(91),[G2tensor(309),G1tensor(827),G0tensor(827)])
  call ol_merge_tensors(G2tensor(338),[G2tensor(310),G1tensor(830),G1tensor(660),G1tensor(257),G1tensor(191),G0tensor(830) &
    ,G0tensor(660),G0tensor(250),G0tensor(215)])
  call ol_merge_tensors(G2tensor(230),[G2tensor(92),G2tensor(312),G1tensor(832),G0tensor(832)])
  call ol_merge_tensors(G2tensor(227),[G2tensor(219),G2tensor(313),G1tensor(835),G1tensor(670),G1tensor(249),G1tensor(178) &
    ,G0tensor(835),G0tensor(670),G0tensor(260),G0tensor(225)])
  call ol_merge_tensors(G2tensor(122),[G2tensor(228),G2tensor(315),G1tensor(153),G1tensor(29),G0tensor(152),G0tensor(147)])
  call ol_merge_tensors(G2tensor(320),[G2tensor(344),G2tensor(316),G1tensor(595),G1tensor(105),G1tensor(40),G0tensor(595) &
    ,G0tensor(195),G0tensor(155)])
  call ol_merge_tensors(G2tensor(15),[G2tensor(324),G1tensor(427),G1tensor(392),G1tensor(162),G1tensor(187),G0tensor(427) &
    ,G0tensor(392),G0tensor(83),G0tensor(32)])
  call ol_merge_tensors(G2tensor(345),[G2tensor(342),G2tensor(330),G2tensor(327),G1tensor(26),G1tensor(20),G0tensor(142) &
    ,G0tensor(137)])
  call ol_merge_tensors(G2tensor(333),[G1tensor(837),G0tensor(837)])
  call ol_merge_tensors(G2tensor(40),[G2tensor(334),G1tensor(840),G0tensor(840)])
  call ol_merge_tensors(G2tensor(336),[G1tensor(842),G0tensor(842)])
  call ol_merge_tensors(G2tensor(299),[G2tensor(50),G2tensor(337),G1tensor(845),G0tensor(845)])
  call ol_merge_tensors(G2tensor(339),[G1tensor(318),G1tensor(52),G1tensor(83),G0tensor(318),G0tensor(132),G0tensor(127)])
  call ol_merge_tensors(G2tensor(67),[G2tensor(49),G2tensor(340),G1tensor(570),G1tensor(93),G1tensor(58),G0tensor(570) &
    ,G0tensor(185),G0tensor(135)])
  call ol_merge_tensors(G2tensor(348),[G1tensor(357),G1tensor(307),G1tensor(39),G1tensor(67),G0tensor(357),G0tensor(307) &
    ,G0tensor(123),G0tensor(12)])
  call ol_merge_tensors(G1tensor(332),[G1tensor(282),G1tensor(176),G1tensor(7),G0tensor(332),G0tensor(282),G0tensor(88) &
    ,G0tensor(2)])
  call ol_merge_tensors(G1tensor(657),[G1tensor(220),G1tensor(148),G1tensor(13),G0tensor(657),G0tensor(245),G0tensor(210) &
    ,G0tensor(3)])
  call ol_merge_tensors(G1tensor(340),[G1tensor(290),G1tensor(139),G1tensor(19),G0tensor(340),G0tensor(290),G0tensor(24) &
    ,G0tensor(4)])
  call ol_merge_tensors(G1tensor(347),[G1tensor(297),G1tensor(228),G1tensor(37),G0tensor(347),G0tensor(297),G0tensor(98) &
    ,G0tensor(7)])
  call ol_merge_tensors(G1tensor(667),[G1tensor(237),G1tensor(171),G1tensor(43),G0tensor(667),G0tensor(255),G0tensor(220) &
    ,G0tensor(8)])
  call ol_merge_tensors(G1tensor(355),[G1tensor(305),G1tensor(169),G1tensor(49),G0tensor(355),G0tensor(305),G0tensor(29) &
    ,G0tensor(9)])
  call ol_merge_tensors(G1tensor(637),[G1tensor(317),G1tensor(112),G1tensor(97),G0tensor(637),G0tensor(317),G0tensor(198) &
    ,G0tensor(17)])
  call ol_merge_tensors(G1tensor(567),[G1tensor(86),G1tensor(5),G1tensor(103),G0tensor(567),G0tensor(180),G0tensor(130) &
    ,G0tensor(18)])
  call ol_merge_tensors(G1tensor(325),[G1tensor(229),G1tensor(109),G0tensor(325),G0tensor(39),G0tensor(19)])
  call ol_merge_tensors(G1tensor(402),[G1tensor(367),G1tensor(114),G1tensor(127),G0tensor(402),G0tensor(367),G0tensor(68) &
    ,G0tensor(22)])
  call ol_merge_tensors(G1tensor(410),[G1tensor(375),G1tensor(133),G0tensor(410),G0tensor(375),G0tensor(23)])
  call ol_merge_tensors(G1tensor(417),[G1tensor(382),G1tensor(146),G1tensor(157),G0tensor(417),G0tensor(382),G0tensor(78) &
    ,G0tensor(27)])
  call ol_merge_tensors(G1tensor(425),[G1tensor(390),G1tensor(163),G0tensor(425),G0tensor(390),G0tensor(28)])
  call ol_merge_tensors(G2tensor(140),[G1tensor(435),G1tensor(400),G1tensor(193),G0tensor(435),G0tensor(400),G0tensor(33)])
  call ol_merge_tensors(G1tensor(597),[G1tensor(437),G1tensor(59),G1tensor(217),G0tensor(597),G0tensor(437),G0tensor(158) &
    ,G0tensor(37)])
  call ol_merge_tensors(G1tensor(445),[G1tensor(223),G0tensor(445),G0tensor(38)])
  call ol_merge_tensors(G1tensor(773),[G1tensor(462),G1tensor(447),G1tensor(82),G1tensor(247),G0tensor(773),G0tensor(462) &
    ,G0tensor(447),G0tensor(138),G0tensor(42)])
  call ol_merge_tensors(G1tensor(470),[G1tensor(455),G1tensor(253),G0tensor(470),G0tensor(455),G0tensor(43)])
  call ol_merge_tensors(G1tensor(475),[G1tensor(460),G1tensor(259),G0tensor(475),G0tensor(460),G0tensor(44)])
  call ol_merge_tensors(G1tensor(66),[G1tensor(36),G0tensor(52),G0tensor(47)])
  call ol_merge_tensors(G1tensor(792),[G1tensor(482),G1tensor(12),G0tensor(792),G0tensor(482),G0tensor(48)])
  call ol_merge_tensors(G1tensor(487),[G1tensor(196),G1tensor(164),G1tensor(96),G1tensor(42),G0tensor(487),G0tensor(189) &
    ,G0tensor(84),G0tensor(59),G0tensor(49)])
  call ol_merge_tensors(G1tensor(492),[G1tensor(9),G1tensor(18),G0tensor(492),G0tensor(105),G0tensor(50)])
  call ol_merge_tensors(G1tensor(485),[G1tensor(48),G0tensor(485),G0tensor(53)])
  call ol_merge_tensors(G1tensor(520),[G1tensor(510),G1tensor(490),G1tensor(101),G1tensor(132),G1tensor(108),G1tensor(72) &
    ,G0tensor(520),G0tensor(510),G0tensor(490),G0tensor(194),G0tensor(74),G0tensor(64),G0tensor(54)])
  call ol_merge_tensors(G2tensor(153),[G1tensor(495),G1tensor(15),G1tensor(54),G0tensor(495),G0tensor(110),G0tensor(55)])
  call ol_merge_tensors(G1tensor(102),[G1tensor(60),G0tensor(62),G0tensor(57)])
  call ol_merge_tensors(G1tensor(797),[G1tensor(497),G1tensor(84),G0tensor(797),G0tensor(497),G0tensor(58)])
  call ol_merge_tensors(G1tensor(502),[G1tensor(33),G1tensor(90),G0tensor(502),G0tensor(115),G0tensor(60)])
  call ol_merge_tensors(G1tensor(500),[G1tensor(104),G0tensor(500),G0tensor(63)])
  call ol_merge_tensors(G2tensor(177),[G2tensor(164),G1tensor(505),G1tensor(252),G1tensor(110),G0tensor(505),G0tensor(120) &
    ,G0tensor(65)])
  call ol_merge_tensors(G1tensor(772),[G1tensor(21),G1tensor(144),G1tensor(156),G1tensor(120),G0tensor(772),G0tensor(82) &
    ,G0tensor(77),G0tensor(72),G0tensor(67)])
  call ol_merge_tensors(G1tensor(507),[G1tensor(116),G0tensor(507),G0tensor(69)])
  call ol_merge_tensors(G1tensor(512),[G1tensor(182),G1tensor(122),G0tensor(512),G0tensor(90),G0tensor(70)])
  call ol_merge_tensors(G1tensor(450),[G1tensor(430),G1tensor(420),G1tensor(412),G1tensor(405),G1tensor(138),G0tensor(450) &
    ,G0tensor(430),G0tensor(420),G0tensor(412),G0tensor(405),G0tensor(73)])
  call ol_merge_tensors(G1tensor(517),[G1tensor(150),G0tensor(517),G0tensor(79)])
  call ol_merge_tensors(G1tensor(522),[G1tensor(204),G1tensor(152),G0tensor(522),G0tensor(100),G0tensor(80)])
  call ol_merge_tensors(G1tensor(532),[G1tensor(180),G0tensor(532),G0tensor(89)])
  call ol_merge_tensors(G2tensor(41),[G2tensor(44),G1tensor(360),G1tensor(350),G1tensor(342),G1tensor(335),G1tensor(192) &
    ,G0tensor(360),G0tensor(350),G0tensor(342),G0tensor(335),G0tensor(93)])
  call ol_merge_tensors(G1tensor(537),[G1tensor(222),G0tensor(537),G0tensor(99)])
  call ol_merge_tensors(G1tensor(733),[G1tensor(728),G1tensor(218),G1tensor(3),G0tensor(733),G0tensor(728),G0tensor(107) &
    ,G0tensor(102)])
  call ol_merge_tensors(G1tensor(782),[G1tensor(542),G1tensor(210),G0tensor(782),G0tensor(542),G0tensor(103)])
  call ol_merge_tensors(G1tensor(545),[G1tensor(224),G0tensor(545),G0tensor(108)])
  call ol_merge_tensors(G1tensor(743),[G1tensor(738),G1tensor(248),G1tensor(27),G0tensor(743),G0tensor(738),G0tensor(117) &
    ,G0tensor(112)])
  call ol_merge_tensors(G1tensor(787),[G1tensor(552),G1tensor(240),G0tensor(787),G0tensor(552),G0tensor(113)])
  call ol_merge_tensors(G1tensor(555),[G1tensor(264),G0tensor(555),G0tensor(118)])
  call ol_merge_tensors(G1tensor(777),[G1tensor(557),G1tensor(443),G1tensor(323),G1tensor(17),G0tensor(777),G0tensor(557) &
    ,G0tensor(443),G0tensor(323),G0tensor(128)])
  call ol_merge_tensors(G2tensor(131),[G1tensor(560),G1tensor(10),G0tensor(560),G0tensor(133)])
  call ol_merge_tensors(G1tensor(577),[G1tensor(71),G1tensor(23),G0tensor(577),G0tensor(170),G0tensor(140)])
  call ol_merge_tensors(G2tensor(56),[G2tensor(65),G2tensor(68),G2tensor(43),G1tensor(477),G1tensor(465),G1tensor(64) &
    ,G0tensor(477),G0tensor(465),G0tensor(143)])
  call ol_merge_tensors(G1tensor(582),[G1tensor(458),G1tensor(453),G1tensor(135),G0tensor(582),G0tensor(458),G0tensor(453) &
    ,G0tensor(148)])
  call ol_merge_tensors(G1tensor(592),[G1tensor(124),G1tensor(70),G0tensor(592),G0tensor(190),G0tensor(150)])
  call ol_merge_tensors(G2tensor(127),[G1tensor(585),G1tensor(38),G0tensor(585),G0tensor(153)])
  call ol_merge_tensors(G1tensor(607),[G1tensor(113),G1tensor(47),G0tensor(607),G0tensor(200),G0tensor(160)])
  call ol_merge_tensors(G2tensor(284),[G2tensor(130),G2tensor(115),G2tensor(121),G1tensor(600),G1tensor(56),G0tensor(600) &
    ,G0tensor(163)])
  call ol_merge_tensors(G1tensor(767),[G1tensor(762),G1tensor(633),G1tensor(498),G1tensor(488),G1tensor(483),G1tensor(432) &
    ,G1tensor(428),G1tensor(117),G1tensor(63),G0tensor(767),G0tensor(762),G0tensor(633),G0tensor(498),G0tensor(488),G0tensor(483) &
    ,G0tensor(432),G0tensor(428),G0tensor(172),G0tensor(167)])
  call ol_merge_tensors(G1tensor(612),[G1tensor(89),G0tensor(612),G0tensor(168)])
  call ol_merge_tensors(G1tensor(617),[G1tensor(77),G0tensor(617),G0tensor(169)])
  call ol_merge_tensors(G1tensor(615),[G1tensor(68),G0tensor(615),G0tensor(173)])
  call ol_merge_tensors(G1tensor(620),[G1tensor(69),G0tensor(620),G0tensor(174)])
  call ol_merge_tensors(G1tensor(643),[G1tensor(638),G1tensor(88),G1tensor(75),G0tensor(643),G0tensor(638),G0tensor(182) &
    ,G0tensor(177)])
  call ol_merge_tensors(G1tensor(622),[G1tensor(80),G0tensor(622),G0tensor(178)])
  call ol_merge_tensors(G1tensor(627),[G1tensor(81),G0tensor(627),G0tensor(179)])
  call ol_merge_tensors(G1tensor(625),[G1tensor(165),G0tensor(625),G0tensor(183)])
  call ol_merge_tensors(G1tensor(630),[G1tensor(92),G0tensor(630),G0tensor(184)])
  call ol_merge_tensors(G1tensor(618),[G1tensor(613),G1tensor(100),G1tensor(95),G0tensor(618),G0tensor(613),G0tensor(192) &
    ,G0tensor(187)])
  call ol_merge_tensors(G1tensor(632),[G1tensor(473),G1tensor(468),G1tensor(99),G0tensor(632),G0tensor(473),G0tensor(468) &
    ,G0tensor(188)])
  call ol_merge_tensors(G1tensor(635),[G1tensor(143),G0tensor(635),G0tensor(193)])
  call ol_merge_tensors(G1tensor(788),[G1tensor(783),G1tensor(628),G1tensor(623),G1tensor(308),G1tensor(214),G1tensor(195) &
    ,G1tensor(179),G1tensor(137),G1tensor(107),G0tensor(788),G0tensor(783),G0tensor(628),G0tensor(623),G0tensor(308),G0tensor(237) &
    ,G0tensor(232),G0tensor(227),G0tensor(202),G0tensor(197)])
  call ol_merge_tensors(G1tensor(642),[G1tensor(131),G0tensor(642),G0tensor(199)])
  call ol_merge_tensors(G1tensor(705),[G1tensor(690),G1tensor(675),G1tensor(640),G1tensor(119),G0tensor(705),G0tensor(690) &
    ,G0tensor(675),G0tensor(640),G0tensor(203)])
  call ol_merge_tensors(G1tensor(695),[G1tensor(680),G1tensor(655),G1tensor(645),G1tensor(177),G1tensor(160),G1tensor(155) &
    ,G0tensor(695),G0tensor(680),G0tensor(655),G0tensor(645),G0tensor(224),G0tensor(214),G0tensor(204)])
  call ol_merge_tensors(G1tensor(283),[G1tensor(147),G1tensor(136),G0tensor(283),G0tensor(212),G0tensor(207)])
  call ol_merge_tensors(G1tensor(647),[G1tensor(373),G1tensor(288),G1tensor(141),G0tensor(647),G0tensor(373),G0tensor(288) &
    ,G0tensor(208)])
  call ol_merge_tensors(G1tensor(652),[G1tensor(444),G1tensor(293),G1tensor(239),G1tensor(167),G1tensor(154),G0tensor(652) &
    ,G0tensor(444),G0tensor(293),G0tensor(239),G0tensor(219),G0tensor(209)])
  call ol_merge_tensors(G1tensor(650),[G1tensor(159),G0tensor(650),G0tensor(213)])
  call ol_merge_tensors(G1tensor(298),[G1tensor(197),G1tensor(166),G0tensor(298),G0tensor(222),G0tensor(217)])
  call ol_merge_tensors(G1tensor(662),[G1tensor(388),G1tensor(303),G1tensor(185),G0tensor(662),G0tensor(388),G0tensor(303) &
    ,G0tensor(218)])
  call ol_merge_tensors(G1tensor(665),[G1tensor(173),G0tensor(665),G0tensor(223)])
  call ol_merge_tensors(G1tensor(753),[G1tensor(672),G1tensor(183),G0tensor(753),G0tensor(672),G0tensor(228)])
  call ol_merge_tensors(G1tensor(677),[G1tensor(184),G0tensor(677),G0tensor(229)])
  call ol_merge_tensors(G1tensor(682),[G1tensor(265),G1tensor(189),G0tensor(682),G0tensor(265),G0tensor(230)])
  call ol_merge_tensors(G1tensor(758),[G1tensor(687),G1tensor(201),G0tensor(758),G0tensor(687),G0tensor(233)])
  call ol_merge_tensors(G1tensor(692),[G1tensor(202),G0tensor(692),G0tensor(234)])
  call ol_merge_tensors(G1tensor(697),[G1tensor(275),G1tensor(207),G0tensor(697),G0tensor(275),G0tensor(235)])
  call ol_merge_tensors(G2tensor(139),[G1tensor(702),G1tensor(398),G1tensor(313),G1tensor(208),G0tensor(702),G0tensor(398) &
    ,G0tensor(313),G0tensor(238)])
  call ol_merge_tensors(G1tensor(533),[G1tensor(333),G1tensor(221),G1tensor(245),G0tensor(533),G0tensor(333),G0tensor(247) &
    ,G0tensor(242)])
  call ol_merge_tensors(G1tensor(712),[G1tensor(408),G1tensor(338),G1tensor(215),G0tensor(712),G0tensor(408),G0tensor(338) &
    ,G0tensor(243)])
  call ol_merge_tensors(G2tensor(99),[G1tensor(717),G1tensor(343),G1tensor(279),G1tensor(233),G1tensor(219),G0tensor(717) &
    ,G0tensor(343),G0tensor(279),G0tensor(254),G0tensor(244)])
  call ol_merge_tensors(G1tensor(715),[G1tensor(225),G0tensor(715),G0tensor(248)])
  call ol_merge_tensors(G2tensor(113),[G2tensor(119),G1tensor(745),G1tensor(735),G1tensor(720),G1tensor(269),G1tensor(243) &
    ,G1tensor(226),G0tensor(745),G0tensor(735),G0tensor(720),G0tensor(269),G0tensor(259),G0tensor(249)])
  call ol_merge_tensors(G1tensor(538),[G1tensor(348),G1tensor(244),G1tensor(231),G0tensor(538),G0tensor(348),G0tensor(257) &
    ,G0tensor(252)])
  call ol_merge_tensors(G1tensor(722),[G1tensor(423),G1tensor(353),G1tensor(263),G0tensor(722),G0tensor(423),G0tensor(353) &
    ,G0tensor(253)])
  call ol_merge_tensors(G1tensor(725),[G1tensor(238),G0tensor(725),G0tensor(258)])
  call ol_merge_tensors(G1tensor(763),[G1tensor(727),G1tensor(256),G0tensor(763),G0tensor(727),G0tensor(263)])
  call ol_merge_tensors(G1tensor(732),[G1tensor(261),G0tensor(732),G0tensor(264)])
  call ol_merge_tensors(G2tensor(116),[G2tensor(100),G1tensor(750),G1tensor(740),G1tensor(730),G1tensor(268),G0tensor(750) &
    ,G0tensor(740),G0tensor(730),G0tensor(268)])
  call ol_merge_tensors(G1tensor(768),[G1tensor(737),G1tensor(273),G0tensor(768),G0tensor(737),G0tensor(273)])
  call ol_merge_tensors(G1tensor(742),[G1tensor(274),G0tensor(742),G0tensor(274)])
  call ol_merge_tensors(G2tensor(133),[G1tensor(747),G1tensor(433),G1tensor(363),G1tensor(278),G0tensor(747),G0tensor(433) &
    ,G0tensor(363),G0tensor(278)])
  call ol_merge_tensors(G1tensor(369),[G1tensor(287),G1tensor(284),G0tensor(369),G0tensor(287),G0tensor(284)])
  call ol_merge_tensors(G1tensor(440),[G1tensor(310),G1tensor(300),G1tensor(292),G1tensor(285),G0tensor(440),G0tensor(310) &
    ,G0tensor(300),G0tensor(292),G0tensor(285)])
  call ol_merge_tensors(G2tensor(4),[G1tensor(379),G1tensor(329),G1tensor(324),G1tensor(314),G1tensor(304),G1tensor(294) &
    ,G1tensor(289),G0tensor(379),G0tensor(329),G0tensor(324),G0tensor(314),G0tensor(304),G0tensor(294),G0tensor(289)])
  call ol_merge_tensors(G1tensor(384),[G1tensor(302),G1tensor(299),G0tensor(384),G0tensor(302),G0tensor(299)])
  call ol_merge_tensors(G2tensor(2),[G1tensor(394),G1tensor(312),G1tensor(309),G0tensor(394),G0tensor(312),G0tensor(309)])
  call ol_merge_tensors(G1tensor(439),[G1tensor(322),G1tensor(319),G0tensor(439),G0tensor(322),G0tensor(319)])
  call ol_merge_tensors(G2tensor(20),[G2tensor(26),G2tensor(18),G2tensor(16),G1tensor(327),G1tensor(320),G0tensor(327) &
    ,G0tensor(320)])
  call ol_merge_tensors(G1tensor(513),[G1tensor(404),G1tensor(337),G1tensor(334),G0tensor(513),G0tensor(404),G0tensor(337) &
    ,G0tensor(334)])
  call ol_merge_tensors(G2tensor(6),[G1tensor(459),G1tensor(414),G1tensor(364),G1tensor(354),G1tensor(344),G1tensor(339) &
    ,G0tensor(459),G0tensor(414),G0tensor(364),G0tensor(354),G0tensor(344),G0tensor(339)])
  call ol_merge_tensors(G1tensor(523),[G1tensor(419),G1tensor(352),G1tensor(349),G0tensor(523),G0tensor(419),G0tensor(352) &
    ,G0tensor(349)])
  call ol_merge_tensors(G2tensor(14),[G1tensor(528),G1tensor(429),G1tensor(362),G1tensor(359),G0tensor(528),G0tensor(429) &
    ,G0tensor(362),G0tensor(359)])
  call ol_merge_tensors(G1tensor(372),[G1tensor(368),G0tensor(372),G0tensor(368)])
  call ol_merge_tensors(G2tensor(47),[G2tensor(30),G1tensor(395),G1tensor(385),G1tensor(377),G1tensor(370),G0tensor(395) &
    ,G0tensor(385),G0tensor(377),G0tensor(370)])
  call ol_merge_tensors(G2tensor(72),[G1tensor(399),G1tensor(389),G1tensor(378),G1tensor(374),G0tensor(399),G0tensor(389) &
    ,G0tensor(378),G0tensor(374)])
  call ol_merge_tensors(G1tensor(387),[G1tensor(383),G0tensor(387),G0tensor(383)])
  call ol_merge_tensors(G1tensor(508),[G1tensor(407),G1tensor(403),G0tensor(508),G0tensor(407),G0tensor(403)])
  call ol_merge_tensors(G1tensor(454),[G1tensor(434),G1tensor(424),G1tensor(413),G1tensor(409),G0tensor(454),G0tensor(434) &
    ,G0tensor(424),G0tensor(413),G0tensor(409)])
  call ol_merge_tensors(G1tensor(518),[G1tensor(422),G1tensor(418),G0tensor(518),G0tensor(422),G0tensor(418)])
  call ol_merge_tensors(G1tensor(442),[G1tensor(438),G0tensor(442),G0tensor(438)])
  call ol_merge_tensors(G1tensor(452),[G1tensor(448),G0tensor(452),G0tensor(448)])
  call ol_merge_tensors(G1tensor(457),[G1tensor(449),G0tensor(457),G0tensor(449)])
  call ol_merge_tensors(G2tensor(73),[G2tensor(218),G1tensor(573),G1tensor(467),G1tensor(463),G0tensor(573),G0tensor(467) &
    ,G0tensor(463)])
  call ol_merge_tensors(G1tensor(614),[G1tensor(578),G1tensor(472),G1tensor(464),G0tensor(614),G0tensor(578),G0tensor(472) &
    ,G0tensor(464)])
  call ol_merge_tensors(G2tensor(5),[G1tensor(478),G1tensor(469),G0tensor(478),G0tensor(469)])
  call ol_merge_tensors(G2tensor(296),[G1tensor(479),G1tensor(474),G0tensor(479),G0tensor(474)])
  call ol_merge_tensors(G1tensor(544),[G1tensor(493),G1tensor(484),G0tensor(544),G0tensor(493),G0tensor(484)])
  call ol_merge_tensors(G2tensor(53),[G1tensor(594),G1tensor(589),G1tensor(549),G1tensor(529),G1tensor(504),G1tensor(494) &
    ,G1tensor(489),G0tensor(594),G0tensor(589),G0tensor(549),G0tensor(529),G0tensor(504),G0tensor(494),G0tensor(489)])
  call ol_merge_tensors(G1tensor(554),[G1tensor(503),G1tensor(499),G0tensor(554),G0tensor(503),G0tensor(499)])
  call ol_merge_tensors(G2tensor(88),[G1tensor(814),G1tensor(534),G1tensor(514),G1tensor(509),G0tensor(814),G0tensor(534) &
    ,G0tensor(514),G0tensor(509)])
  call ol_merge_tensors(G2tensor(103),[G2tensor(97),G1tensor(819),G1tensor(539),G1tensor(524),G1tensor(519),G0tensor(819) &
    ,G0tensor(539),G0tensor(524),G0tensor(519)])
  call ol_merge_tensors(G2tensor(70),[G1tensor(563),G1tensor(558),G0tensor(563),G0tensor(558)])
  call ol_merge_tensors(G1tensor(624),[G1tensor(568),G1tensor(559),G0tensor(624),G0tensor(568),G0tensor(559)])
  call ol_merge_tensors(G2tensor(71),[G1tensor(629),G1tensor(569),G1tensor(564),G0tensor(629),G0tensor(569),G0tensor(564)])
  call ol_merge_tensors(G2tensor(341),[G2tensor(76),G1tensor(619),G1tensor(579),G1tensor(574),G0tensor(619),G0tensor(579) &
    ,G0tensor(574)])
  call ol_merge_tensors(G2tensor(329),[G1tensor(588),G1tensor(583),G0tensor(588),G0tensor(583)])
  call ol_merge_tensors(G1tensor(634),[G1tensor(593),G1tensor(584),G0tensor(634),G0tensor(593),G0tensor(584)])
  call ol_merge_tensors(G2tensor(74),[G2tensor(326),G1tensor(603),G1tensor(598),G0tensor(603),G0tensor(598)])
  call ol_merge_tensors(G1tensor(639),[G1tensor(608),G1tensor(599),G0tensor(639),G0tensor(608),G0tensor(599)])
  call ol_merge_tensors(G2tensor(79),[G2tensor(77),G1tensor(644),G1tensor(609),G1tensor(604),G0tensor(644),G0tensor(609) &
    ,G0tensor(604)])
  call ol_merge_tensors(G1tensor(778),[G1tensor(703),G1tensor(663),G1tensor(653),G1tensor(648),G0tensor(778),G0tensor(703) &
    ,G0tensor(663),G0tensor(653),G0tensor(648)])
  call ol_merge_tensors(G1tensor(714),[G1tensor(658),G1tensor(649),G0tensor(714),G0tensor(658),G0tensor(649)])
  call ol_merge_tensors(G2tensor(226),[G1tensor(719),G1tensor(709),G1tensor(669),G1tensor(659),G1tensor(654),G0tensor(719) &
    ,G0tensor(709),G0tensor(669),G0tensor(659),G0tensor(654)])
  call ol_merge_tensors(G1tensor(724),[G1tensor(668),G1tensor(664),G0tensor(724),G0tensor(668),G0tensor(664)])
  call ol_merge_tensors(G1tensor(678),[G1tensor(673),G0tensor(678),G0tensor(673)])
  call ol_merge_tensors(G1tensor(729),[G1tensor(683),G1tensor(674),G0tensor(729),G0tensor(683),G0tensor(674)])
  call ol_merge_tensors(G1tensor(734),[G1tensor(684),G1tensor(679),G0tensor(734),G0tensor(684),G0tensor(679)])
  call ol_merge_tensors(G1tensor(693),[G1tensor(688),G0tensor(693),G0tensor(688)])
  call ol_merge_tensors(G1tensor(739),[G1tensor(698),G1tensor(689),G0tensor(739),G0tensor(698),G0tensor(689)])
  call ol_merge_tensors(G1tensor(744),[G1tensor(699),G1tensor(694),G0tensor(744),G0tensor(699),G0tensor(694)])
  call ol_merge_tensors(G2tensor(80),[G1tensor(749),G1tensor(708),G1tensor(704),G0tensor(749),G0tensor(708),G0tensor(704)])
  call ol_merge_tensors(G1tensor(754),[G0tensor(754)])
  call ol_merge_tensors(G1tensor(765),[G1tensor(755),G0tensor(765),G0tensor(755)])
  call ol_merge_tensors(G1tensor(759),[G0tensor(759)])
  call ol_merge_tensors(G1tensor(770),[G1tensor(760),G0tensor(770),G0tensor(760)])
  call ol_merge_tensors(G1tensor(764),[G0tensor(764)])
  call ol_merge_tensors(G1tensor(769),[G0tensor(769)])
  call ol_merge_tensors(G1tensor(774),[G0tensor(774)])
  call ol_merge_tensors(G1tensor(775),[G0tensor(775)])
  call ol_merge_tensors(G1tensor(779),[G0tensor(779)])
  call ol_merge_tensors(G1tensor(780),[G0tensor(780)])
  call ol_merge_tensors(G1tensor(794),[G1tensor(784),G0tensor(794),G0tensor(784)])
  call ol_merge_tensors(G1tensor(785),[G0tensor(785)])
  call ol_merge_tensors(G1tensor(799),[G1tensor(789),G0tensor(799),G0tensor(789)])
  call ol_merge_tensors(G1tensor(790),[G0tensor(790)])
  call ol_merge_tensors(G1tensor(795),[G0tensor(795)])
  call ol_merge_tensors(G1tensor(800),[G0tensor(800)])
  call ol_merge_tensors(G2tensor(85),[G1tensor(803),G0tensor(803)])
  call ol_merge_tensors(G2tensor(82),[G1tensor(804),G0tensor(804)])
  call ol_merge_tensors(G2tensor(302),[G2tensor(317),G1tensor(808),G0tensor(808)])
  call ol_merge_tensors(G2tensor(86),[G2tensor(305),G1tensor(809),G0tensor(809)])
  call ol_merge_tensors(G2tensor(83),[G1tensor(813),G0tensor(813)])
  call ol_merge_tensors(G2tensor(229),[G2tensor(89),G1tensor(818),G0tensor(818)])
  call ol_merge_tensors(G2tensor(106),[G2tensor(104),G1tensor(823),G0tensor(823)])
  call ol_merge_tensors(G2tensor(109),[G2tensor(101),G1tensor(824),G0tensor(824)])
  call ol_merge_tensors(G2tensor(118),[G1tensor(828),G0tensor(828)])
  call ol_merge_tensors(G2tensor(124),[G1tensor(833),G0tensor(833)])
  call ol_merge_tensors(G2tensor(137),[G1tensor(838),G0tensor(838)])
  call ol_merge_tensors(G2tensor(134),[G1tensor(843),G0tensor(843)])
  call ol_merge_tensors(G2tensor(205),[G2tensor(165)])
  call TI_triangle_red(G3tensor(25),RedBasis(2),mass3set(:,1),G0tensor(1),G0tensor(6),G0tensor(11),G0tensor(16),M2L1R1)
  call TI_triangle_red(G2tensor(22),RedBasis(7),mass3set(:,2),G0tensor(21),G0tensor(26),G0tensor(31),G0tensor(36),M2L1R1,[nMB], &
    G0tensor(41))
  call TI_triangle_red(G2tensor(95),RedBasis(15),mass3set(:,3),G0tensor(46),G0tensor(51),G0tensor(56),G0tensor(61),M2L1R1,[nMT], &
    G0tensor(66))
  call TI_triangle_red(G2tensor(59),RedBasis(1),mass3set(:,3),G0tensor(71),G0tensor(76),G0tensor(81),G0tensor(86),M2L1R1,[nMT], &
    G0tensor(91))
  call TI_triangle_red(G2tensor(240),RedBasis(56),mass3set(:,4),G0tensor(96),G0tensor(101),G0tensor(106), &
    G0tensor(111),M2L1R1,[nMB],G0tensor(116))
  call TI_triangle_red(G2tensor(8),RedBasis(7),mass3set(:,5),G0tensor(121),G0tensor(126),G0tensor(131),G0tensor(136),M2L1R1,[nMB], &
    G0tensor(141))
  call TI_triangle_red(G2tensor(243),RedBasis(59),mass3set(:,6),G0tensor(146),G0tensor(151),G0tensor(156), &
    G0tensor(161),M2L1R1,[nMB,nMT],G0tensor(166),G0tensor(171))
  call TI_triangle_red(G2tensor(213),RedBasis(8),mass3set(:,7),G0tensor(176),G0tensor(181),G0tensor(186), &
    G0tensor(191),M2L1R1,[nMB,nMT],G0tensor(196),G0tensor(201))
  call TI_triangle_red(G2tensor(136),RedBasis(10),mass3set(:,8),G0tensor(206),G0tensor(211),G0tensor(216), &
    G0tensor(221),M2L1R1,[nMB],G0tensor(226))
  call TI_triangle_red(G3tensor(23),RedBasis(2),mass3set(:,9),G0tensor(231),G0tensor(236),G0tensor(241), &
    G0tensor(246),M2L1R1,[nMB],G0tensor(251))
  call TI_triangle_red(G2tensor(84),RedBasis(10),mass3set(:,10),G0tensor(256),G0tensor(261),G0tensor(266), &
    G0tensor(271),M2L1R1,[nMW,nMT],G0tensor(276),G0tensor(281))
  call TI_triangle_red(G3tensor(11),RedBasis(2),mass3set(:,11),G0tensor(286),G0tensor(291),G0tensor(296), &
    G0tensor(301),M2L1R1,[nMT],G0tensor(306))
  call TI_triangle_red(G2tensor(93),RedBasis(62),mass3set(:,8),G0tensor(311),G0tensor(316),G0tensor(321), &
    G0tensor(326),M2L1R1,[nMB],G0tensor(331))
  call TI_triangle_red(G2tensor(257),RedBasis(62),mass3set(:,10),G0tensor(336),G0tensor(341),G0tensor(346), &
    G0tensor(351),M2L1R1,[nMW,nMT],G0tensor(356),G0tensor(361))
  call TI_triangle_red(G2tensor(216),RedBasis(4),mass3set(:,12),G0tensor(366),G0tensor(371),G0tensor(376), &
    G0tensor(381),M2L1R1,[nMT],G0tensor(386))
  call TI_triangle_red(G2tensor(314),RedBasis(15),mass3set(:,13),G0tensor(391),G0tensor(396),G0tensor(401), &
    G0tensor(406),M2L1R1,[nMT],G0tensor(411))
  call TI_triangle_red(G2tensor(25),RedBasis(10),mass3set(:,14),G0tensor(416),G0tensor(421),G0tensor(426), &
    G0tensor(431),M2L1R1,[nMH,nMB],G0tensor(436),G0tensor(441))
  call TI_triangle_red(G2tensor(48),RedBasis(10),mass3set(:,15),G0tensor(446),G0tensor(451),G0tensor(456), &
    G0tensor(461),M2L1R1,[nMZ,nMB],G0tensor(466),G0tensor(471))
  call TI_triangle_red(G2tensor(105),RedBasis(62),mass3set(:,14),G0tensor(476),G0tensor(481),G0tensor(486), &
    G0tensor(491),M2L1R1,[nMH,nMB],G0tensor(496),G0tensor(501))
  call TI_triangle_red(G2tensor(141),RedBasis(62),mass3set(:,15),G0tensor(506),G0tensor(511),G0tensor(516), &
    G0tensor(521),M2L1R1,[nMZ,nMB],G0tensor(526),G0tensor(531))
  call TI_triangle_red(G2tensor(55),RedBasis(11),mass3set(:,16),G0tensor(536),G0tensor(541),G0tensor(546), &
    G0tensor(551),M2L1R1,[nMB,nMT],G0tensor(556),G0tensor(561))
  call TI_triangle_red(G2tensor(181),RedBasis(22),mass3set(:,16),G0tensor(566),G0tensor(571),G0tensor(576), &
    G0tensor(581),M2L1R1,[nMB,nMT],G0tensor(586),G0tensor(591))
  call TI_triangle_red(G2tensor(52),RedBasis(1),mass3set(:,13),G0tensor(596),G0tensor(601),G0tensor(606), &
    G0tensor(611),M2L1R1,[nMT],G0tensor(616))
  call TI_triangle_red(G2tensor(300),RedBasis(25),mass3set(:,17),G0tensor(621),G0tensor(626),G0tensor(631), &
    G0tensor(636),M2L1R1,[nMT,nMB],G0tensor(641),G0tensor(646))
  call TI_triangle_red(G2tensor(98),RedBasis(58),mass3set(:,13),G0tensor(651),G0tensor(656),G0tensor(661), &
    G0tensor(666),M2L1R1,[nMT],G0tensor(671))
  call TI_triangle_red(G2tensor(91),RedBasis(58),mass3set(:,18),G0tensor(676),G0tensor(681),G0tensor(686), &
    G0tensor(691),M2L1R1,[nMT,nMH],G0tensor(696),G0tensor(701))
  call TI_triangle_red(G2tensor(338),RedBasis(15),mass3set(:,18),G0tensor(706),G0tensor(711),G0tensor(716), &
    G0tensor(721),M2L1R1,[nMT,nMH],G0tensor(726),G0tensor(731))
  call TI_triangle_red(G2tensor(230),RedBasis(58),mass3set(:,19),G0tensor(736),G0tensor(741),G0tensor(746), &
    G0tensor(751),M2L1R1,[nMT,nMZ],G0tensor(756),G0tensor(761))
  call TI_triangle_red(G2tensor(227),RedBasis(15),mass3set(:,19),G0tensor(766),G0tensor(771),G0tensor(776), &
    G0tensor(781),M2L1R1,[nMT,nMZ],G0tensor(786),G0tensor(791))
  call TI_triangle_red(G2tensor(122),RedBasis(58),mass3set(:,20),G0tensor(796),G0tensor(801),G0tensor(806), &
    G0tensor(811),M2L1R1,[nMB,nMW],G0tensor(816),G0tensor(821))
  call TI_triangle_red(G2tensor(320),RedBasis(15),mass3set(:,20),G0tensor(826),G0tensor(831),G0tensor(836), &
    G0tensor(841),M2L1R1,[nMB,nMW],G0tensor(365),G0tensor(315))
  call TI_triangle_red(G2tensor(15),RedBasis(58),mass3set(:,3),G0tensor(34),G0tensor(14),G0tensor(330),G0tensor(20),M2L1R1,[nMT], &
    G0tensor(480))
  call TI_triangle_red(G2tensor(345),RedBasis(60),mass3set(:,13),G0tensor(415),G0tensor(380),G0tensor(45), &
    G0tensor(35),M2L1R1,[nMT],G0tensor(30))
  call TI_triangle_red(G2tensor(333),RedBasis(60),mass3set(:,18),G0tensor(25),G0tensor(345),G0tensor(295), &
    G0tensor(40),M2L1R1,[nMT,nMH],G0tensor(15),G0tensor(10))
  call TI_triangle_red(G2tensor(40),RedBasis(1),mass3set(:,18),G0tensor(5),G0tensor(527),G0tensor(125), &
    G0tensor(85),M2L1R1,[nMT,nMH],G0tensor(530),G0tensor(525))
  call TI_triangle_red(G2tensor(336),RedBasis(60),mass3set(:,19),G0tensor(515),G0tensor(95),G0tensor(75), &
    G0tensor(547),M2L1R1,[nMT,nMZ],G0tensor(124),G0tensor(114))
  call TI_triangle_red(G2tensor(299),RedBasis(1),mass3set(:,19),G0tensor(104),G0tensor(550),G0tensor(540), &
    G0tensor(535),M2L1R1,[nMT,nMZ],G0tensor(119),G0tensor(109))
  call TI_triangle_red(G2tensor(339),RedBasis(60),mass3set(:,20),G0tensor(94),G0tensor(562),G0tensor(328), &
    G0tensor(129),M2L1R1,[nMB,nMW],G0tensor(820),G0tensor(815))
  call TI_triangle_red(G2tensor(67),RedBasis(1),mass3set(:,20),G0tensor(810),G0tensor(805),G0tensor(590), &
    G0tensor(565),M2L1R1,[nMB,nMW],G0tensor(154),G0tensor(134))
  call TI_triangle_red(G2tensor(348),RedBasis(60),mass3set(:,3),G0tensor(572),G0tensor(139),G0tensor(844), &
    G0tensor(839),M2L1R1,[nMT],G0tensor(834))
  call TI_triangle_red(G2tensor(140),RedBasis(16),mass3set(:,12),G0tensor(829),G0tensor(605),G0tensor(575), &
    G0tensor(164),M2L1R1,[nMT],G0tensor(144))
  call TI_triangle_red(G2tensor(153),RedBasis(7),mass3set(:,21),G0tensor(587),G0tensor(149),G0tensor(602), &
    G0tensor(159),M2L1R1,[nMB,nMH],G0tensor(707),G0tensor(280))
  call TI_triangle_red(G2tensor(177),RedBasis(7),mass3set(:,22),G0tensor(240),G0tensor(13),G0tensor(710), &
    G0tensor(700),M2L1R1,[nMB,nMZ],G0tensor(685),G0tensor(610))
  call TI_triangle_red(G2tensor(41),RedBasis(9),mass3set(:,23),G0tensor(270),G0tensor(205),G0tensor(165), &
    G0tensor(802),M2L1R1,[nMB,nMT],G0tensor(807),G0tensor(812))
  call TI_triangle_red(G2tensor(131),RedBasis(4),mass3set(:,24),G0tensor(817),G0tensor(553),G0tensor(548), &
    G0tensor(543),M2L1R1,[nMB,nMW],G0tensor(358),G0tensor(277))
  call TI_triangle_red(G2tensor(56),RedBasis(4),mass3set(:,25),G0tensor(272),G0tensor(267),G0tensor(262), &
    G0tensor(822),M2L1R1,[nMT],G0tensor(798))
  call TI_triangle_red(G2tensor(127),RedBasis(16),mass3set(:,24),G0tensor(793),G0tensor(757),G0tensor(752), &
    G0tensor(397),M2L1R1,[nMB,nMW],G0tensor(393),G0tensor(825))
  call TI_triangle_red(G2tensor(284),RedBasis(16),mass3set(:,25),G0tensor(580),G0tensor(175),G0tensor(145), &
    G0tensor(748),M2L1R1,[nMT],G0tensor(723))
  call TI_triangle_red(G2tensor(139),RedBasis(6),mass3set(:,2),G0tensor(718),G0tensor(713),G0tensor(122), &
    G0tensor(97),M2L1R1,[nMB],G0tensor(92))
  call TI_triangle_red(G2tensor(99),RedBasis(13),mass3set(:,26),G0tensor(87),G0tensor(162),G0tensor(157), &
    G0tensor(827),M2L1R1,[nMT,nMB],G0tensor(830),G0tensor(660))
  call TI_triangle_red(G2tensor(113),RedBasis(20),mass3set(:,27),G0tensor(250),G0tensor(215),G0tensor(832), &
    G0tensor(835),M2L1R1,[nMT,nMB],G0tensor(670),G0tensor(260))
  call TI_triangle_red(G2tensor(116),RedBasis(21),mass3set(:,28),G0tensor(225),G0tensor(152),G0tensor(147), &
    G0tensor(595),M2L1R1,[nMT,nMB],G0tensor(195),G0tensor(155))
  call TI_triangle_red(G2tensor(133),RedBasis(14),mass3set(:,2),G0tensor(427),G0tensor(392),G0tensor(83), &
    G0tensor(32),M2L1R1,[nMB],G0tensor(142))
  call TI_triangle_red(G2tensor(4),RedBasis(3),mass3set(:,2),G0tensor(137),G0tensor(837),G0tensor(840),G0tensor(842),M2L1R1,[nMB], &
    G0tensor(845))
  call TI_triangle_red(G2tensor(2),RedBasis(62),mass3set(:,29),G0tensor(318),G0tensor(132),G0tensor(127), &
    G0tensor(570),M2L1R1,[nMB],G0tensor(185))
  call TI_triangle_red(G2tensor(20),RedBasis(56),mass3set(:,30),G0tensor(135),G0tensor(357),G0tensor(307), &
    G0tensor(123),M2L1R1,[nMB],G0tensor(12))
  call TI_triangle_red(G2tensor(6),RedBasis(12),mass3set(:,2),G0tensor(332),G0tensor(282),G0tensor(88),G0tensor(2),M2L1R1,[nMB], &
    G0tensor(657))
  call TI_triangle_red(G2tensor(14),RedBasis(10),mass3set(:,29),G0tensor(245),G0tensor(210),G0tensor(3), &
    G0tensor(340),M2L1R1,[nMB],G0tensor(290))
  call TI_triangle_red(G2tensor(47),RedBasis(61),mass3set(:,23),G0tensor(24),G0tensor(4),G0tensor(347), &
    G0tensor(297),M2L1R1,[nMB,nMT],G0tensor(98),G0tensor(7))
  call TI_triangle_red(G2tensor(72),RedBasis(17),mass3set(:,26),G0tensor(667),G0tensor(255),G0tensor(220), &
    G0tensor(8),M2L1R1,[nMT,nMB],G0tensor(355),G0tensor(305))
  call TI_triangle_red(G2tensor(73),RedBasis(14),mass3set(:,31),G0tensor(29),G0tensor(9),G0tensor(637), &
    G0tensor(317),M2L1R1,[nMT,nMW],G0tensor(198),G0tensor(17))
  call TI_triangle_red(G2tensor(5),RedBasis(24),mass3set(:,32),G0tensor(567),G0tensor(180),G0tensor(130), &
    G0tensor(18),M2L1R1,[nMT],G0tensor(325))
  call TI_triangle_red(G2tensor(296),RedBasis(23),mass3set(:,3),G0tensor(39),G0tensor(19),G0tensor(402), &
    G0tensor(367),M2L1R1,[nMT],G0tensor(68))
  call TI_triangle_red(G2tensor(53),RedBasis(3),mass3set(:,5),G0tensor(22),G0tensor(410),G0tensor(375),G0tensor(23),M2L1R1,[nMB], &
    G0tensor(417))
  call TI_triangle_red(G2tensor(88),RedBasis(3),mass3set(:,21),G0tensor(382),G0tensor(78),G0tensor(27), &
    G0tensor(425),M2L1R1,[nMB,nMH],G0tensor(390),G0tensor(28))
  call TI_triangle_red(G2tensor(103),RedBasis(3),mass3set(:,22),G0tensor(435),G0tensor(400),G0tensor(33), &
    G0tensor(597),M2L1R1,[nMB,nMZ],G0tensor(437),G0tensor(158))
  call TI_triangle_red(G2tensor(70),RedBasis(14),mass3set(:,5),G0tensor(37),G0tensor(445),G0tensor(38),G0tensor(773),M2L1R1,[nMB], &
    G0tensor(462))
  call TI_triangle_red(G2tensor(71),RedBasis(12),mass3set(:,5),G0tensor(447),G0tensor(138),G0tensor(42), &
    G0tensor(470),M2L1R1,[nMB],G0tensor(455))
  call TI_triangle_red(G2tensor(341),RedBasis(12),mass3set(:,31),G0tensor(43),G0tensor(475),G0tensor(460), &
    G0tensor(44),M2L1R1,[nMT,nMW],G0tensor(52),G0tensor(47))
  call TI_triangle_red(G2tensor(329),RedBasis(6),mass3set(:,5),G0tensor(792),G0tensor(482),G0tensor(48), &
    G0tensor(487),M2L1R1,[nMB],G0tensor(189))
  call TI_triangle_red(G2tensor(74),RedBasis(6),mass3set(:,31),G0tensor(84),G0tensor(59),G0tensor(49), &
    G0tensor(492),M2L1R1,[nMT,nMW],G0tensor(105),G0tensor(50))
  call TI_triangle_red(G2tensor(79),RedBasis(3),mass3set(:,31),G0tensor(485),G0tensor(53),G0tensor(520), &
    G0tensor(510),M2L1R1,[nMT,nMW],G0tensor(490),G0tensor(194))
  call TI_triangle_red(G2tensor(226),RedBasis(23),mass3set(:,13),G0tensor(74),G0tensor(64),G0tensor(54), &
    G0tensor(495),M2L1R1,[nMT],G0tensor(110))
  call TI_triangle_red(G2tensor(80),RedBasis(24),mass3set(:,33),G0tensor(55),G0tensor(62),G0tensor(57),G0tensor(797),M2L1R1,[nMT], &
    G0tensor(497))
  call TI_triangle_red(G2tensor(85),RedBasis(14),mass3set(:,21),G0tensor(58),G0tensor(502),G0tensor(115), &
    G0tensor(60),M2L1R1,[nMB,nMH],G0tensor(500),G0tensor(63))
  call TI_triangle_red(G2tensor(82),RedBasis(12),mass3set(:,21),G0tensor(505),G0tensor(120),G0tensor(65), &
    G0tensor(772),M2L1R1,[nMB,nMH],G0tensor(82),G0tensor(77))
  call TI_triangle_red(G2tensor(302),RedBasis(14),mass3set(:,22),G0tensor(72),G0tensor(67),G0tensor(507), &
    G0tensor(69),M2L1R1,[nMB,nMZ],G0tensor(512),G0tensor(90))
  call TI_triangle_red(G2tensor(86),RedBasis(12),mass3set(:,22),G0tensor(70),G0tensor(450),G0tensor(430), &
    G0tensor(420),M2L1R1,[nMB,nMZ],G0tensor(412),G0tensor(405))
  call TI_triangle_red(G2tensor(83),RedBasis(6),mass3set(:,21),G0tensor(73),G0tensor(517),G0tensor(79), &
    G0tensor(522),M2L1R1,[nMB,nMH],G0tensor(100),G0tensor(80))
  call TI_triangle_red(G2tensor(229),RedBasis(6),mass3set(:,22),G0tensor(532),G0tensor(89),G0tensor(360), &
    G0tensor(350),M2L1R1,[nMB,nMZ],G0tensor(342),G0tensor(335))
  call TI_triangle_red(G2tensor(106),RedBasis(19),mass3set(:,28),G0tensor(93),G0tensor(537),G0tensor(99), &
    G0tensor(733),M2L1R1,[nMT,nMB],G0tensor(728),G0tensor(107))
  call TI_triangle_red(G2tensor(109),RedBasis(8),mass3set(:,27),G0tensor(102),G0tensor(782),G0tensor(542), &
    G0tensor(103),M2L1R1,[nMT,nMB],G0tensor(545),G0tensor(108))
  call TI_triangle_red(G2tensor(118),RedBasis(16),mass3set(:,34),G0tensor(743),G0tensor(738),G0tensor(117), &
    G0tensor(112),M2L1R1,[nMT,nMH],G0tensor(787),G0tensor(552))
  call TI_triangle_red(G2tensor(124),RedBasis(16),mass3set(:,35),G0tensor(113),G0tensor(555),G0tensor(118), &
    G0tensor(777),M2L1R1,[nMT,nMZ],G0tensor(557),G0tensor(443))
  call TI_triangle_red(G2tensor(137),RedBasis(4),mass3set(:,34),G0tensor(323),G0tensor(128),G0tensor(560), &
    G0tensor(133),M2L1R1,[nMT,nMH],G0tensor(577),G0tensor(170))
  call TI_triangle_red(G2tensor(134),RedBasis(4),mass3set(:,35),G0tensor(140),G0tensor(477),G0tensor(465), &
    G0tensor(143),M2L1R1,[nMT,nMZ],G0tensor(582),G0tensor(458))
  call TI_triangle_red(G2tensor(205),RedBasis(7),mass3set(:,31),G0tensor(453),G0tensor(148),G0tensor(592), &
    G0tensor(190),M2L1R1,[nMT,nMW],G0tensor(150),G0tensor(585))
  call TI_triangle_red(G1tensor(332),RedBasis(60),mass3set(:,36),G0tensor(153),G0tensor(607),G0tensor(200), &
    G0tensor(160),M2L1R1,[nMH,nMT],G0tensor(600),G0tensor(163))
  call TI_triangle_red(G1tensor(657),RedBasis(4),mass3set(:,37),G0tensor(767),G0tensor(762),G0tensor(633), &
    G0tensor(498),M2L1R1,[nMT,nMH],G0tensor(488),G0tensor(483))
  call TI_triangle_red(G1tensor(340),RedBasis(2),mass3set(:,38),G0tensor(432),G0tensor(428),G0tensor(172), &
    G0tensor(167),M2L1R1,[nMH],G0tensor(612))
  call TI_triangle_red(G1tensor(347),RedBasis(60),mass3set(:,39),G0tensor(168),G0tensor(617),G0tensor(169), &
    G0tensor(615),M2L1R1,[nMZ,nMT],G0tensor(173),G0tensor(620))
  call TI_triangle_red(G1tensor(667),RedBasis(4),mass3set(:,40),G0tensor(174),G0tensor(643),G0tensor(638), &
    G0tensor(182),M2L1R1,[nMT,nMZ],G0tensor(177),G0tensor(622))
  call TI_triangle_red(G1tensor(355),RedBasis(2),mass3set(:,41),G0tensor(178),G0tensor(627),G0tensor(179), &
    G0tensor(625),M2L1R1,[nMZ],G0tensor(183))
  call TI_triangle_red(G1tensor(637),RedBasis(25),mass3set(:,42),G0tensor(630),G0tensor(184),G0tensor(618), &
    G0tensor(613),M2L1R1,[nMW,nMB],G0tensor(192),G0tensor(187))
  call TI_triangle_red(G1tensor(567),RedBasis(9),mass3set(:,43),G0tensor(632),G0tensor(473),G0tensor(468), &
    G0tensor(188),M2L1R1,[nMB,nMW],G0tensor(635),G0tensor(193))
  call TI_triangle_red(G1tensor(325),RedBasis(8),mass3set(:,44),G0tensor(788),G0tensor(783),G0tensor(628), &
    G0tensor(623),M2L1R1,[nMW],G0tensor(308))
  call TI_triangle_red(G1tensor(402),RedBasis(58),mass3set(:,36),G0tensor(237),G0tensor(232),G0tensor(227), &
    G0tensor(202),M2L1R1,[nMH,nMT],G0tensor(197),G0tensor(642))
  call TI_triangle_red(G1tensor(410),RedBasis(16),mass3set(:,37),G0tensor(199),G0tensor(705),G0tensor(690), &
    G0tensor(675),M2L1R1,[nMT,nMH],G0tensor(640),G0tensor(203))
  call TI_triangle_red(G1tensor(417),RedBasis(58),mass3set(:,39),G0tensor(695),G0tensor(680),G0tensor(655), &
    G0tensor(645),M2L1R1,[nMZ,nMT],G0tensor(224),G0tensor(214))
  call TI_triangle_red(G1tensor(425),RedBasis(16),mass3set(:,40),G0tensor(204),G0tensor(283),G0tensor(212), &
    G0tensor(207),M2L1R1,[nMT,nMZ],G0tensor(647),G0tensor(373))
  call TI_triangle_red(G1tensor(597),RedBasis(22),mass3set(:,45),G0tensor(288),G0tensor(208),G0tensor(652), &
    G0tensor(444),M2L1R1,[nMW,nMT],G0tensor(293),G0tensor(239))
  call TI_triangle_red(G1tensor(445),RedBasis(19),mass3set(:,46),G0tensor(219),G0tensor(209),G0tensor(650), &
    G0tensor(213),M2L1R1,[nMT,nMW],G0tensor(298),G0tensor(222))
  call TI_triangle_red(G1tensor(773),RedBasis(11),mass3set(:,45),G0tensor(217),G0tensor(662),G0tensor(388), &
    G0tensor(303),M2L1R1,[nMW,nMT],G0tensor(218),G0tensor(665))
  call TI_triangle_red(G1tensor(470),RedBasis(21),mass3set(:,46),G0tensor(223),G0tensor(753),G0tensor(672), &
    G0tensor(228),M2L1R1,[nMT,nMW],G0tensor(677),G0tensor(229))
  call TI_triangle_red(G1tensor(475),RedBasis(20),mass3set(:,44),G0tensor(682),G0tensor(265),G0tensor(230), &
    G0tensor(758),M2L1R1,[nMW],G0tensor(687))
  call TI_triangle_red(G1tensor(66),RedBasis(66),mass3set(:,47),G0tensor(233),G0tensor(692),G0tensor(234), &
    G0tensor(697),M2L1R1,[nMT,nMB,nMH],G0tensor(275),G0tensor(235),G0tensor(702))
  call TI_triangle_red(G1tensor(792),RedBasis(58),mass3set(:,48),G0tensor(398),G0tensor(313),G0tensor(238), &
    G0tensor(533),M2L1R1,[nMH,nMT],G0tensor(333),G0tensor(247))
  call TI_triangle_red(G1tensor(487),RedBasis(57),mass3set(:,6),G0tensor(242),G0tensor(712),G0tensor(408), &
    G0tensor(338),M2L1R1,[nMB,nMT],G0tensor(243),G0tensor(717))
  call TI_triangle_red(G1tensor(492),RedBasis(56),mass3set(:,49),G0tensor(343),G0tensor(279),G0tensor(254), &
    G0tensor(244),M2L1R1,[nMB,nMH],G0tensor(715),G0tensor(248))
  call TI_triangle_red(G1tensor(485),RedBasis(27),mass3set(:,50),G0tensor(745),G0tensor(735),G0tensor(720), &
    G0tensor(269),M2L1R1,[nMB,nMH,nMT],G0tensor(259),G0tensor(249),G0tensor(538))
  call TI_triangle_red(G1tensor(520),RedBasis(26),mass3set(:,7),G0tensor(348),G0tensor(257),G0tensor(252), &
    G0tensor(722),M2L1R1,[nMB,nMT],G0tensor(423),G0tensor(353))
  call TI_triangle_red(G1tensor(102),RedBasis(66),mass3set(:,51),G0tensor(253),G0tensor(725),G0tensor(258), &
    G0tensor(763),M2L1R1,[nMT,nMB,nMZ],G0tensor(727),G0tensor(263),G0tensor(732))
  call TI_triangle_red(G1tensor(797),RedBasis(58),mass3set(:,52),G0tensor(264),G0tensor(750),G0tensor(740), &
    G0tensor(730),M2L1R1,[nMZ,nMT],G0tensor(268),G0tensor(768))
  call TI_triangle_red(G1tensor(502),RedBasis(56),mass3set(:,53),G0tensor(737),G0tensor(273),G0tensor(742), &
    G0tensor(274),M2L1R1,[nMB,nMZ],G0tensor(747),G0tensor(433))
  call TI_triangle_red(G1tensor(500),RedBasis(27),mass3set(:,54),G0tensor(363),G0tensor(278),G0tensor(369), &
    G0tensor(287),M2L1R1,[nMB,nMZ,nMT],G0tensor(284),G0tensor(440),G0tensor(310))
  call TI_triangle_red(G1tensor(772),RedBasis(66),mass3set(:,17),G0tensor(300),G0tensor(292),G0tensor(285), &
    G0tensor(379),M2L1R1,[nMT,nMB],G0tensor(329),G0tensor(324))
  call TI_triangle_red(G1tensor(507),RedBasis(57),mass3set(:,55),G0tensor(314),G0tensor(304),G0tensor(294), &
    G0tensor(289),M2L1R1,[nMH,nMB,nMT],G0tensor(384),G0tensor(302),G0tensor(299))
  call TI_triangle_red(G1tensor(512),RedBasis(56),mass3set(:,56),G0tensor(394),G0tensor(312),G0tensor(309), &
    G0tensor(439),M2L1R1,[nMH,nMB],G0tensor(322),G0tensor(319))
  call TI_triangle_red(G1tensor(450),RedBasis(27),mass3set(:,23),G0tensor(327),G0tensor(320),G0tensor(513), &
    G0tensor(404),M2L1R1,[nMB,nMT],G0tensor(337),G0tensor(334))
  call TI_triangle_red(G1tensor(517),RedBasis(57),mass3set(:,57),G0tensor(459),G0tensor(414),G0tensor(364), &
    G0tensor(354),M2L1R1,[nMZ,nMB,nMT],G0tensor(344),G0tensor(339),G0tensor(523))
  call TI_triangle_red(G1tensor(522),RedBasis(56),mass3set(:,58),G0tensor(419),G0tensor(352),G0tensor(349), &
    G0tensor(528),M2L1R1,[nMZ,nMB],G0tensor(429),G0tensor(362))
  call TI_triangle_red(G1tensor(532),RedBasis(59),mass3set(:,55),G0tensor(359),G0tensor(372),G0tensor(368), &
    G0tensor(395),M2L1R1,[nMH,nMB,nMT],G0tensor(385),G0tensor(377),G0tensor(370))
  call TI_triangle_red(G1tensor(537),RedBasis(59),mass3set(:,57),G0tensor(399),G0tensor(389),G0tensor(378), &
    G0tensor(374),M2L1R1,[nMZ,nMB,nMT],G0tensor(387),G0tensor(383),G0tensor(508))
  call TI_triangle_red(G1tensor(733),RedBasis(25),mass3set(:,47),G0tensor(407),G0tensor(403),G0tensor(454), &
    G0tensor(434),M2L1R1,[nMT,nMB,nMH],G0tensor(424),G0tensor(413),G0tensor(409))
  call TI_triangle_red(G1tensor(782),RedBasis(60),mass3set(:,48),G0tensor(518),G0tensor(422),G0tensor(418), &
    G0tensor(442),M2L1R1,[nMH,nMT],G0tensor(438),G0tensor(452))
  call TI_triangle_red(G1tensor(545),RedBasis(9),mass3set(:,50),G0tensor(448),G0tensor(457),G0tensor(449), &
    G0tensor(573),M2L1R1,[nMB,nMH,nMT],G0tensor(467),G0tensor(463),G0tensor(614))
  call TI_triangle_red(G1tensor(743),RedBasis(25),mass3set(:,51),G0tensor(578),G0tensor(472),G0tensor(464), &
    G0tensor(478),M2L1R1,[nMT,nMB,nMZ],G0tensor(469),G0tensor(479),G0tensor(474))
  call TI_triangle_red(G1tensor(787),RedBasis(60),mass3set(:,52),G0tensor(544),G0tensor(493),G0tensor(484), &
    G0tensor(594),M2L1R1,[nMZ,nMT],G0tensor(589),G0tensor(549))
  call TI_triangle_red(G1tensor(555),RedBasis(9),mass3set(:,54),G0tensor(529),G0tensor(504),G0tensor(494), &
    G0tensor(489),M2L1R1,[nMB,nMZ,nMT],G0tensor(554),G0tensor(503),G0tensor(499))
  call TI_triangle_red(G1tensor(777),RedBasis(11),mass3set(:,59),G0tensor(814),G0tensor(534),G0tensor(514), &
    G0tensor(509),M2L1R1,[nMW,nMB],G0tensor(819),G0tensor(539))
  call TI_triangle_red(G1tensor(577),RedBasis(9),mass3set(:,60),G0tensor(524),G0tensor(519),G0tensor(563), &
    G0tensor(558),M2L1R1,[nMW,nMT],G0tensor(624),G0tensor(568))
  call TI_triangle_red(G1tensor(582),RedBasis(22),mass3set(:,59),G0tensor(559),G0tensor(629),G0tensor(569), &
    G0tensor(564),M2L1R1,[nMW,nMB],G0tensor(619),G0tensor(579))
  call TI_triangle_red(G1tensor(592),RedBasis(61),mass3set(:,43),G0tensor(574),G0tensor(588),G0tensor(583), &
    G0tensor(634),M2L1R1,[nMB,nMW],G0tensor(593),G0tensor(584))
  call TI_triangle_red(G1tensor(607),RedBasis(61),mass3set(:,60),G0tensor(603),G0tensor(598),G0tensor(639), &
    G0tensor(608),M2L1R1,[nMW,nMT],G0tensor(599),G0tensor(644))
  call TI_triangle_red(G1tensor(767),RedBasis(28),mass3set(:,16),G0tensor(609),G0tensor(604),G0tensor(778), &
    G0tensor(703),M2L1R1,[nMB,nMT],G0tensor(663),G0tensor(653))
  call TI_triangle_red(G1tensor(612),RedBasis(64),mass3set(:,42),G0tensor(648),G0tensor(714),G0tensor(658), &
    G0tensor(649),M2L1R1,[nMW,nMB],G0tensor(719),G0tensor(709))
  call TI_triangle_red(G1tensor(617),RedBasis(63),mass3set(:,61),G0tensor(669),G0tensor(659),G0tensor(654), &
    G0tensor(724),M2L1R1,[nMW,nMT,nMB],G0tensor(668),G0tensor(664),G0tensor(678))
  call TI_triangle_red(G1tensor(615),RedBasis(30),mass3set(:,28),G0tensor(673),G0tensor(729),G0tensor(683), &
    G0tensor(674),M2L1R1,[nMT,nMB],G0tensor(734),G0tensor(684))
  call TI_triangle_red(G1tensor(620),RedBasis(29),mass3set(:,27),G0tensor(679),G0tensor(693),G0tensor(688), &
    G0tensor(739),M2L1R1,[nMT,nMB],G0tensor(698),G0tensor(689))
  call TI_triangle_red(G1tensor(643),RedBasis(28),mass3set(:,62),G0tensor(744),G0tensor(699),G0tensor(694), &
    G0tensor(749),M2L1R1,[nMT,nMB,nMW],G0tensor(708),G0tensor(704),G0tensor(754))
  call TI_triangle_red(G1tensor(622),RedBasis(64),mass3set(:,63),G0tensor(765),G0tensor(755),G0tensor(759), &
    G0tensor(770),M2L1R1,[nMW,nMT],G0tensor(760),G0tensor(764))
  call TI_triangle_red(G1tensor(627),RedBasis(63),mass3set(:,6),G0tensor(769),G0tensor(774),G0tensor(775), &
    G0tensor(779),M2L1R1,[nMB,nMT],G0tensor(780),G0tensor(794))
  call TI_triangle_red(G1tensor(625),RedBasis(30),mass3set(:,64),G0tensor(784),G0tensor(785),G0tensor(799), &
    G0tensor(789),M2L1R1,[nMB,nMW,nMT],G0tensor(790),G0tensor(795),G0tensor(800))
  call TI_triangle_red(G1tensor(630),RedBasis(29),mass3set(:,7),G0tensor(803),G0tensor(804),G0tensor(808), &
    G0tensor(809),M2L1R1,[nMB,nMT],G0tensor(813),G0tensor(818))
  call TI_triangle_red(G1tensor(618),RedBasis(31),mass3set(:,62),G0tensor(823),G0tensor(824),G0tensor(828), &
    G0tensor(833),M2L1R1,[nMT,nMB,nMW],G0tensor(838),G0tensor(843),G0tensor(846))
  call TI_triangle_red(G1tensor(632),RedBasis(25),mass3set(:,63),G0tensor(847),G0tensor(848),G0tensor(849), &
    G0tensor(850),M2L1R1,[nMW,nMT],G0tensor(851),G0tensor(852))
  call TI_triangle_red(G1tensor(635),RedBasis(32),mass3set(:,64),G0tensor(853),G0tensor(854),G0tensor(855), &
    G0tensor(856),M2L1R1,[nMB,nMW,nMT],G0tensor(857),G0tensor(858),G0tensor(859))
  call TI_triangle_red(G1tensor(788),RedBasis(31),mass3set(:,16),G0tensor(860),G0tensor(861),G0tensor(862), &
    G0tensor(863),M2L1R1,[nMB,nMT],G0tensor(864),G0tensor(865))
  call TI_triangle_red(G1tensor(642),RedBasis(57),mass3set(:,61),G0tensor(866),G0tensor(867),G0tensor(868), &
    G0tensor(869),M2L1R1,[nMW,nMT,nMB],G0tensor(870),G0tensor(871),G0tensor(872))
  call TI_triangle_red(G1tensor(705),RedBasis(32),mass3set(:,28),G0tensor(873),G0tensor(874),G0tensor(875), &
    G0tensor(876),M2L1R1,[nMT,nMB],G0tensor(877),G0tensor(878))
  call TI_triangle_red(G1tensor(695),RedBasis(26),mass3set(:,27),G0tensor(879),G0tensor(880),G0tensor(881), &
    G0tensor(882),M2L1R1,[nMT,nMB],G0tensor(883),G0tensor(884))
  call TI_triangle_red(G1tensor(283),RedBasis(31),mass3set(:,65),G0tensor(885),G0tensor(886),G0tensor(887), &
    G0tensor(888),M2L1R1,[nMB,nMT,nMH],G0tensor(889),G0tensor(890),G0tensor(891))
  call TI_triangle_red(G1tensor(647),RedBasis(6),mass3set(:,66),G0tensor(892),G0tensor(893),G0tensor(894), &
    G0tensor(895),M2L1R1,[nMH,nMB],G0tensor(896),G0tensor(897))
  call TI_triangle_red(G1tensor(652),RedBasis(5),mass3set(:,26),G0tensor(898),G0tensor(899),G0tensor(900), &
    G0tensor(901),M2L1R1,[nMT,nMB],G0tensor(902),G0tensor(903))
  call TI_triangle_red(G1tensor(650),RedBasis(32),mass3set(:,67),G0tensor(904),G0tensor(905),G0tensor(906), &
    G0tensor(907),M2L1R1,[nMT,nMH,nMB],G0tensor(908),G0tensor(909),G0tensor(910))
  call TI_triangle_red(G1tensor(298),RedBasis(31),mass3set(:,68),G0tensor(911),G0tensor(912),G0tensor(913), &
    G0tensor(914),M2L1R1,[nMB,nMT,nMZ],G0tensor(915),G0tensor(916),G0tensor(917))
  call TI_triangle_red(G1tensor(662),RedBasis(6),mass3set(:,69),G0tensor(918),G0tensor(919),G0tensor(920), &
    G0tensor(921),M2L1R1,[nMZ,nMB],G0tensor(922),G0tensor(923))
  call TI_triangle_red(G1tensor(665),RedBasis(32),mass3set(:,70),G0tensor(924),G0tensor(925),G0tensor(926), &
    G0tensor(927),M2L1R1,[nMT,nMZ,nMB],G0tensor(928),G0tensor(929),G0tensor(930))
  call TI_triangle_red(G1tensor(753),RedBasis(6),mass3set(:,71),G0tensor(931),G0tensor(932),G0tensor(933), &
    G0tensor(934),M2L1R1,[nMH,nMB],G0tensor(935),G0tensor(936))
  call TI_triangle_red(G1tensor(677),RedBasis(5),mass3set(:,72),G0tensor(937),G0tensor(938),G0tensor(939), &
    G0tensor(940),M2L1R1,[nMH,nMT,nMB],G0tensor(941),G0tensor(942),G0tensor(943))
  call TI_triangle_red(G1tensor(682),RedBasis(4),mass3set(:,73),G0tensor(944),G0tensor(945),G0tensor(946), &
    G0tensor(947),M2L1R1,[nMH,nMT],G0tensor(948),G0tensor(949))
  call TI_triangle_red(G1tensor(758),RedBasis(6),mass3set(:,74),G0tensor(950),G0tensor(951),G0tensor(952), &
    G0tensor(953),M2L1R1,[nMZ,nMB],G0tensor(954),G0tensor(955))
  call TI_triangle_red(G1tensor(692),RedBasis(5),mass3set(:,75),G0tensor(956),G0tensor(957),G0tensor(958), &
    G0tensor(959),M2L1R1,[nMZ,nMT,nMB],G0tensor(960),G0tensor(961),G0tensor(962))
  call TI_triangle_red(G1tensor(697),RedBasis(4),mass3set(:,76),G0tensor(963),G0tensor(964),G0tensor(965), &
    G0tensor(966),M2L1R1,[nMZ,nMT],G0tensor(967),G0tensor(968))
  call TI_triangle_red(G1tensor(533),RedBasis(11),mass3set(:,65),G0tensor(969),G0tensor(970),G0tensor(971), &
    G0tensor(972),M2L1R1,[nMB,nMT,nMH],G0tensor(973),G0tensor(974),G0tensor(975))
  call TI_triangle_red(G1tensor(712),RedBasis(14),mass3set(:,66),G0tensor(976),G0tensor(977),G0tensor(978), &
    G0tensor(979),M2L1R1,[nMH,nMB],G0tensor(980),G0tensor(981))
  call TI_triangle_red(G1tensor(715),RedBasis(21),mass3set(:,67),G0tensor(982),G0tensor(983),G0tensor(984), &
    G0tensor(985),M2L1R1,[nMT,nMH,nMB],G0tensor(986),G0tensor(987),G0tensor(988))
  call TI_triangle_red(G1tensor(538),RedBasis(11),mass3set(:,68),G0tensor(989),G0tensor(990),G0tensor(991), &
    G0tensor(992),M2L1R1,[nMB,nMT,nMZ],G0tensor(993),G0tensor(994),G0tensor(995))
  call TI_triangle_red(G1tensor(722),RedBasis(14),mass3set(:,69),G0tensor(996),G0tensor(997),G0tensor(998), &
    G0tensor(999),M2L1R1,[nMZ,nMB],G0tensor(1000),G0tensor(1001))
  call TI_triangle_red(G1tensor(725),RedBasis(21),mass3set(:,70),G0tensor(1002),G0tensor(1003),G0tensor(1004), &
    G0tensor(1005),M2L1R1,[nMT,nMZ,nMB],G0tensor(1006),G0tensor(1007),G0tensor(1008))
  call TI_triangle_red(G1tensor(763),RedBasis(14),mass3set(:,71),G0tensor(1009),G0tensor(1010),G0tensor(1011), &
    G0tensor(1012),M2L1R1,[nMH,nMB],G0tensor(1013),G0tensor(1014))
  call TI_triangle_red(G1tensor(732),RedBasis(13),mass3set(:,72),G0tensor(1015),G0tensor(1016),G0tensor(1017), &
    G0tensor(1018),M2L1R1,[nMH,nMT,nMB],G0tensor(1019),G0tensor(1020),G0tensor(1021))
  call TI_triangle_red(G1tensor(768),RedBasis(14),mass3set(:,74),G0tensor(1022),G0tensor(1023),G0tensor(1024), &
    G0tensor(1025),M2L1R1,[nMZ,nMB],G0tensor(1026),G0tensor(1027))
  call TI_triangle_red(G1tensor(742),RedBasis(13),mass3set(:,75),G0tensor(1028),G0tensor(1029),G0tensor(1030), &
    G0tensor(1031),M2L1R1,[nMZ,nMT,nMB],G0tensor(1032),G0tensor(1033),G0tensor(1034))
  call TI_triangle_red(G1tensor(369),RedBasis(62),mass3set(:,77),G0tensor(1035),G0tensor(1036),G0tensor(1037), &
    G0tensor(1038),M2L1R1,[nMB,nMH],G0tensor(1039),G0tensor(1040))
  call TI_triangle_red(G1tensor(440),RedBasis(65),mass3set(:,23),G0tensor(1041),G0tensor(1042),G0tensor(1043), &
    G0tensor(1044),M2L1R1,[nMB,nMT],G0tensor(1045),G0tensor(1046))
  call TI_triangle_red(G1tensor(384),RedBasis(62),mass3set(:,78),G0tensor(1047),G0tensor(1048),G0tensor(1049), &
    G0tensor(1050),M2L1R1,[nMB,nMZ],G0tensor(1051),G0tensor(1052))
  call TI_triangle_red(G1tensor(439),RedBasis(59),mass3set(:,79),G0tensor(1053),G0tensor(1054),G0tensor(1055), &
    G0tensor(1056),M2L1R1,[nMB,nMW],G0tensor(1057),G0tensor(1058))
  call TI_triangle_red(G1tensor(513),RedBasis(10),mass3set(:,77),G0tensor(1059),G0tensor(1060),G0tensor(1061), &
    G0tensor(1062),M2L1R1,[nMB,nMH],G0tensor(1063),G0tensor(1064))
  call TI_triangle_red(G1tensor(523),RedBasis(10),mass3set(:,78),G0tensor(1065),G0tensor(1066),G0tensor(1067), &
    G0tensor(1068),M2L1R1,[nMB,nMZ],G0tensor(1069),G0tensor(1070))
  call TI_triangle_red(G1tensor(372),RedBasis(22),mass3set(:,65),G0tensor(1071),G0tensor(1072),G0tensor(1073), &
    G0tensor(1074),M2L1R1,[nMB,nMT,nMH],G0tensor(1075),G0tensor(1076),G0tensor(1077))
  call TI_triangle_red(G1tensor(387),RedBasis(22),mass3set(:,68),G0tensor(1078),G0tensor(1079),G0tensor(1080), &
    G0tensor(1081),M2L1R1,[nMB,nMT,nMZ],G0tensor(1082),G0tensor(1083),G0tensor(1084))
  call TI_triangle_red(G1tensor(508),RedBasis(28),mass3set(:,65),G0tensor(1085),G0tensor(1086),G0tensor(1087), &
    G0tensor(1088),M2L1R1,[nMB,nMT,nMH],G0tensor(1089),G0tensor(1090),G0tensor(1091))
  call TI_triangle_red(G1tensor(454),RedBasis(18),mass3set(:,26),G0tensor(1092),G0tensor(1093),G0tensor(1094), &
    G0tensor(1095),M2L1R1,[nMT,nMB],G0tensor(1096),G0tensor(1097))
  call TI_triangle_red(G1tensor(518),RedBasis(28),mass3set(:,68),G0tensor(1098),G0tensor(1099),G0tensor(1100), &
    G0tensor(1101),M2L1R1,[nMB,nMT,nMZ],G0tensor(1102),G0tensor(1103),G0tensor(1104))
  call TI_triangle_red(G1tensor(442),RedBasis(66),mass3set(:,80),G0tensor(1105),G0tensor(1106),G0tensor(1107), &
    G0tensor(1108),M2L1R1,[nMB,nMT,nMW],G0tensor(1109),G0tensor(1110),G0tensor(1111))
  call TI_triangle_red(G1tensor(452),RedBasis(33),mass3set(:,80),G0tensor(1112),G0tensor(1113),G0tensor(1114), &
    G0tensor(1115),M2L1R1,[nMB,nMT,nMW],G0tensor(1116),G0tensor(1117),G0tensor(1118))
  call TI_triangle_red(G1tensor(457),RedBasis(67),mass3set(:,79),G0tensor(1119),G0tensor(1120),G0tensor(1121), &
    G0tensor(1122),M2L1R1,[nMB,nMW],G0tensor(1123),G0tensor(1124))
  call TI_triangle_red(G1tensor(614),RedBasis(13),mass3set(:,81),G0tensor(1125),G0tensor(1126),G0tensor(1127), &
    G0tensor(1128),M2L1R1,[nMT,nMW],G0tensor(1129),G0tensor(1130))
  call TI_triangle_red(G1tensor(544),RedBasis(10),mass3set(:,82),G0tensor(1131),G0tensor(1132),G0tensor(1133), &
    G0tensor(1134),M2L1R1,[nMB,nMH],G0tensor(1135),G0tensor(1136))
  call TI_triangle_red(G1tensor(554),RedBasis(10),mass3set(:,83),G0tensor(1137),G0tensor(1138),G0tensor(1139), &
    G0tensor(1140),M2L1R1,[nMB,nMZ],G0tensor(1141),G0tensor(1142))
  call TI_triangle_red(G1tensor(624),RedBasis(13),mass3set(:,84),G0tensor(1143),G0tensor(1144),G0tensor(1145), &
    G0tensor(1146),M2L1R1,[nMB,nMW],G0tensor(1147),G0tensor(1148))
  call TI_triangle_red(G1tensor(634),RedBasis(17),mass3set(:,84),G0tensor(1149),G0tensor(1150),G0tensor(1151), &
    G0tensor(1152),M2L1R1,[nMB,nMW],G0tensor(1153),G0tensor(1154))
  call TI_triangle_red(G1tensor(639),RedBasis(17),mass3set(:,81),G0tensor(1155),G0tensor(1156),G0tensor(1157), &
    G0tensor(1158),M2L1R1,[nMT,nMW],G0tensor(1159),G0tensor(1160))
  call TI_triangle_red(G1tensor(778),RedBasis(33),mass3set(:,17),G0tensor(1161),G0tensor(1162),G0tensor(1163), &
    G0tensor(1164),M2L1R1,[nMT,nMB],G0tensor(1165),G0tensor(1166))
  call TI_triangle_red(G1tensor(714),RedBasis(24),mass3set(:,85),G0tensor(1167),G0tensor(1168),G0tensor(1169), &
    G0tensor(1170),M2L1R1,[nMT,nMH],G0tensor(1171),G0tensor(1172))
  call TI_triangle_red(G1tensor(724),RedBasis(24),mass3set(:,86),G0tensor(1173),G0tensor(1174),G0tensor(1175), &
    G0tensor(1176),M2L1R1,[nMT,nMZ],G0tensor(1177),G0tensor(1178))
  call TI_triangle_red(G1tensor(678),RedBasis(33),mass3set(:,47),G0tensor(1179),G0tensor(1180),G0tensor(1181), &
    G0tensor(1182),M2L1R1,[nMT,nMB,nMH],G0tensor(1183),G0tensor(1184),G0tensor(1185))
  call TI_triangle_red(G1tensor(729),RedBasis(24),mass3set(:,87),G0tensor(1186),G0tensor(1187),G0tensor(1188), &
    G0tensor(1189),M2L1R1,[nMT,nMH],G0tensor(1190),G0tensor(1191))
  call TI_triangle_red(G1tensor(734),RedBasis(23),mass3set(:,18),G0tensor(1192),G0tensor(1193),G0tensor(1194), &
    G0tensor(1195),M2L1R1,[nMT,nMH],G0tensor(1196),G0tensor(1197))
  call TI_triangle_red(G1tensor(693),RedBasis(33),mass3set(:,51),G0tensor(1198),G0tensor(1199),G0tensor(1200), &
    G0tensor(1201),M2L1R1,[nMT,nMB,nMZ],G0tensor(1202),G0tensor(1203),G0tensor(1204))
  call TI_triangle_red(G1tensor(739),RedBasis(24),mass3set(:,88),G0tensor(1205),G0tensor(1206),G0tensor(1207), &
    G0tensor(1208),M2L1R1,[nMT,nMZ],G0tensor(1209),G0tensor(1210))
  call TI_triangle_red(G1tensor(744),RedBasis(23),mass3set(:,19),G0tensor(1211),G0tensor(1212),G0tensor(1213), &
    G0tensor(1214),M2L1R1,[nMT,nMZ],G0tensor(1215),G0tensor(1216))
  call TI_triangle_red(G1tensor(754),RedBasis(17),mass3set(:,72),G0tensor(1217),G0tensor(1218),G0tensor(1219), &
    G0tensor(1220),M2L1R1,[nMH,nMT,nMB],G0tensor(1221),G0tensor(1222),G0tensor(1223))
  call TI_triangle_red(G1tensor(765),RedBasis(16),mass3set(:,73),G0tensor(1224),G0tensor(1225),G0tensor(1226), &
    G0tensor(1227),M2L1R1,[nMH,nMT],G0tensor(1228),G0tensor(1229))
  call TI_triangle_red(G1tensor(759),RedBasis(17),mass3set(:,75),G0tensor(1230),G0tensor(1231),G0tensor(1232), &
    G0tensor(1233),M2L1R1,[nMZ,nMT,nMB],G0tensor(1234),G0tensor(1235),G0tensor(1236))
  call TI_triangle_red(G1tensor(770),RedBasis(16),mass3set(:,76),G0tensor(1237),G0tensor(1238),G0tensor(1239), &
    G0tensor(1240),M2L1R1,[nMZ,nMT],G0tensor(1241),G0tensor(1242))
  call TI_triangle_red(G1tensor(764),RedBasis(18),mass3set(:,72),G0tensor(1243),G0tensor(1244),G0tensor(1245), &
    G0tensor(1246),M2L1R1,[nMH,nMT,nMB],G0tensor(1247),G0tensor(1248),G0tensor(1249))
  call TI_triangle_red(G1tensor(769),RedBasis(18),mass3set(:,75),G0tensor(1250),G0tensor(1251),G0tensor(1252), &
    G0tensor(1253),M2L1R1,[nMZ,nMT,nMB],G0tensor(1254),G0tensor(1255),G0tensor(1256))
  call TI_triangle_red(G1tensor(774),RedBasis(5),mass3set(:,89),G0tensor(1257),G0tensor(1258),G0tensor(1259), &
    G0tensor(1260),M2L1R1,[nMW,nMB,nMT],G0tensor(1261),G0tensor(1262),G0tensor(1263))
  call TI_triangle_red(G1tensor(775),RedBasis(19),mass3set(:,90),G0tensor(1264),G0tensor(1265),G0tensor(1266), &
    G0tensor(1267),M2L1R1,[nMW,nMB],G0tensor(1268),G0tensor(1269))
  call TI_triangle_red(G1tensor(779),RedBasis(67),mass3set(:,91),G0tensor(1270),G0tensor(1271),G0tensor(1272), &
    G0tensor(1273),M2L1R1,[nMT,nMW],G0tensor(1274),G0tensor(1275))
  call TI_triangle_red(G1tensor(780),RedBasis(27),mass3set(:,92),G0tensor(1276),G0tensor(1277),G0tensor(1278), &
    G0tensor(1279),M2L1R1,[nMT,nMW,nMB],G0tensor(1280),G0tensor(1281),G0tensor(1282))
  call TI_triangle_red(G1tensor(794),RedBasis(62),mass3set(:,82),G0tensor(1283),G0tensor(1284),G0tensor(1285), &
    G0tensor(1286),M2L1R1,[nMB,nMH],G0tensor(1287),G0tensor(1288))
  call TI_triangle_red(G1tensor(785),RedBasis(65),mass3set(:,50),G0tensor(1289),G0tensor(1290),G0tensor(1291), &
    G0tensor(1292),M2L1R1,[nMB,nMH,nMT],G0tensor(1293),G0tensor(1294),G0tensor(1295))
  call TI_triangle_red(G1tensor(799),RedBasis(62),mass3set(:,83),G0tensor(1296),G0tensor(1297),G0tensor(1298), &
    G0tensor(1299),M2L1R1,[nMB,nMZ],G0tensor(1300),G0tensor(1301))
  call TI_triangle_red(G1tensor(790),RedBasis(65),mass3set(:,54),G0tensor(1302),G0tensor(1303),G0tensor(1304), &
    G0tensor(1305),M2L1R1,[nMB,nMZ,nMT],G0tensor(1306),G0tensor(1307),G0tensor(1308))
  call TI_triangle_red(G1tensor(795),RedBasis(61),mass3set(:,50),G0tensor(1309),G0tensor(1310),G0tensor(1311), &
    G0tensor(1312),M2L1R1,[nMB,nMH,nMT],G0tensor(1313),G0tensor(1314),G0tensor(1315))
  call TI_triangle_red(G1tensor(800),RedBasis(61),mass3set(:,54),G0tensor(1316),G0tensor(1317),G0tensor(1318), &
    G0tensor(1319),M2L1R1,[nMB,nMZ,nMT],G0tensor(1320),G0tensor(1321),G0tensor(1322))
  call ol_merge_tensors(T0sum(170),[G0tensor(1)])
  call ol_merge_tensors(T0sum(171),[G0tensor(21)])
  call ol_merge_tensors(T0sum(172),[G0tensor(46)])
  call ol_merge_tensors(T0sum(173),[G0tensor(71)])
  call ol_merge_tensors(T0sum(174),[G0tensor(96)])
  call ol_merge_tensors(T0sum(175),[G0tensor(121)])
  call ol_merge_tensors(T0sum(176),[G0tensor(146)])
  call ol_merge_tensors(T0sum(177),[G0tensor(176)])
  call ol_merge_tensors(T0sum(178),[G0tensor(206)])
  call ol_merge_tensors(T0sum(179),[G0tensor(231)])
  call ol_merge_tensors(T0sum(180),[G0tensor(256)])
  call ol_merge_tensors(T0sum(181),[G0tensor(286)])
  call ol_merge_tensors(T0sum(182),[G0tensor(311)])
  call ol_merge_tensors(T0sum(183),[G0tensor(336)])
  call ol_merge_tensors(T0sum(184),[G0tensor(366)])
  call ol_merge_tensors(T0sum(185),[G0tensor(391)])
  call ol_merge_tensors(T0sum(186),[G0tensor(416)])
  call ol_merge_tensors(T0sum(187),[G0tensor(446)])
  call ol_merge_tensors(T0sum(188),[G0tensor(476)])
  call ol_merge_tensors(T0sum(189),[G0tensor(506)])
  call ol_merge_tensors(T0sum(190),[G0tensor(536)])
  call ol_merge_tensors(T0sum(191),[G0tensor(566)])
  call ol_merge_tensors(T0sum(192),[G0tensor(596)])
  call ol_merge_tensors(T0sum(193),[G0tensor(621)])
  call ol_merge_tensors(T0sum(194),[G0tensor(651)])
  call ol_merge_tensors(T0sum(195),[G0tensor(676)])
  call ol_merge_tensors(T0sum(196),[G0tensor(706)])
  call ol_merge_tensors(T0sum(197),[G0tensor(736)])
  call ol_merge_tensors(T0sum(198),[G0tensor(766)])
  call ol_merge_tensors(T0sum(199),[G0tensor(796)])
  call ol_merge_tensors(T0sum(200),[G0tensor(826)])
  call ol_merge_tensors(T0sum(201),[G0tensor(34)])
  call ol_merge_tensors(T0sum(202),[G0tensor(415)])
  call ol_merge_tensors(T0sum(203),[G0tensor(25)])
  call ol_merge_tensors(T0sum(204),[G0tensor(5)])
  call ol_merge_tensors(T0sum(205),[G0tensor(515)])
  call ol_merge_tensors(T0sum(206),[G0tensor(104)])
  call ol_merge_tensors(T0sum(207),[G0tensor(94)])
  call ol_merge_tensors(T0sum(208),[G0tensor(810)])
  call ol_merge_tensors(T0sum(209),[G0tensor(572)])
  call ol_merge_tensors(T0sum(210),[G0tensor(153)])
  call ol_merge_tensors(T0sum(211),[G0tensor(767)])
  call ol_merge_tensors(T0sum(212),[G0tensor(432)])
  call ol_merge_tensors(T0sum(213),[G0tensor(168)])
  call ol_merge_tensors(T0sum(214),[G0tensor(174)])
  call ol_merge_tensors(T0sum(215),[G0tensor(178)])
  call ol_merge_tensors(T0sum(216),[G0tensor(630)])
  call ol_merge_tensors(T0sum(217),[G0tensor(632)])
  call ol_merge_tensors(T0sum(218),[G0tensor(788)])
  call ol_merge_tensors(T0sum(219),[G0tensor(237)])
  call ol_merge_tensors(T0sum(220),[G0tensor(199)])
  call ol_merge_tensors(T0sum(221),[G0tensor(695)])
  call ol_merge_tensors(T0sum(222),[G0tensor(204)])
  call ol_merge_tensors(T0sum(223),[G0tensor(829)])
  call ol_merge_tensors(T0sum(224),[G0tensor(288)])
  call ol_merge_tensors(T0sum(225),[G0tensor(219)])
  call ol_merge_tensors(T0sum(226),[G0tensor(217)])
  call ol_merge_tensors(T0sum(227),[G0tensor(223)])
  call ol_merge_tensors(T0sum(228),[G0tensor(682)])
  call ol_merge_tensors(T0sum(229),[G0tensor(233)])
  call ol_merge_tensors(T0sum(230),[G0tensor(398)])
  call ol_merge_tensors(T0sum(231),[G0tensor(242)])
  call ol_merge_tensors(T0sum(232),[G0tensor(343)])
  call ol_merge_tensors(T0sum(233),[G0tensor(745)])
  call ol_merge_tensors(T0sum(234),[G0tensor(348)])
  call ol_merge_tensors(T0sum(235),[G0tensor(587)])
  call ol_merge_tensors(T0sum(236),[G0tensor(253)])
  call ol_merge_tensors(T0sum(237),[G0tensor(264)])
  call ol_merge_tensors(T0sum(238),[G0tensor(737)])
  call ol_merge_tensors(T0sum(239),[G0tensor(363)])
  call ol_merge_tensors(T0sum(240),[G0tensor(240)])
  call ol_merge_tensors(T0sum(241),[G0tensor(300)])
  call ol_merge_tensors(T0sum(242),[G0tensor(314)])
  call ol_merge_tensors(T0sum(243),[G0tensor(394)])
  call ol_merge_tensors(T0sum(244),[G0tensor(327)])
  call ol_merge_tensors(T0sum(245),[G0tensor(459)])
  call ol_merge_tensors(T0sum(246),[G0tensor(419)])
  call ol_merge_tensors(T0sum(247),[G0tensor(359)])
  call ol_merge_tensors(T0sum(248),[G0tensor(270)])
  call ol_merge_tensors(T0sum(249),[G0tensor(399)])
  call ol_merge_tensors(T0sum(250),[G0tensor(407)])
  call ol_merge_tensors(T0sum(251),[G0tensor(518)])
  call ol_merge_tensors(T0sum(252),[G0tensor(448)])
  call ol_merge_tensors(T0sum(253),[G0tensor(578)])
  call ol_merge_tensors(T0sum(254),[G0tensor(544)])
  call ol_merge_tensors(T0sum(255),[G0tensor(529)])
  call ol_merge_tensors(T0sum(256),[G0tensor(814)])
  call ol_merge_tensors(T0sum(257),[G0tensor(817)])
  call ol_merge_tensors(T0sum(258),[G0tensor(524)])
  call ol_merge_tensors(T0sum(259),[G0tensor(272)])
  call ol_merge_tensors(T0sum(260),[G0tensor(559)])
  call ol_merge_tensors(T0sum(261),[G0tensor(574)])
  call ol_merge_tensors(T0sum(262),[G0tensor(793)])
  call ol_merge_tensors(T0sum(263),[G0tensor(603)])
  call ol_merge_tensors(T0sum(264),[G0tensor(580)])
  call ol_merge_tensors(T0sum(265),[G0tensor(609)])
  call ol_merge_tensors(T0sum(266),[G0tensor(648)])
  call ol_merge_tensors(T0sum(267),[G0tensor(669)])
  call ol_merge_tensors(T0sum(268),[G0tensor(673)])
  call ol_merge_tensors(T0sum(269),[G0tensor(679)])
  call ol_merge_tensors(T0sum(270),[G0tensor(744)])
  call ol_merge_tensors(T0sum(271),[G0tensor(765)])
  call ol_merge_tensors(T0sum(272),[G0tensor(769)])
  call ol_merge_tensors(T0sum(273),[G0tensor(784)])
  call ol_merge_tensors(T0sum(274),[G0tensor(803)])
  call ol_merge_tensors(T0sum(275),[G0tensor(823)])
  call ol_merge_tensors(T0sum(276),[G0tensor(847)])
  call ol_merge_tensors(T0sum(277),[G0tensor(853)])
  call ol_merge_tensors(T0sum(278),[G0tensor(860)])
  call ol_merge_tensors(T0sum(279),[G0tensor(866)])
  call ol_merge_tensors(T0sum(280),[G0tensor(873)])
  call ol_merge_tensors(T0sum(281),[G0tensor(879)])
  call ol_merge_tensors(T0sum(282),[G0tensor(885)])
  call ol_merge_tensors(T0sum(283),[G0tensor(892)])
  call ol_merge_tensors(T0sum(284),[G0tensor(898)])
  call ol_merge_tensors(T0sum(285),[G0tensor(904)])
  call ol_merge_tensors(T0sum(286),[G0tensor(911)])
  call ol_merge_tensors(T0sum(287),[G0tensor(918)])
  call ol_merge_tensors(T0sum(288),[G0tensor(924)])
  call ol_merge_tensors(T0sum(289),[G0tensor(931)])
  call ol_merge_tensors(T0sum(290),[G0tensor(937)])
  call ol_merge_tensors(T0sum(291),[G0tensor(944)])
  call ol_merge_tensors(T0sum(292),[G0tensor(950)])
  call ol_merge_tensors(T0sum(293),[G0tensor(956)])
  call ol_merge_tensors(T0sum(294),[G0tensor(963)])
  call ol_merge_tensors(T0sum(295),[G0tensor(718)])
  call ol_merge_tensors(T0sum(296),[G0tensor(969)])
  call ol_merge_tensors(T0sum(297),[G0tensor(976)])
  call ol_merge_tensors(T0sum(298),[G0tensor(87)])
  call ol_merge_tensors(T0sum(299),[G0tensor(982)])
  call ol_merge_tensors(T0sum(300),[G0tensor(250)])
  call ol_merge_tensors(T0sum(301),[G0tensor(989)])
  call ol_merge_tensors(T0sum(302),[G0tensor(996)])
  call ol_merge_tensors(T0sum(303),[G0tensor(1002)])
  call ol_merge_tensors(T0sum(304),[G0tensor(1009)])
  call ol_merge_tensors(T0sum(305),[G0tensor(1015)])
  call ol_merge_tensors(T0sum(306),[G0tensor(225)])
  call ol_merge_tensors(T0sum(307),[G0tensor(1022)])
  call ol_merge_tensors(T0sum(308),[G0tensor(1028)])
  call ol_merge_tensors(T0sum(309),[G0tensor(427)])
  call ol_merge_tensors(T0sum(310),[G0tensor(1035)])
  call ol_merge_tensors(T0sum(311),[G0tensor(1041)])
  call ol_merge_tensors(T0sum(312),[G0tensor(137)])
  call ol_merge_tensors(T0sum(313),[G0tensor(1047)])
  call ol_merge_tensors(T0sum(314),[G0tensor(318)])
  call ol_merge_tensors(T0sum(315),[G0tensor(1053)])
  call ol_merge_tensors(T0sum(316),[G0tensor(135)])
  call ol_merge_tensors(T0sum(317),[G0tensor(1059)])
  call ol_merge_tensors(T0sum(318),[G0tensor(332)])
  call ol_merge_tensors(T0sum(319),[G0tensor(1065)])
  call ol_merge_tensors(T0sum(320),[G0tensor(245)])
  call ol_merge_tensors(T0sum(321),[G0tensor(1071)])
  call ol_merge_tensors(T0sum(322),[G0tensor(24)])
  call ol_merge_tensors(T0sum(323),[G0tensor(667)])
  call ol_merge_tensors(T0sum(324),[G0tensor(1078)])
  call ol_merge_tensors(T0sum(325),[G0tensor(1085)])
  call ol_merge_tensors(T0sum(326),[G0tensor(1092)])
  call ol_merge_tensors(T0sum(327),[G0tensor(1098)])
  call ol_merge_tensors(T0sum(328),[G0tensor(1105)])
  call ol_merge_tensors(T0sum(329),[G0tensor(1112)])
  call ol_merge_tensors(T0sum(330),[G0tensor(1119)])
  call ol_merge_tensors(T0sum(331),[G0tensor(29)])
  call ol_merge_tensors(T0sum(332),[G0tensor(1125)])
  call ol_merge_tensors(T0sum(333),[G0tensor(567)])
  call ol_merge_tensors(T0sum(334),[G0tensor(39)])
  call ol_merge_tensors(T0sum(335),[G0tensor(1131)])
  call ol_merge_tensors(T0sum(336),[G0tensor(22)])
  call ol_merge_tensors(T0sum(337),[G0tensor(1137)])
  call ol_merge_tensors(T0sum(338),[G0tensor(382)])
  call ol_merge_tensors(T0sum(339),[G0tensor(435)])
  call ol_merge_tensors(T0sum(340),[G0tensor(37)])
  call ol_merge_tensors(T0sum(341),[G0tensor(1143)])
  call ol_merge_tensors(T0sum(342),[G0tensor(447)])
  call ol_merge_tensors(T0sum(343),[G0tensor(43)])
  call ol_merge_tensors(T0sum(344),[G0tensor(792)])
  call ol_merge_tensors(T0sum(345),[G0tensor(1149)])
  call ol_merge_tensors(T0sum(346),[G0tensor(84)])
  call ol_merge_tensors(T0sum(347),[G0tensor(1155)])
  call ol_merge_tensors(T0sum(348),[G0tensor(485)])
  call ol_merge_tensors(T0sum(349),[G0tensor(1161)])
  call ol_merge_tensors(T0sum(350),[G0tensor(1167)])
  call ol_merge_tensors(T0sum(351),[G0tensor(74)])
  call ol_merge_tensors(T0sum(352),[G0tensor(1173)])
  call ol_merge_tensors(T0sum(353),[G0tensor(1179)])
  call ol_merge_tensors(T0sum(354),[G0tensor(1186)])
  call ol_merge_tensors(T0sum(355),[G0tensor(1192)])
  call ol_merge_tensors(T0sum(356),[G0tensor(1198)])
  call ol_merge_tensors(T0sum(357),[G0tensor(1205)])
  call ol_merge_tensors(T0sum(358),[G0tensor(1211)])
  call ol_merge_tensors(T0sum(359),[G0tensor(55)])
  call ol_merge_tensors(T0sum(360),[G0tensor(1217)])
  call ol_merge_tensors(T0sum(361),[G0tensor(1224)])
  call ol_merge_tensors(T0sum(362),[G0tensor(1230)])
  call ol_merge_tensors(T0sum(363),[G0tensor(1237)])
  call ol_merge_tensors(T0sum(364),[G0tensor(1243)])
  call ol_merge_tensors(T0sum(365),[G0tensor(1250)])
  call ol_merge_tensors(T0sum(366),[G0tensor(1257)])
  call ol_merge_tensors(T0sum(367),[G0tensor(1264)])
  call ol_merge_tensors(T0sum(368),[G0tensor(1270)])
  call ol_merge_tensors(T0sum(369),[G0tensor(1276)])
  call ol_merge_tensors(T0sum(370),[G0tensor(1283)])
  call ol_merge_tensors(T0sum(371),[G0tensor(1289)])
  call ol_merge_tensors(T0sum(372),[G0tensor(1296)])
  call ol_merge_tensors(T0sum(373),[G0tensor(1302)])
  call ol_merge_tensors(T0sum(374),[G0tensor(1309)])
  call ol_merge_tensors(T0sum(375),[G0tensor(1316)])
  call ol_merge_tensors(T0sum(376),[G0tensor(58)])
  call ol_merge_tensors(T0sum(377),[G0tensor(505)])
  call ol_merge_tensors(T0sum(378),[G0tensor(72)])
  call ol_merge_tensors(T0sum(379),[G0tensor(70)])
  call ol_merge_tensors(T0sum(380),[G0tensor(73)])
  call ol_merge_tensors(T0sum(381),[G0tensor(532)])
  call ol_merge_tensors(T0sum(382),[G0tensor(93)])
  call ol_merge_tensors(T0sum(383),[G0tensor(102)])
  call ol_merge_tensors(T0sum(384),[G0tensor(743)])
  call ol_merge_tensors(T0sum(385),[G0tensor(113)])
  call ol_merge_tensors(T0sum(386),[G0tensor(323)])
  call ol_merge_tensors(T0sum(387),[G0tensor(140)])
  call ol_merge_tensors(T0sum(388),[G0tensor(453)])
  Gcoeff(:)%j = (c(17)*(M(4,:)%j-M(6,:)%j)) * den(3)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(530),h0tab(:,530),[16,15],[0,0],3,2,wf4(:,1),wf4(:,2))
  call Hloop_UV_W(ntryL,G0H32(1),0,ex5(:),16,G1H16(29),m3h2x16(:,292),heltab2x32(:,:,524))
  Gcoeff(:)%j = (c(17)*(-M(4,:)%j+M(6,:)%j)) * den(3)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(531),h0tab(:,531),[16,15],[0,0],3,2,wf4(:,2),wf4(:,1))
  call Hloop_UV_W(ntryL,G0H32(1),0,ex5(:),16,G1H16(14),m3h2x16(:,293),heltab2x32(:,:,525))
  Gcoeff(:)%j = (c(18)*(-M(4,:)%j+M(6,:)%j)) * den(3)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(532),h0tab(:,532),[16,15],[0,0],3,2,wf4(:,1),wf4(:,2))
  call Hloop_UV_W(ntryL,G0H32(1),0,ex5(:),16,G1H16(9),m3h2x16(:,294),heltab2x32(:,:,526))
  Gcoeff(:)%j = (c(17)*(-M(4,:)%j+M(6,:)%j)) * den(3)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(533),h0tab(:,533),[28,3],[0,0],3,2,wf4(:,2),wf4(:,1))
  call Hloop_GGG_G_12(ntryL,G0H32(1),ex5(:),wf4(:,2),G0H4(1),m4h2x4x4(:,5),heltab3x32(:,:,7))
  Gcoeff(:)%j = (c(17)*(M(4,:)%j-M(6,:)%j)) * den(3)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(534),h0tab(:,534),[28,3],[0,0],3,2,wf4(:,2),wf4(:,1))
  call Hloop_GGG_G_12(ntryL,G0H32(1),wf4(:,2),ex5(:),G0H4(6),m4h4x2x4(:,3),heltab3x32(:,:,8))
  Gcoeff(:)%j = (c(18)*(M(4,:)%j-M(6,:)%j)) * den(3)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(535),h0tab(:,535),[28,3],[0,0],3,2,wf4(:,2),wf4(:,1))
  call Hloop_GGG_G_23(ntryL,G0H32(1),ex5(:),wf4(:,2),G0H4(5),m4h2x4x4(:,6),heltab3x32(:,:,9))
  Gcoeff(:)%j = (c(17)*(M(4,:)%j-M(6,:)%j)) * den(3)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(536),h0tab(:,536),[19,12],[0,0],3,2,wf4(:,1),wf4(:,2))
  call Hloop_GGG_G_12(ntryL,G0H32(1),ex5(:),wf4(:,1),G0H4(4),m4h2x4x4(:,7),heltab3x32(:,:,10))
  Gcoeff(:)%j = (c(17)*(-M(4,:)%j+M(6,:)%j)) * den(3)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(537),h0tab(:,537),[19,12],[0,0],3,2,wf4(:,1),wf4(:,2))
  call Hloop_GGG_G_12(ntryL,G0H32(1),wf4(:,1),ex5(:),G0H4(7),m4h4x2x4(:,4),heltab3x32(:,:,11))
  Gcoeff(:)%j = (c(18)*(-M(4,:)%j+M(6,:)%j)) * den(3)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(538),h0tab(:,538),[19,12],[0,0],3,2,wf4(:,1),wf4(:,2))
  call Hloop_GGG_G_23(ntryL,G0H32(1),ex5(:),wf4(:,1),G0H4(3),m4h2x4x4(:,8),heltab3x32(:,:,12))
  Gcoeff(:)%j = (c(65)*(M(4,:)%j-M(6,:)%j)) * den(39)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(539),h0tab(:,539),[19,12],[0,0],2,2,wf8(:,1),wf4(:,2))
  call Hloop_QV_A(ntryL,G0H32(1),wf8(:,1),G0H4(2),m3h8x4(:,73),heltab2x32(:,:,527))
  call Hloop_Q_A(ntryL,G0H4(2),19,0,G1H4(20),n2h4(287))
  Gcoeff(:)%j = (c(64)*(M(4,:)%j-M(6,:)%j)) * den(39)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(540),h0tab(:,540),[19,12],[nMT,nMT],2,2,wf8(:,1),wf4(:,2))
  call Hloop_QV_A(ntryL,G0H32(1),wf8(:,1),G0H4(2),m3h8x4(:,74),heltab2x32(:,:,528))
  call Hloop_Q_A(ntryL,G0H4(2),19,nMT,G1H4(36),n2h4(288))
  Gcoeff(:)%j = (c(65)*(M(4,:)%j-M(6,:)%j)) * den(39)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(541),h0tab(:,541),[19,12],[0,0],2,2,wf8(:,1),wf4(:,2))
  call Hloop_QV_A(ntryL,G0H32(1),wf8(:,1),G0H4(2),m3h8x4(:,75),heltab2x32(:,:,529))
  call Hloop_Q_A(ntryL,G0H4(2),19,0,G1H4(85),n2h4(289))
  Gcoeff(:)%j = (c(64)*(M(4,:)%j-M(6,:)%j)) * den(39)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(542),h0tab(:,542),[19,12],[nMB,nMB],2,2,wf8(:,1),wf4(:,2))
  call Hloop_QV_A(ntryL,G0H32(1),wf8(:,1),G0H4(2),m3h8x4(:,76),heltab2x32(:,:,530))
  call Hloop_Q_A(ntryL,G0H4(2),19,nMB,G1H4(88),n2h4(290))
  Gcoeff(:)%j = (c(23)*(M(4,:)%j-M(6,:)%j)) * den(39)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(543),h0tab(:,543),[19,12],[0,0],2,2,wf8(:,1),wf4(:,2))
  call Hloop_CV_D(ntryL,G0H32(1),0,wf8(:,1),19,G1H4(15),m3h8x4(:,77),heltab2x32(:,:,531))
  Gcoeff(:)%j = (c(18)*(-M(4,:)%j+M(6,:)%j)) * den(39)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(544),h0tab(:,544),[19,12],[0,0],2,2,wf8(:,1),wf4(:,2))
  call Hloop_UV_W(ntryL,G0H32(1),0,wf8(:,1),19,G1H4(10),m3h8x4(:,78),heltab2x32(:,:,532))
  Gcoeff(:)%j = (c(65)*(-M(4,:)%j+M(6,:)%j)) * den(36)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(545),h0tab(:,545),[28,3],[0,0],2,2,wf8(:,89),wf4(:,1))
  call Hloop_QV_A(ntryL,G0H32(1),wf8(:,89),G0H4(2),m3h8x4(:,79),heltab2x32(:,:,533))
  call Hloop_Q_A(ntryL,G0H4(2),28,0,G1H4(141),n2h4(291))
  Gcoeff(:)%j = (c(64)*(-M(4,:)%j+M(6,:)%j)) * den(36)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(546),h0tab(:,546),[28,3],[nMT,nMT],2,2,wf8(:,89),wf4(:,1))
  call Hloop_QV_A(ntryL,G0H32(1),wf8(:,89),G0H4(2),m3h8x4(:,80),heltab2x32(:,:,534))
  call Hloop_Q_A(ntryL,G0H4(2),28,nMT,G1H4(136),n2h4(292))
  Gcoeff(:)%j = (c(65)*(-M(4,:)%j+M(6,:)%j)) * den(36)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(547),h0tab(:,547),[28,3],[0,0],2,2,wf8(:,89),wf4(:,1))
  call Hloop_QV_A(ntryL,G0H32(1),wf8(:,89),G0H4(2),m3h8x4(:,81),heltab2x32(:,:,535))
  call Hloop_Q_A(ntryL,G0H4(2),28,0,G1H4(30),n2h4(293))
  Gcoeff(:)%j = (c(64)*(-M(4,:)%j+M(6,:)%j)) * den(36)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(548),h0tab(:,548),[28,3],[nMB,nMB],2,2,wf8(:,89),wf4(:,1))
  call Hloop_QV_A(ntryL,G0H32(1),wf8(:,89),G0H4(2),m3h8x4(:,82),heltab2x32(:,:,536))
  call Hloop_Q_A(ntryL,G0H4(2),28,nMB,G1H4(97),n2h4(294))
  Gcoeff(:)%j = (c(23)*(-M(4,:)%j+M(6,:)%j)) * den(36)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(549),h0tab(:,549),[28,3],[0,0],2,2,wf8(:,89),wf4(:,1))
  call Hloop_CV_D(ntryL,G0H32(1),0,wf8(:,89),28,G1H4(98),m3h8x4(:,83),heltab2x32(:,:,537))
  Gcoeff(:)%j = (c(18)*(M(4,:)%j-M(6,:)%j)) * den(36)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(550),h0tab(:,550),[28,3],[0,0],2,2,wf8(:,89),wf4(:,1))
  call Hloop_UV_W(ntryL,G0H32(1),0,wf8(:,89),28,G1H4(104),m3h8x4(:,84),heltab2x32(:,:,538))
  Gcoeff(:)%j = (-(c(54)*M(7,:)%j)) * den(44)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(551),h0tab(:,551),[20,11],[0,nMB],2,2,wf4(:,5),wf8(:,91))
  call Hloop_AQ_V(ntryL,G0H32(1),wf4(:,5),G0H8(27),m3h4x8(:,161),heltab2x32(:,:,539))
  Gcoeff(:)%j = (-(c(54)*M(7,:)%j)) * den(46)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(552),h0tab(:,552),[20,11],[0,nMB],2,2,wf4(:,5),wf8(:,92))
  call Hloop_AQ_V(ntryL,G0H32(1),wf4(:,5),G0H8(26),m3h4x8(:,162),heltab2x32(:,:,540))
  Gcoeff(:)%j = (-(c(49)*M(3,:)%j)+c(48)*M(7,:)%j) * den(48)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(553),h0tab(:,553),[20,11],[nMH,nMB],2,2,wf4(:,5),wf8(:,93))
  call Hloop_AQ_S(ntryL,G0H32(1),wf4(:,5),G0H8(40),ngH,m3h4x8(:,163),heltab2x32(:,:,541))
  Gcoeff(:)%j = (c(49)*M(3,:)%j-c(48)*M(7,:)%j) * den(48)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(554),h0tab(:,554),[20,11],[nMZ,nMB],2,2,wf4(:,5),wf8(:,93))
  call Hloop_AQ_S(ntryL,G0H32(1),wf4(:,5),G0H8(39),ngX,m3h4x8(:,164),heltab2x32(:,:,542))
  Gcoeff(:)%j = (c(45)*M(3,:)%j-c(44)*M(7,:)%j) * den(48)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(555),h0tab(:,555),[20,11],[nMW,nMT],2,2,wf4(:,5),wf8(:,93))
  call Hloop_AQ_S(ntryL,G0H32(1),wf4(:,5),G0H8(49),ngPtb,m3h4x8(:,165),heltab2x32(:,:,543))
  Gcoeff(:)%j = (-(c(11)*M(7,:)%j)) * den(48)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(556),h0tab(:,556),[20,11],[0,nMB],2,2,wf4(:,5),wf8(:,93))
  call Hloop_AQ_V(ntryL,G0H32(1),wf4(:,5),G0H8(48),m3h4x8(:,166),heltab2x32(:,:,544))
  Gcoeff(:)%j = (c(16)*M(7,:)%j) * den(46)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(557),h0tab(:,557),[20,11],[0,nMB],2,2,wf4(:,5),wf8(:,94))
  call Hloop_AQ_V(ntryL,G0H32(1),wf4(:,5),G0H8(1),m3h4x8(:,167),heltab2x32(:,:,545))
  Gcoeff(:)%j = (c(8)*M(3,:)%j-c(7)*M(7,:)%j) * den(48)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(558),h0tab(:,558),[20,11],[0,nMB],2,2,wf4(:,5),wf8(:,93))
  call Hloop_AQ_V(ntryL,G0H32(1),wf4(:,5),G0H8(2),m3h4x8(:,168),heltab2x32(:,:,546))
  Gcoeff(:)%j = (c(15)*M(3,:)%j-c(14)*M(7,:)%j) * den(48)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(559),h0tab(:,559),[20,11],[nMZ,nMB],2,2,wf4(:,5),wf8(:,93))
  call Hloop_AQ_Z(ntryL,G0H32(1),wf4(:,5),G0H8(4),ngZd,m3h4x8(:,169),heltab2x32(:,:,547))
  Gcoeff(:)%j = (c(40)*M(3,:)%j-c(39)*M(7,:)%j) * den(48)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(560),h0tab(:,560),[20,11],[nMW,nMT],2,2,wf4(:,5),wf8(:,93))
  call Hloop_AQ_W(ntryL,G0H32(1),wf4(:,5),G0H8(5),m3h4x8(:,170),heltab2x32(:,:,548))
  Gcoeff(:)%j = (c(34)*M(4,:)%j-c(29)*M(8,:)%j) * den(48)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(561),h0tab(:,561),[20,11],[0,nMB],2,2,wf4(:,5),wf8(:,93))
  call Hloop_AQ_V(ntryL,G0H32(1),wf4(:,5),G0H8(6),m3h4x8(:,171),heltab2x32(:,:,549))
  Gcoeff(:)%j = (-(c(69)*M(4,:)%j)+c(68)*M(8,:)%j) * den(41)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(562),h0tab(:,562),[28,3],[0,0],2,2,wf8(:,90),wf4(:,1))
  call Hloop_QV_A(ntryL,G0H32(1),wf8(:,90),G0H4(2),m3h8x4(:,85),heltab2x32(:,:,550))
  call Hloop_Q_A(ntryL,G0H4(2),28,0,G1H4(107),n2h4(295))
  Gcoeff(:)%j = (-(c(67)*M(4,:)%j)+c(66)*M(8,:)%j) * den(41)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(563),h0tab(:,563),[28,3],[nMT,nMT],2,2,wf8(:,90),wf4(:,1))
  call Hloop_QV_A(ntryL,G0H32(1),wf8(:,90),G0H4(2),m3h8x4(:,86),heltab2x32(:,:,551))
  call Hloop_Q_A(ntryL,G0H4(2),28,nMT,G1H4(108),n2h4(296))
  Gcoeff(:)%j = (-(c(69)*M(4,:)%j)+c(68)*M(8,:)%j) * den(41)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(564),h0tab(:,564),[28,3],[0,0],2,2,wf8(:,90),wf4(:,1))
  call Hloop_QV_A(ntryL,G0H32(1),wf8(:,90),G0H4(2),m3h8x4(:,87),heltab2x32(:,:,552))
  call Hloop_Q_A(ntryL,G0H4(2),28,0,G1H4(121),n2h4(297))
  Gcoeff(:)%j = (-(c(67)*M(4,:)%j)+c(66)*M(8,:)%j) * den(41)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(565),h0tab(:,565),[28,3],[nMB,nMB],2,2,wf8(:,90),wf4(:,1))
  call Hloop_QV_A(ntryL,G0H32(1),wf8(:,90),G0H4(2),m3h8x4(:,88),heltab2x32(:,:,553))
  call Hloop_Q_A(ntryL,G0H4(2),28,nMB,G1H4(116),n2h4(298))
  Gcoeff(:)%j = (-(c(36)*M(4,:)%j)+c(32)*M(8,:)%j) * den(41)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(566),h0tab(:,566),[28,3],[0,0],2,2,wf8(:,90),wf4(:,1))
  call Hloop_CV_D(ntryL,G0H32(1),0,wf8(:,90),28,G1H4(119),m3h8x4(:,89),heltab2x32(:,:,554))
  Gcoeff(:)%j = (c(25)*M(4,:)%j-c(24)*M(8,:)%j) * den(41)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(567),h0tab(:,567),[28,3],[0,0],2,2,wf8(:,90),wf4(:,1))
  call Hloop_UV_W(ntryL,G0H32(1),0,wf8(:,90),28,G1H4(128),m3h8x4(:,90),heltab2x32(:,:,555))
  Gcoeff(:)%j = (-(c(54)*M(7,:)%j)) * den(53)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(568),h0tab(:,568),[24,7],[nMB,0],2,2,wf4(:,9),wf8(:,96))
  call Hloop_VA_Q(ntryL,G0H32(1),wf4(:,9),G0H8(7),m3h4x8(:,172),heltab2x32(:,:,556))
  call Hloop_A_Q(ntryL,G0H8(7),24,nMB,G1H8(50),n2h8(147))
  Gcoeff(:)%j = (-(c(54)*M(7,:)%j)) * den(55)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(569),h0tab(:,569),[24,7],[nMB,0],2,2,wf4(:,9),wf8(:,97))
  call Hloop_VA_Q(ntryL,G0H32(1),wf4(:,9),G0H8(8),m3h4x8(:,173),heltab2x32(:,:,557))
  call Hloop_A_Q(ntryL,G0H8(8),24,nMB,G1H8(36),n2h8(148))
  Gcoeff(:)%j = (-(c(49)*M(5,:)%j)+c(48)*M(7,:)%j) * den(57)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(570),h0tab(:,570),[24,7],[nMB,nMH],2,2,wf4(:,9),wf8(:,98))
  call Hloop_SA_Q(ntryL,G0H32(1),wf4(:,9),G0H8(9),ngH,m3h4x8(:,174),heltab2x32(:,:,558))
  call Hloop_A_Q(ntryL,G0H8(9),24,nMB,G1H8(5),n2h8(149))
  Gcoeff(:)%j = (c(49)*M(5,:)%j-c(48)*M(7,:)%j) * den(57)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(571),h0tab(:,571),[24,7],[nMB,nMZ],2,2,wf4(:,9),wf8(:,98))
  call Hloop_SA_Q(ntryL,G0H32(1),wf4(:,9),G0H8(10),ngX,m3h4x8(:,175),heltab2x32(:,:,559))
  call Hloop_A_Q(ntryL,G0H8(10),24,nMB,G1H8(57),n2h8(150))
  Gcoeff(:)%j = (c(45)*M(5,:)%j-c(44)*M(7,:)%j) * den(57)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(572),h0tab(:,572),[24,7],[nMT,nMW],2,2,wf4(:,9),wf8(:,98))
  call Hloop_SA_Q(ntryL,G0H32(1),wf4(:,9),G0H8(11),ngPbt,m3h4x8(:,176),heltab2x32(:,:,560))
  call Hloop_A_Q(ntryL,G0H8(11),24,nMT,G1H8(62),n2h8(151))
  Gcoeff(:)%j = (-(c(11)*M(7,:)%j)) * den(57)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(573),h0tab(:,573),[24,7],[nMB,0],2,2,wf4(:,9),wf8(:,98))
  call Hloop_VA_Q(ntryL,G0H32(1),wf4(:,9),G0H8(12),m3h4x8(:,177),heltab2x32(:,:,561))
  call Hloop_A_Q(ntryL,G0H8(12),24,nMB,G1H8(63),n2h8(152))
  Gcoeff(:)%j = (c(16)*M(7,:)%j) * den(55)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(574),h0tab(:,574),[24,7],[nMB,0],2,2,wf4(:,9),wf8(:,99))
  call Hloop_VA_Q(ntryL,G0H32(1),wf4(:,9),G0H8(13),m3h4x8(:,178),heltab2x32(:,:,562))
  call Hloop_A_Q(ntryL,G0H8(13),24,nMB,G1H8(64),n2h8(153))
  Gcoeff(:)%j = (c(8)*M(5,:)%j-c(7)*M(7,:)%j) * den(57)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(575),h0tab(:,575),[24,7],[nMB,0],2,2,wf4(:,9),wf8(:,98))
  call Hloop_VA_Q(ntryL,G0H32(1),wf4(:,9),G0H8(14),m3h4x8(:,179),heltab2x32(:,:,563))
  call Hloop_A_Q(ntryL,G0H8(14),24,nMB,G1H8(68),n2h8(154))
  Gcoeff(:)%j = (c(15)*M(5,:)%j-c(14)*M(7,:)%j) * den(57)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(576),h0tab(:,576),[24,7],[nMB,nMZ],2,2,wf4(:,9),wf8(:,98))
  call Hloop_ZA_Q(ntryL,G0H32(1),wf4(:,9),G0H8(16),ngZd,m3h4x8(:,180),heltab2x32(:,:,564))
  call Hloop_A_Q(ntryL,G0H8(16),24,nMB,G1H8(69),n2h8(155))
  Gcoeff(:)%j = (c(40)*M(5,:)%j-c(39)*M(7,:)%j) * den(57)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(577),h0tab(:,577),[24,7],[nMT,nMW],2,2,wf4(:,9),wf8(:,98))
  call Hloop_WA_Q(ntryL,G0H32(1),wf4(:,9),G0H8(21),m3h4x8(:,181),heltab2x32(:,:,565))
  call Hloop_A_Q(ntryL,G0H8(21),24,nMT,G1H8(71),n2h8(156))
  Gcoeff(:)%j = (c(34)*M(6,:)%j-c(29)*M(8,:)%j) * den(57)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(578),h0tab(:,578),[24,7],[nMB,0],2,2,wf4(:,9),wf8(:,98))
  call Hloop_VA_Q(ntryL,G0H32(1),wf4(:,9),G0H8(43),m3h4x8(:,182),heltab2x32(:,:,566))
  call Hloop_A_Q(ntryL,G0H8(43),24,nMB,G1H8(45),n2h8(157))
  Gcoeff(:)%j = (-(c(69)*M(6,:)%j)+c(68)*M(8,:)%j) * den(50)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(579),h0tab(:,579),[28,3],[0,0],2,2,wf8(:,95),wf4(:,1))
  call Hloop_QV_A(ntryL,G0H32(1),wf8(:,95),G0H4(2),m3h8x4(:,91),heltab2x32(:,:,567))
  call Hloop_Q_A(ntryL,G0H4(2),28,0,G1H4(126),n2h4(299))
  Gcoeff(:)%j = (-(c(67)*M(6,:)%j)+c(66)*M(8,:)%j) * den(50)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(580),h0tab(:,580),[28,3],[nMT,nMT],2,2,wf8(:,95),wf4(:,1))
  call Hloop_QV_A(ntryL,G0H32(1),wf8(:,95),G0H4(2),m3h8x4(:,92),heltab2x32(:,:,568))
  call Hloop_Q_A(ntryL,G0H4(2),28,nMT,G1H4(127),n2h4(300))
  Gcoeff(:)%j = (-(c(69)*M(6,:)%j)+c(68)*M(8,:)%j) * den(50)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(581),h0tab(:,581),[28,3],[0,0],2,2,wf8(:,95),wf4(:,1))
  call Hloop_QV_A(ntryL,G0H32(1),wf8(:,95),G0H4(2),m3h8x4(:,93),heltab2x32(:,:,569))
  call Hloop_Q_A(ntryL,G0H4(2),28,0,G1H4(133),n2h4(301))
  Gcoeff(:)%j = (-(c(67)*M(6,:)%j)+c(66)*M(8,:)%j) * den(50)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(582),h0tab(:,582),[28,3],[nMB,nMB],2,2,wf8(:,95),wf4(:,1))
  call Hloop_QV_A(ntryL,G0H32(1),wf8(:,95),G0H4(2),m3h8x4(:,94),heltab2x32(:,:,570))
  call Hloop_Q_A(ntryL,G0H4(2),28,nMB,G1H4(139),n2h4(302))
  Gcoeff(:)%j = (-(c(36)*M(6,:)%j)+c(32)*M(8,:)%j) * den(50)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(583),h0tab(:,583),[28,3],[0,0],2,2,wf8(:,95),wf4(:,1))
  call Hloop_CV_D(ntryL,G0H32(1),0,wf8(:,95),28,G1H4(137),m3h8x4(:,95),heltab2x32(:,:,571))
  Gcoeff(:)%j = (c(25)*M(6,:)%j-c(24)*M(8,:)%j) * den(50)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(584),h0tab(:,584),[28,3],[0,0],2,2,wf8(:,95),wf4(:,1))
  call Hloop_UV_W(ntryL,G0H32(1),0,wf8(:,95),28,G1H4(7),m3h8x4(:,96),heltab2x32(:,:,572))
  Gcoeff(:)%j = (-(c(46)*M(5,:)%j)) * den(60)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(585),h0tab(:,585),[17,14],[0,nMT],2,2,wf4(:,12),wf8(:,101))
  call Hloop_AQ_V(ntryL,G0H32(1),wf4(:,12),G0H8(17),m3h4x8(:,183),heltab2x32(:,:,573))
  Gcoeff(:)%j = (-(c(41)*M(5,:)%j)) * den(60)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(586),h0tab(:,586),[17,14],[0,nMT],2,2,wf4(:,12),wf8(:,103))
  call Hloop_AQ_V(ntryL,G0H32(1),wf4(:,12),G0H8(35),m3h4x8(:,184),heltab2x32(:,:,574))
  Gcoeff(:)%j = (-(c(46)*M(5,:)%j)) * den(62)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(587),h0tab(:,587),[24,7],[nMB,0],2,2,wf4(:,9),wf8(:,104))
  call Hloop_VA_Q(ntryL,G0H32(1),wf4(:,9),G0H8(33),m3h4x8(:,185),heltab2x32(:,:,575))
  call Hloop_A_Q(ntryL,G0H8(33),24,nMB,G1H8(2),n2h8(158))
  Gcoeff(:)%j = (-(c(41)*M(5,:)%j)) * den(62)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(588),h0tab(:,588),[24,7],[nMB,0],2,2,wf4(:,9),wf8(:,105))
  call Hloop_VA_Q(ntryL,G0H32(1),wf4(:,9),G0H8(50),m3h4x8(:,186),heltab2x32(:,:,576))
  call Hloop_A_Q(ntryL,G0H8(50),24,nMB,G1H8(3),n2h8(159))
  Gcoeff(:)%j = (-(c(46)*M(3,:)%j)) * den(65)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(589),h0tab(:,589),[18,13],[0,nMT],2,2,wf4(:,16),wf8(:,106))
  call Hloop_QA_V(ntryL,G0H32(1),wf4(:,16),G0H8(47),m3h4x8(:,187),heltab2x32(:,:,577))
  Gcoeff(:)%j = (-(c(41)*M(3,:)%j)) * den(65)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(590),h0tab(:,590),[18,13],[0,nMT],2,2,wf4(:,16),wf8(:,107))
  call Hloop_QA_V(ntryL,G0H32(1),wf4(:,16),G0H8(3),m3h4x8(:,188),heltab2x32(:,:,578))
  Gcoeff(:)%j = (-(c(46)*M(3,:)%j)) * den(67)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(591),h0tab(:,591),[20,11],[nMB,0],2,2,wf4(:,5),wf8(:,108))
  call Hloop_VQ_A(ntryL,G0H32(1),wf4(:,5),G0H8(15),m3h4x8(:,189),heltab2x32(:,:,579))
  call Hloop_Q_A(ntryL,G0H8(15),20,nMB,G1H8(8),n2h8(160))
  Gcoeff(:)%j = (-(c(41)*M(3,:)%j)) * den(67)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(592),h0tab(:,592),[20,11],[nMB,0],2,2,wf4(:,5),wf8(:,109))
  call Hloop_VQ_A(ntryL,G0H32(1),wf4(:,5),G0H8(19),m3h4x8(:,190),heltab2x32(:,:,580))
  call Hloop_Q_A(ntryL,G0H8(19),20,nMB,G1H8(15),n2h8(161))
  Gcoeff(:)%j = (c(68)*M(2,:)%j-c(69)*M(6,:)%j) * den(75)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(593),h0tab(:,593),[19,12],[0,0],2,2,wf8(:,20),wf4(:,2))
  call Hloop_QV_A(ntryL,G0H32(1),wf8(:,20),G0H4(2),m3h8x4(:,97),heltab2x32(:,:,581))
  call Hloop_Q_A(ntryL,G0H4(2),19,0,G1H4(113),n2h4(303))
  Gcoeff(:)%j = (c(66)*M(2,:)%j-c(67)*M(6,:)%j) * den(75)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(594),h0tab(:,594),[19,12],[nMT,nMT],2,2,wf8(:,20),wf4(:,2))
  call Hloop_QV_A(ntryL,G0H32(1),wf8(:,20),G0H4(2),m3h8x4(:,98),heltab2x32(:,:,582))
  call Hloop_Q_A(ntryL,G0H4(2),19,nMT,G1H4(12),n2h4(304))
  Gcoeff(:)%j = (c(68)*M(2,:)%j-c(69)*M(6,:)%j) * den(75)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(595),h0tab(:,595),[19,12],[0,0],2,2,wf8(:,20),wf4(:,2))
  call Hloop_QV_A(ntryL,G0H32(1),wf8(:,20),G0H4(2),m3h8x4(:,99),heltab2x32(:,:,583))
  call Hloop_Q_A(ntryL,G0H4(2),19,0,G1H4(23),n2h4(305))
  Gcoeff(:)%j = (c(66)*M(2,:)%j-c(67)*M(6,:)%j) * den(75)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(596),h0tab(:,596),[19,12],[nMB,nMB],2,2,wf8(:,20),wf4(:,2))
  call Hloop_QV_A(ntryL,G0H32(1),wf8(:,20),G0H4(2),m3h8x4(:,100),heltab2x32(:,:,584))
  call Hloop_Q_A(ntryL,G0H4(2),19,nMB,G1H4(81),n2h4(306))
  Gcoeff(:)%j = (c(32)*M(2,:)%j-c(36)*M(6,:)%j) * den(75)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(597),h0tab(:,597),[19,12],[0,0],2,2,wf8(:,20),wf4(:,2))
  call Hloop_CV_D(ntryL,G0H32(1),0,wf8(:,20),19,G1H4(25),m3h8x4(:,101),heltab2x32(:,:,585))
  Gcoeff(:)%j = (-(c(24)*M(2,:)%j)+c(25)*M(6,:)%j) * den(75)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(598),h0tab(:,598),[19,12],[0,0],2,2,wf8(:,20),wf4(:,2))
  call Hloop_UV_W(ntryL,G0H32(1),0,wf8(:,20),19,G1H4(3),m3h8x4(:,102),heltab2x32(:,:,586))
  Gcoeff(:)%j = (-(c(54)*M(1,:)%j)) * den(69)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(599),h0tab(:,599),[17,14],[0,nMT],2,2,wf4(:,12),wf8(:,111))
  call Hloop_AQ_V(ntryL,G0H32(1),wf4(:,12),G0H8(20),m3h4x8(:,191),heltab2x32(:,:,587))
  Gcoeff(:)%j = (-(c(54)*M(1,:)%j)) * den(71)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(600),h0tab(:,600),[17,14],[0,nMT],2,2,wf4(:,12),wf8(:,113))
  call Hloop_AQ_V(ntryL,G0H32(1),wf4(:,12),G0H8(22),m3h4x8(:,192),heltab2x32(:,:,588))
  Gcoeff(:)%j = (c(56)*M(1,:)%j-c(57)*M(5,:)%j) * den(73)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(601),h0tab(:,601),[17,14],[nMH,nMT],2,2,wf4(:,12),wf8(:,115))
  call Hloop_AQ_S(ntryL,G0H32(1),wf4(:,12),G0H8(23),ngH,m3h4x8(:,193),heltab2x32(:,:,589))
  Gcoeff(:)%j = (-(c(56)*M(1,:)%j)+c(57)*M(5,:)%j) * den(73)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(602),h0tab(:,602),[17,14],[nMZ,nMT],2,2,wf4(:,12),wf8(:,115))
  call Hloop_AQ_S(ntryL,G0H32(1),wf4(:,12),G0H8(24),ngX,m3h4x8(:,194),heltab2x32(:,:,590))
  Gcoeff(:)%j = (-(c(44)*M(1,:)%j)+c(45)*M(5,:)%j) * den(73)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(603),h0tab(:,603),[17,14],[nMW,nMB],2,2,wf4(:,12),wf8(:,115))
  call Hloop_AQ_S(ntryL,G0H32(1),wf4(:,12),G0H8(25),ngPbt,m3h4x8(:,195),heltab2x32(:,:,591))
  Gcoeff(:)%j = (-(c(11)*M(1,:)%j)) * den(73)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(604),h0tab(:,604),[17,14],[0,nMT],2,2,wf4(:,12),wf8(:,115))
  call Hloop_AQ_V(ntryL,G0H32(1),wf4(:,12),G0H8(30),m3h4x8(:,196),heltab2x32(:,:,592))
  Gcoeff(:)%j = (c(16)*M(1,:)%j) * den(71)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(605),h0tab(:,605),[17,14],[0,nMT],2,2,wf4(:,12),wf8(:,117))
  call Hloop_AQ_V(ntryL,G0H32(1),wf4(:,12),G0H8(28),m3h4x8(:,197),heltab2x32(:,:,593))
  Gcoeff(:)%j = (-(c(12)*M(1,:)%j)+c(13)*M(5,:)%j) * den(73)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(606),h0tab(:,606),[17,14],[0,nMT],2,2,wf4(:,12),wf8(:,115))
  call Hloop_AQ_V(ntryL,G0H32(1),wf4(:,12),G0H8(29),m3h4x8(:,198),heltab2x32(:,:,594))
  Gcoeff(:)%j = (-(c(14)*M(1,:)%j)+c(15)*M(5,:)%j) * den(73)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(607),h0tab(:,607),[17,14],[nMZ,nMT],2,2,wf4(:,12),wf8(:,115))
  call Hloop_AQ_Z(ntryL,G0H32(1),wf4(:,12),G0H8(31),ngZu,m3h4x8(:,199),heltab2x32(:,:,595))
  Gcoeff(:)%j = (-(c(39)*M(1,:)%j)+c(40)*M(5,:)%j) * den(73)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(608),h0tab(:,608),[17,14],[nMW,nMB],2,2,wf4(:,12),wf8(:,115))
  call Hloop_AQ_W(ntryL,G0H32(1),wf4(:,12),G0H8(32),m3h4x8(:,200),heltab2x32(:,:,596))
  Gcoeff(:)%j = (-(c(29)*M(2,:)%j)+c(34)*M(6,:)%j) * den(73)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(609),h0tab(:,609),[17,14],[0,nMT],2,2,wf4(:,12),wf8(:,115))
  call Hloop_AQ_V(ntryL,G0H32(1),wf4(:,12),G0H8(38),m3h4x8(:,201),heltab2x32(:,:,597))
  Gcoeff(:)%j = (c(68)*M(2,:)%j-c(69)*M(4,:)%j) * den(83)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(610),h0tab(:,610),[19,12],[0,0],2,2,wf8(:,24),wf4(:,2))
  call Hloop_QV_A(ntryL,G0H32(1),wf8(:,24),G0H4(2),m3h8x4(:,103),heltab2x32(:,:,598))
  call Hloop_Q_A(ntryL,G0H4(2),19,0,G1H4(144),n2h4(307))
  Gcoeff(:)%j = (c(66)*M(2,:)%j-c(67)*M(4,:)%j) * den(83)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(611),h0tab(:,611),[19,12],[nMT,nMT],2,2,wf8(:,24),wf4(:,2))
  call Hloop_QV_A(ntryL,G0H32(1),wf8(:,24),G0H4(2),m3h8x4(:,104),heltab2x32(:,:,599))
  call Hloop_Q_A(ntryL,G0H4(2),19,nMT,G1H4(4),n2h4(308))
  Gcoeff(:)%j = (c(68)*M(2,:)%j-c(69)*M(4,:)%j) * den(83)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(612),h0tab(:,612),[19,12],[0,0],2,2,wf8(:,24),wf4(:,2))
  call Hloop_QV_A(ntryL,G0H32(1),wf8(:,24),G0H4(2),m3h8x4(:,105),heltab2x32(:,:,600))
  call Hloop_Q_A(ntryL,G0H4(2),19,0,G1H4(1),n2h4(309))
  Gcoeff(:)%j = (c(66)*M(2,:)%j-c(67)*M(4,:)%j) * den(83)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(613),h0tab(:,613),[19,12],[nMB,nMB],2,2,wf8(:,24),wf4(:,2))
  call Hloop_QV_A(ntryL,G0H32(1),wf8(:,24),G0H4(2),m3h8x4(:,106),heltab2x32(:,:,601))
  call Hloop_Q_A(ntryL,G0H4(2),19,nMB,G1H4(134),n2h4(310))
  Gcoeff(:)%j = (c(32)*M(2,:)%j-c(36)*M(4,:)%j) * den(83)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(614),h0tab(:,614),[19,12],[0,0],2,2,wf8(:,24),wf4(:,2))
  call Hloop_CV_D(ntryL,G0H32(1),0,wf8(:,24),19,G1H4(2),m3h8x4(:,107),heltab2x32(:,:,602))
  Gcoeff(:)%j = (-(c(24)*M(2,:)%j)+c(25)*M(4,:)%j) * den(83)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(615),h0tab(:,615),[19,12],[0,0],2,2,wf8(:,24),wf4(:,2))
  call Hloop_UV_W(ntryL,G0H32(1),0,wf8(:,24),19,G1H4(67),m3h8x4(:,108),heltab2x32(:,:,603))
  Gcoeff(:)%j = (-(c(54)*M(1,:)%j)) * den(77)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(616),h0tab(:,616),[18,13],[nMT,0],2,2,wf4(:,16),wf8(:,119))
  call Hloop_VA_Q(ntryL,G0H32(1),wf4(:,16),G0H8(34),m3h4x8(:,202),heltab2x32(:,:,604))
  call Hloop_A_Q(ntryL,G0H8(34),18,nMT,G1H8(9),n2h8(162))
  Gcoeff(:)%j = (-(c(54)*M(1,:)%j)) * den(79)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(617),h0tab(:,617),[18,13],[nMT,0],2,2,wf4(:,16),wf8(:,121))
  call Hloop_VA_Q(ntryL,G0H32(1),wf4(:,16),G0H8(36),m3h4x8(:,203),heltab2x32(:,:,605))
  call Hloop_A_Q(ntryL,G0H8(36),18,nMT,G1H8(11),n2h8(163))
  Gcoeff(:)%j = (c(56)*M(1,:)%j-c(57)*M(3,:)%j) * den(81)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(618),h0tab(:,618),[18,13],[nMT,nMH],2,2,wf4(:,16),wf8(:,123))
  call Hloop_SA_Q(ntryL,G0H32(1),wf4(:,16),G0H8(37),ngH,m3h4x8(:,204),heltab2x32(:,:,606))
  call Hloop_A_Q(ntryL,G0H8(37),18,nMT,G1H8(12),n2h8(164))
  Gcoeff(:)%j = (-(c(56)*M(1,:)%j)+c(57)*M(3,:)%j) * den(81)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(619),h0tab(:,619),[18,13],[nMT,nMZ],2,2,wf4(:,16),wf8(:,123))
  call Hloop_SA_Q(ntryL,G0H32(1),wf4(:,16),G0H8(41),ngX,m3h4x8(:,205),heltab2x32(:,:,607))
  call Hloop_A_Q(ntryL,G0H8(41),18,nMT,G1H8(24),n2h8(165))
  Gcoeff(:)%j = (-(c(44)*M(1,:)%j)+c(45)*M(3,:)%j) * den(81)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(620),h0tab(:,620),[18,13],[nMB,nMW],2,2,wf4(:,16),wf8(:,123))
  call Hloop_SA_Q(ntryL,G0H32(1),wf4(:,16),G0H8(42),ngPtb,m3h4x8(:,206),heltab2x32(:,:,608))
  call Hloop_A_Q(ntryL,G0H8(42),18,nMB,G1H8(30),n2h8(166))
  Gcoeff(:)%j = (-(c(11)*M(1,:)%j)) * den(81)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(621),h0tab(:,621),[18,13],[nMT,0],2,2,wf4(:,16),wf8(:,123))
  call Hloop_VA_Q(ntryL,G0H32(1),wf4(:,16),G0H8(44),m3h4x8(:,207),heltab2x32(:,:,609))
  call Hloop_A_Q(ntryL,G0H8(44),18,nMT,G1H8(40),n2h8(167))
  Gcoeff(:)%j = (c(16)*M(1,:)%j) * den(79)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(622),h0tab(:,622),[18,13],[nMT,0],2,2,wf4(:,16),wf8(:,125))
  call Hloop_VA_Q(ntryL,G0H32(1),wf4(:,16),G0H8(45),m3h4x8(:,208),heltab2x32(:,:,610))
  call Hloop_A_Q(ntryL,G0H8(45),18,nMT,G1H8(41),n2h8(168))
  Gcoeff(:)%j = (-(c(12)*M(1,:)%j)+c(13)*M(3,:)%j) * den(81)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(623),h0tab(:,623),[18,13],[nMT,0],2,2,wf4(:,16),wf8(:,123))
  call Hloop_VA_Q(ntryL,G0H32(1),wf4(:,16),G0H8(46),m3h4x8(:,209),heltab2x32(:,:,611))
  call Hloop_A_Q(ntryL,G0H8(46),18,nMT,G1H8(43),n2h8(169))
  Gcoeff(:)%j = (-(c(14)*M(1,:)%j)+c(15)*M(3,:)%j) * den(81)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(624),h0tab(:,624),[18,13],[nMT,nMZ],2,2,wf4(:,16),wf8(:,123))
  call Hloop_ZA_Q(ntryL,G0H32(1),wf4(:,16),G0H8(18),ngZu,m3h4x8(:,210),heltab2x32(:,:,612))
  call Hloop_A_Q(ntryL,G0H8(18),18,nMT,G1H8(47),n2h8(170))
  Gcoeff(:)%j = (-(c(39)*M(1,:)%j)+c(40)*M(3,:)%j) * den(81)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(625),h0tab(:,625),[18,13],[nMB,nMW],2,2,wf4(:,16),wf8(:,123))
  call Hloop_WA_Q(ntryL,G0H32(1),wf4(:,16),G0H8(52),m3h4x8(:,211),heltab2x32(:,:,613))
  call Hloop_A_Q(ntryL,G0H8(52),18,nMB,G1H8(49),n2h8(171))
  Gcoeff(:)%j = (-(c(29)*M(2,:)%j)+c(34)*M(4,:)%j) * den(81)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(626),h0tab(:,626),[18,13],[nMT,0],2,2,wf4(:,16),wf8(:,123))
  call Hloop_VA_Q(ntryL,G0H32(1),wf4(:,16),G0H8(51),m3h4x8(:,212),heltab2x32(:,:,614))
  call Hloop_A_Q(ntryL,G0H8(51),18,nMT,G1H8(52),n2h8(172))
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(7),[G1H4(128),G1H4(104),G0H4(5),G0H4(6),G0H4(1)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(67),[G1H4(3),G1H4(10),G0H4(3),G0H4(7),G0H4(4)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(1),[G1H4(144),G1H4(23),G1H4(113),G1H4(85),G1H4(20)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(4),[G1H4(12),G1H4(36)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(134),[G1H4(81),G1H4(88)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(2),[G1H4(25),G1H4(15)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(133),[G1H4(126),G1H4(121),G1H4(107),G1H4(30),G1H4(141)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(127),[G1H4(108),G1H4(136)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(139),[G1H4(116),G1H4(97)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(137),[G1H4(119),G1H4(98)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G0H8(6),[G0H8(2),G0H8(48)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H8(45),[G1H8(68),G1H8(63)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G0H8(38),[G0H8(29),G0H8(30)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H8(52),[G1H8(43),G1H8(40)])
  call Hcheck_last_GGG_G_12(ntryL,l_switch,G1H16(29),wf4(:,1),wf4(:,2),G1tensor(1),m4h4x4x1(:,1),heltab3x16(:,:,1))
  call Hcheck_last_GGG_G_12(ntryL,l_switch,G1H16(14),wf4(:,2),wf4(:,1),G1tensor(31),m4h4x4x1(:,2),heltab3x16(:,:,2))
  call Hcheck_last_GGG_G_23(ntryL,l_switch,G1H16(9),wf4(:,1),wf4(:,2),G1tensor(61),m4h4x4x1(:,3),heltab3x16(:,:,3))
  call Hcheck_last_UV_W(ntryL,l_switch,G1H4(7),28,wf4(:,1),3,G2tensor(107),m3h4x1(:,126),heltab2x4(:,:,392))
  call Hcheck_last_UV_W(ntryL,l_switch,G1H4(67),19,wf4(:,2),12,G2tensor(183),m3h4x1(:,127),heltab2x4(:,:,393))
  call Hloop_QV_A(ntryL,G1H4(1),wf4(:,2),G1H1(1),m3h4x1(:,128),heltab2x4(:,:,394))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,0,G2tensor(110),n2h1(430))
  call Hloop_QV_A(ntryL,G1H4(4),wf4(:,2),G1H1(1),m3h4x1(:,129),heltab2x4(:,:,395))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,nMT,G2tensor(212),n2h1(431))
  call Hloop_QV_A(ntryL,G1H4(134),wf4(:,2),G1H1(1),m3h4x1(:,130),heltab2x4(:,:,396))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,nMB,G2tensor(214),n2h1(432))
  call Hcheck_last_CV_D(ntryL,l_switch,G1H4(2),19,wf4(:,2),12,G2tensor(185),m3h4x1(:,131),heltab2x4(:,:,397))
  call Hloop_QV_A(ntryL,G1H4(133),wf4(:,1),G1H1(1),m3h4x1(:,132),heltab2x4(:,:,398))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,0,G2tensor(188),n2h1(433))
  call Hloop_QV_A(ntryL,G1H4(127),wf4(:,1),G1H1(1),m3h4x1(:,133),heltab2x4(:,:,399))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,nMT,G2tensor(125),n2h1(434))
  call Hloop_QV_A(ntryL,G1H4(139),wf4(:,1),G1H1(1),m3h4x1(:,134),heltab2x4(:,:,400))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,nMB,G2tensor(190),n2h1(435))
  call Hcheck_last_CV_D(ntryL,l_switch,G1H4(137),28,wf4(:,1),3,G2tensor(128),m3h4x1(:,135),heltab2x4(:,:,401))
  call Hloop_VA_Q(ntryL,G0H8(27),wf8(:,91),G0H1(1),m3h8x1(:,52),heltab2x8(:,:,338))
  call Hcheck_last_A_Q(ntryL,l_switch,G0H1(1),31,nMB,G1tensor(91),n2h1(436))
  call Hloop_VA_Q(ntryL,G0H8(26),wf8(:,92),G0H1(1),m3h8x1(:,53),heltab2x8(:,:,339))
  call Hcheck_last_A_Q(ntryL,l_switch,G0H1(1),31,nMB,G1tensor(121),n2h1(437))
  call Hloop_SA_Q(ntryL,G0H8(40),wf8(:,93),G0H1(1),ngH,m3h8x1(:,54),heltab2x8(:,:,340))
  call Hcheck_last_A_Q(ntryL,l_switch,G0H1(1),31,nMB,G1tensor(151),n2h1(438))
  call Hloop_SA_Q(ntryL,G0H8(39),wf8(:,93),G0H1(1),ngX,m3h8x1(:,55),heltab2x8(:,:,341))
  call Hcheck_last_A_Q(ntryL,l_switch,G0H1(1),31,nMB,G1tensor(181),n2h1(439))
  call Hloop_SA_Q(ntryL,G0H8(49),wf8(:,93),G0H1(1),ngPbt,m3h8x1(:,56),heltab2x8(:,:,342))
  call Hcheck_last_A_Q(ntryL,l_switch,G0H1(1),31,nMT,G1tensor(211),n2h1(440))
  call Hloop_VA_Q(ntryL,G0H8(6),wf8(:,93),G0H1(1),m3h8x1(:,57),heltab2x8(:,:,343))
  call Hcheck_last_A_Q(ntryL,l_switch,G0H1(1),31,nMB,G1tensor(241),n2h1(441))
  call Hloop_VA_Q(ntryL,G0H8(1),wf8(:,94),G0H1(1),m3h8x1(:,58),heltab2x8(:,:,344))
  call Hcheck_last_A_Q(ntryL,l_switch,G0H1(1),31,nMB,G1tensor(6),n2h1(442))
  call Hloop_ZA_Q(ntryL,G0H8(4),wf8(:,93),G0H1(1),ngZd,m3h8x1(:,59),heltab2x8(:,:,345))
  call Hcheck_last_A_Q(ntryL,l_switch,G0H1(1),31,nMB,G1tensor(24),n2h1(443))
  call Hloop_WA_Q(ntryL,G0H8(5),wf8(:,93),G0H1(1),m3h8x1(:,60),heltab2x8(:,:,346))
  call Hcheck_last_A_Q(ntryL,l_switch,G0H1(1),31,nMT,G1tensor(78),n2h1(444))
  call Hcheck_last_AQ_V(ntryL,l_switch,G1H8(50),wf8(:,96),G1tensor(98),m3h8x1(:,61),heltab2x8(:,:,347))
  call Hcheck_last_AQ_V(ntryL,l_switch,G1H8(36),wf8(:,97),G1tensor(126),m3h8x1(:,62),heltab2x8(:,:,348))
  call Hcheck_last_AQ_S(ntryL,l_switch,G1H8(5),wf8(:,98),G1tensor(128),ngH,m3h8x1(:,63),heltab2x8(:,:,349))
  call Hcheck_last_AQ_S(ntryL,l_switch,G1H8(57),wf8(:,98),G1tensor(140),ngX,m3h8x1(:,64),heltab2x8(:,:,350))
  call Hcheck_last_AQ_S(ntryL,l_switch,G1H8(62),wf8(:,98),G1tensor(158),ngPtb,m3h8x1(:,65),heltab2x8(:,:,351))
  call Hcheck_last_AQ_V(ntryL,l_switch,G1H8(45),wf8(:,98),G1tensor(170),m3h8x1(:,66),heltab2x8(:,:,352))
  call Hcheck_last_AQ_V(ntryL,l_switch,G1H8(64),wf8(:,99),G1tensor(186),m3h8x1(:,67),heltab2x8(:,:,353))
  call Hcheck_last_AQ_Z(ntryL,l_switch,G1H8(69),wf8(:,98),G1tensor(200),ngZd,m3h8x1(:,68),heltab2x8(:,:,354))
  call Hcheck_last_AQ_W(ntryL,l_switch,G1H8(71),wf8(:,98),G1tensor(206),m3h8x1(:,69),heltab2x8(:,:,355))
  call Hloop_VA_Q(ntryL,G0H8(17),wf8(:,101),G0H1(1),m3h8x1(:,70),heltab2x8(:,:,356))
  call Hcheck_last_A_Q(ntryL,l_switch,G0H1(1),31,nMT,G1tensor(216),n2h1(445))
  call Hloop_VA_Q(ntryL,G0H8(35),wf8(:,103),G0H1(1),m3h8x1(:,71),heltab2x8(:,:,357))
  call Hcheck_last_A_Q(ntryL,l_switch,G0H1(1),31,nMT,G1tensor(236),n2h1(446))
  call Hcheck_last_AQ_V(ntryL,l_switch,G1H8(2),wf8(:,104),G1tensor(246),m3h8x1(:,72),heltab2x8(:,:,358))
  call Hcheck_last_AQ_V(ntryL,l_switch,G1H8(3),wf8(:,105),G1tensor(254),m3h8x1(:,73),heltab2x8(:,:,359))
  call Hloop_VQ_A(ntryL,G0H8(47),wf8(:,106),G0H1(1),m3h8x1(:,74),heltab2x8(:,:,360))
  call Hcheck_last_Q_A(ntryL,l_switch,G0H1(1),31,nMT,G1tensor(4),n2h1(447))
  call Hloop_VQ_A(ntryL,G0H8(3),wf8(:,107),G0H1(1),m3h8x1(:,75),heltab2x8(:,:,361))
  call Hcheck_last_Q_A(ntryL,l_switch,G0H1(1),31,nMT,G1tensor(8),n2h1(448))
  call Hcheck_last_QA_V(ntryL,l_switch,G1H8(8),wf8(:,108),G1tensor(16),m3h8x1(:,76),heltab2x8(:,:,362))
  call Hcheck_last_QA_V(ntryL,l_switch,G1H8(15),wf8(:,109),G1tensor(129),m3h8x1(:,77),heltab2x8(:,:,363))
  call Hloop_VA_Q(ntryL,G0H8(20),wf8(:,111),G0H1(1),m3h8x1(:,78),heltab2x8(:,:,364))
  call Hcheck_last_A_Q(ntryL,l_switch,G0H1(1),31,nMT,G1tensor(35),n2h1(449))
  call Hloop_VA_Q(ntryL,G0H8(22),wf8(:,113),G0H1(1),m3h8x1(:,79),heltab2x8(:,:,365))
  call Hcheck_last_A_Q(ntryL,l_switch,G0H1(1),31,nMT,G1tensor(34),n2h1(450))
  call Hloop_SA_Q(ntryL,G0H8(23),wf8(:,115),G0H1(1),ngH,m3h8x1(:,80),heltab2x8(:,:,366))
  call Hcheck_last_A_Q(ntryL,l_switch,G0H1(1),31,nMT,G1tensor(44),n2h1(451))
  call Hloop_SA_Q(ntryL,G0H8(24),wf8(:,115),G0H1(1),ngX,m3h8x1(:,81),heltab2x8(:,:,367))
  call Hcheck_last_A_Q(ntryL,l_switch,G0H1(1),31,nMT,G1tensor(50),n2h1(452))
  call Hloop_SA_Q(ntryL,G0H8(25),wf8(:,115),G0H1(1),ngPtb,m3h8x1(:,82),heltab2x8(:,:,368))
  call Hcheck_last_A_Q(ntryL,l_switch,G0H1(1),31,nMB,G1tensor(62),n2h1(453))
  call Hloop_VA_Q(ntryL,G0H8(38),wf8(:,115),G0H1(1),m3h8x1(:,83),heltab2x8(:,:,369))
  call Hcheck_last_A_Q(ntryL,l_switch,G0H1(1),31,nMT,G1tensor(65),n2h1(454))
  call Hloop_VA_Q(ntryL,G0H8(28),wf8(:,117),G0H1(1),m3h8x1(:,84),heltab2x8(:,:,370))
  call Hcheck_last_A_Q(ntryL,l_switch,G0H1(1),31,nMT,G1tensor(74),n2h1(455))
  call Hloop_ZA_Q(ntryL,G0H8(31),wf8(:,115),G0H1(1),ngZu,m3h8x1(:,85),heltab2x8(:,:,371))
  call Hcheck_last_A_Q(ntryL,l_switch,G0H1(1),31,nMT,G1tensor(87),n2h1(456))
  call Hloop_WA_Q(ntryL,G0H8(32),wf8(:,115),G0H1(1),m3h8x1(:,86),heltab2x8(:,:,372))
  call Hcheck_last_A_Q(ntryL,l_switch,G0H1(1),31,nMB,G1tensor(94),n2h1(457))
  call Hcheck_last_AQ_V(ntryL,l_switch,G1H8(9),wf8(:,119),G1tensor(106),m3h8x1(:,87),heltab2x8(:,:,373))
  call Hcheck_last_AQ_V(ntryL,l_switch,G1H8(11),wf8(:,121),G1tensor(149),m3h8x1(:,88),heltab2x8(:,:,374))
  call Hcheck_last_AQ_S(ntryL,l_switch,G1H8(12),wf8(:,123),G1tensor(118),ngH,m3h8x1(:,89),heltab2x8(:,:,375))
  call Hcheck_last_AQ_S(ntryL,l_switch,G1H8(24),wf8(:,123),G1tensor(130),ngX,m3h8x1(:,90),heltab2x8(:,:,376))
  call Hcheck_last_AQ_S(ntryL,l_switch,G1H8(30),wf8(:,123),G1tensor(142),ngPbt,m3h8x1(:,91),heltab2x8(:,:,377))
  call Hcheck_last_AQ_V(ntryL,l_switch,G1H8(52),wf8(:,123),G1tensor(161),m3h8x1(:,92),heltab2x8(:,:,378))
  call Hcheck_last_AQ_V(ntryL,l_switch,G1H8(41),wf8(:,125),G1tensor(172),m3h8x1(:,93),heltab2x8(:,:,379))
  call Hcheck_last_AQ_Z(ntryL,l_switch,G1H8(47),wf8(:,123),G1tensor(203),ngZu,m3h8x1(:,94),heltab2x8(:,:,380))
  call Hcheck_last_AQ_W(ntryL,l_switch,G1H8(49),wf8(:,123),G1tensor(190),m3h8x1(:,95),heltab2x8(:,:,381))
  call ol_merge_tensors(G2tensor(128),[G2tensor(188),G2tensor(107),G0tensor(210),G0tensor(132),G0tensor(839),G0tensor(20) &
    ,G0tensor(106),G0tensor(6)])
  call ol_merge_tensors(G2tensor(185),[G2tensor(110),G2tensor(183),G0tensor(62),G0tensor(32),G0tensor(97),G0tensor(575) &
    ,G0tensor(376),G0tensor(11)])
  call ol_merge_tensors(G1tensor(61),[G1tensor(31),G1tensor(1),G0tensor(758),G0tensor(623),G0tensor(625),G0tensor(167) &
    ,G0tensor(367),G0tensor(2),G0tensor(842),G0tensor(86),G0tensor(61),G0tensor(36),G0tensor(16)])
  call ol_merge_tensors(G0tensor(1298),[G0tensor(1285),G0tensor(1145),G0tensor(951),G0tensor(932),G0tensor(874),G0tensor(862) &
    ,G0tensor(184),G0tensor(537),G0tensor(42),G0tensor(38),G0tensor(357),G0tensor(127),G0tensor(713),G0tensor(576),G0tensor(26)])
  call ol_merge_tensors(G1tensor(129),[G1tensor(16),G0tensor(779),G0tensor(188),G0tensor(138),G0tensor(221),G0tensor(31)])
  call ol_merge_tensors(G0tensor(1320),[G0tensor(1313),G0tensor(1306),G0tensor(1300),G0tensor(1293),G0tensor(1287),G0tensor(1282) &
    ,G0tensor(1269),G0tensor(1262),G0tensor(1256),G0tensor(1249),G0tensor(1236),G0tensor(1223),G0tensor(1203),G0tensor(1184) &
    ,G0tensor(1166),G0tensor(1153),G0tensor(1147),G0tensor(1141),G0tensor(1135),G0tensor(1123),G0tensor(1116),G0tensor(1109) &
    ,G0tensor(1102),G0tensor(1097),G0tensor(1089),G0tensor(1082),G0tensor(1075),G0tensor(1069),G0tensor(1063),G0tensor(1057) &
    ,G0tensor(1051),G0tensor(1045),G0tensor(1039),G0tensor(1034),G0tensor(1027),G0tensor(1021),G0tensor(1014),G0tensor(1008) &
    ,G0tensor(1001),G0tensor(993),G0tensor(988),G0tensor(981),G0tensor(973),G0tensor(962),G0tensor(955),G0tensor(943) &
    ,G0tensor(936),G0tensor(930),G0tensor(923),G0tensor(915),G0tensor(910),G0tensor(903),G0tensor(897),G0tensor(889),G0tensor(884) &
    ,G0tensor(878),G0tensor(872),G0tensor(864),G0tensor(857),G0tensor(843),G0tensor(813),G0tensor(790),G0tensor(780),G0tensor(704) &
    ,G0tensor(689),G0tensor(684),G0tensor(678),G0tensor(709),G0tensor(663),G0tensor(593),G0tensor(579),G0tensor(539),G0tensor(554) &
    ,G0tensor(479),G0tensor(467),G0tensor(413),G0tensor(383),G0tensor(377),G0tensor(362),G0tensor(339),G0tensor(337),G0tensor(319) &
    ,G0tensor(302),G0tensor(324),G0tensor(284),G0tensor(747),G0tensor(263),G0tensor(423),G0tensor(259),G0tensor(715),G0tensor(243) &
    ,G0tensor(235),G0tensor(635),G0tensor(187),G0tensor(108),G0tensor(107),G0tensor(342),G0tensor(100),G0tensor(412),G0tensor(512) &
    ,G0tensor(82),G0tensor(500),G0tensor(189),G0tensor(455),G0tensor(462),G0tensor(437),G0tensor(390),G0tensor(417),G0tensor(305) &
    ,G0tensor(98),G0tensor(290),G0tensor(657),G0tensor(12),G0tensor(185),G0tensor(845),G0tensor(142),G0tensor(155),G0tensor(260) &
    ,G0tensor(660),G0tensor(92),G0tensor(393),G0tensor(358),G0tensor(807),G0tensor(685),G0tensor(707),G0tensor(154),G0tensor(820) &
    ,G0tensor(365),G0tensor(816),G0tensor(646),G0tensor(586),G0tensor(556),G0tensor(531),G0tensor(501),G0tensor(471),G0tensor(441) &
    ,G0tensor(331),G0tensor(251),G0tensor(226),G0tensor(196),G0tensor(166),G0tensor(141),G0tensor(116),G0tensor(41)])
  call ol_merge_tensors(G0tensor(320),[G0tensor(285),G0tensor(662),G0tensor(680),G0tensor(232),G0tensor(4),G0tensor(267) &
    ,G0tensor(45),G0tensor(14),G0tensor(51)])
  call ol_merge_tensors(G0tensor(1095),[G0tensor(228),G0tensor(207),G0tensor(675),G0tensor(18),G0tensor(8),G0tensor(164) &
    ,G0tensor(56)])
  call ol_merge_tensors(G0tensor(1322),[G0tensor(1315),G0tensor(1308),G0tensor(1295),G0tensor(1280),G0tensor(1274),G0tensor(1263) &
    ,G0tensor(1255),G0tensor(1248),G0tensor(1242),G0tensor(1235),G0tensor(1229),G0tensor(1222),G0tensor(1215),G0tensor(1209) &
    ,G0tensor(1202),G0tensor(1196),G0tensor(1190),G0tensor(1183),G0tensor(1177),G0tensor(1171),G0tensor(1165),G0tensor(1159) &
    ,G0tensor(1129),G0tensor(1117),G0tensor(1110),G0tensor(1103),G0tensor(1096),G0tensor(1090),G0tensor(1083),G0tensor(1076) &
    ,G0tensor(1046),G0tensor(1033),G0tensor(1020),G0tensor(1006),G0tensor(994),G0tensor(986),G0tensor(974),G0tensor(968) &
    ,G0tensor(961),G0tensor(949),G0tensor(942),G0tensor(928),G0tensor(916),G0tensor(908),G0tensor(902),G0tensor(890),G0tensor(883) &
    ,G0tensor(877),G0tensor(871),G0tensor(865),G0tensor(859),G0tensor(852),G0tensor(838),G0tensor(818),G0tensor(800),G0tensor(794) &
    ,G0tensor(764),G0tensor(708),G0tensor(698),G0tensor(734),G0tensor(664),G0tensor(653),G0tensor(644),G0tensor(568),G0tensor(499) &
    ,G0tensor(549),G0tensor(469),G0tensor(614),G0tensor(452),G0tensor(424),G0tensor(508),G0tensor(370),G0tensor(523),G0tensor(334) &
    ,G0tensor(299),G0tensor(329),G0tensor(310),G0tensor(768),G0tensor(727),G0tensor(353),G0tensor(538),G0tensor(717),G0tensor(247) &
    ,G0tensor(275),G0tensor(677),G0tensor(665),G0tensor(298),G0tensor(239),G0tensor(647),G0tensor(214),G0tensor(640),G0tensor(642) &
    ,G0tensor(177),G0tensor(620),G0tensor(488),G0tensor(163),G0tensor(150),G0tensor(582),G0tensor(577),G0tensor(557),G0tensor(787) &
    ,G0tensor(545),G0tensor(728),G0tensor(497),G0tensor(110),G0tensor(490),G0tensor(105),G0tensor(52),G0tensor(68),G0tensor(325) &
    ,G0tensor(198),G0tensor(355),G0tensor(7),G0tensor(195),G0tensor(670),G0tensor(830),G0tensor(723),G0tensor(798),G0tensor(812) &
    ,G0tensor(144),G0tensor(834),G0tensor(119),G0tensor(124),G0tensor(530),G0tensor(15),G0tensor(30),G0tensor(480),G0tensor(786) &
    ,G0tensor(756),G0tensor(726),G0tensor(696),G0tensor(671),G0tensor(641),G0tensor(616),G0tensor(591),G0tensor(561),G0tensor(411) &
    ,G0tensor(386),G0tensor(361),G0tensor(306),G0tensor(281),G0tensor(201),G0tensor(171),G0tensor(91),G0tensor(66)])
  call ol_merge_tensors(G0tensor(1272),[G0tensor(1175),G0tensor(1169),G0tensor(1163),G0tensor(1042),G0tensor(208),G0tensor(617) &
    ,G0tensor(607),G0tensor(57),G0tensor(54),G0tensor(175),G0tensor(205),G0tensor(139),G0tensor(661),G0tensor(631),G0tensor(76)])
  call ol_merge_tensors(G1tensor(172),[G1tensor(161),G1tensor(149),G1tensor(106),G0tensor(901),G0tensor(213),G0tensor(182) &
    ,G0tensor(498),G0tensor(64),G0tensor(827),G0tensor(381),G0tensor(81)])
  call ol_merge_tensors(G0tensor(1265),[G0tensor(1094),G0tensor(998),G0tensor(978),G0tensor(569),G0tensor(352),G0tensor(312) &
    ,G0tensor(292),G0tensor(482),G0tensor(88),G0tensor(83),G0tensor(157),G0tensor(626),G0tensor(321),G0tensor(126) &
    ,G0tensor(101)])
  call ol_merge_tensors(G1tensor(254),[G1tensor(246),G1tensor(186),G1tensor(170),G1tensor(126),G1tensor(98),G0tensor(634) &
    ,G0tensor(274),G0tensor(244),G0tensor(338),G0tensor(410),G0tensor(326),G0tensor(161),G0tensor(111)])
  call ol_merge_tensors(G1tensor(6),[G1tensor(241),G1tensor(121),G1tensor(91),G0tensor(1122),G0tensor(1068),G0tensor(1062) &
    ,G0tensor(404),G0tensor(340),G0tensor(282),G0tensor(802),G0tensor(131)])
  call ol_merge_tensors(G0tensor(809),[G0tensor(722),G0tensor(420),G0tensor(772),G0tensor(470),G0tensor(597),G0tensor(425) &
    ,G0tensor(23),G0tensor(700),G0tensor(159),G0tensor(565),G0tensor(841),G0tensor(246),G0tensor(191),G0tensor(136)])
  call ol_merge_tensors(G0tensor(1004),[G0tensor(984),G0tensor(478),G0tensor(434),G0tensor(389),G0tensor(372),G0tensor(147) &
    ,G0tensor(832),G0tensor(636),G0tensor(181),G0tensor(151)])
  call ol_merge_tensors(G0tensor(964),[G0tensor(945),G0tensor(861),G0tensor(775),G0tensor(759),G0tensor(598),G0tensor(484) &
    ,G0tensor(418),G0tensor(844),G0tensor(656),G0tensor(541),G0tensor(396),G0tensor(371),G0tensor(156)])
  call ol_merge_tensors(G0tensor(1029),[G0tensor(1016),G0tensor(992),G0tensor(972),G0tensor(494),G0tensor(449),G0tensor(215) &
    ,G0tensor(162),G0tensor(165),G0tensor(551),G0tensor(186)])
  call ol_merge_tensors(G2tensor(190),[G0tensor(307),G0tensor(129),G0tensor(811),G0tensor(511),G0tensor(481),G0tensor(451) &
    ,G0tensor(421),G0tensor(316),G0tensor(236),G0tensor(211)])
  call ol_merge_tensors(G0tensor(1162),[G0tensor(920),G0tensor(900),G0tensor(894),G0tensor(514),G0tensor(445),G0tensor(220) &
    ,G0tensor(840),G0tensor(122),G0tensor(216)])
  call ol_merge_tensors(G2tensor(214),[G0tensor(350),G0tensor(522),G0tensor(69),G0tensor(60),G0tensor(487),G0tensor(773) &
    ,G0tensor(752),G0tensor(548),G0tensor(241)])
  call ol_merge_tensors(G2tensor(125),[G0tensor(547),G0tensor(40),G0tensor(35),G0tensor(751),G0tensor(691),G0tensor(666) &
    ,G0tensor(341),G0tensor(291),G0tensor(261)])
  call ol_merge_tensors(G0tensor(1259),[G0tensor(1113),G0tensor(753),G0tensor(388),G0tensor(9),G0tensor(266)])
  call ol_merge_tensors(G0tensor(724),[G0tensor(558),G0tensor(475),G0tensor(271)])
  call ol_merge_tensors(G0tensor(1281),[G0tensor(1275),G0tensor(1268),G0tensor(1261),G0tensor(1160),G0tensor(1154),G0tensor(1148) &
    ,G0tensor(1130),G0tensor(1124),G0tensor(1118),G0tensor(1111),G0tensor(1058),G0tensor(870),G0tensor(858),G0tensor(851) &
    ,G0tensor(846),G0tensor(795),G0tensor(760),G0tensor(754),G0tensor(668),G0tensor(719),G0tensor(599),G0tensor(584),G0tensor(619) &
    ,G0tensor(624),G0tensor(819),G0tensor(687),G0tensor(229),G0tensor(218),G0tensor(222),G0tensor(293),G0tensor(308),G0tensor(193) &
    ,G0tensor(192),G0tensor(585),G0tensor(194),G0tensor(50),G0tensor(47),G0tensor(17),G0tensor(825),G0tensor(277),G0tensor(134) &
    ,G0tensor(815),G0tensor(315),G0tensor(821),G0tensor(356),G0tensor(276)])
  call ol_merge_tensors(G2tensor(212),[G0tensor(465),G0tensor(560),G0tensor(118),G0tensor(117),G0tensor(492),G0tensor(180) &
    ,G0tensor(317),G0tensor(145),G0tensor(262),G0tensor(296)])
  call ol_merge_tensors(G0tensor(1214),[G0tensor(1195),G0tensor(882),G0tensor(739),G0tensor(190),G0tensor(103),G0tensor(495) &
    ,G0tensor(510),G0tensor(44),G0tensor(835),G0tensor(535),G0tensor(85),G0tensor(781),G0tensor(721),G0tensor(611),G0tensor(406) &
    ,G0tensor(301)])
  call ol_merge_tensors(G0tensor(1106),[G0tensor(209),G0tensor(652),G0tensor(148),G0tensor(59),G0tensor(346)])
  call ol_merge_tensors(G1tensor(206),[G1tensor(158),G0tensor(869),G0tensor(608),G0tensor(53),G0tensor(351)])
  call ol_merge_tensors(G1tensor(74),[G1tensor(65),G1tensor(34),G1tensor(35),G1tensor(236),G1tensor(216),G0tensor(1208) &
    ,G0tensor(1189),G0tensor(1158),G0tensor(876),G0tensor(797),G0tensor(595),G0tensor(748),G0tensor(401)])
  call ol_merge_tensors(G0tensor(1219),[G0tensor(1180),G0tensor(939),G0tensor(933),G0tensor(502),G0tensor(426)])
  call ol_merge_tensors(G0tensor(120),[G0tensor(431)])
  call ol_merge_tensors(G0tensor(1314),[G0tensor(1294),G0tensor(1288),G0tensor(1247),G0tensor(1228),G0tensor(1221),G0tensor(1197) &
    ,G0tensor(1191),G0tensor(1185),G0tensor(1172),G0tensor(1136),G0tensor(1091),G0tensor(1077),G0tensor(1064),G0tensor(1040) &
    ,G0tensor(1019),G0tensor(1013),G0tensor(987),G0tensor(980),G0tensor(975),G0tensor(948),G0tensor(941),G0tensor(935) &
    ,G0tensor(909),G0tensor(896),G0tensor(891),G0tensor(463),G0tensor(438),G0tensor(409),G0tensor(385),G0tensor(322),G0tensor(384) &
    ,G0tensor(249),G0tensor(248),G0tensor(333),G0tensor(702),G0tensor(203),G0tensor(197),G0tensor(612),G0tensor(483),G0tensor(600) &
    ,G0tensor(170),G0tensor(552),G0tensor(80),G0tensor(77),G0tensor(63),G0tensor(28),G0tensor(280),G0tensor(525),G0tensor(10) &
    ,G0tensor(731),G0tensor(701),G0tensor(496),G0tensor(436)])
  call ol_merge_tensors(G0tensor(1232),[G0tensor(1199),G0tensor(958),G0tensor(952),G0tensor(67),G0tensor(456)])
  call ol_merge_tensors(G0tensor(450),[G0tensor(461)])
  call ol_merge_tensors(G0tensor(1321),[G0tensor(1307),G0tensor(1301),G0tensor(1254),G0tensor(1241),G0tensor(1234),G0tensor(1216) &
    ,G0tensor(1210),G0tensor(1204),G0tensor(1178),G0tensor(1142),G0tensor(1104),G0tensor(1084),G0tensor(1070),G0tensor(1052) &
    ,G0tensor(1032),G0tensor(1026),G0tensor(1007),G0tensor(1000),G0tensor(995),G0tensor(967),G0tensor(960),G0tensor(954) &
    ,G0tensor(929),G0tensor(922),G0tensor(917),G0tensor(503),G0tensor(589),G0tensor(474),G0tensor(387),G0tensor(429),G0tensor(344) &
    ,G0tensor(440),G0tensor(433),G0tensor(268),G0tensor(732),G0tensor(373),G0tensor(224),G0tensor(183),G0tensor(622),G0tensor(173) &
    ,G0tensor(458),G0tensor(443),G0tensor(335),G0tensor(405),G0tensor(90),G0tensor(158),G0tensor(610),G0tensor(109),G0tensor(114) &
    ,G0tensor(791),G0tensor(761),G0tensor(526),G0tensor(466)])
  call ol_merge_tensors(G0tensor(1245),[G0tensor(1017),G0tensor(1011),G0tensor(403),G0tensor(279),G0tensor(692),G0tensor(517) &
    ,G0tensor(149),G0tensor(486)])
  call ol_merge_tensors(G1tensor(128),[G0tensor(395),G0tensor(439),G0tensor(289),G0tensor(78),G0tensor(491)])
  call ol_merge_tensors(G0tensor(1252),[G0tensor(1030),G0tensor(1024),G0tensor(472),G0tensor(273),G0tensor(725),G0tensor(89) &
    ,G0tensor(13),G0tensor(516)])
  call ol_merge_tensors(G1tensor(200),[G1tensor(140),G0tensor(374),G0tensor(528),G0tensor(354),G0tensor(400),G0tensor(521)])
  call ol_merge_tensors(G0tensor(1151),[G0tensor(1139),G0tensor(1133),G0tensor(1023),G0tensor(1010),G0tensor(729),G0tensor(714) &
    ,G0tensor(778),G0tensor(48),G0tensor(375),G0tensor(3),G0tensor(392),G0tensor(152),G0tensor(546)])
  call ol_merge_tensors(G0tensor(1238),[G0tensor(1225),G0tensor(849),G0tensor(604),G0tensor(519),G0tensor(740),G0tensor(408) &
    ,G0tensor(238),G0tensor(402),G0tensor(130),G0tensor(605),G0tensor(380),G0tensor(330),G0tensor(601),G0tensor(571)])
  call ol_merge_tensors(G0tensor(1318),[G0tensor(1311),G0tensor(1231),G0tensor(1218),G0tensor(1081),G0tensor(1074),G0tensor(782) &
    ,G0tensor(255),G0tensor(347),G0tensor(581)])
  call ol_merge_tensors(G1tensor(8),[G1tensor(4),G0tensor(1128),G0tensor(674),G0tensor(733),G0tensor(19),G0tensor(822) &
    ,G0tensor(606)])
  call ol_merge_tensors(G0tensor(970),[G0tensor(886),G0tensor(368),G0tensor(762),G0tensor(200),G0tensor(711),G0tensor(681)])
  call ol_merge_tensors(G0tensor(1290),[G0tensor(1194),G0tensor(1188),G0tensor(1181),G0tensor(457),G0tensor(422),G0tensor(454) &
    ,G0tensor(738),G0tensor(686)])
  call ol_merge_tensors(G1tensor(44),[G0tensor(1170),G0tensor(985),G0tensor(907),G0tensor(112),G0tensor(716)])
  call ol_merge_tensors(G0tensor(990),[G0tensor(912),G0tensor(378),G0tensor(643),G0tensor(169),G0tensor(771),G0tensor(741)])
  call ol_merge_tensors(G0tensor(1303),[G0tensor(1213),G0tensor(1207),G0tensor(1200),G0tensor(504),G0tensor(493),G0tensor(464) &
    ,G0tensor(555),G0tensor(746)])
  call ol_merge_tensors(G1tensor(87),[G1tensor(50),G0tensor(1176),G0tensor(1005),G0tensor(927),G0tensor(777),G0tensor(776)])
  call ol_merge_tensors(G0tensor(824),[G0tensor(654),G0tensor(658),G0tensor(588),G0tensor(831),G0tensor(801)])
  call ol_merge_tensors(G0tensor(1121),[G0tensor(1114),G0tensor(629),G0tensor(757),G0tensor(806)])
  call ol_merge_tensors(G1tensor(94),[G1tensor(62),G0tensor(1152),G0tensor(856),G0tensor(397),G0tensor(836)])
  call ol_merge_tensors(G0tensor(1086),[G0tensor(1072),G0tensor(294),G0tensor(705),G0tensor(227),G0tensor(527),G0tensor(345)])
  call ol_merge_tensors(G0tensor(1310),[G0tensor(735),G0tensor(313),G0tensor(234),G0tensor(128),G0tensor(295)])
  call ol_merge_tensors(G0tensor(133),[G0tensor(125)])
  call ol_merge_tensors(G0tensor(1099),[G0tensor(1079),G0tensor(364),G0tensor(283),G0tensor(655),G0tensor(550),G0tensor(95)])
  call ol_merge_tensors(G0tensor(1317),[G0tensor(278),G0tensor(750),G0tensor(258),G0tensor(477),G0tensor(75)])
  call ol_merge_tensors(G0tensor(143),[G0tensor(540)])
  call ol_merge_tensors(G0tensor(868),[G0tensor(699),G0tensor(473),G0tensor(618),G0tensor(805),G0tensor(562)])
  call ol_merge_tensors(G0tensor(1277),[G0tensor(1107),G0tensor(1055),G0tensor(534),G0tensor(553),G0tensor(328)])
  call ol_merge_tensors(G0tensor(1146),[G0tensor(789),G0tensor(543),G0tensor(590)])
  call ol_merge_tensors(G1tensor(151),[G0tensor(1134),G0tensor(573),G0tensor(269),G0tensor(602)])
  call ol_merge_tensors(G1tensor(24),[G1tensor(181),G0tensor(1140),G0tensor(489),G0tensor(287),G0tensor(710)])
  call ol_merge_tensors(G0tensor(1056),[G0tensor(1050),G0tensor(1044),G0tensor(1038),G0tensor(297),G0tensor(123),G0tensor(570) &
    ,G0tensor(837)])
  call ol_merge_tensors(G0tensor(1127),[G0tensor(854),G0tensor(848),G0tensor(828),G0tensor(460),G0tensor(637)])
  call ol_merge_tensors(G0tensor(1087),[G0tensor(1061),G0tensor(983),G0tensor(977),G0tensor(971),G0tensor(79),G0tensor(27)])
  call ol_merge_tensors(G0tensor(1100),[G0tensor(1067),G0tensor(1003),G0tensor(997),G0tensor(991),G0tensor(360),G0tensor(33)])
  call ol_merge_tensors(G0tensor(1157),[G0tensor(785),G0tensor(755),G0tensor(694),G0tensor(520),G0tensor(49)])
  call ol_merge_tensors(G0tensor(1073),[G0tensor(1037),G0tensor(905),G0tensor(893),G0tensor(887),G0tensor(65),G0tensor(115)])
  call ol_merge_tensors(G0tensor(1080),[G0tensor(1049),G0tensor(925),G0tensor(919),G0tensor(913),G0tensor(430),G0tensor(507)])
  call ol_merge_tensors(G0tensor(542),[G0tensor(99)])
  call ol_merge_tensors(G1tensor(78),[G1tensor(211),G0tensor(1279),G0tensor(1273),G0tensor(592)])
  call ol_merge_tensors(G0tensor(1060),[G0tensor(1036),G0tensor(309),G0tensor(202),G0tensor(428),G0tensor(160)])
  call ol_merge_tensors(G0tensor(1168),[G0tensor(979),G0tensor(895),G0tensor(690),G0tensor(172),G0tensor(633)])
  call ol_merge_tensors(G0tensor(1066),[G0tensor(1048),G0tensor(349),G0tensor(645),G0tensor(627),G0tensor(615)])
  call ol_merge_tensors(G0tensor(1174),[G0tensor(999),G0tensor(921),G0tensor(212),G0tensor(179),G0tensor(638)])
  call ol_merge_tensors(G0tensor(1156),[G0tensor(1054),G0tensor(639),G0tensor(444),G0tensor(783),G0tensor(613)])
  call ol_merge_tensors(G0tensor(1271),[G0tensor(1144),G0tensor(770),G0tensor(509),G0tensor(650),G0tensor(628),G0tensor(468)])
  call ol_merge_tensors(G0tensor(1266),[G0tensor(1126),G0tensor(1120),G0tensor(649),G0tensor(563),G0tensor(265),G0tensor(303)])
  call ol_merge_tensors(G0tensor(1150),[G0tensor(850),G0tensor(583),G0tensor(564),G0tensor(230),G0tensor(672)])
  call ol_merge_tensors(G0tensor(1258),[G0tensor(833),G0tensor(688),G0tensor(683),G0tensor(414),G0tensor(304),G0tensor(379) &
    ,G0tensor(763),G0tensor(257),G0tensor(712),G0tensor(697)])
  call ol_merge_tensors(G0tensor(1284),[G0tensor(1132),G0tensor(442),G0tensor(254),G0tensor(533)])
  call ol_merge_tensors(G0tensor(1251),[G0tensor(1244),G0tensor(1115),G0tensor(1101),G0tensor(1093),G0tensor(1088),G0tensor(855) &
    ,G0tensor(693),G0tensor(659),G0tensor(703),G0tensor(513),G0tensor(369),G0tensor(252),G0tensor(720)])
  call ol_merge_tensors(G0tensor(1297),[G0tensor(1138),G0tensor(594),G0tensor(742),G0tensor(730)])
  call ol_merge_tensors(G0tensor(1278),[G0tensor(1201),G0tensor(1182),G0tensor(1164),G0tensor(926),G0tensor(906),G0tensor(881) &
    ,G0tensor(875),G0tensor(804),G0tensor(774),G0tensor(749)])
  call ol_merge_tensors(G0tensor(1304),[G0tensor(1291),G0tensor(1108),G0tensor(1043),G0tensor(957),G0tensor(938),G0tensor(914) &
    ,G0tensor(899),G0tensor(888),G0tensor(880),G0tensor(867),G0tensor(863),G0tensor(808),G0tensor(799)])
  call ol_merge_tensors(G0tensor(1226),[G0tensor(1187),G0tensor(1012),G0tensor(946),G0tensor(934)])
  call ol_merge_tensors(G1tensor(118),[G0tensor(1193),G0tensor(1018),G0tensor(947),G0tensor(940)])
  call ol_merge_tensors(G0tensor(1239),[G0tensor(1206),G0tensor(1025),G0tensor(965),G0tensor(953)])
  call ol_merge_tensors(G1tensor(203),[G1tensor(130),G0tensor(1212),G0tensor(1031),G0tensor(966),G0tensor(959)])
  call ol_merge_tensors(G0tensor(1246),[G0tensor(1227),G0tensor(1220)])
  call ol_merge_tensors(G0tensor(1253),[G0tensor(1240),G0tensor(1233)])
  call ol_merge_tensors(G1tensor(190),[G1tensor(142),G0tensor(1267),G0tensor(1260)])
  call ol_merge_tensors(G0tensor(1312),[G0tensor(1292),G0tensor(1286)])
  call ol_merge_tensors(G0tensor(1319),[G0tensor(1305),G0tensor(1299)])
call TI_bubble_red(G2tensor(128),28,mass2set(:,1),G0tensor(1),M2L1R1)
call TI_bubble_red(G2tensor(185),19,mass2set(:,1),G0tensor(21),M2L1R1)
call TI_bubble_red(G2tensor(190),28,mass2set(:,2),G0tensor(46),M2L1R1,G0tensor(71))
call TI_bubble_red(G2tensor(214),19,mass2set(:,2),G0tensor(96),M2L1R1,G0tensor(121))
call TI_bubble_red(G2tensor(125),28,mass2set(:,3),G0tensor(146),M2L1R1,G0tensor(176))
call TI_bubble_red(G2tensor(212),19,mass2set(:,3),G0tensor(206),M2L1R1,G0tensor(231))
  call ol_merge_tensors(G0tensor(121),[G0tensor(71),G0tensor(1320)])
  call ol_merge_tensors(G0tensor(231),[G0tensor(176),G0tensor(1322)])
call TI_bubble_red(G1tensor(61),16,mass2set(:,1),G0tensor(256),M2L1R1)
call TI_bubble_red(G1tensor(129),20,mass2set(:,4),G0tensor(286),M2L1R1,G0tensor(311))
call TI_bubble_red(G1tensor(172),18,mass2set(:,5),G0tensor(336),M2L1R1,G0tensor(366))
call TI_bubble_red(G1tensor(254),24,mass2set(:,4),G0tensor(391),M2L1R1,G0tensor(416))
call TI_bubble_red(G1tensor(6),20,mass2set(:,6),G0tensor(446),M2L1R1,G0tensor(476))
call TI_bubble_red(G1tensor(206),24,mass2set(:,7),G0tensor(506),M2L1R1,G0tensor(536),G0tensor(566))
call TI_bubble_red(G1tensor(74),17,mass2set(:,8),G0tensor(596),M2L1R1,G0tensor(621))
call TI_bubble_red(G1tensor(128),24,mass2set(:,9),G0tensor(651),M2L1R1,G0tensor(676),G0tensor(706))
call TI_bubble_red(G1tensor(200),24,mass2set(:,10),G0tensor(736),M2L1R1,G0tensor(766),G0tensor(796))
call TI_bubble_red(G1tensor(8),18,mass2set(:,8),G0tensor(826),M2L1R1,G0tensor(34))
call TI_bubble_red(G1tensor(44),17,mass2set(:,11),G0tensor(415),M2L1R1,G0tensor(25),G0tensor(5))
call TI_bubble_red(G1tensor(87),17,mass2set(:,12),G0tensor(515),M2L1R1,G0tensor(104),G0tensor(94))
call TI_bubble_red(G1tensor(94),17,mass2set(:,13),G0tensor(810),M2L1R1,G0tensor(572),G0tensor(153))
call TI_bubble_red(G1tensor(151),20,mass2set(:,14),G0tensor(767),M2L1R1,G0tensor(432),G0tensor(168))
call TI_bubble_red(G1tensor(24),20,mass2set(:,15),G0tensor(174),M2L1R1,G0tensor(178),G0tensor(630))
call TI_bubble_red(G1tensor(78),20,mass2set(:,16),G0tensor(632),M2L1R1,G0tensor(788),G0tensor(237))
call TI_bubble_red(G1tensor(118),18,mass2set(:,17),G0tensor(199),M2L1R1,G0tensor(695),G0tensor(204))
call TI_bubble_red(G1tensor(203),18,mass2set(:,18),G0tensor(829),M2L1R1,G0tensor(288),G0tensor(219))
call TI_bubble_red(G1tensor(190),18,mass2set(:,19),G0tensor(217),M2L1R1,G0tensor(223),G0tensor(682))
  call ol_merge_tensors(G0tensor(682),[G0tensor(178),G0tensor(432),G0tensor(572),G0tensor(796),G0tensor(706),G0tensor(476) &
    ,G0tensor(416),G0tensor(121),G0tensor(311)])
  call ol_merge_tensors(G0tensor(219),[G0tensor(204),G0tensor(788),G0tensor(104),G0tensor(25),G0tensor(34),G0tensor(621) &
    ,G0tensor(566),G0tensor(366),G0tensor(231)])
  call ol_merge_tensors(G0tensor(223),[G0tensor(237),G0tensor(153),G0tensor(536),G0tensor(1281)])
  call ol_merge_tensors(G0tensor(695),[G0tensor(168),G0tensor(5),G0tensor(676),G0tensor(1314)])
  call ol_merge_tensors(G0tensor(288),[G0tensor(630),G0tensor(94),G0tensor(766),G0tensor(1321)])
  call ol_merge_tensors(T0sum(389),[G0tensor(1)])
  call ol_merge_tensors(T0sum(390),[G0tensor(21)])
  call ol_merge_tensors(T0sum(391),[G0tensor(256)])
  call ol_merge_tensors(T0sum(392),[G0tensor(1298)])
  call ol_merge_tensors(T0sum(393),[G0tensor(286)])
  call ol_merge_tensors(T0sum(394),[G0tensor(682)])
  call ol_merge_tensors(T0sum(395),[G0tensor(320)])
  call ol_merge_tensors(T0sum(396),[G0tensor(1095)])
  call ol_merge_tensors(T0sum(397),[G0tensor(219)])
  call ol_merge_tensors(T0sum(398),[G0tensor(1272)])
  call ol_merge_tensors(T0sum(399),[G0tensor(336)])
  call ol_merge_tensors(T0sum(400),[G0tensor(1265)])
  call ol_merge_tensors(T0sum(401),[G0tensor(391)])
  call ol_merge_tensors(T0sum(402),[G0tensor(446)])
  call ol_merge_tensors(T0sum(403),[G0tensor(809)])
  call ol_merge_tensors(T0sum(404),[G0tensor(1004)])
  call ol_merge_tensors(T0sum(405),[G0tensor(964)])
  call ol_merge_tensors(T0sum(406),[G0tensor(1029)])
  call ol_merge_tensors(T0sum(407),[G0tensor(46)])
  call ol_merge_tensors(T0sum(408),[G0tensor(1162)])
  call ol_merge_tensors(T0sum(409),[G0tensor(96)])
  call ol_merge_tensors(T0sum(410),[G0tensor(146)])
  call ol_merge_tensors(T0sum(411),[G0tensor(1259)])
  call ol_merge_tensors(T0sum(412),[G0tensor(724)])
  call ol_merge_tensors(T0sum(413),[G0tensor(223)])
  call ol_merge_tensors(T0sum(414),[G0tensor(206)])
  call ol_merge_tensors(T0sum(415),[G0tensor(1214)])
  call ol_merge_tensors(T0sum(416),[G0tensor(1106)])
  call ol_merge_tensors(T0sum(417),[G0tensor(506)])
  call ol_merge_tensors(T0sum(418),[G0tensor(596)])
  call ol_merge_tensors(T0sum(419),[G0tensor(1219)])
  call ol_merge_tensors(T0sum(420),[G0tensor(120)])
  call ol_merge_tensors(T0sum(421),[G0tensor(695)])
  call ol_merge_tensors(T0sum(422),[G0tensor(1232)])
  call ol_merge_tensors(T0sum(423),[G0tensor(450)])
  call ol_merge_tensors(T0sum(424),[G0tensor(288)])
  call ol_merge_tensors(T0sum(425),[G0tensor(1245)])
  call ol_merge_tensors(T0sum(426),[G0tensor(651)])
  call ol_merge_tensors(T0sum(427),[G0tensor(1252)])
  call ol_merge_tensors(T0sum(428),[G0tensor(736)])
  call ol_merge_tensors(T0sum(429),[G0tensor(1151)])
  call ol_merge_tensors(T0sum(430),[G0tensor(1238)])
  call ol_merge_tensors(T0sum(431),[G0tensor(1318)])
  call ol_merge_tensors(T0sum(432),[G0tensor(826)])
  call ol_merge_tensors(T0sum(433),[G0tensor(970)])
  call ol_merge_tensors(T0sum(434),[G0tensor(1290)])
  call ol_merge_tensors(T0sum(435),[G0tensor(415)])
  call ol_merge_tensors(T0sum(436),[G0tensor(990)])
  call ol_merge_tensors(T0sum(437),[G0tensor(1303)])
  call ol_merge_tensors(T0sum(438),[G0tensor(515)])
  call ol_merge_tensors(T0sum(439),[G0tensor(824)])
  call ol_merge_tensors(T0sum(440),[G0tensor(1121)])
  call ol_merge_tensors(T0sum(441),[G0tensor(810)])
  call ol_merge_tensors(T0sum(442),[G0tensor(1086)])
  call ol_merge_tensors(T0sum(443),[G0tensor(1310)])
  call ol_merge_tensors(T0sum(444),[G0tensor(133)])
  call ol_merge_tensors(T0sum(445),[G0tensor(1099)])
  call ol_merge_tensors(T0sum(446),[G0tensor(1317)])
  call ol_merge_tensors(T0sum(447),[G0tensor(143)])
  call ol_merge_tensors(T0sum(448),[G0tensor(868)])
  call ol_merge_tensors(T0sum(449),[G0tensor(1277)])
  call ol_merge_tensors(T0sum(450),[G0tensor(1146)])
  call ol_merge_tensors(T0sum(451),[G0tensor(767)])
  call ol_merge_tensors(T0sum(452),[G0tensor(174)])
  call ol_merge_tensors(T0sum(453),[G0tensor(1056)])
  call ol_merge_tensors(T0sum(454),[G0tensor(1127)])
  call ol_merge_tensors(T0sum(455),[G0tensor(1087)])
  call ol_merge_tensors(T0sum(456),[G0tensor(1100)])
  call ol_merge_tensors(T0sum(457),[G0tensor(1157)])
  call ol_merge_tensors(T0sum(458),[G0tensor(1073)])
  call ol_merge_tensors(T0sum(459),[G0tensor(1080)])
  call ol_merge_tensors(T0sum(460),[G0tensor(542)])
  call ol_merge_tensors(T0sum(461),[G0tensor(632)])
  call ol_merge_tensors(T0sum(462),[G0tensor(1060)])
  call ol_merge_tensors(T0sum(463),[G0tensor(1168)])
  call ol_merge_tensors(T0sum(464),[G0tensor(1066)])
  call ol_merge_tensors(T0sum(465),[G0tensor(1174)])
  call ol_merge_tensors(T0sum(466),[G0tensor(1156)])
  call ol_merge_tensors(T0sum(467),[G0tensor(1271)])
  call ol_merge_tensors(T0sum(468),[G0tensor(1266)])
  call ol_merge_tensors(T0sum(469),[G0tensor(1150)])
  call ol_merge_tensors(T0sum(470),[G0tensor(1258)])
  call ol_merge_tensors(T0sum(471),[G0tensor(1284)])
  call ol_merge_tensors(T0sum(472),[G0tensor(1251)])
  call ol_merge_tensors(T0sum(473),[G0tensor(1297)])
  call ol_merge_tensors(T0sum(474),[G0tensor(1278)])
  call ol_merge_tensors(T0sum(475),[G0tensor(1304)])
  call ol_merge_tensors(T0sum(476),[G0tensor(1226)])
  call ol_merge_tensors(T0sum(477),[G0tensor(199)])
  call ol_merge_tensors(T0sum(478),[G0tensor(1239)])
  call ol_merge_tensors(T0sum(479),[G0tensor(829)])
  call ol_merge_tensors(T0sum(480),[G0tensor(1246)])
  call ol_merge_tensors(T0sum(481),[G0tensor(1253)])
  call ol_merge_tensors(T0sum(482),[G0tensor(217)])
  call ol_merge_tensors(T0sum(483),[G0tensor(1312)])
  call ol_merge_tensors(T0sum(484),[G0tensor(1319)])


! Compute scalar Master integrals 

  call compute_scalar_box([ 18, 19, 23 ],masses2_186,RedSet_4(1),ScalarBoxes(1))
  call compute_scalar_box([ 16, 19, 23 ],masses2_128,RedSet_4(2),ScalarBoxes(2))
  call compute_scalar_box([ 16, 18, 23 ],masses2_131,RedSet_4(3),ScalarBoxes(3))
  call compute_scalar_box([ 16, 18, 19 ],masses2_132,RedSet_4(4),ScalarBoxes(4))
  call compute_scalar_box([ 2, 3, 7 ],masses2_186,RedSet_4(5),ScalarBoxes(5))
  call compute_scalar_box([ 18, 19, 23 ],masses2_193,RedSet_4(1),ScalarBoxes(6))
  call compute_scalar_box([ 16, 19, 23 ],masses2_142,RedSet_4(2),ScalarBoxes(7))
  call compute_scalar_box([ 16, 18, 19 ],masses2_138,RedSet_4(4),ScalarBoxes(8))
  call compute_scalar_box([ 2, 3, 7 ],masses2_193,RedSet_4(5),ScalarBoxes(9))
  call compute_scalar_box([ 18, 19, 23 ],masses2_171,RedSet_4(1),ScalarBoxes(10))
  call compute_scalar_box([ 16, 19, 23 ],masses2_120,RedSet_4(2),ScalarBoxes(11))
  call compute_scalar_box([ 16, 18, 19 ],masses2_129,RedSet_4(4),ScalarBoxes(12))
  call compute_scalar_box([ 2, 3, 7 ],masses2_171,RedSet_4(5),ScalarBoxes(13))
  call compute_scalar_box([ 20, 22, 23 ],masses2_161,RedSet_4(6),ScalarBoxes(14))
  call compute_scalar_box([ 16, 22, 23 ],masses2_140,RedSet_4(7),ScalarBoxes(15))
  call compute_scalar_box([ 16, 20, 23 ],masses2_122,RedSet_4(8),ScalarBoxes(16))
  call compute_scalar_box([ 16, 20, 22 ],masses2_124,RedSet_4(9),ScalarBoxes(17))
  call compute_scalar_box([ 4, 6, 7 ],masses2_161,RedSet_4(10),ScalarBoxes(18))
  call compute_scalar_box([ 18, 19, 27 ],masses2_186,RedSet_4(11),ScalarBoxes(19))
  call compute_scalar_box([ 16, 19, 27 ],masses2_128,RedSet_4(12),ScalarBoxes(20))
  call compute_scalar_box([ 16, 18, 27 ],masses2_131,RedSet_4(13),ScalarBoxes(21))
  call compute_scalar_box([ 2, 3, 11 ],masses2_186,RedSet_4(14),ScalarBoxes(22))
  call compute_scalar_box([ 18, 19, 27 ],masses2_193,RedSet_4(11),ScalarBoxes(23))
  call compute_scalar_box([ 16, 19, 27 ],masses2_142,RedSet_4(12),ScalarBoxes(24))
  call compute_scalar_box([ 2, 3, 11 ],masses2_193,RedSet_4(14),ScalarBoxes(25))
  call compute_scalar_box([ 18, 19, 27 ],masses2_171,RedSet_4(11),ScalarBoxes(26))
  call compute_scalar_box([ 16, 19, 27 ],masses2_120,RedSet_4(12),ScalarBoxes(27))
  call compute_scalar_box([ 2, 3, 11 ],masses2_171,RedSet_4(14),ScalarBoxes(28))
  call compute_scalar_box([ 17, 19, 23 ],masses2_186,RedSet_4(15),ScalarBoxes(29))
  call compute_scalar_box([ 16, 17, 23 ],masses2_131,RedSet_4(16),ScalarBoxes(30))
  call compute_scalar_box([ 16, 17, 19 ],masses2_132,RedSet_4(17),ScalarBoxes(31))
  call compute_scalar_box([ 1, 3, 7 ],masses2_186,RedSet_4(18),ScalarBoxes(32))
  call compute_scalar_box([ 17, 19, 23 ],masses2_193,RedSet_4(15),ScalarBoxes(33))
  call compute_scalar_box([ 16, 17, 19 ],masses2_138,RedSet_4(17),ScalarBoxes(34))
  call compute_scalar_box([ 1, 3, 7 ],masses2_193,RedSet_4(18),ScalarBoxes(35))
  call compute_scalar_box([ 17, 19, 23 ],masses2_171,RedSet_4(15),ScalarBoxes(36))
  call compute_scalar_box([ 16, 17, 19 ],masses2_129,RedSet_4(17),ScalarBoxes(37))
  call compute_scalar_box([ 1, 3, 7 ],masses2_171,RedSet_4(18),ScalarBoxes(38))
  call compute_scalar_box([ 17, 19, 27 ],masses2_186,RedSet_4(19),ScalarBoxes(39))
  call compute_scalar_box([ 16, 17, 27 ],masses2_131,RedSet_4(20),ScalarBoxes(40))
  call compute_scalar_box([ 1, 3, 11 ],masses2_186,RedSet_4(21),ScalarBoxes(41))
  call compute_scalar_box([ 17, 19, 27 ],masses2_193,RedSet_4(19),ScalarBoxes(42))
  call compute_scalar_box([ 1, 3, 11 ],masses2_193,RedSet_4(21),ScalarBoxes(43))
  call compute_scalar_box([ 17, 19, 27 ],masses2_171,RedSet_4(19),ScalarBoxes(44))
  call compute_scalar_box([ 1, 3, 11 ],masses2_171,RedSet_4(21),ScalarBoxes(45))
  call compute_scalar_box([ 18, 22, 23 ],masses2_190,RedSet_4(22),ScalarBoxes(46))
  call compute_scalar_box([ 16, 18, 22 ],masses2_135,RedSet_4(23),ScalarBoxes(47))
  call compute_scalar_box([ 2, 6, 7 ],masses2_190,RedSet_4(24),ScalarBoxes(48))
  call compute_scalar_box([ 17, 25, 27 ],masses2_190,RedSet_4(25),ScalarBoxes(49))
  call compute_scalar_box([ 16, 25, 27 ],masses2_140,RedSet_4(26),ScalarBoxes(50))
  call compute_scalar_box([ 16, 17, 25 ],masses2_135,RedSet_4(27),ScalarBoxes(51))
  call compute_scalar_box([ 1, 9, 11 ],masses2_190,RedSet_4(28),ScalarBoxes(52))
  call compute_scalar_box([ 17, 25, 29 ],masses2_191,RedSet_4(29),ScalarBoxes(53))
  call compute_scalar_box([ 16, 25, 29 ],masses2_141,RedSet_4(30),ScalarBoxes(54))
  call compute_scalar_box([ 16, 17, 29 ],masses2_134,RedSet_4(31),ScalarBoxes(55))
  call compute_scalar_box([ 1, 9, 13 ],masses2_191,RedSet_4(32),ScalarBoxes(56))
  call compute_scalar_box([ 20, 21, 23 ],masses2_169,RedSet_4(33),ScalarBoxes(57))
  call compute_scalar_box([ 16, 21, 23 ],masses2_157,RedSet_4(34),ScalarBoxes(58))
  call compute_scalar_box([ 16, 20, 23 ],masses2_154,RedSet_4(8),ScalarBoxes(59))
  call compute_scalar_box([ 16, 20, 21 ],masses2_156,RedSet_4(35),ScalarBoxes(60))
  call compute_scalar_box([ 4, 5, 7 ],masses2_169,RedSet_4(36),ScalarBoxes(61))
  call compute_scalar_box([ 20, 21, 23 ],masses2_200,RedSet_4(33),ScalarBoxes(62))
  call compute_scalar_box([ 16, 20, 23 ],masses2_165,RedSet_4(8),ScalarBoxes(63))
  call compute_scalar_box([ 16, 20, 21 ],masses2_167,RedSet_4(35),ScalarBoxes(64))
  call compute_scalar_box([ 4, 5, 7 ],masses2_200,RedSet_4(36),ScalarBoxes(65))
  call compute_scalar_box([ 20, 21, 23 ],masses2_133,RedSet_4(33),ScalarBoxes(66))
  call compute_scalar_box([ 16, 21, 23 ],masses2_158,RedSet_4(34),ScalarBoxes(67))
  call compute_scalar_box([ 16, 20, 23 ],masses2_144,RedSet_4(8),ScalarBoxes(68))
  call compute_scalar_box([ 16, 20, 21 ],masses2_146,RedSet_4(35),ScalarBoxes(69))
  call compute_scalar_box([ 4, 5, 7 ],masses2_133,RedSet_4(36),ScalarBoxes(70))
  call compute_scalar_box([ 20, 21, 23 ],masses2_139,RedSet_4(33),ScalarBoxes(71))
  call compute_scalar_box([ 16, 21, 23 ],masses2_159,RedSet_4(34),ScalarBoxes(72))
  call compute_scalar_box([ 16, 20, 23 ],masses2_150,RedSet_4(8),ScalarBoxes(73))
  call compute_scalar_box([ 4, 5, 7 ],masses2_139,RedSet_4(36),ScalarBoxes(74))
  call compute_scalar_box([ 20, 21, 23 ],masses2_130,RedSet_4(33),ScalarBoxes(75))
  call compute_scalar_box([ 16, 20, 23 ],masses2_143,RedSet_4(8),ScalarBoxes(76))
  call compute_scalar_box([ 4, 5, 7 ],masses2_130,RedSet_4(36),ScalarBoxes(77))
  call compute_scalar_box([ 20, 22, 23 ],masses2_133,RedSet_4(6),ScalarBoxes(78))
  call compute_scalar_box([ 16, 22, 23 ],masses2_158,RedSet_4(7),ScalarBoxes(79))
  call compute_scalar_box([ 16, 20, 22 ],masses2_146,RedSet_4(9),ScalarBoxes(80))
  call compute_scalar_box([ 4, 6, 7 ],masses2_133,RedSet_4(10),ScalarBoxes(81))
  call compute_scalar_box([ 20, 22, 23 ],masses2_139,RedSet_4(6),ScalarBoxes(82))
  call compute_scalar_box([ 16, 22, 23 ],masses2_159,RedSet_4(7),ScalarBoxes(83))
  call compute_scalar_box([ 4, 6, 7 ],masses2_139,RedSet_4(10),ScalarBoxes(84))
  call compute_scalar_box([ 20, 22, 23 ],masses2_169,RedSet_4(6),ScalarBoxes(85))
  call compute_scalar_box([ 16, 22, 23 ],masses2_157,RedSet_4(7),ScalarBoxes(86))
  call compute_scalar_box([ 16, 20, 22 ],masses2_156,RedSet_4(9),ScalarBoxes(87))
  call compute_scalar_box([ 4, 6, 7 ],masses2_169,RedSet_4(10),ScalarBoxes(88))
  call compute_scalar_box([ 20, 22, 23 ],masses2_200,RedSet_4(6),ScalarBoxes(89))
  call compute_scalar_box([ 16, 20, 22 ],masses2_167,RedSet_4(9),ScalarBoxes(90))
  call compute_scalar_box([ 4, 6, 7 ],masses2_200,RedSet_4(10),ScalarBoxes(91))
  call compute_scalar_box([ 20, 22, 23 ],masses2_130,RedSet_4(6),ScalarBoxes(92))
  call compute_scalar_box([ 4, 6, 7 ],masses2_130,RedSet_4(10),ScalarBoxes(93))
  call compute_scalar_box([ 18, 19, 27 ],masses2_196,RedSet_4(11),ScalarBoxes(94))
  call compute_scalar_box([ 16, 19, 27 ],masses2_151,RedSet_4(12),ScalarBoxes(95))
  call compute_scalar_box([ 16, 18, 27 ],masses2_160,RedSet_4(13),ScalarBoxes(96))
  call compute_scalar_box([ 16, 18, 19 ],masses2_162,RedSet_4(4),ScalarBoxes(97))
  call compute_scalar_box([ 2, 3, 11 ],masses2_196,RedSet_4(14),ScalarBoxes(98))
  call compute_scalar_box([ 18, 19, 27 ],masses2_137,RedSet_4(11),ScalarBoxes(99))
  call compute_scalar_box([ 16, 19, 27 ],masses2_189,RedSet_4(12),ScalarBoxes(100))
  call compute_scalar_box([ 16, 18, 27 ],masses2_179,RedSet_4(13),ScalarBoxes(101))
  call compute_scalar_box([ 16, 18, 19 ],masses2_177,RedSet_4(4),ScalarBoxes(102))
  call compute_scalar_box([ 2, 3, 11 ],masses2_137,RedSet_4(14),ScalarBoxes(103))
  call compute_scalar_box([ 17, 19, 23 ],masses2_196,RedSet_4(15),ScalarBoxes(104))
  call compute_scalar_box([ 16, 19, 23 ],masses2_151,RedSet_4(2),ScalarBoxes(105))
  call compute_scalar_box([ 16, 17, 23 ],masses2_160,RedSet_4(16),ScalarBoxes(106))
  call compute_scalar_box([ 16, 17, 19 ],masses2_162,RedSet_4(17),ScalarBoxes(107))
  call compute_scalar_box([ 1, 3, 7 ],masses2_196,RedSet_4(18),ScalarBoxes(108))
  call compute_scalar_box([ 17, 19, 23 ],masses2_137,RedSet_4(15),ScalarBoxes(109))
  call compute_scalar_box([ 16, 19, 23 ],masses2_189,RedSet_4(2),ScalarBoxes(110))
  call compute_scalar_box([ 16, 17, 23 ],masses2_179,RedSet_4(16),ScalarBoxes(111))
  call compute_scalar_box([ 16, 17, 19 ],masses2_177,RedSet_4(17),ScalarBoxes(112))
  call compute_scalar_box([ 1, 3, 7 ],masses2_137,RedSet_4(18),ScalarBoxes(113))
  call compute_scalar_box([ 18, 26, 27 ],masses2_126,RedSet_4(37),ScalarBoxes(114))
  call compute_scalar_box([ 16, 26, 27 ],masses2_183,RedSet_4(38),ScalarBoxes(115))
  call compute_scalar_box([ 16, 18, 26 ],masses2_173,RedSet_4(39),ScalarBoxes(116))
  call compute_scalar_box([ 2, 10, 11 ],masses2_126,RedSet_4(40),ScalarBoxes(117))
  call compute_scalar_box([ 18, 26, 27 ],masses2_198,RedSet_4(37),ScalarBoxes(118))
  call compute_scalar_box([ 16, 26, 27 ],masses2_157,RedSet_4(38),ScalarBoxes(119))
  call compute_scalar_box([ 16, 18, 26 ],masses2_164,RedSet_4(39),ScalarBoxes(120))
  call compute_scalar_box([ 2, 10, 11 ],masses2_198,RedSet_4(40),ScalarBoxes(121))
  call compute_scalar_box([ 17, 21, 23 ],masses2_198,RedSet_4(41),ScalarBoxes(122))
  call compute_scalar_box([ 16, 17, 21 ],masses2_164,RedSet_4(42),ScalarBoxes(123))
  call compute_scalar_box([ 1, 5, 7 ],masses2_198,RedSet_4(43),ScalarBoxes(124))
  call compute_scalar_box([ 17, 21, 23 ],masses2_126,RedSet_4(41),ScalarBoxes(125))
  call compute_scalar_box([ 16, 21, 23 ],masses2_183,RedSet_4(34),ScalarBoxes(126))
  call compute_scalar_box([ 16, 17, 21 ],masses2_173,RedSet_4(42),ScalarBoxes(127))
  call compute_scalar_box([ 1, 5, 7 ],masses2_126,RedSet_4(43),ScalarBoxes(128))
  call compute_scalar_box([ 17, 21, 29 ],masses2_168,RedSet_4(44),ScalarBoxes(129))
  call compute_scalar_box([ 16, 21, 29 ],masses2_181,RedSet_4(45),ScalarBoxes(130))
  call compute_scalar_box([ 16, 17, 29 ],masses2_185,RedSet_4(31),ScalarBoxes(131))
  call compute_scalar_box([ 16, 17, 21 ],masses2_187,RedSet_4(42),ScalarBoxes(132))
  call compute_scalar_box([ 1, 5, 13 ],masses2_168,RedSet_4(46),ScalarBoxes(133))
  call compute_scalar_box([ 17, 21, 29 ],masses2_199,RedSet_4(44),ScalarBoxes(134))
  call compute_scalar_box([ 16, 17, 29 ],masses2_192,RedSet_4(31),ScalarBoxes(135))
  call compute_scalar_box([ 16, 17, 21 ],masses2_194,RedSet_4(42),ScalarBoxes(136))
  call compute_scalar_box([ 1, 5, 13 ],masses2_199,RedSet_4(46),ScalarBoxes(137))
  call compute_scalar_box([ 17, 21, 29 ],masses2_123,RedSet_4(44),ScalarBoxes(138))
  call compute_scalar_box([ 16, 21, 29 ],masses2_182,RedSet_4(45),ScalarBoxes(139))
  call compute_scalar_box([ 16, 17, 29 ],masses2_176,RedSet_4(31),ScalarBoxes(140))
  call compute_scalar_box([ 1, 5, 13 ],masses2_123,RedSet_4(46),ScalarBoxes(141))
  call compute_scalar_box([ 17, 21, 29 ],masses2_127,RedSet_4(44),ScalarBoxes(142))
  call compute_scalar_box([ 16, 21, 29 ],masses2_184,RedSet_4(45),ScalarBoxes(143))
  call compute_scalar_box([ 16, 17, 29 ],masses2_180,RedSet_4(31),ScalarBoxes(144))
  call compute_scalar_box([ 1, 5, 13 ],masses2_127,RedSet_4(46),ScalarBoxes(145))
  call compute_scalar_box([ 17, 21, 29 ],masses2_121,RedSet_4(44),ScalarBoxes(146))
  call compute_scalar_box([ 16, 17, 29 ],masses2_170,RedSet_4(31),ScalarBoxes(147))
  call compute_scalar_box([ 1, 5, 13 ],masses2_121,RedSet_4(46),ScalarBoxes(148))
  call compute_scalar_box([ 17, 25, 29 ],masses2_168,RedSet_4(29),ScalarBoxes(149))
  call compute_scalar_box([ 16, 25, 29 ],masses2_181,RedSet_4(30),ScalarBoxes(150))
  call compute_scalar_box([ 16, 17, 25 ],masses2_187,RedSet_4(27),ScalarBoxes(151))
  call compute_scalar_box([ 1, 9, 13 ],masses2_168,RedSet_4(32),ScalarBoxes(152))
  call compute_scalar_box([ 17, 25, 29 ],masses2_199,RedSet_4(29),ScalarBoxes(153))
  call compute_scalar_box([ 16, 17, 25 ],masses2_194,RedSet_4(27),ScalarBoxes(154))
  call compute_scalar_box([ 1, 9, 13 ],masses2_199,RedSet_4(32),ScalarBoxes(155))
  call compute_scalar_box([ 17, 25, 29 ],masses2_123,RedSet_4(29),ScalarBoxes(156))
  call compute_scalar_box([ 16, 25, 29 ],masses2_182,RedSet_4(30),ScalarBoxes(157))
  call compute_scalar_box([ 16, 17, 25 ],masses2_173,RedSet_4(27),ScalarBoxes(158))
  call compute_scalar_box([ 1, 9, 13 ],masses2_123,RedSet_4(32),ScalarBoxes(159))
  call compute_scalar_box([ 17, 25, 29 ],masses2_127,RedSet_4(29),ScalarBoxes(160))
  call compute_scalar_box([ 16, 25, 29 ],masses2_184,RedSet_4(30),ScalarBoxes(161))
  call compute_scalar_box([ 1, 9, 13 ],masses2_127,RedSet_4(32),ScalarBoxes(162))
  call compute_scalar_box([ 17, 25, 29 ],masses2_121,RedSet_4(29),ScalarBoxes(163))
  call compute_scalar_box([ 1, 9, 13 ],masses2_121,RedSet_4(32),ScalarBoxes(164))
! end of process


end subroutine vamp_1

end module ol_vamp_1_ppttj_ew_ttxbbxg_1_/**/REALKIND
