
module ol_vamp_1_ppttj_ew_ttxaag_2_/**/REALKIND
contains

! **********************************************************************
subroutine vamp_1(M)
! P(0:3,nlegs) = incoming external momenta
! Uses tree structures 'wf', factors 'c', and denominators 'den' from loop_ppttj_ew_ttxaag_2.
! Sets colour stripped amplitudes A from the module loop_amplitudes_ppttj_ew_ttxaag_2.
! **********************************************************************
  use KIND_TYPES, only: REALKIND, QREALKIND, intkind2
  use ol_parameters_decl_/**/DREALKIND, only: l_switch
  use ol_parameters_decl_/**/QREALKIND ! masses
  use ol_vert_interface_/**/REALKIND
  use ol_prop_interface_/**/REALKIND
  use ol_last_step_/**/REALKIND
  use ol_tables_storage_ppttj_ew_ttxaag_2_/**/DREALKIND
  use ol_tensor_sum_storage_ppttj_ew_ttxaag_2_/**/REALKIND
  use ol_loop_handling_/**/REALKIND
  use ofred_reduction_/**/REALKIND, only: Hotf_4pt_reduction, Hotf_4pt_reduction_last
  use ofred_reduction_/**/REALKIND, only: Hotf_5pt_reduction, Hotf_5pt_reduction_last
  use ol_loop_reduction_/**/REALKIND, only: TI_bubble_red, TI_triangle_red
use ol_loop_reduction_/**/REALKIND, only: compute_scalar_box

  use ol_loop_storage_ppttj_ew_ttxaag_2_/**/REALKIND
#ifndef PRECISION_dp
  use ol_loop_storage_ppttj_ew_ttxaag_2_/**/DREALKIND, only: &
    & p_switch, Hel, merge_step, merge_mism, merge_tables, merge_hels, ntryL, hel_states
#endif
  use hol_initialisation_/**/REALKIND, only: G0_hol_initialisation
  use ol_h_vert_interface_/**/REALKIND
  use ol_h_prop_interface_/**/REALKIND
  use ol_h_last_step_/**/REALKIND
  use ol_merging_/**/REALKIND, only: ol_merge, ol_merge_tensors, ol_merge_last

  implicit none

  type(Hpolcont) :: Gcoeff(hel_states)
  type(Hpolcont), intent(in) :: M(1,hel_states)


#ifndef PRECISION_dp
  if (ntryL==1 .OR. p_switch == 1) Gcoeff(:)%hf = Hel(1:hel_states)
#else
  if (ntryL==1 .OR. p_switch == 2) Gcoeff(:)%hf = Hel(1:hel_states)
#endif

  ! =============================================


! Dressing, otf merging and otf reduction calls to build loop structures

  Gcoeff(:)%j = (-(c(24)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1),h0tab(:,1),[16,4,1,2,8],[nMT,nMT,nMH,nMT,nMT],5,0)
  call Hloop_AV_Q(ntryL,G0H32(1),ex5(:),G0H16(1),m3h2x16(:,1),heltab2x32(:,:,1))
  call Hloop_A_Q(ntryL,G0H16(1),16,nMT,G1H16(1),n2h16(1))
  Gcoeff(:)%j = (c(24)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(2),h0tab(:,2),[16,4,1,2,8],[nMT,nMT,nMZ,nMT,nMT],5,0)
  call Hloop_AV_Q(ntryL,G0H32(1),ex5(:),G0H16(1),m3h2x16(:,2),heltab2x32(:,:,2))
  call Hloop_A_Q(ntryL,G0H16(1),16,nMT,G1H16(2),n2h16(2))
  Gcoeff(:)%j = (c(15)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(3),h0tab(:,3),[16,4,1,2,8],[nMB,nMB,nMW,nMB,nMB],5,0)
  call Hloop_AV_Q(ntryL,G0H32(1),ex5(:),G0H16(1),m3h2x16(:,3),heltab2x32(:,:,3))
  call Hloop_A_Q(ntryL,G0H16(1),16,nMB,G1H16(3),n2h16(3))
  Gcoeff(:)%j = (c(1)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(4),h0tab(:,4),[16,4,1,2,8],[nMT,nMT,0,nMT,nMT],5,0)
  call Hloop_AV_Q(ntryL,G0H32(1),ex5(:),G0H16(1),m3h2x16(:,4),heltab2x32(:,:,4))
  call Hloop_A_Q(ntryL,G0H16(1),16,nMT,G1H16(4),n2h16(4))
  Gcoeff(:)%j = (c(2)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(5),h0tab(:,5),[16,4,1,2,8],[nMT,nMT,nMZ,nMT,nMT],5,0)
  call Hloop_AV_Q(ntryL,G0H32(1),ex5(:),G0H16(1),m3h2x16(:,5),heltab2x32(:,:,5))
  call Hloop_A_Q(ntryL,G0H16(1),16,nMT,G1H16(5),n2h16(5))
  Gcoeff(:)%j = (c(6)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(6),h0tab(:,6),[16,4,1,2,8],[nMB,nMB,nMW,nMB,nMB],5,0)
  call Hloop_AV_Q(ntryL,G0H32(1),ex5(:),G0H16(1),m3h2x16(:,6),heltab2x32(:,:,6))
  call Hloop_A_Q(ntryL,G0H16(1),16,nMB,G1H16(6),n2h16(6))
  Gcoeff(:)%j = (-(c(24)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(7),h0tab(:,7),[16,2,1,4,8],[nMT,nMH,nMT,nMT,nMT],5,0)
  call Hloop_QV_A(ntryL,G0H32(1),ex5(:),G0H16(1),m3h2x16(:,7),heltab2x32(:,:,7))
  call Hloop_Q_A(ntryL,G0H16(1),16,nMT,G1H16(7),n2h16(7))
  Gcoeff(:)%j = (c(24)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(8),h0tab(:,8),[16,2,1,4,8],[nMT,nMZ,nMT,nMT,nMT],5,0)
  call Hloop_QV_A(ntryL,G0H32(1),ex5(:),G0H16(1),m3h2x16(:,8),heltab2x32(:,:,8))
  call Hloop_Q_A(ntryL,G0H16(1),16,nMT,G1H16(8),n2h16(8))
  Gcoeff(:)%j = (c(15)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(9),h0tab(:,9),[16,2,1,4,8],[nMB,nMW,nMB,nMB,nMB],5,0)
  call Hloop_QV_A(ntryL,G0H32(1),ex5(:),G0H16(1),m3h2x16(:,9),heltab2x32(:,:,9))
  call Hloop_Q_A(ntryL,G0H16(1),16,nMB,G1H16(9),n2h16(9))
  Gcoeff(:)%j = (c(1)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(10),h0tab(:,10),[16,2,1,4,8],[nMT,0,nMT,nMT,nMT],5,0)
  call Hloop_QV_A(ntryL,G0H32(1),ex5(:),G0H16(1),m3h2x16(:,10),heltab2x32(:,:,10))
  call Hloop_Q_A(ntryL,G0H16(1),16,nMT,G1H16(10),n2h16(10))
  Gcoeff(:)%j = (c(2)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(11),h0tab(:,11),[16,2,1,4,8],[nMT,nMZ,nMT,nMT,nMT],5,0)
  call Hloop_QV_A(ntryL,G0H32(1),ex5(:),G0H16(1),m3h2x16(:,11),heltab2x32(:,:,11))
  call Hloop_Q_A(ntryL,G0H16(1),16,nMT,G1H16(11),n2h16(11))
  Gcoeff(:)%j = (c(6)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(12),h0tab(:,12),[16,2,1,4,8],[nMB,nMW,nMB,nMB,nMB],5,0)
  call Hloop_QV_A(ntryL,G0H32(1),ex5(:),G0H16(1),m3h2x16(:,12),heltab2x32(:,:,12))
  call Hloop_Q_A(ntryL,G0H16(1),16,nMB,G1H16(12),n2h16(12))
  Gcoeff(:)%j = (-(c(24)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(13),h0tab(:,13),[16,4,2,1,8],[nMT,nMT,nMH,nMT,nMT],5,0)
  call Hloop_QV_A(ntryL,G0H32(1),ex5(:),G0H16(1),m3h2x16(:,13),heltab2x32(:,:,13))
  call Hloop_Q_A(ntryL,G0H16(1),16,nMT,G1H16(13),n2h16(13))
  Gcoeff(:)%j = (c(24)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(14),h0tab(:,14),[16,4,2,1,8],[nMT,nMT,nMZ,nMT,nMT],5,0)
  call Hloop_QV_A(ntryL,G0H32(1),ex5(:),G0H16(1),m3h2x16(:,14),heltab2x32(:,:,14))
  call Hloop_Q_A(ntryL,G0H16(1),16,nMT,G1H16(14),n2h16(14))
  Gcoeff(:)%j = (c(15)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(15),h0tab(:,15),[16,4,2,1,8],[nMB,nMB,nMW,nMB,nMB],5,0)
  call Hloop_QV_A(ntryL,G0H32(1),ex5(:),G0H16(1),m3h2x16(:,15),heltab2x32(:,:,15))
  call Hloop_Q_A(ntryL,G0H16(1),16,nMB,G1H16(15),n2h16(15))
  Gcoeff(:)%j = (c(1)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(16),h0tab(:,16),[16,4,2,1,8],[nMT,nMT,0,nMT,nMT],5,0)
  call Hloop_QV_A(ntryL,G0H32(1),ex5(:),G0H16(1),m3h2x16(:,16),heltab2x32(:,:,16))
  call Hloop_Q_A(ntryL,G0H16(1),16,nMT,G1H16(16),n2h16(16))
  Gcoeff(:)%j = (c(2)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(17),h0tab(:,17),[16,4,2,1,8],[nMT,nMT,nMZ,nMT,nMT],5,0)
  call Hloop_QV_A(ntryL,G0H32(1),ex5(:),G0H16(1),m3h2x16(:,17),heltab2x32(:,:,17))
  call Hloop_Q_A(ntryL,G0H16(1),16,nMT,G1H16(17),n2h16(17))
  Gcoeff(:)%j = (c(6)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(18),h0tab(:,18),[16,4,2,1,8],[nMB,nMB,nMW,nMB,nMB],5,0)
  call Hloop_QV_A(ntryL,G0H32(1),ex5(:),G0H16(1),m3h2x16(:,18),heltab2x32(:,:,18))
  call Hloop_Q_A(ntryL,G0H16(1),16,nMB,G1H16(18),n2h16(18))
  Gcoeff(:)%j = (-(c(24)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(19),h0tab(:,19),[16,2,1,8,4],[nMT,nMH,nMT,nMT,nMT],5,0)
  call Hloop_QV_A(ntryL,G0H32(1),ex5(:),G0H16(1),m3h2x16(:,19),heltab2x32(:,:,19))
  call Hloop_Q_A(ntryL,G0H16(1),16,nMT,G1H16(19),n2h16(19))
  Gcoeff(:)%j = (c(24)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(20),h0tab(:,20),[16,2,1,8,4],[nMT,nMZ,nMT,nMT,nMT],5,0)
  call Hloop_QV_A(ntryL,G0H32(1),ex5(:),G0H16(1),m3h2x16(:,20),heltab2x32(:,:,20))
  call Hloop_Q_A(ntryL,G0H16(1),16,nMT,G1H16(20),n2h16(20))
  Gcoeff(:)%j = (c(15)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(21),h0tab(:,21),[16,2,1,8,4],[nMB,nMW,nMB,nMB,nMB],5,0)
  call Hloop_QV_A(ntryL,G0H32(1),ex5(:),G0H16(1),m3h2x16(:,21),heltab2x32(:,:,21))
  call Hloop_Q_A(ntryL,G0H16(1),16,nMB,G1H16(21),n2h16(21))
  Gcoeff(:)%j = (c(1)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(22),h0tab(:,22),[16,2,1,8,4],[nMT,0,nMT,nMT,nMT],5,0)
  call Hloop_QV_A(ntryL,G0H32(1),ex5(:),G0H16(1),m3h2x16(:,22),heltab2x32(:,:,22))
  call Hloop_Q_A(ntryL,G0H16(1),16,nMT,G1H16(22),n2h16(22))
  Gcoeff(:)%j = (c(2)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(23),h0tab(:,23),[16,2,1,8,4],[nMT,nMZ,nMT,nMT,nMT],5,0)
  call Hloop_QV_A(ntryL,G0H32(1),ex5(:),G0H16(1),m3h2x16(:,23),heltab2x32(:,:,23))
  call Hloop_Q_A(ntryL,G0H16(1),16,nMT,G1H16(23),n2h16(23))
  Gcoeff(:)%j = (c(6)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(24),h0tab(:,24),[16,2,1,8,4],[nMB,nMW,nMB,nMB,nMB],5,0)
  call Hloop_QV_A(ntryL,G0H32(1),ex5(:),G0H16(1),m3h2x16(:,24),heltab2x32(:,:,24))
  call Hloop_Q_A(ntryL,G0H16(1),16,nMB,G1H16(24),n2h16(24))
  Gcoeff(:)%j = (-(c(24)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(25),h0tab(:,25),[16,1,2,4,8],[nMT,nMH,nMT,nMT,nMT],5,0)
  call Hloop_AV_Q(ntryL,G0H32(1),ex5(:),G0H16(1),m3h2x16(:,25),heltab2x32(:,:,25))
  call Hloop_A_Q(ntryL,G0H16(1),16,nMT,G1H16(25),n2h16(25))
  Gcoeff(:)%j = (c(24)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(26),h0tab(:,26),[16,1,2,4,8],[nMT,nMZ,nMT,nMT,nMT],5,0)
  call Hloop_AV_Q(ntryL,G0H32(1),ex5(:),G0H16(1),m3h2x16(:,26),heltab2x32(:,:,26))
  call Hloop_A_Q(ntryL,G0H16(1),16,nMT,G1H16(26),n2h16(26))
  Gcoeff(:)%j = (c(15)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(27),h0tab(:,27),[16,1,2,4,8],[nMB,nMW,nMB,nMB,nMB],5,0)
  call Hloop_AV_Q(ntryL,G0H32(1),ex5(:),G0H16(1),m3h2x16(:,27),heltab2x32(:,:,27))
  call Hloop_A_Q(ntryL,G0H16(1),16,nMB,G1H16(27),n2h16(27))
  Gcoeff(:)%j = (c(1)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(28),h0tab(:,28),[16,1,2,4,8],[nMT,0,nMT,nMT,nMT],5,0)
  call Hloop_AV_Q(ntryL,G0H32(1),ex5(:),G0H16(1),m3h2x16(:,28),heltab2x32(:,:,28))
  call Hloop_A_Q(ntryL,G0H16(1),16,nMT,G1H16(28),n2h16(28))
  Gcoeff(:)%j = (c(2)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(29),h0tab(:,29),[16,1,2,4,8],[nMT,nMZ,nMT,nMT,nMT],5,0)
  call Hloop_AV_Q(ntryL,G0H32(1),ex5(:),G0H16(1),m3h2x16(:,29),heltab2x32(:,:,29))
  call Hloop_A_Q(ntryL,G0H16(1),16,nMT,G1H16(29),n2h16(29))
  Gcoeff(:)%j = (c(6)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(30),h0tab(:,30),[16,1,2,4,8],[nMB,nMW,nMB,nMB,nMB],5,0)
  call Hloop_AV_Q(ntryL,G0H32(1),ex5(:),G0H16(1),m3h2x16(:,30),heltab2x32(:,:,30))
  call Hloop_A_Q(ntryL,G0H16(1),16,nMB,G1H16(30),n2h16(30))
  Gcoeff(:)%j = (-(c(24)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(31),h0tab(:,31),[16,1,2,8,4],[nMT,nMH,nMT,nMT,nMT],5,0)
  call Hloop_AV_Q(ntryL,G0H32(1),ex5(:),G0H16(1),m3h2x16(:,31),heltab2x32(:,:,31))
  call Hloop_A_Q(ntryL,G0H16(1),16,nMT,G1H16(31),n2h16(31))
  Gcoeff(:)%j = (c(24)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(32),h0tab(:,32),[16,1,2,8,4],[nMT,nMZ,nMT,nMT,nMT],5,0)
  call Hloop_AV_Q(ntryL,G0H32(1),ex5(:),G0H16(1),m3h2x16(:,32),heltab2x32(:,:,32))
  call Hloop_A_Q(ntryL,G0H16(1),16,nMT,G1H16(32),n2h16(32))
  Gcoeff(:)%j = (c(15)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(33),h0tab(:,33),[16,1,2,8,4],[nMB,nMW,nMB,nMB,nMB],5,0)
  call Hloop_AV_Q(ntryL,G0H32(1),ex5(:),G0H16(1),m3h2x16(:,33),heltab2x32(:,:,33))
  call Hloop_A_Q(ntryL,G0H16(1),16,nMB,G1H16(33),n2h16(33))
  Gcoeff(:)%j = (c(1)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(34),h0tab(:,34),[16,1,2,8,4],[nMT,0,nMT,nMT,nMT],5,0)
  call Hloop_AV_Q(ntryL,G0H32(1),ex5(:),G0H16(1),m3h2x16(:,34),heltab2x32(:,:,34))
  call Hloop_A_Q(ntryL,G0H16(1),16,nMT,G1H16(34),n2h16(34))
  Gcoeff(:)%j = (c(2)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(35),h0tab(:,35),[16,1,2,8,4],[nMT,nMZ,nMT,nMT,nMT],5,0)
  call Hloop_AV_Q(ntryL,G0H32(1),ex5(:),G0H16(1),m3h2x16(:,35),heltab2x32(:,:,35))
  call Hloop_A_Q(ntryL,G0H16(1),16,nMT,G1H16(35),n2h16(35))
  Gcoeff(:)%j = (c(6)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(36),h0tab(:,36),[16,1,2,8,4],[nMB,nMW,nMB,nMB,nMB],5,0)
  call Hloop_AV_Q(ntryL,G0H32(1),ex5(:),G0H16(1),m3h2x16(:,36),heltab2x32(:,:,36))
  call Hloop_A_Q(ntryL,G0H16(1),16,nMB,G1H16(36),n2h16(36))
  Gcoeff(:)%j = (-(c(17)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(37),h0tab(:,37),[16,2,4,1,8],[nMB,nMW,nMW,nMB,nMB],5,0)
  call Hloop_QV_A(ntryL,G0H32(1),ex5(:),G0H16(1),m3h2x16(:,37),heltab2x32(:,:,37))
  call Hloop_Q_A(ntryL,G0H16(1),16,nMB,G1H16(37),n2h16(37))
  Gcoeff(:)%j = (c(8)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(38),h0tab(:,38),[16,2,4,1,8],[nMB,nMW,nMW,nMB,nMB],5,0)
  call Hloop_QV_A(ntryL,G0H32(1),ex5(:),G0H16(1),m3h2x16(:,38),heltab2x32(:,:,38))
  call Hloop_Q_A(ntryL,G0H16(1),16,nMB,G1H16(38),n2h16(38))
  Gcoeff(:)%j = (-(c(8)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(39),h0tab(:,39),[16,2,4,1,8],[nMB,nMW,nMW,nMB,nMB],5,0)
  call Hloop_QV_A(ntryL,G0H32(1),ex5(:),G0H16(1),m3h2x16(:,39),heltab2x32(:,:,39))
  call Hloop_Q_A(ntryL,G0H16(1),16,nMB,G1H16(39),n2h16(39))
  Gcoeff(:)%j = (-(c(8)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(40),h0tab(:,40),[16,2,4,1,8],[nMB,nMW,nMW,nMB,nMB],5,0)
  call Hloop_QV_A(ntryL,G0H32(1),ex5(:),G0H16(1),m3h2x16(:,40),heltab2x32(:,:,40))
  call Hloop_Q_A(ntryL,G0H16(1),16,nMB,G1H16(40),n2h16(40))
  Gcoeff(:)%j = (-(c(17)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(41),h0tab(:,41),[16,2,8,1,4],[nMB,nMW,nMW,nMB,nMB],5,0)
  call Hloop_QV_A(ntryL,G0H32(1),ex5(:),G0H16(1),m3h2x16(:,41),heltab2x32(:,:,41))
  call Hloop_Q_A(ntryL,G0H16(1),16,nMB,G1H16(41),n2h16(41))
  Gcoeff(:)%j = (c(8)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(42),h0tab(:,42),[16,2,8,1,4],[nMB,nMW,nMW,nMB,nMB],5,0)
  call Hloop_QV_A(ntryL,G0H32(1),ex5(:),G0H16(1),m3h2x16(:,42),heltab2x32(:,:,42))
  call Hloop_Q_A(ntryL,G0H16(1),16,nMB,G1H16(42),n2h16(42))
  Gcoeff(:)%j = (-(c(8)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(43),h0tab(:,43),[16,2,8,1,4],[nMB,nMW,nMW,nMB,nMB],5,0)
  call Hloop_QV_A(ntryL,G0H32(1),ex5(:),G0H16(1),m3h2x16(:,43),heltab2x32(:,:,43))
  call Hloop_Q_A(ntryL,G0H16(1),16,nMB,G1H16(43),n2h16(43))
  Gcoeff(:)%j = (-(c(8)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(44),h0tab(:,44),[16,2,8,1,4],[nMB,nMW,nMW,nMB,nMB],5,0)
  call Hloop_QV_A(ntryL,G0H32(1),ex5(:),G0H16(1),m3h2x16(:,44),heltab2x32(:,:,44))
  call Hloop_Q_A(ntryL,G0H16(1),16,nMB,G1H16(44),n2h16(44))
  Gcoeff(:)%j = (-(c(17)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(45),h0tab(:,45),[16,1,4,2,8],[nMB,nMW,nMW,nMB,nMB],5,0)
  call Hloop_AV_Q(ntryL,G0H32(1),ex5(:),G0H16(1),m3h2x16(:,45),heltab2x32(:,:,45))
  call Hloop_A_Q(ntryL,G0H16(1),16,nMB,G1H16(45),n2h16(45))
  Gcoeff(:)%j = (c(8)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(46),h0tab(:,46),[16,1,4,2,8],[nMB,nMW,nMW,nMB,nMB],5,0)
  call Hloop_AV_Q(ntryL,G0H32(1),ex5(:),G0H16(1),m3h2x16(:,46),heltab2x32(:,:,46))
  call Hloop_A_Q(ntryL,G0H16(1),16,nMB,G1H16(46),n2h16(46))
  Gcoeff(:)%j = (-(c(8)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(47),h0tab(:,47),[16,1,4,2,8],[nMB,nMW,nMW,nMB,nMB],5,0)
  call Hloop_AV_Q(ntryL,G0H32(1),ex5(:),G0H16(1),m3h2x16(:,47),heltab2x32(:,:,47))
  call Hloop_A_Q(ntryL,G0H16(1),16,nMB,G1H16(47),n2h16(47))
  Gcoeff(:)%j = (-(c(8)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(48),h0tab(:,48),[16,1,4,2,8],[nMB,nMW,nMW,nMB,nMB],5,0)
  call Hloop_AV_Q(ntryL,G0H32(1),ex5(:),G0H16(1),m3h2x16(:,48),heltab2x32(:,:,48))
  call Hloop_A_Q(ntryL,G0H16(1),16,nMB,G1H16(48),n2h16(48))
  Gcoeff(:)%j = (c(20)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(49),h0tab(:,49),[16,1,4,8,2],[nMB,nMW,nMW,nMW,nMB],5,0)
  call Hloop_AV_Q(ntryL,G0H32(1),ex5(:),G0H16(1),m3h2x16(:,49),heltab2x32(:,:,49))
  call Hloop_A_Q(ntryL,G0H16(1),16,nMB,G1H16(49),n2h16(49))
  Gcoeff(:)%j = (-(c(11)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(50),h0tab(:,50),[16,1,4,8,2],[nMB,nMW,nMW,nMW,nMB],5,0)
  call Hloop_AV_Q(ntryL,G0H32(1),ex5(:),G0H16(1),m3h2x16(:,50),heltab2x32(:,:,50))
  call Hloop_A_Q(ntryL,G0H16(1),16,nMB,G1H16(50),n2h16(50))
  Gcoeff(:)%j = (-(c(11)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(51),h0tab(:,51),[16,1,4,8,2],[nMB,nMW,nMW,nMW,nMB],5,0)
  call Hloop_AV_Q(ntryL,G0H32(1),ex5(:),G0H16(1),m3h2x16(:,51),heltab2x32(:,:,51))
  call Hloop_A_Q(ntryL,G0H16(1),16,nMB,G1H16(51),n2h16(51))
  Gcoeff(:)%j = (c(11)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(52),h0tab(:,52),[16,1,4,8,2],[nMB,nMW,nMW,nMW,nMB],5,0)
  call Hloop_AV_Q(ntryL,G0H32(1),ex5(:),G0H16(1),m3h2x16(:,52),heltab2x32(:,:,52))
  call Hloop_A_Q(ntryL,G0H16(1),16,nMB,G1H16(52),n2h16(52))
  Gcoeff(:)%j = (-(c(11)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(53),h0tab(:,53),[16,1,4,8,2],[nMB,nMW,nMW,nMW,nMB],5,0)
  call Hloop_AV_Q(ntryL,G0H32(1),ex5(:),G0H16(1),m3h2x16(:,53),heltab2x32(:,:,53))
  call Hloop_A_Q(ntryL,G0H16(1),16,nMB,G1H16(53),n2h16(53))
  Gcoeff(:)%j = (c(11)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(54),h0tab(:,54),[16,1,4,8,2],[nMB,nMW,nMW,nMW,nMB],5,0)
  call Hloop_AV_Q(ntryL,G0H32(1),ex5(:),G0H16(1),m3h2x16(:,54),heltab2x32(:,:,54))
  call Hloop_A_Q(ntryL,G0H16(1),16,nMB,G1H16(54),n2h16(54))
  Gcoeff(:)%j = (-(c(25)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(55),h0tab(:,55),[16,1,4,8,2],[nMB,nMW,nMW,nMW,nMB],5,0)
  call Hloop_AV_Q(ntryL,G0H32(1),ex5(:),G0H16(1),m3h2x16(:,55),heltab2x32(:,:,55))
  call Hloop_A_Q(ntryL,G0H16(1),16,nMB,G1H16(55),n2h16(55))
  Gcoeff(:)%j = (c(11)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(56),h0tab(:,56),[16,1,4,8,2],[nMB,nMW,nMW,nMW,nMB],5,0)
  call Hloop_AV_Q(ntryL,G0H32(1),ex5(:),G0H16(1),m3h2x16(:,56),heltab2x32(:,:,56))
  call Hloop_A_Q(ntryL,G0H16(1),16,nMB,G1H16(56),n2h16(56))
  Gcoeff(:)%j = (-(c(17)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(57),h0tab(:,57),[16,1,8,2,4],[nMB,nMW,nMW,nMB,nMB],5,0)
  call Hloop_AV_Q(ntryL,G0H32(1),ex5(:),G0H16(1),m3h2x16(:,57),heltab2x32(:,:,57))
  call Hloop_A_Q(ntryL,G0H16(1),16,nMB,G1H16(57),n2h16(57))
  Gcoeff(:)%j = (c(8)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(58),h0tab(:,58),[16,1,8,2,4],[nMB,nMW,nMW,nMB,nMB],5,0)
  call Hloop_AV_Q(ntryL,G0H32(1),ex5(:),G0H16(1),m3h2x16(:,58),heltab2x32(:,:,58))
  call Hloop_A_Q(ntryL,G0H16(1),16,nMB,G1H16(58),n2h16(58))
  Gcoeff(:)%j = (-(c(8)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(59),h0tab(:,59),[16,1,8,2,4],[nMB,nMW,nMW,nMB,nMB],5,0)
  call Hloop_AV_Q(ntryL,G0H32(1),ex5(:),G0H16(1),m3h2x16(:,59),heltab2x32(:,:,59))
  call Hloop_A_Q(ntryL,G0H16(1),16,nMB,G1H16(59),n2h16(59))
  Gcoeff(:)%j = (-(c(8)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(60),h0tab(:,60),[16,1,8,2,4],[nMB,nMW,nMW,nMB,nMB],5,0)
  call Hloop_AV_Q(ntryL,G0H32(1),ex5(:),G0H16(1),m3h2x16(:,60),heltab2x32(:,:,60))
  call Hloop_A_Q(ntryL,G0H16(1),16,nMB,G1H16(60),n2h16(60))
  Gcoeff(:)%j = (c(20)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(61),h0tab(:,61),[16,1,8,4,2],[nMB,nMW,nMW,nMW,nMB],5,0)
  call Hloop_AV_Q(ntryL,G0H32(1),ex5(:),G0H16(1),m3h2x16(:,61),heltab2x32(:,:,61))
  call Hloop_A_Q(ntryL,G0H16(1),16,nMB,G1H16(61),n2h16(61))
  Gcoeff(:)%j = (-(c(11)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(62),h0tab(:,62),[16,1,8,4,2],[nMB,nMW,nMW,nMW,nMB],5,0)
  call Hloop_AV_Q(ntryL,G0H32(1),ex5(:),G0H16(1),m3h2x16(:,62),heltab2x32(:,:,62))
  call Hloop_A_Q(ntryL,G0H16(1),16,nMB,G1H16(62),n2h16(62))
  Gcoeff(:)%j = (-(c(11)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(63),h0tab(:,63),[16,1,8,4,2],[nMB,nMW,nMW,nMW,nMB],5,0)
  call Hloop_AV_Q(ntryL,G0H32(1),ex5(:),G0H16(1),m3h2x16(:,63),heltab2x32(:,:,63))
  call Hloop_A_Q(ntryL,G0H16(1),16,nMB,G1H16(63),n2h16(63))
  Gcoeff(:)%j = (c(11)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(64),h0tab(:,64),[16,1,8,4,2],[nMB,nMW,nMW,nMW,nMB],5,0)
  call Hloop_AV_Q(ntryL,G0H32(1),ex5(:),G0H16(1),m3h2x16(:,64),heltab2x32(:,:,64))
  call Hloop_A_Q(ntryL,G0H16(1),16,nMB,G1H16(64),n2h16(64))
  Gcoeff(:)%j = (-(c(11)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(65),h0tab(:,65),[16,1,8,4,2],[nMB,nMW,nMW,nMW,nMB],5,0)
  call Hloop_AV_Q(ntryL,G0H32(1),ex5(:),G0H16(1),m3h2x16(:,65),heltab2x32(:,:,65))
  call Hloop_A_Q(ntryL,G0H16(1),16,nMB,G1H16(65),n2h16(65))
  Gcoeff(:)%j = (c(11)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(66),h0tab(:,66),[16,1,8,4,2],[nMB,nMW,nMW,nMW,nMB],5,0)
  call Hloop_AV_Q(ntryL,G0H32(1),ex5(:),G0H16(1),m3h2x16(:,66),heltab2x32(:,:,66))
  call Hloop_A_Q(ntryL,G0H16(1),16,nMB,G1H16(66),n2h16(66))
  Gcoeff(:)%j = (-(c(25)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(67),h0tab(:,67),[16,1,8,4,2],[nMB,nMW,nMW,nMW,nMB],5,0)
  call Hloop_AV_Q(ntryL,G0H32(1),ex5(:),G0H16(1),m3h2x16(:,67),heltab2x32(:,:,67))
  call Hloop_A_Q(ntryL,G0H16(1),16,nMB,G1H16(67),n2h16(67))
  Gcoeff(:)%j = (c(11)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(68),h0tab(:,68),[16,1,8,4,2],[nMB,nMW,nMW,nMW,nMB],5,0)
  call Hloop_AV_Q(ntryL,G0H32(1),ex5(:),G0H16(1),m3h2x16(:,68),heltab2x32(:,:,68))
  call Hloop_A_Q(ntryL,G0H16(1),16,nMB,G1H16(68),n2h16(68))
  call Hloop_AV_Q(ntryL,G1H16(1),ex3(:),G1H8(1),m3h2x8(:,1),heltab2x16(:,:,1))
  call Hloop_A_Q(ntryL,G1H8(1),20,nMT,G2H8(1),n2h8(1))
  call Hloop_AV_Q(ntryL,G1H16(2),ex3(:),G1H8(1),m3h2x8(:,2),heltab2x16(:,:,2))
  call Hloop_A_Q(ntryL,G1H8(1),20,nMT,G2H8(2),n2h8(2))
  call Hloop_AV_Q(ntryL,G1H16(3),ex3(:),G1H8(1),m3h2x8(:,3),heltab2x16(:,:,3))
  call Hloop_A_Q(ntryL,G1H8(1),20,nMB,G2H8(3),n2h8(3))
  call Hloop_AV_Q(ntryL,G1H16(4),ex3(:),G1H8(1),m3h2x8(:,4),heltab2x16(:,:,4))
  call Hloop_A_Q(ntryL,G1H8(1),20,nMT,G2H8(4),n2h8(4))
  call Hloop_AV_Q(ntryL,G1H16(5),ex3(:),G1H8(1),m3h2x8(:,5),heltab2x16(:,:,5))
  call Hloop_A_Q(ntryL,G1H8(1),20,nMT,G2H8(5),n2h8(5))
  call Hloop_AV_Q(ntryL,G1H16(6),ex3(:),G1H8(1),m3h2x8(:,6),heltab2x16(:,:,6))
  call Hloop_A_Q(ntryL,G1H8(1),20,nMB,G2H8(6),n2h8(6))
  call Hloop_QA_S(ntryL,G1H16(7),ex2(:),G1H8(1),ngH,m3h2x8(:,7),heltab2x16(:,:,7))
  call Hloop_QA_S(ntryL,G1H16(8),ex2(:),G1H8(2),ngX,m3h2x8(:,8),heltab2x16(:,:,8))
  call Hloop_QA_S(ntryL,G1H16(9),ex2(:),G1H8(3),ngPtb,m3h2x8(:,9),heltab2x16(:,:,9))
  call Hloop_QA_V(ntryL,G1H16(10),ex2(:),G1H8(4),m3h2x8(:,10),heltab2x16(:,:,10))
  call Hloop_QA_Z(ntryL,G1H16(11),ex2(:),G1H8(5),ngZu,m3h2x8(:,11),heltab2x16(:,:,11))
  call Hloop_QA_W(ntryL,G1H16(12),ex2(:),G1H8(6),m3h2x8(:,12),heltab2x16(:,:,12))
  call Hloop_QV_A(ntryL,G1H16(13),ex3(:),G1H8(7),m3h2x8(:,13),heltab2x16(:,:,13))
  call Hloop_Q_A(ntryL,G1H8(7),20,nMT,G2H8(7),n2h8(7))
  call Hloop_QV_A(ntryL,G1H16(14),ex3(:),G1H8(7),m3h2x8(:,14),heltab2x16(:,:,14))
  call Hloop_Q_A(ntryL,G1H8(7),20,nMT,G2H8(8),n2h8(8))
  call Hloop_QV_A(ntryL,G1H16(15),ex3(:),G1H8(7),m3h2x8(:,15),heltab2x16(:,:,15))
  call Hloop_Q_A(ntryL,G1H8(7),20,nMB,G2H8(9),n2h8(9))
  call Hloop_QV_A(ntryL,G1H16(16),ex3(:),G1H8(7),m3h2x8(:,16),heltab2x16(:,:,16))
  call Hloop_Q_A(ntryL,G1H8(7),20,nMT,G2H8(10),n2h8(10))
  call Hloop_QV_A(ntryL,G1H16(17),ex3(:),G1H8(7),m3h2x8(:,17),heltab2x16(:,:,17))
  call Hloop_Q_A(ntryL,G1H8(7),20,nMT,G2H8(11),n2h8(11))
  call Hloop_QV_A(ntryL,G1H16(18),ex3(:),G1H8(7),m3h2x8(:,18),heltab2x16(:,:,18))
  call Hloop_Q_A(ntryL,G1H8(7),20,nMB,G2H8(12),n2h8(12))
  call Hloop_QA_S(ntryL,G1H16(19),ex2(:),G1H8(7),ngH,m3h2x8(:,19),heltab2x16(:,:,19))
  call Hloop_QA_S(ntryL,G1H16(20),ex2(:),G1H8(8),ngX,m3h2x8(:,20),heltab2x16(:,:,20))
  call Hloop_QA_S(ntryL,G1H16(21),ex2(:),G1H8(9),ngPtb,m3h2x8(:,21),heltab2x16(:,:,21))
  call Hloop_QA_V(ntryL,G1H16(22),ex2(:),G1H8(10),m3h2x8(:,22),heltab2x16(:,:,22))
  call Hloop_QA_Z(ntryL,G1H16(23),ex2(:),G1H8(11),ngZu,m3h2x8(:,23),heltab2x16(:,:,23))
  call Hloop_QA_W(ntryL,G1H16(24),ex2(:),G1H8(12),m3h2x8(:,24),heltab2x16(:,:,24))
  call Hloop_AQ_S(ntryL,G1H16(25),ex1(:),G1H8(13),ngH,m3h2x8(:,25),heltab2x16(:,:,25))
  call Hloop_AQ_S(ntryL,G1H16(26),ex1(:),G1H8(14),ngX,m3h2x8(:,26),heltab2x16(:,:,26))
  call Hloop_AQ_S(ntryL,G1H16(27),ex1(:),G1H8(15),ngPbt,m3h2x8(:,27),heltab2x16(:,:,27))
  call Hloop_AQ_V(ntryL,G1H16(28),ex1(:),G1H8(16),m3h2x8(:,28),heltab2x16(:,:,28))
  call Hloop_AQ_Z(ntryL,G1H16(29),ex1(:),G1H8(17),ngZu,m3h2x8(:,29),heltab2x16(:,:,29))
  call Hloop_AQ_W(ntryL,G1H16(30),ex1(:),G1H8(18),m3h2x8(:,30),heltab2x16(:,:,30))
  call Hloop_AQ_S(ntryL,G1H16(31),ex1(:),G1H8(19),ngH,m3h2x8(:,31),heltab2x16(:,:,31))
  call Hloop_AQ_S(ntryL,G1H16(32),ex1(:),G1H8(20),ngX,m3h2x8(:,32),heltab2x16(:,:,32))
  call Hloop_AQ_S(ntryL,G1H16(33),ex1(:),G1H8(21),ngPbt,m3h2x8(:,33),heltab2x16(:,:,33))
  call Hloop_AQ_V(ntryL,G1H16(34),ex1(:),G1H8(22),m3h2x8(:,34),heltab2x16(:,:,34))
  call Hloop_AQ_Z(ntryL,G1H16(35),ex1(:),G1H8(23),ngZu,m3h2x8(:,35),heltab2x16(:,:,35))
  call Hloop_AQ_W(ntryL,G1H16(36),ex1(:),G1H8(24),m3h2x8(:,36),heltab2x16(:,:,36))
  call Hloop_QA_S(ntryL,G1H16(37),ex2(:),G1H8(25),ngPtb,m3h2x8(:,37),heltab2x16(:,:,37))
  call Hloop_QA_W(ntryL,G1H16(38),ex2(:),G1H8(26),m3h2x8(:,38),heltab2x16(:,:,38))
  call Hloop_QA_S(ntryL,G1H16(39),ex2(:),G1H8(27),ngPtb,m3h2x8(:,39),heltab2x16(:,:,39))
  call Hloop_QA_W(ntryL,G1H16(40),ex2(:),G1H8(28),m3h2x8(:,40),heltab2x16(:,:,40))
  call Hloop_QA_S(ntryL,G1H16(41),ex2(:),G1H8(29),ngPtb,m3h2x8(:,41),heltab2x16(:,:,41))
  call Hloop_QA_W(ntryL,G1H16(42),ex2(:),G1H8(30),m3h2x8(:,42),heltab2x16(:,:,42))
  call Hloop_QA_S(ntryL,G1H16(43),ex2(:),G1H8(31),ngPtb,m3h2x8(:,43),heltab2x16(:,:,43))
  call Hloop_QA_W(ntryL,G1H16(44),ex2(:),G1H8(32),m3h2x8(:,44),heltab2x16(:,:,44))
  call Hloop_AQ_S(ntryL,G1H16(45),ex1(:),G1H8(33),ngPbt,m3h2x8(:,45),heltab2x16(:,:,45))
  call Hloop_AQ_S(ntryL,G1H16(46),ex1(:),G1H8(34),ngPbt,m3h2x8(:,46),heltab2x16(:,:,46))
  call Hloop_AQ_W(ntryL,G1H16(47),ex1(:),G1H8(35),m3h2x8(:,47),heltab2x16(:,:,47))
  call Hloop_AQ_W(ntryL,G1H16(48),ex1(:),G1H8(36),m3h2x8(:,48),heltab2x16(:,:,48))
  call Hloop_AQ_S(ntryL,G1H16(49),ex1(:),G1H8(37),ngPbt,m3h2x8(:,49),heltab2x16(:,:,49))
  call Hloop_AQ_S(ntryL,G1H16(50),ex1(:),G1H8(38),ngPbt,m3h2x8(:,50),heltab2x16(:,:,50))
  call Hloop_AQ_S(ntryL,G1H16(51),ex1(:),G1H8(39),ngPbt,m3h2x8(:,51),heltab2x16(:,:,51))
  call Hloop_AQ_W(ntryL,G1H16(52),ex1(:),G1H8(40),m3h2x8(:,52),heltab2x16(:,:,52))
  call Hloop_AQ_S(ntryL,G1H16(53),ex1(:),G1H8(41),ngPbt,m3h2x8(:,53),heltab2x16(:,:,53))
  call Hloop_AQ_W(ntryL,G1H16(54),ex1(:),G1H8(42),m3h2x8(:,54),heltab2x16(:,:,54))
  call Hloop_AQ_W(ntryL,G1H16(55),ex1(:),G1H8(43),m3h2x8(:,55),heltab2x16(:,:,55))
  call Hloop_AQ_W(ntryL,G1H16(56),ex1(:),G1H8(44),m3h2x8(:,56),heltab2x16(:,:,56))
  call Hloop_AQ_S(ntryL,G1H16(57),ex1(:),G1H8(45),ngPbt,m3h2x8(:,57),heltab2x16(:,:,57))
  call Hloop_AQ_S(ntryL,G1H16(58),ex1(:),G1H8(46),ngPbt,m3h2x8(:,58),heltab2x16(:,:,58))
  call Hloop_AQ_W(ntryL,G1H16(59),ex1(:),G1H8(47),m3h2x8(:,59),heltab2x16(:,:,59))
  call Hloop_AQ_W(ntryL,G1H16(60),ex1(:),G1H8(48),m3h2x8(:,60),heltab2x16(:,:,60))
  call Hloop_AQ_S(ntryL,G1H16(61),ex1(:),G1H8(49),ngPbt,m3h2x8(:,61),heltab2x16(:,:,61))
  call Hloop_AQ_S(ntryL,G1H16(62),ex1(:),G1H8(50),ngPbt,m3h2x8(:,62),heltab2x16(:,:,62))
  call Hloop_AQ_S(ntryL,G1H16(63),ex1(:),G1H8(51),ngPbt,m3h2x8(:,63),heltab2x16(:,:,63))
  call Hloop_AQ_W(ntryL,G1H16(64),ex1(:),G1H8(52),m3h2x8(:,64),heltab2x16(:,:,64))
  call Hloop_AQ_S(ntryL,G1H16(65),ex1(:),G1H8(53),ngPbt,m3h2x8(:,65),heltab2x16(:,:,65))
  call Hloop_AQ_W(ntryL,G1H16(66),ex1(:),G1H8(54),m3h2x8(:,66),heltab2x16(:,:,66))
  call Hloop_AQ_W(ntryL,G1H16(67),ex1(:),G1H8(55),m3h2x8(:,67),heltab2x16(:,:,67))
  call Hloop_AQ_W(ntryL,G1H16(68),ex1(:),G1H8(56),m3h2x8(:,68),heltab2x16(:,:,68))
  call Hloop_AQ_S(ntryL,G2H8(1),ex1(:),G2H4(1),ngH,m3h2x4(:,1),heltab2x8(:,:,1))
  call Hloop_AQ_S(ntryL,G2H8(2),ex1(:),G2H4(2),ngX,m3h2x4(:,2),heltab2x8(:,:,2))
  call Hloop_AQ_S(ntryL,G2H8(3),ex1(:),G2H4(3),ngPbt,m3h2x4(:,3),heltab2x8(:,:,3))
  call Hloop_AQ_V(ntryL,G2H8(4),ex1(:),G2H4(4),m3h2x4(:,4),heltab2x8(:,:,4))
  call Hloop_AQ_Z(ntryL,G2H8(5),ex1(:),G2H4(5),ngZu,m3h2x4(:,5),heltab2x8(:,:,5))
  call Hloop_AQ_W(ntryL,G2H8(6),ex1(:),G2H4(6),m3h2x4(:,6),heltab2x8(:,:,6))
  call Hloop_SQ_A(ntryL,G1H8(1),ex1(:),G1H4(1),ngH,m3h2x4(:,7),heltab2x8(:,:,7))
  call Hloop_Q_A(ntryL,G1H4(1),19,nMT,G2H4(7),n2h4(1))
  call Hloop_SQ_A(ntryL,G1H8(2),ex1(:),G1H4(1),ngX,m3h2x4(:,8),heltab2x8(:,:,8))
  call Hloop_Q_A(ntryL,G1H4(1),19,nMT,G2H4(8),n2h4(2))
  call Hloop_SQ_A(ntryL,G1H8(3),ex1(:),G1H4(1),ngPbt,m3h2x4(:,9),heltab2x8(:,:,9))
  call Hloop_Q_A(ntryL,G1H4(1),19,nMB,G2H4(9),n2h4(3))
  call Hloop_VQ_A(ntryL,G1H8(4),ex1(:),G1H4(1),m3h2x4(:,10),heltab2x8(:,:,10))
  call Hloop_Q_A(ntryL,G1H4(1),19,nMT,G2H4(10),n2h4(4))
  call Hloop_ZQ_A(ntryL,G1H8(5),ex1(:),G1H4(1),ngZu,m3h2x4(:,11),heltab2x8(:,:,11))
  call Hloop_Q_A(ntryL,G1H4(1),19,nMT,G2H4(11),n2h4(5))
  call Hloop_WQ_A(ntryL,G1H8(6),ex1(:),G1H4(1),m3h2x4(:,12),heltab2x8(:,:,12))
  call Hloop_Q_A(ntryL,G1H4(1),19,nMB,G2H4(12),n2h4(6))
  call Hloop_QA_S(ntryL,G2H8(7),ex2(:),G2H4(13),ngH,m3h2x4(:,13),heltab2x8(:,:,13))
  call Hloop_QA_S(ntryL,G2H8(8),ex2(:),G2H4(14),ngX,m3h2x4(:,14),heltab2x8(:,:,14))
  call Hloop_QA_S(ntryL,G2H8(9),ex2(:),G2H4(15),ngPtb,m3h2x4(:,15),heltab2x8(:,:,15))
  call Hloop_QA_V(ntryL,G2H8(10),ex2(:),G2H4(16),m3h2x4(:,16),heltab2x8(:,:,16))
  call Hloop_QA_Z(ntryL,G2H8(11),ex2(:),G2H4(17),ngZu,m3h2x4(:,17),heltab2x8(:,:,17))
  call Hloop_QA_W(ntryL,G2H8(12),ex2(:),G2H4(18),m3h2x4(:,18),heltab2x8(:,:,18))
  call Hloop_SQ_A(ntryL,G1H8(7),ex1(:),G1H4(1),ngH,m3h2x4(:,19),heltab2x8(:,:,19))
  call Hloop_Q_A(ntryL,G1H4(1),19,nMT,G2H4(19),n2h4(7))
  call Hloop_SQ_A(ntryL,G1H8(8),ex1(:),G1H4(1),ngX,m3h2x4(:,20),heltab2x8(:,:,20))
  call Hloop_Q_A(ntryL,G1H4(1),19,nMT,G2H4(20),n2h4(8))
  call Hloop_SQ_A(ntryL,G1H8(9),ex1(:),G1H4(1),ngPbt,m3h2x4(:,21),heltab2x8(:,:,21))
  call Hloop_Q_A(ntryL,G1H4(1),19,nMB,G2H4(21),n2h4(9))
  call Hloop_VQ_A(ntryL,G1H8(10),ex1(:),G1H4(1),m3h2x4(:,22),heltab2x8(:,:,22))
  call Hloop_Q_A(ntryL,G1H4(1),19,nMT,G2H4(22),n2h4(10))
  call Hloop_ZQ_A(ntryL,G1H8(11),ex1(:),G1H4(1),ngZu,m3h2x4(:,23),heltab2x8(:,:,23))
  call Hloop_Q_A(ntryL,G1H4(1),19,nMT,G2H4(23),n2h4(11))
  call Hloop_WQ_A(ntryL,G1H8(12),ex1(:),G1H4(1),m3h2x4(:,24),heltab2x8(:,:,24))
  call Hloop_Q_A(ntryL,G1H4(1),19,nMB,G2H4(24),n2h4(12))
  call Hloop_SA_Q(ntryL,G1H8(13),ex2(:),G1H4(1),ngH,m3h2x4(:,25),heltab2x8(:,:,25))
  call Hloop_A_Q(ntryL,G1H4(1),19,nMT,G2H4(25),n2h4(13))
  call Hloop_SA_Q(ntryL,G1H8(14),ex2(:),G1H4(1),ngX,m3h2x4(:,26),heltab2x8(:,:,26))
  call Hloop_A_Q(ntryL,G1H4(1),19,nMT,G2H4(26),n2h4(14))
  call Hloop_SA_Q(ntryL,G1H8(15),ex2(:),G1H4(1),ngPtb,m3h2x4(:,27),heltab2x8(:,:,27))
  call Hloop_A_Q(ntryL,G1H4(1),19,nMB,G2H4(27),n2h4(15))
  call Hloop_VA_Q(ntryL,G1H8(16),ex2(:),G1H4(1),m3h2x4(:,28),heltab2x8(:,:,28))
  call Hloop_A_Q(ntryL,G1H4(1),19,nMT,G2H4(28),n2h4(16))
  call Hloop_ZA_Q(ntryL,G1H8(17),ex2(:),G1H4(1),ngZu,m3h2x4(:,29),heltab2x8(:,:,29))
  call Hloop_A_Q(ntryL,G1H4(1),19,nMT,G2H4(29),n2h4(17))
  call Hloop_WA_Q(ntryL,G1H8(18),ex2(:),G1H4(1),m3h2x4(:,30),heltab2x8(:,:,30))
  call Hloop_A_Q(ntryL,G1H4(1),19,nMB,G2H4(30),n2h4(18))
  call Hloop_SA_Q(ntryL,G1H8(19),ex2(:),G1H4(1),ngH,m3h2x4(:,31),heltab2x8(:,:,31))
  call Hloop_A_Q(ntryL,G1H4(1),19,nMT,G2H4(31),n2h4(19))
  call Hloop_SA_Q(ntryL,G1H8(20),ex2(:),G1H4(1),ngX,m3h2x4(:,32),heltab2x8(:,:,32))
  call Hloop_A_Q(ntryL,G1H4(1),19,nMT,G2H4(32),n2h4(20))
  call Hloop_SA_Q(ntryL,G1H8(21),ex2(:),G1H4(1),ngPtb,m3h2x4(:,33),heltab2x8(:,:,33))
  call Hloop_A_Q(ntryL,G1H4(1),19,nMB,G2H4(33),n2h4(21))
  call Hloop_VA_Q(ntryL,G1H8(22),ex2(:),G1H4(1),m3h2x4(:,34),heltab2x8(:,:,34))
  call Hloop_A_Q(ntryL,G1H4(1),19,nMT,G2H4(34),n2h4(22))
  call Hloop_ZA_Q(ntryL,G1H8(23),ex2(:),G1H4(1),ngZu,m3h2x4(:,35),heltab2x8(:,:,35))
  call Hloop_A_Q(ntryL,G1H4(1),19,nMT,G2H4(35),n2h4(23))
  call Hloop_WA_Q(ntryL,G1H8(24),ex2(:),G1H4(1),m3h2x4(:,36),heltab2x8(:,:,36))
  call Hloop_A_Q(ntryL,G1H4(1),19,nMB,G2H4(36),n2h4(24))
  call Hloop_TV_S(ntryL,G1H8(25),18,ex3(:),4,G2H4(37),m3h2x4(:,37),heltab2x8(:,:,37))
  call Hloop_VV_S(ntryL,G1H8(26),ex3(:),G1H4(1),m3h2x4(:,38),heltab2x8(:,:,38))
  call Hloop_SV_V(ntryL,G1H8(27),ex3(:),G1H4(2),m3h2x4(:,39),heltab2x8(:,:,39))
  call Hloop_UV_W(ntryL,G1H8(28),18,ex3(:),4,G2H4(38),m3h2x4(:,40),heltab2x8(:,:,40))
  call Hloop_TV_S(ntryL,G1H8(29),18,ex4(:),8,G2H4(39),m3h2x4(:,41),heltab2x8(:,:,41))
  call Hloop_VV_S(ntryL,G1H8(30),ex4(:),G1H4(3),m3h2x4(:,42),heltab2x8(:,:,42))
  call Hloop_SV_V(ntryL,G1H8(31),ex4(:),G1H4(4),m3h2x4(:,43),heltab2x8(:,:,43))
  call Hloop_UV_W(ntryL,G1H8(32),18,ex4(:),8,G2H4(40),m3h2x4(:,44),heltab2x8(:,:,44))
  call Hloop_SV_T(ntryL,G1H8(33),17,ex3(:),4,G2H4(41),m3h2x4(:,45),heltab2x8(:,:,45))
  call Hloop_SV_V(ntryL,G1H8(34),ex3(:),G1H4(5),m3h2x4(:,46),heltab2x8(:,:,46))
  call Hloop_VV_S(ntryL,G1H8(35),ex3(:),G1H4(6),m3h2x4(:,47),heltab2x8(:,:,47))
  call Hloop_UW_V(ntryL,G1H8(36),17,ex3(:),4,G2H4(42),m3h2x4(:,48),heltab2x8(:,:,48))
  call Hloop_SV_T(ntryL,G1H8(37),17,ex3(:),4,G2H4(43),m3h2x4(:,49),heltab2x8(:,:,49))
  call Hloop_SV_V(ntryL,G1H8(38),ex3(:),G1H4(7),m3h2x4(:,50),heltab2x8(:,:,50))
  call Hloop_SV_T(ntryL,G1H8(39),17,ex3(:),4,G2H4(44),m3h2x4(:,51),heltab2x8(:,:,51))
  call Hloop_VV_S(ntryL,G1H8(40),ex3(:),G1H4(8),m3h2x4(:,52),heltab2x8(:,:,52))
  call Hloop_SV_V(ntryL,G1H8(41),ex3(:),G1H4(9),m3h2x4(:,53),heltab2x8(:,:,53))
  call Hloop_UW_V(ntryL,G1H8(42),17,ex3(:),4,G2H4(45),m3h2x4(:,54),heltab2x8(:,:,54))
  call Hloop_VV_S(ntryL,G1H8(43),ex3(:),G1H4(10),m3h2x4(:,55),heltab2x8(:,:,55))
  call Hloop_UW_V(ntryL,G1H8(44),17,ex3(:),4,G2H4(46),m3h2x4(:,56),heltab2x8(:,:,56))
  call Hloop_SV_T(ntryL,G1H8(45),17,ex4(:),8,G2H4(47),m3h2x4(:,57),heltab2x8(:,:,57))
  call Hloop_SV_V(ntryL,G1H8(46),ex4(:),G1H4(11),m3h2x4(:,58),heltab2x8(:,:,58))
  call Hloop_VV_S(ntryL,G1H8(47),ex4(:),G1H4(12),m3h2x4(:,59),heltab2x8(:,:,59))
  call Hloop_UW_V(ntryL,G1H8(48),17,ex4(:),8,G2H4(48),m3h2x4(:,60),heltab2x8(:,:,60))
  call Hloop_SV_T(ntryL,G1H8(49),17,ex4(:),8,G2H4(49),m3h2x4(:,61),heltab2x8(:,:,61))
  call Hloop_SV_V(ntryL,G1H8(50),ex4(:),G1H4(13),m3h2x4(:,62),heltab2x8(:,:,62))
  call Hloop_SV_T(ntryL,G1H8(51),17,ex4(:),8,G2H4(50),m3h2x4(:,63),heltab2x8(:,:,63))
  call Hloop_VV_S(ntryL,G1H8(52),ex4(:),G1H4(14),m3h2x4(:,64),heltab2x8(:,:,64))
  call Hloop_SV_V(ntryL,G1H8(53),ex4(:),G1H4(15),m3h2x4(:,65),heltab2x8(:,:,65))
  call Hloop_UW_V(ntryL,G1H8(54),17,ex4(:),8,G2H4(51),m3h2x4(:,66),heltab2x8(:,:,66))
  call Hloop_VV_S(ntryL,G1H8(55),ex4(:),G1H4(16),m3h2x4(:,67),heltab2x8(:,:,67))
  call Hloop_UW_V(ntryL,G1H8(56),17,ex4(:),8,G2H4(52),m3h2x4(:,68),heltab2x8(:,:,68))
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(11),[G2H4(8)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(12),[G2H4(9)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(23),[G2H4(20)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(24),[G2H4(21)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(29),[G2H4(26)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(30),[G2H4(27)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(35),[G2H4(32)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(36),[G2H4(33)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(37),[G1H4(1)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(38),[G1H4(2)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(39),[G1H4(3)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(40),[G1H4(4)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(41),[G1H4(6)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(42),[G1H4(5)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(43),[G1H4(8)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(45),[G1H4(7)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(44),[G1H4(10)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(46),[G1H4(9)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(47),[G1H4(12)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(48),[G1H4(11)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(49),[G1H4(14)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(51),[G1H4(13)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(50),[G1H4(16)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(52),[G1H4(15)])
  call Hotf_5pt_reduction(G2H4(1),RedSet_5(1),mass5set(:,1),  & 
G1H4(1),G1H4(2),G1H4(3),G1H4(4),G1H4(6),G1H4(5),4)
  call HG1shiftOLR(G1H4(2),8,4)
  call Hotf_5pt_reduction(G2H4(2),RedSet_5(1),mass5set(:,2),  & 
G1H4(8),G1H4(7),G1H4(10),G1H4(9),G1H4(12),G1H4(11),4)
  call HG1shiftOLR(G1H4(7),8,4)
  call Hotf_5pt_reduction(G2H4(3),RedSet_5(1),mass5set(:,3),  & 
G1H4(14),G1H4(13),G1H4(16),G1H4(15),G1H4(17),G1H4(18),4)
  call HG1shiftOLR(G1H4(13),8,4)
  call Hotf_5pt_reduction(G2H4(4),RedSet_5(1),mass5set(:,4),  & 
G1H4(19),G1H4(20),G1H4(21),G1H4(22),G1H4(23),G1H4(24),4)
  call HG1shiftOLR(G1H4(20),8,4)
  call Hotf_5pt_reduction(G2H4(5),RedSet_5(1),mass5set(:,2),  & 
G1H4(25),G1H4(26),G1H4(27),G1H4(28),G1H4(29),G1H4(30),4)
  call HG1shiftOLR(G1H4(26),8,4)
  call Hotf_5pt_reduction(G2H4(6),RedSet_5(1),mass5set(:,3),  & 
G1H4(31),G1H4(32),G1H4(33),G1H4(34),G1H4(35),G1H4(36),4)
  call HG1shiftOLR(G1H4(32),8,4)
  call Hotf_5pt_reduction(G2H4(7),RedSet_5(2),mass5set(:,5),  & 
G1H4(37),G1H4(38),G1H4(39),G1H4(40),G1H4(41),G1H4(42),4)
  call HG1shiftOLR(G1H4(38),8,4)
  call Hotf_5pt_reduction(G2H4(11),RedSet_5(2),mass5set(:,6),  & 
G1H4(43),G1H4(44),G1H4(45),G1H4(46),G1H4(47),G1H4(48),4)
  call HG1shiftOLR(G1H4(44),8,4)
  call Hotf_5pt_reduction(G2H4(12),RedSet_5(2),mass5set(:,7),  & 
G1H4(49),G1H4(50),G1H4(51),G1H4(52),G1H4(53),G1H4(54),4)
  call HG1shiftOLR(G1H4(50),8,4)
  call Hotf_5pt_reduction(G2H4(10),RedSet_5(2),mass5set(:,8),  & 
G1H4(55),G1H4(56),G1H4(57),G1H4(58),G1H4(59),G1H4(60),4)
  call HG1shiftOLR(G1H4(56),8,4)
  call Hotf_5pt_reduction(G2H4(13),RedSet_5(3),mass5set(:,1),  & 
G1H4(61),G1H4(62),G1H4(63),G1H4(64),G1H4(65),G1H4(66),4)
  call HG1shiftOLR(G1H4(62),8,4)
  call Hotf_5pt_reduction(G2H4(14),RedSet_5(3),mass5set(:,2),  & 
G1H4(67),G1H4(68),G1H4(69),G1H4(70),G1H4(71),G1H4(72),4)
  call HG1shiftOLR(G1H4(68),8,4)
  call Hotf_5pt_reduction(G2H4(15),RedSet_5(3),mass5set(:,3),  & 
G1H4(73),G1H4(74),G1H4(75),G1H4(76),G1H4(77),G1H4(78),4)
  call HG1shiftOLR(G1H4(74),8,4)
  call Hotf_5pt_reduction(G2H4(16),RedSet_5(3),mass5set(:,4),  & 
G1H4(79),G1H4(80),G1H4(81),G1H4(82),G1H4(83),G1H4(84),4)
  call HG1shiftOLR(G1H4(80),8,4)
  call Hotf_5pt_reduction(G2H4(17),RedSet_5(3),mass5set(:,2),  & 
G1H4(85),G1H4(86),G1H4(87),G1H4(88),G1H4(89),G1H4(90),4)
  call HG1shiftOLR(G1H4(86),8,4)
  call Hotf_5pt_reduction(G2H4(18),RedSet_5(3),mass5set(:,3),  & 
G1H4(91),G1H4(92),G1H4(93),G1H4(94),G1H4(95),G1H4(96),4)
  call HG1shiftOLR(G1H4(92),8,4)
  call Hotf_5pt_reduction(G2H4(19),RedSet_5(4),mass5set(:,5),  & 
G1H4(97),G1H4(98),G1H4(99),G1H4(100),G1H4(101),G1H4(102),4)
  call HG1shiftOLR(G1H4(98),4,4)
  call Hotf_5pt_reduction(G2H4(23),RedSet_5(4),mass5set(:,6),  & 
G1H4(103),G1H4(104),G1H4(105),G1H4(106),G1H4(107),G1H4(108),4)
  call HG1shiftOLR(G1H4(104),4,4)
  call Hotf_5pt_reduction(G2H4(24),RedSet_5(4),mass5set(:,7),  & 
G1H4(109),G1H4(110),G1H4(111),G1H4(112),G1H4(113),G1H4(114),4)
  call HG1shiftOLR(G1H4(110),4,4)
  call Hotf_5pt_reduction(G2H4(22),RedSet_5(4),mass5set(:,8),  & 
G1H4(115),G1H4(116),G1H4(117),G1H4(118),G1H4(119),G1H4(120),4)
  call HG1shiftOLR(G1H4(116),4,4)
  call Hotf_5pt_reduction(G2H4(25),RedSet_5(5),mass5set(:,5),  & 
G1H4(121),G1H4(122),G1H4(123),G1H4(124),G1H4(125),G1H4(126),4)
  call HG1shiftOLR(G1H4(122),8,4)
  call Hotf_5pt_reduction(G2H4(29),RedSet_5(5),mass5set(:,6),  & 
G1H4(127),G1H4(128),G1H4(129),G1H4(130),G1H4(131),G1H4(132),4)
  call HG1shiftOLR(G1H4(128),8,4)
  call Hotf_5pt_reduction(G2H4(30),RedSet_5(5),mass5set(:,7),  & 
G1H4(133),G1H4(134),G1H4(135),G1H4(136),G1H4(137),G1H4(138),4)
  call HG1shiftOLR(G1H4(134),8,4)
  call Hotf_5pt_reduction(G2H4(28),RedSet_5(5),mass5set(:,8),  & 
G1H4(139),G1H4(140),G1H4(141),G1H4(142),G1H4(143),G1H4(144),4)
  call HG1shiftOLR(G1H4(140),8,4)
  call Hotf_5pt_reduction(G2H4(31),RedSet_5(6),mass5set(:,5),  & 
G1H4(145),G1H4(146),G1H4(147),G1H4(148),G1H4(149),G1H4(150),4)
  call HG1shiftOLR(G1H4(146),4,4)
  call Hotf_5pt_reduction(G2H4(35),RedSet_5(6),mass5set(:,6),  & 
G1H4(151),G1H4(152),G1H4(153),G1H4(154),G1H4(155),G1H4(156),4)
  call HG1shiftOLR(G1H4(152),4,4)
  call Hotf_5pt_reduction(G2H4(36),RedSet_5(6),mass5set(:,7),  & 
G1H4(157),G1H4(158),G1H4(159),G1H4(160),G1H4(161),G1H4(162),4)
  call HG1shiftOLR(G1H4(158),4,4)
  call Hotf_5pt_reduction(G2H4(34),RedSet_5(6),mass5set(:,8),  & 
G1H4(163),G1H4(164),G1H4(165),G1H4(166),G1H4(167),G1H4(168),4)
  call HG1shiftOLR(G1H4(164),4,4)
  call Hotf_5pt_reduction(G2H4(37),RedSet_5(7),mass5set(:,9),  & 
G1H4(169),G1H4(170),G1H4(171),G1H4(172),G1H4(173),G1H4(174),4)
  call HG1shiftOLR(G1H4(170),8,4)
  call Hotf_5pt_reduction(G2H4(38),RedSet_5(7),mass5set(:,9),  & 
G1H4(175),G1H4(176),G1H4(177),G1H4(178),G1H4(179),G1H4(180),4)
  call HG1shiftOLR(G1H4(176),8,4)
  call Hotf_5pt_reduction(G2H4(39),RedSet_5(8),mass5set(:,9),  & 
G1H4(181),G1H4(182),G1H4(183),G1H4(184),G1H4(185),G1H4(186),4)
  call HG1shiftOLR(G1H4(182),4,4)
  call Hotf_5pt_reduction(G2H4(40),RedSet_5(8),mass5set(:,9),  & 
G1H4(187),G1H4(188),G1H4(189),G1H4(190),G1H4(191),G1H4(192),4)
  call HG1shiftOLR(G1H4(188),4,4)
  call Hotf_5pt_reduction(G2H4(41),RedSet_5(9),mass5set(:,9),  & 
G1H4(193),G1H4(194),G1H4(195),G1H4(196),G1H4(197),G1H4(198),4)
  call HG1shiftOLR(G1H4(194),8,4)
  call Hotf_5pt_reduction(G2H4(42),RedSet_5(9),mass5set(:,9),  & 
G1H4(199),G1H4(200),G1H4(201),G1H4(202),G1H4(203),G1H4(204),4)
  call HG1shiftOLR(G1H4(200),8,4)
  call Hotf_5pt_reduction(G2H4(43),RedSet_5(10),mass5set(:,10),  & 
G1H4(205),G1H4(206),G1H4(207),G1H4(208),G1H4(209),G1H4(210),4)
  call HG1shiftOLR(G1H4(206),2,4)
  call Hloop_VV_S(ntryL,G2H4(45),ex4(:),G2H2(1),m3h2x2(:,1),heltab2x4(:,:,1))
  call Hloop_SV_V(ntryL,G2H4(44),ex4(:),G2H2(2),m3h2x2(:,2),heltab2x4(:,:,2))
  call Hotf_5pt_reduction(G2H4(46),RedSet_5(10),mass5set(:,10),  & 
G1H4(211),G1H4(212),G1H4(213),G1H4(214),G1H4(215),G1H4(216),4)
  call HG1shiftOLR(G1H4(212),2,4)
  call Hotf_5pt_reduction(G2H4(47),RedSet_5(11),mass5set(:,9),  & 
G1H4(217),G1H4(218),G1H4(219),G1H4(220),G1H4(221),G1H4(222),4)
  call HG1shiftOLR(G1H4(218),4,4)
  call Hotf_5pt_reduction(G2H4(48),RedSet_5(11),mass5set(:,9),  & 
G1H4(223),G1H4(224),G1H4(225),G1H4(226),G1H4(227),G1H4(228),4)
  call HG1shiftOLR(G1H4(224),4,4)
  call Hotf_5pt_reduction(G2H4(49),RedSet_5(12),mass5set(:,10),  & 
G1H4(229),G1H4(230),G1H4(231),G1H4(232),G1H4(233),G1H4(234),4)
  call HG1shiftOLR(G1H4(230),2,4)
  call Hloop_VV_S(ntryL,G2H4(51),ex3(:),G2H2(3),m3h2x2(:,3),heltab2x4(:,:,3))
  call Hloop_SV_V(ntryL,G2H4(50),ex3(:),G2H2(4),m3h2x2(:,4),heltab2x4(:,:,4))
  call Hotf_5pt_reduction(G2H4(52),RedSet_5(12),mass5set(:,10),  & 
G1H4(235),G1H4(236),G1H4(237),G1H4(238),G1H4(239),G1H4(240),4)
  call HG1shiftOLR(G1H4(236),2,4)
  call Hloop_SA_Q(ntryL,G1H4(1),ex2(:),G1H2(1),ngH,m3h2x2(:,5),heltab2x4(:,:,5))
  call Hloop_A_Q(ntryL,G1H2(1),23,nMT,G2H2(5),n2h2(1))
call HGT_OLR(G1H4(2),1,1,4)
call HGT_invQ_OLR(G1H4(2),2,5,4)
  call Hloop_Q_A(ntryL,G1H4(2),-8,nMT,G2H4(8),n2h4(25))
  call Hloop_QV_A(ntryL,G2H4(8),ex4(:),G2H2(6),m3h2x2(:,6),heltab2x4(:,:,6))
  call Hloop_SA_Q(ntryL,G1H4(6),ex2(:),G1H2(1),ngH,m3h2x2(:,7),heltab2x4(:,:,7))
  call Hloop_A_Q(ntryL,G1H2(1),23,nMT,G2H2(7),n2h2(2))
  call Hloop_SA_Q(ntryL,G1H4(5),ex2(:),G1H2(1),ngH,m3h2x2(:,8),heltab2x4(:,:,8))
  call Hloop_A_Q(ntryL,G1H2(1),23,nMT,G2H2(8),n2h2(3))
  call Hloop_SA_Q(ntryL,G1H4(8),ex2(:),G1H2(1),ngX,m3h2x2(:,9),heltab2x4(:,:,9))
  call Hloop_A_Q(ntryL,G1H2(1),23,nMT,G2H2(9),n2h2(4))
call HGT_OLR(G1H4(7),1,1,4)
call HGT_invQ_OLR(G1H4(7),2,5,4)
  call Hloop_Q_A(ntryL,G1H4(7),-8,nMT,G2H4(9),n2h4(26))
  call Hloop_QV_A(ntryL,G2H4(9),ex4(:),G2H2(10),m3h2x2(:,10),heltab2x4(:,:,10))
  call Hloop_SA_Q(ntryL,G1H4(12),ex2(:),G1H2(1),ngX,m3h2x2(:,11),heltab2x4(:,:,11))
  call Hloop_A_Q(ntryL,G1H2(1),23,nMT,G2H2(11),n2h2(5))
  call Hloop_SA_Q(ntryL,G1H4(11),ex2(:),G1H2(1),ngX,m3h2x2(:,12),heltab2x4(:,:,12))
  call Hloop_A_Q(ntryL,G1H2(1),23,nMT,G2H2(12),n2h2(6))
  call Hloop_SA_Q(ntryL,G1H4(14),ex2(:),G1H2(1),ngPtb,m3h2x2(:,13),heltab2x4(:,:,13))
  call Hloop_A_Q(ntryL,G1H2(1),23,nMB,G2H2(13),n2h2(7))
call HGT_OLR(G1H4(13),1,1,4)
call HGT_invQ_OLR(G1H4(13),2,5,4)
  call Hloop_Q_A(ntryL,G1H4(13),-8,nMB,G2H4(20),n2h4(27))
  call Hloop_QV_A(ntryL,G2H4(20),ex4(:),G2H2(14),m3h2x2(:,14),heltab2x4(:,:,14))
  call Hloop_SA_Q(ntryL,G1H4(17),ex2(:),G1H2(1),ngPtb,m3h2x2(:,15),heltab2x4(:,:,15))
  call Hloop_A_Q(ntryL,G1H2(1),23,nMB,G2H2(15),n2h2(8))
  call Hloop_SA_Q(ntryL,G1H4(18),ex2(:),G1H2(1),ngPtb,m3h2x2(:,16),heltab2x4(:,:,16))
  call Hloop_A_Q(ntryL,G1H2(1),23,nMB,G2H2(16),n2h2(9))
  call Hloop_VA_Q(ntryL,G1H4(19),ex2(:),G1H2(1),m3h2x2(:,17),heltab2x4(:,:,17))
  call Hloop_A_Q(ntryL,G1H2(1),23,nMT,G2H2(17),n2h2(10))
call HGT_OLR(G1H4(20),1,1,4)
call HGT_invQ_OLR(G1H4(20),2,5,4)
  call Hloop_Q_A(ntryL,G1H4(20),-8,nMT,G2H4(21),n2h4(28))
  call Hloop_QV_A(ntryL,G2H4(21),ex4(:),G2H2(18),m3h2x2(:,18),heltab2x4(:,:,18))
  call Hloop_VA_Q(ntryL,G1H4(23),ex2(:),G1H2(1),m3h2x2(:,19),heltab2x4(:,:,19))
  call Hloop_A_Q(ntryL,G1H2(1),23,nMT,G2H2(19),n2h2(11))
  call Hloop_VA_Q(ntryL,G1H4(24),ex2(:),G1H2(1),m3h2x2(:,20),heltab2x4(:,:,20))
  call Hloop_A_Q(ntryL,G1H2(1),23,nMT,G2H2(20),n2h2(12))
  call Hloop_ZA_Q(ntryL,G1H4(25),ex2(:),G1H2(1),ngZu,m3h2x2(:,21),heltab2x4(:,:,21))
  call Hloop_A_Q(ntryL,G1H2(1),23,nMT,G2H2(21),n2h2(13))
call HGT_OLR(G1H4(26),1,1,4)
call HGT_invQ_OLR(G1H4(26),2,5,4)
  call Hloop_Q_A(ntryL,G1H4(26),-8,nMT,G2H4(26),n2h4(29))
  call Hloop_QV_A(ntryL,G2H4(26),ex4(:),G2H2(22),m3h2x2(:,22),heltab2x4(:,:,22))
  call Hloop_ZA_Q(ntryL,G1H4(29),ex2(:),G1H2(1),ngZu,m3h2x2(:,23),heltab2x4(:,:,23))
  call Hloop_A_Q(ntryL,G1H2(1),23,nMT,G2H2(23),n2h2(14))
  call Hloop_ZA_Q(ntryL,G1H4(30),ex2(:),G1H2(1),ngZu,m3h2x2(:,24),heltab2x4(:,:,24))
  call Hloop_A_Q(ntryL,G1H2(1),23,nMT,G2H2(24),n2h2(15))
  call Hloop_WA_Q(ntryL,G1H4(31),ex2(:),G1H2(1),m3h2x2(:,25),heltab2x4(:,:,25))
  call Hloop_A_Q(ntryL,G1H2(1),23,nMB,G2H2(25),n2h2(16))
call HGT_OLR(G1H4(32),1,1,4)
call HGT_invQ_OLR(G1H4(32),2,5,4)
  call Hloop_Q_A(ntryL,G1H4(32),-8,nMB,G2H4(27),n2h4(30))
  call Hloop_QV_A(ntryL,G2H4(27),ex4(:),G2H2(26),m3h2x2(:,26),heltab2x4(:,:,26))
  call Hloop_WA_Q(ntryL,G1H4(35),ex2(:),G1H2(1),m3h2x2(:,27),heltab2x4(:,:,27))
  call Hloop_A_Q(ntryL,G1H2(1),23,nMB,G2H2(27),n2h2(17))
  call Hloop_WA_Q(ntryL,G1H4(36),ex2(:),G1H2(1),m3h2x2(:,28),heltab2x4(:,:,28))
  call Hloop_A_Q(ntryL,G1H2(1),23,nMB,G2H2(28),n2h2(18))
  call Hloop_QV_A(ntryL,G1H4(37),ex3(:),G1H2(1),m3h2x2(:,29),heltab2x4(:,:,29))
  call Hloop_Q_A(ntryL,G1H2(1),23,nMT,G2H2(29),n2h2(19))
call HGT_OLR(G1H4(38),1,1,4)
call HGT_invQ_OLR(G1H4(38),2,5,4)
  call Hloop_A_Q(ntryL,G1H4(38),-8,nMT,G2H4(32),n2h4(31))
  call Hloop_AV_Q(ntryL,G2H4(32),ex4(:),G2H2(30),m3h2x2(:,30),heltab2x4(:,:,30))
  call Hloop_QV_A(ntryL,G1H4(41),ex3(:),G1H2(1),m3h2x2(:,31),heltab2x4(:,:,31))
  call Hloop_Q_A(ntryL,G1H2(1),23,nMT,G2H2(31),n2h2(20))
  call Hloop_QV_A(ntryL,G1H4(42),ex3(:),G1H2(1),m3h2x2(:,32),heltab2x4(:,:,32))
  call Hloop_Q_A(ntryL,G1H2(1),23,nMT,G2H2(32),n2h2(21))
  call Hloop_QV_A(ntryL,G1H4(43),ex3(:),G1H2(1),m3h2x2(:,33),heltab2x4(:,:,33))
  call Hloop_Q_A(ntryL,G1H2(1),23,nMT,G2H2(33),n2h2(22))
call HGT_OLR(G1H4(44),1,1,4)
call HGT_invQ_OLR(G1H4(44),2,5,4)
  call Hloop_A_Q(ntryL,G1H4(44),-8,nMT,G2H4(33),n2h4(32))
  call Hloop_AV_Q(ntryL,G2H4(33),ex4(:),G2H2(34),m3h2x2(:,34),heltab2x4(:,:,34))
  call Hloop_QV_A(ntryL,G1H4(47),ex3(:),G1H2(1),m3h2x2(:,35),heltab2x4(:,:,35))
  call Hloop_Q_A(ntryL,G1H2(1),23,nMT,G2H2(35),n2h2(23))
  call Hloop_QV_A(ntryL,G1H4(48),ex3(:),G1H2(1),m3h2x2(:,36),heltab2x4(:,:,36))
  call Hloop_Q_A(ntryL,G1H2(1),23,nMT,G2H2(36),n2h2(24))
  call Hloop_QV_A(ntryL,G1H4(49),ex3(:),G1H2(1),m3h2x2(:,37),heltab2x4(:,:,37))
  call Hloop_Q_A(ntryL,G1H2(1),23,nMB,G2H2(37),n2h2(25))
call HGT_OLR(G1H4(50),1,1,4)
call HGT_invQ_OLR(G1H4(50),2,5,4)
  call Hloop_A_Q(ntryL,G1H4(50),-8,nMB,G2H4(1),n2h4(33))
  call Hloop_AV_Q(ntryL,G2H4(1),ex4(:),G2H2(38),m3h2x2(:,38),heltab2x4(:,:,38))
  call Hloop_QV_A(ntryL,G1H4(53),ex3(:),G1H2(1),m3h2x2(:,39),heltab2x4(:,:,39))
  call Hloop_Q_A(ntryL,G1H2(1),23,nMB,G2H2(39),n2h2(26))
  call Hloop_QV_A(ntryL,G1H4(54),ex3(:),G1H2(1),m3h2x2(:,40),heltab2x4(:,:,40))
  call Hloop_Q_A(ntryL,G1H2(1),23,nMB,G2H2(40),n2h2(27))
  call Hloop_QV_A(ntryL,G1H4(55),ex3(:),G1H2(1),m3h2x2(:,41),heltab2x4(:,:,41))
  call Hloop_Q_A(ntryL,G1H2(1),23,nMT,G2H2(41),n2h2(28))
call HGT_OLR(G1H4(56),1,1,4)
call HGT_invQ_OLR(G1H4(56),2,5,4)
  call Hloop_A_Q(ntryL,G1H4(56),-8,nMT,G2H4(2),n2h4(34))
  call Hloop_AV_Q(ntryL,G2H4(2),ex4(:),G2H2(42),m3h2x2(:,42),heltab2x4(:,:,42))
  call Hloop_QV_A(ntryL,G1H4(59),ex3(:),G1H2(1),m3h2x2(:,43),heltab2x4(:,:,43))
  call Hloop_Q_A(ntryL,G1H2(1),23,nMT,G2H2(43),n2h2(29))
  call Hloop_QV_A(ntryL,G1H4(60),ex3(:),G1H2(1),m3h2x2(:,44),heltab2x4(:,:,44))
  call Hloop_Q_A(ntryL,G1H2(1),23,nMT,G2H2(44),n2h2(30))
  call Hloop_SQ_A(ntryL,G1H4(61),ex1(:),G1H2(1),ngH,m3h2x2(:,45),heltab2x4(:,:,45))
  call Hloop_Q_A(ntryL,G1H2(1),23,nMT,G2H2(45),n2h2(31))
call HGT_OLR(G1H4(62),1,1,4)
call HGT_invQ_OLR(G1H4(62),2,5,4)
  call Hloop_A_Q(ntryL,G1H4(62),-8,nMT,G2H4(3),n2h4(35))
  call Hloop_AV_Q(ntryL,G2H4(3),ex4(:),G2H2(46),m3h2x2(:,46),heltab2x4(:,:,46))
  call Hloop_SQ_A(ntryL,G1H4(65),ex1(:),G1H2(1),ngH,m3h2x2(:,47),heltab2x4(:,:,47))
  call Hloop_Q_A(ntryL,G1H2(1),23,nMT,G2H2(47),n2h2(32))
  call Hloop_SQ_A(ntryL,G1H4(66),ex1(:),G1H2(1),ngH,m3h2x2(:,48),heltab2x4(:,:,48))
  call Hloop_Q_A(ntryL,G1H2(1),23,nMT,G2H2(48),n2h2(33))
  call Hloop_SQ_A(ntryL,G1H4(67),ex1(:),G1H2(1),ngX,m3h2x2(:,49),heltab2x4(:,:,49))
  call Hloop_Q_A(ntryL,G1H2(1),23,nMT,G2H2(49),n2h2(34))
call HGT_OLR(G1H4(68),1,1,4)
call HGT_invQ_OLR(G1H4(68),2,5,4)
  call Hloop_A_Q(ntryL,G1H4(68),-8,nMT,G2H4(4),n2h4(36))
  call Hloop_AV_Q(ntryL,G2H4(4),ex4(:),G2H2(50),m3h2x2(:,50),heltab2x4(:,:,50))
  call Hloop_SQ_A(ntryL,G1H4(71),ex1(:),G1H2(1),ngX,m3h2x2(:,51),heltab2x4(:,:,51))
  call Hloop_Q_A(ntryL,G1H2(1),23,nMT,G2H2(51),n2h2(35))
  call Hloop_SQ_A(ntryL,G1H4(72),ex1(:),G1H2(1),ngX,m3h2x2(:,52),heltab2x4(:,:,52))
  call Hloop_Q_A(ntryL,G1H2(1),23,nMT,G2H2(52),n2h2(36))
  call Hloop_SQ_A(ntryL,G1H4(73),ex1(:),G1H2(1),ngPbt,m3h2x2(:,53),heltab2x4(:,:,53))
  call Hloop_Q_A(ntryL,G1H2(1),23,nMB,G2H2(53),n2h2(37))
call HGT_OLR(G1H4(74),1,1,4)
call HGT_invQ_OLR(G1H4(74),2,5,4)
  call Hloop_A_Q(ntryL,G1H4(74),-8,nMB,G2H4(5),n2h4(37))
  call Hloop_AV_Q(ntryL,G2H4(5),ex4(:),G2H2(54),m3h2x2(:,54),heltab2x4(:,:,54))
  call Hloop_SQ_A(ntryL,G1H4(77),ex1(:),G1H2(1),ngPbt,m3h2x2(:,55),heltab2x4(:,:,55))
  call Hloop_Q_A(ntryL,G1H2(1),23,nMB,G2H2(55),n2h2(38))
  call Hloop_SQ_A(ntryL,G1H4(78),ex1(:),G1H2(1),ngPbt,m3h2x2(:,56),heltab2x4(:,:,56))
  call Hloop_Q_A(ntryL,G1H2(1),23,nMB,G2H2(56),n2h2(39))
  call Hloop_VQ_A(ntryL,G1H4(79),ex1(:),G1H2(1),m3h2x2(:,57),heltab2x4(:,:,57))
  call Hloop_Q_A(ntryL,G1H2(1),23,nMT,G2H2(57),n2h2(40))
call HGT_OLR(G1H4(80),1,1,4)
call HGT_invQ_OLR(G1H4(80),2,5,4)
  call Hloop_A_Q(ntryL,G1H4(80),-8,nMT,G2H4(6),n2h4(38))
  call Hloop_AV_Q(ntryL,G2H4(6),ex4(:),G2H2(58),m3h2x2(:,58),heltab2x4(:,:,58))
  call Hloop_VQ_A(ntryL,G1H4(83),ex1(:),G1H2(1),m3h2x2(:,59),heltab2x4(:,:,59))
  call Hloop_Q_A(ntryL,G1H2(1),23,nMT,G2H2(59),n2h2(41))
  call Hloop_VQ_A(ntryL,G1H4(84),ex1(:),G1H2(1),m3h2x2(:,60),heltab2x4(:,:,60))
  call Hloop_Q_A(ntryL,G1H2(1),23,nMT,G2H2(60),n2h2(42))
  call Hloop_ZQ_A(ntryL,G1H4(85),ex1(:),G1H2(1),ngZu,m3h2x2(:,61),heltab2x4(:,:,61))
  call Hloop_Q_A(ntryL,G1H2(1),23,nMT,G2H2(61),n2h2(43))
call HGT_OLR(G1H4(86),1,1,4)
call HGT_invQ_OLR(G1H4(86),2,5,4)
  call Hloop_A_Q(ntryL,G1H4(86),-8,nMT,G2H4(7),n2h4(39))
  call Hloop_AV_Q(ntryL,G2H4(7),ex4(:),G2H2(62),m3h2x2(:,62),heltab2x4(:,:,62))
  call Hloop_ZQ_A(ntryL,G1H4(89),ex1(:),G1H2(1),ngZu,m3h2x2(:,63),heltab2x4(:,:,63))
  call Hloop_Q_A(ntryL,G1H2(1),23,nMT,G2H2(63),n2h2(44))
  call Hloop_ZQ_A(ntryL,G1H4(90),ex1(:),G1H2(1),ngZu,m3h2x2(:,64),heltab2x4(:,:,64))
  call Hloop_Q_A(ntryL,G1H2(1),23,nMT,G2H2(64),n2h2(45))
  call Hloop_WQ_A(ntryL,G1H4(91),ex1(:),G1H2(1),m3h2x2(:,65),heltab2x4(:,:,65))
  call Hloop_Q_A(ntryL,G1H2(1),23,nMB,G2H2(65),n2h2(46))
call HGT_OLR(G1H4(92),1,1,4)
call HGT_invQ_OLR(G1H4(92),2,5,4)
  call Hloop_A_Q(ntryL,G1H4(92),-8,nMB,G2H4(11),n2h4(40))
  call Hloop_AV_Q(ntryL,G2H4(11),ex4(:),G2H2(66),m3h2x2(:,66),heltab2x4(:,:,66))
  call Hloop_WQ_A(ntryL,G1H4(95),ex1(:),G1H2(1),m3h2x2(:,67),heltab2x4(:,:,67))
  call Hloop_Q_A(ntryL,G1H2(1),23,nMB,G2H2(67),n2h2(47))
  call Hloop_WQ_A(ntryL,G1H4(96),ex1(:),G1H2(1),m3h2x2(:,68),heltab2x4(:,:,68))
  call Hloop_Q_A(ntryL,G1H2(1),23,nMB,G2H2(68),n2h2(48))
  call Hloop_QV_A(ntryL,G1H4(97),ex4(:),G1H2(1),m3h2x2(:,69),heltab2x4(:,:,69))
  call Hloop_Q_A(ntryL,G1H2(1),27,nMT,G2H2(69),n2h2(49))
call HGT_OLR(G1H4(98),1,1,4)
call HGT_invQ_OLR(G1H4(98),2,5,4)
  call Hloop_A_Q(ntryL,G1H4(98),-4,nMT,G2H4(12),n2h4(41))
  call Hloop_AV_Q(ntryL,G2H4(12),ex3(:),G2H2(70),m3h2x2(:,70),heltab2x4(:,:,70))
  call Hloop_QV_A(ntryL,G1H4(101),ex4(:),G1H2(1),m3h2x2(:,71),heltab2x4(:,:,71))
  call Hloop_Q_A(ntryL,G1H2(1),27,nMT,G2H2(71),n2h2(50))
  call Hloop_QV_A(ntryL,G1H4(102),ex4(:),G1H2(1),m3h2x2(:,72),heltab2x4(:,:,72))
  call Hloop_Q_A(ntryL,G1H2(1),27,nMT,G2H2(72),n2h2(51))
  call Hloop_QV_A(ntryL,G1H4(103),ex4(:),G1H2(1),m3h2x2(:,73),heltab2x4(:,:,73))
  call Hloop_Q_A(ntryL,G1H2(1),27,nMT,G2H2(73),n2h2(52))
call HGT_OLR(G1H4(104),1,1,4)
call HGT_invQ_OLR(G1H4(104),2,5,4)
  call Hloop_A_Q(ntryL,G1H4(104),-4,nMT,G2H4(10),n2h4(42))
  call Hloop_AV_Q(ntryL,G2H4(10),ex3(:),G2H2(74),m3h2x2(:,74),heltab2x4(:,:,74))
  call Hloop_QV_A(ntryL,G1H4(107),ex4(:),G1H2(1),m3h2x2(:,75),heltab2x4(:,:,75))
  call Hloop_Q_A(ntryL,G1H2(1),27,nMT,G2H2(75),n2h2(53))
  call Hloop_QV_A(ntryL,G1H4(108),ex4(:),G1H2(1),m3h2x2(:,76),heltab2x4(:,:,76))
  call Hloop_Q_A(ntryL,G1H2(1),27,nMT,G2H2(76),n2h2(54))
  call Hloop_QV_A(ntryL,G1H4(109),ex4(:),G1H2(1),m3h2x2(:,77),heltab2x4(:,:,77))
  call Hloop_Q_A(ntryL,G1H2(1),27,nMB,G2H2(77),n2h2(55))
call HGT_OLR(G1H4(110),1,1,4)
call HGT_invQ_OLR(G1H4(110),2,5,4)
  call Hloop_A_Q(ntryL,G1H4(110),-4,nMB,G2H4(13),n2h4(43))
  call Hloop_AV_Q(ntryL,G2H4(13),ex3(:),G2H2(78),m3h2x2(:,78),heltab2x4(:,:,78))
  call Hloop_QV_A(ntryL,G1H4(113),ex4(:),G1H2(1),m3h2x2(:,79),heltab2x4(:,:,79))
  call Hloop_Q_A(ntryL,G1H2(1),27,nMB,G2H2(79),n2h2(56))
  call Hloop_QV_A(ntryL,G1H4(114),ex4(:),G1H2(1),m3h2x2(:,80),heltab2x4(:,:,80))
  call Hloop_Q_A(ntryL,G1H2(1),27,nMB,G2H2(80),n2h2(57))
  call Hloop_QV_A(ntryL,G1H4(115),ex4(:),G1H2(1),m3h2x2(:,81),heltab2x4(:,:,81))
  call Hloop_Q_A(ntryL,G1H2(1),27,nMT,G2H2(81),n2h2(58))
call HGT_OLR(G1H4(116),1,1,4)
call HGT_invQ_OLR(G1H4(116),2,5,4)
  call Hloop_A_Q(ntryL,G1H4(116),-4,nMT,G2H4(14),n2h4(44))
  call Hloop_AV_Q(ntryL,G2H4(14),ex3(:),G2H2(82),m3h2x2(:,82),heltab2x4(:,:,82))
  call Hloop_QV_A(ntryL,G1H4(119),ex4(:),G1H2(1),m3h2x2(:,83),heltab2x4(:,:,83))
  call Hloop_Q_A(ntryL,G1H2(1),27,nMT,G2H2(83),n2h2(59))
  call Hloop_QV_A(ntryL,G1H4(120),ex4(:),G1H2(1),m3h2x2(:,84),heltab2x4(:,:,84))
  call Hloop_Q_A(ntryL,G1H2(1),27,nMT,G2H2(84),n2h2(60))
  call Hloop_AV_Q(ntryL,G1H4(121),ex3(:),G1H2(1),m3h2x2(:,85),heltab2x4(:,:,85))
  call Hloop_A_Q(ntryL,G1H2(1),23,nMT,G2H2(85),n2h2(61))
call HGT_OLR(G1H4(122),1,1,4)
call HGT_invQ_OLR(G1H4(122),2,5,4)
  call Hloop_Q_A(ntryL,G1H4(122),-8,nMT,G2H4(15),n2h4(45))
  call Hloop_QV_A(ntryL,G2H4(15),ex4(:),G2H2(86),m3h2x2(:,86),heltab2x4(:,:,86))
  call Hloop_AV_Q(ntryL,G1H4(125),ex3(:),G1H2(1),m3h2x2(:,87),heltab2x4(:,:,87))
  call Hloop_A_Q(ntryL,G1H2(1),23,nMT,G2H2(87),n2h2(62))
  call Hloop_AV_Q(ntryL,G1H4(126),ex3(:),G1H2(1),m3h2x2(:,88),heltab2x4(:,:,88))
  call Hloop_A_Q(ntryL,G1H2(1),23,nMT,G2H2(88),n2h2(63))
  call Hloop_AV_Q(ntryL,G1H4(127),ex3(:),G1H2(1),m3h2x2(:,89),heltab2x4(:,:,89))
  call Hloop_A_Q(ntryL,G1H2(1),23,nMT,G2H2(89),n2h2(64))
call HGT_OLR(G1H4(128),1,1,4)
call HGT_invQ_OLR(G1H4(128),2,5,4)
  call Hloop_Q_A(ntryL,G1H4(128),-8,nMT,G2H4(16),n2h4(46))
  call Hloop_QV_A(ntryL,G2H4(16),ex4(:),G2H2(90),m3h2x2(:,90),heltab2x4(:,:,90))
  call Hloop_AV_Q(ntryL,G1H4(131),ex3(:),G1H2(1),m3h2x2(:,91),heltab2x4(:,:,91))
  call Hloop_A_Q(ntryL,G1H2(1),23,nMT,G2H2(91),n2h2(65))
  call Hloop_AV_Q(ntryL,G1H4(132),ex3(:),G1H2(1),m3h2x2(:,92),heltab2x4(:,:,92))
  call Hloop_A_Q(ntryL,G1H2(1),23,nMT,G2H2(92),n2h2(66))
  call Hloop_AV_Q(ntryL,G1H4(133),ex3(:),G1H2(1),m3h2x2(:,93),heltab2x4(:,:,93))
  call Hloop_A_Q(ntryL,G1H2(1),23,nMB,G2H2(93),n2h2(67))
call HGT_OLR(G1H4(134),1,1,4)
call HGT_invQ_OLR(G1H4(134),2,5,4)
  call Hloop_Q_A(ntryL,G1H4(134),-8,nMB,G2H4(17),n2h4(47))
  call Hloop_QV_A(ntryL,G2H4(17),ex4(:),G2H2(94),m3h2x2(:,94),heltab2x4(:,:,94))
  call Hloop_AV_Q(ntryL,G1H4(137),ex3(:),G1H2(1),m3h2x2(:,95),heltab2x4(:,:,95))
  call Hloop_A_Q(ntryL,G1H2(1),23,nMB,G2H2(95),n2h2(68))
  call Hloop_AV_Q(ntryL,G1H4(138),ex3(:),G1H2(1),m3h2x2(:,96),heltab2x4(:,:,96))
  call Hloop_A_Q(ntryL,G1H2(1),23,nMB,G2H2(96),n2h2(69))
  call Hloop_AV_Q(ntryL,G1H4(139),ex3(:),G1H2(1),m3h2x2(:,97),heltab2x4(:,:,97))
  call Hloop_A_Q(ntryL,G1H2(1),23,nMT,G2H2(97),n2h2(70))
call HGT_OLR(G1H4(140),1,1,4)
call HGT_invQ_OLR(G1H4(140),2,5,4)
  call Hloop_Q_A(ntryL,G1H4(140),-8,nMT,G2H4(18),n2h4(48))
  call Hloop_QV_A(ntryL,G2H4(18),ex4(:),G2H2(98),m3h2x2(:,98),heltab2x4(:,:,98))
  call Hloop_AV_Q(ntryL,G1H4(143),ex3(:),G1H2(1),m3h2x2(:,99),heltab2x4(:,:,99))
  call Hloop_A_Q(ntryL,G1H2(1),23,nMT,G2H2(99),n2h2(71))
  call Hloop_AV_Q(ntryL,G1H4(144),ex3(:),G1H2(1),m3h2x2(:,100),heltab2x4(:,:,100))
  call Hloop_A_Q(ntryL,G1H2(1),23,nMT,G2H2(100),n2h2(72))
  call Hloop_AV_Q(ntryL,G1H4(145),ex4(:),G1H2(1),m3h2x2(:,101),heltab2x4(:,:,101))
  call Hloop_A_Q(ntryL,G1H2(1),27,nMT,G2H2(101),n2h2(73))
call HGT_OLR(G1H4(146),1,1,4)
call HGT_invQ_OLR(G1H4(146),2,5,4)
  call Hloop_Q_A(ntryL,G1H4(146),-4,nMT,G2H4(19),n2h4(49))
  call Hloop_QV_A(ntryL,G2H4(19),ex3(:),G2H2(102),m3h2x2(:,102),heltab2x4(:,:,102))
  call Hloop_AV_Q(ntryL,G1H4(149),ex4(:),G1H2(1),m3h2x2(:,103),heltab2x4(:,:,103))
  call Hloop_A_Q(ntryL,G1H2(1),27,nMT,G2H2(103),n2h2(74))
  call Hloop_AV_Q(ntryL,G1H4(150),ex4(:),G1H2(1),m3h2x2(:,104),heltab2x4(:,:,104))
  call Hloop_A_Q(ntryL,G1H2(1),27,nMT,G2H2(104),n2h2(75))
  call Hloop_AV_Q(ntryL,G1H4(151),ex4(:),G1H2(1),m3h2x2(:,105),heltab2x4(:,:,105))
  call Hloop_A_Q(ntryL,G1H2(1),27,nMT,G2H2(105),n2h2(76))
call HGT_OLR(G1H4(152),1,1,4)
call HGT_invQ_OLR(G1H4(152),2,5,4)
  call Hloop_Q_A(ntryL,G1H4(152),-4,nMT,G2H4(23),n2h4(50))
  call Hloop_QV_A(ntryL,G2H4(23),ex3(:),G2H2(106),m3h2x2(:,106),heltab2x4(:,:,106))
  call Hloop_AV_Q(ntryL,G1H4(155),ex4(:),G1H2(1),m3h2x2(:,107),heltab2x4(:,:,107))
  call Hloop_A_Q(ntryL,G1H2(1),27,nMT,G2H2(107),n2h2(77))
  call Hloop_AV_Q(ntryL,G1H4(156),ex4(:),G1H2(1),m3h2x2(:,108),heltab2x4(:,:,108))
  call Hloop_A_Q(ntryL,G1H2(1),27,nMT,G2H2(108),n2h2(78))
  call Hloop_AV_Q(ntryL,G1H4(157),ex4(:),G1H2(1),m3h2x2(:,109),heltab2x4(:,:,109))
  call Hloop_A_Q(ntryL,G1H2(1),27,nMB,G2H2(109),n2h2(79))
call HGT_OLR(G1H4(158),1,1,4)
call HGT_invQ_OLR(G1H4(158),2,5,4)
  call Hloop_Q_A(ntryL,G1H4(158),-4,nMB,G2H4(24),n2h4(51))
  call Hloop_QV_A(ntryL,G2H4(24),ex3(:),G2H2(110),m3h2x2(:,110),heltab2x4(:,:,110))
  call Hloop_AV_Q(ntryL,G1H4(161),ex4(:),G1H2(1),m3h2x2(:,111),heltab2x4(:,:,111))
  call Hloop_A_Q(ntryL,G1H2(1),27,nMB,G2H2(111),n2h2(80))
  call Hloop_AV_Q(ntryL,G1H4(162),ex4(:),G1H2(1),m3h2x2(:,112),heltab2x4(:,:,112))
  call Hloop_A_Q(ntryL,G1H2(1),27,nMB,G2H2(112),n2h2(81))
  call Hloop_AV_Q(ntryL,G1H4(163),ex4(:),G1H2(1),m3h2x2(:,113),heltab2x4(:,:,113))
  call Hloop_A_Q(ntryL,G1H2(1),27,nMT,G2H2(113),n2h2(82))
call HGT_OLR(G1H4(164),1,1,4)
call HGT_invQ_OLR(G1H4(164),2,5,4)
  call Hloop_Q_A(ntryL,G1H4(164),-4,nMT,G2H4(22),n2h4(52))
  call Hloop_QV_A(ntryL,G2H4(22),ex3(:),G2H2(114),m3h2x2(:,114),heltab2x4(:,:,114))
  call Hloop_AV_Q(ntryL,G1H4(167),ex4(:),G1H2(1),m3h2x2(:,115),heltab2x4(:,:,115))
  call Hloop_A_Q(ntryL,G1H2(1),27,nMT,G2H2(115),n2h2(83))
  call Hloop_AV_Q(ntryL,G1H4(168),ex4(:),G1H2(1),m3h2x2(:,116),heltab2x4(:,:,116))
  call Hloop_A_Q(ntryL,G1H2(1),27,nMT,G2H2(116),n2h2(84))
  call Hloop_SQ_A(ntryL,G1H4(169),ex1(:),G1H2(1),ngPbt,m3h2x2(:,117),heltab2x4(:,:,117))
  call Hloop_Q_A(ntryL,G1H2(1),23,nMB,G2H2(117),n2h2(85))
call HGT_OLR(G1H4(170),1,1,4)
call HGT_invQ_OLR(G1H4(170),2,5,4)
  call Hloop_A_Q(ntryL,G1H4(170),-8,nMB,G2H4(25),n2h4(53))
  call Hloop_AV_Q(ntryL,G2H4(25),ex4(:),G2H2(118),m3h2x2(:,118),heltab2x4(:,:,118))
  call Hloop_SQ_A(ntryL,G1H4(173),ex1(:),G1H2(1),ngPbt,m3h2x2(:,119),heltab2x4(:,:,119))
  call Hloop_Q_A(ntryL,G1H2(1),23,nMB,G2H2(119),n2h2(86))
  call Hloop_SQ_A(ntryL,G1H4(174),ex1(:),G1H2(1),ngPbt,m3h2x2(:,120),heltab2x4(:,:,120))
  call Hloop_Q_A(ntryL,G1H2(1),23,nMB,G2H2(120),n2h2(87))
  call Hloop_WQ_A(ntryL,G1H4(175),ex1(:),G1H2(1),m3h2x2(:,121),heltab2x4(:,:,121))
  call Hloop_Q_A(ntryL,G1H2(1),23,nMB,G2H2(121),n2h2(88))
call HGT_OLR(G1H4(176),1,1,4)
call HGT_invQ_OLR(G1H4(176),2,5,4)
  call Hloop_A_Q(ntryL,G1H4(176),-8,nMB,G2H4(29),n2h4(54))
  call Hloop_AV_Q(ntryL,G2H4(29),ex4(:),G2H2(122),m3h2x2(:,122),heltab2x4(:,:,122))
  call Hloop_WQ_A(ntryL,G1H4(179),ex1(:),G1H2(1),m3h2x2(:,123),heltab2x4(:,:,123))
  call Hloop_Q_A(ntryL,G1H2(1),23,nMB,G2H2(123),n2h2(89))
  call Hloop_WQ_A(ntryL,G1H4(180),ex1(:),G1H2(1),m3h2x2(:,124),heltab2x4(:,:,124))
  call Hloop_Q_A(ntryL,G1H2(1),23,nMB,G2H2(124),n2h2(90))
  call Hloop_SQ_A(ntryL,G1H4(181),ex1(:),G1H2(1),ngPbt,m3h2x2(:,125),heltab2x4(:,:,125))
  call Hloop_Q_A(ntryL,G1H2(1),27,nMB,G2H2(125),n2h2(91))
call HGT_OLR(G1H4(182),1,1,4)
call HGT_invQ_OLR(G1H4(182),2,5,4)
  call Hloop_A_Q(ntryL,G1H4(182),-4,nMB,G2H4(30),n2h4(55))
  call Hloop_AV_Q(ntryL,G2H4(30),ex3(:),G2H2(126),m3h2x2(:,126),heltab2x4(:,:,126))
  call Hloop_SQ_A(ntryL,G1H4(185),ex1(:),G1H2(1),ngPbt,m3h2x2(:,127),heltab2x4(:,:,127))
  call Hloop_Q_A(ntryL,G1H2(1),27,nMB,G2H2(127),n2h2(92))
  call Hloop_SQ_A(ntryL,G1H4(186),ex1(:),G1H2(1),ngPbt,m3h2x2(:,128),heltab2x4(:,:,128))
  call Hloop_Q_A(ntryL,G1H2(1),27,nMB,G2H2(128),n2h2(93))
  call Hloop_WQ_A(ntryL,G1H4(187),ex1(:),G1H2(1),m3h2x2(:,129),heltab2x4(:,:,129))
  call Hloop_Q_A(ntryL,G1H2(1),27,nMB,G2H2(129),n2h2(94))
call HGT_OLR(G1H4(188),1,1,4)
call HGT_invQ_OLR(G1H4(188),2,5,4)
  call Hloop_A_Q(ntryL,G1H4(188),-4,nMB,G2H4(28),n2h4(56))
  call Hloop_AV_Q(ntryL,G2H4(28),ex3(:),G2H2(130),m3h2x2(:,130),heltab2x4(:,:,130))
  call Hloop_WQ_A(ntryL,G1H4(191),ex1(:),G1H2(1),m3h2x2(:,131),heltab2x4(:,:,131))
  call Hloop_Q_A(ntryL,G1H2(1),27,nMB,G2H2(131),n2h2(95))
  call Hloop_WQ_A(ntryL,G1H4(192),ex1(:),G1H2(1),m3h2x2(:,132),heltab2x4(:,:,132))
  call Hloop_Q_A(ntryL,G1H2(1),27,nMB,G2H2(132),n2h2(96))
  call Hloop_SA_Q(ntryL,G1H4(193),ex2(:),G1H2(1),ngPtb,m3h2x2(:,133),heltab2x4(:,:,133))
  call Hloop_A_Q(ntryL,G1H2(1),23,nMB,G2H2(133),n2h2(97))
call HGT_OLR(G1H4(194),1,1,4)
call HGT_invQ_OLR(G1H4(194),2,5,4)
  call Hloop_Q_A(ntryL,G1H4(194),-8,nMB,G2H4(31),n2h4(57))
  call Hloop_QV_A(ntryL,G2H4(31),ex4(:),G2H2(134),m3h2x2(:,134),heltab2x4(:,:,134))
  call Hloop_SA_Q(ntryL,G1H4(197),ex2(:),G1H2(1),ngPtb,m3h2x2(:,135),heltab2x4(:,:,135))
  call Hloop_A_Q(ntryL,G1H2(1),23,nMB,G2H2(135),n2h2(98))
  call Hloop_SA_Q(ntryL,G1H4(198),ex2(:),G1H2(1),ngPtb,m3h2x2(:,136),heltab2x4(:,:,136))
  call Hloop_A_Q(ntryL,G1H2(1),23,nMB,G2H2(136),n2h2(99))
  call Hloop_WA_Q(ntryL,G1H4(199),ex2(:),G1H2(1),m3h2x2(:,137),heltab2x4(:,:,137))
  call Hloop_A_Q(ntryL,G1H2(1),23,nMB,G2H2(137),n2h2(100))
call HGT_OLR(G1H4(200),1,1,4)
call HGT_invQ_OLR(G1H4(200),2,5,4)
  call Hloop_Q_A(ntryL,G1H4(200),-8,nMB,G2H4(35),n2h4(58))
  call Hloop_QV_A(ntryL,G2H4(35),ex4(:),G2H2(138),m3h2x2(:,138),heltab2x4(:,:,138))
  call Hloop_WA_Q(ntryL,G1H4(203),ex2(:),G1H2(1),m3h2x2(:,139),heltab2x4(:,:,139))
  call Hloop_A_Q(ntryL,G1H2(1),23,nMB,G2H2(139),n2h2(101))
  call Hloop_WA_Q(ntryL,G1H4(204),ex2(:),G1H2(1),m3h2x2(:,140),heltab2x4(:,:,140))
  call Hloop_A_Q(ntryL,G1H2(1),23,nMB,G2H2(140),n2h2(102))
  call Hloop_SV_T(ntryL,G1H4(205),21,ex4(:),8,G2H2(141),m3h2x2(:,141),heltab2x4(:,:,141))
call HGT_OLR(G1H4(206),1,1,4)
call HGT_invQ_OLR(G1H4(206),2,5,4)
  call Hloop_Q_A(ntryL,G1H4(206),-2,nMB,G2H4(36),n2h4(59))
  call Hloop_QA_S(ntryL,G2H4(36),ex2(:),G2H2(142),ngPtb,m3h2x2(:,142),heltab2x4(:,:,142))
  call Hloop_SV_T(ntryL,G1H4(209),21,ex4(:),8,G2H2(143),m3h2x2(:,143),heltab2x4(:,:,143))
  call Hloop_SV_T(ntryL,G1H4(210),21,ex4(:),8,G2H2(144),m3h2x2(:,144),heltab2x4(:,:,144))
  call Hloop_UW_V(ntryL,G1H4(211),21,ex4(:),8,G2H2(145),m3h2x2(:,145),heltab2x4(:,:,145))
call HGT_OLR(G1H4(212),1,1,4)
call HGT_invQ_OLR(G1H4(212),2,5,4)
  call Hloop_Q_A(ntryL,G1H4(212),-2,nMB,G2H4(34),n2h4(60))
  call Hloop_QA_W(ntryL,G2H4(34),ex2(:),G2H2(146),m3h2x2(:,146),heltab2x4(:,:,146))
  call Hloop_UW_V(ntryL,G1H4(215),21,ex4(:),8,G2H2(147),m3h2x2(:,147),heltab2x4(:,:,147))
  call Hloop_UW_V(ntryL,G1H4(216),21,ex4(:),8,G2H2(148),m3h2x2(:,148),heltab2x4(:,:,148))
  call Hloop_SA_Q(ntryL,G1H4(217),ex2(:),G1H2(1),ngPtb,m3h2x2(:,149),heltab2x4(:,:,149))
  call Hloop_A_Q(ntryL,G1H2(1),27,nMB,G2H2(149),n2h2(103))
call HGT_OLR(G1H4(218),1,1,4)
call HGT_invQ_OLR(G1H4(218),2,5,4)
  call Hloop_Q_A(ntryL,G1H4(218),-4,nMB,G2H4(37),n2h4(61))
  call Hloop_QV_A(ntryL,G2H4(37),ex3(:),G2H2(150),m3h2x2(:,150),heltab2x4(:,:,150))
  call Hloop_SA_Q(ntryL,G1H4(221),ex2(:),G1H2(1),ngPtb,m3h2x2(:,151),heltab2x4(:,:,151))
  call Hloop_A_Q(ntryL,G1H2(1),27,nMB,G2H2(151),n2h2(104))
  call Hloop_SA_Q(ntryL,G1H4(222),ex2(:),G1H2(1),ngPtb,m3h2x2(:,152),heltab2x4(:,:,152))
  call Hloop_A_Q(ntryL,G1H2(1),27,nMB,G2H2(152),n2h2(105))
  call Hloop_WA_Q(ntryL,G1H4(223),ex2(:),G1H2(1),m3h2x2(:,153),heltab2x4(:,:,153))
  call Hloop_A_Q(ntryL,G1H2(1),27,nMB,G2H2(153),n2h2(106))
call HGT_OLR(G1H4(224),1,1,4)
call HGT_invQ_OLR(G1H4(224),2,5,4)
  call Hloop_Q_A(ntryL,G1H4(224),-4,nMB,G2H4(38),n2h4(62))
  call Hloop_QV_A(ntryL,G2H4(38),ex3(:),G2H2(154),m3h2x2(:,154),heltab2x4(:,:,154))
  call Hloop_WA_Q(ntryL,G1H4(227),ex2(:),G1H2(1),m3h2x2(:,155),heltab2x4(:,:,155))
  call Hloop_A_Q(ntryL,G1H2(1),27,nMB,G2H2(155),n2h2(107))
  call Hloop_WA_Q(ntryL,G1H4(228),ex2(:),G1H2(1),m3h2x2(:,156),heltab2x4(:,:,156))
  call Hloop_A_Q(ntryL,G1H2(1),27,nMB,G2H2(156),n2h2(108))
  call Hloop_SV_T(ntryL,G1H4(229),25,ex3(:),4,G2H2(157),m3h2x2(:,157),heltab2x4(:,:,157))
call HGT_OLR(G1H4(230),1,1,4)
call HGT_invQ_OLR(G1H4(230),2,5,4)
  call Hloop_Q_A(ntryL,G1H4(230),-2,nMB,G2H4(39),n2h4(63))
  call Hloop_QA_S(ntryL,G2H4(39),ex2(:),G2H2(158),ngPtb,m3h2x2(:,158),heltab2x4(:,:,158))
  call Hloop_SV_T(ntryL,G1H4(233),25,ex3(:),4,G2H2(159),m3h2x2(:,159),heltab2x4(:,:,159))
  call Hloop_SV_T(ntryL,G1H4(234),25,ex3(:),4,G2H2(160),m3h2x2(:,160),heltab2x4(:,:,160))
  call Hloop_UW_V(ntryL,G1H4(235),25,ex3(:),4,G2H2(161),m3h2x2(:,161),heltab2x4(:,:,161))
call HGT_OLR(G1H4(236),1,1,4)
call HGT_invQ_OLR(G1H4(236),2,5,4)
  call Hloop_Q_A(ntryL,G1H4(236),-2,nMB,G2H4(40),n2h4(64))
  call Hloop_QA_W(ntryL,G2H4(40),ex2(:),G2H2(162),m3h2x2(:,162),heltab2x4(:,:,162))
  call Hloop_UW_V(ntryL,G1H4(239),25,ex3(:),4,G2H2(163),m3h2x2(:,163),heltab2x4(:,:,163))
  call Hloop_UW_V(ntryL,G1H4(240),25,ex3(:),4,G2H2(164),m3h2x2(:,164),heltab2x4(:,:,164))
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(141),[G2H2(1)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(145),[G2H2(2)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(157),[G2H2(3)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(161),[G2H2(4)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(21),[G2H2(9)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(24),[G2H2(12)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(25),[G2H2(13)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(28),[G2H2(16)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(61),[G2H2(49)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(64),[G2H2(52)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(65),[G2H2(53)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(68),[G2H2(56)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(121),[G2H2(117)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(124),[G2H2(120)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(129),[G2H2(125)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(132),[G2H2(128)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(137),[G2H2(133)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(140),[G2H2(136)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(153),[G2H2(149)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(156),[G2H2(152)])
  call Hotf_5pt_reduction(G2H2(141),RedSet_5(10),mass5set(:,10),  & 
G1H2(1),G1H2(2),G1H2(3),G1H2(4),G1H2(5),G1H2(6),2)
  call HG1shiftOLR(G1H2(2),2,2)
  call Hotf_5pt_reduction(G2H2(145),RedSet_5(10),mass5set(:,10),  & 
G1H2(7),G1H2(8),G1H2(9),G1H2(10),G1H2(11),G1H2(12),2)
  call HG1shiftOLR(G1H2(8),2,2)
  call Hotf_5pt_reduction(G2H2(157),RedSet_5(12),mass5set(:,10),  & 
G1H2(13),G1H2(14),G1H2(15),G1H2(16),G1H2(17),G1H2(18),2)
  call HG1shiftOLR(G1H2(14),2,2)
  call Hotf_5pt_reduction(G2H2(161),RedSet_5(12),mass5set(:,10),  & 
G1H2(19),G1H2(20),G1H2(21),G1H2(22),G1H2(23),G1H2(24),2)
  call HG1shiftOLR(G1H2(20),2,2)
  call Hotf_5pt_reduction(G2H2(5),RedSet_5(1),mass5set(:,1),  & 
G1H2(25),G1H2(26),G1H2(27),G1H2(28),G1H2(29),G1H2(30),2)
  call HG1shiftOLR(G1H2(26),8,2)
  call Hotf_4pt_reduction(G2H2(8),RedSet_4(1),mass4set(:,1),  & 
G1H2(31),G1H2(32),G1H2(33),G1H2(34),G1H2(35),2)
  call HG1shiftOLR(G1H2(32),10,2)
  call Hotf_5pt_reduction(G2H2(21),RedSet_5(1),mass5set(:,2),  & 
G1H2(36),G1H2(37),G1H2(38),G1H2(39),G1H2(40),G1H2(41),2)
  call HG1shiftOLR(G1H2(37),8,2)
  call Hotf_4pt_reduction(G2H2(24),RedSet_4(1),mass4set(:,2),  & 
G1H2(42),G1H2(43),G1H2(44),G1H2(45),G1H2(46),2)
  call HG1shiftOLR(G1H2(43),10,2)
  call Hotf_5pt_reduction(G2H2(25),RedSet_5(1),mass5set(:,3),  & 
G1H2(47),G1H2(48),G1H2(49),G1H2(50),G1H2(51),G1H2(52),2)
  call HG1shiftOLR(G1H2(48),8,2)
  call Hotf_4pt_reduction(G2H2(28),RedSet_4(1),mass4set(:,3),  & 
G1H2(53),G1H2(54),G1H2(55),G1H2(56),G1H2(57),2)
  call HG1shiftOLR(G1H2(54),10,2)
  call Hotf_5pt_reduction(G2H2(17),RedSet_5(1),mass5set(:,4),  & 
G1H2(58),G1H2(59),G1H2(60),G1H2(61),G1H2(62),G1H2(63),2)
  call HG1shiftOLR(G1H2(59),8,2)
  call Hotf_4pt_reduction(G2H2(20),RedSet_4(1),mass4set(:,4),  & 
G1H2(64),G1H2(65),G1H2(66),G1H2(67),G1H2(68),2)
  call HG1shiftOLR(G1H2(65),10,2)
  call Hotf_5pt_reduction(G2H2(29),RedSet_5(2),mass5set(:,5),  & 
G1H2(69),G1H2(70),G1H2(71),G1H2(72),G1H2(73),G1H2(74),2)
  call HG1shiftOLR(G1H2(70),8,2)
  call Hotf_4pt_reduction(G2H2(32),RedSet_4(2),mass4set(:,5),  & 
G1H2(75),G1H2(76),G1H2(77),G1H2(78),G1H2(79),2)
  call HG1shiftOLR(G1H2(76),12,2)
  call Hotf_5pt_reduction(G2H2(33),RedSet_5(2),mass5set(:,6),  & 
G1H2(80),G1H2(81),G1H2(82),G1H2(83),G1H2(84),G1H2(85),2)
  call HG1shiftOLR(G1H2(81),8,2)
  call Hotf_4pt_reduction(G2H2(36),RedSet_4(2),mass4set(:,6),  & 
G1H2(86),G1H2(87),G1H2(88),G1H2(89),G1H2(90),2)
  call HG1shiftOLR(G1H2(87),12,2)
  call Hotf_5pt_reduction(G2H2(37),RedSet_5(2),mass5set(:,7),  & 
G1H2(91),G1H2(92),G1H2(93),G1H2(94),G1H2(95),G1H2(96),2)
  call HG1shiftOLR(G1H2(92),8,2)
  call Hotf_4pt_reduction(G2H2(40),RedSet_4(2),mass4set(:,7),  & 
G1H2(97),G1H2(98),G1H2(99),G1H2(100),G1H2(101),2)
  call HG1shiftOLR(G1H2(98),12,2)
  call Hotf_5pt_reduction(G2H2(41),RedSet_5(2),mass5set(:,8),  & 
G1H2(102),G1H2(103),G1H2(104),G1H2(105),G1H2(106),G1H2(107),2)
  call HG1shiftOLR(G1H2(103),8,2)
  call Hotf_4pt_reduction(G2H2(44),RedSet_4(2),mass4set(:,8),  & 
G1H2(108),G1H2(109),G1H2(110),G1H2(111),G1H2(112),2)
  call HG1shiftOLR(G1H2(109),12,2)
  call Hotf_5pt_reduction(G2H2(45),RedSet_5(3),mass5set(:,1),  & 
G1H2(113),G1H2(114),G1H2(115),G1H2(116),G1H2(117),G1H2(118),2)
  call HG1shiftOLR(G1H2(114),8,2)
  call Hotf_4pt_reduction(G2H2(48),RedSet_4(3),mass4set(:,1),  & 
G1H2(119),G1H2(120),G1H2(121),G1H2(122),G1H2(123),2)
  call HG1shiftOLR(G1H2(120),9,2)
  call Hotf_5pt_reduction(G2H2(61),RedSet_5(3),mass5set(:,2),  & 
G1H2(124),G1H2(125),G1H2(126),G1H2(127),G1H2(128),G1H2(129),2)
  call HG1shiftOLR(G1H2(125),8,2)
  call Hotf_4pt_reduction(G2H2(64),RedSet_4(3),mass4set(:,2),  & 
G1H2(130),G1H2(131),G1H2(132),G1H2(133),G1H2(134),2)
  call HG1shiftOLR(G1H2(131),9,2)
  call Hotf_5pt_reduction(G2H2(65),RedSet_5(3),mass5set(:,3),  & 
G1H2(135),G1H2(136),G1H2(137),G1H2(138),G1H2(139),G1H2(140),2)
  call HG1shiftOLR(G1H2(136),8,2)
  call Hotf_4pt_reduction(G2H2(68),RedSet_4(3),mass4set(:,3),  & 
G1H2(141),G1H2(142),G1H2(143),G1H2(144),G1H2(145),2)
  call HG1shiftOLR(G1H2(142),9,2)
  call Hotf_5pt_reduction(G2H2(57),RedSet_5(3),mass5set(:,4),  & 
G1H2(146),G1H2(147),G1H2(148),G1H2(149),G1H2(150),G1H2(151),2)
  call HG1shiftOLR(G1H2(147),8,2)
  call Hotf_4pt_reduction(G2H2(60),RedSet_4(3),mass4set(:,4),  & 
G1H2(152),G1H2(153),G1H2(154),G1H2(155),G1H2(156),2)
  call HG1shiftOLR(G1H2(153),9,2)
  call Hotf_5pt_reduction(G2H2(69),RedSet_5(4),mass5set(:,5),  & 
G1H2(157),G1H2(158),G1H2(159),G1H2(160),G1H2(161),G1H2(162),2)
  call HG1shiftOLR(G1H2(158),4,2)
  call Hotf_4pt_reduction(G2H2(72),RedSet_4(2),mass4set(:,5),  & 
G1H2(163),G1H2(164),G1H2(165),G1H2(166),G1H2(167),2)
  call HG1shiftOLR(G1H2(164),12,2)
  call Hotf_5pt_reduction(G2H2(73),RedSet_5(4),mass5set(:,6),  & 
G1H2(168),G1H2(169),G1H2(170),G1H2(171),G1H2(172),G1H2(173),2)
  call HG1shiftOLR(G1H2(169),4,2)
  call Hotf_4pt_reduction(G2H2(76),RedSet_4(2),mass4set(:,6),  & 
G1H2(174),G1H2(175),G1H2(176),G1H2(177),G1H2(178),2)
  call HG1shiftOLR(G1H2(175),12,2)
  call Hotf_5pt_reduction(G2H2(77),RedSet_5(4),mass5set(:,7),  & 
G1H2(179),G1H2(180),G1H2(181),G1H2(182),G1H2(183),G1H2(184),2)
  call HG1shiftOLR(G1H2(180),4,2)
  call Hotf_4pt_reduction(G2H2(80),RedSet_4(2),mass4set(:,7),  & 
G1H2(185),G1H2(186),G1H2(187),G1H2(188),G1H2(189),2)
  call HG1shiftOLR(G1H2(186),12,2)
  call Hotf_5pt_reduction(G2H2(81),RedSet_5(4),mass5set(:,8),  & 
G1H2(190),G1H2(191),G1H2(192),G1H2(193),G1H2(194),G1H2(195),2)
  call HG1shiftOLR(G1H2(191),4,2)
  call Hotf_4pt_reduction(G2H2(84),RedSet_4(2),mass4set(:,8),  & 
G1H2(196),G1H2(197),G1H2(198),G1H2(199),G1H2(200),2)
  call HG1shiftOLR(G1H2(197),12,2)
  call Hotf_5pt_reduction(G2H2(85),RedSet_5(5),mass5set(:,5),  & 
G1H2(201),G1H2(202),G1H2(203),G1H2(204),G1H2(205),G1H2(206),2)
  call HG1shiftOLR(G1H2(202),8,2)
  call Hotf_4pt_reduction(G2H2(88),RedSet_4(4),mass4set(:,5),  & 
G1H2(207),G1H2(208),G1H2(209),G1H2(210),G1H2(211),2)
  call HG1shiftOLR(G1H2(208),12,2)
  call Hotf_5pt_reduction(G2H2(89),RedSet_5(5),mass5set(:,6),  & 
G1H2(212),G1H2(213),G1H2(214),G1H2(215),G1H2(216),G1H2(217),2)
  call HG1shiftOLR(G1H2(213),8,2)
  call Hotf_4pt_reduction(G2H2(92),RedSet_4(4),mass4set(:,6),  & 
G1H2(218),G1H2(219),G1H2(220),G1H2(221),G1H2(222),2)
  call HG1shiftOLR(G1H2(219),12,2)
  call Hotf_5pt_reduction(G2H2(93),RedSet_5(5),mass5set(:,7),  & 
G1H2(223),G1H2(224),G1H2(225),G1H2(226),G1H2(227),G1H2(228),2)
  call HG1shiftOLR(G1H2(224),8,2)
  call Hotf_4pt_reduction(G2H2(96),RedSet_4(4),mass4set(:,7),  & 
G1H2(229),G1H2(230),G1H2(231),G1H2(232),G1H2(233),2)
  call HG1shiftOLR(G1H2(230),12,2)
  call Hotf_5pt_reduction(G2H2(97),RedSet_5(5),mass5set(:,8),  & 
G1H2(234),G1H2(235),G1H2(236),G1H2(237),G1H2(238),G1H2(239),2)
  call HG1shiftOLR(G1H2(235),8,2)
  call Hotf_4pt_reduction(G2H2(100),RedSet_4(4),mass4set(:,8),  & 
G1H2(240),G1H2(241),G1H2(242),G1H2(243),G1H2(244),2)
  call HG1shiftOLR(G1H2(241),12,2)
  call Hotf_5pt_reduction(G2H2(101),RedSet_5(6),mass5set(:,5),  & 
G1H2(245),G1H2(246),G1H2(247),G1H2(248),G1H2(249),G1H2(250),2)
  call HG1shiftOLR(G1H2(246),4,2)
  call Hotf_4pt_reduction(G2H2(104),RedSet_4(4),mass4set(:,5),  & 
G1H2(251),G1H2(252),G1H2(253),G1H2(254),G1H2(255),2)
  call HG1shiftOLR(G1H2(252),12,2)
  call Hotf_5pt_reduction(G2H2(105),RedSet_5(6),mass5set(:,6),  & 
G1H2(256),G1H2(257),G1H2(258),G1H2(259),G1H2(260),G1H2(261),2)
  call HG1shiftOLR(G1H2(257),4,2)
  call Hotf_4pt_reduction(G2H2(108),RedSet_4(4),mass4set(:,6),  & 
G1H2(262),G1H2(263),G1H2(264),G1H2(265),G1H2(266),2)
  call HG1shiftOLR(G1H2(263),12,2)
  call Hotf_5pt_reduction(G2H2(109),RedSet_5(6),mass5set(:,7),  & 
G1H2(267),G1H2(268),G1H2(269),G1H2(270),G1H2(271),G1H2(272),2)
  call HG1shiftOLR(G1H2(268),4,2)
  call Hotf_4pt_reduction(G2H2(112),RedSet_4(4),mass4set(:,7),  & 
G1H2(273),G1H2(274),G1H2(275),G1H2(276),G1H2(277),2)
  call HG1shiftOLR(G1H2(274),12,2)
  call Hotf_5pt_reduction(G2H2(113),RedSet_5(6),mass5set(:,8),  & 
G1H2(278),G1H2(279),G1H2(280),G1H2(281),G1H2(282),G1H2(283),2)
  call HG1shiftOLR(G1H2(279),4,2)
  call Hotf_4pt_reduction(G2H2(116),RedSet_4(4),mass4set(:,8),  & 
G1H2(284),G1H2(285),G1H2(286),G1H2(287),G1H2(288),2)
  call HG1shiftOLR(G1H2(285),12,2)
  call Hotf_5pt_reduction(G2H2(121),RedSet_5(7),mass5set(:,9),  & 
G1H2(289),G1H2(290),G1H2(291),G1H2(292),G1H2(293),G1H2(294),2)
  call HG1shiftOLR(G1H2(290),8,2)
  call Hotf_4pt_reduction(G2H2(124),RedSet_4(5),mass4set(:,9),  & 
G1H2(295),G1H2(296),G1H2(297),G1H2(298),G1H2(299),2)
  call HG1shiftOLR(G1H2(296),9,2)
  call Hotf_5pt_reduction(G2H2(129),RedSet_5(8),mass5set(:,9),  & 
G1H2(300),G1H2(301),G1H2(302),G1H2(303),G1H2(304),G1H2(305),2)
  call HG1shiftOLR(G1H2(301),4,2)
  call Hotf_4pt_reduction(G2H2(132),RedSet_4(6),mass4set(:,9),  & 
G1H2(306),G1H2(307),G1H2(308),G1H2(309),G1H2(310),2)
  call HG1shiftOLR(G1H2(307),5,2)
  call Hotf_5pt_reduction(G2H2(137),RedSet_5(9),mass5set(:,9),  & 
G1H2(311),G1H2(312),G1H2(313),G1H2(314),G1H2(315),G1H2(316),2)
  call HG1shiftOLR(G1H2(312),8,2)
  call Hotf_4pt_reduction(G2H2(140),RedSet_4(7),mass4set(:,9),  & 
G1H2(317),G1H2(318),G1H2(319),G1H2(320),G1H2(321),2)
  call HG1shiftOLR(G1H2(318),10,2)
  call Hotf_4pt_reduction(G2H2(144),RedSet_4(7),mass4set(:,9),  & 
G1H2(322),G1H2(323),G1H2(324),G1H2(325),G1H2(326),2)
  call HG1shiftOLR(G1H2(323),10,2)
  call Hotf_4pt_reduction(G2H2(148),RedSet_4(7),mass4set(:,9),  & 
G1H2(327),G1H2(328),G1H2(329),G1H2(330),G1H2(331),2)
  call HG1shiftOLR(G1H2(328),10,2)
  call Hotf_5pt_reduction(G2H2(153),RedSet_5(11),mass5set(:,9),  & 
G1H2(332),G1H2(333),G1H2(334),G1H2(335),G1H2(336),G1H2(337),2)
  call HG1shiftOLR(G1H2(333),4,2)
  call Hotf_4pt_reduction(G2H2(156),RedSet_4(8),mass4set(:,9),  & 
G1H2(338),G1H2(339),G1H2(340),G1H2(341),G1H2(342),2)
  call HG1shiftOLR(G1H2(339),6,2)
  call Hotf_4pt_reduction(G2H2(160),RedSet_4(8),mass4set(:,9),  & 
G1H2(343),G1H2(344),G1H2(345),G1H2(346),G1H2(347),2)
  call HG1shiftOLR(G1H2(344),6,2)
  call Hotf_4pt_reduction(G2H2(164),RedSet_4(8),mass4set(:,9),  & 
G1H2(348),G1H2(349),G1H2(350),G1H2(351),G1H2(352),2)
  call HG1shiftOLR(G1H2(349),6,2)
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(322),[G1H2(6)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(327),[G1H2(12)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(343),[G1H2(18)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(348),[G1H2(24)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(31),[G1H2(30)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(42),[G1H2(41)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(53),[G1H2(52)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(64),[G1H2(63)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(75),[G1H2(74)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(86),[G1H2(85)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(97),[G1H2(96)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(108),[G1H2(107)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(119),[G1H2(118)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(130),[G1H2(129)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(141),[G1H2(140)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(152),[G1H2(151)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(163),[G1H2(162)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(174),[G1H2(173)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(185),[G1H2(184)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(196),[G1H2(195)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(207),[G1H2(206)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(218),[G1H2(217)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(229),[G1H2(228)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(240),[G1H2(239)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(251),[G1H2(250)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(262),[G1H2(261)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(273),[G1H2(272)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(284),[G1H2(283)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(295),[G1H2(294)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(306),[G1H2(305)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(317),[G1H2(316)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(338),[G1H2(337)])
  call Hloop_SA_Q(ntryL,G1H2(1),ex2(:),G1H1(1),ngPtb,m3h2x1(:,1),heltab2x2(:,:,1))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,nMB,G2tensor(1),n2h1(1))
  call Hloop_SA_Q(ntryL,G1H2(2),ex2(:),G1H1(1),ngPtb,m3h2x1(:,2),heltab2x2(:,:,2))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),2,nMB,G2tensor(2),n2h1(2))
  call Hloop_SA_Q(ntryL,G1H2(322),ex2(:),G1H1(1),ngPtb,m3h2x1(:,3),heltab2x2(:,:,3))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,nMB,G2tensor(3),n2h1(3))
  call Hloop_WA_Q(ntryL,G1H2(7),ex2(:),G1H1(1),m3h2x1(:,4),heltab2x2(:,:,4))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,nMB,G2tensor(4),n2h1(4))
  call Hloop_WA_Q(ntryL,G1H2(8),ex2(:),G1H1(1),m3h2x1(:,5),heltab2x2(:,:,5))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),2,nMB,G2tensor(5),n2h1(5))
  call Hloop_WA_Q(ntryL,G1H2(327),ex2(:),G1H1(1),m3h2x1(:,6),heltab2x2(:,:,6))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,nMB,G2tensor(6),n2h1(6))
  call Hloop_SA_Q(ntryL,G1H2(13),ex2(:),G1H1(1),ngPtb,m3h2x1(:,7),heltab2x2(:,:,7))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,nMB,G2tensor(7),n2h1(7))
  call Hloop_SA_Q(ntryL,G1H2(14),ex2(:),G1H1(1),ngPtb,m3h2x1(:,8),heltab2x2(:,:,8))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),2,nMB,G2tensor(8),n2h1(8))
  call Hloop_SA_Q(ntryL,G1H2(343),ex2(:),G1H1(1),ngPtb,m3h2x1(:,9),heltab2x2(:,:,9))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,nMB,G2tensor(9),n2h1(9))
  call Hloop_WA_Q(ntryL,G1H2(19),ex2(:),G1H1(1),m3h2x1(:,10),heltab2x2(:,:,10))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,nMB,G2tensor(10),n2h1(10))
  call Hloop_WA_Q(ntryL,G1H2(20),ex2(:),G1H1(1),m3h2x1(:,11),heltab2x2(:,:,11))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),2,nMB,G2tensor(11),n2h1(11))
  call Hloop_WA_Q(ntryL,G1H2(348),ex2(:),G1H1(1),m3h2x1(:,12),heltab2x2(:,:,12))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,nMB,G2tensor(12),n2h1(12))
  call Hloop_AV_Q(ntryL,G1H2(25),ex4(:),G1H1(1),m3h2x1(:,13),heltab2x2(:,:,13))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,nMT,G2tensor(13),n2h1(13))
  call Hloop_AV_Q(ntryL,G1H2(26),ex4(:),G1H1(1),m3h2x1(:,14),heltab2x2(:,:,14))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),8,nMT,G2tensor(14),n2h1(14))
  call Hloop_AV_Q(ntryL,G1H2(31),ex4(:),G1H1(1),m3h2x1(:,15),heltab2x2(:,:,15))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,nMT,G2tensor(15),n2h1(15))
  call Hloop_AV_Q(ntryL,G1H2(32),ex4(:),G1H1(1),m3h2x1(:,16),heltab2x2(:,:,16))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),10,nMT,G2tensor(16),n2h1(16))
  call Hloop_AV_Q(ntryL,G1H2(36),ex4(:),G1H1(1),m3h2x1(:,17),heltab2x2(:,:,17))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,nMT,G2tensor(17),n2h1(17))
  call Hloop_AV_Q(ntryL,G1H2(37),ex4(:),G1H1(1),m3h2x1(:,18),heltab2x2(:,:,18))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),8,nMT,G2tensor(18),n2h1(18))
  call Hloop_AV_Q(ntryL,G1H2(42),ex4(:),G1H1(1),m3h2x1(:,19),heltab2x2(:,:,19))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,nMT,G2tensor(19),n2h1(19))
  call Hloop_AV_Q(ntryL,G1H2(43),ex4(:),G1H1(1),m3h2x1(:,20),heltab2x2(:,:,20))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),10,nMT,G2tensor(20),n2h1(20))
  call Hloop_AV_Q(ntryL,G1H2(47),ex4(:),G1H1(1),m3h2x1(:,21),heltab2x2(:,:,21))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,nMB,G2tensor(21),n2h1(21))
  call Hloop_AV_Q(ntryL,G1H2(48),ex4(:),G1H1(1),m3h2x1(:,22),heltab2x2(:,:,22))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),8,nMB,G2tensor(22),n2h1(22))
  call Hloop_AV_Q(ntryL,G1H2(53),ex4(:),G1H1(1),m3h2x1(:,23),heltab2x2(:,:,23))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,nMB,G2tensor(23),n2h1(23))
  call Hloop_AV_Q(ntryL,G1H2(54),ex4(:),G1H1(1),m3h2x1(:,24),heltab2x2(:,:,24))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),10,nMB,G2tensor(24),n2h1(24))
  call Hloop_AV_Q(ntryL,G1H2(58),ex4(:),G1H1(1),m3h2x1(:,25),heltab2x2(:,:,25))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,nMT,G2tensor(25),n2h1(25))
  call Hloop_AV_Q(ntryL,G1H2(59),ex4(:),G1H1(1),m3h2x1(:,26),heltab2x2(:,:,26))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),8,nMT,G2tensor(26),n2h1(26))
  call Hloop_AV_Q(ntryL,G1H2(64),ex4(:),G1H1(1),m3h2x1(:,27),heltab2x2(:,:,27))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,nMT,G2tensor(27),n2h1(27))
  call Hloop_AV_Q(ntryL,G1H2(65),ex4(:),G1H1(1),m3h2x1(:,28),heltab2x2(:,:,28))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),10,nMT,G2tensor(28),n2h1(28))
  call Hloop_QV_A(ntryL,G1H2(69),ex4(:),G1H1(1),m3h2x1(:,29),heltab2x2(:,:,29))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,nMT,G2tensor(29),n2h1(29))
  call Hloop_QV_A(ntryL,G1H2(70),ex4(:),G1H1(1),m3h2x1(:,30),heltab2x2(:,:,30))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),8,nMT,G2tensor(30),n2h1(30))
  call Hloop_QV_A(ntryL,G1H2(75),ex4(:),G1H1(1),m3h2x1(:,31),heltab2x2(:,:,31))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,nMT,G2tensor(31),n2h1(31))
  call Hloop_QV_A(ntryL,G1H2(76),ex4(:),G1H1(1),m3h2x1(:,32),heltab2x2(:,:,32))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),12,nMT,G2tensor(32),n2h1(32))
  call Hloop_QV_A(ntryL,G1H2(80),ex4(:),G1H1(1),m3h2x1(:,33),heltab2x2(:,:,33))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,nMT,G2tensor(33),n2h1(33))
  call Hloop_QV_A(ntryL,G1H2(81),ex4(:),G1H1(1),m3h2x1(:,34),heltab2x2(:,:,34))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),8,nMT,G2tensor(34),n2h1(34))
  call Hloop_QV_A(ntryL,G1H2(86),ex4(:),G1H1(1),m3h2x1(:,35),heltab2x2(:,:,35))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,nMT,G2tensor(35),n2h1(35))
  call Hloop_QV_A(ntryL,G1H2(87),ex4(:),G1H1(1),m3h2x1(:,36),heltab2x2(:,:,36))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),12,nMT,G2tensor(36),n2h1(36))
  call Hloop_QV_A(ntryL,G1H2(91),ex4(:),G1H1(1),m3h2x1(:,37),heltab2x2(:,:,37))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,nMB,G2tensor(37),n2h1(37))
  call Hloop_QV_A(ntryL,G1H2(92),ex4(:),G1H1(1),m3h2x1(:,38),heltab2x2(:,:,38))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),8,nMB,G2tensor(38),n2h1(38))
  call Hloop_QV_A(ntryL,G1H2(97),ex4(:),G1H1(1),m3h2x1(:,39),heltab2x2(:,:,39))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,nMB,G2tensor(39),n2h1(39))
  call Hloop_QV_A(ntryL,G1H2(98),ex4(:),G1H1(1),m3h2x1(:,40),heltab2x2(:,:,40))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),12,nMB,G2tensor(40),n2h1(40))
  call Hloop_QV_A(ntryL,G1H2(102),ex4(:),G1H1(1),m3h2x1(:,41),heltab2x2(:,:,41))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,nMT,G2tensor(41),n2h1(41))
  call Hloop_QV_A(ntryL,G1H2(103),ex4(:),G1H1(1),m3h2x1(:,42),heltab2x2(:,:,42))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),8,nMT,G2tensor(42),n2h1(42))
  call Hloop_QV_A(ntryL,G1H2(108),ex4(:),G1H1(1),m3h2x1(:,43),heltab2x2(:,:,43))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,nMT,G2tensor(43),n2h1(43))
  call Hloop_QV_A(ntryL,G1H2(109),ex4(:),G1H1(1),m3h2x1(:,44),heltab2x2(:,:,44))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),12,nMT,G2tensor(44),n2h1(44))
  call Hloop_QV_A(ntryL,G1H2(113),ex4(:),G1H1(1),m3h2x1(:,45),heltab2x2(:,:,45))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,nMT,G2tensor(45),n2h1(45))
  call Hloop_QV_A(ntryL,G1H2(114),ex4(:),G1H1(1),m3h2x1(:,46),heltab2x2(:,:,46))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),8,nMT,G2tensor(46),n2h1(46))
  call Hloop_QV_A(ntryL,G1H2(119),ex4(:),G1H1(1),m3h2x1(:,47),heltab2x2(:,:,47))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,nMT,G2tensor(47),n2h1(47))
  call Hloop_QV_A(ntryL,G1H2(120),ex4(:),G1H1(1),m3h2x1(:,48),heltab2x2(:,:,48))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),9,nMT,G2tensor(48),n2h1(48))
  call Hloop_QV_A(ntryL,G1H2(124),ex4(:),G1H1(1),m3h2x1(:,49),heltab2x2(:,:,49))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,nMT,G2tensor(49),n2h1(49))
  call Hloop_QV_A(ntryL,G1H2(125),ex4(:),G1H1(1),m3h2x1(:,50),heltab2x2(:,:,50))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),8,nMT,G2tensor(50),n2h1(50))
  call Hloop_QV_A(ntryL,G1H2(130),ex4(:),G1H1(1),m3h2x1(:,51),heltab2x2(:,:,51))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,nMT,G2tensor(51),n2h1(51))
  call Hloop_QV_A(ntryL,G1H2(131),ex4(:),G1H1(1),m3h2x1(:,52),heltab2x2(:,:,52))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),9,nMT,G2tensor(52),n2h1(52))
  call Hloop_QV_A(ntryL,G1H2(135),ex4(:),G1H1(1),m3h2x1(:,53),heltab2x2(:,:,53))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,nMB,G2tensor(53),n2h1(53))
  call Hloop_QV_A(ntryL,G1H2(136),ex4(:),G1H1(1),m3h2x1(:,54),heltab2x2(:,:,54))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),8,nMB,G2tensor(54),n2h1(54))
  call Hloop_QV_A(ntryL,G1H2(141),ex4(:),G1H1(1),m3h2x1(:,55),heltab2x2(:,:,55))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,nMB,G2tensor(55),n2h1(55))
  call Hloop_QV_A(ntryL,G1H2(142),ex4(:),G1H1(1),m3h2x1(:,56),heltab2x2(:,:,56))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),9,nMB,G2tensor(56),n2h1(56))
  call Hloop_QV_A(ntryL,G1H2(146),ex4(:),G1H1(1),m3h2x1(:,57),heltab2x2(:,:,57))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,nMT,G2tensor(57),n2h1(57))
  call Hloop_QV_A(ntryL,G1H2(147),ex4(:),G1H1(1),m3h2x1(:,58),heltab2x2(:,:,58))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),8,nMT,G2tensor(58),n2h1(58))
  call Hloop_QV_A(ntryL,G1H2(152),ex4(:),G1H1(1),m3h2x1(:,59),heltab2x2(:,:,59))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,nMT,G2tensor(59),n2h1(59))
  call Hloop_QV_A(ntryL,G1H2(153),ex4(:),G1H1(1),m3h2x1(:,60),heltab2x2(:,:,60))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),9,nMT,G2tensor(60),n2h1(60))
  call Hloop_QV_A(ntryL,G1H2(157),ex3(:),G1H1(1),m3h2x1(:,61),heltab2x2(:,:,61))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,nMT,G2tensor(61),n2h1(61))
  call Hloop_QV_A(ntryL,G1H2(158),ex3(:),G1H1(1),m3h2x1(:,62),heltab2x2(:,:,62))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),4,nMT,G2tensor(62),n2h1(62))
  call Hloop_QV_A(ntryL,G1H2(163),ex3(:),G1H1(1),m3h2x1(:,63),heltab2x2(:,:,63))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,nMT,G2tensor(63),n2h1(63))
  call Hloop_QV_A(ntryL,G1H2(164),ex3(:),G1H1(1),m3h2x1(:,64),heltab2x2(:,:,64))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),12,nMT,G2tensor(64),n2h1(64))
  call Hloop_QV_A(ntryL,G1H2(168),ex3(:),G1H1(1),m3h2x1(:,65),heltab2x2(:,:,65))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,nMT,G2tensor(65),n2h1(65))
  call Hloop_QV_A(ntryL,G1H2(169),ex3(:),G1H1(1),m3h2x1(:,66),heltab2x2(:,:,66))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),4,nMT,G2tensor(66),n2h1(66))
  call Hloop_QV_A(ntryL,G1H2(174),ex3(:),G1H1(1),m3h2x1(:,67),heltab2x2(:,:,67))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,nMT,G2tensor(67),n2h1(67))
  call Hloop_QV_A(ntryL,G1H2(175),ex3(:),G1H1(1),m3h2x1(:,68),heltab2x2(:,:,68))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),12,nMT,G2tensor(68),n2h1(68))
  call Hloop_QV_A(ntryL,G1H2(179),ex3(:),G1H1(1),m3h2x1(:,69),heltab2x2(:,:,69))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,nMB,G2tensor(69),n2h1(69))
  call Hloop_QV_A(ntryL,G1H2(180),ex3(:),G1H1(1),m3h2x1(:,70),heltab2x2(:,:,70))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),4,nMB,G2tensor(70),n2h1(70))
  call Hloop_QV_A(ntryL,G1H2(185),ex3(:),G1H1(1),m3h2x1(:,71),heltab2x2(:,:,71))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,nMB,G2tensor(71),n2h1(71))
  call Hloop_QV_A(ntryL,G1H2(186),ex3(:),G1H1(1),m3h2x1(:,72),heltab2x2(:,:,72))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),12,nMB,G2tensor(72),n2h1(72))
  call Hloop_QV_A(ntryL,G1H2(190),ex3(:),G1H1(1),m3h2x1(:,73),heltab2x2(:,:,73))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,nMT,G2tensor(73),n2h1(73))
  call Hloop_QV_A(ntryL,G1H2(191),ex3(:),G1H1(1),m3h2x1(:,74),heltab2x2(:,:,74))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),4,nMT,G2tensor(74),n2h1(74))
  call Hloop_QV_A(ntryL,G1H2(196),ex3(:),G1H1(1),m3h2x1(:,75),heltab2x2(:,:,75))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,nMT,G2tensor(75),n2h1(75))
  call Hloop_QV_A(ntryL,G1H2(197),ex3(:),G1H1(1),m3h2x1(:,76),heltab2x2(:,:,76))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),12,nMT,G2tensor(76),n2h1(76))
  call Hloop_AV_Q(ntryL,G1H2(201),ex4(:),G1H1(1),m3h2x1(:,77),heltab2x2(:,:,77))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,nMT,G2tensor(77),n2h1(77))
  call Hloop_AV_Q(ntryL,G1H2(202),ex4(:),G1H1(1),m3h2x1(:,78),heltab2x2(:,:,78))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),8,nMT,G2tensor(78),n2h1(78))
  call Hloop_AV_Q(ntryL,G1H2(207),ex4(:),G1H1(1),m3h2x1(:,79),heltab2x2(:,:,79))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,nMT,G2tensor(79),n2h1(79))
  call Hloop_AV_Q(ntryL,G1H2(208),ex4(:),G1H1(1),m3h2x1(:,80),heltab2x2(:,:,80))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),12,nMT,G2tensor(80),n2h1(80))
  call Hloop_AV_Q(ntryL,G1H2(212),ex4(:),G1H1(1),m3h2x1(:,81),heltab2x2(:,:,81))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,nMT,G2tensor(81),n2h1(81))
  call Hloop_AV_Q(ntryL,G1H2(213),ex4(:),G1H1(1),m3h2x1(:,82),heltab2x2(:,:,82))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),8,nMT,G2tensor(82),n2h1(82))
  call Hloop_AV_Q(ntryL,G1H2(218),ex4(:),G1H1(1),m3h2x1(:,83),heltab2x2(:,:,83))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,nMT,G2tensor(83),n2h1(83))
  call Hloop_AV_Q(ntryL,G1H2(219),ex4(:),G1H1(1),m3h2x1(:,84),heltab2x2(:,:,84))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),12,nMT,G2tensor(84),n2h1(84))
  call Hloop_AV_Q(ntryL,G1H2(223),ex4(:),G1H1(1),m3h2x1(:,85),heltab2x2(:,:,85))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,nMB,G2tensor(85),n2h1(85))
  call Hloop_AV_Q(ntryL,G1H2(224),ex4(:),G1H1(1),m3h2x1(:,86),heltab2x2(:,:,86))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),8,nMB,G2tensor(86),n2h1(86))
  call Hloop_AV_Q(ntryL,G1H2(229),ex4(:),G1H1(1),m3h2x1(:,87),heltab2x2(:,:,87))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,nMB,G2tensor(87),n2h1(87))
  call Hloop_AV_Q(ntryL,G1H2(230),ex4(:),G1H1(1),m3h2x1(:,88),heltab2x2(:,:,88))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),12,nMB,G2tensor(88),n2h1(88))
  call Hloop_AV_Q(ntryL,G1H2(234),ex4(:),G1H1(1),m3h2x1(:,89),heltab2x2(:,:,89))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,nMT,G2tensor(89),n2h1(89))
  call Hloop_AV_Q(ntryL,G1H2(235),ex4(:),G1H1(1),m3h2x1(:,90),heltab2x2(:,:,90))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),8,nMT,G2tensor(90),n2h1(90))
  call Hloop_AV_Q(ntryL,G1H2(240),ex4(:),G1H1(1),m3h2x1(:,91),heltab2x2(:,:,91))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,nMT,G2tensor(91),n2h1(91))
  call Hloop_AV_Q(ntryL,G1H2(241),ex4(:),G1H1(1),m3h2x1(:,92),heltab2x2(:,:,92))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),12,nMT,G2tensor(92),n2h1(92))
  call Hloop_AV_Q(ntryL,G1H2(245),ex3(:),G1H1(1),m3h2x1(:,93),heltab2x2(:,:,93))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,nMT,G2tensor(93),n2h1(93))
  call Hloop_AV_Q(ntryL,G1H2(246),ex3(:),G1H1(1),m3h2x1(:,94),heltab2x2(:,:,94))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),4,nMT,G2tensor(94),n2h1(94))
  call Hloop_AV_Q(ntryL,G1H2(251),ex3(:),G1H1(1),m3h2x1(:,95),heltab2x2(:,:,95))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,nMT,G2tensor(95),n2h1(95))
  call Hloop_AV_Q(ntryL,G1H2(252),ex3(:),G1H1(1),m3h2x1(:,96),heltab2x2(:,:,96))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),12,nMT,G2tensor(96),n2h1(96))
  call Hloop_AV_Q(ntryL,G1H2(256),ex3(:),G1H1(1),m3h2x1(:,97),heltab2x2(:,:,97))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,nMT,G2tensor(97),n2h1(97))
  call Hloop_AV_Q(ntryL,G1H2(257),ex3(:),G1H1(1),m3h2x1(:,98),heltab2x2(:,:,98))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),4,nMT,G2tensor(98),n2h1(98))
  call Hloop_AV_Q(ntryL,G1H2(262),ex3(:),G1H1(1),m3h2x1(:,99),heltab2x2(:,:,99))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,nMT,G2tensor(99),n2h1(99))
  call Hloop_AV_Q(ntryL,G1H2(263),ex3(:),G1H1(1),m3h2x1(:,100),heltab2x2(:,:,100))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),12,nMT,G2tensor(100),n2h1(100))
  call Hloop_AV_Q(ntryL,G1H2(267),ex3(:),G1H1(1),m3h2x1(:,101),heltab2x2(:,:,101))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,nMB,G2tensor(101),n2h1(101))
  call Hloop_AV_Q(ntryL,G1H2(268),ex3(:),G1H1(1),m3h2x1(:,102),heltab2x2(:,:,102))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),4,nMB,G2tensor(102),n2h1(102))
  call Hloop_AV_Q(ntryL,G1H2(273),ex3(:),G1H1(1),m3h2x1(:,103),heltab2x2(:,:,103))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,nMB,G2tensor(103),n2h1(103))
  call Hloop_AV_Q(ntryL,G1H2(274),ex3(:),G1H1(1),m3h2x1(:,104),heltab2x2(:,:,104))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),12,nMB,G2tensor(104),n2h1(104))
  call Hloop_AV_Q(ntryL,G1H2(278),ex3(:),G1H1(1),m3h2x1(:,105),heltab2x2(:,:,105))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,nMT,G2tensor(105),n2h1(105))
  call Hloop_AV_Q(ntryL,G1H2(279),ex3(:),G1H1(1),m3h2x1(:,106),heltab2x2(:,:,106))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),4,nMT,G2tensor(106),n2h1(106))
  call Hloop_AV_Q(ntryL,G1H2(284),ex3(:),G1H1(1),m3h2x1(:,107),heltab2x2(:,:,107))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,nMT,G2tensor(107),n2h1(107))
  call Hloop_AV_Q(ntryL,G1H2(285),ex3(:),G1H1(1),m3h2x1(:,108),heltab2x2(:,:,108))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),12,nMT,G2tensor(108),n2h1(108))
  call Hloop_QV_A(ntryL,G1H2(289),ex4(:),G1H1(1),m3h2x1(:,109),heltab2x2(:,:,109))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,nMB,G2tensor(109),n2h1(109))
  call Hloop_QV_A(ntryL,G1H2(290),ex4(:),G1H1(1),m3h2x1(:,110),heltab2x2(:,:,110))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),8,nMB,G2tensor(110),n2h1(110))
  call Hloop_QV_A(ntryL,G1H2(295),ex4(:),G1H1(1),m3h2x1(:,111),heltab2x2(:,:,111))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,nMB,G2tensor(111),n2h1(111))
  call Hloop_QV_A(ntryL,G1H2(296),ex4(:),G1H1(1),m3h2x1(:,112),heltab2x2(:,:,112))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),9,nMB,G2tensor(112),n2h1(112))
  call Hloop_QV_A(ntryL,G1H2(300),ex3(:),G1H1(1),m3h2x1(:,113),heltab2x2(:,:,113))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,nMB,G2tensor(113),n2h1(113))
  call Hloop_QV_A(ntryL,G1H2(301),ex3(:),G1H1(1),m3h2x1(:,114),heltab2x2(:,:,114))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),4,nMB,G2tensor(114),n2h1(114))
  call Hloop_QV_A(ntryL,G1H2(306),ex3(:),G1H1(1),m3h2x1(:,115),heltab2x2(:,:,115))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,nMB,G2tensor(115),n2h1(115))
  call Hloop_QV_A(ntryL,G1H2(307),ex3(:),G1H1(1),m3h2x1(:,116),heltab2x2(:,:,116))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),5,nMB,G2tensor(116),n2h1(116))
  call Hloop_AV_Q(ntryL,G1H2(311),ex4(:),G1H1(1),m3h2x1(:,117),heltab2x2(:,:,117))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,nMB,G2tensor(117),n2h1(117))
  call Hloop_AV_Q(ntryL,G1H2(312),ex4(:),G1H1(1),m3h2x1(:,118),heltab2x2(:,:,118))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),8,nMB,G2tensor(118),n2h1(118))
  call Hloop_AV_Q(ntryL,G1H2(317),ex4(:),G1H1(1),m3h2x1(:,119),heltab2x2(:,:,119))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,nMB,G2tensor(119),n2h1(119))
  call Hloop_AV_Q(ntryL,G1H2(318),ex4(:),G1H1(1),m3h2x1(:,120),heltab2x2(:,:,120))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),10,nMB,G2tensor(120),n2h1(120))
  call Hloop_SA_Q(ntryL,G1H2(323),ex2(:),G1H1(1),ngPtb,m3h2x1(:,121),heltab2x2(:,:,121))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),10,nMB,G2tensor(121),n2h1(121))
  call Hloop_WA_Q(ntryL,G1H2(328),ex2(:),G1H1(1),m3h2x1(:,122),heltab2x2(:,:,122))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),10,nMB,G2tensor(122),n2h1(122))
  call Hloop_AV_Q(ntryL,G1H2(332),ex3(:),G1H1(1),m3h2x1(:,123),heltab2x2(:,:,123))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,nMB,G2tensor(123),n2h1(123))
  call Hloop_AV_Q(ntryL,G1H2(333),ex3(:),G1H1(1),m3h2x1(:,124),heltab2x2(:,:,124))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),4,nMB,G2tensor(124),n2h1(124))
  call Hloop_AV_Q(ntryL,G1H2(338),ex3(:),G1H1(1),m3h2x1(:,125),heltab2x2(:,:,125))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,nMB,G2tensor(125),n2h1(125))
  call Hloop_AV_Q(ntryL,G1H2(339),ex3(:),G1H1(1),m3h2x1(:,126),heltab2x2(:,:,126))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),6,nMB,G2tensor(126),n2h1(126))
  call Hloop_SA_Q(ntryL,G1H2(344),ex2(:),G1H1(1),ngPtb,m3h2x1(:,127),heltab2x2(:,:,127))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),6,nMB,G2tensor(127),n2h1(127))
  call Hloop_WA_Q(ntryL,G1H2(349),ex2(:),G1H1(1),m3h2x1(:,128),heltab2x2(:,:,128))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),6,nMB,G2tensor(128),n2h1(128))
  call ol_merge_tensors(G2tensor(4),[G2tensor(1)])
  call ol_merge_tensors(G2tensor(10),[G2tensor(7)])
  call Hotf_5pt_reduction_last(G2tensor(4),RedSet_5(10),mass5set(:,10),  & 
G1tensor(1),G1tensor(2),G1tensor(3),G1tensor(4),G1tensor(5),G1tensor(6))
  call G_TensorShift(G1tensor(2),2)
  call Hotf_5pt_reduction_last(G2tensor(10),RedSet_5(12),mass5set(:,10),  & 
G1tensor(7),G1tensor(8),G1tensor(9),G1tensor(10),G1tensor(11),G1tensor(12))
  call G_TensorShift(G1tensor(8),2)
  call Hotf_5pt_reduction_last(G2tensor(13),RedSet_5(1),mass5set(:,1),  & 
G1tensor(13),G1tensor(14),G1tensor(15),G1tensor(16),G1tensor(17),G1tensor(18))
  call G_TensorShift(G1tensor(14),8)
  call Hotf_5pt_reduction_last(G2tensor(17),RedSet_5(1),mass5set(:,2),  & 
G1tensor(19),G1tensor(20),G1tensor(21),G1tensor(22),G1tensor(23),G1tensor(24))
  call G_TensorShift(G1tensor(20),8)
  call Hotf_5pt_reduction_last(G2tensor(21),RedSet_5(1),mass5set(:,3),  & 
G1tensor(25),G1tensor(26),G1tensor(27),G1tensor(28),G1tensor(29),G1tensor(30))
  call G_TensorShift(G1tensor(26),8)
  call Hotf_5pt_reduction_last(G2tensor(25),RedSet_5(1),mass5set(:,4),  & 
G1tensor(31),G1tensor(32),G1tensor(33),G1tensor(34),G1tensor(35),G1tensor(36))
  call G_TensorShift(G1tensor(32),8)
  call Hotf_5pt_reduction_last(G2tensor(29),RedSet_5(2),mass5set(:,5),  & 
G1tensor(37),G1tensor(38),G1tensor(39),G1tensor(40),G1tensor(41),G1tensor(42))
  call G_TensorShift(G1tensor(38),8)
  call Hotf_5pt_reduction_last(G2tensor(33),RedSet_5(2),mass5set(:,6),  & 
G1tensor(43),G1tensor(44),G1tensor(45),G1tensor(46),G1tensor(47),G1tensor(48))
  call G_TensorShift(G1tensor(44),8)
  call Hotf_5pt_reduction_last(G2tensor(37),RedSet_5(2),mass5set(:,7),  & 
G1tensor(49),G1tensor(50),G1tensor(51),G1tensor(52),G1tensor(53),G1tensor(54))
  call G_TensorShift(G1tensor(50),8)
  call Hotf_5pt_reduction_last(G2tensor(41),RedSet_5(2),mass5set(:,8),  & 
G1tensor(55),G1tensor(56),G1tensor(57),G1tensor(58),G1tensor(59),G1tensor(60))
  call G_TensorShift(G1tensor(56),8)
  call Hotf_5pt_reduction_last(G2tensor(45),RedSet_5(3),mass5set(:,1),  & 
G1tensor(61),G1tensor(62),G1tensor(63),G1tensor(64),G1tensor(65),G1tensor(66))
  call G_TensorShift(G1tensor(62),8)
  call Hotf_5pt_reduction_last(G2tensor(49),RedSet_5(3),mass5set(:,2),  & 
G1tensor(67),G1tensor(68),G1tensor(69),G1tensor(70),G1tensor(71),G1tensor(72))
  call G_TensorShift(G1tensor(68),8)
  call Hotf_5pt_reduction_last(G2tensor(53),RedSet_5(3),mass5set(:,3),  & 
G1tensor(73),G1tensor(74),G1tensor(75),G1tensor(76),G1tensor(77),G1tensor(78))
  call G_TensorShift(G1tensor(74),8)
  call Hotf_5pt_reduction_last(G2tensor(57),RedSet_5(3),mass5set(:,4),  & 
G1tensor(79),G1tensor(80),G1tensor(81),G1tensor(82),G1tensor(83),G1tensor(84))
  call G_TensorShift(G1tensor(80),8)
  call Hotf_5pt_reduction_last(G2tensor(61),RedSet_5(4),mass5set(:,5),  & 
G1tensor(85),G1tensor(86),G1tensor(87),G1tensor(88),G1tensor(89),G1tensor(90))
  call G_TensorShift(G1tensor(86),4)
  call Hotf_5pt_reduction_last(G2tensor(65),RedSet_5(4),mass5set(:,6),  & 
G1tensor(91),G1tensor(92),G1tensor(93),G1tensor(94),G1tensor(95),G1tensor(96))
  call G_TensorShift(G1tensor(92),4)
  call Hotf_5pt_reduction_last(G2tensor(69),RedSet_5(4),mass5set(:,7),  & 
G1tensor(97),G1tensor(98),G1tensor(99),G1tensor(100),G1tensor(101),G1tensor(102))
  call G_TensorShift(G1tensor(98),4)
  call Hotf_5pt_reduction_last(G2tensor(73),RedSet_5(4),mass5set(:,8),  & 
G1tensor(103),G1tensor(104),G1tensor(105),G1tensor(106),G1tensor(107),G1tensor(108))
  call G_TensorShift(G1tensor(104),4)
  call Hotf_5pt_reduction_last(G2tensor(77),RedSet_5(5),mass5set(:,5),  & 
G1tensor(109),G1tensor(110),G1tensor(111),G1tensor(112),G1tensor(113),G1tensor(114))
  call G_TensorShift(G1tensor(110),8)
  call Hotf_5pt_reduction_last(G2tensor(81),RedSet_5(5),mass5set(:,6),  & 
G1tensor(115),G1tensor(116),G1tensor(117),G1tensor(118),G1tensor(119),G1tensor(120))
  call G_TensorShift(G1tensor(116),8)
  call Hotf_5pt_reduction_last(G2tensor(85),RedSet_5(5),mass5set(:,7),  & 
G1tensor(121),G1tensor(122),G1tensor(123),G1tensor(124),G1tensor(125),G1tensor(126))
  call G_TensorShift(G1tensor(122),8)
  call Hotf_5pt_reduction_last(G2tensor(89),RedSet_5(5),mass5set(:,8),  & 
G1tensor(127),G1tensor(128),G1tensor(129),G1tensor(130),G1tensor(131),G1tensor(132))
  call G_TensorShift(G1tensor(128),8)
  call Hotf_5pt_reduction_last(G2tensor(93),RedSet_5(6),mass5set(:,5),  & 
G1tensor(133),G1tensor(134),G1tensor(135),G1tensor(136),G1tensor(137),G1tensor(138))
  call G_TensorShift(G1tensor(134),4)
  call Hotf_5pt_reduction_last(G2tensor(97),RedSet_5(6),mass5set(:,6),  & 
G1tensor(139),G1tensor(140),G1tensor(141),G1tensor(142),G1tensor(143),G1tensor(144))
  call G_TensorShift(G1tensor(140),4)
  call Hotf_5pt_reduction_last(G2tensor(101),RedSet_5(6),mass5set(:,7),  & 
G1tensor(145),G1tensor(146),G1tensor(147),G1tensor(148),G1tensor(149),G1tensor(150))
  call G_TensorShift(G1tensor(146),4)
  call Hotf_5pt_reduction_last(G2tensor(105),RedSet_5(6),mass5set(:,8),  & 
G1tensor(151),G1tensor(152),G1tensor(153),G1tensor(154),G1tensor(155),G1tensor(156))
  call G_TensorShift(G1tensor(152),4)
  call Hotf_5pt_reduction_last(G2tensor(109),RedSet_5(7),mass5set(:,9),  & 
G1tensor(157),G1tensor(158),G1tensor(159),G1tensor(160),G1tensor(161),G1tensor(162))
  call G_TensorShift(G1tensor(158),8)
  call Hotf_5pt_reduction_last(G2tensor(113),RedSet_5(8),mass5set(:,9),  & 
G1tensor(163),G1tensor(164),G1tensor(165),G1tensor(166),G1tensor(167),G1tensor(168))
  call G_TensorShift(G1tensor(164),4)
  call Hotf_5pt_reduction_last(G2tensor(117),RedSet_5(9),mass5set(:,9),  & 
G1tensor(169),G1tensor(170),G1tensor(171),G1tensor(172),G1tensor(173),G1tensor(174))
  call G_TensorShift(G1tensor(170),8)
  call Hotf_5pt_reduction_last(G2tensor(123),RedSet_5(11),mass5set(:,9),  & 
G1tensor(175),G1tensor(176),G1tensor(177),G1tensor(178),G1tensor(179),G1tensor(180))
  call G_TensorShift(G1tensor(176),4)
  call ol_merge_tensors(T1sum(1),[G1tensor(1)])
  call ol_merge_tensors(T1sum(2),[G1tensor(7)])
  call ol_merge_tensors(T1sum(3),[G1tensor(13)])
  call ol_merge_tensors(T1sum(4),[G1tensor(19)])
  call ol_merge_tensors(T1sum(5),[G1tensor(25)])
  call ol_merge_tensors(T1sum(6),[G1tensor(31)])
  call ol_merge_tensors(T1sum(7),[G1tensor(37)])
  call ol_merge_tensors(T1sum(8),[G1tensor(43)])
  call ol_merge_tensors(T1sum(9),[G1tensor(49)])
  call ol_merge_tensors(T1sum(10),[G1tensor(55)])
  call ol_merge_tensors(T1sum(11),[G1tensor(61)])
  call ol_merge_tensors(T1sum(12),[G1tensor(67)])
  call ol_merge_tensors(T1sum(13),[G1tensor(73)])
  call ol_merge_tensors(T1sum(14),[G1tensor(79)])
  call ol_merge_tensors(T1sum(15),[G1tensor(85)])
  call ol_merge_tensors(T1sum(16),[G1tensor(91)])
  call ol_merge_tensors(T1sum(17),[G1tensor(97)])
  call ol_merge_tensors(T1sum(18),[G1tensor(103)])
  call ol_merge_tensors(T1sum(19),[G1tensor(109)])
  call ol_merge_tensors(T1sum(20),[G1tensor(115)])
  call ol_merge_tensors(T1sum(21),[G1tensor(121)])
  call ol_merge_tensors(T1sum(22),[G1tensor(127)])
  call ol_merge_tensors(T1sum(23),[G1tensor(133)])
  call ol_merge_tensors(T1sum(24),[G1tensor(139)])
  call ol_merge_tensors(T1sum(25),[G1tensor(145)])
  call ol_merge_tensors(T1sum(26),[G1tensor(151)])
  call ol_merge_tensors(T1sum(27),[G1tensor(157)])
  call ol_merge_tensors(T1sum(28),[G1tensor(163)])
  call ol_merge_tensors(T1sum(29),[G1tensor(169)])
  call ol_merge_tensors(T1sum(30),[G1tensor(175)])
  Gcoeff(:)%j = (-(c(21)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(69),h0tab(:,69),[16,1,12,2],[nMB,nMW,nMW,nMB],5,0)
  call Hloop_AV_Q(ntryL,G0H32(1),ex5(:),G0H16(1),m3h2x16(:,69),heltab2x32(:,:,69))
  call Hloop_A_Q(ntryL,G0H16(1),16,nMB,G1H16(1),n2h16(69))
  Gcoeff(:)%j = (-(c(11)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(70),h0tab(:,70),[16,1,12,2],[nMB,nMW,nMW,nMB],5,0)
  call Hloop_AV_Q(ntryL,G0H32(1),ex5(:),G0H16(1),m3h2x16(:,70),heltab2x32(:,:,70))
  call Hloop_A_Q(ntryL,G0H16(1),16,nMB,G1H16(2),n2h16(70))
  Gcoeff(:)%j = (c(19)*M(1,:)%j) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(71),h0tab(:,71),[16,2,8,5],[nMB,nMW,nMW,nMB],4,1,wf4(:,3))
  call Hloop_QV_A(ntryL,G0H32(1),ex5(:),G0H16(1),m3h2x16(:,71),heltab2x32(:,:,71))
  call Hloop_Q_A(ntryL,G0H16(1),16,nMB,G1H16(3),n2h16(71))
  Gcoeff(:)%j = (c(10)*M(1,:)%j) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(72),h0tab(:,72),[16,2,8,5],[nMB,nMW,nMW,nMB],4,1,wf4(:,3))
  call Hloop_QV_A(ntryL,G0H32(1),ex5(:),G0H16(1),m3h2x16(:,72),heltab2x32(:,:,72))
  call Hloop_Q_A(ntryL,G0H16(1),16,nMB,G1H16(4),n2h16(72))
  Gcoeff(:)%j = (-(c(10)*M(1,:)%j)) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(73),h0tab(:,73),[16,2,8,5],[nMB,nMW,nMW,nMB],4,1,wf4(:,3))
  call Hloop_QV_A(ntryL,G0H32(1),ex5(:),G0H16(1),m3h2x16(:,73),heltab2x32(:,:,73))
  call Hloop_Q_A(ntryL,G0H16(1),16,nMB,G1H16(5),n2h16(73))
  Gcoeff(:)%j = (c(10)*M(1,:)%j) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(74),h0tab(:,74),[16,2,8,5],[nMB,nMW,nMW,nMB],4,1,wf4(:,3))
  call Hloop_QV_A(ntryL,G0H32(1),ex5(:),G0H16(1),m3h2x16(:,74),heltab2x32(:,:,74))
  call Hloop_Q_A(ntryL,G0H16(1),16,nMB,G1H16(6),n2h16(74))
  Gcoeff(:)%j = (-(c(24)*M(1,:)%j)) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(75),h0tab(:,75),[16,5,2,8],[nMT,nMH,nMT,nMT],4,1,wf4(:,3))
  call Hloop_AV_Q(ntryL,G0H32(1),ex5(:),G0H16(1),m3h2x16(:,75),heltab2x32(:,:,75))
  call Hloop_A_Q(ntryL,G0H16(1),16,nMT,G1H16(7),n2h16(75))
  Gcoeff(:)%j = (c(24)*M(1,:)%j) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(76),h0tab(:,76),[16,5,2,8],[nMT,nMZ,nMT,nMT],4,1,wf4(:,3))
  call Hloop_AV_Q(ntryL,G0H32(1),ex5(:),G0H16(1),m3h2x16(:,76),heltab2x32(:,:,76))
  call Hloop_A_Q(ntryL,G0H16(1),16,nMT,G1H16(8),n2h16(76))
  Gcoeff(:)%j = (-(c(16)*M(1,:)%j)) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(77),h0tab(:,77),[16,5,2,8],[nMB,nMW,nMB,nMB],4,1,wf4(:,3))
  call Hloop_AV_Q(ntryL,G0H32(1),ex5(:),G0H16(1),m3h2x16(:,77),heltab2x32(:,:,77))
  call Hloop_A_Q(ntryL,G0H16(1),16,nMB,G1H16(9),n2h16(77))
  Gcoeff(:)%j = (c(1)*M(1,:)%j) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(78),h0tab(:,78),[16,5,2,8],[nMT,0,nMT,nMT],4,1,wf4(:,3))
  call Hloop_AV_Q(ntryL,G0H32(1),ex5(:),G0H16(1),m3h2x16(:,78),heltab2x32(:,:,78))
  call Hloop_A_Q(ntryL,G0H16(1),16,nMT,G1H16(10),n2h16(78))
  Gcoeff(:)%j = (c(2)*M(1,:)%j) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(79),h0tab(:,79),[16,5,2,8],[nMT,nMZ,nMT,nMT],4,1,wf4(:,3))
  call Hloop_AV_Q(ntryL,G0H32(1),ex5(:),G0H16(1),m3h2x16(:,79),heltab2x32(:,:,79))
  call Hloop_A_Q(ntryL,G0H16(1),16,nMT,G1H16(11),n2h16(79))
  Gcoeff(:)%j = (-(c(7)*M(1,:)%j)) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(80),h0tab(:,80),[16,5,2,8],[nMB,nMW,nMB,nMB],4,1,wf4(:,3))
  call Hloop_AV_Q(ntryL,G0H32(1),ex5(:),G0H16(1),m3h2x16(:,80),heltab2x32(:,:,80))
  call Hloop_A_Q(ntryL,G0H16(1),16,nMB,G1H16(12),n2h16(80))
  Gcoeff(:)%j = (-(c(24)*M(1,:)%j)) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(81),h0tab(:,81),[16,2,5,8],[nMT,nMH,nMT,nMT],4,1,wf4(:,3))
  call Hloop_QV_A(ntryL,G0H32(1),ex5(:),G0H16(1),m3h2x16(:,81),heltab2x32(:,:,81))
  call Hloop_Q_A(ntryL,G0H16(1),16,nMT,G1H16(13),n2h16(81))
  Gcoeff(:)%j = (c(24)*M(1,:)%j) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(82),h0tab(:,82),[16,2,5,8],[nMT,nMZ,nMT,nMT],4,1,wf4(:,3))
  call Hloop_QV_A(ntryL,G0H32(1),ex5(:),G0H16(1),m3h2x16(:,82),heltab2x32(:,:,82))
  call Hloop_Q_A(ntryL,G0H16(1),16,nMT,G1H16(14),n2h16(82))
  Gcoeff(:)%j = (-(c(16)*M(1,:)%j)) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(83),h0tab(:,83),[16,2,5,8],[nMB,nMW,nMB,nMB],4,1,wf4(:,3))
  call Hloop_QV_A(ntryL,G0H32(1),ex5(:),G0H16(1),m3h2x16(:,83),heltab2x32(:,:,83))
  call Hloop_Q_A(ntryL,G0H16(1),16,nMB,G1H16(15),n2h16(83))
  Gcoeff(:)%j = (c(1)*M(1,:)%j) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(84),h0tab(:,84),[16,2,5,8],[nMT,0,nMT,nMT],4,1,wf4(:,3))
  call Hloop_QV_A(ntryL,G0H32(1),ex5(:),G0H16(1),m3h2x16(:,84),heltab2x32(:,:,84))
  call Hloop_Q_A(ntryL,G0H16(1),16,nMT,G1H16(16),n2h16(84))
  Gcoeff(:)%j = (c(2)*M(1,:)%j) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(85),h0tab(:,85),[16,2,5,8],[nMT,nMZ,nMT,nMT],4,1,wf4(:,3))
  call Hloop_QV_A(ntryL,G0H32(1),ex5(:),G0H16(1),m3h2x16(:,85),heltab2x32(:,:,85))
  call Hloop_Q_A(ntryL,G0H16(1),16,nMT,G1H16(17),n2h16(85))
  Gcoeff(:)%j = (-(c(7)*M(1,:)%j)) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(86),h0tab(:,86),[16,2,5,8],[nMB,nMW,nMB,nMB],4,1,wf4(:,3))
  call Hloop_QV_A(ntryL,G0H32(1),ex5(:),G0H16(1),m3h2x16(:,86),heltab2x32(:,:,86))
  call Hloop_Q_A(ntryL,G0H16(1),16,nMB,G1H16(18),n2h16(86))
  Gcoeff(:)%j = (c(19)*M(1,:)%j) * den(7)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(87),h0tab(:,87),[16,1,8,6],[nMB,nMW,nMW,nMB],4,1,wf4(:,10))
  call Hloop_AV_Q(ntryL,G0H32(1),ex5(:),G0H16(1),m3h2x16(:,87),heltab2x32(:,:,87))
  call Hloop_A_Q(ntryL,G0H16(1),16,nMB,G1H16(19),n2h16(87))
  Gcoeff(:)%j = (-(c(10)*M(1,:)%j)) * den(7)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(88),h0tab(:,88),[16,1,8,6],[nMB,nMW,nMW,nMB],4,1,wf4(:,10))
  call Hloop_AV_Q(ntryL,G0H32(1),ex5(:),G0H16(1),m3h2x16(:,88),heltab2x32(:,:,88))
  call Hloop_A_Q(ntryL,G0H16(1),16,nMB,G1H16(20),n2h16(88))
  Gcoeff(:)%j = (c(10)*M(1,:)%j) * den(7)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(89),h0tab(:,89),[16,1,8,6],[nMB,nMW,nMW,nMB],4,1,wf4(:,10))
  call Hloop_AV_Q(ntryL,G0H32(1),ex5(:),G0H16(1),m3h2x16(:,89),heltab2x32(:,:,89))
  call Hloop_A_Q(ntryL,G0H16(1),16,nMB,G1H16(21),n2h16(89))
  Gcoeff(:)%j = (c(10)*M(1,:)%j) * den(7)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(90),h0tab(:,90),[16,1,8,6],[nMB,nMW,nMW,nMB],4,1,wf4(:,10))
  call Hloop_AV_Q(ntryL,G0H32(1),ex5(:),G0H16(1),m3h2x16(:,90),heltab2x32(:,:,90))
  call Hloop_A_Q(ntryL,G0H16(1),16,nMB,G1H16(22),n2h16(90))
  Gcoeff(:)%j = (-(c(24)*M(1,:)%j)) * den(7)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(91),h0tab(:,91),[16,6,1,8],[nMT,nMH,nMT,nMT],4,1,wf4(:,10))
  call Hloop_QV_A(ntryL,G0H32(1),ex5(:),G0H16(1),m3h2x16(:,91),heltab2x32(:,:,91))
  call Hloop_Q_A(ntryL,G0H16(1),16,nMT,G1H16(23),n2h16(91))
  Gcoeff(:)%j = (c(24)*M(1,:)%j) * den(7)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(92),h0tab(:,92),[16,6,1,8],[nMT,nMZ,nMT,nMT],4,1,wf4(:,10))
  call Hloop_QV_A(ntryL,G0H32(1),ex5(:),G0H16(1),m3h2x16(:,92),heltab2x32(:,:,92))
  call Hloop_Q_A(ntryL,G0H16(1),16,nMT,G1H16(24),n2h16(92))
  Gcoeff(:)%j = (-(c(16)*M(1,:)%j)) * den(7)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(93),h0tab(:,93),[16,6,1,8],[nMB,nMW,nMB,nMB],4,1,wf4(:,10))
  call Hloop_QV_A(ntryL,G0H32(1),ex5(:),G0H16(1),m3h2x16(:,93),heltab2x32(:,:,93))
  call Hloop_Q_A(ntryL,G0H16(1),16,nMB,G1H16(25),n2h16(93))
  Gcoeff(:)%j = (c(1)*M(1,:)%j) * den(7)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(94),h0tab(:,94),[16,6,1,8],[nMT,0,nMT,nMT],4,1,wf4(:,10))
  call Hloop_QV_A(ntryL,G0H32(1),ex5(:),G0H16(1),m3h2x16(:,94),heltab2x32(:,:,94))
  call Hloop_Q_A(ntryL,G0H16(1),16,nMT,G1H16(26),n2h16(94))
  Gcoeff(:)%j = (c(2)*M(1,:)%j) * den(7)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(95),h0tab(:,95),[16,6,1,8],[nMT,nMZ,nMT,nMT],4,1,wf4(:,10))
  call Hloop_QV_A(ntryL,G0H32(1),ex5(:),G0H16(1),m3h2x16(:,95),heltab2x32(:,:,95))
  call Hloop_Q_A(ntryL,G0H16(1),16,nMT,G1H16(27),n2h16(95))
  Gcoeff(:)%j = (-(c(7)*M(1,:)%j)) * den(7)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(96),h0tab(:,96),[16,6,1,8],[nMB,nMW,nMB,nMB],4,1,wf4(:,10))
  call Hloop_QV_A(ntryL,G0H32(1),ex5(:),G0H16(1),m3h2x16(:,96),heltab2x32(:,:,96))
  call Hloop_Q_A(ntryL,G0H16(1),16,nMB,G1H16(28),n2h16(96))
  Gcoeff(:)%j = (-(c(24)*M(1,:)%j)) * den(7)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(97),h0tab(:,97),[16,1,6,8],[nMT,nMH,nMT,nMT],4,1,wf4(:,10))
  call Hloop_AV_Q(ntryL,G0H32(1),ex5(:),G0H16(1),m3h2x16(:,97),heltab2x32(:,:,97))
  call Hloop_A_Q(ntryL,G0H16(1),16,nMT,G1H16(29),n2h16(97))
  Gcoeff(:)%j = (c(24)*M(1,:)%j) * den(7)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(98),h0tab(:,98),[16,1,6,8],[nMT,nMZ,nMT,nMT],4,1,wf4(:,10))
  call Hloop_AV_Q(ntryL,G0H32(1),ex5(:),G0H16(1),m3h2x16(:,98),heltab2x32(:,:,98))
  call Hloop_A_Q(ntryL,G0H16(1),16,nMT,G1H16(30),n2h16(98))
  Gcoeff(:)%j = (-(c(16)*M(1,:)%j)) * den(7)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(99),h0tab(:,99),[16,1,6,8],[nMB,nMW,nMB,nMB],4,1,wf4(:,10))
  call Hloop_AV_Q(ntryL,G0H32(1),ex5(:),G0H16(1),m3h2x16(:,99),heltab2x32(:,:,99))
  call Hloop_A_Q(ntryL,G0H16(1),16,nMB,G1H16(31),n2h16(99))
  Gcoeff(:)%j = (c(1)*M(1,:)%j) * den(7)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(100),h0tab(:,100),[16,1,6,8],[nMT,0,nMT,nMT],4,1,wf4(:,10))
  call Hloop_AV_Q(ntryL,G0H32(1),ex5(:),G0H16(1),m3h2x16(:,100),heltab2x32(:,:,100))
  call Hloop_A_Q(ntryL,G0H16(1),16,nMT,G1H16(32),n2h16(100))
  Gcoeff(:)%j = (c(2)*M(1,:)%j) * den(7)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(101),h0tab(:,101),[16,1,6,8],[nMT,nMZ,nMT,nMT],4,1,wf4(:,10))
  call Hloop_AV_Q(ntryL,G0H32(1),ex5(:),G0H16(1),m3h2x16(:,101),heltab2x32(:,:,101))
  call Hloop_A_Q(ntryL,G0H16(1),16,nMT,G1H16(33),n2h16(101))
  Gcoeff(:)%j = (-(c(7)*M(1,:)%j)) * den(7)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(102),h0tab(:,102),[16,1,6,8],[nMB,nMW,nMB,nMB],4,1,wf4(:,10))
  call Hloop_AV_Q(ntryL,G0H32(1),ex5(:),G0H16(1),m3h2x16(:,102),heltab2x32(:,:,102))
  call Hloop_A_Q(ntryL,G0H16(1),16,nMB,G1H16(34),n2h16(102))
  Gcoeff(:)%j = (c(19)*M(1,:)%j) * den(6)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(103),h0tab(:,103),[16,2,4,9],[nMB,nMW,nMW,nMB],4,1,wf4(:,9))
  call Hloop_QV_A(ntryL,G0H32(1),ex5(:),G0H16(1),m3h2x16(:,103),heltab2x32(:,:,103))
  call Hloop_Q_A(ntryL,G0H16(1),16,nMB,G1H16(35),n2h16(103))
  Gcoeff(:)%j = (c(10)*M(1,:)%j) * den(6)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(104),h0tab(:,104),[16,2,4,9],[nMB,nMW,nMW,nMB],4,1,wf4(:,9))
  call Hloop_QV_A(ntryL,G0H32(1),ex5(:),G0H16(1),m3h2x16(:,104),heltab2x32(:,:,104))
  call Hloop_Q_A(ntryL,G0H16(1),16,nMB,G1H16(36),n2h16(104))
  Gcoeff(:)%j = (-(c(10)*M(1,:)%j)) * den(6)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(105),h0tab(:,105),[16,2,4,9],[nMB,nMW,nMW,nMB],4,1,wf4(:,9))
  call Hloop_QV_A(ntryL,G0H32(1),ex5(:),G0H16(1),m3h2x16(:,105),heltab2x32(:,:,105))
  call Hloop_Q_A(ntryL,G0H16(1),16,nMB,G1H16(37),n2h16(105))
  Gcoeff(:)%j = (c(10)*M(1,:)%j) * den(6)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(106),h0tab(:,106),[16,2,4,9],[nMB,nMW,nMW,nMB],4,1,wf4(:,9))
  call Hloop_QV_A(ntryL,G0H32(1),ex5(:),G0H16(1),m3h2x16(:,106),heltab2x32(:,:,106))
  call Hloop_Q_A(ntryL,G0H16(1),16,nMB,G1H16(38),n2h16(106))
  Gcoeff(:)%j = (-(c(24)*M(1,:)%j)) * den(6)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(107),h0tab(:,107),[16,4,2,9],[nMT,nMT,nMH,nMT],4,1,wf4(:,9))
  call Hloop_QV_A(ntryL,G0H32(1),ex5(:),G0H16(1),m3h2x16(:,107),heltab2x32(:,:,107))
  call Hloop_Q_A(ntryL,G0H16(1),16,nMT,G1H16(39),n2h16(107))
  Gcoeff(:)%j = (c(24)*M(1,:)%j) * den(6)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(108),h0tab(:,108),[16,4,2,9],[nMT,nMT,nMZ,nMT],4,1,wf4(:,9))
  call Hloop_QV_A(ntryL,G0H32(1),ex5(:),G0H16(1),m3h2x16(:,108),heltab2x32(:,:,108))
  call Hloop_Q_A(ntryL,G0H16(1),16,nMT,G1H16(40),n2h16(108))
  Gcoeff(:)%j = (-(c(16)*M(1,:)%j)) * den(6)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(109),h0tab(:,109),[16,4,2,9],[nMB,nMB,nMW,nMB],4,1,wf4(:,9))
  call Hloop_QV_A(ntryL,G0H32(1),ex5(:),G0H16(1),m3h2x16(:,109),heltab2x32(:,:,109))
  call Hloop_Q_A(ntryL,G0H16(1),16,nMB,G1H16(41),n2h16(109))
  Gcoeff(:)%j = (c(1)*M(1,:)%j) * den(6)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(110),h0tab(:,110),[16,4,2,9],[nMT,nMT,0,nMT],4,1,wf4(:,9))
  call Hloop_QV_A(ntryL,G0H32(1),ex5(:),G0H16(1),m3h2x16(:,110),heltab2x32(:,:,110))
  call Hloop_Q_A(ntryL,G0H16(1),16,nMT,G1H16(42),n2h16(110))
  Gcoeff(:)%j = (c(2)*M(1,:)%j) * den(6)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(111),h0tab(:,111),[16,4,2,9],[nMT,nMT,nMZ,nMT],4,1,wf4(:,9))
  call Hloop_QV_A(ntryL,G0H32(1),ex5(:),G0H16(1),m3h2x16(:,111),heltab2x32(:,:,111))
  call Hloop_Q_A(ntryL,G0H16(1),16,nMT,G1H16(43),n2h16(111))
  Gcoeff(:)%j = (-(c(7)*M(1,:)%j)) * den(6)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(112),h0tab(:,112),[16,4,2,9],[nMB,nMB,nMW,nMB],4,1,wf4(:,9))
  call Hloop_QV_A(ntryL,G0H32(1),ex5(:),G0H16(1),m3h2x16(:,112),heltab2x32(:,:,112))
  call Hloop_Q_A(ntryL,G0H16(1),16,nMB,G1H16(44),n2h16(112))
  Gcoeff(:)%j = (-(c(24)*M(1,:)%j)) * den(6)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(113),h0tab(:,113),[16,2,9,4],[nMT,nMH,nMT,nMT],4,1,wf4(:,9))
  call Hloop_QV_A(ntryL,G0H32(1),ex5(:),G0H16(1),m3h2x16(:,113),heltab2x32(:,:,113))
  call Hloop_Q_A(ntryL,G0H16(1),16,nMT,G1H16(45),n2h16(113))
  Gcoeff(:)%j = (c(24)*M(1,:)%j) * den(6)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(114),h0tab(:,114),[16,2,9,4],[nMT,nMZ,nMT,nMT],4,1,wf4(:,9))
  call Hloop_QV_A(ntryL,G0H32(1),ex5(:),G0H16(1),m3h2x16(:,114),heltab2x32(:,:,114))
  call Hloop_Q_A(ntryL,G0H16(1),16,nMT,G1H16(46),n2h16(114))
  Gcoeff(:)%j = (-(c(16)*M(1,:)%j)) * den(6)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(115),h0tab(:,115),[16,2,9,4],[nMB,nMW,nMB,nMB],4,1,wf4(:,9))
  call Hloop_QV_A(ntryL,G0H32(1),ex5(:),G0H16(1),m3h2x16(:,115),heltab2x32(:,:,115))
  call Hloop_Q_A(ntryL,G0H16(1),16,nMB,G1H16(47),n2h16(115))
  Gcoeff(:)%j = (c(1)*M(1,:)%j) * den(6)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(116),h0tab(:,116),[16,2,9,4],[nMT,0,nMT,nMT],4,1,wf4(:,9))
  call Hloop_QV_A(ntryL,G0H32(1),ex5(:),G0H16(1),m3h2x16(:,116),heltab2x32(:,:,116))
  call Hloop_Q_A(ntryL,G0H16(1),16,nMT,G1H16(48),n2h16(116))
  Gcoeff(:)%j = (c(2)*M(1,:)%j) * den(6)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(117),h0tab(:,117),[16,2,9,4],[nMT,nMZ,nMT,nMT],4,1,wf4(:,9))
  call Hloop_QV_A(ntryL,G0H32(1),ex5(:),G0H16(1),m3h2x16(:,117),heltab2x32(:,:,117))
  call Hloop_Q_A(ntryL,G0H16(1),16,nMT,G1H16(49),n2h16(117))
  Gcoeff(:)%j = (-(c(7)*M(1,:)%j)) * den(6)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(118),h0tab(:,118),[16,2,9,4],[nMB,nMW,nMB,nMB],4,1,wf4(:,9))
  call Hloop_QV_A(ntryL,G0H32(1),ex5(:),G0H16(1),m3h2x16(:,118),heltab2x32(:,:,118))
  call Hloop_Q_A(ntryL,G0H16(1),16,nMB,G1H16(50),n2h16(118))
  Gcoeff(:)%j = (c(19)*M(1,:)%j) * den(2)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(119),h0tab(:,119),[16,1,4,10],[nMB,nMW,nMW,nMB],4,1,wf4(:,4))
  call Hloop_AV_Q(ntryL,G0H32(1),ex5(:),G0H16(1),m3h2x16(:,119),heltab2x32(:,:,119))
  call Hloop_A_Q(ntryL,G0H16(1),16,nMB,G1H16(51),n2h16(119))
  Gcoeff(:)%j = (-(c(10)*M(1,:)%j)) * den(2)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(120),h0tab(:,120),[16,1,4,10],[nMB,nMW,nMW,nMB],4,1,wf4(:,4))
  call Hloop_AV_Q(ntryL,G0H32(1),ex5(:),G0H16(1),m3h2x16(:,120),heltab2x32(:,:,120))
  call Hloop_A_Q(ntryL,G0H16(1),16,nMB,G1H16(52),n2h16(120))
  Gcoeff(:)%j = (c(10)*M(1,:)%j) * den(2)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(121),h0tab(:,121),[16,1,4,10],[nMB,nMW,nMW,nMB],4,1,wf4(:,4))
  call Hloop_AV_Q(ntryL,G0H32(1),ex5(:),G0H16(1),m3h2x16(:,121),heltab2x32(:,:,121))
  call Hloop_A_Q(ntryL,G0H16(1),16,nMB,G1H16(53),n2h16(121))
  Gcoeff(:)%j = (c(10)*M(1,:)%j) * den(2)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(122),h0tab(:,122),[16,1,4,10],[nMB,nMW,nMW,nMB],4,1,wf4(:,4))
  call Hloop_AV_Q(ntryL,G0H32(1),ex5(:),G0H16(1),m3h2x16(:,122),heltab2x32(:,:,122))
  call Hloop_A_Q(ntryL,G0H16(1),16,nMB,G1H16(54),n2h16(122))
  Gcoeff(:)%j = (-(c(24)*M(1,:)%j)) * den(2)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(123),h0tab(:,123),[16,4,1,10],[nMT,nMT,nMH,nMT],4,1,wf4(:,4))
  call Hloop_AV_Q(ntryL,G0H32(1),ex5(:),G0H16(1),m3h2x16(:,123),heltab2x32(:,:,123))
  call Hloop_A_Q(ntryL,G0H16(1),16,nMT,G1H16(55),n2h16(123))
  Gcoeff(:)%j = (c(24)*M(1,:)%j) * den(2)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(124),h0tab(:,124),[16,4,1,10],[nMT,nMT,nMZ,nMT],4,1,wf4(:,4))
  call Hloop_AV_Q(ntryL,G0H32(1),ex5(:),G0H16(1),m3h2x16(:,124),heltab2x32(:,:,124))
  call Hloop_A_Q(ntryL,G0H16(1),16,nMT,G1H16(56),n2h16(124))
  Gcoeff(:)%j = (-(c(16)*M(1,:)%j)) * den(2)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(125),h0tab(:,125),[16,4,1,10],[nMB,nMB,nMW,nMB],4,1,wf4(:,4))
  call Hloop_AV_Q(ntryL,G0H32(1),ex5(:),G0H16(1),m3h2x16(:,125),heltab2x32(:,:,125))
  call Hloop_A_Q(ntryL,G0H16(1),16,nMB,G1H16(57),n2h16(125))
  Gcoeff(:)%j = (c(1)*M(1,:)%j) * den(2)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(126),h0tab(:,126),[16,4,1,10],[nMT,nMT,0,nMT],4,1,wf4(:,4))
  call Hloop_AV_Q(ntryL,G0H32(1),ex5(:),G0H16(1),m3h2x16(:,126),heltab2x32(:,:,126))
  call Hloop_A_Q(ntryL,G0H16(1),16,nMT,G1H16(58),n2h16(126))
  Gcoeff(:)%j = (c(2)*M(1,:)%j) * den(2)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(127),h0tab(:,127),[16,4,1,10],[nMT,nMT,nMZ,nMT],4,1,wf4(:,4))
  call Hloop_AV_Q(ntryL,G0H32(1),ex5(:),G0H16(1),m3h2x16(:,127),heltab2x32(:,:,127))
  call Hloop_A_Q(ntryL,G0H16(1),16,nMT,G1H16(59),n2h16(127))
  Gcoeff(:)%j = (-(c(7)*M(1,:)%j)) * den(2)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(128),h0tab(:,128),[16,4,1,10],[nMB,nMB,nMW,nMB],4,1,wf4(:,4))
  call Hloop_AV_Q(ntryL,G0H32(1),ex5(:),G0H16(1),m3h2x16(:,128),heltab2x32(:,:,128))
  call Hloop_A_Q(ntryL,G0H16(1),16,nMB,G1H16(60),n2h16(128))
  Gcoeff(:)%j = (-(c(24)*M(1,:)%j)) * den(2)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(129),h0tab(:,129),[16,1,10,4],[nMT,nMH,nMT,nMT],4,1,wf4(:,4))
  call Hloop_AV_Q(ntryL,G0H32(1),ex5(:),G0H16(1),m3h2x16(:,129),heltab2x32(:,:,129))
  call Hloop_A_Q(ntryL,G0H16(1),16,nMT,G1H16(61),n2h16(129))
  Gcoeff(:)%j = (c(24)*M(1,:)%j) * den(2)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(130),h0tab(:,130),[16,1,10,4],[nMT,nMZ,nMT,nMT],4,1,wf4(:,4))
  call Hloop_AV_Q(ntryL,G0H32(1),ex5(:),G0H16(1),m3h2x16(:,130),heltab2x32(:,:,130))
  call Hloop_A_Q(ntryL,G0H16(1),16,nMT,G1H16(62),n2h16(130))
  Gcoeff(:)%j = (-(c(16)*M(1,:)%j)) * den(2)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(131),h0tab(:,131),[16,1,10,4],[nMB,nMW,nMB,nMB],4,1,wf4(:,4))
  call Hloop_AV_Q(ntryL,G0H32(1),ex5(:),G0H16(1),m3h2x16(:,131),heltab2x32(:,:,131))
  call Hloop_A_Q(ntryL,G0H16(1),16,nMB,G1H16(63),n2h16(131))
  Gcoeff(:)%j = (c(1)*M(1,:)%j) * den(2)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(132),h0tab(:,132),[16,1,10,4],[nMT,0,nMT,nMT],4,1,wf4(:,4))
  call Hloop_AV_Q(ntryL,G0H32(1),ex5(:),G0H16(1),m3h2x16(:,132),heltab2x32(:,:,132))
  call Hloop_A_Q(ntryL,G0H16(1),16,nMT,G1H16(64),n2h16(132))
  Gcoeff(:)%j = (c(2)*M(1,:)%j) * den(2)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(133),h0tab(:,133),[16,1,10,4],[nMT,nMZ,nMT,nMT],4,1,wf4(:,4))
  call Hloop_AV_Q(ntryL,G0H32(1),ex5(:),G0H16(1),m3h2x16(:,133),heltab2x32(:,:,133))
  call Hloop_A_Q(ntryL,G0H16(1),16,nMT,G1H16(65),n2h16(133))
  Gcoeff(:)%j = (-(c(7)*M(1,:)%j)) * den(2)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(134),h0tab(:,134),[16,1,10,4],[nMB,nMW,nMB,nMB],4,1,wf4(:,4))
  call Hloop_AV_Q(ntryL,G0H32(1),ex5(:),G0H16(1),m3h2x16(:,134),heltab2x32(:,:,134))
  call Hloop_A_Q(ntryL,G0H16(1),16,nMB,G1H16(66),n2h16(134))
  Gcoeff(:)%j = (-(c(17)*M(1,:)%j)) * den(9)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(135),h0tab(:,135),[17,4,2,8],[nMB,nMB,nMW,nMW],4,1,wf4(:,12))
  call Hloop_SQ_A(ntryL,G0H32(1),wf4(:,12),G0H8(1),ngPbt,m3h4x8(:,1),heltab2x32(:,:,135))
  call Hloop_Q_A(ntryL,G0H8(1),17,nMB,G1H8(1),n2h8(13))
  Gcoeff(:)%j = (-(c(17)*M(1,:)%j)) * den(9)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(136),h0tab(:,136),[17,4,2,8],[nMW,nMW,nMB,nMB],4,1,wf4(:,12))
  call Hloop_AQ_S(ntryL,G0H32(1),wf4(:,12),G0H8(1),ngPbt,m3h4x8(:,2),heltab2x32(:,:,136))
  Gcoeff(:)%j = (-(c(8)*M(1,:)%j)) * den(9)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(137),h0tab(:,137),[17,4,2,8],[nMB,nMB,nMW,nMW],4,1,wf4(:,12))
  call Hloop_WQ_A(ntryL,G0H32(1),wf4(:,12),G0H8(2),m3h4x8(:,3),heltab2x32(:,:,137))
  call Hloop_Q_A(ntryL,G0H8(2),17,nMB,G1H8(2),n2h8(14))
  Gcoeff(:)%j = (c(8)*M(1,:)%j) * den(9)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(138),h0tab(:,138),[17,4,2,8],[nMB,nMB,nMW,nMW],4,1,wf4(:,12))
  call Hloop_SQ_A(ntryL,G0H32(1),wf4(:,12),G0H8(2),ngPbt,m3h4x8(:,4),heltab2x32(:,:,138))
  call Hloop_Q_A(ntryL,G0H8(2),17,nMB,G1H8(3),n2h8(15))
  Gcoeff(:)%j = (-(c(8)*M(1,:)%j)) * den(9)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(139),h0tab(:,139),[17,4,2,8],[nMW,nMW,nMB,nMB],4,1,wf4(:,12))
  call Hloop_AQ_W(ntryL,G0H32(1),wf4(:,12),G0H8(2),m3h4x8(:,5),heltab2x32(:,:,139))
  Gcoeff(:)%j = (c(8)*M(1,:)%j) * den(9)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(140),h0tab(:,140),[17,4,2,8],[nMW,nMW,nMB,nMB],4,1,wf4(:,12))
  call Hloop_AQ_S(ntryL,G0H32(1),wf4(:,12),G0H8(3),ngPbt,m3h4x8(:,6),heltab2x32(:,:,140))
  Gcoeff(:)%j = (-(c(8)*M(1,:)%j)) * den(9)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(141),h0tab(:,141),[17,4,2,8],[nMB,nMB,nMW,nMW],4,1,wf4(:,12))
  call Hloop_WQ_A(ntryL,G0H32(1),wf4(:,12),G0H8(4),m3h4x8(:,7),heltab2x32(:,:,141))
  call Hloop_Q_A(ntryL,G0H8(4),17,nMB,G1H8(4),n2h8(16))
  Gcoeff(:)%j = (-(c(8)*M(1,:)%j)) * den(9)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(142),h0tab(:,142),[17,4,2,8],[nMW,nMW,nMB,nMB],4,1,wf4(:,12))
  call Hloop_AQ_W(ntryL,G0H32(1),wf4(:,12),G0H8(4),m3h4x8(:,8),heltab2x32(:,:,142))
  Gcoeff(:)%j = (-(c(24)*M(1,:)%j)) * den(9)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(143),h0tab(:,143),[17,2,4,8],[nMH,nMT,nMT,nMT],4,1,wf4(:,12))
  call Hloop_AQ_S(ntryL,G0H32(1),wf4(:,12),G0H8(5),ngH,m3h4x8(:,9),heltab2x32(:,:,143))
  Gcoeff(:)%j = (c(24)*M(1,:)%j) * den(9)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(144),h0tab(:,144),[17,2,4,8],[nMZ,nMT,nMT,nMT],4,1,wf4(:,12))
  call Hloop_AQ_S(ntryL,G0H32(1),wf4(:,12),G0H8(6),ngX,m3h4x8(:,10),heltab2x32(:,:,144))
  Gcoeff(:)%j = (c(15)*M(1,:)%j) * den(9)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(145),h0tab(:,145),[17,2,4,8],[nMW,nMB,nMB,nMB],4,1,wf4(:,12))
  call Hloop_AQ_S(ntryL,G0H32(1),wf4(:,12),G0H8(7),ngPbt,m3h4x8(:,11),heltab2x32(:,:,145))
  Gcoeff(:)%j = (c(20)*M(1,:)%j) * den(9)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(146),h0tab(:,146),[17,2,4,8],[nMB,nMW,nMW,nMW],4,1,wf4(:,12))
  call Hloop_SQ_A(ntryL,G0H32(1),wf4(:,12),G0H8(8),ngPbt,m3h4x8(:,12),heltab2x32(:,:,146))
  call Hloop_Q_A(ntryL,G0H8(8),17,nMB,G1H8(5),n2h8(17))
  Gcoeff(:)%j = (c(1)*M(1,:)%j) * den(9)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(147),h0tab(:,147),[17,2,4,8],[0,nMT,nMT,nMT],4,1,wf4(:,12))
  call Hloop_AQ_V(ntryL,G0H32(1),wf4(:,12),G0H8(8),m3h4x8(:,13),heltab2x32(:,:,147))
  Gcoeff(:)%j = (c(2)*M(1,:)%j) * den(9)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(148),h0tab(:,148),[17,2,4,8],[nMZ,nMT,nMT,nMT],4,1,wf4(:,12))
  call Hloop_AQ_Z(ntryL,G0H32(1),wf4(:,12),G0H8(9),ngZu,m3h4x8(:,14),heltab2x32(:,:,148))
  Gcoeff(:)%j = (c(6)*M(1,:)%j) * den(9)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(149),h0tab(:,149),[17,2,4,8],[nMW,nMB,nMB,nMB],4,1,wf4(:,12))
  call Hloop_AQ_W(ntryL,G0H32(1),wf4(:,12),G0H8(10),m3h4x8(:,15),heltab2x32(:,:,149))
  Gcoeff(:)%j = (c(11)*M(1,:)%j) * den(9)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(150),h0tab(:,150),[17,2,4,8],[nMB,nMW,nMW,nMW],4,1,wf4(:,12))
  call Hloop_WQ_A(ntryL,G0H32(1),wf4(:,12),G0H8(11),m3h4x8(:,16),heltab2x32(:,:,150))
  call Hloop_Q_A(ntryL,G0H8(11),17,nMB,G1H8(6),n2h8(18))
  Gcoeff(:)%j = (-(c(11)*M(1,:)%j)) * den(9)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(151),h0tab(:,151),[17,2,4,8],[nMB,nMW,nMW,nMW],4,1,wf4(:,12))
  call Hloop_SQ_A(ntryL,G0H32(1),wf4(:,12),G0H8(11),ngPbt,m3h4x8(:,17),heltab2x32(:,:,151))
  call Hloop_Q_A(ntryL,G0H8(11),17,nMB,G1H8(7),n2h8(19))
  Gcoeff(:)%j = (-(c(11)*M(1,:)%j)) * den(9)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(152),h0tab(:,152),[17,2,4,8],[nMB,nMW,nMW,nMW],4,1,wf4(:,12))
  call Hloop_SQ_A(ntryL,G0H32(1),wf4(:,12),G0H8(11),ngPbt,m3h4x8(:,18),heltab2x32(:,:,152))
  call Hloop_Q_A(ntryL,G0H8(11),17,nMB,G1H8(8),n2h8(20))
  Gcoeff(:)%j = (c(11)*M(1,:)%j) * den(9)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(153),h0tab(:,153),[17,2,4,8],[nMB,nMW,nMW,nMW],4,1,wf4(:,12))
  call Hloop_WQ_A(ntryL,G0H32(1),wf4(:,12),G0H8(11),m3h4x8(:,19),heltab2x32(:,:,153))
  call Hloop_Q_A(ntryL,G0H8(11),17,nMB,G1H8(9),n2h8(21))
  Gcoeff(:)%j = (-(c(25)*M(1,:)%j)) * den(9)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(154),h0tab(:,154),[17,2,4,8],[nMB,nMW,nMW,nMW],4,1,wf4(:,12))
  call Hloop_WQ_A(ntryL,G0H32(1),wf4(:,12),G0H8(11),m3h4x8(:,20),heltab2x32(:,:,154))
  call Hloop_Q_A(ntryL,G0H8(11),17,nMB,G1H8(10),n2h8(22))
  Gcoeff(:)%j = (-(c(11)*M(1,:)%j)) * den(9)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(155),h0tab(:,155),[17,2,4,8],[nMB,nMW,nMW,nMW],4,1,wf4(:,12))
  call Hloop_SQ_A(ntryL,G0H32(1),wf4(:,12),G0H8(11),ngPbt,m3h4x8(:,21),heltab2x32(:,:,155))
  call Hloop_Q_A(ntryL,G0H8(11),17,nMB,G1H8(11),n2h8(23))
  Gcoeff(:)%j = (c(11)*M(1,:)%j) * den(9)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(156),h0tab(:,156),[17,2,4,8],[nMB,nMW,nMW,nMW],4,1,wf4(:,12))
  call Hloop_WQ_A(ntryL,G0H32(1),wf4(:,12),G0H8(11),m3h4x8(:,22),heltab2x32(:,:,156))
  call Hloop_Q_A(ntryL,G0H8(11),17,nMB,G1H8(12),n2h8(24))
  Gcoeff(:)%j = (-(c(24)*M(1,:)%j)) * den(9)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(157),h0tab(:,157),[17,2,8,4],[nMH,nMT,nMT,nMT],4,1,wf4(:,12))
  call Hloop_AQ_S(ntryL,G0H32(1),wf4(:,12),G0H8(11),ngH,m3h4x8(:,23),heltab2x32(:,:,157))
  Gcoeff(:)%j = (c(24)*M(1,:)%j) * den(9)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(158),h0tab(:,158),[17,2,8,4],[nMZ,nMT,nMT,nMT],4,1,wf4(:,12))
  call Hloop_AQ_S(ntryL,G0H32(1),wf4(:,12),G0H8(12),ngX,m3h4x8(:,24),heltab2x32(:,:,158))
  Gcoeff(:)%j = (c(15)*M(1,:)%j) * den(9)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(159),h0tab(:,159),[17,2,8,4],[nMW,nMB,nMB,nMB],4,1,wf4(:,12))
  call Hloop_AQ_S(ntryL,G0H32(1),wf4(:,12),G0H8(13),ngPbt,m3h4x8(:,25),heltab2x32(:,:,159))
  Gcoeff(:)%j = (c(20)*M(1,:)%j) * den(9)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(160),h0tab(:,160),[17,2,8,4],[nMB,nMW,nMW,nMW],4,1,wf4(:,12))
  call Hloop_SQ_A(ntryL,G0H32(1),wf4(:,12),G0H8(14),ngPbt,m3h4x8(:,26),heltab2x32(:,:,160))
  call Hloop_Q_A(ntryL,G0H8(14),17,nMB,G1H8(13),n2h8(25))
  Gcoeff(:)%j = (c(1)*M(1,:)%j) * den(9)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(161),h0tab(:,161),[17,2,8,4],[0,nMT,nMT,nMT],4,1,wf4(:,12))
  call Hloop_AQ_V(ntryL,G0H32(1),wf4(:,12),G0H8(14),m3h4x8(:,27),heltab2x32(:,:,161))
  Gcoeff(:)%j = (c(2)*M(1,:)%j) * den(9)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(162),h0tab(:,162),[17,2,8,4],[nMZ,nMT,nMT,nMT],4,1,wf4(:,12))
  call Hloop_AQ_Z(ntryL,G0H32(1),wf4(:,12),G0H8(15),ngZu,m3h4x8(:,28),heltab2x32(:,:,162))
  Gcoeff(:)%j = (c(6)*M(1,:)%j) * den(9)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(163),h0tab(:,163),[17,2,8,4],[nMW,nMB,nMB,nMB],4,1,wf4(:,12))
  call Hloop_AQ_W(ntryL,G0H32(1),wf4(:,12),G0H8(16),m3h4x8(:,29),heltab2x32(:,:,163))
  Gcoeff(:)%j = (c(11)*M(1,:)%j) * den(9)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(164),h0tab(:,164),[17,2,8,4],[nMB,nMW,nMW,nMW],4,1,wf4(:,12))
  call Hloop_WQ_A(ntryL,G0H32(1),wf4(:,12),G0H8(17),m3h4x8(:,30),heltab2x32(:,:,164))
  call Hloop_Q_A(ntryL,G0H8(17),17,nMB,G1H8(14),n2h8(26))
  Gcoeff(:)%j = (-(c(11)*M(1,:)%j)) * den(9)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(165),h0tab(:,165),[17,2,8,4],[nMB,nMW,nMW,nMW],4,1,wf4(:,12))
  call Hloop_SQ_A(ntryL,G0H32(1),wf4(:,12),G0H8(17),ngPbt,m3h4x8(:,31),heltab2x32(:,:,165))
  call Hloop_Q_A(ntryL,G0H8(17),17,nMB,G1H8(15),n2h8(27))
  Gcoeff(:)%j = (-(c(11)*M(1,:)%j)) * den(9)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(166),h0tab(:,166),[17,2,8,4],[nMB,nMW,nMW,nMW],4,1,wf4(:,12))
  call Hloop_SQ_A(ntryL,G0H32(1),wf4(:,12),G0H8(17),ngPbt,m3h4x8(:,32),heltab2x32(:,:,166))
  call Hloop_Q_A(ntryL,G0H8(17),17,nMB,G1H8(16),n2h8(28))
  Gcoeff(:)%j = (c(11)*M(1,:)%j) * den(9)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(167),h0tab(:,167),[17,2,8,4],[nMB,nMW,nMW,nMW],4,1,wf4(:,12))
  call Hloop_WQ_A(ntryL,G0H32(1),wf4(:,12),G0H8(17),m3h4x8(:,33),heltab2x32(:,:,167))
  call Hloop_Q_A(ntryL,G0H8(17),17,nMB,G1H8(17),n2h8(29))
  Gcoeff(:)%j = (-(c(25)*M(1,:)%j)) * den(9)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(168),h0tab(:,168),[17,2,8,4],[nMB,nMW,nMW,nMW],4,1,wf4(:,12))
  call Hloop_WQ_A(ntryL,G0H32(1),wf4(:,12),G0H8(17),m3h4x8(:,34),heltab2x32(:,:,168))
  call Hloop_Q_A(ntryL,G0H8(17),17,nMB,G1H8(18),n2h8(30))
  Gcoeff(:)%j = (-(c(11)*M(1,:)%j)) * den(9)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(169),h0tab(:,169),[17,2,8,4],[nMB,nMW,nMW,nMW],4,1,wf4(:,12))
  call Hloop_SQ_A(ntryL,G0H32(1),wf4(:,12),G0H8(17),ngPbt,m3h4x8(:,35),heltab2x32(:,:,169))
  call Hloop_Q_A(ntryL,G0H8(17),17,nMB,G1H8(19),n2h8(31))
  Gcoeff(:)%j = (c(11)*M(1,:)%j) * den(9)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(170),h0tab(:,170),[17,2,8,4],[nMB,nMW,nMW,nMW],4,1,wf4(:,12))
  call Hloop_WQ_A(ntryL,G0H32(1),wf4(:,12),G0H8(17),m3h4x8(:,36),heltab2x32(:,:,170))
  call Hloop_Q_A(ntryL,G0H8(17),17,nMB,G1H8(20),n2h8(32))
  Gcoeff(:)%j = (-(c(17)*M(1,:)%j)) * den(4)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(171),h0tab(:,171),[18,4,1,8],[nMB,nMB,nMW,nMW],4,1,wf4(:,6))
  call Hloop_SA_Q(ntryL,G0H32(1),wf4(:,6),G0H8(17),ngPtb,m3h4x8(:,37),heltab2x32(:,:,171))
  call Hloop_A_Q(ntryL,G0H8(17),18,nMB,G1H8(21),n2h8(33))
  Gcoeff(:)%j = (-(c(17)*M(1,:)%j)) * den(4)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(172),h0tab(:,172),[18,4,1,8],[nMW,nMW,nMB,nMB],4,1,wf4(:,6))
  call Hloop_QA_S(ntryL,G0H32(1),wf4(:,6),G0H8(17),ngPtb,m3h4x8(:,38),heltab2x32(:,:,172))
  Gcoeff(:)%j = (c(8)*M(1,:)%j) * den(4)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(173),h0tab(:,173),[18,4,1,8],[nMB,nMB,nMW,nMW],4,1,wf4(:,6))
  call Hloop_WA_Q(ntryL,G0H32(1),wf4(:,6),G0H8(18),m3h4x8(:,39),heltab2x32(:,:,173))
  call Hloop_A_Q(ntryL,G0H8(18),18,nMB,G1H8(22),n2h8(34))
  Gcoeff(:)%j = (-(c(8)*M(1,:)%j)) * den(4)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(174),h0tab(:,174),[18,4,1,8],[nMB,nMB,nMW,nMW],4,1,wf4(:,6))
  call Hloop_SA_Q(ntryL,G0H32(1),wf4(:,6),G0H8(18),ngPtb,m3h4x8(:,40),heltab2x32(:,:,174))
  call Hloop_A_Q(ntryL,G0H8(18),18,nMB,G1H8(23),n2h8(35))
  Gcoeff(:)%j = (c(8)*M(1,:)%j) * den(4)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(175),h0tab(:,175),[18,4,1,8],[nMW,nMW,nMB,nMB],4,1,wf4(:,6))
  call Hloop_QA_W(ntryL,G0H32(1),wf4(:,6),G0H8(18),m3h4x8(:,41),heltab2x32(:,:,175))
  Gcoeff(:)%j = (-(c(8)*M(1,:)%j)) * den(4)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(176),h0tab(:,176),[18,4,1,8],[nMW,nMW,nMB,nMB],4,1,wf4(:,6))
  call Hloop_QA_S(ntryL,G0H32(1),wf4(:,6),G0H8(19),ngPtb,m3h4x8(:,42),heltab2x32(:,:,176))
  Gcoeff(:)%j = (-(c(8)*M(1,:)%j)) * den(4)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(177),h0tab(:,177),[18,4,1,8],[nMB,nMB,nMW,nMW],4,1,wf4(:,6))
  call Hloop_WA_Q(ntryL,G0H32(1),wf4(:,6),G0H8(20),m3h4x8(:,43),heltab2x32(:,:,177))
  call Hloop_A_Q(ntryL,G0H8(20),18,nMB,G1H8(24),n2h8(36))
  Gcoeff(:)%j = (-(c(8)*M(1,:)%j)) * den(4)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(178),h0tab(:,178),[18,4,1,8],[nMW,nMW,nMB,nMB],4,1,wf4(:,6))
  call Hloop_QA_W(ntryL,G0H32(1),wf4(:,6),G0H8(20),m3h4x8(:,44),heltab2x32(:,:,178))
  Gcoeff(:)%j = (-(c(24)*M(1,:)%j)) * den(4)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(179),h0tab(:,179),[18,1,4,8],[nMH,nMT,nMT,nMT],4,1,wf4(:,6))
  call Hloop_QA_S(ntryL,G0H32(1),wf4(:,6),G0H8(21),ngH,m3h4x8(:,45),heltab2x32(:,:,179))
  Gcoeff(:)%j = (c(24)*M(1,:)%j) * den(4)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(180),h0tab(:,180),[18,1,4,8],[nMZ,nMT,nMT,nMT],4,1,wf4(:,6))
  call Hloop_QA_S(ntryL,G0H32(1),wf4(:,6),G0H8(22),ngX,m3h4x8(:,46),heltab2x32(:,:,180))
  Gcoeff(:)%j = (c(15)*M(1,:)%j) * den(4)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(181),h0tab(:,181),[18,1,4,8],[nMW,nMB,nMB,nMB],4,1,wf4(:,6))
  call Hloop_QA_S(ntryL,G0H32(1),wf4(:,6),G0H8(23),ngPtb,m3h4x8(:,47),heltab2x32(:,:,181))
  Gcoeff(:)%j = (c(20)*M(1,:)%j) * den(4)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(182),h0tab(:,182),[18,1,4,8],[nMB,nMW,nMW,nMW],4,1,wf4(:,6))
  call Hloop_SA_Q(ntryL,G0H32(1),wf4(:,6),G0H8(24),ngPtb,m3h4x8(:,48),heltab2x32(:,:,182))
  call Hloop_A_Q(ntryL,G0H8(24),18,nMB,G1H8(25),n2h8(37))
  Gcoeff(:)%j = (c(1)*M(1,:)%j) * den(4)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(183),h0tab(:,183),[18,1,4,8],[0,nMT,nMT,nMT],4,1,wf4(:,6))
  call Hloop_QA_V(ntryL,G0H32(1),wf4(:,6),G0H8(24),m3h4x8(:,49),heltab2x32(:,:,183))
  Gcoeff(:)%j = (c(2)*M(1,:)%j) * den(4)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(184),h0tab(:,184),[18,1,4,8],[nMZ,nMT,nMT,nMT],4,1,wf4(:,6))
  call Hloop_QA_Z(ntryL,G0H32(1),wf4(:,6),G0H8(25),ngZu,m3h4x8(:,50),heltab2x32(:,:,184))
  Gcoeff(:)%j = (c(6)*M(1,:)%j) * den(4)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(185),h0tab(:,185),[18,1,4,8],[nMW,nMB,nMB,nMB],4,1,wf4(:,6))
  call Hloop_QA_W(ntryL,G0H32(1),wf4(:,6),G0H8(26),m3h4x8(:,51),heltab2x32(:,:,185))
  Gcoeff(:)%j = (-(c(11)*M(1,:)%j)) * den(4)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(186),h0tab(:,186),[18,1,4,8],[nMB,nMW,nMW,nMW],4,1,wf4(:,6))
  call Hloop_WA_Q(ntryL,G0H32(1),wf4(:,6),G0H8(27),m3h4x8(:,52),heltab2x32(:,:,186))
  call Hloop_A_Q(ntryL,G0H8(27),18,nMB,G1H8(26),n2h8(38))
  Gcoeff(:)%j = (-(c(11)*M(1,:)%j)) * den(4)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(187),h0tab(:,187),[18,1,4,8],[nMB,nMW,nMW,nMW],4,1,wf4(:,6))
  call Hloop_SA_Q(ntryL,G0H32(1),wf4(:,6),G0H8(27),ngPtb,m3h4x8(:,53),heltab2x32(:,:,187))
  call Hloop_A_Q(ntryL,G0H8(27),18,nMB,G1H8(27),n2h8(39))
  Gcoeff(:)%j = (c(11)*M(1,:)%j) * den(4)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(188),h0tab(:,188),[18,1,4,8],[nMB,nMW,nMW,nMW],4,1,wf4(:,6))
  call Hloop_SA_Q(ntryL,G0H32(1),wf4(:,6),G0H8(27),ngPtb,m3h4x8(:,54),heltab2x32(:,:,188))
  call Hloop_A_Q(ntryL,G0H8(27),18,nMB,G1H8(28),n2h8(40))
  Gcoeff(:)%j = (-(c(11)*M(1,:)%j)) * den(4)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(189),h0tab(:,189),[18,1,4,8],[nMB,nMW,nMW,nMW],4,1,wf4(:,6))
  call Hloop_WA_Q(ntryL,G0H32(1),wf4(:,6),G0H8(27),m3h4x8(:,55),heltab2x32(:,:,189))
  call Hloop_A_Q(ntryL,G0H8(27),18,nMB,G1H8(29),n2h8(41))
  Gcoeff(:)%j = (-(c(25)*M(1,:)%j)) * den(4)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(190),h0tab(:,190),[18,1,4,8],[nMB,nMW,nMW,nMW],4,1,wf4(:,6))
  call Hloop_WA_Q(ntryL,G0H32(1),wf4(:,6),G0H8(27),m3h4x8(:,56),heltab2x32(:,:,190))
  call Hloop_A_Q(ntryL,G0H8(27),18,nMB,G1H8(30),n2h8(42))
  Gcoeff(:)%j = (c(11)*M(1,:)%j) * den(4)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(191),h0tab(:,191),[18,1,4,8],[nMB,nMW,nMW,nMW],4,1,wf4(:,6))
  call Hloop_SA_Q(ntryL,G0H32(1),wf4(:,6),G0H8(27),ngPtb,m3h4x8(:,57),heltab2x32(:,:,191))
  call Hloop_A_Q(ntryL,G0H8(27),18,nMB,G1H8(31),n2h8(43))
  Gcoeff(:)%j = (c(11)*M(1,:)%j) * den(4)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(192),h0tab(:,192),[18,1,4,8],[nMB,nMW,nMW,nMW],4,1,wf4(:,6))
  call Hloop_WA_Q(ntryL,G0H32(1),wf4(:,6),G0H8(27),m3h4x8(:,58),heltab2x32(:,:,192))
  call Hloop_A_Q(ntryL,G0H8(27),18,nMB,G1H8(32),n2h8(44))
  Gcoeff(:)%j = (-(c(24)*M(1,:)%j)) * den(4)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(193),h0tab(:,193),[18,1,8,4],[nMH,nMT,nMT,nMT],4,1,wf4(:,6))
  call Hloop_QA_S(ntryL,G0H32(1),wf4(:,6),G0H8(27),ngH,m3h4x8(:,59),heltab2x32(:,:,193))
  Gcoeff(:)%j = (c(24)*M(1,:)%j) * den(4)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(194),h0tab(:,194),[18,1,8,4],[nMZ,nMT,nMT,nMT],4,1,wf4(:,6))
  call Hloop_QA_S(ntryL,G0H32(1),wf4(:,6),G0H8(28),ngX,m3h4x8(:,60),heltab2x32(:,:,194))
  Gcoeff(:)%j = (c(15)*M(1,:)%j) * den(4)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(195),h0tab(:,195),[18,1,8,4],[nMW,nMB,nMB,nMB],4,1,wf4(:,6))
  call Hloop_QA_S(ntryL,G0H32(1),wf4(:,6),G0H8(29),ngPtb,m3h4x8(:,61),heltab2x32(:,:,195))
  Gcoeff(:)%j = (c(20)*M(1,:)%j) * den(4)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(196),h0tab(:,196),[18,1,8,4],[nMB,nMW,nMW,nMW],4,1,wf4(:,6))
  call Hloop_SA_Q(ntryL,G0H32(1),wf4(:,6),G0H8(30),ngPtb,m3h4x8(:,62),heltab2x32(:,:,196))
  call Hloop_A_Q(ntryL,G0H8(30),18,nMB,G1H8(33),n2h8(45))
  Gcoeff(:)%j = (c(1)*M(1,:)%j) * den(4)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(197),h0tab(:,197),[18,1,8,4],[0,nMT,nMT,nMT],4,1,wf4(:,6))
  call Hloop_QA_V(ntryL,G0H32(1),wf4(:,6),G0H8(30),m3h4x8(:,63),heltab2x32(:,:,197))
  Gcoeff(:)%j = (c(2)*M(1,:)%j) * den(4)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(198),h0tab(:,198),[18,1,8,4],[nMZ,nMT,nMT,nMT],4,1,wf4(:,6))
  call Hloop_QA_Z(ntryL,G0H32(1),wf4(:,6),G0H8(31),ngZu,m3h4x8(:,64),heltab2x32(:,:,198))
  Gcoeff(:)%j = (c(6)*M(1,:)%j) * den(4)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(199),h0tab(:,199),[18,1,8,4],[nMW,nMB,nMB,nMB],4,1,wf4(:,6))
  call Hloop_QA_W(ntryL,G0H32(1),wf4(:,6),G0H8(32),m3h4x8(:,65),heltab2x32(:,:,199))
  Gcoeff(:)%j = (-(c(11)*M(1,:)%j)) * den(4)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(200),h0tab(:,200),[18,1,8,4],[nMB,nMW,nMW,nMW],4,1,wf4(:,6))
  call Hloop_WA_Q(ntryL,G0H32(1),wf4(:,6),G0H8(33),m3h4x8(:,66),heltab2x32(:,:,200))
  call Hloop_A_Q(ntryL,G0H8(33),18,nMB,G1H8(34),n2h8(46))
  Gcoeff(:)%j = (-(c(11)*M(1,:)%j)) * den(4)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(201),h0tab(:,201),[18,1,8,4],[nMB,nMW,nMW,nMW],4,1,wf4(:,6))
  call Hloop_SA_Q(ntryL,G0H32(1),wf4(:,6),G0H8(33),ngPtb,m3h4x8(:,67),heltab2x32(:,:,201))
  call Hloop_A_Q(ntryL,G0H8(33),18,nMB,G1H8(35),n2h8(47))
  Gcoeff(:)%j = (c(11)*M(1,:)%j) * den(4)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(202),h0tab(:,202),[18,1,8,4],[nMB,nMW,nMW,nMW],4,1,wf4(:,6))
  call Hloop_SA_Q(ntryL,G0H32(1),wf4(:,6),G0H8(33),ngPtb,m3h4x8(:,68),heltab2x32(:,:,202))
  call Hloop_A_Q(ntryL,G0H8(33),18,nMB,G1H8(36),n2h8(48))
  Gcoeff(:)%j = (-(c(11)*M(1,:)%j)) * den(4)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(203),h0tab(:,203),[18,1,8,4],[nMB,nMW,nMW,nMW],4,1,wf4(:,6))
  call Hloop_WA_Q(ntryL,G0H32(1),wf4(:,6),G0H8(33),m3h4x8(:,69),heltab2x32(:,:,203))
  call Hloop_A_Q(ntryL,G0H8(33),18,nMB,G1H8(37),n2h8(49))
  Gcoeff(:)%j = (-(c(25)*M(1,:)%j)) * den(4)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(204),h0tab(:,204),[18,1,8,4],[nMB,nMW,nMW,nMW],4,1,wf4(:,6))
  call Hloop_WA_Q(ntryL,G0H32(1),wf4(:,6),G0H8(33),m3h4x8(:,70),heltab2x32(:,:,204))
  call Hloop_A_Q(ntryL,G0H8(33),18,nMB,G1H8(38),n2h8(50))
  Gcoeff(:)%j = (c(11)*M(1,:)%j) * den(4)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(205),h0tab(:,205),[18,1,8,4],[nMB,nMW,nMW,nMW],4,1,wf4(:,6))
  call Hloop_SA_Q(ntryL,G0H32(1),wf4(:,6),G0H8(33),ngPtb,m3h4x8(:,71),heltab2x32(:,:,205))
  call Hloop_A_Q(ntryL,G0H8(33),18,nMB,G1H8(39),n2h8(51))
  Gcoeff(:)%j = (c(11)*M(1,:)%j) * den(4)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(206),h0tab(:,206),[18,1,8,4],[nMB,nMW,nMW,nMW],4,1,wf4(:,6))
  call Hloop_WA_Q(ntryL,G0H32(1),wf4(:,6),G0H8(33),m3h4x8(:,72),heltab2x32(:,:,206))
  call Hloop_A_Q(ntryL,G0H8(33),18,nMB,G1H8(40),n2h8(52))
  call Hloop_AQ_S(ntryL,G1H16(1),ex1(:),G1H8(41),ngPbt,m3h2x8(:,69),heltab2x16(:,:,69))
  call Hloop_AQ_W(ntryL,G1H16(2),ex1(:),G1H8(42),m3h2x8(:,70),heltab2x16(:,:,70))
  call Hloop_QA_S(ntryL,G1H16(3),ex2(:),G1H8(43),ngPtb,m3h2x8(:,71),heltab2x16(:,:,71))
  call Hloop_QA_S(ntryL,G1H16(4),ex2(:),G1H8(44),ngPtb,m3h2x8(:,72),heltab2x16(:,:,72))
  call Hloop_QA_W(ntryL,G1H16(5),ex2(:),G1H8(45),m3h2x8(:,73),heltab2x16(:,:,73))
  call Hloop_QA_W(ntryL,G1H16(6),ex2(:),G1H8(46),m3h2x8(:,74),heltab2x16(:,:,74))
  call Hloop_AQ_S(ntryL,G1H16(7),wf4(:,3),G1H4(1),ngH,m3h4x4(:,1),heltab2x16(:,:,75))
  call Hloop_AQ_S(ntryL,G1H16(8),wf4(:,3),G1H4(2),ngX,m3h4x4(:,2),heltab2x16(:,:,76))
  call Hloop_AQ_S(ntryL,G1H16(9),wf4(:,3),G1H4(6),ngPbt,m3h4x4(:,3),heltab2x16(:,:,77))
  call Hloop_AQ_V(ntryL,G1H16(10),wf4(:,3),G1H4(5),m3h4x4(:,4),heltab2x16(:,:,78))
  call Hloop_AQ_Z(ntryL,G1H16(11),wf4(:,3),G1H4(8),ngZu,m3h4x4(:,5),heltab2x16(:,:,79))
  call Hloop_AQ_W(ntryL,G1H16(12),wf4(:,3),G1H4(7),m3h4x4(:,6),heltab2x16(:,:,80))
  call Hloop_QA_S(ntryL,G1H16(13),ex2(:),G1H8(47),ngH,m3h2x8(:,75),heltab2x16(:,:,81))
  call Hloop_QA_S(ntryL,G1H16(14),ex2(:),G1H8(48),ngX,m3h2x8(:,76),heltab2x16(:,:,82))
  call Hloop_QA_S(ntryL,G1H16(15),ex2(:),G1H8(49),ngPtb,m3h2x8(:,77),heltab2x16(:,:,83))
  call Hloop_QA_V(ntryL,G1H16(16),ex2(:),G1H8(50),m3h2x8(:,78),heltab2x16(:,:,84))
  call Hloop_QA_Z(ntryL,G1H16(17),ex2(:),G1H8(51),ngZu,m3h2x8(:,79),heltab2x16(:,:,85))
  call Hloop_QA_W(ntryL,G1H16(18),ex2(:),G1H8(52),m3h2x8(:,80),heltab2x16(:,:,86))
  call Hloop_AQ_S(ntryL,G1H16(19),ex1(:),G1H8(53),ngPbt,m3h2x8(:,81),heltab2x16(:,:,87))
  call Hloop_AQ_S(ntryL,G1H16(20),ex1(:),G1H8(54),ngPbt,m3h2x8(:,82),heltab2x16(:,:,88))
  call Hloop_AQ_W(ntryL,G1H16(21),ex1(:),G1H8(55),m3h2x8(:,83),heltab2x16(:,:,89))
  call Hloop_AQ_W(ntryL,G1H16(22),ex1(:),G1H8(56),m3h2x8(:,84),heltab2x16(:,:,90))
  call Hloop_QA_S(ntryL,G1H16(23),wf4(:,10),G1H4(12),ngH,m3h4x4(:,7),heltab2x16(:,:,91))
  call Hloop_QA_S(ntryL,G1H16(24),wf4(:,10),G1H4(11),ngX,m3h4x4(:,8),heltab2x16(:,:,92))
  call Hloop_QA_S(ntryL,G1H16(25),wf4(:,10),G1H4(14),ngPtb,m3h4x4(:,9),heltab2x16(:,:,93))
  call Hloop_QA_V(ntryL,G1H16(26),wf4(:,10),G1H4(13),m3h4x4(:,10),heltab2x16(:,:,94))
  call Hloop_QA_Z(ntryL,G1H16(27),wf4(:,10),G1H4(17),ngZu,m3h4x4(:,11),heltab2x16(:,:,95))
  call Hloop_QA_W(ntryL,G1H16(28),wf4(:,10),G1H4(18),m3h4x4(:,12),heltab2x16(:,:,96))
  call Hloop_AQ_S(ntryL,G1H16(29),ex1(:),G1H8(57),ngH,m3h2x8(:,85),heltab2x16(:,:,97))
  call Hloop_AQ_S(ntryL,G1H16(30),ex1(:),G1H8(58),ngX,m3h2x8(:,86),heltab2x16(:,:,98))
  call Hloop_AQ_S(ntryL,G1H16(31),ex1(:),G1H8(59),ngPbt,m3h2x8(:,87),heltab2x16(:,:,99))
  call Hloop_AQ_V(ntryL,G1H16(32),ex1(:),G1H8(60),m3h2x8(:,88),heltab2x16(:,:,100))
  call Hloop_AQ_Z(ntryL,G1H16(33),ex1(:),G1H8(61),ngZu,m3h2x8(:,89),heltab2x16(:,:,101))
  call Hloop_AQ_W(ntryL,G1H16(34),ex1(:),G1H8(62),m3h2x8(:,90),heltab2x16(:,:,102))
  call Hloop_QA_S(ntryL,G1H16(35),ex2(:),G1H8(63),ngPtb,m3h2x8(:,91),heltab2x16(:,:,103))
  call Hloop_QA_S(ntryL,G1H16(36),ex2(:),G1H8(64),ngPtb,m3h2x8(:,92),heltab2x16(:,:,104))
  call Hloop_QA_W(ntryL,G1H16(37),ex2(:),G1H8(65),m3h2x8(:,93),heltab2x16(:,:,105))
  call Hloop_QA_W(ntryL,G1H16(38),ex2(:),G1H8(66),m3h2x8(:,94),heltab2x16(:,:,106))
  call Hloop_QV_A(ntryL,G1H16(39),ex3(:),G1H8(67),m3h2x8(:,95),heltab2x16(:,:,107))
  call Hloop_Q_A(ntryL,G1H8(67),20,nMT,G2H8(1),n2h8(53))
  call Hloop_QV_A(ntryL,G1H16(40),ex3(:),G1H8(67),m3h2x8(:,96),heltab2x16(:,:,108))
  call Hloop_Q_A(ntryL,G1H8(67),20,nMT,G2H8(2),n2h8(54))
  call Hloop_QV_A(ntryL,G1H16(41),ex3(:),G1H8(67),m3h2x8(:,97),heltab2x16(:,:,109))
  call Hloop_Q_A(ntryL,G1H8(67),20,nMB,G2H8(3),n2h8(55))
  call Hloop_QV_A(ntryL,G1H16(42),ex3(:),G1H8(67),m3h2x8(:,98),heltab2x16(:,:,110))
  call Hloop_Q_A(ntryL,G1H8(67),20,nMT,G2H8(4),n2h8(56))
  call Hloop_QV_A(ntryL,G1H16(43),ex3(:),G1H8(67),m3h2x8(:,99),heltab2x16(:,:,111))
  call Hloop_Q_A(ntryL,G1H8(67),20,nMT,G2H8(5),n2h8(57))
  call Hloop_QV_A(ntryL,G1H16(44),ex3(:),G1H8(67),m3h2x8(:,100),heltab2x16(:,:,112))
  call Hloop_Q_A(ntryL,G1H8(67),20,nMB,G2H8(6),n2h8(58))
  call Hloop_QA_S(ntryL,G1H16(45),ex2(:),G1H8(67),ngH,m3h2x8(:,101),heltab2x16(:,:,113))
  call Hloop_QA_S(ntryL,G1H16(46),ex2(:),G1H8(68),ngX,m3h2x8(:,102),heltab2x16(:,:,114))
  call Hloop_QA_S(ntryL,G1H16(47),ex2(:),G1H8(69),ngPtb,m3h2x8(:,103),heltab2x16(:,:,115))
  call Hloop_QA_V(ntryL,G1H16(48),ex2(:),G1H8(70),m3h2x8(:,104),heltab2x16(:,:,116))
  call Hloop_QA_Z(ntryL,G1H16(49),ex2(:),G1H8(71),ngZu,m3h2x8(:,105),heltab2x16(:,:,117))
  call Hloop_QA_W(ntryL,G1H16(50),ex2(:),G1H8(72),m3h2x8(:,106),heltab2x16(:,:,118))
  call Hloop_AQ_S(ntryL,G1H16(51),ex1(:),G1H8(73),ngPbt,m3h2x8(:,107),heltab2x16(:,:,119))
  call Hloop_AQ_S(ntryL,G1H16(52),ex1(:),G1H8(74),ngPbt,m3h2x8(:,108),heltab2x16(:,:,120))
  call Hloop_AQ_W(ntryL,G1H16(53),ex1(:),G1H8(75),m3h2x8(:,109),heltab2x16(:,:,121))
  call Hloop_AQ_W(ntryL,G1H16(54),ex1(:),G1H8(76),m3h2x8(:,110),heltab2x16(:,:,122))
  call Hloop_AV_Q(ntryL,G1H16(55),ex3(:),G1H8(77),m3h2x8(:,111),heltab2x16(:,:,123))
  call Hloop_A_Q(ntryL,G1H8(77),20,nMT,G2H8(7),n2h8(59))
  call Hloop_AV_Q(ntryL,G1H16(56),ex3(:),G1H8(77),m3h2x8(:,112),heltab2x16(:,:,124))
  call Hloop_A_Q(ntryL,G1H8(77),20,nMT,G2H8(8),n2h8(60))
  call Hloop_AV_Q(ntryL,G1H16(57),ex3(:),G1H8(77),m3h2x8(:,113),heltab2x16(:,:,125))
  call Hloop_A_Q(ntryL,G1H8(77),20,nMB,G2H8(9),n2h8(61))
  call Hloop_AV_Q(ntryL,G1H16(58),ex3(:),G1H8(77),m3h2x8(:,114),heltab2x16(:,:,126))
  call Hloop_A_Q(ntryL,G1H8(77),20,nMT,G2H8(10),n2h8(62))
  call Hloop_AV_Q(ntryL,G1H16(59),ex3(:),G1H8(77),m3h2x8(:,115),heltab2x16(:,:,127))
  call Hloop_A_Q(ntryL,G1H8(77),20,nMT,G2H8(11),n2h8(63))
  call Hloop_AV_Q(ntryL,G1H16(60),ex3(:),G1H8(77),m3h2x8(:,116),heltab2x16(:,:,128))
  call Hloop_A_Q(ntryL,G1H8(77),20,nMB,G2H8(12),n2h8(64))
  call Hloop_AQ_S(ntryL,G1H16(61),ex1(:),G1H8(77),ngH,m3h2x8(:,117),heltab2x16(:,:,129))
  call Hloop_AQ_S(ntryL,G1H16(62),ex1(:),G1H8(78),ngX,m3h2x8(:,118),heltab2x16(:,:,130))
  call Hloop_AQ_S(ntryL,G1H16(63),ex1(:),G1H8(79),ngPbt,m3h2x8(:,119),heltab2x16(:,:,131))
  call Hloop_AQ_V(ntryL,G1H16(64),ex1(:),G1H8(80),m3h2x8(:,120),heltab2x16(:,:,132))
  call Hloop_AQ_Z(ntryL,G1H16(65),ex1(:),G1H8(81),ngZu,m3h2x8(:,121),heltab2x16(:,:,133))
  call Hloop_AQ_W(ntryL,G1H16(66),ex1(:),G1H8(82),m3h2x8(:,122),heltab2x16(:,:,134))
  call Hloop_QV_A(ntryL,G1H8(1),ex3(:),G1H4(19),m3h2x4(:,69),heltab2x8(:,:,69))
  call Hloop_Q_A(ntryL,G1H4(19),21,nMB,G2H4(41),n2h4(65))
  call Hloop_SV_T(ntryL,G0H8(1),17,ex3(:),4,G1H4(20),m3h2x4(:,70),heltab2x8(:,:,70))
  call Hloop_QV_A(ntryL,G1H8(2),ex3(:),G1H4(23),m3h2x4(:,71),heltab2x8(:,:,71))
  call Hloop_Q_A(ntryL,G1H4(23),21,nMB,G2H4(42),n2h4(66))
  call Hloop_QV_A(ntryL,G1H8(3),ex3(:),G1H4(24),m3h2x4(:,72),heltab2x8(:,:,72))
  call Hloop_Q_A(ntryL,G1H4(24),21,nMB,G2H4(43),n2h4(67))
  call Hloop_VV_S(ntryL,G0H8(2),ex3(:),G0H4(1),m3h2x4(:,73),heltab2x8(:,:,73))
  call Hloop_SV_V(ntryL,G0H8(3),ex3(:),G0H4(2),m3h2x4(:,74),heltab2x8(:,:,74))
  call Hloop_QV_A(ntryL,G1H8(4),ex3(:),G1H4(25),m3h2x4(:,75),heltab2x8(:,:,75))
  call Hloop_Q_A(ntryL,G1H4(25),21,nMB,G2H4(45),n2h4(68))
  call Hloop_UW_V(ntryL,G0H8(4),17,ex3(:),4,G1H4(26),m3h2x4(:,76),heltab2x8(:,:,76))
  call Hloop_SA_Q(ntryL,G0H8(5),ex2(:),G0H4(3),ngH,m3h2x4(:,77),heltab2x8(:,:,77))
  call Hloop_A_Q(ntryL,G0H4(3),19,nMT,G1H4(29),n2h4(69))
  call Hloop_SA_Q(ntryL,G0H8(6),ex2(:),G0H4(3),ngX,m3h2x4(:,78),heltab2x8(:,:,78))
  call Hloop_A_Q(ntryL,G0H4(3),19,nMT,G1H4(30),n2h4(70))
  call Hloop_SA_Q(ntryL,G0H8(7),ex2(:),G0H4(3),ngPtb,m3h2x4(:,79),heltab2x8(:,:,79))
  call Hloop_A_Q(ntryL,G0H4(3),19,nMB,G1H4(31),n2h4(71))
  call Hloop_QA_S(ntryL,G1H8(5),ex2(:),G1H4(32),ngPtb,m3h2x4(:,80),heltab2x8(:,:,80))
  call Hloop_VA_Q(ntryL,G0H8(8),ex2(:),G0H4(3),m3h2x4(:,81),heltab2x8(:,:,81))
  call Hloop_A_Q(ntryL,G0H4(3),19,nMT,G1H4(35),n2h4(72))
  call Hloop_ZA_Q(ntryL,G0H8(9),ex2(:),G0H4(3),ngZu,m3h2x4(:,82),heltab2x8(:,:,82))
  call Hloop_A_Q(ntryL,G0H4(3),19,nMT,G1H4(36),n2h4(73))
  call Hloop_WA_Q(ntryL,G0H8(10),ex2(:),G0H4(3),m3h2x4(:,83),heltab2x8(:,:,83))
  call Hloop_A_Q(ntryL,G0H4(3),19,nMB,G1H4(37),n2h4(74))
  call Hloop_QA_S(ntryL,G1H8(6),ex2(:),G1H4(38),ngPtb,m3h2x4(:,84),heltab2x8(:,:,84))
  call Hloop_QA_S(ntryL,G1H8(7),ex2(:),G1H4(41),ngPtb,m3h2x4(:,85),heltab2x8(:,:,85))
  call Hloop_QA_W(ntryL,G1H8(8),ex2(:),G1H4(42),m3h2x4(:,86),heltab2x8(:,:,86))
  call Hloop_QA_S(ntryL,G1H8(9),ex2(:),G1H4(43),ngPtb,m3h2x4(:,87),heltab2x8(:,:,87))
  call Hloop_QA_W(ntryL,G1H8(10),ex2(:),G1H4(44),m3h2x4(:,88),heltab2x8(:,:,88))
  call Hloop_QA_W(ntryL,G1H8(11),ex2(:),G1H4(47),m3h2x4(:,89),heltab2x8(:,:,89))
  call Hloop_QA_W(ntryL,G1H8(12),ex2(:),G1H4(48),m3h2x4(:,90),heltab2x8(:,:,90))
  call Hloop_SA_Q(ntryL,G0H8(11),ex2(:),G0H4(3),ngH,m3h2x4(:,91),heltab2x8(:,:,91))
  call Hloop_A_Q(ntryL,G0H4(3),19,nMT,G1H4(49),n2h4(75))
  call Hloop_SA_Q(ntryL,G0H8(12),ex2(:),G0H4(3),ngX,m3h2x4(:,92),heltab2x8(:,:,92))
  call Hloop_A_Q(ntryL,G0H4(3),19,nMT,G1H4(50),n2h4(76))
  call Hloop_SA_Q(ntryL,G0H8(13),ex2(:),G0H4(3),ngPtb,m3h2x4(:,93),heltab2x8(:,:,93))
  call Hloop_A_Q(ntryL,G0H4(3),19,nMB,G1H4(53),n2h4(77))
  call Hloop_QA_S(ntryL,G1H8(13),ex2(:),G1H4(54),ngPtb,m3h2x4(:,94),heltab2x8(:,:,94))
  call Hloop_VA_Q(ntryL,G0H8(14),ex2(:),G0H4(3),m3h2x4(:,95),heltab2x8(:,:,95))
  call Hloop_A_Q(ntryL,G0H4(3),19,nMT,G1H4(55),n2h4(78))
  call Hloop_ZA_Q(ntryL,G0H8(15),ex2(:),G0H4(3),ngZu,m3h2x4(:,96),heltab2x8(:,:,96))
  call Hloop_A_Q(ntryL,G0H4(3),19,nMT,G1H4(56),n2h4(79))
  call Hloop_WA_Q(ntryL,G0H8(16),ex2(:),G0H4(3),m3h2x4(:,97),heltab2x8(:,:,97))
  call Hloop_A_Q(ntryL,G0H4(3),19,nMB,G1H4(59),n2h4(80))
  call Hloop_QA_S(ntryL,G1H8(14),ex2(:),G1H4(60),ngPtb,m3h2x4(:,98),heltab2x8(:,:,98))
  call Hloop_QA_S(ntryL,G1H8(15),ex2(:),G1H4(61),ngPtb,m3h2x4(:,99),heltab2x8(:,:,99))
  call Hloop_QA_W(ntryL,G1H8(16),ex2(:),G1H4(62),m3h2x4(:,100),heltab2x8(:,:,100))
  call Hloop_QA_S(ntryL,G1H8(17),ex2(:),G1H4(65),ngPtb,m3h2x4(:,101),heltab2x8(:,:,101))
  call Hloop_QA_W(ntryL,G1H8(18),ex2(:),G1H4(66),m3h2x4(:,102),heltab2x8(:,:,102))
  call Hloop_QA_W(ntryL,G1H8(19),ex2(:),G1H4(67),m3h2x4(:,103),heltab2x8(:,:,103))
  call Hloop_QA_W(ntryL,G1H8(20),ex2(:),G1H4(68),m3h2x4(:,104),heltab2x8(:,:,104))
  call Hloop_AV_Q(ntryL,G1H8(21),ex3(:),G1H4(71),m3h2x4(:,105),heltab2x8(:,:,105))
  call Hloop_A_Q(ntryL,G1H4(71),22,nMB,G2H4(44),n2h4(81))
  call Hloop_TV_S(ntryL,G0H8(17),18,ex3(:),4,G1H4(72),m3h2x4(:,106),heltab2x8(:,:,106))
  call Hloop_AV_Q(ntryL,G1H8(22),ex3(:),G1H4(73),m3h2x4(:,107),heltab2x8(:,:,107))
  call Hloop_A_Q(ntryL,G1H4(73),22,nMB,G2H4(46),n2h4(82))
  call Hloop_AV_Q(ntryL,G1H8(23),ex3(:),G1H4(74),m3h2x4(:,108),heltab2x8(:,:,108))
  call Hloop_A_Q(ntryL,G1H4(74),22,nMB,G2H4(47),n2h4(83))
  call Hloop_VV_S(ntryL,G0H8(18),ex3(:),G0H4(3),m3h2x4(:,109),heltab2x8(:,:,109))
  call Hloop_SV_V(ntryL,G0H8(19),ex3(:),G0H4(4),m3h2x4(:,110),heltab2x8(:,:,110))
  call Hloop_AV_Q(ntryL,G1H8(24),ex3(:),G1H4(77),m3h2x4(:,111),heltab2x8(:,:,111))
  call Hloop_A_Q(ntryL,G1H4(77),22,nMB,G2H4(48),n2h4(84))
  call Hloop_UV_W(ntryL,G0H8(20),18,ex3(:),4,G1H4(78),m3h2x4(:,112),heltab2x8(:,:,112))
  call Hloop_SQ_A(ntryL,G0H8(21),ex1(:),G0H4(5),ngH,m3h2x4(:,113),heltab2x8(:,:,113))
  call Hloop_Q_A(ntryL,G0H4(5),19,nMT,G1H4(79),n2h4(85))
  call Hloop_SQ_A(ntryL,G0H8(22),ex1(:),G0H4(5),ngX,m3h2x4(:,114),heltab2x8(:,:,114))
  call Hloop_Q_A(ntryL,G0H4(5),19,nMT,G1H4(80),n2h4(86))
  call Hloop_SQ_A(ntryL,G0H8(23),ex1(:),G0H4(5),ngPbt,m3h2x4(:,115),heltab2x8(:,:,115))
  call Hloop_Q_A(ntryL,G0H4(5),19,nMB,G1H4(83),n2h4(87))
  call Hloop_AQ_S(ntryL,G1H8(25),ex1(:),G1H4(84),ngPbt,m3h2x4(:,116),heltab2x8(:,:,116))
  call Hloop_VQ_A(ntryL,G0H8(24),ex1(:),G0H4(5),m3h2x4(:,117),heltab2x8(:,:,117))
  call Hloop_Q_A(ntryL,G0H4(5),19,nMT,G1H4(85),n2h4(88))
  call Hloop_ZQ_A(ntryL,G0H8(25),ex1(:),G0H4(5),ngZu,m3h2x4(:,118),heltab2x8(:,:,118))
  call Hloop_Q_A(ntryL,G0H4(5),19,nMT,G1H4(86),n2h4(89))
  call Hloop_WQ_A(ntryL,G0H8(26),ex1(:),G0H4(5),m3h2x4(:,119),heltab2x8(:,:,119))
  call Hloop_Q_A(ntryL,G0H4(5),19,nMB,G1H4(89),n2h4(90))
  call Hloop_AQ_S(ntryL,G1H8(26),ex1(:),G1H4(90),ngPbt,m3h2x4(:,120),heltab2x8(:,:,120))
  call Hloop_AQ_S(ntryL,G1H8(27),ex1(:),G1H4(91),ngPbt,m3h2x4(:,121),heltab2x8(:,:,121))
  call Hloop_AQ_W(ntryL,G1H8(28),ex1(:),G1H4(92),m3h2x4(:,122),heltab2x8(:,:,122))
  call Hloop_AQ_S(ntryL,G1H8(29),ex1(:),G1H4(95),ngPbt,m3h2x4(:,123),heltab2x8(:,:,123))
  call Hloop_AQ_W(ntryL,G1H8(30),ex1(:),G1H4(96),m3h2x4(:,124),heltab2x8(:,:,124))
  call Hloop_AQ_W(ntryL,G1H8(31),ex1(:),G1H4(97),m3h2x4(:,125),heltab2x8(:,:,125))
  call Hloop_AQ_W(ntryL,G1H8(32),ex1(:),G1H4(98),m3h2x4(:,126),heltab2x8(:,:,126))
  call Hloop_SQ_A(ntryL,G0H8(27),ex1(:),G0H4(5),ngH,m3h2x4(:,127),heltab2x8(:,:,127))
  call Hloop_Q_A(ntryL,G0H4(5),19,nMT,G1H4(101),n2h4(91))
  call Hloop_SQ_A(ntryL,G0H8(28),ex1(:),G0H4(5),ngX,m3h2x4(:,128),heltab2x8(:,:,128))
  call Hloop_Q_A(ntryL,G0H4(5),19,nMT,G1H4(102),n2h4(92))
  call Hloop_SQ_A(ntryL,G0H8(29),ex1(:),G0H4(5),ngPbt,m3h2x4(:,129),heltab2x8(:,:,129))
  call Hloop_Q_A(ntryL,G0H4(5),19,nMB,G1H4(103),n2h4(93))
  call Hloop_AQ_S(ntryL,G1H8(33),ex1(:),G1H4(104),ngPbt,m3h2x4(:,130),heltab2x8(:,:,130))
  call Hloop_VQ_A(ntryL,G0H8(30),ex1(:),G0H4(5),m3h2x4(:,131),heltab2x8(:,:,131))
  call Hloop_Q_A(ntryL,G0H4(5),19,nMT,G1H4(107),n2h4(94))
  call Hloop_ZQ_A(ntryL,G0H8(31),ex1(:),G0H4(5),ngZu,m3h2x4(:,132),heltab2x8(:,:,132))
  call Hloop_Q_A(ntryL,G0H4(5),19,nMT,G1H4(108),n2h4(95))
  call Hloop_WQ_A(ntryL,G0H8(32),ex1(:),G0H4(5),m3h2x4(:,133),heltab2x8(:,:,133))
  call Hloop_Q_A(ntryL,G0H4(5),19,nMB,G1H4(109),n2h4(96))
  call Hloop_AQ_S(ntryL,G1H8(34),ex1(:),G1H4(110),ngPbt,m3h2x4(:,134),heltab2x8(:,:,134))
  call Hloop_AQ_S(ntryL,G1H8(35),ex1(:),G1H4(113),ngPbt,m3h2x4(:,135),heltab2x8(:,:,135))
  call Hloop_AQ_W(ntryL,G1H8(36),ex1(:),G1H4(114),m3h2x4(:,136),heltab2x8(:,:,136))
  call Hloop_AQ_S(ntryL,G1H8(37),ex1(:),G1H4(115),ngPbt,m3h2x4(:,137),heltab2x8(:,:,137))
  call Hloop_AQ_W(ntryL,G1H8(38),ex1(:),G1H4(116),m3h2x4(:,138),heltab2x8(:,:,138))
  call Hloop_AQ_W(ntryL,G1H8(39),ex1(:),G1H4(119),m3h2x4(:,139),heltab2x8(:,:,139))
  call Hloop_AQ_W(ntryL,G1H8(40),ex1(:),G1H4(120),m3h2x4(:,140),heltab2x8(:,:,140))
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(1),[G1H4(4)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(2),[G1H4(9)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(6),[G1H4(196),G1H4(15)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(5),[G1H4(22)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(8),[G1H4(28)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(7),[G1H4(202),G1H4(34)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(79),[G1H4(39)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(58),[G1H4(46),G1H4(40)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(86),[G1H4(80),G1H4(45)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(89),[G1H4(83),G1H4(51)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(85),[G1H4(57)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(12),[G1H4(64)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(11),[G1H4(70)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(14),[G1H4(172),G1H4(76)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(13),[G1H4(82)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(17),[G1H4(88)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(18),[G1H4(178),G1H4(94)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(101),[G1H4(99)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(118),[G1H4(106),G1H4(100)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(108),[G1H4(102),G1H4(105)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(109),[G1H4(103),G1H4(111)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(107),[G1H4(117)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(29),[G1H4(123)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(142),[G1H4(130),G1H4(124)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(36),[G1H4(30),G1H4(129)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(37),[G1H4(31),G1H4(135)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(35),[G1H4(141)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(49),[G1H4(147)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(166),[G1H4(154),G1H4(148)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(56),[G1H4(50),G1H4(153)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(59),[G1H4(53),G1H4(159)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(55),[G1H4(165)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(72),[G1H4(171),G0H4(3)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(78),[G1H4(177),G0H4(4)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(20),[G1H4(195),G0H4(1)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(26),[G1H4(201),G0H4(2)])
  call Hloop_SA_Q(ntryL,G1H4(3),ex2(:),G1H2(6),ngH,m3h2x2(:,165),heltab2x4(:,:,165))
  call Hloop_A_Q(ntryL,G1H2(6),23,nMT,G2H2(1),n2h2(109))
  call Hloop_SA_Q(ntryL,G1H4(1),ex2(:),G1H2(12),ngH,m3h2x2(:,166),heltab2x4(:,:,166))
  call Hloop_A_Q(ntryL,G1H2(12),23,nMT,G2H2(2),n2h2(110))
  call Hloop_SA_Q(ntryL,G1H4(10),ex2(:),G1H2(18),ngX,m3h2x2(:,167),heltab2x4(:,:,167))
  call Hloop_A_Q(ntryL,G1H2(18),23,nMT,G2H2(3),n2h2(111))
  call Hloop_SA_Q(ntryL,G1H4(2),ex2(:),G1H2(24),ngX,m3h2x2(:,168),heltab2x4(:,:,168))
  call Hloop_A_Q(ntryL,G1H2(24),23,nMT,G2H2(4),n2h2(112))
  call Hloop_SA_Q(ntryL,G1H4(16),ex2(:),G1H2(30),ngPtb,m3h2x2(:,169),heltab2x4(:,:,169))
  call Hloop_A_Q(ntryL,G1H2(30),23,nMB,G2H2(9),n2h2(113))
  call Hloop_SA_Q(ntryL,G1H4(6),ex2(:),G1H2(41),ngPtb,m3h2x2(:,170),heltab2x4(:,:,170))
  call Hloop_A_Q(ntryL,G1H2(41),23,nMB,G2H2(12),n2h2(114))
  call Hloop_VA_Q(ntryL,G1H4(21),ex2(:),G1H2(52),m3h2x2(:,171),heltab2x4(:,:,171))
  call Hloop_A_Q(ntryL,G1H2(52),23,nMT,G2H2(13),n2h2(115))
  call Hloop_VA_Q(ntryL,G1H4(5),ex2(:),G1H2(63),m3h2x2(:,172),heltab2x4(:,:,172))
  call Hloop_A_Q(ntryL,G1H2(63),23,nMT,G2H2(16),n2h2(116))
  call Hloop_ZA_Q(ntryL,G1H4(27),ex2(:),G1H2(74),ngZu,m3h2x2(:,173),heltab2x4(:,:,173))
  call Hloop_A_Q(ntryL,G1H2(74),23,nMT,G2H2(49),n2h2(117))
  call Hloop_ZA_Q(ntryL,G1H4(8),ex2(:),G1H2(85),ngZu,m3h2x2(:,174),heltab2x4(:,:,174))
  call Hloop_A_Q(ntryL,G1H2(85),23,nMT,G2H2(52),n2h2(118))
  call Hloop_WA_Q(ntryL,G1H4(33),ex2(:),G1H2(96),m3h2x2(:,175),heltab2x4(:,:,175))
  call Hloop_A_Q(ntryL,G1H2(96),23,nMB,G2H2(53),n2h2(119))
  call Hloop_WA_Q(ntryL,G1H4(7),ex2(:),G1H2(107),m3h2x2(:,176),heltab2x4(:,:,176))
  call Hloop_A_Q(ntryL,G1H2(107),23,nMB,G2H2(56),n2h2(120))
  call Hloop_QV_A(ntryL,G1H4(79),ex3(:),G1H2(118),m3h2x2(:,177),heltab2x4(:,:,177))
  call Hloop_Q_A(ntryL,G1H2(118),23,nMT,G2H2(117),n2h2(121))
  call Hloop_QV_A(ntryL,G1H4(58),ex3(:),G1H2(129),m3h2x2(:,178),heltab2x4(:,:,178))
  call Hloop_Q_A(ntryL,G1H2(129),23,nMT,G2H2(120),n2h2(122))
  call Hloop_QV_A(ntryL,G1H4(86),ex3(:),G1H2(140),m3h2x2(:,179),heltab2x4(:,:,179))
  call Hloop_Q_A(ntryL,G1H2(140),23,nMT,G2H2(125),n2h2(123))
  call Hloop_QV_A(ntryL,G1H4(89),ex3(:),G1H2(151),m3h2x2(:,180),heltab2x4(:,:,180))
  call Hloop_Q_A(ntryL,G1H2(151),23,nMB,G2H2(128),n2h2(124))
  call Hloop_QV_A(ntryL,G1H4(52),ex3(:),G1H2(162),m3h2x2(:,181),heltab2x4(:,:,181))
  call Hloop_Q_A(ntryL,G1H2(162),23,nMB,G2H2(133),n2h2(125))
  call Hloop_QV_A(ntryL,G1H4(85),ex3(:),G1H2(173),m3h2x2(:,182),heltab2x4(:,:,182))
  call Hloop_Q_A(ntryL,G1H2(173),23,nMT,G2H2(136),n2h2(126))
  call Hloop_SQ_A(ntryL,G1H4(63),ex1(:),G1H2(184),ngH,m3h2x2(:,183),heltab2x4(:,:,183))
  call Hloop_Q_A(ntryL,G1H2(184),23,nMT,G2H2(149),n2h2(127))
  call Hloop_SQ_A(ntryL,G1H4(12),ex1(:),G1H2(195),ngH,m3h2x2(:,184),heltab2x4(:,:,184))
  call Hloop_Q_A(ntryL,G1H2(195),23,nMT,G2H2(152),n2h2(128))
  call Hloop_SQ_A(ntryL,G1H4(69),ex1(:),G1H2(206),ngX,m3h2x2(:,185),heltab2x4(:,:,185))
  call Hloop_Q_A(ntryL,G1H2(206),23,nMT,G2H2(141),n2h2(129))
  call Hloop_SQ_A(ntryL,G1H4(11),ex1(:),G1H2(217),ngX,m3h2x2(:,186),heltab2x4(:,:,186))
  call Hloop_Q_A(ntryL,G1H2(217),23,nMT,G2H2(145),n2h2(130))
  call Hloop_SQ_A(ntryL,G1H4(75),ex1(:),G1H2(228),ngPbt,m3h2x2(:,187),heltab2x4(:,:,187))
  call Hloop_Q_A(ntryL,G1H2(228),23,nMB,G2H2(157),n2h2(131))
  call Hloop_SQ_A(ntryL,G1H4(14),ex1(:),G1H2(239),ngPbt,m3h2x2(:,188),heltab2x4(:,:,188))
  call Hloop_Q_A(ntryL,G1H2(239),23,nMB,G2H2(161),n2h2(132))
  call Hloop_VQ_A(ntryL,G1H4(81),ex1(:),G1H2(250),m3h2x2(:,189),heltab2x4(:,:,189))
  call Hloop_Q_A(ntryL,G1H2(250),23,nMT,G2H2(5),n2h2(133))
  call Hloop_VQ_A(ntryL,G1H4(13),ex1(:),G1H2(261),m3h2x2(:,190),heltab2x4(:,:,190))
  call Hloop_Q_A(ntryL,G1H2(261),23,nMT,G2H2(8),n2h2(134))
  call Hloop_ZQ_A(ntryL,G1H4(87),ex1(:),G1H2(272),ngZu,m3h2x2(:,191),heltab2x4(:,:,191))
  call Hloop_Q_A(ntryL,G1H2(272),23,nMT,G2H2(21),n2h2(135))
  call Hloop_ZQ_A(ntryL,G1H4(17),ex1(:),G1H2(283),ngZu,m3h2x2(:,192),heltab2x4(:,:,192))
  call Hloop_Q_A(ntryL,G1H2(283),23,nMT,G2H2(24),n2h2(136))
  call Hloop_WQ_A(ntryL,G1H4(93),ex1(:),G1H2(294),m3h2x2(:,193),heltab2x4(:,:,193))
  call Hloop_Q_A(ntryL,G1H2(294),23,nMB,G2H2(25),n2h2(137))
  call Hloop_WQ_A(ntryL,G1H4(18),ex1(:),G1H2(305),m3h2x2(:,194),heltab2x4(:,:,194))
  call Hloop_Q_A(ntryL,G1H2(305),23,nMB,G2H2(28),n2h2(138))
  call Hloop_QV_A(ntryL,G1H4(101),ex4(:),G1H2(316),m3h2x2(:,195),heltab2x4(:,:,195))
  call Hloop_Q_A(ntryL,G1H2(316),27,nMT,G2H2(17),n2h2(139))
  call Hloop_QV_A(ntryL,G1H4(118),ex4(:),G1H2(337),m3h2x2(:,196),heltab2x4(:,:,196))
  call Hloop_Q_A(ntryL,G1H2(337),27,nMT,G2H2(20),n2h2(140))
  call Hloop_QV_A(ntryL,G1H4(108),ex4(:),G1H2(1),m3h2x2(:,197),heltab2x4(:,:,197))
  call Hloop_Q_A(ntryL,G1H2(1),27,nMT,G2H2(29),n2h2(141))
  call Hloop_QV_A(ntryL,G1H4(109),ex4(:),G1H2(2),m3h2x2(:,198),heltab2x4(:,:,198))
  call Hloop_Q_A(ntryL,G1H2(2),27,nMB,G2H2(32),n2h2(142))
  call Hloop_QV_A(ntryL,G1H4(112),ex4(:),G1H2(322),m3h2x2(:,199),heltab2x4(:,:,199))
  call Hloop_Q_A(ntryL,G1H2(322),27,nMB,G2H2(33),n2h2(143))
  call Hloop_QV_A(ntryL,G1H4(107),ex4(:),G1H2(7),m3h2x2(:,200),heltab2x4(:,:,200))
  call Hloop_Q_A(ntryL,G1H2(7),27,nMT,G2H2(36),n2h2(144))
  call Hloop_AV_Q(ntryL,G1H4(29),ex3(:),G1H2(8),m3h2x2(:,201),heltab2x4(:,:,201))
  call Hloop_A_Q(ntryL,G1H2(8),23,nMT,G2H2(37),n2h2(145))
  call Hloop_AV_Q(ntryL,G1H4(142),ex3(:),G1H2(327),m3h2x2(:,202),heltab2x4(:,:,202))
  call Hloop_A_Q(ntryL,G1H2(327),23,nMT,G2H2(40),n2h2(146))
  call Hloop_AV_Q(ntryL,G1H4(36),ex3(:),G1H2(13),m3h2x2(:,203),heltab2x4(:,:,203))
  call Hloop_A_Q(ntryL,G1H2(13),23,nMT,G2H2(41),n2h2(147))
  call Hloop_AV_Q(ntryL,G1H4(37),ex3(:),G1H2(14),m3h2x2(:,204),heltab2x4(:,:,204))
  call Hloop_A_Q(ntryL,G1H2(14),23,nMB,G2H2(44),n2h2(148))
  call Hloop_AV_Q(ntryL,G1H4(136),ex3(:),G1H2(343),m3h2x2(:,205),heltab2x4(:,:,205))
  call Hloop_A_Q(ntryL,G1H2(343),23,nMB,G2H2(45),n2h2(149))
  call Hloop_AV_Q(ntryL,G1H4(35),ex3(:),G1H2(19),m3h2x2(:,206),heltab2x4(:,:,206))
  call Hloop_A_Q(ntryL,G1H2(19),23,nMT,G2H2(48),n2h2(150))
  call Hloop_AV_Q(ntryL,G1H4(49),ex4(:),G1H2(20),m3h2x2(:,207),heltab2x4(:,:,207))
  call Hloop_A_Q(ntryL,G1H2(20),27,nMT,G2H2(61),n2h2(151))
  call Hloop_AV_Q(ntryL,G1H4(166),ex4(:),G1H2(348),m3h2x2(:,208),heltab2x4(:,:,208))
  call Hloop_A_Q(ntryL,G1H2(348),27,nMT,G2H2(64),n2h2(152))
  call Hloop_AV_Q(ntryL,G1H4(56),ex4(:),G1H2(25),m3h2x2(:,209),heltab2x4(:,:,209))
  call Hloop_A_Q(ntryL,G1H2(25),27,nMT,G2H2(65),n2h2(153))
  call Hloop_AV_Q(ntryL,G1H4(59),ex4(:),G1H2(26),m3h2x2(:,210),heltab2x4(:,:,210))
  call Hloop_A_Q(ntryL,G1H2(26),27,nMB,G2H2(68),n2h2(154))
  call Hloop_AV_Q(ntryL,G1H4(160),ex4(:),G1H2(31),m3h2x2(:,211),heltab2x4(:,:,211))
  call Hloop_A_Q(ntryL,G1H2(31),27,nMB,G2H2(57),n2h2(155))
  call Hloop_AV_Q(ntryL,G1H4(55),ex4(:),G1H2(32),m3h2x2(:,212),heltab2x4(:,:,212))
  call Hloop_A_Q(ntryL,G1H2(32),27,nMT,G2H2(60),n2h2(156))
  call Hloop_SQ_A(ntryL,G1H4(72),ex1(:),G1H2(36),ngPbt,m3h2x2(:,213),heltab2x4(:,:,213))
  call Hloop_Q_A(ntryL,G1H2(36),23,nMB,G2H2(69),n2h2(157))
  call Hloop_WQ_A(ntryL,G1H4(78),ex1(:),G1H2(37),m3h2x2(:,214),heltab2x4(:,:,214))
  call Hloop_Q_A(ntryL,G1H2(37),23,nMB,G2H2(72),n2h2(158))
  call Hloop_SQ_A(ntryL,G1H4(183),ex1(:),G1H2(42),ngPbt,m3h2x2(:,215),heltab2x4(:,:,215))
  call Hloop_Q_A(ntryL,G1H2(42),27,nMB,G2H2(73),n2h2(159))
  call Hloop_SQ_A(ntryL,G1H4(184),ex1(:),G1H2(43),ngPbt,m3h2x2(:,216),heltab2x4(:,:,216))
  call Hloop_Q_A(ntryL,G1H2(43),27,nMB,G2H2(76),n2h2(160))
  call Hloop_WQ_A(ntryL,G1H4(189),ex1(:),G1H2(47),m3h2x2(:,217),heltab2x4(:,:,217))
  call Hloop_Q_A(ntryL,G1H2(47),27,nMB,G2H2(77),n2h2(161))
  call Hloop_WQ_A(ntryL,G1H4(190),ex1(:),G1H2(48),m3h2x2(:,218),heltab2x4(:,:,218))
  call Hloop_Q_A(ntryL,G1H2(48),27,nMB,G2H2(80),n2h2(162))
  call Hloop_SA_Q(ntryL,G1H4(20),ex2(:),G1H2(53),ngPtb,m3h2x2(:,219),heltab2x4(:,:,219))
  call Hloop_A_Q(ntryL,G1H2(53),23,nMB,G2H2(81),n2h2(163))
  call Hloop_WA_Q(ntryL,G1H4(26),ex2(:),G1H2(54),m3h2x2(:,220),heltab2x4(:,:,220))
  call Hloop_A_Q(ntryL,G1H2(54),23,nMB,G2H2(84),n2h2(164))
  call Hloop_SV_T(ntryL,G1H4(207),21,ex4(:),8,G2H2(85),m3h2x2(:,221),heltab2x4(:,:,221))
  call Hloop_SV_T(ntryL,G1H4(208),21,ex4(:),8,G2H2(88),m3h2x2(:,222),heltab2x4(:,:,222))
  call Hloop_UW_V(ntryL,G1H4(213),21,ex4(:),8,G2H2(89),m3h2x2(:,223),heltab2x4(:,:,223))
  call Hloop_UW_V(ntryL,G1H4(214),21,ex4(:),8,G2H2(92),m3h2x2(:,224),heltab2x4(:,:,224))
  call Hloop_SA_Q(ntryL,G1H4(219),ex2(:),G1H2(58),ngPtb,m3h2x2(:,225),heltab2x4(:,:,225))
  call Hloop_A_Q(ntryL,G1H2(58),27,nMB,G2H2(93),n2h2(165))
  call Hloop_SA_Q(ntryL,G1H4(220),ex2(:),G1H2(59),ngPtb,m3h2x2(:,226),heltab2x4(:,:,226))
  call Hloop_A_Q(ntryL,G1H2(59),27,nMB,G2H2(96),n2h2(166))
  call Hloop_WA_Q(ntryL,G1H4(225),ex2(:),G1H2(64),m3h2x2(:,227),heltab2x4(:,:,227))
  call Hloop_A_Q(ntryL,G1H2(64),27,nMB,G2H2(97),n2h2(167))
  call Hloop_WA_Q(ntryL,G1H4(226),ex2(:),G1H2(65),m3h2x2(:,228),heltab2x4(:,:,228))
  call Hloop_A_Q(ntryL,G1H2(65),27,nMB,G2H2(100),n2h2(168))
  call Hloop_SV_T(ntryL,G1H4(231),25,ex3(:),4,G2H2(101),m3h2x2(:,229),heltab2x4(:,:,229))
  call Hloop_SV_T(ntryL,G1H4(232),25,ex3(:),4,G2H2(104),m3h2x2(:,230),heltab2x4(:,:,230))
  call Hloop_UW_V(ntryL,G1H4(237),25,ex3(:),4,G2H2(105),m3h2x2(:,231),heltab2x4(:,:,231))
  call Hloop_UW_V(ntryL,G1H4(238),25,ex3(:),4,G2H2(108),m3h2x2(:,232),heltab2x4(:,:,232))
  call Hloop_SVV_S(ntryL,G1H8(41),ex4(:),ex3(:),G1H2(69),m4h2x2x2(:,1),heltab3x8(:,:,1))
  call Hloop_VWW_V(ntryL,G1H8(42),ex4(:),ex3(:),G1H2(70),m4h2x2x2(:,2),heltab3x8(:,:,2))
  call Hloop_TV_S(ntryL,G1H8(43),18,ex4(:),8,G2H4(49),m3h2x4(:,141),heltab2x8(:,:,141))
  call Hloop_SV_V(ntryL,G1H8(44),ex4(:),G1H4(121),m3h2x4(:,142),heltab2x8(:,:,142))
  call Hloop_VV_S(ntryL,G1H8(45),ex4(:),G1H4(122),m3h2x4(:,143),heltab2x8(:,:,143))
  call Hloop_UV_W(ntryL,G1H8(46),18,ex4(:),8,G2H4(51),m3h2x4(:,144),heltab2x8(:,:,144))
  call Hloop_SQ_A(ntryL,G1H8(47),wf4(:,3),G1H2(75),ngH,m3h4x2(:,1),heltab2x8(:,:,145))
  call Hloop_Q_A(ntryL,G1H2(75),23,nMT,G2H2(109),n2h2(169))
  call Hloop_SQ_A(ntryL,G1H8(48),wf4(:,3),G1H2(76),ngX,m3h4x2(:,2),heltab2x8(:,:,146))
  call Hloop_Q_A(ntryL,G1H2(76),23,nMT,G2H2(112),n2h2(170))
  call Hloop_SQ_A(ntryL,G1H8(49),wf4(:,3),G1H2(80),ngPbt,m3h4x2(:,3),heltab2x8(:,:,147))
  call Hloop_Q_A(ntryL,G1H2(80),23,nMB,G2H2(113),n2h2(171))
  call Hloop_VQ_A(ntryL,G1H8(50),wf4(:,3),G1H2(81),m3h4x2(:,4),heltab2x8(:,:,148))
  call Hloop_Q_A(ntryL,G1H2(81),23,nMT,G2H2(116),n2h2(172))
  call Hloop_ZQ_A(ntryL,G1H8(51),wf4(:,3),G1H2(86),ngZu,m3h4x2(:,5),heltab2x8(:,:,149))
  call Hloop_Q_A(ntryL,G1H2(86),23,nMT,G2H2(121),n2h2(173))
  call Hloop_WQ_A(ntryL,G1H8(52),wf4(:,3),G1H2(87),m3h4x2(:,6),heltab2x8(:,:,150))
  call Hloop_Q_A(ntryL,G1H2(87),23,nMB,G2H2(124),n2h2(174))
  call Hloop_SV_T(ntryL,G1H8(53),17,ex4(:),8,G2H4(50),m3h2x4(:,145),heltab2x8(:,:,151))
  call Hloop_SV_V(ntryL,G1H8(54),ex4(:),G1H4(125),m3h2x4(:,146),heltab2x8(:,:,152))
  call Hloop_VV_S(ntryL,G1H8(55),ex4(:),G1H4(126),m3h2x4(:,147),heltab2x8(:,:,153))
  call Hloop_UW_V(ntryL,G1H8(56),17,ex4(:),8,G2H4(52),m3h2x4(:,148),heltab2x8(:,:,154))
  call Hloop_SA_Q(ntryL,G1H8(57),wf4(:,10),G1H2(91),ngH,m3h4x2(:,7),heltab2x8(:,:,155))
  call Hloop_A_Q(ntryL,G1H2(91),23,nMT,G2H2(129),n2h2(175))
  call Hloop_SA_Q(ntryL,G1H8(58),wf4(:,10),G1H2(92),ngX,m3h4x2(:,8),heltab2x8(:,:,156))
  call Hloop_A_Q(ntryL,G1H2(92),23,nMT,G2H2(132),n2h2(176))
  call Hloop_SA_Q(ntryL,G1H8(59),wf4(:,10),G1H2(97),ngPtb,m3h4x2(:,9),heltab2x8(:,:,157))
  call Hloop_A_Q(ntryL,G1H2(97),23,nMB,G2H2(137),n2h2(177))
  call Hloop_VA_Q(ntryL,G1H8(60),wf4(:,10),G1H2(98),m3h4x2(:,10),heltab2x8(:,:,158))
  call Hloop_A_Q(ntryL,G1H2(98),23,nMT,G2H2(140),n2h2(178))
  call Hloop_ZA_Q(ntryL,G1H8(61),wf4(:,10),G1H2(102),ngZu,m3h4x2(:,11),heltab2x8(:,:,159))
  call Hloop_A_Q(ntryL,G1H2(102),23,nMT,G2H2(144),n2h2(179))
  call Hloop_WA_Q(ntryL,G1H8(62),wf4(:,10),G1H2(103),m3h4x2(:,12),heltab2x8(:,:,160))
  call Hloop_A_Q(ntryL,G1H2(103),23,nMB,G2H2(148),n2h2(180))
  call Hloop_TV_S(ntryL,G1H8(63),18,ex3(:),4,G2H4(8),m3h2x4(:,149),heltab2x8(:,:,161))
  call Hloop_SV_V(ntryL,G1H8(64),ex3(:),G1H4(127),m3h2x4(:,150),heltab2x8(:,:,162))
  call Hloop_VV_S(ntryL,G1H8(65),ex3(:),G1H4(128),m3h2x4(:,151),heltab2x8(:,:,163))
  call Hloop_UV_W(ntryL,G1H8(66),18,ex3(:),4,G2H4(9),m3h2x4(:,152),heltab2x8(:,:,164))
  call Hloop_QA_S(ntryL,G2H8(1),ex2(:),G2H4(20),ngH,m3h2x4(:,153),heltab2x8(:,:,165))
  call Hloop_QA_S(ntryL,G2H8(2),ex2(:),G2H4(21),ngX,m3h2x4(:,154),heltab2x8(:,:,166))
  call Hloop_QA_S(ntryL,G2H8(3),ex2(:),G2H4(26),ngPtb,m3h2x4(:,155),heltab2x8(:,:,167))
  call Hloop_QA_V(ntryL,G2H8(4),ex2(:),G2H4(27),m3h2x4(:,156),heltab2x8(:,:,168))
  call Hloop_QA_Z(ntryL,G2H8(5),ex2(:),G2H4(32),ngZu,m3h2x4(:,157),heltab2x8(:,:,169))
  call Hloop_QA_W(ntryL,G2H8(6),ex2(:),G2H4(33),m3h2x4(:,158),heltab2x8(:,:,170))
  call Hloop_SQ_A(ntryL,G1H8(67),wf4(:,9),G1H2(108),ngH,m3h4x2(:,13),heltab2x8(:,:,171))
  call Hloop_Q_A(ntryL,G1H2(108),27,nMT,G2H2(153),n2h2(181))
  call Hloop_SQ_A(ntryL,G1H8(68),wf4(:,9),G1H2(109),ngX,m3h4x2(:,14),heltab2x8(:,:,172))
  call Hloop_Q_A(ntryL,G1H2(109),27,nMT,G2H2(156),n2h2(182))
  call Hloop_SQ_A(ntryL,G1H8(69),wf4(:,9),G1H2(113),ngPbt,m3h4x2(:,15),heltab2x8(:,:,173))
  call Hloop_Q_A(ntryL,G1H2(113),27,nMB,G2H2(160),n2h2(183))
  call Hloop_VQ_A(ntryL,G1H8(70),wf4(:,9),G1H2(114),m3h4x2(:,16),heltab2x8(:,:,174))
  call Hloop_Q_A(ntryL,G1H2(114),27,nMT,G2H2(164),n2h2(184))
  call Hloop_ZQ_A(ntryL,G1H8(71),wf4(:,9),G1H2(119),ngZu,m3h4x2(:,17),heltab2x8(:,:,175))
  call Hloop_Q_A(ntryL,G1H2(119),27,nMT,G2H2(165),n2h2(185))
  call Hloop_WQ_A(ntryL,G1H8(72),wf4(:,9),G1H2(120),m3h4x2(:,18),heltab2x8(:,:,176))
  call Hloop_Q_A(ntryL,G1H2(120),27,nMB,G2H2(166),n2h2(186))
  call Hloop_SV_T(ntryL,G1H8(73),17,ex3(:),4,G2H4(1),m3h2x4(:,159),heltab2x8(:,:,177))
  call Hloop_SV_V(ntryL,G1H8(74),ex3(:),G1H4(131),m3h2x4(:,160),heltab2x8(:,:,178))
  call Hloop_VV_S(ntryL,G1H8(75),ex3(:),G1H4(132),m3h2x4(:,161),heltab2x8(:,:,179))
  call Hloop_UW_V(ntryL,G1H8(76),17,ex3(:),4,G2H4(2),m3h2x4(:,162),heltab2x8(:,:,180))
  call Hloop_AQ_S(ntryL,G2H8(7),ex1(:),G2H4(3),ngH,m3h2x4(:,163),heltab2x8(:,:,181))
  call Hloop_AQ_S(ntryL,G2H8(8),ex1(:),G2H4(4),ngX,m3h2x4(:,164),heltab2x8(:,:,182))
  call Hloop_AQ_S(ntryL,G2H8(9),ex1(:),G2H4(5),ngPbt,m3h2x4(:,165),heltab2x8(:,:,183))
  call Hloop_AQ_V(ntryL,G2H8(10),ex1(:),G2H4(6),m3h2x4(:,166),heltab2x8(:,:,184))
  call Hloop_AQ_Z(ntryL,G2H8(11),ex1(:),G2H4(7),ngZu,m3h2x4(:,167),heltab2x8(:,:,185))
  call Hloop_AQ_W(ntryL,G2H8(12),ex1(:),G2H4(11),m3h2x4(:,168),heltab2x8(:,:,186))
  call Hloop_SA_Q(ntryL,G1H8(77),wf4(:,4),G1H2(124),ngH,m3h4x2(:,19),heltab2x8(:,:,187))
  call Hloop_A_Q(ntryL,G1H2(124),27,nMT,G2H2(167),n2h2(187))
  call Hloop_SA_Q(ntryL,G1H8(78),wf4(:,4),G1H2(125),ngX,m3h4x2(:,20),heltab2x8(:,:,188))
  call Hloop_A_Q(ntryL,G1H2(125),27,nMT,G2H2(168),n2h2(188))
  call Hloop_SA_Q(ntryL,G1H8(79),wf4(:,4),G1H2(130),ngPtb,m3h4x2(:,21),heltab2x8(:,:,189))
  call Hloop_A_Q(ntryL,G1H2(130),27,nMB,G2H2(169),n2h2(189))
  call Hloop_VA_Q(ntryL,G1H8(80),wf4(:,4),G1H2(131),m3h4x2(:,22),heltab2x8(:,:,190))
  call Hloop_A_Q(ntryL,G1H2(131),27,nMT,G2H2(170),n2h2(190))
  call Hloop_ZA_Q(ntryL,G1H8(81),wf4(:,4),G1H2(135),ngZu,m3h4x2(:,23),heltab2x8(:,:,191))
  call Hloop_A_Q(ntryL,G1H2(135),27,nMT,G2H2(171),n2h2(191))
  call Hloop_WA_Q(ntryL,G1H8(82),wf4(:,4),G1H2(136),m3h4x2(:,24),heltab2x8(:,:,192))
  call Hloop_A_Q(ntryL,G1H2(136),27,nMB,G2H2(172),n2h2(192))
  call Hloop_QA_S(ntryL,G2H4(41),ex2(:),G2H2(173),ngPtb,m3h2x2(:,233),heltab2x4(:,:,233))
  call Hloop_QA_S(ntryL,G2H4(42),ex2(:),G2H2(174),ngPtb,m3h2x2(:,234),heltab2x4(:,:,234))
  call Hloop_QA_W(ntryL,G2H4(43),ex2(:),G2H2(175),m3h2x2(:,235),heltab2x4(:,:,235))
  call Hloop_QA_W(ntryL,G2H4(45),ex2(:),G2H2(176),m3h2x2(:,236),heltab2x4(:,:,236))
  call Hloop_TV_S(ntryL,G1H4(32),19,ex3(:),4,G2H2(177),m3h2x2(:,237),heltab2x4(:,:,237))
  call Hloop_TV_S(ntryL,G1H4(38),19,ex3(:),4,G2H2(178),m3h2x2(:,238),heltab2x4(:,:,238))
  call Hloop_SV_V(ntryL,G1H4(41),ex3(:),G1H2(141),m3h2x2(:,239),heltab2x4(:,:,239))
  call Hloop_VV_S(ntryL,G1H4(42),ex3(:),G1H2(142),m3h2x2(:,240),heltab2x4(:,:,240))
  call Hloop_SV_V(ntryL,G1H4(43),ex3(:),G1H2(146),m3h2x2(:,241),heltab2x4(:,:,241))
  call Hloop_VV_S(ntryL,G1H4(44),ex3(:),G1H2(147),m3h2x2(:,242),heltab2x4(:,:,242))
  call Hloop_UV_W(ntryL,G1H4(47),19,ex3(:),4,G2H2(179),m3h2x2(:,243),heltab2x4(:,:,243))
  call Hloop_UV_W(ntryL,G1H4(48),19,ex3(:),4,G2H2(180),m3h2x2(:,244),heltab2x4(:,:,244))
  call Hloop_TV_S(ntryL,G1H4(54),19,ex4(:),8,G2H2(181),m3h2x2(:,245),heltab2x4(:,:,245))
  call Hloop_TV_S(ntryL,G1H4(60),19,ex4(:),8,G2H2(182),m3h2x2(:,246),heltab2x4(:,:,246))
  call Hloop_SV_V(ntryL,G1H4(61),ex4(:),G1H2(152),m3h2x2(:,247),heltab2x4(:,:,247))
  call Hloop_VV_S(ntryL,G1H4(62),ex4(:),G1H2(153),m3h2x2(:,248),heltab2x4(:,:,248))
  call Hloop_SV_V(ntryL,G1H4(65),ex4(:),G1H2(157),m3h2x2(:,249),heltab2x4(:,:,249))
  call Hloop_VV_S(ntryL,G1H4(66),ex4(:),G1H2(158),m3h2x2(:,250),heltab2x4(:,:,250))
  call Hloop_UV_W(ntryL,G1H4(67),19,ex4(:),8,G2H2(183),m3h2x2(:,251),heltab2x4(:,:,251))
  call Hloop_UV_W(ntryL,G1H4(68),19,ex4(:),8,G2H2(184),m3h2x2(:,252),heltab2x4(:,:,252))
  call Hloop_AQ_S(ntryL,G2H4(44),ex1(:),G2H2(185),ngPbt,m3h2x2(:,253),heltab2x4(:,:,253))
  call Hloop_AQ_S(ntryL,G2H4(46),ex1(:),G2H2(186),ngPbt,m3h2x2(:,254),heltab2x4(:,:,254))
  call Hloop_AQ_W(ntryL,G2H4(47),ex1(:),G2H2(187),m3h2x2(:,255),heltab2x4(:,:,255))
  call Hloop_AQ_W(ntryL,G2H4(48),ex1(:),G2H2(188),m3h2x2(:,256),heltab2x4(:,:,256))
  call Hloop_SV_T(ntryL,G1H4(84),19,ex3(:),4,G2H2(189),m3h2x2(:,257),heltab2x4(:,:,257))
  call Hloop_SV_T(ntryL,G1H4(90),19,ex3(:),4,G2H2(190),m3h2x2(:,258),heltab2x4(:,:,258))
  call Hloop_SV_V(ntryL,G1H4(91),ex3(:),G1H2(163),m3h2x2(:,259),heltab2x4(:,:,259))
  call Hloop_VV_S(ntryL,G1H4(92),ex3(:),G1H2(164),m3h2x2(:,260),heltab2x4(:,:,260))
  call Hloop_SV_V(ntryL,G1H4(95),ex3(:),G1H2(168),m3h2x2(:,261),heltab2x4(:,:,261))
  call Hloop_VV_S(ntryL,G1H4(96),ex3(:),G1H2(169),m3h2x2(:,262),heltab2x4(:,:,262))
  call Hloop_UW_V(ntryL,G1H4(97),19,ex3(:),4,G2H2(191),m3h2x2(:,263),heltab2x4(:,:,263))
  call Hloop_UW_V(ntryL,G1H4(98),19,ex3(:),4,G2H2(192),m3h2x2(:,264),heltab2x4(:,:,264))
  call Hloop_SV_T(ntryL,G1H4(104),19,ex4(:),8,G2H2(193),m3h2x2(:,265),heltab2x4(:,:,265))
  call Hloop_SV_T(ntryL,G1H4(110),19,ex4(:),8,G2H2(194),m3h2x2(:,266),heltab2x4(:,:,266))
  call Hloop_SV_V(ntryL,G1H4(113),ex4(:),G1H2(174),m3h2x2(:,267),heltab2x4(:,:,267))
  call Hloop_VV_S(ntryL,G1H4(114),ex4(:),G1H2(175),m3h2x2(:,268),heltab2x4(:,:,268))
  call Hloop_SV_V(ntryL,G1H4(115),ex4(:),G1H2(179),m3h2x2(:,269),heltab2x4(:,:,269))
  call Hloop_VV_S(ntryL,G1H4(116),ex4(:),G1H2(180),m3h2x2(:,270),heltab2x4(:,:,270))
  call Hloop_UW_V(ntryL,G1H4(119),19,ex4(:),8,G2H2(195),m3h2x2(:,271),heltab2x4(:,:,271))
  call Hloop_UW_V(ntryL,G1H4(120),19,ex4(:),8,G2H2(196),m3h2x2(:,272),heltab2x4(:,:,272))
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(23),[G2H2(19),G2H2(11),G2H2(7),G1H2(62),G1H2(40) &
    ,G1H2(29)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(27),[G2H2(15),G1H2(51)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(109),[G2H2(31),G1H2(73)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(121),[G2H2(112),G2H2(35),G1H2(84)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(124),[G2H2(113),G2H2(123),G2H2(119),G2H2(39),G1H2(293) &
    ,G1H2(95)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(116),[G2H2(43),G1H2(106)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(63),[G2H2(59),G2H2(51),G2H2(47),G1H2(150),G1H2(128) &
    ,G1H2(117)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(67),[G2H2(55),G1H2(139)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(149),[G1H2(115)])
call HGT_OLR(G2H2(70),1,1,2)
call HGT_invQ_OLR(G2H2(70),2,5,2)
call HGT_OLR(G2H2(70),6,15,2)
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(70),[G2H2(149)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(153),[G2H2(71),G1H2(161)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(21),[G2H2(141),G1H2(126)])
call HGT_OLR(G2H2(74),1,1,2)
call HGT_invQ_OLR(G2H2(74),2,5,2)
call HGT_OLR(G2H2(74),6,15,2)
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(74),[G2H2(21)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(165),[G2H2(156),G2H2(75),G1H2(172)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(25),[G2H2(157),G1H2(137)])
call HGT_OLR(G2H2(78),1,1,2)
call HGT_invQ_OLR(G2H2(78),2,5,2)
call HGT_OLR(G2H2(78),6,15,2)
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(78),[G2H2(25)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(166),[G2H2(160),G2H2(131),G2H2(127),G2H2(79),G1H2(304) &
    ,G1H2(183)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(5),[G1H2(148)])
call HGT_OLR(G2H2(82),1,1,2)
call HGT_invQ_OLR(G2H2(82),2,5,2)
call HGT_OLR(G2H2(82),6,15,2)
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(82),[G2H2(5)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(164),[G2H2(83),G1H2(194)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(129),[G2H2(87),G1H2(205)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(144),[G2H2(132),G2H2(91),G1H2(216)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(148),[G2H2(137),G2H2(139),G2H2(135),G2H2(95),G1H2(315) &
    ,G1H2(227)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(140),[G2H2(99),G1H2(238)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(1),[G1H2(27)])
call HGT_OLR(G2H2(102),1,1,2)
call HGT_invQ_OLR(G2H2(102),2,5,2)
call HGT_OLR(G2H2(102),6,15,2)
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(102),[G2H2(1)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(167),[G2H2(103),G1H2(249)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(49),[G2H2(3),G1H2(38)])
call HGT_OLR(G2H2(106),1,1,2)
call HGT_invQ_OLR(G2H2(106),2,5,2)
call HGT_OLR(G2H2(106),6,15,2)
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(106),[G2H2(49)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(171),[G2H2(168),G2H2(107),G1H2(260)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(53),[G2H2(9),G1H2(49)])
call HGT_OLR(G2H2(110),1,1,2)
call HGT_invQ_OLR(G2H2(110),2,5,2)
call HGT_OLR(G2H2(110),6,15,2)
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(110),[G2H2(53)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(172),[G2H2(169),G2H2(155),G2H2(151),G2H2(111),G1H2(336) &
    ,G1H2(271)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(13),[G1H2(60)])
call HGT_OLR(G2H2(114),1,1,2)
call HGT_invQ_OLR(G2H2(114),2,5,2)
call HGT_OLR(G2H2(114),6,15,2)
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(114),[G2H2(13)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(170),[G2H2(115),G1H2(282)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(189),[G1H2(164)])
call HGT_OLR(G2H2(142),1,1,2)
call HGT_invQ_OLR(G2H2(142),2,5,2)
call HGT_OLR(G2H2(142),6,15,2)
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(142),[G2H2(189)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(159),[G2H2(143),G1H2(69),G1H2(17),G1H2(5)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(192),[G1H2(168)])
call HGT_lower_alpha_w2_OLR(G2H2(146),1,1,2)
call HGT_lower_alpha_w2_invQ_OLR(G2H2(146),2,5,2)
call HGT_lower_alpha_w2_OLR(G2H2(146),6,15,2)
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(146),[G2H2(192)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(163),[G2H2(147),G1H2(70),G1H2(23),G1H2(11)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(193),[G1H2(175)])
call HGT_OLR(G2H2(158),1,1,2)
call HGT_invQ_OLR(G2H2(158),2,5,2)
call HGT_OLR(G2H2(158),6,15,2)
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(158),[G2H2(193)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(196),[G1H2(179)])
call HGT_lower_alpha_w2_OLR(G2H2(162),1,1,2)
call HGT_lower_alpha_w2_invQ_OLR(G2H2(162),2,5,2)
call HGT_lower_alpha_w2_OLR(G2H2(162),6,15,2)
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(162),[G2H2(196)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(85),[G1H2(3)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(88),[G1H2(4)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(89),[G1H2(9)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(92),[G1H2(10)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(101),[G1H2(15)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(104),[G1H2(16)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(105),[G1H2(21)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(108),[G1H2(22)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(2),[G1H2(28)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(68),[G1H2(46),G1H2(35)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(52),[G2H2(4),G1H2(39)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(56),[G2H2(12),G1H2(314),G1H2(50)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(320),[G1H2(56)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(16),[G1H2(61)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(117),[G1H2(71)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(120),[G1H2(105),G1H2(83),G1H2(72)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(111),[G1H2(89),G1H2(78)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(125),[G1H2(82)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(128),[G1H2(93)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(133),[G1H2(94)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(299),[G1H2(101)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(136),[G1H2(104)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(152),[G1H2(116)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(156),[G1H2(134),G1H2(123)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(24),[G2H2(145),G1H2(127)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(28),[G2H2(161),G1H2(292),G1H2(138)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(298),[G1H2(144)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(8),[G1H2(149)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(17),[G1H2(159)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(20),[G1H2(193),G1H2(171),G1H2(160)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(199),[G1H2(177),G1H2(166)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(29),[G1H2(170)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(32),[G1H2(181)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(33),[G1H2(182)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(310),[G1H2(189)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(36),[G1H2(192)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(37),[G1H2(203)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(40),[G1H2(237),G1H2(215),G1H2(204)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(243),[G1H2(221),G1H2(210)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(41),[G1H2(214)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(44),[G1H2(225)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(45),[G1H2(226)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(321),[G1H2(233)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(48),[G1H2(236)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(61),[G1H2(247)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(64),[G1H2(281),G1H2(259),G1H2(248)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(287),[G1H2(265),G1H2(254)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(65),[G1H2(258)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(68),[G1H2(269)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(57),[G1H2(270)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(342),[G1H2(277)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(60),[G1H2(280)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(72),[G2H2(69),G1H2(291)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(77),[G2H2(73),G1H2(302)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(80),[G2H2(76),G1H2(303)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(84),[G2H2(81),G1H2(313)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(347),[G1H2(326)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(352),[G1H2(331)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(97),[G2H2(93),G1H2(334)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(100),[G2H2(96),G1H2(335)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(49),[G1H4(122)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(51),[G1H4(121)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(50),[G1H4(126)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(52),[G1H4(125)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(8),[G1H4(128)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(9),[G1H4(127)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(1),[G1H4(132)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(2),[G1H4(131)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(177),[G1H2(142)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(178),[G1H2(147)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(179),[G1H2(141)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(180),[G1H2(146)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(181),[G1H2(153)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(182),[G1H2(158)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(183),[G1H2(152)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(184),[G1H2(157)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(190),[G1H2(169)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(191),[G1H2(163)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(194),[G1H2(180)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(195),[G1H2(174)])
call HGT_OLR(G2H2(6),1,1,2)
call HGT_invQ_OLR(G2H2(6),2,5,2)
call HGT_OLR(G2H2(6),6,15,2)
  call Hotf_4pt_reduction(G2H2(6),RedSet_4(47),mass4set(:,1),  & 
G1H2(185),G1H2(186),G1H2(190),G1H2(191),G1H2(196),2)
  call HG1shiftOLR(G1H2(186),2,2)
  call Hotf_4pt_reduction(G2H2(23),RedSet_4(18),mass4set(:,10),  & 
G1H2(197),G1H2(201),G1H2(202),G1H2(207),G1H2(208),2)
  call HG1shiftOLR(G1H2(201),8,2)
call HGT_OLR(G2H2(10),1,1,2)
call HGT_invQ_OLR(G2H2(10),2,5,2)
call HGT_OLR(G2H2(10),6,15,2)
  call Hotf_4pt_reduction(G2H2(10),RedSet_4(47),mass4set(:,2),  & 
G1H2(212),G1H2(213),G1H2(218),G1H2(219),G1H2(223),2)
  call HG1shiftOLR(G1H2(213),2,2)
call HGT_OLR(G2H2(14),1,1,2)
call HGT_invQ_OLR(G2H2(14),2,5,2)
call HGT_OLR(G2H2(14),6,15,2)
  call Hotf_4pt_reduction(G2H2(14),RedSet_4(47),mass4set(:,3),  & 
G1H2(224),G1H2(229),G1H2(230),G1H2(234),G1H2(235),2)
  call HG1shiftOLR(G1H2(229),2,2)
  call Hotf_4pt_reduction(G2H2(27),RedSet_4(18),mass4set(:,11),  & 
G1H2(240),G1H2(241),G1H2(245),G1H2(246),G1H2(251),2)
  call HG1shiftOLR(G1H2(241),8,2)
call HGT_OLR(G2H2(18),1,1,2)
call HGT_invQ_OLR(G2H2(18),2,5,2)
call HGT_OLR(G2H2(18),6,15,2)
  call Hotf_4pt_reduction(G2H2(18),RedSet_4(47),mass4set(:,4),  & 
G1H2(252),G1H2(256),G1H2(257),G1H2(262),G1H2(263),2)
  call HG1shiftOLR(G1H2(256),2,2)
call HGT_OLR(G2H2(22),1,1,2)
call HGT_invQ_OLR(G2H2(22),2,5,2)
call HGT_OLR(G2H2(22),6,15,2)
  call Hotf_4pt_reduction(G2H2(22),RedSet_4(47),mass4set(:,2),  & 
G1H2(267),G1H2(268),G1H2(273),G1H2(274),G1H2(278),2)
  call HG1shiftOLR(G1H2(268),2,2)
call HGT_OLR(G2H2(26),1,1,2)
call HGT_invQ_OLR(G2H2(26),2,5,2)
call HGT_OLR(G2H2(26),6,15,2)
  call Hotf_4pt_reduction(G2H2(26),RedSet_4(47),mass4set(:,3),  & 
G1H2(279),G1H2(284),G1H2(285),G1H2(289),G1H2(290),2)
  call HG1shiftOLR(G1H2(284),2,2)
call HGT_OLR(G2H2(30),1,1,2)
call HGT_invQ_OLR(G2H2(30),2,5,2)
call HGT_OLR(G2H2(30),6,15,2)
  call Hotf_4pt_reduction(G2H2(30),RedSet_4(48),mass4set(:,5),  & 
G1H2(295),G1H2(296),G1H2(300),G1H2(301),G1H2(306),2)
  call HG1shiftOLR(G1H2(296),4,2)
  call Hotf_4pt_reduction(G2H2(109),RedSet_4(22),mass4set(:,5),  & 
G1H2(307),G1H2(311),G1H2(312),G1H2(317),G1H2(318),2)
  call HG1shiftOLR(G1H2(311),8,2)
call HGT_OLR(G2H2(34),1,1,2)
call HGT_invQ_OLR(G2H2(34),2,5,2)
call HGT_OLR(G2H2(34),6,15,2)
  call Hotf_4pt_reduction(G2H2(34),RedSet_4(48),mass4set(:,6),  & 
G1H2(323),G1H2(328),G1H2(332),G1H2(333),G1H2(338),2)
  call HG1shiftOLR(G1H2(328),4,2)
  call Hotf_4pt_reduction(G2H2(121),RedSet_4(22),mass4set(:,6),  & 
G1H2(339),G1H2(344),G1H2(349),G1H2(6),G1H2(12),2)
  call HG1shiftOLR(G1H2(344),8,2)
call HGT_OLR(G2H2(38),1,1,2)
call HGT_invQ_OLR(G2H2(38),2,5,2)
call HGT_OLR(G2H2(38),6,15,2)
  call Hotf_4pt_reduction(G2H2(38),RedSet_4(48),mass4set(:,7),  & 
G1H2(18),G1H2(24),G1H2(30),G1H2(41),G1H2(52),2)
  call HG1shiftOLR(G1H2(24),4,2)
  call Hotf_4pt_reduction(G2H2(124),RedSet_4(22),mass4set(:,7),  & 
G1H2(63),G1H2(74),G1H2(85),G1H2(96),G1H2(107),2)
  call HG1shiftOLR(G1H2(74),8,2)
call HGT_OLR(G2H2(42),1,1,2)
call HGT_invQ_OLR(G2H2(42),2,5,2)
call HGT_OLR(G2H2(42),6,15,2)
  call Hotf_4pt_reduction(G2H2(42),RedSet_4(48),mass4set(:,8),  & 
G1H2(118),G1H2(129),G1H2(140),G1H2(151),G1H2(162),2)
  call HG1shiftOLR(G1H2(129),4,2)
  call Hotf_4pt_reduction(G2H2(116),RedSet_4(22),mass4set(:,8),  & 
G1H2(173),G1H2(184),G1H2(195),G1H2(206),G1H2(217),2)
  call HG1shiftOLR(G1H2(184),8,2)
call HGT_OLR(G2H2(46),1,1,2)
call HGT_invQ_OLR(G2H2(46),2,5,2)
call HGT_OLR(G2H2(46),6,15,2)
  call Hotf_4pt_reduction(G2H2(46),RedSet_4(49),mass4set(:,1),  & 
G1H2(228),G1H2(239),G1H2(250),G1H2(261),G1H2(272),2)
  call HG1shiftOLR(G1H2(239),1,2)
  call Hotf_4pt_reduction(G2H2(63),RedSet_4(18),mass4set(:,10),  & 
G1H2(283),G1H2(294),G1H2(305),G1H2(316),G1H2(337),2)
  call HG1shiftOLR(G1H2(294),8,2)
call HGT_OLR(G2H2(50),1,1,2)
call HGT_invQ_OLR(G2H2(50),2,5,2)
call HGT_OLR(G2H2(50),6,15,2)
  call Hotf_4pt_reduction(G2H2(50),RedSet_4(49),mass4set(:,2),  & 
G1H2(1),G1H2(2),G1H2(322),G1H2(7),G1H2(8),2)
  call HG1shiftOLR(G1H2(2),1,2)
call HGT_OLR(G2H2(54),1,1,2)
call HGT_invQ_OLR(G2H2(54),2,5,2)
call HGT_OLR(G2H2(54),6,15,2)
  call Hotf_4pt_reduction(G2H2(54),RedSet_4(49),mass4set(:,3),  & 
G1H2(327),G1H2(13),G1H2(14),G1H2(343),G1H2(19),2)
  call HG1shiftOLR(G1H2(13),1,2)
  call Hotf_4pt_reduction(G2H2(67),RedSet_4(18),mass4set(:,11),  & 
G1H2(20),G1H2(348),G1H2(25),G1H2(26),G1H2(31),2)
  call HG1shiftOLR(G1H2(348),8,2)
call HGT_OLR(G2H2(58),1,1,2)
call HGT_invQ_OLR(G2H2(58),2,5,2)
call HGT_OLR(G2H2(58),6,15,2)
  call Hotf_4pt_reduction(G2H2(58),RedSet_4(49),mass4set(:,4),  & 
G1H2(32),G1H2(36),G1H2(37),G1H2(42),G1H2(43),2)
  call HG1shiftOLR(G1H2(36),1,2)
call HGT_OLR(G2H2(62),1,1,2)
call HGT_invQ_OLR(G2H2(62),2,5,2)
call HGT_OLR(G2H2(62),6,15,2)
  call Hotf_4pt_reduction(G2H2(62),RedSet_4(49),mass4set(:,2),  & 
G1H2(47),G1H2(48),G1H2(53),G1H2(54),G1H2(58),2)
  call HG1shiftOLR(G1H2(48),1,2)
call HGT_OLR(G2H2(66),1,1,2)
call HGT_invQ_OLR(G2H2(66),2,5,2)
call HGT_OLR(G2H2(66),6,15,2)
  call Hotf_4pt_reduction(G2H2(66),RedSet_4(49),mass4set(:,3),  & 
G1H2(59),G1H2(64),G1H2(65),G1H2(75),G1H2(76),2)
  call HG1shiftOLR(G1H2(64),1,2)
  call Hotf_4pt_reduction(G2H2(70),RedSet_4(24),mass4set(:,5),  & 
G1H2(80),G1H2(81),G1H2(86),G1H2(87),G1H2(91),2)
  call HG1shiftOLR(G1H2(81),8,2)
  call Hotf_4pt_reduction(G2H2(153),RedSet_4(29),mass4set(:,5),  & 
G1H2(92),G1H2(97),G1H2(98),G1H2(102),G1H2(103),2)
  call HG1shiftOLR(G1H2(97),4,2)
  call Hotf_4pt_reduction(G2H2(74),RedSet_4(24),mass4set(:,6),  & 
G1H2(108),G1H2(109),G1H2(113),G1H2(114),G1H2(119),2)
  call HG1shiftOLR(G1H2(109),8,2)
  call Hotf_4pt_reduction(G2H2(165),RedSet_4(29),mass4set(:,6),  & 
G1H2(120),G1H2(124),G1H2(125),G1H2(130),G1H2(131),2)
  call HG1shiftOLR(G1H2(124),4,2)
  call Hotf_4pt_reduction(G2H2(78),RedSet_4(24),mass4set(:,7),  & 
G1H2(135),G1H2(136),G1H2(62),G1H2(40),G1H2(29),2)
  call HG1shiftOLR(G1H2(136),8,2)
  call Hotf_4pt_reduction(G2H2(166),RedSet_4(29),mass4set(:,7),  & 
G1H2(51),G1H2(73),G1H2(84),G1H2(293),G1H2(95),2)
  call HG1shiftOLR(G1H2(73),4,2)
  call Hotf_4pt_reduction(G2H2(82),RedSet_4(24),mass4set(:,8),  & 
G1H2(106),G1H2(150),G1H2(128),G1H2(117),G1H2(139),2)
  call HG1shiftOLR(G1H2(150),8,2)
  call Hotf_4pt_reduction(G2H2(164),RedSet_4(29),mass4set(:,8),  & 
G1H2(115),G1H2(161),G1H2(126),G1H2(172),G1H2(137),2)
  call HG1shiftOLR(G1H2(161),4,2)
call HGT_OLR(G2H2(86),1,1,2)
call HGT_invQ_OLR(G2H2(86),2,5,2)
call HGT_OLR(G2H2(86),6,15,2)
  call Hotf_4pt_reduction(G2H2(86),RedSet_4(50),mass4set(:,5),  & 
G1H2(304),G1H2(183),G1H2(148),G1H2(194),G1H2(205),2)
  call HG1shiftOLR(G1H2(183),4,2)
  call Hotf_4pt_reduction(G2H2(129),RedSet_4(32),mass4set(:,5),  & 
G1H2(216),G1H2(315),G1H2(227),G1H2(238),G1H2(27),2)
  call HG1shiftOLR(G1H2(315),8,2)
call HGT_OLR(G2H2(90),1,1,2)
call HGT_invQ_OLR(G2H2(90),2,5,2)
call HGT_OLR(G2H2(90),6,15,2)
  call Hotf_4pt_reduction(G2H2(90),RedSet_4(50),mass4set(:,6),  & 
G1H2(249),G1H2(38),G1H2(260),G1H2(49),G1H2(336),2)
  call HG1shiftOLR(G1H2(38),4,2)
  call Hotf_4pt_reduction(G2H2(144),RedSet_4(32),mass4set(:,6),  & 
G1H2(271),G1H2(60),G1H2(282),G1H2(164),G1H2(69),2)
  call HG1shiftOLR(G1H2(60),8,2)
call HGT_OLR(G2H2(94),1,1,2)
call HGT_invQ_OLR(G2H2(94),2,5,2)
call HGT_OLR(G2H2(94),6,15,2)
  call Hotf_4pt_reduction(G2H2(94),RedSet_4(50),mass4set(:,7),  & 
G1H2(17),G1H2(5),G1H2(168),G1H2(70),G1H2(23),2)
  call HG1shiftOLR(G1H2(5),4,2)
  call Hotf_4pt_reduction(G2H2(148),RedSet_4(32),mass4set(:,7),  & 
G1H2(11),G1H2(175),G1H2(179),G1H2(3),G1H2(4),2)
  call HG1shiftOLR(G1H2(175),8,2)
call HGT_OLR(G2H2(98),1,1,2)
call HGT_invQ_OLR(G2H2(98),2,5,2)
call HGT_OLR(G2H2(98),6,15,2)
  call Hotf_4pt_reduction(G2H2(98),RedSet_4(50),mass4set(:,8),  & 
G1H2(9),G1H2(10),G1H2(15),G1H2(16),G1H2(21),2)
  call HG1shiftOLR(G1H2(10),4,2)
  call Hotf_4pt_reduction(G2H2(140),RedSet_4(32),mass4set(:,8),  & 
G1H2(22),G1H2(28),G1H2(46),G1H2(35),G1H2(39),2)
  call HG1shiftOLR(G1H2(28),8,2)
  call Hotf_4pt_reduction(G2H2(102),RedSet_4(16),mass4set(:,5),  & 
G1H2(314),G1H2(50),G1H2(56),G1H2(61),G1H2(71),2)
  call HG1shiftOLR(G1H2(50),8,2)
  call Hotf_4pt_reduction(G2H2(167),RedSet_4(35),mass4set(:,5),  & 
G1H2(105),G1H2(83),G1H2(72),G1H2(89),G1H2(78),2)
  call HG1shiftOLR(G1H2(83),4,2)
  call Hotf_4pt_reduction(G2H2(106),RedSet_4(16),mass4set(:,6),  & 
G1H2(82),G1H2(93),G1H2(94),G1H2(101),G1H2(104),2)
  call HG1shiftOLR(G1H2(93),8,2)
  call Hotf_4pt_reduction(G2H2(171),RedSet_4(35),mass4set(:,6),  & 
G1H2(116),G1H2(134),G1H2(123),G1H2(127),G1H2(292),2)
  call HG1shiftOLR(G1H2(134),4,2)
  call Hotf_4pt_reduction(G2H2(110),RedSet_4(16),mass4set(:,7),  & 
G1H2(138),G1H2(144),G1H2(149),G1H2(159),G1H2(193),2)
  call HG1shiftOLR(G1H2(144),8,2)
  call Hotf_4pt_reduction(G2H2(172),RedSet_4(35),mass4set(:,7),  & 
G1H2(171),G1H2(160),G1H2(177),G1H2(166),G1H2(170),2)
  call HG1shiftOLR(G1H2(160),4,2)
  call Hotf_4pt_reduction(G2H2(114),RedSet_4(16),mass4set(:,8),  & 
G1H2(181),G1H2(182),G1H2(189),G1H2(192),G1H2(203),2)
  call HG1shiftOLR(G1H2(182),8,2)
  call Hotf_4pt_reduction(G2H2(170),RedSet_4(35),mass4set(:,8),  & 
G1H2(237),G1H2(215),G1H2(204),G1H2(221),G1H2(210),2)
  call HG1shiftOLR(G1H2(215),4,2)
call HGT_OLR(G2H2(118),1,1,2)
call HGT_invQ_OLR(G2H2(118),2,5,2)
call HGT_OLR(G2H2(118),6,15,2)
  call Hotf_4pt_reduction(G2H2(118),RedSet_4(51),mass4set(:,9),  & 
G1H2(214),G1H2(225),G1H2(226),G1H2(233),G1H2(236),2)
  call HG1shiftOLR(G1H2(225),1,2)
call HGT_OLR(G2H2(122),1,1,2)
call HGT_invQ_OLR(G2H2(122),2,5,2)
call HGT_OLR(G2H2(122),6,15,2)
  call Hotf_4pt_reduction(G2H2(122),RedSet_4(51),mass4set(:,9),  & 
G1H2(247),G1H2(281),G1H2(259),G1H2(248),G1H2(265),2)
  call HG1shiftOLR(G1H2(281),1,2)
call HGT_OLR(G2H2(126),1,1,2)
call HGT_invQ_OLR(G2H2(126),2,5,2)
call HGT_OLR(G2H2(126),6,15,2)
  call Hotf_4pt_reduction(G2H2(126),RedSet_4(52),mass4set(:,9),  & 
G1H2(254),G1H2(258),G1H2(269),G1H2(270),G1H2(277),2)
  call HG1shiftOLR(G1H2(258),1,2)
call HGT_OLR(G2H2(130),1,1,2)
call HGT_invQ_OLR(G2H2(130),2,5,2)
call HGT_OLR(G2H2(130),6,15,2)
  call Hotf_4pt_reduction(G2H2(130),RedSet_4(52),mass4set(:,9),  & 
G1H2(280),G1H2(291),G1H2(302),G1H2(303),G1H2(313),2)
  call HG1shiftOLR(G1H2(291),1,2)
call HGT_OLR(G2H2(134),1,1,2)
call HGT_invQ_OLR(G2H2(134),2,5,2)
call HGT_OLR(G2H2(134),6,15,2)
  call Hotf_4pt_reduction(G2H2(134),RedSet_4(53),mass4set(:,9),  & 
G1H2(326),G1H2(331),G1H2(334),G1H2(335),G1H2(142),2)
  call HG1shiftOLR(G1H2(331),2,2)
call HGT_OLR(G2H2(138),1,1,2)
call HGT_invQ_OLR(G2H2(138),2,5,2)
call HGT_OLR(G2H2(138),6,15,2)
  call Hotf_4pt_reduction(G2H2(138),RedSet_4(53),mass4set(:,9),  & 
G1H2(147),G1H2(141),G1H2(146),G1H2(153),G1H2(158),2)
  call HG1shiftOLR(G1H2(141),2,2)
  call Hotf_4pt_reduction(G2H2(142),RedSet_4(20),mass4set(:,12),  & 
G1H2(152),G1H2(157),G1H2(169),G1H2(163),G1H2(180),2)
  call HG1shiftOLR(G1H2(157),8,2)
  call Hotf_4pt_reduction(G2H2(159),RedSet_4(11),mass4set(:,9),  & 
G1H2(174),G1H2(353),G1H2(354),G1H2(355),G1H2(356),2)
  call HG1shiftOLR(G1H2(353),2,2)
  call Hotf_4pt_reduction(G2H2(146),RedSet_4(20),mass4set(:,12),  & 
G1H2(357),G1H2(358),G1H2(359),G1H2(360),G1H2(361),2)
  call HG1shiftOLR(G1H2(358),8,2)
  call Hotf_4pt_reduction(G2H2(163),RedSet_4(11),mass4set(:,9),  & 
G1H2(362),G1H2(363),G1H2(364),G1H2(365),G1H2(366),2)
  call HG1shiftOLR(G1H2(363),2,2)
call HGT_OLR(G2H2(150),1,1,2)
call HGT_invQ_OLR(G2H2(150),2,5,2)
call HGT_OLR(G2H2(150),6,15,2)
  call Hotf_4pt_reduction(G2H2(150),RedSet_4(54),mass4set(:,9),  & 
G1H2(367),G1H2(368),G1H2(369),G1H2(370),G1H2(371),2)
  call HG1shiftOLR(G1H2(368),2,2)
call HGT_OLR(G2H2(154),1,1,2)
call HGT_invQ_OLR(G2H2(154),2,5,2)
call HGT_OLR(G2H2(154),6,15,2)
  call Hotf_4pt_reduction(G2H2(154),RedSet_4(54),mass4set(:,9),  & 
G1H2(372),G1H2(373),G1H2(374),G1H2(375),G1H2(376),2)
  call HG1shiftOLR(G1H2(373),2,2)
  call Hotf_4pt_reduction(G2H2(158),RedSet_4(27),mass4set(:,12),  & 
G1H2(377),G1H2(378),G1H2(379),G1H2(380),G1H2(381),2)
  call HG1shiftOLR(G1H2(378),4,2)
  call Hotf_4pt_reduction(G2H2(162),RedSet_4(27),mass4set(:,12),  & 
G1H2(382),G1H2(383),G1H2(384),G1H2(385),G1H2(386),2)
  call HG1shiftOLR(G1H2(383),4,2)
  call Hotf_4pt_reduction(G2H2(85),RedSet_4(9),mass4set(:,13),  & 
G1H2(387),G1H2(388),G1H2(389),G1H2(390),G1H2(391),2)
  call HG1shiftOLR(G1H2(388),2,2)
  call Hotf_4pt_reduction(G2H2(88),RedSet_4(10),mass4set(:,9),  & 
G1H2(392),G1H2(393),G1H2(394),G1H2(395),G1H2(396),2)
  call HG1shiftOLR(G1H2(393),2,2)
  call Hotf_4pt_reduction(G2H2(89),RedSet_4(9),mass4set(:,13),  & 
G1H2(397),G1H2(398),G1H2(399),G1H2(400),G1H2(401),2)
  call HG1shiftOLR(G1H2(398),2,2)
  call Hotf_4pt_reduction(G2H2(92),RedSet_4(10),mass4set(:,9),  & 
G1H2(402),G1H2(403),G1H2(404),G1H2(405),G1H2(406),2)
  call HG1shiftOLR(G1H2(403),2,2)
  call Hotf_4pt_reduction(G2H2(101),RedSet_4(13),mass4set(:,13),  & 
G1H2(407),G1H2(408),G1H2(409),G1H2(410),G1H2(411),2)
  call HG1shiftOLR(G1H2(408),2,2)
  call Hotf_4pt_reduction(G2H2(104),RedSet_4(14),mass4set(:,9),  & 
G1H2(412),G1H2(413),G1H2(414),G1H2(415),G1H2(416),2)
  call HG1shiftOLR(G1H2(413),2,2)
  call Hotf_4pt_reduction(G2H2(105),RedSet_4(13),mass4set(:,13),  & 
G1H2(417),G1H2(418),G1H2(419),G1H2(420),G1H2(421),2)
  call HG1shiftOLR(G1H2(418),2,2)
  call Hotf_4pt_reduction(G2H2(108),RedSet_4(14),mass4set(:,9),  & 
G1H2(422),G1H2(423),G1H2(424),G1H2(425),G1H2(426),2)
  call HG1shiftOLR(G1H2(423),2,2)
  call Hotf_4pt_reduction(G2H2(2),RedSet_4(17),mass4set(:,5),  & 
G1H2(427),G1H2(428),G1H2(429),G1H2(430),G1H2(431),2)
  call HG1shiftOLR(G1H2(428),8,2)
  call Hloop_AV_Q(ntryL,G1H2(33),ex4(:),G1H1(1),m3h2x1(:,129),heltab2x2(:,:,129))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,nMT,G2tensor(1),n2h1(129))
  call Hloop_AV_Q(ntryL,G1H2(34),ex4(:),G1H1(1),m3h2x1(:,130),heltab2x2(:,:,130))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,nMT,G2tensor(7),n2h1(130))
  call Hloop_AV_Q(ntryL,G1H2(68),ex4(:),G1H1(1),m3h2x1(:,131),heltab2x2(:,:,131))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,nMT,G2tensor(4),n2h1(131))
  call Hotf_4pt_reduction(G2H2(52),RedSet_4(17),mass4set(:,6),  & 
G1H2(33),G1H2(34),G1H2(68),G1H2(432),G1H2(433),2)
  call HG1shiftOLR(G1H2(34),8,2)
  call Hloop_AV_Q(ntryL,G1H2(44),ex4(:),G1H1(1),m3h2x1(:,132),heltab2x2(:,:,132))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,nMT,G2tensor(10),n2h1(132))
  call Hloop_AV_Q(ntryL,G1H2(45),ex4(:),G1H1(1),m3h2x1(:,133),heltab2x2(:,:,133))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,nMT,G2tensor(13),n2h1(133))
  call Hotf_4pt_reduction(G2H2(56),RedSet_4(17),mass4set(:,7),  & 
G1H2(44),G1H2(45),G1H2(434),G1H2(435),G1H2(436),2)
  call HG1shiftOLR(G1H2(45),8,2)
  call Hloop_AV_Q(ntryL,G1H2(55),ex4(:),G1H1(1),m3h2x1(:,134),heltab2x2(:,:,134))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,nMB,G2tensor(17),n2h1(134))
  call Hloop_AV_Q(ntryL,G1H2(320),ex4(:),G1H1(1),m3h2x1(:,135),heltab2x2(:,:,135))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,nMB,G2tensor(21),n2h1(135))
  call Hloop_AV_Q(ntryL,G1H2(57),ex4(:),G1H1(1),m3h2x1(:,136),heltab2x2(:,:,136))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,nMB,G2tensor(25),n2h1(136))
  call Hotf_4pt_reduction(G2H2(16),RedSet_4(17),mass4set(:,8),  & 
G1H2(55),G1H2(320),G1H2(57),G1H2(437),G1H2(438),2)
  call HG1shiftOLR(G1H2(320),8,2)
  call Hloop_AV_Q(ntryL,G1H2(66),ex4(:),G1H1(1),m3h2x1(:,137),heltab2x2(:,:,137))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,nMT,G2tensor(29),n2h1(137))
  call Hloop_AV_Q(ntryL,G1H2(67),ex4(:),G1H1(1),m3h2x1(:,138),heltab2x2(:,:,138))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,nMT,G2tensor(33),n2h1(138))
  call Hotf_4pt_reduction(G2H2(117),RedSet_4(20),mass4set(:,14),  & 
G1H2(66),G1H2(67),G1H2(439),G1H2(440),G1H2(441),2)
  call HG1shiftOLR(G1H2(67),8,2)
  call Hotf_4pt_reduction(G2H2(120),RedSet_4(21),mass4set(:,10),  & 
G1H2(442),G1H2(443),G1H2(444),G1H2(445),G1H2(446),2)
  call HG1shiftOLR(G1H2(443),8,2)
  call Hloop_QV_A(ntryL,G1H2(77),ex4(:),G1H1(1),m3h2x1(:,139),heltab2x2(:,:,139))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,nMT,G2tensor(37),n2h1(139))
  call Hloop_QV_A(ntryL,G1H2(111),ex4(:),G1H1(1),m3h2x1(:,140),heltab2x2(:,:,140))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,nMT,G2tensor(41),n2h1(140))
  call Hloop_QV_A(ntryL,G1H2(79),ex4(:),G1H1(1),m3h2x1(:,141),heltab2x2(:,:,141))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,nMT,G2tensor(45),n2h1(141))
  call Hotf_4pt_reduction(G2H2(125),RedSet_4(20),mass4set(:,15),  & 
G1H2(77),G1H2(111),G1H2(79),G1H2(447),G1H2(448),2)
  call HG1shiftOLR(G1H2(111),8,2)
  call Hloop_QV_A(ntryL,G1H2(88),ex4(:),G1H1(1),m3h2x1(:,142),heltab2x2(:,:,142))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,nMT,G2tensor(49),n2h1(142))
  call Hloop_QV_A(ntryL,G1H2(90),ex4(:),G1H1(1),m3h2x1(:,143),heltab2x2(:,:,143))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,nMT,G2tensor(53),n2h1(143))
  call Hotf_4pt_reduction(G2H2(128),RedSet_4(20),mass4set(:,16),  & 
G1H2(88),G1H2(90),G1H2(449),G1H2(450),G1H2(451),2)
  call HG1shiftOLR(G1H2(90),8,2)
  call Hotf_4pt_reduction(G2H2(133),RedSet_4(21),mass4set(:,11),  & 
G1H2(452),G1H2(453),G1H2(454),G1H2(455),G1H2(456),2)
  call HG1shiftOLR(G1H2(453),8,2)
  call Hloop_QV_A(ntryL,G1H2(99),ex4(:),G1H1(1),m3h2x1(:,144),heltab2x2(:,:,144))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,nMB,G2tensor(57),n2h1(144))
  call Hloop_QV_A(ntryL,G1H2(100),ex4(:),G1H1(1),m3h2x1(:,145),heltab2x2(:,:,145))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,nMB,G2tensor(61),n2h1(145))
  call Hloop_QV_A(ntryL,G1H2(299),ex4(:),G1H1(1),m3h2x1(:,146),heltab2x2(:,:,146))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,nMB,G2tensor(65),n2h1(146))
  call Hotf_4pt_reduction(G2H2(136),RedSet_4(20),mass4set(:,17),  & 
G1H2(99),G1H2(100),G1H2(299),G1H2(457),G1H2(458),2)
  call HG1shiftOLR(G1H2(100),8,2)
  call Hloop_QV_A(ntryL,G1H2(110),ex4(:),G1H1(1),m3h2x1(:,147),heltab2x2(:,:,147))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,nMT,G2tensor(69),n2h1(147))
  call Hloop_QV_A(ntryL,G1H2(112),ex4(:),G1H1(1),m3h2x1(:,148),heltab2x2(:,:,148))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,nMT,G2tensor(73),n2h1(148))
  call Hotf_4pt_reduction(G2H2(152),RedSet_4(25),mass4set(:,5),  & 
G1H2(110),G1H2(112),G1H2(459),G1H2(460),G1H2(461),2)
  call HG1shiftOLR(G1H2(112),8,2)
  call Hloop_QV_A(ntryL,G1H2(121),ex4(:),G1H1(1),m3h2x1(:,149),heltab2x2(:,:,149))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,nMT,G2tensor(77),n2h1(149))
  call Hloop_QV_A(ntryL,G1H2(122),ex4(:),G1H1(1),m3h2x1(:,150),heltab2x2(:,:,150))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,nMT,G2tensor(81),n2h1(150))
  call Hloop_QV_A(ntryL,G1H2(156),ex4(:),G1H1(1),m3h2x1(:,151),heltab2x2(:,:,151))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,nMT,G2tensor(85),n2h1(151))
  call Hotf_4pt_reduction(G2H2(24),RedSet_4(25),mass4set(:,6),  & 
G1H2(121),G1H2(122),G1H2(156),G1H2(462),G1H2(463),2)
  call HG1shiftOLR(G1H2(122),8,2)
  call Hloop_QV_A(ntryL,G1H2(132),ex4(:),G1H1(1),m3h2x1(:,152),heltab2x2(:,:,152))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,nMT,G2tensor(89),n2h1(152))
  call Hloop_QV_A(ntryL,G1H2(133),ex4(:),G1H1(1),m3h2x1(:,153),heltab2x2(:,:,153))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,nMT,G2tensor(93),n2h1(153))
  call Hotf_4pt_reduction(G2H2(28),RedSet_4(25),mass4set(:,7),  & 
G1H2(132),G1H2(133),G1H2(464),G1H2(465),G1H2(466),2)
  call HG1shiftOLR(G1H2(133),8,2)
  call Hloop_QV_A(ntryL,G1H2(143),ex4(:),G1H1(1),m3h2x1(:,154),heltab2x2(:,:,154))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,nMB,G2tensor(97),n2h1(154))
  call Hloop_QV_A(ntryL,G1H2(298),ex4(:),G1H1(1),m3h2x1(:,155),heltab2x2(:,:,155))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,nMB,G2tensor(101),n2h1(155))
  call Hloop_QV_A(ntryL,G1H2(145),ex4(:),G1H1(1),m3h2x1(:,156),heltab2x2(:,:,156))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,nMB,G2tensor(105),n2h1(156))
  call Hotf_4pt_reduction(G2H2(8),RedSet_4(25),mass4set(:,8),  & 
G1H2(143),G1H2(298),G1H2(145),G1H2(467),G1H2(468),2)
  call HG1shiftOLR(G1H2(298),8,2)
  call Hloop_QV_A(ntryL,G1H2(154),ex4(:),G1H1(1),m3h2x1(:,157),heltab2x2(:,:,157))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,nMT,G2tensor(109),n2h1(157))
  call Hloop_QV_A(ntryL,G1H2(155),ex4(:),G1H1(1),m3h2x1(:,158),heltab2x2(:,:,158))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,nMT,G2tensor(113),n2h1(158))
  call Hotf_4pt_reduction(G2H2(17),RedSet_4(27),mass4set(:,14),  & 
G1H2(154),G1H2(155),G1H2(469),G1H2(470),G1H2(471),2)
  call HG1shiftOLR(G1H2(155),4,2)
  call Hotf_4pt_reduction(G2H2(20),RedSet_4(28),mass4set(:,10),  & 
G1H2(472),G1H2(473),G1H2(474),G1H2(475),G1H2(476),2)
  call HG1shiftOLR(G1H2(473),4,2)
  call Hloop_QV_A(ntryL,G1H2(165),ex3(:),G1H1(1),m3h2x1(:,159),heltab2x2(:,:,159))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,nMT,G2tensor(117),n2h1(159))
  call Hloop_QV_A(ntryL,G1H2(199),ex3(:),G1H1(1),m3h2x1(:,160),heltab2x2(:,:,160))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,nMT,G2tensor(123),n2h1(160))
  call Hloop_QV_A(ntryL,G1H2(167),ex3(:),G1H1(1),m3h2x1(:,161),heltab2x2(:,:,161))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,nMT,G2tensor(129),n2h1(161))
  call Hotf_4pt_reduction(G2H2(29),RedSet_4(27),mass4set(:,15),  & 
G1H2(165),G1H2(199),G1H2(167),G1H2(477),G1H2(478),2)
  call HG1shiftOLR(G1H2(199),4,2)
  call Hloop_QV_A(ntryL,G1H2(176),ex3(:),G1H1(1),m3h2x1(:,162),heltab2x2(:,:,162))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,nMT,G2tensor(130),n2h1(162))
  call Hloop_QV_A(ntryL,G1H2(178),ex3(:),G1H1(1),m3h2x1(:,163),heltab2x2(:,:,163))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,nMT,G2tensor(131),n2h1(163))
  call Hotf_4pt_reduction(G2H2(32),RedSet_4(27),mass4set(:,16),  & 
G1H2(176),G1H2(178),G1H2(479),G1H2(480),G1H2(481),2)
  call HG1shiftOLR(G1H2(178),4,2)
  call Hotf_4pt_reduction(G2H2(33),RedSet_4(28),mass4set(:,11),  & 
G1H2(482),G1H2(483),G1H2(484),G1H2(485),G1H2(486),2)
  call HG1shiftOLR(G1H2(483),4,2)
  call Hloop_QV_A(ntryL,G1H2(187),ex3(:),G1H1(1),m3h2x1(:,164),heltab2x2(:,:,164))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,nMB,G2tensor(132),n2h1(164))
  call Hloop_QV_A(ntryL,G1H2(188),ex3(:),G1H1(1),m3h2x1(:,165),heltab2x2(:,:,165))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,nMB,G2tensor(133),n2h1(165))
  call Hloop_QV_A(ntryL,G1H2(310),ex3(:),G1H1(1),m3h2x1(:,166),heltab2x2(:,:,166))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,nMB,G2tensor(134),n2h1(166))
  call Hotf_4pt_reduction(G2H2(36),RedSet_4(27),mass4set(:,17),  & 
G1H2(187),G1H2(188),G1H2(310),G1H2(487),G1H2(488),2)
  call HG1shiftOLR(G1H2(188),4,2)
  call Hloop_QV_A(ntryL,G1H2(198),ex3(:),G1H1(1),m3h2x1(:,167),heltab2x2(:,:,167))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,nMT,G2tensor(135),n2h1(167))
  call Hloop_QV_A(ntryL,G1H2(200),ex3(:),G1H1(1),m3h2x1(:,168),heltab2x2(:,:,168))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,nMT,G2tensor(136),n2h1(168))
  call Hotf_4pt_reduction(G2H2(37),RedSet_4(31),mass4set(:,14),  & 
G1H2(198),G1H2(200),G1H2(489),G1H2(490),G1H2(491),2)
  call HG1shiftOLR(G1H2(200),8,2)
  call Hotf_4pt_reduction(G2H2(40),RedSet_4(21),mass4set(:,10),  & 
G1H2(492),G1H2(493),G1H2(494),G1H2(495),G1H2(496),2)
  call HG1shiftOLR(G1H2(493),8,2)
  call Hloop_AV_Q(ntryL,G1H2(209),ex4(:),G1H1(1),m3h2x1(:,169),heltab2x2(:,:,169))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,nMT,G2tensor(137),n2h1(169))
  call Hloop_AV_Q(ntryL,G1H2(243),ex4(:),G1H1(1),m3h2x1(:,170),heltab2x2(:,:,170))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,nMT,G2tensor(138),n2h1(170))
  call Hloop_AV_Q(ntryL,G1H2(211),ex4(:),G1H1(1),m3h2x1(:,171),heltab2x2(:,:,171))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,nMT,G2tensor(139),n2h1(171))
  call Hotf_4pt_reduction(G2H2(41),RedSet_4(31),mass4set(:,15),  & 
G1H2(209),G1H2(243),G1H2(211),G1H2(497),G1H2(498),2)
  call HG1shiftOLR(G1H2(243),8,2)
  call Hloop_AV_Q(ntryL,G1H2(220),ex4(:),G1H1(1),m3h2x1(:,172),heltab2x2(:,:,172))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,nMT,G2tensor(140),n2h1(172))
  call Hloop_AV_Q(ntryL,G1H2(222),ex4(:),G1H1(1),m3h2x1(:,173),heltab2x2(:,:,173))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,nMT,G2tensor(141),n2h1(173))
  call Hotf_4pt_reduction(G2H2(44),RedSet_4(31),mass4set(:,16),  & 
G1H2(220),G1H2(222),G1H2(499),G1H2(500),G1H2(501),2)
  call HG1shiftOLR(G1H2(222),8,2)
  call Hotf_4pt_reduction(G2H2(45),RedSet_4(21),mass4set(:,11),  & 
G1H2(502),G1H2(503),G1H2(504),G1H2(505),G1H2(506),2)
  call HG1shiftOLR(G1H2(503),8,2)
  call Hloop_AV_Q(ntryL,G1H2(231),ex4(:),G1H1(1),m3h2x1(:,174),heltab2x2(:,:,174))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,nMB,G2tensor(142),n2h1(174))
  call Hloop_AV_Q(ntryL,G1H2(232),ex4(:),G1H1(1),m3h2x1(:,175),heltab2x2(:,:,175))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,nMB,G2tensor(143),n2h1(175))
  call Hloop_AV_Q(ntryL,G1H2(321),ex4(:),G1H1(1),m3h2x1(:,176),heltab2x2(:,:,176))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,nMB,G2tensor(144),n2h1(176))
  call Hotf_4pt_reduction(G2H2(48),RedSet_4(31),mass4set(:,17),  & 
G1H2(231),G1H2(232),G1H2(321),G1H2(507),G1H2(508),2)
  call HG1shiftOLR(G1H2(232),8,2)
  call Hloop_AV_Q(ntryL,G1H2(242),ex4(:),G1H1(1),m3h2x1(:,177),heltab2x2(:,:,177))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,nMT,G2tensor(145),n2h1(177))
  call Hloop_AV_Q(ntryL,G1H2(244),ex4(:),G1H1(1),m3h2x1(:,178),heltab2x2(:,:,178))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,nMT,G2tensor(146),n2h1(178))
  call Hotf_4pt_reduction(G2H2(61),RedSet_4(34),mass4set(:,14),  & 
G1H2(242),G1H2(244),G1H2(509),G1H2(510),G1H2(511),2)
  call HG1shiftOLR(G1H2(244),4,2)
  call Hotf_4pt_reduction(G2H2(64),RedSet_4(28),mass4set(:,10),  & 
G1H2(512),G1H2(513),G1H2(514),G1H2(515),G1H2(516),2)
  call HG1shiftOLR(G1H2(513),4,2)
  call Hloop_AV_Q(ntryL,G1H2(253),ex3(:),G1H1(1),m3h2x1(:,179),heltab2x2(:,:,179))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,nMT,G2tensor(147),n2h1(179))
  call Hloop_AV_Q(ntryL,G1H2(287),ex3(:),G1H1(1),m3h2x1(:,180),heltab2x2(:,:,180))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,nMT,G2tensor(148),n2h1(180))
  call Hloop_AV_Q(ntryL,G1H2(255),ex3(:),G1H1(1),m3h2x1(:,181),heltab2x2(:,:,181))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,nMT,G2tensor(149),n2h1(181))
  call Hotf_4pt_reduction(G2H2(65),RedSet_4(34),mass4set(:,15),  & 
G1H2(253),G1H2(287),G1H2(255),G1H2(517),G1H2(518),2)
  call HG1shiftOLR(G1H2(287),4,2)
  call Hloop_AV_Q(ntryL,G1H2(264),ex3(:),G1H1(1),m3h2x1(:,182),heltab2x2(:,:,182))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,nMT,G2tensor(150),n2h1(182))
  call Hloop_AV_Q(ntryL,G1H2(266),ex3(:),G1H1(1),m3h2x1(:,183),heltab2x2(:,:,183))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,nMT,G2tensor(151),n2h1(183))
  call Hotf_4pt_reduction(G2H2(68),RedSet_4(34),mass4set(:,16),  & 
G1H2(264),G1H2(266),G1H2(519),G1H2(520),G1H2(521),2)
  call HG1shiftOLR(G1H2(266),4,2)
  call Hotf_4pt_reduction(G2H2(57),RedSet_4(28),mass4set(:,11),  & 
G1H2(522),G1H2(523),G1H2(524),G1H2(525),G1H2(526),2)
  call HG1shiftOLR(G1H2(523),4,2)
  call Hloop_AV_Q(ntryL,G1H2(275),ex3(:),G1H1(1),m3h2x1(:,184),heltab2x2(:,:,184))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,nMB,G2tensor(152),n2h1(184))
  call Hloop_AV_Q(ntryL,G1H2(276),ex3(:),G1H1(1),m3h2x1(:,185),heltab2x2(:,:,185))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,nMB,G2tensor(153),n2h1(185))
  call Hloop_AV_Q(ntryL,G1H2(342),ex3(:),G1H1(1),m3h2x1(:,186),heltab2x2(:,:,186))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,nMB,G2tensor(154),n2h1(186))
  call Hotf_4pt_reduction(G2H2(60),RedSet_4(34),mass4set(:,17),  & 
G1H2(275),G1H2(276),G1H2(342),G1H2(527),G1H2(528),2)
  call HG1shiftOLR(G1H2(276),4,2)
  call Hloop_AV_Q(ntryL,G1H2(286),ex3(:),G1H1(1),m3h2x1(:,187),heltab2x2(:,:,187))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,nMT,G2tensor(155),n2h1(187))
  call Hloop_AV_Q(ntryL,G1H2(288),ex3(:),G1H1(1),m3h2x1(:,188),heltab2x2(:,:,188))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,nMT,G2tensor(156),n2h1(188))
  call Hotf_4pt_reduction(G2H2(72),RedSet_4(37),mass4set(:,18),  & 
G1H2(286),G1H2(288),G1H2(529),G1H2(530),G1H2(531),2)
  call HG1shiftOLR(G1H2(288),8,2)
  call Hloop_QV_A(ntryL,G1H2(297),ex4(:),G1H1(1),m3h2x1(:,189),heltab2x2(:,:,189))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,nMB,G2tensor(157),n2h1(189))
  call Hotf_4pt_reduction(G2H2(77),RedSet_4(39),mass4set(:,18),  & 
G1H2(297),G1H2(532),G1H2(533),G1H2(534),G1H2(535),2)
  call HG1shiftOLR(G1H2(532),4,2)
  call Hotf_4pt_reduction(G2H2(80),RedSet_4(40),mass4set(:,7),  & 
G1H2(536),G1H2(537),G1H2(538),G1H2(539),G1H2(540),2)
  call HG1shiftOLR(G1H2(537),4,2)
  call Hloop_QV_A(ntryL,G1H2(308),ex3(:),G1H1(1),m3h2x1(:,190),heltab2x2(:,:,190))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,nMB,G2tensor(158),n2h1(190))
  call Hloop_QV_A(ntryL,G1H2(309),ex3(:),G1H1(1),m3h2x1(:,191),heltab2x2(:,:,191))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,nMB,G2tensor(159),n2h1(191))
  call Hotf_4pt_reduction(G2H2(84),RedSet_4(42),mass4set(:,18),  & 
G1H2(308),G1H2(309),G1H2(541),G1H2(542),G1H2(543),2)
  call HG1shiftOLR(G1H2(309),8,2)
  call Hloop_AV_Q(ntryL,G1H2(319),ex4(:),G1H1(1),m3h2x1(:,192),heltab2x2(:,:,192))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,nMB,G2tensor(160),n2h1(192))
  call Hloop_SA_Q(ntryL,G1H2(324),ex2(:),G1H1(1),ngPtb,m3h2x1(:,193),heltab2x2(:,:,193))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,nMB,G2tensor(161),n2h1(193))
  call Hloop_SA_Q(ntryL,G1H2(325),ex2(:),G1H1(1),ngPtb,m3h2x1(:,194),heltab2x2(:,:,194))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,nMB,G2tensor(162),n2h1(194))
  call Hloop_SA_Q(ntryL,G1H2(347),ex2(:),G1H1(1),ngPtb,m3h2x1(:,195),heltab2x2(:,:,195))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,nMB,G2tensor(163),n2h1(195))
  call Hloop_WA_Q(ntryL,G1H2(329),ex2(:),G1H1(1),m3h2x1(:,196),heltab2x2(:,:,196))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,nMB,G2tensor(164),n2h1(196))
  call Hloop_WA_Q(ntryL,G1H2(330),ex2(:),G1H1(1),m3h2x1(:,197),heltab2x2(:,:,197))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,nMB,G2tensor(165),n2h1(197))
  call Hloop_WA_Q(ntryL,G1H2(352),ex2(:),G1H1(1),m3h2x1(:,198),heltab2x2(:,:,198))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,nMB,G2tensor(166),n2h1(198))
  call Hotf_4pt_reduction(G2H2(97),RedSet_4(44),mass4set(:,18),  & 
G1H2(319),G1H2(324),G1H2(325),G1H2(347),G1H2(329),2)
  call HG1shiftOLR(G1H2(324),4,2)
  call Hotf_4pt_reduction(G2H2(100),RedSet_4(45),mass4set(:,7),  & 
G1H2(330),G1H2(352),G1H2(544),G1H2(545),G1H2(546),2)
  call HG1shiftOLR(G1H2(352),4,2)
  call Hloop_AV_Q(ntryL,G1H2(340),ex3(:),G1H1(1),m3h2x1(:,199),heltab2x2(:,:,199))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,nMB,G2tensor(167),n2h1(199))
  call Hloop_AV_Q(ntryL,G1H2(341),ex3(:),G1H1(1),m3h2x1(:,200),heltab2x2(:,:,200))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,nMB,G2tensor(168),n2h1(200))
  call Hloop_SA_Q(ntryL,G1H2(345),ex2(:),G1H1(1),ngPtb,m3h2x1(:,201),heltab2x2(:,:,201))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,nMB,G2tensor(169),n2h1(201))
  call Hloop_SA_Q(ntryL,G1H2(346),ex2(:),G1H1(1),ngPtb,m3h2x1(:,202),heltab2x2(:,:,202))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,nMB,G2tensor(170),n2h1(202))
  call Hloop_WA_Q(ntryL,G1H2(350),ex2(:),G1H1(1),m3h2x1(:,203),heltab2x2(:,:,203))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,nMB,G2tensor(171),n2h1(203))
  call Hloop_WA_Q(ntryL,G1H2(351),ex2(:),G1H1(1),m3h2x1(:,204),heltab2x2(:,:,204))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,nMB,G2tensor(172),n2h1(204))
  call Hotf_4pt_reduction(G2H4(49),RedSet_4(6),mass4set(:,9),  & 
G1H4(133),G1H4(134),G1H4(137),G1H4(138),G1H4(139),4)
  call HG1shiftOLR(G1H4(134),5,4)
  call Hotf_4pt_reduction(G2H4(51),RedSet_4(6),mass4set(:,9),  & 
G1H4(140),G1H4(143),G1H4(144),G1H4(145),G1H4(146),4)
  call HG1shiftOLR(G1H4(143),5,4)
  call Hotf_4pt_reduction(G2H4(50),RedSet_4(8),mass4set(:,9),  & 
G1H4(149),G1H4(150),G1H4(151),G1H4(152),G1H4(155),4)
  call HG1shiftOLR(G1H4(150),6,4)
  call Hotf_4pt_reduction(G2H4(52),RedSet_4(8),mass4set(:,9),  & 
G1H4(156),G1H4(157),G1H4(158),G1H4(161),G1H4(162),4)
  call HG1shiftOLR(G1H4(157),6,4)
  call Hotf_4pt_reduction(G2H4(8),RedSet_4(5),mass4set(:,9),  & 
G1H4(163),G1H4(164),G1H4(167),G1H4(168),G1H4(169),4)
  call HG1shiftOLR(G1H4(164),9,4)
  call Hotf_4pt_reduction(G2H4(9),RedSet_4(5),mass4set(:,9),  & 
G1H4(170),G1H4(173),G1H4(174),G1H4(175),G1H4(176),4)
  call HG1shiftOLR(G1H4(173),9,4)
  call Hotf_4pt_reduction(G2H4(20),RedSet_4(3),mass4set(:,1),  & 
G1H4(179),G1H4(180),G1H4(181),G1H4(182),G1H4(185),4)
  call HG1shiftOLR(G1H4(180),9,4)
  call Hotf_4pt_reduction(G2H4(21),RedSet_4(3),mass4set(:,2),  & 
G1H4(186),G1H4(187),G1H4(188),G1H4(191),G1H4(192),4)
  call HG1shiftOLR(G1H4(187),9,4)
  call Hotf_4pt_reduction(G2H4(26),RedSet_4(3),mass4set(:,3),  & 
G1H4(193),G1H4(194),G1H4(197),G1H4(198),G1H4(199),4)
  call HG1shiftOLR(G1H4(194),9,4)
  call Hotf_4pt_reduction(G2H4(27),RedSet_4(3),mass4set(:,4),  & 
G1H4(200),G1H4(203),G1H4(204),G1H4(205),G1H4(206),4)
  call HG1shiftOLR(G1H4(203),9,4)
  call Hotf_4pt_reduction(G2H4(32),RedSet_4(3),mass4set(:,2),  & 
G1H4(209),G1H4(210),G1H4(211),G1H4(212),G1H4(215),4)
  call HG1shiftOLR(G1H4(210),9,4)
  call Hotf_4pt_reduction(G2H4(33),RedSet_4(3),mass4set(:,3),  & 
G1H4(216),G1H4(217),G1H4(218),G1H4(221),G1H4(222),4)
  call HG1shiftOLR(G1H4(217),9,4)
  call Hotf_4pt_reduction(G2H4(1),RedSet_4(7),mass4set(:,9),  & 
G1H4(223),G1H4(224),G1H4(227),G1H4(228),G1H4(229),4)
  call HG1shiftOLR(G1H4(224),10,4)
  call Hotf_4pt_reduction(G2H4(2),RedSet_4(7),mass4set(:,9),  & 
G1H4(230),G1H4(233),G1H4(234),G1H4(235),G1H4(236),4)
  call HG1shiftOLR(G1H4(233),10,4)
  call Hotf_4pt_reduction(G2H4(3),RedSet_4(1),mass4set(:,1),  & 
G1H4(239),G1H4(240),G1H4(19),G1H4(23),G1H4(24),4)
  call HG1shiftOLR(G1H4(240),10,4)
  call Hotf_4pt_reduction(G2H4(4),RedSet_4(1),mass4set(:,2),  & 
G1H4(25),G1H4(71),G1H4(73),G1H4(74),G1H4(77),4)
  call HG1shiftOLR(G1H4(71),10,4)
  call Hotf_4pt_reduction(G2H4(5),RedSet_4(1),mass4set(:,3),  & 
G1H4(4),G1H4(9),G1H4(196),G1H4(15),G1H4(22),4)
  call HG1shiftOLR(G1H4(9),10,4)
  call Hotf_4pt_reduction(G2H4(6),RedSet_4(1),mass4set(:,4),  & 
G1H4(28),G1H4(202),G1H4(34),G1H4(39),G1H4(46),4)
  call HG1shiftOLR(G1H4(202),10,4)
  call Hotf_4pt_reduction(G2H4(7),RedSet_4(1),mass4set(:,2),  & 
G1H4(40),G1H4(80),G1H4(45),G1H4(83),G1H4(51),4)
  call HG1shiftOLR(G1H4(80),10,4)
  call Hotf_4pt_reduction(G2H4(11),RedSet_4(1),mass4set(:,3),  & 
G1H4(57),G1H4(64),G1H4(70),G1H4(172),G1H4(76),4)
  call HG1shiftOLR(G1H4(64),10,4)
  call Hotf_4pt_reduction(G2H2(173),RedSet_4(42),mass4set(:,19),  & 
G1H2(340),G1H2(341),G1H2(345),G1H2(346),G1H2(350),2)
  call HG1shiftOLR(G1H2(341),8,2)
  call Hcheck_last_SV_V(ntryL,l_switch,G2H2(174),ex4(:),G2tensor(173),m3h2x1(:,205),heltab2x2(:,:,205))
  call Hcheck_last_VV_S(ntryL,l_switch,G2H2(175),ex4(:),G2tensor(174),m3h2x1(:,206),heltab2x2(:,:,206))
  call Hotf_4pt_reduction(G2H2(176),RedSet_4(42),mass4set(:,19),  & 
G1H2(351),G1H2(547),G1H2(548),G1H2(549),G1H2(550),2)
  call HG1shiftOLR(G1H2(547),8,2)
  call Hotf_4pt_reduction(G2H2(177),RedSet_4(31),mass4set(:,12),  & 
G1H2(551),G1H2(552),G1H2(553),G1H2(554),G1H2(555),2)
  call HG1shiftOLR(G1H2(552),8,2)
  call Hcheck_last_SV_V(ntryL,l_switch,G2H2(178),ex4(:),G2tensor(175),m3h2x1(:,207),heltab2x2(:,:,207))
  call Hcheck_last_VV_S(ntryL,l_switch,G2H2(179),ex4(:),G2tensor(176),m3h2x1(:,208),heltab2x2(:,:,208))
  call Hotf_4pt_reduction(G2H2(180),RedSet_4(31),mass4set(:,12),  & 
G1H2(556),G1H2(557),G1H2(558),G1H2(559),G1H2(560),2)
  call HG1shiftOLR(G1H2(557),8,2)
  call Hotf_4pt_reduction(G2H2(181),RedSet_4(34),mass4set(:,12),  & 
G1H2(561),G1H2(562),G1H2(563),G1H2(564),G1H2(565),2)
  call HG1shiftOLR(G1H2(562),4,2)
  call Hcheck_last_SV_V(ntryL,l_switch,G2H2(182),ex3(:),G2tensor(177),m3h2x1(:,209),heltab2x2(:,:,209))
  call Hcheck_last_VV_S(ntryL,l_switch,G2H2(183),ex3(:),G2tensor(178),m3h2x1(:,210),heltab2x2(:,:,210))
  call Hotf_4pt_reduction(G2H2(184),RedSet_4(34),mass4set(:,12),  & 
G1H2(566),G1H2(567),G1H2(568),G1H2(569),G1H2(570),2)
  call HG1shiftOLR(G1H2(567),4,2)
  call Hotf_4pt_reduction(G2H2(185),RedSet_4(37),mass4set(:,19),  & 
G1H2(571),G1H2(572),G1H2(573),G1H2(574),G1H2(575),2)
  call HG1shiftOLR(G1H2(572),8,2)
  call Hcheck_last_SV_V(ntryL,l_switch,G2H2(186),ex4(:),G2tensor(179),m3h2x1(:,211),heltab2x2(:,:,211))
  call Hcheck_last_VV_S(ntryL,l_switch,G2H2(187),ex4(:),G2tensor(180),m3h2x1(:,212),heltab2x2(:,:,212))
  call Hotf_4pt_reduction(G2H2(188),RedSet_4(37),mass4set(:,19),  & 
G1H2(576),G1H2(577),G1H2(578),G1H2(579),G1H2(580),2)
  call HG1shiftOLR(G1H2(577),8,2)
  call Hcheck_last_SV_V(ntryL,l_switch,G2H2(190),ex4(:),G2tensor(181),m3h2x1(:,213),heltab2x2(:,:,213))
  call Hcheck_last_VV_S(ntryL,l_switch,G2H2(191),ex4(:),G2tensor(182),m3h2x1(:,214),heltab2x2(:,:,214))
  call Hcheck_last_SV_V(ntryL,l_switch,G2H2(194),ex3(:),G2tensor(183),m3h2x1(:,215),heltab2x2(:,:,215))
  call Hcheck_last_VV_S(ntryL,l_switch,G2H2(195),ex3(:),G2tensor(184),m3h2x1(:,216),heltab2x2(:,:,216))
  call Hloop_SA_Q(ntryL,G1H2(185),ex2(:),G1H1(1),ngH,m3h2x1(:,217),heltab2x2(:,:,217))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,nMT,G2tensor(185),n2h1(205))
  call Hloop_SA_Q(ntryL,G1H2(186),ex2(:),G1H1(1),ngH,m3h2x1(:,218),heltab2x2(:,:,218))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),2,nMT,G2tensor(186),n2h1(206))
  call Hloop_SA_Q(ntryL,G1H2(196),ex2(:),G1H1(1),ngH,m3h2x1(:,219),heltab2x2(:,:,219))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,nMT,G2tensor(187),n2h1(207))
  call Hloop_AV_Q(ntryL,G1H2(197),ex4(:),G1H1(1),m3h2x1(:,220),heltab2x2(:,:,220))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,nMT,G2tensor(188),n2h1(208))
  call Hloop_AV_Q(ntryL,G1H2(201),ex4(:),G1H1(1),m3h2x1(:,221),heltab2x2(:,:,221))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),8,nMT,G2tensor(189),n2h1(209))
  call Hloop_AV_Q(ntryL,G1H2(208),ex4(:),G1H1(1),m3h2x1(:,222),heltab2x2(:,:,222))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,nMT,G2tensor(190),n2h1(210))
  call Hloop_SA_Q(ntryL,G1H2(212),ex2(:),G1H1(1),ngX,m3h2x1(:,223),heltab2x2(:,:,223))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,nMT,G2tensor(191),n2h1(211))
  call Hloop_SA_Q(ntryL,G1H2(213),ex2(:),G1H1(1),ngX,m3h2x1(:,224),heltab2x2(:,:,224))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),2,nMT,G2tensor(192),n2h1(212))
  call Hloop_SA_Q(ntryL,G1H2(223),ex2(:),G1H1(1),ngX,m3h2x1(:,225),heltab2x2(:,:,225))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,nMT,G2tensor(193),n2h1(213))
  call Hloop_SA_Q(ntryL,G1H2(224),ex2(:),G1H1(1),ngPtb,m3h2x1(:,226),heltab2x2(:,:,226))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,nMB,G2tensor(194),n2h1(214))
  call Hloop_SA_Q(ntryL,G1H2(229),ex2(:),G1H1(1),ngPtb,m3h2x1(:,227),heltab2x2(:,:,227))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),2,nMB,G2tensor(195),n2h1(215))
  call Hloop_SA_Q(ntryL,G1H2(235),ex2(:),G1H1(1),ngPtb,m3h2x1(:,228),heltab2x2(:,:,228))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,nMB,G2tensor(196),n2h1(216))
  call Hloop_AV_Q(ntryL,G1H2(240),ex4(:),G1H1(1),m3h2x1(:,229),heltab2x2(:,:,229))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,nMB,G2tensor(197),n2h1(217))
  call Hloop_AV_Q(ntryL,G1H2(241),ex4(:),G1H1(1),m3h2x1(:,230),heltab2x2(:,:,230))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),8,nMB,G2tensor(198),n2h1(218))
  call Hloop_AV_Q(ntryL,G1H2(251),ex4(:),G1H1(1),m3h2x1(:,231),heltab2x2(:,:,231))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,nMB,G2tensor(199),n2h1(219))
  call Hloop_VA_Q(ntryL,G1H2(252),ex2(:),G1H1(1),m3h2x1(:,232),heltab2x2(:,:,232))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,nMT,G2tensor(200),n2h1(220))
  call Hloop_VA_Q(ntryL,G1H2(256),ex2(:),G1H1(1),m3h2x1(:,233),heltab2x2(:,:,233))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),2,nMT,G2tensor(201),n2h1(221))
  call Hloop_VA_Q(ntryL,G1H2(263),ex2(:),G1H1(1),m3h2x1(:,234),heltab2x2(:,:,234))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,nMT,G2tensor(202),n2h1(222))
  call Hloop_ZA_Q(ntryL,G1H2(267),ex2(:),G1H1(1),ngZu,m3h2x1(:,235),heltab2x2(:,:,235))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,nMT,G2tensor(203),n2h1(223))
  call Hloop_ZA_Q(ntryL,G1H2(268),ex2(:),G1H1(1),ngZu,m3h2x1(:,236),heltab2x2(:,:,236))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),2,nMT,G2tensor(204),n2h1(224))
  call Hloop_ZA_Q(ntryL,G1H2(278),ex2(:),G1H1(1),ngZu,m3h2x1(:,237),heltab2x2(:,:,237))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,nMT,G2tensor(205),n2h1(225))
  call Hloop_WA_Q(ntryL,G1H2(279),ex2(:),G1H1(1),m3h2x1(:,238),heltab2x2(:,:,238))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,nMB,G2tensor(206),n2h1(226))
  call Hloop_WA_Q(ntryL,G1H2(284),ex2(:),G1H1(1),m3h2x1(:,239),heltab2x2(:,:,239))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),2,nMB,G2tensor(207),n2h1(227))
  call Hloop_WA_Q(ntryL,G1H2(290),ex2(:),G1H1(1),m3h2x1(:,240),heltab2x2(:,:,240))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,nMB,G2tensor(208),n2h1(228))
  call Hloop_QV_A(ntryL,G1H2(295),ex3(:),G1H1(1),m3h2x1(:,241),heltab2x2(:,:,241))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,nMT,G2tensor(209),n2h1(229))
  call Hloop_QV_A(ntryL,G1H2(296),ex3(:),G1H1(1),m3h2x1(:,242),heltab2x2(:,:,242))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),4,nMT,G2tensor(210),n2h1(230))
  call Hloop_QV_A(ntryL,G1H2(306),ex3(:),G1H1(1),m3h2x1(:,243),heltab2x2(:,:,243))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,nMT,G2tensor(211),n2h1(231))
  call Hloop_QV_A(ntryL,G1H2(307),ex4(:),G1H1(1),m3h2x1(:,244),heltab2x2(:,:,244))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,nMT,G2tensor(212),n2h1(232))
  call Hloop_QV_A(ntryL,G1H2(311),ex4(:),G1H1(1),m3h2x1(:,245),heltab2x2(:,:,245))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),8,nMT,G2tensor(213),n2h1(233))
  call Hloop_QV_A(ntryL,G1H2(318),ex4(:),G1H1(1),m3h2x1(:,246),heltab2x2(:,:,246))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,nMT,G2tensor(214),n2h1(234))
  call Hloop_QV_A(ntryL,G1H2(323),ex3(:),G1H1(1),m3h2x1(:,247),heltab2x2(:,:,247))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,nMT,G2tensor(215),n2h1(235))
  call Hloop_QV_A(ntryL,G1H2(328),ex3(:),G1H1(1),m3h2x1(:,248),heltab2x2(:,:,248))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),4,nMT,G2tensor(216),n2h1(236))
  call Hloop_QV_A(ntryL,G1H2(338),ex3(:),G1H1(1),m3h2x1(:,249),heltab2x2(:,:,249))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,nMT,G2tensor(217),n2h1(237))
  call Hloop_QV_A(ntryL,G1H2(339),ex4(:),G1H1(1),m3h2x1(:,250),heltab2x2(:,:,250))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,nMT,G2tensor(218),n2h1(238))
  call Hloop_QV_A(ntryL,G1H2(344),ex4(:),G1H1(1),m3h2x1(:,251),heltab2x2(:,:,251))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),8,nMT,G2tensor(219),n2h1(239))
  call Hloop_QV_A(ntryL,G1H2(12),ex4(:),G1H1(1),m3h2x1(:,252),heltab2x2(:,:,252))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,nMT,G2tensor(220),n2h1(240))
  call Hloop_QV_A(ntryL,G1H2(18),ex3(:),G1H1(1),m3h2x1(:,253),heltab2x2(:,:,253))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,nMB,G2tensor(221),n2h1(241))
  call Hloop_QV_A(ntryL,G1H2(24),ex3(:),G1H1(1),m3h2x1(:,254),heltab2x2(:,:,254))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),4,nMB,G2tensor(222),n2h1(242))
  call Hloop_QV_A(ntryL,G1H2(52),ex3(:),G1H1(1),m3h2x1(:,255),heltab2x2(:,:,255))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,nMB,G2tensor(223),n2h1(243))
  call Hloop_QV_A(ntryL,G1H2(63),ex4(:),G1H1(1),m3h2x1(:,256),heltab2x2(:,:,256))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,nMB,G2tensor(224),n2h1(244))
  call Hloop_QV_A(ntryL,G1H2(74),ex4(:),G1H1(1),m3h2x1(:,257),heltab2x2(:,:,257))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),8,nMB,G2tensor(225),n2h1(245))
  call Hloop_QV_A(ntryL,G1H2(107),ex4(:),G1H1(1),m3h2x1(:,258),heltab2x2(:,:,258))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,nMB,G2tensor(226),n2h1(246))
  call Hloop_QV_A(ntryL,G1H2(118),ex3(:),G1H1(1),m3h2x1(:,259),heltab2x2(:,:,259))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,nMT,G2tensor(227),n2h1(247))
  call Hloop_QV_A(ntryL,G1H2(129),ex3(:),G1H1(1),m3h2x1(:,260),heltab2x2(:,:,260))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),4,nMT,G2tensor(228),n2h1(248))
  call Hloop_QV_A(ntryL,G1H2(162),ex3(:),G1H1(1),m3h2x1(:,261),heltab2x2(:,:,261))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,nMT,G2tensor(229),n2h1(249))
  call Hloop_QV_A(ntryL,G1H2(173),ex4(:),G1H1(1),m3h2x1(:,262),heltab2x2(:,:,262))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,nMT,G2tensor(230),n2h1(250))
  call Hloop_QV_A(ntryL,G1H2(184),ex4(:),G1H1(1),m3h2x1(:,263),heltab2x2(:,:,263))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),8,nMT,G2tensor(231),n2h1(251))
  call Hloop_QV_A(ntryL,G1H2(217),ex4(:),G1H1(1),m3h2x1(:,264),heltab2x2(:,:,264))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,nMT,G2tensor(232),n2h1(252))
  call Hloop_SQ_A(ntryL,G1H2(228),ex1(:),G1H1(1),ngH,m3h2x1(:,265),heltab2x2(:,:,265))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,nMT,G2tensor(233),n2h1(253))
  call Hloop_SQ_A(ntryL,G1H2(239),ex1(:),G1H1(1),ngH,m3h2x1(:,266),heltab2x2(:,:,266))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),1,nMT,G2tensor(234),n2h1(254))
  call Hloop_SQ_A(ntryL,G1H2(272),ex1(:),G1H1(1),ngH,m3h2x1(:,267),heltab2x2(:,:,267))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,nMT,G2tensor(235),n2h1(255))
  call Hloop_QV_A(ntryL,G1H2(283),ex4(:),G1H1(1),m3h2x1(:,268),heltab2x2(:,:,268))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,nMT,G2tensor(236),n2h1(256))
  call Hloop_QV_A(ntryL,G1H2(294),ex4(:),G1H1(1),m3h2x1(:,269),heltab2x2(:,:,269))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),8,nMT,G2tensor(237),n2h1(257))
  call Hloop_QV_A(ntryL,G1H2(337),ex4(:),G1H1(1),m3h2x1(:,270),heltab2x2(:,:,270))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,nMT,G2tensor(238),n2h1(258))
  call Hloop_SQ_A(ntryL,G1H2(1),ex1(:),G1H1(1),ngX,m3h2x1(:,271),heltab2x2(:,:,271))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,nMT,G2tensor(239),n2h1(259))
  call Hloop_SQ_A(ntryL,G1H2(2),ex1(:),G1H1(1),ngX,m3h2x1(:,272),heltab2x2(:,:,272))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),1,nMT,G2tensor(240),n2h1(260))
  call Hloop_SQ_A(ntryL,G1H2(8),ex1(:),G1H1(1),ngX,m3h2x1(:,273),heltab2x2(:,:,273))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,nMT,G2tensor(241),n2h1(261))
  call Hloop_SQ_A(ntryL,G1H2(327),ex1(:),G1H1(1),ngPbt,m3h2x1(:,274),heltab2x2(:,:,274))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,nMB,G2tensor(242),n2h1(262))
  call Hloop_SQ_A(ntryL,G1H2(13),ex1(:),G1H1(1),ngPbt,m3h2x1(:,275),heltab2x2(:,:,275))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),1,nMB,G2tensor(243),n2h1(263))
  call Hloop_SQ_A(ntryL,G1H2(19),ex1(:),G1H1(1),ngPbt,m3h2x1(:,276),heltab2x2(:,:,276))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,nMB,G2tensor(244),n2h1(264))
  call Hloop_QV_A(ntryL,G1H2(20),ex4(:),G1H1(1),m3h2x1(:,277),heltab2x2(:,:,277))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,nMB,G2tensor(245),n2h1(265))
  call Hloop_QV_A(ntryL,G1H2(348),ex4(:),G1H1(1),m3h2x1(:,278),heltab2x2(:,:,278))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),8,nMB,G2tensor(246),n2h1(266))
  call Hloop_QV_A(ntryL,G1H2(31),ex4(:),G1H1(1),m3h2x1(:,279),heltab2x2(:,:,279))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,nMB,G2tensor(247),n2h1(267))
  call Hloop_VQ_A(ntryL,G1H2(32),ex1(:),G1H1(1),m3h2x1(:,280),heltab2x2(:,:,280))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,nMT,G2tensor(248),n2h1(268))
  call Hloop_VQ_A(ntryL,G1H2(36),ex1(:),G1H1(1),m3h2x1(:,281),heltab2x2(:,:,281))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),1,nMT,G2tensor(249),n2h1(269))
  call Hloop_VQ_A(ntryL,G1H2(43),ex1(:),G1H1(1),m3h2x1(:,282),heltab2x2(:,:,282))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,nMT,G2tensor(250),n2h1(270))
  call Hloop_ZQ_A(ntryL,G1H2(47),ex1(:),G1H1(1),ngZu,m3h2x1(:,283),heltab2x2(:,:,283))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,nMT,G2tensor(251),n2h1(271))
  call Hloop_ZQ_A(ntryL,G1H2(48),ex1(:),G1H1(1),ngZu,m3h2x1(:,284),heltab2x2(:,:,284))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),1,nMT,G2tensor(252),n2h1(272))
  call Hloop_ZQ_A(ntryL,G1H2(58),ex1(:),G1H1(1),ngZu,m3h2x1(:,285),heltab2x2(:,:,285))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,nMT,G2tensor(253),n2h1(273))
  call Hloop_WQ_A(ntryL,G1H2(59),ex1(:),G1H1(1),m3h2x1(:,286),heltab2x2(:,:,286))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,nMB,G2tensor(254),n2h1(274))
  call Hloop_WQ_A(ntryL,G1H2(64),ex1(:),G1H1(1),m3h2x1(:,287),heltab2x2(:,:,287))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),1,nMB,G2tensor(255),n2h1(275))
  call Hloop_WQ_A(ntryL,G1H2(76),ex1(:),G1H1(1),m3h2x1(:,288),heltab2x2(:,:,288))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,nMB,G2tensor(256),n2h1(276))
  call Hloop_QV_A(ntryL,G1H2(80),ex4(:),G1H1(1),m3h2x1(:,289),heltab2x2(:,:,289))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,nMT,G2tensor(257),n2h1(277))
  call Hloop_QV_A(ntryL,G1H2(81),ex4(:),G1H1(1),m3h2x1(:,290),heltab2x2(:,:,290))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),8,nMT,G2tensor(258),n2h1(278))
  call Hloop_QV_A(ntryL,G1H2(91),ex4(:),G1H1(1),m3h2x1(:,291),heltab2x2(:,:,291))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,nMT,G2tensor(259),n2h1(279))
  call Hloop_QV_A(ntryL,G1H2(92),ex3(:),G1H1(1),m3h2x1(:,292),heltab2x2(:,:,292))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,nMT,G2tensor(260),n2h1(280))
  call Hloop_QV_A(ntryL,G1H2(97),ex3(:),G1H1(1),m3h2x1(:,293),heltab2x2(:,:,293))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),4,nMT,G2tensor(261),n2h1(281))
  call Hloop_QV_A(ntryL,G1H2(103),ex3(:),G1H1(1),m3h2x1(:,294),heltab2x2(:,:,294))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,nMT,G2tensor(262),n2h1(282))
  call Hloop_QV_A(ntryL,G1H2(108),ex4(:),G1H1(1),m3h2x1(:,295),heltab2x2(:,:,295))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,nMT,G2tensor(263),n2h1(283))
  call Hloop_QV_A(ntryL,G1H2(109),ex4(:),G1H1(1),m3h2x1(:,296),heltab2x2(:,:,296))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),8,nMT,G2tensor(264),n2h1(284))
  call Hloop_QV_A(ntryL,G1H2(119),ex4(:),G1H1(1),m3h2x1(:,297),heltab2x2(:,:,297))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,nMT,G2tensor(265),n2h1(285))
  call Hloop_QV_A(ntryL,G1H2(120),ex3(:),G1H1(1),m3h2x1(:,298),heltab2x2(:,:,298))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,nMT,G2tensor(266),n2h1(286))
  call Hloop_QV_A(ntryL,G1H2(124),ex3(:),G1H1(1),m3h2x1(:,299),heltab2x2(:,:,299))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),4,nMT,G2tensor(267),n2h1(287))
  call Hloop_QV_A(ntryL,G1H2(131),ex3(:),G1H1(1),m3h2x1(:,300),heltab2x2(:,:,300))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,nMT,G2tensor(268),n2h1(288))
  call Hloop_QV_A(ntryL,G1H2(135),ex4(:),G1H1(1),m3h2x1(:,301),heltab2x2(:,:,301))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,nMB,G2tensor(269),n2h1(289))
  call Hloop_QV_A(ntryL,G1H2(136),ex4(:),G1H1(1),m3h2x1(:,302),heltab2x2(:,:,302))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),8,nMB,G2tensor(270),n2h1(290))
  call Hloop_QV_A(ntryL,G1H2(29),ex4(:),G1H1(1),m3h2x1(:,303),heltab2x2(:,:,303))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,nMB,G2tensor(271),n2h1(291))
  call Hloop_QV_A(ntryL,G1H2(51),ex3(:),G1H1(1),m3h2x1(:,304),heltab2x2(:,:,304))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,nMB,G2tensor(272),n2h1(292))
  call Hloop_QV_A(ntryL,G1H2(73),ex3(:),G1H1(1),m3h2x1(:,305),heltab2x2(:,:,305))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),4,nMB,G2tensor(273),n2h1(293))
  call Hloop_QV_A(ntryL,G1H2(95),ex3(:),G1H1(1),m3h2x1(:,306),heltab2x2(:,:,306))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,nMB,G2tensor(274),n2h1(294))
  call Hloop_QV_A(ntryL,G1H2(106),ex4(:),G1H1(1),m3h2x1(:,307),heltab2x2(:,:,307))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,nMT,G2tensor(275),n2h1(295))
  call Hloop_QV_A(ntryL,G1H2(150),ex4(:),G1H1(1),m3h2x1(:,308),heltab2x2(:,:,308))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),8,nMT,G2tensor(276),n2h1(296))
  call Hloop_QV_A(ntryL,G1H2(139),ex4(:),G1H1(1),m3h2x1(:,309),heltab2x2(:,:,309))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,nMT,G2tensor(277),n2h1(297))
  call Hloop_QV_A(ntryL,G1H2(115),ex3(:),G1H1(1),m3h2x1(:,310),heltab2x2(:,:,310))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,nMT,G2tensor(278),n2h1(298))
  call Hloop_QV_A(ntryL,G1H2(161),ex3(:),G1H1(1),m3h2x1(:,311),heltab2x2(:,:,311))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),4,nMT,G2tensor(279),n2h1(299))
  call Hloop_QV_A(ntryL,G1H2(137),ex3(:),G1H1(1),m3h2x1(:,312),heltab2x2(:,:,312))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,nMT,G2tensor(280),n2h1(300))
  call Hloop_AV_Q(ntryL,G1H2(304),ex3(:),G1H1(1),m3h2x1(:,313),heltab2x2(:,:,313))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,nMT,G2tensor(281),n2h1(301))
  call Hloop_AV_Q(ntryL,G1H2(183),ex3(:),G1H1(1),m3h2x1(:,314),heltab2x2(:,:,314))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),4,nMT,G2tensor(282),n2h1(302))
  call Hloop_AV_Q(ntryL,G1H2(205),ex3(:),G1H1(1),m3h2x1(:,315),heltab2x2(:,:,315))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,nMT,G2tensor(283),n2h1(303))
  call Hloop_AV_Q(ntryL,G1H2(216),ex4(:),G1H1(1),m3h2x1(:,316),heltab2x2(:,:,316))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,nMT,G2tensor(284),n2h1(304))
  call Hloop_AV_Q(ntryL,G1H2(315),ex4(:),G1H1(1),m3h2x1(:,317),heltab2x2(:,:,317))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),8,nMT,G2tensor(285),n2h1(305))
  call Hloop_AV_Q(ntryL,G1H2(27),ex4(:),G1H1(1),m3h2x1(:,318),heltab2x2(:,:,318))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,nMT,G2tensor(286),n2h1(306))
  call Hloop_AV_Q(ntryL,G1H2(249),ex3(:),G1H1(1),m3h2x1(:,319),heltab2x2(:,:,319))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,nMT,G2tensor(287),n2h1(307))
  call Hloop_AV_Q(ntryL,G1H2(38),ex3(:),G1H1(1),m3h2x1(:,320),heltab2x2(:,:,320))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),4,nMT,G2tensor(288),n2h1(308))
  call Hloop_AV_Q(ntryL,G1H2(336),ex3(:),G1H1(1),m3h2x1(:,321),heltab2x2(:,:,321))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,nMT,G2tensor(289),n2h1(309))
  call Hloop_AV_Q(ntryL,G1H2(271),ex4(:),G1H1(1),m3h2x1(:,322),heltab2x2(:,:,322))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,nMT,G2tensor(290),n2h1(310))
  call Hloop_AV_Q(ntryL,G1H2(60),ex4(:),G1H1(1),m3h2x1(:,323),heltab2x2(:,:,323))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),8,nMT,G2tensor(291),n2h1(311))
  call Hloop_AV_Q(ntryL,G1H2(69),ex4(:),G1H1(1),m3h2x1(:,324),heltab2x2(:,:,324))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,nMT,G2tensor(292),n2h1(312))
  call Hloop_AV_Q(ntryL,G1H2(17),ex3(:),G1H1(1),m3h2x1(:,325),heltab2x2(:,:,325))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,nMB,G2tensor(293),n2h1(313))
  call Hloop_AV_Q(ntryL,G1H2(5),ex3(:),G1H1(1),m3h2x1(:,326),heltab2x2(:,:,326))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),4,nMB,G2tensor(294),n2h1(314))
  call Hloop_AV_Q(ntryL,G1H2(23),ex3(:),G1H1(1),m3h2x1(:,327),heltab2x2(:,:,327))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,nMB,G2tensor(295),n2h1(315))
  call Hloop_AV_Q(ntryL,G1H2(11),ex4(:),G1H1(1),m3h2x1(:,328),heltab2x2(:,:,328))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,nMB,G2tensor(296),n2h1(316))
  call Hloop_AV_Q(ntryL,G1H2(175),ex4(:),G1H1(1),m3h2x1(:,329),heltab2x2(:,:,329))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),8,nMB,G2tensor(297),n2h1(317))
  call Hloop_AV_Q(ntryL,G1H2(4),ex4(:),G1H1(1),m3h2x1(:,330),heltab2x2(:,:,330))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,nMB,G2tensor(298),n2h1(318))
  call Hloop_AV_Q(ntryL,G1H2(9),ex3(:),G1H1(1),m3h2x1(:,331),heltab2x2(:,:,331))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,nMT,G2tensor(299),n2h1(319))
  call Hloop_AV_Q(ntryL,G1H2(10),ex3(:),G1H1(1),m3h2x1(:,332),heltab2x2(:,:,332))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),4,nMT,G2tensor(300),n2h1(320))
  call Hloop_AV_Q(ntryL,G1H2(21),ex3(:),G1H1(1),m3h2x1(:,333),heltab2x2(:,:,333))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,nMT,G2tensor(301),n2h1(321))
  call Hloop_AV_Q(ntryL,G1H2(22),ex4(:),G1H1(1),m3h2x1(:,334),heltab2x2(:,:,334))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,nMT,G2tensor(302),n2h1(322))
  call Hloop_AV_Q(ntryL,G1H2(28),ex4(:),G1H1(1),m3h2x1(:,335),heltab2x2(:,:,335))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),8,nMT,G2tensor(303),n2h1(323))
  call Hloop_AV_Q(ntryL,G1H2(39),ex4(:),G1H1(1),m3h2x1(:,336),heltab2x2(:,:,336))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,nMT,G2tensor(304),n2h1(324))
  call Hloop_AV_Q(ntryL,G1H2(314),ex4(:),G1H1(1),m3h2x1(:,337),heltab2x2(:,:,337))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,nMT,G2tensor(305),n2h1(325))
  call Hloop_AV_Q(ntryL,G1H2(50),ex4(:),G1H1(1),m3h2x1(:,338),heltab2x2(:,:,338))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),8,nMT,G2tensor(306),n2h1(326))
  call Hloop_AV_Q(ntryL,G1H2(71),ex4(:),G1H1(1),m3h2x1(:,339),heltab2x2(:,:,339))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,nMT,G2tensor(307),n2h1(327))
  call Hloop_AV_Q(ntryL,G1H2(105),ex3(:),G1H1(1),m3h2x1(:,340),heltab2x2(:,:,340))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,nMT,G2tensor(308),n2h1(328))
  call Hloop_AV_Q(ntryL,G1H2(83),ex3(:),G1H1(1),m3h2x1(:,341),heltab2x2(:,:,341))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),4,nMT,G2tensor(309),n2h1(329))
  call Hloop_AV_Q(ntryL,G1H2(78),ex3(:),G1H1(1),m3h2x1(:,342),heltab2x2(:,:,342))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,nMT,G2tensor(310),n2h1(330))
  call Hloop_AV_Q(ntryL,G1H2(82),ex4(:),G1H1(1),m3h2x1(:,343),heltab2x2(:,:,343))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,nMT,G2tensor(311),n2h1(331))
  call Hloop_AV_Q(ntryL,G1H2(93),ex4(:),G1H1(1),m3h2x1(:,344),heltab2x2(:,:,344))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),8,nMT,G2tensor(312),n2h1(332))
  call Hloop_AV_Q(ntryL,G1H2(104),ex4(:),G1H1(1),m3h2x1(:,345),heltab2x2(:,:,345))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,nMT,G2tensor(313),n2h1(333))
  call Hloop_AV_Q(ntryL,G1H2(116),ex3(:),G1H1(1),m3h2x1(:,346),heltab2x2(:,:,346))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,nMT,G2tensor(314),n2h1(334))
  call Hloop_AV_Q(ntryL,G1H2(134),ex3(:),G1H1(1),m3h2x1(:,347),heltab2x2(:,:,347))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),4,nMT,G2tensor(315),n2h1(335))
  call Hloop_AV_Q(ntryL,G1H2(292),ex3(:),G1H1(1),m3h2x1(:,348),heltab2x2(:,:,348))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,nMT,G2tensor(316),n2h1(336))
  call Hloop_AV_Q(ntryL,G1H2(138),ex4(:),G1H1(1),m3h2x1(:,349),heltab2x2(:,:,349))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,nMB,G2tensor(317),n2h1(337))
  call Hloop_AV_Q(ntryL,G1H2(144),ex4(:),G1H1(1),m3h2x1(:,350),heltab2x2(:,:,350))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),8,nMB,G2tensor(318),n2h1(338))
  call Hloop_AV_Q(ntryL,G1H2(193),ex4(:),G1H1(1),m3h2x1(:,351),heltab2x2(:,:,351))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,nMB,G2tensor(319),n2h1(339))
  call Hloop_AV_Q(ntryL,G1H2(171),ex3(:),G1H1(1),m3h2x1(:,352),heltab2x2(:,:,352))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,nMB,G2tensor(320),n2h1(340))
  call Hloop_AV_Q(ntryL,G1H2(160),ex3(:),G1H1(1),m3h2x1(:,353),heltab2x2(:,:,353))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),4,nMB,G2tensor(321),n2h1(341))
  call Hloop_AV_Q(ntryL,G1H2(170),ex3(:),G1H1(1),m3h2x1(:,354),heltab2x2(:,:,354))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,nMB,G2tensor(322),n2h1(342))
  call Hloop_AV_Q(ntryL,G1H2(181),ex4(:),G1H1(1),m3h2x1(:,355),heltab2x2(:,:,355))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,nMT,G2tensor(323),n2h1(343))
  call Hloop_AV_Q(ntryL,G1H2(182),ex4(:),G1H1(1),m3h2x1(:,356),heltab2x2(:,:,356))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),8,nMT,G2tensor(324),n2h1(344))
  call Hloop_AV_Q(ntryL,G1H2(203),ex4(:),G1H1(1),m3h2x1(:,357),heltab2x2(:,:,357))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,nMT,G2tensor(325),n2h1(345))
  call Hloop_AV_Q(ntryL,G1H2(237),ex3(:),G1H1(1),m3h2x1(:,358),heltab2x2(:,:,358))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,nMT,G2tensor(326),n2h1(346))
  call Hloop_AV_Q(ntryL,G1H2(215),ex3(:),G1H1(1),m3h2x1(:,359),heltab2x2(:,:,359))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),4,nMT,G2tensor(327),n2h1(347))
  call Hloop_AV_Q(ntryL,G1H2(210),ex3(:),G1H1(1),m3h2x1(:,360),heltab2x2(:,:,360))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,nMT,G2tensor(328),n2h1(348))
  call Hloop_SQ_A(ntryL,G1H2(214),ex1(:),G1H1(1),ngPbt,m3h2x1(:,361),heltab2x2(:,:,361))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,nMB,G2tensor(329),n2h1(349))
  call Hloop_SQ_A(ntryL,G1H2(225),ex1(:),G1H1(1),ngPbt,m3h2x1(:,362),heltab2x2(:,:,362))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),1,nMB,G2tensor(330),n2h1(350))
  call Hloop_SQ_A(ntryL,G1H2(236),ex1(:),G1H1(1),ngPbt,m3h2x1(:,363),heltab2x2(:,:,363))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,nMB,G2tensor(331),n2h1(351))
  call Hloop_WQ_A(ntryL,G1H2(247),ex1(:),G1H1(1),m3h2x1(:,364),heltab2x2(:,:,364))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,nMB,G2tensor(332),n2h1(352))
  call Hloop_WQ_A(ntryL,G1H2(281),ex1(:),G1H1(1),m3h2x1(:,365),heltab2x2(:,:,365))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),1,nMB,G2tensor(333),n2h1(353))
  call Hloop_WQ_A(ntryL,G1H2(265),ex1(:),G1H1(1),m3h2x1(:,366),heltab2x2(:,:,366))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,nMB,G2tensor(334),n2h1(354))
  call Hloop_SQ_A(ntryL,G1H2(254),ex1(:),G1H1(1),ngPbt,m3h2x1(:,367),heltab2x2(:,:,367))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,nMB,G2tensor(335),n2h1(355))
  call Hloop_SQ_A(ntryL,G1H2(258),ex1(:),G1H1(1),ngPbt,m3h2x1(:,368),heltab2x2(:,:,368))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),1,nMB,G2tensor(336),n2h1(356))
  call Hloop_SQ_A(ntryL,G1H2(277),ex1(:),G1H1(1),ngPbt,m3h2x1(:,369),heltab2x2(:,:,369))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,nMB,G2tensor(337),n2h1(357))
  call Hloop_WQ_A(ntryL,G1H2(280),ex1(:),G1H1(1),m3h2x1(:,370),heltab2x2(:,:,370))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,nMB,G2tensor(338),n2h1(358))
  call Hloop_WQ_A(ntryL,G1H2(291),ex1(:),G1H1(1),m3h2x1(:,371),heltab2x2(:,:,371))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),1,nMB,G2tensor(339),n2h1(359))
  call Hloop_WQ_A(ntryL,G1H2(313),ex1(:),G1H1(1),m3h2x1(:,372),heltab2x2(:,:,372))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,nMB,G2tensor(340),n2h1(360))
  call Hloop_SA_Q(ntryL,G1H2(326),ex2(:),G1H1(1),ngPtb,m3h2x1(:,373),heltab2x2(:,:,373))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,nMB,G2tensor(341),n2h1(361))
  call Hloop_SA_Q(ntryL,G1H2(331),ex2(:),G1H1(1),ngPtb,m3h2x1(:,374),heltab2x2(:,:,374))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),2,nMB,G2tensor(342),n2h1(362))
  call Hloop_SA_Q(ntryL,G1H2(142),ex2(:),G1H1(1),ngPtb,m3h2x1(:,375),heltab2x2(:,:,375))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,nMB,G2tensor(343),n2h1(363))
  call Hloop_WA_Q(ntryL,G1H2(147),ex2(:),G1H1(1),m3h2x1(:,376),heltab2x2(:,:,376))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,nMB,G2tensor(344),n2h1(364))
  call Hloop_WA_Q(ntryL,G1H2(141),ex2(:),G1H1(1),m3h2x1(:,377),heltab2x2(:,:,377))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),2,nMB,G2tensor(345),n2h1(365))
  call Hloop_WA_Q(ntryL,G1H2(158),ex2(:),G1H1(1),m3h2x1(:,378),heltab2x2(:,:,378))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,nMB,G2tensor(346),n2h1(366))
  call Hcheck_last_SV_T(ntryL,l_switch,G1H2(152),23,ex4(:),8,G2tensor(347),m3h2x1(:,379),heltab2x2(:,:,379))
  call Hcheck_last_SV_T(ntryL,l_switch,G1H2(157),0,ex4(:),8,G2tensor(348),m3h2x1(:,380),heltab2x2(:,:,380))
  call Hcheck_last_SV_T(ntryL,l_switch,G1H2(180),23,ex4(:),8,G2tensor(349),m3h2x1(:,381),heltab2x2(:,:,381))
  call Hloop_SA_Q(ntryL,G1H2(174),ex2(:),G1H1(1),ngPtb,m3h2x1(:,382),heltab2x2(:,:,382))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,nMB,G2tensor(350),n2h1(368))
  call Hloop_SA_Q(ntryL,G1H2(353),ex2(:),G1H1(1),ngPtb,m3h2x1(:,383),heltab2x2(:,:,383))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),2,nMB,G2tensor(351),n2h1(369))
  call Hloop_SA_Q(ntryL,G1H2(356),ex2(:),G1H1(1),ngPtb,m3h2x1(:,384),heltab2x2(:,:,384))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,nMB,G2tensor(352),n2h1(370))
  call Hcheck_last_UW_V(ntryL,l_switch,G1H2(357),23,ex4(:),8,G2tensor(353),m3h2x1(:,385),heltab2x2(:,:,385))
  call Hcheck_last_UW_V(ntryL,l_switch,G1H2(358),0,ex4(:),8,G2tensor(354),m3h2x1(:,386),heltab2x2(:,:,386))
  call Hcheck_last_UW_V(ntryL,l_switch,G1H2(361),23,ex4(:),8,G2tensor(355),m3h2x1(:,387),heltab2x2(:,:,387))
  call Hloop_WA_Q(ntryL,G1H2(362),ex2(:),G1H1(1),m3h2x1(:,388),heltab2x2(:,:,388))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,nMB,G2tensor(356),n2h1(372))
  call Hloop_WA_Q(ntryL,G1H2(363),ex2(:),G1H1(1),m3h2x1(:,389),heltab2x2(:,:,389))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),2,nMB,G2tensor(357),n2h1(373))
  call Hloop_WA_Q(ntryL,G1H2(366),ex2(:),G1H1(1),m3h2x1(:,390),heltab2x2(:,:,390))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,nMB,G2tensor(358),n2h1(374))
  call Hloop_SA_Q(ntryL,G1H2(367),ex2(:),G1H1(1),ngPtb,m3h2x1(:,391),heltab2x2(:,:,391))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,nMB,G2tensor(359),n2h1(375))
  call Hloop_SA_Q(ntryL,G1H2(368),ex2(:),G1H1(1),ngPtb,m3h2x1(:,392),heltab2x2(:,:,392))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),2,nMB,G2tensor(360),n2h1(376))
  call Hloop_SA_Q(ntryL,G1H2(371),ex2(:),G1H1(1),ngPtb,m3h2x1(:,393),heltab2x2(:,:,393))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,nMB,G2tensor(361),n2h1(377))
  call Hloop_WA_Q(ntryL,G1H2(372),ex2(:),G1H1(1),m3h2x1(:,394),heltab2x2(:,:,394))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,nMB,G2tensor(362),n2h1(378))
  call Hloop_WA_Q(ntryL,G1H2(373),ex2(:),G1H1(1),m3h2x1(:,395),heltab2x2(:,:,395))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),2,nMB,G2tensor(363),n2h1(379))
  call Hloop_WA_Q(ntryL,G1H2(376),ex2(:),G1H1(1),m3h2x1(:,396),heltab2x2(:,:,396))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,nMB,G2tensor(364),n2h1(380))
  call Hcheck_last_SV_T(ntryL,l_switch,G1H2(377),27,ex3(:),4,G2tensor(365),m3h2x1(:,397),heltab2x2(:,:,397))
  call Hcheck_last_SV_T(ntryL,l_switch,G1H2(378),0,ex3(:),4,G2tensor(366),m3h2x1(:,398),heltab2x2(:,:,398))
  call Hcheck_last_SV_T(ntryL,l_switch,G1H2(381),27,ex3(:),4,G2tensor(367),m3h2x1(:,399),heltab2x2(:,:,399))
  call Hcheck_last_UW_V(ntryL,l_switch,G1H2(382),27,ex3(:),4,G2tensor(368),m3h2x1(:,400),heltab2x2(:,:,400))
  call Hcheck_last_UW_V(ntryL,l_switch,G1H2(383),0,ex3(:),4,G2tensor(369),m3h2x1(:,401),heltab2x2(:,:,401))
  call Hcheck_last_UW_V(ntryL,l_switch,G1H2(386),27,ex3(:),4,G2tensor(370),m3h2x1(:,402),heltab2x2(:,:,402))
  call Hloop_SA_Q(ntryL,G1H2(387),ex2(:),G1H1(1),ngPtb,m3h2x1(:,403),heltab2x2(:,:,403))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,nMB,G2tensor(371),n2h1(383))
  call Hloop_SA_Q(ntryL,G1H2(388),ex2(:),G1H1(1),ngPtb,m3h2x1(:,404),heltab2x2(:,:,404))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),2,nMB,G2tensor(372),n2h1(384))
  call Hloop_SA_Q(ntryL,G1H2(391),ex2(:),G1H1(1),ngPtb,m3h2x1(:,405),heltab2x2(:,:,405))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,nMB,G2tensor(373),n2h1(385))
  call Hloop_SA_Q(ntryL,G1H2(392),ex2(:),G1H1(1),ngPtb,m3h2x1(:,406),heltab2x2(:,:,406))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,nMB,G2tensor(374),n2h1(386))
  call Hloop_SA_Q(ntryL,G1H2(393),ex2(:),G1H1(1),ngPtb,m3h2x1(:,407),heltab2x2(:,:,407))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),2,nMB,G2tensor(375),n2h1(387))
  call Hloop_SA_Q(ntryL,G1H2(396),ex2(:),G1H1(1),ngPtb,m3h2x1(:,408),heltab2x2(:,:,408))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,nMB,G2tensor(376),n2h1(388))
  call Hloop_WA_Q(ntryL,G1H2(397),ex2(:),G1H1(1),m3h2x1(:,409),heltab2x2(:,:,409))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,nMB,G2tensor(377),n2h1(389))
  call Hloop_WA_Q(ntryL,G1H2(398),ex2(:),G1H1(1),m3h2x1(:,410),heltab2x2(:,:,410))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),2,nMB,G2tensor(378),n2h1(390))
  call Hloop_WA_Q(ntryL,G1H2(401),ex2(:),G1H1(1),m3h2x1(:,411),heltab2x2(:,:,411))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,nMB,G2tensor(379),n2h1(391))
  call Hloop_WA_Q(ntryL,G1H2(402),ex2(:),G1H1(1),m3h2x1(:,412),heltab2x2(:,:,412))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,nMB,G2tensor(380),n2h1(392))
  call Hloop_WA_Q(ntryL,G1H2(403),ex2(:),G1H1(1),m3h2x1(:,413),heltab2x2(:,:,413))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),2,nMB,G2tensor(381),n2h1(393))
  call Hloop_WA_Q(ntryL,G1H2(406),ex2(:),G1H1(1),m3h2x1(:,414),heltab2x2(:,:,414))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,nMB,G2tensor(382),n2h1(394))
  call Hloop_SA_Q(ntryL,G1H2(407),ex2(:),G1H1(1),ngPtb,m3h2x1(:,415),heltab2x2(:,:,415))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,nMB,G2tensor(383),n2h1(395))
  call Hloop_SA_Q(ntryL,G1H2(408),ex2(:),G1H1(1),ngPtb,m3h2x1(:,416),heltab2x2(:,:,416))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),2,nMB,G2tensor(384),n2h1(396))
  call Hloop_SA_Q(ntryL,G1H2(411),ex2(:),G1H1(1),ngPtb,m3h2x1(:,417),heltab2x2(:,:,417))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,nMB,G2tensor(385),n2h1(397))
  call Hloop_SA_Q(ntryL,G1H2(412),ex2(:),G1H1(1),ngPtb,m3h2x1(:,418),heltab2x2(:,:,418))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,nMB,G2tensor(386),n2h1(398))
  call Hloop_SA_Q(ntryL,G1H2(413),ex2(:),G1H1(1),ngPtb,m3h2x1(:,419),heltab2x2(:,:,419))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),2,nMB,G2tensor(387),n2h1(399))
  call Hloop_SA_Q(ntryL,G1H2(416),ex2(:),G1H1(1),ngPtb,m3h2x1(:,420),heltab2x2(:,:,420))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,nMB,G2tensor(388),n2h1(400))
  call Hloop_WA_Q(ntryL,G1H2(417),ex2(:),G1H1(1),m3h2x1(:,421),heltab2x2(:,:,421))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,nMB,G2tensor(389),n2h1(401))
  call Hloop_WA_Q(ntryL,G1H2(418),ex2(:),G1H1(1),m3h2x1(:,422),heltab2x2(:,:,422))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),2,nMB,G2tensor(390),n2h1(402))
  call Hloop_WA_Q(ntryL,G1H2(421),ex2(:),G1H1(1),m3h2x1(:,423),heltab2x2(:,:,423))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,nMB,G2tensor(391),n2h1(403))
  call Hloop_WA_Q(ntryL,G1H2(422),ex2(:),G1H1(1),m3h2x1(:,424),heltab2x2(:,:,424))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,nMB,G2tensor(392),n2h1(404))
  call Hloop_WA_Q(ntryL,G1H2(423),ex2(:),G1H1(1),m3h2x1(:,425),heltab2x2(:,:,425))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),2,nMB,G2tensor(393),n2h1(405))
  call Hloop_WA_Q(ntryL,G1H2(426),ex2(:),G1H1(1),m3h2x1(:,426),heltab2x2(:,:,426))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,nMB,G2tensor(394),n2h1(406))
  call Hloop_AV_Q(ntryL,G1H2(427),ex4(:),G1H1(1),m3h2x1(:,427),heltab2x2(:,:,427))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,nMT,G2tensor(395),n2h1(407))
  call Hloop_AV_Q(ntryL,G1H2(428),ex4(:),G1H1(1),m3h2x1(:,428),heltab2x2(:,:,428))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),8,nMT,G2tensor(396),n2h1(408))
  call Hloop_AV_Q(ntryL,G1H2(431),ex4(:),G1H1(1),m3h2x1(:,429),heltab2x2(:,:,429))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,nMT,G2tensor(397),n2h1(409))
  call Hloop_AV_Q(ntryL,G1H2(33),ex4(:),G1H1(1),m3h2x1(:,430),heltab2x2(:,:,430))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,nMT,G2tensor(398),n2h1(410))
  call Hloop_AV_Q(ntryL,G1H2(34),ex4(:),G1H1(1),m3h2x1(:,431),heltab2x2(:,:,431))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),8,nMT,G2tensor(399),n2h1(411))
  call Hloop_AV_Q(ntryL,G1H2(433),ex4(:),G1H1(1),m3h2x1(:,432),heltab2x2(:,:,432))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,nMT,G2tensor(400),n2h1(412))
  call Hloop_AV_Q(ntryL,G1H2(44),ex4(:),G1H1(1),m3h2x1(:,433),heltab2x2(:,:,433))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,nMB,G2tensor(401),n2h1(413))
  call Hloop_AV_Q(ntryL,G1H2(45),ex4(:),G1H1(1),m3h2x1(:,434),heltab2x2(:,:,434))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),8,nMB,G2tensor(402),n2h1(414))
  call Hloop_AV_Q(ntryL,G1H2(436),ex4(:),G1H1(1),m3h2x1(:,435),heltab2x2(:,:,435))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,nMB,G2tensor(403),n2h1(415))
  call Hloop_AV_Q(ntryL,G1H2(55),ex4(:),G1H1(1),m3h2x1(:,436),heltab2x2(:,:,436))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,nMT,G2tensor(404),n2h1(416))
  call Hloop_AV_Q(ntryL,G1H2(320),ex4(:),G1H1(1),m3h2x1(:,437),heltab2x2(:,:,437))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),8,nMT,G2tensor(405),n2h1(417))
  call Hloop_AV_Q(ntryL,G1H2(438),ex4(:),G1H1(1),m3h2x1(:,438),heltab2x2(:,:,438))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,nMT,G2tensor(406),n2h1(418))
  call Hloop_QV_A(ntryL,G1H2(66),ex4(:),G1H1(1),m3h2x1(:,439),heltab2x2(:,:,439))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,nMT,G2tensor(407),n2h1(419))
  call Hloop_QV_A(ntryL,G1H2(67),ex4(:),G1H1(1),m3h2x1(:,440),heltab2x2(:,:,440))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),8,nMT,G2tensor(408),n2h1(420))
  call Hloop_QV_A(ntryL,G1H2(441),ex4(:),G1H1(1),m3h2x1(:,441),heltab2x2(:,:,441))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,nMT,G2tensor(409),n2h1(421))
  call Hloop_QV_A(ntryL,G1H2(442),ex4(:),G1H1(1),m3h2x1(:,442),heltab2x2(:,:,442))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,nMT,G2tensor(410),n2h1(422))
  call Hloop_QV_A(ntryL,G1H2(443),ex4(:),G1H1(1),m3h2x1(:,443),heltab2x2(:,:,443))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),8,nMT,G2tensor(411),n2h1(423))
  call Hloop_QV_A(ntryL,G1H2(446),ex4(:),G1H1(1),m3h2x1(:,444),heltab2x2(:,:,444))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,nMT,G2tensor(412),n2h1(424))
  call Hloop_QV_A(ntryL,G1H2(77),ex4(:),G1H1(1),m3h2x1(:,445),heltab2x2(:,:,445))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,nMT,G2tensor(413),n2h1(425))
  call Hloop_QV_A(ntryL,G1H2(111),ex4(:),G1H1(1),m3h2x1(:,446),heltab2x2(:,:,446))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),8,nMT,G2tensor(414),n2h1(426))
  call Hloop_QV_A(ntryL,G1H2(448),ex4(:),G1H1(1),m3h2x1(:,447),heltab2x2(:,:,447))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,nMT,G2tensor(415),n2h1(427))
  call Hloop_QV_A(ntryL,G1H2(88),ex4(:),G1H1(1),m3h2x1(:,448),heltab2x2(:,:,448))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,nMB,G2tensor(416),n2h1(428))
  call Hloop_QV_A(ntryL,G1H2(90),ex4(:),G1H1(1),m3h2x1(:,449),heltab2x2(:,:,449))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),8,nMB,G2tensor(417),n2h1(429))
  call Hloop_QV_A(ntryL,G1H2(451),ex4(:),G1H1(1),m3h2x1(:,450),heltab2x2(:,:,450))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,nMB,G2tensor(418),n2h1(430))
  call Hloop_QV_A(ntryL,G1H2(452),ex4(:),G1H1(1),m3h2x1(:,451),heltab2x2(:,:,451))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,nMB,G2tensor(419),n2h1(431))
  call Hloop_QV_A(ntryL,G1H2(453),ex4(:),G1H1(1),m3h2x1(:,452),heltab2x2(:,:,452))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),8,nMB,G2tensor(420),n2h1(432))
  call Hloop_QV_A(ntryL,G1H2(456),ex4(:),G1H1(1),m3h2x1(:,453),heltab2x2(:,:,453))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,nMB,G2tensor(421),n2h1(433))
  call Hloop_QV_A(ntryL,G1H2(99),ex4(:),G1H1(1),m3h2x1(:,454),heltab2x2(:,:,454))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,nMT,G2tensor(422),n2h1(434))
  call Hloop_QV_A(ntryL,G1H2(100),ex4(:),G1H1(1),m3h2x1(:,455),heltab2x2(:,:,455))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),8,nMT,G2tensor(423),n2h1(435))
  call Hloop_QV_A(ntryL,G1H2(458),ex4(:),G1H1(1),m3h2x1(:,456),heltab2x2(:,:,456))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,nMT,G2tensor(424),n2h1(436))
  call Hloop_QV_A(ntryL,G1H2(110),ex4(:),G1H1(1),m3h2x1(:,457),heltab2x2(:,:,457))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,nMT,G2tensor(425),n2h1(437))
  call Hloop_QV_A(ntryL,G1H2(112),ex4(:),G1H1(1),m3h2x1(:,458),heltab2x2(:,:,458))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),8,nMT,G2tensor(426),n2h1(438))
  call Hloop_QV_A(ntryL,G1H2(461),ex4(:),G1H1(1),m3h2x1(:,459),heltab2x2(:,:,459))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,nMT,G2tensor(427),n2h1(439))
  call Hloop_QV_A(ntryL,G1H2(121),ex4(:),G1H1(1),m3h2x1(:,460),heltab2x2(:,:,460))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,nMT,G2tensor(428),n2h1(440))
  call Hloop_QV_A(ntryL,G1H2(122),ex4(:),G1H1(1),m3h2x1(:,461),heltab2x2(:,:,461))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),8,nMT,G2tensor(429),n2h1(441))
  call Hloop_QV_A(ntryL,G1H2(463),ex4(:),G1H1(1),m3h2x1(:,462),heltab2x2(:,:,462))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,nMT,G2tensor(430),n2h1(442))
  call Hloop_QV_A(ntryL,G1H2(132),ex4(:),G1H1(1),m3h2x1(:,463),heltab2x2(:,:,463))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,nMB,G2tensor(431),n2h1(443))
  call Hloop_QV_A(ntryL,G1H2(133),ex4(:),G1H1(1),m3h2x1(:,464),heltab2x2(:,:,464))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),8,nMB,G2tensor(432),n2h1(444))
  call Hloop_QV_A(ntryL,G1H2(466),ex4(:),G1H1(1),m3h2x1(:,465),heltab2x2(:,:,465))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,nMB,G2tensor(433),n2h1(445))
  call Hloop_QV_A(ntryL,G1H2(143),ex4(:),G1H1(1),m3h2x1(:,466),heltab2x2(:,:,466))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,nMT,G2tensor(434),n2h1(446))
  call Hloop_QV_A(ntryL,G1H2(298),ex4(:),G1H1(1),m3h2x1(:,467),heltab2x2(:,:,467))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),8,nMT,G2tensor(435),n2h1(447))
  call Hloop_QV_A(ntryL,G1H2(468),ex4(:),G1H1(1),m3h2x1(:,468),heltab2x2(:,:,468))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,nMT,G2tensor(436),n2h1(448))
  call Hloop_QV_A(ntryL,G1H2(154),ex3(:),G1H1(1),m3h2x1(:,469),heltab2x2(:,:,469))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,nMT,G2tensor(437),n2h1(449))
  call Hloop_QV_A(ntryL,G1H2(155),ex3(:),G1H1(1),m3h2x1(:,470),heltab2x2(:,:,470))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),4,nMT,G2tensor(438),n2h1(450))
  call Hloop_QV_A(ntryL,G1H2(471),ex3(:),G1H1(1),m3h2x1(:,471),heltab2x2(:,:,471))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,nMT,G2tensor(439),n2h1(451))
  call Hloop_QV_A(ntryL,G1H2(472),ex3(:),G1H1(1),m3h2x1(:,472),heltab2x2(:,:,472))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,nMT,G2tensor(440),n2h1(452))
  call Hloop_QV_A(ntryL,G1H2(473),ex3(:),G1H1(1),m3h2x1(:,473),heltab2x2(:,:,473))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),4,nMT,G2tensor(441),n2h1(453))
  call Hloop_QV_A(ntryL,G1H2(476),ex3(:),G1H1(1),m3h2x1(:,474),heltab2x2(:,:,474))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,nMT,G2tensor(442),n2h1(454))
  call Hloop_QV_A(ntryL,G1H2(165),ex3(:),G1H1(1),m3h2x1(:,475),heltab2x2(:,:,475))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,nMT,G2tensor(443),n2h1(455))
  call Hloop_QV_A(ntryL,G1H2(199),ex3(:),G1H1(1),m3h2x1(:,476),heltab2x2(:,:,476))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),4,nMT,G2tensor(444),n2h1(456))
  call Hloop_QV_A(ntryL,G1H2(478),ex3(:),G1H1(1),m3h2x1(:,477),heltab2x2(:,:,477))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,nMT,G2tensor(445),n2h1(457))
  call Hloop_QV_A(ntryL,G1H2(176),ex3(:),G1H1(1),m3h2x1(:,478),heltab2x2(:,:,478))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,nMB,G2tensor(446),n2h1(458))
  call Hloop_QV_A(ntryL,G1H2(178),ex3(:),G1H1(1),m3h2x1(:,479),heltab2x2(:,:,479))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),4,nMB,G2tensor(447),n2h1(459))
  call Hloop_QV_A(ntryL,G1H2(481),ex3(:),G1H1(1),m3h2x1(:,480),heltab2x2(:,:,480))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,nMB,G2tensor(448),n2h1(460))
  call Hloop_QV_A(ntryL,G1H2(482),ex3(:),G1H1(1),m3h2x1(:,481),heltab2x2(:,:,481))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,nMB,G2tensor(449),n2h1(461))
  call Hloop_QV_A(ntryL,G1H2(483),ex3(:),G1H1(1),m3h2x1(:,482),heltab2x2(:,:,482))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),4,nMB,G2tensor(450),n2h1(462))
  call Hloop_QV_A(ntryL,G1H2(486),ex3(:),G1H1(1),m3h2x1(:,483),heltab2x2(:,:,483))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,nMB,G2tensor(451),n2h1(463))
  call Hloop_QV_A(ntryL,G1H2(187),ex3(:),G1H1(1),m3h2x1(:,484),heltab2x2(:,:,484))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,nMT,G2tensor(452),n2h1(464))
  call Hloop_QV_A(ntryL,G1H2(188),ex3(:),G1H1(1),m3h2x1(:,485),heltab2x2(:,:,485))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),4,nMT,G2tensor(453),n2h1(465))
  call Hloop_QV_A(ntryL,G1H2(488),ex3(:),G1H1(1),m3h2x1(:,486),heltab2x2(:,:,486))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,nMT,G2tensor(454),n2h1(466))
  call Hloop_AV_Q(ntryL,G1H2(198),ex4(:),G1H1(1),m3h2x1(:,487),heltab2x2(:,:,487))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,nMT,G2tensor(455),n2h1(467))
  call Hloop_AV_Q(ntryL,G1H2(200),ex4(:),G1H1(1),m3h2x1(:,488),heltab2x2(:,:,488))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),8,nMT,G2tensor(456),n2h1(468))
  call Hloop_AV_Q(ntryL,G1H2(491),ex4(:),G1H1(1),m3h2x1(:,489),heltab2x2(:,:,489))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,nMT,G2tensor(457),n2h1(469))
  call Hloop_AV_Q(ntryL,G1H2(492),ex4(:),G1H1(1),m3h2x1(:,490),heltab2x2(:,:,490))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,nMT,G2tensor(458),n2h1(470))
  call Hloop_AV_Q(ntryL,G1H2(493),ex4(:),G1H1(1),m3h2x1(:,491),heltab2x2(:,:,491))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),8,nMT,G2tensor(459),n2h1(471))
  call Hloop_AV_Q(ntryL,G1H2(496),ex4(:),G1H1(1),m3h2x1(:,492),heltab2x2(:,:,492))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,nMT,G2tensor(460),n2h1(472))
  call Hloop_AV_Q(ntryL,G1H2(209),ex4(:),G1H1(1),m3h2x1(:,493),heltab2x2(:,:,493))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,nMT,G2tensor(461),n2h1(473))
  call Hloop_AV_Q(ntryL,G1H2(243),ex4(:),G1H1(1),m3h2x1(:,494),heltab2x2(:,:,494))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),8,nMT,G2tensor(462),n2h1(474))
  call Hloop_AV_Q(ntryL,G1H2(498),ex4(:),G1H1(1),m3h2x1(:,495),heltab2x2(:,:,495))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,nMT,G2tensor(463),n2h1(475))
  call Hloop_AV_Q(ntryL,G1H2(220),ex4(:),G1H1(1),m3h2x1(:,496),heltab2x2(:,:,496))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,nMB,G2tensor(464),n2h1(476))
  call Hloop_AV_Q(ntryL,G1H2(222),ex4(:),G1H1(1),m3h2x1(:,497),heltab2x2(:,:,497))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),8,nMB,G2tensor(465),n2h1(477))
  call Hloop_AV_Q(ntryL,G1H2(501),ex4(:),G1H1(1),m3h2x1(:,498),heltab2x2(:,:,498))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,nMB,G2tensor(466),n2h1(478))
  call Hloop_AV_Q(ntryL,G1H2(502),ex4(:),G1H1(1),m3h2x1(:,499),heltab2x2(:,:,499))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,nMB,G2tensor(467),n2h1(479))
  call Hloop_AV_Q(ntryL,G1H2(503),ex4(:),G1H1(1),m3h2x1(:,500),heltab2x2(:,:,500))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),8,nMB,G2tensor(468),n2h1(480))
  call Hloop_AV_Q(ntryL,G1H2(506),ex4(:),G1H1(1),m3h2x1(:,501),heltab2x2(:,:,501))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,nMB,G2tensor(469),n2h1(481))
  call Hloop_AV_Q(ntryL,G1H2(231),ex4(:),G1H1(1),m3h2x1(:,502),heltab2x2(:,:,502))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,nMT,G2tensor(470),n2h1(482))
  call Hloop_AV_Q(ntryL,G1H2(232),ex4(:),G1H1(1),m3h2x1(:,503),heltab2x2(:,:,503))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),8,nMT,G2tensor(471),n2h1(483))
  call Hloop_AV_Q(ntryL,G1H2(508),ex4(:),G1H1(1),m3h2x1(:,504),heltab2x2(:,:,504))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,nMT,G2tensor(472),n2h1(484))
  call Hloop_AV_Q(ntryL,G1H2(242),ex3(:),G1H1(1),m3h2x1(:,505),heltab2x2(:,:,505))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,nMT,G2tensor(473),n2h1(485))
  call Hloop_AV_Q(ntryL,G1H2(244),ex3(:),G1H1(1),m3h2x1(:,506),heltab2x2(:,:,506))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),4,nMT,G2tensor(474),n2h1(486))
  call Hloop_AV_Q(ntryL,G1H2(511),ex3(:),G1H1(1),m3h2x1(:,507),heltab2x2(:,:,507))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,nMT,G2tensor(475),n2h1(487))
  call Hloop_AV_Q(ntryL,G1H2(512),ex3(:),G1H1(1),m3h2x1(:,508),heltab2x2(:,:,508))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,nMT,G2tensor(476),n2h1(488))
  call Hloop_AV_Q(ntryL,G1H2(513),ex3(:),G1H1(1),m3h2x1(:,509),heltab2x2(:,:,509))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),4,nMT,G2tensor(477),n2h1(489))
  call Hloop_AV_Q(ntryL,G1H2(516),ex3(:),G1H1(1),m3h2x1(:,510),heltab2x2(:,:,510))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,nMT,G2tensor(478),n2h1(490))
  call Hloop_AV_Q(ntryL,G1H2(253),ex3(:),G1H1(1),m3h2x1(:,511),heltab2x2(:,:,511))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,nMT,G2tensor(479),n2h1(491))
  call Hloop_AV_Q(ntryL,G1H2(287),ex3(:),G1H1(1),m3h2x1(:,512),heltab2x2(:,:,512))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),4,nMT,G2tensor(480),n2h1(492))
  call Hloop_AV_Q(ntryL,G1H2(518),ex3(:),G1H1(1),m3h2x1(:,513),heltab2x2(:,:,513))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,nMT,G2tensor(481),n2h1(493))
  call Hloop_AV_Q(ntryL,G1H2(264),ex3(:),G1H1(1),m3h2x1(:,514),heltab2x2(:,:,514))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,nMB,G2tensor(482),n2h1(494))
  call Hloop_AV_Q(ntryL,G1H2(266),ex3(:),G1H1(1),m3h2x1(:,515),heltab2x2(:,:,515))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),4,nMB,G2tensor(483),n2h1(495))
  call Hloop_AV_Q(ntryL,G1H2(521),ex3(:),G1H1(1),m3h2x1(:,516),heltab2x2(:,:,516))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,nMB,G2tensor(484),n2h1(496))
  call Hloop_AV_Q(ntryL,G1H2(522),ex3(:),G1H1(1),m3h2x1(:,517),heltab2x2(:,:,517))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,nMB,G2tensor(485),n2h1(497))
  call Hloop_AV_Q(ntryL,G1H2(523),ex3(:),G1H1(1),m3h2x1(:,518),heltab2x2(:,:,518))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),4,nMB,G2tensor(486),n2h1(498))
  call Hloop_AV_Q(ntryL,G1H2(526),ex3(:),G1H1(1),m3h2x1(:,519),heltab2x2(:,:,519))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,nMB,G2tensor(487),n2h1(499))
  call Hloop_AV_Q(ntryL,G1H2(275),ex3(:),G1H1(1),m3h2x1(:,520),heltab2x2(:,:,520))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,nMT,G2tensor(488),n2h1(500))
  call Hloop_AV_Q(ntryL,G1H2(276),ex3(:),G1H1(1),m3h2x1(:,521),heltab2x2(:,:,521))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),4,nMT,G2tensor(489),n2h1(501))
  call Hloop_AV_Q(ntryL,G1H2(528),ex3(:),G1H1(1),m3h2x1(:,522),heltab2x2(:,:,522))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,nMT,G2tensor(490),n2h1(502))
  call Hloop_QV_A(ntryL,G1H2(286),ex4(:),G1H1(1),m3h2x1(:,523),heltab2x2(:,:,523))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,nMB,G2tensor(491),n2h1(503))
  call Hloop_QV_A(ntryL,G1H2(288),ex4(:),G1H1(1),m3h2x1(:,524),heltab2x2(:,:,524))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),8,nMB,G2tensor(492),n2h1(504))
  call Hloop_QV_A(ntryL,G1H2(531),ex4(:),G1H1(1),m3h2x1(:,525),heltab2x2(:,:,525))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,nMB,G2tensor(493),n2h1(505))
  call Hloop_QV_A(ntryL,G1H2(297),ex3(:),G1H1(1),m3h2x1(:,526),heltab2x2(:,:,526))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,nMB,G2tensor(494),n2h1(506))
  call Hloop_QV_A(ntryL,G1H2(532),ex3(:),G1H1(1),m3h2x1(:,527),heltab2x2(:,:,527))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),4,nMB,G2tensor(495),n2h1(507))
  call Hloop_QV_A(ntryL,G1H2(535),ex3(:),G1H1(1),m3h2x1(:,528),heltab2x2(:,:,528))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,nMB,G2tensor(496),n2h1(508))
  call Hloop_QV_A(ntryL,G1H2(536),ex3(:),G1H1(1),m3h2x1(:,529),heltab2x2(:,:,529))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,nMB,G2tensor(497),n2h1(509))
  call Hloop_QV_A(ntryL,G1H2(537),ex3(:),G1H1(1),m3h2x1(:,530),heltab2x2(:,:,530))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),4,nMB,G2tensor(498),n2h1(510))
  call Hloop_QV_A(ntryL,G1H2(540),ex3(:),G1H1(1),m3h2x1(:,531),heltab2x2(:,:,531))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,nMB,G2tensor(499),n2h1(511))
  call Hloop_AV_Q(ntryL,G1H2(308),ex4(:),G1H1(1),m3h2x1(:,532),heltab2x2(:,:,532))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,nMB,G2tensor(500),n2h1(512))
  call Hloop_AV_Q(ntryL,G1H2(309),ex4(:),G1H1(1),m3h2x1(:,533),heltab2x2(:,:,533))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),8,nMB,G2tensor(501),n2h1(513))
  call Hloop_AV_Q(ntryL,G1H2(543),ex4(:),G1H1(1),m3h2x1(:,534),heltab2x2(:,:,534))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,nMB,G2tensor(502),n2h1(514))
  call Hloop_AV_Q(ntryL,G1H2(319),ex3(:),G1H1(1),m3h2x1(:,535),heltab2x2(:,:,535))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,nMB,G2tensor(503),n2h1(515))
  call Hloop_AV_Q(ntryL,G1H2(324),ex3(:),G1H1(1),m3h2x1(:,536),heltab2x2(:,:,536))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),4,nMB,G2tensor(504),n2h1(516))
  call Hloop_AV_Q(ntryL,G1H2(329),ex3(:),G1H1(1),m3h2x1(:,537),heltab2x2(:,:,537))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,nMB,G2tensor(505),n2h1(517))
  call Hloop_AV_Q(ntryL,G1H2(330),ex3(:),G1H1(1),m3h2x1(:,538),heltab2x2(:,:,538))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,nMB,G2tensor(506),n2h1(518))
  call Hloop_AV_Q(ntryL,G1H2(352),ex3(:),G1H1(1),m3h2x1(:,539),heltab2x2(:,:,539))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),4,nMB,G2tensor(507),n2h1(519))
  call Hloop_AV_Q(ntryL,G1H2(546),ex3(:),G1H1(1),m3h2x1(:,540),heltab2x2(:,:,540))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,nMB,G2tensor(508),n2h1(520))
  call Hloop_SQ_A(ntryL,G1H4(133),wf4(:,3),G1H1(1),ngPbt,m3h4x1(:,1),heltab2x4(:,:,273))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,nMB,G2tensor(509),n2h1(521))
  call Hloop_SQ_A(ntryL,G1H4(134),wf4(:,3),G1H1(1),ngPbt,m3h4x1(:,2),heltab2x4(:,:,274))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),5,nMB,G2tensor(510),n2h1(522))
  call Hloop_SQ_A(ntryL,G1H4(139),wf4(:,3),G1H1(1),ngPbt,m3h4x1(:,3),heltab2x4(:,:,275))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,nMB,G2tensor(511),n2h1(523))
  call Hloop_WQ_A(ntryL,G1H4(140),wf4(:,3),G1H1(1),m3h4x1(:,4),heltab2x4(:,:,276))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,nMB,G2tensor(512),n2h1(524))
  call Hloop_WQ_A(ntryL,G1H4(143),wf4(:,3),G1H1(1),m3h4x1(:,5),heltab2x4(:,:,277))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),5,nMB,G2tensor(513),n2h1(525))
  call Hloop_WQ_A(ntryL,G1H4(146),wf4(:,3),G1H1(1),m3h4x1(:,6),heltab2x4(:,:,278))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,nMB,G2tensor(514),n2h1(526))
  call Hloop_SA_Q(ntryL,G1H4(149),wf4(:,10),G1H1(1),ngPtb,m3h4x1(:,7),heltab2x4(:,:,279))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,nMB,G2tensor(515),n2h1(527))
  call Hloop_SA_Q(ntryL,G1H4(150),wf4(:,10),G1H1(1),ngPtb,m3h4x1(:,8),heltab2x4(:,:,280))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),6,nMB,G2tensor(516),n2h1(528))
  call Hloop_SA_Q(ntryL,G1H4(155),wf4(:,10),G1H1(1),ngPtb,m3h4x1(:,9),heltab2x4(:,:,281))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,nMB,G2tensor(517),n2h1(529))
  call Hloop_WA_Q(ntryL,G1H4(156),wf4(:,10),G1H1(1),m3h4x1(:,10),heltab2x4(:,:,282))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,nMB,G2tensor(518),n2h1(530))
  call Hloop_WA_Q(ntryL,G1H4(157),wf4(:,10),G1H1(1),m3h4x1(:,11),heltab2x4(:,:,283))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),6,nMB,G2tensor(519),n2h1(531))
  call Hloop_WA_Q(ntryL,G1H4(162),wf4(:,10),G1H1(1),m3h4x1(:,12),heltab2x4(:,:,284))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,nMB,G2tensor(520),n2h1(532))
  call Hloop_SQ_A(ntryL,G1H4(163),wf4(:,9),G1H1(1),ngPbt,m3h4x1(:,13),heltab2x4(:,:,285))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,nMB,G2tensor(521),n2h1(533))
  call Hloop_SQ_A(ntryL,G1H4(164),wf4(:,9),G1H1(1),ngPbt,m3h4x1(:,14),heltab2x4(:,:,286))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),9,nMB,G2tensor(522),n2h1(534))
  call Hloop_SQ_A(ntryL,G1H4(169),wf4(:,9),G1H1(1),ngPbt,m3h4x1(:,15),heltab2x4(:,:,287))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,nMB,G2tensor(523),n2h1(535))
  call Hloop_WQ_A(ntryL,G1H4(170),wf4(:,9),G1H1(1),m3h4x1(:,16),heltab2x4(:,:,288))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,nMB,G2tensor(524),n2h1(536))
  call Hloop_WQ_A(ntryL,G1H4(173),wf4(:,9),G1H1(1),m3h4x1(:,17),heltab2x4(:,:,289))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),9,nMB,G2tensor(525),n2h1(537))
  call Hloop_WQ_A(ntryL,G1H4(176),wf4(:,9),G1H1(1),m3h4x1(:,18),heltab2x4(:,:,290))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,nMB,G2tensor(526),n2h1(538))
  call Hloop_SQ_A(ntryL,G1H4(179),wf4(:,9),G1H1(1),ngH,m3h4x1(:,19),heltab2x4(:,:,291))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,nMT,G2tensor(527),n2h1(539))
  call Hloop_SQ_A(ntryL,G1H4(180),wf4(:,9),G1H1(1),ngH,m3h4x1(:,20),heltab2x4(:,:,292))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),9,nMT,G2tensor(528),n2h1(540))
  call Hloop_SQ_A(ntryL,G1H4(185),wf4(:,9),G1H1(1),ngH,m3h4x1(:,21),heltab2x4(:,:,293))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,nMT,G2tensor(529),n2h1(541))
  call Hloop_SQ_A(ntryL,G1H4(186),wf4(:,9),G1H1(1),ngX,m3h4x1(:,22),heltab2x4(:,:,294))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,nMT,G2tensor(530),n2h1(542))
  call Hloop_SQ_A(ntryL,G1H4(187),wf4(:,9),G1H1(1),ngX,m3h4x1(:,23),heltab2x4(:,:,295))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),9,nMT,G2tensor(531),n2h1(543))
  call Hloop_SQ_A(ntryL,G1H4(192),wf4(:,9),G1H1(1),ngX,m3h4x1(:,24),heltab2x4(:,:,296))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,nMT,G2tensor(532),n2h1(544))
  call Hloop_SQ_A(ntryL,G1H4(193),wf4(:,9),G1H1(1),ngPbt,m3h4x1(:,25),heltab2x4(:,:,297))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,nMB,G2tensor(533),n2h1(545))
  call Hloop_SQ_A(ntryL,G1H4(194),wf4(:,9),G1H1(1),ngPbt,m3h4x1(:,26),heltab2x4(:,:,298))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),9,nMB,G2tensor(534),n2h1(546))
  call Hloop_SQ_A(ntryL,G1H4(199),wf4(:,9),G1H1(1),ngPbt,m3h4x1(:,27),heltab2x4(:,:,299))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,nMB,G2tensor(535),n2h1(547))
  call Hloop_VQ_A(ntryL,G1H4(200),wf4(:,9),G1H1(1),m3h4x1(:,28),heltab2x4(:,:,300))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,nMT,G2tensor(536),n2h1(548))
  call Hloop_VQ_A(ntryL,G1H4(203),wf4(:,9),G1H1(1),m3h4x1(:,29),heltab2x4(:,:,301))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),9,nMT,G2tensor(537),n2h1(549))
  call Hloop_VQ_A(ntryL,G1H4(206),wf4(:,9),G1H1(1),m3h4x1(:,30),heltab2x4(:,:,302))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,nMT,G2tensor(538),n2h1(550))
  call Hloop_ZQ_A(ntryL,G1H4(209),wf4(:,9),G1H1(1),ngZu,m3h4x1(:,31),heltab2x4(:,:,303))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,nMT,G2tensor(539),n2h1(551))
  call Hloop_ZQ_A(ntryL,G1H4(210),wf4(:,9),G1H1(1),ngZu,m3h4x1(:,32),heltab2x4(:,:,304))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),9,nMT,G2tensor(540),n2h1(552))
  call Hloop_ZQ_A(ntryL,G1H4(215),wf4(:,9),G1H1(1),ngZu,m3h4x1(:,33),heltab2x4(:,:,305))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,nMT,G2tensor(541),n2h1(553))
  call Hloop_WQ_A(ntryL,G1H4(216),wf4(:,9),G1H1(1),m3h4x1(:,34),heltab2x4(:,:,306))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,nMB,G2tensor(542),n2h1(554))
  call Hloop_WQ_A(ntryL,G1H4(217),wf4(:,9),G1H1(1),m3h4x1(:,35),heltab2x4(:,:,307))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),9,nMB,G2tensor(543),n2h1(555))
  call Hloop_WQ_A(ntryL,G1H4(222),wf4(:,9),G1H1(1),m3h4x1(:,36),heltab2x4(:,:,308))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,nMB,G2tensor(544),n2h1(556))
  call Hloop_SA_Q(ntryL,G1H4(223),wf4(:,4),G1H1(1),ngPtb,m3h4x1(:,37),heltab2x4(:,:,309))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,nMB,G2tensor(545),n2h1(557))
  call Hloop_SA_Q(ntryL,G1H4(224),wf4(:,4),G1H1(1),ngPtb,m3h4x1(:,38),heltab2x4(:,:,310))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),10,nMB,G2tensor(546),n2h1(558))
  call Hloop_SA_Q(ntryL,G1H4(229),wf4(:,4),G1H1(1),ngPtb,m3h4x1(:,39),heltab2x4(:,:,311))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,nMB,G2tensor(547),n2h1(559))
  call Hloop_WA_Q(ntryL,G1H4(230),wf4(:,4),G1H1(1),m3h4x1(:,40),heltab2x4(:,:,312))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,nMB,G2tensor(548),n2h1(560))
  call Hloop_WA_Q(ntryL,G1H4(233),wf4(:,4),G1H1(1),m3h4x1(:,41),heltab2x4(:,:,313))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),10,nMB,G2tensor(549),n2h1(561))
  call Hloop_WA_Q(ntryL,G1H4(236),wf4(:,4),G1H1(1),m3h4x1(:,42),heltab2x4(:,:,314))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,nMB,G2tensor(550),n2h1(562))
  call Hloop_SA_Q(ntryL,G1H4(239),wf4(:,4),G1H1(1),ngH,m3h4x1(:,43),heltab2x4(:,:,315))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,nMT,G2tensor(551),n2h1(563))
  call Hloop_SA_Q(ntryL,G1H4(240),wf4(:,4),G1H1(1),ngH,m3h4x1(:,44),heltab2x4(:,:,316))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),10,nMT,G2tensor(552),n2h1(564))
  call Hloop_SA_Q(ntryL,G1H4(24),wf4(:,4),G1H1(1),ngH,m3h4x1(:,45),heltab2x4(:,:,317))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,nMT,G2tensor(553),n2h1(565))
  call Hloop_SA_Q(ntryL,G1H4(25),wf4(:,4),G1H1(1),ngX,m3h4x1(:,46),heltab2x4(:,:,318))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,nMT,G2tensor(554),n2h1(566))
  call Hloop_SA_Q(ntryL,G1H4(71),wf4(:,4),G1H1(1),ngX,m3h4x1(:,47),heltab2x4(:,:,319))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),10,nMT,G2tensor(555),n2h1(567))
  call Hloop_SA_Q(ntryL,G1H4(77),wf4(:,4),G1H1(1),ngX,m3h4x1(:,48),heltab2x4(:,:,320))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,nMT,G2tensor(556),n2h1(568))
  call Hloop_SA_Q(ntryL,G1H4(4),wf4(:,4),G1H1(1),ngPtb,m3h4x1(:,49),heltab2x4(:,:,321))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,nMB,G2tensor(557),n2h1(569))
  call Hloop_SA_Q(ntryL,G1H4(9),wf4(:,4),G1H1(1),ngPtb,m3h4x1(:,50),heltab2x4(:,:,322))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),10,nMB,G2tensor(558),n2h1(570))
  call Hloop_SA_Q(ntryL,G1H4(22),wf4(:,4),G1H1(1),ngPtb,m3h4x1(:,51),heltab2x4(:,:,323))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,nMB,G2tensor(559),n2h1(571))
  call Hloop_VA_Q(ntryL,G1H4(28),wf4(:,4),G1H1(1),m3h4x1(:,52),heltab2x4(:,:,324))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,nMT,G2tensor(560),n2h1(572))
  call Hloop_VA_Q(ntryL,G1H4(202),wf4(:,4),G1H1(1),m3h4x1(:,53),heltab2x4(:,:,325))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),10,nMT,G2tensor(561),n2h1(573))
  call Hloop_VA_Q(ntryL,G1H4(46),wf4(:,4),G1H1(1),m3h4x1(:,54),heltab2x4(:,:,326))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,nMT,G2tensor(562),n2h1(574))
  call Hloop_ZA_Q(ntryL,G1H4(40),wf4(:,4),G1H1(1),ngZu,m3h4x1(:,55),heltab2x4(:,:,327))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,nMT,G2tensor(563),n2h1(575))
  call Hloop_ZA_Q(ntryL,G1H4(80),wf4(:,4),G1H1(1),ngZu,m3h4x1(:,56),heltab2x4(:,:,328))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),10,nMT,G2tensor(564),n2h1(576))
  call Hloop_ZA_Q(ntryL,G1H4(51),wf4(:,4),G1H1(1),ngZu,m3h4x1(:,57),heltab2x4(:,:,329))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,nMT,G2tensor(565),n2h1(577))
  call Hloop_WA_Q(ntryL,G1H4(57),wf4(:,4),G1H1(1),m3h4x1(:,58),heltab2x4(:,:,330))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,nMB,G2tensor(566),n2h1(578))
  call Hloop_WA_Q(ntryL,G1H4(64),wf4(:,4),G1H1(1),m3h4x1(:,59),heltab2x4(:,:,331))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),10,nMB,G2tensor(567),n2h1(579))
  call Hloop_WA_Q(ntryL,G1H4(76),wf4(:,4),G1H1(1),m3h4x1(:,60),heltab2x4(:,:,332))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,nMB,G2tensor(568),n2h1(580))
  call Hcheck_last_TV_S(ntryL,l_switch,G1H2(340),23,ex4(:),8,G2tensor(569),m3h2x1(:,541),heltab2x2(:,:,541))
  call Hcheck_last_TV_S(ntryL,l_switch,G1H2(341),0,ex4(:),8,G2tensor(570),m3h2x1(:,542),heltab2x2(:,:,542))
  call Hcheck_last_TV_S(ntryL,l_switch,G1H2(350),23,ex4(:),8,G2tensor(571),m3h2x1(:,543),heltab2x2(:,:,543))
  call Hcheck_last_UV_W(ntryL,l_switch,G1H2(351),23,ex4(:),8,G2tensor(572),m3h2x1(:,544),heltab2x2(:,:,544))
  call Hcheck_last_UV_W(ntryL,l_switch,G1H2(547),0,ex4(:),8,G2tensor(573),m3h2x1(:,545),heltab2x2(:,:,545))
  call Hcheck_last_UV_W(ntryL,l_switch,G1H2(550),23,ex4(:),8,G2tensor(574),m3h2x1(:,546),heltab2x2(:,:,546))
  call Hcheck_last_TV_S(ntryL,l_switch,G1H2(551),23,ex4(:),8,G2tensor(575),m3h2x1(:,547),heltab2x2(:,:,547))
  call Hcheck_last_TV_S(ntryL,l_switch,G1H2(552),0,ex4(:),8,G2tensor(576),m3h2x1(:,548),heltab2x2(:,:,548))
  call Hcheck_last_TV_S(ntryL,l_switch,G1H2(555),23,ex4(:),8,G2tensor(577),m3h2x1(:,549),heltab2x2(:,:,549))
  call Hcheck_last_UV_W(ntryL,l_switch,G1H2(556),23,ex4(:),8,G2tensor(578),m3h2x1(:,550),heltab2x2(:,:,550))
  call Hcheck_last_UV_W(ntryL,l_switch,G1H2(557),0,ex4(:),8,G2tensor(579),m3h2x1(:,551),heltab2x2(:,:,551))
  call Hcheck_last_UV_W(ntryL,l_switch,G1H2(560),23,ex4(:),8,G2tensor(580),m3h2x1(:,552),heltab2x2(:,:,552))
  call Hcheck_last_TV_S(ntryL,l_switch,G1H2(561),27,ex3(:),4,G2tensor(581),m3h2x1(:,553),heltab2x2(:,:,553))
  call Hcheck_last_TV_S(ntryL,l_switch,G1H2(562),0,ex3(:),4,G2tensor(582),m3h2x1(:,554),heltab2x2(:,:,554))
  call Hcheck_last_TV_S(ntryL,l_switch,G1H2(565),27,ex3(:),4,G2tensor(583),m3h2x1(:,555),heltab2x2(:,:,555))
  call Hcheck_last_UV_W(ntryL,l_switch,G1H2(566),27,ex3(:),4,G2tensor(584),m3h2x1(:,556),heltab2x2(:,:,556))
  call Hcheck_last_UV_W(ntryL,l_switch,G1H2(567),0,ex3(:),4,G2tensor(585),m3h2x1(:,557),heltab2x2(:,:,557))
  call Hcheck_last_UV_W(ntryL,l_switch,G1H2(570),27,ex3(:),4,G2tensor(586),m3h2x1(:,558),heltab2x2(:,:,558))
  call Hcheck_last_SV_T(ntryL,l_switch,G1H2(571),23,ex4(:),8,G2tensor(587),m3h2x1(:,559),heltab2x2(:,:,559))
  call Hcheck_last_SV_T(ntryL,l_switch,G1H2(572),0,ex4(:),8,G2tensor(588),m3h2x1(:,560),heltab2x2(:,:,560))
  call Hcheck_last_SV_T(ntryL,l_switch,G1H2(575),23,ex4(:),8,G2tensor(589),m3h2x1(:,561),heltab2x2(:,:,561))
  call Hcheck_last_UW_V(ntryL,l_switch,G1H2(576),23,ex4(:),8,G2tensor(590),m3h2x1(:,562),heltab2x2(:,:,562))
  call Hcheck_last_UW_V(ntryL,l_switch,G1H2(577),0,ex4(:),8,G2tensor(591),m3h2x1(:,563),heltab2x2(:,:,563))
  call Hcheck_last_UW_V(ntryL,l_switch,G1H2(580),23,ex4(:),8,G2tensor(592),m3h2x1(:,564),heltab2x2(:,:,564))
  call ol_merge_tensors(G2tensor(353),[G2tensor(347),G2tensor(182),G2tensor(181),G2tensor(5),G2tensor(2),G1tensor(2)])
  call ol_merge_tensors(G2tensor(548),[G2tensor(545),G2tensor(119),G2tensor(6),G2tensor(3),G1tensor(174),G1tensor(6)])
  call ol_merge_tensors(G2tensor(368),[G2tensor(365),G2tensor(184),G2tensor(183),G2tensor(11),G2tensor(8),G1tensor(8)])
  call ol_merge_tensors(G2tensor(518),[G2tensor(515),G2tensor(125),G2tensor(12),G2tensor(9),G1tensor(180),G1tensor(12)])
  call ol_merge_tensors(G2tensor(185),[G2tensor(14),G1tensor(14)])
  call ol_merge_tensors(G2tensor(551),[G2tensor(15),G1tensor(18)])
  call ol_merge_tensors(G2tensor(203),[G2tensor(191),G2tensor(18),G1tensor(20)])
  call ol_merge_tensors(G2tensor(563),[G2tensor(554),G2tensor(19),G1tensor(24)])
  call ol_merge_tensors(G2tensor(206),[G2tensor(194),G2tensor(22),G1tensor(26)])
  call ol_merge_tensors(G2tensor(566),[G2tensor(557),G2tensor(23),G1tensor(30)])
  call ol_merge_tensors(G2tensor(200),[G2tensor(26),G1tensor(32)])
  call ol_merge_tensors(G2tensor(560),[G2tensor(27),G1tensor(36)])
  call ol_merge_tensors(G2tensor(209),[G2tensor(30),G1tensor(38)])
  call ol_merge_tensors(G2tensor(63),[G2tensor(31),G1tensor(90),G1tensor(42)])
  call ol_merge_tensors(G2tensor(215),[G2tensor(34),G1tensor(44)])
  call ol_merge_tensors(G2tensor(67),[G2tensor(35),G1tensor(96),G1tensor(48)])
  call ol_merge_tensors(G2tensor(221),[G2tensor(38),G1tensor(50)])
  call ol_merge_tensors(G2tensor(71),[G2tensor(39),G1tensor(102),G1tensor(54)])
  call ol_merge_tensors(G2tensor(227),[G2tensor(42),G1tensor(56)])
  call ol_merge_tensors(G2tensor(75),[G2tensor(43),G1tensor(108),G1tensor(60)])
  call ol_merge_tensors(G2tensor(233),[G2tensor(46),G1tensor(62)])
  call ol_merge_tensors(G2tensor(527),[G2tensor(47),G1tensor(66)])
  call ol_merge_tensors(G2tensor(251),[G2tensor(239),G2tensor(50),G1tensor(68)])
  call ol_merge_tensors(G2tensor(539),[G2tensor(530),G2tensor(51),G1tensor(72)])
  call ol_merge_tensors(G2tensor(254),[G2tensor(242),G2tensor(54),G1tensor(74)])
  call ol_merge_tensors(G2tensor(542),[G2tensor(533),G2tensor(55),G1tensor(78)])
  call ol_merge_tensors(G2tensor(248),[G2tensor(58),G1tensor(80)])
  call ol_merge_tensors(G2tensor(536),[G2tensor(59),G1tensor(84)])
  call ol_merge_tensors(G2tensor(257),[G2tensor(62),G1tensor(86),G1tensor(63)])
  call ol_merge_tensors(G2tensor(263),[G2tensor(66),G1tensor(92),G1tensor(69)])
  call ol_merge_tensors(G2tensor(269),[G2tensor(70),G1tensor(98),G1tensor(75)])
  call ol_merge_tensors(G2tensor(275),[G2tensor(74),G1tensor(104),G1tensor(81)])
  call ol_merge_tensors(G2tensor(281),[G2tensor(78),G1tensor(110)])
  call ol_merge_tensors(G2tensor(95),[G2tensor(79),G1tensor(138),G1tensor(114)])
  call ol_merge_tensors(G2tensor(287),[G2tensor(82),G1tensor(116)])
  call ol_merge_tensors(G2tensor(99),[G2tensor(83),G1tensor(144),G1tensor(120)])
  call ol_merge_tensors(G2tensor(293),[G2tensor(86),G1tensor(122)])
  call ol_merge_tensors(G2tensor(103),[G2tensor(87),G1tensor(150),G1tensor(126)])
  call ol_merge_tensors(G2tensor(299),[G2tensor(90),G1tensor(128)])
  call ol_merge_tensors(G2tensor(107),[G2tensor(91),G1tensor(156),G1tensor(132)])
  call ol_merge_tensors(G2tensor(305),[G2tensor(94),G1tensor(134),G1tensor(15)])
  call ol_merge_tensors(G2tensor(311),[G2tensor(98),G1tensor(140),G1tensor(21)])
  call ol_merge_tensors(G2tensor(317),[G2tensor(102),G1tensor(146),G1tensor(27)])
  call ol_merge_tensors(G2tensor(323),[G2tensor(106),G1tensor(152),G1tensor(33)])
  call ol_merge_tensors(G2tensor(332),[G2tensor(329),G2tensor(110),G1tensor(158)])
  call ol_merge_tensors(G2tensor(524),[G2tensor(521),G2tensor(111),G1tensor(162)])
  call ol_merge_tensors(G2tensor(338),[G2tensor(335),G2tensor(114),G1tensor(164)])
  call ol_merge_tensors(G2tensor(512),[G2tensor(509),G2tensor(115),G1tensor(168)])
  call ol_merge_tensors(G2tensor(344),[G2tensor(341),G2tensor(118),G1tensor(170)])
  call ol_merge_tensors(G2tensor(362),[G2tensor(359),G2tensor(124),G1tensor(176)])
  call ol_merge_tensors(G2tensor(377),[G2tensor(371),G1tensor(3)])
  call ol_merge_tensors(G2tensor(380),[G2tensor(374),G1tensor(4)])
  call ol_merge_tensors(G2tensor(356),[G2tensor(350),G1tensor(11),G1tensor(5)])
  call ol_merge_tensors(G2tensor(389),[G2tensor(383),G1tensor(9)])
  call ol_merge_tensors(G2tensor(392),[G2tensor(386),G1tensor(10)])
  call ol_merge_tensors(G2tensor(395),[G1tensor(16)])
  call ol_merge_tensors(G2tensor(236),[G2tensor(188),G1tensor(83),G1tensor(71),G1tensor(65),G1tensor(35),G1tensor(23) &
    ,G1tensor(17)])
  call ol_merge_tensors(G2tensor(398),[G1tensor(22)])
  call ol_merge_tensors(G2tensor(401),[G1tensor(172),G1tensor(28)])
  call ol_merge_tensors(G2tensor(245),[G2tensor(197),G1tensor(77),G1tensor(29)])
  call ol_merge_tensors(G2tensor(404),[G1tensor(34)])
  call ol_merge_tensors(G2tensor(407),[G1tensor(39)])
  call ol_merge_tensors(G2tensor(458),[G2tensor(410),G1tensor(130),G1tensor(118),G1tensor(112),G1tensor(58),G1tensor(46) &
    ,G1tensor(40)])
  call ol_merge_tensors(G2tensor(212),[G1tensor(41)])
  call ol_merge_tensors(G2tensor(413),[G1tensor(45)])
  call ol_merge_tensors(G2tensor(218),[G1tensor(47)])
  call ol_merge_tensors(G2tensor(416),[G1tensor(51)])
  call ol_merge_tensors(G2tensor(467),[G2tensor(419),G1tensor(124),G1tensor(52)])
  call ol_merge_tensors(G2tensor(224),[G1tensor(161),G1tensor(53)])
  call ol_merge_tensors(G2tensor(422),[G1tensor(57)])
  call ol_merge_tensors(G2tensor(230),[G1tensor(59)])
  call ol_merge_tensors(G2tensor(425),[G1tensor(64)])
  call ol_merge_tensors(G2tensor(428),[G1tensor(70)])
  call ol_merge_tensors(G2tensor(431),[G1tensor(160),G1tensor(76)])
  call ol_merge_tensors(G2tensor(434),[G1tensor(82)])
  call ol_merge_tensors(G2tensor(437),[G1tensor(87)])
  call ol_merge_tensors(G2tensor(476),[G2tensor(440),G1tensor(154),G1tensor(142),G1tensor(136),G1tensor(106),G1tensor(94) &
    ,G1tensor(88)])
  call ol_merge_tensors(G2tensor(260),[G1tensor(89)])
  call ol_merge_tensors(G2tensor(443),[G1tensor(93)])
  call ol_merge_tensors(G2tensor(266),[G1tensor(95)])
  call ol_merge_tensors(G2tensor(446),[G1tensor(99)])
  call ol_merge_tensors(G2tensor(485),[G2tensor(449),G1tensor(148),G1tensor(100)])
  call ol_merge_tensors(G2tensor(272),[G1tensor(167),G1tensor(101)])
  call ol_merge_tensors(G2tensor(452),[G1tensor(105)])
  call ol_merge_tensors(G2tensor(278),[G1tensor(107)])
  call ol_merge_tensors(G2tensor(455),[G1tensor(111)])
  call ol_merge_tensors(G2tensor(284),[G1tensor(113)])
  call ol_merge_tensors(G2tensor(461),[G1tensor(117)])
  call ol_merge_tensors(G2tensor(290),[G1tensor(119)])
  call ol_merge_tensors(G2tensor(464),[G1tensor(123)])
  call ol_merge_tensors(G2tensor(296),[G1tensor(173),G1tensor(125)])
  call ol_merge_tensors(G2tensor(470),[G1tensor(129)])
  call ol_merge_tensors(G2tensor(302),[G1tensor(131)])
  call ol_merge_tensors(G2tensor(473),[G1tensor(135)])
  call ol_merge_tensors(G2tensor(308),[G1tensor(137)])
  call ol_merge_tensors(G2tensor(479),[G1tensor(141)])
  call ol_merge_tensors(G2tensor(314),[G1tensor(143)])
  call ol_merge_tensors(G2tensor(482),[G1tensor(147)])
  call ol_merge_tensors(G2tensor(320),[G1tensor(179),G1tensor(149)])
  call ol_merge_tensors(G2tensor(488),[G1tensor(153)])
  call ol_merge_tensors(G2tensor(326),[G1tensor(155)])
  call ol_merge_tensors(G2tensor(491),[G1tensor(159)])
  call ol_merge_tensors(G2tensor(494),[G1tensor(165)])
  call ol_merge_tensors(G2tensor(497),[G1tensor(166)])
  call ol_merge_tensors(G2tensor(500),[G1tensor(171)])
  call ol_merge_tensors(G2tensor(503),[G1tensor(177)])
  call ol_merge_tensors(G2tensor(506),[G1tensor(178)])
  call ol_merge_tensors(G2tensor(572),[G2tensor(569),G2tensor(174),G2tensor(173)])
  call ol_merge_tensors(G2tensor(578),[G2tensor(575),G2tensor(176),G2tensor(175)])
  call ol_merge_tensors(G2tensor(584),[G2tensor(581),G2tensor(178),G2tensor(177)])
  call ol_merge_tensors(G2tensor(590),[G2tensor(587),G2tensor(180),G2tensor(179)])
  call Hotf_4pt_reduction_last(G2tensor(353),RedSet_4(20),mass4set(:,12),  & 
G1tensor(1),G1tensor(7),G1tensor(13),G1tensor(19),G1tensor(25))
  call G_TensorShift(G1tensor(7),8)
  call Hotf_4pt_reduction_last(G2tensor(548),RedSet_4(7),mass4set(:,9),  & 
G1tensor(31),G1tensor(37),G1tensor(43),G1tensor(49),G1tensor(55))
  call G_TensorShift(G1tensor(37),10)
  call Hotf_4pt_reduction_last(G2tensor(368),RedSet_4(27),mass4set(:,12),  & 
G1tensor(61),G1tensor(67),G1tensor(73),G1tensor(79),G1tensor(85))
  call G_TensorShift(G1tensor(67),4)
  call Hotf_4pt_reduction_last(G2tensor(518),RedSet_4(8),mass4set(:,9),  & 
G1tensor(91),G1tensor(97),G1tensor(103),G1tensor(109),G1tensor(115))
  call G_TensorShift(G1tensor(97),6)
  call Hotf_4pt_reduction_last(G2tensor(185),RedSet_4(47),mass4set(:,1),  & 
G1tensor(121),G1tensor(127),G1tensor(133),G1tensor(139),G1tensor(145))
  call G_TensorShift(G1tensor(127),2)
  call Hotf_4pt_reduction_last(G2tensor(551),RedSet_4(1),mass4set(:,1),  & 
G1tensor(151),G1tensor(157),G1tensor(163),G1tensor(169),G1tensor(175))
  call G_TensorShift(G1tensor(157),10)
  call Hotf_4pt_reduction_last(G2tensor(203),RedSet_4(47),mass4set(:,2),  & 
G1tensor(2),G1tensor(174),G1tensor(6),G1tensor(8),G1tensor(180))
  call G_TensorShift(G1tensor(174),2)
  call Hotf_4pt_reduction_last(G2tensor(563),RedSet_4(1),mass4set(:,2),  & 
G1tensor(12),G1tensor(14),G1tensor(18),G1tensor(20),G1tensor(24))
  call G_TensorShift(G1tensor(14),10)
  call Hotf_4pt_reduction_last(G2tensor(206),RedSet_4(47),mass4set(:,3),  & 
G1tensor(26),G1tensor(30),G1tensor(32),G1tensor(36),G1tensor(38))
  call G_TensorShift(G1tensor(30),2)
  call Hotf_4pt_reduction_last(G2tensor(566),RedSet_4(1),mass4set(:,3),  & 
G1tensor(90),G1tensor(42),G1tensor(44),G1tensor(96),G1tensor(48))
  call G_TensorShift(G1tensor(42),10)
  call Hotf_4pt_reduction_last(G2tensor(200),RedSet_4(47),mass4set(:,4),  & 
G1tensor(50),G1tensor(102),G1tensor(54),G1tensor(56),G1tensor(108))
  call G_TensorShift(G1tensor(102),2)
  call Hotf_4pt_reduction_last(G2tensor(560),RedSet_4(1),mass4set(:,4),  & 
G1tensor(60),G1tensor(62),G1tensor(66),G1tensor(68),G1tensor(72))
  call G_TensorShift(G1tensor(62),10)
  call Hotf_4pt_reduction_last(G2tensor(209),RedSet_4(48),mass4set(:,5),  & 
G1tensor(74),G1tensor(78),G1tensor(80),G1tensor(84),G1tensor(86))
  call G_TensorShift(G1tensor(78),4)
  call Hotf_4pt_reduction_last(G2tensor(63),RedSet_4(2),mass4set(:,5),  & 
G1tensor(63),G1tensor(92),G1tensor(69),G1tensor(98),G1tensor(75))
  call G_TensorShift(G1tensor(92),12)
  call Hotf_4pt_reduction_last(G2tensor(215),RedSet_4(48),mass4set(:,6),  & 
G1tensor(104),G1tensor(81),G1tensor(110),G1tensor(138),G1tensor(114))
  call G_TensorShift(G1tensor(81),4)
  call Hotf_4pt_reduction_last(G2tensor(67),RedSet_4(2),mass4set(:,6),  & 
G1tensor(116),G1tensor(144),G1tensor(120),G1tensor(122),G1tensor(150))
  call G_TensorShift(G1tensor(144),12)
  call Hotf_4pt_reduction_last(G2tensor(221),RedSet_4(48),mass4set(:,7),  & 
G1tensor(126),G1tensor(128),G1tensor(156),G1tensor(132),G1tensor(134))
  call G_TensorShift(G1tensor(128),4)
  call Hotf_4pt_reduction_last(G2tensor(71),RedSet_4(2),mass4set(:,7),  & 
G1tensor(15),G1tensor(140),G1tensor(21),G1tensor(146),G1tensor(27))
  call G_TensorShift(G1tensor(140),12)
  call Hotf_4pt_reduction_last(G2tensor(227),RedSet_4(48),mass4set(:,8),  & 
G1tensor(152),G1tensor(33),G1tensor(158),G1tensor(162),G1tensor(164))
  call G_TensorShift(G1tensor(33),4)
  call Hotf_4pt_reduction_last(G2tensor(75),RedSet_4(2),mass4set(:,8),  & 
G1tensor(168),G1tensor(170),G1tensor(176),G1tensor(3),G1tensor(4))
  call G_TensorShift(G1tensor(170),12)
  call Hotf_4pt_reduction_last(G2tensor(233),RedSet_4(49),mass4set(:,1),  & 
G1tensor(11),G1tensor(5),G1tensor(9),G1tensor(10),G1tensor(16))
  call G_TensorShift(G1tensor(5),1)
  call Hotf_4pt_reduction_last(G2tensor(527),RedSet_4(3),mass4set(:,1),  & 
G1tensor(83),G1tensor(71),G1tensor(65),G1tensor(35),G1tensor(23))
  call G_TensorShift(G1tensor(71),9)
  call Hotf_4pt_reduction_last(G2tensor(251),RedSet_4(49),mass4set(:,2),  & 
G1tensor(17),G1tensor(22),G1tensor(172),G1tensor(28),G1tensor(77))
  call G_TensorShift(G1tensor(22),1)
  call Hotf_4pt_reduction_last(G2tensor(539),RedSet_4(3),mass4set(:,2),  & 
G1tensor(29),G1tensor(34),G1tensor(39),G1tensor(130),G1tensor(118))
  call G_TensorShift(G1tensor(34),9)
  call Hotf_4pt_reduction_last(G2tensor(254),RedSet_4(49),mass4set(:,3),  & 
G1tensor(112),G1tensor(58),G1tensor(46),G1tensor(40),G1tensor(41))
  call G_TensorShift(G1tensor(58),1)
  call Hotf_4pt_reduction_last(G2tensor(542),RedSet_4(3),mass4set(:,3),  & 
G1tensor(45),G1tensor(47),G1tensor(51),G1tensor(124),G1tensor(52))
  call G_TensorShift(G1tensor(47),9)
  call Hotf_4pt_reduction_last(G2tensor(248),RedSet_4(49),mass4set(:,4),  & 
G1tensor(161),G1tensor(53),G1tensor(57),G1tensor(59),G1tensor(64))
  call G_TensorShift(G1tensor(53),1)
  call Hotf_4pt_reduction_last(G2tensor(536),RedSet_4(3),mass4set(:,4),  & 
G1tensor(70),G1tensor(160),G1tensor(76),G1tensor(82),G1tensor(87))
  call G_TensorShift(G1tensor(160),9)
  call Hotf_4pt_reduction_last(G2tensor(257),RedSet_4(24),mass4set(:,5),  & 
G1tensor(154),G1tensor(142),G1tensor(136),G1tensor(106),G1tensor(94))
  call G_TensorShift(G1tensor(142),8)
  call Hotf_4pt_reduction_last(G2tensor(263),RedSet_4(24),mass4set(:,6),  & 
G1tensor(88),G1tensor(89),G1tensor(93),G1tensor(95),G1tensor(99))
  call G_TensorShift(G1tensor(89),8)
  call Hotf_4pt_reduction_last(G2tensor(269),RedSet_4(24),mass4set(:,7),  & 
G1tensor(148),G1tensor(100),G1tensor(167),G1tensor(101),G1tensor(105))
  call G_TensorShift(G1tensor(100),8)
  call Hotf_4pt_reduction_last(G2tensor(275),RedSet_4(24),mass4set(:,8),  & 
G1tensor(107),G1tensor(111),G1tensor(113),G1tensor(117),G1tensor(119))
  call G_TensorShift(G1tensor(111),8)
  call Hotf_4pt_reduction_last(G2tensor(281),RedSet_4(50),mass4set(:,5),  & 
G1tensor(123),G1tensor(173),G1tensor(125),G1tensor(129),G1tensor(131))
  call G_TensorShift(G1tensor(173),4)
  call Hotf_4pt_reduction_last(G2tensor(95),RedSet_4(4),mass4set(:,5),  & 
G1tensor(135),G1tensor(137),G1tensor(141),G1tensor(143),G1tensor(147))
  call G_TensorShift(G1tensor(137),12)
  call Hotf_4pt_reduction_last(G2tensor(287),RedSet_4(50),mass4set(:,6),  & 
G1tensor(179),G1tensor(149),G1tensor(153),G1tensor(155),G1tensor(159))
  call G_TensorShift(G1tensor(149),4)
  call Hotf_4pt_reduction_last(G2tensor(99),RedSet_4(4),mass4set(:,6),  & 
G1tensor(165),G1tensor(166),G1tensor(171),G1tensor(177),G1tensor(178))
  call G_TensorShift(G1tensor(166),12)
  call Hotf_4pt_reduction_last(G2tensor(293),RedSet_4(50),mass4set(:,7),  & 
G1tensor(181),G1tensor(182),G1tensor(183),G1tensor(184),G1tensor(185))
  call G_TensorShift(G1tensor(182),4)
  call Hotf_4pt_reduction_last(G2tensor(103),RedSet_4(4),mass4set(:,7),  & 
G1tensor(186),G1tensor(187),G1tensor(188),G1tensor(189),G1tensor(190))
  call G_TensorShift(G1tensor(187),12)
  call Hotf_4pt_reduction_last(G2tensor(299),RedSet_4(50),mass4set(:,8),  & 
G1tensor(191),G1tensor(192),G1tensor(193),G1tensor(194),G1tensor(195))
  call G_TensorShift(G1tensor(192),4)
  call Hotf_4pt_reduction_last(G2tensor(107),RedSet_4(4),mass4set(:,8),  & 
G1tensor(196),G1tensor(197),G1tensor(198),G1tensor(199),G1tensor(200))
  call G_TensorShift(G1tensor(197),12)
  call Hotf_4pt_reduction_last(G2tensor(305),RedSet_4(16),mass4set(:,5),  & 
G1tensor(201),G1tensor(202),G1tensor(203),G1tensor(204),G1tensor(205))
  call G_TensorShift(G1tensor(202),8)
  call Hotf_4pt_reduction_last(G2tensor(311),RedSet_4(16),mass4set(:,6),  & 
G1tensor(206),G1tensor(207),G1tensor(208),G1tensor(209),G1tensor(210))
  call G_TensorShift(G1tensor(207),8)
  call Hotf_4pt_reduction_last(G2tensor(317),RedSet_4(16),mass4set(:,7),  & 
G1tensor(211),G1tensor(212),G1tensor(213),G1tensor(214),G1tensor(215))
  call G_TensorShift(G1tensor(212),8)
  call Hotf_4pt_reduction_last(G2tensor(323),RedSet_4(16),mass4set(:,8),  & 
G1tensor(216),G1tensor(217),G1tensor(218),G1tensor(219),G1tensor(220))
  call G_TensorShift(G1tensor(217),8)
  call Hotf_4pt_reduction_last(G2tensor(332),RedSet_4(51),mass4set(:,9),  & 
G1tensor(221),G1tensor(222),G1tensor(223),G1tensor(224),G1tensor(225))
  call G_TensorShift(G1tensor(222),1)
  call Hotf_4pt_reduction_last(G2tensor(524),RedSet_4(5),mass4set(:,9),  & 
G1tensor(226),G1tensor(227),G1tensor(228),G1tensor(229),G1tensor(230))
  call G_TensorShift(G1tensor(227),9)
  call Hotf_4pt_reduction_last(G2tensor(338),RedSet_4(52),mass4set(:,9),  & 
G1tensor(231),G1tensor(232),G1tensor(233),G1tensor(234),G1tensor(235))
  call G_TensorShift(G1tensor(232),1)
  call Hotf_4pt_reduction_last(G2tensor(512),RedSet_4(6),mass4set(:,9),  & 
G1tensor(236),G1tensor(237),G1tensor(238),G1tensor(239),G1tensor(240))
  call G_TensorShift(G1tensor(237),5)
  call Hotf_4pt_reduction_last(G2tensor(344),RedSet_4(53),mass4set(:,9),  & 
G1tensor(241),G1tensor(242),G1tensor(243),G1tensor(244),G1tensor(245))
  call G_TensorShift(G1tensor(242),2)
  call Hotf_4pt_reduction_last(G2tensor(362),RedSet_4(54),mass4set(:,9),  & 
G1tensor(246),G1tensor(247),G1tensor(248),G1tensor(249),G1tensor(250))
  call G_TensorShift(G1tensor(247),2)
  call Hotf_4pt_reduction_last(G2tensor(377),RedSet_4(9),mass4set(:,13),  & 
G1tensor(251),G1tensor(252),G1tensor(253),G1tensor(254),G1tensor(255))
  call G_TensorShift(G1tensor(252),2)
  call Hotf_4pt_reduction_last(G2tensor(380),RedSet_4(10),mass4set(:,9),  & 
G1tensor(256),G1tensor(257),G1tensor(258),G1tensor(259),G1tensor(260))
  call G_TensorShift(G1tensor(257),2)
  call Hotf_4pt_reduction_last(G2tensor(356),RedSet_4(11),mass4set(:,9),  & 
G1tensor(261),G1tensor(262),G1tensor(263),G1tensor(264),G1tensor(265))
  call G_TensorShift(G1tensor(262),2)
  call Hotf_4pt_reduction_last(G2tensor(389),RedSet_4(13),mass4set(:,13),  & 
G1tensor(266),G1tensor(267),G1tensor(268),G1tensor(269),G1tensor(270))
  call G_TensorShift(G1tensor(267),2)
  call Hotf_4pt_reduction_last(G2tensor(392),RedSet_4(14),mass4set(:,9),  & 
G1tensor(271),G1tensor(272),G1tensor(273),G1tensor(274),G1tensor(275))
  call G_TensorShift(G1tensor(272),2)
  call Hotf_4pt_reduction_last(G2tensor(395),RedSet_4(17),mass4set(:,5),  & 
G1tensor(276),G1tensor(277),G1tensor(278),G1tensor(279),G1tensor(280))
  call G_TensorShift(G1tensor(277),8)
  call Hotf_4pt_reduction_last(G2tensor(236),RedSet_4(18),mass4set(:,10),  & 
G1tensor(281),G1tensor(282),G1tensor(283),G1tensor(284),G1tensor(285))
  call G_TensorShift(G1tensor(282),8)
  call Hotf_4pt_reduction_last(G2tensor(398),RedSet_4(17),mass4set(:,6),  & 
G1tensor(286),G1tensor(287),G1tensor(288),G1tensor(289),G1tensor(290))
  call G_TensorShift(G1tensor(287),8)
  call Hotf_4pt_reduction_last(G2tensor(401),RedSet_4(17),mass4set(:,7),  & 
G1tensor(291),G1tensor(292),G1tensor(293),G1tensor(294),G1tensor(295))
  call G_TensorShift(G1tensor(292),8)
  call Hotf_4pt_reduction_last(G2tensor(245),RedSet_4(18),mass4set(:,11),  & 
G1tensor(296),G1tensor(297),G1tensor(298),G1tensor(299),G1tensor(300))
  call G_TensorShift(G1tensor(297),8)
  call Hotf_4pt_reduction_last(G2tensor(404),RedSet_4(17),mass4set(:,8),  & 
G1tensor(301),G1tensor(302),G1tensor(303),G1tensor(304),G1tensor(305))
  call G_TensorShift(G1tensor(302),8)
  call Hotf_4pt_reduction_last(G2tensor(407),RedSet_4(20),mass4set(:,14),  & 
G1tensor(306),G1tensor(307),G1tensor(308),G1tensor(309),G1tensor(310))
  call G_TensorShift(G1tensor(307),8)
  call Hotf_4pt_reduction_last(G2tensor(458),RedSet_4(21),mass4set(:,10),  & 
G1tensor(311),G1tensor(312),G1tensor(313),G1tensor(314),G1tensor(315))
  call G_TensorShift(G1tensor(312),8)
  call Hotf_4pt_reduction_last(G2tensor(212),RedSet_4(22),mass4set(:,5),  & 
G1tensor(316),G1tensor(317),G1tensor(318),G1tensor(319),G1tensor(320))
  call G_TensorShift(G1tensor(317),8)
  call Hotf_4pt_reduction_last(G2tensor(413),RedSet_4(20),mass4set(:,15),  & 
G1tensor(321),G1tensor(322),G1tensor(323),G1tensor(324),G1tensor(325))
  call G_TensorShift(G1tensor(322),8)
  call Hotf_4pt_reduction_last(G2tensor(218),RedSet_4(22),mass4set(:,6),  & 
G1tensor(326),G1tensor(327),G1tensor(328),G1tensor(329),G1tensor(330))
  call G_TensorShift(G1tensor(327),8)
  call Hotf_4pt_reduction_last(G2tensor(416),RedSet_4(20),mass4set(:,16),  & 
G1tensor(331),G1tensor(332),G1tensor(333),G1tensor(334),G1tensor(335))
  call G_TensorShift(G1tensor(332),8)
  call Hotf_4pt_reduction_last(G2tensor(467),RedSet_4(21),mass4set(:,11),  & 
G1tensor(336),G1tensor(337),G1tensor(338),G1tensor(339),G1tensor(340))
  call G_TensorShift(G1tensor(337),8)
  call Hotf_4pt_reduction_last(G2tensor(224),RedSet_4(22),mass4set(:,7),  & 
G1tensor(341),G1tensor(342),G1tensor(343),G1tensor(344),G1tensor(345))
  call G_TensorShift(G1tensor(342),8)
  call Hotf_4pt_reduction_last(G2tensor(422),RedSet_4(20),mass4set(:,17),  & 
G1tensor(346),G1tensor(347),G1tensor(348),G1tensor(349),G1tensor(350))
  call G_TensorShift(G1tensor(347),8)
  call Hotf_4pt_reduction_last(G2tensor(230),RedSet_4(22),mass4set(:,8),  & 
G1tensor(351),G1tensor(352),G1tensor(353),G1tensor(354),G1tensor(355))
  call G_TensorShift(G1tensor(352),8)
  call Hotf_4pt_reduction_last(G2tensor(425),RedSet_4(25),mass4set(:,5),  & 
G1tensor(356),G1tensor(357),G1tensor(358),G1tensor(359),G1tensor(360))
  call G_TensorShift(G1tensor(357),8)
  call Hotf_4pt_reduction_last(G2tensor(428),RedSet_4(25),mass4set(:,6),  & 
G1tensor(361),G1tensor(362),G1tensor(363),G1tensor(364),G1tensor(365))
  call G_TensorShift(G1tensor(362),8)
  call Hotf_4pt_reduction_last(G2tensor(431),RedSet_4(25),mass4set(:,7),  & 
G1tensor(366),G1tensor(367),G1tensor(368),G1tensor(369),G1tensor(370))
  call G_TensorShift(G1tensor(367),8)
  call Hotf_4pt_reduction_last(G2tensor(434),RedSet_4(25),mass4set(:,8),  & 
G1tensor(371),G1tensor(372),G1tensor(373),G1tensor(374),G1tensor(375))
  call G_TensorShift(G1tensor(372),8)
  call Hotf_4pt_reduction_last(G2tensor(437),RedSet_4(27),mass4set(:,14),  & 
G1tensor(376),G1tensor(377),G1tensor(378),G1tensor(379),G1tensor(380))
  call G_TensorShift(G1tensor(377),4)
  call Hotf_4pt_reduction_last(G2tensor(476),RedSet_4(28),mass4set(:,10),  & 
G1tensor(381),G1tensor(382),G1tensor(383),G1tensor(384),G1tensor(385))
  call G_TensorShift(G1tensor(382),4)
  call Hotf_4pt_reduction_last(G2tensor(260),RedSet_4(29),mass4set(:,5),  & 
G1tensor(386),G1tensor(387),G1tensor(388),G1tensor(389),G1tensor(390))
  call G_TensorShift(G1tensor(387),4)
  call Hotf_4pt_reduction_last(G2tensor(443),RedSet_4(27),mass4set(:,15),  & 
G1tensor(391),G1tensor(392),G1tensor(393),G1tensor(394),G1tensor(395))
  call G_TensorShift(G1tensor(392),4)
  call Hotf_4pt_reduction_last(G2tensor(266),RedSet_4(29),mass4set(:,6),  & 
G1tensor(396),G1tensor(397),G1tensor(398),G1tensor(399),G1tensor(400))
  call G_TensorShift(G1tensor(397),4)
  call Hotf_4pt_reduction_last(G2tensor(446),RedSet_4(27),mass4set(:,16),  & 
G1tensor(401),G1tensor(402),G1tensor(403),G1tensor(404),G1tensor(405))
  call G_TensorShift(G1tensor(402),4)
  call Hotf_4pt_reduction_last(G2tensor(485),RedSet_4(28),mass4set(:,11),  & 
G1tensor(406),G1tensor(407),G1tensor(408),G1tensor(409),G1tensor(410))
  call G_TensorShift(G1tensor(407),4)
  call Hotf_4pt_reduction_last(G2tensor(272),RedSet_4(29),mass4set(:,7),  & 
G1tensor(411),G1tensor(412),G1tensor(413),G1tensor(414),G1tensor(415))
  call G_TensorShift(G1tensor(412),4)
  call Hotf_4pt_reduction_last(G2tensor(452),RedSet_4(27),mass4set(:,17),  & 
G1tensor(416),G1tensor(417),G1tensor(418),G1tensor(419),G1tensor(420))
  call G_TensorShift(G1tensor(417),4)
  call Hotf_4pt_reduction_last(G2tensor(278),RedSet_4(29),mass4set(:,8),  & 
G1tensor(421),G1tensor(422),G1tensor(423),G1tensor(424),G1tensor(425))
  call G_TensorShift(G1tensor(422),4)
  call Hotf_4pt_reduction_last(G2tensor(455),RedSet_4(31),mass4set(:,14),  & 
G1tensor(426),G1tensor(427),G1tensor(428),G1tensor(429),G1tensor(430))
  call G_TensorShift(G1tensor(427),8)
  call Hotf_4pt_reduction_last(G2tensor(284),RedSet_4(32),mass4set(:,5),  & 
G1tensor(431),G1tensor(432),G1tensor(433),G1tensor(434),G1tensor(435))
  call G_TensorShift(G1tensor(432),8)
  call Hotf_4pt_reduction_last(G2tensor(461),RedSet_4(31),mass4set(:,15),  & 
G1tensor(436),G1tensor(437),G1tensor(438),G1tensor(439),G1tensor(440))
  call G_TensorShift(G1tensor(437),8)
  call Hotf_4pt_reduction_last(G2tensor(290),RedSet_4(32),mass4set(:,6),  & 
G1tensor(441),G1tensor(442),G1tensor(443),G1tensor(444),G1tensor(445))
  call G_TensorShift(G1tensor(442),8)
  call Hotf_4pt_reduction_last(G2tensor(464),RedSet_4(31),mass4set(:,16),  & 
G1tensor(446),G1tensor(447),G1tensor(448),G1tensor(449),G1tensor(450))
  call G_TensorShift(G1tensor(447),8)
  call Hotf_4pt_reduction_last(G2tensor(296),RedSet_4(32),mass4set(:,7),  & 
G1tensor(451),G1tensor(452),G1tensor(453),G1tensor(454),G1tensor(455))
  call G_TensorShift(G1tensor(452),8)
  call Hotf_4pt_reduction_last(G2tensor(470),RedSet_4(31),mass4set(:,17),  & 
G1tensor(456),G1tensor(457),G1tensor(458),G1tensor(459),G1tensor(460))
  call G_TensorShift(G1tensor(457),8)
  call Hotf_4pt_reduction_last(G2tensor(302),RedSet_4(32),mass4set(:,8),  & 
G1tensor(461),G1tensor(462),G1tensor(463),G1tensor(464),G1tensor(465))
  call G_TensorShift(G1tensor(462),8)
  call Hotf_4pt_reduction_last(G2tensor(473),RedSet_4(34),mass4set(:,14),  & 
G1tensor(466),G1tensor(467),G1tensor(468),G1tensor(469),G1tensor(470))
  call G_TensorShift(G1tensor(467),4)
  call Hotf_4pt_reduction_last(G2tensor(308),RedSet_4(35),mass4set(:,5),  & 
G1tensor(471),G1tensor(472),G1tensor(473),G1tensor(474),G1tensor(475))
  call G_TensorShift(G1tensor(472),4)
  call Hotf_4pt_reduction_last(G2tensor(479),RedSet_4(34),mass4set(:,15),  & 
G1tensor(476),G1tensor(477),G1tensor(478),G1tensor(479),G1tensor(480))
  call G_TensorShift(G1tensor(477),4)
  call Hotf_4pt_reduction_last(G2tensor(314),RedSet_4(35),mass4set(:,6),  & 
G1tensor(481),G1tensor(482),G1tensor(483),G1tensor(484),G1tensor(485))
  call G_TensorShift(G1tensor(482),4)
  call Hotf_4pt_reduction_last(G2tensor(482),RedSet_4(34),mass4set(:,16),  & 
G1tensor(486),G1tensor(487),G1tensor(488),G1tensor(489),G1tensor(490))
  call G_TensorShift(G1tensor(487),4)
  call Hotf_4pt_reduction_last(G2tensor(320),RedSet_4(35),mass4set(:,7),  & 
G1tensor(491),G1tensor(492),G1tensor(493),G1tensor(494),G1tensor(495))
  call G_TensorShift(G1tensor(492),4)
  call Hotf_4pt_reduction_last(G2tensor(488),RedSet_4(34),mass4set(:,17),  & 
G1tensor(496),G1tensor(497),G1tensor(498),G1tensor(499),G1tensor(500))
  call G_TensorShift(G1tensor(497),4)
  call Hotf_4pt_reduction_last(G2tensor(326),RedSet_4(35),mass4set(:,8),  & 
G1tensor(501),G1tensor(502),G1tensor(503),G1tensor(504),G1tensor(505))
  call G_TensorShift(G1tensor(502),4)
  call Hotf_4pt_reduction_last(G2tensor(491),RedSet_4(37),mass4set(:,18),  & 
G1tensor(506),G1tensor(507),G1tensor(508),G1tensor(509),G1tensor(510))
  call G_TensorShift(G1tensor(507),8)
  call Hotf_4pt_reduction_last(G2tensor(494),RedSet_4(39),mass4set(:,18),  & 
G1tensor(511),G1tensor(512),G1tensor(513),G1tensor(514),G1tensor(515))
  call G_TensorShift(G1tensor(512),4)
  call Hotf_4pt_reduction_last(G2tensor(497),RedSet_4(40),mass4set(:,7),  & 
G1tensor(516),G1tensor(517),G1tensor(518),G1tensor(519),G1tensor(520))
  call G_TensorShift(G1tensor(517),4)
  call Hotf_4pt_reduction_last(G2tensor(500),RedSet_4(42),mass4set(:,18),  & 
G1tensor(521),G1tensor(522),G1tensor(523),G1tensor(524),G1tensor(525))
  call G_TensorShift(G1tensor(522),8)
  call Hotf_4pt_reduction_last(G2tensor(503),RedSet_4(44),mass4set(:,18),  & 
G1tensor(526),G1tensor(527),G1tensor(528),G1tensor(529),G1tensor(530))
  call G_TensorShift(G1tensor(527),4)
  call Hotf_4pt_reduction_last(G2tensor(506),RedSet_4(45),mass4set(:,7),  & 
G1tensor(531),G1tensor(532),G1tensor(533),G1tensor(534),G1tensor(535))
  call G_TensorShift(G1tensor(532),4)
  call Hotf_4pt_reduction_last(G2tensor(572),RedSet_4(42),mass4set(:,19),  & 
G1tensor(536),G1tensor(537),G1tensor(538),G1tensor(539),G1tensor(540))
  call G_TensorShift(G1tensor(537),8)
  call Hotf_4pt_reduction_last(G2tensor(578),RedSet_4(31),mass4set(:,12),  & 
G1tensor(541),G1tensor(542),G1tensor(543),G1tensor(544),G1tensor(545))
  call G_TensorShift(G1tensor(542),8)
  call Hotf_4pt_reduction_last(G2tensor(584),RedSet_4(34),mass4set(:,12),  & 
G1tensor(546),G1tensor(547),G1tensor(548),G1tensor(549),G1tensor(550))
  call G_TensorShift(G1tensor(547),4)
  call Hotf_4pt_reduction_last(G2tensor(590),RedSet_4(37),mass4set(:,19),  & 
G1tensor(551),G1tensor(552),G1tensor(553),G1tensor(554),G1tensor(555))
  call G_TensorShift(G1tensor(552),8)
  call Hotf_4pt_reduction_last(G1tensor(1),RedSet_4(20),mass4set(:,12),  & 
G0tensor(1),G0tensor(2),G0tensor(3),G0tensor(4),G0tensor(5))
  call Hotf_4pt_reduction_last(G1tensor(31),RedSet_4(7),mass4set(:,9),  & 
G0tensor(6),G0tensor(7),G0tensor(8),G0tensor(9),G0tensor(10))
  call Hotf_4pt_reduction_last(G1tensor(61),RedSet_4(27),mass4set(:,12),  & 
G0tensor(11),G0tensor(12),G0tensor(13),G0tensor(14),G0tensor(15))
  call Hotf_4pt_reduction_last(G1tensor(91),RedSet_4(8),mass4set(:,9),  & 
G0tensor(16),G0tensor(17),G0tensor(18),G0tensor(19),G0tensor(20))
  call Hotf_4pt_reduction_last(G1tensor(121),RedSet_4(47),mass4set(:,1),  & 
G0tensor(21),G0tensor(22),G0tensor(23),G0tensor(24),G0tensor(25))
  call Hotf_4pt_reduction_last(G1tensor(151),RedSet_4(1),mass4set(:,1),  & 
G0tensor(26),G0tensor(27),G0tensor(28),G0tensor(29),G0tensor(30))
  call Hotf_4pt_reduction_last(G1tensor(2),RedSet_4(47),mass4set(:,2),  & 
G0tensor(31),G0tensor(32),G0tensor(33),G0tensor(34),G0tensor(35))
  call Hotf_4pt_reduction_last(G1tensor(12),RedSet_4(1),mass4set(:,2),  & 
G0tensor(36),G0tensor(37),G0tensor(38),G0tensor(39),G0tensor(40))
  call Hotf_4pt_reduction_last(G1tensor(26),RedSet_4(47),mass4set(:,3),  & 
G0tensor(41),G0tensor(42),G0tensor(43),G0tensor(44),G0tensor(45))
  call Hotf_4pt_reduction_last(G1tensor(90),RedSet_4(1),mass4set(:,3),  & 
G0tensor(46),G0tensor(47),G0tensor(48),G0tensor(49),G0tensor(50))
  call Hotf_4pt_reduction_last(G1tensor(50),RedSet_4(47),mass4set(:,4),  & 
G0tensor(51),G0tensor(52),G0tensor(53),G0tensor(54),G0tensor(55))
  call Hotf_4pt_reduction_last(G1tensor(60),RedSet_4(1),mass4set(:,4),  & 
G0tensor(56),G0tensor(57),G0tensor(58),G0tensor(59),G0tensor(60))
  call Hotf_4pt_reduction_last(G1tensor(74),RedSet_4(48),mass4set(:,5),  & 
G0tensor(61),G0tensor(62),G0tensor(63),G0tensor(64),G0tensor(65))
  call Hotf_4pt_reduction_last(G1tensor(63),RedSet_4(2),mass4set(:,5),  & 
G0tensor(66),G0tensor(67),G0tensor(68),G0tensor(69),G0tensor(70))
  call Hotf_4pt_reduction_last(G1tensor(104),RedSet_4(48),mass4set(:,6),  & 
G0tensor(71),G0tensor(72),G0tensor(73),G0tensor(74),G0tensor(75))
  call Hotf_4pt_reduction_last(G1tensor(116),RedSet_4(2),mass4set(:,6),  & 
G0tensor(76),G0tensor(77),G0tensor(78),G0tensor(79),G0tensor(80))
  call Hotf_4pt_reduction_last(G1tensor(126),RedSet_4(48),mass4set(:,7),  & 
G0tensor(81),G0tensor(82),G0tensor(83),G0tensor(84),G0tensor(85))
  call Hotf_4pt_reduction_last(G1tensor(15),RedSet_4(2),mass4set(:,7),  & 
G0tensor(86),G0tensor(87),G0tensor(88),G0tensor(89),G0tensor(90))
  call Hotf_4pt_reduction_last(G1tensor(152),RedSet_4(48),mass4set(:,8),  & 
G0tensor(91),G0tensor(92),G0tensor(93),G0tensor(94),G0tensor(95))
  call Hotf_4pt_reduction_last(G1tensor(168),RedSet_4(2),mass4set(:,8),  & 
G0tensor(96),G0tensor(97),G0tensor(98),G0tensor(99),G0tensor(100))
  call Hotf_4pt_reduction_last(G1tensor(11),RedSet_4(49),mass4set(:,1),  & 
G0tensor(101),G0tensor(102),G0tensor(103),G0tensor(104),G0tensor(105))
  call Hotf_4pt_reduction_last(G1tensor(83),RedSet_4(3),mass4set(:,1),  & 
G0tensor(106),G0tensor(107),G0tensor(108),G0tensor(109),G0tensor(110))
  call Hotf_4pt_reduction_last(G1tensor(17),RedSet_4(49),mass4set(:,2),  & 
G0tensor(111),G0tensor(112),G0tensor(113),G0tensor(114),G0tensor(115))
  call Hotf_4pt_reduction_last(G1tensor(29),RedSet_4(3),mass4set(:,2),  & 
G0tensor(116),G0tensor(117),G0tensor(118),G0tensor(119),G0tensor(120))
  call Hotf_4pt_reduction_last(G1tensor(112),RedSet_4(49),mass4set(:,3),  & 
G0tensor(121),G0tensor(122),G0tensor(123),G0tensor(124),G0tensor(125))
  call Hotf_4pt_reduction_last(G1tensor(45),RedSet_4(3),mass4set(:,3),  & 
G0tensor(126),G0tensor(127),G0tensor(128),G0tensor(129),G0tensor(130))
  call Hotf_4pt_reduction_last(G1tensor(161),RedSet_4(49),mass4set(:,4),  & 
G0tensor(131),G0tensor(132),G0tensor(133),G0tensor(134),G0tensor(135))
  call Hotf_4pt_reduction_last(G1tensor(70),RedSet_4(3),mass4set(:,4),  & 
G0tensor(136),G0tensor(137),G0tensor(138),G0tensor(139),G0tensor(140))
  call Hotf_4pt_reduction_last(G1tensor(154),RedSet_4(24),mass4set(:,5),  & 
G0tensor(141),G0tensor(142),G0tensor(143),G0tensor(144),G0tensor(145))
  call Hotf_4pt_reduction_last(G1tensor(88),RedSet_4(24),mass4set(:,6),  & 
G0tensor(146),G0tensor(147),G0tensor(148),G0tensor(149),G0tensor(150))
  call Hotf_4pt_reduction_last(G1tensor(148),RedSet_4(24),mass4set(:,7),  & 
G0tensor(151),G0tensor(152),G0tensor(153),G0tensor(154),G0tensor(155))
  call Hotf_4pt_reduction_last(G1tensor(107),RedSet_4(24),mass4set(:,8),  & 
G0tensor(156),G0tensor(157),G0tensor(158),G0tensor(159),G0tensor(160))
  call Hotf_4pt_reduction_last(G1tensor(123),RedSet_4(50),mass4set(:,5),  & 
G0tensor(161),G0tensor(162),G0tensor(163),G0tensor(164),G0tensor(165))
  call Hotf_4pt_reduction_last(G1tensor(135),RedSet_4(4),mass4set(:,5),  & 
G0tensor(166),G0tensor(167),G0tensor(168),G0tensor(169),G0tensor(170))
  call Hotf_4pt_reduction_last(G1tensor(179),RedSet_4(50),mass4set(:,6),  & 
G0tensor(171),G0tensor(172),G0tensor(173),G0tensor(174),G0tensor(175))
  call Hotf_4pt_reduction_last(G1tensor(165),RedSet_4(4),mass4set(:,6),  & 
G0tensor(176),G0tensor(177),G0tensor(178),G0tensor(179),G0tensor(180))
  call Hotf_4pt_reduction_last(G1tensor(181),RedSet_4(50),mass4set(:,7),  & 
G0tensor(181),G0tensor(182),G0tensor(183),G0tensor(184),G0tensor(185))
  call Hotf_4pt_reduction_last(G1tensor(186),RedSet_4(4),mass4set(:,7),  & 
G0tensor(186),G0tensor(187),G0tensor(188),G0tensor(189),G0tensor(190))
  call Hotf_4pt_reduction_last(G1tensor(191),RedSet_4(50),mass4set(:,8),  & 
G0tensor(191),G0tensor(192),G0tensor(193),G0tensor(194),G0tensor(195))
  call Hotf_4pt_reduction_last(G1tensor(196),RedSet_4(4),mass4set(:,8),  & 
G0tensor(196),G0tensor(197),G0tensor(198),G0tensor(199),G0tensor(200))
  call Hotf_4pt_reduction_last(G1tensor(201),RedSet_4(16),mass4set(:,5),  & 
G0tensor(201),G0tensor(202),G0tensor(203),G0tensor(204),G0tensor(205))
  call Hotf_4pt_reduction_last(G1tensor(206),RedSet_4(16),mass4set(:,6),  & 
G0tensor(206),G0tensor(207),G0tensor(208),G0tensor(209),G0tensor(210))
  call Hotf_4pt_reduction_last(G1tensor(211),RedSet_4(16),mass4set(:,7),  & 
G0tensor(211),G0tensor(212),G0tensor(213),G0tensor(214),G0tensor(215))
  call Hotf_4pt_reduction_last(G1tensor(216),RedSet_4(16),mass4set(:,8),  & 
G0tensor(216),G0tensor(217),G0tensor(218),G0tensor(219),G0tensor(220))
  call Hotf_4pt_reduction_last(G1tensor(221),RedSet_4(51),mass4set(:,9),  & 
G0tensor(221),G0tensor(222),G0tensor(223),G0tensor(224),G0tensor(225))
  call Hotf_4pt_reduction_last(G1tensor(226),RedSet_4(5),mass4set(:,9),  & 
G0tensor(226),G0tensor(227),G0tensor(228),G0tensor(229),G0tensor(230))
  call Hotf_4pt_reduction_last(G1tensor(231),RedSet_4(52),mass4set(:,9),  & 
G0tensor(231),G0tensor(232),G0tensor(233),G0tensor(234),G0tensor(235))
  call Hotf_4pt_reduction_last(G1tensor(236),RedSet_4(6),mass4set(:,9),  & 
G0tensor(236),G0tensor(237),G0tensor(238),G0tensor(239),G0tensor(240))
  call Hotf_4pt_reduction_last(G1tensor(241),RedSet_4(53),mass4set(:,9),  & 
G0tensor(241),G0tensor(242),G0tensor(243),G0tensor(244),G0tensor(245))
  call Hotf_4pt_reduction_last(G1tensor(246),RedSet_4(54),mass4set(:,9),  & 
G0tensor(246),G0tensor(247),G0tensor(248),G0tensor(249),G0tensor(250))
  call Hotf_4pt_reduction_last(G1tensor(251),RedSet_4(9),mass4set(:,13),  & 
G0tensor(251),G0tensor(252),G0tensor(253),G0tensor(254),G0tensor(255))
  call Hotf_4pt_reduction_last(G1tensor(256),RedSet_4(10),mass4set(:,9),  & 
G0tensor(256),G0tensor(257),G0tensor(258),G0tensor(259),G0tensor(260))
  call Hotf_4pt_reduction_last(G1tensor(261),RedSet_4(11),mass4set(:,9),  & 
G0tensor(261),G0tensor(262),G0tensor(263),G0tensor(264),G0tensor(265))
  call Hotf_4pt_reduction_last(G1tensor(266),RedSet_4(13),mass4set(:,13),  & 
G0tensor(266),G0tensor(267),G0tensor(268),G0tensor(269),G0tensor(270))
  call Hotf_4pt_reduction_last(G1tensor(271),RedSet_4(14),mass4set(:,9),  & 
G0tensor(271),G0tensor(272),G0tensor(273),G0tensor(274),G0tensor(275))
  call Hotf_4pt_reduction_last(G1tensor(276),RedSet_4(17),mass4set(:,5),  & 
G0tensor(276),G0tensor(277),G0tensor(278),G0tensor(279),G0tensor(280))
  call Hotf_4pt_reduction_last(G1tensor(281),RedSet_4(18),mass4set(:,10),  & 
G0tensor(281),G0tensor(282),G0tensor(283),G0tensor(284),G0tensor(285))
  call Hotf_4pt_reduction_last(G1tensor(286),RedSet_4(17),mass4set(:,6),  & 
G0tensor(286),G0tensor(287),G0tensor(288),G0tensor(289),G0tensor(290))
  call Hotf_4pt_reduction_last(G1tensor(291),RedSet_4(17),mass4set(:,7),  & 
G0tensor(291),G0tensor(292),G0tensor(293),G0tensor(294),G0tensor(295))
  call Hotf_4pt_reduction_last(G1tensor(296),RedSet_4(18),mass4set(:,11),  & 
G0tensor(296),G0tensor(297),G0tensor(298),G0tensor(299),G0tensor(300))
  call Hotf_4pt_reduction_last(G1tensor(301),RedSet_4(17),mass4set(:,8),  & 
G0tensor(301),G0tensor(302),G0tensor(303),G0tensor(304),G0tensor(305))
  call Hotf_4pt_reduction_last(G1tensor(306),RedSet_4(20),mass4set(:,14),  & 
G0tensor(306),G0tensor(307),G0tensor(308),G0tensor(309),G0tensor(310))
  call Hotf_4pt_reduction_last(G1tensor(311),RedSet_4(21),mass4set(:,10),  & 
G0tensor(311),G0tensor(312),G0tensor(313),G0tensor(314),G0tensor(315))
  call Hotf_4pt_reduction_last(G1tensor(316),RedSet_4(22),mass4set(:,5),  & 
G0tensor(316),G0tensor(317),G0tensor(318),G0tensor(319),G0tensor(320))
  call Hotf_4pt_reduction_last(G1tensor(321),RedSet_4(20),mass4set(:,15),  & 
G0tensor(321),G0tensor(322),G0tensor(323),G0tensor(324),G0tensor(325))
  call Hotf_4pt_reduction_last(G1tensor(326),RedSet_4(22),mass4set(:,6),  & 
G0tensor(326),G0tensor(327),G0tensor(328),G0tensor(329),G0tensor(330))
  call Hotf_4pt_reduction_last(G1tensor(331),RedSet_4(20),mass4set(:,16),  & 
G0tensor(331),G0tensor(332),G0tensor(333),G0tensor(334),G0tensor(335))
  call Hotf_4pt_reduction_last(G1tensor(336),RedSet_4(21),mass4set(:,11),  & 
G0tensor(336),G0tensor(337),G0tensor(338),G0tensor(339),G0tensor(340))
  call Hotf_4pt_reduction_last(G1tensor(341),RedSet_4(22),mass4set(:,7),  & 
G0tensor(341),G0tensor(342),G0tensor(343),G0tensor(344),G0tensor(345))
  call Hotf_4pt_reduction_last(G1tensor(346),RedSet_4(20),mass4set(:,17),  & 
G0tensor(346),G0tensor(347),G0tensor(348),G0tensor(349),G0tensor(350))
  call Hotf_4pt_reduction_last(G1tensor(351),RedSet_4(22),mass4set(:,8),  & 
G0tensor(351),G0tensor(352),G0tensor(353),G0tensor(354),G0tensor(355))
  call Hotf_4pt_reduction_last(G1tensor(356),RedSet_4(25),mass4set(:,5),  & 
G0tensor(356),G0tensor(357),G0tensor(358),G0tensor(359),G0tensor(360))
  call Hotf_4pt_reduction_last(G1tensor(361),RedSet_4(25),mass4set(:,6),  & 
G0tensor(361),G0tensor(362),G0tensor(363),G0tensor(364),G0tensor(365))
  call Hotf_4pt_reduction_last(G1tensor(366),RedSet_4(25),mass4set(:,7),  & 
G0tensor(366),G0tensor(367),G0tensor(368),G0tensor(369),G0tensor(370))
  call Hotf_4pt_reduction_last(G1tensor(371),RedSet_4(25),mass4set(:,8),  & 
G0tensor(371),G0tensor(372),G0tensor(373),G0tensor(374),G0tensor(375))
  call Hotf_4pt_reduction_last(G1tensor(376),RedSet_4(27),mass4set(:,14),  & 
G0tensor(376),G0tensor(377),G0tensor(378),G0tensor(379),G0tensor(380))
  call Hotf_4pt_reduction_last(G1tensor(381),RedSet_4(28),mass4set(:,10),  & 
G0tensor(381),G0tensor(382),G0tensor(383),G0tensor(384),G0tensor(385))
  call Hotf_4pt_reduction_last(G1tensor(386),RedSet_4(29),mass4set(:,5),  & 
G0tensor(386),G0tensor(387),G0tensor(388),G0tensor(389),G0tensor(390))
  call Hotf_4pt_reduction_last(G1tensor(391),RedSet_4(27),mass4set(:,15),  & 
G0tensor(391),G0tensor(392),G0tensor(393),G0tensor(394),G0tensor(395))
  call Hotf_4pt_reduction_last(G1tensor(396),RedSet_4(29),mass4set(:,6),  & 
G0tensor(396),G0tensor(397),G0tensor(398),G0tensor(399),G0tensor(400))
  call Hotf_4pt_reduction_last(G1tensor(401),RedSet_4(27),mass4set(:,16),  & 
G0tensor(401),G0tensor(402),G0tensor(403),G0tensor(404),G0tensor(405))
  call Hotf_4pt_reduction_last(G1tensor(406),RedSet_4(28),mass4set(:,11),  & 
G0tensor(406),G0tensor(407),G0tensor(408),G0tensor(409),G0tensor(410))
  call Hotf_4pt_reduction_last(G1tensor(411),RedSet_4(29),mass4set(:,7),  & 
G0tensor(411),G0tensor(412),G0tensor(413),G0tensor(414),G0tensor(415))
  call Hotf_4pt_reduction_last(G1tensor(416),RedSet_4(27),mass4set(:,17),  & 
G0tensor(416),G0tensor(417),G0tensor(418),G0tensor(419),G0tensor(420))
  call Hotf_4pt_reduction_last(G1tensor(421),RedSet_4(29),mass4set(:,8),  & 
G0tensor(421),G0tensor(422),G0tensor(423),G0tensor(424),G0tensor(425))
  call Hotf_4pt_reduction_last(G1tensor(426),RedSet_4(31),mass4set(:,14),  & 
G0tensor(426),G0tensor(427),G0tensor(428),G0tensor(429),G0tensor(430))
  call Hotf_4pt_reduction_last(G1tensor(431),RedSet_4(32),mass4set(:,5),  & 
G0tensor(431),G0tensor(432),G0tensor(433),G0tensor(434),G0tensor(435))
  call Hotf_4pt_reduction_last(G1tensor(436),RedSet_4(31),mass4set(:,15),  & 
G0tensor(436),G0tensor(437),G0tensor(438),G0tensor(439),G0tensor(440))
  call Hotf_4pt_reduction_last(G1tensor(441),RedSet_4(32),mass4set(:,6),  & 
G0tensor(441),G0tensor(442),G0tensor(443),G0tensor(444),G0tensor(445))
  call Hotf_4pt_reduction_last(G1tensor(446),RedSet_4(31),mass4set(:,16),  & 
G0tensor(446),G0tensor(447),G0tensor(448),G0tensor(449),G0tensor(450))
  call Hotf_4pt_reduction_last(G1tensor(451),RedSet_4(32),mass4set(:,7),  & 
G0tensor(451),G0tensor(452),G0tensor(453),G0tensor(454),G0tensor(455))
  call Hotf_4pt_reduction_last(G1tensor(456),RedSet_4(31),mass4set(:,17),  & 
G0tensor(456),G0tensor(457),G0tensor(458),G0tensor(459),G0tensor(460))
  call Hotf_4pt_reduction_last(G1tensor(461),RedSet_4(32),mass4set(:,8),  & 
G0tensor(461),G0tensor(462),G0tensor(463),G0tensor(464),G0tensor(465))
  call Hotf_4pt_reduction_last(G1tensor(466),RedSet_4(34),mass4set(:,14),  & 
G0tensor(466),G0tensor(467),G0tensor(468),G0tensor(469),G0tensor(470))
  call Hotf_4pt_reduction_last(G1tensor(471),RedSet_4(35),mass4set(:,5),  & 
G0tensor(471),G0tensor(472),G0tensor(473),G0tensor(474),G0tensor(475))
  call Hotf_4pt_reduction_last(G1tensor(476),RedSet_4(34),mass4set(:,15),  & 
G0tensor(476),G0tensor(477),G0tensor(478),G0tensor(479),G0tensor(480))
  call Hotf_4pt_reduction_last(G1tensor(481),RedSet_4(35),mass4set(:,6),  & 
G0tensor(481),G0tensor(482),G0tensor(483),G0tensor(484),G0tensor(485))
  call Hotf_4pt_reduction_last(G1tensor(486),RedSet_4(34),mass4set(:,16),  & 
G0tensor(486),G0tensor(487),G0tensor(488),G0tensor(489),G0tensor(490))
  call Hotf_4pt_reduction_last(G1tensor(491),RedSet_4(35),mass4set(:,7),  & 
G0tensor(491),G0tensor(492),G0tensor(493),G0tensor(494),G0tensor(495))
  call Hotf_4pt_reduction_last(G1tensor(496),RedSet_4(34),mass4set(:,17),  & 
G0tensor(496),G0tensor(497),G0tensor(498),G0tensor(499),G0tensor(500))
  call Hotf_4pt_reduction_last(G1tensor(501),RedSet_4(35),mass4set(:,8),  & 
G0tensor(501),G0tensor(502),G0tensor(503),G0tensor(504),G0tensor(505))
  call Hotf_4pt_reduction_last(G1tensor(506),RedSet_4(37),mass4set(:,18),  & 
G0tensor(506),G0tensor(507),G0tensor(508),G0tensor(509),G0tensor(510))
  call Hotf_4pt_reduction_last(G1tensor(511),RedSet_4(39),mass4set(:,18),  & 
G0tensor(511),G0tensor(512),G0tensor(513),G0tensor(514),G0tensor(515))
  call Hotf_4pt_reduction_last(G1tensor(516),RedSet_4(40),mass4set(:,7),  & 
G0tensor(516),G0tensor(517),G0tensor(518),G0tensor(519),G0tensor(520))
  call Hotf_4pt_reduction_last(G1tensor(521),RedSet_4(42),mass4set(:,18),  & 
G0tensor(521),G0tensor(522),G0tensor(523),G0tensor(524),G0tensor(525))
  call Hotf_4pt_reduction_last(G1tensor(526),RedSet_4(44),mass4set(:,18),  & 
G0tensor(526),G0tensor(527),G0tensor(528),G0tensor(529),G0tensor(530))
  call Hotf_4pt_reduction_last(G1tensor(531),RedSet_4(45),mass4set(:,7),  & 
G0tensor(531),G0tensor(532),G0tensor(533),G0tensor(534),G0tensor(535))
  call Hotf_4pt_reduction_last(G1tensor(536),RedSet_4(42),mass4set(:,19),  & 
G0tensor(536),G0tensor(537),G0tensor(538),G0tensor(539),G0tensor(540))
  call Hotf_4pt_reduction_last(G1tensor(541),RedSet_4(31),mass4set(:,12),  & 
G0tensor(541),G0tensor(542),G0tensor(543),G0tensor(544),G0tensor(545))
  call Hotf_4pt_reduction_last(G1tensor(546),RedSet_4(34),mass4set(:,12),  & 
G0tensor(546),G0tensor(547),G0tensor(548),G0tensor(549),G0tensor(550))
  call Hotf_4pt_reduction_last(G1tensor(551),RedSet_4(37),mass4set(:,19),  & 
G0tensor(551),G0tensor(552),G0tensor(553),G0tensor(554),G0tensor(555))
  call ol_merge_tensors(T0sum(1),[G0tensor(1)])
  call ol_merge_tensors(T0sum(2),[G0tensor(6)])
  call ol_merge_tensors(T0sum(3),[G0tensor(11)])
  call ol_merge_tensors(T0sum(4),[G0tensor(16)])
  call ol_merge_tensors(T0sum(5),[G0tensor(21)])
  call ol_merge_tensors(T0sum(6),[G0tensor(26)])
  call ol_merge_tensors(T0sum(7),[G0tensor(31)])
  call ol_merge_tensors(T0sum(8),[G0tensor(36)])
  call ol_merge_tensors(T0sum(9),[G0tensor(41)])
  call ol_merge_tensors(T0sum(10),[G0tensor(46)])
  call ol_merge_tensors(T0sum(11),[G0tensor(51)])
  call ol_merge_tensors(T0sum(12),[G0tensor(56)])
  call ol_merge_tensors(T0sum(13),[G0tensor(61)])
  call ol_merge_tensors(T0sum(14),[G0tensor(66)])
  call ol_merge_tensors(T0sum(15),[G0tensor(71)])
  call ol_merge_tensors(T0sum(16),[G0tensor(76)])
  call ol_merge_tensors(T0sum(17),[G0tensor(81)])
  call ol_merge_tensors(T0sum(18),[G0tensor(86)])
  call ol_merge_tensors(T0sum(19),[G0tensor(91)])
  call ol_merge_tensors(T0sum(20),[G0tensor(96)])
  call ol_merge_tensors(T0sum(21),[G0tensor(101)])
  call ol_merge_tensors(T0sum(22),[G0tensor(106)])
  call ol_merge_tensors(T0sum(23),[G0tensor(111)])
  call ol_merge_tensors(T0sum(24),[G0tensor(116)])
  call ol_merge_tensors(T0sum(25),[G0tensor(121)])
  call ol_merge_tensors(T0sum(26),[G0tensor(126)])
  call ol_merge_tensors(T0sum(27),[G0tensor(131)])
  call ol_merge_tensors(T0sum(28),[G0tensor(136)])
  call ol_merge_tensors(T0sum(29),[G0tensor(141)])
  call ol_merge_tensors(T0sum(30),[G0tensor(146)])
  call ol_merge_tensors(T0sum(31),[G0tensor(151)])
  call ol_merge_tensors(T0sum(32),[G0tensor(156)])
  call ol_merge_tensors(T0sum(33),[G0tensor(161)])
  call ol_merge_tensors(T0sum(34),[G0tensor(166)])
  call ol_merge_tensors(T0sum(35),[G0tensor(171)])
  call ol_merge_tensors(T0sum(36),[G0tensor(176)])
  call ol_merge_tensors(T0sum(37),[G0tensor(181)])
  call ol_merge_tensors(T0sum(38),[G0tensor(186)])
  call ol_merge_tensors(T0sum(39),[G0tensor(191)])
  call ol_merge_tensors(T0sum(40),[G0tensor(196)])
  call ol_merge_tensors(T0sum(41),[G0tensor(201)])
  call ol_merge_tensors(T0sum(42),[G0tensor(206)])
  call ol_merge_tensors(T0sum(43),[G0tensor(211)])
  call ol_merge_tensors(T0sum(44),[G0tensor(216)])
  call ol_merge_tensors(T0sum(45),[G0tensor(221)])
  call ol_merge_tensors(T0sum(46),[G0tensor(226)])
  call ol_merge_tensors(T0sum(47),[G0tensor(231)])
  call ol_merge_tensors(T0sum(48),[G0tensor(236)])
  call ol_merge_tensors(T0sum(49),[G0tensor(241)])
  call ol_merge_tensors(T0sum(50),[G0tensor(246)])
  call ol_merge_tensors(T0sum(51),[G0tensor(251)])
  call ol_merge_tensors(T0sum(52),[G0tensor(256)])
  call ol_merge_tensors(T0sum(53),[G0tensor(261)])
  call ol_merge_tensors(T0sum(54),[G0tensor(266)])
  call ol_merge_tensors(T0sum(55),[G0tensor(271)])
  call ol_merge_tensors(T0sum(56),[G0tensor(276)])
  call ol_merge_tensors(T0sum(57),[G0tensor(281)])
  call ol_merge_tensors(T0sum(58),[G0tensor(286)])
  call ol_merge_tensors(T0sum(59),[G0tensor(291)])
  call ol_merge_tensors(T0sum(60),[G0tensor(296)])
  call ol_merge_tensors(T0sum(61),[G0tensor(301)])
  call ol_merge_tensors(T0sum(62),[G0tensor(306)])
  call ol_merge_tensors(T0sum(63),[G0tensor(311)])
  call ol_merge_tensors(T0sum(64),[G0tensor(316)])
  call ol_merge_tensors(T0sum(65),[G0tensor(321)])
  call ol_merge_tensors(T0sum(66),[G0tensor(326)])
  call ol_merge_tensors(T0sum(67),[G0tensor(331)])
  call ol_merge_tensors(T0sum(68),[G0tensor(336)])
  call ol_merge_tensors(T0sum(69),[G0tensor(341)])
  call ol_merge_tensors(T0sum(70),[G0tensor(346)])
  call ol_merge_tensors(T0sum(71),[G0tensor(351)])
  call ol_merge_tensors(T0sum(72),[G0tensor(356)])
  call ol_merge_tensors(T0sum(73),[G0tensor(361)])
  call ol_merge_tensors(T0sum(74),[G0tensor(366)])
  call ol_merge_tensors(T0sum(75),[G0tensor(371)])
  call ol_merge_tensors(T0sum(76),[G0tensor(376)])
  call ol_merge_tensors(T0sum(77),[G0tensor(381)])
  call ol_merge_tensors(T0sum(78),[G0tensor(386)])
  call ol_merge_tensors(T0sum(79),[G0tensor(391)])
  call ol_merge_tensors(T0sum(80),[G0tensor(396)])
  call ol_merge_tensors(T0sum(81),[G0tensor(401)])
  call ol_merge_tensors(T0sum(82),[G0tensor(406)])
  call ol_merge_tensors(T0sum(83),[G0tensor(411)])
  call ol_merge_tensors(T0sum(84),[G0tensor(416)])
  call ol_merge_tensors(T0sum(85),[G0tensor(421)])
  call ol_merge_tensors(T0sum(86),[G0tensor(426)])
  call ol_merge_tensors(T0sum(87),[G0tensor(431)])
  call ol_merge_tensors(T0sum(88),[G0tensor(436)])
  call ol_merge_tensors(T0sum(89),[G0tensor(441)])
  call ol_merge_tensors(T0sum(90),[G0tensor(446)])
  call ol_merge_tensors(T0sum(91),[G0tensor(451)])
  call ol_merge_tensors(T0sum(92),[G0tensor(456)])
  call ol_merge_tensors(T0sum(93),[G0tensor(461)])
  call ol_merge_tensors(T0sum(94),[G0tensor(466)])
  call ol_merge_tensors(T0sum(95),[G0tensor(471)])
  call ol_merge_tensors(T0sum(96),[G0tensor(476)])
  call ol_merge_tensors(T0sum(97),[G0tensor(481)])
  call ol_merge_tensors(T0sum(98),[G0tensor(486)])
  call ol_merge_tensors(T0sum(99),[G0tensor(491)])
  call ol_merge_tensors(T0sum(100),[G0tensor(496)])
  call ol_merge_tensors(T0sum(101),[G0tensor(501)])
  call ol_merge_tensors(T0sum(102),[G0tensor(506)])
  call ol_merge_tensors(T0sum(103),[G0tensor(511)])
  call ol_merge_tensors(T0sum(104),[G0tensor(516)])
  call ol_merge_tensors(T0sum(105),[G0tensor(521)])
  call ol_merge_tensors(T0sum(106),[G0tensor(526)])
  call ol_merge_tensors(T0sum(107),[G0tensor(531)])
  call ol_merge_tensors(T0sum(108),[G0tensor(536)])
  call ol_merge_tensors(T0sum(109),[G0tensor(541)])
  call ol_merge_tensors(T0sum(110),[G0tensor(546)])
  call ol_merge_tensors(T0sum(111),[G0tensor(551)])
  Gcoeff(:)%j = (-(c(21)*M(1,:)%j)) * den(9)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(207),h0tab(:,207),[17,2,12],[nMB,nMW,nMW],4,1,wf4(:,12))
  call Hloop_SQ_A(ntryL,G0H32(1),wf4(:,12),G0H8(33),ngPbt,m3h4x8(:,73),heltab2x32(:,:,207))
  call Hloop_Q_A(ntryL,G0H8(33),17,nMB,G1H8(1),n2h8(65))
  Gcoeff(:)%j = (-(c(11)*M(1,:)%j)) * den(9)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(208),h0tab(:,208),[17,2,12],[nMB,nMW,nMW],4,1,wf4(:,12))
  call Hloop_WQ_A(ntryL,G0H32(1),wf4(:,12),G0H8(1),m3h4x8(:,74),heltab2x32(:,:,208))
  call Hloop_Q_A(ntryL,G0H8(1),17,nMB,G1H8(2),n2h8(66))
  Gcoeff(:)%j = (-(c(21)*M(1,:)%j)) * den(4)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(209),h0tab(:,209),[18,1,12],[nMB,nMW,nMW],4,1,wf4(:,6))
  call Hloop_SA_Q(ntryL,G0H32(1),wf4(:,6),G0H8(2),ngPtb,m3h4x8(:,75),heltab2x32(:,:,209))
  call Hloop_A_Q(ntryL,G0H8(2),18,nMB,G1H8(3),n2h8(67))
  Gcoeff(:)%j = (-(c(11)*M(1,:)%j)) * den(4)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(210),h0tab(:,210),[18,1,12],[nMB,nMW,nMW],4,1,wf4(:,6))
  call Hloop_WA_Q(ntryL,G0H32(1),wf4(:,6),G0H8(3),m3h4x8(:,76),heltab2x32(:,:,210))
  call Hloop_A_Q(ntryL,G0H8(3),18,nMB,G1H8(4),n2h8(68))
  Gcoeff(:)%j = (-(c(24)*M(1,:)%j)) * den(3)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(211),h0tab(:,211),[16,5,10],[nMT,nMH,nMT],3,2,wf4(:,3),wf4(:,4))
  call Hloop_AV_Q(ntryL,G0H32(1),ex5(:),G0H16(1),m3h2x16(:,135),heltab2x32(:,:,211))
  call Hloop_A_Q(ntryL,G0H16(1),16,nMT,G1H16(67),n2h16(135))
  Gcoeff(:)%j = (c(24)*M(1,:)%j) * den(3)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(212),h0tab(:,212),[16,5,10],[nMT,nMZ,nMT],3,2,wf4(:,3),wf4(:,4))
  call Hloop_AV_Q(ntryL,G0H32(1),ex5(:),G0H16(1),m3h2x16(:,136),heltab2x32(:,:,212))
  call Hloop_A_Q(ntryL,G0H16(1),16,nMT,G1H16(68),n2h16(136))
  Gcoeff(:)%j = (c(18)*M(1,:)%j) * den(3)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(213),h0tab(:,213),[16,5,10],[nMB,nMW,nMB],3,2,wf4(:,3),wf4(:,4))
  call Hloop_AV_Q(ntryL,G0H32(1),ex5(:),G0H16(1),m3h2x16(:,137),heltab2x32(:,:,213))
  call Hloop_A_Q(ntryL,G0H16(1),16,nMB,G1H16(1),n2h16(137))
  Gcoeff(:)%j = (c(1)*M(1,:)%j) * den(3)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(214),h0tab(:,214),[16,5,10],[nMT,0,nMT],3,2,wf4(:,3),wf4(:,4))
  call Hloop_AV_Q(ntryL,G0H32(1),ex5(:),G0H16(1),m3h2x16(:,138),heltab2x32(:,:,214))
  call Hloop_A_Q(ntryL,G0H16(1),16,nMT,G1H16(2),n2h16(138))
  Gcoeff(:)%j = (c(2)*M(1,:)%j) * den(3)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(215),h0tab(:,215),[16,5,10],[nMT,nMZ,nMT],3,2,wf4(:,3),wf4(:,4))
  call Hloop_AV_Q(ntryL,G0H32(1),ex5(:),G0H16(1),m3h2x16(:,139),heltab2x32(:,:,215))
  call Hloop_A_Q(ntryL,G0H16(1),16,nMT,G1H16(3),n2h16(139))
  Gcoeff(:)%j = (c(9)*M(1,:)%j) * den(3)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(216),h0tab(:,216),[16,5,10],[nMB,nMW,nMB],3,2,wf4(:,3),wf4(:,4))
  call Hloop_AV_Q(ntryL,G0H32(1),ex5(:),G0H16(1),m3h2x16(:,140),heltab2x32(:,:,216))
  call Hloop_A_Q(ntryL,G0H16(1),16,nMB,G1H16(4),n2h16(140))
  Gcoeff(:)%j = (-(c(24)*M(1,:)%j)) * den(5)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(217),h0tab(:,217),[18,5,8],[nMH,nMT,nMT],3,2,wf4(:,6),wf4(:,3))
  call Hloop_QA_S(ntryL,G0H32(1),wf4(:,6),G0H8(4),ngH,m3h4x8(:,77),heltab2x32(:,:,217))
  Gcoeff(:)%j = (c(24)*M(1,:)%j) * den(5)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(218),h0tab(:,218),[18,5,8],[nMZ,nMT,nMT],3,2,wf4(:,6),wf4(:,3))
  call Hloop_QA_S(ntryL,G0H32(1),wf4(:,6),G0H8(5),ngX,m3h4x8(:,78),heltab2x32(:,:,218))
  Gcoeff(:)%j = (-(c(16)*M(1,:)%j)) * den(5)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(219),h0tab(:,219),[18,5,8],[nMW,nMB,nMB],3,2,wf4(:,6),wf4(:,3))
  call Hloop_QA_S(ntryL,G0H32(1),wf4(:,6),G0H8(6),ngPtb,m3h4x8(:,79),heltab2x32(:,:,219))
  Gcoeff(:)%j = (c(19)*M(1,:)%j) * den(5)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(220),h0tab(:,220),[18,5,8],[nMB,nMW,nMW],3,2,wf4(:,6),wf4(:,3))
  call Hloop_SA_Q(ntryL,G0H32(1),wf4(:,6),G0H8(7),ngPtb,m3h4x8(:,80),heltab2x32(:,:,220))
  call Hloop_A_Q(ntryL,G0H8(7),18,nMB,G1H8(5),n2h8(69))
  Gcoeff(:)%j = (c(1)*M(1,:)%j) * den(5)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(221),h0tab(:,221),[18,5,8],[0,nMT,nMT],3,2,wf4(:,6),wf4(:,3))
  call Hloop_QA_V(ntryL,G0H32(1),wf4(:,6),G0H8(8),m3h4x8(:,81),heltab2x32(:,:,221))
  Gcoeff(:)%j = (c(2)*M(1,:)%j) * den(5)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(222),h0tab(:,222),[18,5,8],[nMZ,nMT,nMT],3,2,wf4(:,6),wf4(:,3))
  call Hloop_QA_Z(ntryL,G0H32(1),wf4(:,6),G0H8(9),ngZu,m3h4x8(:,82),heltab2x32(:,:,222))
  Gcoeff(:)%j = (-(c(7)*M(1,:)%j)) * den(5)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(223),h0tab(:,223),[18,5,8],[nMW,nMB,nMB],3,2,wf4(:,6),wf4(:,3))
  call Hloop_QA_W(ntryL,G0H32(1),wf4(:,6),G0H8(10),m3h4x8(:,83),heltab2x32(:,:,223))
  Gcoeff(:)%j = (-(c(10)*M(1,:)%j)) * den(5)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(224),h0tab(:,224),[18,5,8],[nMB,nMW,nMW],3,2,wf4(:,6),wf4(:,3))
  call Hloop_WA_Q(ntryL,G0H32(1),wf4(:,6),G0H8(11),m3h4x8(:,84),heltab2x32(:,:,224))
  call Hloop_A_Q(ntryL,G0H8(11),18,nMB,G1H8(6),n2h8(70))
  Gcoeff(:)%j = (c(10)*M(1,:)%j) * den(5)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(225),h0tab(:,225),[18,5,8],[nMB,nMW,nMW],3,2,wf4(:,6),wf4(:,3))
  call Hloop_SA_Q(ntryL,G0H32(1),wf4(:,6),G0H8(12),ngPtb,m3h4x8(:,85),heltab2x32(:,:,225))
  call Hloop_A_Q(ntryL,G0H8(12),18,nMB,G1H8(7),n2h8(71))
  Gcoeff(:)%j = (c(10)*M(1,:)%j) * den(5)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(226),h0tab(:,226),[18,5,8],[nMB,nMW,nMW],3,2,wf4(:,6),wf4(:,3))
  call Hloop_WA_Q(ntryL,G0H32(1),wf4(:,6),G0H8(13),m3h4x8(:,86),heltab2x32(:,:,226))
  call Hloop_A_Q(ntryL,G0H8(13),18,nMB,G1H8(8),n2h8(72))
  Gcoeff(:)%j = (-(c(24)*M(1,:)%j)) * den(25)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(227),h0tab(:,227),[16,2,13],[nMT,nMH,nMT],3,1,wf8(:,26))
  call Hloop_QV_A(ntryL,G0H32(1),ex5(:),G0H16(1),m3h2x16(:,141),heltab2x32(:,:,227))
  call Hloop_Q_A(ntryL,G0H16(1),16,nMT,G1H16(5),n2h16(141))
  Gcoeff(:)%j = (c(24)*M(1,:)%j) * den(25)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(228),h0tab(:,228),[16,2,13],[nMT,nMZ,nMT],3,1,wf8(:,26))
  call Hloop_QV_A(ntryL,G0H32(1),ex5(:),G0H16(1),m3h2x16(:,142),heltab2x32(:,:,228))
  call Hloop_Q_A(ntryL,G0H16(1),16,nMT,G1H16(6),n2h16(142))
  Gcoeff(:)%j = (c(18)*M(1,:)%j) * den(25)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(229),h0tab(:,229),[16,2,13],[nMB,nMW,nMB],3,1,wf8(:,26))
  call Hloop_QV_A(ntryL,G0H32(1),ex5(:),G0H16(1),m3h2x16(:,143),heltab2x32(:,:,229))
  call Hloop_Q_A(ntryL,G0H16(1),16,nMB,G1H16(7),n2h16(143))
  Gcoeff(:)%j = (c(1)*M(1,:)%j) * den(25)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(230),h0tab(:,230),[16,2,13],[nMT,0,nMT],3,1,wf8(:,26))
  call Hloop_QV_A(ntryL,G0H32(1),ex5(:),G0H16(1),m3h2x16(:,144),heltab2x32(:,:,230))
  call Hloop_Q_A(ntryL,G0H16(1),16,nMT,G1H16(8),n2h16(144))
  Gcoeff(:)%j = (c(2)*M(1,:)%j) * den(25)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(231),h0tab(:,231),[16,2,13],[nMT,nMZ,nMT],3,1,wf8(:,26))
  call Hloop_QV_A(ntryL,G0H32(1),ex5(:),G0H16(1),m3h2x16(:,145),heltab2x32(:,:,231))
  call Hloop_Q_A(ntryL,G0H16(1),16,nMT,G1H16(9),n2h16(145))
  Gcoeff(:)%j = (c(9)*M(1,:)%j) * den(25)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(232),h0tab(:,232),[16,2,13],[nMB,nMW,nMB],3,1,wf8(:,26))
  call Hloop_QV_A(ntryL,G0H32(1),ex5(:),G0H16(1),m3h2x16(:,146),heltab2x32(:,:,232))
  call Hloop_Q_A(ntryL,G0H16(1),16,nMB,G1H16(10),n2h16(146))
  Gcoeff(:)%j = (-(c(24)*M(1,:)%j)) * den(20)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(233),h0tab(:,233),[21,2,8],[nMH,nMT,nMT],3,1,wf8(:,23))
  call Hloop_AQ_S(ntryL,G0H32(1),wf8(:,23),G0H4(5),ngH,m3h8x4(:,1),heltab2x32(:,:,233))
  Gcoeff(:)%j = (c(24)*M(1,:)%j) * den(20)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(234),h0tab(:,234),[21,2,8],[nMZ,nMT,nMT],3,1,wf8(:,23))
  call Hloop_AQ_S(ntryL,G0H32(1),wf8(:,23),G0H4(3),ngX,m3h8x4(:,2),heltab2x32(:,:,234))
  Gcoeff(:)%j = (-(c(16)*M(1,:)%j)) * den(20)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(235),h0tab(:,235),[21,2,8],[nMW,nMB,nMB],3,1,wf8(:,23))
  call Hloop_AQ_S(ntryL,G0H32(1),wf8(:,23),G0H4(4),ngPbt,m3h8x4(:,3),heltab2x32(:,:,235))
  Gcoeff(:)%j = (c(19)*M(1,:)%j) * den(20)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(236),h0tab(:,236),[21,2,8],[nMB,nMW,nMW],3,1,wf8(:,23))
  call Hloop_SQ_A(ntryL,G0H32(1),wf8(:,23),G0H4(1),ngPbt,m3h8x4(:,4),heltab2x32(:,:,236))
  call Hloop_Q_A(ntryL,G0H4(1),21,nMB,G1H4(82),n2h4(97))
  Gcoeff(:)%j = (c(1)*M(1,:)%j) * den(20)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(237),h0tab(:,237),[21,2,8],[0,nMT,nMT],3,1,wf8(:,23))
  call Hloop_AQ_V(ntryL,G0H32(1),wf8(:,23),G0H4(2),m3h8x4(:,5),heltab2x32(:,:,237))
  Gcoeff(:)%j = (c(2)*M(1,:)%j) * den(20)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(238),h0tab(:,238),[21,2,8],[nMZ,nMT,nMT],3,1,wf8(:,23))
  call Hloop_AQ_Z(ntryL,G0H32(1),wf8(:,23),G0H4(1),ngZu,m3h8x4(:,6),heltab2x32(:,:,238))
  Gcoeff(:)%j = (-(c(7)*M(1,:)%j)) * den(20)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(239),h0tab(:,239),[21,2,8],[nMW,nMB,nMB],3,1,wf8(:,23))
  call Hloop_AQ_W(ntryL,G0H32(1),wf8(:,23),G0H4(6),m3h8x4(:,7),heltab2x32(:,:,239))
  Gcoeff(:)%j = (c(10)*M(1,:)%j) * den(20)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(240),h0tab(:,240),[21,2,8],[nMB,nMW,nMW],3,1,wf8(:,23))
  call Hloop_WQ_A(ntryL,G0H32(1),wf8(:,23),G0H4(7),m3h8x4(:,8),heltab2x32(:,:,240))
  call Hloop_Q_A(ntryL,G0H4(7),21,nMB,G1H4(88),n2h4(98))
  Gcoeff(:)%j = (-(c(10)*M(1,:)%j)) * den(20)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(241),h0tab(:,241),[21,2,8],[nMB,nMW,nMW],3,1,wf8(:,23))
  call Hloop_SQ_A(ntryL,G0H32(1),wf8(:,23),G0H4(7),ngPbt,m3h8x4(:,9),heltab2x32(:,:,241))
  call Hloop_Q_A(ntryL,G0H4(7),21,nMB,G1H4(178),n2h4(99))
  Gcoeff(:)%j = (c(10)*M(1,:)%j) * den(20)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(242),h0tab(:,242),[21,2,8],[nMB,nMW,nMW],3,1,wf8(:,23))
  call Hloop_WQ_A(ntryL,G0H32(1),wf8(:,23),G0H4(7),m3h8x4(:,10),heltab2x32(:,:,242))
  call Hloop_Q_A(ntryL,G0H4(7),21,nMB,G1H4(94),n2h4(100))
  Gcoeff(:)%j = (-(c(24)*M(1,:)%j)) * den(8)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(243),h0tab(:,243),[16,6,9],[nMT,nMH,nMT],3,2,wf4(:,10),wf4(:,9))
  call Hloop_QV_A(ntryL,G0H32(1),ex5(:),G0H16(1),m3h2x16(:,147),heltab2x32(:,:,243))
  call Hloop_Q_A(ntryL,G0H16(1),16,nMT,G1H16(11),n2h16(147))
  Gcoeff(:)%j = (c(24)*M(1,:)%j) * den(8)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(244),h0tab(:,244),[16,6,9],[nMT,nMZ,nMT],3,2,wf4(:,10),wf4(:,9))
  call Hloop_QV_A(ntryL,G0H32(1),ex5(:),G0H16(1),m3h2x16(:,148),heltab2x32(:,:,244))
  call Hloop_Q_A(ntryL,G0H16(1),16,nMT,G1H16(12),n2h16(148))
  Gcoeff(:)%j = (c(18)*M(1,:)%j) * den(8)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(245),h0tab(:,245),[16,6,9],[nMB,nMW,nMB],3,2,wf4(:,10),wf4(:,9))
  call Hloop_QV_A(ntryL,G0H32(1),ex5(:),G0H16(1),m3h2x16(:,149),heltab2x32(:,:,245))
  call Hloop_Q_A(ntryL,G0H16(1),16,nMB,G1H16(13),n2h16(149))
  Gcoeff(:)%j = (c(1)*M(1,:)%j) * den(8)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(246),h0tab(:,246),[16,6,9],[nMT,0,nMT],3,2,wf4(:,10),wf4(:,9))
  call Hloop_QV_A(ntryL,G0H32(1),ex5(:),G0H16(1),m3h2x16(:,150),heltab2x32(:,:,246))
  call Hloop_Q_A(ntryL,G0H16(1),16,nMT,G1H16(14),n2h16(150))
  Gcoeff(:)%j = (c(2)*M(1,:)%j) * den(8)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(247),h0tab(:,247),[16,6,9],[nMT,nMZ,nMT],3,2,wf4(:,10),wf4(:,9))
  call Hloop_QV_A(ntryL,G0H32(1),ex5(:),G0H16(1),m3h2x16(:,151),heltab2x32(:,:,247))
  call Hloop_Q_A(ntryL,G0H16(1),16,nMT,G1H16(15),n2h16(151))
  Gcoeff(:)%j = (c(9)*M(1,:)%j) * den(8)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(248),h0tab(:,248),[16,6,9],[nMB,nMW,nMB],3,2,wf4(:,10),wf4(:,9))
  call Hloop_QV_A(ntryL,G0H32(1),ex5(:),G0H16(1),m3h2x16(:,152),heltab2x32(:,:,248))
  call Hloop_Q_A(ntryL,G0H16(1),16,nMB,G1H16(16),n2h16(152))
  Gcoeff(:)%j = (-(c(24)*M(1,:)%j)) * den(10)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(249),h0tab(:,249),[17,6,8],[nMH,nMT,nMT],3,2,wf4(:,12),wf4(:,10))
  call Hloop_AQ_S(ntryL,G0H32(1),wf4(:,12),G0H8(14),ngH,m3h4x8(:,87),heltab2x32(:,:,249))
  Gcoeff(:)%j = (c(24)*M(1,:)%j) * den(10)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(250),h0tab(:,250),[17,6,8],[nMZ,nMT,nMT],3,2,wf4(:,12),wf4(:,10))
  call Hloop_AQ_S(ntryL,G0H32(1),wf4(:,12),G0H8(15),ngX,m3h4x8(:,88),heltab2x32(:,:,250))
  Gcoeff(:)%j = (-(c(16)*M(1,:)%j)) * den(10)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(251),h0tab(:,251),[17,6,8],[nMW,nMB,nMB],3,2,wf4(:,12),wf4(:,10))
  call Hloop_AQ_S(ntryL,G0H32(1),wf4(:,12),G0H8(16),ngPbt,m3h4x8(:,89),heltab2x32(:,:,251))
  Gcoeff(:)%j = (c(19)*M(1,:)%j) * den(10)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(252),h0tab(:,252),[17,6,8],[nMB,nMW,nMW],3,2,wf4(:,12),wf4(:,10))
  call Hloop_SQ_A(ntryL,G0H32(1),wf4(:,12),G0H8(17),ngPbt,m3h4x8(:,90),heltab2x32(:,:,252))
  call Hloop_Q_A(ntryL,G0H8(17),17,nMB,G1H8(9),n2h8(73))
  Gcoeff(:)%j = (c(1)*M(1,:)%j) * den(10)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(253),h0tab(:,253),[17,6,8],[0,nMT,nMT],3,2,wf4(:,12),wf4(:,10))
  call Hloop_AQ_V(ntryL,G0H32(1),wf4(:,12),G0H8(18),m3h4x8(:,91),heltab2x32(:,:,253))
  Gcoeff(:)%j = (c(2)*M(1,:)%j) * den(10)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(254),h0tab(:,254),[17,6,8],[nMZ,nMT,nMT],3,2,wf4(:,12),wf4(:,10))
  call Hloop_AQ_Z(ntryL,G0H32(1),wf4(:,12),G0H8(19),ngZu,m3h4x8(:,92),heltab2x32(:,:,254))
  Gcoeff(:)%j = (-(c(7)*M(1,:)%j)) * den(10)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(255),h0tab(:,255),[17,6,8],[nMW,nMB,nMB],3,2,wf4(:,12),wf4(:,10))
  call Hloop_AQ_W(ntryL,G0H32(1),wf4(:,12),G0H8(20),m3h4x8(:,93),heltab2x32(:,:,255))
  Gcoeff(:)%j = (-(c(10)*M(1,:)%j)) * den(10)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(256),h0tab(:,256),[17,6,8],[nMB,nMW,nMW],3,2,wf4(:,12),wf4(:,10))
  call Hloop_SQ_A(ntryL,G0H32(1),wf4(:,12),G0H8(21),ngPbt,m3h4x8(:,94),heltab2x32(:,:,256))
  call Hloop_Q_A(ntryL,G0H8(21),17,nMB,G1H8(10),n2h8(74))
  Gcoeff(:)%j = (c(10)*M(1,:)%j) * den(10)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(257),h0tab(:,257),[17,6,8],[nMB,nMW,nMW],3,2,wf4(:,12),wf4(:,10))
  call Hloop_WQ_A(ntryL,G0H32(1),wf4(:,12),G0H8(22),m3h4x8(:,95),heltab2x32(:,:,257))
  call Hloop_Q_A(ntryL,G0H8(22),17,nMB,G1H8(11),n2h8(75))
  Gcoeff(:)%j = (c(10)*M(1,:)%j) * den(10)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(258),h0tab(:,258),[17,6,8],[nMB,nMW,nMW],3,2,wf4(:,12),wf4(:,10))
  call Hloop_WQ_A(ntryL,G0H32(1),wf4(:,12),G0H8(23),m3h4x8(:,96),heltab2x32(:,:,258))
  call Hloop_Q_A(ntryL,G0H8(23),17,nMB,G1H8(12),n2h8(76))
  Gcoeff(:)%j = (-(c(24)*M(1,:)%j)) * den(34)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(259),h0tab(:,259),[16,1,14],[nMT,nMH,nMT],3,1,wf8(:,31))
  call Hloop_AV_Q(ntryL,G0H32(1),ex5(:),G0H16(1),m3h2x16(:,153),heltab2x32(:,:,259))
  call Hloop_A_Q(ntryL,G0H16(1),16,nMT,G1H16(17),n2h16(153))
  Gcoeff(:)%j = (c(24)*M(1,:)%j) * den(34)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(260),h0tab(:,260),[16,1,14],[nMT,nMZ,nMT],3,1,wf8(:,31))
  call Hloop_AV_Q(ntryL,G0H32(1),ex5(:),G0H16(1),m3h2x16(:,154),heltab2x32(:,:,260))
  call Hloop_A_Q(ntryL,G0H16(1),16,nMT,G1H16(18),n2h16(154))
  Gcoeff(:)%j = (c(18)*M(1,:)%j) * den(34)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(261),h0tab(:,261),[16,1,14],[nMB,nMW,nMB],3,1,wf8(:,31))
  call Hloop_AV_Q(ntryL,G0H32(1),ex5(:),G0H16(1),m3h2x16(:,155),heltab2x32(:,:,261))
  call Hloop_A_Q(ntryL,G0H16(1),16,nMB,G1H16(19),n2h16(155))
  Gcoeff(:)%j = (c(1)*M(1,:)%j) * den(34)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(262),h0tab(:,262),[16,1,14],[nMT,0,nMT],3,1,wf8(:,31))
  call Hloop_AV_Q(ntryL,G0H32(1),ex5(:),G0H16(1),m3h2x16(:,156),heltab2x32(:,:,262))
  call Hloop_A_Q(ntryL,G0H16(1),16,nMT,G1H16(20),n2h16(156))
  Gcoeff(:)%j = (c(2)*M(1,:)%j) * den(34)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(263),h0tab(:,263),[16,1,14],[nMT,nMZ,nMT],3,1,wf8(:,31))
  call Hloop_AV_Q(ntryL,G0H32(1),ex5(:),G0H16(1),m3h2x16(:,157),heltab2x32(:,:,263))
  call Hloop_A_Q(ntryL,G0H16(1),16,nMT,G1H16(21),n2h16(157))
  Gcoeff(:)%j = (c(9)*M(1,:)%j) * den(34)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(264),h0tab(:,264),[16,1,14],[nMB,nMW,nMB],3,1,wf8(:,31))
  call Hloop_AV_Q(ntryL,G0H32(1),ex5(:),G0H16(1),m3h2x16(:,158),heltab2x32(:,:,264))
  call Hloop_A_Q(ntryL,G0H16(1),16,nMB,G1H16(22),n2h16(158))
  Gcoeff(:)%j = (-(c(24)*M(1,:)%j)) * den(28)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(265),h0tab(:,265),[22,1,8],[nMH,nMT,nMT],3,1,wf8(:,28))
  call Hloop_QA_S(ntryL,G0H32(1),wf8(:,28),G0H4(7),ngH,m3h8x4(:,11),heltab2x32(:,:,265))
  Gcoeff(:)%j = (c(24)*M(1,:)%j) * den(28)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(266),h0tab(:,266),[22,1,8],[nMZ,nMT,nMT],3,1,wf8(:,28))
  call Hloop_QA_S(ntryL,G0H32(1),wf8(:,28),G0H4(8),ngX,m3h8x4(:,12),heltab2x32(:,:,266))
  Gcoeff(:)%j = (-(c(16)*M(1,:)%j)) * den(28)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(267),h0tab(:,267),[22,1,8],[nMW,nMB,nMB],3,1,wf8(:,28))
  call Hloop_QA_S(ntryL,G0H32(1),wf8(:,28),G0H4(9),ngPtb,m3h8x4(:,13),heltab2x32(:,:,267))
  Gcoeff(:)%j = (c(19)*M(1,:)%j) * den(28)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(268),h0tab(:,268),[22,1,8],[nMB,nMW,nMW],3,1,wf8(:,28))
  call Hloop_SA_Q(ntryL,G0H32(1),wf8(:,28),G0H4(10),ngPtb,m3h8x4(:,14),heltab2x32(:,:,268))
  call Hloop_A_Q(ntryL,G0H4(10),22,nMB,G1H4(99),n2h4(101))
  Gcoeff(:)%j = (c(1)*M(1,:)%j) * den(28)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(269),h0tab(:,269),[22,1,8],[0,nMT,nMT],3,1,wf8(:,28))
  call Hloop_QA_V(ntryL,G0H32(1),wf8(:,28),G0H4(10),m3h8x4(:,15),heltab2x32(:,:,269))
  Gcoeff(:)%j = (c(2)*M(1,:)%j) * den(28)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(270),h0tab(:,270),[22,1,8],[nMZ,nMT,nMT],3,1,wf8(:,28))
  call Hloop_QA_Z(ntryL,G0H32(1),wf8(:,28),G0H4(11),ngZu,m3h8x4(:,16),heltab2x32(:,:,270))
  Gcoeff(:)%j = (-(c(7)*M(1,:)%j)) * den(28)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(271),h0tab(:,271),[22,1,8],[nMW,nMB,nMB],3,1,wf8(:,28))
  call Hloop_QA_W(ntryL,G0H32(1),wf8(:,28),G0H4(12),m3h8x4(:,17),heltab2x32(:,:,271))
  Gcoeff(:)%j = (-(c(10)*M(1,:)%j)) * den(28)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(272),h0tab(:,272),[22,1,8],[nMB,nMW,nMW],3,1,wf8(:,28))
  call Hloop_WA_Q(ntryL,G0H32(1),wf8(:,28),G0H4(13),m3h8x4(:,18),heltab2x32(:,:,272))
  call Hloop_A_Q(ntryL,G0H4(13),22,nMB,G1H4(106),n2h4(102))
  Gcoeff(:)%j = (c(10)*M(1,:)%j) * den(28)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(273),h0tab(:,273),[22,1,8],[nMB,nMW,nMW],3,1,wf8(:,28))
  call Hloop_SA_Q(ntryL,G0H32(1),wf8(:,28),G0H4(13),ngPtb,m3h8x4(:,19),heltab2x32(:,:,273))
  call Hloop_A_Q(ntryL,G0H4(13),22,nMB,G1H4(100),n2h4(103))
  Gcoeff(:)%j = (c(10)*M(1,:)%j) * den(28)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(274),h0tab(:,274),[22,1,8],[nMB,nMW,nMW],3,1,wf8(:,28))
  call Hloop_WA_Q(ntryL,G0H32(1),wf8(:,28),G0H4(13),m3h8x4(:,20),heltab2x32(:,:,274))
  call Hloop_A_Q(ntryL,G0H4(13),22,nMB,G1H4(102),n2h4(104))
  Gcoeff(:)%j = (-(c(24)*M(1,:)%j)) * den(11)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(275),h0tab(:,275),[18,4,9],[nMT,nMT,nMH],3,2,wf4(:,6),wf4(:,9))
  call Hloop_SA_Q(ntryL,G0H32(1),wf4(:,6),G0H8(24),ngH,m3h4x8(:,97),heltab2x32(:,:,275))
  call Hloop_A_Q(ntryL,G0H8(24),18,nMT,G1H8(13),n2h8(77))
  Gcoeff(:)%j = (c(24)*M(1,:)%j) * den(11)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(276),h0tab(:,276),[18,4,9],[nMT,nMT,nMZ],3,2,wf4(:,6),wf4(:,9))
  call Hloop_SA_Q(ntryL,G0H32(1),wf4(:,6),G0H8(25),ngX,m3h4x8(:,98),heltab2x32(:,:,276))
  call Hloop_A_Q(ntryL,G0H8(25),18,nMT,G1H8(14),n2h8(78))
  Gcoeff(:)%j = (-(c(16)*M(1,:)%j)) * den(11)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(277),h0tab(:,277),[18,4,9],[nMB,nMB,nMW],3,2,wf4(:,6),wf4(:,9))
  call Hloop_SA_Q(ntryL,G0H32(1),wf4(:,6),G0H8(26),ngPtb,m3h4x8(:,99),heltab2x32(:,:,277))
  call Hloop_A_Q(ntryL,G0H8(26),18,nMB,G1H8(15),n2h8(79))
  Gcoeff(:)%j = (c(19)*M(1,:)%j) * den(11)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(278),h0tab(:,278),[18,4,9],[nMW,nMW,nMB],3,2,wf4(:,6),wf4(:,9))
  call Hloop_QA_S(ntryL,G0H32(1),wf4(:,6),G0H8(27),ngPtb,m3h4x8(:,100),heltab2x32(:,:,278))
  Gcoeff(:)%j = (c(1)*M(1,:)%j) * den(11)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(279),h0tab(:,279),[18,4,9],[nMT,nMT,0],3,2,wf4(:,6),wf4(:,9))
  call Hloop_VA_Q(ntryL,G0H32(1),wf4(:,6),G0H8(28),m3h4x8(:,101),heltab2x32(:,:,279))
  call Hloop_A_Q(ntryL,G0H8(28),18,nMT,G1H8(16),n2h8(80))
  Gcoeff(:)%j = (c(2)*M(1,:)%j) * den(11)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(280),h0tab(:,280),[18,4,9],[nMT,nMT,nMZ],3,2,wf4(:,6),wf4(:,9))
  call Hloop_ZA_Q(ntryL,G0H32(1),wf4(:,6),G0H8(29),ngZu,m3h4x8(:,102),heltab2x32(:,:,280))
  call Hloop_A_Q(ntryL,G0H8(29),18,nMT,G1H8(17),n2h8(81))
  Gcoeff(:)%j = (-(c(7)*M(1,:)%j)) * den(11)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(281),h0tab(:,281),[18,4,9],[nMB,nMB,nMW],3,2,wf4(:,6),wf4(:,9))
  call Hloop_WA_Q(ntryL,G0H32(1),wf4(:,6),G0H8(30),m3h4x8(:,103),heltab2x32(:,:,281))
  call Hloop_A_Q(ntryL,G0H8(30),18,nMB,G1H8(18),n2h8(82))
  Gcoeff(:)%j = (-(c(10)*M(1,:)%j)) * den(11)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(282),h0tab(:,282),[18,4,9],[nMW,nMW,nMB],3,2,wf4(:,6),wf4(:,9))
  call Hloop_QA_W(ntryL,G0H32(1),wf4(:,6),G0H8(31),m3h4x8(:,104),heltab2x32(:,:,282))
  Gcoeff(:)%j = (c(10)*M(1,:)%j) * den(11)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(283),h0tab(:,283),[18,4,9],[nMW,nMW,nMB],3,2,wf4(:,6),wf4(:,9))
  call Hloop_QA_S(ntryL,G0H32(1),wf4(:,6),G0H8(32),ngPtb,m3h4x8(:,105),heltab2x32(:,:,283))
  Gcoeff(:)%j = (c(10)*M(1,:)%j) * den(11)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(284),h0tab(:,284),[18,4,9],[nMW,nMW,nMB],3,2,wf4(:,6),wf4(:,9))
  call Hloop_QA_W(ntryL,G0H32(1),wf4(:,6),G0H8(33),m3h4x8(:,106),heltab2x32(:,:,284))
  Gcoeff(:)%j = (-(c(24)*M(1,:)%j)) * den(40)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(285),h0tab(:,285),[16,2,13],[nMT,nMH,nMT],3,1,wf8(:,35))
  call Hloop_QV_A(ntryL,G0H32(1),ex5(:),G0H16(1),m3h2x16(:,159),heltab2x32(:,:,285))
  call Hloop_Q_A(ntryL,G0H16(1),16,nMT,G1H16(23),n2h16(159))
  Gcoeff(:)%j = (c(24)*M(1,:)%j) * den(40)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(286),h0tab(:,286),[16,2,13],[nMT,nMZ,nMT],3,1,wf8(:,35))
  call Hloop_QV_A(ntryL,G0H32(1),ex5(:),G0H16(1),m3h2x16(:,160),heltab2x32(:,:,286))
  call Hloop_Q_A(ntryL,G0H16(1),16,nMT,G1H16(24),n2h16(160))
  Gcoeff(:)%j = (c(18)*M(1,:)%j) * den(40)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(287),h0tab(:,287),[16,2,13],[nMB,nMW,nMB],3,1,wf8(:,35))
  call Hloop_QV_A(ntryL,G0H32(1),ex5(:),G0H16(1),m3h2x16(:,161),heltab2x32(:,:,287))
  call Hloop_Q_A(ntryL,G0H16(1),16,nMB,G1H16(25),n2h16(161))
  Gcoeff(:)%j = (c(1)*M(1,:)%j) * den(40)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(288),h0tab(:,288),[16,2,13],[nMT,0,nMT],3,1,wf8(:,35))
  call Hloop_QV_A(ntryL,G0H32(1),ex5(:),G0H16(1),m3h2x16(:,162),heltab2x32(:,:,288))
  call Hloop_Q_A(ntryL,G0H16(1),16,nMT,G1H16(26),n2h16(162))
  Gcoeff(:)%j = (c(2)*M(1,:)%j) * den(40)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(289),h0tab(:,289),[16,2,13],[nMT,nMZ,nMT],3,1,wf8(:,35))
  call Hloop_QV_A(ntryL,G0H32(1),ex5(:),G0H16(1),m3h2x16(:,163),heltab2x32(:,:,289))
  call Hloop_Q_A(ntryL,G0H16(1),16,nMT,G1H16(27),n2h16(163))
  Gcoeff(:)%j = (c(9)*M(1,:)%j) * den(40)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(290),h0tab(:,290),[16,2,13],[nMB,nMW,nMB],3,1,wf8(:,35))
  call Hloop_QV_A(ntryL,G0H32(1),ex5(:),G0H16(1),m3h2x16(:,164),heltab2x32(:,:,290))
  call Hloop_Q_A(ntryL,G0H16(1),16,nMB,G1H16(28),n2h16(164))
  Gcoeff(:)%j = (-(c(24)*M(1,:)%j)) * den(31)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(291),h0tab(:,291),[25,2,4],[nMH,nMT,nMT],3,1,wf8(:,29))
  call Hloop_AQ_S(ntryL,G0H32(1),wf8(:,29),G0H4(13),ngH,m3h8x4(:,21),heltab2x32(:,:,291))
  Gcoeff(:)%j = (c(24)*M(1,:)%j) * den(31)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(292),h0tab(:,292),[25,2,4],[nMZ,nMT,nMT],3,1,wf8(:,29))
  call Hloop_AQ_S(ntryL,G0H32(1),wf8(:,29),G0H4(14),ngX,m3h8x4(:,22),heltab2x32(:,:,292))
  Gcoeff(:)%j = (-(c(16)*M(1,:)%j)) * den(31)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(293),h0tab(:,293),[25,2,4],[nMW,nMB,nMB],3,1,wf8(:,29))
  call Hloop_AQ_S(ntryL,G0H32(1),wf8(:,29),G0H4(15),ngPbt,m3h8x4(:,23),heltab2x32(:,:,293))
  Gcoeff(:)%j = (c(19)*M(1,:)%j) * den(31)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(294),h0tab(:,294),[25,2,4],[nMB,nMW,nMW],3,1,wf8(:,29))
  call Hloop_SQ_A(ntryL,G0H32(1),wf8(:,29),G0H4(16),ngPbt,m3h8x4(:,24),heltab2x32(:,:,294))
  call Hloop_Q_A(ntryL,G0H4(16),25,nMB,G1H4(105),n2h4(105))
  Gcoeff(:)%j = (c(1)*M(1,:)%j) * den(31)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(295),h0tab(:,295),[25,2,4],[0,nMT,nMT],3,1,wf8(:,29))
  call Hloop_AQ_V(ntryL,G0H32(1),wf8(:,29),G0H4(16),m3h8x4(:,25),heltab2x32(:,:,295))
  Gcoeff(:)%j = (c(2)*M(1,:)%j) * den(31)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(296),h0tab(:,296),[25,2,4],[nMZ,nMT,nMT],3,1,wf8(:,29))
  call Hloop_AQ_Z(ntryL,G0H32(1),wf8(:,29),G0H4(17),ngZu,m3h8x4(:,26),heltab2x32(:,:,296))
  Gcoeff(:)%j = (-(c(7)*M(1,:)%j)) * den(31)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(297),h0tab(:,297),[25,2,4],[nMW,nMB,nMB],3,1,wf8(:,29))
  call Hloop_AQ_W(ntryL,G0H32(1),wf8(:,29),G0H4(18),m3h8x4(:,27),heltab2x32(:,:,297))
  Gcoeff(:)%j = (c(10)*M(1,:)%j) * den(31)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(298),h0tab(:,298),[25,2,4],[nMB,nMW,nMW],3,1,wf8(:,29))
  call Hloop_WQ_A(ntryL,G0H32(1),wf8(:,29),G0H4(19),m3h8x4(:,28),heltab2x32(:,:,298))
  call Hloop_Q_A(ntryL,G0H4(19),25,nMB,G1H4(103),n2h4(106))
  Gcoeff(:)%j = (-(c(10)*M(1,:)%j)) * den(31)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(299),h0tab(:,299),[25,2,4],[nMB,nMW,nMW],3,1,wf8(:,29))
  call Hloop_SQ_A(ntryL,G0H32(1),wf8(:,29),G0H4(19),ngPbt,m3h8x4(:,29),heltab2x32(:,:,299))
  call Hloop_Q_A(ntryL,G0H4(19),25,nMB,G1H4(111),n2h4(107))
  Gcoeff(:)%j = (c(10)*M(1,:)%j) * den(31)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(300),h0tab(:,300),[25,2,4],[nMB,nMW,nMW],3,1,wf8(:,29))
  call Hloop_WQ_A(ntryL,G0H32(1),wf8(:,29),G0H4(19),m3h8x4(:,30),heltab2x32(:,:,300))
  call Hloop_Q_A(ntryL,G0H4(19),25,nMB,G1H4(117),n2h4(108))
  Gcoeff(:)%j = (-(c(24)*M(1,:)%j)) * den(12)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(301),h0tab(:,301),[17,4,10],[nMT,nMT,nMH],3,2,wf4(:,12),wf4(:,4))
  call Hloop_SQ_A(ntryL,G0H32(1),wf4(:,12),G0H8(1),ngH,m3h4x8(:,107),heltab2x32(:,:,301))
  call Hloop_Q_A(ntryL,G0H8(1),17,nMT,G1H8(19),n2h8(83))
  Gcoeff(:)%j = (c(24)*M(1,:)%j) * den(12)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(302),h0tab(:,302),[17,4,10],[nMT,nMT,nMZ],3,2,wf4(:,12),wf4(:,4))
  call Hloop_SQ_A(ntryL,G0H32(1),wf4(:,12),G0H8(2),ngX,m3h4x8(:,108),heltab2x32(:,:,302))
  call Hloop_Q_A(ntryL,G0H8(2),17,nMT,G1H8(20),n2h8(84))
  Gcoeff(:)%j = (-(c(16)*M(1,:)%j)) * den(12)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(303),h0tab(:,303),[17,4,10],[nMB,nMB,nMW],3,2,wf4(:,12),wf4(:,4))
  call Hloop_SQ_A(ntryL,G0H32(1),wf4(:,12),G0H8(3),ngPbt,m3h4x8(:,109),heltab2x32(:,:,303))
  call Hloop_Q_A(ntryL,G0H8(3),17,nMB,G1H8(21),n2h8(85))
  Gcoeff(:)%j = (c(19)*M(1,:)%j) * den(12)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(304),h0tab(:,304),[17,4,10],[nMW,nMW,nMB],3,2,wf4(:,12),wf4(:,4))
  call Hloop_AQ_S(ntryL,G0H32(1),wf4(:,12),G0H8(7),ngPbt,m3h4x8(:,110),heltab2x32(:,:,304))
  Gcoeff(:)%j = (c(1)*M(1,:)%j) * den(12)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(305),h0tab(:,305),[17,4,10],[nMT,nMT,0],3,2,wf4(:,12),wf4(:,4))
  call Hloop_VQ_A(ntryL,G0H32(1),wf4(:,12),G0H8(11),m3h4x8(:,111),heltab2x32(:,:,305))
  call Hloop_Q_A(ntryL,G0H8(11),17,nMT,G1H8(22),n2h8(86))
  Gcoeff(:)%j = (c(2)*M(1,:)%j) * den(12)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(306),h0tab(:,306),[17,4,10],[nMT,nMT,nMZ],3,2,wf4(:,12),wf4(:,4))
  call Hloop_ZQ_A(ntryL,G0H32(1),wf4(:,12),G0H8(12),ngZu,m3h4x8(:,112),heltab2x32(:,:,306))
  call Hloop_Q_A(ntryL,G0H8(12),17,nMT,G1H8(23),n2h8(87))
  Gcoeff(:)%j = (-(c(7)*M(1,:)%j)) * den(12)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(307),h0tab(:,307),[17,4,10],[nMB,nMB,nMW],3,2,wf4(:,12),wf4(:,4))
  call Hloop_WQ_A(ntryL,G0H32(1),wf4(:,12),G0H8(13),m3h4x8(:,113),heltab2x32(:,:,307))
  call Hloop_Q_A(ntryL,G0H8(13),17,nMB,G1H8(24),n2h8(88))
  Gcoeff(:)%j = (-(c(10)*M(1,:)%j)) * den(12)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(308),h0tab(:,308),[17,4,10],[nMW,nMW,nMB],3,2,wf4(:,12),wf4(:,4))
  call Hloop_AQ_S(ntryL,G0H32(1),wf4(:,12),G0H8(17),ngPbt,m3h4x8(:,114),heltab2x32(:,:,308))
  Gcoeff(:)%j = (c(10)*M(1,:)%j) * den(12)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(309),h0tab(:,309),[17,4,10],[nMW,nMW,nMB],3,2,wf4(:,12),wf4(:,4))
  call Hloop_AQ_W(ntryL,G0H32(1),wf4(:,12),G0H8(21),m3h4x8(:,115),heltab2x32(:,:,309))
  Gcoeff(:)%j = (c(10)*M(1,:)%j) * den(12)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(310),h0tab(:,310),[17,4,10],[nMW,nMW,nMB],3,2,wf4(:,12),wf4(:,4))
  call Hloop_AQ_W(ntryL,G0H32(1),wf4(:,12),G0H8(22),m3h4x8(:,116),heltab2x32(:,:,310))
  Gcoeff(:)%j = (-(c(24)*M(1,:)%j)) * den(42)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(311),h0tab(:,311),[16,1,14],[nMT,nMH,nMT],3,1,wf8(:,37))
  call Hloop_AV_Q(ntryL,G0H32(1),ex5(:),G0H16(1),m3h2x16(:,165),heltab2x32(:,:,311))
  call Hloop_A_Q(ntryL,G0H16(1),16,nMT,G1H16(29),n2h16(165))
  Gcoeff(:)%j = (c(24)*M(1,:)%j) * den(42)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(312),h0tab(:,312),[16,1,14],[nMT,nMZ,nMT],3,1,wf8(:,37))
  call Hloop_AV_Q(ntryL,G0H32(1),ex5(:),G0H16(1),m3h2x16(:,166),heltab2x32(:,:,312))
  call Hloop_A_Q(ntryL,G0H16(1),16,nMT,G1H16(30),n2h16(166))
  Gcoeff(:)%j = (c(18)*M(1,:)%j) * den(42)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(313),h0tab(:,313),[16,1,14],[nMB,nMW,nMB],3,1,wf8(:,37))
  call Hloop_AV_Q(ntryL,G0H32(1),ex5(:),G0H16(1),m3h2x16(:,167),heltab2x32(:,:,313))
  call Hloop_A_Q(ntryL,G0H16(1),16,nMB,G1H16(31),n2h16(167))
  Gcoeff(:)%j = (c(1)*M(1,:)%j) * den(42)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(314),h0tab(:,314),[16,1,14],[nMT,0,nMT],3,1,wf8(:,37))
  call Hloop_AV_Q(ntryL,G0H32(1),ex5(:),G0H16(1),m3h2x16(:,168),heltab2x32(:,:,314))
  call Hloop_A_Q(ntryL,G0H16(1),16,nMT,G1H16(32),n2h16(168))
  Gcoeff(:)%j = (c(2)*M(1,:)%j) * den(42)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(315),h0tab(:,315),[16,1,14],[nMT,nMZ,nMT],3,1,wf8(:,37))
  call Hloop_AV_Q(ntryL,G0H32(1),ex5(:),G0H16(1),m3h2x16(:,169),heltab2x32(:,:,315))
  call Hloop_A_Q(ntryL,G0H16(1),16,nMT,G1H16(33),n2h16(169))
  Gcoeff(:)%j = (c(9)*M(1,:)%j) * den(42)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(316),h0tab(:,316),[16,1,14],[nMB,nMW,nMB],3,1,wf8(:,37))
  call Hloop_AV_Q(ntryL,G0H32(1),ex5(:),G0H16(1),m3h2x16(:,170),heltab2x32(:,:,316))
  call Hloop_A_Q(ntryL,G0H16(1),16,nMB,G1H16(34),n2h16(170))
  Gcoeff(:)%j = (-(c(24)*M(1,:)%j)) * den(17)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(317),h0tab(:,317),[26,1,4],[nMH,nMT,nMT],3,1,wf8(:,22))
  call Hloop_QA_S(ntryL,G0H32(1),wf8(:,22),G0H4(19),ngH,m3h8x4(:,31),heltab2x32(:,:,317))
  Gcoeff(:)%j = (c(24)*M(1,:)%j) * den(17)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(318),h0tab(:,318),[26,1,4],[nMZ,nMT,nMT],3,1,wf8(:,22))
  call Hloop_QA_S(ntryL,G0H32(1),wf8(:,22),G0H4(20),ngX,m3h8x4(:,32),heltab2x32(:,:,318))
  Gcoeff(:)%j = (-(c(16)*M(1,:)%j)) * den(17)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(319),h0tab(:,319),[26,1,4],[nMW,nMB,nMB],3,1,wf8(:,22))
  call Hloop_QA_S(ntryL,G0H32(1),wf8(:,22),G0H4(21),ngPtb,m3h8x4(:,33),heltab2x32(:,:,319))
  Gcoeff(:)%j = (c(19)*M(1,:)%j) * den(17)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(320),h0tab(:,320),[26,1,4],[nMB,nMW,nMW],3,1,wf8(:,22))
  call Hloop_SA_Q(ntryL,G0H32(1),wf8(:,22),G0H4(22),ngPtb,m3h8x4(:,34),heltab2x32(:,:,320))
  call Hloop_A_Q(ntryL,G0H4(22),26,nMB,G1H4(123),n2h4(109))
  Gcoeff(:)%j = (c(1)*M(1,:)%j) * den(17)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(321),h0tab(:,321),[26,1,4],[0,nMT,nMT],3,1,wf8(:,22))
  call Hloop_QA_V(ntryL,G0H32(1),wf8(:,22),G0H4(22),m3h8x4(:,35),heltab2x32(:,:,321))
  Gcoeff(:)%j = (c(2)*M(1,:)%j) * den(17)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(322),h0tab(:,322),[26,1,4],[nMZ,nMT,nMT],3,1,wf8(:,22))
  call Hloop_QA_Z(ntryL,G0H32(1),wf8(:,22),G0H4(23),ngZu,m3h8x4(:,36),heltab2x32(:,:,322))
  Gcoeff(:)%j = (-(c(7)*M(1,:)%j)) * den(17)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(323),h0tab(:,323),[26,1,4],[nMW,nMB,nMB],3,1,wf8(:,22))
  call Hloop_QA_W(ntryL,G0H32(1),wf8(:,22),G0H4(24),m3h8x4(:,37),heltab2x32(:,:,323))
  Gcoeff(:)%j = (-(c(10)*M(1,:)%j)) * den(17)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(324),h0tab(:,324),[26,1,4],[nMB,nMW,nMW],3,1,wf8(:,22))
  call Hloop_WA_Q(ntryL,G0H32(1),wf8(:,22),G0H4(25),m3h8x4(:,38),heltab2x32(:,:,324))
  call Hloop_A_Q(ntryL,G0H4(25),26,nMB,G1H4(130),n2h4(110))
  Gcoeff(:)%j = (c(10)*M(1,:)%j) * den(17)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(325),h0tab(:,325),[26,1,4],[nMB,nMW,nMW],3,1,wf8(:,22))
  call Hloop_SA_Q(ntryL,G0H32(1),wf8(:,22),G0H4(25),ngPtb,m3h8x4(:,39),heltab2x32(:,:,325))
  call Hloop_A_Q(ntryL,G0H4(25),26,nMB,G1H4(124),n2h4(111))
  Gcoeff(:)%j = (c(10)*M(1,:)%j) * den(17)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(326),h0tab(:,326),[26,1,4],[nMB,nMW,nMW],3,1,wf8(:,22))
  call Hloop_WA_Q(ntryL,G0H32(1),wf8(:,22),G0H4(25),m3h8x4(:,40),heltab2x32(:,:,326))
  call Hloop_A_Q(ntryL,G0H4(25),26,nMB,G1H4(30),n2h4(112))
  Gcoeff(:)%j = (c(44)*M(1,:)%j) * den(47)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(327),h0tab(:,327),[19,4,8],[nME,nME,nME],3,1,wf8(:,13))
  call Hloop_AS_Q(ntryL,G0H32(1),wf8(:,13),G0H4(25),ngH,m3h8x4(:,41),heltab2x32(:,:,327))
  call Hloop_A_Q(ntryL,G0H4(25),19,nME,G1H4(129),n2h4(113))
  Gcoeff(:)%j = (c(46)*M(1,:)%j) * den(47)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(328),h0tab(:,328),[19,4,8],[nMM,nMM,nMM],3,1,wf8(:,13))
  call Hloop_AS_Q(ntryL,G0H32(1),wf8(:,13),G0H4(25),ngH,m3h8x4(:,42),heltab2x32(:,:,328))
  call Hloop_A_Q(ntryL,G0H4(25),19,nMM,G1H4(31),n2h4(114))
  Gcoeff(:)%j = (c(45)*M(1,:)%j) * den(47)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(329),h0tab(:,329),[19,4,8],[nML,nML,nML],3,1,wf8(:,13))
  call Hloop_AS_Q(ntryL,G0H32(1),wf8(:,13),G0H4(25),ngH,m3h8x4(:,43),heltab2x32(:,:,329))
  call Hloop_A_Q(ntryL,G0H4(25),19,nML,G1H4(135),n2h4(115))
  Gcoeff(:)%j = (c(44)*M(1,:)%j) * den(47)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(330),h0tab(:,330),[19,4,8],[nME,nME,nME],3,1,wf8(:,13))
  call Hloop_QS_A(ntryL,G0H32(1),wf8(:,13),G0H4(25),ngH,m3h8x4(:,44),heltab2x32(:,:,330))
  call Hloop_Q_A(ntryL,G0H4(25),19,nME,G1H4(141),n2h4(116))
  Gcoeff(:)%j = (c(46)*M(1,:)%j) * den(47)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(331),h0tab(:,331),[19,4,8],[nMM,nMM,nMM],3,1,wf8(:,13))
  call Hloop_QS_A(ntryL,G0H32(1),wf8(:,13),G0H4(25),ngH,m3h8x4(:,45),heltab2x32(:,:,331))
  call Hloop_Q_A(ntryL,G0H4(25),19,nMM,G1H4(147),n2h4(117))
  Gcoeff(:)%j = (c(45)*M(1,:)%j) * den(47)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(332),h0tab(:,332),[19,4,8],[nML,nML,nML],3,1,wf8(:,13))
  call Hloop_QS_A(ntryL,G0H32(1),wf8(:,13),G0H4(25),ngH,m3h8x4(:,46),heltab2x32(:,:,332))
  call Hloop_Q_A(ntryL,G0H4(25),19,nML,G1H4(154),n2h4(118))
  Gcoeff(:)%j = (c(47)*M(1,:)%j) * den(47)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(333),h0tab(:,333),[19,4,8],[nMT,nMT,nMT],3,1,wf8(:,13))
  call Hloop_AS_Q(ntryL,G0H32(1),wf8(:,13),G0H4(25),ngH,m3h8x4(:,47),heltab2x32(:,:,333))
  call Hloop_A_Q(ntryL,G0H4(25),19,nMT,G1H4(148),n2h4(119))
  Gcoeff(:)%j = (c(47)*M(1,:)%j) * den(47)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(334),h0tab(:,334),[19,4,8],[nMT,nMT,nMT],3,1,wf8(:,13))
  call Hloop_QS_A(ntryL,G0H32(1),wf8(:,13),G0H4(25),ngH,m3h8x4(:,48),heltab2x32(:,:,334))
  call Hloop_Q_A(ntryL,G0H4(25),19,nMT,G1H4(50),n2h4(120))
  Gcoeff(:)%j = (c(43)*M(1,:)%j) * den(47)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(335),h0tab(:,335),[19,4,8],[nMB,nMB,nMB],3,1,wf8(:,13))
  call Hloop_AS_Q(ntryL,G0H32(1),wf8(:,13),G0H4(25),ngH,m3h8x4(:,49),heltab2x32(:,:,335))
  call Hloop_A_Q(ntryL,G0H4(25),19,nMB,G1H4(153),n2h4(121))
  Gcoeff(:)%j = (c(43)*M(1,:)%j) * den(47)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(336),h0tab(:,336),[19,4,8],[nMB,nMB,nMB],3,1,wf8(:,13))
  call Hloop_QS_A(ntryL,G0H32(1),wf8(:,13),G0H4(25),ngH,m3h8x4(:,50),heltab2x32(:,:,336))
  call Hloop_Q_A(ntryL,G0H4(25),19,nMB,G1H4(53),n2h4(122))
  Gcoeff(:)%j = (c(44)*M(1,:)%j) * den(49)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(337),h0tab(:,337),[19,4,8],[nME,nME,nME],3,1,wf8(:,39))
  call Hloop_AS_Q(ntryL,G0H32(1),wf8(:,39),G0H4(25),ngX,m3h8x4(:,51),heltab2x32(:,:,337))
  call Hloop_A_Q(ntryL,G0H4(25),19,nME,G1H4(159),n2h4(123))
  Gcoeff(:)%j = (c(46)*M(1,:)%j) * den(49)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(338),h0tab(:,338),[19,4,8],[nMM,nMM,nMM],3,1,wf8(:,39))
  call Hloop_AS_Q(ntryL,G0H32(1),wf8(:,39),G0H4(25),ngX,m3h8x4(:,52),heltab2x32(:,:,338))
  call Hloop_A_Q(ntryL,G0H4(25),19,nMM,G1H4(165),n2h4(124))
  Gcoeff(:)%j = (c(45)*M(1,:)%j) * den(49)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(339),h0tab(:,339),[19,4,8],[nML,nML,nML],3,1,wf8(:,39))
  call Hloop_AS_Q(ntryL,G0H32(1),wf8(:,39),G0H4(25),ngX,m3h8x4(:,53),heltab2x32(:,:,339))
  call Hloop_A_Q(ntryL,G0H4(25),19,nML,G1H4(171),n2h4(125))
  Gcoeff(:)%j = (c(44)*M(1,:)%j) * den(49)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(340),h0tab(:,340),[19,4,8],[nME,nME,nME],3,1,wf8(:,39))
  call Hloop_QS_A(ntryL,G0H32(1),wf8(:,39),G0H4(25),ngX,m3h8x4(:,54),heltab2x32(:,:,340))
  call Hloop_Q_A(ntryL,G0H4(25),19,nME,G1H4(177),n2h4(126))
  Gcoeff(:)%j = (c(46)*M(1,:)%j) * den(49)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(341),h0tab(:,341),[19,4,8],[nMM,nMM,nMM],3,1,wf8(:,39))
  call Hloop_QS_A(ntryL,G0H32(1),wf8(:,39),G0H4(25),ngX,m3h8x4(:,55),heltab2x32(:,:,341))
  call Hloop_Q_A(ntryL,G0H4(25),19,nMM,G1H4(195),n2h4(127))
  Gcoeff(:)%j = (c(45)*M(1,:)%j) * den(49)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(342),h0tab(:,342),[19,4,8],[nML,nML,nML],3,1,wf8(:,39))
  call Hloop_QS_A(ntryL,G0H32(1),wf8(:,39),G0H4(25),ngX,m3h8x4(:,56),heltab2x32(:,:,342))
  call Hloop_Q_A(ntryL,G0H4(25),19,nML,G1H4(201),n2h4(128))
  Gcoeff(:)%j = (-(c(47)*M(1,:)%j)) * den(49)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(343),h0tab(:,343),[19,4,8],[nMT,nMT,nMT],3,1,wf8(:,39))
  call Hloop_AS_Q(ntryL,G0H32(1),wf8(:,39),G0H4(25),ngX,m3h8x4(:,57),heltab2x32(:,:,343))
  call Hloop_A_Q(ntryL,G0H4(25),19,nMT,G1H4(3),n2h4(129))
  Gcoeff(:)%j = (-(c(47)*M(1,:)%j)) * den(49)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(344),h0tab(:,344),[19,4,8],[nMT,nMT,nMT],3,1,wf8(:,39))
  call Hloop_QS_A(ntryL,G0H32(1),wf8(:,39),G0H4(25),ngX,m3h8x4(:,58),heltab2x32(:,:,344))
  call Hloop_Q_A(ntryL,G0H4(25),19,nMT,G1H4(1),n2h4(130))
  Gcoeff(:)%j = (c(43)*M(1,:)%j) * den(49)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(345),h0tab(:,345),[19,4,8],[nMB,nMB,nMB],3,1,wf8(:,39))
  call Hloop_AS_Q(ntryL,G0H32(1),wf8(:,39),G0H4(25),ngX,m3h8x4(:,59),heltab2x32(:,:,345))
  call Hloop_A_Q(ntryL,G0H4(25),19,nMB,G1H4(10),n2h4(131))
  Gcoeff(:)%j = (c(43)*M(1,:)%j) * den(49)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(346),h0tab(:,346),[19,4,8],[nMB,nMB,nMB],3,1,wf8(:,39))
  call Hloop_QS_A(ntryL,G0H32(1),wf8(:,39),G0H4(25),ngX,m3h8x4(:,60),heltab2x32(:,:,346))
  call Hloop_Q_A(ntryL,G0H4(25),19,nMB,G1H4(2),n2h4(132))
  Gcoeff(:)%j = (-(c(22)*M(1,:)%j)) * den(47)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(347),h0tab(:,347),[19,4,8],[nMW,nMW,nMW],3,1,wf8(:,13))
  call Hloop_SS_S(ntryL,G0H32(1),wf8(:,13),G0H4(25),m3h8x4(:,61),heltab2x32(:,:,347))
  Gcoeff(:)%j = (-(c(22)*M(1,:)%j)) * den(47)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(348),h0tab(:,348),[19,4,8],[nMW,nMW,nMW],3,1,wf8(:,13))
  call Hloop_SS_S(ntryL,G0H32(1),wf8(:,13),G0H4(26),m3h8x4(:,62),heltab2x32(:,:,348))
  Gcoeff(:)%j = (c(12)*M(1,:)%j) * den(47)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(349),h0tab(:,349),[19,4,8],[nMW,nMW,nMW],3,1,wf8(:,13))
  call Hloop_SS_S(ntryL,G0H32(1),wf8(:,13),G0H4(27),m3h8x4(:,63),heltab2x32(:,:,349))
  Gcoeff(:)%j = (c(12)*M(1,:)%j) * den(47)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(350),h0tab(:,350),[19,4,8],[nMW,nMW,nMW],3,1,wf8(:,13))
  call Hloop_SS_S(ntryL,G0H32(1),wf8(:,13),G0H4(28),m3h8x4(:,64),heltab2x32(:,:,350))
  Gcoeff(:)%j = (c(12)*M(1,:)%j) * den(47)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(351),h0tab(:,351),[19,4,8],[nMW,nMW,nMW],3,1,wf8(:,13))
  call Hloop_SS_S(ntryL,G0H32(1),wf8(:,13),G0H4(29),m3h8x4(:,65),heltab2x32(:,:,351))
  Gcoeff(:)%j = (c(12)*M(1,:)%j) * den(47)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(352),h0tab(:,352),[19,4,8],[nMW,nMW,nMW],3,1,wf8(:,13))
  call Hloop_SS_S(ntryL,G0H32(1),wf8(:,13),G0H4(30),m3h8x4(:,66),heltab2x32(:,:,352))
  Gcoeff(:)%j = (c(12)*M(1,:)%j) * den(49)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(353),h0tab(:,353),[19,4,8],[nMW,nMW,nMW],3,1,wf8(:,39))
  call Hloop_SS_S(ntryL,G0H32(1),wf8(:,39),G0H4(31),m3h8x4(:,67),heltab2x32(:,:,353))
  Gcoeff(:)%j = (c(12)*M(1,:)%j) * den(49)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(354),h0tab(:,354),[19,4,8],[nMW,nMW,nMW],3,1,wf8(:,39))
  call Hloop_SS_S(ntryL,G0H32(1),wf8(:,39),G0H4(32),m3h8x4(:,68),heltab2x32(:,:,354))
  Gcoeff(:)%j = (-(c(12)*M(1,:)%j)) * den(49)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(355),h0tab(:,355),[19,4,8],[nMW,nMW,nMW],3,1,wf8(:,39))
  call Hloop_SS_S(ntryL,G0H32(1),wf8(:,39),G0H4(33),m3h8x4(:,69),heltab2x32(:,:,355))
  Gcoeff(:)%j = (-(c(12)*M(1,:)%j)) * den(49)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(356),h0tab(:,356),[19,4,8],[nMW,nMW,nMW],3,1,wf8(:,39))
  call Hloop_SS_S(ntryL,G0H32(1),wf8(:,39),G0H4(34),m3h8x4(:,70),heltab2x32(:,:,356))
  Gcoeff(:)%j = (-(c(13)*M(1,:)%j)) * den(47)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(357),h0tab(:,357),[19,4,8],[nMW,nMW,nMW],3,1,wf8(:,13))
  call Hloop_VS_V(ntryL,G0H32(1),wf8(:,13),G0H4(35),m3h8x4(:,71),heltab2x32(:,:,357))
  Gcoeff(:)%j = (-(c(13)*M(1,:)%j)) * den(47)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(358),h0tab(:,358),[19,4,8],[nMW,nMW,nMW],3,1,wf8(:,13))
  call Hloop_VS_V(ntryL,G0H32(1),wf8(:,13),G0H4(36),m3h8x4(:,72),heltab2x32(:,:,358))
  Gcoeff(:)%j = (c(12)*M(1,:)%j) * den(47)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(359),h0tab(:,359),[19,4,8],[nMW,nMW,nMW],3,1,wf8(:,13))
  call Hloop_VT_S(ntryL,G0H32(1),0,wf8(:,13),19,G1H4(16),m3h8x4(:,73),heltab2x32(:,:,359))
  Gcoeff(:)%j = (-(c(12)*M(1,:)%j)) * den(47)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(360),h0tab(:,360),[19,4,8],[nMW,nMW,nMW],3,1,wf8(:,13))
  call Hloop_VT_S(ntryL,G0H32(1),0,wf8(:,13),19,G1H4(6),m3h8x4(:,74),heltab2x32(:,:,360))
  Gcoeff(:)%j = (-(c(12)*M(1,:)%j)) * den(49)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(361),h0tab(:,361),[19,4,8],[nMW,nMW,nMW],3,1,wf8(:,39))
  call Hloop_VT_S(ntryL,G0H32(1),0,wf8(:,39),19,G1H4(21),m3h8x4(:,75),heltab2x32(:,:,361))
  Gcoeff(:)%j = (-(c(12)*M(1,:)%j)) * den(49)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(362),h0tab(:,362),[19,4,8],[nMW,nMW,nMW],3,1,wf8(:,39))
  call Hloop_VT_S(ntryL,G0H32(1),0,wf8(:,39),19,G1H4(5),m3h8x4(:,76),heltab2x32(:,:,362))
  Gcoeff(:)%j = (-(c(12)*M(1,:)%j)) * den(47)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(363),h0tab(:,363),[19,4,8],[nMW,nMW,nMW],3,1,wf8(:,13))
  call Hloop_ST_V(ntryL,G0H32(1),0,wf8(:,13),19,G1H4(27),m3h8x4(:,77),heltab2x32(:,:,363))
  Gcoeff(:)%j = (c(12)*M(1,:)%j) * den(47)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(364),h0tab(:,364),[19,4,8],[nMW,nMW,nMW],3,1,wf8(:,13))
  call Hloop_ST_V(ntryL,G0H32(1),0,wf8(:,13),19,G1H4(8),m3h8x4(:,78),heltab2x32(:,:,364))
  Gcoeff(:)%j = (-(c(12)*M(1,:)%j)) * den(49)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(365),h0tab(:,365),[19,4,8],[nMW,nMW,nMW],3,1,wf8(:,39))
  call Hloop_ST_V(ntryL,G0H32(1),0,wf8(:,39),19,G1H4(33),m3h8x4(:,79),heltab2x32(:,:,365))
  Gcoeff(:)%j = (-(c(12)*M(1,:)%j)) * den(49)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(366),h0tab(:,366),[19,4,8],[nMW,nMW,nMW],3,1,wf8(:,39))
  call Hloop_ST_V(ntryL,G0H32(1),0,wf8(:,39),19,G1H4(7),m3h8x4(:,80),heltab2x32(:,:,366))
  Gcoeff(:)%j = (c(14)*M(1,:)%j) * den(47)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(367),h0tab(:,367),[19,4,8],[nMW,nMW,nMW],3,1,wf8(:,13))
  call Hloop_SS_S(ntryL,G0H32(1),wf8(:,13),G0H4(37),m3h8x4(:,81),heltab2x32(:,:,367))
  Gcoeff(:)%j = (c(14)*M(1,:)%j) * den(47)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(368),h0tab(:,368),[19,4,8],[nMW,nMW,nMW],3,1,wf8(:,13))
  call Hloop_SS_S(ntryL,G0H32(1),wf8(:,13),G0H4(38),m3h8x4(:,82),heltab2x32(:,:,368))
  Gcoeff(:)%j = (c(26)*M(1,:)%j) * den(47)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(369),h0tab(:,369),[19,4,8],[nMW,nMW,nMW],3,1,wf8(:,13))
  call Hloop_VS_V(ntryL,G0H32(1),wf8(:,13),G0H4(39),m3h8x4(:,83),heltab2x32(:,:,369))
  Gcoeff(:)%j = (c(26)*M(1,:)%j) * den(47)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(370),h0tab(:,370),[19,4,8],[nMW,nMW,nMW],3,1,wf8(:,13))
  call Hloop_VS_V(ntryL,G0H32(1),wf8(:,13),G0H4(40),m3h8x4(:,84),heltab2x32(:,:,370))
  Gcoeff(:)%j = (c(12)*M(1,:)%j) * den(47)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(371),h0tab(:,371),[19,4,8],[nMW,nMW,nMW],3,1,wf8(:,13))
  call Hloop_VT_S(ntryL,G0H32(1),0,wf8(:,13),19,G1H4(79),m3h8x4(:,85),heltab2x32(:,:,371))
  Gcoeff(:)%j = (-(c(12)*M(1,:)%j)) * den(47)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(372),h0tab(:,372),[19,4,8],[nMW,nMW,nMW],3,1,wf8(:,13))
  call Hloop_VT_S(ntryL,G0H32(1),0,wf8(:,13),19,G1H4(58),m3h8x4(:,86),heltab2x32(:,:,372))
  Gcoeff(:)%j = (-(c(12)*M(1,:)%j)) * den(49)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(373),h0tab(:,373),[19,4,8],[nMW,nMW,nMW],3,1,wf8(:,39))
  call Hloop_VT_S(ntryL,G0H32(1),0,wf8(:,39),19,G1H4(86),m3h8x4(:,87),heltab2x32(:,:,373))
  Gcoeff(:)%j = (-(c(12)*M(1,:)%j)) * den(49)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(374),h0tab(:,374),[19,4,8],[nMW,nMW,nMW],3,1,wf8(:,39))
  call Hloop_VT_S(ntryL,G0H32(1),0,wf8(:,39),19,G1H4(89),m3h8x4(:,88),heltab2x32(:,:,374))
  Gcoeff(:)%j = (-(c(12)*M(1,:)%j)) * den(47)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(375),h0tab(:,375),[19,4,8],[nMW,nMW,nMW],3,1,wf8(:,13))
  call Hloop_ST_V(ntryL,G0H32(1),0,wf8(:,13),19,G1H4(52),m3h8x4(:,89),heltab2x32(:,:,375))
  Gcoeff(:)%j = (c(12)*M(1,:)%j) * den(47)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(376),h0tab(:,376),[19,4,8],[nMW,nMW,nMW],3,1,wf8(:,13))
  call Hloop_ST_V(ntryL,G0H32(1),0,wf8(:,13),19,G1H4(85),m3h8x4(:,90),heltab2x32(:,:,376))
  Gcoeff(:)%j = (-(c(12)*M(1,:)%j)) * den(49)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(377),h0tab(:,377),[19,4,8],[nMW,nMW,nMW],3,1,wf8(:,39))
  call Hloop_ST_V(ntryL,G0H32(1),0,wf8(:,39),19,G1H4(63),m3h8x4(:,91),heltab2x32(:,:,377))
  Gcoeff(:)%j = (-(c(12)*M(1,:)%j)) * den(49)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(378),h0tab(:,378),[19,4,8],[nMW,nMW,nMW],3,1,wf8(:,39))
  call Hloop_ST_V(ntryL,G0H32(1),0,wf8(:,39),19,G1H4(12),m3h8x4(:,92),heltab2x32(:,:,378))
  Gcoeff(:)%j = (c(40)*M(1,:)%j) * den(51)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(379),h0tab(:,379),[19,4,8],[nME,nME,nME],3,1,wf8(:,40))
  call Hloop_AV_Q(ntryL,G0H32(1),wf8(:,40),G0H4(41),m3h8x4(:,93),heltab2x32(:,:,379))
  call Hloop_A_Q(ntryL,G0H4(41),19,nME,G1H4(69),n2h4(133))
  Gcoeff(:)%j = (c(40)*M(1,:)%j) * den(51)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(380),h0tab(:,380),[19,4,8],[nMM,nMM,nMM],3,1,wf8(:,40))
  call Hloop_AV_Q(ntryL,G0H32(1),wf8(:,40),G0H4(41),m3h8x4(:,94),heltab2x32(:,:,380))
  call Hloop_A_Q(ntryL,G0H4(41),19,nMM,G1H4(11),n2h4(134))
  Gcoeff(:)%j = (c(40)*M(1,:)%j) * den(51)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(381),h0tab(:,381),[19,4,8],[nML,nML,nML],3,1,wf8(:,40))
  call Hloop_AV_Q(ntryL,G0H32(1),wf8(:,40),G0H4(41),m3h8x4(:,95),heltab2x32(:,:,381))
  call Hloop_A_Q(ntryL,G0H4(41),19,nML,G1H4(75),n2h4(135))
  Gcoeff(:)%j = (c(40)*M(1,:)%j) * den(51)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(382),h0tab(:,382),[19,4,8],[nME,nME,nME],3,1,wf8(:,40))
  call Hloop_QV_A(ntryL,G0H32(1),wf8(:,40),G0H4(41),m3h8x4(:,96),heltab2x32(:,:,382))
  call Hloop_Q_A(ntryL,G0H4(41),19,nME,G1H4(14),n2h4(136))
  Gcoeff(:)%j = (c(40)*M(1,:)%j) * den(51)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(383),h0tab(:,383),[19,4,8],[nMM,nMM,nMM],3,1,wf8(:,40))
  call Hloop_QV_A(ntryL,G0H32(1),wf8(:,40),G0H4(41),m3h8x4(:,97),heltab2x32(:,:,383))
  call Hloop_Q_A(ntryL,G0H4(41),19,nMM,G1H4(81),n2h4(137))
  Gcoeff(:)%j = (c(40)*M(1,:)%j) * den(51)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(384),h0tab(:,384),[19,4,8],[nML,nML,nML],3,1,wf8(:,40))
  call Hloop_QV_A(ntryL,G0H32(1),wf8(:,40),G0H4(41),m3h8x4(:,98),heltab2x32(:,:,384))
  call Hloop_Q_A(ntryL,G0H4(41),19,nML,G1H4(13),n2h4(138))
  Gcoeff(:)%j = (-(c(38)*M(1,:)%j)) * den(51)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(385),h0tab(:,385),[19,4,8],[0,0,0],3,1,wf8(:,40))
  call Hloop_AV_Q(ntryL,G0H32(1),wf8(:,40),G0H4(41),m3h8x4(:,99),heltab2x32(:,:,385))
  call Hloop_A_Q(ntryL,G0H4(41),19,0,G1H4(87),n2h4(139))
  Gcoeff(:)%j = (-(c(36)*M(1,:)%j)) * den(51)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(386),h0tab(:,386),[19,4,8],[nMT,nMT,nMT],3,1,wf8(:,40))
  call Hloop_AV_Q(ntryL,G0H32(1),wf8(:,40),G0H4(41),m3h8x4(:,100),heltab2x32(:,:,386))
  call Hloop_A_Q(ntryL,G0H4(41),19,nMT,G1H4(17),n2h4(140))
  Gcoeff(:)%j = (-(c(38)*M(1,:)%j)) * den(51)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(387),h0tab(:,387),[19,4,8],[0,0,0],3,1,wf8(:,40))
  call Hloop_QV_A(ntryL,G0H32(1),wf8(:,40),G0H4(41),m3h8x4(:,101),heltab2x32(:,:,387))
  call Hloop_Q_A(ntryL,G0H4(41),19,0,G1H4(93),n2h4(141))
  Gcoeff(:)%j = (-(c(36)*M(1,:)%j)) * den(51)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(388),h0tab(:,388),[19,4,8],[nMT,nMT,nMT],3,1,wf8(:,40))
  call Hloop_QV_A(ntryL,G0H32(1),wf8(:,40),G0H4(41),m3h8x4(:,102),heltab2x32(:,:,388))
  call Hloop_Q_A(ntryL,G0H4(41),19,nMT,G1H4(18),n2h4(142))
  Gcoeff(:)%j = (c(34)*M(1,:)%j) * den(51)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(389),h0tab(:,389),[19,4,8],[0,0,0],3,1,wf8(:,40))
  call Hloop_AV_Q(ntryL,G0H32(1),wf8(:,40),G0H4(41),m3h8x4(:,103),heltab2x32(:,:,389))
  call Hloop_A_Q(ntryL,G0H4(41),19,0,G1H4(101),n2h4(143))
  Gcoeff(:)%j = (c(33)*M(1,:)%j) * den(51)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(390),h0tab(:,390),[19,4,8],[nMB,nMB,nMB],3,1,wf8(:,40))
  call Hloop_AV_Q(ntryL,G0H32(1),wf8(:,40),G0H4(41),m3h8x4(:,104),heltab2x32(:,:,390))
  call Hloop_A_Q(ntryL,G0H4(41),19,nMB,G1H4(118),n2h4(144))
  Gcoeff(:)%j = (c(34)*M(1,:)%j) * den(51)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(391),h0tab(:,391),[19,4,8],[0,0,0],3,1,wf8(:,40))
  call Hloop_QV_A(ntryL,G0H32(1),wf8(:,40),G0H4(41),m3h8x4(:,105),heltab2x32(:,:,391))
  call Hloop_Q_A(ntryL,G0H4(41),19,0,G1H4(108),n2h4(145))
  Gcoeff(:)%j = (c(33)*M(1,:)%j) * den(51)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(392),h0tab(:,392),[19,4,8],[nMB,nMB,nMB],3,1,wf8(:,40))
  call Hloop_QV_A(ntryL,G0H32(1),wf8(:,40),G0H4(41),m3h8x4(:,106),heltab2x32(:,:,392))
  call Hloop_Q_A(ntryL,G0H4(41),19,nMB,G1H4(109),n2h4(146))
  Gcoeff(:)%j = (-(c(42)*M(1,:)%j)) * den(49)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(393),h0tab(:,393),[19,4,8],[nME,nME,nME],3,1,wf8(:,41))
  call Hloop_AZ_Q(ntryL,G0H32(1),wf8(:,41),G0H4(41),ngZl,m3h8x4(:,107),heltab2x32(:,:,393))
  call Hloop_A_Q(ntryL,G0H4(41),19,nME,G1H4(112),n2h4(147))
  Gcoeff(:)%j = (-(c(42)*M(1,:)%j)) * den(49)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(394),h0tab(:,394),[19,4,8],[nMM,nMM,nMM],3,1,wf8(:,41))
  call Hloop_AZ_Q(ntryL,G0H32(1),wf8(:,41),G0H4(41),ngZl,m3h8x4(:,108),heltab2x32(:,:,394))
  call Hloop_A_Q(ntryL,G0H4(41),19,nMM,G1H4(107),n2h4(148))
  Gcoeff(:)%j = (-(c(42)*M(1,:)%j)) * den(49)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(395),h0tab(:,395),[19,4,8],[nML,nML,nML],3,1,wf8(:,41))
  call Hloop_AZ_Q(ntryL,G0H32(1),wf8(:,41),G0H4(41),ngZl,m3h8x4(:,109),heltab2x32(:,:,395))
  call Hloop_A_Q(ntryL,G0H4(41),19,nML,G1H4(29),n2h4(149))
  Gcoeff(:)%j = (-(c(42)*M(1,:)%j)) * den(49)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(396),h0tab(:,396),[19,4,8],[nME,nME,nME],3,1,wf8(:,41))
  call Hloop_QZ_A(ntryL,G0H32(1),wf8(:,41),G0H4(41),ngZl,m3h8x4(:,110),heltab2x32(:,:,396))
  call Hloop_Q_A(ntryL,G0H4(41),19,nME,G1H4(142),n2h4(150))
  Gcoeff(:)%j = (-(c(42)*M(1,:)%j)) * den(49)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(397),h0tab(:,397),[19,4,8],[nMM,nMM,nMM],3,1,wf8(:,41))
  call Hloop_QZ_A(ntryL,G0H32(1),wf8(:,41),G0H4(41),ngZl,m3h8x4(:,111),heltab2x32(:,:,397))
  call Hloop_Q_A(ntryL,G0H4(41),19,nMM,G1H4(36),n2h4(151))
  Gcoeff(:)%j = (-(c(42)*M(1,:)%j)) * den(49)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(398),h0tab(:,398),[19,4,8],[nML,nML,nML],3,1,wf8(:,41))
  call Hloop_QZ_A(ntryL,G0H32(1),wf8(:,41),G0H4(41),ngZl,m3h8x4(:,112),heltab2x32(:,:,398))
  call Hloop_Q_A(ntryL,G0H4(41),19,nML,G1H4(37),n2h4(152))
  Gcoeff(:)%j = (-(c(41)*M(1,:)%j)) * den(49)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(399),h0tab(:,399),[19,4,8],[0,0,0],3,1,wf8(:,41))
  call Hloop_AZ_Q(ntryL,G0H32(1),wf8(:,41),G0H4(41),ngZu,m3h8x4(:,113),heltab2x32(:,:,399))
  call Hloop_A_Q(ntryL,G0H4(41),19,0,G1H4(136),n2h4(153))
  Gcoeff(:)%j = (-(c(39)*M(1,:)%j)) * den(49)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(400),h0tab(:,400),[19,4,8],[nMT,nMT,nMT],3,1,wf8(:,41))
  call Hloop_AZ_Q(ntryL,G0H32(1),wf8(:,41),G0H4(41),ngZu,m3h8x4(:,114),heltab2x32(:,:,400))
  call Hloop_A_Q(ntryL,G0H4(41),19,nMT,G1H4(35),n2h4(154))
  Gcoeff(:)%j = (-(c(41)*M(1,:)%j)) * den(49)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(401),h0tab(:,401),[19,4,8],[0,0,0],3,1,wf8(:,41))
  call Hloop_QZ_A(ntryL,G0H32(1),wf8(:,41),G0H4(41),ngZu,m3h8x4(:,115),heltab2x32(:,:,401))
  call Hloop_Q_A(ntryL,G0H4(41),19,0,G1H4(49),n2h4(155))
  Gcoeff(:)%j = (-(c(39)*M(1,:)%j)) * den(49)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(402),h0tab(:,402),[19,4,8],[nMT,nMT,nMT],3,1,wf8(:,41))
  call Hloop_QZ_A(ntryL,G0H32(1),wf8(:,41),G0H4(41),ngZu,m3h8x4(:,116),heltab2x32(:,:,402))
  call Hloop_Q_A(ntryL,G0H4(41),19,nMT,G1H4(166),n2h4(156))
  Gcoeff(:)%j = (-(c(37)*M(1,:)%j)) * den(49)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(403),h0tab(:,403),[19,4,8],[0,0,0],3,1,wf8(:,41))
  call Hloop_AZ_Q(ntryL,G0H32(1),wf8(:,41),G0H4(41),ngZd,m3h8x4(:,117),heltab2x32(:,:,403))
  call Hloop_A_Q(ntryL,G0H4(41),19,0,G1H4(56),n2h4(157))
  Gcoeff(:)%j = (-(c(35)*M(1,:)%j)) * den(49)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(404),h0tab(:,404),[19,4,8],[nMB,nMB,nMB],3,1,wf8(:,41))
  call Hloop_AZ_Q(ntryL,G0H32(1),wf8(:,41),G0H4(41),ngZd,m3h8x4(:,118),heltab2x32(:,:,404))
  call Hloop_A_Q(ntryL,G0H4(41),19,nMB,G1H4(59),n2h4(158))
  Gcoeff(:)%j = (-(c(37)*M(1,:)%j)) * den(49)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(405),h0tab(:,405),[19,4,8],[0,0,0],3,1,wf8(:,41))
  call Hloop_QZ_A(ntryL,G0H32(1),wf8(:,41),G0H4(41),ngZd,m3h8x4(:,119),heltab2x32(:,:,405))
  call Hloop_Q_A(ntryL,G0H4(41),19,0,G1H4(160),n2h4(159))
  Gcoeff(:)%j = (-(c(35)*M(1,:)%j)) * den(49)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(406),h0tab(:,406),[19,4,8],[nMB,nMB,nMB],3,1,wf8(:,41))
  call Hloop_QZ_A(ntryL,G0H32(1),wf8(:,41),G0H4(41),ngZd,m3h8x4(:,120),heltab2x32(:,:,406))
  call Hloop_Q_A(ntryL,G0H4(41),19,nMB,G1H4(55),n2h4(160))
  Gcoeff(:)%j = (c(3)*M(1,:)%j) * den(51)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(407),h0tab(:,407),[19,4,8],[nMW,nMW,nMW],3,1,wf8(:,40))
  call Hloop_SV_T(ntryL,G0H32(1),0,wf8(:,40),19,G1H4(72),m3h8x4(:,121),heltab2x32(:,:,407))
  Gcoeff(:)%j = (c(3)*M(1,:)%j) * den(51)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(408),h0tab(:,408),[19,4,8],[nMW,nMW,nMW],3,1,wf8(:,40))
  call Hloop_TV_S(ntryL,G0H32(1),0,wf8(:,40),19,G1H4(78),m3h8x4(:,122),heltab2x32(:,:,408))
  Gcoeff(:)%j = (-(c(30)*M(1,:)%j)) * den(49)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(409),h0tab(:,409),[19,4,8],[nMW,nMW,nMW],3,1,wf8(:,41))
  call Hloop_SV_T(ntryL,G0H32(1),0,wf8(:,41),19,G1H4(183),m3h8x4(:,123),heltab2x32(:,:,409))
  Gcoeff(:)%j = (-(c(30)*M(1,:)%j)) * den(49)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(410),h0tab(:,410),[19,4,8],[nMW,nMW,nMW],3,1,wf8(:,41))
  call Hloop_TV_S(ntryL,G0H32(1),0,wf8(:,41),19,G1H4(184),m3h8x4(:,124),heltab2x32(:,:,410))
  Gcoeff(:)%j = (c(3)*M(1,:)%j) * den(51)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(411),h0tab(:,411),[19,4,8],[nMW,nMW,nMW],3,1,wf8(:,40))
  call Hloop_DV_C(ntryL,G0H32(1),0,wf8(:,40),G1H4(189),m3h8x4(:,125),heltab2x32(:,:,411))
  Gcoeff(:)%j = (c(3)*M(1,:)%j) * den(51)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(412),h0tab(:,412),[19,4,8],[nMW,nMW,nMW],3,1,wf8(:,40))
  call Hloop_CV_D(ntryL,G0H32(1),0,wf8(:,40),19,G1H4(190),m3h8x4(:,126),heltab2x32(:,:,412))
  Gcoeff(:)%j = (-(c(3)*M(1,:)%j)) * den(51)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(413),h0tab(:,413),[19,4,8],[nMW,nMW,nMW],3,1,wf8(:,40))
  call Hloop_DV_C(ntryL,G0H32(1),0,wf8(:,40),G1H4(20),m3h8x4(:,127),heltab2x32(:,:,413))
  Gcoeff(:)%j = (-(c(3)*M(1,:)%j)) * den(51)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(414),h0tab(:,414),[19,4,8],[nMW,nMW,nMW],3,1,wf8(:,40))
  call Hloop_CV_D(ntryL,G0H32(1),0,wf8(:,40),19,G1H4(26),m3h8x4(:,128),heltab2x32(:,:,414))
  Gcoeff(:)%j = (c(27)*M(1,:)%j) * den(49)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(415),h0tab(:,415),[19,4,8],[nMW,nMW,nMW],3,1,wf8(:,41))
  call Hloop_DV_C(ntryL,G0H32(1),0,wf8(:,41),G1H4(207),m3h8x4(:,129),heltab2x32(:,:,415))
  Gcoeff(:)%j = (c(27)*M(1,:)%j) * den(49)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(416),h0tab(:,416),[19,4,8],[nMW,nMW,nMW],3,1,wf8(:,41))
  call Hloop_CV_D(ntryL,G0H32(1),0,wf8(:,41),19,G1H4(208),m3h8x4(:,130),heltab2x32(:,:,416))
  Gcoeff(:)%j = (-(c(27)*M(1,:)%j)) * den(49)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(417),h0tab(:,417),[19,4,8],[nMW,nMW,nMW],3,1,wf8(:,41))
  call Hloop_DV_C(ntryL,G0H32(1),0,wf8(:,41),G1H4(213),m3h8x4(:,131),heltab2x32(:,:,417))
  Gcoeff(:)%j = (-(c(27)*M(1,:)%j)) * den(49)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(418),h0tab(:,418),[19,4,8],[nMW,nMW,nMW],3,1,wf8(:,41))
  call Hloop_CV_D(ntryL,G0H32(1),0,wf8(:,41),19,G1H4(214),m3h8x4(:,132),heltab2x32(:,:,418))
  Gcoeff(:)%j = (c(3)*M(1,:)%j) * den(51)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(419),h0tab(:,419),[19,4,8],[nMW,nMW,nMW],3,1,wf8(:,40))
  call Hloop_UW_V(ntryL,G0H32(1),0,wf8(:,40),19,G1H4(219),m3h8x4(:,133),heltab2x32(:,:,419))
  Gcoeff(:)%j = (c(3)*M(1,:)%j) * den(51)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(420),h0tab(:,420),[19,4,8],[nMW,nMW,nMW],3,1,wf8(:,40))
  call Hloop_UV_W(ntryL,G0H32(1),0,wf8(:,40),19,G1H4(220),m3h8x4(:,134),heltab2x32(:,:,420))
  Gcoeff(:)%j = (c(27)*M(1,:)%j) * den(49)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(421),h0tab(:,421),[19,4,8],[nMW,nMW,nMW],3,1,wf8(:,41))
  call Hloop_UW_V(ntryL,G0H32(1),0,wf8(:,41),19,G1H4(225),m3h8x4(:,135),heltab2x32(:,:,421))
  Gcoeff(:)%j = (c(27)*M(1,:)%j) * den(49)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(422),h0tab(:,422),[19,4,8],[nMW,nMW,nMW],3,1,wf8(:,41))
  call Hloop_UV_W(ntryL,G0H32(1),0,wf8(:,41),19,G1H4(226),m3h8x4(:,136),heltab2x32(:,:,422))
  Gcoeff(:)%j = (-(c(5)*M(1,:)%j)) * den(51)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(423),h0tab(:,423),[19,4,8],[nMW,nMW,nMW],3,1,wf8(:,40))
  call Hloop_VV_S(ntryL,G0H32(1),wf8(:,40),G0H4(41),m3h8x4(:,137),heltab2x32(:,:,423))
  Gcoeff(:)%j = (-(c(5)*M(1,:)%j)) * den(51)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(424),h0tab(:,424),[19,4,8],[nMW,nMW,nMW],3,1,wf8(:,40))
  call Hloop_VV_S(ntryL,G0H32(1),wf8(:,40),G0H4(42),m3h8x4(:,138),heltab2x32(:,:,424))
  Gcoeff(:)%j = (c(29)*M(1,:)%j) * den(49)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(425),h0tab(:,425),[19,4,8],[nMW,nMW,nMW],3,1,wf8(:,41))
  call Hloop_VV_S(ntryL,G0H32(1),wf8(:,41),G0H4(43),m3h8x4(:,139),heltab2x32(:,:,425))
  Gcoeff(:)%j = (c(29)*M(1,:)%j) * den(49)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(426),h0tab(:,426),[19,4,8],[nMW,nMW,nMW],3,1,wf8(:,41))
  call Hloop_VV_S(ntryL,G0H32(1),wf8(:,41),G0H4(44),m3h8x4(:,140),heltab2x32(:,:,426))
  Gcoeff(:)%j = (-(c(5)*M(1,:)%j)) * den(51)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(427),h0tab(:,427),[19,4,8],[nMW,nMW,nMW],3,1,wf8(:,40))
  call Hloop_SV_V(ntryL,G0H32(1),wf8(:,40),G0H4(45),m3h8x4(:,141),heltab2x32(:,:,427))
  Gcoeff(:)%j = (-(c(5)*M(1,:)%j)) * den(51)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(428),h0tab(:,428),[19,4,8],[nMW,nMW,nMW],3,1,wf8(:,40))
  call Hloop_SV_V(ntryL,G0H32(1),wf8(:,40),G0H4(46),m3h8x4(:,142),heltab2x32(:,:,428))
  Gcoeff(:)%j = (c(29)*M(1,:)%j) * den(49)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(429),h0tab(:,429),[19,4,8],[nMW,nMW,nMW],3,1,wf8(:,41))
  call Hloop_SV_V(ntryL,G0H32(1),wf8(:,41),G0H4(47),m3h8x4(:,143),heltab2x32(:,:,429))
  Gcoeff(:)%j = (c(29)*M(1,:)%j) * den(49)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(430),h0tab(:,430),[19,4,8],[nMW,nMW,nMW],3,1,wf8(:,41))
  call Hloop_SV_V(ntryL,G0H32(1),wf8(:,41),G0H4(48),m3h8x4(:,144),heltab2x32(:,:,430))
  Gcoeff(:)%j = (-(c(5)*M(1,:)%j)) * den(51)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(431),h0tab(:,431),[19,4,8],[nMW,nMW,nMW],3,1,wf8(:,40))
  call Hloop_SV_T(ntryL,G0H32(1),0,wf8(:,40),19,G1H4(231),m3h8x4(:,145),heltab2x32(:,:,431))
  Gcoeff(:)%j = (-(c(5)*M(1,:)%j)) * den(51)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(432),h0tab(:,432),[19,4,8],[nMW,nMW,nMW],3,1,wf8(:,40))
  call Hloop_TV_S(ntryL,G0H32(1),0,wf8(:,40),19,G1H4(232),m3h8x4(:,146),heltab2x32(:,:,432))
  Gcoeff(:)%j = (c(32)*M(1,:)%j) * den(49)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(433),h0tab(:,433),[19,4,8],[nMW,nMW,nMW],3,1,wf8(:,41))
  call Hloop_SV_T(ntryL,G0H32(1),0,wf8(:,41),19,G1H4(237),m3h8x4(:,147),heltab2x32(:,:,433))
  Gcoeff(:)%j = (c(32)*M(1,:)%j) * den(49)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(434),h0tab(:,434),[19,4,8],[nMW,nMW,nMW],3,1,wf8(:,41))
  call Hloop_TV_S(ntryL,G0H32(1),0,wf8(:,41),19,G1H4(238),m3h8x4(:,148),heltab2x32(:,:,434))
  Gcoeff(:)%j = (-(c(5)*M(1,:)%j)) * den(51)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(435),h0tab(:,435),[19,4,8],[nMW,nMW,nMW],3,1,wf8(:,40))
  call Hloop_UW_V(ntryL,G0H32(1),0,wf8(:,40),19,G1H4(32),m3h8x4(:,149),heltab2x32(:,:,435))
  Gcoeff(:)%j = (-(c(5)*M(1,:)%j)) * den(51)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(436),h0tab(:,436),[19,4,8],[nMW,nMW,nMW],3,1,wf8(:,40))
  call Hloop_UV_W(ntryL,G0H32(1),0,wf8(:,40),19,G1H4(38),m3h8x4(:,150),heltab2x32(:,:,436))
  Gcoeff(:)%j = (-(c(28)*M(1,:)%j)) * den(49)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(437),h0tab(:,437),[19,4,8],[nMW,nMW,nMW],3,1,wf8(:,41))
  call Hloop_UW_V(ntryL,G0H32(1),0,wf8(:,41),19,G1H4(41),m3h8x4(:,151),heltab2x32(:,:,437))
  Gcoeff(:)%j = (-(c(28)*M(1,:)%j)) * den(49)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(438),h0tab(:,438),[19,4,8],[nMW,nMW,nMW],3,1,wf8(:,41))
  call Hloop_UV_W(ntryL,G0H32(1),0,wf8(:,41),19,G1H4(42),m3h8x4(:,152),heltab2x32(:,:,438))
  Gcoeff(:)%j = (-(c(5)*M(1,:)%j)) * den(51)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(439),h0tab(:,439),[19,4,8],[nMW,nMW,nMW],3,1,wf8(:,40))
  call Hloop_VV_S(ntryL,G0H32(1),wf8(:,40),G0H4(49),m3h8x4(:,153),heltab2x32(:,:,439))
  Gcoeff(:)%j = (-(c(5)*M(1,:)%j)) * den(51)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(440),h0tab(:,440),[19,4,8],[nMW,nMW,nMW],3,1,wf8(:,40))
  call Hloop_VV_S(ntryL,G0H32(1),wf8(:,40),G0H4(50),m3h8x4(:,154),heltab2x32(:,:,440))
  Gcoeff(:)%j = (c(29)*M(1,:)%j) * den(49)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(441),h0tab(:,441),[19,4,8],[nMW,nMW,nMW],3,1,wf8(:,41))
  call Hloop_VV_S(ntryL,G0H32(1),wf8(:,41),G0H4(51),m3h8x4(:,155),heltab2x32(:,:,441))
  Gcoeff(:)%j = (c(29)*M(1,:)%j) * den(49)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(442),h0tab(:,442),[19,4,8],[nMW,nMW,nMW],3,1,wf8(:,41))
  call Hloop_VV_S(ntryL,G0H32(1),wf8(:,41),G0H4(52),m3h8x4(:,156),heltab2x32(:,:,442))
  Gcoeff(:)%j = (-(c(5)*M(1,:)%j)) * den(51)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(443),h0tab(:,443),[19,4,8],[nMW,nMW,nMW],3,1,wf8(:,40))
  call Hloop_SV_V(ntryL,G0H32(1),wf8(:,40),G0H4(53),m3h8x4(:,157),heltab2x32(:,:,443))
  Gcoeff(:)%j = (-(c(5)*M(1,:)%j)) * den(51)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(444),h0tab(:,444),[19,4,8],[nMW,nMW,nMW],3,1,wf8(:,40))
  call Hloop_SV_V(ntryL,G0H32(1),wf8(:,40),G0H4(54),m3h8x4(:,158),heltab2x32(:,:,444))
  Gcoeff(:)%j = (c(29)*M(1,:)%j) * den(49)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(445),h0tab(:,445),[19,4,8],[nMW,nMW,nMW],3,1,wf8(:,41))
  call Hloop_SV_V(ntryL,G0H32(1),wf8(:,41),G0H4(55),m3h8x4(:,159),heltab2x32(:,:,445))
  Gcoeff(:)%j = (c(29)*M(1,:)%j) * den(49)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(446),h0tab(:,446),[19,4,8],[nMW,nMW,nMW],3,1,wf8(:,41))
  call Hloop_SV_V(ntryL,G0H32(1),wf8(:,41),G0H4(56),m3h8x4(:,160),heltab2x32(:,:,446))
  Gcoeff(:)%j = (-(c(24)*M(1,:)%j)) * den(44)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(447),h0tab(:,447),[21,2,8],[nMH,nMT,nMT],3,1,wf8(:,38))
  call Hloop_AQ_S(ntryL,G0H32(1),wf8(:,38),G0H4(57),ngH,m3h8x4(:,161),heltab2x32(:,:,447))
  Gcoeff(:)%j = (c(24)*M(1,:)%j) * den(44)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(448),h0tab(:,448),[21,2,8],[nMZ,nMT,nMT],3,1,wf8(:,38))
  call Hloop_AQ_S(ntryL,G0H32(1),wf8(:,38),G0H4(58),ngX,m3h8x4(:,162),heltab2x32(:,:,448))
  Gcoeff(:)%j = (-(c(16)*M(1,:)%j)) * den(44)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(449),h0tab(:,449),[21,2,8],[nMW,nMB,nMB],3,1,wf8(:,38))
  call Hloop_AQ_S(ntryL,G0H32(1),wf8(:,38),G0H4(59),ngPbt,m3h8x4(:,163),heltab2x32(:,:,449))
  Gcoeff(:)%j = (c(19)*M(1,:)%j) * den(44)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(450),h0tab(:,450),[21,2,8],[nMB,nMW,nMW],3,1,wf8(:,38))
  call Hloop_SQ_A(ntryL,G0H32(1),wf8(:,38),G0H4(60),ngPbt,m3h8x4(:,164),heltab2x32(:,:,450))
  call Hloop_Q_A(ntryL,G0H4(60),21,nMB,G1H4(43),n2h4(161))
  Gcoeff(:)%j = (c(1)*M(1,:)%j) * den(44)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(451),h0tab(:,451),[21,2,8],[0,nMT,nMT],3,1,wf8(:,38))
  call Hloop_AQ_V(ntryL,G0H32(1),wf8(:,38),G0H4(60),m3h8x4(:,165),heltab2x32(:,:,451))
  Gcoeff(:)%j = (c(2)*M(1,:)%j) * den(44)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(452),h0tab(:,452),[21,2,8],[nMZ,nMT,nMT],3,1,wf8(:,38))
  call Hloop_AQ_Z(ntryL,G0H32(1),wf8(:,38),G0H4(61),ngZu,m3h8x4(:,166),heltab2x32(:,:,452))
  Gcoeff(:)%j = (-(c(7)*M(1,:)%j)) * den(44)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(453),h0tab(:,453),[21,2,8],[nMW,nMB,nMB],3,1,wf8(:,38))
  call Hloop_AQ_W(ntryL,G0H32(1),wf8(:,38),G0H4(62),m3h8x4(:,167),heltab2x32(:,:,453))
  Gcoeff(:)%j = (c(10)*M(1,:)%j) * den(44)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(454),h0tab(:,454),[21,2,8],[nMB,nMW,nMW],3,1,wf8(:,38))
  call Hloop_WQ_A(ntryL,G0H32(1),wf8(:,38),G0H4(63),m3h8x4(:,168),heltab2x32(:,:,454))
  call Hloop_Q_A(ntryL,G0H4(63),21,nMB,G1H4(44),n2h4(162))
  Gcoeff(:)%j = (-(c(10)*M(1,:)%j)) * den(44)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(455),h0tab(:,455),[21,2,8],[nMB,nMW,nMW],3,1,wf8(:,38))
  call Hloop_SQ_A(ntryL,G0H32(1),wf8(:,38),G0H4(63),ngPbt,m3h8x4(:,169),heltab2x32(:,:,455))
  call Hloop_Q_A(ntryL,G0H4(63),21,nMB,G1H4(47),n2h4(163))
  Gcoeff(:)%j = (c(10)*M(1,:)%j) * den(44)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(456),h0tab(:,456),[21,2,8],[nMB,nMW,nMW],3,1,wf8(:,38))
  call Hloop_WQ_A(ntryL,G0H32(1),wf8(:,38),G0H4(63),m3h8x4(:,170),heltab2x32(:,:,456))
  call Hloop_Q_A(ntryL,G0H4(63),21,nMB,G1H4(48),n2h4(164))
  Gcoeff(:)%j = (-(c(24)*M(1,:)%j)) * den(36)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(457),h0tab(:,457),[25,2,4],[nMH,nMT,nMT],3,1,wf8(:,32))
  call Hloop_AQ_S(ntryL,G0H32(1),wf8(:,32),G0H4(63),ngH,m3h8x4(:,171),heltab2x32(:,:,457))
  Gcoeff(:)%j = (c(24)*M(1,:)%j) * den(36)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(458),h0tab(:,458),[25,2,4],[nMZ,nMT,nMT],3,1,wf8(:,32))
  call Hloop_AQ_S(ntryL,G0H32(1),wf8(:,32),G0H4(64),ngX,m3h8x4(:,172),heltab2x32(:,:,458))
  Gcoeff(:)%j = (-(c(16)*M(1,:)%j)) * den(36)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(459),h0tab(:,459),[25,2,4],[nMW,nMB,nMB],3,1,wf8(:,32))
  call Hloop_AQ_S(ntryL,G0H32(1),wf8(:,32),G0H4(65),ngPbt,m3h8x4(:,173),heltab2x32(:,:,459))
  Gcoeff(:)%j = (c(19)*M(1,:)%j) * den(36)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(460),h0tab(:,460),[25,2,4],[nMB,nMW,nMW],3,1,wf8(:,32))
  call Hloop_SQ_A(ntryL,G0H32(1),wf8(:,32),G0H4(66),ngPbt,m3h8x4(:,174),heltab2x32(:,:,460))
  call Hloop_Q_A(ntryL,G0H4(66),25,nMB,G1H4(54),n2h4(165))
  Gcoeff(:)%j = (c(1)*M(1,:)%j) * den(36)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(461),h0tab(:,461),[25,2,4],[0,nMT,nMT],3,1,wf8(:,32))
  call Hloop_AQ_V(ntryL,G0H32(1),wf8(:,32),G0H4(66),m3h8x4(:,175),heltab2x32(:,:,461))
  Gcoeff(:)%j = (c(2)*M(1,:)%j) * den(36)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(462),h0tab(:,462),[25,2,4],[nMZ,nMT,nMT],3,1,wf8(:,32))
  call Hloop_AQ_Z(ntryL,G0H32(1),wf8(:,32),G0H4(67),ngZu,m3h8x4(:,176),heltab2x32(:,:,462))
  Gcoeff(:)%j = (-(c(7)*M(1,:)%j)) * den(36)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(463),h0tab(:,463),[25,2,4],[nMW,nMB,nMB],3,1,wf8(:,32))
  call Hloop_AQ_W(ntryL,G0H32(1),wf8(:,32),G0H4(68),m3h8x4(:,177),heltab2x32(:,:,463))
  Gcoeff(:)%j = (c(10)*M(1,:)%j) * den(36)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(464),h0tab(:,464),[25,2,4],[nMB,nMW,nMW],3,1,wf8(:,32))
  call Hloop_WQ_A(ntryL,G0H32(1),wf8(:,32),G0H4(69),m3h8x4(:,178),heltab2x32(:,:,464))
  call Hloop_Q_A(ntryL,G0H4(69),25,nMB,G1H4(60),n2h4(166))
  Gcoeff(:)%j = (-(c(10)*M(1,:)%j)) * den(36)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(465),h0tab(:,465),[25,2,4],[nMB,nMW,nMW],3,1,wf8(:,32))
  call Hloop_SQ_A(ntryL,G0H32(1),wf8(:,32),G0H4(69),ngPbt,m3h8x4(:,179),heltab2x32(:,:,465))
  call Hloop_Q_A(ntryL,G0H4(69),25,nMB,G1H4(61),n2h4(167))
  Gcoeff(:)%j = (c(10)*M(1,:)%j) * den(36)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(466),h0tab(:,466),[25,2,4],[nMB,nMW,nMW],3,1,wf8(:,32))
  call Hloop_WQ_A(ntryL,G0H32(1),wf8(:,32),G0H4(69),m3h8x4(:,180),heltab2x32(:,:,466))
  call Hloop_Q_A(ntryL,G0H4(69),25,nMB,G1H4(62),n2h4(168))
  Gcoeff(:)%j = (c(44)*M(1,:)%j) * den(52)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(467),h0tab(:,467),[19,4,8],[nME,nME,nME],3,1,wf8(:,14))
  call Hloop_AS_Q(ntryL,G0H32(1),wf8(:,14),G0H4(69),ngH,m3h8x4(:,181),heltab2x32(:,:,467))
  call Hloop_A_Q(ntryL,G0H4(69),19,nME,G1H4(65),n2h4(169))
  Gcoeff(:)%j = (c(46)*M(1,:)%j) * den(52)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(468),h0tab(:,468),[19,4,8],[nMM,nMM,nMM],3,1,wf8(:,14))
  call Hloop_AS_Q(ntryL,G0H32(1),wf8(:,14),G0H4(69),ngH,m3h8x4(:,182),heltab2x32(:,:,468))
  call Hloop_A_Q(ntryL,G0H4(69),19,nMM,G1H4(66),n2h4(170))
  Gcoeff(:)%j = (c(45)*M(1,:)%j) * den(52)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(469),h0tab(:,469),[19,4,8],[nML,nML,nML],3,1,wf8(:,14))
  call Hloop_AS_Q(ntryL,G0H32(1),wf8(:,14),G0H4(69),ngH,m3h8x4(:,183),heltab2x32(:,:,469))
  call Hloop_A_Q(ntryL,G0H4(69),19,nML,G1H4(67),n2h4(171))
  Gcoeff(:)%j = (c(44)*M(1,:)%j) * den(52)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(470),h0tab(:,470),[19,4,8],[nME,nME,nME],3,1,wf8(:,14))
  call Hloop_QS_A(ntryL,G0H32(1),wf8(:,14),G0H4(69),ngH,m3h8x4(:,184),heltab2x32(:,:,470))
  call Hloop_Q_A(ntryL,G0H4(69),19,nME,G1H4(68),n2h4(172))
  Gcoeff(:)%j = (c(46)*M(1,:)%j) * den(52)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(471),h0tab(:,471),[19,4,8],[nMM,nMM,nMM],3,1,wf8(:,14))
  call Hloop_QS_A(ntryL,G0H32(1),wf8(:,14),G0H4(69),ngH,m3h8x4(:,185),heltab2x32(:,:,471))
  call Hloop_Q_A(ntryL,G0H4(69),19,nMM,G1H4(84),n2h4(173))
  Gcoeff(:)%j = (c(45)*M(1,:)%j) * den(52)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(472),h0tab(:,472),[19,4,8],[nML,nML,nML],3,1,wf8(:,14))
  call Hloop_QS_A(ntryL,G0H32(1),wf8(:,14),G0H4(69),ngH,m3h8x4(:,186),heltab2x32(:,:,472))
  call Hloop_Q_A(ntryL,G0H4(69),19,nML,G1H4(90),n2h4(174))
  Gcoeff(:)%j = (c(47)*M(1,:)%j) * den(52)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(473),h0tab(:,473),[19,4,8],[nMT,nMT,nMT],3,1,wf8(:,14))
  call Hloop_AS_Q(ntryL,G0H32(1),wf8(:,14),G0H4(69),ngH,m3h8x4(:,187),heltab2x32(:,:,473))
  call Hloop_A_Q(ntryL,G0H4(69),19,nMT,G1H4(91),n2h4(175))
  Gcoeff(:)%j = (c(47)*M(1,:)%j) * den(52)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(474),h0tab(:,474),[19,4,8],[nMT,nMT,nMT],3,1,wf8(:,14))
  call Hloop_QS_A(ntryL,G0H32(1),wf8(:,14),G0H4(69),ngH,m3h8x4(:,188),heltab2x32(:,:,474))
  call Hloop_Q_A(ntryL,G0H4(69),19,nMT,G1H4(92),n2h4(176))
  Gcoeff(:)%j = (c(43)*M(1,:)%j) * den(52)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(475),h0tab(:,475),[19,4,8],[nMB,nMB,nMB],3,1,wf8(:,14))
  call Hloop_AS_Q(ntryL,G0H32(1),wf8(:,14),G0H4(69),ngH,m3h8x4(:,189),heltab2x32(:,:,475))
  call Hloop_A_Q(ntryL,G0H4(69),19,nMB,G1H4(95),n2h4(177))
  Gcoeff(:)%j = (c(43)*M(1,:)%j) * den(52)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(476),h0tab(:,476),[19,4,8],[nMB,nMB,nMB],3,1,wf8(:,14))
  call Hloop_QS_A(ntryL,G0H32(1),wf8(:,14),G0H4(69),ngH,m3h8x4(:,190),heltab2x32(:,:,476))
  call Hloop_Q_A(ntryL,G0H4(69),19,nMB,G1H4(96),n2h4(178))
  Gcoeff(:)%j = (c(44)*M(1,:)%j) * den(53)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(477),h0tab(:,477),[19,4,8],[nME,nME,nME],3,1,wf8(:,42))
  call Hloop_AS_Q(ntryL,G0H32(1),wf8(:,42),G0H4(69),ngX,m3h8x4(:,191),heltab2x32(:,:,477))
  call Hloop_A_Q(ntryL,G0H4(69),19,nME,G1H4(97),n2h4(179))
  Gcoeff(:)%j = (c(46)*M(1,:)%j) * den(53)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(478),h0tab(:,478),[19,4,8],[nMM,nMM,nMM],3,1,wf8(:,42))
  call Hloop_AS_Q(ntryL,G0H32(1),wf8(:,42),G0H4(69),ngX,m3h8x4(:,192),heltab2x32(:,:,478))
  call Hloop_A_Q(ntryL,G0H4(69),19,nMM,G1H4(98),n2h4(180))
  Gcoeff(:)%j = (c(45)*M(1,:)%j) * den(53)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(479),h0tab(:,479),[19,4,8],[nML,nML,nML],3,1,wf8(:,42))
  call Hloop_AS_Q(ntryL,G0H32(1),wf8(:,42),G0H4(69),ngX,m3h8x4(:,193),heltab2x32(:,:,479))
  call Hloop_A_Q(ntryL,G0H4(69),19,nML,G1H4(104),n2h4(181))
  Gcoeff(:)%j = (c(44)*M(1,:)%j) * den(53)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(480),h0tab(:,480),[19,4,8],[nME,nME,nME],3,1,wf8(:,42))
  call Hloop_QS_A(ntryL,G0H32(1),wf8(:,42),G0H4(69),ngX,m3h8x4(:,194),heltab2x32(:,:,480))
  call Hloop_Q_A(ntryL,G0H4(69),19,nME,G1H4(110),n2h4(182))
  Gcoeff(:)%j = (c(46)*M(1,:)%j) * den(53)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(481),h0tab(:,481),[19,4,8],[nMM,nMM,nMM],3,1,wf8(:,42))
  call Hloop_QS_A(ntryL,G0H32(1),wf8(:,42),G0H4(69),ngX,m3h8x4(:,195),heltab2x32(:,:,481))
  call Hloop_Q_A(ntryL,G0H4(69),19,nMM,G1H4(113),n2h4(183))
  Gcoeff(:)%j = (c(45)*M(1,:)%j) * den(53)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(482),h0tab(:,482),[19,4,8],[nML,nML,nML],3,1,wf8(:,42))
  call Hloop_QS_A(ntryL,G0H32(1),wf8(:,42),G0H4(69),ngX,m3h8x4(:,196),heltab2x32(:,:,482))
  call Hloop_Q_A(ntryL,G0H4(69),19,nML,G1H4(114),n2h4(184))
  Gcoeff(:)%j = (-(c(47)*M(1,:)%j)) * den(53)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(483),h0tab(:,483),[19,4,8],[nMT,nMT,nMT],3,1,wf8(:,42))
  call Hloop_AS_Q(ntryL,G0H32(1),wf8(:,42),G0H4(69),ngX,m3h8x4(:,197),heltab2x32(:,:,483))
  call Hloop_A_Q(ntryL,G0H4(69),19,nMT,G1H4(115),n2h4(185))
  Gcoeff(:)%j = (-(c(47)*M(1,:)%j)) * den(53)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(484),h0tab(:,484),[19,4,8],[nMT,nMT,nMT],3,1,wf8(:,42))
  call Hloop_QS_A(ntryL,G0H32(1),wf8(:,42),G0H4(69),ngX,m3h8x4(:,198),heltab2x32(:,:,484))
  call Hloop_Q_A(ntryL,G0H4(69),19,nMT,G1H4(116),n2h4(186))
  Gcoeff(:)%j = (c(43)*M(1,:)%j) * den(53)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(485),h0tab(:,485),[19,4,8],[nMB,nMB,nMB],3,1,wf8(:,42))
  call Hloop_AS_Q(ntryL,G0H32(1),wf8(:,42),G0H4(69),ngX,m3h8x4(:,199),heltab2x32(:,:,485))
  call Hloop_A_Q(ntryL,G0H4(69),19,nMB,G1H4(119),n2h4(187))
  Gcoeff(:)%j = (c(43)*M(1,:)%j) * den(53)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(486),h0tab(:,486),[19,4,8],[nMB,nMB,nMB],3,1,wf8(:,42))
  call Hloop_QS_A(ntryL,G0H32(1),wf8(:,42),G0H4(69),ngX,m3h8x4(:,200),heltab2x32(:,:,486))
  call Hloop_Q_A(ntryL,G0H4(69),19,nMB,G1H4(120),n2h4(188))
  Gcoeff(:)%j = (-(c(22)*M(1,:)%j)) * den(52)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(487),h0tab(:,487),[19,4,8],[nMW,nMW,nMW],3,1,wf8(:,14))
  call Hloop_SS_S(ntryL,G0H32(1),wf8(:,14),G0H4(69),m3h8x4(:,201),heltab2x32(:,:,487))
  Gcoeff(:)%j = (-(c(22)*M(1,:)%j)) * den(52)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(488),h0tab(:,488),[19,4,8],[nMW,nMW,nMW],3,1,wf8(:,14))
  call Hloop_SS_S(ntryL,G0H32(1),wf8(:,14),G0H4(70),m3h8x4(:,202),heltab2x32(:,:,488))
  Gcoeff(:)%j = (c(12)*M(1,:)%j) * den(52)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(489),h0tab(:,489),[19,4,8],[nMW,nMW,nMW],3,1,wf8(:,14))
  call Hloop_SS_S(ntryL,G0H32(1),wf8(:,14),G0H4(71),m3h8x4(:,203),heltab2x32(:,:,489))
  Gcoeff(:)%j = (c(12)*M(1,:)%j) * den(52)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(490),h0tab(:,490),[19,4,8],[nMW,nMW,nMW],3,1,wf8(:,14))
  call Hloop_SS_S(ntryL,G0H32(1),wf8(:,14),G0H4(72),m3h8x4(:,204),heltab2x32(:,:,490))
  Gcoeff(:)%j = (c(12)*M(1,:)%j) * den(52)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(491),h0tab(:,491),[19,4,8],[nMW,nMW,nMW],3,1,wf8(:,14))
  call Hloop_SS_S(ntryL,G0H32(1),wf8(:,14),G0H4(73),m3h8x4(:,205),heltab2x32(:,:,491))
  Gcoeff(:)%j = (c(12)*M(1,:)%j) * den(52)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(492),h0tab(:,492),[19,4,8],[nMW,nMW,nMW],3,1,wf8(:,14))
  call Hloop_SS_S(ntryL,G0H32(1),wf8(:,14),G0H4(74),m3h8x4(:,206),heltab2x32(:,:,492))
  Gcoeff(:)%j = (c(12)*M(1,:)%j) * den(53)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(493),h0tab(:,493),[19,4,8],[nMW,nMW,nMW],3,1,wf8(:,42))
  call Hloop_SS_S(ntryL,G0H32(1),wf8(:,42),G0H4(75),m3h8x4(:,207),heltab2x32(:,:,493))
  Gcoeff(:)%j = (c(12)*M(1,:)%j) * den(53)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(494),h0tab(:,494),[19,4,8],[nMW,nMW,nMW],3,1,wf8(:,42))
  call Hloop_SS_S(ntryL,G0H32(1),wf8(:,42),G0H4(76),m3h8x4(:,208),heltab2x32(:,:,494))
  Gcoeff(:)%j = (-(c(12)*M(1,:)%j)) * den(53)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(495),h0tab(:,495),[19,4,8],[nMW,nMW,nMW],3,1,wf8(:,42))
  call Hloop_SS_S(ntryL,G0H32(1),wf8(:,42),G0H4(77),m3h8x4(:,209),heltab2x32(:,:,495))
  Gcoeff(:)%j = (-(c(12)*M(1,:)%j)) * den(53)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(496),h0tab(:,496),[19,4,8],[nMW,nMW,nMW],3,1,wf8(:,42))
  call Hloop_SS_S(ntryL,G0H32(1),wf8(:,42),G0H4(78),m3h8x4(:,210),heltab2x32(:,:,496))
  Gcoeff(:)%j = (-(c(13)*M(1,:)%j)) * den(52)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(497),h0tab(:,497),[19,4,8],[nMW,nMW,nMW],3,1,wf8(:,14))
  call Hloop_VS_V(ntryL,G0H32(1),wf8(:,14),G0H4(79),m3h8x4(:,211),heltab2x32(:,:,497))
  Gcoeff(:)%j = (-(c(13)*M(1,:)%j)) * den(52)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(498),h0tab(:,498),[19,4,8],[nMW,nMW,nMW],3,1,wf8(:,14))
  call Hloop_VS_V(ntryL,G0H32(1),wf8(:,14),G0H4(80),m3h8x4(:,212),heltab2x32(:,:,498))
  Gcoeff(:)%j = (c(12)*M(1,:)%j) * den(52)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(499),h0tab(:,499),[19,4,8],[nMW,nMW,nMW],3,1,wf8(:,14))
  call Hloop_VT_S(ntryL,G0H32(1),0,wf8(:,14),19,G1H4(122),m3h8x4(:,213),heltab2x32(:,:,499))
  Gcoeff(:)%j = (-(c(12)*M(1,:)%j)) * den(52)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(500),h0tab(:,500),[19,4,8],[nMW,nMW,nMW],3,1,wf8(:,14))
  call Hloop_VT_S(ntryL,G0H32(1),0,wf8(:,14),19,G1H4(121),m3h8x4(:,214),heltab2x32(:,:,500))
  Gcoeff(:)%j = (-(c(12)*M(1,:)%j)) * den(53)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(501),h0tab(:,501),[19,4,8],[nMW,nMW,nMW],3,1,wf8(:,42))
  call Hloop_VT_S(ntryL,G0H32(1),0,wf8(:,42),19,G1H4(126),m3h8x4(:,215),heltab2x32(:,:,501))
  Gcoeff(:)%j = (-(c(12)*M(1,:)%j)) * den(53)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(502),h0tab(:,502),[19,4,8],[nMW,nMW,nMW],3,1,wf8(:,42))
  call Hloop_VT_S(ntryL,G0H32(1),0,wf8(:,42),19,G1H4(125),m3h8x4(:,216),heltab2x32(:,:,502))
  Gcoeff(:)%j = (-(c(12)*M(1,:)%j)) * den(52)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(503),h0tab(:,503),[19,4,8],[nMW,nMW,nMW],3,1,wf8(:,14))
  call Hloop_ST_V(ntryL,G0H32(1),0,wf8(:,14),19,G1H4(128),m3h8x4(:,217),heltab2x32(:,:,503))
  Gcoeff(:)%j = (c(12)*M(1,:)%j) * den(52)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(504),h0tab(:,504),[19,4,8],[nMW,nMW,nMW],3,1,wf8(:,14))
  call Hloop_ST_V(ntryL,G0H32(1),0,wf8(:,14),19,G1H4(127),m3h8x4(:,218),heltab2x32(:,:,504))
  Gcoeff(:)%j = (-(c(12)*M(1,:)%j)) * den(53)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(505),h0tab(:,505),[19,4,8],[nMW,nMW,nMW],3,1,wf8(:,42))
  call Hloop_ST_V(ntryL,G0H32(1),0,wf8(:,42),19,G1H4(132),m3h8x4(:,219),heltab2x32(:,:,505))
  Gcoeff(:)%j = (-(c(12)*M(1,:)%j)) * den(53)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(506),h0tab(:,506),[19,4,8],[nMW,nMW,nMW],3,1,wf8(:,42))
  call Hloop_ST_V(ntryL,G0H32(1),0,wf8(:,42),19,G1H4(131),m3h8x4(:,220),heltab2x32(:,:,506))
  Gcoeff(:)%j = (c(14)*M(1,:)%j) * den(52)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(507),h0tab(:,507),[19,4,8],[nMW,nMW,nMW],3,1,wf8(:,14))
  call Hloop_SS_S(ntryL,G0H32(1),wf8(:,14),G0H4(81),m3h8x4(:,221),heltab2x32(:,:,507))
  Gcoeff(:)%j = (c(14)*M(1,:)%j) * den(52)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(508),h0tab(:,508),[19,4,8],[nMW,nMW,nMW],3,1,wf8(:,14))
  call Hloop_SS_S(ntryL,G0H32(1),wf8(:,14),G0H4(82),m3h8x4(:,222),heltab2x32(:,:,508))
  Gcoeff(:)%j = (c(26)*M(1,:)%j) * den(52)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(509),h0tab(:,509),[19,4,8],[nMW,nMW,nMW],3,1,wf8(:,14))
  call Hloop_VS_V(ntryL,G0H32(1),wf8(:,14),G0H4(83),m3h8x4(:,223),heltab2x32(:,:,509))
  Gcoeff(:)%j = (c(26)*M(1,:)%j) * den(52)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(510),h0tab(:,510),[19,4,8],[nMW,nMW,nMW],3,1,wf8(:,14))
  call Hloop_VS_V(ntryL,G0H32(1),wf8(:,14),G0H4(84),m3h8x4(:,224),heltab2x32(:,:,510))
  Gcoeff(:)%j = (c(12)*M(1,:)%j) * den(52)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(511),h0tab(:,511),[19,4,8],[nMW,nMW,nMW],3,1,wf8(:,14))
  call Hloop_VT_S(ntryL,G0H32(1),0,wf8(:,14),19,G1H4(133),m3h8x4(:,225),heltab2x32(:,:,511))
  Gcoeff(:)%j = (-(c(12)*M(1,:)%j)) * den(52)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(512),h0tab(:,512),[19,4,8],[nMW,nMW,nMW],3,1,wf8(:,14))
  call Hloop_VT_S(ntryL,G0H32(1),0,wf8(:,14),19,G1H4(134),m3h8x4(:,226),heltab2x32(:,:,512))
  Gcoeff(:)%j = (-(c(12)*M(1,:)%j)) * den(53)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(513),h0tab(:,513),[19,4,8],[nMW,nMW,nMW],3,1,wf8(:,42))
  call Hloop_VT_S(ntryL,G0H32(1),0,wf8(:,42),19,G1H4(139),m3h8x4(:,227),heltab2x32(:,:,513))
  Gcoeff(:)%j = (-(c(12)*M(1,:)%j)) * den(53)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(514),h0tab(:,514),[19,4,8],[nMW,nMW,nMW],3,1,wf8(:,42))
  call Hloop_VT_S(ntryL,G0H32(1),0,wf8(:,42),19,G1H4(140),m3h8x4(:,228),heltab2x32(:,:,514))
  Gcoeff(:)%j = (-(c(12)*M(1,:)%j)) * den(52)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(515),h0tab(:,515),[19,4,8],[nMW,nMW,nMW],3,1,wf8(:,14))
  call Hloop_ST_V(ntryL,G0H32(1),0,wf8(:,14),19,G1H4(143),m3h8x4(:,229),heltab2x32(:,:,515))
  Gcoeff(:)%j = (c(12)*M(1,:)%j) * den(52)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(516),h0tab(:,516),[19,4,8],[nMW,nMW,nMW],3,1,wf8(:,14))
  call Hloop_ST_V(ntryL,G0H32(1),0,wf8(:,14),19,G1H4(146),m3h8x4(:,230),heltab2x32(:,:,516))
  Gcoeff(:)%j = (-(c(12)*M(1,:)%j)) * den(53)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(517),h0tab(:,517),[19,4,8],[nMW,nMW,nMW],3,1,wf8(:,42))
  call Hloop_ST_V(ntryL,G0H32(1),0,wf8(:,42),19,G1H4(149),m3h8x4(:,231),heltab2x32(:,:,517))
  Gcoeff(:)%j = (-(c(12)*M(1,:)%j)) * den(53)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(518),h0tab(:,518),[19,4,8],[nMW,nMW,nMW],3,1,wf8(:,42))
  call Hloop_ST_V(ntryL,G0H32(1),0,wf8(:,42),19,G1H4(150),m3h8x4(:,232),heltab2x32(:,:,518))
  Gcoeff(:)%j = (c(40)*M(1,:)%j) * den(54)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(519),h0tab(:,519),[19,4,8],[nME,nME,nME],3,1,wf8(:,43))
  call Hloop_AV_Q(ntryL,G0H32(1),wf8(:,43),G0H4(85),m3h8x4(:,233),heltab2x32(:,:,519))
  call Hloop_A_Q(ntryL,G0H4(85),19,nME,G1H4(155),n2h4(189))
  Gcoeff(:)%j = (c(40)*M(1,:)%j) * den(54)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(520),h0tab(:,520),[19,4,8],[nMM,nMM,nMM],3,1,wf8(:,43))
  call Hloop_AV_Q(ntryL,G0H32(1),wf8(:,43),G0H4(85),m3h8x4(:,234),heltab2x32(:,:,520))
  call Hloop_A_Q(ntryL,G0H4(85),19,nMM,G1H4(156),n2h4(190))
  Gcoeff(:)%j = (c(40)*M(1,:)%j) * den(54)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(521),h0tab(:,521),[19,4,8],[nML,nML,nML],3,1,wf8(:,43))
  call Hloop_AV_Q(ntryL,G0H32(1),wf8(:,43),G0H4(85),m3h8x4(:,235),heltab2x32(:,:,521))
  call Hloop_A_Q(ntryL,G0H4(85),19,nML,G1H4(157),n2h4(191))
  Gcoeff(:)%j = (c(40)*M(1,:)%j) * den(54)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(522),h0tab(:,522),[19,4,8],[nME,nME,nME],3,1,wf8(:,43))
  call Hloop_QV_A(ntryL,G0H32(1),wf8(:,43),G0H4(85),m3h8x4(:,236),heltab2x32(:,:,522))
  call Hloop_Q_A(ntryL,G0H4(85),19,nME,G1H4(162),n2h4(192))
  Gcoeff(:)%j = (c(40)*M(1,:)%j) * den(54)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(523),h0tab(:,523),[19,4,8],[nMM,nMM,nMM],3,1,wf8(:,43))
  call Hloop_QV_A(ntryL,G0H32(1),wf8(:,43),G0H4(85),m3h8x4(:,237),heltab2x32(:,:,523))
  call Hloop_Q_A(ntryL,G0H4(85),19,nMM,G1H4(163),n2h4(193))
  Gcoeff(:)%j = (c(40)*M(1,:)%j) * den(54)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(524),h0tab(:,524),[19,4,8],[nML,nML,nML],3,1,wf8(:,43))
  call Hloop_QV_A(ntryL,G0H32(1),wf8(:,43),G0H4(85),m3h8x4(:,238),heltab2x32(:,:,524))
  call Hloop_Q_A(ntryL,G0H4(85),19,nML,G1H4(164),n2h4(194))
  Gcoeff(:)%j = (-(c(38)*M(1,:)%j)) * den(54)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(525),h0tab(:,525),[19,4,8],[0,0,0],3,1,wf8(:,43))
  call Hloop_AV_Q(ntryL,G0H32(1),wf8(:,43),G0H4(85),m3h8x4(:,239),heltab2x32(:,:,525))
  call Hloop_A_Q(ntryL,G0H4(85),19,0,G1H4(169),n2h4(195))
  Gcoeff(:)%j = (-(c(36)*M(1,:)%j)) * den(54)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(526),h0tab(:,526),[19,4,8],[nMT,nMT,nMT],3,1,wf8(:,43))
  call Hloop_AV_Q(ntryL,G0H32(1),wf8(:,43),G0H4(85),m3h8x4(:,240),heltab2x32(:,:,526))
  call Hloop_A_Q(ntryL,G0H4(85),19,nMT,G1H4(170),n2h4(196))
  Gcoeff(:)%j = (-(c(38)*M(1,:)%j)) * den(54)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(527),h0tab(:,527),[19,4,8],[0,0,0],3,1,wf8(:,43))
  call Hloop_QV_A(ntryL,G0H32(1),wf8(:,43),G0H4(85),m3h8x4(:,241),heltab2x32(:,:,527))
  call Hloop_Q_A(ntryL,G0H4(85),19,0,G1H4(173),n2h4(197))
  Gcoeff(:)%j = (-(c(36)*M(1,:)%j)) * den(54)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(528),h0tab(:,528),[19,4,8],[nMT,nMT,nMT],3,1,wf8(:,43))
  call Hloop_QV_A(ntryL,G0H32(1),wf8(:,43),G0H4(85),m3h8x4(:,242),heltab2x32(:,:,528))
  call Hloop_Q_A(ntryL,G0H4(85),19,nMT,G1H4(176),n2h4(198))
  Gcoeff(:)%j = (c(34)*M(1,:)%j) * den(54)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(529),h0tab(:,529),[19,4,8],[0,0,0],3,1,wf8(:,43))
  call Hloop_AV_Q(ntryL,G0H32(1),wf8(:,43),G0H4(85),m3h8x4(:,243),heltab2x32(:,:,529))
  call Hloop_A_Q(ntryL,G0H4(85),19,0,G1H4(179),n2h4(199))
  Gcoeff(:)%j = (c(33)*M(1,:)%j) * den(54)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(530),h0tab(:,530),[19,4,8],[nMB,nMB,nMB],3,1,wf8(:,43))
  call Hloop_AV_Q(ntryL,G0H32(1),wf8(:,43),G0H4(85),m3h8x4(:,244),heltab2x32(:,:,530))
  call Hloop_A_Q(ntryL,G0H4(85),19,nMB,G1H4(180),n2h4(200))
  Gcoeff(:)%j = (c(34)*M(1,:)%j) * den(54)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(531),h0tab(:,531),[19,4,8],[0,0,0],3,1,wf8(:,43))
  call Hloop_QV_A(ntryL,G0H32(1),wf8(:,43),G0H4(85),m3h8x4(:,245),heltab2x32(:,:,531))
  call Hloop_Q_A(ntryL,G0H4(85),19,0,G1H4(185),n2h4(201))
  Gcoeff(:)%j = (c(33)*M(1,:)%j) * den(54)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(532),h0tab(:,532),[19,4,8],[nMB,nMB,nMB],3,1,wf8(:,43))
  call Hloop_QV_A(ntryL,G0H32(1),wf8(:,43),G0H4(85),m3h8x4(:,246),heltab2x32(:,:,532))
  call Hloop_Q_A(ntryL,G0H4(85),19,nMB,G1H4(186),n2h4(202))
  Gcoeff(:)%j = (-(c(42)*M(1,:)%j)) * den(53)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(533),h0tab(:,533),[19,4,8],[nME,nME,nME],3,1,wf8(:,44))
  call Hloop_AZ_Q(ntryL,G0H32(1),wf8(:,44),G0H4(85),ngZl,m3h8x4(:,247),heltab2x32(:,:,533))
  call Hloop_A_Q(ntryL,G0H4(85),19,nME,G1H4(187),n2h4(203))
  Gcoeff(:)%j = (-(c(42)*M(1,:)%j)) * den(53)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(534),h0tab(:,534),[19,4,8],[nMM,nMM,nMM],3,1,wf8(:,44))
  call Hloop_AZ_Q(ntryL,G0H32(1),wf8(:,44),G0H4(85),ngZl,m3h8x4(:,248),heltab2x32(:,:,534))
  call Hloop_A_Q(ntryL,G0H4(85),19,nMM,G1H4(192),n2h4(204))
  Gcoeff(:)%j = (-(c(42)*M(1,:)%j)) * den(53)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(535),h0tab(:,535),[19,4,8],[nML,nML,nML],3,1,wf8(:,44))
  call Hloop_AZ_Q(ntryL,G0H32(1),wf8(:,44),G0H4(85),ngZl,m3h8x4(:,249),heltab2x32(:,:,535))
  call Hloop_A_Q(ntryL,G0H4(85),19,nML,G1H4(193),n2h4(205))
  Gcoeff(:)%j = (-(c(42)*M(1,:)%j)) * den(53)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(536),h0tab(:,536),[19,4,8],[nME,nME,nME],3,1,wf8(:,44))
  call Hloop_QZ_A(ntryL,G0H32(1),wf8(:,44),G0H4(85),ngZl,m3h8x4(:,250),heltab2x32(:,:,536))
  call Hloop_Q_A(ntryL,G0H4(85),19,nME,G1H4(194),n2h4(206))
  Gcoeff(:)%j = (-(c(42)*M(1,:)%j)) * den(53)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(537),h0tab(:,537),[19,4,8],[nMM,nMM,nMM],3,1,wf8(:,44))
  call Hloop_QZ_A(ntryL,G0H32(1),wf8(:,44),G0H4(85),ngZl,m3h8x4(:,251),heltab2x32(:,:,537))
  call Hloop_Q_A(ntryL,G0H4(85),19,nMM,G1H4(199),n2h4(207))
  Gcoeff(:)%j = (-(c(42)*M(1,:)%j)) * den(53)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(538),h0tab(:,538),[19,4,8],[nML,nML,nML],3,1,wf8(:,44))
  call Hloop_QZ_A(ntryL,G0H32(1),wf8(:,44),G0H4(85),ngZl,m3h8x4(:,252),heltab2x32(:,:,538))
  call Hloop_Q_A(ntryL,G0H4(85),19,nML,G1H4(200),n2h4(208))
  Gcoeff(:)%j = (-(c(41)*M(1,:)%j)) * den(53)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(539),h0tab(:,539),[19,4,8],[0,0,0],3,1,wf8(:,44))
  call Hloop_AZ_Q(ntryL,G0H32(1),wf8(:,44),G0H4(85),ngZu,m3h8x4(:,253),heltab2x32(:,:,539))
  call Hloop_A_Q(ntryL,G0H4(85),19,0,G1H4(203),n2h4(209))
  Gcoeff(:)%j = (-(c(39)*M(1,:)%j)) * den(53)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(540),h0tab(:,540),[19,4,8],[nMT,nMT,nMT],3,1,wf8(:,44))
  call Hloop_AZ_Q(ntryL,G0H32(1),wf8(:,44),G0H4(85),ngZu,m3h8x4(:,254),heltab2x32(:,:,540))
  call Hloop_A_Q(ntryL,G0H4(85),19,nMT,G1H4(206),n2h4(210))
  Gcoeff(:)%j = (-(c(41)*M(1,:)%j)) * den(53)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(541),h0tab(:,541),[19,4,8],[0,0,0],3,1,wf8(:,44))
  call Hloop_QZ_A(ntryL,G0H32(1),wf8(:,44),G0H4(85),ngZu,m3h8x4(:,255),heltab2x32(:,:,541))
  call Hloop_Q_A(ntryL,G0H4(85),19,0,G1H4(209),n2h4(211))
  Gcoeff(:)%j = (-(c(39)*M(1,:)%j)) * den(53)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(542),h0tab(:,542),[19,4,8],[nMT,nMT,nMT],3,1,wf8(:,44))
  call Hloop_QZ_A(ntryL,G0H32(1),wf8(:,44),G0H4(85),ngZu,m3h8x4(:,256),heltab2x32(:,:,542))
  call Hloop_Q_A(ntryL,G0H4(85),19,nMT,G1H4(210),n2h4(212))
  Gcoeff(:)%j = (-(c(37)*M(1,:)%j)) * den(53)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(543),h0tab(:,543),[19,4,8],[0,0,0],3,1,wf8(:,44))
  call Hloop_AZ_Q(ntryL,G0H32(1),wf8(:,44),G0H4(85),ngZd,m3h8x4(:,257),heltab2x32(:,:,543))
  call Hloop_A_Q(ntryL,G0H4(85),19,0,G1H4(215),n2h4(213))
  Gcoeff(:)%j = (-(c(35)*M(1,:)%j)) * den(53)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(544),h0tab(:,544),[19,4,8],[nMB,nMB,nMB],3,1,wf8(:,44))
  call Hloop_AZ_Q(ntryL,G0H32(1),wf8(:,44),G0H4(85),ngZd,m3h8x4(:,258),heltab2x32(:,:,544))
  call Hloop_A_Q(ntryL,G0H4(85),19,nMB,G1H4(216),n2h4(214))
  Gcoeff(:)%j = (-(c(37)*M(1,:)%j)) * den(53)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(545),h0tab(:,545),[19,4,8],[0,0,0],3,1,wf8(:,44))
  call Hloop_QZ_A(ntryL,G0H32(1),wf8(:,44),G0H4(85),ngZd,m3h8x4(:,259),heltab2x32(:,:,545))
  call Hloop_Q_A(ntryL,G0H4(85),19,0,G1H4(217),n2h4(215))
  Gcoeff(:)%j = (-(c(35)*M(1,:)%j)) * den(53)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(546),h0tab(:,546),[19,4,8],[nMB,nMB,nMB],3,1,wf8(:,44))
  call Hloop_QZ_A(ntryL,G0H32(1),wf8(:,44),G0H4(85),ngZd,m3h8x4(:,260),heltab2x32(:,:,546))
  call Hloop_Q_A(ntryL,G0H4(85),19,nMB,G1H4(222),n2h4(216))
  Gcoeff(:)%j = (c(3)*M(1,:)%j) * den(54)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(547),h0tab(:,547),[19,4,8],[nMW,nMW,nMW],3,1,wf8(:,43))
  call Hloop_SV_T(ntryL,G0H32(1),0,wf8(:,43),19,G1H4(223),m3h8x4(:,261),heltab2x32(:,:,547))
  Gcoeff(:)%j = (c(3)*M(1,:)%j) * den(54)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(548),h0tab(:,548),[19,4,8],[nMW,nMW,nMW],3,1,wf8(:,43))
  call Hloop_TV_S(ntryL,G0H32(1),0,wf8(:,43),19,G1H4(224),m3h8x4(:,262),heltab2x32(:,:,548))
  Gcoeff(:)%j = (-(c(30)*M(1,:)%j)) * den(53)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(549),h0tab(:,549),[19,4,8],[nMW,nMW,nMW],3,1,wf8(:,44))
  call Hloop_SV_T(ntryL,G0H32(1),0,wf8(:,44),19,G1H4(229),m3h8x4(:,263),heltab2x32(:,:,549))
  Gcoeff(:)%j = (-(c(30)*M(1,:)%j)) * den(53)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(550),h0tab(:,550),[19,4,8],[nMW,nMW,nMW],3,1,wf8(:,44))
  call Hloop_TV_S(ntryL,G0H32(1),0,wf8(:,44),19,G1H4(230),m3h8x4(:,264),heltab2x32(:,:,550))
  Gcoeff(:)%j = (c(3)*M(1,:)%j) * den(54)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(551),h0tab(:,551),[19,4,8],[nMW,nMW,nMW],3,1,wf8(:,43))
  call Hloop_DV_C(ntryL,G0H32(1),0,wf8(:,43),G1H4(233),m3h8x4(:,265),heltab2x32(:,:,551))
  Gcoeff(:)%j = (c(3)*M(1,:)%j) * den(54)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(552),h0tab(:,552),[19,4,8],[nMW,nMW,nMW],3,1,wf8(:,43))
  call Hloop_CV_D(ntryL,G0H32(1),0,wf8(:,43),19,G1H4(236),m3h8x4(:,266),heltab2x32(:,:,552))
  Gcoeff(:)%j = (-(c(3)*M(1,:)%j)) * den(54)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(553),h0tab(:,553),[19,4,8],[nMW,nMW,nMW],3,1,wf8(:,43))
  call Hloop_DV_C(ntryL,G0H32(1),0,wf8(:,43),G1H4(239),m3h8x4(:,267),heltab2x32(:,:,553))
  Gcoeff(:)%j = (-(c(3)*M(1,:)%j)) * den(54)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(554),h0tab(:,554),[19,4,8],[nMW,nMW,nMW],3,1,wf8(:,43))
  call Hloop_CV_D(ntryL,G0H32(1),0,wf8(:,43),19,G1H4(240),m3h8x4(:,268),heltab2x32(:,:,554))
  Gcoeff(:)%j = (c(27)*M(1,:)%j) * den(53)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(555),h0tab(:,555),[19,4,8],[nMW,nMW,nMW],3,1,wf8(:,44))
  call Hloop_DV_C(ntryL,G0H32(1),0,wf8(:,44),G1H4(24),m3h8x4(:,269),heltab2x32(:,:,555))
  Gcoeff(:)%j = (c(27)*M(1,:)%j) * den(53)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(556),h0tab(:,556),[19,4,8],[nMW,nMW,nMW],3,1,wf8(:,44))
  call Hloop_CV_D(ntryL,G0H32(1),0,wf8(:,44),19,G1H4(25),m3h8x4(:,270),heltab2x32(:,:,556))
  Gcoeff(:)%j = (-(c(27)*M(1,:)%j)) * den(53)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(557),h0tab(:,557),[19,4,8],[nMW,nMW,nMW],3,1,wf8(:,44))
  call Hloop_DV_C(ntryL,G0H32(1),0,wf8(:,44),G1H4(71),m3h8x4(:,271),heltab2x32(:,:,557))
  Gcoeff(:)%j = (-(c(27)*M(1,:)%j)) * den(53)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(558),h0tab(:,558),[19,4,8],[nMW,nMW,nMW],3,1,wf8(:,44))
  call Hloop_CV_D(ntryL,G0H32(1),0,wf8(:,44),19,G1H4(77),m3h8x4(:,272),heltab2x32(:,:,558))
  Gcoeff(:)%j = (c(3)*M(1,:)%j) * den(54)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(559),h0tab(:,559),[19,4,8],[nMW,nMW,nMW],3,1,wf8(:,43))
  call Hloop_UW_V(ntryL,G0H32(1),0,wf8(:,43),19,G1H4(4),m3h8x4(:,273),heltab2x32(:,:,559))
  Gcoeff(:)%j = (c(3)*M(1,:)%j) * den(54)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(560),h0tab(:,560),[19,4,8],[nMW,nMW,nMW],3,1,wf8(:,43))
  call Hloop_UV_W(ntryL,G0H32(1),0,wf8(:,43),19,G1H4(9),m3h8x4(:,274),heltab2x32(:,:,560))
  Gcoeff(:)%j = (c(27)*M(1,:)%j) * den(53)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(561),h0tab(:,561),[19,4,8],[nMW,nMW,nMW],3,1,wf8(:,44))
  call Hloop_UW_V(ntryL,G0H32(1),0,wf8(:,44),19,G1H4(22),m3h8x4(:,275),heltab2x32(:,:,561))
  Gcoeff(:)%j = (c(27)*M(1,:)%j) * den(53)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(562),h0tab(:,562),[19,4,8],[nMW,nMW,nMW],3,1,wf8(:,44))
  call Hloop_UV_W(ntryL,G0H32(1),0,wf8(:,44),19,G1H4(28),m3h8x4(:,276),heltab2x32(:,:,562))
  Gcoeff(:)%j = (-(c(5)*M(1,:)%j)) * den(54)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(563),h0tab(:,563),[19,4,8],[nMW,nMW,nMW],3,1,wf8(:,43))
  call Hloop_VV_S(ntryL,G0H32(1),wf8(:,43),G0H4(85),m3h8x4(:,277),heltab2x32(:,:,563))
  Gcoeff(:)%j = (-(c(5)*M(1,:)%j)) * den(54)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(564),h0tab(:,564),[19,4,8],[nMW,nMW,nMW],3,1,wf8(:,43))
  call Hloop_VV_S(ntryL,G0H32(1),wf8(:,43),G0H4(86),m3h8x4(:,278),heltab2x32(:,:,564))
  Gcoeff(:)%j = (c(29)*M(1,:)%j) * den(53)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(565),h0tab(:,565),[19,4,8],[nMW,nMW,nMW],3,1,wf8(:,44))
  call Hloop_VV_S(ntryL,G0H32(1),wf8(:,44),G0H4(87),m3h8x4(:,279),heltab2x32(:,:,565))
  Gcoeff(:)%j = (c(29)*M(1,:)%j) * den(53)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(566),h0tab(:,566),[19,4,8],[nMW,nMW,nMW],3,1,wf8(:,44))
  call Hloop_VV_S(ntryL,G0H32(1),wf8(:,44),G0H4(88),m3h8x4(:,280),heltab2x32(:,:,566))
  Gcoeff(:)%j = (-(c(5)*M(1,:)%j)) * den(54)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(567),h0tab(:,567),[19,4,8],[nMW,nMW,nMW],3,1,wf8(:,43))
  call Hloop_SV_V(ntryL,G0H32(1),wf8(:,43),G0H4(89),m3h8x4(:,281),heltab2x32(:,:,567))
  Gcoeff(:)%j = (-(c(5)*M(1,:)%j)) * den(54)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(568),h0tab(:,568),[19,4,8],[nMW,nMW,nMW],3,1,wf8(:,43))
  call Hloop_SV_V(ntryL,G0H32(1),wf8(:,43),G0H4(90),m3h8x4(:,282),heltab2x32(:,:,568))
  Gcoeff(:)%j = (c(29)*M(1,:)%j) * den(53)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(569),h0tab(:,569),[19,4,8],[nMW,nMW,nMW],3,1,wf8(:,44))
  call Hloop_SV_V(ntryL,G0H32(1),wf8(:,44),G0H4(91),m3h8x4(:,283),heltab2x32(:,:,569))
  Gcoeff(:)%j = (c(29)*M(1,:)%j) * den(53)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(570),h0tab(:,570),[19,4,8],[nMW,nMW,nMW],3,1,wf8(:,44))
  call Hloop_SV_V(ntryL,G0H32(1),wf8(:,44),G0H4(92),m3h8x4(:,284),heltab2x32(:,:,570))
  Gcoeff(:)%j = (-(c(5)*M(1,:)%j)) * den(54)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(571),h0tab(:,571),[19,4,8],[nMW,nMW,nMW],3,1,wf8(:,43))
  call Hloop_SV_T(ntryL,G0H32(1),0,wf8(:,43),19,G1H4(202),m3h8x4(:,285),heltab2x32(:,:,571))
  Gcoeff(:)%j = (-(c(5)*M(1,:)%j)) * den(54)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(572),h0tab(:,572),[19,4,8],[nMW,nMW,nMW],3,1,wf8(:,43))
  call Hloop_TV_S(ntryL,G0H32(1),0,wf8(:,43),19,G1H4(46),m3h8x4(:,286),heltab2x32(:,:,572))
  Gcoeff(:)%j = (c(32)*M(1,:)%j) * den(53)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(573),h0tab(:,573),[19,4,8],[nMW,nMW,nMW],3,1,wf8(:,44))
  call Hloop_SV_T(ntryL,G0H32(1),0,wf8(:,44),19,G1H4(40),m3h8x4(:,287),heltab2x32(:,:,573))
  Gcoeff(:)%j = (c(32)*M(1,:)%j) * den(53)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(574),h0tab(:,574),[19,4,8],[nMW,nMW,nMW],3,1,wf8(:,44))
  call Hloop_TV_S(ntryL,G0H32(1),0,wf8(:,44),19,G1H4(80),m3h8x4(:,288),heltab2x32(:,:,574))
  Gcoeff(:)%j = (-(c(5)*M(1,:)%j)) * den(54)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(575),h0tab(:,575),[19,4,8],[nMW,nMW,nMW],3,1,wf8(:,43))
  call Hloop_UW_V(ntryL,G0H32(1),0,wf8(:,43),19,G1H4(51),m3h8x4(:,289),heltab2x32(:,:,575))
  Gcoeff(:)%j = (-(c(5)*M(1,:)%j)) * den(54)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(576),h0tab(:,576),[19,4,8],[nMW,nMW,nMW],3,1,wf8(:,43))
  call Hloop_UV_W(ntryL,G0H32(1),0,wf8(:,43),19,G1H4(57),m3h8x4(:,290),heltab2x32(:,:,576))
  Gcoeff(:)%j = (-(c(28)*M(1,:)%j)) * den(53)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(577),h0tab(:,577),[19,4,8],[nMW,nMW,nMW],3,1,wf8(:,44))
  call Hloop_UW_V(ntryL,G0H32(1),0,wf8(:,44),19,G1H4(64),m3h8x4(:,291),heltab2x32(:,:,577))
  Gcoeff(:)%j = (-(c(28)*M(1,:)%j)) * den(53)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(578),h0tab(:,578),[19,4,8],[nMW,nMW,nMW],3,1,wf8(:,44))
  call Hloop_UV_W(ntryL,G0H32(1),0,wf8(:,44),19,G1H4(76),m3h8x4(:,292),heltab2x32(:,:,578))
  Gcoeff(:)%j = (-(c(5)*M(1,:)%j)) * den(54)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(579),h0tab(:,579),[19,4,8],[nMW,nMW,nMW],3,1,wf8(:,43))
  call Hloop_VV_S(ntryL,G0H32(1),wf8(:,43),G0H4(93),m3h8x4(:,293),heltab2x32(:,:,579))
  Gcoeff(:)%j = (-(c(5)*M(1,:)%j)) * den(54)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(580),h0tab(:,580),[19,4,8],[nMW,nMW,nMW],3,1,wf8(:,43))
  call Hloop_VV_S(ntryL,G0H32(1),wf8(:,43),G0H4(94),m3h8x4(:,294),heltab2x32(:,:,580))
  Gcoeff(:)%j = (c(29)*M(1,:)%j) * den(53)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(581),h0tab(:,581),[19,4,8],[nMW,nMW,nMW],3,1,wf8(:,44))
  call Hloop_VV_S(ntryL,G0H32(1),wf8(:,44),G0H4(95),m3h8x4(:,295),heltab2x32(:,:,581))
  Gcoeff(:)%j = (c(29)*M(1,:)%j) * den(53)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(582),h0tab(:,582),[19,4,8],[nMW,nMW,nMW],3,1,wf8(:,44))
  call Hloop_VV_S(ntryL,G0H32(1),wf8(:,44),G0H4(96),m3h8x4(:,296),heltab2x32(:,:,582))
  Gcoeff(:)%j = (-(c(5)*M(1,:)%j)) * den(54)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(583),h0tab(:,583),[19,4,8],[nMW,nMW,nMW],3,1,wf8(:,43))
  call Hloop_SV_V(ntryL,G0H32(1),wf8(:,43),G0H4(97),m3h8x4(:,297),heltab2x32(:,:,583))
  Gcoeff(:)%j = (-(c(5)*M(1,:)%j)) * den(54)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(584),h0tab(:,584),[19,4,8],[nMW,nMW,nMW],3,1,wf8(:,43))
  call Hloop_SV_V(ntryL,G0H32(1),wf8(:,43),G0H4(98),m3h8x4(:,298),heltab2x32(:,:,584))
  Gcoeff(:)%j = (c(29)*M(1,:)%j) * den(53)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(585),h0tab(:,585),[19,4,8],[nMW,nMW,nMW],3,1,wf8(:,44))
  call Hloop_SV_V(ntryL,G0H32(1),wf8(:,44),G0H4(99),m3h8x4(:,299),heltab2x32(:,:,585))
  Gcoeff(:)%j = (c(29)*M(1,:)%j) * den(53)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(586),h0tab(:,586),[19,4,8],[nMW,nMW,nMW],3,1,wf8(:,44))
  call Hloop_SV_V(ntryL,G0H32(1),wf8(:,44),G0H4(100),m3h8x4(:,300),heltab2x32(:,:,586))
  Gcoeff(:)%j = (-(c(24)*M(1,:)%j)) * den(38)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(587),h0tab(:,587),[22,1,8],[nMH,nMT,nMT],3,1,wf8(:,34))
  call Hloop_QA_S(ntryL,G0H32(1),wf8(:,34),G0H4(101),ngH,m3h8x4(:,301),heltab2x32(:,:,587))
  Gcoeff(:)%j = (c(24)*M(1,:)%j) * den(38)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(588),h0tab(:,588),[22,1,8],[nMZ,nMT,nMT],3,1,wf8(:,34))
  call Hloop_QA_S(ntryL,G0H32(1),wf8(:,34),G0H4(102),ngX,m3h8x4(:,302),heltab2x32(:,:,588))
  Gcoeff(:)%j = (-(c(16)*M(1,:)%j)) * den(38)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(589),h0tab(:,589),[22,1,8],[nMW,nMB,nMB],3,1,wf8(:,34))
  call Hloop_QA_S(ntryL,G0H32(1),wf8(:,34),G0H4(103),ngPtb,m3h8x4(:,303),heltab2x32(:,:,589))
  Gcoeff(:)%j = (c(19)*M(1,:)%j) * den(38)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(590),h0tab(:,590),[22,1,8],[nMB,nMW,nMW],3,1,wf8(:,34))
  call Hloop_SA_Q(ntryL,G0H32(1),wf8(:,34),G0H4(104),ngPtb,m3h8x4(:,304),heltab2x32(:,:,590))
  call Hloop_A_Q(ntryL,G0H4(104),22,nMB,G1H4(241),n2h4(217))
  Gcoeff(:)%j = (c(1)*M(1,:)%j) * den(38)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(591),h0tab(:,591),[22,1,8],[0,nMT,nMT],3,1,wf8(:,34))
  call Hloop_QA_V(ntryL,G0H32(1),wf8(:,34),G0H4(104),m3h8x4(:,305),heltab2x32(:,:,591))
  Gcoeff(:)%j = (c(2)*M(1,:)%j) * den(38)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(592),h0tab(:,592),[22,1,8],[nMZ,nMT,nMT],3,1,wf8(:,34))
  call Hloop_QA_Z(ntryL,G0H32(1),wf8(:,34),G0H4(105),ngZu,m3h8x4(:,306),heltab2x32(:,:,592))
  Gcoeff(:)%j = (-(c(7)*M(1,:)%j)) * den(38)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(593),h0tab(:,593),[22,1,8],[nMW,nMB,nMB],3,1,wf8(:,34))
  call Hloop_QA_W(ntryL,G0H32(1),wf8(:,34),G0H4(106),m3h8x4(:,307),heltab2x32(:,:,593))
  Gcoeff(:)%j = (-(c(10)*M(1,:)%j)) * den(38)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(594),h0tab(:,594),[22,1,8],[nMB,nMW,nMW],3,1,wf8(:,34))
  call Hloop_WA_Q(ntryL,G0H32(1),wf8(:,34),G0H4(107),m3h8x4(:,308),heltab2x32(:,:,594))
  call Hloop_A_Q(ntryL,G0H4(107),22,nMB,G1H4(242),n2h4(218))
  Gcoeff(:)%j = (c(10)*M(1,:)%j) * den(38)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(595),h0tab(:,595),[22,1,8],[nMB,nMW,nMW],3,1,wf8(:,34))
  call Hloop_SA_Q(ntryL,G0H32(1),wf8(:,34),G0H4(107),ngPtb,m3h8x4(:,309),heltab2x32(:,:,595))
  call Hloop_A_Q(ntryL,G0H4(107),22,nMB,G1H4(243),n2h4(219))
  Gcoeff(:)%j = (c(10)*M(1,:)%j) * den(38)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(596),h0tab(:,596),[22,1,8],[nMB,nMW,nMW],3,1,wf8(:,34))
  call Hloop_WA_Q(ntryL,G0H32(1),wf8(:,34),G0H4(107),m3h8x4(:,310),heltab2x32(:,:,596))
  call Hloop_A_Q(ntryL,G0H4(107),22,nMB,G1H4(244),n2h4(220))
  Gcoeff(:)%j = (-(c(24)*M(1,:)%j)) * den(22)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(597),h0tab(:,597),[26,1,4],[nMH,nMT,nMT],3,1,wf8(:,25))
  call Hloop_QA_S(ntryL,G0H32(1),wf8(:,25),G0H4(107),ngH,m3h8x4(:,311),heltab2x32(:,:,597))
  Gcoeff(:)%j = (c(24)*M(1,:)%j) * den(22)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(598),h0tab(:,598),[26,1,4],[nMZ,nMT,nMT],3,1,wf8(:,25))
  call Hloop_QA_S(ntryL,G0H32(1),wf8(:,25),G0H4(108),ngX,m3h8x4(:,312),heltab2x32(:,:,598))
  Gcoeff(:)%j = (-(c(16)*M(1,:)%j)) * den(22)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(599),h0tab(:,599),[26,1,4],[nMW,nMB,nMB],3,1,wf8(:,25))
  call Hloop_QA_S(ntryL,G0H32(1),wf8(:,25),G0H4(109),ngPtb,m3h8x4(:,313),heltab2x32(:,:,599))
  Gcoeff(:)%j = (c(19)*M(1,:)%j) * den(22)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(600),h0tab(:,600),[26,1,4],[nMB,nMW,nMW],3,1,wf8(:,25))
  call Hloop_SA_Q(ntryL,G0H32(1),wf8(:,25),G0H4(110),ngPtb,m3h8x4(:,314),heltab2x32(:,:,600))
  call Hloop_A_Q(ntryL,G0H4(110),26,nMB,G1H4(245),n2h4(221))
  Gcoeff(:)%j = (c(1)*M(1,:)%j) * den(22)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(601),h0tab(:,601),[26,1,4],[0,nMT,nMT],3,1,wf8(:,25))
  call Hloop_QA_V(ntryL,G0H32(1),wf8(:,25),G0H4(110),m3h8x4(:,315),heltab2x32(:,:,601))
  Gcoeff(:)%j = (c(2)*M(1,:)%j) * den(22)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(602),h0tab(:,602),[26,1,4],[nMZ,nMT,nMT],3,1,wf8(:,25))
  call Hloop_QA_Z(ntryL,G0H32(1),wf8(:,25),G0H4(111),ngZu,m3h8x4(:,316),heltab2x32(:,:,602))
  Gcoeff(:)%j = (-(c(7)*M(1,:)%j)) * den(22)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(603),h0tab(:,603),[26,1,4],[nMW,nMB,nMB],3,1,wf8(:,25))
  call Hloop_QA_W(ntryL,G0H32(1),wf8(:,25),G0H4(112),m3h8x4(:,317),heltab2x32(:,:,603))
  Gcoeff(:)%j = (-(c(10)*M(1,:)%j)) * den(22)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(604),h0tab(:,604),[26,1,4],[nMB,nMW,nMW],3,1,wf8(:,25))
  call Hloop_WA_Q(ntryL,G0H32(1),wf8(:,25),G0H4(113),m3h8x4(:,318),heltab2x32(:,:,604))
  call Hloop_A_Q(ntryL,G0H4(113),26,nMB,G1H4(246),n2h4(222))
  Gcoeff(:)%j = (c(10)*M(1,:)%j) * den(22)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(605),h0tab(:,605),[26,1,4],[nMB,nMW,nMW],3,1,wf8(:,25))
  call Hloop_SA_Q(ntryL,G0H32(1),wf8(:,25),G0H4(113),ngPtb,m3h8x4(:,319),heltab2x32(:,:,605))
  call Hloop_A_Q(ntryL,G0H4(113),26,nMB,G1H4(247),n2h4(223))
  Gcoeff(:)%j = (c(10)*M(1,:)%j) * den(22)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(606),h0tab(:,606),[26,1,4],[nMB,nMW,nMW],3,1,wf8(:,25))
  call Hloop_WA_Q(ntryL,G0H32(1),wf8(:,25),G0H4(113),m3h8x4(:,320),heltab2x32(:,:,606))
  call Hloop_A_Q(ntryL,G0H4(113),26,nMB,G1H4(248),n2h4(224))
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G0H4(57),[G0H4(5)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G0H4(58),[G0H4(3)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G0H4(59),[G0H4(4)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(43),[G1H4(82)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G0H4(60),[G0H4(2)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G0H4(61),[G0H4(1)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G0H4(62),[G0H4(6)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(44),[G1H4(88)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(47),[G1H4(178)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(48),[G1H4(94)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G0H4(101),[G0H4(7)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G0H4(102),[G0H4(8)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G0H4(103),[G0H4(9)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(241),[G1H4(99)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G0H4(104),[G0H4(10)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G0H4(105),[G0H4(11)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G0H4(106),[G0H4(12)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(242),[G1H4(106)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(243),[G1H4(100)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(244),[G1H4(102)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G0H4(63),[G0H4(13)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G0H4(64),[G0H4(14)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G0H4(65),[G0H4(15)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(54),[G1H4(105)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G0H4(66),[G0H4(16)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G0H4(67),[G0H4(17)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G0H4(68),[G0H4(18)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(60),[G1H4(103)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(61),[G1H4(111)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(62),[G1H4(117)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G0H4(107),[G0H4(19)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G0H4(108),[G0H4(20)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G0H4(109),[G0H4(21)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(245),[G1H4(123)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G0H4(110),[G0H4(22)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G0H4(111),[G0H4(23)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G0H4(112),[G0H4(24)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(246),[G1H4(130)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(247),[G1H4(124)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(248),[G1H4(30)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(187),[G1H4(155),G1H4(97),G1H4(65),G1H4(112),G1H4(69) &
    ,G1H4(159),G1H4(129)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(192),[G1H4(156),G1H4(98),G1H4(66),G1H4(107),G1H4(11) &
    ,G1H4(165),G1H4(31)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(193),[G1H4(157),G1H4(104),G1H4(67),G1H4(29),G1H4(75) &
    ,G1H4(171),G1H4(135)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(194),[G1H4(162),G1H4(110),G1H4(68),G1H4(142),G1H4(14) &
    ,G1H4(177),G1H4(141)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(199),[G1H4(163),G1H4(113),G1H4(84),G1H4(36),G1H4(81) &
    ,G1H4(195),G1H4(147)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(200),[G1H4(164),G1H4(114),G1H4(90),G1H4(37),G1H4(13) &
    ,G1H4(201),G1H4(154)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(206),[G1H4(170),G1H4(115),G1H4(91),G1H4(35),G1H4(17) &
    ,G1H4(3),G1H4(148)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(210),[G1H4(176),G1H4(116),G1H4(92),G1H4(166),G1H4(18) &
    ,G1H4(1),G1H4(50)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(216),[G1H4(180),G1H4(119),G1H4(95),G1H4(59),G1H4(118) &
    ,G1H4(10),G1H4(153)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(222),[G1H4(186),G1H4(120),G1H4(96),G1H4(55),G1H4(109) &
    ,G1H4(2),G1H4(53)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(229),[G1H4(223),G1H4(183),G1H4(72),G0H4(69),G0H4(25)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(230),[G1H4(224),G1H4(184),G1H4(78),G0H4(70),G0H4(26)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(71),[G1H4(24),G1H4(239),G1H4(233),G1H4(213),G1H4(207) &
    ,G1H4(20),G1H4(189),G0H4(77),G0H4(75),G0H4(73),G0H4(71),G0H4(33),G0H4(31),G0H4(29),G0H4(27)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(77),[G1H4(25),G1H4(240),G1H4(236),G1H4(214),G1H4(208) &
    ,G1H4(26),G1H4(190),G0H4(78),G0H4(76),G0H4(74),G0H4(72),G0H4(34),G0H4(32),G0H4(30),G0H4(28)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(22),[G1H4(4),G1H4(225),G1H4(219),G0H4(79),G0H4(35)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(28),[G1H4(9),G1H4(226),G1H4(220),G0H4(80),G0H4(36)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(126),[G1H4(122),G1H4(21),G1H4(16),G0H4(87),G0H4(85) &
    ,G0H4(43),G0H4(41)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(125),[G1H4(121),G1H4(5),G1H4(6),G0H4(88),G0H4(86) &
    ,G0H4(44),G0H4(42)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(132),[G1H4(128),G1H4(33),G1H4(27),G0H4(91),G0H4(89) &
    ,G0H4(47),G0H4(45)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(131),[G1H4(127),G1H4(7),G1H4(8),G0H4(92),G0H4(90) &
    ,G0H4(48),G0H4(46)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(80),[G1H4(40),G1H4(46),G1H4(202),G1H4(238),G1H4(237) &
    ,G1H4(232),G1H4(231),G0H4(82),G0H4(81),G0H4(38),G0H4(37)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(76),[G1H4(64),G1H4(57),G1H4(51),G1H4(42),G1H4(41) &
    ,G1H4(38),G1H4(32),G0H4(84),G0H4(83),G0H4(40),G0H4(39)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(139),[G1H4(133),G1H4(86),G1H4(79),G0H4(95),G0H4(93) &
    ,G0H4(51),G0H4(49)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(140),[G1H4(134),G1H4(89),G1H4(58),G0H4(96),G0H4(94) &
    ,G0H4(52),G0H4(50)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(149),[G1H4(143),G1H4(63),G1H4(52),G0H4(99),G0H4(97) &
    ,G0H4(55),G0H4(53)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(150),[G1H4(146),G1H4(12),G1H4(85),G0H4(100),G0H4(98) &
    ,G0H4(56),G0H4(54)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(215),[G1H4(203),G1H4(179),G1H4(169),G1H4(56),G1H4(136) &
    ,G1H4(101),G1H4(87)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(217),[G1H4(209),G1H4(185),G1H4(173),G1H4(160),G1H4(49) &
    ,G1H4(108),G1H4(93)])
  call Hloop_QA_S(ntryL,G1H8(1),ex2(:),G1H4(82),ngPtb,m3h2x4(:,169),heltab2x8(:,:,193))
  call Hloop_QA_W(ntryL,G1H8(2),ex2(:),G1H4(88),m3h2x4(:,170),heltab2x8(:,:,194))
  call Hloop_AQ_S(ntryL,G1H8(3),ex1(:),G1H4(178),ngPbt,m3h2x4(:,171),heltab2x8(:,:,195))
  call Hloop_AQ_W(ntryL,G1H8(4),ex1(:),G1H4(94),m3h2x4(:,172),heltab2x8(:,:,196))
  call Hloop_AQ_S(ntryL,G1H16(67),wf4(:,3),G1H4(99),ngH,m3h4x4(:,13),heltab2x16(:,:,135))
  call Hloop_AQ_S(ntryL,G1H16(68),wf4(:,3),G1H4(106),ngX,m3h4x4(:,14),heltab2x16(:,:,136))
  call Hloop_AQ_S(ntryL,G1H16(1),wf4(:,3),G1H4(100),ngPbt,m3h4x4(:,15),heltab2x16(:,:,137))
  call Hloop_AQ_V(ntryL,G1H16(2),wf4(:,3),G1H4(102),m3h4x4(:,16),heltab2x16(:,:,138))
  call Hloop_AQ_Z(ntryL,G1H16(3),wf4(:,3),G1H4(105),ngZu,m3h4x4(:,17),heltab2x16(:,:,139))
  call Hloop_AQ_W(ntryL,G1H16(4),wf4(:,3),G1H4(103),m3h4x4(:,18),heltab2x16(:,:,140))
  call Hloop_SQ_A(ntryL,G0H8(4),wf4(:,3),G0H2(1),ngH,m3h4x2(:,25),heltab2x8(:,:,197))
  call Hloop_Q_A(ntryL,G0H2(1),23,nMT,G1H2(185),n2h2(193))
  call Hloop_SQ_A(ntryL,G0H8(5),wf4(:,3),G0H2(1),ngX,m3h4x2(:,26),heltab2x8(:,:,198))
  call Hloop_Q_A(ntryL,G0H2(1),23,nMT,G1H2(186),n2h2(194))
  call Hloop_SQ_A(ntryL,G0H8(6),wf4(:,3),G0H2(1),ngPbt,m3h4x2(:,27),heltab2x8(:,:,199))
  call Hloop_Q_A(ntryL,G0H2(1),23,nMB,G1H2(196),n2h2(195))
  call Hloop_AQ_S(ntryL,G1H8(5),wf4(:,3),G1H2(197),ngPbt,m3h4x2(:,28),heltab2x8(:,:,200))
  call Hloop_VQ_A(ntryL,G0H8(8),wf4(:,3),G0H2(1),m3h4x2(:,29),heltab2x8(:,:,201))
  call Hloop_Q_A(ntryL,G0H2(1),23,nMT,G1H2(201),n2h2(196))
  call Hloop_ZQ_A(ntryL,G0H8(9),wf4(:,3),G0H2(1),ngZu,m3h4x2(:,30),heltab2x8(:,:,202))
  call Hloop_Q_A(ntryL,G0H2(1),23,nMT,G1H2(208),n2h2(197))
  call Hloop_WQ_A(ntryL,G0H8(10),wf4(:,3),G0H2(1),m3h4x2(:,31),heltab2x8(:,:,203))
  call Hloop_Q_A(ntryL,G0H2(1),23,nMB,G1H2(212),n2h2(198))
  call Hloop_AQ_S(ntryL,G1H8(6),wf4(:,3),G1H2(213),ngPbt,m3h4x2(:,32),heltab2x8(:,:,204))
  call Hloop_AQ_W(ntryL,G1H8(7),wf4(:,3),G1H2(223),m3h4x2(:,33),heltab2x8(:,:,205))
  call Hloop_AQ_W(ntryL,G1H8(8),wf4(:,3),G1H2(224),m3h4x2(:,34),heltab2x8(:,:,206))
  call Hloop_QA_S(ntryL,G1H16(5),ex2(:),G1H8(25),ngH,m3h2x8(:,123),heltab2x16(:,:,141))
  call Hloop_QA_S(ntryL,G1H16(6),ex2(:),G1H8(26),ngX,m3h2x8(:,124),heltab2x16(:,:,142))
  call Hloop_QA_S(ntryL,G1H16(7),ex2(:),G1H8(27),ngPtb,m3h2x8(:,125),heltab2x16(:,:,143))
  call Hloop_QA_V(ntryL,G1H16(8),ex2(:),G1H8(28),m3h2x8(:,126),heltab2x16(:,:,144))
  call Hloop_QA_Z(ntryL,G1H16(9),ex2(:),G1H8(29),ngZu,m3h2x8(:,127),heltab2x16(:,:,145))
  call Hloop_QA_W(ntryL,G1H16(10),ex2(:),G1H8(30),m3h2x8(:,128),heltab2x16(:,:,146))
  call Hloop_SA_Q(ntryL,G0H4(57),ex2(:),G0H2(1),ngH,m3h2x2(:,273),heltab2x4(:,:,333))
  call Hloop_A_Q(ntryL,G0H2(1),23,nMT,G1H2(229),n2h2(199))
  call Hloop_SA_Q(ntryL,G0H4(58),ex2(:),G0H2(1),ngX,m3h2x2(:,274),heltab2x4(:,:,334))
  call Hloop_A_Q(ntryL,G0H2(1),23,nMT,G1H2(235),n2h2(200))
  call Hloop_SA_Q(ntryL,G0H4(59),ex2(:),G0H2(1),ngPtb,m3h2x2(:,275),heltab2x4(:,:,335))
  call Hloop_A_Q(ntryL,G0H2(1),23,nMB,G1H2(240),n2h2(201))
  call Hloop_QA_S(ntryL,G1H4(43),ex2(:),G1H2(241),ngPtb,m3h2x2(:,276),heltab2x4(:,:,336))
  call Hloop_VA_Q(ntryL,G0H4(60),ex2(:),G0H2(1),m3h2x2(:,277),heltab2x4(:,:,337))
  call Hloop_A_Q(ntryL,G0H2(1),23,nMT,G1H2(251),n2h2(202))
  call Hloop_ZA_Q(ntryL,G0H4(61),ex2(:),G0H2(1),ngZu,m3h2x2(:,278),heltab2x4(:,:,338))
  call Hloop_A_Q(ntryL,G0H2(1),23,nMT,G1H2(252),n2h2(203))
  call Hloop_WA_Q(ntryL,G0H4(62),ex2(:),G0H2(1),m3h2x2(:,279),heltab2x4(:,:,339))
  call Hloop_A_Q(ntryL,G0H2(1),23,nMB,G1H2(256),n2h2(204))
  call Hloop_QA_S(ntryL,G1H4(44),ex2(:),G1H2(263),ngPtb,m3h2x2(:,280),heltab2x4(:,:,340))
  call Hloop_QA_W(ntryL,G1H4(47),ex2(:),G1H2(267),m3h2x2(:,281),heltab2x4(:,:,341))
  call Hloop_QA_W(ntryL,G1H4(48),ex2(:),G1H2(268),m3h2x2(:,282),heltab2x4(:,:,342))
  call Hloop_QA_S(ntryL,G1H16(11),wf4(:,10),G1H4(111),ngH,m3h4x4(:,19),heltab2x16(:,:,147))
  call Hloop_QA_S(ntryL,G1H16(12),wf4(:,10),G1H4(117),ngX,m3h4x4(:,20),heltab2x16(:,:,148))
  call Hloop_QA_S(ntryL,G1H16(13),wf4(:,10),G1H4(123),ngPtb,m3h4x4(:,21),heltab2x16(:,:,149))
  call Hloop_QA_V(ntryL,G1H16(14),wf4(:,10),G1H4(130),m3h4x4(:,22),heltab2x16(:,:,150))
  call Hloop_QA_Z(ntryL,G1H16(15),wf4(:,10),G1H4(124),ngZu,m3h4x4(:,23),heltab2x16(:,:,151))
  call Hloop_QA_W(ntryL,G1H16(16),wf4(:,10),G1H4(30),m3h4x4(:,24),heltab2x16(:,:,152))
  call Hloop_SA_Q(ntryL,G0H8(14),wf4(:,10),G0H2(1),ngH,m3h4x2(:,35),heltab2x8(:,:,207))
  call Hloop_A_Q(ntryL,G0H2(1),23,nMT,G1H2(278),n2h2(205))
  call Hloop_SA_Q(ntryL,G0H8(15),wf4(:,10),G0H2(1),ngX,m3h4x2(:,36),heltab2x8(:,:,208))
  call Hloop_A_Q(ntryL,G0H2(1),23,nMT,G1H2(279),n2h2(206))
  call Hloop_SA_Q(ntryL,G0H8(16),wf4(:,10),G0H2(1),ngPtb,m3h4x2(:,37),heltab2x8(:,:,209))
  call Hloop_A_Q(ntryL,G0H2(1),23,nMB,G1H2(284),n2h2(207))
  call Hloop_QA_S(ntryL,G1H8(9),wf4(:,10),G1H2(290),ngPtb,m3h4x2(:,38),heltab2x8(:,:,210))
  call Hloop_VA_Q(ntryL,G0H8(18),wf4(:,10),G0H2(1),m3h4x2(:,39),heltab2x8(:,:,211))
  call Hloop_A_Q(ntryL,G0H2(1),23,nMT,G1H2(295),n2h2(208))
  call Hloop_ZA_Q(ntryL,G0H8(19),wf4(:,10),G0H2(1),ngZu,m3h4x2(:,40),heltab2x8(:,:,212))
  call Hloop_A_Q(ntryL,G0H2(1),23,nMT,G1H2(296),n2h2(209))
  call Hloop_WA_Q(ntryL,G0H8(20),wf4(:,10),G0H2(1),m3h4x2(:,41),heltab2x8(:,:,213))
  call Hloop_A_Q(ntryL,G0H2(1),23,nMB,G1H2(306),n2h2(210))
  call Hloop_QA_W(ntryL,G1H8(10),wf4(:,10),G1H2(307),m3h4x2(:,42),heltab2x8(:,:,214))
  call Hloop_QA_S(ntryL,G1H8(11),wf4(:,10),G1H2(311),ngPtb,m3h4x2(:,43),heltab2x8(:,:,215))
  call Hloop_QA_W(ntryL,G1H8(12),wf4(:,10),G1H2(318),m3h4x2(:,44),heltab2x8(:,:,216))
  call Hloop_AQ_S(ntryL,G1H16(17),ex1(:),G1H8(31),ngH,m3h2x8(:,129),heltab2x16(:,:,153))
  call Hloop_AQ_S(ntryL,G1H16(18),ex1(:),G1H8(32),ngX,m3h2x8(:,130),heltab2x16(:,:,154))
  call Hloop_AQ_S(ntryL,G1H16(19),ex1(:),G1H8(33),ngPbt,m3h2x8(:,131),heltab2x16(:,:,155))
  call Hloop_AQ_V(ntryL,G1H16(20),ex1(:),G1H8(34),m3h2x8(:,132),heltab2x16(:,:,156))
  call Hloop_AQ_Z(ntryL,G1H16(21),ex1(:),G1H8(35),ngZu,m3h2x8(:,133),heltab2x16(:,:,157))
  call Hloop_AQ_W(ntryL,G1H16(22),ex1(:),G1H8(36),m3h2x8(:,134),heltab2x16(:,:,158))
  call Hloop_SQ_A(ntryL,G0H4(101),ex1(:),G0H2(1),ngH,m3h2x2(:,283),heltab2x4(:,:,343))
  call Hloop_Q_A(ntryL,G0H2(1),23,nMT,G1H2(323),n2h2(211))
  call Hloop_SQ_A(ntryL,G0H4(102),ex1(:),G0H2(1),ngX,m3h2x2(:,284),heltab2x4(:,:,344))
  call Hloop_Q_A(ntryL,G0H2(1),23,nMT,G1H2(328),n2h2(212))
  call Hloop_SQ_A(ntryL,G0H4(103),ex1(:),G0H2(1),ngPbt,m3h2x2(:,285),heltab2x4(:,:,345))
  call Hloop_Q_A(ntryL,G0H2(1),23,nMB,G1H2(338),n2h2(213))
  call Hloop_AQ_S(ntryL,G1H4(241),ex1(:),G1H2(339),ngPbt,m3h2x2(:,286),heltab2x4(:,:,346))
  call Hloop_VQ_A(ntryL,G0H4(104),ex1(:),G0H2(1),m3h2x2(:,287),heltab2x4(:,:,347))
  call Hloop_Q_A(ntryL,G0H2(1),23,nMT,G1H2(344),n2h2(214))
  call Hloop_ZQ_A(ntryL,G0H4(105),ex1(:),G0H2(1),ngZu,m3h2x2(:,288),heltab2x4(:,:,348))
  call Hloop_Q_A(ntryL,G0H2(1),23,nMT,G1H2(12),n2h2(215))
  call Hloop_WQ_A(ntryL,G0H4(106),ex1(:),G0H2(1),m3h2x2(:,289),heltab2x4(:,:,349))
  call Hloop_Q_A(ntryL,G0H2(1),23,nMB,G1H2(18),n2h2(216))
  call Hloop_AQ_S(ntryL,G1H4(242),ex1(:),G1H2(24),ngPbt,m3h2x2(:,290),heltab2x4(:,:,350))
  call Hloop_AQ_W(ntryL,G1H4(243),ex1(:),G1H2(52),m3h2x2(:,291),heltab2x4(:,:,351))
  call Hloop_AQ_W(ntryL,G1H4(244),ex1(:),G1H2(63),m3h2x2(:,292),heltab2x4(:,:,352))
  call Hloop_AV_Q(ntryL,G1H8(13),ex3(:),G1H4(155),m3h2x4(:,173),heltab2x8(:,:,217))
  call Hloop_A_Q(ntryL,G1H4(155),22,nMT,G2H4(12),n2h4(225))
  call Hloop_AV_Q(ntryL,G1H8(14),ex3(:),G1H4(97),m3h2x4(:,174),heltab2x8(:,:,218))
  call Hloop_A_Q(ntryL,G1H4(97),22,nMT,G2H4(10),n2h4(226))
  call Hloop_AV_Q(ntryL,G1H8(15),ex3(:),G1H4(65),m3h2x4(:,175),heltab2x8(:,:,219))
  call Hloop_A_Q(ntryL,G1H4(65),22,nMB,G2H4(13),n2h4(227))
  call Hloop_TV_S(ntryL,G0H8(27),18,ex3(:),4,G1H4(112),m3h2x4(:,176),heltab2x8(:,:,220))
  call Hloop_AV_Q(ntryL,G1H8(16),ex3(:),G1H4(69),m3h2x4(:,177),heltab2x8(:,:,221))
  call Hloop_A_Q(ntryL,G1H4(69),22,nMT,G2H4(14),n2h4(228))
  call Hloop_AV_Q(ntryL,G1H8(17),ex3(:),G1H4(159),m3h2x4(:,178),heltab2x8(:,:,222))
  call Hloop_A_Q(ntryL,G1H4(159),22,nMT,G2H4(15),n2h4(229))
  call Hloop_AV_Q(ntryL,G1H8(18),ex3(:),G1H4(129),m3h2x4(:,179),heltab2x8(:,:,223))
  call Hloop_A_Q(ntryL,G1H4(129),22,nMB,G2H4(16),n2h4(230))
  call Hloop_VV_S(ntryL,G0H8(31),ex3(:),G0H4(113),m3h2x4(:,180),heltab2x8(:,:,224))
  call Hloop_SV_V(ntryL,G0H8(32),ex3(:),G0H4(5),m3h2x4(:,181),heltab2x8(:,:,225))
  call Hloop_UV_W(ntryL,G0H8(33),18,ex3(:),4,G1H4(156),m3h2x4(:,182),heltab2x8(:,:,226))
  call Hloop_QA_S(ntryL,G1H16(23),ex2(:),G1H8(37),ngH,m3h2x8(:,135),heltab2x16(:,:,159))
  call Hloop_QA_S(ntryL,G1H16(24),ex2(:),G1H8(38),ngX,m3h2x8(:,136),heltab2x16(:,:,160))
  call Hloop_QA_S(ntryL,G1H16(25),ex2(:),G1H8(39),ngPtb,m3h2x8(:,137),heltab2x16(:,:,161))
  call Hloop_QA_V(ntryL,G1H16(26),ex2(:),G1H8(40),m3h2x8(:,138),heltab2x16(:,:,162))
  call Hloop_QA_Z(ntryL,G1H16(27),ex2(:),G1H8(41),ngZu,m3h2x8(:,139),heltab2x16(:,:,163))
  call Hloop_QA_W(ntryL,G1H16(28),ex2(:),G1H8(42),m3h2x8(:,140),heltab2x16(:,:,164))
  call Hloop_SA_Q(ntryL,G0H4(63),ex2(:),G0H2(1),ngH,m3h2x2(:,293),heltab2x4(:,:,353))
  call Hloop_A_Q(ntryL,G0H2(1),27,nMT,G1H2(74),n2h2(217))
  call Hloop_SA_Q(ntryL,G0H4(64),ex2(:),G0H2(1),ngX,m3h2x2(:,294),heltab2x4(:,:,354))
  call Hloop_A_Q(ntryL,G0H2(1),27,nMT,G1H2(107),n2h2(218))
  call Hloop_SA_Q(ntryL,G0H4(65),ex2(:),G0H2(1),ngPtb,m3h2x2(:,295),heltab2x4(:,:,355))
  call Hloop_A_Q(ntryL,G0H2(1),27,nMB,G1H2(118),n2h2(219))
  call Hloop_QA_S(ntryL,G1H4(54),ex2(:),G1H2(129),ngPtb,m3h2x2(:,296),heltab2x4(:,:,356))
  call Hloop_VA_Q(ntryL,G0H4(66),ex2(:),G0H2(1),m3h2x2(:,297),heltab2x4(:,:,357))
  call Hloop_A_Q(ntryL,G0H2(1),27,nMT,G1H2(162),n2h2(220))
  call Hloop_ZA_Q(ntryL,G0H4(67),ex2(:),G0H2(1),ngZu,m3h2x2(:,298),heltab2x4(:,:,358))
  call Hloop_A_Q(ntryL,G0H2(1),27,nMT,G1H2(173),n2h2(221))
  call Hloop_WA_Q(ntryL,G0H4(68),ex2(:),G0H2(1),m3h2x2(:,299),heltab2x4(:,:,359))
  call Hloop_A_Q(ntryL,G0H2(1),27,nMB,G1H2(184),n2h2(222))
  call Hloop_QA_S(ntryL,G1H4(60),ex2(:),G1H2(217),ngPtb,m3h2x2(:,300),heltab2x4(:,:,360))
  call Hloop_QA_W(ntryL,G1H4(61),ex2(:),G1H2(228),m3h2x2(:,301),heltab2x4(:,:,361))
  call Hloop_QA_W(ntryL,G1H4(62),ex2(:),G1H2(239),m3h2x2(:,302),heltab2x4(:,:,362))
  call Hloop_QV_A(ntryL,G1H8(19),ex3(:),G1H4(98),m3h2x4(:,183),heltab2x8(:,:,227))
  call Hloop_Q_A(ntryL,G1H4(98),21,nMT,G2H4(17),n2h4(231))
  call Hloop_QV_A(ntryL,G1H8(20),ex3(:),G1H4(66),m3h2x4(:,184),heltab2x8(:,:,228))
  call Hloop_Q_A(ntryL,G1H4(66),21,nMT,G2H4(18),n2h4(232))
  call Hloop_QV_A(ntryL,G1H8(21),ex3(:),G1H4(107),m3h2x4(:,185),heltab2x8(:,:,229))
  call Hloop_Q_A(ntryL,G1H4(107),21,nMB,G2H4(19),n2h4(233))
  call Hloop_SV_T(ntryL,G0H8(7),17,ex3(:),4,G1H4(11),m3h2x4(:,186),heltab2x8(:,:,230))
  call Hloop_QV_A(ntryL,G1H8(22),ex3(:),G1H4(165),m3h2x4(:,187),heltab2x8(:,:,231))
  call Hloop_Q_A(ntryL,G1H4(165),21,nMT,G2H4(23),n2h4(234))
  call Hloop_QV_A(ntryL,G1H8(23),ex3(:),G1H4(31),m3h2x4(:,188),heltab2x8(:,:,232))
  call Hloop_Q_A(ntryL,G1H4(31),21,nMT,G2H4(24),n2h4(235))
  call Hloop_QV_A(ntryL,G1H8(24),ex3(:),G1H4(157),m3h2x4(:,189),heltab2x8(:,:,233))
  call Hloop_Q_A(ntryL,G1H4(157),21,nMB,G2H4(22),n2h4(236))
  call Hloop_SV_V(ntryL,G0H8(17),ex3(:),G0H4(3),m3h2x4(:,190),heltab2x8(:,:,234))
  call Hloop_VV_S(ntryL,G0H8(21),ex3(:),G0H4(4),m3h2x4(:,191),heltab2x8(:,:,235))
  call Hloop_UW_V(ntryL,G0H8(22),17,ex3(:),4,G1H4(104),m3h2x4(:,192),heltab2x8(:,:,236))
  call Hloop_AQ_S(ntryL,G1H16(29),ex1(:),G1H8(43),ngH,m3h2x8(:,141),heltab2x16(:,:,165))
  call Hloop_AQ_S(ntryL,G1H16(30),ex1(:),G1H8(44),ngX,m3h2x8(:,142),heltab2x16(:,:,166))
  call Hloop_AQ_S(ntryL,G1H16(31),ex1(:),G1H8(45),ngPbt,m3h2x8(:,143),heltab2x16(:,:,167))
  call Hloop_AQ_V(ntryL,G1H16(32),ex1(:),G1H8(46),m3h2x8(:,144),heltab2x16(:,:,168))
  call Hloop_AQ_Z(ntryL,G1H16(33),ex1(:),G1H8(47),ngZu,m3h2x8(:,145),heltab2x16(:,:,169))
  call Hloop_AQ_W(ntryL,G1H16(34),ex1(:),G1H8(48),m3h2x8(:,146),heltab2x16(:,:,170))
  call Hloop_SQ_A(ntryL,G0H4(107),ex1(:),G0H2(1),ngH,m3h2x2(:,303),heltab2x4(:,:,363))
  call Hloop_Q_A(ntryL,G0H2(1),27,nMT,G1H2(272),n2h2(223))
  call Hloop_SQ_A(ntryL,G0H4(108),ex1(:),G0H2(1),ngX,m3h2x2(:,304),heltab2x4(:,:,364))
  call Hloop_Q_A(ntryL,G0H2(1),27,nMT,G1H2(283),n2h2(224))
  call Hloop_SQ_A(ntryL,G0H4(109),ex1(:),G0H2(1),ngPbt,m3h2x2(:,305),heltab2x4(:,:,365))
  call Hloop_Q_A(ntryL,G0H2(1),27,nMB,G1H2(294),n2h2(225))
  call Hloop_AQ_S(ntryL,G1H4(245),ex1(:),G1H2(337),ngPbt,m3h2x2(:,306),heltab2x4(:,:,366))
  call Hloop_VQ_A(ntryL,G0H4(110),ex1(:),G0H2(1),m3h2x2(:,307),heltab2x4(:,:,367))
  call Hloop_Q_A(ntryL,G0H2(1),27,nMT,G1H2(1),n2h2(226))
  call Hloop_ZQ_A(ntryL,G0H4(111),ex1(:),G0H2(1),ngZu,m3h2x2(:,308),heltab2x4(:,:,368))
  call Hloop_Q_A(ntryL,G0H2(1),27,nMT,G1H2(2),n2h2(227))
  call Hloop_WQ_A(ntryL,G0H4(112),ex1(:),G0H2(1),m3h2x2(:,309),heltab2x4(:,:,369))
  call Hloop_Q_A(ntryL,G0H2(1),27,nMB,G1H2(8),n2h2(228))
  call Hloop_AQ_S(ntryL,G1H4(246),ex1(:),G1H2(327),ngPbt,m3h2x2(:,310),heltab2x4(:,:,370))
  call Hloop_AQ_W(ntryL,G1H4(247),ex1(:),G1H2(13),m3h2x2(:,311),heltab2x4(:,:,371))
  call Hloop_AQ_W(ntryL,G1H4(248),ex1(:),G1H2(19),m3h2x2(:,312),heltab2x4(:,:,372))
  call Hloop_AV_Q(ntryL,G1H4(187),ex3(:),G1H2(20),m3h2x2(:,313),heltab2x4(:,:,373))
  call Hloop_A_Q(ntryL,G1H2(20),23,nME,G2H2(19),n2h2(229))
  call Hloop_AV_Q(ntryL,G1H4(192),ex3(:),G1H2(348),m3h2x2(:,314),heltab2x4(:,:,374))
  call Hloop_A_Q(ntryL,G1H2(348),23,nMM,G2H2(11),n2h2(230))
  call Hloop_AV_Q(ntryL,G1H4(193),ex3(:),G1H2(31),m3h2x2(:,315),heltab2x4(:,:,375))
  call Hloop_A_Q(ntryL,G1H2(31),23,nML,G2H2(7),n2h2(231))
  call Hloop_QV_A(ntryL,G1H4(194),ex3(:),G1H2(32),m3h2x2(:,316),heltab2x4(:,:,376))
  call Hloop_Q_A(ntryL,G1H2(32),23,nME,G2H2(15),n2h2(232))
  call Hloop_QV_A(ntryL,G1H4(199),ex3(:),G1H2(36),m3h2x2(:,317),heltab2x4(:,:,377))
  call Hloop_Q_A(ntryL,G1H2(36),23,nMM,G2H2(31),n2h2(233))
  call Hloop_QV_A(ntryL,G1H4(200),ex3(:),G1H2(43),m3h2x2(:,318),heltab2x4(:,:,378))
  call Hloop_Q_A(ntryL,G1H2(43),23,nML,G2H2(112),n2h2(234))
  call Hloop_AV_Q(ntryL,G1H4(206),ex3(:),G1H2(47),m3h2x2(:,319),heltab2x4(:,:,379))
  call Hloop_A_Q(ntryL,G1H2(47),23,nMT,G2H2(35),n2h2(235))
  call Hloop_QV_A(ntryL,G1H4(210),ex3(:),G1H2(48),m3h2x2(:,320),heltab2x4(:,:,380))
  call Hloop_Q_A(ntryL,G1H2(48),23,nMT,G2H2(113),n2h2(236))
  call Hloop_AV_Q(ntryL,G1H4(216),ex3(:),G1H2(58),m3h2x2(:,321),heltab2x4(:,:,381))
  call Hloop_A_Q(ntryL,G1H2(58),23,nMB,G2H2(123),n2h2(237))
  call Hloop_QV_A(ntryL,G1H4(222),ex3(:),G1H2(59),m3h2x2(:,322),heltab2x4(:,:,382))
  call Hloop_Q_A(ntryL,G1H2(59),23,nMB,G2H2(119),n2h2(238))
  call Hloop_SV_T(ntryL,G1H4(229),19,ex3(:),4,G2H2(39),m3h2x2(:,323),heltab2x4(:,:,383))
  call Hloop_TV_S(ntryL,G1H4(230),19,ex3(:),4,G2H2(43),m3h2x2(:,324),heltab2x4(:,:,384))
  call Hloop_DV_C(ntryL,G1H4(71),19,ex3(:),G2H2(59),m3h2x2(:,325),heltab2x4(:,:,385))
  call Hloop_CV_D(ntryL,G1H4(77),19,ex3(:),4,G2H2(51),m3h2x2(:,326),heltab2x4(:,:,386))
  call Hloop_UW_V(ntryL,G1H4(22),19,ex3(:),4,G2H2(47),m3h2x2(:,327),heltab2x4(:,:,387))
  call Hloop_UV_W(ntryL,G1H4(28),19,ex3(:),4,G2H2(55),m3h2x2(:,328),heltab2x4(:,:,388))
  call Hloop_SV_T(ntryL,G1H4(126),19,ex3(:),4,G2H2(149),m3h2x2(:,329),heltab2x4(:,:,389))
  call Hloop_TV_S(ntryL,G1H4(125),19,ex3(:),4,G2H2(71),m3h2x2(:,330),heltab2x4(:,:,390))
  call Hloop_VV_S(ntryL,G1H4(132),ex3(:),G1H2(64),m3h2x2(:,331),heltab2x4(:,:,391))
  call Hloop_VV_S(ntryL,G1H4(131),ex3(:),G1H2(76),m3h2x2(:,332),heltab2x4(:,:,392))
  call Hloop_SV_V(ntryL,G1H4(80),ex3(:),G1H2(80),m3h2x2(:,333),heltab2x4(:,:,393))
  call Hloop_VV_S(ntryL,G1H4(76),ex3(:),G1H2(81),m3h2x2(:,334),heltab2x4(:,:,394))
  call Hloop_SV_V(ntryL,G1H4(139),ex3(:),G1H2(91),m3h2x2(:,335),heltab2x4(:,:,395))
  call Hloop_SV_V(ntryL,G1H4(140),ex3(:),G1H2(92),m3h2x2(:,336),heltab2x4(:,:,396))
  call Hloop_UW_V(ntryL,G1H4(149),19,ex3(:),4,G2H2(141),m3h2x2(:,337),heltab2x4(:,:,397))
  call Hloop_UV_W(ntryL,G1H4(150),19,ex3(:),4,G2H2(21),m3h2x2(:,338),heltab2x4(:,:,398))
  call Hloop_AV_Q(ntryL,G1H4(215),ex3(:),G1H2(97),m3h2x2(:,339),heltab2x4(:,:,399))
  call Hloop_A_Q(ntryL,G1H2(97),23,0,G2H2(156),n2h2(239))
  call Hloop_QV_A(ntryL,G1H4(217),ex3(:),G1H2(103),m3h2x2(:,340),heltab2x4(:,:,400))
  call Hloop_Q_A(ntryL,G1H2(103),23,0,G2H2(75),n2h2(240))
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(192),[G1H2(101),G1H2(61),G1H2(202)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(495),[G1H2(437),G1H2(432),G1H2(430),G1H2(35),G1H2(164) &
    ,G1H2(238),G1H2(207)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(335),[G1H2(234)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(159),[G1H2(245)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(505),[G1H2(435),G1H2(3),G1H2(246)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(153),[G1H2(289)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(272),[G1H2(300)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(151),[G1H2(333),G1H2(301)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(185),[G1H2(440),G1H2(312)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(467),[G1H2(462),G1H2(460),G1H2(445),G1H2(316),G1H2(206) &
    ,G1H2(6),G1H2(317)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(2),[G1H2(283),G1H2(332)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(208),[G1H2(186),G1H2(447),G1H2(349)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(8),[G1H2(294),G1H2(538),G1H2(533),G1H2(30)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(212),[G1H2(196),G1H2(530),G1H2(450),G1H2(85)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(465),[G1H2(455),G1H2(26),G1H2(96)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(1),[G1H2(140)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(201),[G1H2(457),G1H2(195)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(117),[G1H2(114),G1H2(87),G1H2(305)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(233),[G1H2(343)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(40),[G1H2(25)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(248),[G1H2(75)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(323),[G1H2(459),G1H2(86)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(470),[G1H2(98)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(475),[G1H2(172),G1H2(130),G1H2(102)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(12),[G1H2(328),G1H2(156),G1H2(113)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(477),[G1H2(125)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(18),[G1H2(338),G1H2(529),G1H2(464),G1H2(62)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(534),[G1H2(480),G1H2(84)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(539),[G1H2(485),G1H2(293)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(344),[G1H2(145),G1H2(128)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(487),[G1H2(126)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(74),[G1H2(148)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(16),[G1H2(49),G1H2(194)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(278),[G1H2(490),G1H2(227)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(173),[G1H2(107),G1H2(260)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(296),[G1H2(279),G1H2(497),G1H2(282)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(184),[G1H2(118),G1H2(544),G1H2(325),G1H2(168)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(306),[G1H2(284),G1H2(542),G1H2(500),G1H2(179)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(162),[G1H2(15)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(295),[G1H2(507),G1H2(46)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(229),[G1H2(429),G1H2(56)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(510),[G1H2(72)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(515),[G1H2(221),G1H2(127),G1H2(89)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(252),[G1H2(235),G1H2(68),G1H2(94)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(517),[G1H2(123)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(256),[G1H2(240),G1H2(541),G1H2(434),G1H2(149)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(347),[G1H2(520),G1H2(177)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(545),[G1H2(525),G1H2(166)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(251),[G1H2(57),G1H2(189)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(527),[G1H2(204)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(414),[G1H2(409),G1H2(334)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(424),[G1H2(419),G1H2(146)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(39),[G1H2(64),G1H2(169)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(197),[G1H2(574),G1H2(163)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(410),[G1H2(390),G1H2(354)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(415),[G1H2(395),G1H2(355)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(47),[G1H2(91),G1H2(359)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(224),[G1H2(579),G1H2(360)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(420),[G1H2(400),G1H2(364)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(425),[G1H2(405),G1H2(365)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(394),[G1H2(389),G1H2(369)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(404),[G1H2(399),G1H2(374)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(113),[G1H2(299),G1H2(79),G1H2(444),G1H2(439)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(119),[G1H2(454),G1H2(449)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(310),[G1H2(167),G1H2(474),G1H2(469)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(484),[G1H2(479)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(35),[G1H2(321),G1H2(211),G1H2(494),G1H2(489)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(123),[G1H2(504),G1H2(499)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(342),[G1H2(255),G1H2(514),G1H2(509)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(524),[G1H2(519)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(112),[G1H4(167),G0H4(113)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(123),[G1H4(198),G1H4(168)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(156),[G1H4(174),G0H4(5)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(30),[G1H4(221),G1H4(175)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(111),[G1H4(182)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(117),[G1H4(191)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(130),[G1H4(205)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(124),[G1H4(212)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(11),[G1H4(227),G0H4(4)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(100),[G1H4(15),G1H4(228)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(104),[G1H4(234),G0H4(3)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(103),[G1H4(172),G1H4(235)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(99),[G1H4(23)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(106),[G1H4(74)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(102),[G1H4(39)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(105),[G1H4(83)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(241),[G1H2(345)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(290),[G1H2(554),G1H2(346)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(268),[G1H2(548)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(318),[G1H2(559),G1H2(549)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(43),[G1H2(76),G1H2(553)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(55),[G1H2(92),G1H2(558)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(339),[G1H2(573)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(63),[G1H2(578)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(71),[G2H2(149),G1H2(81)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(21),[G2H2(141),G1H2(80)])
  call Hloop_SA_Q(ntryL,G1H2(190),ex2(:),G1H1(1),ngH,m3h2x1(:,565),heltab2x2(:,:,565))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,nMT,G2tensor(347),n2h1(589))
  call Hloop_SA_Q(ntryL,G1H2(191),ex2(:),G1H1(1),ngH,m3h2x1(:,566),heltab2x2(:,:,566))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,nMT,G2tensor(182),n2h1(590))
  call Hloop_AV_Q(ntryL,G1H2(192),ex4(:),G1H1(1),m3h2x1(:,567),heltab2x2(:,:,567))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,nMT,G2tensor(181),n2h1(591))
  call Hloop_AV_Q(ntryL,G1H2(495),ex4(:),G1H1(1),m3h2x1(:,568),heltab2x2(:,:,568))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,nMT,G2tensor(5),n2h1(592))
  call Hloop_SA_Q(ntryL,G1H2(218),ex2(:),G1H1(1),ngX,m3h2x1(:,569),heltab2x2(:,:,569))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,nMT,G2tensor(2),n2h1(593))
  call Hloop_SA_Q(ntryL,G1H2(219),ex2(:),G1H1(1),ngX,m3h2x1(:,570),heltab2x2(:,:,570))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,nMT,G2tensor(545),n2h1(594))
  call Hloop_SA_Q(ntryL,G1H2(230),ex2(:),G1H1(1),ngPtb,m3h2x1(:,571),heltab2x2(:,:,571))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,nMB,G2tensor(119),n2h1(595))
  call Hloop_SA_Q(ntryL,G1H2(335),ex2(:),G1H1(1),ngPtb,m3h2x1(:,572),heltab2x2(:,:,572))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,nMB,G2tensor(6),n2h1(596))
  call Hloop_AV_Q(ntryL,G1H2(159),ex4(:),G1H1(1),m3h2x1(:,573),heltab2x2(:,:,573))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,nMB,G2tensor(3),n2h1(597))
  call Hloop_AV_Q(ntryL,G1H2(505),ex4(:),G1H1(1),m3h2x1(:,574),heltab2x2(:,:,574))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,nMB,G2tensor(365),n2h1(598))
  call Hloop_VA_Q(ntryL,G1H2(257),ex2(:),G1H1(1),m3h2x1(:,575),heltab2x2(:,:,575))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,nMT,G2tensor(184),n2h1(599))
  call Hloop_VA_Q(ntryL,G1H2(262),ex2(:),G1H1(1),m3h2x1(:,576),heltab2x2(:,:,576))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,nMT,G2tensor(183),n2h1(600))
  call Hloop_ZA_Q(ntryL,G1H2(273),ex2(:),G1H1(1),ngZu,m3h2x1(:,577),heltab2x2(:,:,577))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,nMT,G2tensor(11),n2h1(601))
  call Hloop_ZA_Q(ntryL,G1H2(274),ex2(:),G1H1(1),ngZu,m3h2x1(:,578),heltab2x2(:,:,578))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,nMT,G2tensor(8),n2h1(602))
  call Hloop_WA_Q(ntryL,G1H2(285),ex2(:),G1H1(1),m3h2x1(:,579),heltab2x2(:,:,579))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,nMB,G2tensor(515),n2h1(603))
  call Hloop_WA_Q(ntryL,G1H2(153),ex2(:),G1H1(1),m3h2x1(:,580),heltab2x2(:,:,580))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,nMB,G2tensor(125),n2h1(604))
  call Hloop_QV_A(ntryL,G1H2(272),ex3(:),G1H1(1),m3h2x1(:,581),heltab2x2(:,:,581))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,nMT,G2tensor(12),n2h1(605))
  call Hloop_QV_A(ntryL,G1H2(151),ex3(:),G1H1(1),m3h2x1(:,582),heltab2x2(:,:,582))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,nMT,G2tensor(9),n2h1(606))
  call Hloop_QV_A(ntryL,G1H2(185),ex4(:),G1H1(1),m3h2x1(:,583),heltab2x2(:,:,583))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,nMT,G2tensor(14),n2h1(607))
  call Hloop_QV_A(ntryL,G1H2(467),ex4(:),G1H1(1),m3h2x1(:,584),heltab2x2(:,:,584))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,nMT,G2tensor(15),n2h1(608))
  call Hloop_QV_A(ntryL,G1H2(2),ex3(:),G1H1(1),m3h2x1(:,585),heltab2x2(:,:,585))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,nMT,G2tensor(191),n2h1(609))
  call Hloop_QV_A(ntryL,G1H2(208),ex4(:),G1H1(1),m3h2x1(:,586),heltab2x2(:,:,586))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,nMT,G2tensor(18),n2h1(610))
  call Hloop_QV_A(ntryL,G1H2(8),ex3(:),G1H1(1),m3h2x1(:,587),heltab2x2(:,:,587))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,nMB,G2tensor(554),n2h1(611))
  call Hloop_QV_A(ntryL,G1H2(41),ex3(:),G1H1(1),m3h2x1(:,588),heltab2x2(:,:,588))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,nMB,G2tensor(19),n2h1(612))
  call Hloop_QV_A(ntryL,G1H2(212),ex4(:),G1H1(1),m3h2x1(:,589),heltab2x2(:,:,589))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,nMB,G2tensor(194),n2h1(613))
  call Hloop_QV_A(ntryL,G1H2(465),ex4(:),G1H1(1),m3h2x1(:,590),heltab2x2(:,:,590))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,nMB,G2tensor(22),n2h1(614))
  call Hloop_QV_A(ntryL,G1H2(1),ex3(:),G1H1(1),m3h2x1(:,591),heltab2x2(:,:,591))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,nMT,G2tensor(557),n2h1(615))
  call Hloop_QV_A(ntryL,G1H2(201),ex4(:),G1H1(1),m3h2x1(:,592),heltab2x2(:,:,592))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,nMT,G2tensor(23),n2h1(616))
  call Hloop_SQ_A(ntryL,G1H2(250),ex1(:),G1H1(1),ngH,m3h2x1(:,593),heltab2x2(:,:,593))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,nMT,G2tensor(26),n2h1(617))
  call Hloop_SQ_A(ntryL,G1H2(261),ex1(:),G1H1(1),ngH,m3h2x1(:,594),heltab2x2(:,:,594))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,nMT,G2tensor(27),n2h1(618))
  call Hloop_QV_A(ntryL,G1H2(117),ex4(:),G1H1(1),m3h2x1(:,595),heltab2x2(:,:,595))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,nMT,G2tensor(30),n2h1(619))
  call Hloop_SQ_A(ntryL,G1H2(322),ex1(:),G1H1(1),ngX,m3h2x1(:,596),heltab2x2(:,:,596))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,nMT,G2tensor(31),n2h1(620))
  call Hloop_SQ_A(ntryL,G1H2(7),ex1(:),G1H1(1),ngX,m3h2x1(:,597),heltab2x2(:,:,597))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,nMT,G2tensor(34),n2h1(621))
  call Hloop_SQ_A(ntryL,G1H2(14),ex1(:),G1H1(1),ngPbt,m3h2x1(:,598),heltab2x2(:,:,598))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,nMB,G2tensor(35),n2h1(622))
  call Hloop_SQ_A(ntryL,G1H2(233),ex1(:),G1H1(1),ngPbt,m3h2x1(:,599),heltab2x2(:,:,599))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,nMB,G2tensor(38),n2h1(623))
  call Hloop_QV_A(ntryL,G1H2(40),ex4(:),G1H1(1),m3h2x1(:,600),heltab2x2(:,:,600))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,nMB,G2tensor(39),n2h1(624))
  call Hloop_VQ_A(ntryL,G1H2(37),ex1(:),G1H1(1),m3h2x1(:,601),heltab2x2(:,:,601))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,nMT,G2tensor(42),n2h1(625))
  call Hloop_VQ_A(ntryL,G1H2(42),ex1(:),G1H1(1),m3h2x1(:,602),heltab2x2(:,:,602))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,nMT,G2tensor(43),n2h1(626))
  call Hloop_ZQ_A(ntryL,G1H2(53),ex1(:),G1H1(1),ngZu,m3h2x1(:,603),heltab2x2(:,:,603))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,nMT,G2tensor(46),n2h1(627))
  call Hloop_ZQ_A(ntryL,G1H2(54),ex1(:),G1H1(1),ngZu,m3h2x1(:,604),heltab2x2(:,:,604))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,nMT,G2tensor(47),n2h1(628))
  call Hloop_WQ_A(ntryL,G1H2(65),ex1(:),G1H1(1),m3h2x1(:,605),heltab2x2(:,:,605))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,nMB,G2tensor(239),n2h1(629))
  call Hloop_WQ_A(ntryL,G1H2(248),ex1(:),G1H1(1),m3h2x1(:,606),heltab2x2(:,:,606))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,nMB,G2tensor(50),n2h1(630))
  call Hloop_QV_A(ntryL,G1H2(323),ex4(:),G1H1(1),m3h2x1(:,607),heltab2x2(:,:,607))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,nMT,G2tensor(530),n2h1(631))
  call Hloop_QV_A(ntryL,G1H2(470),ex3(:),G1H1(1),m3h2x1(:,608),heltab2x2(:,:,608))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,nMT,G2tensor(51),n2h1(632))
  call Hloop_QV_A(ntryL,G1H2(475),ex3(:),G1H1(1),m3h2x1(:,609),heltab2x2(:,:,609))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,nMT,G2tensor(242),n2h1(633))
  call Hloop_QV_A(ntryL,G1H2(12),ex4(:),G1H1(1),m3h2x1(:,610),heltab2x2(:,:,610))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,nMT,G2tensor(54),n2h1(634))
  call Hloop_QV_A(ntryL,G1H2(477),ex3(:),G1H1(1),m3h2x1(:,611),heltab2x2(:,:,611))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,nMT,G2tensor(533),n2h1(635))
  call Hloop_QV_A(ntryL,G1H2(18),ex4(:),G1H1(1),m3h2x1(:,612),heltab2x2(:,:,612))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,nMB,G2tensor(55),n2h1(636))
  call Hloop_QV_A(ntryL,G1H2(534),ex3(:),G1H1(1),m3h2x1(:,613),heltab2x2(:,:,613))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,nMB,G2tensor(58),n2h1(637))
  call Hloop_QV_A(ntryL,G1H2(539),ex3(:),G1H1(1),m3h2x1(:,614),heltab2x2(:,:,614))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,nMB,G2tensor(59),n2h1(638))
  call Hloop_QV_A(ntryL,G1H2(344),ex4(:),G1H1(1),m3h2x1(:,615),heltab2x2(:,:,615))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,nMT,G2tensor(62),n2h1(639))
  call Hloop_QV_A(ntryL,G1H2(487),ex3(:),G1H1(1),m3h2x1(:,616),heltab2x2(:,:,616))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,nMT,G2tensor(66),n2h1(640))
  call Hloop_AV_Q(ntryL,G1H2(74),ex3(:),G1H1(1),m3h2x1(:,617),heltab2x2(:,:,617))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,nMT,G2tensor(70),n2h1(641))
  call Hloop_AV_Q(ntryL,G1H2(16),ex3(:),G1H1(1),m3h2x1(:,618),heltab2x2(:,:,618))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,nMT,G2tensor(74),n2h1(642))
  call Hloop_AV_Q(ntryL,G1H2(278),ex4(:),G1H1(1),m3h2x1(:,619),heltab2x2(:,:,619))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,nMT,G2tensor(78),n2h1(643))
  call Hloop_AV_Q(ntryL,G1H2(173),ex3(:),G1H1(1),m3h2x1(:,620),heltab2x2(:,:,620))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,nMT,G2tensor(79),n2h1(644))
  call Hloop_AV_Q(ntryL,G1H2(296),ex4(:),G1H1(1),m3h2x1(:,621),heltab2x2(:,:,621))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,nMT,G2tensor(82),n2h1(645))
  call Hloop_AV_Q(ntryL,G1H2(184),ex3(:),G1H1(1),m3h2x1(:,622),heltab2x2(:,:,622))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,nMB,G2tensor(83),n2h1(646))
  call Hloop_AV_Q(ntryL,G1H2(70),ex3(:),G1H1(1),m3h2x1(:,623),heltab2x2(:,:,623))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,nMB,G2tensor(86),n2h1(647))
  call Hloop_AV_Q(ntryL,G1H2(306),ex4(:),G1H1(1),m3h2x1(:,624),heltab2x2(:,:,624))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,nMB,G2tensor(87),n2h1(648))
  call Hloop_AV_Q(ntryL,G1H2(162),ex3(:),G1H1(1),m3h2x1(:,625),heltab2x2(:,:,625))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,nMT,G2tensor(90),n2h1(649))
  call Hloop_AV_Q(ntryL,G1H2(295),ex4(:),G1H1(1),m3h2x1(:,626),heltab2x2(:,:,626))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,nMT,G2tensor(91),n2h1(650))
  call Hloop_AV_Q(ntryL,G1H2(229),ex4(:),G1H1(1),m3h2x1(:,627),heltab2x2(:,:,627))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,nMT,G2tensor(94),n2h1(651))
  call Hloop_AV_Q(ntryL,G1H2(510),ex3(:),G1H1(1),m3h2x1(:,628),heltab2x2(:,:,628))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,nMT,G2tensor(98),n2h1(652))
  call Hloop_AV_Q(ntryL,G1H2(515),ex3(:),G1H1(1),m3h2x1(:,629),heltab2x2(:,:,629))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,nMT,G2tensor(102),n2h1(653))
  call Hloop_AV_Q(ntryL,G1H2(252),ex4(:),G1H1(1),m3h2x1(:,630),heltab2x2(:,:,630))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,nMT,G2tensor(106),n2h1(654))
  call Hloop_AV_Q(ntryL,G1H2(517),ex3(:),G1H1(1),m3h2x1(:,631),heltab2x2(:,:,631))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,nMT,G2tensor(329),n2h1(655))
  call Hloop_AV_Q(ntryL,G1H2(256),ex4(:),G1H1(1),m3h2x1(:,632),heltab2x2(:,:,632))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,nMB,G2tensor(110),n2h1(656))
  call Hloop_AV_Q(ntryL,G1H2(347),ex3(:),G1H1(1),m3h2x1(:,633),heltab2x2(:,:,633))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,nMB,G2tensor(521),n2h1(657))
  call Hloop_AV_Q(ntryL,G1H2(545),ex3(:),G1H1(1),m3h2x1(:,634),heltab2x2(:,:,634))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,nMB,G2tensor(111),n2h1(658))
  call Hloop_AV_Q(ntryL,G1H2(251),ex4(:),G1H1(1),m3h2x1(:,635),heltab2x2(:,:,635))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,nMT,G2tensor(335),n2h1(659))
  call Hloop_AV_Q(ntryL,G1H2(527),ex3(:),G1H1(1),m3h2x1(:,636),heltab2x2(:,:,636))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,nMT,G2tensor(114),n2h1(660))
  call Hloop_SQ_A(ntryL,G1H2(226),ex1(:),G1H1(1),ngPbt,m3h2x1(:,637),heltab2x2(:,:,637))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,nMB,G2tensor(509),n2h1(661))
  call Hloop_WQ_A(ntryL,G1H2(259),ex1(:),G1H1(1),m3h2x1(:,638),heltab2x2(:,:,638))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,nMB,G2tensor(115),n2h1(662))
  call Hloop_SQ_A(ntryL,G1H2(269),ex1(:),G1H1(1),ngPbt,m3h2x1(:,639),heltab2x2(:,:,639))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,nMB,G2tensor(341),n2h1(663))
  call Hloop_SQ_A(ntryL,G1H2(270),ex1(:),G1H1(1),ngPbt,m3h2x1(:,640),heltab2x2(:,:,640))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,nMB,G2tensor(118),n2h1(664))
  call Hloop_WQ_A(ntryL,G1H2(302),ex1(:),G1H1(1),m3h2x1(:,641),heltab2x2(:,:,641))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,nMB,G2tensor(359),n2h1(665))
  call Hloop_WQ_A(ntryL,G1H2(303),ex1(:),G1H1(1),m3h2x1(:,642),heltab2x2(:,:,642))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,nMB,G2tensor(124),n2h1(666))
  call Hloop_SA_Q(ntryL,G1H2(414),ex2(:),G1H1(1),ngPtb,m3h2x1(:,643),heltab2x2(:,:,643))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,nMB,G2tensor(371),n2h1(667))
  call Hloop_WA_Q(ntryL,G1H2(424),ex2(:),G1H1(1),m3h2x1(:,644),heltab2x2(:,:,644))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,nMB,G2tensor(374),n2h1(668))
  call Hcheck_last_SV_T(ntryL,l_switch,G2H2(39),23,ex4(:),8,G3tensor(1),m3h2x1(:,645),heltab2x2(:,:,645))
  call Hcheck_last_SV_T(ntryL,l_switch,G1H2(197),23,ex4(:),8,G2tensor(350),m3h2x1(:,646),heltab2x2(:,:,646))
  call Hloop_SA_Q(ntryL,G1H2(410),ex2(:),G1H1(1),ngPtb,m3h2x1(:,647),heltab2x2(:,:,647))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,nMB,G2tensor(383),n2h1(669))
  call Hloop_SA_Q(ntryL,G1H2(415),ex2(:),G1H1(1),ngPtb,m3h2x1(:,648),heltab2x2(:,:,648))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,nMB,G2tensor(386),n2h1(670))
  call Hcheck_last_UW_V(ntryL,l_switch,G2H2(47),23,ex4(:),8,G3tensor(2),m3h2x1(:,649),heltab2x2(:,:,649))
  call Hcheck_last_UW_V(ntryL,l_switch,G1H2(224),23,ex4(:),8,G2tensor(188),m3h2x1(:,650),heltab2x2(:,:,650))
  call Hloop_WA_Q(ntryL,G1H2(420),ex2(:),G1H1(1),m3h2x1(:,651),heltab2x2(:,:,651))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,nMB,G2tensor(197),n2h1(671))
  call Hloop_WA_Q(ntryL,G1H2(425),ex2(:),G1H1(1),m3h2x1(:,652),heltab2x2(:,:,652))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,nMB,G2tensor(410),n2h1(672))
  call Hloop_SA_Q(ntryL,G1H2(394),ex2(:),G1H1(1),ngPtb,m3h2x1(:,653),heltab2x2(:,:,653))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,nMB,G2tensor(419),n2h1(673))
  call Hloop_SA_Q(ntryL,G1H2(370),ex2(:),G1H1(1),ngPtb,m3h2x1(:,654),heltab2x2(:,:,654))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,nMB,G2tensor(440),n2h1(674))
  call Hloop_WA_Q(ntryL,G1H2(404),ex2(:),G1H1(1),m3h2x1(:,655),heltab2x2(:,:,655))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,nMB,G2tensor(449),n2h1(675))
  call Hloop_WA_Q(ntryL,G1H2(375),ex2(:),G1H1(1),m3h2x1(:,656),heltab2x2(:,:,656))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,nMB,G2tensor(569),n2h1(676))
  call Hcheck_last_SV_T(ntryL,l_switch,G1H2(379),27,ex3(:),4,G2tensor(174),m3h2x1(:,657),heltab2x2(:,:,657))
  call Hcheck_last_SV_T(ntryL,l_switch,G1H2(380),27,ex3(:),4,G2tensor(173),m3h2x1(:,658),heltab2x2(:,:,658))
  call Hcheck_last_UW_V(ntryL,l_switch,G1H2(384),27,ex3(:),4,G2tensor(575),m3h2x1(:,659),heltab2x2(:,:,659))
  call Hcheck_last_UW_V(ntryL,l_switch,G1H2(385),27,ex3(:),4,G2tensor(176),m3h2x1(:,660),heltab2x2(:,:,660))
  call Hloop_QV_A(ntryL,G2H2(113),ex4(:),G2H1(1),m3h2x1(:,661),heltab2x2(:,:,661))
  call Hcheck_last_Q_A(ntryL,l_switch,G2H1(1),31,nMT,G3tensor(3),n2h1(677))
  call Hloop_QV_A(ntryL,G2H2(119),ex4(:),G2H1(1),m3h2x1(:,662),heltab2x2(:,:,662))
  call Hcheck_last_Q_A(ntryL,l_switch,G2H1(1),31,nMB,G3tensor(4),n2h1(678))
  call Hloop_QV_A(ntryL,G1H2(310),ex3(:),G1H1(1),m3h2x1(:,663),heltab2x2(:,:,663))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,nMT,G2tensor(175),n2h1(679))
  call Hloop_QV_A(ntryL,G1H2(484),ex3(:),G1H1(1),m3h2x1(:,664),heltab2x2(:,:,664))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,nMB,G2tensor(581),n2h1(680))
  call Hloop_AV_Q(ntryL,G2H2(35),ex4(:),G2H1(1),m3h2x1(:,665),heltab2x2(:,:,665))
  call Hcheck_last_A_Q(ntryL,l_switch,G2H1(1),31,nMT,G3tensor(5),n2h1(681))
  call Hloop_AV_Q(ntryL,G2H2(123),ex4(:),G2H1(1),m3h2x1(:,666),heltab2x2(:,:,666))
  call Hcheck_last_A_Q(ntryL,l_switch,G2H1(1),31,nMB,G3tensor(6),n2h1(682))
  call Hloop_AV_Q(ntryL,G1H2(342),ex3(:),G1H1(1),m3h2x1(:,667),heltab2x2(:,:,667))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,nMT,G2tensor(178),n2h1(683))
  call Hloop_AV_Q(ntryL,G1H2(524),ex3(:),G1H1(1),m3h2x1(:,668),heltab2x2(:,:,668))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,nMB,G2tensor(177),n2h1(684))
  call Hloop_SQ_A(ntryL,G1H4(137),wf4(:,3),G1H1(1),ngPbt,m3h4x1(:,61),heltab2x4(:,:,401))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,nMB,G2tensor(587),n2h1(685))
  call Hloop_SQ_A(ntryL,G1H4(138),wf4(:,3),G1H1(1),ngPbt,m3h4x1(:,62),heltab2x4(:,:,402))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,nMB,G2tensor(180),n2h1(686))
  call Hloop_WQ_A(ntryL,G1H4(144),wf4(:,3),G1H1(1),m3h4x1(:,63),heltab2x4(:,:,403))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,nMB,G2tensor(179),n2h1(687))
  call Hloop_WQ_A(ntryL,G1H4(145),wf4(:,3),G1H1(1),m3h4x1(:,64),heltab2x4(:,:,404))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,nMB,G2tensor(353),n2h1(688))
  call Hloop_SA_Q(ntryL,G1H4(151),wf4(:,10),G1H1(1),ngPtb,m3h4x1(:,65),heltab2x4(:,:,405))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,nMB,G2tensor(548),n2h1(689))
  call Hloop_SA_Q(ntryL,G1H4(152),wf4(:,10),G1H1(1),ngPtb,m3h4x1(:,66),heltab2x4(:,:,406))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,nMB,G2tensor(368),n2h1(690))
  call Hloop_WA_Q(ntryL,G1H4(158),wf4(:,10),G1H1(1),m3h4x1(:,67),heltab2x4(:,:,407))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,nMB,G2tensor(518),n2h1(691))
  call Hloop_WA_Q(ntryL,G1H4(161),wf4(:,10),G1H1(1),m3h4x1(:,68),heltab2x4(:,:,408))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,nMB,G2tensor(185),n2h1(692))
  call Hloop_SQ_A(ntryL,G1H4(112),wf4(:,9),G1H1(1),ngPbt,m3h4x1(:,69),heltab2x4(:,:,409))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,nMB,G2tensor(551),n2h1(693))
  call Hloop_SQ_A(ntryL,G1H4(123),wf4(:,9),G1H1(1),ngPbt,m3h4x1(:,70),heltab2x4(:,:,410))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,nMB,G2tensor(203),n2h1(694))
  call Hloop_WQ_A(ntryL,G1H4(156),wf4(:,9),G1H1(1),m3h4x1(:,71),heltab2x4(:,:,411))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,nMB,G2tensor(563),n2h1(695))
  call Hloop_WQ_A(ntryL,G1H4(30),wf4(:,9),G1H1(1),m3h4x1(:,72),heltab2x4(:,:,412))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,nMB,G2tensor(206),n2h1(696))
  call Hloop_SQ_A(ntryL,G1H4(181),wf4(:,9),G1H1(1),ngH,m3h4x1(:,73),heltab2x4(:,:,413))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,nMT,G2tensor(566),n2h1(697))
  call Hloop_SQ_A(ntryL,G1H4(111),wf4(:,9),G1H1(1),ngH,m3h4x1(:,74),heltab2x4(:,:,414))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,nMT,G2tensor(200),n2h1(698))
  call Hloop_SQ_A(ntryL,G1H4(188),wf4(:,9),G1H1(1),ngX,m3h4x1(:,75),heltab2x4(:,:,415))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,nMT,G2tensor(560),n2h1(699))
  call Hloop_SQ_A(ntryL,G1H4(117),wf4(:,9),G1H1(1),ngX,m3h4x1(:,76),heltab2x4(:,:,416))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,nMT,G2tensor(209),n2h1(700))
  call Hloop_SQ_A(ntryL,G1H4(197),wf4(:,9),G1H1(1),ngPbt,m3h4x1(:,77),heltab2x4(:,:,417))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,nMB,G2tensor(63),n2h1(701))
  call Hloop_VQ_A(ntryL,G1H4(204),wf4(:,9),G1H1(1),m3h4x1(:,78),heltab2x4(:,:,418))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,nMT,G2tensor(215),n2h1(702))
  call Hloop_VQ_A(ntryL,G1H4(130),wf4(:,9),G1H1(1),m3h4x1(:,79),heltab2x4(:,:,419))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,nMT,G2tensor(67),n2h1(703))
  call Hloop_ZQ_A(ntryL,G1H4(211),wf4(:,9),G1H1(1),ngZu,m3h4x1(:,80),heltab2x4(:,:,420))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,nMT,G2tensor(221),n2h1(704))
  call Hloop_ZQ_A(ntryL,G1H4(124),wf4(:,9),G1H1(1),ngZu,m3h4x1(:,81),heltab2x4(:,:,421))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,nMT,G2tensor(71),n2h1(705))
  call Hloop_WQ_A(ntryL,G1H4(218),wf4(:,9),G1H1(1),m3h4x1(:,82),heltab2x4(:,:,422))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,nMB,G2tensor(227),n2h1(706))
  call Hloop_SA_Q(ntryL,G1H4(11),wf4(:,4),G1H1(1),ngPtb,m3h4x1(:,83),heltab2x4(:,:,423))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,nMB,G2tensor(75),n2h1(707))
  call Hloop_SA_Q(ntryL,G1H4(100),wf4(:,4),G1H1(1),ngPtb,m3h4x1(:,84),heltab2x4(:,:,424))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,nMB,G2tensor(233),n2h1(708))
  call Hloop_WA_Q(ntryL,G1H4(104),wf4(:,4),G1H1(1),m3h4x1(:,85),heltab2x4(:,:,425))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,nMB,G2tensor(527),n2h1(709))
  call Hloop_WA_Q(ntryL,G1H4(103),wf4(:,4),G1H1(1),m3h4x1(:,86),heltab2x4(:,:,426))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,nMB,G2tensor(251),n2h1(710))
  call Hloop_SA_Q(ntryL,G1H4(19),wf4(:,4),G1H1(1),ngH,m3h4x1(:,87),heltab2x4(:,:,427))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,nMT,G2tensor(539),n2h1(711))
  call Hloop_SA_Q(ntryL,G1H4(99),wf4(:,4),G1H1(1),ngH,m3h4x1(:,88),heltab2x4(:,:,428))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,nMT,G2tensor(254),n2h1(712))
  call Hloop_SA_Q(ntryL,G1H4(73),wf4(:,4),G1H1(1),ngX,m3h4x1(:,89),heltab2x4(:,:,429))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,nMT,G2tensor(542),n2h1(713))
  call Hloop_SA_Q(ntryL,G1H4(106),wf4(:,4),G1H1(1),ngX,m3h4x1(:,90),heltab2x4(:,:,430))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,nMT,G2tensor(248),n2h1(714))
  call Hloop_SA_Q(ntryL,G1H4(196),wf4(:,4),G1H1(1),ngPtb,m3h4x1(:,91),heltab2x4(:,:,431))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,nMB,G2tensor(536),n2h1(715))
  call Hloop_VA_Q(ntryL,G1H4(34),wf4(:,4),G1H1(1),m3h4x1(:,92),heltab2x4(:,:,432))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,nMT,G2tensor(257),n2h1(716))
  call Hloop_VA_Q(ntryL,G1H4(102),wf4(:,4),G1H1(1),m3h4x1(:,93),heltab2x4(:,:,433))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,nMT,G2tensor(263),n2h1(717))
  call Hloop_ZA_Q(ntryL,G1H4(45),wf4(:,4),G1H1(1),ngZu,m3h4x1(:,94),heltab2x4(:,:,434))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,nMT,G2tensor(269),n2h1(718))
  call Hloop_ZA_Q(ntryL,G1H4(105),wf4(:,4),G1H1(1),ngZu,m3h4x1(:,95),heltab2x4(:,:,435))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,nMT,G2tensor(275),n2h1(719))
  call Hloop_WA_Q(ntryL,G1H4(70),wf4(:,4),G1H1(1),m3h4x1(:,96),heltab2x4(:,:,436))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,nMB,G2tensor(281),n2h1(720))
  call Hcheck_last_TV_S(ntryL,l_switch,G1H2(241),23,ex4(:),8,G2tensor(95),m3h2x1(:,669),heltab2x2(:,:,669))
  call Hcheck_last_TV_S(ntryL,l_switch,G1H2(290),23,ex4(:),8,G2tensor(287),m3h2x1(:,670),heltab2x2(:,:,670))
  call Hcheck_last_UV_W(ntryL,l_switch,G1H2(268),23,ex4(:),8,G2tensor(99),m3h2x1(:,671),heltab2x2(:,:,671))
  call Hcheck_last_UV_W(ntryL,l_switch,G1H2(318),23,ex4(:),8,G2tensor(293),m3h2x1(:,672),heltab2x2(:,:,672))
  call Hcheck_last_TV_S(ntryL,l_switch,G2H2(43),23,ex4(:),8,G3tensor(7),m3h2x1(:,673),heltab2x2(:,:,673))
  call Hcheck_last_UV_W(ntryL,l_switch,G2H2(55),23,ex4(:),8,G3tensor(8),m3h2x1(:,674),heltab2x2(:,:,674))
  call Hcheck_last_TV_S(ntryL,l_switch,G1H2(563),27,ex3(:),4,G2tensor(103),m3h2x1(:,675),heltab2x2(:,:,675))
  call Hcheck_last_TV_S(ntryL,l_switch,G1H2(564),27,ex3(:),4,G2tensor(299),m3h2x1(:,676),heltab2x2(:,:,676))
  call Hcheck_last_UV_W(ntryL,l_switch,G1H2(568),27,ex3(:),4,G2tensor(107),m3h2x1(:,677),heltab2x2(:,:,677))
  call Hcheck_last_UV_W(ntryL,l_switch,G1H2(569),27,ex3(:),4,G2tensor(305),m3h2x1(:,678),heltab2x2(:,:,678))
  call Hcheck_last_SV_T(ntryL,l_switch,G1H2(339),23,ex4(:),8,G2tensor(311),m3h2x1(:,679),heltab2x2(:,:,679))
  call Hcheck_last_UW_V(ntryL,l_switch,G1H2(63),23,ex4(:),8,G2tensor(317),m3h2x1(:,680),heltab2x2(:,:,680))
  call Hcheck_last_SVV_S(ntryL,l_switch,G1H4(82),ex4(:),ex3(:),G1tensor(1),m4h2x2x1(:,1),heltab3x4(:,:,1))
  call Hcheck_last_VWW_V(ntryL,l_switch,G1H4(88),ex4(:),ex3(:),G1tensor(31),m4h2x2x1(:,2),heltab3x4(:,:,2))
  call Hcheck_last_SVV_S(ntryL,l_switch,G1H4(178),ex4(:),ex3(:),G1tensor(61),m4h2x2x1(:,3),heltab3x4(:,:,3))
  call Hcheck_last_VWW_V(ntryL,l_switch,G1H4(94),ex4(:),ex3(:),G1tensor(91),m4h2x2x1(:,4),heltab3x4(:,:,4))
  call Hcheck_last_SV_V(ntryL,l_switch,G1H2(213),ex4(:),G1tensor(121),m3h2x1(:,681),heltab2x2(:,:,681))
  call Hcheck_last_VV_S(ntryL,l_switch,G1H2(223),ex4(:),G1tensor(151),m3h2x1(:,682),heltab2x2(:,:,682))
  call Hloop_SQ_A(ntryL,G1H8(25),wf8(:,26),G1H1(1),ngH,m3h8x1(:,1),heltab2x8(:,:,237))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,nMT,G2tensor(323),n2h1(721))
  call Hloop_SQ_A(ntryL,G1H8(26),wf8(:,26),G1H1(1),ngX,m3h8x1(:,2),heltab2x8(:,:,238))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,nMT,G2tensor(332),n2h1(722))
  call Hloop_SQ_A(ntryL,G1H8(27),wf8(:,26),G1H1(1),ngPbt,m3h8x1(:,3),heltab2x8(:,:,239))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,nMB,G2tensor(524),n2h1(723))
  call Hloop_VQ_A(ntryL,G1H8(28),wf8(:,26),G1H1(1),m3h8x1(:,4),heltab2x8(:,:,240))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,nMT,G2tensor(338),n2h1(724))
  call Hloop_ZQ_A(ntryL,G1H8(29),wf8(:,26),G1H1(1),ngZu,m3h8x1(:,5),heltab2x8(:,:,241))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,nMT,G2tensor(512),n2h1(725))
  call Hloop_WQ_A(ntryL,G1H8(30),wf8(:,26),G1H1(1),m3h8x1(:,6),heltab2x8(:,:,242))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,nMB,G2tensor(344),n2h1(726))
  call Hcheck_last_SV_V(ntryL,l_switch,G1H2(263),ex4(:),G1tensor(2),m3h2x1(:,683),heltab2x2(:,:,683))
  call Hcheck_last_VV_S(ntryL,l_switch,G1H2(267),ex4(:),G1tensor(12),m3h2x1(:,684),heltab2x2(:,:,684))
  call Hcheck_last_VV_S(ntryL,l_switch,G1H2(307),ex4(:),G1tensor(26),m3h2x1(:,685),heltab2x2(:,:,685))
  call Hcheck_last_SV_V(ntryL,l_switch,G1H2(311),ex4(:),G1tensor(90),m3h2x1(:,686),heltab2x2(:,:,686))
  call Hloop_SA_Q(ntryL,G1H8(31),wf8(:,31),G1H1(1),ngH,m3h8x1(:,7),heltab2x8(:,:,243))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,nMT,G2tensor(362),n2h1(727))
  call Hloop_SA_Q(ntryL,G1H8(32),wf8(:,31),G1H1(1),ngX,m3h8x1(:,8),heltab2x8(:,:,244))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,nMT,G2tensor(377),n2h1(728))
  call Hloop_SA_Q(ntryL,G1H8(33),wf8(:,31),G1H1(1),ngPtb,m3h8x1(:,9),heltab2x8(:,:,245))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,nMB,G2tensor(380),n2h1(729))
  call Hloop_VA_Q(ntryL,G1H8(34),wf8(:,31),G1H1(1),m3h8x1(:,10),heltab2x8(:,:,246))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,nMT,G2tensor(356),n2h1(730))
  call Hloop_ZA_Q(ntryL,G1H8(35),wf8(:,31),G1H1(1),ngZu,m3h8x1(:,11),heltab2x8(:,:,247))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,nMT,G2tensor(389),n2h1(731))
  call Hloop_WA_Q(ntryL,G1H8(36),wf8(:,31),G1H1(1),m3h8x1(:,12),heltab2x8(:,:,248))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,nMB,G2tensor(392),n2h1(732))
  call Hcheck_last_SV_V(ntryL,l_switch,G1H2(24),ex4(:),G1tensor(50),m3h2x1(:,687),heltab2x2(:,:,687))
  call Hcheck_last_VV_S(ntryL,l_switch,G1H2(52),ex4(:),G1tensor(60),m3h2x1(:,688),heltab2x2(:,:,688))
  call Hcheck_last_AQ_S(ntryL,l_switch,G2H4(12),wf4(:,9),G2tensor(395),ngH,m3h4x1(:,97),heltab2x4(:,:,437))
  call Hcheck_last_AQ_S(ntryL,l_switch,G2H4(10),wf4(:,9),G2tensor(236),ngX,m3h4x1(:,98),heltab2x4(:,:,438))
  call Hcheck_last_AQ_S(ntryL,l_switch,G2H4(13),wf4(:,9),G2tensor(398),ngPbt,m3h4x1(:,99),heltab2x4(:,:,439))
  call Hcheck_last_AQ_V(ntryL,l_switch,G2H4(14),wf4(:,9),G2tensor(401),m3h4x1(:,100),heltab2x4(:,:,440))
  call Hcheck_last_AQ_Z(ntryL,l_switch,G2H4(15),wf4(:,9),G2tensor(245),ngZu,m3h4x1(:,101),heltab2x4(:,:,441))
  call Hcheck_last_AQ_W(ntryL,l_switch,G2H4(16),wf4(:,9),G2tensor(404),m3h4x1(:,102),heltab2x4(:,:,442))
  call Hloop_SQ_A(ntryL,G1H8(37),wf8(:,35),G1H1(1),ngH,m3h8x1(:,13),heltab2x8(:,:,249))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,nMT,G2tensor(407),n2h1(733))
  call Hloop_SQ_A(ntryL,G1H8(38),wf8(:,35),G1H1(1),ngX,m3h8x1(:,14),heltab2x8(:,:,250))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,nMT,G2tensor(458),n2h1(734))
  call Hloop_SQ_A(ntryL,G1H8(39),wf8(:,35),G1H1(1),ngPbt,m3h8x1(:,15),heltab2x8(:,:,251))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,nMB,G2tensor(212),n2h1(735))
  call Hloop_VQ_A(ntryL,G1H8(40),wf8(:,35),G1H1(1),m3h8x1(:,16),heltab2x8(:,:,252))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,nMT,G2tensor(413),n2h1(736))
  call Hloop_ZQ_A(ntryL,G1H8(41),wf8(:,35),G1H1(1),ngZu,m3h8x1(:,17),heltab2x8(:,:,253))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,nMT,G2tensor(218),n2h1(737))
  call Hloop_WQ_A(ntryL,G1H8(42),wf8(:,35),G1H1(1),m3h8x1(:,18),heltab2x8(:,:,254))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,nMB,G2tensor(416),n2h1(738))
  call Hcheck_last_TV_S(ntryL,l_switch,G1H2(129),27,ex3(:),4,G2tensor(467),m3h2x1(:,689),heltab2x2(:,:,689))
  call Hcheck_last_SV_V(ntryL,l_switch,G1H2(217),ex3(:),G1tensor(74),m3h2x1(:,690),heltab2x2(:,:,690))
  call Hcheck_last_VV_S(ntryL,l_switch,G1H2(228),ex3(:),G1tensor(63),m3h2x1(:,691),heltab2x2(:,:,691))
  call Hcheck_last_UV_W(ntryL,l_switch,G1H2(239),27,ex3(:),4,G2tensor(224),m3h2x1(:,692),heltab2x2(:,:,692))
  call Hcheck_last_QA_S(ntryL,l_switch,G2H4(17),wf4(:,4),G2tensor(422),ngH,m3h4x1(:,103),heltab2x4(:,:,443))
  call Hcheck_last_QA_S(ntryL,l_switch,G2H4(18),wf4(:,4),G2tensor(230),ngX,m3h4x1(:,104),heltab2x4(:,:,444))
  call Hcheck_last_QA_S(ntryL,l_switch,G2H4(19),wf4(:,4),G2tensor(425),ngPtb,m3h4x1(:,105),heltab2x4(:,:,445))
  call Hcheck_last_QA_V(ntryL,l_switch,G2H4(23),wf4(:,4),G2tensor(428),m3h4x1(:,106),heltab2x4(:,:,446))
  call Hcheck_last_QA_Z(ntryL,l_switch,G2H4(24),wf4(:,4),G2tensor(431),ngZu,m3h4x1(:,107),heltab2x4(:,:,447))
  call Hcheck_last_QA_W(ntryL,l_switch,G2H4(22),wf4(:,4),G2tensor(434),m3h4x1(:,108),heltab2x4(:,:,448))
  call Hloop_SA_Q(ntryL,G1H8(43),wf8(:,37),G1H1(1),ngH,m3h8x1(:,19),heltab2x8(:,:,255))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,nMT,G2tensor(437),n2h1(739))
  call Hloop_SA_Q(ntryL,G1H8(44),wf8(:,37),G1H1(1),ngX,m3h8x1(:,20),heltab2x8(:,:,256))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,nMT,G2tensor(476),n2h1(740))
  call Hloop_SA_Q(ntryL,G1H8(45),wf8(:,37),G1H1(1),ngPtb,m3h8x1(:,21),heltab2x8(:,:,257))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,nMB,G2tensor(260),n2h1(741))
  call Hloop_VA_Q(ntryL,G1H8(46),wf8(:,37),G1H1(1),m3h8x1(:,22),heltab2x8(:,:,258))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,nMT,G2tensor(443),n2h1(742))
  call Hloop_ZA_Q(ntryL,G1H8(47),wf8(:,37),G1H1(1),ngZu,m3h8x1(:,23),heltab2x8(:,:,259))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,nMT,G2tensor(266),n2h1(743))
  call Hloop_WA_Q(ntryL,G1H8(48),wf8(:,37),G1H1(1),m3h8x1(:,24),heltab2x8(:,:,260))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,nMB,G2tensor(446),n2h1(744))
  call Hcheck_last_SV_T(ntryL,l_switch,G1H2(337),27,ex3(:),4,G2tensor(485),m3h2x1(:,693),heltab2x2(:,:,693))
  call Hcheck_last_SV_V(ntryL,l_switch,G1H2(327),ex3(:),G1tensor(104),m3h2x1(:,694),heltab2x2(:,:,694))
  call Hcheck_last_VV_S(ntryL,l_switch,G1H2(13),ex3(:),G1tensor(116),m3h2x1(:,695),heltab2x2(:,:,695))
  call Hcheck_last_UW_V(ntryL,l_switch,G1H2(19),27,ex3(:),4,G2tensor(272),m3h2x1(:,696),heltab2x2(:,:,696))
  call Hloop_AV_Q(ntryL,G2H2(19),ex4(:),G2H1(1),m3h2x1(:,697),heltab2x2(:,:,697))
  call Hcheck_last_A_Q(ntryL,l_switch,G2H1(1),31,nME,G3tensor(9),n2h1(745))
  call Hloop_AV_Q(ntryL,G2H2(11),ex4(:),G2H1(1),m3h2x1(:,698),heltab2x2(:,:,698))
  call Hcheck_last_A_Q(ntryL,l_switch,G2H1(1),31,nMM,G3tensor(10),n2h1(746))
  call Hloop_AV_Q(ntryL,G2H2(7),ex4(:),G2H1(1),m3h2x1(:,699),heltab2x2(:,:,699))
  call Hcheck_last_A_Q(ntryL,l_switch,G2H1(1),31,nML,G3tensor(11),n2h1(747))
  call Hloop_QV_A(ntryL,G2H2(15),ex4(:),G2H1(1),m3h2x1(:,700),heltab2x2(:,:,700))
  call Hcheck_last_Q_A(ntryL,l_switch,G2H1(1),31,nME,G3tensor(12),n2h1(748))
  call Hloop_QV_A(ntryL,G2H2(31),ex4(:),G2H1(1),m3h2x1(:,701),heltab2x2(:,:,701))
  call Hcheck_last_Q_A(ntryL,l_switch,G2H1(1),31,nMM,G3tensor(13),n2h1(749))
  call Hloop_QV_A(ntryL,G2H2(112),ex4(:),G2H1(1),m3h2x1(:,702),heltab2x2(:,:,702))
  call Hcheck_last_Q_A(ntryL,l_switch,G2H1(1),31,nML,G3tensor(14),n2h1(750))
  call Hcheck_last_DV_C(ntryL,l_switch,G2H2(59),23,ex4(:),G3tensor(15),m3h2x1(:,703),heltab2x2(:,:,703))
  call Hcheck_last_CV_D(ntryL,l_switch,G2H2(51),23,ex4(:),8,G3tensor(16),m3h2x1(:,704),heltab2x2(:,:,704))
  call Hcheck_last_SV_V(ntryL,l_switch,G2H2(71),ex4(:),G2tensor(452),m3h2x1(:,705),heltab2x2(:,:,705))
  call Hcheck_last_VV_S(ntryL,l_switch,G2H2(21),ex4(:),G2tensor(278),m3h2x1(:,706),heltab2x2(:,:,706))
  call Hloop_AV_Q(ntryL,G2H2(156),ex4(:),G2H1(1),m3h2x1(:,707),heltab2x2(:,:,707))
  call Hcheck_last_A_Q(ntryL,l_switch,G2H1(1),31,0,G3tensor(17),n2h1(751))
  call Hloop_QV_A(ntryL,G2H2(75),ex4(:),G2H1(1),m3h2x1(:,708),heltab2x2(:,:,708))
  call Hcheck_last_Q_A(ntryL,l_switch,G2H1(1),31,0,G3tensor(18),n2h1(752))
  call ol_merge_tensors(G2tensor(552),[G2tensor(186),G2tensor(16),G1tensor(157),G1tensor(127),G0tensor(27),G0tensor(22)])
  call ol_merge_tensors(G2tensor(564),[G2tensor(555),G2tensor(204),G2tensor(192),G2tensor(20),G1tensor(14),G1tensor(174) &
    ,G0tensor(37),G0tensor(32)])
  call ol_merge_tensors(G2tensor(591),[G2tensor(588),G2tensor(567),G2tensor(558),G2tensor(207),G2tensor(195),G2tensor(24) &
    ,G1tensor(552),G1tensor(42),G1tensor(30),G0tensor(552),G0tensor(47),G0tensor(42)])
  call ol_merge_tensors(G2tensor(561),[G2tensor(201),G2tensor(28),G1tensor(62),G1tensor(102),G0tensor(57),G0tensor(52)])
  call ol_merge_tensors(G2tensor(26),[G2tensor(258),G2tensor(210),G2tensor(64),G2tensor(32),G1tensor(142),G1tensor(9),G1tensor(92) &
    ,G1tensor(78),G0tensor(142),G0tensor(103),G0tensor(67),G0tensor(62)])
  call ol_merge_tensors(G2tensor(46),[G2tensor(31),G2tensor(264),G2tensor(216),G2tensor(68),G2tensor(36),G1tensor(89) &
    ,G1tensor(172),G1tensor(144),G1tensor(81),G0tensor(147),G0tensor(113),G0tensor(77),G0tensor(72)])
  call ol_merge_tensors(G2tensor(239),[G2tensor(35),G2tensor(270),G2tensor(222),G2tensor(72),G2tensor(40),G1tensor(100) &
    ,G1tensor(46),G1tensor(140),G1tensor(128),G0tensor(152),G0tensor(123),G0tensor(87),G0tensor(82)])
  call ol_merge_tensors(G2tensor(42),[G2tensor(276),G2tensor(228),G2tensor(76),G2tensor(44),G1tensor(111),G1tensor(57) &
    ,G1tensor(170),G1tensor(33),G0tensor(157),G0tensor(133),G0tensor(97),G0tensor(92)])
  call ol_merge_tensors(G2tensor(528),[G2tensor(234),G2tensor(48),G1tensor(71),G1tensor(5),G0tensor(107),G0tensor(102)])
  call ol_merge_tensors(G2tensor(540),[G2tensor(531),G2tensor(252),G2tensor(240),G2tensor(52),G1tensor(34),G1tensor(22) &
    ,G0tensor(117),G0tensor(112)])
  call ol_merge_tensors(G2tensor(573),[G2tensor(570),G2tensor(543),G2tensor(534),G2tensor(255),G2tensor(243),G2tensor(56) &
    ,G1tensor(537),G1tensor(47),G1tensor(58),G0tensor(537),G0tensor(127),G0tensor(122)])
  call ol_merge_tensors(G2tensor(537),[G2tensor(249),G2tensor(60),G1tensor(160),G1tensor(53),G0tensor(137),G0tensor(132)])
  call ol_merge_tensors(G2tensor(347),[G2tensor(306),G2tensor(282),G2tensor(96),G2tensor(80),G1tensor(202),G1tensor(137) &
    ,G1tensor(173),G1tensor(133),G0tensor(202),G0tensor(167),G0tensor(162),G0tensor(23)])
  call ol_merge_tensors(G2tensor(11),[G2tensor(2),G2tensor(312),G2tensor(288),G2tensor(100),G2tensor(84),G1tensor(207) &
    ,G1tensor(166),G1tensor(149),G1tensor(6),G0tensor(207),G0tensor(177),G0tensor(172),G0tensor(33)])
  call ol_merge_tensors(G2tensor(515),[G2tensor(119),G2tensor(318),G2tensor(294),G2tensor(104),G2tensor(88),G1tensor(212) &
    ,G1tensor(187),G1tensor(182),G1tensor(32),G0tensor(212),G0tensor(187),G0tensor(182),G0tensor(43)])
  call ol_merge_tensors(G2tensor(184),[G2tensor(324),G2tensor(300),G2tensor(108),G2tensor(92),G1tensor(217),G1tensor(197) &
    ,G1tensor(192),G1tensor(54),G0tensor(217),G0tensor(197),G0tensor(192),G0tensor(53)])
  call ol_merge_tensors(G2tensor(224),[G2tensor(467),G2tensor(579),G2tensor(576),G2tensor(525),G2tensor(522),G2tensor(333) &
    ,G2tensor(330),G2tensor(112),G1tensor(63),G1tensor(74),G1tensor(542),G1tensor(227),G1tensor(222),G0tensor(542),G0tensor(227) &
    ,G0tensor(222)])
  call ol_merge_tensors(G2tensor(99),[G2tensor(95),G2tensor(585),G2tensor(582),G2tensor(513),G2tensor(510),G2tensor(339) &
    ,G2tensor(336),G2tensor(116),G1tensor(12),G1tensor(2),G1tensor(547),G1tensor(538),G1tensor(237),G1tensor(232),G0tensor(547) &
    ,G0tensor(538),G0tensor(237),G0tensor(232)])
  call ol_merge_tensors(G2tensor(272),[G2tensor(485),G2tensor(549),G2tensor(546),G2tensor(354),G2tensor(348),G2tensor(345) &
    ,G2tensor(342),G2tensor(122),G2tensor(121),G2tensor(120),G1tensor(116),G1tensor(104),G1tensor(242),G1tensor(37),G1tensor(7) &
    ,G0tensor(242),G0tensor(7),G0tensor(2)])
  call ol_merge_tensors(G2tensor(317),[G2tensor(311),G2tensor(519),G2tensor(516),G2tensor(369),G2tensor(366),G2tensor(363) &
    ,G2tensor(360),G2tensor(128),G2tensor(127),G2tensor(126),G1tensor(60),G1tensor(50),G1tensor(553),G1tensor(247),G1tensor(97) &
    ,G1tensor(67),G0tensor(553),G0tensor(247),G0tensor(17),G0tensor(12)])
  call ol_merge_tensors(G2tensor(539),[G2tensor(309),G2tensor(307),G2tensor(1),G1tensor(472),G1tensor(205),G1tensor(163) &
    ,G0tensor(472),G0tensor(205),G0tensor(28)])
  call ol_merge_tensors(G2tensor(254),[G2tensor(397),G2tensor(7),G1tensor(280),G1tensor(169),G0tensor(280),G0tensor(29)])
  call ol_merge_tensors(G2tensor(565),[G2tensor(562),G2tensor(556),G2tensor(553),G2tensor(541),G2tensor(538),G2tensor(532) &
    ,G2tensor(529),G2tensor(238),G2tensor(190),G2tensor(85),G2tensor(4),G1tensor(285),G1tensor(87),G1tensor(118),G1tensor(23) &
    ,G1tensor(72),G1tensor(24),G1tensor(175),G0tensor(285),G0tensor(140),G0tensor(120),G0tensor(110),G0tensor(60),G0tensor(40) &
    ,G0tensor(30)])
  call ol_merge_tensors(G2tensor(269),[G2tensor(542),G2tensor(315),G2tensor(313),G2tensor(10),G1tensor(482),G1tensor(210) &
    ,G1tensor(18),G0tensor(482),G0tensor(210),G0tensor(38)])
  call ol_merge_tensors(G2tensor(275),[G2tensor(248),G2tensor(400),G2tensor(13),G1tensor(290),G1tensor(20),G0tensor(290) &
    ,G0tensor(39)])
  call ol_merge_tensors(G2tensor(281),[G2tensor(536),G2tensor(364),G2tensor(361),G2tensor(321),G2tensor(319),G2tensor(17) &
    ,G1tensor(492),G1tensor(250),G1tensor(215),G1tensor(44),G0tensor(492),G0tensor(250),G0tensor(215),G0tensor(48)])
  call ol_merge_tensors(G2tensor(251),[G2tensor(233),G2tensor(403),G2tensor(382),G2tensor(376),G2tensor(165),G2tensor(162) &
    ,G2tensor(21),G1tensor(295),G1tensor(260),G1tensor(96),G1tensor(49),G0tensor(295),G0tensor(260),G0tensor(49),G0tensor(9)])
  call ol_merge_tensors(G2tensor(568),[G2tensor(559),G2tensor(544),G2tensor(535),G2tensor(247),G2tensor(199),G2tensor(105) &
    ,G2tensor(25),G1tensor(300),G1tensor(52),G1tensor(48),G0tensor(300),G0tensor(130),G0tensor(50)])
  call ol_merge_tensors(G2tensor(257),[G2tensor(327),G2tensor(325),G2tensor(29),G1tensor(502),G1tensor(220),G1tensor(66) &
    ,G0tensor(502),G0tensor(220),G0tensor(58)])
  call ol_merge_tensors(G2tensor(263),[G2tensor(406),G2tensor(33),G1tensor(305),G1tensor(68),G0tensor(305),G0tensor(59)])
  call ol_merge_tensors(G2tensor(439),[G2tensor(409),G2tensor(117),G2tensor(37),G1tensor(380),G1tensor(310),G1tensor(69) &
    ,G0tensor(380),G0tensor(310),G0tensor(68)])
  call ol_merge_tensors(G2tensor(478),[G2tensor(460),G2tensor(442),G2tensor(412),G2tensor(148),G2tensor(138),G2tensor(123) &
    ,G2tensor(41),G1tensor(385),G1tensor(315),G1tensor(199),G1tensor(177),G1tensor(143),G1tensor(3),G1tensor(122),G1tensor(98) &
    ,G0tensor(385),G0tensor(315),G0tensor(199),G0tensor(179),G0tensor(169),G0tensor(99),G0tensor(79),G0tensor(69)])
  call ol_merge_tensors(G2tensor(407),[G2tensor(323),G2tensor(262),G2tensor(214),G2tensor(129),G2tensor(45),G1tensor(390) &
    ,G1tensor(320),G1tensor(75),G0tensor(390),G0tensor(320),G0tensor(70)])
  call ol_merge_tensors(G2tensor(445),[G2tensor(415),G2tensor(130),G2tensor(49),G1tensor(395),G1tensor(325),G1tensor(120) &
    ,G0tensor(395),G0tensor(325),G0tensor(78)])
  call ol_merge_tensors(G2tensor(218),[G2tensor(458),G2tensor(512),G2tensor(332),G2tensor(268),G2tensor(220),G2tensor(131) &
    ,G2tensor(53),G1tensor(400),G1tensor(330),G1tensor(150),G0tensor(400),G0tensor(330),G0tensor(80)])
  call ol_merge_tensors(G2tensor(448),[G2tensor(418),G2tensor(132),G2tensor(57),G1tensor(405),G1tensor(335),G1tensor(21) &
    ,G0tensor(405),G0tensor(335),G0tensor(88)])
  call ol_merge_tensors(G2tensor(487),[G2tensor(469),G2tensor(451),G2tensor(421),G2tensor(153),G2tensor(143),G2tensor(133) &
    ,G2tensor(61),G1tensor(410),G1tensor(340),G1tensor(189),G1tensor(146),G0tensor(410),G0tensor(340),G0tensor(189) &
    ,G0tensor(89)])
  call ol_merge_tensors(G2tensor(416),[G2tensor(212),G2tensor(344),G2tensor(524),G2tensor(526),G2tensor(523),G2tensor(514) &
    ,G2tensor(511),G2tensor(274),G2tensor(226),G2tensor(134),G2tensor(65),G1tensor(415),G1tensor(345),G1tensor(240),G1tensor(230) &
    ,G1tensor(27),G0tensor(415),G0tensor(345),G0tensor(240),G0tensor(230),G0tensor(90)])
  call ol_merge_tensors(G2tensor(454),[G2tensor(424),G2tensor(135),G2tensor(69),G1tensor(420),G1tensor(350),G1tensor(176) &
    ,G0tensor(420),G0tensor(350),G0tensor(98)])
  call ol_merge_tensors(G2tensor(413),[G2tensor(338),G2tensor(280),G2tensor(232),G2tensor(136),G2tensor(73),G1tensor(425) &
    ,G1tensor(355),G1tensor(4),G0tensor(425),G0tensor(355),G0tensor(100)])
  call ol_merge_tensors(G2tensor(566),[G2tensor(261),G2tensor(259),G2tensor(77),G1tensor(387),G1tensor(94),G1tensor(65) &
    ,G0tensor(387),G0tensor(145),G0tensor(108)])
  call ol_merge_tensors(G2tensor(200),[G2tensor(427),G2tensor(81),G1tensor(360),G1tensor(35),G0tensor(360),G0tensor(109)])
  call ol_merge_tensors(G2tensor(221),[G2tensor(560),G2tensor(267),G2tensor(265),G2tensor(89),G1tensor(397),G1tensor(99) &
    ,G1tensor(39),G0tensor(397),G0tensor(150),G0tensor(118)])
  call ol_merge_tensors(G2tensor(71),[G2tensor(209),G2tensor(430),G2tensor(93),G1tensor(365),G1tensor(130),G0tensor(365) &
    ,G0tensor(119)])
  call ol_merge_tensors(G2tensor(227),[G2tensor(63),G2tensor(340),G2tensor(337),G2tensor(273),G2tensor(271),G2tensor(97) &
    ,G1tensor(412),G1tensor(235),G1tensor(105),G1tensor(51),G0tensor(412),G0tensor(235),G0tensor(155),G0tensor(128)])
  call ol_merge_tensors(G2tensor(206),[G2tensor(203),G2tensor(433),G2tensor(101),G1tensor(370),G1tensor(229),G1tensor(124) &
    ,G0tensor(370),G0tensor(229),G0tensor(129)])
  call ol_merge_tensors(G2tensor(215),[G2tensor(279),G2tensor(277),G2tensor(109),G1tensor(422),G1tensor(119),G1tensor(76) &
    ,G0tensor(422),G0tensor(160),G0tensor(138)])
  call ol_merge_tensors(G2tensor(67),[G2tensor(436),G2tensor(113),G1tensor(375),G1tensor(82),G0tensor(375),G0tensor(139)])
  call ol_merge_tensors(G2tensor(475),[G2tensor(457),G2tensor(147),G2tensor(137),G1tensor(470),G1tensor(430),G1tensor(141) &
    ,G0tensor(470),G0tensor(430),G0tensor(168)])
  call ol_merge_tensors(G2tensor(437),[G2tensor(362),G2tensor(310),G2tensor(286),G2tensor(149),G2tensor(139),G1tensor(475) &
    ,G1tensor(435),G1tensor(147),G0tensor(475),G0tensor(435),G0tensor(170)])
  call ol_merge_tensors(G2tensor(481),[G2tensor(463),G2tensor(150),G2tensor(140),G1tensor(480),G1tensor(440),G1tensor(171) &
    ,G0tensor(480),G0tensor(440),G0tensor(178)])
  call ol_merge_tensors(G2tensor(266),[G2tensor(476),G2tensor(389),G2tensor(377),G2tensor(316),G2tensor(292),G2tensor(151) &
    ,G2tensor(141),G1tensor(485),G1tensor(445),G1tensor(178),G0tensor(485),G0tensor(445),G0tensor(180)])
  call ol_merge_tensors(G2tensor(484),[G2tensor(466),G2tensor(152),G2tensor(142),G1tensor(490),G1tensor(450),G1tensor(188) &
    ,G0tensor(490),G0tensor(450),G0tensor(188)])
  call ol_merge_tensors(G2tensor(446),[G2tensor(260),G2tensor(392),G2tensor(380),G2tensor(550),G2tensor(547),G2tensor(520) &
    ,G2tensor(517),G2tensor(358),G2tensor(352),G2tensor(322),G2tensor(298),G2tensor(166),G2tensor(163),G2tensor(154),G2tensor(144) &
    ,G1tensor(495),G1tensor(455),G1tensor(265),G1tensor(190),G1tensor(115),G1tensor(55),G0tensor(495),G0tensor(455),G0tensor(265) &
    ,G0tensor(190),G0tensor(20),G0tensor(10)])
  call ol_merge_tensors(G2tensor(490),[G2tensor(472),G2tensor(155),G2tensor(145),G1tensor(500),G1tensor(460),G1tensor(198) &
    ,G0tensor(500),G0tensor(460),G0tensor(198)])
  call ol_merge_tensors(G2tensor(443),[G2tensor(356),G2tensor(328),G2tensor(304),G2tensor(156),G2tensor(146),G1tensor(505) &
    ,G1tensor(465),G1tensor(200),G0tensor(505),G0tensor(465),G0tensor(200)])
  call ol_merge_tensors(G2tensor(563),[G2tensor(551),G2tensor(493),G2tensor(157),G1tensor(510),G1tensor(228),G0tensor(510) &
    ,G0tensor(228)])
  call ol_merge_tensors(G2tensor(179),[G2tensor(587),G2tensor(496),G2tensor(158),G1tensor(515),G1tensor(238),G0tensor(515) &
    ,G0tensor(238)])
  call ol_merge_tensors(G2tensor(353),[G2tensor(180),G2tensor(499),G2tensor(159),G1tensor(520),G1tensor(239),G0tensor(520) &
    ,G0tensor(239)])
  call ol_merge_tensors(G2tensor(527),[G2tensor(75),G2tensor(502),G2tensor(379),G2tensor(373),G2tensor(164),G2tensor(161) &
    ,G2tensor(160),G1tensor(525),G1tensor(255),G1tensor(43),G0tensor(525),G0tensor(255),G0tensor(8)])
  call ol_merge_tensors(G2tensor(518),[G2tensor(548),G2tensor(505),G2tensor(391),G2tensor(385),G2tensor(171),G2tensor(169) &
    ,G2tensor(167),G1tensor(530),G1tensor(270),G1tensor(103),G0tensor(530),G0tensor(270),G0tensor(18)])
  call ol_merge_tensors(G2tensor(185),[G2tensor(368),G2tensor(508),G2tensor(394),G2tensor(388),G2tensor(172),G2tensor(170) &
    ,G2tensor(168),G1tensor(535),G1tensor(275),G1tensor(109),G0tensor(535),G0tensor(275),G0tensor(19)])
  call ol_merge_tensors(G2tensor(253),[G2tensor(250),G2tensor(241),G2tensor(237),G2tensor(235),G2tensor(205),G2tensor(202) &
    ,G2tensor(193),G2tensor(189),G2tensor(187),G1tensor(282),G1tensor(64),G1tensor(77),G1tensor(16),G1tensor(108),G1tensor(180) &
    ,G1tensor(145),G0tensor(282),G0tensor(135),G0tensor(115),G0tensor(105),G0tensor(55),G0tensor(35),G0tensor(25)])
  call ol_merge_tensors(G2tensor(256),[G2tensor(246),G2tensor(244),G2tensor(208),G2tensor(198),G2tensor(196),G1tensor(297) &
    ,G1tensor(41),G1tensor(38),G0tensor(297),G0tensor(125),G0tensor(45)])
  call ol_merge_tensors(G2tensor(213),[G2tensor(211),G1tensor(317),G1tensor(86),G0tensor(317),G0tensor(65)])
  call ol_merge_tensors(G2tensor(219),[G2tensor(217),G1tensor(327),G1tensor(114),G0tensor(327),G0tensor(75)])
  call ol_merge_tensors(G2tensor(334),[G2tensor(331),G2tensor(225),G2tensor(223),G1tensor(342),G1tensor(225),G1tensor(134) &
    ,G0tensor(342),G0tensor(225),G0tensor(85)])
  call ol_merge_tensors(G2tensor(231),[G2tensor(229),G1tensor(352),G1tensor(164),G0tensor(352),G0tensor(95)])
  call ol_merge_tensors(G2tensor(285),[G2tensor(283),G1tensor(432),G1tensor(131),G0tensor(432),G0tensor(165)])
  call ol_merge_tensors(G2tensor(291),[G2tensor(289),G1tensor(442),G1tensor(159),G0tensor(442),G0tensor(175)])
  call ol_merge_tensors(G2tensor(346),[G2tensor(343),G2tensor(297),G2tensor(295),G1tensor(452),G1tensor(245),G1tensor(185) &
    ,G0tensor(452),G0tensor(245),G0tensor(185)])
  call ol_merge_tensors(G2tensor(303),[G2tensor(301),G1tensor(462),G1tensor(195),G0tensor(462),G0tensor(195)])
  call ol_merge_tensors(G2tensor(370),[G2tensor(367),G2tensor(357),G2tensor(355),G2tensor(351),G2tensor(349),G1tensor(91) &
    ,G1tensor(61),G1tensor(262),G1tensor(85),G1tensor(25),G0tensor(262),G0tensor(15),G0tensor(5)])
  call ol_merge_tensors(G3tensor(16),[G3tensor(15),G3tensor(8),G3tensor(7),G3tensor(2),G3tensor(1),G2tensor(278),G2tensor(452) &
    ,G2tensor(378),G2tensor(372),G1tensor(543),G1tensor(252),G1tensor(13),G0tensor(543),G0tensor(252),G0tensor(3)])
  call ol_merge_tensors(G2tensor(188),[G2tensor(350),G2tensor(381),G2tensor(375),G1tensor(151),G1tensor(121),G1tensor(554) &
    ,G1tensor(257),G1tensor(19),G0tensor(554),G0tensor(257),G0tensor(4)])
  call ol_merge_tensors(G2tensor(107),[G2tensor(103),G2tensor(575),G2tensor(174),G2tensor(390),G2tensor(384),G1tensor(548) &
    ,G1tensor(267),G1tensor(73),G0tensor(548),G0tensor(267),G0tensor(13)])
  call ol_merge_tensors(G2tensor(176),[G2tensor(173),G2tensor(393),G2tensor(387),G1tensor(272),G1tensor(79),G0tensor(272) &
    ,G0tensor(14)])
  call ol_merge_tensors(G2tensor(182),[G2tensor(396),G1tensor(277),G1tensor(139),G0tensor(277),G0tensor(24)])
  call ol_merge_tensors(G2tensor(8),[G2tensor(545),G2tensor(399),G1tensor(287),G1tensor(8),G0tensor(287),G0tensor(34)])
  call ol_merge_tensors(G2tensor(125),[G2tensor(6),G2tensor(402),G1tensor(292),G1tensor(244),G1tensor(36),G0tensor(292) &
    ,G0tensor(244),G0tensor(44)])
  call ol_merge_tensors(G2tensor(183),[G2tensor(405),G1tensor(302),G1tensor(56),G0tensor(302),G0tensor(54)])
  call ol_merge_tensors(G2tensor(12),[G2tensor(408),G1tensor(307),G1tensor(80),G0tensor(307),G0tensor(63)])
  call ol_merge_tensors(G2tensor(74),[G2tensor(9),G2tensor(459),G2tensor(411),G1tensor(312),G1tensor(194),G1tensor(155) &
    ,G1tensor(129),G1tensor(162),G1tensor(138),G1tensor(84),G0tensor(312),G0tensor(194),G0tensor(174),G0tensor(164),G0tensor(94) &
    ,G0tensor(74),G0tensor(64)])
  call ol_merge_tensors(G2tensor(191),[G2tensor(414),G1tensor(322),G1tensor(110),G0tensor(322),G0tensor(73)])
  call ol_merge_tensors(G2tensor(554),[G2tensor(417),G1tensor(518),G1tensor(513),G1tensor(332),G1tensor(156),G0tensor(518) &
    ,G0tensor(513),G0tensor(332),G0tensor(83)])
  call ol_merge_tensors(G2tensor(86),[G2tensor(19),G2tensor(468),G2tensor(420),G1tensor(337),G1tensor(184),G1tensor(132) &
    ,G0tensor(337),G0tensor(184),G0tensor(84)])
  call ol_merge_tensors(G2tensor(557),[G2tensor(423),G1tensor(347),G1tensor(158),G0tensor(347),G0tensor(93)])
  call ol_merge_tensors(G2tensor(27),[G2tensor(426),G1tensor(357),G1tensor(10),G0tensor(357),G0tensor(104)])
  call ol_merge_tensors(G2tensor(47),[G2tensor(34),G2tensor(429),G1tensor(362),G1tensor(28),G0tensor(362),G0tensor(114)])
  call ol_merge_tensors(G2tensor(50),[G2tensor(38),G2tensor(432),G1tensor(367),G1tensor(224),G1tensor(40),G0tensor(367) &
    ,G0tensor(224),G0tensor(124)])
  call ol_merge_tensors(G2tensor(43),[G2tensor(435),G1tensor(372),G1tensor(59),G0tensor(372),G0tensor(134)])
  call ol_merge_tensors(G2tensor(530),[G2tensor(438),G1tensor(377),G1tensor(358),G1tensor(136),G0tensor(377),G0tensor(358) &
    ,G0tensor(143)])
  call ol_merge_tensors(G2tensor(30),[G2tensor(181),G2tensor(477),G2tensor(441),G1tensor(382),G1tensor(283),G1tensor(219) &
    ,G1tensor(209),G1tensor(204),G1tensor(117),G1tensor(95),G1tensor(106),G0tensor(382),G0tensor(283),G0tensor(219),G0tensor(209) &
    ,G0tensor(204),G0tensor(159),G0tensor(149),G0tensor(144)])
  call ol_merge_tensors(G2tensor(54),[G2tensor(444),G1tensor(392),G1tensor(363),G1tensor(93),G0tensor(392),G0tensor(363) &
    ,G0tensor(148)])
  call ol_merge_tensors(G2tensor(55),[G2tensor(447),G1tensor(508),G1tensor(402),G1tensor(368),G1tensor(167),G0tensor(508) &
    ,G0tensor(402),G0tensor(368),G0tensor(153)])
  call ol_merge_tensors(G2tensor(39),[G2tensor(3),G2tensor(486),G2tensor(450),G1tensor(407),G1tensor(298),G1tensor(214) &
    ,G1tensor(101),G0tensor(407),G0tensor(298),G0tensor(214),G0tensor(154)])
  call ol_merge_tensors(G2tensor(62),[G2tensor(453),G1tensor(417),G1tensor(373),G1tensor(113),G0tensor(417),G0tensor(373) &
    ,G0tensor(158)])
  call ol_merge_tensors(G2tensor(70),[G2tensor(456),G1tensor(427),G1tensor(125),G0tensor(427),G0tensor(163)])
  call ol_merge_tensors(G2tensor(79),[G2tensor(462),G1tensor(437),G1tensor(153),G0tensor(437),G0tensor(173)])
  call ol_merge_tensors(G2tensor(83),[G2tensor(465),G1tensor(533),G1tensor(528),G1tensor(447),G1tensor(183),G0tensor(533) &
    ,G0tensor(528),G0tensor(447),G0tensor(183)])
  call ol_merge_tensors(G2tensor(90),[G2tensor(471),G1tensor(457),G1tensor(193),G0tensor(457),G0tensor(193)])
  call ol_merge_tensors(G2tensor(94),[G2tensor(474),G1tensor(467),G1tensor(278),G1tensor(203),G0tensor(467),G0tensor(278) &
    ,G0tensor(203)])
  call ol_merge_tensors(G2tensor(106),[G2tensor(480),G1tensor(477),G1tensor(288),G1tensor(208),G0tensor(477),G0tensor(288) &
    ,G0tensor(208)])
  call ol_merge_tensors(G2tensor(110),[G2tensor(483),G1tensor(523),G1tensor(487),G1tensor(293),G1tensor(213),G0tensor(523) &
    ,G0tensor(487),G0tensor(293),G0tensor(213)])
  call ol_merge_tensors(G2tensor(335),[G2tensor(489),G1tensor(497),G1tensor(303),G1tensor(218),G0tensor(497),G0tensor(303) &
    ,G0tensor(218)])
  call ol_merge_tensors(G2tensor(115),[G2tensor(509),G2tensor(492),G1tensor(507),G1tensor(223),G0tensor(507),G0tensor(223)])
  call ol_merge_tensors(G2tensor(359),[G2tensor(341),G2tensor(495),G1tensor(512),G1tensor(233),G0tensor(512),G0tensor(233)])
  call ol_merge_tensors(G2tensor(124),[G2tensor(118),G2tensor(498),G1tensor(517),G1tensor(234),G0tensor(517),G0tensor(234)])
  call ol_merge_tensors(G2tensor(374),[G2tensor(371),G2tensor(501),G1tensor(522),G1tensor(273),G1tensor(268),G1tensor(243) &
    ,G0tensor(522),G0tensor(273),G0tensor(268),G0tensor(243)])
  call ol_merge_tensors(G2tensor(449),[G2tensor(419),G2tensor(504),G1tensor(527),G1tensor(258),G1tensor(253),G1tensor(248) &
    ,G0tensor(527),G0tensor(258),G0tensor(253),G0tensor(248)])
  call ol_merge_tensors(G2tensor(569),[G2tensor(440),G2tensor(507),G1tensor(532),G1tensor(249),G0tensor(532),G0tensor(249)])
  call ol_merge_tensors(G2tensor(434),[G2tensor(425),G2tensor(574),G2tensor(571),G1tensor(540),G0tensor(540)])
  call ol_merge_tensors(G2tensor(586),[G2tensor(583),G2tensor(580),G2tensor(577),G1tensor(31),G1tensor(1),G1tensor(550) &
    ,G1tensor(545),G0tensor(550),G0tensor(545)])
  call ol_merge_tensors(G2tensor(404),[G2tensor(398),G2tensor(592),G2tensor(589),G1tensor(555),G0tensor(555)])
  call ol_merge_tensors(G2tensor(197),[G2tensor(383),G1tensor(269),G1tensor(263),G1tensor(254),G0tensor(269),G0tensor(263) &
    ,G0tensor(254)])
  call ol_merge_tensors(G2tensor(410),[G2tensor(386),G1tensor(274),G1tensor(264),G1tensor(259),G0tensor(274),G0tensor(264) &
    ,G0tensor(259)])
  call ol_merge_tensors(G2tensor(15),[G2tensor(5),G1tensor(464),G1tensor(444),G1tensor(434),G1tensor(374),G1tensor(364) &
    ,G1tensor(359),G1tensor(354),G1tensor(329),G1tensor(319),G1tensor(314),G1tensor(304),G1tensor(289),G1tensor(284),G1tensor(279) &
    ,G0tensor(464),G0tensor(444),G0tensor(434),G0tensor(374),G0tensor(364),G0tensor(359),G0tensor(354),G0tensor(329),G0tensor(319) &
    ,G0tensor(314),G0tensor(304),G0tensor(289),G0tensor(284),G0tensor(279)])
  call ol_merge_tensors(G2tensor(22),[G2tensor(365),G1tensor(454),G1tensor(369),G1tensor(344),G1tensor(339),G1tensor(299) &
    ,G1tensor(294),G0tensor(454),G0tensor(369),G0tensor(344),G0tensor(339),G0tensor(299),G0tensor(294)])
  call ol_merge_tensors(G3tensor(5),[G3tensor(3),G1tensor(458),G1tensor(438),G1tensor(428),G1tensor(348),G1tensor(323) &
    ,G1tensor(313),G1tensor(308),G0tensor(458),G0tensor(438),G0tensor(428),G0tensor(348),G0tensor(323),G0tensor(313) &
    ,G0tensor(308)])
  call ol_merge_tensors(G2tensor(14),[G1tensor(318),G1tensor(309),G0tensor(318),G0tensor(309)])
  call ol_merge_tensors(G2tensor(18),[G1tensor(328),G1tensor(324),G0tensor(328),G0tensor(324)])
  call ol_merge_tensors(G3tensor(6),[G3tensor(4),G1tensor(448),G1tensor(338),G1tensor(333),G0tensor(448),G0tensor(338) &
    ,G0tensor(333)])
  call ol_merge_tensors(G2tensor(194),[G1tensor(509),G1tensor(343),G1tensor(334),G0tensor(509),G0tensor(343),G0tensor(334)])
  call ol_merge_tensors(G2tensor(23),[G1tensor(353),G1tensor(349),G0tensor(353),G0tensor(349)])
  call ol_merge_tensors(G2tensor(178),[G2tensor(175),G1tensor(498),G1tensor(478),G1tensor(468),G1tensor(418),G1tensor(393) &
    ,G1tensor(383),G1tensor(378),G0tensor(498),G0tensor(478),G0tensor(468),G0tensor(418),G0tensor(393),G0tensor(383) &
    ,G0tensor(378)])
  call ol_merge_tensors(G2tensor(51),[G1tensor(388),G1tensor(379),G0tensor(388),G0tensor(379)])
  call ol_merge_tensors(G2tensor(102),[G2tensor(242),G1tensor(504),G1tensor(484),G1tensor(474),G1tensor(424),G1tensor(399) &
    ,G1tensor(389),G1tensor(384),G0tensor(504),G0tensor(484),G0tensor(474),G0tensor(424),G0tensor(399),G0tensor(389) &
    ,G0tensor(384)])
  call ol_merge_tensors(G2tensor(533),[G1tensor(398),G1tensor(394),G0tensor(398),G0tensor(394)])
  call ol_merge_tensors(G2tensor(177),[G2tensor(581),G1tensor(488),G1tensor(408),G1tensor(403),G0tensor(488),G0tensor(408) &
    ,G0tensor(403)])
  call ol_merge_tensors(G2tensor(58),[G1tensor(514),G1tensor(413),G1tensor(404),G0tensor(514),G0tensor(413),G0tensor(404)])
  call ol_merge_tensors(G2tensor(111),[G2tensor(59),G1tensor(534),G1tensor(519),G1tensor(494),G1tensor(414),G1tensor(409) &
    ,G0tensor(534),G0tensor(519),G0tensor(494),G0tensor(414),G0tensor(409)])
  call ol_merge_tensors(G2tensor(66),[G1tensor(423),G1tensor(419),G0tensor(423),G0tensor(419)])
  call ol_merge_tensors(G2tensor(78),[G1tensor(433),G1tensor(429),G0tensor(433),G0tensor(429)])
  call ol_merge_tensors(G2tensor(82),[G1tensor(443),G1tensor(439),G0tensor(443),G0tensor(439)])
  call ol_merge_tensors(G2tensor(87),[G1tensor(524),G1tensor(453),G1tensor(449),G0tensor(524),G0tensor(453),G0tensor(449)])
  call ol_merge_tensors(G2tensor(91),[G1tensor(463),G1tensor(459),G0tensor(463),G0tensor(459)])
  call ol_merge_tensors(G2tensor(98),[G1tensor(473),G1tensor(469),G0tensor(473),G0tensor(469)])
  call ol_merge_tensors(G2tensor(329),[G1tensor(483),G1tensor(479),G0tensor(483),G0tensor(479)])
  call ol_merge_tensors(G2tensor(521),[G1tensor(529),G1tensor(493),G1tensor(489),G0tensor(529),G0tensor(493),G0tensor(489)])
  call ol_merge_tensors(G2tensor(114),[G1tensor(503),G1tensor(499),G0tensor(503),G0tensor(499)])
  call ol_merge_tensors(G2tensor(293),[G2tensor(287),G1tensor(90),G1tensor(26),G1tensor(544),G1tensor(539),G0tensor(544) &
    ,G0tensor(539)])
  call ol_merge_tensors(G2tensor(305),[G2tensor(299),G1tensor(549),G0tensor(549)])
  call ol_merge_tensors(G2tensor(245),[G2tensor(236)])
  call ol_merge_tensors(G2tensor(431),[G2tensor(230)])
  call ol_merge_tensors(G3tensor(12),[G3tensor(9)])
  call ol_merge_tensors(G3tensor(13),[G3tensor(10)])
  call ol_merge_tensors(G3tensor(14),[G3tensor(11)])
  call ol_merge_tensors(G3tensor(18),[G3tensor(17)])
  call TI_triangle_red(G2tensor(552),RedBasis(64),mass3set(:,1),G0tensor(1),G0tensor(6),G0tensor(11), &
    G0tensor(16),M2L1R1,[nMH,nMT],G0tensor(21),G0tensor(26))
  call TI_triangle_red(G2tensor(564),RedBasis(64),mass3set(:,2),G0tensor(31),G0tensor(36),G0tensor(41), &
    G0tensor(46),M2L1R1,[nMZ,nMT],G0tensor(51),G0tensor(56))
  call TI_triangle_red(G2tensor(591),RedBasis(64),mass3set(:,3),G0tensor(61),G0tensor(66),G0tensor(71), &
    G0tensor(76),M2L1R1,[nMW,nMB],G0tensor(81),G0tensor(86))
  call TI_triangle_red(G2tensor(561),RedBasis(64),mass3set(:,4),G0tensor(91),G0tensor(96),G0tensor(101), &
    G0tensor(106),M2L1R1,[nMT],G0tensor(111))
  call TI_triangle_red(G2tensor(26),RedBasis(62),mass3set(:,5),G0tensor(116),G0tensor(121),G0tensor(126), &
    G0tensor(131),M2L1R1,[nMT,nMH],G0tensor(136),G0tensor(141))
  call TI_triangle_red(G2tensor(46),RedBasis(62),mass3set(:,6),G0tensor(146),G0tensor(151),G0tensor(156), &
    G0tensor(161),M2L1R1,[nMT,nMZ],G0tensor(166),G0tensor(171))
  call TI_triangle_red(G2tensor(239),RedBasis(62),mass3set(:,7),G0tensor(176),G0tensor(181),G0tensor(186), &
    G0tensor(191),M2L1R1,[nMB,nMW],G0tensor(196),G0tensor(201))
  call TI_triangle_red(G2tensor(42),RedBasis(62),mass3set(:,8),G0tensor(206),G0tensor(211),G0tensor(216), &
    G0tensor(221),M2L1R1,[nMT],G0tensor(226))
  call TI_triangle_red(G2tensor(528),RedBasis(33),mass3set(:,1),G0tensor(231),G0tensor(236),G0tensor(241), &
    G0tensor(246),M2L1R1,[nMH,nMT],G0tensor(251),G0tensor(256))
  call TI_triangle_red(G2tensor(540),RedBasis(33),mass3set(:,2),G0tensor(261),G0tensor(266),G0tensor(271), &
    G0tensor(276),M2L1R1,[nMZ,nMT],G0tensor(281),G0tensor(286))
  call TI_triangle_red(G2tensor(573),RedBasis(33),mass3set(:,3),G0tensor(291),G0tensor(296),G0tensor(301), &
    G0tensor(306),M2L1R1,[nMW,nMB],G0tensor(311),G0tensor(316))
  call TI_triangle_red(G2tensor(537),RedBasis(33),mass3set(:,4),G0tensor(321),G0tensor(326),G0tensor(331), &
    G0tensor(336),M2L1R1,[nMT],G0tensor(341))
  call TI_triangle_red(G2tensor(347),RedBasis(58),mass3set(:,5),G0tensor(346),G0tensor(351),G0tensor(356), &
    G0tensor(361),M2L1R1,[nMT,nMH],G0tensor(366),G0tensor(371))
  call TI_triangle_red(G2tensor(11),RedBasis(58),mass3set(:,6),G0tensor(376),G0tensor(381),G0tensor(386), &
    G0tensor(391),M2L1R1,[nMT,nMZ],G0tensor(396),G0tensor(401))
  call TI_triangle_red(G2tensor(515),RedBasis(58),mass3set(:,7),G0tensor(406),G0tensor(411),G0tensor(416), &
    G0tensor(421),M2L1R1,[nMB,nMW],G0tensor(426),G0tensor(431))
  call TI_triangle_red(G2tensor(184),RedBasis(58),mass3set(:,8),G0tensor(436),G0tensor(441),G0tensor(446), &
    G0tensor(451),M2L1R1,[nMT],G0tensor(456))
  call TI_triangle_red(G2tensor(224),RedBasis(32),mass3set(:,9),G0tensor(461),G0tensor(466),G0tensor(471), &
    G0tensor(476),M2L1R1,[nMW,nMB],G0tensor(481),G0tensor(486))
  call TI_triangle_red(G2tensor(99),RedBasis(6),mass3set(:,9),G0tensor(491),G0tensor(496),G0tensor(501), &
    G0tensor(506),M2L1R1,[nMW,nMB],G0tensor(511),G0tensor(516))
  call TI_triangle_red(G2tensor(272),RedBasis(25),mass3set(:,9),G0tensor(521),G0tensor(526),G0tensor(531), &
    G0tensor(536),M2L1R1,[nMW,nMB],G0tensor(541),G0tensor(546))
  call TI_triangle_red(G2tensor(317),RedBasis(14),mass3set(:,9),G0tensor(551),G0tensor(27),G0tensor(22), &
    G0tensor(37),M2L1R1,[nMW,nMB],G0tensor(32),G0tensor(552))
  call TI_triangle_red(G2tensor(539),RedBasis(4),mass3set(:,5),G0tensor(47),G0tensor(42),G0tensor(57), &
    G0tensor(52),M2L1R1,[nMT,nMH],G0tensor(142),G0tensor(103))
  call TI_triangle_red(G2tensor(254),RedBasis(2),mass3set(:,5),G0tensor(67),G0tensor(62),G0tensor(147), &
    G0tensor(113),M2L1R1,[nMT,nMH],G0tensor(77),G0tensor(72))
  call TI_triangle_red(G2tensor(565),RedBasis(1),mass3set(:,10),G0tensor(152),G0tensor(123),G0tensor(87), &
    G0tensor(82),M2L1R1,[nMT],G0tensor(157))
  call TI_triangle_red(G2tensor(269),RedBasis(4),mass3set(:,6),G0tensor(133),G0tensor(97),G0tensor(92), &
    G0tensor(107),M2L1R1,[nMT,nMZ],G0tensor(102),G0tensor(117))
  call TI_triangle_red(G2tensor(275),RedBasis(2),mass3set(:,6),G0tensor(112),G0tensor(537),G0tensor(127), &
    G0tensor(122),M2L1R1,[nMT,nMZ],G0tensor(137),G0tensor(132))
  call TI_triangle_red(G2tensor(281),RedBasis(4),mass3set(:,7),G0tensor(202),G0tensor(167),G0tensor(162), &
    G0tensor(23),M2L1R1,[nMB,nMW],G0tensor(207),G0tensor(177))
  call TI_triangle_red(G2tensor(251),RedBasis(2),mass3set(:,7),G0tensor(172),G0tensor(33),G0tensor(212), &
    G0tensor(187),M2L1R1,[nMB,nMW],G0tensor(182),G0tensor(43))
  call TI_triangle_red(G2tensor(568),RedBasis(1),mass3set(:,11),G0tensor(217),G0tensor(197),G0tensor(192), &
    G0tensor(53),M2L1R1,[nMB],G0tensor(542))
  call TI_triangle_red(G2tensor(257),RedBasis(4),mass3set(:,8),G0tensor(227),G0tensor(222),G0tensor(547), &
    G0tensor(538),M2L1R1,[nMT],G0tensor(237))
  call TI_triangle_red(G2tensor(263),RedBasis(2),mass3set(:,8),G0tensor(232),G0tensor(242),G0tensor(7),G0tensor(2),M2L1R1,[nMT], &
    G0tensor(553))
  call TI_triangle_red(G2tensor(439),RedBasis(9),mass3set(:,12),G0tensor(247),G0tensor(17),G0tensor(12), &
    G0tensor(472),M2L1R1,[nMT,nMH],G0tensor(205),G0tensor(28))
  call TI_triangle_red(G2tensor(478),RedBasis(8),mass3set(:,10),G0tensor(280),G0tensor(29),G0tensor(285), &
    G0tensor(140),M2L1R1,[nMT],G0tensor(120))
  call TI_triangle_red(G2tensor(407),RedBasis(7),mass3set(:,5),G0tensor(110),G0tensor(60),G0tensor(40), &
    G0tensor(30),M2L1R1,[nMT,nMH],G0tensor(482),G0tensor(210))
  call TI_triangle_red(G2tensor(445),RedBasis(9),mass3set(:,13),G0tensor(38),G0tensor(290),G0tensor(39), &
    G0tensor(492),M2L1R1,[nMT,nMZ],G0tensor(250),G0tensor(215))
  call TI_triangle_red(G2tensor(218),RedBasis(7),mass3set(:,6),G0tensor(48),G0tensor(295),G0tensor(260), &
    G0tensor(49),M2L1R1,[nMT,nMZ],G0tensor(9),G0tensor(300))
  call TI_triangle_red(G2tensor(448),RedBasis(9),mass3set(:,14),G0tensor(130),G0tensor(50),G0tensor(502), &
    G0tensor(220),M2L1R1,[nMB,nMW],G0tensor(58),G0tensor(305))
  call TI_triangle_red(G2tensor(487),RedBasis(8),mass3set(:,11),G0tensor(59),G0tensor(380),G0tensor(310), &
    G0tensor(68),M2L1R1,[nMB],G0tensor(385))
  call TI_triangle_red(G2tensor(416),RedBasis(7),mass3set(:,7),G0tensor(315),G0tensor(199),G0tensor(179), &
    G0tensor(169),M2L1R1,[nMB,nMW],G0tensor(99),G0tensor(79))
  call TI_triangle_red(G2tensor(454),RedBasis(9),mass3set(:,15),G0tensor(69),G0tensor(390),G0tensor(320), &
    G0tensor(70),M2L1R1,[nMT],G0tensor(395))
  call TI_triangle_red(G2tensor(413),RedBasis(7),mass3set(:,8),G0tensor(325),G0tensor(78),G0tensor(400), &
    G0tensor(330),M2L1R1,[nMT],G0tensor(80))
  call TI_triangle_red(G2tensor(566),RedBasis(13),mass3set(:,5),G0tensor(405),G0tensor(335),G0tensor(88), &
    G0tensor(410),M2L1R1,[nMT,nMH],G0tensor(340),G0tensor(189))
  call TI_triangle_red(G2tensor(200),RedBasis(12),mass3set(:,5),G0tensor(89),G0tensor(415),G0tensor(345), &
    G0tensor(240),M2L1R1,[nMT,nMH],G0tensor(230),G0tensor(90))
  call TI_triangle_red(G2tensor(221),RedBasis(13),mass3set(:,6),G0tensor(420),G0tensor(350),G0tensor(98), &
    G0tensor(425),M2L1R1,[nMT,nMZ],G0tensor(355),G0tensor(100))
  call TI_triangle_red(G2tensor(71),RedBasis(12),mass3set(:,6),G0tensor(387),G0tensor(145),G0tensor(108), &
    G0tensor(360),M2L1R1,[nMT,nMZ],G0tensor(109),G0tensor(397))
  call TI_triangle_red(G2tensor(227),RedBasis(13),mass3set(:,7),G0tensor(150),G0tensor(118),G0tensor(365), &
    G0tensor(119),M2L1R1,[nMB,nMW],G0tensor(412),G0tensor(235))
  call TI_triangle_red(G2tensor(206),RedBasis(12),mass3set(:,7),G0tensor(155),G0tensor(128),G0tensor(370), &
    G0tensor(229),M2L1R1,[nMB,nMW],G0tensor(129),G0tensor(422))
  call TI_triangle_red(G2tensor(215),RedBasis(13),mass3set(:,8),G0tensor(160),G0tensor(138),G0tensor(375), &
    G0tensor(139),M2L1R1,[nMT],G0tensor(470))
  call TI_triangle_red(G2tensor(67),RedBasis(12),mass3set(:,8),G0tensor(430),G0tensor(168),G0tensor(475), &
    G0tensor(435),M2L1R1,[nMT],G0tensor(170))
  call TI_triangle_red(G2tensor(475),RedBasis(19),mass3set(:,12),G0tensor(480),G0tensor(440),G0tensor(178), &
    G0tensor(485),M2L1R1,[nMT,nMH],G0tensor(445),G0tensor(180))
  call TI_triangle_red(G2tensor(437),RedBasis(18),mass3set(:,5),G0tensor(490),G0tensor(450),G0tensor(188), &
    G0tensor(495),M2L1R1,[nMT,nMH],G0tensor(455),G0tensor(265))
  call TI_triangle_red(G2tensor(481),RedBasis(19),mass3set(:,13),G0tensor(190),G0tensor(20),G0tensor(10), &
    G0tensor(500),M2L1R1,[nMT,nMZ],G0tensor(460),G0tensor(198))
  call TI_triangle_red(G2tensor(266),RedBasis(18),mass3set(:,6),G0tensor(505),G0tensor(465),G0tensor(200), &
    G0tensor(510),M2L1R1,[nMT,nMZ],G0tensor(228),G0tensor(515))
  call TI_triangle_red(G2tensor(484),RedBasis(19),mass3set(:,14),G0tensor(238),G0tensor(520),G0tensor(239), &
    G0tensor(525),M2L1R1,[nMB,nMW],G0tensor(255),G0tensor(8))
  call TI_triangle_red(G2tensor(446),RedBasis(18),mass3set(:,7),G0tensor(530),G0tensor(270),G0tensor(18), &
    G0tensor(535),M2L1R1,[nMB,nMW],G0tensor(275),G0tensor(19))
  call TI_triangle_red(G2tensor(490),RedBasis(19),mass3set(:,15),G0tensor(282),G0tensor(135),G0tensor(115), &
    G0tensor(105),M2L1R1,[nMT],G0tensor(55))
  call TI_triangle_red(G2tensor(443),RedBasis(18),mass3set(:,8),G0tensor(35),G0tensor(25),G0tensor(297), &
    G0tensor(125),M2L1R1,[nMT],G0tensor(45))
  call TI_triangle_red(G2tensor(563),RedBasis(22),mass3set(:,16),G0tensor(317),G0tensor(65),G0tensor(327), &
    G0tensor(75),M2L1R1,[nMB,nMW],G0tensor(342),G0tensor(225))
  call TI_triangle_red(G2tensor(179),RedBasis(24),mass3set(:,16),G0tensor(85),G0tensor(352),G0tensor(95), &
    G0tensor(432),M2L1R1,[nMB,nMW],G0tensor(165),G0tensor(442))
  call TI_triangle_red(G2tensor(353),RedBasis(23),mass3set(:,7),G0tensor(175),G0tensor(452),G0tensor(245), &
    G0tensor(185),M2L1R1,[nMB,nMW],G0tensor(462),G0tensor(195))
  call TI_triangle_red(G2tensor(527),RedBasis(26),mass3set(:,16),G0tensor(262),G0tensor(15),G0tensor(5), &
    G0tensor(543),M2L1R1,[nMB,nMW],G0tensor(252),G0tensor(3))
  call TI_triangle_red(G2tensor(518),RedBasis(31),mass3set(:,16),G0tensor(554),G0tensor(257),G0tensor(4), &
    G0tensor(548),M2L1R1,[nMB,nMW],G0tensor(267),G0tensor(13))
  call TI_triangle_red(G2tensor(185),RedBasis(30),mass3set(:,7),G0tensor(272),G0tensor(14),G0tensor(277), &
    G0tensor(24),M2L1R1,[nMB,nMW],G0tensor(287),G0tensor(34))
  call TI_triangle_red(G2tensor(253),RedBasis(56),mass3set(:,10),G0tensor(292),G0tensor(244),G0tensor(44), &
    G0tensor(302),M2L1R1,[nMT],G0tensor(54))
  call TI_triangle_red(G2tensor(256),RedBasis(56),mass3set(:,11),G0tensor(307),G0tensor(63),G0tensor(312), &
    G0tensor(194),M2L1R1,[nMB],G0tensor(174))
  call TI_triangle_red(G2tensor(213),RedBasis(59),mass3set(:,5),G0tensor(164),G0tensor(94),G0tensor(74), &
    G0tensor(64),M2L1R1,[nMT,nMH],G0tensor(322),G0tensor(73))
  call TI_triangle_red(G2tensor(219),RedBasis(59),mass3set(:,6),G0tensor(518),G0tensor(513),G0tensor(332), &
    G0tensor(83),M2L1R1,[nMT,nMZ],G0tensor(337),G0tensor(184))
  call TI_triangle_red(G2tensor(334),RedBasis(59),mass3set(:,7),G0tensor(84),G0tensor(347),G0tensor(93), &
    G0tensor(357),M2L1R1,[nMB,nMW],G0tensor(104),G0tensor(362))
  call TI_triangle_red(G2tensor(231),RedBasis(59),mass3set(:,8),G0tensor(114),G0tensor(367),G0tensor(224), &
    G0tensor(124),M2L1R1,[nMT],G0tensor(372))
  call TI_triangle_red(G2tensor(285),RedBasis(63),mass3set(:,5),G0tensor(134),G0tensor(377),G0tensor(358), &
    G0tensor(143),M2L1R1,[nMT,nMH],G0tensor(382),G0tensor(283))
  call TI_triangle_red(G2tensor(291),RedBasis(63),mass3set(:,6),G0tensor(219),G0tensor(209),G0tensor(204), &
    G0tensor(159),M2L1R1,[nMT,nMZ],G0tensor(149),G0tensor(144))
  call TI_triangle_red(G2tensor(346),RedBasis(63),mass3set(:,7),G0tensor(392),G0tensor(363),G0tensor(148), &
    G0tensor(508),M2L1R1,[nMB,nMW],G0tensor(402),G0tensor(368))
  call TI_triangle_red(G2tensor(303),RedBasis(63),mass3set(:,8),G0tensor(153),G0tensor(407),G0tensor(298), &
    G0tensor(214),M2L1R1,[nMT],G0tensor(154))
  call TI_triangle_red(G2tensor(370),RedBasis(9),mass3set(:,9),G0tensor(417),G0tensor(373),G0tensor(158), &
    G0tensor(427),M2L1R1,[nMW,nMB],G0tensor(163),G0tensor(437))
  call TI_triangle_red(G3tensor(16),RedBasis(11),mass3set(:,17),G0tensor(173),G0tensor(533),G0tensor(528), &
    G0tensor(447),M2L1R1,[nMW],G0tensor(183))
  call TI_triangle_red(G2tensor(188),RedBasis(10),mass3set(:,9),G0tensor(457),G0tensor(193),G0tensor(467), &
    G0tensor(278),M2L1R1,[nMW,nMB],G0tensor(203),G0tensor(477))
  call TI_triangle_red(G2tensor(107),RedBasis(17),mass3set(:,17),G0tensor(288),G0tensor(208),G0tensor(523), &
    G0tensor(487),M2L1R1,[nMW],G0tensor(293))
  call TI_triangle_red(G2tensor(176),RedBasis(16),mass3set(:,9),G0tensor(213),G0tensor(497),G0tensor(303), &
    G0tensor(218),M2L1R1,[nMW,nMB],G0tensor(507),G0tensor(223))
  call TI_triangle_red(G2tensor(182),RedBasis(57),mass3set(:,5),G0tensor(512),G0tensor(233),G0tensor(517), &
    G0tensor(234),M2L1R1,[nMT,nMH],G0tensor(522),G0tensor(273))
  call TI_triangle_red(G2tensor(8),RedBasis(57),mass3set(:,6),G0tensor(268),G0tensor(243),G0tensor(527), &
    G0tensor(258),M2L1R1,[nMT,nMZ],G0tensor(253),G0tensor(248))
  call TI_triangle_red(G2tensor(125),RedBasis(57),mass3set(:,7),G0tensor(532),G0tensor(249),G0tensor(540), &
    G0tensor(550),M2L1R1,[nMB,nMW],G0tensor(545),G0tensor(555))
  call TI_triangle_red(G2tensor(183),RedBasis(57),mass3set(:,8),G0tensor(269),G0tensor(263),G0tensor(254), &
    G0tensor(274),M2L1R1,[nMT],G0tensor(264))
  call TI_triangle_red(G2tensor(12),RedBasis(25),mass3set(:,12),G0tensor(259),G0tensor(464),G0tensor(444), &
    G0tensor(434),M2L1R1,[nMT,nMH],G0tensor(374),G0tensor(364))
  call TI_triangle_red(G2tensor(74),RedBasis(60),mass3set(:,10),G0tensor(359),G0tensor(354),G0tensor(329), &
    G0tensor(319),M2L1R1,[nMT],G0tensor(314))
  call TI_triangle_red(G2tensor(191),RedBasis(25),mass3set(:,13),G0tensor(304),G0tensor(289),G0tensor(284), &
    G0tensor(279),M2L1R1,[nMT,nMZ],G0tensor(454),G0tensor(369))
  call TI_triangle_red(G2tensor(554),RedBasis(25),mass3set(:,14),G0tensor(344),G0tensor(339),G0tensor(299), &
    G0tensor(294),M2L1R1,[nMB,nMW],G0tensor(458),G0tensor(438))
  call TI_triangle_red(G2tensor(86),RedBasis(60),mass3set(:,11),G0tensor(428),G0tensor(348),G0tensor(323), &
    G0tensor(313),M2L1R1,[nMB],G0tensor(308))
  call TI_triangle_red(G2tensor(557),RedBasis(25),mass3set(:,15),G0tensor(318),G0tensor(309),G0tensor(328), &
    G0tensor(324),M2L1R1,[nMT],G0tensor(448))
  call TI_triangle_red(G2tensor(27),RedBasis(61),mass3set(:,5),G0tensor(338),G0tensor(333),G0tensor(509), &
    G0tensor(343),M2L1R1,[nMT,nMH],G0tensor(334),G0tensor(353))
  call TI_triangle_red(G2tensor(47),RedBasis(61),mass3set(:,6),G0tensor(349),G0tensor(498),G0tensor(478), &
    G0tensor(468),M2L1R1,[nMT,nMZ],G0tensor(418),G0tensor(393))
  call TI_triangle_red(G2tensor(50),RedBasis(61),mass3set(:,7),G0tensor(383),G0tensor(378),G0tensor(388), &
    G0tensor(379),M2L1R1,[nMB,nMW],G0tensor(504),G0tensor(484))
  call TI_triangle_red(G2tensor(43),RedBasis(61),mass3set(:,8),G0tensor(474),G0tensor(424),G0tensor(399), &
    G0tensor(389),M2L1R1,[nMT],G0tensor(384))
  call TI_triangle_red(G2tensor(530),RedBasis(14),mass3set(:,12),G0tensor(398),G0tensor(394),G0tensor(488), &
    G0tensor(408),M2L1R1,[nMT,nMH],G0tensor(403),G0tensor(514))
  call TI_triangle_red(G2tensor(30),RedBasis(5),mass3set(:,10),G0tensor(413),G0tensor(404),G0tensor(534), &
    G0tensor(519),M2L1R1,[nMT],G0tensor(494))
  call TI_triangle_red(G2tensor(54),RedBasis(14),mass3set(:,13),G0tensor(414),G0tensor(409),G0tensor(423), &
    G0tensor(419),M2L1R1,[nMT,nMZ],G0tensor(433),G0tensor(429))
  call TI_triangle_red(G2tensor(55),RedBasis(14),mass3set(:,14),G0tensor(443),G0tensor(439),G0tensor(524), &
    G0tensor(453),M2L1R1,[nMB,nMW],G0tensor(449),G0tensor(463))
  call TI_triangle_red(G2tensor(39),RedBasis(5),mass3set(:,11),G0tensor(459),G0tensor(473),G0tensor(469), &
    G0tensor(483),M2L1R1,[nMB],G0tensor(479))
  call TI_triangle_red(G2tensor(62),RedBasis(14),mass3set(:,15),G0tensor(529),G0tensor(493),G0tensor(489), &
    G0tensor(503),M2L1R1,[nMT],G0tensor(499))
  call TI_triangle_red(G2tensor(70),RedBasis(32),mass3set(:,12),G0tensor(544),G0tensor(539),G0tensor(549), &
    G0tensor(556),M2L1R1,[nMT,nMH],G0tensor(557),G0tensor(558))
  call TI_triangle_red(G2tensor(79),RedBasis(32),mass3set(:,13),G0tensor(559),G0tensor(560),G0tensor(561), &
    G0tensor(562),M2L1R1,[nMT,nMZ],G0tensor(563),G0tensor(564))
  call TI_triangle_red(G2tensor(83),RedBasis(32),mass3set(:,14),G0tensor(565),G0tensor(566),G0tensor(567), &
    G0tensor(568),M2L1R1,[nMB,nMW],G0tensor(569),G0tensor(570))
  call TI_triangle_red(G2tensor(90),RedBasis(32),mass3set(:,15),G0tensor(571),G0tensor(572),G0tensor(573), &
    G0tensor(574),M2L1R1,[nMT],G0tensor(575))
  call TI_triangle_red(G2tensor(94),RedBasis(6),mass3set(:,12),G0tensor(576),G0tensor(577),G0tensor(578), &
    G0tensor(579),M2L1R1,[nMT,nMH],G0tensor(580),G0tensor(581))
  call TI_triangle_red(G2tensor(106),RedBasis(6),mass3set(:,13),G0tensor(582),G0tensor(583),G0tensor(584), &
    G0tensor(585),M2L1R1,[nMT,nMZ],G0tensor(586),G0tensor(587))
  call TI_triangle_red(G2tensor(110),RedBasis(6),mass3set(:,14),G0tensor(588),G0tensor(589),G0tensor(590), &
    G0tensor(591),M2L1R1,[nMB,nMW],G0tensor(592),G0tensor(593))
  call TI_triangle_red(G2tensor(335),RedBasis(6),mass3set(:,15),G0tensor(594),G0tensor(595),G0tensor(596), &
    G0tensor(597),M2L1R1,[nMT],G0tensor(598))
  call TI_triangle_red(G2tensor(115),RedBasis(64),mass3set(:,16),G0tensor(599),G0tensor(600),G0tensor(601), &
    G0tensor(602),M2L1R1,[nMB,nMW],G0tensor(603),G0tensor(604))
  call TI_triangle_red(G2tensor(359),RedBasis(66),mass3set(:,16),G0tensor(605),G0tensor(606),G0tensor(607), &
    G0tensor(608),M2L1R1,[nMB,nMW],G0tensor(609),G0tensor(610))
  call TI_triangle_red(G2tensor(124),RedBasis(65),mass3set(:,7),G0tensor(611),G0tensor(612),G0tensor(613), &
    G0tensor(614),M2L1R1,[nMB,nMW],G0tensor(615),G0tensor(616))
  call TI_triangle_red(G2tensor(374),RedBasis(33),mass3set(:,16),G0tensor(617),G0tensor(618),G0tensor(619), &
    G0tensor(620),M2L1R1,[nMB,nMW],G0tensor(621),G0tensor(622))
  call TI_triangle_red(G2tensor(449),RedBasis(29),mass3set(:,16),G0tensor(623),G0tensor(624),G0tensor(625), &
    G0tensor(626),M2L1R1,[nMB,nMW],G0tensor(627),G0tensor(628))
  call TI_triangle_red(G2tensor(569),RedBasis(67),mass3set(:,7),G0tensor(629),G0tensor(630),G0tensor(631), &
    G0tensor(632),M2L1R1,[nMB,nMW],G0tensor(633),G0tensor(634))
  call TI_triangle_red(G2tensor(434),RedBasis(26),mass3set(:,3),G0tensor(635),G0tensor(636),G0tensor(637), &
    G0tensor(638),M2L1R1,[nMW,nMB],G0tensor(639),G0tensor(640))
  call TI_triangle_red(G2tensor(586),RedBasis(19),mass3set(:,9),G0tensor(641),G0tensor(642),G0tensor(643), &
    G0tensor(644),M2L1R1,[nMW,nMB],G0tensor(645),G0tensor(646))
  call TI_triangle_red(G2tensor(404),RedBasis(22),mass3set(:,3),G0tensor(647),G0tensor(648),G0tensor(649), &
    G0tensor(650),M2L1R1,[nMW,nMB],G0tensor(651),G0tensor(652))
  call TI_triangle_red(G2tensor(197),RedBasis(28),mass3set(:,16),G0tensor(653),G0tensor(654),G0tensor(655), &
    G0tensor(656),M2L1R1,[nMB,nMW],G0tensor(657),G0tensor(658))
  call TI_triangle_red(G2tensor(410),RedBasis(27),mass3set(:,7),G0tensor(659),G0tensor(660),G0tensor(661), &
    G0tensor(662),M2L1R1,[nMB,nMW],G0tensor(663),G0tensor(664))
  call TI_triangle_red(G2tensor(15),RedBasis(3),mass3set(:,10),G0tensor(665),G0tensor(666),G0tensor(667), &
    G0tensor(668),M2L1R1,[nMT],G0tensor(669))
  call TI_triangle_red(G2tensor(22),RedBasis(3),mass3set(:,11),G0tensor(670),G0tensor(671),G0tensor(672), &
    G0tensor(673),M2L1R1,[nMB],G0tensor(674))
  call TI_triangle_red(G3tensor(5),RedBasis(11),mass3set(:,10),G0tensor(675),G0tensor(676),G0tensor(677), &
    G0tensor(678),M2L1R1,[nMT],G0tensor(679))
  call TI_triangle_red(G2tensor(14),RedBasis(10),mass3set(:,12),G0tensor(680),G0tensor(681),G0tensor(682), &
    G0tensor(683),M2L1R1,[nMT,nMH],G0tensor(684),G0tensor(685))
  call TI_triangle_red(G2tensor(18),RedBasis(10),mass3set(:,13),G0tensor(686),G0tensor(687),G0tensor(688), &
    G0tensor(689),M2L1R1,[nMT,nMZ],G0tensor(690),G0tensor(691))
  call TI_triangle_red(G3tensor(6),RedBasis(11),mass3set(:,11),G0tensor(692),G0tensor(693),G0tensor(694), &
    G0tensor(695),M2L1R1,[nMB],G0tensor(696))
  call TI_triangle_red(G2tensor(194),RedBasis(10),mass3set(:,14),G0tensor(697),G0tensor(698),G0tensor(699), &
    G0tensor(700),M2L1R1,[nMB,nMW],G0tensor(701),G0tensor(702))
  call TI_triangle_red(G2tensor(23),RedBasis(10),mass3set(:,15),G0tensor(703),G0tensor(704),G0tensor(705), &
    G0tensor(706),M2L1R1,[nMT],G0tensor(707))
  call TI_triangle_red(G2tensor(178),RedBasis(17),mass3set(:,10),G0tensor(708),G0tensor(709),G0tensor(710), &
    G0tensor(711),M2L1R1,[nMT],G0tensor(712))
  call TI_triangle_red(G2tensor(51),RedBasis(16),mass3set(:,12),G0tensor(713),G0tensor(714),G0tensor(715), &
    G0tensor(716),M2L1R1,[nMT,nMH],G0tensor(717),G0tensor(718))
  call TI_triangle_red(G2tensor(102),RedBasis(15),mass3set(:,10),G0tensor(719),G0tensor(720),G0tensor(721), &
    G0tensor(722),M2L1R1,[nMT],G0tensor(723))
  call TI_triangle_red(G2tensor(533),RedBasis(16),mass3set(:,13),G0tensor(724),G0tensor(725),G0tensor(726), &
    G0tensor(727),M2L1R1,[nMT,nMZ],G0tensor(728),G0tensor(729))
  call TI_triangle_red(G2tensor(177),RedBasis(17),mass3set(:,11),G0tensor(730),G0tensor(731),G0tensor(732), &
    G0tensor(733),M2L1R1,[nMB],G0tensor(734))
  call TI_triangle_red(G2tensor(58),RedBasis(16),mass3set(:,14),G0tensor(735),G0tensor(736),G0tensor(737), &
    G0tensor(738),M2L1R1,[nMB,nMW],G0tensor(739),G0tensor(740))
  call TI_triangle_red(G2tensor(111),RedBasis(15),mass3set(:,11),G0tensor(741),G0tensor(742),G0tensor(743), &
    G0tensor(744),M2L1R1,[nMB],G0tensor(745))
  call TI_triangle_red(G2tensor(66),RedBasis(16),mass3set(:,15),G0tensor(746),G0tensor(747),G0tensor(748), &
    G0tensor(749),M2L1R1,[nMT],G0tensor(750))
  call TI_triangle_red(G2tensor(78),RedBasis(20),mass3set(:,12),G0tensor(751),G0tensor(752),G0tensor(753), &
    G0tensor(754),M2L1R1,[nMT,nMH],G0tensor(755),G0tensor(756))
  call TI_triangle_red(G2tensor(82),RedBasis(20),mass3set(:,13),G0tensor(757),G0tensor(758),G0tensor(759), &
    G0tensor(760),M2L1R1,[nMT,nMZ],G0tensor(761),G0tensor(762))
  call TI_triangle_red(G2tensor(87),RedBasis(20),mass3set(:,14),G0tensor(763),G0tensor(764),G0tensor(765), &
    G0tensor(766),M2L1R1,[nMB,nMW],G0tensor(767),G0tensor(768))
  call TI_triangle_red(G2tensor(91),RedBasis(20),mass3set(:,15),G0tensor(769),G0tensor(770),G0tensor(771), &
    G0tensor(772),M2L1R1,[nMT],G0tensor(773))
  call TI_triangle_red(G2tensor(98),RedBasis(21),mass3set(:,12),G0tensor(774),G0tensor(775),G0tensor(776), &
    G0tensor(777),M2L1R1,[nMT,nMH],G0tensor(778),G0tensor(779))
  call TI_triangle_red(G2tensor(329),RedBasis(21),mass3set(:,13),G0tensor(780),G0tensor(781),G0tensor(782), &
    G0tensor(783),M2L1R1,[nMT,nMZ],G0tensor(784),G0tensor(785))
  call TI_triangle_red(G2tensor(521),RedBasis(21),mass3set(:,14),G0tensor(786),G0tensor(787),G0tensor(788), &
    G0tensor(789),M2L1R1,[nMB,nMW],G0tensor(790),G0tensor(791))
  call TI_triangle_red(G2tensor(114),RedBasis(21),mass3set(:,15),G0tensor(792),G0tensor(793),G0tensor(794), &
    G0tensor(795),M2L1R1,[nMT],G0tensor(796))
  call TI_triangle_red(G2tensor(293),RedBasis(20),mass3set(:,9),G0tensor(797),G0tensor(798),G0tensor(799), &
    G0tensor(800),M2L1R1,[nMW,nMB],G0tensor(801),G0tensor(802))
  call TI_triangle_red(G2tensor(305),RedBasis(21),mass3set(:,9),G0tensor(803),G0tensor(804),G0tensor(805), &
    G0tensor(806),M2L1R1,[nMW,nMB],G0tensor(807),G0tensor(808))
  call TI_triangle_red(G2tensor(395),RedBasis(22),mass3set(:,1),G0tensor(809),G0tensor(810),G0tensor(811), &
    G0tensor(812),M2L1R1,[nMH,nMT],G0tensor(813),G0tensor(814))
  call TI_triangle_red(G2tensor(245),RedBasis(22),mass3set(:,2),G0tensor(815),G0tensor(816),G0tensor(817), &
    G0tensor(818),M2L1R1,[nMZ,nMT],G0tensor(819),G0tensor(820))
  call TI_triangle_red(G2tensor(401),RedBasis(22),mass3set(:,4),G0tensor(821),G0tensor(822),G0tensor(823), &
    G0tensor(824),M2L1R1,[nMT],G0tensor(825))
  call TI_triangle_red(G2tensor(422),RedBasis(26),mass3set(:,1),G0tensor(826),G0tensor(827),G0tensor(828), &
    G0tensor(829),M2L1R1,[nMH,nMT],G0tensor(830),G0tensor(831))
  call TI_triangle_red(G2tensor(431),RedBasis(26),mass3set(:,2),G0tensor(832),G0tensor(833),G0tensor(834), &
    G0tensor(835),M2L1R1,[nMZ,nMT],G0tensor(836),G0tensor(837))
  call TI_triangle_red(G2tensor(428),RedBasis(26),mass3set(:,4),G0tensor(838),G0tensor(839),G0tensor(840), &
    G0tensor(841),M2L1R1,[nMT],G0tensor(842))
  call TI_triangle_red(G3tensor(12),RedBasis(11),mass3set(:,18),G0tensor(843),G0tensor(844),G0tensor(845), &
    G0tensor(846),M2L1R1,[nME],G0tensor(847))
  call TI_triangle_red(G3tensor(13),RedBasis(11),mass3set(:,19),G0tensor(848),G0tensor(849),G0tensor(850), &
    G0tensor(851),M2L1R1,[nMM],G0tensor(852))
  call TI_triangle_red(G3tensor(14),RedBasis(11),mass3set(:,20),G0tensor(853),G0tensor(854),G0tensor(855), &
    G0tensor(856),M2L1R1,[nML],G0tensor(857))
  call TI_triangle_red(G3tensor(18),RedBasis(11),mass3set(:,21),G0tensor(858),G0tensor(859),G0tensor(860),G0tensor(861),M2L1R1)
  call ol_merge_tensors(T0sum(112),[G0tensor(1)])
  call ol_merge_tensors(T0sum(113),[G0tensor(31)])
  call ol_merge_tensors(T0sum(114),[G0tensor(61)])
  call ol_merge_tensors(T0sum(115),[G0tensor(91)])
  call ol_merge_tensors(T0sum(116),[G0tensor(116)])
  call ol_merge_tensors(T0sum(117),[G0tensor(146)])
  call ol_merge_tensors(T0sum(118),[G0tensor(176)])
  call ol_merge_tensors(T0sum(119),[G0tensor(206)])
  call ol_merge_tensors(T0sum(120),[G0tensor(231)])
  call ol_merge_tensors(T0sum(121),[G0tensor(261)])
  call ol_merge_tensors(T0sum(122),[G0tensor(291)])
  call ol_merge_tensors(T0sum(123),[G0tensor(321)])
  call ol_merge_tensors(T0sum(124),[G0tensor(346)])
  call ol_merge_tensors(T0sum(125),[G0tensor(376)])
  call ol_merge_tensors(T0sum(126),[G0tensor(406)])
  call ol_merge_tensors(T0sum(127),[G0tensor(436)])
  call ol_merge_tensors(T0sum(128),[G0tensor(461)])
  call ol_merge_tensors(T0sum(129),[G0tensor(491)])
  call ol_merge_tensors(T0sum(130),[G0tensor(521)])
  call ol_merge_tensors(T0sum(131),[G0tensor(551)])
  call ol_merge_tensors(T0sum(132),[G0tensor(47)])
  call ol_merge_tensors(T0sum(133),[G0tensor(67)])
  call ol_merge_tensors(T0sum(134),[G0tensor(152)])
  call ol_merge_tensors(T0sum(135),[G0tensor(133)])
  call ol_merge_tensors(T0sum(136),[G0tensor(112)])
  call ol_merge_tensors(T0sum(137),[G0tensor(202)])
  call ol_merge_tensors(T0sum(138),[G0tensor(172)])
  call ol_merge_tensors(T0sum(139),[G0tensor(217)])
  call ol_merge_tensors(T0sum(140),[G0tensor(227)])
  call ol_merge_tensors(T0sum(141),[G0tensor(232)])
  call ol_merge_tensors(T0sum(142),[G0tensor(247)])
  call ol_merge_tensors(T0sum(143),[G0tensor(280)])
  call ol_merge_tensors(T0sum(144),[G0tensor(110)])
  call ol_merge_tensors(T0sum(145),[G0tensor(38)])
  call ol_merge_tensors(T0sum(146),[G0tensor(48)])
  call ol_merge_tensors(T0sum(147),[G0tensor(130)])
  call ol_merge_tensors(T0sum(148),[G0tensor(59)])
  call ol_merge_tensors(T0sum(149),[G0tensor(315)])
  call ol_merge_tensors(T0sum(150),[G0tensor(69)])
  call ol_merge_tensors(T0sum(151),[G0tensor(325)])
  call ol_merge_tensors(T0sum(152),[G0tensor(405)])
  call ol_merge_tensors(T0sum(153),[G0tensor(89)])
  call ol_merge_tensors(T0sum(154),[G0tensor(420)])
  call ol_merge_tensors(T0sum(155),[G0tensor(387)])
  call ol_merge_tensors(T0sum(156),[G0tensor(150)])
  call ol_merge_tensors(T0sum(157),[G0tensor(155)])
  call ol_merge_tensors(T0sum(158),[G0tensor(160)])
  call ol_merge_tensors(T0sum(159),[G0tensor(430)])
  call ol_merge_tensors(T0sum(160),[G0tensor(480)])
  call ol_merge_tensors(T0sum(161),[G0tensor(490)])
  call ol_merge_tensors(T0sum(162),[G0tensor(190)])
  call ol_merge_tensors(T0sum(163),[G0tensor(505)])
  call ol_merge_tensors(T0sum(164),[G0tensor(238)])
  call ol_merge_tensors(T0sum(165),[G0tensor(530)])
  call ol_merge_tensors(T0sum(166),[G0tensor(282)])
  call ol_merge_tensors(T0sum(167),[G0tensor(35)])
  call ol_merge_tensors(T0sum(168),[G0tensor(317)])
  call ol_merge_tensors(T0sum(169),[G0tensor(85)])
  call ol_merge_tensors(T0sum(170),[G0tensor(175)])
  call ol_merge_tensors(T0sum(171),[G0tensor(262)])
  call ol_merge_tensors(T0sum(172),[G0tensor(554)])
  call ol_merge_tensors(T0sum(173),[G0tensor(272)])
  call ol_merge_tensors(T0sum(174),[G0tensor(292)])
  call ol_merge_tensors(T0sum(175),[G0tensor(307)])
  call ol_merge_tensors(T0sum(176),[G0tensor(164)])
  call ol_merge_tensors(T0sum(177),[G0tensor(518)])
  call ol_merge_tensors(T0sum(178),[G0tensor(84)])
  call ol_merge_tensors(T0sum(179),[G0tensor(114)])
  call ol_merge_tensors(T0sum(180),[G0tensor(134)])
  call ol_merge_tensors(T0sum(181),[G0tensor(219)])
  call ol_merge_tensors(T0sum(182),[G0tensor(392)])
  call ol_merge_tensors(T0sum(183),[G0tensor(153)])
  call ol_merge_tensors(T0sum(184),[G0tensor(417)])
  call ol_merge_tensors(T0sum(185),[G0tensor(173)])
  call ol_merge_tensors(T0sum(186),[G0tensor(457)])
  call ol_merge_tensors(T0sum(187),[G0tensor(288)])
  call ol_merge_tensors(T0sum(188),[G0tensor(213)])
  call ol_merge_tensors(T0sum(189),[G0tensor(512)])
  call ol_merge_tensors(T0sum(190),[G0tensor(268)])
  call ol_merge_tensors(T0sum(191),[G0tensor(532)])
  call ol_merge_tensors(T0sum(192),[G0tensor(269)])
  call ol_merge_tensors(T0sum(193),[G0tensor(259)])
  call ol_merge_tensors(T0sum(194),[G0tensor(359)])
  call ol_merge_tensors(T0sum(195),[G0tensor(304)])
  call ol_merge_tensors(T0sum(196),[G0tensor(344)])
  call ol_merge_tensors(T0sum(197),[G0tensor(428)])
  call ol_merge_tensors(T0sum(198),[G0tensor(318)])
  call ol_merge_tensors(T0sum(199),[G0tensor(338)])
  call ol_merge_tensors(T0sum(200),[G0tensor(349)])
  call ol_merge_tensors(T0sum(201),[G0tensor(383)])
  call ol_merge_tensors(T0sum(202),[G0tensor(474)])
  call ol_merge_tensors(T0sum(203),[G0tensor(398)])
  call ol_merge_tensors(T0sum(204),[G0tensor(413)])
  call ol_merge_tensors(T0sum(205),[G0tensor(414)])
  call ol_merge_tensors(T0sum(206),[G0tensor(443)])
  call ol_merge_tensors(T0sum(207),[G0tensor(459)])
  call ol_merge_tensors(T0sum(208),[G0tensor(529)])
  call ol_merge_tensors(T0sum(209),[G0tensor(544)])
  call ol_merge_tensors(T0sum(210),[G0tensor(559)])
  call ol_merge_tensors(T0sum(211),[G0tensor(565)])
  call ol_merge_tensors(T0sum(212),[G0tensor(571)])
  call ol_merge_tensors(T0sum(213),[G0tensor(576)])
  call ol_merge_tensors(T0sum(214),[G0tensor(582)])
  call ol_merge_tensors(T0sum(215),[G0tensor(588)])
  call ol_merge_tensors(T0sum(216),[G0tensor(594)])
  call ol_merge_tensors(T0sum(217),[G0tensor(599)])
  call ol_merge_tensors(T0sum(218),[G0tensor(605)])
  call ol_merge_tensors(T0sum(219),[G0tensor(611)])
  call ol_merge_tensors(T0sum(220),[G0tensor(617)])
  call ol_merge_tensors(T0sum(221),[G0tensor(623)])
  call ol_merge_tensors(T0sum(222),[G0tensor(629)])
  call ol_merge_tensors(T0sum(223),[G0tensor(635)])
  call ol_merge_tensors(T0sum(224),[G0tensor(641)])
  call ol_merge_tensors(T0sum(225),[G0tensor(647)])
  call ol_merge_tensors(T0sum(226),[G0tensor(653)])
  call ol_merge_tensors(T0sum(227),[G0tensor(659)])
  call ol_merge_tensors(T0sum(228),[G0tensor(665)])
  call ol_merge_tensors(T0sum(229),[G0tensor(670)])
  call ol_merge_tensors(T0sum(230),[G0tensor(675)])
  call ol_merge_tensors(T0sum(231),[G0tensor(680)])
  call ol_merge_tensors(T0sum(232),[G0tensor(686)])
  call ol_merge_tensors(T0sum(233),[G0tensor(692)])
  call ol_merge_tensors(T0sum(234),[G0tensor(697)])
  call ol_merge_tensors(T0sum(235),[G0tensor(703)])
  call ol_merge_tensors(T0sum(236),[G0tensor(708)])
  call ol_merge_tensors(T0sum(237),[G0tensor(713)])
  call ol_merge_tensors(T0sum(238),[G0tensor(719)])
  call ol_merge_tensors(T0sum(239),[G0tensor(724)])
  call ol_merge_tensors(T0sum(240),[G0tensor(730)])
  call ol_merge_tensors(T0sum(241),[G0tensor(735)])
  call ol_merge_tensors(T0sum(242),[G0tensor(741)])
  call ol_merge_tensors(T0sum(243),[G0tensor(746)])
  call ol_merge_tensors(T0sum(244),[G0tensor(751)])
  call ol_merge_tensors(T0sum(245),[G0tensor(757)])
  call ol_merge_tensors(T0sum(246),[G0tensor(763)])
  call ol_merge_tensors(T0sum(247),[G0tensor(769)])
  call ol_merge_tensors(T0sum(248),[G0tensor(774)])
  call ol_merge_tensors(T0sum(249),[G0tensor(780)])
  call ol_merge_tensors(T0sum(250),[G0tensor(786)])
  call ol_merge_tensors(T0sum(251),[G0tensor(792)])
  call ol_merge_tensors(T0sum(252),[G0tensor(797)])
  call ol_merge_tensors(T0sum(253),[G0tensor(803)])
  call ol_merge_tensors(T0sum(254),[G0tensor(809)])
  call ol_merge_tensors(T0sum(255),[G0tensor(815)])
  call ol_merge_tensors(T0sum(256),[G0tensor(821)])
  call ol_merge_tensors(T0sum(257),[G0tensor(826)])
  call ol_merge_tensors(T0sum(258),[G0tensor(832)])
  call ol_merge_tensors(T0sum(259),[G0tensor(838)])
  call ol_merge_tensors(T0sum(260),[G0tensor(843)])
  call ol_merge_tensors(T0sum(261),[G0tensor(848)])
  call ol_merge_tensors(T0sum(262),[G0tensor(853)])
  call ol_merge_tensors(T0sum(263),[G0tensor(858)])
  Gcoeff(:)%j = (c(12)*M(1,:)%j) * den(47)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(607),h0tab(:,607),[27,4],[nMW,nMW],3,1,wf8(:,13))
  call Hloop_VVS_S(ntryL,G0H32(1),ex4(:),wf8(:,13),G0H2(1),m4h2x8x2(:,1),heltab3x32(:,:,1))
  Gcoeff(:)%j = (c(12)*M(1,:)%j) * den(47)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(608),h0tab(:,608),[27,4],[nMW,nMW],3,1,wf8(:,13))
  call Hloop_VVS_S(ntryL,G0H32(1),ex4(:),wf8(:,13),G0H2(2),m4h2x8x2(:,2),heltab3x32(:,:,2))
  Gcoeff(:)%j = (c(12)*M(1,:)%j) * den(49)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(609),h0tab(:,609),[27,4],[nMW,nMW],3,1,wf8(:,39))
  call Hloop_VVS_S(ntryL,G0H32(1),ex4(:),wf8(:,39),G0H2(3),m4h2x8x2(:,3),heltab3x32(:,:,3))
  Gcoeff(:)%j = (-(c(12)*M(1,:)%j)) * den(49)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(610),h0tab(:,610),[27,4],[nMW,nMW],3,1,wf8(:,39))
  call Hloop_VVS_S(ntryL,G0H32(1),ex4(:),wf8(:,39),G0H2(4),m4h2x8x2(:,4),heltab3x32(:,:,4))
  Gcoeff(:)%j = (-(c(4)*M(1,:)%j)) * den(51)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(611),h0tab(:,611),[27,4],[nMW,nMW],3,1,wf8(:,40))
  call Hloop_SVV_S(ntryL,G0H32(1),ex4(:),wf8(:,40),G0H2(5),m4h2x8x2(:,5),heltab3x32(:,:,5))
  Gcoeff(:)%j = (c(31)*M(1,:)%j) * den(49)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(612),h0tab(:,612),[27,4],[nMW,nMW],3,1,wf8(:,41))
  call Hloop_SVV_S(ntryL,G0H32(1),ex4(:),wf8(:,41),G0H2(6),m4h2x8x2(:,6),heltab3x32(:,:,6))
  Gcoeff(:)%j = (-(c(3)*M(1,:)%j)) * den(51)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(613),h0tab(:,613),[27,4],[nMW,nMW],3,1,wf8(:,40))
  call Hloop_VWW_V(ntryL,G0H32(1),ex4(:),wf8(:,40),G0H2(7),m4h2x8x2(:,7),heltab3x32(:,:,7))
  Gcoeff(:)%j = (-(c(27)*M(1,:)%j)) * den(49)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(614),h0tab(:,614),[27,4],[nMW,nMW],3,1,wf8(:,41))
  call Hloop_VWW_V(ntryL,G0H32(1),ex4(:),wf8(:,41),G0H2(8),m4h2x8x2(:,8),heltab3x32(:,:,8))
  Gcoeff(:)%j = (c(12)*M(1,:)%j) * den(52)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(615),h0tab(:,615),[27,4],[nMW,nMW],3,1,wf8(:,14))
  call Hloop_VVS_S(ntryL,G0H32(1),ex4(:),wf8(:,14),G0H2(9),m4h2x8x2(:,9),heltab3x32(:,:,9))
  Gcoeff(:)%j = (c(12)*M(1,:)%j) * den(52)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(616),h0tab(:,616),[27,4],[nMW,nMW],3,1,wf8(:,14))
  call Hloop_VVS_S(ntryL,G0H32(1),ex4(:),wf8(:,14),G0H2(10),m4h2x8x2(:,10),heltab3x32(:,:,10))
  Gcoeff(:)%j = (c(12)*M(1,:)%j) * den(53)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(617),h0tab(:,617),[27,4],[nMW,nMW],3,1,wf8(:,42))
  call Hloop_VVS_S(ntryL,G0H32(1),ex4(:),wf8(:,42),G0H2(11),m4h2x8x2(:,11),heltab3x32(:,:,11))
  Gcoeff(:)%j = (-(c(12)*M(1,:)%j)) * den(53)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(618),h0tab(:,618),[27,4],[nMW,nMW],3,1,wf8(:,42))
  call Hloop_VVS_S(ntryL,G0H32(1),ex4(:),wf8(:,42),G0H2(12),m4h2x8x2(:,12),heltab3x32(:,:,12))
  Gcoeff(:)%j = (-(c(4)*M(1,:)%j)) * den(54)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(619),h0tab(:,619),[27,4],[nMW,nMW],3,1,wf8(:,43))
  call Hloop_SVV_S(ntryL,G0H32(1),ex4(:),wf8(:,43),G0H2(13),m4h2x8x2(:,13),heltab3x32(:,:,13))
  Gcoeff(:)%j = (c(31)*M(1,:)%j) * den(53)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(620),h0tab(:,620),[27,4],[nMW,nMW],3,1,wf8(:,44))
  call Hloop_SVV_S(ntryL,G0H32(1),ex4(:),wf8(:,44),G0H2(14),m4h2x8x2(:,14),heltab3x32(:,:,14))
  Gcoeff(:)%j = (-(c(3)*M(1,:)%j)) * den(54)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(621),h0tab(:,621),[27,4],[nMW,nMW],3,1,wf8(:,43))
  call Hloop_VWW_V(ntryL,G0H32(1),ex4(:),wf8(:,43),G0H2(15),m4h2x8x2(:,15),heltab3x32(:,:,15))
  Gcoeff(:)%j = (-(c(27)*M(1,:)%j)) * den(53)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(622),h0tab(:,622),[27,4],[nMW,nMW],3,1,wf8(:,44))
  call Hloop_VWW_V(ntryL,G0H32(1),ex4(:),wf8(:,44),G0H2(16),m4h2x8x2(:,16),heltab3x32(:,:,16))
  Gcoeff(:)%j = (c(12)*M(1,:)%j) * den(47)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(623),h0tab(:,623),[23,8],[nMW,nMW],3,1,wf8(:,13))
  call Hloop_VVS_S(ntryL,G0H32(1),ex3(:),wf8(:,13),G0H2(17),m4h2x8x2(:,17),heltab3x32(:,:,17))
  Gcoeff(:)%j = (c(12)*M(1,:)%j) * den(47)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(624),h0tab(:,624),[23,8],[nMW,nMW],3,1,wf8(:,13))
  call Hloop_VVS_S(ntryL,G0H32(1),ex3(:),wf8(:,13),G0H2(18),m4h2x8x2(:,18),heltab3x32(:,:,18))
  Gcoeff(:)%j = (c(12)*M(1,:)%j) * den(49)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(625),h0tab(:,625),[23,8],[nMW,nMW],3,1,wf8(:,39))
  call Hloop_VVS_S(ntryL,G0H32(1),ex3(:),wf8(:,39),G0H2(19),m4h2x8x2(:,19),heltab3x32(:,:,19))
  Gcoeff(:)%j = (-(c(12)*M(1,:)%j)) * den(49)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(626),h0tab(:,626),[23,8],[nMW,nMW],3,1,wf8(:,39))
  call Hloop_VVS_S(ntryL,G0H32(1),ex3(:),wf8(:,39),G0H2(20),m4h2x8x2(:,20),heltab3x32(:,:,20))
  Gcoeff(:)%j = (-(c(4)*M(1,:)%j)) * den(51)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(627),h0tab(:,627),[23,8],[nMW,nMW],3,1,wf8(:,40))
  call Hloop_SVV_S(ntryL,G0H32(1),ex3(:),wf8(:,40),G0H2(21),m4h2x8x2(:,21),heltab3x32(:,:,21))
  Gcoeff(:)%j = (c(31)*M(1,:)%j) * den(49)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(628),h0tab(:,628),[23,8],[nMW,nMW],3,1,wf8(:,41))
  call Hloop_SVV_S(ntryL,G0H32(1),ex3(:),wf8(:,41),G0H2(22),m4h2x8x2(:,22),heltab3x32(:,:,22))
  Gcoeff(:)%j = (-(c(3)*M(1,:)%j)) * den(51)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(629),h0tab(:,629),[23,8],[nMW,nMW],3,1,wf8(:,40))
  call Hloop_VWW_V(ntryL,G0H32(1),ex3(:),wf8(:,40),G0H2(23),m4h2x8x2(:,23),heltab3x32(:,:,23))
  Gcoeff(:)%j = (-(c(27)*M(1,:)%j)) * den(49)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(630),h0tab(:,630),[23,8],[nMW,nMW],3,1,wf8(:,41))
  call Hloop_VWW_V(ntryL,G0H32(1),ex3(:),wf8(:,41),G0H2(24),m4h2x8x2(:,24),heltab3x32(:,:,24))
  Gcoeff(:)%j = (c(12)*M(1,:)%j) * den(52)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(631),h0tab(:,631),[23,8],[nMW,nMW],3,1,wf8(:,14))
  call Hloop_VVS_S(ntryL,G0H32(1),ex3(:),wf8(:,14),G0H2(25),m4h2x8x2(:,25),heltab3x32(:,:,25))
  Gcoeff(:)%j = (c(12)*M(1,:)%j) * den(52)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(632),h0tab(:,632),[23,8],[nMW,nMW],3,1,wf8(:,14))
  call Hloop_VVS_S(ntryL,G0H32(1),ex3(:),wf8(:,14),G0H2(26),m4h2x8x2(:,26),heltab3x32(:,:,26))
  Gcoeff(:)%j = (c(12)*M(1,:)%j) * den(53)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(633),h0tab(:,633),[23,8],[nMW,nMW],3,1,wf8(:,42))
  call Hloop_VVS_S(ntryL,G0H32(1),ex3(:),wf8(:,42),G0H2(27),m4h2x8x2(:,27),heltab3x32(:,:,27))
  Gcoeff(:)%j = (-(c(12)*M(1,:)%j)) * den(53)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(634),h0tab(:,634),[23,8],[nMW,nMW],3,1,wf8(:,42))
  call Hloop_VVS_S(ntryL,G0H32(1),ex3(:),wf8(:,42),G0H2(28),m4h2x8x2(:,28),heltab3x32(:,:,28))
  Gcoeff(:)%j = (-(c(4)*M(1,:)%j)) * den(54)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(635),h0tab(:,635),[23,8],[nMW,nMW],3,1,wf8(:,43))
  call Hloop_SVV_S(ntryL,G0H32(1),ex3(:),wf8(:,43),G0H2(29),m4h2x8x2(:,29),heltab3x32(:,:,29))
  Gcoeff(:)%j = (c(31)*M(1,:)%j) * den(53)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(636),h0tab(:,636),[23,8],[nMW,nMW],3,1,wf8(:,44))
  call Hloop_SVV_S(ntryL,G0H32(1),ex3(:),wf8(:,44),G0H2(30),m4h2x8x2(:,30),heltab3x32(:,:,30))
  Gcoeff(:)%j = (-(c(3)*M(1,:)%j)) * den(54)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(637),h0tab(:,637),[23,8],[nMW,nMW],3,1,wf8(:,43))
  call Hloop_VWW_V(ntryL,G0H32(1),ex3(:),wf8(:,43),G0H2(31),m4h2x8x2(:,31),heltab3x32(:,:,31))
  Gcoeff(:)%j = (-(c(27)*M(1,:)%j)) * den(53)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(638),h0tab(:,638),[23,8],[nMW,nMW],3,1,wf8(:,44))
  call Hloop_VWW_V(ntryL,G0H32(1),ex3(:),wf8(:,44),G0H2(32),m4h2x8x2(:,32),heltab3x32(:,:,32))
  Gcoeff(:)%j = (c(23)*M(1,:)%j) * den(47)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(639),h0tab(:,639),[19,12],[nMW,nMW],3,1,wf8(:,13))
  call Hloop_SS_S(ntryL,G0H32(1),wf8(:,13),G0H4(2),m3h8x4(:,321),heltab2x32(:,:,607))
  Gcoeff(:)%j = (c(13)*M(1,:)%j) * den(47)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(640),h0tab(:,640),[19,12],[nMW,nMW],3,1,wf8(:,13))
  call Hloop_VS_V(ntryL,G0H32(1),wf8(:,13),G0H4(1),m3h8x4(:,322),heltab2x32(:,:,608))
  Gcoeff(:)%j = (-(c(4)*M(1,:)%j)) * den(51)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(641),h0tab(:,641),[19,12],[nMW,nMW],3,1,wf8(:,40))
  call Hloop_TV_S(ntryL,G0H32(1),0,wf8(:,40),19,G1H4(67),m3h8x4(:,323),heltab2x32(:,:,609))
  Gcoeff(:)%j = (c(31)*M(1,:)%j) * den(49)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(642),h0tab(:,642),[19,12],[nMW,nMW],3,1,wf8(:,41))
  call Hloop_TV_S(ntryL,G0H32(1),0,wf8(:,41),19,G1H4(29),m3h8x4(:,324),heltab2x32(:,:,610))
  Gcoeff(:)%j = (-(c(3)*M(1,:)%j)) * den(51)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(643),h0tab(:,643),[19,12],[nMW,nMW],3,1,wf8(:,40))
  call Hloop_UV_W(ntryL,G0H32(1),0,wf8(:,40),19,G1H4(75),m3h8x4(:,325),heltab2x32(:,:,611))
  Gcoeff(:)%j = (-(c(27)*M(1,:)%j)) * den(49)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(644),h0tab(:,644),[19,12],[nMW,nMW],3,1,wf8(:,41))
  call Hloop_UV_W(ntryL,G0H32(1),0,wf8(:,41),19,G1H4(171),m3h8x4(:,326),heltab2x32(:,:,612))
  Gcoeff(:)%j = (c(23)*M(1,:)%j) * den(52)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(645),h0tab(:,645),[19,12],[nMW,nMW],3,1,wf8(:,14))
  call Hloop_SS_S(ntryL,G0H32(1),wf8(:,14),G0H4(6),m3h8x4(:,327),heltab2x32(:,:,613))
  Gcoeff(:)%j = (c(13)*M(1,:)%j) * den(52)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(646),h0tab(:,646),[19,12],[nMW,nMW],3,1,wf8(:,14))
  call Hloop_VS_V(ntryL,G0H32(1),wf8(:,14),G0H4(7),m3h8x4(:,328),heltab2x32(:,:,614))
  Gcoeff(:)%j = (-(c(4)*M(1,:)%j)) * den(54)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(647),h0tab(:,647),[19,12],[nMW,nMW],3,1,wf8(:,43))
  call Hloop_TV_S(ntryL,G0H32(1),0,wf8(:,43),19,G1H4(135),m3h8x4(:,329),heltab2x32(:,:,615))
  Gcoeff(:)%j = (c(31)*M(1,:)%j) * den(53)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(648),h0tab(:,648),[19,12],[nMW,nMW],3,1,wf8(:,44))
  call Hloop_TV_S(ntryL,G0H32(1),0,wf8(:,44),19,G1H4(162),m3h8x4(:,330),heltab2x32(:,:,616))
  Gcoeff(:)%j = (-(c(3)*M(1,:)%j)) * den(54)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(649),h0tab(:,649),[19,12],[nMW,nMW],3,1,wf8(:,43))
  call Hloop_UV_W(ntryL,G0H32(1),0,wf8(:,43),19,G1H4(110),m3h8x4(:,331),heltab2x32(:,:,617))
  Gcoeff(:)%j = (-(c(27)*M(1,:)%j)) * den(53)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(650),h0tab(:,650),[19,12],[nMW,nMW],3,1,wf8(:,44))
  call Hloop_UV_W(ntryL,G0H32(1),0,wf8(:,44),19,G1H4(68),m3h8x4(:,332),heltab2x32(:,:,618))
  Gcoeff(:)%j = (-(c(24)*M(1,:)%j)) * den(21)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(651),h0tab(:,651),[21,10],[nMT,nMH],2,2,wf8(:,23),wf4(:,4))
  call Hloop_SQ_A(ntryL,G0H32(1),wf8(:,23),G0H4(8),ngH,m3h8x4(:,333),heltab2x32(:,:,619))
  call Hloop_Q_A(ntryL,G0H4(8),21,nMT,G1H4(142),n2h4(237))
  Gcoeff(:)%j = (c(24)*M(1,:)%j) * den(21)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(652),h0tab(:,652),[21,10],[nMT,nMZ],2,2,wf8(:,23),wf4(:,4))
  call Hloop_SQ_A(ntryL,G0H32(1),wf8(:,23),G0H4(9),ngX,m3h8x4(:,334),heltab2x32(:,:,620))
  call Hloop_Q_A(ntryL,G0H4(9),21,nMT,G1H4(14),n2h4(238))
  Gcoeff(:)%j = (c(18)*M(1,:)%j) * den(21)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(653),h0tab(:,653),[21,10],[nMB,nMW],2,2,wf8(:,23),wf4(:,4))
  call Hloop_SQ_A(ntryL,G0H32(1),wf8(:,23),G0H4(10),ngPbt,m3h8x4(:,335),heltab2x32(:,:,621))
  call Hloop_Q_A(ntryL,G0H4(10),21,nMB,G1H4(177),n2h4(239))
  Gcoeff(:)%j = (c(1)*M(1,:)%j) * den(21)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(654),h0tab(:,654),[21,10],[nMT,0],2,2,wf8(:,23),wf4(:,4))
  call Hloop_VQ_A(ntryL,G0H32(1),wf8(:,23),G0H4(11),m3h8x4(:,336),heltab2x32(:,:,622))
  call Hloop_Q_A(ntryL,G0H4(11),21,nMT,G1H4(141),n2h4(240))
  Gcoeff(:)%j = (c(2)*M(1,:)%j) * den(21)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(655),h0tab(:,655),[21,10],[nMT,nMZ],2,2,wf8(:,23),wf4(:,4))
  call Hloop_ZQ_A(ntryL,G0H32(1),wf8(:,23),G0H4(12),ngZu,m3h8x4(:,337),heltab2x32(:,:,623))
  call Hloop_Q_A(ntryL,G0H4(12),21,nMT,G1H4(163),n2h4(241))
  Gcoeff(:)%j = (c(9)*M(1,:)%j) * den(21)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(656),h0tab(:,656),[21,10],[nMB,nMW],2,2,wf8(:,23),wf4(:,4))
  call Hloop_WQ_A(ntryL,G0H32(1),wf8(:,23),G0H4(13),m3h8x4(:,338),heltab2x32(:,:,624))
  call Hloop_Q_A(ntryL,G0H4(13),21,nMB,G1H4(113),n2h4(242))
  Gcoeff(:)%j = (-(c(24)*M(1,:)%j)) * den(18)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(657),h0tab(:,657),[26,5],[nMT,nMH],2,2,wf8(:,22),wf4(:,3))
  call Hloop_SA_Q(ntryL,G0H32(1),wf8(:,22),G0H4(14),ngH,m3h8x4(:,339),heltab2x32(:,:,625))
  call Hloop_A_Q(ntryL,G0H4(14),26,nMT,G1H4(84),n2h4(243))
  Gcoeff(:)%j = (c(24)*M(1,:)%j) * den(18)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(658),h0tab(:,658),[26,5],[nMT,nMZ],2,2,wf8(:,22),wf4(:,3))
  call Hloop_SA_Q(ntryL,G0H32(1),wf8(:,22),G0H4(15),ngX,m3h8x4(:,340),heltab2x32(:,:,626))
  call Hloop_A_Q(ntryL,G0H4(15),26,nMT,G1H4(36),n2h4(244))
  Gcoeff(:)%j = (c(18)*M(1,:)%j) * den(18)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(659),h0tab(:,659),[26,5],[nMB,nMW],2,2,wf8(:,22),wf4(:,3))
  call Hloop_SA_Q(ntryL,G0H32(1),wf8(:,22),G0H4(16),ngPtb,m3h8x4(:,341),heltab2x32(:,:,627))
  call Hloop_A_Q(ntryL,G0H4(16),26,nMB,G1H4(81),n2h4(245))
  Gcoeff(:)%j = (c(1)*M(1,:)%j) * den(18)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(660),h0tab(:,660),[26,5],[nMT,0],2,2,wf8(:,22),wf4(:,3))
  call Hloop_VA_Q(ntryL,G0H32(1),wf8(:,22),G0H4(17),m3h8x4(:,342),heltab2x32(:,:,628))
  call Hloop_A_Q(ntryL,G0H4(17),26,nMT,G1H4(195),n2h4(246))
  Gcoeff(:)%j = (c(2)*M(1,:)%j) * den(18)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(661),h0tab(:,661),[26,5],[nMT,nMZ],2,2,wf8(:,22),wf4(:,3))
  call Hloop_ZA_Q(ntryL,G0H32(1),wf8(:,22),G0H4(18),ngZu,m3h8x4(:,343),heltab2x32(:,:,629))
  call Hloop_A_Q(ntryL,G0H4(18),26,nMT,G1H4(147),n2h4(247))
  Gcoeff(:)%j = (c(9)*M(1,:)%j) * den(18)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(662),h0tab(:,662),[26,5],[nMB,nMW],2,2,wf8(:,22),wf4(:,3))
  call Hloop_WA_Q(ntryL,G0H32(1),wf8(:,22),G0H4(19),m3h8x4(:,344),heltab2x32(:,:,630))
  call Hloop_A_Q(ntryL,G0H4(19),26,nMB,G1H4(164),n2h4(248))
  Gcoeff(:)%j = (-(c(24)*M(1,:)%j)) * den(26)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(663),h0tab(:,663),[18,13],[nMH,nMT],2,2,wf4(:,6),wf8(:,26))
  call Hloop_QA_S(ntryL,G0H32(1),wf4(:,6),G0H8(23),ngH,m3h4x8(:,117),heltab2x32(:,:,631))
  Gcoeff(:)%j = (c(24)*M(1,:)%j) * den(26)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(664),h0tab(:,664),[18,13],[nMZ,nMT],2,2,wf4(:,6),wf8(:,26))
  call Hloop_QA_S(ntryL,G0H32(1),wf4(:,6),G0H8(24),ngX,m3h4x8(:,118),heltab2x32(:,:,632))
  Gcoeff(:)%j = (c(18)*M(1,:)%j) * den(26)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(665),h0tab(:,665),[18,13],[nMW,nMB],2,2,wf4(:,6),wf8(:,26))
  call Hloop_QA_S(ntryL,G0H32(1),wf4(:,6),G0H8(25),ngPtb,m3h4x8(:,119),heltab2x32(:,:,633))
  Gcoeff(:)%j = (c(1)*M(1,:)%j) * den(26)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(666),h0tab(:,666),[18,13],[0,nMT],2,2,wf4(:,6),wf8(:,26))
  call Hloop_QA_V(ntryL,G0H32(1),wf4(:,6),G0H8(26),m3h4x8(:,120),heltab2x32(:,:,634))
  Gcoeff(:)%j = (c(2)*M(1,:)%j) * den(26)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(667),h0tab(:,667),[18,13],[nMZ,nMT],2,2,wf4(:,6),wf8(:,26))
  call Hloop_QA_Z(ntryL,G0H32(1),wf4(:,6),G0H8(28),ngZu,m3h4x8(:,121),heltab2x32(:,:,635))
  Gcoeff(:)%j = (c(9)*M(1,:)%j) * den(26)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(668),h0tab(:,668),[18,13],[nMW,nMB],2,2,wf4(:,6),wf8(:,26))
  call Hloop_QA_W(ntryL,G0H32(1),wf4(:,6),G0H8(29),m3h4x8(:,122),heltab2x32(:,:,636))
  Gcoeff(:)%j = (-(c(24)*M(1,:)%j)) * den(23)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(669),h0tab(:,669),[26,5],[nMT,nMH],2,2,wf8(:,25),wf4(:,3))
  call Hloop_SA_Q(ntryL,G0H32(1),wf8(:,25),G0H4(20),ngH,m3h8x4(:,345),heltab2x32(:,:,637))
  call Hloop_A_Q(ntryL,G0H4(20),26,nMT,G1H4(114),n2h4(249))
  Gcoeff(:)%j = (c(24)*M(1,:)%j) * den(23)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(670),h0tab(:,670),[26,5],[nMT,nMZ],2,2,wf8(:,25),wf4(:,3))
  call Hloop_SA_Q(ntryL,G0H32(1),wf8(:,25),G0H4(21),ngX,m3h8x4(:,346),heltab2x32(:,:,638))
  call Hloop_A_Q(ntryL,G0H4(21),26,nMT,G1H4(90),n2h4(250))
  Gcoeff(:)%j = (c(18)*M(1,:)%j) * den(23)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(671),h0tab(:,671),[26,5],[nMB,nMW],2,2,wf8(:,25),wf4(:,3))
  call Hloop_SA_Q(ntryL,G0H32(1),wf8(:,25),G0H4(22),ngPtb,m3h8x4(:,347),heltab2x32(:,:,639))
  call Hloop_A_Q(ntryL,G0H4(22),26,nMB,G1H4(37),n2h4(251))
  Gcoeff(:)%j = (c(1)*M(1,:)%j) * den(23)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(672),h0tab(:,672),[26,5],[nMT,0],2,2,wf8(:,25),wf4(:,3))
  call Hloop_VA_Q(ntryL,G0H32(1),wf8(:,25),G0H4(23),m3h8x4(:,348),heltab2x32(:,:,640))
  call Hloop_A_Q(ntryL,G0H4(23),26,nMT,G1H4(13),n2h4(252))
  Gcoeff(:)%j = (c(2)*M(1,:)%j) * den(23)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(673),h0tab(:,673),[26,5],[nMT,nMZ],2,2,wf8(:,25),wf4(:,3))
  call Hloop_ZA_Q(ntryL,G0H32(1),wf8(:,25),G0H4(24),ngZu,m3h8x4(:,349),heltab2x32(:,:,641))
  call Hloop_A_Q(ntryL,G0H4(24),26,nMT,G1H4(201),n2h4(253))
  Gcoeff(:)%j = (c(9)*M(1,:)%j) * den(23)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(674),h0tab(:,674),[26,5],[nMB,nMW],2,2,wf8(:,25),wf4(:,3))
  call Hloop_WA_Q(ntryL,G0H32(1),wf8(:,25),G0H4(69),m3h8x4(:,350),heltab2x32(:,:,642))
  call Hloop_A_Q(ntryL,G0H4(69),26,nMB,G1H4(154),n2h4(254))
  Gcoeff(:)%j = (-(c(24)*M(1,:)%j)) * den(32)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(675),h0tab(:,675),[25,6],[nMT,nMH],2,2,wf8(:,29),wf4(:,10))
  call Hloop_SQ_A(ntryL,G0H32(1),wf8(:,29),G0H4(25),ngH,m3h8x4(:,351),heltab2x32(:,:,643))
  call Hloop_Q_A(ntryL,G0H4(25),25,nMT,G1H4(170),n2h4(255))
  Gcoeff(:)%j = (c(24)*M(1,:)%j) * den(32)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(676),h0tab(:,676),[25,6],[nMT,nMZ],2,2,wf8(:,29),wf4(:,10))
  call Hloop_SQ_A(ntryL,G0H32(1),wf8(:,29),G0H4(70),ngX,m3h8x4(:,352),heltab2x32(:,:,644))
  call Hloop_Q_A(ntryL,G0H4(70),25,nMT,G1H4(115),n2h4(256))
  Gcoeff(:)%j = (c(18)*M(1,:)%j) * den(32)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(677),h0tab(:,677),[25,6],[nMB,nMW],2,2,wf8(:,29),wf4(:,10))
  call Hloop_SQ_A(ntryL,G0H32(1),wf8(:,29),G0H4(26),ngPbt,m3h8x4(:,353),heltab2x32(:,:,645))
  call Hloop_Q_A(ntryL,G0H4(26),25,nMB,G1H4(91),n2h4(257))
  Gcoeff(:)%j = (c(1)*M(1,:)%j) * den(32)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(678),h0tab(:,678),[25,6],[nMT,0],2,2,wf8(:,29),wf4(:,10))
  call Hloop_VQ_A(ntryL,G0H32(1),wf8(:,29),G0H4(77),m3h8x4(:,354),heltab2x32(:,:,646))
  call Hloop_Q_A(ntryL,G0H4(77),25,nMT,G1H4(35),n2h4(258))
  Gcoeff(:)%j = (c(2)*M(1,:)%j) * den(32)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(679),h0tab(:,679),[25,6],[nMT,nMZ],2,2,wf8(:,29),wf4(:,10))
  call Hloop_ZQ_A(ntryL,G0H32(1),wf8(:,29),G0H4(75),ngZu,m3h8x4(:,355),heltab2x32(:,:,647))
  call Hloop_Q_A(ntryL,G0H4(75),25,nMT,G1H4(17),n2h4(259))
  Gcoeff(:)%j = (c(9)*M(1,:)%j) * den(32)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(680),h0tab(:,680),[25,6],[nMB,nMW],2,2,wf8(:,29),wf4(:,10))
  call Hloop_WQ_A(ntryL,G0H32(1),wf8(:,29),G0H4(73),m3h8x4(:,356),heltab2x32(:,:,648))
  call Hloop_Q_A(ntryL,G0H4(73),25,nMB,G1H4(3),n2h4(260))
  Gcoeff(:)%j = (-(c(24)*M(1,:)%j)) * den(29)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(681),h0tab(:,681),[22,9],[nMT,nMH],2,2,wf8(:,28),wf4(:,9))
  call Hloop_SA_Q(ntryL,G0H32(1),wf8(:,28),G0H4(71),ngH,m3h8x4(:,357),heltab2x32(:,:,649))
  call Hloop_A_Q(ntryL,G0H4(71),22,nMT,G1H4(148),n2h4(261))
  Gcoeff(:)%j = (c(24)*M(1,:)%j) * den(29)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(682),h0tab(:,682),[22,9],[nMT,nMZ],2,2,wf8(:,28),wf4(:,9))
  call Hloop_SA_Q(ntryL,G0H32(1),wf8(:,28),G0H4(33),ngX,m3h8x4(:,358),heltab2x32(:,:,650))
  call Hloop_A_Q(ntryL,G0H4(33),22,nMT,G1H4(176),n2h4(262))
  Gcoeff(:)%j = (c(18)*M(1,:)%j) * den(29)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(683),h0tab(:,683),[22,9],[nMB,nMW],2,2,wf8(:,28),wf4(:,9))
  call Hloop_SA_Q(ntryL,G0H32(1),wf8(:,28),G0H4(31),ngPtb,m3h8x4(:,359),heltab2x32(:,:,651))
  call Hloop_A_Q(ntryL,G0H4(31),22,nMB,G1H4(116),n2h4(263))
  Gcoeff(:)%j = (c(1)*M(1,:)%j) * den(29)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(684),h0tab(:,684),[22,9],[nMT,0],2,2,wf8(:,28),wf4(:,9))
  call Hloop_VA_Q(ntryL,G0H32(1),wf8(:,28),G0H4(29),m3h8x4(:,360),heltab2x32(:,:,652))
  call Hloop_A_Q(ntryL,G0H4(29),22,nMT,G1H4(92),n2h4(264))
  Gcoeff(:)%j = (c(2)*M(1,:)%j) * den(29)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(685),h0tab(:,685),[22,9],[nMT,nMZ],2,2,wf8(:,28),wf4(:,9))
  call Hloop_ZA_Q(ntryL,G0H32(1),wf8(:,28),G0H4(27),ngZu,m3h8x4(:,361),heltab2x32(:,:,653))
  call Hloop_A_Q(ntryL,G0H4(27),22,nMT,G1H4(166),n2h4(265))
  Gcoeff(:)%j = (c(9)*M(1,:)%j) * den(29)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(686),h0tab(:,686),[22,9],[nMB,nMW],2,2,wf8(:,28),wf4(:,9))
  call Hloop_WA_Q(ntryL,G0H32(1),wf8(:,28),G0H4(78),m3h8x4(:,362),heltab2x32(:,:,654))
  call Hloop_A_Q(ntryL,G0H4(78),22,nMB,G1H4(18),n2h4(266))
  Gcoeff(:)%j = (-(c(24)*M(1,:)%j)) * den(37)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(687),h0tab(:,687),[25,6],[nMT,nMH],2,2,wf8(:,32),wf4(:,10))
  call Hloop_SQ_A(ntryL,G0H32(1),wf8(:,32),G0H4(76),ngH,m3h8x4(:,363),heltab2x32(:,:,655))
  call Hloop_Q_A(ntryL,G0H4(76),25,nMT,G1H4(1),n2h4(267))
  Gcoeff(:)%j = (c(24)*M(1,:)%j) * den(37)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(688),h0tab(:,688),[25,6],[nMT,nMZ],2,2,wf8(:,32),wf4(:,10))
  call Hloop_SQ_A(ntryL,G0H32(1),wf8(:,32),G0H4(74),ngX,m3h8x4(:,364),heltab2x32(:,:,656))
  call Hloop_Q_A(ntryL,G0H4(74),25,nMT,G1H4(50),n2h4(268))
  Gcoeff(:)%j = (c(18)*M(1,:)%j) * den(37)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(689),h0tab(:,689),[25,6],[nMB,nMW],2,2,wf8(:,32),wf4(:,10))
  call Hloop_SQ_A(ntryL,G0H32(1),wf8(:,32),G0H4(72),ngPbt,m3h8x4(:,365),heltab2x32(:,:,657))
  call Hloop_Q_A(ntryL,G0H4(72),25,nMB,G1H4(180),n2h4(269))
  Gcoeff(:)%j = (c(1)*M(1,:)%j) * den(37)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(690),h0tab(:,690),[25,6],[nMT,0],2,2,wf8(:,32),wf4(:,10))
  call Hloop_VQ_A(ntryL,G0H32(1),wf8(:,32),G0H4(34),m3h8x4(:,366),heltab2x32(:,:,658))
  call Hloop_Q_A(ntryL,G0H4(34),25,nMT,G1H4(119),n2h4(270))
  Gcoeff(:)%j = (c(2)*M(1,:)%j) * den(37)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(691),h0tab(:,691),[25,6],[nMT,nMZ],2,2,wf8(:,32),wf4(:,10))
  call Hloop_ZQ_A(ntryL,G0H32(1),wf8(:,32),G0H4(32),ngZu,m3h8x4(:,367),heltab2x32(:,:,659))
  call Hloop_Q_A(ntryL,G0H4(32),25,nMT,G1H4(95),n2h4(271))
  Gcoeff(:)%j = (c(9)*M(1,:)%j) * den(37)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(692),h0tab(:,692),[25,6],[nMB,nMW],2,2,wf8(:,32),wf4(:,10))
  call Hloop_WQ_A(ntryL,G0H32(1),wf8(:,32),G0H4(30),m3h8x4(:,368),heltab2x32(:,:,660))
  call Hloop_Q_A(ntryL,G0H4(30),25,nMB,G1H4(59),n2h4(272))
  Gcoeff(:)%j = (-(c(24)*M(1,:)%j)) * den(35)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(693),h0tab(:,693),[17,14],[nMH,nMT],2,2,wf4(:,12),wf8(:,31))
  call Hloop_AQ_S(ntryL,G0H32(1),wf4(:,12),G0H8(30),ngH,m3h4x8(:,123),heltab2x32(:,:,661))
  Gcoeff(:)%j = (c(24)*M(1,:)%j) * den(35)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(694),h0tab(:,694),[17,14],[nMZ,nMT],2,2,wf4(:,12),wf8(:,31))
  call Hloop_AQ_S(ntryL,G0H32(1),wf4(:,12),G0H8(1),ngX,m3h4x8(:,124),heltab2x32(:,:,662))
  Gcoeff(:)%j = (c(18)*M(1,:)%j) * den(35)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(695),h0tab(:,695),[17,14],[nMW,nMB],2,2,wf4(:,12),wf8(:,31))
  call Hloop_AQ_S(ntryL,G0H32(1),wf4(:,12),G0H8(2),ngPbt,m3h4x8(:,125),heltab2x32(:,:,663))
  Gcoeff(:)%j = (c(1)*M(1,:)%j) * den(35)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(696),h0tab(:,696),[17,14],[0,nMT],2,2,wf4(:,12),wf8(:,31))
  call Hloop_AQ_V(ntryL,G0H32(1),wf4(:,12),G0H8(3),m3h4x8(:,126),heltab2x32(:,:,664))
  Gcoeff(:)%j = (c(2)*M(1,:)%j) * den(35)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(697),h0tab(:,697),[17,14],[nMZ,nMT],2,2,wf4(:,12),wf8(:,31))
  call Hloop_AQ_Z(ntryL,G0H32(1),wf4(:,12),G0H8(11),ngZu,m3h4x8(:,127),heltab2x32(:,:,665))
  Gcoeff(:)%j = (c(9)*M(1,:)%j) * den(35)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(698),h0tab(:,698),[17,14],[nMW,nMB],2,2,wf4(:,12),wf8(:,31))
  call Hloop_AQ_W(ntryL,G0H32(1),wf4(:,12),G0H8(12),m3h4x8(:,128),heltab2x32(:,:,666))
  Gcoeff(:)%j = (-(c(24)*M(1,:)%j)) * den(41)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(699),h0tab(:,699),[18,13],[nMH,nMT],2,2,wf4(:,6),wf8(:,35))
  call Hloop_QA_S(ntryL,G0H32(1),wf4(:,6),G0H8(13),ngH,m3h4x8(:,129),heltab2x32(:,:,667))
  Gcoeff(:)%j = (c(24)*M(1,:)%j) * den(41)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(700),h0tab(:,700),[18,13],[nMZ,nMT],2,2,wf4(:,6),wf8(:,35))
  call Hloop_QA_S(ntryL,G0H32(1),wf4(:,6),G0H8(4),ngX,m3h4x8(:,130),heltab2x32(:,:,668))
  Gcoeff(:)%j = (c(18)*M(1,:)%j) * den(41)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(701),h0tab(:,701),[18,13],[nMW,nMB],2,2,wf4(:,6),wf8(:,35))
  call Hloop_QA_S(ntryL,G0H32(1),wf4(:,6),G0H8(5),ngPtb,m3h4x8(:,131),heltab2x32(:,:,669))
  Gcoeff(:)%j = (c(1)*M(1,:)%j) * den(41)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(702),h0tab(:,702),[18,13],[0,nMT],2,2,wf4(:,6),wf8(:,35))
  call Hloop_QA_V(ntryL,G0H32(1),wf4(:,6),G0H8(6),m3h4x8(:,132),heltab2x32(:,:,670))
  Gcoeff(:)%j = (c(2)*M(1,:)%j) * den(41)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(703),h0tab(:,703),[18,13],[nMZ,nMT],2,2,wf4(:,6),wf8(:,35))
  call Hloop_QA_Z(ntryL,G0H32(1),wf4(:,6),G0H8(8),ngZu,m3h4x8(:,133),heltab2x32(:,:,671))
  Gcoeff(:)%j = (c(9)*M(1,:)%j) * den(41)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(704),h0tab(:,704),[18,13],[nMW,nMB],2,2,wf4(:,6),wf8(:,35))
  call Hloop_QA_W(ntryL,G0H32(1),wf4(:,6),G0H8(9),m3h4x8(:,134),heltab2x32(:,:,672))
  Gcoeff(:)%j = (-(c(24)*M(1,:)%j)) * den(39)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(705),h0tab(:,705),[22,9],[nMT,nMH],2,2,wf8(:,34),wf4(:,9))
  call Hloop_SA_Q(ntryL,G0H32(1),wf8(:,34),G0H4(28),ngH,m3h8x4(:,369),heltab2x32(:,:,673))
  call Hloop_A_Q(ntryL,G0H4(28),22,nMT,G1H4(118),n2h4(273))
  Gcoeff(:)%j = (c(24)*M(1,:)%j) * den(39)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(706),h0tab(:,706),[22,9],[nMT,nMZ],2,2,wf8(:,34),wf4(:,9))
  call Hloop_SA_Q(ntryL,G0H32(1),wf8(:,34),G0H4(79),ngX,m3h8x4(:,370),heltab2x32(:,:,674))
  call Hloop_A_Q(ntryL,G0H4(79),22,nMT,G1H4(10),n2h4(274))
  Gcoeff(:)%j = (c(18)*M(1,:)%j) * den(39)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(707),h0tab(:,707),[22,9],[nMB,nMW],2,2,wf8(:,34),wf4(:,9))
  call Hloop_SA_Q(ntryL,G0H32(1),wf8(:,34),G0H4(35),ngPtb,m3h8x4(:,371),heltab2x32(:,:,675))
  call Hloop_A_Q(ntryL,G0H4(35),22,nMB,G1H4(153),n2h4(275))
  Gcoeff(:)%j = (c(1)*M(1,:)%j) * den(39)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(708),h0tab(:,708),[22,9],[nMT,0],2,2,wf8(:,34),wf4(:,9))
  call Hloop_VA_Q(ntryL,G0H32(1),wf8(:,34),G0H4(80),m3h8x4(:,372),heltab2x32(:,:,676))
  call Hloop_A_Q(ntryL,G0H4(80),22,nMT,G1H4(186),n2h4(276))
  Gcoeff(:)%j = (c(2)*M(1,:)%j) * den(39)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(709),h0tab(:,709),[22,9],[nMT,nMZ],2,2,wf8(:,34),wf4(:,9))
  call Hloop_ZA_Q(ntryL,G0H32(1),wf8(:,34),G0H4(36),ngZu,m3h8x4(:,373),heltab2x32(:,:,677))
  call Hloop_A_Q(ntryL,G0H4(36),22,nMT,G1H4(120),n2h4(277))
  Gcoeff(:)%j = (c(9)*M(1,:)%j) * den(39)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(710),h0tab(:,710),[22,9],[nMB,nMW],2,2,wf8(:,34),wf4(:,9))
  call Hloop_WA_Q(ntryL,G0H32(1),wf8(:,34),G0H4(87),m3h8x4(:,374),heltab2x32(:,:,678))
  call Hloop_A_Q(ntryL,G0H4(87),22,nMB,G1H4(96),n2h4(278))
  Gcoeff(:)%j = (-(c(24)*M(1,:)%j)) * den(45)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(711),h0tab(:,711),[21,10],[nMT,nMH],2,2,wf8(:,38),wf4(:,4))
  call Hloop_SQ_A(ntryL,G0H32(1),wf8(:,38),G0H4(85),ngH,m3h8x4(:,375),heltab2x32(:,:,679))
  call Hloop_Q_A(ntryL,G0H4(85),21,nMT,G1H4(55),n2h4(279))
  Gcoeff(:)%j = (c(24)*M(1,:)%j) * den(45)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(712),h0tab(:,712),[21,10],[nMT,nMZ],2,2,wf8(:,38),wf4(:,4))
  call Hloop_SQ_A(ntryL,G0H32(1),wf8(:,38),G0H4(43),ngX,m3h8x4(:,376),heltab2x32(:,:,680))
  call Hloop_Q_A(ntryL,G0H4(43),21,nMT,G1H4(109),n2h4(280))
  Gcoeff(:)%j = (c(18)*M(1,:)%j) * den(45)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(713),h0tab(:,713),[21,10],[nMB,nMW],2,2,wf8(:,38),wf4(:,4))
  call Hloop_SQ_A(ntryL,G0H32(1),wf8(:,38),G0H4(41),ngPbt,m3h8x4(:,377),heltab2x32(:,:,681))
  call Hloop_Q_A(ntryL,G0H4(41),21,nMB,G1H4(2),n2h4(281))
  Gcoeff(:)%j = (c(1)*M(1,:)%j) * den(45)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(714),h0tab(:,714),[21,10],[nMT,0],2,2,wf8(:,38),wf4(:,4))
  call Hloop_VQ_A(ntryL,G0H32(1),wf8(:,38),G0H4(88),m3h8x4(:,378),heltab2x32(:,:,682))
  call Hloop_Q_A(ntryL,G0H4(88),21,nMT,G1H4(53),n2h4(282))
  Gcoeff(:)%j = (c(2)*M(1,:)%j) * den(45)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(715),h0tab(:,715),[21,10],[nMT,nMZ],2,2,wf8(:,38),wf4(:,4))
  call Hloop_ZQ_A(ntryL,G0H32(1),wf8(:,38),G0H4(86),ngZu,m3h8x4(:,379),heltab2x32(:,:,683))
  call Hloop_Q_A(ntryL,G0H4(86),21,nMT,G1H4(223),n2h4(283))
  Gcoeff(:)%j = (c(9)*M(1,:)%j) * den(45)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(716),h0tab(:,716),[21,10],[nMB,nMW],2,2,wf8(:,38),wf4(:,4))
  call Hloop_WQ_A(ntryL,G0H32(1),wf8(:,38),G0H4(44),m3h8x4(:,380),heltab2x32(:,:,684))
  call Hloop_Q_A(ntryL,G0H4(44),21,nMB,G1H4(183),n2h4(284))
  Gcoeff(:)%j = (-(c(24)*M(1,:)%j)) * den(43)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(717),h0tab(:,717),[17,14],[nMH,nMT],2,2,wf4(:,12),wf8(:,37))
  call Hloop_AQ_S(ntryL,G0H32(1),wf4(:,12),G0H8(10),ngH,m3h4x8(:,135),heltab2x32(:,:,685))
  Gcoeff(:)%j = (c(24)*M(1,:)%j) * den(43)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(718),h0tab(:,718),[17,14],[nMZ,nMT],2,2,wf4(:,12),wf8(:,37))
  call Hloop_AQ_S(ntryL,G0H32(1),wf4(:,12),G0H8(14),ngX,m3h4x8(:,136),heltab2x32(:,:,686))
  Gcoeff(:)%j = (c(18)*M(1,:)%j) * den(43)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(719),h0tab(:,719),[17,14],[nMW,nMB],2,2,wf4(:,12),wf8(:,37))
  call Hloop_AQ_S(ntryL,G0H32(1),wf4(:,12),G0H8(15),ngPbt,m3h4x8(:,137),heltab2x32(:,:,687))
  Gcoeff(:)%j = (c(1)*M(1,:)%j) * den(43)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(720),h0tab(:,720),[17,14],[0,nMT],2,2,wf4(:,12),wf8(:,37))
  call Hloop_AQ_V(ntryL,G0H32(1),wf4(:,12),G0H8(16),m3h4x8(:,138),heltab2x32(:,:,688))
  Gcoeff(:)%j = (c(2)*M(1,:)%j) * den(43)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(721),h0tab(:,721),[17,14],[nMZ,nMT],2,2,wf4(:,12),wf8(:,37))
  call Hloop_AQ_Z(ntryL,G0H32(1),wf4(:,12),G0H8(18),ngZu,m3h4x8(:,139),heltab2x32(:,:,689))
  Gcoeff(:)%j = (c(9)*M(1,:)%j) * den(43)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(722),h0tab(:,722),[17,14],[nMW,nMB],2,2,wf4(:,12),wf8(:,37))
  call Hloop_AQ_W(ntryL,G0H32(1),wf4(:,12),G0H8(19),m3h4x8(:,140),heltab2x32(:,:,690))
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G0H2(12),[G0H2(11),G0H2(10),G0H2(9),G0H2(4),G0H2(3),G0H2(2) &
    ,G0H2(1)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G0H2(14),[G0H2(13),G0H2(6),G0H2(5)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G0H2(16),[G0H2(15),G0H2(8),G0H2(7)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G0H2(28),[G0H2(27),G0H2(26),G0H2(25),G0H2(20),G0H2(19) &
    ,G0H2(18),G0H2(17)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G0H2(30),[G0H2(29),G0H2(22),G0H2(21)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G0H2(32),[G0H2(31),G0H2(24),G0H2(23)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(162),[G1H4(135),G1H4(29),G1H4(67),G0H4(6),G0H4(2)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(68),[G1H4(110),G1H4(171),G1H4(75),G0H4(7),G0H4(1)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(55),[G1H4(142)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(109),[G1H4(14)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(2),[G1H4(177)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(53),[G1H4(141)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(223),[G1H4(163)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(183),[G1H4(113)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(114),[G1H4(84)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(90),[G1H4(36)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(37),[G1H4(81)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(13),[G1H4(195)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(201),[G1H4(147)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(154),[G1H4(164)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(1),[G1H4(170)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(50),[G1H4(115)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(180),[G1H4(91)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(119),[G1H4(35)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(95),[G1H4(17)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(59),[G1H4(3)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(118),[G1H4(148)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(10),[G1H4(176)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(153),[G1H4(116)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(186),[G1H4(92)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(120),[G1H4(166)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(96),[G1H4(18)])
  call Hcheck_last_SV_V(ntryL,l_switch,G0H2(12),ex3(:),G0tensor(1),m3h2x1(:,709),heltab2x2(:,:,709))
  call Hcheck_last_TV_S(ntryL,l_switch,G0H2(14),27,ex3(:),4,G1tensor(126),m3h2x1(:,710),heltab2x2(:,:,710))
  call Hcheck_last_UV_W(ntryL,l_switch,G0H2(16),27,ex3(:),4,G1tensor(15),m3h2x1(:,711),heltab2x2(:,:,711))
  call Hcheck_last_SV_V(ntryL,l_switch,G0H2(28),ex4(:),G0tensor(31),m3h2x1(:,712),heltab2x2(:,:,712))
  call Hcheck_last_TV_S(ntryL,l_switch,G0H2(30),23,ex4(:),8,G1tensor(152),m3h2x1(:,713),heltab2x2(:,:,713))
  call Hcheck_last_UV_W(ntryL,l_switch,G0H2(32),23,ex4(:),8,G1tensor(168),m3h2x1(:,714),heltab2x2(:,:,714))
  call Hcheck_last_SVV_S(ntryL,l_switch,G1H4(162),ex4(:),ex3(:),G1tensor(11),m4h2x2x1(:,5),heltab3x4(:,:,5))
  call Hcheck_last_VWW_V(ntryL,l_switch,G1H4(68),ex4(:),ex3(:),G1tensor(83),m4h2x2x1(:,6),heltab3x4(:,:,6))
  call Hcheck_last_QA_S(ntryL,l_switch,G1H4(55),wf4(:,4),G1tensor(17),ngH,m3h4x1(:,109),heltab2x4(:,:,449))
  call Hcheck_last_QA_S(ntryL,l_switch,G1H4(109),wf4(:,4),G1tensor(29),ngX,m3h4x1(:,110),heltab2x4(:,:,450))
  call Hcheck_last_QA_S(ntryL,l_switch,G1H4(2),wf4(:,4),G1tensor(112),ngPtb,m3h4x1(:,111),heltab2x4(:,:,451))
  call Hcheck_last_QA_V(ntryL,l_switch,G1H4(53),wf4(:,4),G1tensor(45),m3h4x1(:,112),heltab2x4(:,:,452))
  call Hcheck_last_QA_Z(ntryL,l_switch,G1H4(223),wf4(:,4),G1tensor(161),ngZu,m3h4x1(:,113),heltab2x4(:,:,453))
  call Hcheck_last_QA_W(ntryL,l_switch,G1H4(183),wf4(:,4),G1tensor(70),m3h4x1(:,114),heltab2x4(:,:,454))
  call Hcheck_last_AQ_S(ntryL,l_switch,G1H4(114),wf4(:,3),G1tensor(154),ngH,m3h4x1(:,115),heltab2x4(:,:,455))
  call Hcheck_last_AQ_S(ntryL,l_switch,G1H4(90),wf4(:,3),G1tensor(88),ngX,m3h4x1(:,116),heltab2x4(:,:,456))
  call Hcheck_last_AQ_S(ntryL,l_switch,G1H4(37),wf4(:,3),G1tensor(148),ngPbt,m3h4x1(:,117),heltab2x4(:,:,457))
  call Hcheck_last_AQ_V(ntryL,l_switch,G1H4(13),wf4(:,3),G1tensor(107),m3h4x1(:,118),heltab2x4(:,:,458))
  call Hcheck_last_AQ_Z(ntryL,l_switch,G1H4(201),wf4(:,3),G1tensor(123),ngZu,m3h4x1(:,119),heltab2x4(:,:,459))
  call Hcheck_last_AQ_W(ntryL,l_switch,G1H4(154),wf4(:,3),G1tensor(135),m3h4x1(:,120),heltab2x4(:,:,460))
  call Hloop_SQ_A(ntryL,G0H8(23),wf8(:,26),G0H1(1),ngH,m3h8x1(:,25),heltab2x8(:,:,261))
  call Hcheck_last_Q_A(ntryL,l_switch,G0H1(1),31,nMT,G1tensor(179),n2h1(753))
  call Hloop_SQ_A(ntryL,G0H8(24),wf8(:,26),G0H1(1),ngX,m3h8x1(:,26),heltab2x8(:,:,262))
  call Hcheck_last_Q_A(ntryL,l_switch,G0H1(1),31,nMT,G1tensor(165),n2h1(754))
  call Hloop_SQ_A(ntryL,G0H8(25),wf8(:,26),G0H1(1),ngPbt,m3h8x1(:,27),heltab2x8(:,:,263))
  call Hcheck_last_Q_A(ntryL,l_switch,G0H1(1),31,nMB,G1tensor(181),n2h1(755))
  call Hloop_VQ_A(ntryL,G0H8(26),wf8(:,26),G0H1(1),m3h8x1(:,28),heltab2x8(:,:,264))
  call Hcheck_last_Q_A(ntryL,l_switch,G0H1(1),31,nMT,G1tensor(186),n2h1(756))
  call Hloop_ZQ_A(ntryL,G0H8(28),wf8(:,26),G0H1(1),ngZu,m3h8x1(:,29),heltab2x8(:,:,265))
  call Hcheck_last_Q_A(ntryL,l_switch,G0H1(1),31,nMT,G1tensor(191),n2h1(757))
  call Hloop_WQ_A(ntryL,G0H8(29),wf8(:,26),G0H1(1),m3h8x1(:,30),heltab2x8(:,:,266))
  call Hcheck_last_Q_A(ntryL,l_switch,G0H1(1),31,nMB,G1tensor(196),n2h1(758))
  call Hcheck_last_QA_S(ntryL,l_switch,G1H4(1),wf4(:,10),G1tensor(201),ngH,m3h4x1(:,121),heltab2x4(:,:,461))
  call Hcheck_last_QA_S(ntryL,l_switch,G1H4(50),wf4(:,10),G1tensor(206),ngX,m3h4x1(:,122),heltab2x4(:,:,462))
  call Hcheck_last_QA_S(ntryL,l_switch,G1H4(180),wf4(:,10),G1tensor(211),ngPtb,m3h4x1(:,123),heltab2x4(:,:,463))
  call Hcheck_last_QA_V(ntryL,l_switch,G1H4(119),wf4(:,10),G1tensor(216),m3h4x1(:,124),heltab2x4(:,:,464))
  call Hcheck_last_QA_Z(ntryL,l_switch,G1H4(95),wf4(:,10),G1tensor(221),ngZu,m3h4x1(:,125),heltab2x4(:,:,465))
  call Hcheck_last_QA_W(ntryL,l_switch,G1H4(59),wf4(:,10),G1tensor(226),m3h4x1(:,126),heltab2x4(:,:,466))
  call Hcheck_last_AQ_S(ntryL,l_switch,G1H4(118),wf4(:,9),G1tensor(231),ngH,m3h4x1(:,127),heltab2x4(:,:,467))
  call Hcheck_last_AQ_S(ntryL,l_switch,G1H4(10),wf4(:,9),G1tensor(236),ngX,m3h4x1(:,128),heltab2x4(:,:,468))
  call Hcheck_last_AQ_S(ntryL,l_switch,G1H4(153),wf4(:,9),G1tensor(241),ngPbt,m3h4x1(:,129),heltab2x4(:,:,469))
  call Hcheck_last_AQ_V(ntryL,l_switch,G1H4(186),wf4(:,9),G1tensor(246),m3h4x1(:,130),heltab2x4(:,:,470))
  call Hcheck_last_AQ_Z(ntryL,l_switch,G1H4(120),wf4(:,9),G1tensor(251),ngZu,m3h4x1(:,131),heltab2x4(:,:,471))
  call Hcheck_last_AQ_W(ntryL,l_switch,G1H4(96),wf4(:,9),G1tensor(256),m3h4x1(:,132),heltab2x4(:,:,472))
  call Hloop_SA_Q(ntryL,G0H8(30),wf8(:,31),G0H1(1),ngH,m3h8x1(:,31),heltab2x8(:,:,267))
  call Hcheck_last_A_Q(ntryL,l_switch,G0H1(1),31,nMT,G1tensor(261),n2h1(759))
  call Hloop_SA_Q(ntryL,G0H8(1),wf8(:,31),G0H1(1),ngX,m3h8x1(:,32),heltab2x8(:,:,268))
  call Hcheck_last_A_Q(ntryL,l_switch,G0H1(1),31,nMT,G1tensor(266),n2h1(760))
  call Hloop_SA_Q(ntryL,G0H8(2),wf8(:,31),G0H1(1),ngPtb,m3h8x1(:,33),heltab2x8(:,:,269))
  call Hcheck_last_A_Q(ntryL,l_switch,G0H1(1),31,nMB,G1tensor(271),n2h1(761))
  call Hloop_VA_Q(ntryL,G0H8(3),wf8(:,31),G0H1(1),m3h8x1(:,34),heltab2x8(:,:,270))
  call Hcheck_last_A_Q(ntryL,l_switch,G0H1(1),31,nMT,G1tensor(276),n2h1(762))
  call Hloop_ZA_Q(ntryL,G0H8(11),wf8(:,31),G0H1(1),ngZu,m3h8x1(:,35),heltab2x8(:,:,271))
  call Hcheck_last_A_Q(ntryL,l_switch,G0H1(1),31,nMT,G1tensor(281),n2h1(763))
  call Hloop_WA_Q(ntryL,G0H8(12),wf8(:,31),G0H1(1),m3h8x1(:,36),heltab2x8(:,:,272))
  call Hcheck_last_A_Q(ntryL,l_switch,G0H1(1),31,nMB,G1tensor(286),n2h1(764))
  call Hloop_SQ_A(ntryL,G0H8(13),wf8(:,35),G0H1(1),ngH,m3h8x1(:,37),heltab2x8(:,:,273))
  call Hcheck_last_Q_A(ntryL,l_switch,G0H1(1),31,nMT,G1tensor(291),n2h1(765))
  call Hloop_SQ_A(ntryL,G0H8(4),wf8(:,35),G0H1(1),ngX,m3h8x1(:,38),heltab2x8(:,:,274))
  call Hcheck_last_Q_A(ntryL,l_switch,G0H1(1),31,nMT,G1tensor(296),n2h1(766))
  call Hloop_SQ_A(ntryL,G0H8(5),wf8(:,35),G0H1(1),ngPbt,m3h8x1(:,39),heltab2x8(:,:,275))
  call Hcheck_last_Q_A(ntryL,l_switch,G0H1(1),31,nMB,G1tensor(301),n2h1(767))
  call Hloop_VQ_A(ntryL,G0H8(6),wf8(:,35),G0H1(1),m3h8x1(:,40),heltab2x8(:,:,276))
  call Hcheck_last_Q_A(ntryL,l_switch,G0H1(1),31,nMT,G1tensor(306),n2h1(768))
  call Hloop_ZQ_A(ntryL,G0H8(8),wf8(:,35),G0H1(1),ngZu,m3h8x1(:,41),heltab2x8(:,:,277))
  call Hcheck_last_Q_A(ntryL,l_switch,G0H1(1),31,nMT,G1tensor(311),n2h1(769))
  call Hloop_WQ_A(ntryL,G0H8(9),wf8(:,35),G0H1(1),m3h8x1(:,42),heltab2x8(:,:,278))
  call Hcheck_last_Q_A(ntryL,l_switch,G0H1(1),31,nMB,G1tensor(316),n2h1(770))
  call Hloop_SA_Q(ntryL,G0H8(10),wf8(:,37),G0H1(1),ngH,m3h8x1(:,43),heltab2x8(:,:,279))
  call Hcheck_last_A_Q(ntryL,l_switch,G0H1(1),31,nMT,G1tensor(321),n2h1(771))
  call Hloop_SA_Q(ntryL,G0H8(14),wf8(:,37),G0H1(1),ngX,m3h8x1(:,44),heltab2x8(:,:,280))
  call Hcheck_last_A_Q(ntryL,l_switch,G0H1(1),31,nMT,G1tensor(326),n2h1(772))
  call Hloop_SA_Q(ntryL,G0H8(15),wf8(:,37),G0H1(1),ngPtb,m3h8x1(:,45),heltab2x8(:,:,281))
  call Hcheck_last_A_Q(ntryL,l_switch,G0H1(1),31,nMB,G1tensor(331),n2h1(773))
  call Hloop_VA_Q(ntryL,G0H8(16),wf8(:,37),G0H1(1),m3h8x1(:,46),heltab2x8(:,:,282))
  call Hcheck_last_A_Q(ntryL,l_switch,G0H1(1),31,nMT,G1tensor(336),n2h1(774))
  call Hloop_ZA_Q(ntryL,G0H8(18),wf8(:,37),G0H1(1),ngZu,m3h8x1(:,47),heltab2x8(:,:,283))
  call Hcheck_last_A_Q(ntryL,l_switch,G0H1(1),31,nMT,G1tensor(341),n2h1(775))
  call Hloop_WA_Q(ntryL,G0H8(19),wf8(:,37),G0H1(1),m3h8x1(:,48),heltab2x8(:,:,284))
  call Hcheck_last_A_Q(ntryL,l_switch,G0H1(1),31,nMB,G1tensor(346),n2h1(776))
  call ol_merge_tensors(G0tensor(839),[G0tensor(833),G0tensor(827),G0tensor(822),G0tensor(816),G0tensor(810),G0tensor(794) &
    ,G0tensor(782),G0tensor(776),G0tensor(748),G0tensor(726),G0tensor(721),G0tensor(715),G0tensor(710),G0tensor(676),G0tensor(573) &
    ,G0tensor(561),G0tensor(549),G0tensor(328),G0tensor(284),G0tensor(329),G0tensor(444),G0tensor(244),G0tensor(123),G0tensor(326) &
    ,G0tensor(266),G0tensor(236),G0tensor(96),G0tensor(36),G0tensor(6)])
  call ol_merge_tensors(G0tensor(377),[G0tensor(450),G0tensor(42),G0tensor(351),G0tensor(11)])
  call ol_merge_tensors(G1tensor(154),[G0tensor(233),G0tensor(62),G0tensor(16)])
  call ol_merge_tensors(G0tensor(830),[G0tensor(813),G0tensor(779),G0tensor(756),G0tensor(718),G0tensor(685),G0tensor(581) &
    ,G0tensor(558),G0tensor(514),G0tensor(353),G0tensor(364),G0tensor(273),G0tensor(283),G0tensor(73),G0tensor(265),G0tensor(180) &
    ,G0tensor(90),G0tensor(189),G0tensor(210),G0tensor(28),G0tensor(72),G0tensor(103),G0tensor(371),G0tensor(251),G0tensor(141) &
    ,G0tensor(21)])
  call ol_merge_tensors(G0tensor(842),[G0tensor(837),G0tensor(831),G0tensor(825),G0tensor(820),G0tensor(814),G0tensor(796) &
    ,G0tensor(784),G0tensor(778),G0tensor(773),G0tensor(761),G0tensor(755),G0tensor(750),G0tensor(728),G0tensor(723),G0tensor(717) &
    ,G0tensor(712),G0tensor(707),G0tensor(690),G0tensor(684),G0tensor(679),G0tensor(669),G0tensor(598),G0tensor(586),G0tensor(580) &
    ,G0tensor(575),G0tensor(563),G0tensor(557),G0tensor(499),G0tensor(433),G0tensor(494),G0tensor(403),G0tensor(384),G0tensor(418) &
    ,G0tensor(334),G0tensor(448),G0tensor(454),G0tensor(314),G0tensor(374),G0tensor(264),G0tensor(253),G0tensor(522),G0tensor(154) &
    ,G0tensor(149),G0tensor(382),G0tensor(372),G0tensor(337),G0tensor(322),G0tensor(54),G0tensor(45),G0tensor(55),G0tensor(228) &
    ,G0tensor(460),G0tensor(455),G0tensor(445),G0tensor(170),G0tensor(470),G0tensor(109),G0tensor(355),G0tensor(230),G0tensor(340) &
    ,G0tensor(80),G0tensor(395),G0tensor(9),G0tensor(250),G0tensor(482),G0tensor(120),G0tensor(205),G0tensor(553),G0tensor(237) &
    ,G0tensor(137),G0tensor(102),G0tensor(157),G0tensor(77),G0tensor(142),G0tensor(456),G0tensor(396),G0tensor(366),G0tensor(341) &
    ,G0tensor(286),G0tensor(256),G0tensor(226),G0tensor(166),G0tensor(136),G0tensor(111),G0tensor(56),G0tensor(26)])
  call ol_merge_tensors(G0tensor(209),[G0tensor(465),G0tensor(97),G0tensor(381),G0tensor(41)])
  call ol_merge_tensors(G1tensor(123),[G1tensor(88),G0tensor(243),G0tensor(537),G0tensor(46)])
  call ol_merge_tensors(G0tensor(836),[G0tensor(819),G0tensor(785),G0tensor(762),G0tensor(729),G0tensor(691),G0tensor(587) &
    ,G0tensor(564),G0tensor(429),G0tensor(393),G0tensor(369),G0tensor(248),G0tensor(144),G0tensor(184),G0tensor(515),G0tensor(198) &
    ,G0tensor(397),G0tensor(100),G0tensor(300),G0tensor(215),G0tensor(132),G0tensor(117),G0tensor(401),G0tensor(281),G0tensor(171) &
    ,G0tensor(51)])
  call ol_merge_tensors(G0tensor(788),[G0tensor(743),G0tensor(737),G0tensor(732),G0tensor(693),G0tensor(648),G0tensor(636) &
    ,G0tensor(567),G0tensor(323),G0tensor(299),G0tensor(63),G0tensor(197),G0tensor(296),G0tensor(66)])
  call ol_merge_tensors(G0tensor(373),[G0tensor(363),G0tensor(270),G0tensor(167),G0tensor(27),G0tensor(526),G0tensor(411) &
    ,G0tensor(71)])
  call ol_merge_tensors(G1tensor(135),[G1tensor(148),G0tensor(249),G0tensor(193),G0tensor(33),G0tensor(536),G0tensor(76)])
  call ol_merge_tensors(G0tensor(807),[G0tensor(801),G0tensor(791),G0tensor(768),G0tensor(740),G0tensor(702),G0tensor(664) &
    ,G0tensor(658),G0tensor(651),G0tensor(645),G0tensor(639),G0tensor(634),G0tensor(628),G0tensor(622),G0tensor(616),G0tensor(610) &
    ,G0tensor(604),G0tensor(593),G0tensor(570),G0tensor(463),G0tensor(484),G0tensor(438),G0tensor(555),G0tensor(507),G0tensor(293) &
    ,G0tensor(203),G0tensor(183),G0tensor(163),G0tensor(368),G0tensor(362),G0tensor(34),G0tensor(13),G0tensor(3),G0tensor(195) &
    ,G0tensor(442),G0tensor(225),G0tensor(19),G0tensor(8),G0tensor(422),G0tensor(235),G0tensor(79),G0tensor(305),G0tensor(43) &
    ,G0tensor(177),G0tensor(32),G0tensor(541),G0tensor(511),G0tensor(481),G0tensor(431),G0tensor(311),G0tensor(201) &
    ,G0tensor(81)])
  call ol_merge_tensors(G0tensor(808),[G0tensor(802),G0tensor(790),G0tensor(767),G0tensor(745),G0tensor(739),G0tensor(734) &
    ,G0tensor(701),G0tensor(696),G0tensor(674),G0tensor(663),G0tensor(657),G0tensor(652),G0tensor(646),G0tensor(640),G0tensor(633) &
    ,G0tensor(627),G0tensor(621),G0tensor(615),G0tensor(609),G0tensor(603),G0tensor(592),G0tensor(569),G0tensor(479),G0tensor(449) &
    ,G0tensor(504),G0tensor(308),G0tensor(458),G0tensor(545),G0tensor(223),G0tensor(477),G0tensor(437),G0tensor(402),G0tensor(104) &
    ,G0tensor(174),G0tensor(287),G0tensor(267),G0tensor(252),G0tensor(462),G0tensor(165),G0tensor(342),G0tensor(275),G0tensor(255) &
    ,G0tensor(129),G0tensor(412),G0tensor(99),G0tensor(385),G0tensor(58),G0tensor(542),G0tensor(182),G0tensor(207),G0tensor(552) &
    ,G0tensor(546),G0tensor(516),G0tensor(486),G0tensor(426),G0tensor(316),G0tensor(196),G0tensor(86)])
  call ol_merge_tensors(G0tensor(407),[G0tensor(25),G0tensor(222),G0tensor(441),G0tensor(101)])
  call ol_merge_tensors(G1tensor(107),[G0tensor(263),G0tensor(242),G0tensor(106)])
  call ol_merge_tensors(G0tensor(94),[G0tensor(335),G0tensor(60),G0tensor(241),G0tensor(121)])
  call ol_merge_tensors(G0tensor(394),[G0tensor(509),G0tensor(464),G0tensor(17),G0tensor(126)])
  call ol_merge_tensors(G0tensor(404),[G0tensor(354),G0tensor(44),G0tensor(29),G0tensor(451),G0tensor(391),G0tensor(361) &
    ,G0tensor(221),G0tensor(161),G0tensor(131)])
  call ol_merge_tensors(G0tensor(513),[G0tensor(350),G0tensor(295),G0tensor(271),G0tensor(151)])
  call ol_merge_tensors(G0tensor(409),[G0tensor(478),G0tensor(289),G0tensor(290),G0tensor(156)])
  call ol_merge_tensors(G0tensor(642),[G0tensor(347),G0tensor(118),G0tensor(199),G0tensor(496),G0tensor(466),G0tensor(301) &
    ,G0tensor(181)])
  call ol_merge_tensors(G0tensor(613),[G0tensor(607),G0tensor(601),G0tensor(439),G0tensor(388),G0tensor(339),G0tensor(50) &
    ,G0tensor(186)])
  call ol_merge_tensors(G0tensor(473),[G0tensor(348),G0tensor(312),G0tensor(380),G0tensor(421),G0tensor(191)])
  call ol_merge_tensors(G0tensor(367),[G0tensor(138),G0tensor(78),G0tensor(331),G0tensor(211)])
  call ol_merge_tensors(G0tensor(493),[G0tensor(399),G0tensor(309),G0tensor(390),G0tensor(216)])
  call ol_merge_tensors(G1tensor(201),[G0tensor(333),G0tensor(415),G0tensor(246)])
  call ol_merge_tensors(G1tensor(221),[G1tensor(206),G0tensor(498),G0tensor(145),G0tensor(276)])
  call ol_merge_tensors(G1tensor(226),[G1tensor(211),G0tensor(798),G0tensor(378),G0tensor(128),G0tensor(476),G0tensor(306)])
  call ol_merge_tensors(G1tensor(216),[G0tensor(424),G0tensor(168),G0tensor(336)])
  call ol_merge_tensors(G0tensor(577),[G0tensor(539),G0tensor(517),G0tensor(440),G0tensor(356)])
  call ol_merge_tensors(G0tensor(583),[G0tensor(560),G0tensor(527),G0tensor(20),G0tensor(386)])
  call ol_merge_tensors(G0tensor(661),[G0tensor(655),G0tensor(631),G0tensor(625),G0tensor(619),G0tensor(589),G0tensor(566) &
    ,G0tensor(540),G0tensor(520),G0tensor(416)])
  call ol_merge_tensors(G0tensor(595),[G0tensor(572),G0tensor(254),G0tensor(135),G0tensor(446)])
  call ol_merge_tensors(G1tensor(15),[G1tensor(126),G0tensor(1),G0tensor(805),G0tensor(618),G0tensor(600),G0tensor(303) &
    ,G0tensor(523),G0tensor(533),G0tensor(15),G0tensor(65),G0tensor(531),G0tensor(471)])
  call ol_merge_tensors(G1tensor(168),[G1tensor(152),G0tensor(31),G0tensor(799),G0tensor(624),G0tensor(606),G0tensor(208) &
    ,G0tensor(467),G0tensor(528),G0tensor(257),G0tensor(352),G0tensor(22),G0tensor(501)])
  call ol_merge_tensors(G1tensor(70),[G1tensor(112),G0tensor(804),G0tensor(637),G0tensor(612),G0tensor(452),G0tensor(506)])
  call ol_merge_tensors(G1tensor(256),[G1tensor(241),G0tensor(649),G0tensor(630),G0tensor(497),G0tensor(14),G0tensor(37)])
  call ol_merge_tensors(G0tensor(775),[G0tensor(579),G0tensor(147),G0tensor(57)])
  call ol_merge_tensors(G0tensor(720),[G0tensor(519),G0tensor(139),G0tensor(425),G0tensor(410),G0tensor(538),G0tensor(107) &
    ,G0tensor(87),G0tensor(52)])
  call ol_merge_tensors(G0tensor(722),[G0tensor(668),G0tensor(125),G0tensor(510),G0tensor(495),G0tensor(435),G0tensor(360) &
    ,G0tensor(240),G0tensor(330),G0tensor(49),G0tensor(30),G0tensor(140),G0tensor(2),G0tensor(122),G0tensor(82),G0tensor(113)])
  call ol_merge_tensors(G0tensor(781),[G0tensor(585),G0tensor(127),G0tensor(92)])
  call ol_merge_tensors(G0tensor(787),[G0tensor(626),G0tensor(591),G0tensor(5),G0tensor(212),G0tensor(162)])
  call ol_merge_tensors(G0tensor(742),[G0tensor(632),G0tensor(614),G0tensor(483),G0tensor(119),G0tensor(192),G0tensor(23)])
  call ol_merge_tensors(G0tensor(744),[G0tensor(673),G0tensor(662),G0tensor(24),G0tensor(185),G0tensor(535),G0tensor(229) &
    ,G0tensor(169),G0tensor(68),G0tensor(53),G0tensor(187)])
  call ol_merge_tensors(G0tensor(793),[G0tensor(597),G0tensor(7),G0tensor(547)])
  call ol_merge_tensors(G0tensor(711),[G0tensor(678),G0tensor(115),G0tensor(10),G0tensor(178),G0tensor(320),G0tensor(39) &
    ,G0tensor(285),G0tensor(12)])
  call ol_merge_tensors(G1tensor(291),[G1tensor(179),G0tensor(716),G0tensor(683),G0tensor(40),G0tensor(472)])
  call ol_merge_tensors(G1tensor(311),[G1tensor(296),G1tensor(191),G1tensor(165),G0tensor(727),G0tensor(689),G0tensor(260) &
    ,G0tensor(492)])
  call ol_merge_tensors(G0tensor(733),[G0tensor(695),G0tensor(239),G0tensor(310),G0tensor(502)])
  call ol_merge_tensors(G1tensor(316),[G1tensor(301),G1tensor(196),G1tensor(181),G0tensor(738),G0tensor(700),G0tensor(432) &
    ,G0tensor(75),G0tensor(179),G0tensor(220)])
  call ol_merge_tensors(G1tensor(306),[G1tensor(186),G0tensor(749),G0tensor(706),G0tensor(400),G0tensor(70)])
  call ol_merge_tensors(G0tensor(714),[G0tensor(408),G0tensor(345),G0tensor(88)])
  call ol_merge_tensors(G0tensor(725),[G0tensor(419),G0tensor(108),G0tensor(98)])
  call ol_merge_tensors(G0tensor(736),[G0tensor(608),G0tensor(453),G0tensor(327),G0tensor(370),G0tensor(365)])
  call ol_merge_tensors(G0tensor(747),[G0tensor(503),G0tensor(475),G0tensor(375)])
  call ol_merge_tensors(G1tensor(321),[G1tensor(261),G0tensor(777),G0tensor(754),G0tensor(188),G0tensor(485)])
  call ol_merge_tensors(G1tensor(341),[G1tensor(326),G1tensor(281),G1tensor(266),G0tensor(783),G0tensor(760),G0tensor(200) &
    ,G0tensor(500)])
  call ol_merge_tensors(G1tensor(346),[G1tensor(331),G1tensor(286),G1tensor(271),G0tensor(789),G0tensor(766),G0tensor(656) &
    ,G0tensor(548),G0tensor(543),G0tensor(18),G0tensor(525)])
  call ol_merge_tensors(G1tensor(336),[G1tensor(276),G0tensor(795),G0tensor(772),G0tensor(297),G0tensor(105)])
  call ol_merge_tensors(G0tensor(698),[G0tensor(602),G0tensor(294),G0tensor(93),G0tensor(245),G0tensor(95)])
  call ol_merge_tensors(G0tensor(764),[G0tensor(620),G0tensor(568),G0tensor(148),G0tensor(277),G0tensor(4)])
  call ol_merge_tensors(G0tensor(666),[G0tensor(389),G0tensor(468),G0tensor(343),G0tensor(319),G0tensor(274),G0tensor(258) &
    ,G0tensor(234),G0tensor(214),G0tensor(159),G0tensor(143),G0tensor(124),G0tensor(83),G0tensor(64),G0tensor(302)])
  call ol_merge_tensors(G0tensor(671),[G0tensor(379),G0tensor(313),G0tensor(550),G0tensor(508),G0tensor(357),G0tensor(194)])
  call ol_merge_tensors(G0tensor(681),[G0tensor(434),G0tensor(74)])
  call ol_merge_tensors(G0tensor(687),[G0tensor(279),G0tensor(332)])
  call ol_merge_tensors(G0tensor(704),[G0tensor(324),G0tensor(224)])
  call ol_merge_tensors(G0tensor(752),[G0tensor(556),G0tensor(358)])
  call ol_merge_tensors(G0tensor(758),[G0tensor(562),G0tensor(204)])
  call ol_merge_tensors(G0tensor(770),[G0tensor(574),G0tensor(298)])
  call ol_merge_tensors(G1tensor(83),[G1tensor(11),G0tensor(654),G0tensor(643),G0tensor(487),G0tensor(447),G0tensor(158)])
  call ol_merge_tensors(G0tensor(660),[G0tensor(650),G0tensor(218),G0tensor(278),G0tensor(427)])
  call ol_merge_tensors(G0tensor(771),[G0tensor(759),G0tensor(753),G0tensor(709),G0tensor(705),G0tensor(688),G0tensor(682) &
    ,G0tensor(677),G0tensor(667),G0tensor(596),G0tensor(584),G0tensor(578),G0tensor(489),G0tensor(423),G0tensor(534) &
    ,G0tensor(488)])
  call ol_merge_tensors(G0tensor(765),[G0tensor(731),G0tensor(699),G0tensor(694),G0tensor(672),G0tensor(590),G0tensor(469) &
    ,G0tensor(524)])
  call ol_merge_tensors(G0tensor(806),[G0tensor(800),G0tensor(644),G0tensor(638)])
  call ol_merge_tensors(G1tensor(231),[G0tensor(811)])
  call ol_merge_tensors(G1tensor(251),[G1tensor(236),G0tensor(817)])
  call ol_merge_tensors(G1tensor(246),[G0tensor(823)])
  call ol_merge_tensors(G1tensor(17),[G0tensor(828)])
  call ol_merge_tensors(G1tensor(161),[G1tensor(29),G0tensor(834)])
  call ol_merge_tensors(G1tensor(45),[G0tensor(840)])
call TI_bubble_red(G1tensor(154),26,mass2set(:,1),G0tensor(61),M2L1R1,G0tensor(91),G0tensor(116))
call TI_bubble_red(G1tensor(123),26,mass2set(:,2),G0tensor(146),M2L1R1,G0tensor(176),G0tensor(206))
call TI_bubble_red(G1tensor(135),26,mass2set(:,3),G0tensor(231),M2L1R1,G0tensor(261),G0tensor(291))
call TI_bubble_red(G1tensor(107),26,mass2set(:,4),G0tensor(321),M2L1R1,G0tensor(346))
call TI_bubble_red(G1tensor(201),25,mass2set(:,1),G0tensor(376),M2L1R1,G0tensor(406),G0tensor(436))
call TI_bubble_red(G1tensor(221),25,mass2set(:,2),G0tensor(461),M2L1R1,G0tensor(491),G0tensor(521))
call TI_bubble_red(G1tensor(226),25,mass2set(:,3),G0tensor(551),M2L1R1,G0tensor(47),G0tensor(67))
call TI_bubble_red(G1tensor(216),25,mass2set(:,4),G0tensor(152),M2L1R1,G0tensor(133))
call TI_bubble_red(G1tensor(15),27,mass2set(:,5),G0tensor(112),M2L1R1,G0tensor(202))
call TI_bubble_red(G1tensor(168),23,mass2set(:,5),G0tensor(172),M2L1R1,G0tensor(217))
call TI_bubble_red(G1tensor(70),21,mass2set(:,3),G0tensor(227),M2L1R1,G0tensor(232),G0tensor(247))
call TI_bubble_red(G1tensor(256),22,mass2set(:,3),G0tensor(280),M2L1R1,G0tensor(110),G0tensor(38))
call TI_bubble_red(G1tensor(291),18,mass2set(:,6),G0tensor(48),M2L1R1,G0tensor(130),G0tensor(59))
call TI_bubble_red(G1tensor(311),18,mass2set(:,7),G0tensor(315),M2L1R1,G0tensor(69),G0tensor(325))
call TI_bubble_red(G1tensor(316),18,mass2set(:,8),G0tensor(405),M2L1R1,G0tensor(89),G0tensor(420))
call TI_bubble_red(G1tensor(306),18,mass2set(:,9),G0tensor(387),M2L1R1,G0tensor(150))
call TI_bubble_red(G1tensor(321),17,mass2set(:,6),G0tensor(155),M2L1R1,G0tensor(160),G0tensor(430))
call TI_bubble_red(G1tensor(341),17,mass2set(:,7),G0tensor(480),M2L1R1,G0tensor(490),G0tensor(190))
call TI_bubble_red(G1tensor(346),17,mass2set(:,8),G0tensor(505),M2L1R1,G0tensor(238),G0tensor(530))
call TI_bubble_red(G1tensor(336),17,mass2set(:,9),G0tensor(282),M2L1R1,G0tensor(35))
call TI_bubble_red(G1tensor(83),19,mass2set(:,5),G0tensor(317),M2L1R1,G0tensor(85))
call TI_bubble_red(G1tensor(231),22,mass2set(:,1),G0tensor(175),M2L1R1,G0tensor(262),G0tensor(554))
call TI_bubble_red(G1tensor(251),22,mass2set(:,2),G0tensor(272),M2L1R1,G0tensor(292),G0tensor(307))
call TI_bubble_red(G1tensor(246),22,mass2set(:,4),G0tensor(164),M2L1R1,G0tensor(518))
call TI_bubble_red(G1tensor(17),21,mass2set(:,1),G0tensor(84),M2L1R1,G0tensor(114),G0tensor(134))
call TI_bubble_red(G1tensor(161),21,mass2set(:,2),G0tensor(219),M2L1R1,G0tensor(392),G0tensor(153))
call TI_bubble_red(G1tensor(45),21,mass2set(:,4),G0tensor(417),M2L1R1,G0tensor(173))
  call ol_merge_tensors(G0tensor(114),[G0tensor(262),G0tensor(430),G0tensor(59),G0tensor(406),G0tensor(830),G0tensor(91)])
  call ol_merge_tensors(G0tensor(173),[G0tensor(153),G0tensor(134),G0tensor(518),G0tensor(307),G0tensor(554),G0tensor(35) &
    ,G0tensor(490),G0tensor(160),G0tensor(150),G0tensor(69),G0tensor(130),G0tensor(133),G0tensor(521),G0tensor(436),G0tensor(346) &
    ,G0tensor(206),G0tensor(842),G0tensor(116)])
  call ol_merge_tensors(G0tensor(392),[G0tensor(292),G0tensor(190),G0tensor(325),G0tensor(491),G0tensor(836),G0tensor(176)])
  call ol_merge_tensors(G0tensor(85),[G0tensor(530),G0tensor(420),G0tensor(110),G0tensor(232),G0tensor(217),G0tensor(202) &
    ,G0tensor(47),G0tensor(807),G0tensor(261)])
  call ol_merge_tensors(G0tensor(238),[G0tensor(89),G0tensor(38),G0tensor(247),G0tensor(67),G0tensor(808),G0tensor(291)])
  call ol_merge_tensors(T0sum(264),[G0tensor(839)])
  call ol_merge_tensors(T0sum(265),[G0tensor(377)])
  call ol_merge_tensors(T0sum(266),[G0tensor(61)])
  call ol_merge_tensors(T0sum(267),[G0tensor(114)])
  call ol_merge_tensors(T0sum(268),[G0tensor(173)])
  call ol_merge_tensors(T0sum(269),[G0tensor(209)])
  call ol_merge_tensors(T0sum(270),[G0tensor(146)])
  call ol_merge_tensors(T0sum(271),[G0tensor(392)])
  call ol_merge_tensors(T0sum(272),[G0tensor(788)])
  call ol_merge_tensors(T0sum(273),[G0tensor(373)])
  call ol_merge_tensors(T0sum(274),[G0tensor(231)])
  call ol_merge_tensors(T0sum(275),[G0tensor(85)])
  call ol_merge_tensors(T0sum(276),[G0tensor(238)])
  call ol_merge_tensors(T0sum(277),[G0tensor(407)])
  call ol_merge_tensors(T0sum(278),[G0tensor(321)])
  call ol_merge_tensors(T0sum(279),[G0tensor(94)])
  call ol_merge_tensors(T0sum(280),[G0tensor(394)])
  call ol_merge_tensors(T0sum(281),[G0tensor(404)])
  call ol_merge_tensors(T0sum(282),[G0tensor(513)])
  call ol_merge_tensors(T0sum(283),[G0tensor(409)])
  call ol_merge_tensors(T0sum(284),[G0tensor(642)])
  call ol_merge_tensors(T0sum(285),[G0tensor(613)])
  call ol_merge_tensors(T0sum(286),[G0tensor(473)])
  call ol_merge_tensors(T0sum(287),[G0tensor(367)])
  call ol_merge_tensors(T0sum(288),[G0tensor(493)])
  call ol_merge_tensors(T0sum(289),[G0tensor(376)])
  call ol_merge_tensors(T0sum(290),[G0tensor(461)])
  call ol_merge_tensors(T0sum(291),[G0tensor(551)])
  call ol_merge_tensors(T0sum(292),[G0tensor(152)])
  call ol_merge_tensors(T0sum(293),[G0tensor(577)])
  call ol_merge_tensors(T0sum(294),[G0tensor(583)])
  call ol_merge_tensors(T0sum(295),[G0tensor(661)])
  call ol_merge_tensors(T0sum(296),[G0tensor(595)])
  call ol_merge_tensors(T0sum(297),[G0tensor(112)])
  call ol_merge_tensors(T0sum(298),[G0tensor(172)])
  call ol_merge_tensors(T0sum(299),[G0tensor(227)])
  call ol_merge_tensors(T0sum(300),[G0tensor(280)])
  call ol_merge_tensors(T0sum(301),[G0tensor(775)])
  call ol_merge_tensors(T0sum(302),[G0tensor(720)])
  call ol_merge_tensors(T0sum(303),[G0tensor(722)])
  call ol_merge_tensors(T0sum(304),[G0tensor(781)])
  call ol_merge_tensors(T0sum(305),[G0tensor(787)])
  call ol_merge_tensors(T0sum(306),[G0tensor(742)])
  call ol_merge_tensors(T0sum(307),[G0tensor(744)])
  call ol_merge_tensors(T0sum(308),[G0tensor(793)])
  call ol_merge_tensors(T0sum(309),[G0tensor(711)])
  call ol_merge_tensors(T0sum(310),[G0tensor(48)])
  call ol_merge_tensors(T0sum(311),[G0tensor(315)])
  call ol_merge_tensors(T0sum(312),[G0tensor(733)])
  call ol_merge_tensors(T0sum(313),[G0tensor(405)])
  call ol_merge_tensors(T0sum(314),[G0tensor(387)])
  call ol_merge_tensors(T0sum(315),[G0tensor(714)])
  call ol_merge_tensors(T0sum(316),[G0tensor(725)])
  call ol_merge_tensors(T0sum(317),[G0tensor(736)])
  call ol_merge_tensors(T0sum(318),[G0tensor(747)])
  call ol_merge_tensors(T0sum(319),[G0tensor(155)])
  call ol_merge_tensors(T0sum(320),[G0tensor(480)])
  call ol_merge_tensors(T0sum(321),[G0tensor(505)])
  call ol_merge_tensors(T0sum(322),[G0tensor(282)])
  call ol_merge_tensors(T0sum(323),[G0tensor(698)])
  call ol_merge_tensors(T0sum(324),[G0tensor(764)])
  call ol_merge_tensors(T0sum(325),[G0tensor(666)])
  call ol_merge_tensors(T0sum(326),[G0tensor(671)])
  call ol_merge_tensors(T0sum(327),[G0tensor(681)])
  call ol_merge_tensors(T0sum(328),[G0tensor(687)])
  call ol_merge_tensors(T0sum(329),[G0tensor(704)])
  call ol_merge_tensors(T0sum(330),[G0tensor(752)])
  call ol_merge_tensors(T0sum(331),[G0tensor(758)])
  call ol_merge_tensors(T0sum(332),[G0tensor(770)])
  call ol_merge_tensors(T0sum(333),[G0tensor(317)])
  call ol_merge_tensors(T0sum(334),[G0tensor(660)])
  call ol_merge_tensors(T0sum(335),[G0tensor(771)])
  call ol_merge_tensors(T0sum(336),[G0tensor(765)])
  call ol_merge_tensors(T0sum(337),[G0tensor(806)])
  call ol_merge_tensors(T0sum(338),[G0tensor(175)])
  call ol_merge_tensors(T0sum(339),[G0tensor(812)])
  call ol_merge_tensors(T0sum(340),[G0tensor(272)])
  call ol_merge_tensors(T0sum(341),[G0tensor(818)])
  call ol_merge_tensors(T0sum(342),[G0tensor(164)])
  call ol_merge_tensors(T0sum(343),[G0tensor(824)])
  call ol_merge_tensors(T0sum(344),[G0tensor(84)])
  call ol_merge_tensors(T0sum(345),[G0tensor(829)])
  call ol_merge_tensors(T0sum(346),[G0tensor(219)])
  call ol_merge_tensors(T0sum(347),[G0tensor(835)])
  call ol_merge_tensors(T0sum(348),[G0tensor(417)])
  call ol_merge_tensors(T0sum(349),[G0tensor(841)])
  call ol_merge_tensors(T0sum(350),[G0tensor(844)])
  call ol_merge_tensors(T0sum(351),[G0tensor(845)])
  call ol_merge_tensors(T0sum(352),[G0tensor(846)])
  call ol_merge_tensors(T0sum(353),[G0tensor(847)])
  call ol_merge_tensors(T0sum(354),[G0tensor(849)])
  call ol_merge_tensors(T0sum(355),[G0tensor(850)])
  call ol_merge_tensors(T0sum(356),[G0tensor(851)])
  call ol_merge_tensors(T0sum(357),[G0tensor(852)])
  call ol_merge_tensors(T0sum(358),[G0tensor(854)])
  call ol_merge_tensors(T0sum(359),[G0tensor(855)])
  call ol_merge_tensors(T0sum(360),[G0tensor(856)])
  call ol_merge_tensors(T0sum(361),[G0tensor(857)])
  call ol_merge_tensors(T0sum(362),[G0tensor(859)])
  call ol_merge_tensors(T0sum(363),[G0tensor(860)])
  call ol_merge_tensors(T0sum(364),[G0tensor(861)])


! Compute scalar Master integrals 

  call compute_scalar_box([ 17, 21, 29 ],masses2_61,RedSet_4(9),ScalarBoxes(1))
  call compute_scalar_box([ 16, 21, 29 ],masses2_49,RedSet_4(10),ScalarBoxes(2))
  call compute_scalar_box([ 16, 17, 29 ],masses2_49,RedSet_4(11),ScalarBoxes(3))
  call compute_scalar_box([ 16, 17, 21 ],masses2_49,RedSet_4(7),ScalarBoxes(4))
  call compute_scalar_box([ 1, 5, 13 ],masses2_61,RedSet_4(12),ScalarBoxes(5))
  call compute_scalar_box([ 17, 25, 29 ],masses2_61,RedSet_4(13),ScalarBoxes(6))
  call compute_scalar_box([ 16, 25, 29 ],masses2_49,RedSet_4(14),ScalarBoxes(7))
  call compute_scalar_box([ 16, 17, 25 ],masses2_49,RedSet_4(8),ScalarBoxes(8))
  call compute_scalar_box([ 1, 9, 13 ],masses2_61,RedSet_4(15),ScalarBoxes(9))
  call compute_scalar_box([ 20, 21, 23 ],masses2_53,RedSet_4(16),ScalarBoxes(10))
  call compute_scalar_box([ 16, 21, 23 ],masses2_53,RedSet_4(17),ScalarBoxes(11))
  call compute_scalar_box([ 16, 20, 23 ],masses2_56,RedSet_4(18),ScalarBoxes(12))
  call compute_scalar_box([ 16, 20, 21 ],masses2_55,RedSet_4(1),ScalarBoxes(13))
  call compute_scalar_box([ 4, 5, 7 ],masses2_53,RedSet_4(19),ScalarBoxes(14))
  call compute_scalar_box([ 20, 21, 23 ],masses2_58,RedSet_4(16),ScalarBoxes(15))
  call compute_scalar_box([ 16, 21, 23 ],masses2_58,RedSet_4(17),ScalarBoxes(16))
  call compute_scalar_box([ 16, 20, 21 ],masses2_57,RedSet_4(1),ScalarBoxes(17))
  call compute_scalar_box([ 4, 5, 7 ],masses2_58,RedSet_4(19),ScalarBoxes(18))
  call compute_scalar_box([ 20, 21, 23 ],masses2_48,RedSet_4(16),ScalarBoxes(19))
  call compute_scalar_box([ 16, 21, 23 ],masses2_48,RedSet_4(17),ScalarBoxes(20))
  call compute_scalar_box([ 16, 20, 23 ],masses2_45,RedSet_4(18),ScalarBoxes(21))
  call compute_scalar_box([ 16, 20, 21 ],masses2_46,RedSet_4(1),ScalarBoxes(22))
  call compute_scalar_box([ 4, 5, 7 ],masses2_48,RedSet_4(19),ScalarBoxes(23))
  call compute_scalar_box([ 20, 21, 23 ],masses2_52,RedSet_4(16),ScalarBoxes(24))
  call compute_scalar_box([ 16, 21, 23 ],masses2_52,RedSet_4(17),ScalarBoxes(25))
  call compute_scalar_box([ 16, 20, 21 ],masses2_54,RedSet_4(1),ScalarBoxes(26))
  call compute_scalar_box([ 4, 5, 7 ],masses2_52,RedSet_4(19),ScalarBoxes(27))
  call compute_scalar_box([ 18, 19, 23 ],masses2_51,RedSet_4(20),ScalarBoxes(28))
  call compute_scalar_box([ 16, 19, 23 ],masses2_56,RedSet_4(21),ScalarBoxes(29))
  call compute_scalar_box([ 16, 18, 23 ],masses2_53,RedSet_4(22),ScalarBoxes(30))
  call compute_scalar_box([ 16, 18, 19 ],masses2_53,RedSet_4(2),ScalarBoxes(31))
  call compute_scalar_box([ 2, 3, 7 ],masses2_51,RedSet_4(23),ScalarBoxes(32))
  call compute_scalar_box([ 18, 19, 23 ],masses2_62,RedSet_4(20),ScalarBoxes(33))
  call compute_scalar_box([ 16, 18, 23 ],masses2_58,RedSet_4(22),ScalarBoxes(34))
  call compute_scalar_box([ 16, 18, 19 ],masses2_58,RedSet_4(2),ScalarBoxes(35))
  call compute_scalar_box([ 2, 3, 7 ],masses2_62,RedSet_4(23),ScalarBoxes(36))
  call compute_scalar_box([ 18, 19, 23 ],masses2_59,RedSet_4(20),ScalarBoxes(37))
  call compute_scalar_box([ 16, 19, 23 ],masses2_45,RedSet_4(21),ScalarBoxes(38))
  call compute_scalar_box([ 16, 18, 23 ],masses2_48,RedSet_4(22),ScalarBoxes(39))
  call compute_scalar_box([ 16, 18, 19 ],masses2_48,RedSet_4(2),ScalarBoxes(40))
  call compute_scalar_box([ 2, 3, 7 ],masses2_59,RedSet_4(23),ScalarBoxes(41))
  call compute_scalar_box([ 18, 19, 23 ],masses2_44,RedSet_4(20),ScalarBoxes(42))
  call compute_scalar_box([ 16, 18, 23 ],masses2_52,RedSet_4(22),ScalarBoxes(43))
  call compute_scalar_box([ 16, 18, 19 ],masses2_52,RedSet_4(2),ScalarBoxes(44))
  call compute_scalar_box([ 2, 3, 7 ],masses2_44,RedSet_4(23),ScalarBoxes(45))
  call compute_scalar_box([ 20, 22, 23 ],masses2_53,RedSet_4(24),ScalarBoxes(46))
  call compute_scalar_box([ 16, 22, 23 ],masses2_53,RedSet_4(25),ScalarBoxes(47))
  call compute_scalar_box([ 16, 20, 22 ],masses2_55,RedSet_4(3),ScalarBoxes(48))
  call compute_scalar_box([ 4, 6, 7 ],masses2_53,RedSet_4(26),ScalarBoxes(49))
  call compute_scalar_box([ 20, 22, 23 ],masses2_58,RedSet_4(24),ScalarBoxes(50))
  call compute_scalar_box([ 16, 22, 23 ],masses2_58,RedSet_4(25),ScalarBoxes(51))
  call compute_scalar_box([ 16, 20, 22 ],masses2_57,RedSet_4(3),ScalarBoxes(52))
  call compute_scalar_box([ 4, 6, 7 ],masses2_58,RedSet_4(26),ScalarBoxes(53))
  call compute_scalar_box([ 20, 22, 23 ],masses2_48,RedSet_4(24),ScalarBoxes(54))
  call compute_scalar_box([ 16, 22, 23 ],masses2_48,RedSet_4(25),ScalarBoxes(55))
  call compute_scalar_box([ 16, 20, 22 ],masses2_46,RedSet_4(3),ScalarBoxes(56))
  call compute_scalar_box([ 4, 6, 7 ],masses2_48,RedSet_4(26),ScalarBoxes(57))
  call compute_scalar_box([ 20, 22, 23 ],masses2_52,RedSet_4(24),ScalarBoxes(58))
  call compute_scalar_box([ 16, 22, 23 ],masses2_52,RedSet_4(25),ScalarBoxes(59))
  call compute_scalar_box([ 16, 20, 22 ],masses2_54,RedSet_4(3),ScalarBoxes(60))
  call compute_scalar_box([ 4, 6, 7 ],masses2_52,RedSet_4(26),ScalarBoxes(61))
  call compute_scalar_box([ 18, 19, 27 ],masses2_51,RedSet_4(27),ScalarBoxes(62))
  call compute_scalar_box([ 16, 19, 27 ],masses2_56,RedSet_4(28),ScalarBoxes(63))
  call compute_scalar_box([ 16, 18, 27 ],masses2_53,RedSet_4(29),ScalarBoxes(64))
  call compute_scalar_box([ 2, 3, 11 ],masses2_51,RedSet_4(30),ScalarBoxes(65))
  call compute_scalar_box([ 18, 19, 27 ],masses2_62,RedSet_4(27),ScalarBoxes(66))
  call compute_scalar_box([ 16, 18, 27 ],masses2_58,RedSet_4(29),ScalarBoxes(67))
  call compute_scalar_box([ 2, 3, 11 ],masses2_62,RedSet_4(30),ScalarBoxes(68))
  call compute_scalar_box([ 18, 19, 27 ],masses2_59,RedSet_4(27),ScalarBoxes(69))
  call compute_scalar_box([ 16, 19, 27 ],masses2_45,RedSet_4(28),ScalarBoxes(70))
  call compute_scalar_box([ 16, 18, 27 ],masses2_48,RedSet_4(29),ScalarBoxes(71))
  call compute_scalar_box([ 2, 3, 11 ],masses2_59,RedSet_4(30),ScalarBoxes(72))
  call compute_scalar_box([ 18, 19, 27 ],masses2_44,RedSet_4(27),ScalarBoxes(73))
  call compute_scalar_box([ 16, 18, 27 ],masses2_52,RedSet_4(29),ScalarBoxes(74))
  call compute_scalar_box([ 2, 3, 11 ],masses2_44,RedSet_4(30),ScalarBoxes(75))
  call compute_scalar_box([ 17, 19, 23 ],masses2_51,RedSet_4(31),ScalarBoxes(76))
  call compute_scalar_box([ 16, 17, 23 ],masses2_53,RedSet_4(32),ScalarBoxes(77))
  call compute_scalar_box([ 16, 17, 19 ],masses2_53,RedSet_4(4),ScalarBoxes(78))
  call compute_scalar_box([ 1, 3, 7 ],masses2_51,RedSet_4(33),ScalarBoxes(79))
  call compute_scalar_box([ 17, 19, 23 ],masses2_62,RedSet_4(31),ScalarBoxes(80))
  call compute_scalar_box([ 16, 17, 23 ],masses2_58,RedSet_4(32),ScalarBoxes(81))
  call compute_scalar_box([ 16, 17, 19 ],masses2_58,RedSet_4(4),ScalarBoxes(82))
  call compute_scalar_box([ 1, 3, 7 ],masses2_62,RedSet_4(33),ScalarBoxes(83))
  call compute_scalar_box([ 17, 19, 23 ],masses2_59,RedSet_4(31),ScalarBoxes(84))
  call compute_scalar_box([ 16, 17, 23 ],masses2_48,RedSet_4(32),ScalarBoxes(85))
  call compute_scalar_box([ 16, 17, 19 ],masses2_48,RedSet_4(4),ScalarBoxes(86))
  call compute_scalar_box([ 1, 3, 7 ],masses2_59,RedSet_4(33),ScalarBoxes(87))
  call compute_scalar_box([ 17, 19, 23 ],masses2_44,RedSet_4(31),ScalarBoxes(88))
  call compute_scalar_box([ 16, 17, 23 ],masses2_52,RedSet_4(32),ScalarBoxes(89))
  call compute_scalar_box([ 16, 17, 19 ],masses2_52,RedSet_4(4),ScalarBoxes(90))
  call compute_scalar_box([ 1, 3, 7 ],masses2_44,RedSet_4(33),ScalarBoxes(91))
  call compute_scalar_box([ 17, 19, 27 ],masses2_51,RedSet_4(34),ScalarBoxes(92))
  call compute_scalar_box([ 16, 17, 27 ],masses2_53,RedSet_4(35),ScalarBoxes(93))
  call compute_scalar_box([ 1, 3, 11 ],masses2_51,RedSet_4(36),ScalarBoxes(94))
  call compute_scalar_box([ 17, 19, 27 ],masses2_62,RedSet_4(34),ScalarBoxes(95))
  call compute_scalar_box([ 16, 17, 27 ],masses2_58,RedSet_4(35),ScalarBoxes(96))
  call compute_scalar_box([ 1, 3, 11 ],masses2_62,RedSet_4(36),ScalarBoxes(97))
  call compute_scalar_box([ 17, 19, 27 ],masses2_59,RedSet_4(34),ScalarBoxes(98))
  call compute_scalar_box([ 16, 17, 27 ],masses2_48,RedSet_4(35),ScalarBoxes(99))
  call compute_scalar_box([ 1, 3, 11 ],masses2_59,RedSet_4(36),ScalarBoxes(100))
  call compute_scalar_box([ 17, 19, 27 ],masses2_44,RedSet_4(34),ScalarBoxes(101))
  call compute_scalar_box([ 16, 17, 27 ],masses2_52,RedSet_4(35),ScalarBoxes(102))
  call compute_scalar_box([ 1, 3, 11 ],masses2_44,RedSet_4(36),ScalarBoxes(103))
  call compute_scalar_box([ 18, 22, 23 ],masses2_60,RedSet_4(37),ScalarBoxes(104))
  call compute_scalar_box([ 16, 18, 22 ],masses2_49,RedSet_4(5),ScalarBoxes(105))
  call compute_scalar_box([ 2, 6, 7 ],masses2_60,RedSet_4(38),ScalarBoxes(106))
  call compute_scalar_box([ 18, 26, 27 ],masses2_60,RedSet_4(39),ScalarBoxes(107))
  call compute_scalar_box([ 16, 26, 27 ],masses2_48,RedSet_4(40),ScalarBoxes(108))
  call compute_scalar_box([ 16, 18, 26 ],masses2_49,RedSet_4(6),ScalarBoxes(109))
  call compute_scalar_box([ 2, 10, 11 ],masses2_60,RedSet_4(41),ScalarBoxes(110))
  call compute_scalar_box([ 17, 21, 23 ],masses2_60,RedSet_4(42),ScalarBoxes(111))
  call compute_scalar_box([ 1, 5, 7 ],masses2_60,RedSet_4(43),ScalarBoxes(112))
  call compute_scalar_box([ 17, 25, 27 ],masses2_60,RedSet_4(44),ScalarBoxes(113))
  call compute_scalar_box([ 16, 25, 27 ],masses2_48,RedSet_4(45),ScalarBoxes(114))
  call compute_scalar_box([ 1, 9, 11 ],masses2_60,RedSet_4(46),ScalarBoxes(115))
! end of process


end subroutine vamp_1

end module ol_vamp_1_ppttj_ew_ttxaag_2_/**/REALKIND
