
module ol_vamp_1_ppttj_ew_ttxaaa_2_/**/REALKIND
contains

! **********************************************************************
subroutine vamp_1(M)
! P(0:3,nlegs) = incoming external momenta
! Uses tree structures 'wf', factors 'c', and denominators 'den' from loop_ppttj_ew_ttxaaa_2.
! Sets colour stripped amplitudes A from the module loop_amplitudes_ppttj_ew_ttxaaa_2.
! **********************************************************************
  use KIND_TYPES, only: REALKIND, QREALKIND, intkind2
  use ol_parameters_decl_/**/DREALKIND, only: l_switch
  use ol_parameters_decl_/**/QREALKIND ! masses
  use ol_vert_interface_/**/REALKIND
  use ol_prop_interface_/**/REALKIND
  use ol_last_step_/**/REALKIND
  use ol_tables_storage_ppttj_ew_ttxaaa_2_/**/DREALKIND
  use ol_tensor_sum_storage_ppttj_ew_ttxaaa_2_/**/REALKIND
  use ol_loop_handling_/**/REALKIND
  use ofred_reduction_/**/REALKIND, only: Hotf_4pt_reduction, Hotf_4pt_reduction_last
  use ofred_reduction_/**/REALKIND, only: Hotf_5pt_reduction, Hotf_5pt_reduction_last
  use ol_loop_reduction_/**/REALKIND, only: TI_bubble_red, TI_triangle_red
use ol_loop_reduction_/**/REALKIND, only: compute_scalar_box

  use ol_loop_storage_ppttj_ew_ttxaaa_2_/**/REALKIND
#ifndef PRECISION_dp
  use ol_loop_storage_ppttj_ew_ttxaaa_2_/**/DREALKIND, only: &
    & p_switch, Hel, merge_step, merge_mism, merge_tables, merge_hels, ntryL, hel_states
#endif
  use hol_initialisation_/**/REALKIND, only: G0_hol_initialisation
  use ol_h_vert_interface_/**/REALKIND
  use ol_h_prop_interface_/**/REALKIND
  use ol_h_last_step_/**/REALKIND
  use ol_merging_/**/REALKIND, only: ol_merge, ol_merge_tensors, ol_merge_last

  implicit none

  type(Hpolcont) :: Gcoeff(hel_states)
  type(Hpolcont), intent(in) :: M(1,hel_states)


#ifndef PRECISION_dp
  if (ntryL==1 .OR. p_switch == 1) Gcoeff(:)%hf = Hel(1:hel_states)
#else
  if (ntryL==1 .OR. p_switch == 2) Gcoeff(:)%hf = Hel(1:hel_states)
#endif

  ! =============================================


! Dressing, otf merging and otf reduction calls to build loop structures

  Gcoeff(:)%j = (-(c(45)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1),h0tab(:,1),[16,4,1,2,8],[nMT,nMT,nMH,nMT,nMT],5,0)
  call Hloop_AV_Q(ntryL,G0H32(1),ex5(:),G0H16(1),m3h2x16(:,1),heltab2x32(:,:,1))
  call Hloop_A_Q(ntryL,G0H16(1),16,nMT,G1H16(1),n2h16(1))
  Gcoeff(:)%j = (c(45)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(2),h0tab(:,2),[16,4,1,2,8],[nMT,nMT,nMZ,nMT,nMT],5,0)
  call Hloop_AV_Q(ntryL,G0H32(1),ex5(:),G0H16(1),m3h2x16(:,2),heltab2x32(:,:,2))
  call Hloop_A_Q(ntryL,G0H16(1),16,nMT,G1H16(2),n2h16(2))
  Gcoeff(:)%j = (-(c(29)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(3),h0tab(:,3),[16,4,1,2,8],[nMB,nMB,nMW,nMB,nMB],5,0)
  call Hloop_AV_Q(ntryL,G0H32(1),ex5(:),G0H16(1),m3h2x16(:,3),heltab2x32(:,:,3))
  call Hloop_A_Q(ntryL,G0H16(1),16,nMB,G1H16(3),n2h16(3))
  Gcoeff(:)%j = (c(38)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(4),h0tab(:,4),[16,4,1,2,8],[nMW,nMW,nMB,nMW,nMW],5,0)
  call Hloop_TV_S(ntryL,G0H32(1),0,ex5(:),16,G1H16(4),m3h2x16(:,4),heltab2x32(:,:,4))
  Gcoeff(:)%j = (c(1)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(5),h0tab(:,5),[16,4,1,2,8],[nMT,nMT,0,nMT,nMT],5,0)
  call Hloop_AV_Q(ntryL,G0H32(1),ex5(:),G0H16(1),m3h2x16(:,5),heltab2x32(:,:,5))
  call Hloop_A_Q(ntryL,G0H16(1),16,nMT,G1H16(5),n2h16(4))
  Gcoeff(:)%j = (c(2)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(6),h0tab(:,6),[16,4,1,2,8],[nMT,nMT,nMZ,nMT,nMT],5,0)
  call Hloop_AV_Q(ntryL,G0H32(1),ex5(:),G0H16(1),m3h2x16(:,6),heltab2x32(:,:,6))
  call Hloop_A_Q(ntryL,G0H16(1),16,nMT,G1H16(6),n2h16(5))
  Gcoeff(:)%j = (-(c(12)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(7),h0tab(:,7),[16,4,1,2,8],[nMB,nMB,nMW,nMB,nMB],5,0)
  call Hloop_AV_Q(ntryL,G0H32(1),ex5(:),G0H16(1),m3h2x16(:,7),heltab2x32(:,:,7))
  call Hloop_A_Q(ntryL,G0H16(1),16,nMB,G1H16(7),n2h16(6))
  Gcoeff(:)%j = (-(c(21)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(8),h0tab(:,8),[16,4,1,2,8],[nMW,nMW,nMB,nMW,nMW],5,0)
  call Hloop_VV_S(ntryL,G0H32(1),ex5(:),G0H16(1),m3h2x16(:,8),heltab2x32(:,:,8))
  Gcoeff(:)%j = (-(c(21)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(9),h0tab(:,9),[16,4,1,2,8],[nMW,nMW,nMB,nMW,nMW],5,0)
  call Hloop_SV_V(ntryL,G0H32(1),ex5(:),G0H16(2),m3h2x16(:,9),heltab2x32(:,:,9))
  Gcoeff(:)%j = (-(c(21)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(10),h0tab(:,10),[16,4,1,2,8],[nMW,nMW,nMB,nMW,nMW],5,0)
  call Hloop_TV_S(ntryL,G0H32(1),0,ex5(:),16,G1H16(8),m3h2x16(:,10),heltab2x32(:,:,10))
  Gcoeff(:)%j = (c(21)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(11),h0tab(:,11),[16,4,1,2,8],[nMW,nMW,nMB,nMW,nMW],5,0)
  call Hloop_TV_S(ntryL,G0H32(1),0,ex5(:),16,G1H16(9),m3h2x16(:,11),heltab2x32(:,:,11))
  Gcoeff(:)%j = (-(c(21)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(12),h0tab(:,12),[16,4,1,2,8],[nMW,nMW,nMB,nMW,nMW],5,0)
  call Hloop_UV_W(ntryL,G0H32(1),0,ex5(:),16,G1H16(10),m3h2x16(:,12),heltab2x32(:,:,12))
  Gcoeff(:)%j = (-(c(21)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(13),h0tab(:,13),[16,4,1,2,8],[nMW,nMW,nMB,nMW,nMW],5,0)
  call Hloop_VV_S(ntryL,G0H32(1),ex5(:),G0H16(3),m3h2x16(:,13),heltab2x32(:,:,13))
  Gcoeff(:)%j = (c(48)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(14),h0tab(:,14),[16,4,1,2,8],[nMW,nMW,nMB,nMW,nMW],5,0)
  call Hloop_SV_V(ntryL,G0H32(1),ex5(:),G0H16(4),m3h2x16(:,14),heltab2x32(:,:,14))
  Gcoeff(:)%j = (-(c(48)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(15),h0tab(:,15),[16,4,1,2,8],[nMW,nMW,nMB,nMW,nMW],5,0)
  call Hloop_VV_S(ntryL,G0H32(1),ex5(:),G0H16(5),m3h2x16(:,15),heltab2x32(:,:,15))
  Gcoeff(:)%j = (c(21)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(16),h0tab(:,16),[16,4,1,2,8],[nMW,nMW,nMB,nMW,nMW],5,0)
  call Hloop_SV_V(ntryL,G0H32(1),ex5(:),G0H16(6),m3h2x16(:,16),heltab2x32(:,:,16))
  Gcoeff(:)%j = (-(c(48)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(17),h0tab(:,17),[16,4,1,2,8],[nMW,nMW,nMB,nMW,nMW],5,0)
  call Hloop_TV_S(ntryL,G0H32(1),0,ex5(:),16,G1H16(11),m3h2x16(:,17),heltab2x32(:,:,17))
  Gcoeff(:)%j = (-(c(21)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(18),h0tab(:,18),[16,4,1,2,8],[nMW,nMW,nMB,nMW,nMW],5,0)
  call Hloop_UV_W(ntryL,G0H32(1),0,ex5(:),16,G1H16(12),m3h2x16(:,18),heltab2x32(:,:,18))
  Gcoeff(:)%j = (c(21)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(19),h0tab(:,19),[16,4,1,2,8],[nMW,nMW,nMB,nMW,nMW],5,0)
  call Hloop_UV_W(ntryL,G0H32(1),0,ex5(:),16,G1H16(13),m3h2x16(:,19),heltab2x32(:,:,19))
  Gcoeff(:)%j = (-(c(48)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(20),h0tab(:,20),[16,4,1,2,8],[nMW,nMW,nMB,nMW,nMW],5,0)
  call Hloop_VV_S(ntryL,G0H32(1),ex5(:),G0H16(7),m3h2x16(:,20),heltab2x32(:,:,20))
  Gcoeff(:)%j = (-(c(48)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(21),h0tab(:,21),[16,4,1,2,8],[nMW,nMW,nMB,nMW,nMW],5,0)
  call Hloop_SV_V(ntryL,G0H32(1),ex5(:),G0H16(8),m3h2x16(:,21),heltab2x32(:,:,21))
  Gcoeff(:)%j = (c(21)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(22),h0tab(:,22),[16,4,1,2,8],[nMW,nMW,nMB,nMW,nMW],5,0)
  call Hloop_UV_W(ntryL,G0H32(1),0,ex5(:),16,G1H16(14),m3h2x16(:,22),heltab2x32(:,:,22))
  Gcoeff(:)%j = (-(c(45)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(23),h0tab(:,23),[16,2,1,4,8],[nMT,nMH,nMT,nMT,nMT],5,0)
  call Hloop_QV_A(ntryL,G0H32(1),ex5(:),G0H16(9),m3h2x16(:,23),heltab2x32(:,:,23))
  call Hloop_Q_A(ntryL,G0H16(9),16,nMT,G1H16(15),n2h16(7))
  Gcoeff(:)%j = (c(45)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(24),h0tab(:,24),[16,2,1,4,8],[nMT,nMZ,nMT,nMT,nMT],5,0)
  call Hloop_QV_A(ntryL,G0H32(1),ex5(:),G0H16(9),m3h2x16(:,24),heltab2x32(:,:,24))
  call Hloop_Q_A(ntryL,G0H16(9),16,nMT,G1H16(16),n2h16(8))
  Gcoeff(:)%j = (-(c(29)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(25),h0tab(:,25),[16,2,1,4,8],[nMB,nMW,nMB,nMB,nMB],5,0)
  call Hloop_QV_A(ntryL,G0H32(1),ex5(:),G0H16(9),m3h2x16(:,25),heltab2x32(:,:,25))
  call Hloop_Q_A(ntryL,G0H16(9),16,nMB,G1H16(17),n2h16(9))
  Gcoeff(:)%j = (c(38)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(26),h0tab(:,26),[16,2,1,4,8],[nMW,nMB,nMW,nMW,nMW],5,0)
  call Hloop_SV_T(ntryL,G0H32(1),0,ex5(:),16,G1H16(18),m3h2x16(:,26),heltab2x32(:,:,26))
  Gcoeff(:)%j = (c(1)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(27),h0tab(:,27),[16,2,1,4,8],[nMT,0,nMT,nMT,nMT],5,0)
  call Hloop_QV_A(ntryL,G0H32(1),ex5(:),G0H16(9),m3h2x16(:,27),heltab2x32(:,:,27))
  call Hloop_Q_A(ntryL,G0H16(9),16,nMT,G1H16(19),n2h16(10))
  Gcoeff(:)%j = (c(2)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(28),h0tab(:,28),[16,2,1,4,8],[nMT,nMZ,nMT,nMT,nMT],5,0)
  call Hloop_QV_A(ntryL,G0H32(1),ex5(:),G0H16(9),m3h2x16(:,28),heltab2x32(:,:,28))
  call Hloop_Q_A(ntryL,G0H16(9),16,nMT,G1H16(20),n2h16(11))
  Gcoeff(:)%j = (-(c(12)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(29),h0tab(:,29),[16,2,1,4,8],[nMB,nMW,nMB,nMB,nMB],5,0)
  call Hloop_QV_A(ntryL,G0H32(1),ex5(:),G0H16(9),m3h2x16(:,29),heltab2x32(:,:,29))
  call Hloop_Q_A(ntryL,G0H16(9),16,nMB,G1H16(21),n2h16(12))
  Gcoeff(:)%j = (-(c(21)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(30),h0tab(:,30),[16,2,1,4,8],[nMW,nMB,nMW,nMW,nMW],5,0)
  call Hloop_VV_S(ntryL,G0H32(1),ex5(:),G0H16(9),m3h2x16(:,30),heltab2x32(:,:,30))
  Gcoeff(:)%j = (-(c(21)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(31),h0tab(:,31),[16,2,1,4,8],[nMW,nMB,nMW,nMW,nMW],5,0)
  call Hloop_SV_T(ntryL,G0H32(1),0,ex5(:),16,G1H16(22),m3h2x16(:,31),heltab2x32(:,:,31))
  Gcoeff(:)%j = (-(c(21)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(32),h0tab(:,32),[16,2,1,4,8],[nMW,nMB,nMW,nMW,nMW],5,0)
  call Hloop_SV_V(ntryL,G0H32(1),ex5(:),G0H16(10),m3h2x16(:,32),heltab2x32(:,:,32))
  Gcoeff(:)%j = (c(21)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(33),h0tab(:,33),[16,2,1,4,8],[nMW,nMB,nMW,nMW,nMW],5,0)
  call Hloop_SV_T(ntryL,G0H32(1),0,ex5(:),16,G1H16(23),m3h2x16(:,33),heltab2x32(:,:,33))
  Gcoeff(:)%j = (-(c(21)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(34),h0tab(:,34),[16,2,1,4,8],[nMW,nMB,nMW,nMW,nMW],5,0)
  call Hloop_VV_S(ntryL,G0H32(1),ex5(:),G0H16(11),m3h2x16(:,34),heltab2x32(:,:,34))
  Gcoeff(:)%j = (-(c(21)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(35),h0tab(:,35),[16,2,1,4,8],[nMW,nMB,nMW,nMW,nMW],5,0)
  call Hloop_UW_V(ntryL,G0H32(1),0,ex5(:),16,G1H16(24),m3h2x16(:,35),heltab2x32(:,:,35))
  Gcoeff(:)%j = (c(48)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(36),h0tab(:,36),[16,2,1,4,8],[nMW,nMB,nMW,nMW,nMW],5,0)
  call Hloop_SV_V(ntryL,G0H32(1),ex5(:),G0H16(12),m3h2x16(:,36),heltab2x32(:,:,36))
  Gcoeff(:)%j = (-(c(48)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(37),h0tab(:,37),[16,2,1,4,8],[nMW,nMB,nMW,nMW,nMW],5,0)
  call Hloop_VV_S(ntryL,G0H32(1),ex5(:),G0H16(13),m3h2x16(:,37),heltab2x32(:,:,37))
  Gcoeff(:)%j = (c(21)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(38),h0tab(:,38),[16,2,1,4,8],[nMW,nMB,nMW,nMW,nMW],5,0)
  call Hloop_SV_T(ntryL,G0H32(1),0,ex5(:),16,G1H16(25),m3h2x16(:,38),heltab2x32(:,:,38))
  Gcoeff(:)%j = (-(c(48)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(39),h0tab(:,39),[16,2,1,4,8],[nMW,nMB,nMW,nMW,nMW],5,0)
  call Hloop_SV_V(ntryL,G0H32(1),ex5(:),G0H16(14),m3h2x16(:,39),heltab2x32(:,:,39))
  Gcoeff(:)%j = (-(c(21)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(40),h0tab(:,40),[16,2,1,4,8],[nMW,nMB,nMW,nMW,nMW],5,0)
  call Hloop_UW_V(ntryL,G0H32(1),0,ex5(:),16,G1H16(26),m3h2x16(:,40),heltab2x32(:,:,40))
  Gcoeff(:)%j = (c(21)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(41),h0tab(:,41),[16,2,1,4,8],[nMW,nMB,nMW,nMW,nMW],5,0)
  call Hloop_VV_S(ntryL,G0H32(1),ex5(:),G0H16(15),m3h2x16(:,41),heltab2x32(:,:,41))
  Gcoeff(:)%j = (-(c(48)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(42),h0tab(:,42),[16,2,1,4,8],[nMW,nMB,nMW,nMW,nMW],5,0)
  call Hloop_UW_V(ntryL,G0H32(1),0,ex5(:),16,G1H16(27),m3h2x16(:,42),heltab2x32(:,:,42))
  Gcoeff(:)%j = (-(c(48)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(43),h0tab(:,43),[16,2,1,4,8],[nMW,nMB,nMW,nMW,nMW],5,0)
  call Hloop_SV_V(ntryL,G0H32(1),ex5(:),G0H16(16),m3h2x16(:,43),heltab2x32(:,:,43))
  Gcoeff(:)%j = (c(21)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(44),h0tab(:,44),[16,2,1,4,8],[nMW,nMB,nMW,nMW,nMW],5,0)
  call Hloop_UW_V(ntryL,G0H32(1),0,ex5(:),16,G1H16(28),m3h2x16(:,44),heltab2x32(:,:,44))
  Gcoeff(:)%j = (-(c(45)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(45),h0tab(:,45),[16,4,2,1,8],[nMT,nMT,nMH,nMT,nMT],5,0)
  call Hloop_QV_A(ntryL,G0H32(1),ex5(:),G0H16(17),m3h2x16(:,45),heltab2x32(:,:,45))
  call Hloop_Q_A(ntryL,G0H16(17),16,nMT,G1H16(29),n2h16(13))
  Gcoeff(:)%j = (c(45)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(46),h0tab(:,46),[16,4,2,1,8],[nMT,nMT,nMZ,nMT,nMT],5,0)
  call Hloop_QV_A(ntryL,G0H32(1),ex5(:),G0H16(17),m3h2x16(:,46),heltab2x32(:,:,46))
  call Hloop_Q_A(ntryL,G0H16(17),16,nMT,G1H16(30),n2h16(14))
  Gcoeff(:)%j = (-(c(29)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(47),h0tab(:,47),[16,4,2,1,8],[nMB,nMB,nMW,nMB,nMB],5,0)
  call Hloop_QV_A(ntryL,G0H32(1),ex5(:),G0H16(17),m3h2x16(:,47),heltab2x32(:,:,47))
  call Hloop_Q_A(ntryL,G0H16(17),16,nMB,G1H16(31),n2h16(15))
  Gcoeff(:)%j = (c(38)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(48),h0tab(:,48),[16,4,2,1,8],[nMW,nMW,nMB,nMW,nMW],5,0)
  call Hloop_SV_T(ntryL,G0H32(1),0,ex5(:),16,G1H16(32),m3h2x16(:,48),heltab2x32(:,:,48))
  Gcoeff(:)%j = (c(1)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(49),h0tab(:,49),[16,4,2,1,8],[nMT,nMT,0,nMT,nMT],5,0)
  call Hloop_QV_A(ntryL,G0H32(1),ex5(:),G0H16(17),m3h2x16(:,49),heltab2x32(:,:,49))
  call Hloop_Q_A(ntryL,G0H16(17),16,nMT,G1H16(33),n2h16(16))
  Gcoeff(:)%j = (c(2)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(50),h0tab(:,50),[16,4,2,1,8],[nMT,nMT,nMZ,nMT,nMT],5,0)
  call Hloop_QV_A(ntryL,G0H32(1),ex5(:),G0H16(17),m3h2x16(:,50),heltab2x32(:,:,50))
  call Hloop_Q_A(ntryL,G0H16(17),16,nMT,G1H16(34),n2h16(17))
  Gcoeff(:)%j = (-(c(12)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(51),h0tab(:,51),[16,4,2,1,8],[nMB,nMB,nMW,nMB,nMB],5,0)
  call Hloop_QV_A(ntryL,G0H32(1),ex5(:),G0H16(17),m3h2x16(:,51),heltab2x32(:,:,51))
  call Hloop_Q_A(ntryL,G0H16(17),16,nMB,G1H16(35),n2h16(18))
  Gcoeff(:)%j = (-(c(21)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(52),h0tab(:,52),[16,4,2,1,8],[nMW,nMW,nMB,nMW,nMW],5,0)
  call Hloop_VV_S(ntryL,G0H32(1),ex5(:),G0H16(17),m3h2x16(:,52),heltab2x32(:,:,52))
  Gcoeff(:)%j = (-(c(21)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(53),h0tab(:,53),[16,4,2,1,8],[nMW,nMW,nMB,nMW,nMW],5,0)
  call Hloop_SV_V(ntryL,G0H32(1),ex5(:),G0H16(18),m3h2x16(:,53),heltab2x32(:,:,53))
  Gcoeff(:)%j = (-(c(21)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(54),h0tab(:,54),[16,4,2,1,8],[nMW,nMW,nMB,nMW,nMW],5,0)
  call Hloop_SV_T(ntryL,G0H32(1),0,ex5(:),16,G1H16(36),m3h2x16(:,54),heltab2x32(:,:,54))
  Gcoeff(:)%j = (c(21)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(55),h0tab(:,55),[16,4,2,1,8],[nMW,nMW,nMB,nMW,nMW],5,0)
  call Hloop_SV_T(ntryL,G0H32(1),0,ex5(:),16,G1H16(37),m3h2x16(:,55),heltab2x32(:,:,55))
  Gcoeff(:)%j = (-(c(21)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(56),h0tab(:,56),[16,4,2,1,8],[nMW,nMW,nMB,nMW,nMW],5,0)
  call Hloop_UW_V(ntryL,G0H32(1),0,ex5(:),16,G1H16(38),m3h2x16(:,56),heltab2x32(:,:,56))
  Gcoeff(:)%j = (c(48)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(57),h0tab(:,57),[16,4,2,1,8],[nMW,nMW,nMB,nMW,nMW],5,0)
  call Hloop_VV_S(ntryL,G0H32(1),ex5(:),G0H16(19),m3h2x16(:,57),heltab2x32(:,:,57))
  Gcoeff(:)%j = (-(c(21)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(58),h0tab(:,58),[16,4,2,1,8],[nMW,nMW,nMB,nMW,nMW],5,0)
  call Hloop_SV_V(ntryL,G0H32(1),ex5(:),G0H16(20),m3h2x16(:,58),heltab2x32(:,:,58))
  Gcoeff(:)%j = (c(21)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(59),h0tab(:,59),[16,4,2,1,8],[nMW,nMW,nMB,nMW,nMW],5,0)
  call Hloop_VV_S(ntryL,G0H32(1),ex5(:),G0H16(21),m3h2x16(:,59),heltab2x32(:,:,59))
  Gcoeff(:)%j = (-(c(48)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(60),h0tab(:,60),[16,4,2,1,8],[nMW,nMW,nMB,nMW,nMW],5,0)
  call Hloop_SV_V(ntryL,G0H32(1),ex5(:),G0H16(22),m3h2x16(:,60),heltab2x32(:,:,60))
  Gcoeff(:)%j = (-(c(48)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(61),h0tab(:,61),[16,4,2,1,8],[nMW,nMW,nMB,nMW,nMW],5,0)
  call Hloop_SV_T(ntryL,G0H32(1),0,ex5(:),16,G1H16(39),m3h2x16(:,61),heltab2x32(:,:,61))
  Gcoeff(:)%j = (-(c(21)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(62),h0tab(:,62),[16,4,2,1,8],[nMW,nMW,nMB,nMW,nMW],5,0)
  call Hloop_UW_V(ntryL,G0H32(1),0,ex5(:),16,G1H16(40),m3h2x16(:,62),heltab2x32(:,:,62))
  Gcoeff(:)%j = (c(21)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(63),h0tab(:,63),[16,4,2,1,8],[nMW,nMW,nMB,nMW,nMW],5,0)
  call Hloop_UW_V(ntryL,G0H32(1),0,ex5(:),16,G1H16(41),m3h2x16(:,63),heltab2x32(:,:,63))
  Gcoeff(:)%j = (-(c(48)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(64),h0tab(:,64),[16,4,2,1,8],[nMW,nMW,nMB,nMW,nMW],5,0)
  call Hloop_VV_S(ntryL,G0H32(1),ex5(:),G0H16(23),m3h2x16(:,64),heltab2x32(:,:,64))
  Gcoeff(:)%j = (-(c(48)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(65),h0tab(:,65),[16,4,2,1,8],[nMW,nMW,nMB,nMW,nMW],5,0)
  call Hloop_SV_V(ntryL,G0H32(1),ex5(:),G0H16(24),m3h2x16(:,65),heltab2x32(:,:,65))
  Gcoeff(:)%j = (c(21)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(66),h0tab(:,66),[16,4,2,1,8],[nMW,nMW,nMB,nMW,nMW],5,0)
  call Hloop_UW_V(ntryL,G0H32(1),0,ex5(:),16,G1H16(42),m3h2x16(:,66),heltab2x32(:,:,66))
  Gcoeff(:)%j = (-(c(45)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(67),h0tab(:,67),[16,2,1,8,4],[nMT,nMH,nMT,nMT,nMT],5,0)
  call Hloop_QV_A(ntryL,G0H32(1),ex5(:),G0H16(25),m3h2x16(:,67),heltab2x32(:,:,67))
  call Hloop_Q_A(ntryL,G0H16(25),16,nMT,G1H16(43),n2h16(19))
  Gcoeff(:)%j = (c(45)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(68),h0tab(:,68),[16,2,1,8,4],[nMT,nMZ,nMT,nMT,nMT],5,0)
  call Hloop_QV_A(ntryL,G0H32(1),ex5(:),G0H16(25),m3h2x16(:,68),heltab2x32(:,:,68))
  call Hloop_Q_A(ntryL,G0H16(25),16,nMT,G1H16(44),n2h16(20))
  Gcoeff(:)%j = (-(c(29)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(69),h0tab(:,69),[16,2,1,8,4],[nMB,nMW,nMB,nMB,nMB],5,0)
  call Hloop_QV_A(ntryL,G0H32(1),ex5(:),G0H16(25),m3h2x16(:,69),heltab2x32(:,:,69))
  call Hloop_Q_A(ntryL,G0H16(25),16,nMB,G1H16(45),n2h16(21))
  Gcoeff(:)%j = (c(38)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(70),h0tab(:,70),[16,2,1,8,4],[nMW,nMB,nMW,nMW,nMW],5,0)
  call Hloop_SV_T(ntryL,G0H32(1),0,ex5(:),16,G1H16(46),m3h2x16(:,70),heltab2x32(:,:,70))
  Gcoeff(:)%j = (c(1)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(71),h0tab(:,71),[16,2,1,8,4],[nMT,0,nMT,nMT,nMT],5,0)
  call Hloop_QV_A(ntryL,G0H32(1),ex5(:),G0H16(25),m3h2x16(:,71),heltab2x32(:,:,71))
  call Hloop_Q_A(ntryL,G0H16(25),16,nMT,G1H16(47),n2h16(22))
  Gcoeff(:)%j = (c(2)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(72),h0tab(:,72),[16,2,1,8,4],[nMT,nMZ,nMT,nMT,nMT],5,0)
  call Hloop_QV_A(ntryL,G0H32(1),ex5(:),G0H16(25),m3h2x16(:,72),heltab2x32(:,:,72))
  call Hloop_Q_A(ntryL,G0H16(25),16,nMT,G1H16(48),n2h16(23))
  Gcoeff(:)%j = (-(c(12)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(73),h0tab(:,73),[16,2,1,8,4],[nMB,nMW,nMB,nMB,nMB],5,0)
  call Hloop_QV_A(ntryL,G0H32(1),ex5(:),G0H16(25),m3h2x16(:,73),heltab2x32(:,:,73))
  call Hloop_Q_A(ntryL,G0H16(25),16,nMB,G1H16(49),n2h16(24))
  Gcoeff(:)%j = (-(c(21)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(74),h0tab(:,74),[16,2,1,8,4],[nMW,nMB,nMW,nMW,nMW],5,0)
  call Hloop_VV_S(ntryL,G0H32(1),ex5(:),G0H16(25),m3h2x16(:,74),heltab2x32(:,:,74))
  Gcoeff(:)%j = (-(c(21)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(75),h0tab(:,75),[16,2,1,8,4],[nMW,nMB,nMW,nMW,nMW],5,0)
  call Hloop_SV_T(ntryL,G0H32(1),0,ex5(:),16,G1H16(50),m3h2x16(:,75),heltab2x32(:,:,75))
  Gcoeff(:)%j = (-(c(21)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(76),h0tab(:,76),[16,2,1,8,4],[nMW,nMB,nMW,nMW,nMW],5,0)
  call Hloop_SV_V(ntryL,G0H32(1),ex5(:),G0H16(26),m3h2x16(:,76),heltab2x32(:,:,76))
  Gcoeff(:)%j = (c(21)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(77),h0tab(:,77),[16,2,1,8,4],[nMW,nMB,nMW,nMW,nMW],5,0)
  call Hloop_SV_T(ntryL,G0H32(1),0,ex5(:),16,G1H16(51),m3h2x16(:,77),heltab2x32(:,:,77))
  Gcoeff(:)%j = (-(c(21)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(78),h0tab(:,78),[16,2,1,8,4],[nMW,nMB,nMW,nMW,nMW],5,0)
  call Hloop_VV_S(ntryL,G0H32(1),ex5(:),G0H16(27),m3h2x16(:,78),heltab2x32(:,:,78))
  Gcoeff(:)%j = (-(c(21)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(79),h0tab(:,79),[16,2,1,8,4],[nMW,nMB,nMW,nMW,nMW],5,0)
  call Hloop_UW_V(ntryL,G0H32(1),0,ex5(:),16,G1H16(52),m3h2x16(:,79),heltab2x32(:,:,79))
  Gcoeff(:)%j = (c(48)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(80),h0tab(:,80),[16,2,1,8,4],[nMW,nMB,nMW,nMW,nMW],5,0)
  call Hloop_SV_V(ntryL,G0H32(1),ex5(:),G0H16(28),m3h2x16(:,80),heltab2x32(:,:,80))
  Gcoeff(:)%j = (-(c(48)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(81),h0tab(:,81),[16,2,1,8,4],[nMW,nMB,nMW,nMW,nMW],5,0)
  call Hloop_VV_S(ntryL,G0H32(1),ex5(:),G0H16(29),m3h2x16(:,81),heltab2x32(:,:,81))
  Gcoeff(:)%j = (c(21)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(82),h0tab(:,82),[16,2,1,8,4],[nMW,nMB,nMW,nMW,nMW],5,0)
  call Hloop_SV_T(ntryL,G0H32(1),0,ex5(:),16,G1H16(53),m3h2x16(:,82),heltab2x32(:,:,82))
  Gcoeff(:)%j = (-(c(48)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(83),h0tab(:,83),[16,2,1,8,4],[nMW,nMB,nMW,nMW,nMW],5,0)
  call Hloop_SV_V(ntryL,G0H32(1),ex5(:),G0H16(30),m3h2x16(:,83),heltab2x32(:,:,83))
  Gcoeff(:)%j = (-(c(21)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(84),h0tab(:,84),[16,2,1,8,4],[nMW,nMB,nMW,nMW,nMW],5,0)
  call Hloop_UW_V(ntryL,G0H32(1),0,ex5(:),16,G1H16(54),m3h2x16(:,84),heltab2x32(:,:,84))
  Gcoeff(:)%j = (c(21)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(85),h0tab(:,85),[16,2,1,8,4],[nMW,nMB,nMW,nMW,nMW],5,0)
  call Hloop_VV_S(ntryL,G0H32(1),ex5(:),G0H16(31),m3h2x16(:,85),heltab2x32(:,:,85))
  Gcoeff(:)%j = (-(c(48)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(86),h0tab(:,86),[16,2,1,8,4],[nMW,nMB,nMW,nMW,nMW],5,0)
  call Hloop_UW_V(ntryL,G0H32(1),0,ex5(:),16,G1H16(55),m3h2x16(:,86),heltab2x32(:,:,86))
  Gcoeff(:)%j = (-(c(48)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(87),h0tab(:,87),[16,2,1,8,4],[nMW,nMB,nMW,nMW,nMW],5,0)
  call Hloop_SV_V(ntryL,G0H32(1),ex5(:),G0H16(32),m3h2x16(:,87),heltab2x32(:,:,87))
  Gcoeff(:)%j = (c(21)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(88),h0tab(:,88),[16,2,1,8,4],[nMW,nMB,nMW,nMW,nMW],5,0)
  call Hloop_UW_V(ntryL,G0H32(1),0,ex5(:),16,G1H16(56),m3h2x16(:,88),heltab2x32(:,:,88))
  Gcoeff(:)%j = (-(c(45)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(89),h0tab(:,89),[16,1,2,4,8],[nMT,nMH,nMT,nMT,nMT],5,0)
  call Hloop_AV_Q(ntryL,G0H32(1),ex5(:),G0H16(33),m3h2x16(:,89),heltab2x32(:,:,89))
  call Hloop_A_Q(ntryL,G0H16(33),16,nMT,G1H16(57),n2h16(25))
  Gcoeff(:)%j = (c(45)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(90),h0tab(:,90),[16,1,2,4,8],[nMT,nMZ,nMT,nMT,nMT],5,0)
  call Hloop_AV_Q(ntryL,G0H32(1),ex5(:),G0H16(33),m3h2x16(:,90),heltab2x32(:,:,90))
  call Hloop_A_Q(ntryL,G0H16(33),16,nMT,G1H16(58),n2h16(26))
  Gcoeff(:)%j = (-(c(29)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(91),h0tab(:,91),[16,1,2,4,8],[nMB,nMW,nMB,nMB,nMB],5,0)
  call Hloop_AV_Q(ntryL,G0H32(1),ex5(:),G0H16(33),m3h2x16(:,91),heltab2x32(:,:,91))
  call Hloop_A_Q(ntryL,G0H16(33),16,nMB,G1H16(59),n2h16(27))
  Gcoeff(:)%j = (c(38)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(92),h0tab(:,92),[16,1,2,4,8],[nMW,nMB,nMW,nMW,nMW],5,0)
  call Hloop_TV_S(ntryL,G0H32(1),0,ex5(:),16,G1H16(60),m3h2x16(:,92),heltab2x32(:,:,92))
  Gcoeff(:)%j = (c(1)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(93),h0tab(:,93),[16,1,2,4,8],[nMT,0,nMT,nMT,nMT],5,0)
  call Hloop_AV_Q(ntryL,G0H32(1),ex5(:),G0H16(33),m3h2x16(:,93),heltab2x32(:,:,93))
  call Hloop_A_Q(ntryL,G0H16(33),16,nMT,G1H16(61),n2h16(28))
  Gcoeff(:)%j = (c(2)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(94),h0tab(:,94),[16,1,2,4,8],[nMT,nMZ,nMT,nMT,nMT],5,0)
  call Hloop_AV_Q(ntryL,G0H32(1),ex5(:),G0H16(33),m3h2x16(:,94),heltab2x32(:,:,94))
  call Hloop_A_Q(ntryL,G0H16(33),16,nMT,G1H16(62),n2h16(29))
  Gcoeff(:)%j = (-(c(12)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(95),h0tab(:,95),[16,1,2,4,8],[nMB,nMW,nMB,nMB,nMB],5,0)
  call Hloop_AV_Q(ntryL,G0H32(1),ex5(:),G0H16(33),m3h2x16(:,95),heltab2x32(:,:,95))
  call Hloop_A_Q(ntryL,G0H16(33),16,nMB,G1H16(63),n2h16(30))
  Gcoeff(:)%j = (-(c(21)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(96),h0tab(:,96),[16,1,2,4,8],[nMW,nMB,nMW,nMW,nMW],5,0)
  call Hloop_VV_S(ntryL,G0H32(1),ex5(:),G0H16(33),m3h2x16(:,96),heltab2x32(:,:,96))
  Gcoeff(:)%j = (-(c(21)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(97),h0tab(:,97),[16,1,2,4,8],[nMW,nMB,nMW,nMW,nMW],5,0)
  call Hloop_TV_S(ntryL,G0H32(1),0,ex5(:),16,G1H16(64),m3h2x16(:,97),heltab2x32(:,:,97))
  Gcoeff(:)%j = (-(c(21)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(98),h0tab(:,98),[16,1,2,4,8],[nMW,nMB,nMW,nMW,nMW],5,0)
  call Hloop_TV_S(ntryL,G0H32(1),0,ex5(:),16,G1H16(65),m3h2x16(:,98),heltab2x32(:,:,98))
  Gcoeff(:)%j = (c(21)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(99),h0tab(:,99),[16,1,2,4,8],[nMW,nMB,nMW,nMW,nMW],5,0)
  call Hloop_SV_V(ntryL,G0H32(1),ex5(:),G0H16(34),m3h2x16(:,99),heltab2x32(:,:,99))
  Gcoeff(:)%j = (-(c(21)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(100),h0tab(:,100),[16,1,2,4,8],[nMW,nMB,nMW,nMW,nMW],5,0)
  call Hloop_VV_S(ntryL,G0H32(1),ex5(:),G0H16(35),m3h2x16(:,100),heltab2x32(:,:,100))
  Gcoeff(:)%j = (c(48)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(101),h0tab(:,101),[16,1,2,4,8],[nMW,nMB,nMW,nMW,nMW],5,0)
  call Hloop_VV_S(ntryL,G0H32(1),ex5(:),G0H16(36),m3h2x16(:,101),heltab2x32(:,:,101))
  Gcoeff(:)%j = (-(c(21)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(102),h0tab(:,102),[16,1,2,4,8],[nMW,nMB,nMW,nMW,nMW],5,0)
  call Hloop_TV_S(ntryL,G0H32(1),0,ex5(:),16,G1H16(66),m3h2x16(:,102),heltab2x32(:,:,102))
  Gcoeff(:)%j = (c(21)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(103),h0tab(:,103),[16,1,2,4,8],[nMW,nMB,nMW,nMW,nMW],5,0)
  call Hloop_UV_W(ntryL,G0H32(1),0,ex5(:),16,G1H16(67),m3h2x16(:,103),heltab2x32(:,:,103))
  Gcoeff(:)%j = (-(c(48)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(104),h0tab(:,104),[16,1,2,4,8],[nMW,nMB,nMW,nMW,nMW],5,0)
  call Hloop_SV_V(ntryL,G0H32(1),ex5(:),G0H16(37),m3h2x16(:,104),heltab2x32(:,:,104))
  Gcoeff(:)%j = (-(c(48)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(105),h0tab(:,105),[16,1,2,4,8],[nMW,nMB,nMW,nMW,nMW],5,0)
  call Hloop_SV_V(ntryL,G0H32(1),ex5(:),G0H16(38),m3h2x16(:,105),heltab2x32(:,:,105))
  Gcoeff(:)%j = (-(c(21)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(106),h0tab(:,106),[16,1,2,4,8],[nMW,nMB,nMW,nMW,nMW],5,0)
  call Hloop_VV_S(ntryL,G0H32(1),ex5(:),G0H16(39),m3h2x16(:,106),heltab2x32(:,:,106))
  Gcoeff(:)%j = (c(21)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(107),h0tab(:,107),[16,1,2,4,8],[nMW,nMB,nMW,nMW,nMW],5,0)
  call Hloop_UV_W(ntryL,G0H32(1),0,ex5(:),16,G1H16(68),m3h2x16(:,107),heltab2x32(:,:,107))
  Gcoeff(:)%j = (-(c(48)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(108),h0tab(:,108),[16,1,2,4,8],[nMW,nMB,nMW,nMW,nMW],5,0)
  call Hloop_UV_W(ntryL,G0H32(1),0,ex5(:),16,G1H16(69),m3h2x16(:,108),heltab2x32(:,:,108))
  Gcoeff(:)%j = (-(c(48)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(109),h0tab(:,109),[16,1,2,4,8],[nMW,nMB,nMW,nMW,nMW],5,0)
  call Hloop_SV_V(ntryL,G0H32(1),ex5(:),G0H16(40),m3h2x16(:,109),heltab2x32(:,:,109))
  Gcoeff(:)%j = (c(21)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(110),h0tab(:,110),[16,1,2,4,8],[nMW,nMB,nMW,nMW,nMW],5,0)
  call Hloop_UV_W(ntryL,G0H32(1),0,ex5(:),16,G1H16(70),m3h2x16(:,110),heltab2x32(:,:,110))
  Gcoeff(:)%j = (-(c(45)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(111),h0tab(:,111),[16,1,2,8,4],[nMT,nMH,nMT,nMT,nMT],5,0)
  call Hloop_AV_Q(ntryL,G0H32(1),ex5(:),G0H16(41),m3h2x16(:,111),heltab2x32(:,:,111))
  call Hloop_A_Q(ntryL,G0H16(41),16,nMT,G1H16(71),n2h16(31))
  Gcoeff(:)%j = (c(45)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(112),h0tab(:,112),[16,1,2,8,4],[nMT,nMZ,nMT,nMT,nMT],5,0)
  call Hloop_AV_Q(ntryL,G0H32(1),ex5(:),G0H16(41),m3h2x16(:,112),heltab2x32(:,:,112))
  call Hloop_A_Q(ntryL,G0H16(41),16,nMT,G1H16(72),n2h16(32))
  Gcoeff(:)%j = (-(c(29)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(113),h0tab(:,113),[16,1,2,8,4],[nMB,nMW,nMB,nMB,nMB],5,0)
  call Hloop_AV_Q(ntryL,G0H32(1),ex5(:),G0H16(41),m3h2x16(:,113),heltab2x32(:,:,113))
  call Hloop_A_Q(ntryL,G0H16(41),16,nMB,G1H16(73),n2h16(33))
  Gcoeff(:)%j = (c(38)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(114),h0tab(:,114),[16,1,2,8,4],[nMW,nMB,nMW,nMW,nMW],5,0)
  call Hloop_TV_S(ntryL,G0H32(1),0,ex5(:),16,G1H16(74),m3h2x16(:,114),heltab2x32(:,:,114))
  Gcoeff(:)%j = (c(1)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(115),h0tab(:,115),[16,1,2,8,4],[nMT,0,nMT,nMT,nMT],5,0)
  call Hloop_AV_Q(ntryL,G0H32(1),ex5(:),G0H16(41),m3h2x16(:,115),heltab2x32(:,:,115))
  call Hloop_A_Q(ntryL,G0H16(41),16,nMT,G1H16(75),n2h16(34))
  Gcoeff(:)%j = (c(2)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(116),h0tab(:,116),[16,1,2,8,4],[nMT,nMZ,nMT,nMT,nMT],5,0)
  call Hloop_AV_Q(ntryL,G0H32(1),ex5(:),G0H16(41),m3h2x16(:,116),heltab2x32(:,:,116))
  call Hloop_A_Q(ntryL,G0H16(41),16,nMT,G1H16(76),n2h16(35))
  Gcoeff(:)%j = (-(c(12)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(117),h0tab(:,117),[16,1,2,8,4],[nMB,nMW,nMB,nMB,nMB],5,0)
  call Hloop_AV_Q(ntryL,G0H32(1),ex5(:),G0H16(41),m3h2x16(:,117),heltab2x32(:,:,117))
  call Hloop_A_Q(ntryL,G0H16(41),16,nMB,G1H16(77),n2h16(36))
  Gcoeff(:)%j = (-(c(21)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(118),h0tab(:,118),[16,1,2,8,4],[nMW,nMB,nMW,nMW,nMW],5,0)
  call Hloop_VV_S(ntryL,G0H32(1),ex5(:),G0H16(41),m3h2x16(:,118),heltab2x32(:,:,118))
  Gcoeff(:)%j = (-(c(21)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(119),h0tab(:,119),[16,1,2,8,4],[nMW,nMB,nMW,nMW,nMW],5,0)
  call Hloop_TV_S(ntryL,G0H32(1),0,ex5(:),16,G1H16(78),m3h2x16(:,119),heltab2x32(:,:,119))
  Gcoeff(:)%j = (-(c(21)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(120),h0tab(:,120),[16,1,2,8,4],[nMW,nMB,nMW,nMW,nMW],5,0)
  call Hloop_TV_S(ntryL,G0H32(1),0,ex5(:),16,G1H16(79),m3h2x16(:,120),heltab2x32(:,:,120))
  Gcoeff(:)%j = (c(21)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(121),h0tab(:,121),[16,1,2,8,4],[nMW,nMB,nMW,nMW,nMW],5,0)
  call Hloop_SV_V(ntryL,G0H32(1),ex5(:),G0H16(42),m3h2x16(:,121),heltab2x32(:,:,121))
  Gcoeff(:)%j = (-(c(21)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(122),h0tab(:,122),[16,1,2,8,4],[nMW,nMB,nMW,nMW,nMW],5,0)
  call Hloop_VV_S(ntryL,G0H32(1),ex5(:),G0H16(43),m3h2x16(:,122),heltab2x32(:,:,122))
  Gcoeff(:)%j = (c(48)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(123),h0tab(:,123),[16,1,2,8,4],[nMW,nMB,nMW,nMW,nMW],5,0)
  call Hloop_VV_S(ntryL,G0H32(1),ex5(:),G0H16(44),m3h2x16(:,123),heltab2x32(:,:,123))
  Gcoeff(:)%j = (-(c(21)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(124),h0tab(:,124),[16,1,2,8,4],[nMW,nMB,nMW,nMW,nMW],5,0)
  call Hloop_TV_S(ntryL,G0H32(1),0,ex5(:),16,G1H16(80),m3h2x16(:,124),heltab2x32(:,:,124))
  Gcoeff(:)%j = (c(21)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(125),h0tab(:,125),[16,1,2,8,4],[nMW,nMB,nMW,nMW,nMW],5,0)
  call Hloop_UV_W(ntryL,G0H32(1),0,ex5(:),16,G1H16(81),m3h2x16(:,125),heltab2x32(:,:,125))
  Gcoeff(:)%j = (-(c(48)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(126),h0tab(:,126),[16,1,2,8,4],[nMW,nMB,nMW,nMW,nMW],5,0)
  call Hloop_SV_V(ntryL,G0H32(1),ex5(:),G0H16(45),m3h2x16(:,126),heltab2x32(:,:,126))
  Gcoeff(:)%j = (-(c(48)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(127),h0tab(:,127),[16,1,2,8,4],[nMW,nMB,nMW,nMW,nMW],5,0)
  call Hloop_SV_V(ntryL,G0H32(1),ex5(:),G0H16(46),m3h2x16(:,127),heltab2x32(:,:,127))
  Gcoeff(:)%j = (-(c(21)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(128),h0tab(:,128),[16,1,2,8,4],[nMW,nMB,nMW,nMW,nMW],5,0)
  call Hloop_VV_S(ntryL,G0H32(1),ex5(:),G0H16(47),m3h2x16(:,128),heltab2x32(:,:,128))
  Gcoeff(:)%j = (c(21)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(129),h0tab(:,129),[16,1,2,8,4],[nMW,nMB,nMW,nMW,nMW],5,0)
  call Hloop_UV_W(ntryL,G0H32(1),0,ex5(:),16,G1H16(82),m3h2x16(:,129),heltab2x32(:,:,129))
  Gcoeff(:)%j = (-(c(48)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(130),h0tab(:,130),[16,1,2,8,4],[nMW,nMB,nMW,nMW,nMW],5,0)
  call Hloop_UV_W(ntryL,G0H32(1),0,ex5(:),16,G1H16(83),m3h2x16(:,130),heltab2x32(:,:,130))
  Gcoeff(:)%j = (-(c(48)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(131),h0tab(:,131),[16,1,2,8,4],[nMW,nMB,nMW,nMW,nMW],5,0)
  call Hloop_SV_V(ntryL,G0H32(1),ex5(:),G0H16(48),m3h2x16(:,131),heltab2x32(:,:,131))
  Gcoeff(:)%j = (c(21)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(132),h0tab(:,132),[16,1,2,8,4],[nMW,nMB,nMW,nMW,nMW],5,0)
  call Hloop_UV_W(ntryL,G0H32(1),0,ex5(:),16,G1H16(84),m3h2x16(:,132),heltab2x32(:,:,132))
  Gcoeff(:)%j = (c(31)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(133),h0tab(:,133),[16,2,4,1,8],[nMB,nMW,nMW,nMB,nMB],5,0)
  call Hloop_QV_A(ntryL,G0H32(1),ex5(:),G0H16(49),m3h2x16(:,133),heltab2x32(:,:,133))
  call Hloop_Q_A(ntryL,G0H16(49),16,nMB,G1H16(85),n2h16(37))
  Gcoeff(:)%j = (-(c(35)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(134),h0tab(:,134),[16,2,4,1,8],[nMW,nMB,nMB,nMW,nMW],5,0)
  call Hloop_SV_T(ntryL,G0H32(1),0,ex5(:),16,G1H16(86),m3h2x16(:,134),heltab2x32(:,:,134))
  Gcoeff(:)%j = (-(c(14)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(135),h0tab(:,135),[16,2,4,1,8],[nMB,nMW,nMW,nMB,nMB],5,0)
  call Hloop_QV_A(ntryL,G0H32(1),ex5(:),G0H16(49),m3h2x16(:,135),heltab2x32(:,:,135))
  call Hloop_Q_A(ntryL,G0H16(49),16,nMB,G1H16(87),n2h16(38))
  Gcoeff(:)%j = (c(14)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(136),h0tab(:,136),[16,2,4,1,8],[nMB,nMW,nMW,nMB,nMB],5,0)
  call Hloop_QV_A(ntryL,G0H32(1),ex5(:),G0H16(49),m3h2x16(:,136),heltab2x32(:,:,136))
  call Hloop_Q_A(ntryL,G0H16(49),16,nMB,G1H16(88),n2h16(39))
  Gcoeff(:)%j = (c(18)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(137),h0tab(:,137),[16,2,4,1,8],[nMW,nMB,nMB,nMW,nMW],5,0)
  call Hloop_VV_S(ntryL,G0H32(1),ex5(:),G0H16(49),m3h2x16(:,137),heltab2x32(:,:,137))
  Gcoeff(:)%j = (c(18)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(138),h0tab(:,138),[16,2,4,1,8],[nMW,nMB,nMB,nMW,nMW],5,0)
  call Hloop_SV_V(ntryL,G0H32(1),ex5(:),G0H16(50),m3h2x16(:,138),heltab2x32(:,:,138))
  Gcoeff(:)%j = (-(c(18)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(139),h0tab(:,139),[16,2,4,1,8],[nMW,nMB,nMB,nMW,nMW],5,0)
  call Hloop_SV_T(ntryL,G0H32(1),0,ex5(:),16,G1H16(89),m3h2x16(:,139),heltab2x32(:,:,139))
  Gcoeff(:)%j = (c(14)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(140),h0tab(:,140),[16,2,4,1,8],[nMB,nMW,nMW,nMB,nMB],5,0)
  call Hloop_QV_A(ntryL,G0H32(1),ex5(:),G0H16(51),m3h2x16(:,140),heltab2x32(:,:,140))
  call Hloop_Q_A(ntryL,G0H16(51),16,nMB,G1H16(90),n2h16(40))
  Gcoeff(:)%j = (c(18)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(141),h0tab(:,141),[16,2,4,1,8],[nMW,nMB,nMB,nMW,nMW],5,0)
  call Hloop_UW_V(ntryL,G0H32(1),0,ex5(:),16,G1H16(91),m3h2x16(:,141),heltab2x32(:,:,141))
  Gcoeff(:)%j = (-(c(18)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(142),h0tab(:,142),[16,2,4,1,8],[nMW,nMB,nMB,nMW,nMW],5,0)
  call Hloop_VV_S(ntryL,G0H32(1),ex5(:),G0H16(51),m3h2x16(:,142),heltab2x32(:,:,142))
  Gcoeff(:)%j = (c(46)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(143),h0tab(:,143),[16,2,4,1,8],[nMW,nMB,nMB,nMW,nMW],5,0)
  call Hloop_SV_V(ntryL,G0H32(1),ex5(:),G0H16(52),m3h2x16(:,143),heltab2x32(:,:,143))
  Gcoeff(:)%j = (-(c(18)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(144),h0tab(:,144),[16,2,4,1,8],[nMW,nMB,nMB,nMW,nMW],5,0)
  call Hloop_UW_V(ntryL,G0H32(1),0,ex5(:),16,G1H16(92),m3h2x16(:,144),heltab2x32(:,:,144))
  Gcoeff(:)%j = (c(31)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(145),h0tab(:,145),[16,2,8,1,4],[nMB,nMW,nMW,nMB,nMB],5,0)
  call Hloop_QV_A(ntryL,G0H32(1),ex5(:),G0H16(53),m3h2x16(:,145),heltab2x32(:,:,145))
  call Hloop_Q_A(ntryL,G0H16(53),16,nMB,G1H16(93),n2h16(41))
  Gcoeff(:)%j = (-(c(35)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(146),h0tab(:,146),[16,2,8,1,4],[nMW,nMB,nMB,nMW,nMW],5,0)
  call Hloop_SV_T(ntryL,G0H32(1),0,ex5(:),16,G1H16(94),m3h2x16(:,146),heltab2x32(:,:,146))
  Gcoeff(:)%j = (-(c(14)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(147),h0tab(:,147),[16,2,8,1,4],[nMB,nMW,nMW,nMB,nMB],5,0)
  call Hloop_QV_A(ntryL,G0H32(1),ex5(:),G0H16(53),m3h2x16(:,147),heltab2x32(:,:,147))
  call Hloop_Q_A(ntryL,G0H16(53),16,nMB,G1H16(95),n2h16(42))
  Gcoeff(:)%j = (c(14)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(148),h0tab(:,148),[16,2,8,1,4],[nMB,nMW,nMW,nMB,nMB],5,0)
  call Hloop_QV_A(ntryL,G0H32(1),ex5(:),G0H16(53),m3h2x16(:,148),heltab2x32(:,:,148))
  call Hloop_Q_A(ntryL,G0H16(53),16,nMB,G1H16(96),n2h16(43))
  Gcoeff(:)%j = (c(18)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(149),h0tab(:,149),[16,2,8,1,4],[nMW,nMB,nMB,nMW,nMW],5,0)
  call Hloop_VV_S(ntryL,G0H32(1),ex5(:),G0H16(53),m3h2x16(:,149),heltab2x32(:,:,149))
  Gcoeff(:)%j = (c(18)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(150),h0tab(:,150),[16,2,8,1,4],[nMW,nMB,nMB,nMW,nMW],5,0)
  call Hloop_SV_V(ntryL,G0H32(1),ex5(:),G0H16(54),m3h2x16(:,150),heltab2x32(:,:,150))
  Gcoeff(:)%j = (-(c(18)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(151),h0tab(:,151),[16,2,8,1,4],[nMW,nMB,nMB,nMW,nMW],5,0)
  call Hloop_SV_T(ntryL,G0H32(1),0,ex5(:),16,G1H16(97),m3h2x16(:,151),heltab2x32(:,:,151))
  Gcoeff(:)%j = (c(14)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(152),h0tab(:,152),[16,2,8,1,4],[nMB,nMW,nMW,nMB,nMB],5,0)
  call Hloop_QV_A(ntryL,G0H32(1),ex5(:),G0H16(55),m3h2x16(:,152),heltab2x32(:,:,152))
  call Hloop_Q_A(ntryL,G0H16(55),16,nMB,G1H16(98),n2h16(44))
  Gcoeff(:)%j = (c(18)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(153),h0tab(:,153),[16,2,8,1,4],[nMW,nMB,nMB,nMW,nMW],5,0)
  call Hloop_UW_V(ntryL,G0H32(1),0,ex5(:),16,G1H16(99),m3h2x16(:,153),heltab2x32(:,:,153))
  Gcoeff(:)%j = (-(c(18)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(154),h0tab(:,154),[16,2,8,1,4],[nMW,nMB,nMB,nMW,nMW],5,0)
  call Hloop_VV_S(ntryL,G0H32(1),ex5(:),G0H16(55),m3h2x16(:,154),heltab2x32(:,:,154))
  Gcoeff(:)%j = (c(46)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(155),h0tab(:,155),[16,2,8,1,4],[nMW,nMB,nMB,nMW,nMW],5,0)
  call Hloop_SV_V(ntryL,G0H32(1),ex5(:),G0H16(56),m3h2x16(:,155),heltab2x32(:,:,155))
  Gcoeff(:)%j = (-(c(18)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(156),h0tab(:,156),[16,2,8,1,4],[nMW,nMB,nMB,nMW,nMW],5,0)
  call Hloop_UW_V(ntryL,G0H32(1),0,ex5(:),16,G1H16(100),m3h2x16(:,156),heltab2x32(:,:,156))
  Gcoeff(:)%j = (c(31)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(157),h0tab(:,157),[16,1,4,2,8],[nMB,nMW,nMW,nMB,nMB],5,0)
  call Hloop_AV_Q(ntryL,G0H32(1),ex5(:),G0H16(57),m3h2x16(:,157),heltab2x32(:,:,157))
  call Hloop_A_Q(ntryL,G0H16(57),16,nMB,G1H16(101),n2h16(45))
  Gcoeff(:)%j = (-(c(35)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(158),h0tab(:,158),[16,1,4,2,8],[nMW,nMB,nMB,nMW,nMW],5,0)
  call Hloop_TV_S(ntryL,G0H32(1),0,ex5(:),16,G1H16(102),m3h2x16(:,158),heltab2x32(:,:,158))
  Gcoeff(:)%j = (-(c(14)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(159),h0tab(:,159),[16,1,4,2,8],[nMB,nMW,nMW,nMB,nMB],5,0)
  call Hloop_AV_Q(ntryL,G0H32(1),ex5(:),G0H16(57),m3h2x16(:,159),heltab2x32(:,:,159))
  call Hloop_A_Q(ntryL,G0H16(57),16,nMB,G1H16(103),n2h16(46))
  Gcoeff(:)%j = (c(14)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(160),h0tab(:,160),[16,1,4,2,8],[nMB,nMW,nMW,nMB,nMB],5,0)
  call Hloop_AV_Q(ntryL,G0H32(1),ex5(:),G0H16(57),m3h2x16(:,160),heltab2x32(:,:,160))
  call Hloop_A_Q(ntryL,G0H16(57),16,nMB,G1H16(104),n2h16(47))
  Gcoeff(:)%j = (c(18)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(161),h0tab(:,161),[16,1,4,2,8],[nMW,nMB,nMB,nMW,nMW],5,0)
  call Hloop_VV_S(ntryL,G0H32(1),ex5(:),G0H16(57),m3h2x16(:,161),heltab2x32(:,:,161))
  Gcoeff(:)%j = (c(18)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(162),h0tab(:,162),[16,1,4,2,8],[nMW,nMB,nMB,nMW,nMW],5,0)
  call Hloop_TV_S(ntryL,G0H32(1),0,ex5(:),16,G1H16(105),m3h2x16(:,162),heltab2x32(:,:,162))
  Gcoeff(:)%j = (-(c(18)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(163),h0tab(:,163),[16,1,4,2,8],[nMW,nMB,nMB,nMW,nMW],5,0)
  call Hloop_SV_V(ntryL,G0H32(1),ex5(:),G0H16(58),m3h2x16(:,163),heltab2x32(:,:,163))
  Gcoeff(:)%j = (c(14)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(164),h0tab(:,164),[16,1,4,2,8],[nMB,nMW,nMW,nMB,nMB],5,0)
  call Hloop_AV_Q(ntryL,G0H32(1),ex5(:),G0H16(59),m3h2x16(:,164),heltab2x32(:,:,164))
  call Hloop_A_Q(ntryL,G0H16(59),16,nMB,G1H16(106),n2h16(48))
  Gcoeff(:)%j = (c(18)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(165),h0tab(:,165),[16,1,4,2,8],[nMW,nMB,nMB,nMW,nMW],5,0)
  call Hloop_VV_S(ntryL,G0H32(1),ex5(:),G0H16(59),m3h2x16(:,165),heltab2x32(:,:,165))
  Gcoeff(:)%j = (-(c(18)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(166),h0tab(:,166),[16,1,4,2,8],[nMW,nMB,nMB,nMW,nMW],5,0)
  call Hloop_UV_W(ntryL,G0H32(1),0,ex5(:),16,G1H16(107),m3h2x16(:,166),heltab2x32(:,:,166))
  Gcoeff(:)%j = (c(46)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(167),h0tab(:,167),[16,1,4,2,8],[nMW,nMB,nMB,nMW,nMW],5,0)
  call Hloop_SV_V(ntryL,G0H32(1),ex5(:),G0H16(60),m3h2x16(:,167),heltab2x32(:,:,167))
  Gcoeff(:)%j = (-(c(18)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(168),h0tab(:,168),[16,1,4,2,8],[nMW,nMB,nMB,nMW,nMW],5,0)
  call Hloop_UV_W(ntryL,G0H32(1),0,ex5(:),16,G1H16(108),m3h2x16(:,168),heltab2x32(:,:,168))
  Gcoeff(:)%j = (c(31)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(169),h0tab(:,169),[16,1,4,8,2],[nMW,nMB,nMB,nMB,nMW],5,0)
  call Hloop_TV_S(ntryL,G0H32(1),0,ex5(:),16,G1H16(109),m3h2x16(:,169),heltab2x32(:,:,169))
  Gcoeff(:)%j = (-(c(35)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(170),h0tab(:,170),[16,1,4,8,2],[nMB,nMW,nMW,nMW,nMB],5,0)
  call Hloop_AV_Q(ntryL,G0H32(1),ex5(:),G0H16(61),m3h2x16(:,170),heltab2x32(:,:,170))
  call Hloop_A_Q(ntryL,G0H16(61),16,nMB,G1H16(110),n2h16(49))
  Gcoeff(:)%j = (-(c(14)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(171),h0tab(:,171),[16,1,4,8,2],[nMW,nMB,nMB,nMB,nMW],5,0)
  call Hloop_VV_S(ntryL,G0H32(1),ex5(:),G0H16(61),m3h2x16(:,171),heltab2x32(:,:,171))
  Gcoeff(:)%j = (c(14)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(172),h0tab(:,172),[16,1,4,8,2],[nMW,nMB,nMB,nMB,nMW],5,0)
  call Hloop_SV_V(ntryL,G0H32(1),ex5(:),G0H16(62),m3h2x16(:,172),heltab2x32(:,:,172))
  Gcoeff(:)%j = (c(18)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(173),h0tab(:,173),[16,1,4,8,2],[nMB,nMW,nMW,nMW,nMB],5,0)
  call Hloop_AV_Q(ntryL,G0H32(1),ex5(:),G0H16(63),m3h2x16(:,173),heltab2x32(:,:,173))
  call Hloop_A_Q(ntryL,G0H16(63),16,nMB,G1H16(111),n2h16(50))
  Gcoeff(:)%j = (c(18)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(174),h0tab(:,174),[16,1,4,8,2],[nMB,nMW,nMW,nMW,nMB],5,0)
  call Hloop_AV_Q(ntryL,G0H32(1),ex5(:),G0H16(63),m3h2x16(:,174),heltab2x32(:,:,174))
  call Hloop_A_Q(ntryL,G0H16(63),16,nMB,G1H16(112),n2h16(51))
  Gcoeff(:)%j = (-(c(18)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(175),h0tab(:,175),[16,1,4,8,2],[nMB,nMW,nMW,nMW,nMB],5,0)
  call Hloop_AV_Q(ntryL,G0H32(1),ex5(:),G0H16(63),m3h2x16(:,175),heltab2x32(:,:,175))
  call Hloop_A_Q(ntryL,G0H16(63),16,nMB,G1H16(113),n2h16(52))
  Gcoeff(:)%j = (c(14)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(176),h0tab(:,176),[16,1,4,8,2],[nMW,nMB,nMB,nMB,nMW],5,0)
  call Hloop_UV_W(ntryL,G0H32(1),0,ex5(:),16,G1H16(114),m3h2x16(:,176),heltab2x32(:,:,176))
  Gcoeff(:)%j = (c(18)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(177),h0tab(:,177),[16,1,4,8,2],[nMB,nMW,nMW,nMW,nMB],5,0)
  call Hloop_AV_Q(ntryL,G0H32(1),ex5(:),G0H16(63),m3h2x16(:,177),heltab2x32(:,:,177))
  call Hloop_A_Q(ntryL,G0H16(63),16,nMB,G1H16(115),n2h16(53))
  Gcoeff(:)%j = (-(c(18)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(178),h0tab(:,178),[16,1,4,8,2],[nMB,nMW,nMW,nMW,nMB],5,0)
  call Hloop_AV_Q(ntryL,G0H32(1),ex5(:),G0H16(63),m3h2x16(:,178),heltab2x32(:,:,178))
  call Hloop_A_Q(ntryL,G0H16(63),16,nMB,G1H16(116),n2h16(54))
  Gcoeff(:)%j = (c(46)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(179),h0tab(:,179),[16,1,4,8,2],[nMB,nMW,nMW,nMW,nMB],5,0)
  call Hloop_AV_Q(ntryL,G0H32(1),ex5(:),G0H16(63),m3h2x16(:,179),heltab2x32(:,:,179))
  call Hloop_A_Q(ntryL,G0H16(63),16,nMB,G1H16(117),n2h16(55))
  Gcoeff(:)%j = (-(c(18)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(180),h0tab(:,180),[16,1,4,8,2],[nMB,nMW,nMW,nMW,nMB],5,0)
  call Hloop_AV_Q(ntryL,G0H32(1),ex5(:),G0H16(63),m3h2x16(:,180),heltab2x32(:,:,180))
  call Hloop_A_Q(ntryL,G0H16(63),16,nMB,G1H16(118),n2h16(56))
  Gcoeff(:)%j = (c(31)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(181),h0tab(:,181),[16,1,8,2,4],[nMB,nMW,nMW,nMB,nMB],5,0)
  call Hloop_AV_Q(ntryL,G0H32(1),ex5(:),G0H16(63),m3h2x16(:,181),heltab2x32(:,:,181))
  call Hloop_A_Q(ntryL,G0H16(63),16,nMB,G1H16(119),n2h16(57))
  Gcoeff(:)%j = (-(c(35)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(182),h0tab(:,182),[16,1,8,2,4],[nMW,nMB,nMB,nMW,nMW],5,0)
  call Hloop_TV_S(ntryL,G0H32(1),0,ex5(:),16,G1H16(120),m3h2x16(:,182),heltab2x32(:,:,182))
  Gcoeff(:)%j = (-(c(14)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(183),h0tab(:,183),[16,1,8,2,4],[nMB,nMW,nMW,nMB,nMB],5,0)
  call Hloop_AV_Q(ntryL,G0H32(1),ex5(:),G0H16(63),m3h2x16(:,183),heltab2x32(:,:,183))
  call Hloop_A_Q(ntryL,G0H16(63),16,nMB,G1H16(121),n2h16(58))
  Gcoeff(:)%j = (c(14)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(184),h0tab(:,184),[16,1,8,2,4],[nMB,nMW,nMW,nMB,nMB],5,0)
  call Hloop_AV_Q(ntryL,G0H32(1),ex5(:),G0H16(63),m3h2x16(:,184),heltab2x32(:,:,184))
  call Hloop_A_Q(ntryL,G0H16(63),16,nMB,G1H16(122),n2h16(59))
  Gcoeff(:)%j = (c(18)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(185),h0tab(:,185),[16,1,8,2,4],[nMW,nMB,nMB,nMW,nMW],5,0)
  call Hloop_VV_S(ntryL,G0H32(1),ex5(:),G0H16(63),m3h2x16(:,185),heltab2x32(:,:,185))
  Gcoeff(:)%j = (c(18)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(186),h0tab(:,186),[16,1,8,2,4],[nMW,nMB,nMB,nMW,nMW],5,0)
  call Hloop_TV_S(ntryL,G0H32(1),0,ex5(:),16,G1H16(123),m3h2x16(:,186),heltab2x32(:,:,186))
  Gcoeff(:)%j = (-(c(18)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(187),h0tab(:,187),[16,1,8,2,4],[nMW,nMB,nMB,nMW,nMW],5,0)
  call Hloop_SV_V(ntryL,G0H32(1),ex5(:),G0H16(64),m3h2x16(:,187),heltab2x32(:,:,187))
  Gcoeff(:)%j = (c(14)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(188),h0tab(:,188),[16,1,8,2,4],[nMB,nMW,nMW,nMB,nMB],5,0)
  call Hloop_AV_Q(ntryL,G0H32(1),ex5(:),G0H16(65),m3h2x16(:,188),heltab2x32(:,:,188))
  call Hloop_A_Q(ntryL,G0H16(65),16,nMB,G1H16(124),n2h16(60))
  Gcoeff(:)%j = (c(18)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(189),h0tab(:,189),[16,1,8,2,4],[nMW,nMB,nMB,nMW,nMW],5,0)
  call Hloop_VV_S(ntryL,G0H32(1),ex5(:),G0H16(65),m3h2x16(:,189),heltab2x32(:,:,189))
  Gcoeff(:)%j = (-(c(18)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(190),h0tab(:,190),[16,1,8,2,4],[nMW,nMB,nMB,nMW,nMW],5,0)
  call Hloop_UV_W(ntryL,G0H32(1),0,ex5(:),16,G1H16(125),m3h2x16(:,190),heltab2x32(:,:,190))
  Gcoeff(:)%j = (c(46)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(191),h0tab(:,191),[16,1,8,2,4],[nMW,nMB,nMB,nMW,nMW],5,0)
  call Hloop_SV_V(ntryL,G0H32(1),ex5(:),G0H16(66),m3h2x16(:,191),heltab2x32(:,:,191))
  Gcoeff(:)%j = (-(c(18)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(192),h0tab(:,192),[16,1,8,2,4],[nMW,nMB,nMB,nMW,nMW],5,0)
  call Hloop_UV_W(ntryL,G0H32(1),0,ex5(:),16,G1H16(126),m3h2x16(:,192),heltab2x32(:,:,192))
  Gcoeff(:)%j = (c(31)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(193),h0tab(:,193),[16,1,8,4,2],[nMW,nMB,nMB,nMB,nMW],5,0)
  call Hloop_TV_S(ntryL,G0H32(1),0,ex5(:),16,G1H16(127),m3h2x16(:,193),heltab2x32(:,:,193))
  Gcoeff(:)%j = (-(c(35)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(194),h0tab(:,194),[16,1,8,4,2],[nMB,nMW,nMW,nMW,nMB],5,0)
  call Hloop_AV_Q(ntryL,G0H32(1),ex5(:),G0H16(67),m3h2x16(:,194),heltab2x32(:,:,194))
  call Hloop_A_Q(ntryL,G0H16(67),16,nMB,G1H16(128),n2h16(61))
  Gcoeff(:)%j = (-(c(14)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(195),h0tab(:,195),[16,1,8,4,2],[nMW,nMB,nMB,nMB,nMW],5,0)
  call Hloop_VV_S(ntryL,G0H32(1),ex5(:),G0H16(67),m3h2x16(:,195),heltab2x32(:,:,195))
  Gcoeff(:)%j = (c(14)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(196),h0tab(:,196),[16,1,8,4,2],[nMW,nMB,nMB,nMB,nMW],5,0)
  call Hloop_SV_V(ntryL,G0H32(1),ex5(:),G0H16(68),m3h2x16(:,196),heltab2x32(:,:,196))
  Gcoeff(:)%j = (c(18)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(197),h0tab(:,197),[16,1,8,4,2],[nMB,nMW,nMW,nMW,nMB],5,0)
  call Hloop_AV_Q(ntryL,G0H32(1),ex5(:),G0H16(69),m3h2x16(:,197),heltab2x32(:,:,197))
  call Hloop_A_Q(ntryL,G0H16(69),16,nMB,G1H16(129),n2h16(62))
  Gcoeff(:)%j = (c(18)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(198),h0tab(:,198),[16,1,8,4,2],[nMB,nMW,nMW,nMW,nMB],5,0)
  call Hloop_AV_Q(ntryL,G0H32(1),ex5(:),G0H16(69),m3h2x16(:,198),heltab2x32(:,:,198))
  call Hloop_A_Q(ntryL,G0H16(69),16,nMB,G1H16(130),n2h16(63))
  Gcoeff(:)%j = (-(c(18)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(199),h0tab(:,199),[16,1,8,4,2],[nMB,nMW,nMW,nMW,nMB],5,0)
  call Hloop_AV_Q(ntryL,G0H32(1),ex5(:),G0H16(69),m3h2x16(:,199),heltab2x32(:,:,199))
  call Hloop_A_Q(ntryL,G0H16(69),16,nMB,G1H16(131),n2h16(64))
  Gcoeff(:)%j = (c(14)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(200),h0tab(:,200),[16,1,8,4,2],[nMW,nMB,nMB,nMB,nMW],5,0)
  call Hloop_UV_W(ntryL,G0H32(1),0,ex5(:),16,G1H16(132),m3h2x16(:,200),heltab2x32(:,:,200))
  Gcoeff(:)%j = (c(18)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(201),h0tab(:,201),[16,1,8,4,2],[nMB,nMW,nMW,nMW,nMB],5,0)
  call Hloop_AV_Q(ntryL,G0H32(1),ex5(:),G0H16(69),m3h2x16(:,201),heltab2x32(:,:,201))
  call Hloop_A_Q(ntryL,G0H16(69),16,nMB,G1H16(133),n2h16(65))
  Gcoeff(:)%j = (-(c(18)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(202),h0tab(:,202),[16,1,8,4,2],[nMB,nMW,nMW,nMW,nMB],5,0)
  call Hloop_AV_Q(ntryL,G0H32(1),ex5(:),G0H16(69),m3h2x16(:,202),heltab2x32(:,:,202))
  call Hloop_A_Q(ntryL,G0H16(69),16,nMB,G1H16(134),n2h16(66))
  Gcoeff(:)%j = (c(46)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(203),h0tab(:,203),[16,1,8,4,2],[nMB,nMW,nMW,nMW,nMB],5,0)
  call Hloop_AV_Q(ntryL,G0H32(1),ex5(:),G0H16(69),m3h2x16(:,203),heltab2x32(:,:,203))
  call Hloop_A_Q(ntryL,G0H16(69),16,nMB,G1H16(135),n2h16(67))
  Gcoeff(:)%j = (-(c(18)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(204),h0tab(:,204),[16,1,8,4,2],[nMB,nMW,nMW,nMW,nMB],5,0)
  call Hloop_AV_Q(ntryL,G0H32(1),ex5(:),G0H16(69),m3h2x16(:,204),heltab2x32(:,:,204))
  call Hloop_A_Q(ntryL,G0H16(69),16,nMB,G1H16(136),n2h16(68))
  call Hloop_AV_Q(ntryL,G1H16(1),ex3(:),G1H8(1),m3h2x8(:,1),heltab2x16(:,:,1))
  call Hloop_A_Q(ntryL,G1H8(1),20,nMT,G2H8(1),n2h8(1))
  call Hloop_AV_Q(ntryL,G1H16(2),ex3(:),G1H8(1),m3h2x8(:,2),heltab2x16(:,:,2))
  call Hloop_A_Q(ntryL,G1H8(1),20,nMT,G2H8(2),n2h8(2))
  call Hloop_AV_Q(ntryL,G1H16(3),ex3(:),G1H8(1),m3h2x8(:,3),heltab2x16(:,:,3))
  call Hloop_A_Q(ntryL,G1H8(1),20,nMB,G2H8(3),n2h8(3))
  call Hloop_TV_S(ntryL,G1H16(4),16,ex3(:),4,G2H8(4),m3h2x8(:,4),heltab2x16(:,:,4))
  call Hloop_AV_Q(ntryL,G1H16(5),ex3(:),G1H8(1),m3h2x8(:,5),heltab2x16(:,:,5))
  call Hloop_A_Q(ntryL,G1H8(1),20,nMT,G2H8(5),n2h8(4))
  call Hloop_AV_Q(ntryL,G1H16(6),ex3(:),G1H8(1),m3h2x8(:,6),heltab2x16(:,:,6))
  call Hloop_A_Q(ntryL,G1H8(1),20,nMT,G2H8(6),n2h8(5))
  call Hloop_AV_Q(ntryL,G1H16(7),ex3(:),G1H8(1),m3h2x8(:,7),heltab2x16(:,:,7))
  call Hloop_A_Q(ntryL,G1H8(1),20,nMB,G2H8(7),n2h8(6))
  call Hloop_TV_S(ntryL,G0H16(1),16,ex3(:),4,G1H8(1),m3h2x8(:,8),heltab2x16(:,:,8))
  call Hloop_VV_S(ntryL,G0H16(2),ex3(:),G0H8(1),m3h2x8(:,9),heltab2x16(:,:,9))
  call Hloop_TV_S(ntryL,G1H16(8),16,ex3(:),4,G2H8(8),m3h2x8(:,10),heltab2x16(:,:,10))
  call Hloop_SV_V(ntryL,G1H16(9),ex3(:),G1H8(2),m3h2x8(:,11),heltab2x16(:,:,11))
  call Hloop_VV_S(ntryL,G1H16(10),ex3(:),G1H8(3),m3h2x8(:,12),heltab2x16(:,:,12))
  call Hloop_TV_S(ntryL,G0H16(3),16,ex3(:),4,G1H8(4),m3h2x8(:,13),heltab2x16(:,:,13))
  call Hloop_VV_S(ntryL,G0H16(4),ex3(:),G0H8(2),m3h2x8(:,14),heltab2x16(:,:,14))
  call Hloop_SV_V(ntryL,G0H16(5),ex3(:),G0H8(3),m3h2x8(:,15),heltab2x16(:,:,15))
  call Hloop_UV_W(ntryL,G0H16(6),16,ex3(:),4,G1H8(5),m3h2x8(:,16),heltab2x16(:,:,16))
  call Hloop_SV_V(ntryL,G1H16(11),ex3(:),G1H8(6),m3h2x8(:,17),heltab2x16(:,:,17))
  call Hloop_VV_S(ntryL,G1H16(12),ex3(:),G1H8(7),m3h2x8(:,18),heltab2x16(:,:,18))
  call Hloop_UV_W(ntryL,G1H16(13),16,ex3(:),4,G2H8(9),m3h2x8(:,19),heltab2x16(:,:,19))
  call Hloop_SV_V(ntryL,G0H16(7),ex3(:),G0H8(4),m3h2x8(:,20),heltab2x16(:,:,20))
  call Hloop_UV_W(ntryL,G0H16(8),16,ex3(:),4,G1H8(8),m3h2x8(:,21),heltab2x16(:,:,21))
  call Hloop_UV_W(ntryL,G1H16(14),16,ex3(:),4,G2H8(10),m3h2x8(:,22),heltab2x16(:,:,22))
  call Hloop_QA_S(ntryL,G1H16(15),ex2(:),G1H8(9),ngH,m3h2x8(:,23),heltab2x16(:,:,23))
  call Hloop_QA_S(ntryL,G1H16(16),ex2(:),G1H8(10),ngX,m3h2x8(:,24),heltab2x16(:,:,24))
  call Hloop_QA_S(ntryL,G1H16(17),ex2(:),G1H8(11),ngPtb,m3h2x8(:,25),heltab2x16(:,:,25))
  call Hloop_SA_Q(ntryL,G1H16(18),ex2(:),G1H8(12),ngPtb,m3h2x8(:,26),heltab2x16(:,:,26))
  call Hloop_A_Q(ntryL,G1H8(12),18,nMB,G2H8(11),n2h8(7))
  call Hloop_QA_V(ntryL,G1H16(19),ex2(:),G1H8(12),m3h2x8(:,27),heltab2x16(:,:,27))
  call Hloop_QA_Z(ntryL,G1H16(20),ex2(:),G1H8(13),ngZu,m3h2x8(:,28),heltab2x16(:,:,28))
  call Hloop_QA_W(ntryL,G1H16(21),ex2(:),G1H8(14),m3h2x8(:,29),heltab2x16(:,:,29))
  call Hloop_SA_Q(ntryL,G0H16(9),ex2(:),G0H8(5),ngPtb,m3h2x8(:,30),heltab2x16(:,:,30))
  call Hloop_A_Q(ntryL,G0H8(5),18,nMB,G1H8(15),n2h8(8))
  call Hloop_SA_Q(ntryL,G1H16(22),ex2(:),G1H8(16),ngPtb,m3h2x8(:,31),heltab2x16(:,:,31))
  call Hloop_A_Q(ntryL,G1H8(16),18,nMB,G2H8(12),n2h8(9))
  call Hloop_WA_Q(ntryL,G0H16(10),ex2(:),G0H8(5),m3h2x8(:,32),heltab2x16(:,:,32))
  call Hloop_A_Q(ntryL,G0H8(5),18,nMB,G1H8(16),n2h8(10))
  call Hloop_SA_Q(ntryL,G1H16(23),ex2(:),G1H8(17),ngPtb,m3h2x8(:,33),heltab2x16(:,:,33))
  call Hloop_A_Q(ntryL,G1H8(17),18,nMB,G2H8(13),n2h8(11))
  call Hloop_SA_Q(ntryL,G0H16(11),ex2(:),G0H8(5),ngPtb,m3h2x8(:,34),heltab2x16(:,:,34))
  call Hloop_A_Q(ntryL,G0H8(5),18,nMB,G1H8(17),n2h8(12))
  call Hloop_WA_Q(ntryL,G1H16(24),ex2(:),G1H8(18),m3h2x8(:,35),heltab2x16(:,:,35))
  call Hloop_A_Q(ntryL,G1H8(18),18,nMB,G2H8(14),n2h8(13))
  call Hloop_WA_Q(ntryL,G0H16(12),ex2(:),G0H8(5),m3h2x8(:,36),heltab2x16(:,:,36))
  call Hloop_A_Q(ntryL,G0H8(5),18,nMB,G1H8(18),n2h8(14))
  call Hloop_SA_Q(ntryL,G0H16(13),ex2(:),G0H8(5),ngPtb,m3h2x8(:,37),heltab2x16(:,:,37))
  call Hloop_A_Q(ntryL,G0H8(5),18,nMB,G1H8(19),n2h8(15))
  call Hloop_SA_Q(ntryL,G1H16(25),ex2(:),G1H8(20),ngPtb,m3h2x8(:,38),heltab2x16(:,:,38))
  call Hloop_A_Q(ntryL,G1H8(20),18,nMB,G2H8(15),n2h8(16))
  call Hloop_WA_Q(ntryL,G0H16(14),ex2(:),G0H8(5),m3h2x8(:,39),heltab2x16(:,:,39))
  call Hloop_A_Q(ntryL,G0H8(5),18,nMB,G1H8(20),n2h8(17))
  call Hloop_WA_Q(ntryL,G1H16(26),ex2(:),G1H8(21),m3h2x8(:,40),heltab2x16(:,:,40))
  call Hloop_A_Q(ntryL,G1H8(21),18,nMB,G2H8(16),n2h8(18))
  call Hloop_SA_Q(ntryL,G0H16(15),ex2(:),G0H8(5),ngPtb,m3h2x8(:,41),heltab2x16(:,:,41))
  call Hloop_A_Q(ntryL,G0H8(5),18,nMB,G1H8(21),n2h8(19))
  call Hloop_WA_Q(ntryL,G1H16(27),ex2(:),G1H8(22),m3h2x8(:,42),heltab2x16(:,:,42))
  call Hloop_A_Q(ntryL,G1H8(22),18,nMB,G2H8(17),n2h8(20))
  call Hloop_WA_Q(ntryL,G0H16(16),ex2(:),G0H8(5),m3h2x8(:,43),heltab2x16(:,:,43))
  call Hloop_A_Q(ntryL,G0H8(5),18,nMB,G1H8(22),n2h8(21))
  call Hloop_WA_Q(ntryL,G1H16(28),ex2(:),G1H8(23),m3h2x8(:,44),heltab2x16(:,:,44))
  call Hloop_A_Q(ntryL,G1H8(23),18,nMB,G2H8(18),n2h8(22))
  call Hloop_QV_A(ntryL,G1H16(29),ex3(:),G1H8(23),m3h2x8(:,45),heltab2x16(:,:,45))
  call Hloop_Q_A(ntryL,G1H8(23),20,nMT,G2H8(19),n2h8(23))
  call Hloop_QV_A(ntryL,G1H16(30),ex3(:),G1H8(23),m3h2x8(:,46),heltab2x16(:,:,46))
  call Hloop_Q_A(ntryL,G1H8(23),20,nMT,G2H8(20),n2h8(24))
  call Hloop_QV_A(ntryL,G1H16(31),ex3(:),G1H8(23),m3h2x8(:,47),heltab2x16(:,:,47))
  call Hloop_Q_A(ntryL,G1H8(23),20,nMB,G2H8(21),n2h8(25))
  call Hloop_SV_T(ntryL,G1H16(32),16,ex3(:),4,G2H8(22),m3h2x8(:,48),heltab2x16(:,:,48))
  call Hloop_QV_A(ntryL,G1H16(33),ex3(:),G1H8(23),m3h2x8(:,49),heltab2x16(:,:,49))
  call Hloop_Q_A(ntryL,G1H8(23),20,nMT,G2H8(23),n2h8(26))
  call Hloop_QV_A(ntryL,G1H16(34),ex3(:),G1H8(23),m3h2x8(:,50),heltab2x16(:,:,50))
  call Hloop_Q_A(ntryL,G1H8(23),20,nMT,G2H8(24),n2h8(27))
  call Hloop_QV_A(ntryL,G1H16(35),ex3(:),G1H8(23),m3h2x8(:,51),heltab2x16(:,:,51))
  call Hloop_Q_A(ntryL,G1H8(23),20,nMB,G2H8(25),n2h8(28))
  call Hloop_SV_T(ntryL,G0H16(17),16,ex3(:),4,G1H8(23),m3h2x8(:,52),heltab2x16(:,:,52))
  call Hloop_VV_S(ntryL,G0H16(18),ex3(:),G0H8(5),m3h2x8(:,53),heltab2x16(:,:,53))
  call Hloop_SV_V(ntryL,G1H16(36),ex3(:),G1H8(24),m3h2x8(:,54),heltab2x16(:,:,54))
  call Hloop_SV_T(ntryL,G1H16(37),16,ex3(:),4,G2H8(26),m3h2x8(:,55),heltab2x16(:,:,55))
  call Hloop_VV_S(ntryL,G1H16(38),ex3(:),G1H8(25),m3h2x8(:,56),heltab2x16(:,:,56))
  call Hloop_SV_V(ntryL,G0H16(19),ex3(:),G0H8(6),m3h2x8(:,57),heltab2x16(:,:,57))
  call Hloop_UW_V(ntryL,G0H16(20),16,ex3(:),4,G1H8(26),m3h2x8(:,58),heltab2x16(:,:,58))
  call Hloop_SV_T(ntryL,G0H16(21),16,ex3(:),4,G1H8(27),m3h2x8(:,59),heltab2x16(:,:,59))
  call Hloop_VV_S(ntryL,G0H16(22),ex3(:),G0H8(7),m3h2x8(:,60),heltab2x16(:,:,60))
  call Hloop_SV_V(ntryL,G1H16(39),ex3(:),G1H8(28),m3h2x8(:,61),heltab2x16(:,:,61))
  call Hloop_UW_V(ntryL,G1H16(40),16,ex3(:),4,G2H8(27),m3h2x8(:,62),heltab2x16(:,:,62))
  call Hloop_VV_S(ntryL,G1H16(41),ex3(:),G1H8(29),m3h2x8(:,63),heltab2x16(:,:,63))
  call Hloop_SV_V(ntryL,G0H16(23),ex3(:),G0H8(8),m3h2x8(:,64),heltab2x16(:,:,64))
  call Hloop_UW_V(ntryL,G0H16(24),16,ex3(:),4,G1H8(30),m3h2x8(:,65),heltab2x16(:,:,65))
  call Hloop_UW_V(ntryL,G1H16(42),16,ex3(:),4,G2H8(28),m3h2x8(:,66),heltab2x16(:,:,66))
  call Hloop_QA_S(ntryL,G1H16(43),ex2(:),G1H8(31),ngH,m3h2x8(:,67),heltab2x16(:,:,67))
  call Hloop_QA_S(ntryL,G1H16(44),ex2(:),G1H8(32),ngX,m3h2x8(:,68),heltab2x16(:,:,68))
  call Hloop_QA_S(ntryL,G1H16(45),ex2(:),G1H8(33),ngPtb,m3h2x8(:,69),heltab2x16(:,:,69))
  call Hloop_SA_Q(ntryL,G1H16(46),ex2(:),G1H8(34),ngPtb,m3h2x8(:,70),heltab2x16(:,:,70))
  call Hloop_A_Q(ntryL,G1H8(34),18,nMB,G2H8(29),n2h8(29))
  call Hloop_QA_V(ntryL,G1H16(47),ex2(:),G1H8(34),m3h2x8(:,71),heltab2x16(:,:,71))
  call Hloop_QA_Z(ntryL,G1H16(48),ex2(:),G1H8(35),ngZu,m3h2x8(:,72),heltab2x16(:,:,72))
  call Hloop_QA_W(ntryL,G1H16(49),ex2(:),G1H8(36),m3h2x8(:,73),heltab2x16(:,:,73))
  call Hloop_SA_Q(ntryL,G0H16(25),ex2(:),G0H8(9),ngPtb,m3h2x8(:,74),heltab2x16(:,:,74))
  call Hloop_A_Q(ntryL,G0H8(9),18,nMB,G1H8(37),n2h8(30))
  call Hloop_SA_Q(ntryL,G1H16(50),ex2(:),G1H8(38),ngPtb,m3h2x8(:,75),heltab2x16(:,:,75))
  call Hloop_A_Q(ntryL,G1H8(38),18,nMB,G2H8(30),n2h8(31))
  call Hloop_WA_Q(ntryL,G0H16(26),ex2(:),G0H8(9),m3h2x8(:,76),heltab2x16(:,:,76))
  call Hloop_A_Q(ntryL,G0H8(9),18,nMB,G1H8(38),n2h8(32))
  call Hloop_SA_Q(ntryL,G1H16(51),ex2(:),G1H8(39),ngPtb,m3h2x8(:,77),heltab2x16(:,:,77))
  call Hloop_A_Q(ntryL,G1H8(39),18,nMB,G2H8(31),n2h8(33))
  call Hloop_SA_Q(ntryL,G0H16(27),ex2(:),G0H8(9),ngPtb,m3h2x8(:,78),heltab2x16(:,:,78))
  call Hloop_A_Q(ntryL,G0H8(9),18,nMB,G1H8(39),n2h8(34))
  call Hloop_WA_Q(ntryL,G1H16(52),ex2(:),G1H8(40),m3h2x8(:,79),heltab2x16(:,:,79))
  call Hloop_A_Q(ntryL,G1H8(40),18,nMB,G2H8(32),n2h8(35))
  call Hloop_WA_Q(ntryL,G0H16(28),ex2(:),G0H8(9),m3h2x8(:,80),heltab2x16(:,:,80))
  call Hloop_A_Q(ntryL,G0H8(9),18,nMB,G1H8(40),n2h8(36))
  call Hloop_SA_Q(ntryL,G0H16(29),ex2(:),G0H8(9),ngPtb,m3h2x8(:,81),heltab2x16(:,:,81))
  call Hloop_A_Q(ntryL,G0H8(9),18,nMB,G1H8(41),n2h8(37))
  call Hloop_SA_Q(ntryL,G1H16(53),ex2(:),G1H8(42),ngPtb,m3h2x8(:,82),heltab2x16(:,:,82))
  call Hloop_A_Q(ntryL,G1H8(42),18,nMB,G2H8(33),n2h8(38))
  call Hloop_WA_Q(ntryL,G0H16(30),ex2(:),G0H8(9),m3h2x8(:,83),heltab2x16(:,:,83))
  call Hloop_A_Q(ntryL,G0H8(9),18,nMB,G1H8(42),n2h8(39))
  call Hloop_WA_Q(ntryL,G1H16(54),ex2(:),G1H8(43),m3h2x8(:,84),heltab2x16(:,:,84))
  call Hloop_A_Q(ntryL,G1H8(43),18,nMB,G2H8(34),n2h8(40))
  call Hloop_SA_Q(ntryL,G0H16(31),ex2(:),G0H8(9),ngPtb,m3h2x8(:,85),heltab2x16(:,:,85))
  call Hloop_A_Q(ntryL,G0H8(9),18,nMB,G1H8(43),n2h8(41))
  call Hloop_WA_Q(ntryL,G1H16(55),ex2(:),G1H8(44),m3h2x8(:,86),heltab2x16(:,:,86))
  call Hloop_A_Q(ntryL,G1H8(44),18,nMB,G2H8(35),n2h8(42))
  call Hloop_WA_Q(ntryL,G0H16(32),ex2(:),G0H8(9),m3h2x8(:,87),heltab2x16(:,:,87))
  call Hloop_A_Q(ntryL,G0H8(9),18,nMB,G1H8(44),n2h8(43))
  call Hloop_WA_Q(ntryL,G1H16(56),ex2(:),G1H8(45),m3h2x8(:,88),heltab2x16(:,:,88))
  call Hloop_A_Q(ntryL,G1H8(45),18,nMB,G2H8(36),n2h8(44))
  call Hloop_AQ_S(ntryL,G1H16(57),ex1(:),G1H8(45),ngH,m3h2x8(:,89),heltab2x16(:,:,89))
  call Hloop_AQ_S(ntryL,G1H16(58),ex1(:),G1H8(46),ngX,m3h2x8(:,90),heltab2x16(:,:,90))
  call Hloop_AQ_S(ntryL,G1H16(59),ex1(:),G1H8(47),ngPbt,m3h2x8(:,91),heltab2x16(:,:,91))
  call Hloop_SQ_A(ntryL,G1H16(60),ex1(:),G1H8(48),ngPbt,m3h2x8(:,92),heltab2x16(:,:,92))
  call Hloop_Q_A(ntryL,G1H8(48),17,nMB,G2H8(37),n2h8(45))
  call Hloop_AQ_V(ntryL,G1H16(61),ex1(:),G1H8(48),m3h2x8(:,93),heltab2x16(:,:,93))
  call Hloop_AQ_Z(ntryL,G1H16(62),ex1(:),G1H8(49),ngZu,m3h2x8(:,94),heltab2x16(:,:,94))
  call Hloop_AQ_W(ntryL,G1H16(63),ex1(:),G1H8(50),m3h2x8(:,95),heltab2x16(:,:,95))
  call Hloop_SQ_A(ntryL,G0H16(33),ex1(:),G0H8(9),ngPbt,m3h2x8(:,96),heltab2x16(:,:,96))
  call Hloop_Q_A(ntryL,G0H8(9),17,nMB,G1H8(51),n2h8(46))
  call Hloop_SQ_A(ntryL,G1H16(64),ex1(:),G1H8(52),ngPbt,m3h2x8(:,97),heltab2x16(:,:,97))
  call Hloop_Q_A(ntryL,G1H8(52),17,nMB,G2H8(38),n2h8(47))
  call Hloop_SQ_A(ntryL,G1H16(65),ex1(:),G1H8(52),ngPbt,m3h2x8(:,98),heltab2x16(:,:,98))
  call Hloop_Q_A(ntryL,G1H8(52),17,nMB,G2H8(39),n2h8(48))
  call Hloop_WQ_A(ntryL,G0H16(34),ex1(:),G0H8(9),m3h2x8(:,99),heltab2x16(:,:,99))
  call Hloop_Q_A(ntryL,G0H8(9),17,nMB,G1H8(52),n2h8(49))
  call Hloop_SQ_A(ntryL,G0H16(35),ex1(:),G0H8(9),ngPbt,m3h2x8(:,100),heltab2x16(:,:,100))
  call Hloop_Q_A(ntryL,G0H8(9),17,nMB,G1H8(53),n2h8(50))
  call Hloop_SQ_A(ntryL,G0H16(36),ex1(:),G0H8(9),ngPbt,m3h2x8(:,101),heltab2x16(:,:,101))
  call Hloop_Q_A(ntryL,G0H8(9),17,nMB,G1H8(54),n2h8(51))
  call Hloop_SQ_A(ntryL,G1H16(66),ex1(:),G1H8(55),ngPbt,m3h2x8(:,102),heltab2x16(:,:,102))
  call Hloop_Q_A(ntryL,G1H8(55),17,nMB,G2H8(40),n2h8(52))
  call Hloop_WQ_A(ntryL,G1H16(67),ex1(:),G1H8(55),m3h2x8(:,103),heltab2x16(:,:,103))
  call Hloop_Q_A(ntryL,G1H8(55),17,nMB,G2H8(41),n2h8(53))
  call Hloop_WQ_A(ntryL,G0H16(37),ex1(:),G0H8(9),m3h2x8(:,104),heltab2x16(:,:,104))
  call Hloop_Q_A(ntryL,G0H8(9),17,nMB,G1H8(55),n2h8(54))
  call Hloop_WQ_A(ntryL,G0H16(38),ex1(:),G0H8(9),m3h2x8(:,105),heltab2x16(:,:,105))
  call Hloop_Q_A(ntryL,G0H8(9),17,nMB,G1H8(56),n2h8(55))
  call Hloop_SQ_A(ntryL,G0H16(39),ex1(:),G0H8(9),ngPbt,m3h2x8(:,106),heltab2x16(:,:,106))
  call Hloop_Q_A(ntryL,G0H8(9),17,nMB,G1H8(57),n2h8(56))
  call Hloop_WQ_A(ntryL,G1H16(68),ex1(:),G1H8(58),m3h2x8(:,107),heltab2x16(:,:,107))
  call Hloop_Q_A(ntryL,G1H8(58),17,nMB,G2H8(42),n2h8(57))
  call Hloop_WQ_A(ntryL,G1H16(69),ex1(:),G1H8(58),m3h2x8(:,108),heltab2x16(:,:,108))
  call Hloop_Q_A(ntryL,G1H8(58),17,nMB,G2H8(43),n2h8(58))
  call Hloop_WQ_A(ntryL,G0H16(40),ex1(:),G0H8(9),m3h2x8(:,109),heltab2x16(:,:,109))
  call Hloop_Q_A(ntryL,G0H8(9),17,nMB,G1H8(58),n2h8(59))
  call Hloop_WQ_A(ntryL,G1H16(70),ex1(:),G1H8(59),m3h2x8(:,110),heltab2x16(:,:,110))
  call Hloop_Q_A(ntryL,G1H8(59),17,nMB,G2H8(44),n2h8(60))
  call Hloop_AQ_S(ntryL,G1H16(71),ex1(:),G1H8(59),ngH,m3h2x8(:,111),heltab2x16(:,:,111))
  call Hloop_AQ_S(ntryL,G1H16(72),ex1(:),G1H8(60),ngX,m3h2x8(:,112),heltab2x16(:,:,112))
  call Hloop_AQ_S(ntryL,G1H16(73),ex1(:),G1H8(61),ngPbt,m3h2x8(:,113),heltab2x16(:,:,113))
  call Hloop_SQ_A(ntryL,G1H16(74),ex1(:),G1H8(62),ngPbt,m3h2x8(:,114),heltab2x16(:,:,114))
  call Hloop_Q_A(ntryL,G1H8(62),17,nMB,G2H8(45),n2h8(61))
  call Hloop_AQ_V(ntryL,G1H16(75),ex1(:),G1H8(62),m3h2x8(:,115),heltab2x16(:,:,115))
  call Hloop_AQ_Z(ntryL,G1H16(76),ex1(:),G1H8(63),ngZu,m3h2x8(:,116),heltab2x16(:,:,116))
  call Hloop_AQ_W(ntryL,G1H16(77),ex1(:),G1H8(64),m3h2x8(:,117),heltab2x16(:,:,117))
  call Hloop_SQ_A(ntryL,G0H16(41),ex1(:),G0H8(9),ngPbt,m3h2x8(:,118),heltab2x16(:,:,118))
  call Hloop_Q_A(ntryL,G0H8(9),17,nMB,G1H8(65),n2h8(62))
  call Hloop_SQ_A(ntryL,G1H16(78),ex1(:),G1H8(66),ngPbt,m3h2x8(:,119),heltab2x16(:,:,119))
  call Hloop_Q_A(ntryL,G1H8(66),17,nMB,G2H8(46),n2h8(63))
  call Hloop_SQ_A(ntryL,G1H16(79),ex1(:),G1H8(66),ngPbt,m3h2x8(:,120),heltab2x16(:,:,120))
  call Hloop_Q_A(ntryL,G1H8(66),17,nMB,G2H8(47),n2h8(64))
  call Hloop_WQ_A(ntryL,G0H16(42),ex1(:),G0H8(9),m3h2x8(:,121),heltab2x16(:,:,121))
  call Hloop_Q_A(ntryL,G0H8(9),17,nMB,G1H8(66),n2h8(65))
  call Hloop_SQ_A(ntryL,G0H16(43),ex1(:),G0H8(9),ngPbt,m3h2x8(:,122),heltab2x16(:,:,122))
  call Hloop_Q_A(ntryL,G0H8(9),17,nMB,G1H8(67),n2h8(66))
  call Hloop_SQ_A(ntryL,G0H16(44),ex1(:),G0H8(9),ngPbt,m3h2x8(:,123),heltab2x16(:,:,123))
  call Hloop_Q_A(ntryL,G0H8(9),17,nMB,G1H8(68),n2h8(67))
  call Hloop_SQ_A(ntryL,G1H16(80),ex1(:),G1H8(69),ngPbt,m3h2x8(:,124),heltab2x16(:,:,124))
  call Hloop_Q_A(ntryL,G1H8(69),17,nMB,G2H8(48),n2h8(68))
  call Hloop_WQ_A(ntryL,G1H16(81),ex1(:),G1H8(69),m3h2x8(:,125),heltab2x16(:,:,125))
  call Hloop_Q_A(ntryL,G1H8(69),17,nMB,G2H8(49),n2h8(69))
  call Hloop_WQ_A(ntryL,G0H16(45),ex1(:),G0H8(9),m3h2x8(:,126),heltab2x16(:,:,126))
  call Hloop_Q_A(ntryL,G0H8(9),17,nMB,G1H8(69),n2h8(70))
  call Hloop_WQ_A(ntryL,G0H16(46),ex1(:),G0H8(9),m3h2x8(:,127),heltab2x16(:,:,127))
  call Hloop_Q_A(ntryL,G0H8(9),17,nMB,G1H8(70),n2h8(71))
  call Hloop_SQ_A(ntryL,G0H16(47),ex1(:),G0H8(9),ngPbt,m3h2x8(:,128),heltab2x16(:,:,128))
  call Hloop_Q_A(ntryL,G0H8(9),17,nMB,G1H8(71),n2h8(72))
  call Hloop_WQ_A(ntryL,G1H16(82),ex1(:),G1H8(72),m3h2x8(:,129),heltab2x16(:,:,129))
  call Hloop_Q_A(ntryL,G1H8(72),17,nMB,G2H8(50),n2h8(73))
  call Hloop_WQ_A(ntryL,G1H16(83),ex1(:),G1H8(72),m3h2x8(:,130),heltab2x16(:,:,130))
  call Hloop_Q_A(ntryL,G1H8(72),17,nMB,G2H8(51),n2h8(74))
  call Hloop_WQ_A(ntryL,G0H16(48),ex1(:),G0H8(9),m3h2x8(:,131),heltab2x16(:,:,131))
  call Hloop_Q_A(ntryL,G0H8(9),17,nMB,G1H8(72),n2h8(75))
  call Hloop_WQ_A(ntryL,G1H16(84),ex1(:),G1H8(73),m3h2x8(:,132),heltab2x16(:,:,132))
  call Hloop_Q_A(ntryL,G1H8(73),17,nMB,G2H8(52),n2h8(76))
  call Hloop_QA_S(ntryL,G1H16(85),ex2(:),G1H8(73),ngPtb,m3h2x8(:,133),heltab2x16(:,:,133))
  call Hloop_SA_Q(ntryL,G1H16(86),ex2(:),G1H8(74),ngPtb,m3h2x8(:,134),heltab2x16(:,:,134))
  call Hloop_A_Q(ntryL,G1H8(74),18,nMB,G2H8(53),n2h8(77))
  call Hloop_QA_W(ntryL,G1H16(87),ex2(:),G1H8(74),m3h2x8(:,135),heltab2x16(:,:,135))
  call Hloop_QA_S(ntryL,G1H16(88),ex2(:),G1H8(75),ngPtb,m3h2x8(:,136),heltab2x16(:,:,136))
  call Hloop_SA_Q(ntryL,G0H16(49),ex2(:),G0H8(9),ngPtb,m3h2x8(:,137),heltab2x16(:,:,137))
  call Hloop_A_Q(ntryL,G0H8(9),18,nMB,G1H8(76),n2h8(78))
  call Hloop_WA_Q(ntryL,G0H16(50),ex2(:),G0H8(9),m3h2x8(:,138),heltab2x16(:,:,138))
  call Hloop_A_Q(ntryL,G0H8(9),18,nMB,G1H8(77),n2h8(79))
  call Hloop_SA_Q(ntryL,G1H16(89),ex2(:),G1H8(78),ngPtb,m3h2x8(:,139),heltab2x16(:,:,139))
  call Hloop_A_Q(ntryL,G1H8(78),18,nMB,G2H8(54),n2h8(80))
  call Hloop_QA_W(ntryL,G1H16(90),ex2(:),G1H8(78),m3h2x8(:,140),heltab2x16(:,:,140))
  call Hloop_WA_Q(ntryL,G1H16(91),ex2(:),G1H8(79),m3h2x8(:,141),heltab2x16(:,:,141))
  call Hloop_A_Q(ntryL,G1H8(79),18,nMB,G2H8(55),n2h8(81))
  call Hloop_SA_Q(ntryL,G0H16(51),ex2(:),G0H8(9),ngPtb,m3h2x8(:,142),heltab2x16(:,:,142))
  call Hloop_A_Q(ntryL,G0H8(9),18,nMB,G1H8(79),n2h8(82))
  call Hloop_WA_Q(ntryL,G0H16(52),ex2(:),G0H8(9),m3h2x8(:,143),heltab2x16(:,:,143))
  call Hloop_A_Q(ntryL,G0H8(9),18,nMB,G1H8(80),n2h8(83))
  call Hloop_WA_Q(ntryL,G1H16(92),ex2(:),G1H8(81),m3h2x8(:,144),heltab2x16(:,:,144))
  call Hloop_A_Q(ntryL,G1H8(81),18,nMB,G2H8(56),n2h8(84))
  call Hloop_QA_S(ntryL,G1H16(93),ex2(:),G1H8(81),ngPtb,m3h2x8(:,145),heltab2x16(:,:,145))
  call Hloop_SA_Q(ntryL,G1H16(94),ex2(:),G1H8(82),ngPtb,m3h2x8(:,146),heltab2x16(:,:,146))
  call Hloop_A_Q(ntryL,G1H8(82),18,nMB,G2H8(57),n2h8(85))
  call Hloop_QA_W(ntryL,G1H16(95),ex2(:),G1H8(82),m3h2x8(:,147),heltab2x16(:,:,147))
  call Hloop_QA_S(ntryL,G1H16(96),ex2(:),G1H8(83),ngPtb,m3h2x8(:,148),heltab2x16(:,:,148))
  call Hloop_SA_Q(ntryL,G0H16(53),ex2(:),G0H8(9),ngPtb,m3h2x8(:,149),heltab2x16(:,:,149))
  call Hloop_A_Q(ntryL,G0H8(9),18,nMB,G1H8(84),n2h8(86))
  call Hloop_WA_Q(ntryL,G0H16(54),ex2(:),G0H8(9),m3h2x8(:,150),heltab2x16(:,:,150))
  call Hloop_A_Q(ntryL,G0H8(9),18,nMB,G1H8(85),n2h8(87))
  call Hloop_SA_Q(ntryL,G1H16(97),ex2(:),G1H8(86),ngPtb,m3h2x8(:,151),heltab2x16(:,:,151))
  call Hloop_A_Q(ntryL,G1H8(86),18,nMB,G2H8(58),n2h8(88))
  call Hloop_QA_W(ntryL,G1H16(98),ex2(:),G1H8(86),m3h2x8(:,152),heltab2x16(:,:,152))
  call Hloop_WA_Q(ntryL,G1H16(99),ex2(:),G1H8(87),m3h2x8(:,153),heltab2x16(:,:,153))
  call Hloop_A_Q(ntryL,G1H8(87),18,nMB,G2H8(59),n2h8(89))
  call Hloop_SA_Q(ntryL,G0H16(55),ex2(:),G0H8(9),ngPtb,m3h2x8(:,154),heltab2x16(:,:,154))
  call Hloop_A_Q(ntryL,G0H8(9),18,nMB,G1H8(87),n2h8(90))
  call Hloop_WA_Q(ntryL,G0H16(56),ex2(:),G0H8(9),m3h2x8(:,155),heltab2x16(:,:,155))
  call Hloop_A_Q(ntryL,G0H8(9),18,nMB,G1H8(88),n2h8(91))
  call Hloop_WA_Q(ntryL,G1H16(100),ex2(:),G1H8(89),m3h2x8(:,156),heltab2x16(:,:,156))
  call Hloop_A_Q(ntryL,G1H8(89),18,nMB,G2H8(60),n2h8(92))
  call Hloop_AQ_S(ntryL,G1H16(101),ex1(:),G1H8(89),ngPbt,m3h2x8(:,157),heltab2x16(:,:,157))
  call Hloop_SQ_A(ntryL,G1H16(102),ex1(:),G1H8(90),ngPbt,m3h2x8(:,158),heltab2x16(:,:,158))
  call Hloop_Q_A(ntryL,G1H8(90),17,nMB,G2H8(61),n2h8(93))
  call Hloop_AQ_S(ntryL,G1H16(103),ex1(:),G1H8(90),ngPbt,m3h2x8(:,159),heltab2x16(:,:,159))
  call Hloop_AQ_W(ntryL,G1H16(104),ex1(:),G1H8(91),m3h2x8(:,160),heltab2x16(:,:,160))
  call Hloop_SQ_A(ntryL,G0H16(57),ex1(:),G0H8(9),ngPbt,m3h2x8(:,161),heltab2x16(:,:,161))
  call Hloop_Q_A(ntryL,G0H8(9),17,nMB,G1H8(92),n2h8(94))
  call Hloop_SQ_A(ntryL,G1H16(105),ex1(:),G1H8(93),ngPbt,m3h2x8(:,162),heltab2x16(:,:,162))
  call Hloop_Q_A(ntryL,G1H8(93),17,nMB,G2H8(62),n2h8(95))
  call Hloop_WQ_A(ntryL,G0H16(58),ex1(:),G0H8(9),m3h2x8(:,163),heltab2x16(:,:,163))
  call Hloop_Q_A(ntryL,G0H8(9),17,nMB,G1H8(93),n2h8(96))
  call Hloop_AQ_W(ntryL,G1H16(106),ex1(:),G1H8(94),m3h2x8(:,164),heltab2x16(:,:,164))
  call Hloop_SQ_A(ntryL,G0H16(59),ex1(:),G0H8(9),ngPbt,m3h2x8(:,165),heltab2x16(:,:,165))
  call Hloop_Q_A(ntryL,G0H8(9),17,nMB,G1H8(95),n2h8(97))
  call Hloop_WQ_A(ntryL,G1H16(107),ex1(:),G1H8(96),m3h2x8(:,166),heltab2x16(:,:,166))
  call Hloop_Q_A(ntryL,G1H8(96),17,nMB,G2H8(63),n2h8(98))
  call Hloop_WQ_A(ntryL,G0H16(60),ex1(:),G0H8(9),m3h2x8(:,167),heltab2x16(:,:,167))
  call Hloop_Q_A(ntryL,G0H8(9),17,nMB,G1H8(96),n2h8(99))
  call Hloop_WQ_A(ntryL,G1H16(108),ex1(:),G1H8(97),m3h2x8(:,168),heltab2x16(:,:,168))
  call Hloop_Q_A(ntryL,G1H8(97),17,nMB,G2H8(64),n2h8(100))
  call Hloop_SQ_A(ntryL,G1H16(109),ex1(:),G1H8(97),ngPbt,m3h2x8(:,169),heltab2x16(:,:,169))
  call Hloop_Q_A(ntryL,G1H8(97),17,nMB,G2H8(65),n2h8(101))
  call Hloop_AQ_S(ntryL,G1H16(110),ex1(:),G1H8(97),ngPbt,m3h2x8(:,170),heltab2x16(:,:,170))
  call Hloop_SQ_A(ntryL,G0H16(61),ex1(:),G0H8(9),ngPbt,m3h2x8(:,171),heltab2x16(:,:,171))
  call Hloop_Q_A(ntryL,G0H8(9),17,nMB,G1H8(98),n2h8(102))
  call Hloop_WQ_A(ntryL,G0H16(62),ex1(:),G0H8(9),m3h2x8(:,172),heltab2x16(:,:,172))
  call Hloop_Q_A(ntryL,G0H8(9),17,nMB,G1H8(99),n2h8(103))
  call Hloop_AQ_S(ntryL,G1H16(111),ex1(:),G1H8(100),ngPbt,m3h2x8(:,173),heltab2x16(:,:,173))
  call Hloop_AQ_S(ntryL,G1H16(112),ex1(:),G1H8(101),ngPbt,m3h2x8(:,174),heltab2x16(:,:,174))
  call Hloop_AQ_W(ntryL,G1H16(113),ex1(:),G1H8(102),m3h2x8(:,175),heltab2x16(:,:,175))
  call Hloop_WQ_A(ntryL,G1H16(114),ex1(:),G1H8(103),m3h2x8(:,176),heltab2x16(:,:,176))
  call Hloop_Q_A(ntryL,G1H8(103),17,nMB,G2H8(66),n2h8(104))
  call Hloop_AQ_S(ntryL,G1H16(115),ex1(:),G1H8(103),ngPbt,m3h2x8(:,177),heltab2x16(:,:,177))
  call Hloop_AQ_W(ntryL,G1H16(116),ex1(:),G1H8(104),m3h2x8(:,178),heltab2x16(:,:,178))
  call Hloop_AQ_W(ntryL,G1H16(117),ex1(:),G1H8(105),m3h2x8(:,179),heltab2x16(:,:,179))
  call Hloop_AQ_W(ntryL,G1H16(118),ex1(:),G1H8(106),m3h2x8(:,180),heltab2x16(:,:,180))
  call Hloop_AQ_S(ntryL,G1H16(119),ex1(:),G1H8(107),ngPbt,m3h2x8(:,181),heltab2x16(:,:,181))
  call Hloop_SQ_A(ntryL,G1H16(120),ex1(:),G1H8(108),ngPbt,m3h2x8(:,182),heltab2x16(:,:,182))
  call Hloop_Q_A(ntryL,G1H8(108),17,nMB,G2H8(67),n2h8(105))
  call Hloop_AQ_S(ntryL,G1H16(121),ex1(:),G1H8(108),ngPbt,m3h2x8(:,183),heltab2x16(:,:,183))
  call Hloop_AQ_W(ntryL,G1H16(122),ex1(:),G1H8(109),m3h2x8(:,184),heltab2x16(:,:,184))
  call Hloop_SQ_A(ntryL,G0H16(63),ex1(:),G0H8(9),ngPbt,m3h2x8(:,185),heltab2x16(:,:,185))
  call Hloop_Q_A(ntryL,G0H8(9),17,nMB,G1H8(110),n2h8(106))
  call Hloop_SQ_A(ntryL,G1H16(123),ex1(:),G1H8(111),ngPbt,m3h2x8(:,186),heltab2x16(:,:,186))
  call Hloop_Q_A(ntryL,G1H8(111),17,nMB,G2H8(68),n2h8(107))
  call Hloop_WQ_A(ntryL,G0H16(64),ex1(:),G0H8(9),m3h2x8(:,187),heltab2x16(:,:,187))
  call Hloop_Q_A(ntryL,G0H8(9),17,nMB,G1H8(111),n2h8(108))
  call Hloop_AQ_W(ntryL,G1H16(124),ex1(:),G1H8(112),m3h2x8(:,188),heltab2x16(:,:,188))
  call Hloop_SQ_A(ntryL,G0H16(65),ex1(:),G0H8(9),ngPbt,m3h2x8(:,189),heltab2x16(:,:,189))
  call Hloop_Q_A(ntryL,G0H8(9),17,nMB,G1H8(113),n2h8(109))
  call Hloop_WQ_A(ntryL,G1H16(125),ex1(:),G1H8(114),m3h2x8(:,190),heltab2x16(:,:,190))
  call Hloop_Q_A(ntryL,G1H8(114),17,nMB,G2H8(69),n2h8(110))
  call Hloop_WQ_A(ntryL,G0H16(66),ex1(:),G0H8(9),m3h2x8(:,191),heltab2x16(:,:,191))
  call Hloop_Q_A(ntryL,G0H8(9),17,nMB,G1H8(114),n2h8(111))
  call Hloop_WQ_A(ntryL,G1H16(126),ex1(:),G1H8(115),m3h2x8(:,192),heltab2x16(:,:,192))
  call Hloop_Q_A(ntryL,G1H8(115),17,nMB,G2H8(70),n2h8(112))
  call Hloop_SQ_A(ntryL,G1H16(127),ex1(:),G1H8(115),ngPbt,m3h2x8(:,193),heltab2x16(:,:,193))
  call Hloop_Q_A(ntryL,G1H8(115),17,nMB,G2H8(71),n2h8(113))
  call Hloop_AQ_S(ntryL,G1H16(128),ex1(:),G1H8(115),ngPbt,m3h2x8(:,194),heltab2x16(:,:,194))
  call Hloop_SQ_A(ntryL,G0H16(67),ex1(:),G0H8(9),ngPbt,m3h2x8(:,195),heltab2x16(:,:,195))
  call Hloop_Q_A(ntryL,G0H8(9),17,nMB,G1H8(116),n2h8(114))
  call Hloop_WQ_A(ntryL,G0H16(68),ex1(:),G0H8(9),m3h2x8(:,196),heltab2x16(:,:,196))
  call Hloop_Q_A(ntryL,G0H8(9),17,nMB,G1H8(117),n2h8(115))
  call Hloop_AQ_S(ntryL,G1H16(129),ex1(:),G1H8(118),ngPbt,m3h2x8(:,197),heltab2x16(:,:,197))
  call Hloop_AQ_S(ntryL,G1H16(130),ex1(:),G1H8(119),ngPbt,m3h2x8(:,198),heltab2x16(:,:,198))
  call Hloop_AQ_W(ntryL,G1H16(131),ex1(:),G1H8(120),m3h2x8(:,199),heltab2x16(:,:,199))
  call Hloop_WQ_A(ntryL,G1H16(132),ex1(:),G1H8(121),m3h2x8(:,200),heltab2x16(:,:,200))
  call Hloop_Q_A(ntryL,G1H8(121),17,nMB,G2H8(72),n2h8(116))
  call Hloop_AQ_S(ntryL,G1H16(133),ex1(:),G1H8(121),ngPbt,m3h2x8(:,201),heltab2x16(:,:,201))
  call Hloop_AQ_W(ntryL,G1H16(134),ex1(:),G1H8(122),m3h2x8(:,202),heltab2x16(:,:,202))
  call Hloop_AQ_W(ntryL,G1H16(135),ex1(:),G1H8(123),m3h2x8(:,203),heltab2x16(:,:,203))
  call Hloop_AQ_W(ntryL,G1H16(136),ex1(:),G1H8(124),m3h2x8(:,204),heltab2x16(:,:,204))
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H8(4),[G0H8(1)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H8(3),[G1H8(1)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H8(8),[G0H8(2)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H8(5),[G1H8(2)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H8(7),[G1H8(4)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H8(9),[G0H8(3)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H8(8),[G1H8(6)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H8(10),[G0H8(4)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H8(11),[G1H8(16)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H8(14),[G1H8(15)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H8(12),[G1H8(18)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H8(13),[G1H8(20)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H8(16),[G1H8(17)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H8(17),[G1H8(19)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H8(15),[G1H8(22)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H8(18),[G1H8(21)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H8(22),[G0H8(5)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H8(25),[G1H8(23)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H8(26),[G1H8(24)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H8(26),[G0H8(7)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H8(27),[G0H8(6)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H8(29),[G1H8(27)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H8(30),[G1H8(28)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H8(28),[G0H8(8)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H8(29),[G1H8(38)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H8(32),[G1H8(37)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H8(30),[G1H8(40)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H8(31),[G1H8(42)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H8(34),[G1H8(39)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H8(35),[G1H8(41)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H8(33),[G1H8(44)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H8(36),[G1H8(43)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H8(37),[G1H8(52)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H8(41),[G1H8(51)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H8(38),[G1H8(55)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H8(39),[G1H8(56)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H8(42),[G1H8(53)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H8(43),[G1H8(54)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H8(40),[G1H8(58)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H8(44),[G1H8(57)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H8(45),[G1H8(66)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H8(49),[G1H8(65)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H8(46),[G1H8(69)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H8(47),[G1H8(70)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H8(50),[G1H8(67)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H8(51),[G1H8(68)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H8(48),[G1H8(72)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H8(52),[G1H8(71)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H8(53),[G1H8(77)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H8(55),[G1H8(76)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H8(54),[G1H8(80)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H8(56),[G1H8(79)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H8(57),[G1H8(85)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H8(59),[G1H8(84)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H8(58),[G1H8(88)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H8(60),[G1H8(87)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H8(61),[G1H8(93)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H8(63),[G1H8(92)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H8(62),[G1H8(96)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H8(64),[G1H8(95)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H8(65),[G1H8(99)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H8(66),[G1H8(98)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H8(67),[G1H8(111)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H8(69),[G1H8(110)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H8(68),[G1H8(114)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H8(70),[G1H8(113)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H8(71),[G1H8(117)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H8(72),[G1H8(116)])
  call Hloop_AQ_S(ntryL,G2H8(1),ex1(:),G2H4(1),ngH,m3h2x4(:,1),heltab2x8(:,:,1))
  call Hloop_AQ_S(ntryL,G2H8(2),ex1(:),G2H4(2),ngX,m3h2x4(:,2),heltab2x8(:,:,2))
  call Hloop_AQ_S(ntryL,G2H8(3),ex1(:),G2H4(3),ngPbt,m3h2x4(:,3),heltab2x8(:,:,3))
  call Hotf_5pt_reduction(G2H8(4),RedSet_5(1),mass5set(:,1),  & 
G1H8(1),G1H8(2),G1H8(4),G1H8(6),G1H8(16),G1H8(15),8)
  call HG1shiftOLR(G1H8(2),8,8)
  call Hloop_AQ_V(ntryL,G2H8(5),ex1(:),G2H4(4),m3h2x4(:,4),heltab2x8(:,:,4))
  call Hloop_AQ_Z(ntryL,G2H8(6),ex1(:),G2H4(5),ngZu,m3h2x4(:,5),heltab2x8(:,:,5))
  call Hloop_AQ_W(ntryL,G2H8(7),ex1(:),G2H4(6),m3h2x4(:,6),heltab2x8(:,:,6))
  call Hloop_SQ_A(ntryL,G1H8(3),ex1(:),G1H4(1),ngPbt,m3h2x4(:,7),heltab2x8(:,:,7))
  call Hloop_Q_A(ntryL,G1H4(1),21,nMB,G2H4(7),n2h4(1))
  call Hotf_5pt_reduction(G2H8(8),RedSet_5(1),mass5set(:,1),  & 
G1H8(18),G1H8(20),G1H8(17),G1H8(19),G1H8(22),G1H8(21),8)
  call HG1shiftOLR(G1H8(20),8,8)
  call Hloop_WQ_A(ntryL,G1H8(5),ex1(:),G1H4(1),m3h2x4(:,8),heltab2x8(:,:,8))
  call Hloop_Q_A(ntryL,G1H4(1),21,nMB,G2H4(8),n2h4(2))
  call Hloop_SQ_A(ntryL,G1H8(7),ex1(:),G1H4(1),ngPbt,m3h2x4(:,9),heltab2x8(:,:,9))
  call Hloop_Q_A(ntryL,G1H4(1),21,nMB,G2H4(9),n2h4(3))
  call Hotf_5pt_reduction(G2H8(9),RedSet_5(1),mass5set(:,1),  & 
G1H8(23),G1H8(24),G1H8(27),G1H8(28),G1H8(38),G1H8(37),8)
  call HG1shiftOLR(G1H8(24),8,8)
  call Hloop_WQ_A(ntryL,G1H8(8),ex1(:),G1H4(1),m3h2x4(:,10),heltab2x8(:,:,10))
  call Hloop_Q_A(ntryL,G1H4(1),21,nMB,G2H4(10),n2h4(4))
  call Hotf_5pt_reduction(G2H8(10),RedSet_5(1),mass5set(:,1),  & 
G1H8(40),G1H8(42),G1H8(39),G1H8(41),G1H8(44),G1H8(43),8)
  call HG1shiftOLR(G1H8(42),8,8)
  call Hloop_SQ_A(ntryL,G1H8(9),ex1(:),G1H4(1),ngH,m3h2x4(:,11),heltab2x8(:,:,11))
  call Hloop_Q_A(ntryL,G1H4(1),19,nMT,G2H4(11),n2h4(5))
  call Hloop_SQ_A(ntryL,G1H8(10),ex1(:),G1H4(1),ngX,m3h2x4(:,12),heltab2x8(:,:,12))
  call Hloop_Q_A(ntryL,G1H4(1),19,nMT,G2H4(12),n2h4(6))
  call Hloop_SQ_A(ntryL,G1H8(11),ex1(:),G1H4(1),ngPbt,m3h2x4(:,13),heltab2x8(:,:,13))
  call Hloop_Q_A(ntryL,G1H4(1),19,nMB,G2H4(13),n2h4(7))
  call Hloop_AQ_S(ntryL,G2H8(11),ex1(:),G2H4(14),ngPbt,m3h2x4(:,14),heltab2x8(:,:,14))
  call Hloop_VQ_A(ntryL,G1H8(12),ex1(:),G1H4(1),m3h2x4(:,15),heltab2x8(:,:,15))
  call Hloop_Q_A(ntryL,G1H4(1),19,nMT,G2H4(15),n2h4(8))
  call Hloop_ZQ_A(ntryL,G1H8(13),ex1(:),G1H4(1),ngZu,m3h2x4(:,16),heltab2x8(:,:,16))
  call Hloop_Q_A(ntryL,G1H4(1),19,nMT,G2H4(16),n2h4(9))
  call Hloop_WQ_A(ntryL,G1H8(14),ex1(:),G1H4(1),m3h2x4(:,17),heltab2x8(:,:,17))
  call Hloop_Q_A(ntryL,G1H4(1),19,nMB,G2H4(17),n2h4(10))
  call Hloop_AQ_S(ntryL,G2H8(14),ex1(:),G2H4(18),ngPbt,m3h2x4(:,18),heltab2x8(:,:,18))
  call Hloop_AQ_S(ntryL,G2H8(12),ex1(:),G2H4(19),ngPbt,m3h2x4(:,19),heltab2x8(:,:,19))
  call Hloop_AQ_W(ntryL,G2H8(13),ex1(:),G2H4(20),m3h2x4(:,20),heltab2x8(:,:,20))
  call Hloop_AQ_S(ntryL,G2H8(16),ex1(:),G2H4(21),ngPbt,m3h2x4(:,21),heltab2x8(:,:,21))
  call Hloop_AQ_W(ntryL,G2H8(17),ex1(:),G2H4(22),m3h2x4(:,22),heltab2x8(:,:,22))
  call Hloop_AQ_W(ntryL,G2H8(15),ex1(:),G2H4(23),m3h2x4(:,23),heltab2x8(:,:,23))
  call Hloop_AQ_W(ntryL,G2H8(18),ex1(:),G2H4(24),m3h2x4(:,24),heltab2x8(:,:,24))
  call Hloop_QA_S(ntryL,G2H8(19),ex2(:),G2H4(25),ngH,m3h2x4(:,25),heltab2x8(:,:,25))
  call Hloop_QA_S(ntryL,G2H8(20),ex2(:),G2H4(26),ngX,m3h2x4(:,26),heltab2x8(:,:,26))
  call Hloop_QA_S(ntryL,G2H8(21),ex2(:),G2H4(27),ngPtb,m3h2x4(:,27),heltab2x8(:,:,27))
  call Hotf_5pt_reduction(G2H8(22),RedSet_5(2),mass5set(:,1),  & 
G1H8(52),G1H8(51),G1H8(55),G1H8(56),G1H8(53),G1H8(54),8)
  call HG1shiftOLR(G1H8(51),8,8)
  call Hloop_QA_V(ntryL,G2H8(23),ex2(:),G2H4(28),m3h2x4(:,28),heltab2x8(:,:,28))
  call Hloop_QA_Z(ntryL,G2H8(24),ex2(:),G2H4(29),ngZu,m3h2x4(:,29),heltab2x8(:,:,29))
  call Hloop_QA_W(ntryL,G2H8(25),ex2(:),G2H4(30),m3h2x4(:,30),heltab2x8(:,:,30))
  call Hloop_SA_Q(ntryL,G1H8(25),ex2(:),G1H4(1),ngPtb,m3h2x4(:,31),heltab2x8(:,:,31))
  call Hloop_A_Q(ntryL,G1H4(1),22,nMB,G2H4(31),n2h4(11))
  call Hloop_WA_Q(ntryL,G1H8(26),ex2(:),G1H4(1),m3h2x4(:,32),heltab2x8(:,:,32))
  call Hloop_A_Q(ntryL,G1H4(1),22,nMB,G2H4(32),n2h4(12))
  call Hotf_5pt_reduction(G2H8(26),RedSet_5(2),mass5set(:,1),  & 
G1H8(58),G1H8(57),G1H8(66),G1H8(65),G1H8(69),G1H8(70),8)
  call HG1shiftOLR(G1H8(57),8,8)
  call Hotf_5pt_reduction(G2H8(27),RedSet_5(2),mass5set(:,1),  & 
G1H8(67),G1H8(68),G1H8(72),G1H8(71),G1H8(77),G1H8(76),8)
  call HG1shiftOLR(G1H8(68),8,8)
  call Hloop_SA_Q(ntryL,G1H8(29),ex2(:),G1H4(1),ngPtb,m3h2x4(:,33),heltab2x8(:,:,33))
  call Hloop_A_Q(ntryL,G1H4(1),22,nMB,G2H4(33),n2h4(13))
  call Hloop_WA_Q(ntryL,G1H8(30),ex2(:),G1H4(1),m3h2x4(:,34),heltab2x8(:,:,34))
  call Hloop_A_Q(ntryL,G1H4(1),22,nMB,G2H4(34),n2h4(14))
  call Hotf_5pt_reduction(G2H8(28),RedSet_5(2),mass5set(:,1),  & 
G1H8(80),G1H8(79),G1H8(85),G1H8(84),G1H8(88),G1H8(87),8)
  call HG1shiftOLR(G1H8(79),8,8)
  call Hloop_SQ_A(ntryL,G1H8(31),ex1(:),G1H4(1),ngH,m3h2x4(:,35),heltab2x8(:,:,35))
  call Hloop_Q_A(ntryL,G1H4(1),19,nMT,G2H4(35),n2h4(15))
  call Hloop_SQ_A(ntryL,G1H8(32),ex1(:),G1H4(1),ngX,m3h2x4(:,36),heltab2x8(:,:,36))
  call Hloop_Q_A(ntryL,G1H4(1),19,nMT,G2H4(36),n2h4(16))
  call Hloop_SQ_A(ntryL,G1H8(33),ex1(:),G1H4(1),ngPbt,m3h2x4(:,37),heltab2x8(:,:,37))
  call Hloop_Q_A(ntryL,G1H4(1),19,nMB,G2H4(37),n2h4(17))
  call Hloop_AQ_S(ntryL,G2H8(29),ex1(:),G2H4(38),ngPbt,m3h2x4(:,38),heltab2x8(:,:,38))
  call Hloop_VQ_A(ntryL,G1H8(34),ex1(:),G1H4(1),m3h2x4(:,39),heltab2x8(:,:,39))
  call Hloop_Q_A(ntryL,G1H4(1),19,nMT,G2H4(39),n2h4(18))
  call Hloop_ZQ_A(ntryL,G1H8(35),ex1(:),G1H4(1),ngZu,m3h2x4(:,40),heltab2x8(:,:,40))
  call Hloop_Q_A(ntryL,G1H4(1),19,nMT,G2H4(40),n2h4(19))
  call Hloop_WQ_A(ntryL,G1H8(36),ex1(:),G1H4(1),m3h2x4(:,41),heltab2x8(:,:,41))
  call Hloop_Q_A(ntryL,G1H4(1),19,nMB,G2H4(41),n2h4(20))
  call Hloop_AQ_S(ntryL,G2H8(32),ex1(:),G2H4(42),ngPbt,m3h2x4(:,42),heltab2x8(:,:,42))
  call Hloop_AQ_S(ntryL,G2H8(30),ex1(:),G2H4(43),ngPbt,m3h2x4(:,43),heltab2x8(:,:,43))
  call Hloop_AQ_W(ntryL,G2H8(31),ex1(:),G2H4(44),m3h2x4(:,44),heltab2x8(:,:,44))
  call Hloop_AQ_S(ntryL,G2H8(34),ex1(:),G2H4(45),ngPbt,m3h2x4(:,45),heltab2x8(:,:,45))
  call Hloop_AQ_W(ntryL,G2H8(35),ex1(:),G2H4(46),m3h2x4(:,46),heltab2x8(:,:,46))
  call Hloop_AQ_W(ntryL,G2H8(33),ex1(:),G2H4(47),m3h2x4(:,47),heltab2x8(:,:,47))
  call Hloop_AQ_W(ntryL,G2H8(36),ex1(:),G2H4(48),m3h2x4(:,48),heltab2x8(:,:,48))
  call Hloop_SA_Q(ntryL,G1H8(45),ex2(:),G1H4(1),ngH,m3h2x4(:,49),heltab2x8(:,:,49))
  call Hloop_A_Q(ntryL,G1H4(1),19,nMT,G2H4(49),n2h4(21))
  call Hloop_SA_Q(ntryL,G1H8(46),ex2(:),G1H4(1),ngX,m3h2x4(:,50),heltab2x8(:,:,50))
  call Hloop_A_Q(ntryL,G1H4(1),19,nMT,G2H4(50),n2h4(22))
  call Hloop_SA_Q(ntryL,G1H8(47),ex2(:),G1H4(1),ngPtb,m3h2x4(:,51),heltab2x8(:,:,51))
  call Hloop_A_Q(ntryL,G1H4(1),19,nMB,G2H4(51),n2h4(23))
  call Hloop_QA_S(ntryL,G2H8(37),ex2(:),G2H4(52),ngPtb,m3h2x4(:,52),heltab2x8(:,:,52))
  call Hloop_VA_Q(ntryL,G1H8(48),ex2(:),G1H4(1),m3h2x4(:,53),heltab2x8(:,:,53))
  call Hloop_A_Q(ntryL,G1H4(1),19,nMT,G2H4(53),n2h4(24))
  call Hloop_ZA_Q(ntryL,G1H8(49),ex2(:),G1H4(1),ngZu,m3h2x4(:,54),heltab2x8(:,:,54))
  call Hloop_A_Q(ntryL,G1H4(1),19,nMT,G2H4(54),n2h4(25))
  call Hloop_WA_Q(ntryL,G1H8(50),ex2(:),G1H4(1),m3h2x4(:,55),heltab2x8(:,:,55))
  call Hloop_A_Q(ntryL,G1H4(1),19,nMB,G2H4(55),n2h4(26))
  call Hloop_QA_S(ntryL,G2H8(41),ex2(:),G2H4(56),ngPtb,m3h2x4(:,56),heltab2x8(:,:,56))
  call Hloop_QA_S(ntryL,G2H8(38),ex2(:),G2H4(57),ngPtb,m3h2x4(:,57),heltab2x8(:,:,57))
  call Hloop_QA_W(ntryL,G2H8(39),ex2(:),G2H4(58),m3h2x4(:,58),heltab2x8(:,:,58))
  call Hloop_QA_S(ntryL,G2H8(42),ex2(:),G2H4(59),ngPtb,m3h2x4(:,59),heltab2x8(:,:,59))
  call Hloop_QA_W(ntryL,G2H8(43),ex2(:),G2H4(60),m3h2x4(:,60),heltab2x8(:,:,60))
  call Hloop_QA_W(ntryL,G2H8(40),ex2(:),G2H4(61),m3h2x4(:,61),heltab2x8(:,:,61))
  call Hloop_QA_W(ntryL,G2H8(44),ex2(:),G2H4(62),m3h2x4(:,62),heltab2x8(:,:,62))
  call Hloop_SA_Q(ntryL,G1H8(59),ex2(:),G1H4(1),ngH,m3h2x4(:,63),heltab2x8(:,:,63))
  call Hloop_A_Q(ntryL,G1H4(1),19,nMT,G2H4(63),n2h4(27))
  call Hloop_SA_Q(ntryL,G1H8(60),ex2(:),G1H4(1),ngX,m3h2x4(:,64),heltab2x8(:,:,64))
  call Hloop_A_Q(ntryL,G1H4(1),19,nMT,G2H4(64),n2h4(28))
  call Hloop_SA_Q(ntryL,G1H8(61),ex2(:),G1H4(1),ngPtb,m3h2x4(:,65),heltab2x8(:,:,65))
  call Hloop_A_Q(ntryL,G1H4(1),19,nMB,G2H4(65),n2h4(29))
  call Hloop_QA_S(ntryL,G2H8(45),ex2(:),G2H4(66),ngPtb,m3h2x4(:,66),heltab2x8(:,:,66))
  call Hloop_VA_Q(ntryL,G1H8(62),ex2(:),G1H4(1),m3h2x4(:,67),heltab2x8(:,:,67))
  call Hloop_A_Q(ntryL,G1H4(1),19,nMT,G2H4(67),n2h4(30))
  call Hloop_ZA_Q(ntryL,G1H8(63),ex2(:),G1H4(1),ngZu,m3h2x4(:,68),heltab2x8(:,:,68))
  call Hloop_A_Q(ntryL,G1H4(1),19,nMT,G2H4(68),n2h4(31))
  call Hloop_WA_Q(ntryL,G1H8(64),ex2(:),G1H4(1),m3h2x4(:,69),heltab2x8(:,:,69))
  call Hloop_A_Q(ntryL,G1H4(1),19,nMB,G2H4(69),n2h4(32))
  call Hloop_QA_S(ntryL,G2H8(49),ex2(:),G2H4(70),ngPtb,m3h2x4(:,70),heltab2x8(:,:,70))
  call Hloop_QA_S(ntryL,G2H8(46),ex2(:),G2H4(71),ngPtb,m3h2x4(:,71),heltab2x8(:,:,71))
  call Hloop_QA_W(ntryL,G2H8(47),ex2(:),G2H4(72),m3h2x4(:,72),heltab2x8(:,:,72))
  call Hloop_QA_S(ntryL,G2H8(50),ex2(:),G2H4(73),ngPtb,m3h2x4(:,73),heltab2x8(:,:,73))
  call Hloop_QA_W(ntryL,G2H8(51),ex2(:),G2H4(74),m3h2x4(:,74),heltab2x8(:,:,74))
  call Hloop_QA_W(ntryL,G2H8(48),ex2(:),G2H4(75),m3h2x4(:,75),heltab2x8(:,:,75))
  call Hloop_QA_W(ntryL,G2H8(52),ex2(:),G2H4(76),m3h2x4(:,76),heltab2x8(:,:,76))
  call Hloop_TV_S(ntryL,G1H8(73),18,ex3(:),4,G2H4(77),m3h2x4(:,77),heltab2x8(:,:,77))
  call Hotf_5pt_reduction(G2H8(53),RedSet_5(3),mass5set(:,2),  & 
G1H8(93),G1H8(92),G1H8(96),G1H8(95),G1H8(99),G1H8(98),8)
  call HG1shiftOLR(G1H8(92),8,8)
  call Hloop_VV_S(ntryL,G1H8(74),ex3(:),G1H4(1),m3h2x4(:,78),heltab2x8(:,:,78))
  call Hloop_SV_V(ntryL,G1H8(75),ex3(:),G1H4(2),m3h2x4(:,79),heltab2x8(:,:,79))
  call Hotf_5pt_reduction(G2H8(55),RedSet_5(3),mass5set(:,2),  & 
G1H8(111),G1H8(110),G1H8(114),G1H8(113),G1H8(117),G1H8(116),8)
  call HG1shiftOLR(G1H8(110),8,8)
  call Hotf_5pt_reduction(G2H8(54),RedSet_5(3),mass5set(:,2),  & 
G1H8(3),G1H8(5),G1H8(7),G1H8(8),G1H8(9),G1H8(10),8)
  call HG1shiftOLR(G1H8(5),8,8)
  call Hloop_UV_W(ntryL,G1H8(78),18,ex3(:),4,G2H4(78),m3h2x4(:,80),heltab2x8(:,:,80))
  call Hotf_5pt_reduction(G2H8(56),RedSet_5(3),mass5set(:,2),  & 
G1H8(11),G1H8(12),G1H8(13),G1H8(14),G1H8(25),G1H8(26),8)
  call HG1shiftOLR(G1H8(12),8,8)
  call Hloop_TV_S(ntryL,G1H8(81),18,ex4(:),8,G2H4(79),m3h2x4(:,81),heltab2x8(:,:,81))
  call Hotf_5pt_reduction(G2H8(57),RedSet_5(4),mass5set(:,2),  & 
G1H8(29),G1H8(30),G1H8(31),G1H8(32),G1H8(33),G1H8(34),8)
  call HG1shiftOLR(G1H8(30),4,8)
  call Hloop_VV_S(ntryL,G1H8(82),ex4(:),G1H4(3),m3h2x4(:,82),heltab2x8(:,:,82))
  call Hloop_SV_V(ntryL,G1H8(83),ex4(:),G1H4(4),m3h2x4(:,83),heltab2x8(:,:,83))
  call Hotf_5pt_reduction(G2H8(59),RedSet_5(4),mass5set(:,2),  & 
G1H8(35),G1H8(36),G1H8(45),G1H8(46),G1H8(47),G1H8(48),8)
  call HG1shiftOLR(G1H8(36),4,8)
  call Hotf_5pt_reduction(G2H8(58),RedSet_5(4),mass5set(:,2),  & 
G1H8(49),G1H8(50),G1H8(59),G1H8(60),G1H8(61),G1H8(62),8)
  call HG1shiftOLR(G1H8(50),4,8)
  call Hloop_UV_W(ntryL,G1H8(86),18,ex4(:),8,G2H4(80),m3h2x4(:,84),heltab2x8(:,:,84))
  call Hotf_5pt_reduction(G2H8(60),RedSet_5(4),mass5set(:,2),  & 
G1H8(63),G1H8(64),G1H8(73),G1H8(74),G1H8(75),G1H8(78),8)
  call HG1shiftOLR(G1H8(64),4,8)
  call Hloop_SV_T(ntryL,G1H8(89),17,ex3(:),4,G2H4(81),m3h2x4(:,85),heltab2x8(:,:,85))
  call Hotf_5pt_reduction(G2H8(61),RedSet_5(5),mass5set(:,2),  & 
G1H8(81),G1H8(82),G1H8(83),G1H8(86),G1H8(89),G1H8(125),8)
  call HG1shiftOLR(G1H8(82),8,8)
  call Hloop_SV_V(ntryL,G1H8(90),ex3(:),G1H4(5),m3h2x4(:,86),heltab2x8(:,:,86))
  call Hloop_VV_S(ntryL,G1H8(91),ex3(:),G1H4(6),m3h2x4(:,87),heltab2x8(:,:,87))
  call Hotf_5pt_reduction(G2H8(63),RedSet_5(5),mass5set(:,2),  & 
G1H8(90),G1H8(91),G1H8(126),G1H8(127),G1H8(128),G1H8(129),8)
  call HG1shiftOLR(G1H8(91),8,8)
  call Hotf_5pt_reduction(G2H8(62),RedSet_5(5),mass5set(:,2),  & 
G1H8(130),G1H8(131),G1H8(132),G1H8(133),G1H8(134),G1H8(135),8)
  call HG1shiftOLR(G1H8(131),8,8)
  call Hloop_UW_V(ntryL,G1H8(94),17,ex3(:),4,G2H4(82),m3h2x4(:,88),heltab2x8(:,:,88))
  call Hotf_5pt_reduction(G2H8(64),RedSet_5(5),mass5set(:,2),  & 
G1H8(94),G1H8(136),G1H8(137),G1H8(138),G1H8(139),G1H8(140),8)
  call HG1shiftOLR(G1H8(136),8,8)
  call Hotf_5pt_reduction(G2H8(65),RedSet_5(6),mass5set(:,3),  & 
G1H8(141),G1H8(142),G1H8(143),G1H8(144),G1H8(145),G1H8(146),8)
  call HG1shiftOLR(G1H8(142),2,8)
  call Hloop_SV_T(ntryL,G1H8(97),17,ex3(:),4,G2H4(83),m3h2x4(:,89),heltab2x8(:,:,89))
  call Hotf_5pt_reduction(G2H8(66),RedSet_5(6),mass5set(:,3),  & 
G1H8(97),G1H8(147),G1H8(148),G1H8(149),G1H8(150),G1H8(151),8)
  call HG1shiftOLR(G1H8(147),2,8)
  call Hloop_SV_V(ntryL,G1H8(100),ex3(:),G1H4(7),m3h2x4(:,90),heltab2x8(:,:,90))
  call Hloop_SV_T(ntryL,G1H8(101),17,ex3(:),4,G2H4(84),m3h2x4(:,91),heltab2x8(:,:,91))
  call Hloop_VV_S(ntryL,G1H8(102),ex3(:),G1H4(8),m3h2x4(:,92),heltab2x8(:,:,92))
  call Hloop_SV_V(ntryL,G1H8(103),ex3(:),G1H4(9),m3h2x4(:,93),heltab2x8(:,:,93))
  call Hloop_UW_V(ntryL,G1H8(104),17,ex3(:),4,G2H4(85),m3h2x4(:,94),heltab2x8(:,:,94))
  call Hloop_VV_S(ntryL,G1H8(105),ex3(:),G1H4(10),m3h2x4(:,95),heltab2x8(:,:,95))
  call Hloop_UW_V(ntryL,G1H8(106),17,ex3(:),4,G2H4(86),m3h2x4(:,96),heltab2x8(:,:,96))
  call Hloop_SV_T(ntryL,G1H8(107),17,ex4(:),8,G2H4(87),m3h2x4(:,97),heltab2x8(:,:,97))
  call Hotf_5pt_reduction(G2H8(67),RedSet_5(7),mass5set(:,2),  & 
G1H8(100),G1H8(101),G1H8(102),G1H8(103),G1H8(104),G1H8(105),8)
  call HG1shiftOLR(G1H8(101),4,8)
  call Hloop_SV_V(ntryL,G1H8(108),ex4(:),G1H4(11),m3h2x4(:,98),heltab2x8(:,:,98))
  call Hloop_VV_S(ntryL,G1H8(109),ex4(:),G1H4(12),m3h2x4(:,99),heltab2x8(:,:,99))
  call Hotf_5pt_reduction(G2H8(69),RedSet_5(7),mass5set(:,2),  & 
G1H8(106),G1H8(107),G1H8(108),G1H8(109),G1H8(152),G1H8(153),8)
  call HG1shiftOLR(G1H8(107),4,8)
  call Hotf_5pt_reduction(G2H8(68),RedSet_5(7),mass5set(:,2),  & 
G1H8(154),G1H8(155),G1H8(156),G1H8(157),G1H8(158),G1H8(159),8)
  call HG1shiftOLR(G1H8(155),4,8)
  call Hloop_UW_V(ntryL,G1H8(112),17,ex4(:),8,G2H4(88),m3h2x4(:,100),heltab2x8(:,:,100))
  call Hotf_5pt_reduction(G2H8(70),RedSet_5(7),mass5set(:,2),  & 
G1H8(112),G1H8(160),G1H8(161),G1H8(162),G1H8(163),G1H8(164),8)
  call HG1shiftOLR(G1H8(160),4,8)
  call Hotf_5pt_reduction(G2H8(71),RedSet_5(8),mass5set(:,3),  & 
G1H8(165),G1H8(166),G1H8(167),G1H8(168),G1H8(169),G1H8(170),8)
  call HG1shiftOLR(G1H8(166),2,8)
  call Hloop_SV_T(ntryL,G1H8(115),17,ex4(:),8,G2H4(89),m3h2x4(:,101),heltab2x8(:,:,101))
  call Hotf_5pt_reduction(G2H8(72),RedSet_5(8),mass5set(:,3),  & 
G1H8(115),G1H8(171),G1H8(172),G1H8(173),G1H8(174),G1H8(175),8)
  call HG1shiftOLR(G1H8(171),2,8)
  call Hloop_SV_V(ntryL,G1H8(118),ex4(:),G1H4(13),m3h2x4(:,102),heltab2x8(:,:,102))
  call Hloop_SV_T(ntryL,G1H8(119),17,ex4(:),8,G2H4(90),m3h2x4(:,103),heltab2x8(:,:,103))
  call Hloop_VV_S(ntryL,G1H8(120),ex4(:),G1H4(14),m3h2x4(:,104),heltab2x8(:,:,104))
  call Hloop_SV_V(ntryL,G1H8(121),ex4(:),G1H4(15),m3h2x4(:,105),heltab2x8(:,:,105))
  call Hloop_UW_V(ntryL,G1H8(122),17,ex4(:),8,G2H4(91),m3h2x4(:,106),heltab2x8(:,:,106))
  call Hloop_VV_S(ntryL,G1H8(123),ex4(:),G1H4(16),m3h2x4(:,107),heltab2x8(:,:,107))
  call Hloop_UW_V(ntryL,G1H8(124),17,ex4(:),8,G2H4(92),m3h2x4(:,108),heltab2x8(:,:,108))
  call Hloop_SQ_A(ntryL,G1H8(1),ex1(:),G1H4(17),ngPbt,m3h2x4(:,109),heltab2x8(:,:,109))
  call Hloop_Q_A(ntryL,G1H4(17),21,nMB,G2H4(93),n2h4(33))
call HGT_OLR(G1H8(2),1,1,8)
call HGT_invQ_OLR(G1H8(2),2,5,8)
  call Hloop_SV_T(ntryL,G1H8(2),-8,ex4(:),8,G2H4(94),m3h2x4(:,110),heltab2x8(:,:,110))
  call Hloop_SQ_A(ntryL,G1H8(6),ex1(:),G1H4(17),ngPbt,m3h2x4(:,111),heltab2x8(:,:,111))
  call Hloop_Q_A(ntryL,G1H4(17),21,nMB,G2H4(95),n2h4(34))
  call Hloop_SQ_A(ntryL,G1H8(16),ex1(:),G1H4(17),ngPbt,m3h2x4(:,112),heltab2x8(:,:,112))
  call Hloop_Q_A(ntryL,G1H4(17),21,nMB,G2H4(96),n2h4(35))
  call Hloop_SQ_A(ntryL,G1H8(15),ex1(:),G1H4(17),ngPbt,m3h2x4(:,113),heltab2x8(:,:,113))
  call Hloop_Q_A(ntryL,G1H4(17),21,nMB,G2H4(97),n2h4(36))
  call Hloop_SQ_A(ntryL,G1H8(18),ex1(:),G1H4(17),ngPbt,m3h2x4(:,114),heltab2x8(:,:,114))
  call Hloop_Q_A(ntryL,G1H4(17),21,nMB,G2H4(98),n2h4(37))
call HGT_OLR(G1H8(20),1,1,8)
call HGT_invQ_OLR(G1H8(20),2,5,8)
  call Hloop_SV_V(ntryL,G1H8(20),ex4(:),G1H4(17),m3h2x4(:,115),heltab2x8(:,:,115))
  call Hloop_SQ_A(ntryL,G1H8(19),ex1(:),G1H4(18),ngPbt,m3h2x4(:,116),heltab2x8(:,:,116))
  call Hloop_Q_A(ntryL,G1H4(18),21,nMB,G2H4(99),n2h4(38))
  call Hloop_SQ_A(ntryL,G1H8(22),ex1(:),G1H4(18),ngPbt,m3h2x4(:,117),heltab2x8(:,:,117))
  call Hloop_Q_A(ntryL,G1H4(18),21,nMB,G2H4(100),n2h4(39))
  call Hloop_SQ_A(ntryL,G1H8(21),ex1(:),G1H4(18),ngPbt,m3h2x4(:,118),heltab2x8(:,:,118))
  call Hloop_Q_A(ntryL,G1H4(18),21,nMB,G2H4(101),n2h4(40))
  call Hloop_WQ_A(ntryL,G1H8(23),ex1(:),G1H4(18),m3h2x4(:,119),heltab2x8(:,:,119))
  call Hloop_Q_A(ntryL,G1H4(18),21,nMB,G2H4(102),n2h4(41))
call HGT_raise_alpha_OLR(G1H8(24),1,1,8)
call HGT_raise_alpha_invQ_OLR(G1H8(24),2,5,8)
  call Hloop_VV_S(ntryL,G1H8(24),ex4(:),G1H4(18),m3h2x4(:,120),heltab2x8(:,:,120))
  call Hloop_WQ_A(ntryL,G1H8(28),ex1(:),G1H4(19),m3h2x4(:,121),heltab2x8(:,:,121))
  call Hloop_Q_A(ntryL,G1H4(19),21,nMB,G2H4(103),n2h4(42))
  call Hloop_WQ_A(ntryL,G1H8(38),ex1(:),G1H4(19),m3h2x4(:,122),heltab2x8(:,:,122))
  call Hloop_Q_A(ntryL,G1H4(19),21,nMB,G2H4(104),n2h4(43))
  call Hloop_WQ_A(ntryL,G1H8(37),ex1(:),G1H4(19),m3h2x4(:,123),heltab2x8(:,:,123))
  call Hloop_Q_A(ntryL,G1H4(19),21,nMB,G2H4(105),n2h4(44))
  call Hloop_WQ_A(ntryL,G1H8(40),ex1(:),G1H4(19),m3h2x4(:,124),heltab2x8(:,:,124))
  call Hloop_Q_A(ntryL,G1H4(19),21,nMB,G2H4(106),n2h4(45))
call HGT_raise_alpha_OLR(G1H8(42),1,1,8)
call HGT_raise_alpha_invQ_OLR(G1H8(42),2,5,8)
  call Hloop_UW_V(ntryL,G1H8(42),-8,ex4(:),8,G2H4(107),m3h2x4(:,125),heltab2x8(:,:,125))
  call Hloop_WQ_A(ntryL,G1H8(41),ex1(:),G1H4(19),m3h2x4(:,126),heltab2x8(:,:,126))
  call Hloop_Q_A(ntryL,G1H4(19),21,nMB,G2H4(108),n2h4(46))
  call Hloop_WQ_A(ntryL,G1H8(44),ex1(:),G1H4(19),m3h2x4(:,127),heltab2x8(:,:,127))
  call Hloop_Q_A(ntryL,G1H4(19),21,nMB,G2H4(109),n2h4(47))
  call Hloop_WQ_A(ntryL,G1H8(43),ex1(:),G1H4(19),m3h2x4(:,128),heltab2x8(:,:,128))
  call Hloop_Q_A(ntryL,G1H4(19),21,nMB,G2H4(110),n2h4(48))
  call Hloop_SA_Q(ntryL,G1H8(52),ex2(:),G1H4(19),ngPtb,m3h2x4(:,129),heltab2x8(:,:,129))
  call Hloop_A_Q(ntryL,G1H4(19),22,nMB,G2H4(111),n2h4(49))
call HGT_OLR(G1H8(51),1,1,8)
call HGT_invQ_OLR(G1H8(51),2,5,8)
  call Hloop_TV_S(ntryL,G1H8(51),-8,ex4(:),8,G2H4(112),m3h2x4(:,130),heltab2x8(:,:,130))
  call Hloop_SA_Q(ntryL,G1H8(56),ex2(:),G1H4(19),ngPtb,m3h2x4(:,131),heltab2x8(:,:,131))
  call Hloop_A_Q(ntryL,G1H4(19),22,nMB,G2H4(113),n2h4(50))
  call Hloop_SA_Q(ntryL,G1H8(53),ex2(:),G1H4(19),ngPtb,m3h2x4(:,132),heltab2x8(:,:,132))
  call Hloop_A_Q(ntryL,G1H4(19),22,nMB,G2H4(114),n2h4(51))
  call Hloop_SA_Q(ntryL,G1H8(54),ex2(:),G1H4(19),ngPtb,m3h2x4(:,133),heltab2x8(:,:,133))
  call Hloop_A_Q(ntryL,G1H4(19),22,nMB,G2H4(115),n2h4(52))
  call Hloop_SA_Q(ntryL,G1H8(58),ex2(:),G1H4(19),ngPtb,m3h2x4(:,134),heltab2x8(:,:,134))
  call Hloop_A_Q(ntryL,G1H4(19),22,nMB,G2H4(116),n2h4(53))
call HGT_OLR(G1H8(57),1,1,8)
call HGT_invQ_OLR(G1H8(57),2,5,8)
  call Hloop_SV_V(ntryL,G1H8(57),ex4(:),G1H4(19),m3h2x4(:,135),heltab2x8(:,:,135))
  call Hloop_SA_Q(ntryL,G1H8(65),ex2(:),G1H4(20),ngPtb,m3h2x4(:,136),heltab2x8(:,:,136))
  call Hloop_A_Q(ntryL,G1H4(20),22,nMB,G2H4(117),n2h4(54))
  call Hloop_SA_Q(ntryL,G1H8(69),ex2(:),G1H4(20),ngPtb,m3h2x4(:,137),heltab2x8(:,:,137))
  call Hloop_A_Q(ntryL,G1H4(20),22,nMB,G2H4(118),n2h4(55))
  call Hloop_SA_Q(ntryL,G1H8(70),ex2(:),G1H4(20),ngPtb,m3h2x4(:,138),heltab2x8(:,:,138))
  call Hloop_A_Q(ntryL,G1H4(20),22,nMB,G2H4(119),n2h4(56))
  call Hloop_WA_Q(ntryL,G1H8(67),ex2(:),G1H4(20),m3h2x4(:,139),heltab2x8(:,:,139))
  call Hloop_A_Q(ntryL,G1H4(20),22,nMB,G2H4(120),n2h4(57))
call HGT_raise_alpha_OLR(G1H8(68),1,1,8)
call HGT_raise_alpha_invQ_OLR(G1H8(68),2,5,8)
  call Hloop_VV_S(ntryL,G1H8(68),ex4(:),G1H4(20),m3h2x4(:,140),heltab2x8(:,:,140))
  call Hloop_WA_Q(ntryL,G1H8(71),ex2(:),G1H4(21),m3h2x4(:,141),heltab2x8(:,:,141))
  call Hloop_A_Q(ntryL,G1H4(21),22,nMB,G2H4(121),n2h4(58))
  call Hloop_WA_Q(ntryL,G1H8(77),ex2(:),G1H4(21),m3h2x4(:,142),heltab2x8(:,:,142))
  call Hloop_A_Q(ntryL,G1H4(21),22,nMB,G2H4(122),n2h4(59))
  call Hloop_WA_Q(ntryL,G1H8(76),ex2(:),G1H4(21),m3h2x4(:,143),heltab2x8(:,:,143))
  call Hloop_A_Q(ntryL,G1H4(21),22,nMB,G2H4(123),n2h4(60))
  call Hloop_WA_Q(ntryL,G1H8(80),ex2(:),G1H4(21),m3h2x4(:,144),heltab2x8(:,:,144))
  call Hloop_A_Q(ntryL,G1H4(21),22,nMB,G2H4(124),n2h4(61))
call HGT_raise_alpha_OLR(G1H8(79),1,1,8)
call HGT_raise_alpha_invQ_OLR(G1H8(79),2,5,8)
  call Hloop_UV_W(ntryL,G1H8(79),-8,ex4(:),8,G2H4(125),m3h2x4(:,145),heltab2x8(:,:,145))
  call Hloop_WA_Q(ntryL,G1H8(84),ex2(:),G1H4(21),m3h2x4(:,146),heltab2x8(:,:,146))
  call Hloop_A_Q(ntryL,G1H4(21),22,nMB,G2H4(126),n2h4(62))
  call Hloop_WA_Q(ntryL,G1H8(88),ex2(:),G1H4(21),m3h2x4(:,147),heltab2x8(:,:,147))
  call Hloop_A_Q(ntryL,G1H4(21),22,nMB,G2H4(127),n2h4(63))
  call Hloop_WA_Q(ntryL,G1H8(87),ex2(:),G1H4(21),m3h2x4(:,148),heltab2x8(:,:,148))
  call Hloop_A_Q(ntryL,G1H4(21),22,nMB,G2H4(128),n2h4(64))
  call Hloop_AV_Q(ntryL,G1H8(93),ex3(:),G1H4(21),m3h2x4(:,149),heltab2x8(:,:,149))
  call Hloop_A_Q(ntryL,G1H4(21),22,nMB,G2H4(129),n2h4(65))
call HGT_OLR(G1H8(92),1,1,8)
call HGT_invQ_OLR(G1H8(92),2,5,8)
  call Hloop_TV_S(ntryL,G1H8(92),-8,ex4(:),8,G2H4(130),m3h2x4(:,150),heltab2x8(:,:,150))
  call Hloop_AV_Q(ntryL,G1H8(95),ex3(:),G1H4(21),m3h2x4(:,151),heltab2x8(:,:,151))
  call Hloop_A_Q(ntryL,G1H4(21),22,nMB,G2H4(131),n2h4(66))
  call Hloop_AV_Q(ntryL,G1H8(99),ex3(:),G1H4(21),m3h2x4(:,152),heltab2x8(:,:,152))
  call Hloop_A_Q(ntryL,G1H4(21),22,nMB,G2H4(132),n2h4(67))
  call Hloop_AV_Q(ntryL,G1H8(98),ex3(:),G1H4(21),m3h2x4(:,153),heltab2x8(:,:,153))
  call Hloop_A_Q(ntryL,G1H4(21),22,nMB,G2H4(133),n2h4(68))
  call Hloop_AV_Q(ntryL,G1H8(111),ex3(:),G1H4(21),m3h2x4(:,154),heltab2x8(:,:,154))
  call Hloop_A_Q(ntryL,G1H4(21),22,nMB,G2H4(134),n2h4(69))
call HGT_raise_alpha_OLR(G1H8(110),1,1,8)
call HGT_raise_alpha_invQ_OLR(G1H8(110),2,5,8)
  call Hloop_VV_S(ntryL,G1H8(110),ex4(:),G1H4(21),m3h2x4(:,155),heltab2x8(:,:,155))
  call Hloop_AV_Q(ntryL,G1H8(113),ex3(:),G1H4(22),m3h2x4(:,156),heltab2x8(:,:,156))
  call Hloop_A_Q(ntryL,G1H4(22),22,nMB,G2H4(135),n2h4(70))
  call Hloop_AV_Q(ntryL,G1H8(117),ex3(:),G1H4(22),m3h2x4(:,157),heltab2x8(:,:,157))
  call Hloop_A_Q(ntryL,G1H4(22),22,nMB,G2H4(136),n2h4(71))
  call Hloop_AV_Q(ntryL,G1H8(116),ex3(:),G1H4(22),m3h2x4(:,158),heltab2x8(:,:,158))
  call Hloop_A_Q(ntryL,G1H4(22),22,nMB,G2H4(137),n2h4(72))
  call Hloop_AV_Q(ntryL,G1H8(3),ex3(:),G1H4(22),m3h2x4(:,159),heltab2x8(:,:,159))
  call Hloop_A_Q(ntryL,G1H4(22),22,nMB,G2H4(138),n2h4(73))
call HGT_OLR(G1H8(5),1,1,8)
call HGT_invQ_OLR(G1H8(5),2,5,8)
  call Hloop_SV_V(ntryL,G1H8(5),ex4(:),G1H4(22),m3h2x4(:,160),heltab2x8(:,:,160))
  call Hloop_AV_Q(ntryL,G1H8(8),ex3(:),G1H4(23),m3h2x4(:,161),heltab2x8(:,:,161))
  call Hloop_A_Q(ntryL,G1H4(23),22,nMB,G2H4(139),n2h4(74))
  call Hloop_AV_Q(ntryL,G1H8(9),ex3(:),G1H4(23),m3h2x4(:,162),heltab2x8(:,:,162))
  call Hloop_A_Q(ntryL,G1H4(23),22,nMB,G2H4(140),n2h4(75))
  call Hloop_AV_Q(ntryL,G1H8(10),ex3(:),G1H4(23),m3h2x4(:,163),heltab2x8(:,:,163))
  call Hloop_A_Q(ntryL,G1H4(23),22,nMB,G2H4(141),n2h4(76))
  call Hloop_AV_Q(ntryL,G1H8(11),ex3(:),G1H4(23),m3h2x4(:,164),heltab2x8(:,:,164))
  call Hloop_A_Q(ntryL,G1H4(23),22,nMB,G2H4(142),n2h4(77))
call HGT_raise_alpha_OLR(G1H8(12),1,1,8)
call HGT_raise_alpha_invQ_OLR(G1H8(12),2,5,8)
  call Hloop_UV_W(ntryL,G1H8(12),-8,ex4(:),8,G2H4(143),m3h2x4(:,165),heltab2x8(:,:,165))
  call Hloop_AV_Q(ntryL,G1H8(14),ex3(:),G1H4(23),m3h2x4(:,166),heltab2x8(:,:,166))
  call Hloop_A_Q(ntryL,G1H4(23),22,nMB,G2H4(144),n2h4(78))
  call Hloop_AV_Q(ntryL,G1H8(25),ex3(:),G1H4(23),m3h2x4(:,167),heltab2x8(:,:,167))
  call Hloop_A_Q(ntryL,G1H4(23),22,nMB,G2H4(145),n2h4(79))
  call Hloop_AV_Q(ntryL,G1H8(26),ex3(:),G1H4(23),m3h2x4(:,168),heltab2x8(:,:,168))
  call Hloop_A_Q(ntryL,G1H4(23),22,nMB,G2H4(146),n2h4(80))
  call Hloop_AV_Q(ntryL,G1H8(29),ex4(:),G1H4(23),m3h2x4(:,169),heltab2x8(:,:,169))
  call Hloop_A_Q(ntryL,G1H4(23),26,nMB,G2H4(147),n2h4(81))
call HGT_OLR(G1H8(30),1,1,8)
call HGT_invQ_OLR(G1H8(30),2,5,8)
  call Hloop_TV_S(ntryL,G1H8(30),-4,ex3(:),4,G2H4(148),m3h2x4(:,170),heltab2x8(:,:,170))
  call Hloop_AV_Q(ntryL,G1H8(32),ex4(:),G1H4(23),m3h2x4(:,171),heltab2x8(:,:,171))
  call Hloop_A_Q(ntryL,G1H4(23),26,nMB,G2H4(149),n2h4(82))
  call Hloop_AV_Q(ntryL,G1H8(33),ex4(:),G1H4(23),m3h2x4(:,172),heltab2x8(:,:,172))
  call Hloop_A_Q(ntryL,G1H4(23),26,nMB,G2H4(150),n2h4(83))
  call Hloop_AV_Q(ntryL,G1H8(34),ex4(:),G1H4(23),m3h2x4(:,173),heltab2x8(:,:,173))
  call Hloop_A_Q(ntryL,G1H4(23),26,nMB,G2H4(151),n2h4(84))
  call Hloop_AV_Q(ntryL,G1H8(35),ex4(:),G1H4(23),m3h2x4(:,174),heltab2x8(:,:,174))
  call Hloop_A_Q(ntryL,G1H4(23),26,nMB,G2H4(152),n2h4(85))
call HGT_raise_alpha_OLR(G1H8(36),1,1,8)
call HGT_raise_alpha_invQ_OLR(G1H8(36),2,5,8)
  call Hloop_VV_S(ntryL,G1H8(36),ex3(:),G1H4(23),m3h2x4(:,175),heltab2x8(:,:,175))
  call Hloop_AV_Q(ntryL,G1H8(46),ex4(:),G1H4(24),m3h2x4(:,176),heltab2x8(:,:,176))
  call Hloop_A_Q(ntryL,G1H4(24),26,nMB,G2H4(153),n2h4(86))
  call Hloop_AV_Q(ntryL,G1H8(47),ex4(:),G1H4(24),m3h2x4(:,177),heltab2x8(:,:,177))
  call Hloop_A_Q(ntryL,G1H4(24),26,nMB,G2H4(154),n2h4(87))
  call Hloop_AV_Q(ntryL,G1H8(48),ex4(:),G1H4(24),m3h2x4(:,178),heltab2x8(:,:,178))
  call Hloop_A_Q(ntryL,G1H4(24),26,nMB,G2H4(155),n2h4(88))
  call Hloop_AV_Q(ntryL,G1H8(49),ex4(:),G1H4(24),m3h2x4(:,179),heltab2x8(:,:,179))
  call Hloop_A_Q(ntryL,G1H4(24),26,nMB,G2H4(156),n2h4(89))
call HGT_OLR(G1H8(50),1,1,8)
call HGT_invQ_OLR(G1H8(50),2,5,8)
  call Hloop_SV_V(ntryL,G1H8(50),ex3(:),G1H4(24),m3h2x4(:,180),heltab2x8(:,:,180))
  call Hloop_AV_Q(ntryL,G1H8(60),ex4(:),G1H4(25),m3h2x4(:,181),heltab2x8(:,:,181))
  call Hloop_A_Q(ntryL,G1H4(25),26,nMB,G2H4(157),n2h4(90))
  call Hloop_AV_Q(ntryL,G1H8(61),ex4(:),G1H4(25),m3h2x4(:,182),heltab2x8(:,:,182))
  call Hloop_A_Q(ntryL,G1H4(25),26,nMB,G2H4(158),n2h4(91))
  call Hloop_AV_Q(ntryL,G1H8(62),ex4(:),G1H4(25),m3h2x4(:,183),heltab2x8(:,:,183))
  call Hloop_A_Q(ntryL,G1H4(25),26,nMB,G2H4(159),n2h4(92))
  call Hloop_AV_Q(ntryL,G1H8(63),ex4(:),G1H4(25),m3h2x4(:,184),heltab2x8(:,:,184))
  call Hloop_A_Q(ntryL,G1H4(25),26,nMB,G2H4(160),n2h4(93))
call HGT_raise_alpha_OLR(G1H8(64),1,1,8)
call HGT_raise_alpha_invQ_OLR(G1H8(64),2,5,8)
  call Hloop_UV_W(ntryL,G1H8(64),-4,ex3(:),4,G2H4(161),m3h2x4(:,185),heltab2x8(:,:,185))
  call Hloop_AV_Q(ntryL,G1H8(74),ex4(:),G1H4(25),m3h2x4(:,186),heltab2x8(:,:,186))
  call Hloop_A_Q(ntryL,G1H4(25),26,nMB,G2H4(162),n2h4(94))
  call Hloop_AV_Q(ntryL,G1H8(75),ex4(:),G1H4(25),m3h2x4(:,187),heltab2x8(:,:,187))
  call Hloop_A_Q(ntryL,G1H4(25),26,nMB,G2H4(163),n2h4(95))
  call Hloop_AV_Q(ntryL,G1H8(78),ex4(:),G1H4(25),m3h2x4(:,188),heltab2x8(:,:,188))
  call Hloop_A_Q(ntryL,G1H4(25),26,nMB,G2H4(164),n2h4(96))
  call Hloop_QV_A(ntryL,G1H8(81),ex3(:),G1H4(25),m3h2x4(:,189),heltab2x8(:,:,189))
  call Hloop_Q_A(ntryL,G1H4(25),21,nMB,G2H4(165),n2h4(97))
call HGT_OLR(G1H8(82),1,1,8)
call HGT_invQ_OLR(G1H8(82),2,5,8)
  call Hloop_SV_T(ntryL,G1H8(82),-8,ex4(:),8,G2H4(166),m3h2x4(:,190),heltab2x8(:,:,190))
  call Hloop_QV_A(ntryL,G1H8(86),ex3(:),G1H4(25),m3h2x4(:,191),heltab2x8(:,:,191))
  call Hloop_Q_A(ntryL,G1H4(25),21,nMB,G2H4(167),n2h4(98))
  call Hloop_QV_A(ntryL,G1H8(89),ex3(:),G1H4(25),m3h2x4(:,192),heltab2x8(:,:,192))
  call Hloop_Q_A(ntryL,G1H4(25),21,nMB,G2H4(168),n2h4(99))
  call Hloop_QV_A(ntryL,G1H8(125),ex3(:),G1H4(25),m3h2x4(:,193),heltab2x8(:,:,193))
  call Hloop_Q_A(ntryL,G1H4(25),21,nMB,G2H4(169),n2h4(100))
  call Hloop_QV_A(ntryL,G1H8(90),ex3(:),G1H4(25),m3h2x4(:,194),heltab2x8(:,:,194))
  call Hloop_Q_A(ntryL,G1H4(25),21,nMB,G2H4(170),n2h4(101))
call HGT_raise_alpha_OLR(G1H8(91),1,1,8)
call HGT_raise_alpha_invQ_OLR(G1H8(91),2,5,8)
  call Hloop_VV_S(ntryL,G1H8(91),ex4(:),G1H4(25),m3h2x4(:,195),heltab2x8(:,:,195))
  call Hloop_QV_A(ntryL,G1H8(127),ex3(:),G1H4(26),m3h2x4(:,196),heltab2x8(:,:,196))
  call Hloop_Q_A(ntryL,G1H4(26),21,nMB,G2H4(171),n2h4(102))
  call Hloop_QV_A(ntryL,G1H8(128),ex3(:),G1H4(26),m3h2x4(:,197),heltab2x8(:,:,197))
  call Hloop_Q_A(ntryL,G1H4(26),21,nMB,G2H4(172),n2h4(103))
  call Hloop_QV_A(ntryL,G1H8(129),ex3(:),G1H4(26),m3h2x4(:,198),heltab2x8(:,:,198))
  call Hloop_Q_A(ntryL,G1H4(26),21,nMB,G2H4(173),n2h4(104))
  call Hloop_QV_A(ntryL,G1H8(130),ex3(:),G1H4(26),m3h2x4(:,199),heltab2x8(:,:,199))
  call Hloop_Q_A(ntryL,G1H4(26),21,nMB,G2H4(174),n2h4(105))
call HGT_OLR(G1H8(131),1,1,8)
call HGT_invQ_OLR(G1H8(131),2,5,8)
  call Hloop_SV_V(ntryL,G1H8(131),ex4(:),G1H4(26),m3h2x4(:,200),heltab2x8(:,:,200))
  call Hloop_QV_A(ntryL,G1H8(133),ex3(:),G1H4(27),m3h2x4(:,201),heltab2x8(:,:,201))
  call Hloop_Q_A(ntryL,G1H4(27),21,nMB,G2H4(175),n2h4(106))
  call Hloop_QV_A(ntryL,G1H8(134),ex3(:),G1H4(27),m3h2x4(:,202),heltab2x8(:,:,202))
  call Hloop_Q_A(ntryL,G1H4(27),21,nMB,G2H4(176),n2h4(107))
  call Hloop_QV_A(ntryL,G1H8(135),ex3(:),G1H4(27),m3h2x4(:,203),heltab2x8(:,:,203))
  call Hloop_Q_A(ntryL,G1H4(27),21,nMB,G2H4(177),n2h4(108))
  call Hloop_QV_A(ntryL,G1H8(94),ex3(:),G1H4(27),m3h2x4(:,204),heltab2x8(:,:,204))
  call Hloop_Q_A(ntryL,G1H4(27),21,nMB,G2H4(178),n2h4(109))
call HGT_raise_alpha_OLR(G1H8(136),1,1,8)
call HGT_raise_alpha_invQ_OLR(G1H8(136),2,5,8)
  call Hloop_UW_V(ntryL,G1H8(136),-8,ex4(:),8,G2H4(179),m3h2x4(:,205),heltab2x8(:,:,205))
  call Hloop_QV_A(ntryL,G1H8(138),ex3(:),G1H4(27),m3h2x4(:,206),heltab2x8(:,:,206))
  call Hloop_Q_A(ntryL,G1H4(27),21,nMB,G2H4(180),n2h4(110))
  call Hloop_QV_A(ntryL,G1H8(139),ex3(:),G1H4(27),m3h2x4(:,207),heltab2x8(:,:,207))
  call Hloop_Q_A(ntryL,G1H4(27),21,nMB,G2H4(181),n2h4(111))
  call Hloop_QV_A(ntryL,G1H8(140),ex3(:),G1H4(27),m3h2x4(:,208),heltab2x8(:,:,208))
  call Hloop_Q_A(ntryL,G1H4(27),21,nMB,G2H4(182),n2h4(112))
  call Hloop_QV_A(ntryL,G1H8(141),ex3(:),G1H4(27),m3h2x4(:,209),heltab2x8(:,:,209))
  call Hloop_Q_A(ntryL,G1H4(27),21,nMB,G2H4(183),n2h4(113))
call HGT_OLR(G1H8(142),1,1,8)
call HGT_invQ_OLR(G1H8(142),2,5,8)
  call Hloop_SA_Q(ntryL,G1H8(142),ex2(:),G1H4(27),ngPtb,m3h2x4(:,210),heltab2x8(:,:,210))
  call Hloop_QV_A(ntryL,G1H8(144),ex3(:),G1H4(28),m3h2x4(:,211),heltab2x8(:,:,211))
  call Hloop_Q_A(ntryL,G1H4(28),21,nMB,G2H4(184),n2h4(114))
  call Hloop_QV_A(ntryL,G1H8(145),ex3(:),G1H4(28),m3h2x4(:,212),heltab2x8(:,:,212))
  call Hloop_Q_A(ntryL,G1H4(28),21,nMB,G2H4(185),n2h4(115))
  call Hloop_QV_A(ntryL,G1H8(146),ex3(:),G1H4(28),m3h2x4(:,213),heltab2x8(:,:,213))
  call Hloop_Q_A(ntryL,G1H4(28),21,nMB,G2H4(186),n2h4(116))
  call Hloop_QV_A(ntryL,G1H8(97),ex3(:),G1H4(28),m3h2x4(:,214),heltab2x8(:,:,214))
  call Hloop_Q_A(ntryL,G1H4(28),21,nMB,G2H4(187),n2h4(117))
call HGT_raise_alpha_OLR(G1H8(147),1,1,8)
call HGT_raise_alpha_invQ_OLR(G1H8(147),2,5,8)
  call Hloop_WA_Q(ntryL,G1H8(147),ex2(:),G1H4(28),m3h2x4(:,215),heltab2x8(:,:,215))
  call Hloop_QV_A(ntryL,G1H8(149),ex3(:),G1H4(29),m3h2x4(:,216),heltab2x8(:,:,216))
  call Hloop_Q_A(ntryL,G1H4(29),21,nMB,G2H4(188),n2h4(118))
  call Hloop_QV_A(ntryL,G1H8(150),ex3(:),G1H4(29),m3h2x4(:,217),heltab2x8(:,:,217))
  call Hloop_Q_A(ntryL,G1H4(29),21,nMB,G2H4(189),n2h4(119))
  call Hloop_QV_A(ntryL,G1H8(151),ex3(:),G1H4(29),m3h2x4(:,218),heltab2x8(:,:,218))
  call Hloop_Q_A(ntryL,G1H4(29),21,nMB,G2H4(190),n2h4(120))
  call Hloop_QV_A(ntryL,G1H8(100),ex4(:),G1H4(29),m3h2x4(:,219),heltab2x8(:,:,219))
  call Hloop_Q_A(ntryL,G1H4(29),25,nMB,G2H4(191),n2h4(121))
call HGT_OLR(G1H8(101),1,1,8)
call HGT_invQ_OLR(G1H8(101),2,5,8)
  call Hloop_SV_T(ntryL,G1H8(101),-4,ex3(:),4,G2H4(192),m3h2x4(:,220),heltab2x8(:,:,220))
  call Hloop_QV_A(ntryL,G1H8(103),ex4(:),G1H4(29),m3h2x4(:,221),heltab2x8(:,:,221))
  call Hloop_Q_A(ntryL,G1H4(29),25,nMB,G2H4(193),n2h4(122))
  call Hloop_QV_A(ntryL,G1H8(104),ex4(:),G1H4(29),m3h2x4(:,222),heltab2x8(:,:,222))
  call Hloop_Q_A(ntryL,G1H4(29),25,nMB,G2H4(194),n2h4(123))
  call Hloop_QV_A(ntryL,G1H8(105),ex4(:),G1H4(29),m3h2x4(:,223),heltab2x8(:,:,223))
  call Hloop_Q_A(ntryL,G1H4(29),25,nMB,G2H4(195),n2h4(124))
  call Hloop_QV_A(ntryL,G1H8(106),ex4(:),G1H4(29),m3h2x4(:,224),heltab2x8(:,:,224))
  call Hloop_Q_A(ntryL,G1H4(29),25,nMB,G2H4(196),n2h4(125))
call HGT_raise_alpha_OLR(G1H8(107),1,1,8)
call HGT_raise_alpha_invQ_OLR(G1H8(107),2,5,8)
  call Hloop_VV_S(ntryL,G1H8(107),ex3(:),G1H4(29),m3h2x4(:,225),heltab2x8(:,:,225))
  call Hloop_QV_A(ntryL,G1H8(109),ex4(:),G1H4(30),m3h2x4(:,226),heltab2x8(:,:,226))
  call Hloop_Q_A(ntryL,G1H4(30),25,nMB,G2H4(197),n2h4(126))
  call Hloop_QV_A(ntryL,G1H8(152),ex4(:),G1H4(30),m3h2x4(:,227),heltab2x8(:,:,227))
  call Hloop_Q_A(ntryL,G1H4(30),25,nMB,G2H4(198),n2h4(127))
  call Hloop_QV_A(ntryL,G1H8(153),ex4(:),G1H4(30),m3h2x4(:,228),heltab2x8(:,:,228))
  call Hloop_Q_A(ntryL,G1H4(30),25,nMB,G2H4(199),n2h4(128))
  call Hloop_QV_A(ntryL,G1H8(154),ex4(:),G1H4(30),m3h2x4(:,229),heltab2x8(:,:,229))
  call Hloop_Q_A(ntryL,G1H4(30),25,nMB,G2H4(200),n2h4(129))
call HGT_OLR(G1H8(155),1,1,8)
call HGT_invQ_OLR(G1H8(155),2,5,8)
  call Hloop_SV_V(ntryL,G1H8(155),ex3(:),G1H4(30),m3h2x4(:,230),heltab2x8(:,:,230))
  call Hloop_QV_A(ntryL,G1H8(157),ex4(:),G1H4(31),m3h2x4(:,231),heltab2x8(:,:,231))
  call Hloop_Q_A(ntryL,G1H4(31),25,nMB,G2H4(201),n2h4(130))
  call Hloop_QV_A(ntryL,G1H8(158),ex4(:),G1H4(31),m3h2x4(:,232),heltab2x8(:,:,232))
  call Hloop_Q_A(ntryL,G1H4(31),25,nMB,G2H4(202),n2h4(131))
  call Hloop_QV_A(ntryL,G1H8(159),ex4(:),G1H4(31),m3h2x4(:,233),heltab2x8(:,:,233))
  call Hloop_Q_A(ntryL,G1H4(31),25,nMB,G2H4(203),n2h4(132))
  call Hloop_QV_A(ntryL,G1H8(112),ex4(:),G1H4(31),m3h2x4(:,234),heltab2x8(:,:,234))
  call Hloop_Q_A(ntryL,G1H4(31),25,nMB,G2H4(204),n2h4(133))
call HGT_raise_alpha_OLR(G1H8(160),1,1,8)
call HGT_raise_alpha_invQ_OLR(G1H8(160),2,5,8)
  call Hloop_UW_V(ntryL,G1H8(160),-4,ex3(:),4,G2H4(205),m3h2x4(:,235),heltab2x8(:,:,235))
  call Hloop_QV_A(ntryL,G1H8(162),ex4(:),G1H4(31),m3h2x4(:,236),heltab2x8(:,:,236))
  call Hloop_Q_A(ntryL,G1H4(31),25,nMB,G2H4(206),n2h4(134))
  call Hloop_QV_A(ntryL,G1H8(163),ex4(:),G1H4(31),m3h2x4(:,237),heltab2x8(:,:,237))
  call Hloop_Q_A(ntryL,G1H4(31),25,nMB,G2H4(207),n2h4(135))
  call Hloop_QV_A(ntryL,G1H8(164),ex4(:),G1H4(31),m3h2x4(:,238),heltab2x8(:,:,238))
  call Hloop_Q_A(ntryL,G1H4(31),25,nMB,G2H4(208),n2h4(136))
  call Hloop_QV_A(ntryL,G1H8(165),ex4(:),G1H4(31),m3h2x4(:,239),heltab2x8(:,:,239))
  call Hloop_Q_A(ntryL,G1H4(31),25,nMB,G2H4(209),n2h4(137))
call HGT_OLR(G1H8(166),1,1,8)
call HGT_invQ_OLR(G1H8(166),2,5,8)
  call Hloop_SA_Q(ntryL,G1H8(166),ex2(:),G1H4(31),ngPtb,m3h2x4(:,240),heltab2x8(:,:,240))
  call Hloop_QV_A(ntryL,G1H8(168),ex4(:),G1H4(32),m3h2x4(:,241),heltab2x8(:,:,241))
  call Hloop_Q_A(ntryL,G1H4(32),25,nMB,G2H4(210),n2h4(138))
  call Hloop_QV_A(ntryL,G1H8(169),ex4(:),G1H4(32),m3h2x4(:,242),heltab2x8(:,:,242))
  call Hloop_Q_A(ntryL,G1H4(32),25,nMB,G2H4(211),n2h4(139))
  call Hloop_QV_A(ntryL,G1H8(170),ex4(:),G1H4(32),m3h2x4(:,243),heltab2x8(:,:,243))
  call Hloop_Q_A(ntryL,G1H4(32),25,nMB,G2H4(212),n2h4(140))
  call Hloop_QV_A(ntryL,G1H8(115),ex4(:),G1H4(32),m3h2x4(:,244),heltab2x8(:,:,244))
  call Hloop_Q_A(ntryL,G1H4(32),25,nMB,G2H4(213),n2h4(141))
call HGT_raise_alpha_OLR(G1H8(171),1,1,8)
call HGT_raise_alpha_invQ_OLR(G1H8(171),2,5,8)
  call Hloop_WA_Q(ntryL,G1H8(171),ex2(:),G1H4(32),m3h2x4(:,245),heltab2x8(:,:,245))
  call Hloop_QV_A(ntryL,G1H8(173),ex4(:),G1H4(33),m3h2x4(:,246),heltab2x8(:,:,246))
  call Hloop_Q_A(ntryL,G1H4(33),25,nMB,G2H4(214),n2h4(142))
  call Hloop_QV_A(ntryL,G1H8(174),ex4(:),G1H4(33),m3h2x4(:,247),heltab2x8(:,:,247))
  call Hloop_Q_A(ntryL,G1H4(33),25,nMB,G2H4(215),n2h4(143))
  call Hloop_QV_A(ntryL,G1H8(175),ex4(:),G1H4(33),m3h2x4(:,248),heltab2x8(:,:,248))
  call Hloop_Q_A(ntryL,G1H4(33),25,nMB,G2H4(216),n2h4(144))
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(102),[G2H4(7)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(93),[G2H4(8)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(106),[G2H4(9)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(98),[G2H4(10)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(16),[G2H4(12)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(17),[G2H4(13)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(120),[G2H4(31)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(111),[G2H4(32)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(124),[G2H4(33)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(116),[G2H4(34)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(40),[G2H4(36)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(41),[G2H4(37)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(54),[G2H4(50)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(55),[G2H4(51)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(68),[G2H4(64)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(69),[G2H4(65)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(77),[G1H4(1)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(78),[G1H4(2)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(79),[G1H4(3)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(80),[G1H4(4)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(81),[G1H4(6)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(82),[G1H4(5)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(83),[G1H4(8)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(85),[G1H4(7)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(84),[G1H4(10)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(86),[G1H4(9)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(87),[G1H4(12)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(88),[G1H4(11)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(89),[G1H4(14)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(91),[G1H4(13)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(90),[G1H4(16)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(92),[G1H4(15)])
  call Hotf_5pt_reduction(G2H4(1),RedSet_5(1),mass5set(:,4),  & 
G1H4(33),G1H4(1),G1H4(2),G1H4(3),G1H4(4),G1H4(6),4)
  call HG1shiftOLR(G1H4(1),8,4)
  call Hotf_5pt_reduction(G2H4(2),RedSet_5(1),mass5set(:,5),  & 
G1H4(5),G1H4(8),G1H4(7),G1H4(10),G1H4(9),G1H4(12),4)
  call HG1shiftOLR(G1H4(8),8,4)
  call Hotf_5pt_reduction(G2H4(3),RedSet_5(1),mass5set(:,6),  & 
G1H4(11),G1H4(14),G1H4(13),G1H4(16),G1H4(15),G1H4(34),4)
  call HG1shiftOLR(G1H4(14),8,4)
  call Hotf_5pt_reduction(G2H4(4),RedSet_5(1),mass5set(:,7),  & 
G1H4(35),G1H4(36),G1H4(37),G1H4(38),G1H4(39),G1H4(40),4)
  call HG1shiftOLR(G1H4(36),8,4)
  call Hotf_5pt_reduction(G2H4(5),RedSet_5(1),mass5set(:,5),  & 
G1H4(41),G1H4(42),G1H4(43),G1H4(44),G1H4(45),G1H4(46),4)
  call HG1shiftOLR(G1H4(42),8,4)
  call Hotf_5pt_reduction(G2H4(6),RedSet_5(1),mass5set(:,6),  & 
G1H4(47),G1H4(48),G1H4(49),G1H4(50),G1H4(51),G1H4(52),4)
  call HG1shiftOLR(G1H4(48),8,4)
  call Hloop_QA_S(ntryL,G2H4(102),ex2(:),G2H2(1),ngPtb,m3h2x2(:,1),heltab2x4(:,:,1))
  call Hloop_QA_S(ntryL,G2H4(93),ex2(:),G2H2(2),ngPtb,m3h2x2(:,2),heltab2x4(:,:,2))
  call Hloop_QA_W(ntryL,G2H4(106),ex2(:),G2H2(3),m3h2x2(:,3),heltab2x4(:,:,3))
  call Hloop_QA_W(ntryL,G2H4(98),ex2(:),G2H2(4),m3h2x2(:,4),heltab2x4(:,:,4))
  call Hotf_5pt_reduction(G2H4(11),RedSet_5(9),mass5set(:,8),  & 
G1H4(53),G1H4(54),G1H4(55),G1H4(56),G1H4(57),G1H4(58),4)
  call HG1shiftOLR(G1H4(54),8,4)
  call Hotf_5pt_reduction(G2H4(16),RedSet_5(9),mass5set(:,9),  & 
G1H4(59),G1H4(60),G1H4(61),G1H4(62),G1H4(63),G1H4(64),4)
  call HG1shiftOLR(G1H4(60),8,4)
  call Hotf_5pt_reduction(G2H4(17),RedSet_5(9),mass5set(:,10),  & 
G1H4(65),G1H4(66),G1H4(67),G1H4(68),G1H4(69),G1H4(70),4)
  call HG1shiftOLR(G1H4(66),8,4)
  call Hotf_5pt_reduction(G2H4(14),RedSet_5(9),mass5set(:,11),  & 
G1H4(71),G1H4(72),G1H4(73),G1H4(74),G1H4(75),G1H4(76),4)
  call HG1shiftOLR(G1H4(72),8,4)
  call Hotf_5pt_reduction(G2H4(15),RedSet_5(9),mass5set(:,12),  & 
G1H4(77),G1H4(78),G1H4(79),G1H4(80),G1H4(81),G1H4(82),4)
  call HG1shiftOLR(G1H4(78),8,4)
  call Hotf_5pt_reduction(G2H4(18),RedSet_5(9),mass5set(:,11),  & 
G1H4(83),G1H4(84),G1H4(85),G1H4(86),G1H4(87),G1H4(88),4)
  call HG1shiftOLR(G1H4(84),8,4)
  call Hloop_SV_V(ntryL,G2H4(19),ex3(:),G2H2(5),m3h2x2(:,5),heltab2x4(:,:,5))
  call Hloop_VV_S(ntryL,G2H4(20),ex3(:),G2H2(6),m3h2x2(:,6),heltab2x4(:,:,6))
  call Hloop_SV_V(ntryL,G2H4(21),ex3(:),G2H2(7),m3h2x2(:,7),heltab2x4(:,:,7))
  call Hloop_VV_S(ntryL,G2H4(22),ex3(:),G2H2(8),m3h2x2(:,8),heltab2x4(:,:,8))
  call Hotf_5pt_reduction(G2H4(23),RedSet_5(9),mass5set(:,11),  & 
G1H4(89),G1H4(90),G1H4(91),G1H4(92),G1H4(93),G1H4(94),4)
  call HG1shiftOLR(G1H4(90),8,4)
  call Hotf_5pt_reduction(G2H4(24),RedSet_5(9),mass5set(:,11),  & 
G1H4(95),G1H4(96),G1H4(97),G1H4(98),G1H4(99),G1H4(100),4)
  call HG1shiftOLR(G1H4(96),8,4)
  call Hotf_5pt_reduction(G2H4(25),RedSet_5(2),mass5set(:,4),  & 
G1H4(101),G1H4(102),G1H4(103),G1H4(104),G1H4(105),G1H4(106),4)
  call HG1shiftOLR(G1H4(102),8,4)
  call Hotf_5pt_reduction(G2H4(26),RedSet_5(2),mass5set(:,5),  & 
G1H4(107),G1H4(108),G1H4(109),G1H4(110),G1H4(111),G1H4(112),4)
  call HG1shiftOLR(G1H4(108),8,4)
  call Hotf_5pt_reduction(G2H4(27),RedSet_5(2),mass5set(:,6),  & 
G1H4(113),G1H4(114),G1H4(115),G1H4(116),G1H4(117),G1H4(118),4)
  call HG1shiftOLR(G1H4(114),8,4)
  call Hotf_5pt_reduction(G2H4(28),RedSet_5(2),mass5set(:,7),  & 
G1H4(119),G1H4(120),G1H4(121),G1H4(122),G1H4(123),G1H4(124),4)
  call HG1shiftOLR(G1H4(120),8,4)
  call Hotf_5pt_reduction(G2H4(29),RedSet_5(2),mass5set(:,5),  & 
G1H4(125),G1H4(126),G1H4(127),G1H4(128),G1H4(129),G1H4(130),4)
  call HG1shiftOLR(G1H4(126),8,4)
  call Hotf_5pt_reduction(G2H4(30),RedSet_5(2),mass5set(:,6),  & 
G1H4(131),G1H4(132),G1H4(133),G1H4(134),G1H4(135),G1H4(136),4)
  call HG1shiftOLR(G1H4(132),8,4)
  call Hloop_AQ_S(ntryL,G2H4(120),ex1(:),G2H2(9),ngPbt,m3h2x2(:,9),heltab2x4(:,:,9))
  call Hloop_AQ_S(ntryL,G2H4(111),ex1(:),G2H2(10),ngPbt,m3h2x2(:,10),heltab2x4(:,:,10))
  call Hloop_AQ_W(ntryL,G2H4(124),ex1(:),G2H2(11),m3h2x2(:,11),heltab2x4(:,:,11))
  call Hloop_AQ_W(ntryL,G2H4(116),ex1(:),G2H2(12),m3h2x2(:,12),heltab2x4(:,:,12))
  call Hotf_5pt_reduction(G2H4(35),RedSet_5(10),mass5set(:,8),  & 
G1H4(137),G1H4(138),G1H4(139),G1H4(140),G1H4(141),G1H4(142),4)
  call HG1shiftOLR(G1H4(138),4,4)
  call Hotf_5pt_reduction(G2H4(40),RedSet_5(10),mass5set(:,9),  & 
G1H4(143),G1H4(144),G1H4(145),G1H4(146),G1H4(147),G1H4(148),4)
  call HG1shiftOLR(G1H4(144),4,4)
  call Hotf_5pt_reduction(G2H4(41),RedSet_5(10),mass5set(:,10),  & 
G1H4(149),G1H4(150),G1H4(151),G1H4(152),G1H4(153),G1H4(154),4)
  call HG1shiftOLR(G1H4(150),4,4)
  call Hotf_5pt_reduction(G2H4(38),RedSet_5(10),mass5set(:,11),  & 
G1H4(155),G1H4(156),G1H4(157),G1H4(158),G1H4(159),G1H4(160),4)
  call HG1shiftOLR(G1H4(156),4,4)
  call Hotf_5pt_reduction(G2H4(39),RedSet_5(10),mass5set(:,12),  & 
G1H4(161),G1H4(162),G1H4(163),G1H4(164),G1H4(165),G1H4(166),4)
  call HG1shiftOLR(G1H4(162),4,4)
  call Hotf_5pt_reduction(G2H4(42),RedSet_5(10),mass5set(:,11),  & 
G1H4(167),G1H4(168),G1H4(169),G1H4(170),G1H4(171),G1H4(172),4)
  call HG1shiftOLR(G1H4(168),4,4)
  call Hloop_SV_V(ntryL,G2H4(43),ex4(:),G2H2(13),m3h2x2(:,13),heltab2x4(:,:,13))
  call Hloop_VV_S(ntryL,G2H4(44),ex4(:),G2H2(14),m3h2x2(:,14),heltab2x4(:,:,14))
  call Hloop_SV_V(ntryL,G2H4(45),ex4(:),G2H2(15),m3h2x2(:,15),heltab2x4(:,:,15))
  call Hloop_VV_S(ntryL,G2H4(46),ex4(:),G2H2(16),m3h2x2(:,16),heltab2x4(:,:,16))
  call Hotf_5pt_reduction(G2H4(47),RedSet_5(10),mass5set(:,11),  & 
G1H4(173),G1H4(174),G1H4(175),G1H4(176),G1H4(177),G1H4(178),4)
  call HG1shiftOLR(G1H4(174),4,4)
  call Hotf_5pt_reduction(G2H4(48),RedSet_5(10),mass5set(:,11),  & 
G1H4(179),G1H4(180),G1H4(181),G1H4(182),G1H4(183),G1H4(184),4)
  call HG1shiftOLR(G1H4(180),4,4)
  call Hotf_5pt_reduction(G2H4(49),RedSet_5(11),mass5set(:,8),  & 
G1H4(185),G1H4(186),G1H4(187),G1H4(188),G1H4(189),G1H4(190),4)
  call HG1shiftOLR(G1H4(186),8,4)
  call Hotf_5pt_reduction(G2H4(54),RedSet_5(11),mass5set(:,9),  & 
G1H4(191),G1H4(192),G1H4(193),G1H4(194),G1H4(195),G1H4(196),4)
  call HG1shiftOLR(G1H4(192),8,4)
  call Hotf_5pt_reduction(G2H4(55),RedSet_5(11),mass5set(:,10),  & 
G1H4(197),G1H4(198),G1H4(199),G1H4(200),G1H4(201),G1H4(202),4)
  call HG1shiftOLR(G1H4(198),8,4)
  call Hotf_5pt_reduction(G2H4(52),RedSet_5(11),mass5set(:,11),  & 
G1H4(203),G1H4(204),G1H4(205),G1H4(206),G1H4(207),G1H4(208),4)
  call HG1shiftOLR(G1H4(204),8,4)
  call Hotf_5pt_reduction(G2H4(53),RedSet_5(11),mass5set(:,12),  & 
G1H4(209),G1H4(210),G1H4(211),G1H4(212),G1H4(213),G1H4(214),4)
  call HG1shiftOLR(G1H4(210),8,4)
  call Hotf_5pt_reduction(G2H4(56),RedSet_5(11),mass5set(:,11),  & 
G1H4(215),G1H4(216),G1H4(217),G1H4(218),G1H4(219),G1H4(220),4)
  call HG1shiftOLR(G1H4(216),8,4)
  call Hloop_SV_V(ntryL,G2H4(57),ex3(:),G2H2(17),m3h2x2(:,17),heltab2x4(:,:,17))
  call Hloop_VV_S(ntryL,G2H4(58),ex3(:),G2H2(18),m3h2x2(:,18),heltab2x4(:,:,18))
  call Hloop_SV_V(ntryL,G2H4(59),ex3(:),G2H2(19),m3h2x2(:,19),heltab2x4(:,:,19))
  call Hloop_VV_S(ntryL,G2H4(60),ex3(:),G2H2(20),m3h2x2(:,20),heltab2x4(:,:,20))
  call Hotf_5pt_reduction(G2H4(61),RedSet_5(11),mass5set(:,11),  & 
G1H4(221),G1H4(222),G1H4(223),G1H4(224),G1H4(225),G1H4(226),4)
  call HG1shiftOLR(G1H4(222),8,4)
  call Hotf_5pt_reduction(G2H4(62),RedSet_5(11),mass5set(:,11),  & 
G1H4(227),G1H4(228),G1H4(229),G1H4(230),G1H4(231),G1H4(232),4)
  call HG1shiftOLR(G1H4(228),8,4)
  call Hotf_5pt_reduction(G2H4(63),RedSet_5(12),mass5set(:,8),  & 
G1H4(233),G1H4(234),G1H4(235),G1H4(236),G1H4(237),G1H4(238),4)
  call HG1shiftOLR(G1H4(234),4,4)
  call Hotf_5pt_reduction(G2H4(68),RedSet_5(12),mass5set(:,9),  & 
G1H4(239),G1H4(240),G1H4(241),G1H4(242),G1H4(243),G1H4(244),4)
  call HG1shiftOLR(G1H4(240),4,4)
  call Hotf_5pt_reduction(G2H4(69),RedSet_5(12),mass5set(:,10),  & 
G1H4(245),G1H4(246),G1H4(247),G1H4(248),G1H4(249),G1H4(250),4)
  call HG1shiftOLR(G1H4(246),4,4)
  call Hotf_5pt_reduction(G2H4(66),RedSet_5(12),mass5set(:,11),  & 
G1H4(251),G1H4(252),G1H4(253),G1H4(254),G1H4(255),G1H4(256),4)
  call HG1shiftOLR(G1H4(252),4,4)
  call Hotf_5pt_reduction(G2H4(67),RedSet_5(12),mass5set(:,12),  & 
G1H4(257),G1H4(258),G1H4(259),G1H4(260),G1H4(261),G1H4(262),4)
  call HG1shiftOLR(G1H4(258),4,4)
  call Hotf_5pt_reduction(G2H4(70),RedSet_5(12),mass5set(:,11),  & 
G1H4(263),G1H4(264),G1H4(265),G1H4(266),G1H4(267),G1H4(268),4)
  call HG1shiftOLR(G1H4(264),4,4)
  call Hloop_SV_V(ntryL,G2H4(71),ex4(:),G2H2(21),m3h2x2(:,21),heltab2x4(:,:,21))
  call Hloop_VV_S(ntryL,G2H4(72),ex4(:),G2H2(22),m3h2x2(:,22),heltab2x4(:,:,22))
  call Hloop_SV_V(ntryL,G2H4(73),ex4(:),G2H2(23),m3h2x2(:,23),heltab2x4(:,:,23))
  call Hloop_VV_S(ntryL,G2H4(74),ex4(:),G2H2(24),m3h2x2(:,24),heltab2x4(:,:,24))
  call Hotf_5pt_reduction(G2H4(75),RedSet_5(12),mass5set(:,11),  & 
G1H4(269),G1H4(270),G1H4(271),G1H4(272),G1H4(273),G1H4(274),4)
  call HG1shiftOLR(G1H4(270),4,4)
  call Hotf_5pt_reduction(G2H4(76),RedSet_5(12),mass5set(:,11),  & 
G1H4(275),G1H4(276),G1H4(277),G1H4(278),G1H4(279),G1H4(280),4)
  call HG1shiftOLR(G1H4(276),4,4)
  call Hotf_5pt_reduction(G2H4(77),RedSet_5(3),mass5set(:,13),  & 
G1H4(281),G1H4(282),G1H4(283),G1H4(284),G1H4(285),G1H4(286),4)
  call HG1shiftOLR(G1H4(282),8,4)
  call Hotf_5pt_reduction(G2H4(78),RedSet_5(3),mass5set(:,13),  & 
G1H4(287),G1H4(288),G1H4(289),G1H4(290),G1H4(291),G1H4(292),4)
  call HG1shiftOLR(G1H4(288),8,4)
  call Hotf_5pt_reduction(G2H4(79),RedSet_5(4),mass5set(:,13),  & 
G1H4(293),G1H4(294),G1H4(295),G1H4(296),G1H4(297),G1H4(298),4)
  call HG1shiftOLR(G1H4(294),4,4)
  call Hotf_5pt_reduction(G2H4(80),RedSet_5(4),mass5set(:,13),  & 
G1H4(299),G1H4(300),G1H4(301),G1H4(302),G1H4(303),G1H4(304),4)
  call HG1shiftOLR(G1H4(300),4,4)
  call Hotf_5pt_reduction(G2H4(81),RedSet_5(5),mass5set(:,13),  & 
G1H4(305),G1H4(306),G1H4(307),G1H4(308),G1H4(309),G1H4(310),4)
  call HG1shiftOLR(G1H4(306),8,4)
  call Hotf_5pt_reduction(G2H4(82),RedSet_5(5),mass5set(:,13),  & 
G1H4(311),G1H4(312),G1H4(313),G1H4(314),G1H4(315),G1H4(316),4)
  call HG1shiftOLR(G1H4(312),8,4)
  call Hotf_5pt_reduction(G2H4(83),RedSet_5(6),mass5set(:,14),  & 
G1H4(317),G1H4(318),G1H4(319),G1H4(320),G1H4(321),G1H4(322),4)
  call HG1shiftOLR(G1H4(318),2,4)
  call Hloop_VV_S(ntryL,G2H4(85),ex4(:),G2H2(25),m3h2x2(:,25),heltab2x4(:,:,25))
  call Hloop_SV_V(ntryL,G2H4(84),ex4(:),G2H2(26),m3h2x2(:,26),heltab2x4(:,:,26))
  call Hotf_5pt_reduction(G2H4(86),RedSet_5(6),mass5set(:,14),  & 
G1H4(323),G1H4(324),G1H4(325),G1H4(326),G1H4(327),G1H4(328),4)
  call HG1shiftOLR(G1H4(324),2,4)
  call Hotf_5pt_reduction(G2H4(87),RedSet_5(7),mass5set(:,13),  & 
G1H4(329),G1H4(330),G1H4(331),G1H4(332),G1H4(333),G1H4(334),4)
  call HG1shiftOLR(G1H4(330),4,4)
  call Hotf_5pt_reduction(G2H4(88),RedSet_5(7),mass5set(:,13),  & 
G1H4(335),G1H4(336),G1H4(337),G1H4(338),G1H4(339),G1H4(340),4)
  call HG1shiftOLR(G1H4(336),4,4)
  call Hotf_5pt_reduction(G2H4(89),RedSet_5(8),mass5set(:,14),  & 
G1H4(341),G1H4(342),G1H4(343),G1H4(344),G1H4(345),G1H4(346),4)
  call HG1shiftOLR(G1H4(342),2,4)
  call Hloop_VV_S(ntryL,G2H4(91),ex3(:),G2H2(27),m3h2x2(:,27),heltab2x4(:,:,27))
  call Hloop_SV_V(ntryL,G2H4(90),ex3(:),G2H2(28),m3h2x2(:,28),heltab2x4(:,:,28))
  call Hotf_5pt_reduction(G2H4(92),RedSet_5(8),mass5set(:,14),  & 
G1H4(347),G1H4(348),G1H4(349),G1H4(350),G1H4(351),G1H4(352),4)
  call HG1shiftOLR(G1H4(348),2,4)
  call Hloop_QA_S(ntryL,G2H4(96),ex2(:),G2H2(29),ngPtb,m3h2x2(:,29),heltab2x4(:,:,29))
  call Hloop_QA_S(ntryL,G2H4(97),ex2(:),G2H2(30),ngPtb,m3h2x2(:,30),heltab2x4(:,:,30))
  call Hloop_QA_W(ntryL,G2H4(100),ex2(:),G2H2(31),m3h2x2(:,31),heltab2x4(:,:,31))
  call Hloop_QA_W(ntryL,G2H4(101),ex2(:),G2H2(32),m3h2x2(:,32),heltab2x4(:,:,32))
  call Hloop_QA_S(ntryL,G2H4(104),ex2(:),G2H2(33),ngPtb,m3h2x2(:,33),heltab2x4(:,:,33))
  call Hloop_QA_S(ntryL,G2H4(105),ex2(:),G2H2(34),ngPtb,m3h2x2(:,34),heltab2x4(:,:,34))
  call Hloop_QA_W(ntryL,G2H4(109),ex2(:),G2H2(35),m3h2x2(:,35),heltab2x4(:,:,35))
  call Hloop_QA_W(ntryL,G2H4(110),ex2(:),G2H2(36),m3h2x2(:,36),heltab2x4(:,:,36))
  call Hloop_AQ_S(ntryL,G2H4(114),ex1(:),G2H2(37),ngPbt,m3h2x2(:,37),heltab2x4(:,:,37))
  call Hloop_AQ_S(ntryL,G2H4(115),ex1(:),G2H2(38),ngPbt,m3h2x2(:,38),heltab2x4(:,:,38))
  call Hloop_AQ_W(ntryL,G2H4(118),ex1(:),G2H2(39),m3h2x2(:,39),heltab2x4(:,:,39))
  call Hloop_AQ_W(ntryL,G2H4(119),ex1(:),G2H2(40),m3h2x2(:,40),heltab2x4(:,:,40))
  call Hloop_AQ_S(ntryL,G2H4(122),ex1(:),G2H2(41),ngPbt,m3h2x2(:,41),heltab2x4(:,:,41))
  call Hloop_AQ_S(ntryL,G2H4(123),ex1(:),G2H2(42),ngPbt,m3h2x2(:,42),heltab2x4(:,:,42))
  call Hloop_AQ_W(ntryL,G2H4(127),ex1(:),G2H2(43),m3h2x2(:,43),heltab2x4(:,:,43))
  call Hloop_AQ_W(ntryL,G2H4(128),ex1(:),G2H2(44),m3h2x2(:,44),heltab2x4(:,:,44))
  call Hloop_AQ_S(ntryL,G2H4(129),ex1(:),G2H2(45),ngPbt,m3h2x2(:,45),heltab2x4(:,:,45))
  call Hloop_AQ_S(ntryL,G2H4(132),ex1(:),G2H2(46),ngPbt,m3h2x2(:,46),heltab2x4(:,:,46))
  call Hloop_AQ_S(ntryL,G2H4(133),ex1(:),G2H2(47),ngPbt,m3h2x2(:,47),heltab2x4(:,:,47))
  call Hloop_AQ_S(ntryL,G2H4(134),ex1(:),G2H2(48),ngPbt,m3h2x2(:,48),heltab2x4(:,:,48))
  call Hloop_AQ_S(ntryL,G2H4(136),ex1(:),G2H2(49),ngPbt,m3h2x2(:,49),heltab2x4(:,:,49))
  call Hloop_AQ_S(ntryL,G2H4(137),ex1(:),G2H2(50),ngPbt,m3h2x2(:,50),heltab2x4(:,:,50))
  call Hloop_AQ_W(ntryL,G2H4(138),ex1(:),G2H2(51),m3h2x2(:,51),heltab2x4(:,:,51))
  call Hloop_AQ_W(ntryL,G2H4(140),ex1(:),G2H2(52),m3h2x2(:,52),heltab2x4(:,:,52))
  call Hloop_AQ_W(ntryL,G2H4(141),ex1(:),G2H2(53),m3h2x2(:,53),heltab2x4(:,:,53))
  call Hloop_AQ_W(ntryL,G2H4(142),ex1(:),G2H2(54),m3h2x2(:,54),heltab2x4(:,:,54))
  call Hloop_AQ_W(ntryL,G2H4(145),ex1(:),G2H2(55),m3h2x2(:,55),heltab2x4(:,:,55))
  call Hloop_AQ_W(ntryL,G2H4(146),ex1(:),G2H2(56),m3h2x2(:,56),heltab2x4(:,:,56))
  call Hloop_AQ_S(ntryL,G2H4(147),ex1(:),G2H2(57),ngPbt,m3h2x2(:,57),heltab2x4(:,:,57))
  call Hloop_AQ_S(ntryL,G2H4(150),ex1(:),G2H2(58),ngPbt,m3h2x2(:,58),heltab2x4(:,:,58))
  call Hloop_AQ_S(ntryL,G2H4(151),ex1(:),G2H2(59),ngPbt,m3h2x2(:,59),heltab2x4(:,:,59))
  call Hloop_AQ_S(ntryL,G2H4(152),ex1(:),G2H2(60),ngPbt,m3h2x2(:,60),heltab2x4(:,:,60))
  call Hloop_AQ_S(ntryL,G2H4(154),ex1(:),G2H2(61),ngPbt,m3h2x2(:,61),heltab2x4(:,:,61))
  call Hloop_AQ_S(ntryL,G2H4(155),ex1(:),G2H2(62),ngPbt,m3h2x2(:,62),heltab2x4(:,:,62))
  call Hloop_AQ_W(ntryL,G2H4(156),ex1(:),G2H2(63),m3h2x2(:,63),heltab2x4(:,:,63))
  call Hloop_AQ_W(ntryL,G2H4(158),ex1(:),G2H2(64),m3h2x2(:,64),heltab2x4(:,:,64))
  call Hloop_AQ_W(ntryL,G2H4(159),ex1(:),G2H2(65),m3h2x2(:,65),heltab2x4(:,:,65))
  call Hloop_AQ_W(ntryL,G2H4(160),ex1(:),G2H2(66),m3h2x2(:,66),heltab2x4(:,:,66))
  call Hloop_AQ_W(ntryL,G2H4(163),ex1(:),G2H2(67),m3h2x2(:,67),heltab2x4(:,:,67))
  call Hloop_AQ_W(ntryL,G2H4(164),ex1(:),G2H2(68),m3h2x2(:,68),heltab2x4(:,:,68))
  call Hloop_QA_S(ntryL,G2H4(165),ex2(:),G2H2(69),ngPtb,m3h2x2(:,69),heltab2x4(:,:,69))
  call Hloop_QA_S(ntryL,G2H4(168),ex2(:),G2H2(70),ngPtb,m3h2x2(:,70),heltab2x4(:,:,70))
  call Hloop_QA_S(ntryL,G2H4(169),ex2(:),G2H2(71),ngPtb,m3h2x2(:,71),heltab2x4(:,:,71))
  call Hloop_QA_S(ntryL,G2H4(170),ex2(:),G2H2(72),ngPtb,m3h2x2(:,72),heltab2x4(:,:,72))
  call Hloop_QA_S(ntryL,G2H4(172),ex2(:),G2H2(73),ngPtb,m3h2x2(:,73),heltab2x4(:,:,73))
  call Hloop_QA_S(ntryL,G2H4(173),ex2(:),G2H2(74),ngPtb,m3h2x2(:,74),heltab2x4(:,:,74))
  call Hloop_QA_W(ntryL,G2H4(174),ex2(:),G2H2(75),m3h2x2(:,75),heltab2x4(:,:,75))
  call Hloop_QA_W(ntryL,G2H4(176),ex2(:),G2H2(76),m3h2x2(:,76),heltab2x4(:,:,76))
  call Hloop_QA_W(ntryL,G2H4(177),ex2(:),G2H2(77),m3h2x2(:,77),heltab2x4(:,:,77))
  call Hloop_QA_W(ntryL,G2H4(178),ex2(:),G2H2(78),m3h2x2(:,78),heltab2x4(:,:,78))
  call Hloop_QA_W(ntryL,G2H4(181),ex2(:),G2H2(79),m3h2x2(:,79),heltab2x4(:,:,79))
  call Hloop_QA_W(ntryL,G2H4(182),ex2(:),G2H2(80),m3h2x2(:,80),heltab2x4(:,:,80))
  call Hotf_5pt_reduction(G2H4(183),RedSet_5(6),mass5set(:,3),  & 
G1H4(353),G1H4(354),G1H4(355),G1H4(356),G1H4(357),G1H4(358),4)
  call HG1shiftOLR(G1H4(354),2,4)
  call Hotf_4pt_reduction(G2H4(185),RedSet_4(1),mass4set(:,1),  & 
G1H4(359),G1H4(360),G1H4(361),G1H4(362),G1H4(363),4)
  call HG1shiftOLR(G1H4(360),2,4)
  call Hotf_4pt_reduction(G2H4(186),RedSet_4(2),mass4set(:,1),  & 
G1H4(364),G1H4(365),G1H4(366),G1H4(367),G1H4(368),4)
  call HG1shiftOLR(G1H4(365),10,4)
  call Hotf_5pt_reduction(G2H4(187),RedSet_5(6),mass5set(:,3),  & 
G1H4(369),G1H4(370),G1H4(371),G1H4(372),G1H4(373),G1H4(374),4)
  call HG1shiftOLR(G1H4(370),2,4)
  call Hotf_4pt_reduction(G2H4(189),RedSet_4(1),mass4set(:,1),  & 
G1H4(375),G1H4(376),G1H4(377),G1H4(378),G1H4(379),4)
  call HG1shiftOLR(G1H4(376),2,4)
  call Hotf_4pt_reduction(G2H4(190),RedSet_4(2),mass4set(:,1),  & 
G1H4(380),G1H4(381),G1H4(382),G1H4(383),G1H4(384),4)
  call HG1shiftOLR(G1H4(381),10,4)
  call Hloop_QA_S(ntryL,G2H4(191),ex2(:),G2H2(81),ngPtb,m3h2x2(:,81),heltab2x4(:,:,81))
  call Hloop_QA_S(ntryL,G2H4(194),ex2(:),G2H2(82),ngPtb,m3h2x2(:,82),heltab2x4(:,:,82))
  call Hloop_QA_S(ntryL,G2H4(195),ex2(:),G2H2(83),ngPtb,m3h2x2(:,83),heltab2x4(:,:,83))
  call Hloop_QA_S(ntryL,G2H4(196),ex2(:),G2H2(84),ngPtb,m3h2x2(:,84),heltab2x4(:,:,84))
  call Hloop_QA_S(ntryL,G2H4(198),ex2(:),G2H2(85),ngPtb,m3h2x2(:,85),heltab2x4(:,:,85))
  call Hloop_QA_S(ntryL,G2H4(199),ex2(:),G2H2(86),ngPtb,m3h2x2(:,86),heltab2x4(:,:,86))
  call Hloop_QA_W(ntryL,G2H4(200),ex2(:),G2H2(87),m3h2x2(:,87),heltab2x4(:,:,87))
  call Hloop_QA_W(ntryL,G2H4(202),ex2(:),G2H2(88),m3h2x2(:,88),heltab2x4(:,:,88))
  call Hloop_QA_W(ntryL,G2H4(203),ex2(:),G2H2(89),m3h2x2(:,89),heltab2x4(:,:,89))
  call Hloop_QA_W(ntryL,G2H4(204),ex2(:),G2H2(90),m3h2x2(:,90),heltab2x4(:,:,90))
  call Hloop_QA_W(ntryL,G2H4(207),ex2(:),G2H2(91),m3h2x2(:,91),heltab2x4(:,:,91))
  call Hloop_QA_W(ntryL,G2H4(208),ex2(:),G2H2(92),m3h2x2(:,92),heltab2x4(:,:,92))
  call Hotf_5pt_reduction(G2H4(209),RedSet_5(8),mass5set(:,3),  & 
G1H4(385),G1H4(386),G1H4(387),G1H4(388),G1H4(389),G1H4(390),4)
  call HG1shiftOLR(G1H4(386),2,4)
  call Hotf_4pt_reduction(G2H4(211),RedSet_4(1),mass4set(:,1),  & 
G1H4(391),G1H4(392),G1H4(393),G1H4(394),G1H4(395),4)
  call HG1shiftOLR(G1H4(392),2,4)
  call Hotf_4pt_reduction(G2H4(212),RedSet_4(3),mass4set(:,1),  & 
G1H4(396),G1H4(397),G1H4(398),G1H4(399),G1H4(400),4)
  call HG1shiftOLR(G1H4(397),6,4)
  call Hotf_5pt_reduction(G2H4(213),RedSet_5(8),mass5set(:,3),  & 
G1H4(401),G1H4(402),G1H4(403),G1H4(404),G1H4(405),G1H4(406),4)
  call HG1shiftOLR(G1H4(402),2,4)
  call Hotf_4pt_reduction(G2H4(215),RedSet_4(1),mass4set(:,1),  & 
G1H4(407),G1H4(408),G1H4(409),G1H4(410),G1H4(411),4)
  call HG1shiftOLR(G1H4(408),2,4)
  call Hotf_4pt_reduction(G2H4(216),RedSet_4(3),mass4set(:,1),  & 
G1H4(412),G1H4(413),G1H4(414),G1H4(415),G1H4(416),4)
  call HG1shiftOLR(G1H4(413),6,4)
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(359),[G1H4(357)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(364),[G1H4(358)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(375),[G1H4(373)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(380),[G1H4(374)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(391),[G1H4(389)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(396),[G1H4(390)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(407),[G1H4(405)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(412),[G1H4(406)])
  call Hloop_SA_Q(ntryL,G1H4(33),ex2(:),G1H2(1),ngH,m3h2x2(:,93),heltab2x4(:,:,93))
  call Hloop_A_Q(ntryL,G1H2(1),23,nMT,G2H2(93),n2h2(1))
call HGT_OLR(G1H4(1),1,1,4)
call HGT_invQ_OLR(G1H4(1),2,5,4)
  call Hloop_Q_A(ntryL,G1H4(1),-8,nMT,G2H4(7),n2h4(145))
  call Hloop_QV_A(ntryL,G2H4(7),ex4(:),G2H2(94),m3h2x2(:,94),heltab2x4(:,:,94))
  call Hloop_SA_Q(ntryL,G1H4(4),ex2(:),G1H2(1),ngH,m3h2x2(:,95),heltab2x4(:,:,95))
  call Hloop_A_Q(ntryL,G1H2(1),23,nMT,G2H2(95),n2h2(2))
  call Hloop_SA_Q(ntryL,G1H4(6),ex2(:),G1H2(1),ngH,m3h2x2(:,96),heltab2x4(:,:,96))
  call Hloop_A_Q(ntryL,G1H2(1),23,nMT,G2H2(96),n2h2(3))
  call Hloop_SA_Q(ntryL,G1H4(5),ex2(:),G1H2(1),ngX,m3h2x2(:,97),heltab2x4(:,:,97))
  call Hloop_A_Q(ntryL,G1H2(1),23,nMT,G2H2(97),n2h2(4))
call HGT_OLR(G1H4(8),1,1,4)
call HGT_invQ_OLR(G1H4(8),2,5,4)
  call Hloop_Q_A(ntryL,G1H4(8),-8,nMT,G2H4(8),n2h4(146))
  call Hloop_QV_A(ntryL,G2H4(8),ex4(:),G2H2(98),m3h2x2(:,98),heltab2x4(:,:,98))
  call Hloop_SA_Q(ntryL,G1H4(9),ex2(:),G1H2(1),ngX,m3h2x2(:,99),heltab2x4(:,:,99))
  call Hloop_A_Q(ntryL,G1H2(1),23,nMT,G2H2(99),n2h2(5))
  call Hloop_SA_Q(ntryL,G1H4(12),ex2(:),G1H2(1),ngX,m3h2x2(:,100),heltab2x4(:,:,100))
  call Hloop_A_Q(ntryL,G1H2(1),23,nMT,G2H2(100),n2h2(6))
  call Hloop_SA_Q(ntryL,G1H4(11),ex2(:),G1H2(1),ngPtb,m3h2x2(:,101),heltab2x4(:,:,101))
  call Hloop_A_Q(ntryL,G1H2(1),23,nMB,G2H2(101),n2h2(7))
call HGT_OLR(G1H4(14),1,1,4)
call HGT_invQ_OLR(G1H4(14),2,5,4)
  call Hloop_Q_A(ntryL,G1H4(14),-8,nMB,G2H4(9),n2h4(147))
  call Hloop_QV_A(ntryL,G2H4(9),ex4(:),G2H2(102),m3h2x2(:,102),heltab2x4(:,:,102))
  call Hloop_SA_Q(ntryL,G1H4(15),ex2(:),G1H2(1),ngPtb,m3h2x2(:,103),heltab2x4(:,:,103))
  call Hloop_A_Q(ntryL,G1H2(1),23,nMB,G2H2(103),n2h2(8))
  call Hloop_SA_Q(ntryL,G1H4(34),ex2(:),G1H2(1),ngPtb,m3h2x2(:,104),heltab2x4(:,:,104))
  call Hloop_A_Q(ntryL,G1H2(1),23,nMB,G2H2(104),n2h2(9))
  call Hloop_VA_Q(ntryL,G1H4(35),ex2(:),G1H2(1),m3h2x2(:,105),heltab2x4(:,:,105))
  call Hloop_A_Q(ntryL,G1H2(1),23,nMT,G2H2(105),n2h2(10))
call HGT_OLR(G1H4(36),1,1,4)
call HGT_invQ_OLR(G1H4(36),2,5,4)
  call Hloop_Q_A(ntryL,G1H4(36),-8,nMT,G2H4(10),n2h4(148))
  call Hloop_QV_A(ntryL,G2H4(10),ex4(:),G2H2(106),m3h2x2(:,106),heltab2x4(:,:,106))
  call Hloop_VA_Q(ntryL,G1H4(39),ex2(:),G1H2(1),m3h2x2(:,107),heltab2x4(:,:,107))
  call Hloop_A_Q(ntryL,G1H2(1),23,nMT,G2H2(107),n2h2(11))
  call Hloop_VA_Q(ntryL,G1H4(40),ex2(:),G1H2(1),m3h2x2(:,108),heltab2x4(:,:,108))
  call Hloop_A_Q(ntryL,G1H2(1),23,nMT,G2H2(108),n2h2(12))
  call Hloop_ZA_Q(ntryL,G1H4(41),ex2(:),G1H2(1),ngZu,m3h2x2(:,109),heltab2x4(:,:,109))
  call Hloop_A_Q(ntryL,G1H2(1),23,nMT,G2H2(109),n2h2(13))
call HGT_OLR(G1H4(42),1,1,4)
call HGT_invQ_OLR(G1H4(42),2,5,4)
  call Hloop_Q_A(ntryL,G1H4(42),-8,nMT,G2H4(12),n2h4(149))
  call Hloop_QV_A(ntryL,G2H4(12),ex4(:),G2H2(110),m3h2x2(:,110),heltab2x4(:,:,110))
  call Hloop_ZA_Q(ntryL,G1H4(45),ex2(:),G1H2(1),ngZu,m3h2x2(:,111),heltab2x4(:,:,111))
  call Hloop_A_Q(ntryL,G1H2(1),23,nMT,G2H2(111),n2h2(14))
  call Hloop_ZA_Q(ntryL,G1H4(46),ex2(:),G1H2(1),ngZu,m3h2x2(:,112),heltab2x4(:,:,112))
  call Hloop_A_Q(ntryL,G1H2(1),23,nMT,G2H2(112),n2h2(15))
  call Hloop_WA_Q(ntryL,G1H4(47),ex2(:),G1H2(1),m3h2x2(:,113),heltab2x4(:,:,113))
  call Hloop_A_Q(ntryL,G1H2(1),23,nMB,G2H2(113),n2h2(16))
call HGT_OLR(G1H4(48),1,1,4)
call HGT_invQ_OLR(G1H4(48),2,5,4)
  call Hloop_Q_A(ntryL,G1H4(48),-8,nMB,G2H4(13),n2h4(150))
  call Hloop_QV_A(ntryL,G2H4(13),ex4(:),G2H2(114),m3h2x2(:,114),heltab2x4(:,:,114))
  call Hloop_WA_Q(ntryL,G1H4(51),ex2(:),G1H2(1),m3h2x2(:,115),heltab2x4(:,:,115))
  call Hloop_A_Q(ntryL,G1H2(1),23,nMB,G2H2(115),n2h2(17))
  call Hloop_WA_Q(ntryL,G1H4(52),ex2(:),G1H2(1),m3h2x2(:,116),heltab2x4(:,:,116))
  call Hloop_A_Q(ntryL,G1H2(1),23,nMB,G2H2(116),n2h2(18))
  call Hloop_QV_A(ntryL,G1H4(53),ex3(:),G1H2(1),m3h2x2(:,117),heltab2x4(:,:,117))
  call Hloop_Q_A(ntryL,G1H2(1),23,nMT,G2H2(117),n2h2(19))
call HGT_OLR(G1H4(54),1,1,4)
call HGT_invQ_OLR(G1H4(54),2,5,4)
  call Hloop_A_Q(ntryL,G1H4(54),-8,nMT,G2H4(31),n2h4(151))
  call Hloop_AV_Q(ntryL,G2H4(31),ex4(:),G2H2(118),m3h2x2(:,118),heltab2x4(:,:,118))
  call Hloop_QV_A(ntryL,G1H4(57),ex3(:),G1H2(1),m3h2x2(:,119),heltab2x4(:,:,119))
  call Hloop_Q_A(ntryL,G1H2(1),23,nMT,G2H2(119),n2h2(20))
  call Hloop_QV_A(ntryL,G1H4(58),ex3(:),G1H2(1),m3h2x2(:,120),heltab2x4(:,:,120))
  call Hloop_Q_A(ntryL,G1H2(1),23,nMT,G2H2(120),n2h2(21))
  call Hloop_QV_A(ntryL,G1H4(59),ex3(:),G1H2(1),m3h2x2(:,121),heltab2x4(:,:,121))
  call Hloop_Q_A(ntryL,G1H2(1),23,nMT,G2H2(121),n2h2(22))
call HGT_OLR(G1H4(60),1,1,4)
call HGT_invQ_OLR(G1H4(60),2,5,4)
  call Hloop_A_Q(ntryL,G1H4(60),-8,nMT,G2H4(32),n2h4(152))
  call Hloop_AV_Q(ntryL,G2H4(32),ex4(:),G2H2(122),m3h2x2(:,122),heltab2x4(:,:,122))
  call Hloop_QV_A(ntryL,G1H4(63),ex3(:),G1H2(1),m3h2x2(:,123),heltab2x4(:,:,123))
  call Hloop_Q_A(ntryL,G1H2(1),23,nMT,G2H2(123),n2h2(23))
  call Hloop_QV_A(ntryL,G1H4(64),ex3(:),G1H2(1),m3h2x2(:,124),heltab2x4(:,:,124))
  call Hloop_Q_A(ntryL,G1H2(1),23,nMT,G2H2(124),n2h2(24))
  call Hloop_QV_A(ntryL,G1H4(65),ex3(:),G1H2(1),m3h2x2(:,125),heltab2x4(:,:,125))
  call Hloop_Q_A(ntryL,G1H2(1),23,nMB,G2H2(125),n2h2(25))
call HGT_OLR(G1H4(66),1,1,4)
call HGT_invQ_OLR(G1H4(66),2,5,4)
  call Hloop_A_Q(ntryL,G1H4(66),-8,nMB,G2H4(33),n2h4(153))
  call Hloop_AV_Q(ntryL,G2H4(33),ex4(:),G2H2(126),m3h2x2(:,126),heltab2x4(:,:,126))
  call Hloop_QV_A(ntryL,G1H4(69),ex3(:),G1H2(1),m3h2x2(:,127),heltab2x4(:,:,127))
  call Hloop_Q_A(ntryL,G1H2(1),23,nMB,G2H2(127),n2h2(26))
  call Hloop_QV_A(ntryL,G1H4(70),ex3(:),G1H2(1),m3h2x2(:,128),heltab2x4(:,:,128))
  call Hloop_Q_A(ntryL,G1H2(1),23,nMB,G2H2(128),n2h2(27))
  call Hloop_SV_T(ntryL,G1H4(71),19,ex3(:),4,G2H2(129),m3h2x2(:,129),heltab2x4(:,:,129))
call HGT_OLR(G1H4(72),1,1,4)
call HGT_invQ_OLR(G1H4(72),2,5,4)
  call Hloop_TV_S(ntryL,G1H4(72),-8,ex4(:),8,G2H2(130),m3h2x2(:,130),heltab2x4(:,:,130))
  call Hloop_SV_T(ntryL,G1H4(75),19,ex3(:),4,G2H2(131),m3h2x2(:,131),heltab2x4(:,:,131))
  call Hloop_SV_T(ntryL,G1H4(76),19,ex3(:),4,G2H2(132),m3h2x2(:,132),heltab2x4(:,:,132))
  call Hloop_QV_A(ntryL,G1H4(77),ex3(:),G1H2(1),m3h2x2(:,133),heltab2x4(:,:,133))
  call Hloop_Q_A(ntryL,G1H2(1),23,nMT,G2H2(133),n2h2(28))
call HGT_OLR(G1H4(78),1,1,4)
call HGT_invQ_OLR(G1H4(78),2,5,4)
  call Hloop_A_Q(ntryL,G1H4(78),-8,nMT,G2H4(34),n2h4(155))
  call Hloop_AV_Q(ntryL,G2H4(34),ex4(:),G2H2(134),m3h2x2(:,134),heltab2x4(:,:,134))
  call Hloop_QV_A(ntryL,G1H4(81),ex3(:),G1H2(1),m3h2x2(:,135),heltab2x4(:,:,135))
  call Hloop_Q_A(ntryL,G1H2(1),23,nMT,G2H2(135),n2h2(29))
  call Hloop_QV_A(ntryL,G1H4(82),ex3(:),G1H2(1),m3h2x2(:,136),heltab2x4(:,:,136))
  call Hloop_Q_A(ntryL,G1H2(1),23,nMT,G2H2(136),n2h2(30))
  call Hloop_SV_T(ntryL,G1H4(83),19,ex3(:),4,G2H2(137),m3h2x2(:,137),heltab2x4(:,:,137))
call HGT_raise_alpha_OLR(G1H4(84),1,1,4)
call HGT_raise_alpha_invQ_OLR(G1H4(84),2,5,4)
  call Hloop_VV_S(ntryL,G1H4(84),ex4(:),G1H2(1),m3h2x2(:,138),heltab2x4(:,:,138))
  call Hloop_SV_T(ntryL,G1H4(87),19,ex3(:),4,G2H2(138),m3h2x2(:,139),heltab2x4(:,:,139))
  call Hloop_SV_T(ntryL,G1H4(88),19,ex3(:),4,G2H2(139),m3h2x2(:,140),heltab2x4(:,:,140))
  call Hloop_UW_V(ntryL,G1H4(89),19,ex3(:),4,G2H2(140),m3h2x2(:,141),heltab2x4(:,:,141))
call HGT_OLR(G1H4(90),1,1,4)
call HGT_invQ_OLR(G1H4(90),2,5,4)
  call Hloop_SV_V(ntryL,G1H4(90),ex4(:),G1H2(2),m3h2x2(:,142),heltab2x4(:,:,142))
  call Hloop_UW_V(ntryL,G1H4(93),19,ex3(:),4,G2H2(141),m3h2x2(:,143),heltab2x4(:,:,143))
  call Hloop_UW_V(ntryL,G1H4(94),19,ex3(:),4,G2H2(142),m3h2x2(:,144),heltab2x4(:,:,144))
  call Hloop_UW_V(ntryL,G1H4(95),19,ex3(:),4,G2H2(143),m3h2x2(:,145),heltab2x4(:,:,145))
call HGT_raise_alpha_OLR(G1H4(96),1,1,4)
call HGT_raise_alpha_invQ_OLR(G1H4(96),2,5,4)
  call Hloop_UV_W(ntryL,G1H4(96),-8,ex4(:),8,G2H2(144),m3h2x2(:,146),heltab2x4(:,:,146))
  call Hloop_UW_V(ntryL,G1H4(99),19,ex3(:),4,G2H2(145),m3h2x2(:,147),heltab2x4(:,:,147))
  call Hloop_UW_V(ntryL,G1H4(100),19,ex3(:),4,G2H2(146),m3h2x2(:,148),heltab2x4(:,:,148))
  call Hloop_SQ_A(ntryL,G1H4(101),ex1(:),G1H2(3),ngH,m3h2x2(:,149),heltab2x4(:,:,149))
  call Hloop_Q_A(ntryL,G1H2(3),23,nMT,G2H2(147),n2h2(31))
call HGT_OLR(G1H4(102),1,1,4)
call HGT_invQ_OLR(G1H4(102),2,5,4)
  call Hloop_A_Q(ntryL,G1H4(102),-8,nMT,G2H4(36),n2h4(159))
  call Hloop_AV_Q(ntryL,G2H4(36),ex4(:),G2H2(148),m3h2x2(:,150),heltab2x4(:,:,150))
  call Hloop_SQ_A(ntryL,G1H4(105),ex1(:),G1H2(3),ngH,m3h2x2(:,151),heltab2x4(:,:,151))
  call Hloop_Q_A(ntryL,G1H2(3),23,nMT,G2H2(149),n2h2(32))
  call Hloop_SQ_A(ntryL,G1H4(106),ex1(:),G1H2(3),ngH,m3h2x2(:,152),heltab2x4(:,:,152))
  call Hloop_Q_A(ntryL,G1H2(3),23,nMT,G2H2(150),n2h2(33))
  call Hloop_SQ_A(ntryL,G1H4(107),ex1(:),G1H2(3),ngX,m3h2x2(:,153),heltab2x4(:,:,153))
  call Hloop_Q_A(ntryL,G1H2(3),23,nMT,G2H2(151),n2h2(34))
call HGT_OLR(G1H4(108),1,1,4)
call HGT_invQ_OLR(G1H4(108),2,5,4)
  call Hloop_A_Q(ntryL,G1H4(108),-8,nMT,G2H4(37),n2h4(160))
  call Hloop_AV_Q(ntryL,G2H4(37),ex4(:),G2H2(152),m3h2x2(:,154),heltab2x4(:,:,154))
  call Hloop_SQ_A(ntryL,G1H4(111),ex1(:),G1H2(3),ngX,m3h2x2(:,155),heltab2x4(:,:,155))
  call Hloop_Q_A(ntryL,G1H2(3),23,nMT,G2H2(153),n2h2(35))
  call Hloop_SQ_A(ntryL,G1H4(112),ex1(:),G1H2(3),ngX,m3h2x2(:,156),heltab2x4(:,:,156))
  call Hloop_Q_A(ntryL,G1H2(3),23,nMT,G2H2(154),n2h2(36))
  call Hloop_SQ_A(ntryL,G1H4(113),ex1(:),G1H2(3),ngPbt,m3h2x2(:,157),heltab2x4(:,:,157))
  call Hloop_Q_A(ntryL,G1H2(3),23,nMB,G2H2(155),n2h2(37))
call HGT_OLR(G1H4(114),1,1,4)
call HGT_invQ_OLR(G1H4(114),2,5,4)
  call Hloop_A_Q(ntryL,G1H4(114),-8,nMB,G2H4(50),n2h4(161))
  call Hloop_AV_Q(ntryL,G2H4(50),ex4(:),G2H2(156),m3h2x2(:,158),heltab2x4(:,:,158))
  call Hloop_SQ_A(ntryL,G1H4(117),ex1(:),G1H2(3),ngPbt,m3h2x2(:,159),heltab2x4(:,:,159))
  call Hloop_Q_A(ntryL,G1H2(3),23,nMB,G2H2(157),n2h2(38))
  call Hloop_SQ_A(ntryL,G1H4(118),ex1(:),G1H2(3),ngPbt,m3h2x2(:,160),heltab2x4(:,:,160))
  call Hloop_Q_A(ntryL,G1H2(3),23,nMB,G2H2(158),n2h2(39))
  call Hloop_VQ_A(ntryL,G1H4(119),ex1(:),G1H2(3),m3h2x2(:,161),heltab2x4(:,:,161))
  call Hloop_Q_A(ntryL,G1H2(3),23,nMT,G2H2(159),n2h2(40))
call HGT_OLR(G1H4(120),1,1,4)
call HGT_invQ_OLR(G1H4(120),2,5,4)
  call Hloop_A_Q(ntryL,G1H4(120),-8,nMT,G2H4(51),n2h4(162))
  call Hloop_AV_Q(ntryL,G2H4(51),ex4(:),G2H2(160),m3h2x2(:,162),heltab2x4(:,:,162))
  call Hloop_VQ_A(ntryL,G1H4(123),ex1(:),G1H2(3),m3h2x2(:,163),heltab2x4(:,:,163))
  call Hloop_Q_A(ntryL,G1H2(3),23,nMT,G2H2(161),n2h2(41))
  call Hloop_VQ_A(ntryL,G1H4(124),ex1(:),G1H2(3),m3h2x2(:,164),heltab2x4(:,:,164))
  call Hloop_Q_A(ntryL,G1H2(3),23,nMT,G2H2(162),n2h2(42))
  call Hloop_ZQ_A(ntryL,G1H4(125),ex1(:),G1H2(3),ngZu,m3h2x2(:,165),heltab2x4(:,:,165))
  call Hloop_Q_A(ntryL,G1H2(3),23,nMT,G2H2(163),n2h2(43))
call HGT_OLR(G1H4(126),1,1,4)
call HGT_invQ_OLR(G1H4(126),2,5,4)
  call Hloop_A_Q(ntryL,G1H4(126),-8,nMT,G2H4(64),n2h4(163))
  call Hloop_AV_Q(ntryL,G2H4(64),ex4(:),G2H2(164),m3h2x2(:,166),heltab2x4(:,:,166))
  call Hloop_ZQ_A(ntryL,G1H4(129),ex1(:),G1H2(3),ngZu,m3h2x2(:,167),heltab2x4(:,:,167))
  call Hloop_Q_A(ntryL,G1H2(3),23,nMT,G2H2(165),n2h2(44))
  call Hloop_ZQ_A(ntryL,G1H4(130),ex1(:),G1H2(3),ngZu,m3h2x2(:,168),heltab2x4(:,:,168))
  call Hloop_Q_A(ntryL,G1H2(3),23,nMT,G2H2(166),n2h2(45))
  call Hloop_WQ_A(ntryL,G1H4(131),ex1(:),G1H2(3),m3h2x2(:,169),heltab2x4(:,:,169))
  call Hloop_Q_A(ntryL,G1H2(3),23,nMB,G2H2(167),n2h2(46))
call HGT_OLR(G1H4(132),1,1,4)
call HGT_invQ_OLR(G1H4(132),2,5,4)
  call Hloop_A_Q(ntryL,G1H4(132),-8,nMB,G2H4(65),n2h4(164))
  call Hloop_AV_Q(ntryL,G2H4(65),ex4(:),G2H2(168),m3h2x2(:,170),heltab2x4(:,:,170))
  call Hloop_WQ_A(ntryL,G1H4(135),ex1(:),G1H2(3),m3h2x2(:,171),heltab2x4(:,:,171))
  call Hloop_Q_A(ntryL,G1H2(3),23,nMB,G2H2(169),n2h2(47))
  call Hloop_WQ_A(ntryL,G1H4(136),ex1(:),G1H2(3),m3h2x2(:,172),heltab2x4(:,:,172))
  call Hloop_Q_A(ntryL,G1H2(3),23,nMB,G2H2(170),n2h2(48))
  call Hloop_QV_A(ntryL,G1H4(137),ex4(:),G1H2(3),m3h2x2(:,173),heltab2x4(:,:,173))
  call Hloop_Q_A(ntryL,G1H2(3),27,nMT,G2H2(171),n2h2(49))
call HGT_OLR(G1H4(138),1,1,4)
call HGT_invQ_OLR(G1H4(138),2,5,4)
  call Hloop_A_Q(ntryL,G1H4(138),-4,nMT,G2H4(1),n2h4(165))
  call Hloop_AV_Q(ntryL,G2H4(1),ex3(:),G2H2(172),m3h2x2(:,174),heltab2x4(:,:,174))
  call Hloop_QV_A(ntryL,G1H4(141),ex4(:),G1H2(3),m3h2x2(:,175),heltab2x4(:,:,175))
  call Hloop_Q_A(ntryL,G1H2(3),27,nMT,G2H2(173),n2h2(50))
  call Hloop_QV_A(ntryL,G1H4(142),ex4(:),G1H2(3),m3h2x2(:,176),heltab2x4(:,:,176))
  call Hloop_Q_A(ntryL,G1H2(3),27,nMT,G2H2(174),n2h2(51))
  call Hloop_QV_A(ntryL,G1H4(143),ex4(:),G1H2(3),m3h2x2(:,177),heltab2x4(:,:,177))
  call Hloop_Q_A(ntryL,G1H2(3),27,nMT,G2H2(175),n2h2(52))
call HGT_OLR(G1H4(144),1,1,4)
call HGT_invQ_OLR(G1H4(144),2,5,4)
  call Hloop_A_Q(ntryL,G1H4(144),-4,nMT,G2H4(2),n2h4(166))
  call Hloop_AV_Q(ntryL,G2H4(2),ex3(:),G2H2(176),m3h2x2(:,178),heltab2x4(:,:,178))
  call Hloop_QV_A(ntryL,G1H4(147),ex4(:),G1H2(3),m3h2x2(:,179),heltab2x4(:,:,179))
  call Hloop_Q_A(ntryL,G1H2(3),27,nMT,G2H2(177),n2h2(53))
  call Hloop_QV_A(ntryL,G1H4(148),ex4(:),G1H2(3),m3h2x2(:,180),heltab2x4(:,:,180))
  call Hloop_Q_A(ntryL,G1H2(3),27,nMT,G2H2(178),n2h2(54))
  call Hloop_QV_A(ntryL,G1H4(149),ex4(:),G1H2(3),m3h2x2(:,181),heltab2x4(:,:,181))
  call Hloop_Q_A(ntryL,G1H2(3),27,nMB,G2H2(179),n2h2(55))
call HGT_OLR(G1H4(150),1,1,4)
call HGT_invQ_OLR(G1H4(150),2,5,4)
  call Hloop_A_Q(ntryL,G1H4(150),-4,nMB,G2H4(3),n2h4(167))
  call Hloop_AV_Q(ntryL,G2H4(3),ex3(:),G2H2(180),m3h2x2(:,182),heltab2x4(:,:,182))
  call Hloop_QV_A(ntryL,G1H4(153),ex4(:),G1H2(3),m3h2x2(:,183),heltab2x4(:,:,183))
  call Hloop_Q_A(ntryL,G1H2(3),27,nMB,G2H2(181),n2h2(56))
  call Hloop_QV_A(ntryL,G1H4(154),ex4(:),G1H2(3),m3h2x2(:,184),heltab2x4(:,:,184))
  call Hloop_Q_A(ntryL,G1H2(3),27,nMB,G2H2(182),n2h2(57))
  call Hloop_SV_T(ntryL,G1H4(155),19,ex4(:),8,G2H2(183),m3h2x2(:,185),heltab2x4(:,:,185))
call HGT_OLR(G1H4(156),1,1,4)
call HGT_invQ_OLR(G1H4(156),2,5,4)
  call Hloop_TV_S(ntryL,G1H4(156),-4,ex3(:),4,G2H2(184),m3h2x2(:,186),heltab2x4(:,:,186))
  call Hloop_SV_T(ntryL,G1H4(159),19,ex4(:),8,G2H2(185),m3h2x2(:,187),heltab2x4(:,:,187))
  call Hloop_SV_T(ntryL,G1H4(160),19,ex4(:),8,G2H2(186),m3h2x2(:,188),heltab2x4(:,:,188))
  call Hloop_QV_A(ntryL,G1H4(161),ex4(:),G1H2(3),m3h2x2(:,189),heltab2x4(:,:,189))
  call Hloop_Q_A(ntryL,G1H2(3),27,nMT,G2H2(187),n2h2(58))
call HGT_OLR(G1H4(162),1,1,4)
call HGT_invQ_OLR(G1H4(162),2,5,4)
  call Hloop_A_Q(ntryL,G1H4(162),-4,nMT,G2H4(4),n2h4(169))
  call Hloop_AV_Q(ntryL,G2H4(4),ex3(:),G2H2(188),m3h2x2(:,190),heltab2x4(:,:,190))
  call Hloop_QV_A(ntryL,G1H4(165),ex4(:),G1H2(3),m3h2x2(:,191),heltab2x4(:,:,191))
  call Hloop_Q_A(ntryL,G1H2(3),27,nMT,G2H2(189),n2h2(59))
  call Hloop_QV_A(ntryL,G1H4(166),ex4(:),G1H2(3),m3h2x2(:,192),heltab2x4(:,:,192))
  call Hloop_Q_A(ntryL,G1H2(3),27,nMT,G2H2(190),n2h2(60))
  call Hloop_SV_T(ntryL,G1H4(167),19,ex4(:),8,G2H2(191),m3h2x2(:,193),heltab2x4(:,:,193))
call HGT_raise_alpha_OLR(G1H4(168),1,1,4)
call HGT_raise_alpha_invQ_OLR(G1H4(168),2,5,4)
  call Hloop_VV_S(ntryL,G1H4(168),ex3(:),G1H2(3),m3h2x2(:,194),heltab2x4(:,:,194))
  call Hloop_SV_T(ntryL,G1H4(171),19,ex4(:),8,G2H2(192),m3h2x2(:,195),heltab2x4(:,:,195))
  call Hloop_SV_T(ntryL,G1H4(172),19,ex4(:),8,G2H2(193),m3h2x2(:,196),heltab2x4(:,:,196))
  call Hloop_UW_V(ntryL,G1H4(173),19,ex4(:),8,G2H2(194),m3h2x2(:,197),heltab2x4(:,:,197))
call HGT_OLR(G1H4(174),1,1,4)
call HGT_invQ_OLR(G1H4(174),2,5,4)
  call Hloop_SV_V(ntryL,G1H4(174),ex3(:),G1H2(4),m3h2x2(:,198),heltab2x4(:,:,198))
  call Hloop_UW_V(ntryL,G1H4(177),19,ex4(:),8,G2H2(195),m3h2x2(:,199),heltab2x4(:,:,199))
  call Hloop_UW_V(ntryL,G1H4(178),19,ex4(:),8,G2H2(196),m3h2x2(:,200),heltab2x4(:,:,200))
  call Hloop_UW_V(ntryL,G1H4(179),19,ex4(:),8,G2H2(197),m3h2x2(:,201),heltab2x4(:,:,201))
call HGT_raise_alpha_OLR(G1H4(180),1,1,4)
call HGT_raise_alpha_invQ_OLR(G1H4(180),2,5,4)
  call Hloop_UV_W(ntryL,G1H4(180),-4,ex3(:),4,G2H2(198),m3h2x2(:,202),heltab2x4(:,:,202))
  call Hloop_UW_V(ntryL,G1H4(183),19,ex4(:),8,G2H2(199),m3h2x2(:,203),heltab2x4(:,:,203))
  call Hloop_UW_V(ntryL,G1H4(184),19,ex4(:),8,G2H2(200),m3h2x2(:,204),heltab2x4(:,:,204))
  call Hloop_AV_Q(ntryL,G1H4(185),ex3(:),G1H2(5),m3h2x2(:,205),heltab2x4(:,:,205))
  call Hloop_A_Q(ntryL,G1H2(5),23,nMT,G2H2(201),n2h2(61))
call HGT_OLR(G1H4(186),1,1,4)
call HGT_invQ_OLR(G1H4(186),2,5,4)
  call Hloop_Q_A(ntryL,G1H4(186),-8,nMT,G2H4(5),n2h4(173))
  call Hloop_QV_A(ntryL,G2H4(5),ex4(:),G2H2(202),m3h2x2(:,206),heltab2x4(:,:,206))
  call Hloop_AV_Q(ntryL,G1H4(189),ex3(:),G1H2(5),m3h2x2(:,207),heltab2x4(:,:,207))
  call Hloop_A_Q(ntryL,G1H2(5),23,nMT,G2H2(203),n2h2(62))
  call Hloop_AV_Q(ntryL,G1H4(190),ex3(:),G1H2(5),m3h2x2(:,208),heltab2x4(:,:,208))
  call Hloop_A_Q(ntryL,G1H2(5),23,nMT,G2H2(204),n2h2(63))
  call Hloop_AV_Q(ntryL,G1H4(191),ex3(:),G1H2(5),m3h2x2(:,209),heltab2x4(:,:,209))
  call Hloop_A_Q(ntryL,G1H2(5),23,nMT,G2H2(205),n2h2(64))
call HGT_OLR(G1H4(192),1,1,4)
call HGT_invQ_OLR(G1H4(192),2,5,4)
  call Hloop_Q_A(ntryL,G1H4(192),-8,nMT,G2H4(6),n2h4(174))
  call Hloop_QV_A(ntryL,G2H4(6),ex4(:),G2H2(206),m3h2x2(:,210),heltab2x4(:,:,210))
  call Hloop_AV_Q(ntryL,G1H4(195),ex3(:),G1H2(5),m3h2x2(:,211),heltab2x4(:,:,211))
  call Hloop_A_Q(ntryL,G1H2(5),23,nMT,G2H2(207),n2h2(65))
  call Hloop_AV_Q(ntryL,G1H4(196),ex3(:),G1H2(5),m3h2x2(:,212),heltab2x4(:,:,212))
  call Hloop_A_Q(ntryL,G1H2(5),23,nMT,G2H2(208),n2h2(66))
  call Hloop_AV_Q(ntryL,G1H4(197),ex3(:),G1H2(5),m3h2x2(:,213),heltab2x4(:,:,213))
  call Hloop_A_Q(ntryL,G1H2(5),23,nMB,G2H2(209),n2h2(67))
call HGT_OLR(G1H4(198),1,1,4)
call HGT_invQ_OLR(G1H4(198),2,5,4)
  call Hloop_Q_A(ntryL,G1H4(198),-8,nMB,G2H4(102),n2h4(175))
  call Hloop_QV_A(ntryL,G2H4(102),ex4(:),G2H2(210),m3h2x2(:,214),heltab2x4(:,:,214))
  call Hloop_AV_Q(ntryL,G1H4(201),ex3(:),G1H2(5),m3h2x2(:,215),heltab2x4(:,:,215))
  call Hloop_A_Q(ntryL,G1H2(5),23,nMB,G2H2(211),n2h2(68))
  call Hloop_AV_Q(ntryL,G1H4(202),ex3(:),G1H2(5),m3h2x2(:,216),heltab2x4(:,:,216))
  call Hloop_A_Q(ntryL,G1H2(5),23,nMB,G2H2(212),n2h2(69))
  call Hloop_TV_S(ntryL,G1H4(203),19,ex3(:),4,G2H2(213),m3h2x2(:,217),heltab2x4(:,:,217))
call HGT_OLR(G1H4(204),1,1,4)
call HGT_invQ_OLR(G1H4(204),2,5,4)
  call Hloop_SV_T(ntryL,G1H4(204),-8,ex4(:),8,G2H2(214),m3h2x2(:,218),heltab2x4(:,:,218))
  call Hloop_TV_S(ntryL,G1H4(207),19,ex3(:),4,G2H2(215),m3h2x2(:,219),heltab2x4(:,:,219))
  call Hloop_TV_S(ntryL,G1H4(208),19,ex3(:),4,G2H2(216),m3h2x2(:,220),heltab2x4(:,:,220))
  call Hloop_AV_Q(ntryL,G1H4(209),ex3(:),G1H2(5),m3h2x2(:,221),heltab2x4(:,:,221))
  call Hloop_A_Q(ntryL,G1H2(5),23,nMT,G2H2(217),n2h2(70))
call HGT_OLR(G1H4(210),1,1,4)
call HGT_invQ_OLR(G1H4(210),2,5,4)
  call Hloop_Q_A(ntryL,G1H4(210),-8,nMT,G2H4(93),n2h4(177))
  call Hloop_QV_A(ntryL,G2H4(93),ex4(:),G2H2(218),m3h2x2(:,222),heltab2x4(:,:,222))
  call Hloop_AV_Q(ntryL,G1H4(213),ex3(:),G1H2(5),m3h2x2(:,223),heltab2x4(:,:,223))
  call Hloop_A_Q(ntryL,G1H2(5),23,nMT,G2H2(219),n2h2(71))
  call Hloop_AV_Q(ntryL,G1H4(214),ex3(:),G1H2(5),m3h2x2(:,224),heltab2x4(:,:,224))
  call Hloop_A_Q(ntryL,G1H2(5),23,nMT,G2H2(220),n2h2(72))
  call Hloop_TV_S(ntryL,G1H4(215),19,ex3(:),4,G2H2(221),m3h2x2(:,225),heltab2x4(:,:,225))
call HGT_raise_alpha_OLR(G1H4(216),1,1,4)
call HGT_raise_alpha_invQ_OLR(G1H4(216),2,5,4)
  call Hloop_VV_S(ntryL,G1H4(216),ex4(:),G1H2(5),m3h2x2(:,226),heltab2x4(:,:,226))
  call Hloop_TV_S(ntryL,G1H4(219),19,ex3(:),4,G2H2(222),m3h2x2(:,227),heltab2x4(:,:,227))
  call Hloop_TV_S(ntryL,G1H4(220),19,ex3(:),4,G2H2(223),m3h2x2(:,228),heltab2x4(:,:,228))
  call Hloop_UV_W(ntryL,G1H4(221),19,ex3(:),4,G2H2(224),m3h2x2(:,229),heltab2x4(:,:,229))
call HGT_OLR(G1H4(222),1,1,4)
call HGT_invQ_OLR(G1H4(222),2,5,4)
  call Hloop_SV_V(ntryL,G1H4(222),ex4(:),G1H2(6),m3h2x2(:,230),heltab2x4(:,:,230))
  call Hloop_UV_W(ntryL,G1H4(225),19,ex3(:),4,G2H2(225),m3h2x2(:,231),heltab2x4(:,:,231))
  call Hloop_UV_W(ntryL,G1H4(226),19,ex3(:),4,G2H2(226),m3h2x2(:,232),heltab2x4(:,:,232))
  call Hloop_UV_W(ntryL,G1H4(227),19,ex3(:),4,G2H2(227),m3h2x2(:,233),heltab2x4(:,:,233))
call HGT_raise_alpha_OLR(G1H4(228),1,1,4)
call HGT_raise_alpha_invQ_OLR(G1H4(228),2,5,4)
  call Hloop_UW_V(ntryL,G1H4(228),-8,ex4(:),8,G2H2(228),m3h2x2(:,234),heltab2x4(:,:,234))
  call Hloop_UV_W(ntryL,G1H4(231),19,ex3(:),4,G2H2(229),m3h2x2(:,235),heltab2x4(:,:,235))
  call Hloop_UV_W(ntryL,G1H4(232),19,ex3(:),4,G2H2(230),m3h2x2(:,236),heltab2x4(:,:,236))
  call Hloop_AV_Q(ntryL,G1H4(233),ex4(:),G1H2(7),m3h2x2(:,237),heltab2x4(:,:,237))
  call Hloop_A_Q(ntryL,G1H2(7),27,nMT,G2H2(231),n2h2(73))
call HGT_OLR(G1H4(234),1,1,4)
call HGT_invQ_OLR(G1H4(234),2,5,4)
  call Hloop_Q_A(ntryL,G1H4(234),-4,nMT,G2H4(106),n2h4(181))
  call Hloop_QV_A(ntryL,G2H4(106),ex3(:),G2H2(232),m3h2x2(:,238),heltab2x4(:,:,238))
  call Hloop_AV_Q(ntryL,G1H4(237),ex4(:),G1H2(7),m3h2x2(:,239),heltab2x4(:,:,239))
  call Hloop_A_Q(ntryL,G1H2(7),27,nMT,G2H2(233),n2h2(74))
  call Hloop_AV_Q(ntryL,G1H4(238),ex4(:),G1H2(7),m3h2x2(:,240),heltab2x4(:,:,240))
  call Hloop_A_Q(ntryL,G1H2(7),27,nMT,G2H2(234),n2h2(75))
  call Hloop_AV_Q(ntryL,G1H4(239),ex4(:),G1H2(7),m3h2x2(:,241),heltab2x4(:,:,241))
  call Hloop_A_Q(ntryL,G1H2(7),27,nMT,G2H2(235),n2h2(76))
call HGT_OLR(G1H4(240),1,1,4)
call HGT_invQ_OLR(G1H4(240),2,5,4)
  call Hloop_Q_A(ntryL,G1H4(240),-4,nMT,G2H4(98),n2h4(182))
  call Hloop_QV_A(ntryL,G2H4(98),ex3(:),G2H2(236),m3h2x2(:,242),heltab2x4(:,:,242))
  call Hloop_AV_Q(ntryL,G1H4(243),ex4(:),G1H2(7),m3h2x2(:,243),heltab2x4(:,:,243))
  call Hloop_A_Q(ntryL,G1H2(7),27,nMT,G2H2(237),n2h2(77))
  call Hloop_AV_Q(ntryL,G1H4(244),ex4(:),G1H2(7),m3h2x2(:,244),heltab2x4(:,:,244))
  call Hloop_A_Q(ntryL,G1H2(7),27,nMT,G2H2(238),n2h2(78))
  call Hloop_AV_Q(ntryL,G1H4(245),ex4(:),G1H2(7),m3h2x2(:,245),heltab2x4(:,:,245))
  call Hloop_A_Q(ntryL,G1H2(7),27,nMB,G2H2(239),n2h2(79))
call HGT_OLR(G1H4(246),1,1,4)
call HGT_invQ_OLR(G1H4(246),2,5,4)
  call Hloop_Q_A(ntryL,G1H4(246),-4,nMB,G2H4(11),n2h4(183))
  call Hloop_QV_A(ntryL,G2H4(11),ex3(:),G2H2(240),m3h2x2(:,246),heltab2x4(:,:,246))
  call Hloop_AV_Q(ntryL,G1H4(249),ex4(:),G1H2(7),m3h2x2(:,247),heltab2x4(:,:,247))
  call Hloop_A_Q(ntryL,G1H2(7),27,nMB,G2H2(241),n2h2(80))
  call Hloop_AV_Q(ntryL,G1H4(250),ex4(:),G1H2(7),m3h2x2(:,248),heltab2x4(:,:,248))
  call Hloop_A_Q(ntryL,G1H2(7),27,nMB,G2H2(242),n2h2(81))
  call Hloop_TV_S(ntryL,G1H4(251),19,ex4(:),8,G2H2(243),m3h2x2(:,249),heltab2x4(:,:,249))
call HGT_OLR(G1H4(252),1,1,4)
call HGT_invQ_OLR(G1H4(252),2,5,4)
  call Hloop_SV_T(ntryL,G1H4(252),-4,ex3(:),4,G2H2(244),m3h2x2(:,250),heltab2x4(:,:,250))
  call Hloop_TV_S(ntryL,G1H4(255),19,ex4(:),8,G2H2(245),m3h2x2(:,251),heltab2x4(:,:,251))
  call Hloop_TV_S(ntryL,G1H4(256),19,ex4(:),8,G2H2(246),m3h2x2(:,252),heltab2x4(:,:,252))
  call Hloop_AV_Q(ntryL,G1H4(257),ex4(:),G1H2(7),m3h2x2(:,253),heltab2x4(:,:,253))
  call Hloop_A_Q(ntryL,G1H2(7),27,nMT,G2H2(247),n2h2(82))
call HGT_OLR(G1H4(258),1,1,4)
call HGT_invQ_OLR(G1H4(258),2,5,4)
  call Hloop_Q_A(ntryL,G1H4(258),-4,nMT,G2H4(16),n2h4(185))
  call Hloop_QV_A(ntryL,G2H4(16),ex3(:),G2H2(248),m3h2x2(:,254),heltab2x4(:,:,254))
  call Hloop_AV_Q(ntryL,G1H4(261),ex4(:),G1H2(7),m3h2x2(:,255),heltab2x4(:,:,255))
  call Hloop_A_Q(ntryL,G1H2(7),27,nMT,G2H2(249),n2h2(83))
  call Hloop_AV_Q(ntryL,G1H4(262),ex4(:),G1H2(7),m3h2x2(:,256),heltab2x4(:,:,256))
  call Hloop_A_Q(ntryL,G1H2(7),27,nMT,G2H2(250),n2h2(84))
  call Hloop_TV_S(ntryL,G1H4(263),19,ex4(:),8,G2H2(251),m3h2x2(:,257),heltab2x4(:,:,257))
call HGT_raise_alpha_OLR(G1H4(264),1,1,4)
call HGT_raise_alpha_invQ_OLR(G1H4(264),2,5,4)
  call Hloop_VV_S(ntryL,G1H4(264),ex3(:),G1H2(7),m3h2x2(:,258),heltab2x4(:,:,258))
  call Hloop_TV_S(ntryL,G1H4(267),19,ex4(:),8,G2H2(252),m3h2x2(:,259),heltab2x4(:,:,259))
  call Hloop_TV_S(ntryL,G1H4(268),19,ex4(:),8,G2H2(253),m3h2x2(:,260),heltab2x4(:,:,260))
  call Hloop_UV_W(ntryL,G1H4(269),19,ex4(:),8,G2H2(254),m3h2x2(:,261),heltab2x4(:,:,261))
call HGT_OLR(G1H4(270),1,1,4)
call HGT_invQ_OLR(G1H4(270),2,5,4)
  call Hloop_SV_V(ntryL,G1H4(270),ex3(:),G1H2(8),m3h2x2(:,262),heltab2x4(:,:,262))
  call Hloop_UV_W(ntryL,G1H4(273),19,ex4(:),8,G2H2(255),m3h2x2(:,263),heltab2x4(:,:,263))
  call Hloop_UV_W(ntryL,G1H4(274),19,ex4(:),8,G2H2(256),m3h2x2(:,264),heltab2x4(:,:,264))
  call Hloop_UV_W(ntryL,G1H4(275),19,ex4(:),8,G2H2(257),m3h2x2(:,265),heltab2x4(:,:,265))
call HGT_raise_alpha_OLR(G1H4(276),1,1,4)
call HGT_raise_alpha_invQ_OLR(G1H4(276),2,5,4)
  call Hloop_UW_V(ntryL,G1H4(276),-4,ex3(:),4,G2H2(258),m3h2x2(:,266),heltab2x4(:,:,266))
  call Hloop_UV_W(ntryL,G1H4(279),19,ex4(:),8,G2H2(259),m3h2x2(:,267),heltab2x4(:,:,267))
  call Hloop_UV_W(ntryL,G1H4(280),19,ex4(:),8,G2H2(260),m3h2x2(:,268),heltab2x4(:,:,268))
  call Hloop_SQ_A(ntryL,G1H4(281),ex1(:),G1H2(9),ngPbt,m3h2x2(:,269),heltab2x4(:,:,269))
  call Hloop_Q_A(ntryL,G1H2(9),23,nMB,G2H2(261),n2h2(85))
call HGT_OLR(G1H4(282),1,1,4)
call HGT_invQ_OLR(G1H4(282),2,5,4)
  call Hloop_A_Q(ntryL,G1H4(282),-8,nMB,G2H4(17),n2h4(189))
  call Hloop_AV_Q(ntryL,G2H4(17),ex4(:),G2H2(262),m3h2x2(:,270),heltab2x4(:,:,270))
  call Hloop_SQ_A(ntryL,G1H4(285),ex1(:),G1H2(9),ngPbt,m3h2x2(:,271),heltab2x4(:,:,271))
  call Hloop_Q_A(ntryL,G1H2(9),23,nMB,G2H2(263),n2h2(86))
  call Hloop_SQ_A(ntryL,G1H4(286),ex1(:),G1H2(9),ngPbt,m3h2x2(:,272),heltab2x4(:,:,272))
  call Hloop_Q_A(ntryL,G1H2(9),23,nMB,G2H2(264),n2h2(87))
  call Hloop_WQ_A(ntryL,G1H4(287),ex1(:),G1H2(9),m3h2x2(:,273),heltab2x4(:,:,273))
  call Hloop_Q_A(ntryL,G1H2(9),23,nMB,G2H2(265),n2h2(88))
call HGT_OLR(G1H4(288),1,1,4)
call HGT_invQ_OLR(G1H4(288),2,5,4)
  call Hloop_A_Q(ntryL,G1H4(288),-8,nMB,G2H4(14),n2h4(190))
  call Hloop_AV_Q(ntryL,G2H4(14),ex4(:),G2H2(266),m3h2x2(:,274),heltab2x4(:,:,274))
  call Hloop_WQ_A(ntryL,G1H4(291),ex1(:),G1H2(9),m3h2x2(:,275),heltab2x4(:,:,275))
  call Hloop_Q_A(ntryL,G1H2(9),23,nMB,G2H2(267),n2h2(89))
  call Hloop_WQ_A(ntryL,G1H4(292),ex1(:),G1H2(9),m3h2x2(:,276),heltab2x4(:,:,276))
  call Hloop_Q_A(ntryL,G1H2(9),23,nMB,G2H2(268),n2h2(90))
  call Hloop_SQ_A(ntryL,G1H4(293),ex1(:),G1H2(9),ngPbt,m3h2x2(:,277),heltab2x4(:,:,277))
  call Hloop_Q_A(ntryL,G1H2(9),27,nMB,G2H2(269),n2h2(91))
call HGT_OLR(G1H4(294),1,1,4)
call HGT_invQ_OLR(G1H4(294),2,5,4)
  call Hloop_A_Q(ntryL,G1H4(294),-4,nMB,G2H4(15),n2h4(191))
  call Hloop_AV_Q(ntryL,G2H4(15),ex3(:),G2H2(270),m3h2x2(:,278),heltab2x4(:,:,278))
  call Hloop_SQ_A(ntryL,G1H4(297),ex1(:),G1H2(9),ngPbt,m3h2x2(:,279),heltab2x4(:,:,279))
  call Hloop_Q_A(ntryL,G1H2(9),27,nMB,G2H2(271),n2h2(92))
  call Hloop_SQ_A(ntryL,G1H4(298),ex1(:),G1H2(9),ngPbt,m3h2x2(:,280),heltab2x4(:,:,280))
  call Hloop_Q_A(ntryL,G1H2(9),27,nMB,G2H2(272),n2h2(93))
  call Hloop_WQ_A(ntryL,G1H4(299),ex1(:),G1H2(9),m3h2x2(:,281),heltab2x4(:,:,281))
  call Hloop_Q_A(ntryL,G1H2(9),27,nMB,G2H2(273),n2h2(94))
call HGT_OLR(G1H4(300),1,1,4)
call HGT_invQ_OLR(G1H4(300),2,5,4)
  call Hloop_A_Q(ntryL,G1H4(300),-4,nMB,G2H4(18),n2h4(192))
  call Hloop_AV_Q(ntryL,G2H4(18),ex3(:),G2H2(274),m3h2x2(:,282),heltab2x4(:,:,282))
  call Hloop_WQ_A(ntryL,G1H4(303),ex1(:),G1H2(9),m3h2x2(:,283),heltab2x4(:,:,283))
  call Hloop_Q_A(ntryL,G1H2(9),27,nMB,G2H2(275),n2h2(95))
  call Hloop_WQ_A(ntryL,G1H4(304),ex1(:),G1H2(9),m3h2x2(:,284),heltab2x4(:,:,284))
  call Hloop_Q_A(ntryL,G1H2(9),27,nMB,G2H2(276),n2h2(96))
  call Hloop_SA_Q(ntryL,G1H4(305),ex2(:),G1H2(9),ngPtb,m3h2x2(:,285),heltab2x4(:,:,285))
  call Hloop_A_Q(ntryL,G1H2(9),23,nMB,G2H2(277),n2h2(97))
call HGT_OLR(G1H4(306),1,1,4)
call HGT_invQ_OLR(G1H4(306),2,5,4)
  call Hloop_Q_A(ntryL,G1H4(306),-8,nMB,G2H4(19),n2h4(193))
  call Hloop_QV_A(ntryL,G2H4(19),ex4(:),G2H2(278),m3h2x2(:,286),heltab2x4(:,:,286))
  call Hloop_SA_Q(ntryL,G1H4(309),ex2(:),G1H2(9),ngPtb,m3h2x2(:,287),heltab2x4(:,:,287))
  call Hloop_A_Q(ntryL,G1H2(9),23,nMB,G2H2(279),n2h2(98))
  call Hloop_SA_Q(ntryL,G1H4(310),ex2(:),G1H2(9),ngPtb,m3h2x2(:,288),heltab2x4(:,:,288))
  call Hloop_A_Q(ntryL,G1H2(9),23,nMB,G2H2(280),n2h2(99))
  call Hloop_WA_Q(ntryL,G1H4(311),ex2(:),G1H2(9),m3h2x2(:,289),heltab2x4(:,:,289))
  call Hloop_A_Q(ntryL,G1H2(9),23,nMB,G2H2(281),n2h2(100))
call HGT_OLR(G1H4(312),1,1,4)
call HGT_invQ_OLR(G1H4(312),2,5,4)
  call Hloop_Q_A(ntryL,G1H4(312),-8,nMB,G2H4(20),n2h4(194))
  call Hloop_QV_A(ntryL,G2H4(20),ex4(:),G2H2(282),m3h2x2(:,290),heltab2x4(:,:,290))
  call Hloop_WA_Q(ntryL,G1H4(315),ex2(:),G1H2(9),m3h2x2(:,291),heltab2x4(:,:,291))
  call Hloop_A_Q(ntryL,G1H2(9),23,nMB,G2H2(283),n2h2(101))
  call Hloop_WA_Q(ntryL,G1H4(316),ex2(:),G1H2(9),m3h2x2(:,292),heltab2x4(:,:,292))
  call Hloop_A_Q(ntryL,G1H2(9),23,nMB,G2H2(284),n2h2(102))
  call Hloop_SV_T(ntryL,G1H4(317),21,ex4(:),8,G2H2(285),m3h2x2(:,293),heltab2x4(:,:,293))
call HGT_OLR(G1H4(318),1,1,4)
call HGT_invQ_OLR(G1H4(318),2,5,4)
  call Hloop_Q_A(ntryL,G1H4(318),-2,nMB,G2H4(21),n2h4(195))
  call Hloop_QA_S(ntryL,G2H4(21),ex2(:),G2H2(286),ngPtb,m3h2x2(:,294),heltab2x4(:,:,294))
  call Hloop_SV_T(ntryL,G1H4(321),21,ex4(:),8,G2H2(287),m3h2x2(:,295),heltab2x4(:,:,295))
  call Hloop_SV_T(ntryL,G1H4(322),21,ex4(:),8,G2H2(288),m3h2x2(:,296),heltab2x4(:,:,296))
  call Hloop_UW_V(ntryL,G1H4(323),21,ex4(:),8,G2H2(289),m3h2x2(:,297),heltab2x4(:,:,297))
call HGT_OLR(G1H4(324),1,1,4)
call HGT_invQ_OLR(G1H4(324),2,5,4)
  call Hloop_Q_A(ntryL,G1H4(324),-2,nMB,G2H4(22),n2h4(196))
  call Hloop_QA_W(ntryL,G2H4(22),ex2(:),G2H2(290),m3h2x2(:,298),heltab2x4(:,:,298))
  call Hloop_UW_V(ntryL,G1H4(327),21,ex4(:),8,G2H2(291),m3h2x2(:,299),heltab2x4(:,:,299))
  call Hloop_UW_V(ntryL,G1H4(328),21,ex4(:),8,G2H2(292),m3h2x2(:,300),heltab2x4(:,:,300))
  call Hloop_SA_Q(ntryL,G1H4(329),ex2(:),G1H2(9),ngPtb,m3h2x2(:,301),heltab2x4(:,:,301))
  call Hloop_A_Q(ntryL,G1H2(9),27,nMB,G2H2(293),n2h2(103))
call HGT_OLR(G1H4(330),1,1,4)
call HGT_invQ_OLR(G1H4(330),2,5,4)
  call Hloop_Q_A(ntryL,G1H4(330),-4,nMB,G2H4(23),n2h4(197))
  call Hloop_QV_A(ntryL,G2H4(23),ex3(:),G2H2(294),m3h2x2(:,302),heltab2x4(:,:,302))
  call Hloop_SA_Q(ntryL,G1H4(333),ex2(:),G1H2(9),ngPtb,m3h2x2(:,303),heltab2x4(:,:,303))
  call Hloop_A_Q(ntryL,G1H2(9),27,nMB,G2H2(295),n2h2(104))
  call Hloop_SA_Q(ntryL,G1H4(334),ex2(:),G1H2(9),ngPtb,m3h2x2(:,304),heltab2x4(:,:,304))
  call Hloop_A_Q(ntryL,G1H2(9),27,nMB,G2H2(296),n2h2(105))
  call Hloop_WA_Q(ntryL,G1H4(335),ex2(:),G1H2(9),m3h2x2(:,305),heltab2x4(:,:,305))
  call Hloop_A_Q(ntryL,G1H2(9),27,nMB,G2H2(297),n2h2(106))
call HGT_OLR(G1H4(336),1,1,4)
call HGT_invQ_OLR(G1H4(336),2,5,4)
  call Hloop_Q_A(ntryL,G1H4(336),-4,nMB,G2H4(24),n2h4(198))
  call Hloop_QV_A(ntryL,G2H4(24),ex3(:),G2H2(298),m3h2x2(:,306),heltab2x4(:,:,306))
  call Hloop_WA_Q(ntryL,G1H4(339),ex2(:),G1H2(9),m3h2x2(:,307),heltab2x4(:,:,307))
  call Hloop_A_Q(ntryL,G1H2(9),27,nMB,G2H2(299),n2h2(107))
  call Hloop_WA_Q(ntryL,G1H4(340),ex2(:),G1H2(9),m3h2x2(:,308),heltab2x4(:,:,308))
  call Hloop_A_Q(ntryL,G1H2(9),27,nMB,G2H2(300),n2h2(108))
  call Hloop_SV_T(ntryL,G1H4(341),25,ex3(:),4,G2H2(301),m3h2x2(:,309),heltab2x4(:,:,309))
call HGT_OLR(G1H4(342),1,1,4)
call HGT_invQ_OLR(G1H4(342),2,5,4)
  call Hloop_Q_A(ntryL,G1H4(342),-2,nMB,G2H4(25),n2h4(199))
  call Hloop_QA_S(ntryL,G2H4(25),ex2(:),G2H2(302),ngPtb,m3h2x2(:,310),heltab2x4(:,:,310))
  call Hloop_SV_T(ntryL,G1H4(345),25,ex3(:),4,G2H2(303),m3h2x2(:,311),heltab2x4(:,:,311))
  call Hloop_SV_T(ntryL,G1H4(346),25,ex3(:),4,G2H2(304),m3h2x2(:,312),heltab2x4(:,:,312))
  call Hloop_UW_V(ntryL,G1H4(347),25,ex3(:),4,G2H2(305),m3h2x2(:,313),heltab2x4(:,:,313))
call HGT_OLR(G1H4(348),1,1,4)
call HGT_invQ_OLR(G1H4(348),2,5,4)
  call Hloop_Q_A(ntryL,G1H4(348),-2,nMB,G2H4(26),n2h4(200))
  call Hloop_QA_W(ntryL,G2H4(26),ex2(:),G2H2(306),m3h2x2(:,314),heltab2x4(:,:,314))
  call Hloop_UW_V(ntryL,G1H4(351),25,ex3(:),4,G2H2(307),m3h2x2(:,315),heltab2x4(:,:,315))
  call Hloop_UW_V(ntryL,G1H4(352),25,ex3(:),4,G2H2(308),m3h2x2(:,316),heltab2x4(:,:,316))
  call Hloop_QV_A(ntryL,G1H4(353),ex4(:),G1H2(9),m3h2x2(:,317),heltab2x4(:,:,317))
  call Hloop_Q_A(ntryL,G1H2(9),29,nMB,G2H2(309),n2h2(109))
call HGT_OLR(G1H4(354),1,1,4)
call HGT_invQ_OLR(G1H4(354),2,5,4)
  call Hloop_SA_Q(ntryL,G1H4(354),ex2(:),G1H2(9),ngPtb,m3h2x2(:,318),heltab2x4(:,:,318))
  call Hloop_QV_A(ntryL,G1H4(359),ex4(:),G1H2(10),m3h2x2(:,319),heltab2x4(:,:,319))
  call Hloop_Q_A(ntryL,G1H2(10),29,nMB,G2H2(310),n2h2(110))
  call Hloop_QV_A(ntryL,G1H4(364),ex4(:),G1H2(10),m3h2x2(:,320),heltab2x4(:,:,320))
  call Hloop_Q_A(ntryL,G1H2(10),29,nMB,G2H2(311),n2h2(111))
call HGT_OLR(G1H4(360),1,1,4)
call HGT_invQ_OLR(G1H4(360),2,5,4)
  call Hloop_SA_Q(ntryL,G1H4(360),ex2(:),G1H2(10),ngPtb,m3h2x2(:,321),heltab2x4(:,:,321))
  call Hloop_QV_A(ntryL,G1H4(363),ex4(:),G1H2(11),m3h2x2(:,322),heltab2x4(:,:,322))
  call Hloop_Q_A(ntryL,G1H2(11),29,nMB,G2H2(312),n2h2(112))
call HGT_OLR(G1H4(365),1,1,4)
call HGT_invQ_OLR(G1H4(365),2,5,4)
  call Hloop_SA_Q(ntryL,G1H4(365),ex2(:),G1H2(11),ngPtb,m3h2x2(:,323),heltab2x4(:,:,323))
  call Hloop_QV_A(ntryL,G1H4(368),ex4(:),G1H2(12),m3h2x2(:,324),heltab2x4(:,:,324))
  call Hloop_Q_A(ntryL,G1H2(12),29,nMB,G2H2(313),n2h2(113))
  call Hloop_QV_A(ntryL,G1H4(369),ex4(:),G1H2(12),m3h2x2(:,325),heltab2x4(:,:,325))
  call Hloop_Q_A(ntryL,G1H2(12),29,nMB,G2H2(314),n2h2(114))
call HGT_raise_alpha_OLR(G1H4(370),1,1,4)
call HGT_raise_alpha_invQ_OLR(G1H4(370),2,5,4)
  call Hloop_WA_Q(ntryL,G1H4(370),ex2(:),G1H2(12),m3h2x2(:,326),heltab2x4(:,:,326))
  call Hloop_QV_A(ntryL,G1H4(375),ex4(:),G1H2(13),m3h2x2(:,327),heltab2x4(:,:,327))
  call Hloop_Q_A(ntryL,G1H2(13),29,nMB,G2H2(315),n2h2(115))
  call Hloop_QV_A(ntryL,G1H4(380),ex4(:),G1H2(13),m3h2x2(:,328),heltab2x4(:,:,328))
  call Hloop_Q_A(ntryL,G1H2(13),29,nMB,G2H2(316),n2h2(116))
call HGT_raise_alpha_OLR(G1H4(376),1,1,4)
call HGT_raise_alpha_invQ_OLR(G1H4(376),2,5,4)
  call Hloop_WA_Q(ntryL,G1H4(376),ex2(:),G1H2(13),m3h2x2(:,329),heltab2x4(:,:,329))
  call Hloop_QV_A(ntryL,G1H4(379),ex4(:),G1H2(14),m3h2x2(:,330),heltab2x4(:,:,330))
  call Hloop_Q_A(ntryL,G1H2(14),29,nMB,G2H2(317),n2h2(117))
call HGT_raise_alpha_OLR(G1H4(381),1,1,4)
call HGT_raise_alpha_invQ_OLR(G1H4(381),2,5,4)
  call Hloop_WA_Q(ntryL,G1H4(381),ex2(:),G1H2(14),m3h2x2(:,331),heltab2x4(:,:,331))
  call Hloop_QV_A(ntryL,G1H4(384),ex4(:),G1H2(15),m3h2x2(:,332),heltab2x4(:,:,332))
  call Hloop_Q_A(ntryL,G1H2(15),29,nMB,G2H2(318),n2h2(118))
  call Hloop_QV_A(ntryL,G1H4(385),ex3(:),G1H2(15),m3h2x2(:,333),heltab2x4(:,:,333))
  call Hloop_Q_A(ntryL,G1H2(15),29,nMB,G2H2(319),n2h2(119))
call HGT_OLR(G1H4(386),1,1,4)
call HGT_invQ_OLR(G1H4(386),2,5,4)
  call Hloop_SA_Q(ntryL,G1H4(386),ex2(:),G1H2(15),ngPtb,m3h2x2(:,334),heltab2x4(:,:,334))
  call Hloop_QV_A(ntryL,G1H4(391),ex3(:),G1H2(16),m3h2x2(:,335),heltab2x4(:,:,335))
  call Hloop_Q_A(ntryL,G1H2(16),29,nMB,G2H2(320),n2h2(120))
  call Hloop_QV_A(ntryL,G1H4(396),ex3(:),G1H2(16),m3h2x2(:,336),heltab2x4(:,:,336))
  call Hloop_Q_A(ntryL,G1H2(16),29,nMB,G2H2(321),n2h2(121))
call HGT_OLR(G1H4(392),1,1,4)
call HGT_invQ_OLR(G1H4(392),2,5,4)
  call Hloop_SA_Q(ntryL,G1H4(392),ex2(:),G1H2(16),ngPtb,m3h2x2(:,337),heltab2x4(:,:,337))
  call Hloop_QV_A(ntryL,G1H4(395),ex3(:),G1H2(17),m3h2x2(:,338),heltab2x4(:,:,338))
  call Hloop_Q_A(ntryL,G1H2(17),29,nMB,G2H2(322),n2h2(122))
call HGT_OLR(G1H4(397),1,1,4)
call HGT_invQ_OLR(G1H4(397),2,5,4)
  call Hloop_SA_Q(ntryL,G1H4(397),ex2(:),G1H2(17),ngPtb,m3h2x2(:,339),heltab2x4(:,:,339))
  call Hloop_QV_A(ntryL,G1H4(400),ex3(:),G1H2(18),m3h2x2(:,340),heltab2x4(:,:,340))
  call Hloop_Q_A(ntryL,G1H2(18),29,nMB,G2H2(323),n2h2(123))
  call Hloop_QV_A(ntryL,G1H4(401),ex3(:),G1H2(18),m3h2x2(:,341),heltab2x4(:,:,341))
  call Hloop_Q_A(ntryL,G1H2(18),29,nMB,G2H2(324),n2h2(124))
call HGT_raise_alpha_OLR(G1H4(402),1,1,4)
call HGT_raise_alpha_invQ_OLR(G1H4(402),2,5,4)
  call Hloop_WA_Q(ntryL,G1H4(402),ex2(:),G1H2(18),m3h2x2(:,342),heltab2x4(:,:,342))
  call Hloop_QV_A(ntryL,G1H4(407),ex3(:),G1H2(19),m3h2x2(:,343),heltab2x4(:,:,343))
  call Hloop_Q_A(ntryL,G1H2(19),29,nMB,G2H2(325),n2h2(125))
  call Hloop_QV_A(ntryL,G1H4(412),ex3(:),G1H2(19),m3h2x2(:,344),heltab2x4(:,:,344))
  call Hloop_Q_A(ntryL,G1H2(19),29,nMB,G2H2(326),n2h2(126))
call HGT_raise_alpha_OLR(G1H4(408),1,1,4)
call HGT_raise_alpha_invQ_OLR(G1H4(408),2,5,4)
  call Hloop_WA_Q(ntryL,G1H4(408),ex2(:),G1H2(19),m3h2x2(:,345),heltab2x4(:,:,345))
  call Hloop_QV_A(ntryL,G1H4(411),ex3(:),G1H2(20),m3h2x2(:,346),heltab2x4(:,:,346))
  call Hloop_Q_A(ntryL,G1H2(20),29,nMB,G2H2(327),n2h2(127))
call HGT_raise_alpha_OLR(G1H4(413),1,1,4)
call HGT_raise_alpha_invQ_OLR(G1H4(413),2,5,4)
  call Hloop_WA_Q(ntryL,G1H4(413),ex2(:),G1H2(20),m3h2x2(:,347),heltab2x4(:,:,347))
  call Hloop_QV_A(ntryL,G1H4(416),ex3(:),G1H2(21),m3h2x2(:,348),heltab2x4(:,:,348))
  call Hloop_Q_A(ntryL,G1H2(21),29,nMB,G2H2(328),n2h2(128))
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(140),[G2H2(5)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(129),[G2H2(6)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(143),[G2H2(7)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(137),[G2H2(8)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(194),[G2H2(13)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(183),[G2H2(14)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(197),[G2H2(15)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(191),[G2H2(16)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(224),[G2H2(17)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(213),[G2H2(18)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(227),[G2H2(19)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(221),[G2H2(20)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(254),[G2H2(21)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(243),[G2H2(22)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(257),[G2H2(23)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(251),[G2H2(24)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(285),[G2H2(25)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(289),[G2H2(26)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(301),[G2H2(27)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(305),[G2H2(28)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(109),[G2H2(97)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(112),[G2H2(100)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(113),[G2H2(101)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(116),[G2H2(104)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(163),[G2H2(151)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(166),[G2H2(154)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(167),[G2H2(155)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(170),[G2H2(158)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(265),[G2H2(261)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(268),[G2H2(264)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(273),[G2H2(269)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(276),[G2H2(272)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(281),[G2H2(277)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(284),[G2H2(280)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(297),[G2H2(293)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(300),[G2H2(296)])
  call Hcheck_last_SV_V(ntryL,l_switch,G2H2(1),ex4(:),G2tensor(1),m3h2x1(:,1),heltab2x2(:,:,1))
  call Hotf_5pt_reduction(G2H2(2),RedSet_5(1),mass5set(:,1),  & 
G1H2(21),G1H2(22),G1H2(23),G1H2(24),G1H2(25),G1H2(26),2)
  call HG1shiftOLR(G1H2(22),8,2)
  call Hotf_5pt_reduction(G2H2(3),RedSet_5(1),mass5set(:,1),  & 
G1H2(27),G1H2(28),G1H2(29),G1H2(30),G1H2(31),G1H2(32),2)
  call HG1shiftOLR(G1H2(28),8,2)
  call Hcheck_last_VV_S(ntryL,l_switch,G2H2(4),ex4(:),G2tensor(2),m3h2x1(:,2),heltab2x2(:,:,2))
  call Hcheck_last_VV_S(ntryL,l_switch,G2H2(140),ex4(:),G2tensor(3),m3h2x1(:,3),heltab2x2(:,:,3))
  call Hotf_5pt_reduction(G2H2(129),RedSet_5(9),mass5set(:,11),  & 
G1H2(33),G1H2(34),G1H2(35),G1H2(36),G1H2(37),G1H2(38),2)
  call HG1shiftOLR(G1H2(34),8,2)
  call Hotf_5pt_reduction(G2H2(143),RedSet_5(9),mass5set(:,11),  & 
G1H2(39),G1H2(40),G1H2(41),G1H2(42),G1H2(43),G1H2(44),2)
  call HG1shiftOLR(G1H2(40),8,2)
  call Hcheck_last_SV_V(ntryL,l_switch,G2H2(137),ex4(:),G2tensor(4),m3h2x1(:,4),heltab2x2(:,:,4))
  call Hcheck_last_SV_V(ntryL,l_switch,G2H2(9),ex4(:),G2tensor(5),m3h2x1(:,5),heltab2x2(:,:,5))
  call Hotf_5pt_reduction(G2H2(10),RedSet_5(2),mass5set(:,1),  & 
G1H2(45),G1H2(46),G1H2(47),G1H2(48),G1H2(49),G1H2(50),2)
  call HG1shiftOLR(G1H2(46),8,2)
  call Hotf_5pt_reduction(G2H2(11),RedSet_5(2),mass5set(:,1),  & 
G1H2(51),G1H2(52),G1H2(53),G1H2(54),G1H2(55),G1H2(56),2)
  call HG1shiftOLR(G1H2(52),8,2)
  call Hcheck_last_VV_S(ntryL,l_switch,G2H2(12),ex4(:),G2tensor(6),m3h2x1(:,6),heltab2x2(:,:,6))
  call Hcheck_last_VV_S(ntryL,l_switch,G2H2(194),ex3(:),G2tensor(7),m3h2x1(:,7),heltab2x2(:,:,7))
  call Hotf_5pt_reduction(G2H2(183),RedSet_5(10),mass5set(:,11),  & 
G1H2(57),G1H2(58),G1H2(59),G1H2(60),G1H2(61),G1H2(62),2)
  call HG1shiftOLR(G1H2(58),4,2)
  call Hotf_5pt_reduction(G2H2(197),RedSet_5(10),mass5set(:,11),  & 
G1H2(63),G1H2(64),G1H2(65),G1H2(66),G1H2(67),G1H2(68),2)
  call HG1shiftOLR(G1H2(64),4,2)
  call Hcheck_last_SV_V(ntryL,l_switch,G2H2(191),ex3(:),G2tensor(8),m3h2x1(:,8),heltab2x2(:,:,8))
  call Hcheck_last_VV_S(ntryL,l_switch,G2H2(224),ex4(:),G2tensor(9),m3h2x1(:,9),heltab2x2(:,:,9))
  call Hotf_5pt_reduction(G2H2(213),RedSet_5(11),mass5set(:,11),  & 
G1H2(69),G1H2(70),G1H2(71),G1H2(72),G1H2(73),G1H2(74),2)
  call HG1shiftOLR(G1H2(70),8,2)
  call Hotf_5pt_reduction(G2H2(227),RedSet_5(11),mass5set(:,11),  & 
G1H2(75),G1H2(76),G1H2(77),G1H2(78),G1H2(79),G1H2(80),2)
  call HG1shiftOLR(G1H2(76),8,2)
  call Hcheck_last_SV_V(ntryL,l_switch,G2H2(221),ex4(:),G2tensor(10),m3h2x1(:,10),heltab2x2(:,:,10))
  call Hcheck_last_VV_S(ntryL,l_switch,G2H2(254),ex3(:),G2tensor(11),m3h2x1(:,11),heltab2x2(:,:,11))
  call Hotf_5pt_reduction(G2H2(243),RedSet_5(12),mass5set(:,11),  & 
G1H2(81),G1H2(82),G1H2(83),G1H2(84),G1H2(85),G1H2(86),2)
  call HG1shiftOLR(G1H2(82),4,2)
  call Hotf_5pt_reduction(G2H2(257),RedSet_5(12),mass5set(:,11),  & 
G1H2(87),G1H2(88),G1H2(89),G1H2(90),G1H2(91),G1H2(92),2)
  call HG1shiftOLR(G1H2(88),4,2)
  call Hcheck_last_SV_V(ntryL,l_switch,G2H2(251),ex3(:),G2tensor(12),m3h2x1(:,12),heltab2x2(:,:,12))
  call Hotf_5pt_reduction(G2H2(285),RedSet_5(6),mass5set(:,14),  & 
G1H2(93),G1H2(94),G1H2(95),G1H2(96),G1H2(97),G1H2(98),2)
  call HG1shiftOLR(G1H2(94),2,2)
  call Hotf_5pt_reduction(G2H2(289),RedSet_5(6),mass5set(:,14),  & 
G1H2(99),G1H2(100),G1H2(101),G1H2(102),G1H2(103),G1H2(104),2)
  call HG1shiftOLR(G1H2(100),2,2)
  call Hotf_5pt_reduction(G2H2(301),RedSet_5(8),mass5set(:,14),  & 
G1H2(105),G1H2(106),G1H2(107),G1H2(108),G1H2(109),G1H2(110),2)
  call HG1shiftOLR(G1H2(106),2,2)
  call Hotf_5pt_reduction(G2H2(305),RedSet_5(8),mass5set(:,14),  & 
G1H2(111),G1H2(112),G1H2(113),G1H2(114),G1H2(115),G1H2(116),2)
  call HG1shiftOLR(G1H2(112),2,2)
  call Hotf_4pt_reduction(G2H2(30),RedSet_4(4),mass4set(:,2),  & 
G1H2(117),G1H2(118),G1H2(119),G1H2(120),G1H2(121),2)
  call HG1shiftOLR(G1H2(118),10,2)
  call Hcheck_last_VV_S(ntryL,l_switch,G2H2(32),ex4(:),G2tensor(13),m3h2x1(:,13),heltab2x2(:,:,13))
  call Hcheck_last_SV_V(ntryL,l_switch,G2H2(34),ex4(:),G2tensor(14),m3h2x1(:,14),heltab2x2(:,:,14))
  call Hotf_4pt_reduction(G2H2(36),RedSet_4(4),mass4set(:,2),  & 
G1H2(122),G1H2(123),G1H2(124),G1H2(125),G1H2(126),2)
  call HG1shiftOLR(G1H2(123),10,2)
  call Hotf_4pt_reduction(G2H2(38),RedSet_4(5),mass4set(:,2),  & 
G1H2(127),G1H2(128),G1H2(129),G1H2(130),G1H2(131),2)
  call HG1shiftOLR(G1H2(128),9,2)
  call Hcheck_last_VV_S(ntryL,l_switch,G2H2(40),ex4(:),G2tensor(15),m3h2x1(:,15),heltab2x2(:,:,15))
  call Hcheck_last_SV_V(ntryL,l_switch,G2H2(42),ex4(:),G2tensor(16),m3h2x1(:,16),heltab2x2(:,:,16))
  call Hotf_4pt_reduction(G2H2(44),RedSet_4(5),mass4set(:,2),  & 
G1H2(132),G1H2(133),G1H2(134),G1H2(135),G1H2(136),2)
  call HG1shiftOLR(G1H2(133),9,2)
  call Hotf_5pt_reduction(G2H2(45),RedSet_5(3),mass5set(:,2),  & 
G1H2(137),G1H2(138),G1H2(139),G1H2(140),G1H2(141),G1H2(142),2)
  call HG1shiftOLR(G1H2(138),8,2)
  call Hotf_4pt_reduction(G2H2(47),RedSet_4(6),mass4set(:,1),  & 
G1H2(143),G1H2(144),G1H2(145),G1H2(146),G1H2(147),2)
  call HG1shiftOLR(G1H2(144),9,2)
  call Hcheck_last_SV_V(ntryL,l_switch,G2H2(48),ex4(:),G2tensor(17),m3h2x1(:,17),heltab2x2(:,:,17))
  call Hcheck_last_SV_V(ntryL,l_switch,G2H2(50),ex4(:),G2tensor(18),m3h2x1(:,18),heltab2x2(:,:,18))
  call Hcheck_last_VV_S(ntryL,l_switch,G2H2(51),ex4(:),G2tensor(19),m3h2x1(:,19),heltab2x2(:,:,19))
  call Hcheck_last_VV_S(ntryL,l_switch,G2H2(53),ex4(:),G2tensor(20),m3h2x1(:,20),heltab2x2(:,:,20))
  call Hotf_5pt_reduction(G2H2(54),RedSet_5(3),mass5set(:,2),  & 
G1H2(148),G1H2(149),G1H2(150),G1H2(151),G1H2(152),G1H2(153),2)
  call HG1shiftOLR(G1H2(149),8,2)
  call Hotf_4pt_reduction(G2H2(56),RedSet_4(6),mass4set(:,1),  & 
G1H2(154),G1H2(155),G1H2(156),G1H2(157),G1H2(158),2)
  call HG1shiftOLR(G1H2(155),9,2)
  call Hotf_5pt_reduction(G2H2(57),RedSet_5(4),mass5set(:,2),  & 
G1H2(159),G1H2(160),G1H2(161),G1H2(162),G1H2(163),G1H2(164),2)
  call HG1shiftOLR(G1H2(160),4,2)
  call Hotf_4pt_reduction(G2H2(59),RedSet_4(7),mass4set(:,1),  & 
G1H2(165),G1H2(166),G1H2(167),G1H2(168),G1H2(169),2)
  call HG1shiftOLR(G1H2(166),5,2)
  call Hcheck_last_SV_V(ntryL,l_switch,G2H2(60),ex3(:),G2tensor(21),m3h2x1(:,21),heltab2x2(:,:,21))
  call Hcheck_last_SV_V(ntryL,l_switch,G2H2(62),ex3(:),G2tensor(22),m3h2x1(:,22),heltab2x2(:,:,22))
  call Hcheck_last_VV_S(ntryL,l_switch,G2H2(63),ex3(:),G2tensor(23),m3h2x1(:,23),heltab2x2(:,:,23))
  call Hcheck_last_VV_S(ntryL,l_switch,G2H2(65),ex3(:),G2tensor(24),m3h2x1(:,24),heltab2x2(:,:,24))
  call Hotf_5pt_reduction(G2H2(66),RedSet_5(4),mass5set(:,2),  & 
G1H2(170),G1H2(171),G1H2(172),G1H2(173),G1H2(174),G1H2(175),2)
  call HG1shiftOLR(G1H2(171),4,2)
  call Hotf_4pt_reduction(G2H2(68),RedSet_4(7),mass4set(:,1),  & 
G1H2(176),G1H2(177),G1H2(178),G1H2(179),G1H2(180),2)
  call HG1shiftOLR(G1H2(177),5,2)
  call Hotf_5pt_reduction(G2H2(69),RedSet_5(5),mass5set(:,2),  & 
G1H2(181),G1H2(182),G1H2(183),G1H2(184),G1H2(185),G1H2(186),2)
  call HG1shiftOLR(G1H2(182),8,2)
  call Hotf_4pt_reduction(G2H2(71),RedSet_4(2),mass4set(:,1),  & 
G1H2(187),G1H2(188),G1H2(189),G1H2(190),G1H2(191),2)
  call HG1shiftOLR(G1H2(188),10,2)
  call Hcheck_last_SV_V(ntryL,l_switch,G2H2(72),ex4(:),G2tensor(25),m3h2x1(:,25),heltab2x2(:,:,25))
  call Hcheck_last_SV_V(ntryL,l_switch,G2H2(74),ex4(:),G2tensor(26),m3h2x1(:,26),heltab2x2(:,:,26))
  call Hcheck_last_VV_S(ntryL,l_switch,G2H2(75),ex4(:),G2tensor(27),m3h2x1(:,27),heltab2x2(:,:,27))
  call Hcheck_last_VV_S(ntryL,l_switch,G2H2(77),ex4(:),G2tensor(28),m3h2x1(:,28),heltab2x2(:,:,28))
  call Hotf_5pt_reduction(G2H2(78),RedSet_5(5),mass5set(:,2),  & 
G1H2(192),G1H2(193),G1H2(194),G1H2(195),G1H2(196),G1H2(197),2)
  call HG1shiftOLR(G1H2(193),8,2)
  call Hotf_4pt_reduction(G2H2(80),RedSet_4(2),mass4set(:,1),  & 
G1H2(198),G1H2(199),G1H2(200),G1H2(201),G1H2(202),2)
  call HG1shiftOLR(G1H2(199),10,2)
  call Hotf_5pt_reduction(G2H2(81),RedSet_5(7),mass5set(:,2),  & 
G1H2(203),G1H2(204),G1H2(205),G1H2(206),G1H2(207),G1H2(208),2)
  call HG1shiftOLR(G1H2(204),4,2)
  call Hotf_4pt_reduction(G2H2(83),RedSet_4(3),mass4set(:,1),  & 
G1H2(209),G1H2(210),G1H2(211),G1H2(212),G1H2(213),2)
  call HG1shiftOLR(G1H2(210),6,2)
  call Hcheck_last_SV_V(ntryL,l_switch,G2H2(84),ex3(:),G2tensor(29),m3h2x1(:,29),heltab2x2(:,:,29))
  call Hcheck_last_SV_V(ntryL,l_switch,G2H2(86),ex3(:),G2tensor(30),m3h2x1(:,30),heltab2x2(:,:,30))
  call Hcheck_last_VV_S(ntryL,l_switch,G2H2(87),ex3(:),G2tensor(31),m3h2x1(:,31),heltab2x2(:,:,31))
  call Hcheck_last_VV_S(ntryL,l_switch,G2H2(89),ex3(:),G2tensor(32),m3h2x1(:,32),heltab2x2(:,:,32))
  call Hotf_5pt_reduction(G2H2(90),RedSet_5(7),mass5set(:,2),  & 
G1H2(214),G1H2(215),G1H2(216),G1H2(217),G1H2(218),G1H2(219),2)
  call HG1shiftOLR(G1H2(215),4,2)
  call Hotf_4pt_reduction(G2H2(92),RedSet_4(3),mass4set(:,1),  & 
G1H2(220),G1H2(221),G1H2(222),G1H2(223),G1H2(224),2)
  call HG1shiftOLR(G1H2(221),6,2)
  call Hotf_5pt_reduction(G2H2(93),RedSet_5(1),mass5set(:,4),  & 
G1H2(225),G1H2(226),G1H2(227),G1H2(228),G1H2(229),G1H2(230),2)
  call HG1shiftOLR(G1H2(226),8,2)
  call Hotf_4pt_reduction(G2H2(96),RedSet_4(4),mass4set(:,3),  & 
G1H2(231),G1H2(232),G1H2(233),G1H2(234),G1H2(235),2)
  call HG1shiftOLR(G1H2(232),10,2)
  call Hotf_5pt_reduction(G2H2(109),RedSet_5(1),mass5set(:,5),  & 
G1H2(236),G1H2(237),G1H2(238),G1H2(239),G1H2(240),G1H2(241),2)
  call HG1shiftOLR(G1H2(237),8,2)
  call Hotf_4pt_reduction(G2H2(112),RedSet_4(4),mass4set(:,4),  & 
G1H2(242),G1H2(243),G1H2(244),G1H2(245),G1H2(246),2)
  call HG1shiftOLR(G1H2(243),10,2)
  call Hotf_5pt_reduction(G2H2(113),RedSet_5(1),mass5set(:,6),  & 
G1H2(247),G1H2(248),G1H2(249),G1H2(250),G1H2(251),G1H2(252),2)
  call HG1shiftOLR(G1H2(248),8,2)
  call Hotf_4pt_reduction(G2H2(116),RedSet_4(4),mass4set(:,5),  & 
G1H2(253),G1H2(254),G1H2(255),G1H2(256),G1H2(257),2)
  call HG1shiftOLR(G1H2(254),10,2)
  call Hotf_5pt_reduction(G2H2(105),RedSet_5(1),mass5set(:,7),  & 
G1H2(258),G1H2(259),G1H2(260),G1H2(261),G1H2(262),G1H2(263),2)
  call HG1shiftOLR(G1H2(259),8,2)
  call Hotf_4pt_reduction(G2H2(108),RedSet_4(4),mass4set(:,6),  & 
G1H2(264),G1H2(265),G1H2(266),G1H2(267),G1H2(268),2)
  call HG1shiftOLR(G1H2(265),10,2)
  call Hotf_5pt_reduction(G2H2(117),RedSet_5(9),mass5set(:,8),  & 
G1H2(269),G1H2(270),G1H2(271),G1H2(272),G1H2(273),G1H2(274),2)
  call HG1shiftOLR(G1H2(270),8,2)
  call Hotf_4pt_reduction(G2H2(120),RedSet_4(8),mass4set(:,7),  & 
G1H2(275),G1H2(276),G1H2(277),G1H2(278),G1H2(279),2)
  call HG1shiftOLR(G1H2(276),12,2)
  call Hotf_5pt_reduction(G2H2(121),RedSet_5(9),mass5set(:,9),  & 
G1H2(280),G1H2(281),G1H2(282),G1H2(283),G1H2(284),G1H2(285),2)
  call HG1shiftOLR(G1H2(281),8,2)
  call Hotf_4pt_reduction(G2H2(124),RedSet_4(8),mass4set(:,8),  & 
G1H2(286),G1H2(287),G1H2(288),G1H2(289),G1H2(290),2)
  call HG1shiftOLR(G1H2(287),12,2)
  call Hotf_5pt_reduction(G2H2(125),RedSet_5(9),mass5set(:,10),  & 
G1H2(291),G1H2(292),G1H2(293),G1H2(294),G1H2(295),G1H2(296),2)
  call HG1shiftOLR(G1H2(292),8,2)
  call Hotf_4pt_reduction(G2H2(128),RedSet_4(8),mass4set(:,9),  & 
G1H2(297),G1H2(298),G1H2(299),G1H2(300),G1H2(301),2)
  call HG1shiftOLR(G1H2(298),12,2)
  call Hotf_4pt_reduction(G2H2(132),RedSet_4(8),mass4set(:,10),  & 
G1H2(302),G1H2(303),G1H2(304),G1H2(305),G1H2(306),2)
  call HG1shiftOLR(G1H2(303),12,2)
  call Hotf_5pt_reduction(G2H2(133),RedSet_5(9),mass5set(:,12),  & 
G1H2(307),G1H2(308),G1H2(309),G1H2(310),G1H2(311),G1H2(312),2)
  call HG1shiftOLR(G1H2(308),8,2)
  call Hotf_4pt_reduction(G2H2(136),RedSet_4(8),mass4set(:,11),  & 
G1H2(313),G1H2(314),G1H2(315),G1H2(316),G1H2(317),2)
  call HG1shiftOLR(G1H2(314),12,2)
  call Hcheck_last_SV_V(ntryL,l_switch,G2H2(139),ex4(:),G2tensor(33),m3h2x1(:,33),heltab2x2(:,:,33))
  call Hcheck_last_VV_S(ntryL,l_switch,G2H2(142),ex4(:),G2tensor(34),m3h2x1(:,34),heltab2x2(:,:,34))
  call Hotf_4pt_reduction(G2H2(146),RedSet_4(8),mass4set(:,10),  & 
G1H2(318),G1H2(319),G1H2(320),G1H2(321),G1H2(322),2)
  call HG1shiftOLR(G1H2(319),12,2)
  call Hotf_5pt_reduction(G2H2(147),RedSet_5(2),mass5set(:,4),  & 
G1H2(323),G1H2(324),G1H2(325),G1H2(326),G1H2(327),G1H2(328),2)
  call HG1shiftOLR(G1H2(324),8,2)
  call Hotf_4pt_reduction(G2H2(150),RedSet_4(5),mass4set(:,3),  & 
G1H2(329),G1H2(330),G1H2(331),G1H2(332),G1H2(333),2)
  call HG1shiftOLR(G1H2(330),9,2)
  call Hotf_5pt_reduction(G2H2(163),RedSet_5(2),mass5set(:,5),  & 
G1H2(334),G1H2(335),G1H2(336),G1H2(337),G1H2(338),G1H2(339),2)
  call HG1shiftOLR(G1H2(335),8,2)
  call Hotf_4pt_reduction(G2H2(166),RedSet_4(5),mass4set(:,4),  & 
G1H2(340),G1H2(341),G1H2(342),G1H2(343),G1H2(344),2)
  call HG1shiftOLR(G1H2(341),9,2)
  call Hotf_5pt_reduction(G2H2(167),RedSet_5(2),mass5set(:,6),  & 
G1H2(345),G1H2(346),G1H2(347),G1H2(348),G1H2(349),G1H2(350),2)
  call HG1shiftOLR(G1H2(346),8,2)
  call Hotf_4pt_reduction(G2H2(170),RedSet_4(5),mass4set(:,5),  & 
G1H2(351),G1H2(352),G1H2(353),G1H2(354),G1H2(355),2)
  call HG1shiftOLR(G1H2(352),9,2)
  call Hotf_5pt_reduction(G2H2(159),RedSet_5(2),mass5set(:,7),  & 
G1H2(356),G1H2(357),G1H2(358),G1H2(359),G1H2(360),G1H2(361),2)
  call HG1shiftOLR(G1H2(357),8,2)
  call Hotf_4pt_reduction(G2H2(162),RedSet_4(5),mass4set(:,6),  & 
G1H2(362),G1H2(363),G1H2(364),G1H2(365),G1H2(366),2)
  call HG1shiftOLR(G1H2(363),9,2)
  call Hotf_5pt_reduction(G2H2(171),RedSet_5(10),mass5set(:,8),  & 
G1H2(367),G1H2(368),G1H2(369),G1H2(370),G1H2(371),G1H2(372),2)
  call HG1shiftOLR(G1H2(368),4,2)
  call Hotf_4pt_reduction(G2H2(174),RedSet_4(8),mass4set(:,7),  & 
G1H2(373),G1H2(374),G1H2(375),G1H2(376),G1H2(377),2)
  call HG1shiftOLR(G1H2(374),12,2)
  call Hotf_5pt_reduction(G2H2(175),RedSet_5(10),mass5set(:,9),  & 
G1H2(378),G1H2(379),G1H2(380),G1H2(381),G1H2(382),G1H2(383),2)
  call HG1shiftOLR(G1H2(379),4,2)
  call Hotf_4pt_reduction(G2H2(178),RedSet_4(8),mass4set(:,8),  & 
G1H2(384),G1H2(385),G1H2(386),G1H2(387),G1H2(388),2)
  call HG1shiftOLR(G1H2(385),12,2)
  call Hotf_5pt_reduction(G2H2(179),RedSet_5(10),mass5set(:,10),  & 
G1H2(389),G1H2(390),G1H2(391),G1H2(392),G1H2(393),G1H2(394),2)
  call HG1shiftOLR(G1H2(390),4,2)
  call Hotf_4pt_reduction(G2H2(182),RedSet_4(8),mass4set(:,9),  & 
G1H2(395),G1H2(396),G1H2(397),G1H2(398),G1H2(399),2)
  call HG1shiftOLR(G1H2(396),12,2)
  call Hotf_4pt_reduction(G2H2(186),RedSet_4(8),mass4set(:,10),  & 
G1H2(400),G1H2(401),G1H2(402),G1H2(403),G1H2(404),2)
  call HG1shiftOLR(G1H2(401),12,2)
  call Hotf_5pt_reduction(G2H2(187),RedSet_5(10),mass5set(:,12),  & 
G1H2(405),G1H2(406),G1H2(407),G1H2(408),G1H2(409),G1H2(410),2)
  call HG1shiftOLR(G1H2(406),4,2)
  call Hotf_4pt_reduction(G2H2(190),RedSet_4(8),mass4set(:,11),  & 
G1H2(411),G1H2(412),G1H2(413),G1H2(414),G1H2(415),2)
  call HG1shiftOLR(G1H2(412),12,2)
  call Hcheck_last_SV_V(ntryL,l_switch,G2H2(193),ex3(:),G2tensor(35),m3h2x1(:,35),heltab2x2(:,:,35))
  call Hcheck_last_VV_S(ntryL,l_switch,G2H2(196),ex3(:),G2tensor(36),m3h2x1(:,36),heltab2x2(:,:,36))
  call Hotf_4pt_reduction(G2H2(200),RedSet_4(8),mass4set(:,10),  & 
G1H2(416),G1H2(417),G1H2(418),G1H2(419),G1H2(420),2)
  call HG1shiftOLR(G1H2(417),12,2)
  call Hotf_5pt_reduction(G2H2(201),RedSet_5(11),mass5set(:,8),  & 
G1H2(421),G1H2(422),G1H2(423),G1H2(424),G1H2(425),G1H2(426),2)
  call HG1shiftOLR(G1H2(422),8,2)
  call Hotf_4pt_reduction(G2H2(204),RedSet_4(9),mass4set(:,7),  & 
G1H2(427),G1H2(428),G1H2(429),G1H2(430),G1H2(431),2)
  call HG1shiftOLR(G1H2(428),12,2)
  call Hotf_5pt_reduction(G2H2(205),RedSet_5(11),mass5set(:,9),  & 
G1H2(432),G1H2(433),G1H2(434),G1H2(435),G1H2(436),G1H2(437),2)
  call HG1shiftOLR(G1H2(433),8,2)
  call Hotf_4pt_reduction(G2H2(208),RedSet_4(9),mass4set(:,8),  & 
G1H2(438),G1H2(439),G1H2(440),G1H2(441),G1H2(442),2)
  call HG1shiftOLR(G1H2(439),12,2)
  call Hotf_5pt_reduction(G2H2(209),RedSet_5(11),mass5set(:,10),  & 
G1H2(443),G1H2(444),G1H2(445),G1H2(446),G1H2(447),G1H2(448),2)
  call HG1shiftOLR(G1H2(444),8,2)
  call Hotf_4pt_reduction(G2H2(212),RedSet_4(9),mass4set(:,9),  & 
G1H2(449),G1H2(450),G1H2(451),G1H2(452),G1H2(453),2)
  call HG1shiftOLR(G1H2(450),12,2)
  call Hotf_4pt_reduction(G2H2(216),RedSet_4(9),mass4set(:,10),  & 
G1H2(454),G1H2(455),G1H2(456),G1H2(457),G1H2(458),2)
  call HG1shiftOLR(G1H2(455),12,2)
  call Hotf_5pt_reduction(G2H2(217),RedSet_5(11),mass5set(:,12),  & 
G1H2(459),G1H2(460),G1H2(461),G1H2(462),G1H2(463),G1H2(464),2)
  call HG1shiftOLR(G1H2(460),8,2)
  call Hotf_4pt_reduction(G2H2(220),RedSet_4(9),mass4set(:,11),  & 
G1H2(465),G1H2(466),G1H2(467),G1H2(468),G1H2(469),2)
  call HG1shiftOLR(G1H2(466),12,2)
  call Hcheck_last_SV_V(ntryL,l_switch,G2H2(223),ex4(:),G2tensor(37),m3h2x1(:,37),heltab2x2(:,:,37))
  call Hcheck_last_VV_S(ntryL,l_switch,G2H2(226),ex4(:),G2tensor(38),m3h2x1(:,38),heltab2x2(:,:,38))
  call Hotf_4pt_reduction(G2H2(230),RedSet_4(9),mass4set(:,10),  & 
G1H2(470),G1H2(471),G1H2(472),G1H2(473),G1H2(474),2)
  call HG1shiftOLR(G1H2(471),12,2)
  call Hotf_5pt_reduction(G2H2(231),RedSet_5(12),mass5set(:,8),  & 
G1H2(475),G1H2(476),G1H2(477),G1H2(478),G1H2(479),G1H2(480),2)
  call HG1shiftOLR(G1H2(476),4,2)
  call Hotf_4pt_reduction(G2H2(234),RedSet_4(9),mass4set(:,7),  & 
G1H2(481),G1H2(482),G1H2(483),G1H2(484),G1H2(485),2)
  call HG1shiftOLR(G1H2(482),12,2)
  call Hotf_5pt_reduction(G2H2(235),RedSet_5(12),mass5set(:,9),  & 
G1H2(486),G1H2(487),G1H2(488),G1H2(489),G1H2(490),G1H2(491),2)
  call HG1shiftOLR(G1H2(487),4,2)
  call Hotf_4pt_reduction(G2H2(238),RedSet_4(9),mass4set(:,8),  & 
G1H2(492),G1H2(493),G1H2(494),G1H2(495),G1H2(496),2)
  call HG1shiftOLR(G1H2(493),12,2)
  call Hotf_5pt_reduction(G2H2(239),RedSet_5(12),mass5set(:,10),  & 
G1H2(497),G1H2(498),G1H2(499),G1H2(500),G1H2(501),G1H2(502),2)
  call HG1shiftOLR(G1H2(498),4,2)
  call Hotf_4pt_reduction(G2H2(242),RedSet_4(9),mass4set(:,9),  & 
G1H2(503),G1H2(504),G1H2(505),G1H2(506),G1H2(507),2)
  call HG1shiftOLR(G1H2(504),12,2)
  call Hotf_4pt_reduction(G2H2(246),RedSet_4(9),mass4set(:,10),  & 
G1H2(508),G1H2(509),G1H2(510),G1H2(511),G1H2(512),2)
  call HG1shiftOLR(G1H2(509),12,2)
  call Hotf_5pt_reduction(G2H2(247),RedSet_5(12),mass5set(:,12),  & 
G1H2(513),G1H2(514),G1H2(515),G1H2(516),G1H2(517),G1H2(518),2)
  call HG1shiftOLR(G1H2(514),4,2)
  call Hotf_4pt_reduction(G2H2(250),RedSet_4(9),mass4set(:,11),  & 
G1H2(519),G1H2(520),G1H2(521),G1H2(522),G1H2(523),2)
  call HG1shiftOLR(G1H2(520),12,2)
  call Hcheck_last_SV_V(ntryL,l_switch,G2H2(253),ex3(:),G2tensor(39),m3h2x1(:,39),heltab2x2(:,:,39))
  call Hcheck_last_VV_S(ntryL,l_switch,G2H2(256),ex3(:),G2tensor(40),m3h2x1(:,40),heltab2x2(:,:,40))
  call Hotf_4pt_reduction(G2H2(260),RedSet_4(9),mass4set(:,10),  & 
G1H2(524),G1H2(525),G1H2(526),G1H2(527),G1H2(528),2)
  call HG1shiftOLR(G1H2(525),12,2)
  call Hotf_5pt_reduction(G2H2(265),RedSet_5(3),mass5set(:,13),  & 
G1H2(529),G1H2(530),G1H2(531),G1H2(532),G1H2(533),G1H2(534),2)
  call HG1shiftOLR(G1H2(530),8,2)
  call Hotf_4pt_reduction(G2H2(268),RedSet_4(6),mass4set(:,12),  & 
G1H2(535),G1H2(536),G1H2(537),G1H2(538),G1H2(539),2)
  call HG1shiftOLR(G1H2(536),9,2)
  call Hotf_5pt_reduction(G2H2(273),RedSet_5(4),mass5set(:,13),  & 
G1H2(540),G1H2(541),G1H2(542),G1H2(543),G1H2(544),G1H2(545),2)
  call HG1shiftOLR(G1H2(541),4,2)
  call Hotf_4pt_reduction(G2H2(276),RedSet_4(7),mass4set(:,12),  & 
G1H2(546),G1H2(547),G1H2(548),G1H2(549),G1H2(550),2)
  call HG1shiftOLR(G1H2(547),5,2)
  call Hotf_5pt_reduction(G2H2(281),RedSet_5(5),mass5set(:,13),  & 
G1H2(551),G1H2(552),G1H2(553),G1H2(554),G1H2(555),G1H2(556),2)
  call HG1shiftOLR(G1H2(552),8,2)
  call Hotf_4pt_reduction(G2H2(284),RedSet_4(2),mass4set(:,12),  & 
G1H2(557),G1H2(558),G1H2(559),G1H2(560),G1H2(561),2)
  call HG1shiftOLR(G1H2(558),10,2)
  call Hotf_4pt_reduction(G2H2(288),RedSet_4(2),mass4set(:,12),  & 
G1H2(562),G1H2(563),G1H2(564),G1H2(565),G1H2(566),2)
  call HG1shiftOLR(G1H2(563),10,2)
  call Hotf_4pt_reduction(G2H2(292),RedSet_4(2),mass4set(:,12),  & 
G1H2(567),G1H2(568),G1H2(569),G1H2(570),G1H2(571),2)
  call HG1shiftOLR(G1H2(568),10,2)
  call Hotf_5pt_reduction(G2H2(297),RedSet_5(7),mass5set(:,13),  & 
G1H2(572),G1H2(573),G1H2(574),G1H2(575),G1H2(576),G1H2(577),2)
  call HG1shiftOLR(G1H2(573),4,2)
  call Hotf_4pt_reduction(G2H2(300),RedSet_4(3),mass4set(:,12),  & 
G1H2(578),G1H2(579),G1H2(580),G1H2(581),G1H2(582),2)
  call HG1shiftOLR(G1H2(579),6,2)
  call Hotf_4pt_reduction(G2H2(304),RedSet_4(3),mass4set(:,12),  & 
G1H2(583),G1H2(584),G1H2(585),G1H2(586),G1H2(587),2)
  call HG1shiftOLR(G1H2(584),6,2)
  call Hotf_4pt_reduction(G2H2(308),RedSet_4(3),mass4set(:,12),  & 
G1H2(588),G1H2(589),G1H2(590),G1H2(591),G1H2(592),2)
  call HG1shiftOLR(G1H2(589),6,2)
  call Hcheck_last_QA_S(ntryL,l_switch,G2H2(309),ex2(:),G2tensor(41),ngPtb,m3h2x1(:,41),heltab2x2(:,:,41))
  call Hcheck_last_QA_S(ntryL,l_switch,G2H2(311),ex2(:),G2tensor(42),ngPtb,m3h2x1(:,42),heltab2x2(:,:,42))
  call Hcheck_last_QA_W(ntryL,l_switch,G2H2(314),ex2(:),G2tensor(43),m3h2x1(:,43),heltab2x2(:,:,43))
  call Hcheck_last_QA_W(ntryL,l_switch,G2H2(316),ex2(:),G2tensor(44),m3h2x1(:,44),heltab2x2(:,:,44))
  call Hcheck_last_QA_S(ntryL,l_switch,G2H2(319),ex2(:),G2tensor(45),ngPtb,m3h2x1(:,45),heltab2x2(:,:,45))
  call Hcheck_last_QA_S(ntryL,l_switch,G2H2(321),ex2(:),G2tensor(46),ngPtb,m3h2x1(:,46),heltab2x2(:,:,46))
  call Hcheck_last_QA_W(ntryL,l_switch,G2H2(324),ex2(:),G2tensor(47),m3h2x1(:,47),heltab2x2(:,:,47))
  call Hcheck_last_QA_W(ntryL,l_switch,G2H2(326),ex2(:),G2tensor(48),m3h2x1(:,48),heltab2x2(:,:,48))
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(117),[G1H2(26)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(122),[G1H2(32)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(302),[G1H2(38)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(318),[G1H2(44)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(127),[G1H2(50)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(132),[G1H2(56)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(400),[G1H2(62)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(416),[G1H2(68)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(454),[G1H2(74)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(470),[G1H2(80)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(508),[G1H2(86)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(524),[G1H2(92)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(562),[G1H2(98)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(567),[G1H2(104)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(583),[G1H2(110)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(588),[G1H2(116)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(143),[G1H2(142)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(154),[G1H2(153)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(165),[G1H2(164)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(176),[G1H2(175)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(187),[G1H2(186)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(198),[G1H2(197)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(209),[G1H2(208)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(220),[G1H2(219)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(231),[G1H2(230)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(242),[G1H2(241)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(253),[G1H2(252)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(264),[G1H2(263)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(275),[G1H2(274)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(286),[G1H2(285)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(297),[G1H2(296)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(313),[G1H2(312)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(329),[G1H2(328)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(340),[G1H2(339)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(351),[G1H2(350)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(362),[G1H2(361)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(373),[G1H2(372)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(384),[G1H2(383)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(395),[G1H2(394)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(411),[G1H2(410)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(427),[G1H2(426)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(438),[G1H2(437)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(449),[G1H2(448)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(465),[G1H2(464)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(481),[G1H2(480)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(492),[G1H2(491)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(503),[G1H2(502)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(519),[G1H2(518)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(535),[G1H2(534)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(546),[G1H2(545)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(557),[G1H2(556)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(578),[G1H2(577)])
  call Hcheck_last_TV_S(ntryL,l_switch,G1H2(21),23,ex4(:),8,G2tensor(49),m3h2x1(:,49),heltab2x2(:,:,49))
  call Hcheck_last_TV_S(ntryL,l_switch,G1H2(22),0,ex4(:),8,G2tensor(50),m3h2x1(:,50),heltab2x2(:,:,50))
  call Hcheck_last_TV_S(ntryL,l_switch,G1H2(117),23,ex4(:),8,G2tensor(51),m3h2x1(:,51),heltab2x2(:,:,51))
  call Hcheck_last_UV_W(ntryL,l_switch,G1H2(27),23,ex4(:),8,G2tensor(52),m3h2x1(:,52),heltab2x2(:,:,52))
  call Hcheck_last_UV_W(ntryL,l_switch,G1H2(28),0,ex4(:),8,G2tensor(53),m3h2x1(:,53),heltab2x2(:,:,53))
  call Hcheck_last_UV_W(ntryL,l_switch,G1H2(122),23,ex4(:),8,G2tensor(54),m3h2x1(:,54),heltab2x2(:,:,54))
  call Hcheck_last_SV_T(ntryL,l_switch,G1H2(33),23,ex4(:),8,G2tensor(55),m3h2x1(:,55),heltab2x2(:,:,55))
  call Hcheck_last_SV_T(ntryL,l_switch,G1H2(34),0,ex4(:),8,G2tensor(56),m3h2x1(:,56),heltab2x2(:,:,56))
  call Hcheck_last_SV_T(ntryL,l_switch,G1H2(302),23,ex4(:),8,G2tensor(57),m3h2x1(:,57),heltab2x2(:,:,57))
  call Hcheck_last_UW_V(ntryL,l_switch,G1H2(39),23,ex4(:),8,G2tensor(58),m3h2x1(:,58),heltab2x2(:,:,58))
  call Hcheck_last_UW_V(ntryL,l_switch,G1H2(40),0,ex4(:),8,G2tensor(59),m3h2x1(:,59),heltab2x2(:,:,59))
  call Hcheck_last_UW_V(ntryL,l_switch,G1H2(318),23,ex4(:),8,G2tensor(60),m3h2x1(:,60),heltab2x2(:,:,60))
  call Hcheck_last_SV_T(ntryL,l_switch,G1H2(45),23,ex4(:),8,G2tensor(61),m3h2x1(:,61),heltab2x2(:,:,61))
  call Hcheck_last_SV_T(ntryL,l_switch,G1H2(46),0,ex4(:),8,G2tensor(62),m3h2x1(:,62),heltab2x2(:,:,62))
  call Hcheck_last_SV_T(ntryL,l_switch,G1H2(127),23,ex4(:),8,G2tensor(63),m3h2x1(:,63),heltab2x2(:,:,63))
  call Hcheck_last_UW_V(ntryL,l_switch,G1H2(51),23,ex4(:),8,G2tensor(64),m3h2x1(:,64),heltab2x2(:,:,64))
  call Hcheck_last_UW_V(ntryL,l_switch,G1H2(52),0,ex4(:),8,G2tensor(65),m3h2x1(:,65),heltab2x2(:,:,65))
  call Hcheck_last_UW_V(ntryL,l_switch,G1H2(132),23,ex4(:),8,G2tensor(66),m3h2x1(:,66),heltab2x2(:,:,66))
  call Hcheck_last_SV_T(ntryL,l_switch,G1H2(57),27,ex3(:),4,G2tensor(67),m3h2x1(:,67),heltab2x2(:,:,67))
  call Hcheck_last_SV_T(ntryL,l_switch,G1H2(58),0,ex3(:),4,G2tensor(68),m3h2x1(:,68),heltab2x2(:,:,68))
  call Hcheck_last_SV_T(ntryL,l_switch,G1H2(400),27,ex3(:),4,G2tensor(69),m3h2x1(:,69),heltab2x2(:,:,69))
  call Hcheck_last_UW_V(ntryL,l_switch,G1H2(63),27,ex3(:),4,G2tensor(70),m3h2x1(:,70),heltab2x2(:,:,70))
  call Hcheck_last_UW_V(ntryL,l_switch,G1H2(64),0,ex3(:),4,G2tensor(71),m3h2x1(:,71),heltab2x2(:,:,71))
  call Hcheck_last_UW_V(ntryL,l_switch,G1H2(416),27,ex3(:),4,G2tensor(72),m3h2x1(:,72),heltab2x2(:,:,72))
  call Hcheck_last_TV_S(ntryL,l_switch,G1H2(69),23,ex4(:),8,G2tensor(73),m3h2x1(:,73),heltab2x2(:,:,73))
  call Hcheck_last_TV_S(ntryL,l_switch,G1H2(70),0,ex4(:),8,G2tensor(74),m3h2x1(:,74),heltab2x2(:,:,74))
  call Hcheck_last_TV_S(ntryL,l_switch,G1H2(454),23,ex4(:),8,G2tensor(75),m3h2x1(:,75),heltab2x2(:,:,75))
  call Hcheck_last_UV_W(ntryL,l_switch,G1H2(75),23,ex4(:),8,G2tensor(76),m3h2x1(:,76),heltab2x2(:,:,76))
  call Hcheck_last_UV_W(ntryL,l_switch,G1H2(76),0,ex4(:),8,G2tensor(77),m3h2x1(:,77),heltab2x2(:,:,77))
  call Hcheck_last_UV_W(ntryL,l_switch,G1H2(470),23,ex4(:),8,G2tensor(78),m3h2x1(:,78),heltab2x2(:,:,78))
  call Hcheck_last_TV_S(ntryL,l_switch,G1H2(81),27,ex3(:),4,G2tensor(79),m3h2x1(:,79),heltab2x2(:,:,79))
  call Hcheck_last_TV_S(ntryL,l_switch,G1H2(82),0,ex3(:),4,G2tensor(80),m3h2x1(:,80),heltab2x2(:,:,80))
  call Hcheck_last_TV_S(ntryL,l_switch,G1H2(508),27,ex3(:),4,G2tensor(81),m3h2x1(:,81),heltab2x2(:,:,81))
  call Hcheck_last_UV_W(ntryL,l_switch,G1H2(87),27,ex3(:),4,G2tensor(82),m3h2x1(:,82),heltab2x2(:,:,82))
  call Hcheck_last_UV_W(ntryL,l_switch,G1H2(88),0,ex3(:),4,G2tensor(83),m3h2x1(:,83),heltab2x2(:,:,83))
  call Hcheck_last_UV_W(ntryL,l_switch,G1H2(524),27,ex3(:),4,G2tensor(84),m3h2x1(:,84),heltab2x2(:,:,84))
  call Hloop_SA_Q(ntryL,G1H2(93),ex2(:),G1H1(1),ngPtb,m3h2x1(:,85),heltab2x2(:,:,85))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,nMB,G2tensor(85),n2h1(13))
  call Hloop_SA_Q(ntryL,G1H2(94),ex2(:),G1H1(1),ngPtb,m3h2x1(:,86),heltab2x2(:,:,86))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),2,nMB,G2tensor(86),n2h1(14))
  call Hloop_SA_Q(ntryL,G1H2(562),ex2(:),G1H1(1),ngPtb,m3h2x1(:,87),heltab2x2(:,:,87))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,nMB,G2tensor(87),n2h1(15))
  call Hloop_WA_Q(ntryL,G1H2(99),ex2(:),G1H1(1),m3h2x1(:,88),heltab2x2(:,:,88))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,nMB,G2tensor(88),n2h1(16))
  call Hloop_WA_Q(ntryL,G1H2(100),ex2(:),G1H1(1),m3h2x1(:,89),heltab2x2(:,:,89))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),2,nMB,G2tensor(89),n2h1(17))
  call Hloop_WA_Q(ntryL,G1H2(567),ex2(:),G1H1(1),m3h2x1(:,90),heltab2x2(:,:,90))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,nMB,G2tensor(90),n2h1(18))
  call Hloop_SA_Q(ntryL,G1H2(105),ex2(:),G1H1(1),ngPtb,m3h2x1(:,91),heltab2x2(:,:,91))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,nMB,G2tensor(91),n2h1(19))
  call Hloop_SA_Q(ntryL,G1H2(106),ex2(:),G1H1(1),ngPtb,m3h2x1(:,92),heltab2x2(:,:,92))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),2,nMB,G2tensor(92),n2h1(20))
  call Hloop_SA_Q(ntryL,G1H2(583),ex2(:),G1H1(1),ngPtb,m3h2x1(:,93),heltab2x2(:,:,93))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,nMB,G2tensor(93),n2h1(21))
  call Hloop_WA_Q(ntryL,G1H2(111),ex2(:),G1H1(1),m3h2x1(:,94),heltab2x2(:,:,94))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,nMB,G2tensor(94),n2h1(22))
  call Hloop_WA_Q(ntryL,G1H2(112),ex2(:),G1H1(1),m3h2x1(:,95),heltab2x2(:,:,95))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),2,nMB,G2tensor(95),n2h1(23))
  call Hloop_WA_Q(ntryL,G1H2(588),ex2(:),G1H1(1),m3h2x1(:,96),heltab2x2(:,:,96))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,nMB,G2tensor(96),n2h1(24))
  call Hcheck_last_TV_S(ntryL,l_switch,G1H2(118),2,ex4(:),8,G2tensor(97),m3h2x1(:,97),heltab2x2(:,:,97))
  call Hcheck_last_UV_W(ntryL,l_switch,G1H2(123),2,ex4(:),8,G2tensor(98),m3h2x1(:,98),heltab2x2(:,:,98))
  call Hcheck_last_SV_T(ntryL,l_switch,G1H2(128),1,ex4(:),8,G2tensor(99),m3h2x1(:,99),heltab2x2(:,:,99))
  call Hcheck_last_UW_V(ntryL,l_switch,G1H2(133),1,ex4(:),8,G2tensor(100),m3h2x1(:,100),heltab2x2(:,:,100))
  call Hcheck_last_SV_T(ntryL,l_switch,G1H2(137),23,ex4(:),8,G2tensor(101),m3h2x1(:,101),heltab2x2(:,:,101))
  call Hcheck_last_SV_T(ntryL,l_switch,G1H2(138),0,ex4(:),8,G2tensor(102),m3h2x1(:,102),heltab2x2(:,:,102))
  call Hcheck_last_SV_T(ntryL,l_switch,G1H2(143),23,ex4(:),8,G2tensor(103),m3h2x1(:,103),heltab2x2(:,:,103))
  call Hcheck_last_SV_T(ntryL,l_switch,G1H2(144),1,ex4(:),8,G2tensor(104),m3h2x1(:,104),heltab2x2(:,:,104))
  call Hcheck_last_UW_V(ntryL,l_switch,G1H2(148),23,ex4(:),8,G2tensor(105),m3h2x1(:,105),heltab2x2(:,:,105))
  call Hcheck_last_UW_V(ntryL,l_switch,G1H2(149),0,ex4(:),8,G2tensor(106),m3h2x1(:,106),heltab2x2(:,:,106))
  call Hcheck_last_UW_V(ntryL,l_switch,G1H2(154),23,ex4(:),8,G2tensor(107),m3h2x1(:,107),heltab2x2(:,:,107))
  call Hcheck_last_UW_V(ntryL,l_switch,G1H2(155),1,ex4(:),8,G2tensor(108),m3h2x1(:,108),heltab2x2(:,:,108))
  call Hcheck_last_SV_T(ntryL,l_switch,G1H2(159),27,ex3(:),4,G2tensor(109),m3h2x1(:,109),heltab2x2(:,:,109))
  call Hcheck_last_SV_T(ntryL,l_switch,G1H2(160),0,ex3(:),4,G2tensor(110),m3h2x1(:,110),heltab2x2(:,:,110))
  call Hcheck_last_SV_T(ntryL,l_switch,G1H2(165),27,ex3(:),4,G2tensor(111),m3h2x1(:,111),heltab2x2(:,:,111))
  call Hcheck_last_SV_T(ntryL,l_switch,G1H2(166),1,ex3(:),4,G2tensor(112),m3h2x1(:,112),heltab2x2(:,:,112))
  call Hcheck_last_UW_V(ntryL,l_switch,G1H2(170),27,ex3(:),4,G2tensor(113),m3h2x1(:,113),heltab2x2(:,:,113))
  call Hcheck_last_UW_V(ntryL,l_switch,G1H2(171),0,ex3(:),4,G2tensor(114),m3h2x1(:,114),heltab2x2(:,:,114))
  call Hcheck_last_UW_V(ntryL,l_switch,G1H2(176),27,ex3(:),4,G2tensor(115),m3h2x1(:,115),heltab2x2(:,:,115))
  call Hcheck_last_UW_V(ntryL,l_switch,G1H2(177),1,ex3(:),4,G2tensor(116),m3h2x1(:,116),heltab2x2(:,:,116))
  call Hcheck_last_TV_S(ntryL,l_switch,G1H2(181),23,ex4(:),8,G2tensor(117),m3h2x1(:,117),heltab2x2(:,:,117))
  call Hcheck_last_TV_S(ntryL,l_switch,G1H2(182),0,ex4(:),8,G2tensor(118),m3h2x1(:,118),heltab2x2(:,:,118))
  call Hcheck_last_TV_S(ntryL,l_switch,G1H2(187),23,ex4(:),8,G2tensor(119),m3h2x1(:,119),heltab2x2(:,:,119))
  call Hcheck_last_TV_S(ntryL,l_switch,G1H2(188),2,ex4(:),8,G2tensor(120),m3h2x1(:,120),heltab2x2(:,:,120))
  call Hcheck_last_UV_W(ntryL,l_switch,G1H2(192),23,ex4(:),8,G2tensor(121),m3h2x1(:,121),heltab2x2(:,:,121))
  call Hcheck_last_UV_W(ntryL,l_switch,G1H2(193),0,ex4(:),8,G2tensor(122),m3h2x1(:,122),heltab2x2(:,:,122))
  call Hcheck_last_UV_W(ntryL,l_switch,G1H2(198),23,ex4(:),8,G2tensor(123),m3h2x1(:,123),heltab2x2(:,:,123))
  call Hcheck_last_UV_W(ntryL,l_switch,G1H2(199),2,ex4(:),8,G2tensor(124),m3h2x1(:,124),heltab2x2(:,:,124))
  call Hcheck_last_TV_S(ntryL,l_switch,G1H2(203),27,ex3(:),4,G2tensor(125),m3h2x1(:,125),heltab2x2(:,:,125))
  call Hcheck_last_TV_S(ntryL,l_switch,G1H2(204),0,ex3(:),4,G2tensor(126),m3h2x1(:,126),heltab2x2(:,:,126))
  call Hcheck_last_TV_S(ntryL,l_switch,G1H2(209),27,ex3(:),4,G2tensor(127),m3h2x1(:,127),heltab2x2(:,:,127))
  call Hcheck_last_TV_S(ntryL,l_switch,G1H2(210),2,ex3(:),4,G2tensor(128),m3h2x1(:,128),heltab2x2(:,:,128))
  call Hcheck_last_UV_W(ntryL,l_switch,G1H2(214),27,ex3(:),4,G2tensor(129),m3h2x1(:,129),heltab2x2(:,:,129))
  call Hcheck_last_UV_W(ntryL,l_switch,G1H2(215),0,ex3(:),4,G2tensor(130),m3h2x1(:,130),heltab2x2(:,:,130))
  call Hcheck_last_UV_W(ntryL,l_switch,G1H2(220),27,ex3(:),4,G2tensor(131),m3h2x1(:,131),heltab2x2(:,:,131))
  call Hcheck_last_UV_W(ntryL,l_switch,G1H2(221),2,ex3(:),4,G2tensor(132),m3h2x1(:,132),heltab2x2(:,:,132))
  call Hloop_AV_Q(ntryL,G1H2(225),ex4(:),G1H1(1),m3h2x1(:,133),heltab2x2(:,:,133))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,nMT,G2tensor(133),n2h1(45))
  call Hloop_AV_Q(ntryL,G1H2(226),ex4(:),G1H1(1),m3h2x1(:,134),heltab2x2(:,:,134))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),8,nMT,G2tensor(134),n2h1(46))
  call Hloop_AV_Q(ntryL,G1H2(231),ex4(:),G1H1(1),m3h2x1(:,135),heltab2x2(:,:,135))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,nMT,G2tensor(135),n2h1(47))
  call Hloop_AV_Q(ntryL,G1H2(232),ex4(:),G1H1(1),m3h2x1(:,136),heltab2x2(:,:,136))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),10,nMT,G2tensor(136),n2h1(48))
  call Hloop_AV_Q(ntryL,G1H2(236),ex4(:),G1H1(1),m3h2x1(:,137),heltab2x2(:,:,137))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,nMT,G2tensor(137),n2h1(49))
  call Hloop_AV_Q(ntryL,G1H2(237),ex4(:),G1H1(1),m3h2x1(:,138),heltab2x2(:,:,138))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),8,nMT,G2tensor(138),n2h1(50))
  call Hloop_AV_Q(ntryL,G1H2(242),ex4(:),G1H1(1),m3h2x1(:,139),heltab2x2(:,:,139))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,nMT,G2tensor(139),n2h1(51))
  call Hloop_AV_Q(ntryL,G1H2(243),ex4(:),G1H1(1),m3h2x1(:,140),heltab2x2(:,:,140))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),10,nMT,G2tensor(140),n2h1(52))
  call Hloop_AV_Q(ntryL,G1H2(247),ex4(:),G1H1(1),m3h2x1(:,141),heltab2x2(:,:,141))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,nMB,G2tensor(141),n2h1(53))
  call Hloop_AV_Q(ntryL,G1H2(248),ex4(:),G1H1(1),m3h2x1(:,142),heltab2x2(:,:,142))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),8,nMB,G2tensor(142),n2h1(54))
  call Hloop_AV_Q(ntryL,G1H2(253),ex4(:),G1H1(1),m3h2x1(:,143),heltab2x2(:,:,143))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,nMB,G2tensor(143),n2h1(55))
  call Hloop_AV_Q(ntryL,G1H2(254),ex4(:),G1H1(1),m3h2x1(:,144),heltab2x2(:,:,144))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),10,nMB,G2tensor(144),n2h1(56))
  call Hloop_AV_Q(ntryL,G1H2(258),ex4(:),G1H1(1),m3h2x1(:,145),heltab2x2(:,:,145))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,nMT,G2tensor(145),n2h1(57))
  call Hloop_AV_Q(ntryL,G1H2(259),ex4(:),G1H1(1),m3h2x1(:,146),heltab2x2(:,:,146))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),8,nMT,G2tensor(146),n2h1(58))
  call Hloop_AV_Q(ntryL,G1H2(264),ex4(:),G1H1(1),m3h2x1(:,147),heltab2x2(:,:,147))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,nMT,G2tensor(147),n2h1(59))
  call Hloop_AV_Q(ntryL,G1H2(265),ex4(:),G1H1(1),m3h2x1(:,148),heltab2x2(:,:,148))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),10,nMT,G2tensor(148),n2h1(60))
  call Hloop_QV_A(ntryL,G1H2(269),ex4(:),G1H1(1),m3h2x1(:,149),heltab2x2(:,:,149))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,nMT,G2tensor(149),n2h1(61))
  call Hloop_QV_A(ntryL,G1H2(270),ex4(:),G1H1(1),m3h2x1(:,150),heltab2x2(:,:,150))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),8,nMT,G2tensor(150),n2h1(62))
  call Hloop_QV_A(ntryL,G1H2(275),ex4(:),G1H1(1),m3h2x1(:,151),heltab2x2(:,:,151))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,nMT,G2tensor(151),n2h1(63))
  call Hloop_QV_A(ntryL,G1H2(276),ex4(:),G1H1(1),m3h2x1(:,152),heltab2x2(:,:,152))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),12,nMT,G2tensor(152),n2h1(64))
  call Hloop_QV_A(ntryL,G1H2(280),ex4(:),G1H1(1),m3h2x1(:,153),heltab2x2(:,:,153))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,nMT,G2tensor(153),n2h1(65))
  call Hloop_QV_A(ntryL,G1H2(281),ex4(:),G1H1(1),m3h2x1(:,154),heltab2x2(:,:,154))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),8,nMT,G2tensor(154),n2h1(66))
  call Hloop_QV_A(ntryL,G1H2(286),ex4(:),G1H1(1),m3h2x1(:,155),heltab2x2(:,:,155))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,nMT,G2tensor(155),n2h1(67))
  call Hloop_QV_A(ntryL,G1H2(287),ex4(:),G1H1(1),m3h2x1(:,156),heltab2x2(:,:,156))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),12,nMT,G2tensor(156),n2h1(68))
  call Hloop_QV_A(ntryL,G1H2(291),ex4(:),G1H1(1),m3h2x1(:,157),heltab2x2(:,:,157))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,nMB,G2tensor(157),n2h1(69))
  call Hloop_QV_A(ntryL,G1H2(292),ex4(:),G1H1(1),m3h2x1(:,158),heltab2x2(:,:,158))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),8,nMB,G2tensor(158),n2h1(70))
  call Hloop_QV_A(ntryL,G1H2(297),ex4(:),G1H1(1),m3h2x1(:,159),heltab2x2(:,:,159))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,nMB,G2tensor(159),n2h1(71))
  call Hloop_QV_A(ntryL,G1H2(298),ex4(:),G1H1(1),m3h2x1(:,160),heltab2x2(:,:,160))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),12,nMB,G2tensor(160),n2h1(72))
  call Hcheck_last_SV_T(ntryL,l_switch,G1H2(303),4,ex4(:),8,G2tensor(161),m3h2x1(:,161),heltab2x2(:,:,161))
  call Hloop_QV_A(ntryL,G1H2(307),ex4(:),G1H1(1),m3h2x1(:,162),heltab2x2(:,:,162))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,nMT,G2tensor(162),n2h1(74))
  call Hloop_QV_A(ntryL,G1H2(308),ex4(:),G1H1(1),m3h2x1(:,163),heltab2x2(:,:,163))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),8,nMT,G2tensor(163),n2h1(75))
  call Hloop_QV_A(ntryL,G1H2(313),ex4(:),G1H1(1),m3h2x1(:,164),heltab2x2(:,:,164))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,nMT,G2tensor(164),n2h1(76))
  call Hloop_QV_A(ntryL,G1H2(314),ex4(:),G1H1(1),m3h2x1(:,165),heltab2x2(:,:,165))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),12,nMT,G2tensor(165),n2h1(77))
  call Hcheck_last_UW_V(ntryL,l_switch,G1H2(319),4,ex4(:),8,G2tensor(166),m3h2x1(:,166),heltab2x2(:,:,166))
  call Hloop_QV_A(ntryL,G1H2(323),ex4(:),G1H1(1),m3h2x1(:,167),heltab2x2(:,:,167))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,nMT,G2tensor(167),n2h1(79))
  call Hloop_QV_A(ntryL,G1H2(324),ex4(:),G1H1(1),m3h2x1(:,168),heltab2x2(:,:,168))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),8,nMT,G2tensor(168),n2h1(80))
  call Hloop_QV_A(ntryL,G1H2(329),ex4(:),G1H1(1),m3h2x1(:,169),heltab2x2(:,:,169))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,nMT,G2tensor(169),n2h1(81))
  call Hloop_QV_A(ntryL,G1H2(330),ex4(:),G1H1(1),m3h2x1(:,170),heltab2x2(:,:,170))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),9,nMT,G2tensor(170),n2h1(82))
  call Hloop_QV_A(ntryL,G1H2(334),ex4(:),G1H1(1),m3h2x1(:,171),heltab2x2(:,:,171))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,nMT,G2tensor(171),n2h1(83))
  call Hloop_QV_A(ntryL,G1H2(335),ex4(:),G1H1(1),m3h2x1(:,172),heltab2x2(:,:,172))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),8,nMT,G2tensor(172),n2h1(84))
  call Hloop_QV_A(ntryL,G1H2(340),ex4(:),G1H1(1),m3h2x1(:,173),heltab2x2(:,:,173))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,nMT,G2tensor(173),n2h1(85))
  call Hloop_QV_A(ntryL,G1H2(341),ex4(:),G1H1(1),m3h2x1(:,174),heltab2x2(:,:,174))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),9,nMT,G2tensor(174),n2h1(86))
  call Hloop_QV_A(ntryL,G1H2(345),ex4(:),G1H1(1),m3h2x1(:,175),heltab2x2(:,:,175))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,nMB,G2tensor(175),n2h1(87))
  call Hloop_QV_A(ntryL,G1H2(346),ex4(:),G1H1(1),m3h2x1(:,176),heltab2x2(:,:,176))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),8,nMB,G2tensor(176),n2h1(88))
  call Hloop_QV_A(ntryL,G1H2(351),ex4(:),G1H1(1),m3h2x1(:,177),heltab2x2(:,:,177))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,nMB,G2tensor(177),n2h1(89))
  call Hloop_QV_A(ntryL,G1H2(352),ex4(:),G1H1(1),m3h2x1(:,178),heltab2x2(:,:,178))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),9,nMB,G2tensor(178),n2h1(90))
  call Hloop_QV_A(ntryL,G1H2(356),ex4(:),G1H1(1),m3h2x1(:,179),heltab2x2(:,:,179))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,nMT,G2tensor(179),n2h1(91))
  call Hloop_QV_A(ntryL,G1H2(357),ex4(:),G1H1(1),m3h2x1(:,180),heltab2x2(:,:,180))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),8,nMT,G2tensor(180),n2h1(92))
  call Hloop_QV_A(ntryL,G1H2(362),ex4(:),G1H1(1),m3h2x1(:,181),heltab2x2(:,:,181))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,nMT,G2tensor(181),n2h1(93))
  call Hloop_QV_A(ntryL,G1H2(363),ex4(:),G1H1(1),m3h2x1(:,182),heltab2x2(:,:,182))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),9,nMT,G2tensor(182),n2h1(94))
  call Hloop_QV_A(ntryL,G1H2(367),ex3(:),G1H1(1),m3h2x1(:,183),heltab2x2(:,:,183))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,nMT,G2tensor(183),n2h1(95))
  call Hloop_QV_A(ntryL,G1H2(368),ex3(:),G1H1(1),m3h2x1(:,184),heltab2x2(:,:,184))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),4,nMT,G2tensor(184),n2h1(96))
  call Hloop_QV_A(ntryL,G1H2(373),ex3(:),G1H1(1),m3h2x1(:,185),heltab2x2(:,:,185))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,nMT,G2tensor(185),n2h1(97))
  call Hloop_QV_A(ntryL,G1H2(374),ex3(:),G1H1(1),m3h2x1(:,186),heltab2x2(:,:,186))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),12,nMT,G2tensor(186),n2h1(98))
  call Hloop_QV_A(ntryL,G1H2(378),ex3(:),G1H1(1),m3h2x1(:,187),heltab2x2(:,:,187))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,nMT,G2tensor(187),n2h1(99))
  call Hloop_QV_A(ntryL,G1H2(379),ex3(:),G1H1(1),m3h2x1(:,188),heltab2x2(:,:,188))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),4,nMT,G2tensor(188),n2h1(100))
  call Hloop_QV_A(ntryL,G1H2(384),ex3(:),G1H1(1),m3h2x1(:,189),heltab2x2(:,:,189))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,nMT,G2tensor(189),n2h1(101))
  call Hloop_QV_A(ntryL,G1H2(385),ex3(:),G1H1(1),m3h2x1(:,190),heltab2x2(:,:,190))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),12,nMT,G2tensor(190),n2h1(102))
  call Hloop_QV_A(ntryL,G1H2(389),ex3(:),G1H1(1),m3h2x1(:,191),heltab2x2(:,:,191))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,nMB,G2tensor(191),n2h1(103))
  call Hloop_QV_A(ntryL,G1H2(390),ex3(:),G1H1(1),m3h2x1(:,192),heltab2x2(:,:,192))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),4,nMB,G2tensor(192),n2h1(104))
  call Hloop_QV_A(ntryL,G1H2(395),ex3(:),G1H1(1),m3h2x1(:,193),heltab2x2(:,:,193))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,nMB,G2tensor(193),n2h1(105))
  call Hloop_QV_A(ntryL,G1H2(396),ex3(:),G1H1(1),m3h2x1(:,194),heltab2x2(:,:,194))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),12,nMB,G2tensor(194),n2h1(106))
  call Hcheck_last_SV_T(ntryL,l_switch,G1H2(401),8,ex3(:),4,G2tensor(195),m3h2x1(:,195),heltab2x2(:,:,195))
  call Hloop_QV_A(ntryL,G1H2(405),ex3(:),G1H1(1),m3h2x1(:,196),heltab2x2(:,:,196))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,nMT,G2tensor(196),n2h1(108))
  call Hloop_QV_A(ntryL,G1H2(406),ex3(:),G1H1(1),m3h2x1(:,197),heltab2x2(:,:,197))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),4,nMT,G2tensor(197),n2h1(109))
  call Hloop_QV_A(ntryL,G1H2(411),ex3(:),G1H1(1),m3h2x1(:,198),heltab2x2(:,:,198))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,nMT,G2tensor(198),n2h1(110))
  call Hloop_QV_A(ntryL,G1H2(412),ex3(:),G1H1(1),m3h2x1(:,199),heltab2x2(:,:,199))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),12,nMT,G2tensor(199),n2h1(111))
  call Hcheck_last_UW_V(ntryL,l_switch,G1H2(417),8,ex3(:),4,G2tensor(200),m3h2x1(:,200),heltab2x2(:,:,200))
  call Hloop_AV_Q(ntryL,G1H2(421),ex4(:),G1H1(1),m3h2x1(:,201),heltab2x2(:,:,201))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,nMT,G2tensor(201),n2h1(113))
  call Hloop_AV_Q(ntryL,G1H2(422),ex4(:),G1H1(1),m3h2x1(:,202),heltab2x2(:,:,202))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),8,nMT,G2tensor(202),n2h1(114))
  call Hloop_AV_Q(ntryL,G1H2(427),ex4(:),G1H1(1),m3h2x1(:,203),heltab2x2(:,:,203))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,nMT,G2tensor(203),n2h1(115))
  call Hloop_AV_Q(ntryL,G1H2(428),ex4(:),G1H1(1),m3h2x1(:,204),heltab2x2(:,:,204))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),12,nMT,G2tensor(204),n2h1(116))
  call Hloop_AV_Q(ntryL,G1H2(432),ex4(:),G1H1(1),m3h2x1(:,205),heltab2x2(:,:,205))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,nMT,G2tensor(205),n2h1(117))
  call Hloop_AV_Q(ntryL,G1H2(433),ex4(:),G1H1(1),m3h2x1(:,206),heltab2x2(:,:,206))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),8,nMT,G2tensor(206),n2h1(118))
  call Hloop_AV_Q(ntryL,G1H2(438),ex4(:),G1H1(1),m3h2x1(:,207),heltab2x2(:,:,207))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,nMT,G2tensor(207),n2h1(119))
  call Hloop_AV_Q(ntryL,G1H2(439),ex4(:),G1H1(1),m3h2x1(:,208),heltab2x2(:,:,208))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),12,nMT,G2tensor(208),n2h1(120))
  call Hloop_AV_Q(ntryL,G1H2(443),ex4(:),G1H1(1),m3h2x1(:,209),heltab2x2(:,:,209))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,nMB,G2tensor(209),n2h1(121))
  call Hloop_AV_Q(ntryL,G1H2(444),ex4(:),G1H1(1),m3h2x1(:,210),heltab2x2(:,:,210))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),8,nMB,G2tensor(210),n2h1(122))
  call Hloop_AV_Q(ntryL,G1H2(449),ex4(:),G1H1(1),m3h2x1(:,211),heltab2x2(:,:,211))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,nMB,G2tensor(211),n2h1(123))
  call Hloop_AV_Q(ntryL,G1H2(450),ex4(:),G1H1(1),m3h2x1(:,212),heltab2x2(:,:,212))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),12,nMB,G2tensor(212),n2h1(124))
  call Hcheck_last_TV_S(ntryL,l_switch,G1H2(455),4,ex4(:),8,G2tensor(213),m3h2x1(:,213),heltab2x2(:,:,213))
  call Hloop_AV_Q(ntryL,G1H2(459),ex4(:),G1H1(1),m3h2x1(:,214),heltab2x2(:,:,214))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,nMT,G2tensor(214),n2h1(126))
  call Hloop_AV_Q(ntryL,G1H2(460),ex4(:),G1H1(1),m3h2x1(:,215),heltab2x2(:,:,215))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),8,nMT,G2tensor(215),n2h1(127))
  call Hloop_AV_Q(ntryL,G1H2(465),ex4(:),G1H1(1),m3h2x1(:,216),heltab2x2(:,:,216))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,nMT,G2tensor(216),n2h1(128))
  call Hloop_AV_Q(ntryL,G1H2(466),ex4(:),G1H1(1),m3h2x1(:,217),heltab2x2(:,:,217))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),12,nMT,G2tensor(217),n2h1(129))
  call Hcheck_last_UV_W(ntryL,l_switch,G1H2(471),4,ex4(:),8,G2tensor(218),m3h2x1(:,218),heltab2x2(:,:,218))
  call Hloop_AV_Q(ntryL,G1H2(475),ex3(:),G1H1(1),m3h2x1(:,219),heltab2x2(:,:,219))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,nMT,G2tensor(219),n2h1(131))
  call Hloop_AV_Q(ntryL,G1H2(476),ex3(:),G1H1(1),m3h2x1(:,220),heltab2x2(:,:,220))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),4,nMT,G2tensor(220),n2h1(132))
  call Hloop_AV_Q(ntryL,G1H2(481),ex3(:),G1H1(1),m3h2x1(:,221),heltab2x2(:,:,221))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,nMT,G2tensor(221),n2h1(133))
  call Hloop_AV_Q(ntryL,G1H2(482),ex3(:),G1H1(1),m3h2x1(:,222),heltab2x2(:,:,222))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),12,nMT,G2tensor(222),n2h1(134))
  call Hloop_AV_Q(ntryL,G1H2(486),ex3(:),G1H1(1),m3h2x1(:,223),heltab2x2(:,:,223))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,nMT,G2tensor(223),n2h1(135))
  call Hloop_AV_Q(ntryL,G1H2(487),ex3(:),G1H1(1),m3h2x1(:,224),heltab2x2(:,:,224))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),4,nMT,G2tensor(224),n2h1(136))
  call Hloop_AV_Q(ntryL,G1H2(492),ex3(:),G1H1(1),m3h2x1(:,225),heltab2x2(:,:,225))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,nMT,G2tensor(225),n2h1(137))
  call Hloop_AV_Q(ntryL,G1H2(493),ex3(:),G1H1(1),m3h2x1(:,226),heltab2x2(:,:,226))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),12,nMT,G2tensor(226),n2h1(138))
  call Hloop_AV_Q(ntryL,G1H2(497),ex3(:),G1H1(1),m3h2x1(:,227),heltab2x2(:,:,227))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,nMB,G2tensor(227),n2h1(139))
  call Hloop_AV_Q(ntryL,G1H2(498),ex3(:),G1H1(1),m3h2x1(:,228),heltab2x2(:,:,228))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),4,nMB,G2tensor(228),n2h1(140))
  call Hloop_AV_Q(ntryL,G1H2(503),ex3(:),G1H1(1),m3h2x1(:,229),heltab2x2(:,:,229))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,nMB,G2tensor(229),n2h1(141))
  call Hloop_AV_Q(ntryL,G1H2(504),ex3(:),G1H1(1),m3h2x1(:,230),heltab2x2(:,:,230))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),12,nMB,G2tensor(230),n2h1(142))
  call Hcheck_last_TV_S(ntryL,l_switch,G1H2(509),8,ex3(:),4,G2tensor(231),m3h2x1(:,231),heltab2x2(:,:,231))
  call Hloop_AV_Q(ntryL,G1H2(513),ex3(:),G1H1(1),m3h2x1(:,232),heltab2x2(:,:,232))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,nMT,G2tensor(232),n2h1(144))
  call Hloop_AV_Q(ntryL,G1H2(514),ex3(:),G1H1(1),m3h2x1(:,233),heltab2x2(:,:,233))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),4,nMT,G2tensor(233),n2h1(145))
  call Hloop_AV_Q(ntryL,G1H2(519),ex3(:),G1H1(1),m3h2x1(:,234),heltab2x2(:,:,234))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,nMT,G2tensor(234),n2h1(146))
  call Hloop_AV_Q(ntryL,G1H2(520),ex3(:),G1H1(1),m3h2x1(:,235),heltab2x2(:,:,235))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),12,nMT,G2tensor(235),n2h1(147))
  call Hcheck_last_UV_W(ntryL,l_switch,G1H2(525),8,ex3(:),4,G2tensor(236),m3h2x1(:,236),heltab2x2(:,:,236))
  call Hloop_QV_A(ntryL,G1H2(529),ex4(:),G1H1(1),m3h2x1(:,237),heltab2x2(:,:,237))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,nMB,G2tensor(237),n2h1(149))
  call Hloop_QV_A(ntryL,G1H2(530),ex4(:),G1H1(1),m3h2x1(:,238),heltab2x2(:,:,238))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),8,nMB,G2tensor(238),n2h1(150))
  call Hloop_QV_A(ntryL,G1H2(535),ex4(:),G1H1(1),m3h2x1(:,239),heltab2x2(:,:,239))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,nMB,G2tensor(239),n2h1(151))
  call Hloop_QV_A(ntryL,G1H2(536),ex4(:),G1H1(1),m3h2x1(:,240),heltab2x2(:,:,240))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),9,nMB,G2tensor(240),n2h1(152))
  call Hloop_QV_A(ntryL,G1H2(540),ex3(:),G1H1(1),m3h2x1(:,241),heltab2x2(:,:,241))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,nMB,G2tensor(241),n2h1(153))
  call Hloop_QV_A(ntryL,G1H2(541),ex3(:),G1H1(1),m3h2x1(:,242),heltab2x2(:,:,242))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),4,nMB,G2tensor(242),n2h1(154))
  call Hloop_QV_A(ntryL,G1H2(546),ex3(:),G1H1(1),m3h2x1(:,243),heltab2x2(:,:,243))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,nMB,G2tensor(243),n2h1(155))
  call Hloop_QV_A(ntryL,G1H2(547),ex3(:),G1H1(1),m3h2x1(:,244),heltab2x2(:,:,244))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),5,nMB,G2tensor(244),n2h1(156))
  call Hloop_AV_Q(ntryL,G1H2(551),ex4(:),G1H1(1),m3h2x1(:,245),heltab2x2(:,:,245))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,nMB,G2tensor(245),n2h1(157))
  call Hloop_AV_Q(ntryL,G1H2(552),ex4(:),G1H1(1),m3h2x1(:,246),heltab2x2(:,:,246))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),8,nMB,G2tensor(246),n2h1(158))
  call Hloop_AV_Q(ntryL,G1H2(557),ex4(:),G1H1(1),m3h2x1(:,247),heltab2x2(:,:,247))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,nMB,G2tensor(247),n2h1(159))
  call Hloop_AV_Q(ntryL,G1H2(558),ex4(:),G1H1(1),m3h2x1(:,248),heltab2x2(:,:,248))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),10,nMB,G2tensor(248),n2h1(160))
  call Hloop_SA_Q(ntryL,G1H2(563),ex2(:),G1H1(1),ngPtb,m3h2x1(:,249),heltab2x2(:,:,249))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),10,nMB,G2tensor(249),n2h1(161))
  call Hloop_WA_Q(ntryL,G1H2(568),ex2(:),G1H1(1),m3h2x1(:,250),heltab2x2(:,:,250))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),10,nMB,G2tensor(250),n2h1(162))
  call Hloop_AV_Q(ntryL,G1H2(572),ex3(:),G1H1(1),m3h2x1(:,251),heltab2x2(:,:,251))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,nMB,G2tensor(251),n2h1(163))
  call Hloop_AV_Q(ntryL,G1H2(573),ex3(:),G1H1(1),m3h2x1(:,252),heltab2x2(:,:,252))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),4,nMB,G2tensor(252),n2h1(164))
  call Hloop_AV_Q(ntryL,G1H2(578),ex3(:),G1H1(1),m3h2x1(:,253),heltab2x2(:,:,253))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,nMB,G2tensor(253),n2h1(165))
  call Hloop_AV_Q(ntryL,G1H2(579),ex3(:),G1H1(1),m3h2x1(:,254),heltab2x2(:,:,254))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),6,nMB,G2tensor(254),n2h1(166))
  call Hloop_SA_Q(ntryL,G1H2(584),ex2(:),G1H1(1),ngPtb,m3h2x1(:,255),heltab2x2(:,:,255))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),6,nMB,G2tensor(255),n2h1(167))
  call Hloop_WA_Q(ntryL,G1H2(589),ex2(:),G1H1(1),m3h2x1(:,256),heltab2x2(:,:,256))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),6,nMB,G2tensor(256),n2h1(168))
  call ol_merge_tensors(G2tensor(52),[G2tensor(49),G2tensor(2),G2tensor(1)])
  call ol_merge_tensors(G2tensor(58),[G2tensor(55),G2tensor(4),G2tensor(3)])
  call ol_merge_tensors(G2tensor(64),[G2tensor(61),G2tensor(6),G2tensor(5)])
  call ol_merge_tensors(G2tensor(70),[G2tensor(67),G2tensor(8),G2tensor(7)])
  call ol_merge_tensors(G2tensor(76),[G2tensor(73),G2tensor(10),G2tensor(9)])
  call ol_merge_tensors(G2tensor(82),[G2tensor(79),G2tensor(12),G2tensor(11)])
  call ol_merge_tensors(G2tensor(105),[G2tensor(101),G2tensor(19),G2tensor(17)])
  call ol_merge_tensors(G2tensor(113),[G2tensor(109),G2tensor(23),G2tensor(21)])
  call ol_merge_tensors(G2tensor(121),[G2tensor(117),G2tensor(27),G2tensor(25)])
  call ol_merge_tensors(G2tensor(129),[G2tensor(125),G2tensor(31),G2tensor(29)])
  call ol_merge_tensors(G2tensor(43),[G2tensor(41)])
  call ol_merge_tensors(G2tensor(47),[G2tensor(45)])
  call ol_merge_tensors(G2tensor(88),[G2tensor(85)])
  call ol_merge_tensors(G2tensor(94),[G2tensor(91)])
  call Hotf_5pt_reduction_last(G2tensor(52),RedSet_5(1),mass5set(:,1),  & 
G1tensor(1),G1tensor(2),G1tensor(3),G1tensor(4),G1tensor(5),G1tensor(6))
  call G_TensorShift(G1tensor(2),8)
  call Hotf_5pt_reduction_last(G2tensor(58),RedSet_5(9),mass5set(:,11),  & 
G1tensor(7),G1tensor(8),G1tensor(9),G1tensor(10),G1tensor(11),G1tensor(12))
  call G_TensorShift(G1tensor(8),8)
  call Hotf_5pt_reduction_last(G2tensor(64),RedSet_5(2),mass5set(:,1),  & 
G1tensor(13),G1tensor(14),G1tensor(15),G1tensor(16),G1tensor(17),G1tensor(18))
  call G_TensorShift(G1tensor(14),8)
  call Hotf_5pt_reduction_last(G2tensor(70),RedSet_5(10),mass5set(:,11),  & 
G1tensor(19),G1tensor(20),G1tensor(21),G1tensor(22),G1tensor(23),G1tensor(24))
  call G_TensorShift(G1tensor(20),4)
  call Hotf_5pt_reduction_last(G2tensor(76),RedSet_5(11),mass5set(:,11),  & 
G1tensor(25),G1tensor(26),G1tensor(27),G1tensor(28),G1tensor(29),G1tensor(30))
  call G_TensorShift(G1tensor(26),8)
  call Hotf_5pt_reduction_last(G2tensor(82),RedSet_5(12),mass5set(:,11),  & 
G1tensor(31),G1tensor(32),G1tensor(33),G1tensor(34),G1tensor(35),G1tensor(36))
  call G_TensorShift(G1tensor(32),4)
  call Hotf_5pt_reduction_last(G2tensor(105),RedSet_5(3),mass5set(:,2),  & 
G1tensor(37),G1tensor(38),G1tensor(39),G1tensor(40),G1tensor(41),G1tensor(42))
  call G_TensorShift(G1tensor(38),8)
  call Hotf_5pt_reduction_last(G2tensor(113),RedSet_5(4),mass5set(:,2),  & 
G1tensor(43),G1tensor(44),G1tensor(45),G1tensor(46),G1tensor(47),G1tensor(48))
  call G_TensorShift(G1tensor(44),4)
  call Hotf_5pt_reduction_last(G2tensor(121),RedSet_5(5),mass5set(:,2),  & 
G1tensor(49),G1tensor(50),G1tensor(51),G1tensor(52),G1tensor(53),G1tensor(54))
  call G_TensorShift(G1tensor(50),8)
  call Hotf_5pt_reduction_last(G2tensor(129),RedSet_5(7),mass5set(:,2),  & 
G1tensor(55),G1tensor(56),G1tensor(57),G1tensor(58),G1tensor(59),G1tensor(60))
  call G_TensorShift(G1tensor(56),4)
  call Hotf_5pt_reduction_last(G2tensor(43),RedSet_5(6),mass5set(:,3),  & 
G1tensor(61),G1tensor(62),G1tensor(63),G1tensor(64),G1tensor(65),G1tensor(66))
  call G_TensorShift(G1tensor(62),2)
  call Hotf_5pt_reduction_last(G2tensor(47),RedSet_5(8),mass5set(:,3),  & 
G1tensor(67),G1tensor(68),G1tensor(69),G1tensor(70),G1tensor(71),G1tensor(72))
  call G_TensorShift(G1tensor(68),2)
  call Hotf_5pt_reduction_last(G2tensor(88),RedSet_5(6),mass5set(:,14),  & 
G1tensor(73),G1tensor(74),G1tensor(75),G1tensor(76),G1tensor(77),G1tensor(78))
  call G_TensorShift(G1tensor(74),2)
  call Hotf_5pt_reduction_last(G2tensor(94),RedSet_5(8),mass5set(:,14),  & 
G1tensor(79),G1tensor(80),G1tensor(81),G1tensor(82),G1tensor(83),G1tensor(84))
  call G_TensorShift(G1tensor(80),2)
  call Hotf_5pt_reduction_last(G2tensor(133),RedSet_5(1),mass5set(:,4),  & 
G1tensor(85),G1tensor(86),G1tensor(87),G1tensor(88),G1tensor(89),G1tensor(90))
  call G_TensorShift(G1tensor(86),8)
  call Hotf_5pt_reduction_last(G2tensor(137),RedSet_5(1),mass5set(:,5),  & 
G1tensor(91),G1tensor(92),G1tensor(93),G1tensor(94),G1tensor(95),G1tensor(96))
  call G_TensorShift(G1tensor(92),8)
  call Hotf_5pt_reduction_last(G2tensor(141),RedSet_5(1),mass5set(:,6),  & 
G1tensor(97),G1tensor(98),G1tensor(99),G1tensor(100),G1tensor(101),G1tensor(102))
  call G_TensorShift(G1tensor(98),8)
  call Hotf_5pt_reduction_last(G2tensor(145),RedSet_5(1),mass5set(:,7),  & 
G1tensor(103),G1tensor(104),G1tensor(105),G1tensor(106),G1tensor(107),G1tensor(108))
  call G_TensorShift(G1tensor(104),8)
  call Hotf_5pt_reduction_last(G2tensor(149),RedSet_5(9),mass5set(:,8),  & 
G1tensor(109),G1tensor(110),G1tensor(111),G1tensor(112),G1tensor(113),G1tensor(114))
  call G_TensorShift(G1tensor(110),8)
  call Hotf_5pt_reduction_last(G2tensor(153),RedSet_5(9),mass5set(:,9),  & 
G1tensor(115),G1tensor(116),G1tensor(117),G1tensor(118),G1tensor(119),G1tensor(120))
  call G_TensorShift(G1tensor(116),8)
  call Hotf_5pt_reduction_last(G2tensor(157),RedSet_5(9),mass5set(:,10),  & 
G1tensor(121),G1tensor(122),G1tensor(123),G1tensor(124),G1tensor(125),G1tensor(126))
  call G_TensorShift(G1tensor(122),8)
  call Hotf_5pt_reduction_last(G2tensor(162),RedSet_5(9),mass5set(:,12),  & 
G1tensor(127),G1tensor(128),G1tensor(129),G1tensor(130),G1tensor(131),G1tensor(132))
  call G_TensorShift(G1tensor(128),8)
  call Hotf_5pt_reduction_last(G2tensor(167),RedSet_5(2),mass5set(:,4),  & 
G1tensor(133),G1tensor(134),G1tensor(135),G1tensor(136),G1tensor(137),G1tensor(138))
  call G_TensorShift(G1tensor(134),8)
  call Hotf_5pt_reduction_last(G2tensor(171),RedSet_5(2),mass5set(:,5),  & 
G1tensor(139),G1tensor(140),G1tensor(141),G1tensor(142),G1tensor(143),G1tensor(144))
  call G_TensorShift(G1tensor(140),8)
  call Hotf_5pt_reduction_last(G2tensor(175),RedSet_5(2),mass5set(:,6),  & 
G1tensor(145),G1tensor(146),G1tensor(147),G1tensor(148),G1tensor(149),G1tensor(150))
  call G_TensorShift(G1tensor(146),8)
  call Hotf_5pt_reduction_last(G2tensor(179),RedSet_5(2),mass5set(:,7),  & 
G1tensor(151),G1tensor(152),G1tensor(153),G1tensor(154),G1tensor(155),G1tensor(156))
  call G_TensorShift(G1tensor(152),8)
  call Hotf_5pt_reduction_last(G2tensor(183),RedSet_5(10),mass5set(:,8),  & 
G1tensor(157),G1tensor(158),G1tensor(159),G1tensor(160),G1tensor(161),G1tensor(162))
  call G_TensorShift(G1tensor(158),4)
  call Hotf_5pt_reduction_last(G2tensor(187),RedSet_5(10),mass5set(:,9),  & 
G1tensor(163),G1tensor(164),G1tensor(165),G1tensor(166),G1tensor(167),G1tensor(168))
  call G_TensorShift(G1tensor(164),4)
  call Hotf_5pt_reduction_last(G2tensor(191),RedSet_5(10),mass5set(:,10),  & 
G1tensor(169),G1tensor(170),G1tensor(171),G1tensor(172),G1tensor(173),G1tensor(174))
  call G_TensorShift(G1tensor(170),4)
  call Hotf_5pt_reduction_last(G2tensor(196),RedSet_5(10),mass5set(:,12),  & 
G1tensor(175),G1tensor(176),G1tensor(177),G1tensor(178),G1tensor(179),G1tensor(180))
  call G_TensorShift(G1tensor(176),4)
  call Hotf_5pt_reduction_last(G2tensor(201),RedSet_5(11),mass5set(:,8),  & 
G1tensor(181),G1tensor(182),G1tensor(183),G1tensor(184),G1tensor(185),G1tensor(186))
  call G_TensorShift(G1tensor(182),8)
  call Hotf_5pt_reduction_last(G2tensor(205),RedSet_5(11),mass5set(:,9),  & 
G1tensor(187),G1tensor(188),G1tensor(189),G1tensor(190),G1tensor(191),G1tensor(192))
  call G_TensorShift(G1tensor(188),8)
  call Hotf_5pt_reduction_last(G2tensor(209),RedSet_5(11),mass5set(:,10),  & 
G1tensor(193),G1tensor(194),G1tensor(195),G1tensor(196),G1tensor(197),G1tensor(198))
  call G_TensorShift(G1tensor(194),8)
  call Hotf_5pt_reduction_last(G2tensor(214),RedSet_5(11),mass5set(:,12),  & 
G1tensor(199),G1tensor(200),G1tensor(201),G1tensor(202),G1tensor(203),G1tensor(204))
  call G_TensorShift(G1tensor(200),8)
  call Hotf_5pt_reduction_last(G2tensor(219),RedSet_5(12),mass5set(:,8),  & 
G1tensor(205),G1tensor(206),G1tensor(207),G1tensor(208),G1tensor(209),G1tensor(210))
  call G_TensorShift(G1tensor(206),4)
  call Hotf_5pt_reduction_last(G2tensor(223),RedSet_5(12),mass5set(:,9),  & 
G1tensor(211),G1tensor(212),G1tensor(213),G1tensor(214),G1tensor(215),G1tensor(216))
  call G_TensorShift(G1tensor(212),4)
  call Hotf_5pt_reduction_last(G2tensor(227),RedSet_5(12),mass5set(:,10),  & 
G1tensor(217),G1tensor(218),G1tensor(219),G1tensor(220),G1tensor(221),G1tensor(222))
  call G_TensorShift(G1tensor(218),4)
  call Hotf_5pt_reduction_last(G2tensor(232),RedSet_5(12),mass5set(:,12),  & 
G1tensor(223),G1tensor(224),G1tensor(225),G1tensor(226),G1tensor(227),G1tensor(228))
  call G_TensorShift(G1tensor(224),4)
  call Hotf_5pt_reduction_last(G2tensor(237),RedSet_5(3),mass5set(:,13),  & 
G1tensor(229),G1tensor(230),G1tensor(231),G1tensor(232),G1tensor(233),G1tensor(234))
  call G_TensorShift(G1tensor(230),8)
  call Hotf_5pt_reduction_last(G2tensor(241),RedSet_5(4),mass5set(:,13),  & 
G1tensor(235),G1tensor(236),G1tensor(237),G1tensor(238),G1tensor(239),G1tensor(240))
  call G_TensorShift(G1tensor(236),4)
  call Hotf_5pt_reduction_last(G2tensor(245),RedSet_5(5),mass5set(:,13),  & 
G1tensor(241),G1tensor(242),G1tensor(243),G1tensor(244),G1tensor(245),G1tensor(246))
  call G_TensorShift(G1tensor(242),8)
  call Hotf_5pt_reduction_last(G2tensor(251),RedSet_5(7),mass5set(:,13),  & 
G1tensor(247),G1tensor(248),G1tensor(249),G1tensor(250),G1tensor(251),G1tensor(252))
  call G_TensorShift(G1tensor(248),4)
  call ol_merge_tensors(T1sum(1),[G1tensor(1)])
  call ol_merge_tensors(T1sum(2),[G1tensor(7)])
  call ol_merge_tensors(T1sum(3),[G1tensor(13)])
  call ol_merge_tensors(T1sum(4),[G1tensor(19)])
  call ol_merge_tensors(T1sum(5),[G1tensor(25)])
  call ol_merge_tensors(T1sum(6),[G1tensor(31)])
  call ol_merge_tensors(T1sum(7),[G1tensor(37)])
  call ol_merge_tensors(T1sum(8),[G1tensor(43)])
  call ol_merge_tensors(T1sum(9),[G1tensor(49)])
  call ol_merge_tensors(T1sum(10),[G1tensor(55)])
  call ol_merge_tensors(T1sum(11),[G1tensor(61)])
  call ol_merge_tensors(T1sum(12),[G1tensor(67)])
  call ol_merge_tensors(T1sum(13),[G1tensor(73)])
  call ol_merge_tensors(T1sum(14),[G1tensor(79)])
  call ol_merge_tensors(T1sum(15),[G1tensor(85)])
  call ol_merge_tensors(T1sum(16),[G1tensor(91)])
  call ol_merge_tensors(T1sum(17),[G1tensor(97)])
  call ol_merge_tensors(T1sum(18),[G1tensor(103)])
  call ol_merge_tensors(T1sum(19),[G1tensor(109)])
  call ol_merge_tensors(T1sum(20),[G1tensor(115)])
  call ol_merge_tensors(T1sum(21),[G1tensor(121)])
  call ol_merge_tensors(T1sum(22),[G1tensor(127)])
  call ol_merge_tensors(T1sum(23),[G1tensor(133)])
  call ol_merge_tensors(T1sum(24),[G1tensor(139)])
  call ol_merge_tensors(T1sum(25),[G1tensor(145)])
  call ol_merge_tensors(T1sum(26),[G1tensor(151)])
  call ol_merge_tensors(T1sum(27),[G1tensor(157)])
  call ol_merge_tensors(T1sum(28),[G1tensor(163)])
  call ol_merge_tensors(T1sum(29),[G1tensor(169)])
  call ol_merge_tensors(T1sum(30),[G1tensor(175)])
  call ol_merge_tensors(T1sum(31),[G1tensor(181)])
  call ol_merge_tensors(T1sum(32),[G1tensor(187)])
  call ol_merge_tensors(T1sum(33),[G1tensor(193)])
  call ol_merge_tensors(T1sum(34),[G1tensor(199)])
  call ol_merge_tensors(T1sum(35),[G1tensor(205)])
  call ol_merge_tensors(T1sum(36),[G1tensor(211)])
  call ol_merge_tensors(T1sum(37),[G1tensor(217)])
  call ol_merge_tensors(T1sum(38),[G1tensor(223)])
  call ol_merge_tensors(T1sum(39),[G1tensor(229)])
  call ol_merge_tensors(T1sum(40),[G1tensor(235)])
  call ol_merge_tensors(T1sum(41),[G1tensor(241)])
  call ol_merge_tensors(T1sum(42),[G1tensor(247)])
  Gcoeff(:)%j = (-(c(40)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(205),h0tab(:,205),[24,2,1,4],[nMW,nMB,nMW,nMW],5,0)
  call Hloop_SVV_S(ntryL,G0H32(1),ex5(:),ex4(:),G0H8(9),m4h2x2x8(:,1),heltab3x32(:,:,1))
  Gcoeff(:)%j = (-(c(22)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(206),h0tab(:,206),[24,2,1,4],[nMW,nMB,nMW,nMW],5,0)
  call Hloop_SVV_S(ntryL,G0H32(1),ex5(:),ex4(:),G0H8(1),m4h2x2x8(:,2),heltab3x32(:,:,2))
  Gcoeff(:)%j = (c(21)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(207),h0tab(:,207),[24,2,1,4],[nMW,nMB,nMW,nMW],5,0)
  call Hloop_VWW_V(ntryL,G0H32(1),ex5(:),ex4(:),G0H8(2),m4h2x2x8(:,3),heltab3x32(:,:,3))
  Gcoeff(:)%j = (-(c(21)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(208),h0tab(:,208),[24,2,1,4],[nMW,nMB,nMW,nMW],5,0)
  call Hloop_VWW_V(ntryL,G0H32(1),ex5(:),ex4(:),G0H8(3),m4h2x2x8(:,4),heltab3x32(:,:,4))
  Gcoeff(:)%j = (-(c(40)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(209),h0tab(:,209),[24,1,2,4],[nMW,nMB,nMW,nMW],5,0)
  call Hloop_SVV_S(ntryL,G0H32(1),ex5(:),ex4(:),G0H8(4),m4h2x2x8(:,5),heltab3x32(:,:,5))
  Gcoeff(:)%j = (c(22)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(210),h0tab(:,210),[24,1,2,4],[nMW,nMB,nMW,nMW],5,0)
  call Hloop_SVV_S(ntryL,G0H32(1),ex5(:),ex4(:),G0H8(5),m4h2x2x8(:,6),heltab3x32(:,:,6))
  Gcoeff(:)%j = (-(c(21)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(211),h0tab(:,211),[24,1,2,4],[nMW,nMB,nMW,nMW],5,0)
  call Hloop_VWW_V(ntryL,G0H32(1),ex5(:),ex4(:),G0H8(7),m4h2x2x8(:,7),heltab3x32(:,:,7))
  Gcoeff(:)%j = (-(c(21)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(212),h0tab(:,212),[24,1,2,4],[nMW,nMB,nMW,nMW],5,0)
  call Hloop_VWW_V(ntryL,G0H32(1),ex5(:),ex4(:),G0H8(6),m4h2x2x8(:,8),heltab3x32(:,:,8))
  Gcoeff(:)%j = (c(37)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(213),h0tab(:,213),[24,1,4,2],[nMW,nMB,nMB,nMW],5,0)
  call Hloop_SVV_S(ntryL,G0H32(1),ex5(:),ex4(:),G0H8(8),m4h2x2x8(:,9),heltab3x32(:,:,9))
  Gcoeff(:)%j = (c(18)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(214),h0tab(:,214),[24,1,4,2],[nMW,nMB,nMB,nMW],5,0)
  call Hloop_VWW_V(ntryL,G0H32(1),ex5(:),ex4(:),G0H8(10),m4h2x2x8(:,10),heltab3x32(:,:,10))
  Gcoeff(:)%j = (-(c(40)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(215),h0tab(:,215),[20,2,1,8],[nMW,nMB,nMW,nMW],5,0)
  call Hloop_SVV_S(ntryL,G0H32(1),ex5(:),ex3(:),G0H8(11),m4h2x2x8(:,11),heltab3x32(:,:,11))
  Gcoeff(:)%j = (-(c(22)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(216),h0tab(:,216),[20,2,1,8],[nMW,nMB,nMW,nMW],5,0)
  call Hloop_SVV_S(ntryL,G0H32(1),ex5(:),ex3(:),G0H8(12),m4h2x2x8(:,12),heltab3x32(:,:,12))
  Gcoeff(:)%j = (c(21)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(217),h0tab(:,217),[20,2,1,8],[nMW,nMB,nMW,nMW],5,0)
  call Hloop_VWW_V(ntryL,G0H32(1),ex5(:),ex3(:),G0H8(13),m4h2x2x8(:,13),heltab3x32(:,:,13))
  Gcoeff(:)%j = (-(c(21)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(218),h0tab(:,218),[20,2,1,8],[nMW,nMB,nMW,nMW],5,0)
  call Hloop_VWW_V(ntryL,G0H32(1),ex5(:),ex3(:),G0H8(14),m4h2x2x8(:,14),heltab3x32(:,:,14))
  Gcoeff(:)%j = (-(c(40)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(219),h0tab(:,219),[20,1,2,8],[nMW,nMB,nMW,nMW],5,0)
  call Hloop_SVV_S(ntryL,G0H32(1),ex5(:),ex3(:),G0H8(15),m4h2x2x8(:,15),heltab3x32(:,:,15))
  Gcoeff(:)%j = (c(22)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(220),h0tab(:,220),[20,1,2,8],[nMW,nMB,nMW,nMW],5,0)
  call Hloop_SVV_S(ntryL,G0H32(1),ex5(:),ex3(:),G0H8(16),m4h2x2x8(:,16),heltab3x32(:,:,16))
  Gcoeff(:)%j = (-(c(21)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(221),h0tab(:,221),[20,1,2,8],[nMW,nMB,nMW,nMW],5,0)
  call Hloop_VWW_V(ntryL,G0H32(1),ex5(:),ex3(:),G0H8(17),m4h2x2x8(:,17),heltab3x32(:,:,17))
  Gcoeff(:)%j = (-(c(21)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(222),h0tab(:,222),[20,1,2,8],[nMW,nMB,nMW,nMW],5,0)
  call Hloop_VWW_V(ntryL,G0H32(1),ex5(:),ex3(:),G0H8(18),m4h2x2x8(:,18),heltab3x32(:,:,18))
  Gcoeff(:)%j = (c(37)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(223),h0tab(:,223),[20,1,8,2],[nMW,nMB,nMB,nMW],5,0)
  call Hloop_SVV_S(ntryL,G0H32(1),ex5(:),ex3(:),G0H8(19),m4h2x2x8(:,19),heltab3x32(:,:,19))
  Gcoeff(:)%j = (c(18)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(224),h0tab(:,224),[20,1,8,2],[nMW,nMB,nMB,nMW],5,0)
  call Hloop_VWW_V(ntryL,G0H32(1),ex5(:),ex3(:),G0H8(20),m4h2x2x8(:,20),heltab3x32(:,:,20))
  Gcoeff(:)%j = (-(c(40)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(225),h0tab(:,225),[16,1,2,12],[nMW,nMB,nMW,nMW],5,0)
  call Hloop_TV_S(ntryL,G0H32(1),0,ex5(:),16,G1H16(1),m3h2x16(:,205),heltab2x32(:,:,205))
  Gcoeff(:)%j = (-(c(22)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(226),h0tab(:,226),[16,1,2,12],[nMW,nMB,nMW,nMW],5,0)
  call Hloop_SV_V(ntryL,G0H32(1),ex5(:),G0H16(69),m3h2x16(:,206),heltab2x32(:,:,206))
  Gcoeff(:)%j = (c(21)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(227),h0tab(:,227),[16,1,2,12],[nMW,nMB,nMW,nMW],5,0)
  call Hloop_VV_S(ntryL,G0H32(1),ex5(:),G0H16(1),m3h2x16(:,207),heltab2x32(:,:,207))
  Gcoeff(:)%j = (-(c(21)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(228),h0tab(:,228),[16,1,2,12],[nMW,nMB,nMW,nMW],5,0)
  call Hloop_UV_W(ntryL,G0H32(1),0,ex5(:),16,G1H16(2),m3h2x16(:,208),heltab2x32(:,:,208))
  Gcoeff(:)%j = (-(c(40)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(229),h0tab(:,229),[16,2,1,12],[nMW,nMB,nMW,nMW],5,0)
  call Hloop_SV_T(ntryL,G0H32(1),0,ex5(:),16,G1H16(3),m3h2x16(:,209),heltab2x32(:,:,209))
  Gcoeff(:)%j = (c(22)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(230),h0tab(:,230),[16,2,1,12],[nMW,nMB,nMW,nMW],5,0)
  call Hloop_SV_V(ntryL,G0H32(1),ex5(:),G0H16(2),m3h2x16(:,210),heltab2x32(:,:,210))
  Gcoeff(:)%j = (-(c(21)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(231),h0tab(:,231),[16,2,1,12],[nMW,nMB,nMW,nMW],5,0)
  call Hloop_VV_S(ntryL,G0H32(1),ex5(:),G0H16(3),m3h2x16(:,211),heltab2x32(:,:,211))
  Gcoeff(:)%j = (-(c(21)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(232),h0tab(:,232),[16,2,1,12],[nMW,nMB,nMW,nMW],5,0)
  call Hloop_UW_V(ntryL,G0H32(1),0,ex5(:),16,G1H16(4),m3h2x16(:,212),heltab2x32(:,:,212))
  Gcoeff(:)%j = (c(37)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(233),h0tab(:,233),[16,1,12,2],[nMB,nMW,nMW,nMB],5,0)
  call Hloop_AV_Q(ntryL,G0H32(1),ex5(:),G0H16(4),m3h2x16(:,213),heltab2x32(:,:,213))
  call Hloop_A_Q(ntryL,G0H16(4),16,nMB,G1H16(5),n2h16(69))
  Gcoeff(:)%j = (c(18)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(234),h0tab(:,234),[16,1,12,2],[nMB,nMW,nMW,nMB],5,0)
  call Hloop_AV_Q(ntryL,G0H32(1),ex5(:),G0H16(5),m3h2x16(:,214),heltab2x32(:,:,214))
  call Hloop_A_Q(ntryL,G0H16(5),16,nMB,G1H16(6),n2h16(70))
  Gcoeff(:)%j = (-(c(84)*M(1,:)%j)) * den(54)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(235),h0tab(:,235),[16,3,8,4],[nME,nME,nME,nME],4,1,wf4(:,36))
  call Hloop_QV_A(ntryL,G0H32(1),ex5(:),G0H16(6),m3h2x16(:,215),heltab2x32(:,:,215))
  call Hloop_Q_A(ntryL,G0H16(6),16,nME,G1H16(7),n2h16(71))
  Gcoeff(:)%j = (-(c(88)*M(1,:)%j)) * den(54)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(236),h0tab(:,236),[16,3,8,4],[nMM,nMM,nMM,nMM],4,1,wf4(:,36))
  call Hloop_QV_A(ntryL,G0H32(1),ex5(:),G0H16(7),m3h2x16(:,216),heltab2x32(:,:,216))
  call Hloop_Q_A(ntryL,G0H16(7),16,nMM,G1H16(8),n2h16(72))
  Gcoeff(:)%j = (-(c(86)*M(1,:)%j)) * den(54)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(237),h0tab(:,237),[16,3,8,4],[nML,nML,nML,nML],4,1,wf4(:,36))
  call Hloop_QV_A(ntryL,G0H32(1),ex5(:),G0H16(8),m3h2x16(:,217),heltab2x32(:,:,217))
  call Hloop_Q_A(ntryL,G0H16(8),16,nML,G1H16(9),n2h16(73))
  Gcoeff(:)%j = (-(c(84)*M(1,:)%j)) * den(54)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(238),h0tab(:,238),[16,3,8,4],[nME,nME,nME,nME],4,1,wf4(:,36))
  call Hloop_AV_Q(ntryL,G0H32(1),ex5(:),G0H16(9),m3h2x16(:,218),heltab2x32(:,:,218))
  call Hloop_A_Q(ntryL,G0H16(9),16,nME,G1H16(10),n2h16(74))
  Gcoeff(:)%j = (-(c(88)*M(1,:)%j)) * den(54)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(239),h0tab(:,239),[16,3,8,4],[nMM,nMM,nMM,nMM],4,1,wf4(:,36))
  call Hloop_AV_Q(ntryL,G0H32(1),ex5(:),G0H16(10),m3h2x16(:,219),heltab2x32(:,:,219))
  call Hloop_A_Q(ntryL,G0H16(10),16,nMM,G1H16(11),n2h16(75))
  Gcoeff(:)%j = (-(c(86)*M(1,:)%j)) * den(54)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(240),h0tab(:,240),[16,3,8,4],[nML,nML,nML,nML],4,1,wf4(:,36))
  call Hloop_AV_Q(ntryL,G0H32(1),ex5(:),G0H16(11),m3h2x16(:,220),heltab2x32(:,:,220))
  call Hloop_A_Q(ntryL,G0H16(11),16,nML,G1H16(12),n2h16(76))
  Gcoeff(:)%j = (c(89)*M(1,:)%j) * den(54)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(241),h0tab(:,241),[16,3,8,4],[nMT,nMT,nMT,nMT],4,1,wf4(:,36))
  call Hloop_QV_A(ntryL,G0H32(1),ex5(:),G0H16(12),m3h2x16(:,221),heltab2x32(:,:,221))
  call Hloop_Q_A(ntryL,G0H16(12),16,nMT,G1H16(13),n2h16(77))
  Gcoeff(:)%j = (c(89)*M(1,:)%j) * den(54)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(242),h0tab(:,242),[16,3,8,4],[nMT,nMT,nMT,nMT],4,1,wf4(:,36))
  call Hloop_AV_Q(ntryL,G0H32(1),ex5(:),G0H16(13),m3h2x16(:,222),heltab2x32(:,:,222))
  call Hloop_A_Q(ntryL,G0H16(13),16,nMT,G1H16(14),n2h16(78))
  Gcoeff(:)%j = (-(c(81)*M(1,:)%j)) * den(54)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(243),h0tab(:,243),[16,3,8,4],[nMB,nMB,nMB,nMB],4,1,wf4(:,36))
  call Hloop_QV_A(ntryL,G0H32(1),ex5(:),G0H16(14),m3h2x16(:,223),heltab2x32(:,:,223))
  call Hloop_Q_A(ntryL,G0H16(14),16,nMB,G1H16(15),n2h16(79))
  Gcoeff(:)%j = (-(c(81)*M(1,:)%j)) * den(54)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(244),h0tab(:,244),[16,3,8,4],[nMB,nMB,nMB,nMB],4,1,wf4(:,36))
  call Hloop_AV_Q(ntryL,G0H32(1),ex5(:),G0H16(15),m3h2x16(:,224),heltab2x32(:,:,224))
  call Hloop_A_Q(ntryL,G0H16(15),16,nMB,G1H16(16),n2h16(80))
  Gcoeff(:)%j = (-(c(84)*M(1,:)%j)) * den(14)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(245),h0tab(:,245),[16,3,8,4],[nME,nME,nME,nME],4,1,wf4(:,37))
  call Hloop_QV_A(ntryL,G0H32(1),ex5(:),G0H16(16),m3h2x16(:,225),heltab2x32(:,:,225))
  call Hloop_Q_A(ntryL,G0H16(16),16,nME,G1H16(17),n2h16(81))
  Gcoeff(:)%j = (-(c(88)*M(1,:)%j)) * den(14)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(246),h0tab(:,246),[16,3,8,4],[nMM,nMM,nMM,nMM],4,1,wf4(:,37))
  call Hloop_QV_A(ntryL,G0H32(1),ex5(:),G0H16(17),m3h2x16(:,226),heltab2x32(:,:,226))
  call Hloop_Q_A(ntryL,G0H16(17),16,nMM,G1H16(18),n2h16(82))
  Gcoeff(:)%j = (-(c(86)*M(1,:)%j)) * den(14)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(247),h0tab(:,247),[16,3,8,4],[nML,nML,nML,nML],4,1,wf4(:,37))
  call Hloop_QV_A(ntryL,G0H32(1),ex5(:),G0H16(18),m3h2x16(:,227),heltab2x32(:,:,227))
  call Hloop_Q_A(ntryL,G0H16(18),16,nML,G1H16(19),n2h16(83))
  Gcoeff(:)%j = (-(c(84)*M(1,:)%j)) * den(14)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(248),h0tab(:,248),[16,3,8,4],[nME,nME,nME,nME],4,1,wf4(:,37))
  call Hloop_AV_Q(ntryL,G0H32(1),ex5(:),G0H16(19),m3h2x16(:,228),heltab2x32(:,:,228))
  call Hloop_A_Q(ntryL,G0H16(19),16,nME,G1H16(20),n2h16(84))
  Gcoeff(:)%j = (-(c(88)*M(1,:)%j)) * den(14)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(249),h0tab(:,249),[16,3,8,4],[nMM,nMM,nMM,nMM],4,1,wf4(:,37))
  call Hloop_AV_Q(ntryL,G0H32(1),ex5(:),G0H16(20),m3h2x16(:,229),heltab2x32(:,:,229))
  call Hloop_A_Q(ntryL,G0H16(20),16,nMM,G1H16(21),n2h16(85))
  Gcoeff(:)%j = (-(c(86)*M(1,:)%j)) * den(14)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(250),h0tab(:,250),[16,3,8,4],[nML,nML,nML,nML],4,1,wf4(:,37))
  call Hloop_AV_Q(ntryL,G0H32(1),ex5(:),G0H16(21),m3h2x16(:,230),heltab2x32(:,:,230))
  call Hloop_A_Q(ntryL,G0H16(21),16,nML,G1H16(22),n2h16(86))
  Gcoeff(:)%j = (-(c(89)*M(1,:)%j)) * den(14)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(251),h0tab(:,251),[16,3,8,4],[nMT,nMT,nMT,nMT],4,1,wf4(:,37))
  call Hloop_QV_A(ntryL,G0H32(1),ex5(:),G0H16(22),m3h2x16(:,231),heltab2x32(:,:,231))
  call Hloop_Q_A(ntryL,G0H16(22),16,nMT,G1H16(23),n2h16(87))
  Gcoeff(:)%j = (-(c(89)*M(1,:)%j)) * den(14)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(252),h0tab(:,252),[16,3,8,4],[nMT,nMT,nMT,nMT],4,1,wf4(:,37))
  call Hloop_AV_Q(ntryL,G0H32(1),ex5(:),G0H16(23),m3h2x16(:,232),heltab2x32(:,:,232))
  call Hloop_A_Q(ntryL,G0H16(23),16,nMT,G1H16(24),n2h16(88))
  Gcoeff(:)%j = (-(c(81)*M(1,:)%j)) * den(14)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(253),h0tab(:,253),[16,3,8,4],[nMB,nMB,nMB,nMB],4,1,wf4(:,37))
  call Hloop_QV_A(ntryL,G0H32(1),ex5(:),G0H16(24),m3h2x16(:,233),heltab2x32(:,:,233))
  call Hloop_Q_A(ntryL,G0H16(24),16,nMB,G1H16(25),n2h16(89))
  Gcoeff(:)%j = (-(c(81)*M(1,:)%j)) * den(14)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(254),h0tab(:,254),[16,3,8,4],[nMB,nMB,nMB,nMB],4,1,wf4(:,37))
  call Hloop_AV_Q(ntryL,G0H32(1),ex5(:),G0H16(25),m3h2x16(:,234),heltab2x32(:,:,234))
  call Hloop_A_Q(ntryL,G0H16(25),16,nMB,G1H16(26),n2h16(90))
  Gcoeff(:)%j = (-(c(42)*M(1,:)%j)) * den(54)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(255),h0tab(:,255),[16,3,8,4],[nMW,nMW,nMW,nMW],4,1,wf4(:,36))
  call Hloop_TV_S(ntryL,G0H32(1),0,ex5(:),16,G1H16(27),m3h2x16(:,235),heltab2x32(:,:,235))
  Gcoeff(:)%j = (-(c(42)*M(1,:)%j)) * den(54)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(256),h0tab(:,256),[16,3,8,4],[nMW,nMW,nMW,nMW],4,1,wf4(:,36))
  call Hloop_SV_T(ntryL,G0H32(1),0,ex5(:),16,G1H16(28),m3h2x16(:,236),heltab2x32(:,:,236))
  Gcoeff(:)%j = (-(c(24)*M(1,:)%j)) * den(54)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(257),h0tab(:,257),[16,3,8,4],[nMW,nMW,nMW,nMW],4,1,wf4(:,36))
  call Hloop_CV_D(ntryL,G0H32(1),0,ex5(:),16,G1H16(29),m3h2x16(:,237),heltab2x32(:,:,237))
  Gcoeff(:)%j = (-(c(24)*M(1,:)%j)) * den(54)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(258),h0tab(:,258),[16,3,8,4],[nMW,nMW,nMW,nMW],4,1,wf4(:,36))
  call Hloop_DV_C(ntryL,G0H32(1),0,ex5(:),G1H16(30),m3h2x16(:,238),heltab2x32(:,:,238))
  Gcoeff(:)%j = (c(24)*M(1,:)%j) * den(54)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(259),h0tab(:,259),[16,3,8,4],[nMW,nMW,nMW,nMW],4,1,wf4(:,36))
  call Hloop_CV_D(ntryL,G0H32(1),0,ex5(:),16,G1H16(31),m3h2x16(:,239),heltab2x32(:,:,239))
  Gcoeff(:)%j = (c(24)*M(1,:)%j) * den(54)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(260),h0tab(:,260),[16,3,8,4],[nMW,nMW,nMW,nMW],4,1,wf4(:,36))
  call Hloop_DV_C(ntryL,G0H32(1),0,ex5(:),G1H16(32),m3h2x16(:,240),heltab2x32(:,:,240))
  Gcoeff(:)%j = (-(c(24)*M(1,:)%j)) * den(14)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(261),h0tab(:,261),[16,3,8,4],[nMW,nMW,nMW,nMW],4,1,wf4(:,37))
  call Hloop_CV_D(ntryL,G0H32(1),0,ex5(:),16,G1H16(33),m3h2x16(:,241),heltab2x32(:,:,241))
  Gcoeff(:)%j = (-(c(24)*M(1,:)%j)) * den(14)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(262),h0tab(:,262),[16,3,8,4],[nMW,nMW,nMW,nMW],4,1,wf4(:,37))
  call Hloop_DV_C(ntryL,G0H32(1),0,ex5(:),G1H16(34),m3h2x16(:,242),heltab2x32(:,:,242))
  Gcoeff(:)%j = (-(c(24)*M(1,:)%j)) * den(14)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(263),h0tab(:,263),[16,3,8,4],[nMW,nMW,nMW,nMW],4,1,wf4(:,37))
  call Hloop_CV_D(ntryL,G0H32(1),0,ex5(:),16,G1H16(35),m3h2x16(:,243),heltab2x32(:,:,243))
  Gcoeff(:)%j = (-(c(24)*M(1,:)%j)) * den(14)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(264),h0tab(:,264),[16,3,8,4],[nMW,nMW,nMW,nMW],4,1,wf4(:,37))
  call Hloop_DV_C(ntryL,G0H32(1),0,ex5(:),G1H16(36),m3h2x16(:,244),heltab2x32(:,:,244))
  Gcoeff(:)%j = (-(c(26)*M(1,:)%j)) * den(54)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(265),h0tab(:,265),[16,3,8,4],[nMW,nMW,nMW,nMW],4,1,wf4(:,36))
  call Hloop_UV_W(ntryL,G0H32(1),0,ex5(:),16,G1H16(37),m3h2x16(:,245),heltab2x32(:,:,245))
  Gcoeff(:)%j = (-(c(26)*M(1,:)%j)) * den(54)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(266),h0tab(:,266),[16,3,8,4],[nMW,nMW,nMW,nMW],4,1,wf4(:,36))
  call Hloop_UW_V(ntryL,G0H32(1),0,ex5(:),16,G1H16(38),m3h2x16(:,246),heltab2x32(:,:,246))
  Gcoeff(:)%j = (-(c(24)*M(1,:)%j)) * den(54)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(267),h0tab(:,267),[16,3,8,4],[nMW,nMW,nMW,nMW],4,1,wf4(:,36))
  call Hloop_SV_V(ntryL,G0H32(1),ex5(:),G0H16(26),m3h2x16(:,247),heltab2x32(:,:,247))
  Gcoeff(:)%j = (c(24)*M(1,:)%j) * den(54)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(268),h0tab(:,268),[16,3,8,4],[nMW,nMW,nMW,nMW],4,1,wf4(:,36))
  call Hloop_SV_V(ntryL,G0H32(1),ex5(:),G0H16(27),m3h2x16(:,248),heltab2x32(:,:,248))
  Gcoeff(:)%j = (-(c(24)*M(1,:)%j)) * den(14)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(269),h0tab(:,269),[16,3,8,4],[nMW,nMW,nMW,nMW],4,1,wf4(:,37))
  call Hloop_SV_V(ntryL,G0H32(1),ex5(:),G0H16(28),m3h2x16(:,249),heltab2x32(:,:,249))
  Gcoeff(:)%j = (-(c(24)*M(1,:)%j)) * den(14)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(270),h0tab(:,270),[16,3,8,4],[nMW,nMW,nMW,nMW],4,1,wf4(:,37))
  call Hloop_SV_V(ntryL,G0H32(1),ex5(:),G0H16(29),m3h2x16(:,250),heltab2x32(:,:,250))
  Gcoeff(:)%j = (c(24)*M(1,:)%j) * den(54)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(271),h0tab(:,271),[16,3,8,4],[nMW,nMW,nMW,nMW],4,1,wf4(:,36))
  call Hloop_TV_S(ntryL,G0H32(1),0,ex5(:),16,G1H16(39),m3h2x16(:,251),heltab2x32(:,:,251))
  Gcoeff(:)%j = (-(c(24)*M(1,:)%j)) * den(54)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(272),h0tab(:,272),[16,3,8,4],[nMW,nMW,nMW,nMW],4,1,wf4(:,36))
  call Hloop_SV_T(ntryL,G0H32(1),0,ex5(:),16,G1H16(40),m3h2x16(:,252),heltab2x32(:,:,252))
  Gcoeff(:)%j = (-(c(24)*M(1,:)%j)) * den(14)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(273),h0tab(:,273),[16,3,8,4],[nMW,nMW,nMW,nMW],4,1,wf4(:,37))
  call Hloop_TV_S(ntryL,G0H32(1),0,ex5(:),16,G1H16(41),m3h2x16(:,253),heltab2x32(:,:,253))
  Gcoeff(:)%j = (-(c(24)*M(1,:)%j)) * den(14)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(274),h0tab(:,274),[16,3,8,4],[nMW,nMW,nMW,nMW],4,1,wf4(:,37))
  call Hloop_SV_T(ntryL,G0H32(1),0,ex5(:),16,G1H16(42),m3h2x16(:,254),heltab2x32(:,:,254))
  Gcoeff(:)%j = (c(28)*M(1,:)%j) * den(54)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(275),h0tab(:,275),[16,3,8,4],[nMW,nMW,nMW,nMW],4,1,wf4(:,36))
  call Hloop_VV_S(ntryL,G0H32(1),ex5(:),G0H16(30),m3h2x16(:,255),heltab2x32(:,:,255))
  Gcoeff(:)%j = (c(28)*M(1,:)%j) * den(54)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(276),h0tab(:,276),[16,3,8,4],[nMW,nMW,nMW,nMW],4,1,wf4(:,36))
  call Hloop_VV_S(ntryL,G0H32(1),ex5(:),G0H16(31),m3h2x16(:,256),heltab2x32(:,:,256))
  Gcoeff(:)%j = (c(28)*M(1,:)%j) * den(54)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(277),h0tab(:,277),[16,3,8,4],[nMW,nMW,nMW,nMW],4,1,wf4(:,36))
  call Hloop_TV_S(ntryL,G0H32(1),0,ex5(:),16,G1H16(43),m3h2x16(:,257),heltab2x32(:,:,257))
  Gcoeff(:)%j = (c(28)*M(1,:)%j) * den(54)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(278),h0tab(:,278),[16,3,8,4],[nMW,nMW,nMW,nMW],4,1,wf4(:,36))
  call Hloop_SV_T(ntryL,G0H32(1),0,ex5(:),16,G1H16(44),m3h2x16(:,258),heltab2x32(:,:,258))
  Gcoeff(:)%j = (c(51)*M(1,:)%j) * den(54)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(279),h0tab(:,279),[16,3,8,4],[nMW,nMW,nMW,nMW],4,1,wf4(:,36))
  call Hloop_SV_V(ntryL,G0H32(1),ex5(:),G0H16(32),m3h2x16(:,259),heltab2x32(:,:,259))
  Gcoeff(:)%j = (c(51)*M(1,:)%j) * den(54)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(280),h0tab(:,280),[16,3,8,4],[nMW,nMW,nMW,nMW],4,1,wf4(:,36))
  call Hloop_SV_V(ntryL,G0H32(1),ex5(:),G0H16(33),m3h2x16(:,260),heltab2x32(:,:,260))
  Gcoeff(:)%j = (-(c(24)*M(1,:)%j)) * den(54)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(281),h0tab(:,281),[16,3,8,4],[nMW,nMW,nMW,nMW],4,1,wf4(:,36))
  call Hloop_UV_W(ntryL,G0H32(1),0,ex5(:),16,G1H16(45),m3h2x16(:,261),heltab2x32(:,:,261))
  Gcoeff(:)%j = (c(24)*M(1,:)%j) * den(54)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(282),h0tab(:,282),[16,3,8,4],[nMW,nMW,nMW,nMW],4,1,wf4(:,36))
  call Hloop_UW_V(ntryL,G0H32(1),0,ex5(:),16,G1H16(46),m3h2x16(:,262),heltab2x32(:,:,262))
  Gcoeff(:)%j = (-(c(24)*M(1,:)%j)) * den(14)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(283),h0tab(:,283),[16,3,8,4],[nMW,nMW,nMW,nMW],4,1,wf4(:,37))
  call Hloop_UV_W(ntryL,G0H32(1),0,ex5(:),16,G1H16(47),m3h2x16(:,263),heltab2x32(:,:,263))
  Gcoeff(:)%j = (-(c(24)*M(1,:)%j)) * den(14)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(284),h0tab(:,284),[16,3,8,4],[nMW,nMW,nMW,nMW],4,1,wf4(:,37))
  call Hloop_UW_V(ntryL,G0H32(1),0,ex5(:),16,G1H16(48),m3h2x16(:,264),heltab2x32(:,:,264))
  Gcoeff(:)%j = (-(c(49)*M(1,:)%j)) * den(54)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(285),h0tab(:,285),[16,3,8,4],[nMW,nMW,nMW,nMW],4,1,wf4(:,36))
  call Hloop_VV_S(ntryL,G0H32(1),ex5(:),G0H16(34),m3h2x16(:,265),heltab2x32(:,:,265))
  Gcoeff(:)%j = (c(49)*M(1,:)%j) * den(54)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(286),h0tab(:,286),[16,3,8,4],[nMW,nMW,nMW,nMW],4,1,wf4(:,36))
  call Hloop_VV_S(ntryL,G0H32(1),ex5(:),G0H16(35),m3h2x16(:,266),heltab2x32(:,:,266))
  Gcoeff(:)%j = (c(49)*M(1,:)%j) * den(14)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(287),h0tab(:,287),[16,3,8,4],[nMW,nMW,nMW,nMW],4,1,wf4(:,37))
  call Hloop_VV_S(ntryL,G0H32(1),ex5(:),G0H16(36),m3h2x16(:,267),heltab2x32(:,:,267))
  Gcoeff(:)%j = (c(49)*M(1,:)%j) * den(14)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(288),h0tab(:,288),[16,3,8,4],[nMW,nMW,nMW,nMW],4,1,wf4(:,37))
  call Hloop_VV_S(ntryL,G0H32(1),ex5(:),G0H16(37),m3h2x16(:,268),heltab2x32(:,:,268))
  Gcoeff(:)%j = (c(49)*M(1,:)%j) * den(54)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(289),h0tab(:,289),[16,3,8,4],[nMW,nMW,nMW,nMW],4,1,wf4(:,36))
  call Hloop_SV_V(ntryL,G0H32(1),ex5(:),G0H16(38),m3h2x16(:,269),heltab2x32(:,:,269))
  Gcoeff(:)%j = (-(c(49)*M(1,:)%j)) * den(54)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(290),h0tab(:,290),[16,3,8,4],[nMW,nMW,nMW,nMW],4,1,wf4(:,36))
  call Hloop_SV_V(ntryL,G0H32(1),ex5(:),G0H16(39),m3h2x16(:,270),heltab2x32(:,:,270))
  Gcoeff(:)%j = (c(49)*M(1,:)%j) * den(14)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(291),h0tab(:,291),[16,3,8,4],[nMW,nMW,nMW,nMW],4,1,wf4(:,37))
  call Hloop_SV_V(ntryL,G0H32(1),ex5(:),G0H16(40),m3h2x16(:,271),heltab2x32(:,:,271))
  Gcoeff(:)%j = (c(49)*M(1,:)%j) * den(14)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(292),h0tab(:,292),[16,3,8,4],[nMW,nMW,nMW,nMW],4,1,wf4(:,37))
  call Hloop_SV_V(ntryL,G0H32(1),ex5(:),G0H16(41),m3h2x16(:,272),heltab2x32(:,:,272))
  Gcoeff(:)%j = (c(24)*M(1,:)%j) * den(54)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(293),h0tab(:,293),[16,3,8,4],[nMW,nMW,nMW,nMW],4,1,wf4(:,36))
  call Hloop_TV_S(ntryL,G0H32(1),0,ex5(:),16,G1H16(49),m3h2x16(:,273),heltab2x32(:,:,273))
  Gcoeff(:)%j = (-(c(24)*M(1,:)%j)) * den(54)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(294),h0tab(:,294),[16,3,8,4],[nMW,nMW,nMW,nMW],4,1,wf4(:,36))
  call Hloop_SV_T(ntryL,G0H32(1),0,ex5(:),16,G1H16(50),m3h2x16(:,274),heltab2x32(:,:,274))
  Gcoeff(:)%j = (-(c(24)*M(1,:)%j)) * den(14)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(295),h0tab(:,295),[16,3,8,4],[nMW,nMW,nMW,nMW],4,1,wf4(:,37))
  call Hloop_TV_S(ntryL,G0H32(1),0,ex5(:),16,G1H16(51),m3h2x16(:,275),heltab2x32(:,:,275))
  Gcoeff(:)%j = (-(c(24)*M(1,:)%j)) * den(14)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(296),h0tab(:,296),[16,3,8,4],[nMW,nMW,nMW,nMW],4,1,wf4(:,37))
  call Hloop_SV_T(ntryL,G0H32(1),0,ex5(:),16,G1H16(52),m3h2x16(:,276),heltab2x32(:,:,276))
  Gcoeff(:)%j = (c(28)*M(1,:)%j) * den(54)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(297),h0tab(:,297),[16,3,8,4],[nMW,nMW,nMW,nMW],4,1,wf4(:,36))
  call Hloop_VV_S(ntryL,G0H32(1),ex5(:),G0H16(42),m3h2x16(:,277),heltab2x32(:,:,277))
  Gcoeff(:)%j = (c(28)*M(1,:)%j) * den(54)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(298),h0tab(:,298),[16,3,8,4],[nMW,nMW,nMW,nMW],4,1,wf4(:,36))
  call Hloop_VV_S(ntryL,G0H32(1),ex5(:),G0H16(43),m3h2x16(:,278),heltab2x32(:,:,278))
  Gcoeff(:)%j = (c(51)*M(1,:)%j) * den(54)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(299),h0tab(:,299),[16,3,8,4],[nMW,nMW,nMW,nMW],4,1,wf4(:,36))
  call Hloop_UV_W(ntryL,G0H32(1),0,ex5(:),16,G1H16(53),m3h2x16(:,279),heltab2x32(:,:,279))
  Gcoeff(:)%j = (c(51)*M(1,:)%j) * den(54)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(300),h0tab(:,300),[16,3,8,4],[nMW,nMW,nMW,nMW],4,1,wf4(:,36))
  call Hloop_UW_V(ntryL,G0H32(1),0,ex5(:),16,G1H16(54),m3h2x16(:,280),heltab2x32(:,:,280))
  Gcoeff(:)%j = (c(51)*M(1,:)%j) * den(54)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(301),h0tab(:,301),[16,3,8,4],[nMW,nMW,nMW,nMW],4,1,wf4(:,36))
  call Hloop_SV_V(ntryL,G0H32(1),ex5(:),G0H16(44),m3h2x16(:,281),heltab2x32(:,:,281))
  Gcoeff(:)%j = (c(51)*M(1,:)%j) * den(54)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(302),h0tab(:,302),[16,3,8,4],[nMW,nMW,nMW,nMW],4,1,wf4(:,36))
  call Hloop_SV_V(ntryL,G0H32(1),ex5(:),G0H16(45),m3h2x16(:,282),heltab2x32(:,:,282))
  Gcoeff(:)%j = (-(c(24)*M(1,:)%j)) * den(54)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(303),h0tab(:,303),[16,3,8,4],[nMW,nMW,nMW,nMW],4,1,wf4(:,36))
  call Hloop_UV_W(ntryL,G0H32(1),0,ex5(:),16,G1H16(55),m3h2x16(:,283),heltab2x32(:,:,283))
  Gcoeff(:)%j = (c(24)*M(1,:)%j) * den(54)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(304),h0tab(:,304),[16,3,8,4],[nMW,nMW,nMW,nMW],4,1,wf4(:,36))
  call Hloop_UW_V(ntryL,G0H32(1),0,ex5(:),16,G1H16(56),m3h2x16(:,284),heltab2x32(:,:,284))
  Gcoeff(:)%j = (-(c(24)*M(1,:)%j)) * den(14)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(305),h0tab(:,305),[16,3,8,4],[nMW,nMW,nMW,nMW],4,1,wf4(:,37))
  call Hloop_UV_W(ntryL,G0H32(1),0,ex5(:),16,G1H16(57),m3h2x16(:,285),heltab2x32(:,:,285))
  Gcoeff(:)%j = (-(c(24)*M(1,:)%j)) * den(14)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(306),h0tab(:,306),[16,3,8,4],[nMW,nMW,nMW,nMW],4,1,wf4(:,37))
  call Hloop_UW_V(ntryL,G0H32(1),0,ex5(:),16,G1H16(58),m3h2x16(:,286),heltab2x32(:,:,286))
  Gcoeff(:)%j = (c(24)*M(1,:)%j) * den(54)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(307),h0tab(:,307),[16,3,8,4],[nMW,nMW,nMW,nMW],4,1,wf4(:,36))
  call Hloop_VV_S(ntryL,G0H32(1),ex5(:),G0H16(46),m3h2x16(:,287),heltab2x32(:,:,287))
  Gcoeff(:)%j = (-(c(24)*M(1,:)%j)) * den(54)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(308),h0tab(:,308),[16,3,8,4],[nMW,nMW,nMW,nMW],4,1,wf4(:,36))
  call Hloop_VV_S(ntryL,G0H32(1),ex5(:),G0H16(47),m3h2x16(:,288),heltab2x32(:,:,288))
  Gcoeff(:)%j = (-(c(24)*M(1,:)%j)) * den(14)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(309),h0tab(:,309),[16,3,8,4],[nMW,nMW,nMW,nMW],4,1,wf4(:,37))
  call Hloop_VV_S(ntryL,G0H32(1),ex5(:),G0H16(48),m3h2x16(:,289),heltab2x32(:,:,289))
  Gcoeff(:)%j = (-(c(24)*M(1,:)%j)) * den(14)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(310),h0tab(:,310),[16,3,8,4],[nMW,nMW,nMW,nMW],4,1,wf4(:,37))
  call Hloop_VV_S(ntryL,G0H32(1),ex5(:),G0H16(49),m3h2x16(:,290),heltab2x32(:,:,290))
  Gcoeff(:)%j = (-(c(79)*M(1,:)%j)) * den(13)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(311),h0tab(:,311),[16,3,8,4],[nME,nME,nME,nME],4,1,wf4(:,13))
  call Hloop_QV_A(ntryL,G0H32(1),ex5(:),G0H16(50),m3h2x16(:,291),heltab2x32(:,:,291))
  call Hloop_Q_A(ntryL,G0H16(50),16,nME,G1H16(59),n2h16(91))
  Gcoeff(:)%j = (-(c(79)*M(1,:)%j)) * den(13)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(312),h0tab(:,312),[16,3,8,4],[nMM,nMM,nMM,nMM],4,1,wf4(:,13))
  call Hloop_QV_A(ntryL,G0H32(1),ex5(:),G0H16(51),m3h2x16(:,292),heltab2x32(:,:,292))
  call Hloop_Q_A(ntryL,G0H16(51),16,nMM,G1H16(60),n2h16(92))
  Gcoeff(:)%j = (-(c(79)*M(1,:)%j)) * den(13)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(313),h0tab(:,313),[16,3,8,4],[nML,nML,nML,nML],4,1,wf4(:,13))
  call Hloop_QV_A(ntryL,G0H32(1),ex5(:),G0H16(52),m3h2x16(:,293),heltab2x32(:,:,293))
  call Hloop_Q_A(ntryL,G0H16(52),16,nML,G1H16(61),n2h16(93))
  Gcoeff(:)%j = (-(c(79)*M(1,:)%j)) * den(13)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(314),h0tab(:,314),[16,3,8,4],[nME,nME,nME,nME],4,1,wf4(:,13))
  call Hloop_AV_Q(ntryL,G0H32(1),ex5(:),G0H16(53),m3h2x16(:,294),heltab2x32(:,:,294))
  call Hloop_A_Q(ntryL,G0H16(53),16,nME,G1H16(62),n2h16(94))
  Gcoeff(:)%j = (-(c(79)*M(1,:)%j)) * den(13)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(315),h0tab(:,315),[16,3,8,4],[nMM,nMM,nMM,nMM],4,1,wf4(:,13))
  call Hloop_AV_Q(ntryL,G0H32(1),ex5(:),G0H16(54),m3h2x16(:,295),heltab2x32(:,:,295))
  call Hloop_A_Q(ntryL,G0H16(54),16,nMM,G1H16(63),n2h16(95))
  Gcoeff(:)%j = (-(c(79)*M(1,:)%j)) * den(13)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(316),h0tab(:,316),[16,3,8,4],[nML,nML,nML,nML],4,1,wf4(:,13))
  call Hloop_AV_Q(ntryL,G0H32(1),ex5(:),G0H16(55),m3h2x16(:,296),heltab2x32(:,:,296))
  call Hloop_A_Q(ntryL,G0H16(55),16,nML,G1H16(64),n2h16(96))
  Gcoeff(:)%j = (-(c(75)*M(1,:)%j)) * den(13)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(317),h0tab(:,317),[16,3,8,4],[0,0,0,0],4,1,wf4(:,13))
  call Hloop_QV_A(ntryL,G0H32(1),ex5(:),G0H16(56),m3h2x16(:,297),heltab2x32(:,:,297))
  call Hloop_Q_A(ntryL,G0H16(56),16,0,G1H16(65),n2h16(97))
  Gcoeff(:)%j = (-(c(73)*M(1,:)%j)) * den(13)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(318),h0tab(:,318),[16,3,8,4],[nMT,nMT,nMT,nMT],4,1,wf4(:,13))
  call Hloop_QV_A(ntryL,G0H32(1),ex5(:),G0H16(57),m3h2x16(:,298),heltab2x32(:,:,298))
  call Hloop_Q_A(ntryL,G0H16(57),16,nMT,G1H16(66),n2h16(98))
  Gcoeff(:)%j = (-(c(75)*M(1,:)%j)) * den(13)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(319),h0tab(:,319),[16,3,8,4],[0,0,0,0],4,1,wf4(:,13))
  call Hloop_AV_Q(ntryL,G0H32(1),ex5(:),G0H16(58),m3h2x16(:,299),heltab2x32(:,:,299))
  call Hloop_A_Q(ntryL,G0H16(58),16,0,G1H16(67),n2h16(99))
  Gcoeff(:)%j = (-(c(73)*M(1,:)%j)) * den(13)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(320),h0tab(:,320),[16,3,8,4],[nMT,nMT,nMT,nMT],4,1,wf4(:,13))
  call Hloop_AV_Q(ntryL,G0H32(1),ex5(:),G0H16(59),m3h2x16(:,300),heltab2x32(:,:,300))
  call Hloop_A_Q(ntryL,G0H16(59),16,nMT,G1H16(68),n2h16(100))
  Gcoeff(:)%j = (-(c(69)*M(1,:)%j)) * den(13)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(321),h0tab(:,321),[16,3,8,4],[0,0,0,0],4,1,wf4(:,13))
  call Hloop_QV_A(ntryL,G0H32(1),ex5(:),G0H16(60),m3h2x16(:,301),heltab2x32(:,:,301))
  call Hloop_Q_A(ntryL,G0H16(60),16,0,G1H16(69),n2h16(101))
  Gcoeff(:)%j = (-(c(68)*M(1,:)%j)) * den(13)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(322),h0tab(:,322),[16,3,8,4],[nMB,nMB,nMB,nMB],4,1,wf4(:,13))
  call Hloop_QV_A(ntryL,G0H32(1),ex5(:),G0H16(61),m3h2x16(:,302),heltab2x32(:,:,302))
  call Hloop_Q_A(ntryL,G0H16(61),16,nMB,G1H16(70),n2h16(102))
  Gcoeff(:)%j = (-(c(69)*M(1,:)%j)) * den(13)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(323),h0tab(:,323),[16,3,8,4],[0,0,0,0],4,1,wf4(:,13))
  call Hloop_AV_Q(ntryL,G0H32(1),ex5(:),G0H16(62),m3h2x16(:,303),heltab2x32(:,:,303))
  call Hloop_A_Q(ntryL,G0H16(62),16,0,G1H16(71),n2h16(103))
  Gcoeff(:)%j = (-(c(68)*M(1,:)%j)) * den(13)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(324),h0tab(:,324),[16,3,8,4],[nMB,nMB,nMB,nMB],4,1,wf4(:,13))
  call Hloop_AV_Q(ntryL,G0H32(1),ex5(:),G0H16(63),m3h2x16(:,304),heltab2x32(:,:,304))
  call Hloop_A_Q(ntryL,G0H16(63),16,nMB,G1H16(72),n2h16(104))
  Gcoeff(:)%j = (c(80)*M(1,:)%j) * den(14)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(325),h0tab(:,325),[16,3,8,4],[nME,nME,nME,nME],4,1,wf4(:,14))
  call Hloop_QV_A(ntryL,G0H32(1),ex5(:),G0H16(64),m3h2x16(:,305),heltab2x32(:,:,305))
  call Hloop_Q_A(ntryL,G0H16(64),16,nME,G1H16(73),n2h16(105))
  Gcoeff(:)%j = (c(80)*M(1,:)%j) * den(14)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(326),h0tab(:,326),[16,3,8,4],[nMM,nMM,nMM,nMM],4,1,wf4(:,14))
  call Hloop_QV_A(ntryL,G0H32(1),ex5(:),G0H16(65),m3h2x16(:,306),heltab2x32(:,:,306))
  call Hloop_Q_A(ntryL,G0H16(65),16,nMM,G1H16(74),n2h16(106))
  Gcoeff(:)%j = (c(80)*M(1,:)%j) * den(14)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(327),h0tab(:,327),[16,3,8,4],[nML,nML,nML,nML],4,1,wf4(:,14))
  call Hloop_QV_A(ntryL,G0H32(1),ex5(:),G0H16(66),m3h2x16(:,307),heltab2x32(:,:,307))
  call Hloop_Q_A(ntryL,G0H16(66),16,nML,G1H16(75),n2h16(107))
  Gcoeff(:)%j = (c(80)*M(1,:)%j) * den(14)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(328),h0tab(:,328),[16,3,8,4],[nME,nME,nME,nME],4,1,wf4(:,14))
  call Hloop_AV_Q(ntryL,G0H32(1),ex5(:),G0H16(67),m3h2x16(:,308),heltab2x32(:,:,308))
  call Hloop_A_Q(ntryL,G0H16(67),16,nME,G1H16(76),n2h16(108))
  Gcoeff(:)%j = (c(80)*M(1,:)%j) * den(14)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(329),h0tab(:,329),[16,3,8,4],[nMM,nMM,nMM,nMM],4,1,wf4(:,14))
  call Hloop_AV_Q(ntryL,G0H32(1),ex5(:),G0H16(68),m3h2x16(:,309),heltab2x32(:,:,309))
  call Hloop_A_Q(ntryL,G0H16(68),16,nMM,G1H16(77),n2h16(109))
  Gcoeff(:)%j = (c(80)*M(1,:)%j) * den(14)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(330),h0tab(:,330),[16,3,8,4],[nML,nML,nML,nML],4,1,wf4(:,14))
  call Hloop_AV_Q(ntryL,G0H32(1),ex5(:),G0H16(4),m3h2x16(:,310),heltab2x32(:,:,310))
  call Hloop_A_Q(ntryL,G0H16(4),16,nML,G1H16(78),n2h16(110))
  Gcoeff(:)%j = (-(c(78)*M(1,:)%j)) * den(14)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(331),h0tab(:,331),[16,3,8,4],[0,0,0,0],4,1,wf4(:,14))
  call Hloop_QV_A(ntryL,G0H32(1),ex5(:),G0H16(5),m3h2x16(:,311),heltab2x32(:,:,311))
  call Hloop_Q_A(ntryL,G0H16(5),16,0,G1H16(79),n2h16(111))
  Gcoeff(:)%j = (-(c(76)*M(1,:)%j)) * den(14)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(332),h0tab(:,332),[16,3,8,4],[nMT,nMT,nMT,nMT],4,1,wf4(:,14))
  call Hloop_QV_A(ntryL,G0H32(1),ex5(:),G0H16(6),m3h2x16(:,312),heltab2x32(:,:,312))
  call Hloop_Q_A(ntryL,G0H16(6),16,nMT,G1H16(80),n2h16(112))
  Gcoeff(:)%j = (-(c(78)*M(1,:)%j)) * den(14)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(333),h0tab(:,333),[16,3,8,4],[0,0,0,0],4,1,wf4(:,14))
  call Hloop_AV_Q(ntryL,G0H32(1),ex5(:),G0H16(7),m3h2x16(:,313),heltab2x32(:,:,313))
  call Hloop_A_Q(ntryL,G0H16(7),16,0,G1H16(81),n2h16(113))
  Gcoeff(:)%j = (-(c(76)*M(1,:)%j)) * den(14)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(334),h0tab(:,334),[16,3,8,4],[nMT,nMT,nMT,nMT],4,1,wf4(:,14))
  call Hloop_AV_Q(ntryL,G0H32(1),ex5(:),G0H16(8),m3h2x16(:,314),heltab2x32(:,:,314))
  call Hloop_A_Q(ntryL,G0H16(8),16,nMT,G1H16(82),n2h16(114))
  Gcoeff(:)%j = (c(72)*M(1,:)%j) * den(14)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(335),h0tab(:,335),[16,3,8,4],[0,0,0,0],4,1,wf4(:,14))
  call Hloop_QV_A(ntryL,G0H32(1),ex5(:),G0H16(9),m3h2x16(:,315),heltab2x32(:,:,315))
  call Hloop_Q_A(ntryL,G0H16(9),16,0,G1H16(83),n2h16(115))
  Gcoeff(:)%j = (c(71)*M(1,:)%j) * den(14)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(336),h0tab(:,336),[16,3,8,4],[nMB,nMB,nMB,nMB],4,1,wf4(:,14))
  call Hloop_QV_A(ntryL,G0H32(1),ex5(:),G0H16(10),m3h2x16(:,316),heltab2x32(:,:,316))
  call Hloop_Q_A(ntryL,G0H16(10),16,nMB,G1H16(84),n2h16(116))
  Gcoeff(:)%j = (c(72)*M(1,:)%j) * den(14)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(337),h0tab(:,337),[16,3,8,4],[0,0,0,0],4,1,wf4(:,14))
  call Hloop_AV_Q(ntryL,G0H32(1),ex5(:),G0H16(11),m3h2x16(:,317),heltab2x32(:,:,317))
  call Hloop_A_Q(ntryL,G0H16(11),16,0,G1H16(85),n2h16(117))
  Gcoeff(:)%j = (c(71)*M(1,:)%j) * den(14)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(338),h0tab(:,338),[16,3,8,4],[nMB,nMB,nMB,nMB],4,1,wf4(:,14))
  call Hloop_AV_Q(ntryL,G0H32(1),ex5(:),G0H16(12),m3h2x16(:,318),heltab2x32(:,:,318))
  call Hloop_A_Q(ntryL,G0H16(12),16,nMB,G1H16(86),n2h16(118))
  Gcoeff(:)%j = (c(4)*M(1,:)%j) * den(13)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(339),h0tab(:,339),[16,3,8,4],[nMW,nMW,nMW,nMW],4,1,wf4(:,13))
  call Hloop_TV_S(ntryL,G0H32(1),0,ex5(:),16,G1H16(87),m3h2x16(:,319),heltab2x32(:,:,319))
  Gcoeff(:)%j = (c(4)*M(1,:)%j) * den(13)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(340),h0tab(:,340),[16,3,8,4],[nMW,nMW,nMW,nMW],4,1,wf4(:,13))
  call Hloop_SV_T(ntryL,G0H32(1),0,ex5(:),16,G1H16(88),m3h2x16(:,320),heltab2x32(:,:,320))
  Gcoeff(:)%j = (-(c(61)*M(1,:)%j)) * den(14)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(341),h0tab(:,341),[16,3,8,4],[nMW,nMW,nMW,nMW],4,1,wf4(:,14))
  call Hloop_TV_S(ntryL,G0H32(1),0,ex5(:),16,G1H16(89),m3h2x16(:,321),heltab2x32(:,:,321))
  Gcoeff(:)%j = (-(c(61)*M(1,:)%j)) * den(14)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(342),h0tab(:,342),[16,3,8,4],[nMW,nMW,nMW,nMW],4,1,wf4(:,14))
  call Hloop_SV_T(ntryL,G0H32(1),0,ex5(:),16,G1H16(90),m3h2x16(:,322),heltab2x32(:,:,322))
  Gcoeff(:)%j = (-(c(4)*M(1,:)%j)) * den(13)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(343),h0tab(:,343),[16,3,8,4],[nMW,nMW,nMW,nMW],4,1,wf4(:,13))
  call Hloop_CV_D(ntryL,G0H32(1),0,ex5(:),16,G1H16(91),m3h2x16(:,323),heltab2x32(:,:,323))
  Gcoeff(:)%j = (-(c(4)*M(1,:)%j)) * den(13)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(344),h0tab(:,344),[16,3,8,4],[nMW,nMW,nMW,nMW],4,1,wf4(:,13))
  call Hloop_DV_C(ntryL,G0H32(1),0,ex5(:),G1H16(92),m3h2x16(:,324),heltab2x32(:,:,324))
  Gcoeff(:)%j = (-(c(4)*M(1,:)%j)) * den(13)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(345),h0tab(:,345),[16,3,8,4],[nMW,nMW,nMW,nMW],4,1,wf4(:,13))
  call Hloop_CV_D(ntryL,G0H32(1),0,ex5(:),16,G1H16(93),m3h2x16(:,325),heltab2x32(:,:,325))
  Gcoeff(:)%j = (-(c(4)*M(1,:)%j)) * den(13)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(346),h0tab(:,346),[16,3,8,4],[nMW,nMW,nMW,nMW],4,1,wf4(:,13))
  call Hloop_DV_C(ntryL,G0H32(1),0,ex5(:),G1H16(94),m3h2x16(:,326),heltab2x32(:,:,326))
  Gcoeff(:)%j = (-(c(53)*M(1,:)%j)) * den(14)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(347),h0tab(:,347),[16,3,8,4],[nMW,nMW,nMW,nMW],4,1,wf4(:,14))
  call Hloop_CV_D(ntryL,G0H32(1),0,ex5(:),16,G1H16(95),m3h2x16(:,327),heltab2x32(:,:,327))
  Gcoeff(:)%j = (-(c(53)*M(1,:)%j)) * den(14)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(348),h0tab(:,348),[16,3,8,4],[nMW,nMW,nMW,nMW],4,1,wf4(:,14))
  call Hloop_DV_C(ntryL,G0H32(1),0,ex5(:),G1H16(96),m3h2x16(:,328),heltab2x32(:,:,328))
  Gcoeff(:)%j = (-(c(53)*M(1,:)%j)) * den(14)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(349),h0tab(:,349),[16,3,8,4],[nMW,nMW,nMW,nMW],4,1,wf4(:,14))
  call Hloop_CV_D(ntryL,G0H32(1),0,ex5(:),16,G1H16(97),m3h2x16(:,329),heltab2x32(:,:,329))
  Gcoeff(:)%j = (-(c(53)*M(1,:)%j)) * den(14)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(350),h0tab(:,350),[16,3,8,4],[nMW,nMW,nMW,nMW],4,1,wf4(:,14))
  call Hloop_DV_C(ntryL,G0H32(1),0,ex5(:),G1H16(98),m3h2x16(:,330),heltab2x32(:,:,330))
  Gcoeff(:)%j = (c(4)*M(1,:)%j) * den(13)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(351),h0tab(:,351),[16,3,8,4],[nMW,nMW,nMW,nMW],4,1,wf4(:,13))
  call Hloop_UV_W(ntryL,G0H32(1),0,ex5(:),16,G1H16(99),m3h2x16(:,331),heltab2x32(:,:,331))
  Gcoeff(:)%j = (c(4)*M(1,:)%j) * den(13)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(352),h0tab(:,352),[16,3,8,4],[nMW,nMW,nMW,nMW],4,1,wf4(:,13))
  call Hloop_UW_V(ntryL,G0H32(1),0,ex5(:),16,G1H16(100),m3h2x16(:,332),heltab2x32(:,:,332))
  Gcoeff(:)%j = (c(53)*M(1,:)%j) * den(14)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(353),h0tab(:,353),[16,3,8,4],[nMW,nMW,nMW,nMW],4,1,wf4(:,14))
  call Hloop_UV_W(ntryL,G0H32(1),0,ex5(:),16,G1H16(101),m3h2x16(:,333),heltab2x32(:,:,333))
  Gcoeff(:)%j = (c(53)*M(1,:)%j) * den(14)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(354),h0tab(:,354),[16,3,8,4],[nMW,nMW,nMW,nMW],4,1,wf4(:,14))
  call Hloop_UW_V(ntryL,G0H32(1),0,ex5(:),16,G1H16(102),m3h2x16(:,334),heltab2x32(:,:,334))
  Gcoeff(:)%j = (-(c(9)*M(1,:)%j)) * den(13)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(355),h0tab(:,355),[16,3,8,4],[nMW,nMW,nMW,nMW],4,1,wf4(:,13))
  call Hloop_SV_V(ntryL,G0H32(1),ex5(:),G0H16(13),m3h2x16(:,335),heltab2x32(:,:,335))
  Gcoeff(:)%j = (-(c(9)*M(1,:)%j)) * den(13)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(356),h0tab(:,356),[16,3,8,4],[nMW,nMW,nMW,nMW],4,1,wf4(:,13))
  call Hloop_SV_V(ntryL,G0H32(1),ex5(:),G0H16(14),m3h2x16(:,336),heltab2x32(:,:,336))
  Gcoeff(:)%j = (c(57)*M(1,:)%j) * den(14)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(357),h0tab(:,357),[16,3,8,4],[nMW,nMW,nMW,nMW],4,1,wf4(:,14))
  call Hloop_SV_V(ntryL,G0H32(1),ex5(:),G0H16(15),m3h2x16(:,337),heltab2x32(:,:,337))
  Gcoeff(:)%j = (c(57)*M(1,:)%j) * den(14)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(358),h0tab(:,358),[16,3,8,4],[nMW,nMW,nMW,nMW],4,1,wf4(:,14))
  call Hloop_SV_V(ntryL,G0H32(1),ex5(:),G0H16(16),m3h2x16(:,338),heltab2x32(:,:,338))
  Gcoeff(:)%j = (-(c(9)*M(1,:)%j)) * den(13)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(359),h0tab(:,359),[16,3,8,4],[nMW,nMW,nMW,nMW],4,1,wf4(:,13))
  call Hloop_TV_S(ntryL,G0H32(1),0,ex5(:),16,G1H16(103),m3h2x16(:,339),heltab2x32(:,:,339))
  Gcoeff(:)%j = (-(c(9)*M(1,:)%j)) * den(13)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(360),h0tab(:,360),[16,3,8,4],[nMW,nMW,nMW,nMW],4,1,wf4(:,13))
  call Hloop_SV_T(ntryL,G0H32(1),0,ex5(:),16,G1H16(104),m3h2x16(:,340),heltab2x32(:,:,340))
  Gcoeff(:)%j = (c(57)*M(1,:)%j) * den(14)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(361),h0tab(:,361),[16,3,8,4],[nMW,nMW,nMW,nMW],4,1,wf4(:,14))
  call Hloop_TV_S(ntryL,G0H32(1),0,ex5(:),16,G1H16(105),m3h2x16(:,341),heltab2x32(:,:,341))
  Gcoeff(:)%j = (c(57)*M(1,:)%j) * den(14)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(362),h0tab(:,362),[16,3,8,4],[nMW,nMW,nMW,nMW],4,1,wf4(:,14))
  call Hloop_SV_T(ntryL,G0H32(1),0,ex5(:),16,G1H16(106),m3h2x16(:,342),heltab2x32(:,:,342))
  Gcoeff(:)%j = (-(c(9)*M(1,:)%j)) * den(13)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(363),h0tab(:,363),[16,3,8,4],[nMW,nMW,nMW,nMW],4,1,wf4(:,13))
  call Hloop_VV_S(ntryL,G0H32(1),ex5(:),G0H16(17),m3h2x16(:,343),heltab2x32(:,:,343))
  Gcoeff(:)%j = (-(c(9)*M(1,:)%j)) * den(13)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(364),h0tab(:,364),[16,3,8,4],[nMW,nMW,nMW,nMW],4,1,wf4(:,13))
  call Hloop_VV_S(ntryL,G0H32(1),ex5(:),G0H16(18),m3h2x16(:,344),heltab2x32(:,:,344))
  Gcoeff(:)%j = (c(66)*M(1,:)%j) * den(14)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(365),h0tab(:,365),[16,3,8,4],[nMW,nMW,nMW,nMW],4,1,wf4(:,14))
  call Hloop_VV_S(ntryL,G0H32(1),ex5(:),G0H16(19),m3h2x16(:,345),heltab2x32(:,:,345))
  Gcoeff(:)%j = (c(66)*M(1,:)%j) * den(14)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(366),h0tab(:,366),[16,3,8,4],[nMW,nMW,nMW,nMW],4,1,wf4(:,14))
  call Hloop_VV_S(ntryL,G0H32(1),ex5(:),G0H16(20),m3h2x16(:,346),heltab2x32(:,:,346))
  Gcoeff(:)%j = (-(c(9)*M(1,:)%j)) * den(13)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(367),h0tab(:,367),[16,3,8,4],[nMW,nMW,nMW,nMW],4,1,wf4(:,13))
  call Hloop_TV_S(ntryL,G0H32(1),0,ex5(:),16,G1H16(107),m3h2x16(:,347),heltab2x32(:,:,347))
  Gcoeff(:)%j = (-(c(9)*M(1,:)%j)) * den(13)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(368),h0tab(:,368),[16,3,8,4],[nMW,nMW,nMW,nMW],4,1,wf4(:,13))
  call Hloop_SV_T(ntryL,G0H32(1),0,ex5(:),16,G1H16(108),m3h2x16(:,348),heltab2x32(:,:,348))
  Gcoeff(:)%j = (c(66)*M(1,:)%j) * den(14)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(369),h0tab(:,369),[16,3,8,4],[nMW,nMW,nMW,nMW],4,1,wf4(:,14))
  call Hloop_TV_S(ntryL,G0H32(1),0,ex5(:),16,G1H16(109),m3h2x16(:,349),heltab2x32(:,:,349))
  Gcoeff(:)%j = (c(66)*M(1,:)%j) * den(14)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(370),h0tab(:,370),[16,3,8,4],[nMW,nMW,nMW,nMW],4,1,wf4(:,14))
  call Hloop_SV_T(ntryL,G0H32(1),0,ex5(:),16,G1H16(110),m3h2x16(:,350),heltab2x32(:,:,350))
  Gcoeff(:)%j = (-(c(9)*M(1,:)%j)) * den(13)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(371),h0tab(:,371),[16,3,8,4],[nMW,nMW,nMW,nMW],4,1,wf4(:,13))
  call Hloop_SV_V(ntryL,G0H32(1),ex5(:),G0H16(21),m3h2x16(:,351),heltab2x32(:,:,351))
  Gcoeff(:)%j = (-(c(9)*M(1,:)%j)) * den(13)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(372),h0tab(:,372),[16,3,8,4],[nMW,nMW,nMW,nMW],4,1,wf4(:,13))
  call Hloop_SV_V(ntryL,G0H32(1),ex5(:),G0H16(22),m3h2x16(:,352),heltab2x32(:,:,352))
  Gcoeff(:)%j = (-(c(55)*M(1,:)%j)) * den(14)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(373),h0tab(:,373),[16,3,8,4],[nMW,nMW,nMW,nMW],4,1,wf4(:,14))
  call Hloop_SV_V(ntryL,G0H32(1),ex5(:),G0H16(23),m3h2x16(:,353),heltab2x32(:,:,353))
  Gcoeff(:)%j = (-(c(55)*M(1,:)%j)) * den(14)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(374),h0tab(:,374),[16,3,8,4],[nMW,nMW,nMW,nMW],4,1,wf4(:,14))
  call Hloop_SV_V(ntryL,G0H32(1),ex5(:),G0H16(24),m3h2x16(:,354),heltab2x32(:,:,354))
  Gcoeff(:)%j = (-(c(9)*M(1,:)%j)) * den(13)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(375),h0tab(:,375),[16,3,8,4],[nMW,nMW,nMW,nMW],4,1,wf4(:,13))
  call Hloop_UV_W(ntryL,G0H32(1),0,ex5(:),16,G1H16(111),m3h2x16(:,355),heltab2x32(:,:,355))
  Gcoeff(:)%j = (-(c(9)*M(1,:)%j)) * den(13)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(376),h0tab(:,376),[16,3,8,4],[nMW,nMW,nMW,nMW],4,1,wf4(:,13))
  call Hloop_UW_V(ntryL,G0H32(1),0,ex5(:),16,G1H16(112),m3h2x16(:,356),heltab2x32(:,:,356))
  Gcoeff(:)%j = (c(57)*M(1,:)%j) * den(14)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(377),h0tab(:,377),[16,3,8,4],[nMW,nMW,nMW,nMW],4,1,wf4(:,14))
  call Hloop_UV_W(ntryL,G0H32(1),0,ex5(:),16,G1H16(113),m3h2x16(:,357),heltab2x32(:,:,357))
  Gcoeff(:)%j = (c(57)*M(1,:)%j) * den(14)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(378),h0tab(:,378),[16,3,8,4],[nMW,nMW,nMW,nMW],4,1,wf4(:,14))
  call Hloop_UW_V(ntryL,G0H32(1),0,ex5(:),16,G1H16(114),m3h2x16(:,358),heltab2x32(:,:,358))
  Gcoeff(:)%j = (c(11)*M(1,:)%j) * den(13)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(379),h0tab(:,379),[16,3,8,4],[nMW,nMW,nMW,nMW],4,1,wf4(:,13))
  call Hloop_VV_S(ntryL,G0H32(1),ex5(:),G0H16(25),m3h2x16(:,359),heltab2x32(:,:,359))
  Gcoeff(:)%j = (c(11)*M(1,:)%j) * den(13)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(380),h0tab(:,380),[16,3,8,4],[nMW,nMW,nMW,nMW],4,1,wf4(:,13))
  call Hloop_VV_S(ntryL,G0H32(1),ex5(:),G0H16(50),m3h2x16(:,360),heltab2x32(:,:,360))
  Gcoeff(:)%j = (-(c(59)*M(1,:)%j)) * den(14)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(381),h0tab(:,381),[16,3,8,4],[nMW,nMW,nMW,nMW],4,1,wf4(:,14))
  call Hloop_VV_S(ntryL,G0H32(1),ex5(:),G0H16(51),m3h2x16(:,361),heltab2x32(:,:,361))
  Gcoeff(:)%j = (-(c(59)*M(1,:)%j)) * den(14)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(382),h0tab(:,382),[16,3,8,4],[nMW,nMW,nMW,nMW],4,1,wf4(:,14))
  call Hloop_VV_S(ntryL,G0H32(1),ex5(:),G0H16(52),m3h2x16(:,362),heltab2x32(:,:,362))
  Gcoeff(:)%j = (c(11)*M(1,:)%j) * den(13)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(383),h0tab(:,383),[16,3,8,4],[nMW,nMW,nMW,nMW],4,1,wf4(:,13))
  call Hloop_SV_V(ntryL,G0H32(1),ex5(:),G0H16(53),m3h2x16(:,363),heltab2x32(:,:,363))
  Gcoeff(:)%j = (c(11)*M(1,:)%j) * den(13)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(384),h0tab(:,384),[16,3,8,4],[nMW,nMW,nMW,nMW],4,1,wf4(:,13))
  call Hloop_SV_V(ntryL,G0H32(1),ex5(:),G0H16(54),m3h2x16(:,364),heltab2x32(:,:,364))
  Gcoeff(:)%j = (-(c(59)*M(1,:)%j)) * den(14)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(385),h0tab(:,385),[16,3,8,4],[nMW,nMW,nMW,nMW],4,1,wf4(:,14))
  call Hloop_SV_V(ntryL,G0H32(1),ex5(:),G0H16(55),m3h2x16(:,365),heltab2x32(:,:,365))
  Gcoeff(:)%j = (-(c(59)*M(1,:)%j)) * den(14)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(386),h0tab(:,386),[16,3,8,4],[nMW,nMW,nMW,nMW],4,1,wf4(:,14))
  call Hloop_SV_V(ntryL,G0H32(1),ex5(:),G0H16(56),m3h2x16(:,366),heltab2x32(:,:,366))
  Gcoeff(:)%j = (-(c(9)*M(1,:)%j)) * den(13)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(387),h0tab(:,387),[16,3,8,4],[nMW,nMW,nMW,nMW],4,1,wf4(:,13))
  call Hloop_TV_S(ntryL,G0H32(1),0,ex5(:),16,G1H16(115),m3h2x16(:,367),heltab2x32(:,:,367))
  Gcoeff(:)%j = (-(c(9)*M(1,:)%j)) * den(13)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(388),h0tab(:,388),[16,3,8,4],[nMW,nMW,nMW,nMW],4,1,wf4(:,13))
  call Hloop_SV_T(ntryL,G0H32(1),0,ex5(:),16,G1H16(116),m3h2x16(:,368),heltab2x32(:,:,368))
  Gcoeff(:)%j = (c(57)*M(1,:)%j) * den(14)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(389),h0tab(:,389),[16,3,8,4],[nMW,nMW,nMW,nMW],4,1,wf4(:,14))
  call Hloop_TV_S(ntryL,G0H32(1),0,ex5(:),16,G1H16(117),m3h2x16(:,369),heltab2x32(:,:,369))
  Gcoeff(:)%j = (c(57)*M(1,:)%j) * den(14)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(390),h0tab(:,390),[16,3,8,4],[nMW,nMW,nMW,nMW],4,1,wf4(:,14))
  call Hloop_SV_T(ntryL,G0H32(1),0,ex5(:),16,G1H16(118),m3h2x16(:,370),heltab2x32(:,:,370))
  Gcoeff(:)%j = (-(c(9)*M(1,:)%j)) * den(13)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(391),h0tab(:,391),[16,3,8,4],[nMW,nMW,nMW,nMW],4,1,wf4(:,13))
  call Hloop_VV_S(ntryL,G0H32(1),ex5(:),G0H16(57),m3h2x16(:,371),heltab2x32(:,:,371))
  Gcoeff(:)%j = (-(c(9)*M(1,:)%j)) * den(13)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(392),h0tab(:,392),[16,3,8,4],[nMW,nMW,nMW,nMW],4,1,wf4(:,13))
  call Hloop_VV_S(ntryL,G0H32(1),ex5(:),G0H16(58),m3h2x16(:,372),heltab2x32(:,:,372))
  Gcoeff(:)%j = (c(66)*M(1,:)%j) * den(14)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(393),h0tab(:,393),[16,3,8,4],[nMW,nMW,nMW,nMW],4,1,wf4(:,14))
  call Hloop_VV_S(ntryL,G0H32(1),ex5(:),G0H16(59),m3h2x16(:,373),heltab2x32(:,:,373))
  Gcoeff(:)%j = (c(66)*M(1,:)%j) * den(14)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(394),h0tab(:,394),[16,3,8,4],[nMW,nMW,nMW,nMW],4,1,wf4(:,14))
  call Hloop_VV_S(ntryL,G0H32(1),ex5(:),G0H16(60),m3h2x16(:,374),heltab2x32(:,:,374))
  Gcoeff(:)%j = (-(c(9)*M(1,:)%j)) * den(13)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(395),h0tab(:,395),[16,3,8,4],[nMW,nMW,nMW,nMW],4,1,wf4(:,13))
  call Hloop_UV_W(ntryL,G0H32(1),0,ex5(:),16,G1H16(119),m3h2x16(:,375),heltab2x32(:,:,375))
  Gcoeff(:)%j = (-(c(9)*M(1,:)%j)) * den(13)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(396),h0tab(:,396),[16,3,8,4],[nMW,nMW,nMW,nMW],4,1,wf4(:,13))
  call Hloop_UW_V(ntryL,G0H32(1),0,ex5(:),16,G1H16(120),m3h2x16(:,376),heltab2x32(:,:,376))
  Gcoeff(:)%j = (-(c(55)*M(1,:)%j)) * den(14)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(397),h0tab(:,397),[16,3,8,4],[nMW,nMW,nMW,nMW],4,1,wf4(:,14))
  call Hloop_UV_W(ntryL,G0H32(1),0,ex5(:),16,G1H16(121),m3h2x16(:,377),heltab2x32(:,:,377))
  Gcoeff(:)%j = (-(c(55)*M(1,:)%j)) * den(14)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(398),h0tab(:,398),[16,3,8,4],[nMW,nMW,nMW,nMW],4,1,wf4(:,14))
  call Hloop_UW_V(ntryL,G0H32(1),0,ex5(:),16,G1H16(122),m3h2x16(:,378),heltab2x32(:,:,378))
  Gcoeff(:)%j = (-(c(9)*M(1,:)%j)) * den(13)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(399),h0tab(:,399),[16,3,8,4],[nMW,nMW,nMW,nMW],4,1,wf4(:,13))
  call Hloop_SV_V(ntryL,G0H32(1),ex5(:),G0H16(61),m3h2x16(:,379),heltab2x32(:,:,379))
  Gcoeff(:)%j = (-(c(9)*M(1,:)%j)) * den(13)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(400),h0tab(:,400),[16,3,8,4],[nMW,nMW,nMW,nMW],4,1,wf4(:,13))
  call Hloop_SV_V(ntryL,G0H32(1),ex5(:),G0H16(62),m3h2x16(:,380),heltab2x32(:,:,380))
  Gcoeff(:)%j = (-(c(55)*M(1,:)%j)) * den(14)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(401),h0tab(:,401),[16,3,8,4],[nMW,nMW,nMW,nMW],4,1,wf4(:,14))
  call Hloop_SV_V(ntryL,G0H32(1),ex5(:),G0H16(63),m3h2x16(:,381),heltab2x32(:,:,381))
  Gcoeff(:)%j = (-(c(55)*M(1,:)%j)) * den(14)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(402),h0tab(:,402),[16,3,8,4],[nMW,nMW,nMW,nMW],4,1,wf4(:,14))
  call Hloop_SV_V(ntryL,G0H32(1),ex5(:),G0H16(64),m3h2x16(:,382),heltab2x32(:,:,382))
  Gcoeff(:)%j = (-(c(9)*M(1,:)%j)) * den(13)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(403),h0tab(:,403),[16,3,8,4],[nMW,nMW,nMW,nMW],4,1,wf4(:,13))
  call Hloop_UV_W(ntryL,G0H32(1),0,ex5(:),16,G1H16(123),m3h2x16(:,383),heltab2x32(:,:,383))
  Gcoeff(:)%j = (-(c(9)*M(1,:)%j)) * den(13)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(404),h0tab(:,404),[16,3,8,4],[nMW,nMW,nMW,nMW],4,1,wf4(:,13))
  call Hloop_UW_V(ntryL,G0H32(1),0,ex5(:),16,G1H16(124),m3h2x16(:,384),heltab2x32(:,:,384))
  Gcoeff(:)%j = (c(57)*M(1,:)%j) * den(14)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(405),h0tab(:,405),[16,3,8,4],[nMW,nMW,nMW,nMW],4,1,wf4(:,14))
  call Hloop_UV_W(ntryL,G0H32(1),0,ex5(:),16,G1H16(125),m3h2x16(:,385),heltab2x32(:,:,385))
  Gcoeff(:)%j = (c(57)*M(1,:)%j) * den(14)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(406),h0tab(:,406),[16,3,8,4],[nMW,nMW,nMW,nMW],4,1,wf4(:,14))
  call Hloop_UW_V(ntryL,G0H32(1),0,ex5(:),16,G1H16(126),m3h2x16(:,386),heltab2x32(:,:,386))
  Gcoeff(:)%j = (-(c(9)*M(1,:)%j)) * den(13)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(407),h0tab(:,407),[16,3,8,4],[nMW,nMW,nMW,nMW],4,1,wf4(:,13))
  call Hloop_VV_S(ntryL,G0H32(1),ex5(:),G0H16(65),m3h2x16(:,387),heltab2x32(:,:,387))
  Gcoeff(:)%j = (-(c(9)*M(1,:)%j)) * den(13)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(408),h0tab(:,408),[16,3,8,4],[nMW,nMW,nMW,nMW],4,1,wf4(:,13))
  call Hloop_VV_S(ntryL,G0H32(1),ex5(:),G0H16(66),m3h2x16(:,388),heltab2x32(:,:,388))
  Gcoeff(:)%j = (c(57)*M(1,:)%j) * den(14)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(409),h0tab(:,409),[16,3,8,4],[nMW,nMW,nMW,nMW],4,1,wf4(:,14))
  call Hloop_VV_S(ntryL,G0H32(1),ex5(:),G0H16(67),m3h2x16(:,389),heltab2x32(:,:,389))
  Gcoeff(:)%j = (c(57)*M(1,:)%j) * den(14)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(410),h0tab(:,410),[16,3,8,4],[nMW,nMW,nMW,nMW],4,1,wf4(:,14))
  call Hloop_VV_S(ntryL,G0H32(1),ex5(:),G0H16(68),m3h2x16(:,390),heltab2x32(:,:,390))
  Gcoeff(:)%j = (-(c(84)*M(1,:)%j)) * den(54)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(411),h0tab(:,411),[16,3,4,8],[nME,nME,nME,nME],4,1,wf4(:,36))
  call Hloop_AV_Q(ntryL,G0H32(1),ex5(:),G0H16(4),m3h2x16(:,391),heltab2x32(:,:,391))
  call Hloop_A_Q(ntryL,G0H16(4),16,nME,G1H16(127),n2h16(119))
  Gcoeff(:)%j = (-(c(88)*M(1,:)%j)) * den(54)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(412),h0tab(:,412),[16,3,4,8],[nMM,nMM,nMM,nMM],4,1,wf4(:,36))
  call Hloop_AV_Q(ntryL,G0H32(1),ex5(:),G0H16(5),m3h2x16(:,392),heltab2x32(:,:,392))
  call Hloop_A_Q(ntryL,G0H16(5),16,nMM,G1H16(128),n2h16(120))
  Gcoeff(:)%j = (-(c(86)*M(1,:)%j)) * den(54)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(413),h0tab(:,413),[16,3,4,8],[nML,nML,nML,nML],4,1,wf4(:,36))
  call Hloop_AV_Q(ntryL,G0H32(1),ex5(:),G0H16(6),m3h2x16(:,393),heltab2x32(:,:,393))
  call Hloop_A_Q(ntryL,G0H16(6),16,nML,G1H16(129),n2h16(121))
  Gcoeff(:)%j = (-(c(84)*M(1,:)%j)) * den(54)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(414),h0tab(:,414),[16,3,4,8],[nME,nME,nME,nME],4,1,wf4(:,36))
  call Hloop_QV_A(ntryL,G0H32(1),ex5(:),G0H16(7),m3h2x16(:,394),heltab2x32(:,:,394))
  call Hloop_Q_A(ntryL,G0H16(7),16,nME,G1H16(130),n2h16(122))
  Gcoeff(:)%j = (-(c(88)*M(1,:)%j)) * den(54)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(415),h0tab(:,415),[16,3,4,8],[nMM,nMM,nMM,nMM],4,1,wf4(:,36))
  call Hloop_QV_A(ntryL,G0H32(1),ex5(:),G0H16(8),m3h2x16(:,395),heltab2x32(:,:,395))
  call Hloop_Q_A(ntryL,G0H16(8),16,nMM,G1H16(131),n2h16(123))
  Gcoeff(:)%j = (-(c(86)*M(1,:)%j)) * den(54)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(416),h0tab(:,416),[16,3,4,8],[nML,nML,nML,nML],4,1,wf4(:,36))
  call Hloop_QV_A(ntryL,G0H32(1),ex5(:),G0H16(9),m3h2x16(:,396),heltab2x32(:,:,396))
  call Hloop_Q_A(ntryL,G0H16(9),16,nML,G1H16(132),n2h16(124))
  Gcoeff(:)%j = (c(89)*M(1,:)%j) * den(54)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(417),h0tab(:,417),[16,3,4,8],[nMT,nMT,nMT,nMT],4,1,wf4(:,36))
  call Hloop_AV_Q(ntryL,G0H32(1),ex5(:),G0H16(10),m3h2x16(:,397),heltab2x32(:,:,397))
  call Hloop_A_Q(ntryL,G0H16(10),16,nMT,G1H16(133),n2h16(125))
  Gcoeff(:)%j = (c(89)*M(1,:)%j) * den(54)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(418),h0tab(:,418),[16,3,4,8],[nMT,nMT,nMT,nMT],4,1,wf4(:,36))
  call Hloop_QV_A(ntryL,G0H32(1),ex5(:),G0H16(11),m3h2x16(:,398),heltab2x32(:,:,398))
  call Hloop_Q_A(ntryL,G0H16(11),16,nMT,G1H16(134),n2h16(126))
  Gcoeff(:)%j = (-(c(81)*M(1,:)%j)) * den(54)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(419),h0tab(:,419),[16,3,4,8],[nMB,nMB,nMB,nMB],4,1,wf4(:,36))
  call Hloop_AV_Q(ntryL,G0H32(1),ex5(:),G0H16(12),m3h2x16(:,399),heltab2x32(:,:,399))
  call Hloop_A_Q(ntryL,G0H16(12),16,nMB,G1H16(135),n2h16(127))
  Gcoeff(:)%j = (-(c(81)*M(1,:)%j)) * den(54)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(420),h0tab(:,420),[16,3,4,8],[nMB,nMB,nMB,nMB],4,1,wf4(:,36))
  call Hloop_QV_A(ntryL,G0H32(1),ex5(:),G0H16(4),m3h2x16(:,400),heltab2x32(:,:,400))
  call Hloop_Q_A(ntryL,G0H16(4),16,nMB,G1H16(136),n2h16(128))
  Gcoeff(:)%j = (-(c(84)*M(1,:)%j)) * den(14)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(421),h0tab(:,421),[16,3,4,8],[nME,nME,nME,nME],4,1,wf4(:,37))
  call Hloop_AV_Q(ntryL,G0H32(1),ex5(:),G0H16(5),m3h2x16(:,401),heltab2x32(:,:,401))
  call Hloop_A_Q(ntryL,G0H16(5),16,nME,G1H16(137),n2h16(129))
  Gcoeff(:)%j = (-(c(88)*M(1,:)%j)) * den(14)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(422),h0tab(:,422),[16,3,4,8],[nMM,nMM,nMM,nMM],4,1,wf4(:,37))
  call Hloop_AV_Q(ntryL,G0H32(1),ex5(:),G0H16(6),m3h2x16(:,402),heltab2x32(:,:,402))
  call Hloop_A_Q(ntryL,G0H16(6),16,nMM,G1H16(138),n2h16(130))
  Gcoeff(:)%j = (-(c(86)*M(1,:)%j)) * den(14)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(423),h0tab(:,423),[16,3,4,8],[nML,nML,nML,nML],4,1,wf4(:,37))
  call Hloop_AV_Q(ntryL,G0H32(1),ex5(:),G0H16(7),m3h2x16(:,403),heltab2x32(:,:,403))
  call Hloop_A_Q(ntryL,G0H16(7),16,nML,G1H16(139),n2h16(131))
  Gcoeff(:)%j = (-(c(84)*M(1,:)%j)) * den(14)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(424),h0tab(:,424),[16,3,4,8],[nME,nME,nME,nME],4,1,wf4(:,37))
  call Hloop_QV_A(ntryL,G0H32(1),ex5(:),G0H16(8),m3h2x16(:,404),heltab2x32(:,:,404))
  call Hloop_Q_A(ntryL,G0H16(8),16,nME,G1H16(140),n2h16(132))
  Gcoeff(:)%j = (-(c(88)*M(1,:)%j)) * den(14)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(425),h0tab(:,425),[16,3,4,8],[nMM,nMM,nMM,nMM],4,1,wf4(:,37))
  call Hloop_QV_A(ntryL,G0H32(1),ex5(:),G0H16(9),m3h2x16(:,405),heltab2x32(:,:,405))
  call Hloop_Q_A(ntryL,G0H16(9),16,nMM,G1H16(141),n2h16(133))
  Gcoeff(:)%j = (-(c(86)*M(1,:)%j)) * den(14)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(426),h0tab(:,426),[16,3,4,8],[nML,nML,nML,nML],4,1,wf4(:,37))
  call Hloop_QV_A(ntryL,G0H32(1),ex5(:),G0H16(10),m3h2x16(:,406),heltab2x32(:,:,406))
  call Hloop_Q_A(ntryL,G0H16(10),16,nML,G1H16(142),n2h16(134))
  Gcoeff(:)%j = (-(c(89)*M(1,:)%j)) * den(14)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(427),h0tab(:,427),[16,3,4,8],[nMT,nMT,nMT,nMT],4,1,wf4(:,37))
  call Hloop_AV_Q(ntryL,G0H32(1),ex5(:),G0H16(11),m3h2x16(:,407),heltab2x32(:,:,407))
  call Hloop_A_Q(ntryL,G0H16(11),16,nMT,G1H16(143),n2h16(135))
  Gcoeff(:)%j = (-(c(89)*M(1,:)%j)) * den(14)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(428),h0tab(:,428),[16,3,4,8],[nMT,nMT,nMT,nMT],4,1,wf4(:,37))
  call Hloop_QV_A(ntryL,G0H32(1),ex5(:),G0H16(12),m3h2x16(:,408),heltab2x32(:,:,408))
  call Hloop_Q_A(ntryL,G0H16(12),16,nMT,G1H16(144),n2h16(136))
  Gcoeff(:)%j = (-(c(81)*M(1,:)%j)) * den(14)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(429),h0tab(:,429),[16,3,4,8],[nMB,nMB,nMB,nMB],4,1,wf4(:,37))
  call Hloop_AV_Q(ntryL,G0H32(1),ex5(:),G0H16(4),m3h2x16(:,409),heltab2x32(:,:,409))
  call Hloop_A_Q(ntryL,G0H16(4),16,nMB,G1H16(145),n2h16(137))
  Gcoeff(:)%j = (-(c(81)*M(1,:)%j)) * den(14)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(430),h0tab(:,430),[16,3,4,8],[nMB,nMB,nMB,nMB],4,1,wf4(:,37))
  call Hloop_QV_A(ntryL,G0H32(1),ex5(:),G0H16(5),m3h2x16(:,410),heltab2x32(:,:,410))
  call Hloop_Q_A(ntryL,G0H16(5),16,nMB,G1H16(146),n2h16(138))
  Gcoeff(:)%j = (-(c(42)*M(1,:)%j)) * den(54)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(431),h0tab(:,431),[16,3,4,8],[nMW,nMW,nMW,nMW],4,1,wf4(:,36))
  call Hloop_SV_T(ntryL,G0H32(1),0,ex5(:),16,G1H16(147),m3h2x16(:,411),heltab2x32(:,:,411))
  Gcoeff(:)%j = (-(c(42)*M(1,:)%j)) * den(54)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(432),h0tab(:,432),[16,3,4,8],[nMW,nMW,nMW,nMW],4,1,wf4(:,36))
  call Hloop_TV_S(ntryL,G0H32(1),0,ex5(:),16,G1H16(148),m3h2x16(:,412),heltab2x32(:,:,412))
  Gcoeff(:)%j = (-(c(24)*M(1,:)%j)) * den(54)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(433),h0tab(:,433),[16,3,4,8],[nMW,nMW,nMW,nMW],4,1,wf4(:,36))
  call Hloop_DV_C(ntryL,G0H32(1),0,ex5(:),G1H16(149),m3h2x16(:,413),heltab2x32(:,:,413))
  Gcoeff(:)%j = (-(c(24)*M(1,:)%j)) * den(54)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(434),h0tab(:,434),[16,3,4,8],[nMW,nMW,nMW,nMW],4,1,wf4(:,36))
  call Hloop_CV_D(ntryL,G0H32(1),0,ex5(:),16,G1H16(150),m3h2x16(:,414),heltab2x32(:,:,414))
  Gcoeff(:)%j = (c(24)*M(1,:)%j) * den(54)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(435),h0tab(:,435),[16,3,4,8],[nMW,nMW,nMW,nMW],4,1,wf4(:,36))
  call Hloop_DV_C(ntryL,G0H32(1),0,ex5(:),G1H16(151),m3h2x16(:,415),heltab2x32(:,:,415))
  Gcoeff(:)%j = (c(24)*M(1,:)%j) * den(54)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(436),h0tab(:,436),[16,3,4,8],[nMW,nMW,nMW,nMW],4,1,wf4(:,36))
  call Hloop_CV_D(ntryL,G0H32(1),0,ex5(:),16,G1H16(152),m3h2x16(:,416),heltab2x32(:,:,416))
  Gcoeff(:)%j = (-(c(24)*M(1,:)%j)) * den(14)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(437),h0tab(:,437),[16,3,4,8],[nMW,nMW,nMW,nMW],4,1,wf4(:,37))
  call Hloop_DV_C(ntryL,G0H32(1),0,ex5(:),G1H16(153),m3h2x16(:,417),heltab2x32(:,:,417))
  Gcoeff(:)%j = (-(c(24)*M(1,:)%j)) * den(14)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(438),h0tab(:,438),[16,3,4,8],[nMW,nMW,nMW,nMW],4,1,wf4(:,37))
  call Hloop_CV_D(ntryL,G0H32(1),0,ex5(:),16,G1H16(154),m3h2x16(:,418),heltab2x32(:,:,418))
  Gcoeff(:)%j = (-(c(24)*M(1,:)%j)) * den(14)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(439),h0tab(:,439),[16,3,4,8],[nMW,nMW,nMW,nMW],4,1,wf4(:,37))
  call Hloop_DV_C(ntryL,G0H32(1),0,ex5(:),G1H16(155),m3h2x16(:,419),heltab2x32(:,:,419))
  Gcoeff(:)%j = (-(c(24)*M(1,:)%j)) * den(14)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(440),h0tab(:,440),[16,3,4,8],[nMW,nMW,nMW,nMW],4,1,wf4(:,37))
  call Hloop_CV_D(ntryL,G0H32(1),0,ex5(:),16,G1H16(156),m3h2x16(:,420),heltab2x32(:,:,420))
  Gcoeff(:)%j = (-(c(26)*M(1,:)%j)) * den(54)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(441),h0tab(:,441),[16,3,4,8],[nMW,nMW,nMW,nMW],4,1,wf4(:,36))
  call Hloop_UW_V(ntryL,G0H32(1),0,ex5(:),16,G1H16(157),m3h2x16(:,421),heltab2x32(:,:,421))
  Gcoeff(:)%j = (-(c(26)*M(1,:)%j)) * den(54)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(442),h0tab(:,442),[16,3,4,8],[nMW,nMW,nMW,nMW],4,1,wf4(:,36))
  call Hloop_UV_W(ntryL,G0H32(1),0,ex5(:),16,G1H16(158),m3h2x16(:,422),heltab2x32(:,:,422))
  Gcoeff(:)%j = (c(24)*M(1,:)%j) * den(54)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(443),h0tab(:,443),[16,3,4,8],[nMW,nMW,nMW,nMW],4,1,wf4(:,36))
  call Hloop_SV_V(ntryL,G0H32(1),ex5(:),G0H16(6),m3h2x16(:,423),heltab2x32(:,:,423))
  Gcoeff(:)%j = (-(c(24)*M(1,:)%j)) * den(54)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(444),h0tab(:,444),[16,3,4,8],[nMW,nMW,nMW,nMW],4,1,wf4(:,36))
  call Hloop_SV_V(ntryL,G0H32(1),ex5(:),G0H16(7),m3h2x16(:,424),heltab2x32(:,:,424))
  Gcoeff(:)%j = (-(c(24)*M(1,:)%j)) * den(14)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(445),h0tab(:,445),[16,3,4,8],[nMW,nMW,nMW,nMW],4,1,wf4(:,37))
  call Hloop_SV_V(ntryL,G0H32(1),ex5(:),G0H16(8),m3h2x16(:,425),heltab2x32(:,:,425))
  Gcoeff(:)%j = (-(c(24)*M(1,:)%j)) * den(14)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(446),h0tab(:,446),[16,3,4,8],[nMW,nMW,nMW,nMW],4,1,wf4(:,37))
  call Hloop_SV_V(ntryL,G0H32(1),ex5(:),G0H16(9),m3h2x16(:,426),heltab2x32(:,:,426))
  Gcoeff(:)%j = (c(28)*M(1,:)%j) * den(54)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(447),h0tab(:,447),[16,3,4,8],[nMW,nMW,nMW,nMW],4,1,wf4(:,36))
  call Hloop_VV_S(ntryL,G0H32(1),ex5(:),G0H16(10),m3h2x16(:,427),heltab2x32(:,:,427))
  Gcoeff(:)%j = (c(28)*M(1,:)%j) * den(54)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(448),h0tab(:,448),[16,3,4,8],[nMW,nMW,nMW,nMW],4,1,wf4(:,36))
  call Hloop_VV_S(ntryL,G0H32(1),ex5(:),G0H16(11),m3h2x16(:,428),heltab2x32(:,:,428))
  Gcoeff(:)%j = (-(c(24)*M(1,:)%j)) * den(54)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(449),h0tab(:,449),[16,3,4,8],[nMW,nMW,nMW,nMW],4,1,wf4(:,36))
  call Hloop_SV_T(ntryL,G0H32(1),0,ex5(:),16,G1H16(159),m3h2x16(:,429),heltab2x32(:,:,429))
  Gcoeff(:)%j = (c(24)*M(1,:)%j) * den(54)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(450),h0tab(:,450),[16,3,4,8],[nMW,nMW,nMW,nMW],4,1,wf4(:,36))
  call Hloop_TV_S(ntryL,G0H32(1),0,ex5(:),16,G1H16(160),m3h2x16(:,430),heltab2x32(:,:,430))
  Gcoeff(:)%j = (-(c(24)*M(1,:)%j)) * den(14)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(451),h0tab(:,451),[16,3,4,8],[nMW,nMW,nMW,nMW],4,1,wf4(:,37))
  call Hloop_SV_T(ntryL,G0H32(1),0,ex5(:),16,G1H16(161),m3h2x16(:,431),heltab2x32(:,:,431))
  Gcoeff(:)%j = (-(c(24)*M(1,:)%j)) * den(14)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(452),h0tab(:,452),[16,3,4,8],[nMW,nMW,nMW,nMW],4,1,wf4(:,37))
  call Hloop_TV_S(ntryL,G0H32(1),0,ex5(:),16,G1H16(162),m3h2x16(:,432),heltab2x32(:,:,432))
  Gcoeff(:)%j = (c(28)*M(1,:)%j) * den(54)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(453),h0tab(:,453),[16,3,4,8],[nMW,nMW,nMW,nMW],4,1,wf4(:,36))
  call Hloop_SV_T(ntryL,G0H32(1),0,ex5(:),16,G1H16(163),m3h2x16(:,433),heltab2x32(:,:,433))
  Gcoeff(:)%j = (c(28)*M(1,:)%j) * den(54)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(454),h0tab(:,454),[16,3,4,8],[nMW,nMW,nMW,nMW],4,1,wf4(:,36))
  call Hloop_TV_S(ntryL,G0H32(1),0,ex5(:),16,G1H16(164),m3h2x16(:,434),heltab2x32(:,:,434))
  Gcoeff(:)%j = (c(24)*M(1,:)%j) * den(54)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(455),h0tab(:,455),[16,3,4,8],[nMW,nMW,nMW,nMW],4,1,wf4(:,36))
  call Hloop_UW_V(ntryL,G0H32(1),0,ex5(:),16,G1H16(165),m3h2x16(:,435),heltab2x32(:,:,435))
  Gcoeff(:)%j = (-(c(24)*M(1,:)%j)) * den(54)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(456),h0tab(:,456),[16,3,4,8],[nMW,nMW,nMW,nMW],4,1,wf4(:,36))
  call Hloop_UV_W(ntryL,G0H32(1),0,ex5(:),16,G1H16(166),m3h2x16(:,436),heltab2x32(:,:,436))
  Gcoeff(:)%j = (-(c(24)*M(1,:)%j)) * den(14)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(457),h0tab(:,457),[16,3,4,8],[nMW,nMW,nMW,nMW],4,1,wf4(:,37))
  call Hloop_UW_V(ntryL,G0H32(1),0,ex5(:),16,G1H16(167),m3h2x16(:,437),heltab2x32(:,:,437))
  Gcoeff(:)%j = (-(c(24)*M(1,:)%j)) * den(14)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(458),h0tab(:,458),[16,3,4,8],[nMW,nMW,nMW,nMW],4,1,wf4(:,37))
  call Hloop_UV_W(ntryL,G0H32(1),0,ex5(:),16,G1H16(168),m3h2x16(:,438),heltab2x32(:,:,438))
  Gcoeff(:)%j = (c(51)*M(1,:)%j) * den(54)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(459),h0tab(:,459),[16,3,4,8],[nMW,nMW,nMW,nMW],4,1,wf4(:,36))
  call Hloop_SV_V(ntryL,G0H32(1),ex5(:),G0H16(12),m3h2x16(:,439),heltab2x32(:,:,439))
  Gcoeff(:)%j = (c(51)*M(1,:)%j) * den(54)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(460),h0tab(:,460),[16,3,4,8],[nMW,nMW,nMW,nMW],4,1,wf4(:,36))
  call Hloop_SV_V(ntryL,G0H32(1),ex5(:),G0H16(4),m3h2x16(:,440),heltab2x32(:,:,440))
  Gcoeff(:)%j = (c(49)*M(1,:)%j) * den(54)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(461),h0tab(:,461),[16,3,4,8],[nMW,nMW,nMW,nMW],4,1,wf4(:,36))
  call Hloop_VV_S(ntryL,G0H32(1),ex5(:),G0H16(5),m3h2x16(:,441),heltab2x32(:,:,441))
  Gcoeff(:)%j = (-(c(49)*M(1,:)%j)) * den(54)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(462),h0tab(:,462),[16,3,4,8],[nMW,nMW,nMW,nMW],4,1,wf4(:,36))
  call Hloop_VV_S(ntryL,G0H32(1),ex5(:),G0H16(70),m3h2x16(:,442),heltab2x32(:,:,442))
  Gcoeff(:)%j = (c(49)*M(1,:)%j) * den(14)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(463),h0tab(:,463),[16,3,4,8],[nMW,nMW,nMW,nMW],4,1,wf4(:,37))
  call Hloop_VV_S(ntryL,G0H32(1),ex5(:),G0H16(71),m3h2x16(:,443),heltab2x32(:,:,443))
  Gcoeff(:)%j = (c(49)*M(1,:)%j) * den(14)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(464),h0tab(:,464),[16,3,4,8],[nMW,nMW,nMW,nMW],4,1,wf4(:,37))
  call Hloop_VV_S(ntryL,G0H32(1),ex5(:),G0H16(72),m3h2x16(:,444),heltab2x32(:,:,444))
  Gcoeff(:)%j = (-(c(49)*M(1,:)%j)) * den(54)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(465),h0tab(:,465),[16,3,4,8],[nMW,nMW,nMW,nMW],4,1,wf4(:,36))
  call Hloop_SV_V(ntryL,G0H32(1),ex5(:),G0H16(73),m3h2x16(:,445),heltab2x32(:,:,445))
  Gcoeff(:)%j = (c(49)*M(1,:)%j) * den(54)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(466),h0tab(:,466),[16,3,4,8],[nMW,nMW,nMW,nMW],4,1,wf4(:,36))
  call Hloop_SV_V(ntryL,G0H32(1),ex5(:),G0H16(74),m3h2x16(:,446),heltab2x32(:,:,446))
  Gcoeff(:)%j = (c(49)*M(1,:)%j) * den(14)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(467),h0tab(:,467),[16,3,4,8],[nMW,nMW,nMW,nMW],4,1,wf4(:,37))
  call Hloop_SV_V(ntryL,G0H32(1),ex5(:),G0H16(75),m3h2x16(:,447),heltab2x32(:,:,447))
  Gcoeff(:)%j = (c(49)*M(1,:)%j) * den(14)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(468),h0tab(:,468),[16,3,4,8],[nMW,nMW,nMW,nMW],4,1,wf4(:,37))
  call Hloop_SV_V(ntryL,G0H32(1),ex5(:),G0H16(76),m3h2x16(:,448),heltab2x32(:,:,448))
  Gcoeff(:)%j = (c(28)*M(1,:)%j) * den(54)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(469),h0tab(:,469),[16,3,4,8],[nMW,nMW,nMW,nMW],4,1,wf4(:,36))
  call Hloop_VV_S(ntryL,G0H32(1),ex5(:),G0H16(77),m3h2x16(:,449),heltab2x32(:,:,449))
  Gcoeff(:)%j = (c(28)*M(1,:)%j) * den(54)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(470),h0tab(:,470),[16,3,4,8],[nMW,nMW,nMW,nMW],4,1,wf4(:,36))
  call Hloop_VV_S(ntryL,G0H32(1),ex5(:),G0H16(78),m3h2x16(:,450),heltab2x32(:,:,450))
  Gcoeff(:)%j = (-(c(24)*M(1,:)%j)) * den(54)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(471),h0tab(:,471),[16,3,4,8],[nMW,nMW,nMW,nMW],4,1,wf4(:,36))
  call Hloop_SV_T(ntryL,G0H32(1),0,ex5(:),16,G1H16(169),m3h2x16(:,451),heltab2x32(:,:,451))
  Gcoeff(:)%j = (c(24)*M(1,:)%j) * den(54)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(472),h0tab(:,472),[16,3,4,8],[nMW,nMW,nMW,nMW],4,1,wf4(:,36))
  call Hloop_TV_S(ntryL,G0H32(1),0,ex5(:),16,G1H16(170),m3h2x16(:,452),heltab2x32(:,:,452))
  Gcoeff(:)%j = (-(c(24)*M(1,:)%j)) * den(14)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(473),h0tab(:,473),[16,3,4,8],[nMW,nMW,nMW,nMW],4,1,wf4(:,37))
  call Hloop_SV_T(ntryL,G0H32(1),0,ex5(:),16,G1H16(171),m3h2x16(:,453),heltab2x32(:,:,453))
  Gcoeff(:)%j = (-(c(24)*M(1,:)%j)) * den(14)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(474),h0tab(:,474),[16,3,4,8],[nMW,nMW,nMW,nMW],4,1,wf4(:,37))
  call Hloop_TV_S(ntryL,G0H32(1),0,ex5(:),16,G1H16(172),m3h2x16(:,454),heltab2x32(:,:,454))
  Gcoeff(:)%j = (c(51)*M(1,:)%j) * den(54)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(475),h0tab(:,475),[16,3,4,8],[nMW,nMW,nMW,nMW],4,1,wf4(:,36))
  call Hloop_UW_V(ntryL,G0H32(1),0,ex5(:),16,G1H16(173),m3h2x16(:,455),heltab2x32(:,:,455))
  Gcoeff(:)%j = (c(51)*M(1,:)%j) * den(54)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(476),h0tab(:,476),[16,3,4,8],[nMW,nMW,nMW,nMW],4,1,wf4(:,36))
  call Hloop_UV_W(ntryL,G0H32(1),0,ex5(:),16,G1H16(174),m3h2x16(:,456),heltab2x32(:,:,456))
  Gcoeff(:)%j = (c(24)*M(1,:)%j) * den(54)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(477),h0tab(:,477),[16,3,4,8],[nMW,nMW,nMW,nMW],4,1,wf4(:,36))
  call Hloop_UW_V(ntryL,G0H32(1),0,ex5(:),16,G1H16(175),m3h2x16(:,457),heltab2x32(:,:,457))
  Gcoeff(:)%j = (-(c(24)*M(1,:)%j)) * den(54)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(478),h0tab(:,478),[16,3,4,8],[nMW,nMW,nMW,nMW],4,1,wf4(:,36))
  call Hloop_UV_W(ntryL,G0H32(1),0,ex5(:),16,G1H16(176),m3h2x16(:,458),heltab2x32(:,:,458))
  Gcoeff(:)%j = (-(c(24)*M(1,:)%j)) * den(14)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(479),h0tab(:,479),[16,3,4,8],[nMW,nMW,nMW,nMW],4,1,wf4(:,37))
  call Hloop_UW_V(ntryL,G0H32(1),0,ex5(:),16,G1H16(177),m3h2x16(:,459),heltab2x32(:,:,459))
  Gcoeff(:)%j = (-(c(24)*M(1,:)%j)) * den(14)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(480),h0tab(:,480),[16,3,4,8],[nMW,nMW,nMW,nMW],4,1,wf4(:,37))
  call Hloop_UV_W(ntryL,G0H32(1),0,ex5(:),16,G1H16(178),m3h2x16(:,460),heltab2x32(:,:,460))
  Gcoeff(:)%j = (c(51)*M(1,:)%j) * den(54)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(481),h0tab(:,481),[16,3,4,8],[nMW,nMW,nMW,nMW],4,1,wf4(:,36))
  call Hloop_SV_V(ntryL,G0H32(1),ex5(:),G0H16(79),m3h2x16(:,461),heltab2x32(:,:,461))
  Gcoeff(:)%j = (c(51)*M(1,:)%j) * den(54)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(482),h0tab(:,482),[16,3,4,8],[nMW,nMW,nMW,nMW],4,1,wf4(:,36))
  call Hloop_SV_V(ntryL,G0H32(1),ex5(:),G0H16(80),m3h2x16(:,462),heltab2x32(:,:,462))
  Gcoeff(:)%j = (-(c(24)*M(1,:)%j)) * den(54)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(483),h0tab(:,483),[16,3,4,8],[nMW,nMW,nMW,nMW],4,1,wf4(:,36))
  call Hloop_VV_S(ntryL,G0H32(1),ex5(:),G0H16(81),m3h2x16(:,463),heltab2x32(:,:,463))
  Gcoeff(:)%j = (c(24)*M(1,:)%j) * den(54)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(484),h0tab(:,484),[16,3,4,8],[nMW,nMW,nMW,nMW],4,1,wf4(:,36))
  call Hloop_VV_S(ntryL,G0H32(1),ex5(:),G0H16(82),m3h2x16(:,464),heltab2x32(:,:,464))
  Gcoeff(:)%j = (-(c(24)*M(1,:)%j)) * den(14)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(485),h0tab(:,485),[16,3,4,8],[nMW,nMW,nMW,nMW],4,1,wf4(:,37))
  call Hloop_VV_S(ntryL,G0H32(1),ex5(:),G0H16(83),m3h2x16(:,465),heltab2x32(:,:,465))
  Gcoeff(:)%j = (-(c(24)*M(1,:)%j)) * den(14)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(486),h0tab(:,486),[16,3,4,8],[nMW,nMW,nMW,nMW],4,1,wf4(:,37))
  call Hloop_VV_S(ntryL,G0H32(1),ex5(:),G0H16(84),m3h2x16(:,466),heltab2x32(:,:,466))
  Gcoeff(:)%j = (-(c(79)*M(1,:)%j)) * den(13)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(487),h0tab(:,487),[16,3,4,8],[nME,nME,nME,nME],4,1,wf4(:,13))
  call Hloop_AV_Q(ntryL,G0H32(1),ex5(:),G0H16(85),m3h2x16(:,467),heltab2x32(:,:,467))
  call Hloop_A_Q(ntryL,G0H16(85),16,nME,G1H16(179),n2h16(139))
  Gcoeff(:)%j = (-(c(79)*M(1,:)%j)) * den(13)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(488),h0tab(:,488),[16,3,4,8],[nMM,nMM,nMM,nMM],4,1,wf4(:,13))
  call Hloop_AV_Q(ntryL,G0H32(1),ex5(:),G0H16(85),m3h2x16(:,468),heltab2x32(:,:,468))
  call Hloop_A_Q(ntryL,G0H16(85),16,nMM,G1H16(180),n2h16(140))
  Gcoeff(:)%j = (-(c(79)*M(1,:)%j)) * den(13)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(489),h0tab(:,489),[16,3,4,8],[nML,nML,nML,nML],4,1,wf4(:,13))
  call Hloop_AV_Q(ntryL,G0H32(1),ex5(:),G0H16(85),m3h2x16(:,469),heltab2x32(:,:,469))
  call Hloop_A_Q(ntryL,G0H16(85),16,nML,G1H16(181),n2h16(141))
  Gcoeff(:)%j = (-(c(79)*M(1,:)%j)) * den(13)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(490),h0tab(:,490),[16,3,4,8],[nME,nME,nME,nME],4,1,wf4(:,13))
  call Hloop_QV_A(ntryL,G0H32(1),ex5(:),G0H16(85),m3h2x16(:,470),heltab2x32(:,:,470))
  call Hloop_Q_A(ntryL,G0H16(85),16,nME,G1H16(182),n2h16(142))
  Gcoeff(:)%j = (-(c(79)*M(1,:)%j)) * den(13)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(491),h0tab(:,491),[16,3,4,8],[nMM,nMM,nMM,nMM],4,1,wf4(:,13))
  call Hloop_QV_A(ntryL,G0H32(1),ex5(:),G0H16(85),m3h2x16(:,471),heltab2x32(:,:,471))
  call Hloop_Q_A(ntryL,G0H16(85),16,nMM,G1H16(183),n2h16(143))
  Gcoeff(:)%j = (-(c(79)*M(1,:)%j)) * den(13)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(492),h0tab(:,492),[16,3,4,8],[nML,nML,nML,nML],4,1,wf4(:,13))
  call Hloop_QV_A(ntryL,G0H32(1),ex5(:),G0H16(85),m3h2x16(:,472),heltab2x32(:,:,472))
  call Hloop_Q_A(ntryL,G0H16(85),16,nML,G1H16(184),n2h16(144))
  Gcoeff(:)%j = (-(c(75)*M(1,:)%j)) * den(13)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(493),h0tab(:,493),[16,3,4,8],[0,0,0,0],4,1,wf4(:,13))
  call Hloop_AV_Q(ntryL,G0H32(1),ex5(:),G0H16(85),m3h2x16(:,473),heltab2x32(:,:,473))
  call Hloop_A_Q(ntryL,G0H16(85),16,0,G1H16(185),n2h16(145))
  Gcoeff(:)%j = (-(c(73)*M(1,:)%j)) * den(13)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(494),h0tab(:,494),[16,3,4,8],[nMT,nMT,nMT,nMT],4,1,wf4(:,13))
  call Hloop_AV_Q(ntryL,G0H32(1),ex5(:),G0H16(85),m3h2x16(:,474),heltab2x32(:,:,474))
  call Hloop_A_Q(ntryL,G0H16(85),16,nMT,G1H16(186),n2h16(146))
  Gcoeff(:)%j = (-(c(75)*M(1,:)%j)) * den(13)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(495),h0tab(:,495),[16,3,4,8],[0,0,0,0],4,1,wf4(:,13))
  call Hloop_QV_A(ntryL,G0H32(1),ex5(:),G0H16(85),m3h2x16(:,475),heltab2x32(:,:,475))
  call Hloop_Q_A(ntryL,G0H16(85),16,0,G1H16(187),n2h16(147))
  Gcoeff(:)%j = (-(c(73)*M(1,:)%j)) * den(13)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(496),h0tab(:,496),[16,3,4,8],[nMT,nMT,nMT,nMT],4,1,wf4(:,13))
  call Hloop_QV_A(ntryL,G0H32(1),ex5(:),G0H16(85),m3h2x16(:,476),heltab2x32(:,:,476))
  call Hloop_Q_A(ntryL,G0H16(85),16,nMT,G1H16(188),n2h16(148))
  Gcoeff(:)%j = (-(c(69)*M(1,:)%j)) * den(13)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(497),h0tab(:,497),[16,3,4,8],[0,0,0,0],4,1,wf4(:,13))
  call Hloop_AV_Q(ntryL,G0H32(1),ex5(:),G0H16(85),m3h2x16(:,477),heltab2x32(:,:,477))
  call Hloop_A_Q(ntryL,G0H16(85),16,0,G1H16(189),n2h16(149))
  Gcoeff(:)%j = (-(c(68)*M(1,:)%j)) * den(13)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(498),h0tab(:,498),[16,3,4,8],[nMB,nMB,nMB,nMB],4,1,wf4(:,13))
  call Hloop_AV_Q(ntryL,G0H32(1),ex5(:),G0H16(85),m3h2x16(:,478),heltab2x32(:,:,478))
  call Hloop_A_Q(ntryL,G0H16(85),16,nMB,G1H16(190),n2h16(150))
  Gcoeff(:)%j = (-(c(69)*M(1,:)%j)) * den(13)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(499),h0tab(:,499),[16,3,4,8],[0,0,0,0],4,1,wf4(:,13))
  call Hloop_QV_A(ntryL,G0H32(1),ex5(:),G0H16(85),m3h2x16(:,479),heltab2x32(:,:,479))
  call Hloop_Q_A(ntryL,G0H16(85),16,0,G1H16(191),n2h16(151))
  Gcoeff(:)%j = (-(c(68)*M(1,:)%j)) * den(13)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(500),h0tab(:,500),[16,3,4,8],[nMB,nMB,nMB,nMB],4,1,wf4(:,13))
  call Hloop_QV_A(ntryL,G0H32(1),ex5(:),G0H16(85),m3h2x16(:,480),heltab2x32(:,:,480))
  call Hloop_Q_A(ntryL,G0H16(85),16,nMB,G1H16(192),n2h16(152))
  Gcoeff(:)%j = (c(80)*M(1,:)%j) * den(14)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(501),h0tab(:,501),[16,3,4,8],[nME,nME,nME,nME],4,1,wf4(:,14))
  call Hloop_AV_Q(ntryL,G0H32(1),ex5(:),G0H16(85),m3h2x16(:,481),heltab2x32(:,:,481))
  call Hloop_A_Q(ntryL,G0H16(85),16,nME,G1H16(193),n2h16(153))
  Gcoeff(:)%j = (c(80)*M(1,:)%j) * den(14)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(502),h0tab(:,502),[16,3,4,8],[nMM,nMM,nMM,nMM],4,1,wf4(:,14))
  call Hloop_AV_Q(ntryL,G0H32(1),ex5(:),G0H16(85),m3h2x16(:,482),heltab2x32(:,:,482))
  call Hloop_A_Q(ntryL,G0H16(85),16,nMM,G1H16(194),n2h16(154))
  Gcoeff(:)%j = (c(80)*M(1,:)%j) * den(14)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(503),h0tab(:,503),[16,3,4,8],[nML,nML,nML,nML],4,1,wf4(:,14))
  call Hloop_AV_Q(ntryL,G0H32(1),ex5(:),G0H16(85),m3h2x16(:,483),heltab2x32(:,:,483))
  call Hloop_A_Q(ntryL,G0H16(85),16,nML,G1H16(195),n2h16(155))
  Gcoeff(:)%j = (c(80)*M(1,:)%j) * den(14)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(504),h0tab(:,504),[16,3,4,8],[nME,nME,nME,nME],4,1,wf4(:,14))
  call Hloop_QV_A(ntryL,G0H32(1),ex5(:),G0H16(85),m3h2x16(:,484),heltab2x32(:,:,484))
  call Hloop_Q_A(ntryL,G0H16(85),16,nME,G1H16(196),n2h16(156))
  Gcoeff(:)%j = (c(80)*M(1,:)%j) * den(14)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(505),h0tab(:,505),[16,3,4,8],[nMM,nMM,nMM,nMM],4,1,wf4(:,14))
  call Hloop_QV_A(ntryL,G0H32(1),ex5(:),G0H16(85),m3h2x16(:,485),heltab2x32(:,:,485))
  call Hloop_Q_A(ntryL,G0H16(85),16,nMM,G1H16(197),n2h16(157))
  Gcoeff(:)%j = (c(80)*M(1,:)%j) * den(14)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(506),h0tab(:,506),[16,3,4,8],[nML,nML,nML,nML],4,1,wf4(:,14))
  call Hloop_QV_A(ntryL,G0H32(1),ex5(:),G0H16(85),m3h2x16(:,486),heltab2x32(:,:,486))
  call Hloop_Q_A(ntryL,G0H16(85),16,nML,G1H16(198),n2h16(158))
  Gcoeff(:)%j = (-(c(78)*M(1,:)%j)) * den(14)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(507),h0tab(:,507),[16,3,4,8],[0,0,0,0],4,1,wf4(:,14))
  call Hloop_AV_Q(ntryL,G0H32(1),ex5(:),G0H16(85),m3h2x16(:,487),heltab2x32(:,:,487))
  call Hloop_A_Q(ntryL,G0H16(85),16,0,G1H16(199),n2h16(159))
  Gcoeff(:)%j = (-(c(76)*M(1,:)%j)) * den(14)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(508),h0tab(:,508),[16,3,4,8],[nMT,nMT,nMT,nMT],4,1,wf4(:,14))
  call Hloop_AV_Q(ntryL,G0H32(1),ex5(:),G0H16(85),m3h2x16(:,488),heltab2x32(:,:,488))
  call Hloop_A_Q(ntryL,G0H16(85),16,nMT,G1H16(200),n2h16(160))
  Gcoeff(:)%j = (-(c(78)*M(1,:)%j)) * den(14)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(509),h0tab(:,509),[16,3,4,8],[0,0,0,0],4,1,wf4(:,14))
  call Hloop_QV_A(ntryL,G0H32(1),ex5(:),G0H16(85),m3h2x16(:,489),heltab2x32(:,:,489))
  call Hloop_Q_A(ntryL,G0H16(85),16,0,G1H16(201),n2h16(161))
  Gcoeff(:)%j = (-(c(76)*M(1,:)%j)) * den(14)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(510),h0tab(:,510),[16,3,4,8],[nMT,nMT,nMT,nMT],4,1,wf4(:,14))
  call Hloop_QV_A(ntryL,G0H32(1),ex5(:),G0H16(85),m3h2x16(:,490),heltab2x32(:,:,490))
  call Hloop_Q_A(ntryL,G0H16(85),16,nMT,G1H16(202),n2h16(162))
  Gcoeff(:)%j = (c(72)*M(1,:)%j) * den(14)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(511),h0tab(:,511),[16,3,4,8],[0,0,0,0],4,1,wf4(:,14))
  call Hloop_AV_Q(ntryL,G0H32(1),ex5(:),G0H16(85),m3h2x16(:,491),heltab2x32(:,:,491))
  call Hloop_A_Q(ntryL,G0H16(85),16,0,G1H16(203),n2h16(163))
  Gcoeff(:)%j = (c(71)*M(1,:)%j) * den(14)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(512),h0tab(:,512),[16,3,4,8],[nMB,nMB,nMB,nMB],4,1,wf4(:,14))
  call Hloop_AV_Q(ntryL,G0H32(1),ex5(:),G0H16(85),m3h2x16(:,492),heltab2x32(:,:,492))
  call Hloop_A_Q(ntryL,G0H16(85),16,nMB,G1H16(204),n2h16(164))
  Gcoeff(:)%j = (c(72)*M(1,:)%j) * den(14)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(513),h0tab(:,513),[16,3,4,8],[0,0,0,0],4,1,wf4(:,14))
  call Hloop_QV_A(ntryL,G0H32(1),ex5(:),G0H16(85),m3h2x16(:,493),heltab2x32(:,:,493))
  call Hloop_Q_A(ntryL,G0H16(85),16,0,G1H16(205),n2h16(165))
  Gcoeff(:)%j = (c(71)*M(1,:)%j) * den(14)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(514),h0tab(:,514),[16,3,4,8],[nMB,nMB,nMB,nMB],4,1,wf4(:,14))
  call Hloop_QV_A(ntryL,G0H32(1),ex5(:),G0H16(85),m3h2x16(:,494),heltab2x32(:,:,494))
  call Hloop_Q_A(ntryL,G0H16(85),16,nMB,G1H16(206),n2h16(166))
  Gcoeff(:)%j = (c(4)*M(1,:)%j) * den(13)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(515),h0tab(:,515),[16,3,4,8],[nMW,nMW,nMW,nMW],4,1,wf4(:,13))
  call Hloop_SV_T(ntryL,G0H32(1),0,ex5(:),16,G1H16(207),m3h2x16(:,495),heltab2x32(:,:,495))
  Gcoeff(:)%j = (c(4)*M(1,:)%j) * den(13)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(516),h0tab(:,516),[16,3,4,8],[nMW,nMW,nMW,nMW],4,1,wf4(:,13))
  call Hloop_TV_S(ntryL,G0H32(1),0,ex5(:),16,G1H16(208),m3h2x16(:,496),heltab2x32(:,:,496))
  Gcoeff(:)%j = (-(c(61)*M(1,:)%j)) * den(14)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(517),h0tab(:,517),[16,3,4,8],[nMW,nMW,nMW,nMW],4,1,wf4(:,14))
  call Hloop_SV_T(ntryL,G0H32(1),0,ex5(:),16,G1H16(209),m3h2x16(:,497),heltab2x32(:,:,497))
  Gcoeff(:)%j = (-(c(61)*M(1,:)%j)) * den(14)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(518),h0tab(:,518),[16,3,4,8],[nMW,nMW,nMW,nMW],4,1,wf4(:,14))
  call Hloop_TV_S(ntryL,G0H32(1),0,ex5(:),16,G1H16(210),m3h2x16(:,498),heltab2x32(:,:,498))
  Gcoeff(:)%j = (-(c(4)*M(1,:)%j)) * den(13)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(519),h0tab(:,519),[16,3,4,8],[nMW,nMW,nMW,nMW],4,1,wf4(:,13))
  call Hloop_DV_C(ntryL,G0H32(1),0,ex5(:),G1H16(211),m3h2x16(:,499),heltab2x32(:,:,499))
  Gcoeff(:)%j = (-(c(4)*M(1,:)%j)) * den(13)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(520),h0tab(:,520),[16,3,4,8],[nMW,nMW,nMW,nMW],4,1,wf4(:,13))
  call Hloop_CV_D(ntryL,G0H32(1),0,ex5(:),16,G1H16(212),m3h2x16(:,500),heltab2x32(:,:,500))
  Gcoeff(:)%j = (-(c(4)*M(1,:)%j)) * den(13)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(521),h0tab(:,521),[16,3,4,8],[nMW,nMW,nMW,nMW],4,1,wf4(:,13))
  call Hloop_DV_C(ntryL,G0H32(1),0,ex5(:),G1H16(213),m3h2x16(:,501),heltab2x32(:,:,501))
  Gcoeff(:)%j = (-(c(4)*M(1,:)%j)) * den(13)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(522),h0tab(:,522),[16,3,4,8],[nMW,nMW,nMW,nMW],4,1,wf4(:,13))
  call Hloop_CV_D(ntryL,G0H32(1),0,ex5(:),16,G1H16(214),m3h2x16(:,502),heltab2x32(:,:,502))
  Gcoeff(:)%j = (-(c(53)*M(1,:)%j)) * den(14)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(523),h0tab(:,523),[16,3,4,8],[nMW,nMW,nMW,nMW],4,1,wf4(:,14))
  call Hloop_DV_C(ntryL,G0H32(1),0,ex5(:),G1H16(215),m3h2x16(:,503),heltab2x32(:,:,503))
  Gcoeff(:)%j = (-(c(53)*M(1,:)%j)) * den(14)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(524),h0tab(:,524),[16,3,4,8],[nMW,nMW,nMW,nMW],4,1,wf4(:,14))
  call Hloop_CV_D(ntryL,G0H32(1),0,ex5(:),16,G1H16(216),m3h2x16(:,504),heltab2x32(:,:,504))
  Gcoeff(:)%j = (-(c(53)*M(1,:)%j)) * den(14)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(525),h0tab(:,525),[16,3,4,8],[nMW,nMW,nMW,nMW],4,1,wf4(:,14))
  call Hloop_DV_C(ntryL,G0H32(1),0,ex5(:),G1H16(217),m3h2x16(:,505),heltab2x32(:,:,505))
  Gcoeff(:)%j = (-(c(53)*M(1,:)%j)) * den(14)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(526),h0tab(:,526),[16,3,4,8],[nMW,nMW,nMW,nMW],4,1,wf4(:,14))
  call Hloop_CV_D(ntryL,G0H32(1),0,ex5(:),16,G1H16(218),m3h2x16(:,506),heltab2x32(:,:,506))
  Gcoeff(:)%j = (c(4)*M(1,:)%j) * den(13)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(527),h0tab(:,527),[16,3,4,8],[nMW,nMW,nMW,nMW],4,1,wf4(:,13))
  call Hloop_UW_V(ntryL,G0H32(1),0,ex5(:),16,G1H16(219),m3h2x16(:,507),heltab2x32(:,:,507))
  Gcoeff(:)%j = (c(4)*M(1,:)%j) * den(13)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(528),h0tab(:,528),[16,3,4,8],[nMW,nMW,nMW,nMW],4,1,wf4(:,13))
  call Hloop_UV_W(ntryL,G0H32(1),0,ex5(:),16,G1H16(220),m3h2x16(:,508),heltab2x32(:,:,508))
  Gcoeff(:)%j = (c(53)*M(1,:)%j) * den(14)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(529),h0tab(:,529),[16,3,4,8],[nMW,nMW,nMW,nMW],4,1,wf4(:,14))
  call Hloop_UW_V(ntryL,G0H32(1),0,ex5(:),16,G1H16(221),m3h2x16(:,509),heltab2x32(:,:,509))
  Gcoeff(:)%j = (c(53)*M(1,:)%j) * den(14)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(530),h0tab(:,530),[16,3,4,8],[nMW,nMW,nMW,nMW],4,1,wf4(:,14))
  call Hloop_UV_W(ntryL,G0H32(1),0,ex5(:),16,G1H16(222),m3h2x16(:,510),heltab2x32(:,:,510))
  Gcoeff(:)%j = (-(c(9)*M(1,:)%j)) * den(13)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(531),h0tab(:,531),[16,3,4,8],[nMW,nMW,nMW,nMW],4,1,wf4(:,13))
  call Hloop_SV_V(ntryL,G0H32(1),ex5(:),G0H16(85),m3h2x16(:,511),heltab2x32(:,:,511))
  Gcoeff(:)%j = (-(c(9)*M(1,:)%j)) * den(13)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(532),h0tab(:,532),[16,3,4,8],[nMW,nMW,nMW,nMW],4,1,wf4(:,13))
  call Hloop_SV_V(ntryL,G0H32(1),ex5(:),G0H16(86),m3h2x16(:,512),heltab2x32(:,:,512))
  Gcoeff(:)%j = (c(57)*M(1,:)%j) * den(14)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(533),h0tab(:,533),[16,3,4,8],[nMW,nMW,nMW,nMW],4,1,wf4(:,14))
  call Hloop_SV_V(ntryL,G0H32(1),ex5(:),G0H16(87),m3h2x16(:,513),heltab2x32(:,:,513))
  Gcoeff(:)%j = (c(57)*M(1,:)%j) * den(14)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(534),h0tab(:,534),[16,3,4,8],[nMW,nMW,nMW,nMW],4,1,wf4(:,14))
  call Hloop_SV_V(ntryL,G0H32(1),ex5(:),G0H16(88),m3h2x16(:,514),heltab2x32(:,:,514))
  Gcoeff(:)%j = (-(c(9)*M(1,:)%j)) * den(13)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(535),h0tab(:,535),[16,3,4,8],[nMW,nMW,nMW,nMW],4,1,wf4(:,13))
  call Hloop_VV_S(ntryL,G0H32(1),ex5(:),G0H16(89),m3h2x16(:,515),heltab2x32(:,:,515))
  Gcoeff(:)%j = (-(c(9)*M(1,:)%j)) * den(13)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(536),h0tab(:,536),[16,3,4,8],[nMW,nMW,nMW,nMW],4,1,wf4(:,13))
  call Hloop_VV_S(ntryL,G0H32(1),ex5(:),G0H16(90),m3h2x16(:,516),heltab2x32(:,:,516))
  Gcoeff(:)%j = (c(66)*M(1,:)%j) * den(14)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(537),h0tab(:,537),[16,3,4,8],[nMW,nMW,nMW,nMW],4,1,wf4(:,14))
  call Hloop_VV_S(ntryL,G0H32(1),ex5(:),G0H16(91),m3h2x16(:,517),heltab2x32(:,:,517))
  Gcoeff(:)%j = (c(66)*M(1,:)%j) * den(14)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(538),h0tab(:,538),[16,3,4,8],[nMW,nMW,nMW,nMW],4,1,wf4(:,14))
  call Hloop_VV_S(ntryL,G0H32(1),ex5(:),G0H16(92),m3h2x16(:,518),heltab2x32(:,:,518))
  Gcoeff(:)%j = (-(c(9)*M(1,:)%j)) * den(13)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(539),h0tab(:,539),[16,3,4,8],[nMW,nMW,nMW,nMW],4,1,wf4(:,13))
  call Hloop_SV_T(ntryL,G0H32(1),0,ex5(:),16,G1H16(223),m3h2x16(:,519),heltab2x32(:,:,519))
  Gcoeff(:)%j = (-(c(9)*M(1,:)%j)) * den(13)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(540),h0tab(:,540),[16,3,4,8],[nMW,nMW,nMW,nMW],4,1,wf4(:,13))
  call Hloop_TV_S(ntryL,G0H32(1),0,ex5(:),16,G1H16(224),m3h2x16(:,520),heltab2x32(:,:,520))
  Gcoeff(:)%j = (c(57)*M(1,:)%j) * den(14)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(541),h0tab(:,541),[16,3,4,8],[nMW,nMW,nMW,nMW],4,1,wf4(:,14))
  call Hloop_SV_T(ntryL,G0H32(1),0,ex5(:),16,G1H16(225),m3h2x16(:,521),heltab2x32(:,:,521))
  Gcoeff(:)%j = (c(57)*M(1,:)%j) * den(14)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(542),h0tab(:,542),[16,3,4,8],[nMW,nMW,nMW,nMW],4,1,wf4(:,14))
  call Hloop_TV_S(ntryL,G0H32(1),0,ex5(:),16,G1H16(226),m3h2x16(:,522),heltab2x32(:,:,522))
  Gcoeff(:)%j = (-(c(9)*M(1,:)%j)) * den(13)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(543),h0tab(:,543),[16,3,4,8],[nMW,nMW,nMW,nMW],4,1,wf4(:,13))
  call Hloop_SV_T(ntryL,G0H32(1),0,ex5(:),16,G1H16(227),m3h2x16(:,523),heltab2x32(:,:,523))
  Gcoeff(:)%j = (-(c(9)*M(1,:)%j)) * den(13)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(544),h0tab(:,544),[16,3,4,8],[nMW,nMW,nMW,nMW],4,1,wf4(:,13))
  call Hloop_TV_S(ntryL,G0H32(1),0,ex5(:),16,G1H16(228),m3h2x16(:,524),heltab2x32(:,:,524))
  Gcoeff(:)%j = (c(66)*M(1,:)%j) * den(14)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(545),h0tab(:,545),[16,3,4,8],[nMW,nMW,nMW,nMW],4,1,wf4(:,14))
  call Hloop_SV_T(ntryL,G0H32(1),0,ex5(:),16,G1H16(229),m3h2x16(:,525),heltab2x32(:,:,525))
  Gcoeff(:)%j = (c(66)*M(1,:)%j) * den(14)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(546),h0tab(:,546),[16,3,4,8],[nMW,nMW,nMW,nMW],4,1,wf4(:,14))
  call Hloop_TV_S(ntryL,G0H32(1),0,ex5(:),16,G1H16(230),m3h2x16(:,526),heltab2x32(:,:,526))
  Gcoeff(:)%j = (-(c(9)*M(1,:)%j)) * den(13)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(547),h0tab(:,547),[16,3,4,8],[nMW,nMW,nMW,nMW],4,1,wf4(:,13))
  call Hloop_UW_V(ntryL,G0H32(1),0,ex5(:),16,G1H16(231),m3h2x16(:,527),heltab2x32(:,:,527))
  Gcoeff(:)%j = (-(c(9)*M(1,:)%j)) * den(13)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(548),h0tab(:,548),[16,3,4,8],[nMW,nMW,nMW,nMW],4,1,wf4(:,13))
  call Hloop_UV_W(ntryL,G0H32(1),0,ex5(:),16,G1H16(232),m3h2x16(:,528),heltab2x32(:,:,528))
  Gcoeff(:)%j = (c(57)*M(1,:)%j) * den(14)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(549),h0tab(:,549),[16,3,4,8],[nMW,nMW,nMW,nMW],4,1,wf4(:,14))
  call Hloop_UW_V(ntryL,G0H32(1),0,ex5(:),16,G1H16(233),m3h2x16(:,529),heltab2x32(:,:,529))
  Gcoeff(:)%j = (c(57)*M(1,:)%j) * den(14)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(550),h0tab(:,550),[16,3,4,8],[nMW,nMW,nMW,nMW],4,1,wf4(:,14))
  call Hloop_UV_W(ntryL,G0H32(1),0,ex5(:),16,G1H16(234),m3h2x16(:,530),heltab2x32(:,:,530))
  Gcoeff(:)%j = (-(c(9)*M(1,:)%j)) * den(13)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(551),h0tab(:,551),[16,3,4,8],[nMW,nMW,nMW,nMW],4,1,wf4(:,13))
  call Hloop_SV_V(ntryL,G0H32(1),ex5(:),G0H16(93),m3h2x16(:,531),heltab2x32(:,:,531))
  Gcoeff(:)%j = (-(c(9)*M(1,:)%j)) * den(13)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(552),h0tab(:,552),[16,3,4,8],[nMW,nMW,nMW,nMW],4,1,wf4(:,13))
  call Hloop_SV_V(ntryL,G0H32(1),ex5(:),G0H16(94),m3h2x16(:,532),heltab2x32(:,:,532))
  Gcoeff(:)%j = (-(c(55)*M(1,:)%j)) * den(14)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(553),h0tab(:,553),[16,3,4,8],[nMW,nMW,nMW,nMW],4,1,wf4(:,14))
  call Hloop_SV_V(ntryL,G0H32(1),ex5(:),G0H16(95),m3h2x16(:,533),heltab2x32(:,:,533))
  Gcoeff(:)%j = (-(c(55)*M(1,:)%j)) * den(14)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(554),h0tab(:,554),[16,3,4,8],[nMW,nMW,nMW,nMW],4,1,wf4(:,14))
  call Hloop_SV_V(ntryL,G0H32(1),ex5(:),G0H16(96),m3h2x16(:,534),heltab2x32(:,:,534))
  Gcoeff(:)%j = (c(11)*M(1,:)%j) * den(13)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(555),h0tab(:,555),[16,3,4,8],[nMW,nMW,nMW,nMW],4,1,wf4(:,13))
  call Hloop_VV_S(ntryL,G0H32(1),ex5(:),G0H16(97),m3h2x16(:,535),heltab2x32(:,:,535))
  Gcoeff(:)%j = (c(11)*M(1,:)%j) * den(13)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(556),h0tab(:,556),[16,3,4,8],[nMW,nMW,nMW,nMW],4,1,wf4(:,13))
  call Hloop_VV_S(ntryL,G0H32(1),ex5(:),G0H16(98),m3h2x16(:,536),heltab2x32(:,:,536))
  Gcoeff(:)%j = (-(c(59)*M(1,:)%j)) * den(14)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(557),h0tab(:,557),[16,3,4,8],[nMW,nMW,nMW,nMW],4,1,wf4(:,14))
  call Hloop_VV_S(ntryL,G0H32(1),ex5(:),G0H16(99),m3h2x16(:,537),heltab2x32(:,:,537))
  Gcoeff(:)%j = (-(c(59)*M(1,:)%j)) * den(14)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(558),h0tab(:,558),[16,3,4,8],[nMW,nMW,nMW,nMW],4,1,wf4(:,14))
  call Hloop_VV_S(ntryL,G0H32(1),ex5(:),G0H16(100),m3h2x16(:,538),heltab2x32(:,:,538))
  Gcoeff(:)%j = (c(11)*M(1,:)%j) * den(13)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(559),h0tab(:,559),[16,3,4,8],[nMW,nMW,nMW,nMW],4,1,wf4(:,13))
  call Hloop_SV_V(ntryL,G0H32(1),ex5(:),G0H16(101),m3h2x16(:,539),heltab2x32(:,:,539))
  Gcoeff(:)%j = (c(11)*M(1,:)%j) * den(13)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(560),h0tab(:,560),[16,3,4,8],[nMW,nMW,nMW,nMW],4,1,wf4(:,13))
  call Hloop_SV_V(ntryL,G0H32(1),ex5(:),G0H16(102),m3h2x16(:,540),heltab2x32(:,:,540))
  Gcoeff(:)%j = (-(c(59)*M(1,:)%j)) * den(14)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(561),h0tab(:,561),[16,3,4,8],[nMW,nMW,nMW,nMW],4,1,wf4(:,14))
  call Hloop_SV_V(ntryL,G0H32(1),ex5(:),G0H16(103),m3h2x16(:,541),heltab2x32(:,:,541))
  Gcoeff(:)%j = (-(c(59)*M(1,:)%j)) * den(14)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(562),h0tab(:,562),[16,3,4,8],[nMW,nMW,nMW,nMW],4,1,wf4(:,14))
  call Hloop_SV_V(ntryL,G0H32(1),ex5(:),G0H16(104),m3h2x16(:,542),heltab2x32(:,:,542))
  Gcoeff(:)%j = (-(c(9)*M(1,:)%j)) * den(13)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(563),h0tab(:,563),[16,3,4,8],[nMW,nMW,nMW,nMW],4,1,wf4(:,13))
  call Hloop_VV_S(ntryL,G0H32(1),ex5(:),G0H16(105),m3h2x16(:,543),heltab2x32(:,:,543))
  Gcoeff(:)%j = (-(c(9)*M(1,:)%j)) * den(13)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(564),h0tab(:,564),[16,3,4,8],[nMW,nMW,nMW,nMW],4,1,wf4(:,13))
  call Hloop_VV_S(ntryL,G0H32(1),ex5(:),G0H16(106),m3h2x16(:,544),heltab2x32(:,:,544))
  Gcoeff(:)%j = (c(66)*M(1,:)%j) * den(14)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(565),h0tab(:,565),[16,3,4,8],[nMW,nMW,nMW,nMW],4,1,wf4(:,14))
  call Hloop_VV_S(ntryL,G0H32(1),ex5(:),G0H16(107),m3h2x16(:,545),heltab2x32(:,:,545))
  Gcoeff(:)%j = (c(66)*M(1,:)%j) * den(14)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(566),h0tab(:,566),[16,3,4,8],[nMW,nMW,nMW,nMW],4,1,wf4(:,14))
  call Hloop_VV_S(ntryL,G0H32(1),ex5(:),G0H16(108),m3h2x16(:,546),heltab2x32(:,:,546))
  Gcoeff(:)%j = (-(c(9)*M(1,:)%j)) * den(13)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(567),h0tab(:,567),[16,3,4,8],[nMW,nMW,nMW,nMW],4,1,wf4(:,13))
  call Hloop_SV_T(ntryL,G0H32(1),0,ex5(:),16,G1H16(235),m3h2x16(:,547),heltab2x32(:,:,547))
  Gcoeff(:)%j = (-(c(9)*M(1,:)%j)) * den(13)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(568),h0tab(:,568),[16,3,4,8],[nMW,nMW,nMW,nMW],4,1,wf4(:,13))
  call Hloop_TV_S(ntryL,G0H32(1),0,ex5(:),16,G1H16(236),m3h2x16(:,548),heltab2x32(:,:,548))
  Gcoeff(:)%j = (c(57)*M(1,:)%j) * den(14)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(569),h0tab(:,569),[16,3,4,8],[nMW,nMW,nMW,nMW],4,1,wf4(:,14))
  call Hloop_SV_T(ntryL,G0H32(1),0,ex5(:),16,G1H16(237),m3h2x16(:,549),heltab2x32(:,:,549))
  Gcoeff(:)%j = (c(57)*M(1,:)%j) * den(14)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(570),h0tab(:,570),[16,3,4,8],[nMW,nMW,nMW,nMW],4,1,wf4(:,14))
  call Hloop_TV_S(ntryL,G0H32(1),0,ex5(:),16,G1H16(238),m3h2x16(:,550),heltab2x32(:,:,550))
  Gcoeff(:)%j = (-(c(9)*M(1,:)%j)) * den(13)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(571),h0tab(:,571),[16,3,4,8],[nMW,nMW,nMW,nMW],4,1,wf4(:,13))
  call Hloop_UW_V(ntryL,G0H32(1),0,ex5(:),16,G1H16(239),m3h2x16(:,551),heltab2x32(:,:,551))
  Gcoeff(:)%j = (-(c(9)*M(1,:)%j)) * den(13)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(572),h0tab(:,572),[16,3,4,8],[nMW,nMW,nMW,nMW],4,1,wf4(:,13))
  call Hloop_UV_W(ntryL,G0H32(1),0,ex5(:),16,G1H16(240),m3h2x16(:,552),heltab2x32(:,:,552))
  Gcoeff(:)%j = (-(c(55)*M(1,:)%j)) * den(14)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(573),h0tab(:,573),[16,3,4,8],[nMW,nMW,nMW,nMW],4,1,wf4(:,14))
  call Hloop_UW_V(ntryL,G0H32(1),0,ex5(:),16,G1H16(241),m3h2x16(:,553),heltab2x32(:,:,553))
  Gcoeff(:)%j = (-(c(55)*M(1,:)%j)) * den(14)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(574),h0tab(:,574),[16,3,4,8],[nMW,nMW,nMW,nMW],4,1,wf4(:,14))
  call Hloop_UV_W(ntryL,G0H32(1),0,ex5(:),16,G1H16(242),m3h2x16(:,554),heltab2x32(:,:,554))
  Gcoeff(:)%j = (-(c(9)*M(1,:)%j)) * den(13)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(575),h0tab(:,575),[16,3,4,8],[nMW,nMW,nMW,nMW],4,1,wf4(:,13))
  call Hloop_UW_V(ntryL,G0H32(1),0,ex5(:),16,G1H16(243),m3h2x16(:,555),heltab2x32(:,:,555))
  Gcoeff(:)%j = (-(c(9)*M(1,:)%j)) * den(13)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(576),h0tab(:,576),[16,3,4,8],[nMW,nMW,nMW,nMW],4,1,wf4(:,13))
  call Hloop_UV_W(ntryL,G0H32(1),0,ex5(:),16,G1H16(244),m3h2x16(:,556),heltab2x32(:,:,556))
  Gcoeff(:)%j = (c(57)*M(1,:)%j) * den(14)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(577),h0tab(:,577),[16,3,4,8],[nMW,nMW,nMW,nMW],4,1,wf4(:,14))
  call Hloop_UW_V(ntryL,G0H32(1),0,ex5(:),16,G1H16(245),m3h2x16(:,557),heltab2x32(:,:,557))
  Gcoeff(:)%j = (c(57)*M(1,:)%j) * den(14)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(578),h0tab(:,578),[16,3,4,8],[nMW,nMW,nMW,nMW],4,1,wf4(:,14))
  call Hloop_UV_W(ntryL,G0H32(1),0,ex5(:),16,G1H16(246),m3h2x16(:,558),heltab2x32(:,:,558))
  Gcoeff(:)%j = (-(c(9)*M(1,:)%j)) * den(13)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(579),h0tab(:,579),[16,3,4,8],[nMW,nMW,nMW,nMW],4,1,wf4(:,13))
  call Hloop_SV_V(ntryL,G0H32(1),ex5(:),G0H16(109),m3h2x16(:,559),heltab2x32(:,:,559))
  Gcoeff(:)%j = (-(c(9)*M(1,:)%j)) * den(13)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(580),h0tab(:,580),[16,3,4,8],[nMW,nMW,nMW,nMW],4,1,wf4(:,13))
  call Hloop_SV_V(ntryL,G0H32(1),ex5(:),G0H16(110),m3h2x16(:,560),heltab2x32(:,:,560))
  Gcoeff(:)%j = (-(c(55)*M(1,:)%j)) * den(14)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(581),h0tab(:,581),[16,3,4,8],[nMW,nMW,nMW,nMW],4,1,wf4(:,14))
  call Hloop_SV_V(ntryL,G0H32(1),ex5(:),G0H16(111),m3h2x16(:,561),heltab2x32(:,:,561))
  Gcoeff(:)%j = (-(c(55)*M(1,:)%j)) * den(14)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(582),h0tab(:,582),[16,3,4,8],[nMW,nMW,nMW,nMW],4,1,wf4(:,14))
  call Hloop_SV_V(ntryL,G0H32(1),ex5(:),G0H16(112),m3h2x16(:,562),heltab2x32(:,:,562))
  Gcoeff(:)%j = (-(c(9)*M(1,:)%j)) * den(13)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(583),h0tab(:,583),[16,3,4,8],[nMW,nMW,nMW,nMW],4,1,wf4(:,13))
  call Hloop_VV_S(ntryL,G0H32(1),ex5(:),G0H16(113),m3h2x16(:,563),heltab2x32(:,:,563))
  Gcoeff(:)%j = (-(c(9)*M(1,:)%j)) * den(13)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(584),h0tab(:,584),[16,3,4,8],[nMW,nMW,nMW,nMW],4,1,wf4(:,13))
  call Hloop_VV_S(ntryL,G0H32(1),ex5(:),G0H16(114),m3h2x16(:,564),heltab2x32(:,:,564))
  Gcoeff(:)%j = (c(57)*M(1,:)%j) * den(14)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(585),h0tab(:,585),[16,3,4,8],[nMW,nMW,nMW,nMW],4,1,wf4(:,14))
  call Hloop_VV_S(ntryL,G0H32(1),ex5(:),G0H16(115),m3h2x16(:,565),heltab2x32(:,:,565))
  Gcoeff(:)%j = (c(57)*M(1,:)%j) * den(14)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(586),h0tab(:,586),[16,3,4,8],[nMW,nMW,nMW,nMW],4,1,wf4(:,14))
  call Hloop_VV_S(ntryL,G0H32(1),ex5(:),G0H16(116),m3h2x16(:,566),heltab2x32(:,:,566))
  Gcoeff(:)%j = (-(c(84)*M(1,:)%j)) * den(54)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(587),h0tab(:,587),[16,4,3,8],[nME,nME,nME,nME],4,1,wf4(:,36))
  call Hloop_QV_A(ntryL,G0H32(1),ex5(:),G0H16(117),m3h2x16(:,567),heltab2x32(:,:,567))
  call Hloop_Q_A(ntryL,G0H16(117),16,nME,G1H16(247),n2h16(167))
  Gcoeff(:)%j = (-(c(88)*M(1,:)%j)) * den(54)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(588),h0tab(:,588),[16,4,3,8],[nMM,nMM,nMM,nMM],4,1,wf4(:,36))
  call Hloop_QV_A(ntryL,G0H32(1),ex5(:),G0H16(117),m3h2x16(:,568),heltab2x32(:,:,568))
  call Hloop_Q_A(ntryL,G0H16(117),16,nMM,G1H16(248),n2h16(168))
  Gcoeff(:)%j = (-(c(86)*M(1,:)%j)) * den(54)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(589),h0tab(:,589),[16,4,3,8],[nML,nML,nML,nML],4,1,wf4(:,36))
  call Hloop_QV_A(ntryL,G0H32(1),ex5(:),G0H16(117),m3h2x16(:,569),heltab2x32(:,:,569))
  call Hloop_Q_A(ntryL,G0H16(117),16,nML,G1H16(249),n2h16(169))
  Gcoeff(:)%j = (-(c(84)*M(1,:)%j)) * den(54)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(590),h0tab(:,590),[16,4,3,8],[nME,nME,nME,nME],4,1,wf4(:,36))
  call Hloop_AV_Q(ntryL,G0H32(1),ex5(:),G0H16(117),m3h2x16(:,570),heltab2x32(:,:,570))
  call Hloop_A_Q(ntryL,G0H16(117),16,nME,G1H16(250),n2h16(170))
  Gcoeff(:)%j = (-(c(88)*M(1,:)%j)) * den(54)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(591),h0tab(:,591),[16,4,3,8],[nMM,nMM,nMM,nMM],4,1,wf4(:,36))
  call Hloop_AV_Q(ntryL,G0H32(1),ex5(:),G0H16(117),m3h2x16(:,571),heltab2x32(:,:,571))
  call Hloop_A_Q(ntryL,G0H16(117),16,nMM,G1H16(251),n2h16(171))
  Gcoeff(:)%j = (-(c(86)*M(1,:)%j)) * den(54)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(592),h0tab(:,592),[16,4,3,8],[nML,nML,nML,nML],4,1,wf4(:,36))
  call Hloop_AV_Q(ntryL,G0H32(1),ex5(:),G0H16(117),m3h2x16(:,572),heltab2x32(:,:,572))
  call Hloop_A_Q(ntryL,G0H16(117),16,nML,G1H16(252),n2h16(172))
  Gcoeff(:)%j = (c(89)*M(1,:)%j) * den(54)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(593),h0tab(:,593),[16,4,3,8],[nMT,nMT,nMT,nMT],4,1,wf4(:,36))
  call Hloop_QV_A(ntryL,G0H32(1),ex5(:),G0H16(117),m3h2x16(:,573),heltab2x32(:,:,573))
  call Hloop_Q_A(ntryL,G0H16(117),16,nMT,G1H16(253),n2h16(173))
  Gcoeff(:)%j = (c(89)*M(1,:)%j) * den(54)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(594),h0tab(:,594),[16,4,3,8],[nMT,nMT,nMT,nMT],4,1,wf4(:,36))
  call Hloop_AV_Q(ntryL,G0H32(1),ex5(:),G0H16(117),m3h2x16(:,574),heltab2x32(:,:,574))
  call Hloop_A_Q(ntryL,G0H16(117),16,nMT,G1H16(254),n2h16(174))
  Gcoeff(:)%j = (-(c(81)*M(1,:)%j)) * den(54)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(595),h0tab(:,595),[16,4,3,8],[nMB,nMB,nMB,nMB],4,1,wf4(:,36))
  call Hloop_QV_A(ntryL,G0H32(1),ex5(:),G0H16(117),m3h2x16(:,575),heltab2x32(:,:,575))
  call Hloop_Q_A(ntryL,G0H16(117),16,nMB,G1H16(255),n2h16(175))
  Gcoeff(:)%j = (-(c(81)*M(1,:)%j)) * den(54)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(596),h0tab(:,596),[16,4,3,8],[nMB,nMB,nMB,nMB],4,1,wf4(:,36))
  call Hloop_AV_Q(ntryL,G0H32(1),ex5(:),G0H16(117),m3h2x16(:,576),heltab2x32(:,:,576))
  call Hloop_A_Q(ntryL,G0H16(117),16,nMB,G1H16(256),n2h16(176))
  Gcoeff(:)%j = (-(c(84)*M(1,:)%j)) * den(14)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(597),h0tab(:,597),[16,4,3,8],[nME,nME,nME,nME],4,1,wf4(:,37))
  call Hloop_QV_A(ntryL,G0H32(1),ex5(:),G0H16(117),m3h2x16(:,577),heltab2x32(:,:,577))
  call Hloop_Q_A(ntryL,G0H16(117),16,nME,G1H16(257),n2h16(177))
  Gcoeff(:)%j = (-(c(88)*M(1,:)%j)) * den(14)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(598),h0tab(:,598),[16,4,3,8],[nMM,nMM,nMM,nMM],4,1,wf4(:,37))
  call Hloop_QV_A(ntryL,G0H32(1),ex5(:),G0H16(117),m3h2x16(:,578),heltab2x32(:,:,578))
  call Hloop_Q_A(ntryL,G0H16(117),16,nMM,G1H16(258),n2h16(178))
  Gcoeff(:)%j = (-(c(86)*M(1,:)%j)) * den(14)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(599),h0tab(:,599),[16,4,3,8],[nML,nML,nML,nML],4,1,wf4(:,37))
  call Hloop_QV_A(ntryL,G0H32(1),ex5(:),G0H16(117),m3h2x16(:,579),heltab2x32(:,:,579))
  call Hloop_Q_A(ntryL,G0H16(117),16,nML,G1H16(259),n2h16(179))
  Gcoeff(:)%j = (-(c(84)*M(1,:)%j)) * den(14)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(600),h0tab(:,600),[16,4,3,8],[nME,nME,nME,nME],4,1,wf4(:,37))
  call Hloop_AV_Q(ntryL,G0H32(1),ex5(:),G0H16(117),m3h2x16(:,580),heltab2x32(:,:,580))
  call Hloop_A_Q(ntryL,G0H16(117),16,nME,G1H16(260),n2h16(180))
  Gcoeff(:)%j = (-(c(88)*M(1,:)%j)) * den(14)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(601),h0tab(:,601),[16,4,3,8],[nMM,nMM,nMM,nMM],4,1,wf4(:,37))
  call Hloop_AV_Q(ntryL,G0H32(1),ex5(:),G0H16(117),m3h2x16(:,581),heltab2x32(:,:,581))
  call Hloop_A_Q(ntryL,G0H16(117),16,nMM,G1H16(261),n2h16(181))
  Gcoeff(:)%j = (-(c(86)*M(1,:)%j)) * den(14)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(602),h0tab(:,602),[16,4,3,8],[nML,nML,nML,nML],4,1,wf4(:,37))
  call Hloop_AV_Q(ntryL,G0H32(1),ex5(:),G0H16(117),m3h2x16(:,582),heltab2x32(:,:,582))
  call Hloop_A_Q(ntryL,G0H16(117),16,nML,G1H16(262),n2h16(182))
  Gcoeff(:)%j = (-(c(89)*M(1,:)%j)) * den(14)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(603),h0tab(:,603),[16,4,3,8],[nMT,nMT,nMT,nMT],4,1,wf4(:,37))
  call Hloop_QV_A(ntryL,G0H32(1),ex5(:),G0H16(117),m3h2x16(:,583),heltab2x32(:,:,583))
  call Hloop_Q_A(ntryL,G0H16(117),16,nMT,G1H16(263),n2h16(183))
  Gcoeff(:)%j = (-(c(89)*M(1,:)%j)) * den(14)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(604),h0tab(:,604),[16,4,3,8],[nMT,nMT,nMT,nMT],4,1,wf4(:,37))
  call Hloop_AV_Q(ntryL,G0H32(1),ex5(:),G0H16(117),m3h2x16(:,584),heltab2x32(:,:,584))
  call Hloop_A_Q(ntryL,G0H16(117),16,nMT,G1H16(264),n2h16(184))
  Gcoeff(:)%j = (-(c(81)*M(1,:)%j)) * den(14)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(605),h0tab(:,605),[16,4,3,8],[nMB,nMB,nMB,nMB],4,1,wf4(:,37))
  call Hloop_QV_A(ntryL,G0H32(1),ex5(:),G0H16(117),m3h2x16(:,585),heltab2x32(:,:,585))
  call Hloop_Q_A(ntryL,G0H16(117),16,nMB,G1H16(265),n2h16(185))
  Gcoeff(:)%j = (-(c(81)*M(1,:)%j)) * den(14)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(606),h0tab(:,606),[16,4,3,8],[nMB,nMB,nMB,nMB],4,1,wf4(:,37))
  call Hloop_AV_Q(ntryL,G0H32(1),ex5(:),G0H16(117),m3h2x16(:,586),heltab2x32(:,:,586))
  call Hloop_A_Q(ntryL,G0H16(117),16,nMB,G1H16(266),n2h16(186))
  Gcoeff(:)%j = (-(c(42)*M(1,:)%j)) * den(54)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(607),h0tab(:,607),[16,4,3,8],[nMW,nMW,nMW,nMW],4,1,wf4(:,36))
  call Hloop_TV_S(ntryL,G0H32(1),0,ex5(:),16,G1H16(267),m3h2x16(:,587),heltab2x32(:,:,587))
  Gcoeff(:)%j = (-(c(42)*M(1,:)%j)) * den(54)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(608),h0tab(:,608),[16,4,3,8],[nMW,nMW,nMW,nMW],4,1,wf4(:,36))
  call Hloop_SV_T(ntryL,G0H32(1),0,ex5(:),16,G1H16(268),m3h2x16(:,588),heltab2x32(:,:,588))
  Gcoeff(:)%j = (-(c(24)*M(1,:)%j)) * den(54)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(609),h0tab(:,609),[16,4,3,8],[nMW,nMW,nMW,nMW],4,1,wf4(:,36))
  call Hloop_CV_D(ntryL,G0H32(1),0,ex5(:),16,G1H16(269),m3h2x16(:,589),heltab2x32(:,:,589))
  Gcoeff(:)%j = (-(c(24)*M(1,:)%j)) * den(54)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(610),h0tab(:,610),[16,4,3,8],[nMW,nMW,nMW,nMW],4,1,wf4(:,36))
  call Hloop_DV_C(ntryL,G0H32(1),0,ex5(:),G1H16(270),m3h2x16(:,590),heltab2x32(:,:,590))
  Gcoeff(:)%j = (c(24)*M(1,:)%j) * den(54)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(611),h0tab(:,611),[16,4,3,8],[nMW,nMW,nMW,nMW],4,1,wf4(:,36))
  call Hloop_CV_D(ntryL,G0H32(1),0,ex5(:),16,G1H16(271),m3h2x16(:,591),heltab2x32(:,:,591))
  Gcoeff(:)%j = (c(24)*M(1,:)%j) * den(54)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(612),h0tab(:,612),[16,4,3,8],[nMW,nMW,nMW,nMW],4,1,wf4(:,36))
  call Hloop_DV_C(ntryL,G0H32(1),0,ex5(:),G1H16(272),m3h2x16(:,592),heltab2x32(:,:,592))
  Gcoeff(:)%j = (-(c(24)*M(1,:)%j)) * den(14)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(613),h0tab(:,613),[16,4,3,8],[nMW,nMW,nMW,nMW],4,1,wf4(:,37))
  call Hloop_CV_D(ntryL,G0H32(1),0,ex5(:),16,G1H16(273),m3h2x16(:,593),heltab2x32(:,:,593))
  Gcoeff(:)%j = (-(c(24)*M(1,:)%j)) * den(14)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(614),h0tab(:,614),[16,4,3,8],[nMW,nMW,nMW,nMW],4,1,wf4(:,37))
  call Hloop_DV_C(ntryL,G0H32(1),0,ex5(:),G1H16(274),m3h2x16(:,594),heltab2x32(:,:,594))
  Gcoeff(:)%j = (-(c(24)*M(1,:)%j)) * den(14)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(615),h0tab(:,615),[16,4,3,8],[nMW,nMW,nMW,nMW],4,1,wf4(:,37))
  call Hloop_CV_D(ntryL,G0H32(1),0,ex5(:),16,G1H16(275),m3h2x16(:,595),heltab2x32(:,:,595))
  Gcoeff(:)%j = (-(c(24)*M(1,:)%j)) * den(14)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(616),h0tab(:,616),[16,4,3,8],[nMW,nMW,nMW,nMW],4,1,wf4(:,37))
  call Hloop_DV_C(ntryL,G0H32(1),0,ex5(:),G1H16(276),m3h2x16(:,596),heltab2x32(:,:,596))
  Gcoeff(:)%j = (-(c(26)*M(1,:)%j)) * den(54)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(617),h0tab(:,617),[16,4,3,8],[nMW,nMW,nMW,nMW],4,1,wf4(:,36))
  call Hloop_UV_W(ntryL,G0H32(1),0,ex5(:),16,G1H16(277),m3h2x16(:,597),heltab2x32(:,:,597))
  Gcoeff(:)%j = (-(c(26)*M(1,:)%j)) * den(54)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(618),h0tab(:,618),[16,4,3,8],[nMW,nMW,nMW,nMW],4,1,wf4(:,36))
  call Hloop_UW_V(ntryL,G0H32(1),0,ex5(:),16,G1H16(278),m3h2x16(:,598),heltab2x32(:,:,598))
  Gcoeff(:)%j = (c(24)*M(1,:)%j) * den(54)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(619),h0tab(:,619),[16,4,3,8],[nMW,nMW,nMW,nMW],4,1,wf4(:,36))
  call Hloop_TV_S(ntryL,G0H32(1),0,ex5(:),16,G1H16(279),m3h2x16(:,599),heltab2x32(:,:,599))
  Gcoeff(:)%j = (-(c(24)*M(1,:)%j)) * den(54)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(620),h0tab(:,620),[16,4,3,8],[nMW,nMW,nMW,nMW],4,1,wf4(:,36))
  call Hloop_SV_T(ntryL,G0H32(1),0,ex5(:),16,G1H16(280),m3h2x16(:,600),heltab2x32(:,:,600))
  Gcoeff(:)%j = (-(c(24)*M(1,:)%j)) * den(14)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(621),h0tab(:,621),[16,4,3,8],[nMW,nMW,nMW,nMW],4,1,wf4(:,37))
  call Hloop_TV_S(ntryL,G0H32(1),0,ex5(:),16,G1H16(281),m3h2x16(:,601),heltab2x32(:,:,601))
  Gcoeff(:)%j = (-(c(24)*M(1,:)%j)) * den(14)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(622),h0tab(:,622),[16,4,3,8],[nMW,nMW,nMW,nMW],4,1,wf4(:,37))
  call Hloop_SV_T(ntryL,G0H32(1),0,ex5(:),16,G1H16(282),m3h2x16(:,602),heltab2x32(:,:,602))
  Gcoeff(:)%j = (c(28)*M(1,:)%j) * den(54)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(623),h0tab(:,623),[16,4,3,8],[nMW,nMW,nMW,nMW],4,1,wf4(:,36))
  call Hloop_VV_S(ntryL,G0H32(1),ex5(:),G0H16(117),m3h2x16(:,603),heltab2x32(:,:,603))
  Gcoeff(:)%j = (c(28)*M(1,:)%j) * den(54)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(624),h0tab(:,624),[16,4,3,8],[nMW,nMW,nMW,nMW],4,1,wf4(:,36))
  call Hloop_VV_S(ntryL,G0H32(1),ex5(:),G0H16(118),m3h2x16(:,604),heltab2x32(:,:,604))
  Gcoeff(:)%j = (-(c(24)*M(1,:)%j)) * den(54)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(625),h0tab(:,625),[16,4,3,8],[nMW,nMW,nMW,nMW],4,1,wf4(:,36))
  call Hloop_TV_S(ntryL,G0H32(1),0,ex5(:),16,G1H16(283),m3h2x16(:,605),heltab2x32(:,:,605))
  Gcoeff(:)%j = (c(24)*M(1,:)%j) * den(54)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(626),h0tab(:,626),[16,4,3,8],[nMW,nMW,nMW,nMW],4,1,wf4(:,36))
  call Hloop_SV_T(ntryL,G0H32(1),0,ex5(:),16,G1H16(284),m3h2x16(:,606),heltab2x32(:,:,606))
  Gcoeff(:)%j = (-(c(24)*M(1,:)%j)) * den(14)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(627),h0tab(:,627),[16,4,3,8],[nMW,nMW,nMW,nMW],4,1,wf4(:,37))
  call Hloop_TV_S(ntryL,G0H32(1),0,ex5(:),16,G1H16(285),m3h2x16(:,607),heltab2x32(:,:,607))
  Gcoeff(:)%j = (-(c(24)*M(1,:)%j)) * den(14)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(628),h0tab(:,628),[16,4,3,8],[nMW,nMW,nMW,nMW],4,1,wf4(:,37))
  call Hloop_SV_T(ntryL,G0H32(1),0,ex5(:),16,G1H16(286),m3h2x16(:,608),heltab2x32(:,:,608))
  Gcoeff(:)%j = (c(28)*M(1,:)%j) * den(54)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(629),h0tab(:,629),[16,4,3,8],[nMW,nMW,nMW,nMW],4,1,wf4(:,36))
  call Hloop_SV_V(ntryL,G0H32(1),ex5(:),G0H16(119),m3h2x16(:,609),heltab2x32(:,:,609))
  Gcoeff(:)%j = (c(28)*M(1,:)%j) * den(54)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(630),h0tab(:,630),[16,4,3,8],[nMW,nMW,nMW,nMW],4,1,wf4(:,36))
  call Hloop_SV_V(ntryL,G0H32(1),ex5(:),G0H16(120),m3h2x16(:,610),heltab2x32(:,:,610))
  Gcoeff(:)%j = (c(24)*M(1,:)%j) * den(54)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(631),h0tab(:,631),[16,4,3,8],[nMW,nMW,nMW,nMW],4,1,wf4(:,36))
  call Hloop_VV_S(ntryL,G0H32(1),ex5(:),G0H16(121),m3h2x16(:,611),heltab2x32(:,:,611))
  Gcoeff(:)%j = (-(c(24)*M(1,:)%j)) * den(54)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(632),h0tab(:,632),[16,4,3,8],[nMW,nMW,nMW,nMW],4,1,wf4(:,36))
  call Hloop_VV_S(ntryL,G0H32(1),ex5(:),G0H16(122),m3h2x16(:,612),heltab2x32(:,:,612))
  Gcoeff(:)%j = (-(c(24)*M(1,:)%j)) * den(14)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(633),h0tab(:,633),[16,4,3,8],[nMW,nMW,nMW,nMW],4,1,wf4(:,37))
  call Hloop_VV_S(ntryL,G0H32(1),ex5(:),G0H16(123),m3h2x16(:,613),heltab2x32(:,:,613))
  Gcoeff(:)%j = (-(c(24)*M(1,:)%j)) * den(14)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(634),h0tab(:,634),[16,4,3,8],[nMW,nMW,nMW,nMW],4,1,wf4(:,37))
  call Hloop_VV_S(ntryL,G0H32(1),ex5(:),G0H16(124),m3h2x16(:,614),heltab2x32(:,:,614))
  Gcoeff(:)%j = (c(51)*M(1,:)%j) * den(54)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(635),h0tab(:,635),[16,4,3,8],[nMW,nMW,nMW,nMW],4,1,wf4(:,36))
  call Hloop_TV_S(ntryL,G0H32(1),0,ex5(:),16,G1H16(287),m3h2x16(:,615),heltab2x32(:,:,615))
  Gcoeff(:)%j = (c(51)*M(1,:)%j) * den(54)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(636),h0tab(:,636),[16,4,3,8],[nMW,nMW,nMW,nMW],4,1,wf4(:,36))
  call Hloop_SV_T(ntryL,G0H32(1),0,ex5(:),16,G1H16(288),m3h2x16(:,616),heltab2x32(:,:,616))
  Gcoeff(:)%j = (c(49)*M(1,:)%j) * den(54)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(637),h0tab(:,637),[16,4,3,8],[nMW,nMW,nMW,nMW],4,1,wf4(:,36))
  call Hloop_VV_S(ntryL,G0H32(1),ex5(:),G0H16(125),m3h2x16(:,617),heltab2x32(:,:,617))
  Gcoeff(:)%j = (-(c(49)*M(1,:)%j)) * den(54)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(638),h0tab(:,638),[16,4,3,8],[nMW,nMW,nMW,nMW],4,1,wf4(:,36))
  call Hloop_VV_S(ntryL,G0H32(1),ex5(:),G0H16(126),m3h2x16(:,618),heltab2x32(:,:,618))
  Gcoeff(:)%j = (c(49)*M(1,:)%j) * den(14)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(639),h0tab(:,639),[16,4,3,8],[nMW,nMW,nMW,nMW],4,1,wf4(:,37))
  call Hloop_VV_S(ntryL,G0H32(1),ex5(:),G0H16(127),m3h2x16(:,619),heltab2x32(:,:,619))
  Gcoeff(:)%j = (c(49)*M(1,:)%j) * den(14)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(640),h0tab(:,640),[16,4,3,8],[nMW,nMW,nMW,nMW],4,1,wf4(:,37))
  call Hloop_VV_S(ntryL,G0H32(1),ex5(:),G0H16(128),m3h2x16(:,620),heltab2x32(:,:,620))
  Gcoeff(:)%j = (-(c(49)*M(1,:)%j)) * den(54)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(641),h0tab(:,641),[16,4,3,8],[nMW,nMW,nMW,nMW],4,1,wf4(:,36))
  call Hloop_SV_V(ntryL,G0H32(1),ex5(:),G0H16(129),m3h2x16(:,621),heltab2x32(:,:,621))
  Gcoeff(:)%j = (c(49)*M(1,:)%j) * den(54)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(642),h0tab(:,642),[16,4,3,8],[nMW,nMW,nMW,nMW],4,1,wf4(:,36))
  call Hloop_SV_V(ntryL,G0H32(1),ex5(:),G0H16(130),m3h2x16(:,622),heltab2x32(:,:,622))
  Gcoeff(:)%j = (c(49)*M(1,:)%j) * den(14)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(643),h0tab(:,643),[16,4,3,8],[nMW,nMW,nMW,nMW],4,1,wf4(:,37))
  call Hloop_SV_V(ntryL,G0H32(1),ex5(:),G0H16(131),m3h2x16(:,623),heltab2x32(:,:,623))
  Gcoeff(:)%j = (c(49)*M(1,:)%j) * den(14)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(644),h0tab(:,644),[16,4,3,8],[nMW,nMW,nMW,nMW],4,1,wf4(:,37))
  call Hloop_SV_V(ntryL,G0H32(1),ex5(:),G0H16(132),m3h2x16(:,624),heltab2x32(:,:,624))
  Gcoeff(:)%j = (c(28)*M(1,:)%j) * den(54)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(645),h0tab(:,645),[16,4,3,8],[nMW,nMW,nMW,nMW],4,1,wf4(:,36))
  call Hloop_UV_W(ntryL,G0H32(1),0,ex5(:),16,G1H16(289),m3h2x16(:,625),heltab2x32(:,:,625))
  Gcoeff(:)%j = (c(28)*M(1,:)%j) * den(54)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(646),h0tab(:,646),[16,4,3,8],[nMW,nMW,nMW,nMW],4,1,wf4(:,36))
  call Hloop_UW_V(ntryL,G0H32(1),0,ex5(:),16,G1H16(290),m3h2x16(:,626),heltab2x32(:,:,626))
  Gcoeff(:)%j = (-(c(24)*M(1,:)%j)) * den(54)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(647),h0tab(:,647),[16,4,3,8],[nMW,nMW,nMW,nMW],4,1,wf4(:,36))
  call Hloop_SV_V(ntryL,G0H32(1),ex5(:),G0H16(133),m3h2x16(:,627),heltab2x32(:,:,627))
  Gcoeff(:)%j = (c(24)*M(1,:)%j) * den(54)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(648),h0tab(:,648),[16,4,3,8],[nMW,nMW,nMW,nMW],4,1,wf4(:,36))
  call Hloop_SV_V(ntryL,G0H32(1),ex5(:),G0H16(134),m3h2x16(:,628),heltab2x32(:,:,628))
  Gcoeff(:)%j = (-(c(24)*M(1,:)%j)) * den(14)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(649),h0tab(:,649),[16,4,3,8],[nMW,nMW,nMW,nMW],4,1,wf4(:,37))
  call Hloop_SV_V(ntryL,G0H32(1),ex5(:),G0H16(135),m3h2x16(:,629),heltab2x32(:,:,629))
  Gcoeff(:)%j = (-(c(24)*M(1,:)%j)) * den(14)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(650),h0tab(:,650),[16,4,3,8],[nMW,nMW,nMW,nMW],4,1,wf4(:,37))
  call Hloop_SV_V(ntryL,G0H32(1),ex5(:),G0H16(136),m3h2x16(:,630),heltab2x32(:,:,630))
  Gcoeff(:)%j = (c(51)*M(1,:)%j) * den(54)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(651),h0tab(:,651),[16,4,3,8],[nMW,nMW,nMW,nMW],4,1,wf4(:,36))
  call Hloop_VV_S(ntryL,G0H32(1),ex5(:),G0H16(137),m3h2x16(:,631),heltab2x32(:,:,631))
  Gcoeff(:)%j = (c(51)*M(1,:)%j) * den(54)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(652),h0tab(:,652),[16,4,3,8],[nMW,nMW,nMW,nMW],4,1,wf4(:,36))
  call Hloop_VV_S(ntryL,G0H32(1),ex5(:),G0H16(138),m3h2x16(:,632),heltab2x32(:,:,632))
  Gcoeff(:)%j = (c(24)*M(1,:)%j) * den(54)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(653),h0tab(:,653),[16,4,3,8],[nMW,nMW,nMW,nMW],4,1,wf4(:,36))
  call Hloop_UV_W(ntryL,G0H32(1),0,ex5(:),16,G1H16(291),m3h2x16(:,633),heltab2x32(:,:,633))
  Gcoeff(:)%j = (-(c(24)*M(1,:)%j)) * den(54)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(654),h0tab(:,654),[16,4,3,8],[nMW,nMW,nMW,nMW],4,1,wf4(:,36))
  call Hloop_UW_V(ntryL,G0H32(1),0,ex5(:),16,G1H16(292),m3h2x16(:,634),heltab2x32(:,:,634))
  Gcoeff(:)%j = (-(c(24)*M(1,:)%j)) * den(14)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(655),h0tab(:,655),[16,4,3,8],[nMW,nMW,nMW,nMW],4,1,wf4(:,37))
  call Hloop_UV_W(ntryL,G0H32(1),0,ex5(:),16,G1H16(293),m3h2x16(:,635),heltab2x32(:,:,635))
  Gcoeff(:)%j = (-(c(24)*M(1,:)%j)) * den(14)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(656),h0tab(:,656),[16,4,3,8],[nMW,nMW,nMW,nMW],4,1,wf4(:,37))
  call Hloop_UW_V(ntryL,G0H32(1),0,ex5(:),16,G1H16(294),m3h2x16(:,636),heltab2x32(:,:,636))
  Gcoeff(:)%j = (c(51)*M(1,:)%j) * den(54)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(657),h0tab(:,657),[16,4,3,8],[nMW,nMW,nMW,nMW],4,1,wf4(:,36))
  call Hloop_SV_V(ntryL,G0H32(1),ex5(:),G0H16(139),m3h2x16(:,637),heltab2x32(:,:,637))
  Gcoeff(:)%j = (c(51)*M(1,:)%j) * den(54)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(658),h0tab(:,658),[16,4,3,8],[nMW,nMW,nMW,nMW],4,1,wf4(:,36))
  call Hloop_SV_V(ntryL,G0H32(1),ex5(:),G0H16(140),m3h2x16(:,638),heltab2x32(:,:,638))
  Gcoeff(:)%j = (-(c(24)*M(1,:)%j)) * den(54)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(659),h0tab(:,659),[16,4,3,8],[nMW,nMW,nMW,nMW],4,1,wf4(:,36))
  call Hloop_UV_W(ntryL,G0H32(1),0,ex5(:),16,G1H16(295),m3h2x16(:,639),heltab2x32(:,:,639))
  Gcoeff(:)%j = (c(24)*M(1,:)%j) * den(54)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(660),h0tab(:,660),[16,4,3,8],[nMW,nMW,nMW,nMW],4,1,wf4(:,36))
  call Hloop_UW_V(ntryL,G0H32(1),0,ex5(:),16,G1H16(296),m3h2x16(:,640),heltab2x32(:,:,640))
  Gcoeff(:)%j = (-(c(24)*M(1,:)%j)) * den(14)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(661),h0tab(:,661),[16,4,3,8],[nMW,nMW,nMW,nMW],4,1,wf4(:,37))
  call Hloop_UV_W(ntryL,G0H32(1),0,ex5(:),16,G1H16(297),m3h2x16(:,641),heltab2x32(:,:,641))
  Gcoeff(:)%j = (-(c(24)*M(1,:)%j)) * den(14)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(662),h0tab(:,662),[16,4,3,8],[nMW,nMW,nMW,nMW],4,1,wf4(:,37))
  call Hloop_UW_V(ntryL,G0H32(1),0,ex5(:),16,G1H16(298),m3h2x16(:,642),heltab2x32(:,:,642))
  Gcoeff(:)%j = (-(c(79)*M(1,:)%j)) * den(13)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(663),h0tab(:,663),[16,4,3,8],[nME,nME,nME,nME],4,1,wf4(:,13))
  call Hloop_QV_A(ntryL,G0H32(1),ex5(:),G0H16(141),m3h2x16(:,643),heltab2x32(:,:,643))
  call Hloop_Q_A(ntryL,G0H16(141),16,nME,G1H16(299),n2h16(187))
  Gcoeff(:)%j = (-(c(79)*M(1,:)%j)) * den(13)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(664),h0tab(:,664),[16,4,3,8],[nMM,nMM,nMM,nMM],4,1,wf4(:,13))
  call Hloop_QV_A(ntryL,G0H32(1),ex5(:),G0H16(141),m3h2x16(:,644),heltab2x32(:,:,644))
  call Hloop_Q_A(ntryL,G0H16(141),16,nMM,G1H16(300),n2h16(188))
  Gcoeff(:)%j = (-(c(79)*M(1,:)%j)) * den(13)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(665),h0tab(:,665),[16,4,3,8],[nML,nML,nML,nML],4,1,wf4(:,13))
  call Hloop_QV_A(ntryL,G0H32(1),ex5(:),G0H16(141),m3h2x16(:,645),heltab2x32(:,:,645))
  call Hloop_Q_A(ntryL,G0H16(141),16,nML,G1H16(301),n2h16(189))
  Gcoeff(:)%j = (-(c(79)*M(1,:)%j)) * den(13)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(666),h0tab(:,666),[16,4,3,8],[nME,nME,nME,nME],4,1,wf4(:,13))
  call Hloop_AV_Q(ntryL,G0H32(1),ex5(:),G0H16(141),m3h2x16(:,646),heltab2x32(:,:,646))
  call Hloop_A_Q(ntryL,G0H16(141),16,nME,G1H16(302),n2h16(190))
  Gcoeff(:)%j = (-(c(79)*M(1,:)%j)) * den(13)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(667),h0tab(:,667),[16,4,3,8],[nMM,nMM,nMM,nMM],4,1,wf4(:,13))
  call Hloop_AV_Q(ntryL,G0H32(1),ex5(:),G0H16(141),m3h2x16(:,647),heltab2x32(:,:,647))
  call Hloop_A_Q(ntryL,G0H16(141),16,nMM,G1H16(303),n2h16(191))
  Gcoeff(:)%j = (-(c(79)*M(1,:)%j)) * den(13)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(668),h0tab(:,668),[16,4,3,8],[nML,nML,nML,nML],4,1,wf4(:,13))
  call Hloop_AV_Q(ntryL,G0H32(1),ex5(:),G0H16(141),m3h2x16(:,648),heltab2x32(:,:,648))
  call Hloop_A_Q(ntryL,G0H16(141),16,nML,G1H16(304),n2h16(192))
  Gcoeff(:)%j = (-(c(75)*M(1,:)%j)) * den(13)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(669),h0tab(:,669),[16,4,3,8],[0,0,0,0],4,1,wf4(:,13))
  call Hloop_QV_A(ntryL,G0H32(1),ex5(:),G0H16(141),m3h2x16(:,649),heltab2x32(:,:,649))
  call Hloop_Q_A(ntryL,G0H16(141),16,0,G1H16(305),n2h16(193))
  Gcoeff(:)%j = (-(c(73)*M(1,:)%j)) * den(13)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(670),h0tab(:,670),[16,4,3,8],[nMT,nMT,nMT,nMT],4,1,wf4(:,13))
  call Hloop_QV_A(ntryL,G0H32(1),ex5(:),G0H16(141),m3h2x16(:,650),heltab2x32(:,:,650))
  call Hloop_Q_A(ntryL,G0H16(141),16,nMT,G1H16(306),n2h16(194))
  Gcoeff(:)%j = (-(c(75)*M(1,:)%j)) * den(13)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(671),h0tab(:,671),[16,4,3,8],[0,0,0,0],4,1,wf4(:,13))
  call Hloop_AV_Q(ntryL,G0H32(1),ex5(:),G0H16(141),m3h2x16(:,651),heltab2x32(:,:,651))
  call Hloop_A_Q(ntryL,G0H16(141),16,0,G1H16(307),n2h16(195))
  Gcoeff(:)%j = (-(c(73)*M(1,:)%j)) * den(13)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(672),h0tab(:,672),[16,4,3,8],[nMT,nMT,nMT,nMT],4,1,wf4(:,13))
  call Hloop_AV_Q(ntryL,G0H32(1),ex5(:),G0H16(141),m3h2x16(:,652),heltab2x32(:,:,652))
  call Hloop_A_Q(ntryL,G0H16(141),16,nMT,G1H16(308),n2h16(196))
  Gcoeff(:)%j = (-(c(69)*M(1,:)%j)) * den(13)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(673),h0tab(:,673),[16,4,3,8],[0,0,0,0],4,1,wf4(:,13))
  call Hloop_QV_A(ntryL,G0H32(1),ex5(:),G0H16(141),m3h2x16(:,653),heltab2x32(:,:,653))
  call Hloop_Q_A(ntryL,G0H16(141),16,0,G1H16(309),n2h16(197))
  Gcoeff(:)%j = (-(c(68)*M(1,:)%j)) * den(13)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(674),h0tab(:,674),[16,4,3,8],[nMB,nMB,nMB,nMB],4,1,wf4(:,13))
  call Hloop_QV_A(ntryL,G0H32(1),ex5(:),G0H16(141),m3h2x16(:,654),heltab2x32(:,:,654))
  call Hloop_Q_A(ntryL,G0H16(141),16,nMB,G1H16(310),n2h16(198))
  Gcoeff(:)%j = (-(c(69)*M(1,:)%j)) * den(13)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(675),h0tab(:,675),[16,4,3,8],[0,0,0,0],4,1,wf4(:,13))
  call Hloop_AV_Q(ntryL,G0H32(1),ex5(:),G0H16(141),m3h2x16(:,655),heltab2x32(:,:,655))
  call Hloop_A_Q(ntryL,G0H16(141),16,0,G1H16(311),n2h16(199))
  Gcoeff(:)%j = (-(c(68)*M(1,:)%j)) * den(13)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(676),h0tab(:,676),[16,4,3,8],[nMB,nMB,nMB,nMB],4,1,wf4(:,13))
  call Hloop_AV_Q(ntryL,G0H32(1),ex5(:),G0H16(141),m3h2x16(:,656),heltab2x32(:,:,656))
  call Hloop_A_Q(ntryL,G0H16(141),16,nMB,G1H16(312),n2h16(200))
  Gcoeff(:)%j = (c(80)*M(1,:)%j) * den(14)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(677),h0tab(:,677),[16,4,3,8],[nME,nME,nME,nME],4,1,wf4(:,14))
  call Hloop_QV_A(ntryL,G0H32(1),ex5(:),G0H16(141),m3h2x16(:,657),heltab2x32(:,:,657))
  call Hloop_Q_A(ntryL,G0H16(141),16,nME,G1H16(313),n2h16(201))
  Gcoeff(:)%j = (c(80)*M(1,:)%j) * den(14)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(678),h0tab(:,678),[16,4,3,8],[nMM,nMM,nMM,nMM],4,1,wf4(:,14))
  call Hloop_QV_A(ntryL,G0H32(1),ex5(:),G0H16(141),m3h2x16(:,658),heltab2x32(:,:,658))
  call Hloop_Q_A(ntryL,G0H16(141),16,nMM,G1H16(314),n2h16(202))
  Gcoeff(:)%j = (c(80)*M(1,:)%j) * den(14)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(679),h0tab(:,679),[16,4,3,8],[nML,nML,nML,nML],4,1,wf4(:,14))
  call Hloop_QV_A(ntryL,G0H32(1),ex5(:),G0H16(141),m3h2x16(:,659),heltab2x32(:,:,659))
  call Hloop_Q_A(ntryL,G0H16(141),16,nML,G1H16(315),n2h16(203))
  Gcoeff(:)%j = (c(80)*M(1,:)%j) * den(14)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(680),h0tab(:,680),[16,4,3,8],[nME,nME,nME,nME],4,1,wf4(:,14))
  call Hloop_AV_Q(ntryL,G0H32(1),ex5(:),G0H16(141),m3h2x16(:,660),heltab2x32(:,:,660))
  call Hloop_A_Q(ntryL,G0H16(141),16,nME,G1H16(316),n2h16(204))
  Gcoeff(:)%j = (c(80)*M(1,:)%j) * den(14)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(681),h0tab(:,681),[16,4,3,8],[nMM,nMM,nMM,nMM],4,1,wf4(:,14))
  call Hloop_AV_Q(ntryL,G0H32(1),ex5(:),G0H16(141),m3h2x16(:,661),heltab2x32(:,:,661))
  call Hloop_A_Q(ntryL,G0H16(141),16,nMM,G1H16(317),n2h16(205))
  Gcoeff(:)%j = (c(80)*M(1,:)%j) * den(14)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(682),h0tab(:,682),[16,4,3,8],[nML,nML,nML,nML],4,1,wf4(:,14))
  call Hloop_AV_Q(ntryL,G0H32(1),ex5(:),G0H16(141),m3h2x16(:,662),heltab2x32(:,:,662))
  call Hloop_A_Q(ntryL,G0H16(141),16,nML,G1H16(318),n2h16(206))
  Gcoeff(:)%j = (-(c(78)*M(1,:)%j)) * den(14)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(683),h0tab(:,683),[16,4,3,8],[0,0,0,0],4,1,wf4(:,14))
  call Hloop_QV_A(ntryL,G0H32(1),ex5(:),G0H16(141),m3h2x16(:,663),heltab2x32(:,:,663))
  call Hloop_Q_A(ntryL,G0H16(141),16,0,G1H16(319),n2h16(207))
  Gcoeff(:)%j = (-(c(76)*M(1,:)%j)) * den(14)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(684),h0tab(:,684),[16,4,3,8],[nMT,nMT,nMT,nMT],4,1,wf4(:,14))
  call Hloop_QV_A(ntryL,G0H32(1),ex5(:),G0H16(141),m3h2x16(:,664),heltab2x32(:,:,664))
  call Hloop_Q_A(ntryL,G0H16(141),16,nMT,G1H16(320),n2h16(208))
  Gcoeff(:)%j = (-(c(78)*M(1,:)%j)) * den(14)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(685),h0tab(:,685),[16,4,3,8],[0,0,0,0],4,1,wf4(:,14))
  call Hloop_AV_Q(ntryL,G0H32(1),ex5(:),G0H16(141),m3h2x16(:,665),heltab2x32(:,:,665))
  call Hloop_A_Q(ntryL,G0H16(141),16,0,G1H16(321),n2h16(209))
  Gcoeff(:)%j = (-(c(76)*M(1,:)%j)) * den(14)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(686),h0tab(:,686),[16,4,3,8],[nMT,nMT,nMT,nMT],4,1,wf4(:,14))
  call Hloop_AV_Q(ntryL,G0H32(1),ex5(:),G0H16(141),m3h2x16(:,666),heltab2x32(:,:,666))
  call Hloop_A_Q(ntryL,G0H16(141),16,nMT,G1H16(322),n2h16(210))
  Gcoeff(:)%j = (c(72)*M(1,:)%j) * den(14)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(687),h0tab(:,687),[16,4,3,8],[0,0,0,0],4,1,wf4(:,14))
  call Hloop_QV_A(ntryL,G0H32(1),ex5(:),G0H16(141),m3h2x16(:,667),heltab2x32(:,:,667))
  call Hloop_Q_A(ntryL,G0H16(141),16,0,G1H16(323),n2h16(211))
  Gcoeff(:)%j = (c(71)*M(1,:)%j) * den(14)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(688),h0tab(:,688),[16,4,3,8],[nMB,nMB,nMB,nMB],4,1,wf4(:,14))
  call Hloop_QV_A(ntryL,G0H32(1),ex5(:),G0H16(141),m3h2x16(:,668),heltab2x32(:,:,668))
  call Hloop_Q_A(ntryL,G0H16(141),16,nMB,G1H16(324),n2h16(212))
  Gcoeff(:)%j = (c(72)*M(1,:)%j) * den(14)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(689),h0tab(:,689),[16,4,3,8],[0,0,0,0],4,1,wf4(:,14))
  call Hloop_AV_Q(ntryL,G0H32(1),ex5(:),G0H16(141),m3h2x16(:,669),heltab2x32(:,:,669))
  call Hloop_A_Q(ntryL,G0H16(141),16,0,G1H16(325),n2h16(213))
  Gcoeff(:)%j = (c(71)*M(1,:)%j) * den(14)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(690),h0tab(:,690),[16,4,3,8],[nMB,nMB,nMB,nMB],4,1,wf4(:,14))
  call Hloop_AV_Q(ntryL,G0H32(1),ex5(:),G0H16(141),m3h2x16(:,670),heltab2x32(:,:,670))
  call Hloop_A_Q(ntryL,G0H16(141),16,nMB,G1H16(326),n2h16(214))
  Gcoeff(:)%j = (c(4)*M(1,:)%j) * den(13)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(691),h0tab(:,691),[16,4,3,8],[nMW,nMW,nMW,nMW],4,1,wf4(:,13))
  call Hloop_TV_S(ntryL,G0H32(1),0,ex5(:),16,G1H16(327),m3h2x16(:,671),heltab2x32(:,:,671))
  Gcoeff(:)%j = (c(4)*M(1,:)%j) * den(13)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(692),h0tab(:,692),[16,4,3,8],[nMW,nMW,nMW,nMW],4,1,wf4(:,13))
  call Hloop_SV_T(ntryL,G0H32(1),0,ex5(:),16,G1H16(328),m3h2x16(:,672),heltab2x32(:,:,672))
  Gcoeff(:)%j = (-(c(61)*M(1,:)%j)) * den(14)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(693),h0tab(:,693),[16,4,3,8],[nMW,nMW,nMW,nMW],4,1,wf4(:,14))
  call Hloop_TV_S(ntryL,G0H32(1),0,ex5(:),16,G1H16(329),m3h2x16(:,673),heltab2x32(:,:,673))
  Gcoeff(:)%j = (-(c(61)*M(1,:)%j)) * den(14)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(694),h0tab(:,694),[16,4,3,8],[nMW,nMW,nMW,nMW],4,1,wf4(:,14))
  call Hloop_SV_T(ntryL,G0H32(1),0,ex5(:),16,G1H16(330),m3h2x16(:,674),heltab2x32(:,:,674))
  Gcoeff(:)%j = (-(c(4)*M(1,:)%j)) * den(13)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(695),h0tab(:,695),[16,4,3,8],[nMW,nMW,nMW,nMW],4,1,wf4(:,13))
  call Hloop_CV_D(ntryL,G0H32(1),0,ex5(:),16,G1H16(331),m3h2x16(:,675),heltab2x32(:,:,675))
  Gcoeff(:)%j = (-(c(4)*M(1,:)%j)) * den(13)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(696),h0tab(:,696),[16,4,3,8],[nMW,nMW,nMW,nMW],4,1,wf4(:,13))
  call Hloop_DV_C(ntryL,G0H32(1),0,ex5(:),G1H16(332),m3h2x16(:,676),heltab2x32(:,:,676))
  Gcoeff(:)%j = (-(c(4)*M(1,:)%j)) * den(13)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(697),h0tab(:,697),[16,4,3,8],[nMW,nMW,nMW,nMW],4,1,wf4(:,13))
  call Hloop_CV_D(ntryL,G0H32(1),0,ex5(:),16,G1H16(333),m3h2x16(:,677),heltab2x32(:,:,677))
  Gcoeff(:)%j = (-(c(4)*M(1,:)%j)) * den(13)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(698),h0tab(:,698),[16,4,3,8],[nMW,nMW,nMW,nMW],4,1,wf4(:,13))
  call Hloop_DV_C(ntryL,G0H32(1),0,ex5(:),G1H16(334),m3h2x16(:,678),heltab2x32(:,:,678))
  Gcoeff(:)%j = (-(c(53)*M(1,:)%j)) * den(14)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(699),h0tab(:,699),[16,4,3,8],[nMW,nMW,nMW,nMW],4,1,wf4(:,14))
  call Hloop_CV_D(ntryL,G0H32(1),0,ex5(:),16,G1H16(335),m3h2x16(:,679),heltab2x32(:,:,679))
  Gcoeff(:)%j = (-(c(53)*M(1,:)%j)) * den(14)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(700),h0tab(:,700),[16,4,3,8],[nMW,nMW,nMW,nMW],4,1,wf4(:,14))
  call Hloop_DV_C(ntryL,G0H32(1),0,ex5(:),G1H16(336),m3h2x16(:,680),heltab2x32(:,:,680))
  Gcoeff(:)%j = (-(c(53)*M(1,:)%j)) * den(14)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(701),h0tab(:,701),[16,4,3,8],[nMW,nMW,nMW,nMW],4,1,wf4(:,14))
  call Hloop_CV_D(ntryL,G0H32(1),0,ex5(:),16,G1H16(337),m3h2x16(:,681),heltab2x32(:,:,681))
  Gcoeff(:)%j = (-(c(53)*M(1,:)%j)) * den(14)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(702),h0tab(:,702),[16,4,3,8],[nMW,nMW,nMW,nMW],4,1,wf4(:,14))
  call Hloop_DV_C(ntryL,G0H32(1),0,ex5(:),G1H16(338),m3h2x16(:,682),heltab2x32(:,:,682))
  Gcoeff(:)%j = (c(4)*M(1,:)%j) * den(13)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(703),h0tab(:,703),[16,4,3,8],[nMW,nMW,nMW,nMW],4,1,wf4(:,13))
  call Hloop_UV_W(ntryL,G0H32(1),0,ex5(:),16,G1H16(339),m3h2x16(:,683),heltab2x32(:,:,683))
  Gcoeff(:)%j = (c(4)*M(1,:)%j) * den(13)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(704),h0tab(:,704),[16,4,3,8],[nMW,nMW,nMW,nMW],4,1,wf4(:,13))
  call Hloop_UW_V(ntryL,G0H32(1),0,ex5(:),16,G1H16(340),m3h2x16(:,684),heltab2x32(:,:,684))
  Gcoeff(:)%j = (c(53)*M(1,:)%j) * den(14)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(705),h0tab(:,705),[16,4,3,8],[nMW,nMW,nMW,nMW],4,1,wf4(:,14))
  call Hloop_UV_W(ntryL,G0H32(1),0,ex5(:),16,G1H16(341),m3h2x16(:,685),heltab2x32(:,:,685))
  Gcoeff(:)%j = (c(53)*M(1,:)%j) * den(14)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(706),h0tab(:,706),[16,4,3,8],[nMW,nMW,nMW,nMW],4,1,wf4(:,14))
  call Hloop_UW_V(ntryL,G0H32(1),0,ex5(:),16,G1H16(342),m3h2x16(:,686),heltab2x32(:,:,686))
  Gcoeff(:)%j = (-(c(9)*M(1,:)%j)) * den(13)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(707),h0tab(:,707),[16,4,3,8],[nMW,nMW,nMW,nMW],4,1,wf4(:,13))
  call Hloop_TV_S(ntryL,G0H32(1),0,ex5(:),16,G1H16(343),m3h2x16(:,687),heltab2x32(:,:,687))
  Gcoeff(:)%j = (-(c(9)*M(1,:)%j)) * den(13)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(708),h0tab(:,708),[16,4,3,8],[nMW,nMW,nMW,nMW],4,1,wf4(:,13))
  call Hloop_SV_T(ntryL,G0H32(1),0,ex5(:),16,G1H16(344),m3h2x16(:,688),heltab2x32(:,:,688))
  Gcoeff(:)%j = (c(57)*M(1,:)%j) * den(14)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(709),h0tab(:,709),[16,4,3,8],[nMW,nMW,nMW,nMW],4,1,wf4(:,14))
  call Hloop_TV_S(ntryL,G0H32(1),0,ex5(:),16,G1H16(345),m3h2x16(:,689),heltab2x32(:,:,689))
  Gcoeff(:)%j = (c(57)*M(1,:)%j) * den(14)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(710),h0tab(:,710),[16,4,3,8],[nMW,nMW,nMW,nMW],4,1,wf4(:,14))
  call Hloop_SV_T(ntryL,G0H32(1),0,ex5(:),16,G1H16(346),m3h2x16(:,690),heltab2x32(:,:,690))
  Gcoeff(:)%j = (-(c(9)*M(1,:)%j)) * den(13)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(711),h0tab(:,711),[16,4,3,8],[nMW,nMW,nMW,nMW],4,1,wf4(:,13))
  call Hloop_VV_S(ntryL,G0H32(1),ex5(:),G0H16(141),m3h2x16(:,691),heltab2x32(:,:,691))
  Gcoeff(:)%j = (-(c(9)*M(1,:)%j)) * den(13)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(712),h0tab(:,712),[16,4,3,8],[nMW,nMW,nMW,nMW],4,1,wf4(:,13))
  call Hloop_VV_S(ntryL,G0H32(1),ex5(:),G0H16(142),m3h2x16(:,692),heltab2x32(:,:,692))
  Gcoeff(:)%j = (c(66)*M(1,:)%j) * den(14)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(713),h0tab(:,713),[16,4,3,8],[nMW,nMW,nMW,nMW],4,1,wf4(:,14))
  call Hloop_VV_S(ntryL,G0H32(1),ex5(:),G0H16(143),m3h2x16(:,693),heltab2x32(:,:,693))
  Gcoeff(:)%j = (c(66)*M(1,:)%j) * den(14)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(714),h0tab(:,714),[16,4,3,8],[nMW,nMW,nMW,nMW],4,1,wf4(:,14))
  call Hloop_VV_S(ntryL,G0H32(1),ex5(:),G0H16(144),m3h2x16(:,694),heltab2x32(:,:,694))
  Gcoeff(:)%j = (-(c(9)*M(1,:)%j)) * den(13)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(715),h0tab(:,715),[16,4,3,8],[nMW,nMW,nMW,nMW],4,1,wf4(:,13))
  call Hloop_TV_S(ntryL,G0H32(1),0,ex5(:),16,G1H16(347),m3h2x16(:,695),heltab2x32(:,:,695))
  Gcoeff(:)%j = (-(c(9)*M(1,:)%j)) * den(13)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(716),h0tab(:,716),[16,4,3,8],[nMW,nMW,nMW,nMW],4,1,wf4(:,13))
  call Hloop_SV_T(ntryL,G0H32(1),0,ex5(:),16,G1H16(348),m3h2x16(:,696),heltab2x32(:,:,696))
  Gcoeff(:)%j = (c(57)*M(1,:)%j) * den(14)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(717),h0tab(:,717),[16,4,3,8],[nMW,nMW,nMW,nMW],4,1,wf4(:,14))
  call Hloop_TV_S(ntryL,G0H32(1),0,ex5(:),16,G1H16(349),m3h2x16(:,697),heltab2x32(:,:,697))
  Gcoeff(:)%j = (c(57)*M(1,:)%j) * den(14)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(718),h0tab(:,718),[16,4,3,8],[nMW,nMW,nMW,nMW],4,1,wf4(:,14))
  call Hloop_SV_T(ntryL,G0H32(1),0,ex5(:),16,G1H16(350),m3h2x16(:,698),heltab2x32(:,:,698))
  Gcoeff(:)%j = (-(c(9)*M(1,:)%j)) * den(13)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(719),h0tab(:,719),[16,4,3,8],[nMW,nMW,nMW,nMW],4,1,wf4(:,13))
  call Hloop_SV_V(ntryL,G0H32(1),ex5(:),G0H16(145),m3h2x16(:,699),heltab2x32(:,:,699))
  Gcoeff(:)%j = (-(c(9)*M(1,:)%j)) * den(13)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(720),h0tab(:,720),[16,4,3,8],[nMW,nMW,nMW,nMW],4,1,wf4(:,13))
  call Hloop_SV_V(ntryL,G0H32(1),ex5(:),G0H16(146),m3h2x16(:,700),heltab2x32(:,:,700))
  Gcoeff(:)%j = (c(66)*M(1,:)%j) * den(14)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(721),h0tab(:,721),[16,4,3,8],[nMW,nMW,nMW,nMW],4,1,wf4(:,14))
  call Hloop_SV_V(ntryL,G0H32(1),ex5(:),G0H16(147),m3h2x16(:,701),heltab2x32(:,:,701))
  Gcoeff(:)%j = (c(66)*M(1,:)%j) * den(14)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(722),h0tab(:,722),[16,4,3,8],[nMW,nMW,nMW,nMW],4,1,wf4(:,14))
  call Hloop_SV_V(ntryL,G0H32(1),ex5(:),G0H16(148),m3h2x16(:,702),heltab2x32(:,:,702))
  Gcoeff(:)%j = (-(c(9)*M(1,:)%j)) * den(13)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(723),h0tab(:,723),[16,4,3,8],[nMW,nMW,nMW,nMW],4,1,wf4(:,13))
  call Hloop_VV_S(ntryL,G0H32(1),ex5(:),G0H16(149),m3h2x16(:,703),heltab2x32(:,:,703))
  Gcoeff(:)%j = (-(c(9)*M(1,:)%j)) * den(13)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(724),h0tab(:,724),[16,4,3,8],[nMW,nMW,nMW,nMW],4,1,wf4(:,13))
  call Hloop_VV_S(ntryL,G0H32(1),ex5(:),G0H16(150),m3h2x16(:,704),heltab2x32(:,:,704))
  Gcoeff(:)%j = (c(57)*M(1,:)%j) * den(14)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(725),h0tab(:,725),[16,4,3,8],[nMW,nMW,nMW,nMW],4,1,wf4(:,14))
  call Hloop_VV_S(ntryL,G0H32(1),ex5(:),G0H16(151),m3h2x16(:,705),heltab2x32(:,:,705))
  Gcoeff(:)%j = (c(57)*M(1,:)%j) * den(14)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(726),h0tab(:,726),[16,4,3,8],[nMW,nMW,nMW,nMW],4,1,wf4(:,14))
  call Hloop_VV_S(ntryL,G0H32(1),ex5(:),G0H16(152),m3h2x16(:,706),heltab2x32(:,:,706))
  Gcoeff(:)%j = (-(c(9)*M(1,:)%j)) * den(13)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(727),h0tab(:,727),[16,4,3,8],[nMW,nMW,nMW,nMW],4,1,wf4(:,13))
  call Hloop_TV_S(ntryL,G0H32(1),0,ex5(:),16,G1H16(351),m3h2x16(:,707),heltab2x32(:,:,707))
  Gcoeff(:)%j = (-(c(9)*M(1,:)%j)) * den(13)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(728),h0tab(:,728),[16,4,3,8],[nMW,nMW,nMW,nMW],4,1,wf4(:,13))
  call Hloop_SV_T(ntryL,G0H32(1),0,ex5(:),16,G1H16(352),m3h2x16(:,708),heltab2x32(:,:,708))
  Gcoeff(:)%j = (-(c(55)*M(1,:)%j)) * den(14)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(729),h0tab(:,729),[16,4,3,8],[nMW,nMW,nMW,nMW],4,1,wf4(:,14))
  call Hloop_TV_S(ntryL,G0H32(1),0,ex5(:),16,G1H16(353),m3h2x16(:,709),heltab2x32(:,:,709))
  Gcoeff(:)%j = (-(c(55)*M(1,:)%j)) * den(14)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(730),h0tab(:,730),[16,4,3,8],[nMW,nMW,nMW,nMW],4,1,wf4(:,14))
  call Hloop_SV_T(ntryL,G0H32(1),0,ex5(:),16,G1H16(354),m3h2x16(:,710),heltab2x32(:,:,710))
  Gcoeff(:)%j = (c(11)*M(1,:)%j) * den(13)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(731),h0tab(:,731),[16,4,3,8],[nMW,nMW,nMW,nMW],4,1,wf4(:,13))
  call Hloop_VV_S(ntryL,G0H32(1),ex5(:),G0H16(153),m3h2x16(:,711),heltab2x32(:,:,711))
  Gcoeff(:)%j = (c(11)*M(1,:)%j) * den(13)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(732),h0tab(:,732),[16,4,3,8],[nMW,nMW,nMW,nMW],4,1,wf4(:,13))
  call Hloop_VV_S(ntryL,G0H32(1),ex5(:),G0H16(154),m3h2x16(:,712),heltab2x32(:,:,712))
  Gcoeff(:)%j = (-(c(59)*M(1,:)%j)) * den(14)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(733),h0tab(:,733),[16,4,3,8],[nMW,nMW,nMW,nMW],4,1,wf4(:,14))
  call Hloop_VV_S(ntryL,G0H32(1),ex5(:),G0H16(155),m3h2x16(:,713),heltab2x32(:,:,713))
  Gcoeff(:)%j = (-(c(59)*M(1,:)%j)) * den(14)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(734),h0tab(:,734),[16,4,3,8],[nMW,nMW,nMW,nMW],4,1,wf4(:,14))
  call Hloop_VV_S(ntryL,G0H32(1),ex5(:),G0H16(156),m3h2x16(:,714),heltab2x32(:,:,714))
  Gcoeff(:)%j = (c(11)*M(1,:)%j) * den(13)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(735),h0tab(:,735),[16,4,3,8],[nMW,nMW,nMW,nMW],4,1,wf4(:,13))
  call Hloop_SV_V(ntryL,G0H32(1),ex5(:),G0H16(157),m3h2x16(:,715),heltab2x32(:,:,715))
  Gcoeff(:)%j = (c(11)*M(1,:)%j) * den(13)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(736),h0tab(:,736),[16,4,3,8],[nMW,nMW,nMW,nMW],4,1,wf4(:,13))
  call Hloop_SV_V(ntryL,G0H32(1),ex5(:),G0H16(158),m3h2x16(:,716),heltab2x32(:,:,716))
  Gcoeff(:)%j = (-(c(59)*M(1,:)%j)) * den(14)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(737),h0tab(:,737),[16,4,3,8],[nMW,nMW,nMW,nMW],4,1,wf4(:,14))
  call Hloop_SV_V(ntryL,G0H32(1),ex5(:),G0H16(159),m3h2x16(:,717),heltab2x32(:,:,717))
  Gcoeff(:)%j = (-(c(59)*M(1,:)%j)) * den(14)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(738),h0tab(:,738),[16,4,3,8],[nMW,nMW,nMW,nMW],4,1,wf4(:,14))
  call Hloop_SV_V(ntryL,G0H32(1),ex5(:),G0H16(160),m3h2x16(:,718),heltab2x32(:,:,718))
  Gcoeff(:)%j = (-(c(9)*M(1,:)%j)) * den(13)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(739),h0tab(:,739),[16,4,3,8],[nMW,nMW,nMW,nMW],4,1,wf4(:,13))
  call Hloop_UV_W(ntryL,G0H32(1),0,ex5(:),16,G1H16(355),m3h2x16(:,719),heltab2x32(:,:,719))
  Gcoeff(:)%j = (-(c(9)*M(1,:)%j)) * den(13)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(740),h0tab(:,740),[16,4,3,8],[nMW,nMW,nMW,nMW],4,1,wf4(:,13))
  call Hloop_UW_V(ntryL,G0H32(1),0,ex5(:),16,G1H16(356),m3h2x16(:,720),heltab2x32(:,:,720))
  Gcoeff(:)%j = (c(66)*M(1,:)%j) * den(14)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(741),h0tab(:,741),[16,4,3,8],[nMW,nMW,nMW,nMW],4,1,wf4(:,14))
  call Hloop_UV_W(ntryL,G0H32(1),0,ex5(:),16,G1H16(357),m3h2x16(:,721),heltab2x32(:,:,721))
  Gcoeff(:)%j = (c(66)*M(1,:)%j) * den(14)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(742),h0tab(:,742),[16,4,3,8],[nMW,nMW,nMW,nMW],4,1,wf4(:,14))
  call Hloop_UW_V(ntryL,G0H32(1),0,ex5(:),16,G1H16(358),m3h2x16(:,722),heltab2x32(:,:,722))
  Gcoeff(:)%j = (-(c(9)*M(1,:)%j)) * den(13)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(743),h0tab(:,743),[16,4,3,8],[nMW,nMW,nMW,nMW],4,1,wf4(:,13))
  call Hloop_SV_V(ntryL,G0H32(1),ex5(:),G0H16(161),m3h2x16(:,723),heltab2x32(:,:,723))
  Gcoeff(:)%j = (-(c(9)*M(1,:)%j)) * den(13)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(744),h0tab(:,744),[16,4,3,8],[nMW,nMW,nMW,nMW],4,1,wf4(:,13))
  call Hloop_SV_V(ntryL,G0H32(1),ex5(:),G0H16(162),m3h2x16(:,724),heltab2x32(:,:,724))
  Gcoeff(:)%j = (c(57)*M(1,:)%j) * den(14)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(745),h0tab(:,745),[16,4,3,8],[nMW,nMW,nMW,nMW],4,1,wf4(:,14))
  call Hloop_SV_V(ntryL,G0H32(1),ex5(:),G0H16(163),m3h2x16(:,725),heltab2x32(:,:,725))
  Gcoeff(:)%j = (c(57)*M(1,:)%j) * den(14)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(746),h0tab(:,746),[16,4,3,8],[nMW,nMW,nMW,nMW],4,1,wf4(:,14))
  call Hloop_SV_V(ntryL,G0H32(1),ex5(:),G0H16(164),m3h2x16(:,726),heltab2x32(:,:,726))
  Gcoeff(:)%j = (-(c(9)*M(1,:)%j)) * den(13)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(747),h0tab(:,747),[16,4,3,8],[nMW,nMW,nMW,nMW],4,1,wf4(:,13))
  call Hloop_VV_S(ntryL,G0H32(1),ex5(:),G0H16(165),m3h2x16(:,727),heltab2x32(:,:,727))
  Gcoeff(:)%j = (-(c(9)*M(1,:)%j)) * den(13)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(748),h0tab(:,748),[16,4,3,8],[nMW,nMW,nMW,nMW],4,1,wf4(:,13))
  call Hloop_VV_S(ntryL,G0H32(1),ex5(:),G0H16(166),m3h2x16(:,728),heltab2x32(:,:,728))
  Gcoeff(:)%j = (-(c(55)*M(1,:)%j)) * den(14)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(749),h0tab(:,749),[16,4,3,8],[nMW,nMW,nMW,nMW],4,1,wf4(:,14))
  call Hloop_VV_S(ntryL,G0H32(1),ex5(:),G0H16(167),m3h2x16(:,729),heltab2x32(:,:,729))
  Gcoeff(:)%j = (-(c(55)*M(1,:)%j)) * den(14)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(750),h0tab(:,750),[16,4,3,8],[nMW,nMW,nMW,nMW],4,1,wf4(:,14))
  call Hloop_VV_S(ntryL,G0H32(1),ex5(:),G0H16(168),m3h2x16(:,730),heltab2x32(:,:,730))
  Gcoeff(:)%j = (-(c(9)*M(1,:)%j)) * den(13)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(751),h0tab(:,751),[16,4,3,8],[nMW,nMW,nMW,nMW],4,1,wf4(:,13))
  call Hloop_UV_W(ntryL,G0H32(1),0,ex5(:),16,G1H16(359),m3h2x16(:,731),heltab2x32(:,:,731))
  Gcoeff(:)%j = (-(c(9)*M(1,:)%j)) * den(13)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(752),h0tab(:,752),[16,4,3,8],[nMW,nMW,nMW,nMW],4,1,wf4(:,13))
  call Hloop_UW_V(ntryL,G0H32(1),0,ex5(:),16,G1H16(360),m3h2x16(:,732),heltab2x32(:,:,732))
  Gcoeff(:)%j = (c(57)*M(1,:)%j) * den(14)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(753),h0tab(:,753),[16,4,3,8],[nMW,nMW,nMW,nMW],4,1,wf4(:,14))
  call Hloop_UV_W(ntryL,G0H32(1),0,ex5(:),16,G1H16(361),m3h2x16(:,733),heltab2x32(:,:,733))
  Gcoeff(:)%j = (c(57)*M(1,:)%j) * den(14)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(754),h0tab(:,754),[16,4,3,8],[nMW,nMW,nMW,nMW],4,1,wf4(:,14))
  call Hloop_UW_V(ntryL,G0H32(1),0,ex5(:),16,G1H16(362),m3h2x16(:,734),heltab2x32(:,:,734))
  Gcoeff(:)%j = (-(c(9)*M(1,:)%j)) * den(13)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(755),h0tab(:,755),[16,4,3,8],[nMW,nMW,nMW,nMW],4,1,wf4(:,13))
  call Hloop_SV_V(ntryL,G0H32(1),ex5(:),G0H16(169),m3h2x16(:,735),heltab2x32(:,:,735))
  Gcoeff(:)%j = (-(c(9)*M(1,:)%j)) * den(13)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(756),h0tab(:,756),[16,4,3,8],[nMW,nMW,nMW,nMW],4,1,wf4(:,13))
  call Hloop_SV_V(ntryL,G0H32(1),ex5(:),G0H16(170),m3h2x16(:,736),heltab2x32(:,:,736))
  Gcoeff(:)%j = (-(c(55)*M(1,:)%j)) * den(14)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(757),h0tab(:,757),[16,4,3,8],[nMW,nMW,nMW,nMW],4,1,wf4(:,14))
  call Hloop_SV_V(ntryL,G0H32(1),ex5(:),G0H16(171),m3h2x16(:,737),heltab2x32(:,:,737))
  Gcoeff(:)%j = (-(c(55)*M(1,:)%j)) * den(14)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(758),h0tab(:,758),[16,4,3,8],[nMW,nMW,nMW,nMW],4,1,wf4(:,14))
  call Hloop_SV_V(ntryL,G0H32(1),ex5(:),G0H16(172),m3h2x16(:,738),heltab2x32(:,:,738))
  Gcoeff(:)%j = (-(c(9)*M(1,:)%j)) * den(13)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(759),h0tab(:,759),[16,4,3,8],[nMW,nMW,nMW,nMW],4,1,wf4(:,13))
  call Hloop_UV_W(ntryL,G0H32(1),0,ex5(:),16,G1H16(363),m3h2x16(:,739),heltab2x32(:,:,739))
  Gcoeff(:)%j = (-(c(9)*M(1,:)%j)) * den(13)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(760),h0tab(:,760),[16,4,3,8],[nMW,nMW,nMW,nMW],4,1,wf4(:,13))
  call Hloop_UW_V(ntryL,G0H32(1),0,ex5(:),16,G1H16(364),m3h2x16(:,740),heltab2x32(:,:,740))
  Gcoeff(:)%j = (c(57)*M(1,:)%j) * den(14)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(761),h0tab(:,761),[16,4,3,8],[nMW,nMW,nMW,nMW],4,1,wf4(:,14))
  call Hloop_UV_W(ntryL,G0H32(1),0,ex5(:),16,G1H16(365),m3h2x16(:,741),heltab2x32(:,:,741))
  Gcoeff(:)%j = (c(57)*M(1,:)%j) * den(14)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(762),h0tab(:,762),[16,4,3,8],[nMW,nMW,nMW,nMW],4,1,wf4(:,14))
  call Hloop_UW_V(ntryL,G0H32(1),0,ex5(:),16,G1H16(366),m3h2x16(:,742),heltab2x32(:,:,742))
  Gcoeff(:)%j = (-(c(33)*M(1,:)%j)) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(763),h0tab(:,763),[16,2,8,5],[nMW,nMB,nMB,nMW],4,1,wf4(:,3))
  call Hloop_SV_T(ntryL,G0H32(1),0,ex5(:),16,G1H16(367),m3h2x16(:,743),heltab2x32(:,:,743))
  Gcoeff(:)%j = (-(c(33)*M(1,:)%j)) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(764),h0tab(:,764),[16,2,8,5],[nMB,nMW,nMW,nMB],4,1,wf4(:,3))
  call Hloop_QV_A(ntryL,G0H32(1),ex5(:),G0H16(173),m3h2x16(:,744),heltab2x32(:,:,744))
  call Hloop_Q_A(ntryL,G0H16(173),16,nMB,G1H16(368),n2h16(215))
  Gcoeff(:)%j = (-(c(16)*M(1,:)%j)) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(765),h0tab(:,765),[16,2,8,5],[nMW,nMB,nMB,nMW],4,1,wf4(:,3))
  call Hloop_VV_S(ntryL,G0H32(1),ex5(:),G0H16(173),m3h2x16(:,745),heltab2x32(:,:,745))
  Gcoeff(:)%j = (c(16)*M(1,:)%j) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(766),h0tab(:,766),[16,2,8,5],[nMW,nMB,nMB,nMW],4,1,wf4(:,3))
  call Hloop_SV_V(ntryL,G0H32(1),ex5(:),G0H16(174),m3h2x16(:,746),heltab2x32(:,:,746))
  Gcoeff(:)%j = (-(c(16)*M(1,:)%j)) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(767),h0tab(:,767),[16,2,8,5],[nMB,nMW,nMW,nMB],4,1,wf4(:,3))
  call Hloop_QV_A(ntryL,G0H32(1),ex5(:),G0H16(175),m3h2x16(:,747),heltab2x32(:,:,747))
  call Hloop_Q_A(ntryL,G0H16(175),16,nMB,G1H16(369),n2h16(216))
  Gcoeff(:)%j = (c(16)*M(1,:)%j) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(768),h0tab(:,768),[16,2,8,5],[nMB,nMW,nMW,nMB],4,1,wf4(:,3))
  call Hloop_QV_A(ntryL,G0H32(1),ex5(:),G0H16(175),m3h2x16(:,748),heltab2x32(:,:,748))
  call Hloop_Q_A(ntryL,G0H16(175),16,nMB,G1H16(370),n2h16(217))
  Gcoeff(:)%j = (-(c(16)*M(1,:)%j)) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(769),h0tab(:,769),[16,2,8,5],[nMW,nMB,nMB,nMW],4,1,wf4(:,3))
  call Hloop_UW_V(ntryL,G0H32(1),0,ex5(:),16,G1H16(371),m3h2x16(:,749),heltab2x32(:,:,749))
  Gcoeff(:)%j = (-(c(16)*M(1,:)%j)) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(770),h0tab(:,770),[16,2,8,5],[nMB,nMW,nMW,nMB],4,1,wf4(:,3))
  call Hloop_QV_A(ntryL,G0H32(1),ex5(:),G0H16(175),m3h2x16(:,750),heltab2x32(:,:,750))
  call Hloop_Q_A(ntryL,G0H16(175),16,nMB,G1H16(372),n2h16(218))
  Gcoeff(:)%j = (-(c(45)*M(1,:)%j)) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(771),h0tab(:,771),[16,5,2,8],[nMT,nMH,nMT,nMT],4,1,wf4(:,3))
  call Hloop_AV_Q(ntryL,G0H32(1),ex5(:),G0H16(175),m3h2x16(:,751),heltab2x32(:,:,751))
  call Hloop_A_Q(ntryL,G0H16(175),16,nMT,G1H16(373),n2h16(219))
  Gcoeff(:)%j = (c(45)*M(1,:)%j) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(772),h0tab(:,772),[16,5,2,8],[nMT,nMZ,nMT,nMT],4,1,wf4(:,3))
  call Hloop_AV_Q(ntryL,G0H32(1),ex5(:),G0H16(175),m3h2x16(:,752),heltab2x32(:,:,752))
  call Hloop_A_Q(ntryL,G0H16(175),16,nMT,G1H16(374),n2h16(220))
  Gcoeff(:)%j = (c(30)*M(1,:)%j) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(773),h0tab(:,773),[16,5,2,8],[nMB,nMW,nMB,nMB],4,1,wf4(:,3))
  call Hloop_AV_Q(ntryL,G0H32(1),ex5(:),G0H16(175),m3h2x16(:,753),heltab2x32(:,:,753))
  call Hloop_A_Q(ntryL,G0H16(175),16,nMB,G1H16(375),n2h16(221))
  Gcoeff(:)%j = (c(37)*M(1,:)%j) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(774),h0tab(:,774),[16,5,2,8],[nMW,nMB,nMW,nMW],4,1,wf4(:,3))
  call Hloop_TV_S(ntryL,G0H32(1),0,ex5(:),16,G1H16(376),m3h2x16(:,754),heltab2x32(:,:,754))
  Gcoeff(:)%j = (c(1)*M(1,:)%j) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(775),h0tab(:,775),[16,5,2,8],[nMT,0,nMT,nMT],4,1,wf4(:,3))
  call Hloop_AV_Q(ntryL,G0H32(1),ex5(:),G0H16(175),m3h2x16(:,755),heltab2x32(:,:,755))
  call Hloop_A_Q(ntryL,G0H16(175),16,nMT,G1H16(377),n2h16(222))
  Gcoeff(:)%j = (c(2)*M(1,:)%j) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(776),h0tab(:,776),[16,5,2,8],[nMT,nMZ,nMT,nMT],4,1,wf4(:,3))
  call Hloop_AV_Q(ntryL,G0H32(1),ex5(:),G0H16(175),m3h2x16(:,756),heltab2x32(:,:,756))
  call Hloop_A_Q(ntryL,G0H16(175),16,nMT,G1H16(378),n2h16(223))
  Gcoeff(:)%j = (c(13)*M(1,:)%j) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(777),h0tab(:,777),[16,5,2,8],[nMB,nMW,nMB,nMB],4,1,wf4(:,3))
  call Hloop_AV_Q(ntryL,G0H32(1),ex5(:),G0H16(175),m3h2x16(:,757),heltab2x32(:,:,757))
  call Hloop_A_Q(ntryL,G0H16(175),16,nMB,G1H16(379),n2h16(224))
  Gcoeff(:)%j = (c(20)*M(1,:)%j) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(778),h0tab(:,778),[16,5,2,8],[nMW,nMB,nMW,nMW],4,1,wf4(:,3))
  call Hloop_SV_V(ntryL,G0H32(1),ex5(:),G0H16(175),m3h2x16(:,758),heltab2x32(:,:,758))
  Gcoeff(:)%j = (-(c(20)*M(1,:)%j)) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(779),h0tab(:,779),[16,5,2,8],[nMW,nMB,nMW,nMW],4,1,wf4(:,3))
  call Hloop_VV_S(ntryL,G0H32(1),ex5(:),G0H16(176),m3h2x16(:,759),heltab2x32(:,:,759))
  Gcoeff(:)%j = (-(c(20)*M(1,:)%j)) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(780),h0tab(:,780),[16,5,2,8],[nMW,nMB,nMW,nMW],4,1,wf4(:,3))
  call Hloop_TV_S(ntryL,G0H32(1),0,ex5(:),16,G1H16(380),m3h2x16(:,760),heltab2x32(:,:,760))
  Gcoeff(:)%j = (c(20)*M(1,:)%j) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(781),h0tab(:,781),[16,5,2,8],[nMW,nMB,nMW,nMW],4,1,wf4(:,3))
  call Hloop_UV_W(ntryL,G0H32(1),0,ex5(:),16,G1H16(381),m3h2x16(:,761),heltab2x32(:,:,761))
  Gcoeff(:)%j = (-(c(47)*M(1,:)%j)) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(782),h0tab(:,782),[16,5,2,8],[nMW,nMB,nMW,nMW],4,1,wf4(:,3))
  call Hloop_SV_V(ntryL,G0H32(1),ex5(:),G0H16(177),m3h2x16(:,762),heltab2x32(:,:,762))
  Gcoeff(:)%j = (-(c(20)*M(1,:)%j)) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(783),h0tab(:,783),[16,5,2,8],[nMW,nMB,nMW,nMW],4,1,wf4(:,3))
  call Hloop_VV_S(ntryL,G0H32(1),ex5(:),G0H16(178),m3h2x16(:,763),heltab2x32(:,:,763))
  Gcoeff(:)%j = (c(20)*M(1,:)%j) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(784),h0tab(:,784),[16,5,2,8],[nMW,nMB,nMW,nMW],4,1,wf4(:,3))
  call Hloop_UV_W(ntryL,G0H32(1),0,ex5(:),16,G1H16(382),m3h2x16(:,764),heltab2x32(:,:,764))
  Gcoeff(:)%j = (-(c(45)*M(1,:)%j)) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(785),h0tab(:,785),[16,2,5,8],[nMT,nMH,nMT,nMT],4,1,wf4(:,3))
  call Hloop_QV_A(ntryL,G0H32(1),ex5(:),G0H16(179),m3h2x16(:,765),heltab2x32(:,:,765))
  call Hloop_Q_A(ntryL,G0H16(179),16,nMT,G1H16(383),n2h16(225))
  Gcoeff(:)%j = (c(45)*M(1,:)%j) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(786),h0tab(:,786),[16,2,5,8],[nMT,nMZ,nMT,nMT],4,1,wf4(:,3))
  call Hloop_QV_A(ntryL,G0H32(1),ex5(:),G0H16(179),m3h2x16(:,766),heltab2x32(:,:,766))
  call Hloop_Q_A(ntryL,G0H16(179),16,nMT,G1H16(384),n2h16(226))
  Gcoeff(:)%j = (c(30)*M(1,:)%j) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(787),h0tab(:,787),[16,2,5,8],[nMB,nMW,nMB,nMB],4,1,wf4(:,3))
  call Hloop_QV_A(ntryL,G0H32(1),ex5(:),G0H16(179),m3h2x16(:,767),heltab2x32(:,:,767))
  call Hloop_Q_A(ntryL,G0H16(179),16,nMB,G1H16(385),n2h16(227))
  Gcoeff(:)%j = (c(37)*M(1,:)%j) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(788),h0tab(:,788),[16,2,5,8],[nMW,nMB,nMW,nMW],4,1,wf4(:,3))
  call Hloop_SV_T(ntryL,G0H32(1),0,ex5(:),16,G1H16(386),m3h2x16(:,768),heltab2x32(:,:,768))
  Gcoeff(:)%j = (c(1)*M(1,:)%j) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(789),h0tab(:,789),[16,2,5,8],[nMT,0,nMT,nMT],4,1,wf4(:,3))
  call Hloop_QV_A(ntryL,G0H32(1),ex5(:),G0H16(179),m3h2x16(:,769),heltab2x32(:,:,769))
  call Hloop_Q_A(ntryL,G0H16(179),16,nMT,G1H16(387),n2h16(228))
  Gcoeff(:)%j = (c(2)*M(1,:)%j) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(790),h0tab(:,790),[16,2,5,8],[nMT,nMZ,nMT,nMT],4,1,wf4(:,3))
  call Hloop_QV_A(ntryL,G0H32(1),ex5(:),G0H16(179),m3h2x16(:,770),heltab2x32(:,:,770))
  call Hloop_Q_A(ntryL,G0H16(179),16,nMT,G1H16(388),n2h16(229))
  Gcoeff(:)%j = (c(13)*M(1,:)%j) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(791),h0tab(:,791),[16,2,5,8],[nMB,nMW,nMB,nMB],4,1,wf4(:,3))
  call Hloop_QV_A(ntryL,G0H32(1),ex5(:),G0H16(179),m3h2x16(:,771),heltab2x32(:,:,771))
  call Hloop_Q_A(ntryL,G0H16(179),16,nMB,G1H16(389),n2h16(230))
  Gcoeff(:)%j = (c(20)*M(1,:)%j) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(792),h0tab(:,792),[16,2,5,8],[nMW,nMB,nMW,nMW],4,1,wf4(:,3))
  call Hloop_SV_T(ntryL,G0H32(1),0,ex5(:),16,G1H16(390),m3h2x16(:,772),heltab2x32(:,:,772))
  Gcoeff(:)%j = (-(c(20)*M(1,:)%j)) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(793),h0tab(:,793),[16,2,5,8],[nMW,nMB,nMW,nMW],4,1,wf4(:,3))
  call Hloop_VV_S(ntryL,G0H32(1),ex5(:),G0H16(179),m3h2x16(:,773),heltab2x32(:,:,773))
  Gcoeff(:)%j = (-(c(20)*M(1,:)%j)) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(794),h0tab(:,794),[16,2,5,8],[nMW,nMB,nMW,nMW],4,1,wf4(:,3))
  call Hloop_SV_V(ntryL,G0H32(1),ex5(:),G0H16(180),m3h2x16(:,774),heltab2x32(:,:,774))
  Gcoeff(:)%j = (c(20)*M(1,:)%j) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(795),h0tab(:,795),[16,2,5,8],[nMW,nMB,nMW,nMW],4,1,wf4(:,3))
  call Hloop_VV_S(ntryL,G0H32(1),ex5(:),G0H16(181),m3h2x16(:,775),heltab2x32(:,:,775))
  Gcoeff(:)%j = (-(c(47)*M(1,:)%j)) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(796),h0tab(:,796),[16,2,5,8],[nMW,nMB,nMW,nMW],4,1,wf4(:,3))
  call Hloop_SV_V(ntryL,G0H32(1),ex5(:),G0H16(182),m3h2x16(:,776),heltab2x32(:,:,776))
  Gcoeff(:)%j = (-(c(20)*M(1,:)%j)) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(797),h0tab(:,797),[16,2,5,8],[nMW,nMB,nMW,nMW],4,1,wf4(:,3))
  call Hloop_UW_V(ntryL,G0H32(1),0,ex5(:),16,G1H16(391),m3h2x16(:,777),heltab2x32(:,:,777))
  Gcoeff(:)%j = (c(20)*M(1,:)%j) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(798),h0tab(:,798),[16,2,5,8],[nMW,nMB,nMW,nMW],4,1,wf4(:,3))
  call Hloop_UW_V(ntryL,G0H32(1),0,ex5(:),16,G1H16(392),m3h2x16(:,778),heltab2x32(:,:,778))
  Gcoeff(:)%j = (-(c(33)*M(1,:)%j)) * den(7)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(799),h0tab(:,799),[16,1,8,6],[nMW,nMB,nMB,nMW],4,1,wf4(:,10))
  call Hloop_TV_S(ntryL,G0H32(1),0,ex5(:),16,G1H16(393),m3h2x16(:,779),heltab2x32(:,:,779))
  Gcoeff(:)%j = (-(c(33)*M(1,:)%j)) * den(7)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(800),h0tab(:,800),[16,1,8,6],[nMB,nMW,nMW,nMB],4,1,wf4(:,10))
  call Hloop_AV_Q(ntryL,G0H32(1),ex5(:),G0H16(183),m3h2x16(:,780),heltab2x32(:,:,780))
  call Hloop_A_Q(ntryL,G0H16(183),16,nMB,G1H16(394),n2h16(231))
  Gcoeff(:)%j = (c(16)*M(1,:)%j) * den(7)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(801),h0tab(:,801),[16,1,8,6],[nMW,nMB,nMB,nMW],4,1,wf4(:,10))
  call Hloop_VV_S(ntryL,G0H32(1),ex5(:),G0H16(183),m3h2x16(:,781),heltab2x32(:,:,781))
  Gcoeff(:)%j = (-(c(16)*M(1,:)%j)) * den(7)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(802),h0tab(:,802),[16,1,8,6],[nMW,nMB,nMB,nMW],4,1,wf4(:,10))
  call Hloop_SV_V(ntryL,G0H32(1),ex5(:),G0H16(184),m3h2x16(:,782),heltab2x32(:,:,782))
  Gcoeff(:)%j = (c(16)*M(1,:)%j) * den(7)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(803),h0tab(:,803),[16,1,8,6],[nMB,nMW,nMW,nMB],4,1,wf4(:,10))
  call Hloop_AV_Q(ntryL,G0H32(1),ex5(:),G0H16(185),m3h2x16(:,783),heltab2x32(:,:,783))
  call Hloop_A_Q(ntryL,G0H16(185),16,nMB,G1H16(395),n2h16(232))
  Gcoeff(:)%j = (-(c(16)*M(1,:)%j)) * den(7)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(804),h0tab(:,804),[16,1,8,6],[nMB,nMW,nMW,nMB],4,1,wf4(:,10))
  call Hloop_AV_Q(ntryL,G0H32(1),ex5(:),G0H16(185),m3h2x16(:,784),heltab2x32(:,:,784))
  call Hloop_A_Q(ntryL,G0H16(185),16,nMB,G1H16(396),n2h16(233))
  Gcoeff(:)%j = (-(c(16)*M(1,:)%j)) * den(7)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(805),h0tab(:,805),[16,1,8,6],[nMW,nMB,nMB,nMW],4,1,wf4(:,10))
  call Hloop_UV_W(ntryL,G0H32(1),0,ex5(:),16,G1H16(397),m3h2x16(:,785),heltab2x32(:,:,785))
  Gcoeff(:)%j = (-(c(16)*M(1,:)%j)) * den(7)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(806),h0tab(:,806),[16,1,8,6],[nMB,nMW,nMW,nMB],4,1,wf4(:,10))
  call Hloop_AV_Q(ntryL,G0H32(1),ex5(:),G0H16(185),m3h2x16(:,786),heltab2x32(:,:,786))
  call Hloop_A_Q(ntryL,G0H16(185),16,nMB,G1H16(398),n2h16(234))
  Gcoeff(:)%j = (-(c(45)*M(1,:)%j)) * den(7)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(807),h0tab(:,807),[16,6,1,8],[nMT,nMH,nMT,nMT],4,1,wf4(:,10))
  call Hloop_QV_A(ntryL,G0H32(1),ex5(:),G0H16(185),m3h2x16(:,787),heltab2x32(:,:,787))
  call Hloop_Q_A(ntryL,G0H16(185),16,nMT,G1H16(399),n2h16(235))
  Gcoeff(:)%j = (c(45)*M(1,:)%j) * den(7)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(808),h0tab(:,808),[16,6,1,8],[nMT,nMZ,nMT,nMT],4,1,wf4(:,10))
  call Hloop_QV_A(ntryL,G0H32(1),ex5(:),G0H16(185),m3h2x16(:,788),heltab2x32(:,:,788))
  call Hloop_Q_A(ntryL,G0H16(185),16,nMT,G1H16(400),n2h16(236))
  Gcoeff(:)%j = (c(30)*M(1,:)%j) * den(7)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(809),h0tab(:,809),[16,6,1,8],[nMB,nMW,nMB,nMB],4,1,wf4(:,10))
  call Hloop_QV_A(ntryL,G0H32(1),ex5(:),G0H16(185),m3h2x16(:,789),heltab2x32(:,:,789))
  call Hloop_Q_A(ntryL,G0H16(185),16,nMB,G1H16(401),n2h16(237))
  Gcoeff(:)%j = (c(37)*M(1,:)%j) * den(7)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(810),h0tab(:,810),[16,6,1,8],[nMW,nMB,nMW,nMW],4,1,wf4(:,10))
  call Hloop_SV_T(ntryL,G0H32(1),0,ex5(:),16,G1H16(402),m3h2x16(:,790),heltab2x32(:,:,790))
  Gcoeff(:)%j = (c(1)*M(1,:)%j) * den(7)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(811),h0tab(:,811),[16,6,1,8],[nMT,0,nMT,nMT],4,1,wf4(:,10))
  call Hloop_QV_A(ntryL,G0H32(1),ex5(:),G0H16(185),m3h2x16(:,791),heltab2x32(:,:,791))
  call Hloop_Q_A(ntryL,G0H16(185),16,nMT,G1H16(403),n2h16(238))
  Gcoeff(:)%j = (c(2)*M(1,:)%j) * den(7)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(812),h0tab(:,812),[16,6,1,8],[nMT,nMZ,nMT,nMT],4,1,wf4(:,10))
  call Hloop_QV_A(ntryL,G0H32(1),ex5(:),G0H16(185),m3h2x16(:,792),heltab2x32(:,:,792))
  call Hloop_Q_A(ntryL,G0H16(185),16,nMT,G1H16(404),n2h16(239))
  Gcoeff(:)%j = (c(13)*M(1,:)%j) * den(7)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(813),h0tab(:,813),[16,6,1,8],[nMB,nMW,nMB,nMB],4,1,wf4(:,10))
  call Hloop_QV_A(ntryL,G0H32(1),ex5(:),G0H16(185),m3h2x16(:,793),heltab2x32(:,:,793))
  call Hloop_Q_A(ntryL,G0H16(185),16,nMB,G1H16(405),n2h16(240))
  Gcoeff(:)%j = (-(c(20)*M(1,:)%j)) * den(7)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(814),h0tab(:,814),[16,6,1,8],[nMW,nMB,nMW,nMW],4,1,wf4(:,10))
  call Hloop_SV_V(ntryL,G0H32(1),ex5(:),G0H16(185),m3h2x16(:,794),heltab2x32(:,:,794))
  Gcoeff(:)%j = (-(c(20)*M(1,:)%j)) * den(7)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(815),h0tab(:,815),[16,6,1,8],[nMW,nMB,nMW,nMW],4,1,wf4(:,10))
  call Hloop_VV_S(ntryL,G0H32(1),ex5(:),G0H16(186),m3h2x16(:,795),heltab2x32(:,:,795))
  Gcoeff(:)%j = (c(20)*M(1,:)%j) * den(7)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(816),h0tab(:,816),[16,6,1,8],[nMW,nMB,nMW,nMW],4,1,wf4(:,10))
  call Hloop_SV_T(ntryL,G0H32(1),0,ex5(:),16,G1H16(406),m3h2x16(:,796),heltab2x32(:,:,796))
  Gcoeff(:)%j = (-(c(20)*M(1,:)%j)) * den(7)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(817),h0tab(:,817),[16,6,1,8],[nMW,nMB,nMW,nMW],4,1,wf4(:,10))
  call Hloop_UW_V(ntryL,G0H32(1),0,ex5(:),16,G1H16(407),m3h2x16(:,797),heltab2x32(:,:,797))
  Gcoeff(:)%j = (-(c(47)*M(1,:)%j)) * den(7)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(818),h0tab(:,818),[16,6,1,8],[nMW,nMB,nMW,nMW],4,1,wf4(:,10))
  call Hloop_SV_V(ntryL,G0H32(1),ex5(:),G0H16(187),m3h2x16(:,798),heltab2x32(:,:,798))
  Gcoeff(:)%j = (c(20)*M(1,:)%j) * den(7)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(819),h0tab(:,819),[16,6,1,8],[nMW,nMB,nMW,nMW],4,1,wf4(:,10))
  call Hloop_VV_S(ntryL,G0H32(1),ex5(:),G0H16(188),m3h2x16(:,799),heltab2x32(:,:,799))
  Gcoeff(:)%j = (c(20)*M(1,:)%j) * den(7)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(820),h0tab(:,820),[16,6,1,8],[nMW,nMB,nMW,nMW],4,1,wf4(:,10))
  call Hloop_UW_V(ntryL,G0H32(1),0,ex5(:),16,G1H16(408),m3h2x16(:,800),heltab2x32(:,:,800))
  Gcoeff(:)%j = (-(c(45)*M(1,:)%j)) * den(7)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(821),h0tab(:,821),[16,1,6,8],[nMT,nMH,nMT,nMT],4,1,wf4(:,10))
  call Hloop_AV_Q(ntryL,G0H32(1),ex5(:),G0H16(189),m3h2x16(:,801),heltab2x32(:,:,801))
  call Hloop_A_Q(ntryL,G0H16(189),16,nMT,G1H16(409),n2h16(241))
  Gcoeff(:)%j = (c(45)*M(1,:)%j) * den(7)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(822),h0tab(:,822),[16,1,6,8],[nMT,nMZ,nMT,nMT],4,1,wf4(:,10))
  call Hloop_AV_Q(ntryL,G0H32(1),ex5(:),G0H16(189),m3h2x16(:,802),heltab2x32(:,:,802))
  call Hloop_A_Q(ntryL,G0H16(189),16,nMT,G1H16(410),n2h16(242))
  Gcoeff(:)%j = (c(30)*M(1,:)%j) * den(7)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(823),h0tab(:,823),[16,1,6,8],[nMB,nMW,nMB,nMB],4,1,wf4(:,10))
  call Hloop_AV_Q(ntryL,G0H32(1),ex5(:),G0H16(189),m3h2x16(:,803),heltab2x32(:,:,803))
  call Hloop_A_Q(ntryL,G0H16(189),16,nMB,G1H16(411),n2h16(243))
  Gcoeff(:)%j = (c(37)*M(1,:)%j) * den(7)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(824),h0tab(:,824),[16,1,6,8],[nMW,nMB,nMW,nMW],4,1,wf4(:,10))
  call Hloop_TV_S(ntryL,G0H32(1),0,ex5(:),16,G1H16(412),m3h2x16(:,804),heltab2x32(:,:,804))
  Gcoeff(:)%j = (c(1)*M(1,:)%j) * den(7)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(825),h0tab(:,825),[16,1,6,8],[nMT,0,nMT,nMT],4,1,wf4(:,10))
  call Hloop_AV_Q(ntryL,G0H32(1),ex5(:),G0H16(189),m3h2x16(:,805),heltab2x32(:,:,805))
  call Hloop_A_Q(ntryL,G0H16(189),16,nMT,G1H16(413),n2h16(244))
  Gcoeff(:)%j = (c(2)*M(1,:)%j) * den(7)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(826),h0tab(:,826),[16,1,6,8],[nMT,nMZ,nMT,nMT],4,1,wf4(:,10))
  call Hloop_AV_Q(ntryL,G0H32(1),ex5(:),G0H16(189),m3h2x16(:,806),heltab2x32(:,:,806))
  call Hloop_A_Q(ntryL,G0H16(189),16,nMT,G1H16(414),n2h16(245))
  Gcoeff(:)%j = (c(13)*M(1,:)%j) * den(7)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(827),h0tab(:,827),[16,1,6,8],[nMB,nMW,nMB,nMB],4,1,wf4(:,10))
  call Hloop_AV_Q(ntryL,G0H32(1),ex5(:),G0H16(189),m3h2x16(:,807),heltab2x32(:,:,807))
  call Hloop_A_Q(ntryL,G0H16(189),16,nMB,G1H16(415),n2h16(246))
  Gcoeff(:)%j = (-(c(20)*M(1,:)%j)) * den(7)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(828),h0tab(:,828),[16,1,6,8],[nMW,nMB,nMW,nMW],4,1,wf4(:,10))
  call Hloop_TV_S(ntryL,G0H32(1),0,ex5(:),16,G1H16(416),m3h2x16(:,808),heltab2x32(:,:,808))
  Gcoeff(:)%j = (-(c(20)*M(1,:)%j)) * den(7)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(829),h0tab(:,829),[16,1,6,8],[nMW,nMB,nMW,nMW],4,1,wf4(:,10))
  call Hloop_VV_S(ntryL,G0H32(1),ex5(:),G0H16(189),m3h2x16(:,809),heltab2x32(:,:,809))
  Gcoeff(:)%j = (c(20)*M(1,:)%j) * den(7)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(830),h0tab(:,830),[16,1,6,8],[nMW,nMB,nMW,nMW],4,1,wf4(:,10))
  call Hloop_SV_V(ntryL,G0H32(1),ex5(:),G0H16(190),m3h2x16(:,810),heltab2x32(:,:,810))
  Gcoeff(:)%j = (-(c(20)*M(1,:)%j)) * den(7)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(831),h0tab(:,831),[16,1,6,8],[nMW,nMB,nMW,nMW],4,1,wf4(:,10))
  call Hloop_VV_S(ntryL,G0H32(1),ex5(:),G0H16(191),m3h2x16(:,811),heltab2x32(:,:,811))
  Gcoeff(:)%j = (-(c(47)*M(1,:)%j)) * den(7)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(832),h0tab(:,832),[16,1,6,8],[nMW,nMB,nMW,nMW],4,1,wf4(:,10))
  call Hloop_SV_V(ntryL,G0H32(1),ex5(:),G0H16(192),m3h2x16(:,812),heltab2x32(:,:,812))
  Gcoeff(:)%j = (c(20)*M(1,:)%j) * den(7)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(833),h0tab(:,833),[16,1,6,8],[nMW,nMB,nMW,nMW],4,1,wf4(:,10))
  call Hloop_UV_W(ntryL,G0H32(1),0,ex5(:),16,G1H16(417),m3h2x16(:,813),heltab2x32(:,:,813))
  Gcoeff(:)%j = (c(20)*M(1,:)%j) * den(7)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(834),h0tab(:,834),[16,1,6,8],[nMW,nMB,nMW,nMW],4,1,wf4(:,10))
  call Hloop_UV_W(ntryL,G0H32(1),0,ex5(:),16,G1H16(418),m3h2x16(:,814),heltab2x32(:,:,814))
  Gcoeff(:)%j = (-(c(33)*M(1,:)%j)) * den(6)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(835),h0tab(:,835),[16,2,4,9],[nMW,nMB,nMB,nMW],4,1,wf4(:,9))
  call Hloop_SV_T(ntryL,G0H32(1),0,ex5(:),16,G1H16(419),m3h2x16(:,815),heltab2x32(:,:,815))
  Gcoeff(:)%j = (-(c(33)*M(1,:)%j)) * den(6)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(836),h0tab(:,836),[16,2,4,9],[nMB,nMW,nMW,nMB],4,1,wf4(:,9))
  call Hloop_QV_A(ntryL,G0H32(1),ex5(:),G0H16(193),m3h2x16(:,816),heltab2x32(:,:,816))
  call Hloop_Q_A(ntryL,G0H16(193),16,nMB,G1H16(420),n2h16(247))
  Gcoeff(:)%j = (-(c(16)*M(1,:)%j)) * den(6)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(837),h0tab(:,837),[16,2,4,9],[nMW,nMB,nMB,nMW],4,1,wf4(:,9))
  call Hloop_VV_S(ntryL,G0H32(1),ex5(:),G0H16(193),m3h2x16(:,817),heltab2x32(:,:,817))
  Gcoeff(:)%j = (c(16)*M(1,:)%j) * den(6)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(838),h0tab(:,838),[16,2,4,9],[nMW,nMB,nMB,nMW],4,1,wf4(:,9))
  call Hloop_SV_V(ntryL,G0H32(1),ex5(:),G0H16(194),m3h2x16(:,818),heltab2x32(:,:,818))
  Gcoeff(:)%j = (-(c(16)*M(1,:)%j)) * den(6)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(839),h0tab(:,839),[16,2,4,9],[nMB,nMW,nMW,nMB],4,1,wf4(:,9))
  call Hloop_QV_A(ntryL,G0H32(1),ex5(:),G0H16(195),m3h2x16(:,819),heltab2x32(:,:,819))
  call Hloop_Q_A(ntryL,G0H16(195),16,nMB,G1H16(421),n2h16(248))
  Gcoeff(:)%j = (c(16)*M(1,:)%j) * den(6)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(840),h0tab(:,840),[16,2,4,9],[nMB,nMW,nMW,nMB],4,1,wf4(:,9))
  call Hloop_QV_A(ntryL,G0H32(1),ex5(:),G0H16(195),m3h2x16(:,820),heltab2x32(:,:,820))
  call Hloop_Q_A(ntryL,G0H16(195),16,nMB,G1H16(422),n2h16(249))
  Gcoeff(:)%j = (-(c(16)*M(1,:)%j)) * den(6)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(841),h0tab(:,841),[16,2,4,9],[nMW,nMB,nMB,nMW],4,1,wf4(:,9))
  call Hloop_UW_V(ntryL,G0H32(1),0,ex5(:),16,G1H16(423),m3h2x16(:,821),heltab2x32(:,:,821))
  Gcoeff(:)%j = (-(c(16)*M(1,:)%j)) * den(6)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(842),h0tab(:,842),[16,2,4,9],[nMB,nMW,nMW,nMB],4,1,wf4(:,9))
  call Hloop_QV_A(ntryL,G0H32(1),ex5(:),G0H16(195),m3h2x16(:,822),heltab2x32(:,:,822))
  call Hloop_Q_A(ntryL,G0H16(195),16,nMB,G1H16(424),n2h16(250))
  Gcoeff(:)%j = (-(c(45)*M(1,:)%j)) * den(6)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(843),h0tab(:,843),[16,4,2,9],[nMT,nMT,nMH,nMT],4,1,wf4(:,9))
  call Hloop_QV_A(ntryL,G0H32(1),ex5(:),G0H16(195),m3h2x16(:,823),heltab2x32(:,:,823))
  call Hloop_Q_A(ntryL,G0H16(195),16,nMT,G1H16(425),n2h16(251))
  Gcoeff(:)%j = (c(45)*M(1,:)%j) * den(6)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(844),h0tab(:,844),[16,4,2,9],[nMT,nMT,nMZ,nMT],4,1,wf4(:,9))
  call Hloop_QV_A(ntryL,G0H32(1),ex5(:),G0H16(195),m3h2x16(:,824),heltab2x32(:,:,824))
  call Hloop_Q_A(ntryL,G0H16(195),16,nMT,G1H16(426),n2h16(252))
  Gcoeff(:)%j = (c(30)*M(1,:)%j) * den(6)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(845),h0tab(:,845),[16,4,2,9],[nMB,nMB,nMW,nMB],4,1,wf4(:,9))
  call Hloop_QV_A(ntryL,G0H32(1),ex5(:),G0H16(195),m3h2x16(:,825),heltab2x32(:,:,825))
  call Hloop_Q_A(ntryL,G0H16(195),16,nMB,G1H16(427),n2h16(253))
  Gcoeff(:)%j = (c(37)*M(1,:)%j) * den(6)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(846),h0tab(:,846),[16,4,2,9],[nMW,nMW,nMB,nMW],4,1,wf4(:,9))
  call Hloop_SV_T(ntryL,G0H32(1),0,ex5(:),16,G1H16(428),m3h2x16(:,826),heltab2x32(:,:,826))
  Gcoeff(:)%j = (c(1)*M(1,:)%j) * den(6)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(847),h0tab(:,847),[16,4,2,9],[nMT,nMT,0,nMT],4,1,wf4(:,9))
  call Hloop_QV_A(ntryL,G0H32(1),ex5(:),G0H16(195),m3h2x16(:,827),heltab2x32(:,:,827))
  call Hloop_Q_A(ntryL,G0H16(195),16,nMT,G1H16(429),n2h16(254))
  Gcoeff(:)%j = (c(2)*M(1,:)%j) * den(6)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(848),h0tab(:,848),[16,4,2,9],[nMT,nMT,nMZ,nMT],4,1,wf4(:,9))
  call Hloop_QV_A(ntryL,G0H32(1),ex5(:),G0H16(195),m3h2x16(:,828),heltab2x32(:,:,828))
  call Hloop_Q_A(ntryL,G0H16(195),16,nMT,G1H16(430),n2h16(255))
  Gcoeff(:)%j = (c(13)*M(1,:)%j) * den(6)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(849),h0tab(:,849),[16,4,2,9],[nMB,nMB,nMW,nMB],4,1,wf4(:,9))
  call Hloop_QV_A(ntryL,G0H32(1),ex5(:),G0H16(195),m3h2x16(:,829),heltab2x32(:,:,829))
  call Hloop_Q_A(ntryL,G0H16(195),16,nMB,G1H16(431),n2h16(256))
  Gcoeff(:)%j = (c(20)*M(1,:)%j) * den(6)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(850),h0tab(:,850),[16,4,2,9],[nMW,nMW,nMB,nMW],4,1,wf4(:,9))
  call Hloop_VV_S(ntryL,G0H32(1),ex5(:),G0H16(195),m3h2x16(:,830),heltab2x32(:,:,830))
  Gcoeff(:)%j = (-(c(20)*M(1,:)%j)) * den(6)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(851),h0tab(:,851),[16,4,2,9],[nMW,nMW,nMB,nMW],4,1,wf4(:,9))
  call Hloop_SV_V(ntryL,G0H32(1),ex5(:),G0H16(196),m3h2x16(:,831),heltab2x32(:,:,831))
  Gcoeff(:)%j = (-(c(20)*M(1,:)%j)) * den(6)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(852),h0tab(:,852),[16,4,2,9],[nMW,nMW,nMB,nMW],4,1,wf4(:,9))
  call Hloop_SV_T(ntryL,G0H32(1),0,ex5(:),16,G1H16(432),m3h2x16(:,832),heltab2x32(:,:,832))
  Gcoeff(:)%j = (c(20)*M(1,:)%j) * den(6)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(853),h0tab(:,853),[16,4,2,9],[nMW,nMW,nMB,nMW],4,1,wf4(:,9))
  call Hloop_UW_V(ntryL,G0H32(1),0,ex5(:),16,G1H16(433),m3h2x16(:,833),heltab2x32(:,:,833))
  Gcoeff(:)%j = (-(c(47)*M(1,:)%j)) * den(6)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(854),h0tab(:,854),[16,4,2,9],[nMW,nMW,nMB,nMW],4,1,wf4(:,9))
  call Hloop_VV_S(ntryL,G0H32(1),ex5(:),G0H16(197),m3h2x16(:,834),heltab2x32(:,:,834))
  Gcoeff(:)%j = (-(c(20)*M(1,:)%j)) * den(6)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(855),h0tab(:,855),[16,4,2,9],[nMW,nMW,nMB,nMW],4,1,wf4(:,9))
  call Hloop_SV_V(ntryL,G0H32(1),ex5(:),G0H16(198),m3h2x16(:,835),heltab2x32(:,:,835))
  Gcoeff(:)%j = (c(20)*M(1,:)%j) * den(6)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(856),h0tab(:,856),[16,4,2,9],[nMW,nMW,nMB,nMW],4,1,wf4(:,9))
  call Hloop_UW_V(ntryL,G0H32(1),0,ex5(:),16,G1H16(434),m3h2x16(:,836),heltab2x32(:,:,836))
  Gcoeff(:)%j = (-(c(45)*M(1,:)%j)) * den(6)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(857),h0tab(:,857),[16,2,9,4],[nMT,nMH,nMT,nMT],4,1,wf4(:,9))
  call Hloop_QV_A(ntryL,G0H32(1),ex5(:),G0H16(199),m3h2x16(:,837),heltab2x32(:,:,837))
  call Hloop_Q_A(ntryL,G0H16(199),16,nMT,G1H16(435),n2h16(257))
  Gcoeff(:)%j = (c(45)*M(1,:)%j) * den(6)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(858),h0tab(:,858),[16,2,9,4],[nMT,nMZ,nMT,nMT],4,1,wf4(:,9))
  call Hloop_QV_A(ntryL,G0H32(1),ex5(:),G0H16(199),m3h2x16(:,838),heltab2x32(:,:,838))
  call Hloop_Q_A(ntryL,G0H16(199),16,nMT,G1H16(436),n2h16(258))
  Gcoeff(:)%j = (c(30)*M(1,:)%j) * den(6)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(859),h0tab(:,859),[16,2,9,4],[nMB,nMW,nMB,nMB],4,1,wf4(:,9))
  call Hloop_QV_A(ntryL,G0H32(1),ex5(:),G0H16(199),m3h2x16(:,839),heltab2x32(:,:,839))
  call Hloop_Q_A(ntryL,G0H16(199),16,nMB,G1H16(437),n2h16(259))
  Gcoeff(:)%j = (c(37)*M(1,:)%j) * den(6)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(860),h0tab(:,860),[16,2,9,4],[nMW,nMB,nMW,nMW],4,1,wf4(:,9))
  call Hloop_SV_T(ntryL,G0H32(1),0,ex5(:),16,G1H16(438),m3h2x16(:,840),heltab2x32(:,:,840))
  Gcoeff(:)%j = (c(1)*M(1,:)%j) * den(6)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(861),h0tab(:,861),[16,2,9,4],[nMT,0,nMT,nMT],4,1,wf4(:,9))
  call Hloop_QV_A(ntryL,G0H32(1),ex5(:),G0H16(199),m3h2x16(:,841),heltab2x32(:,:,841))
  call Hloop_Q_A(ntryL,G0H16(199),16,nMT,G1H16(439),n2h16(260))
  Gcoeff(:)%j = (c(2)*M(1,:)%j) * den(6)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(862),h0tab(:,862),[16,2,9,4],[nMT,nMZ,nMT,nMT],4,1,wf4(:,9))
  call Hloop_QV_A(ntryL,G0H32(1),ex5(:),G0H16(199),m3h2x16(:,842),heltab2x32(:,:,842))
  call Hloop_Q_A(ntryL,G0H16(199),16,nMT,G1H16(440),n2h16(261))
  Gcoeff(:)%j = (c(13)*M(1,:)%j) * den(6)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(863),h0tab(:,863),[16,2,9,4],[nMB,nMW,nMB,nMB],4,1,wf4(:,9))
  call Hloop_QV_A(ntryL,G0H32(1),ex5(:),G0H16(199),m3h2x16(:,843),heltab2x32(:,:,843))
  call Hloop_Q_A(ntryL,G0H16(199),16,nMB,G1H16(441),n2h16(262))
  Gcoeff(:)%j = (c(20)*M(1,:)%j) * den(6)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(864),h0tab(:,864),[16,2,9,4],[nMW,nMB,nMW,nMW],4,1,wf4(:,9))
  call Hloop_SV_T(ntryL,G0H32(1),0,ex5(:),16,G1H16(442),m3h2x16(:,844),heltab2x32(:,:,844))
  Gcoeff(:)%j = (-(c(20)*M(1,:)%j)) * den(6)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(865),h0tab(:,865),[16,2,9,4],[nMW,nMB,nMW,nMW],4,1,wf4(:,9))
  call Hloop_VV_S(ntryL,G0H32(1),ex5(:),G0H16(199),m3h2x16(:,845),heltab2x32(:,:,845))
  Gcoeff(:)%j = (-(c(20)*M(1,:)%j)) * den(6)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(866),h0tab(:,866),[16,2,9,4],[nMW,nMB,nMW,nMW],4,1,wf4(:,9))
  call Hloop_SV_V(ntryL,G0H32(1),ex5(:),G0H16(200),m3h2x16(:,846),heltab2x32(:,:,846))
  Gcoeff(:)%j = (c(20)*M(1,:)%j) * den(6)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(867),h0tab(:,867),[16,2,9,4],[nMW,nMB,nMW,nMW],4,1,wf4(:,9))
  call Hloop_VV_S(ntryL,G0H32(1),ex5(:),G0H16(201),m3h2x16(:,847),heltab2x32(:,:,847))
  Gcoeff(:)%j = (-(c(47)*M(1,:)%j)) * den(6)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(868),h0tab(:,868),[16,2,9,4],[nMW,nMB,nMW,nMW],4,1,wf4(:,9))
  call Hloop_SV_V(ntryL,G0H32(1),ex5(:),G0H16(202),m3h2x16(:,848),heltab2x32(:,:,848))
  Gcoeff(:)%j = (-(c(20)*M(1,:)%j)) * den(6)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(869),h0tab(:,869),[16,2,9,4],[nMW,nMB,nMW,nMW],4,1,wf4(:,9))
  call Hloop_UW_V(ntryL,G0H32(1),0,ex5(:),16,G1H16(443),m3h2x16(:,849),heltab2x32(:,:,849))
  Gcoeff(:)%j = (c(20)*M(1,:)%j) * den(6)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(870),h0tab(:,870),[16,2,9,4],[nMW,nMB,nMW,nMW],4,1,wf4(:,9))
  call Hloop_UW_V(ntryL,G0H32(1),0,ex5(:),16,G1H16(444),m3h2x16(:,850),heltab2x32(:,:,850))
  Gcoeff(:)%j = (-(c(33)*M(1,:)%j)) * den(2)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(871),h0tab(:,871),[16,1,4,10],[nMW,nMB,nMB,nMW],4,1,wf4(:,4))
  call Hloop_TV_S(ntryL,G0H32(1),0,ex5(:),16,G1H16(445),m3h2x16(:,851),heltab2x32(:,:,851))
  Gcoeff(:)%j = (-(c(33)*M(1,:)%j)) * den(2)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(872),h0tab(:,872),[16,1,4,10],[nMB,nMW,nMW,nMB],4,1,wf4(:,4))
  call Hloop_AV_Q(ntryL,G0H32(1),ex5(:),G0H16(203),m3h2x16(:,852),heltab2x32(:,:,852))
  call Hloop_A_Q(ntryL,G0H16(203),16,nMB,G1H16(446),n2h16(263))
  Gcoeff(:)%j = (c(16)*M(1,:)%j) * den(2)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(873),h0tab(:,873),[16,1,4,10],[nMW,nMB,nMB,nMW],4,1,wf4(:,4))
  call Hloop_VV_S(ntryL,G0H32(1),ex5(:),G0H16(203),m3h2x16(:,853),heltab2x32(:,:,853))
  Gcoeff(:)%j = (-(c(16)*M(1,:)%j)) * den(2)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(874),h0tab(:,874),[16,1,4,10],[nMW,nMB,nMB,nMW],4,1,wf4(:,4))
  call Hloop_SV_V(ntryL,G0H32(1),ex5(:),G0H16(204),m3h2x16(:,854),heltab2x32(:,:,854))
  Gcoeff(:)%j = (c(16)*M(1,:)%j) * den(2)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(875),h0tab(:,875),[16,1,4,10],[nMB,nMW,nMW,nMB],4,1,wf4(:,4))
  call Hloop_AV_Q(ntryL,G0H32(1),ex5(:),G0H16(205),m3h2x16(:,855),heltab2x32(:,:,855))
  call Hloop_A_Q(ntryL,G0H16(205),16,nMB,G1H16(447),n2h16(264))
  Gcoeff(:)%j = (-(c(16)*M(1,:)%j)) * den(2)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(876),h0tab(:,876),[16,1,4,10],[nMB,nMW,nMW,nMB],4,1,wf4(:,4))
  call Hloop_AV_Q(ntryL,G0H32(1),ex5(:),G0H16(205),m3h2x16(:,856),heltab2x32(:,:,856))
  call Hloop_A_Q(ntryL,G0H16(205),16,nMB,G1H16(448),n2h16(265))
  Gcoeff(:)%j = (-(c(16)*M(1,:)%j)) * den(2)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(877),h0tab(:,877),[16,1,4,10],[nMW,nMB,nMB,nMW],4,1,wf4(:,4))
  call Hloop_UV_W(ntryL,G0H32(1),0,ex5(:),16,G1H16(449),m3h2x16(:,857),heltab2x32(:,:,857))
  Gcoeff(:)%j = (-(c(16)*M(1,:)%j)) * den(2)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(878),h0tab(:,878),[16,1,4,10],[nMB,nMW,nMW,nMB],4,1,wf4(:,4))
  call Hloop_AV_Q(ntryL,G0H32(1),ex5(:),G0H16(205),m3h2x16(:,858),heltab2x32(:,:,858))
  call Hloop_A_Q(ntryL,G0H16(205),16,nMB,G1H16(450),n2h16(266))
  Gcoeff(:)%j = (-(c(45)*M(1,:)%j)) * den(2)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(879),h0tab(:,879),[16,4,1,10],[nMT,nMT,nMH,nMT],4,1,wf4(:,4))
  call Hloop_AV_Q(ntryL,G0H32(1),ex5(:),G0H16(205),m3h2x16(:,859),heltab2x32(:,:,859))
  call Hloop_A_Q(ntryL,G0H16(205),16,nMT,G1H16(451),n2h16(267))
  Gcoeff(:)%j = (c(45)*M(1,:)%j) * den(2)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(880),h0tab(:,880),[16,4,1,10],[nMT,nMT,nMZ,nMT],4,1,wf4(:,4))
  call Hloop_AV_Q(ntryL,G0H32(1),ex5(:),G0H16(205),m3h2x16(:,860),heltab2x32(:,:,860))
  call Hloop_A_Q(ntryL,G0H16(205),16,nMT,G1H16(452),n2h16(268))
  Gcoeff(:)%j = (c(30)*M(1,:)%j) * den(2)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(881),h0tab(:,881),[16,4,1,10],[nMB,nMB,nMW,nMB],4,1,wf4(:,4))
  call Hloop_AV_Q(ntryL,G0H32(1),ex5(:),G0H16(205),m3h2x16(:,861),heltab2x32(:,:,861))
  call Hloop_A_Q(ntryL,G0H16(205),16,nMB,G1H16(453),n2h16(269))
  Gcoeff(:)%j = (c(37)*M(1,:)%j) * den(2)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(882),h0tab(:,882),[16,4,1,10],[nMW,nMW,nMB,nMW],4,1,wf4(:,4))
  call Hloop_TV_S(ntryL,G0H32(1),0,ex5(:),16,G1H16(454),m3h2x16(:,862),heltab2x32(:,:,862))
  Gcoeff(:)%j = (c(1)*M(1,:)%j) * den(2)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(883),h0tab(:,883),[16,4,1,10],[nMT,nMT,0,nMT],4,1,wf4(:,4))
  call Hloop_AV_Q(ntryL,G0H32(1),ex5(:),G0H16(205),m3h2x16(:,863),heltab2x32(:,:,863))
  call Hloop_A_Q(ntryL,G0H16(205),16,nMT,G1H16(455),n2h16(270))
  Gcoeff(:)%j = (c(2)*M(1,:)%j) * den(2)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(884),h0tab(:,884),[16,4,1,10],[nMT,nMT,nMZ,nMT],4,1,wf4(:,4))
  call Hloop_AV_Q(ntryL,G0H32(1),ex5(:),G0H16(205),m3h2x16(:,864),heltab2x32(:,:,864))
  call Hloop_A_Q(ntryL,G0H16(205),16,nMT,G1H16(456),n2h16(271))
  Gcoeff(:)%j = (c(13)*M(1,:)%j) * den(2)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(885),h0tab(:,885),[16,4,1,10],[nMB,nMB,nMW,nMB],4,1,wf4(:,4))
  call Hloop_AV_Q(ntryL,G0H32(1),ex5(:),G0H16(205),m3h2x16(:,865),heltab2x32(:,:,865))
  call Hloop_A_Q(ntryL,G0H16(205),16,nMB,G1H16(457),n2h16(272))
  Gcoeff(:)%j = (-(c(20)*M(1,:)%j)) * den(2)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(886),h0tab(:,886),[16,4,1,10],[nMW,nMW,nMB,nMW],4,1,wf4(:,4))
  call Hloop_VV_S(ntryL,G0H32(1),ex5(:),G0H16(205),m3h2x16(:,866),heltab2x32(:,:,866))
  Gcoeff(:)%j = (-(c(20)*M(1,:)%j)) * den(2)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(887),h0tab(:,887),[16,4,1,10],[nMW,nMW,nMB,nMW],4,1,wf4(:,4))
  call Hloop_SV_V(ntryL,G0H32(1),ex5(:),G0H16(206),m3h2x16(:,867),heltab2x32(:,:,867))
  Gcoeff(:)%j = (c(20)*M(1,:)%j) * den(2)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(888),h0tab(:,888),[16,4,1,10],[nMW,nMW,nMB,nMW],4,1,wf4(:,4))
  call Hloop_TV_S(ntryL,G0H32(1),0,ex5(:),16,G1H16(458),m3h2x16(:,868),heltab2x32(:,:,868))
  Gcoeff(:)%j = (-(c(20)*M(1,:)%j)) * den(2)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(889),h0tab(:,889),[16,4,1,10],[nMW,nMW,nMB,nMW],4,1,wf4(:,4))
  call Hloop_UV_W(ntryL,G0H32(1),0,ex5(:),16,G1H16(459),m3h2x16(:,869),heltab2x32(:,:,869))
  Gcoeff(:)%j = (-(c(47)*M(1,:)%j)) * den(2)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(890),h0tab(:,890),[16,4,1,10],[nMW,nMW,nMB,nMW],4,1,wf4(:,4))
  call Hloop_VV_S(ntryL,G0H32(1),ex5(:),G0H16(207),m3h2x16(:,870),heltab2x32(:,:,870))
  Gcoeff(:)%j = (c(20)*M(1,:)%j) * den(2)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(891),h0tab(:,891),[16,4,1,10],[nMW,nMW,nMB,nMW],4,1,wf4(:,4))
  call Hloop_SV_V(ntryL,G0H32(1),ex5(:),G0H16(208),m3h2x16(:,871),heltab2x32(:,:,871))
  Gcoeff(:)%j = (c(20)*M(1,:)%j) * den(2)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(892),h0tab(:,892),[16,4,1,10],[nMW,nMW,nMB,nMW],4,1,wf4(:,4))
  call Hloop_UV_W(ntryL,G0H32(1),0,ex5(:),16,G1H16(460),m3h2x16(:,872),heltab2x32(:,:,872))
  Gcoeff(:)%j = (-(c(45)*M(1,:)%j)) * den(2)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(893),h0tab(:,893),[16,1,10,4],[nMT,nMH,nMT,nMT],4,1,wf4(:,4))
  call Hloop_AV_Q(ntryL,G0H32(1),ex5(:),G0H16(209),m3h2x16(:,873),heltab2x32(:,:,873))
  call Hloop_A_Q(ntryL,G0H16(209),16,nMT,G1H16(461),n2h16(273))
  Gcoeff(:)%j = (c(45)*M(1,:)%j) * den(2)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(894),h0tab(:,894),[16,1,10,4],[nMT,nMZ,nMT,nMT],4,1,wf4(:,4))
  call Hloop_AV_Q(ntryL,G0H32(1),ex5(:),G0H16(209),m3h2x16(:,874),heltab2x32(:,:,874))
  call Hloop_A_Q(ntryL,G0H16(209),16,nMT,G1H16(462),n2h16(274))
  Gcoeff(:)%j = (c(30)*M(1,:)%j) * den(2)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(895),h0tab(:,895),[16,1,10,4],[nMB,nMW,nMB,nMB],4,1,wf4(:,4))
  call Hloop_AV_Q(ntryL,G0H32(1),ex5(:),G0H16(209),m3h2x16(:,875),heltab2x32(:,:,875))
  call Hloop_A_Q(ntryL,G0H16(209),16,nMB,G1H16(463),n2h16(275))
  Gcoeff(:)%j = (c(37)*M(1,:)%j) * den(2)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(896),h0tab(:,896),[16,1,10,4],[nMW,nMB,nMW,nMW],4,1,wf4(:,4))
  call Hloop_TV_S(ntryL,G0H32(1),0,ex5(:),16,G1H16(464),m3h2x16(:,876),heltab2x32(:,:,876))
  Gcoeff(:)%j = (c(1)*M(1,:)%j) * den(2)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(897),h0tab(:,897),[16,1,10,4],[nMT,0,nMT,nMT],4,1,wf4(:,4))
  call Hloop_AV_Q(ntryL,G0H32(1),ex5(:),G0H16(209),m3h2x16(:,877),heltab2x32(:,:,877))
  call Hloop_A_Q(ntryL,G0H16(209),16,nMT,G1H16(465),n2h16(276))
  Gcoeff(:)%j = (c(2)*M(1,:)%j) * den(2)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(898),h0tab(:,898),[16,1,10,4],[nMT,nMZ,nMT,nMT],4,1,wf4(:,4))
  call Hloop_AV_Q(ntryL,G0H32(1),ex5(:),G0H16(209),m3h2x16(:,878),heltab2x32(:,:,878))
  call Hloop_A_Q(ntryL,G0H16(209),16,nMT,G1H16(466),n2h16(277))
  Gcoeff(:)%j = (c(13)*M(1,:)%j) * den(2)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(899),h0tab(:,899),[16,1,10,4],[nMB,nMW,nMB,nMB],4,1,wf4(:,4))
  call Hloop_AV_Q(ntryL,G0H32(1),ex5(:),G0H16(209),m3h2x16(:,879),heltab2x32(:,:,879))
  call Hloop_A_Q(ntryL,G0H16(209),16,nMB,G1H16(467),n2h16(278))
  Gcoeff(:)%j = (-(c(20)*M(1,:)%j)) * den(2)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(900),h0tab(:,900),[16,1,10,4],[nMW,nMB,nMW,nMW],4,1,wf4(:,4))
  call Hloop_TV_S(ntryL,G0H32(1),0,ex5(:),16,G1H16(468),m3h2x16(:,880),heltab2x32(:,:,880))
  Gcoeff(:)%j = (-(c(20)*M(1,:)%j)) * den(2)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(901),h0tab(:,901),[16,1,10,4],[nMW,nMB,nMW,nMW],4,1,wf4(:,4))
  call Hloop_VV_S(ntryL,G0H32(1),ex5(:),G0H16(209),m3h2x16(:,881),heltab2x32(:,:,881))
  Gcoeff(:)%j = (c(20)*M(1,:)%j) * den(2)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(902),h0tab(:,902),[16,1,10,4],[nMW,nMB,nMW,nMW],4,1,wf4(:,4))
  call Hloop_SV_V(ntryL,G0H32(1),ex5(:),G0H16(210),m3h2x16(:,882),heltab2x32(:,:,882))
  Gcoeff(:)%j = (-(c(20)*M(1,:)%j)) * den(2)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(903),h0tab(:,903),[16,1,10,4],[nMW,nMB,nMW,nMW],4,1,wf4(:,4))
  call Hloop_VV_S(ntryL,G0H32(1),ex5(:),G0H16(211),m3h2x16(:,883),heltab2x32(:,:,883))
  Gcoeff(:)%j = (-(c(47)*M(1,:)%j)) * den(2)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(904),h0tab(:,904),[16,1,10,4],[nMW,nMB,nMW,nMW],4,1,wf4(:,4))
  call Hloop_SV_V(ntryL,G0H32(1),ex5(:),G0H16(212),m3h2x16(:,884),heltab2x32(:,:,884))
  Gcoeff(:)%j = (c(20)*M(1,:)%j) * den(2)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(905),h0tab(:,905),[16,1,10,4],[nMW,nMB,nMW,nMW],4,1,wf4(:,4))
  call Hloop_UV_W(ntryL,G0H32(1),0,ex5(:),16,G1H16(469),m3h2x16(:,885),heltab2x32(:,:,885))
  Gcoeff(:)%j = (c(20)*M(1,:)%j) * den(2)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(906),h0tab(:,906),[16,1,10,4],[nMW,nMB,nMW,nMW],4,1,wf4(:,4))
  call Hloop_UV_W(ntryL,G0H32(1),0,ex5(:),16,G1H16(470),m3h2x16(:,886),heltab2x32(:,:,886))
  Gcoeff(:)%j = (-(c(33)*M(1,:)%j)) * den(9)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(907),h0tab(:,907),[17,4,2,8],[nMB,nMB,nMW,nMW],4,1,wf4(:,12))
  call Hloop_SQ_A(ntryL,G0H32(1),wf4(:,12),G0H8(21),ngPbt,m3h4x8(:,1),heltab2x32(:,:,887))
  call Hloop_Q_A(ntryL,G0H8(21),17,nMB,G1H8(118),n2h8(145))
  Gcoeff(:)%j = (-(c(33)*M(1,:)%j)) * den(9)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(908),h0tab(:,908),[17,4,2,8],[nMW,nMW,nMB,nMB],4,1,wf4(:,12))
  call Hloop_AQ_S(ntryL,G0H32(1),wf4(:,12),G0H8(21),ngPbt,m3h4x8(:,2),heltab2x32(:,:,888))
  Gcoeff(:)%j = (-(c(16)*M(1,:)%j)) * den(9)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(909),h0tab(:,909),[17,4,2,8],[nMB,nMB,nMW,nMW],4,1,wf4(:,12))
  call Hloop_WQ_A(ntryL,G0H32(1),wf4(:,12),G0H8(22),m3h4x8(:,3),heltab2x32(:,:,889))
  call Hloop_Q_A(ntryL,G0H8(22),17,nMB,G1H8(119),n2h8(146))
  Gcoeff(:)%j = (c(16)*M(1,:)%j) * den(9)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(910),h0tab(:,910),[17,4,2,8],[nMB,nMB,nMW,nMW],4,1,wf4(:,12))
  call Hloop_SQ_A(ntryL,G0H32(1),wf4(:,12),G0H8(22),ngPbt,m3h4x8(:,4),heltab2x32(:,:,890))
  call Hloop_Q_A(ntryL,G0H8(22),17,nMB,G1H8(120),n2h8(147))
  Gcoeff(:)%j = (-(c(16)*M(1,:)%j)) * den(9)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(911),h0tab(:,911),[17,4,2,8],[nMW,nMW,nMB,nMB],4,1,wf4(:,12))
  call Hloop_AQ_W(ntryL,G0H32(1),wf4(:,12),G0H8(22),m3h4x8(:,5),heltab2x32(:,:,891))
  Gcoeff(:)%j = (c(16)*M(1,:)%j) * den(9)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(912),h0tab(:,912),[17,4,2,8],[nMW,nMW,nMB,nMB],4,1,wf4(:,12))
  call Hloop_AQ_S(ntryL,G0H32(1),wf4(:,12),G0H8(23),ngPbt,m3h4x8(:,6),heltab2x32(:,:,892))
  Gcoeff(:)%j = (-(c(16)*M(1,:)%j)) * den(9)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(913),h0tab(:,913),[17,4,2,8],[nMB,nMB,nMW,nMW],4,1,wf4(:,12))
  call Hloop_WQ_A(ntryL,G0H32(1),wf4(:,12),G0H8(24),m3h4x8(:,7),heltab2x32(:,:,893))
  call Hloop_Q_A(ntryL,G0H8(24),17,nMB,G1H8(121),n2h8(148))
  Gcoeff(:)%j = (-(c(16)*M(1,:)%j)) * den(9)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(914),h0tab(:,914),[17,4,2,8],[nMW,nMW,nMB,nMB],4,1,wf4(:,12))
  call Hloop_AQ_W(ntryL,G0H32(1),wf4(:,12),G0H8(24),m3h4x8(:,8),heltab2x32(:,:,894))
  Gcoeff(:)%j = (-(c(45)*M(1,:)%j)) * den(9)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(915),h0tab(:,915),[17,2,4,8],[nMH,nMT,nMT,nMT],4,1,wf4(:,12))
  call Hloop_AQ_S(ntryL,G0H32(1),wf4(:,12),G0H8(25),ngH,m3h4x8(:,9),heltab2x32(:,:,895))
  Gcoeff(:)%j = (c(45)*M(1,:)%j) * den(9)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(916),h0tab(:,916),[17,2,4,8],[nMZ,nMT,nMT,nMT],4,1,wf4(:,12))
  call Hloop_AQ_S(ntryL,G0H32(1),wf4(:,12),G0H8(26),ngX,m3h4x8(:,10),heltab2x32(:,:,896))
  Gcoeff(:)%j = (c(30)*M(1,:)%j) * den(9)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(917),h0tab(:,917),[17,2,4,8],[nMW,nMB,nMB,nMB],4,1,wf4(:,12))
  call Hloop_AQ_S(ntryL,G0H32(1),wf4(:,12),G0H8(27),ngPbt,m3h4x8(:,11),heltab2x32(:,:,897))
  Gcoeff(:)%j = (c(37)*M(1,:)%j) * den(9)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(918),h0tab(:,918),[17,2,4,8],[nMB,nMW,nMW,nMW],4,1,wf4(:,12))
  call Hloop_SQ_A(ntryL,G0H32(1),wf4(:,12),G0H8(28),ngPbt,m3h4x8(:,12),heltab2x32(:,:,898))
  call Hloop_Q_A(ntryL,G0H8(28),17,nMB,G1H8(122),n2h8(149))
  Gcoeff(:)%j = (c(1)*M(1,:)%j) * den(9)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(919),h0tab(:,919),[17,2,4,8],[0,nMT,nMT,nMT],4,1,wf4(:,12))
  call Hloop_AQ_V(ntryL,G0H32(1),wf4(:,12),G0H8(28),m3h4x8(:,13),heltab2x32(:,:,899))
  Gcoeff(:)%j = (c(2)*M(1,:)%j) * den(9)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(920),h0tab(:,920),[17,2,4,8],[nMZ,nMT,nMT,nMT],4,1,wf4(:,12))
  call Hloop_AQ_Z(ntryL,G0H32(1),wf4(:,12),G0H8(29),ngZu,m3h4x8(:,14),heltab2x32(:,:,900))
  Gcoeff(:)%j = (c(13)*M(1,:)%j) * den(9)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(921),h0tab(:,921),[17,2,4,8],[nMW,nMB,nMB,nMB],4,1,wf4(:,12))
  call Hloop_AQ_W(ntryL,G0H32(1),wf4(:,12),G0H8(30),m3h4x8(:,15),heltab2x32(:,:,901))
  Gcoeff(:)%j = (c(20)*M(1,:)%j) * den(9)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(922),h0tab(:,922),[17,2,4,8],[nMB,nMW,nMW,nMW],4,1,wf4(:,12))
  call Hloop_WQ_A(ntryL,G0H32(1),wf4(:,12),G0H8(31),m3h4x8(:,16),heltab2x32(:,:,902))
  call Hloop_Q_A(ntryL,G0H8(31),17,nMB,G1H8(123),n2h8(150))
  Gcoeff(:)%j = (-(c(20)*M(1,:)%j)) * den(9)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(923),h0tab(:,923),[17,2,4,8],[nMB,nMW,nMW,nMW],4,1,wf4(:,12))
  call Hloop_SQ_A(ntryL,G0H32(1),wf4(:,12),G0H8(31),ngPbt,m3h4x8(:,17),heltab2x32(:,:,903))
  call Hloop_Q_A(ntryL,G0H8(31),17,nMB,G1H8(124),n2h8(151))
  Gcoeff(:)%j = (-(c(20)*M(1,:)%j)) * den(9)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(924),h0tab(:,924),[17,2,4,8],[nMB,nMW,nMW,nMW],4,1,wf4(:,12))
  call Hloop_SQ_A(ntryL,G0H32(1),wf4(:,12),G0H8(31),ngPbt,m3h4x8(:,18),heltab2x32(:,:,904))
  call Hloop_Q_A(ntryL,G0H8(31),17,nMB,G1H8(1),n2h8(152))
  Gcoeff(:)%j = (c(20)*M(1,:)%j) * den(9)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(925),h0tab(:,925),[17,2,4,8],[nMB,nMW,nMW,nMW],4,1,wf4(:,12))
  call Hloop_WQ_A(ntryL,G0H32(1),wf4(:,12),G0H8(31),m3h4x8(:,19),heltab2x32(:,:,905))
  call Hloop_Q_A(ntryL,G0H8(31),17,nMB,G1H8(2),n2h8(153))
  Gcoeff(:)%j = (-(c(47)*M(1,:)%j)) * den(9)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(926),h0tab(:,926),[17,2,4,8],[nMB,nMW,nMW,nMW],4,1,wf4(:,12))
  call Hloop_WQ_A(ntryL,G0H32(1),wf4(:,12),G0H8(31),m3h4x8(:,20),heltab2x32(:,:,906))
  call Hloop_Q_A(ntryL,G0H8(31),17,nMB,G1H8(6),n2h8(154))
  Gcoeff(:)%j = (-(c(20)*M(1,:)%j)) * den(9)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(927),h0tab(:,927),[17,2,4,8],[nMB,nMW,nMW,nMW],4,1,wf4(:,12))
  call Hloop_SQ_A(ntryL,G0H32(1),wf4(:,12),G0H8(31),ngPbt,m3h4x8(:,21),heltab2x32(:,:,907))
  call Hloop_Q_A(ntryL,G0H8(31),17,nMB,G1H8(16),n2h8(155))
  Gcoeff(:)%j = (c(20)*M(1,:)%j) * den(9)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(928),h0tab(:,928),[17,2,4,8],[nMB,nMW,nMW,nMW],4,1,wf4(:,12))
  call Hloop_WQ_A(ntryL,G0H32(1),wf4(:,12),G0H8(31),m3h4x8(:,22),heltab2x32(:,:,908))
  call Hloop_Q_A(ntryL,G0H8(31),17,nMB,G1H8(15),n2h8(156))
  Gcoeff(:)%j = (-(c(45)*M(1,:)%j)) * den(9)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(929),h0tab(:,929),[17,2,8,4],[nMH,nMT,nMT,nMT],4,1,wf4(:,12))
  call Hloop_AQ_S(ntryL,G0H32(1),wf4(:,12),G0H8(31),ngH,m3h4x8(:,23),heltab2x32(:,:,909))
  Gcoeff(:)%j = (c(45)*M(1,:)%j) * den(9)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(930),h0tab(:,930),[17,2,8,4],[nMZ,nMT,nMT,nMT],4,1,wf4(:,12))
  call Hloop_AQ_S(ntryL,G0H32(1),wf4(:,12),G0H8(32),ngX,m3h4x8(:,24),heltab2x32(:,:,910))
  Gcoeff(:)%j = (c(30)*M(1,:)%j) * den(9)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(931),h0tab(:,931),[17,2,8,4],[nMW,nMB,nMB,nMB],4,1,wf4(:,12))
  call Hloop_AQ_S(ntryL,G0H32(1),wf4(:,12),G0H8(33),ngPbt,m3h4x8(:,25),heltab2x32(:,:,911))
  Gcoeff(:)%j = (c(37)*M(1,:)%j) * den(9)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(932),h0tab(:,932),[17,2,8,4],[nMB,nMW,nMW,nMW],4,1,wf4(:,12))
  call Hloop_SQ_A(ntryL,G0H32(1),wf4(:,12),G0H8(34),ngPbt,m3h4x8(:,26),heltab2x32(:,:,912))
  call Hloop_Q_A(ntryL,G0H8(34),17,nMB,G1H8(18),n2h8(157))
  Gcoeff(:)%j = (c(1)*M(1,:)%j) * den(9)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(933),h0tab(:,933),[17,2,8,4],[0,nMT,nMT,nMT],4,1,wf4(:,12))
  call Hloop_AQ_V(ntryL,G0H32(1),wf4(:,12),G0H8(34),m3h4x8(:,27),heltab2x32(:,:,913))
  Gcoeff(:)%j = (c(2)*M(1,:)%j) * den(9)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(934),h0tab(:,934),[17,2,8,4],[nMZ,nMT,nMT,nMT],4,1,wf4(:,12))
  call Hloop_AQ_Z(ntryL,G0H32(1),wf4(:,12),G0H8(35),ngZu,m3h4x8(:,28),heltab2x32(:,:,914))
  Gcoeff(:)%j = (c(13)*M(1,:)%j) * den(9)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(935),h0tab(:,935),[17,2,8,4],[nMW,nMB,nMB,nMB],4,1,wf4(:,12))
  call Hloop_AQ_W(ntryL,G0H32(1),wf4(:,12),G0H8(36),m3h4x8(:,29),heltab2x32(:,:,915))
  Gcoeff(:)%j = (c(20)*M(1,:)%j) * den(9)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(936),h0tab(:,936),[17,2,8,4],[nMB,nMW,nMW,nMW],4,1,wf4(:,12))
  call Hloop_WQ_A(ntryL,G0H32(1),wf4(:,12),G0H8(37),m3h4x8(:,30),heltab2x32(:,:,916))
  call Hloop_Q_A(ntryL,G0H8(37),17,nMB,G1H8(20),n2h8(158))
  Gcoeff(:)%j = (-(c(20)*M(1,:)%j)) * den(9)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(937),h0tab(:,937),[17,2,8,4],[nMB,nMW,nMW,nMW],4,1,wf4(:,12))
  call Hloop_SQ_A(ntryL,G0H32(1),wf4(:,12),G0H8(37),ngPbt,m3h4x8(:,31),heltab2x32(:,:,917))
  call Hloop_Q_A(ntryL,G0H8(37),17,nMB,G1H8(19),n2h8(159))
  Gcoeff(:)%j = (-(c(20)*M(1,:)%j)) * den(9)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(938),h0tab(:,938),[17,2,8,4],[nMB,nMW,nMW,nMW],4,1,wf4(:,12))
  call Hloop_SQ_A(ntryL,G0H32(1),wf4(:,12),G0H8(37),ngPbt,m3h4x8(:,32),heltab2x32(:,:,918))
  call Hloop_Q_A(ntryL,G0H8(37),17,nMB,G1H8(22),n2h8(160))
  Gcoeff(:)%j = (c(20)*M(1,:)%j) * den(9)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(939),h0tab(:,939),[17,2,8,4],[nMB,nMW,nMW,nMW],4,1,wf4(:,12))
  call Hloop_WQ_A(ntryL,G0H32(1),wf4(:,12),G0H8(37),m3h4x8(:,33),heltab2x32(:,:,919))
  call Hloop_Q_A(ntryL,G0H8(37),17,nMB,G1H8(21),n2h8(161))
  Gcoeff(:)%j = (-(c(47)*M(1,:)%j)) * den(9)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(940),h0tab(:,940),[17,2,8,4],[nMB,nMW,nMW,nMW],4,1,wf4(:,12))
  call Hloop_WQ_A(ntryL,G0H32(1),wf4(:,12),G0H8(37),m3h4x8(:,34),heltab2x32(:,:,920))
  call Hloop_Q_A(ntryL,G0H8(37),17,nMB,G1H8(23),n2h8(162))
  Gcoeff(:)%j = (-(c(20)*M(1,:)%j)) * den(9)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(941),h0tab(:,941),[17,2,8,4],[nMB,nMW,nMW,nMW],4,1,wf4(:,12))
  call Hloop_SQ_A(ntryL,G0H32(1),wf4(:,12),G0H8(37),ngPbt,m3h4x8(:,35),heltab2x32(:,:,921))
  call Hloop_Q_A(ntryL,G0H8(37),17,nMB,G1H8(24),n2h8(163))
  Gcoeff(:)%j = (c(20)*M(1,:)%j) * den(9)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(942),h0tab(:,942),[17,2,8,4],[nMB,nMW,nMW,nMW],4,1,wf4(:,12))
  call Hloop_WQ_A(ntryL,G0H32(1),wf4(:,12),G0H8(37),m3h4x8(:,36),heltab2x32(:,:,922))
  call Hloop_Q_A(ntryL,G0H8(37),17,nMB,G1H8(28),n2h8(164))
  Gcoeff(:)%j = (-(c(33)*M(1,:)%j)) * den(4)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(943),h0tab(:,943),[18,4,1,8],[nMB,nMB,nMW,nMW],4,1,wf4(:,6))
  call Hloop_SA_Q(ntryL,G0H32(1),wf4(:,6),G0H8(37),ngPtb,m3h4x8(:,37),heltab2x32(:,:,923))
  call Hloop_A_Q(ntryL,G0H8(37),18,nMB,G1H8(38),n2h8(165))
  Gcoeff(:)%j = (-(c(33)*M(1,:)%j)) * den(4)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(944),h0tab(:,944),[18,4,1,8],[nMW,nMW,nMB,nMB],4,1,wf4(:,6))
  call Hloop_QA_S(ntryL,G0H32(1),wf4(:,6),G0H8(37),ngPtb,m3h4x8(:,38),heltab2x32(:,:,924))
  Gcoeff(:)%j = (c(16)*M(1,:)%j) * den(4)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(945),h0tab(:,945),[18,4,1,8],[nMB,nMB,nMW,nMW],4,1,wf4(:,6))
  call Hloop_WA_Q(ntryL,G0H32(1),wf4(:,6),G0H8(38),m3h4x8(:,39),heltab2x32(:,:,925))
  call Hloop_A_Q(ntryL,G0H8(38),18,nMB,G1H8(37),n2h8(166))
  Gcoeff(:)%j = (-(c(16)*M(1,:)%j)) * den(4)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(946),h0tab(:,946),[18,4,1,8],[nMB,nMB,nMW,nMW],4,1,wf4(:,6))
  call Hloop_SA_Q(ntryL,G0H32(1),wf4(:,6),G0H8(38),ngPtb,m3h4x8(:,40),heltab2x32(:,:,926))
  call Hloop_A_Q(ntryL,G0H8(38),18,nMB,G1H8(40),n2h8(167))
  Gcoeff(:)%j = (c(16)*M(1,:)%j) * den(4)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(947),h0tab(:,947),[18,4,1,8],[nMW,nMW,nMB,nMB],4,1,wf4(:,6))
  call Hloop_QA_W(ntryL,G0H32(1),wf4(:,6),G0H8(38),m3h4x8(:,41),heltab2x32(:,:,927))
  Gcoeff(:)%j = (-(c(16)*M(1,:)%j)) * den(4)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(948),h0tab(:,948),[18,4,1,8],[nMW,nMW,nMB,nMB],4,1,wf4(:,6))
  call Hloop_QA_S(ntryL,G0H32(1),wf4(:,6),G0H8(39),ngPtb,m3h4x8(:,42),heltab2x32(:,:,928))
  Gcoeff(:)%j = (-(c(16)*M(1,:)%j)) * den(4)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(949),h0tab(:,949),[18,4,1,8],[nMB,nMB,nMW,nMW],4,1,wf4(:,6))
  call Hloop_WA_Q(ntryL,G0H32(1),wf4(:,6),G0H8(40),m3h4x8(:,43),heltab2x32(:,:,929))
  call Hloop_A_Q(ntryL,G0H8(40),18,nMB,G1H8(42),n2h8(168))
  Gcoeff(:)%j = (-(c(16)*M(1,:)%j)) * den(4)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(950),h0tab(:,950),[18,4,1,8],[nMW,nMW,nMB,nMB],4,1,wf4(:,6))
  call Hloop_QA_W(ntryL,G0H32(1),wf4(:,6),G0H8(40),m3h4x8(:,44),heltab2x32(:,:,930))
  Gcoeff(:)%j = (-(c(45)*M(1,:)%j)) * den(4)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(951),h0tab(:,951),[18,1,4,8],[nMH,nMT,nMT,nMT],4,1,wf4(:,6))
  call Hloop_QA_S(ntryL,G0H32(1),wf4(:,6),G0H8(41),ngH,m3h4x8(:,45),heltab2x32(:,:,931))
  Gcoeff(:)%j = (c(45)*M(1,:)%j) * den(4)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(952),h0tab(:,952),[18,1,4,8],[nMZ,nMT,nMT,nMT],4,1,wf4(:,6))
  call Hloop_QA_S(ntryL,G0H32(1),wf4(:,6),G0H8(42),ngX,m3h4x8(:,46),heltab2x32(:,:,932))
  Gcoeff(:)%j = (c(30)*M(1,:)%j) * den(4)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(953),h0tab(:,953),[18,1,4,8],[nMW,nMB,nMB,nMB],4,1,wf4(:,6))
  call Hloop_QA_S(ntryL,G0H32(1),wf4(:,6),G0H8(43),ngPtb,m3h4x8(:,47),heltab2x32(:,:,933))
  Gcoeff(:)%j = (c(37)*M(1,:)%j) * den(4)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(954),h0tab(:,954),[18,1,4,8],[nMB,nMW,nMW,nMW],4,1,wf4(:,6))
  call Hloop_SA_Q(ntryL,G0H32(1),wf4(:,6),G0H8(44),ngPtb,m3h4x8(:,48),heltab2x32(:,:,934))
  call Hloop_A_Q(ntryL,G0H8(44),18,nMB,G1H8(41),n2h8(169))
  Gcoeff(:)%j = (c(1)*M(1,:)%j) * den(4)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(955),h0tab(:,955),[18,1,4,8],[0,nMT,nMT,nMT],4,1,wf4(:,6))
  call Hloop_QA_V(ntryL,G0H32(1),wf4(:,6),G0H8(44),m3h4x8(:,49),heltab2x32(:,:,935))
  Gcoeff(:)%j = (c(2)*M(1,:)%j) * den(4)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(956),h0tab(:,956),[18,1,4,8],[nMZ,nMT,nMT,nMT],4,1,wf4(:,6))
  call Hloop_QA_Z(ntryL,G0H32(1),wf4(:,6),G0H8(45),ngZu,m3h4x8(:,50),heltab2x32(:,:,936))
  Gcoeff(:)%j = (c(13)*M(1,:)%j) * den(4)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(957),h0tab(:,957),[18,1,4,8],[nMW,nMB,nMB,nMB],4,1,wf4(:,6))
  call Hloop_QA_W(ntryL,G0H32(1),wf4(:,6),G0H8(46),m3h4x8(:,51),heltab2x32(:,:,937))
  Gcoeff(:)%j = (-(c(20)*M(1,:)%j)) * den(4)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(958),h0tab(:,958),[18,1,4,8],[nMB,nMW,nMW,nMW],4,1,wf4(:,6))
  call Hloop_WA_Q(ntryL,G0H32(1),wf4(:,6),G0H8(47),m3h4x8(:,52),heltab2x32(:,:,938))
  call Hloop_A_Q(ntryL,G0H8(47),18,nMB,G1H8(44),n2h8(170))
  Gcoeff(:)%j = (-(c(20)*M(1,:)%j)) * den(4)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(959),h0tab(:,959),[18,1,4,8],[nMB,nMW,nMW,nMW],4,1,wf4(:,6))
  call Hloop_SA_Q(ntryL,G0H32(1),wf4(:,6),G0H8(47),ngPtb,m3h4x8(:,53),heltab2x32(:,:,939))
  call Hloop_A_Q(ntryL,G0H8(47),18,nMB,G1H8(43),n2h8(171))
  Gcoeff(:)%j = (c(20)*M(1,:)%j) * den(4)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(960),h0tab(:,960),[18,1,4,8],[nMB,nMW,nMW,nMW],4,1,wf4(:,6))
  call Hloop_SA_Q(ntryL,G0H32(1),wf4(:,6),G0H8(47),ngPtb,m3h4x8(:,54),heltab2x32(:,:,940))
  call Hloop_A_Q(ntryL,G0H8(47),18,nMB,G1H8(52),n2h8(172))
  Gcoeff(:)%j = (-(c(20)*M(1,:)%j)) * den(4)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(961),h0tab(:,961),[18,1,4,8],[nMB,nMW,nMW,nMW],4,1,wf4(:,6))
  call Hloop_WA_Q(ntryL,G0H32(1),wf4(:,6),G0H8(47),m3h4x8(:,55),heltab2x32(:,:,941))
  call Hloop_A_Q(ntryL,G0H8(47),18,nMB,G1H8(51),n2h8(173))
  Gcoeff(:)%j = (-(c(47)*M(1,:)%j)) * den(4)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(962),h0tab(:,962),[18,1,4,8],[nMB,nMW,nMW,nMW],4,1,wf4(:,6))
  call Hloop_WA_Q(ntryL,G0H32(1),wf4(:,6),G0H8(47),m3h4x8(:,56),heltab2x32(:,:,942))
  call Hloop_A_Q(ntryL,G0H8(47),18,nMB,G1H8(56),n2h8(174))
  Gcoeff(:)%j = (c(20)*M(1,:)%j) * den(4)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(963),h0tab(:,963),[18,1,4,8],[nMB,nMW,nMW,nMW],4,1,wf4(:,6))
  call Hloop_SA_Q(ntryL,G0H32(1),wf4(:,6),G0H8(47),ngPtb,m3h4x8(:,57),heltab2x32(:,:,943))
  call Hloop_A_Q(ntryL,G0H8(47),18,nMB,G1H8(53),n2h8(175))
  Gcoeff(:)%j = (c(20)*M(1,:)%j) * den(4)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(964),h0tab(:,964),[18,1,4,8],[nMB,nMW,nMW,nMW],4,1,wf4(:,6))
  call Hloop_WA_Q(ntryL,G0H32(1),wf4(:,6),G0H8(47),m3h4x8(:,58),heltab2x32(:,:,944))
  call Hloop_A_Q(ntryL,G0H8(47),18,nMB,G1H8(54),n2h8(176))
  Gcoeff(:)%j = (-(c(45)*M(1,:)%j)) * den(4)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(965),h0tab(:,965),[18,1,8,4],[nMH,nMT,nMT,nMT],4,1,wf4(:,6))
  call Hloop_QA_S(ntryL,G0H32(1),wf4(:,6),G0H8(47),ngH,m3h4x8(:,59),heltab2x32(:,:,945))
  Gcoeff(:)%j = (c(45)*M(1,:)%j) * den(4)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(966),h0tab(:,966),[18,1,8,4],[nMZ,nMT,nMT,nMT],4,1,wf4(:,6))
  call Hloop_QA_S(ntryL,G0H32(1),wf4(:,6),G0H8(48),ngX,m3h4x8(:,60),heltab2x32(:,:,946))
  Gcoeff(:)%j = (c(30)*M(1,:)%j) * den(4)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(967),h0tab(:,967),[18,1,8,4],[nMW,nMB,nMB,nMB],4,1,wf4(:,6))
  call Hloop_QA_S(ntryL,G0H32(1),wf4(:,6),G0H8(49),ngPtb,m3h4x8(:,61),heltab2x32(:,:,947))
  Gcoeff(:)%j = (c(37)*M(1,:)%j) * den(4)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(968),h0tab(:,968),[18,1,8,4],[nMB,nMW,nMW,nMW],4,1,wf4(:,6))
  call Hloop_SA_Q(ntryL,G0H32(1),wf4(:,6),G0H8(50),ngPtb,m3h4x8(:,62),heltab2x32(:,:,948))
  call Hloop_A_Q(ntryL,G0H8(50),18,nMB,G1H8(58),n2h8(177))
  Gcoeff(:)%j = (c(1)*M(1,:)%j) * den(4)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(969),h0tab(:,969),[18,1,8,4],[0,nMT,nMT,nMT],4,1,wf4(:,6))
  call Hloop_QA_V(ntryL,G0H32(1),wf4(:,6),G0H8(50),m3h4x8(:,63),heltab2x32(:,:,949))
  Gcoeff(:)%j = (c(2)*M(1,:)%j) * den(4)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(970),h0tab(:,970),[18,1,8,4],[nMZ,nMT,nMT,nMT],4,1,wf4(:,6))
  call Hloop_QA_Z(ntryL,G0H32(1),wf4(:,6),G0H8(51),ngZu,m3h4x8(:,64),heltab2x32(:,:,950))
  Gcoeff(:)%j = (c(13)*M(1,:)%j) * den(4)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(971),h0tab(:,971),[18,1,8,4],[nMW,nMB,nMB,nMB],4,1,wf4(:,6))
  call Hloop_QA_W(ntryL,G0H32(1),wf4(:,6),G0H8(52),m3h4x8(:,65),heltab2x32(:,:,951))
  Gcoeff(:)%j = (-(c(20)*M(1,:)%j)) * den(4)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(972),h0tab(:,972),[18,1,8,4],[nMB,nMW,nMW,nMW],4,1,wf4(:,6))
  call Hloop_WA_Q(ntryL,G0H32(1),wf4(:,6),G0H8(53),m3h4x8(:,66),heltab2x32(:,:,952))
  call Hloop_A_Q(ntryL,G0H8(53),18,nMB,G1H8(57),n2h8(178))
  Gcoeff(:)%j = (-(c(20)*M(1,:)%j)) * den(4)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(973),h0tab(:,973),[18,1,8,4],[nMB,nMW,nMW,nMW],4,1,wf4(:,6))
  call Hloop_SA_Q(ntryL,G0H32(1),wf4(:,6),G0H8(53),ngPtb,m3h4x8(:,67),heltab2x32(:,:,953))
  call Hloop_A_Q(ntryL,G0H8(53),18,nMB,G1H8(65),n2h8(179))
  Gcoeff(:)%j = (c(20)*M(1,:)%j) * den(4)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(974),h0tab(:,974),[18,1,8,4],[nMB,nMW,nMW,nMW],4,1,wf4(:,6))
  call Hloop_SA_Q(ntryL,G0H32(1),wf4(:,6),G0H8(53),ngPtb,m3h4x8(:,68),heltab2x32(:,:,954))
  call Hloop_A_Q(ntryL,G0H8(53),18,nMB,G1H8(69),n2h8(180))
  Gcoeff(:)%j = (-(c(20)*M(1,:)%j)) * den(4)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(975),h0tab(:,975),[18,1,8,4],[nMB,nMW,nMW,nMW],4,1,wf4(:,6))
  call Hloop_WA_Q(ntryL,G0H32(1),wf4(:,6),G0H8(53),m3h4x8(:,69),heltab2x32(:,:,955))
  call Hloop_A_Q(ntryL,G0H8(53),18,nMB,G1H8(70),n2h8(181))
  Gcoeff(:)%j = (-(c(47)*M(1,:)%j)) * den(4)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(976),h0tab(:,976),[18,1,8,4],[nMB,nMW,nMW,nMW],4,1,wf4(:,6))
  call Hloop_WA_Q(ntryL,G0H32(1),wf4(:,6),G0H8(53),m3h4x8(:,70),heltab2x32(:,:,956))
  call Hloop_A_Q(ntryL,G0H8(53),18,nMB,G1H8(67),n2h8(182))
  Gcoeff(:)%j = (c(20)*M(1,:)%j) * den(4)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(977),h0tab(:,977),[18,1,8,4],[nMB,nMW,nMW,nMW],4,1,wf4(:,6))
  call Hloop_SA_Q(ntryL,G0H32(1),wf4(:,6),G0H8(53),ngPtb,m3h4x8(:,71),heltab2x32(:,:,957))
  call Hloop_A_Q(ntryL,G0H8(53),18,nMB,G1H8(68),n2h8(183))
  Gcoeff(:)%j = (c(20)*M(1,:)%j) * den(4)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(978),h0tab(:,978),[18,1,8,4],[nMB,nMW,nMW,nMW],4,1,wf4(:,6))
  call Hloop_WA_Q(ntryL,G0H32(1),wf4(:,6),G0H8(53),m3h4x8(:,72),heltab2x32(:,:,958))
  call Hloop_A_Q(ntryL,G0H8(53),18,nMB,G1H8(71),n2h8(184))
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H8(4),[G0H8(15)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H8(17),[G0H8(16)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H8(27),[G0H8(17)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H8(39),[G0H8(18)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H8(55),[G0H8(11)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H8(66),[G0H8(12)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H8(72),[G0H8(13)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H8(85),[G0H8(14)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H8(38),[G1H8(96)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H8(37),[G1H8(114)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H8(40),[G1H8(7)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H8(42),[G1H8(13)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H8(118),[G1H8(83)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H8(119),[G1H8(126)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H8(120),[G1H8(132)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H8(121),[G1H8(137)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H16(31),[G1H16(29)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H16(32),[G1H16(30)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H16(35),[G1H16(33)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H16(36),[G1H16(34)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H16(44),[G1H16(43)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G0H16(35),[G0H16(34)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G0H16(37),[G0H16(36)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G0H16(39),[G0H16(38)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G0H16(41),[G0H16(40)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H16(54),[G1H16(53)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H16(69),[G1H16(65)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H16(71),[G1H16(67)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H16(93),[G1H16(91)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H16(94),[G1H16(92)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H16(97),[G1H16(95)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H16(98),[G1H16(96)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G0H16(50),[G0H16(25)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G0H16(52),[G0H16(51)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G0H16(54),[G0H16(53)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G0H16(56),[G0H16(55)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H16(151),[G1H16(149)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H16(152),[G1H16(150)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H16(155),[G1H16(153)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H16(156),[G1H16(154)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H16(164),[G1H16(163)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G0H16(70),[G0H16(5)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G0H16(72),[G0H16(71)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G0H16(74),[G0H16(73)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G0H16(76),[G0H16(75)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H16(174),[G1H16(173)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H16(189),[G1H16(185)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H16(191),[G1H16(187)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H16(213),[G1H16(211)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H16(214),[G1H16(212)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H16(217),[G1H16(215)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H16(218),[G1H16(216)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G0H16(98),[G0H16(97)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G0H16(100),[G0H16(99)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G0H16(102),[G0H16(101)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G0H16(104),[G0H16(103)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H16(271),[G1H16(269)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H16(272),[G1H16(270)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H16(275),[G1H16(273)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H16(276),[G1H16(274)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H16(288),[G1H16(287)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G0H16(126),[G0H16(125)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G0H16(128),[G0H16(127)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G0H16(130),[G0H16(129)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G0H16(132),[G0H16(131)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H16(290),[G1H16(289)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H16(309),[G1H16(305)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H16(311),[G1H16(307)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H16(333),[G1H16(331)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H16(334),[G1H16(332)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H16(337),[G1H16(335)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H16(338),[G1H16(336)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G0H16(154),[G0H16(153)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G0H16(156),[G0H16(155)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G0H16(158),[G0H16(157)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G0H16(160),[G0H16(159)])
  call Hloop_SQ_A(ntryL,G1H8(4),ex1(:),G1H4(357),ngPbt,m3h2x4(:,249),heltab2x8(:,:,249))
  call Hloop_Q_A(ntryL,G1H4(357),21,nMB,G2H4(27),n2h4(213))
  call Hloop_SQ_A(ntryL,G1H8(17),ex1(:),G1H4(358),ngPbt,m3h2x4(:,250),heltab2x8(:,:,250))
  call Hloop_Q_A(ntryL,G1H4(358),21,nMB,G2H4(28),n2h4(214))
  call Hloop_WQ_A(ntryL,G1H8(27),ex1(:),G1H4(373),m3h2x4(:,251),heltab2x8(:,:,251))
  call Hloop_Q_A(ntryL,G1H4(373),21,nMB,G2H4(29),n2h4(215))
  call Hloop_WQ_A(ntryL,G1H8(39),ex1(:),G1H4(374),m3h2x4(:,252),heltab2x8(:,:,252))
  call Hloop_Q_A(ntryL,G1H4(374),21,nMB,G2H4(30),n2h4(216))
  call Hloop_SA_Q(ntryL,G1H8(55),ex2(:),G1H4(389),ngPtb,m3h2x4(:,253),heltab2x8(:,:,253))
  call Hloop_A_Q(ntryL,G1H4(389),22,nMB,G2H4(120),n2h4(217))
  call Hloop_SA_Q(ntryL,G1H8(66),ex2(:),G1H4(390),ngPtb,m3h2x4(:,254),heltab2x8(:,:,254))
  call Hloop_A_Q(ntryL,G1H4(390),22,nMB,G2H4(111),n2h4(218))
  call Hloop_WA_Q(ntryL,G1H8(72),ex2(:),G1H4(405),m3h2x4(:,255),heltab2x8(:,:,255))
  call Hloop_A_Q(ntryL,G1H4(405),22,nMB,G2H4(124),n2h4(219))
  call Hloop_WA_Q(ntryL,G1H8(85),ex2(:),G1H4(406),m3h2x4(:,256),heltab2x8(:,:,256))
  call Hloop_A_Q(ntryL,G1H4(406),22,nMB,G2H4(116),n2h4(220))
  call Hloop_AV_Q(ntryL,G1H8(38),ex3(:),G1H4(33),m3h2x4(:,257),heltab2x8(:,:,257))
  call Hloop_A_Q(ntryL,G1H4(33),22,nMB,G2H4(35),n2h4(221))
  call Hloop_AV_Q(ntryL,G1H8(37),ex3(:),G1H4(1),m3h2x4(:,258),heltab2x8(:,:,258))
  call Hloop_A_Q(ntryL,G1H4(1),22,nMB,G2H4(40),n2h4(222))
  call Hloop_AV_Q(ntryL,G1H8(40),ex3(:),G1H4(4),m3h2x4(:,259),heltab2x8(:,:,259))
  call Hloop_A_Q(ntryL,G1H4(4),22,nMB,G2H4(41),n2h4(223))
  call Hloop_AV_Q(ntryL,G1H8(42),ex3(:),G1H4(6),m3h2x4(:,260),heltab2x8(:,:,260))
  call Hloop_A_Q(ntryL,G1H4(6),22,nMB,G2H4(38),n2h4(224))
  call Hloop_AV_Q(ntryL,G1H8(31),ex4(:),G1H4(5),m3h2x4(:,261),heltab2x8(:,:,261))
  call Hloop_A_Q(ntryL,G1H4(5),26,nMB,G2H4(39),n2h4(225))
  call Hloop_AV_Q(ntryL,G1H8(45),ex4(:),G1H4(8),m3h2x4(:,262),heltab2x8(:,:,262))
  call Hloop_A_Q(ntryL,G1H4(8),26,nMB,G2H4(42),n2h4(226))
  call Hloop_AV_Q(ntryL,G1H8(59),ex4(:),G1H4(9),m3h2x4(:,263),heltab2x8(:,:,263))
  call Hloop_A_Q(ntryL,G1H4(9),26,nMB,G2H4(43),n2h4(227))
  call Hloop_AV_Q(ntryL,G1H8(73),ex4(:),G1H4(12),m3h2x4(:,264),heltab2x8(:,:,264))
  call Hloop_A_Q(ntryL,G1H4(12),26,nMB,G2H4(44),n2h4(228))
  call Hloop_QV_A(ntryL,G1H8(118),ex3(:),G1H4(11),m3h2x4(:,265),heltab2x8(:,:,265))
  call Hloop_Q_A(ntryL,G1H4(11),21,nMB,G2H4(45),n2h4(229))
  call Hloop_QV_A(ntryL,G1H8(119),ex3(:),G1H4(14),m3h2x4(:,266),heltab2x8(:,:,266))
  call Hloop_Q_A(ntryL,G1H4(14),21,nMB,G2H4(46),n2h4(230))
  call Hloop_QV_A(ntryL,G1H8(120),ex3(:),G1H4(15),m3h2x4(:,267),heltab2x8(:,:,267))
  call Hloop_Q_A(ntryL,G1H4(15),21,nMB,G2H4(47),n2h4(231))
  call Hloop_QV_A(ntryL,G1H8(121),ex3(:),G1H4(34),m3h2x4(:,268),heltab2x8(:,:,268))
  call Hloop_Q_A(ntryL,G1H4(34),21,nMB,G2H4(48),n2h4(232))
  call Hloop_QV_A(ntryL,G1H8(143),ex3(:),G1H4(35),m3h2x4(:,269),heltab2x8(:,:,269))
  call Hloop_Q_A(ntryL,G1H4(35),21,nMB,G2H4(49),n2h4(233))
  call Hloop_QV_A(ntryL,G1H8(148),ex3(:),G1H4(36),m3h2x4(:,270),heltab2x8(:,:,270))
  call Hloop_Q_A(ntryL,G1H4(36),21,nMB,G2H4(54),n2h4(234))
  call Hloop_QV_A(ntryL,G1H8(102),ex4(:),G1H4(39),m3h2x4(:,271),heltab2x8(:,:,271))
  call Hloop_Q_A(ntryL,G1H4(39),25,nMB,G2H4(55),n2h4(235))
  call Hloop_QV_A(ntryL,G1H8(108),ex4(:),G1H4(40),m3h2x4(:,272),heltab2x8(:,:,272))
  call Hloop_Q_A(ntryL,G1H4(40),25,nMB,G2H4(52),n2h4(236))
  call Hloop_QV_A(ntryL,G1H8(156),ex4(:),G1H4(41),m3h2x4(:,273),heltab2x8(:,:,273))
  call Hloop_Q_A(ntryL,G1H4(41),25,nMB,G2H4(53),n2h4(237))
  call Hloop_QV_A(ntryL,G1H8(161),ex4(:),G1H4(42),m3h2x4(:,274),heltab2x8(:,:,274))
  call Hloop_Q_A(ntryL,G1H4(42),25,nMB,G2H4(56),n2h4(238))
  call Hloop_QV_A(ntryL,G1H8(167),ex4(:),G1H4(45),m3h2x4(:,275),heltab2x8(:,:,275))
  call Hloop_Q_A(ntryL,G1H4(45),25,nMB,G2H4(57),n2h4(239))
  call Hloop_QV_A(ntryL,G1H8(172),ex4(:),G1H4(46),m3h2x4(:,276),heltab2x8(:,:,276))
  call Hloop_Q_A(ntryL,G1H4(46),25,nMB,G2H4(58),n2h4(240))
  call Hloop_SA_Q(ntryL,G0H8(9),ex2(:),G0H4(1),ngPtb,m3h2x4(:,277),heltab2x8(:,:,277))
  call Hloop_A_Q(ntryL,G0H4(1),26,nMB,G1H4(47),n2h4(241))
  call Hloop_SA_Q(ntryL,G0H8(1),ex2(:),G0H4(1),ngPtb,m3h2x4(:,278),heltab2x8(:,:,278))
  call Hloop_A_Q(ntryL,G0H4(1),26,nMB,G1H4(48),n2h4(242))
  call Hloop_WA_Q(ntryL,G0H8(2),ex2(:),G0H4(1),m3h2x4(:,279),heltab2x8(:,:,279))
  call Hloop_A_Q(ntryL,G0H4(1),26,nMB,G1H4(51),n2h4(243))
  call Hloop_WA_Q(ntryL,G0H8(3),ex2(:),G0H4(1),m3h2x4(:,280),heltab2x8(:,:,280))
  call Hloop_A_Q(ntryL,G0H4(1),26,nMB,G1H4(52),n2h4(244))
  call Hloop_SQ_A(ntryL,G0H8(4),ex1(:),G0H4(1),ngPbt,m3h2x4(:,281),heltab2x8(:,:,281))
  call Hloop_Q_A(ntryL,G0H4(1),25,nMB,G1H4(53),n2h4(245))
  call Hloop_SQ_A(ntryL,G0H8(5),ex1(:),G0H4(1),ngPbt,m3h2x4(:,282),heltab2x8(:,:,282))
  call Hloop_Q_A(ntryL,G0H4(1),25,nMB,G1H4(54),n2h4(246))
  call Hloop_WQ_A(ntryL,G0H8(7),ex1(:),G0H4(1),m3h2x4(:,283),heltab2x8(:,:,283))
  call Hloop_Q_A(ntryL,G0H4(1),25,nMB,G1H4(57),n2h4(247))
  call Hloop_WQ_A(ntryL,G0H8(6),ex1(:),G0H4(1),m3h2x4(:,284),heltab2x8(:,:,284))
  call Hloop_Q_A(ntryL,G0H4(1),25,nMB,G1H4(58),n2h4(248))
  call Hloop_SQ_A(ntryL,G0H8(8),ex1(:),G0H4(1),ngPbt,m3h2x4(:,285),heltab2x8(:,:,285))
  call Hloop_Q_A(ntryL,G0H4(1),25,nMB,G1H4(59),n2h4(249))
  call Hloop_WQ_A(ntryL,G0H8(10),ex1(:),G0H4(1),m3h2x4(:,286),heltab2x8(:,:,286))
  call Hloop_Q_A(ntryL,G0H4(1),25,nMB,G1H4(60),n2h4(250))
  call Hloop_SQ_A(ntryL,G0H8(19),ex1(:),G0H4(1),ngPbt,m3h2x4(:,287),heltab2x8(:,:,287))
  call Hloop_Q_A(ntryL,G0H4(1),21,nMB,G1H4(63),n2h4(251))
  call Hloop_WQ_A(ntryL,G0H8(20),ex1(:),G0H4(1),m3h2x4(:,288),heltab2x8(:,:,288))
  call Hloop_Q_A(ntryL,G0H4(1),21,nMB,G1H4(64),n2h4(252))
  call Hloop_SQ_A(ntryL,G1H16(1),ex1(:),G1H8(77),ngPbt,m3h2x8(:,205),heltab2x16(:,:,205))
  call Hloop_Q_A(ntryL,G1H8(77),17,nMB,G2H8(1),n2h8(185))
  call Hloop_WQ_A(ntryL,G0H16(69),ex1(:),G0H8(53),m3h2x8(:,206),heltab2x16(:,:,206))
  call Hloop_Q_A(ntryL,G0H8(53),17,nMB,G1H8(76),n2h8(186))
  call Hloop_SQ_A(ntryL,G0H16(1),ex1(:),G0H8(15),ngPbt,m3h2x8(:,207),heltab2x16(:,:,207))
  call Hloop_Q_A(ntryL,G0H8(15),17,nMB,G1H8(80),n2h8(187))
  call Hloop_WQ_A(ntryL,G1H16(2),ex1(:),G1H8(79),m3h2x8(:,208),heltab2x16(:,:,208))
  call Hloop_Q_A(ntryL,G1H8(79),17,nMB,G2H8(2),n2h8(188))
  call Hloop_SA_Q(ntryL,G1H16(3),ex2(:),G1H8(84),ngPtb,m3h2x8(:,209),heltab2x16(:,:,209))
  call Hloop_A_Q(ntryL,G1H8(84),18,nMB,G2H8(3),n2h8(189))
  call Hloop_WA_Q(ntryL,G0H16(2),ex2(:),G0H8(16),m3h2x8(:,210),heltab2x16(:,:,210))
  call Hloop_A_Q(ntryL,G0H8(16),18,nMB,G1H8(88),n2h8(190))
  call Hloop_SA_Q(ntryL,G0H16(3),ex2(:),G0H8(17),ngPtb,m3h2x8(:,211),heltab2x16(:,:,211))
  call Hloop_A_Q(ntryL,G0H8(17),18,nMB,G1H8(87),n2h8(191))
  call Hloop_WA_Q(ntryL,G1H16(4),ex2(:),G1H8(93),m3h2x8(:,212),heltab2x16(:,:,212))
  call Hloop_A_Q(ntryL,G1H8(93),18,nMB,G2H8(4),n2h8(192))
  call Hloop_AQ_S(ntryL,G1H16(5),ex1(:),G1H8(92),ngPbt,m3h2x8(:,213),heltab2x16(:,:,213))
  call Hloop_AQ_W(ntryL,G1H16(6),ex1(:),G1H8(95),m3h2x8(:,214),heltab2x16(:,:,214))
  call Hloop_QS_A(ntryL,G1H16(7),wf4(:,36),G1H4(65),ngH,m3h4x4(:,1),heltab2x16(:,:,215))
  call Hloop_Q_A(ntryL,G1H4(65),19,nME,G2H4(59),n2h4(253))
  call Hloop_QS_A(ntryL,G1H16(8),wf4(:,36),G1H4(66),ngH,m3h4x4(:,2),heltab2x16(:,:,216))
  call Hloop_Q_A(ntryL,G1H4(66),19,nMM,G2H4(60),n2h4(254))
  call Hloop_QS_A(ntryL,G1H16(9),wf4(:,36),G1H4(69),ngH,m3h4x4(:,3),heltab2x16(:,:,217))
  call Hloop_Q_A(ntryL,G1H4(69),19,nML,G2H4(61),n2h4(255))
  call Hloop_AS_Q(ntryL,G1H16(10),wf4(:,36),G1H4(70),ngH,m3h4x4(:,4),heltab2x16(:,:,218))
  call Hloop_A_Q(ntryL,G1H4(70),19,nME,G2H4(62),n2h4(256))
  call Hloop_AS_Q(ntryL,G1H16(11),wf4(:,36),G1H4(71),ngH,m3h4x4(:,5),heltab2x16(:,:,219))
  call Hloop_A_Q(ntryL,G1H4(71),19,nMM,G2H4(63),n2h4(257))
  call Hloop_AS_Q(ntryL,G1H16(12),wf4(:,36),G1H4(72),ngH,m3h4x4(:,6),heltab2x16(:,:,220))
  call Hloop_A_Q(ntryL,G1H4(72),19,nML,G2H4(68),n2h4(258))
  call Hloop_QS_A(ntryL,G1H16(13),wf4(:,36),G1H4(75),ngH,m3h4x4(:,7),heltab2x16(:,:,221))
  call Hloop_Q_A(ntryL,G1H4(75),19,nMT,G2H4(69),n2h4(259))
  call Hloop_AS_Q(ntryL,G1H16(14),wf4(:,36),G1H4(76),ngH,m3h4x4(:,8),heltab2x16(:,:,222))
  call Hloop_A_Q(ntryL,G1H4(76),19,nMT,G2H4(66),n2h4(260))
  call Hloop_QS_A(ntryL,G1H16(15),wf4(:,36),G1H4(77),ngH,m3h4x4(:,9),heltab2x16(:,:,223))
  call Hloop_Q_A(ntryL,G1H4(77),19,nMB,G2H4(67),n2h4(261))
  call Hloop_AS_Q(ntryL,G1H16(16),wf4(:,36),G1H4(78),ngH,m3h4x4(:,10),heltab2x16(:,:,224))
  call Hloop_A_Q(ntryL,G1H4(78),19,nMB,G2H4(70),n2h4(262))
  call Hloop_QS_A(ntryL,G1H16(17),wf4(:,37),G1H4(81),ngX,m3h4x4(:,11),heltab2x16(:,:,225))
  call Hloop_Q_A(ntryL,G1H4(81),19,nME,G2H4(71),n2h4(263))
  call Hloop_QS_A(ntryL,G1H16(18),wf4(:,37),G1H4(82),ngX,m3h4x4(:,12),heltab2x16(:,:,226))
  call Hloop_Q_A(ntryL,G1H4(82),19,nMM,G2H4(72),n2h4(264))
  call Hloop_QS_A(ntryL,G1H16(19),wf4(:,37),G1H4(83),ngX,m3h4x4(:,13),heltab2x16(:,:,227))
  call Hloop_Q_A(ntryL,G1H4(83),19,nML,G2H4(73),n2h4(265))
  call Hloop_AS_Q(ntryL,G1H16(20),wf4(:,37),G1H4(84),ngX,m3h4x4(:,14),heltab2x16(:,:,228))
  call Hloop_A_Q(ntryL,G1H4(84),19,nME,G2H4(74),n2h4(266))
  call Hloop_AS_Q(ntryL,G1H16(21),wf4(:,37),G1H4(87),ngX,m3h4x4(:,15),heltab2x16(:,:,229))
  call Hloop_A_Q(ntryL,G1H4(87),19,nMM,G2H4(75),n2h4(267))
  call Hloop_AS_Q(ntryL,G1H16(22),wf4(:,37),G1H4(88),ngX,m3h4x4(:,16),heltab2x16(:,:,230))
  call Hloop_A_Q(ntryL,G1H4(88),19,nML,G2H4(76),n2h4(268))
  call Hloop_QS_A(ntryL,G1H16(23),wf4(:,37),G1H4(89),ngX,m3h4x4(:,17),heltab2x16(:,:,231))
  call Hloop_Q_A(ntryL,G1H4(89),19,nMT,G2H4(77),n2h4(269))
  call Hloop_AS_Q(ntryL,G1H16(24),wf4(:,37),G1H4(90),ngX,m3h4x4(:,18),heltab2x16(:,:,232))
  call Hloop_A_Q(ntryL,G1H4(90),19,nMT,G2H4(78),n2h4(270))
  call Hloop_QS_A(ntryL,G1H16(25),wf4(:,37),G1H4(93),ngX,m3h4x4(:,19),heltab2x16(:,:,233))
  call Hloop_Q_A(ntryL,G1H4(93),19,nMB,G2H4(79),n2h4(271))
  call Hloop_AS_Q(ntryL,G1H16(26),wf4(:,37),G1H4(94),ngX,m3h4x4(:,20),heltab2x16(:,:,234))
  call Hloop_A_Q(ntryL,G1H4(94),19,nMB,G2H4(80),n2h4(272))
  call Hloop_SS_S(ntryL,G1H16(27),wf4(:,36),G1H4(95),m3h4x4(:,21),heltab2x16(:,:,235))
  call Hloop_SS_S(ntryL,G1H16(28),wf4(:,36),G1H4(96),m3h4x4(:,22),heltab2x16(:,:,236))
  call Hloop_SS_S(ntryL,G1H16(31),wf4(:,36),G1H4(99),m3h4x4(:,23),heltab2x16(:,:,237))
  call Hloop_SS_S(ntryL,G1H16(32),wf4(:,36),G1H4(100),m3h4x4(:,24),heltab2x16(:,:,238))
  call Hloop_SS_S(ntryL,G1H16(35),wf4(:,37),G1H4(101),m3h4x4(:,25),heltab2x16(:,:,239))
  call Hloop_SS_S(ntryL,G1H16(36),wf4(:,37),G1H4(102),m3h4x4(:,26),heltab2x16(:,:,240))
  call Hloop_VS_V(ntryL,G1H16(37),wf4(:,36),G1H4(105),m3h4x4(:,27),heltab2x16(:,:,241))
  call Hloop_VS_V(ntryL,G1H16(38),wf4(:,36),G1H4(106),m3h4x4(:,28),heltab2x16(:,:,242))
  call Hloop_VT_S(ntryL,G0H16(26),16,wf4(:,36),3,G1H4(107),m3h4x4(:,29),heltab2x16(:,:,243))
  call Hloop_VT_S(ntryL,G0H16(27),16,wf4(:,36),3,G1H4(108),m3h4x4(:,30),heltab2x16(:,:,244))
  call Hloop_VT_S(ntryL,G0H16(28),16,wf4(:,37),3,G1H4(111),m3h4x4(:,31),heltab2x16(:,:,245))
  call Hloop_VT_S(ntryL,G0H16(29),16,wf4(:,37),3,G1H4(112),m3h4x4(:,32),heltab2x16(:,:,246))
  call Hloop_ST_V(ntryL,G1H16(39),16,wf4(:,36),3,G2H4(81),m3h4x4(:,33),heltab2x16(:,:,247))
  call Hloop_ST_V(ntryL,G1H16(40),16,wf4(:,36),3,G2H4(82),m3h4x4(:,34),heltab2x16(:,:,248))
  call Hloop_ST_V(ntryL,G1H16(41),16,wf4(:,37),3,G2H4(83),m3h4x4(:,35),heltab2x16(:,:,249))
  call Hloop_ST_V(ntryL,G1H16(42),16,wf4(:,37),3,G2H4(85),m3h4x4(:,36),heltab2x16(:,:,250))
  call Hloop_SS_S(ntryL,G0H16(30),wf4(:,36),G0H4(1),m3h4x4(:,37),heltab2x16(:,:,251))
  call Hloop_SS_S(ntryL,G0H16(31),wf4(:,36),G0H4(2),m3h4x4(:,38),heltab2x16(:,:,252))
  call Hloop_SS_S(ntryL,G1H16(44),wf4(:,36),G1H4(113),m3h4x4(:,39),heltab2x16(:,:,253))
  call Hloop_VS_V(ntryL,G0H16(32),wf4(:,36),G0H4(3),m3h4x4(:,40),heltab2x16(:,:,254))
  call Hloop_VS_V(ntryL,G0H16(33),wf4(:,36),G0H4(4),m3h4x4(:,41),heltab2x16(:,:,255))
  call Hloop_VT_S(ntryL,G1H16(45),16,wf4(:,36),3,G2H4(84),m3h4x4(:,42),heltab2x16(:,:,256))
  call Hloop_VT_S(ntryL,G1H16(46),16,wf4(:,36),3,G2H4(86),m3h4x4(:,43),heltab2x16(:,:,257))
  call Hloop_VT_S(ntryL,G1H16(47),16,wf4(:,37),3,G2H4(87),m3h4x4(:,44),heltab2x16(:,:,258))
  call Hloop_VT_S(ntryL,G1H16(48),16,wf4(:,37),3,G2H4(88),m3h4x4(:,45),heltab2x16(:,:,259))
  call Hloop_ST_V(ntryL,G0H16(35),16,wf4(:,36),3,G1H4(114),m3h4x4(:,46),heltab2x16(:,:,260))
  call Hloop_ST_V(ntryL,G0H16(37),16,wf4(:,37),3,G1H4(117),m3h4x4(:,47),heltab2x16(:,:,261))
  call Hloop_VT_S(ntryL,G0H16(39),16,wf4(:,36),3,G1H4(118),m3h4x4(:,48),heltab2x16(:,:,262))
  call Hloop_VT_S(ntryL,G0H16(41),16,wf4(:,37),3,G1H4(119),m3h4x4(:,49),heltab2x16(:,:,263))
  call Hloop_ST_V(ntryL,G1H16(49),16,wf4(:,36),3,G2H4(89),m3h4x4(:,50),heltab2x16(:,:,264))
  call Hloop_ST_V(ntryL,G1H16(50),16,wf4(:,36),3,G2H4(91),m3h4x4(:,51),heltab2x16(:,:,265))
  call Hloop_ST_V(ntryL,G1H16(51),16,wf4(:,37),3,G2H4(90),m3h4x4(:,52),heltab2x16(:,:,266))
  call Hloop_ST_V(ntryL,G1H16(52),16,wf4(:,37),3,G2H4(92),m3h4x4(:,53),heltab2x16(:,:,267))
  call Hloop_SS_S(ntryL,G0H16(42),wf4(:,36),G0H4(5),m3h4x4(:,54),heltab2x16(:,:,268))
  call Hloop_SS_S(ntryL,G0H16(43),wf4(:,36),G0H4(6),m3h4x4(:,55),heltab2x16(:,:,269))
  call Hloop_VS_V(ntryL,G1H16(54),wf4(:,36),G1H4(120),m3h4x4(:,56),heltab2x16(:,:,270))
  call Hloop_VS_V(ntryL,G0H16(44),wf4(:,36),G0H4(7),m3h4x4(:,57),heltab2x16(:,:,271))
  call Hloop_VS_V(ntryL,G0H16(45),wf4(:,36),G0H4(8),m3h4x4(:,58),heltab2x16(:,:,272))
  call Hloop_VT_S(ntryL,G1H16(55),16,wf4(:,36),3,G2H4(96),m3h4x4(:,59),heltab2x16(:,:,273))
  call Hloop_VT_S(ntryL,G1H16(56),16,wf4(:,36),3,G2H4(97),m3h4x4(:,60),heltab2x16(:,:,274))
  call Hloop_VT_S(ntryL,G1H16(57),16,wf4(:,37),3,G2H4(100),m3h4x4(:,61),heltab2x16(:,:,275))
  call Hloop_VT_S(ntryL,G1H16(58),16,wf4(:,37),3,G2H4(101),m3h4x4(:,62),heltab2x16(:,:,276))
  call Hloop_ST_V(ntryL,G0H16(46),16,wf4(:,36),3,G1H4(123),m3h4x4(:,63),heltab2x16(:,:,277))
  call Hloop_ST_V(ntryL,G0H16(47),16,wf4(:,36),3,G1H4(124),m3h4x4(:,64),heltab2x16(:,:,278))
  call Hloop_ST_V(ntryL,G0H16(48),16,wf4(:,37),3,G1H4(125),m3h4x4(:,65),heltab2x16(:,:,279))
  call Hloop_ST_V(ntryL,G0H16(49),16,wf4(:,37),3,G1H4(126),m3h4x4(:,66),heltab2x16(:,:,280))
  call Hloop_QV_A(ntryL,G1H16(59),wf4(:,13),G1H4(129),m3h4x4(:,67),heltab2x16(:,:,281))
  call Hloop_Q_A(ntryL,G1H4(129),19,nME,G2H4(104),n2h4(273))
  call Hloop_QV_A(ntryL,G1H16(60),wf4(:,13),G1H4(130),m3h4x4(:,68),heltab2x16(:,:,282))
  call Hloop_Q_A(ntryL,G1H4(130),19,nMM,G2H4(105),n2h4(274))
  call Hloop_QV_A(ntryL,G1H16(61),wf4(:,13),G1H4(131),m3h4x4(:,69),heltab2x16(:,:,283))
  call Hloop_Q_A(ntryL,G1H4(131),19,nML,G2H4(109),n2h4(275))
  call Hloop_AV_Q(ntryL,G1H16(62),wf4(:,13),G1H4(132),m3h4x4(:,70),heltab2x16(:,:,284))
  call Hloop_A_Q(ntryL,G1H4(132),19,nME,G2H4(110),n2h4(276))
  call Hloop_AV_Q(ntryL,G1H16(63),wf4(:,13),G1H4(135),m3h4x4(:,71),heltab2x16(:,:,285))
  call Hloop_A_Q(ntryL,G1H4(135),19,nMM,G2H4(114),n2h4(277))
  call Hloop_AV_Q(ntryL,G1H16(64),wf4(:,13),G1H4(136),m3h4x4(:,72),heltab2x16(:,:,286))
  call Hloop_A_Q(ntryL,G1H4(136),19,nML,G2H4(115),n2h4(278))
  call Hloop_QV_A(ntryL,G1H16(69),wf4(:,13),G1H4(137),m3h4x4(:,73),heltab2x16(:,:,287))
  call Hloop_Q_A(ntryL,G1H4(137),19,0,G2H4(118),n2h4(279))
  call Hloop_QV_A(ntryL,G1H16(66),wf4(:,13),G1H4(138),m3h4x4(:,74),heltab2x16(:,:,288))
  call Hloop_Q_A(ntryL,G1H4(138),19,nMT,G2H4(119),n2h4(280))
  call Hloop_AV_Q(ntryL,G1H16(71),wf4(:,13),G1H4(141),m3h4x4(:,75),heltab2x16(:,:,289))
  call Hloop_A_Q(ntryL,G1H4(141),19,0,G2H4(122),n2h4(281))
  call Hloop_AV_Q(ntryL,G1H16(68),wf4(:,13),G1H4(142),m3h4x4(:,76),heltab2x16(:,:,290))
  call Hloop_A_Q(ntryL,G1H4(142),19,nMT,G2H4(123),n2h4(282))
  call Hloop_QV_A(ntryL,G1H16(70),wf4(:,13),G1H4(143),m3h4x4(:,77),heltab2x16(:,:,291))
  call Hloop_Q_A(ntryL,G1H4(143),19,nMB,G2H4(127),n2h4(283))
  call Hloop_AV_Q(ntryL,G1H16(72),wf4(:,13),G1H4(144),m3h4x4(:,78),heltab2x16(:,:,292))
  call Hloop_A_Q(ntryL,G1H4(144),19,nMB,G2H4(128),n2h4(284))
  call Hloop_QZ_A(ntryL,G1H16(73),wf4(:,14),G1H4(147),ngZl,m3h4x4(:,79),heltab2x16(:,:,293))
  call Hloop_Q_A(ntryL,G1H4(147),19,nME,G2H4(129),n2h4(285))
  call Hloop_QZ_A(ntryL,G1H16(74),wf4(:,14),G1H4(148),ngZl,m3h4x4(:,80),heltab2x16(:,:,294))
  call Hloop_Q_A(ntryL,G1H4(148),19,nMM,G2H4(132),n2h4(286))
  call Hloop_QZ_A(ntryL,G1H16(75),wf4(:,14),G1H4(149),ngZl,m3h4x4(:,81),heltab2x16(:,:,295))
  call Hloop_Q_A(ntryL,G1H4(149),19,nML,G2H4(133),n2h4(287))
  call Hloop_AZ_Q(ntryL,G1H16(76),wf4(:,14),G1H4(150),ngZl,m3h4x4(:,82),heltab2x16(:,:,296))
  call Hloop_A_Q(ntryL,G1H4(150),19,nME,G2H4(134),n2h4(288))
  call Hloop_AZ_Q(ntryL,G1H16(77),wf4(:,14),G1H4(153),ngZl,m3h4x4(:,83),heltab2x16(:,:,297))
  call Hloop_A_Q(ntryL,G1H4(153),19,nMM,G2H4(136),n2h4(289))
  call Hloop_AZ_Q(ntryL,G1H16(78),wf4(:,14),G1H4(154),ngZl,m3h4x4(:,84),heltab2x16(:,:,298))
  call Hloop_A_Q(ntryL,G1H4(154),19,nML,G2H4(137),n2h4(290))
  call Hloop_QZ_A(ntryL,G1H16(79),wf4(:,14),G1H4(155),ngZu,m3h4x4(:,85),heltab2x16(:,:,299))
  call Hloop_Q_A(ntryL,G1H4(155),19,0,G2H4(138),n2h4(291))
  call Hloop_QZ_A(ntryL,G1H16(80),wf4(:,14),G1H4(156),ngZu,m3h4x4(:,86),heltab2x16(:,:,300))
  call Hloop_Q_A(ntryL,G1H4(156),19,nMT,G2H4(140),n2h4(292))
  call Hloop_AZ_Q(ntryL,G1H16(81),wf4(:,14),G1H4(159),ngZu,m3h4x4(:,87),heltab2x16(:,:,301))
  call Hloop_A_Q(ntryL,G1H4(159),19,0,G2H4(141),n2h4(293))
  call Hloop_AZ_Q(ntryL,G1H16(82),wf4(:,14),G1H4(160),ngZu,m3h4x4(:,88),heltab2x16(:,:,302))
  call Hloop_A_Q(ntryL,G1H4(160),19,nMT,G2H4(142),n2h4(294))
  call Hloop_QZ_A(ntryL,G1H16(83),wf4(:,14),G1H4(161),ngZd,m3h4x4(:,89),heltab2x16(:,:,303))
  call Hloop_Q_A(ntryL,G1H4(161),19,0,G2H4(145),n2h4(295))
  call Hloop_QZ_A(ntryL,G1H16(84),wf4(:,14),G1H4(162),ngZd,m3h4x4(:,90),heltab2x16(:,:,304))
  call Hloop_Q_A(ntryL,G1H4(162),19,nMB,G2H4(146),n2h4(296))
  call Hloop_AZ_Q(ntryL,G1H16(85),wf4(:,14),G1H4(165),ngZd,m3h4x4(:,91),heltab2x16(:,:,305))
  call Hloop_A_Q(ntryL,G1H4(165),19,0,G2H4(147),n2h4(297))
  call Hloop_AZ_Q(ntryL,G1H16(86),wf4(:,14),G1H4(166),ngZd,m3h4x4(:,92),heltab2x16(:,:,306))
  call Hloop_A_Q(ntryL,G1H4(166),19,nMB,G2H4(150),n2h4(298))
  call Hloop_TV_S(ntryL,G1H16(87),16,wf4(:,13),3,G2H4(151),m3h4x4(:,93),heltab2x16(:,:,307))
  call Hloop_SV_T(ntryL,G1H16(88),16,wf4(:,13),3,G2H4(152),m3h4x4(:,94),heltab2x16(:,:,308))
  call Hloop_TV_S(ntryL,G1H16(89),16,wf4(:,14),3,G2H4(154),m3h4x4(:,95),heltab2x16(:,:,309))
  call Hloop_SV_T(ntryL,G1H16(90),16,wf4(:,14),3,G2H4(155),m3h4x4(:,96),heltab2x16(:,:,310))
  call Hloop_CV_D(ntryL,G1H16(93),16,wf4(:,13),3,G2H4(156),m3h4x4(:,97),heltab2x16(:,:,311))
  call Hloop_DV_C(ntryL,G1H16(94),16,wf4(:,13),G2H4(158),m3h4x4(:,98),heltab2x16(:,:,312))
  call Hloop_CV_D(ntryL,G1H16(97),16,wf4(:,14),3,G2H4(159),m3h4x4(:,99),heltab2x16(:,:,313))
  call Hloop_DV_C(ntryL,G1H16(98),16,wf4(:,14),G2H4(160),m3h4x4(:,100),heltab2x16(:,:,314))
  call Hloop_UV_W(ntryL,G1H16(99),16,wf4(:,13),3,G2H4(163),m3h4x4(:,101),heltab2x16(:,:,315))
  call Hloop_UW_V(ntryL,G1H16(100),16,wf4(:,13),3,G2H4(164),m3h4x4(:,102),heltab2x16(:,:,316))
  call Hloop_UV_W(ntryL,G1H16(101),16,wf4(:,14),3,G2H4(165),m3h4x4(:,103),heltab2x16(:,:,317))
  call Hloop_UW_V(ntryL,G1H16(102),16,wf4(:,14),3,G2H4(168),m3h4x4(:,104),heltab2x16(:,:,318))
  call Hloop_VV_S(ntryL,G0H16(13),wf4(:,13),G0H4(9),m3h4x4(:,105),heltab2x16(:,:,319))
  call Hloop_VV_S(ntryL,G0H16(14),wf4(:,13),G0H4(10),m3h4x4(:,106),heltab2x16(:,:,320))
  call Hloop_VV_S(ntryL,G0H16(15),wf4(:,14),G0H4(11),m3h4x4(:,107),heltab2x16(:,:,321))
  call Hloop_VV_S(ntryL,G0H16(16),wf4(:,14),G0H4(12),m3h4x4(:,108),heltab2x16(:,:,322))
  call Hloop_SV_V(ntryL,G1H16(103),wf4(:,13),G1H4(167),m3h4x4(:,109),heltab2x16(:,:,323))
  call Hloop_SV_V(ntryL,G1H16(104),wf4(:,13),G1H4(168),m3h4x4(:,110),heltab2x16(:,:,324))
  call Hloop_SV_V(ntryL,G1H16(105),wf4(:,14),G1H4(171),m3h4x4(:,111),heltab2x16(:,:,325))
  call Hloop_SV_V(ntryL,G1H16(106),wf4(:,14),G1H4(172),m3h4x4(:,112),heltab2x16(:,:,326))
  call Hloop_TV_S(ntryL,G0H16(17),16,wf4(:,13),3,G1H4(173),m3h4x4(:,113),heltab2x16(:,:,327))
  call Hloop_SV_T(ntryL,G0H16(18),16,wf4(:,13),3,G1H4(174),m3h4x4(:,114),heltab2x16(:,:,328))
  call Hloop_TV_S(ntryL,G0H16(19),16,wf4(:,14),3,G1H4(177),m3h4x4(:,115),heltab2x16(:,:,329))
  call Hloop_SV_T(ntryL,G0H16(20),16,wf4(:,14),3,G1H4(178),m3h4x4(:,116),heltab2x16(:,:,330))
  call Hloop_TV_S(ntryL,G1H16(107),16,wf4(:,13),3,G2H4(169),m3h4x4(:,117),heltab2x16(:,:,331))
  call Hloop_SV_T(ntryL,G1H16(108),16,wf4(:,13),3,G2H4(170),m3h4x4(:,118),heltab2x16(:,:,332))
  call Hloop_TV_S(ntryL,G1H16(109),16,wf4(:,14),3,G2H4(172),m3h4x4(:,119),heltab2x16(:,:,333))
  call Hloop_SV_T(ntryL,G1H16(110),16,wf4(:,14),3,G2H4(173),m3h4x4(:,120),heltab2x16(:,:,334))
  call Hloop_UV_W(ntryL,G0H16(21),16,wf4(:,13),3,G1H4(179),m3h4x4(:,121),heltab2x16(:,:,335))
  call Hloop_UW_V(ntryL,G0H16(22),16,wf4(:,13),3,G1H4(180),m3h4x4(:,122),heltab2x16(:,:,336))
  call Hloop_UV_W(ntryL,G0H16(23),16,wf4(:,14),3,G1H4(183),m3h4x4(:,123),heltab2x16(:,:,337))
  call Hloop_UW_V(ntryL,G0H16(24),16,wf4(:,14),3,G1H4(184),m3h4x4(:,124),heltab2x16(:,:,338))
  call Hloop_VV_S(ntryL,G1H16(111),wf4(:,13),G1H4(185),m3h4x4(:,125),heltab2x16(:,:,339))
  call Hloop_VV_S(ntryL,G1H16(112),wf4(:,13),G1H4(186),m3h4x4(:,126),heltab2x16(:,:,340))
  call Hloop_VV_S(ntryL,G1H16(113),wf4(:,14),G1H4(189),m3h4x4(:,127),heltab2x16(:,:,341))
  call Hloop_VV_S(ntryL,G1H16(114),wf4(:,14),G1H4(190),m3h4x4(:,128),heltab2x16(:,:,342))
  call Hloop_SV_V(ntryL,G0H16(50),wf4(:,13),G0H4(13),m3h4x4(:,129),heltab2x16(:,:,343))
  call Hloop_SV_V(ntryL,G0H16(52),wf4(:,14),G0H4(14),m3h4x4(:,130),heltab2x16(:,:,344))
  call Hloop_VV_S(ntryL,G0H16(54),wf4(:,13),G0H4(15),m3h4x4(:,131),heltab2x16(:,:,345))
  call Hloop_VV_S(ntryL,G0H16(56),wf4(:,14),G0H4(16),m3h4x4(:,132),heltab2x16(:,:,346))
  call Hloop_SV_V(ntryL,G1H16(115),wf4(:,13),G1H4(191),m3h4x4(:,133),heltab2x16(:,:,347))
  call Hloop_SV_V(ntryL,G1H16(116),wf4(:,13),G1H4(192),m3h4x4(:,134),heltab2x16(:,:,348))
  call Hloop_SV_V(ntryL,G1H16(117),wf4(:,14),G1H4(195),m3h4x4(:,135),heltab2x16(:,:,349))
  call Hloop_SV_V(ntryL,G1H16(118),wf4(:,14),G1H4(196),m3h4x4(:,136),heltab2x16(:,:,350))
  call Hloop_TV_S(ntryL,G0H16(57),16,wf4(:,13),3,G1H4(197),m3h4x4(:,137),heltab2x16(:,:,351))
  call Hloop_SV_T(ntryL,G0H16(58),16,wf4(:,13),3,G1H4(198),m3h4x4(:,138),heltab2x16(:,:,352))
  call Hloop_TV_S(ntryL,G0H16(59),16,wf4(:,14),3,G1H4(201),m3h4x4(:,139),heltab2x16(:,:,353))
  call Hloop_SV_T(ntryL,G0H16(60),16,wf4(:,14),3,G1H4(202),m3h4x4(:,140),heltab2x16(:,:,354))
  call Hloop_UV_W(ntryL,G1H16(119),16,wf4(:,13),3,G2H4(174),m3h4x4(:,141),heltab2x16(:,:,355))
  call Hloop_UW_V(ntryL,G1H16(120),16,wf4(:,13),3,G2H4(176),m3h4x4(:,142),heltab2x16(:,:,356))
  call Hloop_UV_W(ntryL,G1H16(121),16,wf4(:,14),3,G2H4(177),m3h4x4(:,143),heltab2x16(:,:,357))
  call Hloop_UW_V(ntryL,G1H16(122),16,wf4(:,14),3,G2H4(178),m3h4x4(:,144),heltab2x16(:,:,358))
  call Hloop_UV_W(ntryL,G0H16(61),16,wf4(:,13),3,G1H4(203),m3h4x4(:,145),heltab2x16(:,:,359))
  call Hloop_UW_V(ntryL,G0H16(62),16,wf4(:,13),3,G1H4(204),m3h4x4(:,146),heltab2x16(:,:,360))
  call Hloop_UV_W(ntryL,G0H16(63),16,wf4(:,14),3,G1H4(207),m3h4x4(:,147),heltab2x16(:,:,361))
  call Hloop_UW_V(ntryL,G0H16(64),16,wf4(:,14),3,G1H4(208),m3h4x4(:,148),heltab2x16(:,:,362))
  call Hloop_VV_S(ntryL,G1H16(123),wf4(:,13),G1H4(209),m3h4x4(:,149),heltab2x16(:,:,363))
  call Hloop_VV_S(ntryL,G1H16(124),wf4(:,13),G1H4(210),m3h4x4(:,150),heltab2x16(:,:,364))
  call Hloop_VV_S(ntryL,G1H16(125),wf4(:,14),G1H4(213),m3h4x4(:,151),heltab2x16(:,:,365))
  call Hloop_VV_S(ntryL,G1H16(126),wf4(:,14),G1H4(214),m3h4x4(:,152),heltab2x16(:,:,366))
  call Hloop_SV_V(ntryL,G0H16(65),wf4(:,13),G0H4(17),m3h4x4(:,153),heltab2x16(:,:,367))
  call Hloop_SV_V(ntryL,G0H16(66),wf4(:,13),G0H4(18),m3h4x4(:,154),heltab2x16(:,:,368))
  call Hloop_SV_V(ntryL,G0H16(67),wf4(:,14),G0H4(19),m3h4x4(:,155),heltab2x16(:,:,369))
  call Hloop_SV_V(ntryL,G0H16(68),wf4(:,14),G0H4(20),m3h4x4(:,156),heltab2x16(:,:,370))
  call Hloop_AS_Q(ntryL,G1H16(127),wf4(:,36),G1H4(215),ngH,m3h4x4(:,157),heltab2x16(:,:,371))
  call Hloop_A_Q(ntryL,G1H4(215),19,nME,G2H4(181),n2h4(299))
  call Hloop_AS_Q(ntryL,G1H16(128),wf4(:,36),G1H4(216),ngH,m3h4x4(:,158),heltab2x16(:,:,372))
  call Hloop_A_Q(ntryL,G1H4(216),19,nMM,G2H4(182),n2h4(300))
  call Hloop_AS_Q(ntryL,G1H16(129),wf4(:,36),G1H4(219),ngH,m3h4x4(:,159),heltab2x16(:,:,373))
  call Hloop_A_Q(ntryL,G1H4(219),19,nML,G2H4(183),n2h4(301))
  call Hloop_QS_A(ntryL,G1H16(130),wf4(:,36),G1H4(220),ngH,m3h4x4(:,160),heltab2x16(:,:,374))
  call Hloop_Q_A(ntryL,G1H4(220),19,nME,G2H4(185),n2h4(302))
  call Hloop_QS_A(ntryL,G1H16(131),wf4(:,36),G1H4(221),ngH,m3h4x4(:,161),heltab2x16(:,:,375))
  call Hloop_Q_A(ntryL,G1H4(221),19,nMM,G2H4(186),n2h4(303))
  call Hloop_QS_A(ntryL,G1H16(132),wf4(:,36),G1H4(222),ngH,m3h4x4(:,162),heltab2x16(:,:,376))
  call Hloop_Q_A(ntryL,G1H4(222),19,nML,G2H4(187),n2h4(304))
  call Hloop_AS_Q(ntryL,G1H16(133),wf4(:,36),G1H4(225),ngH,m3h4x4(:,163),heltab2x16(:,:,377))
  call Hloop_A_Q(ntryL,G1H4(225),19,nMT,G2H4(189),n2h4(305))
  call Hloop_QS_A(ntryL,G1H16(134),wf4(:,36),G1H4(226),ngH,m3h4x4(:,164),heltab2x16(:,:,378))
  call Hloop_Q_A(ntryL,G1H4(226),19,nMT,G2H4(190),n2h4(306))
  call Hloop_AS_Q(ntryL,G1H16(135),wf4(:,36),G1H4(227),ngH,m3h4x4(:,165),heltab2x16(:,:,379))
  call Hloop_A_Q(ntryL,G1H4(227),19,nMB,G2H4(191),n2h4(307))
  call Hloop_QS_A(ntryL,G1H16(136),wf4(:,36),G1H4(228),ngH,m3h4x4(:,166),heltab2x16(:,:,380))
  call Hloop_Q_A(ntryL,G1H4(228),19,nMB,G2H4(194),n2h4(308))
  call Hloop_AS_Q(ntryL,G1H16(137),wf4(:,37),G1H4(231),ngX,m3h4x4(:,167),heltab2x16(:,:,381))
  call Hloop_A_Q(ntryL,G1H4(231),19,nME,G2H4(195),n2h4(309))
  call Hloop_AS_Q(ntryL,G1H16(138),wf4(:,37),G1H4(232),ngX,m3h4x4(:,168),heltab2x16(:,:,382))
  call Hloop_A_Q(ntryL,G1H4(232),19,nMM,G2H4(196),n2h4(310))
  call Hloop_AS_Q(ntryL,G1H16(139),wf4(:,37),G1H4(233),ngX,m3h4x4(:,169),heltab2x16(:,:,383))
  call Hloop_A_Q(ntryL,G1H4(233),19,nML,G2H4(198),n2h4(311))
  call Hloop_QS_A(ntryL,G1H16(140),wf4(:,37),G1H4(234),ngX,m3h4x4(:,170),heltab2x16(:,:,384))
  call Hloop_Q_A(ntryL,G1H4(234),19,nME,G2H4(199),n2h4(312))
  call Hloop_QS_A(ntryL,G1H16(141),wf4(:,37),G1H4(237),ngX,m3h4x4(:,171),heltab2x16(:,:,385))
  call Hloop_Q_A(ntryL,G1H4(237),19,nMM,G2H4(200),n2h4(313))
  call Hloop_QS_A(ntryL,G1H16(142),wf4(:,37),G1H4(238),ngX,m3h4x4(:,172),heltab2x16(:,:,386))
  call Hloop_Q_A(ntryL,G1H4(238),19,nML,G2H4(202),n2h4(314))
  call Hloop_AS_Q(ntryL,G1H16(143),wf4(:,37),G1H4(239),ngX,m3h4x4(:,173),heltab2x16(:,:,387))
  call Hloop_A_Q(ntryL,G1H4(239),19,nMT,G2H4(203),n2h4(315))
  call Hloop_QS_A(ntryL,G1H16(144),wf4(:,37),G1H4(240),ngX,m3h4x4(:,174),heltab2x16(:,:,388))
  call Hloop_Q_A(ntryL,G1H4(240),19,nMT,G2H4(204),n2h4(316))
  call Hloop_AS_Q(ntryL,G1H16(145),wf4(:,37),G1H4(243),ngX,m3h4x4(:,175),heltab2x16(:,:,389))
  call Hloop_A_Q(ntryL,G1H4(243),19,nMB,G2H4(207),n2h4(317))
  call Hloop_QS_A(ntryL,G1H16(146),wf4(:,37),G1H4(244),ngX,m3h4x4(:,176),heltab2x16(:,:,390))
  call Hloop_Q_A(ntryL,G1H4(244),19,nMB,G2H4(208),n2h4(318))
  call Hloop_SS_S(ntryL,G1H16(147),wf4(:,36),G1H4(245),m3h4x4(:,177),heltab2x16(:,:,391))
  call Hloop_SS_S(ntryL,G1H16(148),wf4(:,36),G1H4(246),m3h4x4(:,178),heltab2x16(:,:,392))
  call Hloop_SS_S(ntryL,G1H16(151),wf4(:,36),G1H4(249),m3h4x4(:,179),heltab2x16(:,:,393))
  call Hloop_SS_S(ntryL,G1H16(152),wf4(:,36),G1H4(250),m3h4x4(:,180),heltab2x16(:,:,394))
  call Hloop_SS_S(ntryL,G1H16(155),wf4(:,37),G1H4(251),m3h4x4(:,181),heltab2x16(:,:,395))
  call Hloop_SS_S(ntryL,G1H16(156),wf4(:,37),G1H4(252),m3h4x4(:,182),heltab2x16(:,:,396))
  call Hloop_VS_V(ntryL,G1H16(157),wf4(:,36),G1H4(255),m3h4x4(:,183),heltab2x16(:,:,397))
  call Hloop_VS_V(ntryL,G1H16(158),wf4(:,36),G1H4(256),m3h4x4(:,184),heltab2x16(:,:,398))
  call Hloop_VT_S(ntryL,G0H16(6),16,wf4(:,36),3,G1H4(257),m3h4x4(:,185),heltab2x16(:,:,399))
  call Hloop_VT_S(ntryL,G0H16(7),16,wf4(:,36),3,G1H4(258),m3h4x4(:,186),heltab2x16(:,:,400))
  call Hloop_VT_S(ntryL,G0H16(8),16,wf4(:,37),3,G1H4(261),m3h4x4(:,187),heltab2x16(:,:,401))
  call Hloop_VT_S(ntryL,G0H16(9),16,wf4(:,37),3,G1H4(262),m3h4x4(:,188),heltab2x16(:,:,402))
  call Hloop_SS_S(ntryL,G0H16(10),wf4(:,36),G0H4(21),m3h4x4(:,189),heltab2x16(:,:,403))
  call Hloop_SS_S(ntryL,G0H16(11),wf4(:,36),G0H4(22),m3h4x4(:,190),heltab2x16(:,:,404))
  call Hloop_ST_V(ntryL,G1H16(159),16,wf4(:,36),3,G2H4(209),m3h4x4(:,191),heltab2x16(:,:,405))
  call Hloop_ST_V(ntryL,G1H16(160),16,wf4(:,36),3,G2H4(211),m3h4x4(:,192),heltab2x16(:,:,406))
  call Hloop_ST_V(ntryL,G1H16(161),16,wf4(:,37),3,G2H4(212),m3h4x4(:,193),heltab2x16(:,:,407))
  call Hloop_ST_V(ntryL,G1H16(162),16,wf4(:,37),3,G2H4(213),m3h4x4(:,194),heltab2x16(:,:,408))
  call Hloop_SS_S(ntryL,G1H16(164),wf4(:,36),G1H4(263),m3h4x4(:,195),heltab2x16(:,:,409))
  call Hloop_VT_S(ntryL,G1H16(165),16,wf4(:,36),3,G2H4(215),m3h4x4(:,196),heltab2x16(:,:,410))
  call Hloop_VT_S(ntryL,G1H16(166),16,wf4(:,36),3,G2H4(216),m3h4x4(:,197),heltab2x16(:,:,411))
  call Hloop_VT_S(ntryL,G1H16(167),16,wf4(:,37),3,G2H4(7),m3h4x4(:,198),heltab2x16(:,:,412))
  call Hloop_VT_S(ntryL,G1H16(168),16,wf4(:,37),3,G2H4(8),m3h4x4(:,199),heltab2x16(:,:,413))
  call Hloop_VS_V(ntryL,G0H16(12),wf4(:,36),G0H4(23),m3h4x4(:,200),heltab2x16(:,:,414))
  call Hloop_VS_V(ntryL,G0H16(4),wf4(:,36),G0H4(24),m3h4x4(:,201),heltab2x16(:,:,415))
  call Hloop_ST_V(ntryL,G0H16(70),16,wf4(:,36),3,G1H4(264),m3h4x4(:,202),heltab2x16(:,:,416))
  call Hloop_ST_V(ntryL,G0H16(72),16,wf4(:,37),3,G1H4(267),m3h4x4(:,203),heltab2x16(:,:,417))
  call Hloop_VT_S(ntryL,G0H16(74),16,wf4(:,36),3,G1H4(268),m3h4x4(:,204),heltab2x16(:,:,418))
  call Hloop_VT_S(ntryL,G0H16(76),16,wf4(:,37),3,G1H4(269),m3h4x4(:,205),heltab2x16(:,:,419))
  call Hloop_SS_S(ntryL,G0H16(77),wf4(:,36),G0H4(25),m3h4x4(:,206),heltab2x16(:,:,420))
  call Hloop_SS_S(ntryL,G0H16(78),wf4(:,36),G0H4(26),m3h4x4(:,207),heltab2x16(:,:,421))
  call Hloop_ST_V(ntryL,G1H16(169),16,wf4(:,36),3,G2H4(9),m3h4x4(:,208),heltab2x16(:,:,422))
  call Hloop_ST_V(ntryL,G1H16(170),16,wf4(:,36),3,G2H4(10),m3h4x4(:,209),heltab2x16(:,:,423))
  call Hloop_ST_V(ntryL,G1H16(171),16,wf4(:,37),3,G2H4(12),m3h4x4(:,210),heltab2x16(:,:,424))
  call Hloop_ST_V(ntryL,G1H16(172),16,wf4(:,37),3,G2H4(13),m3h4x4(:,211),heltab2x16(:,:,425))
  call Hloop_VS_V(ntryL,G1H16(174),wf4(:,36),G1H4(270),m3h4x4(:,212),heltab2x16(:,:,426))
  call Hloop_VT_S(ntryL,G1H16(175),16,wf4(:,36),3,G2H4(31),m3h4x4(:,213),heltab2x16(:,:,427))
  call Hloop_VT_S(ntryL,G1H16(176),16,wf4(:,36),3,G2H4(32),m3h4x4(:,214),heltab2x16(:,:,428))
  call Hloop_VT_S(ntryL,G1H16(177),16,wf4(:,37),3,G2H4(33),m3h4x4(:,215),heltab2x16(:,:,429))
  call Hloop_VT_S(ntryL,G1H16(178),16,wf4(:,37),3,G2H4(34),m3h4x4(:,216),heltab2x16(:,:,430))
  call Hloop_VS_V(ntryL,G0H16(79),wf4(:,36),G0H4(27),m3h4x4(:,217),heltab2x16(:,:,431))
  call Hloop_VS_V(ntryL,G0H16(80),wf4(:,36),G0H4(28),m3h4x4(:,218),heltab2x16(:,:,432))
  call Hloop_ST_V(ntryL,G0H16(81),16,wf4(:,36),3,G1H4(273),m3h4x4(:,219),heltab2x16(:,:,433))
  call Hloop_ST_V(ntryL,G0H16(82),16,wf4(:,36),3,G1H4(274),m3h4x4(:,220),heltab2x16(:,:,434))
  call Hloop_ST_V(ntryL,G0H16(83),16,wf4(:,37),3,G1H4(275),m3h4x4(:,221),heltab2x16(:,:,435))
  call Hloop_ST_V(ntryL,G0H16(84),16,wf4(:,37),3,G1H4(276),m3h4x4(:,222),heltab2x16(:,:,436))
  call Hloop_AV_Q(ntryL,G1H16(179),wf4(:,13),G1H4(279),m3h4x4(:,223),heltab2x16(:,:,437))
  call Hloop_A_Q(ntryL,G1H4(279),19,nME,G2H4(36),n2h4(319))
  call Hloop_AV_Q(ntryL,G1H16(180),wf4(:,13),G1H4(280),m3h4x4(:,224),heltab2x16(:,:,438))
  call Hloop_A_Q(ntryL,G1H4(280),19,nMM,G2H4(37),n2h4(320))
  call Hloop_AV_Q(ntryL,G1H16(181),wf4(:,13),G1H4(281),m3h4x4(:,225),heltab2x16(:,:,439))
  call Hloop_A_Q(ntryL,G1H4(281),19,nML,G2H4(50),n2h4(321))
  call Hloop_QV_A(ntryL,G1H16(182),wf4(:,13),G1H4(282),m3h4x4(:,226),heltab2x16(:,:,440))
  call Hloop_Q_A(ntryL,G1H4(282),19,nME,G2H4(51),n2h4(322))
  call Hloop_QV_A(ntryL,G1H16(183),wf4(:,13),G1H4(285),m3h4x4(:,227),heltab2x16(:,:,441))
  call Hloop_Q_A(ntryL,G1H4(285),19,nMM,G2H4(64),n2h4(323))
  call Hloop_QV_A(ntryL,G1H16(184),wf4(:,13),G1H4(286),m3h4x4(:,228),heltab2x16(:,:,442))
  call Hloop_Q_A(ntryL,G1H4(286),19,nML,G2H4(65),n2h4(324))
  call Hloop_AV_Q(ntryL,G1H16(189),wf4(:,13),G1H4(287),m3h4x4(:,229),heltab2x16(:,:,443))
  call Hloop_A_Q(ntryL,G1H4(287),19,0,G2H4(1),n2h4(325))
  call Hloop_AV_Q(ntryL,G1H16(186),wf4(:,13),G1H4(288),m3h4x4(:,230),heltab2x16(:,:,444))
  call Hloop_A_Q(ntryL,G1H4(288),19,nMT,G2H4(2),n2h4(326))
  call Hloop_QV_A(ntryL,G1H16(191),wf4(:,13),G1H4(291),m3h4x4(:,231),heltab2x16(:,:,445))
  call Hloop_Q_A(ntryL,G1H4(291),19,0,G2H4(3),n2h4(327))
  call Hloop_QV_A(ntryL,G1H16(188),wf4(:,13),G1H4(292),m3h4x4(:,232),heltab2x16(:,:,446))
  call Hloop_Q_A(ntryL,G1H4(292),19,nMT,G2H4(4),n2h4(328))
  call Hloop_AV_Q(ntryL,G1H16(190),wf4(:,13),G1H4(293),m3h4x4(:,233),heltab2x16(:,:,447))
  call Hloop_A_Q(ntryL,G1H4(293),19,nMB,G2H4(5),n2h4(329))
  call Hloop_QV_A(ntryL,G1H16(192),wf4(:,13),G1H4(294),m3h4x4(:,234),heltab2x16(:,:,448))
  call Hloop_Q_A(ntryL,G1H4(294),19,nMB,G2H4(6),n2h4(330))
  call Hloop_AZ_Q(ntryL,G1H16(193),wf4(:,14),G1H4(297),ngZl,m3h4x4(:,235),heltab2x16(:,:,449))
  call Hloop_A_Q(ntryL,G1H4(297),19,nME,G2H4(102),n2h4(331))
  call Hloop_AZ_Q(ntryL,G1H16(194),wf4(:,14),G1H4(298),ngZl,m3h4x4(:,236),heltab2x16(:,:,450))
  call Hloop_A_Q(ntryL,G1H4(298),19,nMM,G2H4(93),n2h4(332))
  call Hloop_AZ_Q(ntryL,G1H16(195),wf4(:,14),G1H4(299),ngZl,m3h4x4(:,237),heltab2x16(:,:,451))
  call Hloop_A_Q(ntryL,G1H4(299),19,nML,G2H4(106),n2h4(333))
  call Hloop_QZ_A(ntryL,G1H16(196),wf4(:,14),G1H4(300),ngZl,m3h4x4(:,238),heltab2x16(:,:,452))
  call Hloop_Q_A(ntryL,G1H4(300),19,nME,G2H4(98),n2h4(334))
  call Hloop_QZ_A(ntryL,G1H16(197),wf4(:,14),G1H4(303),ngZl,m3h4x4(:,239),heltab2x16(:,:,453))
  call Hloop_Q_A(ntryL,G1H4(303),19,nMM,G2H4(11),n2h4(335))
  call Hloop_QZ_A(ntryL,G1H16(198),wf4(:,14),G1H4(304),ngZl,m3h4x4(:,240),heltab2x16(:,:,454))
  call Hloop_Q_A(ntryL,G1H4(304),19,nML,G2H4(16),n2h4(336))
  call Hloop_AZ_Q(ntryL,G1H16(199),wf4(:,14),G1H4(305),ngZu,m3h4x4(:,241),heltab2x16(:,:,455))
  call Hloop_A_Q(ntryL,G1H4(305),19,0,G2H4(17),n2h4(337))
  call Hloop_AZ_Q(ntryL,G1H16(200),wf4(:,14),G1H4(306),ngZu,m3h4x4(:,242),heltab2x16(:,:,456))
  call Hloop_A_Q(ntryL,G1H4(306),19,nMT,G2H4(14),n2h4(338))
  call Hloop_QZ_A(ntryL,G1H16(201),wf4(:,14),G1H4(309),ngZu,m3h4x4(:,243),heltab2x16(:,:,457))
  call Hloop_Q_A(ntryL,G1H4(309),19,0,G2H4(15),n2h4(339))
  call Hloop_QZ_A(ntryL,G1H16(202),wf4(:,14),G1H4(310),ngZu,m3h4x4(:,244),heltab2x16(:,:,458))
  call Hloop_Q_A(ntryL,G1H4(310),19,nMT,G2H4(18),n2h4(340))
  call Hloop_AZ_Q(ntryL,G1H16(203),wf4(:,14),G1H4(311),ngZd,m3h4x4(:,245),heltab2x16(:,:,459))
  call Hloop_A_Q(ntryL,G1H4(311),19,0,G2H4(19),n2h4(341))
  call Hloop_AZ_Q(ntryL,G1H16(204),wf4(:,14),G1H4(312),ngZd,m3h4x4(:,246),heltab2x16(:,:,460))
  call Hloop_A_Q(ntryL,G1H4(312),19,nMB,G2H4(20),n2h4(342))
  call Hloop_QZ_A(ntryL,G1H16(205),wf4(:,14),G1H4(315),ngZd,m3h4x4(:,247),heltab2x16(:,:,461))
  call Hloop_Q_A(ntryL,G1H4(315),19,0,G2H4(21),n2h4(343))
  call Hloop_QZ_A(ntryL,G1H16(206),wf4(:,14),G1H4(316),ngZd,m3h4x4(:,248),heltab2x16(:,:,462))
  call Hloop_Q_A(ntryL,G1H4(316),19,nMB,G2H4(22),n2h4(344))
  call Hloop_SV_T(ntryL,G1H16(207),16,wf4(:,13),3,G2H4(23),m3h4x4(:,249),heltab2x16(:,:,463))
  call Hloop_TV_S(ntryL,G1H16(208),16,wf4(:,13),3,G2H4(24),m3h4x4(:,250),heltab2x16(:,:,464))
  call Hloop_SV_T(ntryL,G1H16(209),16,wf4(:,14),3,G2H4(25),m3h4x4(:,251),heltab2x16(:,:,465))
  call Hloop_TV_S(ntryL,G1H16(210),16,wf4(:,14),3,G2H4(26),m3h4x4(:,252),heltab2x16(:,:,466))
  call Hloop_DV_C(ntryL,G1H16(213),16,wf4(:,13),G2H4(217),m3h4x4(:,253),heltab2x16(:,:,467))
  call Hloop_CV_D(ntryL,G1H16(214),16,wf4(:,13),3,G2H4(218),m3h4x4(:,254),heltab2x16(:,:,468))
  call Hloop_DV_C(ntryL,G1H16(217),16,wf4(:,14),G2H4(219),m3h4x4(:,255),heltab2x16(:,:,469))
  call Hloop_CV_D(ntryL,G1H16(218),16,wf4(:,14),3,G2H4(220),m3h4x4(:,256),heltab2x16(:,:,470))
  call Hloop_UW_V(ntryL,G1H16(219),16,wf4(:,13),3,G2H4(221),m3h4x4(:,257),heltab2x16(:,:,471))
  call Hloop_UV_W(ntryL,G1H16(220),16,wf4(:,13),3,G2H4(222),m3h4x4(:,258),heltab2x16(:,:,472))
  call Hloop_UW_V(ntryL,G1H16(221),16,wf4(:,14),3,G2H4(223),m3h4x4(:,259),heltab2x16(:,:,473))
  call Hloop_UV_W(ntryL,G1H16(222),16,wf4(:,14),3,G2H4(224),m3h4x4(:,260),heltab2x16(:,:,474))
  call Hloop_VV_S(ntryL,G0H16(85),wf4(:,13),G0H4(29),m3h4x4(:,261),heltab2x16(:,:,475))
  call Hloop_VV_S(ntryL,G0H16(86),wf4(:,13),G0H4(30),m3h4x4(:,262),heltab2x16(:,:,476))
  call Hloop_VV_S(ntryL,G0H16(87),wf4(:,14),G0H4(31),m3h4x4(:,263),heltab2x16(:,:,477))
  call Hloop_VV_S(ntryL,G0H16(88),wf4(:,14),G0H4(32),m3h4x4(:,264),heltab2x16(:,:,478))
  call Hloop_SV_T(ntryL,G0H16(89),16,wf4(:,13),3,G1H4(317),m3h4x4(:,265),heltab2x16(:,:,479))
  call Hloop_TV_S(ntryL,G0H16(90),16,wf4(:,13),3,G1H4(318),m3h4x4(:,266),heltab2x16(:,:,480))
  call Hloop_SV_T(ntryL,G0H16(91),16,wf4(:,14),3,G1H4(321),m3h4x4(:,267),heltab2x16(:,:,481))
  call Hloop_TV_S(ntryL,G0H16(92),16,wf4(:,14),3,G1H4(322),m3h4x4(:,268),heltab2x16(:,:,482))
  call Hloop_SV_V(ntryL,G1H16(223),wf4(:,13),G1H4(323),m3h4x4(:,269),heltab2x16(:,:,483))
  call Hloop_SV_V(ntryL,G1H16(224),wf4(:,13),G1H4(324),m3h4x4(:,270),heltab2x16(:,:,484))
  call Hloop_SV_V(ntryL,G1H16(225),wf4(:,14),G1H4(327),m3h4x4(:,271),heltab2x16(:,:,485))
  call Hloop_SV_V(ntryL,G1H16(226),wf4(:,14),G1H4(328),m3h4x4(:,272),heltab2x16(:,:,486))
  call Hloop_SV_T(ntryL,G1H16(227),16,wf4(:,13),3,G2H4(225),m3h4x4(:,273),heltab2x16(:,:,487))
  call Hloop_TV_S(ntryL,G1H16(228),16,wf4(:,13),3,G2H4(226),m3h4x4(:,274),heltab2x16(:,:,488))
  call Hloop_SV_T(ntryL,G1H16(229),16,wf4(:,14),3,G2H4(227),m3h4x4(:,275),heltab2x16(:,:,489))
  call Hloop_TV_S(ntryL,G1H16(230),16,wf4(:,14),3,G2H4(228),m3h4x4(:,276),heltab2x16(:,:,490))
  call Hloop_VV_S(ntryL,G1H16(231),wf4(:,13),G1H4(329),m3h4x4(:,277),heltab2x16(:,:,491))
  call Hloop_VV_S(ntryL,G1H16(232),wf4(:,13),G1H4(330),m3h4x4(:,278),heltab2x16(:,:,492))
  call Hloop_VV_S(ntryL,G1H16(233),wf4(:,14),G1H4(333),m3h4x4(:,279),heltab2x16(:,:,493))
  call Hloop_VV_S(ntryL,G1H16(234),wf4(:,14),G1H4(334),m3h4x4(:,280),heltab2x16(:,:,494))
  call Hloop_UW_V(ntryL,G0H16(93),16,wf4(:,13),3,G1H4(335),m3h4x4(:,281),heltab2x16(:,:,495))
  call Hloop_UV_W(ntryL,G0H16(94),16,wf4(:,13),3,G1H4(336),m3h4x4(:,282),heltab2x16(:,:,496))
  call Hloop_UW_V(ntryL,G0H16(95),16,wf4(:,14),3,G1H4(339),m3h4x4(:,283),heltab2x16(:,:,497))
  call Hloop_UV_W(ntryL,G0H16(96),16,wf4(:,14),3,G1H4(340),m3h4x4(:,284),heltab2x16(:,:,498))
  call Hloop_SV_V(ntryL,G0H16(98),wf4(:,13),G0H4(33),m3h4x4(:,285),heltab2x16(:,:,499))
  call Hloop_SV_V(ntryL,G0H16(100),wf4(:,14),G0H4(34),m3h4x4(:,286),heltab2x16(:,:,500))
  call Hloop_VV_S(ntryL,G0H16(102),wf4(:,13),G0H4(35),m3h4x4(:,287),heltab2x16(:,:,501))
  call Hloop_VV_S(ntryL,G0H16(104),wf4(:,14),G0H4(36),m3h4x4(:,288),heltab2x16(:,:,502))
  call Hloop_SV_T(ntryL,G0H16(105),16,wf4(:,13),3,G1H4(341),m3h4x4(:,289),heltab2x16(:,:,503))
  call Hloop_TV_S(ntryL,G0H16(106),16,wf4(:,13),3,G1H4(342),m3h4x4(:,290),heltab2x16(:,:,504))
  call Hloop_SV_T(ntryL,G0H16(107),16,wf4(:,14),3,G1H4(345),m3h4x4(:,291),heltab2x16(:,:,505))
  call Hloop_TV_S(ntryL,G0H16(108),16,wf4(:,14),3,G1H4(346),m3h4x4(:,292),heltab2x16(:,:,506))
  call Hloop_SV_V(ntryL,G1H16(235),wf4(:,13),G1H4(347),m3h4x4(:,293),heltab2x16(:,:,507))
  call Hloop_SV_V(ntryL,G1H16(236),wf4(:,13),G1H4(348),m3h4x4(:,294),heltab2x16(:,:,508))
  call Hloop_SV_V(ntryL,G1H16(237),wf4(:,14),G1H4(351),m3h4x4(:,295),heltab2x16(:,:,509))
  call Hloop_SV_V(ntryL,G1H16(238),wf4(:,14),G1H4(352),m3h4x4(:,296),heltab2x16(:,:,510))
  call Hloop_UW_V(ntryL,G1H16(239),16,wf4(:,13),3,G2H4(229),m3h4x4(:,297),heltab2x16(:,:,511))
  call Hloop_UV_W(ntryL,G1H16(240),16,wf4(:,13),3,G2H4(230),m3h4x4(:,298),heltab2x16(:,:,512))
  call Hloop_UW_V(ntryL,G1H16(241),16,wf4(:,14),3,G2H4(231),m3h4x4(:,299),heltab2x16(:,:,513))
  call Hloop_UV_W(ntryL,G1H16(242),16,wf4(:,14),3,G2H4(232),m3h4x4(:,300),heltab2x16(:,:,514))
  call Hloop_VV_S(ntryL,G1H16(243),wf4(:,13),G1H4(353),m3h4x4(:,301),heltab2x16(:,:,515))
  call Hloop_VV_S(ntryL,G1H16(244),wf4(:,13),G1H4(354),m3h4x4(:,302),heltab2x16(:,:,516))
  call Hloop_VV_S(ntryL,G1H16(245),wf4(:,14),G1H4(359),m3h4x4(:,303),heltab2x16(:,:,517))
  call Hloop_VV_S(ntryL,G1H16(246),wf4(:,14),G1H4(364),m3h4x4(:,304),heltab2x16(:,:,518))
  call Hloop_UW_V(ntryL,G0H16(109),16,wf4(:,13),3,G1H4(360),m3h4x4(:,305),heltab2x16(:,:,519))
  call Hloop_UV_W(ntryL,G0H16(110),16,wf4(:,13),3,G1H4(363),m3h4x4(:,306),heltab2x16(:,:,520))
  call Hloop_UW_V(ntryL,G0H16(111),16,wf4(:,14),3,G1H4(365),m3h4x4(:,307),heltab2x16(:,:,521))
  call Hloop_UV_W(ntryL,G0H16(112),16,wf4(:,14),3,G1H4(368),m3h4x4(:,308),heltab2x16(:,:,522))
  call Hloop_SV_V(ntryL,G0H16(113),wf4(:,13),G0H4(37),m3h4x4(:,309),heltab2x16(:,:,523))
  call Hloop_SV_V(ntryL,G0H16(114),wf4(:,13),G0H4(38),m3h4x4(:,310),heltab2x16(:,:,524))
  call Hloop_SV_V(ntryL,G0H16(115),wf4(:,14),G0H4(39),m3h4x4(:,311),heltab2x16(:,:,525))
  call Hloop_SV_V(ntryL,G0H16(116),wf4(:,14),G0H4(40),m3h4x4(:,312),heltab2x16(:,:,526))
  call Hloop_QV_A(ntryL,G1H16(247),ex3(:),G1H8(99),m3h2x8(:,215),heltab2x16(:,:,527))
  call Hloop_Q_A(ntryL,G1H8(99),20,nME,G2H8(5),n2h8(193))
  call Hloop_QV_A(ntryL,G1H16(248),ex3(:),G1H8(98),m3h2x8(:,216),heltab2x16(:,:,528))
  call Hloop_Q_A(ntryL,G1H8(98),20,nMM,G2H8(6),n2h8(194))
  call Hloop_QV_A(ntryL,G1H16(249),ex3(:),G1H8(111),m3h2x8(:,217),heltab2x16(:,:,529))
  call Hloop_Q_A(ntryL,G1H8(111),20,nML,G2H8(7),n2h8(195))
  call Hloop_AV_Q(ntryL,G1H16(250),ex3(:),G1H8(110),m3h2x8(:,218),heltab2x16(:,:,530))
  call Hloop_A_Q(ntryL,G1H8(110),20,nME,G2H8(8),n2h8(196))
  call Hloop_AV_Q(ntryL,G1H16(251),ex3(:),G1H8(113),m3h2x8(:,219),heltab2x16(:,:,531))
  call Hloop_A_Q(ntryL,G1H8(113),20,nMM,G2H8(9),n2h8(197))
  call Hloop_AV_Q(ntryL,G1H16(252),ex3(:),G1H8(117),m3h2x8(:,220),heltab2x16(:,:,532))
  call Hloop_A_Q(ntryL,G1H8(117),20,nML,G2H8(10),n2h8(198))
  call Hloop_QV_A(ntryL,G1H16(253),ex3(:),G1H8(116),m3h2x8(:,221),heltab2x16(:,:,533))
  call Hloop_Q_A(ntryL,G1H8(116),20,nMT,G2H8(11),n2h8(199))
  call Hloop_AV_Q(ntryL,G1H16(254),ex3(:),G1H8(3),m3h2x8(:,222),heltab2x16(:,:,534))
  call Hloop_A_Q(ntryL,G1H8(3),20,nMT,G2H8(14),n2h8(200))
  call Hloop_QV_A(ntryL,G1H16(255),ex3(:),G1H8(5),m3h2x8(:,223),heltab2x16(:,:,535))
  call Hloop_Q_A(ntryL,G1H8(5),20,nMB,G2H8(12),n2h8(201))
  call Hloop_AV_Q(ntryL,G1H16(256),ex3(:),G1H8(8),m3h2x8(:,224),heltab2x16(:,:,536))
  call Hloop_A_Q(ntryL,G1H8(8),20,nMB,G2H8(13),n2h8(202))
  call Hloop_QV_A(ntryL,G1H16(257),ex3(:),G1H8(9),m3h2x8(:,225),heltab2x16(:,:,537))
  call Hloop_Q_A(ntryL,G1H8(9),20,nME,G2H8(16),n2h8(203))
  call Hloop_QV_A(ntryL,G1H16(258),ex3(:),G1H8(10),m3h2x8(:,226),heltab2x16(:,:,538))
  call Hloop_Q_A(ntryL,G1H8(10),20,nMM,G2H8(17),n2h8(204))
  call Hloop_QV_A(ntryL,G1H16(259),ex3(:),G1H8(11),m3h2x8(:,227),heltab2x16(:,:,539))
  call Hloop_Q_A(ntryL,G1H8(11),20,nML,G2H8(15),n2h8(205))
  call Hloop_AV_Q(ntryL,G1H16(260),ex3(:),G1H8(12),m3h2x8(:,228),heltab2x16(:,:,540))
  call Hloop_A_Q(ntryL,G1H8(12),20,nME,G2H8(18),n2h8(206))
  call Hloop_AV_Q(ntryL,G1H16(261),ex3(:),G1H8(14),m3h2x8(:,229),heltab2x16(:,:,541))
  call Hloop_A_Q(ntryL,G1H8(14),20,nMM,G2H8(19),n2h8(207))
  call Hloop_AV_Q(ntryL,G1H16(262),ex3(:),G1H8(25),m3h2x8(:,230),heltab2x16(:,:,542))
  call Hloop_A_Q(ntryL,G1H8(25),20,nML,G2H8(20),n2h8(208))
  call Hloop_QV_A(ntryL,G1H16(263),ex3(:),G1H8(26),m3h2x8(:,231),heltab2x16(:,:,543))
  call Hloop_Q_A(ntryL,G1H8(26),20,nMT,G2H8(21),n2h8(209))
  call Hloop_AV_Q(ntryL,G1H16(264),ex3(:),G1H8(29),m3h2x8(:,232),heltab2x16(:,:,544))
  call Hloop_A_Q(ntryL,G1H8(29),20,nMT,G2H8(22),n2h8(210))
  call Hloop_QV_A(ntryL,G1H16(265),ex3(:),G1H8(30),m3h2x8(:,233),heltab2x16(:,:,545))
  call Hloop_Q_A(ntryL,G1H8(30),20,nMB,G2H8(23),n2h8(211))
  call Hloop_AV_Q(ntryL,G1H16(266),ex3(:),G1H8(32),m3h2x8(:,234),heltab2x16(:,:,546))
  call Hloop_A_Q(ntryL,G1H8(32),20,nMB,G2H8(24),n2h8(212))
  call Hloop_TV_S(ntryL,G1H16(267),16,ex3(:),4,G2H8(25),m3h2x8(:,235),heltab2x16(:,:,547))
  call Hloop_SV_T(ntryL,G1H16(268),16,ex3(:),4,G2H8(26),m3h2x8(:,236),heltab2x16(:,:,548))
  call Hloop_CV_D(ntryL,G1H16(271),16,ex3(:),4,G2H8(27),m3h2x8(:,237),heltab2x16(:,:,549))
  call Hloop_DV_C(ntryL,G1H16(272),16,ex3(:),G2H8(28),m3h2x8(:,238),heltab2x16(:,:,550))
  call Hloop_CV_D(ntryL,G1H16(275),16,ex3(:),4,G2H8(29),m3h2x8(:,239),heltab2x16(:,:,551))
  call Hloop_DV_C(ntryL,G1H16(276),16,ex3(:),G2H8(32),m3h2x8(:,240),heltab2x16(:,:,552))
  call Hloop_UV_W(ntryL,G1H16(277),16,ex3(:),4,G2H8(30),m3h2x8(:,241),heltab2x16(:,:,553))
  call Hloop_UW_V(ntryL,G1H16(278),16,ex3(:),4,G2H8(31),m3h2x8(:,242),heltab2x16(:,:,554))
  call Hloop_TV_S(ntryL,G1H16(279),16,ex3(:),4,G2H8(34),m3h2x8(:,243),heltab2x16(:,:,555))
  call Hloop_SV_T(ntryL,G1H16(280),16,ex3(:),4,G2H8(35),m3h2x8(:,244),heltab2x16(:,:,556))
  call Hloop_TV_S(ntryL,G1H16(281),16,ex3(:),4,G2H8(33),m3h2x8(:,245),heltab2x16(:,:,557))
  call Hloop_SV_T(ntryL,G1H16(282),16,ex3(:),4,G2H8(36),m3h2x8(:,246),heltab2x16(:,:,558))
  call Hloop_TV_S(ntryL,G0H16(117),16,ex3(:),4,G1H8(33),m3h2x8(:,247),heltab2x16(:,:,559))
  call Hloop_SV_T(ntryL,G0H16(118),16,ex3(:),4,G1H8(34),m3h2x8(:,248),heltab2x16(:,:,560))
  call Hloop_SV_V(ntryL,G1H16(283),ex3(:),G1H8(35),m3h2x8(:,249),heltab2x16(:,:,561))
  call Hloop_SV_V(ntryL,G1H16(284),ex3(:),G1H8(36),m3h2x8(:,250),heltab2x16(:,:,562))
  call Hloop_SV_V(ntryL,G1H16(285),ex3(:),G1H8(46),m3h2x8(:,251),heltab2x16(:,:,563))
  call Hloop_SV_V(ntryL,G1H16(286),ex3(:),G1H8(47),m3h2x8(:,252),heltab2x16(:,:,564))
  call Hloop_VV_S(ntryL,G0H16(119),ex3(:),G0H8(18),m3h2x8(:,253),heltab2x16(:,:,565))
  call Hloop_VV_S(ntryL,G0H16(120),ex3(:),G0H8(11),m3h2x8(:,254),heltab2x16(:,:,566))
  call Hloop_TV_S(ntryL,G0H16(121),16,ex3(:),4,G1H8(48),m3h2x8(:,255),heltab2x16(:,:,567))
  call Hloop_SV_T(ntryL,G0H16(122),16,ex3(:),4,G1H8(49),m3h2x8(:,256),heltab2x16(:,:,568))
  call Hloop_TV_S(ntryL,G0H16(123),16,ex3(:),4,G1H8(50),m3h2x8(:,257),heltab2x16(:,:,569))
  call Hloop_SV_T(ntryL,G0H16(124),16,ex3(:),4,G1H8(60),m3h2x8(:,258),heltab2x16(:,:,570))
  call Hloop_SV_V(ntryL,G1H16(288),ex3(:),G1H8(61),m3h2x8(:,259),heltab2x16(:,:,571))
  call Hloop_SV_V(ntryL,G0H16(126),ex3(:),G0H8(12),m3h2x8(:,260),heltab2x16(:,:,572))
  call Hloop_SV_V(ntryL,G0H16(128),ex3(:),G0H8(13),m3h2x8(:,261),heltab2x16(:,:,573))
  call Hloop_VV_S(ntryL,G0H16(130),ex3(:),G0H8(14),m3h2x8(:,262),heltab2x16(:,:,574))
  call Hloop_VV_S(ntryL,G0H16(132),ex3(:),G0H8(9),m3h2x8(:,263),heltab2x16(:,:,575))
  call Hloop_VV_S(ntryL,G1H16(290),ex3(:),G1H8(62),m3h2x8(:,264),heltab2x16(:,:,576))
  call Hloop_UV_W(ntryL,G0H16(133),16,ex3(:),4,G1H8(63),m3h2x8(:,265),heltab2x16(:,:,577))
  call Hloop_UW_V(ntryL,G0H16(134),16,ex3(:),4,G1H8(64),m3h2x8(:,266),heltab2x16(:,:,578))
  call Hloop_UV_W(ntryL,G0H16(135),16,ex3(:),4,G1H8(74),m3h2x8(:,267),heltab2x16(:,:,579))
  call Hloop_UW_V(ntryL,G0H16(136),16,ex3(:),4,G1H8(75),m3h2x8(:,268),heltab2x16(:,:,580))
  call Hloop_SV_V(ntryL,G0H16(137),ex3(:),G0H8(1),m3h2x8(:,269),heltab2x16(:,:,581))
  call Hloop_SV_V(ntryL,G0H16(138),ex3(:),G0H8(2),m3h2x8(:,270),heltab2x16(:,:,582))
  call Hloop_VV_S(ntryL,G1H16(291),ex3(:),G1H8(78),m3h2x8(:,271),heltab2x16(:,:,583))
  call Hloop_VV_S(ntryL,G1H16(292),ex3(:),G1H8(81),m3h2x8(:,272),heltab2x16(:,:,584))
  call Hloop_VV_S(ntryL,G1H16(293),ex3(:),G1H8(82),m3h2x8(:,273),heltab2x16(:,:,585))
  call Hloop_VV_S(ntryL,G1H16(294),ex3(:),G1H8(86),m3h2x8(:,274),heltab2x16(:,:,586))
  call Hloop_UV_W(ntryL,G0H16(139),16,ex3(:),4,G1H8(89),m3h2x8(:,275),heltab2x16(:,:,587))
  call Hloop_UW_V(ntryL,G0H16(140),16,ex3(:),4,G1H8(125),m3h2x8(:,276),heltab2x16(:,:,588))
  call Hloop_UV_W(ntryL,G1H16(295),16,ex3(:),4,G2H8(37),m3h2x8(:,277),heltab2x16(:,:,589))
  call Hloop_UW_V(ntryL,G1H16(296),16,ex3(:),4,G2H8(41),m3h2x8(:,278),heltab2x16(:,:,590))
  call Hloop_UV_W(ntryL,G1H16(297),16,ex3(:),4,G2H8(38),m3h2x8(:,279),heltab2x16(:,:,591))
  call Hloop_UW_V(ntryL,G1H16(298),16,ex3(:),4,G2H8(39),m3h2x8(:,280),heltab2x16(:,:,592))
  call Hloop_QV_A(ntryL,G1H16(299),ex3(:),G1H8(90),m3h2x8(:,281),heltab2x16(:,:,593))
  call Hloop_Q_A(ntryL,G1H8(90),20,nME,G2H8(42),n2h8(213))
  call Hloop_QV_A(ntryL,G1H16(300),ex3(:),G1H8(91),m3h2x8(:,282),heltab2x16(:,:,594))
  call Hloop_Q_A(ntryL,G1H8(91),20,nMM,G2H8(43),n2h8(214))
  call Hloop_QV_A(ntryL,G1H16(301),ex3(:),G1H8(127),m3h2x8(:,283),heltab2x16(:,:,595))
  call Hloop_Q_A(ntryL,G1H8(127),20,nML,G2H8(40),n2h8(215))
  call Hloop_AV_Q(ntryL,G1H16(302),ex3(:),G1H8(128),m3h2x8(:,284),heltab2x16(:,:,596))
  call Hloop_A_Q(ntryL,G1H8(128),20,nME,G2H8(44),n2h8(216))
  call Hloop_AV_Q(ntryL,G1H16(303),ex3(:),G1H8(129),m3h2x8(:,285),heltab2x16(:,:,597))
  call Hloop_A_Q(ntryL,G1H8(129),20,nMM,G2H8(45),n2h8(217))
  call Hloop_AV_Q(ntryL,G1H16(304),ex3(:),G1H8(130),m3h2x8(:,286),heltab2x16(:,:,598))
  call Hloop_A_Q(ntryL,G1H8(130),20,nML,G2H8(49),n2h8(218))
  call Hloop_QV_A(ntryL,G1H16(309),ex3(:),G1H8(131),m3h2x8(:,287),heltab2x16(:,:,599))
  call Hloop_Q_A(ntryL,G1H8(131),20,0,G2H8(46),n2h8(219))
  call Hloop_QV_A(ntryL,G1H16(306),ex3(:),G1H8(133),m3h2x8(:,288),heltab2x16(:,:,600))
  call Hloop_Q_A(ntryL,G1H8(133),20,nMT,G2H8(47),n2h8(220))
  call Hloop_AV_Q(ntryL,G1H16(311),ex3(:),G1H8(134),m3h2x8(:,289),heltab2x16(:,:,601))
  call Hloop_A_Q(ntryL,G1H8(134),20,0,G2H8(50),n2h8(221))
  call Hloop_AV_Q(ntryL,G1H16(308),ex3(:),G1H8(135),m3h2x8(:,290),heltab2x16(:,:,602))
  call Hloop_A_Q(ntryL,G1H8(135),20,nMT,G2H8(51),n2h8(222))
  call Hloop_QV_A(ntryL,G1H16(310),ex3(:),G1H8(94),m3h2x8(:,291),heltab2x16(:,:,603))
  call Hloop_Q_A(ntryL,G1H8(94),20,nMB,G2H8(48),n2h8(223))
  call Hloop_AV_Q(ntryL,G1H16(312),ex3(:),G1H8(136),m3h2x8(:,292),heltab2x16(:,:,604))
  call Hloop_A_Q(ntryL,G1H8(136),20,nMB,G2H8(52),n2h8(224))
  call Hloop_QV_A(ntryL,G1H16(313),ex3(:),G1H8(138),m3h2x8(:,293),heltab2x16(:,:,605))
  call Hloop_Q_A(ntryL,G1H8(138),20,nME,G2H8(53),n2h8(225))
  call Hloop_QV_A(ntryL,G1H16(314),ex3(:),G1H8(139),m3h2x8(:,294),heltab2x16(:,:,606))
  call Hloop_Q_A(ntryL,G1H8(139),20,nMM,G2H8(55),n2h8(226))
  call Hloop_QV_A(ntryL,G1H16(315),ex3(:),G1H8(140),m3h2x8(:,295),heltab2x16(:,:,607))
  call Hloop_Q_A(ntryL,G1H8(140),20,nML,G2H8(54),n2h8(227))
  call Hloop_AV_Q(ntryL,G1H16(316),ex3(:),G1H8(141),m3h2x8(:,296),heltab2x16(:,:,608))
  call Hloop_A_Q(ntryL,G1H8(141),20,nME,G2H8(56),n2h8(228))
  call Hloop_AV_Q(ntryL,G1H16(317),ex3(:),G1H8(142),m3h2x8(:,297),heltab2x16(:,:,609))
  call Hloop_A_Q(ntryL,G1H8(142),20,nMM,G2H8(57),n2h8(229))
  call Hloop_AV_Q(ntryL,G1H16(318),ex3(:),G1H8(144),m3h2x8(:,298),heltab2x16(:,:,610))
  call Hloop_A_Q(ntryL,G1H8(144),20,nML,G2H8(59),n2h8(230))
  call Hloop_QV_A(ntryL,G1H16(319),ex3(:),G1H8(145),m3h2x8(:,299),heltab2x16(:,:,611))
  call Hloop_Q_A(ntryL,G1H8(145),20,0,G2H8(58),n2h8(231))
  call Hloop_QV_A(ntryL,G1H16(320),ex3(:),G1H8(146),m3h2x8(:,300),heltab2x16(:,:,612))
  call Hloop_Q_A(ntryL,G1H8(146),20,nMT,G2H8(60),n2h8(232))
  call Hloop_AV_Q(ntryL,G1H16(321),ex3(:),G1H8(97),m3h2x8(:,301),heltab2x16(:,:,613))
  call Hloop_A_Q(ntryL,G1H8(97),20,0,G2H8(61),n2h8(233))
  call Hloop_AV_Q(ntryL,G1H16(322),ex3(:),G1H8(147),m3h2x8(:,302),heltab2x16(:,:,614))
  call Hloop_A_Q(ntryL,G1H8(147),20,nMT,G2H8(63),n2h8(234))
  call Hloop_QV_A(ntryL,G1H16(323),ex3(:),G1H8(149),m3h2x8(:,303),heltab2x16(:,:,615))
  call Hloop_Q_A(ntryL,G1H8(149),20,0,G2H8(62),n2h8(235))
  call Hloop_QV_A(ntryL,G1H16(324),ex3(:),G1H8(150),m3h2x8(:,304),heltab2x16(:,:,616))
  call Hloop_Q_A(ntryL,G1H8(150),20,nMB,G2H8(64),n2h8(236))
  call Hloop_AV_Q(ntryL,G1H16(325),ex3(:),G1H8(151),m3h2x8(:,305),heltab2x16(:,:,617))
  call Hloop_A_Q(ntryL,G1H8(151),20,0,G2H8(65),n2h8(237))
  call Hloop_AV_Q(ntryL,G1H16(326),ex3(:),G1H8(100),m3h2x8(:,306),heltab2x16(:,:,618))
  call Hloop_A_Q(ntryL,G1H8(100),20,nMB,G2H8(66),n2h8(238))
  call Hloop_TV_S(ntryL,G1H16(327),16,ex3(:),4,G2H8(67),m3h2x8(:,307),heltab2x16(:,:,619))
  call Hloop_SV_T(ntryL,G1H16(328),16,ex3(:),4,G2H8(69),m3h2x8(:,308),heltab2x16(:,:,620))
  call Hloop_TV_S(ntryL,G1H16(329),16,ex3(:),4,G2H8(68),m3h2x8(:,309),heltab2x16(:,:,621))
  call Hloop_SV_T(ntryL,G1H16(330),16,ex3(:),4,G2H8(70),m3h2x8(:,310),heltab2x16(:,:,622))
  call Hloop_CV_D(ntryL,G1H16(333),16,ex3(:),4,G2H8(71),m3h2x8(:,311),heltab2x16(:,:,623))
  call Hloop_DV_C(ntryL,G1H16(334),16,ex3(:),G2H8(72),m3h2x8(:,312),heltab2x16(:,:,624))
  call Hloop_CV_D(ntryL,G1H16(337),16,ex3(:),4,G2H8(73),m3h2x8(:,313),heltab2x16(:,:,625))
  call Hloop_DV_C(ntryL,G1H16(338),16,ex3(:),G2H8(74),m3h2x8(:,314),heltab2x16(:,:,626))
  call Hloop_UV_W(ntryL,G1H16(339),16,ex3(:),4,G2H8(75),m3h2x8(:,315),heltab2x16(:,:,627))
  call Hloop_UW_V(ntryL,G1H16(340),16,ex3(:),4,G2H8(76),m3h2x8(:,316),heltab2x16(:,:,628))
  call Hloop_UV_W(ntryL,G1H16(341),16,ex3(:),4,G2H8(77),m3h2x8(:,317),heltab2x16(:,:,629))
  call Hloop_UW_V(ntryL,G1H16(342),16,ex3(:),4,G2H8(78),m3h2x8(:,318),heltab2x16(:,:,630))
  call Hloop_TV_S(ntryL,G1H16(343),16,ex3(:),4,G2H8(79),m3h2x8(:,319),heltab2x16(:,:,631))
  call Hloop_SV_T(ntryL,G1H16(344),16,ex3(:),4,G2H8(80),m3h2x8(:,320),heltab2x16(:,:,632))
  call Hloop_TV_S(ntryL,G1H16(345),16,ex3(:),4,G2H8(81),m3h2x8(:,321),heltab2x16(:,:,633))
  call Hloop_SV_T(ntryL,G1H16(346),16,ex3(:),4,G2H8(82),m3h2x8(:,322),heltab2x16(:,:,634))
  call Hloop_TV_S(ntryL,G0H16(141),16,ex3(:),4,G1H8(101),m3h2x8(:,323),heltab2x16(:,:,635))
  call Hloop_SV_T(ntryL,G0H16(142),16,ex3(:),4,G1H8(103),m3h2x8(:,324),heltab2x16(:,:,636))
  call Hloop_TV_S(ntryL,G0H16(143),16,ex3(:),4,G1H8(104),m3h2x8(:,325),heltab2x16(:,:,637))
  call Hloop_SV_T(ntryL,G0H16(144),16,ex3(:),4,G1H8(105),m3h2x8(:,326),heltab2x16(:,:,638))
  call Hloop_SV_V(ntryL,G1H16(347),ex3(:),G1H8(106),m3h2x8(:,327),heltab2x16(:,:,639))
  call Hloop_SV_V(ntryL,G1H16(348),ex3(:),G1H8(107),m3h2x8(:,328),heltab2x16(:,:,640))
  call Hloop_SV_V(ntryL,G1H16(349),ex3(:),G1H8(109),m3h2x8(:,329),heltab2x16(:,:,641))
  call Hloop_SV_V(ntryL,G1H16(350),ex3(:),G1H8(152),m3h2x8(:,330),heltab2x16(:,:,642))
  call Hloop_VV_S(ntryL,G0H16(145),ex3(:),G0H8(3),m3h2x8(:,331),heltab2x16(:,:,643))
  call Hloop_VV_S(ntryL,G0H16(146),ex3(:),G0H8(4),m3h2x8(:,332),heltab2x16(:,:,644))
  call Hloop_VV_S(ntryL,G0H16(147),ex3(:),G0H8(5),m3h2x8(:,333),heltab2x16(:,:,645))
  call Hloop_VV_S(ntryL,G0H16(148),ex3(:),G0H8(7),m3h2x8(:,334),heltab2x16(:,:,646))
  call Hloop_TV_S(ntryL,G0H16(149),16,ex3(:),4,G1H8(153),m3h2x8(:,335),heltab2x16(:,:,647))
  call Hloop_SV_T(ntryL,G0H16(150),16,ex3(:),4,G1H8(154),m3h2x8(:,336),heltab2x16(:,:,648))
  call Hloop_TV_S(ntryL,G0H16(151),16,ex3(:),4,G1H8(155),m3h2x8(:,337),heltab2x16(:,:,649))
  call Hloop_SV_T(ntryL,G0H16(152),16,ex3(:),4,G1H8(157),m3h2x8(:,338),heltab2x16(:,:,650))
  call Hloop_SV_V(ntryL,G1H16(351),ex3(:),G1H8(158),m3h2x8(:,339),heltab2x16(:,:,651))
  call Hloop_SV_V(ntryL,G1H16(352),ex3(:),G1H8(159),m3h2x8(:,340),heltab2x16(:,:,652))
  call Hloop_SV_V(ntryL,G1H16(353),ex3(:),G1H8(112),m3h2x8(:,341),heltab2x16(:,:,653))
  call Hloop_SV_V(ntryL,G1H16(354),ex3(:),G1H8(160),m3h2x8(:,342),heltab2x16(:,:,654))
  call Hloop_SV_V(ntryL,G0H16(154),ex3(:),G0H8(6),m3h2x8(:,343),heltab2x16(:,:,655))
  call Hloop_SV_V(ntryL,G0H16(156),ex3(:),G0H8(8),m3h2x8(:,344),heltab2x16(:,:,656))
  call Hloop_VV_S(ntryL,G0H16(158),ex3(:),G0H8(10),m3h2x8(:,345),heltab2x16(:,:,657))
  call Hloop_VV_S(ntryL,G0H16(160),ex3(:),G0H8(19),m3h2x8(:,346),heltab2x16(:,:,658))
  call Hloop_VV_S(ntryL,G1H16(355),ex3(:),G1H8(162),m3h2x8(:,347),heltab2x16(:,:,659))
  call Hloop_VV_S(ntryL,G1H16(356),ex3(:),G1H8(163),m3h2x8(:,348),heltab2x16(:,:,660))
  call Hloop_VV_S(ntryL,G1H16(357),ex3(:),G1H8(164),m3h2x8(:,349),heltab2x16(:,:,661))
  call Hloop_VV_S(ntryL,G1H16(358),ex3(:),G1H8(165),m3h2x8(:,350),heltab2x16(:,:,662))
  call Hloop_UV_W(ntryL,G0H16(161),16,ex3(:),4,G1H8(166),m3h2x8(:,351),heltab2x16(:,:,663))
  call Hloop_UW_V(ntryL,G0H16(162),16,ex3(:),4,G1H8(168),m3h2x8(:,352),heltab2x16(:,:,664))
  call Hloop_UV_W(ntryL,G0H16(163),16,ex3(:),4,G1H8(169),m3h2x8(:,353),heltab2x16(:,:,665))
  call Hloop_UW_V(ntryL,G0H16(164),16,ex3(:),4,G1H8(170),m3h2x8(:,354),heltab2x16(:,:,666))
  call Hloop_SV_V(ntryL,G0H16(165),ex3(:),G0H8(20),m3h2x8(:,355),heltab2x16(:,:,667))
  call Hloop_SV_V(ntryL,G0H16(166),ex3(:),G0H8(53),m3h2x8(:,356),heltab2x16(:,:,668))
  call Hloop_SV_V(ntryL,G0H16(167),ex3(:),G0H8(15),m3h2x8(:,357),heltab2x16(:,:,669))
  call Hloop_SV_V(ntryL,G0H16(168),ex3(:),G0H8(16),m3h2x8(:,358),heltab2x16(:,:,670))
  call Hloop_VV_S(ntryL,G1H16(359),ex3(:),G1H8(115),m3h2x8(:,359),heltab2x16(:,:,671))
  call Hloop_VV_S(ntryL,G1H16(360),ex3(:),G1H8(171),m3h2x8(:,360),heltab2x16(:,:,672))
  call Hloop_VV_S(ntryL,G1H16(361),ex3(:),G1H8(173),m3h2x8(:,361),heltab2x16(:,:,673))
  call Hloop_VV_S(ntryL,G1H16(362),ex3(:),G1H8(174),m3h2x8(:,362),heltab2x16(:,:,674))
  call Hloop_UV_W(ntryL,G0H16(169),16,ex3(:),4,G1H8(175),m3h2x8(:,363),heltab2x16(:,:,675))
  call Hloop_UW_V(ntryL,G0H16(170),16,ex3(:),4,G1H8(96),m3h2x8(:,364),heltab2x16(:,:,676))
  call Hloop_UV_W(ntryL,G0H16(171),16,ex3(:),4,G1H8(114),m3h2x8(:,365),heltab2x16(:,:,677))
  call Hloop_UW_V(ntryL,G0H16(172),16,ex3(:),4,G1H8(7),m3h2x8(:,366),heltab2x16(:,:,678))
  call Hloop_UV_W(ntryL,G1H16(363),16,ex3(:),4,G2H8(83),m3h2x8(:,367),heltab2x16(:,:,679))
  call Hloop_UW_V(ntryL,G1H16(364),16,ex3(:),4,G2H8(84),m3h2x8(:,368),heltab2x16(:,:,680))
  call Hloop_UV_W(ntryL,G1H16(365),16,ex3(:),4,G2H8(85),m3h2x8(:,369),heltab2x16(:,:,681))
  call Hloop_UW_V(ntryL,G1H16(366),16,ex3(:),4,G2H8(86),m3h2x8(:,370),heltab2x16(:,:,682))
  call Hloop_SA_Q(ntryL,G1H16(367),ex2(:),G1H8(13),ngPtb,m3h2x8(:,371),heltab2x16(:,:,683))
  call Hloop_A_Q(ntryL,G1H8(13),18,nMB,G2H8(87),n2h8(239))
  call Hloop_QA_S(ntryL,G1H16(368),ex2(:),G1H8(83),ngPtb,m3h2x8(:,372),heltab2x16(:,:,684))
  call Hloop_SA_Q(ntryL,G0H16(173),ex2(:),G0H8(17),ngPtb,m3h2x8(:,373),heltab2x16(:,:,685))
  call Hloop_A_Q(ntryL,G0H8(17),18,nMB,G1H8(126),n2h8(240))
  call Hloop_WA_Q(ntryL,G0H16(174),ex2(:),G0H8(17),m3h2x8(:,374),heltab2x16(:,:,686))
  call Hloop_A_Q(ntryL,G0H8(17),18,nMB,G1H8(132),n2h8(241))
  call Hloop_QA_S(ntryL,G1H16(369),ex2(:),G1H8(137),ngPtb,m3h2x8(:,375),heltab2x16(:,:,687))
  call Hloop_QA_W(ntryL,G1H16(370),ex2(:),G1H8(4),m3h2x8(:,376),heltab2x16(:,:,688))
  call Hloop_WA_Q(ntryL,G1H16(371),ex2(:),G1H8(17),m3h2x8(:,377),heltab2x16(:,:,689))
  call Hloop_A_Q(ntryL,G1H8(17),18,nMB,G2H8(88),n2h8(242))
  call Hloop_QA_W(ntryL,G1H16(372),ex2(:),G1H8(27),m3h2x8(:,378),heltab2x16(:,:,690))
  call Hloop_AQ_S(ntryL,G1H16(373),wf4(:,3),G1H4(369),ngH,m3h4x4(:,313),heltab2x16(:,:,691))
  call Hloop_AQ_S(ntryL,G1H16(374),wf4(:,3),G1H4(370),ngX,m3h4x4(:,314),heltab2x16(:,:,692))
  call Hloop_AQ_S(ntryL,G1H16(375),wf4(:,3),G1H4(375),ngPbt,m3h4x4(:,315),heltab2x16(:,:,693))
  call Hloop_SQ_A(ntryL,G1H16(376),wf4(:,3),G1H4(380),ngPbt,m3h4x4(:,316),heltab2x16(:,:,694))
  call Hloop_Q_A(ntryL,G1H4(380),21,nMB,G2H4(233),n2h4(345))
  call Hloop_AQ_V(ntryL,G1H16(377),wf4(:,3),G1H4(376),m3h4x4(:,317),heltab2x16(:,:,695))
  call Hloop_AQ_Z(ntryL,G1H16(378),wf4(:,3),G1H4(379),ngZu,m3h4x4(:,318),heltab2x16(:,:,696))
  call Hloop_AQ_W(ntryL,G1H16(379),wf4(:,3),G1H4(381),m3h4x4(:,319),heltab2x16(:,:,697))
  call Hloop_WQ_A(ntryL,G0H16(175),wf4(:,3),G0H4(41),m3h4x4(:,320),heltab2x16(:,:,698))
  call Hloop_Q_A(ntryL,G0H4(41),21,nMB,G1H4(384),n2h4(346))
  call Hloop_SQ_A(ntryL,G0H16(176),wf4(:,3),G0H4(41),ngPbt,m3h4x4(:,321),heltab2x16(:,:,699))
  call Hloop_Q_A(ntryL,G0H4(41),21,nMB,G1H4(385),n2h4(347))
  call Hloop_SQ_A(ntryL,G1H16(380),wf4(:,3),G1H4(386),ngPbt,m3h4x4(:,322),heltab2x16(:,:,700))
  call Hloop_Q_A(ntryL,G1H4(386),21,nMB,G2H4(234),n2h4(348))
  call Hloop_WQ_A(ntryL,G1H16(381),wf4(:,3),G1H4(391),m3h4x4(:,323),heltab2x16(:,:,701))
  call Hloop_Q_A(ntryL,G1H4(391),21,nMB,G2H4(235),n2h4(349))
  call Hloop_WQ_A(ntryL,G0H16(177),wf4(:,3),G0H4(41),m3h4x4(:,324),heltab2x16(:,:,702))
  call Hloop_Q_A(ntryL,G0H4(41),21,nMB,G1H4(396),n2h4(350))
  call Hloop_SQ_A(ntryL,G0H16(178),wf4(:,3),G0H4(41),ngPbt,m3h4x4(:,325),heltab2x16(:,:,703))
  call Hloop_Q_A(ntryL,G0H4(41),21,nMB,G1H4(392),n2h4(351))
  call Hloop_WQ_A(ntryL,G1H16(382),wf4(:,3),G1H4(395),m3h4x4(:,326),heltab2x16(:,:,704))
  call Hloop_Q_A(ntryL,G1H4(395),21,nMB,G2H4(236),n2h4(352))
  call Hloop_QA_S(ntryL,G1H16(383),ex2(:),G1H8(39),ngH,m3h2x8(:,379),heltab2x16(:,:,705))
  call Hloop_QA_S(ntryL,G1H16(384),ex2(:),G1H8(55),ngX,m3h2x8(:,380),heltab2x16(:,:,706))
  call Hloop_QA_S(ntryL,G1H16(385),ex2(:),G1H8(66),ngPtb,m3h2x8(:,381),heltab2x16(:,:,707))
  call Hloop_SA_Q(ntryL,G1H16(386),ex2(:),G1H8(72),ngPtb,m3h2x8(:,382),heltab2x16(:,:,708))
  call Hloop_A_Q(ntryL,G1H8(72),18,nMB,G2H8(89),n2h8(243))
  call Hloop_QA_V(ntryL,G1H16(387),ex2(:),G1H8(85),m3h2x8(:,383),heltab2x16(:,:,709))
  call Hloop_QA_Z(ntryL,G1H16(388),ex2(:),G1H8(38),ngZu,m3h2x8(:,384),heltab2x16(:,:,710))
  call Hloop_QA_W(ntryL,G1H16(389),ex2(:),G1H8(37),m3h2x8(:,385),heltab2x16(:,:,711))
  call Hloop_SA_Q(ntryL,G1H16(390),ex2(:),G1H8(40),ngPtb,m3h2x8(:,386),heltab2x16(:,:,712))
  call Hloop_A_Q(ntryL,G1H8(40),18,nMB,G2H8(90),n2h8(244))
  call Hloop_SA_Q(ntryL,G0H16(179),ex2(:),G0H8(17),ngPtb,m3h2x8(:,387),heltab2x16(:,:,713))
  call Hloop_A_Q(ntryL,G0H8(17),18,nMB,G1H8(42),n2h8(245))
  call Hloop_WA_Q(ntryL,G0H16(180),ex2(:),G0H8(17),m3h2x8(:,388),heltab2x16(:,:,714))
  call Hloop_A_Q(ntryL,G0H8(17),18,nMB,G1H8(31),n2h8(246))
  call Hloop_SA_Q(ntryL,G0H16(181),ex2(:),G0H8(17),ngPtb,m3h2x8(:,389),heltab2x16(:,:,715))
  call Hloop_A_Q(ntryL,G0H8(17),18,nMB,G1H8(45),n2h8(247))
  call Hloop_WA_Q(ntryL,G0H16(182),ex2(:),G0H8(17),m3h2x8(:,390),heltab2x16(:,:,716))
  call Hloop_A_Q(ntryL,G0H8(17),18,nMB,G1H8(59),n2h8(248))
  call Hloop_WA_Q(ntryL,G1H16(391),ex2(:),G1H8(73),m3h2x8(:,391),heltab2x16(:,:,717))
  call Hloop_A_Q(ntryL,G1H8(73),18,nMB,G2H8(91),n2h8(249))
  call Hloop_WA_Q(ntryL,G1H16(392),ex2(:),G1H8(118),m3h2x8(:,392),heltab2x16(:,:,718))
  call Hloop_A_Q(ntryL,G1H8(118),18,nMB,G2H8(92),n2h8(250))
  call Hloop_SQ_A(ntryL,G1H16(393),ex1(:),G1H8(119),ngPbt,m3h2x8(:,393),heltab2x16(:,:,719))
  call Hloop_Q_A(ntryL,G1H8(119),17,nMB,G2H8(93),n2h8(251))
  call Hloop_AQ_S(ntryL,G1H16(394),ex1(:),G1H8(120),ngPbt,m3h2x8(:,394),heltab2x16(:,:,720))
  call Hloop_SQ_A(ntryL,G0H16(183),ex1(:),G0H8(17),ngPbt,m3h2x8(:,395),heltab2x16(:,:,721))
  call Hloop_Q_A(ntryL,G0H8(17),17,nMB,G1H8(121),n2h8(252))
  call Hloop_WQ_A(ntryL,G0H16(184),ex1(:),G0H8(17),m3h2x8(:,396),heltab2x16(:,:,722))
  call Hloop_Q_A(ntryL,G0H8(17),17,nMB,G1H8(143),n2h8(253))
  call Hloop_AQ_S(ntryL,G1H16(395),ex1(:),G1H8(148),ngPbt,m3h2x8(:,397),heltab2x16(:,:,723))
  call Hloop_AQ_W(ntryL,G1H16(396),ex1(:),G1H8(102),m3h2x8(:,398),heltab2x16(:,:,724))
  call Hloop_WQ_A(ntryL,G1H16(397),ex1(:),G1H8(108),m3h2x8(:,399),heltab2x16(:,:,725))
  call Hloop_Q_A(ntryL,G1H8(108),17,nMB,G2H8(94),n2h8(254))
  call Hloop_AQ_W(ntryL,G1H16(398),ex1(:),G1H8(156),m3h2x8(:,400),heltab2x16(:,:,726))
  call Hloop_QA_S(ntryL,G1H16(399),wf4(:,10),G1H4(397),ngH,m3h4x4(:,327),heltab2x16(:,:,727))
  call Hloop_QA_S(ntryL,G1H16(400),wf4(:,10),G1H4(400),ngX,m3h4x4(:,328),heltab2x16(:,:,728))
  call Hloop_QA_S(ntryL,G1H16(401),wf4(:,10),G1H4(401),ngPtb,m3h4x4(:,329),heltab2x16(:,:,729))
  call Hloop_SA_Q(ntryL,G1H16(402),wf4(:,10),G1H4(402),ngPtb,m3h4x4(:,330),heltab2x16(:,:,730))
  call Hloop_A_Q(ntryL,G1H4(402),22,nMB,G2H4(237),n2h4(353))
  call Hloop_QA_V(ntryL,G1H16(403),wf4(:,10),G1H4(407),m3h4x4(:,331),heltab2x16(:,:,731))
  call Hloop_QA_Z(ntryL,G1H16(404),wf4(:,10),G1H4(412),ngZu,m3h4x4(:,332),heltab2x16(:,:,732))
  call Hloop_QA_W(ntryL,G1H16(405),wf4(:,10),G1H4(408),m3h4x4(:,333),heltab2x16(:,:,733))
  call Hloop_WA_Q(ntryL,G0H16(185),wf4(:,10),G0H4(41),m3h4x4(:,334),heltab2x16(:,:,734))
  call Hloop_A_Q(ntryL,G0H4(41),22,nMB,G1H4(411),n2h4(354))
  call Hloop_SA_Q(ntryL,G0H16(186),wf4(:,10),G0H4(41),ngPtb,m3h4x4(:,335),heltab2x16(:,:,735))
  call Hloop_A_Q(ntryL,G0H4(41),22,nMB,G1H4(413),n2h4(355))
  call Hloop_SA_Q(ntryL,G1H16(406),wf4(:,10),G1H4(416),ngPtb,m3h4x4(:,336),heltab2x16(:,:,736))
  call Hloop_A_Q(ntryL,G1H4(416),22,nMB,G2H4(238),n2h4(356))
  call Hloop_WA_Q(ntryL,G1H16(407),wf4(:,10),G1H4(357),m3h4x4(:,337),heltab2x16(:,:,737))
  call Hloop_A_Q(ntryL,G1H4(357),22,nMB,G2H4(239),n2h4(357))
  call Hloop_WA_Q(ntryL,G0H16(187),wf4(:,10),G0H4(41),m3h4x4(:,338),heltab2x16(:,:,738))
  call Hloop_A_Q(ntryL,G0H4(41),22,nMB,G1H4(358),n2h4(358))
  call Hloop_SA_Q(ntryL,G0H16(188),wf4(:,10),G0H4(41),ngPtb,m3h4x4(:,339),heltab2x16(:,:,739))
  call Hloop_A_Q(ntryL,G0H4(41),22,nMB,G1H4(373),n2h4(359))
  call Hloop_WA_Q(ntryL,G1H16(408),wf4(:,10),G1H4(374),m3h4x4(:,340),heltab2x16(:,:,740))
  call Hloop_A_Q(ntryL,G1H4(374),22,nMB,G2H4(240),n2h4(360))
  call Hloop_AQ_S(ntryL,G1H16(409),ex1(:),G1H8(161),ngH,m3h2x8(:,401),heltab2x16(:,:,741))
  call Hloop_AQ_S(ntryL,G1H16(410),ex1(:),G1H8(167),ngX,m3h2x8(:,402),heltab2x16(:,:,742))
  call Hloop_AQ_S(ntryL,G1H16(411),ex1(:),G1H8(172),ngPbt,m3h2x8(:,403),heltab2x16(:,:,743))
  call Hloop_SQ_A(ntryL,G1H16(412),ex1(:),G1H8(77),ngPbt,m3h2x8(:,404),heltab2x16(:,:,744))
  call Hloop_Q_A(ntryL,G1H8(77),17,nMB,G2H8(95),n2h8(255))
  call Hloop_AQ_V(ntryL,G1H16(413),ex1(:),G1H8(79),m3h2x8(:,405),heltab2x16(:,:,745))
  call Hloop_AQ_Z(ntryL,G1H16(414),ex1(:),G1H8(84),ngZu,m3h2x8(:,406),heltab2x16(:,:,746))
  call Hloop_AQ_W(ntryL,G1H16(415),ex1(:),G1H8(93),m3h2x8(:,407),heltab2x16(:,:,747))
  call Hloop_SQ_A(ntryL,G1H16(416),ex1(:),G1H8(99),ngPbt,m3h2x8(:,408),heltab2x16(:,:,748))
  call Hloop_Q_A(ntryL,G1H8(99),17,nMB,G2H8(96),n2h8(256))
  call Hloop_SQ_A(ntryL,G0H16(189),ex1(:),G0H8(17),ngPbt,m3h2x8(:,409),heltab2x16(:,:,749))
  call Hloop_Q_A(ntryL,G0H8(17),17,nMB,G1H8(98),n2h8(257))
  call Hloop_WQ_A(ntryL,G0H16(190),ex1(:),G0H8(17),m3h2x8(:,410),heltab2x16(:,:,750))
  call Hloop_Q_A(ntryL,G0H8(17),17,nMB,G1H8(111),n2h8(258))
  call Hloop_SQ_A(ntryL,G0H16(191),ex1(:),G0H8(17),ngPbt,m3h2x8(:,411),heltab2x16(:,:,751))
  call Hloop_Q_A(ntryL,G0H8(17),17,nMB,G1H8(110),n2h8(259))
  call Hloop_WQ_A(ntryL,G0H16(192),ex1(:),G0H8(17),m3h2x8(:,412),heltab2x16(:,:,752))
  call Hloop_Q_A(ntryL,G0H8(17),17,nMB,G1H8(113),n2h8(260))
  call Hloop_WQ_A(ntryL,G1H16(417),ex1(:),G1H8(117),m3h2x8(:,413),heltab2x16(:,:,753))
  call Hloop_Q_A(ntryL,G1H8(117),17,nMB,G2H8(97),n2h8(261))
  call Hloop_WQ_A(ntryL,G1H16(418),ex1(:),G1H8(116),m3h2x8(:,414),heltab2x16(:,:,754))
  call Hloop_Q_A(ntryL,G1H8(116),17,nMB,G2H8(98),n2h8(262))
  call Hloop_SA_Q(ntryL,G1H16(419),ex2(:),G1H8(3),ngPtb,m3h2x8(:,415),heltab2x16(:,:,755))
  call Hloop_A_Q(ntryL,G1H8(3),18,nMB,G2H8(99),n2h8(263))
  call Hloop_QA_S(ntryL,G1H16(420),ex2(:),G1H8(5),ngPtb,m3h2x8(:,416),heltab2x16(:,:,756))
  call Hloop_SA_Q(ntryL,G0H16(193),ex2(:),G0H8(17),ngPtb,m3h2x8(:,417),heltab2x16(:,:,757))
  call Hloop_A_Q(ntryL,G0H8(17),18,nMB,G1H8(8),n2h8(264))
  call Hloop_WA_Q(ntryL,G0H16(194),ex2(:),G0H8(17),m3h2x8(:,418),heltab2x16(:,:,758))
  call Hloop_A_Q(ntryL,G0H8(17),18,nMB,G1H8(9),n2h8(265))
  call Hloop_QA_S(ntryL,G1H16(421),ex2(:),G1H8(10),ngPtb,m3h2x8(:,419),heltab2x16(:,:,759))
  call Hloop_QA_W(ntryL,G1H16(422),ex2(:),G1H8(11),m3h2x8(:,420),heltab2x16(:,:,760))
  call Hloop_WA_Q(ntryL,G1H16(423),ex2(:),G1H8(12),m3h2x8(:,421),heltab2x16(:,:,761))
  call Hloop_A_Q(ntryL,G1H8(12),18,nMB,G2H8(100),n2h8(266))
  call Hloop_QA_W(ntryL,G1H16(424),ex2(:),G1H8(14),m3h2x8(:,422),heltab2x16(:,:,762))
  call Hloop_QV_A(ntryL,G1H16(425),ex3(:),G1H8(25),m3h2x8(:,423),heltab2x16(:,:,763))
  call Hloop_Q_A(ntryL,G1H8(25),20,nMT,G2H8(101),n2h8(267))
  call Hloop_QV_A(ntryL,G1H16(426),ex3(:),G1H8(26),m3h2x8(:,424),heltab2x16(:,:,764))
  call Hloop_Q_A(ntryL,G1H8(26),20,nMT,G2H8(102),n2h8(268))
  call Hloop_QV_A(ntryL,G1H16(427),ex3(:),G1H8(29),m3h2x8(:,425),heltab2x16(:,:,765))
  call Hloop_Q_A(ntryL,G1H8(29),20,nMB,G2H8(103),n2h8(269))
  call Hloop_SV_T(ntryL,G1H16(428),16,ex3(:),4,G2H8(104),m3h2x8(:,426),heltab2x16(:,:,766))
  call Hloop_QV_A(ntryL,G1H16(429),ex3(:),G1H8(30),m3h2x8(:,427),heltab2x16(:,:,767))
  call Hloop_Q_A(ntryL,G1H8(30),20,nMT,G2H8(105),n2h8(270))
  call Hloop_QV_A(ntryL,G1H16(430),ex3(:),G1H8(32),m3h2x8(:,428),heltab2x16(:,:,768))
  call Hloop_Q_A(ntryL,G1H8(32),20,nMT,G2H8(106),n2h8(271))
  call Hloop_QV_A(ntryL,G1H16(431),ex3(:),G1H8(90),m3h2x8(:,429),heltab2x16(:,:,769))
  call Hloop_Q_A(ntryL,G1H8(90),20,nMB,G2H8(107),n2h8(272))
  call Hloop_SV_T(ntryL,G0H16(195),16,ex3(:),4,G1H8(91),m3h2x8(:,430),heltab2x16(:,:,770))
  call Hloop_VV_S(ntryL,G0H16(196),ex3(:),G0H8(17),m3h2x8(:,431),heltab2x16(:,:,771))
  call Hloop_SV_V(ntryL,G1H16(432),ex3(:),G1H8(127),m3h2x8(:,432),heltab2x16(:,:,772))
  call Hloop_VV_S(ntryL,G1H16(433),ex3(:),G1H8(128),m3h2x8(:,433),heltab2x16(:,:,773))
  call Hloop_SV_V(ntryL,G0H16(197),ex3(:),G0H8(54),m3h2x8(:,434),heltab2x16(:,:,774))
  call Hloop_UW_V(ntryL,G0H16(198),16,ex3(:),4,G1H8(129),m3h2x8(:,435),heltab2x16(:,:,775))
  call Hloop_UW_V(ntryL,G1H16(434),16,ex3(:),4,G2H8(108),m3h2x8(:,436),heltab2x16(:,:,776))
  call Hloop_QA_S(ntryL,G1H16(435),ex2(:),G1H8(130),ngH,m3h2x8(:,437),heltab2x16(:,:,777))
  call Hloop_QA_S(ntryL,G1H16(436),ex2(:),G1H8(131),ngX,m3h2x8(:,438),heltab2x16(:,:,778))
  call Hloop_QA_S(ntryL,G1H16(437),ex2(:),G1H8(133),ngPtb,m3h2x8(:,439),heltab2x16(:,:,779))
  call Hloop_SA_Q(ntryL,G1H16(438),ex2(:),G1H8(134),ngPtb,m3h2x8(:,440),heltab2x16(:,:,780))
  call Hloop_A_Q(ntryL,G1H8(134),18,nMB,G2H8(109),n2h8(273))
  call Hloop_QA_V(ntryL,G1H16(439),ex2(:),G1H8(135),m3h2x8(:,441),heltab2x16(:,:,781))
  call Hloop_QA_Z(ntryL,G1H16(440),ex2(:),G1H8(94),ngZu,m3h2x8(:,442),heltab2x16(:,:,782))
  call Hloop_QA_W(ntryL,G1H16(441),ex2(:),G1H8(136),m3h2x8(:,443),heltab2x16(:,:,783))
  call Hloop_SA_Q(ntryL,G1H16(442),ex2(:),G1H8(138),ngPtb,m3h2x8(:,444),heltab2x16(:,:,784))
  call Hloop_A_Q(ntryL,G1H8(138),18,nMB,G2H8(110),n2h8(274))
  call Hloop_SA_Q(ntryL,G0H16(199),ex2(:),G0H8(55),ngPtb,m3h2x8(:,445),heltab2x16(:,:,785))
  call Hloop_A_Q(ntryL,G0H8(55),18,nMB,G1H8(139),n2h8(275))
  call Hloop_WA_Q(ntryL,G0H16(200),ex2(:),G0H8(55),m3h2x8(:,446),heltab2x16(:,:,786))
  call Hloop_A_Q(ntryL,G0H8(55),18,nMB,G1H8(140),n2h8(276))
  call Hloop_SA_Q(ntryL,G0H16(201),ex2(:),G0H8(55),ngPtb,m3h2x8(:,447),heltab2x16(:,:,787))
  call Hloop_A_Q(ntryL,G0H8(55),18,nMB,G1H8(141),n2h8(277))
  call Hloop_WA_Q(ntryL,G0H16(202),ex2(:),G0H8(55),m3h2x8(:,448),heltab2x16(:,:,788))
  call Hloop_A_Q(ntryL,G0H8(55),18,nMB,G1H8(142),n2h8(278))
  call Hloop_WA_Q(ntryL,G1H16(443),ex2(:),G1H8(144),m3h2x8(:,449),heltab2x16(:,:,789))
  call Hloop_A_Q(ntryL,G1H8(144),18,nMB,G2H8(111),n2h8(279))
  call Hloop_WA_Q(ntryL,G1H16(444),ex2(:),G1H8(145),m3h2x8(:,450),heltab2x16(:,:,790))
  call Hloop_A_Q(ntryL,G1H8(145),18,nMB,G2H8(112),n2h8(280))
  call Hloop_SQ_A(ntryL,G1H16(445),ex1(:),G1H8(146),ngPbt,m3h2x8(:,451),heltab2x16(:,:,791))
  call Hloop_Q_A(ntryL,G1H8(146),17,nMB,G2H8(113),n2h8(281))
  call Hloop_AQ_S(ntryL,G1H16(446),ex1(:),G1H8(97),ngPbt,m3h2x8(:,452),heltab2x16(:,:,792))
  call Hloop_SQ_A(ntryL,G0H16(203),ex1(:),G0H8(55),ngPbt,m3h2x8(:,453),heltab2x16(:,:,793))
  call Hloop_Q_A(ntryL,G0H8(55),17,nMB,G1H8(147),n2h8(282))
  call Hloop_WQ_A(ntryL,G0H16(204),ex1(:),G0H8(55),m3h2x8(:,454),heltab2x16(:,:,794))
  call Hloop_Q_A(ntryL,G0H8(55),17,nMB,G1H8(149),n2h8(283))
  call Hloop_AQ_S(ntryL,G1H16(447),ex1(:),G1H8(150),ngPbt,m3h2x8(:,455),heltab2x16(:,:,795))
  call Hloop_AQ_W(ntryL,G1H16(448),ex1(:),G1H8(151),m3h2x8(:,456),heltab2x16(:,:,796))
  call Hloop_WQ_A(ntryL,G1H16(449),ex1(:),G1H8(100),m3h2x8(:,457),heltab2x16(:,:,797))
  call Hloop_Q_A(ntryL,G1H8(100),17,nMB,G2H8(114),n2h8(284))
  call Hloop_AQ_W(ntryL,G1H16(450),ex1(:),G1H8(13),m3h2x8(:,458),heltab2x16(:,:,798))
  call Hloop_AV_Q(ntryL,G1H16(451),ex3(:),G1H8(17),m3h2x8(:,459),heltab2x16(:,:,799))
  call Hloop_A_Q(ntryL,G1H8(17),20,nMT,G2H8(115),n2h8(285))
  call Hloop_AV_Q(ntryL,G1H16(452),ex3(:),G1H8(72),m3h2x8(:,460),heltab2x16(:,:,800))
  call Hloop_A_Q(ntryL,G1H8(72),20,nMT,G2H8(116),n2h8(286))
  call Hloop_AV_Q(ntryL,G1H16(453),ex3(:),G1H8(40),m3h2x8(:,461),heltab2x16(:,:,801))
  call Hloop_A_Q(ntryL,G1H8(40),20,nMB,G2H8(117),n2h8(287))
  call Hloop_TV_S(ntryL,G1H16(454),16,ex3(:),4,G2H8(118),m3h2x8(:,462),heltab2x16(:,:,802))
  call Hloop_AV_Q(ntryL,G1H16(455),ex3(:),G1H8(73),m3h2x8(:,463),heltab2x16(:,:,803))
  call Hloop_A_Q(ntryL,G1H8(73),20,nMT,G2H8(119),n2h8(288))
  call Hloop_AV_Q(ntryL,G1H16(456),ex3(:),G1H8(118),m3h2x8(:,464),heltab2x16(:,:,804))
  call Hloop_A_Q(ntryL,G1H8(118),20,nMT,G2H8(120),n2h8(289))
  call Hloop_AV_Q(ntryL,G1H16(457),ex3(:),G1H8(119),m3h2x8(:,465),heltab2x16(:,:,805))
  call Hloop_A_Q(ntryL,G1H8(119),20,nMB,G2H8(121),n2h8(290))
  call Hloop_TV_S(ntryL,G0H16(205),16,ex3(:),4,G1H8(108),m3h2x8(:,466),heltab2x16(:,:,806))
  call Hloop_VV_S(ntryL,G0H16(206),ex3(:),G0H8(55),m3h2x8(:,467),heltab2x16(:,:,807))
  call Hloop_SV_V(ntryL,G1H16(458),ex3(:),G1H8(77),m3h2x8(:,468),heltab2x16(:,:,808))
  call Hloop_VV_S(ntryL,G1H16(459),ex3(:),G1H8(99),m3h2x8(:,469),heltab2x16(:,:,809))
  call Hloop_SV_V(ntryL,G0H16(207),ex3(:),G0H8(56),m3h2x8(:,470),heltab2x16(:,:,810))
  call Hloop_UV_W(ntryL,G0H16(208),16,ex3(:),4,G1H8(117),m3h2x8(:,471),heltab2x16(:,:,811))
  call Hloop_UV_W(ntryL,G1H16(460),16,ex3(:),4,G2H8(122),m3h2x8(:,472),heltab2x16(:,:,812))
  call Hloop_AQ_S(ntryL,G1H16(461),ex1(:),G1H8(116),ngH,m3h2x8(:,473),heltab2x16(:,:,813))
  call Hloop_AQ_S(ntryL,G1H16(462),ex1(:),G1H8(3),ngX,m3h2x8(:,474),heltab2x16(:,:,814))
  call Hloop_AQ_S(ntryL,G1H16(463),ex1(:),G1H8(12),ngPbt,m3h2x8(:,475),heltab2x16(:,:,815))
  call Hloop_SQ_A(ntryL,G1H16(464),ex1(:),G1H8(25),ngPbt,m3h2x8(:,476),heltab2x16(:,:,816))
  call Hloop_Q_A(ntryL,G1H8(25),17,nMB,G2H8(123),n2h8(291))
  call Hloop_AQ_V(ntryL,G1H16(465),ex1(:),G1H8(26),m3h2x8(:,477),heltab2x16(:,:,817))
  call Hloop_AQ_Z(ntryL,G1H16(466),ex1(:),G1H8(29),ngZu,m3h2x8(:,478),heltab2x16(:,:,818))
  call Hloop_AQ_W(ntryL,G1H16(467),ex1(:),G1H8(30),m3h2x8(:,479),heltab2x16(:,:,819))
  call Hloop_SQ_A(ntryL,G1H16(468),ex1(:),G1H8(32),ngPbt,m3h2x8(:,480),heltab2x16(:,:,820))
  call Hloop_Q_A(ntryL,G1H8(32),17,nMB,G2H8(124),n2h8(292))
  call Hloop_SQ_A(ntryL,G0H16(209),ex1(:),G0H8(57),ngPbt,m3h2x8(:,481),heltab2x16(:,:,821))
  call Hloop_Q_A(ntryL,G0H8(57),17,nMB,G1H8(90),n2h8(293))
  call Hloop_WQ_A(ntryL,G0H16(210),ex1(:),G0H8(57),m3h2x8(:,482),heltab2x16(:,:,822))
  call Hloop_Q_A(ntryL,G0H8(57),17,nMB,G1H8(134),n2h8(294))
  call Hloop_SQ_A(ntryL,G0H16(211),ex1(:),G0H8(57),ngPbt,m3h2x8(:,483),heltab2x16(:,:,823))
  call Hloop_Q_A(ntryL,G0H8(57),17,nMB,G1H8(138),n2h8(295))
  call Hloop_WQ_A(ntryL,G0H16(212),ex1(:),G0H8(57),m3h2x8(:,484),heltab2x16(:,:,824))
  call Hloop_Q_A(ntryL,G0H8(57),17,nMB,G1H8(144),n2h8(296))
  call Hloop_WQ_A(ntryL,G1H16(469),ex1(:),G1H8(145),m3h2x8(:,485),heltab2x16(:,:,825))
  call Hloop_Q_A(ntryL,G1H8(145),17,nMB,G2H8(125),n2h8(297))
  call Hloop_WQ_A(ntryL,G1H16(470),ex1(:),G1H8(146),m3h2x8(:,486),heltab2x16(:,:,826))
  call Hloop_Q_A(ntryL,G1H8(146),17,nMB,G2H8(126),n2h8(298))
  call Hloop_SV_T(ntryL,G0H8(21),17,ex3(:),4,G1H4(389),m3h2x4(:,289),heltab2x8(:,:,289))
  call Hloop_VV_S(ntryL,G0H8(22),ex3(:),G0H4(41),m3h2x4(:,290),heltab2x8(:,:,290))
  call Hloop_SV_V(ntryL,G0H8(23),ex3(:),G0H4(42),m3h2x4(:,291),heltab2x8(:,:,291))
  call Hloop_UW_V(ntryL,G0H8(24),17,ex3(:),4,G1H4(390),m3h2x4(:,292),heltab2x8(:,:,292))
  call Hloop_SA_Q(ntryL,G0H8(25),ex2(:),G0H4(43),ngH,m3h2x4(:,293),heltab2x8(:,:,293))
  call Hloop_A_Q(ntryL,G0H4(43),19,nMT,G1H4(405),n2h4(361))
  call Hloop_SA_Q(ntryL,G0H8(26),ex2(:),G0H4(43),ngX,m3h2x4(:,294),heltab2x8(:,:,294))
  call Hloop_A_Q(ntryL,G0H4(43),19,nMT,G1H4(406),n2h4(362))
  call Hloop_SA_Q(ntryL,G0H8(27),ex2(:),G0H4(43),ngPtb,m3h2x4(:,295),heltab2x8(:,:,295))
  call Hloop_A_Q(ntryL,G0H4(43),19,nMB,G1H4(33),n2h4(363))
  call Hloop_QA_S(ntryL,G1H8(122),ex2(:),G1H4(1),ngPtb,m3h2x4(:,296),heltab2x8(:,:,296))
  call Hloop_VA_Q(ntryL,G0H8(28),ex2(:),G0H4(43),m3h2x4(:,297),heltab2x8(:,:,297))
  call Hloop_A_Q(ntryL,G0H4(43),19,nMT,G1H4(4),n2h4(364))
  call Hloop_ZA_Q(ntryL,G0H8(29),ex2(:),G0H4(43),ngZu,m3h2x4(:,298),heltab2x8(:,:,298))
  call Hloop_A_Q(ntryL,G0H4(43),19,nMT,G1H4(6),n2h4(365))
  call Hloop_WA_Q(ntryL,G0H8(30),ex2(:),G0H4(43),m3h2x4(:,299),heltab2x8(:,:,299))
  call Hloop_A_Q(ntryL,G0H4(43),19,nMB,G1H4(5),n2h4(366))
  call Hloop_QA_S(ntryL,G1H8(123),ex2(:),G1H4(8),ngPtb,m3h2x4(:,300),heltab2x8(:,:,300))
  call Hloop_QA_S(ntryL,G1H8(124),ex2(:),G1H4(9),ngPtb,m3h2x4(:,301),heltab2x8(:,:,301))
  call Hloop_QA_W(ntryL,G1H8(1),ex2(:),G1H4(12),m3h2x4(:,302),heltab2x8(:,:,302))
  call Hloop_QA_S(ntryL,G1H8(2),ex2(:),G1H4(11),ngPtb,m3h2x4(:,303),heltab2x8(:,:,303))
  call Hloop_QA_W(ntryL,G1H8(6),ex2(:),G1H4(14),m3h2x4(:,304),heltab2x8(:,:,304))
  call Hloop_QA_W(ntryL,G1H8(16),ex2(:),G1H4(15),m3h2x4(:,305),heltab2x8(:,:,305))
  call Hloop_QA_W(ntryL,G1H8(15),ex2(:),G1H4(34),m3h2x4(:,306),heltab2x8(:,:,306))
  call Hloop_SA_Q(ntryL,G0H8(31),ex2(:),G0H4(43),ngH,m3h2x4(:,307),heltab2x8(:,:,307))
  call Hloop_A_Q(ntryL,G0H4(43),19,nMT,G1H4(35),n2h4(367))
  call Hloop_SA_Q(ntryL,G0H8(32),ex2(:),G0H4(43),ngX,m3h2x4(:,308),heltab2x8(:,:,308))
  call Hloop_A_Q(ntryL,G0H4(43),19,nMT,G1H4(36),n2h4(368))
  call Hloop_SA_Q(ntryL,G0H8(33),ex2(:),G0H4(43),ngPtb,m3h2x4(:,309),heltab2x8(:,:,309))
  call Hloop_A_Q(ntryL,G0H4(43),19,nMB,G1H4(39),n2h4(369))
  call Hloop_QA_S(ntryL,G1H8(18),ex2(:),G1H4(40),ngPtb,m3h2x4(:,310),heltab2x8(:,:,310))
  call Hloop_VA_Q(ntryL,G0H8(34),ex2(:),G0H4(43),m3h2x4(:,311),heltab2x8(:,:,311))
  call Hloop_A_Q(ntryL,G0H4(43),19,nMT,G1H4(41),n2h4(370))
  call Hloop_ZA_Q(ntryL,G0H8(35),ex2(:),G0H4(43),ngZu,m3h2x4(:,312),heltab2x8(:,:,312))
  call Hloop_A_Q(ntryL,G0H4(43),19,nMT,G1H4(42),n2h4(371))
  call Hloop_WA_Q(ntryL,G0H8(36),ex2(:),G0H4(43),m3h2x4(:,313),heltab2x8(:,:,313))
  call Hloop_A_Q(ntryL,G0H4(43),19,nMB,G1H4(45),n2h4(372))
  call Hloop_QA_S(ntryL,G1H8(20),ex2(:),G1H4(46),ngPtb,m3h2x4(:,314),heltab2x8(:,:,314))
  call Hloop_QA_S(ntryL,G1H8(19),ex2(:),G1H4(65),ngPtb,m3h2x4(:,315),heltab2x8(:,:,315))
  call Hloop_QA_W(ntryL,G1H8(22),ex2(:),G1H4(66),m3h2x4(:,316),heltab2x8(:,:,316))
  call Hloop_QA_S(ntryL,G1H8(21),ex2(:),G1H4(69),ngPtb,m3h2x4(:,317),heltab2x8(:,:,317))
  call Hloop_QA_W(ntryL,G1H8(23),ex2(:),G1H4(70),m3h2x4(:,318),heltab2x8(:,:,318))
  call Hloop_QA_W(ntryL,G1H8(24),ex2(:),G1H4(71),m3h2x4(:,319),heltab2x8(:,:,319))
  call Hloop_QA_W(ntryL,G1H8(28),ex2(:),G1H4(72),m3h2x4(:,320),heltab2x8(:,:,320))
  call Hloop_TV_S(ntryL,G0H8(37),18,ex3(:),4,G1H4(75),m3h2x4(:,321),heltab2x8(:,:,321))
  call Hloop_VV_S(ntryL,G0H8(38),ex3(:),G0H4(43),m3h2x4(:,322),heltab2x8(:,:,322))
  call Hloop_SV_V(ntryL,G0H8(39),ex3(:),G0H4(44),m3h2x4(:,323),heltab2x8(:,:,323))
  call Hloop_UV_W(ntryL,G0H8(40),18,ex3(:),4,G1H4(76),m3h2x4(:,324),heltab2x8(:,:,324))
  call Hloop_SQ_A(ntryL,G0H8(41),ex1(:),G0H4(45),ngH,m3h2x4(:,325),heltab2x8(:,:,325))
  call Hloop_Q_A(ntryL,G0H4(45),19,nMT,G1H4(77),n2h4(373))
  call Hloop_SQ_A(ntryL,G0H8(42),ex1(:),G0H4(45),ngX,m3h2x4(:,326),heltab2x8(:,:,326))
  call Hloop_Q_A(ntryL,G0H4(45),19,nMT,G1H4(78),n2h4(374))
  call Hloop_SQ_A(ntryL,G0H8(43),ex1(:),G0H4(45),ngPbt,m3h2x4(:,327),heltab2x8(:,:,327))
  call Hloop_Q_A(ntryL,G0H4(45),19,nMB,G1H4(81),n2h4(375))
  call Hloop_AQ_S(ntryL,G1H8(41),ex1(:),G1H4(82),ngPbt,m3h2x4(:,328),heltab2x8(:,:,328))
  call Hloop_VQ_A(ntryL,G0H8(44),ex1(:),G0H4(45),m3h2x4(:,329),heltab2x8(:,:,329))
  call Hloop_Q_A(ntryL,G0H4(45),19,nMT,G1H4(83),n2h4(376))
  call Hloop_ZQ_A(ntryL,G0H8(45),ex1(:),G0H4(45),ngZu,m3h2x4(:,330),heltab2x8(:,:,330))
  call Hloop_Q_A(ntryL,G0H4(45),19,nMT,G1H4(84),n2h4(377))
  call Hloop_WQ_A(ntryL,G0H8(46),ex1(:),G0H4(45),m3h2x4(:,331),heltab2x8(:,:,331))
  call Hloop_Q_A(ntryL,G0H4(45),19,nMB,G1H4(87),n2h4(378))
  call Hloop_AQ_S(ntryL,G1H8(44),ex1(:),G1H4(88),ngPbt,m3h2x4(:,332),heltab2x8(:,:,332))
  call Hloop_AQ_S(ntryL,G1H8(43),ex1(:),G1H4(89),ngPbt,m3h2x4(:,333),heltab2x8(:,:,333))
  call Hloop_AQ_W(ntryL,G1H8(52),ex1(:),G1H4(90),m3h2x4(:,334),heltab2x8(:,:,334))
  call Hloop_AQ_S(ntryL,G1H8(51),ex1(:),G1H4(93),ngPbt,m3h2x4(:,335),heltab2x8(:,:,335))
  call Hloop_AQ_W(ntryL,G1H8(56),ex1(:),G1H4(94),m3h2x4(:,336),heltab2x8(:,:,336))
  call Hloop_AQ_W(ntryL,G1H8(53),ex1(:),G1H4(129),m3h2x4(:,337),heltab2x8(:,:,337))
  call Hloop_AQ_W(ntryL,G1H8(54),ex1(:),G1H4(130),m3h2x4(:,338),heltab2x8(:,:,338))
  call Hloop_SQ_A(ntryL,G0H8(47),ex1(:),G0H4(45),ngH,m3h2x4(:,339),heltab2x8(:,:,339))
  call Hloop_Q_A(ntryL,G0H4(45),19,nMT,G1H4(131),n2h4(379))
  call Hloop_SQ_A(ntryL,G0H8(48),ex1(:),G0H4(45),ngX,m3h2x4(:,340),heltab2x8(:,:,340))
  call Hloop_Q_A(ntryL,G0H4(45),19,nMT,G1H4(132),n2h4(380))
  call Hloop_SQ_A(ntryL,G0H8(49),ex1(:),G0H4(45),ngPbt,m3h2x4(:,341),heltab2x8(:,:,341))
  call Hloop_Q_A(ntryL,G0H4(45),19,nMB,G1H4(135),n2h4(381))
  call Hloop_AQ_S(ntryL,G1H8(58),ex1(:),G1H4(136),ngPbt,m3h2x4(:,342),heltab2x8(:,:,342))
  call Hloop_VQ_A(ntryL,G0H8(50),ex1(:),G0H4(45),m3h2x4(:,343),heltab2x8(:,:,343))
  call Hloop_Q_A(ntryL,G0H4(45),19,nMT,G1H4(137),n2h4(382))
  call Hloop_ZQ_A(ntryL,G0H8(51),ex1(:),G0H4(45),ngZu,m3h2x4(:,344),heltab2x8(:,:,344))
  call Hloop_Q_A(ntryL,G0H4(45),19,nMT,G1H4(138),n2h4(383))
  call Hloop_WQ_A(ntryL,G0H8(52),ex1(:),G0H4(45),m3h2x4(:,345),heltab2x8(:,:,345))
  call Hloop_Q_A(ntryL,G0H4(45),19,nMB,G1H4(141),n2h4(384))
  call Hloop_AQ_S(ntryL,G1H8(57),ex1(:),G1H4(142),ngPbt,m3h2x4(:,346),heltab2x8(:,:,346))
  call Hloop_AQ_S(ntryL,G1H8(65),ex1(:),G1H4(143),ngPbt,m3h2x4(:,347),heltab2x8(:,:,347))
  call Hloop_AQ_W(ntryL,G1H8(69),ex1(:),G1H4(144),m3h2x4(:,348),heltab2x8(:,:,348))
  call Hloop_AQ_S(ntryL,G1H8(70),ex1(:),G1H4(147),ngPbt,m3h2x4(:,349),heltab2x8(:,:,349))
  call Hloop_AQ_W(ntryL,G1H8(67),ex1(:),G1H4(148),m3h2x4(:,350),heltab2x8(:,:,350))
  call Hloop_AQ_W(ntryL,G1H8(68),ex1(:),G1H4(149),m3h2x4(:,351),heltab2x8(:,:,351))
  call Hloop_AQ_W(ntryL,G1H8(71),ex1(:),G1H4(150),m3h2x4(:,352),heltab2x8(:,:,352))
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(233),[G2H4(167),G2H4(95),G1H4(384)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(234),[G2H4(175),G2H4(99),G1H4(396)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(235),[G2H4(171),G2H4(103),G1H4(385)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(236),[G2H4(180),G2H4(108),G1H4(392)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(237),[G2H4(131),G2H4(113),G1H4(411)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(238),[G2H4(139),G2H4(117),G1H4(358)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(239),[G2H4(135),G2H4(121),G1H4(413)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(240),[G2H4(144),G2H4(126),G1H4(373)])
call ol_merge_last(G1H4(21), G1H4(21)) 
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(130),[G1H4(21)])
call ol_merge_last(G2H4(143), G2H4(143)) 
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(143),[G1H4(22)])
call ol_merge_last(G1H4(23), G1H4(23)) 
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(148),[G1H4(23)])
call ol_merge_last(G2H4(161), G2H4(161)) 
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(161),[G1H4(24)])
call ol_merge_last(G1H4(25), G1H4(25)) 
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(166),[G1H4(25)])
call HGT_OLR(G2H4(166),1,1,4)
call HGT_invQ_OLR(G2H4(166),2,5,4)
call HGT_OLR(G2H4(166),6,15,4)
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(166),[G1H4(59)])
call ol_merge_last(G2H4(179), G2H4(179)) 
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(179),[G1H4(26)])
call HGT_lower_alpha_w2_OLR(G2H4(179),1,1,4)
call HGT_lower_alpha_w2_invQ_OLR(G2H4(179),2,5,4)
call HGT_lower_alpha_w2_OLR(G2H4(179),6,15,4)
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(179),[G1H4(60)])
call ol_merge_last(G1H4(28), G1H4(28)) 
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(28),[G1H4(27)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(87),[G1H4(81),G1H4(67)])
call HGT_OLR(G1H4(28),1,1,4)
call HGT_invQ_OLR(G1H4(28),2,5,4)
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(28),[G1H4(87)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(184),[G1H4(356)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(188),[G1H4(372)])
call ol_merge_last(G1H4(29), G1H4(29)) 
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(192),[G1H4(29)])
call HGT_OLR(G2H4(192),1,1,4)
call HGT_invQ_OLR(G2H4(192),2,5,4)
call HGT_OLR(G2H4(192),6,15,4)
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(192),[G1H4(63)])
call ol_merge_last(G2H4(205), G2H4(205)) 
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(205),[G1H4(30)])
call HGT_lower_alpha_w2_OLR(G2H4(205),1,1,4)
call HGT_lower_alpha_w2_invQ_OLR(G2H4(205),2,5,4)
call HGT_lower_alpha_w2_OLR(G2H4(205),6,15,4)
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(205),[G1H4(64)])
call ol_merge_last(G1H4(32), G1H4(32)) 
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(32),[G1H4(31)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(141),[G1H4(135),G1H4(151)])
call HGT_OLR(G1H4(32),1,1,4)
call HGT_invQ_OLR(G1H4(32),2,5,4)
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(32),[G1H4(141)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(210),[G1H4(388)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(214),[G1H4(404)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(369),[G1H4(3)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(370),[G1H4(10)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(375),[G1H4(308),G1H4(16)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(376),[G1H4(38)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(379),[G1H4(44)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(381),[G1H4(314),G1H4(50)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(77),[G1H4(55)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(18),[G2H4(4),G2H4(204),G2H4(190),G1H4(80),G1H4(62) &
    ,G1H4(56)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(84),[G1H4(78),G1H4(61)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(22),[G2H4(6),G2H4(208),G2H4(194),G1H4(68)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(82),[G1H4(73)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(25),[G2H4(23),G1H4(261),G1H4(257),G1H4(245),G1H4(74) &
    ,G0H4(31),G0H4(29)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(83),[G1H4(79)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(88),[G1H4(85)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(7),[G2H4(215),G1H4(333),G1H4(329),G1H4(321),G1H4(317) &
    ,G1H4(86),G0H4(21)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(129),[G1H4(91)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(12),[G2H4(9),G1H4(365),G1H4(360),G1H4(351),G1H4(347) &
    ,G1H4(92),G0H4(27)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(130),[G1H4(97)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(223),[G2H4(221),G1H4(275),G1H4(273),G1H4(255),G1H4(98) &
    ,G0H4(39),G0H4(37)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(397),[G1H4(104)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(400),[G1H4(110)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(401),[G1H4(284),G1H4(116)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(407),[G1H4(122)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(412),[G1H4(128)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(408),[G1H4(290),G1H4(134)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(131),[G1H4(139)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(140),[G2H4(119),G2H4(77),G2H4(69),G1H4(164),G1H4(146) &
    ,G1H4(140)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(138),[G1H4(132),G1H4(145)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(146),[G2H4(127),G2H4(79),G2H4(67),G1H4(152)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(136),[G1H4(157)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(155),[G2H4(152),G1H4(112),G1H4(108),G1H4(96),G1H4(158) &
    ,G0H4(12),G0H4(10)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(137),[G1H4(163)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(142),[G1H4(169)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(88),[G2H4(86),G1H4(190),G1H4(186),G1H4(178),G1H4(174) &
    ,G1H4(170),G0H4(2)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(149),[G1H4(175)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(92),[G2H4(91),G1H4(208),G1H4(204),G1H4(196),G1H4(192) &
    ,G1H4(176),G0H4(8)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(150),[G1H4(181)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(168),[G2H4(164),G1H4(126),G1H4(124),G1H4(106),G1H4(182) &
    ,G0H4(20),G0H4(18)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(405),[G1H4(187)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(14),[G2H4(2),G2H4(203),G2H4(189),G1H4(212),G1H4(194) &
    ,G1H4(188)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(6),[G1H4(406),G1H4(193)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(5),[G1H4(33),G1H4(199)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(20),[G2H4(5),G2H4(207),G2H4(191),G1H4(200)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(1),[G1H4(205)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(26),[G2H4(24),G1H4(262),G1H4(258),G1H4(246),G1H4(206) &
    ,G0H4(32),G0H4(30)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(4),[G1H4(211)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(8),[G1H4(217)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(8),[G2H4(216),G1H4(334),G1H4(330),G1H4(322),G1H4(318) &
    ,G1H4(218),G0H4(22)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(15),[G1H4(223)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(13),[G2H4(10),G1H4(368),G1H4(363),G1H4(352),G1H4(348) &
    ,G1H4(224),G0H4(28)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(34),[G1H4(229)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(224),[G2H4(222),G1H4(276),G1H4(274),G1H4(256),G1H4(230) &
    ,G0H4(40),G0H4(38)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(35),[G1H4(235)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(142),[G2H4(123),G2H4(78),G2H4(66),G1H4(260),G1H4(242) &
    ,G1H4(236)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(42),[G1H4(36),G1H4(241)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(45),[G1H4(39),G1H4(247)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(150),[G2H4(128),G2H4(80),G2H4(70),G1H4(248)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(40),[G1H4(253)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(154),[G2H4(151),G1H4(111),G1H4(107),G1H4(95),G1H4(254) &
    ,G0H4(11),G0H4(9)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(41),[G1H4(259)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(46),[G1H4(265)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(87),[G2H4(84),G1H4(189),G1H4(185),G1H4(177),G1H4(173) &
    ,G1H4(266),G0H4(1)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(71),[G1H4(271)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(90),[G2H4(89),G1H4(207),G1H4(203),G1H4(195),G1H4(191) &
    ,G1H4(272),G0H4(7)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(72),[G1H4(277)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(165),[G2H4(163),G1H4(125),G1H4(123),G1H4(105),G1H4(278) &
    ,G0H4(19),G0H4(17)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(75),[G1H4(283),G0H4(43)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(76),[G1H4(289),G0H4(44)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(389),[G1H4(307),G0H4(41)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(390),[G1H4(313),G0H4(42)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(49),[G1H4(355)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(54),[G1H4(371)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(57),[G1H4(387)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(58),[G1H4(403)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H8(1),[G1H8(76)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H8(2),[G1H8(80)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H8(3),[G1H8(88)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H8(4),[G1H8(87)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(129),[G2H4(104),G2H4(71),G2H4(59)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(132),[G2H4(105),G2H4(72),G2H4(60)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(133),[G2H4(109),G2H4(73),G2H4(61)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(134),[G2H4(110),G2H4(74),G2H4(62)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(136),[G2H4(114),G2H4(75),G2H4(63)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(137),[G2H4(115),G2H4(76),G2H4(68)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(159),[G2H4(156),G1H4(101),G1H4(99)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(160),[G2H4(158),G1H4(102),G1H4(100)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(83),[G2H4(81),G1H4(183),G1H4(179),G1H4(171),G1H4(167) &
    ,G0H4(3)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(85),[G2H4(82),G1H4(184),G1H4(180),G1H4(172),G1H4(168) &
    ,G0H4(4)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(173),[G2H4(172),G2H4(170),G2H4(169),G1H4(119),G1H4(118) &
    ,G1H4(113),G0H4(16),G0H4(15)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(178),[G2H4(177),G2H4(176),G2H4(174),G1H4(120),G1H4(117) &
    ,G1H4(114),G0H4(14),G0H4(13)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(100),[G2H4(96),G1H4(213),G1H4(209),G1H4(201),G1H4(197) &
    ,G0H4(5)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(101),[G2H4(97),G1H4(214),G1H4(210),G1H4(202),G1H4(198) &
    ,G0H4(6)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(145),[G2H4(138),G2H4(118)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(147),[G2H4(141),G2H4(122)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(102),[G2H4(36),G2H4(195),G2H4(181)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(93),[G2H4(37),G2H4(196),G2H4(182)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(106),[G2H4(50),G2H4(198),G2H4(183)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(98),[G2H4(51),G2H4(199),G2H4(185)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(11),[G2H4(64),G2H4(200),G2H4(186)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(16),[G2H4(65),G2H4(202),G2H4(187)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(219),[G2H4(217),G1H4(251),G1H4(249)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(220),[G2H4(218),G1H4(252),G1H4(250)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(212),[G2H4(209),G1H4(339),G1H4(335),G1H4(327),G1H4(323) &
    ,G0H4(23)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(213),[G2H4(211),G1H4(340),G1H4(336),G1H4(328),G1H4(324) &
    ,G0H4(24)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(228),[G2H4(227),G2H4(226),G2H4(225),G1H4(269),G1H4(268) &
    ,G1H4(263),G0H4(36),G0H4(35)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(232),[G2H4(231),G2H4(230),G2H4(229),G1H4(270),G1H4(267) &
    ,G1H4(264),G0H4(34),G0H4(33)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(33),[G2H4(31),G1H4(359),G1H4(353),G1H4(345),G1H4(341) &
    ,G0H4(25)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(34),[G2H4(32),G1H4(364),G1H4(354),G1H4(346),G1H4(342) &
    ,G0H4(26)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(19),[G2H4(17),G2H4(1)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(21),[G2H4(15),G2H4(3)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H8(25),[G0H8(18)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H8(26),[G0H8(11)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H8(30),[G0H8(1)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H8(31),[G0H8(2)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H8(35),[G2H8(34),G0H8(14)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H8(36),[G2H8(33),G0H8(9)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H8(62),[G1H8(34),G1H8(33)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H8(63),[G1H8(35)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H8(64),[G1H8(36)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H8(74),[G1H8(46)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H8(75),[G1H8(47)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H8(78),[G1H8(48)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H8(81),[G1H8(49)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H8(82),[G1H8(50)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H8(86),[G1H8(60)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H8(125),[G1H8(89),G1H8(61)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H8(41),[G2H8(37),G0H8(12)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H8(39),[G2H8(38),G0H8(13)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H8(67),[G0H8(3)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H8(69),[G0H8(4)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H8(68),[G0H8(5)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H8(70),[G0H8(7)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H8(75),[G0H8(20)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H8(76),[G0H8(53)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H8(77),[G0H8(15)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H8(78),[G0H8(16)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H8(80),[G2H8(79),G0H8(10)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H8(82),[G2H8(81),G0H8(19)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H8(162),[G1H8(101)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H8(163),[G1H8(103)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H8(164),[G1H8(104)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H8(165),[G1H8(105)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H8(166),[G1H8(106)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H8(168),[G1H8(107)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H8(169),[G1H8(109)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H8(170),[G1H8(152)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H8(115),[G1H8(153)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H8(171),[G1H8(154)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H8(173),[G1H8(155)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H8(174),[G1H8(157)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H8(175),[G1H8(158)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H8(96),[G1H8(159)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H8(114),[G1H8(112)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H8(7),[G1H8(160)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H8(84),[G2H8(83),G0H8(6)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H8(86),[G2H8(85),G0H8(8)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H8(87),[G1H8(132)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H8(88),[G1H8(126)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H8(89),[G1H8(31)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H8(90),[G1H8(59)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H8(91),[G1H8(42)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H8(92),[G1H8(45)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H8(93),[G1H8(143)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H8(94),[G1H8(121)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H8(95),[G1H8(111)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H8(96),[G1H8(113)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H8(97),[G1H8(98)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H8(98),[G1H8(110)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H8(99),[G1H8(9)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H8(100),[G1H8(8)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H8(104),[G0H8(17)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H8(128),[G1H8(91)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H8(129),[G1H8(127)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H8(108),[G0H8(54)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H8(109),[G1H8(140)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H8(110),[G1H8(142)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H8(111),[G1H8(139)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H8(112),[G1H8(141)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H8(113),[G1H8(149)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H8(114),[G1H8(147)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H8(118),[G0H8(55)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H8(99),[G1H8(108)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H8(117),[G1H8(77)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H8(122),[G0H8(56)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H8(123),[G1H8(134)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H8(124),[G1H8(144)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H8(125),[G1H8(90)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H8(126),[G1H8(138)])
call HGT_OLR(G2H4(94),1,1,4)
call HGT_invQ_OLR(G2H4(94),2,5,4)
call HGT_OLR(G2H4(94),6,15,4)
  call Hotf_4pt_reduction(G2H4(94),RedSet_4(47),mass4set(:,2),  & 
G1H4(153),G1H4(154),G1H4(155),G1H4(156),G1H4(159),4)
  call HG1shiftOLR(G1H4(154),2,4)
  call Hloop_QA_S(ntryL,G2H4(233),ex2(:),G2H2(5),ngPtb,m3h2x2(:,349),heltab2x4(:,:,349))
call HGT_lower_alpha_w2_OLR(G1H4(17),1,1,4)
call HGT_lower_alpha_w2_invQ_OLR(G1H4(17),2,5,4)
  call Hloop_SQ_A(ntryL,G1H4(17),ex1(:),G1H2(26),ngPbt,m3h2x2(:,350),heltab2x4(:,:,350))
  call Hloop_Q_A(ntryL,G1H2(26),29,nMB,G2H2(6),n2h2(129))
  call Hloop_QA_W(ntryL,G2H4(234),ex2(:),G2H2(7),m3h2x2(:,351),heltab2x4(:,:,351))
call HGT_w2_OLR(G1H4(18),1,1,4)
call HGT_w2_invQ_OLR(G1H4(18),2,5,4)
  call Hloop_WQ_A(ntryL,G1H4(18),ex1(:),G1H2(32),m3h2x2(:,352),heltab2x4(:,:,352))
  call Hloop_Q_A(ntryL,G1H2(32),29,nMB,G2H2(8),n2h2(130))
  call Hloop_QA_S(ntryL,G2H4(235),ex2(:),G2H2(13),ngPtb,m3h2x2(:,353),heltab2x4(:,:,353))
call HGT_lower_alpha_OLR(G2H4(107),1,1,4)
call HGT_lower_alpha_invQ_OLR(G2H4(107),2,5,4)
call HGT_lower_alpha_OLR(G2H4(107),6,15,4)
  call Hotf_4pt_reduction(G2H4(107),RedSet_4(47),mass4set(:,2),  & 
G1H4(160),G1H4(161),G1H4(162),G1H4(165),G1H4(166),4)
  call HG1shiftOLR(G1H4(161),2,4)
  call Hloop_QA_W(ntryL,G2H4(236),ex2(:),G2H2(14),m3h2x2(:,354),heltab2x4(:,:,354))
call HGT_OLR(G2H4(112),1,1,4)
call HGT_invQ_OLR(G2H4(112),2,5,4)
call HGT_OLR(G2H4(112),6,15,4)
  call Hotf_4pt_reduction(G2H4(112),RedSet_4(48),mass4set(:,2),  & 
G1H4(215),G1H4(216),G1H4(219),G1H4(220),G1H4(221),4)
  call HG1shiftOLR(G1H4(216),1,4)
  call Hloop_AQ_S(ntryL,G2H4(237),ex1(:),G2H2(15),ngPbt,m3h2x2(:,355),heltab2x4(:,:,355))
call HGT_lower_alpha_w2_OLR(G1H4(19),1,1,4)
call HGT_lower_alpha_w2_invQ_OLR(G1H4(19),2,5,4)
  call Hloop_SA_Q(ntryL,G1H4(19),ex2(:),G1H2(38),ngPtb,m3h2x2(:,356),heltab2x4(:,:,356))
  call Hloop_A_Q(ntryL,G1H2(38),30,nMB,G2H2(16),n2h2(131))
  call Hloop_AQ_W(ntryL,G2H4(238),ex1(:),G2H2(17),m3h2x2(:,357),heltab2x4(:,:,357))
call HGT_w2_OLR(G1H4(20),1,1,4)
call HGT_w2_invQ_OLR(G1H4(20),2,5,4)
  call Hloop_WA_Q(ntryL,G1H4(20),ex2(:),G1H2(44),m3h2x2(:,358),heltab2x4(:,:,358))
  call Hloop_A_Q(ntryL,G1H2(44),30,nMB,G2H2(18),n2h2(132))
  call Hloop_AQ_S(ntryL,G2H4(239),ex1(:),G2H2(19),ngPbt,m3h2x2(:,359),heltab2x4(:,:,359))
call HGT_lower_alpha_OLR(G2H4(125),1,1,4)
call HGT_lower_alpha_invQ_OLR(G2H4(125),2,5,4)
call HGT_lower_alpha_OLR(G2H4(125),6,15,4)
  call Hotf_4pt_reduction(G2H4(125),RedSet_4(48),mass4set(:,2),  & 
G1H4(222),G1H4(225),G1H4(226),G1H4(227),G1H4(228),4)
  call HG1shiftOLR(G1H4(225),1,4)
  call Hloop_AQ_W(ntryL,G2H4(240),ex1(:),G2H2(20),m3h2x2(:,360),heltab2x4(:,:,360))
call HGT_OLR(G2H4(130),1,1,4)
call HGT_invQ_OLR(G2H4(130),2,5,4)
call HGT_OLR(G2H4(130),6,15,4)
  call Hotf_4pt_reduction(G2H4(130),RedSet_4(49),mass4set(:,1),  & 
G1H4(231),G1H4(232),G1H4(233),G1H4(234),G1H4(237),4)
  call HG1shiftOLR(G1H4(232),1,4)
call HGT_lower_alpha_w2_OLR(G2H4(143),1,1,4)
call HGT_lower_alpha_w2_invQ_OLR(G2H4(143),2,5,4)
call HGT_lower_alpha_w2_OLR(G2H4(143),6,15,4)
  call Hotf_4pt_reduction(G2H4(143),RedSet_4(49),mass4set(:,1),  & 
G1H4(238),G1H4(239),G1H4(240),G1H4(243),G1H4(244),4)
  call HG1shiftOLR(G1H4(239),1,4)
call HGT_OLR(G2H4(148),1,1,4)
call HGT_invQ_OLR(G2H4(148),2,5,4)
call HGT_OLR(G2H4(148),6,15,4)
  call Hotf_4pt_reduction(G2H4(148),RedSet_4(50),mass4set(:,1),  & 
G1H4(279),G1H4(280),G1H4(281),G1H4(282),G1H4(285),4)
  call HG1shiftOLR(G1H4(280),1,4)
  call Hloop_AQ_S(ntryL,G2H4(149),ex1(:),G2H2(21),ngPbt,m3h2x2(:,361),heltab2x4(:,:,361))
  call Hloop_AQ_S(ntryL,G2H4(153),ex1(:),G2H2(22),ngPbt,m3h2x2(:,362),heltab2x4(:,:,362))
call HGT_lower_alpha_w2_OLR(G2H4(161),1,1,4)
call HGT_lower_alpha_w2_invQ_OLR(G2H4(161),2,5,4)
call HGT_lower_alpha_w2_OLR(G2H4(161),6,15,4)
  call Hotf_4pt_reduction(G2H4(161),RedSet_4(50),mass4set(:,1),  & 
G1H4(286),G1H4(287),G1H4(288),G1H4(291),G1H4(292),4)
  call HG1shiftOLR(G1H4(287),1,4)
  call Hloop_AQ_W(ntryL,G2H4(157),ex1(:),G2H2(23),m3h2x2(:,363),heltab2x4(:,:,363))
  call Hloop_AQ_W(ntryL,G2H4(162),ex1(:),G2H2(24),m3h2x2(:,364),heltab2x4(:,:,364))
  call Hotf_4pt_reduction(G2H4(166),RedSet_4(51),mass4set(:,1),  & 
G1H4(293),G1H4(294),G1H4(297),G1H4(298),G1H4(299),4)
  call HG1shiftOLR(G1H4(294),2,4)
  call Hotf_4pt_reduction(G2H4(179),RedSet_4(51),mass4set(:,1),  & 
G1H4(300),G1H4(303),G1H4(304),G1H4(305),G1H4(306),4)
  call HG1shiftOLR(G1H4(303),2,4)
  call Hloop_QV_A(ntryL,G1H4(28),ex3(:),G1H2(50),m3h2x2(:,365),heltab2x4(:,:,365))
  call Hloop_Q_A(ntryL,G1H2(50),23,nMB,G2H2(25),n2h2(133))
  call Hotf_4pt_reduction(G2H4(184),RedSet_4(42),mass4set(:,1),  & 
G1H4(309),G1H4(310),G1H4(311),G1H4(312),G1H4(315),4)
  call HG1shiftOLR(G1H4(310),2,4)
  call Hotf_4pt_reduction(G2H4(188),RedSet_4(42),mass4set(:,1),  & 
G1H4(316),G1H4(380),G1H4(386),G1H4(391),G1H4(395),4)
  call HG1shiftOLR(G1H4(380),2,4)
  call Hotf_4pt_reduction(G2H4(192),RedSet_4(52),mass4set(:,1),  & 
G1H4(402),G1H4(416),G1H4(357),G1H4(374),G1H4(384),4)
  call HG1shiftOLR(G1H4(416),2,4)
  call Hloop_QA_S(ntryL,G2H4(193),ex2(:),G2H2(26),ngPtb,m3h2x2(:,366),heltab2x4(:,:,366))
  call Hloop_QA_S(ntryL,G2H4(197),ex2(:),G2H2(27),ngPtb,m3h2x2(:,367),heltab2x4(:,:,367))
  call Hotf_4pt_reduction(G2H4(205),RedSet_4(52),mass4set(:,1),  & 
G1H4(396),G1H4(385),G1H4(392),G1H4(411),G1H4(358),4)
  call HG1shiftOLR(G1H4(385),2,4)
  call Hloop_QA_W(ntryL,G2H4(201),ex2(:),G2H2(28),m3h2x2(:,368),heltab2x4(:,:,368))
  call Hloop_QA_W(ntryL,G2H4(206),ex2(:),G2H2(97),m3h2x2(:,369),heltab2x4(:,:,369))
  call Hloop_QV_A(ntryL,G1H4(32),ex4(:),G1H2(56),m3h2x2(:,370),heltab2x4(:,:,370))
  call Hloop_Q_A(ntryL,G1H2(56),27,nMB,G2H2(100),n2h2(134))
  call Hotf_4pt_reduction(G2H4(210),RedSet_4(45),mass4set(:,1),  & 
G1H4(413),G1H4(373),G1H4(21),G1H4(22),G1H4(23),4)
  call HG1shiftOLR(G1H4(373),2,4)
  call Hotf_4pt_reduction(G2H4(214),RedSet_4(45),mass4set(:,1),  & 
G1H4(24),G1H4(25),G1H4(59),G1H4(26),G1H4(60),4)
  call HG1shiftOLR(G1H4(25),2,4)
  call Hloop_SA_Q(ntryL,G1H4(2),ex2(:),G1H2(62),ngH,m3h2x2(:,371),heltab2x4(:,:,371))
  call Hloop_A_Q(ntryL,G1H2(62),23,nMT,G2H2(101),n2h2(135))
  call Hloop_SA_Q(ntryL,G1H4(369),ex2(:),G1H2(68),ngH,m3h2x2(:,372),heltab2x4(:,:,372))
  call Hloop_A_Q(ntryL,G1H2(68),23,nMT,G2H2(104),n2h2(136))
  call Hloop_SA_Q(ntryL,G1H4(7),ex2(:),G1H2(74),ngX,m3h2x2(:,373),heltab2x4(:,:,373))
  call Hloop_A_Q(ntryL,G1H2(74),23,nMT,G2H2(151),n2h2(137))
  call Hloop_SA_Q(ntryL,G1H4(370),ex2(:),G1H2(80),ngX,m3h2x2(:,374),heltab2x4(:,:,374))
  call Hloop_A_Q(ntryL,G1H2(80),23,nMT,G2H2(154),n2h2(138))
  call Hloop_SA_Q(ntryL,G1H4(13),ex2(:),G1H2(86),ngPtb,m3h2x2(:,375),heltab2x4(:,:,375))
  call Hloop_A_Q(ntryL,G1H2(86),23,nMB,G2H2(155),n2h2(139))
  call Hloop_SA_Q(ntryL,G1H4(375),ex2(:),G1H2(92),ngPtb,m3h2x2(:,376),heltab2x4(:,:,376))
  call Hloop_A_Q(ntryL,G1H2(92),23,nMB,G2H2(158),n2h2(140))
  call Hloop_VA_Q(ntryL,G1H4(37),ex2(:),G1H2(98),m3h2x2(:,377),heltab2x4(:,:,377))
  call Hloop_A_Q(ntryL,G1H2(98),23,nMT,G2H2(261),n2h2(141))
  call Hloop_VA_Q(ntryL,G1H4(376),ex2(:),G1H2(104),m3h2x2(:,378),heltab2x4(:,:,378))
  call Hloop_A_Q(ntryL,G1H2(104),23,nMT,G2H2(264),n2h2(142))
  call Hloop_ZA_Q(ntryL,G1H4(43),ex2(:),G1H2(110),ngZu,m3h2x2(:,379),heltab2x4(:,:,379))
  call Hloop_A_Q(ntryL,G1H2(110),23,nMT,G2H2(269),n2h2(143))
  call Hloop_ZA_Q(ntryL,G1H4(379),ex2(:),G1H2(116),ngZu,m3h2x2(:,380),heltab2x4(:,:,380))
  call Hloop_A_Q(ntryL,G1H2(116),23,nMT,G2H2(272),n2h2(144))
  call Hloop_WA_Q(ntryL,G1H4(49),ex2(:),G1H2(142),m3h2x2(:,381),heltab2x4(:,:,381))
  call Hloop_A_Q(ntryL,G1H2(142),23,nMB,G2H2(277),n2h2(145))
  call Hloop_WA_Q(ntryL,G1H4(381),ex2(:),G1H2(153),m3h2x2(:,382),heltab2x4(:,:,382))
  call Hloop_A_Q(ntryL,G1H2(153),23,nMB,G2H2(280),n2h2(146))
  call Hloop_QV_A(ntryL,G1H4(77),ex3(:),G1H2(164),m3h2x2(:,383),heltab2x4(:,:,383))
  call Hloop_Q_A(ntryL,G1H2(164),23,nMT,G2H2(293),n2h2(147))
  call Hotf_4pt_reduction(G2H4(18),RedSet_4(15),mass4set(:,13),  & 
G1H4(27),G1H4(81),G1H4(67),G1H4(87),G1H4(356),G0H4(45),4)
  call HG1shiftOLR(G1H4(81),8,4)
  call Hloop_QV_A(ntryL,G1H4(84),ex3(:),G1H2(175),m3h2x2(:,384),heltab2x4(:,:,384))
  call Hloop_Q_A(ntryL,G1H2(175),23,nMT,G2H2(296),n2h2(148))
  call Hotf_4pt_reduction(G2H4(22),RedSet_4(15),mass4set(:,14),  & 
G1H4(372),G1H4(29),G1H4(63),G1H4(30),G1H4(64),G0H4(31),4)
  call HG1shiftOLR(G1H4(29),8,4)
  call Hloop_SV_T(ntryL,G1H4(82),19,ex3(:),4,G2H2(1),m3h2x2(:,385),heltab2x4(:,:,385))
  call Hotf_4pt_reduction(G2H4(25),RedSet_4(15),mass4set(:,15),  & 
G1H4(31),G1H4(135),G1H4(151),G1H4(141),G1H4(388),G0H4(29),4)
  call HG1shiftOLR(G1H4(135),8,4)
  call Hloop_QV_A(ntryL,G1H4(83),ex3(:),G1H2(186),m3h2x2(:,386),heltab2x4(:,:,386))
  call Hloop_Q_A(ntryL,G1H2(186),23,nMT,G2H2(2),n2h2(149))
  call Hloop_SV_T(ntryL,G1H4(88),19,ex3(:),4,G2H2(3),m3h2x2(:,387),heltab2x4(:,:,387))
  call Hotf_4pt_reduction(G2H4(7),RedSet_4(15),mass4set(:,15),  & 
G1H4(404),G1H4(3),G1H4(10),G1H4(308),G1H4(16),4)
  call HG1shiftOLR(G1H4(3),8,4)
  call Hloop_UW_V(ntryL,G1H4(129),19,ex3(:),4,G2H2(4),m3h2x2(:,388),heltab2x4(:,:,388))
  call Hotf_4pt_reduction(G2H4(12),RedSet_4(15),mass4set(:,15),  & 
G1H4(38),G1H4(44),G1H4(314),G1H4(50),G1H4(55),4)
  call HG1shiftOLR(G1H4(44),8,4)
  call Hloop_UW_V(ntryL,G1H4(130),19,ex3(:),4,G2H2(140),m3h2x2(:,389),heltab2x4(:,:,389))
  call Hotf_4pt_reduction(G2H4(223),RedSet_4(15),mass4set(:,15),  & 
G1H4(80),G1H4(62),G1H4(56),G1H4(78),G1H4(61),G0H4(21),4)
  call HG1shiftOLR(G1H4(62),8,4)
  call Hloop_SQ_A(ntryL,G1H4(103),ex1(:),G1H2(197),ngH,m3h2x2(:,390),heltab2x4(:,:,390))
  call Hloop_Q_A(ntryL,G1H2(197),23,nMT,G2H2(129),n2h2(150))
  call Hloop_SQ_A(ntryL,G1H4(397),ex1(:),G1H2(208),ngH,m3h2x2(:,391),heltab2x4(:,:,391))
  call Hloop_Q_A(ntryL,G1H2(208),23,nMT,G2H2(143),n2h2(151))
  call Hloop_SQ_A(ntryL,G1H4(109),ex1(:),G1H2(219),ngX,m3h2x2(:,392),heltab2x4(:,:,392))
  call Hloop_Q_A(ntryL,G1H2(219),23,nMT,G2H2(137),n2h2(152))
  call Hloop_SQ_A(ntryL,G1H4(400),ex1(:),G1H2(230),ngX,m3h2x2(:,393),heltab2x4(:,:,393))
  call Hloop_Q_A(ntryL,G1H2(230),23,nMT,G2H2(9),n2h2(153))
  call Hloop_SQ_A(ntryL,G1H4(115),ex1(:),G1H2(241),ngPbt,m3h2x2(:,394),heltab2x4(:,:,394))
  call Hloop_Q_A(ntryL,G1H2(241),23,nMB,G2H2(10),n2h2(154))
  call Hloop_SQ_A(ntryL,G1H4(401),ex1(:),G1H2(252),ngPbt,m3h2x2(:,395),heltab2x4(:,:,395))
  call Hloop_Q_A(ntryL,G1H2(252),23,nMB,G2H2(11),n2h2(155))
  call Hloop_VQ_A(ntryL,G1H4(121),ex1(:),G1H2(263),m3h2x2(:,396),heltab2x4(:,:,396))
  call Hloop_Q_A(ntryL,G1H2(263),23,nMT,G2H2(12),n2h2(156))
  call Hloop_VQ_A(ntryL,G1H4(407),ex1(:),G1H2(274),m3h2x2(:,397),heltab2x4(:,:,397))
  call Hloop_Q_A(ntryL,G1H2(274),23,nMT,G2H2(194),n2h2(157))
  call Hloop_ZQ_A(ntryL,G1H4(127),ex1(:),G1H2(285),ngZu,m3h2x2(:,398),heltab2x4(:,:,398))
  call Hloop_Q_A(ntryL,G1H2(285),23,nMT,G2H2(183),n2h2(158))
  call Hloop_ZQ_A(ntryL,G1H4(412),ex1(:),G1H2(296),ngZu,m3h2x2(:,399),heltab2x4(:,:,399))
  call Hloop_Q_A(ntryL,G1H2(296),23,nMT,G2H2(197),n2h2(159))
  call Hloop_WQ_A(ntryL,G1H4(133),ex1(:),G1H2(312),m3h2x2(:,400),heltab2x4(:,:,400))
  call Hloop_Q_A(ntryL,G1H2(312),23,nMB,G2H2(191),n2h2(160))
  call Hloop_WQ_A(ntryL,G1H4(408),ex1(:),G1H2(328),m3h2x2(:,401),heltab2x4(:,:,401))
  call Hloop_Q_A(ntryL,G1H2(328),23,nMB,G2H2(224),n2h2(161))
  call Hloop_QV_A(ntryL,G1H4(131),ex4(:),G1H2(339),m3h2x2(:,402),heltab2x4(:,:,402))
  call Hloop_Q_A(ntryL,G1H2(339),27,nMT,G2H2(213),n2h2(162))
  call Hotf_4pt_reduction(G2H4(140),RedSet_4(22),mass4set(:,13),  & 
G1H4(68),G1H4(73),G1H4(261),G1H4(257),G1H4(245),G0H4(27),4)
  call HG1shiftOLR(G1H4(73),4,4)
  call Hloop_QV_A(ntryL,G1H4(138),ex4(:),G1H2(350),m3h2x2(:,403),heltab2x4(:,:,403))
  call Hloop_Q_A(ntryL,G1H2(350),27,nMT,G2H2(227),n2h2(163))
  call Hotf_4pt_reduction(G2H4(146),RedSet_4(22),mass4set(:,14),  & 
G1H4(74),G1H4(79),G1H4(85),G1H4(333),G1H4(329),G0H4(39),4)
  call HG1shiftOLR(G1H4(79),4,4)
  call Hloop_SV_T(ntryL,G1H4(136),19,ex4(:),8,G2H2(221),m3h2x2(:,404),heltab2x4(:,:,404))
  call Hotf_4pt_reduction(G2H4(155),RedSet_4(22),mass4set(:,15),  & 
G1H4(321),G1H4(317),G1H4(86),G1H4(91),G1H4(365),G0H4(37),4)
  call HG1shiftOLR(G1H4(317),4,4)
  call Hloop_QV_A(ntryL,G1H4(137),ex4(:),G1H2(361),m3h2x2(:,405),heltab2x4(:,:,405))
  call Hloop_Q_A(ntryL,G1H2(361),27,nMT,G2H2(254),n2h2(164))
  call Hloop_SV_T(ntryL,G1H4(142),19,ex4(:),8,G2H2(243),m3h2x2(:,406),heltab2x4(:,:,406))
  call Hotf_4pt_reduction(G2H4(88),RedSet_4(22),mass4set(:,15),  & 
G1H4(360),G1H4(351),G1H4(347),G1H4(92),G1H4(97),4)
  call HG1shiftOLR(G1H4(351),4,4)
  call Hloop_UW_V(ntryL,G1H4(149),19,ex4(:),8,G2H2(257),m3h2x2(:,407),heltab2x4(:,:,407))
  call Hotf_4pt_reduction(G2H4(92),RedSet_4(22),mass4set(:,15),  & 
G1H4(275),G1H4(273),G1H4(255),G1H4(98),G1H4(104),4)
  call HG1shiftOLR(G1H4(273),4,4)
  call Hloop_UW_V(ntryL,G1H4(150),19,ex4(:),8,G2H2(251),m3h2x2(:,408),heltab2x4(:,:,408))
  call Hotf_4pt_reduction(G2H4(168),RedSet_4(22),mass4set(:,15),  & 
G1H4(110),G1H4(284),G1H4(116),G1H4(122),G1H4(128),G0H4(12),4)
  call HG1shiftOLR(G1H4(284),4,4)
  call Hloop_AV_Q(ntryL,G1H4(405),ex3(:),G1H2(372),m3h2x2(:,409),heltab2x4(:,:,409))
  call Hloop_A_Q(ntryL,G1H2(372),23,nMT,G2H2(285),n2h2(165))
  call Hotf_4pt_reduction(G2H4(14),RedSet_4(15),mass4set(:,13),  & 
G1H4(290),G1H4(134),G1H4(139),G1H4(164),G1H4(146),G0H4(10),4)
  call HG1shiftOLR(G1H4(134),8,4)
  call Hloop_AV_Q(ntryL,G1H4(6),ex3(:),G1H2(383),m3h2x2(:,410),heltab2x4(:,:,410))
  call Hloop_A_Q(ntryL,G1H2(383),23,nMT,G2H2(289),n2h2(166))
  call Hloop_AV_Q(ntryL,G1H4(5),ex3(:),G1H2(394),m3h2x2(:,411),heltab2x4(:,:,411))
  call Hloop_A_Q(ntryL,G1H2(394),23,nMB,G2H2(301),n2h2(167))
  call Hotf_4pt_reduction(G2H4(20),RedSet_4(15),mass4set(:,14),  & 
G1H4(140),G1H4(132),G1H4(145),G1H4(152),G1H4(157),G0H4(2),4)
  call HG1shiftOLR(G1H4(132),8,4)
  call Hloop_TV_S(ntryL,G1H4(1),19,ex3(:),4,G2H2(305),m3h2x2(:,412),heltab2x4(:,:,412))
  call Hotf_4pt_reduction(G2H4(26),RedSet_4(15),mass4set(:,15),  & 
G1H4(112),G1H4(108),G1H4(96),G1H4(158),G1H4(163),G0H4(8),4)
  call HG1shiftOLR(G1H4(108),8,4)
  call Hloop_AV_Q(ntryL,G1H4(4),ex3(:),G1H2(410),m3h2x2(:,413),heltab2x4(:,:,413))
  call Hloop_A_Q(ntryL,G1H2(410),23,nMT,G2H2(30),n2h2(168))
  call Hloop_TV_S(ntryL,G1H4(8),19,ex3(:),4,G2H2(32),m3h2x2(:,414),heltab2x4(:,:,414))
  call Hotf_4pt_reduction(G2H4(8),RedSet_4(15),mass4set(:,15),  & 
G1H4(169),G1H4(190),G1H4(186),G1H4(178),G1H4(174),4)
  call HG1shiftOLR(G1H4(190),8,4)
  call Hloop_UV_W(ntryL,G1H4(15),19,ex3(:),4,G2H2(34),m3h2x2(:,415),heltab2x4(:,:,415))
  call Hotf_4pt_reduction(G2H4(13),RedSet_4(15),mass4set(:,15),  & 
G1H4(170),G1H4(175),G1H4(208),G1H4(204),G1H4(196),4)
  call HG1shiftOLR(G1H4(175),8,4)
  call Hloop_UV_W(ntryL,G1H4(34),19,ex3(:),4,G2H2(36),m3h2x2(:,416),heltab2x4(:,:,416))
  call Hotf_4pt_reduction(G2H4(224),RedSet_4(15),mass4set(:,15),  & 
G1H4(192),G1H4(176),G1H4(181),G1H4(126),G1H4(124),G0H4(20),4)
  call HG1shiftOLR(G1H4(176),8,4)
  call Hloop_AV_Q(ntryL,G1H4(35),ex4(:),G1H2(426),m3h2x2(:,417),heltab2x4(:,:,417))
  call Hloop_A_Q(ntryL,G1H2(426),27,nMT,G2H2(38),n2h2(169))
  call Hotf_4pt_reduction(G2H4(142),RedSet_4(22),mass4set(:,13),  & 
G1H4(106),G1H4(182),G1H4(187),G1H4(212),G1H4(194),G0H4(18),4)
  call HG1shiftOLR(G1H4(182),4,4)
  call Hloop_AV_Q(ntryL,G1H4(42),ex4(:),G1H2(437),m3h2x2(:,418),heltab2x4(:,:,418))
  call Hloop_A_Q(ntryL,G1H2(437),27,nMT,G2H2(40),n2h2(170))
  call Hloop_AV_Q(ntryL,G1H4(45),ex4(:),G1H2(448),m3h2x2(:,419),heltab2x4(:,:,419))
  call Hloop_A_Q(ntryL,G1H2(448),27,nMB,G2H2(42),n2h2(171))
  call Hotf_4pt_reduction(G2H4(150),RedSet_4(22),mass4set(:,14),  & 
G1H4(188),G1H4(406),G1H4(193),G1H4(33),G1H4(199),G0H4(32),4)
  call HG1shiftOLR(G1H4(406),4,4)
  call Hloop_TV_S(ntryL,G1H4(40),19,ex4(:),8,G2H2(44),m3h2x2(:,420),heltab2x4(:,:,420))
  call Hotf_4pt_reduction(G2H4(154),RedSet_4(22),mass4set(:,15),  & 
G1H4(200),G1H4(205),G1H4(262),G1H4(258),G1H4(246),G0H4(30),4)
  call HG1shiftOLR(G1H4(205),4,4)
  call Hloop_AV_Q(ntryL,G1H4(41),ex4(:),G1H2(464),m3h2x2(:,421),heltab2x4(:,:,421))
  call Hloop_A_Q(ntryL,G1H2(464),27,nMT,G2H2(45),n2h2(172))
  call Hloop_TV_S(ntryL,G1H4(46),19,ex4(:),8,G2H2(47),m3h2x2(:,422),heltab2x4(:,:,422))
  call Hotf_4pt_reduction(G2H4(87),RedSet_4(22),mass4set(:,15),  & 
G1H4(206),G1H4(211),G1H4(217),G1H4(334),G1H4(330),4)
  call HG1shiftOLR(G1H4(211),4,4)
  call Hloop_UV_W(ntryL,G1H4(71),19,ex4(:),8,G2H2(48),m3h2x2(:,423),heltab2x4(:,:,423))
  call Hotf_4pt_reduction(G2H4(90),RedSet_4(22),mass4set(:,15),  & 
G1H4(322),G1H4(318),G1H4(218),G1H4(223),G1H4(368),4)
  call HG1shiftOLR(G1H4(318),4,4)
  call Hloop_UV_W(ntryL,G1H4(72),19,ex4(:),8,G2H2(50),m3h2x2(:,424),heltab2x4(:,:,424))
  call Hotf_4pt_reduction(G2H4(165),RedSet_4(22),mass4set(:,15),  & 
G1H4(363),G1H4(352),G1H4(348),G1H4(224),G1H4(229),G0H4(22),4)
  call HG1shiftOLR(G1H4(352),4,4)
  call Hloop_SQ_A(ntryL,G1H4(75),ex1(:),G1H2(480),ngPbt,m3h2x2(:,425),heltab2x4(:,:,425))
  call Hloop_Q_A(ntryL,G1H2(480),23,nMB,G2H2(51),n2h2(173))
  call Hloop_WQ_A(ntryL,G1H4(76),ex1(:),G1H2(491),m3h2x2(:,426),heltab2x4(:,:,426))
  call Hloop_Q_A(ntryL,G1H2(491),23,nMB,G2H2(53),n2h2(174))
  call Hloop_SQ_A(ntryL,G1H4(295),ex1(:),G1H2(502),ngPbt,m3h2x2(:,427),heltab2x4(:,:,427))
  call Hloop_Q_A(ntryL,G1H2(502),27,nMB,G2H2(54),n2h2(175))
  call Hloop_SQ_A(ntryL,G1H4(296),ex1(:),G1H2(518),ngPbt,m3h2x2(:,428),heltab2x4(:,:,428))
  call Hloop_Q_A(ntryL,G1H2(518),27,nMB,G2H2(56),n2h2(176))
  call Hloop_WQ_A(ntryL,G1H4(301),ex1(:),G1H2(534),m3h2x2(:,429),heltab2x4(:,:,429))
  call Hloop_Q_A(ntryL,G1H2(534),27,nMB,G2H2(57),n2h2(177))
  call Hloop_WQ_A(ntryL,G1H4(302),ex1(:),G1H2(545),m3h2x2(:,430),heltab2x4(:,:,430))
  call Hloop_Q_A(ntryL,G1H2(545),27,nMB,G2H2(59),n2h2(178))
  call Hloop_SA_Q(ntryL,G1H4(389),ex2(:),G1H2(556),ngPtb,m3h2x2(:,431),heltab2x4(:,:,431))
  call Hloop_A_Q(ntryL,G1H2(556),23,nMB,G2H2(60),n2h2(179))
  call Hloop_WA_Q(ntryL,G1H4(390),ex2(:),G1H2(577),m3h2x2(:,432),heltab2x4(:,:,432))
  call Hloop_A_Q(ntryL,G1H2(577),23,nMB,G2H2(62),n2h2(180))
  call Hloop_SV_T(ntryL,G1H4(319),21,ex4(:),8,G2H2(63),m3h2x2(:,433),heltab2x4(:,:,433))
  call Hloop_SV_T(ntryL,G1H4(320),21,ex4(:),8,G2H2(65),m3h2x2(:,434),heltab2x4(:,:,434))
  call Hloop_UW_V(ntryL,G1H4(325),21,ex4(:),8,G2H2(66),m3h2x2(:,435),heltab2x4(:,:,435))
  call Hloop_UW_V(ntryL,G1H4(326),21,ex4(:),8,G2H2(68),m3h2x2(:,436),heltab2x4(:,:,436))
  call Hloop_SA_Q(ntryL,G1H4(331),ex2(:),G1H2(21),ngPtb,m3h2x2(:,437),heltab2x4(:,:,437))
  call Hloop_A_Q(ntryL,G1H2(21),27,nMB,G2H2(69),n2h2(181))
  call Hloop_SA_Q(ntryL,G1H4(332),ex2(:),G1H2(22),ngPtb,m3h2x2(:,438),heltab2x4(:,:,438))
  call Hloop_A_Q(ntryL,G1H2(22),27,nMB,G2H2(71),n2h2(182))
  call Hloop_WA_Q(ntryL,G1H4(337),ex2(:),G1H2(117),m3h2x2(:,439),heltab2x4(:,:,439))
  call Hloop_A_Q(ntryL,G1H2(117),27,nMB,G2H2(72),n2h2(183))
  call Hloop_WA_Q(ntryL,G1H4(338),ex2(:),G1H2(27),m3h2x2(:,440),heltab2x4(:,:,440))
  call Hloop_A_Q(ntryL,G1H2(27),27,nMB,G2H2(74),n2h2(184))
  call Hloop_SV_T(ntryL,G1H4(343),25,ex3(:),4,G2H2(75),m3h2x2(:,441),heltab2x4(:,:,441))
  call Hloop_SV_T(ntryL,G1H4(344),25,ex3(:),4,G2H2(77),m3h2x2(:,442),heltab2x4(:,:,442))
  call Hloop_UW_V(ntryL,G1H4(349),25,ex3(:),4,G2H2(78),m3h2x2(:,443),heltab2x4(:,:,443))
  call Hloop_UW_V(ntryL,G1H4(350),25,ex3(:),4,G2H2(80),m3h2x2(:,444),heltab2x4(:,:,444))
  call Hotf_4pt_reduction(G2H4(49),RedSet_4(41),mass4set(:,16),  & 
G1H4(276),G1H4(274),G1H4(256),G1H4(230),G1H4(235),4)
  call HG1shiftOLR(G1H4(274),2,4)
  call Hloop_QV_A(ntryL,G1H4(361),ex4(:),G1H2(28),m3h2x2(:,445),heltab2x4(:,:,445))
  call Hloop_Q_A(ntryL,G1H2(28),29,nMB,G2H2(81),n2h2(185))
  call Hloop_QV_A(ntryL,G1H4(362),ex4(:),G1H2(122),m3h2x2(:,446),heltab2x4(:,:,446))
  call Hloop_Q_A(ntryL,G1H2(122),29,nMB,G2H2(83),n2h2(186))
  call Hloop_QV_A(ntryL,G1H4(366),ex4(:),G1H2(33),m3h2x2(:,447),heltab2x4(:,:,447))
  call Hloop_Q_A(ntryL,G1H2(33),29,nMB,G2H2(84),n2h2(187))
  call Hloop_QV_A(ntryL,G1H4(367),ex4(:),G1H2(34),m3h2x2(:,448),heltab2x4(:,:,448))
  call Hloop_Q_A(ntryL,G1H2(34),29,nMB,G2H2(86),n2h2(188))
  call Hotf_4pt_reduction(G2H4(54),RedSet_4(41),mass4set(:,16),  & 
G1H4(260),G1H4(242),G1H4(236),G1H4(36),G1H4(241),4)
  call HG1shiftOLR(G1H4(242),2,4)
  call Hloop_QV_A(ntryL,G1H4(377),ex4(:),G1H2(302),m3h2x2(:,449),heltab2x4(:,:,449))
  call Hloop_Q_A(ntryL,G1H2(302),29,nMB,G2H2(87),n2h2(189))
  call Hloop_QV_A(ntryL,G1H4(378),ex4(:),G1H2(39),m3h2x2(:,450),heltab2x4(:,:,450))
  call Hloop_Q_A(ntryL,G1H2(39),29,nMB,G2H2(89),n2h2(190))
  call Hloop_QV_A(ntryL,G1H4(382),ex4(:),G1H2(40),m3h2x2(:,451),heltab2x4(:,:,451))
  call Hloop_Q_A(ntryL,G1H2(40),29,nMB,G2H2(90),n2h2(191))
  call Hloop_QV_A(ntryL,G1H4(383),ex4(:),G1H2(318),m3h2x2(:,452),heltab2x4(:,:,452))
  call Hloop_Q_A(ntryL,G1H2(318),29,nMB,G2H2(92),n2h2(192))
  call Hotf_4pt_reduction(G2H4(57),RedSet_4(44),mass4set(:,16),  & 
G1H4(39),G1H4(247),G1H4(248),G1H4(253),G1H4(111),4)
  call HG1shiftOLR(G1H4(247),2,4)
  call Hloop_QV_A(ntryL,G1H4(393),ex3(:),G1H2(45),m3h2x2(:,453),heltab2x4(:,:,453))
  call Hloop_Q_A(ntryL,G1H2(45),29,nMB,G2H2(93),n2h2(193))
  call Hloop_QV_A(ntryL,G1H4(394),ex3(:),G1H2(46),m3h2x2(:,454),heltab2x4(:,:,454))
  call Hloop_Q_A(ntryL,G1H2(46),29,nMB,G2H2(96),n2h2(194))
  call Hloop_QV_A(ntryL,G1H4(398),ex3(:),G1H2(127),m3h2x2(:,455),heltab2x4(:,:,455))
  call Hloop_Q_A(ntryL,G1H2(127),29,nMB,G2H2(109),n2h2(195))
  call Hloop_QV_A(ntryL,G1H4(399),ex3(:),G1H2(51),m3h2x2(:,456),heltab2x4(:,:,456))
  call Hloop_Q_A(ntryL,G1H2(51),29,nMB,G2H2(112),n2h2(196))
  call Hotf_4pt_reduction(G2H4(58),RedSet_4(44),mass4set(:,16),  & 
G1H4(107),G1H4(95),G1H4(254),G1H4(259),G1H4(265),4)
  call HG1shiftOLR(G1H4(95),2,4)
  call Hloop_QV_A(ntryL,G1H4(409),ex3(:),G1H2(52),m3h2x2(:,457),heltab2x4(:,:,457))
  call Hloop_Q_A(ntryL,G1H2(52),29,nMB,G2H2(113),n2h2(197))
  call Hloop_QV_A(ntryL,G1H4(410),ex3(:),G1H2(132),m3h2x2(:,458),heltab2x4(:,:,458))
  call Hloop_Q_A(ntryL,G1H2(132),29,nMB,G2H2(116),n2h2(198))
  call Hloop_QV_A(ntryL,G1H4(414),ex3(:),G1H2(57),m3h2x2(:,459),heltab2x4(:,:,459))
  call Hloop_Q_A(ntryL,G1H2(57),29,nMB,G2H2(105),n2h2(199))
  call Hloop_QV_A(ntryL,G1H4(415),ex3(:),G1H2(58),m3h2x2(:,460),heltab2x4(:,:,460))
  call Hloop_Q_A(ntryL,G1H2(58),29,nMB,G2H2(108),n2h2(200))
  call Hloop_QA_S(ntryL,G2H4(27),ex2(:),G2H2(117),ngPtb,m3h2x2(:,461),heltab2x4(:,:,461))
  call Hloop_QA_W(ntryL,G2H4(28),ex2(:),G2H2(120),m3h2x2(:,462),heltab2x4(:,:,462))
  call Hloop_QA_S(ntryL,G2H4(29),ex2(:),G2H2(121),ngPtb,m3h2x2(:,463),heltab2x4(:,:,463))
  call Hloop_QA_W(ntryL,G2H4(30),ex2(:),G2H2(124),m3h2x2(:,464),heltab2x4(:,:,464))
  call Hloop_AQ_S(ntryL,G2H4(120),ex1(:),G2H2(125),ngPbt,m3h2x2(:,465),heltab2x4(:,:,465))
  call Hloop_AQ_W(ntryL,G2H4(111),ex1(:),G2H2(128),m3h2x2(:,466),heltab2x4(:,:,466))
  call Hloop_AQ_S(ntryL,G2H4(124),ex1(:),G2H2(132),ngPbt,m3h2x2(:,467),heltab2x4(:,:,467))
  call Hloop_AQ_W(ntryL,G2H4(116),ex1(:),G2H2(133),m3h2x2(:,468),heltab2x4(:,:,468))
  call Hloop_AQ_S(ntryL,G2H4(35),ex1(:),G2H2(136),ngPbt,m3h2x2(:,469),heltab2x4(:,:,469))
  call Hloop_AQ_S(ntryL,G2H4(40),ex1(:),G2H2(139),ngPbt,m3h2x2(:,470),heltab2x4(:,:,470))
  call Hloop_AQ_W(ntryL,G2H4(41),ex1(:),G2H2(142),m3h2x2(:,471),heltab2x4(:,:,471))
  call Hloop_AQ_W(ntryL,G2H4(38),ex1(:),G2H2(146),m3h2x2(:,472),heltab2x4(:,:,472))
  call Hloop_AQ_S(ntryL,G2H4(39),ex1(:),G2H2(147),ngPbt,m3h2x2(:,473),heltab2x4(:,:,473))
  call Hloop_AQ_S(ntryL,G2H4(42),ex1(:),G2H2(150),ngPbt,m3h2x2(:,474),heltab2x4(:,:,474))
  call Hloop_AQ_W(ntryL,G2H4(43),ex1(:),G2H2(163),m3h2x2(:,475),heltab2x4(:,:,475))
  call Hloop_AQ_W(ntryL,G2H4(44),ex1(:),G2H2(166),m3h2x2(:,476),heltab2x4(:,:,476))
  call Hloop_QA_S(ntryL,G2H4(45),ex2(:),G2H2(167),ngPtb,m3h2x2(:,477),heltab2x4(:,:,477))
  call Hloop_QA_S(ntryL,G2H4(46),ex2(:),G2H2(170),ngPtb,m3h2x2(:,478),heltab2x4(:,:,478))
  call Hloop_QA_W(ntryL,G2H4(47),ex2(:),G2H2(159),m3h2x2(:,479),heltab2x4(:,:,479))
  call Hloop_QA_W(ntryL,G2H4(48),ex2(:),G2H2(162),m3h2x2(:,480),heltab2x4(:,:,480))
  call Hloop_QA_S(ntryL,G2H4(55),ex2(:),G2H2(171),ngPtb,m3h2x2(:,481),heltab2x4(:,:,481))
  call Hloop_QA_S(ntryL,G2H4(52),ex2(:),G2H2(174),ngPtb,m3h2x2(:,482),heltab2x4(:,:,482))
  call Hloop_QA_W(ntryL,G2H4(53),ex2(:),G2H2(175),m3h2x2(:,483),heltab2x4(:,:,483))
  call Hloop_QA_W(ntryL,G2H4(56),ex2(:),G2H2(178),m3h2x2(:,484),heltab2x4(:,:,484))
  call Hloop_AQ_S(ntryL,G1H4(47),ex1(:),G1H2(400),ngPbt,m3h2x2(:,485),heltab2x4(:,:,485))
  call Hloop_AQ_W(ntryL,G1H4(48),ex1(:),G1H2(63),m3h2x2(:,486),heltab2x4(:,:,486))
  call Hloop_AQ_S(ntryL,G1H4(51),ex1(:),G1H2(64),ngPbt,m3h2x2(:,487),heltab2x4(:,:,487))
  call Hloop_AQ_W(ntryL,G1H4(52),ex1(:),G1H2(416),m3h2x2(:,488),heltab2x4(:,:,488))
  call Hloop_QA_S(ntryL,G1H4(53),ex2(:),G1H2(69),ngPtb,m3h2x2(:,489),heltab2x4(:,:,489))
  call Hloop_QA_W(ntryL,G1H4(54),ex2(:),G1H2(70),m3h2x2(:,490),heltab2x4(:,:,490))
  call Hloop_QA_S(ntryL,G1H4(57),ex2(:),G1H2(454),ngPtb,m3h2x2(:,491),heltab2x4(:,:,491))
  call Hloop_QA_W(ntryL,G1H4(58),ex2(:),G1H2(75),m3h2x2(:,492),heltab2x4(:,:,492))
  call Hloop_QA_S(ntryL,G2H8(1),ex2(:),G2H4(167),ngPtb,m3h2x4(:,353),heltab2x8(:,:,353))
  call Hloop_QA_W(ntryL,G2H8(2),ex2(:),G2H4(95),m3h2x4(:,354),heltab2x8(:,:,354))
  call Hloop_AQ_S(ntryL,G2H8(3),ex1(:),G2H4(175),ngPbt,m3h2x4(:,355),heltab2x8(:,:,355))
  call Hloop_AQ_W(ntryL,G2H8(4),ex1(:),G2H4(99),m3h2x4(:,356),heltab2x8(:,:,356))
  call Hloop_SVV_S(ntryL,G1H8(92),ex4(:),ex3(:),G1H2(76),m4h2x2x2(:,1),heltab3x8(:,:,1))
  call Hloop_VWW_V(ntryL,G1H8(95),ex4(:),ex3(:),G1H2(470),m4h2x2x2(:,2),heltab3x8(:,:,2))
  call Hotf_4pt_reduction(G2H4(129),RedSet_4(22),mass4set(:,17),  & 
G1H4(189),G1H4(185),G1H4(177),G1H4(173),G1H4(266),G0H4(28),4)
  call HG1shiftOLR(G1H4(185),4,4)
  call Hotf_4pt_reduction(G2H4(132),RedSet_4(22),mass4set(:,18),  & 
G1H4(271),G1H4(207),G1H4(203),G1H4(195),G1H4(191),G0H4(40),4)
  call HG1shiftOLR(G1H4(207),4,4)
  call Hotf_4pt_reduction(G2H4(133),RedSet_4(22),mass4set(:,19),  & 
G1H4(272),G1H4(277),G1H4(125),G1H4(123),G1H4(105),G0H4(38),4)
  call HG1shiftOLR(G1H4(277),4,4)
  call Hotf_4pt_reduction(G2H4(134),RedSet_4(22),mass4set(:,17),  & 
G1H4(278),G1H4(283),G1H4(289),G1H4(307),G1H4(313),G0H4(11),4)
  call HG1shiftOLR(G1H4(283),4,4)
  call Hotf_4pt_reduction(G2H4(136),RedSet_4(22),mass4set(:,18),  & 
G1H4(355),G1H4(371),G1H4(387),G1H4(403),G1H4(101),G0H4(9),4)
  call HG1shiftOLR(G1H4(371),4,4)
  call Hotf_4pt_reduction(G2H4(137),RedSet_4(22),mass4set(:,19),  & 
G1H4(99),G1H4(102),G1H4(100),G1H4(183),G1H4(179),G0H4(1),4)
  call HG1shiftOLR(G1H4(102),4,4)
  call Hotf_4pt_reduction(G2H4(159),RedSet_4(22),mass4set(:,15),  & 
G1H4(171),G1H4(167),G1H4(184),G1H4(180),G1H4(172),G0H4(7),4)
  call HG1shiftOLR(G1H4(167),4,4)
  call Hotf_4pt_reduction(G2H4(160),RedSet_4(22),mass4set(:,15),  & 
G1H4(168),G1H4(119),G1H4(118),G1H4(113),G1H4(120),G0H4(19),4)
  call HG1shiftOLR(G1H4(119),4,4)
  call Hloop_VV_S(ntryL,G2H4(83),ex4(:),G2H2(179),m3h2x2(:,493),heltab2x4(:,:,493))
  call Hloop_VV_S(ntryL,G2H4(85),ex4(:),G2H2(182),m3h2x2(:,494),heltab2x4(:,:,494))
  call Hloop_SV_V(ntryL,G2H4(173),ex4(:),G2H2(186),m3h2x2(:,495),heltab2x4(:,:,495))
  call Hloop_VV_S(ntryL,G2H4(178),ex4(:),G2H2(187),m3h2x2(:,496),heltab2x4(:,:,496))
  call Hloop_SV_V(ntryL,G2H4(100),ex4(:),G2H2(190),m3h2x2(:,497),heltab2x4(:,:,497))
  call Hloop_SV_V(ntryL,G2H4(101),ex4(:),G2H2(193),m3h2x2(:,498),heltab2x4(:,:,498))
  call Hotf_4pt_reduction(G2H4(145),RedSet_4(22),mass4set(:,20),  & 
G1H4(117),G1H4(114),G1H4(213),G1H4(209),G1H4(201),G0H4(17),4)
  call HG1shiftOLR(G1H4(114),4,4)
  call Hotf_4pt_reduction(G2H4(147),RedSet_4(22),mass4set(:,20),  & 
G1H4(197),G1H4(214),G1H4(210),G1H4(202),G1H4(198),G0H4(43),4)
  call HG1shiftOLR(G1H4(214),4,4)
  call Hotf_4pt_reduction(G2H4(102),RedSet_4(15),mass4set(:,17),  & 
G1H4(251),G1H4(249),G1H4(252),G1H4(250),G1H4(339),G0H4(44),4)
  call HG1shiftOLR(G1H4(249),8,4)
  call Hotf_4pt_reduction(G2H4(93),RedSet_4(15),mass4set(:,18),  & 
G1H4(335),G1H4(327),G1H4(323),G1H4(340),G1H4(336),G0H4(41),4)
  call HG1shiftOLR(G1H4(327),8,4)
  call Hotf_4pt_reduction(G2H4(106),RedSet_4(15),mass4set(:,19),  & 
G1H4(328),G1H4(324),G1H4(269),G1H4(268),G1H4(263),G0H4(42),4)
  call HG1shiftOLR(G1H4(324),8,4)
  call Hotf_4pt_reduction(G2H4(98),RedSet_4(15),mass4set(:,17),  & 
G1H4(270),G1H4(267),G1H4(264),G1H4(359),G1H4(353),G0H4(3),4)
  call HG1shiftOLR(G1H4(267),8,4)
  call Hotf_4pt_reduction(G2H4(11),RedSet_4(15),mass4set(:,18),  & 
G1H4(345),G1H4(341),G1H4(364),G1H4(354),G1H4(346),G0H4(4),4)
  call HG1shiftOLR(G1H4(341),8,4)
  call Hotf_4pt_reduction(G2H4(16),RedSet_4(15),mass4set(:,19),  & 
G1H4(342),G1H4(17),G1H4(18),G1H4(19),G1H4(20),G0H4(16),4)
  call HG1shiftOLR(G1H4(17),8,4)
  call Hotf_4pt_reduction(G2H4(219),RedSet_4(15),mass4set(:,15),  & 
G1H4(28),G1H4(32),G1H4(2),G1H4(369),G1H4(7),G0H4(15),4)
  call HG1shiftOLR(G1H4(32),8,4)
  call Hotf_4pt_reduction(G2H4(220),RedSet_4(15),mass4set(:,15),  & 
G1H4(370),G1H4(13),G1H4(375),G1H4(37),G1H4(376),G0H4(14),4)
  call HG1shiftOLR(G1H4(13),8,4)
  call Hloop_VV_S(ntryL,G2H4(212),ex3(:),G2H2(196),m3h2x2(:,499),heltab2x4(:,:,499))
  call Hloop_VV_S(ntryL,G2H4(213),ex3(:),G2H2(200),m3h2x2(:,500),heltab2x4(:,:,500))
  call Hloop_SV_V(ntryL,G2H4(228),ex3(:),G2H2(201),m3h2x2(:,501),heltab2x4(:,:,501))
  call Hloop_VV_S(ntryL,G2H4(232),ex3(:),G2H2(204),m3h2x2(:,502),heltab2x4(:,:,502))
  call Hloop_SV_V(ntryL,G2H4(33),ex3(:),G2H2(205),m3h2x2(:,503),heltab2x4(:,:,503))
  call Hloop_SV_V(ntryL,G2H4(34),ex3(:),G2H2(208),m3h2x2(:,504),heltab2x4(:,:,504))
  call Hotf_4pt_reduction(G2H4(19),RedSet_4(15),mass4set(:,20),  & 
G1H4(43),G1H4(379),G1H4(49),G1H4(381),G1H4(77),G0H4(13),4)
  call HG1shiftOLR(G1H4(379),8,4)
  call Hotf_4pt_reduction(G2H4(21),RedSet_4(15),mass4set(:,20),  & 
G1H4(84),G1H4(82),G1H4(83),G1H4(88),G1H4(129),G0H4(5),4)
  call HG1shiftOLR(G1H4(82),8,4)
  call Hotf_4pt_reduction(G2H8(5),RedSet_4(12),mass4set(:,17),  & 
G1H8(100),G1H8(17),G1H8(72),G1H8(40),G1H8(73),G0H8(57),8)
  call HG1shiftOLR(G1H8(17),8,8)
  call Hotf_4pt_reduction(G2H8(6),RedSet_4(12),mass4set(:,18),  & 
G1H8(118),G1H8(119),G1H8(25),G1H8(32),G1H8(145),G0H8(21),8)
  call HG1shiftOLR(G1H8(119),8,8)
  call Hotf_4pt_reduction(G2H8(7),RedSet_4(12),mass4set(:,19),  & 
G1H8(146),G1H8(122),G1H8(123),G1H8(124),G1H8(1),G0H8(22),8)
  call HG1shiftOLR(G1H8(122),8,8)
  call Hotf_4pt_reduction(G2H8(8),RedSet_4(12),mass4set(:,17),  & 
G1H8(2),G1H8(6),G1H8(16),G1H8(15),G1H8(18),G0H8(23),8)
  call HG1shiftOLR(G1H8(6),8,8)
  call Hotf_4pt_reduction(G2H8(9),RedSet_4(12),mass4set(:,18),  & 
G1H8(20),G1H8(19),G1H8(22),G1H8(21),G1H8(23),G0H8(24),8)
  call HG1shiftOLR(G1H8(19),8,8)
  call Hotf_4pt_reduction(G2H8(10),RedSet_4(12),mass4set(:,19),  & 
G1H8(24),G1H8(28),G1H8(41),G1H8(44),G1H8(43),G0H8(25),8)
  call HG1shiftOLR(G1H8(28),8,8)
  call Hotf_4pt_reduction(G2H8(11),RedSet_4(12),mass4set(:,13),  & 
G1H8(52),G1H8(51),G1H8(56),G1H8(53),G1H8(54),G0H8(26),8)
  call HG1shiftOLR(G1H8(51),8,8)
  call Hotf_4pt_reduction(G2H8(14),RedSet_4(12),mass4set(:,13),  & 
G1H8(58),G1H8(57),G1H8(65),G1H8(69),G1H8(70),G0H8(27),8)
  call HG1shiftOLR(G1H8(57),8,8)
  call Hotf_4pt_reduction(G2H8(12),RedSet_4(12),mass4set(:,14),  & 
G1H8(67),G1H8(68),G1H8(71),G1H8(76),G1H8(80),G0H8(28),8)
  call HG1shiftOLR(G1H8(68),8,8)
  call Hotf_4pt_reduction(G2H8(13),RedSet_4(12),mass4set(:,14),  & 
G1H8(88),G1H8(87),G1H8(34),G1H8(33),G1H8(35),G0H8(29),8)
  call HG1shiftOLR(G1H8(87),8,8)
  call Hotf_4pt_reduction(G2H8(16),RedSet_4(12),mass4set(:,17),  & 
G1H8(36),G1H8(46),G1H8(47),G1H8(48),G1H8(49),G0H8(30),8)
  call HG1shiftOLR(G1H8(46),8,8)
  call Hotf_4pt_reduction(G2H8(17),RedSet_4(12),mass4set(:,18),  & 
G1H8(50),G1H8(60),G1H8(89),G1H8(61),G1H8(101),G0H8(31),8)
  call HG1shiftOLR(G1H8(60),8,8)
  call Hotf_4pt_reduction(G2H8(15),RedSet_4(12),mass4set(:,19),  & 
G1H8(103),G1H8(104),G1H8(105),G1H8(106),G1H8(107),G0H8(32),8)
  call HG1shiftOLR(G1H8(104),8,8)
  call Hotf_4pt_reduction(G2H8(18),RedSet_4(12),mass4set(:,17),  & 
G1H8(109),G1H8(152),G1H8(153),G1H8(154),G1H8(155),G0H8(33),8)
  call HG1shiftOLR(G1H8(152),8,8)
  call Hotf_4pt_reduction(G2H8(19),RedSet_4(12),mass4set(:,18),  & 
G1H8(157),G1H8(158),G1H8(159),G1H8(112),G1H8(160),G0H8(34),8)
  call HG1shiftOLR(G1H8(158),8,8)
  call Hotf_4pt_reduction(G2H8(20),RedSet_4(12),mass4set(:,19),  & 
G1H8(132),G1H8(126),G1H8(31),G1H8(59),G1H8(42),G0H8(35),8)
  call HG1shiftOLR(G1H8(126),8,8)
  call Hotf_4pt_reduction(G2H8(21),RedSet_4(12),mass4set(:,13),  & 
G1H8(45),G1H8(143),G1H8(121),G1H8(111),G1H8(113),G0H8(36),8)
  call HG1shiftOLR(G1H8(143),8,8)
  call Hotf_4pt_reduction(G2H8(22),RedSet_4(12),mass4set(:,13),  & 
G1H8(98),G1H8(110),G1H8(9),G1H8(8),G1H8(91),G0H8(37),8)
  call HG1shiftOLR(G1H8(110),8,8)
  call Hotf_4pt_reduction(G2H8(23),RedSet_4(12),mass4set(:,14),  & 
G1H8(127),G1H8(140),G1H8(142),G1H8(139),G1H8(141),G0H8(38),8)
  call HG1shiftOLR(G1H8(140),8,8)
  call Hotf_4pt_reduction(G2H8(24),RedSet_4(12),mass4set(:,14),  & 
G1H8(149),G1H8(147),G1H8(108),G1H8(77),G1H8(134),G0H8(39),8)
  call HG1shiftOLR(G1H8(147),8,8)
  call Hloop_SS_S(ntryL,G2H8(25),wf4(:,36),G2H2(209),m3h4x2(:,1),heltab2x8(:,:,357))
  call Hloop_SS_S(ntryL,G2H8(26),wf4(:,36),G2H2(212),m3h4x2(:,2),heltab2x8(:,:,358))
  call Hloop_SS_S(ntryL,G2H8(27),wf4(:,36),G2H2(216),m3h4x2(:,3),heltab2x8(:,:,359))
  call Hloop_SS_S(ntryL,G2H8(28),wf4(:,36),G2H2(217),m3h4x2(:,4),heltab2x8(:,:,360))
  call Hloop_SS_S(ntryL,G2H8(29),wf4(:,37),G2H2(220),m3h4x2(:,5),heltab2x8(:,:,361))
  call Hloop_SS_S(ntryL,G2H8(32),wf4(:,37),G2H2(223),m3h4x2(:,6),heltab2x8(:,:,362))
  call Hloop_VS_V(ntryL,G2H8(30),wf4(:,36),G2H2(226),m3h4x2(:,7),heltab2x8(:,:,363))
  call Hloop_VS_V(ntryL,G2H8(31),wf4(:,36),G2H2(230),m3h4x2(:,8),heltab2x8(:,:,364))
  call Hotf_4pt_reduction(G2H8(35),RedSet_4(12),mass4set(:,15),  & 
G1H8(144),G1H8(90),G1H8(138),G1H8(92),G1H8(95),8)
  call HG1shiftOLR(G1H8(90),8,8)
  call Hotf_4pt_reduction(G2H8(36),RedSet_4(12),mass4set(:,15),  & 
G1H8(176),G1H8(177),G1H8(178),G1H8(179),G1H8(180),8)
  call HG1shiftOLR(G1H8(177),8,8)
  call Hloop_SS_S(ntryL,G1H8(62),wf4(:,36),G1H2(81),m3h4x2(:,9),heltab2x8(:,:,365))
  call Hloop_VT_S(ntryL,G1H8(63),20,wf4(:,36),3,G2H2(231),m3h4x2(:,10),heltab2x8(:,:,366))
  call Hloop_VT_S(ntryL,G1H8(64),20,wf4(:,36),3,G2H2(234),m3h4x2(:,11),heltab2x8(:,:,367))
  call Hloop_VT_S(ntryL,G1H8(74),20,wf4(:,37),3,G2H2(235),m3h4x2(:,12),heltab2x8(:,:,368))
  call Hloop_VT_S(ntryL,G1H8(75),20,wf4(:,37),3,G2H2(238),m3h4x2(:,13),heltab2x8(:,:,369))
  call Hloop_ST_V(ntryL,G1H8(78),20,wf4(:,36),3,G2H2(239),m3h4x2(:,14),heltab2x8(:,:,370))
  call Hloop_ST_V(ntryL,G1H8(81),20,wf4(:,36),3,G2H2(242),m3h4x2(:,15),heltab2x8(:,:,371))
  call Hloop_ST_V(ntryL,G1H8(82),20,wf4(:,37),3,G2H2(246),m3h4x2(:,16),heltab2x8(:,:,372))
  call Hloop_ST_V(ntryL,G1H8(86),20,wf4(:,37),3,G2H2(247),m3h4x2(:,17),heltab2x8(:,:,373))
  call Hloop_VS_V(ntryL,G1H8(125),wf4(:,36),G1H2(82),m3h4x2(:,18),heltab2x8(:,:,374))
  call Hotf_4pt_reduction(G2H8(41),RedSet_4(12),mass4set(:,15),  & 
G1H8(62),G1H8(63),G1H8(64),G1H8(74),G1H8(75),8)
  call HG1shiftOLR(G1H8(63),8,8)
  call Hotf_4pt_reduction(G2H8(39),RedSet_4(12),mass4set(:,15),  & 
G1H8(78),G1H8(81),G1H8(82),G1H8(86),G1H8(125),8)
  call HG1shiftOLR(G1H8(81),8,8)
  call Hotf_4pt_reduction(G2H8(42),RedSet_4(12),mass4set(:,17),  & 
G1H8(181),G1H8(182),G1H8(183),G1H8(184),G1H8(185),G0H8(40),8)
  call HG1shiftOLR(G1H8(182),8,8)
  call Hotf_4pt_reduction(G2H8(43),RedSet_4(12),mass4set(:,18),  & 
G1H8(186),G1H8(187),G1H8(188),G1H8(189),G1H8(190),G0H8(41),8)
  call HG1shiftOLR(G1H8(187),8,8)
  call Hotf_4pt_reduction(G2H8(40),RedSet_4(12),mass4set(:,19),  & 
G1H8(191),G1H8(192),G1H8(193),G1H8(194),G1H8(195),G0H8(42),8)
  call HG1shiftOLR(G1H8(192),8,8)
  call Hotf_4pt_reduction(G2H8(44),RedSet_4(12),mass4set(:,17),  & 
G1H8(196),G1H8(197),G1H8(198),G1H8(199),G1H8(200),G0H8(43),8)
  call HG1shiftOLR(G1H8(197),8,8)
  call Hotf_4pt_reduction(G2H8(45),RedSet_4(12),mass4set(:,18),  & 
G1H8(201),G1H8(202),G1H8(203),G1H8(204),G1H8(205),G0H8(44),8)
  call HG1shiftOLR(G1H8(202),8,8)
  call Hotf_4pt_reduction(G2H8(49),RedSet_4(12),mass4set(:,19),  & 
G1H8(206),G1H8(207),G1H8(208),G1H8(209),G1H8(210),G0H8(45),8)
  call HG1shiftOLR(G1H8(207),8,8)
  call Hotf_4pt_reduction(G2H8(46),RedSet_4(12),mass4set(:,20),  & 
G1H8(211),G1H8(212),G1H8(213),G1H8(214),G1H8(215),G0H8(46),8)
  call HG1shiftOLR(G1H8(212),8,8)
  call Hotf_4pt_reduction(G2H8(47),RedSet_4(12),mass4set(:,13),  & 
G1H8(216),G1H8(217),G1H8(218),G1H8(219),G1H8(220),G0H8(47),8)
  call HG1shiftOLR(G1H8(217),8,8)
  call Hotf_4pt_reduction(G2H8(50),RedSet_4(12),mass4set(:,20),  & 
G1H8(221),G1H8(222),G1H8(223),G1H8(224),G1H8(225),G0H8(48),8)
  call HG1shiftOLR(G1H8(222),8,8)
  call Hotf_4pt_reduction(G2H8(51),RedSet_4(12),mass4set(:,13),  & 
G1H8(226),G1H8(227),G1H8(228),G1H8(229),G1H8(230),G0H8(49),8)
  call HG1shiftOLR(G1H8(227),8,8)
  call Hotf_4pt_reduction(G2H8(48),RedSet_4(12),mass4set(:,14),  & 
G1H8(231),G1H8(232),G1H8(233),G1H8(234),G1H8(235),G0H8(50),8)
  call HG1shiftOLR(G1H8(232),8,8)
  call Hotf_4pt_reduction(G2H8(52),RedSet_4(12),mass4set(:,14),  & 
G1H8(236),G1H8(237),G1H8(238),G1H8(239),G1H8(240),G0H8(51),8)
  call HG1shiftOLR(G1H8(237),8,8)
  call Hotf_4pt_reduction(G2H8(53),RedSet_4(12),mass4set(:,17),  & 
G1H8(241),G1H8(242),G1H8(243),G1H8(244),G1H8(245),G0H8(52),8)
  call HG1shiftOLR(G1H8(242),8,8)
  call Hotf_4pt_reduction(G2H8(55),RedSet_4(12),mass4set(:,18),  & 
G1H8(246),G1H8(247),G1H8(248),G1H8(249),G1H8(250),G0H8(18),8)
  call HG1shiftOLR(G1H8(247),8,8)
  call Hotf_4pt_reduction(G2H8(54),RedSet_4(12),mass4set(:,19),  & 
G1H8(251),G1H8(252),G1H8(253),G1H8(254),G1H8(255),G0H8(11),8)
  call HG1shiftOLR(G1H8(252),8,8)
  call Hotf_4pt_reduction(G2H8(56),RedSet_4(12),mass4set(:,17),  & 
G1H8(256),G1H8(257),G1H8(258),G1H8(259),G1H8(260),G0H8(1),8)
  call HG1shiftOLR(G1H8(257),8,8)
  call Hotf_4pt_reduction(G2H8(57),RedSet_4(12),mass4set(:,18),  & 
G1H8(261),G1H8(262),G1H8(263),G1H8(264),G1H8(265),G0H8(2),8)
  call HG1shiftOLR(G1H8(262),8,8)
  call Hotf_4pt_reduction(G2H8(59),RedSet_4(12),mass4set(:,19),  & 
G1H8(266),G1H8(267),G1H8(268),G1H8(269),G1H8(270),G0H8(14),8)
  call HG1shiftOLR(G1H8(267),8,8)
  call Hotf_4pt_reduction(G2H8(58),RedSet_4(12),mass4set(:,20),  & 
G1H8(271),G1H8(272),G1H8(273),G1H8(274),G1H8(275),G0H8(9),8)
  call HG1shiftOLR(G1H8(272),8,8)
  call Hotf_4pt_reduction(G2H8(60),RedSet_4(12),mass4set(:,13),  & 
G1H8(276),G1H8(277),G1H8(278),G1H8(279),G1H8(280),G0H8(12),8)
  call HG1shiftOLR(G1H8(277),8,8)
  call Hotf_4pt_reduction(G2H8(61),RedSet_4(12),mass4set(:,20),  & 
G1H8(281),G1H8(282),G1H8(283),G1H8(284),G1H8(285),G0H8(13),8)
  call HG1shiftOLR(G1H8(282),8,8)
  call Hotf_4pt_reduction(G2H8(63),RedSet_4(12),mass4set(:,13),  & 
G1H8(286),G1H8(287),G1H8(288),G1H8(289),G1H8(290),G0H8(3),8)
  call HG1shiftOLR(G1H8(287),8,8)
  call Hotf_4pt_reduction(G2H8(62),RedSet_4(12),mass4set(:,20),  & 
G1H8(291),G1H8(292),G1H8(293),G1H8(294),G1H8(295),G0H8(4),8)
  call HG1shiftOLR(G1H8(292),8,8)
  call Hotf_4pt_reduction(G2H8(64),RedSet_4(12),mass4set(:,14),  & 
G1H8(296),G1H8(297),G1H8(298),G1H8(299),G1H8(300),G0H8(5),8)
  call HG1shiftOLR(G1H8(297),8,8)
  call Hotf_4pt_reduction(G2H8(65),RedSet_4(12),mass4set(:,20),  & 
G1H8(301),G1H8(302),G1H8(303),G1H8(304),G1H8(305),G0H8(7),8)
  call HG1shiftOLR(G1H8(302),8,8)
  call Hotf_4pt_reduction(G2H8(66),RedSet_4(12),mass4set(:,14),  & 
G1H8(306),G1H8(307),G1H8(308),G1H8(309),G1H8(310),G0H8(20),8)
  call HG1shiftOLR(G1H8(307),8,8)
  call Hotf_4pt_reduction(G2H8(67),RedSet_4(12),mass4set(:,15),  & 
G1H8(311),G1H8(312),G1H8(313),G1H8(314),G1H8(315),G0H8(53),8)
  call HG1shiftOLR(G1H8(312),8,8)
  call Hotf_4pt_reduction(G2H8(69),RedSet_4(12),mass4set(:,15),  & 
G1H8(316),G1H8(317),G1H8(318),G1H8(319),G1H8(320),G0H8(15),8)
  call HG1shiftOLR(G1H8(317),8,8)
  call Hotf_4pt_reduction(G2H8(68),RedSet_4(12),mass4set(:,15),  & 
G1H8(321),G1H8(322),G1H8(323),G1H8(324),G1H8(325),G0H8(16),8)
  call HG1shiftOLR(G1H8(322),8,8)
  call Hotf_4pt_reduction(G2H8(70),RedSet_4(12),mass4set(:,15),  & 
G1H8(326),G1H8(327),G1H8(328),G1H8(329),G1H8(330),G0H8(10),8)
  call HG1shiftOLR(G1H8(327),8,8)
  call Hotf_4pt_reduction(G2H8(71),RedSet_4(12),mass4set(:,15),  & 
G1H8(331),G1H8(332),G1H8(333),G1H8(334),G1H8(335),G0H8(19),8)
  call HG1shiftOLR(G1H8(332),8,8)
  call Hotf_4pt_reduction(G2H8(72),RedSet_4(12),mass4set(:,15),  & 
G1H8(336),G1H8(337),G1H8(338),G1H8(339),G1H8(340),G0H8(6),8)
  call HG1shiftOLR(G1H8(337),8,8)
  call Hotf_4pt_reduction(G2H8(73),RedSet_4(12),mass4set(:,15),  & 
G1H8(341),G1H8(342),G1H8(343),G1H8(344),G1H8(345),G0H8(8),8)
  call HG1shiftOLR(G1H8(342),8,8)
  call Hotf_4pt_reduction(G2H8(74),RedSet_4(12),mass4set(:,15),  & 
G1H8(346),G1H8(347),G1H8(348),G1H8(349),G1H8(350),G0H8(17),8)
  call HG1shiftOLR(G1H8(347),8,8)
  call Hotf_4pt_reduction(G2H8(75),RedSet_4(12),mass4set(:,15),  & 
G1H8(351),G1H8(352),G1H8(353),G1H8(354),G1H8(355),G0H8(54),8)
  call HG1shiftOLR(G1H8(352),8,8)
  call Hotf_4pt_reduction(G2H8(76),RedSet_4(12),mass4set(:,15),  & 
G1H8(356),G1H8(357),G1H8(358),G1H8(359),G1H8(360),G0H8(55),8)
  call HG1shiftOLR(G1H8(357),8,8)
  call Hotf_4pt_reduction(G2H8(77),RedSet_4(12),mass4set(:,15),  & 
G1H8(361),G1H8(362),G1H8(363),G1H8(364),G1H8(365),G0H8(56),8)
  call HG1shiftOLR(G1H8(362),8,8)
  call Hotf_4pt_reduction(G2H8(78),RedSet_4(12),mass4set(:,15),  & 
G1H8(366),G1H8(367),G1H8(368),G1H8(369),G1H8(370),G0H8(58),8)
  call HG1shiftOLR(G1H8(367),8,8)
  call Hloop_SV_V(ntryL,G2H8(80),wf4(:,13),G2H2(250),m3h4x2(:,19),heltab2x8(:,:,375))
  call Hloop_SV_V(ntryL,G2H8(82),wf4(:,14),G2H2(253),m3h4x2(:,20),heltab2x8(:,:,376))
  call Hloop_TV_S(ntryL,G1H8(162),20,wf4(:,13),3,G2H2(256),m3h4x2(:,21),heltab2x8(:,:,377))
  call Hloop_SV_T(ntryL,G1H8(163),20,wf4(:,13),3,G2H2(260),m3h4x2(:,22),heltab2x8(:,:,378))
  call Hloop_TV_S(ntryL,G1H8(164),20,wf4(:,14),3,G2H2(265),m3h4x2(:,23),heltab2x8(:,:,379))
  call Hloop_SV_T(ntryL,G1H8(165),20,wf4(:,14),3,G2H2(268),m3h4x2(:,24),heltab2x8(:,:,380))
  call Hloop_VV_S(ntryL,G1H8(166),wf4(:,13),G1H2(508),m3h4x2(:,25),heltab2x8(:,:,381))
  call Hloop_VV_S(ntryL,G1H8(168),wf4(:,13),G1H2(87),m3h4x2(:,26),heltab2x8(:,:,382))
  call Hloop_VV_S(ntryL,G1H8(169),wf4(:,14),G1H2(88),m3h4x2(:,27),heltab2x8(:,:,383))
  call Hloop_VV_S(ntryL,G1H8(170),wf4(:,14),G1H2(524),m3h4x2(:,28),heltab2x8(:,:,384))
  call Hloop_SV_V(ntryL,G1H8(115),wf4(:,13),G1H2(93),m3h4x2(:,29),heltab2x8(:,:,385))
  call Hloop_SV_V(ntryL,G1H8(171),wf4(:,13),G1H2(94),m3h4x2(:,30),heltab2x8(:,:,386))
  call Hloop_SV_V(ntryL,G1H8(173),wf4(:,14),G1H2(562),m3h4x2(:,31),heltab2x8(:,:,387))
  call Hloop_SV_V(ntryL,G1H8(174),wf4(:,14),G1H2(99),m3h4x2(:,32),heltab2x8(:,:,388))
  call Hloop_UV_W(ntryL,G1H8(175),20,wf4(:,13),3,G2H2(273),m3h4x2(:,33),heltab2x8(:,:,389))
  call Hloop_UW_V(ntryL,G1H8(96),20,wf4(:,13),3,G2H2(276),m3h4x2(:,34),heltab2x8(:,:,390))
  call Hloop_UV_W(ntryL,G1H8(114),20,wf4(:,14),3,G2H2(281),m3h4x2(:,35),heltab2x8(:,:,391))
  call Hloop_UW_V(ntryL,G1H8(7),20,wf4(:,14),3,G2H2(284),m3h4x2(:,36),heltab2x8(:,:,392))
  call Hloop_VV_S(ntryL,G2H8(84),wf4(:,13),G2H2(288),m3h4x2(:,37),heltab2x8(:,:,393))
  call Hloop_VV_S(ntryL,G2H8(86),wf4(:,14),G2H2(292),m3h4x2(:,38),heltab2x8(:,:,394))
  call Hotf_4pt_reduction(G2H8(87),RedSet_4(7),mass4set(:,1),  & 
G1H8(162),G1H8(163),G1H8(164),G1H8(165),G1H8(166),8)
  call HG1shiftOLR(G1H8(163),5,8)
  call Hloop_TV_S(ntryL,G1H8(83),18,ex4(:),8,G2H4(171),m3h2x4(:,357),heltab2x8(:,:,395))
  call Hotf_4pt_reduction(G2H8(88),RedSet_4(7),mass4set(:,1),  & 
G1H8(168),G1H8(169),G1H8(170),G1H8(115),G1H8(171),8)
  call HG1shiftOLR(G1H8(169),5,8)
  call Hloop_SV_V(ntryL,G1H8(137),ex4(:),G1H4(130),m3h2x4(:,358),heltab2x8(:,:,396))
  call Hloop_VV_S(ntryL,G1H8(4),ex4(:),G1H4(103),m3h2x4(:,359),heltab2x8(:,:,397))
  call Hloop_UV_W(ntryL,G1H8(27),18,ex4(:),8,G2H4(103),m3h2x4(:,360),heltab2x8(:,:,398))
  call Hloop_SQ_A(ntryL,G1H8(39),wf4(:,3),G1H2(100),ngH,m3h4x2(:,39),heltab2x8(:,:,399))
  call Hloop_Q_A(ntryL,G1H2(100),23,nMT,G2H2(297),n2h2(201))
  call Hloop_SQ_A(ntryL,G1H8(55),wf4(:,3),G1H2(567),ngX,m3h4x2(:,40),heltab2x8(:,:,400))
  call Hloop_Q_A(ntryL,G1H2(567),23,nMT,G2H2(300),n2h2(202))
  call Hloop_SQ_A(ntryL,G1H8(66),wf4(:,3),G1H2(105),ngPbt,m3h4x2(:,41),heltab2x8(:,:,401))
  call Hloop_Q_A(ntryL,G1H2(105),23,nMB,G2H2(304),n2h2(203))
  call Hloop_AQ_S(ntryL,G2H8(89),wf4(:,3),G2H2(308),ngPbt,m3h4x2(:,42),heltab2x8(:,:,402))
  call Hloop_VQ_A(ntryL,G1H8(85),wf4(:,3),G1H2(106),m3h4x2(:,43),heltab2x8(:,:,403))
  call Hloop_Q_A(ntryL,G1H2(106),23,nMT,G2H2(309),n2h2(204))
  call Hloop_ZQ_A(ntryL,G1H8(38),wf4(:,3),G1H2(583),ngZu,m3h4x2(:,44),heltab2x8(:,:,404))
  call Hloop_Q_A(ntryL,G1H2(583),23,nMT,G2H2(311),n2h2(205))
  call Hloop_WQ_A(ntryL,G1H8(37),wf4(:,3),G1H2(111),m3h4x2(:,45),heltab2x8(:,:,405))
  call Hloop_Q_A(ntryL,G1H2(111),23,nMB,G2H2(314),n2h2(206))
  call Hloop_AQ_W(ntryL,G2H8(90),wf4(:,3),G2H2(316),m3h4x2(:,46),heltab2x8(:,:,406))
  call Hloop_AQ_S(ntryL,G2H8(91),wf4(:,3),G2H2(319),ngPbt,m3h4x2(:,47),heltab2x8(:,:,407))
  call Hloop_AQ_W(ntryL,G2H8(92),wf4(:,3),G2H2(321),m3h4x2(:,48),heltab2x8(:,:,408))
  call Hotf_4pt_reduction(G2H8(93),RedSet_4(3),mass4set(:,1),  & 
G1H8(173),G1H8(174),G1H8(175),G1H8(96),G1H8(114),8)
  call HG1shiftOLR(G1H8(174),6,8)
  call Hloop_SV_T(ntryL,G1H8(120),17,ex4(:),8,G2H4(180),m3h2x4(:,361),heltab2x8(:,:,409))
  call Hotf_4pt_reduction(G2H8(94),RedSet_4(3),mass4set(:,1),  & 
G1H8(7),G1H8(83),G1H8(137),G1H8(4),G1H8(27),8)
  call HG1shiftOLR(G1H8(83),6,8)
  call Hloop_SV_V(ntryL,G1H8(148),ex4(:),G1H4(397),m3h2x4(:,362),heltab2x8(:,:,410))
  call Hloop_VV_S(ntryL,G1H8(102),ex4(:),G1H4(109),m3h2x4(:,363),heltab2x8(:,:,411))
  call Hloop_UW_V(ntryL,G1H8(156),17,ex4(:),8,G2H4(108),m3h2x4(:,364),heltab2x8(:,:,412))
  call Hloop_SA_Q(ntryL,G1H8(161),wf4(:,10),G1H2(112),ngH,m3h4x2(:,49),heltab2x8(:,:,413))
  call Hloop_A_Q(ntryL,G1H2(112),23,nMT,G2H2(324),n2h2(207))
  call Hloop_SA_Q(ntryL,G1H8(167),wf4(:,10),G1H2(588),ngX,m3h4x2(:,50),heltab2x8(:,:,414))
  call Hloop_A_Q(ntryL,G1H2(588),23,nMT,G2H2(326),n2h2(208))
  call Hloop_SA_Q(ntryL,G1H8(172),wf4(:,10),G1H2(118),ngPtb,m3h4x2(:,51),heltab2x8(:,:,415))
  call Hloop_A_Q(ntryL,G1H2(118),23,nMB,G2H2(329),n2h2(209))
  call Hloop_QA_S(ntryL,G2H8(95),wf4(:,10),G2H2(330),ngPtb,m3h4x2(:,52),heltab2x8(:,:,416))
  call Hloop_VA_Q(ntryL,G1H8(79),wf4(:,10),G1H2(123),m3h4x2(:,53),heltab2x8(:,:,417))
  call Hloop_A_Q(ntryL,G1H2(123),23,nMT,G2H2(331),n2h2(210))
  call Hloop_ZA_Q(ntryL,G1H8(84),wf4(:,10),G1H2(128),ngZu,m3h4x2(:,54),heltab2x8(:,:,418))
  call Hloop_A_Q(ntryL,G1H2(128),23,nMT,G2H2(332),n2h2(211))
  call Hloop_WA_Q(ntryL,G1H8(93),wf4(:,10),G1H2(133),m3h4x2(:,55),heltab2x8(:,:,419))
  call Hloop_A_Q(ntryL,G1H2(133),23,nMB,G2H2(333),n2h2(212))
  call Hloop_QA_W(ntryL,G2H8(96),wf4(:,10),G2H2(334),m3h4x2(:,56),heltab2x8(:,:,420))
  call Hloop_QA_S(ntryL,G2H8(97),wf4(:,10),G2H2(335),ngPtb,m3h4x2(:,57),heltab2x8(:,:,421))
  call Hloop_QA_W(ntryL,G2H8(98),wf4(:,10),G2H2(336),m3h4x2(:,58),heltab2x8(:,:,422))
  call Hotf_4pt_reduction(G2H8(99),RedSet_4(6),mass4set(:,1),  & 
G1H8(39),G1H8(55),G1H8(66),G1H8(85),G1H8(38),8)
  call HG1shiftOLR(G1H8(55),9,8)
  call Hloop_TV_S(ntryL,G1H8(5),18,ex3(:),4,G2H4(131),m3h2x4(:,365),heltab2x8(:,:,423))
  call Hotf_4pt_reduction(G2H8(100),RedSet_4(6),mass4set(:,1),  & 
G1H8(37),G1H8(120),G1H8(148),G1H8(102),G1H8(156),8)
  call HG1shiftOLR(G1H8(120),9,8)
  call Hloop_SV_V(ntryL,G1H8(10),ex3(:),G1H4(400),m3h2x4(:,366),heltab2x8(:,:,424))
  call Hloop_VV_S(ntryL,G1H8(11),ex3(:),G1H4(115),m3h2x4(:,367),heltab2x8(:,:,425))
  call Hloop_UV_W(ntryL,G1H8(14),18,ex3(:),4,G2H4(113),m3h2x4(:,368),heltab2x8(:,:,426))
  call Hloop_QA_S(ntryL,G2H8(101),ex2(:),G2H4(139),ngH,m3h2x4(:,369),heltab2x8(:,:,427))
  call Hloop_QA_S(ntryL,G2H8(102),ex2(:),G2H4(117),ngX,m3h2x4(:,370),heltab2x8(:,:,428))
  call Hloop_QA_S(ntryL,G2H8(103),ex2(:),G2H4(135),ngPtb,m3h2x4(:,371),heltab2x8(:,:,429))
  call Hotf_4pt_reduction(G2H8(104),RedSet_4(5),mass4set(:,2),  & 
G1H8(161),G1H8(167),G1H8(172),G1H8(79),G1H8(84),8)
  call HG1shiftOLR(G1H8(167),9,8)
  call Hloop_QA_V(ntryL,G2H8(105),ex2(:),G2H4(121),m3h2x4(:,372),heltab2x8(:,:,430))
  call Hloop_QA_Z(ntryL,G2H8(106),ex2(:),G2H4(144),ngZu,m3h2x4(:,373),heltab2x8(:,:,431))
  call Hloop_QA_W(ntryL,G2H8(107),ex2(:),G2H4(126),m3h2x4(:,374),heltab2x8(:,:,432))
  call Hloop_SA_Q(ntryL,G1H8(128),ex2(:),G1H4(401),ngPtb,m3h2x4(:,375),heltab2x8(:,:,433))
  call Hloop_A_Q(ntryL,G1H4(401),22,nMB,G2H4(4),n2h4(385))
  call Hloop_WA_Q(ntryL,G1H8(129),ex2(:),G1H4(121),m3h2x4(:,376),heltab2x8(:,:,434))
  call Hloop_A_Q(ntryL,G1H4(121),22,nMB,G2H4(204),n2h4(386))
  call Hotf_4pt_reduction(G2H8(108),RedSet_4(5),mass4set(:,2),  & 
G1H8(93),G1H8(5),G1H8(10),G1H8(11),G1H8(14),8)
  call HG1shiftOLR(G1H8(5),9,8)
  call Hloop_SQ_A(ntryL,G1H8(130),wf4(:,9),G1H2(137),ngH,m3h4x2(:,59),heltab2x8(:,:,435))
  call Hloop_Q_A(ntryL,G1H2(137),27,nMT,G2H2(337),n2h2(213))
  call Hloop_SQ_A(ntryL,G1H8(131),wf4(:,9),G1H2(138),ngX,m3h4x2(:,60),heltab2x8(:,:,436))
  call Hloop_Q_A(ntryL,G1H2(138),27,nMT,G2H2(338),n2h2(214))
  call Hloop_SQ_A(ntryL,G1H8(133),wf4(:,9),G1H2(143),ngPbt,m3h4x2(:,61),heltab2x8(:,:,437))
  call Hloop_Q_A(ntryL,G1H2(143),27,nMB,G2H2(339),n2h2(215))
  call Hloop_AQ_S(ntryL,G2H8(109),wf4(:,9),G2H2(340),ngPbt,m3h4x2(:,62),heltab2x8(:,:,438))
  call Hloop_VQ_A(ntryL,G1H8(135),wf4(:,9),G1H2(144),m3h4x2(:,63),heltab2x8(:,:,439))
  call Hloop_Q_A(ntryL,G1H2(144),27,nMT,G2H2(341),n2h2(216))
  call Hloop_ZQ_A(ntryL,G1H8(94),wf4(:,9),G1H2(148),ngZu,m3h4x2(:,64),heltab2x8(:,:,440))
  call Hloop_Q_A(ntryL,G1H2(148),27,nMT,G2H2(342),n2h2(217))
  call Hloop_WQ_A(ntryL,G1H8(136),wf4(:,9),G1H2(149),m3h4x2(:,65),heltab2x8(:,:,441))
  call Hloop_Q_A(ntryL,G1H2(149),27,nMB,G2H2(343),n2h2(218))
  call Hloop_AQ_W(ntryL,G2H8(110),wf4(:,9),G2H2(344),m3h4x2(:,66),heltab2x8(:,:,442))
  call Hloop_AQ_S(ntryL,G2H8(111),wf4(:,9),G2H2(345),ngPbt,m3h4x2(:,67),heltab2x8(:,:,443))
  call Hloop_AQ_W(ntryL,G2H8(112),wf4(:,9),G2H2(346),m3h4x2(:,68),heltab2x8(:,:,444))
  call Hotf_4pt_reduction(G2H8(113),RedSet_4(2),mass4set(:,1),  & 
G1H8(128),G1H8(129),G1H8(130),G1H8(131),G1H8(133),8)
  call HG1shiftOLR(G1H8(129),10,8)
  call Hloop_SV_T(ntryL,G1H8(97),17,ex3(:),4,G2H4(190),m3h2x4(:,377),heltab2x8(:,:,445))
  call Hotf_4pt_reduction(G2H8(114),RedSet_4(2),mass4set(:,1),  & 
G1H8(135),G1H8(94),G1H8(136),G1H8(97),G1H8(371),8)
  call HG1shiftOLR(G1H8(94),10,8)
  call Hloop_SV_V(ntryL,G1H8(150),ex3(:),G1H4(407),m3h2x4(:,378),heltab2x8(:,:,446))
  call Hloop_VV_S(ntryL,G1H8(151),ex3(:),G1H4(127),m3h2x4(:,379),heltab2x8(:,:,447))
  call Hloop_UW_V(ntryL,G1H8(13),17,ex3(:),4,G2H4(6),m3h2x4(:,380),heltab2x8(:,:,448))
  call Hloop_AQ_S(ntryL,G2H8(115),ex1(:),G2H4(208),ngH,m3h2x4(:,381),heltab2x8(:,:,449))
  call Hloop_AQ_S(ntryL,G2H8(116),ex1(:),G2H4(194),ngX,m3h2x4(:,382),heltab2x8(:,:,450))
  call Hloop_AQ_S(ntryL,G2H8(117),ex1(:),G2H4(23),ngPbt,m3h2x4(:,383),heltab2x8(:,:,451))
  call Hotf_4pt_reduction(G2H8(118),RedSet_4(4),mass4set(:,2),  & 
G1H8(150),G1H8(151),G1H8(13),G1H8(372),G1H8(373),8)
  call HG1shiftOLR(G1H8(151),10,8)
  call Hloop_AQ_V(ntryL,G2H8(119),ex1(:),G2H4(215),m3h2x4(:,384),heltab2x8(:,:,452))
  call Hloop_AQ_Z(ntryL,G2H8(120),ex1(:),G2H4(9),ngZu,m3h2x4(:,385),heltab2x8(:,:,453))
  call Hloop_AQ_W(ntryL,G2H8(121),ex1(:),G2H4(221),m3h2x4(:,386),heltab2x8(:,:,454))
  call Hloop_SQ_A(ntryL,G1H8(99),ex1(:),G1H4(412),ngPbt,m3h2x4(:,387),heltab2x8(:,:,455))
  call Hloop_Q_A(ntryL,G1H4(412),21,nMB,G2H4(119),n2h4(387))
  call Hloop_WQ_A(ntryL,G1H8(117),ex1(:),G1H4(133),m3h2x4(:,388),heltab2x8(:,:,456))
  call Hloop_Q_A(ntryL,G1H4(133),21,nMB,G2H4(77),n2h4(388))
  call Hotf_4pt_reduction(G2H8(122),RedSet_4(4),mass4set(:,2),  & 
G1H8(99),G1H8(117),G1H8(374),G1H8(375),G1H8(376),8)
  call HG1shiftOLR(G1H8(117),10,8)
  call Hloop_SA_Q(ntryL,G1H8(116),wf4(:,4),G1H2(154),ngH,m3h4x2(:,69),heltab2x8(:,:,457))
  call Hloop_A_Q(ntryL,G1H2(154),27,nMT,G2H2(347),n2h2(219))
  call Hloop_SA_Q(ntryL,G1H8(3),wf4(:,4),G1H2(155),ngX,m3h4x2(:,70),heltab2x8(:,:,458))
  call Hloop_A_Q(ntryL,G1H2(155),27,nMT,G2H2(348),n2h2(220))
  call Hloop_SA_Q(ntryL,G1H8(12),wf4(:,4),G1H2(159),ngPtb,m3h4x2(:,71),heltab2x8(:,:,459))
  call Hloop_A_Q(ntryL,G1H2(159),27,nMB,G2H2(349),n2h2(221))
  call Hloop_QA_S(ntryL,G2H8(123),wf4(:,4),G2H2(350),ngPtb,m3h4x2(:,72),heltab2x8(:,:,460))
  call Hloop_VA_Q(ntryL,G1H8(26),wf4(:,4),G1H2(160),m3h4x2(:,73),heltab2x8(:,:,461))
  call Hloop_A_Q(ntryL,G1H2(160),27,nMT,G2H2(351),n2h2(222))
  call Hloop_ZA_Q(ntryL,G1H8(29),wf4(:,4),G1H2(165),ngZu,m3h4x2(:,74),heltab2x8(:,:,462))
  call Hloop_A_Q(ntryL,G1H2(165),27,nMT,G2H2(352),n2h2(223))
  call Hloop_WA_Q(ntryL,G1H8(30),wf4(:,4),G1H2(166),m3h4x2(:,75),heltab2x8(:,:,463))
  call Hloop_A_Q(ntryL,G1H2(166),27,nMB,G2H2(353),n2h2(224))
  call Hloop_QA_W(ntryL,G2H8(124),wf4(:,4),G2H2(354),m3h4x2(:,76),heltab2x8(:,:,464))
  call Hloop_QA_S(ntryL,G2H8(125),wf4(:,4),G2H2(355),ngPtb,m3h4x2(:,77),heltab2x8(:,:,465))
  call Hloop_QA_W(ntryL,G2H8(126),wf4(:,4),G2H2(356),m3h4x2(:,78),heltab2x8(:,:,466))
  call Hloop_SV_V(ntryL,G1H4(9),ex3(:),G1H2(170),m3h2x2(:,505),heltab2x4(:,:,505))
  call Hloop_VV_S(ntryL,G1H4(12),ex3(:),G1H2(171),m3h2x2(:,506),heltab2x4(:,:,506))
  call Hloop_SV_V(ntryL,G1H4(11),ex3(:),G1H2(176),m3h2x2(:,507),heltab2x4(:,:,507))
  call Hloop_VV_S(ntryL,G1H4(14),ex3(:),G1H2(177),m3h2x2(:,508),heltab2x4(:,:,508))
  call Hloop_SV_V(ntryL,G1H4(65),ex4(:),G1H2(181),m3h2x2(:,509),heltab2x4(:,:,509))
  call Hloop_VV_S(ntryL,G1H4(66),ex4(:),G1H2(182),m3h2x2(:,510),heltab2x4(:,:,510))
  call Hloop_SV_V(ntryL,G1H4(69),ex4(:),G1H2(187),m3h2x2(:,511),heltab2x4(:,:,511))
  call Hloop_VV_S(ntryL,G1H4(70),ex4(:),G1H2(188),m3h2x2(:,512),heltab2x4(:,:,512))
  call Hloop_SV_V(ntryL,G1H4(89),ex3(:),G1H2(192),m3h2x2(:,513),heltab2x4(:,:,513))
  call Hloop_VV_S(ntryL,G1H4(90),ex3(:),G1H2(193),m3h2x2(:,514),heltab2x4(:,:,514))
  call Hloop_SV_V(ntryL,G1H4(93),ex3(:),G1H2(198),m3h2x2(:,515),heltab2x4(:,:,515))
  call Hloop_VV_S(ntryL,G1H4(94),ex3(:),G1H2(199),m3h2x2(:,516),heltab2x4(:,:,516))
  call Hloop_SV_V(ntryL,G1H4(143),ex4(:),G1H2(203),m3h2x2(:,517),heltab2x4(:,:,517))
  call Hloop_VV_S(ntryL,G1H4(144),ex4(:),G1H2(204),m3h2x2(:,518),heltab2x4(:,:,518))
  call Hloop_SV_V(ntryL,G1H4(147),ex4(:),G1H2(209),m3h2x2(:,519),heltab2x4(:,:,519))
  call Hloop_VV_S(ntryL,G1H4(148),ex4(:),G1H2(210),m3h2x2(:,520),heltab2x4(:,:,520))
  call Hloop_SQ_A(ntryL,G1H4(153),ex1(:),G1H2(214),ngPbt,m3h2x2(:,521),heltab2x4(:,:,521))
  call Hloop_Q_A(ntryL,G1H2(214),29,nMB,G2H2(357),n2h2(225))
call HGT_OLR(G1H4(154),1,1,4)
call HGT_invQ_OLR(G1H4(154),2,5,4)
  call Hloop_SA_Q(ntryL,G1H4(154),ex2(:),G1H2(215),ngPtb,m3h2x2(:,522),heltab2x4(:,:,522))
  call Hloop_SQ_A(ntryL,G1H4(156),ex1(:),G1H2(220),ngPbt,m3h2x2(:,523),heltab2x4(:,:,523))
  call Hloop_Q_A(ntryL,G1H2(220),29,nMB,G2H2(358),n2h2(226))
  call Hloop_SQ_A(ntryL,G1H4(159),ex1(:),G1H2(221),ngPbt,m3h2x2(:,524),heltab2x4(:,:,524))
  call Hloop_Q_A(ntryL,G1H2(221),29,nMB,G2H2(359),n2h2(227))
  call Hloop_WQ_A(ntryL,G1H4(160),ex1(:),G1H2(225),m3h2x2(:,525),heltab2x4(:,:,525))
  call Hloop_Q_A(ntryL,G1H2(225),29,nMB,G2H2(360),n2h2(228))
call HGT_raise_alpha_OLR(G1H4(161),1,1,4)
call HGT_raise_alpha_invQ_OLR(G1H4(161),2,5,4)
  call Hloop_WA_Q(ntryL,G1H4(161),ex2(:),G1H2(226),m3h2x2(:,526),heltab2x4(:,:,526))
  call Hloop_WQ_A(ntryL,G1H4(165),ex1(:),G1H2(231),m3h2x2(:,527),heltab2x4(:,:,527))
  call Hloop_Q_A(ntryL,G1H2(231),29,nMB,G2H2(361),n2h2(229))
  call Hloop_WQ_A(ntryL,G1H4(166),ex1(:),G1H2(232),m3h2x2(:,528),heltab2x4(:,:,528))
  call Hloop_Q_A(ntryL,G1H2(232),29,nMB,G2H2(362),n2h2(230))
  call Hloop_SA_Q(ntryL,G1H4(215),ex2(:),G1H2(236),ngPtb,m3h2x2(:,529),heltab2x4(:,:,529))
  call Hloop_A_Q(ntryL,G1H2(236),30,nMB,G2H2(363),n2h2(231))
call HGT_OLR(G1H4(216),1,1,4)
call HGT_invQ_OLR(G1H4(216),2,5,4)
  call Hloop_SQ_A(ntryL,G1H4(216),ex1(:),G1H2(237),ngPbt,m3h2x2(:,530),heltab2x4(:,:,530))
  call Hloop_SA_Q(ntryL,G1H4(220),ex2(:),G1H2(242),ngPtb,m3h2x2(:,531),heltab2x4(:,:,531))
  call Hloop_A_Q(ntryL,G1H2(242),30,nMB,G2H2(364),n2h2(232))
  call Hloop_SA_Q(ntryL,G1H4(221),ex2(:),G1H2(243),ngPtb,m3h2x2(:,532),heltab2x4(:,:,532))
  call Hloop_A_Q(ntryL,G1H2(243),30,nMB,G2H2(365),n2h2(233))
  call Hloop_WA_Q(ntryL,G1H4(222),ex2(:),G1H2(247),m3h2x2(:,533),heltab2x4(:,:,533))
  call Hloop_A_Q(ntryL,G1H2(247),30,nMB,G2H2(366),n2h2(234))
call HGT_raise_alpha_OLR(G1H4(225),1,1,4)
call HGT_raise_alpha_invQ_OLR(G1H4(225),2,5,4)
  call Hloop_WQ_A(ntryL,G1H4(225),ex1(:),G1H2(248),m3h2x2(:,534),heltab2x4(:,:,534))
  call Hloop_WA_Q(ntryL,G1H4(227),ex2(:),G1H2(253),m3h2x2(:,535),heltab2x4(:,:,535))
  call Hloop_A_Q(ntryL,G1H2(253),30,nMB,G2H2(367),n2h2(235))
  call Hloop_WA_Q(ntryL,G1H4(228),ex2(:),G1H2(254),m3h2x2(:,536),heltab2x4(:,:,536))
  call Hloop_A_Q(ntryL,G1H2(254),30,nMB,G2H2(368),n2h2(236))
  call Hloop_AV_Q(ntryL,G1H4(231),ex3(:),G1H2(258),m3h2x2(:,537),heltab2x4(:,:,537))
  call Hloop_A_Q(ntryL,G1H2(258),30,nMB,G2H2(369),n2h2(237))
call HGT_OLR(G1H4(232),1,1,4)
call HGT_invQ_OLR(G1H4(232),2,5,4)
  call Hloop_SQ_A(ntryL,G1H4(232),ex1(:),G1H2(259),ngPbt,m3h2x2(:,538),heltab2x4(:,:,538))
  call Hloop_AV_Q(ntryL,G1H4(234),ex3(:),G1H2(264),m3h2x2(:,539),heltab2x4(:,:,539))
  call Hloop_A_Q(ntryL,G1H2(264),30,nMB,G2H2(370),n2h2(238))
  call Hloop_AV_Q(ntryL,G1H4(237),ex3(:),G1H2(265),m3h2x2(:,540),heltab2x4(:,:,540))
  call Hloop_A_Q(ntryL,G1H2(265),30,nMB,G2H2(371),n2h2(239))
  call Hloop_AV_Q(ntryL,G1H4(238),ex3(:),G1H2(269),m3h2x2(:,541),heltab2x4(:,:,541))
  call Hloop_A_Q(ntryL,G1H2(269),30,nMB,G2H2(372),n2h2(240))
call HGT_raise_alpha_OLR(G1H4(239),1,1,4)
call HGT_raise_alpha_invQ_OLR(G1H4(239),2,5,4)
  call Hloop_WQ_A(ntryL,G1H4(239),ex1(:),G1H2(270),m3h2x2(:,542),heltab2x4(:,:,542))
  call Hloop_AV_Q(ntryL,G1H4(243),ex3(:),G1H2(275),m3h2x2(:,543),heltab2x4(:,:,543))
  call Hloop_A_Q(ntryL,G1H2(275),30,nMB,G2H2(373),n2h2(241))
  call Hloop_AV_Q(ntryL,G1H4(244),ex3(:),G1H2(276),m3h2x2(:,544),heltab2x4(:,:,544))
  call Hloop_A_Q(ntryL,G1H2(276),30,nMB,G2H2(374),n2h2(242))
  call Hloop_AV_Q(ntryL,G1H4(279),ex4(:),G1H2(280),m3h2x2(:,545),heltab2x4(:,:,545))
  call Hloop_A_Q(ntryL,G1H2(280),30,nMB,G2H2(375),n2h2(243))
call HGT_OLR(G1H4(280),1,1,4)
call HGT_invQ_OLR(G1H4(280),2,5,4)
  call Hloop_SQ_A(ntryL,G1H4(280),ex1(:),G1H2(281),ngPbt,m3h2x2(:,546),heltab2x4(:,:,546))
  call Hloop_AV_Q(ntryL,G1H4(282),ex4(:),G1H2(286),m3h2x2(:,547),heltab2x4(:,:,547))
  call Hloop_A_Q(ntryL,G1H2(286),30,nMB,G2H2(376),n2h2(244))
  call Hloop_AV_Q(ntryL,G1H4(285),ex4(:),G1H2(287),m3h2x2(:,548),heltab2x4(:,:,548))
  call Hloop_A_Q(ntryL,G1H2(287),30,nMB,G2H2(377),n2h2(245))
  call Hloop_AV_Q(ntryL,G1H4(286),ex4(:),G1H2(291),m3h2x2(:,549),heltab2x4(:,:,549))
  call Hloop_A_Q(ntryL,G1H2(291),30,nMB,G2H2(378),n2h2(246))
call HGT_raise_alpha_OLR(G1H4(287),1,1,4)
call HGT_raise_alpha_invQ_OLR(G1H4(287),2,5,4)
  call Hloop_WQ_A(ntryL,G1H4(287),ex1(:),G1H2(292),m3h2x2(:,550),heltab2x4(:,:,550))
  call Hloop_AV_Q(ntryL,G1H4(291),ex4(:),G1H2(297),m3h2x2(:,551),heltab2x4(:,:,551))
  call Hloop_A_Q(ntryL,G1H2(297),30,nMB,G2H2(379),n2h2(247))
  call Hloop_AV_Q(ntryL,G1H4(292),ex4(:),G1H2(298),m3h2x2(:,552),heltab2x4(:,:,552))
  call Hloop_A_Q(ntryL,G1H2(298),30,nMB,G2H2(380),n2h2(248))
  call Hloop_QV_A(ntryL,G1H4(293),ex3(:),G1H2(303),m3h2x2(:,553),heltab2x4(:,:,553))
  call Hloop_Q_A(ntryL,G1H2(303),29,nMB,G2H2(381),n2h2(249))
call HGT_OLR(G1H4(294),1,1,4)
call HGT_invQ_OLR(G1H4(294),2,5,4)
  call Hloop_SA_Q(ntryL,G1H4(294),ex2(:),G1H2(307),ngPtb,m3h2x2(:,554),heltab2x4(:,:,554))
  call Hloop_QV_A(ntryL,G1H4(298),ex3(:),G1H2(308),m3h2x2(:,555),heltab2x4(:,:,555))
  call Hloop_Q_A(ntryL,G1H2(308),29,nMB,G2H2(382),n2h2(250))
  call Hloop_QV_A(ntryL,G1H4(299),ex3(:),G1H2(313),m3h2x2(:,556),heltab2x4(:,:,556))
  call Hloop_Q_A(ntryL,G1H2(313),29,nMB,G2H2(383),n2h2(251))
  call Hloop_QV_A(ntryL,G1H4(300),ex3(:),G1H2(314),m3h2x2(:,557),heltab2x4(:,:,557))
  call Hloop_Q_A(ntryL,G1H2(314),29,nMB,G2H2(384),n2h2(252))
call HGT_raise_alpha_OLR(G1H4(303),1,1,4)
call HGT_raise_alpha_invQ_OLR(G1H4(303),2,5,4)
  call Hloop_WA_Q(ntryL,G1H4(303),ex2(:),G1H2(319),m3h2x2(:,558),heltab2x4(:,:,558))
  call Hloop_QV_A(ntryL,G1H4(305),ex3(:),G1H2(323),m3h2x2(:,559),heltab2x4(:,:,559))
  call Hloop_Q_A(ntryL,G1H2(323),29,nMB,G2H2(385),n2h2(253))
  call Hloop_QV_A(ntryL,G1H4(306),ex3(:),G1H2(324),m3h2x2(:,560),heltab2x4(:,:,560))
  call Hloop_Q_A(ntryL,G1H2(324),29,nMB,G2H2(386),n2h2(254))
  call Hloop_QV_A(ntryL,G1H4(309),ex4(:),G1H2(329),m3h2x2(:,561),heltab2x4(:,:,561))
  call Hloop_Q_A(ntryL,G1H2(329),29,nMB,G2H2(387),n2h2(255))
call HGT_OLR(G1H4(310),1,1,4)
call HGT_invQ_OLR(G1H4(310),2,5,4)
  call Hloop_SA_Q(ntryL,G1H4(310),ex2(:),G1H2(330),ngPtb,m3h2x2(:,562),heltab2x4(:,:,562))
  call Hloop_QV_A(ntryL,G1H4(312),ex4(:),G1H2(334),m3h2x2(:,563),heltab2x4(:,:,563))
  call Hloop_Q_A(ntryL,G1H2(334),29,nMB,G2H2(388),n2h2(256))
  call Hloop_QV_A(ntryL,G1H4(315),ex4(:),G1H2(335),m3h2x2(:,564),heltab2x4(:,:,564))
  call Hloop_Q_A(ntryL,G1H2(335),29,nMB,G2H2(389),n2h2(257))
  call Hloop_QV_A(ntryL,G1H4(316),ex4(:),G1H2(340),m3h2x2(:,565),heltab2x4(:,:,565))
  call Hloop_Q_A(ntryL,G1H2(340),29,nMB,G2H2(390),n2h2(258))
call HGT_raise_alpha_OLR(G1H4(380),1,1,4)
call HGT_raise_alpha_invQ_OLR(G1H4(380),2,5,4)
  call Hloop_WA_Q(ntryL,G1H4(380),ex2(:),G1H2(341),m3h2x2(:,566),heltab2x4(:,:,566))
  call Hloop_QV_A(ntryL,G1H4(391),ex4(:),G1H2(345),m3h2x2(:,567),heltab2x4(:,:,567))
  call Hloop_Q_A(ntryL,G1H2(345),29,nMB,G2H2(391),n2h2(259))
  call Hloop_QV_A(ntryL,G1H4(395),ex4(:),G1H2(346),m3h2x2(:,568),heltab2x4(:,:,568))
  call Hloop_Q_A(ntryL,G1H2(346),29,nMB,G2H2(392),n2h2(260))
  call Hloop_QV_A(ntryL,G1H4(402),ex4(:),G1H2(351),m3h2x2(:,569),heltab2x4(:,:,569))
  call Hloop_Q_A(ntryL,G1H2(351),29,nMB,G2H2(393),n2h2(261))
call HGT_OLR(G1H4(416),1,1,4)
call HGT_invQ_OLR(G1H4(416),2,5,4)
  call Hloop_SA_Q(ntryL,G1H4(416),ex2(:),G1H2(352),ngPtb,m3h2x2(:,570),heltab2x4(:,:,570))
  call Hloop_QV_A(ntryL,G1H4(374),ex4(:),G1H2(356),m3h2x2(:,571),heltab2x4(:,:,571))
  call Hloop_Q_A(ntryL,G1H2(356),29,nMB,G2H2(394),n2h2(262))
  call Hloop_QV_A(ntryL,G1H4(384),ex4(:),G1H2(357),m3h2x2(:,572),heltab2x4(:,:,572))
  call Hloop_Q_A(ntryL,G1H2(357),29,nMB,G2H2(395),n2h2(263))
  call Hloop_QV_A(ntryL,G1H4(396),ex4(:),G1H2(362),m3h2x2(:,573),heltab2x4(:,:,573))
  call Hloop_Q_A(ntryL,G1H2(362),29,nMB,G2H2(396),n2h2(264))
call HGT_raise_alpha_OLR(G1H4(385),1,1,4)
call HGT_raise_alpha_invQ_OLR(G1H4(385),2,5,4)
  call Hloop_WA_Q(ntryL,G1H4(385),ex2(:),G1H2(363),m3h2x2(:,574),heltab2x4(:,:,574))
  call Hloop_QV_A(ntryL,G1H4(411),ex4(:),G1H2(367),m3h2x2(:,575),heltab2x4(:,:,575))
  call Hloop_Q_A(ntryL,G1H2(367),29,nMB,G2H2(397),n2h2(265))
  call Hloop_QV_A(ntryL,G1H4(358),ex4(:),G1H2(368),m3h2x2(:,576),heltab2x4(:,:,576))
  call Hloop_Q_A(ntryL,G1H2(368),29,nMB,G2H2(398),n2h2(266))
  call Hloop_QV_A(ntryL,G1H4(413),ex3(:),G1H2(373),m3h2x2(:,577),heltab2x4(:,:,577))
  call Hloop_Q_A(ntryL,G1H2(373),29,nMB,G2H2(399),n2h2(267))
call HGT_OLR(G1H4(373),1,1,4)
call HGT_invQ_OLR(G1H4(373),2,5,4)
  call Hloop_SA_Q(ntryL,G1H4(373),ex2(:),G1H2(374),ngPtb,m3h2x2(:,578),heltab2x4(:,:,578))
  call Hloop_QV_A(ntryL,G1H4(22),ex3(:),G1H2(378),m3h2x2(:,579),heltab2x4(:,:,579))
  call Hloop_Q_A(ntryL,G1H2(378),29,nMB,G2H2(400),n2h2(268))
  call Hloop_QV_A(ntryL,G1H4(23),ex3(:),G1H2(379),m3h2x2(:,580),heltab2x4(:,:,580))
  call Hloop_Q_A(ntryL,G1H2(379),29,nMB,G2H2(401),n2h2(269))
  call Hloop_QV_A(ntryL,G1H4(24),ex3(:),G1H2(384),m3h2x2(:,581),heltab2x4(:,:,581))
  call Hloop_Q_A(ntryL,G1H2(384),29,nMB,G2H2(402),n2h2(270))
call HGT_raise_alpha_OLR(G1H4(25),1,1,4)
call HGT_raise_alpha_invQ_OLR(G1H4(25),2,5,4)
  call Hloop_WA_Q(ntryL,G1H4(25),ex2(:),G1H2(385),m3h2x2(:,582),heltab2x4(:,:,582))
  call Hloop_QV_A(ntryL,G1H4(26),ex3(:),G1H2(389),m3h2x2(:,583),heltab2x4(:,:,583))
  call Hloop_Q_A(ntryL,G1H2(389),29,nMB,G2H2(403),n2h2(271))
  call Hloop_QV_A(ntryL,G1H4(60),ex3(:),G1H2(390),m3h2x2(:,584),heltab2x4(:,:,584))
  call Hloop_Q_A(ntryL,G1H2(390),29,nMB,G2H2(404),n2h2(272))
  call Hloop_QV_A(ntryL,G1H4(27),ex3(:),G1H2(395),m3h2x2(:,585),heltab2x4(:,:,585))
  call Hloop_Q_A(ntryL,G1H2(395),23,nMT,G2H2(405),n2h2(273))
call HGT_OLR(G1H4(81),1,1,4)
call HGT_invQ_OLR(G1H4(81),2,5,4)
  call Hloop_A_Q(ntryL,G1H4(81),-8,nMT,G2H4(69),n2h4(405))
  call Hloop_AV_Q(ntryL,G2H4(69),ex4(:),G2H2(406),m3h2x2(:,586),heltab2x4(:,:,586))
  call Hloop_QV_A(ntryL,G1H4(87),ex3(:),G1H2(396),m3h2x2(:,587),heltab2x4(:,:,587))
  call Hloop_Q_A(ntryL,G1H2(396),23,nMT,G2H2(407),n2h2(274))
  call Hloop_QV_A(ntryL,G1H4(356),ex3(:),G1H2(401),m3h2x2(:,588),heltab2x4(:,:,588))
  call Hloop_Q_A(ntryL,G1H2(401),23,nMT,G2H2(408),n2h2(275))
  call Hloop_QV_A(ntryL,G0H4(45),ex3(:),G0H2(1),m3h2x2(:,589),heltab2x4(:,:,589))
  call Hloop_Q_A(ntryL,G0H2(1),23,nMT,G1H2(405),n2h2(276))
  call Hloop_QV_A(ntryL,G1H4(372),ex3(:),G1H2(406),m3h2x2(:,590),heltab2x4(:,:,590))
  call Hloop_Q_A(ntryL,G1H2(406),23,nMB,G2H2(409),n2h2(277))
call HGT_OLR(G1H4(29),1,1,4)
call HGT_invQ_OLR(G1H4(29),2,5,4)
  call Hloop_A_Q(ntryL,G1H4(29),-8,nMB,G2H4(127),n2h4(406))
  call Hloop_AV_Q(ntryL,G2H4(127),ex4(:),G2H2(410),m3h2x2(:,591),heltab2x4(:,:,591))
  call Hloop_QV_A(ntryL,G1H4(30),ex3(:),G1H2(411),m3h2x2(:,592),heltab2x4(:,:,592))
  call Hloop_Q_A(ntryL,G1H2(411),23,nMB,G2H2(411),n2h2(278))
  call Hloop_QV_A(ntryL,G1H4(64),ex3(:),G1H2(412),m3h2x2(:,593),heltab2x4(:,:,593))
  call Hloop_Q_A(ntryL,G1H2(412),23,nMB,G2H2(412),n2h2(279))
  call Hloop_QV_A(ntryL,G0H4(31),ex3(:),G0H2(1),m3h2x2(:,594),heltab2x4(:,:,594))
  call Hloop_Q_A(ntryL,G0H2(1),23,nMB,G1H2(417),n2h2(280))
  call Hloop_SV_T(ntryL,G1H4(31),19,ex3(:),4,G2H2(413),m3h2x2(:,595),heltab2x4(:,:,595))
call HGT_OLR(G1H4(135),1,1,4)
call HGT_invQ_OLR(G1H4(135),2,5,4)
  call Hloop_TV_S(ntryL,G1H4(135),-8,ex4(:),8,G2H2(414),m3h2x2(:,596),heltab2x4(:,:,596))
  call Hloop_SV_T(ntryL,G1H4(141),19,ex3(:),4,G2H2(415),m3h2x2(:,597),heltab2x4(:,:,597))
  call Hloop_SV_T(ntryL,G1H4(388),19,ex3(:),4,G2H2(416),m3h2x2(:,598),heltab2x4(:,:,598))
  call Hloop_SV_T(ntryL,G0H4(29),19,ex3(:),4,G1H2(421),m3h2x2(:,599),heltab2x4(:,:,599))
  call Hloop_SV_T(ntryL,G1H4(404),19,ex3(:),4,G2H2(417),m3h2x2(:,600),heltab2x4(:,:,600))
call HGT_raise_alpha_OLR(G1H4(3),1,1,4)
call HGT_raise_alpha_invQ_OLR(G1H4(3),2,5,4)
  call Hloop_VV_S(ntryL,G1H4(3),ex4(:),G1H2(422),m3h2x2(:,601),heltab2x4(:,:,601))
  call Hloop_SV_T(ntryL,G1H4(308),19,ex3(:),4,G2H2(418),m3h2x2(:,602),heltab2x4(:,:,602))
  call Hloop_SV_T(ntryL,G1H4(16),19,ex3(:),4,G2H2(419),m3h2x2(:,603),heltab2x4(:,:,603))
  call Hloop_UW_V(ntryL,G1H4(38),19,ex3(:),4,G2H2(420),m3h2x2(:,604),heltab2x4(:,:,604))
call HGT_OLR(G1H4(44),1,1,4)
call HGT_invQ_OLR(G1H4(44),2,5,4)
  call Hloop_SV_V(ntryL,G1H4(44),ex4(:),G1H2(427),m3h2x2(:,605),heltab2x4(:,:,605))
  call Hloop_UW_V(ntryL,G1H4(50),19,ex3(:),4,G2H2(421),m3h2x2(:,606),heltab2x4(:,:,606))
  call Hloop_UW_V(ntryL,G1H4(55),19,ex3(:),4,G2H2(422),m3h2x2(:,607),heltab2x4(:,:,607))
  call Hloop_UW_V(ntryL,G1H4(80),19,ex3(:),4,G2H2(423),m3h2x2(:,608),heltab2x4(:,:,608))
call HGT_raise_alpha_OLR(G1H4(62),1,1,4)
call HGT_raise_alpha_invQ_OLR(G1H4(62),2,5,4)
  call Hloop_UV_W(ntryL,G1H4(62),-8,ex4(:),8,G2H2(424),m3h2x2(:,609),heltab2x4(:,:,609))
  call Hloop_UW_V(ntryL,G1H4(78),19,ex3(:),4,G2H2(425),m3h2x2(:,610),heltab2x4(:,:,610))
  call Hloop_UW_V(ntryL,G1H4(61),19,ex3(:),4,G2H2(426),m3h2x2(:,611),heltab2x4(:,:,611))
  call Hloop_UW_V(ntryL,G0H4(21),19,ex3(:),4,G1H2(428),m3h2x2(:,612),heltab2x4(:,:,612))
  call Hloop_QV_A(ntryL,G1H4(68),ex4(:),G1H2(432),m3h2x2(:,613),heltab2x4(:,:,613))
  call Hloop_Q_A(ntryL,G1H2(432),27,nMT,G2H2(427),n2h2(281))
call HGT_OLR(G1H4(73),1,1,4)
call HGT_invQ_OLR(G1H4(73),2,5,4)
  call Hloop_A_Q(ntryL,G1H4(73),-4,nMT,G2H4(79),n2h4(411))
  call Hloop_AV_Q(ntryL,G2H4(79),ex3(:),G2H2(428),m3h2x2(:,614),heltab2x4(:,:,614))
  call Hloop_QV_A(ntryL,G1H4(257),ex4(:),G1H2(433),m3h2x2(:,615),heltab2x4(:,:,615))
  call Hloop_Q_A(ntryL,G1H2(433),27,nMT,G2H2(429),n2h2(282))
  call Hloop_QV_A(ntryL,G1H4(245),ex4(:),G1H2(438),m3h2x2(:,616),heltab2x4(:,:,616))
  call Hloop_Q_A(ntryL,G1H2(438),27,nMT,G2H2(430),n2h2(283))
  call Hloop_QV_A(ntryL,G0H4(27),ex4(:),G0H2(1),m3h2x2(:,617),heltab2x4(:,:,617))
  call Hloop_Q_A(ntryL,G0H2(1),27,nMT,G1H2(439),n2h2(284))
  call Hloop_QV_A(ntryL,G1H4(74),ex4(:),G1H2(443),m3h2x2(:,618),heltab2x4(:,:,618))
  call Hloop_Q_A(ntryL,G1H2(443),27,nMB,G2H2(431),n2h2(285))
call HGT_OLR(G1H4(79),1,1,4)
call HGT_invQ_OLR(G1H4(79),2,5,4)
  call Hloop_A_Q(ntryL,G1H4(79),-4,nMB,G2H4(67),n2h4(412))
  call Hloop_AV_Q(ntryL,G2H4(67),ex3(:),G2H2(432),m3h2x2(:,619),heltab2x4(:,:,619))
  call Hloop_QV_A(ntryL,G1H4(333),ex4(:),G1H2(444),m3h2x2(:,620),heltab2x4(:,:,620))
  call Hloop_Q_A(ntryL,G1H2(444),27,nMB,G2H2(433),n2h2(286))
  call Hloop_QV_A(ntryL,G1H4(329),ex4(:),G1H2(449),m3h2x2(:,621),heltab2x4(:,:,621))
  call Hloop_Q_A(ntryL,G1H2(449),27,nMB,G2H2(434),n2h2(287))
  call Hloop_QV_A(ntryL,G0H4(39),ex4(:),G0H2(1),m3h2x2(:,622),heltab2x4(:,:,622))
  call Hloop_Q_A(ntryL,G0H2(1),27,nMB,G1H2(450),n2h2(288))
  call Hloop_SV_T(ntryL,G1H4(321),19,ex4(:),8,G2H2(435),m3h2x2(:,623),heltab2x4(:,:,623))
call HGT_OLR(G1H4(317),1,1,4)
call HGT_invQ_OLR(G1H4(317),2,5,4)
  call Hloop_TV_S(ntryL,G1H4(317),-4,ex3(:),4,G2H2(436),m3h2x2(:,624),heltab2x4(:,:,624))
  call Hloop_SV_T(ntryL,G1H4(91),19,ex4(:),8,G2H2(437),m3h2x2(:,625),heltab2x4(:,:,625))
  call Hloop_SV_T(ntryL,G1H4(365),19,ex4(:),8,G2H2(438),m3h2x2(:,626),heltab2x4(:,:,626))
  call Hloop_SV_T(ntryL,G0H4(37),19,ex4(:),8,G1H2(455),m3h2x2(:,627),heltab2x4(:,:,627))
  call Hloop_SV_T(ntryL,G1H4(360),19,ex4(:),8,G2H2(439),m3h2x2(:,628),heltab2x4(:,:,628))
call HGT_raise_alpha_OLR(G1H4(351),1,1,4)
call HGT_raise_alpha_invQ_OLR(G1H4(351),2,5,4)
  call Hloop_VV_S(ntryL,G1H4(351),ex3(:),G1H2(459),m3h2x2(:,629),heltab2x4(:,:,629))
  call Hloop_SV_T(ntryL,G1H4(92),19,ex4(:),8,G2H2(440),m3h2x2(:,630),heltab2x4(:,:,630))
  call Hloop_SV_T(ntryL,G1H4(97),19,ex4(:),8,G2H2(441),m3h2x2(:,631),heltab2x4(:,:,631))
  call Hloop_UW_V(ntryL,G1H4(275),19,ex4(:),8,G2H2(442),m3h2x2(:,632),heltab2x4(:,:,632))
call HGT_OLR(G1H4(273),1,1,4)
call HGT_invQ_OLR(G1H4(273),2,5,4)
  call Hloop_SV_V(ntryL,G1H4(273),ex3(:),G1H2(460),m3h2x2(:,633),heltab2x4(:,:,633))
  call Hloop_UW_V(ntryL,G1H4(98),19,ex4(:),8,G2H2(443),m3h2x2(:,634),heltab2x4(:,:,634))
  call Hloop_UW_V(ntryL,G1H4(104),19,ex4(:),8,G2H2(444),m3h2x2(:,635),heltab2x4(:,:,635))
  call Hloop_UW_V(ntryL,G1H4(110),19,ex4(:),8,G2H2(445),m3h2x2(:,636),heltab2x4(:,:,636))
call HGT_raise_alpha_OLR(G1H4(284),1,1,4)
call HGT_raise_alpha_invQ_OLR(G1H4(284),2,5,4)
  call Hloop_UV_W(ntryL,G1H4(284),-4,ex3(:),4,G2H2(446),m3h2x2(:,637),heltab2x4(:,:,637))
  call Hloop_UW_V(ntryL,G1H4(122),19,ex4(:),8,G2H2(447),m3h2x2(:,638),heltab2x4(:,:,638))
  call Hloop_UW_V(ntryL,G1H4(128),19,ex4(:),8,G2H2(448),m3h2x2(:,639),heltab2x4(:,:,639))
  call Hloop_UW_V(ntryL,G0H4(12),19,ex4(:),8,G1H2(465),m3h2x2(:,640),heltab2x4(:,:,640))
  call Hloop_AV_Q(ntryL,G1H4(290),ex3(:),G1H2(466),m3h2x2(:,641),heltab2x4(:,:,641))
  call Hloop_A_Q(ntryL,G1H2(466),23,nMT,G2H2(449),n2h2(289))
call HGT_OLR(G1H4(134),1,1,4)
call HGT_invQ_OLR(G1H4(134),2,5,4)
  call Hloop_Q_A(ntryL,G1H4(134),-8,nMT,G2H4(152),n2h4(417))
  call Hloop_QV_A(ntryL,G2H4(152),ex4(:),G2H2(450),m3h2x2(:,642),heltab2x4(:,:,642))
  call Hloop_AV_Q(ntryL,G1H4(164),ex3(:),G1H2(471),m3h2x2(:,643),heltab2x4(:,:,643))
  call Hloop_A_Q(ntryL,G1H2(471),23,nMT,G2H2(451),n2h2(290))
  call Hloop_AV_Q(ntryL,G1H4(146),ex3(:),G1H2(475),m3h2x2(:,644),heltab2x4(:,:,644))
  call Hloop_A_Q(ntryL,G1H2(475),23,nMT,G2H2(452),n2h2(291))
  call Hloop_AV_Q(ntryL,G0H4(10),ex3(:),G0H2(1),m3h2x2(:,645),heltab2x4(:,:,645))
  call Hloop_A_Q(ntryL,G0H2(1),23,nMT,G1H2(476),n2h2(292))
  call Hloop_AV_Q(ntryL,G1H4(140),ex3(:),G1H2(481),m3h2x2(:,646),heltab2x4(:,:,646))
  call Hloop_A_Q(ntryL,G1H2(481),23,nMB,G2H2(453),n2h2(293))
call HGT_OLR(G1H4(132),1,1,4)
call HGT_invQ_OLR(G1H4(132),2,5,4)
  call Hloop_Q_A(ntryL,G1H4(132),-8,nMB,G2H4(86),n2h4(418))
  call Hloop_QV_A(ntryL,G2H4(86),ex4(:),G2H2(454),m3h2x2(:,647),heltab2x4(:,:,647))
  call Hloop_AV_Q(ntryL,G1H4(152),ex3(:),G1H2(482),m3h2x2(:,648),heltab2x4(:,:,648))
  call Hloop_A_Q(ntryL,G1H2(482),23,nMB,G2H2(455),n2h2(294))
  call Hloop_AV_Q(ntryL,G1H4(157),ex3(:),G1H2(486),m3h2x2(:,649),heltab2x4(:,:,649))
  call Hloop_A_Q(ntryL,G1H2(486),23,nMB,G2H2(456),n2h2(295))
  call Hloop_AV_Q(ntryL,G0H4(2),ex3(:),G0H2(1),m3h2x2(:,650),heltab2x4(:,:,650))
  call Hloop_A_Q(ntryL,G0H2(1),23,nMB,G1H2(487),n2h2(296))
  call Hloop_TV_S(ntryL,G1H4(112),19,ex3(:),4,G2H2(457),m3h2x2(:,651),heltab2x4(:,:,651))
call HGT_OLR(G1H4(108),1,1,4)
call HGT_invQ_OLR(G1H4(108),2,5,4)
  call Hloop_SV_T(ntryL,G1H4(108),-8,ex4(:),8,G2H2(458),m3h2x2(:,652),heltab2x4(:,:,652))
  call Hloop_TV_S(ntryL,G1H4(158),19,ex3(:),4,G2H2(459),m3h2x2(:,653),heltab2x4(:,:,653))
  call Hloop_TV_S(ntryL,G1H4(163),19,ex3(:),4,G2H2(460),m3h2x2(:,654),heltab2x4(:,:,654))
  call Hloop_TV_S(ntryL,G0H4(8),19,ex3(:),4,G1H2(492),m3h2x2(:,655),heltab2x4(:,:,655))
  call Hloop_TV_S(ntryL,G1H4(169),19,ex3(:),4,G2H2(461),m3h2x2(:,656),heltab2x4(:,:,656))
call HGT_raise_alpha_OLR(G1H4(190),1,1,4)
call HGT_raise_alpha_invQ_OLR(G1H4(190),2,5,4)
  call Hloop_VV_S(ntryL,G1H4(190),ex4(:),G1H2(493),m3h2x2(:,657),heltab2x4(:,:,657))
  call Hloop_TV_S(ntryL,G1H4(178),19,ex3(:),4,G2H2(462),m3h2x2(:,658),heltab2x4(:,:,658))
  call Hloop_TV_S(ntryL,G1H4(174),19,ex3(:),4,G2H2(463),m3h2x2(:,659),heltab2x4(:,:,659))
  call Hloop_UV_W(ntryL,G1H4(170),19,ex3(:),4,G2H2(464),m3h2x2(:,660),heltab2x4(:,:,660))
call HGT_OLR(G1H4(175),1,1,4)
call HGT_invQ_OLR(G1H4(175),2,5,4)
  call Hloop_SV_V(ntryL,G1H4(175),ex4(:),G1H2(497),m3h2x2(:,661),heltab2x4(:,:,661))
  call Hloop_UV_W(ntryL,G1H4(204),19,ex3(:),4,G2H2(465),m3h2x2(:,662),heltab2x4(:,:,662))
  call Hloop_UV_W(ntryL,G1H4(196),19,ex3(:),4,G2H2(466),m3h2x2(:,663),heltab2x4(:,:,663))
  call Hloop_UV_W(ntryL,G1H4(192),19,ex3(:),4,G2H2(467),m3h2x2(:,664),heltab2x4(:,:,664))
call HGT_raise_alpha_OLR(G1H4(176),1,1,4)
call HGT_raise_alpha_invQ_OLR(G1H4(176),2,5,4)
  call Hloop_UW_V(ntryL,G1H4(176),-8,ex4(:),8,G2H2(468),m3h2x2(:,665),heltab2x4(:,:,665))
  call Hloop_UV_W(ntryL,G1H4(126),19,ex3(:),4,G2H2(469),m3h2x2(:,666),heltab2x4(:,:,666))
  call Hloop_UV_W(ntryL,G1H4(124),19,ex3(:),4,G2H2(470),m3h2x2(:,667),heltab2x4(:,:,667))
  call Hloop_UV_W(ntryL,G0H4(20),19,ex3(:),4,G1H2(498),m3h2x2(:,668),heltab2x4(:,:,668))
  call Hloop_AV_Q(ntryL,G1H4(106),ex4(:),G1H2(503),m3h2x2(:,669),heltab2x4(:,:,669))
  call Hloop_A_Q(ntryL,G1H2(503),27,nMT,G2H2(471),n2h2(297))
call HGT_OLR(G1H4(182),1,1,4)
call HGT_invQ_OLR(G1H4(182),2,5,4)
  call Hloop_Q_A(ntryL,G1H4(182),-4,nMT,G2H4(91),n2h4(423))
  call Hloop_QV_A(ntryL,G2H4(91),ex3(:),G2H2(472),m3h2x2(:,670),heltab2x4(:,:,670))
  call Hloop_AV_Q(ntryL,G1H4(212),ex4(:),G1H2(504),m3h2x2(:,671),heltab2x4(:,:,671))
  call Hloop_A_Q(ntryL,G1H2(504),27,nMT,G2H2(473),n2h2(298))
  call Hloop_AV_Q(ntryL,G1H4(194),ex4(:),G1H2(509),m3h2x2(:,672),heltab2x4(:,:,672))
  call Hloop_A_Q(ntryL,G1H2(509),27,nMT,G2H2(474),n2h2(299))
  call Hloop_AV_Q(ntryL,G0H4(18),ex4(:),G0H2(1),m3h2x2(:,673),heltab2x4(:,:,673))
  call Hloop_A_Q(ntryL,G0H2(1),27,nMT,G1H2(513),n2h2(300))
  call Hloop_AV_Q(ntryL,G1H4(188),ex4(:),G1H2(514),m3h2x2(:,674),heltab2x4(:,:,674))
  call Hloop_A_Q(ntryL,G1H2(514),27,nMB,G2H2(475),n2h2(301))
call HGT_OLR(G1H4(406),1,1,4)
call HGT_invQ_OLR(G1H4(406),2,5,4)
  call Hloop_Q_A(ntryL,G1H4(406),-4,nMB,G2H4(164),n2h4(424))
  call Hloop_QV_A(ntryL,G2H4(164),ex3(:),G2H2(476),m3h2x2(:,675),heltab2x4(:,:,675))
  call Hloop_AV_Q(ntryL,G1H4(33),ex4(:),G1H2(519),m3h2x2(:,676),heltab2x4(:,:,676))
  call Hloop_A_Q(ntryL,G1H2(519),27,nMB,G2H2(477),n2h2(302))
  call Hloop_AV_Q(ntryL,G1H4(199),ex4(:),G1H2(520),m3h2x2(:,677),heltab2x4(:,:,677))
  call Hloop_A_Q(ntryL,G1H2(520),27,nMB,G2H2(478),n2h2(303))
  call Hloop_AV_Q(ntryL,G0H4(32),ex4(:),G0H2(1),m3h2x2(:,678),heltab2x4(:,:,678))
  call Hloop_A_Q(ntryL,G0H2(1),27,nMB,G1H2(525),n2h2(304))
  call Hloop_TV_S(ntryL,G1H4(200),19,ex4(:),8,G2H2(479),m3h2x2(:,679),heltab2x4(:,:,679))
call HGT_OLR(G1H4(205),1,1,4)
call HGT_invQ_OLR(G1H4(205),2,5,4)
  call Hloop_SV_T(ntryL,G1H4(205),-4,ex3(:),4,G2H2(480),m3h2x2(:,680),heltab2x4(:,:,680))
  call Hloop_TV_S(ntryL,G1H4(258),19,ex4(:),8,G2H2(481),m3h2x2(:,681),heltab2x4(:,:,681))
  call Hloop_TV_S(ntryL,G1H4(246),19,ex4(:),8,G2H2(482),m3h2x2(:,682),heltab2x4(:,:,682))
  call Hloop_TV_S(ntryL,G0H4(30),19,ex4(:),8,G1H2(529),m3h2x2(:,683),heltab2x4(:,:,683))
  call Hloop_TV_S(ntryL,G1H4(206),19,ex4(:),8,G2H2(483),m3h2x2(:,684),heltab2x4(:,:,684))
call HGT_raise_alpha_OLR(G1H4(211),1,1,4)
call HGT_raise_alpha_invQ_OLR(G1H4(211),2,5,4)
  call Hloop_VV_S(ntryL,G1H4(211),ex3(:),G1H2(530),m3h2x2(:,685),heltab2x4(:,:,685))
  call Hloop_TV_S(ntryL,G1H4(334),19,ex4(:),8,G2H2(484),m3h2x2(:,686),heltab2x4(:,:,686))
  call Hloop_TV_S(ntryL,G1H4(330),19,ex4(:),8,G2H2(485),m3h2x2(:,687),heltab2x4(:,:,687))
  call Hloop_UV_W(ntryL,G1H4(322),19,ex4(:),8,G2H2(486),m3h2x2(:,688),heltab2x4(:,:,688))
call HGT_OLR(G1H4(318),1,1,4)
call HGT_invQ_OLR(G1H4(318),2,5,4)
  call Hloop_SV_V(ntryL,G1H4(318),ex3(:),G1H2(535),m3h2x2(:,689),heltab2x4(:,:,689))
  call Hloop_UV_W(ntryL,G1H4(223),19,ex4(:),8,G2H2(487),m3h2x2(:,690),heltab2x4(:,:,690))
  call Hloop_UV_W(ntryL,G1H4(368),19,ex4(:),8,G2H2(488),m3h2x2(:,691),heltab2x4(:,:,691))
  call Hloop_UV_W(ntryL,G1H4(363),19,ex4(:),8,G2H2(489),m3h2x2(:,692),heltab2x4(:,:,692))
call HGT_raise_alpha_OLR(G1H4(352),1,1,4)
call HGT_raise_alpha_invQ_OLR(G1H4(352),2,5,4)
  call Hloop_UW_V(ntryL,G1H4(352),-4,ex3(:),4,G2H2(490),m3h2x2(:,693),heltab2x4(:,:,693))
  call Hloop_UV_W(ntryL,G1H4(224),19,ex4(:),8,G2H2(491),m3h2x2(:,694),heltab2x4(:,:,694))
  call Hloop_UV_W(ntryL,G1H4(229),19,ex4(:),8,G2H2(492),m3h2x2(:,695),heltab2x4(:,:,695))
  call Hloop_UV_W(ntryL,G0H4(22),19,ex4(:),8,G1H2(536),m3h2x2(:,696),heltab2x4(:,:,696))
  call Hloop_QV_A(ntryL,G1H4(276),ex4(:),G1H2(540),m3h2x2(:,697),heltab2x4(:,:,697))
  call Hloop_Q_A(ntryL,G1H2(540),29,nMB,G2H2(493),n2h2(305))
call HGT_OLR(G1H4(274),1,1,4)
call HGT_invQ_OLR(G1H4(274),2,5,4)
  call Hloop_SA_Q(ntryL,G1H4(274),ex2(:),G1H2(541),ngPtb,m3h2x2(:,698),heltab2x4(:,:,698))
  call Hloop_QV_A(ntryL,G1H4(230),ex4(:),G1H2(546),m3h2x2(:,699),heltab2x4(:,:,699))
  call Hloop_Q_A(ntryL,G1H2(546),29,nMB,G2H2(494),n2h2(306))
  call Hloop_QV_A(ntryL,G1H4(235),ex4(:),G1H2(547),m3h2x2(:,700),heltab2x4(:,:,700))
  call Hloop_Q_A(ntryL,G1H2(547),29,nMB,G2H2(495),n2h2(307))
  call Hloop_QV_A(ntryL,G1H4(260),ex4(:),G1H2(551),m3h2x2(:,701),heltab2x4(:,:,701))
  call Hloop_Q_A(ntryL,G1H2(551),29,nMB,G2H2(496),n2h2(308))
call HGT_raise_alpha_OLR(G1H4(242),1,1,4)
call HGT_raise_alpha_invQ_OLR(G1H4(242),2,5,4)
  call Hloop_WA_Q(ntryL,G1H4(242),ex2(:),G1H2(552),m3h2x2(:,702),heltab2x4(:,:,702))
  call Hloop_QV_A(ntryL,G1H4(36),ex4(:),G1H2(557),m3h2x2(:,703),heltab2x4(:,:,703))
  call Hloop_Q_A(ntryL,G1H2(557),29,nMB,G2H2(497),n2h2(309))
  call Hloop_QV_A(ntryL,G1H4(241),ex4(:),G1H2(558),m3h2x2(:,704),heltab2x4(:,:,704))
  call Hloop_Q_A(ntryL,G1H2(558),29,nMB,G2H2(498),n2h2(310))
  call Hloop_QV_A(ntryL,G1H4(39),ex3(:),G1H2(563),m3h2x2(:,705),heltab2x4(:,:,705))
  call Hloop_Q_A(ntryL,G1H2(563),29,nMB,G2H2(499),n2h2(311))
call HGT_OLR(G1H4(247),1,1,4)
call HGT_invQ_OLR(G1H4(247),2,5,4)
  call Hloop_SA_Q(ntryL,G1H4(247),ex2(:),G1H2(568),ngPtb,m3h2x2(:,706),heltab2x4(:,:,706))
  call Hloop_QV_A(ntryL,G1H4(253),ex3(:),G1H2(572),m3h2x2(:,707),heltab2x4(:,:,707))
  call Hloop_Q_A(ntryL,G1H2(572),29,nMB,G2H2(500),n2h2(312))
  call Hloop_QV_A(ntryL,G1H4(111),ex3(:),G1H2(573),m3h2x2(:,708),heltab2x4(:,:,708))
  call Hloop_Q_A(ntryL,G1H2(573),29,nMB,G2H2(501),n2h2(313))
  call Hloop_QV_A(ntryL,G1H4(107),ex3(:),G1H2(578),m3h2x2(:,709),heltab2x4(:,:,709))
  call Hloop_Q_A(ntryL,G1H2(578),29,nMB,G2H2(502),n2h2(314))
call HGT_raise_alpha_OLR(G1H4(95),1,1,4)
call HGT_raise_alpha_invQ_OLR(G1H4(95),2,5,4)
  call Hloop_WA_Q(ntryL,G1H4(95),ex2(:),G1H2(579),m3h2x2(:,710),heltab2x4(:,:,710))
  call Hloop_QV_A(ntryL,G1H4(259),ex3(:),G1H2(584),m3h2x2(:,711),heltab2x4(:,:,711))
  call Hloop_Q_A(ntryL,G1H2(584),29,nMB,G2H2(503),n2h2(315))
  call Hloop_QV_A(ntryL,G1H4(265),ex3(:),G1H2(589),m3h2x2(:,712),heltab2x4(:,:,712))
  call Hloop_Q_A(ntryL,G1H2(589),29,nMB,G2H2(504),n2h2(316))
  call Hloop_QV_A(ntryL,G1H4(189),ex4(:),G1H2(26),m3h2x2(:,713),heltab2x4(:,:,713))
  call Hloop_Q_A(ntryL,G1H2(26),27,nME,G2H2(505),n2h2(317))
call HGT_OLR(G1H4(185),1,1,4)
call HGT_invQ_OLR(G1H4(185),2,5,4)
  call Hloop_A_Q(ntryL,G1H4(185),-4,nME,G2H4(2),n2h4(433))
  call Hloop_AV_Q(ntryL,G2H4(2),ex3(:),G2H2(506),m3h2x2(:,714),heltab2x4(:,:,714))
  call Hloop_QV_A(ntryL,G1H4(173),ex4(:),G1H2(32),m3h2x2(:,715),heltab2x4(:,:,715))
  call Hloop_Q_A(ntryL,G1H2(32),27,nME,G2H2(507),n2h2(318))
  call Hloop_QV_A(ntryL,G1H4(266),ex4(:),G1H2(38),m3h2x2(:,716),heltab2x4(:,:,716))
  call Hloop_Q_A(ntryL,G1H2(38),27,nME,G2H2(508),n2h2(319))
  call Hloop_QV_A(ntryL,G0H4(28),ex4(:),G0H2(1),m3h2x2(:,717),heltab2x4(:,:,717))
  call Hloop_Q_A(ntryL,G0H2(1),27,nME,G1H2(44),n2h2(320))
  call Hloop_QV_A(ntryL,G1H4(271),ex4(:),G1H2(50),m3h2x2(:,718),heltab2x4(:,:,718))
  call Hloop_Q_A(ntryL,G1H2(50),27,nMM,G2H2(509),n2h2(321))
call HGT_OLR(G1H4(207),1,1,4)
call HGT_invQ_OLR(G1H4(207),2,5,4)
  call Hloop_A_Q(ntryL,G1H4(207),-4,nMM,G2H4(203),n2h4(434))
  call Hloop_AV_Q(ntryL,G2H4(203),ex3(:),G2H2(510),m3h2x2(:,719),heltab2x4(:,:,719))
  call Hloop_QV_A(ntryL,G1H4(195),ex4(:),G1H2(56),m3h2x2(:,720),heltab2x4(:,:,720))
  call Hloop_Q_A(ntryL,G1H2(56),27,nMM,G2H2(511),n2h2(322))
  call Hloop_QV_A(ntryL,G1H4(191),ex4(:),G1H2(62),m3h2x2(:,721),heltab2x4(:,:,721))
  call Hloop_Q_A(ntryL,G1H2(62),27,nMM,G2H2(512),n2h2(323))
  call Hloop_QV_A(ntryL,G0H4(40),ex4(:),G0H2(1),m3h2x2(:,722),heltab2x4(:,:,722))
  call Hloop_Q_A(ntryL,G0H2(1),27,nMM,G1H2(68),n2h2(324))
  call Hloop_QV_A(ntryL,G1H4(272),ex4(:),G1H2(74),m3h2x2(:,723),heltab2x4(:,:,723))
  call Hloop_Q_A(ntryL,G1H2(74),27,nML,G2H2(513),n2h2(325))
call HGT_OLR(G1H4(277),1,1,4)
call HGT_invQ_OLR(G1H4(277),2,5,4)
  call Hloop_A_Q(ntryL,G1H4(277),-4,nML,G2H4(189),n2h4(435))
  call Hloop_AV_Q(ntryL,G2H4(189),ex3(:),G2H2(514),m3h2x2(:,724),heltab2x4(:,:,724))
  call Hloop_QV_A(ntryL,G1H4(123),ex4(:),G1H2(80),m3h2x2(:,725),heltab2x4(:,:,725))
  call Hloop_Q_A(ntryL,G1H2(80),27,nML,G2H2(515),n2h2(326))
  call Hloop_QV_A(ntryL,G1H4(105),ex4(:),G1H2(86),m3h2x2(:,726),heltab2x4(:,:,726))
  call Hloop_Q_A(ntryL,G1H2(86),27,nML,G2H2(516),n2h2(327))
  call Hloop_QV_A(ntryL,G0H4(38),ex4(:),G0H2(1),m3h2x2(:,727),heltab2x4(:,:,727))
  call Hloop_Q_A(ntryL,G0H2(1),27,nML,G1H2(92),n2h2(328))
  call Hloop_AV_Q(ntryL,G1H4(278),ex4(:),G1H2(98),m3h2x2(:,728),heltab2x4(:,:,728))
  call Hloop_A_Q(ntryL,G1H2(98),27,nME,G2H2(517),n2h2(329))
call HGT_OLR(G1H4(283),1,1,4)
call HGT_invQ_OLR(G1H4(283),2,5,4)
  call Hloop_Q_A(ntryL,G1H4(283),-4,nME,G2H4(5),n2h4(436))
  call Hloop_QV_A(ntryL,G2H4(5),ex3(:),G2H2(518),m3h2x2(:,729),heltab2x4(:,:,729))
  call Hloop_AV_Q(ntryL,G1H4(307),ex4(:),G1H2(104),m3h2x2(:,730),heltab2x4(:,:,730))
  call Hloop_A_Q(ntryL,G1H2(104),27,nME,G2H2(519),n2h2(330))
  call Hloop_AV_Q(ntryL,G1H4(313),ex4(:),G1H2(110),m3h2x2(:,731),heltab2x4(:,:,731))
  call Hloop_A_Q(ntryL,G1H2(110),27,nME,G2H2(520),n2h2(331))
  call Hloop_AV_Q(ntryL,G0H4(11),ex4(:),G0H2(1),m3h2x2(:,732),heltab2x4(:,:,732))
  call Hloop_A_Q(ntryL,G0H2(1),27,nME,G1H2(116),n2h2(332))
  call Hloop_AV_Q(ntryL,G1H4(355),ex4(:),G1H2(142),m3h2x2(:,733),heltab2x4(:,:,733))
  call Hloop_A_Q(ntryL,G1H2(142),27,nMM,G2H2(521),n2h2(333))
call HGT_OLR(G1H4(371),1,1,4)
call HGT_invQ_OLR(G1H4(371),2,5,4)
  call Hloop_Q_A(ntryL,G1H4(371),-4,nMM,G2H4(207),n2h4(437))
  call Hloop_QV_A(ntryL,G2H4(207),ex3(:),G2H2(522),m3h2x2(:,734),heltab2x4(:,:,734))
  call Hloop_AV_Q(ntryL,G1H4(403),ex4(:),G1H2(153),m3h2x2(:,735),heltab2x4(:,:,735))
  call Hloop_A_Q(ntryL,G1H2(153),27,nMM,G2H2(523),n2h2(334))
  call Hloop_AV_Q(ntryL,G1H4(101),ex4(:),G1H2(164),m3h2x2(:,736),heltab2x4(:,:,736))
  call Hloop_A_Q(ntryL,G1H2(164),27,nMM,G2H2(524),n2h2(335))
  call Hloop_AV_Q(ntryL,G0H4(9),ex4(:),G0H2(1),m3h2x2(:,737),heltab2x4(:,:,737))
  call Hloop_A_Q(ntryL,G0H2(1),27,nMM,G1H2(175),n2h2(336))
  call Hloop_AV_Q(ntryL,G1H4(99),ex4(:),G1H2(186),m3h2x2(:,738),heltab2x4(:,:,738))
  call Hloop_A_Q(ntryL,G1H2(186),27,nML,G2H2(525),n2h2(337))
call HGT_OLR(G1H4(102),1,1,4)
call HGT_invQ_OLR(G1H4(102),2,5,4)
  call Hloop_Q_A(ntryL,G1H4(102),-4,nML,G2H4(191),n2h4(438))
  call Hloop_QV_A(ntryL,G2H4(191),ex3(:),G2H2(526),m3h2x2(:,739),heltab2x4(:,:,739))
  call Hloop_AV_Q(ntryL,G1H4(183),ex4(:),G1H2(197),m3h2x2(:,740),heltab2x4(:,:,740))
  call Hloop_A_Q(ntryL,G1H2(197),27,nML,G2H2(527),n2h2(338))
  call Hloop_AV_Q(ntryL,G1H4(179),ex4(:),G1H2(208),m3h2x2(:,741),heltab2x4(:,:,741))
  call Hloop_A_Q(ntryL,G1H2(208),27,nML,G2H2(528),n2h2(339))
  call Hloop_AV_Q(ntryL,G0H4(1),ex4(:),G0H2(1),m3h2x2(:,742),heltab2x4(:,:,742))
  call Hloop_A_Q(ntryL,G0H2(1),27,nML,G1H2(219),n2h2(340))
  call Hloop_CV_D(ntryL,G1H4(171),19,ex4(:),8,G2H2(529),m3h2x2(:,743),heltab2x4(:,:,743))
call HGT_OLR(G1H4(167),1,1,4)
call HGT_invQ_OLR(G1H4(167),2,5,4)
  call Hloop_DV_C(ntryL,G1H4(167),-4,ex3(:),G2H2(530),m3h2x2(:,744),heltab2x4(:,:,744))
  call Hloop_CV_D(ntryL,G1H4(180),19,ex4(:),8,G2H2(531),m3h2x2(:,745),heltab2x4(:,:,745))
  call Hloop_CV_D(ntryL,G1H4(172),19,ex4(:),8,G2H2(532),m3h2x2(:,746),heltab2x4(:,:,746))
  call Hloop_CV_D(ntryL,G0H4(7),19,ex4(:),8,G1H2(230),m3h2x2(:,747),heltab2x4(:,:,747))
  call Hloop_DV_C(ntryL,G1H4(168),19,ex4(:),G2H2(533),m3h2x2(:,748),heltab2x4(:,:,748))
call HGT_OLR(G1H4(119),1,1,4)
call HGT_invQ_OLR(G1H4(119),2,5,4)
  call Hloop_CV_D(ntryL,G1H4(119),-4,ex3(:),4,G2H2(534),m3h2x2(:,749),heltab2x4(:,:,749))
  call Hloop_DV_C(ntryL,G1H4(113),19,ex4(:),G2H2(535),m3h2x2(:,750),heltab2x4(:,:,750))
  call Hloop_DV_C(ntryL,G1H4(120),19,ex4(:),G2H2(536),m3h2x2(:,751),heltab2x4(:,:,751))
  call Hloop_DV_C(ntryL,G0H4(19),19,ex4(:),G1H2(241),m3h2x2(:,752),heltab2x4(:,:,752))
  call Hloop_QV_A(ntryL,G1H4(117),ex4(:),G1H2(252),m3h2x2(:,753),heltab2x4(:,:,753))
  call Hloop_Q_A(ntryL,G1H2(252),27,0,G2H2(537),n2h2(341))
call HGT_OLR(G1H4(114),1,1,4)
call HGT_invQ_OLR(G1H4(114),2,5,4)
  call Hloop_A_Q(ntryL,G1H4(114),-4,0,G2H4(24),n2h4(441))
  call Hloop_AV_Q(ntryL,G2H4(24),ex3(:),G2H2(538),m3h2x2(:,754),heltab2x4(:,:,754))
  call Hloop_QV_A(ntryL,G1H4(209),ex4(:),G1H2(263),m3h2x2(:,755),heltab2x4(:,:,755))
  call Hloop_Q_A(ntryL,G1H2(263),27,0,G2H2(539),n2h2(342))
  call Hloop_QV_A(ntryL,G1H4(201),ex4(:),G1H2(274),m3h2x2(:,756),heltab2x4(:,:,756))
  call Hloop_Q_A(ntryL,G1H2(274),27,0,G2H2(540),n2h2(343))
  call Hloop_QV_A(ntryL,G0H4(17),ex4(:),G0H2(1),m3h2x2(:,757),heltab2x4(:,:,757))
  call Hloop_Q_A(ntryL,G0H2(1),27,0,G1H2(285),n2h2(344))
  call Hloop_AV_Q(ntryL,G1H4(197),ex4(:),G1H2(296),m3h2x2(:,758),heltab2x4(:,:,758))
  call Hloop_A_Q(ntryL,G1H2(296),27,0,G2H2(541),n2h2(345))
call HGT_OLR(G1H4(214),1,1,4)
call HGT_invQ_OLR(G1H4(214),2,5,4)
  call Hloop_Q_A(ntryL,G1H4(214),-4,0,G2H4(216),n2h4(442))
  call Hloop_QV_A(ntryL,G2H4(216),ex3(:),G2H2(542),m3h2x2(:,759),heltab2x4(:,:,759))
  call Hloop_AV_Q(ntryL,G1H4(202),ex4(:),G1H2(312),m3h2x2(:,760),heltab2x4(:,:,760))
  call Hloop_A_Q(ntryL,G1H2(312),27,0,G2H2(543),n2h2(346))
  call Hloop_AV_Q(ntryL,G1H4(198),ex4(:),G1H2(328),m3h2x2(:,761),heltab2x4(:,:,761))
  call Hloop_A_Q(ntryL,G1H2(328),27,0,G2H2(544),n2h2(347))
  call Hloop_AV_Q(ntryL,G0H4(43),ex4(:),G0H2(1),m3h2x2(:,762),heltab2x4(:,:,762))
  call Hloop_A_Q(ntryL,G0H2(1),27,0,G1H2(339),n2h2(348))
  call Hloop_AV_Q(ntryL,G1H4(251),ex3(:),G1H2(350),m3h2x2(:,763),heltab2x4(:,:,763))
  call Hloop_A_Q(ntryL,G1H2(350),23,nME,G2H2(545),n2h2(349))
call HGT_OLR(G1H4(249),1,1,4)
call HGT_invQ_OLR(G1H4(249),2,5,4)
  call Hloop_Q_A(ntryL,G1H4(249),-8,nME,G2H4(10),n2h4(443))
  call Hloop_QV_A(ntryL,G2H4(10),ex4(:),G2H2(546),m3h2x2(:,764),heltab2x4(:,:,764))
  call Hloop_AV_Q(ntryL,G1H4(250),ex3(:),G1H2(361),m3h2x2(:,765),heltab2x4(:,:,765))
  call Hloop_A_Q(ntryL,G1H2(361),23,nME,G2H2(547),n2h2(350))
  call Hloop_AV_Q(ntryL,G1H4(339),ex3(:),G1H2(372),m3h2x2(:,766),heltab2x4(:,:,766))
  call Hloop_A_Q(ntryL,G1H2(372),23,nME,G2H2(548),n2h2(351))
  call Hloop_AV_Q(ntryL,G0H4(44),ex3(:),G0H2(1),m3h2x2(:,767),heltab2x4(:,:,767))
  call Hloop_A_Q(ntryL,G0H2(1),23,nME,G1H2(383),n2h2(352))
  call Hloop_AV_Q(ntryL,G1H4(335),ex3(:),G1H2(394),m3h2x2(:,768),heltab2x4(:,:,768))
  call Hloop_A_Q(ntryL,G1H2(394),23,nMM,G2H2(549),n2h2(353))
call HGT_OLR(G1H4(327),1,1,4)
call HGT_invQ_OLR(G1H4(327),2,5,4)
  call Hloop_Q_A(ntryL,G1H4(327),-8,nMM,G2H4(222),n2h4(444))
  call Hloop_QV_A(ntryL,G2H4(222),ex4(:),G2H2(550),m3h2x2(:,769),heltab2x4(:,:,769))
  call Hloop_AV_Q(ntryL,G1H4(340),ex3(:),G1H2(410),m3h2x2(:,770),heltab2x4(:,:,770))
  call Hloop_A_Q(ntryL,G1H2(410),23,nMM,G2H2(551),n2h2(354))
  call Hloop_AV_Q(ntryL,G1H4(336),ex3(:),G1H2(426),m3h2x2(:,771),heltab2x4(:,:,771))
  call Hloop_A_Q(ntryL,G1H2(426),23,nMM,G2H2(552),n2h2(355))
  call Hloop_AV_Q(ntryL,G0H4(41),ex3(:),G0H2(1),m3h2x2(:,772),heltab2x4(:,:,772))
  call Hloop_A_Q(ntryL,G0H2(1),23,nMM,G1H2(437),n2h2(356))
  call Hloop_AV_Q(ntryL,G1H4(328),ex3(:),G1H2(448),m3h2x2(:,773),heltab2x4(:,:,773))
  call Hloop_A_Q(ntryL,G1H2(448),23,nML,G2H2(553),n2h2(357))
call HGT_OLR(G1H4(324),1,1,4)
call HGT_invQ_OLR(G1H4(324),2,5,4)
  call Hloop_Q_A(ntryL,G1H4(324),-8,nML,G2H4(123),n2h4(445))
  call Hloop_QV_A(ntryL,G2H4(123),ex4(:),G2H2(554),m3h2x2(:,774),heltab2x4(:,:,774))
  call Hloop_AV_Q(ntryL,G1H4(268),ex3(:),G1H2(464),m3h2x2(:,775),heltab2x4(:,:,775))
  call Hloop_A_Q(ntryL,G1H2(464),23,nML,G2H2(555),n2h2(358))
  call Hloop_AV_Q(ntryL,G1H4(263),ex3(:),G1H2(480),m3h2x2(:,776),heltab2x4(:,:,776))
  call Hloop_A_Q(ntryL,G1H2(480),23,nML,G2H2(556),n2h2(359))
  call Hloop_AV_Q(ntryL,G0H4(42),ex3(:),G0H2(1),m3h2x2(:,777),heltab2x4(:,:,777))
  call Hloop_A_Q(ntryL,G0H2(1),23,nML,G1H2(491),n2h2(360))
  call Hloop_QV_A(ntryL,G1H4(270),ex3(:),G1H2(502),m3h2x2(:,778),heltab2x4(:,:,778))
  call Hloop_Q_A(ntryL,G1H2(502),23,nME,G2H2(557),n2h2(361))
call HGT_OLR(G1H4(267),1,1,4)
call HGT_invQ_OLR(G1H4(267),2,5,4)
  call Hloop_A_Q(ntryL,G1H4(267),-8,nME,G2H4(78),n2h4(446))
  call Hloop_AV_Q(ntryL,G2H4(78),ex4(:),G2H2(558),m3h2x2(:,779),heltab2x4(:,:,779))
  call Hloop_QV_A(ntryL,G1H4(359),ex3(:),G1H2(518),m3h2x2(:,780),heltab2x4(:,:,780))
  call Hloop_Q_A(ntryL,G1H2(518),23,nME,G2H2(559),n2h2(362))
  call Hloop_QV_A(ntryL,G1H4(353),ex3(:),G1H2(534),m3h2x2(:,781),heltab2x4(:,:,781))
  call Hloop_Q_A(ntryL,G1H2(534),23,nME,G2H2(560),n2h2(363))
  call Hloop_QV_A(ntryL,G0H4(3),ex3(:),G0H2(1),m3h2x2(:,782),heltab2x4(:,:,782))
  call Hloop_Q_A(ntryL,G0H2(1),23,nME,G1H2(545),n2h2(364))
  call Hloop_QV_A(ntryL,G1H4(345),ex3(:),G1H2(556),m3h2x2(:,783),heltab2x4(:,:,783))
  call Hloop_Q_A(ntryL,G1H2(556),23,nMM,G2H2(561),n2h2(365))
call HGT_OLR(G1H4(341),1,1,4)
call HGT_invQ_OLR(G1H4(341),2,5,4)
  call Hloop_A_Q(ntryL,G1H4(341),-8,nMM,G2H4(66),n2h4(447))
  call Hloop_AV_Q(ntryL,G2H4(66),ex4(:),G2H2(562),m3h2x2(:,784),heltab2x4(:,:,784))
  call Hloop_QV_A(ntryL,G1H4(354),ex3(:),G1H2(577),m3h2x2(:,785),heltab2x4(:,:,785))
  call Hloop_Q_A(ntryL,G1H2(577),23,nMM,G2H2(563),n2h2(366))
  call Hloop_QV_A(ntryL,G1H4(346),ex3(:),G1H2(21),m3h2x2(:,786),heltab2x4(:,:,786))
  call Hloop_Q_A(ntryL,G1H2(21),23,nMM,G2H2(564),n2h2(367))
  call Hloop_QV_A(ntryL,G0H4(4),ex3(:),G0H2(1),m3h2x2(:,787),heltab2x4(:,:,787))
  call Hloop_Q_A(ntryL,G0H2(1),23,nMM,G1H2(22),n2h2(368))
  call Hloop_QV_A(ntryL,G1H4(342),ex3(:),G1H2(117),m3h2x2(:,788),heltab2x4(:,:,788))
  call Hloop_Q_A(ntryL,G1H2(117),23,nML,G2H2(565),n2h2(369))
call HGT_OLR(G1H4(17),1,1,4)
call HGT_invQ_OLR(G1H4(17),2,5,4)
  call Hloop_A_Q(ntryL,G1H4(17),-8,nML,G2H4(128),n2h4(448))
  call Hloop_AV_Q(ntryL,G2H4(128),ex4(:),G2H2(566),m3h2x2(:,789),heltab2x4(:,:,789))
  call Hloop_QV_A(ntryL,G1H4(19),ex3(:),G1H2(27),m3h2x2(:,790),heltab2x4(:,:,790))
  call Hloop_Q_A(ntryL,G1H2(27),23,nML,G2H2(567),n2h2(370))
  call Hloop_QV_A(ntryL,G1H4(20),ex3(:),G1H2(28),m3h2x2(:,791),heltab2x4(:,:,791))
  call Hloop_Q_A(ntryL,G1H2(28),23,nML,G2H2(568),n2h2(371))
  call Hloop_QV_A(ntryL,G0H4(16),ex3(:),G0H2(1),m3h2x2(:,792),heltab2x4(:,:,792))
  call Hloop_Q_A(ntryL,G0H2(1),23,nML,G1H2(122),n2h2(372))
  call Hloop_DV_C(ntryL,G1H4(28),19,ex3(:),G2H2(569),m3h2x2(:,793),heltab2x4(:,:,793))
call HGT_OLR(G1H4(32),1,1,4)
call HGT_invQ_OLR(G1H4(32),2,5,4)
  call Hloop_CV_D(ntryL,G1H4(32),-8,ex4(:),8,G2H2(570),m3h2x2(:,794),heltab2x4(:,:,794))
  call Hloop_DV_C(ntryL,G1H4(369),19,ex3(:),G2H2(571),m3h2x2(:,795),heltab2x4(:,:,795))
  call Hloop_DV_C(ntryL,G1H4(7),19,ex3(:),G2H2(572),m3h2x2(:,796),heltab2x4(:,:,796))
  call Hloop_DV_C(ntryL,G0H4(15),19,ex3(:),G1H2(33),m3h2x2(:,797),heltab2x4(:,:,797))
  call Hloop_CV_D(ntryL,G1H4(370),19,ex3(:),4,G2H2(573),m3h2x2(:,798),heltab2x4(:,:,798))
call HGT_OLR(G1H4(13),1,1,4)
call HGT_invQ_OLR(G1H4(13),2,5,4)
  call Hloop_DV_C(ntryL,G1H4(13),-8,ex4(:),G2H2(574),m3h2x2(:,799),heltab2x4(:,:,799))
  call Hloop_CV_D(ntryL,G1H4(37),19,ex3(:),4,G2H2(575),m3h2x2(:,800),heltab2x4(:,:,800))
  call Hloop_CV_D(ntryL,G1H4(376),19,ex3(:),4,G2H2(576),m3h2x2(:,801),heltab2x4(:,:,801))
  call Hloop_CV_D(ntryL,G0H4(14),19,ex3(:),4,G1H2(34),m3h2x2(:,802),heltab2x4(:,:,802))
  call Hloop_AV_Q(ntryL,G1H4(43),ex3(:),G1H2(302),m3h2x2(:,803),heltab2x4(:,:,803))
  call Hloop_A_Q(ntryL,G1H2(302),23,0,G2H2(577),n2h2(373))
call HGT_OLR(G1H4(379),1,1,4)
call HGT_invQ_OLR(G1H4(379),2,5,4)
  call Hloop_Q_A(ntryL,G1H4(379),-8,0,G2H4(80),n2h4(451))
  call Hloop_QV_A(ntryL,G2H4(80),ex4(:),G2H2(578),m3h2x2(:,804),heltab2x4(:,:,804))
  call Hloop_AV_Q(ntryL,G1H4(381),ex3(:),G1H2(39),m3h2x2(:,805),heltab2x4(:,:,805))
  call Hloop_A_Q(ntryL,G1H2(39),23,0,G2H2(579),n2h2(374))
  call Hloop_AV_Q(ntryL,G1H4(77),ex3(:),G1H2(40),m3h2x2(:,806),heltab2x4(:,:,806))
  call Hloop_A_Q(ntryL,G1H2(40),23,0,G2H2(580),n2h2(375))
  call Hloop_AV_Q(ntryL,G0H4(13),ex3(:),G0H2(1),m3h2x2(:,807),heltab2x4(:,:,807))
  call Hloop_A_Q(ntryL,G0H2(1),23,0,G1H2(318),n2h2(376))
  call Hloop_QV_A(ntryL,G1H4(84),ex3(:),G1H2(45),m3h2x2(:,808),heltab2x4(:,:,808))
  call Hloop_Q_A(ntryL,G1H2(45),23,0,G2H2(581),n2h2(377))
call HGT_OLR(G1H4(82),1,1,4)
call HGT_invQ_OLR(G1H4(82),2,5,4)
  call Hloop_A_Q(ntryL,G1H4(82),-8,0,G2H4(70),n2h4(452))
  call Hloop_AV_Q(ntryL,G2H4(70),ex4(:),G2H2(582),m3h2x2(:,809),heltab2x4(:,:,809))
  call Hloop_QV_A(ntryL,G1H4(88),ex3(:),G1H2(46),m3h2x2(:,810),heltab2x4(:,:,810))
  call Hloop_Q_A(ntryL,G1H2(46),23,0,G2H2(583),n2h2(378))
  call Hloop_QV_A(ntryL,G1H4(129),ex3(:),G1H2(127),m3h2x2(:,811),heltab2x4(:,:,811))
  call Hloop_Q_A(ntryL,G1H2(127),23,0,G2H2(584),n2h2(379))
  call Hloop_QV_A(ntryL,G0H4(5),ex3(:),G0H2(1),m3h2x2(:,812),heltab2x4(:,:,812))
  call Hloop_Q_A(ntryL,G0H2(1),23,0,G1H2(51),n2h2(380))
  call Hloop_QS_A(ntryL,G1H8(100),wf4(:,36),G1H2(52),ngH,m3h4x2(:,79),heltab2x8(:,:,467))
  call Hloop_Q_A(ntryL,G1H2(52),23,nME,G2H2(585),n2h2(381))
call HGT_OLR(G1H8(17),1,1,8)
call HGT_invQ_OLR(G1H8(17),2,5,8)
  call Hloop_A_Q(ntryL,G1H8(17),-8,nME,G2H8(34),n2h8(299))
  call Hloop_AV_Q(ntryL,G2H8(34),ex4(:),G2H4(151),m3h2x4(:,389),heltab2x8(:,:,468))
  call Hloop_QS_A(ntryL,G1H8(40),wf4(:,36),G1H2(132),ngH,m3h4x2(:,80),heltab2x8(:,:,469))
  call Hloop_Q_A(ntryL,G1H2(132),23,nME,G2H2(586),n2h2(382))
  call Hloop_QS_A(ntryL,G1H8(73),wf4(:,36),G1H2(57),ngH,m3h4x2(:,81),heltab2x8(:,:,470))
  call Hloop_Q_A(ntryL,G1H2(57),23,nME,G2H2(587),n2h2(383))
  call Hloop_QS_A(ntryL,G0H8(57),wf4(:,36),G0H2(1),ngH,m3h4x2(:,82),heltab2x8(:,:,471))
  call Hloop_Q_A(ntryL,G0H2(1),23,nME,G1H2(58),n2h2(384))
  call Hloop_QS_A(ntryL,G1H8(118),wf4(:,36),G1H2(100),ngH,m3h4x2(:,83),heltab2x8(:,:,472))
  call Hloop_Q_A(ntryL,G1H2(100),23,nMM,G2H2(588),n2h2(385))
call HGT_OLR(G1H8(119),1,1,8)
call HGT_invQ_OLR(G1H8(119),2,5,8)
  call Hloop_A_Q(ntryL,G1H8(119),-8,nMM,G2H8(33),n2h8(300))
  call Hloop_AV_Q(ntryL,G2H8(33),ex4(:),G2H4(84),m3h2x4(:,390),heltab2x8(:,:,473))
  call Hloop_QS_A(ntryL,G1H8(32),wf4(:,36),G1H2(567),ngH,m3h4x2(:,84),heltab2x8(:,:,474))
  call Hloop_Q_A(ntryL,G1H2(567),23,nMM,G2H2(589),n2h2(386))
  call Hloop_QS_A(ntryL,G1H8(145),wf4(:,36),G1H2(105),ngH,m3h4x2(:,85),heltab2x8(:,:,475))
  call Hloop_Q_A(ntryL,G1H2(105),23,nMM,G2H2(590),n2h2(387))
  call Hloop_QS_A(ntryL,G0H8(21),wf4(:,36),G0H2(1),ngH,m3h4x2(:,86),heltab2x8(:,:,476))
  call Hloop_Q_A(ntryL,G0H2(1),23,nMM,G1H2(106),n2h2(388))
  call Hloop_QS_A(ntryL,G1H8(146),wf4(:,36),G1H2(583),ngH,m3h4x2(:,87),heltab2x8(:,:,477))
  call Hloop_Q_A(ntryL,G1H2(583),23,nML,G2H2(591),n2h2(389))
call HGT_OLR(G1H8(122),1,1,8)
call HGT_invQ_OLR(G1H8(122),2,5,8)
  call Hloop_A_Q(ntryL,G1H8(122),-8,nML,G2H8(37),n2h8(301))
  call Hloop_AV_Q(ntryL,G2H8(37),ex4(:),G2H4(89),m3h2x4(:,391),heltab2x8(:,:,478))
  call Hloop_QS_A(ntryL,G1H8(124),wf4(:,36),G1H2(111),ngH,m3h4x2(:,88),heltab2x8(:,:,479))
  call Hloop_Q_A(ntryL,G1H2(111),23,nML,G2H2(592),n2h2(390))
  call Hloop_QS_A(ntryL,G1H8(1),wf4(:,36),G1H2(112),ngH,m3h4x2(:,89),heltab2x8(:,:,480))
  call Hloop_Q_A(ntryL,G1H2(112),23,nML,G2H2(593),n2h2(391))
  call Hloop_QS_A(ntryL,G0H8(22),wf4(:,36),G0H2(1),ngH,m3h4x2(:,90),heltab2x8(:,:,481))
  call Hloop_Q_A(ntryL,G0H2(1),23,nML,G1H2(588),n2h2(392))
  call Hloop_AS_Q(ntryL,G1H8(2),wf4(:,36),G1H2(118),ngH,m3h4x2(:,91),heltab2x8(:,:,482))
  call Hloop_A_Q(ntryL,G1H2(118),23,nME,G2H2(594),n2h2(393))
call HGT_OLR(G1H8(6),1,1,8)
call HGT_invQ_OLR(G1H8(6),2,5,8)
  call Hloop_Q_A(ntryL,G1H8(6),-8,nME,G2H8(38),n2h8(302))
  call Hloop_QV_A(ntryL,G2H8(38),ex4(:),G2H4(163),m3h2x4(:,392),heltab2x8(:,:,483))
  call Hloop_AS_Q(ntryL,G1H8(15),wf4(:,36),G1H2(123),ngH,m3h4x2(:,92),heltab2x8(:,:,484))
  call Hloop_A_Q(ntryL,G1H2(123),23,nME,G2H2(595),n2h2(394))
  call Hloop_AS_Q(ntryL,G1H8(18),wf4(:,36),G1H2(128),ngH,m3h4x2(:,93),heltab2x8(:,:,485))
  call Hloop_A_Q(ntryL,G1H2(128),23,nME,G2H2(596),n2h2(395))
  call Hloop_AS_Q(ntryL,G0H8(23),wf4(:,36),G0H2(1),ngH,m3h4x2(:,94),heltab2x8(:,:,486))
  call Hloop_A_Q(ntryL,G0H2(1),23,nME,G1H2(133),n2h2(396))
  call Hloop_AS_Q(ntryL,G1H8(20),wf4(:,36),G1H2(137),ngH,m3h4x2(:,95),heltab2x8(:,:,487))
  call Hloop_A_Q(ntryL,G1H2(137),23,nMM,G2H2(597),n2h2(397))
call HGT_OLR(G1H8(19),1,1,8)
call HGT_invQ_OLR(G1H8(19),2,5,8)
  call Hloop_Q_A(ntryL,G1H8(19),-8,nMM,G2H8(79),n2h8(303))
  call Hloop_QV_A(ntryL,G2H8(79),ex4(:),G2H4(104),m3h2x4(:,393),heltab2x8(:,:,488))
  call Hloop_AS_Q(ntryL,G1H8(21),wf4(:,36),G1H2(138),ngH,m3h4x2(:,96),heltab2x8(:,:,489))
  call Hloop_A_Q(ntryL,G1H2(138),23,nMM,G2H2(598),n2h2(398))
  call Hloop_AS_Q(ntryL,G1H8(23),wf4(:,36),G1H2(143),ngH,m3h4x2(:,97),heltab2x8(:,:,490))
  call Hloop_A_Q(ntryL,G1H2(143),23,nMM,G2H2(599),n2h2(399))
  call Hloop_AS_Q(ntryL,G0H8(24),wf4(:,36),G0H2(1),ngH,m3h4x2(:,98),heltab2x8(:,:,491))
  call Hloop_A_Q(ntryL,G0H2(1),23,nMM,G1H2(144),n2h2(400))
  call Hloop_AS_Q(ntryL,G1H8(24),wf4(:,36),G1H2(148),ngH,m3h4x2(:,99),heltab2x8(:,:,492))
  call Hloop_A_Q(ntryL,G1H2(148),23,nML,G2H2(600),n2h2(401))
call HGT_OLR(G1H8(28),1,1,8)
call HGT_invQ_OLR(G1H8(28),2,5,8)
  call Hloop_Q_A(ntryL,G1H8(28),-8,nML,G2H8(81),n2h8(304))
  call Hloop_QV_A(ntryL,G2H8(81),ex4(:),G2H4(71),m3h2x4(:,394),heltab2x8(:,:,493))
  call Hloop_AS_Q(ntryL,G1H8(44),wf4(:,36),G1H2(149),ngH,m3h4x2(:,100),heltab2x8(:,:,494))
  call Hloop_A_Q(ntryL,G1H2(149),23,nML,G2H2(601),n2h2(402))
  call Hloop_AS_Q(ntryL,G1H8(43),wf4(:,36),G1H2(154),ngH,m3h4x2(:,101),heltab2x8(:,:,495))
  call Hloop_A_Q(ntryL,G1H2(154),23,nML,G2H2(602),n2h2(403))
  call Hloop_AS_Q(ntryL,G0H8(25),wf4(:,36),G0H2(1),ngH,m3h4x2(:,102),heltab2x8(:,:,496))
  call Hloop_A_Q(ntryL,G0H2(1),23,nML,G1H2(155),n2h2(404))
  call Hloop_QS_A(ntryL,G1H8(52),wf4(:,36),G1H2(159),ngH,m3h4x2(:,103),heltab2x8(:,:,497))
  call Hloop_Q_A(ntryL,G1H2(159),23,nMT,G2H2(603),n2h2(405))
call HGT_OLR(G1H8(51),1,1,8)
call HGT_invQ_OLR(G1H8(51),2,5,8)
  call Hloop_A_Q(ntryL,G1H8(51),-8,nMT,G2H8(83),n2h8(305))
  call Hloop_AV_Q(ntryL,G2H8(83),ex4(:),G2H4(59),m3h2x4(:,395),heltab2x8(:,:,498))
  call Hloop_QS_A(ntryL,G1H8(53),wf4(:,36),G1H2(160),ngH,m3h4x2(:,104),heltab2x8(:,:,499))
  call Hloop_Q_A(ntryL,G1H2(160),23,nMT,G2H2(604),n2h2(406))
  call Hloop_QS_A(ntryL,G1H8(54),wf4(:,36),G1H2(165),ngH,m3h4x2(:,105),heltab2x8(:,:,500))
  call Hloop_Q_A(ntryL,G1H2(165),23,nMT,G2H2(605),n2h2(407))
  call Hloop_QS_A(ntryL,G0H8(26),wf4(:,36),G0H2(1),ngH,m3h4x2(:,106),heltab2x8(:,:,501))
  call Hloop_Q_A(ntryL,G0H2(1),23,nMT,G1H2(166),n2h2(408))
  call Hloop_AS_Q(ntryL,G1H8(58),wf4(:,36),G1H2(214),ngH,m3h4x2(:,107),heltab2x8(:,:,502))
  call Hloop_A_Q(ntryL,G1H2(214),23,nMT,G2H2(606),n2h2(409))
call HGT_OLR(G1H8(57),1,1,8)
call HGT_invQ_OLR(G1H8(57),2,5,8)
  call Hloop_Q_A(ntryL,G1H8(57),-8,nMT,G2H8(85),n2h8(306))
  call Hloop_QV_A(ntryL,G2H8(85),ex4(:),G2H4(105),m3h2x4(:,396),heltab2x8(:,:,503))
  call Hloop_AS_Q(ntryL,G1H8(69),wf4(:,36),G1H2(220),ngH,m3h4x2(:,108),heltab2x8(:,:,504))
  call Hloop_A_Q(ntryL,G1H2(220),23,nMT,G2H2(607),n2h2(410))
  call Hloop_AS_Q(ntryL,G1H8(70),wf4(:,36),G1H2(221),ngH,m3h4x2(:,109),heltab2x8(:,:,505))
  call Hloop_A_Q(ntryL,G1H2(221),23,nMT,G2H2(608),n2h2(411))
  call Hloop_AS_Q(ntryL,G0H8(27),wf4(:,36),G0H2(1),ngH,m3h4x2(:,110),heltab2x8(:,:,506))
  call Hloop_A_Q(ntryL,G0H2(1),23,nMT,G1H2(225),n2h2(412))
  call Hloop_QS_A(ntryL,G1H8(67),wf4(:,36),G1H2(231),ngH,m3h4x2(:,111),heltab2x8(:,:,507))
  call Hloop_Q_A(ntryL,G1H2(231),23,nMB,G2H2(609),n2h2(413))
call HGT_OLR(G1H8(68),1,1,8)
call HGT_invQ_OLR(G1H8(68),2,5,8)
  call Hloop_A_Q(ntryL,G1H8(68),-8,nMB,G2H8(1),n2h8(307))
  call Hloop_AV_Q(ntryL,G2H8(1),ex4(:),G2H4(72),m3h2x4(:,397),heltab2x8(:,:,508))
  call Hloop_QS_A(ntryL,G1H8(76),wf4(:,36),G1H2(232),ngH,m3h4x2(:,112),heltab2x8(:,:,509))
  call Hloop_Q_A(ntryL,G1H2(232),23,nMB,G2H2(610),n2h2(414))
  call Hloop_QS_A(ntryL,G1H8(80),wf4(:,36),G1H2(236),ngH,m3h4x2(:,113),heltab2x8(:,:,510))
  call Hloop_Q_A(ntryL,G1H2(236),23,nMB,G2H2(611),n2h2(415))
  call Hloop_QS_A(ntryL,G0H8(28),wf4(:,36),G0H2(1),ngH,m3h4x2(:,114),heltab2x8(:,:,511))
  call Hloop_Q_A(ntryL,G0H2(1),23,nMB,G1H2(242),n2h2(416))
  call Hloop_AS_Q(ntryL,G1H8(88),wf4(:,36),G1H2(243),ngH,m3h4x2(:,115),heltab2x8(:,:,512))
  call Hloop_A_Q(ntryL,G1H2(243),23,nMB,G2H2(612),n2h2(417))
call HGT_OLR(G1H8(87),1,1,8)
call HGT_invQ_OLR(G1H8(87),2,5,8)
  call Hloop_Q_A(ntryL,G1H8(87),-8,nMB,G2H8(2),n2h8(308))
  call Hloop_QV_A(ntryL,G2H8(2),ex4(:),G2H4(60),m3h2x4(:,398),heltab2x8(:,:,513))
  call Hloop_AS_Q(ntryL,G1H8(33),wf4(:,36),G1H2(247),ngH,m3h4x2(:,116),heltab2x8(:,:,514))
  call Hloop_A_Q(ntryL,G1H2(247),23,nMB,G2H2(613),n2h2(418))
  call Hloop_AS_Q(ntryL,G1H8(35),wf4(:,36),G1H2(253),ngH,m3h4x2(:,117),heltab2x8(:,:,515))
  call Hloop_A_Q(ntryL,G1H2(253),23,nMB,G2H2(614),n2h2(419))
  call Hloop_AS_Q(ntryL,G0H8(29),wf4(:,36),G0H2(1),ngH,m3h4x2(:,118),heltab2x8(:,:,516))
  call Hloop_A_Q(ntryL,G0H2(1),23,nMB,G1H2(254),n2h2(420))
  call Hloop_QS_A(ntryL,G1H8(36),wf4(:,37),G1H2(258),ngX,m3h4x2(:,119),heltab2x8(:,:,517))
  call Hloop_Q_A(ntryL,G1H2(258),23,nME,G2H2(615),n2h2(421))
call HGT_OLR(G1H8(46),1,1,8)
call HGT_invQ_OLR(G1H8(46),2,5,8)
  call Hloop_A_Q(ntryL,G1H8(46),-8,nME,G2H8(3),n2h8(309))
  call Hloop_AV_Q(ntryL,G2H8(3),ex4(:),G2H4(109),m3h2x4(:,399),heltab2x8(:,:,518))
  call Hloop_QS_A(ntryL,G1H8(48),wf4(:,37),G1H2(264),ngX,m3h4x2(:,120),heltab2x8(:,:,519))
  call Hloop_Q_A(ntryL,G1H2(264),23,nME,G2H2(616),n2h2(422))
  call Hloop_QS_A(ntryL,G1H8(49),wf4(:,37),G1H2(265),ngX,m3h4x2(:,121),heltab2x8(:,:,520))
  call Hloop_Q_A(ntryL,G1H2(265),23,nME,G2H2(617),n2h2(423))
  call Hloop_QS_A(ntryL,G0H8(30),wf4(:,37),G0H2(1),ngX,m3h4x2(:,122),heltab2x8(:,:,521))
  call Hloop_Q_A(ntryL,G0H2(1),23,nME,G1H2(269),n2h2(424))
  call Hloop_QS_A(ntryL,G1H8(50),wf4(:,37),G1H2(275),ngX,m3h4x2(:,123),heltab2x8(:,:,522))
  call Hloop_Q_A(ntryL,G1H2(275),23,nMM,G2H2(618),n2h2(425))
call HGT_OLR(G1H8(60),1,1,8)
call HGT_invQ_OLR(G1H8(60),2,5,8)
  call Hloop_A_Q(ntryL,G1H8(60),-8,nMM,G2H8(4),n2h8(310))
  call Hloop_AV_Q(ntryL,G2H8(4),ex4(:),G2H4(73),m3h2x4(:,400),heltab2x8(:,:,523))
  call Hloop_QS_A(ntryL,G1H8(61),wf4(:,37),G1H2(276),ngX,m3h4x2(:,124),heltab2x8(:,:,524))
  call Hloop_Q_A(ntryL,G1H2(276),23,nMM,G2H2(619),n2h2(426))
  call Hloop_QS_A(ntryL,G1H8(101),wf4(:,37),G1H2(280),ngX,m3h4x2(:,125),heltab2x8(:,:,525))
  call Hloop_Q_A(ntryL,G1H2(280),23,nMM,G2H2(620),n2h2(427))
  call Hloop_QS_A(ntryL,G0H8(31),wf4(:,37),G0H2(1),ngX,m3h4x2(:,126),heltab2x8(:,:,526))
  call Hloop_Q_A(ntryL,G0H2(1),23,nMM,G1H2(286),n2h2(428))
  call Hloop_QS_A(ntryL,G1H8(103),wf4(:,37),G1H2(287),ngX,m3h4x2(:,127),heltab2x8(:,:,527))
  call Hloop_Q_A(ntryL,G1H2(287),23,nML,G2H2(621),n2h2(429))
call HGT_OLR(G1H8(104),1,1,8)
call HGT_invQ_OLR(G1H8(104),2,5,8)
  call Hloop_A_Q(ntryL,G1H8(104),-8,nML,G2H8(5),n2h8(311))
  call Hloop_AV_Q(ntryL,G2H8(5),ex4(:),G2H4(61),m3h2x4(:,401),heltab2x8(:,:,528))
  call Hloop_QS_A(ntryL,G1H8(106),wf4(:,37),G1H2(291),ngX,m3h4x2(:,128),heltab2x8(:,:,529))
  call Hloop_Q_A(ntryL,G1H2(291),23,nML,G2H2(622),n2h2(430))
  call Hloop_QS_A(ntryL,G1H8(107),wf4(:,37),G1H2(297),ngX,m3h4x2(:,129),heltab2x8(:,:,530))
  call Hloop_Q_A(ntryL,G1H2(297),23,nML,G2H2(623),n2h2(431))
  call Hloop_QS_A(ntryL,G0H8(32),wf4(:,37),G0H2(1),ngX,m3h4x2(:,130),heltab2x8(:,:,531))
  call Hloop_Q_A(ntryL,G0H2(1),23,nML,G1H2(298),n2h2(432))
  call Hloop_AS_Q(ntryL,G1H8(109),wf4(:,37),G1H2(303),ngX,m3h4x2(:,131),heltab2x8(:,:,532))
  call Hloop_A_Q(ntryL,G1H2(303),23,nME,G2H2(624),n2h2(433))
call HGT_OLR(G1H8(152),1,1,8)
call HGT_invQ_OLR(G1H8(152),2,5,8)
  call Hloop_Q_A(ntryL,G1H8(152),-8,nME,G2H8(6),n2h8(312))
  call Hloop_QV_A(ntryL,G2H8(6),ex4(:),G2H4(110),m3h2x4(:,402),heltab2x8(:,:,533))
  call Hloop_AS_Q(ntryL,G1H8(154),wf4(:,37),G1H2(308),ngX,m3h4x2(:,132),heltab2x8(:,:,534))
  call Hloop_A_Q(ntryL,G1H2(308),23,nME,G2H2(625),n2h2(434))
  call Hloop_AS_Q(ntryL,G1H8(155),wf4(:,37),G1H2(313),ngX,m3h4x2(:,133),heltab2x8(:,:,535))
  call Hloop_A_Q(ntryL,G1H2(313),23,nME,G2H2(626),n2h2(435))
  call Hloop_AS_Q(ntryL,G0H8(33),wf4(:,37),G0H2(1),ngX,m3h4x2(:,134),heltab2x8(:,:,536))
  call Hloop_A_Q(ntryL,G0H2(1),23,nME,G1H2(314),n2h2(436))
  call Hloop_AS_Q(ntryL,G1H8(157),wf4(:,37),G1H2(323),ngX,m3h4x2(:,135),heltab2x8(:,:,537))
  call Hloop_A_Q(ntryL,G1H2(323),23,nMM,G2H2(627),n2h2(437))
call HGT_OLR(G1H8(158),1,1,8)
call HGT_invQ_OLR(G1H8(158),2,5,8)
  call Hloop_Q_A(ntryL,G1H8(158),-8,nMM,G2H8(7),n2h8(313))
  call Hloop_QV_A(ntryL,G2H8(7),ex4(:),G2H4(74),m3h2x4(:,403),heltab2x8(:,:,538))
  call Hloop_AS_Q(ntryL,G1H8(112),wf4(:,37),G1H2(324),ngX,m3h4x2(:,136),heltab2x8(:,:,539))
  call Hloop_A_Q(ntryL,G1H2(324),23,nMM,G2H2(628),n2h2(438))
  call Hloop_AS_Q(ntryL,G1H8(160),wf4(:,37),G1H2(329),ngX,m3h4x2(:,137),heltab2x8(:,:,540))
  call Hloop_A_Q(ntryL,G1H2(329),23,nMM,G2H2(629),n2h2(439))
  call Hloop_AS_Q(ntryL,G0H8(34),wf4(:,37),G0H2(1),ngX,m3h4x2(:,138),heltab2x8(:,:,541))
  call Hloop_A_Q(ntryL,G0H2(1),23,nMM,G1H2(334),n2h2(440))
  call Hloop_AS_Q(ntryL,G1H8(132),wf4(:,37),G1H2(335),ngX,m3h4x2(:,139),heltab2x8(:,:,542))
  call Hloop_A_Q(ntryL,G1H2(335),23,nML,G2H2(630),n2h2(441))
call HGT_OLR(G1H8(126),1,1,8)
call HGT_invQ_OLR(G1H8(126),2,5,8)
  call Hloop_Q_A(ntryL,G1H8(126),-8,nML,G2H8(8),n2h8(314))
  call Hloop_QV_A(ntryL,G2H8(8),ex4(:),G2H4(62),m3h2x4(:,404),heltab2x8(:,:,543))
  call Hloop_AS_Q(ntryL,G1H8(59),wf4(:,37),G1H2(340),ngX,m3h4x2(:,140),heltab2x8(:,:,544))
  call Hloop_A_Q(ntryL,G1H2(340),23,nML,G2H2(631),n2h2(442))
  call Hloop_AS_Q(ntryL,G1H8(42),wf4(:,37),G1H2(345),ngX,m3h4x2(:,141),heltab2x8(:,:,545))
  call Hloop_A_Q(ntryL,G1H2(345),23,nML,G2H2(632),n2h2(443))
  call Hloop_AS_Q(ntryL,G0H8(35),wf4(:,37),G0H2(1),ngX,m3h4x2(:,142),heltab2x8(:,:,546))
  call Hloop_A_Q(ntryL,G0H2(1),23,nML,G1H2(346),n2h2(444))
  call Hloop_QS_A(ntryL,G1H8(45),wf4(:,37),G1H2(351),ngX,m3h4x2(:,143),heltab2x8(:,:,547))
  call Hloop_Q_A(ntryL,G1H2(351),23,nMT,G2H2(633),n2h2(445))
call HGT_OLR(G1H8(143),1,1,8)
call HGT_invQ_OLR(G1H8(143),2,5,8)
  call Hloop_A_Q(ntryL,G1H8(143),-8,nMT,G2H8(9),n2h8(315))
  call Hloop_AV_Q(ntryL,G2H8(9),ex4(:),G2H4(114),m3h2x4(:,405),heltab2x8(:,:,548))
  call Hloop_QS_A(ntryL,G1H8(111),wf4(:,37),G1H2(356),ngX,m3h4x2(:,144),heltab2x8(:,:,549))
  call Hloop_Q_A(ntryL,G1H2(356),23,nMT,G2H2(634),n2h2(446))
  call Hloop_QS_A(ntryL,G1H8(113),wf4(:,37),G1H2(357),ngX,m3h4x2(:,145),heltab2x8(:,:,550))
  call Hloop_Q_A(ntryL,G1H2(357),23,nMT,G2H2(635),n2h2(447))
  call Hloop_QS_A(ntryL,G0H8(36),wf4(:,37),G0H2(1),ngX,m3h4x2(:,146),heltab2x8(:,:,551))
  call Hloop_Q_A(ntryL,G0H2(1),23,nMT,G1H2(362),n2h2(448))
  call Hloop_AS_Q(ntryL,G1H8(98),wf4(:,37),G1H2(367),ngX,m3h4x2(:,147),heltab2x8(:,:,552))
  call Hloop_A_Q(ntryL,G1H2(367),23,nMT,G2H2(636),n2h2(449))
call HGT_OLR(G1H8(110),1,1,8)
call HGT_invQ_OLR(G1H8(110),2,5,8)
  call Hloop_Q_A(ntryL,G1H8(110),-8,nMT,G2H8(10),n2h8(316))
  call Hloop_QV_A(ntryL,G2H8(10),ex4(:),G2H4(75),m3h2x4(:,406),heltab2x8(:,:,553))
  call Hloop_AS_Q(ntryL,G1H8(8),wf4(:,37),G1H2(368),ngX,m3h4x2(:,148),heltab2x8(:,:,554))
  call Hloop_A_Q(ntryL,G1H2(368),23,nMT,G2H2(637),n2h2(450))
  call Hloop_AS_Q(ntryL,G1H8(91),wf4(:,37),G1H2(373),ngX,m3h4x2(:,149),heltab2x8(:,:,555))
  call Hloop_A_Q(ntryL,G1H2(373),23,nMT,G2H2(638),n2h2(451))
  call Hloop_AS_Q(ntryL,G0H8(37),wf4(:,37),G0H2(1),ngX,m3h4x2(:,150),heltab2x8(:,:,556))
  call Hloop_A_Q(ntryL,G0H2(1),23,nMT,G1H2(378),n2h2(452))
  call Hloop_QS_A(ntryL,G1H8(127),wf4(:,37),G1H2(379),ngX,m3h4x2(:,151),heltab2x8(:,:,557))
  call Hloop_Q_A(ntryL,G1H2(379),23,nMB,G2H2(639),n2h2(453))
call HGT_OLR(G1H8(140),1,1,8)
call HGT_invQ_OLR(G1H8(140),2,5,8)
  call Hloop_A_Q(ntryL,G1H8(140),-8,nMB,G2H8(11),n2h8(317))
  call Hloop_AV_Q(ntryL,G2H8(11),ex4(:),G2H4(63),m3h2x4(:,407),heltab2x8(:,:,558))
  call Hloop_QS_A(ntryL,G1H8(139),wf4(:,37),G1H2(384),ngX,m3h4x2(:,152),heltab2x8(:,:,559))
  call Hloop_Q_A(ntryL,G1H2(384),23,nMB,G2H2(640),n2h2(454))
  call Hloop_QS_A(ntryL,G1H8(141),wf4(:,37),G1H2(389),ngX,m3h4x2(:,153),heltab2x8(:,:,560))
  call Hloop_Q_A(ntryL,G1H2(389),23,nMB,G2H2(641),n2h2(455))
  call Hloop_QS_A(ntryL,G0H8(38),wf4(:,37),G0H2(1),ngX,m3h4x2(:,154),heltab2x8(:,:,561))
  call Hloop_Q_A(ntryL,G0H2(1),23,nMB,G1H2(390),n2h2(456))
  call Hloop_AS_Q(ntryL,G1H8(149),wf4(:,37),G1H2(395),ngX,m3h4x2(:,155),heltab2x8(:,:,562))
  call Hloop_A_Q(ntryL,G1H2(395),23,nMB,G2H2(642),n2h2(457))
call HGT_OLR(G1H8(147),1,1,8)
call HGT_invQ_OLR(G1H8(147),2,5,8)
  call Hloop_Q_A(ntryL,G1H8(147),-8,nMB,G2H8(14),n2h8(318))
  call Hloop_QV_A(ntryL,G2H8(14),ex4(:),G2H4(115),m3h2x4(:,408),heltab2x8(:,:,563))
  call Hloop_AS_Q(ntryL,G1H8(77),wf4(:,37),G1H2(396),ngX,m3h4x2(:,156),heltab2x8(:,:,564))
  call Hloop_A_Q(ntryL,G1H2(396),23,nMB,G2H2(643),n2h2(458))
  call Hloop_AS_Q(ntryL,G1H8(134),wf4(:,37),G1H2(401),ngX,m3h4x2(:,157),heltab2x8(:,:,565))
  call Hloop_A_Q(ntryL,G1H2(401),23,nMB,G2H2(644),n2h2(459))
  call Hloop_AS_Q(ntryL,G0H8(39),wf4(:,37),G0H2(1),ngX,m3h4x2(:,158),heltab2x8(:,:,566))
  call Hloop_A_Q(ntryL,G0H2(1),23,nMB,G1H2(406),n2h2(460))
  call Hloop_ST_V(ntryL,G1H8(144),20,wf4(:,36),3,G2H2(645),m3h4x2(:,159),heltab2x8(:,:,567))
call HGT_OLR(G1H8(90),1,1,8)
call HGT_invQ_OLR(G1H8(90),2,5,8)
  call Hloop_SV_V(ntryL,G1H8(90),ex4(:),G1H4(408),m3h2x4(:,409),heltab2x8(:,:,568))
  call Hloop_ST_V(ntryL,G1H8(92),20,wf4(:,36),3,G2H2(646),m3h4x2(:,160),heltab2x8(:,:,569))
  call Hloop_ST_V(ntryL,G1H8(95),20,wf4(:,36),3,G2H2(647),m3h4x2(:,161),heltab2x8(:,:,570))
  call Hloop_ST_V(ntryL,G1H8(176),20,wf4(:,37),3,G2H2(648),m3h4x2(:,162),heltab2x8(:,:,571))
call HGT_OLR(G1H8(177),1,1,8)
call HGT_invQ_OLR(G1H8(177),2,5,8)
  call Hloop_SV_V(ntryL,G1H8(177),ex4(:),G1H4(131),m3h2x4(:,410),heltab2x8(:,:,572))
  call Hloop_ST_V(ntryL,G1H8(179),20,wf4(:,37),3,G2H2(649),m3h4x2(:,163),heltab2x8(:,:,573))
  call Hloop_ST_V(ntryL,G1H8(180),20,wf4(:,37),3,G2H2(650),m3h4x2(:,164),heltab2x8(:,:,574))
  call Hloop_VT_S(ntryL,G1H8(62),20,wf4(:,36),3,G2H2(651),m3h4x2(:,165),heltab2x8(:,:,575))
call HGT_raise_alpha_OLR(G1H8(63),1,1,8)
call HGT_raise_alpha_invQ_OLR(G1H8(63),2,5,8)
  call Hloop_VV_S(ntryL,G1H8(63),ex4(:),G1H4(138),m3h2x4(:,411),heltab2x8(:,:,576))
  call Hloop_VT_S(ntryL,G1H8(74),20,wf4(:,36),3,G2H2(652),m3h4x2(:,166),heltab2x8(:,:,577))
  call Hloop_VT_S(ntryL,G1H8(75),20,wf4(:,36),3,G2H2(653),m3h4x2(:,167),heltab2x8(:,:,578))
  call Hloop_VT_S(ntryL,G1H8(78),20,wf4(:,37),3,G2H2(654),m3h4x2(:,168),heltab2x8(:,:,579))
call HGT_raise_alpha_OLR(G1H8(81),1,1,8)
call HGT_raise_alpha_invQ_OLR(G1H8(81),2,5,8)
  call Hloop_VV_S(ntryL,G1H8(81),ex4(:),G1H4(136),m3h2x4(:,412),heltab2x8(:,:,580))
  call Hloop_VT_S(ntryL,G1H8(86),20,wf4(:,37),3,G2H2(655),m3h4x2(:,169),heltab2x8(:,:,581))
  call Hloop_VT_S(ntryL,G1H8(125),20,wf4(:,37),3,G2H2(656),m3h4x2(:,170),heltab2x8(:,:,582))
  call Hloop_QV_A(ntryL,G1H8(181),wf4(:,13),G1H2(411),m3h4x2(:,171),heltab2x8(:,:,583))
  call Hloop_Q_A(ntryL,G1H2(411),23,nME,G2H2(657),n2h2(461))
call HGT_OLR(G1H8(182),1,1,8)
call HGT_invQ_OLR(G1H8(182),2,5,8)
  call Hloop_A_Q(ntryL,G1H8(182),-8,nME,G2H8(12),n2h8(323))
  call Hloop_AV_Q(ntryL,G2H8(12),ex4(:),G2H4(76),m3h2x4(:,413),heltab2x8(:,:,584))
  call Hloop_QV_A(ntryL,G1H8(184),wf4(:,13),G1H2(412),m3h4x2(:,172),heltab2x8(:,:,585))
  call Hloop_Q_A(ntryL,G1H2(412),23,nME,G2H2(658),n2h2(462))
  call Hloop_QV_A(ntryL,G1H8(185),wf4(:,13),G1H2(432),m3h4x2(:,173),heltab2x8(:,:,586))
  call Hloop_Q_A(ntryL,G1H2(432),23,nME,G2H2(659),n2h2(463))
  call Hloop_QV_A(ntryL,G0H8(40),wf4(:,13),G0H2(1),m3h4x2(:,174),heltab2x8(:,:,587))
  call Hloop_Q_A(ntryL,G0H2(1),23,nME,G1H2(433),n2h2(464))
  call Hloop_QV_A(ntryL,G1H8(186),wf4(:,13),G1H2(438),m3h4x2(:,175),heltab2x8(:,:,588))
  call Hloop_Q_A(ntryL,G1H2(438),23,nMM,G2H2(660),n2h2(465))
call HGT_OLR(G1H8(187),1,1,8)
call HGT_invQ_OLR(G1H8(187),2,5,8)
  call Hloop_A_Q(ntryL,G1H8(187),-8,nMM,G2H8(13),n2h8(324))
  call Hloop_AV_Q(ntryL,G2H8(13),ex4(:),G2H4(68),m3h2x4(:,414),heltab2x8(:,:,589))
  call Hloop_QV_A(ntryL,G1H8(189),wf4(:,13),G1H2(443),m3h4x2(:,176),heltab2x8(:,:,590))
  call Hloop_Q_A(ntryL,G1H2(443),23,nMM,G2H2(661),n2h2(466))
  call Hloop_QV_A(ntryL,G1H8(190),wf4(:,13),G1H2(444),m3h4x2(:,177),heltab2x8(:,:,591))
  call Hloop_Q_A(ntryL,G1H2(444),23,nMM,G2H2(662),n2h2(467))
  call Hloop_QV_A(ntryL,G0H8(41),wf4(:,13),G0H2(1),m3h4x2(:,178),heltab2x8(:,:,592))
  call Hloop_Q_A(ntryL,G0H2(1),23,nMM,G1H2(449),n2h2(468))
  call Hloop_QV_A(ntryL,G1H8(191),wf4(:,13),G1H2(466),m3h4x2(:,179),heltab2x8(:,:,593))
  call Hloop_Q_A(ntryL,G1H2(466),23,nML,G2H2(663),n2h2(469))
call HGT_OLR(G1H8(192),1,1,8)
call HGT_invQ_OLR(G1H8(192),2,5,8)
  call Hloop_A_Q(ntryL,G1H8(192),-8,nML,G2H8(16),n2h8(325))
  call Hloop_AV_Q(ntryL,G2H8(16),ex4(:),G2H4(156),m3h2x4(:,415),heltab2x8(:,:,594))
  call Hloop_QV_A(ntryL,G1H8(194),wf4(:,13),G1H2(471),m3h4x2(:,180),heltab2x8(:,:,595))
  call Hloop_Q_A(ntryL,G1H2(471),23,nML,G2H2(664),n2h2(470))
  call Hloop_QV_A(ntryL,G1H8(195),wf4(:,13),G1H2(475),m3h4x2(:,181),heltab2x8(:,:,596))
  call Hloop_Q_A(ntryL,G1H2(475),23,nML,G2H2(665),n2h2(471))
  call Hloop_QV_A(ntryL,G0H8(42),wf4(:,13),G0H2(1),m3h4x2(:,182),heltab2x8(:,:,597))
  call Hloop_Q_A(ntryL,G0H2(1),23,nML,G1H2(481),n2h2(472))
  call Hloop_AV_Q(ntryL,G1H8(196),wf4(:,13),G1H2(482),m3h4x2(:,183),heltab2x8(:,:,598))
  call Hloop_A_Q(ntryL,G1H2(482),23,nME,G2H2(666),n2h2(473))
call HGT_OLR(G1H8(197),1,1,8)
call HGT_invQ_OLR(G1H8(197),2,5,8)
  call Hloop_Q_A(ntryL,G1H8(197),-8,nME,G2H8(17),n2h8(326))
  call Hloop_QV_A(ntryL,G2H8(17),ex4(:),G2H4(158),m3h2x4(:,416),heltab2x8(:,:,599))
  call Hloop_AV_Q(ntryL,G1H8(199),wf4(:,13),G1H2(486),m3h4x2(:,184),heltab2x8(:,:,600))
  call Hloop_A_Q(ntryL,G1H2(486),23,nME,G2H2(667),n2h2(474))
  call Hloop_AV_Q(ntryL,G1H8(200),wf4(:,13),G1H2(503),m3h4x2(:,185),heltab2x8(:,:,601))
  call Hloop_A_Q(ntryL,G1H2(503),23,nME,G2H2(668),n2h2(475))
  call Hloop_AV_Q(ntryL,G0H8(43),wf4(:,13),G0H2(1),m3h4x2(:,186),heltab2x8(:,:,602))
  call Hloop_A_Q(ntryL,G0H2(1),23,nME,G1H2(504),n2h2(476))
  call Hloop_AV_Q(ntryL,G1H8(201),wf4(:,13),G1H2(509),m3h4x2(:,187),heltab2x8(:,:,603))
  call Hloop_A_Q(ntryL,G1H2(509),23,nMM,G2H2(669),n2h2(477))
call HGT_OLR(G1H8(202),1,1,8)
call HGT_invQ_OLR(G1H8(202),2,5,8)
  call Hloop_Q_A(ntryL,G1H8(202),-8,nMM,G2H8(15),n2h8(327))
  call Hloop_QV_A(ntryL,G2H8(15),ex4(:),G2H4(81),m3h2x4(:,417),heltab2x8(:,:,604))
  call Hloop_AV_Q(ntryL,G1H8(204),wf4(:,13),G1H2(514),m3h4x2(:,188),heltab2x8(:,:,605))
  call Hloop_A_Q(ntryL,G1H2(514),23,nMM,G2H2(670),n2h2(478))
  call Hloop_AV_Q(ntryL,G1H8(205),wf4(:,13),G1H2(519),m3h4x2(:,189),heltab2x8(:,:,606))
  call Hloop_A_Q(ntryL,G1H2(519),23,nMM,G2H2(671),n2h2(479))
  call Hloop_AV_Q(ntryL,G0H8(44),wf4(:,13),G0H2(1),m3h4x2(:,190),heltab2x8(:,:,607))
  call Hloop_A_Q(ntryL,G0H2(1),23,nMM,G1H2(520),n2h2(480))
  call Hloop_AV_Q(ntryL,G1H8(206),wf4(:,13),G1H2(540),m3h4x2(:,191),heltab2x8(:,:,608))
  call Hloop_A_Q(ntryL,G1H2(540),23,nML,G2H2(672),n2h2(481))
call HGT_OLR(G1H8(207),1,1,8)
call HGT_invQ_OLR(G1H8(207),2,5,8)
  call Hloop_Q_A(ntryL,G1H8(207),-8,nML,G2H8(18),n2h8(328))
  call Hloop_QV_A(ntryL,G2H8(18),ex4(:),G2H4(82),m3h2x4(:,418),heltab2x8(:,:,609))
  call Hloop_AV_Q(ntryL,G1H8(209),wf4(:,13),G1H2(546),m3h4x2(:,192),heltab2x8(:,:,610))
  call Hloop_A_Q(ntryL,G1H2(546),23,nML,G2H2(673),n2h2(482))
  call Hloop_AV_Q(ntryL,G1H8(210),wf4(:,13),G1H2(547),m3h4x2(:,193),heltab2x8(:,:,611))
  call Hloop_A_Q(ntryL,G1H2(547),23,nML,G2H2(674),n2h2(483))
  call Hloop_AV_Q(ntryL,G0H8(45),wf4(:,13),G0H2(1),m3h4x2(:,194),heltab2x8(:,:,612))
  call Hloop_A_Q(ntryL,G0H2(1),23,nML,G1H2(551),n2h2(484))
  call Hloop_QV_A(ntryL,G1H8(211),wf4(:,13),G1H2(557),m3h4x2(:,195),heltab2x8(:,:,613))
  call Hloop_Q_A(ntryL,G1H2(557),23,0,G2H2(675),n2h2(485))
call HGT_OLR(G1H8(212),1,1,8)
call HGT_invQ_OLR(G1H8(212),2,5,8)
  call Hloop_A_Q(ntryL,G1H8(212),-8,0,G2H8(19),n2h8(329))
  call Hloop_AV_Q(ntryL,G2H8(19),ex4(:),G2H4(172),m3h2x4(:,419),heltab2x8(:,:,614))
  call Hloop_QV_A(ntryL,G1H8(214),wf4(:,13),G1H2(558),m3h4x2(:,196),heltab2x8(:,:,615))
  call Hloop_Q_A(ntryL,G1H2(558),23,0,G2H2(676),n2h2(486))
  call Hloop_QV_A(ntryL,G1H8(215),wf4(:,13),G1H2(563),m3h4x2(:,197),heltab2x8(:,:,616))
  call Hloop_Q_A(ntryL,G1H2(563),23,0,G2H2(677),n2h2(487))
  call Hloop_QV_A(ntryL,G0H8(46),wf4(:,13),G0H2(1),m3h4x2(:,198),heltab2x8(:,:,617))
  call Hloop_Q_A(ntryL,G0H2(1),23,0,G1H2(572),n2h2(488))
  call Hloop_QV_A(ntryL,G1H8(216),wf4(:,13),G1H2(573),m3h4x2(:,199),heltab2x8(:,:,618))
  call Hloop_Q_A(ntryL,G1H2(573),23,nMT,G2H2(678),n2h2(489))
call HGT_OLR(G1H8(217),1,1,8)
call HGT_invQ_OLR(G1H8(217),2,5,8)
  call Hloop_A_Q(ntryL,G1H8(217),-8,nMT,G2H8(20),n2h8(330))
  call Hloop_AV_Q(ntryL,G2H8(20),ex4(:),G2H4(170),m3h2x4(:,420),heltab2x8(:,:,619))
  call Hloop_QV_A(ntryL,G1H8(219),wf4(:,13),G1H2(578),m3h4x2(:,200),heltab2x8(:,:,620))
  call Hloop_Q_A(ntryL,G1H2(578),23,nMT,G2H2(679),n2h2(490))
  call Hloop_QV_A(ntryL,G1H8(220),wf4(:,13),G1H2(584),m3h4x2(:,201),heltab2x8(:,:,621))
  call Hloop_Q_A(ntryL,G1H2(584),23,nMT,G2H2(680),n2h2(491))
  call Hloop_QV_A(ntryL,G0H8(47),wf4(:,13),G0H2(1),m3h4x2(:,202),heltab2x8(:,:,622))
  call Hloop_Q_A(ntryL,G0H2(1),23,nMT,G1H2(589),n2h2(492))
  call Hloop_AV_Q(ntryL,G1H8(221),wf4(:,13),G1H2(26),m3h4x2(:,203),heltab2x8(:,:,623))
  call Hloop_A_Q(ntryL,G1H2(26),23,0,G2H2(681),n2h2(493))
call HGT_OLR(G1H8(222),1,1,8)
call HGT_invQ_OLR(G1H8(222),2,5,8)
  call Hloop_Q_A(ntryL,G1H8(222),-8,0,G2H8(21),n2h8(331))
  call Hloop_QV_A(ntryL,G2H8(21),ex4(:),G2H4(169),m3h2x4(:,421),heltab2x8(:,:,624))
  call Hloop_AV_Q(ntryL,G1H8(224),wf4(:,13),G1H2(32),m3h4x2(:,204),heltab2x8(:,:,625))
  call Hloop_A_Q(ntryL,G1H2(32),23,0,G2H2(682),n2h2(494))
  call Hloop_AV_Q(ntryL,G1H8(225),wf4(:,13),G1H2(38),m3h4x2(:,205),heltab2x8(:,:,626))
  call Hloop_A_Q(ntryL,G1H2(38),23,0,G2H2(683),n2h2(495))
  call Hloop_AV_Q(ntryL,G0H8(48),wf4(:,13),G0H2(1),m3h4x2(:,206),heltab2x8(:,:,627))
  call Hloop_A_Q(ntryL,G0H2(1),23,0,G1H2(50),n2h2(496))
  call Hloop_AV_Q(ntryL,G1H8(226),wf4(:,13),G1H2(56),m3h4x2(:,207),heltab2x8(:,:,628))
  call Hloop_A_Q(ntryL,G1H2(56),23,nMT,G2H2(684),n2h2(497))
call HGT_OLR(G1H8(227),1,1,8)
call HGT_invQ_OLR(G1H8(227),2,5,8)
  call Hloop_Q_A(ntryL,G1H8(227),-8,nMT,G2H8(22),n2h8(332))
  call Hloop_QV_A(ntryL,G2H8(22),ex4(:),G2H4(177),m3h2x4(:,422),heltab2x8(:,:,629))
  call Hloop_AV_Q(ntryL,G1H8(229),wf4(:,13),G1H2(62),m3h4x2(:,208),heltab2x8(:,:,630))
  call Hloop_A_Q(ntryL,G1H2(62),23,nMT,G2H2(685),n2h2(498))
  call Hloop_AV_Q(ntryL,G1H8(230),wf4(:,13),G1H2(74),m3h4x2(:,209),heltab2x8(:,:,631))
  call Hloop_A_Q(ntryL,G1H2(74),23,nMT,G2H2(686),n2h2(499))
  call Hloop_AV_Q(ntryL,G0H8(49),wf4(:,13),G0H2(1),m3h4x2(:,210),heltab2x8(:,:,632))
  call Hloop_A_Q(ntryL,G0H2(1),23,nMT,G1H2(80),n2h2(500))
  call Hloop_QV_A(ntryL,G1H8(231),wf4(:,13),G1H2(86),m3h4x2(:,211),heltab2x8(:,:,633))
  call Hloop_Q_A(ntryL,G1H2(86),23,nMB,G2H2(687),n2h2(501))
call HGT_OLR(G1H8(232),1,1,8)
call HGT_invQ_OLR(G1H8(232),2,5,8)
  call Hloop_A_Q(ntryL,G1H8(232),-8,nMB,G2H8(23),n2h8(333))
  call Hloop_AV_Q(ntryL,G2H8(23),ex4(:),G2H4(176),m3h2x4(:,423),heltab2x8(:,:,634))
  call Hloop_QV_A(ntryL,G1H8(234),wf4(:,13),G1H2(98),m3h4x2(:,212),heltab2x8(:,:,635))
  call Hloop_Q_A(ntryL,G1H2(98),23,nMB,G2H2(688),n2h2(502))
  call Hloop_QV_A(ntryL,G1H8(235),wf4(:,13),G1H2(104),m3h4x2(:,213),heltab2x8(:,:,636))
  call Hloop_Q_A(ntryL,G1H2(104),23,nMB,G2H2(689),n2h2(503))
  call Hloop_QV_A(ntryL,G0H8(50),wf4(:,13),G0H2(1),m3h4x2(:,214),heltab2x8(:,:,637))
  call Hloop_Q_A(ntryL,G0H2(1),23,nMB,G1H2(110),n2h2(504))
  call Hloop_AV_Q(ntryL,G1H8(236),wf4(:,13),G1H2(142),m3h4x2(:,215),heltab2x8(:,:,638))
  call Hloop_A_Q(ntryL,G1H2(142),23,nMB,G2H2(690),n2h2(505))
call HGT_OLR(G1H8(237),1,1,8)
call HGT_invQ_OLR(G1H8(237),2,5,8)
  call Hloop_Q_A(ntryL,G1H8(237),-8,nMB,G2H8(24),n2h8(334))
  call Hloop_QV_A(ntryL,G2H8(24),ex4(:),G2H4(174),m3h2x4(:,424),heltab2x8(:,:,639))
  call Hloop_AV_Q(ntryL,G1H8(239),wf4(:,13),G1H2(153),m3h4x2(:,216),heltab2x8(:,:,640))
  call Hloop_A_Q(ntryL,G1H2(153),23,nMB,G2H2(691),n2h2(506))
  call Hloop_AV_Q(ntryL,G1H8(240),wf4(:,13),G1H2(164),m3h4x2(:,217),heltab2x8(:,:,641))
  call Hloop_A_Q(ntryL,G1H2(164),23,nMB,G2H2(692),n2h2(507))
  call Hloop_AV_Q(ntryL,G0H8(51),wf4(:,13),G0H2(1),m3h4x2(:,218),heltab2x8(:,:,642))
  call Hloop_A_Q(ntryL,G0H2(1),23,nMB,G1H2(186),n2h2(508))
  call Hloop_QZ_A(ntryL,G1H8(241),wf4(:,14),G1H2(197),ngZl,m3h4x2(:,219),heltab2x8(:,:,643))
  call Hloop_Q_A(ntryL,G1H2(197),23,nME,G2H2(693),n2h2(509))
call HGT_OLR(G1H8(242),1,1,8)
call HGT_invQ_OLR(G1H8(242),2,5,8)
  call Hloop_A_Q(ntryL,G1H8(242),-8,nME,G2H8(25),n2h8(335))
  call Hloop_AV_Q(ntryL,G2H8(25),ex4(:),G2H4(96),m3h2x4(:,425),heltab2x8(:,:,644))
  call Hloop_QZ_A(ntryL,G1H8(244),wf4(:,14),G1H2(208),ngZl,m3h4x2(:,220),heltab2x8(:,:,645))
  call Hloop_Q_A(ntryL,G1H2(208),23,nME,G2H2(694),n2h2(510))
  call Hloop_QZ_A(ntryL,G1H8(245),wf4(:,14),G1H2(252),ngZl,m3h4x2(:,221),heltab2x8(:,:,646))
  call Hloop_Q_A(ntryL,G1H2(252),23,nME,G2H2(695),n2h2(511))
  call Hloop_QZ_A(ntryL,G0H8(52),wf4(:,14),G0H2(1),ngZl,m3h4x2(:,222),heltab2x8(:,:,647))
  call Hloop_Q_A(ntryL,G0H2(1),23,nME,G1H2(263),n2h2(512))
  call Hloop_QZ_A(ntryL,G1H8(246),wf4(:,14),G1H2(274),ngZl,m3h4x2(:,223),heltab2x8(:,:,648))
  call Hloop_Q_A(ntryL,G1H2(274),23,nMM,G2H2(696),n2h2(513))
call HGT_OLR(G1H8(247),1,1,8)
call HGT_invQ_OLR(G1H8(247),2,5,8)
  call Hloop_A_Q(ntryL,G1H8(247),-8,nMM,G2H8(26),n2h8(336))
  call Hloop_AV_Q(ntryL,G2H8(26),ex4(:),G2H4(97),m3h2x4(:,426),heltab2x8(:,:,649))
  call Hloop_QZ_A(ntryL,G1H8(249),wf4(:,14),G1H2(296),ngZl,m3h4x2(:,224),heltab2x8(:,:,650))
  call Hloop_Q_A(ntryL,G1H2(296),23,nMM,G2H2(697),n2h2(514))
  call Hloop_QZ_A(ntryL,G1H8(250),wf4(:,14),G1H2(312),ngZl,m3h4x2(:,225),heltab2x8(:,:,651))
  call Hloop_Q_A(ntryL,G1H2(312),23,nMM,G2H2(698),n2h2(515))
  call Hloop_QZ_A(ntryL,G0H8(18),wf4(:,14),G0H2(1),ngZl,m3h4x2(:,226),heltab2x8(:,:,652))
  call Hloop_Q_A(ntryL,G0H2(1),23,nMM,G1H2(328),n2h2(516))
  call Hloop_QZ_A(ntryL,G1H8(251),wf4(:,14),G1H2(350),ngZl,m3h4x2(:,227),heltab2x8(:,:,653))
  call Hloop_Q_A(ntryL,G1H2(350),23,nML,G2H2(699),n2h2(517))
call HGT_OLR(G1H8(252),1,1,8)
call HGT_invQ_OLR(G1H8(252),2,5,8)
  call Hloop_A_Q(ntryL,G1H8(252),-8,nML,G2H8(27),n2h8(337))
  call Hloop_AV_Q(ntryL,G2H8(27),ex4(:),G2H4(138),m3h2x4(:,427),heltab2x8(:,:,654))
  call Hloop_QZ_A(ntryL,G1H8(254),wf4(:,14),G1H2(361),ngZl,m3h4x2(:,228),heltab2x8(:,:,655))
  call Hloop_Q_A(ntryL,G1H2(361),23,nML,G2H2(700),n2h2(518))
  call Hloop_QZ_A(ntryL,G1H8(255),wf4(:,14),G1H2(372),ngZl,m3h4x2(:,229),heltab2x8(:,:,656))
  call Hloop_Q_A(ntryL,G1H2(372),23,nML,G2H2(701),n2h2(519))
  call Hloop_QZ_A(ntryL,G0H8(11),wf4(:,14),G0H2(1),ngZl,m3h4x2(:,230),heltab2x8(:,:,657))
  call Hloop_Q_A(ntryL,G0H2(1),23,nML,G1H2(394),n2h2(520))
  call Hloop_AZ_Q(ntryL,G1H8(256),wf4(:,14),G1H2(410),ngZl,m3h4x2(:,231),heltab2x8(:,:,658))
  call Hloop_A_Q(ntryL,G1H2(410),23,nME,G2H2(702),n2h2(521))
call HGT_OLR(G1H8(257),1,1,8)
call HGT_invQ_OLR(G1H8(257),2,5,8)
  call Hloop_Q_A(ntryL,G1H8(257),-8,nME,G2H8(28),n2h8(338))
  call Hloop_QV_A(ntryL,G2H8(28),ex4(:),G2H4(118),m3h2x4(:,428),heltab2x8(:,:,659))
  call Hloop_AZ_Q(ntryL,G1H8(259),wf4(:,14),G1H2(426),ngZl,m3h4x2(:,232),heltab2x8(:,:,660))
  call Hloop_A_Q(ntryL,G1H2(426),23,nME,G2H2(703),n2h2(522))
  call Hloop_AZ_Q(ntryL,G1H8(260),wf4(:,14),G1H2(448),ngZl,m3h4x2(:,233),heltab2x8(:,:,661))
  call Hloop_A_Q(ntryL,G1H2(448),23,nME,G2H2(704),n2h2(523))
  call Hloop_AZ_Q(ntryL,G0H8(1),wf4(:,14),G0H2(1),ngZl,m3h4x2(:,234),heltab2x8(:,:,662))
  call Hloop_A_Q(ntryL,G0H2(1),23,nME,G1H2(464),n2h2(524))
  call Hloop_AZ_Q(ntryL,G1H8(261),wf4(:,14),G1H2(480),ngZl,m3h4x2(:,235),heltab2x8(:,:,663))
  call Hloop_A_Q(ntryL,G1H2(480),23,nMM,G2H2(705),n2h2(525))
call HGT_OLR(G1H8(262),1,1,8)
call HGT_invQ_OLR(G1H8(262),2,5,8)
  call Hloop_Q_A(ntryL,G1H8(262),-8,nMM,G2H8(29),n2h8(339))
  call Hloop_QV_A(ntryL,G2H8(29),ex4(:),G2H4(141),m3h2x4(:,429),heltab2x8(:,:,664))
  call Hloop_AZ_Q(ntryL,G1H8(264),wf4(:,14),G1H2(502),ngZl,m3h4x2(:,236),heltab2x8(:,:,665))
  call Hloop_A_Q(ntryL,G1H2(502),23,nMM,G2H2(706),n2h2(526))
  call Hloop_AZ_Q(ntryL,G1H8(265),wf4(:,14),G1H2(518),ngZl,m3h4x2(:,237),heltab2x8(:,:,666))
  call Hloop_A_Q(ntryL,G1H2(518),23,nMM,G2H2(707),n2h2(527))
  call Hloop_AZ_Q(ntryL,G0H8(2),wf4(:,14),G0H2(1),ngZl,m3h4x2(:,238),heltab2x8(:,:,667))
  call Hloop_A_Q(ntryL,G0H2(1),23,nMM,G1H2(534),n2h2(528))
  call Hloop_AZ_Q(ntryL,G1H8(266),wf4(:,14),G1H2(556),ngZl,m3h4x2(:,239),heltab2x8(:,:,668))
  call Hloop_A_Q(ntryL,G1H2(556),23,nML,G2H2(708),n2h2(529))
call HGT_OLR(G1H8(267),1,1,8)
call HGT_invQ_OLR(G1H8(267),2,5,8)
  call Hloop_Q_A(ntryL,G1H8(267),-8,nML,G2H8(32),n2h8(340))
  call Hloop_QV_A(ntryL,G2H8(32),ex4(:),G2H4(122),m3h2x4(:,430),heltab2x8(:,:,669))
  call Hloop_AZ_Q(ntryL,G1H8(269),wf4(:,14),G1H2(577),ngZl,m3h4x2(:,240),heltab2x8(:,:,670))
  call Hloop_A_Q(ntryL,G1H2(577),23,nML,G2H2(709),n2h2(530))
  call Hloop_AZ_Q(ntryL,G1H8(270),wf4(:,14),G1H2(21),ngZl,m3h4x2(:,241),heltab2x8(:,:,671))
  call Hloop_A_Q(ntryL,G1H2(21),23,nML,G2H2(710),n2h2(531))
  call Hloop_AZ_Q(ntryL,G0H8(14),wf4(:,14),G0H2(1),ngZl,m3h4x2(:,242),heltab2x8(:,:,672))
  call Hloop_A_Q(ntryL,G0H2(1),23,nML,G1H2(117),n2h2(532))
  call Hloop_QZ_A(ntryL,G1H8(271),wf4(:,14),G1H2(27),ngZu,m3h4x2(:,243),heltab2x8(:,:,673))
  call Hloop_Q_A(ntryL,G1H2(27),23,0,G2H2(711),n2h2(533))
call HGT_OLR(G1H8(272),1,1,8)
call HGT_invQ_OLR(G1H8(272),2,5,8)
  call Hloop_A_Q(ntryL,G1H8(272),-8,0,G2H8(30),n2h8(341))
  call Hloop_AV_Q(ntryL,G2H8(30),ex4(:),G2H4(36),m3h2x4(:,431),heltab2x8(:,:,674))
  call Hloop_QZ_A(ntryL,G1H8(274),wf4(:,14),G1H2(28),ngZu,m3h4x2(:,244),heltab2x8(:,:,675))
  call Hloop_Q_A(ntryL,G1H2(28),23,0,G2H2(712),n2h2(534))
  call Hloop_QZ_A(ntryL,G1H8(275),wf4(:,14),G1H2(302),ngZu,m3h4x2(:,245),heltab2x8(:,:,676))
  call Hloop_Q_A(ntryL,G1H2(302),23,0,G2H2(713),n2h2(535))
  call Hloop_QZ_A(ntryL,G0H8(9),wf4(:,14),G0H2(1),ngZu,m3h4x2(:,246),heltab2x8(:,:,677))
  call Hloop_Q_A(ntryL,G0H2(1),23,0,G1H2(39),n2h2(536))
  call Hloop_QZ_A(ntryL,G1H8(276),wf4(:,14),G1H2(40),ngZu,m3h4x2(:,247),heltab2x8(:,:,678))
  call Hloop_Q_A(ntryL,G1H2(40),23,nMT,G2H2(714),n2h2(537))
call HGT_OLR(G1H8(277),1,1,8)
call HGT_invQ_OLR(G1H8(277),2,5,8)
  call Hloop_A_Q(ntryL,G1H8(277),-8,nMT,G2H8(31),n2h8(342))
  call Hloop_AV_Q(ntryL,G2H8(31),ex4(:),G2H4(195),m3h2x4(:,432),heltab2x8(:,:,679))
  call Hloop_QZ_A(ntryL,G1H8(279),wf4(:,14),G1H2(45),ngZu,m3h4x2(:,248),heltab2x8(:,:,680))
  call Hloop_Q_A(ntryL,G1H2(45),23,nMT,G2H2(715),n2h2(538))
  call Hloop_QZ_A(ntryL,G1H8(280),wf4(:,14),G1H2(46),ngZu,m3h4x2(:,249),heltab2x8(:,:,681))
  call Hloop_Q_A(ntryL,G1H2(46),23,nMT,G2H2(716),n2h2(539))
  call Hloop_QZ_A(ntryL,G0H8(12),wf4(:,14),G0H2(1),ngZu,m3h4x2(:,250),heltab2x8(:,:,682))
  call Hloop_Q_A(ntryL,G0H2(1),23,nMT,G1H2(127),n2h2(540))
  call Hloop_AZ_Q(ntryL,G1H8(281),wf4(:,14),G1H2(52),ngZu,m3h4x2(:,251),heltab2x8(:,:,683))
  call Hloop_A_Q(ntryL,G1H2(52),23,0,G2H2(717),n2h2(541))
call HGT_OLR(G1H8(282),1,1,8)
call HGT_invQ_OLR(G1H8(282),2,5,8)
  call Hloop_Q_A(ntryL,G1H8(282),-8,0,G2H8(35),n2h8(343))
  call Hloop_QV_A(ntryL,G2H8(35),ex4(:),G2H4(181),m3h2x4(:,433),heltab2x8(:,:,684))
  call Hloop_AZ_Q(ntryL,G1H8(284),wf4(:,14),G1H2(132),ngZu,m3h4x2(:,252),heltab2x8(:,:,685))
  call Hloop_A_Q(ntryL,G1H2(132),23,0,G2H2(718),n2h2(542))
  call Hloop_AZ_Q(ntryL,G1H8(285),wf4(:,14),G1H2(57),ngZu,m3h4x2(:,253),heltab2x8(:,:,686))
  call Hloop_A_Q(ntryL,G1H2(57),23,0,G2H2(719),n2h2(543))
  call Hloop_AZ_Q(ntryL,G0H8(13),wf4(:,14),G0H2(1),ngZu,m3h4x2(:,254),heltab2x8(:,:,687))
  call Hloop_A_Q(ntryL,G0H2(1),23,0,G1H2(100),n2h2(544))
  call Hloop_AZ_Q(ntryL,G1H8(286),wf4(:,14),G1H2(567),ngZu,m3h4x2(:,255),heltab2x8(:,:,688))
  call Hloop_A_Q(ntryL,G1H2(567),23,nMT,G2H2(720),n2h2(545))
call HGT_OLR(G1H8(287),1,1,8)
call HGT_invQ_OLR(G1H8(287),2,5,8)
  call Hloop_Q_A(ntryL,G1H8(287),-8,nMT,G2H8(36),n2h8(344))
  call Hloop_QV_A(ntryL,G2H8(36),ex4(:),G2H4(37),m3h2x4(:,434),heltab2x8(:,:,689))
  call Hloop_AZ_Q(ntryL,G1H8(289),wf4(:,14),G1H2(105),ngZu,m3h4x2(:,256),heltab2x8(:,:,690))
  call Hloop_A_Q(ntryL,G1H2(105),23,nMT,G2H2(721),n2h2(546))
  call Hloop_AZ_Q(ntryL,G1H8(290),wf4(:,14),G1H2(583),ngZu,m3h4x2(:,257),heltab2x8(:,:,691))
  call Hloop_A_Q(ntryL,G1H2(583),23,nMT,G2H2(722),n2h2(547))
  call Hloop_AZ_Q(ntryL,G0H8(3),wf4(:,14),G0H2(1),ngZu,m3h4x2(:,258),heltab2x8(:,:,692))
  call Hloop_A_Q(ntryL,G0H2(1),23,nMT,G1H2(111),n2h2(548))
  call Hloop_QZ_A(ntryL,G1H8(291),wf4(:,14),G1H2(112),ngZd,m3h4x2(:,259),heltab2x8(:,:,693))
  call Hloop_Q_A(ntryL,G1H2(112),23,0,G2H2(723),n2h2(549))
call HGT_OLR(G1H8(292),1,1,8)
call HGT_invQ_OLR(G1H8(292),2,5,8)
  call Hloop_A_Q(ntryL,G1H8(292),-8,0,G2H8(41),n2h8(345))
  call Hloop_AV_Q(ntryL,G2H8(41),ex4(:),G2H4(196),m3h2x4(:,435),heltab2x8(:,:,694))
  call Hloop_QZ_A(ntryL,G1H8(294),wf4(:,14),G1H2(118),ngZd,m3h4x2(:,260),heltab2x8(:,:,695))
  call Hloop_Q_A(ntryL,G1H2(118),23,0,G2H2(724),n2h2(550))
  call Hloop_QZ_A(ntryL,G1H8(295),wf4(:,14),G1H2(123),ngZd,m3h4x2(:,261),heltab2x8(:,:,696))
  call Hloop_Q_A(ntryL,G1H2(123),23,0,G2H2(725),n2h2(551))
  call Hloop_QZ_A(ntryL,G0H8(4),wf4(:,14),G0H2(1),ngZd,m3h4x2(:,262),heltab2x8(:,:,697))
  call Hloop_Q_A(ntryL,G0H2(1),23,0,G1H2(128),n2h2(552))
  call Hloop_QZ_A(ntryL,G1H8(296),wf4(:,14),G1H2(137),ngZd,m3h4x2(:,263),heltab2x8(:,:,698))
  call Hloop_Q_A(ntryL,G1H2(137),23,nMB,G2H2(726),n2h2(553))
call HGT_OLR(G1H8(297),1,1,8)
call HGT_invQ_OLR(G1H8(297),2,5,8)
  call Hloop_A_Q(ntryL,G1H8(297),-8,nMB,G2H8(39),n2h8(346))
  call Hloop_AV_Q(ntryL,G2H8(39),ex4(:),G2H4(182),m3h2x4(:,436),heltab2x8(:,:,699))
  call Hloop_QZ_A(ntryL,G1H8(299),wf4(:,14),G1H2(138),ngZd,m3h4x2(:,264),heltab2x8(:,:,700))
  call Hloop_Q_A(ntryL,G1H2(138),23,nMB,G2H2(727),n2h2(554))
  call Hloop_QZ_A(ntryL,G1H8(300),wf4(:,14),G1H2(143),ngZd,m3h4x2(:,265),heltab2x8(:,:,701))
  call Hloop_Q_A(ntryL,G1H2(143),23,nMB,G2H2(728),n2h2(555))
  call Hloop_QZ_A(ntryL,G0H8(5),wf4(:,14),G0H2(1),ngZd,m3h4x2(:,266),heltab2x8(:,:,702))
  call Hloop_Q_A(ntryL,G0H2(1),23,nMB,G1H2(148),n2h2(556))
  call Hloop_AZ_Q(ntryL,G1H8(301),wf4(:,14),G1H2(149),ngZd,m3h4x2(:,267),heltab2x8(:,:,703))
  call Hloop_A_Q(ntryL,G1H2(149),23,0,G2H2(729),n2h2(557))
call HGT_OLR(G1H8(302),1,1,8)
call HGT_invQ_OLR(G1H8(302),2,5,8)
  call Hloop_Q_A(ntryL,G1H8(302),-8,0,G2H8(42),n2h8(347))
  call Hloop_QV_A(ntryL,G2H8(42),ex4(:),G2H4(50),m3h2x4(:,437),heltab2x8(:,:,704))
  call Hloop_AZ_Q(ntryL,G1H8(304),wf4(:,14),G1H2(154),ngZd,m3h4x2(:,268),heltab2x8(:,:,705))
  call Hloop_A_Q(ntryL,G1H2(154),23,0,G2H2(730),n2h2(558))
  call Hloop_AZ_Q(ntryL,G1H8(305),wf4(:,14),G1H2(159),ngZd,m3h4x2(:,269),heltab2x8(:,:,706))
  call Hloop_A_Q(ntryL,G1H2(159),23,0,G2H2(731),n2h2(559))
  call Hloop_AZ_Q(ntryL,G0H8(7),wf4(:,14),G0H2(1),ngZd,m3h4x2(:,270),heltab2x8(:,:,707))
  call Hloop_A_Q(ntryL,G0H2(1),23,0,G1H2(160),n2h2(560))
  call Hloop_AZ_Q(ntryL,G1H8(306),wf4(:,14),G1H2(165),ngZd,m3h4x2(:,271),heltab2x8(:,:,708))
  call Hloop_A_Q(ntryL,G1H2(165),23,nMB,G2H2(732),n2h2(561))
call HGT_OLR(G1H8(307),1,1,8)
call HGT_invQ_OLR(G1H8(307),2,5,8)
  call Hloop_Q_A(ntryL,G1H8(307),-8,nMB,G2H8(43),n2h8(348))
  call Hloop_QV_A(ntryL,G2H8(43),ex4(:),G2H4(198),m3h2x4(:,438),heltab2x8(:,:,709))
  call Hloop_AZ_Q(ntryL,G1H8(309),wf4(:,14),G1H2(214),ngZd,m3h4x2(:,272),heltab2x8(:,:,710))
  call Hloop_A_Q(ntryL,G1H2(214),23,nMB,G2H2(733),n2h2(562))
  call Hloop_AZ_Q(ntryL,G1H8(310),wf4(:,14),G1H2(220),ngZd,m3h4x2(:,273),heltab2x8(:,:,711))
  call Hloop_A_Q(ntryL,G1H2(220),23,nMB,G2H2(734),n2h2(563))
  call Hloop_AZ_Q(ntryL,G0H8(20),wf4(:,14),G0H2(1),ngZd,m3h4x2(:,274),heltab2x8(:,:,712))
  call Hloop_A_Q(ntryL,G0H2(1),23,nMB,G1H2(221),n2h2(564))
  call Hloop_TV_S(ntryL,G1H8(311),20,wf4(:,13),3,G2H2(735),m3h4x2(:,275),heltab2x8(:,:,713))
call HGT_OLR(G1H8(312),1,1,8)
call HGT_invQ_OLR(G1H8(312),2,5,8)
  call Hloop_SV_T(ntryL,G1H8(312),-8,ex4(:),8,G2H4(183),m3h2x4(:,439),heltab2x8(:,:,714))
  call Hloop_TV_S(ntryL,G1H8(314),20,wf4(:,13),3,G2H2(736),m3h4x2(:,276),heltab2x8(:,:,715))
  call Hloop_TV_S(ntryL,G1H8(315),20,wf4(:,13),3,G2H2(737),m3h4x2(:,277),heltab2x8(:,:,716))
  call Hloop_TV_S(ntryL,G0H8(53),20,wf4(:,13),3,G1H2(231),m3h4x2(:,278),heltab2x8(:,:,717))
  call Hloop_SV_T(ntryL,G1H8(316),20,wf4(:,13),3,G2H2(738),m3h4x2(:,279),heltab2x8(:,:,718))
call HGT_OLR(G1H8(317),1,1,8)
call HGT_invQ_OLR(G1H8(317),2,5,8)
  call Hloop_TV_S(ntryL,G1H8(317),-8,ex4(:),8,G2H4(51),m3h2x4(:,440),heltab2x8(:,:,719))
  call Hloop_SV_T(ntryL,G1H8(319),20,wf4(:,13),3,G2H2(739),m3h4x2(:,280),heltab2x8(:,:,720))
  call Hloop_SV_T(ntryL,G1H8(320),20,wf4(:,13),3,G2H2(740),m3h4x2(:,281),heltab2x8(:,:,721))
  call Hloop_SV_T(ntryL,G0H8(15),20,wf4(:,13),3,G1H2(232),m3h4x2(:,282),heltab2x8(:,:,722))
  call Hloop_TV_S(ntryL,G1H8(321),20,wf4(:,14),3,G2H2(741),m3h4x2(:,283),heltab2x8(:,:,723))
call HGT_OLR(G1H8(322),1,1,8)
call HGT_invQ_OLR(G1H8(322),2,5,8)
  call Hloop_SV_T(ntryL,G1H8(322),-8,ex4(:),8,G2H4(199),m3h2x4(:,441),heltab2x8(:,:,724))
  call Hloop_TV_S(ntryL,G1H8(324),20,wf4(:,14),3,G2H2(742),m3h4x2(:,284),heltab2x8(:,:,725))
  call Hloop_TV_S(ntryL,G1H8(325),20,wf4(:,14),3,G2H2(743),m3h4x2(:,285),heltab2x8(:,:,726))
  call Hloop_TV_S(ntryL,G0H8(16),20,wf4(:,14),3,G1H2(236),m3h4x2(:,286),heltab2x8(:,:,727))
  call Hloop_SV_T(ntryL,G1H8(326),20,wf4(:,14),3,G2H2(744),m3h4x2(:,287),heltab2x8(:,:,728))
call HGT_OLR(G1H8(327),1,1,8)
call HGT_invQ_OLR(G1H8(327),2,5,8)
  call Hloop_TV_S(ntryL,G1H8(327),-8,ex4(:),8,G2H4(185),m3h2x4(:,442),heltab2x8(:,:,729))
  call Hloop_SV_T(ntryL,G1H8(329),20,wf4(:,14),3,G2H2(745),m3h4x2(:,288),heltab2x8(:,:,730))
  call Hloop_SV_T(ntryL,G1H8(330),20,wf4(:,14),3,G2H2(746),m3h4x2(:,289),heltab2x8(:,:,731))
  call Hloop_SV_T(ntryL,G0H8(10),20,wf4(:,14),3,G1H2(243),m3h4x2(:,290),heltab2x8(:,:,732))
  call Hloop_CV_D(ntryL,G1H8(331),20,wf4(:,13),3,G2H2(747),m3h4x2(:,291),heltab2x8(:,:,733))
call HGT_OLR(G1H8(332),1,1,8)
call HGT_invQ_OLR(G1H8(332),2,5,8)
  call Hloop_DV_C(ntryL,G1H8(332),-8,ex4(:),G2H4(64),m3h2x4(:,443),heltab2x8(:,:,734))
  call Hloop_CV_D(ntryL,G1H8(334),20,wf4(:,13),3,G2H2(748),m3h4x2(:,292),heltab2x8(:,:,735))
  call Hloop_CV_D(ntryL,G1H8(335),20,wf4(:,13),3,G2H2(749),m3h4x2(:,293),heltab2x8(:,:,736))
  call Hloop_CV_D(ntryL,G0H8(19),20,wf4(:,13),3,G1H2(247),m3h4x2(:,294),heltab2x8(:,:,737))
  call Hloop_DV_C(ntryL,G1H8(336),20,wf4(:,13),G2H2(750),m3h4x2(:,295),heltab2x8(:,:,738))
call HGT_OLR(G1H8(337),1,1,8)
call HGT_invQ_OLR(G1H8(337),2,5,8)
  call Hloop_CV_D(ntryL,G1H8(337),-8,ex4(:),8,G2H4(200),m3h2x4(:,444),heltab2x8(:,:,739))
  call Hloop_DV_C(ntryL,G1H8(339),20,wf4(:,13),G2H2(751),m3h4x2(:,296),heltab2x8(:,:,740))
  call Hloop_DV_C(ntryL,G1H8(340),20,wf4(:,13),G2H2(752),m3h4x2(:,297),heltab2x8(:,:,741))
  call Hloop_DV_C(ntryL,G0H8(6),20,wf4(:,13),G1H2(253),m3h4x2(:,298),heltab2x8(:,:,742))
  call Hloop_CV_D(ntryL,G1H8(341),20,wf4(:,14),3,G2H2(753),m3h4x2(:,299),heltab2x8(:,:,743))
call HGT_OLR(G1H8(342),1,1,8)
call HGT_invQ_OLR(G1H8(342),2,5,8)
  call Hloop_DV_C(ntryL,G1H8(342),-8,ex4(:),G2H4(186),m3h2x4(:,445),heltab2x8(:,:,744))
  call Hloop_CV_D(ntryL,G1H8(344),20,wf4(:,14),3,G2H2(754),m3h4x2(:,300),heltab2x8(:,:,745))
  call Hloop_CV_D(ntryL,G1H8(345),20,wf4(:,14),3,G2H2(755),m3h4x2(:,301),heltab2x8(:,:,746))
  call Hloop_CV_D(ntryL,G0H8(8),20,wf4(:,14),3,G1H2(258),m3h4x2(:,302),heltab2x8(:,:,747))
  call Hloop_DV_C(ntryL,G1H8(346),20,wf4(:,14),G2H2(756),m3h4x2(:,303),heltab2x8(:,:,748))
call HGT_OLR(G1H8(347),1,1,8)
call HGT_invQ_OLR(G1H8(347),2,5,8)
  call Hloop_CV_D(ntryL,G1H8(347),-8,ex4(:),8,G2H4(65),m3h2x4(:,446),heltab2x8(:,:,749))
  call Hloop_DV_C(ntryL,G1H8(349),20,wf4(:,14),G2H2(757),m3h4x2(:,304),heltab2x8(:,:,750))
  call Hloop_DV_C(ntryL,G1H8(350),20,wf4(:,14),G2H2(758),m3h4x2(:,305),heltab2x8(:,:,751))
  call Hloop_DV_C(ntryL,G0H8(17),20,wf4(:,14),G1H2(264),m3h4x2(:,306),heltab2x8(:,:,752))
  call Hloop_UV_W(ntryL,G1H8(351),20,wf4(:,13),3,G2H2(759),m3h4x2(:,307),heltab2x8(:,:,753))
call HGT_raise_alpha_OLR(G1H8(352),1,1,8)
call HGT_raise_alpha_invQ_OLR(G1H8(352),2,5,8)
  call Hloop_UW_V(ntryL,G1H8(352),-8,ex4(:),8,G2H4(202),m3h2x4(:,447),heltab2x8(:,:,754))
  call Hloop_UV_W(ntryL,G1H8(354),20,wf4(:,13),3,G2H2(760),m3h4x2(:,308),heltab2x8(:,:,755))
  call Hloop_UV_W(ntryL,G1H8(355),20,wf4(:,13),3,G2H2(761),m3h4x2(:,309),heltab2x8(:,:,756))
  call Hloop_UV_W(ntryL,G0H8(54),20,wf4(:,13),3,G1H2(265),m3h4x2(:,310),heltab2x8(:,:,757))
  call Hloop_UW_V(ntryL,G1H8(356),20,wf4(:,13),3,G2H2(762),m3h4x2(:,311),heltab2x8(:,:,758))
call HGT_raise_alpha_OLR(G1H8(357),1,1,8)
call HGT_raise_alpha_invQ_OLR(G1H8(357),2,5,8)
  call Hloop_UV_W(ntryL,G1H8(357),-8,ex4(:),8,G2H4(187),m3h2x4(:,448),heltab2x8(:,:,759))
  call Hloop_UW_V(ntryL,G1H8(359),20,wf4(:,13),3,G2H2(763),m3h4x2(:,312),heltab2x8(:,:,760))
  call Hloop_UW_V(ntryL,G1H8(360),20,wf4(:,13),3,G2H2(764),m3h4x2(:,313),heltab2x8(:,:,761))
  call Hloop_UW_V(ntryL,G0H8(55),20,wf4(:,13),3,G1H2(275),m3h4x2(:,314),heltab2x8(:,:,762))
  call Hloop_UV_W(ntryL,G1H8(361),20,wf4(:,14),3,G2H2(765),m3h4x2(:,315),heltab2x8(:,:,763))
call HGT_raise_alpha_OLR(G1H8(362),1,1,8)
call HGT_raise_alpha_invQ_OLR(G1H8(362),2,5,8)
  call Hloop_UW_V(ntryL,G1H8(362),-8,ex4(:),8,G2H4(217),m3h2x4(:,449),heltab2x8(:,:,764))
  call Hloop_UV_W(ntryL,G1H8(364),20,wf4(:,14),3,G2H2(766),m3h4x2(:,316),heltab2x8(:,:,765))
  call Hloop_UV_W(ntryL,G1H8(365),20,wf4(:,14),3,G2H2(767),m3h4x2(:,317),heltab2x8(:,:,766))
  call Hloop_UV_W(ntryL,G0H8(56),20,wf4(:,14),3,G1H2(276),m3h4x2(:,318),heltab2x8(:,:,767))
  call Hloop_UW_V(ntryL,G1H8(366),20,wf4(:,14),3,G2H2(768),m3h4x2(:,319),heltab2x8(:,:,768))
call HGT_raise_alpha_OLR(G1H8(367),1,1,8)
call HGT_raise_alpha_invQ_OLR(G1H8(367),2,5,8)
  call Hloop_UV_W(ntryL,G1H8(367),-8,ex4(:),8,G2H4(218),m3h2x4(:,450),heltab2x8(:,:,769))
  call Hloop_UW_V(ntryL,G1H8(369),20,wf4(:,14),3,G2H2(769),m3h4x2(:,320),heltab2x8(:,:,770))
  call Hloop_UW_V(ntryL,G1H8(370),20,wf4(:,14),3,G2H2(770),m3h4x2(:,321),heltab2x8(:,:,771))
  call Hloop_UW_V(ntryL,G0H8(58),20,wf4(:,14),3,G1H2(280),m3h4x2(:,322),heltab2x8(:,:,772))
  call Hloop_AV_Q(ntryL,G1H8(162),ex4(:),G1H4(137),m3h2x4(:,451),heltab2x8(:,:,773))
  call Hloop_A_Q(ntryL,G1H4(137),26,nMB,G2H4(209),n2h4(453))
call HGT_OLR(G1H8(163),1,1,8)
call HGT_invQ_OLR(G1H8(163),2,5,8)
  call Hloop_SQ_A(ntryL,G1H8(163),wf4(:,3),G1H2(287),ngPbt,m3h4x2(:,323),heltab2x8(:,:,774))
  call Hloop_AV_Q(ntryL,G1H8(165),ex4(:),G1H4(142),m3h2x4(:,452),heltab2x8(:,:,775))
  call Hloop_A_Q(ntryL,G1H4(142),26,nMB,G2H4(211),n2h4(454))
  call Hloop_AV_Q(ntryL,G1H8(166),ex4(:),G1H4(149),m3h2x4(:,453),heltab2x8(:,:,776))
  call Hloop_A_Q(ntryL,G1H4(149),26,nMB,G2H4(227),n2h4(455))
  call Hloop_AV_Q(ntryL,G1H8(168),ex4(:),G1H4(150),m3h2x4(:,454),heltab2x8(:,:,777))
  call Hloop_A_Q(ntryL,G1H4(150),26,nMB,G2H4(226),n2h4(456))
call HGT_raise_alpha_OLR(G1H8(169),1,1,8)
call HGT_raise_alpha_invQ_OLR(G1H8(169),2,5,8)
  call Hloop_WQ_A(ntryL,G1H8(169),wf4(:,3),G1H2(291),m3h4x2(:,324),heltab2x8(:,:,778))
  call Hloop_AV_Q(ntryL,G1H8(115),ex4(:),G1H4(405),m3h2x4(:,455),heltab2x8(:,:,779))
  call Hloop_A_Q(ntryL,G1H4(405),26,nMB,G2H4(225),n2h4(457))
  call Hloop_AV_Q(ntryL,G1H8(171),ex4(:),G1H4(6),m3h2x4(:,456),heltab2x8(:,:,780))
  call Hloop_A_Q(ntryL,G1H4(6),26,nMB,G2H4(231),n2h4(458))
  call Hloop_QV_A(ntryL,G1H8(173),ex4(:),G1H4(5),m3h2x4(:,457),heltab2x8(:,:,781))
  call Hloop_Q_A(ntryL,G1H4(5),25,nMB,G2H4(230),n2h4(459))
call HGT_OLR(G1H8(174),1,1,8)
call HGT_invQ_OLR(G1H8(174),2,5,8)
  call Hloop_SA_Q(ntryL,G1H8(174),wf4(:,10),G1H2(297),ngPtb,m3h4x2(:,325),heltab2x8(:,:,782))
  call Hloop_QV_A(ntryL,G1H8(96),ex4(:),G1H4(1),m3h2x4(:,458),heltab2x8(:,:,783))
  call Hloop_Q_A(ntryL,G1H4(1),25,nMB,G2H4(229),n2h4(460))
  call Hloop_QV_A(ntryL,G1H8(114),ex4(:),G1H4(4),m3h2x4(:,459),heltab2x8(:,:,784))
  call Hloop_Q_A(ntryL,G1H4(4),25,nMB,G2H4(31),n2h4(461))
  call Hloop_QV_A(ntryL,G1H8(7),ex4(:),G1H4(8),m3h2x4(:,460),heltab2x8(:,:,785))
  call Hloop_Q_A(ntryL,G1H4(8),25,nMB,G2H4(32),n2h4(462))
call HGT_raise_alpha_OLR(G1H8(83),1,1,8)
call HGT_raise_alpha_invQ_OLR(G1H8(83),2,5,8)
  call Hloop_WA_Q(ntryL,G1H8(83),wf4(:,10),G1H2(303),m3h4x2(:,326),heltab2x8(:,:,786))
  call Hloop_QV_A(ntryL,G1H8(4),ex4(:),G1H4(15),m3h2x4(:,461),heltab2x8(:,:,787))
  call Hloop_Q_A(ntryL,G1H4(15),25,nMB,G2H4(17),n2h4(463))
  call Hloop_QV_A(ntryL,G1H8(27),ex4(:),G1H4(34),m3h2x4(:,462),heltab2x8(:,:,788))
  call Hloop_Q_A(ntryL,G1H4(34),25,nMB,G2H4(1),n2h4(464))
  call Hloop_AV_Q(ntryL,G1H8(39),ex3(:),G1H4(35),m3h2x4(:,463),heltab2x8(:,:,789))
  call Hloop_A_Q(ntryL,G1H4(35),22,nMB,G2H4(15),n2h4(465))
call HGT_OLR(G1H8(55),1,1,8)
call HGT_invQ_OLR(G1H8(55),2,5,8)
  call Hloop_SQ_A(ntryL,G1H8(55),wf4(:,9),G1H2(308),ngPbt,m3h4x2(:,327),heltab2x8(:,:,790))
  call Hloop_AV_Q(ntryL,G1H8(85),ex3(:),G1H4(42),m3h2x4(:,464),heltab2x8(:,:,791))
  call Hloop_A_Q(ntryL,G1H4(42),22,nMB,G2H4(3),n2h4(466))
  call Hloop_AV_Q(ntryL,G1H8(38),ex3(:),G1H4(45),m3h2x4(:,465),heltab2x8(:,:,792))
  call Hloop_A_Q(ntryL,G1H4(45),22,nMB,G2H4(94),n2h4(467))
  call Hloop_AV_Q(ntryL,G1H8(37),ex3(:),G1H4(40),m3h2x4(:,466),heltab2x8(:,:,793))
  call Hloop_A_Q(ntryL,G1H4(40),22,nMB,G2H4(233),n2h4(468))
call HGT_raise_alpha_OLR(G1H8(120),1,1,8)
call HGT_raise_alpha_invQ_OLR(G1H8(120),2,5,8)
  call Hloop_WQ_A(ntryL,G1H8(120),wf4(:,9),G1H2(313),m3h4x2(:,328),heltab2x8(:,:,794))
  call Hloop_AV_Q(ntryL,G1H8(102),ex3(:),G1H4(41),m3h2x4(:,467),heltab2x8(:,:,795))
  call Hloop_A_Q(ntryL,G1H4(41),22,nMB,G2H4(234),n2h4(469))
  call Hloop_AV_Q(ntryL,G1H8(156),ex3(:),G1H4(46),m3h2x4(:,468),heltab2x8(:,:,796))
  call Hloop_A_Q(ntryL,G1H4(46),22,nMB,G2H4(235),n2h4(470))
  call Hloop_SA_Q(ntryL,G1H8(161),ex2(:),G1H4(71),ngPtb,m3h2x4(:,469),heltab2x8(:,:,797))
  call Hloop_A_Q(ntryL,G1H4(71),22,nMB,G2H4(107),n2h4(471))
call HGT_OLR(G1H8(167),1,1,8)
call HGT_invQ_OLR(G1H8(167),2,5,8)
  call Hloop_SQ_A(ntryL,G1H8(167),wf4(:,9),G1H2(323),ngPbt,m3h4x2(:,329),heltab2x8(:,:,798))
  call Hloop_SA_Q(ntryL,G1H8(79),ex2(:),G1H4(72),ngPtb,m3h2x4(:,470),heltab2x8(:,:,799))
  call Hloop_A_Q(ntryL,G1H4(72),22,nMB,G2H4(236),n2h4(472))
  call Hloop_SA_Q(ntryL,G1H8(84),ex2(:),G1H4(75),ngPtb,m3h2x4(:,471),heltab2x8(:,:,800))
  call Hloop_A_Q(ntryL,G1H4(75),22,nMB,G2H4(112),n2h4(473))
  call Hloop_WA_Q(ntryL,G1H8(93),ex2(:),G1H4(76),m3h2x4(:,472),heltab2x8(:,:,801))
  call Hloop_A_Q(ntryL,G1H4(76),22,nMB,G2H4(237),n2h4(474))
call HGT_raise_alpha_OLR(G1H8(5),1,1,8)
call HGT_raise_alpha_invQ_OLR(G1H8(5),2,5,8)
  call Hloop_WQ_A(ntryL,G1H8(5),wf4(:,9),G1H2(324),m3h4x2(:,330),heltab2x8(:,:,802))
  call Hloop_WA_Q(ntryL,G1H8(11),ex2(:),G1H4(295),m3h2x4(:,473),heltab2x8(:,:,803))
  call Hloop_A_Q(ntryL,G1H4(295),22,nMB,G2H4(238),n2h4(475))
  call Hloop_WA_Q(ntryL,G1H8(14),ex2(:),G1H4(296),m3h2x4(:,474),heltab2x8(:,:,804))
  call Hloop_A_Q(ntryL,G1H4(296),22,nMB,G2H4(239),n2h4(476))
  call Hloop_QV_A(ntryL,G1H8(128),ex3(:),G1H4(301),m3h2x4(:,475),heltab2x8(:,:,805))
  call Hloop_Q_A(ntryL,G1H4(301),21,nMB,G2H4(125),n2h4(477))
call HGT_OLR(G1H8(129),1,1,8)
call HGT_invQ_OLR(G1H8(129),2,5,8)
  call Hloop_SA_Q(ntryL,G1H8(129),wf4(:,4),G1H2(329),ngPtb,m3h4x2(:,331),heltab2x8(:,:,806))
  call Hloop_QV_A(ntryL,G1H8(131),ex3(:),G1H4(302),m3h2x4(:,476),heltab2x8(:,:,807))
  call Hloop_Q_A(ntryL,G1H4(302),21,nMB,G2H4(240),n2h4(478))
  call Hloop_QV_A(ntryL,G1H8(133),ex3(:),G1H4(389),m3h2x4(:,477),heltab2x8(:,:,808))
  call Hloop_Q_A(ntryL,G1H4(389),21,nMB,G2H4(130),n2h4(479))
  call Hloop_QV_A(ntryL,G1H8(135),ex3(:),G1H4(390),m3h2x4(:,478),heltab2x8(:,:,809))
  call Hloop_Q_A(ntryL,G1H4(390),21,nMB,G2H4(143),n2h4(480))
call HGT_raise_alpha_OLR(G1H8(94),1,1,8)
call HGT_raise_alpha_invQ_OLR(G1H8(94),2,5,8)
  call Hloop_WA_Q(ntryL,G1H8(94),wf4(:,4),G1H2(335),m3h4x2(:,332),heltab2x8(:,:,810))
  call Hloop_QV_A(ntryL,G1H8(97),ex3(:),G1H4(319),m3h2x4(:,479),heltab2x8(:,:,811))
  call Hloop_Q_A(ntryL,G1H4(319),21,nMB,G2H4(148),n2h4(481))
  call Hloop_QV_A(ntryL,G1H8(371),ex3(:),G1H4(320),m3h2x4(:,480),heltab2x8(:,:,812))
  call Hloop_Q_A(ntryL,G1H4(320),21,nMB,G2H4(149),n2h4(482))
  call Hloop_SQ_A(ntryL,G1H8(150),ex1(:),G1H4(325),ngPbt,m3h2x4(:,481),heltab2x8(:,:,813))
  call Hloop_Q_A(ntryL,G1H4(325),21,nMB,G2H4(153),n2h4(483))
call HGT_OLR(G1H8(151),1,1,8)
call HGT_invQ_OLR(G1H8(151),2,5,8)
  call Hloop_SA_Q(ntryL,G1H8(151),wf4(:,4),G1H2(340),ngPtb,m3h4x2(:,333),heltab2x8(:,:,814))
  call Hloop_SQ_A(ntryL,G1H8(372),ex1(:),G1H4(326),ngPbt,m3h2x4(:,482),heltab2x8(:,:,815))
  call Hloop_Q_A(ntryL,G1H4(326),21,nMB,G2H4(161),n2h4(484))
  call Hloop_SQ_A(ntryL,G1H8(373),ex1(:),G1H4(331),ngPbt,m3h2x4(:,483),heltab2x8(:,:,816))
  call Hloop_Q_A(ntryL,G1H4(331),21,nMB,G2H4(157),n2h4(485))
  call Hloop_WQ_A(ntryL,G1H8(99),ex1(:),G1H4(332),m3h2x4(:,484),heltab2x8(:,:,817))
  call Hloop_Q_A(ntryL,G1H4(332),21,nMB,G2H4(162),n2h4(486))
call HGT_raise_alpha_OLR(G1H8(117),1,1,8)
call HGT_raise_alpha_invQ_OLR(G1H8(117),2,5,8)
  call Hloop_WA_Q(ntryL,G1H8(117),wf4(:,4),G1H2(345),m3h4x2(:,334),heltab2x8(:,:,818))
  call Hloop_WQ_A(ntryL,G1H8(375),ex1(:),G1H4(337),m3h2x4(:,485),heltab2x8(:,:,819))
  call Hloop_Q_A(ntryL,G1H4(337),21,nMB,G2H4(166),n2h4(487))
  call Hloop_WQ_A(ntryL,G1H8(376),ex1(:),G1H4(338),m3h2x4(:,486),heltab2x8(:,:,820))
  call Hloop_Q_A(ntryL,G1H4(338),21,nMB,G2H4(179),n2h4(488))
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(741),[G2H2(735),G2H2(235),G2H2(231),G2H2(209),G2H2(29) &
    ,G1H2(88),G1H2(508),G1H2(25)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(648),[G2H2(645),G2H2(284),G2H2(281),G2H2(276),G2H2(273) &
    ,G2H2(253),G2H2(250),G2H2(39),G2H2(31),G1H2(82)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(654),[G2H2(651),G2H2(292),G2H2(288),G2H2(268),G2H2(265) &
    ,G2H2(260),G2H2(256),G2H2(41),G2H2(33),G1H2(81)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(765),[G2H2(759),G2H2(246),G2H2(239),G2H2(226),G2H2(35) &
    ,G1H2(562),G1H2(93),G1H2(31)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(744),[G2H2(738),G2H2(238),G2H2(234),G2H2(212),G2H2(37) &
    ,G1H2(524),G1H2(87),G1H2(49)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(768),[G2H2(762),G2H2(247),G2H2(242),G2H2(230),G2H2(43) &
    ,G1H2(99),G1H2(94),G1H2(55)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(308),[G2H2(131),G2H2(46),G1H2(141),G1H2(37)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(319),[G2H2(138),G2H2(49)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(316),[G2H2(141),G2H2(52)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(321),[G2H2(145),G2H2(55),G1H2(152),G1H2(43)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(340),[G2H2(185),G2H2(58),G1H2(163),G1H2(61)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(345),[G2H2(192),G2H2(61)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(344),[G2H2(195),G2H2(64)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(346),[G2H2(199),G2H2(67),G1H2(174),G1H2(67)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(330),[G2H2(215),G2H2(70),G1H2(185),G1H2(73)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(335),[G2H2(222),G2H2(73)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(334),[G2H2(225),G2H2(76)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(336),[G2H2(229),G2H2(79),G1H2(196),G1H2(79)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(350),[G2H2(245),G2H2(82),G1H2(207),G1H2(85)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(355),[G2H2(252),G2H2(85)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(354),[G2H2(255),G2H2(88)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(356),[G2H2(259),G2H2(91),G1H2(218),G1H2(91)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(720),[G2H2(684),G2H2(636),G2H2(606),G2H2(111),G2H2(107) &
    ,G2H2(99),G2H2(95),G1H2(262),G1H2(240),G1H2(229)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(732),[G2H2(690),G2H2(642),G2H2(612),G2H2(115),G2H2(103) &
    ,G1H2(251)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(297),[G2H2(119),G1H2(273)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(311),[G2H2(300),G2H2(123),G1H2(284)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(314),[G2H2(304),G2H2(267),G2H2(263),G2H2(127),G1H2(533) &
    ,G1H2(295)])
call ol_merge_last(G1H2(1), G1H2(1)) 
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(130),[G1H2(1)])
call HGT_OLR(G2H2(130),1,1,2)
call HGT_invQ_OLR(G2H2(130),2,5,2)
call HGT_OLR(G2H2(130),6,15,2)
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(130),[G1H2(400)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(309),[G2H2(135),G1H2(311)])
call ol_merge_last(G2H2(144), G2H2(144)) 
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(144),[G1H2(2)])
call HGT_lower_alpha_w2_OLR(G2H2(144),1,1,2)
call HGT_lower_alpha_w2_invQ_OLR(G2H2(144),2,5,2)
call HGT_lower_alpha_w2_OLR(G2H2(144),6,15,2)
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(144),[G1H2(416)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(714),[G2H2(678),G2H2(633),G2H2(603),G2H2(165),G2H2(161) &
    ,G2H2(153),G2H2(149),G1H2(360),G1H2(338),G1H2(327)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(726),[G2H2(687),G2H2(639),G2H2(609),G2H2(169),G2H2(157) &
    ,G1H2(349)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(129),[G1H2(325)])
call HGT_OLR(G2H2(172),1,1,2)
call HGT_invQ_OLR(G2H2(172),2,5,2)
call HGT_OLR(G2H2(172),6,15,2)
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(172),[G2H2(129)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(337),[G2H2(173),G1H2(371)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(183),[G2H2(137),G1H2(336)])
call HGT_OLR(G2H2(176),1,1,2)
call HGT_invQ_OLR(G2H2(176),2,5,2)
call HGT_OLR(G2H2(176),6,15,2)
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(176),[G2H2(183)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(342),[G2H2(338),G2H2(177),G1H2(382)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(191),[G2H2(10),G1H2(347)])
call HGT_OLR(G2H2(180),1,1,2)
call HGT_invQ_OLR(G2H2(180),2,5,2)
call HGT_OLR(G2H2(180),6,15,2)
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(180),[G2H2(191)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(343),[G2H2(339),G2H2(275),G2H2(271),G2H2(181),G1H2(544) &
    ,G1H2(393)])
call ol_merge_last(G1H2(3), G1H2(3)) 
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(184),[G1H2(3)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(125),[G1H2(47)])
call HGT_OLR(G2H2(184),1,1,2)
call HGT_invQ_OLR(G2H2(184),2,5,2)
call HGT_OLR(G2H2(184),6,15,2)
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(184),[G2H2(125)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(12),[G1H2(358)])
call HGT_OLR(G2H2(188),1,1,2)
call HGT_invQ_OLR(G2H2(188),2,5,2)
call HGT_OLR(G2H2(188),6,15,2)
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(188),[G2H2(12)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(341),[G2H2(189),G1H2(409)])
call ol_merge_last(G2H2(198), G2H2(198)) 
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(198),[G1H2(4)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(133),[G1H2(53)])
call HGT_lower_alpha_w2_OLR(G2H2(198),1,1,2)
call HGT_lower_alpha_w2_invQ_OLR(G2H2(198),2,5,2)
call HGT_lower_alpha_w2_OLR(G2H2(198),6,15,2)
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(198),[G2H2(133)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(324),[G2H2(203),G1H2(425)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(332),[G2H2(326),G2H2(207),G1H2(436)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(333),[G2H2(329),G2H2(283),G2H2(279),G2H2(211),G1H2(555) &
    ,G1H2(447)])
call ol_merge_last(G1H2(5), G1H2(5)) 
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(214),[G1H2(5)])
call HGT_OLR(G2H2(214),1,1,2)
call HGT_invQ_OLR(G2H2(214),2,5,2)
call HGT_OLR(G2H2(214),6,15,2)
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(214),[G1H2(69)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(331),[G2H2(219),G1H2(463)])
call ol_merge_last(G2H2(228), G2H2(228)) 
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(228),[G1H2(6)])
call HGT_lower_alpha_w2_OLR(G2H2(228),1,1,2)
call HGT_lower_alpha_w2_invQ_OLR(G2H2(228),2,5,2)
call HGT_lower_alpha_w2_OLR(G2H2(228),6,15,2)
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(228),[G1H2(75)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(101),[G1H2(227)])
call HGT_OLR(G2H2(232),1,1,2)
call HGT_invQ_OLR(G2H2(232),2,5,2)
call HGT_OLR(G2H2(232),6,15,2)
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(232),[G2H2(101)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(347),[G2H2(233),G1H2(479)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(269),[G2H2(151),G1H2(238)])
call HGT_OLR(G2H2(236),1,1,2)
call HGT_invQ_OLR(G2H2(236),2,5,2)
call HGT_OLR(G2H2(236),6,15,2)
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(236),[G2H2(269)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(352),[G2H2(348),G2H2(237),G1H2(490)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(277),[G2H2(155),G1H2(249)])
call HGT_OLR(G2H2(240),1,1,2)
call HGT_invQ_OLR(G2H2(240),2,5,2)
call HGT_OLR(G2H2(240),6,15,2)
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(240),[G2H2(277)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(353),[G2H2(349),G2H2(299),G2H2(295),G2H2(241),G1H2(576) &
    ,G1H2(501)])
call ol_merge_last(G1H2(7), G1H2(7)) 
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(244),[G1H2(7)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(117),[G1H2(23)])
call HGT_OLR(G2H2(244),1,1,2)
call HGT_invQ_OLR(G2H2(244),2,5,2)
call HGT_OLR(G2H2(244),6,15,2)
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(244),[G2H2(117)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(261),[G1H2(260)])
call HGT_OLR(G2H2(248),1,1,2)
call HGT_invQ_OLR(G2H2(248),2,5,2)
call HGT_OLR(G2H2(248),6,15,2)
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(248),[G2H2(261)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(351),[G2H2(249),G1H2(517)])
call ol_merge_last(G2H2(258), G2H2(258)) 
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(258),[G1H2(8)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(124),[G1H2(29)])
call HGT_lower_alpha_w2_OLR(G2H2(258),1,1,2)
call HGT_lower_alpha_w2_invQ_OLR(G2H2(258),2,5,2)
call HGT_lower_alpha_w2_OLR(G2H2(258),6,15,2)
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(258),[G2H2(124)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(1),[G1H2(193),G1H2(35)])
call HGT_OLR(G2H2(286),1,1,2)
call HGT_invQ_OLR(G2H2(286),2,5,2)
call HGT_OLR(G2H2(286),6,15,2)
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(286),[G2H2(1)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(303),[G2H2(287),G1H2(76),G1H2(109),G1H2(97)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(140),[G1H2(198),G1H2(41)])
call HGT_lower_alpha_w2_OLR(G2H2(290),1,1,2)
call HGT_lower_alpha_w2_invQ_OLR(G2H2(290),2,5,2)
call HGT_lower_alpha_w2_OLR(G2H2(290),6,15,2)
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(290),[G2H2(140)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(307),[G2H2(291),G1H2(470),G1H2(115),G1H2(103)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(221),[G1H2(204),G1H2(59)])
call HGT_OLR(G2H2(302),1,1,2)
call HGT_invQ_OLR(G2H2(302),2,5,2)
call HGT_OLR(G2H2(302),6,15,2)
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(302),[G2H2(221)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(251),[G1H2(209),G1H2(65)])
call HGT_lower_alpha_w2_OLR(G2H2(306),1,1,2)
call HGT_lower_alpha_w2_invQ_OLR(G2H2(306),2,5,2)
call HGT_lower_alpha_w2_OLR(G2H2(306),6,15,2)
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(306),[G2H2(251)])
call ol_merge_last(G1H2(12), G1H2(12)) 
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(12),[G1H2(9)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(25),[G1H2(293)])
call HGT_OLR(G1H2(12),1,1,2)
call HGT_invQ_OLR(G1H2(12),2,5,2)
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(25),[G1H2(12)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(320),[G2H2(310)])
call ol_merge_last(G1H2(13), G1H2(13)) 
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(13),[G1H2(10)])
call HGT_OLR(G1H2(13),1,1,2)
call HGT_invQ_OLR(G1H2(13),2,5,2)
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(13),[G1H2(299)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(323),[G2H2(322),G2H2(313),G2H2(312)])
call ol_merge_last(G1H2(14), G1H2(14)) 
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(14),[G1H2(11)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(325),[G2H2(315)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(328),[G2H2(327),G2H2(318),G2H2(317)])
call ol_merge_last(G1H2(18), G1H2(18)) 
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(18),[G1H2(15)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(100),[G1H2(391)])
call HGT_OLR(G1H2(18),1,1,2)
call HGT_invQ_OLR(G1H2(18),2,5,2)
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(100),[G1H2(18)])
call ol_merge_last(G1H2(19), G1H2(19)) 
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(19),[G1H2(16)])
call HGT_OLR(G1H2(19),1,1,2)
call HGT_invQ_OLR(G1H2(19),2,5,2)
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(19),[G1H2(397)])
call ol_merge_last(G1H2(20), G1H2(20)) 
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(20),[G1H2(17)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(5),[G1H2(184),G1H2(24)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(14),[G1H2(195),G1H2(30)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(413),[G2H2(196),G1H2(36)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(423),[G2H2(205),G1H2(42)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(15),[G1H2(140),G1H2(48)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(20),[G1H2(151),G1H2(54)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(435),[G2H2(182),G1H2(60)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(445),[G2H2(193),G1H2(66)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(305),[G1H2(171),G1H2(71)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(457),[G2H2(200),G1H2(72)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(36),[G1H2(176),G1H2(77)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(467),[G2H2(208),G1H2(78)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(44),[G1H2(182),G1H2(83)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(479),[G2H2(179),G1H2(84)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(50),[G1H2(187),G1H2(89)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(489),[G2H2(190),G1H2(90)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(63),[G1H2(95)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(65),[G1H2(96)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(66),[G1H2(101)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(68),[G1H2(102)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(75),[G1H2(107)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(77),[G1H2(108)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(78),[G1H2(113)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(80),[G1H2(114)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(190),[G1H2(120)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(743),[G2H2(737),G1H2(121)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(201),[G1H2(125)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(767),[G2H2(761),G1H2(126)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(146),[G1H2(130)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(746),[G2H2(740),G1H2(131)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(157),[G1H2(135)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(770),[G2H2(764),G1H2(136)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(136),[G1H2(139)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(306),[G1H2(147)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(146),[G1H2(150)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(322),[G1H2(158)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(147),[G1H2(161)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(21),[G1H2(162)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(404),[G1H2(169)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(166),[G1H2(172)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(24),[G1H2(173)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(420),[G1H2(180)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(167),[G1H2(183)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(458),[G1H2(191)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(162),[G1H2(194)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(474),[G1H2(202)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(171),[G1H2(205)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(26),[G1H2(206)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(512),[G1H2(213)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(178),[G1H2(216)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(97),[G1H2(217)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(528),[G1H2(224)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(104),[G1H2(228)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(722),[G2H2(686),G2H2(638),G2H2(608),G1H2(268),G1H2(246) &
    ,G1H2(235)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(272),[G2H2(154),G1H2(239)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(280),[G2H2(158),G1H2(554),G1H2(250)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(560),[G1H2(256)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(734),[G2H2(692),G2H2(644),G2H2(614),G1H2(257)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(264),[G1H2(261)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(293),[G1H2(271)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(405),[G1H2(310),G1H2(283),G1H2(272)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(408),[G1H2(316),G1H2(289),G1H2(278)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(296),[G1H2(282)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(409),[G1H2(294)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(412),[G1H2(300)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(539),[G1H2(301)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(416),[G1H2(305)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(2),[G1H2(309)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(426),[G1H2(321)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(143),[G1H2(326)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(716),[G2H2(680),G2H2(635),G2H2(605),G1H2(366),G1H2(344) &
    ,G1H2(333)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(197),[G2H2(9),G1H2(337)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(224),[G2H2(11),G1H2(532),G1H2(348)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(538),[G1H2(354)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(728),[G2H2(689),G2H2(641),G2H2(611),G1H2(355)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(194),[G1H2(359)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(213),[G1H2(369)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(427),[G1H2(408),G1H2(381),G1H2(370)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(430),[G1H2(414),G1H2(387),G1H2(376)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(227),[G1H2(380)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(431),[G1H2(392)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(434),[G1H2(398)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(550),[G1H2(399)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(438),[G1H2(403)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(254),[G1H2(407)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(448),[G1H2(419)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(285),[G1H2(423)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(449),[G1H2(462),G1H2(435),G1H2(424)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(452),[G1H2(468),G1H2(441),G1H2(430)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(289),[G1H2(434)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(301),[G1H2(445)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(453),[G1H2(446)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(456),[G1H2(452)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(561),[G1H2(453)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(460),[G1H2(457)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(30),[G1H2(461)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(470),[G1H2(473)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(38),[G1H2(477)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(471),[G1H2(516),G1H2(489),G1H2(478)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(474),[G1H2(522),G1H2(495),G1H2(484)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(40),[G1H2(488)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(42),[G1H2(499)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(475),[G1H2(500)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(478),[G1H2(506)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(582),[G1H2(507)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(482),[G1H2(511)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(45),[G1H2(515)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(492),[G1H2(527)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(53),[G2H2(51),G1H2(531)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(57),[G2H2(54),G1H2(542)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(59),[G2H2(56),G1H2(543)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(62),[G2H2(60),G1H2(553)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(587),[G1H2(566)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(592),[G1H2(571)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(72),[G2H2(69),G1H2(574)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(74),[G2H2(71),G1H2(575)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(360),[G2H2(6)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(357),[G2H2(8)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(366),[G2H2(16)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(363),[G2H2(18)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(3),[G1H2(199)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(4),[G1H2(192)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(243),[G1H2(210)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(257),[G1H2(203)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(32),[G1H2(177)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(34),[G1H2(170)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(47),[G1H2(188)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(48),[G1H2(181)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(495),[G2H2(84)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(389),[G2H2(86)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(498),[G2H2(90)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(392),[G2H2(92)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(501),[G2H2(109)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(401),[G2H2(112)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(504),[G2H2(105)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(404),[G2H2(108)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(486),[G2H2(442),G2H2(186)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(483),[G2H2(439),G2H2(187)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(464),[G2H2(420),G2H2(201)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(461),[G2H2(417),G2H2(204)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(753),[G2H2(747),G2H2(220),G2H2(216)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(756),[G2H2(750),G2H2(223),G2H2(217)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(171),[G1H4(103)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(103),[G1H4(130)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(180),[G1H4(109)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(108),[G1H4(397)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(131),[G1H4(115)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(113),[G1H4(400)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(237),[G2H4(4)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(107),[G2H4(204)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(190),[G1H4(127)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(6),[G1H4(407)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(162),[G2H4(119)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(153),[G2H4(77)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(463),[G2H2(419)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(466),[G2H2(422)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(485),[G2H2(441)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(488),[G2H2(444)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(693),[G2H2(657),G2H2(615),G2H2(585)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(695),[G2H2(659),G2H2(617),G2H2(587)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(263),[G1H2(433),G1H2(269),G1H2(58)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(696),[G2H2(660),G2H2(618),G2H2(588)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(698),[G2H2(662),G2H2(620),G2H2(590)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(328),[G1H2(449),G1H2(286),G1H2(106)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(699),[G2H2(663),G2H2(621),G2H2(591)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(701),[G2H2(665),G2H2(623),G2H2(593)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(394),[G1H2(481),G1H2(298),G1H2(588)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(702),[G2H2(666),G2H2(624),G2H2(594)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(704),[G2H2(668),G2H2(626),G2H2(596)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(464),[G1H2(504),G1H2(314),G1H2(133)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(705),[G2H2(669),G2H2(627),G2H2(597)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(707),[G2H2(671),G2H2(629),G2H2(599)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(534),[G1H2(520),G1H2(334),G1H2(144)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(708),[G2H2(672),G2H2(630),G2H2(600)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(710),[G2H2(674),G2H2(632),G2H2(602)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(117),[G1H2(551),G1H2(346),G1H2(155)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(127),[G1H2(589),G1H2(362),G1H2(166)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(111),[G1H2(80),G1H2(378),G1H2(225)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(148),[G1H2(110),G1H2(390),G1H2(242)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(221),[G1H2(186),G1H2(406),G1H2(254)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(650),[G2H2(647)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(656),[G2H2(653)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(723),[G2H2(711),G2H2(675)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(725),[G2H2(713),G2H2(677)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(128),[G1H2(39),G1H2(572)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(729),[G2H2(717),G2H2(681)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(731),[G2H2(719),G2H2(683)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(160),[G1H2(100),G1H2(50)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(236),[G1H2(231)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(243),[G1H2(232)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(755),[G2H2(749)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(258),[G1H2(247)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(758),[G2H2(752)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(264),[G1H2(253)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(276),[G1H2(265)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(280),[G1H2(275)])
  call Hotf_4pt_reduction(G2H2(741),RedSet_4(12),mass4set(:,15),  & 
G1H2(351),G1H2(356),G1H2(357),G1H2(367),G1H2(368),2)
  call HG1shiftOLR(G1H2(356),8,2)
  call Hcheck_last_VV_S(ntryL,l_switch,G2H2(648),ex4(:),G2tensor(49),m3h2x1(:,257),heltab2x2(:,:,257))
  call Hcheck_last_SV_V(ntryL,l_switch,G2H2(654),ex4(:),G2tensor(2),m3h2x1(:,258),heltab2x2(:,:,258))
  call Hotf_4pt_reduction(G2H2(765),RedSet_4(12),mass4set(:,15),  & 
G1H2(373),G1H2(379),G1H2(384),G1H2(389),G1H2(395),2)
  call HG1shiftOLR(G1H2(379),8,2)
  call Hotf_4pt_reduction(G2H2(744),RedSet_4(12),mass4set(:,15),  & 
G1H2(396),G1H2(401),G1H2(411),G1H2(412),G1H2(432),2)
  call HG1shiftOLR(G1H2(401),8,2)
  call Hotf_4pt_reduction(G2H2(768),RedSet_4(12),mass4set(:,15),  & 
G1H2(438),G1H2(443),G1H2(444),G1H2(466),G1H2(471),2)
  call HG1shiftOLR(G1H2(443),8,2)
  call Hotf_4pt_reduction(G2H2(308),RedSet_4(16),mass4set(:,10),  & 
G1H2(475),G1H2(482),G1H2(486),G1H2(503),G1H2(509),2)
  call HG1shiftOLR(G1H2(482),8,2)
  call Hcheck_last_SV_V(ntryL,l_switch,G2H2(319),ex4(:),G2tensor(1),m3h2x1(:,259),heltab2x2(:,:,259))
  call Hcheck_last_VV_S(ntryL,l_switch,G2H2(316),ex4(:),G2tensor(55),m3h2x1(:,260),heltab2x2(:,:,260))
  call Hotf_4pt_reduction(G2H2(321),RedSet_4(16),mass4set(:,10),  & 
G1H2(514),G1H2(519),G1H2(540),G1H2(546),G1H2(547),2)
  call HG1shiftOLR(G1H2(519),8,2)
  call Hotf_4pt_reduction(G2H2(340),RedSet_4(23),mass4set(:,10),  & 
G1H2(557),G1H2(558),G1H2(563),G1H2(573),G1H2(578),2)
  call HG1shiftOLR(G1H2(558),4,2)
  call Hcheck_last_SV_V(ntryL,l_switch,G2H2(345),ex3(:),G2tensor(4),m3h2x1(:,261),heltab2x2(:,:,261))
  call Hcheck_last_VV_S(ntryL,l_switch,G2H2(344),ex3(:),G2tensor(3),m3h2x1(:,262),heltab2x2(:,:,262))
  call Hotf_4pt_reduction(G2H2(346),RedSet_4(23),mass4set(:,10),  & 
G1H2(584),G1H2(26),G1H2(32),G1H2(38),G1H2(56),2)
  call HG1shiftOLR(G1H2(26),4,2)
  call Hotf_4pt_reduction(G2H2(330),RedSet_4(26),mass4set(:,10),  & 
G1H2(62),G1H2(74),G1H2(86),G1H2(98),G1H2(104),2)
  call HG1shiftOLR(G1H2(74),8,2)
  call Hcheck_last_SV_V(ntryL,l_switch,G2H2(335),ex4(:),G2tensor(61),m3h2x1(:,263),heltab2x2(:,:,263))
  call Hcheck_last_VV_S(ntryL,l_switch,G2H2(334),ex4(:),G2tensor(6),m3h2x1(:,264),heltab2x2(:,:,264))
  call Hotf_4pt_reduction(G2H2(336),RedSet_4(26),mass4set(:,10),  & 
G1H2(142),G1H2(153),G1H2(164),G1H2(197),G1H2(208),2)
  call HG1shiftOLR(G1H2(153),8,2)
  call Hotf_4pt_reduction(G2H2(350),RedSet_4(29),mass4set(:,10),  & 
G1H2(252),G1H2(274),G1H2(296),G1H2(312),G1H2(350),2)
  call HG1shiftOLR(G1H2(274),4,2)
  call Hcheck_last_SV_V(ntryL,l_switch,G2H2(355),ex3(:),G2tensor(5),m3h2x1(:,265),heltab2x2(:,:,265))
  call Hcheck_last_VV_S(ntryL,l_switch,G2H2(354),ex3(:),G2tensor(67),m3h2x1(:,266),heltab2x2(:,:,266))
  call Hotf_4pt_reduction(G2H2(356),RedSet_4(29),mass4set(:,10),  & 
G1H2(361),G1H2(372),G1H2(410),G1H2(426),G1H2(448),2)
  call HG1shiftOLR(G1H2(372),4,2)
call HGT_OLR(G2H2(94),1,1,2)
call HGT_invQ_OLR(G2H2(94),2,5,2)
call HGT_OLR(G2H2(94),6,15,2)
  call Hotf_4pt_reduction(G2H2(94),RedSet_4(47),mass4set(:,3),  & 
G1H2(480),G1H2(502),G1H2(518),G1H2(556),G1H2(577),2)
  call HG1shiftOLR(G1H2(502),2,2)
  call Hotf_4pt_reduction(G2H2(720),RedSet_4(12),mass4set(:,13),  & 
G1H2(21),G1H2(27),G1H2(28),G1H2(302),G1H2(40),2)
  call HG1shiftOLR(G1H2(27),8,2)
call HGT_OLR(G2H2(98),1,1,2)
call HGT_invQ_OLR(G2H2(98),2,5,2)
call HGT_OLR(G2H2(98),6,15,2)
  call Hotf_4pt_reduction(G2H2(98),RedSet_4(47),mass4set(:,4),  & 
G1H2(45),G1H2(46),G1H2(52),G1H2(132),G1H2(57),2)
  call HG1shiftOLR(G1H2(46),2,2)
call HGT_OLR(G2H2(102),1,1,2)
call HGT_invQ_OLR(G2H2(102),2,5,2)
call HGT_OLR(G2H2(102),6,15,2)
  call Hotf_4pt_reduction(G2H2(102),RedSet_4(47),mass4set(:,5),  & 
G1H2(567),G1H2(105),G1H2(583),G1H2(112),G1H2(118),2)
  call HG1shiftOLR(G1H2(105),2,2)
  call Hotf_4pt_reduction(G2H2(732),RedSet_4(12),mass4set(:,14),  & 
G1H2(123),G1H2(137),G1H2(138),G1H2(143),G1H2(149),2)
  call HG1shiftOLR(G1H2(137),8,2)
call HGT_OLR(G2H2(106),1,1,2)
call HGT_invQ_OLR(G2H2(106),2,5,2)
call HGT_OLR(G2H2(106),6,15,2)
  call Hotf_4pt_reduction(G2H2(106),RedSet_4(47),mass4set(:,6),  & 
G1H2(154),G1H2(159),G1H2(165),G1H2(214),G1H2(220),2)
  call HG1shiftOLR(G1H2(159),2,2)
call HGT_OLR(G2H2(110),1,1,2)
call HGT_invQ_OLR(G2H2(110),2,5,2)
call HGT_OLR(G2H2(110),6,15,2)
  call Hotf_4pt_reduction(G2H2(110),RedSet_4(47),mass4set(:,4),  & 
G1H2(88),G1H2(508),G1H2(25),G1H2(82),G1H2(81),2)
  call HG1shiftOLR(G1H2(508),2,2)
call HGT_OLR(G2H2(114),1,1,2)
call HGT_invQ_OLR(G2H2(114),2,5,2)
call HGT_OLR(G2H2(114),6,15,2)
  call Hotf_4pt_reduction(G2H2(114),RedSet_4(47),mass4set(:,5),  & 
G1H2(562),G1H2(93),G1H2(31),G1H2(524),G1H2(87),2)
  call HG1shiftOLR(G1H2(93),2,2)
call HGT_OLR(G2H2(118),1,1,2)
call HGT_invQ_OLR(G2H2(118),2,5,2)
call HGT_OLR(G2H2(118),6,15,2)
  call Hotf_4pt_reduction(G2H2(118),RedSet_4(53),mass4set(:,7),  & 
G1H2(49),G1H2(99),G1H2(94),G1H2(55),G1H2(141),2)
  call HG1shiftOLR(G1H2(99),4,2)
  call Hotf_4pt_reduction(G2H2(297),RedSet_4(16),mass4set(:,7),  & 
G1H2(37),G1H2(152),G1H2(43),G1H2(163),G1H2(61),2)
  call HG1shiftOLR(G1H2(152),8,2)
call HGT_OLR(G2H2(122),1,1,2)
call HGT_invQ_OLR(G2H2(122),2,5,2)
call HGT_OLR(G2H2(122),6,15,2)
  call Hotf_4pt_reduction(G2H2(122),RedSet_4(53),mass4set(:,8),  & 
G1H2(174),G1H2(67),G1H2(185),G1H2(73),G1H2(196),2)
  call HG1shiftOLR(G1H2(67),4,2)
  call Hotf_4pt_reduction(G2H2(311),RedSet_4(16),mass4set(:,8),  & 
G1H2(79),G1H2(207),G1H2(85),G1H2(218),G1H2(91),2)
  call HG1shiftOLR(G1H2(207),8,2)
call HGT_OLR(G2H2(126),1,1,2)
call HGT_invQ_OLR(G2H2(126),2,5,2)
call HGT_OLR(G2H2(126),6,15,2)
  call Hotf_4pt_reduction(G2H2(126),RedSet_4(53),mass4set(:,9),  & 
G1H2(262),G1H2(240),G1H2(229),G1H2(251),G1H2(273),2)
  call HG1shiftOLR(G1H2(240),4,2)
  call Hotf_4pt_reduction(G2H2(314),RedSet_4(16),mass4set(:,9),  & 
G1H2(284),G1H2(533),G1H2(295),G1H2(1),G1H2(400),2)
  call HG1shiftOLR(G1H2(533),8,2)
  call Hotf_4pt_reduction(G2H2(130),RedSet_4(53),mass4set(:,10),  & 
G1H2(311),G1H2(2),G1H2(416),G1H2(360),G1H2(338),2)
  call HG1shiftOLR(G1H2(2),4,2)
call HGT_OLR(G2H2(134),1,1,2)
call HGT_invQ_OLR(G2H2(134),2,5,2)
call HGT_OLR(G2H2(134),6,15,2)
  call Hotf_4pt_reduction(G2H2(134),RedSet_4(53),mass4set(:,11),  & 
G1H2(327),G1H2(349),G1H2(325),G1H2(371),G1H2(336),2)
  call HG1shiftOLR(G1H2(349),4,2)
  call Hotf_4pt_reduction(G2H2(309),RedSet_4(16),mass4set(:,11),  & 
G1H2(382),G1H2(347),G1H2(544),G1H2(393),G1H2(3),2)
  call HG1shiftOLR(G1H2(347),8,2)
  call Hotf_4pt_reduction(G2H2(144),RedSet_4(53),mass4set(:,10),  & 
G1H2(47),G1H2(358),G1H2(409),G1H2(4),G1H2(53),2)
  call HG1shiftOLR(G1H2(358),4,2)
call HGT_OLR(G2H2(148),1,1,2)
call HGT_invQ_OLR(G2H2(148),2,5,2)
call HGT_OLR(G2H2(148),6,15,2)
  call Hotf_4pt_reduction(G2H2(148),RedSet_4(48),mass4set(:,3),  & 
G1H2(425),G1H2(436),G1H2(555),G1H2(447),G1H2(5),2)
  call HG1shiftOLR(G1H2(436),1,2)
  call Hotf_4pt_reduction(G2H2(714),RedSet_4(12),mass4set(:,13),  & 
G1H2(69),G1H2(463),G1H2(6),G1H2(75),G1H2(227),2)
  call HG1shiftOLR(G1H2(463),8,2)
call HGT_OLR(G2H2(152),1,1,2)
call HGT_invQ_OLR(G2H2(152),2,5,2)
call HGT_OLR(G2H2(152),6,15,2)
  call Hotf_4pt_reduction(G2H2(152),RedSet_4(48),mass4set(:,4),  & 
G1H2(479),G1H2(238),G1H2(490),G1H2(249),G1H2(576),2)
  call HG1shiftOLR(G1H2(238),1,2)
call HGT_OLR(G2H2(156),1,1,2)
call HGT_invQ_OLR(G2H2(156),2,5,2)
call HGT_OLR(G2H2(156),6,15,2)
  call Hotf_4pt_reduction(G2H2(156),RedSet_4(48),mass4set(:,5),  & 
G1H2(501),G1H2(7),G1H2(23),G1H2(260),G1H2(517),2)
  call HG1shiftOLR(G1H2(7),1,2)
  call Hotf_4pt_reduction(G2H2(726),RedSet_4(12),mass4set(:,14),  & 
G1H2(8),G1H2(29),G1H2(193),G1H2(35),G1H2(76),2)
  call HG1shiftOLR(G1H2(29),8,2)
call HGT_OLR(G2H2(160),1,1,2)
call HGT_invQ_OLR(G2H2(160),2,5,2)
call HGT_OLR(G2H2(160),6,15,2)
  call Hotf_4pt_reduction(G2H2(160),RedSet_4(48),mass4set(:,6),  & 
G1H2(109),G1H2(97),G1H2(198),G1H2(41),G1H2(470),2)
  call HG1shiftOLR(G1H2(97),1,2)
call HGT_OLR(G2H2(164),1,1,2)
call HGT_invQ_OLR(G2H2(164),2,5,2)
call HGT_OLR(G2H2(164),6,15,2)
  call Hotf_4pt_reduction(G2H2(164),RedSet_4(48),mass4set(:,4),  & 
G1H2(115),G1H2(103),G1H2(204),G1H2(59),G1H2(209),2)
  call HG1shiftOLR(G1H2(103),1,2)
call HGT_OLR(G2H2(168),1,1,2)
call HGT_invQ_OLR(G2H2(168),2,5,2)
call HGT_OLR(G2H2(168),6,15,2)
  call Hotf_4pt_reduction(G2H2(168),RedSet_4(48),mass4set(:,5),  & 
G1H2(65),G1H2(9),G1H2(293),G1H2(12),G1H2(10),2)
  call HG1shiftOLR(G1H2(9),1,2)
  call Hotf_4pt_reduction(G2H2(172),RedSet_4(18),mass4set(:,7),  & 
G1H2(299),G1H2(11),G1H2(15),G1H2(391),G1H2(18),2)
  call HG1shiftOLR(G1H2(11),8,2)
  call Hotf_4pt_reduction(G2H2(337),RedSet_4(23),mass4set(:,7),  & 
G1H2(16),G1H2(397),G1H2(17),G1H2(184),G1H2(24),2)
  call HG1shiftOLR(G1H2(397),4,2)
  call Hotf_4pt_reduction(G2H2(176),RedSet_4(18),mass4set(:,8),  & 
G1H2(195),G1H2(30),G1H2(36),G1H2(42),G1H2(140),2)
  call HG1shiftOLR(G1H2(30),8,2)
  call Hotf_4pt_reduction(G2H2(342),RedSet_4(23),mass4set(:,8),  & 
G1H2(48),G1H2(151),G1H2(54),G1H2(60),G1H2(66),2)
  call HG1shiftOLR(G1H2(151),4,2)
  call Hotf_4pt_reduction(G2H2(180),RedSet_4(18),mass4set(:,9),  & 
G1H2(171),G1H2(71),G1H2(72),G1H2(176),G1H2(77),2)
  call HG1shiftOLR(G1H2(71),8,2)
  call Hotf_4pt_reduction(G2H2(343),RedSet_4(23),mass4set(:,9),  & 
G1H2(78),G1H2(182),G1H2(83),G1H2(84),G1H2(187),2)
  call HG1shiftOLR(G1H2(182),4,2)
  call Hotf_4pt_reduction(G2H2(184),RedSet_4(18),mass4set(:,10),  & 
G1H2(89),G1H2(90),G1H2(95),G1H2(96),G1H2(101),2)
  call HG1shiftOLR(G1H2(90),8,2)
  call Hotf_4pt_reduction(G2H2(188),RedSet_4(18),mass4set(:,11),  & 
G1H2(102),G1H2(107),G1H2(108),G1H2(113),G1H2(114),2)
  call HG1shiftOLR(G1H2(107),8,2)
  call Hotf_4pt_reduction(G2H2(341),RedSet_4(23),mass4set(:,11),  & 
G1H2(120),G1H2(121),G1H2(125),G1H2(126),G1H2(130),2)
  call HG1shiftOLR(G1H2(121),4,2)
  call Hotf_4pt_reduction(G2H2(198),RedSet_4(18),mass4set(:,10),  & 
G1H2(131),G1H2(135),G1H2(136),G1H2(139),G1H2(147),2)
  call HG1shiftOLR(G1H2(135),8,2)
call HGT_OLR(G2H2(202),1,1,2)
call HGT_invQ_OLR(G2H2(202),2,5,2)
call HGT_OLR(G2H2(202),6,15,2)
  call Hotf_4pt_reduction(G2H2(202),RedSet_4(54),mass4set(:,7),  & 
G1H2(150),G1H2(158),G1H2(161),G1H2(162),G1H2(169),2)
  call HG1shiftOLR(G1H2(158),4,2)
  call Hotf_4pt_reduction(G2H2(324),RedSet_4(26),mass4set(:,7),  & 
G1H2(172),G1H2(173),G1H2(180),G1H2(183),G1H2(191),2)
  call HG1shiftOLR(G1H2(173),8,2)
call HGT_OLR(G2H2(206),1,1,2)
call HGT_invQ_OLR(G2H2(206),2,5,2)
call HGT_OLR(G2H2(206),6,15,2)
  call Hotf_4pt_reduction(G2H2(206),RedSet_4(54),mass4set(:,8),  & 
G1H2(194),G1H2(202),G1H2(205),G1H2(206),G1H2(213),2)
  call HG1shiftOLR(G1H2(202),4,2)
  call Hotf_4pt_reduction(G2H2(332),RedSet_4(26),mass4set(:,8),  & 
G1H2(216),G1H2(217),G1H2(224),G1H2(228),G1H2(268),2)
  call HG1shiftOLR(G1H2(217),8,2)
call HGT_OLR(G2H2(210),1,1,2)
call HGT_invQ_OLR(G2H2(210),2,5,2)
call HGT_OLR(G2H2(210),6,15,2)
  call Hotf_4pt_reduction(G2H2(210),RedSet_4(54),mass4set(:,9),  & 
G1H2(246),G1H2(235),G1H2(239),G1H2(554),G1H2(250),2)
  call HG1shiftOLR(G1H2(235),4,2)
  call Hotf_4pt_reduction(G2H2(333),RedSet_4(26),mass4set(:,9),  & 
G1H2(256),G1H2(257),G1H2(261),G1H2(271),G1H2(310),2)
  call HG1shiftOLR(G1H2(257),8,2)
  call Hotf_4pt_reduction(G2H2(214),RedSet_4(54),mass4set(:,10),  & 
G1H2(283),G1H2(272),G1H2(316),G1H2(289),G1H2(278),2)
  call HG1shiftOLR(G1H2(272),4,2)
call HGT_OLR(G2H2(218),1,1,2)
call HGT_invQ_OLR(G2H2(218),2,5,2)
call HGT_OLR(G2H2(218),6,15,2)
  call Hotf_4pt_reduction(G2H2(218),RedSet_4(54),mass4set(:,11),  & 
G1H2(282),G1H2(294),G1H2(300),G1H2(301),G1H2(305),2)
  call HG1shiftOLR(G1H2(294),4,2)
  call Hotf_4pt_reduction(G2H2(331),RedSet_4(26),mass4set(:,11),  & 
G1H2(309),G1H2(321),G1H2(326),G1H2(366),G1H2(344),2)
  call HG1shiftOLR(G1H2(321),8,2)
  call Hotf_4pt_reduction(G2H2(228),RedSet_4(54),mass4set(:,10),  & 
G1H2(333),G1H2(337),G1H2(532),G1H2(348),G1H2(354),2)
  call HG1shiftOLR(G1H2(337),4,2)
  call Hotf_4pt_reduction(G2H2(232),RedSet_4(10),mass4set(:,7),  & 
G1H2(355),G1H2(359),G1H2(369),G1H2(408),G1H2(381),2)
  call HG1shiftOLR(G1H2(359),8,2)
  call Hotf_4pt_reduction(G2H2(347),RedSet_4(29),mass4set(:,7),  & 
G1H2(370),G1H2(414),G1H2(387),G1H2(376),G1H2(380),2)
  call HG1shiftOLR(G1H2(414),4,2)
  call Hotf_4pt_reduction(G2H2(236),RedSet_4(10),mass4set(:,8),  & 
G1H2(392),G1H2(398),G1H2(399),G1H2(403),G1H2(407),2)
  call HG1shiftOLR(G1H2(398),8,2)
  call Hotf_4pt_reduction(G2H2(352),RedSet_4(29),mass4set(:,8),  & 
G1H2(419),G1H2(423),G1H2(462),G1H2(435),G1H2(424),2)
  call HG1shiftOLR(G1H2(423),4,2)
  call Hotf_4pt_reduction(G2H2(240),RedSet_4(10),mass4set(:,9),  & 
G1H2(468),G1H2(441),G1H2(430),G1H2(434),G1H2(445),2)
  call HG1shiftOLR(G1H2(441),8,2)
  call Hotf_4pt_reduction(G2H2(353),RedSet_4(29),mass4set(:,9),  & 
G1H2(446),G1H2(452),G1H2(453),G1H2(457),G1H2(461),2)
  call HG1shiftOLR(G1H2(452),4,2)
  call Hotf_4pt_reduction(G2H2(244),RedSet_4(10),mass4set(:,10),  & 
G1H2(473),G1H2(477),G1H2(516),G1H2(489),G1H2(478),2)
  call HG1shiftOLR(G1H2(477),8,2)
  call Hotf_4pt_reduction(G2H2(248),RedSet_4(10),mass4set(:,11),  & 
G1H2(522),G1H2(495),G1H2(484),G1H2(488),G1H2(499),2)
  call HG1shiftOLR(G1H2(495),8,2)
  call Hotf_4pt_reduction(G2H2(351),RedSet_4(29),mass4set(:,11),  & 
G1H2(500),G1H2(506),G1H2(507),G1H2(511),G1H2(515),2)
  call HG1shiftOLR(G1H2(506),4,2)
  call Hotf_4pt_reduction(G2H2(258),RedSet_4(10),mass4set(:,10),  & 
G1H2(527),G1H2(531),G1H2(542),G1H2(543),G1H2(553),2)
  call HG1shiftOLR(G1H2(531),8,2)
call HGT_OLR(G2H2(262),1,1,2)
call HGT_invQ_OLR(G2H2(262),2,5,2)
call HGT_OLR(G2H2(262),6,15,2)
  call Hotf_4pt_reduction(G2H2(262),RedSet_4(49),mass4set(:,12),  & 
G1H2(566),G1H2(571),G1H2(574),G1H2(575),G1H2(199),2)
  call HG1shiftOLR(G1H2(571),1,2)
call HGT_OLR(G2H2(266),1,1,2)
call HGT_invQ_OLR(G2H2(266),2,5,2)
call HGT_OLR(G2H2(266),6,15,2)
  call Hotf_4pt_reduction(G2H2(266),RedSet_4(49),mass4set(:,12),  & 
G1H2(192),G1H2(210),G1H2(203),G1H2(177),G1H2(170),2)
  call HG1shiftOLR(G1H2(210),1,2)
call HGT_OLR(G2H2(270),1,1,2)
call HGT_invQ_OLR(G2H2(270),2,5,2)
call HGT_OLR(G2H2(270),6,15,2)
  call Hotf_4pt_reduction(G2H2(270),RedSet_4(50),mass4set(:,12),  & 
G1H2(188),G1H2(181),G1H2(433),G1H2(269),G1H2(58),2)
  call HG1shiftOLR(G1H2(181),1,2)
call HGT_OLR(G2H2(274),1,1,2)
call HGT_invQ_OLR(G2H2(274),2,5,2)
call HGT_OLR(G2H2(274),6,15,2)
  call Hotf_4pt_reduction(G2H2(274),RedSet_4(50),mass4set(:,12),  & 
G1H2(449),G1H2(286),G1H2(106),G1H2(481),G1H2(298),2)
  call HG1shiftOLR(G1H2(286),1,2)
call HGT_OLR(G2H2(278),1,1,2)
call HGT_invQ_OLR(G2H2(278),2,5,2)
call HGT_OLR(G2H2(278),6,15,2)
  call Hotf_4pt_reduction(G2H2(278),RedSet_4(51),mass4set(:,12),  & 
G1H2(588),G1H2(504),G1H2(314),G1H2(133),G1H2(520),2)
  call HG1shiftOLR(G1H2(504),2,2)
call HGT_OLR(G2H2(282),1,1,2)
call HGT_invQ_OLR(G2H2(282),2,5,2)
call HGT_OLR(G2H2(282),6,15,2)
  call Hotf_4pt_reduction(G2H2(282),RedSet_4(51),mass4set(:,12),  & 
G1H2(334),G1H2(144),G1H2(551),G1H2(346),G1H2(155),2)
  call HG1shiftOLR(G1H2(144),2,2)
  call Hotf_4pt_reduction(G2H2(286),RedSet_4(14),mass4set(:,21),  & 
G1H2(589),G1H2(362),G1H2(166),G1H2(80),G1H2(378),2)
  call HG1shiftOLR(G1H2(362),8,2)
  call Hotf_4pt_reduction(G2H2(303),RedSet_4(1),mass4set(:,12),  & 
G1H2(225),G1H2(110),G1H2(390),G1H2(242),G1H2(186),2)
  call HG1shiftOLR(G1H2(110),2,2)
  call Hotf_4pt_reduction(G2H2(290),RedSet_4(14),mass4set(:,21),  & 
G1H2(406),G1H2(254),G1H2(39),G1H2(572),G1H2(100),2)
  call HG1shiftOLR(G1H2(254),8,2)
  call Hotf_4pt_reduction(G2H2(307),RedSet_4(1),mass4set(:,12),  & 
G1H2(50),G1H2(231),G1H2(232),G1H2(247),G1H2(253),2)
  call HG1shiftOLR(G1H2(231),2,2)
call HGT_OLR(G2H2(294),1,1,2)
call HGT_invQ_OLR(G2H2(294),2,5,2)
call HGT_OLR(G2H2(294),6,15,2)
  call Hotf_4pt_reduction(G2H2(294),RedSet_4(52),mass4set(:,12),  & 
G1H2(265),G1H2(275),G1H2(593),G1H2(594),G1H2(595),2)
  call HG1shiftOLR(G1H2(275),2,2)
call HGT_OLR(G2H2(298),1,1,2)
call HGT_invQ_OLR(G2H2(298),2,5,2)
call HGT_OLR(G2H2(298),6,15,2)
  call Hotf_4pt_reduction(G2H2(298),RedSet_4(52),mass4set(:,12),  & 
G1H2(596),G1H2(597),G1H2(598),G1H2(599),G1H2(600),2)
  call HG1shiftOLR(G1H2(597),2,2)
  call Hotf_4pt_reduction(G2H2(302),RedSet_4(21),mass4set(:,21),  & 
G1H2(601),G1H2(602),G1H2(603),G1H2(604),G1H2(605),2)
  call HG1shiftOLR(G1H2(602),4,2)
  call Hotf_4pt_reduction(G2H2(306),RedSet_4(21),mass4set(:,21),  & 
G1H2(606),G1H2(607),G1H2(608),G1H2(609),G1H2(610),2)
  call HG1shiftOLR(G1H2(607),4,2)
  call Hotf_4pt_reduction(G2H2(25),RedSet_4(14),mass4set(:,22),  & 
G1H2(611),G1H2(612),G1H2(613),G1H2(614),G1H2(615),2)
  call HG1shiftOLR(G1H2(612),8,2)
  call Hcheck_last_QA_S(ntryL,l_switch,G2H2(320),ex2(:),G2tensor(8),ngPtb,m3h2x1(:,267),heltab2x2(:,:,267))
  call Hloop_QV_A(ntryL,G1H2(13),ex4(:),G1H1(1),m3h2x1(:,268),heltab2x2(:,:,268))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,nMB,G2tensor(7),n2h1(169))
  call Hcheck_last_QA_S(ntryL,l_switch,G2H2(323),ex2(:),G2tensor(73),ngPtb,m3h2x1(:,269),heltab2x2(:,:,269))
call HGT_OLR(G1H2(14),1,1,2)
call HGT_invQ_OLR(G1H2(14),2,5,2)
  call Hloop_QV_A(ntryL,G1H2(14),ex4(:),G1H1(1),m3h2x1(:,270),heltab2x2(:,:,270))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),8,nMB,G2tensor(10),n2h1(170))
  call Hcheck_last_QA_W(ntryL,l_switch,G2H2(325),ex2(:),G2tensor(9),m3h2x1(:,271),heltab2x2(:,:,271))
  call Hcheck_last_QA_W(ntryL,l_switch,G2H2(328),ex2(:),G2tensor(79),m3h2x1(:,272),heltab2x2(:,:,272))
  call Hotf_4pt_reduction(G2H2(100),RedSet_4(21),mass4set(:,22),  & 
G1H2(13),G1H2(14),G1H2(616),G1H2(617),G1H2(618),2)
  call HG1shiftOLR(G1H2(14),4,2)
  call Hloop_QV_A(ntryL,G1H2(19),ex3(:),G1H1(1),m3h2x1(:,273),heltab2x2(:,:,273))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,nMB,G2tensor(12),n2h1(171))
call HGT_OLR(G1H2(20),1,1,2)
call HGT_invQ_OLR(G1H2(20),2,5,2)
  call Hloop_QV_A(ntryL,G1H2(20),ex3(:),G1H1(1),m3h2x1(:,274),heltab2x2(:,:,274))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),4,nMB,G2tensor(11),n2h1(172))
  call Hotf_4pt_reduction(G2H2(5),RedSet_4(11),mass4set(:,10),  & 
G1H2(19),G1H2(20),G1H2(619),G1H2(620),G1H2(621),2)
  call HG1shiftOLR(G1H2(20),8,2)
  call Hotf_4pt_reduction(G2H2(14),RedSet_4(11),mass4set(:,10),  & 
G1H2(622),G1H2(623),G1H2(624),G1H2(625),G1H2(626),2)
  call HG1shiftOLR(G1H2(623),8,2)
  call Hotf_4pt_reduction(G2H2(413),RedSet_4(15),mass4set(:,15),  & 
G1H2(627),G1H2(628),G1H2(629),G1H2(630),G1H2(631),2)
  call HG1shiftOLR(G1H2(628),8,2)
  call Hotf_4pt_reduction(G2H2(423),RedSet_4(15),mass4set(:,15),  & 
G1H2(632),G1H2(633),G1H2(634),G1H2(635),G1H2(636),2)
  call HG1shiftOLR(G1H2(633),8,2)
  call Hotf_4pt_reduction(G2H2(15),RedSet_4(19),mass4set(:,10),  & 
G1H2(637),G1H2(638),G1H2(639),G1H2(640),G1H2(641),2)
  call HG1shiftOLR(G1H2(638),8,2)
  call Hotf_4pt_reduction(G2H2(20),RedSet_4(19),mass4set(:,10),  & 
G1H2(642),G1H2(643),G1H2(644),G1H2(645),G1H2(646),2)
  call HG1shiftOLR(G1H2(643),8,2)
  call Hotf_4pt_reduction(G2H2(435),RedSet_4(22),mass4set(:,15),  & 
G1H2(647),G1H2(648),G1H2(649),G1H2(650),G1H2(651),2)
  call HG1shiftOLR(G1H2(648),4,2)
  call Hotf_4pt_reduction(G2H2(445),RedSet_4(22),mass4set(:,15),  & 
G1H2(652),G1H2(653),G1H2(654),G1H2(655),G1H2(656),2)
  call HG1shiftOLR(G1H2(653),4,2)
  call Hotf_4pt_reduction(G2H2(305),RedSet_4(25),mass4set(:,21),  & 
G1H2(657),G1H2(658),G1H2(659),G1H2(660),G1H2(661),2)
  call HG1shiftOLR(G1H2(658),8,2)
  call Hotf_4pt_reduction(G2H2(457),RedSet_4(15),mass4set(:,15),  & 
G1H2(662),G1H2(663),G1H2(664),G1H2(665),G1H2(666),2)
  call HG1shiftOLR(G1H2(663),8,2)
  call Hotf_4pt_reduction(G2H2(36),RedSet_4(25),mass4set(:,21),  & 
G1H2(667),G1H2(668),G1H2(669),G1H2(670),G1H2(671),2)
  call HG1shiftOLR(G1H2(668),8,2)
  call Hotf_4pt_reduction(G2H2(467),RedSet_4(15),mass4set(:,15),  & 
G1H2(672),G1H2(673),G1H2(674),G1H2(675),G1H2(676),2)
  call HG1shiftOLR(G1H2(673),8,2)
  call Hotf_4pt_reduction(G2H2(44),RedSet_4(28),mass4set(:,21),  & 
G1H2(677),G1H2(678),G1H2(679),G1H2(680),G1H2(681),2)
  call HG1shiftOLR(G1H2(678),4,2)
  call Hotf_4pt_reduction(G2H2(479),RedSet_4(22),mass4set(:,15),  & 
G1H2(682),G1H2(683),G1H2(684),G1H2(685),G1H2(686),2)
  call HG1shiftOLR(G1H2(683),4,2)
  call Hotf_4pt_reduction(G2H2(50),RedSet_4(28),mass4set(:,21),  & 
G1H2(687),G1H2(688),G1H2(689),G1H2(690),G1H2(691),2)
  call HG1shiftOLR(G1H2(688),4,2)
  call Hotf_4pt_reduction(G2H2(489),RedSet_4(22),mass4set(:,15),  & 
G1H2(692),G1H2(693),G1H2(694),G1H2(695),G1H2(696),2)
  call HG1shiftOLR(G1H2(693),4,2)
  call Hotf_4pt_reduction(G2H2(63),RedSet_4(41),mass4set(:,23),  & 
G1H2(697),G1H2(698),G1H2(699),G1H2(700),G1H2(701),2)
  call HG1shiftOLR(G1H2(698),2,2)
  call Hotf_4pt_reduction(G2H2(65),RedSet_4(42),mass4set(:,12),  & 
G1H2(702),G1H2(703),G1H2(704),G1H2(705),G1H2(706),2)
  call HG1shiftOLR(G1H2(703),2,2)
  call Hotf_4pt_reduction(G2H2(66),RedSet_4(41),mass4set(:,23),  & 
G1H2(707),G1H2(708),G1H2(709),G1H2(710),G1H2(711),2)
  call HG1shiftOLR(G1H2(708),2,2)
  call Hotf_4pt_reduction(G2H2(68),RedSet_4(42),mass4set(:,12),  & 
G1H2(712),G1H2(713),G1H2(714),G1H2(715),G1H2(716),2)
  call HG1shiftOLR(G1H2(713),2,2)
  call Hotf_4pt_reduction(G2H2(75),RedSet_4(44),mass4set(:,23),  & 
G1H2(717),G1H2(718),G1H2(719),G1H2(720),G1H2(721),2)
  call HG1shiftOLR(G1H2(718),2,2)
  call Hotf_4pt_reduction(G2H2(77),RedSet_4(45),mass4set(:,12),  & 
G1H2(722),G1H2(723),G1H2(724),G1H2(725),G1H2(726),2)
  call HG1shiftOLR(G1H2(723),2,2)
  call Hotf_4pt_reduction(G2H2(78),RedSet_4(44),mass4set(:,23),  & 
G1H2(727),G1H2(728),G1H2(729),G1H2(730),G1H2(731),2)
  call HG1shiftOLR(G1H2(728),2,2)
  call Hotf_4pt_reduction(G2H2(80),RedSet_4(45),mass4set(:,12),  & 
G1H2(732),G1H2(733),G1H2(734),G1H2(735),G1H2(736),2)
  call HG1shiftOLR(G1H2(733),2,2)
  call Hcheck_last_TV_S(ntryL,l_switch,G1H2(119),23,ex4(:),8,G2tensor(101),m3h2x1(:,275),heltab2x2(:,:,275))
  call Hcheck_last_TV_S(ntryL,l_switch,G1H2(190),23,ex4(:),8,G2tensor(19),m3h2x1(:,276),heltab2x2(:,:,276))
  call Hcheck_last_TV_S(ntryL,l_switch,G2H2(743),23,ex4(:),8,G3tensor(1),m3h2x1(:,277),heltab2x2(:,:,277))
  call Hcheck_last_UV_W(ntryL,l_switch,G1H2(124),23,ex4(:),8,G2tensor(17),m3h2x1(:,278),heltab2x2(:,:,278))
  call Hcheck_last_UV_W(ntryL,l_switch,G1H2(201),23,ex4(:),8,G2tensor(109),m3h2x1(:,279),heltab2x2(:,:,279))
  call Hcheck_last_UV_W(ntryL,l_switch,G2H2(767),23,ex4(:),8,G3tensor(2),m3h2x1(:,280),heltab2x2(:,:,280))
  call Hcheck_last_SV_T(ntryL,l_switch,G1H2(129),23,ex4(:),8,G2tensor(23),m3h2x1(:,281),heltab2x2(:,:,281))
  call Hcheck_last_SV_T(ntryL,l_switch,G1H2(146),23,ex4(:),8,G2tensor(21),m3h2x1(:,282),heltab2x2(:,:,282))
  call Hcheck_last_SV_T(ntryL,l_switch,G2H2(746),23,ex4(:),8,G3tensor(3),m3h2x1(:,283),heltab2x2(:,:,283))
  call Hcheck_last_UW_V(ntryL,l_switch,G1H2(134),23,ex4(:),8,G2tensor(117),m3h2x1(:,284),heltab2x2(:,:,284))
  call Hcheck_last_UW_V(ntryL,l_switch,G1H2(157),23,ex4(:),8,G2tensor(27),m3h2x1(:,285),heltab2x2(:,:,285))
  call Hcheck_last_UW_V(ntryL,l_switch,G2H2(770),23,ex4(:),8,G3tensor(4),m3h2x1(:,286),heltab2x2(:,:,286))
  call Hotf_4pt_reduction(G2H2(136),RedSet_4(31),mass4set(:,24),  & 
G1H2(119),G1H2(190),G1H2(124),G1H2(201),G1H2(129),2)
  call HG1shiftOLR(G1H2(190),8,2)
  call Hcheck_last_SV_T(ntryL,l_switch,G1H2(145),23,ex4(:),8,G2tensor(25),m3h2x1(:,287),heltab2x2(:,:,287))
  call Hcheck_last_SV_T(ntryL,l_switch,G1H2(306),23,ex4(:),8,G2tensor(125),m3h2x1(:,288),heltab2x2(:,:,288))
  call Hotf_4pt_reduction(G2H2(146),RedSet_4(31),mass4set(:,24),  & 
G1H2(146),G1H2(134),G1H2(157),G1H2(145),G1H2(306),2)
  call HG1shiftOLR(G1H2(134),8,2)
  call Hcheck_last_UW_V(ntryL,l_switch,G1H2(156),23,ex4(:),8,G2tensor(31),m3h2x1(:,289),heltab2x2(:,:,289))
  call Hcheck_last_UW_V(ntryL,l_switch,G1H2(322),23,ex4(:),8,G2tensor(29),m3h2x1(:,290),heltab2x2(:,:,290))
  call Hotf_4pt_reduction(G2H2(147),RedSet_4(33),mass4set(:,24),  & 
G1H2(156),G1H2(322),G1H2(737),G1H2(738),G1H2(739),2)
  call HG1shiftOLR(G1H2(322),4,2)
  call Hotf_4pt_reduction(G2H2(21),RedSet_4(34),mass4set(:,10),  & 
G1H2(740),G1H2(741),G1H2(742),G1H2(743),G1H2(744),2)
  call HG1shiftOLR(G1H2(741),4,2)
  call Hcheck_last_SV_T(ntryL,l_switch,G1H2(167),27,ex3(:),4,G2tensor(41),m3h2x1(:,291),heltab2x2(:,:,291))
  call Hcheck_last_SV_T(ntryL,l_switch,G1H2(168),27,ex3(:),4,G2tensor(45),m3h2x1(:,292),heltab2x2(:,:,292))
  call Hcheck_last_SV_T(ntryL,l_switch,G1H2(404),27,ex3(:),4,G2tensor(85),m3h2x1(:,293),heltab2x2(:,:,293))
  call Hotf_4pt_reduction(G2H2(166),RedSet_4(33),mass4set(:,24),  & 
G1H2(167),G1H2(168),G1H2(404),G1H2(745),G1H2(746),2)
  call HG1shiftOLR(G1H2(168),4,2)
  call Hotf_4pt_reduction(G2H2(24),RedSet_4(34),mass4set(:,10),  & 
G1H2(747),G1H2(748),G1H2(749),G1H2(750),G1H2(751),2)
  call HG1shiftOLR(G1H2(748),4,2)
  call Hcheck_last_UW_V(ntryL,l_switch,G1H2(178),27,ex3(:),4,G2tensor(91),m3h2x1(:,294),heltab2x2(:,:,294))
  call Hcheck_last_UW_V(ntryL,l_switch,G1H2(179),27,ex3(:),4,G2tensor(52),m3h2x1(:,295),heltab2x2(:,:,295))
  call Hcheck_last_UW_V(ntryL,l_switch,G1H2(420),27,ex3(:),4,G2tensor(58),m3h2x1(:,296),heltab2x2(:,:,296))
  call Hotf_4pt_reduction(G2H2(167),RedSet_4(36),mass4set(:,24),  & 
G1H2(178),G1H2(179),G1H2(420),G1H2(752),G1H2(753),2)
  call HG1shiftOLR(G1H2(179),8,2)
  call Hcheck_last_TV_S(ntryL,l_switch,G1H2(189),23,ex4(:),8,G2tensor(64),m3h2x1(:,297),heltab2x2(:,:,297))
  call Hcheck_last_TV_S(ntryL,l_switch,G1H2(458),23,ex4(:),8,G2tensor(70),m3h2x1(:,298),heltab2x2(:,:,298))
  call Hotf_4pt_reduction(G2H2(162),RedSet_4(36),mass4set(:,24),  & 
G1H2(189),G1H2(458),G1H2(754),G1H2(755),G1H2(756),2)
  call HG1shiftOLR(G1H2(458),8,2)
  call Hcheck_last_UV_W(ntryL,l_switch,G1H2(200),23,ex4(:),8,G2tensor(76),m3h2x1(:,299),heltab2x2(:,:,299))
  call Hcheck_last_UV_W(ntryL,l_switch,G1H2(474),23,ex4(:),8,G2tensor(82),m3h2x1(:,300),heltab2x2(:,:,300))
  call Hotf_4pt_reduction(G2H2(171),RedSet_4(38),mass4set(:,24),  & 
G1H2(200),G1H2(474),G1H2(757),G1H2(758),G1H2(759),2)
  call HG1shiftOLR(G1H2(474),4,2)
  call Hotf_4pt_reduction(G2H2(26),RedSet_4(39),mass4set(:,10),  & 
G1H2(760),G1H2(761),G1H2(762),G1H2(763),G1H2(764),2)
  call HG1shiftOLR(G1H2(761),4,2)
  call Hcheck_last_TV_S(ntryL,l_switch,G1H2(211),27,ex3(:),4,G2tensor(105),m3h2x1(:,301),heltab2x2(:,:,301))
  call Hcheck_last_TV_S(ntryL,l_switch,G1H2(212),27,ex3(:),4,G2tensor(113),m3h2x1(:,302),heltab2x2(:,:,302))
  call Hcheck_last_TV_S(ntryL,l_switch,G1H2(512),27,ex3(:),4,G2tensor(121),m3h2x1(:,303),heltab2x2(:,:,303))
  call Hotf_4pt_reduction(G2H2(178),RedSet_4(38),mass4set(:,24),  & 
G1H2(211),G1H2(212),G1H2(512),G1H2(765),G1H2(766),2)
  call HG1shiftOLR(G1H2(212),4,2)
  call Hotf_4pt_reduction(G2H2(97),RedSet_4(39),mass4set(:,10),  & 
G1H2(767),G1H2(768),G1H2(769),G1H2(770),G1H2(771),2)
  call HG1shiftOLR(G1H2(768),4,2)
  call Hcheck_last_UV_W(ntryL,l_switch,G1H2(222),27,ex3(:),4,G2tensor(129),m3h2x1(:,304),heltab2x2(:,:,304))
  call Hcheck_last_UV_W(ntryL,l_switch,G1H2(223),27,ex3(:),4,G2tensor(43),m3h2x1(:,305),heltab2x2(:,:,305))
  call Hcheck_last_UV_W(ntryL,l_switch,G1H2(528),27,ex3(:),4,G2tensor(47),m3h2x1(:,306),heltab2x2(:,:,306))
  call Hotf_4pt_reduction(G2H2(104),RedSet_4(11),mass4set(:,7),  & 
G1H2(222),G1H2(223),G1H2(528),G1H2(772),G1H2(773),2)
  call HG1shiftOLR(G1H2(223),8,2)
  call Hloop_AV_Q(ntryL,G1H2(233),ex4(:),G1H1(1),m3h2x1(:,307),heltab2x2(:,:,307))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,nMT,G2tensor(88),n2h1(173))
  call Hloop_AV_Q(ntryL,G1H2(234),ex4(:),G1H1(1),m3h2x1(:,308),heltab2x2(:,:,308))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,nMT,G2tensor(94),n2h1(174))
  call Hloop_AV_Q(ntryL,G2H2(722),ex4(:),G2H1(1),m3h2x1(:,309),heltab2x2(:,:,309))
  call Hcheck_last_A_Q(ntryL,l_switch,G2H1(1),31,nMT,G3tensor(5),n2h1(175))
  call Hotf_4pt_reduction(G2H2(272),RedSet_4(11),mass4set(:,8),  & 
G1H2(233),G1H2(234),G1H2(774),G1H2(775),G1H2(776),2)
  call HG1shiftOLR(G1H2(234),8,2)
  call Hloop_AV_Q(ntryL,G1H2(244),ex4(:),G1H1(1),m3h2x1(:,310),heltab2x2(:,:,310))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,nMT,G2tensor(133),n2h1(176))
  call Hloop_AV_Q(ntryL,G1H2(245),ex4(:),G1H1(1),m3h2x1(:,311),heltab2x2(:,:,311))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,nMT,G2tensor(137),n2h1(177))
  call Hotf_4pt_reduction(G2H2(280),RedSet_4(11),mass4set(:,9),  & 
G1H2(244),G1H2(245),G1H2(777),G1H2(778),G1H2(779),2)
  call HG1shiftOLR(G1H2(245),8,2)
  call Hloop_AV_Q(ntryL,G1H2(255),ex4(:),G1H1(1),m3h2x1(:,312),heltab2x2(:,:,312))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,nMB,G2tensor(141),n2h1(178))
  call Hloop_AV_Q(ntryL,G1H2(560),ex4(:),G1H1(1),m3h2x1(:,313),heltab2x2(:,:,313))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,nMB,G2tensor(145),n2h1(179))
  call Hloop_AV_Q(ntryL,G2H2(734),ex4(:),G2H1(1),m3h2x1(:,314),heltab2x2(:,:,314))
  call Hcheck_last_A_Q(ntryL,l_switch,G2H1(1),31,nMB,G3tensor(6),n2h1(180))
  call Hotf_4pt_reduction(G2H2(264),RedSet_4(11),mass4set(:,11),  & 
G1H2(255),G1H2(560),G1H2(780),G1H2(781),G1H2(782),2)
  call HG1shiftOLR(G1H2(560),8,2)
  call Hloop_AV_Q(ntryL,G1H2(266),ex4(:),G1H1(1),m3h2x1(:,315),heltab2x2(:,:,315))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,nMT,G2tensor(149),n2h1(181))
  call Hloop_AV_Q(ntryL,G1H2(267),ex4(:),G1H1(1),m3h2x1(:,316),heltab2x2(:,:,316))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,nMT,G2tensor(153),n2h1(182))
  call Hotf_4pt_reduction(G2H2(293),RedSet_4(14),mass4set(:,25),  & 
G1H2(266),G1H2(267),G1H2(783),G1H2(784),G1H2(785),2)
  call HG1shiftOLR(G1H2(267),8,2)
  call Hotf_4pt_reduction(G2H2(405),RedSet_4(15),mass4set(:,13),  & 
G1H2(786),G1H2(787),G1H2(788),G1H2(789),G1H2(790),2)
  call HG1shiftOLR(G1H2(787),8,2)
  call Hloop_QV_A(ntryL,G1H2(277),ex4(:),G1H1(1),m3h2x1(:,317),heltab2x2(:,:,317))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,nMT,G2tensor(157),n2h1(183))
  call Hloop_QV_A(ntryL,G2H2(408),ex4(:),G2H1(1),m3h2x1(:,318),heltab2x2(:,:,318))
  call Hcheck_last_Q_A(ntryL,l_switch,G2H1(1),31,nMT,G3tensor(7),n2h1(184))
  call Hloop_QV_A(ntryL,G1H2(279),ex4(:),G1H1(1),m3h2x1(:,319),heltab2x2(:,:,319))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,nMT,G2tensor(162),n2h1(185))
  call Hotf_4pt_reduction(G2H2(296),RedSet_4(14),mass4set(:,26),  & 
G1H2(277),G1H2(279),G1H2(791),G1H2(792),G1H2(793),2)
  call HG1shiftOLR(G1H2(279),8,2)
  call Hloop_QV_A(ntryL,G1H2(288),ex4(:),G1H1(1),m3h2x1(:,320),heltab2x2(:,:,320))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,nMT,G2tensor(167),n2h1(186))
  call Hloop_QV_A(ntryL,G1H2(290),ex4(:),G1H1(1),m3h2x1(:,321),heltab2x2(:,:,321))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,nMT,G2tensor(171),n2h1(187))
  call Hotf_4pt_reduction(G2H2(409),RedSet_4(15),mass4set(:,14),  & 
G1H2(288),G1H2(290),G1H2(794),G1H2(795),G1H2(796),2)
  call HG1shiftOLR(G1H2(290),8,2)
  call Hloop_QV_A(ntryL,G2H2(412),ex4(:),G2H1(1),m3h2x1(:,322),heltab2x2(:,:,322))
  call Hcheck_last_Q_A(ntryL,l_switch,G2H1(1),31,nMB,G3tensor(8),n2h1(188))
  call Hloop_QV_A(ntryL,G1H2(539),ex4(:),G1H1(1),m3h2x1(:,323),heltab2x2(:,:,323))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,nMB,G2tensor(175),n2h1(189))
  call Hcheck_last_SV_T(ntryL,l_switch,G1H2(304),23,ex4(:),8,G2tensor(179),m3h2x1(:,324),heltab2x2(:,:,324))
  call Hcheck_last_SV_T(ntryL,l_switch,G2H2(416),23,ex4(:),8,G3tensor(9),m3h2x1(:,325),heltab2x2(:,:,325))
  call Hotf_4pt_reduction(G2H2(2),RedSet_4(14),mass4set(:,27),  & 
G1H2(539),G1H2(304),G1H2(797),G1H2(798),G1H2(799),2)
  call HG1shiftOLR(G1H2(304),8,2)
  call Hloop_QV_A(ntryL,G1H2(315),ex4(:),G1H1(1),m3h2x1(:,326),heltab2x2(:,:,326))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,nMT,G2tensor(183),n2h1(190))
  call Hloop_QV_A(ntryL,G1H2(317),ex4(:),G1H1(1),m3h2x1(:,327),heltab2x2(:,:,327))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,nMT,G2tensor(187),n2h1(191))
  call Hcheck_last_UW_V(ntryL,l_switch,G1H2(320),23,ex4(:),8,G2tensor(191),m3h2x1(:,328),heltab2x2(:,:,328))
  call Hcheck_last_UW_V(ntryL,l_switch,G2H2(426),23,ex4(:),8,G3tensor(10),m3h2x1(:,329),heltab2x2(:,:,329))
  call Hotf_4pt_reduction(G2H2(143),RedSet_4(19),mass4set(:,7),  & 
G1H2(315),G1H2(317),G1H2(320),G1H2(800),G1H2(801),2)
  call HG1shiftOLR(G1H2(317),8,2)
  call Hloop_QV_A(ntryL,G1H2(331),ex4(:),G1H1(1),m3h2x1(:,330),heltab2x2(:,:,330))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,nMT,G2tensor(196),n2h1(192))
  call Hloop_QV_A(ntryL,G1H2(332),ex4(:),G1H1(1),m3h2x1(:,331),heltab2x2(:,:,331))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,nMT,G2tensor(201),n2h1(193))
  call Hloop_QV_A(ntryL,G2H2(716),ex4(:),G2H1(1),m3h2x1(:,332),heltab2x2(:,:,332))
  call Hcheck_last_Q_A(ntryL,l_switch,G2H1(1),31,nMT,G3tensor(11),n2h1(194))
  call Hotf_4pt_reduction(G2H2(197),RedSet_4(19),mass4set(:,8),  & 
G1H2(331),G1H2(332),G1H2(802),G1H2(803),G1H2(804),2)
  call HG1shiftOLR(G1H2(332),8,2)
  call Hloop_QV_A(ntryL,G1H2(342),ex4(:),G1H1(1),m3h2x1(:,333),heltab2x2(:,:,333))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,nMT,G2tensor(205),n2h1(195))
  call Hloop_QV_A(ntryL,G1H2(343),ex4(:),G1H1(1),m3h2x1(:,334),heltab2x2(:,:,334))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,nMT,G2tensor(209),n2h1(196))
  call Hotf_4pt_reduction(G2H2(224),RedSet_4(19),mass4set(:,9),  & 
G1H2(342),G1H2(343),G1H2(805),G1H2(806),G1H2(807),2)
  call HG1shiftOLR(G1H2(343),8,2)
  call Hloop_QV_A(ntryL,G1H2(353),ex4(:),G1H1(1),m3h2x1(:,335),heltab2x2(:,:,335))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,nMB,G2tensor(214),n2h1(197))
  call Hloop_QV_A(ntryL,G1H2(538),ex4(:),G1H1(1),m3h2x1(:,336),heltab2x2(:,:,336))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,nMB,G2tensor(219),n2h1(198))
  call Hloop_QV_A(ntryL,G2H2(728),ex4(:),G2H1(1),m3h2x1(:,337),heltab2x2(:,:,337))
  call Hcheck_last_Q_A(ntryL,l_switch,G2H1(1),31,nMB,G3tensor(12),n2h1(199))
  call Hotf_4pt_reduction(G2H2(194),RedSet_4(19),mass4set(:,11),  & 
G1H2(353),G1H2(538),G1H2(808),G1H2(809),G1H2(810),2)
  call HG1shiftOLR(G1H2(538),8,2)
  call Hloop_QV_A(ntryL,G1H2(364),ex4(:),G1H1(1),m3h2x1(:,338),heltab2x2(:,:,338))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,nMT,G2tensor(223),n2h1(200))
  call Hloop_QV_A(ntryL,G1H2(365),ex4(:),G1H1(1),m3h2x1(:,339),heltab2x2(:,:,339))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,nMT,G2tensor(227),n2h1(201))
  call Hotf_4pt_reduction(G2H2(213),RedSet_4(21),mass4set(:,25),  & 
G1H2(364),G1H2(365),G1H2(811),G1H2(812),G1H2(813),2)
  call HG1shiftOLR(G1H2(365),4,2)
  call Hotf_4pt_reduction(G2H2(427),RedSet_4(22),mass4set(:,13),  & 
G1H2(814),G1H2(815),G1H2(816),G1H2(817),G1H2(818),2)
  call HG1shiftOLR(G1H2(815),4,2)
  call Hloop_QV_A(ntryL,G1H2(375),ex3(:),G1H1(1),m3h2x1(:,340),heltab2x2(:,:,340))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,nMT,G2tensor(232),n2h1(202))
  call Hloop_QV_A(ntryL,G2H2(430),ex3(:),G2H1(1),m3h2x1(:,341),heltab2x2(:,:,341))
  call Hcheck_last_Q_A(ntryL,l_switch,G2H1(1),31,nMT,G3tensor(13),n2h1(203))
  call Hloop_QV_A(ntryL,G1H2(377),ex3(:),G1H1(1),m3h2x1(:,342),heltab2x2(:,:,342))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,nMT,G2tensor(237),n2h1(204))
  call Hotf_4pt_reduction(G2H2(227),RedSet_4(21),mass4set(:,26),  & 
G1H2(375),G1H2(377),G1H2(819),G1H2(820),G1H2(821),2)
  call HG1shiftOLR(G1H2(377),4,2)
  call Hloop_QV_A(ntryL,G1H2(386),ex3(:),G1H1(1),m3h2x1(:,343),heltab2x2(:,:,343))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,nMT,G2tensor(241),n2h1(205))
  call Hloop_QV_A(ntryL,G1H2(388),ex3(:),G1H1(1),m3h2x1(:,344),heltab2x2(:,:,344))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,nMT,G2tensor(245),n2h1(206))
  call Hotf_4pt_reduction(G2H2(431),RedSet_4(22),mass4set(:,14),  & 
G1H2(386),G1H2(388),G1H2(822),G1H2(823),G1H2(824),2)
  call HG1shiftOLR(G1H2(388),4,2)
  call Hloop_QV_A(ntryL,G2H2(434),ex3(:),G2H1(1),m3h2x1(:,345),heltab2x2(:,:,345))
  call Hcheck_last_Q_A(ntryL,l_switch,G2H1(1),31,nMB,G3tensor(14),n2h1(207))
  call Hloop_QV_A(ntryL,G1H2(550),ex3(:),G1H1(1),m3h2x1(:,346),heltab2x2(:,:,346))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,nMB,G2tensor(251),n2h1(208))
  call Hcheck_last_SV_T(ntryL,l_switch,G1H2(402),27,ex3(:),4,G2tensor(257),m3h2x1(:,347),heltab2x2(:,:,347))
  call Hcheck_last_SV_T(ntryL,l_switch,G2H2(438),27,ex3(:),4,G3tensor(15),m3h2x1(:,348),heltab2x2(:,:,348))
  call Hotf_4pt_reduction(G2H2(254),RedSet_4(21),mass4set(:,27),  & 
G1H2(550),G1H2(402),G1H2(825),G1H2(826),G1H2(827),2)
  call HG1shiftOLR(G1H2(402),4,2)
  call Hloop_QV_A(ntryL,G1H2(413),ex3(:),G1H1(1),m3h2x1(:,349),heltab2x2(:,:,349))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,nMT,G2tensor(258),n2h1(209))
  call Hloop_QV_A(ntryL,G1H2(415),ex3(:),G1H1(1),m3h2x1(:,350),heltab2x2(:,:,350))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,nMT,G2tensor(259),n2h1(210))
  call Hcheck_last_UW_V(ntryL,l_switch,G1H2(418),27,ex3(:),4,G2tensor(260),m3h2x1(:,351),heltab2x2(:,:,351))
  call Hcheck_last_UW_V(ntryL,l_switch,G2H2(448),27,ex3(:),4,G3tensor(16),m3h2x1(:,352),heltab2x2(:,:,352))
  call Hotf_4pt_reduction(G2H2(285),RedSet_4(25),mass4set(:,25),  & 
G1H2(413),G1H2(415),G1H2(418),G1H2(828),G1H2(829),2)
  call HG1shiftOLR(G1H2(415),8,2)
  call Hotf_4pt_reduction(G2H2(449),RedSet_4(15),mass4set(:,13),  & 
G1H2(830),G1H2(831),G1H2(832),G1H2(833),G1H2(834),2)
  call HG1shiftOLR(G1H2(831),8,2)
  call Hloop_AV_Q(ntryL,G1H2(429),ex4(:),G1H1(1),m3h2x1(:,353),heltab2x2(:,:,353))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,nMT,G2tensor(261),n2h1(211))
  call Hloop_AV_Q(ntryL,G2H2(452),ex4(:),G2H1(1),m3h2x1(:,354),heltab2x2(:,:,354))
  call Hcheck_last_A_Q(ntryL,l_switch,G2H1(1),31,nMT,G3tensor(17),n2h1(212))
  call Hloop_AV_Q(ntryL,G1H2(431),ex4(:),G1H1(1),m3h2x1(:,355),heltab2x2(:,:,355))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,nMT,G2tensor(262),n2h1(213))
  call Hotf_4pt_reduction(G2H2(289),RedSet_4(25),mass4set(:,26),  & 
G1H2(429),G1H2(431),G1H2(835),G1H2(836),G1H2(837),2)
  call HG1shiftOLR(G1H2(431),8,2)
  call Hloop_AV_Q(ntryL,G1H2(440),ex4(:),G1H1(1),m3h2x1(:,356),heltab2x2(:,:,356))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,nMT,G2tensor(263),n2h1(214))
  call Hloop_AV_Q(ntryL,G1H2(442),ex4(:),G1H1(1),m3h2x1(:,357),heltab2x2(:,:,357))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,nMT,G2tensor(264),n2h1(215))
  call Hotf_4pt_reduction(G2H2(301),RedSet_4(25),mass4set(:,22),  & 
G1H2(440),G1H2(442),G1H2(838),G1H2(839),G1H2(840),2)
  call HG1shiftOLR(G1H2(442),8,2)
  call Hotf_4pt_reduction(G2H2(453),RedSet_4(15),mass4set(:,14),  & 
G1H2(841),G1H2(842),G1H2(843),G1H2(844),G1H2(845),2)
  call HG1shiftOLR(G1H2(842),8,2)
  call Hloop_AV_Q(ntryL,G1H2(451),ex4(:),G1H1(1),m3h2x1(:,358),heltab2x2(:,:,358))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,nMB,G2tensor(265),n2h1(216))
  call Hloop_AV_Q(ntryL,G2H2(456),ex4(:),G2H1(1),m3h2x1(:,359),heltab2x2(:,:,359))
  call Hcheck_last_A_Q(ntryL,l_switch,G2H1(1),31,nMB,G3tensor(18),n2h1(217))
  call Hloop_AV_Q(ntryL,G1H2(561),ex4(:),G1H1(1),m3h2x1(:,360),heltab2x2(:,:,360))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,nMB,G2tensor(266),n2h1(218))
  call Hcheck_last_TV_S(ntryL,l_switch,G1H2(456),23,ex4(:),8,G2tensor(267),m3h2x1(:,361),heltab2x2(:,:,361))
  call Hcheck_last_TV_S(ntryL,l_switch,G2H2(460),23,ex4(:),8,G3tensor(19),m3h2x1(:,362),heltab2x2(:,:,362))
  call Hotf_4pt_reduction(G2H2(30),RedSet_4(25),mass4set(:,27),  & 
G1H2(451),G1H2(561),G1H2(456),G1H2(846),G1H2(847),2)
  call HG1shiftOLR(G1H2(561),8,2)
  call Hloop_AV_Q(ntryL,G1H2(467),ex4(:),G1H1(1),m3h2x1(:,363),heltab2x2(:,:,363))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,nMT,G2tensor(268),n2h1(219))
  call Hloop_AV_Q(ntryL,G1H2(469),ex4(:),G1H1(1),m3h2x1(:,364),heltab2x2(:,:,364))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,nMT,G2tensor(269),n2h1(220))
  call Hcheck_last_UV_W(ntryL,l_switch,G1H2(472),23,ex4(:),8,G2tensor(270),m3h2x1(:,365),heltab2x2(:,:,365))
  call Hcheck_last_UV_W(ntryL,l_switch,G2H2(470),23,ex4(:),8,G3tensor(20),m3h2x1(:,366),heltab2x2(:,:,366))
  call Hotf_4pt_reduction(G2H2(38),RedSet_4(28),mass4set(:,25),  & 
G1H2(467),G1H2(469),G1H2(472),G1H2(848),G1H2(849),2)
  call HG1shiftOLR(G1H2(469),4,2)
  call Hotf_4pt_reduction(G2H2(471),RedSet_4(22),mass4set(:,13),  & 
G1H2(850),G1H2(851),G1H2(852),G1H2(853),G1H2(854),2)
  call HG1shiftOLR(G1H2(851),4,2)
  call Hloop_AV_Q(ntryL,G1H2(483),ex3(:),G1H1(1),m3h2x1(:,367),heltab2x2(:,:,367))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,nMT,G2tensor(271),n2h1(221))
  call Hloop_AV_Q(ntryL,G2H2(474),ex3(:),G2H1(1),m3h2x1(:,368),heltab2x2(:,:,368))
  call Hcheck_last_A_Q(ntryL,l_switch,G2H1(1),31,nMT,G3tensor(21),n2h1(222))
  call Hloop_AV_Q(ntryL,G1H2(485),ex3(:),G1H1(1),m3h2x1(:,369),heltab2x2(:,:,369))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,nMT,G2tensor(272),n2h1(223))
  call Hotf_4pt_reduction(G2H2(40),RedSet_4(28),mass4set(:,26),  & 
G1H2(483),G1H2(485),G1H2(855),G1H2(856),G1H2(857),2)
  call HG1shiftOLR(G1H2(485),4,2)
  call Hloop_AV_Q(ntryL,G1H2(494),ex3(:),G1H1(1),m3h2x1(:,370),heltab2x2(:,:,370))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,nMT,G2tensor(273),n2h1(224))
  call Hloop_AV_Q(ntryL,G1H2(496),ex3(:),G1H1(1),m3h2x1(:,371),heltab2x2(:,:,371))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,nMT,G2tensor(274),n2h1(225))
  call Hotf_4pt_reduction(G2H2(42),RedSet_4(28),mass4set(:,22),  & 
G1H2(494),G1H2(496),G1H2(858),G1H2(859),G1H2(860),2)
  call HG1shiftOLR(G1H2(496),4,2)
  call Hotf_4pt_reduction(G2H2(475),RedSet_4(22),mass4set(:,14),  & 
G1H2(861),G1H2(862),G1H2(863),G1H2(864),G1H2(865),2)
  call HG1shiftOLR(G1H2(862),4,2)
  call Hloop_AV_Q(ntryL,G1H2(505),ex3(:),G1H1(1),m3h2x1(:,372),heltab2x2(:,:,372))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,nMB,G2tensor(275),n2h1(226))
  call Hloop_AV_Q(ntryL,G2H2(478),ex3(:),G2H1(1),m3h2x1(:,373),heltab2x2(:,:,373))
  call Hcheck_last_A_Q(ntryL,l_switch,G2H1(1),31,nMB,G3tensor(22),n2h1(227))
  call Hloop_AV_Q(ntryL,G1H2(582),ex3(:),G1H1(1),m3h2x1(:,374),heltab2x2(:,:,374))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,nMB,G2tensor(276),n2h1(228))
  call Hcheck_last_TV_S(ntryL,l_switch,G1H2(510),27,ex3(:),4,G2tensor(277),m3h2x1(:,375),heltab2x2(:,:,375))
  call Hcheck_last_TV_S(ntryL,l_switch,G2H2(482),27,ex3(:),4,G3tensor(23),m3h2x1(:,376),heltab2x2(:,:,376))
  call Hotf_4pt_reduction(G2H2(45),RedSet_4(28),mass4set(:,27),  & 
G1H2(505),G1H2(582),G1H2(510),G1H2(866),G1H2(867),2)
  call HG1shiftOLR(G1H2(582),4,2)
  call Hloop_AV_Q(ntryL,G1H2(521),ex3(:),G1H1(1),m3h2x1(:,377),heltab2x2(:,:,377))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,nMT,G2tensor(278),n2h1(229))
  call Hloop_AV_Q(ntryL,G1H2(523),ex3(:),G1H1(1),m3h2x1(:,378),heltab2x2(:,:,378))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,nMT,G2tensor(279),n2h1(230))
  call Hcheck_last_UV_W(ntryL,l_switch,G1H2(526),27,ex3(:),4,G2tensor(280),m3h2x1(:,379),heltab2x2(:,:,379))
  call Hcheck_last_UV_W(ntryL,l_switch,G2H2(492),27,ex3(:),4,G3tensor(24),m3h2x1(:,380),heltab2x2(:,:,380))
  call Hotf_4pt_reduction(G2H2(53),RedSet_4(31),mass4set(:,28),  & 
G1H2(521),G1H2(523),G1H2(526),G1H2(868),G1H2(869),2)
  call HG1shiftOLR(G1H2(523),8,2)
  call Hloop_QV_A(ntryL,G1H2(537),ex4(:),G1H1(1),m3h2x1(:,381),heltab2x2(:,:,381))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,nMB,G2tensor(281),n2h1(231))
  call Hotf_4pt_reduction(G2H2(57),RedSet_4(33),mass4set(:,28),  & 
G1H2(537),G1H2(870),G1H2(871),G1H2(872),G1H2(873),2)
  call HG1shiftOLR(G1H2(870),4,2)
  call Hotf_4pt_reduction(G2H2(59),RedSet_4(34),mass4set(:,9),  & 
G1H2(874),G1H2(875),G1H2(876),G1H2(877),G1H2(878),2)
  call HG1shiftOLR(G1H2(875),4,2)
  call Hloop_QV_A(ntryL,G1H2(548),ex3(:),G1H1(1),m3h2x1(:,382),heltab2x2(:,:,382))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,nMB,G2tensor(282),n2h1(232))
  call Hloop_QV_A(ntryL,G1H2(549),ex3(:),G1H1(1),m3h2x1(:,383),heltab2x2(:,:,383))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,nMB,G2tensor(283),n2h1(233))
  call Hotf_4pt_reduction(G2H2(62),RedSet_4(36),mass4set(:,28),  & 
G1H2(548),G1H2(549),G1H2(879),G1H2(880),G1H2(881),2)
  call HG1shiftOLR(G1H2(549),8,2)
  call Hloop_AV_Q(ntryL,G1H2(559),ex4(:),G1H1(1),m3h2x1(:,384),heltab2x2(:,:,384))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,nMB,G2tensor(284),n2h1(234))
  call Hloop_SA_Q(ntryL,G1H2(564),ex2(:),G1H1(1),ngPtb,m3h2x1(:,385),heltab2x2(:,:,385))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,nMB,G2tensor(285),n2h1(235))
  call Hloop_SA_Q(ntryL,G1H2(565),ex2(:),G1H1(1),ngPtb,m3h2x1(:,386),heltab2x2(:,:,386))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,nMB,G2tensor(286),n2h1(236))
  call Hloop_SA_Q(ntryL,G1H2(587),ex2(:),G1H1(1),ngPtb,m3h2x1(:,387),heltab2x2(:,:,387))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,nMB,G2tensor(287),n2h1(237))
  call Hloop_WA_Q(ntryL,G1H2(569),ex2(:),G1H1(1),m3h2x1(:,388),heltab2x2(:,:,388))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,nMB,G2tensor(288),n2h1(238))
  call Hloop_WA_Q(ntryL,G1H2(570),ex2(:),G1H1(1),m3h2x1(:,389),heltab2x2(:,:,389))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,nMB,G2tensor(289),n2h1(239))
  call Hloop_WA_Q(ntryL,G1H2(592),ex2(:),G1H1(1),m3h2x1(:,390),heltab2x2(:,:,390))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,nMB,G2tensor(290),n2h1(240))
  call Hotf_4pt_reduction(G2H2(72),RedSet_4(38),mass4set(:,28),  & 
G1H2(559),G1H2(564),G1H2(565),G1H2(587),G1H2(569),2)
  call HG1shiftOLR(G1H2(564),4,2)
  call Hotf_4pt_reduction(G2H2(74),RedSet_4(39),mass4set(:,9),  & 
G1H2(570),G1H2(592),G1H2(882),G1H2(883),G1H2(884),2)
  call HG1shiftOLR(G1H2(592),4,2)
  call Hloop_AV_Q(ntryL,G1H2(580),ex3(:),G1H1(1),m3h2x1(:,391),heltab2x2(:,:,391))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,nMB,G2tensor(291),n2h1(241))
  call Hloop_AV_Q(ntryL,G1H2(581),ex3(:),G1H1(1),m3h2x1(:,392),heltab2x2(:,:,392))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,nMB,G2tensor(292),n2h1(242))
  call Hloop_SA_Q(ntryL,G1H2(585),ex2(:),G1H1(1),ngPtb,m3h2x1(:,393),heltab2x2(:,:,393))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,nMB,G2tensor(293),n2h1(243))
  call Hloop_SA_Q(ntryL,G1H2(586),ex2(:),G1H1(1),ngPtb,m3h2x1(:,394),heltab2x2(:,:,394))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,nMB,G2tensor(294),n2h1(244))
  call Hloop_WA_Q(ntryL,G1H2(590),ex2(:),G1H1(1),m3h2x1(:,395),heltab2x2(:,:,395))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,nMB,G2tensor(295),n2h1(245))
  call Hloop_WA_Q(ntryL,G1H2(591),ex2(:),G1H1(1),m3h2x1(:,396),heltab2x2(:,:,396))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,nMB,G2tensor(296),n2h1(246))
  call Hcheck_last_QA_W(ntryL,l_switch,G2H2(360),ex2(:),G2tensor(297),m3h2x1(:,397),heltab2x2(:,:,397))
  call Hcheck_last_VV_S(ntryL,l_switch,G2H2(7),ex4(:),G2tensor(298),m3h2x1(:,398),heltab2x2(:,:,398))
  call Hcheck_last_QA_S(ntryL,l_switch,G2H2(357),ex2(:),G2tensor(299),ngPtb,m3h2x1(:,399),heltab2x2(:,:,399))
  call Hcheck_last_SV_V(ntryL,l_switch,G2H2(13),ex4(:),G2tensor(300),m3h2x1(:,400),heltab2x2(:,:,400))
  call Hcheck_last_AQ_W(ntryL,l_switch,G2H2(366),ex1(:),G2tensor(301),m3h2x1(:,401),heltab2x2(:,:,401))
  call Hcheck_last_VV_S(ntryL,l_switch,G2H2(17),ex4(:),G2tensor(302),m3h2x1(:,402),heltab2x2(:,:,402))
  call Hcheck_last_AQ_S(ntryL,l_switch,G2H2(363),ex1(:),G2tensor(303),ngPbt,m3h2x1(:,403),heltab2x2(:,:,403))
  call Hcheck_last_SV_V(ntryL,l_switch,G2H2(19),ex4(:),G2tensor(304),m3h2x1(:,404),heltab2x2(:,:,404))
  call Hcheck_last_SV_V(ntryL,l_switch,G2H2(22),ex3(:),G2tensor(305),m3h2x1(:,405),heltab2x2(:,:,405))
  call Hcheck_last_VV_S(ntryL,l_switch,G2H2(23),ex3(:),G2tensor(306),m3h2x1(:,406),heltab2x2(:,:,406))
  call Hcheck_last_SV_V(ntryL,l_switch,G2H2(27),ex3(:),G2tensor(307),m3h2x1(:,407),heltab2x2(:,:,407))
  call Hcheck_last_VV_S(ntryL,l_switch,G2H2(28),ex3(:),G2tensor(308),m3h2x1(:,408),heltab2x2(:,:,408))
  call Hcheck_last_SV_V(ntryL,l_switch,G2H2(3),ex4(:),G2tensor(309),m3h2x1(:,409),heltab2x2(:,:,409))
  call Hcheck_last_VV_S(ntryL,l_switch,G2H2(4),ex4(:),G2tensor(310),m3h2x1(:,410),heltab2x2(:,:,410))
  call Hcheck_last_SV_V(ntryL,l_switch,G2H2(243),ex3(:),G2tensor(311),m3h2x1(:,411),heltab2x2(:,:,411))
  call Hcheck_last_VV_S(ntryL,l_switch,G2H2(257),ex3(:),G2tensor(312),m3h2x1(:,412),heltab2x2(:,:,412))
  call Hcheck_last_SV_V(ntryL,l_switch,G2H2(32),ex4(:),G2tensor(313),m3h2x1(:,413),heltab2x2(:,:,413))
  call Hcheck_last_VV_S(ntryL,l_switch,G2H2(34),ex4(:),G2tensor(314),m3h2x1(:,414),heltab2x2(:,:,414))
  call Hcheck_last_SV_V(ntryL,l_switch,G2H2(47),ex3(:),G2tensor(315),m3h2x1(:,415),heltab2x2(:,:,415))
  call Hcheck_last_VV_S(ntryL,l_switch,G2H2(48),ex3(:),G2tensor(316),m3h2x1(:,416),heltab2x2(:,:,416))
  call Hcheck_last_QA_S(ntryL,l_switch,G2H2(495),ex2(:),G2tensor(317),ngPtb,m3h2x1(:,417),heltab2x2(:,:,417))
  call Hcheck_last_QA_S(ntryL,l_switch,G2H2(389),ex2(:),G2tensor(318),ngPtb,m3h2x1(:,418),heltab2x2(:,:,418))
  call Hcheck_last_QA_W(ntryL,l_switch,G2H2(498),ex2(:),G2tensor(319),m3h2x1(:,419),heltab2x2(:,:,419))
  call Hcheck_last_QA_W(ntryL,l_switch,G2H2(392),ex2(:),G2tensor(320),m3h2x1(:,420),heltab2x2(:,:,420))
  call Hcheck_last_QA_S(ntryL,l_switch,G2H2(501),ex2(:),G2tensor(321),ngPtb,m3h2x1(:,421),heltab2x2(:,:,421))
  call Hcheck_last_QA_S(ntryL,l_switch,G2H2(401),ex2(:),G2tensor(322),ngPtb,m3h2x1(:,422),heltab2x2(:,:,422))
  call Hcheck_last_QA_W(ntryL,l_switch,G2H2(504),ex2(:),G2tensor(323),m3h2x1(:,423),heltab2x2(:,:,423))
  call Hcheck_last_QA_W(ntryL,l_switch,G2H2(404),ex2(:),G2tensor(324),m3h2x1(:,424),heltab2x2(:,:,424))
  call Hcheck_last_VV_S(ntryL,l_switch,G2H2(120),ex4(:),G2tensor(325),m3h2x1(:,425),heltab2x2(:,:,425))
  call Hcheck_last_SV_V(ntryL,l_switch,G2H2(121),ex4(:),G2tensor(326),m3h2x1(:,426),heltab2x2(:,:,426))
  call Hcheck_last_VV_S(ntryL,l_switch,G2H2(128),ex4(:),G2tensor(327),m3h2x1(:,427),heltab2x2(:,:,427))
  call Hcheck_last_SV_V(ntryL,l_switch,G2H2(132),ex4(:),G2tensor(328),m3h2x1(:,428),heltab2x2(:,:,428))
  call Hcheck_last_SV_V(ntryL,l_switch,G2H2(139),ex4(:),G2tensor(329),m3h2x1(:,429),heltab2x2(:,:,429))
  call Hcheck_last_VV_S(ntryL,l_switch,G2H2(142),ex4(:),G2tensor(330),m3h2x1(:,430),heltab2x2(:,:,430))
  call Hcheck_last_SV_V(ntryL,l_switch,G2H2(150),ex3(:),G2tensor(331),m3h2x1(:,431),heltab2x2(:,:,431))
  call Hcheck_last_VV_S(ntryL,l_switch,G2H2(163),ex3(:),G2tensor(332),m3h2x1(:,432),heltab2x2(:,:,432))
  call Hcheck_last_SV_V(ntryL,l_switch,G2H2(170),ex4(:),G2tensor(333),m3h2x1(:,433),heltab2x2(:,:,433))
  call Hcheck_last_VV_S(ntryL,l_switch,G2H2(159),ex4(:),G2tensor(334),m3h2x1(:,434),heltab2x2(:,:,434))
  call Hcheck_last_SV_V(ntryL,l_switch,G2H2(174),ex3(:),G2tensor(335),m3h2x1(:,435),heltab2x2(:,:,435))
  call Hcheck_last_VV_S(ntryL,l_switch,G2H2(175),ex3(:),G2tensor(336),m3h2x1(:,436),heltab2x2(:,:,436))
  call Hcheck_last_VV_S(ntryL,l_switch,G1H2(63),ex3(:),G1tensor(1),m3h2x1(:,437),heltab2x2(:,:,437))
  call Hcheck_last_SV_V(ntryL,l_switch,G1H2(64),ex3(:),G1tensor(7),m3h2x1(:,438),heltab2x2(:,:,438))
  call Hcheck_last_VV_S(ntryL,l_switch,G1H2(70),ex3(:),G1tensor(13),m3h2x1(:,439),heltab2x2(:,:,439))
  call Hcheck_last_SV_V(ntryL,l_switch,G1H2(454),ex3(:),G1tensor(19),m3h2x1(:,440),heltab2x2(:,:,440))
  call Hcheck_last_SVV_S(ntryL,l_switch,G2H4(167),ex4(:),ex3(:),G2tensor(337),m4h2x2x1(:,1),heltab3x4(:,:,1))
  call Hcheck_last_VWW_V(ntryL,l_switch,G2H4(95),ex4(:),ex3(:),G2tensor(338),m4h2x2x1(:,2),heltab3x4(:,:,2))
  call Hcheck_last_SVV_S(ntryL,l_switch,G2H4(175),ex4(:),ex3(:),G2tensor(339),m4h2x2x1(:,3),heltab3x4(:,:,3))
  call Hcheck_last_VWW_V(ntryL,l_switch,G2H4(99),ex4(:),ex3(:),G2tensor(340),m4h2x2x1(:,4),heltab3x4(:,:,4))
  call Hcheck_last_VV_S(ntryL,l_switch,G2H2(486),ex3(:),G2tensor(341),m3h2x1(:,441),heltab2x2(:,:,441))
  call Hcheck_last_SV_V(ntryL,l_switch,G2H2(483),ex3(:),G2tensor(342),m3h2x1(:,442),heltab2x2(:,:,442))
  call Hcheck_last_VV_S(ntryL,l_switch,G2H2(464),ex4(:),G2tensor(343),m3h2x1(:,443),heltab2x2(:,:,443))
  call Hcheck_last_SV_V(ntryL,l_switch,G2H2(461),ex4(:),G2tensor(344),m3h2x1(:,444),heltab2x2(:,:,444))
  call Hotf_4pt_reduction(G2H2(753),RedSet_4(12),mass4set(:,15),  & 
G1H2(580),G1H2(581),G1H2(585),G1H2(586),G1H2(590),2)
  call HG1shiftOLR(G1H2(581),8,2)
  call Hotf_4pt_reduction(G2H2(756),RedSet_4(12),mass4set(:,15),  & 
G1H2(591),G1H2(63),G1H2(64),G1H2(70),G1H2(454),2)
  call HG1shiftOLR(G1H2(63),8,2)
  call Hotf_4pt_reduction(G2H4(171),RedSet_4(7),mass4set(:,12),  & 
G1H4(343),G1H4(344),G1H4(349),G1H4(350),G1H4(361),4)
  call HG1shiftOLR(G1H4(344),5,4)
  call Hotf_4pt_reduction(G2H4(103),RedSet_4(7),mass4set(:,12),  & 
G1H4(362),G1H4(366),G1H4(367),G1H4(377),G1H4(378),4)
  call HG1shiftOLR(G1H4(366),5,4)
  call Hotf_4pt_reduction(G2H4(180),RedSet_4(3),mass4set(:,12),  & 
G1H4(382),G1H4(383),G1H4(393),G1H4(394),G1H4(398),4)
  call HG1shiftOLR(G1H4(383),6,4)
  call Hotf_4pt_reduction(G2H4(108),RedSet_4(3),mass4set(:,12),  & 
G1H4(399),G1H4(409),G1H4(410),G1H4(414),G1H4(415),4)
  call HG1shiftOLR(G1H4(409),6,4)
  call Hotf_4pt_reduction(G2H4(131),RedSet_4(6),mass4set(:,12),  & 
G1H4(47),G1H4(48),G1H4(51),G1H4(52),G1H4(53),4)
  call HG1shiftOLR(G1H4(48),9,4)
  call Hotf_4pt_reduction(G2H4(113),RedSet_4(6),mass4set(:,12),  & 
G1H4(54),G1H4(57),G1H4(58),G1H4(401),G1H4(121),4)
  call HG1shiftOLR(G1H4(57),9,4)
  call Hotf_4pt_reduction(G2H4(139),RedSet_4(5),mass4set(:,3),  & 
G1H4(412),G1H4(133),G1H4(9),G1H4(12),G1H4(11),4)
  call HG1shiftOLR(G1H4(133),9,4)
  call Hotf_4pt_reduction(G2H4(117),RedSet_4(5),mass4set(:,4),  & 
G1H4(14),G1H4(65),G1H4(66),G1H4(69),G1H4(70),4)
  call HG1shiftOLR(G1H4(65),9,4)
  call Hotf_4pt_reduction(G2H4(135),RedSet_4(5),mass4set(:,5),  & 
G1H4(89),G1H4(90),G1H4(93),G1H4(94),G1H4(143),4)
  call HG1shiftOLR(G1H4(90),9,4)
  call Hotf_4pt_reduction(G2H4(121),RedSet_4(5),mass4set(:,6),  & 
G1H4(144),G1H4(147),G1H4(148),G1H4(153),G1H4(154),4)
  call HG1shiftOLR(G1H4(147),9,4)
  call Hotf_4pt_reduction(G2H4(144),RedSet_4(5),mass4set(:,4),  & 
G1H4(156),G1H4(159),G1H4(160),G1H4(161),G1H4(165),4)
  call HG1shiftOLR(G1H4(159),9,4)
  call Hotf_4pt_reduction(G2H4(126),RedSet_4(5),mass4set(:,5),  & 
G1H4(166),G1H4(215),G1H4(216),G1H4(220),G1H4(221),4)
  call HG1shiftOLR(G1H4(215),9,4)
  call Hcheck_last_AQ_W(ntryL,l_switch,G2H4(237),wf4(:,9),G2tensor(345),m3h4x1(:,1),heltab2x4(:,:,813))
  call Hcheck_last_AQ_S(ntryL,l_switch,G2H4(107),wf4(:,9),G2tensor(346),ngPbt,m3h4x1(:,2),heltab2x4(:,:,814))
  call Hotf_4pt_reduction(G2H4(190),RedSet_4(2),mass4set(:,12),  & 
G1H4(222),G1H4(225),G1H4(227),G1H4(228),G1H4(231),4)
  call HG1shiftOLR(G1H4(225),10,4)
  call Hotf_4pt_reduction(G2H4(6),RedSet_4(2),mass4set(:,12),  & 
G1H4(232),G1H4(234),G1H4(237),G1H4(238),G1H4(239),4)
  call HG1shiftOLR(G1H4(234),10,4)
  call Hotf_4pt_reduction(G2H4(208),RedSet_4(4),mass4set(:,3),  & 
G1H4(243),G1H4(244),G1H4(279),G1H4(280),G1H4(282),4)
  call HG1shiftOLR(G1H4(244),10,4)
  call Hotf_4pt_reduction(G2H4(194),RedSet_4(4),mass4set(:,4),  & 
G1H4(285),G1H4(286),G1H4(287),G1H4(291),G1H4(292),4)
  call HG1shiftOLR(G1H4(286),10,4)
  call Hotf_4pt_reduction(G2H4(23),RedSet_4(4),mass4set(:,5),  & 
G1H4(293),G1H4(294),G1H4(298),G1H4(299),G1H4(300),4)
  call HG1shiftOLR(G1H4(294),10,4)
  call Hotf_4pt_reduction(G2H4(215),RedSet_4(4),mass4set(:,6),  & 
G1H4(303),G1H4(305),G1H4(306),G1H4(309),G1H4(310),4)
  call HG1shiftOLR(G1H4(305),10,4)
  call Hotf_4pt_reduction(G2H4(9),RedSet_4(4),mass4set(:,4),  & 
G1H4(312),G1H4(315),G1H4(316),G1H4(380),G1H4(391),4)
  call HG1shiftOLR(G1H4(315),10,4)
  call Hotf_4pt_reduction(G2H4(221),RedSet_4(4),mass4set(:,5),  & 
G1H4(395),G1H4(402),G1H4(416),G1H4(374),G1H4(384),4)
  call HG1shiftOLR(G1H4(402),10,4)
  call Hcheck_last_QA_W(ntryL,l_switch,G2H4(162),wf4(:,4),G2tensor(347),m3h4x1(:,3),heltab2x4(:,:,815))
  call Hcheck_last_QA_S(ntryL,l_switch,G2H4(153),wf4(:,4),G2tensor(348),ngPtb,m3h4x1(:,4),heltab2x4(:,:,816))
  call Hcheck_last_QA_S(ntryL,l_switch,G2H2(359),ex2(:),G2tensor(349),ngPtb,m3h2x1(:,445),heltab2x2(:,:,445))
  call Hcheck_last_QA_W(ntryL,l_switch,G2H2(362),ex2(:),G2tensor(350),m3h2x1(:,446),heltab2x2(:,:,446))
  call Hcheck_last_AQ_S(ntryL,l_switch,G2H2(365),ex1(:),G2tensor(351),ngPbt,m3h2x1(:,447),heltab2x2(:,:,447))
  call Hcheck_last_AQ_W(ntryL,l_switch,G2H2(368),ex1(:),G2tensor(352),m3h2x1(:,448),heltab2x2(:,:,448))
  call Hcheck_last_AQ_S(ntryL,l_switch,G2H2(369),ex1(:),G2tensor(353),ngPbt,m3h2x1(:,449),heltab2x2(:,:,449))
  call Hcheck_last_AQ_S(ntryL,l_switch,G2H2(371),ex1(:),G2tensor(354),ngPbt,m3h2x1(:,450),heltab2x2(:,:,450))
  call Hcheck_last_AQ_W(ntryL,l_switch,G2H2(372),ex1(:),G2tensor(355),m3h2x1(:,451),heltab2x2(:,:,451))
  call Hcheck_last_AQ_W(ntryL,l_switch,G2H2(374),ex1(:),G2tensor(356),m3h2x1(:,452),heltab2x2(:,:,452))
  call Hcheck_last_AQ_S(ntryL,l_switch,G2H2(375),ex1(:),G2tensor(357),ngPbt,m3h2x1(:,453),heltab2x2(:,:,453))
  call Hcheck_last_AQ_S(ntryL,l_switch,G2H2(377),ex1(:),G2tensor(358),ngPbt,m3h2x1(:,454),heltab2x2(:,:,454))
  call Hcheck_last_AQ_W(ntryL,l_switch,G2H2(378),ex1(:),G2tensor(359),m3h2x1(:,455),heltab2x2(:,:,455))
  call Hcheck_last_AQ_W(ntryL,l_switch,G2H2(380),ex1(:),G2tensor(360),m3h2x1(:,456),heltab2x2(:,:,456))
  call Hcheck_last_QA_S(ntryL,l_switch,G2H2(381),ex2(:),G2tensor(361),ngPtb,m3h2x1(:,457),heltab2x2(:,:,457))
  call Hcheck_last_QA_S(ntryL,l_switch,G2H2(383),ex2(:),G2tensor(362),ngPtb,m3h2x1(:,458),heltab2x2(:,:,458))
  call Hcheck_last_QA_W(ntryL,l_switch,G2H2(384),ex2(:),G2tensor(363),m3h2x1(:,459),heltab2x2(:,:,459))
  call Hcheck_last_QA_W(ntryL,l_switch,G2H2(386),ex2(:),G2tensor(364),m3h2x1(:,460),heltab2x2(:,:,460))
  call Hcheck_last_QA_S(ntryL,l_switch,G2H2(387),ex2(:),G2tensor(365),ngPtb,m3h2x1(:,461),heltab2x2(:,:,461))
  call Hcheck_last_QA_W(ntryL,l_switch,G2H2(390),ex2(:),G2tensor(366),m3h2x1(:,462),heltab2x2(:,:,462))
  call Hcheck_last_QA_S(ntryL,l_switch,G2H2(393),ex2(:),G2tensor(367),ngPtb,m3h2x1(:,463),heltab2x2(:,:,463))
  call Hcheck_last_QA_S(ntryL,l_switch,G2H2(395),ex2(:),G2tensor(368),ngPtb,m3h2x1(:,464),heltab2x2(:,:,464))
  call Hcheck_last_QA_W(ntryL,l_switch,G2H2(396),ex2(:),G2tensor(369),m3h2x1(:,465),heltab2x2(:,:,465))
  call Hcheck_last_QA_W(ntryL,l_switch,G2H2(398),ex2(:),G2tensor(370),m3h2x1(:,466),heltab2x2(:,:,466))
  call Hcheck_last_QA_S(ntryL,l_switch,G2H2(399),ex2(:),G2tensor(371),ngPtb,m3h2x1(:,467),heltab2x2(:,:,467))
  call Hcheck_last_QA_W(ntryL,l_switch,G2H2(402),ex2(:),G2tensor(372),m3h2x1(:,468),heltab2x2(:,:,468))
  call Hloop_QV_A(ntryL,G1H2(405),ex4(:),G1H1(1),m3h2x1(:,469),heltab2x2(:,:,469))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,nMT,G2tensor(373),n2h1(247))
  call Hloop_QV_A(ntryL,G1H2(417),ex4(:),G1H1(1),m3h2x1(:,470),heltab2x2(:,:,470))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,nMB,G2tensor(374),n2h1(248))
  call Hcheck_last_SV_T(ntryL,l_switch,G1H2(421),23,ex4(:),8,G2tensor(375),m3h2x1(:,471),heltab2x2(:,:,471))
  call Hcheck_last_SV_V(ntryL,l_switch,G2H2(463),ex4(:),G2tensor(376),m3h2x1(:,472),heltab2x2(:,:,472))
  call Hcheck_last_VV_S(ntryL,l_switch,G2H2(466),ex4(:),G2tensor(377),m3h2x1(:,473),heltab2x2(:,:,473))
  call Hcheck_last_UW_V(ntryL,l_switch,G1H2(428),23,ex4(:),8,G2tensor(378),m3h2x1(:,474),heltab2x2(:,:,474))
  call Hloop_QV_A(ntryL,G1H2(439),ex3(:),G1H1(1),m3h2x1(:,475),heltab2x2(:,:,475))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,nMT,G2tensor(379),n2h1(249))
  call Hloop_QV_A(ntryL,G1H2(450),ex3(:),G1H1(1),m3h2x1(:,476),heltab2x2(:,:,476))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,nMB,G2tensor(380),n2h1(250))
  call Hcheck_last_SV_T(ntryL,l_switch,G1H2(455),27,ex3(:),4,G2tensor(381),m3h2x1(:,477),heltab2x2(:,:,477))
  call Hcheck_last_SV_V(ntryL,l_switch,G2H2(485),ex3(:),G2tensor(382),m3h2x1(:,478),heltab2x2(:,:,478))
  call Hcheck_last_VV_S(ntryL,l_switch,G2H2(488),ex3(:),G2tensor(383),m3h2x1(:,479),heltab2x2(:,:,479))
  call Hcheck_last_UW_V(ntryL,l_switch,G1H2(465),27,ex3(:),4,G2tensor(384),m3h2x1(:,480),heltab2x2(:,:,480))
  call Hloop_AV_Q(ntryL,G1H2(476),ex4(:),G1H1(1),m3h2x1(:,481),heltab2x2(:,:,481))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,nMT,G2tensor(385),n2h1(251))
  call Hloop_AV_Q(ntryL,G1H2(487),ex4(:),G1H1(1),m3h2x1(:,482),heltab2x2(:,:,482))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,nMB,G2tensor(386),n2h1(252))
  call Hcheck_last_TV_S(ntryL,l_switch,G1H2(492),23,ex4(:),8,G2tensor(387),m3h2x1(:,483),heltab2x2(:,:,483))
  call Hcheck_last_UV_W(ntryL,l_switch,G1H2(498),23,ex4(:),8,G2tensor(388),m3h2x1(:,484),heltab2x2(:,:,484))
  call Hloop_AV_Q(ntryL,G1H2(513),ex3(:),G1H1(1),m3h2x1(:,485),heltab2x2(:,:,485))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,nMT,G2tensor(389),n2h1(253))
  call Hloop_AV_Q(ntryL,G1H2(525),ex3(:),G1H1(1),m3h2x1(:,486),heltab2x2(:,:,486))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,nMB,G2tensor(390),n2h1(254))
  call Hcheck_last_TV_S(ntryL,l_switch,G1H2(529),27,ex3(:),4,G2tensor(391),m3h2x1(:,487),heltab2x2(:,:,487))
  call Hcheck_last_UV_W(ntryL,l_switch,G1H2(536),27,ex3(:),4,G2tensor(392),m3h2x1(:,488),heltab2x2(:,:,488))
  call Hcheck_last_QA_S(ntryL,l_switch,G2H2(493),ex2(:),G2tensor(393),ngPtb,m3h2x1(:,489),heltab2x2(:,:,489))
  call Hcheck_last_QA_W(ntryL,l_switch,G2H2(496),ex2(:),G2tensor(394),m3h2x1(:,490),heltab2x2(:,:,490))
  call Hcheck_last_QA_S(ntryL,l_switch,G2H2(499),ex2(:),G2tensor(395),ngPtb,m3h2x1(:,491),heltab2x2(:,:,491))
  call Hcheck_last_QA_W(ntryL,l_switch,G2H2(502),ex2(:),G2tensor(396),m3h2x1(:,492),heltab2x2(:,:,492))
  call Hotf_4pt_reduction(G2H2(505),RedSet_4(22),mass4set(:,17),  & 
G1H2(405),G1H2(417),G1H2(421),G1H2(428),G1H2(439),2)
  call HG1shiftOLR(G1H2(417),4,2)
  call Hloop_QV_A(ntryL,G2H2(508),ex3(:),G2H1(1),m3h2x1(:,493),heltab2x2(:,:,493))
  call Hcheck_last_Q_A(ntryL,l_switch,G2H1(1),31,nME,G3tensor(25),n2h1(255))
  call Hloop_QV_A(ntryL,G1H2(44),ex3(:),G1H1(1),m3h2x1(:,494),heltab2x2(:,:,494))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,nME,G2tensor(397),n2h1(256))
  call Hotf_4pt_reduction(G2H2(509),RedSet_4(22),mass4set(:,18),  & 
G1H2(450),G1H2(455),G1H2(465),G1H2(476),G1H2(487),2)
  call HG1shiftOLR(G1H2(455),4,2)
  call Hloop_QV_A(ntryL,G2H2(512),ex3(:),G2H1(1),m3h2x1(:,495),heltab2x2(:,:,495))
  call Hcheck_last_Q_A(ntryL,l_switch,G2H1(1),31,nMM,G3tensor(26),n2h1(257))
  call Hloop_QV_A(ntryL,G1H2(68),ex3(:),G1H1(1),m3h2x1(:,496),heltab2x2(:,:,496))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,nMM,G2tensor(398),n2h1(258))
  call Hotf_4pt_reduction(G2H2(513),RedSet_4(22),mass4set(:,19),  & 
G1H2(492),G1H2(498),G1H2(513),G1H2(525),G1H2(529),2)
  call HG1shiftOLR(G1H2(498),4,2)
  call Hloop_QV_A(ntryL,G2H2(516),ex3(:),G2H1(1),m3h2x1(:,497),heltab2x2(:,:,497))
  call Hcheck_last_Q_A(ntryL,l_switch,G2H1(1),31,nML,G3tensor(27),n2h1(259))
  call Hloop_QV_A(ntryL,G1H2(92),ex3(:),G1H1(1),m3h2x1(:,498),heltab2x2(:,:,498))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,nML,G2tensor(399),n2h1(260))
  call Hotf_4pt_reduction(G2H2(517),RedSet_4(22),mass4set(:,17),  & 
G1H2(536),G1H2(44),G1H2(68),G1H2(92),G1H2(885),2)
  call HG1shiftOLR(G1H2(44),4,2)
  call Hloop_AV_Q(ntryL,G2H2(520),ex3(:),G2H1(1),m3h2x1(:,499),heltab2x2(:,:,499))
  call Hcheck_last_A_Q(ntryL,l_switch,G2H1(1),31,nME,G3tensor(28),n2h1(261))
  call Hloop_AV_Q(ntryL,G1H2(116),ex3(:),G1H1(1),m3h2x1(:,500),heltab2x2(:,:,500))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,nME,G2tensor(400),n2h1(262))
  call Hotf_4pt_reduction(G2H2(521),RedSet_4(22),mass4set(:,18),  & 
G1H2(116),G1H2(886),G1H2(887),G1H2(888),G1H2(889),2)
  call HG1shiftOLR(G1H2(886),4,2)
  call Hloop_AV_Q(ntryL,G2H2(524),ex3(:),G2H1(1),m3h2x1(:,501),heltab2x2(:,:,501))
  call Hcheck_last_A_Q(ntryL,l_switch,G2H1(1),31,nMM,G3tensor(29),n2h1(263))
  call Hloop_AV_Q(ntryL,G1H2(175),ex3(:),G1H1(1),m3h2x1(:,502),heltab2x2(:,:,502))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,nMM,G2tensor(401),n2h1(264))
  call Hotf_4pt_reduction(G2H2(525),RedSet_4(22),mass4set(:,19),  & 
G1H2(175),G1H2(890),G1H2(891),G1H2(892),G1H2(893),2)
  call HG1shiftOLR(G1H2(890),4,2)
  call Hloop_AV_Q(ntryL,G2H2(528),ex3(:),G2H1(1),m3h2x1(:,503),heltab2x2(:,:,503))
  call Hcheck_last_A_Q(ntryL,l_switch,G2H1(1),31,nML,G3tensor(30),n2h1(265))
  call Hloop_AV_Q(ntryL,G1H2(219),ex3(:),G1H1(1),m3h2x1(:,504),heltab2x2(:,:,504))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,nML,G2tensor(402),n2h1(266))
  call Hotf_4pt_reduction(G2H2(529),RedSet_4(22),mass4set(:,15),  & 
G1H2(219),G1H2(894),G1H2(895),G1H2(896),G1H2(897),2)
  call HG1shiftOLR(G1H2(894),4,2)
  call Hcheck_last_CV_D(ntryL,l_switch,G2H2(532),27,ex3(:),4,G3tensor(31),m3h2x1(:,505),heltab2x2(:,:,505))
  call Hcheck_last_CV_D(ntryL,l_switch,G1H2(230),27,ex3(:),4,G2tensor(403),m3h2x1(:,506),heltab2x2(:,:,506))
  call Hotf_4pt_reduction(G2H2(533),RedSet_4(22),mass4set(:,15),  & 
G1H2(230),G1H2(898),G1H2(899),G1H2(900),G1H2(901),2)
  call HG1shiftOLR(G1H2(898),4,2)
  call Hcheck_last_DV_C(ntryL,l_switch,G2H2(536),27,ex3(:),G3tensor(32),m3h2x1(:,507),heltab2x2(:,:,507))
  call Hcheck_last_DV_C(ntryL,l_switch,G1H2(241),27,ex3(:),G2tensor(404),m3h2x1(:,508),heltab2x2(:,:,508))
  call Hotf_4pt_reduction(G2H2(537),RedSet_4(22),mass4set(:,20),  & 
G1H2(241),G1H2(902),G1H2(903),G1H2(904),G1H2(905),2)
  call HG1shiftOLR(G1H2(902),4,2)
  call Hloop_QV_A(ntryL,G2H2(540),ex3(:),G2H1(1),m3h2x1(:,509),heltab2x2(:,:,509))
  call Hcheck_last_Q_A(ntryL,l_switch,G2H1(1),31,0,G3tensor(33),n2h1(267))
  call Hloop_QV_A(ntryL,G1H2(285),ex3(:),G1H1(1),m3h2x1(:,510),heltab2x2(:,:,510))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,0,G2tensor(405),n2h1(268))
  call Hotf_4pt_reduction(G2H2(541),RedSet_4(22),mass4set(:,20),  & 
G1H2(285),G1H2(906),G1H2(907),G1H2(908),G1H2(909),2)
  call HG1shiftOLR(G1H2(906),4,2)
  call Hloop_AV_Q(ntryL,G2H2(544),ex3(:),G2H1(1),m3h2x1(:,511),heltab2x2(:,:,511))
  call Hcheck_last_A_Q(ntryL,l_switch,G2H1(1),31,0,G3tensor(34),n2h1(269))
  call Hloop_AV_Q(ntryL,G1H2(339),ex3(:),G1H1(1),m3h2x1(:,512),heltab2x2(:,:,512))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,0,G2tensor(406),n2h1(270))
  call Hotf_4pt_reduction(G2H2(545),RedSet_4(15),mass4set(:,17),  & 
G1H2(339),G1H2(910),G1H2(911),G1H2(912),G1H2(913),2)
  call HG1shiftOLR(G1H2(910),8,2)
  call Hloop_AV_Q(ntryL,G2H2(548),ex4(:),G2H1(1),m3h2x1(:,513),heltab2x2(:,:,513))
  call Hcheck_last_A_Q(ntryL,l_switch,G2H1(1),31,nME,G3tensor(35),n2h1(271))
  call Hloop_AV_Q(ntryL,G1H2(383),ex4(:),G1H1(1),m3h2x1(:,514),heltab2x2(:,:,514))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,nME,G2tensor(407),n2h1(272))
  call Hotf_4pt_reduction(G2H2(549),RedSet_4(15),mass4set(:,18),  & 
G1H2(383),G1H2(914),G1H2(915),G1H2(916),G1H2(917),2)
  call HG1shiftOLR(G1H2(914),8,2)
  call Hloop_AV_Q(ntryL,G2H2(552),ex4(:),G2H1(1),m3h2x1(:,515),heltab2x2(:,:,515))
  call Hcheck_last_A_Q(ntryL,l_switch,G2H1(1),31,nMM,G3tensor(36),n2h1(273))
  call Hloop_AV_Q(ntryL,G1H2(437),ex4(:),G1H1(1),m3h2x1(:,516),heltab2x2(:,:,516))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,nMM,G2tensor(408),n2h1(274))
  call Hotf_4pt_reduction(G2H2(553),RedSet_4(15),mass4set(:,19),  & 
G1H2(437),G1H2(918),G1H2(919),G1H2(920),G1H2(921),2)
  call HG1shiftOLR(G1H2(918),8,2)
  call Hloop_AV_Q(ntryL,G2H2(556),ex4(:),G2H1(1),m3h2x1(:,517),heltab2x2(:,:,517))
  call Hcheck_last_A_Q(ntryL,l_switch,G2H1(1),31,nML,G3tensor(37),n2h1(275))
  call Hloop_AV_Q(ntryL,G1H2(491),ex4(:),G1H1(1),m3h2x1(:,518),heltab2x2(:,:,518))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,nML,G2tensor(409),n2h1(276))
  call Hotf_4pt_reduction(G2H2(557),RedSet_4(15),mass4set(:,17),  & 
G1H2(491),G1H2(922),G1H2(923),G1H2(924),G1H2(925),2)
  call HG1shiftOLR(G1H2(922),8,2)
  call Hloop_QV_A(ntryL,G2H2(560),ex4(:),G2H1(1),m3h2x1(:,519),heltab2x2(:,:,519))
  call Hcheck_last_Q_A(ntryL,l_switch,G2H1(1),31,nME,G3tensor(38),n2h1(277))
  call Hloop_QV_A(ntryL,G1H2(545),ex4(:),G1H1(1),m3h2x1(:,520),heltab2x2(:,:,520))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,nME,G2tensor(410),n2h1(278))
  call Hotf_4pt_reduction(G2H2(561),RedSet_4(15),mass4set(:,18),  & 
G1H2(545),G1H2(926),G1H2(927),G1H2(928),G1H2(929),2)
  call HG1shiftOLR(G1H2(926),8,2)
  call Hloop_QV_A(ntryL,G2H2(564),ex4(:),G2H1(1),m3h2x1(:,521),heltab2x2(:,:,521))
  call Hcheck_last_Q_A(ntryL,l_switch,G2H1(1),31,nMM,G3tensor(39),n2h1(279))
  call Hloop_QV_A(ntryL,G1H2(22),ex4(:),G1H1(1),m3h2x1(:,522),heltab2x2(:,:,522))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,nMM,G2tensor(411),n2h1(280))
  call Hotf_4pt_reduction(G2H2(565),RedSet_4(15),mass4set(:,19),  & 
G1H2(22),G1H2(930),G1H2(931),G1H2(932),G1H2(933),2)
  call HG1shiftOLR(G1H2(930),8,2)
  call Hloop_QV_A(ntryL,G2H2(568),ex4(:),G2H1(1),m3h2x1(:,523),heltab2x2(:,:,523))
  call Hcheck_last_Q_A(ntryL,l_switch,G2H1(1),31,nML,G3tensor(40),n2h1(281))
  call Hloop_QV_A(ntryL,G1H2(122),ex4(:),G1H1(1),m3h2x1(:,524),heltab2x2(:,:,524))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,nML,G2tensor(412),n2h1(282))
  call Hotf_4pt_reduction(G2H2(569),RedSet_4(15),mass4set(:,15),  & 
G1H2(122),G1H2(934),G1H2(935),G1H2(936),G1H2(937),2)
  call HG1shiftOLR(G1H2(934),8,2)
  call Hcheck_last_DV_C(ntryL,l_switch,G2H2(572),23,ex4(:),G3tensor(41),m3h2x1(:,525),heltab2x2(:,:,525))
  call Hcheck_last_DV_C(ntryL,l_switch,G1H2(33),23,ex4(:),G2tensor(413),m3h2x1(:,526),heltab2x2(:,:,526))
  call Hotf_4pt_reduction(G2H2(573),RedSet_4(15),mass4set(:,15),  & 
G1H2(33),G1H2(938),G1H2(939),G1H2(940),G1H2(941),2)
  call HG1shiftOLR(G1H2(938),8,2)
  call Hcheck_last_CV_D(ntryL,l_switch,G2H2(576),23,ex4(:),8,G3tensor(42),m3h2x1(:,527),heltab2x2(:,:,527))
  call Hcheck_last_CV_D(ntryL,l_switch,G1H2(34),23,ex4(:),8,G2tensor(414),m3h2x1(:,528),heltab2x2(:,:,528))
  call Hotf_4pt_reduction(G2H2(577),RedSet_4(15),mass4set(:,20),  & 
G1H2(34),G1H2(942),G1H2(943),G1H2(944),G1H2(945),2)
  call HG1shiftOLR(G1H2(942),8,2)
  call Hloop_AV_Q(ntryL,G2H2(580),ex4(:),G2H1(1),m3h2x1(:,529),heltab2x2(:,:,529))
  call Hcheck_last_A_Q(ntryL,l_switch,G2H1(1),31,0,G3tensor(43),n2h1(283))
  call Hloop_AV_Q(ntryL,G1H2(318),ex4(:),G1H1(1),m3h2x1(:,530),heltab2x2(:,:,530))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,0,G2tensor(415),n2h1(284))
  call Hotf_4pt_reduction(G2H2(581),RedSet_4(15),mass4set(:,20),  & 
G1H2(318),G1H2(946),G1H2(947),G1H2(948),G1H2(949),2)
  call HG1shiftOLR(G1H2(946),8,2)
  call Hloop_QV_A(ntryL,G2H2(584),ex4(:),G2H1(1),m3h2x1(:,531),heltab2x2(:,:,531))
  call Hcheck_last_Q_A(ntryL,l_switch,G2H1(1),31,0,G3tensor(44),n2h1(285))
  call Hloop_QV_A(ntryL,G1H2(51),ex4(:),G1H1(1),m3h2x1(:,532),heltab2x2(:,:,532))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,0,G2tensor(416),n2h1(286))
  call Hotf_4pt_reduction(G2H2(693),RedSet_4(12),mass4set(:,17),  & 
G1H2(51),G1H2(950),G1H2(951),G1H2(952),G1H2(953),2)
  call HG1shiftOLR(G1H2(950),8,2)
  call Hloop_QV_A(ntryL,G2H2(695),ex4(:),G2H1(1),m3h2x1(:,533),heltab2x2(:,:,533))
  call Hcheck_last_Q_A(ntryL,l_switch,G2H1(1),31,nME,G3tensor(45),n2h1(287))
  call Hloop_QV_A(ntryL,G1H2(263),ex4(:),G1H1(1),m3h2x1(:,534),heltab2x2(:,:,534))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,nME,G2tensor(417),n2h1(288))
  call Hotf_4pt_reduction(G2H2(696),RedSet_4(12),mass4set(:,18),  & 
G1H2(263),G1H2(954),G1H2(955),G1H2(956),G1H2(957),2)
  call HG1shiftOLR(G1H2(954),8,2)
  call Hloop_QV_A(ntryL,G2H2(698),ex4(:),G2H1(1),m3h2x1(:,535),heltab2x2(:,:,535))
  call Hcheck_last_Q_A(ntryL,l_switch,G2H1(1),31,nMM,G3tensor(46),n2h1(289))
  call Hloop_QV_A(ntryL,G1H2(328),ex4(:),G1H1(1),m3h2x1(:,536),heltab2x2(:,:,536))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,nMM,G2tensor(418),n2h1(290))
  call Hotf_4pt_reduction(G2H2(699),RedSet_4(12),mass4set(:,19),  & 
G1H2(328),G1H2(958),G1H2(959),G1H2(960),G1H2(961),2)
  call HG1shiftOLR(G1H2(958),8,2)
  call Hloop_QV_A(ntryL,G2H2(701),ex4(:),G2H1(1),m3h2x1(:,537),heltab2x2(:,:,537))
  call Hcheck_last_Q_A(ntryL,l_switch,G2H1(1),31,nML,G3tensor(47),n2h1(291))
  call Hloop_QV_A(ntryL,G1H2(394),ex4(:),G1H1(1),m3h2x1(:,538),heltab2x2(:,:,538))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,nML,G2tensor(419),n2h1(292))
  call Hotf_4pt_reduction(G2H2(702),RedSet_4(12),mass4set(:,17),  & 
G1H2(394),G1H2(962),G1H2(963),G1H2(964),G1H2(965),2)
  call HG1shiftOLR(G1H2(962),8,2)
  call Hloop_AV_Q(ntryL,G2H2(704),ex4(:),G2H1(1),m3h2x1(:,539),heltab2x2(:,:,539))
  call Hcheck_last_A_Q(ntryL,l_switch,G2H1(1),31,nME,G3tensor(48),n2h1(293))
  call Hloop_AV_Q(ntryL,G1H2(464),ex4(:),G1H1(1),m3h2x1(:,540),heltab2x2(:,:,540))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,nME,G2tensor(420),n2h1(294))
  call Hotf_4pt_reduction(G2H2(705),RedSet_4(12),mass4set(:,18),  & 
G1H2(464),G1H2(966),G1H2(967),G1H2(968),G1H2(969),2)
  call HG1shiftOLR(G1H2(966),8,2)
  call Hloop_AV_Q(ntryL,G2H2(707),ex4(:),G2H1(1),m3h2x1(:,541),heltab2x2(:,:,541))
  call Hcheck_last_A_Q(ntryL,l_switch,G2H1(1),31,nMM,G3tensor(49),n2h1(295))
  call Hloop_AV_Q(ntryL,G1H2(534),ex4(:),G1H1(1),m3h2x1(:,542),heltab2x2(:,:,542))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,nMM,G2tensor(421),n2h1(296))
  call Hotf_4pt_reduction(G2H2(708),RedSet_4(12),mass4set(:,19),  & 
G1H2(534),G1H2(970),G1H2(971),G1H2(972),G1H2(973),2)
  call HG1shiftOLR(G1H2(970),8,2)
  call Hloop_AV_Q(ntryL,G2H2(710),ex4(:),G2H1(1),m3h2x1(:,543),heltab2x2(:,:,543))
  call Hcheck_last_A_Q(ntryL,l_switch,G2H1(1),31,nML,G3tensor(50),n2h1(297))
  call Hloop_AV_Q(ntryL,G1H2(117),ex4(:),G1H1(1),m3h2x1(:,544),heltab2x2(:,:,544))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,nML,G2tensor(422),n2h1(298))
  call Hloop_QV_A(ntryL,G1H2(127),ex4(:),G1H1(1),m3h2x1(:,545),heltab2x2(:,:,545))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,nMT,G2tensor(423),n2h1(299))
  call Hloop_AV_Q(ntryL,G1H2(111),ex4(:),G1H1(1),m3h2x1(:,546),heltab2x2(:,:,546))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,nMT,G2tensor(424),n2h1(300))
  call Hloop_QV_A(ntryL,G1H2(148),ex4(:),G1H1(1),m3h2x1(:,547),heltab2x2(:,:,547))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,nMB,G2tensor(425),n2h1(301))
  call Hloop_AV_Q(ntryL,G1H2(221),ex4(:),G1H1(1),m3h2x1(:,548),heltab2x2(:,:,548))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,nMB,G2tensor(426),n2h1(302))
  call Hcheck_last_VV_S(ntryL,l_switch,G2H2(650),ex4(:),G2tensor(427),m3h2x1(:,549),heltab2x2(:,:,549))
  call Hcheck_last_SV_V(ntryL,l_switch,G2H2(656),ex4(:),G2tensor(428),m3h2x1(:,550),heltab2x2(:,:,550))
  call Hotf_4pt_reduction(G2H2(723),RedSet_4(12),mass4set(:,20),  & 
G1H2(117),G1H2(127),G1H2(111),G1H2(148),G1H2(221),2)
  call HG1shiftOLR(G1H2(127),8,2)
  call Hloop_QV_A(ntryL,G2H2(725),ex4(:),G2H1(1),m3h2x1(:,551),heltab2x2(:,:,551))
  call Hcheck_last_Q_A(ntryL,l_switch,G2H1(1),31,0,G3tensor(51),n2h1(303))
  call Hloop_QV_A(ntryL,G1H2(128),ex4(:),G1H1(1),m3h2x1(:,552),heltab2x2(:,:,552))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,0,G2tensor(429),n2h1(304))
  call Hotf_4pt_reduction(G2H2(729),RedSet_4(12),mass4set(:,20),  & 
G1H2(128),G1H2(974),G1H2(975),G1H2(976),G1H2(977),2)
  call HG1shiftOLR(G1H2(974),8,2)
  call Hloop_AV_Q(ntryL,G2H2(731),ex4(:),G2H1(1),m3h2x1(:,553),heltab2x2(:,:,553))
  call Hcheck_last_A_Q(ntryL,l_switch,G2H1(1),31,0,G3tensor(52),n2h1(305))
  call Hloop_AV_Q(ntryL,G1H2(160),ex4(:),G1H1(1),m3h2x1(:,554),heltab2x2(:,:,554))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,0,G2tensor(430),n2h1(306))
  call Hcheck_last_TV_S(ntryL,l_switch,G1H2(236),23,ex4(:),8,G2tensor(431),m3h2x1(:,555),heltab2x2(:,:,555))
  call Hcheck_last_SV_T(ntryL,l_switch,G1H2(243),23,ex4(:),8,G2tensor(432),m3h2x1(:,556),heltab2x2(:,:,556))
  call Hcheck_last_CV_D(ntryL,l_switch,G2H2(755),23,ex4(:),8,G3tensor(53),m3h2x1(:,557),heltab2x2(:,:,557))
  call Hcheck_last_CV_D(ntryL,l_switch,G1H2(258),23,ex4(:),8,G2tensor(433),m3h2x1(:,558),heltab2x2(:,:,558))
  call Hcheck_last_DV_C(ntryL,l_switch,G2H2(758),23,ex4(:),G3tensor(54),m3h2x1(:,559),heltab2x2(:,:,559))
  call Hcheck_last_DV_C(ntryL,l_switch,G1H2(264),23,ex4(:),G2tensor(434),m3h2x1(:,560),heltab2x2(:,:,560))
  call Hcheck_last_UV_W(ntryL,l_switch,G1H2(276),23,ex4(:),8,G2tensor(435),m3h2x1(:,561),heltab2x2(:,:,561))
  call Hcheck_last_UW_V(ntryL,l_switch,G1H2(280),23,ex4(:),8,G2tensor(436),m3h2x1(:,562),heltab2x2(:,:,562))
  call Hcheck_last_AQ_S(ntryL,l_switch,G2H4(209),wf4(:,3),G2tensor(437),ngPbt,m3h4x1(:,5),heltab2x4(:,:,817))
  call Hcheck_last_AQ_S(ntryL,l_switch,G2H4(227),wf4(:,3),G2tensor(438),ngPbt,m3h4x1(:,6),heltab2x4(:,:,818))
  call Hcheck_last_AQ_W(ntryL,l_switch,G2H4(226),wf4(:,3),G2tensor(439),m3h4x1(:,7),heltab2x4(:,:,819))
  call Hcheck_last_AQ_W(ntryL,l_switch,G2H4(231),wf4(:,3),G2tensor(440),m3h4x1(:,8),heltab2x4(:,:,820))
  call Hcheck_last_QA_S(ntryL,l_switch,G2H4(230),wf4(:,10),G2tensor(441),ngPtb,m3h4x1(:,9),heltab2x4(:,:,821))
  call Hcheck_last_QA_S(ntryL,l_switch,G2H4(31),wf4(:,10),G2tensor(442),ngPtb,m3h4x1(:,10),heltab2x4(:,:,822))
  call Hcheck_last_QA_W(ntryL,l_switch,G2H4(32),wf4(:,10),G2tensor(443),m3h4x1(:,11),heltab2x4(:,:,823))
  call Hcheck_last_QA_W(ntryL,l_switch,G2H4(1),wf4(:,10),G2tensor(444),m3h4x1(:,12),heltab2x4(:,:,824))
  call Hcheck_last_AQ_S(ntryL,l_switch,G2H4(15),wf4(:,9),G2tensor(445),ngPbt,m3h4x1(:,13),heltab2x4(:,:,825))
  call Hcheck_last_AQ_S(ntryL,l_switch,G2H4(94),wf4(:,9),G2tensor(446),ngPbt,m3h4x1(:,14),heltab2x4(:,:,826))
  call Hcheck_last_AQ_W(ntryL,l_switch,G2H4(233),wf4(:,9),G2tensor(447),m3h4x1(:,15),heltab2x4(:,:,827))
  call Hcheck_last_AQ_W(ntryL,l_switch,G2H4(235),wf4(:,9),G2tensor(448),m3h4x1(:,16),heltab2x4(:,:,828))
  call Hcheck_last_AQ_S(ntryL,l_switch,G2H4(112),wf4(:,9),G2tensor(449),ngPbt,m3h4x1(:,17),heltab2x4(:,:,829))
  call Hcheck_last_AQ_W(ntryL,l_switch,G2H4(239),wf4(:,9),G2tensor(450),m3h4x1(:,18),heltab2x4(:,:,830))
  call Hcheck_last_QA_S(ntryL,l_switch,G2H4(125),wf4(:,4),G2tensor(451),ngPtb,m3h4x1(:,19),heltab2x4(:,:,831))
  call Hcheck_last_QA_S(ntryL,l_switch,G2H4(130),wf4(:,4),G2tensor(452),ngPtb,m3h4x1(:,20),heltab2x4(:,:,832))
  call Hcheck_last_QA_W(ntryL,l_switch,G2H4(143),wf4(:,4),G2tensor(453),m3h4x1(:,21),heltab2x4(:,:,833))
  call Hcheck_last_QA_W(ntryL,l_switch,G2H4(149),wf4(:,4),G2tensor(454),m3h4x1(:,22),heltab2x4(:,:,834))
  call Hcheck_last_QA_S(ntryL,l_switch,G2H4(157),wf4(:,4),G2tensor(455),ngPtb,m3h4x1(:,23),heltab2x4(:,:,835))
  call Hcheck_last_QA_W(ntryL,l_switch,G2H4(179),wf4(:,4),G2tensor(456),m3h4x1(:,24),heltab2x4(:,:,836))
  call Hcheck_last_TV_S(ntryL,l_switch,G1H2(351),23,ex4(:),8,G2tensor(457),m3h2x1(:,563),heltab2x2(:,:,563))
  call Hcheck_last_TV_S(ntryL,l_switch,G1H2(356),0,ex4(:),8,G2tensor(458),m3h2x1(:,564),heltab2x2(:,:,564))
  call Hcheck_last_TV_S(ntryL,l_switch,G1H2(368),23,ex4(:),8,G2tensor(459),m3h2x1(:,565),heltab2x2(:,:,565))
  call Hcheck_last_UV_W(ntryL,l_switch,G1H2(373),23,ex4(:),8,G2tensor(460),m3h2x1(:,566),heltab2x2(:,:,566))
  call Hcheck_last_UV_W(ntryL,l_switch,G1H2(379),0,ex4(:),8,G2tensor(461),m3h2x1(:,567),heltab2x2(:,:,567))
  call Hcheck_last_UV_W(ntryL,l_switch,G1H2(395),23,ex4(:),8,G2tensor(462),m3h2x1(:,568),heltab2x2(:,:,568))
  call Hcheck_last_SV_T(ntryL,l_switch,G1H2(396),23,ex4(:),8,G2tensor(463),m3h2x1(:,569),heltab2x2(:,:,569))
  call Hcheck_last_SV_T(ntryL,l_switch,G1H2(401),0,ex4(:),8,G2tensor(464),m3h2x1(:,570),heltab2x2(:,:,570))
  call Hcheck_last_SV_T(ntryL,l_switch,G1H2(432),23,ex4(:),8,G2tensor(465),m3h2x1(:,571),heltab2x2(:,:,571))
  call Hcheck_last_UW_V(ntryL,l_switch,G1H2(438),23,ex4(:),8,G2tensor(466),m3h2x1(:,572),heltab2x2(:,:,572))
  call Hcheck_last_UW_V(ntryL,l_switch,G1H2(443),0,ex4(:),8,G2tensor(467),m3h2x1(:,573),heltab2x2(:,:,573))
  call Hcheck_last_UW_V(ntryL,l_switch,G1H2(471),23,ex4(:),8,G2tensor(468),m3h2x1(:,574),heltab2x2(:,:,574))
  call Hcheck_last_SV_T(ntryL,l_switch,G1H2(475),23,ex4(:),8,G2tensor(469),m3h2x1(:,575),heltab2x2(:,:,575))
  call Hcheck_last_SV_T(ntryL,l_switch,G1H2(482),0,ex4(:),8,G2tensor(470),m3h2x1(:,576),heltab2x2(:,:,576))
  call Hcheck_last_SV_T(ntryL,l_switch,G1H2(509),23,ex4(:),8,G2tensor(471),m3h2x1(:,577),heltab2x2(:,:,577))
  call Hcheck_last_UW_V(ntryL,l_switch,G1H2(514),23,ex4(:),8,G2tensor(472),m3h2x1(:,578),heltab2x2(:,:,578))
  call Hcheck_last_UW_V(ntryL,l_switch,G1H2(519),0,ex4(:),8,G2tensor(473),m3h2x1(:,579),heltab2x2(:,:,579))
  call Hcheck_last_UW_V(ntryL,l_switch,G1H2(547),23,ex4(:),8,G2tensor(474),m3h2x1(:,580),heltab2x2(:,:,580))
  call Hcheck_last_SV_T(ntryL,l_switch,G1H2(557),27,ex3(:),4,G2tensor(475),m3h2x1(:,581),heltab2x2(:,:,581))
  call Hcheck_last_SV_T(ntryL,l_switch,G1H2(558),0,ex3(:),4,G2tensor(476),m3h2x1(:,582),heltab2x2(:,:,582))
  call Hcheck_last_SV_T(ntryL,l_switch,G1H2(578),27,ex3(:),4,G2tensor(477),m3h2x1(:,583),heltab2x2(:,:,583))
  call Hcheck_last_UW_V(ntryL,l_switch,G1H2(584),27,ex3(:),4,G2tensor(478),m3h2x1(:,584),heltab2x2(:,:,584))
  call Hcheck_last_UW_V(ntryL,l_switch,G1H2(26),0,ex3(:),4,G2tensor(479),m3h2x1(:,585),heltab2x2(:,:,585))
  call Hcheck_last_UW_V(ntryL,l_switch,G1H2(56),27,ex3(:),4,G2tensor(480),m3h2x1(:,586),heltab2x2(:,:,586))
  call Hcheck_last_TV_S(ntryL,l_switch,G1H2(62),23,ex4(:),8,G2tensor(481),m3h2x1(:,587),heltab2x2(:,:,587))
  call Hcheck_last_TV_S(ntryL,l_switch,G1H2(74),0,ex4(:),8,G2tensor(482),m3h2x1(:,588),heltab2x2(:,:,588))
  call Hcheck_last_TV_S(ntryL,l_switch,G1H2(104),23,ex4(:),8,G2tensor(483),m3h2x1(:,589),heltab2x2(:,:,589))
  call Hcheck_last_UV_W(ntryL,l_switch,G1H2(142),23,ex4(:),8,G2tensor(484),m3h2x1(:,590),heltab2x2(:,:,590))
  call Hcheck_last_UV_W(ntryL,l_switch,G1H2(153),0,ex4(:),8,G2tensor(485),m3h2x1(:,591),heltab2x2(:,:,591))
  call Hcheck_last_UV_W(ntryL,l_switch,G1H2(208),23,ex4(:),8,G2tensor(486),m3h2x1(:,592),heltab2x2(:,:,592))
  call Hcheck_last_TV_S(ntryL,l_switch,G1H2(252),27,ex3(:),4,G2tensor(487),m3h2x1(:,593),heltab2x2(:,:,593))
  call Hcheck_last_TV_S(ntryL,l_switch,G1H2(274),0,ex3(:),4,G2tensor(488),m3h2x1(:,594),heltab2x2(:,:,594))
  call Hcheck_last_TV_S(ntryL,l_switch,G1H2(350),27,ex3(:),4,G2tensor(489),m3h2x1(:,595),heltab2x2(:,:,595))
  call Hcheck_last_UV_W(ntryL,l_switch,G1H2(361),27,ex3(:),4,G2tensor(490),m3h2x1(:,596),heltab2x2(:,:,596))
  call Hcheck_last_UV_W(ntryL,l_switch,G1H2(372),0,ex3(:),4,G2tensor(491),m3h2x1(:,597),heltab2x2(:,:,597))
  call Hcheck_last_UV_W(ntryL,l_switch,G1H2(448),27,ex3(:),4,G2tensor(492),m3h2x1(:,598),heltab2x2(:,:,598))
  call Hloop_SA_Q(ntryL,G1H2(480),ex2(:),G1H1(1),ngH,m3h2x1(:,599),heltab2x2(:,:,599))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,nMT,G2tensor(493),n2h1(319))
  call Hloop_SA_Q(ntryL,G1H2(502),ex2(:),G1H1(1),ngH,m3h2x1(:,600),heltab2x2(:,:,600))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),2,nMT,G2tensor(494),n2h1(320))
  call Hloop_SA_Q(ntryL,G1H2(577),ex2(:),G1H1(1),ngH,m3h2x1(:,601),heltab2x2(:,:,601))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,nMT,G2tensor(495),n2h1(321))
  call Hloop_AV_Q(ntryL,G1H2(21),ex4(:),G1H1(1),m3h2x1(:,602),heltab2x2(:,:,602))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,nMT,G2tensor(496),n2h1(322))
  call Hloop_AV_Q(ntryL,G1H2(27),ex4(:),G1H1(1),m3h2x1(:,603),heltab2x2(:,:,603))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),8,nMT,G2tensor(497),n2h1(323))
  call Hloop_AV_Q(ntryL,G1H2(40),ex4(:),G1H1(1),m3h2x1(:,604),heltab2x2(:,:,604))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,nMT,G2tensor(498),n2h1(324))
  call Hloop_SA_Q(ntryL,G1H2(45),ex2(:),G1H1(1),ngX,m3h2x1(:,605),heltab2x2(:,:,605))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,nMT,G2tensor(499),n2h1(325))
  call Hloop_SA_Q(ntryL,G1H2(46),ex2(:),G1H1(1),ngX,m3h2x1(:,606),heltab2x2(:,:,606))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),2,nMT,G2tensor(500),n2h1(326))
  call Hloop_SA_Q(ntryL,G1H2(57),ex2(:),G1H1(1),ngX,m3h2x1(:,607),heltab2x2(:,:,607))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,nMT,G2tensor(501),n2h1(327))
  call Hloop_SA_Q(ntryL,G1H2(567),ex2(:),G1H1(1),ngPtb,m3h2x1(:,608),heltab2x2(:,:,608))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,nMB,G2tensor(502),n2h1(328))
  call Hloop_SA_Q(ntryL,G1H2(105),ex2(:),G1H1(1),ngPtb,m3h2x1(:,609),heltab2x2(:,:,609))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),2,nMB,G2tensor(503),n2h1(329))
  call Hloop_SA_Q(ntryL,G1H2(118),ex2(:),G1H1(1),ngPtb,m3h2x1(:,610),heltab2x2(:,:,610))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,nMB,G2tensor(504),n2h1(330))
  call Hloop_AV_Q(ntryL,G1H2(123),ex4(:),G1H1(1),m3h2x1(:,611),heltab2x2(:,:,611))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,nMB,G2tensor(505),n2h1(331))
  call Hloop_AV_Q(ntryL,G1H2(137),ex4(:),G1H1(1),m3h2x1(:,612),heltab2x2(:,:,612))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),8,nMB,G2tensor(506),n2h1(332))
  call Hloop_AV_Q(ntryL,G1H2(149),ex4(:),G1H1(1),m3h2x1(:,613),heltab2x2(:,:,613))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,nMB,G2tensor(507),n2h1(333))
  call Hloop_VA_Q(ntryL,G1H2(154),ex2(:),G1H1(1),m3h2x1(:,614),heltab2x2(:,:,614))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,nMT,G2tensor(508),n2h1(334))
  call Hloop_VA_Q(ntryL,G1H2(159),ex2(:),G1H1(1),m3h2x1(:,615),heltab2x2(:,:,615))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),2,nMT,G2tensor(509),n2h1(335))
  call Hloop_VA_Q(ntryL,G1H2(220),ex2(:),G1H1(1),m3h2x1(:,616),heltab2x2(:,:,616))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,nMT,G2tensor(510),n2h1(336))
  call Hloop_ZA_Q(ntryL,G1H2(88),ex2(:),G1H1(1),ngZu,m3h2x1(:,617),heltab2x2(:,:,617))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,nMT,G2tensor(511),n2h1(337))
  call Hloop_ZA_Q(ntryL,G1H2(508),ex2(:),G1H1(1),ngZu,m3h2x1(:,618),heltab2x2(:,:,618))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),2,nMT,G2tensor(512),n2h1(338))
  call Hloop_ZA_Q(ntryL,G1H2(81),ex2(:),G1H1(1),ngZu,m3h2x1(:,619),heltab2x2(:,:,619))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,nMT,G2tensor(513),n2h1(339))
  call Hloop_WA_Q(ntryL,G1H2(562),ex2(:),G1H1(1),m3h2x1(:,620),heltab2x2(:,:,620))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,nMB,G2tensor(514),n2h1(340))
  call Hloop_WA_Q(ntryL,G1H2(93),ex2(:),G1H1(1),m3h2x1(:,621),heltab2x2(:,:,621))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),2,nMB,G2tensor(515),n2h1(341))
  call Hloop_WA_Q(ntryL,G1H2(87),ex2(:),G1H1(1),m3h2x1(:,622),heltab2x2(:,:,622))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,nMB,G2tensor(516),n2h1(342))
  call Hloop_QV_A(ntryL,G1H2(49),ex3(:),G1H1(1),m3h2x1(:,623),heltab2x2(:,:,623))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,nMT,G2tensor(517),n2h1(343))
  call Hloop_QV_A(ntryL,G1H2(99),ex3(:),G1H1(1),m3h2x1(:,624),heltab2x2(:,:,624))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),4,nMT,G2tensor(518),n2h1(344))
  call Hloop_QV_A(ntryL,G1H2(141),ex3(:),G1H1(1),m3h2x1(:,625),heltab2x2(:,:,625))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,nMT,G2tensor(519),n2h1(345))
  call Hloop_QV_A(ntryL,G1H2(37),ex4(:),G1H1(1),m3h2x1(:,626),heltab2x2(:,:,626))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,nMT,G2tensor(520),n2h1(346))
  call Hloop_QV_A(ntryL,G1H2(152),ex4(:),G1H1(1),m3h2x1(:,627),heltab2x2(:,:,627))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),8,nMT,G2tensor(521),n2h1(347))
  call Hloop_QV_A(ntryL,G1H2(61),ex4(:),G1H1(1),m3h2x1(:,628),heltab2x2(:,:,628))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,nMT,G2tensor(522),n2h1(348))
  call Hloop_QV_A(ntryL,G1H2(174),ex3(:),G1H1(1),m3h2x1(:,629),heltab2x2(:,:,629))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,nMT,G2tensor(523),n2h1(349))
  call Hloop_QV_A(ntryL,G1H2(67),ex3(:),G1H1(1),m3h2x1(:,630),heltab2x2(:,:,630))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),4,nMT,G2tensor(524),n2h1(350))
  call Hloop_QV_A(ntryL,G1H2(196),ex3(:),G1H1(1),m3h2x1(:,631),heltab2x2(:,:,631))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,nMT,G2tensor(525),n2h1(351))
  call Hloop_QV_A(ntryL,G1H2(79),ex4(:),G1H1(1),m3h2x1(:,632),heltab2x2(:,:,632))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,nMT,G2tensor(526),n2h1(352))
  call Hloop_QV_A(ntryL,G1H2(207),ex4(:),G1H1(1),m3h2x1(:,633),heltab2x2(:,:,633))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),8,nMT,G2tensor(527),n2h1(353))
  call Hloop_QV_A(ntryL,G1H2(91),ex4(:),G1H1(1),m3h2x1(:,634),heltab2x2(:,:,634))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,nMT,G2tensor(528),n2h1(354))
  call Hloop_QV_A(ntryL,G1H2(262),ex3(:),G1H1(1),m3h2x1(:,635),heltab2x2(:,:,635))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,nMB,G2tensor(529),n2h1(355))
  call Hloop_QV_A(ntryL,G1H2(240),ex3(:),G1H1(1),m3h2x1(:,636),heltab2x2(:,:,636))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),4,nMB,G2tensor(530),n2h1(356))
  call Hloop_QV_A(ntryL,G1H2(273),ex3(:),G1H1(1),m3h2x1(:,637),heltab2x2(:,:,637))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,nMB,G2tensor(531),n2h1(357))
  call Hloop_QV_A(ntryL,G1H2(284),ex4(:),G1H1(1),m3h2x1(:,638),heltab2x2(:,:,638))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,nMB,G2tensor(532),n2h1(358))
  call Hloop_QV_A(ntryL,G1H2(533),ex4(:),G1H1(1),m3h2x1(:,639),heltab2x2(:,:,639))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),8,nMB,G2tensor(533),n2h1(359))
  call Hloop_QV_A(ntryL,G1H2(400),ex4(:),G1H1(1),m3h2x1(:,640),heltab2x2(:,:,640))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,nMB,G2tensor(534),n2h1(360))
  call Hcheck_last_SV_T(ntryL,l_switch,G1H2(311),27,ex3(:),4,G2tensor(535),m3h2x1(:,641),heltab2x2(:,:,641))
  call Hcheck_last_SV_T(ntryL,l_switch,G1H2(2),0,ex3(:),4,G2tensor(536),m3h2x1(:,642),heltab2x2(:,:,642))
  call Hcheck_last_SV_T(ntryL,l_switch,G1H2(338),27,ex3(:),4,G2tensor(537),m3h2x1(:,643),heltab2x2(:,:,643))
  call Hloop_QV_A(ntryL,G1H2(327),ex3(:),G1H1(1),m3h2x1(:,644),heltab2x2(:,:,644))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,nMT,G2tensor(538),n2h1(362))
  call Hloop_QV_A(ntryL,G1H2(349),ex3(:),G1H1(1),m3h2x1(:,645),heltab2x2(:,:,645))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),4,nMT,G2tensor(539),n2h1(363))
  call Hloop_QV_A(ntryL,G1H2(336),ex3(:),G1H1(1),m3h2x1(:,646),heltab2x2(:,:,646))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,nMT,G2tensor(540),n2h1(364))
  call Hloop_QV_A(ntryL,G1H2(382),ex4(:),G1H1(1),m3h2x1(:,647),heltab2x2(:,:,647))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,nMT,G2tensor(541),n2h1(365))
  call Hloop_QV_A(ntryL,G1H2(347),ex4(:),G1H1(1),m3h2x1(:,648),heltab2x2(:,:,648))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),8,nMT,G2tensor(542),n2h1(366))
  call Hloop_QV_A(ntryL,G1H2(3),ex4(:),G1H1(1),m3h2x1(:,649),heltab2x2(:,:,649))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,nMT,G2tensor(543),n2h1(367))
  call Hcheck_last_UW_V(ntryL,l_switch,G1H2(47),27,ex3(:),4,G2tensor(544),m3h2x1(:,650),heltab2x2(:,:,650))
  call Hcheck_last_UW_V(ntryL,l_switch,G1H2(358),0,ex3(:),4,G2tensor(545),m3h2x1(:,651),heltab2x2(:,:,651))
  call Hcheck_last_UW_V(ntryL,l_switch,G1H2(53),27,ex3(:),4,G2tensor(546),m3h2x1(:,652),heltab2x2(:,:,652))
  call Hloop_SQ_A(ntryL,G1H2(425),ex1(:),G1H1(1),ngH,m3h2x1(:,653),heltab2x2(:,:,653))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,nMT,G2tensor(547),n2h1(369))
  call Hloop_SQ_A(ntryL,G1H2(436),ex1(:),G1H1(1),ngH,m3h2x1(:,654),heltab2x2(:,:,654))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),1,nMT,G2tensor(548),n2h1(370))
  call Hloop_SQ_A(ntryL,G1H2(5),ex1(:),G1H1(1),ngH,m3h2x1(:,655),heltab2x2(:,:,655))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,nMT,G2tensor(549),n2h1(371))
  call Hloop_QV_A(ntryL,G1H2(69),ex4(:),G1H1(1),m3h2x1(:,656),heltab2x2(:,:,656))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,nMT,G2tensor(550),n2h1(372))
  call Hloop_QV_A(ntryL,G1H2(463),ex4(:),G1H1(1),m3h2x1(:,657),heltab2x2(:,:,657))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),8,nMT,G2tensor(551),n2h1(373))
  call Hloop_QV_A(ntryL,G1H2(227),ex4(:),G1H1(1),m3h2x1(:,658),heltab2x2(:,:,658))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,nMT,G2tensor(552),n2h1(374))
  call Hloop_SQ_A(ntryL,G1H2(479),ex1(:),G1H1(1),ngX,m3h2x1(:,659),heltab2x2(:,:,659))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,nMT,G2tensor(553),n2h1(375))
  call Hloop_SQ_A(ntryL,G1H2(238),ex1(:),G1H1(1),ngX,m3h2x1(:,660),heltab2x2(:,:,660))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),1,nMT,G2tensor(554),n2h1(376))
  call Hloop_SQ_A(ntryL,G1H2(576),ex1(:),G1H1(1),ngX,m3h2x1(:,661),heltab2x2(:,:,661))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,nMT,G2tensor(555),n2h1(377))
  call Hloop_SQ_A(ntryL,G1H2(501),ex1(:),G1H1(1),ngPbt,m3h2x1(:,662),heltab2x2(:,:,662))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,nMB,G2tensor(556),n2h1(378))
  call Hloop_SQ_A(ntryL,G1H2(7),ex1(:),G1H1(1),ngPbt,m3h2x1(:,663),heltab2x2(:,:,663))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),1,nMB,G2tensor(557),n2h1(379))
  call Hloop_SQ_A(ntryL,G1H2(517),ex1(:),G1H1(1),ngPbt,m3h2x1(:,664),heltab2x2(:,:,664))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,nMB,G2tensor(558),n2h1(380))
  call Hloop_QV_A(ntryL,G1H2(8),ex4(:),G1H1(1),m3h2x1(:,665),heltab2x2(:,:,665))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,nMB,G2tensor(559),n2h1(381))
  call Hloop_QV_A(ntryL,G1H2(29),ex4(:),G1H1(1),m3h2x1(:,666),heltab2x2(:,:,666))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),8,nMB,G2tensor(560),n2h1(382))
  call Hloop_QV_A(ntryL,G1H2(76),ex4(:),G1H1(1),m3h2x1(:,667),heltab2x2(:,:,667))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,nMB,G2tensor(561),n2h1(383))
  call Hloop_VQ_A(ntryL,G1H2(109),ex1(:),G1H1(1),m3h2x1(:,668),heltab2x2(:,:,668))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,nMT,G2tensor(562),n2h1(384))
  call Hloop_VQ_A(ntryL,G1H2(97),ex1(:),G1H1(1),m3h2x1(:,669),heltab2x2(:,:,669))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),1,nMT,G2tensor(563),n2h1(385))
  call Hloop_VQ_A(ntryL,G1H2(470),ex1(:),G1H1(1),m3h2x1(:,670),heltab2x2(:,:,670))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,nMT,G2tensor(564),n2h1(386))
  call Hloop_ZQ_A(ntryL,G1H2(115),ex1(:),G1H1(1),ngZu,m3h2x1(:,671),heltab2x2(:,:,671))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,nMT,G2tensor(565),n2h1(387))
  call Hloop_ZQ_A(ntryL,G1H2(103),ex1(:),G1H1(1),ngZu,m3h2x1(:,672),heltab2x2(:,:,672))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),1,nMT,G2tensor(566),n2h1(388))
  call Hloop_ZQ_A(ntryL,G1H2(209),ex1(:),G1H1(1),ngZu,m3h2x1(:,673),heltab2x2(:,:,673))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,nMT,G2tensor(567),n2h1(389))
  call Hloop_WQ_A(ntryL,G1H2(65),ex1(:),G1H1(1),m3h2x1(:,674),heltab2x2(:,:,674))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,nMB,G2tensor(568),n2h1(390))
  call Hloop_WQ_A(ntryL,G1H2(9),ex1(:),G1H1(1),m3h2x1(:,675),heltab2x2(:,:,675))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),1,nMB,G2tensor(569),n2h1(391))
  call Hloop_WQ_A(ntryL,G1H2(10),ex1(:),G1H1(1),m3h2x1(:,676),heltab2x2(:,:,676))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,nMB,G2tensor(570),n2h1(392))
  call Hloop_QV_A(ntryL,G1H2(299),ex4(:),G1H1(1),m3h2x1(:,677),heltab2x2(:,:,677))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,nMT,G2tensor(571),n2h1(393))
  call Hloop_QV_A(ntryL,G1H2(11),ex4(:),G1H1(1),m3h2x1(:,678),heltab2x2(:,:,678))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),8,nMT,G2tensor(572),n2h1(394))
  call Hloop_QV_A(ntryL,G1H2(18),ex4(:),G1H1(1),m3h2x1(:,679),heltab2x2(:,:,679))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,nMT,G2tensor(573),n2h1(395))
  call Hloop_QV_A(ntryL,G1H2(16),ex3(:),G1H1(1),m3h2x1(:,680),heltab2x2(:,:,680))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,nMT,G2tensor(574),n2h1(396))
  call Hloop_QV_A(ntryL,G1H2(397),ex3(:),G1H1(1),m3h2x1(:,681),heltab2x2(:,:,681))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),4,nMT,G2tensor(575),n2h1(397))
  call Hloop_QV_A(ntryL,G1H2(24),ex3(:),G1H1(1),m3h2x1(:,682),heltab2x2(:,:,682))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,nMT,G2tensor(576),n2h1(398))
  call Hloop_QV_A(ntryL,G1H2(195),ex4(:),G1H1(1),m3h2x1(:,683),heltab2x2(:,:,683))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,nMT,G2tensor(577),n2h1(399))
  call Hloop_QV_A(ntryL,G1H2(30),ex4(:),G1H1(1),m3h2x1(:,684),heltab2x2(:,:,684))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),8,nMT,G2tensor(578),n2h1(400))
  call Hloop_QV_A(ntryL,G1H2(140),ex4(:),G1H1(1),m3h2x1(:,685),heltab2x2(:,:,685))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,nMT,G2tensor(579),n2h1(401))
  call Hloop_QV_A(ntryL,G1H2(48),ex3(:),G1H1(1),m3h2x1(:,686),heltab2x2(:,:,686))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,nMT,G2tensor(580),n2h1(402))
  call Hloop_QV_A(ntryL,G1H2(151),ex3(:),G1H1(1),m3h2x1(:,687),heltab2x2(:,:,687))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),4,nMT,G2tensor(581),n2h1(403))
  call Hloop_QV_A(ntryL,G1H2(66),ex3(:),G1H1(1),m3h2x1(:,688),heltab2x2(:,:,688))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,nMT,G2tensor(582),n2h1(404))
  call Hloop_QV_A(ntryL,G1H2(171),ex4(:),G1H1(1),m3h2x1(:,689),heltab2x2(:,:,689))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,nMB,G2tensor(583),n2h1(405))
  call Hloop_QV_A(ntryL,G1H2(71),ex4(:),G1H1(1),m3h2x1(:,690),heltab2x2(:,:,690))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),8,nMB,G2tensor(584),n2h1(406))
  call Hloop_QV_A(ntryL,G1H2(77),ex4(:),G1H1(1),m3h2x1(:,691),heltab2x2(:,:,691))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,nMB,G2tensor(585),n2h1(407))
  call Hloop_QV_A(ntryL,G1H2(78),ex3(:),G1H1(1),m3h2x1(:,692),heltab2x2(:,:,692))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,nMB,G2tensor(586),n2h1(408))
  call Hloop_QV_A(ntryL,G1H2(182),ex3(:),G1H1(1),m3h2x1(:,693),heltab2x2(:,:,693))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),4,nMB,G2tensor(587),n2h1(409))
  call Hloop_QV_A(ntryL,G1H2(187),ex3(:),G1H1(1),m3h2x1(:,694),heltab2x2(:,:,694))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,nMB,G2tensor(588),n2h1(410))
  call Hcheck_last_SV_T(ntryL,l_switch,G1H2(89),23,ex4(:),8,G2tensor(589),m3h2x1(:,695),heltab2x2(:,:,695))
  call Hcheck_last_SV_T(ntryL,l_switch,G1H2(90),0,ex4(:),8,G2tensor(590),m3h2x1(:,696),heltab2x2(:,:,696))
  call Hcheck_last_SV_T(ntryL,l_switch,G1H2(101),23,ex4(:),8,G2tensor(591),m3h2x1(:,697),heltab2x2(:,:,697))
  call Hloop_QV_A(ntryL,G1H2(102),ex4(:),G1H1(1),m3h2x1(:,698),heltab2x2(:,:,698))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,nMT,G2tensor(592),n2h1(412))
  call Hloop_QV_A(ntryL,G1H2(107),ex4(:),G1H1(1),m3h2x1(:,699),heltab2x2(:,:,699))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),8,nMT,G2tensor(593),n2h1(413))
  call Hloop_QV_A(ntryL,G1H2(114),ex4(:),G1H1(1),m3h2x1(:,700),heltab2x2(:,:,700))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,nMT,G2tensor(594),n2h1(414))
  call Hloop_QV_A(ntryL,G1H2(120),ex3(:),G1H1(1),m3h2x1(:,701),heltab2x2(:,:,701))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,nMT,G2tensor(595),n2h1(415))
  call Hloop_QV_A(ntryL,G1H2(121),ex3(:),G1H1(1),m3h2x1(:,702),heltab2x2(:,:,702))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),4,nMT,G2tensor(596),n2h1(416))
  call Hloop_QV_A(ntryL,G1H2(130),ex3(:),G1H1(1),m3h2x1(:,703),heltab2x2(:,:,703))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,nMT,G2tensor(597),n2h1(417))
  call Hcheck_last_UW_V(ntryL,l_switch,G1H2(131),23,ex4(:),8,G2tensor(598),m3h2x1(:,704),heltab2x2(:,:,704))
  call Hcheck_last_UW_V(ntryL,l_switch,G1H2(135),0,ex4(:),8,G2tensor(599),m3h2x1(:,705),heltab2x2(:,:,705))
  call Hcheck_last_UW_V(ntryL,l_switch,G1H2(147),23,ex4(:),8,G2tensor(600),m3h2x1(:,706),heltab2x2(:,:,706))
  call Hloop_AV_Q(ntryL,G1H2(150),ex3(:),G1H1(1),m3h2x1(:,707),heltab2x2(:,:,707))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,nMT,G2tensor(601),n2h1(419))
  call Hloop_AV_Q(ntryL,G1H2(158),ex3(:),G1H1(1),m3h2x1(:,708),heltab2x2(:,:,708))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),4,nMT,G2tensor(602),n2h1(420))
  call Hloop_AV_Q(ntryL,G1H2(169),ex3(:),G1H1(1),m3h2x1(:,709),heltab2x2(:,:,709))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,nMT,G2tensor(603),n2h1(421))
  call Hloop_AV_Q(ntryL,G1H2(172),ex4(:),G1H1(1),m3h2x1(:,710),heltab2x2(:,:,710))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,nMT,G2tensor(604),n2h1(422))
  call Hloop_AV_Q(ntryL,G1H2(173),ex4(:),G1H1(1),m3h2x1(:,711),heltab2x2(:,:,711))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),8,nMT,G2tensor(605),n2h1(423))
  call Hloop_AV_Q(ntryL,G1H2(191),ex4(:),G1H1(1),m3h2x1(:,712),heltab2x2(:,:,712))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,nMT,G2tensor(606),n2h1(424))
  call Hloop_AV_Q(ntryL,G1H2(194),ex3(:),G1H1(1),m3h2x1(:,713),heltab2x2(:,:,713))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,nMT,G2tensor(607),n2h1(425))
  call Hloop_AV_Q(ntryL,G1H2(202),ex3(:),G1H1(1),m3h2x1(:,714),heltab2x2(:,:,714))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),4,nMT,G2tensor(608),n2h1(426))
  call Hloop_AV_Q(ntryL,G1H2(213),ex3(:),G1H1(1),m3h2x1(:,715),heltab2x2(:,:,715))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,nMT,G2tensor(609),n2h1(427))
  call Hloop_AV_Q(ntryL,G1H2(216),ex4(:),G1H1(1),m3h2x1(:,716),heltab2x2(:,:,716))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,nMT,G2tensor(610),n2h1(428))
  call Hloop_AV_Q(ntryL,G1H2(217),ex4(:),G1H1(1),m3h2x1(:,717),heltab2x2(:,:,717))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),8,nMT,G2tensor(611),n2h1(429))
  call Hloop_AV_Q(ntryL,G1H2(268),ex4(:),G1H1(1),m3h2x1(:,718),heltab2x2(:,:,718))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,nMT,G2tensor(612),n2h1(430))
  call Hloop_AV_Q(ntryL,G1H2(246),ex3(:),G1H1(1),m3h2x1(:,719),heltab2x2(:,:,719))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,nMB,G2tensor(613),n2h1(431))
  call Hloop_AV_Q(ntryL,G1H2(235),ex3(:),G1H1(1),m3h2x1(:,720),heltab2x2(:,:,720))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),4,nMB,G2tensor(614),n2h1(432))
  call Hloop_AV_Q(ntryL,G1H2(250),ex3(:),G1H1(1),m3h2x1(:,721),heltab2x2(:,:,721))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,nMB,G2tensor(615),n2h1(433))
  call Hloop_AV_Q(ntryL,G1H2(256),ex4(:),G1H1(1),m3h2x1(:,722),heltab2x2(:,:,722))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,nMB,G2tensor(616),n2h1(434))
  call Hloop_AV_Q(ntryL,G1H2(257),ex4(:),G1H1(1),m3h2x1(:,723),heltab2x2(:,:,723))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),8,nMB,G2tensor(617),n2h1(435))
  call Hloop_AV_Q(ntryL,G1H2(310),ex4(:),G1H1(1),m3h2x1(:,724),heltab2x2(:,:,724))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,nMB,G2tensor(618),n2h1(436))
  call Hcheck_last_TV_S(ntryL,l_switch,G1H2(283),27,ex3(:),4,G2tensor(619),m3h2x1(:,725),heltab2x2(:,:,725))
  call Hcheck_last_TV_S(ntryL,l_switch,G1H2(272),0,ex3(:),4,G2tensor(620),m3h2x1(:,726),heltab2x2(:,:,726))
  call Hcheck_last_TV_S(ntryL,l_switch,G1H2(278),27,ex3(:),4,G2tensor(621),m3h2x1(:,727),heltab2x2(:,:,727))
  call Hloop_AV_Q(ntryL,G1H2(282),ex3(:),G1H1(1),m3h2x1(:,728),heltab2x2(:,:,728))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,nMT,G2tensor(622),n2h1(438))
  call Hloop_AV_Q(ntryL,G1H2(294),ex3(:),G1H1(1),m3h2x1(:,729),heltab2x2(:,:,729))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),4,nMT,G2tensor(623),n2h1(439))
  call Hloop_AV_Q(ntryL,G1H2(305),ex3(:),G1H1(1),m3h2x1(:,730),heltab2x2(:,:,730))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,nMT,G2tensor(624),n2h1(440))
  call Hloop_AV_Q(ntryL,G1H2(309),ex4(:),G1H1(1),m3h2x1(:,731),heltab2x2(:,:,731))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,nMT,G2tensor(625),n2h1(441))
  call Hloop_AV_Q(ntryL,G1H2(321),ex4(:),G1H1(1),m3h2x1(:,732),heltab2x2(:,:,732))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),8,nMT,G2tensor(626),n2h1(442))
  call Hloop_AV_Q(ntryL,G1H2(344),ex4(:),G1H1(1),m3h2x1(:,733),heltab2x2(:,:,733))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,nMT,G2tensor(627),n2h1(443))
  call Hcheck_last_UV_W(ntryL,l_switch,G1H2(333),27,ex3(:),4,G2tensor(628),m3h2x1(:,734),heltab2x2(:,:,734))
  call Hcheck_last_UV_W(ntryL,l_switch,G1H2(337),0,ex3(:),4,G2tensor(629),m3h2x1(:,735),heltab2x2(:,:,735))
  call Hcheck_last_UV_W(ntryL,l_switch,G1H2(354),27,ex3(:),4,G2tensor(630),m3h2x1(:,736),heltab2x2(:,:,736))
  call Hloop_AV_Q(ntryL,G1H2(355),ex4(:),G1H1(1),m3h2x1(:,737),heltab2x2(:,:,737))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,nMT,G2tensor(631),n2h1(445))
  call Hloop_AV_Q(ntryL,G1H2(359),ex4(:),G1H1(1),m3h2x1(:,738),heltab2x2(:,:,738))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),8,nMT,G2tensor(632),n2h1(446))
  call Hloop_AV_Q(ntryL,G1H2(381),ex4(:),G1H1(1),m3h2x1(:,739),heltab2x2(:,:,739))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,nMT,G2tensor(633),n2h1(447))
  call Hloop_AV_Q(ntryL,G1H2(370),ex3(:),G1H1(1),m3h2x1(:,740),heltab2x2(:,:,740))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,nMT,G2tensor(634),n2h1(448))
  call Hloop_AV_Q(ntryL,G1H2(414),ex3(:),G1H1(1),m3h2x1(:,741),heltab2x2(:,:,741))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),4,nMT,G2tensor(635),n2h1(449))
  call Hloop_AV_Q(ntryL,G1H2(380),ex3(:),G1H1(1),m3h2x1(:,742),heltab2x2(:,:,742))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,nMT,G2tensor(636),n2h1(450))
  call Hloop_AV_Q(ntryL,G1H2(392),ex4(:),G1H1(1),m3h2x1(:,743),heltab2x2(:,:,743))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,nMT,G2tensor(637),n2h1(451))
  call Hloop_AV_Q(ntryL,G1H2(398),ex4(:),G1H1(1),m3h2x1(:,744),heltab2x2(:,:,744))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),8,nMT,G2tensor(638),n2h1(452))
  call Hloop_AV_Q(ntryL,G1H2(407),ex4(:),G1H1(1),m3h2x1(:,745),heltab2x2(:,:,745))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,nMT,G2tensor(639),n2h1(453))
  call Hloop_AV_Q(ntryL,G1H2(419),ex3(:),G1H1(1),m3h2x1(:,746),heltab2x2(:,:,746))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,nMT,G2tensor(640),n2h1(454))
  call Hloop_AV_Q(ntryL,G1H2(423),ex3(:),G1H1(1),m3h2x1(:,747),heltab2x2(:,:,747))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),4,nMT,G2tensor(641),n2h1(455))
  call Hloop_AV_Q(ntryL,G1H2(424),ex3(:),G1H1(1),m3h2x1(:,748),heltab2x2(:,:,748))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,nMT,G2tensor(642),n2h1(456))
  call Hloop_AV_Q(ntryL,G1H2(468),ex4(:),G1H1(1),m3h2x1(:,749),heltab2x2(:,:,749))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,nMB,G2tensor(643),n2h1(457))
  call Hloop_AV_Q(ntryL,G1H2(441),ex4(:),G1H1(1),m3h2x1(:,750),heltab2x2(:,:,750))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),8,nMB,G2tensor(644),n2h1(458))
  call Hloop_AV_Q(ntryL,G1H2(445),ex4(:),G1H1(1),m3h2x1(:,751),heltab2x2(:,:,751))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,nMB,G2tensor(645),n2h1(459))
  call Hloop_AV_Q(ntryL,G1H2(446),ex3(:),G1H1(1),m3h2x1(:,752),heltab2x2(:,:,752))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,nMB,G2tensor(646),n2h1(460))
  call Hloop_AV_Q(ntryL,G1H2(452),ex3(:),G1H1(1),m3h2x1(:,753),heltab2x2(:,:,753))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),4,nMB,G2tensor(647),n2h1(461))
  call Hloop_AV_Q(ntryL,G1H2(461),ex3(:),G1H1(1),m3h2x1(:,754),heltab2x2(:,:,754))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,nMB,G2tensor(648),n2h1(462))
  call Hcheck_last_TV_S(ntryL,l_switch,G1H2(473),23,ex4(:),8,G2tensor(649),m3h2x1(:,755),heltab2x2(:,:,755))
  call Hcheck_last_TV_S(ntryL,l_switch,G1H2(477),0,ex4(:),8,G2tensor(650),m3h2x1(:,756),heltab2x2(:,:,756))
  call Hcheck_last_TV_S(ntryL,l_switch,G1H2(478),23,ex4(:),8,G2tensor(651),m3h2x1(:,757),heltab2x2(:,:,757))
  call Hloop_AV_Q(ntryL,G1H2(522),ex4(:),G1H1(1),m3h2x1(:,758),heltab2x2(:,:,758))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,nMT,G2tensor(652),n2h1(464))
  call Hloop_AV_Q(ntryL,G1H2(495),ex4(:),G1H1(1),m3h2x1(:,759),heltab2x2(:,:,759))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),8,nMT,G2tensor(653),n2h1(465))
  call Hloop_AV_Q(ntryL,G1H2(499),ex4(:),G1H1(1),m3h2x1(:,760),heltab2x2(:,:,760))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,nMT,G2tensor(654),n2h1(466))
  call Hloop_AV_Q(ntryL,G1H2(500),ex3(:),G1H1(1),m3h2x1(:,761),heltab2x2(:,:,761))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,nMT,G2tensor(655),n2h1(467))
  call Hloop_AV_Q(ntryL,G1H2(506),ex3(:),G1H1(1),m3h2x1(:,762),heltab2x2(:,:,762))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),4,nMT,G2tensor(656),n2h1(468))
  call Hloop_AV_Q(ntryL,G1H2(515),ex3(:),G1H1(1),m3h2x1(:,763),heltab2x2(:,:,763))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,nMT,G2tensor(657),n2h1(469))
  call Hcheck_last_UV_W(ntryL,l_switch,G1H2(527),23,ex4(:),8,G2tensor(658),m3h2x1(:,764),heltab2x2(:,:,764))
  call Hcheck_last_UV_W(ntryL,l_switch,G1H2(531),0,ex4(:),8,G2tensor(659),m3h2x1(:,765),heltab2x2(:,:,765))
  call Hcheck_last_UV_W(ntryL,l_switch,G1H2(553),23,ex4(:),8,G2tensor(660),m3h2x1(:,766),heltab2x2(:,:,766))
  call Hloop_SQ_A(ntryL,G1H2(566),ex1(:),G1H1(1),ngPbt,m3h2x1(:,767),heltab2x2(:,:,767))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,nMB,G2tensor(661),n2h1(471))
  call Hloop_SQ_A(ntryL,G1H2(571),ex1(:),G1H1(1),ngPbt,m3h2x1(:,768),heltab2x2(:,:,768))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),1,nMB,G2tensor(662),n2h1(472))
  call Hloop_SQ_A(ntryL,G1H2(199),ex1(:),G1H1(1),ngPbt,m3h2x1(:,769),heltab2x2(:,:,769))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,nMB,G2tensor(663),n2h1(473))
  call Hloop_WQ_A(ntryL,G1H2(192),ex1(:),G1H1(1),m3h2x1(:,770),heltab2x2(:,:,770))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,nMB,G2tensor(664),n2h1(474))
  call Hloop_WQ_A(ntryL,G1H2(210),ex1(:),G1H1(1),m3h2x1(:,771),heltab2x2(:,:,771))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),1,nMB,G2tensor(665),n2h1(475))
  call Hloop_WQ_A(ntryL,G1H2(170),ex1(:),G1H1(1),m3h2x1(:,772),heltab2x2(:,:,772))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,nMB,G2tensor(666),n2h1(476))
  call Hloop_SQ_A(ntryL,G1H2(188),ex1(:),G1H1(1),ngPbt,m3h2x1(:,773),heltab2x2(:,:,773))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,nMB,G2tensor(667),n2h1(477))
  call Hloop_SQ_A(ntryL,G1H2(181),ex1(:),G1H1(1),ngPbt,m3h2x1(:,774),heltab2x2(:,:,774))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),1,nMB,G2tensor(668),n2h1(478))
  call Hloop_SQ_A(ntryL,G1H2(58),ex1(:),G1H1(1),ngPbt,m3h2x1(:,775),heltab2x2(:,:,775))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,nMB,G2tensor(669),n2h1(479))
  call Hloop_WQ_A(ntryL,G1H2(449),ex1(:),G1H1(1),m3h2x1(:,776),heltab2x2(:,:,776))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,nMB,G2tensor(670),n2h1(480))
  call Hloop_WQ_A(ntryL,G1H2(286),ex1(:),G1H1(1),m3h2x1(:,777),heltab2x2(:,:,777))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),1,nMB,G2tensor(671),n2h1(481))
  call Hloop_WQ_A(ntryL,G1H2(298),ex1(:),G1H1(1),m3h2x1(:,778),heltab2x2(:,:,778))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,nMB,G2tensor(672),n2h1(482))
  call Hloop_SA_Q(ntryL,G1H2(588),ex2(:),G1H1(1),ngPtb,m3h2x1(:,779),heltab2x2(:,:,779))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,nMB,G2tensor(673),n2h1(483))
  call Hloop_SA_Q(ntryL,G1H2(504),ex2(:),G1H1(1),ngPtb,m3h2x1(:,780),heltab2x2(:,:,780))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),2,nMB,G2tensor(674),n2h1(484))
  call Hloop_SA_Q(ntryL,G1H2(520),ex2(:),G1H1(1),ngPtb,m3h2x1(:,781),heltab2x2(:,:,781))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,nMB,G2tensor(675),n2h1(485))
  call Hloop_WA_Q(ntryL,G1H2(334),ex2(:),G1H1(1),m3h2x1(:,782),heltab2x2(:,:,782))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,nMB,G2tensor(676),n2h1(486))
  call Hloop_WA_Q(ntryL,G1H2(144),ex2(:),G1H1(1),m3h2x1(:,783),heltab2x2(:,:,783))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),2,nMB,G2tensor(677),n2h1(487))
  call Hloop_WA_Q(ntryL,G1H2(155),ex2(:),G1H1(1),m3h2x1(:,784),heltab2x2(:,:,784))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,nMB,G2tensor(678),n2h1(488))
  call Hcheck_last_SV_T(ntryL,l_switch,G1H2(589),23,ex4(:),8,G2tensor(679),m3h2x1(:,785),heltab2x2(:,:,785))
  call Hcheck_last_SV_T(ntryL,l_switch,G1H2(362),0,ex4(:),8,G2tensor(680),m3h2x1(:,786),heltab2x2(:,:,786))
  call Hcheck_last_SV_T(ntryL,l_switch,G1H2(378),23,ex4(:),8,G2tensor(681),m3h2x1(:,787),heltab2x2(:,:,787))
  call Hloop_SA_Q(ntryL,G1H2(225),ex2(:),G1H1(1),ngPtb,m3h2x1(:,788),heltab2x2(:,:,788))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,nMB,G2tensor(682),n2h1(490))
  call Hloop_SA_Q(ntryL,G1H2(110),ex2(:),G1H1(1),ngPtb,m3h2x1(:,789),heltab2x2(:,:,789))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),2,nMB,G2tensor(683),n2h1(491))
  call Hloop_SA_Q(ntryL,G1H2(186),ex2(:),G1H1(1),ngPtb,m3h2x1(:,790),heltab2x2(:,:,790))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,nMB,G2tensor(684),n2h1(492))
  call Hcheck_last_UW_V(ntryL,l_switch,G1H2(406),23,ex4(:),8,G2tensor(685),m3h2x1(:,791),heltab2x2(:,:,791))
  call Hcheck_last_UW_V(ntryL,l_switch,G1H2(254),0,ex4(:),8,G2tensor(686),m3h2x1(:,792),heltab2x2(:,:,792))
  call Hcheck_last_UW_V(ntryL,l_switch,G1H2(100),23,ex4(:),8,G2tensor(687),m3h2x1(:,793),heltab2x2(:,:,793))
  call Hloop_WA_Q(ntryL,G1H2(50),ex2(:),G1H1(1),m3h2x1(:,794),heltab2x2(:,:,794))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,nMB,G2tensor(688),n2h1(494))
  call Hloop_WA_Q(ntryL,G1H2(231),ex2(:),G1H1(1),m3h2x1(:,795),heltab2x2(:,:,795))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),2,nMB,G2tensor(689),n2h1(495))
  call Hloop_WA_Q(ntryL,G1H2(253),ex2(:),G1H1(1),m3h2x1(:,796),heltab2x2(:,:,796))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,nMB,G2tensor(690),n2h1(496))
  call Hloop_SA_Q(ntryL,G1H2(265),ex2(:),G1H1(1),ngPtb,m3h2x1(:,797),heltab2x2(:,:,797))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,nMB,G2tensor(691),n2h1(497))
  call Hloop_SA_Q(ntryL,G1H2(275),ex2(:),G1H1(1),ngPtb,m3h2x1(:,798),heltab2x2(:,:,798))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),2,nMB,G2tensor(692),n2h1(498))
  call Hloop_SA_Q(ntryL,G1H2(595),ex2(:),G1H1(1),ngPtb,m3h2x1(:,799),heltab2x2(:,:,799))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,nMB,G2tensor(693),n2h1(499))
  call Hloop_WA_Q(ntryL,G1H2(596),ex2(:),G1H1(1),m3h2x1(:,800),heltab2x2(:,:,800))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,nMB,G2tensor(694),n2h1(500))
  call Hloop_WA_Q(ntryL,G1H2(597),ex2(:),G1H1(1),m3h2x1(:,801),heltab2x2(:,:,801))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),2,nMB,G2tensor(695),n2h1(501))
  call Hloop_WA_Q(ntryL,G1H2(600),ex2(:),G1H1(1),m3h2x1(:,802),heltab2x2(:,:,802))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,nMB,G2tensor(696),n2h1(502))
  call Hcheck_last_SV_T(ntryL,l_switch,G1H2(601),27,ex3(:),4,G2tensor(697),m3h2x1(:,803),heltab2x2(:,:,803))
  call Hcheck_last_SV_T(ntryL,l_switch,G1H2(602),0,ex3(:),4,G2tensor(698),m3h2x1(:,804),heltab2x2(:,:,804))
  call Hcheck_last_SV_T(ntryL,l_switch,G1H2(605),27,ex3(:),4,G2tensor(699),m3h2x1(:,805),heltab2x2(:,:,805))
  call Hcheck_last_UW_V(ntryL,l_switch,G1H2(606),27,ex3(:),4,G2tensor(700),m3h2x1(:,806),heltab2x2(:,:,806))
  call Hcheck_last_UW_V(ntryL,l_switch,G1H2(607),0,ex3(:),4,G2tensor(701),m3h2x1(:,807),heltab2x2(:,:,807))
  call Hcheck_last_UW_V(ntryL,l_switch,G1H2(610),27,ex3(:),4,G2tensor(702),m3h2x1(:,808),heltab2x2(:,:,808))
  call Hloop_QV_A(ntryL,G1H2(611),ex4(:),G1H1(1),m3h2x1(:,809),heltab2x2(:,:,809))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,nMB,G2tensor(703),n2h1(505))
  call Hloop_QV_A(ntryL,G1H2(612),ex4(:),G1H1(1),m3h2x1(:,810),heltab2x2(:,:,810))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),8,nMB,G2tensor(704),n2h1(506))
  call Hloop_QV_A(ntryL,G1H2(615),ex4(:),G1H1(1),m3h2x1(:,811),heltab2x2(:,:,811))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,nMB,G2tensor(705),n2h1(507))
  call Hloop_QV_A(ntryL,G1H2(13),ex3(:),G1H1(1),m3h2x1(:,812),heltab2x2(:,:,812))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,nMB,G2tensor(706),n2h1(508))
  call Hloop_QV_A(ntryL,G1H2(14),ex3(:),G1H1(1),m3h2x1(:,813),heltab2x2(:,:,813))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),4,nMB,G2tensor(707),n2h1(509))
  call Hloop_QV_A(ntryL,G1H2(618),ex3(:),G1H1(1),m3h2x1(:,814),heltab2x2(:,:,814))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,nMB,G2tensor(708),n2h1(510))
  call Hcheck_last_TV_S(ntryL,l_switch,G1H2(19),23,ex4(:),8,G2tensor(709),m3h2x1(:,815),heltab2x2(:,:,815))
  call Hcheck_last_TV_S(ntryL,l_switch,G1H2(20),0,ex4(:),8,G2tensor(710),m3h2x1(:,816),heltab2x2(:,:,816))
  call Hcheck_last_TV_S(ntryL,l_switch,G1H2(621),23,ex4(:),8,G2tensor(711),m3h2x1(:,817),heltab2x2(:,:,817))
  call Hcheck_last_UV_W(ntryL,l_switch,G1H2(622),23,ex4(:),8,G2tensor(712),m3h2x1(:,818),heltab2x2(:,:,818))
  call Hcheck_last_UV_W(ntryL,l_switch,G1H2(623),0,ex4(:),8,G2tensor(713),m3h2x1(:,819),heltab2x2(:,:,819))
  call Hcheck_last_UV_W(ntryL,l_switch,G1H2(626),23,ex4(:),8,G2tensor(714),m3h2x1(:,820),heltab2x2(:,:,820))
  call Hcheck_last_SV_T(ntryL,l_switch,G1H2(627),23,ex4(:),8,G2tensor(715),m3h2x1(:,821),heltab2x2(:,:,821))
  call Hcheck_last_SV_T(ntryL,l_switch,G1H2(628),0,ex4(:),8,G2tensor(716),m3h2x1(:,822),heltab2x2(:,:,822))
  call Hcheck_last_SV_T(ntryL,l_switch,G1H2(631),23,ex4(:),8,G2tensor(717),m3h2x1(:,823),heltab2x2(:,:,823))
  call Hcheck_last_UW_V(ntryL,l_switch,G1H2(632),23,ex4(:),8,G2tensor(718),m3h2x1(:,824),heltab2x2(:,:,824))
  call Hcheck_last_UW_V(ntryL,l_switch,G1H2(633),0,ex4(:),8,G2tensor(719),m3h2x1(:,825),heltab2x2(:,:,825))
  call Hcheck_last_UW_V(ntryL,l_switch,G1H2(636),23,ex4(:),8,G2tensor(720),m3h2x1(:,826),heltab2x2(:,:,826))
  call Hcheck_last_SV_T(ntryL,l_switch,G1H2(637),23,ex4(:),8,G2tensor(721),m3h2x1(:,827),heltab2x2(:,:,827))
  call Hcheck_last_SV_T(ntryL,l_switch,G1H2(638),0,ex4(:),8,G2tensor(722),m3h2x1(:,828),heltab2x2(:,:,828))
  call Hcheck_last_SV_T(ntryL,l_switch,G1H2(641),23,ex4(:),8,G2tensor(723),m3h2x1(:,829),heltab2x2(:,:,829))
  call Hcheck_last_UW_V(ntryL,l_switch,G1H2(642),23,ex4(:),8,G2tensor(724),m3h2x1(:,830),heltab2x2(:,:,830))
  call Hcheck_last_UW_V(ntryL,l_switch,G1H2(643),0,ex4(:),8,G2tensor(725),m3h2x1(:,831),heltab2x2(:,:,831))
  call Hcheck_last_UW_V(ntryL,l_switch,G1H2(646),23,ex4(:),8,G2tensor(726),m3h2x1(:,832),heltab2x2(:,:,832))
  call Hcheck_last_SV_T(ntryL,l_switch,G1H2(647),27,ex3(:),4,G2tensor(727),m3h2x1(:,833),heltab2x2(:,:,833))
  call Hcheck_last_SV_T(ntryL,l_switch,G1H2(648),0,ex3(:),4,G2tensor(728),m3h2x1(:,834),heltab2x2(:,:,834))
  call Hcheck_last_SV_T(ntryL,l_switch,G1H2(651),27,ex3(:),4,G2tensor(729),m3h2x1(:,835),heltab2x2(:,:,835))
  call Hcheck_last_UW_V(ntryL,l_switch,G1H2(652),27,ex3(:),4,G2tensor(730),m3h2x1(:,836),heltab2x2(:,:,836))
  call Hcheck_last_UW_V(ntryL,l_switch,G1H2(653),0,ex3(:),4,G2tensor(731),m3h2x1(:,837),heltab2x2(:,:,837))
  call Hcheck_last_UW_V(ntryL,l_switch,G1H2(656),27,ex3(:),4,G2tensor(732),m3h2x1(:,838),heltab2x2(:,:,838))
  call Hcheck_last_TV_S(ntryL,l_switch,G1H2(657),23,ex4(:),8,G2tensor(733),m3h2x1(:,839),heltab2x2(:,:,839))
  call Hcheck_last_TV_S(ntryL,l_switch,G1H2(658),0,ex4(:),8,G2tensor(734),m3h2x1(:,840),heltab2x2(:,:,840))
  call Hcheck_last_TV_S(ntryL,l_switch,G1H2(661),23,ex4(:),8,G2tensor(735),m3h2x1(:,841),heltab2x2(:,:,841))
  call Hcheck_last_TV_S(ntryL,l_switch,G1H2(662),23,ex4(:),8,G2tensor(736),m3h2x1(:,842),heltab2x2(:,:,842))
  call Hcheck_last_TV_S(ntryL,l_switch,G1H2(663),0,ex4(:),8,G2tensor(737),m3h2x1(:,843),heltab2x2(:,:,843))
  call Hcheck_last_TV_S(ntryL,l_switch,G1H2(666),23,ex4(:),8,G2tensor(738),m3h2x1(:,844),heltab2x2(:,:,844))
  call Hcheck_last_UV_W(ntryL,l_switch,G1H2(667),23,ex4(:),8,G2tensor(739),m3h2x1(:,845),heltab2x2(:,:,845))
  call Hcheck_last_UV_W(ntryL,l_switch,G1H2(668),0,ex4(:),8,G2tensor(740),m3h2x1(:,846),heltab2x2(:,:,846))
  call Hcheck_last_UV_W(ntryL,l_switch,G1H2(671),23,ex4(:),8,G2tensor(741),m3h2x1(:,847),heltab2x2(:,:,847))
  call Hcheck_last_UV_W(ntryL,l_switch,G1H2(672),23,ex4(:),8,G2tensor(742),m3h2x1(:,848),heltab2x2(:,:,848))
  call Hcheck_last_UV_W(ntryL,l_switch,G1H2(673),0,ex4(:),8,G2tensor(743),m3h2x1(:,849),heltab2x2(:,:,849))
  call Hcheck_last_UV_W(ntryL,l_switch,G1H2(676),23,ex4(:),8,G2tensor(744),m3h2x1(:,850),heltab2x2(:,:,850))
  call Hcheck_last_TV_S(ntryL,l_switch,G1H2(677),27,ex3(:),4,G2tensor(745),m3h2x1(:,851),heltab2x2(:,:,851))
  call Hcheck_last_TV_S(ntryL,l_switch,G1H2(678),0,ex3(:),4,G2tensor(746),m3h2x1(:,852),heltab2x2(:,:,852))
  call Hcheck_last_TV_S(ntryL,l_switch,G1H2(681),27,ex3(:),4,G2tensor(747),m3h2x1(:,853),heltab2x2(:,:,853))
  call Hcheck_last_TV_S(ntryL,l_switch,G1H2(682),27,ex3(:),4,G2tensor(748),m3h2x1(:,854),heltab2x2(:,:,854))
  call Hcheck_last_TV_S(ntryL,l_switch,G1H2(683),0,ex3(:),4,G2tensor(749),m3h2x1(:,855),heltab2x2(:,:,855))
  call Hcheck_last_TV_S(ntryL,l_switch,G1H2(686),27,ex3(:),4,G2tensor(750),m3h2x1(:,856),heltab2x2(:,:,856))
  call Hcheck_last_UV_W(ntryL,l_switch,G1H2(687),27,ex3(:),4,G2tensor(751),m3h2x1(:,857),heltab2x2(:,:,857))
  call Hcheck_last_UV_W(ntryL,l_switch,G1H2(688),0,ex3(:),4,G2tensor(752),m3h2x1(:,858),heltab2x2(:,:,858))
  call Hcheck_last_UV_W(ntryL,l_switch,G1H2(691),27,ex3(:),4,G2tensor(753),m3h2x1(:,859),heltab2x2(:,:,859))
  call Hcheck_last_UV_W(ntryL,l_switch,G1H2(692),27,ex3(:),4,G2tensor(754),m3h2x1(:,860),heltab2x2(:,:,860))
  call Hcheck_last_UV_W(ntryL,l_switch,G1H2(693),0,ex3(:),4,G2tensor(755),m3h2x1(:,861),heltab2x2(:,:,861))
  call Hcheck_last_UV_W(ntryL,l_switch,G1H2(696),27,ex3(:),4,G2tensor(756),m3h2x1(:,862),heltab2x2(:,:,862))
  call Hloop_SA_Q(ntryL,G1H2(697),ex2(:),G1H1(1),ngPtb,m3h2x1(:,863),heltab2x2(:,:,863))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,nMB,G2tensor(757),n2h1(527))
  call Hloop_SA_Q(ntryL,G1H2(698),ex2(:),G1H1(1),ngPtb,m3h2x1(:,864),heltab2x2(:,:,864))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),2,nMB,G2tensor(758),n2h1(528))
  call Hloop_SA_Q(ntryL,G1H2(701),ex2(:),G1H1(1),ngPtb,m3h2x1(:,865),heltab2x2(:,:,865))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,nMB,G2tensor(759),n2h1(529))
  call Hloop_SA_Q(ntryL,G1H2(702),ex2(:),G1H1(1),ngPtb,m3h2x1(:,866),heltab2x2(:,:,866))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,nMB,G2tensor(760),n2h1(530))
  call Hloop_SA_Q(ntryL,G1H2(703),ex2(:),G1H1(1),ngPtb,m3h2x1(:,867),heltab2x2(:,:,867))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),2,nMB,G2tensor(761),n2h1(531))
  call Hloop_SA_Q(ntryL,G1H2(706),ex2(:),G1H1(1),ngPtb,m3h2x1(:,868),heltab2x2(:,:,868))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,nMB,G2tensor(762),n2h1(532))
  call Hloop_WA_Q(ntryL,G1H2(707),ex2(:),G1H1(1),m3h2x1(:,869),heltab2x2(:,:,869))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,nMB,G2tensor(763),n2h1(533))
  call Hloop_WA_Q(ntryL,G1H2(708),ex2(:),G1H1(1),m3h2x1(:,870),heltab2x2(:,:,870))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),2,nMB,G2tensor(764),n2h1(534))
  call Hloop_WA_Q(ntryL,G1H2(711),ex2(:),G1H1(1),m3h2x1(:,871),heltab2x2(:,:,871))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,nMB,G2tensor(765),n2h1(535))
  call Hloop_WA_Q(ntryL,G1H2(712),ex2(:),G1H1(1),m3h2x1(:,872),heltab2x2(:,:,872))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,nMB,G2tensor(766),n2h1(536))
  call Hloop_WA_Q(ntryL,G1H2(713),ex2(:),G1H1(1),m3h2x1(:,873),heltab2x2(:,:,873))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),2,nMB,G2tensor(767),n2h1(537))
  call Hloop_WA_Q(ntryL,G1H2(716),ex2(:),G1H1(1),m3h2x1(:,874),heltab2x2(:,:,874))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,nMB,G2tensor(768),n2h1(538))
  call Hloop_SA_Q(ntryL,G1H2(717),ex2(:),G1H1(1),ngPtb,m3h2x1(:,875),heltab2x2(:,:,875))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,nMB,G2tensor(769),n2h1(539))
  call Hloop_SA_Q(ntryL,G1H2(718),ex2(:),G1H1(1),ngPtb,m3h2x1(:,876),heltab2x2(:,:,876))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),2,nMB,G2tensor(770),n2h1(540))
  call Hloop_SA_Q(ntryL,G1H2(721),ex2(:),G1H1(1),ngPtb,m3h2x1(:,877),heltab2x2(:,:,877))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,nMB,G2tensor(771),n2h1(541))
  call Hloop_SA_Q(ntryL,G1H2(722),ex2(:),G1H1(1),ngPtb,m3h2x1(:,878),heltab2x2(:,:,878))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,nMB,G2tensor(772),n2h1(542))
  call Hloop_SA_Q(ntryL,G1H2(723),ex2(:),G1H1(1),ngPtb,m3h2x1(:,879),heltab2x2(:,:,879))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),2,nMB,G2tensor(773),n2h1(543))
  call Hloop_SA_Q(ntryL,G1H2(726),ex2(:),G1H1(1),ngPtb,m3h2x1(:,880),heltab2x2(:,:,880))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,nMB,G2tensor(774),n2h1(544))
  call Hloop_WA_Q(ntryL,G1H2(727),ex2(:),G1H1(1),m3h2x1(:,881),heltab2x2(:,:,881))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,nMB,G2tensor(775),n2h1(545))
  call Hloop_WA_Q(ntryL,G1H2(728),ex2(:),G1H1(1),m3h2x1(:,882),heltab2x2(:,:,882))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),2,nMB,G2tensor(776),n2h1(546))
  call Hloop_WA_Q(ntryL,G1H2(731),ex2(:),G1H1(1),m3h2x1(:,883),heltab2x2(:,:,883))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,nMB,G2tensor(777),n2h1(547))
  call Hloop_WA_Q(ntryL,G1H2(732),ex2(:),G1H1(1),m3h2x1(:,884),heltab2x2(:,:,884))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,nMB,G2tensor(778),n2h1(548))
  call Hloop_WA_Q(ntryL,G1H2(733),ex2(:),G1H1(1),m3h2x1(:,885),heltab2x2(:,:,885))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),2,nMB,G2tensor(779),n2h1(549))
  call Hloop_WA_Q(ntryL,G1H2(736),ex2(:),G1H1(1),m3h2x1(:,886),heltab2x2(:,:,886))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,nMB,G2tensor(780),n2h1(550))
  call Hcheck_last_SV_T(ntryL,l_switch,G1H2(119),23,ex4(:),8,G2tensor(781),m3h2x1(:,887),heltab2x2(:,:,887))
  call Hcheck_last_SV_T(ntryL,l_switch,G1H2(190),0,ex4(:),8,G2tensor(782),m3h2x1(:,888),heltab2x2(:,:,888))
  call Hcheck_last_SV_T(ntryL,l_switch,G1H2(129),23,ex4(:),8,G2tensor(783),m3h2x1(:,889),heltab2x2(:,:,889))
  call Hcheck_last_UW_V(ntryL,l_switch,G1H2(146),23,ex4(:),8,G2tensor(784),m3h2x1(:,890),heltab2x2(:,:,890))
  call Hcheck_last_UW_V(ntryL,l_switch,G1H2(134),0,ex4(:),8,G2tensor(785),m3h2x1(:,891),heltab2x2(:,:,891))
  call Hcheck_last_UW_V(ntryL,l_switch,G1H2(306),23,ex4(:),8,G2tensor(786),m3h2x1(:,892),heltab2x2(:,:,892))
  call Hcheck_last_SV_T(ntryL,l_switch,G1H2(156),27,ex3(:),4,G2tensor(787),m3h2x1(:,893),heltab2x2(:,:,893))
  call Hcheck_last_SV_T(ntryL,l_switch,G1H2(322),0,ex3(:),4,G2tensor(788),m3h2x1(:,894),heltab2x2(:,:,894))
  call Hcheck_last_SV_T(ntryL,l_switch,G1H2(739),27,ex3(:),4,G2tensor(789),m3h2x1(:,895),heltab2x2(:,:,895))
  call Hcheck_last_SV_T(ntryL,l_switch,G1H2(740),27,ex3(:),4,G2tensor(790),m3h2x1(:,896),heltab2x2(:,:,896))
  call Hcheck_last_SV_T(ntryL,l_switch,G1H2(741),0,ex3(:),4,G2tensor(791),m3h2x1(:,897),heltab2x2(:,:,897))
  call Hcheck_last_SV_T(ntryL,l_switch,G1H2(744),27,ex3(:),4,G2tensor(792),m3h2x1(:,898),heltab2x2(:,:,898))
  call Hcheck_last_UW_V(ntryL,l_switch,G1H2(167),27,ex3(:),4,G2tensor(793),m3h2x1(:,899),heltab2x2(:,:,899))
  call Hcheck_last_UW_V(ntryL,l_switch,G1H2(168),0,ex3(:),4,G2tensor(794),m3h2x1(:,900),heltab2x2(:,:,900))
  call Hcheck_last_UW_V(ntryL,l_switch,G1H2(746),27,ex3(:),4,G2tensor(795),m3h2x1(:,901),heltab2x2(:,:,901))
  call Hcheck_last_UW_V(ntryL,l_switch,G1H2(747),27,ex3(:),4,G2tensor(796),m3h2x1(:,902),heltab2x2(:,:,902))
  call Hcheck_last_UW_V(ntryL,l_switch,G1H2(748),0,ex3(:),4,G2tensor(797),m3h2x1(:,903),heltab2x2(:,:,903))



end subroutine vamp_1

end module ol_vamp_1_ppttj_ew_ttxaaa_2_/**/REALKIND
