
module ol_vamp_3_ppttj_ew_ttxbbxg_1_/**/REALKIND
contains

! **********************************************************************
subroutine vamp_3(M)
! P(0:3,nlegs) = incoming external momenta
! Uses tree structures 'wf', factors 'c', and denominators 'den' from loop_ppttj_ew_ttxbbxg_1.
! Sets colour stripped amplitudes A from the module loop_amplitudes_ppttj_ew_ttxbbxg_1.
! **********************************************************************
  use KIND_TYPES, only: REALKIND, QREALKIND, intkind2
  use ol_parameters_decl_/**/DREALKIND, only: l_switch
  use ol_parameters_decl_/**/QREALKIND ! masses
  use ol_vert_interface_/**/REALKIND
  use ol_prop_interface_/**/REALKIND
  use ol_last_step_/**/REALKIND
  use ol_tables_storage_ppttj_ew_ttxbbxg_1_/**/DREALKIND
  use ol_tensor_sum_storage_ppttj_ew_ttxbbxg_1_/**/REALKIND
  use ol_loop_handling_/**/REALKIND
  use ofred_reduction_/**/REALKIND, only: Hotf_4pt_reduction, Hotf_4pt_reduction_last
  use ofred_reduction_/**/REALKIND, only: Hotf_5pt_reduction, Hotf_5pt_reduction_last
  use ol_loop_reduction_/**/REALKIND, only: TI_bubble_red, TI_triangle_red
use ol_loop_reduction_/**/REALKIND, only: compute_scalar_box

  use ol_loop_storage_ppttj_ew_ttxbbxg_1_/**/REALKIND
#ifndef PRECISION_dp
  use ol_loop_storage_ppttj_ew_ttxbbxg_1_/**/DREALKIND, only: &
    & p_switch, Hel, merge_step, merge_mism, merge_tables, merge_hels, ntryL
#endif
  use hol_initialisation_/**/REALKIND, only: G0_hol_initialisation
  use ol_h_vert_interface_/**/REALKIND
  use ol_h_prop_interface_/**/REALKIND
  use ol_h_last_step_/**/REALKIND
  use ol_merging_/**/REALKIND, only: ol_merge, ol_merge_tensors, ol_merge_last

  implicit none

  type(Hpolcont) :: Gcoeff(32)
  type(Hpolcont), intent(in) :: M(8,32)


#ifndef PRECISION_dp
  if (ntryL==1 .OR. p_switch == 1) Gcoeff(:)%hf = Hel
#else
  if (ntryL==1 .OR. p_switch == 2) Gcoeff(:)%hf = Hel
#endif

  ! =============================================
  call Hloop_QV_A(ntryL,G0H32(1),ex5(:),G0H16(1),m3h2x16(:,154),heltab2x32(:,:,258))
  call Hloop_Q_A(ntryL,G0H16(1),16,nMT,G1H16(72),n2h16(108))
  Gcoeff(:)%j = (c(71)*M(7,:)%j) * den(30)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(265),h0tab(:,265),[16,3,12],[nMB,nMB,nMB],3,2,wf4(:,3),wf4(:,2))
  call Hloop_AV_Q(ntryL,G0H32(1),ex5(:),G0H16(1),m3h2x16(:,155),heltab2x32(:,:,259))
  call Hloop_A_Q(ntryL,G0H16(1),16,nMB,G1H16(73),n2h16(109))
  Gcoeff(:)%j = (c(71)*M(7,:)%j) * den(30)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(266),h0tab(:,266),[16,3,12],[nMB,nMB,nMB],3,2,wf4(:,3),wf4(:,2))
  call Hloop_QV_A(ntryL,G0H32(1),ex5(:),G0H16(1),m3h2x16(:,156),heltab2x32(:,:,260))
  call Hloop_Q_A(ntryL,G0H16(1),16,nMB,G1H16(78),n2h16(110))
  Gcoeff(:)%j = (-(c(72)*M(7,:)%j)) * den(32)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(267),h0tab(:,267),[16,3,12],[nMT,nMT,nMT],3,2,wf4(:,6),wf4(:,2))
  call Hloop_AV_Q(ntryL,G0H32(1),ex5(:),G0H16(1),m3h2x16(:,157),heltab2x32(:,:,261))
  call Hloop_A_Q(ntryL,G0H16(1),16,nMT,G1H16(76),n2h16(111))
  Gcoeff(:)%j = (-(c(72)*M(7,:)%j)) * den(32)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(268),h0tab(:,268),[16,3,12],[nMT,nMT,nMT],3,2,wf4(:,6),wf4(:,2))
  call Hloop_QV_A(ntryL,G0H32(1),ex5(:),G0H16(1),m3h2x16(:,158),heltab2x32(:,:,262))
  call Hloop_Q_A(ntryL,G0H16(1),16,nMT,G1H16(77),n2h16(112))
  Gcoeff(:)%j = (c(71)*M(7,:)%j) * den(32)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(269),h0tab(:,269),[16,3,12],[nMB,nMB,nMB],3,2,wf4(:,6),wf4(:,2))
  call Hloop_AV_Q(ntryL,G0H32(1),ex5(:),G0H16(1),m3h2x16(:,159),heltab2x32(:,:,263))
  call Hloop_A_Q(ntryL,G0H16(1),16,nMB,G1H16(79),n2h16(113))
  Gcoeff(:)%j = (c(71)*M(7,:)%j) * den(32)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(270),h0tab(:,270),[16,3,12],[nMB,nMB,nMB],3,2,wf4(:,6),wf4(:,2))
  call Hloop_QV_A(ntryL,G0H32(1),ex5(:),G0H16(1),m3h2x16(:,160),heltab2x32(:,:,264))
  call Hloop_Q_A(ntryL,G0H16(1),16,nMB,G1H16(80),n2h16(114))
  Gcoeff(:)%j = (c(71)*M(1,:)%j) * den(31)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(271),h0tab(:,271),[16,3,12],[nMT,nMT,nMT],3,2,wf4(:,1),wf4(:,18))
  call Hloop_AV_Q(ntryL,G0H32(1),ex5(:),G0H16(1),m3h2x16(:,161),heltab2x32(:,:,265))
  call Hloop_A_Q(ntryL,G0H16(1),16,nMT,G1H16(46),n2h16(115))
  Gcoeff(:)%j = (c(71)*M(1,:)%j) * den(31)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(272),h0tab(:,272),[16,3,12],[nMT,nMT,nMT],3,2,wf4(:,1),wf4(:,18))
  call Hloop_QV_A(ntryL,G0H32(1),ex5(:),G0H16(1),m3h2x16(:,162),heltab2x32(:,:,266))
  call Hloop_Q_A(ntryL,G0H16(1),16,nMT,G1H16(32),n2h16(116))
  Gcoeff(:)%j = (c(70)*M(1,:)%j) * den(31)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(273),h0tab(:,273),[16,3,12],[nMB,nMB,nMB],3,2,wf4(:,1),wf4(:,18))
  call Hloop_AV_Q(ntryL,G0H32(1),ex5(:),G0H16(1),m3h2x16(:,163),heltab2x32(:,:,267))
  call Hloop_A_Q(ntryL,G0H16(1),16,nMB,G1H16(10),n2h16(117))
  Gcoeff(:)%j = (c(70)*M(1,:)%j) * den(31)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(274),h0tab(:,274),[16,3,12],[nMB,nMB,nMB],3,2,wf4(:,1),wf4(:,18))
  call Hloop_QV_A(ntryL,G0H32(1),ex5(:),G0H16(1),m3h2x16(:,164),heltab2x32(:,:,268))
  call Hloop_Q_A(ntryL,G0H16(1),16,nMB,G1H16(7),n2h16(118))
  Gcoeff(:)%j = (c(71)*M(1,:)%j) * den(33)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(275),h0tab(:,275),[16,3,12],[nMT,nMT,nMT],3,2,wf4(:,1),wf4(:,19))
  call Hloop_AV_Q(ntryL,G0H32(1),ex5(:),G0H16(1),m3h2x16(:,165),heltab2x32(:,:,269))
  call Hloop_A_Q(ntryL,G0H16(1),16,nMT,G1H16(23),n2h16(119))
  Gcoeff(:)%j = (c(71)*M(1,:)%j) * den(33)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(276),h0tab(:,276),[16,3,12],[nMT,nMT,nMT],3,2,wf4(:,1),wf4(:,19))
  call Hloop_QV_A(ntryL,G0H32(1),ex5(:),G0H16(1),m3h2x16(:,166),heltab2x32(:,:,270))
  call Hloop_Q_A(ntryL,G0H16(1),16,nMT,G1H16(45),n2h16(120))
  Gcoeff(:)%j = (-(c(70)*M(1,:)%j)) * den(33)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(277),h0tab(:,277),[16,3,12],[nMB,nMB,nMB],3,2,wf4(:,1),wf4(:,19))
  call Hloop_AV_Q(ntryL,G0H32(1),ex5(:),G0H16(1),m3h2x16(:,167),heltab2x32(:,:,271))
  call Hloop_A_Q(ntryL,G0H16(1),16,nMB,G1H16(42),n2h16(121))
  Gcoeff(:)%j = (-(c(70)*M(1,:)%j)) * den(33)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(278),h0tab(:,278),[16,3,12],[nMB,nMB,nMB],3,2,wf4(:,1),wf4(:,19))
  call Hloop_QV_A(ntryL,G0H32(1),ex5(:),G0H16(1),m3h2x16(:,168),heltab2x32(:,:,272))
  call Hloop_Q_A(ntryL,G0H16(1),16,nMB,G1H16(58),n2h16(122))
  Gcoeff(:)%j = (-(c(61)*M(7,:)%j)) * den(3)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(279),h0tab(:,279),[16,3,12],[0,0,0],3,2,wf4(:,1),wf4(:,2))
  call Hloop_AV_Q(ntryL,G0H32(1),ex5(:),G0H16(1),m3h2x16(:,169),heltab2x32(:,:,273))
  call Hloop_A_Q(ntryL,G0H16(1),16,0,G1H16(56),n2h16(123))
  Gcoeff(:)%j = (-(c(60)*M(7,:)%j)) * den(3)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(280),h0tab(:,280),[16,3,12],[nMT,nMT,nMT],3,2,wf4(:,1),wf4(:,2))
  call Hloop_AV_Q(ntryL,G0H32(1),ex5(:),G0H16(1),m3h2x16(:,170),heltab2x32(:,:,274))
  call Hloop_A_Q(ntryL,G0H16(1),16,nMT,G1H16(68),n2h16(124))
  Gcoeff(:)%j = (-(c(61)*M(7,:)%j)) * den(3)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(281),h0tab(:,281),[16,3,12],[0,0,0],3,2,wf4(:,1),wf4(:,2))
  call Hloop_QV_A(ntryL,G0H32(1),ex5(:),G0H16(1),m3h2x16(:,171),heltab2x32(:,:,275))
  call Hloop_Q_A(ntryL,G0H16(1),16,0,G1H16(6),n2h16(125))
  Gcoeff(:)%j = (-(c(60)*M(7,:)%j)) * den(3)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(282),h0tab(:,282),[16,3,12],[nMT,nMT,nMT],3,2,wf4(:,1),wf4(:,2))
  call Hloop_QV_A(ntryL,G0H32(1),ex5(:),G0H16(1),m3h2x16(:,172),heltab2x32(:,:,276))
  call Hloop_Q_A(ntryL,G0H16(1),16,nMT,G1H16(5),n2h16(126))
  Gcoeff(:)%j = (c(60)*M(7,:)%j) * den(3)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(283),h0tab(:,283),[16,3,12],[0,0,0],3,2,wf4(:,1),wf4(:,2))
  call Hloop_AV_Q(ntryL,G0H32(1),ex5(:),G0H16(1),m3h2x16(:,173),heltab2x32(:,:,277))
  call Hloop_A_Q(ntryL,G0H16(1),16,0,G1H16(12),n2h16(127))
  Gcoeff(:)%j = (c(59)*M(7,:)%j) * den(3)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(284),h0tab(:,284),[16,3,12],[nMB,nMB,nMB],3,2,wf4(:,1),wf4(:,2))
  call Hloop_AV_Q(ntryL,G0H32(1),ex5(:),G0H16(1),m3h2x16(:,174),heltab2x32(:,:,278))
  call Hloop_A_Q(ntryL,G0H16(1),16,nMB,G1H16(20),n2h16(128))
  Gcoeff(:)%j = (c(60)*M(7,:)%j) * den(3)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(285),h0tab(:,285),[16,3,12],[0,0,0],3,2,wf4(:,1),wf4(:,2))
  call Hloop_QV_A(ntryL,G0H32(1),ex5(:),G0H16(1),m3h2x16(:,175),heltab2x32(:,:,279))
  call Hloop_Q_A(ntryL,G0H16(1),16,0,G1H16(19),n2h16(129))
  Gcoeff(:)%j = (c(59)*M(7,:)%j) * den(3)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(286),h0tab(:,286),[16,3,12],[nMB,nMB,nMB],3,2,wf4(:,1),wf4(:,2))
  call Hloop_QV_A(ntryL,G0H32(1),ex5(:),G0H16(1),m3h2x16(:,176),heltab2x32(:,:,280))
  call Hloop_Q_A(ntryL,G0H16(1),16,nMB,G1H16(75),n2h16(130))
  Gcoeff(:)%j = (-(c(63)*M(7,:)%j)) * den(32)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(287),h0tab(:,287),[16,3,12],[0,0,0],3,2,wf4(:,7),wf4(:,2))
  call Hloop_AV_Q(ntryL,G0H32(1),ex5(:),G0H16(1),m3h2x16(:,177),heltab2x32(:,:,281))
  call Hloop_A_Q(ntryL,G0H16(1),16,0,G1H16(41),n2h16(131))
  Gcoeff(:)%j = (-(c(62)*M(7,:)%j)) * den(32)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(288),h0tab(:,288),[16,3,12],[nMT,nMT,nMT],3,2,wf4(:,7),wf4(:,2))
  call Hloop_AV_Q(ntryL,G0H32(1),ex5(:),G0H16(1),m3h2x16(:,178),heltab2x32(:,:,282))
  call Hloop_A_Q(ntryL,G0H16(1),16,nMT,G1H16(64),n2h16(132))
  Gcoeff(:)%j = (-(c(63)*M(7,:)%j)) * den(32)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(289),h0tab(:,289),[16,3,12],[0,0,0],3,2,wf4(:,7),wf4(:,2))
  call Hloop_QV_A(ntryL,G0H32(1),ex5(:),G0H16(1),m3h2x16(:,179),heltab2x32(:,:,283))
  call Hloop_Q_A(ntryL,G0H16(1),16,0,G1H16(63),n2h16(133))
  Gcoeff(:)%j = (-(c(62)*M(7,:)%j)) * den(32)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(290),h0tab(:,290),[16,3,12],[nMT,nMT,nMT],3,2,wf4(:,7),wf4(:,2))
  call Hloop_QV_A(ntryL,G0H32(1),ex5(:),G0H16(1),m3h2x16(:,180),heltab2x32(:,:,284))
  call Hloop_Q_A(ntryL,G0H16(1),16,nMT,G1H16(74),n2h16(134))
  Gcoeff(:)%j = (-(c(63)*M(7,:)%j)) * den(32)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(291),h0tab(:,291),[16,3,12],[0,0,0],3,2,wf4(:,7),wf4(:,2))
  call Hloop_AV_Q(ntryL,G0H32(1),ex5(:),G0H16(1),m3h2x16(:,181),heltab2x32(:,:,285))
  call Hloop_A_Q(ntryL,G0H16(1),16,0,G1H16(1),n2h16(135))
  Gcoeff(:)%j = (-(c(62)*M(7,:)%j)) * den(32)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(292),h0tab(:,292),[16,3,12],[nMB,nMB,nMB],3,2,wf4(:,7),wf4(:,2))
  call Hloop_AV_Q(ntryL,G0H32(1),ex5(:),G0H16(1),m3h2x16(:,182),heltab2x32(:,:,286))
  call Hloop_A_Q(ntryL,G0H16(1),16,nMB,G1H16(2),n2h16(136))
  Gcoeff(:)%j = (-(c(63)*M(7,:)%j)) * den(32)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(293),h0tab(:,293),[16,3,12],[0,0,0],3,2,wf4(:,7),wf4(:,2))
  call Hloop_QV_A(ntryL,G0H32(1),ex5(:),G0H16(1),m3h2x16(:,183),heltab2x32(:,:,287))
  call Hloop_Q_A(ntryL,G0H16(1),16,0,G1H16(3),n2h16(137))
  Gcoeff(:)%j = (-(c(62)*M(7,:)%j)) * den(32)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(294),h0tab(:,294),[16,3,12],[nMB,nMB,nMB],3,2,wf4(:,7),wf4(:,2))
  call Hloop_QV_A(ntryL,G0H32(1),ex5(:),G0H16(1),m3h2x16(:,184),heltab2x32(:,:,288))
  call Hloop_Q_A(ntryL,G0H16(1),16,nMB,G1H16(4),n2h16(138))
  Gcoeff(:)%j = (c(60)*M(1,:)%j) * den(3)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(295),h0tab(:,295),[16,3,12],[0,0,0],3,2,wf4(:,1),wf4(:,2))
  call Hloop_AV_Q(ntryL,G0H32(1),ex5(:),G0H16(1),m3h2x16(:,185),heltab2x32(:,:,289))
  call Hloop_A_Q(ntryL,G0H16(1),16,0,G1H16(9),n2h16(139))
  Gcoeff(:)%j = (c(59)*M(1,:)%j) * den(3)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(296),h0tab(:,296),[16,3,12],[nMT,nMT,nMT],3,2,wf4(:,1),wf4(:,2))
  call Hloop_AV_Q(ntryL,G0H32(1),ex5(:),G0H16(1),m3h2x16(:,186),heltab2x32(:,:,290))
  call Hloop_A_Q(ntryL,G0H16(1),16,nMT,G1H16(13),n2h16(140))
  Gcoeff(:)%j = (c(60)*M(1,:)%j) * den(3)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(297),h0tab(:,297),[16,3,12],[0,0,0],3,2,wf4(:,1),wf4(:,2))
  call Hloop_QV_A(ntryL,G0H32(1),ex5(:),G0H16(1),m3h2x16(:,187),heltab2x32(:,:,291))
  call Hloop_Q_A(ntryL,G0H16(1),16,0,G1H16(8),n2h16(141))
  Gcoeff(:)%j = (c(59)*M(1,:)%j) * den(3)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(298),h0tab(:,298),[16,3,12],[nMT,nMT,nMT],3,2,wf4(:,1),wf4(:,2))
  call Hloop_QV_A(ntryL,G0H32(1),ex5(:),G0H16(1),m3h2x16(:,188),heltab2x32(:,:,292))
  call Hloop_Q_A(ntryL,G0H16(1),16,nMT,G1H16(11),n2h16(142))
  Gcoeff(:)%j = (-(c(59)*M(1,:)%j)) * den(3)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(299),h0tab(:,299),[16,3,12],[0,0,0],3,2,wf4(:,1),wf4(:,2))
  call Hloop_AV_Q(ntryL,G0H32(1),ex5(:),G0H16(1),m3h2x16(:,189),heltab2x32(:,:,293))
  call Hloop_A_Q(ntryL,G0H16(1),16,0,G1H16(14),n2h16(143))
  Gcoeff(:)%j = (-(c(58)*M(1,:)%j)) * den(3)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(300),h0tab(:,300),[16,3,12],[nMB,nMB,nMB],3,2,wf4(:,1),wf4(:,2))
  call Hloop_AV_Q(ntryL,G0H32(1),ex5(:),G0H16(1),m3h2x16(:,190),heltab2x32(:,:,294))
  call Hloop_A_Q(ntryL,G0H16(1),16,nMB,G1H16(15),n2h16(144))
  Gcoeff(:)%j = (-(c(59)*M(1,:)%j)) * den(3)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(301),h0tab(:,301),[16,3,12],[0,0,0],3,2,wf4(:,1),wf4(:,2))
  call Hloop_QV_A(ntryL,G0H32(1),ex5(:),G0H16(1),m3h2x16(:,191),heltab2x32(:,:,295))
  call Hloop_Q_A(ntryL,G0H16(1),16,0,G1H16(16),n2h16(145))
  Gcoeff(:)%j = (-(c(58)*M(1,:)%j)) * den(3)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(302),h0tab(:,302),[16,3,12],[nMB,nMB,nMB],3,2,wf4(:,1),wf4(:,2))
  call Hloop_QV_A(ntryL,G0H32(1),ex5(:),G0H16(1),m3h2x16(:,192),heltab2x32(:,:,296))
  call Hloop_Q_A(ntryL,G0H16(1),16,nMB,G1H16(17),n2h16(146))
  Gcoeff(:)%j = (-(c(63)*M(1,:)%j)) * den(33)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(303),h0tab(:,303),[16,3,12],[0,0,0],3,2,wf4(:,1),wf4(:,20))
  call Hloop_AV_Q(ntryL,G0H32(1),ex5(:),G0H16(1),m3h2x16(:,193),heltab2x32(:,:,297))
  call Hloop_A_Q(ntryL,G0H16(1),16,0,G1H16(18),n2h16(147))
  Gcoeff(:)%j = (-(c(62)*M(1,:)%j)) * den(33)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(304),h0tab(:,304),[16,3,12],[nMT,nMT,nMT],3,2,wf4(:,1),wf4(:,20))
  call Hloop_AV_Q(ntryL,G0H32(1),ex5(:),G0H16(1),m3h2x16(:,194),heltab2x32(:,:,298))
  call Hloop_A_Q(ntryL,G0H16(1),16,nMT,G1H16(22),n2h16(148))
  Gcoeff(:)%j = (-(c(63)*M(1,:)%j)) * den(33)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(305),h0tab(:,305),[16,3,12],[0,0,0],3,2,wf4(:,1),wf4(:,20))
  call Hloop_QV_A(ntryL,G0H32(1),ex5(:),G0H16(1),m3h2x16(:,195),heltab2x32(:,:,299))
  call Hloop_Q_A(ntryL,G0H16(1),16,0,G1H16(21),n2h16(149))
  Gcoeff(:)%j = (-(c(62)*M(1,:)%j)) * den(33)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(306),h0tab(:,306),[16,3,12],[nMT,nMT,nMT],3,2,wf4(:,1),wf4(:,20))
  call Hloop_QV_A(ntryL,G0H32(1),ex5(:),G0H16(1),m3h2x16(:,196),heltab2x32(:,:,300))
  call Hloop_Q_A(ntryL,G0H16(1),16,nMT,G1H16(24),n2h16(150))
  Gcoeff(:)%j = (-(c(63)*M(1,:)%j)) * den(33)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(307),h0tab(:,307),[16,3,12],[0,0,0],3,2,wf4(:,1),wf4(:,20))
  call Hloop_AV_Q(ntryL,G0H32(1),ex5(:),G0H16(1),m3h2x16(:,197),heltab2x32(:,:,301))
  call Hloop_A_Q(ntryL,G0H16(1),16,0,G1H16(25),n2h16(151))
  Gcoeff(:)%j = (-(c(62)*M(1,:)%j)) * den(33)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(308),h0tab(:,308),[16,3,12],[nMB,nMB,nMB],3,2,wf4(:,1),wf4(:,20))
  call Hloop_AV_Q(ntryL,G0H32(1),ex5(:),G0H16(1),m3h2x16(:,198),heltab2x32(:,:,302))
  call Hloop_A_Q(ntryL,G0H16(1),16,nMB,G1H16(26),n2h16(152))
  Gcoeff(:)%j = (-(c(63)*M(1,:)%j)) * den(33)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(309),h0tab(:,309),[16,3,12],[0,0,0],3,2,wf4(:,1),wf4(:,20))
  call Hloop_QV_A(ntryL,G0H32(1),ex5(:),G0H16(1),m3h2x16(:,199),heltab2x32(:,:,303))
  call Hloop_Q_A(ntryL,G0H16(1),16,0,G1H16(27),n2h16(153))
  Gcoeff(:)%j = (-(c(62)*M(1,:)%j)) * den(33)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(310),h0tab(:,310),[16,3,12],[nMB,nMB,nMB],3,2,wf4(:,1),wf4(:,20))
  call Hloop_QV_A(ntryL,G0H32(1),ex5(:),G0H16(1),m3h2x16(:,200),heltab2x32(:,:,304))
  call Hloop_Q_A(ntryL,G0H16(1),16,nMB,G1H16(28),n2h16(154))
  Gcoeff(:)%j = (-(c(69)*M(6,:)%j)+c(68)*(M(2,:)%j+M(8,:)%j)) * den(3)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(311),h0tab(:,311),[16,3,12],[0,0,0],3,2,wf4(:,1),wf4(:,2))
  call Hloop_AV_Q(ntryL,G0H32(1),ex5(:),G0H16(1),m3h2x16(:,201),heltab2x32(:,:,305))
  call Hloop_A_Q(ntryL,G0H16(1),16,0,G1H16(29),n2h16(155))
  Gcoeff(:)%j = (-(c(67)*M(6,:)%j)+c(66)*(M(2,:)%j+M(8,:)%j)) * den(3)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(312),h0tab(:,312),[16,3,12],[nMT,nMT,nMT],3,2,wf4(:,1),wf4(:,2))
  call Hloop_AV_Q(ntryL,G0H32(1),ex5(:),G0H16(1),m3h2x16(:,202),heltab2x32(:,:,306))
  call Hloop_A_Q(ntryL,G0H16(1),16,nMT,G1H16(30),n2h16(156))
  Gcoeff(:)%j = (-(c(69)*M(4,:)%j)+c(68)*(M(2,:)%j+M(8,:)%j)) * den(3)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(313),h0tab(:,313),[16,3,12],[0,0,0],3,2,wf4(:,1),wf4(:,2))
  call Hloop_QV_A(ntryL,G0H32(1),ex5(:),G0H16(1),m3h2x16(:,203),heltab2x32(:,:,307))
  call Hloop_Q_A(ntryL,G0H16(1),16,0,G1H16(31),n2h16(157))
  Gcoeff(:)%j = (-(c(67)*M(4,:)%j)+c(66)*(M(2,:)%j+M(8,:)%j)) * den(3)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(314),h0tab(:,314),[16,3,12],[nMT,nMT,nMT],3,2,wf4(:,1),wf4(:,2))
  call Hloop_QV_A(ntryL,G0H32(1),ex5(:),G0H16(1),m3h2x16(:,204),heltab2x32(:,:,308))
  call Hloop_Q_A(ntryL,G0H16(1),16,nMT,G1H16(34),n2h16(158))
  Gcoeff(:)%j = (-(c(69)*M(6,:)%j)+c(68)*(M(2,:)%j+M(8,:)%j)) * den(3)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(315),h0tab(:,315),[16,3,12],[0,0,0],3,2,wf4(:,1),wf4(:,2))
  call Hloop_AV_Q(ntryL,G0H32(1),ex5(:),G0H16(1),m3h2x16(:,205),heltab2x32(:,:,309))
  call Hloop_A_Q(ntryL,G0H16(1),16,0,G1H16(33),n2h16(159))
  Gcoeff(:)%j = (-(c(67)*M(6,:)%j)+c(66)*(M(2,:)%j+M(8,:)%j)) * den(3)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(316),h0tab(:,316),[16,3,12],[nMB,nMB,nMB],3,2,wf4(:,1),wf4(:,2))
  call Hloop_AV_Q(ntryL,G0H32(1),ex5(:),G0H16(1),m3h2x16(:,206),heltab2x32(:,:,310))
  call Hloop_A_Q(ntryL,G0H16(1),16,nMB,G1H16(35),n2h16(160))
  Gcoeff(:)%j = (-(c(69)*M(4,:)%j)+c(68)*(M(2,:)%j+M(8,:)%j)) * den(3)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(317),h0tab(:,317),[16,3,12],[0,0,0],3,2,wf4(:,1),wf4(:,2))
  call Hloop_QV_A(ntryL,G0H32(1),ex5(:),G0H16(1),m3h2x16(:,207),heltab2x32(:,:,311))
  call Hloop_Q_A(ntryL,G0H16(1),16,0,G1H16(36),n2h16(161))
  Gcoeff(:)%j = (-(c(67)*M(4,:)%j)+c(66)*(M(2,:)%j+M(8,:)%j)) * den(3)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(318),h0tab(:,318),[16,3,12],[nMB,nMB,nMB],3,2,wf4(:,1),wf4(:,2))
  call Hloop_QV_A(ntryL,G0H32(1),ex5(:),G0H16(1),m3h2x16(:,208),heltab2x32(:,:,312))
  call Hloop_Q_A(ntryL,G0H16(1),16,nMB,G1H16(37),n2h16(162))
  Gcoeff(:)%j = (c(22)*(-M(4,:)%j+M(6,:)%j)) * den(3)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(319),h0tab(:,319),[16,3,12],[0,0,0],3,2,wf4(:,1),wf4(:,2))
  call Hloop_DV_C(ntryL,G0H32(1),0,ex5(:),G1H16(38),m3h2x16(:,209),heltab2x32(:,:,313))
  Gcoeff(:)%j = (c(22)*(M(4,:)%j-M(6,:)%j)) * den(3)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(320),h0tab(:,320),[16,3,12],[0,0,0],3,2,wf4(:,1),wf4(:,2))
  call Hloop_CV_D(ntryL,G0H32(1),0,ex5(:),16,G1H16(39),m3h2x16(:,210),heltab2x32(:,:,314))
  Gcoeff(:)%j = (c(22)*(M(4,:)%j-M(6,:)%j)) * den(3)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(321),h0tab(:,321),[16,3,12],[0,0,0],3,2,wf4(:,1),wf4(:,2))
  call Hloop_UV_W(ntryL,G0H32(1),0,ex5(:),16,G1H16(40),m3h2x16(:,211),heltab2x32(:,:,315))
  Gcoeff(:)%j = (-(c(54)*M(7,:)%j)) * den(6)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(322),h0tab(:,322),[20,3,8],[nMB,nMB,0],3,2,wf4(:,5),wf4(:,3))
  call Hloop_VQ_A(ntryL,G0H32(1),wf4(:,5),G0H8(53),m3h4x8(:,105),heltab2x32(:,:,316))
  call Hloop_Q_A(ntryL,G0H8(53),20,nMB,G1H8(60),n2h8(103))
  Gcoeff(:)%j = (-(c(54)*M(7,:)%j)) * den(8)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(323),h0tab(:,323),[20,3,8],[nMB,nMB,0],3,2,wf4(:,5),wf4(:,6))
  call Hloop_VQ_A(ntryL,G0H32(1),wf4(:,5),G0H8(18),m3h4x8(:,106),heltab2x32(:,:,317))
  call Hloop_Q_A(ntryL,G0H8(18),20,nMB,G1H8(61),n2h8(104))
  Gcoeff(:)%j = (-(c(49)*M(3,:)%j)+c(48)*M(7,:)%j) * den(9)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(324),h0tab(:,324),[20,3,8],[nMB,nMB,nMH],3,2,wf4(:,5),wf4(:,1))
  call Hloop_SQ_A(ntryL,G0H32(1),wf4(:,5),G0H8(17),ngH,m3h4x8(:,107),heltab2x32(:,:,318))
  call Hloop_Q_A(ntryL,G0H8(17),20,nMB,G1H8(62),n2h8(105))
  Gcoeff(:)%j = (c(49)*M(3,:)%j-c(48)*M(7,:)%j) * den(9)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(325),h0tab(:,325),[20,3,8],[nMB,nMB,nMZ],3,2,wf4(:,5),wf4(:,1))
  call Hloop_SQ_A(ntryL,G0H32(1),wf4(:,5),G0H8(27),ngX,m3h4x8(:,108),heltab2x32(:,:,319))
  call Hloop_Q_A(ntryL,G0H8(27),20,nMB,G1H8(63),n2h8(106))
  Gcoeff(:)%j = (c(45)*M(3,:)%j-c(44)*M(7,:)%j) * den(9)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(326),h0tab(:,326),[20,3,8],[nMT,nMT,nMW],3,2,wf4(:,5),wf4(:,1))
  call Hloop_SQ_A(ntryL,G0H32(1),wf4(:,5),G0H8(26),ngPtb,m3h4x8(:,109),heltab2x32(:,:,320))
  call Hloop_Q_A(ntryL,G0H8(26),20,nMT,G1H8(64),n2h8(107))
  Gcoeff(:)%j = (-(c(11)*M(7,:)%j)) * den(9)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(327),h0tab(:,327),[20,3,8],[nMB,nMB,0],3,2,wf4(:,5),wf4(:,1))
  call Hloop_VQ_A(ntryL,G0H32(1),wf4(:,5),G0H8(40),m3h4x8(:,110),heltab2x32(:,:,321))
  call Hloop_Q_A(ntryL,G0H8(40),20,nMB,G1H8(65),n2h8(108))
  Gcoeff(:)%j = (c(16)*M(7,:)%j) * den(8)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(328),h0tab(:,328),[20,3,8],[nMB,nMB,0],3,2,wf4(:,5),wf4(:,7))
  call Hloop_VQ_A(ntryL,G0H32(1),wf4(:,5),G0H8(39),m3h4x8(:,111),heltab2x32(:,:,322))
  call Hloop_Q_A(ntryL,G0H8(39),20,nMB,G1H8(66),n2h8(109))
  Gcoeff(:)%j = (c(8)*M(3,:)%j-c(7)*M(7,:)%j) * den(9)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(329),h0tab(:,329),[20,3,8],[nMB,nMB,0],3,2,wf4(:,5),wf4(:,1))
  call Hloop_VQ_A(ntryL,G0H32(1),wf4(:,5),G0H8(49),m3h4x8(:,112),heltab2x32(:,:,323))
  call Hloop_Q_A(ntryL,G0H8(49),20,nMB,G1H8(67),n2h8(110))
  Gcoeff(:)%j = (c(15)*M(3,:)%j-c(14)*M(7,:)%j) * den(9)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(330),h0tab(:,330),[20,3,8],[nMB,nMB,nMZ],3,2,wf4(:,5),wf4(:,1))
  call Hloop_ZQ_A(ntryL,G0H32(1),wf4(:,5),G0H8(48),ngZd,m3h4x8(:,113),heltab2x32(:,:,324))
  call Hloop_Q_A(ntryL,G0H8(48),20,nMB,G1H8(68),n2h8(111))
  Gcoeff(:)%j = (c(40)*M(3,:)%j-c(39)*M(7,:)%j) * den(9)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(331),h0tab(:,331),[20,3,8],[nMT,nMT,nMW],3,2,wf4(:,5),wf4(:,1))
  call Hloop_WQ_A(ntryL,G0H32(1),wf4(:,5),G0H8(1),m3h4x8(:,114),heltab2x32(:,:,325))
  call Hloop_Q_A(ntryL,G0H8(1),20,nMT,G1H8(69),n2h8(112))
  Gcoeff(:)%j = (-(c(27)*M(4,:)%j)+c(26)*M(8,:)%j) * den(9)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(332),h0tab(:,332),[20,3,8],[nMB,nMB,0],3,2,wf4(:,5),wf4(:,1))
  call Hloop_VQ_A(ntryL,G0H32(1),wf4(:,5),G0H8(2),m3h4x8(:,115),heltab2x32(:,:,326))
  call Hloop_Q_A(ntryL,G0H8(2),20,nMB,G1H8(70),n2h8(113))
  Gcoeff(:)%j = (c(22)*M(4,:)%j-c(20)*M(8,:)%j) * den(9)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(333),h0tab(:,333),[20,3,8],[0,0,nMB],3,2,wf4(:,5),wf4(:,1))
  call Hloop_AQ_V(ntryL,G0H32(1),wf4(:,5),G0H8(3),m3h4x8(:,116),heltab2x32(:,:,327))
  Gcoeff(:)%j = (-(c(54)*M(7,:)%j)) * den(11)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(334),h0tab(:,334),[24,3,4],[nMB,nMB,0],3,2,wf4(:,9),wf4(:,3))
  call Hloop_VA_Q(ntryL,G0H32(1),wf4(:,9),G0H8(4),m3h4x8(:,117),heltab2x32(:,:,328))
  call Hloop_A_Q(ntryL,G0H8(4),24,nMB,G1H8(71),n2h8(114))
  Gcoeff(:)%j = (-(c(54)*M(7,:)%j)) * den(12)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(335),h0tab(:,335),[24,3,4],[nMB,nMB,0],3,2,wf4(:,9),wf4(:,6))
  call Hloop_VA_Q(ntryL,G0H32(1),wf4(:,9),G0H8(5),m3h4x8(:,118),heltab2x32(:,:,329))
  call Hloop_A_Q(ntryL,G0H8(5),24,nMB,G1H8(45),n2h8(115))
  Gcoeff(:)%j = (-(c(49)*M(5,:)%j)+c(48)*M(7,:)%j) * den(13)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(336),h0tab(:,336),[24,3,4],[nMB,nMB,nMH],3,2,wf4(:,9),wf4(:,1))
  call Hloop_SA_Q(ntryL,G0H32(1),wf4(:,9),G0H8(6),ngH,m3h4x8(:,119),heltab2x32(:,:,330))
  call Hloop_A_Q(ntryL,G0H8(6),24,nMB,G1H8(2),n2h8(116))
  Gcoeff(:)%j = (c(49)*M(5,:)%j-c(48)*M(7,:)%j) * den(13)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(337),h0tab(:,337),[24,3,4],[nMB,nMB,nMZ],3,2,wf4(:,9),wf4(:,1))
  call Hloop_SA_Q(ntryL,G0H32(1),wf4(:,9),G0H8(7),ngX,m3h4x8(:,120),heltab2x32(:,:,331))
  call Hloop_A_Q(ntryL,G0H8(7),24,nMB,G1H8(3),n2h8(117))
  Gcoeff(:)%j = (c(45)*M(5,:)%j-c(44)*M(7,:)%j) * den(13)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(338),h0tab(:,338),[24,3,4],[nMT,nMT,nMW],3,2,wf4(:,9),wf4(:,1))
  call Hloop_SA_Q(ntryL,G0H32(1),wf4(:,9),G0H8(8),ngPbt,m3h4x8(:,121),heltab2x32(:,:,332))
  call Hloop_A_Q(ntryL,G0H8(8),24,nMT,G1H8(8),n2h8(118))
  Gcoeff(:)%j = (-(c(11)*M(7,:)%j)) * den(13)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(339),h0tab(:,339),[24,3,4],[nMB,nMB,0],3,2,wf4(:,9),wf4(:,1))
  call Hloop_VA_Q(ntryL,G0H32(1),wf4(:,9),G0H8(9),m3h4x8(:,122),heltab2x32(:,:,333))
  call Hloop_A_Q(ntryL,G0H8(9),24,nMB,G1H8(6),n2h8(119))
  Gcoeff(:)%j = (c(16)*M(7,:)%j) * den(12)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(340),h0tab(:,340),[24,3,4],[nMB,nMB,0],3,2,wf4(:,9),wf4(:,7))
  call Hloop_VA_Q(ntryL,G0H32(1),wf4(:,9),G0H8(10),m3h4x8(:,123),heltab2x32(:,:,334))
  call Hloop_A_Q(ntryL,G0H8(10),24,nMB,G1H8(9),n2h8(120))
  Gcoeff(:)%j = (c(8)*M(5,:)%j-c(7)*M(7,:)%j) * den(13)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(341),h0tab(:,341),[24,3,4],[nMB,nMB,0],3,2,wf4(:,9),wf4(:,1))
  call Hloop_VA_Q(ntryL,G0H32(1),wf4(:,9),G0H8(11),m3h4x8(:,124),heltab2x32(:,:,335))
  call Hloop_A_Q(ntryL,G0H8(11),24,nMB,G1H8(10),n2h8(121))
  Gcoeff(:)%j = (c(15)*M(5,:)%j-c(14)*M(7,:)%j) * den(13)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(342),h0tab(:,342),[24,3,4],[nMB,nMB,nMZ],3,2,wf4(:,9),wf4(:,1))
  call Hloop_ZA_Q(ntryL,G0H32(1),wf4(:,9),G0H8(12),ngZd,m3h4x8(:,125),heltab2x32(:,:,336))
  call Hloop_A_Q(ntryL,G0H8(12),24,nMB,G1H8(11),n2h8(122))
  Gcoeff(:)%j = (c(40)*M(5,:)%j-c(39)*M(7,:)%j) * den(13)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(343),h0tab(:,343),[24,3,4],[nMT,nMT,nMW],3,2,wf4(:,9),wf4(:,1))
  call Hloop_WA_Q(ntryL,G0H32(1),wf4(:,9),G0H8(13),m3h4x8(:,126),heltab2x32(:,:,337))
  call Hloop_A_Q(ntryL,G0H8(13),24,nMT,G1H8(12),n2h8(123))
  Gcoeff(:)%j = (-(c(27)*M(6,:)%j)+c(26)*M(8,:)%j) * den(13)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(344),h0tab(:,344),[24,3,4],[nMB,nMB,0],3,2,wf4(:,9),wf4(:,1))
  call Hloop_VA_Q(ntryL,G0H32(1),wf4(:,9),G0H8(14),m3h4x8(:,127),heltab2x32(:,:,338))
  call Hloop_A_Q(ntryL,G0H8(14),24,nMB,G1H8(15),n2h8(124))
  Gcoeff(:)%j = (-(c(22)*M(6,:)%j)+c(20)*M(8,:)%j) * den(13)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(345),h0tab(:,345),[24,3,4],[0,0,nMB],3,2,wf4(:,9),wf4(:,1))
  call Hloop_QA_V(ntryL,G0H32(1),wf4(:,9),G0H8(15),m3h4x8(:,128),heltab2x32(:,:,339))
  Gcoeff(:)%j = (c(52)*M(7,:)%j) * den(52)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(346),h0tab(:,346),[16,7,8],[nMB,0,nMB],3,1,wf8(:,96))
  call Hloop_AV_Q(ntryL,G0H32(1),ex5(:),G0H16(1),m3h2x16(:,212),heltab2x32(:,:,340))
  call Hloop_A_Q(ntryL,G0H16(1),16,nMB,G1H16(43),n2h16(163))
  Gcoeff(:)%j = (c(52)*M(7,:)%j) * den(54)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(347),h0tab(:,347),[16,7,8],[nMB,0,nMB],3,1,wf8(:,97))
  call Hloop_AV_Q(ntryL,G0H32(1),ex5(:),G0H16(1),m3h2x16(:,213),heltab2x32(:,:,341))
  call Hloop_A_Q(ntryL,G0H16(1),16,nMB,G1H16(49),n2h16(164))
  Gcoeff(:)%j = (c(51)*M(7,:)%j) * den(52)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(348),h0tab(:,348),[16,7,8],[0,nMB,0],3,1,wf8(:,96))
  call Hloop_UV_W(ntryL,G0H32(1),0,ex5(:),16,G1H16(44),m3h2x16(:,214),heltab2x32(:,:,342))
  Gcoeff(:)%j = (c(51)*M(7,:)%j) * den(54)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(349),h0tab(:,349),[16,7,8],[0,nMB,0],3,1,wf8(:,97))
  call Hloop_UV_W(ntryL,G0H32(1),0,ex5(:),16,G1H16(48),m3h2x16(:,215),heltab2x32(:,:,343))
  Gcoeff(:)%j = (-(c(49)*M(5,:)%j)+c(48)*M(7,:)%j) * den(56)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(350),h0tab(:,350),[16,7,8],[nMB,nMH,nMB],3,1,wf8(:,98))
  call Hloop_AV_Q(ntryL,G0H32(1),ex5(:),G0H16(1),m3h2x16(:,216),heltab2x32(:,:,344))
  call Hloop_A_Q(ntryL,G0H16(1),16,nMB,G1H16(47),n2h16(165))
  Gcoeff(:)%j = (c(49)*M(5,:)%j-c(48)*M(7,:)%j) * den(56)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(351),h0tab(:,351),[16,7,8],[nMB,nMZ,nMB],3,1,wf8(:,98))
  call Hloop_AV_Q(ntryL,G0H32(1),ex5(:),G0H16(1),m3h2x16(:,217),heltab2x32(:,:,345))
  call Hloop_A_Q(ntryL,G0H16(1),16,nMB,G1H16(50),n2h16(166))
  Gcoeff(:)%j = (c(45)*M(5,:)%j-c(44)*M(7,:)%j) * den(56)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(352),h0tab(:,352),[16,7,8],[nMT,nMW,nMT],3,1,wf8(:,98))
  call Hloop_AV_Q(ntryL,G0H32(1),ex5(:),G0H16(1),m3h2x16(:,218),heltab2x32(:,:,346))
  call Hloop_A_Q(ntryL,G0H16(1),16,nMT,G1H16(51),n2h16(167))
  Gcoeff(:)%j = (c(9)*M(7,:)%j) * den(56)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(353),h0tab(:,353),[16,7,8],[nMB,0,nMB],3,1,wf8(:,98))
  call Hloop_AV_Q(ntryL,G0H32(1),ex5(:),G0H16(1),m3h2x16(:,219),heltab2x32(:,:,347))
  call Hloop_A_Q(ntryL,G0H16(1),16,nMB,G1H16(52),n2h16(168))
  Gcoeff(:)%j = (-(c(14)*M(7,:)%j)) * den(54)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(354),h0tab(:,354),[16,7,8],[nMB,0,nMB],3,1,wf8(:,99))
  call Hloop_AV_Q(ntryL,G0H32(1),ex5(:),G0H16(1),m3h2x16(:,220),heltab2x32(:,:,348))
  call Hloop_A_Q(ntryL,G0H16(1),16,nMB,G1H16(53),n2h16(169))
  Gcoeff(:)%j = (c(8)*M(5,:)%j-c(7)*M(7,:)%j) * den(56)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(355),h0tab(:,355),[16,7,8],[nMB,0,nMB],3,1,wf8(:,98))
  call Hloop_AV_Q(ntryL,G0H32(1),ex5(:),G0H16(1),m3h2x16(:,221),heltab2x32(:,:,349))
  call Hloop_A_Q(ntryL,G0H16(1),16,nMB,G1H16(54),n2h16(170))
  Gcoeff(:)%j = (c(15)*M(5,:)%j-c(14)*M(7,:)%j) * den(56)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(356),h0tab(:,356),[16,7,8],[nMB,nMZ,nMB],3,1,wf8(:,98))
  call Hloop_AV_Q(ntryL,G0H32(1),ex5(:),G0H16(1),m3h2x16(:,222),heltab2x32(:,:,350))
  call Hloop_A_Q(ntryL,G0H16(1),16,nMB,G1H16(55),n2h16(171))
  Gcoeff(:)%j = (c(40)*M(5,:)%j-c(39)*M(7,:)%j) * den(56)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(357),h0tab(:,357),[16,7,8],[nMT,nMW,nMT],3,1,wf8(:,98))
  call Hloop_AV_Q(ntryL,G0H32(1),ex5(:),G0H16(1),m3h2x16(:,223),heltab2x32(:,:,351))
  call Hloop_A_Q(ntryL,G0H16(1),16,nMT,G1H16(61),n2h16(172))
  Gcoeff(:)%j = (-(c(27)*M(6,:)%j)+c(26)*M(8,:)%j) * den(56)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(358),h0tab(:,358),[16,7,8],[nMB,0,nMB],3,1,wf8(:,98))
  call Hloop_AV_Q(ntryL,G0H32(1),ex5(:),G0H16(1),m3h2x16(:,224),heltab2x32(:,:,352))
  call Hloop_A_Q(ntryL,G0H16(1),16,nMB,G1H16(57),n2h16(173))
  Gcoeff(:)%j = (c(3)*M(7,:)%j) * den(56)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(359),h0tab(:,359),[16,7,8],[0,nMB,0],3,1,wf8(:,98))
  call Hloop_UV_W(ntryL,G0H32(1),0,ex5(:),16,G1H16(59),m3h2x16(:,225),heltab2x32(:,:,353))
  Gcoeff(:)%j = (-(c(6)*M(7,:)%j)) * den(54)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(360),h0tab(:,360),[16,7,8],[0,nMB,0],3,1,wf8(:,99))
  call Hloop_UV_W(ntryL,G0H32(1),0,ex5(:),16,G1H16(60),m3h2x16(:,226),heltab2x32(:,:,354))
  Gcoeff(:)%j = (-(c(22)*M(6,:)%j)+c(20)*M(8,:)%j) * den(56)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(361),h0tab(:,361),[16,7,8],[0,nMB,0],3,1,wf8(:,98))
  call Hloop_UV_W(ntryL,G0H32(1),0,ex5(:),16,G1H16(62),m3h2x16(:,227),heltab2x32(:,:,355))
  Gcoeff(:)%j = (c(52)*M(7,:)%j) * den(43)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(362),h0tab(:,362),[16,4,11],[nMB,0,nMB],3,1,wf8(:,91))
  call Hloop_AV_Q(ntryL,G0H32(1),ex5(:),G0H16(1),m3h2x16(:,228),heltab2x32(:,:,356))
  call Hloop_A_Q(ntryL,G0H16(1),16,nMB,G1H16(67),n2h16(174))
  Gcoeff(:)%j = (c(52)*M(7,:)%j) * den(45)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(363),h0tab(:,363),[16,4,11],[nMB,0,nMB],3,1,wf8(:,92))
  call Hloop_AV_Q(ntryL,G0H32(1),ex5(:),G0H16(1),m3h2x16(:,229),heltab2x32(:,:,357))
  call Hloop_A_Q(ntryL,G0H16(1),16,nMB,G1H16(65),n2h16(175))
  Gcoeff(:)%j = (c(51)*M(7,:)%j) * den(43)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(364),h0tab(:,364),[16,4,11],[0,nMB,0],3,1,wf8(:,91))
  call Hloop_UV_W(ntryL,G0H32(1),0,ex5(:),16,G1H16(66),m3h2x16(:,230),heltab2x32(:,:,358))
  Gcoeff(:)%j = (c(51)*M(7,:)%j) * den(45)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(365),h0tab(:,365),[16,4,11],[0,nMB,0],3,1,wf8(:,92))
  call Hloop_UV_W(ntryL,G0H32(1),0,ex5(:),16,G1H16(70),m3h2x16(:,231),heltab2x32(:,:,359))
  Gcoeff(:)%j = (-(c(49)*M(3,:)%j)+c(48)*M(7,:)%j) * den(47)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(366),h0tab(:,366),[16,4,11],[nMB,nMH,nMB],3,1,wf8(:,93))
  call Hloop_AV_Q(ntryL,G0H32(1),ex5(:),G0H16(1),m3h2x16(:,232),heltab2x32(:,:,360))
  call Hloop_A_Q(ntryL,G0H16(1),16,nMB,G1H16(69),n2h16(176))
  Gcoeff(:)%j = (c(49)*M(3,:)%j-c(48)*M(7,:)%j) * den(47)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(367),h0tab(:,367),[16,4,11],[nMB,nMZ,nMB],3,1,wf8(:,93))
  call Hloop_AV_Q(ntryL,G0H32(1),ex5(:),G0H16(1),m3h2x16(:,233),heltab2x32(:,:,361))
  call Hloop_A_Q(ntryL,G0H16(1),16,nMB,G1H16(81),n2h16(177))
  Gcoeff(:)%j = (c(45)*M(3,:)%j-c(44)*M(7,:)%j) * den(47)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(368),h0tab(:,368),[16,4,11],[nMT,nMW,nMT],3,1,wf8(:,93))
  call Hloop_AV_Q(ntryL,G0H32(1),ex5(:),G0H16(1),m3h2x16(:,234),heltab2x32(:,:,362))
  call Hloop_A_Q(ntryL,G0H16(1),16,nMT,G1H16(82),n2h16(178))
  Gcoeff(:)%j = (c(9)*M(7,:)%j) * den(47)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(369),h0tab(:,369),[16,4,11],[nMB,0,nMB],3,1,wf8(:,93))
  call Hloop_AV_Q(ntryL,G0H32(1),ex5(:),G0H16(1),m3h2x16(:,235),heltab2x32(:,:,363))
  call Hloop_A_Q(ntryL,G0H16(1),16,nMB,G1H16(83),n2h16(179))
  Gcoeff(:)%j = (-(c(14)*M(7,:)%j)) * den(45)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(370),h0tab(:,370),[16,4,11],[nMB,0,nMB],3,1,wf8(:,94))
  call Hloop_AV_Q(ntryL,G0H32(1),ex5(:),G0H16(1),m3h2x16(:,236),heltab2x32(:,:,364))
  call Hloop_A_Q(ntryL,G0H16(1),16,nMB,G1H16(84),n2h16(180))
  Gcoeff(:)%j = (c(8)*M(3,:)%j-c(7)*M(7,:)%j) * den(47)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(371),h0tab(:,371),[16,4,11],[nMB,0,nMB],3,1,wf8(:,93))
  call Hloop_AV_Q(ntryL,G0H32(1),ex5(:),G0H16(1),m3h2x16(:,237),heltab2x32(:,:,365))
  call Hloop_A_Q(ntryL,G0H16(1),16,nMB,G1H16(85),n2h16(181))
  Gcoeff(:)%j = (c(15)*M(3,:)%j-c(14)*M(7,:)%j) * den(47)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(372),h0tab(:,372),[16,4,11],[nMB,nMZ,nMB],3,1,wf8(:,93))
  call Hloop_AV_Q(ntryL,G0H32(1),ex5(:),G0H16(1),m3h2x16(:,238),heltab2x32(:,:,366))
  call Hloop_A_Q(ntryL,G0H16(1),16,nMB,G1H16(86),n2h16(182))
  Gcoeff(:)%j = (c(40)*M(3,:)%j-c(39)*M(7,:)%j) * den(47)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(373),h0tab(:,373),[16,4,11],[nMT,nMW,nMT],3,1,wf8(:,93))
  call Hloop_AV_Q(ntryL,G0H32(1),ex5(:),G0H16(1),m3h2x16(:,239),heltab2x32(:,:,367))
  call Hloop_A_Q(ntryL,G0H16(1),16,nMT,G1H16(87),n2h16(183))
  Gcoeff(:)%j = (-(c(27)*M(4,:)%j)+c(26)*M(8,:)%j) * den(47)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(374),h0tab(:,374),[16,4,11],[nMB,0,nMB],3,1,wf8(:,93))
  call Hloop_AV_Q(ntryL,G0H32(1),ex5(:),G0H16(1),m3h2x16(:,240),heltab2x32(:,:,368))
  call Hloop_A_Q(ntryL,G0H16(1),16,nMB,G1H16(88),n2h16(184))
  Gcoeff(:)%j = (c(3)*M(7,:)%j) * den(47)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(375),h0tab(:,375),[16,4,11],[0,nMB,0],3,1,wf8(:,93))
  call Hloop_UV_W(ntryL,G0H32(1),0,ex5(:),16,G1H16(89),m3h2x16(:,241),heltab2x32(:,:,369))
  Gcoeff(:)%j = (-(c(6)*M(7,:)%j)) * den(45)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(376),h0tab(:,376),[16,4,11],[0,nMB,0],3,1,wf8(:,94))
  call Hloop_UV_W(ntryL,G0H32(1),0,ex5(:),16,G1H16(90),m3h2x16(:,242),heltab2x32(:,:,370))
  Gcoeff(:)%j = (-(c(22)*M(4,:)%j)+c(20)*M(8,:)%j) * den(47)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(377),h0tab(:,377),[16,4,11],[0,nMB,0],3,1,wf8(:,93))
  call Hloop_UV_W(ntryL,G0H32(1),0,ex5(:),16,G1H16(91),m3h2x16(:,243),heltab2x32(:,:,371))
  Gcoeff(:)%j = (c(47)*(M(3,:)%j-M(5,:)%j)) * den(38)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(378),h0tab(:,378),[19,4,8],[nMB,nMH,nMB],3,1,wf8(:,1))
  call Hloop_AV_Q(ntryL,G0H32(1),wf8(:,1),G0H4(7),m3h8x4(:,1),heltab2x32(:,:,372))
  call Hloop_A_Q(ntryL,G0H4(7),19,nMB,G1H4(144),n2h4(159))
  Gcoeff(:)%j = (c(47)*(-M(3,:)%j+M(5,:)%j)) * den(38)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(379),h0tab(:,379),[19,4,8],[nMB,nMZ,nMB],3,1,wf8(:,1))
  call Hloop_AV_Q(ntryL,G0H32(1),wf8(:,1),G0H4(7),m3h8x4(:,2),heltab2x32(:,:,373))
  call Hloop_A_Q(ntryL,G0H4(7),19,nMB,G1H4(1),n2h4(160))
  Gcoeff(:)%j = (c(42)*(-M(3,:)%j+M(5,:)%j)) * den(38)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(380),h0tab(:,380),[19,4,8],[nMT,nMW,nMT],3,1,wf8(:,1))
  call Hloop_AV_Q(ntryL,G0H32(1),wf8(:,1),G0H4(7),m3h8x4(:,3),heltab2x32(:,:,374))
  call Hloop_A_Q(ntryL,G0H4(7),19,nMT,G1H4(2),n2h4(161))
  Gcoeff(:)%j = (c(1)*(-M(3,:)%j+M(5,:)%j)) * den(38)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(381),h0tab(:,381),[19,4,8],[nMB,0,nMB],3,1,wf8(:,1))
  call Hloop_AV_Q(ntryL,G0H32(1),wf8(:,1),G0H4(7),m3h8x4(:,4),heltab2x32(:,:,375))
  call Hloop_A_Q(ntryL,G0H4(7),19,nMB,G1H4(5),n2h4(162))
  Gcoeff(:)%j = (c(5)*(-M(3,:)%j+M(5,:)%j)) * den(38)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(382),h0tab(:,382),[19,4,8],[nMB,nMZ,nMB],3,1,wf8(:,1))
  call Hloop_AV_Q(ntryL,G0H32(1),wf8(:,1),G0H4(7),m3h8x4(:,5),heltab2x32(:,:,376))
  call Hloop_A_Q(ntryL,G0H4(7),19,nMB,G1H4(6),n2h4(163))
  Gcoeff(:)%j = (c(37)*(-M(3,:)%j+M(5,:)%j)) * den(38)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(383),h0tab(:,383),[19,4,8],[nMT,nMW,nMT],3,1,wf8(:,1))
  call Hloop_AV_Q(ntryL,G0H32(1),wf8(:,1),G0H4(7),m3h8x4(:,6),heltab2x32(:,:,377))
  call Hloop_A_Q(ntryL,G0H4(7),19,nMT,G1H4(8),n2h4(164))
  Gcoeff(:)%j = (c(19)*(M(4,:)%j-M(6,:)%j)) * den(38)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(384),h0tab(:,384),[19,4,8],[nMB,0,nMB],3,1,wf8(:,1))
  call Hloop_AV_Q(ntryL,G0H32(1),wf8(:,1),G0H4(7),m3h8x4(:,7),heltab2x32(:,:,378))
  call Hloop_A_Q(ntryL,G0H4(7),19,nMB,G1H4(11),n2h4(165))
  Gcoeff(:)%j = (c(35)*(M(4,:)%j-M(6,:)%j)) * den(38)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(385),h0tab(:,385),[19,4,8],[0,nMB,0],3,1,wf8(:,1))
  call Hloop_UV_W(ntryL,G0H32(1),0,wf8(:,1),19,G1H4(12),m3h8x4(:,8),heltab2x32(:,:,379))
  Gcoeff(:)%j = (-(c(46)*M(5,:)%j)) * den(16)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(386),h0tab(:,386),[17,6,8],[nMT,nMB,0],3,2,wf4(:,12),wf4(:,11))
  call Hloop_VQ_A(ntryL,G0H32(1),wf4(:,12),G0H8(16),m3h4x8(:,129),heltab2x32(:,:,380))
  call Hloop_Q_A(ntryL,G0H8(16),17,nMT,G1H8(16),n2h8(125))
  Gcoeff(:)%j = (-(c(41)*M(5,:)%j)) * den(16)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(387),h0tab(:,387),[17,6,8],[nMT,nMB,0],3,2,wf4(:,12),wf4(:,13))
  call Hloop_VQ_A(ntryL,G0H32(1),wf4(:,12),G0H8(21),m3h4x8(:,130),heltab2x32(:,:,381))
  call Hloop_Q_A(ntryL,G0H8(21),17,nMT,G1H8(18),n2h8(126))
  Gcoeff(:)%j = (-(c(46)*M(5,:)%j)) * den(17)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(388),h0tab(:,388),[24,1,6],[0,nMT,nMB],3,2,wf4(:,9),wf4(:,11))
  call Hloop_QA_V(ntryL,G0H32(1),wf4(:,9),G0H8(19),m3h4x8(:,131),heltab2x32(:,:,382))
  Gcoeff(:)%j = (-(c(41)*M(5,:)%j)) * den(17)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(389),h0tab(:,389),[24,1,6],[0,nMT,nMB],3,2,wf4(:,9),wf4(:,13))
  call Hloop_QA_V(ntryL,G0H32(1),wf4(:,9),G0H8(20),m3h4x8(:,132),heltab2x32(:,:,383))
  Gcoeff(:)%j = (c(44)*M(5,:)%j) * den(61)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(390),h0tab(:,390),[16,7,8],[nMB,0,nMB],3,1,wf8(:,104))
  call Hloop_AV_Q(ntryL,G0H32(1),ex5(:),G0H16(1),m3h2x16(:,244),heltab2x32(:,:,384))
  call Hloop_A_Q(ntryL,G0H16(1),16,nMB,G1H16(92),n2h16(185))
  Gcoeff(:)%j = (c(43)*M(5,:)%j) * den(61)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(391),h0tab(:,391),[16,7,8],[0,nMB,0],3,1,wf8(:,104))
  call Hloop_UV_W(ntryL,G0H32(1),0,ex5(:),16,G1H16(93),m3h2x16(:,245),heltab2x32(:,:,385))
  Gcoeff(:)%j = (c(39)*M(5,:)%j) * den(61)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(392),h0tab(:,392),[16,7,8],[nMB,0,nMB],3,1,wf8(:,105))
  call Hloop_AV_Q(ntryL,G0H32(1),ex5(:),G0H16(1),m3h2x16(:,246),heltab2x32(:,:,386))
  call Hloop_A_Q(ntryL,G0H16(1),16,nMB,G1H16(94),n2h16(186))
  Gcoeff(:)%j = (c(38)*M(5,:)%j) * den(61)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(393),h0tab(:,393),[16,7,8],[0,nMB,0],3,1,wf8(:,105))
  call Hloop_UV_W(ntryL,G0H32(1),0,ex5(:),16,G1H16(95),m3h2x16(:,247),heltab2x32(:,:,387))
  Gcoeff(:)%j = (c(44)*M(5,:)%j) * den(59)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(394),h0tab(:,394),[16,1,14],[nMT,0,nMT],3,1,wf8(:,101))
  call Hloop_AV_Q(ntryL,G0H32(1),ex5(:),G0H16(1),m3h2x16(:,248),heltab2x32(:,:,388))
  call Hloop_A_Q(ntryL,G0H16(1),16,nMT,G1H16(96),n2h16(187))
  Gcoeff(:)%j = (c(43)*M(5,:)%j) * den(59)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(395),h0tab(:,395),[16,1,14],[0,nMT,0],3,1,wf8(:,101))
  call Hloop_UV_W(ntryL,G0H32(1),0,ex5(:),16,G1H16(97),m3h2x16(:,249),heltab2x32(:,:,389))
  Gcoeff(:)%j = (c(39)*M(5,:)%j) * den(59)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(396),h0tab(:,396),[16,1,14],[nMT,0,nMT],3,1,wf8(:,103))
  call Hloop_AV_Q(ntryL,G0H32(1),ex5(:),G0H16(1),m3h2x16(:,250),heltab2x32(:,:,390))
  call Hloop_A_Q(ntryL,G0H16(1),16,nMT,G1H16(98),n2h16(188))
  Gcoeff(:)%j = (c(38)*M(5,:)%j) * den(59)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(397),h0tab(:,397),[16,1,14],[0,nMT,0],3,1,wf8(:,103))
  call Hloop_UV_W(ntryL,G0H32(1),0,ex5(:),16,G1H16(99),m3h2x16(:,251),heltab2x32(:,:,391))
  Gcoeff(:)%j = (-(c(46)*M(3,:)%j)) * den(20)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(398),h0tab(:,398),[18,4,9],[0,nMB,nMT],3,2,wf4(:,16),wf4(:,14))
  call Hloop_QA_V(ntryL,G0H32(1),wf4(:,16),G0H8(22),m3h4x8(:,133),heltab2x32(:,:,392))
  Gcoeff(:)%j = (-(c(41)*M(3,:)%j)) * den(20)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(399),h0tab(:,399),[18,4,9],[0,nMB,nMT],3,2,wf4(:,16),wf4(:,17))
  call Hloop_QA_V(ntryL,G0H32(1),wf4(:,16),G0H8(23),m3h4x8(:,134),heltab2x32(:,:,393))
  Gcoeff(:)%j = (-(c(46)*M(3,:)%j)) * den(21)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(400),h0tab(:,400),[20,2,9],[0,nMT,nMB],3,2,wf4(:,5),wf4(:,14))
  call Hloop_AQ_V(ntryL,G0H32(1),wf4(:,5),G0H8(24),m3h4x8(:,135),heltab2x32(:,:,394))
  Gcoeff(:)%j = (-(c(41)*M(3,:)%j)) * den(21)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(401),h0tab(:,401),[20,2,9],[0,nMT,nMB],3,2,wf4(:,5),wf4(:,17))
  call Hloop_AQ_V(ntryL,G0H32(1),wf4(:,5),G0H8(25),m3h4x8(:,136),heltab2x32(:,:,395))
  Gcoeff(:)%j = (c(44)*M(3,:)%j) * den(66)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(402),h0tab(:,402),[16,4,11],[nMB,0,nMB],3,1,wf8(:,108))
  call Hloop_AV_Q(ntryL,G0H32(1),ex5(:),G0H16(1),m3h2x16(:,252),heltab2x32(:,:,396))
  call Hloop_A_Q(ntryL,G0H16(1),16,nMB,G1H16(100),n2h16(189))
  Gcoeff(:)%j = (c(43)*M(3,:)%j) * den(66)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(403),h0tab(:,403),[16,4,11],[0,nMB,0],3,1,wf8(:,108))
  call Hloop_UV_W(ntryL,G0H32(1),0,ex5(:),16,G1H16(101),m3h2x16(:,253),heltab2x32(:,:,397))
  Gcoeff(:)%j = (c(39)*M(3,:)%j) * den(66)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(404),h0tab(:,404),[16,4,11],[nMB,0,nMB],3,1,wf8(:,109))
  call Hloop_AV_Q(ntryL,G0H32(1),ex5(:),G0H16(1),m3h2x16(:,254),heltab2x32(:,:,398))
  call Hloop_A_Q(ntryL,G0H16(1),16,nMB,G1H16(102),n2h16(190))
  Gcoeff(:)%j = (c(38)*M(3,:)%j) * den(66)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(405),h0tab(:,405),[16,4,11],[0,nMB,0],3,1,wf8(:,109))
  call Hloop_UV_W(ntryL,G0H32(1),0,ex5(:),16,G1H16(103),m3h2x16(:,255),heltab2x32(:,:,399))
  Gcoeff(:)%j = (c(44)*M(3,:)%j) * den(64)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(406),h0tab(:,406),[16,2,13],[nMT,0,nMT],3,1,wf8(:,106))
  call Hloop_QV_A(ntryL,G0H32(1),ex5(:),G0H16(1),m3h2x16(:,256),heltab2x32(:,:,400))
  call Hloop_Q_A(ntryL,G0H16(1),16,nMT,G1H16(104),n2h16(191))
  Gcoeff(:)%j = (-(c(43)*M(3,:)%j)) * den(64)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(407),h0tab(:,407),[16,2,13],[0,nMT,0],3,1,wf8(:,106))
  call Hloop_UV_W(ntryL,G0H32(1),0,ex5(:),16,G1H16(105),m3h2x16(:,257),heltab2x32(:,:,401))
  Gcoeff(:)%j = (c(39)*M(3,:)%j) * den(64)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(408),h0tab(:,408),[16,2,13],[nMT,0,nMT],3,1,wf8(:,107))
  call Hloop_QV_A(ntryL,G0H32(1),ex5(:),G0H16(1),m3h2x16(:,258),heltab2x32(:,:,402))
  call Hloop_Q_A(ntryL,G0H16(1),16,nMT,G1H16(106),n2h16(192))
  Gcoeff(:)%j = (-(c(38)*M(3,:)%j)) * den(64)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(409),h0tab(:,409),[16,2,13],[0,nMT,0],3,1,wf8(:,107))
  call Hloop_UV_W(ntryL,G0H32(1),0,ex5(:),16,G1H16(107),m3h2x16(:,259),heltab2x32(:,:,403))
  Gcoeff(:)%j = (-(c(54)*M(1,:)%j)) * den(23)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(410),h0tab(:,410),[17,2,12],[0,nMT,nMT],3,2,wf4(:,12),wf4(:,18))
  call Hloop_AQ_V(ntryL,G0H32(1),wf4(:,12),G0H8(30),m3h4x8(:,137),heltab2x32(:,:,404))
  Gcoeff(:)%j = (-(c(54)*M(1,:)%j)) * den(25)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(411),h0tab(:,411),[17,2,12],[0,nMT,nMT],3,2,wf4(:,12),wf4(:,19))
  call Hloop_AQ_V(ntryL,G0H32(1),wf4(:,12),G0H8(28),m3h4x8(:,138),heltab2x32(:,:,405))
  Gcoeff(:)%j = (c(56)*M(1,:)%j-c(57)*M(5,:)%j) * den(26)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(412),h0tab(:,412),[17,2,12],[nMH,nMT,nMT],3,2,wf4(:,12),wf4(:,2))
  call Hloop_AQ_S(ntryL,G0H32(1),wf4(:,12),G0H8(29),ngH,m3h4x8(:,139),heltab2x32(:,:,406))
  Gcoeff(:)%j = (-(c(56)*M(1,:)%j)+c(57)*M(5,:)%j) * den(26)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(413),h0tab(:,413),[17,2,12],[nMZ,nMT,nMT],3,2,wf4(:,12),wf4(:,2))
  call Hloop_AQ_S(ntryL,G0H32(1),wf4(:,12),G0H8(31),ngX,m3h4x8(:,140),heltab2x32(:,:,407))
  Gcoeff(:)%j = (-(c(44)*M(1,:)%j)+c(45)*M(5,:)%j) * den(26)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(414),h0tab(:,414),[17,2,12],[nMW,nMB,nMB],3,2,wf4(:,12),wf4(:,2))
  call Hloop_AQ_S(ntryL,G0H32(1),wf4(:,12),G0H8(32),ngPbt,m3h4x8(:,141),heltab2x32(:,:,408))
  Gcoeff(:)%j = (-(c(11)*M(1,:)%j)) * den(26)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(415),h0tab(:,415),[17,2,12],[0,nMT,nMT],3,2,wf4(:,12),wf4(:,2))
  call Hloop_AQ_V(ntryL,G0H32(1),wf4(:,12),G0H8(33),m3h4x8(:,142),heltab2x32(:,:,409))
  Gcoeff(:)%j = (c(16)*M(1,:)%j) * den(25)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(416),h0tab(:,416),[17,2,12],[0,nMT,nMT],3,2,wf4(:,12),wf4(:,20))
  call Hloop_AQ_V(ntryL,G0H32(1),wf4(:,12),G0H8(34),m3h4x8(:,143),heltab2x32(:,:,410))
  Gcoeff(:)%j = (-(c(12)*M(1,:)%j)+c(13)*M(5,:)%j) * den(26)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(417),h0tab(:,417),[17,2,12],[0,nMT,nMT],3,2,wf4(:,12),wf4(:,2))
  call Hloop_AQ_V(ntryL,G0H32(1),wf4(:,12),G0H8(35),m3h4x8(:,144),heltab2x32(:,:,411))
  Gcoeff(:)%j = (-(c(14)*M(1,:)%j)+c(15)*M(5,:)%j) * den(26)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(418),h0tab(:,418),[17,2,12],[nMZ,nMT,nMT],3,2,wf4(:,12),wf4(:,2))
  call Hloop_AQ_Z(ntryL,G0H32(1),wf4(:,12),G0H8(36),ngZu,m3h4x8(:,145),heltab2x32(:,:,412))
  Gcoeff(:)%j = (-(c(39)*M(1,:)%j)+c(40)*M(5,:)%j) * den(26)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(419),h0tab(:,419),[17,2,12],[nMW,nMB,nMB],3,2,wf4(:,12),wf4(:,2))
  call Hloop_AQ_W(ntryL,G0H32(1),wf4(:,12),G0H8(37),m3h4x8(:,146),heltab2x32(:,:,413))
  Gcoeff(:)%j = (c(26)*M(2,:)%j-c(27)*M(6,:)%j) * den(26)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(420),h0tab(:,420),[17,2,12],[0,nMT,nMT],3,2,wf4(:,12),wf4(:,2))
  call Hloop_AQ_V(ntryL,G0H32(1),wf4(:,12),G0H8(38),m3h4x8(:,147),heltab2x32(:,:,414))
  Gcoeff(:)%j = (c(20)*M(2,:)%j-c(22)*M(6,:)%j) * den(26)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(421),h0tab(:,421),[17,2,12],[nMT,0,0],3,2,wf4(:,12),wf4(:,2))
  call Hloop_VQ_A(ntryL,G0H32(1),wf4(:,12),G0H8(43),m3h4x8(:,148),heltab2x32(:,:,415))
  call Hloop_Q_A(ntryL,G0H8(43),17,nMT,G1H8(19),n2h8(127))
  Gcoeff(:)%j = (-(c(54)*M(1,:)%j)) * den(27)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(422),h0tab(:,422),[18,1,12],[0,nMT,nMT],3,2,wf4(:,16),wf4(:,18))
  call Hloop_QA_V(ntryL,G0H32(1),wf4(:,16),G0H8(41),m3h4x8(:,149),heltab2x32(:,:,416))
  Gcoeff(:)%j = (-(c(54)*M(1,:)%j)) * den(28)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(423),h0tab(:,423),[18,1,12],[0,nMT,nMT],3,2,wf4(:,16),wf4(:,19))
  call Hloop_QA_V(ntryL,G0H32(1),wf4(:,16),G0H8(42),m3h4x8(:,150),heltab2x32(:,:,417))
  Gcoeff(:)%j = (c(56)*M(1,:)%j-c(57)*M(3,:)%j) * den(29)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(424),h0tab(:,424),[18,1,12],[nMH,nMT,nMT],3,2,wf4(:,16),wf4(:,2))
  call Hloop_QA_S(ntryL,G0H32(1),wf4(:,16),G0H8(44),ngH,m3h4x8(:,151),heltab2x32(:,:,418))
  Gcoeff(:)%j = (-(c(56)*M(1,:)%j)+c(57)*M(3,:)%j) * den(29)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(425),h0tab(:,425),[18,1,12],[nMZ,nMT,nMT],3,2,wf4(:,16),wf4(:,2))
  call Hloop_QA_S(ntryL,G0H32(1),wf4(:,16),G0H8(45),ngX,m3h4x8(:,152),heltab2x32(:,:,419))
  Gcoeff(:)%j = (-(c(44)*M(1,:)%j)+c(45)*M(3,:)%j) * den(29)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(426),h0tab(:,426),[18,1,12],[nMW,nMB,nMB],3,2,wf4(:,16),wf4(:,2))
  call Hloop_QA_S(ntryL,G0H32(1),wf4(:,16),G0H8(46),ngPtb,m3h4x8(:,153),heltab2x32(:,:,420))
  Gcoeff(:)%j = (-(c(11)*M(1,:)%j)) * den(29)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(427),h0tab(:,427),[18,1,12],[0,nMT,nMT],3,2,wf4(:,16),wf4(:,2))
  call Hloop_QA_V(ntryL,G0H32(1),wf4(:,16),G0H8(47),m3h4x8(:,154),heltab2x32(:,:,421))
  Gcoeff(:)%j = (c(16)*M(1,:)%j) * den(28)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(428),h0tab(:,428),[18,1,12],[0,nMT,nMT],3,2,wf4(:,16),wf4(:,20))
  call Hloop_QA_V(ntryL,G0H32(1),wf4(:,16),G0H8(52),m3h4x8(:,155),heltab2x32(:,:,422))
  Gcoeff(:)%j = (-(c(12)*M(1,:)%j)+c(13)*M(3,:)%j) * den(29)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(429),h0tab(:,429),[18,1,12],[0,nMT,nMT],3,2,wf4(:,16),wf4(:,2))
  call Hloop_QA_V(ntryL,G0H32(1),wf4(:,16),G0H8(50),m3h4x8(:,156),heltab2x32(:,:,423))
  Gcoeff(:)%j = (-(c(14)*M(1,:)%j)+c(15)*M(3,:)%j) * den(29)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(430),h0tab(:,430),[18,1,12],[nMZ,nMT,nMT],3,2,wf4(:,16),wf4(:,2))
  call Hloop_QA_Z(ntryL,G0H32(1),wf4(:,16),G0H8(51),ngZu,m3h4x8(:,157),heltab2x32(:,:,424))
  Gcoeff(:)%j = (-(c(39)*M(1,:)%j)+c(40)*M(3,:)%j) * den(29)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(431),h0tab(:,431),[18,1,12],[nMW,nMB,nMB],3,2,wf4(:,16),wf4(:,2))
  call Hloop_QA_W(ntryL,G0H32(1),wf4(:,16),G0H8(53),m3h4x8(:,158),heltab2x32(:,:,425))
  Gcoeff(:)%j = (c(26)*M(2,:)%j-c(27)*M(4,:)%j) * den(29)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(432),h0tab(:,432),[18,1,12],[0,nMT,nMT],3,2,wf4(:,16),wf4(:,2))
  call Hloop_QA_V(ntryL,G0H32(1),wf4(:,16),G0H8(18),m3h4x8(:,159),heltab2x32(:,:,426))
  Gcoeff(:)%j = (-(c(20)*M(2,:)%j)+c(22)*M(4,:)%j) * den(29)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(433),h0tab(:,433),[18,1,12],[nMT,0,0],3,2,wf4(:,16),wf4(:,2))
  call Hloop_VA_Q(ntryL,G0H32(1),wf4(:,16),G0H8(17),m3h4x8(:,160),heltab2x32(:,:,427))
  call Hloop_A_Q(ntryL,G0H8(17),18,nMT,G1H8(21),n2h8(128))
  Gcoeff(:)%j = (c(52)*M(1,:)%j) * den(76)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(434),h0tab(:,434),[16,2,13],[nMT,0,nMT],3,1,wf8(:,119))
  call Hloop_QV_A(ntryL,G0H32(1),ex5(:),G0H16(1),m3h2x16(:,260),heltab2x32(:,:,428))
  call Hloop_Q_A(ntryL,G0H16(1),16,nMT,G1H16(108),n2h16(193))
  Gcoeff(:)%j = (c(52)*M(1,:)%j) * den(78)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(435),h0tab(:,435),[16,2,13],[nMT,0,nMT],3,1,wf8(:,121))
  call Hloop_QV_A(ntryL,G0H32(1),ex5(:),G0H16(1),m3h2x16(:,261),heltab2x32(:,:,429))
  call Hloop_Q_A(ntryL,G0H16(1),16,nMT,G1H16(109),n2h16(194))
  Gcoeff(:)%j = (-(c(51)*M(1,:)%j)) * den(76)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(436),h0tab(:,436),[16,2,13],[0,nMT,0],3,1,wf8(:,119))
  call Hloop_UV_W(ntryL,G0H32(1),0,ex5(:),16,G1H16(110),m3h2x16(:,262),heltab2x32(:,:,430))
  Gcoeff(:)%j = (-(c(51)*M(1,:)%j)) * den(78)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(437),h0tab(:,437),[16,2,13],[0,nMT,0],3,1,wf8(:,121))
  call Hloop_UV_W(ntryL,G0H32(1),0,ex5(:),16,G1H16(111),m3h2x16(:,263),heltab2x32(:,:,431))
  Gcoeff(:)%j = (c(56)*M(1,:)%j-c(57)*M(3,:)%j) * den(80)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(438),h0tab(:,438),[16,2,13],[nMT,nMH,nMT],3,1,wf8(:,123))
  call Hloop_QV_A(ntryL,G0H32(1),ex5(:),G0H16(1),m3h2x16(:,264),heltab2x32(:,:,432))
  call Hloop_Q_A(ntryL,G0H16(1),16,nMT,G1H16(112),n2h16(195))
  Gcoeff(:)%j = (-(c(56)*M(1,:)%j)+c(57)*M(3,:)%j) * den(80)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(439),h0tab(:,439),[16,2,13],[nMT,nMZ,nMT],3,1,wf8(:,123))
  call Hloop_QV_A(ntryL,G0H32(1),ex5(:),G0H16(1),m3h2x16(:,265),heltab2x32(:,:,433))
  call Hloop_Q_A(ntryL,G0H16(1),16,nMT,G1H16(113),n2h16(196))
  Gcoeff(:)%j = (-(c(44)*M(1,:)%j)+c(45)*M(3,:)%j) * den(80)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(440),h0tab(:,440),[16,2,13],[nMB,nMW,nMB],3,1,wf8(:,123))
  call Hloop_QV_A(ntryL,G0H32(1),ex5(:),G0H16(1),m3h2x16(:,266),heltab2x32(:,:,434))
  call Hloop_Q_A(ntryL,G0H16(1),16,nMB,G1H16(114),n2h16(197))
  Gcoeff(:)%j = (c(9)*M(1,:)%j) * den(80)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(441),h0tab(:,441),[16,2,13],[nMT,0,nMT],3,1,wf8(:,123))
  call Hloop_QV_A(ntryL,G0H32(1),ex5(:),G0H16(1),m3h2x16(:,267),heltab2x32(:,:,435))
  call Hloop_Q_A(ntryL,G0H16(1),16,nMT,G1H16(115),n2h16(198))
  Gcoeff(:)%j = (-(c(14)*M(1,:)%j)) * den(78)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(442),h0tab(:,442),[16,2,13],[nMT,0,nMT],3,1,wf8(:,125))
  call Hloop_QV_A(ntryL,G0H32(1),ex5(:),G0H16(1),m3h2x16(:,268),heltab2x32(:,:,436))
  call Hloop_Q_A(ntryL,G0H16(1),16,nMT,G1H16(116),n2h16(199))
  Gcoeff(:)%j = (-(c(12)*M(1,:)%j)+c(13)*M(3,:)%j) * den(80)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(443),h0tab(:,443),[16,2,13],[nMT,0,nMT],3,1,wf8(:,123))
  call Hloop_QV_A(ntryL,G0H32(1),ex5(:),G0H16(1),m3h2x16(:,269),heltab2x32(:,:,437))
  call Hloop_Q_A(ntryL,G0H16(1),16,nMT,G1H16(117),n2h16(200))
  Gcoeff(:)%j = (-(c(14)*M(1,:)%j)+c(15)*M(3,:)%j) * den(80)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(444),h0tab(:,444),[16,2,13],[nMT,nMZ,nMT],3,1,wf8(:,123))
  call Hloop_QV_A(ntryL,G0H32(1),ex5(:),G0H16(1),m3h2x16(:,270),heltab2x32(:,:,438))
  call Hloop_Q_A(ntryL,G0H16(1),16,nMT,G1H16(118),n2h16(201))
  Gcoeff(:)%j = (-(c(39)*M(1,:)%j)+c(40)*M(3,:)%j) * den(80)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(445),h0tab(:,445),[16,2,13],[nMB,nMW,nMB],3,1,wf8(:,123))
  call Hloop_QV_A(ntryL,G0H32(1),ex5(:),G0H16(1),m3h2x16(:,271),heltab2x32(:,:,439))
  call Hloop_Q_A(ntryL,G0H16(1),16,nMB,G1H16(119),n2h16(202))
  Gcoeff(:)%j = (c(26)*M(2,:)%j-c(27)*M(4,:)%j) * den(80)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(446),h0tab(:,446),[16,2,13],[nMT,0,nMT],3,1,wf8(:,123))
  call Hloop_QV_A(ntryL,G0H32(1),ex5(:),G0H16(1),m3h2x16(:,272),heltab2x32(:,:,440))
  call Hloop_Q_A(ntryL,G0H16(1),16,nMT,G1H16(120),n2h16(203))
  Gcoeff(:)%j = (-(c(3)*M(1,:)%j)) * den(80)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(447),h0tab(:,447),[16,2,13],[0,nMT,0],3,1,wf8(:,123))
  call Hloop_UV_W(ntryL,G0H32(1),0,ex5(:),16,G1H16(121),m3h2x16(:,273),heltab2x32(:,:,441))
  Gcoeff(:)%j = (c(6)*M(1,:)%j) * den(78)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(448),h0tab(:,448),[16,2,13],[0,nMT,0],3,1,wf8(:,125))
  call Hloop_UV_W(ntryL,G0H32(1),0,ex5(:),16,G1H16(122),m3h2x16(:,274),heltab2x32(:,:,442))
  Gcoeff(:)%j = (-(c(20)*M(2,:)%j)+c(22)*M(4,:)%j) * den(80)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(449),h0tab(:,449),[16,2,13],[0,nMT,0],3,1,wf8(:,123))
  call Hloop_UV_W(ntryL,G0H32(1),0,ex5(:),16,G1H16(123),m3h2x16(:,275),heltab2x32(:,:,443))
  Gcoeff(:)%j = (c(52)*M(1,:)%j) * den(68)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(450),h0tab(:,450),[16,1,14],[nMT,0,nMT],3,1,wf8(:,111))
  call Hloop_AV_Q(ntryL,G0H32(1),ex5(:),G0H16(1),m3h2x16(:,276),heltab2x32(:,:,444))
  call Hloop_A_Q(ntryL,G0H16(1),16,nMT,G1H16(124),n2h16(204))
  Gcoeff(:)%j = (c(52)*M(1,:)%j) * den(70)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(451),h0tab(:,451),[16,1,14],[nMT,0,nMT],3,1,wf8(:,113))
  call Hloop_AV_Q(ntryL,G0H32(1),ex5(:),G0H16(1),m3h2x16(:,277),heltab2x32(:,:,445))
  call Hloop_A_Q(ntryL,G0H16(1),16,nMT,G1H16(125),n2h16(205))
  Gcoeff(:)%j = (c(51)*M(1,:)%j) * den(68)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(452),h0tab(:,452),[16,1,14],[0,nMT,0],3,1,wf8(:,111))
  call Hloop_UV_W(ntryL,G0H32(1),0,ex5(:),16,G1H16(126),m3h2x16(:,278),heltab2x32(:,:,446))
  Gcoeff(:)%j = (c(51)*M(1,:)%j) * den(70)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(453),h0tab(:,453),[16,1,14],[0,nMT,0],3,1,wf8(:,113))
  call Hloop_UV_W(ntryL,G0H32(1),0,ex5(:),16,G1H16(127),m3h2x16(:,279),heltab2x32(:,:,447))
  Gcoeff(:)%j = (c(56)*M(1,:)%j-c(57)*M(5,:)%j) * den(72)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(454),h0tab(:,454),[16,1,14],[nMT,nMH,nMT],3,1,wf8(:,115))
  call Hloop_AV_Q(ntryL,G0H32(1),ex5(:),G0H16(1),m3h2x16(:,280),heltab2x32(:,:,448))
  call Hloop_A_Q(ntryL,G0H16(1),16,nMT,G1H16(128),n2h16(206))
  Gcoeff(:)%j = (-(c(56)*M(1,:)%j)+c(57)*M(5,:)%j) * den(72)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(455),h0tab(:,455),[16,1,14],[nMT,nMZ,nMT],3,1,wf8(:,115))
  call Hloop_AV_Q(ntryL,G0H32(1),ex5(:),G0H16(1),m3h2x16(:,281),heltab2x32(:,:,449))
  call Hloop_A_Q(ntryL,G0H16(1),16,nMT,G1H16(129),n2h16(207))
  Gcoeff(:)%j = (-(c(44)*M(1,:)%j)+c(45)*M(5,:)%j) * den(72)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(456),h0tab(:,456),[16,1,14],[nMB,nMW,nMB],3,1,wf8(:,115))
  call Hloop_AV_Q(ntryL,G0H32(1),ex5(:),G0H16(1),m3h2x16(:,282),heltab2x32(:,:,450))
  call Hloop_A_Q(ntryL,G0H16(1),16,nMB,G1H16(130),n2h16(208))
  Gcoeff(:)%j = (c(9)*M(1,:)%j) * den(72)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(457),h0tab(:,457),[16,1,14],[nMT,0,nMT],3,1,wf8(:,115))
  call Hloop_AV_Q(ntryL,G0H32(1),ex5(:),G0H16(1),m3h2x16(:,283),heltab2x32(:,:,451))
  call Hloop_A_Q(ntryL,G0H16(1),16,nMT,G1H16(131),n2h16(209))
  Gcoeff(:)%j = (-(c(14)*M(1,:)%j)) * den(70)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(458),h0tab(:,458),[16,1,14],[nMT,0,nMT],3,1,wf8(:,117))
  call Hloop_AV_Q(ntryL,G0H32(1),ex5(:),G0H16(1),m3h2x16(:,284),heltab2x32(:,:,452))
  call Hloop_A_Q(ntryL,G0H16(1),16,nMT,G1H16(132),n2h16(210))
  Gcoeff(:)%j = (-(c(12)*M(1,:)%j)+c(13)*M(5,:)%j) * den(72)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(459),h0tab(:,459),[16,1,14],[nMT,0,nMT],3,1,wf8(:,115))
  call Hloop_AV_Q(ntryL,G0H32(1),ex5(:),G0H16(1),m3h2x16(:,285),heltab2x32(:,:,453))
  call Hloop_A_Q(ntryL,G0H16(1),16,nMT,G1H16(133),n2h16(211))
  Gcoeff(:)%j = (-(c(14)*M(1,:)%j)+c(15)*M(5,:)%j) * den(72)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(460),h0tab(:,460),[16,1,14],[nMT,nMZ,nMT],3,1,wf8(:,115))
  call Hloop_AV_Q(ntryL,G0H32(1),ex5(:),G0H16(1),m3h2x16(:,286),heltab2x32(:,:,454))
  call Hloop_A_Q(ntryL,G0H16(1),16,nMT,G1H16(134),n2h16(212))
  Gcoeff(:)%j = (-(c(39)*M(1,:)%j)+c(40)*M(5,:)%j) * den(72)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(461),h0tab(:,461),[16,1,14],[nMB,nMW,nMB],3,1,wf8(:,115))
  call Hloop_AV_Q(ntryL,G0H32(1),ex5(:),G0H16(1),m3h2x16(:,287),heltab2x32(:,:,455))
  call Hloop_A_Q(ntryL,G0H16(1),16,nMB,G1H16(135),n2h16(213))
  Gcoeff(:)%j = (c(26)*M(2,:)%j-c(27)*M(6,:)%j) * den(72)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(462),h0tab(:,462),[16,1,14],[nMT,0,nMT],3,1,wf8(:,115))
  call Hloop_AV_Q(ntryL,G0H32(1),ex5(:),G0H16(1),m3h2x16(:,288),heltab2x32(:,:,456))
  call Hloop_A_Q(ntryL,G0H16(1),16,nMT,G1H16(136),n2h16(214))
  Gcoeff(:)%j = (c(3)*M(1,:)%j) * den(72)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(463),h0tab(:,463),[16,1,14],[0,nMT,0],3,1,wf8(:,115))
  call Hloop_UV_W(ntryL,G0H32(1),0,ex5(:),16,G1H16(137),m3h2x16(:,289),heltab2x32(:,:,457))
  Gcoeff(:)%j = (-(c(6)*M(1,:)%j)) * den(70)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(464),h0tab(:,464),[16,1,14],[0,nMT,0],3,1,wf8(:,117))
  call Hloop_UV_W(ntryL,G0H32(1),0,ex5(:),16,G1H16(138),m3h2x16(:,290),heltab2x32(:,:,458))
  Gcoeff(:)%j = (c(20)*M(2,:)%j-c(22)*M(6,:)%j) * den(72)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(465),h0tab(:,465),[16,1,14],[0,nMT,0],3,1,wf8(:,115))
  call Hloop_UV_W(ntryL,G0H32(1),0,ex5(:),16,G1H16(139),m3h2x16(:,291),heltab2x32(:,:,459))
  Gcoeff(:)%j = (c(55)*(-M(3,:)%j+M(5,:)%j)) * den(35)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(466),h0tab(:,466),[28,1,2],[nMT,nMH,nMT],3,1,wf8(:,89))
  call Hloop_AV_Q(ntryL,G0H32(1),wf8(:,89),G0H4(7),m3h8x4(:,9),heltab2x32(:,:,460))
  call Hloop_A_Q(ntryL,G0H4(7),28,nMT,G1H4(13),n2h4(166))
  Gcoeff(:)%j = (c(55)*(M(3,:)%j-M(5,:)%j)) * den(35)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(467),h0tab(:,467),[28,1,2],[nMT,nMZ,nMT],3,1,wf8(:,89))
  call Hloop_AV_Q(ntryL,G0H32(1),wf8(:,89),G0H4(7),m3h8x4(:,10),heltab2x32(:,:,461))
  call Hloop_A_Q(ntryL,G0H4(7),28,nMT,G1H4(14),n2h4(167))
  Gcoeff(:)%j = (c(42)*(M(3,:)%j-M(5,:)%j)) * den(35)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(468),h0tab(:,468),[28,1,2],[nMB,nMW,nMB],3,1,wf8(:,89))
  call Hloop_AV_Q(ntryL,G0H32(1),wf8(:,89),G0H4(7),m3h8x4(:,11),heltab2x32(:,:,462))
  call Hloop_A_Q(ntryL,G0H4(7),28,nMB,G1H4(17),n2h4(168))
  Gcoeff(:)%j = (c(4)*(M(3,:)%j-M(5,:)%j)) * den(35)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(469),h0tab(:,469),[28,1,2],[nMT,0,nMT],3,1,wf8(:,89))
  call Hloop_AV_Q(ntryL,G0H32(1),wf8(:,89),G0H4(7),m3h8x4(:,12),heltab2x32(:,:,463))
  call Hloop_A_Q(ntryL,G0H4(7),28,nMT,G1H4(18),n2h4(169))
  Gcoeff(:)%j = (c(5)*(M(3,:)%j-M(5,:)%j)) * den(35)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(470),h0tab(:,470),[28,1,2],[nMT,nMZ,nMT],3,1,wf8(:,89))
  call Hloop_AV_Q(ntryL,G0H32(1),wf8(:,89),G0H4(7),m3h8x4(:,13),heltab2x32(:,:,464))
  call Hloop_A_Q(ntryL,G0H4(7),28,nMT,G1H4(19),n2h4(170))
  Gcoeff(:)%j = (c(37)*(M(3,:)%j-M(5,:)%j)) * den(35)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(471),h0tab(:,471),[28,1,2],[nMB,nMW,nMB],3,1,wf8(:,89))
  call Hloop_AV_Q(ntryL,G0H32(1),wf8(:,89),G0H4(7),m3h8x4(:,14),heltab2x32(:,:,465))
  call Hloop_A_Q(ntryL,G0H4(7),28,nMB,G1H4(20),n2h4(171))
  Gcoeff(:)%j = (c(19)*(-M(4,:)%j+M(6,:)%j)) * den(35)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(472),h0tab(:,472),[28,1,2],[nMT,0,nMT],3,1,wf8(:,89))
  call Hloop_AV_Q(ntryL,G0H32(1),wf8(:,89),G0H4(7),m3h8x4(:,15),heltab2x32(:,:,466))
  call Hloop_A_Q(ntryL,G0H4(7),28,nMT,G1H4(24),n2h4(172))
  Gcoeff(:)%j = (c(35)*(-M(4,:)%j+M(6,:)%j)) * den(35)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(473),h0tab(:,473),[28,1,2],[0,nMT,0],3,1,wf8(:,89))
  call Hloop_UV_W(ntryL,G0H32(1),0,wf8(:,89),28,G1H4(25),m3h8x4(:,16),heltab2x32(:,:,467))
  Gcoeff(:)%j = (-(c(54)*M(1,:)%j)) * den(85)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(474),h0tab(:,474),[19,4,8],[nMB,0,nMB],3,1,wf8(:,18))
  call Hloop_AS_Q(ntryL,G0H32(1),wf8(:,18),G0H4(7),ngH,m3h8x4(:,17),heltab2x32(:,:,468))
  call Hloop_A_Q(ntryL,G0H4(7),19,nMB,G1H4(26),n2h4(173))
  Gcoeff(:)%j = (-(c(54)*M(1,:)%j)) * den(87)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(475),h0tab(:,475),[19,4,8],[nMB,0,nMB],3,1,wf8(:,19))
  call Hloop_AS_Q(ntryL,G0H32(1),wf8(:,19),G0H4(7),ngX,m3h8x4(:,18),heltab2x32(:,:,469))
  call Hloop_A_Q(ntryL,G0H4(7),19,nMB,G1H4(29),n2h4(174))
  Gcoeff(:)%j = (c(48)*M(1,:)%j-c(49)*M(5,:)%j) * den(74)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(476),h0tab(:,476),[19,4,8],[nMB,nMH,nMB],3,1,wf8(:,20))
  call Hloop_AV_Q(ntryL,G0H32(1),wf8(:,20),G0H4(7),m3h8x4(:,19),heltab2x32(:,:,470))
  call Hloop_A_Q(ntryL,G0H4(7),19,nMB,G1H4(3),n2h4(175))
  Gcoeff(:)%j = (-(c(48)*M(1,:)%j)+c(49)*M(5,:)%j) * den(74)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(477),h0tab(:,477),[19,4,8],[nMB,nMZ,nMB],3,1,wf8(:,20))
  call Hloop_AV_Q(ntryL,G0H32(1),wf8(:,20),G0H4(7),m3h8x4(:,20),heltab2x32(:,:,471))
  call Hloop_A_Q(ntryL,G0H4(7),19,nMB,G1H4(4),n2h4(176))
  Gcoeff(:)%j = (-(c(44)*M(1,:)%j)+c(45)*M(5,:)%j) * den(74)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(478),h0tab(:,478),[19,4,8],[nMT,nMW,nMT],3,1,wf8(:,20))
  call Hloop_AV_Q(ntryL,G0H32(1),wf8(:,20),G0H4(7),m3h8x4(:,21),heltab2x32(:,:,472))
  call Hloop_A_Q(ntryL,G0H4(7),19,nMT,G1H4(134),n2h4(177))
  Gcoeff(:)%j = (-(c(11)*M(1,:)%j)) * den(74)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(479),h0tab(:,479),[19,4,8],[nMB,0,nMB],3,1,wf8(:,20))
  call Hloop_AV_Q(ntryL,G0H32(1),wf8(:,20),G0H4(7),m3h8x4(:,22),heltab2x32(:,:,473))
  call Hloop_A_Q(ntryL,G0H4(7),19,nMB,G1H4(143),n2h4(178))
  Gcoeff(:)%j = (c(16)*M(1,:)%j) * den(87)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(480),h0tab(:,480),[19,4,8],[nMB,0,nMB],3,1,wf8(:,21))
  call Hloop_AZ_Q(ntryL,G0H32(1),wf8(:,21),G0H4(7),ngZd,m3h8x4(:,23),heltab2x32(:,:,474))
  call Hloop_A_Q(ntryL,G0H4(7),19,nMB,G1H4(72),n2h4(179))
  Gcoeff(:)%j = (-(c(7)*M(1,:)%j)+c(8)*M(5,:)%j) * den(74)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(481),h0tab(:,481),[19,4,8],[nMB,0,nMB],3,1,wf8(:,20))
  call Hloop_AV_Q(ntryL,G0H32(1),wf8(:,20),G0H4(7),m3h8x4(:,24),heltab2x32(:,:,475))
  call Hloop_A_Q(ntryL,G0H4(7),19,nMB,G1H4(70),n2h4(180))
  Gcoeff(:)%j = (-(c(14)*M(1,:)%j)+c(15)*M(5,:)%j) * den(74)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(482),h0tab(:,482),[19,4,8],[nMB,nMZ,nMB],3,1,wf8(:,20))
  call Hloop_AV_Q(ntryL,G0H32(1),wf8(:,20),G0H4(7),m3h8x4(:,25),heltab2x32(:,:,476))
  call Hloop_A_Q(ntryL,G0H4(7),19,nMB,G1H4(77),n2h4(181))
  Gcoeff(:)%j = (-(c(39)*M(1,:)%j)+c(40)*M(5,:)%j) * den(74)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(483),h0tab(:,483),[19,4,8],[nMT,nMW,nMT],3,1,wf8(:,20))
  call Hloop_AV_Q(ntryL,G0H32(1),wf8(:,20),G0H4(7),m3h8x4(:,26),heltab2x32(:,:,477))
  call Hloop_A_Q(ntryL,G0H4(7),19,nMT,G1H4(103),n2h4(182))
  Gcoeff(:)%j = (c(26)*M(2,:)%j-c(27)*M(6,:)%j) * den(74)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(484),h0tab(:,484),[19,4,8],[nMB,0,nMB],3,1,wf8(:,20))
  call Hloop_AV_Q(ntryL,G0H32(1),wf8(:,20),G0H4(7),m3h8x4(:,27),heltab2x32(:,:,478))
  call Hloop_A_Q(ntryL,G0H4(7),19,nMB,G1H4(112),n2h4(183))
  Gcoeff(:)%j = (c(20)*M(2,:)%j-c(22)*M(6,:)%j) * den(74)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(485),h0tab(:,485),[19,4,8],[0,nMB,0],3,1,wf8(:,20))
  call Hloop_UV_W(ntryL,G0H32(1),0,wf8(:,20),19,G1H4(113),m3h8x4(:,28),heltab2x32(:,:,479))
  Gcoeff(:)%j = (-(c(46)*M(5,:)%j)) * den(89)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(486),h0tab(:,486),[25,2,4],[nMT,0,nMB],3,1,wf8(:,10))
  call Hloop_QS_A(ntryL,G0H32(1),wf8(:,10),G0H4(7),ngPtb,m3h8x4(:,29),heltab2x32(:,:,480))
  call Hloop_Q_A(ntryL,G0H4(7),25,nMT,G1H4(88),n2h4(184))
  Gcoeff(:)%j = (-(c(41)*M(5,:)%j)) * den(89)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(487),h0tab(:,487),[25,2,4],[nMT,0,nMB],3,1,wf8(:,11))
  call Hloop_QW_A(ntryL,G0H32(1),wf8(:,11),G0H4(7),m3h8x4(:,30),heltab2x32(:,:,481))
  call Hloop_Q_A(ntryL,G0H4(7),25,nMT,G1H4(85),n2h4(185))
  Gcoeff(:)%j = (-(c(54)*M(1,:)%j)) * den(90)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(488),h0tab(:,488),[19,4,8],[nMB,0,nMB],3,1,wf8(:,22))
  call Hloop_AS_Q(ntryL,G0H32(1),wf8(:,22),G0H4(7),ngH,m3h8x4(:,31),heltab2x32(:,:,482))
  call Hloop_A_Q(ntryL,G0H4(7),19,nMB,G1H4(94),n2h4(186))
  Gcoeff(:)%j = (-(c(54)*M(1,:)%j)) * den(91)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(489),h0tab(:,489),[19,4,8],[nMB,0,nMB],3,1,wf8(:,23))
  call Hloop_AS_Q(ntryL,G0H32(1),wf8(:,23),G0H4(7),ngX,m3h8x4(:,32),heltab2x32(:,:,483))
  call Hloop_A_Q(ntryL,G0H4(7),19,nMB,G1H4(106),n2h4(187))
  Gcoeff(:)%j = (c(48)*M(1,:)%j-c(49)*M(3,:)%j) * den(82)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(490),h0tab(:,490),[19,4,8],[nMB,nMH,nMB],3,1,wf8(:,24))
  call Hloop_AV_Q(ntryL,G0H32(1),wf8(:,24),G0H4(7),m3h8x4(:,33),heltab2x32(:,:,484))
  call Hloop_A_Q(ntryL,G0H4(7),19,nMB,G1H4(41),n2h4(188))
  Gcoeff(:)%j = (-(c(48)*M(1,:)%j)+c(49)*M(3,:)%j) * den(82)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(491),h0tab(:,491),[19,4,8],[nMB,nMZ,nMB],3,1,wf8(:,24))
  call Hloop_AV_Q(ntryL,G0H32(1),wf8(:,24),G0H4(7),m3h8x4(:,34),heltab2x32(:,:,485))
  call Hloop_A_Q(ntryL,G0H4(7),19,nMB,G1H4(42),n2h4(189))
  Gcoeff(:)%j = (-(c(44)*M(1,:)%j)+c(45)*M(3,:)%j) * den(82)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(492),h0tab(:,492),[19,4,8],[nMT,nMW,nMT],3,1,wf8(:,24))
  call Hloop_AV_Q(ntryL,G0H32(1),wf8(:,24),G0H4(7),m3h8x4(:,35),heltab2x32(:,:,486))
  call Hloop_A_Q(ntryL,G0H4(7),19,nMT,G1H4(54),n2h4(190))
  Gcoeff(:)%j = (-(c(11)*M(1,:)%j)) * den(82)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(493),h0tab(:,493),[19,4,8],[nMB,0,nMB],3,1,wf8(:,24))
  call Hloop_AV_Q(ntryL,G0H32(1),wf8(:,24),G0H4(7),m3h8x4(:,36),heltab2x32(:,:,487))
  call Hloop_A_Q(ntryL,G0H4(7),19,nMB,G1H4(55),n2h4(191))
  Gcoeff(:)%j = (c(16)*M(1,:)%j) * den(91)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(494),h0tab(:,494),[19,4,8],[nMB,0,nMB],3,1,wf8(:,25))
  call Hloop_AZ_Q(ntryL,G0H32(1),wf8(:,25),G0H4(7),ngZd,m3h8x4(:,37),heltab2x32(:,:,488))
  call Hloop_A_Q(ntryL,G0H4(7),19,nMB,G1H4(60),n2h4(192))
  Gcoeff(:)%j = (-(c(7)*M(1,:)%j)+c(8)*M(3,:)%j) * den(82)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(495),h0tab(:,495),[19,4,8],[nMB,0,nMB],3,1,wf8(:,24))
  call Hloop_AV_Q(ntryL,G0H32(1),wf8(:,24),G0H4(7),m3h8x4(:,38),heltab2x32(:,:,489))
  call Hloop_A_Q(ntryL,G0H4(7),19,nMB,G1H4(67),n2h4(193))
  Gcoeff(:)%j = (-(c(14)*M(1,:)%j)+c(15)*M(3,:)%j) * den(82)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(496),h0tab(:,496),[19,4,8],[nMB,nMZ,nMB],3,1,wf8(:,24))
  call Hloop_AV_Q(ntryL,G0H32(1),wf8(:,24),G0H4(7),m3h8x4(:,39),heltab2x32(:,:,490))
  call Hloop_A_Q(ntryL,G0H4(7),19,nMB,G1H4(123),n2h4(194))
  Gcoeff(:)%j = (-(c(39)*M(1,:)%j)+c(40)*M(3,:)%j) * den(82)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(497),h0tab(:,497),[19,4,8],[nMT,nMW,nMT],3,1,wf8(:,24))
  call Hloop_AV_Q(ntryL,G0H32(1),wf8(:,24),G0H4(7),m3h8x4(:,40),heltab2x32(:,:,491))
  call Hloop_A_Q(ntryL,G0H4(7),19,nMT,G1H4(124),n2h4(195))
  Gcoeff(:)%j = (c(26)*M(2,:)%j-c(27)*M(4,:)%j) * den(82)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(498),h0tab(:,498),[19,4,8],[nMB,0,nMB],3,1,wf8(:,24))
  call Hloop_AV_Q(ntryL,G0H32(1),wf8(:,24),G0H4(7),m3h8x4(:,41),heltab2x32(:,:,492))
  call Hloop_A_Q(ntryL,G0H4(7),19,nMB,G1H4(135),n2h4(196))
  Gcoeff(:)%j = (c(20)*M(2,:)%j-c(22)*M(4,:)%j) * den(82)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(499),h0tab(:,499),[19,4,8],[0,nMB,0],3,1,wf8(:,24))
  call Hloop_UV_W(ntryL,G0H32(1),0,wf8(:,24),19,G1H4(136),m3h8x4(:,42),heltab2x32(:,:,493))
  Gcoeff(:)%j = (-(c(46)*M(3,:)%j)) * den(93)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(500),h0tab(:,500),[22,1,8],[nMT,0,nMB],3,1,wf8(:,126))
  call Hloop_AS_Q(ntryL,G0H32(1),wf8(:,126),G0H4(7),ngPbt,m3h8x4(:,43),heltab2x32(:,:,494))
  call Hloop_A_Q(ntryL,G0H4(7),22,nMT,G1H4(141),n2h4(197))
  Gcoeff(:)%j = (-(c(41)*M(3,:)%j)) * den(93)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(501),h0tab(:,501),[22,1,8],[nMT,0,nMB],3,1,wf8(:,127))
  call Hloop_AW_Q(ntryL,G0H32(1),wf8(:,127),G0H4(7),m3h8x4(:,44),heltab2x32(:,:,495))
  call Hloop_A_Q(ntryL,G0H4(7),22,nMT,G1H4(10),n2h4(198))
  Gcoeff(:)%j = (-(c(46)*M(3,:)%j)) * den(94)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(502),h0tab(:,502),[22,1,8],[nMT,0,nMB],3,1,wf8(:,128))
  call Hloop_AS_Q(ntryL,G0H32(1),wf8(:,128),G0H4(7),ngPbt,m3h8x4(:,45),heltab2x32(:,:,496))
  call Hloop_A_Q(ntryL,G0H4(7),22,nMT,G1H4(15),n2h4(199))
  Gcoeff(:)%j = (-(c(41)*M(3,:)%j)) * den(94)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(503),h0tab(:,503),[22,1,8],[nMT,0,nMB],3,1,wf8(:,129))
  call Hloop_AW_Q(ntryL,G0H32(1),wf8(:,129),G0H4(7),m3h8x4(:,46),heltab2x32(:,:,497))
  call Hloop_A_Q(ntryL,G0H4(7),22,nMT,G1H4(76),n2h4(200))
  Gcoeff(:)%j = (-(c(54)*M(7,:)%j)) * den(96)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(504),h0tab(:,504),[28,1,2],[nMT,0,nMT],3,1,wf8(:,130))
  call Hloop_AS_Q(ntryL,G0H32(1),wf8(:,130),G0H4(7),ngH,m3h8x4(:,47),heltab2x32(:,:,498))
  call Hloop_A_Q(ntryL,G0H4(7),28,nMT,G1H4(22),n2h4(201))
  Gcoeff(:)%j = (-(c(54)*M(7,:)%j)) * den(98)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(505),h0tab(:,505),[28,1,2],[nMT,0,nMT],3,1,wf8(:,131))
  call Hloop_AS_Q(ntryL,G0H32(1),wf8(:,131),G0H4(7),ngX,m3h8x4(:,48),heltab2x32(:,:,499))
  call Hloop_A_Q(ntryL,G0H4(7),28,nMT,G1H4(27),n2h4(202))
  Gcoeff(:)%j = (-(c(57)*M(3,:)%j)+c(56)*M(7,:)%j) * den(40)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(506),h0tab(:,506),[28,1,2],[nMT,nMH,nMT],3,1,wf8(:,90))
  call Hloop_AV_Q(ntryL,G0H32(1),wf8(:,90),G0H4(7),m3h8x4(:,49),heltab2x32(:,:,500))
  call Hloop_A_Q(ntryL,G0H4(7),28,nMT,G1H4(28),n2h4(203))
  Gcoeff(:)%j = (c(57)*M(3,:)%j-c(56)*M(7,:)%j) * den(40)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(507),h0tab(:,507),[28,1,2],[nMT,nMZ,nMT],3,1,wf8(:,90))
  call Hloop_AV_Q(ntryL,G0H32(1),wf8(:,90),G0H4(7),m3h8x4(:,50),heltab2x32(:,:,501))
  call Hloop_A_Q(ntryL,G0H4(7),28,nMT,G1H4(39),n2h4(204))
  Gcoeff(:)%j = (c(45)*M(3,:)%j-c(44)*M(7,:)%j) * den(40)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(508),h0tab(:,508),[28,1,2],[nMB,nMW,nMB],3,1,wf8(:,90))
  call Hloop_AV_Q(ntryL,G0H32(1),wf8(:,90),G0H4(7),m3h8x4(:,51),heltab2x32(:,:,502))
  call Hloop_A_Q(ntryL,G0H4(7),28,nMB,G1H4(40),n2h4(205))
  Gcoeff(:)%j = (-(c(11)*M(7,:)%j)) * den(40)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(509),h0tab(:,509),[28,1,2],[nMT,0,nMT],3,1,wf8(:,90))
  call Hloop_AV_Q(ntryL,G0H32(1),wf8(:,90),G0H4(7),m3h8x4(:,52),heltab2x32(:,:,503))
  call Hloop_A_Q(ntryL,G0H4(7),28,nMT,G1H4(45),n2h4(206))
  Gcoeff(:)%j = (c(16)*M(7,:)%j) * den(98)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(510),h0tab(:,510),[28,1,2],[nMT,0,nMT],3,1,wf8(:,132))
  call Hloop_AZ_Q(ntryL,G0H32(1),wf8(:,132),G0H4(7),ngZu,m3h8x4(:,53),heltab2x32(:,:,504))
  call Hloop_A_Q(ntryL,G0H4(7),28,nMT,G1H4(100),n2h4(207))
  Gcoeff(:)%j = (c(13)*M(3,:)%j-c(12)*M(7,:)%j) * den(40)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(511),h0tab(:,511),[28,1,2],[nMT,0,nMT],3,1,wf8(:,90))
  call Hloop_AV_Q(ntryL,G0H32(1),wf8(:,90),G0H4(7),m3h8x4(:,54),heltab2x32(:,:,505))
  call Hloop_A_Q(ntryL,G0H4(7),28,nMT,G1H4(52),n2h4(208))
  Gcoeff(:)%j = (c(15)*M(3,:)%j-c(14)*M(7,:)%j) * den(40)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(512),h0tab(:,512),[28,1,2],[nMT,nMZ,nMT],3,1,wf8(:,90))
  call Hloop_AV_Q(ntryL,G0H32(1),wf8(:,90),G0H4(7),m3h8x4(:,55),heltab2x32(:,:,506))
  call Hloop_A_Q(ntryL,G0H4(7),28,nMT,G1H4(57),n2h4(209))
  Gcoeff(:)%j = (c(40)*M(3,:)%j-c(39)*M(7,:)%j) * den(40)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(513),h0tab(:,513),[28,1,2],[nMB,nMW,nMB],3,1,wf8(:,90))
  call Hloop_AV_Q(ntryL,G0H32(1),wf8(:,90),G0H4(7),m3h8x4(:,56),heltab2x32(:,:,507))
  call Hloop_A_Q(ntryL,G0H4(7),28,nMB,G1H4(69),n2h4(210))
  Gcoeff(:)%j = (-(c(27)*M(4,:)%j)+c(26)*M(8,:)%j) * den(40)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(514),h0tab(:,514),[28,1,2],[nMT,0,nMT],3,1,wf8(:,90))
  call Hloop_AV_Q(ntryL,G0H32(1),wf8(:,90),G0H4(7),m3h8x4(:,57),heltab2x32(:,:,508))
  call Hloop_A_Q(ntryL,G0H4(7),28,nMT,G1H4(75),n2h4(211))
  Gcoeff(:)%j = (-(c(22)*M(4,:)%j)+c(20)*M(8,:)%j) * den(40)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(515),h0tab(:,515),[28,1,2],[0,nMT,0],3,1,wf8(:,90))
  call Hloop_UV_W(ntryL,G0H32(1),0,wf8(:,90),28,G1H4(81),m3h8x4(:,58),heltab2x32(:,:,509))
  Gcoeff(:)%j = (-(c(46)*M(5,:)%j)) * den(99)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(516),h0tab(:,516),[25,2,4],[nMT,0,nMB],3,1,wf8(:,133))
  call Hloop_QS_A(ntryL,G0H32(1),wf8(:,133),G0H4(7),ngPtb,m3h8x4(:,59),heltab2x32(:,:,510))
  call Hloop_Q_A(ntryL,G0H4(7),25,nMT,G1H4(36),n2h4(212))
  Gcoeff(:)%j = (-(c(41)*M(5,:)%j)) * den(99)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(517),h0tab(:,517),[25,2,4],[nMT,0,nMB],3,1,wf8(:,134))
  call Hloop_QW_A(ntryL,G0H32(1),wf8(:,134),G0H4(7),m3h8x4(:,60),heltab2x32(:,:,511))
  call Hloop_Q_A(ntryL,G0H4(7),25,nMT,G1H4(48),n2h4(213))
  Gcoeff(:)%j = (-(c(54)*M(7,:)%j)) * den(100)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(518),h0tab(:,518),[28,1,2],[nMT,0,nMT],3,1,wf8(:,135))
  call Hloop_AS_Q(ntryL,G0H32(1),wf8(:,135),G0H4(7),ngH,m3h8x4(:,61),heltab2x32(:,:,512))
  call Hloop_A_Q(ntryL,G0H4(7),28,nMT,G1H4(38),n2h4(214))
  Gcoeff(:)%j = (-(c(54)*M(7,:)%j)) * den(101)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(519),h0tab(:,519),[28,1,2],[nMT,0,nMT],3,1,wf8(:,136))
  call Hloop_AS_Q(ntryL,G0H32(1),wf8(:,136),G0H4(7),ngX,m3h8x4(:,62),heltab2x32(:,:,513))
  call Hloop_A_Q(ntryL,G0H4(7),28,nMT,G1H4(47),n2h4(215))
  Gcoeff(:)%j = (-(c(57)*M(5,:)%j)+c(56)*M(7,:)%j) * den(49)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(520),h0tab(:,520),[28,1,2],[nMT,nMH,nMT],3,1,wf8(:,95))
  call Hloop_AV_Q(ntryL,G0H32(1),wf8(:,95),G0H4(7),m3h8x4(:,63),heltab2x32(:,:,514))
  call Hloop_A_Q(ntryL,G0H4(7),28,nMT,G1H4(53),n2h4(216))
  Gcoeff(:)%j = (c(57)*M(5,:)%j-c(56)*M(7,:)%j) * den(49)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(521),h0tab(:,521),[28,1,2],[nMT,nMZ,nMT],3,1,wf8(:,95))
  call Hloop_AV_Q(ntryL,G0H32(1),wf8(:,95),G0H4(7),m3h8x4(:,64),heltab2x32(:,:,515))
  call Hloop_A_Q(ntryL,G0H4(7),28,nMT,G1H4(56),n2h4(217))
  Gcoeff(:)%j = (c(45)*M(5,:)%j-c(44)*M(7,:)%j) * den(49)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(522),h0tab(:,522),[28,1,2],[nMB,nMW,nMB],3,1,wf8(:,95))
  call Hloop_AV_Q(ntryL,G0H32(1),wf8(:,95),G0H4(7),m3h8x4(:,65),heltab2x32(:,:,516))
  call Hloop_A_Q(ntryL,G0H4(7),28,nMB,G1H4(66),n2h4(218))
  Gcoeff(:)%j = (-(c(11)*M(7,:)%j)) * den(49)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(523),h0tab(:,523),[28,1,2],[nMT,0,nMT],3,1,wf8(:,95))
  call Hloop_AV_Q(ntryL,G0H32(1),wf8(:,95),G0H4(7),m3h8x4(:,66),heltab2x32(:,:,517))
  call Hloop_A_Q(ntryL,G0H4(7),28,nMT,G1H4(68),n2h4(219))
  Gcoeff(:)%j = (c(16)*M(7,:)%j) * den(101)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(524),h0tab(:,524),[28,1,2],[nMT,0,nMT],3,1,wf8(:,137))
  call Hloop_AZ_Q(ntryL,G0H32(1),wf8(:,137),G0H4(7),ngZu,m3h8x4(:,67),heltab2x32(:,:,518))
  call Hloop_A_Q(ntryL,G0H4(7),28,nMT,G1H4(73),n2h4(220))
  Gcoeff(:)%j = (c(13)*M(5,:)%j-c(12)*M(7,:)%j) * den(49)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(525),h0tab(:,525),[28,1,2],[nMT,0,nMT],3,1,wf8(:,95))
  call Hloop_AV_Q(ntryL,G0H32(1),wf8(:,95),G0H4(7),m3h8x4(:,68),heltab2x32(:,:,519))
  call Hloop_A_Q(ntryL,G0H4(7),28,nMT,G1H4(91),n2h4(221))
  Gcoeff(:)%j = (c(15)*M(5,:)%j-c(14)*M(7,:)%j) * den(49)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(526),h0tab(:,526),[28,1,2],[nMT,nMZ,nMT],3,1,wf8(:,95))
  call Hloop_AV_Q(ntryL,G0H32(1),wf8(:,95),G0H4(7),m3h8x4(:,69),heltab2x32(:,:,520))
  call Hloop_A_Q(ntryL,G0H4(7),28,nMT,G1H4(83),n2h4(222))
  Gcoeff(:)%j = (c(40)*M(5,:)%j-c(39)*M(7,:)%j) * den(49)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(527),h0tab(:,527),[28,1,2],[nMB,nMW,nMB],3,1,wf8(:,95))
  call Hloop_AV_Q(ntryL,G0H32(1),wf8(:,95),G0H4(7),m3h8x4(:,70),heltab2x32(:,:,521))
  call Hloop_A_Q(ntryL,G0H4(7),28,nMB,G1H4(86),n2h4(223))
  Gcoeff(:)%j = (-(c(27)*M(6,:)%j)+c(26)*M(8,:)%j) * den(49)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(528),h0tab(:,528),[28,1,2],[nMT,0,nMT],3,1,wf8(:,95))
  call Hloop_AV_Q(ntryL,G0H32(1),wf8(:,95),G0H4(7),m3h8x4(:,71),heltab2x32(:,:,522))
  call Hloop_A_Q(ntryL,G0H4(7),28,nMT,G1H4(96),n2h4(224))
  Gcoeff(:)%j = (-(c(22)*M(6,:)%j)+c(20)*M(8,:)%j) * den(49)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(529),h0tab(:,529),[28,1,2],[0,nMT,0],3,1,wf8(:,95))
  call Hloop_UV_W(ntryL,G0H32(1),0,wf8(:,95),28,G1H4(97),m3h8x4(:,72),heltab2x32(:,:,523))
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(136),[G1H4(113),G1H4(12),G1H4(23),G0H4(3),G0H4(2) &
    ,G0H4(1)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H8(60),[G1H8(1)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H8(61),[G1H8(7)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H8(70),[G1H8(67),G1H8(65),G1H8(17)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H8(66),[G1H8(20)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H8(16),[G1H8(25)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H8(18),[G1H8(32)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(97),[G1H4(81),G1H4(25),G0H4(6),G0H4(5),G0H4(4)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H16(33),[G1H16(29),G1H16(14),G1H16(9),G1H16(12),G1H16(56)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H16(30),[G1H16(13),G1H16(68)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H16(36),[G1H16(31),G1H16(16),G1H16(8),G1H16(19),G1H16(6)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H16(34),[G1H16(11),G1H16(5)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H16(35),[G1H16(15),G1H16(20)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H16(37),[G1H16(17),G1H16(75)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H8(15),[G1H8(10),G1H8(6)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H16(57),[G1H16(54),G1H16(52)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H16(62),[G1H16(59)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H16(88),[G1H16(85),G1H16(83)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H16(91),[G1H16(89)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(41),[G1H4(3),G1H4(144)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(42),[G1H4(4),G1H4(1)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(54),[G1H4(134),G1H4(2)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(135),[G1H4(67),G1H4(60),G1H4(55),G1H4(106),G1H4(94) &
    ,G1H4(112),G1H4(70),G1H4(72),G1H4(143),G1H4(29),G1H4(26),G1H4(11),G1H4(5)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(123),[G1H4(77),G1H4(6)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(124),[G1H4(103),G1H4(8)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G0H8(38),[G0H8(35),G0H8(33)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G0H8(18),[G0H8(50),G0H8(47)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H16(120),[G1H16(117),G1H16(115)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H16(123),[G1H16(121)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H16(136),[G1H16(133),G1H16(131)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H16(139),[G1H16(137)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(53),[G1H4(28),G1H4(13)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(56),[G1H4(39),G1H4(14)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(66),[G1H4(40),G1H4(17)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(96),[G1H4(91),G1H4(73),G1H4(68),G1H4(47),G1H4(38) &
    ,G1H4(75),G1H4(52),G1H4(100),G1H4(45),G1H4(27),G1H4(22),G1H4(24),G1H4(18)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(83),[G1H4(57),G1H4(19)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(86),[G1H4(69),G1H4(20)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(48),[G1H4(36),G1H4(85),G1H4(88)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(76),[G1H4(15),G1H4(10),G1H4(141)])
  call Hloop_VQ_A(ntryL,G1H4(136),ex3(:),G1H2(144),m3h2x2(:,250),heltab2x4(:,:,316))
  call Hloop_Q_A(ntryL,G1H2(144),23,nMB,G2H2(92),n2h2(175))
  call Hloop_VA_Q(ntryL,G1H4(30),ex4(:),G1H2(69),m3h2x2(:,251),heltab2x4(:,:,317))
  call Hloop_A_Q(ntryL,G1H2(69),27,nMB,G2H2(47),n2h2(176))
  call Hloop_QS_A(ntryL,G1H8(60),wf4(:,3),G1H2(145),ngH,m3h4x2(:,39),heltab2x8(:,:,233))
  call Hloop_Q_A(ntryL,G1H2(145),23,nMB,G2H2(44),n2h2(177))
  call Hloop_QS_A(ntryL,G1H8(61),wf4(:,6),G1H2(87),ngX,m3h4x2(:,40),heltab2x8(:,:,234))
  call Hloop_Q_A(ntryL,G1H2(87),23,nMB,G2H2(41),n2h2(178))
  call Hloop_QV_A(ntryL,G1H8(70),wf4(:,1),G1H2(152),m3h4x2(:,41),heltab2x8(:,:,235))
  call Hloop_Q_A(ntryL,G1H2(152),23,nMB,G2H2(38),n2h2(179))
  call Hloop_QZ_A(ntryL,G1H8(66),wf4(:,7),G1H2(93),ngZd,m3h4x2(:,42),heltab2x8(:,:,236))
  call Hloop_Q_A(ntryL,G1H2(93),23,nMB,G2H2(112),n2h2(180))
  call Hloop_QS_A(ntryL,G1H8(16),wf4(:,11),G1H2(156),ngPbt,m3h4x2(:,43),heltab2x8(:,:,237))
  call Hloop_Q_A(ntryL,G1H2(156),23,nMB,G2H2(109),n2h2(181))
  call Hloop_QW_A(ntryL,G1H8(18),wf4(:,13),G1H2(193),m3h4x2(:,44),heltab2x8(:,:,238))
  call Hloop_Q_A(ntryL,G1H2(193),23,nMB,G2H2(102),n2h2(182))
  call Hloop_AS_Q(ntryL,G1H8(38),wf4(:,14),G1H2(194),ngPtb,m3h4x2(:,45),heltab2x8(:,:,239))
  call Hloop_A_Q(ntryL,G1H2(194),27,nMB,G2H2(53),n2h2(183))
  call Hloop_AW_Q(ntryL,G1H8(44),wf4(:,17),G1H2(200),m3h4x2(:,46),heltab2x8(:,:,240))
  call Hloop_A_Q(ntryL,G1H2(200),27,nMB,G2H2(50),n2h2(184))
  call Hloop_QS_A(ntryL,G1H8(50),wf4(:,18),G1H2(204),ngH,m3h4x2(:,47),heltab2x8(:,:,241))
  call Hloop_Q_A(ntryL,G1H2(204),29,nMT,G2H2(124),n2h2(185))
  call Hloop_QS_A(ntryL,G1H8(36),wf4(:,19),G1H2(39),ngX,m3h4x2(:,48),heltab2x8(:,:,242))
  call Hloop_Q_A(ntryL,G1H2(39),29,nMT,G2H2(65),n2h2(186))
  call Hloop_QV_A(ntryL,G1H8(5),wf4(:,2),G1H2(163),m3h4x2(:,49),heltab2x8(:,:,243))
  call Hloop_Q_A(ntryL,G1H2(163),29,nMT,G2H2(62),n2h2(187))
  call Hloop_QZ_A(ntryL,G1H8(57),wf4(:,20),G1H2(45),ngZu,m3h4x2(:,50),heltab2x8(:,:,244))
  call Hloop_Q_A(ntryL,G1H2(45),29,nMT,G2H2(59),n2h2(188))
  call Hloop_VQ_A(ntryL,G1H4(97),ex1(:),G1H2(164),m3h2x2(:,252),heltab2x4(:,:,318))
  call Hloop_Q_A(ntryL,G1H2(164),29,nMT,G2H2(56),n2h2(189))
  call Hloop_AS_Q(ntryL,G1H16(71),wf4(:,3),G1H4(98),ngH,m3h4x4(:,23),heltab2x16(:,:,131))
  call Hloop_A_Q(ntryL,G1H4(98),19,nMT,G2H4(45),n2h4(225))
  call Hloop_QS_A(ntryL,G1H16(72),wf4(:,3),G1H4(104),ngH,m3h4x4(:,24),heltab2x16(:,:,132))
  call Hloop_Q_A(ntryL,G1H4(104),19,nMT,G2H4(50),n2h4(226))
  call Hloop_AS_Q(ntryL,G1H16(73),wf4(:,3),G1H4(107),ngH,m3h4x4(:,25),heltab2x16(:,:,133))
  call Hloop_A_Q(ntryL,G1H4(107),19,nMB,G2H4(48),n2h4(227))
  call Hloop_QS_A(ntryL,G1H16(78),wf4(:,3),G1H4(108),ngH,m3h4x4(:,26),heltab2x16(:,:,134))
  call Hloop_Q_A(ntryL,G1H4(108),19,nMB,G2H4(49),n2h4(228))
  call Hloop_AS_Q(ntryL,G1H16(76),wf4(:,6),G1H4(121),ngX,m3h4x4(:,27),heltab2x16(:,:,135))
  call Hloop_A_Q(ntryL,G1H4(121),19,nMT,G2H4(51),n2h4(229))
  call Hloop_QS_A(ntryL,G1H16(77),wf4(:,6),G1H4(116),ngX,m3h4x4(:,28),heltab2x16(:,:,136))
  call Hloop_Q_A(ntryL,G1H4(116),19,nMT,G2H4(56),n2h4(230))
  call Hloop_AS_Q(ntryL,G1H16(79),wf4(:,6),G1H4(119),ngX,m3h4x4(:,29),heltab2x16(:,:,137))
  call Hloop_A_Q(ntryL,G1H4(119),19,nMB,G2H4(53),n2h4(231))
  call Hloop_QS_A(ntryL,G1H16(80),wf4(:,6),G1H4(128),ngX,m3h4x4(:,30),heltab2x16(:,:,138))
  call Hloop_Q_A(ntryL,G1H4(128),19,nMB,G2H4(54),n2h4(232))
  call Hloop_AV_Q(ntryL,G1H16(46),wf4(:,1),G1H4(126),m3h4x4(:,31),heltab2x16(:,:,139))
  call Hloop_A_Q(ntryL,G1H4(126),19,nMT,G2H4(55),n2h4(233))
  call Hloop_QV_A(ntryL,G1H16(32),wf4(:,1),G1H4(127),m3h4x4(:,32),heltab2x16(:,:,140))
  call Hloop_Q_A(ntryL,G1H4(127),19,nMT,G2H4(57),n2h4(234))
  call Hloop_AV_Q(ntryL,G1H16(10),wf4(:,1),G1H4(133),m3h4x4(:,33),heltab2x16(:,:,141))
  call Hloop_A_Q(ntryL,G1H4(133),19,nMB,G2H4(58),n2h4(235))
  call Hloop_QV_A(ntryL,G1H16(7),wf4(:,1),G1H4(139),m3h4x4(:,34),heltab2x16(:,:,142))
  call Hloop_Q_A(ntryL,G1H4(139),19,nMB,G2H4(59),n2h4(236))
  call Hloop_AV_Q(ntryL,G1H16(23),wf4(:,1),G1H4(137),m3h4x4(:,35),heltab2x16(:,:,143))
  call Hloop_A_Q(ntryL,G1H4(137),19,nMT,G2H4(60),n2h4(237))
  call Hloop_QV_A(ntryL,G1H16(45),wf4(:,1),G1H4(7),m3h4x4(:,36),heltab2x16(:,:,144))
  call Hloop_Q_A(ntryL,G1H4(7),19,nMT,G2H4(65),n2h4(238))
  call Hloop_AV_Q(ntryL,G1H16(42),wf4(:,1),G1H4(113),m3h4x4(:,37),heltab2x16(:,:,145))
  call Hloop_A_Q(ntryL,G1H4(113),19,nMB,G2H4(62),n2h4(239))
  call Hloop_QV_A(ntryL,G1H16(58),wf4(:,1),G1H4(12),m3h4x4(:,38),heltab2x16(:,:,146))
  call Hloop_Q_A(ntryL,G1H4(12),19,nMB,G2H4(63),n2h4(240))
  call Hloop_AV_Q(ntryL,G1H16(33),wf4(:,1),G1H4(23),m3h4x4(:,39),heltab2x16(:,:,147))
  call Hloop_A_Q(ntryL,G1H4(23),19,0,G2H4(64),n2h4(241))
  call Hloop_AV_Q(ntryL,G1H16(30),wf4(:,1),G1H4(81),m3h4x4(:,40),heltab2x16(:,:,148))
  call Hloop_A_Q(ntryL,G1H4(81),19,nMT,G2H4(66),n2h4(242))
  call Hloop_QV_A(ntryL,G1H16(36),wf4(:,1),G1H4(25),m3h4x4(:,41),heltab2x16(:,:,149))
  call Hloop_Q_A(ntryL,G1H4(25),19,0,G2H4(67),n2h4(243))
  call Hloop_QV_A(ntryL,G1H16(34),wf4(:,1),G1H4(3),m3h4x4(:,42),heltab2x16(:,:,150))
  call Hloop_Q_A(ntryL,G1H4(3),19,nMT,G2H4(68),n2h4(244))
  call Hloop_AV_Q(ntryL,G1H16(35),wf4(:,1),G1H4(144),m3h4x4(:,43),heltab2x16(:,:,151))
  call Hloop_A_Q(ntryL,G1H4(144),19,nMB,G2H4(47),n2h4(245))
  call Hloop_QV_A(ntryL,G1H16(37),wf4(:,1),G1H4(4),m3h4x4(:,44),heltab2x16(:,:,152))
  call Hloop_Q_A(ntryL,G1H4(4),19,nMB,G2H4(15),n2h4(246))
  call Hloop_AZ_Q(ntryL,G1H16(41),wf4(:,7),G1H4(1),ngZu,m3h4x4(:,45),heltab2x16(:,:,153))
  call Hloop_A_Q(ntryL,G1H4(1),19,0,G2H4(2),n2h4(247))
  call Hloop_AZ_Q(ntryL,G1H16(64),wf4(:,7),G1H4(134),ngZu,m3h4x4(:,46),heltab2x16(:,:,154))
  call Hloop_A_Q(ntryL,G1H4(134),19,nMT,G2H4(9),n2h4(248))
  call Hloop_QZ_A(ntryL,G1H16(63),wf4(:,7),G1H4(2),ngZu,m3h4x4(:,47),heltab2x16(:,:,155))
  call Hloop_Q_A(ntryL,G1H4(2),19,0,G2H4(4),n2h4(249))
  call Hloop_QZ_A(ntryL,G1H16(74),wf4(:,7),G1H4(67),ngZu,m3h4x4(:,48),heltab2x16(:,:,156))
  call Hloop_Q_A(ntryL,G1H4(67),19,nMT,G2H4(3),n2h4(250))
  call Hloop_AZ_Q(ntryL,G1H16(1),wf4(:,7),G1H4(60),ngZd,m3h4x4(:,49),heltab2x16(:,:,157))
  call Hloop_A_Q(ntryL,G1H4(60),19,0,G2H4(14),n2h4(251))
  call Hloop_AZ_Q(ntryL,G1H16(2),wf4(:,7),G1H4(55),ngZd,m3h4x4(:,50),heltab2x16(:,:,158))
  call Hloop_A_Q(ntryL,G1H4(55),19,nMB,G2H4(13),n2h4(252))
  call Hloop_QZ_A(ntryL,G1H16(3),wf4(:,7),G1H4(106),ngZd,m3h4x4(:,51),heltab2x16(:,:,159))
  call Hloop_Q_A(ntryL,G1H4(106),19,0,G2H4(6),n2h4(253))
  call Hloop_QZ_A(ntryL,G1H16(4),wf4(:,7),G1H4(94),ngZd,m3h4x4(:,52),heltab2x16(:,:,160))
  call Hloop_Q_A(ntryL,G1H4(94),19,nMB,G2H4(52),n2h4(254))
  call Hloop_AV_Q(ntryL,G1H16(18),wf4(:,1),G1H4(112),m3h4x4(:,53),heltab2x16(:,:,161))
  call Hloop_A_Q(ntryL,G1H4(112),19,0,G2H4(21),n2h4(255))
  call Hloop_AV_Q(ntryL,G1H16(22),wf4(:,1),G1H4(70),m3h4x4(:,54),heltab2x16(:,:,162))
  call Hloop_A_Q(ntryL,G1H4(70),19,nMT,G2H4(29),n2h4(256))
  call Hloop_QV_A(ntryL,G1H16(21),wf4(:,1),G1H4(72),m3h4x4(:,55),heltab2x16(:,:,163))
  call Hloop_Q_A(ntryL,G1H4(72),19,0,G2H4(44),n2h4(257))
  call Hloop_QV_A(ntryL,G1H16(24),wf4(:,1),G1H4(143),m3h4x4(:,56),heltab2x16(:,:,164))
  call Hloop_Q_A(ntryL,G1H4(143),19,nMT,G2H4(61),n2h4(258))
  call Hloop_AV_Q(ntryL,G1H16(25),wf4(:,1),G1H4(29),m3h4x4(:,57),heltab2x16(:,:,165))
  call Hloop_A_Q(ntryL,G1H4(29),19,0,G2H4(1),n2h4(259))
  call Hloop_AV_Q(ntryL,G1H16(26),wf4(:,1),G1H4(26),m3h4x4(:,58),heltab2x16(:,:,166))
  call Hloop_A_Q(ntryL,G1H4(26),19,nMB,G2H4(10),n2h4(260))
  call Hloop_QV_A(ntryL,G1H16(27),wf4(:,1),G1H4(11),m3h4x4(:,59),heltab2x16(:,:,167))
  call Hloop_Q_A(ntryL,G1H4(11),19,0,G2H4(5),n2h4(261))
  call Hloop_QV_A(ntryL,G1H16(28),wf4(:,1),G1H4(5),m3h4x4(:,60),heltab2x16(:,:,168))
  call Hloop_Q_A(ntryL,G1H4(5),19,nMB,G2H4(7),n2h4(262))
  call Hloop_DV_C(ntryL,G1H16(38),16,wf4(:,1),G2H4(8),m3h4x4(:,61),heltab2x16(:,:,169))
  call Hloop_CV_D(ntryL,G1H16(39),16,wf4(:,1),3,G2H4(11),m3h4x4(:,62),heltab2x16(:,:,170))
  call Hloop_UV_W(ntryL,G1H16(40),16,wf4(:,1),3,G2H4(12),m3h4x4(:,63),heltab2x16(:,:,171))
  call Hloop_QV_A(ntryL,G1H8(62),wf4(:,1),G1H2(51),m3h4x2(:,51),heltab2x8(:,:,245))
  call Hloop_Q_A(ntryL,G1H2(51),23,nMB,G2H2(118),n2h2(190))
  call Hloop_QV_A(ntryL,G1H8(63),wf4(:,1),G1H2(168),m3h4x2(:,52),heltab2x8(:,:,246))
  call Hloop_Q_A(ntryL,G1H2(168),23,nMB,G2H2(77),n2h2(191))
  call Hloop_QV_A(ntryL,G1H8(64),wf4(:,1),G1H2(57),m3h4x2(:,53),heltab2x8(:,:,247))
  call Hloop_Q_A(ntryL,G1H2(57),23,nMT,G2H2(74),n2h2(192))
  call Hloop_QV_A(ntryL,G1H8(68),wf4(:,1),G1H2(169),m3h4x2(:,54),heltab2x8(:,:,248))
  call Hloop_Q_A(ntryL,G1H2(169),23,nMB,G2H2(71),n2h2(193))
  call Hloop_QV_A(ntryL,G1H8(69),wf4(:,1),G1H2(174),m3h4x2(:,55),heltab2x8(:,:,249))
  call Hloop_Q_A(ntryL,G1H2(174),23,nMT,G2H2(68),n2h2(194))
  call Hloop_UV_W(ntryL,G0H8(3),20,wf4(:,1),3,G1H2(175),m3h4x2(:,56),heltab2x8(:,:,250))
  call Hloop_AS_Q(ntryL,G1H8(71),wf4(:,3),G1H2(105),ngH,m3h4x2(:,57),heltab2x8(:,:,251))
  call Hloop_A_Q(ntryL,G1H2(105),27,nMB,G2H2(98),n2h2(195))
  call Hloop_AS_Q(ntryL,G1H8(45),wf4(:,6),G1H2(133),ngX,m3h4x2(:,58),heltab2x8(:,:,252))
  call Hloop_A_Q(ntryL,G1H2(133),27,nMB,G2H2(89),n2h2(196))
  call Hloop_AV_Q(ntryL,G1H8(2),wf4(:,1),G1H2(111),m3h4x2(:,59),heltab2x8(:,:,253))
  call Hloop_A_Q(ntryL,G1H2(111),27,nMB,G2H2(86),n2h2(197))
  call Hloop_AV_Q(ntryL,G1H8(3),wf4(:,1),G1H2(139),m3h4x2(:,60),heltab2x8(:,:,254))
  call Hloop_A_Q(ntryL,G1H2(139),27,nMB,G2H2(83),n2h2(198))
  call Hloop_AV_Q(ntryL,G1H8(8),wf4(:,1),G1H2(27),m3h4x2(:,61),heltab2x8(:,:,255))
  call Hloop_A_Q(ntryL,G1H2(27),27,nMT,G2H2(80),n2h2(199))
  call Hloop_AV_Q(ntryL,G1H8(15),wf4(:,1),G1H2(52),m3h4x2(:,62),heltab2x8(:,:,256))
  call Hloop_A_Q(ntryL,G1H2(52),27,nMB,G2H2(136),n2h2(200))
  call Hloop_AZ_Q(ntryL,G1H8(9),wf4(:,7),G1H2(34),ngZd,m3h4x2(:,63),heltab2x8(:,:,257))
  call Hloop_A_Q(ntryL,G1H2(34),27,nMB,G2H2(133),n2h2(201))
  call Hloop_AV_Q(ntryL,G1H8(11),wf4(:,1),G1H2(28),m3h4x2(:,64),heltab2x8(:,:,258))
  call Hloop_A_Q(ntryL,G1H2(28),27,nMB,G2H2(130),n2h2(202))
  call Hloop_AV_Q(ntryL,G1H8(12),wf4(:,1),G1H2(29),m3h4x2(:,65),heltab2x8(:,:,259))
  call Hloop_A_Q(ntryL,G1H2(29),27,nMT,G2H2(107),n2h2(203))
  call Hloop_UV_W(ntryL,G0H8(15),24,wf4(:,1),3,G1H2(33),m3h4x2(:,66),heltab2x8(:,:,260))
  call Hloop_AQ_V(ntryL,G1H16(43),wf8(:,96),G1H2(35),m3h8x2(:,1),heltab2x16(:,:,172))
  call Hloop_AQ_V(ntryL,G1H16(49),wf8(:,97),G1H2(41),m3h8x2(:,2),heltab2x16(:,:,173))
  call Hloop_VQ_A(ntryL,G1H16(44),wf8(:,96),G1H2(47),m3h8x2(:,3),heltab2x16(:,:,174))
  call Hloop_Q_A(ntryL,G1H2(47),23,nMB,G2H2(104),n2h2(204))
  call Hloop_VQ_A(ntryL,G1H16(48),wf8(:,97),G1H2(89),m3h8x2(:,4),heltab2x16(:,:,175))
  call Hloop_Q_A(ntryL,G1H2(89),23,nMB,G2H2(49),n2h2(205))
  call Hloop_AQ_S(ntryL,G1H16(47),wf8(:,98),G1H2(53),ngH,m3h8x2(:,5),heltab2x16(:,:,176))
  call Hloop_AQ_S(ntryL,G1H16(50),wf8(:,98),G1H2(59),ngX,m3h8x2(:,6),heltab2x16(:,:,177))
  call Hloop_AQ_S(ntryL,G1H16(51),wf8(:,98),G1H2(75),ngPtb,m3h8x2(:,7),heltab2x16(:,:,178))
  call Hloop_AQ_V(ntryL,G1H16(57),wf8(:,98),G1H2(88),m3h8x2(:,8),heltab2x16(:,:,179))
  call Hloop_AQ_V(ntryL,G1H16(53),wf8(:,99),G1H2(82),m3h8x2(:,9),heltab2x16(:,:,180))
  call Hloop_AQ_Z(ntryL,G1H16(55),wf8(:,98),G1H2(76),ngZd,m3h8x2(:,10),heltab2x16(:,:,181))
  call Hloop_AQ_W(ntryL,G1H16(61),wf8(:,98),G1H2(81),m3h8x2(:,11),heltab2x16(:,:,182))
  call Hloop_VQ_A(ntryL,G1H16(62),wf8(:,98),G1H2(99),m3h8x2(:,12),heltab2x16(:,:,183))
  call Hloop_Q_A(ntryL,G1H2(99),23,nMB,G2H2(51),n2h2(206))
  call Hloop_VQ_A(ntryL,G1H16(60),wf8(:,99),G1H2(100),m3h8x2(:,13),heltab2x16(:,:,184))
  call Hloop_Q_A(ntryL,G1H2(100),23,nMB,G2H2(72),n2h2(207))
  call Hloop_AQ_V(ntryL,G1H16(67),ex3(:),G1H8(22),m3h2x8(:,109),heltab2x16(:,:,185))
  call Hloop_AQ_V(ntryL,G1H16(65),ex3(:),G1H8(23),m3h2x8(:,110),heltab2x16(:,:,186))
  call Hloop_VQ_A(ntryL,G1H16(66),ex3(:),G1H8(24),m3h2x8(:,111),heltab2x16(:,:,187))
  call Hloop_Q_A(ntryL,G1H8(24),20,nMB,G2H8(15),n2h8(129))
  call Hloop_VQ_A(ntryL,G1H16(70),ex3(:),G1H8(30),m3h2x8(:,112),heltab2x16(:,:,188))
  call Hloop_Q_A(ntryL,G1H8(30),20,nMB,G2H8(16),n2h8(130))
  call Hloop_AQ_S(ntryL,G1H16(69),ex3(:),G1H8(28),ngH,m3h2x8(:,113),heltab2x16(:,:,189))
  call Hloop_AQ_S(ntryL,G1H16(81),ex3(:),G1H8(29),ngX,m3h2x8(:,114),heltab2x16(:,:,190))
  call Hloop_AQ_S(ntryL,G1H16(82),ex3(:),G1H8(31),ngPtb,m3h2x8(:,115),heltab2x16(:,:,191))
  call Hloop_AQ_V(ntryL,G1H16(88),ex3(:),G1H8(33),m3h2x8(:,116),heltab2x16(:,:,192))
  call Hloop_AQ_V(ntryL,G1H16(84),ex3(:),G1H8(34),m3h2x8(:,117),heltab2x16(:,:,193))
  call Hloop_AQ_Z(ntryL,G1H16(86),ex3(:),G1H8(39),ngZd,m3h2x8(:,118),heltab2x16(:,:,194))
  call Hloop_AQ_W(ntryL,G1H16(87),ex3(:),G1H8(37),m3h2x8(:,119),heltab2x16(:,:,195))
  call Hloop_VQ_A(ntryL,G1H16(91),ex3(:),G1H8(40),m3h2x8(:,120),heltab2x16(:,:,196))
  call Hloop_Q_A(ntryL,G1H8(40),20,nMB,G2H8(17),n2h8(131))
  call Hloop_VQ_A(ntryL,G1H16(90),ex3(:),G1H8(41),m3h2x8(:,121),heltab2x16(:,:,197))
  call Hloop_Q_A(ntryL,G1H8(41),20,nMB,G2H8(18),n2h8(132))
  call Hloop_AQ_S(ntryL,G1H4(41),ex3(:),G1H2(101),ngH,m3h2x2(:,253),heltab2x4(:,:,319))
  call Hloop_AQ_S(ntryL,G1H4(42),ex3(:),G1H2(106),ngX,m3h2x2(:,254),heltab2x4(:,:,320))
  call Hloop_AQ_S(ntryL,G1H4(54),ex3(:),G1H2(107),ngPtb,m3h2x2(:,255),heltab2x4(:,:,321))
  call Hloop_AQ_V(ntryL,G1H4(135),ex3(:),G1H2(112),m3h2x2(:,256),heltab2x4(:,:,322))
  call Hloop_AQ_Z(ntryL,G1H4(123),ex3(:),G1H2(113),ngZd,m3h2x2(:,257),heltab2x4(:,:,323))
  call Hloop_AQ_W(ntryL,G1H4(124),ex3(:),G1H2(117),m3h2x2(:,258),heltab2x4(:,:,324))
  call Hloop_VQ_A(ntryL,G0H8(19),ex1(:),G0H4(7),m3h2x4(:,195),heltab2x8(:,:,261))
  call Hloop_Q_A(ntryL,G0H4(7),25,nMT,G1H4(77),n2h4(263))
  call Hloop_VQ_A(ntryL,G0H8(20),ex1(:),G0H4(3),m3h2x4(:,196),heltab2x8(:,:,262))
  call Hloop_Q_A(ntryL,G0H4(3),25,nMT,G1H4(6),n2h4(264))
  call Hloop_AQ_V(ntryL,G1H16(92),wf8(:,104),G1H2(118),m3h8x2(:,14),heltab2x16(:,:,198))
  call Hloop_VQ_A(ntryL,G1H16(93),wf8(:,104),G1H2(119),m3h8x2(:,15),heltab2x16(:,:,199))
  call Hloop_Q_A(ntryL,G1H2(119),23,nMB,G2H2(82),n2h2(208))
  call Hloop_AQ_V(ntryL,G1H16(94),wf8(:,105),G1H2(123),m3h8x2(:,16),heltab2x16(:,:,200))
  call Hloop_VQ_A(ntryL,G1H16(95),wf8(:,105),G1H2(124),m3h8x2(:,17),heltab2x16(:,:,201))
  call Hloop_Q_A(ntryL,G1H2(124),23,nMB,G2H2(99),n2h2(209))
  call Hloop_AQ_V(ntryL,G1H16(96),ex1(:),G1H8(42),m3h2x8(:,122),heltab2x16(:,:,202))
  call Hloop_VQ_A(ntryL,G1H16(97),ex1(:),G1H8(43),m3h2x8(:,123),heltab2x16(:,:,203))
  call Hloop_Q_A(ntryL,G1H8(43),17,nMT,G2H8(19),n2h8(133))
  call Hloop_AQ_V(ntryL,G1H16(98),ex1(:),G1H8(46),m3h2x8(:,124),heltab2x16(:,:,204))
  call Hloop_VQ_A(ntryL,G1H16(99),ex1(:),G1H8(47),m3h2x8(:,125),heltab2x16(:,:,205))
  call Hloop_Q_A(ntryL,G1H8(47),17,nMT,G2H8(20),n2h8(134))
  call Hloop_VQ_A(ntryL,G0H8(22),ex3(:),G0H4(2),m3h2x4(:,197),heltab2x8(:,:,263))
  call Hloop_Q_A(ntryL,G0H4(2),22,nMB,G1H4(103),n2h4(265))
  call Hloop_VQ_A(ntryL,G0H8(23),ex3(:),G0H4(1),m3h2x4(:,198),heltab2x8(:,:,264))
  call Hloop_Q_A(ntryL,G0H4(1),22,nMB,G1H4(8),n2h4(266))
  call Hloop_VA_Q(ntryL,G0H8(24),ex2(:),G0H4(6),m3h2x4(:,199),heltab2x8(:,:,265))
  call Hloop_A_Q(ntryL,G0H4(6),22,nMT,G1H4(28),n2h4(267))
  call Hloop_VA_Q(ntryL,G0H8(25),ex2(:),G0H4(5),m3h2x4(:,200),heltab2x8(:,:,266))
  call Hloop_A_Q(ntryL,G0H4(5),22,nMT,G1H4(13),n2h4(268))
  call Hloop_AQ_V(ntryL,G1H16(100),ex3(:),G1H8(48),m3h2x8(:,126),heltab2x16(:,:,206))
  call Hloop_VQ_A(ntryL,G1H16(101),ex3(:),G1H8(49),m3h2x8(:,127),heltab2x16(:,:,207))
  call Hloop_Q_A(ntryL,G1H8(49),20,nMB,G2H8(21),n2h8(135))
  call Hloop_AQ_V(ntryL,G1H16(102),ex3(:),G1H8(51),m3h2x8(:,128),heltab2x16(:,:,208))
  call Hloop_VQ_A(ntryL,G1H16(103),ex3(:),G1H8(52),m3h2x8(:,129),heltab2x16(:,:,209))
  call Hloop_Q_A(ntryL,G1H8(52),20,nMB,G2H8(22),n2h8(136))
  call Hloop_QA_V(ntryL,G1H16(104),ex2(:),G1H8(14),m3h2x8(:,130),heltab2x16(:,:,210))
  call Hloop_VA_Q(ntryL,G1H16(105),ex2(:),G1H8(26),m3h2x8(:,131),heltab2x16(:,:,211))
  call Hloop_A_Q(ntryL,G1H8(26),18,nMT,G2H8(23),n2h8(137))
  call Hloop_QA_V(ntryL,G1H16(106),ex2(:),G1H8(4),m3h2x8(:,132),heltab2x16(:,:,212))
  call Hloop_VA_Q(ntryL,G1H16(107),ex2(:),G1H8(13),m3h2x8(:,133),heltab2x16(:,:,213))
  call Hloop_A_Q(ntryL,G1H8(13),18,nMT,G2H8(24),n2h8(138))
  call Hloop_VA_Q(ntryL,G0H8(30),ex2(:),G0H4(4),m3h2x4(:,201),heltab2x8(:,:,267))
  call Hloop_A_Q(ntryL,G0H4(4),19,nMT,G1H4(39),n2h4(269))
  call Hloop_VA_Q(ntryL,G0H8(28),ex2(:),G0H4(7),m3h2x4(:,202),heltab2x8(:,:,268))
  call Hloop_A_Q(ntryL,G0H4(7),19,nMT,G1H4(14),n2h4(270))
  call Hloop_SA_Q(ntryL,G0H8(29),ex2(:),G0H4(3),ngH,m3h2x4(:,203),heltab2x8(:,:,269))
  call Hloop_A_Q(ntryL,G0H4(3),19,nMT,G1H4(40),n2h4(271))
  call Hloop_SA_Q(ntryL,G0H8(31),ex2(:),G0H4(2),ngX,m3h2x4(:,204),heltab2x8(:,:,270))
  call Hloop_A_Q(ntryL,G0H4(2),19,nMT,G1H4(17),n2h4(272))
  call Hloop_SA_Q(ntryL,G0H8(32),ex2(:),G0H4(1),ngPtb,m3h2x4(:,205),heltab2x8(:,:,271))
  call Hloop_A_Q(ntryL,G0H4(1),19,nMB,G1H4(91),n2h4(273))
  call Hloop_VA_Q(ntryL,G0H8(38),ex2(:),G0H4(6),m3h2x4(:,206),heltab2x8(:,:,272))
  call Hloop_A_Q(ntryL,G0H4(6),19,nMT,G1H4(73),n2h4(274))
  call Hloop_VA_Q(ntryL,G0H8(34),ex2(:),G0H4(5),m3h2x4(:,207),heltab2x8(:,:,273))
  call Hloop_A_Q(ntryL,G0H4(5),19,nMT,G1H4(68),n2h4(275))
  call Hloop_ZA_Q(ntryL,G0H8(36),ex2(:),G0H4(4),ngZu,m3h2x4(:,208),heltab2x8(:,:,274))
  call Hloop_A_Q(ntryL,G0H4(4),19,nMT,G1H4(47),n2h4(276))
  call Hloop_WA_Q(ntryL,G0H8(37),ex2(:),G0H4(7),m3h2x4(:,209),heltab2x8(:,:,275))
  call Hloop_A_Q(ntryL,G0H4(7),19,nMB,G1H4(38),n2h4(277))
  call Hloop_QA_V(ntryL,G1H8(19),ex2(:),G1H4(75),m3h2x4(:,210),heltab2x8(:,:,276))
  call Hloop_VQ_A(ntryL,G0H8(41),ex1(:),G0H4(3),m3h2x4(:,211),heltab2x8(:,:,277))
  call Hloop_Q_A(ntryL,G0H4(3),19,nMT,G1H4(52),n2h4(278))
  call Hloop_VQ_A(ntryL,G0H8(42),ex1(:),G0H4(2),m3h2x4(:,212),heltab2x8(:,:,278))
  call Hloop_Q_A(ntryL,G0H4(2),19,nMT,G1H4(100),n2h4(279))
  call Hloop_SQ_A(ntryL,G0H8(44),ex1(:),G0H4(1),ngH,m3h2x4(:,213),heltab2x8(:,:,279))
  call Hloop_Q_A(ntryL,G0H4(1),19,nMT,G1H4(45),n2h4(280))
  call Hloop_SQ_A(ntryL,G0H8(45),ex1(:),G0H4(6),ngX,m3h2x4(:,214),heltab2x8(:,:,280))
  call Hloop_Q_A(ntryL,G0H4(6),19,nMT,G1H4(27),n2h4(281))
  call Hloop_SQ_A(ntryL,G0H8(46),ex1(:),G0H4(5),ngPbt,m3h2x4(:,215),heltab2x8(:,:,281))
  call Hloop_Q_A(ntryL,G0H4(5),19,nMB,G1H4(22),n2h4(282))
  call Hloop_VQ_A(ntryL,G0H8(18),ex1(:),G0H4(4),m3h2x4(:,216),heltab2x8(:,:,282))
  call Hloop_Q_A(ntryL,G0H4(4),19,nMT,G1H4(24),n2h4(283))
  call Hloop_VQ_A(ntryL,G0H8(52),ex1(:),G0H4(7),m3h2x4(:,217),heltab2x8(:,:,283))
  call Hloop_Q_A(ntryL,G0H4(7),19,nMT,G1H4(18),n2h4(284))
  call Hloop_ZQ_A(ntryL,G0H8(51),ex1(:),G0H4(3),ngZu,m3h2x4(:,218),heltab2x8(:,:,284))
  call Hloop_Q_A(ntryL,G0H4(3),19,nMT,G1H4(57),n2h4(285))
  call Hloop_WQ_A(ntryL,G0H8(53),ex1(:),G0H4(2),m3h2x4(:,219),heltab2x8(:,:,285))
  call Hloop_Q_A(ntryL,G0H4(2),19,nMB,G1H4(19),n2h4(286))
  call Hloop_AQ_V(ntryL,G1H8(21),ex1(:),G1H4(69),m3h2x4(:,220),heltab2x8(:,:,286))
  call Hloop_QA_V(ntryL,G1H16(108),ex2(:),G1H8(27),m3h2x8(:,134),heltab2x16(:,:,214))
  call Hloop_QA_V(ntryL,G1H16(109),ex2(:),G1H8(35),m3h2x8(:,135),heltab2x16(:,:,215))
  call Hloop_VA_Q(ntryL,G1H16(110),ex2(:),G1H8(53),m3h2x8(:,136),heltab2x16(:,:,216))
  call Hloop_A_Q(ntryL,G1H8(53),18,nMT,G2H8(1),n2h8(139))
  call Hloop_VA_Q(ntryL,G1H16(111),ex2(:),G1H8(54),m3h2x8(:,137),heltab2x16(:,:,217))
  call Hloop_A_Q(ntryL,G1H8(54),18,nMT,G2H8(2),n2h8(140))
  call Hloop_QA_S(ntryL,G1H16(112),ex2(:),G1H8(55),ngH,m3h2x8(:,138),heltab2x16(:,:,218))
  call Hloop_QA_S(ntryL,G1H16(113),ex2(:),G1H8(56),ngX,m3h2x8(:,139),heltab2x16(:,:,219))
  call Hloop_QA_S(ntryL,G1H16(114),ex2(:),G1H8(58),ngPtb,m3h2x8(:,140),heltab2x16(:,:,220))
  call Hloop_QA_V(ntryL,G1H16(120),ex2(:),G1H8(59),m3h2x8(:,141),heltab2x16(:,:,221))
  call Hloop_QA_V(ntryL,G1H16(116),ex2(:),G1H8(1),m3h2x8(:,142),heltab2x16(:,:,222))
  call Hloop_QA_Z(ntryL,G1H16(118),ex2(:),G1H8(7),ngZu,m3h2x8(:,143),heltab2x16(:,:,223))
  call Hloop_QA_W(ntryL,G1H16(119),ex2(:),G1H8(67),m3h2x8(:,144),heltab2x16(:,:,224))
  call Hloop_VA_Q(ntryL,G1H16(123),ex2(:),G1H8(65),m3h2x8(:,145),heltab2x16(:,:,225))
  call Hloop_A_Q(ntryL,G1H8(65),18,nMT,G2H8(3),n2h8(141))
  call Hloop_VA_Q(ntryL,G1H16(122),ex2(:),G1H8(17),m3h2x8(:,146),heltab2x16(:,:,226))
  call Hloop_A_Q(ntryL,G1H8(17),18,nMT,G2H8(4),n2h8(142))
  call Hloop_AQ_V(ntryL,G1H16(124),ex1(:),G1H8(20),m3h2x8(:,147),heltab2x16(:,:,227))
  call Hloop_AQ_V(ntryL,G1H16(125),ex1(:),G1H8(25),m3h2x8(:,148),heltab2x16(:,:,228))
  call Hloop_VQ_A(ntryL,G1H16(126),ex1(:),G1H8(32),m3h2x8(:,149),heltab2x16(:,:,229))
  call Hloop_Q_A(ntryL,G1H8(32),17,nMT,G2H8(5),n2h8(143))
  call Hloop_VQ_A(ntryL,G1H16(127),ex1(:),G1H8(10),m3h2x8(:,150),heltab2x16(:,:,230))
  call Hloop_Q_A(ntryL,G1H8(10),17,nMT,G2H8(6),n2h8(144))
  call Hloop_AQ_S(ntryL,G1H16(128),ex1(:),G1H8(6),ngH,m3h2x8(:,151),heltab2x16(:,:,231))
  call Hloop_AQ_S(ntryL,G1H16(129),ex1(:),G1H8(60),ngX,m3h2x8(:,152),heltab2x16(:,:,232))
  call Hloop_AQ_S(ntryL,G1H16(130),ex1(:),G1H8(61),ngPbt,m3h2x8(:,153),heltab2x16(:,:,233))
  call Hloop_AQ_V(ntryL,G1H16(136),ex1(:),G1H8(70),m3h2x8(:,154),heltab2x16(:,:,234))
  call Hloop_AQ_V(ntryL,G1H16(132),ex1(:),G1H8(66),m3h2x8(:,155),heltab2x16(:,:,235))
  call Hloop_AQ_Z(ntryL,G1H16(134),ex1(:),G1H8(16),ngZu,m3h2x8(:,156),heltab2x16(:,:,236))
  call Hloop_AQ_W(ntryL,G1H16(135),ex1(:),G1H8(18),m3h2x8(:,157),heltab2x16(:,:,237))
  call Hloop_VQ_A(ntryL,G1H16(139),ex1(:),G1H8(38),m3h2x8(:,158),heltab2x16(:,:,238))
  call Hloop_Q_A(ntryL,G1H8(38),17,nMT,G2H8(7),n2h8(145))
  call Hloop_VQ_A(ntryL,G1H16(138),ex1(:),G1H8(44),m3h2x8(:,159),heltab2x16(:,:,239))
  call Hloop_Q_A(ntryL,G1H8(44),17,nMT,G2H8(8),n2h8(146))
  call Hloop_AQ_S(ntryL,G1H4(53),ex1(:),G1H2(125),ngH,m3h2x2(:,259),heltab2x4(:,:,325))
  call Hloop_AQ_S(ntryL,G1H4(56),ex1(:),G1H2(129),ngX,m3h2x2(:,260),heltab2x4(:,:,326))
  call Hloop_AQ_S(ntryL,G1H4(66),ex1(:),G1H2(130),ngPbt,m3h2x2(:,261),heltab2x4(:,:,327))
  call Hloop_AQ_V(ntryL,G1H4(96),ex1(:),G1H2(131),m3h2x2(:,262),heltab2x4(:,:,328))
  call Hloop_AQ_Z(ntryL,G1H4(83),ex1(:),G1H2(153),ngZu,m3h2x2(:,263),heltab2x4(:,:,329))
  call Hloop_AQ_W(ntryL,G1H4(86),ex1(:),G1H2(159),m3h2x2(:,264),heltab2x4(:,:,330))
  call Hloop_QA_V(ntryL,G1H4(48),ex2(:),G1H2(165),m3h2x2(:,265),heltab2x4(:,:,331))
  call Hloop_AQ_V(ntryL,G1H4(76),ex1(:),G1H2(178),m3h2x2(:,266),heltab2x4(:,:,332))
call HGT_w2_OLR(G1H2(218),1,1,2)
call HGT_w2_invQ_OLR(G1H2(218),2,5,2)
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(218),[G1H2(33)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(99),[G2H2(82),G2H2(72),G2H2(51),G2H2(49),G2H2(104) &
    ,G2H2(122),G2H2(119),G2H2(116),G2H2(113),G2H2(110),G2H2(106),G2H2(85)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(175),[G1H2(92)])
call HGT_w2_OLR(G1H2(228),1,1,2)
call HGT_w2_invQ_OLR(G1H2(228),2,5,2)
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(228),[G1H2(175)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(128),[G2H2(125),G2H2(96)])
call HGT_w2_OLR(G1H4(111),1,1,4)
call HGT_w2_invQ_OLR(G1H4(111),2,5,4)
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(111),[G1H4(77)])
call HGT_w2_OLR(G1H4(117),1,1,4)
call HGT_w2_invQ_OLR(G1H4(117),2,5,4)
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(117),[G1H4(6)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(28),[G1H4(49)])
call HGT_w2_OLR(G1H4(32),1,1,4)
call HGT_w2_invQ_OLR(G1H4(32),2,5,4)
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(32),[G1H4(28)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(13),[G1H4(61)])
call HGT_w2_OLR(G1H4(37),1,1,4)
call HGT_w2_invQ_OLR(G1H4(37),2,5,4)
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(37),[G1H4(13)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(52),[G1H4(59)])
call HGT_w2_OLR(G1H4(80),1,1,4)
call HGT_w2_invQ_OLR(G1H4(80),2,5,4)
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(80),[G1H4(52)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(140),[G2H2(137),G2H2(134),G2H2(131)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(100),[G1H4(74)])
call HGT_w2_OLR(G1H4(102),1,1,4)
call HGT_w2_invQ_OLR(G1H4(102),2,5,4)
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(102),[G1H4(100)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(24),[G1H4(120)])
call HGT_w2_OLR(G1H4(115),1,1,4)
call HGT_w2_invQ_OLR(G1H4(115),2,5,4)
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(115),[G1H4(24)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(18),[G1H4(131)])
call HGT_w2_OLR(G1H4(125),1,1,4)
call HGT_w2_invQ_OLR(G1H4(125),2,5,4)
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(125),[G1H4(18)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(123),[G1H2(118),G1H2(82),G1H2(88),G1H2(41),G1H2(35) &
    ,G1H2(217),G1H2(116),G1H2(96)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(178),[G1H2(115)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(112),[G1H2(216)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(107),[G1H2(229)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(75),[G1H2(230)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(117),[G1H2(240)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(81),[G1H2(25)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(101),[G1H2(73)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(53),[G1H2(74)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(106),[G1H2(84)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(59),[G1H2(85)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(113),[G1H2(186)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(76),[G1H2(187)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(103),[G1H4(118)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(8),[G1H4(92)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(39),[G1H4(129)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(55),[G1H4(130)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(14),[G1H4(142)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(60),[G1H4(9)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(40),[G1H4(16)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(9),[G2H4(66),G2H4(51),G2H4(45),G1H4(63),G1H4(34) &
    ,G1H4(21)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(47),[G1H4(17),G1H4(33)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(38),[G1H4(91),G1H4(46)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(13),[G2H4(47),G2H4(53),G2H4(48),G1H4(51)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(73),[G1H4(58)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(68),[G1H4(31)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(29),[G1H4(35)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(75),[G1H4(43)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(12),[G1H4(140),G1H4(44)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(57),[G1H4(62)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(65),[G1H4(79)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(45),[G1H4(89)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(3),[G2H4(68),G2H4(56),G2H4(50),G1H4(122),G1H4(109) &
    ,G1H4(90)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(57),[G1H4(27),G1H4(101)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(19),[G1H4(22),G1H4(110)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(52),[G2H4(15),G2H4(54),G2H4(49),G1H4(114)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(61),[G1H4(132)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(69),[G1H4(138)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(112),[G2H2(38),G2H2(41),G2H2(44)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(102),[G2H2(109)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(50),[G2H2(53)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(59),[G2H2(62),G2H2(65),G2H2(124)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(14),[G2H4(2),G2H4(64)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(6),[G2H4(4),G2H4(67)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(133),[G2H2(136),G2H2(89),G2H2(98)])
  call Hloop_VQ_A(ntryL,G1H2(218),ex3(:),G1H1(1),m3h2x1(:,336),heltab2x2(:,:,336))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,nMB,G2tensor(2),n2h1(307))
  call Hcheck_last_QA_V(ntryL,l_switch,G2H2(99),ex4(:),G2tensor(4),m3h2x1(:,337),heltab2x2(:,:,337))
  call Hloop_VA_Q(ntryL,G1H2(228),ex4(:),G1H1(1),m3h2x1(:,338),heltab2x2(:,:,338))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,nMB,G2tensor(14),n2h1(308))
  call Hcheck_last_AQ_V(ntryL,l_switch,G2H2(128),ex3(:),G2tensor(6),m3h2x1(:,339),heltab2x2(:,:,339))
call HGT_w2_OLR(G1H4(87),1,1,4)
call HGT_w2_invQ_OLR(G1H4(87),2,5,4)
  call Hloop_QS_A(ntryL,G1H4(87),wf4(:,3),G1H1(1),ngH,m3h4x1(:,67),heltab2x4(:,:,333))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,nMB,G2tensor(16),n2h1(309))
call HGT_w2_OLR(G1H4(93),1,1,4)
call HGT_w2_invQ_OLR(G1H4(93),2,5,4)
  call Hloop_QS_A(ntryL,G1H4(93),wf4(:,6),G1H1(1),ngX,m3h4x1(:,68),heltab2x4(:,:,334))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,nMB,G2tensor(18),n2h1(310))
call HGT_w2_OLR(G1H4(99),1,1,4)
call HGT_w2_invQ_OLR(G1H4(99),2,5,4)
  call Hloop_QV_A(ntryL,G1H4(99),wf4(:,1),G1H1(1),m3h4x1(:,69),heltab2x4(:,:,335))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,nMB,G2tensor(26),n2h1(311))
call HGT_w2_OLR(G1H4(105),1,1,4)
call HGT_w2_invQ_OLR(G1H4(105),2,5,4)
  call Hloop_QZ_A(ntryL,G1H4(105),wf4(:,7),G1H1(1),ngZd,m3h4x1(:,70),heltab2x4(:,:,336))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,nMB,G2tensor(20),n2h1(312))
  call Hloop_QS_A(ntryL,G1H4(111),wf4(:,11),G1H1(1),ngPbt,m3h4x1(:,71),heltab2x4(:,:,337))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,nMB,G2tensor(30),n2h1(313))
  call Hloop_QW_A(ntryL,G1H4(117),wf4(:,13),G1H1(1),m3h4x1(:,72),heltab2x4(:,:,338))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,nMB,G2tensor(47),n2h1(314))
  call Hloop_AS_Q(ntryL,G1H4(32),wf4(:,14),G1H1(1),ngPtb,m3h4x1(:,73),heltab2x4(:,:,339))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,nMB,G2tensor(44),n2h1(315))
  call Hloop_AW_Q(ntryL,G1H4(37),wf4(:,17),G1H1(1),m3h4x1(:,74),heltab2x4(:,:,340))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,nMB,G2tensor(41),n2h1(316))
  call Hloop_QS_A(ntryL,G1H4(80),wf4(:,18),G1H1(1),ngH,m3h4x1(:,75),heltab2x4(:,:,341))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,nMT,G2tensor(43),n2h1(317))
  call Hcheck_last_QA_V(ntryL,l_switch,G2H2(140),ex2(:),G2tensor(296),m3h2x1(:,340),heltab2x2(:,:,340))
  call Hloop_QS_A(ntryL,G1H4(102),wf4(:,19),G1H1(1),ngX,m3h4x1(:,76),heltab2x4(:,:,342))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,nMT,G2tensor(68),n2h1(318))
  call Hloop_QV_A(ntryL,G1H4(115),wf4(:,2),G1H1(1),m3h4x1(:,77),heltab2x4(:,:,343))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,nMT,G2tensor(65),n2h1(319))
  call Hloop_QZ_A(ntryL,G1H4(125),wf4(:,20),G1H1(1),ngZu,m3h4x1(:,78),heltab2x4(:,:,344))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,nMT,G2tensor(56),n2h1(320))
  call Hloop_VA_Q(ntryL,G1H2(123),ex4(:),G1H1(1),m3h2x1(:,341),heltab2x2(:,:,341))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,nMB,G2tensor(53),n2h1(321))
  call Hloop_VA_Q(ntryL,G1H2(178),ex4(:),G1H1(1),m3h2x1(:,342),heltab2x2(:,:,342))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,nMB,G2tensor(55),n2h1(322))
  call Hloop_VQ_A(ntryL,G1H2(126),ex3(:),G1H1(1),m3h2x1(:,343),heltab2x2(:,:,343))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,nMB,G2tensor(70),n2h1(323))
  call Hloop_VQ_A(ntryL,G1H2(127),ex3(:),G1H1(1),m3h2x1(:,344),heltab2x2(:,:,344))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,nMB,G2tensor(71),n2h1(324))
  call Hloop_SQ_A(ntryL,G1H2(140),ex3(:),G1H1(1),ngPtb,m3h2x1(:,345),heltab2x2(:,:,345))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,nMT,G2tensor(218),n2h1(325))
  call Hloop_SQ_A(ntryL,G1H2(151),ex3(:),G1H1(1),ngPtb,m3h2x1(:,346),heltab2x2(:,:,346))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,nMT,G2tensor(76),n2h1(326))
  call Hloop_WQ_A(ntryL,G1H2(205),ex3(:),G1H1(1),m3h2x1(:,347),heltab2x2(:,:,347))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,nMT,G2tensor(73),n2h1(327))
  call Hloop_WQ_A(ntryL,G1H2(206),ex3(:),G1H1(1),m3h2x1(:,348),heltab2x2(:,:,348))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,nMT,G2tensor(341),n2h1(328))
  call Hloop_VA_Q(ntryL,G1H2(112),ex4(:),G1H1(1),m3h2x1(:,349),heltab2x2(:,:,349))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,nMB,G2tensor(329),n2h1(329))
  call Hloop_SA_Q(ntryL,G1H2(107),ex4(:),G1H1(1),ngPbt,m3h2x1(:,350),heltab2x2(:,:,350))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,nMT,G2tensor(326),n2h1(330))
  call Hloop_SA_Q(ntryL,G1H2(75),ex4(:),G1H1(1),ngPbt,m3h2x1(:,351),heltab2x2(:,:,351))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,nMT,G2tensor(77),n2h1(331))
  call Hloop_WA_Q(ntryL,G1H2(117),ex4(:),G1H1(1),m3h2x1(:,352),heltab2x2(:,:,352))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,nMT,G2tensor(74),n2h1(332))
  call Hloop_WA_Q(ntryL,G1H2(81),ex4(:),G1H1(1),m3h2x1(:,353),heltab2x2(:,:,353))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,nMT,G2tensor(79),n2h1(333))
  call Hloop_VA_Q(ntryL,G1H2(32),ex2(:),G1H1(1),m3h2x1(:,354),heltab2x2(:,:,354))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,nMT,G2tensor(80),n2h1(334))
  call Hloop_VA_Q(ntryL,G1H2(36),ex2(:),G1H1(1),m3h2x1(:,355),heltab2x2(:,:,355))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,nMT,G2tensor(226),n2h1(335))
  call Hloop_SQ_A(ntryL,G1H2(43),ex3(:),G1H1(1),ngH,m3h2x1(:,356),heltab2x2(:,:,356))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,nMB,G2tensor(85),n2h1(336))
  call Hloop_SQ_A(ntryL,G1H2(44),ex3(:),G1H1(1),ngH,m3h2x1(:,357),heltab2x2(:,:,357))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,nMB,G2tensor(82),n2h1(337))
  call Hloop_SQ_A(ntryL,G1H2(54),ex3(:),G1H1(1),ngX,m3h2x1(:,358),heltab2x2(:,:,358))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,nMB,G2tensor(317),n2h1(338))
  call Hloop_SQ_A(ntryL,G1H2(55),ex3(:),G1H1(1),ngX,m3h2x1(:,359),heltab2x2(:,:,359))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,nMB,G2tensor(305),n2h1(339))
  call Hloop_ZQ_A(ntryL,G1H2(62),ex3(:),G1H1(1),ngZd,m3h2x1(:,360),heltab2x2(:,:,360))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,nMB,G2tensor(302),n2h1(340))
  call Hloop_ZQ_A(ntryL,G1H2(66),ex3(:),G1H1(1),ngZd,m3h2x1(:,361),heltab2x2(:,:,361))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,nMB,G2tensor(86),n2h1(341))
  call Hloop_SA_Q(ntryL,G1H2(101),ex4(:),G1H1(1),ngH,m3h2x1(:,362),heltab2x2(:,:,362))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,nMB,G2tensor(83),n2h1(342))
  call Hloop_SA_Q(ntryL,G1H2(53),ex4(:),G1H1(1),ngH,m3h2x1(:,363),heltab2x2(:,:,363))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,nMB,G2tensor(88),n2h1(343))
  call Hloop_SA_Q(ntryL,G1H2(106),ex4(:),G1H1(1),ngX,m3h2x1(:,364),heltab2x2(:,:,364))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,nMB,G2tensor(89),n2h1(344))
  call Hloop_SA_Q(ntryL,G1H2(59),ex4(:),G1H1(1),ngX,m3h2x1(:,365),heltab2x2(:,:,365))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,nMB,G2tensor(97),n2h1(345))
  call Hloop_ZA_Q(ntryL,G1H2(113),ex4(:),G1H1(1),ngZd,m3h2x1(:,366),heltab2x2(:,:,366))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,nMB,G2tensor(229),n2h1(346))
  call Hloop_ZA_Q(ntryL,G1H2(76),ex4(:),G1H1(1),ngZd,m3h2x1(:,367),heltab2x2(:,:,367))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,nMB,G2tensor(103),n2h1(347))
  call Hloop_AS_Q(ntryL,G1H4(71),wf4(:,11),G1H1(1),ngPbt,m3h4x1(:,79),heltab2x4(:,:,345))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,nMT,G2tensor(100),n2h1(348))
  call Hloop_AS_Q(ntryL,G1H4(64),wf4(:,11),G1H1(1),ngPbt,m3h4x1(:,80),heltab2x4(:,:,346))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,nMT,G2tensor(119),n2h1(349))
  call Hloop_AW_Q(ntryL,G1H4(78),wf4(:,13),G1H1(1),m3h4x1(:,81),heltab2x4(:,:,347))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,nMT,G2tensor(116),n2h1(350))
  call Hloop_AW_Q(ntryL,G1H4(82),wf4(:,13),G1H1(1),m3h4x1(:,82),heltab2x4(:,:,348))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,nMT,G2tensor(113),n2h1(351))
  call Hloop_QS_A(ntryL,G1H4(103),wf4(:,14),G1H1(1),ngPtb,m3h4x1(:,83),heltab2x4(:,:,349))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,nMT,G2tensor(104),n2h1(352))
  call Hloop_QS_A(ntryL,G1H4(84),wf4(:,14),G1H1(1),ngPtb,m3h4x1(:,84),heltab2x4(:,:,350))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,nMT,G2tensor(101),n2h1(353))
  call Hloop_QW_A(ntryL,G1H4(8),wf4(:,17),G1H1(1),m3h4x1(:,85),heltab2x4(:,:,351))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,nMT,G2tensor(106),n2h1(354))
  call Hloop_QW_A(ntryL,G1H4(95),wf4(:,17),G1H1(1),m3h4x1(:,86),heltab2x4(:,:,352))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,nMT,G2tensor(109),n2h1(355))
  call Hloop_AS_Q(ntryL,G1H4(50),wf4(:,14),G1H1(1),ngPtb,m3h4x1(:,87),heltab2x4(:,:,353))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,nMB,G2tensor(112),n2h1(356))
  call Hloop_AW_Q(ntryL,G1H4(65),wf4(:,17),G1H1(1),m3h4x1(:,88),heltab2x4(:,:,354))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,nMB,G2tensor(213),n2h1(357))
  call Hloop_AS_Q(ntryL,G1H4(39),wf4(:,18),G1H1(1),ngH,m3h4x1(:,89),heltab2x4(:,:,355))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,nMT,G2tensor(121),n2h1(358))
  call Hloop_AS_Q(ntryL,G2H4(55),wf4(:,18),G2H1(1),ngH,m3h4x1(:,90),heltab2x4(:,:,356))
  call Hcheck_last_A_Q(ntryL,l_switch,G2H1(1),31,nMT,G3tensor(1),n2h1(359))
  call Hloop_AS_Q(ntryL,G1H4(14),wf4(:,19),G1H1(1),ngX,m3h4x1(:,91),heltab2x4(:,:,357))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,nMT,G2tensor(115),n2h1(360))
  call Hloop_AS_Q(ntryL,G2H4(60),wf4(:,19),G2H1(1),ngX,m3h4x1(:,92),heltab2x4(:,:,358))
  call Hcheck_last_A_Q(ntryL,l_switch,G2H1(1),31,nMT,G3tensor(2),n2h1(361))
  call Hloop_AV_Q(ntryL,G1H4(40),wf4(:,2),G1H1(1),m3h4x1(:,93),heltab2x4(:,:,359))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,nMT,G2tensor(118),n2h1(362))
  call Hloop_AV_Q(ntryL,G2H4(9),wf4(:,2),G2H1(1),m3h4x1(:,94),heltab2x4(:,:,360))
  call Hcheck_last_A_Q(ntryL,l_switch,G2H1(1),31,nMT,G3tensor(3),n2h1(363))
  call Hloop_AV_Q(ntryL,G1H4(47),wf4(:,2),G1H1(1),m3h4x1(:,95),heltab2x4(:,:,361))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,nMT,G2tensor(124),n2h1(364))
  call Hloop_AV_Q(ntryL,G1H4(38),wf4(:,2),G1H1(1),m3h4x1(:,96),heltab2x4(:,:,362))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,nMB,G2tensor(127),n2h1(365))
  call Hloop_AV_Q(ntryL,G2H4(13),wf4(:,2),G2H1(1),m3h4x1(:,97),heltab2x4(:,:,363))
  call Hcheck_last_A_Q(ntryL,l_switch,G2H1(1),31,nMB,G3tensor(4),n2h1(366))
  call Hloop_AV_Q(ntryL,G1H4(73),wf4(:,2),G1H1(1),m3h4x1(:,98),heltab2x4(:,:,364))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,nMT,G2tensor(130),n2h1(367))
  call Hloop_AZ_Q(ntryL,G1H4(68),wf4(:,20),G1H1(1),ngZu,m3h4x1(:,99),heltab2x4(:,:,365))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,nMT,G2tensor(284),n2h1(368))
  call Hloop_AZ_Q(ntryL,G2H4(29),wf4(:,20),G2H1(1),ngZu,m3h4x1(:,100),heltab2x4(:,:,366))
  call Hcheck_last_A_Q(ntryL,l_switch,G2H1(1),31,nMT,G3tensor(5),n2h1(369))
  call Hcheck_last_UV_W(ntryL,l_switch,G1H4(75),19,wf4(:,2),12,G2tensor(140),m3h4x1(:,101),heltab2x4(:,:,367))
  call Hcheck_last_UV_W(ntryL,l_switch,G2H4(12),19,wf4(:,2),12,G3tensor(6),m3h4x1(:,102),heltab2x4(:,:,368))
  call Hloop_QS_A(ntryL,G2H4(57),wf4(:,18),G2H1(1),ngH,m3h4x1(:,103),heltab2x4(:,:,369))
  call Hcheck_last_Q_A(ntryL,l_switch,G2H1(1),31,nMT,G3tensor(7),n2h1(370))
  call Hloop_QS_A(ntryL,G2H4(65),wf4(:,19),G2H1(1),ngX,m3h4x1(:,104),heltab2x4(:,:,370))
  call Hcheck_last_Q_A(ntryL,l_switch,G2H1(1),31,nMT,G3tensor(8),n2h1(371))
  call Hloop_QV_A(ntryL,G1H4(45),wf4(:,2),G1H1(1),m3h4x1(:,105),heltab2x4(:,:,371))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,nMT,G2tensor(137),n2h1(372))
  call Hloop_QV_A(ntryL,G2H4(3),wf4(:,2),G2H1(1),m3h4x1(:,106),heltab2x4(:,:,372))
  call Hcheck_last_Q_A(ntryL,l_switch,G2H1(1),31,nMT,G3tensor(9),n2h1(373))
  call Hloop_QV_A(ntryL,G1H4(57),wf4(:,2),G1H1(1),m3h4x1(:,107),heltab2x4(:,:,373))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,nMT,G2tensor(134),n2h1(374))
  call Hloop_QV_A(ntryL,G1H4(19),wf4(:,2),G1H1(1),m3h4x1(:,108),heltab2x4(:,:,374))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,nMB,G2tensor(131),n2h1(375))
  call Hloop_QV_A(ntryL,G2H4(52),wf4(:,2),G2H1(1),m3h4x1(:,109),heltab2x4(:,:,375))
  call Hcheck_last_Q_A(ntryL,l_switch,G2H1(1),31,nMB,G3tensor(10),n2h1(376))
  call Hloop_QZ_A(ntryL,G2H4(61),wf4(:,20),G2H1(1),ngZu,m3h4x1(:,110),heltab2x4(:,:,376))
  call Hcheck_last_Q_A(ntryL,l_switch,G2H1(1),31,nMT,G3tensor(11),n2h1(377))
  call Hcheck_last_UV_W(ntryL,l_switch,G1H4(69),19,wf4(:,2),12,G2tensor(216),m3h4x1(:,111),heltab2x4(:,:,377))
  call Hcheck_last_QA_V(ntryL,l_switch,G2H2(92),ex4(:),G2tensor(139),m3h2x1(:,368),heltab2x2(:,:,368))
  call Hcheck_last_AQ_V(ntryL,l_switch,G2H2(47),ex3(:),G2tensor(133),m3h2x1(:,369),heltab2x2(:,:,369))
  call Hcheck_last_QA_V(ntryL,l_switch,G2H2(112),ex4(:),G2tensor(136),m3h2x1(:,370),heltab2x2(:,:,370))
  call Hcheck_last_QA_V(ntryL,l_switch,G2H2(102),ex4(:),G2tensor(72),m3h2x1(:,371),heltab2x2(:,:,371))
  call Hcheck_last_AQ_V(ntryL,l_switch,G2H2(50),ex3(:),G2tensor(99),m3h2x1(:,372),heltab2x2(:,:,372))
  call Hcheck_last_QA_V(ntryL,l_switch,G2H2(59),ex2(:),G2tensor(5),m3h2x1(:,373),heltab2x2(:,:,373))
  call Hcheck_last_QA_V(ntryL,l_switch,G2H2(56),ex2(:),G2tensor(15),m3h2x1(:,374),heltab2x2(:,:,374))
  call Hloop_AS_Q(ntryL,G2H4(58),wf4(:,18),G2H1(1),ngH,m3h4x1(:,112),heltab2x4(:,:,378))
  call Hcheck_last_A_Q(ntryL,l_switch,G2H1(1),31,nMB,G3tensor(12),n2h1(378))
  call Hloop_QS_A(ntryL,G2H4(59),wf4(:,18),G2H1(1),ngH,m3h4x1(:,113),heltab2x4(:,:,379))
  call Hcheck_last_Q_A(ntryL,l_switch,G2H1(1),31,nMB,G3tensor(13),n2h1(379))
  call Hloop_AS_Q(ntryL,G2H4(62),wf4(:,19),G2H1(1),ngX,m3h4x1(:,114),heltab2x4(:,:,380))
  call Hcheck_last_A_Q(ntryL,l_switch,G2H1(1),31,nMB,G3tensor(14),n2h1(380))
  call Hloop_QS_A(ntryL,G2H4(63),wf4(:,19),G2H1(1),ngX,m3h4x1(:,115),heltab2x4(:,:,381))
  call Hcheck_last_Q_A(ntryL,l_switch,G2H1(1),31,nMB,G3tensor(15),n2h1(381))
  call Hloop_AV_Q(ntryL,G2H4(14),wf4(:,2),G2H1(1),m3h4x1(:,116),heltab2x4(:,:,382))
  call Hcheck_last_A_Q(ntryL,l_switch,G2H1(1),31,0,G3tensor(16),n2h1(382))
  call Hloop_QV_A(ntryL,G2H4(6),wf4(:,2),G2H1(1),m3h4x1(:,117),heltab2x4(:,:,383))
  call Hcheck_last_Q_A(ntryL,l_switch,G2H1(1),31,0,G3tensor(17),n2h1(383))
  call Hloop_AZ_Q(ntryL,G2H4(21),wf4(:,20),G2H1(1),ngZu,m3h4x1(:,118),heltab2x4(:,:,384))
  call Hcheck_last_A_Q(ntryL,l_switch,G2H1(1),31,0,G3tensor(18),n2h1(384))
  call Hloop_QZ_A(ntryL,G2H4(44),wf4(:,20),G2H1(1),ngZu,m3h4x1(:,119),heltab2x4(:,:,385))
  call Hcheck_last_Q_A(ntryL,l_switch,G2H1(1),31,0,G3tensor(19),n2h1(385))
  call Hloop_AZ_Q(ntryL,G2H4(1),wf4(:,20),G2H1(1),ngZd,m3h4x1(:,120),heltab2x4(:,:,386))
  call Hcheck_last_A_Q(ntryL,l_switch,G2H1(1),31,0,G3tensor(20),n2h1(386))
  call Hloop_AZ_Q(ntryL,G2H4(10),wf4(:,20),G2H1(1),ngZd,m3h4x1(:,121),heltab2x4(:,:,387))
  call Hcheck_last_A_Q(ntryL,l_switch,G2H1(1),31,nMB,G3tensor(21),n2h1(387))
  call Hloop_QZ_A(ntryL,G2H4(5),wf4(:,20),G2H1(1),ngZd,m3h4x1(:,122),heltab2x4(:,:,388))
  call Hcheck_last_Q_A(ntryL,l_switch,G2H1(1),31,0,G3tensor(22),n2h1(388))
  call Hloop_QZ_A(ntryL,G2H4(7),wf4(:,20),G2H1(1),ngZd,m3h4x1(:,123),heltab2x4(:,:,389))
  call Hcheck_last_Q_A(ntryL,l_switch,G2H1(1),31,nMB,G3tensor(23),n2h1(389))
  call Hcheck_last_DV_C(ntryL,l_switch,G2H4(8),19,wf4(:,2),G3tensor(24),m3h4x1(:,124),heltab2x4(:,:,390))
  call Hcheck_last_CV_D(ntryL,l_switch,G2H4(11),19,wf4(:,2),12,G3tensor(25),m3h4x1(:,125),heltab2x4(:,:,391))
  call Hcheck_last_QA_S(ntryL,l_switch,G2H2(118),ex4(:),G2tensor(25),ngH,m3h2x1(:,375),heltab2x2(:,:,375))
  call Hcheck_last_QA_S(ntryL,l_switch,G2H2(77),ex4(:),G2tensor(31),ngX,m3h2x1(:,376),heltab2x2(:,:,376))
  call Hcheck_last_QA_S(ntryL,l_switch,G2H2(74),ex4(:),G2tensor(36),ngPbt,m3h2x1(:,377),heltab2x2(:,:,377))
  call Hcheck_last_QA_Z(ntryL,l_switch,G2H2(71),ex4(:),G2tensor(48),ngZd,m3h2x1(:,378),heltab2x2(:,:,378))
  call Hcheck_last_QA_W(ntryL,l_switch,G2H2(68),ex4(:),G2tensor(84),m3h2x1(:,379),heltab2x2(:,:,379))
  call Hcheck_last_AQ_V(ntryL,l_switch,G2H2(133),ex3(:),G2tensor(93),m3h2x1(:,380),heltab2x2(:,:,380))
  call Hcheck_last_AQ_S(ntryL,l_switch,G2H2(86),ex3(:),G2tensor(105),ngH,m3h2x1(:,381),heltab2x2(:,:,381))
  call Hcheck_last_AQ_S(ntryL,l_switch,G2H2(83),ex3(:),G2tensor(248),ngX,m3h2x1(:,382),heltab2x2(:,:,382))
  call Hcheck_last_AQ_S(ntryL,l_switch,G2H2(80),ex3(:),G2tensor(126),ngPtb,m3h2x1(:,383),heltab2x2(:,:,383))
  call Hcheck_last_AQ_Z(ntryL,l_switch,G2H2(130),ex3(:),G2tensor(141),ngZd,m3h2x1(:,384),heltab2x2(:,:,384))
  call Hcheck_last_AQ_W(ntryL,l_switch,G2H2(107),ex3(:),G2tensor(257),m3h2x1(:,385),heltab2x2(:,:,385))
  call Hloop_VA_Q(ntryL,G1H8(22),wf8(:,91),G1H1(1),m3h8x1(:,1),heltab2x8(:,:,287))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,nMB,G2tensor(142),n2h1(390))
  call Hloop_VA_Q(ntryL,G1H8(23),wf8(:,92),G1H1(1),m3h8x1(:,2),heltab2x8(:,:,288))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,nMB,G2tensor(145),n2h1(391))
  call Hcheck_last_QA_V(ntryL,l_switch,G2H8(15),wf8(:,91),G2tensor(146),m3h8x1(:,3),heltab2x8(:,:,289))
  call Hcheck_last_QA_V(ntryL,l_switch,G2H8(16),wf8(:,92),G2tensor(152),m3h8x1(:,4),heltab2x8(:,:,290))
  call Hloop_SA_Q(ntryL,G1H8(28),wf8(:,93),G1H1(1),ngH,m3h8x1(:,5),heltab2x8(:,:,291))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,nMB,G2tensor(153),n2h1(392))
  call Hloop_SA_Q(ntryL,G1H8(29),wf8(:,93),G1H1(1),ngX,m3h8x1(:,6),heltab2x8(:,:,292))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,nMB,G2tensor(164),n2h1(393))
  call Hloop_SA_Q(ntryL,G1H8(31),wf8(:,93),G1H1(1),ngPbt,m3h8x1(:,7),heltab2x8(:,:,293))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,nMT,G2tensor(165),n2h1(394))
  call Hloop_VA_Q(ntryL,G1H8(33),wf8(:,93),G1H1(1),m3h8x1(:,8),heltab2x8(:,:,294))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,nMB,G2tensor(166),n2h1(395))
  call Hloop_VA_Q(ntryL,G1H8(34),wf8(:,94),G1H1(1),m3h8x1(:,9),heltab2x8(:,:,295))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,nMB,G2tensor(176),n2h1(396))
  call Hloop_ZA_Q(ntryL,G1H8(39),wf8(:,93),G1H1(1),ngZd,m3h8x1(:,10),heltab2x8(:,:,296))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,nMB,G2tensor(177),n2h1(397))
  call Hloop_WA_Q(ntryL,G1H8(37),wf8(:,93),G1H1(1),m3h8x1(:,11),heltab2x8(:,:,297))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,nMT,G2tensor(205),n2h1(398))
  call Hcheck_last_QA_V(ntryL,l_switch,G2H8(17),wf8(:,93),G2tensor(208),m3h8x1(:,12),heltab2x8(:,:,298))
  call Hcheck_last_QA_V(ntryL,l_switch,G2H8(18),wf8(:,94),G2tensor(210),m3h8x1(:,13),heltab2x8(:,:,299))
  call Hloop_VA_Q(ntryL,G1H8(42),wf8(:,101),G1H1(1),m3h8x1(:,14),heltab2x8(:,:,300))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,nMT,G2tensor(269),n2h1(399))
  call Hcheck_last_QA_V(ntryL,l_switch,G2H8(19),wf8(:,101),G2tensor(278),m3h8x1(:,15),heltab2x8(:,:,301))
  call Hloop_VA_Q(ntryL,G1H8(46),wf8(:,103),G1H1(1),m3h8x1(:,16),heltab2x8(:,:,302))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,nMT,G2tensor(290),n2h1(400))
  call Hcheck_last_QA_V(ntryL,l_switch,G2H8(20),wf8(:,103),G2tensor(10),m3h8x1(:,17),heltab2x8(:,:,303))
  call Hloop_VA_Q(ntryL,G1H8(48),wf8(:,108),G1H1(1),m3h8x1(:,18),heltab2x8(:,:,304))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,nMB,G2tensor(12),n2h1(401))
  call Hcheck_last_QA_V(ntryL,l_switch,G2H8(21),wf8(:,108),G2tensor(347),m3h8x1(:,19),heltab2x8(:,:,305))
  call Hloop_VA_Q(ntryL,G1H8(51),wf8(:,109),G1H1(1),m3h8x1(:,20),heltab2x8(:,:,306))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,nMB,G2tensor(8),n2h1(402))
  call Hcheck_last_QA_V(ntryL,l_switch,G2H8(22),wf8(:,109),G2tensor(22),m3h8x1(:,21),heltab2x8(:,:,307))
  call Hloop_VQ_A(ntryL,G1H8(14),wf8(:,106),G1H1(1),m3h8x1(:,22),heltab2x8(:,:,308))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,nMT,G2tensor(24),n2h1(403))
  call Hcheck_last_AQ_V(ntryL,l_switch,G2H8(23),wf8(:,106),G2tensor(323),m3h8x1(:,23),heltab2x8(:,:,309))
  call Hloop_VQ_A(ntryL,G1H8(4),wf8(:,107),G1H1(1),m3h8x1(:,24),heltab2x8(:,:,310))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,nMT,G2tensor(28),n2h1(404))
  call Hcheck_last_AQ_V(ntryL,l_switch,G2H8(24),wf8(:,107),G2tensor(32),m3h8x1(:,25),heltab2x8(:,:,311))
  call Hloop_VQ_A(ntryL,G1H8(27),wf8(:,119),G1H1(1),m3h8x1(:,26),heltab2x8(:,:,312))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,nMT,G2tensor(34),n2h1(405))
  call Hloop_VQ_A(ntryL,G1H8(35),wf8(:,121),G1H1(1),m3h8x1(:,27),heltab2x8(:,:,313))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,nMT,G2tensor(35),n2h1(406))
  call Hcheck_last_AQ_V(ntryL,l_switch,G2H8(1),wf8(:,119),G2tensor(37),m3h8x1(:,28),heltab2x8(:,:,314))
  call Hcheck_last_AQ_V(ntryL,l_switch,G2H8(2),wf8(:,121),G2tensor(38),m3h8x1(:,29),heltab2x8(:,:,315))
  call Hloop_SQ_A(ntryL,G1H8(55),wf8(:,123),G1H1(1),ngH,m3h8x1(:,30),heltab2x8(:,:,316))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,nMT,G2tensor(40),n2h1(407))
  call Hloop_SQ_A(ntryL,G1H8(56),wf8(:,123),G1H1(1),ngX,m3h8x1(:,31),heltab2x8(:,:,317))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,nMT,G2tensor(50),n2h1(408))
  call Hloop_SQ_A(ntryL,G1H8(58),wf8(:,123),G1H1(1),ngPbt,m3h8x1(:,32),heltab2x8(:,:,318))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,nMB,G2tensor(49),n2h1(409))
  call Hloop_VQ_A(ntryL,G1H8(59),wf8(:,123),G1H1(1),m3h8x1(:,33),heltab2x8(:,:,319))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,nMT,G2tensor(46),n2h1(410))
  call Hloop_VQ_A(ntryL,G1H8(1),wf8(:,125),G1H1(1),m3h8x1(:,34),heltab2x8(:,:,320))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,nMT,G2tensor(52),n2h1(411))
  call Hloop_ZQ_A(ntryL,G1H8(7),wf8(:,123),G1H1(1),ngZu,m3h8x1(:,35),heltab2x8(:,:,321))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,nMT,G2tensor(299),n2h1(412))
  call Hloop_WQ_A(ntryL,G1H8(67),wf8(:,123),G1H1(1),m3h8x1(:,36),heltab2x8(:,:,322))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,nMB,G2tensor(67),n2h1(413))
  call Hcheck_last_AQ_V(ntryL,l_switch,G2H8(3),wf8(:,123),G2tensor(58),m3h8x1(:,37),heltab2x8(:,:,323))
  call Hcheck_last_AQ_V(ntryL,l_switch,G2H8(4),wf8(:,125),G2tensor(59),m3h8x1(:,38),heltab2x8(:,:,324))
  call Hloop_VA_Q(ntryL,G1H8(20),wf8(:,111),G1H1(1),m3h8x1(:,39),heltab2x8(:,:,325))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,nMT,G2tensor(61),n2h1(414))
  call Hloop_VA_Q(ntryL,G1H8(25),wf8(:,113),G1H1(1),m3h8x1(:,40),heltab2x8(:,:,326))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,nMT,G2tensor(62),n2h1(415))
  call Hcheck_last_QA_V(ntryL,l_switch,G2H8(5),wf8(:,111),G2tensor(64),m3h8x1(:,41),heltab2x8(:,:,327))
  call Hcheck_last_QA_V(ntryL,l_switch,G2H8(6),wf8(:,113),G2tensor(186),m3h8x1(:,42),heltab2x8(:,:,328))
  call Hloop_SA_Q(ntryL,G1H8(6),wf8(:,115),G1H1(1),ngH,m3h8x1(:,43),heltab2x8(:,:,329))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,nMT,G2tensor(338),n2h1(416))
  call Hloop_SA_Q(ntryL,G1H8(60),wf8(:,115),G1H1(1),ngX,m3h8x1(:,44),heltab2x8(:,:,330))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,nMT,G2tensor(219),n2h1(417))
  call Hloop_SA_Q(ntryL,G1H8(61),wf8(:,115),G1H1(1),ngPtb,m3h8x1(:,45),heltab2x8(:,:,331))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,nMB,G2tensor(344),n2h1(418))
  call Hloop_VA_Q(ntryL,G1H8(70),wf8(:,115),G1H1(1),m3h8x1(:,46),heltab2x8(:,:,332))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,nMT,G2tensor(225),n2h1(419))
  call Hloop_VA_Q(ntryL,G1H8(66),wf8(:,117),G1H1(1),m3h8x1(:,47),heltab2x8(:,:,333))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,nMT,G2tensor(314),n2h1(420))
  call Hloop_ZA_Q(ntryL,G1H8(16),wf8(:,115),G1H1(1),ngZu,m3h8x1(:,48),heltab2x8(:,:,334))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,nMT,G2tensor(227),n2h1(421))
  call Hloop_WA_Q(ntryL,G1H8(18),wf8(:,115),G1H1(1),m3h8x1(:,49),heltab2x8(:,:,335))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,nMB,G2tensor(320),n2h1(422))
  call Hcheck_last_QA_V(ntryL,l_switch,G2H8(7),wf8(:,115),G2tensor(94),m3h8x1(:,50),heltab2x8(:,:,336))
  call Hcheck_last_QA_V(ntryL,l_switch,G2H8(8),wf8(:,117),G2tensor(95),m3h8x1(:,51),heltab2x8(:,:,337))
  call Hloop_SA_Q(ntryL,G1H2(125),ex2(:),G1H1(1),ngH,m3h2x1(:,386),heltab2x2(:,:,386))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,nMT,G2tensor(91),n2h1(423))
  call Hloop_SA_Q(ntryL,G1H2(129),ex2(:),G1H1(1),ngX,m3h2x1(:,387),heltab2x2(:,:,387))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,nMT,G2tensor(92),n2h1(424))
  call Hloop_SA_Q(ntryL,G1H2(130),ex2(:),G1H1(1),ngPtb,m3h2x1(:,388),heltab2x2(:,:,388))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,nMB,G2tensor(228),n2h1(425))
  call Hloop_VA_Q(ntryL,G1H2(131),ex2(:),G1H1(1),m3h2x1(:,389),heltab2x2(:,:,389))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,nMT,G2tensor(98),n2h1(426))
  call Hloop_ZA_Q(ntryL,G1H2(153),ex2(:),G1H1(1),ngZu,m3h2x1(:,390),heltab2x2(:,:,390))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,nMT,G2tensor(230),n2h1(427))
  call Hloop_WA_Q(ntryL,G1H2(159),ex2(:),G1H1(1),m3h2x1(:,391),heltab2x2(:,:,391))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,nMB,G2tensor(122),n2h1(428))
  call Hloop_VQ_A(ntryL,G1H2(165),ex3(:),G1H1(1),m3h2x1(:,392),heltab2x2(:,:,392))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,nMB,G2tensor(181),n2h1(429))
  call ol_merge_tensors(G3tensor(25),[G3tensor(24),G3tensor(22),G3tensor(20),G3tensor(19),G3tensor(18),G3tensor(17),G3tensor(16) &
    ,G3tensor(6),G2tensor(234),G2tensor(232),G1tensor(365),G1tensor(315),G1tensor(199),G1tensor(79),G0tensor(365),G0tensor(315) &
    ,G0tensor(34),G0tensor(14)])
  call ol_merge_tensors(G2tensor(22),[G2tensor(347),G2tensor(210),G2tensor(208),G2tensor(152),G2tensor(146),G2tensor(235) &
    ,G1tensor(330),G1tensor(115),G0tensor(330),G0tensor(20)])
  call ol_merge_tensors(G2tensor(95),[G2tensor(94),G2tensor(186),G2tensor(64),G2tensor(10),G2tensor(278),G2tensor(325) &
    ,G2tensor(238),G2tensor(236),G1tensor(480),G1tensor(415),G1tensor(380),G1tensor(30),G1tensor(205),G1tensor(175),G1tensor(145) &
    ,G0tensor(480),G0tensor(415),G0tensor(380),G0tensor(45),G0tensor(35),G0tensor(30),G0tensor(25)])
  call ol_merge_tensors(G2tensor(59),[G2tensor(58),G2tensor(38),G2tensor(37),G2tensor(32),G2tensor(323),G2tensor(349) &
    ,G2tensor(237),G1tensor(345),G1tensor(295),G1tensor(235),G1tensor(85),G1tensor(55),G1tensor(25),G0tensor(345),G0tensor(295) &
    ,G0tensor(40),G0tensor(15),G0tensor(10),G0tensor(5)])
  call ol_merge_tensors(G2tensor(240),[G1tensor(527),G1tensor(46),G1tensor(168),G0tensor(527),G0tensor(125),G0tensor(85)])
  call ol_merge_tensors(G2tensor(8),[G2tensor(12),G2tensor(176),G2tensor(166),G2tensor(145),G2tensor(142),G2tensor(301) &
    ,G2tensor(298),G2tensor(241),G1tensor(530),G1tensor(525),G1tensor(515),G1tensor(198),G1tensor(134),G0tensor(530),G0tensor(525) &
    ,G0tensor(515),G0tensor(95),G0tensor(75)])
  call ol_merge_tensors(G2tensor(243),[G1tensor(547),G1tensor(2),G1tensor(242),G1tensor(212),G0tensor(547),G0tensor(124) &
    ,G0tensor(114),G0tensor(104)])
  call ol_merge_tensors(G2tensor(213),[G2tensor(112),G2tensor(244),G1tensor(550),G1tensor(540),G1tensor(535),G1tensor(258) &
    ,G1tensor(230),G1tensor(194),G0tensor(550),G0tensor(540),G0tensor(535),G0tensor(119),G0tensor(109),G0tensor(94)])
  call ol_merge_tensors(G2tensor(136),[G2tensor(246),G1tensor(562),G1tensor(328),G1tensor(11),G0tensor(562),G0tensor(328) &
    ,G0tensor(129)])
  call ol_merge_tensors(G3tensor(23),[G3tensor(21),G3tensor(15),G3tensor(14),G3tensor(13),G3tensor(12),G3tensor(10),G3tensor(4) &
    ,G2tensor(283),G2tensor(280),G2tensor(277),G2tensor(274),G2tensor(271),G2tensor(268),G2tensor(256),G2tensor(247),G1tensor(820) &
    ,G1tensor(815),G1tensor(810),G1tensor(805),G1tensor(590),G1tensor(565),G1tensor(76),G1tensor(14),G0tensor(820),G0tensor(815) &
    ,G0tensor(810),G0tensor(805),G0tensor(590),G0tensor(565),G0tensor(154),G0tensor(134)])
  call ol_merge_tensors(G2tensor(84),[G2tensor(36),G2tensor(252),G2tensor(249),G1tensor(572),G1tensor(22),G0tensor(572) &
    ,G0tensor(139)])
  call ol_merge_tensors(G3tensor(11),[G3tensor(9),G3tensor(8),G3tensor(7),G3tensor(5),G3tensor(3),G3tensor(2),G3tensor(1) &
    ,G2tensor(262),G2tensor(259),G2tensor(253),G2tensor(250),G1tensor(844),G1tensor(839),G1tensor(834),G1tensor(829),G1tensor(605) &
    ,G1tensor(575),G1tensor(57),G1tensor(28),G0tensor(844),G0tensor(839),G0tensor(834),G0tensor(829),G0tensor(605),G0tensor(575) &
    ,G0tensor(164),G0tensor(144)])
  call ol_merge_tensors(G2tensor(93),[G2tensor(255),G1tensor(587),G1tensor(32),G0tensor(587),G0tensor(149)])
  call ol_merge_tensors(G2tensor(257),[G2tensor(126),G2tensor(261),G2tensor(258),G1tensor(602),G1tensor(53),G0tensor(602) &
    ,G0tensor(159)])
  call ol_merge_tensors(G2tensor(216),[G2tensor(264),G1tensor(707),G1tensor(280),G1tensor(209),G1tensor(73),G0tensor(707) &
    ,G0tensor(280),G0tensor(240),G0tensor(13)])
  call ol_merge_tensors(G2tensor(314),[G2tensor(225),G2tensor(62),G2tensor(61),G2tensor(290),G2tensor(269),G2tensor(322) &
    ,G2tensor(319),G2tensor(307),G2tensor(304),G2tensor(289),G2tensor(286),G2tensor(265),G1tensor(710),G1tensor(700),G1tensor(685) &
    ,G1tensor(610),G1tensor(270),G1tensor(125),G1tensor(111),G0tensor(710),G0tensor(700),G0tensor(685),G0tensor(610),G0tensor(270) &
    ,G0tensor(205),G0tensor(165)])
  call ol_merge_tensors(G2tensor(25),[G2tensor(267),G1tensor(802),G0tensor(802)])
  call ol_merge_tensors(G2tensor(48),[G2tensor(31),G2tensor(273),G2tensor(270),G1tensor(807),G0tensor(807)])
  call ol_merge_tensors(G2tensor(105),[G2tensor(276),G1tensor(812),G0tensor(812)])
  call ol_merge_tensors(G2tensor(141),[G2tensor(248),G2tensor(282),G2tensor(279),G1tensor(817),G0tensor(817)])
  call ol_merge_tensors(G2tensor(55),[G2tensor(288),G2tensor(285),G1tensor(553),G1tensor(548),G1tensor(543),G1tensor(358) &
    ,G1tensor(277),G1tensor(272),G1tensor(267),G1tensor(255),G0tensor(553),G0tensor(548),G0tensor(543),G0tensor(358),G0tensor(277) &
    ,G0tensor(272),G0tensor(267),G0tensor(262)])
  call ol_merge_tensors(G2tensor(181),[G2tensor(294),G2tensor(291),G1tensor(822),G1tensor(798),G1tensor(793),G1tensor(757) &
    ,G1tensor(752),G1tensor(397),G1tensor(393),G0tensor(822),G0tensor(798),G0tensor(793),G0tensor(757),G0tensor(752),G0tensor(397) &
    ,G0tensor(393)])
  call ol_merge_tensors(G2tensor(52),[G2tensor(46),G2tensor(35),G2tensor(34),G2tensor(28),G2tensor(24),G2tensor(346),G2tensor(343) &
    ,G2tensor(331),G2tensor(328),G2tensor(295),G2tensor(292),G1tensor(825),G1tensor(580),G1tensor(123),G1tensor(41),G0tensor(825) &
    ,G0tensor(580),G0tensor(175),G0tensor(145)])
  call ol_merge_tensors(G2tensor(300),[G2tensor(297),G1tensor(748),G1tensor(723),G1tensor(718),G1tensor(713),G1tensor(260) &
    ,G1tensor(234),G1tensor(188),G1tensor(174),G0tensor(748),G0tensor(723),G0tensor(718),G0tensor(713),G0tensor(122),G0tensor(97) &
    ,G0tensor(92),G0tensor(87)])
  call ol_merge_tensors(G2tensor(98),[G2tensor(321),G2tensor(318),G2tensor(306),G2tensor(303),G1tensor(51),G1tensor(45) &
    ,G0tensor(162),G0tensor(157)])
  call ol_merge_tensors(G2tensor(91),[G2tensor(309),G1tensor(827),G0tensor(827)])
  call ol_merge_tensors(G2tensor(338),[G2tensor(310),G1tensor(830),G1tensor(660),G1tensor(257),G1tensor(191),G0tensor(830) &
    ,G0tensor(660),G0tensor(250),G0tensor(215)])
  call ol_merge_tensors(G2tensor(230),[G2tensor(92),G2tensor(312),G1tensor(832),G0tensor(832)])
  call ol_merge_tensors(G2tensor(227),[G2tensor(219),G2tensor(313),G1tensor(835),G1tensor(670),G1tensor(249),G1tensor(178) &
    ,G0tensor(835),G0tensor(670),G0tensor(260),G0tensor(225)])
  call ol_merge_tensors(G2tensor(122),[G2tensor(228),G2tensor(315),G1tensor(153),G1tensor(29),G0tensor(152),G0tensor(147)])
  call ol_merge_tensors(G2tensor(320),[G2tensor(344),G2tensor(316),G1tensor(595),G1tensor(105),G1tensor(40),G0tensor(595) &
    ,G0tensor(195),G0tensor(155)])
  call ol_merge_tensors(G2tensor(15),[G2tensor(324),G1tensor(427),G1tensor(392),G1tensor(162),G1tensor(187),G0tensor(427) &
    ,G0tensor(392),G0tensor(83),G0tensor(32)])
  call ol_merge_tensors(G2tensor(345),[G2tensor(342),G2tensor(330),G2tensor(327),G1tensor(26),G1tensor(20),G0tensor(142) &
    ,G0tensor(137)])
  call ol_merge_tensors(G2tensor(333),[G1tensor(837),G0tensor(837)])
  call ol_merge_tensors(G2tensor(40),[G2tensor(334),G1tensor(840),G0tensor(840)])
  call ol_merge_tensors(G2tensor(336),[G1tensor(842),G0tensor(842)])
  call ol_merge_tensors(G2tensor(299),[G2tensor(50),G2tensor(337),G1tensor(845),G0tensor(845)])
  call ol_merge_tensors(G2tensor(339),[G1tensor(318),G1tensor(52),G1tensor(83),G0tensor(318),G0tensor(132),G0tensor(127)])
  call ol_merge_tensors(G2tensor(67),[G2tensor(49),G2tensor(340),G1tensor(570),G1tensor(93),G1tensor(58),G0tensor(570) &
    ,G0tensor(185),G0tensor(135)])
  call ol_merge_tensors(G2tensor(348),[G1tensor(357),G1tensor(307),G1tensor(39),G1tensor(67),G0tensor(357),G0tensor(307) &
    ,G0tensor(123),G0tensor(12)])
  call ol_merge_tensors(G1tensor(332),[G1tensor(282),G1tensor(176),G1tensor(7),G0tensor(332),G0tensor(282),G0tensor(88) &
    ,G0tensor(2)])
  call ol_merge_tensors(G1tensor(657),[G1tensor(220),G1tensor(148),G1tensor(13),G0tensor(657),G0tensor(245),G0tensor(210) &
    ,G0tensor(3)])
  call ol_merge_tensors(G1tensor(340),[G1tensor(290),G1tensor(139),G1tensor(19),G0tensor(340),G0tensor(290),G0tensor(24) &
    ,G0tensor(4)])
  call ol_merge_tensors(G1tensor(347),[G1tensor(297),G1tensor(228),G1tensor(37),G0tensor(347),G0tensor(297),G0tensor(98) &
    ,G0tensor(7)])
  call ol_merge_tensors(G1tensor(667),[G1tensor(237),G1tensor(171),G1tensor(43),G0tensor(667),G0tensor(255),G0tensor(220) &
    ,G0tensor(8)])
  call ol_merge_tensors(G1tensor(355),[G1tensor(305),G1tensor(169),G1tensor(49),G0tensor(355),G0tensor(305),G0tensor(29) &
    ,G0tensor(9)])
  call ol_merge_tensors(G1tensor(637),[G1tensor(317),G1tensor(112),G1tensor(97),G0tensor(637),G0tensor(317),G0tensor(198) &
    ,G0tensor(17)])
  call ol_merge_tensors(G1tensor(567),[G1tensor(86),G1tensor(5),G1tensor(103),G0tensor(567),G0tensor(180),G0tensor(130) &
    ,G0tensor(18)])
  call ol_merge_tensors(G1tensor(325),[G1tensor(229),G1tensor(109),G0tensor(325),G0tensor(39),G0tensor(19)])
  call ol_merge_tensors(G1tensor(402),[G1tensor(367),G1tensor(114),G1tensor(127),G0tensor(402),G0tensor(367),G0tensor(68) &
    ,G0tensor(22)])
  call ol_merge_tensors(G1tensor(410),[G1tensor(375),G1tensor(133),G0tensor(410),G0tensor(375),G0tensor(23)])
  call ol_merge_tensors(G1tensor(417),[G1tensor(382),G1tensor(146),G1tensor(157),G0tensor(417),G0tensor(382),G0tensor(78) &
    ,G0tensor(27)])
  call ol_merge_tensors(G1tensor(425),[G1tensor(390),G1tensor(163),G0tensor(425),G0tensor(390),G0tensor(28)])
  call ol_merge_tensors(G2tensor(140),[G1tensor(435),G1tensor(400),G1tensor(193),G0tensor(435),G0tensor(400),G0tensor(33)])
  call ol_merge_tensors(G1tensor(597),[G1tensor(437),G1tensor(59),G1tensor(217),G0tensor(597),G0tensor(437),G0tensor(158) &
    ,G0tensor(37)])
  call ol_merge_tensors(G1tensor(445),[G1tensor(223),G0tensor(445),G0tensor(38)])
  call ol_merge_tensors(G1tensor(773),[G1tensor(462),G1tensor(447),G1tensor(82),G1tensor(247),G0tensor(773),G0tensor(462) &
    ,G0tensor(447),G0tensor(138),G0tensor(42)])
  call ol_merge_tensors(G1tensor(470),[G1tensor(455),G1tensor(253),G0tensor(470),G0tensor(455),G0tensor(43)])
  call ol_merge_tensors(G1tensor(475),[G1tensor(460),G1tensor(259),G0tensor(475),G0tensor(460),G0tensor(44)])
  call ol_merge_tensors(G1tensor(66),[G1tensor(36),G0tensor(52),G0tensor(47)])
  call ol_merge_tensors(G1tensor(792),[G1tensor(482),G1tensor(12),G0tensor(792),G0tensor(482),G0tensor(48)])
  call ol_merge_tensors(G1tensor(487),[G1tensor(196),G1tensor(164),G1tensor(96),G1tensor(42),G0tensor(487),G0tensor(189) &
    ,G0tensor(84),G0tensor(59),G0tensor(49)])
  call ol_merge_tensors(G1tensor(492),[G1tensor(9),G1tensor(18),G0tensor(492),G0tensor(105),G0tensor(50)])
  call ol_merge_tensors(G1tensor(485),[G1tensor(48),G0tensor(485),G0tensor(53)])
  call ol_merge_tensors(G1tensor(520),[G1tensor(510),G1tensor(490),G1tensor(101),G1tensor(132),G1tensor(108),G1tensor(72) &
    ,G0tensor(520),G0tensor(510),G0tensor(490),G0tensor(194),G0tensor(74),G0tensor(64),G0tensor(54)])
  call ol_merge_tensors(G2tensor(153),[G1tensor(495),G1tensor(15),G1tensor(54),G0tensor(495),G0tensor(110),G0tensor(55)])
  call ol_merge_tensors(G1tensor(102),[G1tensor(60),G0tensor(62),G0tensor(57)])
  call ol_merge_tensors(G1tensor(797),[G1tensor(497),G1tensor(84),G0tensor(797),G0tensor(497),G0tensor(58)])
  call ol_merge_tensors(G1tensor(502),[G1tensor(33),G1tensor(90),G0tensor(502),G0tensor(115),G0tensor(60)])
  call ol_merge_tensors(G1tensor(500),[G1tensor(104),G0tensor(500),G0tensor(63)])
  call ol_merge_tensors(G2tensor(177),[G2tensor(164),G1tensor(505),G1tensor(252),G1tensor(110),G0tensor(505),G0tensor(120) &
    ,G0tensor(65)])
  call ol_merge_tensors(G1tensor(772),[G1tensor(21),G1tensor(144),G1tensor(156),G1tensor(120),G0tensor(772),G0tensor(82) &
    ,G0tensor(77),G0tensor(72),G0tensor(67)])
  call ol_merge_tensors(G1tensor(507),[G1tensor(116),G0tensor(507),G0tensor(69)])
  call ol_merge_tensors(G1tensor(512),[G1tensor(182),G1tensor(122),G0tensor(512),G0tensor(90),G0tensor(70)])
  call ol_merge_tensors(G1tensor(450),[G1tensor(430),G1tensor(420),G1tensor(412),G1tensor(405),G1tensor(138),G0tensor(450) &
    ,G0tensor(430),G0tensor(420),G0tensor(412),G0tensor(405),G0tensor(73)])
  call ol_merge_tensors(G1tensor(517),[G1tensor(150),G0tensor(517),G0tensor(79)])
  call ol_merge_tensors(G1tensor(522),[G1tensor(204),G1tensor(152),G0tensor(522),G0tensor(100),G0tensor(80)])
  call ol_merge_tensors(G1tensor(532),[G1tensor(180),G0tensor(532),G0tensor(89)])
  call ol_merge_tensors(G2tensor(41),[G2tensor(44),G1tensor(360),G1tensor(350),G1tensor(342),G1tensor(335),G1tensor(192) &
    ,G0tensor(360),G0tensor(350),G0tensor(342),G0tensor(335),G0tensor(93)])
  call ol_merge_tensors(G1tensor(537),[G1tensor(222),G0tensor(537),G0tensor(99)])
  call ol_merge_tensors(G1tensor(733),[G1tensor(728),G1tensor(218),G1tensor(3),G0tensor(733),G0tensor(728),G0tensor(107) &
    ,G0tensor(102)])
  call ol_merge_tensors(G1tensor(782),[G1tensor(542),G1tensor(210),G0tensor(782),G0tensor(542),G0tensor(103)])
  call ol_merge_tensors(G1tensor(545),[G1tensor(224),G0tensor(545),G0tensor(108)])
  call ol_merge_tensors(G1tensor(743),[G1tensor(738),G1tensor(248),G1tensor(27),G0tensor(743),G0tensor(738),G0tensor(117) &
    ,G0tensor(112)])
  call ol_merge_tensors(G1tensor(787),[G1tensor(552),G1tensor(240),G0tensor(787),G0tensor(552),G0tensor(113)])
  call ol_merge_tensors(G1tensor(555),[G1tensor(264),G0tensor(555),G0tensor(118)])
  call ol_merge_tensors(G1tensor(777),[G1tensor(557),G1tensor(443),G1tensor(323),G1tensor(17),G0tensor(777),G0tensor(557) &
    ,G0tensor(443),G0tensor(323),G0tensor(128)])
  call ol_merge_tensors(G2tensor(131),[G1tensor(560),G1tensor(10),G0tensor(560),G0tensor(133)])
  call ol_merge_tensors(G1tensor(577),[G1tensor(71),G1tensor(23),G0tensor(577),G0tensor(170),G0tensor(140)])
  call ol_merge_tensors(G2tensor(56),[G2tensor(65),G2tensor(68),G2tensor(43),G1tensor(477),G1tensor(465),G1tensor(64) &
    ,G0tensor(477),G0tensor(465),G0tensor(143)])
  call ol_merge_tensors(G1tensor(582),[G1tensor(458),G1tensor(453),G1tensor(135),G0tensor(582),G0tensor(458),G0tensor(453) &
    ,G0tensor(148)])
  call ol_merge_tensors(G1tensor(592),[G1tensor(124),G1tensor(70),G0tensor(592),G0tensor(190),G0tensor(150)])
  call ol_merge_tensors(G2tensor(127),[G1tensor(585),G1tensor(38),G0tensor(585),G0tensor(153)])
  call ol_merge_tensors(G1tensor(607),[G1tensor(113),G1tensor(47),G0tensor(607),G0tensor(200),G0tensor(160)])
  call ol_merge_tensors(G2tensor(284),[G2tensor(130),G2tensor(115),G2tensor(121),G1tensor(600),G1tensor(56),G0tensor(600) &
    ,G0tensor(163)])
  call ol_merge_tensors(G1tensor(767),[G1tensor(762),G1tensor(633),G1tensor(498),G1tensor(488),G1tensor(483),G1tensor(432) &
    ,G1tensor(428),G1tensor(117),G1tensor(63),G0tensor(767),G0tensor(762),G0tensor(633),G0tensor(498),G0tensor(488),G0tensor(483) &
    ,G0tensor(432),G0tensor(428),G0tensor(172),G0tensor(167)])
  call ol_merge_tensors(G1tensor(612),[G1tensor(89),G0tensor(612),G0tensor(168)])
  call ol_merge_tensors(G1tensor(617),[G1tensor(77),G0tensor(617),G0tensor(169)])
  call ol_merge_tensors(G1tensor(615),[G1tensor(68),G0tensor(615),G0tensor(173)])
  call ol_merge_tensors(G1tensor(620),[G1tensor(69),G0tensor(620),G0tensor(174)])
  call ol_merge_tensors(G1tensor(643),[G1tensor(638),G1tensor(88),G1tensor(75),G0tensor(643),G0tensor(638),G0tensor(182) &
    ,G0tensor(177)])
  call ol_merge_tensors(G1tensor(622),[G1tensor(80),G0tensor(622),G0tensor(178)])
  call ol_merge_tensors(G1tensor(627),[G1tensor(81),G0tensor(627),G0tensor(179)])
  call ol_merge_tensors(G1tensor(625),[G1tensor(165),G0tensor(625),G0tensor(183)])
  call ol_merge_tensors(G1tensor(630),[G1tensor(92),G0tensor(630),G0tensor(184)])
  call ol_merge_tensors(G1tensor(618),[G1tensor(613),G1tensor(100),G1tensor(95),G0tensor(618),G0tensor(613),G0tensor(192) &
    ,G0tensor(187)])
  call ol_merge_tensors(G1tensor(632),[G1tensor(473),G1tensor(468),G1tensor(99),G0tensor(632),G0tensor(473),G0tensor(468) &
    ,G0tensor(188)])
  call ol_merge_tensors(G1tensor(635),[G1tensor(143),G0tensor(635),G0tensor(193)])
  call ol_merge_tensors(G1tensor(788),[G1tensor(783),G1tensor(628),G1tensor(623),G1tensor(308),G1tensor(214),G1tensor(195) &
    ,G1tensor(179),G1tensor(137),G1tensor(107),G0tensor(788),G0tensor(783),G0tensor(628),G0tensor(623),G0tensor(308),G0tensor(237) &
    ,G0tensor(232),G0tensor(227),G0tensor(202),G0tensor(197)])
  call ol_merge_tensors(G1tensor(642),[G1tensor(131),G0tensor(642),G0tensor(199)])
  call ol_merge_tensors(G1tensor(705),[G1tensor(690),G1tensor(675),G1tensor(640),G1tensor(119),G0tensor(705),G0tensor(690) &
    ,G0tensor(675),G0tensor(640),G0tensor(203)])
  call ol_merge_tensors(G1tensor(695),[G1tensor(680),G1tensor(655),G1tensor(645),G1tensor(177),G1tensor(160),G1tensor(155) &
    ,G0tensor(695),G0tensor(680),G0tensor(655),G0tensor(645),G0tensor(224),G0tensor(214),G0tensor(204)])
  call ol_merge_tensors(G1tensor(283),[G1tensor(147),G1tensor(136),G0tensor(283),G0tensor(212),G0tensor(207)])
  call ol_merge_tensors(G1tensor(647),[G1tensor(373),G1tensor(288),G1tensor(141),G0tensor(647),G0tensor(373),G0tensor(288) &
    ,G0tensor(208)])
  call ol_merge_tensors(G1tensor(652),[G1tensor(444),G1tensor(293),G1tensor(239),G1tensor(167),G1tensor(154),G0tensor(652) &
    ,G0tensor(444),G0tensor(293),G0tensor(239),G0tensor(219),G0tensor(209)])
  call ol_merge_tensors(G1tensor(650),[G1tensor(159),G0tensor(650),G0tensor(213)])
  call ol_merge_tensors(G1tensor(298),[G1tensor(197),G1tensor(166),G0tensor(298),G0tensor(222),G0tensor(217)])
  call ol_merge_tensors(G1tensor(662),[G1tensor(388),G1tensor(303),G1tensor(185),G0tensor(662),G0tensor(388),G0tensor(303) &
    ,G0tensor(218)])
  call ol_merge_tensors(G1tensor(665),[G1tensor(173),G0tensor(665),G0tensor(223)])
  call ol_merge_tensors(G1tensor(753),[G1tensor(672),G1tensor(183),G0tensor(753),G0tensor(672),G0tensor(228)])
  call ol_merge_tensors(G1tensor(677),[G1tensor(184),G0tensor(677),G0tensor(229)])
  call ol_merge_tensors(G1tensor(682),[G1tensor(265),G1tensor(189),G0tensor(682),G0tensor(265),G0tensor(230)])
  call ol_merge_tensors(G1tensor(758),[G1tensor(687),G1tensor(201),G0tensor(758),G0tensor(687),G0tensor(233)])
  call ol_merge_tensors(G1tensor(692),[G1tensor(202),G0tensor(692),G0tensor(234)])
  call ol_merge_tensors(G1tensor(697),[G1tensor(275),G1tensor(207),G0tensor(697),G0tensor(275),G0tensor(235)])
  call ol_merge_tensors(G2tensor(139),[G1tensor(702),G1tensor(398),G1tensor(313),G1tensor(208),G0tensor(702),G0tensor(398) &
    ,G0tensor(313),G0tensor(238)])
  call ol_merge_tensors(G1tensor(533),[G1tensor(333),G1tensor(221),G1tensor(245),G0tensor(533),G0tensor(333),G0tensor(247) &
    ,G0tensor(242)])
  call ol_merge_tensors(G1tensor(712),[G1tensor(408),G1tensor(338),G1tensor(215),G0tensor(712),G0tensor(408),G0tensor(338) &
    ,G0tensor(243)])
  call ol_merge_tensors(G2tensor(99),[G1tensor(717),G1tensor(343),G1tensor(279),G1tensor(233),G1tensor(219),G0tensor(717) &
    ,G0tensor(343),G0tensor(279),G0tensor(254),G0tensor(244)])
  call ol_merge_tensors(G1tensor(715),[G1tensor(225),G0tensor(715),G0tensor(248)])
  call ol_merge_tensors(G2tensor(113),[G2tensor(119),G1tensor(745),G1tensor(735),G1tensor(720),G1tensor(269),G1tensor(243) &
    ,G1tensor(226),G0tensor(745),G0tensor(735),G0tensor(720),G0tensor(269),G0tensor(259),G0tensor(249)])
  call ol_merge_tensors(G1tensor(538),[G1tensor(348),G1tensor(244),G1tensor(231),G0tensor(538),G0tensor(348),G0tensor(257) &
    ,G0tensor(252)])
  call ol_merge_tensors(G1tensor(722),[G1tensor(423),G1tensor(353),G1tensor(263),G0tensor(722),G0tensor(423),G0tensor(353) &
    ,G0tensor(253)])
  call ol_merge_tensors(G1tensor(725),[G1tensor(238),G0tensor(725),G0tensor(258)])
  call ol_merge_tensors(G1tensor(763),[G1tensor(727),G1tensor(256),G0tensor(763),G0tensor(727),G0tensor(263)])
  call ol_merge_tensors(G1tensor(732),[G1tensor(261),G0tensor(732),G0tensor(264)])
  call ol_merge_tensors(G2tensor(116),[G2tensor(100),G1tensor(750),G1tensor(740),G1tensor(730),G1tensor(268),G0tensor(750) &
    ,G0tensor(740),G0tensor(730),G0tensor(268)])
  call ol_merge_tensors(G1tensor(768),[G1tensor(737),G1tensor(273),G0tensor(768),G0tensor(737),G0tensor(273)])
  call ol_merge_tensors(G1tensor(742),[G1tensor(274),G0tensor(742),G0tensor(274)])
  call ol_merge_tensors(G2tensor(133),[G1tensor(747),G1tensor(433),G1tensor(363),G1tensor(278),G0tensor(747),G0tensor(433) &
    ,G0tensor(363),G0tensor(278)])
  call ol_merge_tensors(G1tensor(369),[G1tensor(287),G1tensor(284),G0tensor(369),G0tensor(287),G0tensor(284)])
  call ol_merge_tensors(G1tensor(440),[G1tensor(310),G1tensor(300),G1tensor(292),G1tensor(285),G0tensor(440),G0tensor(310) &
    ,G0tensor(300),G0tensor(292),G0tensor(285)])
  call ol_merge_tensors(G2tensor(4),[G1tensor(379),G1tensor(329),G1tensor(324),G1tensor(314),G1tensor(304),G1tensor(294) &
    ,G1tensor(289),G0tensor(379),G0tensor(329),G0tensor(324),G0tensor(314),G0tensor(304),G0tensor(294),G0tensor(289)])
  call ol_merge_tensors(G1tensor(384),[G1tensor(302),G1tensor(299),G0tensor(384),G0tensor(302),G0tensor(299)])
  call ol_merge_tensors(G2tensor(2),[G1tensor(394),G1tensor(312),G1tensor(309),G0tensor(394),G0tensor(312),G0tensor(309)])
  call ol_merge_tensors(G1tensor(439),[G1tensor(322),G1tensor(319),G0tensor(439),G0tensor(322),G0tensor(319)])
  call ol_merge_tensors(G2tensor(20),[G2tensor(26),G2tensor(18),G2tensor(16),G1tensor(327),G1tensor(320),G0tensor(327) &
    ,G0tensor(320)])
  call ol_merge_tensors(G1tensor(513),[G1tensor(404),G1tensor(337),G1tensor(334),G0tensor(513),G0tensor(404),G0tensor(337) &
    ,G0tensor(334)])
  call ol_merge_tensors(G2tensor(6),[G1tensor(459),G1tensor(414),G1tensor(364),G1tensor(354),G1tensor(344),G1tensor(339) &
    ,G0tensor(459),G0tensor(414),G0tensor(364),G0tensor(354),G0tensor(344),G0tensor(339)])
  call ol_merge_tensors(G1tensor(523),[G1tensor(419),G1tensor(352),G1tensor(349),G0tensor(523),G0tensor(419),G0tensor(352) &
    ,G0tensor(349)])
  call ol_merge_tensors(G2tensor(14),[G1tensor(528),G1tensor(429),G1tensor(362),G1tensor(359),G0tensor(528),G0tensor(429) &
    ,G0tensor(362),G0tensor(359)])
  call ol_merge_tensors(G1tensor(372),[G1tensor(368),G0tensor(372),G0tensor(368)])
  call ol_merge_tensors(G2tensor(47),[G2tensor(30),G1tensor(395),G1tensor(385),G1tensor(377),G1tensor(370),G0tensor(395) &
    ,G0tensor(385),G0tensor(377),G0tensor(370)])
  call ol_merge_tensors(G2tensor(72),[G1tensor(399),G1tensor(389),G1tensor(378),G1tensor(374),G0tensor(399),G0tensor(389) &
    ,G0tensor(378),G0tensor(374)])
  call ol_merge_tensors(G1tensor(387),[G1tensor(383),G0tensor(387),G0tensor(383)])
  call ol_merge_tensors(G1tensor(508),[G1tensor(407),G1tensor(403),G0tensor(508),G0tensor(407),G0tensor(403)])
  call ol_merge_tensors(G1tensor(454),[G1tensor(434),G1tensor(424),G1tensor(413),G1tensor(409),G0tensor(454),G0tensor(434) &
    ,G0tensor(424),G0tensor(413),G0tensor(409)])
  call ol_merge_tensors(G1tensor(518),[G1tensor(422),G1tensor(418),G0tensor(518),G0tensor(422),G0tensor(418)])
  call ol_merge_tensors(G1tensor(442),[G1tensor(438),G0tensor(442),G0tensor(438)])
  call ol_merge_tensors(G1tensor(452),[G1tensor(448),G0tensor(452),G0tensor(448)])
  call ol_merge_tensors(G1tensor(457),[G1tensor(449),G0tensor(457),G0tensor(449)])
  call ol_merge_tensors(G2tensor(73),[G2tensor(218),G1tensor(573),G1tensor(467),G1tensor(463),G0tensor(573),G0tensor(467) &
    ,G0tensor(463)])
  call ol_merge_tensors(G1tensor(614),[G1tensor(578),G1tensor(472),G1tensor(464),G0tensor(614),G0tensor(578),G0tensor(472) &
    ,G0tensor(464)])
  call ol_merge_tensors(G2tensor(5),[G1tensor(478),G1tensor(469),G0tensor(478),G0tensor(469)])
  call ol_merge_tensors(G2tensor(296),[G1tensor(479),G1tensor(474),G0tensor(479),G0tensor(474)])
  call ol_merge_tensors(G1tensor(544),[G1tensor(493),G1tensor(484),G0tensor(544),G0tensor(493),G0tensor(484)])
  call ol_merge_tensors(G2tensor(53),[G1tensor(594),G1tensor(589),G1tensor(549),G1tensor(529),G1tensor(504),G1tensor(494) &
    ,G1tensor(489),G0tensor(594),G0tensor(589),G0tensor(549),G0tensor(529),G0tensor(504),G0tensor(494),G0tensor(489)])
  call ol_merge_tensors(G1tensor(554),[G1tensor(503),G1tensor(499),G0tensor(554),G0tensor(503),G0tensor(499)])
  call ol_merge_tensors(G2tensor(88),[G1tensor(814),G1tensor(534),G1tensor(514),G1tensor(509),G0tensor(814),G0tensor(534) &
    ,G0tensor(514),G0tensor(509)])
  call ol_merge_tensors(G2tensor(103),[G2tensor(97),G1tensor(819),G1tensor(539),G1tensor(524),G1tensor(519),G0tensor(819) &
    ,G0tensor(539),G0tensor(524),G0tensor(519)])
  call ol_merge_tensors(G2tensor(70),[G1tensor(563),G1tensor(558),G0tensor(563),G0tensor(558)])
  call ol_merge_tensors(G1tensor(624),[G1tensor(568),G1tensor(559),G0tensor(624),G0tensor(568),G0tensor(559)])
  call ol_merge_tensors(G2tensor(71),[G1tensor(629),G1tensor(569),G1tensor(564),G0tensor(629),G0tensor(569),G0tensor(564)])
  call ol_merge_tensors(G2tensor(341),[G2tensor(76),G1tensor(619),G1tensor(579),G1tensor(574),G0tensor(619),G0tensor(579) &
    ,G0tensor(574)])
  call ol_merge_tensors(G2tensor(329),[G1tensor(588),G1tensor(583),G0tensor(588),G0tensor(583)])
  call ol_merge_tensors(G1tensor(634),[G1tensor(593),G1tensor(584),G0tensor(634),G0tensor(593),G0tensor(584)])
  call ol_merge_tensors(G2tensor(74),[G2tensor(326),G1tensor(603),G1tensor(598),G0tensor(603),G0tensor(598)])
  call ol_merge_tensors(G1tensor(639),[G1tensor(608),G1tensor(599),G0tensor(639),G0tensor(608),G0tensor(599)])
  call ol_merge_tensors(G2tensor(79),[G2tensor(77),G1tensor(644),G1tensor(609),G1tensor(604),G0tensor(644),G0tensor(609) &
    ,G0tensor(604)])
  call ol_merge_tensors(G1tensor(778),[G1tensor(703),G1tensor(663),G1tensor(653),G1tensor(648),G0tensor(778),G0tensor(703) &
    ,G0tensor(663),G0tensor(653),G0tensor(648)])
  call ol_merge_tensors(G1tensor(714),[G1tensor(658),G1tensor(649),G0tensor(714),G0tensor(658),G0tensor(649)])
  call ol_merge_tensors(G2tensor(226),[G1tensor(719),G1tensor(709),G1tensor(669),G1tensor(659),G1tensor(654),G0tensor(719) &
    ,G0tensor(709),G0tensor(669),G0tensor(659),G0tensor(654)])
  call ol_merge_tensors(G1tensor(724),[G1tensor(668),G1tensor(664),G0tensor(724),G0tensor(668),G0tensor(664)])
  call ol_merge_tensors(G1tensor(678),[G1tensor(673),G0tensor(678),G0tensor(673)])
  call ol_merge_tensors(G1tensor(729),[G1tensor(683),G1tensor(674),G0tensor(729),G0tensor(683),G0tensor(674)])
  call ol_merge_tensors(G1tensor(734),[G1tensor(684),G1tensor(679),G0tensor(734),G0tensor(684),G0tensor(679)])
  call ol_merge_tensors(G1tensor(693),[G1tensor(688),G0tensor(693),G0tensor(688)])
  call ol_merge_tensors(G1tensor(739),[G1tensor(698),G1tensor(689),G0tensor(739),G0tensor(698),G0tensor(689)])
  call ol_merge_tensors(G1tensor(744),[G1tensor(699),G1tensor(694),G0tensor(744),G0tensor(699),G0tensor(694)])
  call ol_merge_tensors(G2tensor(80),[G1tensor(749),G1tensor(708),G1tensor(704),G0tensor(749),G0tensor(708),G0tensor(704)])
  call ol_merge_tensors(G1tensor(754),[G0tensor(754)])
  call ol_merge_tensors(G1tensor(765),[G1tensor(755),G0tensor(765),G0tensor(755)])
  call ol_merge_tensors(G1tensor(759),[G0tensor(759)])
  call ol_merge_tensors(G1tensor(770),[G1tensor(760),G0tensor(770),G0tensor(760)])
  call ol_merge_tensors(G1tensor(764),[G0tensor(764)])
  call ol_merge_tensors(G1tensor(769),[G0tensor(769)])
  call ol_merge_tensors(G1tensor(774),[G0tensor(774)])
  call ol_merge_tensors(G1tensor(775),[G0tensor(775)])
  call ol_merge_tensors(G1tensor(779),[G0tensor(779)])
  call ol_merge_tensors(G1tensor(780),[G0tensor(780)])
  call ol_merge_tensors(G1tensor(794),[G1tensor(784),G0tensor(794),G0tensor(784)])
  call ol_merge_tensors(G1tensor(785),[G0tensor(785)])
  call ol_merge_tensors(G1tensor(799),[G1tensor(789),G0tensor(799),G0tensor(789)])
  call ol_merge_tensors(G1tensor(790),[G0tensor(790)])
  call ol_merge_tensors(G1tensor(795),[G0tensor(795)])
  call ol_merge_tensors(G1tensor(800),[G0tensor(800)])
  call ol_merge_tensors(G2tensor(85),[G1tensor(803),G0tensor(803)])
  call ol_merge_tensors(G2tensor(82),[G1tensor(804),G0tensor(804)])
  call ol_merge_tensors(G2tensor(302),[G2tensor(317),G1tensor(808),G0tensor(808)])
  call ol_merge_tensors(G2tensor(86),[G2tensor(305),G1tensor(809),G0tensor(809)])
  call ol_merge_tensors(G2tensor(83),[G1tensor(813),G0tensor(813)])
  call ol_merge_tensors(G2tensor(229),[G2tensor(89),G1tensor(818),G0tensor(818)])
  call ol_merge_tensors(G2tensor(106),[G2tensor(104),G1tensor(823),G0tensor(823)])
  call ol_merge_tensors(G2tensor(109),[G2tensor(101),G1tensor(824),G0tensor(824)])
  call ol_merge_tensors(G2tensor(118),[G1tensor(828),G0tensor(828)])
  call ol_merge_tensors(G2tensor(124),[G1tensor(833),G0tensor(833)])
  call ol_merge_tensors(G2tensor(137),[G1tensor(838),G0tensor(838)])
  call ol_merge_tensors(G2tensor(134),[G1tensor(843),G0tensor(843)])
  call ol_merge_tensors(G2tensor(205),[G2tensor(165)])
  call TI_triangle_red(G3tensor(25),RedBasis(2),mass3set(:,1),G0tensor(1),G0tensor(6),G0tensor(11),G0tensor(16),M2L1R1)
  call TI_triangle_red(G2tensor(22),RedBasis(7),mass3set(:,2),G0tensor(21),G0tensor(26),G0tensor(31),G0tensor(36),M2L1R1,[nMB], &
    G0tensor(41))
  call TI_triangle_red(G2tensor(95),RedBasis(15),mass3set(:,3),G0tensor(46),G0tensor(51),G0tensor(56),G0tensor(61),M2L1R1,[nMT], &
    G0tensor(66))
  call TI_triangle_red(G2tensor(59),RedBasis(1),mass3set(:,3),G0tensor(71),G0tensor(76),G0tensor(81),G0tensor(86),M2L1R1,[nMT], &
    G0tensor(91))
  call TI_triangle_red(G2tensor(240),RedBasis(56),mass3set(:,4),G0tensor(96),G0tensor(101),G0tensor(106), &
    G0tensor(111),M2L1R1,[nMB],G0tensor(116))
  call TI_triangle_red(G2tensor(8),RedBasis(7),mass3set(:,5),G0tensor(121),G0tensor(126),G0tensor(131),G0tensor(136),M2L1R1,[nMB], &
    G0tensor(141))
  call TI_triangle_red(G2tensor(243),RedBasis(59),mass3set(:,6),G0tensor(146),G0tensor(151),G0tensor(156), &
    G0tensor(161),M2L1R1,[nMB,nMT],G0tensor(166),G0tensor(171))
  call TI_triangle_red(G2tensor(213),RedBasis(8),mass3set(:,7),G0tensor(176),G0tensor(181),G0tensor(186), &
    G0tensor(191),M2L1R1,[nMB,nMT],G0tensor(196),G0tensor(201))
  call TI_triangle_red(G2tensor(136),RedBasis(10),mass3set(:,8),G0tensor(206),G0tensor(211),G0tensor(216), &
    G0tensor(221),M2L1R1,[nMB],G0tensor(226))
  call TI_triangle_red(G3tensor(23),RedBasis(2),mass3set(:,9),G0tensor(231),G0tensor(236),G0tensor(241), &
    G0tensor(246),M2L1R1,[nMB],G0tensor(251))
  call TI_triangle_red(G2tensor(84),RedBasis(10),mass3set(:,10),G0tensor(256),G0tensor(261),G0tensor(266), &
    G0tensor(271),M2L1R1,[nMW,nMT],G0tensor(276),G0tensor(281))
  call TI_triangle_red(G3tensor(11),RedBasis(2),mass3set(:,11),G0tensor(286),G0tensor(291),G0tensor(296), &
    G0tensor(301),M2L1R1,[nMT],G0tensor(306))
  call TI_triangle_red(G2tensor(93),RedBasis(62),mass3set(:,8),G0tensor(311),G0tensor(316),G0tensor(321), &
    G0tensor(326),M2L1R1,[nMB],G0tensor(331))
  call TI_triangle_red(G2tensor(257),RedBasis(62),mass3set(:,10),G0tensor(336),G0tensor(341),G0tensor(346), &
    G0tensor(351),M2L1R1,[nMW,nMT],G0tensor(356),G0tensor(361))
  call TI_triangle_red(G2tensor(216),RedBasis(4),mass3set(:,12),G0tensor(366),G0tensor(371),G0tensor(376), &
    G0tensor(381),M2L1R1,[nMT],G0tensor(386))
  call TI_triangle_red(G2tensor(314),RedBasis(15),mass3set(:,13),G0tensor(391),G0tensor(396),G0tensor(401), &
    G0tensor(406),M2L1R1,[nMT],G0tensor(411))
  call TI_triangle_red(G2tensor(25),RedBasis(10),mass3set(:,14),G0tensor(416),G0tensor(421),G0tensor(426), &
    G0tensor(431),M2L1R1,[nMH,nMB],G0tensor(436),G0tensor(441))
  call TI_triangle_red(G2tensor(48),RedBasis(10),mass3set(:,15),G0tensor(446),G0tensor(451),G0tensor(456), &
    G0tensor(461),M2L1R1,[nMZ,nMB],G0tensor(466),G0tensor(471))
  call TI_triangle_red(G2tensor(105),RedBasis(62),mass3set(:,14),G0tensor(476),G0tensor(481),G0tensor(486), &
    G0tensor(491),M2L1R1,[nMH,nMB],G0tensor(496),G0tensor(501))
  call TI_triangle_red(G2tensor(141),RedBasis(62),mass3set(:,15),G0tensor(506),G0tensor(511),G0tensor(516), &
    G0tensor(521),M2L1R1,[nMZ,nMB],G0tensor(526),G0tensor(531))
  call TI_triangle_red(G2tensor(55),RedBasis(11),mass3set(:,16),G0tensor(536),G0tensor(541),G0tensor(546), &
    G0tensor(551),M2L1R1,[nMB,nMT],G0tensor(556),G0tensor(561))
  call TI_triangle_red(G2tensor(181),RedBasis(22),mass3set(:,16),G0tensor(566),G0tensor(571),G0tensor(576), &
    G0tensor(581),M2L1R1,[nMB,nMT],G0tensor(586),G0tensor(591))
  call TI_triangle_red(G2tensor(52),RedBasis(1),mass3set(:,13),G0tensor(596),G0tensor(601),G0tensor(606), &
    G0tensor(611),M2L1R1,[nMT],G0tensor(616))
  call TI_triangle_red(G2tensor(300),RedBasis(25),mass3set(:,17),G0tensor(621),G0tensor(626),G0tensor(631), &
    G0tensor(636),M2L1R1,[nMT,nMB],G0tensor(641),G0tensor(646))
  call TI_triangle_red(G2tensor(98),RedBasis(58),mass3set(:,13),G0tensor(651),G0tensor(656),G0tensor(661), &
    G0tensor(666),M2L1R1,[nMT],G0tensor(671))
  call TI_triangle_red(G2tensor(91),RedBasis(58),mass3set(:,18),G0tensor(676),G0tensor(681),G0tensor(686), &
    G0tensor(691),M2L1R1,[nMT,nMH],G0tensor(696),G0tensor(701))
  call TI_triangle_red(G2tensor(338),RedBasis(15),mass3set(:,18),G0tensor(706),G0tensor(711),G0tensor(716), &
    G0tensor(721),M2L1R1,[nMT,nMH],G0tensor(726),G0tensor(731))
  call TI_triangle_red(G2tensor(230),RedBasis(58),mass3set(:,19),G0tensor(736),G0tensor(741),G0tensor(746), &
    G0tensor(751),M2L1R1,[nMT,nMZ],G0tensor(756),G0tensor(761))
  call TI_triangle_red(G2tensor(227),RedBasis(15),mass3set(:,19),G0tensor(766),G0tensor(771),G0tensor(776), &
    G0tensor(781),M2L1R1,[nMT,nMZ],G0tensor(786),G0tensor(791))
  call TI_triangle_red(G2tensor(122),RedBasis(58),mass3set(:,20),G0tensor(796),G0tensor(801),G0tensor(806), &
    G0tensor(811),M2L1R1,[nMB,nMW],G0tensor(816),G0tensor(821))
  call TI_triangle_red(G2tensor(320),RedBasis(15),mass3set(:,20),G0tensor(826),G0tensor(831),G0tensor(836), &
    G0tensor(841),M2L1R1,[nMB,nMW],G0tensor(365),G0tensor(315))
  call TI_triangle_red(G2tensor(15),RedBasis(58),mass3set(:,3),G0tensor(34),G0tensor(14),G0tensor(330),G0tensor(20),M2L1R1,[nMT], &
    G0tensor(480))
  call TI_triangle_red(G2tensor(345),RedBasis(60),mass3set(:,13),G0tensor(415),G0tensor(380),G0tensor(45), &
    G0tensor(35),M2L1R1,[nMT],G0tensor(30))
  call TI_triangle_red(G2tensor(333),RedBasis(60),mass3set(:,18),G0tensor(25),G0tensor(345),G0tensor(295), &
    G0tensor(40),M2L1R1,[nMT,nMH],G0tensor(15),G0tensor(10))
  call TI_triangle_red(G2tensor(40),RedBasis(1),mass3set(:,18),G0tensor(5),G0tensor(527),G0tensor(125), &
    G0tensor(85),M2L1R1,[nMT,nMH],G0tensor(530),G0tensor(525))
  call TI_triangle_red(G2tensor(336),RedBasis(60),mass3set(:,19),G0tensor(515),G0tensor(95),G0tensor(75), &
    G0tensor(547),M2L1R1,[nMT,nMZ],G0tensor(124),G0tensor(114))
  call TI_triangle_red(G2tensor(299),RedBasis(1),mass3set(:,19),G0tensor(104),G0tensor(550),G0tensor(540), &
    G0tensor(535),M2L1R1,[nMT,nMZ],G0tensor(119),G0tensor(109))
  call TI_triangle_red(G2tensor(339),RedBasis(60),mass3set(:,20),G0tensor(94),G0tensor(562),G0tensor(328), &
    G0tensor(129),M2L1R1,[nMB,nMW],G0tensor(820),G0tensor(815))
  call TI_triangle_red(G2tensor(67),RedBasis(1),mass3set(:,20),G0tensor(810),G0tensor(805),G0tensor(590), &
    G0tensor(565),M2L1R1,[nMB,nMW],G0tensor(154),G0tensor(134))
  call TI_triangle_red(G2tensor(348),RedBasis(60),mass3set(:,3),G0tensor(572),G0tensor(139),G0tensor(844), &
    G0tensor(839),M2L1R1,[nMT],G0tensor(834))
  call TI_triangle_red(G2tensor(140),RedBasis(16),mass3set(:,12),G0tensor(829),G0tensor(605),G0tensor(575), &
    G0tensor(164),M2L1R1,[nMT],G0tensor(144))
  call TI_triangle_red(G2tensor(153),RedBasis(7),mass3set(:,21),G0tensor(587),G0tensor(149),G0tensor(602), &
    G0tensor(159),M2L1R1,[nMB,nMH],G0tensor(707),G0tensor(280))
  call TI_triangle_red(G2tensor(177),RedBasis(7),mass3set(:,22),G0tensor(240),G0tensor(13),G0tensor(710), &
    G0tensor(700),M2L1R1,[nMB,nMZ],G0tensor(685),G0tensor(610))
  call TI_triangle_red(G2tensor(41),RedBasis(9),mass3set(:,23),G0tensor(270),G0tensor(205),G0tensor(165), &
    G0tensor(802),M2L1R1,[nMB,nMT],G0tensor(807),G0tensor(812))
  call TI_triangle_red(G2tensor(131),RedBasis(4),mass3set(:,24),G0tensor(817),G0tensor(553),G0tensor(548), &
    G0tensor(543),M2L1R1,[nMB,nMW],G0tensor(358),G0tensor(277))
  call TI_triangle_red(G2tensor(56),RedBasis(4),mass3set(:,25),G0tensor(272),G0tensor(267),G0tensor(262), &
    G0tensor(822),M2L1R1,[nMT],G0tensor(798))
  call TI_triangle_red(G2tensor(127),RedBasis(16),mass3set(:,24),G0tensor(793),G0tensor(757),G0tensor(752), &
    G0tensor(397),M2L1R1,[nMB,nMW],G0tensor(393),G0tensor(825))
  call TI_triangle_red(G2tensor(284),RedBasis(16),mass3set(:,25),G0tensor(580),G0tensor(175),G0tensor(145), &
    G0tensor(748),M2L1R1,[nMT],G0tensor(723))
  call TI_triangle_red(G2tensor(139),RedBasis(6),mass3set(:,2),G0tensor(718),G0tensor(713),G0tensor(122), &
    G0tensor(97),M2L1R1,[nMB],G0tensor(92))
  call TI_triangle_red(G2tensor(99),RedBasis(13),mass3set(:,26),G0tensor(87),G0tensor(162),G0tensor(157), &
    G0tensor(827),M2L1R1,[nMT,nMB],G0tensor(830),G0tensor(660))
  call TI_triangle_red(G2tensor(113),RedBasis(20),mass3set(:,27),G0tensor(250),G0tensor(215),G0tensor(832), &
    G0tensor(835),M2L1R1,[nMT,nMB],G0tensor(670),G0tensor(260))
  call TI_triangle_red(G2tensor(116),RedBasis(21),mass3set(:,28),G0tensor(225),G0tensor(152),G0tensor(147), &
    G0tensor(595),M2L1R1,[nMT,nMB],G0tensor(195),G0tensor(155))
  call TI_triangle_red(G2tensor(133),RedBasis(14),mass3set(:,2),G0tensor(427),G0tensor(392),G0tensor(83), &
    G0tensor(32),M2L1R1,[nMB],G0tensor(142))
  call TI_triangle_red(G2tensor(4),RedBasis(3),mass3set(:,2),G0tensor(137),G0tensor(837),G0tensor(840),G0tensor(842),M2L1R1,[nMB], &
    G0tensor(845))
  call TI_triangle_red(G2tensor(2),RedBasis(62),mass3set(:,29),G0tensor(318),G0tensor(132),G0tensor(127), &
    G0tensor(570),M2L1R1,[nMB],G0tensor(185))
  call TI_triangle_red(G2tensor(20),RedBasis(56),mass3set(:,30),G0tensor(135),G0tensor(357),G0tensor(307), &
    G0tensor(123),M2L1R1,[nMB],G0tensor(12))
  call TI_triangle_red(G2tensor(6),RedBasis(12),mass3set(:,2),G0tensor(332),G0tensor(282),G0tensor(88),G0tensor(2),M2L1R1,[nMB], &
    G0tensor(657))
  call TI_triangle_red(G2tensor(14),RedBasis(10),mass3set(:,29),G0tensor(245),G0tensor(210),G0tensor(3), &
    G0tensor(340),M2L1R1,[nMB],G0tensor(290))
  call TI_triangle_red(G2tensor(47),RedBasis(61),mass3set(:,23),G0tensor(24),G0tensor(4),G0tensor(347), &
    G0tensor(297),M2L1R1,[nMB,nMT],G0tensor(98),G0tensor(7))
  call TI_triangle_red(G2tensor(72),RedBasis(17),mass3set(:,26),G0tensor(667),G0tensor(255),G0tensor(220), &
    G0tensor(8),M2L1R1,[nMT,nMB],G0tensor(355),G0tensor(305))
  call TI_triangle_red(G2tensor(73),RedBasis(14),mass3set(:,31),G0tensor(29),G0tensor(9),G0tensor(637), &
    G0tensor(317),M2L1R1,[nMT,nMW],G0tensor(198),G0tensor(17))
  call TI_triangle_red(G2tensor(5),RedBasis(24),mass3set(:,32),G0tensor(567),G0tensor(180),G0tensor(130), &
    G0tensor(18),M2L1R1,[nMT],G0tensor(325))
  call TI_triangle_red(G2tensor(296),RedBasis(23),mass3set(:,3),G0tensor(39),G0tensor(19),G0tensor(402), &
    G0tensor(367),M2L1R1,[nMT],G0tensor(68))
  call TI_triangle_red(G2tensor(53),RedBasis(3),mass3set(:,5),G0tensor(22),G0tensor(410),G0tensor(375),G0tensor(23),M2L1R1,[nMB], &
    G0tensor(417))
  call TI_triangle_red(G2tensor(88),RedBasis(3),mass3set(:,21),G0tensor(382),G0tensor(78),G0tensor(27), &
    G0tensor(425),M2L1R1,[nMB,nMH],G0tensor(390),G0tensor(28))
  call TI_triangle_red(G2tensor(103),RedBasis(3),mass3set(:,22),G0tensor(435),G0tensor(400),G0tensor(33), &
    G0tensor(597),M2L1R1,[nMB,nMZ],G0tensor(437),G0tensor(158))
  call TI_triangle_red(G2tensor(70),RedBasis(14),mass3set(:,5),G0tensor(37),G0tensor(445),G0tensor(38),G0tensor(773),M2L1R1,[nMB], &
    G0tensor(462))
  call TI_triangle_red(G2tensor(71),RedBasis(12),mass3set(:,5),G0tensor(447),G0tensor(138),G0tensor(42), &
    G0tensor(470),M2L1R1,[nMB],G0tensor(455))
  call TI_triangle_red(G2tensor(341),RedBasis(12),mass3set(:,31),G0tensor(43),G0tensor(475),G0tensor(460), &
    G0tensor(44),M2L1R1,[nMT,nMW],G0tensor(52),G0tensor(47))
  call TI_triangle_red(G2tensor(329),RedBasis(6),mass3set(:,5),G0tensor(792),G0tensor(482),G0tensor(48), &
    G0tensor(487),M2L1R1,[nMB],G0tensor(189))
  call TI_triangle_red(G2tensor(74),RedBasis(6),mass3set(:,31),G0tensor(84),G0tensor(59),G0tensor(49), &
    G0tensor(492),M2L1R1,[nMT,nMW],G0tensor(105),G0tensor(50))
  call TI_triangle_red(G2tensor(79),RedBasis(3),mass3set(:,31),G0tensor(485),G0tensor(53),G0tensor(520), &
    G0tensor(510),M2L1R1,[nMT,nMW],G0tensor(490),G0tensor(194))
  call TI_triangle_red(G2tensor(226),RedBasis(23),mass3set(:,13),G0tensor(74),G0tensor(64),G0tensor(54), &
    G0tensor(495),M2L1R1,[nMT],G0tensor(110))
  call TI_triangle_red(G2tensor(80),RedBasis(24),mass3set(:,33),G0tensor(55),G0tensor(62),G0tensor(57),G0tensor(797),M2L1R1,[nMT], &
    G0tensor(497))
  call TI_triangle_red(G2tensor(85),RedBasis(14),mass3set(:,21),G0tensor(58),G0tensor(502),G0tensor(115), &
    G0tensor(60),M2L1R1,[nMB,nMH],G0tensor(500),G0tensor(63))
  call TI_triangle_red(G2tensor(82),RedBasis(12),mass3set(:,21),G0tensor(505),G0tensor(120),G0tensor(65), &
    G0tensor(772),M2L1R1,[nMB,nMH],G0tensor(82),G0tensor(77))
  call TI_triangle_red(G2tensor(302),RedBasis(14),mass3set(:,22),G0tensor(72),G0tensor(67),G0tensor(507), &
    G0tensor(69),M2L1R1,[nMB,nMZ],G0tensor(512),G0tensor(90))
  call TI_triangle_red(G2tensor(86),RedBasis(12),mass3set(:,22),G0tensor(70),G0tensor(450),G0tensor(430), &
    G0tensor(420),M2L1R1,[nMB,nMZ],G0tensor(412),G0tensor(405))
  call TI_triangle_red(G2tensor(83),RedBasis(6),mass3set(:,21),G0tensor(73),G0tensor(517),G0tensor(79), &
    G0tensor(522),M2L1R1,[nMB,nMH],G0tensor(100),G0tensor(80))
  call TI_triangle_red(G2tensor(229),RedBasis(6),mass3set(:,22),G0tensor(532),G0tensor(89),G0tensor(360), &
    G0tensor(350),M2L1R1,[nMB,nMZ],G0tensor(342),G0tensor(335))



end subroutine vamp_3

end module ol_vamp_3_ppttj_ew_ttxbbxg_1_/**/REALKIND
