
module ol_vamp_2_ppttj_ew_uuxttxg_4_/**/REALKIND
contains

! **********************************************************************
subroutine vamp_2(M)
! P(0:3,nlegs) = incoming external momenta
! Uses tree structures 'wf', factors 'c', and denominators 'den' from loop_ppttj_ew_uuxttxg_4.
! Sets colour stripped amplitudes A from the module loop_amplitudes_ppttj_ew_uuxttxg_4.
! **********************************************************************
  use KIND_TYPES, only: REALKIND, QREALKIND, intkind2
  use ol_parameters_decl_/**/DREALKIND, only: l_switch
  use ol_parameters_decl_/**/QREALKIND ! masses
  use ol_vert_interface_/**/REALKIND
  use ol_prop_interface_/**/REALKIND
  use ol_last_step_/**/REALKIND
  use ol_tables_storage_ppttj_ew_uuxttxg_4_/**/DREALKIND
  use ol_tensor_sum_storage_ppttj_ew_uuxttxg_4_/**/REALKIND
  use ol_loop_handling_/**/REALKIND
  use ofred_reduction_/**/REALKIND, only: Hotf_4pt_reduction, Hotf_4pt_reduction_last
  use ofred_reduction_/**/REALKIND, only: Hotf_5pt_reduction, Hotf_5pt_reduction_last
  use ol_loop_reduction_/**/REALKIND, only: TI_bubble_red, TI_triangle_red
use ol_loop_reduction_/**/REALKIND, only: compute_scalar_box

  use ol_loop_storage_ppttj_ew_uuxttxg_4_/**/REALKIND
#ifndef PRECISION_dp
  use ol_loop_storage_ppttj_ew_uuxttxg_4_/**/DREALKIND, only: &
    & p_switch, Hel, merge_step, merge_mism, merge_tables, merge_hels, ntryL
#endif
  use hol_initialisation_/**/REALKIND, only: G0_hol_initialisation
  use ol_h_vert_interface_/**/REALKIND
  use ol_h_prop_interface_/**/REALKIND
  use ol_h_last_step_/**/REALKIND
  use ol_merging_/**/REALKIND, only: ol_merge, ol_merge_tensors, ol_merge_last

  implicit none

  type(Hpolcont) :: Gcoeff(32)
  type(Hpolcont), intent(in) :: M(2,32)


#ifndef PRECISION_dp
  if (ntryL==1 .OR. p_switch == 1) Gcoeff(:)%hf = Hel
#else
  if (ntryL==1 .OR. p_switch == 2) Gcoeff(:)%hf = Hel
#endif

  ! =============================================
  Gcoeff(:)%j = (c(15)*M(1,:)%j) * den(15)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(197),h0tab(:,197),[18,1,12],[0,nMW,nMW],3,2,wf4(:,12),wf4(:,8))
  call Hloop_WA_Q(ntryL,G0H32(1),wf4(:,12),G0H8(37),m3h4x8(:,103),heltab2x32(:,:,197))
  call Hloop_A_Q(ntryL,G0H8(37),18,0,G1H8(31),n2h8(49))
  Gcoeff(:)%j = (c(7)*M(1,:)%j) * den(16)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(198),h0tab(:,198),[18,1,12],[0,nMW,nMW],3,2,wf4(:,12),wf4(:,10))
  call Hloop_WA_Q(ntryL,G0H32(1),wf4(:,12),G0H8(37),m3h4x8(:,104),heltab2x32(:,:,198))
  call Hloop_A_Q(ntryL,G0H8(37),18,0,G1H8(32),n2h8(50))
  Gcoeff(:)%j = (c(1)*M(1,:)%j) * den(55)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(199),h0tab(:,199),[16,2,13],[0,0,0],3,1,wf8(:,40))
  call Hloop_QV_A(ntryL,G0H32(1),ex5(:),G0H16(1),m3h2x16(:,95),heltab2x32(:,:,199))
  call Hloop_Q_A(ntryL,G0H16(1),16,0,G1H16(25),n2h16(95))
  Gcoeff(:)%j = (c(2)*M(1,:)%j) * den(55)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(200),h0tab(:,200),[16,2,13],[0,nMZ,0],3,1,wf8(:,40))
  call Hloop_QV_A(ntryL,G0H32(1),ex5(:),G0H16(1),m3h2x16(:,96),heltab2x32(:,:,200))
  call Hloop_Q_A(ntryL,G0H16(1),16,0,G1H16(26),n2h16(96))
  Gcoeff(:)%j = (c(14)*M(1,:)%j) * den(55)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(201),h0tab(:,201),[16,2,13],[0,nMW,0],3,1,wf8(:,40))
  call Hloop_QV_A(ntryL,G0H32(1),ex5(:),G0H16(1),m3h2x16(:,97),heltab2x32(:,:,201))
  call Hloop_Q_A(ntryL,G0H16(1),16,0,G1H16(27),n2h16(97))
  Gcoeff(:)%j = (c(2)*M(1,:)%j) * den(57)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(202),h0tab(:,202),[16,2,13],[0,0,0],3,1,wf8(:,42))
  call Hloop_QV_A(ntryL,G0H32(1),ex5(:),G0H16(1),m3h2x16(:,98),heltab2x32(:,:,202))
  call Hloop_Q_A(ntryL,G0H16(1),16,0,G1H16(28),n2h16(98))
  Gcoeff(:)%j = (c(3)*M(1,:)%j) * den(57)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(203),h0tab(:,203),[16,2,13],[0,nMZ,0],3,1,wf8(:,42))
  call Hloop_QV_A(ntryL,G0H32(1),ex5(:),G0H16(1),m3h2x16(:,99),heltab2x32(:,:,203))
  call Hloop_Q_A(ntryL,G0H16(1),16,0,G1H16(29),n2h16(99))
  Gcoeff(:)%j = (c(16)*M(1,:)%j) * den(57)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(204),h0tab(:,204),[16,2,13],[0,nMW,0],3,1,wf8(:,42))
  call Hloop_QV_A(ntryL,G0H32(1),ex5(:),G0H16(1),m3h2x16(:,100),heltab2x32(:,:,204))
  call Hloop_Q_A(ntryL,G0H16(1),16,0,G1H16(30),n2h16(100))
  Gcoeff(:)%j = (c(1)*M(1,:)%j) * den(42)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(205),h0tab(:,205),[16,1,14],[0,0,0],3,1,wf8(:,36))
  call Hloop_AV_Q(ntryL,G0H32(1),ex5(:),G0H16(1),m3h2x16(:,101),heltab2x32(:,:,205))
  call Hloop_A_Q(ntryL,G0H16(1),16,0,G1H16(31),n2h16(101))
  Gcoeff(:)%j = (c(2)*M(1,:)%j) * den(42)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(206),h0tab(:,206),[16,1,14],[0,nMZ,0],3,1,wf8(:,36))
  call Hloop_AV_Q(ntryL,G0H32(1),ex5(:),G0H16(1),m3h2x16(:,102),heltab2x32(:,:,206))
  call Hloop_A_Q(ntryL,G0H16(1),16,0,G1H16(32),n2h16(102))
  Gcoeff(:)%j = (c(14)*M(1,:)%j) * den(42)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(207),h0tab(:,207),[16,1,14],[0,nMW,0],3,1,wf8(:,36))
  call Hloop_AV_Q(ntryL,G0H32(1),ex5(:),G0H16(1),m3h2x16(:,103),heltab2x32(:,:,207))
  call Hloop_A_Q(ntryL,G0H16(1),16,0,G1H16(33),n2h16(103))
  Gcoeff(:)%j = (c(2)*M(1,:)%j) * den(44)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(208),h0tab(:,208),[16,1,14],[0,0,0],3,1,wf8(:,38))
  call Hloop_AV_Q(ntryL,G0H32(1),ex5(:),G0H16(1),m3h2x16(:,104),heltab2x32(:,:,208))
  call Hloop_A_Q(ntryL,G0H16(1),16,0,G1H16(34),n2h16(104))
  Gcoeff(:)%j = (c(3)*M(1,:)%j) * den(44)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(209),h0tab(:,209),[16,1,14],[0,nMZ,0],3,1,wf8(:,38))
  call Hloop_AV_Q(ntryL,G0H32(1),ex5(:),G0H16(1),m3h2x16(:,105),heltab2x32(:,:,209))
  call Hloop_A_Q(ntryL,G0H16(1),16,0,G1H16(35),n2h16(105))
  Gcoeff(:)%j = (c(16)*M(1,:)%j) * den(44)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(210),h0tab(:,210),[16,1,14],[0,nMW,0],3,1,wf8(:,38))
  call Hloop_AV_Q(ntryL,G0H32(1),ex5(:),G0H16(1),m3h2x16(:,106),heltab2x32(:,:,210))
  call Hloop_A_Q(ntryL,G0H16(1),16,0,G1H16(36),n2h16(106))
  Gcoeff(:)%j = (-(c(27)*M(1,:)%j)) * den(47)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(211),h0tab(:,211),[19,4,8],[nMT,nMH,nMT],3,1,wf8(:,5))
  call Hloop_AV_Q(ntryL,G0H32(1),wf8(:,5),G0H4(1),m3h8x4(:,1),heltab2x32(:,:,211))
  call Hloop_A_Q(ntryL,G0H4(1),19,nMT,G1H4(37),n2h4(73))
  Gcoeff(:)%j = (c(27)*M(1,:)%j) * den(47)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(212),h0tab(:,212),[19,4,8],[nMT,nMZ,nMT],3,1,wf8(:,5))
  call Hloop_AV_Q(ntryL,G0H32(1),wf8(:,5),G0H4(1),m3h8x4(:,2),heltab2x32(:,:,212))
  call Hloop_A_Q(ntryL,G0H4(1),19,nMT,G1H4(1),n2h4(74))
  Gcoeff(:)%j = (-(c(22)*M(1,:)%j)) * den(47)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(213),h0tab(:,213),[19,4,8],[nMB,nMW,nMB],3,1,wf8(:,5))
  call Hloop_AV_Q(ntryL,G0H32(1),wf8(:,5),G0H4(1),m3h8x4(:,3),heltab2x32(:,:,213))
  call Hloop_A_Q(ntryL,G0H4(1),19,nMB,G1H4(4),n2h4(75))
  Gcoeff(:)%j = (-(c(28)*M(1,:)%j)) * den(50)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(214),h0tab(:,214),[19,4,8],[nMT,nMH,nMT],3,1,wf8(:,6))
  call Hloop_AZ_Q(ntryL,G0H32(1),wf8(:,6),G0H4(1),ngZu,m3h8x4(:,4),heltab2x32(:,:,214))
  call Hloop_A_Q(ntryL,G0H4(1),19,nMT,G1H4(5),n2h4(76))
  Gcoeff(:)%j = (c(28)*M(1,:)%j) * den(50)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(215),h0tab(:,215),[19,4,8],[nMT,nMZ,nMT],3,1,wf8(:,6))
  call Hloop_AZ_Q(ntryL,G0H32(1),wf8(:,6),G0H4(1),ngZu,m3h8x4(:,5),heltab2x32(:,:,215))
  call Hloop_A_Q(ntryL,G0H4(1),19,nMT,G1H4(6),n2h4(77))
  Gcoeff(:)%j = (c(25)*M(1,:)%j) * den(50)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(216),h0tab(:,216),[19,4,8],[nMB,nMW,nMB],3,1,wf8(:,6))
  call Hloop_AZ_Q(ntryL,G0H32(1),wf8(:,6),G0H4(1),ngZd,m3h8x4(:,6),heltab2x32(:,:,216))
  call Hloop_A_Q(ntryL,G0H4(1),19,nMB,G1H4(9),n2h4(78))
  Gcoeff(:)%j = (c(24)*M(1,:)%j) * den(47)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(217),h0tab(:,217),[19,4,8],[nMW,nMB,nMW],3,1,wf8(:,5))
  call Hloop_TV_S(ntryL,G0H32(1),0,wf8(:,5),19,G1H4(10),m3h8x4(:,7),heltab2x32(:,:,217))
  Gcoeff(:)%j = (-(c(12)*M(1,:)%j)) * den(50)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(218),h0tab(:,218),[19,4,8],[nMH,nMT,nMZ],3,1,wf8(:,6))
  call Hloop_SV_T(ntryL,G0H32(1),0,wf8(:,6),19,G1H4(11),m3h8x4(:,8),heltab2x32(:,:,218))
  Gcoeff(:)%j = (-(c(12)*M(1,:)%j)) * den(50)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(219),h0tab(:,219),[19,4,8],[nMZ,nMT,nMH],3,1,wf8(:,6))
  call Hloop_TV_S(ntryL,G0H32(1),0,wf8(:,6),19,G1H4(14),m3h8x4(:,9),heltab2x32(:,:,219))
  Gcoeff(:)%j = (-(c(35)*M(1,:)%j)) * den(50)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(220),h0tab(:,220),[19,4,8],[nMW,nMB,nMW],3,1,wf8(:,6))
  call Hloop_TV_S(ntryL,G0H32(1),0,wf8(:,6),19,G1H4(15),m3h8x4(:,10),heltab2x32(:,:,220))
  Gcoeff(:)%j = (c(1)*M(1,:)%j) * den(47)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(221),h0tab(:,221),[19,4,8],[nMT,0,nMT],3,1,wf8(:,5))
  call Hloop_AV_Q(ntryL,G0H32(1),wf8(:,5),G0H4(1),m3h8x4(:,11),heltab2x32(:,:,221))
  call Hloop_A_Q(ntryL,G0H4(1),19,nMT,G1H4(16),n2h4(79))
  Gcoeff(:)%j = (c(2)*M(1,:)%j) * den(47)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(222),h0tab(:,222),[19,4,8],[nMT,nMZ,nMT],3,1,wf8(:,5))
  call Hloop_AV_Q(ntryL,G0H32(1),wf8(:,5),G0H4(1),m3h8x4(:,12),heltab2x32(:,:,222))
  call Hloop_A_Q(ntryL,G0H4(1),19,nMT,G1H4(19),n2h4(80))
  Gcoeff(:)%j = (-(c(13)*M(1,:)%j)) * den(47)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(223),h0tab(:,223),[19,4,8],[nMB,nMW,nMB],3,1,wf8(:,5))
  call Hloop_AV_Q(ntryL,G0H32(1),wf8(:,5),G0H4(1),m3h8x4(:,13),heltab2x32(:,:,223))
  call Hloop_A_Q(ntryL,G0H4(1),19,nMB,G1H4(20),n2h4(81))
  Gcoeff(:)%j = (c(2)*M(1,:)%j) * den(50)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(224),h0tab(:,224),[19,4,8],[nMT,0,nMT],3,1,wf8(:,6))
  call Hloop_AZ_Q(ntryL,G0H32(1),wf8(:,6),G0H4(1),ngZu,m3h8x4(:,14),heltab2x32(:,:,224))
  call Hloop_A_Q(ntryL,G0H4(1),19,nMT,G1H4(21),n2h4(82))
  Gcoeff(:)%j = (c(3)*M(1,:)%j) * den(50)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(225),h0tab(:,225),[19,4,8],[nMT,nMZ,nMT],3,1,wf8(:,6))
  call Hloop_AZ_Q(ntryL,G0H32(1),wf8(:,6),G0H4(1),ngZu,m3h8x4(:,15),heltab2x32(:,:,225))
  call Hloop_A_Q(ntryL,G0H4(1),19,nMT,G1H4(24),n2h4(83))
  Gcoeff(:)%j = (c(16)*M(1,:)%j) * den(50)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(226),h0tab(:,226),[19,4,8],[nMB,nMW,nMB],3,1,wf8(:,6))
  call Hloop_AZ_Q(ntryL,G0H32(1),wf8(:,6),G0H4(1),ngZd,m3h8x4(:,16),heltab2x32(:,:,226))
  call Hloop_A_Q(ntryL,G0H4(1),19,nMB,G1H4(25),n2h4(84))
  Gcoeff(:)%j = (-(c(15)*M(1,:)%j)) * den(47)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(227),h0tab(:,227),[19,4,8],[nMW,nMB,nMW],3,1,wf8(:,5))
  call Hloop_VV_S(ntryL,G0H32(1),wf8(:,5),G0H4(1),m3h8x4(:,17),heltab2x32(:,:,227))
  Gcoeff(:)%j = (-(c(21)*M(1,:)%j)) * den(50)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(228),h0tab(:,228),[19,4,8],[nMH,nMT,nMZ],3,1,wf8(:,6))
  call Hloop_VV_S(ntryL,G0H32(1),wf8(:,6),G0H4(2),m3h8x4(:,18),heltab2x32(:,:,228))
  Gcoeff(:)%j = (c(30)*M(1,:)%j) * den(50)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(229),h0tab(:,229),[19,4,8],[nMW,nMB,nMW],3,1,wf8(:,6))
  call Hloop_VV_S(ntryL,G0H32(1),wf8(:,6),G0H4(3),m3h8x4(:,19),heltab2x32(:,:,229))
  Gcoeff(:)%j = (c(15)*M(1,:)%j) * den(47)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(230),h0tab(:,230),[19,4,8],[nMW,nMB,nMW],3,1,wf8(:,5))
  call Hloop_SV_V(ntryL,G0H32(1),wf8(:,5),G0H4(4),m3h8x4(:,20),heltab2x32(:,:,230))
  Gcoeff(:)%j = (-(c(21)*M(1,:)%j)) * den(50)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(231),h0tab(:,231),[19,4,8],[nMZ,nMT,nMH],3,1,wf8(:,6))
  call Hloop_SV_V(ntryL,G0H32(1),wf8(:,6),G0H4(5),m3h8x4(:,21),heltab2x32(:,:,231))
  Gcoeff(:)%j = (-(c(30)*M(1,:)%j)) * den(50)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(232),h0tab(:,232),[19,4,8],[nMW,nMB,nMW],3,1,wf8(:,6))
  call Hloop_SV_V(ntryL,G0H32(1),wf8(:,6),G0H4(6),m3h8x4(:,22),heltab2x32(:,:,232))
  Gcoeff(:)%j = (c(15)*M(1,:)%j) * den(47)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(233),h0tab(:,233),[19,4,8],[nMW,nMB,nMW],3,1,wf8(:,5))
  call Hloop_UV_W(ntryL,G0H32(1),0,wf8(:,5),19,G1H4(26),m3h8x4(:,23),heltab2x32(:,:,233))
  Gcoeff(:)%j = (c(7)*M(1,:)%j) * den(50)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(234),h0tab(:,234),[19,4,8],[nMW,nMB,nMW],3,1,wf8(:,6))
  call Hloop_UV_W(ntryL,G0H32(1),0,wf8(:,6),19,G1H4(29),m3h8x4(:,24),heltab2x32(:,:,234))
  Gcoeff(:)%j = (-(c(27)*M(1,:)%j)) * den(59)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(235),h0tab(:,235),[19,4,8],[nMT,nMH,nMT],3,1,wf8(:,7))
  call Hloop_AV_Q(ntryL,G0H32(1),wf8(:,7),G0H4(7),m3h8x4(:,25),heltab2x32(:,:,235))
  call Hloop_A_Q(ntryL,G0H4(7),19,nMT,G1H4(30),n2h4(85))
  Gcoeff(:)%j = (c(27)*M(1,:)%j) * den(59)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(236),h0tab(:,236),[19,4,8],[nMT,nMZ,nMT],3,1,wf8(:,7))
  call Hloop_AV_Q(ntryL,G0H32(1),wf8(:,7),G0H4(7),m3h8x4(:,26),heltab2x32(:,:,236))
  call Hloop_A_Q(ntryL,G0H4(7),19,nMT,G1H4(31),n2h4(86))
  Gcoeff(:)%j = (-(c(22)*M(1,:)%j)) * den(59)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(237),h0tab(:,237),[19,4,8],[nMB,nMW,nMB],3,1,wf8(:,7))
  call Hloop_AV_Q(ntryL,G0H32(1),wf8(:,7),G0H4(7),m3h8x4(:,27),heltab2x32(:,:,237))
  call Hloop_A_Q(ntryL,G0H4(7),19,nMB,G1H4(34),n2h4(87))
  Gcoeff(:)%j = (-(c(28)*M(1,:)%j)) * den(61)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(238),h0tab(:,238),[19,4,8],[nMT,nMH,nMT],3,1,wf8(:,8))
  call Hloop_AZ_Q(ntryL,G0H32(1),wf8(:,8),G0H4(7),ngZu,m3h8x4(:,28),heltab2x32(:,:,238))
  call Hloop_A_Q(ntryL,G0H4(7),19,nMT,G1H4(35),n2h4(88))
  Gcoeff(:)%j = (c(28)*M(1,:)%j) * den(61)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(239),h0tab(:,239),[19,4,8],[nMT,nMZ,nMT],3,1,wf8(:,8))
  call Hloop_AZ_Q(ntryL,G0H32(1),wf8(:,8),G0H4(7),ngZu,m3h8x4(:,29),heltab2x32(:,:,239))
  call Hloop_A_Q(ntryL,G0H4(7),19,nMT,G1H4(36),n2h4(89))
  Gcoeff(:)%j = (c(25)*M(1,:)%j) * den(61)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(240),h0tab(:,240),[19,4,8],[nMB,nMW,nMB],3,1,wf8(:,8))
  call Hloop_AZ_Q(ntryL,G0H32(1),wf8(:,8),G0H4(7),ngZd,m3h8x4(:,30),heltab2x32(:,:,240))
  call Hloop_A_Q(ntryL,G0H4(7),19,nMB,G1H4(40),n2h4(90))
  Gcoeff(:)%j = (c(24)*M(1,:)%j) * den(59)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(241),h0tab(:,241),[19,4,8],[nMW,nMB,nMW],3,1,wf8(:,7))
  call Hloop_TV_S(ntryL,G0H32(1),0,wf8(:,7),19,G1H4(41),m3h8x4(:,31),heltab2x32(:,:,241))
  Gcoeff(:)%j = (-(c(12)*M(1,:)%j)) * den(61)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(242),h0tab(:,242),[19,4,8],[nMH,nMT,nMZ],3,1,wf8(:,8))
  call Hloop_SV_T(ntryL,G0H32(1),0,wf8(:,8),19,G1H4(42),m3h8x4(:,32),heltab2x32(:,:,242))
  Gcoeff(:)%j = (-(c(12)*M(1,:)%j)) * den(61)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(243),h0tab(:,243),[19,4,8],[nMZ,nMT,nMH],3,1,wf8(:,8))
  call Hloop_TV_S(ntryL,G0H32(1),0,wf8(:,8),19,G1H4(45),m3h8x4(:,33),heltab2x32(:,:,243))
  Gcoeff(:)%j = (-(c(35)*M(1,:)%j)) * den(61)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(244),h0tab(:,244),[19,4,8],[nMW,nMB,nMW],3,1,wf8(:,8))
  call Hloop_TV_S(ntryL,G0H32(1),0,wf8(:,8),19,G1H4(46),m3h8x4(:,34),heltab2x32(:,:,244))
  Gcoeff(:)%j = (c(1)*M(1,:)%j) * den(59)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(245),h0tab(:,245),[19,4,8],[nMT,0,nMT],3,1,wf8(:,7))
  call Hloop_AV_Q(ntryL,G0H32(1),wf8(:,7),G0H4(7),m3h8x4(:,35),heltab2x32(:,:,245))
  call Hloop_A_Q(ntryL,G0H4(7),19,nMT,G1H4(47),n2h4(91))
  Gcoeff(:)%j = (c(2)*M(1,:)%j) * den(59)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(246),h0tab(:,246),[19,4,8],[nMT,nMZ,nMT],3,1,wf8(:,7))
  call Hloop_AV_Q(ntryL,G0H32(1),wf8(:,7),G0H4(7),m3h8x4(:,36),heltab2x32(:,:,246))
  call Hloop_A_Q(ntryL,G0H4(7),19,nMT,G1H4(50),n2h4(92))
  Gcoeff(:)%j = (-(c(13)*M(1,:)%j)) * den(59)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(247),h0tab(:,247),[19,4,8],[nMB,nMW,nMB],3,1,wf8(:,7))
  call Hloop_AV_Q(ntryL,G0H32(1),wf8(:,7),G0H4(7),m3h8x4(:,37),heltab2x32(:,:,247))
  call Hloop_A_Q(ntryL,G0H4(7),19,nMB,G1H4(51),n2h4(93))
  Gcoeff(:)%j = (c(2)*M(1,:)%j) * den(61)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(248),h0tab(:,248),[19,4,8],[nMT,0,nMT],3,1,wf8(:,8))
  call Hloop_AZ_Q(ntryL,G0H32(1),wf8(:,8),G0H4(7),ngZu,m3h8x4(:,38),heltab2x32(:,:,248))
  call Hloop_A_Q(ntryL,G0H4(7),19,nMT,G1H4(52),n2h4(94))
  Gcoeff(:)%j = (c(3)*M(1,:)%j) * den(61)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(249),h0tab(:,249),[19,4,8],[nMT,nMZ,nMT],3,1,wf8(:,8))
  call Hloop_AZ_Q(ntryL,G0H32(1),wf8(:,8),G0H4(7),ngZu,m3h8x4(:,39),heltab2x32(:,:,249))
  call Hloop_A_Q(ntryL,G0H4(7),19,nMT,G1H4(55),n2h4(95))
  Gcoeff(:)%j = (c(16)*M(1,:)%j) * den(61)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(250),h0tab(:,250),[19,4,8],[nMB,nMW,nMB],3,1,wf8(:,8))
  call Hloop_AZ_Q(ntryL,G0H32(1),wf8(:,8),G0H4(7),ngZd,m3h8x4(:,40),heltab2x32(:,:,250))
  call Hloop_A_Q(ntryL,G0H4(7),19,nMB,G1H4(56),n2h4(96))
  Gcoeff(:)%j = (-(c(15)*M(1,:)%j)) * den(59)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(251),h0tab(:,251),[19,4,8],[nMW,nMB,nMW],3,1,wf8(:,7))
  call Hloop_VV_S(ntryL,G0H32(1),wf8(:,7),G0H4(7),m3h8x4(:,41),heltab2x32(:,:,251))
  Gcoeff(:)%j = (-(c(21)*M(1,:)%j)) * den(61)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(252),h0tab(:,252),[19,4,8],[nMH,nMT,nMZ],3,1,wf8(:,8))
  call Hloop_VV_S(ntryL,G0H32(1),wf8(:,8),G0H4(8),m3h8x4(:,42),heltab2x32(:,:,252))
  Gcoeff(:)%j = (c(30)*M(1,:)%j) * den(61)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(253),h0tab(:,253),[19,4,8],[nMW,nMB,nMW],3,1,wf8(:,8))
  call Hloop_VV_S(ntryL,G0H32(1),wf8(:,8),G0H4(9),m3h8x4(:,43),heltab2x32(:,:,253))
  Gcoeff(:)%j = (c(15)*M(1,:)%j) * den(59)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(254),h0tab(:,254),[19,4,8],[nMW,nMB,nMW],3,1,wf8(:,7))
  call Hloop_SV_V(ntryL,G0H32(1),wf8(:,7),G0H4(10),m3h8x4(:,44),heltab2x32(:,:,254))
  Gcoeff(:)%j = (-(c(21)*M(1,:)%j)) * den(61)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(255),h0tab(:,255),[19,4,8],[nMZ,nMT,nMH],3,1,wf8(:,8))
  call Hloop_SV_V(ntryL,G0H32(1),wf8(:,8),G0H4(11),m3h8x4(:,45),heltab2x32(:,:,255))
  Gcoeff(:)%j = (-(c(30)*M(1,:)%j)) * den(61)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(256),h0tab(:,256),[19,4,8],[nMW,nMB,nMW],3,1,wf8(:,8))
  call Hloop_SV_V(ntryL,G0H32(1),wf8(:,8),G0H4(12),m3h8x4(:,46),heltab2x32(:,:,256))
  Gcoeff(:)%j = (c(15)*M(1,:)%j) * den(59)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(257),h0tab(:,257),[19,4,8],[nMW,nMB,nMW],3,1,wf8(:,7))
  call Hloop_UV_W(ntryL,G0H32(1),0,wf8(:,7),19,G1H4(57),m3h8x4(:,47),heltab2x32(:,:,257))
  Gcoeff(:)%j = (c(7)*M(1,:)%j) * den(61)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(258),h0tab(:,258),[19,4,8],[nMW,nMB,nMW],3,1,wf8(:,8))
  call Hloop_UV_W(ntryL,G0H32(1),0,wf8(:,8),19,G1H4(60),m3h8x4(:,48),heltab2x32(:,:,258))
  Gcoeff(:)%j = (-(c(21)*M(2,:)%j)) * den(67)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(259),h0tab(:,259),[28,1,2],[nMZ,0,nMZ],3,1,wf8(:,43))
  call Hloop_VS_V(ntryL,G0H32(1),wf8(:,43),G0H4(13),m3h8x4(:,49),heltab2x32(:,:,259))
  Gcoeff(:)%j = (-(c(6)*M(2,:)%j)) * den(67)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(260),h0tab(:,260),[28,1,2],[nMW,0,nMW],3,1,wf8(:,43))
  call Hloop_VS_V(ntryL,G0H32(1),wf8(:,43),G0H4(14),m3h8x4(:,50),heltab2x32(:,:,260))
  Gcoeff(:)%j = (c(1)*M(2,:)%j) * den(22)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(261),h0tab(:,261),[28,1,2],[0,0,0],3,1,wf8(:,26))
  call Hloop_AV_Q(ntryL,G0H32(1),wf8(:,26),G0H4(15),m3h8x4(:,51),heltab2x32(:,:,261))
  call Hloop_A_Q(ntryL,G0H4(15),28,0,G1H4(61),n2h4(97))
  Gcoeff(:)%j = (c(2)*M(2,:)%j) * den(22)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(262),h0tab(:,262),[28,1,2],[0,nMZ,0],3,1,wf8(:,26))
  call Hloop_AV_Q(ntryL,G0H32(1),wf8(:,26),G0H4(15),m3h8x4(:,52),heltab2x32(:,:,262))
  call Hloop_A_Q(ntryL,G0H4(15),28,0,G1H4(62),n2h4(98))
  Gcoeff(:)%j = (-(c(13)*M(2,:)%j)) * den(22)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(263),h0tab(:,263),[28,1,2],[0,nMW,0],3,1,wf8(:,26))
  call Hloop_AV_Q(ntryL,G0H32(1),wf8(:,26),G0H4(15),m3h8x4(:,53),heltab2x32(:,:,263))
  call Hloop_A_Q(ntryL,G0H4(15),28,0,G1H4(63),n2h4(99))
  Gcoeff(:)%j = (c(2)*M(2,:)%j) * den(18)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(264),h0tab(:,264),[28,1,2],[0,0,0],3,1,wf8(:,27))
  call Hloop_AZ_Q(ntryL,G0H32(1),wf8(:,27),G0H4(15),ngZu,m3h8x4(:,54),heltab2x32(:,:,264))
  call Hloop_A_Q(ntryL,G0H4(15),28,0,G1H4(64),n2h4(100))
  Gcoeff(:)%j = (c(3)*M(2,:)%j) * den(18)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(265),h0tab(:,265),[28,1,2],[0,nMZ,0],3,1,wf8(:,27))
  call Hloop_AZ_Q(ntryL,G0H32(1),wf8(:,27),G0H4(15),ngZu,m3h8x4(:,55),heltab2x32(:,:,265))
  call Hloop_A_Q(ntryL,G0H4(15),28,0,G1H4(65),n2h4(101))
  Gcoeff(:)%j = (c(16)*M(2,:)%j) * den(18)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(266),h0tab(:,266),[28,1,2],[0,nMW,0],3,1,wf8(:,27))
  call Hloop_AZ_Q(ntryL,G0H32(1),wf8(:,27),G0H4(15),ngZd,m3h8x4(:,56),heltab2x32(:,:,266))
  call Hloop_A_Q(ntryL,G0H4(15),28,0,G1H4(66),n2h4(102))
  Gcoeff(:)%j = (c(15)*M(2,:)%j) * den(22)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(267),h0tab(:,267),[28,1,2],[nMW,0,nMW],3,1,wf8(:,26))
  call Hloop_UV_W(ntryL,G0H32(1),0,wf8(:,26),28,G1H4(67),m3h8x4(:,57),heltab2x32(:,:,267))
  Gcoeff(:)%j = (c(7)*M(2,:)%j) * den(18)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(268),h0tab(:,268),[28,1,2],[nMW,0,nMW],3,1,wf8(:,27))
  call Hloop_UV_W(ntryL,G0H32(1),0,wf8(:,27),28,G1H4(68),m3h8x4(:,58),heltab2x32(:,:,268))
  Gcoeff(:)%j = (-(c(21)*M(2,:)%j)) * den(68)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(269),h0tab(:,269),[28,1,2],[nMZ,0,nMZ],3,1,wf8(:,44))
  call Hloop_VS_V(ntryL,G0H32(1),wf8(:,44),G0H4(15),m3h8x4(:,59),heltab2x32(:,:,269))
  Gcoeff(:)%j = (-(c(6)*M(2,:)%j)) * den(68)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(270),h0tab(:,270),[28,1,2],[nMW,0,nMW],3,1,wf8(:,44))
  call Hloop_VS_V(ntryL,G0H32(1),wf8(:,44),G0H4(16),m3h8x4(:,60),heltab2x32(:,:,270))
  Gcoeff(:)%j = (c(1)*M(2,:)%j) * den(33)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(271),h0tab(:,271),[28,1,2],[0,0,0],3,1,wf8(:,31))
  call Hloop_AV_Q(ntryL,G0H32(1),wf8(:,31),G0H4(17),m3h8x4(:,61),heltab2x32(:,:,271))
  call Hloop_A_Q(ntryL,G0H4(17),28,0,G1H4(69),n2h4(103))
  Gcoeff(:)%j = (c(2)*M(2,:)%j) * den(33)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(272),h0tab(:,272),[28,1,2],[0,nMZ,0],3,1,wf8(:,31))
  call Hloop_AV_Q(ntryL,G0H32(1),wf8(:,31),G0H4(17),m3h8x4(:,62),heltab2x32(:,:,272))
  call Hloop_A_Q(ntryL,G0H4(17),28,0,G1H4(70),n2h4(104))
  Gcoeff(:)%j = (-(c(13)*M(2,:)%j)) * den(33)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(273),h0tab(:,273),[28,1,2],[0,nMW,0],3,1,wf8(:,31))
  call Hloop_AV_Q(ntryL,G0H32(1),wf8(:,31),G0H4(17),m3h8x4(:,63),heltab2x32(:,:,273))
  call Hloop_A_Q(ntryL,G0H4(17),28,0,G1H4(71),n2h4(105))
  Gcoeff(:)%j = (c(2)*M(2,:)%j) * den(30)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(274),h0tab(:,274),[28,1,2],[0,0,0],3,1,wf8(:,32))
  call Hloop_AZ_Q(ntryL,G0H32(1),wf8(:,32),G0H4(17),ngZu,m3h8x4(:,64),heltab2x32(:,:,274))
  call Hloop_A_Q(ntryL,G0H4(17),28,0,G1H4(72),n2h4(106))
  Gcoeff(:)%j = (c(3)*M(2,:)%j) * den(30)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(275),h0tab(:,275),[28,1,2],[0,nMZ,0],3,1,wf8(:,32))
  call Hloop_AZ_Q(ntryL,G0H32(1),wf8(:,32),G0H4(17),ngZu,m3h8x4(:,65),heltab2x32(:,:,275))
  call Hloop_A_Q(ntryL,G0H4(17),28,0,G1H4(73),n2h4(107))
  Gcoeff(:)%j = (c(16)*M(2,:)%j) * den(30)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(276),h0tab(:,276),[28,1,2],[0,nMW,0],3,1,wf8(:,32))
  call Hloop_AZ_Q(ntryL,G0H32(1),wf8(:,32),G0H4(17),ngZd,m3h8x4(:,66),heltab2x32(:,:,276))
  call Hloop_A_Q(ntryL,G0H4(17),28,0,G1H4(74),n2h4(108))
  Gcoeff(:)%j = (c(15)*M(2,:)%j) * den(33)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(277),h0tab(:,277),[28,1,2],[nMW,0,nMW],3,1,wf8(:,31))
  call Hloop_UV_W(ntryL,G0H32(1),0,wf8(:,31),28,G1H4(75),m3h8x4(:,67),heltab2x32(:,:,277))
  Gcoeff(:)%j = (c(7)*M(2,:)%j) * den(30)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(278),h0tab(:,278),[28,1,2],[nMW,0,nMW],3,1,wf8(:,32))
  call Hloop_UV_W(ntryL,G0H32(1),0,wf8(:,32),28,G1H4(76),m3h8x4(:,68),heltab2x32(:,:,278))
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(35),[G1H4(30),G1H4(5),G1H4(37)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(36),[G1H4(31),G1H4(6),G1H4(1)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(40),[G1H4(34),G1H4(9),G1H4(4)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(46),[G1H4(41),G1H4(15),G1H4(10)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(42),[G1H4(11)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(45),[G1H4(14)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(52),[G1H4(47),G1H4(21),G1H4(16)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(55),[G1H4(50),G1H4(24),G1H4(19)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(56),[G1H4(51),G1H4(25),G1H4(20)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G0H4(9),[G0H4(7),G0H4(3),G0H4(1)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G0H4(8),[G0H4(2)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G0H4(12),[G0H4(10),G0H4(6),G0H4(4)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G0H4(11),[G0H4(5)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(60),[G1H4(57),G1H4(29),G1H4(26)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G0H4(15),[G0H4(13)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(76),[G1H4(75),G1H4(68),G1H4(67),G0H4(16),G0H4(14)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(72),[G1H4(69),G1H4(64),G1H4(61)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(73),[G1H4(70),G1H4(65),G1H4(62)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(74),[G1H4(71),G1H4(66),G1H4(63)])
  call Hloop_QV_A(ntryL,G1H8(1),wf4(:,1),G1H2(89),m3h4x2(:,17),heltab2x8(:,:,83))
  call Hloop_Q_A(ntryL,G1H2(89),23,nMT,G2H2(17),n2h2(19))
  call Hloop_QV_A(ntryL,G1H8(2),wf4(:,1),G1H2(69),m3h4x2(:,18),heltab2x8(:,:,84))
  call Hloop_Q_A(ntryL,G1H2(69),23,nMT,G2H2(19),n2h2(20))
  call Hloop_QV_A(ntryL,G1H8(3),wf4(:,1),G1H2(95),m3h4x2(:,19),heltab2x8(:,:,85))
  call Hloop_Q_A(ntryL,G1H2(95),23,nMB,G2H2(13),n2h2(21))
  call Hloop_QZ_A(ntryL,G1H8(4),wf4(:,4),G1H2(75),ngZu,m3h4x2(:,20),heltab2x8(:,:,86))
  call Hloop_Q_A(ntryL,G1H2(75),23,nMT,G2H2(18),n2h2(22))
  call Hloop_QZ_A(ntryL,G1H8(5),wf4(:,4),G1H2(13),ngZu,m3h4x2(:,21),heltab2x8(:,:,87))
  call Hloop_Q_A(ntryL,G1H2(13),23,nMT,G2H2(20),n2h2(23))
  call Hloop_QZ_A(ntryL,G1H8(6),wf4(:,4),G1H2(81),ngZd,m3h4x2(:,22),heltab2x8(:,:,88))
  call Hloop_Q_A(ntryL,G1H2(81),23,nMB,G2H2(1),n2h2(24))
  call Hloop_SV_T(ntryL,G0H8(7),20,wf4(:,1),3,G1H2(94),m3h4x2(:,23),heltab2x8(:,:,89))
  call Hloop_SV_T(ntryL,G0H8(8),20,wf4(:,4),3,G1H2(87),m3h4x2(:,24),heltab2x8(:,:,90))
  call Hloop_TV_S(ntryL,G0H8(9),20,wf4(:,4),3,G1H2(100),m3h4x2(:,25),heltab2x8(:,:,91))
  call Hloop_SV_T(ntryL,G0H8(10),20,wf4(:,4),3,G1H2(93),m3h4x2(:,26),heltab2x8(:,:,92))
  call Hloop_QV_A(ntryL,G1H8(7),wf4(:,1),G1H2(99),m3h4x2(:,27),heltab2x8(:,:,93))
  call Hloop_Q_A(ntryL,G1H2(99),23,nMT,G2H2(2),n2h2(25))
  call Hloop_QV_A(ntryL,G1H8(8),wf4(:,1),G1H2(105),m3h4x2(:,28),heltab2x8(:,:,94))
  call Hloop_Q_A(ntryL,G1H2(105),23,nMT,G2H2(3),n2h2(26))
  call Hloop_QV_A(ntryL,G1H8(9),wf4(:,1),G1H2(106),m3h4x2(:,29),heltab2x8(:,:,95))
  call Hloop_Q_A(ntryL,G1H2(106),23,nMB,G2H2(4),n2h2(27))
  call Hloop_QZ_A(ntryL,G1H8(10),wf4(:,4),G1H2(2),ngZu,m3h4x2(:,30),heltab2x8(:,:,96))
  call Hloop_Q_A(ntryL,G1H2(2),23,nMT,G2H2(5),n2h2(28))
  call Hloop_QZ_A(ntryL,G1H8(11),wf4(:,4),G1H2(72),ngZu,m3h4x2(:,31),heltab2x8(:,:,97))
  call Hloop_Q_A(ntryL,G1H2(72),23,nMT,G2H2(6),n2h2(29))
  call Hloop_QZ_A(ntryL,G1H8(12),wf4(:,4),G1H2(73),ngZd,m3h4x2(:,32),heltab2x8(:,:,98))
  call Hloop_Q_A(ntryL,G1H2(73),23,nMB,G2H2(7),n2h2(30))
  call Hloop_VV_S(ntryL,G0H8(17),wf4(:,1),G0H2(1),m3h4x2(:,33),heltab2x8(:,:,99))
  call Hloop_VV_S(ntryL,G0H8(18),wf4(:,4),G0H2(2),m3h4x2(:,34),heltab2x8(:,:,100))
  call Hloop_VV_S(ntryL,G0H8(1),wf4(:,4),G0H2(3),m3h4x2(:,35),heltab2x8(:,:,101))
  call Hloop_SV_V(ntryL,G0H8(2),wf4(:,1),G0H2(4),m3h4x2(:,36),heltab2x8(:,:,102))
  call Hloop_SV_V(ntryL,G0H8(3),wf4(:,4),G0H2(5),m3h4x2(:,37),heltab2x8(:,:,103))
  call Hloop_SV_V(ntryL,G0H8(4),wf4(:,4),G0H2(6),m3h4x2(:,38),heltab2x8(:,:,104))
  call Hloop_UW_V(ntryL,G0H8(5),20,wf4(:,1),3,G1H2(74),m3h4x2(:,39),heltab2x8(:,:,105))
  call Hloop_UW_V(ntryL,G0H8(6),20,wf4(:,4),3,G1H2(78),m3h4x2(:,40),heltab2x8(:,:,106))
  call Hloop_AV_Q(ntryL,G1H8(13),wf4(:,1),G1H2(79),m3h4x2(:,41),heltab2x8(:,:,107))
  call Hloop_A_Q(ntryL,G1H2(79),27,nMT,G2H2(8),n2h2(31))
  call Hloop_AV_Q(ntryL,G1H8(14),wf4(:,1),G1H2(80),m3h4x2(:,42),heltab2x8(:,:,108))
  call Hloop_A_Q(ntryL,G1H2(80),27,nMT,G2H2(9),n2h2(32))
  call Hloop_AV_Q(ntryL,G1H8(15),wf4(:,1),G1H2(84),m3h4x2(:,43),heltab2x8(:,:,109))
  call Hloop_A_Q(ntryL,G1H2(84),27,nMB,G2H2(10),n2h2(33))
  call Hloop_AZ_Q(ntryL,G1H8(16),wf4(:,4),G1H2(85),ngZu,m3h4x2(:,44),heltab2x8(:,:,110))
  call Hloop_A_Q(ntryL,G1H2(85),27,nMT,G2H2(11),n2h2(34))
  call Hloop_AZ_Q(ntryL,G1H8(17),wf4(:,4),G1H2(86),ngZu,m3h4x2(:,45),heltab2x8(:,:,111))
  call Hloop_A_Q(ntryL,G1H2(86),27,nMT,G2H2(12),n2h2(35))
  call Hloop_AZ_Q(ntryL,G1H8(18),wf4(:,4),G1H2(90),ngZd,m3h4x2(:,46),heltab2x8(:,:,112))
  call Hloop_A_Q(ntryL,G1H2(90),27,nMB,G2H2(16),n2h2(36))
  call Hloop_TV_S(ntryL,G0H8(11),24,wf4(:,1),3,G1H2(91),m3h4x2(:,47),heltab2x8(:,:,113))
  call Hloop_SV_T(ntryL,G0H8(12),24,wf4(:,4),3,G1H2(97),m3h4x2(:,48),heltab2x8(:,:,114))
  call Hloop_TV_S(ntryL,G0H8(13),24,wf4(:,4),3,G1H2(98),m3h4x2(:,49),heltab2x8(:,:,115))
  call Hloop_TV_S(ntryL,G0H8(14),24,wf4(:,4),3,G1H2(102),m3h4x2(:,50),heltab2x8(:,:,116))
  call Hloop_AV_Q(ntryL,G1H8(19),wf4(:,1),G1H2(108),m3h4x2(:,51),heltab2x8(:,:,117))
  call Hloop_A_Q(ntryL,G1H2(108),27,nMT,G2H2(14),n2h2(37))
  call Hloop_AV_Q(ntryL,G1H8(20),wf4(:,1),G1H2(18),m3h4x2(:,52),heltab2x8(:,:,118))
  call Hloop_A_Q(ntryL,G1H2(18),27,nMT,G2H2(15),n2h2(38))
  call Hloop_AV_Q(ntryL,G1H8(21),wf4(:,1),G1H2(19),m3h4x2(:,53),heltab2x8(:,:,119))
  call Hloop_A_Q(ntryL,G1H2(19),27,nMB,G2H2(21),n2h2(39))
  call Hloop_AZ_Q(ntryL,G1H8(22),wf4(:,4),G1H2(25),ngZu,m3h4x2(:,54),heltab2x8(:,:,120))
  call Hloop_A_Q(ntryL,G1H2(25),27,nMT,G2H2(22),n2h2(40))
  call Hloop_AZ_Q(ntryL,G1H8(23),wf4(:,4),G1H2(26),ngZu,m3h4x2(:,55),heltab2x8(:,:,121))
  call Hloop_A_Q(ntryL,G1H2(26),27,nMT,G2H2(23),n2h2(41))
  call Hloop_AZ_Q(ntryL,G1H8(24),wf4(:,4),G1H2(30),ngZd,m3h4x2(:,56),heltab2x8(:,:,122))
  call Hloop_A_Q(ntryL,G1H2(30),27,nMB,G2H2(24),n2h2(42))
  call Hloop_VV_S(ntryL,G0H8(15),wf4(:,1),G0H2(7),m3h4x2(:,57),heltab2x8(:,:,123))
  call Hloop_VV_S(ntryL,G0H8(16),wf4(:,4),G0H2(8),m3h4x2(:,58),heltab2x8(:,:,124))
  call Hloop_VV_S(ntryL,G0H8(19),wf4(:,4),G0H2(9),m3h4x2(:,59),heltab2x8(:,:,125))
  call Hloop_SV_V(ntryL,G0H8(20),wf4(:,1),G0H2(10),m3h4x2(:,60),heltab2x8(:,:,126))
  call Hloop_SV_V(ntryL,G0H8(21),wf4(:,4),G0H2(11),m3h4x2(:,61),heltab2x8(:,:,127))
  call Hloop_SV_V(ntryL,G0H8(22),wf4(:,4),G0H2(12),m3h4x2(:,62),heltab2x8(:,:,128))
  call Hloop_UV_W(ntryL,G0H8(23),24,wf4(:,1),3,G1H2(36),m3h4x2(:,63),heltab2x8(:,:,129))
  call Hloop_UV_W(ntryL,G0H8(24),24,wf4(:,4),3,G1H2(37),m3h4x2(:,64),heltab2x8(:,:,130))
  call Hloop_AQ_S(ntryL,G1H16(1),wf8(:,33),G1H2(38),ngH,m3h8x2(:,1),heltab2x16(:,:,71))
  call Hloop_AQ_S(ntryL,G1H16(2),wf8(:,33),G1H2(44),ngX,m3h8x2(:,2),heltab2x16(:,:,72))
  call Hloop_AQ_S(ntryL,G1H16(3),wf8(:,33),G1H2(48),ngPbt,m3h8x2(:,3),heltab2x16(:,:,73))
  call Hloop_AQ_S(ntryL,G1H16(4),wf8(:,34),G1H2(49),ngH,m3h8x2(:,4),heltab2x16(:,:,74))
  call Hloop_AQ_S(ntryL,G1H16(5),wf8(:,34),G1H2(4),ngX,m3h8x2(:,5),heltab2x16(:,:,75))
  call Hloop_AQ_S(ntryL,G1H16(6),wf8(:,34),G1H2(5),ngPbt,m3h8x2(:,6),heltab2x16(:,:,76))
  call Hloop_AQ_V(ntryL,G1H16(7),wf8(:,33),G1H2(9),m3h8x2(:,7),heltab2x16(:,:,77))
  call Hloop_AQ_Z(ntryL,G1H16(8),wf8(:,33),G1H2(15),ngZu,m3h8x2(:,8),heltab2x16(:,:,78))
  call Hloop_AQ_W(ntryL,G1H16(9),wf8(:,33),G1H2(17),m3h8x2(:,9),heltab2x16(:,:,79))
  call Hloop_AQ_V(ntryL,G1H16(10),wf8(:,34),G1H2(21),m3h8x2(:,10),heltab2x16(:,:,80))
  call Hloop_AQ_Z(ntryL,G1H16(11),wf8(:,34),G1H2(28),ngZu,m3h8x2(:,11),heltab2x16(:,:,81))
  call Hloop_AQ_W(ntryL,G1H16(12),wf8(:,34),G1H2(33),m3h8x2(:,12),heltab2x16(:,:,82))
  call Hloop_AQ_S(ntryL,G1H16(13),ex3(:),G1H8(33),ngH,m3h2x8(:,47),heltab2x16(:,:,83))
  call Hloop_AQ_S(ntryL,G1H16(14),ex3(:),G1H8(34),ngX,m3h2x8(:,48),heltab2x16(:,:,84))
  call Hloop_AQ_S(ntryL,G1H16(15),ex3(:),G1H8(35),ngPbt,m3h2x8(:,49),heltab2x16(:,:,85))
  call Hloop_AQ_S(ntryL,G1H16(16),ex3(:),G1H8(36),ngH,m3h2x8(:,50),heltab2x16(:,:,86))
  call Hloop_AQ_S(ntryL,G1H16(17),ex3(:),G1H8(37),ngX,m3h2x8(:,51),heltab2x16(:,:,87))
  call Hloop_AQ_S(ntryL,G1H16(18),ex3(:),G1H8(38),ngPbt,m3h2x8(:,52),heltab2x16(:,:,88))
  call Hloop_AQ_V(ntryL,G1H16(19),ex3(:),G1H8(39),m3h2x8(:,53),heltab2x16(:,:,89))
  call Hloop_AQ_Z(ntryL,G1H16(20),ex3(:),G1H8(40),ngZu,m3h2x8(:,54),heltab2x16(:,:,90))
  call Hloop_AQ_W(ntryL,G1H16(21),ex3(:),G1H8(41),m3h2x8(:,55),heltab2x16(:,:,91))
  call Hloop_AQ_V(ntryL,G1H16(22),ex3(:),G1H8(42),m3h2x8(:,56),heltab2x16(:,:,92))
  call Hloop_AQ_Z(ntryL,G1H16(23),ex3(:),G1H8(43),ngZu,m3h2x8(:,57),heltab2x16(:,:,93))
  call Hloop_AQ_W(ntryL,G1H16(24),ex3(:),G1H8(44),m3h2x8(:,58),heltab2x16(:,:,94))
  call Hloop_QA_Z(ntryL,G1H8(25),ex2(:),G1H4(30),ngZu,m3h2x4(:,67),heltab2x8(:,:,131))
  call Hloop_QA_W(ntryL,G1H8(26),ex2(:),G1H4(5),m3h2x4(:,68),heltab2x8(:,:,132))
  call Hloop_VA_Q(ntryL,G0H8(25),ex2(:),G0H4(17),m3h2x4(:,69),heltab2x8(:,:,133))
  call Hloop_A_Q(ntryL,G0H4(17),19,0,G1H4(37),n2h4(109))
  call Hloop_ZA_Q(ntryL,G0H8(26),ex2(:),G0H4(7),ngZu,m3h2x4(:,70),heltab2x8(:,:,134))
  call Hloop_A_Q(ntryL,G0H4(7),19,0,G1H4(31),n2h4(110))
  call Hloop_WA_Q(ntryL,G0H8(27),ex2(:),G0H4(3),m3h2x4(:,71),heltab2x8(:,:,135))
  call Hloop_A_Q(ntryL,G0H4(3),19,0,G1H4(6),n2h4(111))
  call Hloop_VA_Q(ntryL,G0H8(28),ex2(:),G0H4(1),m3h2x4(:,72),heltab2x8(:,:,136))
  call Hloop_A_Q(ntryL,G0H4(1),19,0,G1H4(1),n2h4(112))
  call Hloop_ZA_Q(ntryL,G0H8(29),ex2(:),G0H4(2),ngZu,m3h2x4(:,73),heltab2x8(:,:,137))
  call Hloop_A_Q(ntryL,G0H4(2),19,0,G1H4(34),n2h4(113))
  call Hloop_WA_Q(ntryL,G0H8(30),ex2(:),G0H4(10),m3h2x4(:,74),heltab2x8(:,:,138))
  call Hloop_A_Q(ntryL,G0H4(10),19,0,G1H4(9),n2h4(114))
  call Hloop_QA_W(ntryL,G1H8(27),ex2(:),G1H4(4),m3h2x4(:,75),heltab2x8(:,:,139))
  call Hloop_QA_W(ntryL,G1H8(28),ex2(:),G1H4(41),m3h2x4(:,76),heltab2x8(:,:,140))
  call Hloop_AQ_Z(ntryL,G1H8(29),ex1(:),G1H4(15),ngZu,m3h2x4(:,77),heltab2x8(:,:,141))
  call Hloop_AQ_W(ntryL,G1H8(30),ex1(:),G1H4(10),m3h2x4(:,78),heltab2x8(:,:,142))
  call Hloop_VQ_A(ntryL,G0H8(31),ex1(:),G0H4(6),m3h2x4(:,79),heltab2x8(:,:,143))
  call Hloop_Q_A(ntryL,G0H4(6),19,0,G1H4(11),n2h4(115))
  call Hloop_ZQ_A(ntryL,G0H8(32),ex1(:),G0H4(4),ngZu,m3h2x4(:,80),heltab2x8(:,:,144))
  call Hloop_Q_A(ntryL,G0H4(4),19,0,G1H4(14),n2h4(116))
  call Hloop_WQ_A(ntryL,G0H8(33),ex1(:),G0H4(5),m3h2x4(:,81),heltab2x8(:,:,145))
  call Hloop_Q_A(ntryL,G0H4(5),19,0,G1H4(47),n2h4(117))
  call Hloop_VQ_A(ntryL,G0H8(34),ex1(:),G0H4(13),m3h2x4(:,82),heltab2x8(:,:,146))
  call Hloop_Q_A(ntryL,G0H4(13),19,0,G1H4(21),n2h4(118))
  call Hloop_ZQ_A(ntryL,G0H8(35),ex1(:),G0H4(16),ngZu,m3h2x4(:,83),heltab2x8(:,:,147))
  call Hloop_Q_A(ntryL,G0H4(16),19,0,G1H4(16),n2h4(119))
  call Hloop_WQ_A(ntryL,G0H8(36),ex1(:),G0H4(14),m3h2x4(:,84),heltab2x8(:,:,148))
  call Hloop_Q_A(ntryL,G0H4(14),19,0,G1H4(50),n2h4(120))
  call Hloop_AQ_W(ntryL,G1H8(31),ex1(:),G1H4(24),m3h2x4(:,85),heltab2x8(:,:,149))
  call Hloop_AQ_W(ntryL,G1H8(32),ex1(:),G1H4(19),m3h2x4(:,86),heltab2x8(:,:,150))
  call Hloop_QA_V(ntryL,G1H16(25),ex2(:),G1H8(45),m3h2x8(:,59),heltab2x16(:,:,95))
  call Hloop_QA_Z(ntryL,G1H16(26),ex2(:),G1H8(46),ngZu,m3h2x8(:,60),heltab2x16(:,:,96))
  call Hloop_QA_W(ntryL,G1H16(27),ex2(:),G1H8(1),m3h2x8(:,61),heltab2x16(:,:,97))
  call Hloop_QA_V(ntryL,G1H16(28),ex2(:),G1H8(2),m3h2x8(:,62),heltab2x16(:,:,98))
  call Hloop_QA_Z(ntryL,G1H16(29),ex2(:),G1H8(3),ngZu,m3h2x8(:,63),heltab2x16(:,:,99))
  call Hloop_QA_W(ntryL,G1H16(30),ex2(:),G1H8(4),m3h2x8(:,64),heltab2x16(:,:,100))
  call Hloop_AQ_V(ntryL,G1H16(31),ex1(:),G1H8(5),m3h2x8(:,65),heltab2x16(:,:,101))
  call Hloop_AQ_Z(ntryL,G1H16(32),ex1(:),G1H8(6),ngZu,m3h2x8(:,66),heltab2x16(:,:,102))
  call Hloop_AQ_W(ntryL,G1H16(33),ex1(:),G1H8(7),m3h2x8(:,67),heltab2x16(:,:,103))
  call Hloop_AQ_V(ntryL,G1H16(34),ex1(:),G1H8(8),m3h2x8(:,68),heltab2x16(:,:,104))
  call Hloop_AQ_Z(ntryL,G1H16(35),ex1(:),G1H8(9),ngZu,m3h2x8(:,69),heltab2x16(:,:,105))
  call Hloop_AQ_W(ntryL,G1H16(36),ex1(:),G1H8(10),m3h2x8(:,70),heltab2x16(:,:,106))
  call Hloop_AQ_S(ntryL,G1H4(35),ex3(:),G1H2(39),ngH,m3h2x2(:,67),heltab2x4(:,:,103))
  call Hloop_AQ_S(ntryL,G1H4(36),ex3(:),G1H2(51),ngX,m3h2x2(:,68),heltab2x4(:,:,104))
  call Hloop_AQ_S(ntryL,G1H4(40),ex3(:),G1H2(6),ngPbt,m3h2x2(:,69),heltab2x4(:,:,105))
  call Hloop_SQ_A(ntryL,G1H4(46),ex3(:),G1H2(1),ngPbt,m3h2x2(:,70),heltab2x4(:,:,106))
  call Hloop_Q_A(ntryL,G1H2(1),23,nMB,G2H2(25),n2h2(43))
  call Hloop_SQ_A(ntryL,G1H4(42),ex3(:),G1H2(59),ngH,m3h2x2(:,71),heltab2x4(:,:,107))
  call Hloop_Q_A(ntryL,G1H2(59),23,nMT,G2H2(26),n2h2(44))
  call Hloop_SQ_A(ntryL,G1H4(45),ex3(:),G1H2(64),ngX,m3h2x2(:,72),heltab2x4(:,:,108))
  call Hloop_Q_A(ntryL,G1H2(64),23,nMT,G2H2(27),n2h2(45))
  call Hloop_AQ_V(ntryL,G1H4(52),ex3(:),G1H2(65),m3h2x2(:,73),heltab2x4(:,:,109))
  call Hloop_AQ_Z(ntryL,G1H4(55),ex3(:),G1H2(77),ngZu,m3h2x2(:,74),heltab2x4(:,:,110))
  call Hloop_AQ_W(ntryL,G1H4(56),ex3(:),G1H2(82),m3h2x2(:,75),heltab2x4(:,:,111))
  call Hloop_SQ_A(ntryL,G0H4(9),ex3(:),G0H2(13),ngPbt,m3h2x2(:,76),heltab2x4(:,:,112))
  call Hloop_Q_A(ntryL,G0H2(13),23,nMB,G1H2(88),n2h2(46))
  call Hloop_SQ_A(ntryL,G0H4(8),ex3(:),G0H2(13),ngH,m3h2x2(:,77),heltab2x4(:,:,113))
  call Hloop_Q_A(ntryL,G0H2(13),23,nMT,G1H2(12),n2h2(47))
  call Hloop_WQ_A(ntryL,G0H4(12),ex3(:),G0H2(13),m3h2x2(:,78),heltab2x4(:,:,114))
  call Hloop_Q_A(ntryL,G0H2(13),23,nMB,G1H2(7),n2h2(48))
  call Hloop_ZQ_A(ntryL,G0H4(11),ex3(:),G0H2(13),ngZu,m3h2x2(:,79),heltab2x4(:,:,115))
  call Hloop_Q_A(ntryL,G0H2(13),23,nMT,G1H2(8),n2h2(49))
  call Hloop_WQ_A(ntryL,G1H4(60),ex3(:),G1H2(29),m3h2x2(:,80),heltab2x4(:,:,116))
  call Hloop_Q_A(ntryL,G1H2(29),23,nMB,G2H2(28),n2h2(50))
  call Hloop_ZQ_A(ntryL,G0H4(15),ex1(:),G0H2(13),ngZu,m3h2x2(:,81),heltab2x4(:,:,117))
  call Hloop_Q_A(ntryL,G0H2(13),29,0,G1H2(66),n2h2(51))
  call Hloop_WQ_A(ntryL,G1H4(76),ex1(:),G1H2(22),m3h2x2(:,82),heltab2x4(:,:,118))
  call Hloop_Q_A(ntryL,G1H2(22),29,0,G2H2(29),n2h2(52))
  call Hloop_AQ_V(ntryL,G1H4(72),ex1(:),G1H2(35),m3h2x2(:,83),heltab2x4(:,:,119))
  call Hloop_AQ_Z(ntryL,G1H4(73),ex1(:),G1H2(68),ngZu,m3h2x2(:,84),heltab2x4(:,:,120))
  call Hloop_AQ_W(ntryL,G1H4(74),ex1(:),G1H2(47),m3h2x2(:,85),heltab2x4(:,:,121))
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(78),[G1H2(74),G1H2(92),G0H2(6),G0H2(4)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(33),[G1H2(17),G1H2(67),G1H2(96)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(39),[G1H2(40)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(49),[G1H2(38),G1H2(63),G1H2(45)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(51),[G1H2(53)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(4),[G1H2(44),G1H2(61),G1H2(58)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(6),[G1H2(71)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(5),[G1H2(48),G1H2(34),G1H2(101)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(65),[G1H2(14)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(21),[G1H2(9),G1H2(107)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(77),[G1H2(62)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(28),[G1H2(15),G1H2(16)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(82),[G1H2(41)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(93),[G1H2(94),G1H2(54),G0H2(3),G0H2(1)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(100),[G1H2(60)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(87),[G1H2(83),G0H2(2)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(37),[G1H4(2)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(13),[G1H4(8),G1H4(3)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(31),[G1H4(7)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(6),[G1H4(12)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(1),[G1H4(17)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(23),[G1H4(18)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(34),[G1H4(22)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(9),[G1H4(27)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(11),[G1H4(32)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(44),[G1H4(39),G1H4(33)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(14),[G1H4(38)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(47),[G1H4(43)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(21),[G1H4(48)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(54),[G1H4(49)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(16),[G1H4(53)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(50),[G1H4(58)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(18),[G2H2(17)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(20),[G2H2(19)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(1),[G2H2(13)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(5),[G2H2(2)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(6),[G2H2(3)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(7),[G2H2(4)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(11),[G2H2(8)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(12),[G2H2(9)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(16),[G2H2(10)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(102),[G1H2(91),G0H2(9),G0H2(7)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(97),[G0H2(8)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(22),[G2H2(14)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(23),[G2H2(15)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(24),[G2H2(21)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(37),[G1H2(36),G0H2(12),G0H2(10)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(25),[G1H2(7)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(27),[G1H2(8)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(28),[G1H2(88)])
  call Hloop_WA_Q(ntryL,G1H2(78),ex4(:),G1H1(1),m3h2x1(:,170),heltab2x2(:,:,170))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,nMB,G2tensor(3),n2h1(188))
  call Hloop_WA_Q(ntryL,G1H2(33),ex4(:),G1H1(1),m3h2x1(:,171),heltab2x2(:,:,171))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,nMB,G2tensor(9),n2h1(189))
  call Hloop_WA_Q(ntryL,G1H2(103),ex2(:),G1H1(1),m3h2x1(:,172),heltab2x2(:,:,172))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,0,G2tensor(15),n2h1(190))
  call Hloop_WA_Q(ntryL,G1H2(104),ex2(:),G1H1(1),m3h2x1(:,173),heltab2x2(:,:,173))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,0,G2tensor(18),n2h1(191))
  call Hloop_SQ_A(ntryL,G1H2(20),ex3(:),G1H1(1),ngH,m3h2x1(:,174),heltab2x2(:,:,174))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,nMT,G2tensor(29),n2h1(192))
  call Hloop_SQ_A(ntryL,G1H2(24),ex3(:),G1H1(1),ngH,m3h2x1(:,175),heltab2x2(:,:,175))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,nMT,G2tensor(30),n2h1(193))
  call Hloop_SQ_A(ntryL,G1H2(31),ex3(:),G1H1(1),ngX,m3h2x1(:,176),heltab2x2(:,:,176))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,nMT,G2tensor(32),n2h1(194))
  call Hloop_SQ_A(ntryL,G1H2(32),ex3(:),G1H1(1),ngX,m3h2x1(:,177),heltab2x2(:,:,177))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,nMT,G2tensor(35),n2h1(195))
  call Hloop_SQ_A(ntryL,G1H2(42),ex3(:),G1H1(1),ngPbt,m3h2x1(:,178),heltab2x2(:,:,178))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,nMB,G2tensor(36),n2h1(196))
  call Hloop_SQ_A(ntryL,G1H2(43),ex3(:),G1H1(1),ngPbt,m3h2x1(:,179),heltab2x2(:,:,179))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,nMB,G2tensor(38),n2h1(197))
  call Hloop_VQ_A(ntryL,G1H2(50),ex3(:),G1H1(1),m3h2x1(:,180),heltab2x2(:,:,180))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,nMT,G2tensor(41),n2h1(198))
  call Hloop_VQ_A(ntryL,G1H2(3),ex3(:),G1H1(1),m3h2x1(:,181),heltab2x2(:,:,181))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,nMT,G2tensor(42),n2h1(199))
  call Hloop_ZQ_A(ntryL,G1H2(10),ex3(:),G1H1(1),ngZu,m3h2x1(:,182),heltab2x2(:,:,182))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,nMT,G2tensor(44),n2h1(200))
  call Hloop_ZQ_A(ntryL,G1H2(11),ex3(:),G1H1(1),ngZu,m3h2x1(:,183),heltab2x2(:,:,183))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,nMT,G2tensor(47),n2h1(201))
  call Hloop_WQ_A(ntryL,G1H2(23),ex3(:),G1H1(1),m3h2x1(:,184),heltab2x2(:,:,184))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,nMB,G2tensor(48),n2h1(202))
  call Hloop_WQ_A(ntryL,G1H2(27),ex3(:),G1H1(1),m3h2x1(:,185),heltab2x2(:,:,185))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,nMB,G2tensor(50),n2h1(203))
  call Hloop_SA_Q(ntryL,G1H2(39),ex4(:),G1H1(1),ngH,m3h2x1(:,186),heltab2x2(:,:,186))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,nMT,G2tensor(53),n2h1(204))
  call Hloop_SA_Q(ntryL,G1H2(49),ex4(:),G1H1(1),ngH,m3h2x1(:,187),heltab2x2(:,:,187))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,nMT,G2tensor(101),n2h1(205))
  call Hloop_SA_Q(ntryL,G1H2(51),ex4(:),G1H1(1),ngX,m3h2x1(:,188),heltab2x2(:,:,188))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,nMT,G2tensor(73),n2h1(206))
  call Hloop_SA_Q(ntryL,G1H2(4),ex4(:),G1H1(1),ngX,m3h2x1(:,189),heltab2x2(:,:,189))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,nMT,G2tensor(110),n2h1(207))
  call Hloop_SA_Q(ntryL,G1H2(6),ex4(:),G1H1(1),ngPtb,m3h2x1(:,190),heltab2x2(:,:,190))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,nMB,G2tensor(113),n2h1(208))
  call Hloop_SA_Q(ntryL,G1H2(5),ex4(:),G1H1(1),ngPtb,m3h2x1(:,191),heltab2x2(:,:,191))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,nMB,G2tensor(128),n2h1(209))
  call Hloop_VA_Q(ntryL,G1H2(65),ex4(:),G1H1(1),m3h2x1(:,192),heltab2x2(:,:,192))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,nMT,G2tensor(131),n2h1(210))
  call Hloop_VA_Q(ntryL,G1H2(21),ex4(:),G1H1(1),m3h2x1(:,193),heltab2x2(:,:,193))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,nMT,G2tensor(152),n2h1(211))
  call Hloop_ZA_Q(ntryL,G1H2(77),ex4(:),G1H1(1),ngZu,m3h2x1(:,194),heltab2x2(:,:,194))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,nMT,G2tensor(155),n2h1(212))
  call Hloop_ZA_Q(ntryL,G1H2(28),ex4(:),G1H1(1),ngZu,m3h2x1(:,195),heltab2x2(:,:,195))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,nMT,G2tensor(158),n2h1(213))
  call Hloop_WA_Q(ntryL,G1H2(82),ex4(:),G1H1(1),m3h2x1(:,196),heltab2x2(:,:,196))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,nMB,G2tensor(170),n2h1(214))
  call Hloop_SA_Q(ntryL,G1H2(93),ex4(:),G1H1(1),ngPtb,m3h2x1(:,197),heltab2x2(:,:,197))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,nMB,G2tensor(173),n2h1(215))
  call Hloop_SA_Q(ntryL,G1H2(100),ex4(:),G1H1(1),ngX,m3h2x1(:,198),heltab2x2(:,:,198))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,nMT,G2tensor(176),n2h1(216))
  call Hloop_SA_Q(ntryL,G1H2(87),ex4(:),G1H1(1),ngH,m3h2x1(:,199),heltab2x2(:,:,199))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,nMT,G2tensor(2),n2h1(217))
  call Hloop_AV_Q(ntryL,G1H4(37),wf4(:,8),G1H1(1),m3h4x1(:,37),heltab2x4(:,:,122))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,0,G2tensor(6),n2h1(218))
  call Hloop_AV_Q(ntryL,G1H4(13),wf4(:,8),G1H1(1),m3h4x1(:,38),heltab2x4(:,:,123))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,0,G2tensor(5),n2h1(219))
  call Hloop_AV_Q(ntryL,G1H4(31),wf4(:,8),G1H1(1),m3h4x1(:,39),heltab2x4(:,:,124))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,0,G2tensor(8),n2h1(220))
  call Hloop_AV_Q(ntryL,G1H4(6),wf4(:,8),G1H1(1),m3h4x1(:,40),heltab2x4(:,:,125))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,0,G2tensor(12),n2h1(221))
  call Hloop_AZ_Q(ntryL,G1H4(1),wf4(:,10),G1H1(1),ngZu,m3h4x1(:,41),heltab2x4(:,:,126))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,0,G2tensor(11),n2h1(222))
  call Hloop_AZ_Q(ntryL,G1H4(23),wf4(:,10),G1H1(1),ngZu,m3h4x1(:,42),heltab2x4(:,:,127))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,0,G2tensor(14),n2h1(223))
  call Hloop_AZ_Q(ntryL,G1H4(34),wf4(:,10),G1H1(1),ngZu,m3h4x1(:,43),heltab2x4(:,:,128))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,0,G2tensor(21),n2h1(224))
  call Hloop_AZ_Q(ntryL,G1H4(9),wf4(:,10),G1H1(1),ngZd,m3h4x1(:,44),heltab2x4(:,:,129))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,0,G2tensor(17),n2h1(225))
  call Hloop_AZ_Q(ntryL,G1H4(28),wf4(:,10),G1H1(1),ngZd,m3h4x1(:,45),heltab2x4(:,:,130))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,0,G2tensor(24),n2h1(226))
  call Hloop_QV_A(ntryL,G1H4(11),wf4(:,8),G1H1(1),m3h4x1(:,46),heltab2x4(:,:,131))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,0,G2tensor(20),n2h1(227))
  call Hloop_QV_A(ntryL,G1H4(44),wf4(:,8),G1H1(1),m3h4x1(:,47),heltab2x4(:,:,132))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,0,G2tensor(23),n2h1(228))
  call Hloop_QV_A(ntryL,G1H4(14),wf4(:,8),G1H1(1),m3h4x1(:,48),heltab2x4(:,:,133))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,0,G2tensor(26),n2h1(229))
  call Hloop_QV_A(ntryL,G1H4(47),wf4(:,8),G1H1(1),m3h4x1(:,49),heltab2x4(:,:,134))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,0,G2tensor(27),n2h1(230))
  call Hloop_QZ_A(ntryL,G1H4(21),wf4(:,10),G1H1(1),ngZu,m3h4x1(:,50),heltab2x4(:,:,135))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,0,G2tensor(83),n2h1(231))
  call Hloop_QZ_A(ntryL,G1H4(54),wf4(:,10),G1H1(1),ngZu,m3h4x1(:,51),heltab2x4(:,:,136))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,0,G2tensor(33),n2h1(232))
  call Hloop_QZ_A(ntryL,G1H4(16),wf4(:,10),G1H1(1),ngZu,m3h4x1(:,52),heltab2x4(:,:,137))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,0,G2tensor(84),n2h1(233))
  call Hloop_QZ_A(ntryL,G1H4(50),wf4(:,10),G1H1(1),ngZd,m3h4x1(:,53),heltab2x4(:,:,138))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,0,G2tensor(85),n2h1(234))
  call Hloop_QZ_A(ntryL,G1H4(59),wf4(:,10),G1H1(1),ngZd,m3h4x1(:,54),heltab2x4(:,:,139))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,0,G2tensor(39),n2h1(235))
  call Hcheck_last_QA_S(ntryL,l_switch,G2H2(18),ex4(:),G2tensor(86),ngH,m3h2x1(:,200),heltab2x2(:,:,200))
  call Hcheck_last_QA_S(ntryL,l_switch,G2H2(20),ex4(:),G2tensor(87),ngX,m3h2x1(:,201),heltab2x2(:,:,201))
  call Hcheck_last_QA_S(ntryL,l_switch,G2H2(1),ex4(:),G2tensor(45),ngPtb,m3h2x1(:,202),heltab2x2(:,:,202))
  call Hcheck_last_QA_V(ntryL,l_switch,G2H2(5),ex4(:),G2tensor(88),m3h2x1(:,203),heltab2x2(:,:,203))
  call Hcheck_last_QA_Z(ntryL,l_switch,G2H2(6),ex4(:),G2tensor(89),ngZu,m3h2x1(:,204),heltab2x2(:,:,204))
  call Hcheck_last_QA_W(ntryL,l_switch,G2H2(7),ex4(:),G2tensor(51),m3h2x1(:,205),heltab2x2(:,:,205))
  call Hloop_ZA_Q(ntryL,G0H2(5),ex4(:),G0H1(1),ngZu,m3h2x1(:,206),heltab2x2(:,:,206))
  call Hcheck_last_A_Q(ntryL,l_switch,G0H1(1),31,nMT,G1tensor(1),n2h1(236))
  call Hcheck_last_AQ_S(ntryL,l_switch,G2H2(11),ex3(:),G2tensor(90),ngH,m3h2x1(:,207),heltab2x2(:,:,207))
  call Hcheck_last_AQ_S(ntryL,l_switch,G2H2(12),ex3(:),G2tensor(91),ngX,m3h2x1(:,208),heltab2x2(:,:,208))
  call Hcheck_last_AQ_S(ntryL,l_switch,G2H2(16),ex3(:),G2tensor(54),ngPbt,m3h2x1(:,209),heltab2x2(:,:,209))
  call Hloop_SQ_A(ntryL,G1H2(102),ex3(:),G1H1(1),ngPbt,m3h2x1(:,210),heltab2x2(:,:,210))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,nMB,G2tensor(1),n2h1(237))
  call Hloop_SQ_A(ntryL,G1H2(97),ex3(:),G1H1(1),ngH,m3h2x1(:,211),heltab2x2(:,:,211))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,nMT,G2tensor(4),n2h1(238))
  call Hloop_SQ_A(ntryL,G1H2(98),ex3(:),G1H1(1),ngX,m3h2x1(:,212),heltab2x2(:,:,212))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,nMT,G2tensor(7),n2h1(239))
  call Hcheck_last_AQ_V(ntryL,l_switch,G2H2(22),ex3(:),G2tensor(10),m3h2x1(:,213),heltab2x2(:,:,213))
  call Hcheck_last_AQ_Z(ntryL,l_switch,G2H2(23),ex3(:),G2tensor(13),ngZu,m3h2x1(:,214),heltab2x2(:,:,214))
  call Hcheck_last_AQ_W(ntryL,l_switch,G2H2(24),ex3(:),G2tensor(16),m3h2x1(:,215),heltab2x2(:,:,215))
  call Hloop_WQ_A(ntryL,G1H2(37),ex3(:),G1H1(1),m3h2x1(:,216),heltab2x2(:,:,216))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,nMB,G2tensor(19),n2h1(240))
  call Hloop_ZQ_A(ntryL,G0H2(11),ex3(:),G0H1(1),ngZu,m3h2x1(:,217),heltab2x2(:,:,217))
  call Hcheck_last_Q_A(ntryL,l_switch,G0H1(1),31,nMT,G1tensor(31),n2h1(241))
  call Hloop_SA_Q(ntryL,G1H8(33),wf8(:,28),G1H1(1),ngH,m3h8x1(:,1),heltab2x8(:,:,151))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,nMT,G2tensor(22),n2h1(242))
  call Hloop_SA_Q(ntryL,G1H8(34),wf8(:,28),G1H1(1),ngX,m3h8x1(:,2),heltab2x8(:,:,152))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,nMT,G2tensor(25),n2h1(243))
  call Hloop_SA_Q(ntryL,G1H8(35),wf8(:,28),G1H1(1),ngPtb,m3h8x1(:,3),heltab2x8(:,:,153))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,nMB,G2tensor(28),n2h1(244))
  call Hloop_SA_Q(ntryL,G1H8(36),wf8(:,29),G1H1(1),ngH,m3h8x1(:,4),heltab2x8(:,:,154))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,nMT,G2tensor(31),n2h1(245))
  call Hloop_SA_Q(ntryL,G1H8(37),wf8(:,29),G1H1(1),ngX,m3h8x1(:,5),heltab2x8(:,:,155))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,nMT,G2tensor(34),n2h1(246))
  call Hloop_SA_Q(ntryL,G1H8(38),wf8(:,29),G1H1(1),ngPtb,m3h8x1(:,6),heltab2x8(:,:,156))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,nMB,G2tensor(37),n2h1(247))
  call Hloop_VA_Q(ntryL,G1H8(39),wf8(:,28),G1H1(1),m3h8x1(:,7),heltab2x8(:,:,157))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,nMT,G2tensor(40),n2h1(248))
  call Hloop_ZA_Q(ntryL,G1H8(40),wf8(:,28),G1H1(1),ngZu,m3h8x1(:,8),heltab2x8(:,:,158))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,nMT,G2tensor(43),n2h1(249))
  call Hloop_WA_Q(ntryL,G1H8(41),wf8(:,28),G1H1(1),m3h8x1(:,9),heltab2x8(:,:,159))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,nMB,G2tensor(46),n2h1(250))
  call Hloop_VA_Q(ntryL,G1H8(42),wf8(:,29),G1H1(1),m3h8x1(:,10),heltab2x8(:,:,160))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,nMT,G2tensor(49),n2h1(251))
  call Hloop_ZA_Q(ntryL,G1H8(43),wf8(:,29),G1H1(1),ngZu,m3h8x1(:,11),heltab2x8(:,:,161))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,nMT,G2tensor(52),n2h1(252))
  call Hloop_WA_Q(ntryL,G1H8(44),wf8(:,29),G1H1(1),m3h8x1(:,12),heltab2x8(:,:,162))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,nMB,G2tensor(143),n2h1(253))
  call Hcheck_last_VS_V(ntryL,l_switch,G1H4(30),wf4(:,42),G1tensor(61),m3h4x1(:,55),heltab2x4(:,:,140))
  call Hcheck_last_VS_V(ntryL,l_switch,G1H4(5),wf4(:,42),G1tensor(91),m3h4x1(:,56),heltab2x4(:,:,141))
  call Hcheck_last_UV_W(ntryL,l_switch,G1H4(4),19,wf4(:,8),12,G2tensor(55),m3h4x1(:,57),heltab2x4(:,:,142))
  call Hcheck_last_UV_W(ntryL,l_switch,G1H4(41),19,wf4(:,10),12,G2tensor(56),m3h4x1(:,58),heltab2x4(:,:,143))
  call Hcheck_last_VS_V(ntryL,l_switch,G1H4(15),wf4(:,42),G1tensor(6),m3h4x1(:,59),heltab2x4(:,:,144))
  call Hcheck_last_VS_V(ntryL,l_switch,G1H4(10),wf4(:,42),G1tensor(20),m3h4x1(:,60),heltab2x4(:,:,145))
  call Hcheck_last_UW_V(ntryL,l_switch,G1H4(24),19,wf4(:,8),12,G2tensor(57),m3h4x1(:,61),heltab2x4(:,:,146))
  call Hcheck_last_UW_V(ntryL,l_switch,G1H4(19),19,wf4(:,10),12,G2tensor(58),m3h4x1(:,62),heltab2x4(:,:,147))
  call Hloop_VQ_A(ntryL,G1H8(45),wf8(:,40),G1H1(1),m3h8x1(:,13),heltab2x8(:,:,163))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,0,G2tensor(59),n2h1(254))
  call Hloop_ZQ_A(ntryL,G1H8(46),wf8(:,40),G1H1(1),ngZu,m3h8x1(:,14),heltab2x8(:,:,164))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,0,G2tensor(60),n2h1(255))
  call Hloop_WQ_A(ntryL,G1H8(1),wf8(:,40),G1H1(1),m3h8x1(:,15),heltab2x8(:,:,165))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,0,G2tensor(61),n2h1(256))
  call Hloop_VQ_A(ntryL,G1H8(2),wf8(:,42),G1H1(1),m3h8x1(:,16),heltab2x8(:,:,166))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,0,G2tensor(62),n2h1(257))
  call Hloop_ZQ_A(ntryL,G1H8(3),wf8(:,42),G1H1(1),ngZu,m3h8x1(:,17),heltab2x8(:,:,167))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,0,G2tensor(63),n2h1(258))
  call Hloop_WQ_A(ntryL,G1H8(4),wf8(:,42),G1H1(1),m3h8x1(:,18),heltab2x8(:,:,168))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,0,G2tensor(64),n2h1(259))
  call Hloop_VA_Q(ntryL,G1H8(5),wf8(:,36),G1H1(1),m3h8x1(:,19),heltab2x8(:,:,169))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,0,G2tensor(65),n2h1(260))
  call Hloop_ZA_Q(ntryL,G1H8(6),wf8(:,36),G1H1(1),ngZu,m3h8x1(:,20),heltab2x8(:,:,170))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,0,G2tensor(66),n2h1(261))
  call Hloop_WA_Q(ntryL,G1H8(7),wf8(:,36),G1H1(1),m3h8x1(:,21),heltab2x8(:,:,171))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,0,G2tensor(67),n2h1(262))
  call Hloop_VA_Q(ntryL,G1H8(8),wf8(:,38),G1H1(1),m3h8x1(:,22),heltab2x8(:,:,172))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,0,G2tensor(68),n2h1(263))
  call Hloop_ZA_Q(ntryL,G1H8(9),wf8(:,38),G1H1(1),ngZu,m3h8x1(:,23),heltab2x8(:,:,173))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,0,G2tensor(69),n2h1(264))
  call Hloop_WA_Q(ntryL,G1H8(10),wf8(:,38),G1H1(1),m3h8x1(:,24),heltab2x8(:,:,174))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,0,G2tensor(70),n2h1(265))
  call Hcheck_last_QA_S(ntryL,l_switch,G2H2(25),ex4(:),G2tensor(71),ngPtb,m3h2x1(:,218),heltab2x2(:,:,218))
  call Hcheck_last_QA_S(ntryL,l_switch,G2H2(26),ex4(:),G2tensor(72),ngX,m3h2x1(:,219),heltab2x2(:,:,219))
  call Hcheck_last_QA_S(ntryL,l_switch,G2H2(27),ex4(:),G2tensor(104),ngH,m3h2x1(:,220),heltab2x2(:,:,220))
  call Hcheck_last_QA_W(ntryL,l_switch,G2H2(28),ex4(:),G2tensor(146),m3h2x1(:,221),heltab2x2(:,:,221))
  call Hcheck_last_QA_Z(ntryL,l_switch,G1H2(12),ex4(:),G1tensor(48),ngZu,m3h2x1(:,222),heltab2x2(:,:,222))
  call Hcheck_last_QA_Z(ntryL,l_switch,G1H2(66),ex2(:),G1tensor(54),ngZu,m3h2x1(:,223),heltab2x2(:,:,223))
  call Hcheck_last_QA_W(ntryL,l_switch,G2H2(29),ex2(:),G2tensor(74),m3h2x1(:,224),heltab2x2(:,:,224))
  call Hloop_VA_Q(ntryL,G1H2(35),ex2(:),G1H1(1),m3h2x1(:,225),heltab2x2(:,:,225))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,0,G2tensor(75),n2h1(266))
  call Hloop_ZA_Q(ntryL,G1H2(68),ex2(:),G1H1(1),ngZu,m3h2x1(:,226),heltab2x2(:,:,226))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,0,G2tensor(76),n2h1(267))
  call Hloop_WA_Q(ntryL,G1H2(47),ex2(:),G1H1(1),m3h2x1(:,227),heltab2x2(:,:,227))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,0,G2tensor(77),n2h1(268))
  call ol_merge_tensors(G2tensor(144),[G2tensor(102),G1tensor(232),G1tensor(15),G0tensor(232),G0tensor(65)])
  call ol_merge_tensors(G2tensor(143),[G2tensor(46),G2tensor(37),G2tensor(28),G2tensor(145),G2tensor(103),G1tensor(235) &
    ,G1tensor(23),G0tensor(235),G0tensor(70)])
  call ol_merge_tensors(G2tensor(58),[G2tensor(57),G2tensor(105),G1tensor(20),G1tensor(327),G1tensor(135),G0tensor(327) &
    ,G0tensor(135)])
  call ol_merge_tensors(G2tensor(70),[G2tensor(67),G2tensor(169),G2tensor(160),G2tensor(106),G1tensor(485),G1tensor(330) &
    ,G1tensor(140),G0tensor(485),G0tensor(330),G0tensor(140)])
  call ol_merge_tensors(G2tensor(86),[G2tensor(108),G1tensor(427),G0tensor(427)])
  call ol_merge_tensors(G2tensor(139),[G2tensor(136),G2tensor(130),G2tensor(127),G2tensor(121),G2tensor(118),G2tensor(112) &
    ,G2tensor(109),G1tensor(465),G1tensor(455),G1tensor(450),G1tensor(445),G1tensor(435),G1tensor(430),G0tensor(465),G0tensor(455) &
    ,G0tensor(450),G0tensor(445),G0tensor(435),G0tensor(430)])
  call ol_merge_tensors(G2tensor(89),[G2tensor(87),G2tensor(120),G2tensor(111),G1tensor(432),G0tensor(432)])
  call ol_merge_tensors(G2tensor(51),[G2tensor(45),G2tensor(123),G2tensor(114),G1tensor(437),G0tensor(437)])
  call ol_merge_tensors(G2tensor(142),[G2tensor(133),G2tensor(124),G2tensor(115),G1tensor(460),G1tensor(440),G0tensor(460) &
    ,G0tensor(440)])
  call ol_merge_tensors(G2tensor(88),[G2tensor(117),G1tensor(442),G0tensor(442)])
  call ol_merge_tensors(G2tensor(90),[G2tensor(126),G1tensor(447),G0tensor(447)])
  call ol_merge_tensors(G2tensor(13),[G2tensor(91),G2tensor(138),G2tensor(129),G1tensor(452),G0tensor(452)])
  call ol_merge_tensors(G2tensor(16),[G2tensor(54),G2tensor(141),G2tensor(132),G1tensor(457),G0tensor(457)])
  call ol_merge_tensors(G2tensor(10),[G2tensor(135),G1tensor(462),G0tensor(462)])
  call ol_merge_tensors(G2tensor(147),[G1tensor(332),G0tensor(332)])
  call ol_merge_tensors(G2tensor(31),[G2tensor(22),G2tensor(148),G1tensor(335),G0tensor(335)])
  call ol_merge_tensors(G2tensor(150),[G1tensor(467),G0tensor(467)])
  call ol_merge_tensors(G2tensor(52),[G2tensor(43),G2tensor(34),G2tensor(25),G2tensor(151),G1tensor(470),G1tensor(190) &
    ,G1tensor(180),G1tensor(102),G1tensor(18),G0tensor(470),G0tensor(190),G0tensor(180),G0tensor(50),G0tensor(25)])
  call ol_merge_tensors(G2tensor(75),[G2tensor(162),G2tensor(153),G1tensor(472),G1tensor(402),G1tensor(142),G1tensor(13) &
    ,G0tensor(472),G0tensor(402),G0tensor(142),G0tensor(3)])
  call ol_merge_tensors(G2tensor(68),[G2tensor(65),G2tensor(163),G2tensor(154),G1tensor(475),G1tensor(265),G1tensor(250) &
    ,G1tensor(110),G1tensor(52),G0tensor(475),G0tensor(265),G0tensor(250),G0tensor(110),G0tensor(80)])
  call ol_merge_tensors(G2tensor(76),[G2tensor(165),G2tensor(156),G1tensor(477),G0tensor(477)])
  call ol_merge_tensors(G2tensor(69),[G2tensor(66),G2tensor(166),G2tensor(157),G1tensor(480),G1tensor(285),G1tensor(275) &
    ,G1tensor(125),G1tensor(75),G0tensor(480),G0tensor(285),G0tensor(275),G0tensor(125),G0tensor(95)])
  call ol_merge_tensors(G2tensor(77),[G2tensor(168),G2tensor(159),G1tensor(482),G0tensor(482)])
  call ol_merge_tensors(G2tensor(180),[G2tensor(171),G1tensor(487),G1tensor(382),G1tensor(192),G1tensor(38),G0tensor(487) &
    ,G0tensor(382),G0tensor(192),G0tensor(33)])
  call ol_merge_tensors(G2tensor(62),[G2tensor(59),G2tensor(181),G2tensor(172),G1tensor(490),G0tensor(490)])
  call ol_merge_tensors(G2tensor(183),[G2tensor(174),G1tensor(492),G0tensor(492)])
  call ol_merge_tensors(G2tensor(63),[G2tensor(60),G2tensor(184),G2tensor(175),G1tensor(495),G0tensor(495)])
  call ol_merge_tensors(G2tensor(186),[G2tensor(177),G1tensor(497),G0tensor(497)])
  call ol_merge_tensors(G2tensor(64),[G2tensor(61),G2tensor(187),G2tensor(178),G1tensor(500),G0tensor(500)])
  call ol_merge_tensors(G1tensor(67),[G1tensor(37),G1tensor(7),G0tensor(12),G0tensor(7),G0tensor(2)])
  call ol_merge_tensors(G1tensor(147),[G1tensor(2),G1tensor(19),G0tensor(147),G0tensor(19),G0tensor(4)])
  call ol_merge_tensors(G1tensor(152),[G1tensor(50),G1tensor(25),G0tensor(152),G0tensor(35),G0tensor(5)])
  call ol_merge_tensors(G1tensor(160),[G1tensor(145),G1tensor(43),G0tensor(160),G0tensor(145),G0tensor(8)])
  call ol_merge_tensors(G1tensor(165),[G1tensor(150),G1tensor(24),G1tensor(49),G0tensor(165),G0tensor(150),G0tensor(24) &
    ,G0tensor(9)])
  call ol_merge_tensors(G2tensor(49),[G2tensor(40),G1tensor(170),G1tensor(155),G1tensor(62),G1tensor(55),G0tensor(170) &
    ,G0tensor(155),G0tensor(40),G0tensor(10)])
  call ol_merge_tensors(G1tensor(407),[G1tensor(157),G1tensor(73),G0tensor(407),G0tensor(157),G0tensor(13)])
  call ol_merge_tensors(G1tensor(162),[G1tensor(30),G1tensor(79),G0tensor(162),G0tensor(29),G0tensor(14)])
  call ol_merge_tensors(G1tensor(167),[G1tensor(3),G1tensor(85),G0tensor(167),G0tensor(55),G0tensor(15)])
  call ol_merge_tensors(G1tensor(26),[G1tensor(8),G1tensor(97),G0tensor(27),G0tensor(22),G0tensor(17)])
  call ol_merge_tensors(G1tensor(412),[G1tensor(172),G1tensor(103),G0tensor(412),G0tensor(172),G0tensor(18)])
  call ol_merge_tensors(G1tensor(177),[G1tensor(80),G1tensor(12),G0tensor(177),G0tensor(45),G0tensor(20)])
  call ol_merge_tensors(G1tensor(185),[G1tensor(175),G1tensor(14),G0tensor(185),G0tensor(175),G0tensor(23)])
  call ol_merge_tensors(G1tensor(54),[G1tensor(417),G1tensor(182),G1tensor(42),G0tensor(417),G0tensor(182),G0tensor(28)])
  call ol_merge_tensors(G1tensor(187),[G1tensor(9),G1tensor(32),G0tensor(187),G0tensor(60),G0tensor(30)])
  call ol_merge_tensors(G1tensor(308),[G1tensor(293),G1tensor(288),G1tensor(98),G1tensor(56),G1tensor(36),G0tensor(308) &
    ,G0tensor(293),G0tensor(288),G0tensor(52),G0tensor(37),G0tensor(32)])
  call ol_merge_tensors(G1tensor(197),[G1tensor(74),G1tensor(44),G0tensor(197),G0tensor(44),G0tensor(34)])
  call ol_merge_tensors(G1tensor(210),[G1tensor(195),G1tensor(66),G0tensor(210),G0tensor(195),G0tensor(38)])
  call ol_merge_tensors(G1tensor(215),[G1tensor(200),G1tensor(92),G1tensor(60),G0tensor(215),G0tensor(200),G0tensor(49) &
    ,G0tensor(39)])
  call ol_merge_tensors(G1tensor(313),[G1tensor(303),G1tensor(298),G1tensor(4),G1tensor(84),G1tensor(78),G0tensor(313) &
    ,G0tensor(303),G0tensor(298),G0tensor(57),G0tensor(47),G0tensor(42)])
  call ol_merge_tensors(G1tensor(387),[G1tensor(202),G1tensor(72),G0tensor(387),G0tensor(202),G0tensor(43)])
  call ol_merge_tensors(G1tensor(220),[G1tensor(205),G1tensor(86),G0tensor(220),G0tensor(205),G0tensor(48)])
  call ol_merge_tensors(G1tensor(392),[G1tensor(207),G1tensor(104),G0tensor(392),G0tensor(207),G0tensor(53)])
  call ol_merge_tensors(G1tensor(212),[G1tensor(5),G1tensor(108),G0tensor(212),G0tensor(59),G0tensor(54)])
  call ol_merge_tensors(G1tensor(397),[G1tensor(217),G1tensor(29),G0tensor(397),G0tensor(217),G0tensor(58)])
  call ol_merge_tensors(G1tensor(323),[G1tensor(318),G1tensor(17),G1tensor(10),G0tensor(323),G0tensor(318),G0tensor(67) &
    ,G0tensor(62)])
  call ol_merge_tensors(G1tensor(222),[G1tensor(41),G0tensor(222),G0tensor(63)])
  call ol_merge_tensors(G1tensor(227),[G1tensor(11),G0tensor(227),G0tensor(64)])
  call ol_merge_tensors(G1tensor(225),[G1tensor(21),G0tensor(225),G0tensor(68)])
  call ol_merge_tensors(G1tensor(230),[G1tensor(47),G0tensor(230),G0tensor(69)])
  call ol_merge_tensors(G1tensor(388),[G1tensor(383),G1tensor(57),G1tensor(40),G1tensor(34),G0tensor(388),G0tensor(383) &
    ,G0tensor(82),G0tensor(77),G0tensor(72)])
  call ol_merge_tensors(G1tensor(338),[G1tensor(237),G1tensor(28),G0tensor(338),G0tensor(237),G0tensor(73)])
  call ol_merge_tensors(G1tensor(242),[G1tensor(64),G1tensor(33),G0tensor(242),G0tensor(89),G0tensor(74)])
  call ol_merge_tensors(G2tensor(83),[G2tensor(20),G1tensor(488),G1tensor(247),G1tensor(99),G1tensor(39),G0tensor(488) &
    ,G0tensor(247),G0tensor(105),G0tensor(75)])
  call ol_merge_tensors(G1tensor(255),[G1tensor(240),G1tensor(45),G0tensor(255),G0tensor(240),G0tensor(78)])
  call ol_merge_tensors(G1tensor(260),[G1tensor(245),G1tensor(71),G1tensor(51),G0tensor(260),G0tensor(245),G0tensor(94) &
    ,G0tensor(79)])
  call ol_merge_tensors(G1tensor(343),[G1tensor(252),G1tensor(70),G0tensor(343),G0tensor(252),G0tensor(83)])
  call ol_merge_tensors(G1tensor(257),[G1tensor(94),G1tensor(58),G0tensor(257),G0tensor(99),G0tensor(84)])
  call ol_merge_tensors(G1tensor(262),[G1tensor(115),G1tensor(83),G0tensor(262),G0tensor(115),G0tensor(85)])
  call ol_merge_tensors(G1tensor(398),[G1tensor(393),G1tensor(77),G1tensor(69),G1tensor(63),G0tensor(398),G0tensor(393) &
    ,G0tensor(97),G0tensor(92),G0tensor(87)])
  call ol_merge_tensors(G1tensor(348),[G1tensor(267),G1tensor(76),G0tensor(348),G0tensor(267),G0tensor(88)])
  call ol_merge_tensors(G1tensor(272),[G1tensor(120),G1tensor(89),G0tensor(272),G0tensor(120),G0tensor(90)])
  call ol_merge_tensors(G1tensor(280),[G1tensor(270),G1tensor(95),G0tensor(280),G0tensor(270),G0tensor(93)])
  call ol_merge_tensors(G1tensor(353),[G1tensor(277),G1tensor(81),G0tensor(353),G0tensor(277),G0tensor(98)])
  call ol_merge_tensors(G1tensor(6),[G1tensor(282),G1tensor(130),G1tensor(82),G0tensor(282),G0tensor(130),G0tensor(100)])
  call ol_merge_tensors(G1tensor(203),[G1tensor(198),G1tensor(193),G1tensor(112),G1tensor(106),G1tensor(100),G0tensor(203) &
    ,G0tensor(198),G0tensor(193),G0tensor(112),G0tensor(107),G0tensor(102)])
  call ol_merge_tensors(G1tensor(363),[G1tensor(287),G1tensor(88),G0tensor(363),G0tensor(287),G0tensor(103)])
  call ol_merge_tensors(G1tensor(292),[G1tensor(119),G1tensor(93),G0tensor(292),G0tensor(119),G0tensor(104)])
  call ol_merge_tensors(G1tensor(300),[G1tensor(290),G1tensor(107),G0tensor(300),G0tensor(290),G0tensor(108)])
  call ol_merge_tensors(G1tensor(305),[G1tensor(295),G1tensor(124),G1tensor(109),G0tensor(305),G0tensor(295),G0tensor(124) &
    ,G0tensor(109)])
  call ol_merge_tensors(G1tensor(368),[G1tensor(297),G1tensor(113),G0tensor(368),G0tensor(297),G0tensor(113)])
  call ol_merge_tensors(G1tensor(302),[G1tensor(129),G1tensor(114),G0tensor(302),G0tensor(129),G0tensor(114)])
  call ol_merge_tensors(G1tensor(218),[G1tensor(213),G1tensor(208),G1tensor(127),G1tensor(122),G1tensor(117),G0tensor(218) &
    ,G0tensor(213),G0tensor(208),G0tensor(127),G0tensor(122),G0tensor(117)])
  call ol_merge_tensors(G1tensor(373),[G1tensor(307),G1tensor(118),G0tensor(373),G0tensor(307),G0tensor(118)])
  call ol_merge_tensors(G1tensor(315),[G1tensor(310),G1tensor(123),G0tensor(315),G0tensor(310),G0tensor(123)])
  call ol_merge_tensors(G1tensor(378),[G1tensor(312),G1tensor(128),G0tensor(378),G0tensor(312),G0tensor(128)])
  call ol_merge_tensors(G1tensor(228),[G1tensor(223),G1tensor(137),G1tensor(132),G0tensor(228),G0tensor(223),G0tensor(137) &
    ,G0tensor(132)])
  call ol_merge_tensors(G1tensor(317),[G1tensor(133),G0tensor(317),G0tensor(133)])
  call ol_merge_tensors(G1tensor(322),[G1tensor(134),G0tensor(322),G0tensor(134)])
  call ol_merge_tensors(G1tensor(320),[G1tensor(138),G0tensor(320),G0tensor(138)])
  call ol_merge_tensors(G1tensor(325),[G1tensor(139),G0tensor(325),G0tensor(139)])
  call ol_merge_tensors(G1tensor(367),[G1tensor(362),G1tensor(173),G1tensor(148),G1tensor(143),G0tensor(367),G0tensor(362) &
    ,G0tensor(173),G0tensor(148),G0tensor(143)])
  call ol_merge_tensors(G1tensor(194),[G1tensor(153),G1tensor(144),G0tensor(194),G0tensor(153),G0tensor(144)])
  call ol_merge_tensors(G2tensor(152),[G1tensor(464),G1tensor(199),G1tensor(179),G1tensor(154),G1tensor(149),G0tensor(464) &
    ,G0tensor(199),G0tensor(179),G0tensor(154),G0tensor(149)])
  call ol_merge_tensors(G1tensor(377),[G1tensor(372),G1tensor(183),G1tensor(163),G1tensor(158),G0tensor(377),G0tensor(372) &
    ,G0tensor(183),G0tensor(163),G0tensor(158)])
  call ol_merge_tensors(G1tensor(209),[G1tensor(168),G1tensor(159),G0tensor(209),G0tensor(168),G0tensor(159)])
  call ol_merge_tensors(G2tensor(158),[G2tensor(110),G1tensor(454),G1tensor(334),G1tensor(214),G1tensor(189),G1tensor(169) &
    ,G1tensor(164),G0tensor(454),G0tensor(334),G0tensor(214),G0tensor(189),G0tensor(169),G0tensor(164)])
  call ol_merge_tensors(G1tensor(204),[G1tensor(178),G1tensor(174),G0tensor(204),G0tensor(178),G0tensor(174)])
  call ol_merge_tensors(G1tensor(219),[G1tensor(188),G1tensor(184),G0tensor(219),G0tensor(188),G0tensor(184)])
  call ol_merge_tensors(G2tensor(173),[G2tensor(3),G1tensor(233),G1tensor(224),G0tensor(233),G0tensor(224)])
  call ol_merge_tensors(G2tensor(128),[G2tensor(9),G1tensor(459),G1tensor(234),G1tensor(229),G0tensor(459),G0tensor(234) &
    ,G0tensor(229)])
  call ol_merge_tensors(G1tensor(268),[G1tensor(243),G1tensor(238),G0tensor(268),G0tensor(243),G0tensor(238)])
  call ol_merge_tensors(G1tensor(289),[G1tensor(248),G1tensor(239),G0tensor(289),G0tensor(248),G0tensor(239)])
  call ol_merge_tensors(G1tensor(294),[G1tensor(274),G1tensor(249),G1tensor(244),G0tensor(294),G0tensor(274),G0tensor(249) &
    ,G0tensor(244)])
  call ol_merge_tensors(G1tensor(278),[G1tensor(258),G1tensor(253),G0tensor(278),G0tensor(258),G0tensor(253)])
  call ol_merge_tensors(G1tensor(299),[G1tensor(263),G1tensor(254),G0tensor(299),G0tensor(263),G0tensor(254)])
  call ol_merge_tensors(G1tensor(304),[G1tensor(284),G1tensor(264),G1tensor(259),G0tensor(304),G0tensor(284),G0tensor(264) &
    ,G0tensor(259)])
  call ol_merge_tensors(G1tensor(309),[G1tensor(273),G1tensor(269),G0tensor(309),G0tensor(273),G0tensor(269)])
  call ol_merge_tensors(G1tensor(314),[G1tensor(283),G1tensor(279),G0tensor(314),G0tensor(283),G0tensor(279)])
  call ol_merge_tensors(G2tensor(15),[G1tensor(328),G1tensor(319),G0tensor(328),G0tensor(319)])
  call ol_merge_tensors(G2tensor(18),[G1tensor(329),G1tensor(324),G0tensor(329),G0tensor(324)])
  call ol_merge_tensors(G2tensor(176),[G1tensor(1),G1tensor(333),G0tensor(333)])
  call ol_merge_tensors(G1tensor(413),[G1tensor(403),G1tensor(342),G1tensor(337),G0tensor(413),G0tensor(403),G0tensor(342) &
    ,G0tensor(337)])
  call ol_merge_tensors(G1tensor(349),[G1tensor(339),G0tensor(349),G0tensor(339)])
  call ol_merge_tensors(G2tensor(11),[G2tensor(6),G1tensor(473),G1tensor(365),G1tensor(340),G0tensor(473),G0tensor(365) &
    ,G0tensor(340)])
  call ol_merge_tensors(G1tensor(354),[G1tensor(344),G0tensor(354),G0tensor(344)])
  call ol_merge_tensors(G1tensor(370),[G1tensor(345),G0tensor(370),G0tensor(345)])
  call ol_merge_tensors(G1tensor(418),[G1tensor(408),G1tensor(352),G1tensor(347),G0tensor(418),G0tensor(408),G0tensor(352) &
    ,G0tensor(347)])
  call ol_merge_tensors(G1tensor(375),[G1tensor(350),G0tensor(375),G0tensor(350)])
  call ol_merge_tensors(G1tensor(61),[G1tensor(380),G1tensor(355),G0tensor(380),G0tensor(355)])
  call ol_merge_tensors(G1tensor(423),[G1tensor(357),G0tensor(423),G0tensor(357)])
  call ol_merge_tensors(G2tensor(146),[G2tensor(71),G1tensor(358),G0tensor(358)])
  call ol_merge_tensors(G1tensor(359),[G0tensor(359)])
  call ol_merge_tensors(G2tensor(56),[G2tensor(55),G1tensor(91),G1tensor(360),G0tensor(360)])
  call ol_merge_tensors(G1tensor(374),[G1tensor(364),G0tensor(374),G0tensor(364)])
  call ol_merge_tensors(G1tensor(379),[G1tensor(369),G0tensor(379),G0tensor(369)])
  call ol_merge_tensors(G1tensor(404),[G1tensor(384),G0tensor(404),G0tensor(384)])
  call ol_merge_tensors(G1tensor(395),[G1tensor(385),G0tensor(395),G0tensor(385)])
  call ol_merge_tensors(G1tensor(414),[G1tensor(389),G0tensor(414),G0tensor(389)])
  call ol_merge_tensors(G1tensor(400),[G1tensor(390),G0tensor(400),G0tensor(390)])
  call ol_merge_tensors(G1tensor(409),[G1tensor(394),G0tensor(409),G0tensor(394)])
  call ol_merge_tensors(G1tensor(419),[G1tensor(399),G0tensor(419),G0tensor(399)])
  call ol_merge_tensors(G1tensor(410),[G1tensor(405),G0tensor(410),G0tensor(405)])
  call ol_merge_tensors(G1tensor(420),[G1tensor(415),G0tensor(420),G0tensor(415)])
  call ol_merge_tensors(G2tensor(74),[G1tensor(422),G0tensor(422)])
  call ol_merge_tensors(G2tensor(19),[G2tensor(1),G1tensor(424),G0tensor(424)])
  call ol_merge_tensors(G1tensor(425),[G0tensor(425)])
  call ol_merge_tensors(G2tensor(29),[G1tensor(428),G0tensor(428)])
  call ol_merge_tensors(G2tensor(30),[G1tensor(429),G0tensor(429)])
  call ol_merge_tensors(G2tensor(44),[G2tensor(32),G1tensor(433),G0tensor(433)])
  call ol_merge_tensors(G2tensor(47),[G2tensor(35),G1tensor(434),G0tensor(434)])
  call ol_merge_tensors(G2tensor(48),[G2tensor(36),G1tensor(438),G0tensor(438)])
  call ol_merge_tensors(G2tensor(50),[G2tensor(38),G1tensor(439),G0tensor(439)])
  call ol_merge_tensors(G2tensor(41),[G1tensor(443),G0tensor(443)])
  call ol_merge_tensors(G2tensor(42),[G1tensor(444),G0tensor(444)])
  call ol_merge_tensors(G2tensor(53),[G1tensor(448),G0tensor(448)])
  call ol_merge_tensors(G2tensor(101),[G1tensor(469),G1tensor(449),G0tensor(469),G0tensor(449)])
  call ol_merge_tensors(G2tensor(155),[G2tensor(73),G1tensor(453),G0tensor(453)])
  call ol_merge_tensors(G2tensor(170),[G2tensor(113),G1tensor(458),G0tensor(458)])
  call ol_merge_tensors(G2tensor(131),[G1tensor(463),G0tensor(463)])
  call ol_merge_tensors(G2tensor(2),[G1tensor(468),G0tensor(468)])
  call ol_merge_tensors(G2tensor(39),[G2tensor(33),G2tensor(23),G2tensor(24),G2tensor(14),G2tensor(5),G1tensor(499),G1tensor(494) &
    ,G1tensor(489),G1tensor(484),G1tensor(479),G1tensor(474),G0tensor(499),G0tensor(494),G0tensor(489),G0tensor(484),G0tensor(479) &
    ,G0tensor(474)])
  call ol_merge_tensors(G2tensor(21),[G2tensor(8),G1tensor(478),G0tensor(478)])
  call ol_merge_tensors(G2tensor(17),[G2tensor(12),G1tensor(483),G0tensor(483)])
  call ol_merge_tensors(G2tensor(84),[G2tensor(26),G1tensor(493),G0tensor(493)])
  call ol_merge_tensors(G2tensor(85),[G2tensor(27),G1tensor(498),G0tensor(498)])
  call ol_merge_tensors(G2tensor(7),[G1tensor(31)])
  call ol_merge_tensors(G2tensor(72),[G1tensor(48)])
  call TI_triangle_red(G2tensor(144),RedBasis(35),mass3set(:,1),G0tensor(1),G0tensor(6),G0tensor(11), &
    G0tensor(16),M2L1R1,[nMW,nMB],G0tensor(21),G0tensor(26))
  call TI_triangle_red(G2tensor(143),RedBasis(1),mass3set(:,2),G0tensor(31),G0tensor(36),G0tensor(41), &
    G0tensor(46),M2L1R1,[nMB,nMW],G0tensor(51),G0tensor(56))
  call TI_triangle_red(G2tensor(58),RedBasis(34),mass3set(:,3),G0tensor(61),G0tensor(66),G0tensor(71),G0tensor(76),M2L1R1,[nMW], &
    G0tensor(81))
  call TI_triangle_red(G2tensor(70),RedBasis(10),mass3set(:,4),G0tensor(86),G0tensor(91),G0tensor(96),G0tensor(101),M2L1R1,[nMW], &
    G0tensor(106))
  call TI_triangle_red(G2tensor(86),RedBasis(5),mass3set(:,5),G0tensor(111),G0tensor(116),G0tensor(121), &
    G0tensor(126),M2L1R1,[nMH,nMT],G0tensor(131),G0tensor(136))
  call TI_triangle_red(G2tensor(139),RedBasis(28),mass3set(:,6),G0tensor(141),G0tensor(146),G0tensor(151), &
    G0tensor(156),M2L1R1,[nMT],G0tensor(161))
  call TI_triangle_red(G2tensor(89),RedBasis(5),mass3set(:,7),G0tensor(166),G0tensor(171),G0tensor(176), &
    G0tensor(181),M2L1R1,[nMZ,nMT],G0tensor(186),G0tensor(191))
  call TI_triangle_red(G2tensor(51),RedBasis(5),mass3set(:,8),G0tensor(196),G0tensor(201),G0tensor(206), &
    G0tensor(211),M2L1R1,[nMW,nMB],G0tensor(216),G0tensor(221))
  call TI_triangle_red(G2tensor(142),RedBasis(28),mass3set(:,9),G0tensor(226),G0tensor(231),G0tensor(236), &
    G0tensor(241),M2L1R1,[nMB],G0tensor(246))
  call TI_triangle_red(G2tensor(88),RedBasis(5),mass3set(:,10),G0tensor(251),G0tensor(256),G0tensor(261), &
    G0tensor(266),M2L1R1,[nMT],G0tensor(271))
  call TI_triangle_red(G2tensor(90),RedBasis(45),mass3set(:,5),G0tensor(276),G0tensor(281),G0tensor(286), &
    G0tensor(291),M2L1R1,[nMH,nMT],G0tensor(296),G0tensor(301))
  call TI_triangle_red(G2tensor(13),RedBasis(45),mass3set(:,7),G0tensor(306),G0tensor(311),G0tensor(316), &
    G0tensor(321),M2L1R1,[nMZ,nMT],G0tensor(326),G0tensor(331))
  call TI_triangle_red(G2tensor(16),RedBasis(45),mass3set(:,8),G0tensor(336),G0tensor(341),G0tensor(346), &
    G0tensor(351),M2L1R1,[nMW,nMB],G0tensor(356),G0tensor(361))
  call TI_triangle_red(G2tensor(10),RedBasis(45),mass3set(:,10),G0tensor(366),G0tensor(371),G0tensor(376), &
    G0tensor(381),M2L1R1,[nMT],G0tensor(386))
  call TI_triangle_red(G2tensor(147),RedBasis(35),mass3set(:,11),G0tensor(391),G0tensor(396),G0tensor(401), &
    G0tensor(406),M2L1R1,[nMZ,nMT,nMH],G0tensor(411),G0tensor(416),G0tensor(421))
  call TI_triangle_red(G2tensor(31),RedBasis(1),mass3set(:,12),G0tensor(426),G0tensor(431),G0tensor(436), &
    G0tensor(441),M2L1R1,[nMT,nMH],G0tensor(446),G0tensor(451))
  call TI_triangle_red(G2tensor(150),RedBasis(35),mass3set(:,13),G0tensor(456),G0tensor(461),G0tensor(466), &
    G0tensor(471),M2L1R1,[nMH,nMT,nMZ],G0tensor(476),G0tensor(481),G0tensor(486))
  call TI_triangle_red(G2tensor(52),RedBasis(1),mass3set(:,14),G0tensor(491),G0tensor(496),G0tensor(232), &
    G0tensor(65),M2L1R1,[nMT,nMZ],G0tensor(235),G0tensor(70))
  call TI_triangle_red(G2tensor(75),RedBasis(37),mass3set(:,15),G0tensor(327),G0tensor(135),G0tensor(485),G0tensor(330),M2L1R1)
  call TI_triangle_red(G2tensor(68),RedBasis(10),mass3set(:,15),G0tensor(140),G0tensor(427),G0tensor(465),G0tensor(455),M2L1R1)
  call TI_triangle_red(G2tensor(76),RedBasis(37),mass3set(:,16),G0tensor(450),G0tensor(445),G0tensor(435), &
    G0tensor(430),M2L1R1,[nMZ],G0tensor(432))
  call TI_triangle_red(G2tensor(69),RedBasis(10),mass3set(:,16),G0tensor(437),G0tensor(460),G0tensor(440), &
    G0tensor(442),M2L1R1,[nMZ],G0tensor(447))
  call TI_triangle_red(G2tensor(77),RedBasis(37),mass3set(:,4),G0tensor(452),G0tensor(457),G0tensor(462), &
    G0tensor(332),M2L1R1,[nMW],G0tensor(335))
  call TI_triangle_red(G2tensor(180),RedBasis(39),mass3set(:,15),G0tensor(467),G0tensor(470),G0tensor(190),G0tensor(180),M2L1R1)
  call TI_triangle_red(G2tensor(62),RedBasis(33),mass3set(:,15),G0tensor(50),G0tensor(25),G0tensor(472),G0tensor(402),M2L1R1)
  call TI_triangle_red(G2tensor(183),RedBasis(39),mass3set(:,16),G0tensor(142),G0tensor(3),G0tensor(475), &
    G0tensor(265),M2L1R1,[nMZ],G0tensor(250))
  call TI_triangle_red(G2tensor(63),RedBasis(33),mass3set(:,16),G0tensor(110),G0tensor(80),G0tensor(477), &
    G0tensor(480),M2L1R1,[nMZ],G0tensor(285))
  call TI_triangle_red(G2tensor(186),RedBasis(39),mass3set(:,4),G0tensor(275),G0tensor(125),G0tensor(95), &
    G0tensor(482),M2L1R1,[nMW],G0tensor(487))
  call TI_triangle_red(G2tensor(64),RedBasis(33),mass3set(:,4),G0tensor(382),G0tensor(192),G0tensor(33), &
    G0tensor(490),M2L1R1,[nMW],G0tensor(492))
  call TI_triangle_red(G2tensor(49),RedBasis(1),mass3set(:,17),G0tensor(495),G0tensor(497),G0tensor(500), &
    G0tensor(12),M2L1R1,[nMT],G0tensor(7))
  call TI_triangle_red(G2tensor(83),RedBasis(34),mass3set(:,15),G0tensor(2),G0tensor(147),G0tensor(19),G0tensor(4),M2L1R1)
  call TI_triangle_red(G2tensor(152),RedBasis(3),mass3set(:,17),G0tensor(152),G0tensor(35),G0tensor(5),G0tensor(160),M2L1R1,[nMT], &
    G0tensor(145))
  call TI_triangle_red(G2tensor(158),RedBasis(3),mass3set(:,14),G0tensor(8),G0tensor(165),G0tensor(150), &
    G0tensor(24),M2L1R1,[nMT,nMZ],G0tensor(9),G0tensor(170))
  call TI_triangle_red(G2tensor(173),RedBasis(5),mass3set(:,18),G0tensor(155),G0tensor(40),G0tensor(10), &
    G0tensor(407),M2L1R1,[nMB,nMW],G0tensor(157),G0tensor(13))
  call TI_triangle_red(G2tensor(128),RedBasis(3),mass3set(:,2),G0tensor(162),G0tensor(29),G0tensor(14), &
    G0tensor(167),M2L1R1,[nMB,nMW],G0tensor(55),G0tensor(15))
  call TI_triangle_red(G2tensor(15),RedBasis(13),mass3set(:,19),G0tensor(27),G0tensor(22),G0tensor(17),G0tensor(412),M2L1R1,[nMW], &
    G0tensor(172))
  call TI_triangle_red(G2tensor(18),RedBasis(11),mass3set(:,4),G0tensor(18),G0tensor(177),G0tensor(45),G0tensor(20),M2L1R1,[nMW], &
    G0tensor(185))
  call TI_triangle_red(G2tensor(176),RedBasis(5),mass3set(:,20),G0tensor(175),G0tensor(23),G0tensor(417), &
    G0tensor(182),M2L1R1,[nMT,nMH,nMZ],G0tensor(28),G0tensor(187),G0tensor(60))
  call TI_triangle_red(G2tensor(11),RedBasis(32),mass3set(:,15),G0tensor(30),G0tensor(308),G0tensor(293),G0tensor(288),M2L1R1)
  call TI_triangle_red(G2tensor(146),RedBasis(31),mass3set(:,21),G0tensor(52),G0tensor(37),G0tensor(32), &
    G0tensor(197),M2L1R1,[nMW,nMB],G0tensor(44),G0tensor(34))
  call TI_triangle_red(G2tensor(56),RedBasis(32),mass3set(:,3),G0tensor(210),G0tensor(195),G0tensor(38), &
    G0tensor(215),M2L1R1,[nMW],G0tensor(200))
  call TI_triangle_red(G2tensor(74),RedBasis(37),mass3set(:,22),G0tensor(49),G0tensor(39),G0tensor(313), &
    G0tensor(303),M2L1R1,[nMW],G0tensor(298))
  call TI_triangle_red(G2tensor(19),RedBasis(45),mass3set(:,18),G0tensor(57),G0tensor(47),G0tensor(42), &
    G0tensor(387),M2L1R1,[nMB,nMW],G0tensor(202),G0tensor(43))
  call TI_triangle_red(G2tensor(29),RedBasis(30),mass3set(:,12),G0tensor(220),G0tensor(205),G0tensor(48), &
    G0tensor(392),M2L1R1,[nMT,nMH],G0tensor(207),G0tensor(53))
  call TI_triangle_red(G2tensor(30),RedBasis(29),mass3set(:,12),G0tensor(212),G0tensor(59),G0tensor(54), &
    G0tensor(397),M2L1R1,[nMT,nMH],G0tensor(217),G0tensor(58))
  call TI_triangle_red(G2tensor(44),RedBasis(30),mass3set(:,14),G0tensor(323),G0tensor(318),G0tensor(67), &
    G0tensor(62),M2L1R1,[nMT,nMZ],G0tensor(222),G0tensor(63))
  call TI_triangle_red(G2tensor(47),RedBasis(29),mass3set(:,14),G0tensor(227),G0tensor(64),G0tensor(225), &
    G0tensor(68),M2L1R1,[nMT,nMZ],G0tensor(230),G0tensor(69))
  call TI_triangle_red(G2tensor(48),RedBasis(30),mass3set(:,2),G0tensor(388),G0tensor(383),G0tensor(82), &
    G0tensor(77),M2L1R1,[nMB,nMW],G0tensor(72),G0tensor(338))
  call TI_triangle_red(G2tensor(50),RedBasis(29),mass3set(:,2),G0tensor(237),G0tensor(73),G0tensor(242), &
    G0tensor(89),M2L1R1,[nMB,nMW],G0tensor(74),G0tensor(488))
  call TI_triangle_red(G2tensor(41),RedBasis(30),mass3set(:,17),G0tensor(247),G0tensor(105),G0tensor(75), &
    G0tensor(255),M2L1R1,[nMT],G0tensor(240))
  call TI_triangle_red(G2tensor(42),RedBasis(29),mass3set(:,17),G0tensor(78),G0tensor(260),G0tensor(245), &
    G0tensor(94),M2L1R1,[nMT],G0tensor(79))
  call TI_triangle_red(G2tensor(53),RedBasis(31),mass3set(:,12),G0tensor(343),G0tensor(252),G0tensor(83), &
    G0tensor(257),M2L1R1,[nMT,nMH],G0tensor(99),G0tensor(84))
  call TI_triangle_red(G2tensor(101),RedBasis(3),mass3set(:,12),G0tensor(262),G0tensor(115),G0tensor(85), &
    G0tensor(398),M2L1R1,[nMT,nMH],G0tensor(393),G0tensor(97))
  call TI_triangle_red(G2tensor(155),RedBasis(31),mass3set(:,14),G0tensor(92),G0tensor(87),G0tensor(348), &
    G0tensor(267),M2L1R1,[nMT,nMZ],G0tensor(88),G0tensor(272))
  call TI_triangle_red(G2tensor(170),RedBasis(31),mass3set(:,2),G0tensor(120),G0tensor(90),G0tensor(280), &
    G0tensor(270),M2L1R1,[nMB,nMW],G0tensor(93),G0tensor(353))
  call TI_triangle_red(G2tensor(131),RedBasis(31),mass3set(:,17),G0tensor(277),G0tensor(98),G0tensor(282), &
    G0tensor(130),M2L1R1,[nMT],G0tensor(100))
  call TI_triangle_red(G2tensor(2),RedBasis(5),mass3set(:,23),G0tensor(203),G0tensor(198),G0tensor(193), &
    G0tensor(112),M2L1R1,[nMT,nMZ,nMH],G0tensor(107),G0tensor(102),G0tensor(363))
  call TI_triangle_red(G2tensor(39),RedBasis(28),mass3set(:,15),G0tensor(287),G0tensor(103),G0tensor(292),G0tensor(119),M2L1R1)
  call TI_triangle_red(G2tensor(21),RedBasis(32),mass3set(:,24),G0tensor(104),G0tensor(300),G0tensor(290), &
    G0tensor(108),M2L1R1,[nMZ],G0tensor(305))
  call TI_triangle_red(G2tensor(17),RedBasis(32),mass3set(:,25),G0tensor(295),G0tensor(124),G0tensor(109), &
    G0tensor(368),M2L1R1,[nMW],G0tensor(297))
  call TI_triangle_red(G2tensor(84),RedBasis(34),mass3set(:,24),G0tensor(113),G0tensor(302),G0tensor(129), &
    G0tensor(114),M2L1R1,[nMZ],G0tensor(218))
  call TI_triangle_red(G2tensor(85),RedBasis(34),mass3set(:,25),G0tensor(213),G0tensor(208),G0tensor(127), &
    G0tensor(122),M2L1R1,[nMW],G0tensor(117))
  call TI_triangle_red(G2tensor(4),RedBasis(45),mass3set(:,23),G0tensor(373),G0tensor(307),G0tensor(118), &
    G0tensor(315),M2L1R1,[nMT,nMZ,nMH],G0tensor(310),G0tensor(123),G0tensor(378))
  call TI_triangle_red(G2tensor(7),RedBasis(45),mass3set(:,20),G0tensor(312),G0tensor(128),G0tensor(228), &
    G0tensor(223),M2L1R1,[nMT,nMH,nMZ],G0tensor(137),G0tensor(132),G0tensor(317))
  call TI_triangle_red(G2tensor(72),RedBasis(31),mass3set(:,26),G0tensor(133),G0tensor(322),G0tensor(134), &
    G0tensor(320),M2L1R1,[nMZ,nMH,nMT],G0tensor(138),G0tensor(325),G0tensor(139))
  call TI_triangle_red(G2tensor(104),RedBasis(31),mass3set(:,27),G0tensor(367),G0tensor(362),G0tensor(173), &
    G0tensor(148),M2L1R1,[nMH,nMZ,nMT],G0tensor(143),G0tensor(194),G0tensor(153))
  call TI_triangle_red(G1tensor(67),RedBasis(49),mass3set(:,28),G0tensor(144),G0tensor(464),G0tensor(199), &
    G0tensor(179),M2L1R1,[nMT],G0tensor(154))
  call TI_triangle_red(G1tensor(147),RedBasis(36),mass3set(:,28),G0tensor(149),G0tensor(377),G0tensor(372), &
    G0tensor(183),M2L1R1,[nMT],G0tensor(163))
  call TI_triangle_red(G1tensor(152),RedBasis(35),mass3set(:,28),G0tensor(158),G0tensor(209),G0tensor(168), &
    G0tensor(159),M2L1R1,[nMT],G0tensor(454))
  call TI_triangle_red(G1tensor(160),RedBasis(4),mass3set(:,29),G0tensor(334),G0tensor(214),G0tensor(189), &
    G0tensor(169),M2L1R1,[nMT],G0tensor(164))
  call TI_triangle_red(G1tensor(165),RedBasis(2),mass3set(:,17),G0tensor(204),G0tensor(178),G0tensor(174), &
    G0tensor(219),M2L1R1,[nMT],G0tensor(188))
  call TI_triangle_red(G1tensor(407),RedBasis(37),mass3set(:,30),G0tensor(184),G0tensor(233),G0tensor(224), &
    G0tensor(459),M2L1R1,[nMZ],G0tensor(234))
  call TI_triangle_red(G1tensor(162),RedBasis(36),mass3set(:,31),G0tensor(229),G0tensor(268),G0tensor(243), &
    G0tensor(238),M2L1R1,[nMZ,nMT],G0tensor(289),G0tensor(248))
  call TI_triangle_red(G1tensor(167),RedBasis(35),mass3set(:,31),G0tensor(239),G0tensor(294),G0tensor(274), &
    G0tensor(249),M2L1R1,[nMZ,nMT],G0tensor(244),G0tensor(278))
  call TI_triangle_red(G1tensor(26),RedBasis(49),mass3set(:,32),G0tensor(258),G0tensor(253),G0tensor(299), &
    G0tensor(263),M2L1R1,[nMT,nMZ],G0tensor(254),G0tensor(304))
  call TI_triangle_red(G1tensor(412),RedBasis(37),mass3set(:,24),G0tensor(284),G0tensor(264),G0tensor(259), &
    G0tensor(309),M2L1R1,[nMZ],G0tensor(273))
  call TI_triangle_red(G1tensor(177),RedBasis(35),mass3set(:,32),G0tensor(269),G0tensor(314),G0tensor(283), &
    G0tensor(279),M2L1R1,[nMT,nMZ],G0tensor(328),G0tensor(319))
  call TI_triangle_red(G1tensor(185),RedBasis(4),mass3set(:,33),G0tensor(329),G0tensor(324),G0tensor(333), &
    G0tensor(413),M2L1R1,[nMT,nMZ],G0tensor(403),G0tensor(342))
  call TI_triangle_red(G1tensor(54),RedBasis(37),mass3set(:,34),G0tensor(337),G0tensor(349),G0tensor(339), &
    G0tensor(473),M2L1R1,[nMZ],G0tensor(365))
  call TI_triangle_red(G1tensor(187),RedBasis(35),mass3set(:,35),G0tensor(340),G0tensor(354),G0tensor(344), &
    G0tensor(370),M2L1R1,[nMZ,nMT],G0tensor(345),G0tensor(418))
  call TI_triangle_red(G1tensor(308),RedBasis(17),mass3set(:,28),G0tensor(408),G0tensor(352),G0tensor(347), &
    G0tensor(375),M2L1R1,[nMT],G0tensor(350))
  call TI_triangle_red(G1tensor(197),RedBasis(38),mass3set(:,28),G0tensor(380),G0tensor(355),G0tensor(423), &
    G0tensor(357),M2L1R1,[nMT],G0tensor(358))
  call TI_triangle_red(G1tensor(210),RedBasis(8),mass3set(:,29),G0tensor(359),G0tensor(360),G0tensor(374), &
    G0tensor(364),M2L1R1,[nMT],G0tensor(379))
  call TI_triangle_red(G1tensor(215),RedBasis(7),mass3set(:,17),G0tensor(369),G0tensor(404),G0tensor(384), &
    G0tensor(395),M2L1R1,[nMT],G0tensor(385))
  call TI_triangle_red(G1tensor(313),RedBasis(17),mass3set(:,32),G0tensor(414),G0tensor(389),G0tensor(400), &
    G0tensor(390),M2L1R1,[nMT,nMZ],G0tensor(409),G0tensor(394))
  call TI_triangle_red(G1tensor(387),RedBasis(39),mass3set(:,24),G0tensor(419),G0tensor(399),G0tensor(410), &
    G0tensor(405),M2L1R1,[nMZ],G0tensor(420))
  call TI_triangle_red(G1tensor(220),RedBasis(8),mass3set(:,33),G0tensor(415),G0tensor(422),G0tensor(424), &
    G0tensor(425),M2L1R1,[nMT,nMZ],G0tensor(428),G0tensor(429))
  call TI_triangle_red(G1tensor(392),RedBasis(39),mass3set(:,30),G0tensor(433),G0tensor(434),G0tensor(438), &
    G0tensor(439),M2L1R1,[nMZ],G0tensor(443))
  call TI_triangle_red(G1tensor(212),RedBasis(38),mass3set(:,31),G0tensor(444),G0tensor(448),G0tensor(469), &
    G0tensor(449),M2L1R1,[nMZ,nMT],G0tensor(453),G0tensor(458))
  call TI_triangle_red(G1tensor(397),RedBasis(39),mass3set(:,34),G0tensor(463),G0tensor(468),G0tensor(499), &
    G0tensor(494),M2L1R1,[nMZ],G0tensor(489))
  call TI_triangle_red(G1tensor(323),RedBasis(17),mass3set(:,36),G0tensor(484),G0tensor(479),G0tensor(474), &
    G0tensor(478),M2L1R1,[nMB,nMW],G0tensor(483),G0tensor(493))
  call TI_triangle_red(G1tensor(222),RedBasis(39),mass3set(:,22),G0tensor(498),G0tensor(501),G0tensor(502), &
    G0tensor(503),M2L1R1,[nMW],G0tensor(504))
  call TI_triangle_red(G1tensor(227),RedBasis(38),mass3set(:,37),G0tensor(505),G0tensor(506),G0tensor(507), &
    G0tensor(508),M2L1R1,[nMW,nMB],G0tensor(509),G0tensor(510))
  call TI_triangle_red(G1tensor(225),RedBasis(8),mass3set(:,38),G0tensor(511),G0tensor(512),G0tensor(513), &
    G0tensor(514),M2L1R1,[nMB,nMW],G0tensor(515),G0tensor(516))
  call TI_triangle_red(G1tensor(230),RedBasis(7),mass3set(:,39),G0tensor(517),G0tensor(518),G0tensor(519), &
    G0tensor(520),M2L1R1,[nMB],G0tensor(521))
  call TI_triangle_red(G1tensor(388),RedBasis(46),mass3set(:,29),G0tensor(522),G0tensor(523),G0tensor(524), &
    G0tensor(525),M2L1R1,[nMT],G0tensor(526))
  call TI_triangle_red(G1tensor(338),RedBasis(31),mass3set(:,40),G0tensor(527),G0tensor(528),G0tensor(529), &
    G0tensor(530),M2L1R1,[nMT],G0tensor(531))
  call TI_triangle_red(G1tensor(242),RedBasis(40),mass3set(:,40),G0tensor(532),G0tensor(533),G0tensor(534), &
    G0tensor(535),M2L1R1,[nMT],G0tensor(536))
  call TI_triangle_red(G1tensor(255),RedBasis(12),mass3set(:,40),G0tensor(537),G0tensor(538),G0tensor(539), &
    G0tensor(540),M2L1R1,[nMT],G0tensor(541))
  call TI_triangle_red(G1tensor(260),RedBasis(2),mass3set(:,40),G0tensor(542),G0tensor(543),G0tensor(544), &
    G0tensor(545),M2L1R1,[nMT],G0tensor(546))
  call TI_triangle_red(G1tensor(343),RedBasis(31),mass3set(:,41),G0tensor(547),G0tensor(548),G0tensor(549), &
    G0tensor(550),M2L1R1,[nMZ,nMT],G0tensor(551),G0tensor(552))
  call TI_triangle_red(G1tensor(257),RedBasis(40),mass3set(:,41),G0tensor(553),G0tensor(554),G0tensor(555), &
    G0tensor(556),M2L1R1,[nMZ,nMT],G0tensor(557),G0tensor(558))
  call TI_triangle_red(G1tensor(262),RedBasis(34),mass3set(:,30),G0tensor(559),G0tensor(560),G0tensor(561), &
    G0tensor(562),M2L1R1,[nMZ],G0tensor(563))
  call TI_triangle_red(G1tensor(398),RedBasis(46),mass3set(:,42),G0tensor(564),G0tensor(565),G0tensor(566), &
    G0tensor(567),M2L1R1,[nMT,nMZ],G0tensor(568),G0tensor(569))
  call TI_triangle_red(G1tensor(348),RedBasis(31),mass3set(:,43),G0tensor(570),G0tensor(571),G0tensor(572), &
    G0tensor(573),M2L1R1,[nMZ,nMT],G0tensor(574),G0tensor(575))
  call TI_triangle_red(G1tensor(272),RedBasis(34),mass3set(:,16),G0tensor(576),G0tensor(577),G0tensor(578), &
    G0tensor(579),M2L1R1,[nMZ],G0tensor(580))
  call TI_triangle_red(G1tensor(280),RedBasis(12),mass3set(:,43),G0tensor(581),G0tensor(582),G0tensor(583), &
    G0tensor(584),M2L1R1,[nMZ,nMT],G0tensor(585),G0tensor(586))
  call TI_triangle_red(G1tensor(353),RedBasis(31),mass3set(:,44),G0tensor(587),G0tensor(588),G0tensor(589), &
    G0tensor(590),M2L1R1,[nMZ,nMT],G0tensor(591),G0tensor(592))
  call TI_triangle_red(G1tensor(6),RedBasis(34),mass3set(:,45),G0tensor(593),G0tensor(594),G0tensor(595), &
    G0tensor(596),M2L1R1,[nMZ],G0tensor(597))
  call TI_triangle_red(G1tensor(203),RedBasis(9),mass3set(:,29),G0tensor(598),G0tensor(599),G0tensor(600), &
    G0tensor(601),M2L1R1,[nMT],G0tensor(602))
  call TI_triangle_red(G1tensor(363),RedBasis(30),mass3set(:,40),G0tensor(603),G0tensor(604),G0tensor(605), &
    G0tensor(606),M2L1R1,[nMT],G0tensor(607))
  call TI_triangle_red(G1tensor(292),RedBasis(41),mass3set(:,40),G0tensor(608),G0tensor(609),G0tensor(610), &
    G0tensor(611),M2L1R1,[nMT],G0tensor(612))
  call TI_triangle_red(G1tensor(300),RedBasis(16),mass3set(:,40),G0tensor(613),G0tensor(614),G0tensor(615), &
    G0tensor(616),M2L1R1,[nMT],G0tensor(617))
  call TI_triangle_red(G1tensor(305),RedBasis(15),mass3set(:,40),G0tensor(618),G0tensor(619),G0tensor(620), &
    G0tensor(621),M2L1R1,[nMT],G0tensor(622))
  call TI_triangle_red(G1tensor(368),RedBasis(30),mass3set(:,41),G0tensor(623),G0tensor(624),G0tensor(625), &
    G0tensor(626),M2L1R1,[nMZ,nMT],G0tensor(627),G0tensor(628))
  call TI_triangle_red(G1tensor(302),RedBasis(41),mass3set(:,41),G0tensor(629),G0tensor(630),G0tensor(631), &
    G0tensor(632),M2L1R1,[nMZ,nMT],G0tensor(633),G0tensor(634))
  call TI_triangle_red(G1tensor(218),RedBasis(9),mass3set(:,42),G0tensor(635),G0tensor(636),G0tensor(637), &
    G0tensor(638),M2L1R1,[nMT,nMZ],G0tensor(639),G0tensor(640))
  call TI_triangle_red(G1tensor(373),RedBasis(30),mass3set(:,43),G0tensor(641),G0tensor(642),G0tensor(643), &
    G0tensor(644),M2L1R1,[nMZ,nMT],G0tensor(645),G0tensor(646))
  call TI_triangle_red(G1tensor(315),RedBasis(16),mass3set(:,43),G0tensor(647),G0tensor(648),G0tensor(649), &
    G0tensor(650),M2L1R1,[nMZ,nMT],G0tensor(651),G0tensor(652))
  call TI_triangle_red(G1tensor(378),RedBasis(30),mass3set(:,44),G0tensor(653),G0tensor(654),G0tensor(655), &
    G0tensor(656),M2L1R1,[nMZ,nMT],G0tensor(657),G0tensor(658))
  call TI_triangle_red(G1tensor(228),RedBasis(9),mass3set(:,46),G0tensor(659),G0tensor(660),G0tensor(661), &
    G0tensor(662),M2L1R1,[nMB,nMW],G0tensor(663),G0tensor(664))
  call TI_triangle_red(G1tensor(317),RedBasis(30),mass3set(:,21),G0tensor(665),G0tensor(666),G0tensor(667), &
    G0tensor(668),M2L1R1,[nMW,nMB],G0tensor(669),G0tensor(670))
  call TI_triangle_red(G1tensor(322),RedBasis(41),mass3set(:,47),G0tensor(671),G0tensor(672),G0tensor(673), &
    G0tensor(674),M2L1R1,[nMW,nMB],G0tensor(675),G0tensor(676))
  call TI_triangle_red(G1tensor(320),RedBasis(16),mass3set(:,48),G0tensor(677),G0tensor(678),G0tensor(679), &
    G0tensor(680),M2L1R1,[nMW,nMB],G0tensor(681),G0tensor(682))
  call TI_triangle_red(G1tensor(325),RedBasis(15),mass3set(:,49),G0tensor(683),G0tensor(684),G0tensor(685), &
    G0tensor(686),M2L1R1,[nMB],G0tensor(687))
  call TI_triangle_red(G1tensor(367),RedBasis(6),mass3set(:,29),G0tensor(688),G0tensor(689),G0tensor(690), &
    G0tensor(691),M2L1R1,[nMT],G0tensor(692))
  call TI_triangle_red(G1tensor(194),RedBasis(5),mass3set(:,29),G0tensor(693),G0tensor(694),G0tensor(695), &
    G0tensor(696),M2L1R1,[nMT],G0tensor(697))
  call TI_triangle_red(G1tensor(377),RedBasis(6),mass3set(:,42),G0tensor(698),G0tensor(699),G0tensor(700), &
    G0tensor(701),M2L1R1,[nMT,nMZ],G0tensor(702),G0tensor(703))
  call TI_triangle_red(G1tensor(209),RedBasis(5),mass3set(:,42),G0tensor(704),G0tensor(705),G0tensor(706), &
    G0tensor(707),M2L1R1,[nMT,nMZ],G0tensor(708),G0tensor(709))
  call TI_triangle_red(G1tensor(204),RedBasis(5),mass3set(:,33),G0tensor(710),G0tensor(711),G0tensor(712), &
    G0tensor(713),M2L1R1,[nMT,nMZ],G0tensor(714),G0tensor(715))
  call TI_triangle_red(G1tensor(219),RedBasis(5),mass3set(:,50),G0tensor(716),G0tensor(717),G0tensor(718), &
    G0tensor(719),M2L1R1,[nMT,nMZ],G0tensor(720),G0tensor(721))
  call TI_triangle_red(G1tensor(268),RedBasis(14),mass3set(:,28),G0tensor(722),G0tensor(723),G0tensor(724), &
    G0tensor(725),M2L1R1,[nMT],G0tensor(726))
  call TI_triangle_red(G1tensor(289),RedBasis(13),mass3set(:,15),G0tensor(727),G0tensor(728),G0tensor(729),G0tensor(730),M2L1R1)
  call TI_triangle_red(G1tensor(294),RedBasis(11),mass3set(:,15),G0tensor(731),G0tensor(732),G0tensor(733),G0tensor(734),M2L1R1)
  call TI_triangle_red(G1tensor(278),RedBasis(14),mass3set(:,32),G0tensor(735),G0tensor(736),G0tensor(737), &
    G0tensor(738),M2L1R1,[nMT,nMZ],G0tensor(739),G0tensor(740))
  call TI_triangle_red(G1tensor(299),RedBasis(13),mass3set(:,16),G0tensor(741),G0tensor(742),G0tensor(743), &
    G0tensor(744),M2L1R1,[nMZ],G0tensor(745))
  call TI_triangle_red(G1tensor(304),RedBasis(11),mass3set(:,16),G0tensor(746),G0tensor(747),G0tensor(748), &
    G0tensor(749),M2L1R1,[nMZ],G0tensor(750))
  call TI_triangle_red(G1tensor(309),RedBasis(13),mass3set(:,24),G0tensor(751),G0tensor(752),G0tensor(753), &
    G0tensor(754),M2L1R1,[nMZ],G0tensor(755))
  call TI_triangle_red(G1tensor(314),RedBasis(13),mass3set(:,51),G0tensor(756),G0tensor(757),G0tensor(758), &
    G0tensor(759),M2L1R1,[nMZ],G0tensor(760))
  call TI_triangle_red(G1tensor(413),RedBasis(48),mass3set(:,29),G0tensor(761),G0tensor(762),G0tensor(763), &
    G0tensor(764),M2L1R1,[nMT],G0tensor(765))
  call TI_triangle_red(G1tensor(349),RedBasis(42),mass3set(:,40),G0tensor(766),G0tensor(767),G0tensor(768), &
    G0tensor(769),M2L1R1,[nMT],G0tensor(770))
  call TI_triangle_red(G1tensor(354),RedBasis(42),mass3set(:,41),G0tensor(771),G0tensor(772),G0tensor(773), &
    G0tensor(774),M2L1R1,[nMZ,nMT],G0tensor(775),G0tensor(776))
  call TI_triangle_red(G1tensor(370),RedBasis(32),mass3set(:,30),G0tensor(777),G0tensor(778),G0tensor(779), &
    G0tensor(780),M2L1R1,[nMZ],G0tensor(781))
  call TI_triangle_red(G1tensor(418),RedBasis(48),mass3set(:,42),G0tensor(782),G0tensor(783),G0tensor(784), &
    G0tensor(785),M2L1R1,[nMT,nMZ],G0tensor(786),G0tensor(787))
  call TI_triangle_red(G1tensor(375),RedBasis(32),mass3set(:,16),G0tensor(788),G0tensor(789),G0tensor(790), &
    G0tensor(791),M2L1R1,[nMZ],G0tensor(792))
  call TI_triangle_red(G1tensor(61),RedBasis(32),mass3set(:,45),G0tensor(793),G0tensor(794),G0tensor(795), &
    G0tensor(796),M2L1R1,[nMZ],G0tensor(797))
  call TI_triangle_red(G1tensor(423),RedBasis(48),mass3set(:,46),G0tensor(798),G0tensor(799),G0tensor(800), &
    G0tensor(801),M2L1R1,[nMB,nMW],G0tensor(802),G0tensor(803))
  call TI_triangle_red(G1tensor(359),RedBasis(42),mass3set(:,47),G0tensor(804),G0tensor(805),G0tensor(806), &
    G0tensor(807),M2L1R1,[nMW,nMB],G0tensor(808),G0tensor(809))
  call TI_triangle_red(G1tensor(374),RedBasis(43),mass3set(:,40),G0tensor(810),G0tensor(811),G0tensor(812), &
    G0tensor(813),M2L1R1,[nMT],G0tensor(814))
  call TI_triangle_red(G1tensor(379),RedBasis(43),mass3set(:,41),G0tensor(815),G0tensor(816),G0tensor(817), &
    G0tensor(818),M2L1R1,[nMZ,nMT],G0tensor(819),G0tensor(820))
  call TI_triangle_red(G1tensor(404),RedBasis(45),mass3set(:,29),G0tensor(821),G0tensor(822),G0tensor(823), &
    G0tensor(824),M2L1R1,[nMT],G0tensor(825))
  call TI_triangle_red(G1tensor(395),RedBasis(44),mass3set(:,29),G0tensor(826),G0tensor(827),G0tensor(828), &
    G0tensor(829),M2L1R1,[nMT],G0tensor(830))
  call TI_triangle_red(G1tensor(414),RedBasis(45),mass3set(:,33),G0tensor(831),G0tensor(832),G0tensor(833), &
    G0tensor(834),M2L1R1,[nMT,nMZ],G0tensor(835),G0tensor(836))
  call TI_triangle_red(G1tensor(400),RedBasis(44),mass3set(:,33),G0tensor(837),G0tensor(838),G0tensor(839), &
    G0tensor(840),M2L1R1,[nMT,nMZ],G0tensor(841),G0tensor(842))
  call TI_triangle_red(G1tensor(409),RedBasis(45),mass3set(:,42),G0tensor(843),G0tensor(844),G0tensor(845), &
    G0tensor(846),M2L1R1,[nMT,nMZ],G0tensor(847),G0tensor(848))
  call TI_triangle_red(G1tensor(419),RedBasis(45),mass3set(:,50),G0tensor(849),G0tensor(850),G0tensor(851), &
    G0tensor(852),M2L1R1,[nMT,nMZ],G0tensor(853),G0tensor(854))
  call TI_triangle_red(G1tensor(410),RedBasis(47),mass3set(:,29),G0tensor(855),G0tensor(856),G0tensor(857), &
    G0tensor(858),M2L1R1,[nMT],G0tensor(859))
  call TI_triangle_red(G1tensor(420),RedBasis(47),mass3set(:,33),G0tensor(860),G0tensor(861),G0tensor(862), &
    G0tensor(863),M2L1R1,[nMT,nMZ],G0tensor(864),G0tensor(865))
  call TI_triangle_red(G1tensor(425),RedBasis(47),mass3set(:,38),G0tensor(866),G0tensor(867),G0tensor(868), &
    G0tensor(869),M2L1R1,[nMB,nMW],G0tensor(870),G0tensor(871))
  call ol_merge_tensors(T0sum(101),[G0tensor(1)])
  call ol_merge_tensors(T0sum(102),[G0tensor(31)])
  call ol_merge_tensors(T0sum(103),[G0tensor(61)])
  call ol_merge_tensors(T0sum(104),[G0tensor(86)])
  call ol_merge_tensors(T0sum(105),[G0tensor(111)])
  call ol_merge_tensors(T0sum(106),[G0tensor(141)])
  call ol_merge_tensors(T0sum(107),[G0tensor(166)])
  call ol_merge_tensors(T0sum(108),[G0tensor(196)])
  call ol_merge_tensors(T0sum(109),[G0tensor(226)])
  call ol_merge_tensors(T0sum(110),[G0tensor(251)])
  call ol_merge_tensors(T0sum(111),[G0tensor(276)])
  call ol_merge_tensors(T0sum(112),[G0tensor(306)])
  call ol_merge_tensors(T0sum(113),[G0tensor(336)])
  call ol_merge_tensors(T0sum(114),[G0tensor(366)])
  call ol_merge_tensors(T0sum(115),[G0tensor(391)])
  call ol_merge_tensors(T0sum(116),[G0tensor(426)])
  call ol_merge_tensors(T0sum(117),[G0tensor(456)])
  call ol_merge_tensors(T0sum(118),[G0tensor(491)])
  call ol_merge_tensors(T0sum(119),[G0tensor(327)])
  call ol_merge_tensors(T0sum(120),[G0tensor(140)])
  call ol_merge_tensors(T0sum(121),[G0tensor(450)])
  call ol_merge_tensors(T0sum(122),[G0tensor(437)])
  call ol_merge_tensors(T0sum(123),[G0tensor(452)])
  call ol_merge_tensors(T0sum(124),[G0tensor(467)])
  call ol_merge_tensors(T0sum(125),[G0tensor(50)])
  call ol_merge_tensors(T0sum(126),[G0tensor(142)])
  call ol_merge_tensors(T0sum(127),[G0tensor(110)])
  call ol_merge_tensors(T0sum(128),[G0tensor(275)])
  call ol_merge_tensors(T0sum(129),[G0tensor(382)])
  call ol_merge_tensors(T0sum(130),[G0tensor(144)])
  call ol_merge_tensors(T0sum(131),[G0tensor(149)])
  call ol_merge_tensors(T0sum(132),[G0tensor(158)])
  call ol_merge_tensors(T0sum(133),[G0tensor(334)])
  call ol_merge_tensors(T0sum(134),[G0tensor(204)])
  call ol_merge_tensors(T0sum(135),[G0tensor(495)])
  call ol_merge_tensors(T0sum(136),[G0tensor(184)])
  call ol_merge_tensors(T0sum(137),[G0tensor(229)])
  call ol_merge_tensors(T0sum(138),[G0tensor(239)])
  call ol_merge_tensors(T0sum(139),[G0tensor(258)])
  call ol_merge_tensors(T0sum(140),[G0tensor(284)])
  call ol_merge_tensors(T0sum(141),[G0tensor(269)])
  call ol_merge_tensors(T0sum(142),[G0tensor(329)])
  call ol_merge_tensors(T0sum(143),[G0tensor(337)])
  call ol_merge_tensors(T0sum(144),[G0tensor(340)])
  call ol_merge_tensors(T0sum(145),[G0tensor(408)])
  call ol_merge_tensors(T0sum(146),[G0tensor(380)])
  call ol_merge_tensors(T0sum(147),[G0tensor(359)])
  call ol_merge_tensors(T0sum(148),[G0tensor(369)])
  call ol_merge_tensors(T0sum(149),[G0tensor(414)])
  call ol_merge_tensors(T0sum(150),[G0tensor(419)])
  call ol_merge_tensors(T0sum(151),[G0tensor(415)])
  call ol_merge_tensors(T0sum(152),[G0tensor(433)])
  call ol_merge_tensors(T0sum(153),[G0tensor(444)])
  call ol_merge_tensors(T0sum(154),[G0tensor(463)])
  call ol_merge_tensors(T0sum(155),[G0tensor(484)])
  call ol_merge_tensors(T0sum(156),[G0tensor(498)])
  call ol_merge_tensors(T0sum(157),[G0tensor(505)])
  call ol_merge_tensors(T0sum(158),[G0tensor(511)])
  call ol_merge_tensors(T0sum(159),[G0tensor(517)])
  call ol_merge_tensors(T0sum(160),[G0tensor(522)])
  call ol_merge_tensors(T0sum(161),[G0tensor(527)])
  call ol_merge_tensors(T0sum(162),[G0tensor(532)])
  call ol_merge_tensors(T0sum(163),[G0tensor(2)])
  call ol_merge_tensors(T0sum(164),[G0tensor(537)])
  call ol_merge_tensors(T0sum(165),[G0tensor(542)])
  call ol_merge_tensors(T0sum(166),[G0tensor(547)])
  call ol_merge_tensors(T0sum(167),[G0tensor(553)])
  call ol_merge_tensors(T0sum(168),[G0tensor(559)])
  call ol_merge_tensors(T0sum(169),[G0tensor(564)])
  call ol_merge_tensors(T0sum(170),[G0tensor(570)])
  call ol_merge_tensors(T0sum(171),[G0tensor(576)])
  call ol_merge_tensors(T0sum(172),[G0tensor(581)])
  call ol_merge_tensors(T0sum(173),[G0tensor(587)])
  call ol_merge_tensors(T0sum(174),[G0tensor(593)])
  call ol_merge_tensors(T0sum(175),[G0tensor(598)])
  call ol_merge_tensors(T0sum(176),[G0tensor(603)])
  call ol_merge_tensors(T0sum(177),[G0tensor(608)])
  call ol_merge_tensors(T0sum(178),[G0tensor(613)])
  call ol_merge_tensors(T0sum(179),[G0tensor(618)])
  call ol_merge_tensors(T0sum(180),[G0tensor(623)])
  call ol_merge_tensors(T0sum(181),[G0tensor(629)])
  call ol_merge_tensors(T0sum(182),[G0tensor(635)])
  call ol_merge_tensors(T0sum(183),[G0tensor(641)])
  call ol_merge_tensors(T0sum(184),[G0tensor(647)])
  call ol_merge_tensors(T0sum(185),[G0tensor(653)])
  call ol_merge_tensors(T0sum(186),[G0tensor(659)])
  call ol_merge_tensors(T0sum(187),[G0tensor(665)])
  call ol_merge_tensors(T0sum(188),[G0tensor(671)])
  call ol_merge_tensors(T0sum(189),[G0tensor(677)])
  call ol_merge_tensors(T0sum(190),[G0tensor(683)])
  call ol_merge_tensors(T0sum(191),[G0tensor(688)])
  call ol_merge_tensors(T0sum(192),[G0tensor(693)])
  call ol_merge_tensors(T0sum(193),[G0tensor(152)])
  call ol_merge_tensors(T0sum(194),[G0tensor(698)])
  call ol_merge_tensors(T0sum(195),[G0tensor(704)])
  call ol_merge_tensors(T0sum(196),[G0tensor(8)])
  call ol_merge_tensors(T0sum(197),[G0tensor(710)])
  call ol_merge_tensors(T0sum(198),[G0tensor(716)])
  call ol_merge_tensors(T0sum(199),[G0tensor(155)])
  call ol_merge_tensors(T0sum(200),[G0tensor(162)])
  call ol_merge_tensors(T0sum(201),[G0tensor(722)])
  call ol_merge_tensors(T0sum(202),[G0tensor(727)])
  call ol_merge_tensors(T0sum(203),[G0tensor(731)])
  call ol_merge_tensors(T0sum(204),[G0tensor(735)])
  call ol_merge_tensors(T0sum(205),[G0tensor(741)])
  call ol_merge_tensors(T0sum(206),[G0tensor(746)])
  call ol_merge_tensors(T0sum(207),[G0tensor(751)])
  call ol_merge_tensors(T0sum(208),[G0tensor(756)])
  call ol_merge_tensors(T0sum(209),[G0tensor(27)])
  call ol_merge_tensors(T0sum(210),[G0tensor(18)])
  call ol_merge_tensors(T0sum(211),[G0tensor(175)])
  call ol_merge_tensors(T0sum(212),[G0tensor(761)])
  call ol_merge_tensors(T0sum(213),[G0tensor(766)])
  call ol_merge_tensors(T0sum(214),[G0tensor(30)])
  call ol_merge_tensors(T0sum(215),[G0tensor(771)])
  call ol_merge_tensors(T0sum(216),[G0tensor(777)])
  call ol_merge_tensors(T0sum(217),[G0tensor(782)])
  call ol_merge_tensors(T0sum(218),[G0tensor(788)])
  call ol_merge_tensors(T0sum(219),[G0tensor(793)])
  call ol_merge_tensors(T0sum(220),[G0tensor(798)])
  call ol_merge_tensors(T0sum(221),[G0tensor(52)])
  call ol_merge_tensors(T0sum(222),[G0tensor(804)])
  call ol_merge_tensors(T0sum(223),[G0tensor(210)])
  call ol_merge_tensors(T0sum(224),[G0tensor(810)])
  call ol_merge_tensors(T0sum(225),[G0tensor(815)])
  call ol_merge_tensors(T0sum(226),[G0tensor(821)])
  call ol_merge_tensors(T0sum(227),[G0tensor(826)])
  call ol_merge_tensors(T0sum(228),[G0tensor(831)])
  call ol_merge_tensors(T0sum(229),[G0tensor(837)])
  call ol_merge_tensors(T0sum(230),[G0tensor(843)])
  call ol_merge_tensors(T0sum(231),[G0tensor(849)])
  call ol_merge_tensors(T0sum(232),[G0tensor(855)])
  call ol_merge_tensors(T0sum(233),[G0tensor(860)])
  call ol_merge_tensors(T0sum(234),[G0tensor(49)])
  call ol_merge_tensors(T0sum(235),[G0tensor(57)])
  call ol_merge_tensors(T0sum(236),[G0tensor(866)])
  call ol_merge_tensors(T0sum(237),[G0tensor(220)])
  call ol_merge_tensors(T0sum(238),[G0tensor(212)])
  call ol_merge_tensors(T0sum(239),[G0tensor(323)])
  call ol_merge_tensors(T0sum(240),[G0tensor(227)])
  call ol_merge_tensors(T0sum(241),[G0tensor(388)])
  call ol_merge_tensors(T0sum(242),[G0tensor(237)])
  call ol_merge_tensors(T0sum(243),[G0tensor(247)])
  call ol_merge_tensors(T0sum(244),[G0tensor(78)])
  call ol_merge_tensors(T0sum(245),[G0tensor(343)])
  call ol_merge_tensors(T0sum(246),[G0tensor(262)])
  call ol_merge_tensors(T0sum(247),[G0tensor(92)])
  call ol_merge_tensors(T0sum(248),[G0tensor(120)])
  call ol_merge_tensors(T0sum(249),[G0tensor(277)])
  call ol_merge_tensors(T0sum(250),[G0tensor(203)])
  call ol_merge_tensors(T0sum(251),[G0tensor(287)])
  call ol_merge_tensors(T0sum(252),[G0tensor(104)])
  call ol_merge_tensors(T0sum(253),[G0tensor(295)])
  call ol_merge_tensors(T0sum(254),[G0tensor(113)])
  call ol_merge_tensors(T0sum(255),[G0tensor(213)])
  call ol_merge_tensors(T0sum(256),[G0tensor(373)])
  call ol_merge_tensors(T0sum(257),[G0tensor(312)])
  call ol_merge_tensors(T0sum(258),[G0tensor(133)])
  call ol_merge_tensors(T0sum(259),[G0tensor(367)])
  Gcoeff(:)%j = (-(c(27)*M(2,:)%j)) * den(27)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(279),h0tab(:,279),[20,11],[nMH,nMT],2,2,wf4(:,3),wf8(:,28))
  call Hloop_AQ_S(ntryL,G0H32(1),wf4(:,3),G0H8(37),ngH,m3h4x8(:,105),heltab2x32(:,:,279))
  Gcoeff(:)%j = (c(27)*M(2,:)%j) * den(27)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(280),h0tab(:,280),[20,11],[nMZ,nMT],2,2,wf4(:,3),wf8(:,28))
  call Hloop_AQ_S(ntryL,G0H32(1),wf4(:,3),G0H8(7),ngX,m3h4x8(:,106),heltab2x32(:,:,280))
  Gcoeff(:)%j = (c(23)*M(2,:)%j) * den(27)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(281),h0tab(:,281),[20,11],[nMW,nMB],2,2,wf4(:,3),wf8(:,28))
  call Hloop_AQ_S(ntryL,G0H32(1),wf4(:,3),G0H8(8),ngPbt,m3h4x8(:,107),heltab2x32(:,:,281))
  Gcoeff(:)%j = (-(c(28)*M(2,:)%j)) * den(29)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(282),h0tab(:,282),[20,11],[nMH,nMT],2,2,wf4(:,3),wf8(:,29))
  call Hloop_AQ_S(ntryL,G0H32(1),wf4(:,3),G0H8(9),ngH,m3h4x8(:,108),heltab2x32(:,:,282))
  Gcoeff(:)%j = (c(28)*M(2,:)%j) * den(29)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(283),h0tab(:,283),[20,11],[nMZ,nMT],2,2,wf4(:,3),wf8(:,29))
  call Hloop_AQ_S(ntryL,G0H32(1),wf4(:,3),G0H8(10),ngX,m3h4x8(:,109),heltab2x32(:,:,283))
  Gcoeff(:)%j = (c(25)*M(2,:)%j) * den(29)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(284),h0tab(:,284),[20,11],[nMW,nMB],2,2,wf4(:,3),wf8(:,29))
  call Hloop_AQ_S(ntryL,G0H32(1),wf4(:,3),G0H8(17),ngPbt,m3h4x8(:,110),heltab2x32(:,:,284))
  Gcoeff(:)%j = (c(1)*M(2,:)%j) * den(27)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(285),h0tab(:,285),[20,11],[0,nMT],2,2,wf4(:,3),wf8(:,28))
  call Hloop_AQ_V(ntryL,G0H32(1),wf4(:,3),G0H8(18),m3h4x8(:,111),heltab2x32(:,:,285))
  Gcoeff(:)%j = (c(2)*M(2,:)%j) * den(27)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(286),h0tab(:,286),[20,11],[nMZ,nMT],2,2,wf4(:,3),wf8(:,28))
  call Hloop_AQ_Z(ntryL,G0H32(1),wf4(:,3),G0H8(1),ngZu,m3h4x8(:,112),heltab2x32(:,:,286))
  Gcoeff(:)%j = (c(14)*M(2,:)%j) * den(27)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(287),h0tab(:,287),[20,11],[nMW,nMB],2,2,wf4(:,3),wf8(:,28))
  call Hloop_AQ_W(ntryL,G0H32(1),wf4(:,3),G0H8(2),m3h4x8(:,113),heltab2x32(:,:,287))
  Gcoeff(:)%j = (c(2)*M(2,:)%j) * den(29)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(288),h0tab(:,288),[20,11],[0,nMT],2,2,wf4(:,3),wf8(:,29))
  call Hloop_AQ_V(ntryL,G0H32(1),wf4(:,3),G0H8(3),m3h4x8(:,114),heltab2x32(:,:,288))
  Gcoeff(:)%j = (c(3)*M(2,:)%j) * den(29)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(289),h0tab(:,289),[20,11],[nMZ,nMT],2,2,wf4(:,3),wf8(:,29))
  call Hloop_AQ_Z(ntryL,G0H32(1),wf4(:,3),G0H8(4),ngZu,m3h4x8(:,115),heltab2x32(:,:,289))
  Gcoeff(:)%j = (c(16)*M(2,:)%j) * den(29)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(290),h0tab(:,290),[20,11],[nMW,nMB],2,2,wf4(:,3),wf8(:,29))
  call Hloop_AQ_W(ntryL,G0H32(1),wf4(:,3),G0H8(5),m3h4x8(:,116),heltab2x32(:,:,290))
  Gcoeff(:)%j = (-(c(54)*M(2,:)%j)) * den(71)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(291),h0tab(:,291),[28,3],[nME,nME],2,2,wf8(:,43),wf4(:,1))
  call Hloop_QS_A(ntryL,G0H32(1),wf8(:,43),G0H4(17),ngH,m3h8x4(:,69),heltab2x32(:,:,291))
  call Hloop_Q_A(ntryL,G0H4(17),28,nME,G1H4(51),n2h4(121))
  Gcoeff(:)%j = (-(c(58)*M(2,:)%j)) * den(71)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(292),h0tab(:,292),[28,3],[nMM,nMM],2,2,wf8(:,43),wf4(:,1))
  call Hloop_QS_A(ntryL,G0H32(1),wf8(:,43),G0H4(7),ngH,m3h8x4(:,70),heltab2x32(:,:,292))
  call Hloop_Q_A(ntryL,G0H4(7),28,nMM,G1H4(25),n2h4(122))
  Gcoeff(:)%j = (-(c(56)*M(2,:)%j)) * den(71)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(293),h0tab(:,293),[28,3],[nML,nML],2,2,wf8(:,43),wf4(:,1))
  call Hloop_QS_A(ntryL,G0H32(1),wf8(:,43),G0H4(3),ngH,m3h8x4(:,71),heltab2x32(:,:,293))
  call Hloop_Q_A(ntryL,G0H4(3),28,nML,G1H4(20),n2h4(123))
  Gcoeff(:)%j = (c(60)*M(2,:)%j) * den(71)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(294),h0tab(:,294),[28,3],[nMT,nMT],2,2,wf8(:,43),wf4(:,1))
  call Hloop_QS_A(ntryL,G0H32(1),wf8(:,43),G0H4(1),ngH,m3h8x4(:,72),heltab2x32(:,:,294))
  call Hloop_Q_A(ntryL,G0H4(1),28,nMT,G1H4(57),n2h4(124))
  Gcoeff(:)%j = (-(c(52)*M(2,:)%j)) * den(71)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(295),h0tab(:,295),[28,3],[nMB,nMB],2,2,wf8(:,43),wf4(:,1))
  call Hloop_QS_A(ntryL,G0H32(1),wf8(:,43),G0H4(2),ngH,m3h8x4(:,73),heltab2x32(:,:,295))
  call Hloop_Q_A(ntryL,G0H4(2),28,nMB,G1H4(29),n2h4(125))
  Gcoeff(:)%j = (-(c(54)*M(2,:)%j)) * den(19)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(296),h0tab(:,296),[28,3],[nME,nME],2,2,wf8(:,25),wf4(:,1))
  call Hloop_QS_A(ntryL,G0H32(1),wf8(:,25),G0H4(10),ngX,m3h8x4(:,74),heltab2x32(:,:,296))
  call Hloop_Q_A(ntryL,G0H4(10),28,nME,G1H4(26),n2h4(126))
  Gcoeff(:)%j = (-(c(58)*M(2,:)%j)) * den(19)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(297),h0tab(:,297),[28,3],[nMM,nMM],2,2,wf8(:,25),wf4(:,1))
  call Hloop_QS_A(ntryL,G0H32(1),wf8(:,25),G0H4(6),ngX,m3h8x4(:,75),heltab2x32(:,:,297))
  call Hloop_Q_A(ntryL,G0H4(6),28,nMM,G1H4(75),n2h4(127))
  Gcoeff(:)%j = (-(c(56)*M(2,:)%j)) * den(19)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(298),h0tab(:,298),[28,3],[nML,nML],2,2,wf8(:,25),wf4(:,1))
  call Hloop_QS_A(ntryL,G0H32(1),wf8(:,25),G0H4(4),ngX,m3h8x4(:,76),heltab2x32(:,:,298))
  call Hloop_Q_A(ntryL,G0H4(4),28,nML,G1H4(68),n2h4(128))
  Gcoeff(:)%j = (-(c(60)*M(2,:)%j)) * den(19)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(299),h0tab(:,299),[28,3],[nMT,nMT],2,2,wf8(:,25),wf4(:,1))
  call Hloop_QS_A(ntryL,G0H32(1),wf8(:,25),G0H4(5),ngX,m3h8x4(:,77),heltab2x32(:,:,299))
  call Hloop_Q_A(ntryL,G0H4(5),28,nMT,G1H4(67),n2h4(129))
  Gcoeff(:)%j = (-(c(52)*M(2,:)%j)) * den(19)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(300),h0tab(:,300),[28,3],[nMB,nMB],2,2,wf8(:,25),wf4(:,1))
  call Hloop_QS_A(ntryL,G0H32(1),wf8(:,25),G0H4(13),ngX,m3h8x4(:,78),heltab2x32(:,:,300))
  call Hloop_Q_A(ntryL,G0H4(13),28,nMB,G1H4(69),n2h4(130))
  Gcoeff(:)%j = (c(55)*M(2,:)%j) * den(72)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(301),h0tab(:,301),[28,3],[nME,nME],2,2,wf8(:,43),wf4(:,4))
  call Hloop_QS_A(ntryL,G0H32(1),wf8(:,43),G0H4(16),ngH,m3h8x4(:,79),heltab2x32(:,:,301))
  call Hloop_Q_A(ntryL,G0H4(16),28,nME,G1H4(64),n2h4(131))
  Gcoeff(:)%j = (c(59)*M(2,:)%j) * den(72)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(302),h0tab(:,302),[28,3],[nMM,nMM],2,2,wf8(:,43),wf4(:,4))
  call Hloop_QS_A(ntryL,G0H32(1),wf8(:,43),G0H4(14),ngH,m3h8x4(:,80),heltab2x32(:,:,302))
  call Hloop_Q_A(ntryL,G0H4(14),28,nMM,G1H4(61),n2h4(132))
  Gcoeff(:)%j = (c(57)*M(2,:)%j) * den(72)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(303),h0tab(:,303),[28,3],[nML,nML],2,2,wf8(:,43),wf4(:,4))
  call Hloop_QS_A(ntryL,G0H32(1),wf8(:,43),G0H4(9),ngH,m3h8x4(:,81),heltab2x32(:,:,303))
  call Hloop_Q_A(ntryL,G0H4(9),28,nML,G1H4(70),n2h4(133))
  Gcoeff(:)%j = (c(61)*M(2,:)%j) * den(72)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(304),h0tab(:,304),[28,3],[nMT,nMT],2,2,wf8(:,43),wf4(:,4))
  call Hloop_QS_A(ntryL,G0H32(1),wf8(:,43),G0H4(8),ngH,m3h8x4(:,82),heltab2x32(:,:,304))
  call Hloop_Q_A(ntryL,G0H4(8),28,nMT,G1H4(65),n2h4(134))
  Gcoeff(:)%j = (c(53)*M(2,:)%j) * den(72)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(305),h0tab(:,305),[28,3],[nMB,nMB],2,2,wf8(:,43),wf4(:,4))
  call Hloop_QS_A(ntryL,G0H32(1),wf8(:,43),G0H4(12),ngH,m3h8x4(:,83),heltab2x32(:,:,305))
  call Hloop_Q_A(ntryL,G0H4(12),28,nMB,G1H4(62),n2h4(135))
  Gcoeff(:)%j = (c(55)*M(2,:)%j) * den(20)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(306),h0tab(:,306),[28,3],[nME,nME],2,2,wf8(:,25),wf4(:,4))
  call Hloop_QS_A(ntryL,G0H32(1),wf8(:,25),G0H4(11),ngX,m3h8x4(:,84),heltab2x32(:,:,306))
  call Hloop_Q_A(ntryL,G0H4(11),28,nME,G1H4(71),n2h4(136))
  Gcoeff(:)%j = (c(59)*M(2,:)%j) * den(20)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(307),h0tab(:,307),[28,3],[nMM,nMM],2,2,wf8(:,25),wf4(:,4))
  call Hloop_QS_A(ntryL,G0H32(1),wf8(:,25),G0H4(15),ngX,m3h8x4(:,85),heltab2x32(:,:,307))
  call Hloop_Q_A(ntryL,G0H4(15),28,nMM,G1H4(66),n2h4(137))
  Gcoeff(:)%j = (c(57)*M(2,:)%j) * den(20)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(308),h0tab(:,308),[28,3],[nML,nML],2,2,wf8(:,25),wf4(:,4))
  call Hloop_QS_A(ntryL,G0H32(1),wf8(:,25),G0H4(17),ngX,m3h8x4(:,86),heltab2x32(:,:,308))
  call Hloop_Q_A(ntryL,G0H4(17),28,nML,G1H4(63),n2h4(138))
  Gcoeff(:)%j = (-(c(61)*M(2,:)%j)) * den(20)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(309),h0tab(:,309),[28,3],[nMT,nMT],2,2,wf8(:,25),wf4(:,4))
  call Hloop_QS_A(ntryL,G0H32(1),wf8(:,25),G0H4(7),ngX,m3h8x4(:,87),heltab2x32(:,:,309))
  call Hloop_Q_A(ntryL,G0H4(7),28,nMT,G1H4(35),n2h4(139))
  Gcoeff(:)%j = (c(53)*M(2,:)%j) * den(20)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(310),h0tab(:,310),[28,3],[nMB,nMB],2,2,wf8(:,25),wf4(:,4))
  call Hloop_QS_A(ntryL,G0H32(1),wf8(:,25),G0H4(3),ngX,m3h8x4(:,88),heltab2x32(:,:,310))
  call Hloop_Q_A(ntryL,G0H4(3),28,nMB,G1H4(36),n2h4(140))
  Gcoeff(:)%j = (-(c(26)*M(2,:)%j)) * den(71)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(311),h0tab(:,311),[28,3],[nMW,nMW],2,2,wf8(:,43),wf4(:,1))
  call Hloop_SS_S(ntryL,G0H32(1),wf8(:,43),G0H4(1),m3h8x4(:,89),heltab2x32(:,:,311))
  Gcoeff(:)%j = (c(36)*M(2,:)%j) * den(72)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(312),h0tab(:,312),[28,3],[nMW,nMW],2,2,wf8(:,43),wf4(:,4))
  call Hloop_SS_S(ntryL,G0H32(1),wf8(:,43),G0H4(2),m3h8x4(:,90),heltab2x32(:,:,312))
  Gcoeff(:)%j = (-(c(11)*M(2,:)%j)) * den(20)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(313),h0tab(:,313),[28,3],[nMH,nMZ],2,2,wf8(:,25),wf4(:,4))
  call Hloop_SS_S(ntryL,G0H32(1),wf8(:,25),G0H4(10),m3h8x4(:,91),heltab2x32(:,:,313))
  Gcoeff(:)%j = (-(c(19)*M(2,:)%j)) * den(71)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(314),h0tab(:,314),[28,3],[nMW,nMW],2,2,wf8(:,43),wf4(:,1))
  call Hloop_SS_S(ntryL,G0H32(1),wf8(:,43),G0H4(6),m3h8x4(:,92),heltab2x32(:,:,314))
  Gcoeff(:)%j = (c(19)*M(2,:)%j) * den(71)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(315),h0tab(:,315),[28,3],[nMW,nMW],2,2,wf8(:,43),wf4(:,1))
  call Hloop_SS_S(ntryL,G0H32(1),wf8(:,43),G0H4(4),m3h8x4(:,93),heltab2x32(:,:,315))
  Gcoeff(:)%j = (-(c(19)*M(2,:)%j)) * den(19)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(316),h0tab(:,316),[28,3],[nMW,nMW],2,2,wf8(:,25),wf4(:,1))
  call Hloop_SS_S(ntryL,G0H32(1),wf8(:,25),G0H4(5),m3h8x4(:,94),heltab2x32(:,:,316))
  Gcoeff(:)%j = (-(c(19)*M(2,:)%j)) * den(19)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(317),h0tab(:,317),[28,3],[nMW,nMW],2,2,wf8(:,25),wf4(:,1))
  call Hloop_SS_S(ntryL,G0H32(1),wf8(:,25),G0H4(13),m3h8x4(:,95),heltab2x32(:,:,317))
  Gcoeff(:)%j = (-(c(9)*M(2,:)%j)) * den(72)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(318),h0tab(:,318),[28,3],[nMW,nMW],2,2,wf8(:,43),wf4(:,4))
  call Hloop_SS_S(ntryL,G0H32(1),wf8(:,43),G0H4(16),m3h8x4(:,96),heltab2x32(:,:,318))
  Gcoeff(:)%j = (c(9)*M(2,:)%j) * den(72)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(319),h0tab(:,319),[28,3],[nMW,nMW],2,2,wf8(:,43),wf4(:,4))
  call Hloop_SS_S(ntryL,G0H32(1),wf8(:,43),G0H4(14),m3h8x4(:,97),heltab2x32(:,:,319))
  Gcoeff(:)%j = (-(c(9)*M(2,:)%j)) * den(20)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(320),h0tab(:,320),[28,3],[nMW,nMW],2,2,wf8(:,25),wf4(:,4))
  call Hloop_SS_S(ntryL,G0H32(1),wf8(:,25),G0H4(9),m3h8x4(:,98),heltab2x32(:,:,320))
  Gcoeff(:)%j = (-(c(9)*M(2,:)%j)) * den(20)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(321),h0tab(:,321),[28,3],[nMW,nMW],2,2,wf8(:,25),wf4(:,4))
  call Hloop_SS_S(ntryL,G0H32(1),wf8(:,25),G0H4(8),m3h8x4(:,99),heltab2x32(:,:,321))
  Gcoeff(:)%j = (-(c(20)*M(2,:)%j)) * den(71)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(322),h0tab(:,322),[28,3],[nMW,nMW],2,2,wf8(:,43),wf4(:,1))
  call Hloop_VS_V(ntryL,G0H32(1),wf8(:,43),G0H4(12),m3h8x4(:,100),heltab2x32(:,:,322))
  Gcoeff(:)%j = (-(c(10)*M(2,:)%j)) * den(72)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(323),h0tab(:,323),[28,3],[nMW,nMW],2,2,wf8(:,43),wf4(:,4))
  call Hloop_VS_V(ntryL,G0H32(1),wf8(:,43),G0H4(11),m3h8x4(:,101),heltab2x32(:,:,323))
  Gcoeff(:)%j = (-(c(19)*M(2,:)%j)) * den(71)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(324),h0tab(:,324),[28,3],[nMW,nMW],2,2,wf8(:,43),wf4(:,1))
  call Hloop_VT_S(ntryL,G0H32(1),0,wf8(:,43),28,G1H4(40),m3h8x4(:,102),heltab2x32(:,:,324))
  Gcoeff(:)%j = (c(19)*M(2,:)%j) * den(71)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(325),h0tab(:,325),[28,3],[nMW,nMW],2,2,wf8(:,43),wf4(:,1))
  call Hloop_VT_S(ntryL,G0H32(1),0,wf8(:,43),28,G1H4(46),m3h8x4(:,103),heltab2x32(:,:,325))
  Gcoeff(:)%j = (-(c(19)*M(2,:)%j)) * den(19)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(326),h0tab(:,326),[28,3],[nMW,nMW],2,2,wf8(:,25),wf4(:,1))
  call Hloop_VT_S(ntryL,G0H32(1),0,wf8(:,25),28,G1H4(42),m3h8x4(:,104),heltab2x32(:,:,326))
  Gcoeff(:)%j = (-(c(19)*M(2,:)%j)) * den(19)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(327),h0tab(:,327),[28,3],[nMW,nMW],2,2,wf8(:,25),wf4(:,1))
  call Hloop_VT_S(ntryL,G0H32(1),0,wf8(:,25),28,G1H4(45),m3h8x4(:,105),heltab2x32(:,:,327))
  Gcoeff(:)%j = (c(32)*M(2,:)%j) * den(72)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(328),h0tab(:,328),[28,3],[nMW,nMW],2,2,wf8(:,43),wf4(:,4))
  call Hloop_VT_S(ntryL,G0H32(1),0,wf8(:,43),28,G1H4(52),m3h8x4(:,106),heltab2x32(:,:,328))
  Gcoeff(:)%j = (-(c(32)*M(2,:)%j)) * den(72)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(329),h0tab(:,329),[28,3],[nMW,nMW],2,2,wf8(:,43),wf4(:,4))
  call Hloop_VT_S(ntryL,G0H32(1),0,wf8(:,43),28,G1H4(55),m3h8x4(:,107),heltab2x32(:,:,329))
  Gcoeff(:)%j = (-(c(8)*M(2,:)%j)) * den(20)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(330),h0tab(:,330),[28,3],[nMH,nMZ],2,2,wf8(:,25),wf4(:,4))
  call Hloop_VS_T(ntryL,G0H32(1),0,wf8(:,25),28,G1H4(56),m3h8x4(:,108),heltab2x32(:,:,330))
  Gcoeff(:)%j = (c(32)*M(2,:)%j) * den(20)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(331),h0tab(:,331),[28,3],[nMW,nMW],2,2,wf8(:,25),wf4(:,4))
  call Hloop_VT_S(ntryL,G0H32(1),0,wf8(:,25),28,G1H4(60),m3h8x4(:,109),heltab2x32(:,:,331))
  Gcoeff(:)%j = (c(32)*M(2,:)%j) * den(20)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(332),h0tab(:,332),[28,3],[nMW,nMW],2,2,wf8(:,25),wf4(:,4))
  call Hloop_VT_S(ntryL,G0H32(1),0,wf8(:,25),28,G1H4(76),m3h8x4(:,110),heltab2x32(:,:,332))
  Gcoeff(:)%j = (-(c(44)*M(2,:)%j)) * den(23)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(333),h0tab(:,333),[28,3],[nME,nME],2,2,wf8(:,26),wf4(:,1))
  call Hloop_QV_A(ntryL,G0H32(1),wf8(:,26),G0H4(15),m3h8x4(:,111),heltab2x32(:,:,333))
  call Hloop_Q_A(ntryL,G0H4(15),28,nME,G1H4(72),n2h4(141))
  Gcoeff(:)%j = (-(c(44)*M(2,:)%j)) * den(23)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(334),h0tab(:,334),[28,3],[nMM,nMM],2,2,wf8(:,26),wf4(:,1))
  call Hloop_QV_A(ntryL,G0H32(1),wf8(:,26),G0H4(17),m3h8x4(:,112),heltab2x32(:,:,334))
  call Hloop_Q_A(ntryL,G0H4(17),28,nMM,G1H4(73),n2h4(142))
  Gcoeff(:)%j = (-(c(44)*M(2,:)%j)) * den(23)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(335),h0tab(:,335),[28,3],[nML,nML],2,2,wf8(:,26),wf4(:,1))
  call Hloop_QV_A(ntryL,G0H32(1),wf8(:,26),G0H4(7),m3h8x4(:,113),heltab2x32(:,:,335))
  call Hloop_Q_A(ntryL,G0H4(7),28,nML,G1H4(74),n2h4(143))
  Gcoeff(:)%j = (-(c(43)*M(2,:)%j)) * den(23)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(336),h0tab(:,336),[28,3],[0,0],2,2,wf8(:,26),wf4(:,1))
  call Hloop_QV_A(ntryL,G0H32(1),wf8(:,26),G0H4(3),m3h8x4(:,114),heltab2x32(:,:,336))
  call Hloop_Q_A(ntryL,G0H4(3),28,0,G1H4(2),n2h4(144))
  Gcoeff(:)%j = (-(c(41)*M(2,:)%j)) * den(23)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(337),h0tab(:,337),[28,3],[nMT,nMT],2,2,wf8(:,26),wf4(:,1))
  call Hloop_QV_A(ntryL,G0H32(1),wf8(:,26),G0H4(15),m3h8x4(:,115),heltab2x32(:,:,337))
  call Hloop_Q_A(ntryL,G0H4(15),28,nMT,G1H4(8),n2h4(145))
  Gcoeff(:)%j = (-(c(40)*M(2,:)%j)) * den(23)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(338),h0tab(:,338),[28,3],[0,0],2,2,wf8(:,26),wf4(:,1))
  call Hloop_QV_A(ntryL,G0H32(1),wf8(:,26),G0H4(17),m3h8x4(:,116),heltab2x32(:,:,338))
  call Hloop_Q_A(ntryL,G0H4(17),28,0,G1H4(3),n2h4(146))
  Gcoeff(:)%j = (-(c(39)*M(2,:)%j)) * den(23)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(339),h0tab(:,339),[28,3],[nMB,nMB],2,2,wf8(:,26),wf4(:,1))
  call Hloop_QV_A(ntryL,G0H32(1),wf8(:,26),G0H4(7),m3h8x4(:,117),heltab2x32(:,:,339))
  call Hloop_Q_A(ntryL,G0H4(7),28,nMB,G1H4(7),n2h4(147))
  Gcoeff(:)%j = (c(46)*M(2,:)%j) * den(19)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(340),h0tab(:,340),[28,3],[nME,nME],2,2,wf8(:,27),wf4(:,1))
  call Hloop_QZ_A(ntryL,G0H32(1),wf8(:,27),G0H4(3),ngZl,m3h8x4(:,118),heltab2x32(:,:,340))
  call Hloop_Q_A(ntryL,G0H4(3),28,nME,G1H4(12),n2h4(148))
  Gcoeff(:)%j = (c(46)*M(2,:)%j) * den(19)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(341),h0tab(:,341),[28,3],[nMM,nMM],2,2,wf8(:,27),wf4(:,1))
  call Hloop_QZ_A(ntryL,G0H32(1),wf8(:,27),G0H4(15),ngZl,m3h8x4(:,119),heltab2x32(:,:,341))
  call Hloop_Q_A(ntryL,G0H4(15),28,nMM,G1H4(17),n2h4(149))
  Gcoeff(:)%j = (c(46)*M(2,:)%j) * den(19)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(342),h0tab(:,342),[28,3],[nML,nML],2,2,wf8(:,27),wf4(:,1))
  call Hloop_QZ_A(ntryL,G0H32(1),wf8(:,27),G0H4(17),ngZl,m3h8x4(:,120),heltab2x32(:,:,342))
  call Hloop_Q_A(ntryL,G0H4(17),28,nML,G1H4(18),n2h4(150))
  Gcoeff(:)%j = (-(c(47)*M(2,:)%j)) * den(19)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(343),h0tab(:,343),[28,3],[0,0],2,2,wf8(:,27),wf4(:,1))
  call Hloop_QZ_A(ntryL,G0H32(1),wf8(:,27),G0H4(7),ngZu,m3h8x4(:,121),heltab2x32(:,:,343))
  call Hloop_Q_A(ntryL,G0H4(7),28,0,G1H4(22),n2h4(151))
  Gcoeff(:)%j = (-(c(45)*M(2,:)%j)) * den(19)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(344),h0tab(:,344),[28,3],[nMT,nMT],2,2,wf8(:,27),wf4(:,1))
  call Hloop_QZ_A(ntryL,G0H32(1),wf8(:,27),G0H4(3),ngZu,m3h8x4(:,122),heltab2x32(:,:,344))
  call Hloop_Q_A(ntryL,G0H4(3),28,nMT,G1H4(27),n2h4(152))
  Gcoeff(:)%j = (c(45)*M(2,:)%j) * den(19)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(345),h0tab(:,345),[28,3],[0,0],2,2,wf8(:,27),wf4(:,1))
  call Hloop_QZ_A(ntryL,G0H32(1),wf8(:,27),G0H4(15),ngZd,m3h8x4(:,123),heltab2x32(:,:,345))
  call Hloop_Q_A(ntryL,G0H4(15),28,0,G1H4(32),n2h4(153))
  Gcoeff(:)%j = (c(42)*M(2,:)%j) * den(19)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(346),h0tab(:,346),[28,3],[nMB,nMB],2,2,wf8(:,27),wf4(:,1))
  call Hloop_QZ_A(ntryL,G0H32(1),wf8(:,27),G0H4(17),ngZd,m3h8x4(:,124),heltab2x32(:,:,346))
  call Hloop_Q_A(ntryL,G0H4(17),28,nMB,G1H4(39),n2h4(154))
  Gcoeff(:)%j = (c(46)*M(2,:)%j) * den(24)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(347),h0tab(:,347),[28,3],[nME,nME],2,2,wf8(:,26),wf4(:,4))
  call Hloop_QV_A(ntryL,G0H32(1),wf8(:,26),G0H4(7),m3h8x4(:,125),heltab2x32(:,:,347))
  call Hloop_Q_A(ntryL,G0H4(7),28,nME,G1H4(33),n2h4(155))
  Gcoeff(:)%j = (c(46)*M(2,:)%j) * den(24)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(348),h0tab(:,348),[28,3],[nMM,nMM],2,2,wf8(:,26),wf4(:,4))
  call Hloop_QV_A(ntryL,G0H32(1),wf8(:,26),G0H4(3),m3h8x4(:,126),heltab2x32(:,:,348))
  call Hloop_Q_A(ntryL,G0H4(3),28,nMM,G1H4(38),n2h4(156))
  Gcoeff(:)%j = (c(46)*M(2,:)%j) * den(24)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(349),h0tab(:,349),[28,3],[nML,nML],2,2,wf8(:,26),wf4(:,4))
  call Hloop_QV_A(ntryL,G0H32(1),wf8(:,26),G0H4(15),m3h8x4(:,127),heltab2x32(:,:,349))
  call Hloop_Q_A(ntryL,G0H4(15),28,nML,G1H4(43),n2h4(157))
  Gcoeff(:)%j = (-(c(47)*M(2,:)%j)) * den(24)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(350),h0tab(:,350),[28,3],[0,0],2,2,wf8(:,26),wf4(:,4))
  call Hloop_QV_A(ntryL,G0H32(1),wf8(:,26),G0H4(17),m3h8x4(:,128),heltab2x32(:,:,350))
  call Hloop_Q_A(ntryL,G0H4(17),28,0,G1H4(48),n2h4(158))
  Gcoeff(:)%j = (-(c(45)*M(2,:)%j)) * den(24)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(351),h0tab(:,351),[28,3],[nMT,nMT],2,2,wf8(:,26),wf4(:,4))
  call Hloop_QV_A(ntryL,G0H32(1),wf8(:,26),G0H4(7),m3h8x4(:,129),heltab2x32(:,:,351))
  call Hloop_Q_A(ntryL,G0H4(7),28,nMT,G1H4(49),n2h4(159))
  Gcoeff(:)%j = (c(45)*M(2,:)%j) * den(24)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(352),h0tab(:,352),[28,3],[0,0],2,2,wf8(:,26),wf4(:,4))
  call Hloop_QV_A(ntryL,G0H32(1),wf8(:,26),G0H4(3),m3h8x4(:,130),heltab2x32(:,:,352))
  call Hloop_Q_A(ntryL,G0H4(3),28,0,G1H4(53),n2h4(160))
  Gcoeff(:)%j = (c(42)*M(2,:)%j) * den(24)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(353),h0tab(:,353),[28,3],[nMB,nMB],2,2,wf8(:,26),wf4(:,4))
  call Hloop_QV_A(ntryL,G0H32(1),wf8(:,26),G0H4(15),m3h8x4(:,131),heltab2x32(:,:,353))
  call Hloop_Q_A(ntryL,G0H4(15),28,nMB,G1H4(58),n2h4(161))
  Gcoeff(:)%j = (-(c(51)*M(2,:)%j)) * den(20)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(354),h0tab(:,354),[28,3],[0,0],2,2,wf8(:,27),wf4(:,4))
  call Hloop_QZ_A(ntryL,G0H32(1),wf8(:,27),G0H4(17),ngZn,m3h8x4(:,132),heltab2x32(:,:,354))
  call Hloop_Q_A(ntryL,G0H4(17),28,0,G1H4(37),n2h4(162))
  Gcoeff(:)%j = (-(c(48)*M(2,:)%j)) * den(20)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(355),h0tab(:,355),[28,3],[nME,nME],2,2,wf8(:,27),wf4(:,4))
  call Hloop_QZ_A(ntryL,G0H32(1),wf8(:,27),G0H4(7),ngZl,m3h8x4(:,133),heltab2x32(:,:,355))
  call Hloop_Q_A(ntryL,G0H4(7),28,nME,G1H4(13),n2h4(163))
  Gcoeff(:)%j = (-(c(48)*M(2,:)%j)) * den(20)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(356),h0tab(:,356),[28,3],[nMM,nMM],2,2,wf8(:,27),wf4(:,4))
  call Hloop_QZ_A(ntryL,G0H32(1),wf8(:,27),G0H4(3),ngZl,m3h8x4(:,134),heltab2x32(:,:,356))
  call Hloop_Q_A(ntryL,G0H4(3),28,nMM,G1H4(31),n2h4(164))
  Gcoeff(:)%j = (-(c(48)*M(2,:)%j)) * den(20)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(357),h0tab(:,357),[28,3],[nML,nML],2,2,wf8(:,27),wf4(:,4))
  call Hloop_QZ_A(ntryL,G0H32(1),wf8(:,27),G0H4(15),ngZl,m3h8x4(:,135),heltab2x32(:,:,357))
  call Hloop_Q_A(ntryL,G0H4(15),28,nML,G1H4(6),n2h4(165))
  Gcoeff(:)%j = (-(c(50)*M(2,:)%j)) * den(20)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(358),h0tab(:,358),[28,3],[0,0],2,2,wf8(:,27),wf4(:,4))
  call Hloop_QZ_A(ntryL,G0H32(1),wf8(:,27),G0H4(17),ngZu,m3h8x4(:,136),heltab2x32(:,:,358))
  call Hloop_Q_A(ntryL,G0H4(17),28,0,G1H4(1),n2h4(166))
  Gcoeff(:)%j = (-(c(49)*M(2,:)%j)) * den(20)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(359),h0tab(:,359),[28,3],[nMT,nMT],2,2,wf8(:,27),wf4(:,4))
  call Hloop_QZ_A(ntryL,G0H32(1),wf8(:,27),G0H4(7),ngZu,m3h8x4(:,137),heltab2x32(:,:,359))
  call Hloop_Q_A(ntryL,G0H4(7),28,nMT,G1H4(23),n2h4(167))
  Gcoeff(:)%j = (-(c(50)*M(2,:)%j)) * den(20)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(360),h0tab(:,360),[28,3],[0,0],2,2,wf8(:,27),wf4(:,4))
  call Hloop_QZ_A(ntryL,G0H32(1),wf8(:,27),G0H4(3),ngZd,m3h8x4(:,138),heltab2x32(:,:,360))
  call Hloop_Q_A(ntryL,G0H4(3),28,0,G1H4(34),n2h4(168))
  Gcoeff(:)%j = (-(c(49)*M(2,:)%j)) * den(20)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(361),h0tab(:,361),[28,3],[nMB,nMB],2,2,wf8(:,27),wf4(:,4))
  call Hloop_QZ_A(ntryL,G0H32(1),wf8(:,27),G0H4(15),ngZd,m3h8x4(:,139),heltab2x32(:,:,361))
  call Hloop_Q_A(ntryL,G0H4(15),28,nMB,G1H4(9),n2h4(169))
  Gcoeff(:)%j = (c(2)*M(2,:)%j) * den(23)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(362),h0tab(:,362),[28,3],[nMW,nMW],2,2,wf8(:,26),wf4(:,1))
  call Hloop_TV_S(ntryL,G0H32(1),0,wf8(:,26),28,G1H4(28),m3h8x4(:,140),heltab2x32(:,:,362))
  Gcoeff(:)%j = (-(c(37)*M(2,:)%j)) * den(19)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(363),h0tab(:,363),[28,3],[nMW,nMW],2,2,wf8(:,27),wf4(:,1))
  call Hloop_TV_S(ntryL,G0H32(1),0,wf8(:,27),28,G1H4(11),m3h8x4(:,141),heltab2x32(:,:,363))
  Gcoeff(:)%j = (-(c(37)*M(2,:)%j)) * den(24)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(364),h0tab(:,364),[28,3],[nMW,nMW],2,2,wf8(:,26),wf4(:,4))
  call Hloop_TV_S(ntryL,G0H32(1),0,wf8(:,26),28,G1H4(44),m3h8x4(:,142),heltab2x32(:,:,364))
  Gcoeff(:)%j = (-(c(17)*M(2,:)%j)) * den(20)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(365),h0tab(:,365),[28,3],[nMH,nMZ],2,2,wf8(:,27),wf4(:,4))
  call Hloop_SV_T(ntryL,G0H32(1),0,wf8(:,27),28,G1H4(14),m3h8x4(:,143),heltab2x32(:,:,365))
  Gcoeff(:)%j = (c(38)*M(2,:)%j) * den(20)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(366),h0tab(:,366),[28,3],[nMW,nMW],2,2,wf8(:,27),wf4(:,4))
  call Hloop_TV_S(ntryL,G0H32(1),0,wf8(:,27),28,G1H4(47),m3h8x4(:,144),heltab2x32(:,:,366))
  Gcoeff(:)%j = (-(c(2)*M(2,:)%j)) * den(23)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(367),h0tab(:,367),[28,3],[nMW,nMW],2,2,wf8(:,26),wf4(:,1))
  call Hloop_CV_D(ntryL,G0H32(1),0,wf8(:,26),28,G1H4(21),m3h8x4(:,145),heltab2x32(:,:,367))
  Gcoeff(:)%j = (-(c(2)*M(2,:)%j)) * den(23)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(368),h0tab(:,368),[28,3],[nMW,nMW],2,2,wf8(:,26),wf4(:,1))
  call Hloop_CV_D(ntryL,G0H32(1),0,wf8(:,26),28,G1H4(54),m3h8x4(:,146),heltab2x32(:,:,368))
  Gcoeff(:)%j = (-(c(31)*M(2,:)%j)) * den(19)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(369),h0tab(:,369),[28,3],[nMW,nMW],2,2,wf8(:,27),wf4(:,1))
  call Hloop_CV_D(ntryL,G0H32(1),0,wf8(:,27),28,G1H4(16),m3h8x4(:,147),heltab2x32(:,:,369))
  Gcoeff(:)%j = (-(c(31)*M(2,:)%j)) * den(19)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(370),h0tab(:,370),[28,3],[nMW,nMW],2,2,wf8(:,27),wf4(:,1))
  call Hloop_CV_D(ntryL,G0H32(1),0,wf8(:,27),28,G1H4(50),m3h8x4(:,148),heltab2x32(:,:,370))
  Gcoeff(:)%j = (-(c(31)*M(2,:)%j)) * den(24)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(371),h0tab(:,371),[28,3],[nMW,nMW],2,2,wf8(:,26),wf4(:,4))
  call Hloop_CV_D(ntryL,G0H32(1),0,wf8(:,26),28,G1H4(59),m3h8x4(:,149),heltab2x32(:,:,371))
  Gcoeff(:)%j = (-(c(31)*M(2,:)%j)) * den(24)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(372),h0tab(:,372),[28,3],[nMW,nMW],2,2,wf8(:,26),wf4(:,4))
  call Hloop_CV_D(ntryL,G0H32(1),0,wf8(:,26),28,G1H4(30),m3h8x4(:,150),heltab2x32(:,:,372))
  Gcoeff(:)%j = (-(c(18)*M(2,:)%j)) * den(20)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(373),h0tab(:,373),[28,3],[nMW,nMW],2,2,wf8(:,27),wf4(:,4))
  call Hloop_CV_D(ntryL,G0H32(1),0,wf8(:,27),28,G1H4(5),m3h8x4(:,151),heltab2x32(:,:,373))
  Gcoeff(:)%j = (-(c(18)*M(2,:)%j)) * den(20)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(374),h0tab(:,374),[28,3],[nMW,nMW],2,2,wf8(:,27),wf4(:,4))
  call Hloop_CV_D(ntryL,G0H32(1),0,wf8(:,27),28,G1H4(4),m3h8x4(:,152),heltab2x32(:,:,374))
  Gcoeff(:)%j = (c(2)*M(2,:)%j) * den(23)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(375),h0tab(:,375),[28,3],[nMW,nMW],2,2,wf8(:,26),wf4(:,1))
  call Hloop_UV_W(ntryL,G0H32(1),0,wf8(:,26),28,G1H4(41),m3h8x4(:,153),heltab2x32(:,:,375))
  Gcoeff(:)%j = (c(31)*M(2,:)%j) * den(19)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(376),h0tab(:,376),[28,3],[nMW,nMW],2,2,wf8(:,27),wf4(:,1))
  call Hloop_UV_W(ntryL,G0H32(1),0,wf8(:,27),28,G1H4(15),m3h8x4(:,154),heltab2x32(:,:,376))
  Gcoeff(:)%j = (c(31)*M(2,:)%j) * den(24)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(377),h0tab(:,377),[28,3],[nMW,nMW],2,2,wf8(:,26),wf4(:,4))
  call Hloop_UV_W(ntryL,G0H32(1),0,wf8(:,26),28,G1H4(10),m3h8x4(:,155),heltab2x32(:,:,377))
  Gcoeff(:)%j = (c(18)*M(2,:)%j) * den(20)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(378),h0tab(:,378),[28,3],[nMW,nMW],2,2,wf8(:,27),wf4(:,4))
  call Hloop_UV_W(ntryL,G0H32(1),0,wf8(:,27),28,G1H4(24),m3h8x4(:,156),heltab2x32(:,:,378))
  Gcoeff(:)%j = (-(c(4)*M(2,:)%j)) * den(23)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(379),h0tab(:,379),[28,3],[nMW,nMW],2,2,wf8(:,26),wf4(:,1))
  call Hloop_VV_S(ntryL,G0H32(1),wf8(:,26),G0H4(17),m3h8x4(:,157),heltab2x32(:,:,379))
  Gcoeff(:)%j = (-(c(4)*M(2,:)%j)) * den(23)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(380),h0tab(:,380),[28,3],[nMW,nMW],2,2,wf8(:,26),wf4(:,1))
  call Hloop_VV_S(ntryL,G0H32(1),wf8(:,26),G0H4(7),m3h8x4(:,158),heltab2x32(:,:,380))
  Gcoeff(:)%j = (c(33)*M(2,:)%j) * den(19)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(381),h0tab(:,381),[28,3],[nMW,nMW],2,2,wf8(:,27),wf4(:,1))
  call Hloop_VV_S(ntryL,G0H32(1),wf8(:,27),G0H4(3),m3h8x4(:,159),heltab2x32(:,:,381))
  Gcoeff(:)%j = (c(33)*M(2,:)%j) * den(19)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(382),h0tab(:,382),[28,3],[nMW,nMW],2,2,wf8(:,27),wf4(:,1))
  call Hloop_VV_S(ntryL,G0H32(1),wf8(:,27),G0H4(15),m3h8x4(:,160),heltab2x32(:,:,382))
  Gcoeff(:)%j = (c(33)*M(2,:)%j) * den(24)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(383),h0tab(:,383),[28,3],[nMW,nMW],2,2,wf8(:,26),wf4(:,4))
  call Hloop_VV_S(ntryL,G0H32(1),wf8(:,26),G0H4(18),m3h8x4(:,161),heltab2x32(:,:,383))
  Gcoeff(:)%j = (c(33)*M(2,:)%j) * den(24)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(384),h0tab(:,384),[28,3],[nMW,nMW],2,2,wf8(:,26),wf4(:,4))
  call Hloop_VV_S(ntryL,G0H32(1),wf8(:,26),G0H4(19),m3h8x4(:,162),heltab2x32(:,:,384))
  Gcoeff(:)%j = (-(c(29)*M(2,:)%j)) * den(20)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(385),h0tab(:,385),[28,3],[nMH,nMZ],2,2,wf8(:,27),wf4(:,4))
  call Hloop_VV_S(ntryL,G0H32(1),wf8(:,27),G0H4(20),m3h8x4(:,163),heltab2x32(:,:,385))
  Gcoeff(:)%j = (-(c(34)*M(2,:)%j)) * den(20)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(386),h0tab(:,386),[28,3],[nMW,nMW],2,2,wf8(:,27),wf4(:,4))
  call Hloop_VV_S(ntryL,G0H32(1),wf8(:,27),G0H4(21),m3h8x4(:,164),heltab2x32(:,:,386))
  Gcoeff(:)%j = (-(c(34)*M(2,:)%j)) * den(20)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(387),h0tab(:,387),[28,3],[nMW,nMW],2,2,wf8(:,27),wf4(:,4))
  call Hloop_VV_S(ntryL,G0H32(1),wf8(:,27),G0H4(22),m3h8x4(:,165),heltab2x32(:,:,387))
  Gcoeff(:)%j = (-(c(27)*M(2,:)%j)) * den(38)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(388),h0tab(:,388),[24,7],[nMT,nMH],2,2,wf4(:,6),wf8(:,33))
  call Hloop_SA_Q(ntryL,G0H32(1),wf4(:,6),G0H8(6),ngH,m3h4x8(:,117),heltab2x32(:,:,388))
  call Hloop_A_Q(ntryL,G0H8(6),24,nMT,G1H8(11),n2h8(51))
  Gcoeff(:)%j = (c(27)*M(2,:)%j) * den(38)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(389),h0tab(:,389),[24,7],[nMT,nMZ],2,2,wf4(:,6),wf8(:,33))
  call Hloop_SA_Q(ntryL,G0H32(1),wf4(:,6),G0H8(11),ngX,m3h4x8(:,118),heltab2x32(:,:,389))
  call Hloop_A_Q(ntryL,G0H8(11),24,nMT,G1H8(12),n2h8(52))
  Gcoeff(:)%j = (c(23)*M(2,:)%j) * den(38)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(390),h0tab(:,390),[24,7],[nMB,nMW],2,2,wf4(:,6),wf8(:,33))
  call Hloop_SA_Q(ntryL,G0H32(1),wf4(:,6),G0H8(12),ngPtb,m3h4x8(:,119),heltab2x32(:,:,390))
  call Hloop_A_Q(ntryL,G0H8(12),24,nMB,G1H8(13),n2h8(53))
  Gcoeff(:)%j = (-(c(28)*M(2,:)%j)) * den(40)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(391),h0tab(:,391),[24,7],[nMT,nMH],2,2,wf4(:,6),wf8(:,34))
  call Hloop_SA_Q(ntryL,G0H32(1),wf4(:,6),G0H8(13),ngH,m3h4x8(:,120),heltab2x32(:,:,391))
  call Hloop_A_Q(ntryL,G0H8(13),24,nMT,G1H8(14),n2h8(54))
  Gcoeff(:)%j = (c(28)*M(2,:)%j) * den(40)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(392),h0tab(:,392),[24,7],[nMT,nMZ],2,2,wf4(:,6),wf8(:,34))
  call Hloop_SA_Q(ntryL,G0H32(1),wf4(:,6),G0H8(14),ngX,m3h4x8(:,121),heltab2x32(:,:,392))
  call Hloop_A_Q(ntryL,G0H8(14),24,nMT,G1H8(15),n2h8(55))
  Gcoeff(:)%j = (c(25)*M(2,:)%j) * den(40)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(393),h0tab(:,393),[24,7],[nMB,nMW],2,2,wf4(:,6),wf8(:,34))
  call Hloop_SA_Q(ntryL,G0H32(1),wf4(:,6),G0H8(15),ngPtb,m3h4x8(:,122),heltab2x32(:,:,393))
  call Hloop_A_Q(ntryL,G0H8(15),24,nMB,G1H8(16),n2h8(56))
  Gcoeff(:)%j = (c(1)*M(2,:)%j) * den(38)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(394),h0tab(:,394),[24,7],[nMT,0],2,2,wf4(:,6),wf8(:,33))
  call Hloop_VA_Q(ntryL,G0H32(1),wf4(:,6),G0H8(16),m3h4x8(:,123),heltab2x32(:,:,394))
  call Hloop_A_Q(ntryL,G0H8(16),24,nMT,G1H8(17),n2h8(57))
  Gcoeff(:)%j = (c(2)*M(2,:)%j) * den(38)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(395),h0tab(:,395),[24,7],[nMT,nMZ],2,2,wf4(:,6),wf8(:,33))
  call Hloop_ZA_Q(ntryL,G0H32(1),wf4(:,6),G0H8(19),ngZu,m3h4x8(:,124),heltab2x32(:,:,395))
  call Hloop_A_Q(ntryL,G0H8(19),24,nMT,G1H8(18),n2h8(58))
  Gcoeff(:)%j = (c(14)*M(2,:)%j) * den(38)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(396),h0tab(:,396),[24,7],[nMB,nMW],2,2,wf4(:,6),wf8(:,33))
  call Hloop_WA_Q(ntryL,G0H32(1),wf4(:,6),G0H8(20),m3h4x8(:,125),heltab2x32(:,:,396))
  call Hloop_A_Q(ntryL,G0H8(20),24,nMB,G1H8(19),n2h8(59))
  Gcoeff(:)%j = (c(2)*M(2,:)%j) * den(40)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(397),h0tab(:,397),[24,7],[nMT,0],2,2,wf4(:,6),wf8(:,34))
  call Hloop_VA_Q(ntryL,G0H32(1),wf4(:,6),G0H8(21),m3h4x8(:,126),heltab2x32(:,:,397))
  call Hloop_A_Q(ntryL,G0H8(21),24,nMT,G1H8(20),n2h8(60))
  Gcoeff(:)%j = (c(3)*M(2,:)%j) * den(40)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(398),h0tab(:,398),[24,7],[nMT,nMZ],2,2,wf4(:,6),wf8(:,34))
  call Hloop_ZA_Q(ntryL,G0H32(1),wf4(:,6),G0H8(22),ngZu,m3h4x8(:,127),heltab2x32(:,:,398))
  call Hloop_A_Q(ntryL,G0H8(22),24,nMT,G1H8(21),n2h8(61))
  Gcoeff(:)%j = (c(16)*M(2,:)%j) * den(40)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(399),h0tab(:,399),[24,7],[nMB,nMW],2,2,wf4(:,6),wf8(:,34))
  call Hloop_WA_Q(ntryL,G0H32(1),wf4(:,6),G0H8(23),m3h4x8(:,128),heltab2x32(:,:,399))
  call Hloop_A_Q(ntryL,G0H8(23),24,nMB,G1H8(22),n2h8(62))
  Gcoeff(:)%j = (-(c(54)*M(2,:)%j)) * den(73)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(400),h0tab(:,400),[28,3],[nME,nME],2,2,wf8(:,44),wf4(:,1))
  call Hloop_QS_A(ntryL,G0H32(1),wf8(:,44),G0H4(23),ngH,m3h8x4(:,166),heltab2x32(:,:,400))
  call Hloop_Q_A(ntryL,G0H4(23),28,nME,G1H4(19),n2h4(170))
  Gcoeff(:)%j = (-(c(58)*M(2,:)%j)) * den(73)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(401),h0tab(:,401),[28,3],[nMM,nMM],2,2,wf8(:,44),wf4(:,1))
  call Hloop_QS_A(ntryL,G0H32(1),wf8(:,44),G0H4(23),ngH,m3h8x4(:,167),heltab2x32(:,:,401))
  call Hloop_Q_A(ntryL,G0H4(23),28,nMM,G1H4(77),n2h4(171))
  Gcoeff(:)%j = (-(c(56)*M(2,:)%j)) * den(73)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(402),h0tab(:,402),[28,3],[nML,nML],2,2,wf8(:,44),wf4(:,1))
  call Hloop_QS_A(ntryL,G0H32(1),wf8(:,44),G0H4(23),ngH,m3h8x4(:,168),heltab2x32(:,:,402))
  call Hloop_Q_A(ntryL,G0H4(23),28,nML,G1H4(78),n2h4(172))
  Gcoeff(:)%j = (c(60)*M(2,:)%j) * den(73)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(403),h0tab(:,403),[28,3],[nMT,nMT],2,2,wf8(:,44),wf4(:,1))
  call Hloop_QS_A(ntryL,G0H32(1),wf8(:,44),G0H4(23),ngH,m3h8x4(:,169),heltab2x32(:,:,403))
  call Hloop_Q_A(ntryL,G0H4(23),28,nMT,G1H4(79),n2h4(173))
  Gcoeff(:)%j = (-(c(52)*M(2,:)%j)) * den(73)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(404),h0tab(:,404),[28,3],[nMB,nMB],2,2,wf8(:,44),wf4(:,1))
  call Hloop_QS_A(ntryL,G0H32(1),wf8(:,44),G0H4(23),ngH,m3h8x4(:,170),heltab2x32(:,:,404))
  call Hloop_Q_A(ntryL,G0H4(23),28,nMB,G1H4(80),n2h4(174))
  Gcoeff(:)%j = (-(c(54)*M(2,:)%j)) * den(31)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(405),h0tab(:,405),[28,3],[nME,nME],2,2,wf8(:,30),wf4(:,1))
  call Hloop_QS_A(ntryL,G0H32(1),wf8(:,30),G0H4(23),ngX,m3h8x4(:,171),heltab2x32(:,:,405))
  call Hloop_Q_A(ntryL,G0H4(23),28,nME,G1H4(81),n2h4(175))
  Gcoeff(:)%j = (-(c(58)*M(2,:)%j)) * den(31)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(406),h0tab(:,406),[28,3],[nMM,nMM],2,2,wf8(:,30),wf4(:,1))
  call Hloop_QS_A(ntryL,G0H32(1),wf8(:,30),G0H4(23),ngX,m3h8x4(:,172),heltab2x32(:,:,406))
  call Hloop_Q_A(ntryL,G0H4(23),28,nMM,G1H4(82),n2h4(176))
  Gcoeff(:)%j = (-(c(56)*M(2,:)%j)) * den(31)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(407),h0tab(:,407),[28,3],[nML,nML],2,2,wf8(:,30),wf4(:,1))
  call Hloop_QS_A(ntryL,G0H32(1),wf8(:,30),G0H4(23),ngX,m3h8x4(:,173),heltab2x32(:,:,407))
  call Hloop_Q_A(ntryL,G0H4(23),28,nML,G1H4(83),n2h4(177))
  Gcoeff(:)%j = (-(c(60)*M(2,:)%j)) * den(31)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(408),h0tab(:,408),[28,3],[nMT,nMT],2,2,wf8(:,30),wf4(:,1))
  call Hloop_QS_A(ntryL,G0H32(1),wf8(:,30),G0H4(23),ngX,m3h8x4(:,174),heltab2x32(:,:,408))
  call Hloop_Q_A(ntryL,G0H4(23),28,nMT,G1H4(84),n2h4(178))
  Gcoeff(:)%j = (-(c(52)*M(2,:)%j)) * den(31)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(409),h0tab(:,409),[28,3],[nMB,nMB],2,2,wf8(:,30),wf4(:,1))
  call Hloop_QS_A(ntryL,G0H32(1),wf8(:,30),G0H4(23),ngX,m3h8x4(:,175),heltab2x32(:,:,409))
  call Hloop_Q_A(ntryL,G0H4(23),28,nMB,G1H4(85),n2h4(179))
  Gcoeff(:)%j = (c(55)*M(2,:)%j) * den(74)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(410),h0tab(:,410),[28,3],[nME,nME],2,2,wf8(:,44),wf4(:,4))
  call Hloop_QS_A(ntryL,G0H32(1),wf8(:,44),G0H4(23),ngH,m3h8x4(:,176),heltab2x32(:,:,410))
  call Hloop_Q_A(ntryL,G0H4(23),28,nME,G1H4(86),n2h4(180))
  Gcoeff(:)%j = (c(59)*M(2,:)%j) * den(74)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(411),h0tab(:,411),[28,3],[nMM,nMM],2,2,wf8(:,44),wf4(:,4))
  call Hloop_QS_A(ntryL,G0H32(1),wf8(:,44),G0H4(23),ngH,m3h8x4(:,177),heltab2x32(:,:,411))
  call Hloop_Q_A(ntryL,G0H4(23),28,nMM,G1H4(87),n2h4(181))
  Gcoeff(:)%j = (c(57)*M(2,:)%j) * den(74)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(412),h0tab(:,412),[28,3],[nML,nML],2,2,wf8(:,44),wf4(:,4))
  call Hloop_QS_A(ntryL,G0H32(1),wf8(:,44),G0H4(23),ngH,m3h8x4(:,178),heltab2x32(:,:,412))
  call Hloop_Q_A(ntryL,G0H4(23),28,nML,G1H4(88),n2h4(182))
  Gcoeff(:)%j = (c(61)*M(2,:)%j) * den(74)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(413),h0tab(:,413),[28,3],[nMT,nMT],2,2,wf8(:,44),wf4(:,4))
  call Hloop_QS_A(ntryL,G0H32(1),wf8(:,44),G0H4(23),ngH,m3h8x4(:,179),heltab2x32(:,:,413))
  call Hloop_Q_A(ntryL,G0H4(23),28,nMT,G1H4(89),n2h4(183))
  Gcoeff(:)%j = (c(53)*M(2,:)%j) * den(74)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(414),h0tab(:,414),[28,3],[nMB,nMB],2,2,wf8(:,44),wf4(:,4))
  call Hloop_QS_A(ntryL,G0H32(1),wf8(:,44),G0H4(23),ngH,m3h8x4(:,180),heltab2x32(:,:,414))
  call Hloop_Q_A(ntryL,G0H4(23),28,nMB,G1H4(90),n2h4(184))
  Gcoeff(:)%j = (c(55)*M(2,:)%j) * den(32)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(415),h0tab(:,415),[28,3],[nME,nME],2,2,wf8(:,30),wf4(:,4))
  call Hloop_QS_A(ntryL,G0H32(1),wf8(:,30),G0H4(23),ngX,m3h8x4(:,181),heltab2x32(:,:,415))
  call Hloop_Q_A(ntryL,G0H4(23),28,nME,G1H4(91),n2h4(185))
  Gcoeff(:)%j = (c(59)*M(2,:)%j) * den(32)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(416),h0tab(:,416),[28,3],[nMM,nMM],2,2,wf8(:,30),wf4(:,4))
  call Hloop_QS_A(ntryL,G0H32(1),wf8(:,30),G0H4(23),ngX,m3h8x4(:,182),heltab2x32(:,:,416))
  call Hloop_Q_A(ntryL,G0H4(23),28,nMM,G1H4(92),n2h4(186))
  Gcoeff(:)%j = (c(57)*M(2,:)%j) * den(32)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(417),h0tab(:,417),[28,3],[nML,nML],2,2,wf8(:,30),wf4(:,4))
  call Hloop_QS_A(ntryL,G0H32(1),wf8(:,30),G0H4(23),ngX,m3h8x4(:,183),heltab2x32(:,:,417))
  call Hloop_Q_A(ntryL,G0H4(23),28,nML,G1H4(93),n2h4(187))
  Gcoeff(:)%j = (-(c(61)*M(2,:)%j)) * den(32)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(418),h0tab(:,418),[28,3],[nMT,nMT],2,2,wf8(:,30),wf4(:,4))
  call Hloop_QS_A(ntryL,G0H32(1),wf8(:,30),G0H4(23),ngX,m3h8x4(:,184),heltab2x32(:,:,418))
  call Hloop_Q_A(ntryL,G0H4(23),28,nMT,G1H4(94),n2h4(188))
  Gcoeff(:)%j = (c(53)*M(2,:)%j) * den(32)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(419),h0tab(:,419),[28,3],[nMB,nMB],2,2,wf8(:,30),wf4(:,4))
  call Hloop_QS_A(ntryL,G0H32(1),wf8(:,30),G0H4(23),ngX,m3h8x4(:,185),heltab2x32(:,:,419))
  call Hloop_Q_A(ntryL,G0H4(23),28,nMB,G1H4(95),n2h4(189))
  Gcoeff(:)%j = (-(c(26)*M(2,:)%j)) * den(73)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(420),h0tab(:,420),[28,3],[nMW,nMW],2,2,wf8(:,44),wf4(:,1))
  call Hloop_SS_S(ntryL,G0H32(1),wf8(:,44),G0H4(23),m3h8x4(:,186),heltab2x32(:,:,420))
  Gcoeff(:)%j = (c(36)*M(2,:)%j) * den(74)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(421),h0tab(:,421),[28,3],[nMW,nMW],2,2,wf8(:,44),wf4(:,4))
  call Hloop_SS_S(ntryL,G0H32(1),wf8(:,44),G0H4(24),m3h8x4(:,187),heltab2x32(:,:,421))
  Gcoeff(:)%j = (-(c(11)*M(2,:)%j)) * den(32)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(422),h0tab(:,422),[28,3],[nMH,nMZ],2,2,wf8(:,30),wf4(:,4))
  call Hloop_SS_S(ntryL,G0H32(1),wf8(:,30),G0H4(25),m3h8x4(:,188),heltab2x32(:,:,422))
  Gcoeff(:)%j = (-(c(19)*M(2,:)%j)) * den(73)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(423),h0tab(:,423),[28,3],[nMW,nMW],2,2,wf8(:,44),wf4(:,1))
  call Hloop_SS_S(ntryL,G0H32(1),wf8(:,44),G0H4(26),m3h8x4(:,189),heltab2x32(:,:,423))
  Gcoeff(:)%j = (c(19)*M(2,:)%j) * den(73)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(424),h0tab(:,424),[28,3],[nMW,nMW],2,2,wf8(:,44),wf4(:,1))
  call Hloop_SS_S(ntryL,G0H32(1),wf8(:,44),G0H4(27),m3h8x4(:,190),heltab2x32(:,:,424))
  Gcoeff(:)%j = (-(c(19)*M(2,:)%j)) * den(31)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(425),h0tab(:,425),[28,3],[nMW,nMW],2,2,wf8(:,30),wf4(:,1))
  call Hloop_SS_S(ntryL,G0H32(1),wf8(:,30),G0H4(28),m3h8x4(:,191),heltab2x32(:,:,425))
  Gcoeff(:)%j = (-(c(19)*M(2,:)%j)) * den(31)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(426),h0tab(:,426),[28,3],[nMW,nMW],2,2,wf8(:,30),wf4(:,1))
  call Hloop_SS_S(ntryL,G0H32(1),wf8(:,30),G0H4(29),m3h8x4(:,192),heltab2x32(:,:,426))
  Gcoeff(:)%j = (-(c(9)*M(2,:)%j)) * den(74)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(427),h0tab(:,427),[28,3],[nMW,nMW],2,2,wf8(:,44),wf4(:,4))
  call Hloop_SS_S(ntryL,G0H32(1),wf8(:,44),G0H4(30),m3h8x4(:,193),heltab2x32(:,:,427))
  Gcoeff(:)%j = (c(9)*M(2,:)%j) * den(74)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(428),h0tab(:,428),[28,3],[nMW,nMW],2,2,wf8(:,44),wf4(:,4))
  call Hloop_SS_S(ntryL,G0H32(1),wf8(:,44),G0H4(31),m3h8x4(:,194),heltab2x32(:,:,428))
  Gcoeff(:)%j = (-(c(9)*M(2,:)%j)) * den(32)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(429),h0tab(:,429),[28,3],[nMW,nMW],2,2,wf8(:,30),wf4(:,4))
  call Hloop_SS_S(ntryL,G0H32(1),wf8(:,30),G0H4(32),m3h8x4(:,195),heltab2x32(:,:,429))
  Gcoeff(:)%j = (-(c(9)*M(2,:)%j)) * den(32)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(430),h0tab(:,430),[28,3],[nMW,nMW],2,2,wf8(:,30),wf4(:,4))
  call Hloop_SS_S(ntryL,G0H32(1),wf8(:,30),G0H4(33),m3h8x4(:,196),heltab2x32(:,:,430))
  Gcoeff(:)%j = (-(c(20)*M(2,:)%j)) * den(73)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(431),h0tab(:,431),[28,3],[nMW,nMW],2,2,wf8(:,44),wf4(:,1))
  call Hloop_VS_V(ntryL,G0H32(1),wf8(:,44),G0H4(34),m3h8x4(:,197),heltab2x32(:,:,431))
  Gcoeff(:)%j = (-(c(10)*M(2,:)%j)) * den(74)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(432),h0tab(:,432),[28,3],[nMW,nMW],2,2,wf8(:,44),wf4(:,4))
  call Hloop_VS_V(ntryL,G0H32(1),wf8(:,44),G0H4(35),m3h8x4(:,198),heltab2x32(:,:,432))
  Gcoeff(:)%j = (-(c(19)*M(2,:)%j)) * den(73)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(433),h0tab(:,433),[28,3],[nMW,nMW],2,2,wf8(:,44),wf4(:,1))
  call Hloop_VT_S(ntryL,G0H32(1),0,wf8(:,44),28,G1H4(96),m3h8x4(:,199),heltab2x32(:,:,433))
  Gcoeff(:)%j = (c(19)*M(2,:)%j) * den(73)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(434),h0tab(:,434),[28,3],[nMW,nMW],2,2,wf8(:,44),wf4(:,1))
  call Hloop_VT_S(ntryL,G0H32(1),0,wf8(:,44),28,G1H4(97),m3h8x4(:,200),heltab2x32(:,:,434))
  Gcoeff(:)%j = (-(c(19)*M(2,:)%j)) * den(31)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(435),h0tab(:,435),[28,3],[nMW,nMW],2,2,wf8(:,30),wf4(:,1))
  call Hloop_VT_S(ntryL,G0H32(1),0,wf8(:,30),28,G1H4(98),m3h8x4(:,201),heltab2x32(:,:,435))
  Gcoeff(:)%j = (-(c(19)*M(2,:)%j)) * den(31)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(436),h0tab(:,436),[28,3],[nMW,nMW],2,2,wf8(:,30),wf4(:,1))
  call Hloop_VT_S(ntryL,G0H32(1),0,wf8(:,30),28,G1H4(99),m3h8x4(:,202),heltab2x32(:,:,436))
  Gcoeff(:)%j = (c(32)*M(2,:)%j) * den(74)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(437),h0tab(:,437),[28,3],[nMW,nMW],2,2,wf8(:,44),wf4(:,4))
  call Hloop_VT_S(ntryL,G0H32(1),0,wf8(:,44),28,G1H4(100),m3h8x4(:,203),heltab2x32(:,:,437))
  Gcoeff(:)%j = (-(c(32)*M(2,:)%j)) * den(74)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(438),h0tab(:,438),[28,3],[nMW,nMW],2,2,wf8(:,44),wf4(:,4))
  call Hloop_VT_S(ntryL,G0H32(1),0,wf8(:,44),28,G1H4(101),m3h8x4(:,204),heltab2x32(:,:,438))
  Gcoeff(:)%j = (-(c(8)*M(2,:)%j)) * den(32)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(439),h0tab(:,439),[28,3],[nMH,nMZ],2,2,wf8(:,30),wf4(:,4))
  call Hloop_VS_T(ntryL,G0H32(1),0,wf8(:,30),28,G1H4(102),m3h8x4(:,205),heltab2x32(:,:,439))
  Gcoeff(:)%j = (c(32)*M(2,:)%j) * den(32)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(440),h0tab(:,440),[28,3],[nMW,nMW],2,2,wf8(:,30),wf4(:,4))
  call Hloop_VT_S(ntryL,G0H32(1),0,wf8(:,30),28,G1H4(103),m3h8x4(:,206),heltab2x32(:,:,440))
  Gcoeff(:)%j = (c(32)*M(2,:)%j) * den(32)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(441),h0tab(:,441),[28,3],[nMW,nMW],2,2,wf8(:,30),wf4(:,4))
  call Hloop_VT_S(ntryL,G0H32(1),0,wf8(:,30),28,G1H4(104),m3h8x4(:,207),heltab2x32(:,:,441))
  Gcoeff(:)%j = (-(c(44)*M(2,:)%j)) * den(34)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(442),h0tab(:,442),[28,3],[nME,nME],2,2,wf8(:,31),wf4(:,1))
  call Hloop_QV_A(ntryL,G0H32(1),wf8(:,31),G0H4(36),m3h8x4(:,208),heltab2x32(:,:,442))
  call Hloop_Q_A(ntryL,G0H4(36),28,nME,G1H4(105),n2h4(190))
  Gcoeff(:)%j = (-(c(44)*M(2,:)%j)) * den(34)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(443),h0tab(:,443),[28,3],[nMM,nMM],2,2,wf8(:,31),wf4(:,1))
  call Hloop_QV_A(ntryL,G0H32(1),wf8(:,31),G0H4(36),m3h8x4(:,209),heltab2x32(:,:,443))
  call Hloop_Q_A(ntryL,G0H4(36),28,nMM,G1H4(106),n2h4(191))
  Gcoeff(:)%j = (-(c(44)*M(2,:)%j)) * den(34)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(444),h0tab(:,444),[28,3],[nML,nML],2,2,wf8(:,31),wf4(:,1))
  call Hloop_QV_A(ntryL,G0H32(1),wf8(:,31),G0H4(36),m3h8x4(:,210),heltab2x32(:,:,444))
  call Hloop_Q_A(ntryL,G0H4(36),28,nML,G1H4(107),n2h4(192))
  Gcoeff(:)%j = (-(c(43)*M(2,:)%j)) * den(34)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(445),h0tab(:,445),[28,3],[0,0],2,2,wf8(:,31),wf4(:,1))
  call Hloop_QV_A(ntryL,G0H32(1),wf8(:,31),G0H4(36),m3h8x4(:,211),heltab2x32(:,:,445))
  call Hloop_Q_A(ntryL,G0H4(36),28,0,G1H4(108),n2h4(193))
  Gcoeff(:)%j = (-(c(41)*M(2,:)%j)) * den(34)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(446),h0tab(:,446),[28,3],[nMT,nMT],2,2,wf8(:,31),wf4(:,1))
  call Hloop_QV_A(ntryL,G0H32(1),wf8(:,31),G0H4(36),m3h8x4(:,212),heltab2x32(:,:,446))
  call Hloop_Q_A(ntryL,G0H4(36),28,nMT,G1H4(109),n2h4(194))
  Gcoeff(:)%j = (-(c(40)*M(2,:)%j)) * den(34)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(447),h0tab(:,447),[28,3],[0,0],2,2,wf8(:,31),wf4(:,1))
  call Hloop_QV_A(ntryL,G0H32(1),wf8(:,31),G0H4(36),m3h8x4(:,213),heltab2x32(:,:,447))
  call Hloop_Q_A(ntryL,G0H4(36),28,0,G1H4(110),n2h4(195))
  Gcoeff(:)%j = (-(c(39)*M(2,:)%j)) * den(34)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(448),h0tab(:,448),[28,3],[nMB,nMB],2,2,wf8(:,31),wf4(:,1))
  call Hloop_QV_A(ntryL,G0H32(1),wf8(:,31),G0H4(36),m3h8x4(:,214),heltab2x32(:,:,448))
  call Hloop_Q_A(ntryL,G0H4(36),28,nMB,G1H4(111),n2h4(196))
  Gcoeff(:)%j = (c(46)*M(2,:)%j) * den(31)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(449),h0tab(:,449),[28,3],[nME,nME],2,2,wf8(:,32),wf4(:,1))
  call Hloop_QZ_A(ntryL,G0H32(1),wf8(:,32),G0H4(36),ngZl,m3h8x4(:,215),heltab2x32(:,:,449))
  call Hloop_Q_A(ntryL,G0H4(36),28,nME,G1H4(112),n2h4(197))
  Gcoeff(:)%j = (c(46)*M(2,:)%j) * den(31)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(450),h0tab(:,450),[28,3],[nMM,nMM],2,2,wf8(:,32),wf4(:,1))
  call Hloop_QZ_A(ntryL,G0H32(1),wf8(:,32),G0H4(36),ngZl,m3h8x4(:,216),heltab2x32(:,:,450))
  call Hloop_Q_A(ntryL,G0H4(36),28,nMM,G1H4(113),n2h4(198))
  Gcoeff(:)%j = (c(46)*M(2,:)%j) * den(31)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(451),h0tab(:,451),[28,3],[nML,nML],2,2,wf8(:,32),wf4(:,1))
  call Hloop_QZ_A(ntryL,G0H32(1),wf8(:,32),G0H4(36),ngZl,m3h8x4(:,217),heltab2x32(:,:,451))
  call Hloop_Q_A(ntryL,G0H4(36),28,nML,G1H4(114),n2h4(199))
  Gcoeff(:)%j = (-(c(47)*M(2,:)%j)) * den(31)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(452),h0tab(:,452),[28,3],[0,0],2,2,wf8(:,32),wf4(:,1))
  call Hloop_QZ_A(ntryL,G0H32(1),wf8(:,32),G0H4(36),ngZu,m3h8x4(:,218),heltab2x32(:,:,452))
  call Hloop_Q_A(ntryL,G0H4(36),28,0,G1H4(115),n2h4(200))
  Gcoeff(:)%j = (-(c(45)*M(2,:)%j)) * den(31)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(453),h0tab(:,453),[28,3],[nMT,nMT],2,2,wf8(:,32),wf4(:,1))
  call Hloop_QZ_A(ntryL,G0H32(1),wf8(:,32),G0H4(36),ngZu,m3h8x4(:,219),heltab2x32(:,:,453))
  call Hloop_Q_A(ntryL,G0H4(36),28,nMT,G1H4(116),n2h4(201))
  Gcoeff(:)%j = (c(45)*M(2,:)%j) * den(31)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(454),h0tab(:,454),[28,3],[0,0],2,2,wf8(:,32),wf4(:,1))
  call Hloop_QZ_A(ntryL,G0H32(1),wf8(:,32),G0H4(36),ngZd,m3h8x4(:,220),heltab2x32(:,:,454))
  call Hloop_Q_A(ntryL,G0H4(36),28,0,G1H4(117),n2h4(202))
  Gcoeff(:)%j = (c(42)*M(2,:)%j) * den(31)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(455),h0tab(:,455),[28,3],[nMB,nMB],2,2,wf8(:,32),wf4(:,1))
  call Hloop_QZ_A(ntryL,G0H32(1),wf8(:,32),G0H4(36),ngZd,m3h8x4(:,221),heltab2x32(:,:,455))
  call Hloop_Q_A(ntryL,G0H4(36),28,nMB,G1H4(118),n2h4(203))
  Gcoeff(:)%j = (c(46)*M(2,:)%j) * den(35)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(456),h0tab(:,456),[28,3],[nME,nME],2,2,wf8(:,31),wf4(:,4))
  call Hloop_QV_A(ntryL,G0H32(1),wf8(:,31),G0H4(36),m3h8x4(:,222),heltab2x32(:,:,456))
  call Hloop_Q_A(ntryL,G0H4(36),28,nME,G1H4(119),n2h4(204))
  Gcoeff(:)%j = (c(46)*M(2,:)%j) * den(35)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(457),h0tab(:,457),[28,3],[nMM,nMM],2,2,wf8(:,31),wf4(:,4))
  call Hloop_QV_A(ntryL,G0H32(1),wf8(:,31),G0H4(36),m3h8x4(:,223),heltab2x32(:,:,457))
  call Hloop_Q_A(ntryL,G0H4(36),28,nMM,G1H4(120),n2h4(205))
  Gcoeff(:)%j = (c(46)*M(2,:)%j) * den(35)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(458),h0tab(:,458),[28,3],[nML,nML],2,2,wf8(:,31),wf4(:,4))
  call Hloop_QV_A(ntryL,G0H32(1),wf8(:,31),G0H4(36),m3h8x4(:,224),heltab2x32(:,:,458))
  call Hloop_Q_A(ntryL,G0H4(36),28,nML,G1H4(121),n2h4(206))
  Gcoeff(:)%j = (-(c(47)*M(2,:)%j)) * den(35)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(459),h0tab(:,459),[28,3],[0,0],2,2,wf8(:,31),wf4(:,4))
  call Hloop_QV_A(ntryL,G0H32(1),wf8(:,31),G0H4(36),m3h8x4(:,225),heltab2x32(:,:,459))
  call Hloop_Q_A(ntryL,G0H4(36),28,0,G1H4(122),n2h4(207))
  Gcoeff(:)%j = (-(c(45)*M(2,:)%j)) * den(35)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(460),h0tab(:,460),[28,3],[nMT,nMT],2,2,wf8(:,31),wf4(:,4))
  call Hloop_QV_A(ntryL,G0H32(1),wf8(:,31),G0H4(36),m3h8x4(:,226),heltab2x32(:,:,460))
  call Hloop_Q_A(ntryL,G0H4(36),28,nMT,G1H4(123),n2h4(208))
  Gcoeff(:)%j = (c(45)*M(2,:)%j) * den(35)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(461),h0tab(:,461),[28,3],[0,0],2,2,wf8(:,31),wf4(:,4))
  call Hloop_QV_A(ntryL,G0H32(1),wf8(:,31),G0H4(36),m3h8x4(:,227),heltab2x32(:,:,461))
  call Hloop_Q_A(ntryL,G0H4(36),28,0,G1H4(124),n2h4(209))
  Gcoeff(:)%j = (c(42)*M(2,:)%j) * den(35)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(462),h0tab(:,462),[28,3],[nMB,nMB],2,2,wf8(:,31),wf4(:,4))
  call Hloop_QV_A(ntryL,G0H32(1),wf8(:,31),G0H4(36),m3h8x4(:,228),heltab2x32(:,:,462))
  call Hloop_Q_A(ntryL,G0H4(36),28,nMB,G1H4(125),n2h4(210))
  Gcoeff(:)%j = (-(c(51)*M(2,:)%j)) * den(32)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(463),h0tab(:,463),[28,3],[0,0],2,2,wf8(:,32),wf4(:,4))
  call Hloop_QZ_A(ntryL,G0H32(1),wf8(:,32),G0H4(36),ngZn,m3h8x4(:,229),heltab2x32(:,:,463))
  call Hloop_Q_A(ntryL,G0H4(36),28,0,G1H4(126),n2h4(211))
  Gcoeff(:)%j = (-(c(48)*M(2,:)%j)) * den(32)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(464),h0tab(:,464),[28,3],[nME,nME],2,2,wf8(:,32),wf4(:,4))
  call Hloop_QZ_A(ntryL,G0H32(1),wf8(:,32),G0H4(36),ngZl,m3h8x4(:,230),heltab2x32(:,:,464))
  call Hloop_Q_A(ntryL,G0H4(36),28,nME,G1H4(127),n2h4(212))
  Gcoeff(:)%j = (-(c(48)*M(2,:)%j)) * den(32)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(465),h0tab(:,465),[28,3],[nMM,nMM],2,2,wf8(:,32),wf4(:,4))
  call Hloop_QZ_A(ntryL,G0H32(1),wf8(:,32),G0H4(36),ngZl,m3h8x4(:,231),heltab2x32(:,:,465))
  call Hloop_Q_A(ntryL,G0H4(36),28,nMM,G1H4(128),n2h4(213))
  Gcoeff(:)%j = (-(c(48)*M(2,:)%j)) * den(32)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(466),h0tab(:,466),[28,3],[nML,nML],2,2,wf8(:,32),wf4(:,4))
  call Hloop_QZ_A(ntryL,G0H32(1),wf8(:,32),G0H4(36),ngZl,m3h8x4(:,232),heltab2x32(:,:,466))
  call Hloop_Q_A(ntryL,G0H4(36),28,nML,G1H4(129),n2h4(214))
  Gcoeff(:)%j = (-(c(50)*M(2,:)%j)) * den(32)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(467),h0tab(:,467),[28,3],[0,0],2,2,wf8(:,32),wf4(:,4))
  call Hloop_QZ_A(ntryL,G0H32(1),wf8(:,32),G0H4(36),ngZu,m3h8x4(:,233),heltab2x32(:,:,467))
  call Hloop_Q_A(ntryL,G0H4(36),28,0,G1H4(130),n2h4(215))
  Gcoeff(:)%j = (-(c(49)*M(2,:)%j)) * den(32)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(468),h0tab(:,468),[28,3],[nMT,nMT],2,2,wf8(:,32),wf4(:,4))
  call Hloop_QZ_A(ntryL,G0H32(1),wf8(:,32),G0H4(36),ngZu,m3h8x4(:,234),heltab2x32(:,:,468))
  call Hloop_Q_A(ntryL,G0H4(36),28,nMT,G1H4(131),n2h4(216))
  Gcoeff(:)%j = (-(c(50)*M(2,:)%j)) * den(32)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(469),h0tab(:,469),[28,3],[0,0],2,2,wf8(:,32),wf4(:,4))
  call Hloop_QZ_A(ntryL,G0H32(1),wf8(:,32),G0H4(36),ngZd,m3h8x4(:,235),heltab2x32(:,:,469))
  call Hloop_Q_A(ntryL,G0H4(36),28,0,G1H4(132),n2h4(217))
  Gcoeff(:)%j = (-(c(49)*M(2,:)%j)) * den(32)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(470),h0tab(:,470),[28,3],[nMB,nMB],2,2,wf8(:,32),wf4(:,4))
  call Hloop_QZ_A(ntryL,G0H32(1),wf8(:,32),G0H4(36),ngZd,m3h8x4(:,236),heltab2x32(:,:,470))
  call Hloop_Q_A(ntryL,G0H4(36),28,nMB,G1H4(133),n2h4(218))
  Gcoeff(:)%j = (c(2)*M(2,:)%j) * den(34)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(471),h0tab(:,471),[28,3],[nMW,nMW],2,2,wf8(:,31),wf4(:,1))
  call Hloop_TV_S(ntryL,G0H32(1),0,wf8(:,31),28,G1H4(134),m3h8x4(:,237),heltab2x32(:,:,471))
  Gcoeff(:)%j = (-(c(37)*M(2,:)%j)) * den(31)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(472),h0tab(:,472),[28,3],[nMW,nMW],2,2,wf8(:,32),wf4(:,1))
  call Hloop_TV_S(ntryL,G0H32(1),0,wf8(:,32),28,G1H4(135),m3h8x4(:,238),heltab2x32(:,:,472))
  Gcoeff(:)%j = (-(c(37)*M(2,:)%j)) * den(35)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(473),h0tab(:,473),[28,3],[nMW,nMW],2,2,wf8(:,31),wf4(:,4))
  call Hloop_TV_S(ntryL,G0H32(1),0,wf8(:,31),28,G1H4(136),m3h8x4(:,239),heltab2x32(:,:,473))
  Gcoeff(:)%j = (-(c(17)*M(2,:)%j)) * den(32)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(474),h0tab(:,474),[28,3],[nMH,nMZ],2,2,wf8(:,32),wf4(:,4))
  call Hloop_SV_T(ntryL,G0H32(1),0,wf8(:,32),28,G1H4(137),m3h8x4(:,240),heltab2x32(:,:,474))
  Gcoeff(:)%j = (c(38)*M(2,:)%j) * den(32)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(475),h0tab(:,475),[28,3],[nMW,nMW],2,2,wf8(:,32),wf4(:,4))
  call Hloop_TV_S(ntryL,G0H32(1),0,wf8(:,32),28,G1H4(138),m3h8x4(:,241),heltab2x32(:,:,475))
  Gcoeff(:)%j = (-(c(2)*M(2,:)%j)) * den(34)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(476),h0tab(:,476),[28,3],[nMW,nMW],2,2,wf8(:,31),wf4(:,1))
  call Hloop_CV_D(ntryL,G0H32(1),0,wf8(:,31),28,G1H4(139),m3h8x4(:,242),heltab2x32(:,:,476))
  Gcoeff(:)%j = (-(c(2)*M(2,:)%j)) * den(34)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(477),h0tab(:,477),[28,3],[nMW,nMW],2,2,wf8(:,31),wf4(:,1))
  call Hloop_CV_D(ntryL,G0H32(1),0,wf8(:,31),28,G1H4(140),m3h8x4(:,243),heltab2x32(:,:,477))
  Gcoeff(:)%j = (-(c(31)*M(2,:)%j)) * den(31)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(478),h0tab(:,478),[28,3],[nMW,nMW],2,2,wf8(:,32),wf4(:,1))
  call Hloop_CV_D(ntryL,G0H32(1),0,wf8(:,32),28,G1H4(141),m3h8x4(:,244),heltab2x32(:,:,478))
  Gcoeff(:)%j = (-(c(31)*M(2,:)%j)) * den(31)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(479),h0tab(:,479),[28,3],[nMW,nMW],2,2,wf8(:,32),wf4(:,1))
  call Hloop_CV_D(ntryL,G0H32(1),0,wf8(:,32),28,G1H4(142),m3h8x4(:,245),heltab2x32(:,:,479))
  Gcoeff(:)%j = (-(c(31)*M(2,:)%j)) * den(35)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(480),h0tab(:,480),[28,3],[nMW,nMW],2,2,wf8(:,31),wf4(:,4))
  call Hloop_CV_D(ntryL,G0H32(1),0,wf8(:,31),28,G1H4(143),m3h8x4(:,246),heltab2x32(:,:,480))
  Gcoeff(:)%j = (-(c(31)*M(2,:)%j)) * den(35)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(481),h0tab(:,481),[28,3],[nMW,nMW],2,2,wf8(:,31),wf4(:,4))
  call Hloop_CV_D(ntryL,G0H32(1),0,wf8(:,31),28,G1H4(144),m3h8x4(:,247),heltab2x32(:,:,481))
  Gcoeff(:)%j = (-(c(18)*M(2,:)%j)) * den(32)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(482),h0tab(:,482),[28,3],[nMW,nMW],2,2,wf8(:,32),wf4(:,4))
  call Hloop_CV_D(ntryL,G0H32(1),0,wf8(:,32),28,G1H4(145),m3h8x4(:,248),heltab2x32(:,:,482))
  Gcoeff(:)%j = (-(c(18)*M(2,:)%j)) * den(32)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(483),h0tab(:,483),[28,3],[nMW,nMW],2,2,wf8(:,32),wf4(:,4))
  call Hloop_CV_D(ntryL,G0H32(1),0,wf8(:,32),28,G1H4(146),m3h8x4(:,249),heltab2x32(:,:,483))
  Gcoeff(:)%j = (c(2)*M(2,:)%j) * den(34)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(484),h0tab(:,484),[28,3],[nMW,nMW],2,2,wf8(:,31),wf4(:,1))
  call Hloop_UV_W(ntryL,G0H32(1),0,wf8(:,31),28,G1H4(147),m3h8x4(:,250),heltab2x32(:,:,484))
  Gcoeff(:)%j = (c(31)*M(2,:)%j) * den(31)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(485),h0tab(:,485),[28,3],[nMW,nMW],2,2,wf8(:,32),wf4(:,1))
  call Hloop_UV_W(ntryL,G0H32(1),0,wf8(:,32),28,G1H4(148),m3h8x4(:,251),heltab2x32(:,:,485))
  Gcoeff(:)%j = (c(31)*M(2,:)%j) * den(35)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(486),h0tab(:,486),[28,3],[nMW,nMW],2,2,wf8(:,31),wf4(:,4))
  call Hloop_UV_W(ntryL,G0H32(1),0,wf8(:,31),28,G1H4(149),m3h8x4(:,252),heltab2x32(:,:,486))
  Gcoeff(:)%j = (c(18)*M(2,:)%j) * den(32)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(487),h0tab(:,487),[28,3],[nMW,nMW],2,2,wf8(:,32),wf4(:,4))
  call Hloop_UV_W(ntryL,G0H32(1),0,wf8(:,32),28,G1H4(150),m3h8x4(:,253),heltab2x32(:,:,487))
  Gcoeff(:)%j = (-(c(4)*M(2,:)%j)) * den(34)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(488),h0tab(:,488),[28,3],[nMW,nMW],2,2,wf8(:,31),wf4(:,1))
  call Hloop_VV_S(ntryL,G0H32(1),wf8(:,31),G0H4(36),m3h8x4(:,254),heltab2x32(:,:,488))
  Gcoeff(:)%j = (-(c(4)*M(2,:)%j)) * den(34)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(489),h0tab(:,489),[28,3],[nMW,nMW],2,2,wf8(:,31),wf4(:,1))
  call Hloop_VV_S(ntryL,G0H32(1),wf8(:,31),G0H4(37),m3h8x4(:,255),heltab2x32(:,:,489))
  Gcoeff(:)%j = (c(33)*M(2,:)%j) * den(31)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(490),h0tab(:,490),[28,3],[nMW,nMW],2,2,wf8(:,32),wf4(:,1))
  call Hloop_VV_S(ntryL,G0H32(1),wf8(:,32),G0H4(38),m3h8x4(:,256),heltab2x32(:,:,490))
  Gcoeff(:)%j = (c(33)*M(2,:)%j) * den(31)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(491),h0tab(:,491),[28,3],[nMW,nMW],2,2,wf8(:,32),wf4(:,1))
  call Hloop_VV_S(ntryL,G0H32(1),wf8(:,32),G0H4(39),m3h8x4(:,257),heltab2x32(:,:,491))
  Gcoeff(:)%j = (c(33)*M(2,:)%j) * den(35)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(492),h0tab(:,492),[28,3],[nMW,nMW],2,2,wf8(:,31),wf4(:,4))
  call Hloop_VV_S(ntryL,G0H32(1),wf8(:,31),G0H4(40),m3h8x4(:,258),heltab2x32(:,:,492))



end subroutine vamp_2

end module ol_vamp_2_ppttj_ew_uuxttxg_4_/**/REALKIND
