
module ol_vamp_10_ppttj_ew_ttxbbxg_3_/**/REALKIND
contains

! **********************************************************************
subroutine vamp_10(M)
! P(0:3,nlegs) = incoming external momenta
! Uses tree structures 'wf', factors 'c', and denominators 'den' from loop_ppttj_ew_ttxbbxg_3.
! Sets colour stripped amplitudes A from the module loop_amplitudes_ppttj_ew_ttxbbxg_3.
! **********************************************************************
  use KIND_TYPES, only: REALKIND, QREALKIND, intkind2
  use ol_parameters_decl_/**/DREALKIND, only: l_switch
  use ol_parameters_decl_/**/QREALKIND ! masses
  use ol_vert_interface_/**/REALKIND
  use ol_prop_interface_/**/REALKIND
  use ol_last_step_/**/REALKIND
  use ol_tables_storage_ppttj_ew_ttxbbxg_3_/**/DREALKIND
  use ol_tensor_sum_storage_ppttj_ew_ttxbbxg_3_/**/REALKIND
  use ol_loop_handling_/**/REALKIND
  use ofred_reduction_/**/REALKIND, only: Hotf_4pt_reduction, Hotf_4pt_reduction_last
  use ofred_reduction_/**/REALKIND, only: Hotf_5pt_reduction, Hotf_5pt_reduction_last
  use ol_loop_reduction_/**/REALKIND, only: TI_bubble_red, TI_triangle_red
use ol_loop_reduction_/**/REALKIND, only: compute_scalar_box

  use ol_loop_storage_ppttj_ew_ttxbbxg_3_/**/REALKIND
#ifndef PRECISION_dp
  use ol_loop_storage_ppttj_ew_ttxbbxg_3_/**/DREALKIND, only: &
    & p_switch, Hel, merge_step, merge_mism, merge_tables, merge_hels, ntryL
#endif
  use hol_initialisation_/**/REALKIND, only: G0_hol_initialisation
  use ol_h_vert_interface_/**/REALKIND
  use ol_h_prop_interface_/**/REALKIND
  use ol_h_last_step_/**/REALKIND
  use ol_merging_/**/REALKIND, only: ol_merge, ol_merge_tensors, ol_merge_last

  implicit none

  type(Hpolcont) :: Gcoeff(32)
  type(Hpolcont), intent(in) :: M(8,32)


#ifndef PRECISION_dp
  if (ntryL==1 .OR. p_switch == 1) Gcoeff(:)%hf = Hel
#else
  if (ntryL==1 .OR. p_switch == 2) Gcoeff(:)%hf = Hel
#endif

  ! =============================================
  Gcoeff(:)%j = (-(c(184)*M(1,:)%j)) * den(131)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(2746),h0tab(:,2746),[19,12],[nMB,nMB],2,2,wf8(:,20),wf4(:,18))
  call Hloop_QV_A(ntryL,G0H32(1),wf8(:,20),G0H4(189),m3h8x4(:,1088),heltab2x32(:,:,2746))
  call Hloop_Q_A(ntryL,G0H4(189),19,nMB,G1H4(492),n2h4(1013))
  Gcoeff(:)%j = (c(187)*M(1,:)%j) * den(102)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(2747),h0tab(:,2747),[19,12],[nME,nME],2,2,wf8(:,20),wf4(:,19))
  call Hloop_QV_A(ntryL,G0H32(1),wf8(:,20),G0H4(189),m3h8x4(:,1089),heltab2x32(:,:,2747))
  call Hloop_Q_A(ntryL,G0H4(189),19,nME,G1H4(493),n2h4(1014))
  Gcoeff(:)%j = (c(191)*M(1,:)%j) * den(102)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(2748),h0tab(:,2748),[19,12],[nMM,nMM],2,2,wf8(:,20),wf4(:,19))
  call Hloop_QV_A(ntryL,G0H32(1),wf8(:,20),G0H4(189),m3h8x4(:,1090),heltab2x32(:,:,2748))
  call Hloop_Q_A(ntryL,G0H4(189),19,nMM,G1H4(494),n2h4(1015))
  Gcoeff(:)%j = (c(189)*M(1,:)%j) * den(102)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(2749),h0tab(:,2749),[19,12],[nML,nML],2,2,wf8(:,20),wf4(:,19))
  call Hloop_QV_A(ntryL,G0H32(1),wf8(:,20),G0H4(189),m3h8x4(:,1091),heltab2x32(:,:,2749))
  call Hloop_Q_A(ntryL,G0H4(189),19,nML,G1H4(495),n2h4(1016))
  Gcoeff(:)%j = (c(194)*M(1,:)%j) * den(102)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(2750),h0tab(:,2750),[19,12],[nMT,nMT],2,2,wf8(:,20),wf4(:,19))
  call Hloop_QV_A(ntryL,G0H32(1),wf8(:,20),G0H4(189),m3h8x4(:,1092),heltab2x32(:,:,2750))
  call Hloop_Q_A(ntryL,G0H4(189),19,nMT,G1H4(496),n2h4(1017))
  Gcoeff(:)%j = (c(184)*M(1,:)%j) * den(102)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(2751),h0tab(:,2751),[19,12],[nMB,nMB],2,2,wf8(:,20),wf4(:,19))
  call Hloop_QV_A(ntryL,G0H32(1),wf8(:,20),G0H4(189),m3h8x4(:,1093),heltab2x32(:,:,2751))
  call Hloop_Q_A(ntryL,G0H4(189),19,nMB,G1H4(497),n2h4(1018))
  Gcoeff(:)%j = (c(188)*M(1,:)%j) * den(129)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(2752),h0tab(:,2752),[19,12],[nME,nME],2,2,wf8(:,21),wf4(:,18))
  call Hloop_QZ_A(ntryL,G0H32(1),wf8(:,21),G0H4(189),ngZl,m3h8x4(:,1094),heltab2x32(:,:,2752))
  call Hloop_Q_A(ntryL,G0H4(189),19,nME,G1H4(498),n2h4(1019))
  Gcoeff(:)%j = (c(192)*M(1,:)%j) * den(129)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(2753),h0tab(:,2753),[19,12],[nMM,nMM],2,2,wf8(:,21),wf4(:,18))
  call Hloop_QZ_A(ntryL,G0H32(1),wf8(:,21),G0H4(189),ngZl,m3h8x4(:,1095),heltab2x32(:,:,2753))
  call Hloop_Q_A(ntryL,G0H4(189),19,nMM,G1H4(499),n2h4(1020))
  Gcoeff(:)%j = (c(190)*M(1,:)%j) * den(129)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(2754),h0tab(:,2754),[19,12],[nML,nML],2,2,wf8(:,21),wf4(:,18))
  call Hloop_QZ_A(ntryL,G0H32(1),wf8(:,21),G0H4(189),ngZl,m3h8x4(:,1096),heltab2x32(:,:,2754))
  call Hloop_Q_A(ntryL,G0H4(189),19,nML,G1H4(500),n2h4(1021))
  Gcoeff(:)%j = (c(195)*M(1,:)%j) * den(129)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(2755),h0tab(:,2755),[19,12],[nMT,nMT],2,2,wf8(:,21),wf4(:,18))
  call Hloop_QZ_A(ntryL,G0H32(1),wf8(:,21),G0H4(189),ngZu,m3h8x4(:,1097),heltab2x32(:,:,2755))
  call Hloop_Q_A(ntryL,G0H4(189),19,nMT,G1H4(501),n2h4(1022))
  Gcoeff(:)%j = (c(185)*M(1,:)%j) * den(129)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(2756),h0tab(:,2756),[19,12],[nMB,nMB],2,2,wf8(:,21),wf4(:,18))
  call Hloop_QZ_A(ntryL,G0H32(1),wf8(:,21),G0H4(189),ngZd,m3h8x4(:,1098),heltab2x32(:,:,2756))
  call Hloop_Q_A(ntryL,G0H4(189),19,nMB,G1H4(502),n2h4(1023))
  Gcoeff(:)%j = (-(c(188)*M(1,:)%j)) * den(98)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(2757),h0tab(:,2757),[19,12],[nME,nME],2,2,wf8(:,21),wf4(:,19))
  call Hloop_QZ_A(ntryL,G0H32(1),wf8(:,21),G0H4(189),ngZl,m3h8x4(:,1099),heltab2x32(:,:,2757))
  call Hloop_Q_A(ntryL,G0H4(189),19,nME,G1H4(503),n2h4(1024))
  Gcoeff(:)%j = (-(c(192)*M(1,:)%j)) * den(98)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(2758),h0tab(:,2758),[19,12],[nMM,nMM],2,2,wf8(:,21),wf4(:,19))
  call Hloop_QZ_A(ntryL,G0H32(1),wf8(:,21),G0H4(189),ngZl,m3h8x4(:,1100),heltab2x32(:,:,2758))
  call Hloop_Q_A(ntryL,G0H4(189),19,nMM,G1H4(504),n2h4(1025))
  Gcoeff(:)%j = (-(c(190)*M(1,:)%j)) * den(98)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(2759),h0tab(:,2759),[19,12],[nML,nML],2,2,wf8(:,21),wf4(:,19))
  call Hloop_QZ_A(ntryL,G0H32(1),wf8(:,21),G0H4(189),ngZl,m3h8x4(:,1101),heltab2x32(:,:,2759))
  call Hloop_Q_A(ntryL,G0H4(189),19,nML,G1H4(505),n2h4(1026))
  Gcoeff(:)%j = (c(195)*M(1,:)%j) * den(98)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(2760),h0tab(:,2760),[19,12],[nMT,nMT],2,2,wf8(:,21),wf4(:,19))
  call Hloop_QZ_A(ntryL,G0H32(1),wf8(:,21),G0H4(189),ngZu,m3h8x4(:,1102),heltab2x32(:,:,2760))
  call Hloop_Q_A(ntryL,G0H4(189),19,nMT,G1H4(506),n2h4(1027))
  Gcoeff(:)%j = (-(c(185)*M(1,:)%j)) * den(98)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(2761),h0tab(:,2761),[19,12],[nMB,nMB],2,2,wf8(:,21),wf4(:,19))
  call Hloop_QZ_A(ntryL,G0H32(1),wf8(:,21),G0H4(189),ngZd,m3h8x4(:,1103),heltab2x32(:,:,2761))
  call Hloop_Q_A(ntryL,G0H4(189),19,nMB,G1H4(507),n2h4(1028))
  Gcoeff(:)%j = (-(c(111)*M(1,:)%j)) * den(131)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(2762),h0tab(:,2762),[19,12],[nMW,nMW],2,2,wf8(:,20),wf4(:,18))
  call Hloop_TV_S(ntryL,G0H32(1),0,wf8(:,20),19,G1H4(508),m3h8x4(:,1104),heltab2x32(:,:,2762))
  Gcoeff(:)%j = (c(142)*M(1,:)%j) * den(129)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(2763),h0tab(:,2763),[19,12],[nMW,nMW],2,2,wf8(:,21),wf4(:,18))
  call Hloop_TV_S(ntryL,G0H32(1),0,wf8(:,21),19,G1H4(509),m3h8x4(:,1105),heltab2x32(:,:,2763))
  Gcoeff(:)%j = (c(72)*M(1,:)%j) * den(98)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(2764),h0tab(:,2764),[19,12],[nMZ,nMH],2,2,wf8(:,21),wf4(:,19))
  call Hloop_TV_S(ntryL,G0H32(1),0,wf8(:,21),19,G1H4(510),m3h8x4(:,1106),heltab2x32(:,:,2764))
  Gcoeff(:)%j = (-(c(89)*M(1,:)%j)) * den(131)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(2765),h0tab(:,2765),[19,12],[nMW,nMW],2,2,wf8(:,20),wf4(:,18))
  call Hloop_CV_D(ntryL,G0H32(1),0,wf8(:,20),19,G1H4(511),m3h8x4(:,1107),heltab2x32(:,:,2765))
  Gcoeff(:)%j = (c(89)*M(1,:)%j) * den(131)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(2766),h0tab(:,2766),[19,12],[nMW,nMW],2,2,wf8(:,20),wf4(:,18))
  call Hloop_CV_D(ntryL,G0H32(1),0,wf8(:,20),19,G1H4(512),m3h8x4(:,1108),heltab2x32(:,:,2766))
  Gcoeff(:)%j = (c(89)*M(1,:)%j) * den(102)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(2767),h0tab(:,2767),[19,12],[nMW,nMW],2,2,wf8(:,20),wf4(:,19))
  call Hloop_CV_D(ntryL,G0H32(1),0,wf8(:,20),19,G1H4(513),m3h8x4(:,1109),heltab2x32(:,:,2767))
  Gcoeff(:)%j = (c(89)*M(1,:)%j) * den(102)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(2768),h0tab(:,2768),[19,12],[nMW,nMW],2,2,wf8(:,20),wf4(:,19))
  call Hloop_CV_D(ntryL,G0H32(1),0,wf8(:,20),19,G1H4(514),m3h8x4(:,1110),heltab2x32(:,:,2768))
  Gcoeff(:)%j = (-(c(66)*M(1,:)%j)) * den(129)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(2769),h0tab(:,2769),[19,12],[nMW,nMW],2,2,wf8(:,21),wf4(:,18))
  call Hloop_CV_D(ntryL,G0H32(1),0,wf8(:,21),19,G1H4(515),m3h8x4(:,1111),heltab2x32(:,:,2769))
  Gcoeff(:)%j = (c(66)*M(1,:)%j) * den(129)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(2770),h0tab(:,2770),[19,12],[nMW,nMW],2,2,wf8(:,21),wf4(:,18))
  call Hloop_CV_D(ntryL,G0H32(1),0,wf8(:,21),19,G1H4(516),m3h8x4(:,1112),heltab2x32(:,:,2770))
  Gcoeff(:)%j = (c(66)*M(1,:)%j) * den(98)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(2771),h0tab(:,2771),[19,12],[nMW,nMW],2,2,wf8(:,21),wf4(:,19))
  call Hloop_CV_D(ntryL,G0H32(1),0,wf8(:,21),19,G1H4(517),m3h8x4(:,1113),heltab2x32(:,:,2771))
  Gcoeff(:)%j = (c(66)*M(1,:)%j) * den(98)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(2772),h0tab(:,2772),[19,12],[nMW,nMW],2,2,wf8(:,21),wf4(:,19))
  call Hloop_CV_D(ntryL,G0H32(1),0,wf8(:,21),19,G1H4(518),m3h8x4(:,1114),heltab2x32(:,:,2772))
  Gcoeff(:)%j = (-(c(90)*M(1,:)%j)) * den(131)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(2773),h0tab(:,2773),[19,12],[nMW,nMW],2,2,wf8(:,20),wf4(:,18))
  call Hloop_UV_W(ntryL,G0H32(1),0,wf8(:,20),19,G1H4(519),m3h8x4(:,1115),heltab2x32(:,:,2773))
  Gcoeff(:)%j = (-(c(67)*M(1,:)%j)) * den(129)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(2774),h0tab(:,2774),[19,12],[nMW,nMW],2,2,wf8(:,21),wf4(:,18))
  call Hloop_UV_W(ntryL,G0H32(1),0,wf8(:,21),19,G1H4(520),m3h8x4(:,1116),heltab2x32(:,:,2774))
  Gcoeff(:)%j = (-(c(89)*M(1,:)%j)) * den(131)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(2775),h0tab(:,2775),[19,12],[nMW,nMW],2,2,wf8(:,20),wf4(:,18))
  call Hloop_SV_V(ntryL,G0H32(1),wf8(:,20),G0H4(189),m3h8x4(:,1117),heltab2x32(:,:,2775))
  Gcoeff(:)%j = (c(89)*M(1,:)%j) * den(131)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(2776),h0tab(:,2776),[19,12],[nMW,nMW],2,2,wf8(:,20),wf4(:,18))
  call Hloop_SV_V(ntryL,G0H32(1),wf8(:,20),G0H4(190),m3h8x4(:,1118),heltab2x32(:,:,2776))
  Gcoeff(:)%j = (c(89)*M(1,:)%j) * den(102)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(2777),h0tab(:,2777),[19,12],[nMW,nMW],2,2,wf8(:,20),wf4(:,19))
  call Hloop_SV_V(ntryL,G0H32(1),wf8(:,20),G0H4(191),m3h8x4(:,1119),heltab2x32(:,:,2777))
  Gcoeff(:)%j = (c(89)*M(1,:)%j) * den(102)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(2778),h0tab(:,2778),[19,12],[nMW,nMW],2,2,wf8(:,20),wf4(:,19))
  call Hloop_SV_V(ntryL,G0H32(1),wf8(:,20),G0H4(192),m3h8x4(:,1120),heltab2x32(:,:,2778))
  Gcoeff(:)%j = (c(132)*M(1,:)%j) * den(129)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(2779),h0tab(:,2779),[19,12],[nMW,nMW],2,2,wf8(:,21),wf4(:,18))
  call Hloop_SV_V(ntryL,G0H32(1),wf8(:,21),G0H4(193),m3h8x4(:,1121),heltab2x32(:,:,2779))
  Gcoeff(:)%j = (-(c(132)*M(1,:)%j)) * den(129)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(2780),h0tab(:,2780),[19,12],[nMW,nMW],2,2,wf8(:,21),wf4(:,18))
  call Hloop_SV_V(ntryL,G0H32(1),wf8(:,21),G0H4(194),m3h8x4(:,1122),heltab2x32(:,:,2780))
  Gcoeff(:)%j = (c(65)*M(1,:)%j) * den(98)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(2781),h0tab(:,2781),[19,12],[nMZ,nMH],2,2,wf8(:,21),wf4(:,19))
  call Hloop_SV_V(ntryL,G0H32(1),wf8(:,21),G0H4(195),m3h8x4(:,1123),heltab2x32(:,:,2781))
  Gcoeff(:)%j = (-(c(132)*M(1,:)%j)) * den(98)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(2782),h0tab(:,2782),[19,12],[nMW,nMW],2,2,wf8(:,21),wf4(:,19))
  call Hloop_SV_V(ntryL,G0H32(1),wf8(:,21),G0H4(196),m3h8x4(:,1124),heltab2x32(:,:,2782))
  Gcoeff(:)%j = (-(c(132)*M(1,:)%j)) * den(98)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(2783),h0tab(:,2783),[19,12],[nMW,nMW],2,2,wf8(:,21),wf4(:,19))
  call Hloop_SV_V(ntryL,G0H32(1),wf8(:,21),G0H4(197),m3h8x4(:,1125),heltab2x32(:,:,2783))
  Gcoeff(:)%j = (c(152)*M(1,:)%j) * den(103)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(2784),h0tab(:,2784),[19,12],[nME,nME],2,2,wf8(:,20),wf4(:,2))
  call Hloop_QV_A(ntryL,G0H32(1),wf8(:,20),G0H4(198),m3h8x4(:,1126),heltab2x32(:,:,2784))
  call Hloop_Q_A(ntryL,G0H4(198),19,nME,G1H4(521),n2h4(1029))
  Gcoeff(:)%j = (c(152)*M(1,:)%j) * den(103)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(2785),h0tab(:,2785),[19,12],[nMM,nMM],2,2,wf8(:,20),wf4(:,2))
  call Hloop_QV_A(ntryL,G0H32(1),wf8(:,20),G0H4(198),m3h8x4(:,1127),heltab2x32(:,:,2785))
  call Hloop_Q_A(ntryL,G0H4(198),19,nMM,G1H4(522),n2h4(1030))
  Gcoeff(:)%j = (c(152)*M(1,:)%j) * den(103)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(2786),h0tab(:,2786),[19,12],[nML,nML],2,2,wf8(:,20),wf4(:,2))
  call Hloop_QV_A(ntryL,G0H32(1),wf8(:,20),G0H4(198),m3h8x4(:,1128),heltab2x32(:,:,2786))
  call Hloop_Q_A(ntryL,G0H4(198),19,nML,G1H4(523),n2h4(1031))
  Gcoeff(:)%j = (c(151)*M(1,:)%j) * den(103)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(2787),h0tab(:,2787),[19,12],[0,0],2,2,wf8(:,20),wf4(:,2))
  call Hloop_QV_A(ntryL,G0H32(1),wf8(:,20),G0H4(198),m3h8x4(:,1129),heltab2x32(:,:,2787))
  call Hloop_Q_A(ntryL,G0H4(198),19,0,G1H4(524),n2h4(1032))
  Gcoeff(:)%j = (c(149)*M(1,:)%j) * den(103)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(2788),h0tab(:,2788),[19,12],[nMT,nMT],2,2,wf8(:,20),wf4(:,2))
  call Hloop_QV_A(ntryL,G0H32(1),wf8(:,20),G0H4(198),m3h8x4(:,1130),heltab2x32(:,:,2788))
  call Hloop_Q_A(ntryL,G0H4(198),19,nMT,G1H4(525),n2h4(1033))
  Gcoeff(:)%j = (c(148)*M(1,:)%j) * den(103)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(2789),h0tab(:,2789),[19,12],[0,0],2,2,wf8(:,20),wf4(:,2))
  call Hloop_QV_A(ntryL,G0H32(1),wf8(:,20),G0H4(198),m3h8x4(:,1131),heltab2x32(:,:,2789))
  call Hloop_Q_A(ntryL,G0H4(198),19,0,G1H4(526),n2h4(1034))
  Gcoeff(:)%j = (c(147)*M(1,:)%j) * den(103)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(2790),h0tab(:,2790),[19,12],[nMB,nMB],2,2,wf8(:,20),wf4(:,2))
  call Hloop_QV_A(ntryL,G0H32(1),wf8(:,20),G0H4(198),m3h8x4(:,1132),heltab2x32(:,:,2790))
  call Hloop_Q_A(ntryL,G0H4(198),19,nMB,G1H4(527),n2h4(1035))
  Gcoeff(:)%j = (c(156)*M(1,:)%j) * den(102)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(2791),h0tab(:,2791),[19,12],[nME,nME],2,2,wf8(:,20),wf4(:,20))
  call Hloop_QV_A(ntryL,G0H32(1),wf8(:,20),G0H4(198),m3h8x4(:,1133),heltab2x32(:,:,2791))
  call Hloop_Q_A(ntryL,G0H4(198),19,nME,G1H4(528),n2h4(1036))
  Gcoeff(:)%j = (c(156)*M(1,:)%j) * den(102)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(2792),h0tab(:,2792),[19,12],[nMM,nMM],2,2,wf8(:,20),wf4(:,20))
  call Hloop_QV_A(ntryL,G0H32(1),wf8(:,20),G0H4(198),m3h8x4(:,1134),heltab2x32(:,:,2792))
  call Hloop_Q_A(ntryL,G0H4(198),19,nMM,G1H4(529),n2h4(1037))
  Gcoeff(:)%j = (c(156)*M(1,:)%j) * den(102)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(2793),h0tab(:,2793),[19,12],[nML,nML],2,2,wf8(:,20),wf4(:,20))
  call Hloop_QV_A(ntryL,G0H32(1),wf8(:,20),G0H4(198),m3h8x4(:,1135),heltab2x32(:,:,2793))
  call Hloop_Q_A(ntryL,G0H4(198),19,nML,G1H4(530),n2h4(1038))
  Gcoeff(:)%j = (-(c(157)*M(1,:)%j)) * den(102)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(2794),h0tab(:,2794),[19,12],[0,0],2,2,wf8(:,20),wf4(:,20))
  call Hloop_QV_A(ntryL,G0H32(1),wf8(:,20),G0H4(198),m3h8x4(:,1136),heltab2x32(:,:,2794))
  call Hloop_Q_A(ntryL,G0H4(198),19,0,G1H4(531),n2h4(1039))
  Gcoeff(:)%j = (-(c(155)*M(1,:)%j)) * den(102)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(2795),h0tab(:,2795),[19,12],[nMT,nMT],2,2,wf8(:,20),wf4(:,20))
  call Hloop_QV_A(ntryL,G0H32(1),wf8(:,20),G0H4(198),m3h8x4(:,1137),heltab2x32(:,:,2795))
  call Hloop_Q_A(ntryL,G0H4(198),19,nMT,G1H4(532),n2h4(1040))
  Gcoeff(:)%j = (c(155)*M(1,:)%j) * den(102)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(2796),h0tab(:,2796),[19,12],[0,0],2,2,wf8(:,20),wf4(:,20))
  call Hloop_QV_A(ntryL,G0H32(1),wf8(:,20),G0H4(198),m3h8x4(:,1138),heltab2x32(:,:,2796))
  call Hloop_Q_A(ntryL,G0H4(198),19,0,G1H4(533),n2h4(1041))
  Gcoeff(:)%j = (c(153)*M(1,:)%j) * den(102)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(2797),h0tab(:,2797),[19,12],[nMB,nMB],2,2,wf8(:,20),wf4(:,20))
  call Hloop_QV_A(ntryL,G0H32(1),wf8(:,20),G0H4(198),m3h8x4(:,1139),heltab2x32(:,:,2797))
  call Hloop_Q_A(ntryL,G0H4(198),19,nMB,G1H4(534),n2h4(1042))
  Gcoeff(:)%j = (-(c(154)*M(1,:)%j)) * den(99)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(2798),h0tab(:,2798),[19,12],[nME,nME],2,2,wf8(:,21),wf4(:,2))
  call Hloop_QZ_A(ntryL,G0H32(1),wf8(:,21),G0H4(198),ngZl,m3h8x4(:,1140),heltab2x32(:,:,2798))
  call Hloop_Q_A(ntryL,G0H4(198),19,nME,G1H4(535),n2h4(1043))
  Gcoeff(:)%j = (-(c(154)*M(1,:)%j)) * den(99)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(2799),h0tab(:,2799),[19,12],[nMM,nMM],2,2,wf8(:,21),wf4(:,2))
  call Hloop_QZ_A(ntryL,G0H32(1),wf8(:,21),G0H4(198),ngZl,m3h8x4(:,1141),heltab2x32(:,:,2799))
  call Hloop_Q_A(ntryL,G0H4(198),19,nMM,G1H4(536),n2h4(1044))
  Gcoeff(:)%j = (-(c(154)*M(1,:)%j)) * den(99)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(2800),h0tab(:,2800),[19,12],[nML,nML],2,2,wf8(:,21),wf4(:,2))
  call Hloop_QZ_A(ntryL,G0H32(1),wf8(:,21),G0H4(198),ngZl,m3h8x4(:,1142),heltab2x32(:,:,2800))
  call Hloop_Q_A(ntryL,G0H4(198),19,nML,G1H4(537),n2h4(1045))
  Gcoeff(:)%j = (c(155)*M(1,:)%j) * den(99)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(2801),h0tab(:,2801),[19,12],[0,0],2,2,wf8(:,21),wf4(:,2))
  call Hloop_QZ_A(ntryL,G0H32(1),wf8(:,21),G0H4(198),ngZu,m3h8x4(:,1143),heltab2x32(:,:,2801))
  call Hloop_Q_A(ntryL,G0H4(198),19,0,G1H4(538),n2h4(1046))
  Gcoeff(:)%j = (c(153)*M(1,:)%j) * den(99)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(2802),h0tab(:,2802),[19,12],[nMT,nMT],2,2,wf8(:,21),wf4(:,2))
  call Hloop_QZ_A(ntryL,G0H32(1),wf8(:,21),G0H4(198),ngZu,m3h8x4(:,1144),heltab2x32(:,:,2802))
  call Hloop_Q_A(ntryL,G0H4(198),19,nMT,G1H4(539),n2h4(1047))
  Gcoeff(:)%j = (-(c(153)*M(1,:)%j)) * den(99)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(2803),h0tab(:,2803),[19,12],[0,0],2,2,wf8(:,21),wf4(:,2))
  call Hloop_QZ_A(ntryL,G0H32(1),wf8(:,21),G0H4(198),ngZd,m3h8x4(:,1145),heltab2x32(:,:,2803))
  call Hloop_Q_A(ntryL,G0H4(198),19,0,G1H4(540),n2h4(1048))
  Gcoeff(:)%j = (-(c(150)*M(1,:)%j)) * den(99)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(2804),h0tab(:,2804),[19,12],[nMB,nMB],2,2,wf8(:,21),wf4(:,2))
  call Hloop_QZ_A(ntryL,G0H32(1),wf8(:,21),G0H4(198),ngZd,m3h8x4(:,1146),heltab2x32(:,:,2804))
  call Hloop_Q_A(ntryL,G0H4(198),19,nMB,G1H4(541),n2h4(1049))
  Gcoeff(:)%j = (-(c(161)*M(1,:)%j)) * den(98)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(2805),h0tab(:,2805),[19,12],[0,0],2,2,wf8(:,21),wf4(:,20))
  call Hloop_QZ_A(ntryL,G0H32(1),wf8(:,21),G0H4(198),ngZn,m3h8x4(:,1147),heltab2x32(:,:,2805))
  call Hloop_Q_A(ntryL,G0H4(198),19,0,G1H4(542),n2h4(1050))
  Gcoeff(:)%j = (-(c(158)*M(1,:)%j)) * den(98)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(2806),h0tab(:,2806),[19,12],[nME,nME],2,2,wf8(:,21),wf4(:,20))
  call Hloop_QZ_A(ntryL,G0H32(1),wf8(:,21),G0H4(198),ngZl,m3h8x4(:,1148),heltab2x32(:,:,2806))
  call Hloop_Q_A(ntryL,G0H4(198),19,nME,G1H4(543),n2h4(1051))
  Gcoeff(:)%j = (-(c(158)*M(1,:)%j)) * den(98)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(2807),h0tab(:,2807),[19,12],[nMM,nMM],2,2,wf8(:,21),wf4(:,20))
  call Hloop_QZ_A(ntryL,G0H32(1),wf8(:,21),G0H4(198),ngZl,m3h8x4(:,1149),heltab2x32(:,:,2807))
  call Hloop_Q_A(ntryL,G0H4(198),19,nMM,G1H4(544),n2h4(1052))
  Gcoeff(:)%j = (-(c(158)*M(1,:)%j)) * den(98)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(2808),h0tab(:,2808),[19,12],[nML,nML],2,2,wf8(:,21),wf4(:,20))
  call Hloop_QZ_A(ntryL,G0H32(1),wf8(:,21),G0H4(198),ngZl,m3h8x4(:,1150),heltab2x32(:,:,2808))
  call Hloop_Q_A(ntryL,G0H4(198),19,nML,G1H4(545),n2h4(1053))
  Gcoeff(:)%j = (-(c(160)*M(1,:)%j)) * den(98)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(2809),h0tab(:,2809),[19,12],[0,0],2,2,wf8(:,21),wf4(:,20))
  call Hloop_QZ_A(ntryL,G0H32(1),wf8(:,21),G0H4(198),ngZu,m3h8x4(:,1151),heltab2x32(:,:,2809))
  call Hloop_Q_A(ntryL,G0H4(198),19,0,G1H4(546),n2h4(1054))
  Gcoeff(:)%j = (-(c(159)*M(1,:)%j)) * den(98)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(2810),h0tab(:,2810),[19,12],[nMT,nMT],2,2,wf8(:,21),wf4(:,20))
  call Hloop_QZ_A(ntryL,G0H32(1),wf8(:,21),G0H4(198),ngZu,m3h8x4(:,1152),heltab2x32(:,:,2810))
  call Hloop_Q_A(ntryL,G0H4(198),19,nMT,G1H4(547),n2h4(1055))
  Gcoeff(:)%j = (-(c(160)*M(1,:)%j)) * den(98)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(2811),h0tab(:,2811),[19,12],[0,0],2,2,wf8(:,21),wf4(:,20))
  call Hloop_QZ_A(ntryL,G0H32(1),wf8(:,21),G0H4(198),ngZd,m3h8x4(:,1153),heltab2x32(:,:,2811))
  call Hloop_Q_A(ntryL,G0H4(198),19,0,G1H4(548),n2h4(1056))
  Gcoeff(:)%j = (-(c(159)*M(1,:)%j)) * den(98)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(2812),h0tab(:,2812),[19,12],[nMB,nMB],2,2,wf8(:,21),wf4(:,20))
  call Hloop_QZ_A(ntryL,G0H32(1),wf8(:,21),G0H4(198),ngZd,m3h8x4(:,1154),heltab2x32(:,:,2812))
  call Hloop_Q_A(ntryL,G0H4(198),19,nMB,G1H4(549),n2h4(1057))
  Gcoeff(:)%j = (-(c(5)*M(1,:)%j)) * den(103)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(2813),h0tab(:,2813),[19,12],[nMW,nMW],2,2,wf8(:,20),wf4(:,2))
  call Hloop_TV_S(ntryL,G0H32(1),0,wf8(:,20),19,G1H4(550),m3h8x4(:,1155),heltab2x32(:,:,2813))
  Gcoeff(:)%j = (-(c(145)*M(1,:)%j)) * den(102)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(2814),h0tab(:,2814),[19,12],[nMW,nMW],2,2,wf8(:,20),wf4(:,20))
  call Hloop_TV_S(ntryL,G0H32(1),0,wf8(:,20),19,G1H4(551),m3h8x4(:,1156),heltab2x32(:,:,2814))
  Gcoeff(:)%j = (c(144)*M(1,:)%j) * den(99)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(2815),h0tab(:,2815),[19,12],[nMW,nMW],2,2,wf8(:,21),wf4(:,2))
  call Hloop_TV_S(ntryL,G0H32(1),0,wf8(:,21),19,G1H4(552),m3h8x4(:,1157),heltab2x32(:,:,2815))
  Gcoeff(:)%j = (-(c(82)*M(1,:)%j)) * den(98)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(2816),h0tab(:,2816),[19,12],[nMZ,nMH],2,2,wf8(:,21),wf4(:,20))
  call Hloop_TV_S(ntryL,G0H32(1),0,wf8(:,21),19,G1H4(553),m3h8x4(:,1158),heltab2x32(:,:,2816))
  Gcoeff(:)%j = (c(146)*M(1,:)%j) * den(98)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(2817),h0tab(:,2817),[19,12],[nMW,nMW],2,2,wf8(:,21),wf4(:,20))
  call Hloop_TV_S(ntryL,G0H32(1),0,wf8(:,21),19,G1H4(554),m3h8x4(:,1159),heltab2x32(:,:,2817))
  Gcoeff(:)%j = (c(5)*M(1,:)%j) * den(103)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(2818),h0tab(:,2818),[19,12],[nMW,nMW],2,2,wf8(:,20),wf4(:,2))
  call Hloop_CV_D(ntryL,G0H32(1),0,wf8(:,20),19,G1H4(555),m3h8x4(:,1160),heltab2x32(:,:,2818))
  Gcoeff(:)%j = (c(5)*M(1,:)%j) * den(103)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(2819),h0tab(:,2819),[19,12],[nMW,nMW],2,2,wf8(:,20),wf4(:,2))
  call Hloop_CV_D(ntryL,G0H32(1),0,wf8(:,20),19,G1H4(556),m3h8x4(:,1161),heltab2x32(:,:,2819))
  Gcoeff(:)%j = (-(c(131)*M(1,:)%j)) * den(102)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(2820),h0tab(:,2820),[19,12],[nMW,nMW],2,2,wf8(:,20),wf4(:,20))
  call Hloop_CV_D(ntryL,G0H32(1),0,wf8(:,20),19,G1H4(557),m3h8x4(:,1162),heltab2x32(:,:,2820))
  Gcoeff(:)%j = (-(c(131)*M(1,:)%j)) * den(102)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(2821),h0tab(:,2821),[19,12],[nMW,nMW],2,2,wf8(:,20),wf4(:,20))
  call Hloop_CV_D(ntryL,G0H32(1),0,wf8(:,20),19,G1H4(558),m3h8x4(:,1163),heltab2x32(:,:,2821))
  Gcoeff(:)%j = (c(130)*M(1,:)%j) * den(99)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(2822),h0tab(:,2822),[19,12],[nMW,nMW],2,2,wf8(:,21),wf4(:,2))
  call Hloop_CV_D(ntryL,G0H32(1),0,wf8(:,21),19,G1H4(559),m3h8x4(:,1164),heltab2x32(:,:,2822))
  Gcoeff(:)%j = (c(130)*M(1,:)%j) * den(99)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(2823),h0tab(:,2823),[19,12],[nMW,nMW],2,2,wf8(:,21),wf4(:,2))
  call Hloop_CV_D(ntryL,G0H32(1),0,wf8(:,21),19,G1H4(560),m3h8x4(:,1165),heltab2x32(:,:,2823))
  Gcoeff(:)%j = (-(c(83)*M(1,:)%j)) * den(98)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(2824),h0tab(:,2824),[19,12],[nMW,nMW],2,2,wf8(:,21),wf4(:,20))
  call Hloop_CV_D(ntryL,G0H32(1),0,wf8(:,21),19,G1H4(561),m3h8x4(:,1166),heltab2x32(:,:,2824))
  Gcoeff(:)%j = (-(c(83)*M(1,:)%j)) * den(98)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(2825),h0tab(:,2825),[19,12],[nMW,nMW],2,2,wf8(:,21),wf4(:,20))
  call Hloop_CV_D(ntryL,G0H32(1),0,wf8(:,21),19,G1H4(562),m3h8x4(:,1167),heltab2x32(:,:,2825))
  Gcoeff(:)%j = (-(c(5)*M(1,:)%j)) * den(103)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(2826),h0tab(:,2826),[19,12],[nMW,nMW],2,2,wf8(:,20),wf4(:,2))
  call Hloop_UV_W(ntryL,G0H32(1),0,wf8(:,20),19,G1H4(563),m3h8x4(:,1168),heltab2x32(:,:,2826))
  Gcoeff(:)%j = (c(131)*M(1,:)%j) * den(102)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(2827),h0tab(:,2827),[19,12],[nMW,nMW],2,2,wf8(:,20),wf4(:,20))
  call Hloop_UV_W(ntryL,G0H32(1),0,wf8(:,20),19,G1H4(564),m3h8x4(:,1169),heltab2x32(:,:,2827))
  Gcoeff(:)%j = (-(c(130)*M(1,:)%j)) * den(99)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(2828),h0tab(:,2828),[19,12],[nMW,nMW],2,2,wf8(:,21),wf4(:,2))
  call Hloop_UV_W(ntryL,G0H32(1),0,wf8(:,21),19,G1H4(565),m3h8x4(:,1170),heltab2x32(:,:,2828))
  Gcoeff(:)%j = (c(83)*M(1,:)%j) * den(98)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(2829),h0tab(:,2829),[19,12],[nMW,nMW],2,2,wf8(:,21),wf4(:,20))
  call Hloop_UV_W(ntryL,G0H32(1),0,wf8(:,21),19,G1H4(566),m3h8x4(:,1171),heltab2x32(:,:,2829))
  Gcoeff(:)%j = (c(25)*M(1,:)%j) * den(103)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(2830),h0tab(:,2830),[19,12],[nMW,nMW],2,2,wf8(:,20),wf4(:,2))
  call Hloop_SV_V(ntryL,G0H32(1),wf8(:,20),G0H4(198),m3h8x4(:,1172),heltab2x32(:,:,2830))
  Gcoeff(:)%j = (c(25)*M(1,:)%j) * den(103)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(2831),h0tab(:,2831),[19,12],[nMW,nMW],2,2,wf8(:,20),wf4(:,2))
  call Hloop_SV_V(ntryL,G0H32(1),wf8(:,20),G0H4(199),m3h8x4(:,1173),heltab2x32(:,:,2831))
  Gcoeff(:)%j = (c(135)*M(1,:)%j) * den(102)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(2832),h0tab(:,2832),[19,12],[nMW,nMW],2,2,wf8(:,20),wf4(:,20))
  call Hloop_SV_V(ntryL,G0H32(1),wf8(:,20),G0H4(200),m3h8x4(:,1174),heltab2x32(:,:,2832))
  Gcoeff(:)%j = (c(135)*M(1,:)%j) * den(102)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(2833),h0tab(:,2833),[19,12],[nMW,nMW],2,2,wf8(:,20),wf4(:,20))
  call Hloop_SV_V(ntryL,G0H32(1),wf8(:,20),G0H4(201),m3h8x4(:,1175),heltab2x32(:,:,2833))
  Gcoeff(:)%j = (-(c(134)*M(1,:)%j)) * den(99)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(2834),h0tab(:,2834),[19,12],[nMW,nMW],2,2,wf8(:,21),wf4(:,2))
  call Hloop_SV_V(ntryL,G0H32(1),wf8(:,21),G0H4(202),m3h8x4(:,1176),heltab2x32(:,:,2834))
  Gcoeff(:)%j = (-(c(134)*M(1,:)%j)) * den(99)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(2835),h0tab(:,2835),[19,12],[nMW,nMW],2,2,wf8(:,21),wf4(:,2))
  call Hloop_SV_V(ntryL,G0H32(1),wf8(:,21),G0H4(203),m3h8x4(:,1177),heltab2x32(:,:,2835))
  Gcoeff(:)%j = (-(c(128)*M(1,:)%j)) * den(98)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(2836),h0tab(:,2836),[19,12],[nMZ,nMH],2,2,wf8(:,21),wf4(:,20))
  call Hloop_SV_V(ntryL,G0H32(1),wf8(:,21),G0H4(204),m3h8x4(:,1178),heltab2x32(:,:,2836))
  Gcoeff(:)%j = (-(c(136)*M(1,:)%j)) * den(98)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(2837),h0tab(:,2837),[19,12],[nMW,nMW],2,2,wf8(:,21),wf4(:,20))
  call Hloop_SV_V(ntryL,G0H32(1),wf8(:,21),G0H4(205),m3h8x4(:,1179),heltab2x32(:,:,2837))
  Gcoeff(:)%j = (-(c(136)*M(1,:)%j)) * den(98)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(2838),h0tab(:,2838),[19,12],[nMW,nMW],2,2,wf8(:,21),wf4(:,20))
  call Hloop_SV_V(ntryL,G0H32(1),wf8(:,21),G0H4(206),m3h8x4(:,1180),heltab2x32(:,:,2838))
  Gcoeff(:)%j = (c(52)*M(1,:)%j) * den(88)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(2839),h0tab(:,2839),[17,14],[nMH,nMT],2,2,wf4(:,12),wf8(:,159))
  call Hloop_AQ_S(ntryL,G0H32(1),wf4(:,12),G0H8(138),ngH,m3h4x8(:,889),heltab2x32(:,:,2839))
  Gcoeff(:)%j = (-(c(52)*M(1,:)%j)) * den(88)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(2840),h0tab(:,2840),[17,14],[nMZ,nMT],2,2,wf4(:,12),wf8(:,159))
  call Hloop_AQ_S(ntryL,G0H32(1),wf4(:,12),G0H8(3),ngX,m3h4x8(:,890),heltab2x32(:,:,2840))
  Gcoeff(:)%j = (-(c(40)*M(1,:)%j)) * den(88)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(2841),h0tab(:,2841),[17,14],[nMW,nMB],2,2,wf4(:,12),wf8(:,159))
  call Hloop_AQ_S(ntryL,G0H32(1),wf4(:,12),G0H8(4),ngPbt,m3h4x8(:,891),heltab2x32(:,:,2841))
  Gcoeff(:)%j = (c(52)*M(1,:)%j) * den(90)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(2842),h0tab(:,2842),[17,14],[nMH,nMT],2,2,wf4(:,12),wf8(:,161))
  call Hloop_AQ_S(ntryL,G0H32(1),wf4(:,12),G0H8(28),ngH,m3h4x8(:,892),heltab2x32(:,:,2842))
  Gcoeff(:)%j = (-(c(52)*M(1,:)%j)) * den(90)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(2843),h0tab(:,2843),[17,14],[nMZ,nMT],2,2,wf4(:,12),wf8(:,161))
  call Hloop_AQ_S(ntryL,G0H32(1),wf4(:,12),G0H8(22),ngX,m3h4x8(:,893),heltab2x32(:,:,2843))
  Gcoeff(:)%j = (-(c(40)*M(1,:)%j)) * den(90)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(2844),h0tab(:,2844),[17,14],[nMW,nMB],2,2,wf4(:,12),wf8(:,161))
  call Hloop_AQ_S(ntryL,G0H32(1),wf4(:,12),G0H8(59),ngPbt,m3h4x8(:,894),heltab2x32(:,:,2844))
  Gcoeff(:)%j = (-(c(114)*M(1,:)%j)) * den(88)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(2845),h0tab(:,2845),[17,14],[0,nMT],2,2,wf4(:,12),wf8(:,159))
  call Hloop_AQ_V(ntryL,G0H32(1),wf4(:,12),G0H8(60),m3h4x8(:,895),heltab2x32(:,:,2845))
  Gcoeff(:)%j = (-(c(115)*M(1,:)%j)) * den(88)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(2846),h0tab(:,2846),[17,14],[nMZ,nMT],2,2,wf4(:,12),wf8(:,159))
  call Hloop_AQ_Z(ntryL,G0H32(1),wf4(:,12),G0H8(67),ngZu,m3h4x8(:,896),heltab2x32(:,:,2846))
  Gcoeff(:)%j = (-(c(60)*M(1,:)%j)) * den(88)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(2847),h0tab(:,2847),[17,14],[nMW,nMB],2,2,wf4(:,12),wf8(:,159))
  call Hloop_AQ_W(ntryL,G0H32(1),wf4(:,12),G0H8(62),m3h4x8(:,897),heltab2x32(:,:,2847))
  Gcoeff(:)%j = (-(c(120)*M(2,:)%j)) * den(88)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(2848),h0tab(:,2848),[17,14],[0,nMT],2,2,wf4(:,12),wf8(:,159))
  call Hloop_AQ_V(ntryL,G0H32(1),wf4(:,12),G0H8(100),m3h4x8(:,898),heltab2x32(:,:,2848))
  Gcoeff(:)%j = (-(c(114)*M(1,:)%j)) * den(90)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(2849),h0tab(:,2849),[17,14],[0,nMT],2,2,wf4(:,12),wf8(:,161))
  call Hloop_AQ_V(ntryL,G0H32(1),wf4(:,12),G0H8(101),m3h4x8(:,899),heltab2x32(:,:,2849))
  Gcoeff(:)%j = (-(c(115)*M(1,:)%j)) * den(90)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(2850),h0tab(:,2850),[17,14],[nMZ,nMT],2,2,wf4(:,12),wf8(:,161))
  call Hloop_AQ_Z(ntryL,G0H32(1),wf4(:,12),G0H8(148),ngZu,m3h4x8(:,900),heltab2x32(:,:,2850))
  Gcoeff(:)%j = (-(c(60)*M(1,:)%j)) * den(90)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(2851),h0tab(:,2851),[17,14],[nMW,nMB],2,2,wf4(:,12),wf8(:,161))
  call Hloop_AQ_W(ntryL,G0H32(1),wf4(:,12),G0H8(133),m3h4x8(:,901),heltab2x32(:,:,2851))
  Gcoeff(:)%j = (-(c(120)*M(2,:)%j)) * den(90)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(2852),h0tab(:,2852),[17,14],[0,nMT],2,2,wf4(:,12),wf8(:,161))
  call Hloop_AQ_V(ntryL,G0H32(1),wf4(:,12),G0H8(168),m3h4x8(:,902),heltab2x32(:,:,2852))
  Gcoeff(:)%j = (c(122)*M(1,:)%j) * den(92)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(2853),h0tab(:,2853),[17,14],[nMH,nMT],2,2,wf4(:,12),wf8(:,163))
  call Hloop_AQ_S(ntryL,G0H32(1),wf4(:,12),G0H8(175),ngH,m3h4x8(:,903),heltab2x32(:,:,2853))
  Gcoeff(:)%j = (-(c(122)*M(1,:)%j)) * den(92)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(2854),h0tab(:,2854),[17,14],[nMZ,nMT],2,2,wf4(:,12),wf8(:,163))
  call Hloop_AQ_S(ntryL,G0H32(1),wf4(:,12),G0H8(176),ngX,m3h4x8(:,904),heltab2x32(:,:,2854))
  Gcoeff(:)%j = (-(c(96)*M(1,:)%j)) * den(92)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(2855),h0tab(:,2855),[17,14],[nMW,nMB],2,2,wf4(:,12),wf8(:,163))
  call Hloop_AQ_S(ntryL,G0H32(1),wf4(:,12),G0H8(182),ngPbt,m3h4x8(:,905),heltab2x32(:,:,2855))
  Gcoeff(:)%j = (-(c(123)*M(1,:)%j)) * den(90)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(2856),h0tab(:,2856),[17,14],[nMH,nMT],2,2,wf4(:,12),wf8(:,165))
  call Hloop_AQ_S(ntryL,G0H32(1),wf4(:,12),G0H8(184),ngH,m3h4x8(:,906),heltab2x32(:,:,2856))
  Gcoeff(:)%j = (c(123)*M(1,:)%j) * den(90)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(2857),h0tab(:,2857),[17,14],[nMZ,nMT],2,2,wf4(:,12),wf8(:,165))
  call Hloop_AQ_S(ntryL,G0H32(1),wf4(:,12),G0H8(183),ngX,m3h4x8(:,907),heltab2x32(:,:,2857))
  Gcoeff(:)%j = (c(100)*M(1,:)%j) * den(90)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(2858),h0tab(:,2858),[17,14],[nMW,nMB],2,2,wf4(:,12),wf8(:,165))
  call Hloop_AQ_S(ntryL,G0H32(1),wf4(:,12),G0H8(71),ngPbt,m3h4x8(:,908),heltab2x32(:,:,2858))
  Gcoeff(:)%j = (c(125)*M(2,:)%j-c(126)*M(6,:)%j) * den(92)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(2859),h0tab(:,2859),[17,14],[nMH,nMT],2,2,wf4(:,12),wf8(:,163))
  call Hloop_AQ_S(ntryL,G0H32(1),wf4(:,12),G0H8(65),ngH,m3h4x8(:,909),heltab2x32(:,:,2859))
  Gcoeff(:)%j = (-(c(125)*M(2,:)%j)+c(126)*M(6,:)%j) * den(92)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(2860),h0tab(:,2860),[17,14],[nMZ,nMT],2,2,wf4(:,12),wf8(:,163))
  call Hloop_AQ_S(ntryL,G0H32(1),wf4(:,12),G0H8(66),ngX,m3h4x8(:,910),heltab2x32(:,:,2860))
  Gcoeff(:)%j = (-(c(103)*M(2,:)%j)+c(104)*M(6,:)%j) * den(92)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(2861),h0tab(:,2861),[17,14],[nMW,nMB],2,2,wf4(:,12),wf8(:,163))
  call Hloop_AQ_S(ntryL,G0H32(1),wf4(:,12),G0H8(127),ngPbt,m3h4x8(:,911),heltab2x32(:,:,2861))
  Gcoeff(:)%j = (-(c(3)*M(1,:)%j)) * den(92)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(2862),h0tab(:,2862),[17,14],[0,nMT],2,2,wf4(:,12),wf8(:,163))
  call Hloop_AQ_V(ntryL,G0H32(1),wf4(:,12),G0H8(81),m3h4x8(:,912),heltab2x32(:,:,2862))
  Gcoeff(:)%j = (-(c(5)*M(1,:)%j)) * den(92)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(2863),h0tab(:,2863),[17,14],[nMZ,nMT],2,2,wf4(:,12),wf8(:,163))
  call Hloop_AQ_Z(ntryL,G0H32(1),wf4(:,12),G0H8(122),ngZu,m3h4x8(:,913),heltab2x32(:,:,2863))
  Gcoeff(:)%j = (-(c(77)*M(1,:)%j)) * den(92)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(2864),h0tab(:,2864),[17,14],[nMW,nMB],2,2,wf4(:,12),wf8(:,163))
  call Hloop_AQ_W(ntryL,G0H32(1),wf4(:,12),G0H8(34),m3h4x8(:,914),heltab2x32(:,:,2864))
  Gcoeff(:)%j = (-(c(19)*M(2,:)%j)) * den(92)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(2865),h0tab(:,2865),[17,14],[0,nMT],2,2,wf4(:,12),wf8(:,163))
  call Hloop_AQ_V(ntryL,G0H32(1),wf4(:,12),G0H8(31),m3h4x8(:,915),heltab2x32(:,:,2865))
  Gcoeff(:)%j = (c(6)*M(1,:)%j) * den(90)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(2866),h0tab(:,2866),[17,14],[0,nMT],2,2,wf4(:,12),wf8(:,165))
  call Hloop_AQ_V(ntryL,G0H32(1),wf4(:,12),G0H8(32),m3h4x8(:,916),heltab2x32(:,:,2866))
  Gcoeff(:)%j = (c(7)*M(1,:)%j) * den(90)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(2867),h0tab(:,2867),[17,14],[nMZ,nMT],2,2,wf4(:,12),wf8(:,165))
  call Hloop_AQ_Z(ntryL,G0H32(1),wf4(:,12),G0H8(20),ngZu,m3h4x8(:,917),heltab2x32(:,:,2867))
  Gcoeff(:)%j = (c(81)*M(1,:)%j) * den(90)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(2868),h0tab(:,2868),[17,14],[nMW,nMB],2,2,wf4(:,12),wf8(:,165))
  call Hloop_AQ_W(ntryL,G0H32(1),wf4(:,12),G0H8(17),m3h4x8(:,918),heltab2x32(:,:,2868))
  Gcoeff(:)%j = (c(24)*M(2,:)%j) * den(90)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(2869),h0tab(:,2869),[17,14],[0,nMT],2,2,wf4(:,12),wf8(:,165))
  call Hloop_AQ_V(ntryL,G0H32(1),wf4(:,12),G0H8(18),m3h4x8(:,919),heltab2x32(:,:,2869))
  Gcoeff(:)%j = (-(c(20)*M(2,:)%j)+c(21)*M(6,:)%j) * den(92)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(2870),h0tab(:,2870),[17,14],[0,nMT],2,2,wf4(:,12),wf8(:,163))
  call Hloop_AQ_V(ntryL,G0H32(1),wf4(:,12),G0H8(73),m3h4x8(:,920),heltab2x32(:,:,2870))
  Gcoeff(:)%j = (-(c(22)*M(2,:)%j)+c(23)*M(6,:)%j) * den(92)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(2871),h0tab(:,2871),[17,14],[nMZ,nMT],2,2,wf4(:,12),wf8(:,163))
  call Hloop_AQ_Z(ntryL,G0H32(1),wf4(:,12),G0H8(74),ngZu,m3h4x8(:,921),heltab2x32(:,:,2871))
  Gcoeff(:)%j = (-(c(86)*M(2,:)%j)+c(87)*M(6,:)%j) * den(92)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(2872),h0tab(:,2872),[17,14],[nMW,nMB],2,2,wf4(:,12),wf8(:,163))
  call Hloop_AQ_W(ntryL,G0H32(1),wf4(:,12),G0H8(82),m3h4x8(:,922),heltab2x32(:,:,2872))
  Gcoeff(:)%j = (-(c(176)*M(1,:)%j)) * den(111)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(2873),h0tab(:,2873),[19,12],[nME,nME],2,2,wf8(:,22),wf4(:,18))
  call Hloop_QS_A(ntryL,G0H32(1),wf8(:,22),G0H4(207),ngH,m3h8x4(:,1181),heltab2x32(:,:,2873))
  call Hloop_Q_A(ntryL,G0H4(207),19,nME,G1H4(567),n2h4(1058))
  Gcoeff(:)%j = (-(c(178)*M(1,:)%j)) * den(111)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(2874),h0tab(:,2874),[19,12],[nMM,nMM],2,2,wf8(:,22),wf4(:,18))
  call Hloop_QS_A(ntryL,G0H32(1),wf8(:,22),G0H4(207),ngH,m3h8x4(:,1182),heltab2x32(:,:,2874))
  call Hloop_Q_A(ntryL,G0H4(207),19,nMM,G1H4(568),n2h4(1059))
  Gcoeff(:)%j = (-(c(177)*M(1,:)%j)) * den(111)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(2875),h0tab(:,2875),[19,12],[nML,nML],2,2,wf8(:,22),wf4(:,18))
  call Hloop_QS_A(ntryL,G0H32(1),wf8(:,22),G0H4(207),ngH,m3h8x4(:,1183),heltab2x32(:,:,2875))
  call Hloop_Q_A(ntryL,G0H4(207),19,nML,G1H4(569),n2h4(1060))
  Gcoeff(:)%j = (-(c(179)*M(1,:)%j)) * den(111)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(2876),h0tab(:,2876),[19,12],[nMT,nMT],2,2,wf8(:,22),wf4(:,18))
  call Hloop_QS_A(ntryL,G0H32(1),wf8(:,22),G0H4(207),ngH,m3h8x4(:,1184),heltab2x32(:,:,2876))
  call Hloop_Q_A(ntryL,G0H4(207),19,nMT,G1H4(570),n2h4(1061))
  Gcoeff(:)%j = (-(c(175)*M(1,:)%j)) * den(111)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(2877),h0tab(:,2877),[19,12],[nMB,nMB],2,2,wf8(:,22),wf4(:,18))
  call Hloop_QS_A(ntryL,G0H32(1),wf8(:,22),G0H4(207),ngH,m3h8x4(:,1185),heltab2x32(:,:,2877))
  call Hloop_Q_A(ntryL,G0H4(207),19,nMB,G1H4(571),n2h4(1062))
  Gcoeff(:)%j = (c(176)*M(1,:)%j) * den(132)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(2878),h0tab(:,2878),[19,12],[nME,nME],2,2,wf8(:,22),wf4(:,19))
  call Hloop_QS_A(ntryL,G0H32(1),wf8(:,22),G0H4(207),ngH,m3h8x4(:,1186),heltab2x32(:,:,2878))
  call Hloop_Q_A(ntryL,G0H4(207),19,nME,G1H4(572),n2h4(1063))
  Gcoeff(:)%j = (c(178)*M(1,:)%j) * den(132)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(2879),h0tab(:,2879),[19,12],[nMM,nMM],2,2,wf8(:,22),wf4(:,19))
  call Hloop_QS_A(ntryL,G0H32(1),wf8(:,22),G0H4(207),ngH,m3h8x4(:,1187),heltab2x32(:,:,2879))
  call Hloop_Q_A(ntryL,G0H4(207),19,nMM,G1H4(573),n2h4(1064))
  Gcoeff(:)%j = (c(177)*M(1,:)%j) * den(132)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(2880),h0tab(:,2880),[19,12],[nML,nML],2,2,wf8(:,22),wf4(:,19))
  call Hloop_QS_A(ntryL,G0H32(1),wf8(:,22),G0H4(207),ngH,m3h8x4(:,1188),heltab2x32(:,:,2880))
  call Hloop_Q_A(ntryL,G0H4(207),19,nML,G1H4(574),n2h4(1065))
  Gcoeff(:)%j = (-(c(179)*M(1,:)%j)) * den(132)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(2881),h0tab(:,2881),[19,12],[nMT,nMT],2,2,wf8(:,22),wf4(:,19))
  call Hloop_QS_A(ntryL,G0H32(1),wf8(:,22),G0H4(207),ngH,m3h8x4(:,1189),heltab2x32(:,:,2881))
  call Hloop_Q_A(ntryL,G0H4(207),19,nMT,G1H4(575),n2h4(1066))
  Gcoeff(:)%j = (c(175)*M(1,:)%j) * den(132)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(2882),h0tab(:,2882),[19,12],[nMB,nMB],2,2,wf8(:,22),wf4(:,19))
  call Hloop_QS_A(ntryL,G0H32(1),wf8(:,22),G0H4(207),ngH,m3h8x4(:,1190),heltab2x32(:,:,2882))
  call Hloop_Q_A(ntryL,G0H4(207),19,nMB,G1H4(576),n2h4(1067))
  Gcoeff(:)%j = (-(c(176)*M(1,:)%j)) * den(133)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(2883),h0tab(:,2883),[19,12],[nME,nME],2,2,wf8(:,23),wf4(:,18))
  call Hloop_QS_A(ntryL,G0H32(1),wf8(:,23),G0H4(207),ngX,m3h8x4(:,1191),heltab2x32(:,:,2883))
  call Hloop_Q_A(ntryL,G0H4(207),19,nME,G1H4(577),n2h4(1068))
  Gcoeff(:)%j = (-(c(178)*M(1,:)%j)) * den(133)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(2884),h0tab(:,2884),[19,12],[nMM,nMM],2,2,wf8(:,23),wf4(:,18))
  call Hloop_QS_A(ntryL,G0H32(1),wf8(:,23),G0H4(207),ngX,m3h8x4(:,1192),heltab2x32(:,:,2884))
  call Hloop_Q_A(ntryL,G0H4(207),19,nMM,G1H4(578),n2h4(1069))
  Gcoeff(:)%j = (-(c(177)*M(1,:)%j)) * den(133)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(2885),h0tab(:,2885),[19,12],[nML,nML],2,2,wf8(:,23),wf4(:,18))
  call Hloop_QS_A(ntryL,G0H32(1),wf8(:,23),G0H4(207),ngX,m3h8x4(:,1193),heltab2x32(:,:,2885))
  call Hloop_Q_A(ntryL,G0H4(207),19,nML,G1H4(579),n2h4(1070))
  Gcoeff(:)%j = (c(179)*M(1,:)%j) * den(133)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(2886),h0tab(:,2886),[19,12],[nMT,nMT],2,2,wf8(:,23),wf4(:,18))
  call Hloop_QS_A(ntryL,G0H32(1),wf8(:,23),G0H4(207),ngX,m3h8x4(:,1194),heltab2x32(:,:,2886))
  call Hloop_Q_A(ntryL,G0H4(207),19,nMT,G1H4(580),n2h4(1071))
  Gcoeff(:)%j = (-(c(175)*M(1,:)%j)) * den(133)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(2887),h0tab(:,2887),[19,12],[nMB,nMB],2,2,wf8(:,23),wf4(:,18))
  call Hloop_QS_A(ntryL,G0H32(1),wf8(:,23),G0H4(207),ngX,m3h8x4(:,1195),heltab2x32(:,:,2887))
  call Hloop_Q_A(ntryL,G0H4(207),19,nMB,G1H4(581),n2h4(1072))
  Gcoeff(:)%j = (c(176)*M(1,:)%j) * den(113)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(2888),h0tab(:,2888),[19,12],[nME,nME],2,2,wf8(:,23),wf4(:,19))
  call Hloop_QS_A(ntryL,G0H32(1),wf8(:,23),G0H4(207),ngX,m3h8x4(:,1196),heltab2x32(:,:,2888))
  call Hloop_Q_A(ntryL,G0H4(207),19,nME,G1H4(582),n2h4(1073))
  Gcoeff(:)%j = (c(178)*M(1,:)%j) * den(113)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(2889),h0tab(:,2889),[19,12],[nMM,nMM],2,2,wf8(:,23),wf4(:,19))
  call Hloop_QS_A(ntryL,G0H32(1),wf8(:,23),G0H4(207),ngX,m3h8x4(:,1197),heltab2x32(:,:,2889))
  call Hloop_Q_A(ntryL,G0H4(207),19,nMM,G1H4(583),n2h4(1074))
  Gcoeff(:)%j = (c(177)*M(1,:)%j) * den(113)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(2890),h0tab(:,2890),[19,12],[nML,nML],2,2,wf8(:,23),wf4(:,19))
  call Hloop_QS_A(ntryL,G0H32(1),wf8(:,23),G0H4(207),ngX,m3h8x4(:,1198),heltab2x32(:,:,2890))
  call Hloop_Q_A(ntryL,G0H4(207),19,nML,G1H4(584),n2h4(1075))
  Gcoeff(:)%j = (c(179)*M(1,:)%j) * den(113)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(2891),h0tab(:,2891),[19,12],[nMT,nMT],2,2,wf8(:,23),wf4(:,19))
  call Hloop_QS_A(ntryL,G0H32(1),wf8(:,23),G0H4(207),ngX,m3h8x4(:,1199),heltab2x32(:,:,2891))
  call Hloop_Q_A(ntryL,G0H4(207),19,nMT,G1H4(585),n2h4(1076))
  Gcoeff(:)%j = (c(175)*M(1,:)%j) * den(113)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(2892),h0tab(:,2892),[19,12],[nMB,nMB],2,2,wf8(:,23),wf4(:,19))
  call Hloop_QS_A(ntryL,G0H32(1),wf8(:,23),G0H4(207),ngX,m3h8x4(:,1200),heltab2x32(:,:,2892))
  call Hloop_Q_A(ntryL,G0H4(207),19,nMB,G1H4(586),n2h4(1077))
  Gcoeff(:)%j = (c(47)*M(1,:)%j) * den(111)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(2893),h0tab(:,2893),[19,12],[nMH,nMH],2,2,wf8(:,22),wf4(:,18))
  call Hloop_SS_S(ntryL,G0H32(1),wf8(:,22),G0H4(207),m3h8x4(:,1201),heltab2x32(:,:,2893))
  Gcoeff(:)%j = (c(45)*M(1,:)%j) * den(111)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(2894),h0tab(:,2894),[19,12],[nMZ,nMZ],2,2,wf8(:,22),wf4(:,18))
  call Hloop_SS_S(ntryL,G0H32(1),wf8(:,22),G0H4(208),m3h8x4(:,1202),heltab2x32(:,:,2894))
  Gcoeff(:)%j = (c(46)*M(1,:)%j) * den(111)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(2895),h0tab(:,2895),[19,12],[nMW,nMW],2,2,wf8(:,22),wf4(:,18))
  call Hloop_SS_S(ntryL,G0H32(1),wf8(:,22),G0H4(209),m3h8x4(:,1203),heltab2x32(:,:,2895))
  Gcoeff(:)%j = (c(46)*M(1,:)%j) * den(113)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(2896),h0tab(:,2896),[19,12],[nMZ,nMH],2,2,wf8(:,23),wf4(:,19))
  call Hloop_SS_S(ntryL,G0H32(1),wf8(:,23),G0H4(210),m3h8x4(:,1204),heltab2x32(:,:,2896))
  Gcoeff(:)%j = (-(c(34)*M(1,:)%j)) * den(111)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(2897),h0tab(:,2897),[19,12],[nMZ,nMZ],2,2,wf8(:,22),wf4(:,18))
  call Hloop_SS_S(ntryL,G0H32(1),wf8(:,22),G0H4(211),m3h8x4(:,1205),heltab2x32(:,:,2897))
  Gcoeff(:)%j = (-(c(32)*M(1,:)%j)) * den(111)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(2898),h0tab(:,2898),[19,12],[nMW,nMW],2,2,wf8(:,22),wf4(:,18))
  call Hloop_SS_S(ntryL,G0H32(1),wf8(:,22),G0H4(212),m3h8x4(:,1206),heltab2x32(:,:,2898))
  Gcoeff(:)%j = (-(c(32)*M(1,:)%j)) * den(111)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(2899),h0tab(:,2899),[19,12],[nMW,nMW],2,2,wf8(:,22),wf4(:,18))
  call Hloop_SS_S(ntryL,G0H32(1),wf8(:,22),G0H4(213),m3h8x4(:,1207),heltab2x32(:,:,2899))
  Gcoeff(:)%j = (c(32)*M(1,:)%j) * den(132)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(2900),h0tab(:,2900),[19,12],[nMW,nMW],2,2,wf8(:,22),wf4(:,19))
  call Hloop_SS_S(ntryL,G0H32(1),wf8(:,22),G0H4(214),m3h8x4(:,1208),heltab2x32(:,:,2900))
  Gcoeff(:)%j = (-(c(32)*M(1,:)%j)) * den(132)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(2901),h0tab(:,2901),[19,12],[nMW,nMW],2,2,wf8(:,22),wf4(:,19))
  call Hloop_SS_S(ntryL,G0H32(1),wf8(:,22),G0H4(215),m3h8x4(:,1209),heltab2x32(:,:,2901))
  Gcoeff(:)%j = (-(c(32)*M(1,:)%j)) * den(133)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(2902),h0tab(:,2902),[19,12],[nMW,nMW],2,2,wf8(:,23),wf4(:,18))
  call Hloop_SS_S(ntryL,G0H32(1),wf8(:,23),G0H4(216),m3h8x4(:,1210),heltab2x32(:,:,2902))
  Gcoeff(:)%j = (c(32)*M(1,:)%j) * den(133)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(2903),h0tab(:,2903),[19,12],[nMW,nMW],2,2,wf8(:,23),wf4(:,18))
  call Hloop_SS_S(ntryL,G0H32(1),wf8(:,23),G0H4(217),m3h8x4(:,1211),heltab2x32(:,:,2903))
  Gcoeff(:)%j = (c(32)*M(1,:)%j) * den(113)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(2904),h0tab(:,2904),[19,12],[nMW,nMW],2,2,wf8(:,23),wf4(:,19))
  call Hloop_SS_S(ntryL,G0H32(1),wf8(:,23),G0H4(218),m3h8x4(:,1212),heltab2x32(:,:,2904))
  Gcoeff(:)%j = (c(32)*M(1,:)%j) * den(113)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(2905),h0tab(:,2905),[19,12],[nMW,nMW],2,2,wf8(:,23),wf4(:,19))
  call Hloop_SS_S(ntryL,G0H32(1),wf8(:,23),G0H4(219),m3h8x4(:,1213),heltab2x32(:,:,2905))
  Gcoeff(:)%j = (c(35)*M(1,:)%j) * den(111)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(2906),h0tab(:,2906),[19,12],[nMZ,nMZ],2,2,wf8(:,22),wf4(:,18))
  call Hloop_VS_V(ntryL,G0H32(1),wf8(:,22),G0H4(220),m3h8x4(:,1214),heltab2x32(:,:,2906))
  Gcoeff(:)%j = (c(33)*M(1,:)%j) * den(111)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(2907),h0tab(:,2907),[19,12],[nMW,nMW],2,2,wf8(:,22),wf4(:,18))
  call Hloop_VS_V(ntryL,G0H32(1),wf8(:,22),G0H4(221),m3h8x4(:,1215),heltab2x32(:,:,2907))
  Gcoeff(:)%j = (c(61)*M(1,:)%j) * den(111)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(2908),h0tab(:,2908),[19,12],[nMZ,nMZ],2,2,wf8(:,22),wf4(:,18))
  call Hloop_ST_V(ntryL,G0H32(1),0,wf8(:,22),19,G1H4(587),m3h8x4(:,1216),heltab2x32(:,:,2908))
  Gcoeff(:)%j = (c(59)*M(1,:)%j) * den(111)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(2909),h0tab(:,2909),[19,12],[nMW,nMW],2,2,wf8(:,22),wf4(:,18))
  call Hloop_ST_V(ntryL,G0H32(1),0,wf8(:,22),19,G1H4(588),m3h8x4(:,1217),heltab2x32(:,:,2909))
  Gcoeff(:)%j = (c(59)*M(1,:)%j) * den(111)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(2910),h0tab(:,2910),[19,12],[nMW,nMW],2,2,wf8(:,22),wf4(:,18))
  call Hloop_ST_V(ntryL,G0H32(1),0,wf8(:,22),19,G1H4(589),m3h8x4(:,1218),heltab2x32(:,:,2910))
  Gcoeff(:)%j = (-(c(59)*M(1,:)%j)) * den(132)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(2911),h0tab(:,2911),[19,12],[nMW,nMW],2,2,wf8(:,22),wf4(:,19))
  call Hloop_ST_V(ntryL,G0H32(1),0,wf8(:,22),19,G1H4(590),m3h8x4(:,1219),heltab2x32(:,:,2911))
  Gcoeff(:)%j = (c(59)*M(1,:)%j) * den(132)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(2912),h0tab(:,2912),[19,12],[nMW,nMW],2,2,wf8(:,22),wf4(:,19))
  call Hloop_ST_V(ntryL,G0H32(1),0,wf8(:,22),19,G1H4(591),m3h8x4(:,1220),heltab2x32(:,:,2912))
  Gcoeff(:)%j = (-(c(59)*M(1,:)%j)) * den(133)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(2913),h0tab(:,2913),[19,12],[nMW,nMW],2,2,wf8(:,23),wf4(:,18))
  call Hloop_ST_V(ntryL,G0H32(1),0,wf8(:,23),19,G1H4(592),m3h8x4(:,1221),heltab2x32(:,:,2913))
  Gcoeff(:)%j = (c(59)*M(1,:)%j) * den(133)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(2914),h0tab(:,2914),[19,12],[nMW,nMW],2,2,wf8(:,23),wf4(:,18))
  call Hloop_ST_V(ntryL,G0H32(1),0,wf8(:,23),19,G1H4(593),m3h8x4(:,1222),heltab2x32(:,:,2914))
  Gcoeff(:)%j = (c(61)*M(1,:)%j) * den(113)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(2915),h0tab(:,2915),[19,12],[nMZ,nMH],2,2,wf8(:,23),wf4(:,19))
  call Hloop_TS_V(ntryL,G0H32(1),0,wf8(:,23),19,G1H4(594),m3h8x4(:,1223),heltab2x32(:,:,2915))
  Gcoeff(:)%j = (c(59)*M(1,:)%j) * den(113)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(2916),h0tab(:,2916),[19,12],[nMW,nMW],2,2,wf8(:,23),wf4(:,19))
  call Hloop_ST_V(ntryL,G0H32(1),0,wf8(:,23),19,G1H4(595),m3h8x4(:,1224),heltab2x32(:,:,2916))
  Gcoeff(:)%j = (c(59)*M(1,:)%j) * den(113)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(2917),h0tab(:,2917),[19,12],[nMW,nMW],2,2,wf8(:,23),wf4(:,19))
  call Hloop_ST_V(ntryL,G0H32(1),0,wf8(:,23),19,G1H4(596),m3h8x4(:,1225),heltab2x32(:,:,2917))
  Gcoeff(:)%j = (c(197)*M(1,:)%j) * den(134)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(2918),h0tab(:,2918),[19,12],[nME,nME],2,2,wf8(:,22),wf4(:,2))
  call Hloop_QS_A(ntryL,G0H32(1),wf8(:,22),G0H4(222),ngH,m3h8x4(:,1226),heltab2x32(:,:,2918))
  call Hloop_Q_A(ntryL,G0H4(222),19,nME,G1H4(597),n2h4(1078))
  Gcoeff(:)%j = (c(201)*M(1,:)%j) * den(134)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(2919),h0tab(:,2919),[19,12],[nMM,nMM],2,2,wf8(:,22),wf4(:,2))
  call Hloop_QS_A(ntryL,G0H32(1),wf8(:,22),G0H4(222),ngH,m3h8x4(:,1227),heltab2x32(:,:,2919))
  call Hloop_Q_A(ntryL,G0H4(222),19,nMM,G1H4(598),n2h4(1079))
  Gcoeff(:)%j = (c(199)*M(1,:)%j) * den(134)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(2920),h0tab(:,2920),[19,12],[nML,nML],2,2,wf8(:,22),wf4(:,2))
  call Hloop_QS_A(ntryL,G0H32(1),wf8(:,22),G0H4(222),ngH,m3h8x4(:,1228),heltab2x32(:,:,2920))
  call Hloop_Q_A(ntryL,G0H4(222),19,nML,G1H4(599),n2h4(1080))
  Gcoeff(:)%j = (-(c(203)*M(1,:)%j)) * den(134)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(2921),h0tab(:,2921),[19,12],[nMT,nMT],2,2,wf8(:,22),wf4(:,2))
  call Hloop_QS_A(ntryL,G0H32(1),wf8(:,22),G0H4(222),ngH,m3h8x4(:,1229),heltab2x32(:,:,2921))
  call Hloop_Q_A(ntryL,G0H4(222),19,nMT,G1H4(600),n2h4(1081))
  Gcoeff(:)%j = (c(193)*M(1,:)%j) * den(134)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(2922),h0tab(:,2922),[19,12],[nMB,nMB],2,2,wf8(:,22),wf4(:,2))
  call Hloop_QS_A(ntryL,G0H32(1),wf8(:,22),G0H4(222),ngH,m3h8x4(:,1230),heltab2x32(:,:,2922))
  call Hloop_Q_A(ntryL,G0H4(222),19,nMB,G1H4(601),n2h4(1082))
  Gcoeff(:)%j = (c(198)*M(1,:)%j) * den(132)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(2923),h0tab(:,2923),[19,12],[nME,nME],2,2,wf8(:,22),wf4(:,20))
  call Hloop_QS_A(ntryL,G0H32(1),wf8(:,22),G0H4(222),ngH,m3h8x4(:,1231),heltab2x32(:,:,2923))
  call Hloop_Q_A(ntryL,G0H4(222),19,nME,G1H4(602),n2h4(1083))
  Gcoeff(:)%j = (c(202)*M(1,:)%j) * den(132)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(2924),h0tab(:,2924),[19,12],[nMM,nMM],2,2,wf8(:,22),wf4(:,20))
  call Hloop_QS_A(ntryL,G0H32(1),wf8(:,22),G0H4(222),ngH,m3h8x4(:,1232),heltab2x32(:,:,2924))
  call Hloop_Q_A(ntryL,G0H4(222),19,nMM,G1H4(603),n2h4(1084))
  Gcoeff(:)%j = (c(200)*M(1,:)%j) * den(132)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(2925),h0tab(:,2925),[19,12],[nML,nML],2,2,wf8(:,22),wf4(:,20))
  call Hloop_QS_A(ntryL,G0H32(1),wf8(:,22),G0H4(222),ngH,m3h8x4(:,1233),heltab2x32(:,:,2925))
  call Hloop_Q_A(ntryL,G0H4(222),19,nML,G1H4(604),n2h4(1085))
  Gcoeff(:)%j = (c(204)*M(1,:)%j) * den(132)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(2926),h0tab(:,2926),[19,12],[nMT,nMT],2,2,wf8(:,22),wf4(:,20))
  call Hloop_QS_A(ntryL,G0H32(1),wf8(:,22),G0H4(222),ngH,m3h8x4(:,1234),heltab2x32(:,:,2926))
  call Hloop_Q_A(ntryL,G0H4(222),19,nMT,G1H4(605),n2h4(1086))
  Gcoeff(:)%j = (c(195)*M(1,:)%j) * den(132)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(2927),h0tab(:,2927),[19,12],[nMB,nMB],2,2,wf8(:,22),wf4(:,20))
  call Hloop_QS_A(ntryL,G0H32(1),wf8(:,22),G0H4(222),ngH,m3h8x4(:,1235),heltab2x32(:,:,2927))
  call Hloop_Q_A(ntryL,G0H4(222),19,nMB,G1H4(606),n2h4(1087))
  Gcoeff(:)%j = (c(197)*M(1,:)%j) * den(114)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(2928),h0tab(:,2928),[19,12],[nME,nME],2,2,wf8(:,23),wf4(:,2))
  call Hloop_QS_A(ntryL,G0H32(1),wf8(:,23),G0H4(222),ngX,m3h8x4(:,1236),heltab2x32(:,:,2928))
  call Hloop_Q_A(ntryL,G0H4(222),19,nME,G1H4(607),n2h4(1088))
  Gcoeff(:)%j = (c(201)*M(1,:)%j) * den(114)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(2929),h0tab(:,2929),[19,12],[nMM,nMM],2,2,wf8(:,23),wf4(:,2))
  call Hloop_QS_A(ntryL,G0H32(1),wf8(:,23),G0H4(222),ngX,m3h8x4(:,1237),heltab2x32(:,:,2929))
  call Hloop_Q_A(ntryL,G0H4(222),19,nMM,G1H4(608),n2h4(1089))
  Gcoeff(:)%j = (c(199)*M(1,:)%j) * den(114)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(2930),h0tab(:,2930),[19,12],[nML,nML],2,2,wf8(:,23),wf4(:,2))
  call Hloop_QS_A(ntryL,G0H32(1),wf8(:,23),G0H4(222),ngX,m3h8x4(:,1238),heltab2x32(:,:,2930))
  call Hloop_Q_A(ntryL,G0H4(222),19,nML,G1H4(609),n2h4(1090))
  Gcoeff(:)%j = (c(203)*M(1,:)%j) * den(114)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(2931),h0tab(:,2931),[19,12],[nMT,nMT],2,2,wf8(:,23),wf4(:,2))
  call Hloop_QS_A(ntryL,G0H32(1),wf8(:,23),G0H4(222),ngX,m3h8x4(:,1239),heltab2x32(:,:,2931))
  call Hloop_Q_A(ntryL,G0H4(222),19,nMT,G1H4(610),n2h4(1091))
  Gcoeff(:)%j = (c(193)*M(1,:)%j) * den(114)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(2932),h0tab(:,2932),[19,12],[nMB,nMB],2,2,wf8(:,23),wf4(:,2))
  call Hloop_QS_A(ntryL,G0H32(1),wf8(:,23),G0H4(222),ngX,m3h8x4(:,1240),heltab2x32(:,:,2932))
  call Hloop_Q_A(ntryL,G0H4(222),19,nMB,G1H4(611),n2h4(1092))
  Gcoeff(:)%j = (c(198)*M(1,:)%j) * den(113)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(2933),h0tab(:,2933),[19,12],[nME,nME],2,2,wf8(:,23),wf4(:,20))
  call Hloop_QS_A(ntryL,G0H32(1),wf8(:,23),G0H4(222),ngX,m3h8x4(:,1241),heltab2x32(:,:,2933))
  call Hloop_Q_A(ntryL,G0H4(222),19,nME,G1H4(612),n2h4(1093))
  Gcoeff(:)%j = (c(202)*M(1,:)%j) * den(113)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(2934),h0tab(:,2934),[19,12],[nMM,nMM],2,2,wf8(:,23),wf4(:,20))
  call Hloop_QS_A(ntryL,G0H32(1),wf8(:,23),G0H4(222),ngX,m3h8x4(:,1242),heltab2x32(:,:,2934))
  call Hloop_Q_A(ntryL,G0H4(222),19,nMM,G1H4(613),n2h4(1094))
  Gcoeff(:)%j = (c(200)*M(1,:)%j) * den(113)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(2935),h0tab(:,2935),[19,12],[nML,nML],2,2,wf8(:,23),wf4(:,20))
  call Hloop_QS_A(ntryL,G0H32(1),wf8(:,23),G0H4(222),ngX,m3h8x4(:,1243),heltab2x32(:,:,2935))
  call Hloop_Q_A(ntryL,G0H4(222),19,nML,G1H4(614),n2h4(1095))
  Gcoeff(:)%j = (-(c(204)*M(1,:)%j)) * den(113)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(2936),h0tab(:,2936),[19,12],[nMT,nMT],2,2,wf8(:,23),wf4(:,20))
  call Hloop_QS_A(ntryL,G0H32(1),wf8(:,23),G0H4(222),ngX,m3h8x4(:,1244),heltab2x32(:,:,2936))
  call Hloop_Q_A(ntryL,G0H4(222),19,nMT,G1H4(615),n2h4(1096))
  Gcoeff(:)%j = (c(195)*M(1,:)%j) * den(113)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(2937),h0tab(:,2937),[19,12],[nMB,nMB],2,2,wf8(:,23),wf4(:,20))
  call Hloop_QS_A(ntryL,G0H32(1),wf8(:,23),G0H4(222),ngX,m3h8x4(:,1245),heltab2x32(:,:,2937))
  call Hloop_Q_A(ntryL,G0H4(222),19,nMB,G1H4(616),n2h4(1097))
  Gcoeff(:)%j = (c(121)*M(1,:)%j) * den(134)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(2938),h0tab(:,2938),[19,12],[nMW,nMW],2,2,wf8(:,22),wf4(:,2))
  call Hloop_SS_S(ntryL,G0H32(1),wf8(:,22),G0H4(222),m3h8x4(:,1246),heltab2x32(:,:,2938))
  Gcoeff(:)%j = (c(143)*M(1,:)%j) * den(132)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(2939),h0tab(:,2939),[19,12],[nMW,nMW],2,2,wf8(:,22),wf4(:,20))
  call Hloop_SS_S(ntryL,G0H32(1),wf8(:,22),G0H4(223),m3h8x4(:,1247),heltab2x32(:,:,2939))
  Gcoeff(:)%j = (-(c(74)*M(1,:)%j)) * den(113)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(2940),h0tab(:,2940),[19,12],[nMZ,nMH],2,2,wf8(:,23),wf4(:,20))
  call Hloop_SS_S(ntryL,G0H32(1),wf8(:,23),G0H4(224),m3h8x4(:,1248),heltab2x32(:,:,2940))
  Gcoeff(:)%j = (c(92)*M(1,:)%j) * den(134)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(2941),h0tab(:,2941),[19,12],[nMW,nMW],2,2,wf8(:,22),wf4(:,2))
  call Hloop_SS_S(ntryL,G0H32(1),wf8(:,22),G0H4(225),m3h8x4(:,1249),heltab2x32(:,:,2941))
  Gcoeff(:)%j = (-(c(92)*M(1,:)%j)) * den(134)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(2942),h0tab(:,2942),[19,12],[nMW,nMW],2,2,wf8(:,22),wf4(:,2))
  call Hloop_SS_S(ntryL,G0H32(1),wf8(:,22),G0H4(226),m3h8x4(:,1250),heltab2x32(:,:,2942))
  Gcoeff(:)%j = (-(c(69)*M(1,:)%j)) * den(132)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(2943),h0tab(:,2943),[19,12],[nMW,nMW],2,2,wf8(:,22),wf4(:,20))
  call Hloop_SS_S(ntryL,G0H32(1),wf8(:,22),G0H4(227),m3h8x4(:,1251),heltab2x32(:,:,2943))
  Gcoeff(:)%j = (c(69)*M(1,:)%j) * den(132)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(2944),h0tab(:,2944),[19,12],[nMW,nMW],2,2,wf8(:,22),wf4(:,20))
  call Hloop_SS_S(ntryL,G0H32(1),wf8(:,22),G0H4(228),m3h8x4(:,1252),heltab2x32(:,:,2944))
  Gcoeff(:)%j = (c(92)*M(1,:)%j) * den(114)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(2945),h0tab(:,2945),[19,12],[nMW,nMW],2,2,wf8(:,23),wf4(:,2))
  call Hloop_SS_S(ntryL,G0H32(1),wf8(:,23),G0H4(229),m3h8x4(:,1253),heltab2x32(:,:,2945))
  Gcoeff(:)%j = (c(92)*M(1,:)%j) * den(114)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(2946),h0tab(:,2946),[19,12],[nMW,nMW],2,2,wf8(:,23),wf4(:,2))
  call Hloop_SS_S(ntryL,G0H32(1),wf8(:,23),G0H4(230),m3h8x4(:,1254),heltab2x32(:,:,2946))
  Gcoeff(:)%j = (-(c(69)*M(1,:)%j)) * den(113)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(2947),h0tab(:,2947),[19,12],[nMW,nMW],2,2,wf8(:,23),wf4(:,20))
  call Hloop_SS_S(ntryL,G0H32(1),wf8(:,23),G0H4(231),m3h8x4(:,1255),heltab2x32(:,:,2947))
  Gcoeff(:)%j = (-(c(69)*M(1,:)%j)) * den(113)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(2948),h0tab(:,2948),[19,12],[nMW,nMW],2,2,wf8(:,23),wf4(:,20))
  call Hloop_SS_S(ntryL,G0H32(1),wf8(:,23),G0H4(232),m3h8x4(:,1256),heltab2x32(:,:,2948))
  Gcoeff(:)%j = (c(93)*M(1,:)%j) * den(134)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(2949),h0tab(:,2949),[19,12],[nMW,nMW],2,2,wf8(:,22),wf4(:,2))
  call Hloop_VS_V(ntryL,G0H32(1),wf8(:,22),G0H4(233),m3h8x4(:,1257),heltab2x32(:,:,2949))
  Gcoeff(:)%j = (-(c(70)*M(1,:)%j)) * den(132)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(2950),h0tab(:,2950),[19,12],[nMW,nMW],2,2,wf8(:,22),wf4(:,20))
  call Hloop_VS_V(ntryL,G0H32(1),wf8(:,22),G0H4(234),m3h8x4(:,1258),heltab2x32(:,:,2950))
  Gcoeff(:)%j = (-(c(92)*M(1,:)%j)) * den(134)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(2951),h0tab(:,2951),[19,12],[nMW,nMW],2,2,wf8(:,22),wf4(:,2))
  call Hloop_ST_V(ntryL,G0H32(1),0,wf8(:,22),19,G1H4(617),m3h8x4(:,1259),heltab2x32(:,:,2951))
  Gcoeff(:)%j = (c(92)*M(1,:)%j) * den(134)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(2952),h0tab(:,2952),[19,12],[nMW,nMW],2,2,wf8(:,22),wf4(:,2))
  call Hloop_ST_V(ntryL,G0H32(1),0,wf8(:,22),19,G1H4(618),m3h8x4(:,1260),heltab2x32(:,:,2952))
  Gcoeff(:)%j = (-(c(133)*M(1,:)%j)) * den(132)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(2953),h0tab(:,2953),[19,12],[nMW,nMW],2,2,wf8(:,22),wf4(:,20))
  call Hloop_ST_V(ntryL,G0H32(1),0,wf8(:,22),19,G1H4(619),m3h8x4(:,1261),heltab2x32(:,:,2953))
  Gcoeff(:)%j = (c(133)*M(1,:)%j) * den(132)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(2954),h0tab(:,2954),[19,12],[nMW,nMW],2,2,wf8(:,22),wf4(:,20))
  call Hloop_ST_V(ntryL,G0H32(1),0,wf8(:,22),19,G1H4(620),m3h8x4(:,1262),heltab2x32(:,:,2954))
  Gcoeff(:)%j = (c(92)*M(1,:)%j) * den(114)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(2955),h0tab(:,2955),[19,12],[nMW,nMW],2,2,wf8(:,23),wf4(:,2))
  call Hloop_ST_V(ntryL,G0H32(1),0,wf8(:,23),19,G1H4(621),m3h8x4(:,1263),heltab2x32(:,:,2955))
  Gcoeff(:)%j = (c(92)*M(1,:)%j) * den(114)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(2956),h0tab(:,2956),[19,12],[nMW,nMW],2,2,wf8(:,23),wf4(:,2))
  call Hloop_ST_V(ntryL,G0H32(1),0,wf8(:,23),19,G1H4(622),m3h8x4(:,1264),heltab2x32(:,:,2956))
  Gcoeff(:)%j = (-(c(68)*M(1,:)%j)) * den(113)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(2957),h0tab(:,2957),[19,12],[nMZ,nMH],2,2,wf8(:,23),wf4(:,20))
  call Hloop_TS_V(ntryL,G0H32(1),0,wf8(:,23),19,G1H4(623),m3h8x4(:,1265),heltab2x32(:,:,2957))
  Gcoeff(:)%j = (c(133)*M(1,:)%j) * den(113)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(2958),h0tab(:,2958),[19,12],[nMW,nMW],2,2,wf8(:,23),wf4(:,20))
  call Hloop_ST_V(ntryL,G0H32(1),0,wf8(:,23),19,G1H4(624),m3h8x4(:,1266),heltab2x32(:,:,2958))
  Gcoeff(:)%j = (c(133)*M(1,:)%j) * den(113)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(2959),h0tab(:,2959),[19,12],[nMW,nMW],2,2,wf8(:,23),wf4(:,20))
  call Hloop_ST_V(ntryL,G0H32(1),0,wf8(:,23),19,G1H4(625),m3h8x4(:,1267),heltab2x32(:,:,2959))
  Gcoeff(:)%j = (-(c(187)*M(1,:)%j)) * den(135)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(2960),h0tab(:,2960),[19,12],[nME,nME],2,2,wf8(:,24),wf4(:,18))
  call Hloop_QV_A(ntryL,G0H32(1),wf8(:,24),G0H4(235),m3h8x4(:,1268),heltab2x32(:,:,2960))
  call Hloop_Q_A(ntryL,G0H4(235),19,nME,G1H4(626),n2h4(1098))
  Gcoeff(:)%j = (-(c(191)*M(1,:)%j)) * den(135)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(2961),h0tab(:,2961),[19,12],[nMM,nMM],2,2,wf8(:,24),wf4(:,18))
  call Hloop_QV_A(ntryL,G0H32(1),wf8(:,24),G0H4(235),m3h8x4(:,1269),heltab2x32(:,:,2961))
  call Hloop_Q_A(ntryL,G0H4(235),19,nMM,G1H4(627),n2h4(1099))
  Gcoeff(:)%j = (-(c(189)*M(1,:)%j)) * den(135)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(2962),h0tab(:,2962),[19,12],[nML,nML],2,2,wf8(:,24),wf4(:,18))
  call Hloop_QV_A(ntryL,G0H32(1),wf8(:,24),G0H4(235),m3h8x4(:,1270),heltab2x32(:,:,2962))
  call Hloop_Q_A(ntryL,G0H4(235),19,nML,G1H4(628),n2h4(1100))
  Gcoeff(:)%j = (c(194)*M(1,:)%j) * den(135)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(2963),h0tab(:,2963),[19,12],[nMT,nMT],2,2,wf8(:,24),wf4(:,18))
  call Hloop_QV_A(ntryL,G0H32(1),wf8(:,24),G0H4(235),m3h8x4(:,1271),heltab2x32(:,:,2963))
  call Hloop_Q_A(ntryL,G0H4(235),19,nMT,G1H4(629),n2h4(1101))
  Gcoeff(:)%j = (-(c(184)*M(1,:)%j)) * den(135)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(2964),h0tab(:,2964),[19,12],[nMB,nMB],2,2,wf8(:,24),wf4(:,18))
  call Hloop_QV_A(ntryL,G0H32(1),wf8(:,24),G0H4(235),m3h8x4(:,1272),heltab2x32(:,:,2964))
  call Hloop_Q_A(ntryL,G0H4(235),19,nMB,G1H4(630),n2h4(1102))
  Gcoeff(:)%j = (c(187)*M(1,:)%j) * den(116)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(2965),h0tab(:,2965),[19,12],[nME,nME],2,2,wf8(:,24),wf4(:,19))
  call Hloop_QV_A(ntryL,G0H32(1),wf8(:,24),G0H4(235),m3h8x4(:,1273),heltab2x32(:,:,2965))
  call Hloop_Q_A(ntryL,G0H4(235),19,nME,G1H4(631),n2h4(1103))
  Gcoeff(:)%j = (c(191)*M(1,:)%j) * den(116)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(2966),h0tab(:,2966),[19,12],[nMM,nMM],2,2,wf8(:,24),wf4(:,19))
  call Hloop_QV_A(ntryL,G0H32(1),wf8(:,24),G0H4(235),m3h8x4(:,1274),heltab2x32(:,:,2966))
  call Hloop_Q_A(ntryL,G0H4(235),19,nMM,G1H4(632),n2h4(1104))
  Gcoeff(:)%j = (c(189)*M(1,:)%j) * den(116)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(2967),h0tab(:,2967),[19,12],[nML,nML],2,2,wf8(:,24),wf4(:,19))
  call Hloop_QV_A(ntryL,G0H32(1),wf8(:,24),G0H4(235),m3h8x4(:,1275),heltab2x32(:,:,2967))
  call Hloop_Q_A(ntryL,G0H4(235),19,nML,G1H4(633),n2h4(1105))
  Gcoeff(:)%j = (c(194)*M(1,:)%j) * den(116)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(2968),h0tab(:,2968),[19,12],[nMT,nMT],2,2,wf8(:,24),wf4(:,19))
  call Hloop_QV_A(ntryL,G0H32(1),wf8(:,24),G0H4(235),m3h8x4(:,1276),heltab2x32(:,:,2968))
  call Hloop_Q_A(ntryL,G0H4(235),19,nMT,G1H4(634),n2h4(1106))
  Gcoeff(:)%j = (c(184)*M(1,:)%j) * den(116)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(2969),h0tab(:,2969),[19,12],[nMB,nMB],2,2,wf8(:,24),wf4(:,19))
  call Hloop_QV_A(ntryL,G0H32(1),wf8(:,24),G0H4(235),m3h8x4(:,1277),heltab2x32(:,:,2969))
  call Hloop_Q_A(ntryL,G0H4(235),19,nMB,G1H4(635),n2h4(1107))
  Gcoeff(:)%j = (c(188)*M(1,:)%j) * den(133)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(2970),h0tab(:,2970),[19,12],[nME,nME],2,2,wf8(:,25),wf4(:,18))
  call Hloop_QZ_A(ntryL,G0H32(1),wf8(:,25),G0H4(235),ngZl,m3h8x4(:,1278),heltab2x32(:,:,2970))
  call Hloop_Q_A(ntryL,G0H4(235),19,nME,G1H4(636),n2h4(1108))
  Gcoeff(:)%j = (c(192)*M(1,:)%j) * den(133)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(2971),h0tab(:,2971),[19,12],[nMM,nMM],2,2,wf8(:,25),wf4(:,18))
  call Hloop_QZ_A(ntryL,G0H32(1),wf8(:,25),G0H4(235),ngZl,m3h8x4(:,1279),heltab2x32(:,:,2971))
  call Hloop_Q_A(ntryL,G0H4(235),19,nMM,G1H4(637),n2h4(1109))
  Gcoeff(:)%j = (c(190)*M(1,:)%j) * den(133)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(2972),h0tab(:,2972),[19,12],[nML,nML],2,2,wf8(:,25),wf4(:,18))
  call Hloop_QZ_A(ntryL,G0H32(1),wf8(:,25),G0H4(235),ngZl,m3h8x4(:,1280),heltab2x32(:,:,2972))
  call Hloop_Q_A(ntryL,G0H4(235),19,nML,G1H4(638),n2h4(1110))
  Gcoeff(:)%j = (c(195)*M(1,:)%j) * den(133)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(2973),h0tab(:,2973),[19,12],[nMT,nMT],2,2,wf8(:,25),wf4(:,18))
  call Hloop_QZ_A(ntryL,G0H32(1),wf8(:,25),G0H4(235),ngZu,m3h8x4(:,1281),heltab2x32(:,:,2973))
  call Hloop_Q_A(ntryL,G0H4(235),19,nMT,G1H4(639),n2h4(1111))
  Gcoeff(:)%j = (c(185)*M(1,:)%j) * den(133)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(2974),h0tab(:,2974),[19,12],[nMB,nMB],2,2,wf8(:,25),wf4(:,18))
  call Hloop_QZ_A(ntryL,G0H32(1),wf8(:,25),G0H4(235),ngZd,m3h8x4(:,1282),heltab2x32(:,:,2974))
  call Hloop_Q_A(ntryL,G0H4(235),19,nMB,G1H4(640),n2h4(1112))
  Gcoeff(:)%j = (-(c(188)*M(1,:)%j)) * den(113)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(2975),h0tab(:,2975),[19,12],[nME,nME],2,2,wf8(:,25),wf4(:,19))
  call Hloop_QZ_A(ntryL,G0H32(1),wf8(:,25),G0H4(235),ngZl,m3h8x4(:,1283),heltab2x32(:,:,2975))
  call Hloop_Q_A(ntryL,G0H4(235),19,nME,G1H4(641),n2h4(1113))
  Gcoeff(:)%j = (-(c(192)*M(1,:)%j)) * den(113)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(2976),h0tab(:,2976),[19,12],[nMM,nMM],2,2,wf8(:,25),wf4(:,19))
  call Hloop_QZ_A(ntryL,G0H32(1),wf8(:,25),G0H4(235),ngZl,m3h8x4(:,1284),heltab2x32(:,:,2976))
  call Hloop_Q_A(ntryL,G0H4(235),19,nMM,G1H4(642),n2h4(1114))
  Gcoeff(:)%j = (-(c(190)*M(1,:)%j)) * den(113)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(2977),h0tab(:,2977),[19,12],[nML,nML],2,2,wf8(:,25),wf4(:,19))
  call Hloop_QZ_A(ntryL,G0H32(1),wf8(:,25),G0H4(235),ngZl,m3h8x4(:,1285),heltab2x32(:,:,2977))
  call Hloop_Q_A(ntryL,G0H4(235),19,nML,G1H4(643),n2h4(1115))
  Gcoeff(:)%j = (c(195)*M(1,:)%j) * den(113)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(2978),h0tab(:,2978),[19,12],[nMT,nMT],2,2,wf8(:,25),wf4(:,19))
  call Hloop_QZ_A(ntryL,G0H32(1),wf8(:,25),G0H4(235),ngZu,m3h8x4(:,1286),heltab2x32(:,:,2978))
  call Hloop_Q_A(ntryL,G0H4(235),19,nMT,G1H4(644),n2h4(1116))
  Gcoeff(:)%j = (-(c(185)*M(1,:)%j)) * den(113)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(2979),h0tab(:,2979),[19,12],[nMB,nMB],2,2,wf8(:,25),wf4(:,19))
  call Hloop_QZ_A(ntryL,G0H32(1),wf8(:,25),G0H4(235),ngZd,m3h8x4(:,1287),heltab2x32(:,:,2979))
  call Hloop_Q_A(ntryL,G0H4(235),19,nMB,G1H4(645),n2h4(1117))
  Gcoeff(:)%j = (-(c(111)*M(1,:)%j)) * den(135)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(2980),h0tab(:,2980),[19,12],[nMW,nMW],2,2,wf8(:,24),wf4(:,18))
  call Hloop_TV_S(ntryL,G0H32(1),0,wf8(:,24),19,G1H4(646),m3h8x4(:,1288),heltab2x32(:,:,2980))
  Gcoeff(:)%j = (c(142)*M(1,:)%j) * den(133)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(2981),h0tab(:,2981),[19,12],[nMW,nMW],2,2,wf8(:,25),wf4(:,18))
  call Hloop_TV_S(ntryL,G0H32(1),0,wf8(:,25),19,G1H4(647),m3h8x4(:,1289),heltab2x32(:,:,2981))
  Gcoeff(:)%j = (c(72)*M(1,:)%j) * den(113)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(2982),h0tab(:,2982),[19,12],[nMZ,nMH],2,2,wf8(:,25),wf4(:,19))
  call Hloop_TV_S(ntryL,G0H32(1),0,wf8(:,25),19,G1H4(648),m3h8x4(:,1290),heltab2x32(:,:,2982))
  Gcoeff(:)%j = (-(c(89)*M(1,:)%j)) * den(135)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(2983),h0tab(:,2983),[19,12],[nMW,nMW],2,2,wf8(:,24),wf4(:,18))
  call Hloop_CV_D(ntryL,G0H32(1),0,wf8(:,24),19,G1H4(649),m3h8x4(:,1291),heltab2x32(:,:,2983))
  Gcoeff(:)%j = (c(89)*M(1,:)%j) * den(135)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(2984),h0tab(:,2984),[19,12],[nMW,nMW],2,2,wf8(:,24),wf4(:,18))
  call Hloop_CV_D(ntryL,G0H32(1),0,wf8(:,24),19,G1H4(650),m3h8x4(:,1292),heltab2x32(:,:,2984))
  Gcoeff(:)%j = (c(89)*M(1,:)%j) * den(116)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(2985),h0tab(:,2985),[19,12],[nMW,nMW],2,2,wf8(:,24),wf4(:,19))
  call Hloop_CV_D(ntryL,G0H32(1),0,wf8(:,24),19,G1H4(651),m3h8x4(:,1293),heltab2x32(:,:,2985))
  Gcoeff(:)%j = (c(89)*M(1,:)%j) * den(116)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(2986),h0tab(:,2986),[19,12],[nMW,nMW],2,2,wf8(:,24),wf4(:,19))
  call Hloop_CV_D(ntryL,G0H32(1),0,wf8(:,24),19,G1H4(652),m3h8x4(:,1294),heltab2x32(:,:,2986))
  Gcoeff(:)%j = (-(c(66)*M(1,:)%j)) * den(133)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(2987),h0tab(:,2987),[19,12],[nMW,nMW],2,2,wf8(:,25),wf4(:,18))
  call Hloop_CV_D(ntryL,G0H32(1),0,wf8(:,25),19,G1H4(653),m3h8x4(:,1295),heltab2x32(:,:,2987))
  Gcoeff(:)%j = (c(66)*M(1,:)%j) * den(133)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(2988),h0tab(:,2988),[19,12],[nMW,nMW],2,2,wf8(:,25),wf4(:,18))
  call Hloop_CV_D(ntryL,G0H32(1),0,wf8(:,25),19,G1H4(654),m3h8x4(:,1296),heltab2x32(:,:,2988))
  Gcoeff(:)%j = (c(66)*M(1,:)%j) * den(113)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(2989),h0tab(:,2989),[19,12],[nMW,nMW],2,2,wf8(:,25),wf4(:,19))
  call Hloop_CV_D(ntryL,G0H32(1),0,wf8(:,25),19,G1H4(655),m3h8x4(:,1297),heltab2x32(:,:,2989))
  Gcoeff(:)%j = (c(66)*M(1,:)%j) * den(113)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(2990),h0tab(:,2990),[19,12],[nMW,nMW],2,2,wf8(:,25),wf4(:,19))
  call Hloop_CV_D(ntryL,G0H32(1),0,wf8(:,25),19,G1H4(656),m3h8x4(:,1298),heltab2x32(:,:,2990))
  Gcoeff(:)%j = (-(c(90)*M(1,:)%j)) * den(135)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(2991),h0tab(:,2991),[19,12],[nMW,nMW],2,2,wf8(:,24),wf4(:,18))
  call Hloop_UV_W(ntryL,G0H32(1),0,wf8(:,24),19,G1H4(657),m3h8x4(:,1299),heltab2x32(:,:,2991))
  Gcoeff(:)%j = (-(c(67)*M(1,:)%j)) * den(133)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(2992),h0tab(:,2992),[19,12],[nMW,nMW],2,2,wf8(:,25),wf4(:,18))
  call Hloop_UV_W(ntryL,G0H32(1),0,wf8(:,25),19,G1H4(658),m3h8x4(:,1300),heltab2x32(:,:,2992))
  Gcoeff(:)%j = (-(c(89)*M(1,:)%j)) * den(135)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(2993),h0tab(:,2993),[19,12],[nMW,nMW],2,2,wf8(:,24),wf4(:,18))
  call Hloop_SV_V(ntryL,G0H32(1),wf8(:,24),G0H4(235),m3h8x4(:,1301),heltab2x32(:,:,2993))
  Gcoeff(:)%j = (c(89)*M(1,:)%j) * den(135)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(2994),h0tab(:,2994),[19,12],[nMW,nMW],2,2,wf8(:,24),wf4(:,18))
  call Hloop_SV_V(ntryL,G0H32(1),wf8(:,24),G0H4(236),m3h8x4(:,1302),heltab2x32(:,:,2994))
  Gcoeff(:)%j = (c(89)*M(1,:)%j) * den(116)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(2995),h0tab(:,2995),[19,12],[nMW,nMW],2,2,wf8(:,24),wf4(:,19))
  call Hloop_SV_V(ntryL,G0H32(1),wf8(:,24),G0H4(237),m3h8x4(:,1303),heltab2x32(:,:,2995))
  Gcoeff(:)%j = (c(89)*M(1,:)%j) * den(116)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(2996),h0tab(:,2996),[19,12],[nMW,nMW],2,2,wf8(:,24),wf4(:,19))
  call Hloop_SV_V(ntryL,G0H32(1),wf8(:,24),G0H4(238),m3h8x4(:,1304),heltab2x32(:,:,2996))
  Gcoeff(:)%j = (c(132)*M(1,:)%j) * den(133)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(2997),h0tab(:,2997),[19,12],[nMW,nMW],2,2,wf8(:,25),wf4(:,18))
  call Hloop_SV_V(ntryL,G0H32(1),wf8(:,25),G0H4(239),m3h8x4(:,1305),heltab2x32(:,:,2997))
  Gcoeff(:)%j = (-(c(132)*M(1,:)%j)) * den(133)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(2998),h0tab(:,2998),[19,12],[nMW,nMW],2,2,wf8(:,25),wf4(:,18))
  call Hloop_SV_V(ntryL,G0H32(1),wf8(:,25),G0H4(240),m3h8x4(:,1306),heltab2x32(:,:,2998))
  Gcoeff(:)%j = (c(65)*M(1,:)%j) * den(113)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(2999),h0tab(:,2999),[19,12],[nMZ,nMH],2,2,wf8(:,25),wf4(:,19))
  call Hloop_SV_V(ntryL,G0H32(1),wf8(:,25),G0H4(241),m3h8x4(:,1307),heltab2x32(:,:,2999))
  Gcoeff(:)%j = (-(c(132)*M(1,:)%j)) * den(113)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(3000),h0tab(:,3000),[19,12],[nMW,nMW],2,2,wf8(:,25),wf4(:,19))
  call Hloop_SV_V(ntryL,G0H32(1),wf8(:,25),G0H4(242),m3h8x4(:,1308),heltab2x32(:,:,3000))
  Gcoeff(:)%j = (-(c(132)*M(1,:)%j)) * den(113)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(3001),h0tab(:,3001),[19,12],[nMW,nMW],2,2,wf8(:,25),wf4(:,19))
  call Hloop_SV_V(ntryL,G0H32(1),wf8(:,25),G0H4(243),m3h8x4(:,1309),heltab2x32(:,:,3001))
  Gcoeff(:)%j = (c(152)*M(1,:)%j) * den(117)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(3002),h0tab(:,3002),[19,12],[nME,nME],2,2,wf8(:,24),wf4(:,2))
  call Hloop_QV_A(ntryL,G0H32(1),wf8(:,24),G0H4(244),m3h8x4(:,1310),heltab2x32(:,:,3002))
  call Hloop_Q_A(ntryL,G0H4(244),19,nME,G1H4(659),n2h4(1118))
  Gcoeff(:)%j = (c(152)*M(1,:)%j) * den(117)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(3003),h0tab(:,3003),[19,12],[nMM,nMM],2,2,wf8(:,24),wf4(:,2))
  call Hloop_QV_A(ntryL,G0H32(1),wf8(:,24),G0H4(244),m3h8x4(:,1311),heltab2x32(:,:,3003))
  call Hloop_Q_A(ntryL,G0H4(244),19,nMM,G1H4(660),n2h4(1119))
  Gcoeff(:)%j = (c(152)*M(1,:)%j) * den(117)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(3004),h0tab(:,3004),[19,12],[nML,nML],2,2,wf8(:,24),wf4(:,2))
  call Hloop_QV_A(ntryL,G0H32(1),wf8(:,24),G0H4(244),m3h8x4(:,1312),heltab2x32(:,:,3004))
  call Hloop_Q_A(ntryL,G0H4(244),19,nML,G1H4(661),n2h4(1120))
  Gcoeff(:)%j = (c(151)*M(1,:)%j) * den(117)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(3005),h0tab(:,3005),[19,12],[0,0],2,2,wf8(:,24),wf4(:,2))
  call Hloop_QV_A(ntryL,G0H32(1),wf8(:,24),G0H4(244),m3h8x4(:,1313),heltab2x32(:,:,3005))
  call Hloop_Q_A(ntryL,G0H4(244),19,0,G1H4(662),n2h4(1121))
  Gcoeff(:)%j = (c(149)*M(1,:)%j) * den(117)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(3006),h0tab(:,3006),[19,12],[nMT,nMT],2,2,wf8(:,24),wf4(:,2))
  call Hloop_QV_A(ntryL,G0H32(1),wf8(:,24),G0H4(244),m3h8x4(:,1314),heltab2x32(:,:,3006))
  call Hloop_Q_A(ntryL,G0H4(244),19,nMT,G1H4(663),n2h4(1122))
  Gcoeff(:)%j = (c(148)*M(1,:)%j) * den(117)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(3007),h0tab(:,3007),[19,12],[0,0],2,2,wf8(:,24),wf4(:,2))
  call Hloop_QV_A(ntryL,G0H32(1),wf8(:,24),G0H4(244),m3h8x4(:,1315),heltab2x32(:,:,3007))
  call Hloop_Q_A(ntryL,G0H4(244),19,0,G1H4(664),n2h4(1123))
  Gcoeff(:)%j = (c(147)*M(1,:)%j) * den(117)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(3008),h0tab(:,3008),[19,12],[nMB,nMB],2,2,wf8(:,24),wf4(:,2))
  call Hloop_QV_A(ntryL,G0H32(1),wf8(:,24),G0H4(244),m3h8x4(:,1316),heltab2x32(:,:,3008))
  call Hloop_Q_A(ntryL,G0H4(244),19,nMB,G1H4(665),n2h4(1124))
  Gcoeff(:)%j = (c(156)*M(1,:)%j) * den(116)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(3009),h0tab(:,3009),[19,12],[nME,nME],2,2,wf8(:,24),wf4(:,20))
  call Hloop_QV_A(ntryL,G0H32(1),wf8(:,24),G0H4(244),m3h8x4(:,1317),heltab2x32(:,:,3009))
  call Hloop_Q_A(ntryL,G0H4(244),19,nME,G1H4(666),n2h4(1125))
  Gcoeff(:)%j = (c(156)*M(1,:)%j) * den(116)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(3010),h0tab(:,3010),[19,12],[nMM,nMM],2,2,wf8(:,24),wf4(:,20))
  call Hloop_QV_A(ntryL,G0H32(1),wf8(:,24),G0H4(244),m3h8x4(:,1318),heltab2x32(:,:,3010))
  call Hloop_Q_A(ntryL,G0H4(244),19,nMM,G1H4(667),n2h4(1126))
  Gcoeff(:)%j = (c(156)*M(1,:)%j) * den(116)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(3011),h0tab(:,3011),[19,12],[nML,nML],2,2,wf8(:,24),wf4(:,20))
  call Hloop_QV_A(ntryL,G0H32(1),wf8(:,24),G0H4(244),m3h8x4(:,1319),heltab2x32(:,:,3011))
  call Hloop_Q_A(ntryL,G0H4(244),19,nML,G1H4(668),n2h4(1127))
  Gcoeff(:)%j = (-(c(157)*M(1,:)%j)) * den(116)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(3012),h0tab(:,3012),[19,12],[0,0],2,2,wf8(:,24),wf4(:,20))
  call Hloop_QV_A(ntryL,G0H32(1),wf8(:,24),G0H4(244),m3h8x4(:,1320),heltab2x32(:,:,3012))
  call Hloop_Q_A(ntryL,G0H4(244),19,0,G1H4(669),n2h4(1128))
  Gcoeff(:)%j = (-(c(155)*M(1,:)%j)) * den(116)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(3013),h0tab(:,3013),[19,12],[nMT,nMT],2,2,wf8(:,24),wf4(:,20))
  call Hloop_QV_A(ntryL,G0H32(1),wf8(:,24),G0H4(244),m3h8x4(:,1321),heltab2x32(:,:,3013))
  call Hloop_Q_A(ntryL,G0H4(244),19,nMT,G1H4(670),n2h4(1129))
  Gcoeff(:)%j = (c(155)*M(1,:)%j) * den(116)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(3014),h0tab(:,3014),[19,12],[0,0],2,2,wf8(:,24),wf4(:,20))
  call Hloop_QV_A(ntryL,G0H32(1),wf8(:,24),G0H4(244),m3h8x4(:,1322),heltab2x32(:,:,3014))
  call Hloop_Q_A(ntryL,G0H4(244),19,0,G1H4(671),n2h4(1130))
  Gcoeff(:)%j = (c(153)*M(1,:)%j) * den(116)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(3015),h0tab(:,3015),[19,12],[nMB,nMB],2,2,wf8(:,24),wf4(:,20))
  call Hloop_QV_A(ntryL,G0H32(1),wf8(:,24),G0H4(244),m3h8x4(:,1323),heltab2x32(:,:,3015))
  call Hloop_Q_A(ntryL,G0H4(244),19,nMB,G1H4(672),n2h4(1131))
  Gcoeff(:)%j = (-(c(154)*M(1,:)%j)) * den(114)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(3016),h0tab(:,3016),[19,12],[nME,nME],2,2,wf8(:,25),wf4(:,2))
  call Hloop_QZ_A(ntryL,G0H32(1),wf8(:,25),G0H4(244),ngZl,m3h8x4(:,1324),heltab2x32(:,:,3016))
  call Hloop_Q_A(ntryL,G0H4(244),19,nME,G1H4(673),n2h4(1132))
  Gcoeff(:)%j = (-(c(154)*M(1,:)%j)) * den(114)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(3017),h0tab(:,3017),[19,12],[nMM,nMM],2,2,wf8(:,25),wf4(:,2))
  call Hloop_QZ_A(ntryL,G0H32(1),wf8(:,25),G0H4(244),ngZl,m3h8x4(:,1325),heltab2x32(:,:,3017))
  call Hloop_Q_A(ntryL,G0H4(244),19,nMM,G1H4(674),n2h4(1133))
  Gcoeff(:)%j = (-(c(154)*M(1,:)%j)) * den(114)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(3018),h0tab(:,3018),[19,12],[nML,nML],2,2,wf8(:,25),wf4(:,2))
  call Hloop_QZ_A(ntryL,G0H32(1),wf8(:,25),G0H4(244),ngZl,m3h8x4(:,1326),heltab2x32(:,:,3018))
  call Hloop_Q_A(ntryL,G0H4(244),19,nML,G1H4(675),n2h4(1134))
  Gcoeff(:)%j = (c(155)*M(1,:)%j) * den(114)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(3019),h0tab(:,3019),[19,12],[0,0],2,2,wf8(:,25),wf4(:,2))
  call Hloop_QZ_A(ntryL,G0H32(1),wf8(:,25),G0H4(244),ngZu,m3h8x4(:,1327),heltab2x32(:,:,3019))
  call Hloop_Q_A(ntryL,G0H4(244),19,0,G1H4(676),n2h4(1135))
  Gcoeff(:)%j = (c(153)*M(1,:)%j) * den(114)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(3020),h0tab(:,3020),[19,12],[nMT,nMT],2,2,wf8(:,25),wf4(:,2))
  call Hloop_QZ_A(ntryL,G0H32(1),wf8(:,25),G0H4(244),ngZu,m3h8x4(:,1328),heltab2x32(:,:,3020))
  call Hloop_Q_A(ntryL,G0H4(244),19,nMT,G1H4(677),n2h4(1136))
  Gcoeff(:)%j = (-(c(153)*M(1,:)%j)) * den(114)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(3021),h0tab(:,3021),[19,12],[0,0],2,2,wf8(:,25),wf4(:,2))
  call Hloop_QZ_A(ntryL,G0H32(1),wf8(:,25),G0H4(244),ngZd,m3h8x4(:,1329),heltab2x32(:,:,3021))
  call Hloop_Q_A(ntryL,G0H4(244),19,0,G1H4(678),n2h4(1137))
  Gcoeff(:)%j = (-(c(150)*M(1,:)%j)) * den(114)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(3022),h0tab(:,3022),[19,12],[nMB,nMB],2,2,wf8(:,25),wf4(:,2))
  call Hloop_QZ_A(ntryL,G0H32(1),wf8(:,25),G0H4(244),ngZd,m3h8x4(:,1330),heltab2x32(:,:,3022))
  call Hloop_Q_A(ntryL,G0H4(244),19,nMB,G1H4(679),n2h4(1138))
  Gcoeff(:)%j = (-(c(161)*M(1,:)%j)) * den(113)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(3023),h0tab(:,3023),[19,12],[0,0],2,2,wf8(:,25),wf4(:,20))
  call Hloop_QZ_A(ntryL,G0H32(1),wf8(:,25),G0H4(244),ngZn,m3h8x4(:,1331),heltab2x32(:,:,3023))
  call Hloop_Q_A(ntryL,G0H4(244),19,0,G1H4(680),n2h4(1139))
  Gcoeff(:)%j = (-(c(158)*M(1,:)%j)) * den(113)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(3024),h0tab(:,3024),[19,12],[nME,nME],2,2,wf8(:,25),wf4(:,20))
  call Hloop_QZ_A(ntryL,G0H32(1),wf8(:,25),G0H4(244),ngZl,m3h8x4(:,1332),heltab2x32(:,:,3024))
  call Hloop_Q_A(ntryL,G0H4(244),19,nME,G1H4(681),n2h4(1140))
  Gcoeff(:)%j = (-(c(158)*M(1,:)%j)) * den(113)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(3025),h0tab(:,3025),[19,12],[nMM,nMM],2,2,wf8(:,25),wf4(:,20))
  call Hloop_QZ_A(ntryL,G0H32(1),wf8(:,25),G0H4(244),ngZl,m3h8x4(:,1333),heltab2x32(:,:,3025))
  call Hloop_Q_A(ntryL,G0H4(244),19,nMM,G1H4(682),n2h4(1141))
  Gcoeff(:)%j = (-(c(158)*M(1,:)%j)) * den(113)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(3026),h0tab(:,3026),[19,12],[nML,nML],2,2,wf8(:,25),wf4(:,20))
  call Hloop_QZ_A(ntryL,G0H32(1),wf8(:,25),G0H4(244),ngZl,m3h8x4(:,1334),heltab2x32(:,:,3026))
  call Hloop_Q_A(ntryL,G0H4(244),19,nML,G1H4(683),n2h4(1142))
  Gcoeff(:)%j = (-(c(160)*M(1,:)%j)) * den(113)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(3027),h0tab(:,3027),[19,12],[0,0],2,2,wf8(:,25),wf4(:,20))
  call Hloop_QZ_A(ntryL,G0H32(1),wf8(:,25),G0H4(244),ngZu,m3h8x4(:,1335),heltab2x32(:,:,3027))
  call Hloop_Q_A(ntryL,G0H4(244),19,0,G1H4(684),n2h4(1143))
  Gcoeff(:)%j = (-(c(159)*M(1,:)%j)) * den(113)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(3028),h0tab(:,3028),[19,12],[nMT,nMT],2,2,wf8(:,25),wf4(:,20))
  call Hloop_QZ_A(ntryL,G0H32(1),wf8(:,25),G0H4(244),ngZu,m3h8x4(:,1336),heltab2x32(:,:,3028))
  call Hloop_Q_A(ntryL,G0H4(244),19,nMT,G1H4(685),n2h4(1144))
  Gcoeff(:)%j = (-(c(160)*M(1,:)%j)) * den(113)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(3029),h0tab(:,3029),[19,12],[0,0],2,2,wf8(:,25),wf4(:,20))
  call Hloop_QZ_A(ntryL,G0H32(1),wf8(:,25),G0H4(244),ngZd,m3h8x4(:,1337),heltab2x32(:,:,3029))
  call Hloop_Q_A(ntryL,G0H4(244),19,0,G1H4(686),n2h4(1145))
  Gcoeff(:)%j = (-(c(159)*M(1,:)%j)) * den(113)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(3030),h0tab(:,3030),[19,12],[nMB,nMB],2,2,wf8(:,25),wf4(:,20))
  call Hloop_QZ_A(ntryL,G0H32(1),wf8(:,25),G0H4(244),ngZd,m3h8x4(:,1338),heltab2x32(:,:,3030))
  call Hloop_Q_A(ntryL,G0H4(244),19,nMB,G1H4(687),n2h4(1146))
  Gcoeff(:)%j = (-(c(5)*M(1,:)%j)) * den(117)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(3031),h0tab(:,3031),[19,12],[nMW,nMW],2,2,wf8(:,24),wf4(:,2))
  call Hloop_TV_S(ntryL,G0H32(1),0,wf8(:,24),19,G1H4(688),m3h8x4(:,1339),heltab2x32(:,:,3031))
  Gcoeff(:)%j = (-(c(145)*M(1,:)%j)) * den(116)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(3032),h0tab(:,3032),[19,12],[nMW,nMW],2,2,wf8(:,24),wf4(:,20))
  call Hloop_TV_S(ntryL,G0H32(1),0,wf8(:,24),19,G1H4(689),m3h8x4(:,1340),heltab2x32(:,:,3032))
  Gcoeff(:)%j = (c(144)*M(1,:)%j) * den(114)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(3033),h0tab(:,3033),[19,12],[nMW,nMW],2,2,wf8(:,25),wf4(:,2))
  call Hloop_TV_S(ntryL,G0H32(1),0,wf8(:,25),19,G1H4(690),m3h8x4(:,1341),heltab2x32(:,:,3033))
  Gcoeff(:)%j = (-(c(82)*M(1,:)%j)) * den(113)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(3034),h0tab(:,3034),[19,12],[nMZ,nMH],2,2,wf8(:,25),wf4(:,20))
  call Hloop_TV_S(ntryL,G0H32(1),0,wf8(:,25),19,G1H4(691),m3h8x4(:,1342),heltab2x32(:,:,3034))
  Gcoeff(:)%j = (c(146)*M(1,:)%j) * den(113)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(3035),h0tab(:,3035),[19,12],[nMW,nMW],2,2,wf8(:,25),wf4(:,20))
  call Hloop_TV_S(ntryL,G0H32(1),0,wf8(:,25),19,G1H4(692),m3h8x4(:,1343),heltab2x32(:,:,3035))
  Gcoeff(:)%j = (c(5)*M(1,:)%j) * den(117)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(3036),h0tab(:,3036),[19,12],[nMW,nMW],2,2,wf8(:,24),wf4(:,2))
  call Hloop_CV_D(ntryL,G0H32(1),0,wf8(:,24),19,G1H4(693),m3h8x4(:,1344),heltab2x32(:,:,3036))
  Gcoeff(:)%j = (c(5)*M(1,:)%j) * den(117)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(3037),h0tab(:,3037),[19,12],[nMW,nMW],2,2,wf8(:,24),wf4(:,2))
  call Hloop_CV_D(ntryL,G0H32(1),0,wf8(:,24),19,G1H4(694),m3h8x4(:,1345),heltab2x32(:,:,3037))
  Gcoeff(:)%j = (-(c(131)*M(1,:)%j)) * den(116)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(3038),h0tab(:,3038),[19,12],[nMW,nMW],2,2,wf8(:,24),wf4(:,20))
  call Hloop_CV_D(ntryL,G0H32(1),0,wf8(:,24),19,G1H4(695),m3h8x4(:,1346),heltab2x32(:,:,3038))
  Gcoeff(:)%j = (-(c(131)*M(1,:)%j)) * den(116)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(3039),h0tab(:,3039),[19,12],[nMW,nMW],2,2,wf8(:,24),wf4(:,20))
  call Hloop_CV_D(ntryL,G0H32(1),0,wf8(:,24),19,G1H4(696),m3h8x4(:,1347),heltab2x32(:,:,3039))
  Gcoeff(:)%j = (c(130)*M(1,:)%j) * den(114)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(3040),h0tab(:,3040),[19,12],[nMW,nMW],2,2,wf8(:,25),wf4(:,2))
  call Hloop_CV_D(ntryL,G0H32(1),0,wf8(:,25),19,G1H4(697),m3h8x4(:,1348),heltab2x32(:,:,3040))
  Gcoeff(:)%j = (c(130)*M(1,:)%j) * den(114)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(3041),h0tab(:,3041),[19,12],[nMW,nMW],2,2,wf8(:,25),wf4(:,2))
  call Hloop_CV_D(ntryL,G0H32(1),0,wf8(:,25),19,G1H4(698),m3h8x4(:,1349),heltab2x32(:,:,3041))
  Gcoeff(:)%j = (-(c(83)*M(1,:)%j)) * den(113)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(3042),h0tab(:,3042),[19,12],[nMW,nMW],2,2,wf8(:,25),wf4(:,20))
  call Hloop_CV_D(ntryL,G0H32(1),0,wf8(:,25),19,G1H4(699),m3h8x4(:,1350),heltab2x32(:,:,3042))
  Gcoeff(:)%j = (-(c(83)*M(1,:)%j)) * den(113)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(3043),h0tab(:,3043),[19,12],[nMW,nMW],2,2,wf8(:,25),wf4(:,20))
  call Hloop_CV_D(ntryL,G0H32(1),0,wf8(:,25),19,G1H4(700),m3h8x4(:,1351),heltab2x32(:,:,3043))
  Gcoeff(:)%j = (-(c(5)*M(1,:)%j)) * den(117)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(3044),h0tab(:,3044),[19,12],[nMW,nMW],2,2,wf8(:,24),wf4(:,2))
  call Hloop_UV_W(ntryL,G0H32(1),0,wf8(:,24),19,G1H4(701),m3h8x4(:,1352),heltab2x32(:,:,3044))
  Gcoeff(:)%j = (c(131)*M(1,:)%j) * den(116)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(3045),h0tab(:,3045),[19,12],[nMW,nMW],2,2,wf8(:,24),wf4(:,20))
  call Hloop_UV_W(ntryL,G0H32(1),0,wf8(:,24),19,G1H4(702),m3h8x4(:,1353),heltab2x32(:,:,3045))
  Gcoeff(:)%j = (-(c(130)*M(1,:)%j)) * den(114)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(3046),h0tab(:,3046),[19,12],[nMW,nMW],2,2,wf8(:,25),wf4(:,2))
  call Hloop_UV_W(ntryL,G0H32(1),0,wf8(:,25),19,G1H4(703),m3h8x4(:,1354),heltab2x32(:,:,3046))
  Gcoeff(:)%j = (c(83)*M(1,:)%j) * den(113)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(3047),h0tab(:,3047),[19,12],[nMW,nMW],2,2,wf8(:,25),wf4(:,20))
  call Hloop_UV_W(ntryL,G0H32(1),0,wf8(:,25),19,G1H4(704),m3h8x4(:,1355),heltab2x32(:,:,3047))
  Gcoeff(:)%j = (c(25)*M(1,:)%j) * den(117)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(3048),h0tab(:,3048),[19,12],[nMW,nMW],2,2,wf8(:,24),wf4(:,2))
  call Hloop_SV_V(ntryL,G0H32(1),wf8(:,24),G0H4(244),m3h8x4(:,1356),heltab2x32(:,:,3048))
  Gcoeff(:)%j = (c(25)*M(1,:)%j) * den(117)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(3049),h0tab(:,3049),[19,12],[nMW,nMW],2,2,wf8(:,24),wf4(:,2))
  call Hloop_SV_V(ntryL,G0H32(1),wf8(:,24),G0H4(245),m3h8x4(:,1357),heltab2x32(:,:,3049))
  Gcoeff(:)%j = (c(135)*M(1,:)%j) * den(116)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(3050),h0tab(:,3050),[19,12],[nMW,nMW],2,2,wf8(:,24),wf4(:,20))
  call Hloop_SV_V(ntryL,G0H32(1),wf8(:,24),G0H4(246),m3h8x4(:,1358),heltab2x32(:,:,3050))
  Gcoeff(:)%j = (c(135)*M(1,:)%j) * den(116)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(3051),h0tab(:,3051),[19,12],[nMW,nMW],2,2,wf8(:,24),wf4(:,20))
  call Hloop_SV_V(ntryL,G0H32(1),wf8(:,24),G0H4(247),m3h8x4(:,1359),heltab2x32(:,:,3051))
  Gcoeff(:)%j = (-(c(134)*M(1,:)%j)) * den(114)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(3052),h0tab(:,3052),[19,12],[nMW,nMW],2,2,wf8(:,25),wf4(:,2))
  call Hloop_SV_V(ntryL,G0H32(1),wf8(:,25),G0H4(248),m3h8x4(:,1360),heltab2x32(:,:,3052))
  Gcoeff(:)%j = (-(c(134)*M(1,:)%j)) * den(114)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(3053),h0tab(:,3053),[19,12],[nMW,nMW],2,2,wf8(:,25),wf4(:,2))
  call Hloop_SV_V(ntryL,G0H32(1),wf8(:,25),G0H4(249),m3h8x4(:,1361),heltab2x32(:,:,3053))
  Gcoeff(:)%j = (-(c(128)*M(1,:)%j)) * den(113)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(3054),h0tab(:,3054),[19,12],[nMZ,nMH],2,2,wf8(:,25),wf4(:,20))
  call Hloop_SV_V(ntryL,G0H32(1),wf8(:,25),G0H4(250),m3h8x4(:,1362),heltab2x32(:,:,3054))
  Gcoeff(:)%j = (-(c(136)*M(1,:)%j)) * den(113)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(3055),h0tab(:,3055),[19,12],[nMW,nMW],2,2,wf8(:,25),wf4(:,20))
  call Hloop_SV_V(ntryL,G0H32(1),wf8(:,25),G0H4(251),m3h8x4(:,1363),heltab2x32(:,:,3055))
  Gcoeff(:)%j = (-(c(136)*M(1,:)%j)) * den(113)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(3056),h0tab(:,3056),[19,12],[nMW,nMW],2,2,wf8(:,25),wf4(:,20))
  call Hloop_SV_V(ntryL,G0H32(1),wf8(:,25),G0H4(252),m3h8x4(:,1364),heltab2x32(:,:,3056))
  Gcoeff(:)%j = (c(52)*M(1,:)%j) * den(105)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(3057),h0tab(:,3057),[18,13],[nMT,nMH],2,2,wf4(:,16),wf8(:,167))
  call Hloop_SA_Q(ntryL,G0H32(1),wf4(:,16),G0H8(76),ngH,m3h4x8(:,923),heltab2x32(:,:,3057))
  call Hloop_A_Q(ntryL,G0H8(76),18,nMT,G1H8(20),n2h8(529))
  Gcoeff(:)%j = (-(c(52)*M(1,:)%j)) * den(105)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(3058),h0tab(:,3058),[18,13],[nMT,nMZ],2,2,wf4(:,16),wf8(:,167))
  call Hloop_SA_Q(ntryL,G0H32(1),wf4(:,16),G0H8(68),ngX,m3h4x8(:,924),heltab2x32(:,:,3058))
  call Hloop_A_Q(ntryL,G0H8(68),18,nMT,G1H8(16),n2h8(530))
  Gcoeff(:)%j = (-(c(40)*M(1,:)%j)) * den(105)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(3059),h0tab(:,3059),[18,13],[nMB,nMW],2,2,wf4(:,16),wf8(:,167))
  call Hloop_SA_Q(ntryL,G0H32(1),wf4(:,16),G0H8(75),ngPtb,m3h4x8(:,925),heltab2x32(:,:,3059))
  call Hloop_A_Q(ntryL,G0H8(75),18,nMB,G1H8(17),n2h8(531))
  Gcoeff(:)%j = (c(52)*M(1,:)%j) * den(107)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(3060),h0tab(:,3060),[18,13],[nMT,nMH],2,2,wf4(:,16),wf8(:,169))
  call Hloop_SA_Q(ntryL,G0H32(1),wf4(:,16),G0H8(123),ngH,m3h4x8(:,926),heltab2x32(:,:,3060))
  call Hloop_A_Q(ntryL,G0H8(123),18,nMT,G1H8(18),n2h8(532))
  Gcoeff(:)%j = (-(c(52)*M(1,:)%j)) * den(107)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(3061),h0tab(:,3061),[18,13],[nMT,nMZ],2,2,wf4(:,16),wf8(:,169))
  call Hloop_SA_Q(ntryL,G0H32(1),wf4(:,16),G0H8(129),ngX,m3h4x8(:,927),heltab2x32(:,:,3061))
  call Hloop_A_Q(ntryL,G0H8(129),18,nMT,G1H8(29),n2h8(533))
  Gcoeff(:)%j = (-(c(40)*M(1,:)%j)) * den(107)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(3062),h0tab(:,3062),[18,13],[nMB,nMW],2,2,wf4(:,16),wf8(:,169))
  call Hloop_SA_Q(ntryL,G0H32(1),wf4(:,16),G0H8(149),ngPtb,m3h4x8(:,928),heltab2x32(:,:,3062))
  call Hloop_A_Q(ntryL,G0H8(149),18,nMB,G1H8(30),n2h8(534))
  Gcoeff(:)%j = (-(c(114)*M(1,:)%j)) * den(105)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(3063),h0tab(:,3063),[18,13],[nMT,0],2,2,wf4(:,16),wf8(:,167))
  call Hloop_VA_Q(ntryL,G0H32(1),wf4(:,16),G0H8(155),m3h4x8(:,929),heltab2x32(:,:,3063))
  call Hloop_A_Q(ntryL,G0H8(155),18,nMT,G1H8(36),n2h8(535))
  Gcoeff(:)%j = (-(c(115)*M(1,:)%j)) * den(105)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(3064),h0tab(:,3064),[18,13],[nMT,nMZ],2,2,wf4(:,16),wf8(:,167))
  call Hloop_ZA_Q(ntryL,G0H32(1),wf4(:,16),G0H8(156),ngZu,m3h4x8(:,930),heltab2x32(:,:,3064))
  call Hloop_A_Q(ntryL,G0H8(156),18,nMT,G1H8(37),n2h8(536))
  Gcoeff(:)%j = (-(c(60)*M(1,:)%j)) * den(105)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(3065),h0tab(:,3065),[18,13],[nMB,nMW],2,2,wf4(:,16),wf8(:,167))
  call Hloop_WA_Q(ntryL,G0H32(1),wf4(:,16),G0H8(161),m3h4x8(:,931),heltab2x32(:,:,3065))
  call Hloop_A_Q(ntryL,G0H8(161),18,nMB,G1H8(48),n2h8(537))
  Gcoeff(:)%j = (-(c(120)*M(2,:)%j)) * den(105)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(3066),h0tab(:,3066),[18,13],[nMT,0],2,2,wf4(:,16),wf8(:,167))
  call Hloop_VA_Q(ntryL,G0H32(1),wf4(:,16),G0H8(16),m3h4x8(:,932),heltab2x32(:,:,3066))
  call Hloop_A_Q(ntryL,G0H8(16),18,nMT,G1H8(43),n2h8(538))
  Gcoeff(:)%j = (-(c(114)*M(1,:)%j)) * den(107)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(3067),h0tab(:,3067),[18,13],[nMT,0],2,2,wf4(:,16),wf8(:,169))
  call Hloop_VA_Q(ntryL,G0H32(1),wf4(:,16),G0H8(180),m3h4x8(:,933),heltab2x32(:,:,3067))
  call Hloop_A_Q(ntryL,G0H8(180),18,nMT,G1H8(44),n2h8(539))
  Gcoeff(:)%j = (-(c(115)*M(1,:)%j)) * den(107)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(3068),h0tab(:,3068),[18,13],[nMT,nMZ],2,2,wf4(:,16),wf8(:,169))
  call Hloop_ZA_Q(ntryL,G0H32(1),wf4(:,16),G0H8(15),ngZu,m3h4x8(:,934),heltab2x32(:,:,3068))
  call Hloop_A_Q(ntryL,G0H8(15),18,nMT,G1H8(61),n2h8(540))
  Gcoeff(:)%j = (-(c(60)*M(1,:)%j)) * den(107)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(3069),h0tab(:,3069),[18,13],[nMB,nMW],2,2,wf4(:,16),wf8(:,169))
  call Hloop_WA_Q(ntryL,G0H32(1),wf4(:,16),G0H8(146),m3h4x8(:,935),heltab2x32(:,:,3069))
  call Hloop_A_Q(ntryL,G0H8(146),18,nMB,G1H8(66),n2h8(541))
  Gcoeff(:)%j = (-(c(120)*M(2,:)%j)) * den(107)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(3070),h0tab(:,3070),[18,13],[nMT,0],2,2,wf4(:,16),wf8(:,169))
  call Hloop_VA_Q(ntryL,G0H32(1),wf4(:,16),G0H8(55),m3h4x8(:,936),heltab2x32(:,:,3070))
  call Hloop_A_Q(ntryL,G0H8(55),18,nMT,G1H8(67),n2h8(542))
  Gcoeff(:)%j = (c(122)*M(1,:)%j) * den(109)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(3071),h0tab(:,3071),[18,13],[nMT,nMH],2,2,wf4(:,16),wf8(:,171))
  call Hloop_SA_Q(ntryL,G0H32(1),wf4(:,16),G0H8(145),ngH,m3h4x8(:,937),heltab2x32(:,:,3071))
  call Hloop_A_Q(ntryL,G0H8(145),18,nMT,G1H8(77),n2h8(543))
  Gcoeff(:)%j = (-(c(122)*M(1,:)%j)) * den(109)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(3072),h0tab(:,3072),[18,13],[nMT,nMZ],2,2,wf4(:,16),wf8(:,171))
  call Hloop_SA_Q(ntryL,G0H32(1),wf4(:,16),G0H8(94),ngX,m3h4x8(:,938),heltab2x32(:,:,3072))
  call Hloop_A_Q(ntryL,G0H8(94),18,nMT,G1H8(78),n2h8(544))
  Gcoeff(:)%j = (-(c(96)*M(1,:)%j)) * den(109)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(3073),h0tab(:,3073),[18,13],[nMB,nMW],2,2,wf4(:,16),wf8(:,171))
  call Hloop_SA_Q(ntryL,G0H32(1),wf4(:,16),G0H8(102),ngPtb,m3h4x8(:,939),heltab2x32(:,:,3073))
  call Hloop_A_Q(ntryL,G0H8(102),18,nMB,G1H8(84),n2h8(545))
  Gcoeff(:)%j = (-(c(123)*M(1,:)%j)) * den(107)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(3074),h0tab(:,3074),[18,13],[nMT,nMH],2,2,wf4(:,16),wf8(:,173))
  call Hloop_SA_Q(ntryL,G0H32(1),wf4(:,16),G0H8(110),ngH,m3h4x8(:,940),heltab2x32(:,:,3074))
  call Hloop_A_Q(ntryL,G0H8(110),18,nMT,G1H8(85),n2h8(546))
  Gcoeff(:)%j = (c(123)*M(1,:)%j) * den(107)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(3075),h0tab(:,3075),[18,13],[nMT,nMZ],2,2,wf4(:,16),wf8(:,173))
  call Hloop_SA_Q(ntryL,G0H32(1),wf4(:,16),G0H8(83),ngX,m3h4x8(:,941),heltab2x32(:,:,3075))
  call Hloop_A_Q(ntryL,G0H8(83),18,nMT,G1H8(96),n2h8(547))
  Gcoeff(:)%j = (c(100)*M(1,:)%j) * den(107)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(3076),h0tab(:,3076),[18,13],[nMB,nMW],2,2,wf4(:,16),wf8(:,173))
  call Hloop_SA_Q(ntryL,G0H32(1),wf4(:,16),G0H8(80),ngPtb,m3h4x8(:,942),heltab2x32(:,:,3076))
  call Hloop_A_Q(ntryL,G0H8(80),18,nMB,G1H8(91),n2h8(548))
  Gcoeff(:)%j = (c(125)*M(2,:)%j-c(126)*M(4,:)%j) * den(109)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(3077),h0tab(:,3077),[18,13],[nMT,nMH],2,2,wf4(:,16),wf8(:,171))
  call Hloop_SA_Q(ntryL,G0H32(1),wf4(:,16),G0H8(85),ngH,m3h4x8(:,943),heltab2x32(:,:,3077))
  call Hloop_A_Q(ntryL,G0H8(85),18,nMT,G1H8(92),n2h8(549))
  Gcoeff(:)%j = (-(c(125)*M(2,:)%j)+c(126)*M(4,:)%j) * den(109)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(3078),h0tab(:,3078),[18,13],[nMT,nMZ],2,2,wf4(:,16),wf8(:,171))
  call Hloop_SA_Q(ntryL,G0H32(1),wf4(:,16),G0H8(178),ngX,m3h4x8(:,944),heltab2x32(:,:,3078))
  call Hloop_A_Q(ntryL,G0H8(178),18,nMT,G1H8(93),n2h8(550))
  Gcoeff(:)%j = (-(c(103)*M(2,:)%j)+c(104)*M(4,:)%j) * den(109)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(3079),h0tab(:,3079),[18,13],[nMB,nMW],2,2,wf4(:,16),wf8(:,171))
  call Hloop_SA_Q(ntryL,G0H32(1),wf4(:,16),G0H8(179),ngPtb,m3h4x8(:,945),heltab2x32(:,:,3079))
  call Hloop_A_Q(ntryL,G0H8(179),18,nMB,G1H8(104),n2h8(551))
  Gcoeff(:)%j = (-(c(3)*M(1,:)%j)) * den(109)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(3080),h0tab(:,3080),[18,13],[nMT,0],2,2,wf4(:,16),wf8(:,171))
  call Hloop_VA_Q(ntryL,G0H32(1),wf4(:,16),G0H8(33),m3h4x8(:,946),heltab2x32(:,:,3080))
  call Hloop_A_Q(ntryL,G0H8(33),18,nMT,G1H8(111),n2h8(552))
  Gcoeff(:)%j = (-(c(5)*M(1,:)%j)) * den(109)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(3081),h0tab(:,3081),[18,13],[nMT,nMZ],2,2,wf4(:,16),wf8(:,171))
  call Hloop_ZA_Q(ntryL,G0H32(1),wf4(:,16),G0H8(177),ngZu,m3h4x8(:,947),heltab2x32(:,:,3081))
  call Hloop_A_Q(ntryL,G0H8(177),18,nMT,G1H8(120),n2h8(553))
  Gcoeff(:)%j = (-(c(77)*M(1,:)%j)) * den(109)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(3082),h0tab(:,3082),[18,13],[nMB,nMW],2,2,wf4(:,16),wf8(:,171))
  call Hloop_WA_Q(ntryL,G0H32(1),wf4(:,16),G0H8(172),m3h4x8(:,948),heltab2x32(:,:,3082))
  call Hloop_A_Q(ntryL,G0H8(172),18,nMB,G1H8(310),n2h8(554))
  Gcoeff(:)%j = (-(c(19)*M(2,:)%j)) * den(109)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(3083),h0tab(:,3083),[18,13],[nMT,0],2,2,wf4(:,16),wf8(:,171))
  call Hloop_VA_Q(ntryL,G0H32(1),wf4(:,16),G0H8(181),m3h4x8(:,949),heltab2x32(:,:,3083))
  call Hloop_A_Q(ntryL,G0H8(181),18,nMT,G1H8(317),n2h8(555))
  Gcoeff(:)%j = (c(6)*M(1,:)%j) * den(107)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(3084),h0tab(:,3084),[18,13],[nMT,0],2,2,wf4(:,16),wf8(:,173))
  call Hloop_VA_Q(ntryL,G0H32(1),wf4(:,16),G0H8(45),m3h4x8(:,950),heltab2x32(:,:,3084))
  call Hloop_A_Q(ntryL,G0H8(45),18,nMT,G1H8(116),n2h8(556))
  Gcoeff(:)%j = (c(7)*M(1,:)%j) * den(107)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(3085),h0tab(:,3085),[18,13],[nMT,nMZ],2,2,wf4(:,16),wf8(:,173))
  call Hloop_ZA_Q(ntryL,G0H32(1),wf4(:,16),G0H8(50),ngZu,m3h4x8(:,951),heltab2x32(:,:,3085))
  call Hloop_A_Q(ntryL,G0H8(50),18,nMT,G1H8(117),n2h8(557))
  Gcoeff(:)%j = (c(81)*M(1,:)%j) * den(107)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(3086),h0tab(:,3086),[18,13],[nMB,nMW],2,2,wf4(:,16),wf8(:,173))
  call Hloop_WA_Q(ntryL,G0H32(1),wf4(:,16),G0H8(78),m3h4x8(:,952),heltab2x32(:,:,3086))
  call Hloop_A_Q(ntryL,G0H8(78),18,nMB,G1H8(118),n2h8(558))
  Gcoeff(:)%j = (c(24)*M(2,:)%j) * den(107)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(3087),h0tab(:,3087),[18,13],[nMT,0],2,2,wf4(:,16),wf8(:,173))
  call Hloop_VA_Q(ntryL,G0H32(1),wf4(:,16),G0H8(79),m3h4x8(:,953),heltab2x32(:,:,3087))
  call Hloop_A_Q(ntryL,G0H8(79),18,nMT,G1H8(128),n2h8(559))
  Gcoeff(:)%j = (-(c(20)*M(2,:)%j)+c(21)*M(4,:)%j) * den(109)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(3088),h0tab(:,3088),[18,13],[nMT,0],2,2,wf4(:,16),wf8(:,171))
  call Hloop_VA_Q(ntryL,G0H32(1),wf4(:,16),G0H8(90),m3h4x8(:,954),heltab2x32(:,:,3088))
  call Hloop_A_Q(ntryL,G0H8(90),18,nMT,G1H8(133),n2h8(560))
  Gcoeff(:)%j = (-(c(22)*M(2,:)%j)+c(23)*M(4,:)%j) * den(109)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(3089),h0tab(:,3089),[18,13],[nMT,nMZ],2,2,wf4(:,16),wf8(:,171))
  call Hloop_ZA_Q(ntryL,G0H32(1),wf4(:,16),G0H8(91),ngZu,m3h4x8(:,955),heltab2x32(:,:,3089))
  call Hloop_A_Q(ntryL,G0H8(91),18,nMT,G1H8(139),n2h8(561))
  Gcoeff(:)%j = (-(c(86)*M(2,:)%j)+c(87)*M(4,:)%j) * den(109)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(3090),h0tab(:,3090),[18,13],[nMB,nMW],2,2,wf4(:,16),wf8(:,171))
  call Hloop_WA_Q(ntryL,G0H32(1),wf4(:,16),G0H8(97),m3h4x8(:,956),heltab2x32(:,:,3090))
  call Hloop_A_Q(ntryL,G0H8(97),18,nMB,G1H8(140),n2h8(562))
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G0H8(61),[G0H8(185)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G0H8(1),[G0H8(130)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G0H8(58),[G0H8(2)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G0H8(167),[G0H8(19)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G0H8(25),[G0H8(57)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G0H8(30),[G0H8(166),G0H8(40)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G0H8(35),[G0H8(37)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G0H8(36),[G0H8(84)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G0H8(171),[G0H8(169)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(124),[G1H4(79),G1H4(267),G1H4(254),G1H4(416),G1H4(125) &
    ,G1H4(287),G1H4(99)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(59),[G1H4(53),G1H4(294),G1H4(137),G1H4(417),G1H4(5) &
    ,G1H4(270),G1H4(69)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(60),[G1H4(43),G1H4(96),G1H4(275),G1H4(418),G1H4(401) &
    ,G1H4(260),G1H4(304)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(67),[G1H4(123),G1H4(92),G1H4(256),G1H4(91),G1H4(402) &
    ,G1H4(244),G1H4(301)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(78),[G1H4(50),G1H4(101),G1H4(200),G1H4(95),G1H4(403) &
    ,G1H4(238),G1H4(296)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(152),[G1H4(145),G1H4(138),G1H4(144),G1H4(220),G1H4(86) &
    ,G1H4(288),G1H4(105)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(17),[G1H4(196),G1H4(120),G1H4(132),G1H4(219),G1H4(154) &
    ,G1H4(273),G1H4(75)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(157),[G1H4(153),G1H4(2),G1H4(108),G1H4(139),G1H4(164) &
    ,G1H4(255),G1H4(305)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(158),[G1H4(146),G1H4(127),G1H4(293),G1H4(360),G1H4(162) &
    ,G1H4(119),G1H4(302)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(180),[G1H4(61),G1H4(143),G1H4(128),G1H4(361),G1H4(186) &
    ,G1H4(131),G1H4(297)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G0H4(60),[G0H4(94)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G0H4(48),[G0H4(69)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(173),[G1H4(193),G1H4(363),G1H4(362),G0H4(61),G0H4(1)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(163),[G1H4(368),G0H4(49),G0H4(2)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G0H4(62),[G0H4(28)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(177),[G1H4(65),G1H4(172),G1H4(149),G1H4(354),G1H4(353) &
    ,G1H4(352),G1H4(367),G0H4(64),G0H4(93),G0H4(89),G0H4(88),G0H4(30),G0H4(4),G0H4(29),G0H4(3)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(206),[G1H4(248),G1H4(199),G1H4(182),G1H4(358),G1H4(357) &
    ,G1H4(356),G1H4(355),G0H4(66),G0H4(91),G0H4(65),G0H4(90),G0H4(10),G0H4(33),G0H4(35),G0H4(5)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G0H4(92),[G0H4(8)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(247),[G1H4(212),G1H4(369),G1H4(359),G0H4(67),G0H4(34)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(13),[G1H4(109)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(23),[G1H4(14),G1H4(25),G1H4(68),G1H4(97),G1H4(110) &
    ,G1H4(126),G1H4(103),G0H4(22),G0H4(84),G0H4(21),G0H4(83),G0H4(24),G0H4(86),G0H4(23),G0H4(85)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(42),[G1H4(32),G1H4(36),G1H4(24),G1H4(6),G1H4(266) &
    ,G1H4(257),G1H4(111),G0H4(19),G0H4(81),G0H4(80),G0H4(17),G0H4(79),G0H4(16),G0H4(25),G0H4(87)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(31),[G1H4(264),G0H4(18),G0H4(78)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(46),[G1H4(100),G1H4(245),G1H4(205),G1H4(320),G1H4(390) &
    ,G1H4(171),G1H4(370)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(396),[G1H4(7),G1H4(224),G1H4(233),G1H4(156),G1H4(389) &
    ,G1H4(174),G1H4(371)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(399),[G1H4(38),G1H4(229),G1H4(211),G1H4(215),G1H4(391) &
    ,G1H4(175),G1H4(372)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(85),[G1H4(129),G1H4(250),G1H4(213),G1H4(217),G1H4(393) &
    ,G1H4(176),G1H4(364)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(415),[G1H4(321),G1H4(234),G1H4(218),G1H4(30),G1H4(310) &
    ,G1H4(190),G1H4(365)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(94),[G1H4(334),G1H4(282),G1H4(392),G1H4(130),G1H4(192) &
    ,G1H4(160),G1H4(189)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(292),[G1H4(161),G1H4(284),G1H4(228),G1H4(49),G1H4(41) &
    ,G1H4(178),G1H4(167)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(9),[G1H4(265),G1H4(74),G1H4(232),G1H4(15),G1H4(246) &
    ,G1H4(179),G1H4(166)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(348),[G1H4(240),G1H4(64),G1H4(317),G1H4(16),G1H4(251) &
    ,G1H4(165),G1H4(168)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(20),[G1H4(291),G1H4(77),G1H4(262),G1H4(28),G1H4(183) &
    ,G1H4(191),G1H4(159)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(21),[G1H4(10),G1H4(58),G1H4(45),G0H4(99),G0H4(50)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(140),[G1H4(62),G1H4(326),G1H4(93),G0H4(74),G0H4(53)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(44),[G1H4(63),G0H4(68),G0H4(41)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(35),[G1H4(66),G1H4(83),G1H4(52),G1H4(122),G1H4(98) &
    ,G1H4(117),G1H4(87),G0H4(13),G0H4(36),G0H4(38),G0H4(9),G0H4(43),G0H4(55),G0H4(42),G0H4(54)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(72),[G1H4(71),G1H4(8),G1H4(37),G1H4(188),G1H4(121) &
    ,G1H4(236),G1H4(102),G0H4(51),G0H4(20),G0H4(37),G0H4(11),G0H4(26),G0H4(63),G0H4(44),G0H4(56)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(345),[G1H4(388),G1H4(198),G1H4(223),G0H4(39),G0H4(27)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(237),[G1H4(241),G1H4(221),G1H4(381),G0H4(52),G0H4(31)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(150),[G1H4(76),G1H4(148),G1H4(70),G1H4(184),G1H4(210) &
    ,G1H4(197),G1H4(194),G0H4(75),G0H4(98),G0H4(100),G0H4(71),G0H4(7),G0H4(32),G0H4(6),G0H4(12)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(11),[G1H4(169),G1H4(201),G1H4(82),G1H4(387),G1H4(406) &
    ,G1H4(407),G1H4(185),G0H4(58),G0H4(45),G0H4(40),G0H4(73),G0H4(82),G0H4(15),G0H4(14),G0H4(76)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(112),[G1H4(405),G0H4(57),G0H4(77)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(412),[G1H4(329),G1H4(142),G1H4(3),G1H4(187),G1H4(239) &
    ,G1H4(420),G1H4(394)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(366),[G1H4(385),G1H4(33),G1H4(346)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(4),[G1H4(272),G1H4(207),G1H4(225)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(141),[G1H4(88)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H8(90),[G1H8(80)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H8(94),[G1H8(86)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H8(106),[G1H8(95)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H8(127),[G1H8(107)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H8(132),[G1H8(114)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H8(141),[G1H8(130),G1H8(119)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H8(143),[G1H8(124)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H8(144),[G1H8(129)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H8(135),[G1H8(131)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(277),[G1H4(81)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(261),[G1H4(57)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(115),[G1H4(318)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(107),[G1H4(300)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(113),[G0H4(95)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(319),[G0H4(72)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(315),[G0H4(70)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(311),[G0H4(96)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(299),[G0H4(46)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(314),[G0H4(47)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(313),[G0H4(97)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(281),[G0H4(59)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(283),[G1H4(278)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(279),[G1H4(316)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(258),[G1H4(116)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(395),[G1H4(104)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(376),[G0H4(101)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(324),[G0H4(102)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(202),[G0H4(103)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(259),[G0H4(104)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(377),[G0H4(105)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(374),[G0H4(106)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(114),[G0H4(107)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(90),[G0H4(108)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(312),[G0H4(109)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G0H8(64),[G0H8(48)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G0H8(95),[G0H8(87)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H8(151),[G1H8(155)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H8(166),[G1H8(170)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(408),[G1H4(328)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(386),[G1H4(325)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(383),[G1H4(322)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(382),[G1H4(208)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(379),[G0H4(110)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(341),[G0H4(111)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(338),[G0H4(112)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(337),[G0H4(113)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(231),[G0H4(114)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(203),[G0H4(121)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(263),[G0H4(122)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(400),[G0H4(123)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(230),[G1H4(378)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(413),[G1H4(375)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(409),[G1H4(323)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(380),[G1H4(209)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(343),[G0H4(115)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(222),[G0H4(116)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(216),[G0H4(117)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(271),[G0H4(118)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(414),[G0H4(119)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(410),[G0H4(120)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(204),[G0H4(124)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(269),[G0H4(125)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(411),[G0H4(126)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G0H8(132),[G0H8(124)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G0H8(140),[G0H8(137)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(73),[G1H4(195),G1H4(308),G1H4(344)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(80),[G1H4(151),G1H4(285),G1H4(340)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(55),[G1H4(147),G1H4(155),G1H4(336)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(56),[G1H4(12),G1H4(290),G1H4(235)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(404),[G1H4(286),G0H4(144),G0H4(127)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(333),[G1H4(289),G0H4(145),G0H4(128)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(331),[G1H4(214),G0H4(146),G0H4(129)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(332),[G1H4(347),G0H4(147),G0H4(130)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(227),[G1H4(136),G0H4(148),G0H4(131)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(18),[G1H4(276),G0H4(149),G0H4(132)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(19),[G1H4(309),G0H4(150),G0H4(133)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(26),[G1H4(306),G0H4(151),G0H4(134)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(29),[G1H4(307)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(330),[G1H4(118)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(274),[G1H4(249),G1H4(350),G1H4(170)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(268),[G1H4(252),G1H4(27),G1H4(351)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(253),[G1H4(243),G1H4(106),G1H4(349)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(226),[G1H4(419),G1H4(135),G1H4(34)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(421),[G1H4(39),G0H4(152),G0H4(135)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(423),[G1H4(51),G0H4(153),G0H4(136)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(424),[G1H4(84),G0H4(154),G0H4(137)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(426),[G1H4(1),G0H4(155),G0H4(138)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(427),[G1H4(48),G0H4(156),G0H4(139)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(428),[G1H4(54),G0H4(157),G0H4(140)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(303),[G1H4(22),G0H4(158),G0H4(141)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(298),[G1H4(133),G0H4(159),G0H4(142)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(295),[G1H4(181),G0H4(160),G0H4(143)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(242),[G1H4(134)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(422),[G1H4(40)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(425),[G1H4(47)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H8(178),[G1H8(302)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H8(11),[G1H8(182)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(636),[G1H4(626),G1H4(577),G1H4(567),G1H4(498),G1H4(488) &
    ,G1H4(439),G1H4(429)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(637),[G1H4(627),G1H4(578),G1H4(568),G1H4(499),G1H4(489) &
    ,G1H4(440),G1H4(430)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(638),[G1H4(628),G1H4(579),G1H4(569),G1H4(500),G1H4(490) &
    ,G1H4(441),G1H4(431)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(639),[G1H4(629),G1H4(580),G1H4(570),G1H4(501),G1H4(491) &
    ,G1H4(442),G1H4(432)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(640),[G1H4(630),G1H4(581),G1H4(571),G1H4(502),G1H4(492) &
    ,G1H4(443),G1H4(433)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(641),[G1H4(631),G1H4(582),G1H4(572),G1H4(503),G1H4(493) &
    ,G1H4(444),G1H4(434)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(642),[G1H4(632),G1H4(583),G1H4(573),G1H4(504),G1H4(494) &
    ,G1H4(445),G1H4(435)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(643),[G1H4(633),G1H4(584),G1H4(574),G1H4(505),G1H4(495) &
    ,G1H4(446),G1H4(436)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(644),[G1H4(634),G1H4(585),G1H4(575),G1H4(506),G1H4(496) &
    ,G1H4(447),G1H4(437)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(645),[G1H4(635),G1H4(586),G1H4(576),G1H4(507),G1H4(497) &
    ,G1H4(448),G1H4(438)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G0H4(207),[G0H4(161)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G0H4(208),[G0H4(162)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(647),[G1H4(646),G1H4(509),G1H4(508),G0H4(209) &
    ,G0H4(163)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(648),[G1H4(510),G0H4(210),G0H4(164)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G0H4(211),[G0H4(165)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(654),[G1H4(653),G1H4(650),G1H4(649),G1H4(516),G1H4(515) &
    ,G1H4(512),G1H4(511),G0H4(217),G0H4(216),G0H4(213),G0H4(212),G0H4(171),G0H4(170),G0H4(167),G0H4(166)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(656),[G1H4(655),G1H4(652),G1H4(651),G1H4(518),G1H4(517) &
    ,G1H4(514),G1H4(513),G0H4(219),G0H4(218),G0H4(215),G0H4(214),G0H4(173),G0H4(172),G0H4(169),G0H4(168)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G0H4(220),[G0H4(174)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(658),[G1H4(657),G1H4(520),G1H4(519),G0H4(221) &
    ,G0H4(175)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(587),[G1H4(449)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(593),[G1H4(592),G1H4(589),G1H4(588),G1H4(455),G1H4(454) &
    ,G1H4(451),G1H4(450),G0H4(240),G0H4(239),G0H4(236),G0H4(235),G0H4(194),G0H4(193),G0H4(190),G0H4(189)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(596),[G1H4(595),G1H4(591),G1H4(590),G1H4(458),G1H4(457) &
    ,G1H4(453),G1H4(452),G0H4(243),G0H4(242),G0H4(238),G0H4(237),G0H4(197),G0H4(196),G0H4(192),G0H4(191)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(594),[G1H4(456),G0H4(241),G0H4(195)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(673),[G1H4(659),G1H4(607),G1H4(597),G1H4(535),G1H4(521) &
    ,G1H4(469),G1H4(459)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(674),[G1H4(660),G1H4(608),G1H4(598),G1H4(536),G1H4(522) &
    ,G1H4(470),G1H4(460)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(675),[G1H4(661),G1H4(609),G1H4(599),G1H4(537),G1H4(523) &
    ,G1H4(471),G1H4(461)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(677),[G1H4(663),G1H4(610),G1H4(600),G1H4(539),G1H4(525) &
    ,G1H4(472),G1H4(462)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(679),[G1H4(665),G1H4(611),G1H4(601),G1H4(541),G1H4(527) &
    ,G1H4(473),G1H4(463)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(681),[G1H4(666),G1H4(612),G1H4(602),G1H4(543),G1H4(528) &
    ,G1H4(474),G1H4(464)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(682),[G1H4(667),G1H4(613),G1H4(603),G1H4(544),G1H4(529) &
    ,G1H4(475),G1H4(465)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(683),[G1H4(668),G1H4(614),G1H4(604),G1H4(545),G1H4(530) &
    ,G1H4(476),G1H4(466)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(685),[G1H4(670),G1H4(615),G1H4(605),G1H4(547),G1H4(532) &
    ,G1H4(477),G1H4(467)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(687),[G1H4(672),G1H4(616),G1H4(606),G1H4(549),G1H4(534) &
    ,G1H4(478),G1H4(468)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(690),[G1H4(688),G1H4(552),G1H4(550),G0H4(222) &
    ,G0H4(176)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(692),[G1H4(689),G1H4(554),G1H4(551),G0H4(223) &
    ,G0H4(177)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(691),[G1H4(553),G0H4(224),G0H4(178)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(698),[G1H4(697),G1H4(694),G1H4(693),G1H4(560),G1H4(559) &
    ,G1H4(556),G1H4(555),G0H4(230),G0H4(229),G0H4(226),G0H4(225),G0H4(184),G0H4(183),G0H4(180),G0H4(179)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(700),[G1H4(699),G1H4(696),G1H4(695),G1H4(562),G1H4(561) &
    ,G1H4(558),G1H4(557),G0H4(232),G0H4(231),G0H4(228),G0H4(227),G0H4(186),G0H4(185),G0H4(182),G0H4(181)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(703),[G1H4(701),G1H4(565),G1H4(563),G0H4(233) &
    ,G0H4(187)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(704),[G1H4(702),G1H4(566),G1H4(564),G0H4(234) &
    ,G0H4(188)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(622),[G1H4(621),G1H4(618),G1H4(617),G1H4(484),G1H4(483) &
    ,G1H4(480),G1H4(479),G0H4(249),G0H4(248),G0H4(245),G0H4(244),G0H4(203),G0H4(202),G0H4(199),G0H4(198)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(625),[G1H4(624),G1H4(620),G1H4(619),G1H4(487),G1H4(486) &
    ,G1H4(482),G1H4(481),G0H4(252),G0H4(251),G0H4(247),G0H4(246),G0H4(206),G0H4(205),G0H4(201),G0H4(200)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(623),[G1H4(485),G0H4(250),G0H4(204)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(678),[G1H4(676),G1H4(664),G1H4(662),G1H4(540),G1H4(538) &
    ,G1H4(526),G1H4(524)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(684),[G1H4(669),G1H4(546),G1H4(531)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(686),[G1H4(671),G1H4(548),G1H4(533)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(680),[G1H4(542)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G0H8(100),[G0H8(60)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G0H8(168),[G0H8(101)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G0H8(65),[G0H8(175)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G0H8(66),[G0H8(176)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G0H8(127),[G0H8(182)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G0H8(73),[G0H8(31),G0H8(81)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G0H8(74),[G0H8(122)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G0H8(82),[G0H8(34)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G0H8(18),[G0H8(32)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H8(43),[G1H8(36)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H8(67),[G1H8(44)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H8(92),[G1H8(77)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H8(93),[G1H8(78)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H8(104),[G1H8(84)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H8(133),[G1H8(317),G1H8(111)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H8(139),[G1H8(120)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H8(140),[G1H8(310)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H8(128),[G1H8(116)])
  call Hloop_SA_Q(ntryL,G0H8(163),wf8(:,130),G0H1(1),ngH,m3h8x1(:,127),heltab2x8(:,:,1143))
  call Hcheck_last_A_Q(ntryL,l_switch,G0H1(1),31,nMB,G1tensor(155),n2h1(1027))
  call Hloop_SA_Q(ntryL,G0H8(164),wf8(:,130),G0H1(1),ngX,m3h8x1(:,128),heltab2x8(:,:,1144))
  call Hcheck_last_A_Q(ntryL,l_switch,G0H1(1),31,nMB,G1tensor(165),n2h1(1028))
  call Hloop_SA_Q(ntryL,G0H8(39),wf8(:,130),G0H1(1),ngPbt,m3h8x1(:,129),heltab2x8(:,:,1145))
  call Hcheck_last_A_Q(ntryL,l_switch,G0H1(1),31,nMT,G1tensor(177),n2h1(1029))
  call Hloop_SA_Q(ntryL,G0H8(126),wf8(:,131),G0H1(1),ngH,m3h8x1(:,130),heltab2x8(:,:,1146))
  call Hcheck_last_A_Q(ntryL,l_switch,G0H1(1),31,nMB,G1tensor(201),n2h1(1030))
  call Hloop_SA_Q(ntryL,G0H8(162),wf8(:,131),G0H1(1),ngX,m3h8x1(:,131),heltab2x8(:,:,1147))
  call Hcheck_last_A_Q(ntryL,l_switch,G0H1(1),31,nMB,G1tensor(287),n2h1(1031))
  call Hloop_SA_Q(ntryL,G0H8(158),wf8(:,131),G0H1(1),ngPbt,m3h8x1(:,132),heltab2x8(:,:,1148))
  call Hcheck_last_A_Q(ntryL,l_switch,G0H1(1),31,nMT,G1tensor(221),n2h1(1032))
  call Hloop_VA_Q(ntryL,G0H8(61),wf8(:,130),G0H1(1),m3h8x1(:,133),heltab2x8(:,:,1149))
  call Hcheck_last_A_Q(ntryL,l_switch,G0H1(1),31,nMB,G1tensor(232),n2h1(1033))
  call Hloop_ZA_Q(ntryL,G0H8(128),wf8(:,130),G0H1(1),ngZd,m3h8x1(:,134),heltab2x8(:,:,1150))
  call Hcheck_last_A_Q(ntryL,l_switch,G0H1(1),31,nMB,G1tensor(317),n2h1(1034))
  call Hloop_WA_Q(ntryL,G0H8(21),wf8(:,130),G0H1(1),m3h8x1(:,135),heltab2x8(:,:,1151))
  call Hcheck_last_A_Q(ntryL,l_switch,G0H1(1),31,nMT,G1tensor(280),n2h1(1035))
  call Hloop_VA_Q(ntryL,G0H8(1),wf8(:,131),G0H1(1),m3h8x1(:,136),heltab2x8(:,:,1152))
  call Hcheck_last_A_Q(ntryL,l_switch,G0H1(1),31,nMB,G1tensor(255),n2h1(1036))
  call Hloop_ZA_Q(ntryL,G0H8(56),wf8(:,131),G0H1(1),ngZd,m3h8x1(:,137),heltab2x8(:,:,1153))
  call Hcheck_last_A_Q(ntryL,l_switch,G0H1(1),31,nMB,G1tensor(335),n2h1(1037))
  call Hloop_WA_Q(ntryL,G0H8(72),wf8(:,131),G0H1(1),m3h8x1(:,138),heltab2x8(:,:,1154))
  call Hcheck_last_A_Q(ntryL,l_switch,G0H1(1),31,nMT,G1tensor(269),n2h1(1038))
  call Hloop_SA_Q(ntryL,G0H8(58),wf8(:,132),G0H1(1),ngH,m3h8x1(:,139),heltab2x8(:,:,1155))
  call Hcheck_last_A_Q(ntryL,l_switch,G0H1(1),31,nMB,G1tensor(279),n2h1(1039))
  call Hloop_SA_Q(ntryL,G0H8(167),wf8(:,132),G0H1(1),ngX,m3h8x1(:,140),heltab2x8(:,:,1156))
  call Hcheck_last_A_Q(ntryL,l_switch,G0H1(1),31,nMB,G1tensor(298),n2h1(1040))
  call Hloop_SA_Q(ntryL,G0H8(25),wf8(:,132),G0H1(1),ngPbt,m3h8x1(:,141),heltab2x8(:,:,1157))
  call Hcheck_last_A_Q(ntryL,l_switch,G0H1(1),31,nMT,G1tensor(303),n2h1(1041))
  call Hloop_SA_Q(ntryL,G0H8(51),wf8(:,133),G0H1(1),ngH,m3h8x1(:,142),heltab2x8(:,:,1158))
  call Hcheck_last_A_Q(ntryL,l_switch,G0H1(1),31,nMB,G1tensor(321),n2h1(1042))
  call Hloop_SA_Q(ntryL,G0H8(52),wf8(:,133),G0H1(1),ngX,m3h8x1(:,143),heltab2x8(:,:,1159))
  call Hcheck_last_A_Q(ntryL,l_switch,G0H1(1),31,nMB,G1tensor(351),n2h1(1043))
  call Hloop_SA_Q(ntryL,G0H8(53),wf8(:,133),G0H1(1),ngPbt,m3h8x1(:,144),heltab2x8(:,:,1160))
  call Hcheck_last_A_Q(ntryL,l_switch,G0H1(1),31,nMT,G1tensor(419),n2h1(1044))
  call Hloop_VA_Q(ntryL,G0H8(30),wf8(:,132),G0H1(1),m3h8x1(:,145),heltab2x8(:,:,1161))
  call Hcheck_last_A_Q(ntryL,l_switch,G0H1(1),31,nMB,G1tensor(364),n2h1(1045))
  call Hloop_ZA_Q(ntryL,G0H8(35),wf8(:,132),G0H1(1),ngZd,m3h8x1(:,146),heltab2x8(:,:,1162))
  call Hcheck_last_A_Q(ntryL,l_switch,G0H1(1),31,nMB,G1tensor(371),n2h1(1046))
  call Hloop_WA_Q(ntryL,G0H8(36),wf8(:,132),G0H1(1),m3h8x1(:,147),heltab2x8(:,:,1163))
  call Hcheck_last_A_Q(ntryL,l_switch,G0H1(1),31,nMT,G1tensor(382),n2h1(1047))
  call Hloop_VA_Q(ntryL,G0H8(171),wf8(:,133),G0H1(1),m3h8x1(:,148),heltab2x8(:,:,1164))
  call Hcheck_last_A_Q(ntryL,l_switch,G0H1(1),31,nMB,G1tensor(388),n2h1(1048))
  call Hloop_ZA_Q(ntryL,G0H8(170),wf8(:,133),G0H1(1),ngZd,m3h8x1(:,149),heltab2x8(:,:,1165))
  call Hcheck_last_A_Q(ntryL,l_switch,G0H1(1),31,nMB,G1tensor(395),n2h1(1049))
  call Hloop_WA_Q(ntryL,G0H8(157),wf8(:,133),G0H1(1),m3h8x1(:,150),heltab2x8(:,:,1166))
  call Hcheck_last_A_Q(ntryL,l_switch,G0H1(1),31,nMT,G1tensor(461),n2h1(1050))
  call Hloop_QS_A(ntryL,G1H4(124),wf4(:,3),G1H1(1),ngH,m3h4x1(:,377),heltab2x4(:,:,905))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,nME,G2tensor(177),n2h1(1051))
  call Hloop_QS_A(ntryL,G1H4(59),wf4(:,3),G1H1(1),ngH,m3h4x1(:,378),heltab2x4(:,:,906))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,nMM,G2tensor(365),n2h1(1052))
  call Hloop_QS_A(ntryL,G1H4(60),wf4(:,3),G1H1(1),ngH,m3h4x1(:,379),heltab2x4(:,:,907))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,nML,G2tensor(183),n2h1(1053))
  call Hloop_QS_A(ntryL,G1H4(67),wf4(:,3),G1H1(1),ngH,m3h4x1(:,380),heltab2x4(:,:,908))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,nMT,G2tensor(366),n2h1(1054))
  call Hloop_QS_A(ntryL,G1H4(78),wf4(:,3),G1H1(1),ngH,m3h4x1(:,381),heltab2x4(:,:,909))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,nMB,G2tensor(201),n2h1(1055))
  call Hloop_QS_A(ntryL,G1H4(152),wf4(:,6),G1H1(1),ngX,m3h4x1(:,382),heltab2x4(:,:,910))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,nME,G2tensor(225),n2h1(1056))
  call Hloop_QS_A(ntryL,G1H4(17),wf4(:,6),G1H1(1),ngX,m3h4x1(:,383),heltab2x4(:,:,911))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,nMM,G2tensor(367),n2h1(1057))
  call Hloop_QS_A(ntryL,G1H4(157),wf4(:,6),G1H1(1),ngX,m3h4x1(:,384),heltab2x4(:,:,912))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,nML,G2tensor(210),n2h1(1058))
  call Hloop_QS_A(ntryL,G1H4(158),wf4(:,6),G1H1(1),ngX,m3h4x1(:,385),heltab2x4(:,:,913))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,nMT,G2tensor(368),n2h1(1059))
  call Hloop_QS_A(ntryL,G1H4(180),wf4(:,6),G1H1(1),ngX,m3h4x1(:,386),heltab2x4(:,:,914))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,nMB,G2tensor(240),n2h1(1060))
  call Hcheck_last_SS_S(ntryL,l_switch,G0H4(60),wf4(:,3),G0tensor(1),m3h4x1(:,387),heltab2x4(:,:,915))
  call Hcheck_last_SS_S(ntryL,l_switch,G0H4(48),wf4(:,3),G0tensor(26),m3h4x1(:,388),heltab2x4(:,:,916))
  call Hcheck_last_SS_S(ntryL,l_switch,G1H4(173),wf4(:,3),G1tensor(417),m3h4x1(:,389),heltab2x4(:,:,917))
  call Hcheck_last_SS_S(ntryL,l_switch,G1H4(163),wf4(:,6),G1tensor(460),m3h4x1(:,390),heltab2x4(:,:,918))
  call Hcheck_last_SS_S(ntryL,l_switch,G0H4(62),wf4(:,3),G0tensor(51),m3h4x1(:,391),heltab2x4(:,:,919))
  call Hcheck_last_SS_S(ntryL,l_switch,G1H4(177),wf4(:,3),G1tensor(441),m3h4x1(:,392),heltab2x4(:,:,920))
  call Hcheck_last_SS_S(ntryL,l_switch,G1H4(206),wf4(:,6),G1tensor(453),m3h4x1(:,393),heltab2x4(:,:,921))
  call Hcheck_last_VS_V(ntryL,l_switch,G0H4(92),wf4(:,3),G0tensor(76),m3h4x1(:,394),heltab2x4(:,:,922))
  call Hcheck_last_VS_V(ntryL,l_switch,G1H4(247),wf4(:,3),G1tensor(471),m3h4x1(:,395),heltab2x4(:,:,923))
  call Hcheck_last_ST_V(ntryL,l_switch,G1H4(13),28,wf4(:,3),3,G2tensor(369),m3h4x1(:,396),heltab2x4(:,:,924))
  call Hcheck_last_ST_V(ntryL,l_switch,G1H4(23),28,wf4(:,3),3,G2tensor(264),m3h4x1(:,397),heltab2x4(:,:,925))
  call Hcheck_last_ST_V(ntryL,l_switch,G1H4(42),28,wf4(:,6),3,G2tensor(370),m3h4x1(:,398),heltab2x4(:,:,926))
  call Hcheck_last_TS_V(ntryL,l_switch,G1H4(31),28,wf4(:,6),3,G2tensor(371),m3h4x1(:,399),heltab2x4(:,:,927))
  call Hloop_QV_A(ntryL,G1H4(46),wf4(:,1),G1H1(1),m3h4x1(:,400),heltab2x4(:,:,928))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,nME,G2tensor(300),n2h1(1061))
  call Hloop_QV_A(ntryL,G1H4(396),wf4(:,1),G1H1(1),m3h4x1(:,401),heltab2x4(:,:,929))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,nMM,G2tensor(372),n2h1(1062))
  call Hloop_QV_A(ntryL,G1H4(399),wf4(:,1),G1H1(1),m3h4x1(:,402),heltab2x4(:,:,930))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,nML,G2tensor(373),n2h1(1063))
  call Hloop_QV_A(ntryL,G1H4(85),wf4(:,1),G1H1(1),m3h4x1(:,403),heltab2x4(:,:,931))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,nMT,G2tensor(282),n2h1(1064))
  call Hloop_QV_A(ntryL,G1H4(415),wf4(:,1),G1H1(1),m3h4x1(:,404),heltab2x4(:,:,932))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,nMB,G2tensor(1),n2h1(1065))
  call Hloop_QZ_A(ntryL,G1H4(94),wf4(:,7),G1H1(1),ngZl,m3h4x1(:,405),heltab2x4(:,:,933))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,nME,G2tensor(3),n2h1(1066))
  call Hloop_QZ_A(ntryL,G1H4(292),wf4(:,7),G1H1(1),ngZl,m3h4x1(:,406),heltab2x4(:,:,934))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,nMM,G2tensor(5),n2h1(1067))
  call Hloop_QZ_A(ntryL,G1H4(9),wf4(:,7),G1H1(1),ngZl,m3h4x1(:,407),heltab2x4(:,:,935))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,nML,G2tensor(29),n2h1(1068))
  call Hloop_QZ_A(ntryL,G1H4(348),wf4(:,7),G1H1(1),ngZu,m3h4x1(:,408),heltab2x4(:,:,936))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,nMT,G2tensor(31),n2h1(1069))
  call Hloop_QZ_A(ntryL,G1H4(20),wf4(:,7),G1H1(1),ngZd,m3h4x1(:,409),heltab2x4(:,:,937))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,nMB,G2tensor(494),n2h1(1070))
  call Hcheck_last_TV_S(ntryL,l_switch,G1H4(21),28,wf4(:,1),3,G2tensor(11),m3h4x1(:,410),heltab2x4(:,:,938))
  call Hcheck_last_TV_S(ntryL,l_switch,G1H4(140),28,wf4(:,7),3,G2tensor(485),m3h4x1(:,411),heltab2x4(:,:,939))
  call Hcheck_last_TV_S(ntryL,l_switch,G1H4(44),28,wf4(:,7),3,G2tensor(33),m3h4x1(:,412),heltab2x4(:,:,940))
  call Hcheck_last_CV_D(ntryL,l_switch,G1H4(35),28,wf4(:,1),3,G2tensor(497),m3h4x1(:,413),heltab2x4(:,:,941))
  call Hcheck_last_CV_D(ntryL,l_switch,G1H4(72),28,wf4(:,7),3,G2tensor(54),m3h4x1(:,414),heltab2x4(:,:,942))
  call Hcheck_last_UV_W(ntryL,l_switch,G1H4(345),28,wf4(:,1),3,G2tensor(39),m3h4x1(:,415),heltab2x4(:,:,943))
  call Hcheck_last_UV_W(ntryL,l_switch,G1H4(237),28,wf4(:,7),3,G2tensor(500),m3h4x1(:,416),heltab2x4(:,:,944))
  call Hcheck_last_SV_V(ntryL,l_switch,G1H4(150),wf4(:,1),G1tensor(476),m3h4x1(:,417),heltab2x4(:,:,945))
  call Hcheck_last_SV_V(ntryL,l_switch,G1H4(11),wf4(:,7),G1tensor(481),m3h4x1(:,418),heltab2x4(:,:,946))
  call Hcheck_last_SV_V(ntryL,l_switch,G1H4(112),wf4(:,7),G1tensor(486),m3h4x1(:,419),heltab2x4(:,:,947))
  call Hloop_QV_A(ntryL,G1H4(412),wf4(:,1),G1H1(1),m3h4x1(:,420),heltab2x4(:,:,948))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,0,G2tensor(19),n2h1(1071))
  call Hloop_QZ_A(ntryL,G1H4(366),wf4(:,7),G1H1(1),ngZu,m3h4x1(:,421),heltab2x4(:,:,949))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,0,G2tensor(21),n2h1(1072))
  call Hloop_QZ_A(ntryL,G1H4(4),wf4(:,7),G1H1(1),ngZd,m3h4x1(:,422),heltab2x4(:,:,950))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,0,G2tensor(23),n2h1(1073))
  call Hloop_QZ_A(ntryL,G1H4(141),wf4(:,7),G1H1(1),ngZn,m3h4x1(:,423),heltab2x4(:,:,951))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,0,G2tensor(25),n2h1(1074))
  call Hcheck_last_AQ_S(ntryL,l_switch,G1H8(52),wf8(:,138),G1tensor(491),ngH,m3h8x1(:,151),heltab2x8(:,:,1167))
  call Hcheck_last_AQ_S(ntryL,l_switch,G1H8(57),wf8(:,138),G1tensor(496),ngX,m3h8x1(:,152),heltab2x8(:,:,1168))
  call Hcheck_last_AQ_S(ntryL,l_switch,G1H8(63),wf8(:,138),G1tensor(501),ngPtb,m3h8x1(:,153),heltab2x8(:,:,1169))
  call Hcheck_last_AQ_S(ntryL,l_switch,G1H8(69),wf8(:,139),G1tensor(506),ngH,m3h8x1(:,154),heltab2x8(:,:,1170))
  call Hcheck_last_AQ_S(ntryL,l_switch,G1H8(76),wf8(:,139),G1tensor(511),ngX,m3h8x1(:,155),heltab2x8(:,:,1171))
  call Hcheck_last_AQ_S(ntryL,l_switch,G1H8(79),wf8(:,139),G1tensor(516),ngPtb,m3h8x1(:,156),heltab2x8(:,:,1172))
  call Hcheck_last_AQ_V(ntryL,l_switch,G1H8(90),wf8(:,138),G1tensor(521),m3h8x1(:,157),heltab2x8(:,:,1173))
  call Hcheck_last_AQ_Z(ntryL,l_switch,G1H8(81),wf8(:,138),G1tensor(526),ngZd,m3h8x1(:,158),heltab2x8(:,:,1174))
  call Hcheck_last_AQ_W(ntryL,l_switch,G1H8(89),wf8(:,138),G1tensor(531),m3h8x1(:,159),heltab2x8(:,:,1175))
  call Hcheck_last_AQ_V(ntryL,l_switch,G1H8(94),wf8(:,139),G1tensor(536),m3h8x1(:,160),heltab2x8(:,:,1176))
  call Hcheck_last_AQ_Z(ntryL,l_switch,G1H8(88),wf8(:,139),G1tensor(541),ngZd,m3h8x1(:,161),heltab2x8(:,:,1177))
  call Hcheck_last_AQ_W(ntryL,l_switch,G1H8(97),wf8(:,139),G1tensor(546),m3h8x1(:,162),heltab2x8(:,:,1178))
  call Hcheck_last_AQ_S(ntryL,l_switch,G1H8(106),wf8(:,140),G1tensor(551),ngH,m3h8x1(:,163),heltab2x8(:,:,1179))
  call Hcheck_last_AQ_S(ntryL,l_switch,G1H8(127),wf8(:,140),G1tensor(556),ngX,m3h8x1(:,164),heltab2x8(:,:,1180))
  call Hcheck_last_AQ_S(ntryL,l_switch,G1H8(132),wf8(:,140),G1tensor(561),ngPtb,m3h8x1(:,165),heltab2x8(:,:,1181))
  call Hcheck_last_AQ_S(ntryL,l_switch,G1H8(115),wf8(:,141),G1tensor(566),ngH,m3h8x1(:,166),heltab2x8(:,:,1182))
  call Hcheck_last_AQ_S(ntryL,l_switch,G1H8(108),wf8(:,141),G1tensor(571),ngX,m3h8x1(:,167),heltab2x8(:,:,1183))
  call Hcheck_last_AQ_S(ntryL,l_switch,G1H8(109),wf8(:,141),G1tensor(576),ngPtb,m3h8x1(:,168),heltab2x8(:,:,1184))
  call Hcheck_last_AQ_V(ntryL,l_switch,G1H8(141),wf8(:,140),G1tensor(581),m3h8x1(:,169),heltab2x8(:,:,1185))
  call Hcheck_last_AQ_Z(ntryL,l_switch,G1H8(143),wf8(:,140),G1tensor(586),ngZd,m3h8x1(:,170),heltab2x8(:,:,1186))
  call Hcheck_last_AQ_W(ntryL,l_switch,G1H8(144),wf8(:,140),G1tensor(591),m3h8x1(:,171),heltab2x8(:,:,1187))
  call Hcheck_last_AQ_V(ntryL,l_switch,G1H8(135),wf8(:,141),G1tensor(596),m3h8x1(:,172),heltab2x8(:,:,1188))
  call Hcheck_last_AQ_Z(ntryL,l_switch,G1H8(138),wf8(:,141),G1tensor(601),ngZd,m3h8x1(:,173),heltab2x8(:,:,1189))
  call Hcheck_last_AQ_W(ntryL,l_switch,G1H8(134),wf8(:,141),G1tensor(606),m3h8x1(:,174),heltab2x8(:,:,1190))
  call Hloop_QS_A(ntryL,G1H4(277),wf4(:,11),G1H1(1),ngPln,m3h4x1(:,424),heltab2x4(:,:,952))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,nME,G2tensor(27),n2h1(1075))
  call Hloop_QS_A(ntryL,G1H4(261),wf4(:,11),G1H1(1),ngPln,m3h4x1(:,425),heltab2x4(:,:,953))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,nMM,G2tensor(57),n2h1(1076))
  call Hloop_QS_A(ntryL,G1H4(115),wf4(:,11),G1H1(1),ngPln,m3h4x1(:,426),heltab2x4(:,:,954))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,nML,G2tensor(51),n2h1(1077))
  call Hloop_QS_A(ntryL,G1H4(107),wf4(:,11),G1H1(1),ngPbt,m3h4x1(:,427),heltab2x4(:,:,955))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,nMB,G2tensor(48),n2h1(1078))
  call Hcheck_last_SS_S(ntryL,l_switch,G1H4(113),wf4(:,11),G1tensor(611),m3h4x1(:,428),heltab2x4(:,:,956))
  call Hcheck_last_SS_S(ntryL,l_switch,G1H4(319),wf4(:,11),G1tensor(616),m3h4x1(:,429),heltab2x4(:,:,957))
  call Hcheck_last_SS_S(ntryL,l_switch,G1H4(315),wf4(:,11),G1tensor(621),m3h4x1(:,430),heltab2x4(:,:,958))
  call Hcheck_last_VS_V(ntryL,l_switch,G1H4(311),wf4(:,11),G1tensor(626),m3h4x1(:,431),heltab2x4(:,:,959))
  call Hcheck_last_VS_V(ntryL,l_switch,G1H4(299),wf4(:,11),G1tensor(631),m3h4x1(:,432),heltab2x4(:,:,960))
  call Hcheck_last_ST_V(ntryL,l_switch,G1H4(314),25,wf4(:,11),6,G2tensor(63),m3h4x1(:,433),heltab2x4(:,:,961))
  call Hcheck_last_ST_V(ntryL,l_switch,G1H4(313),25,wf4(:,11),6,G2tensor(503),m3h4x1(:,434),heltab2x4(:,:,962))
  call Hcheck_last_TS_V(ntryL,l_switch,G1H4(281),25,wf4(:,11),6,G2tensor(72),m3h4x1(:,435),heltab2x4(:,:,963))
  call Hcheck_last_TS_V(ntryL,l_switch,G1H4(280),25,wf4(:,11),6,G2tensor(102),m3h4x1(:,436),heltab2x4(:,:,964))
  call Hcheck_last_SS_S(ntryL,l_switch,G1H4(89),wf4(:,11),G1tensor(636),m3h4x1(:,437),heltab2x4(:,:,965))
  call Hloop_QW_A(ntryL,G1H4(283),wf4(:,13),G1H1(1),m3h4x1(:,438),heltab2x4(:,:,966))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,nME,G2tensor(512),n2h1(1079))
  call Hloop_QW_A(ntryL,G1H4(279),wf4(:,13),G1H1(1),m3h4x1(:,439),heltab2x4(:,:,967))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,nMM,G2tensor(87),n2h1(1080))
  call Hloop_QW_A(ntryL,G1H4(258),wf4(:,13),G1H1(1),m3h4x1(:,440),heltab2x4(:,:,968))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,nML,G2tensor(78),n2h1(1081))
  call Hloop_QW_A(ntryL,G1H4(395),wf4(:,13),G1H1(1),m3h4x1(:,441),heltab2x4(:,:,969))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,nMB,G2tensor(509),n2h1(1082))
  call Hcheck_last_TV_S(ntryL,l_switch,G1H4(376),25,wf4(:,13),6,G2tensor(99),m3h4x1(:,442),heltab2x4(:,:,970))
  call Hcheck_last_CV_D(ntryL,l_switch,G1H4(324),25,wf4(:,13),6,G2tensor(132),m3h4x1(:,443),heltab2x4(:,:,971))
  call Hcheck_last_DV_C(ntryL,l_switch,G1H4(202),25,wf4(:,13),G2tensor(548),m3h4x1(:,444),heltab2x4(:,:,972))
  call Hcheck_last_DV_C(ntryL,l_switch,G1H4(259),25,wf4(:,13),G2tensor(551),m3h4x1(:,445),heltab2x4(:,:,973))
  call Hcheck_last_UW_V(ntryL,l_switch,G1H4(377),25,wf4(:,13),6,G2tensor(93),m3h4x1(:,446),heltab2x4(:,:,974))
  call Hcheck_last_UW_V(ntryL,l_switch,G1H4(374),25,wf4(:,13),6,G2tensor(521),m3h4x1(:,447),heltab2x4(:,:,975))
  call Hcheck_last_SV_V(ntryL,l_switch,G1H4(114),wf4(:,13),G1tensor(641),m3h4x1(:,448),heltab2x4(:,:,976))
  call Hcheck_last_SV_V(ntryL,l_switch,G1H4(90),wf4(:,13),G1tensor(646),m3h4x1(:,449),heltab2x4(:,:,977))
  call Hcheck_last_SV_V(ntryL,l_switch,G1H4(312),wf4(:,13),G1tensor(651),m3h4x1(:,450),heltab2x4(:,:,978))
  call Hloop_QW_A(ntryL,G1H4(398),wf4(:,13),G1H1(1),m3h4x1(:,451),heltab2x4(:,:,979))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,0,G2tensor(524),n2h1(1083))
  call Hcheck_last_TV_S(ntryL,l_switch,G1H4(373),25,wf4(:,13),6,G2tensor(126),m3h4x1(:,452),heltab2x4(:,:,980))
  call Hcheck_last_CV_D(ntryL,l_switch,G1H4(327),25,wf4(:,13),6,G2tensor(554),m3h4x1(:,453),heltab2x4(:,:,981))
  call Hloop_SA_Q(ntryL,G0H8(49),wf8(:,143),G0H1(1),ngH,m3h8x1(:,175),heltab2x8(:,:,1191))
  call Hcheck_last_A_Q(ntryL,l_switch,G0H1(1),31,nMT,G1tensor(656),n2h1(1084))
  call Hloop_SA_Q(ntryL,G0H8(46),wf8(:,143),G0H1(1),ngX,m3h8x1(:,176),heltab2x8(:,:,1192))
  call Hcheck_last_A_Q(ntryL,l_switch,G0H1(1),31,nMT,G1tensor(661),n2h1(1085))
  call Hloop_SA_Q(ntryL,G0H8(47),wf8(:,143),G0H1(1),ngPtb,m3h8x1(:,177),heltab2x8(:,:,1193))
  call Hcheck_last_A_Q(ntryL,l_switch,G0H1(1),31,nMB,G1tensor(666),n2h1(1086))
  call Hloop_VA_Q(ntryL,G0H8(64),wf8(:,143),G0H1(1),m3h8x1(:,178),heltab2x8(:,:,1194))
  call Hcheck_last_A_Q(ntryL,l_switch,G0H1(1),31,nMT,G1tensor(671),n2h1(1087))
  call Hloop_ZA_Q(ntryL,G0H8(54),wf8(:,143),G0H1(1),ngZu,m3h8x1(:,179),heltab2x8(:,:,1195))
  call Hcheck_last_A_Q(ntryL,l_switch,G0H1(1),31,nMT,G1tensor(676),n2h1(1088))
  call Hloop_WA_Q(ntryL,G0H8(63),wf8(:,143),G0H1(1),m3h8x1(:,180),heltab2x8(:,:,1196))
  call Hcheck_last_A_Q(ntryL,l_switch,G0H1(1),31,nMB,G1tensor(681),n2h1(1089))
  call Hloop_SA_Q(ntryL,G0H8(69),wf8(:,145),G0H1(1),ngH,m3h8x1(:,181),heltab2x8(:,:,1197))
  call Hcheck_last_A_Q(ntryL,l_switch,G0H1(1),31,nMT,G1tensor(686),n2h1(1090))
  call Hloop_SA_Q(ntryL,G0H8(70),wf8(:,145),G0H1(1),ngX,m3h8x1(:,182),heltab2x8(:,:,1198))
  call Hcheck_last_A_Q(ntryL,l_switch,G0H1(1),31,nMT,G1tensor(691),n2h1(1091))
  call Hloop_SA_Q(ntryL,G0H8(86),wf8(:,145),G0H1(1),ngPtb,m3h8x1(:,183),heltab2x8(:,:,1199))
  call Hcheck_last_A_Q(ntryL,l_switch,G0H1(1),31,nMB,G1tensor(696),n2h1(1092))
  call Hloop_VA_Q(ntryL,G0H8(95),wf8(:,145),G0H1(1),m3h8x1(:,184),heltab2x8(:,:,1200))
  call Hcheck_last_A_Q(ntryL,l_switch,G0H1(1),31,nMT,G1tensor(701),n2h1(1093))
  call Hloop_ZA_Q(ntryL,G0H8(88),wf8(:,145),G0H1(1),ngZu,m3h8x1(:,185),heltab2x8(:,:,1201))
  call Hcheck_last_A_Q(ntryL,l_switch,G0H1(1),31,nMT,G1tensor(706),n2h1(1094))
  call Hloop_WA_Q(ntryL,G0H8(89),wf8(:,145),G0H1(1),m3h8x1(:,186),heltab2x8(:,:,1202))
  call Hcheck_last_A_Q(ntryL,l_switch,G0H1(1),31,nMB,G1tensor(711),n2h1(1095))
  call Hcheck_last_AQ_S(ntryL,l_switch,G1H8(147),wf8(:,148),G1tensor(716),ngH,m3h8x1(:,187),heltab2x8(:,:,1203))
  call Hcheck_last_AQ_S(ntryL,l_switch,G1H8(145),wf8(:,148),G1tensor(721),ngX,m3h8x1(:,188),heltab2x8(:,:,1204))
  call Hcheck_last_AQ_S(ntryL,l_switch,G1H8(146),wf8(:,148),G1tensor(726),ngPtb,m3h8x1(:,189),heltab2x8(:,:,1205))
  call Hcheck_last_AQ_V(ntryL,l_switch,G1H8(151),wf8(:,148),G1tensor(731),m3h8x1(:,190),heltab2x8(:,:,1206))
  call Hcheck_last_AQ_Z(ntryL,l_switch,G1H8(156),wf8(:,148),G1tensor(736),ngZd,m3h8x1(:,191),heltab2x8(:,:,1207))
  call Hcheck_last_AQ_W(ntryL,l_switch,G1H8(157),wf8(:,148),G1tensor(741),m3h8x1(:,192),heltab2x8(:,:,1208))
  call Hcheck_last_AQ_S(ntryL,l_switch,G1H8(152),wf8(:,149),G1tensor(746),ngH,m3h8x1(:,193),heltab2x8(:,:,1209))
  call Hcheck_last_AQ_S(ntryL,l_switch,G1H8(158),wf8(:,149),G1tensor(751),ngX,m3h8x1(:,194),heltab2x8(:,:,1210))
  call Hcheck_last_AQ_S(ntryL,l_switch,G1H8(173),wf8(:,149),G1tensor(756),ngPtb,m3h8x1(:,195),heltab2x8(:,:,1211))
  call Hcheck_last_AQ_V(ntryL,l_switch,G1H8(166),wf8(:,149),G1tensor(761),m3h8x1(:,196),heltab2x8(:,:,1212))
  call Hcheck_last_AQ_Z(ntryL,l_switch,G1H8(171),wf8(:,149),G1tensor(766),ngZd,m3h8x1(:,197),heltab2x8(:,:,1213))
  call Hcheck_last_AQ_W(ntryL,l_switch,G1H8(168),wf8(:,149),G1tensor(771),m3h8x1(:,198),heltab2x8(:,:,1214))
  call Hloop_AS_Q(ntryL,G1H4(408),wf4(:,11),G1H1(1),ngPln,m3h4x1(:,454),heltab2x4(:,:,982))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,0,G2tensor(114),n2h1(1096))
  call Hloop_AS_Q(ntryL,G1H4(386),wf4(:,11),G1H1(1),ngPln,m3h4x1(:,455),heltab2x4(:,:,983))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,0,G2tensor(542),n2h1(1097))
  call Hloop_AS_Q(ntryL,G1H4(383),wf4(:,11),G1H1(1),ngPln,m3h4x1(:,456),heltab2x4(:,:,984))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,0,G2tensor(545),n2h1(1098))
  call Hloop_AS_Q(ntryL,G1H4(382),wf4(:,11),G1H1(1),ngPbt,m3h4x1(:,457),heltab2x4(:,:,985))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,nMT,G2tensor(129),n2h1(1099))
  call Hcheck_last_SS_S(ntryL,l_switch,G1H4(379),wf4(:,11),G1tensor(776),m3h4x1(:,458),heltab2x4(:,:,986))
  call Hcheck_last_SS_S(ntryL,l_switch,G1H4(341),wf4(:,11),G1tensor(781),m3h4x1(:,459),heltab2x4(:,:,987))
  call Hcheck_last_SS_S(ntryL,l_switch,G1H4(338),wf4(:,11),G1tensor(786),m3h4x1(:,460),heltab2x4(:,:,988))
  call Hcheck_last_VS_V(ntryL,l_switch,G1H4(337),wf4(:,11),G1tensor(791),m3h4x1(:,461),heltab2x4(:,:,989))
  call Hcheck_last_VS_V(ntryL,l_switch,G1H4(231),wf4(:,11),G1tensor(796),m3h4x1(:,462),heltab2x4(:,:,990))
  call Hcheck_last_VT_S(ntryL,l_switch,G1H4(203),25,wf4(:,11),6,G2tensor(536),m3h4x1(:,463),heltab2x4(:,:,991))
  call Hcheck_last_VT_S(ntryL,l_switch,G1H4(263),25,wf4(:,11),6,G2tensor(539),m3h4x1(:,464),heltab2x4(:,:,992))
  call Hcheck_last_VS_T(ntryL,l_switch,G1H4(400),25,wf4(:,11),6,G2tensor(560),m3h4x1(:,465),heltab2x4(:,:,993))
  call Hcheck_last_VS_T(ntryL,l_switch,G1H4(397),25,wf4(:,11),6,G2tensor(153),m3h4x1(:,466),heltab2x4(:,:,994))
  call Hloop_AW_Q(ntryL,G1H4(230),wf4(:,13),G1H1(1),m3h4x1(:,467),heltab2x4(:,:,995))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,0,G2tensor(596),n2h1(1100))
  call Hloop_AW_Q(ntryL,G1H4(413),wf4(:,13),G1H1(1),m3h4x1(:,468),heltab2x4(:,:,996))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,0,G2tensor(599),n2h1(1101))
  call Hloop_AW_Q(ntryL,G1H4(409),wf4(:,13),G1H1(1),m3h4x1(:,469),heltab2x4(:,:,997))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,0,G2tensor(138),n2h1(1102))
  call Hloop_AW_Q(ntryL,G1H4(380),wf4(:,13),G1H1(1),m3h4x1(:,470),heltab2x4(:,:,998))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,nMT,G2tensor(569),n2h1(1103))
  call Hcheck_last_SV_T(ntryL,l_switch,G1H4(343),25,wf4(:,13),6,G2tensor(572),m3h4x1(:,471),heltab2x4(:,:,999))
  call Hcheck_last_DV_C(ntryL,l_switch,G1H4(222),25,wf4(:,13),G2tensor(168),m3h4x1(:,472),heltab2x4(:,:,1000))
  call Hcheck_last_CV_D(ntryL,l_switch,G1H4(216),25,wf4(:,13),6,G2tensor(602),m3h4x1(:,473),heltab2x4(:,:,1001))
  call Hcheck_last_CV_D(ntryL,l_switch,G1H4(271),25,wf4(:,13),6,G2tensor(156),m3h4x1(:,474),heltab2x4(:,:,1002))
  call Hcheck_last_UV_W(ntryL,l_switch,G1H4(414),25,wf4(:,13),6,G2tensor(590),m3h4x1(:,475),heltab2x4(:,:,1003))
  call Hcheck_last_UV_W(ntryL,l_switch,G1H4(410),25,wf4(:,13),6,G2tensor(593),m3h4x1(:,476),heltab2x4(:,:,1004))
  call Hcheck_last_VV_S(ntryL,l_switch,G1H4(204),wf4(:,13),G1tensor(801),m3h4x1(:,477),heltab2x4(:,:,1005))
  call Hcheck_last_VV_S(ntryL,l_switch,G1H4(269),wf4(:,13),G1tensor(806),m3h4x1(:,478),heltab2x4(:,:,1006))
  call Hcheck_last_VV_S(ntryL,l_switch,G1H4(411),wf4(:,13),G1tensor(811),m3h4x1(:,479),heltab2x4(:,:,1007))
  call Hcheck_last_SS_S(ntryL,l_switch,G1H4(342),wf4(:,11),G1tensor(816),m3h4x1(:,480),heltab2x4(:,:,1008))
  call Hloop_AW_Q(ntryL,G1H4(384),wf4(:,13),G1H1(1),m3h4x1(:,481),heltab2x4(:,:,1009))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,0,G2tensor(162),n2h1(1104))
  call Hcheck_last_SV_T(ntryL,l_switch,G1H4(339),25,wf4(:,13),6,G2tensor(584),m3h4x1(:,482),heltab2x4(:,:,1010))
  call Hcheck_last_DV_C(ntryL,l_switch,G1H4(335),25,wf4(:,13),G2tensor(587),m3h4x1(:,483),heltab2x4(:,:,1011))
  call Hloop_SQ_A(ntryL,G0H8(118),wf8(:,152),G0H1(1),ngH,m3h8x1(:,199),heltab2x8(:,:,1215))
  call Hcheck_last_Q_A(ntryL,l_switch,G0H1(1),31,nMT,G1tensor(821),n2h1(1105))
  call Hloop_SQ_A(ntryL,G0H8(119),wf8(:,152),G0H1(1),ngX,m3h8x1(:,200),heltab2x8(:,:,1216))
  call Hcheck_last_Q_A(ntryL,l_switch,G0H1(1),31,nMT,G1tensor(826),n2h1(1106))
  call Hloop_SQ_A(ntryL,G0H8(120),wf8(:,152),G0H1(1),ngPbt,m3h8x1(:,201),heltab2x8(:,:,1217))
  call Hcheck_last_Q_A(ntryL,l_switch,G0H1(1),31,nMB,G1tensor(831),n2h1(1107))
  call Hloop_VQ_A(ntryL,G0H8(132),wf8(:,152),G0H1(1),m3h8x1(:,202),heltab2x8(:,:,1218))
  call Hcheck_last_Q_A(ntryL,l_switch,G0H1(1),31,nMT,G1tensor(836),n2h1(1108))
  call Hloop_ZQ_A(ntryL,G0H8(125),wf8(:,152),G0H1(1),ngZu,m3h8x1(:,203),heltab2x8(:,:,1219))
  call Hcheck_last_Q_A(ntryL,l_switch,G0H1(1),31,nMT,G1tensor(841),n2h1(1109))
  call Hloop_WQ_A(ntryL,G0H8(131),wf8(:,152),G0H1(1),m3h8x1(:,204),heltab2x8(:,:,1220))
  call Hcheck_last_Q_A(ntryL,l_switch,G0H1(1),31,nMB,G1tensor(846),n2h1(1110))
  call Hloop_SQ_A(ntryL,G0H8(134),wf8(:,153),G0H1(1),ngH,m3h8x1(:,205),heltab2x8(:,:,1221))
  call Hcheck_last_Q_A(ntryL,l_switch,G0H1(1),31,nMT,G1tensor(851),n2h1(1111))
  call Hloop_SQ_A(ntryL,G0H8(135),wf8(:,153),G0H1(1),ngX,m3h8x1(:,206),heltab2x8(:,:,1222))
  call Hcheck_last_Q_A(ntryL,l_switch,G0H1(1),31,nMT,G1tensor(856),n2h1(1112))
  call Hloop_SQ_A(ntryL,G0H8(136),wf8(:,153),G0H1(1),ngPbt,m3h8x1(:,207),heltab2x8(:,:,1223))
  call Hcheck_last_Q_A(ntryL,l_switch,G0H1(1),31,nMB,G1tensor(861),n2h1(1113))
  call Hloop_VQ_A(ntryL,G0H8(140),wf8(:,153),G0H1(1),m3h8x1(:,208),heltab2x8(:,:,1224))
  call Hcheck_last_Q_A(ntryL,l_switch,G0H1(1),31,nMT,G1tensor(866),n2h1(1114))
  call Hloop_ZQ_A(ntryL,G0H8(143),wf8(:,153),G0H1(1),ngZu,m3h8x1(:,209),heltab2x8(:,:,1225))
  call Hcheck_last_Q_A(ntryL,l_switch,G0H1(1),31,nMT,G1tensor(871),n2h1(1115))
  call Hloop_WQ_A(ntryL,G0H8(144),wf8(:,153),G0H1(1),m3h8x1(:,210),heltab2x8(:,:,1226))
  call Hcheck_last_Q_A(ntryL,l_switch,G0H1(1),31,nMB,G1tensor(876),n2h1(1116))
  call Hloop_AS_Q(ntryL,G1H4(73),wf4(:,14),G1H1(1),ngPnl,m3h4x1(:,484),heltab2x4(:,:,1012))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,nME,G2tensor(174),n2h1(1117))
  call Hloop_AS_Q(ntryL,G1H4(80),wf4(:,14),G1H1(1),ngPnl,m3h4x1(:,485),heltab2x4(:,:,1013))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,nMM,G2tensor(608),n2h1(1118))
  call Hloop_AS_Q(ntryL,G1H4(55),wf4(:,14),G1H1(1),ngPnl,m3h4x1(:,486),heltab2x4(:,:,1014))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,nML,G2tensor(237),n2h1(1119))
  call Hloop_AS_Q(ntryL,G1H4(56),wf4(:,14),G1H1(1),ngPtb,m3h4x1(:,487),heltab2x4(:,:,1015))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,nMB,G2tensor(255),n2h1(1120))
  call Hcheck_last_SS_S(ntryL,l_switch,G1H4(404),wf4(:,14),G1tensor(881),m3h4x1(:,488),heltab2x4(:,:,1016))
  call Hcheck_last_SS_S(ntryL,l_switch,G1H4(333),wf4(:,14),G1tensor(886),m3h4x1(:,489),heltab2x4(:,:,1017))
  call Hcheck_last_SS_S(ntryL,l_switch,G1H4(331),wf4(:,14),G1tensor(891),m3h4x1(:,490),heltab2x4(:,:,1018))
  call Hcheck_last_VS_V(ntryL,l_switch,G1H4(332),wf4(:,14),G1tensor(896),m3h4x1(:,491),heltab2x4(:,:,1019))
  call Hcheck_last_VS_V(ntryL,l_switch,G1H4(227),wf4(:,14),G1tensor(901),m3h4x1(:,492),heltab2x4(:,:,1020))
  call Hcheck_last_TS_V(ntryL,l_switch,G1H4(18),22,wf4(:,14),9,G2tensor(198),m3h4x1(:,493),heltab2x4(:,:,1021))
  call Hcheck_last_TS_V(ntryL,l_switch,G1H4(19),22,wf4(:,14),9,G2tensor(186),m3h4x1(:,494),heltab2x4(:,:,1022))
  call Hcheck_last_TS_V(ntryL,l_switch,G1H4(26),22,wf4(:,14),9,G2tensor(258),m3h4x1(:,495),heltab2x4(:,:,1023))
  call Hcheck_last_TS_V(ntryL,l_switch,G1H4(29),22,wf4(:,14),9,G2tensor(231),m3h4x1(:,496),heltab2x4(:,:,1024))
  call Hcheck_last_SS_S(ntryL,l_switch,G1H4(330),wf4(:,14),G1tensor(906),m3h4x1(:,497),heltab2x4(:,:,1025))
  call Hloop_AW_Q(ntryL,G1H4(274),wf4(:,17),G1H1(1),m3h4x1(:,498),heltab2x4(:,:,1026))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,nME,G2tensor(252),n2h1(1121))
  call Hloop_AW_Q(ntryL,G1H4(268),wf4(:,17),G1H1(1),m3h4x1(:,499),heltab2x4(:,:,1027))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,nMM,G2tensor(246),n2h1(1122))
  call Hloop_AW_Q(ntryL,G1H4(253),wf4(:,17),G1H1(1),m3h4x1(:,500),heltab2x4(:,:,1028))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,nML,G2tensor(213),n2h1(1123))
  call Hloop_AW_Q(ntryL,G1H4(226),wf4(:,17),G1H1(1),m3h4x1(:,501),heltab2x4(:,:,1029))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,nMB,G2tensor(228),n2h1(1124))
  call Hcheck_last_TV_S(ntryL,l_switch,G1H4(421),22,wf4(:,17),9,G2tensor(279),m3h4x1(:,502),heltab2x4(:,:,1030))
  call Hcheck_last_DV_C(ntryL,l_switch,G1H4(423),22,wf4(:,17),G2tensor(261),m3h4x1(:,503),heltab2x4(:,:,1031))
  call Hcheck_last_DV_C(ntryL,l_switch,G1H4(424),22,wf4(:,17),G2tensor(294),m3h4x1(:,504),heltab2x4(:,:,1032))
  call Hcheck_last_CV_D(ntryL,l_switch,G1H4(426),22,wf4(:,17),9,G2tensor(291),m3h4x1(:,505),heltab2x4(:,:,1033))
  call Hcheck_last_UV_W(ntryL,l_switch,G1H4(427),22,wf4(:,17),9,G2tensor(273),m3h4x1(:,506),heltab2x4(:,:,1034))
  call Hcheck_last_UV_W(ntryL,l_switch,G1H4(428),22,wf4(:,17),9,G2tensor(288),m3h4x1(:,507),heltab2x4(:,:,1035))
  call Hcheck_last_SV_V(ntryL,l_switch,G1H4(303),wf4(:,17),G1tensor(911),m3h4x1(:,508),heltab2x4(:,:,1036))
  call Hcheck_last_SV_V(ntryL,l_switch,G1H4(298),wf4(:,17),G1tensor(916),m3h4x1(:,509),heltab2x4(:,:,1037))
  call Hcheck_last_SV_V(ntryL,l_switch,G1H4(295),wf4(:,17),G1tensor(921),m3h4x1(:,510),heltab2x4(:,:,1038))
  call Hloop_AW_Q(ntryL,G1H4(242),wf4(:,17),G1H1(1),m3h4x1(:,511),heltab2x4(:,:,1039))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,0,G2tensor(297),n2h1(1125))
  call Hcheck_last_TV_S(ntryL,l_switch,G1H4(422),22,wf4(:,17),9,G2tensor(306),m3h4x1(:,512),heltab2x4(:,:,1040))
  call Hcheck_last_CV_D(ntryL,l_switch,G1H4(425),22,wf4(:,17),9,G2tensor(303),m3h4x1(:,513),heltab2x4(:,:,1041))
  call Hcheck_last_QA_S(ntryL,l_switch,G1H8(167),wf8(:,156),G1tensor(926),ngH,m3h8x1(:,211),heltab2x8(:,:,1227))
  call Hcheck_last_QA_S(ntryL,l_switch,G1H8(288),wf8(:,156),G1tensor(931),ngX,m3h8x1(:,212),heltab2x8(:,:,1228))
  call Hcheck_last_QA_S(ntryL,l_switch,G1H8(289),wf8(:,156),G1tensor(936),ngPbt,m3h8x1(:,213),heltab2x8(:,:,1229))
  call Hcheck_last_QA_V(ntryL,l_switch,G1H8(178),wf8(:,156),G1tensor(941),m3h8x1(:,214),heltab2x8(:,:,1230))
  call Hcheck_last_QA_Z(ntryL,l_switch,G1H8(303),wf8(:,156),G1tensor(946),ngZd,m3h8x1(:,215),heltab2x8(:,:,1231))
  call Hcheck_last_QA_W(ntryL,l_switch,G1H8(172),wf8(:,156),G1tensor(951),m3h8x1(:,216),heltab2x8(:,:,1232))
  call Hcheck_last_QA_S(ntryL,l_switch,G1H8(176),wf8(:,157),G1tensor(956),ngH,m3h8x1(:,217),heltab2x8(:,:,1233))
  call Hcheck_last_QA_S(ntryL,l_switch,G1H8(184),wf8(:,157),G1tensor(961),ngX,m3h8x1(:,218),heltab2x8(:,:,1234))
  call Hcheck_last_QA_S(ntryL,l_switch,G1H8(183),wf8(:,157),G1tensor(966),ngPbt,m3h8x1(:,219),heltab2x8(:,:,1235))
  call Hcheck_last_QA_V(ntryL,l_switch,G1H8(11),wf8(:,157),G1tensor(971),m3h8x1(:,220),heltab2x8(:,:,1236))
  call Hcheck_last_QA_Z(ntryL,l_switch,G1H8(5),wf8(:,157),G1tensor(976),ngZd,m3h8x1(:,221),heltab2x8(:,:,1237))
  call Hcheck_last_QA_W(ntryL,l_switch,G1H8(10),wf8(:,157),G1tensor(981),m3h8x1(:,222),heltab2x8(:,:,1238))
  call Hloop_QS_A(ntryL,G1H4(636),wf4(:,18),G1H1(1),ngH,m3h4x1(:,514),heltab2x4(:,:,1042))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,nME,G2tensor(320),n2h1(1126))
  call Hloop_QS_A(ntryL,G1H4(637),wf4(:,18),G1H1(1),ngH,m3h4x1(:,515),heltab2x4(:,:,1043))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,nMM,G2tensor(321),n2h1(1127))
  call Hloop_QS_A(ntryL,G1H4(638),wf4(:,18),G1H1(1),ngH,m3h4x1(:,516),heltab2x4(:,:,1044))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,nML,G2tensor(623),n2h1(1128))
  call Hloop_QS_A(ntryL,G1H4(639),wf4(:,18),G1H1(1),ngH,m3h4x1(:,517),heltab2x4(:,:,1045))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,nMT,G2tensor(311),n2h1(1129))
  call Hloop_QS_A(ntryL,G1H4(640),wf4(:,18),G1H1(1),ngH,m3h4x1(:,518),heltab2x4(:,:,1046))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,nMB,G2tensor(614),n2h1(1130))
  call Hloop_QS_A(ntryL,G1H4(641),wf4(:,19),G1H1(1),ngX,m3h4x1(:,519),heltab2x4(:,:,1047))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,nME,G2tensor(322),n2h1(1131))
  call Hloop_QS_A(ntryL,G1H4(642),wf4(:,19),G1H1(1),ngX,m3h4x1(:,520),heltab2x4(:,:,1048))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,nMM,G2tensor(626),n2h1(1132))
  call Hloop_QS_A(ntryL,G1H4(643),wf4(:,19),G1H1(1),ngX,m3h4x1(:,521),heltab2x4(:,:,1049))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,nML,G2tensor(323),n2h1(1133))
  call Hloop_QS_A(ntryL,G1H4(644),wf4(:,19),G1H1(1),ngX,m3h4x1(:,522),heltab2x4(:,:,1050))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,nMT,G2tensor(324),n2h1(1134))
  call Hloop_QS_A(ntryL,G1H4(645),wf4(:,19),G1H1(1),ngX,m3h4x1(:,523),heltab2x4(:,:,1051))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,nMB,G2tensor(629),n2h1(1135))
  call Hcheck_last_SS_S(ntryL,l_switch,G0H4(207),wf4(:,18),G0tensor(111),m3h4x1(:,524),heltab2x4(:,:,1052))
  call Hcheck_last_SS_S(ntryL,l_switch,G0H4(208),wf4(:,18),G0tensor(141),m3h4x1(:,525),heltab2x4(:,:,1053))
  call Hcheck_last_SS_S(ntryL,l_switch,G1H4(647),wf4(:,18),G1tensor(986),m3h4x1(:,526),heltab2x4(:,:,1054))
  call Hcheck_last_SS_S(ntryL,l_switch,G1H4(648),wf4(:,19),G1tensor(991),m3h4x1(:,527),heltab2x4(:,:,1055))
  call Hcheck_last_SS_S(ntryL,l_switch,G0H4(211),wf4(:,18),G0tensor(176),m3h4x1(:,528),heltab2x4(:,:,1056))
  call Hcheck_last_SS_S(ntryL,l_switch,G1H4(654),wf4(:,18),G1tensor(996),m3h4x1(:,529),heltab2x4(:,:,1057))
  call Hcheck_last_SS_S(ntryL,l_switch,G1H4(656),wf4(:,19),G1tensor(1001),m3h4x1(:,530),heltab2x4(:,:,1058))
  call Hcheck_last_VS_V(ntryL,l_switch,G0H4(220),wf4(:,18),G0tensor(206),m3h4x1(:,531),heltab2x4(:,:,1059))
  call Hcheck_last_VS_V(ntryL,l_switch,G1H4(658),wf4(:,18),G1tensor(1006),m3h4x1(:,532),heltab2x4(:,:,1060))
  call Hcheck_last_VT_S(ntryL,l_switch,G1H4(587),19,wf4(:,18),12,G2tensor(315),m3h4x1(:,533),heltab2x4(:,:,1061))
  call Hcheck_last_VT_S(ntryL,l_switch,G1H4(593),19,wf4(:,18),12,G2tensor(316),m3h4x1(:,534),heltab2x4(:,:,1062))
  call Hcheck_last_VT_S(ntryL,l_switch,G1H4(596),19,wf4(:,19),12,G2tensor(317),m3h4x1(:,535),heltab2x4(:,:,1063))
  call Hcheck_last_VS_T(ntryL,l_switch,G1H4(594),19,wf4(:,19),12,G2tensor(318),m3h4x1(:,536),heltab2x4(:,:,1064))
  call Hloop_QV_A(ntryL,G1H4(673),wf4(:,2),G1H1(1),m3h4x1(:,537),heltab2x4(:,:,1065))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,nME,G2tensor(319),n2h1(1136))
  call Hloop_QV_A(ntryL,G1H4(674),wf4(:,2),G1H1(1),m3h4x1(:,538),heltab2x4(:,:,1066))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,nMM,G2tensor(325),n2h1(1137))
  call Hloop_QV_A(ntryL,G1H4(675),wf4(:,2),G1H1(1),m3h4x1(:,539),heltab2x4(:,:,1067))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,nML,G2tensor(326),n2h1(1138))
  call Hloop_QV_A(ntryL,G1H4(677),wf4(:,2),G1H1(1),m3h4x1(:,540),heltab2x4(:,:,1068))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,nMT,G2tensor(331),n2h1(1139))
  call Hloop_QV_A(ntryL,G1H4(679),wf4(:,2),G1H1(1),m3h4x1(:,541),heltab2x4(:,:,1069))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,nMB,G2tensor(332),n2h1(1140))
  call Hloop_QZ_A(ntryL,G1H4(681),wf4(:,20),G1H1(1),ngZl,m3h4x1(:,542),heltab2x4(:,:,1070))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,nME,G2tensor(329),n2h1(1141))
  call Hloop_QZ_A(ntryL,G1H4(682),wf4(:,20),G1H1(1),ngZl,m3h4x1(:,543),heltab2x4(:,:,1071))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,nMM,G2tensor(330),n2h1(1142))
  call Hloop_QZ_A(ntryL,G1H4(683),wf4(:,20),G1H1(1),ngZl,m3h4x1(:,544),heltab2x4(:,:,1072))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,nML,G2tensor(333),n2h1(1143))
  call Hloop_QZ_A(ntryL,G1H4(685),wf4(:,20),G1H1(1),ngZu,m3h4x1(:,545),heltab2x4(:,:,1073))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,nMT,G2tensor(334),n2h1(1144))
  call Hloop_QZ_A(ntryL,G1H4(687),wf4(:,20),G1H1(1),ngZd,m3h4x1(:,546),heltab2x4(:,:,1074))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,nMB,G2tensor(342),n2h1(1145))
  call Hcheck_last_TV_S(ntryL,l_switch,G1H4(690),19,wf4(:,2),12,G2tensor(343),m3h4x1(:,547),heltab2x4(:,:,1075))
  call Hcheck_last_TV_S(ntryL,l_switch,G1H4(692),19,wf4(:,20),12,G2tensor(337),m3h4x1(:,548),heltab2x4(:,:,1076))
  call Hcheck_last_SV_T(ntryL,l_switch,G1H4(691),19,wf4(:,20),12,G2tensor(344),m3h4x1(:,549),heltab2x4(:,:,1077))
  call Hcheck_last_CV_D(ntryL,l_switch,G1H4(698),19,wf4(:,2),12,G2tensor(339),m3h4x1(:,550),heltab2x4(:,:,1078))
  call Hcheck_last_CV_D(ntryL,l_switch,G1H4(700),19,wf4(:,20),12,G2tensor(340),m3h4x1(:,551),heltab2x4(:,:,1079))
  call Hcheck_last_UV_W(ntryL,l_switch,G1H4(703),19,wf4(:,2),12,G2tensor(341),m3h4x1(:,552),heltab2x4(:,:,1080))
  call Hcheck_last_UV_W(ntryL,l_switch,G1H4(704),19,wf4(:,20),12,G2tensor(345),m3h4x1(:,553),heltab2x4(:,:,1081))
  call Hcheck_last_VV_S(ntryL,l_switch,G1H4(622),wf4(:,2),G1tensor(1011),m3h4x1(:,554),heltab2x4(:,:,1082))
  call Hcheck_last_VV_S(ntryL,l_switch,G1H4(625),wf4(:,20),G1tensor(1016),m3h4x1(:,555),heltab2x4(:,:,1083))
  call Hcheck_last_VV_S(ntryL,l_switch,G1H4(623),wf4(:,20),G1tensor(1021),m3h4x1(:,556),heltab2x4(:,:,1084))
  call Hloop_QV_A(ntryL,G1H4(678),wf4(:,2),G1H1(1),m3h4x1(:,557),heltab2x4(:,:,1085))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,0,G2tensor(348),n2h1(1146))
  call Hloop_QZ_A(ntryL,G1H4(684),wf4(:,20),G1H1(1),ngZu,m3h4x1(:,558),heltab2x4(:,:,1086))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,0,G2tensor(347),n2h1(1147))
  call Hloop_QZ_A(ntryL,G1H4(686),wf4(:,20),G1H1(1),ngZd,m3h4x1(:,559),heltab2x4(:,:,1087))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,0,G2tensor(374),n2h1(1148))
  call Hloop_QZ_A(ntryL,G1H4(680),wf4(:,20),G1H1(1),ngZn,m3h4x1(:,560),heltab2x4(:,:,1088))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,0,G2tensor(378),n2h1(1149))
  call Hloop_SA_Q(ntryL,G0H8(138),wf8(:,159),G0H1(1),ngH,m3h8x1(:,223),heltab2x8(:,:,1239))
  call Hcheck_last_A_Q(ntryL,l_switch,G0H1(1),31,nMT,G1tensor(1026),n2h1(1150))
  call Hloop_SA_Q(ntryL,G0H8(3),wf8(:,159),G0H1(1),ngX,m3h8x1(:,224),heltab2x8(:,:,1240))
  call Hcheck_last_A_Q(ntryL,l_switch,G0H1(1),31,nMT,G1tensor(1031),n2h1(1151))
  call Hloop_SA_Q(ntryL,G0H8(4),wf8(:,159),G0H1(1),ngPtb,m3h8x1(:,225),heltab2x8(:,:,1241))
  call Hcheck_last_A_Q(ntryL,l_switch,G0H1(1),31,nMB,G1tensor(1036),n2h1(1152))
  call Hloop_SA_Q(ntryL,G0H8(28),wf8(:,161),G0H1(1),ngH,m3h8x1(:,226),heltab2x8(:,:,1242))
  call Hcheck_last_A_Q(ntryL,l_switch,G0H1(1),31,nMT,G1tensor(1041),n2h1(1153))
  call Hloop_SA_Q(ntryL,G0H8(22),wf8(:,161),G0H1(1),ngX,m3h8x1(:,227),heltab2x8(:,:,1243))
  call Hcheck_last_A_Q(ntryL,l_switch,G0H1(1),31,nMT,G1tensor(1046),n2h1(1154))
  call Hloop_SA_Q(ntryL,G0H8(59),wf8(:,161),G0H1(1),ngPtb,m3h8x1(:,228),heltab2x8(:,:,1244))
  call Hcheck_last_A_Q(ntryL,l_switch,G0H1(1),31,nMB,G1tensor(1051),n2h1(1155))
  call Hloop_VA_Q(ntryL,G0H8(100),wf8(:,159),G0H1(1),m3h8x1(:,229),heltab2x8(:,:,1245))
  call Hcheck_last_A_Q(ntryL,l_switch,G0H1(1),31,nMT,G1tensor(1056),n2h1(1156))
  call Hloop_ZA_Q(ntryL,G0H8(67),wf8(:,159),G0H1(1),ngZu,m3h8x1(:,230),heltab2x8(:,:,1246))
  call Hcheck_last_A_Q(ntryL,l_switch,G0H1(1),31,nMT,G1tensor(1061),n2h1(1157))
  call Hloop_WA_Q(ntryL,G0H8(62),wf8(:,159),G0H1(1),m3h8x1(:,231),heltab2x8(:,:,1247))
  call Hcheck_last_A_Q(ntryL,l_switch,G0H1(1),31,nMB,G1tensor(1066),n2h1(1158))
  call Hloop_VA_Q(ntryL,G0H8(168),wf8(:,161),G0H1(1),m3h8x1(:,232),heltab2x8(:,:,1248))
  call Hcheck_last_A_Q(ntryL,l_switch,G0H1(1),31,nMT,G1tensor(1071),n2h1(1159))
  call Hloop_ZA_Q(ntryL,G0H8(148),wf8(:,161),G0H1(1),ngZu,m3h8x1(:,233),heltab2x8(:,:,1249))
  call Hcheck_last_A_Q(ntryL,l_switch,G0H1(1),31,nMT,G1tensor(1076),n2h1(1160))
  call Hloop_WA_Q(ntryL,G0H8(133),wf8(:,161),G0H1(1),m3h8x1(:,234),heltab2x8(:,:,1250))
  call Hcheck_last_A_Q(ntryL,l_switch,G0H1(1),31,nMB,G1tensor(1081),n2h1(1161))
  call Hloop_SA_Q(ntryL,G0H8(65),wf8(:,163),G0H1(1),ngH,m3h8x1(:,235),heltab2x8(:,:,1251))
  call Hcheck_last_A_Q(ntryL,l_switch,G0H1(1),31,nMT,G1tensor(1086),n2h1(1162))
  call Hloop_SA_Q(ntryL,G0H8(66),wf8(:,163),G0H1(1),ngX,m3h8x1(:,236),heltab2x8(:,:,1252))
  call Hcheck_last_A_Q(ntryL,l_switch,G0H1(1),31,nMT,G1tensor(1091),n2h1(1163))
  call Hloop_SA_Q(ntryL,G0H8(127),wf8(:,163),G0H1(1),ngPtb,m3h8x1(:,237),heltab2x8(:,:,1253))
  call Hcheck_last_A_Q(ntryL,l_switch,G0H1(1),31,nMB,G1tensor(1096),n2h1(1164))
  call Hloop_SA_Q(ntryL,G0H8(184),wf8(:,165),G0H1(1),ngH,m3h8x1(:,238),heltab2x8(:,:,1254))
  call Hcheck_last_A_Q(ntryL,l_switch,G0H1(1),31,nMT,G1tensor(1101),n2h1(1165))
  call Hloop_SA_Q(ntryL,G0H8(183),wf8(:,165),G0H1(1),ngX,m3h8x1(:,239),heltab2x8(:,:,1255))
  call Hcheck_last_A_Q(ntryL,l_switch,G0H1(1),31,nMT,G1tensor(1106),n2h1(1166))
  call Hloop_SA_Q(ntryL,G0H8(71),wf8(:,165),G0H1(1),ngPtb,m3h8x1(:,240),heltab2x8(:,:,1256))
  call Hcheck_last_A_Q(ntryL,l_switch,G0H1(1),31,nMB,G1tensor(1111),n2h1(1167))
  call Hloop_VA_Q(ntryL,G0H8(73),wf8(:,163),G0H1(1),m3h8x1(:,241),heltab2x8(:,:,1257))
  call Hcheck_last_A_Q(ntryL,l_switch,G0H1(1),31,nMT,G1tensor(1116),n2h1(1168))
  call Hloop_ZA_Q(ntryL,G0H8(74),wf8(:,163),G0H1(1),ngZu,m3h8x1(:,242),heltab2x8(:,:,1258))
  call Hcheck_last_A_Q(ntryL,l_switch,G0H1(1),31,nMT,G1tensor(1121),n2h1(1169))
  call Hloop_WA_Q(ntryL,G0H8(82),wf8(:,163),G0H1(1),m3h8x1(:,243),heltab2x8(:,:,1259))
  call Hcheck_last_A_Q(ntryL,l_switch,G0H1(1),31,nMB,G1tensor(1126),n2h1(1170))
  call Hloop_VA_Q(ntryL,G0H8(18),wf8(:,165),G0H1(1),m3h8x1(:,244),heltab2x8(:,:,1260))
  call Hcheck_last_A_Q(ntryL,l_switch,G0H1(1),31,nMT,G1tensor(1131),n2h1(1171))
  call Hloop_ZA_Q(ntryL,G0H8(20),wf8(:,165),G0H1(1),ngZu,m3h8x1(:,245),heltab2x8(:,:,1261))
  call Hcheck_last_A_Q(ntryL,l_switch,G0H1(1),31,nMT,G1tensor(1136),n2h1(1172))
  call Hloop_WA_Q(ntryL,G0H8(17),wf8(:,165),G0H1(1),m3h8x1(:,246),heltab2x8(:,:,1262))
  call Hcheck_last_A_Q(ntryL,l_switch,G0H1(1),31,nMB,G1tensor(1141),n2h1(1173))
  call Hcheck_last_AQ_S(ntryL,l_switch,G1H8(20),wf8(:,167),G1tensor(1146),ngH,m3h8x1(:,247),heltab2x8(:,:,1263))
  call Hcheck_last_AQ_S(ntryL,l_switch,G1H8(16),wf8(:,167),G1tensor(1151),ngX,m3h8x1(:,248),heltab2x8(:,:,1264))
  call Hcheck_last_AQ_S(ntryL,l_switch,G1H8(17),wf8(:,167),G1tensor(1156),ngPbt,m3h8x1(:,249),heltab2x8(:,:,1265))
  call Hcheck_last_AQ_S(ntryL,l_switch,G1H8(18),wf8(:,169),G1tensor(1161),ngH,m3h8x1(:,250),heltab2x8(:,:,1266))
  call Hcheck_last_AQ_S(ntryL,l_switch,G1H8(29),wf8(:,169),G1tensor(1166),ngX,m3h8x1(:,251),heltab2x8(:,:,1267))
  call Hcheck_last_AQ_S(ntryL,l_switch,G1H8(30),wf8(:,169),G1tensor(1171),ngPbt,m3h8x1(:,252),heltab2x8(:,:,1268))
  call Hcheck_last_AQ_V(ntryL,l_switch,G1H8(43),wf8(:,167),G1tensor(1176),m3h8x1(:,253),heltab2x8(:,:,1269))
  call Hcheck_last_AQ_Z(ntryL,l_switch,G1H8(37),wf8(:,167),G1tensor(1181),ngZu,m3h8x1(:,254),heltab2x8(:,:,1270))
  call Hcheck_last_AQ_W(ntryL,l_switch,G1H8(48),wf8(:,167),G1tensor(1186),m3h8x1(:,255),heltab2x8(:,:,1271))
  call Hcheck_last_AQ_V(ntryL,l_switch,G1H8(67),wf8(:,169),G1tensor(1191),m3h8x1(:,256),heltab2x8(:,:,1272))
  call Hcheck_last_AQ_Z(ntryL,l_switch,G1H8(61),wf8(:,169),G1tensor(1196),ngZu,m3h8x1(:,257),heltab2x8(:,:,1273))
  call Hcheck_last_AQ_W(ntryL,l_switch,G1H8(66),wf8(:,169),G1tensor(1201),m3h8x1(:,258),heltab2x8(:,:,1274))
  call Hcheck_last_AQ_S(ntryL,l_switch,G1H8(92),wf8(:,171),G1tensor(1206),ngH,m3h8x1(:,259),heltab2x8(:,:,1275))
  call Hcheck_last_AQ_S(ntryL,l_switch,G1H8(93),wf8(:,171),G1tensor(1211),ngX,m3h8x1(:,260),heltab2x8(:,:,1276))
  call Hcheck_last_AQ_S(ntryL,l_switch,G1H8(104),wf8(:,171),G1tensor(1216),ngPbt,m3h8x1(:,261),heltab2x8(:,:,1277))
  call Hcheck_last_AQ_S(ntryL,l_switch,G1H8(85),wf8(:,173),G1tensor(1221),ngH,m3h8x1(:,262),heltab2x8(:,:,1278))
  call Hcheck_last_AQ_S(ntryL,l_switch,G1H8(96),wf8(:,173),G1tensor(1226),ngX,m3h8x1(:,263),heltab2x8(:,:,1279))
  call Hcheck_last_AQ_S(ntryL,l_switch,G1H8(91),wf8(:,173),G1tensor(1231),ngPbt,m3h8x1(:,264),heltab2x8(:,:,1280))
  call Hcheck_last_AQ_V(ntryL,l_switch,G1H8(133),wf8(:,171),G1tensor(1236),m3h8x1(:,265),heltab2x8(:,:,1281))
  call Hcheck_last_AQ_Z(ntryL,l_switch,G1H8(139),wf8(:,171),G1tensor(1241),ngZu,m3h8x1(:,266),heltab2x8(:,:,1282))
  call Hcheck_last_AQ_W(ntryL,l_switch,G1H8(140),wf8(:,171),G1tensor(1246),m3h8x1(:,267),heltab2x8(:,:,1283))
  call Hcheck_last_AQ_V(ntryL,l_switch,G1H8(128),wf8(:,173),G1tensor(1251),m3h8x1(:,268),heltab2x8(:,:,1284))
  call Hcheck_last_AQ_Z(ntryL,l_switch,G1H8(117),wf8(:,173),G1tensor(1256),ngZu,m3h8x1(:,269),heltab2x8(:,:,1285))
  call Hcheck_last_AQ_W(ntryL,l_switch,G1H8(118),wf8(:,173),G1tensor(1261),m3h8x1(:,270),heltab2x8(:,:,1286))
  call ol_merge_tensors(G0tensor(1981),[G0tensor(1975),G0tensor(1738),G0tensor(1645),G0tensor(1633),G0tensor(1621),G0tensor(1564) &
    ,G0tensor(1559),G0tensor(1232),G0tensor(1177),G0tensor(867),G0tensor(895),G0tensor(183),G0tensor(1317),G0tensor(129) &
    ,G0tensor(6)])
  call ol_merge_tensors(G1tensor(971),[G1tensor(941),G0tensor(1478),G0tensor(1328),G0tensor(836),G0tensor(811),G0tensor(11)])
  call ol_merge_tensors(G0tensor(544),[G0tensor(1245),G0tensor(448),G0tensor(1200),G0tensor(62),G0tensor(48),G0tensor(680) &
    ,G0tensor(225),G0tensor(66),G0tensor(41),G0tensor(16)])
  call ol_merge_tensors(G0tensor(1983),[G0tensor(1977),G0tensor(1972),G0tensor(1965),G0tensor(1957),G0tensor(1950),G0tensor(1944) &
    ,G0tensor(1924),G0tensor(1910),G0tensor(1904),G0tensor(1892),G0tensor(1885),G0tensor(1826),G0tensor(1819),G0tensor(1806) &
    ,G0tensor(1799),G0tensor(1793),G0tensor(1787),G0tensor(1781),G0tensor(1774),G0tensor(1769),G0tensor(1763),G0tensor(1757) &
    ,G0tensor(1751),G0tensor(1745),G0tensor(1740),G0tensor(1734),G0tensor(1728),G0tensor(1722),G0tensor(1717),G0tensor(1712) &
    ,G0tensor(1706),G0tensor(1700),G0tensor(1694),G0tensor(1688),G0tensor(1682),G0tensor(1675),G0tensor(1668),G0tensor(1661) &
    ,G0tensor(1654),G0tensor(1648),G0tensor(1637),G0tensor(1625),G0tensor(1619),G0tensor(1613),G0tensor(1607),G0tensor(1600) &
    ,G0tensor(1594),G0tensor(1581),G0tensor(1574),G0tensor(1568),G0tensor(1561),G0tensor(1543),G0tensor(1536),G0tensor(1527) &
    ,G0tensor(1520),G0tensor(1507),G0tensor(1501),G0tensor(1494),G0tensor(1485),G0tensor(1479),G0tensor(1468),G0tensor(1462) &
    ,G0tensor(1455),G0tensor(1449),G0tensor(1405),G0tensor(1390),G0tensor(1400),G0tensor(1369),G0tensor(1340),G0tensor(1304) &
    ,G0tensor(1265),G0tensor(1279),G0tensor(1184),G0tensor(1168),G0tensor(1159),G0tensor(1183),G0tensor(1064),G0tensor(1059) &
    ,G0tensor(938),G0tensor(923),G0tensor(899),G0tensor(898),G0tensor(859),G0tensor(853),G0tensor(773),G0tensor(829),G0tensor(749) &
    ,G0tensor(819),G0tensor(784),G0tensor(809),G0tensor(939),G0tensor(683),G0tensor(838),G0tensor(653),G0tensor(618),G0tensor(567) &
    ,G0tensor(1308),G0tensor(603),G0tensor(1172),G0tensor(1273),G0tensor(409),G0tensor(399),G0tensor(393),G0tensor(1087) &
    ,G0tensor(414),G0tensor(1070),G0tensor(372),G0tensor(1057),G0tensor(1018),G0tensor(1060),G0tensor(402),G0tensor(1037) &
    ,G0tensor(317),G0tensor(1063),G0tensor(304),G0tensor(279),G0tensor(282),G0tensor(1048),G0tensor(942),G0tensor(927) &
    ,G0tensor(870),G0tensor(855),G0tensor(1323),G0tensor(1318),G0tensor(1392),G0tensor(143),G0tensor(123),G0tensor(115) &
    ,G0tensor(103),G0tensor(767),G0tensor(1080),G0tensor(1365),G0tensor(78),G0tensor(1332),G0tensor(730),G0tensor(53) &
    ,G0tensor(697),G0tensor(692),G0tensor(52),G0tensor(665),G0tensor(42),G0tensor(650),G0tensor(605),G0tensor(595),G0tensor(23) &
    ,G0tensor(1067),G0tensor(425),G0tensor(9),G0tensor(4),G0tensor(460),G0tensor(257),G0tensor(232),G0tensor(162),G0tensor(602) &
    ,G0tensor(472),G0tensor(828),G0tensor(455),G0tensor(1097),G0tensor(1190),G0tensor(365),G0tensor(902),G0tensor(862) &
    ,G0tensor(847),G0tensor(254),G0tensor(842),G0tensor(159),G0tensor(830),G0tensor(80),G0tensor(725),G0tensor(55),G0tensor(712) &
    ,G0tensor(25),G0tensor(620),G0tensor(1271),G0tensor(1246),G0tensor(1216),G0tensor(1186),G0tensor(1086),G0tensor(1056) &
    ,G0tensor(1026),G0tensor(841),G0tensor(816),G0tensor(786),G0tensor(756),G0tensor(656),G0tensor(626),G0tensor(596) &
    ,G0tensor(571),G0tensor(416),G0tensor(386),G0tensor(351),G0tensor(321),G0tensor(231),G0tensor(196),G0tensor(166),G0tensor(131) &
    ,G0tensor(101),G0tensor(21)])
  call ol_merge_tensors(G0tensor(933),[G0tensor(894),G0tensor(504),G0tensor(505),G0tensor(1313),G0tensor(99),G0tensor(122) &
    ,G0tensor(235),G0tensor(907),G0tensor(31)])
  call ol_merge_tensors(G0tensor(1767),[G0tensor(539),G0tensor(532),G0tensor(499),G0tensor(492),G0tensor(59),G0tensor(705) &
    ,G0tensor(36)])
  call ol_merge_tensors(G0tensor(1970),[G0tensor(1959),G0tensor(1952),G0tensor(1938),G0tensor(1931),G0tensor(1917),G0tensor(1905) &
    ,G0tensor(1898),G0tensor(1891),G0tensor(1884),G0tensor(1878),G0tensor(1872),G0tensor(1866),G0tensor(1860),G0tensor(1854) &
    ,G0tensor(1848),G0tensor(1842),G0tensor(1837),G0tensor(1831),G0tensor(1825),G0tensor(1818),G0tensor(1812),G0tensor(1805) &
    ,G0tensor(1775),G0tensor(1768),G0tensor(1729),G0tensor(1674),G0tensor(1660),G0tensor(1643),G0tensor(1631),G0tensor(1612) &
    ,G0tensor(1601),G0tensor(1593),G0tensor(1587),G0tensor(1580),G0tensor(1567),G0tensor(1562),G0tensor(1556),G0tensor(1550) &
    ,G0tensor(1541),G0tensor(1528),G0tensor(1522),G0tensor(1515),G0tensor(1506),G0tensor(1499),G0tensor(1486),G0tensor(1480) &
    ,G0tensor(1474),G0tensor(1467),G0tensor(1456),G0tensor(1450),G0tensor(1434),G0tensor(1425),G0tensor(1385),G0tensor(1395) &
    ,G0tensor(1349),G0tensor(1305),G0tensor(1294),G0tensor(1295),G0tensor(1255),G0tensor(1249),G0tensor(1239),G0tensor(1153) &
    ,G0tensor(1133),G0tensor(1214),G0tensor(1089),G0tensor(1173),G0tensor(1074),G0tensor(1348),G0tensor(929),G0tensor(904) &
    ,G0tensor(888),G0tensor(1004),G0tensor(909),G0tensor(834),G0tensor(979),G0tensor(919),G0tensor(733),G0tensor(714) &
    ,G0tensor(694),G0tensor(934),G0tensor(674),G0tensor(668),G0tensor(614),G0tensor(594),G0tensor(634),G0tensor(664),G0tensor(525) &
    ,G0tensor(514),G0tensor(494),G0tensor(534),G0tensor(489),G0tensor(638),G0tensor(464),G0tensor(543),G0tensor(1212) &
    ,G0tensor(1207),G0tensor(1205),G0tensor(1197),G0tensor(1182),G0tensor(415),G0tensor(408),G0tensor(498),G0tensor(578) &
    ,G0tensor(398),G0tensor(384),G0tensor(1393),G0tensor(1052),G0tensor(342),G0tensor(1028),G0tensor(328),G0tensor(488) &
    ,G0tensor(323),G0tensor(1017),G0tensor(623),G0tensor(1292),G0tensor(1005),G0tensor(1002),G0tensor(743),G0tensor(663) &
    ,G0tensor(682),G0tensor(208),G0tensor(805),G0tensor(100),G0tensor(1337),G0tensor(94),G0tensor(1422),G0tensor(1412) &
    ,G0tensor(1327),G0tensor(58),G0tensor(344),G0tensor(690),G0tensor(120),G0tensor(218),G0tensor(37),G0tensor(32),G0tensor(630) &
    ,G0tensor(615),G0tensor(19),G0tensor(1157),G0tensor(187),G0tensor(197),G0tensor(157),G0tensor(1248),G0tensor(1218) &
    ,G0tensor(1262),G0tensor(573),G0tensor(813),G0tensor(457),G0tensor(395),G0tensor(385),G0tensor(1170),G0tensor(962) &
    ,G0tensor(950),G0tensor(245),G0tensor(340),G0tensor(925),G0tensor(330),G0tensor(220),G0tensor(887),G0tensor(1440) &
    ,G0tensor(295),G0tensor(935),G0tensor(285),G0tensor(274),G0tensor(164),G0tensor(812),G0tensor(815),G0tensor(750),G0tensor(135) &
    ,G0tensor(722),G0tensor(140),G0tensor(550),G0tensor(1431),G0tensor(1396),G0tensor(1361),G0tensor(1331),G0tensor(1306) &
    ,G0tensor(1151),G0tensor(1121),G0tensor(991),G0tensor(961),G0tensor(931),G0tensor(901),G0tensor(876),G0tensor(721) &
    ,G0tensor(691),G0tensor(536),G0tensor(506),G0tensor(476),G0tensor(451),G0tensor(421),G0tensor(391),G0tensor(356),G0tensor(326) &
    ,G0tensor(286),G0tensor(261),G0tensor(71),G0tensor(46)])
  call ol_merge_tensors(G0tensor(1936),[G0tensor(1858),G0tensor(1840),G0tensor(1835),G0tensor(1829),G0tensor(1823),G0tensor(1725) &
    ,G0tensor(453),G0tensor(434),G0tensor(423),G0tensor(502),G0tensor(445),G0tensor(269),G0tensor(890),G0tensor(920) &
    ,G0tensor(56)])
  call ol_merge_tensors(G1tensor(1251),[G1tensor(1236),G1tensor(1191),G1tensor(1176),G0tensor(1834),G0tensor(1611),G0tensor(484) &
    ,G0tensor(1293),G0tensor(1225),G0tensor(268),G0tensor(1085),G0tensor(61)])
  call ol_merge_tensors(G0tensor(1881),[G0tensor(1703),G0tensor(1678),G0tensor(1657),G0tensor(1651),G0tensor(854),G0tensor(1343) &
    ,G0tensor(557),G0tensor(343),G0tensor(228),G0tensor(785),G0tensor(154),G0tensor(1011),G0tensor(116),G0tensor(81)])
  call ol_merge_tensors(G2tensor(33),[G2tensor(371),G1tensor(486),G1tensor(460),G0tensor(1084),G0tensor(378),G0tensor(1417) &
    ,G0tensor(965),G0tensor(86)])
  call ol_merge_tensors(G1tensor(766),[G1tensor(751),G1tensor(736),G1tensor(721),G1tensor(601),G1tensor(586),G1tensor(571) &
    ,G1tensor(556),G1tensor(541),G1tensor(526),G1tensor(511),G1tensor(496),G0tensor(958),G0tensor(698),G0tensor(82),G0tensor(1206) &
    ,G0tensor(1176),G0tensor(376),G0tensor(221),G0tensor(91)])
  call ol_merge_tensors(G0tensor(1984),[G0tensor(1958),G0tensor(1933),G0tensor(1925),G0tensor(1890),G0tensor(1877),G0tensor(1855) &
    ,G0tensor(1843),G0tensor(1820),G0tensor(1800),G0tensor(1758),G0tensor(1735),G0tensor(1711),G0tensor(1699),G0tensor(1687) &
    ,G0tensor(1681),G0tensor(1673),G0tensor(1666),G0tensor(1642),G0tensor(1636),G0tensor(1618),G0tensor(1592),G0tensor(1548) &
    ,G0tensor(1542),G0tensor(1535),G0tensor(1529),G0tensor(1448),G0tensor(1444),G0tensor(1410),G0tensor(1389),G0tensor(1375) &
    ,G0tensor(1114),G0tensor(1098),G0tensor(1079),G0tensor(1083),G0tensor(953),G0tensor(893),G0tensor(1019),G0tensor(734) &
    ,G0tensor(713),G0tensor(689),G0tensor(589),G0tensor(584),G0tensor(1298),G0tensor(443),G0tensor(438),G0tensor(1278) &
    ,G0tensor(1137),G0tensor(383),G0tensor(379),G0tensor(373),G0tensor(1398),G0tensor(358),G0tensor(357),G0tensor(1013) &
    ,G0tensor(1042),G0tensor(1003),G0tensor(308),G0tensor(302),G0tensor(1058),G0tensor(1040),G0tensor(992),G0tensor(718) &
    ,G0tensor(658),G0tensor(837),G0tensor(163),G0tensor(565),G0tensor(133),G0tensor(745),G0tensor(1360),G0tensor(742) &
    ,G0tensor(647),G0tensor(640),G0tensor(14),G0tensor(485),G0tensor(510),G0tensor(2),G0tensor(222),G0tensor(202),G0tensor(1277) &
    ,G0tensor(592),G0tensor(577),G0tensor(440),G0tensor(259),G0tensor(1110),G0tensor(940),G0tensor(310),G0tensor(900) &
    ,G0tensor(219),G0tensor(85),G0tensor(60),G0tensor(1426),G0tensor(1401),G0tensor(1356),G0tensor(1211),G0tensor(1181) &
    ,G0tensor(1156),G0tensor(1126),G0tensor(781),G0tensor(751),G0tensor(726),G0tensor(696),G0tensor(381),G0tensor(226) &
    ,G0tensor(201),G0tensor(171),G0tensor(96)])
  call ol_merge_tensors(G0tensor(1978),[G0tensor(1951),G0tensor(1945),G0tensor(1919),G0tensor(1911),G0tensor(1883),G0tensor(1871) &
    ,G0tensor(1865),G0tensor(1849),G0tensor(1832),G0tensor(1813),G0tensor(1807),G0tensor(1794),G0tensor(1788),G0tensor(1752) &
    ,G0tensor(1723),G0tensor(1705),G0tensor(1693),G0tensor(1680),G0tensor(1667),G0tensor(1659),G0tensor(1653),G0tensor(1630) &
    ,G0tensor(1624),G0tensor(1606),G0tensor(1586),G0tensor(1579),G0tensor(1573),G0tensor(1513),G0tensor(1500),G0tensor(1493) &
    ,G0tensor(1487),G0tensor(1303),G0tensor(1280),G0tensor(1188),G0tensor(1189),G0tensor(1143),G0tensor(1094),G0tensor(1358) &
    ,G0tensor(1194),G0tensor(984),G0tensor(1044),G0tensor(1014),G0tensor(999),G0tensor(672),G0tensor(657),G0tensor(629) &
    ,G0tensor(604),G0tensor(564),G0tensor(645),G0tensor(1247),G0tensor(474),G0tensor(1195),G0tensor(428),G0tensor(424) &
    ,G0tensor(1122),G0tensor(389),G0tensor(1253),G0tensor(347),G0tensor(503),G0tensor(1388),G0tensor(1140),G0tensor(1032) &
    ,G0tensor(297),G0tensor(293),G0tensor(288),G0tensor(945),G0tensor(238),G0tensor(670),G0tensor(1372),G0tensor(792) &
    ,G0tensor(782),G0tensor(112),G0tensor(1350),G0tensor(1322),G0tensor(720),G0tensor(580),G0tensor(1187),G0tensor(29) &
    ,G0tensor(155),G0tensor(152),G0tensor(127),G0tensor(442),G0tensor(808),G0tensor(538),G0tensor(1180),G0tensor(1120) &
    ,G0tensor(345),G0tensor(875),G0tensor(185),G0tensor(144),G0tensor(70),G0tensor(500),G0tensor(1391),G0tensor(1366) &
    ,G0tensor(1051),G0tensor(1021),G0tensor(996),G0tensor(966),G0tensor(621),G0tensor(566),G0tensor(541),G0tensor(511) &
    ,G0tensor(316),G0tensor(161),G0tensor(136),G0tensor(106)])
  call ol_merge_tensors(G1tensor(321),[G1tensor(279),G1tensor(201),G1tensor(155),G0tensor(1909),G0tensor(1792),G0tensor(1786) &
    ,G0tensor(843),G0tensor(73),G0tensor(270),G0tensor(121)])
  call ol_merge_tensors(G0tensor(1404),[G0tensor(669),G0tensor(633),G0tensor(198),G0tensor(1342),G0tensor(795),G0tensor(1427) &
    ,G0tensor(737),G0tensor(770),G0tensor(184),G0tensor(1081),G0tensor(651),G0tensor(591),G0tensor(346),G0tensor(191) &
    ,G0tensor(126)])
  call ol_merge_tensors(G0tensor(1888),[G0tensor(1709),G0tensor(1685),G0tensor(1671),G0tensor(1664),G0tensor(1024),G0tensor(779) &
    ,G0tensor(1115),G0tensor(273),G0tensor(487),G0tensor(827),G0tensor(1171),G0tensor(211),G0tensor(181),G0tensor(146)])
  call ol_merge_tensors(G0tensor(1073),[G0tensor(1185),G0tensor(349),G0tensor(1160),G0tensor(151)])
  call ol_merge_tensors(G1tensor(746),[G1tensor(716),G1tensor(566),G1tensor(551),G1tensor(506),G1tensor(491),G0tensor(913) &
    ,G0tensor(1123),G0tensor(639),G0tensor(63),G0tensor(1046),G0tensor(1016),G0tensor(311),G0tensor(156)])
  call ol_merge_tensors(G1tensor(395),[G1tensor(371),G1tensor(351),G1tensor(298),G1tensor(335),G1tensor(317),G1tensor(287) &
    ,G1tensor(165),G0tensor(1923),G0tensor(1798),G0tensor(814),G0tensor(1095),G0tensor(79),G0tensor(275),G0tensor(186)])
  call ol_merge_tensors(G2tensor(369),[G0tensor(76),G0tensor(51),G0tensor(26),G0tensor(1204),G0tensor(430),G0tensor(83) &
    ,G0tensor(957),G0tensor(216)])
  call ol_merge_tensors(G0tensor(1901),[G0tensor(1895),G0tensor(804),G0tensor(678),G0tensor(392),G0tensor(1357),G0tensor(267) &
    ,G0tensor(167),G0tensor(1150),G0tensor(249),G0tensor(916),G0tensor(271),G0tensor(241)])
  call ol_merge_tensors(G2tensor(500),[G2tensor(39),G2tensor(54),G2tensor(497),G2tensor(485),G2tensor(11),G2tensor(370) &
    ,G2tensor(264),G1tensor(481),G1tensor(476),G1tensor(471),G1tensor(453),G1tensor(441),G1tensor(417),G0tensor(1963) &
    ,G0tensor(1092),G0tensor(354),G0tensor(264),G0tensor(246)])
  call ol_merge_tensors(G1tensor(771),[G1tensor(756),G1tensor(741),G1tensor(726),G1tensor(606),G1tensor(591),G1tensor(576) &
    ,G1tensor(561),G1tensor(546),G1tensor(531),G1tensor(516),G1tensor(501),G0tensor(949),G0tensor(757),G0tensor(1296) &
    ,G0tensor(1111),G0tensor(951),G0tensor(921),G0tensor(251)])
  call ol_merge_tensors(G0tensor(1971),[G0tensor(1964),G0tensor(1939),G0tensor(1932),G0tensor(1926),G0tensor(1918),G0tensor(1912) &
    ,G0tensor(1903),G0tensor(1897),G0tensor(1782),G0tensor(1776),G0tensor(1746),G0tensor(1599),G0tensor(1555),G0tensor(1549) &
    ,G0tensor(1534),G0tensor(1521),G0tensor(1514),G0tensor(1508),G0tensor(1492),G0tensor(1473),G0tensor(1461),G0tensor(1439) &
    ,G0tensor(1387),G0tensor(1344),G0tensor(1309),G0tensor(1300),G0tensor(1154),G0tensor(1229),G0tensor(974),G0tensor(924) &
    ,G0tensor(729),G0tensor(783),G0tensor(619),G0tensor(1240),G0tensor(463),G0tensor(1263),G0tensor(412),G0tensor(1038) &
    ,G0tensor(353),G0tensor(348),G0tensor(1023),G0tensor(1065),G0tensor(312),G0tensor(768),G0tensor(738),G0tensor(284) &
    ,G0tensor(277),G0tensor(263),G0tensor(248),G0tensor(223),G0tensor(1362),G0tensor(193),G0tensor(822),G0tensor(1377) &
    ,G0tensor(1367),G0tensor(655),G0tensor(107),G0tensor(89),G0tensor(752),G0tensor(707),G0tensor(104),G0tensor(39),G0tensor(24) &
    ,G0tensor(1147),G0tensor(177),G0tensor(242),G0tensor(105),G0tensor(132),G0tensor(1193),G0tensor(1272),G0tensor(1252) &
    ,G0tensor(467),G0tensor(833),G0tensor(793),G0tensor(977),G0tensor(937),G0tensor(435),G0tensor(922),G0tensor(325),G0tensor(290) &
    ,G0tensor(685),G0tensor(1301),G0tensor(1276),G0tensor(1221),G0tensor(1116),G0tensor(1091),G0tensor(1061),G0tensor(956) &
    ,G0tensor(926),G0tensor(871),G0tensor(846),G0tensor(791),G0tensor(686),G0tensor(661),G0tensor(631),G0tensor(501),G0tensor(446) &
    ,G0tensor(291),G0tensor(256)])
  call ol_merge_tensors(G1tensor(461),[G1tensor(382),G1tensor(419),G1tensor(303),G1tensor(269),G1tensor(280),G1tensor(221) &
    ,G1tensor(177),G0tensor(1937),G0tensor(1930),G0tensor(1916),G0tensor(754),G0tensor(84),G0tensor(276)])
  call ol_merge_tensors(G0tensor(1836),[G0tensor(1285),G0tensor(759),G0tensor(508),G0tensor(1297),G0tensor(287),G0tensor(150) &
    ,G0tensor(114),G0tensor(27),G0tensor(1326),G0tensor(1146),G0tensor(986),G0tensor(896),G0tensor(716),G0tensor(531) &
    ,G0tensor(471),G0tensor(281)])
  call ol_merge_tensors(G2tensor(569),[G2tensor(129),G0tensor(667),G0tensor(597),G0tensor(108),G0tensor(98),G0tensor(845) &
    ,G0tensor(169),G0tensor(124),G0tensor(401),G0tensor(366),G0tensor(336),G0tensor(301)])
  call ol_merge_tensors(G0tensor(1583),[G0tensor(1482),G0tensor(1299),G0tensor(1275),G0tensor(1078),G0tensor(1069),G0tensor(444) &
    ,G0tensor(1283),G0tensor(180),G0tensor(45),G0tensor(1341),G0tensor(976),G0tensor(941),G0tensor(306)])
  call ol_merge_tensors(G2tensor(228),[G2tensor(255),G0tensor(1670),G0tensor(1656),G0tensor(982),G0tensor(587),G0tensor(390) &
    ,G0tensor(375),G0tensor(370),G0tensor(125),G0tensor(5),G0tensor(30),G0tensor(341)])
  call ol_merge_tensors(G0tensor(1524),[G0tensor(1446),G0tensor(1415),G0tensor(1088),G0tensor(1109),G0tensor(454),G0tensor(1288) &
    ,G0tensor(189),G0tensor(15),G0tensor(1411),G0tensor(1376),G0tensor(1136),G0tensor(1101),G0tensor(371)])
  call ol_merge_tensors(G0tensor(1639),[G0tensor(1627),G0tensor(1558),G0tensor(1477),G0tensor(1471),G0tensor(1219),G0tensor(1119) &
    ,G0tensor(1227),G0tensor(1222),G0tensor(905),G0tensor(715),G0tensor(1316),G0tensor(1286),G0tensor(406)])
  call ol_merge_tensors(G1tensor(761),[G1tensor(731),G1tensor(596),G1tensor(581),G1tensor(536),G1tensor(521),G0tensor(968) &
    ,G0tensor(884),G0tensor(864),G0tensor(858),G0tensor(165),G0tensor(1266),G0tensor(1241),G0tensor(411)])
  call ol_merge_tensors(G2tensor(31),[G2tensor(282),G2tensor(368),G2tensor(366),G0tensor(315),G0tensor(209),G0tensor(200) &
    ,G0tensor(865),G0tensor(960),G0tensor(850),G0tensor(911),G0tensor(461),G0tensor(431)])
  call ol_merge_tensors(G0tensor(1771),[G0tensor(1597),G0tensor(609),G0tensor(760),G0tensor(17),G0tensor(1403),G0tensor(803) &
    ,G0tensor(932),G0tensor(436)])
  call ol_merge_tensors(G1tensor(981),[G1tensor(966),G1tensor(951),G1tensor(936),G0tensor(1158),G0tensor(97),G0tensor(866) &
    ,G0tensor(681),G0tensor(496),G0tensor(441)])
  call ol_merge_tensors(G2tensor(334),[G2tensor(331),G2tensor(324),G2tensor(311),G0tensor(877),G0tensor(109),G0tensor(695) &
    ,G0tensor(158),G0tensor(207),G0tensor(1223),G0tensor(117),G0tensor(1408),G0tensor(427),G0tensor(466)])
  call ol_merge_tensors(G0tensor(1862),[G0tensor(1511),G0tensor(1134),G0tensor(659),G0tensor(582),G0tensor(483),G0tensor(1242) &
    ,G0tensor(377),G0tensor(250),G0tensor(872),G0tensor(65),G0tensor(521),G0tensor(486)])
  call ol_merge_tensors(G2tensor(279),[G2tensor(258),G1tensor(921),G1tensor(881),G0tensor(1907),G0tensor(1139),G0tensor(1383) &
    ,G0tensor(772),G0tensor(798),G0tensor(491)])
  call ol_merge_tensors(G1tensor(851),[G1tensor(821),G0tensor(1174),G0tensor(649),G0tensor(95),G0tensor(818),G0tensor(526)])
  call ol_merge_tensors(G2tensor(494),[G2tensor(1),G2tensor(240),G2tensor(201),G0tensor(87),G0tensor(214),G0tensor(194) &
    ,G0tensor(1231),G0tensor(1166),G0tensor(1006),G0tensor(801),G0tensor(736),G0tensor(581),G0tensor(551)])
  call ol_merge_tensors(G0tensor(1802),[G0tensor(1622),G0tensor(1577),G0tensor(1571),G0tensor(1030),G0tensor(625),G0tensor(173) &
    ,G0tensor(452),G0tensor(556)])
  call ol_merge_tensors(G1tensor(956),[G1tensor(926),G0tensor(1289),G0tensor(825),G0tensor(616),G0tensor(561)])
  call ol_merge_tensors(G2tensor(342),[G2tensor(332),G2tensor(629),G2tensor(614),G0tensor(299),G0tensor(1282),G0tensor(233) &
    ,G0tensor(1347),G0tensor(817),G0tensor(610),G0tensor(247),G0tensor(482),G0tensor(586)])
  call ol_merge_tensors(G0tensor(1532),[G0tensor(1490),G0tensor(1259),G0tensor(989),G0tensor(628),G0tensor(1047),G0tensor(972) &
    ,G0tensor(897),G0tensor(826),G0tensor(766),G0tensor(641),G0tensor(606)])
  call ol_merge_tensors(G0tensor(1914),[G0tensor(1315),G0tensor(387),G0tensor(110),G0tensor(447),G0tensor(611)])
  call ol_merge_tensors(G1tensor(876),[G1tensor(861),G1tensor(846),G1tensor(831),G0tensor(1335),G0tensor(880),G0tensor(153) &
    ,G0tensor(175),G0tensor(477),G0tensor(646)])
  call ol_merge_tensors(G0tensor(1546),[G0tensor(1370),G0tensor(794),G0tensor(519),G0tensor(497),G0tensor(993),G0tensor(1075) &
    ,G0tensor(255),G0tensor(980),G0tensor(205),G0tensor(145),G0tensor(706),G0tensor(671)])
  call ol_merge_tensors(G2tensor(306),[G2tensor(288),G2tensor(291),G2tensor(294),G2tensor(231),G1tensor(901),G1tensor(891) &
    ,G1tensor(886),G0tensor(1921),G0tensor(1384),G0tensor(1105),G0tensor(128),G0tensor(1257),G0tensor(676)])
  call ol_merge_tensors(G1tensor(871),[G1tensor(856),G1tensor(841),G1tensor(826),G0tensor(1399),G0tensor(470),G0tensor(820) &
    ,G0tensor(1267),G0tensor(711)])
  call ol_merge_tensors(G0tensor(1815),[G0tensor(1634),G0tensor(1590),G0tensor(1368),G0tensor(138),G0tensor(520),G0tensor(8) &
    ,G0tensor(1428),G0tensor(741)])
  call ol_merge_tensors(G1tensor(976),[G1tensor(961),G1tensor(946),G1tensor(931),G0tensor(1447),G0tensor(832),G0tensor(776) &
    ,G0tensor(746)])
  call ol_merge_tensors(G2tensor(186),[G1tensor(916),G0tensor(1928),G0tensor(1433),G0tensor(673),G0tensor(547),G0tensor(1423) &
    ,G0tensor(771)])
  call ol_merge_tensors(G0tensor(1822),[G0tensor(1646),G0tensor(1616),G0tensor(1610),G0tensor(1604),G0tensor(840),G0tensor(755) &
    ,G0tensor(43),G0tensor(1213),G0tensor(806)])
  call ol_merge_tensors(G2tensor(198),[G1tensor(911),G0tensor(1935),G0tensor(1472),G0tensor(1250),G0tensor(188),G0tensor(1198) &
    ,G0tensor(1100),G0tensor(831)])
  call ol_merge_tensors(G0tensor(1874),[G0tensor(1868),G0tensor(1553),G0tensor(1452),G0tensor(883),G0tensor(844),G0tensor(848) &
    ,G0tensor(527),G0tensor(599),G0tensor(67),G0tensor(74),G0tensor(18),G0tensor(149),G0tensor(886),G0tensor(856)])
  call ol_merge_tensors(G2tensor(303),[G2tensor(273),G2tensor(261),G1tensor(906),G1tensor(896),G0tensor(1778),G0tensor(1460) &
    ,G0tensor(559),G0tensor(422),G0tensor(54),G0tensor(239),G0tensor(861)])
  call ol_merge_tensors(G1tensor(866),[G1tensor(836),G0tensor(1466),G0tensor(420),G0tensor(72),G0tensor(702),G0tensor(1243) &
    ,G0tensor(891)])
  call ol_merge_tensors(G2tensor(99),[G2tensor(72),G1tensor(651),G1tensor(611),G0tensor(1491),G0tensor(648),G0tensor(142) &
    ,G0tensor(946)])
  call ol_merge_tensors(G1tensor(1101),[G1tensor(1086),G1tensor(1041),G1tensor(1026),G1tensor(686),G1tensor(656),G0tensor(1830) &
    ,G0tensor(1811),G0tensor(1498),G0tensor(1020),G0tensor(213),G0tensor(22),G0tensor(172),G0tensor(981)])
  call ol_merge_tensors(G0tensor(1962),[G0tensor(1503),G0tensor(1459),G0tensor(1419),G0tensor(1234),G0tensor(1148),G0tensor(860) &
    ,G0tensor(1441),G0tensor(1256),G0tensor(1196),G0tensor(1071),G0tensor(1036)])
  call ol_merge_tensors(G2tensor(572),[G2tensor(560),G1tensor(811),G1tensor(776),G0tensor(1512),G0tensor(955),G0tensor(780) &
    ,G0tensor(1041)])
  call ol_merge_tensors(G1tensor(1141),[G1tensor(1126),G1tensor(1111),G1tensor(1096),G1tensor(1081),G1tensor(1066),G1tensor(1051) &
    ,G1tensor(1036),G1tensor(711),G1tensor(696),G1tensor(681),G1tensor(666),G0tensor(1519),G0tensor(1307),G0tensor(319) &
    ,G0tensor(608),G0tensor(243),G0tensor(262),G0tensor(1076)])
  call ol_merge_tensors(G2tensor(539),[G2tensor(126),G2tensor(521),G2tensor(551),G2tensor(132),G2tensor(102),G1tensor(806) &
    ,G1tensor(631),G1tensor(621),G1tensor(616),G0tensor(1533),G0tensor(952),G0tensor(182),G0tensor(1106)])
  call ol_merge_tensors(G1tensor(1136),[G1tensor(1121),G1tensor(1106),G1tensor(1091),G1tensor(1076),G1tensor(1061),G1tensor(1046) &
    ,G1tensor(1031),G1tensor(706),G1tensor(691),G1tensor(676),G1tensor(661),G0tensor(1841),G0tensor(1540),G0tensor(303) &
    ,G0tensor(627),G0tensor(967),G0tensor(113),G0tensor(192),G0tensor(1141)])
  call ol_merge_tensors(G2tensor(584),[G2tensor(593),G2tensor(156),G2tensor(168),G2tensor(153),G2tensor(503),G1tensor(796) &
    ,G1tensor(786),G1tensor(781),G1tensor(646),G0tensor(1547),G0tensor(688),G0tensor(148),G0tensor(1201)])
  call ol_merge_tensors(G0tensor(1766),[G0tensor(1715),G0tensor(1697),G0tensor(1691),G0tensor(954),G0tensor(948),G0tensor(943) &
    ,G0tensor(903),G0tensor(513),G0tensor(997),G0tensor(687),G0tensor(642),G0tensor(545),G0tensor(224),G0tensor(179) &
    ,G0tensor(1236)])
  call ol_merge_tensors(G2tensor(587),[G2tensor(590),G2tensor(602),G2tensor(63),G1tensor(816),G1tensor(791),G1tensor(641) &
    ,G0tensor(1554),G0tensor(549),G0tensor(542),G0tensor(283),G0tensor(495),G0tensor(1261)])
  call ol_merge_tensors(G2tensor(536),[G2tensor(554),G2tensor(93),G2tensor(548),G1tensor(801),G1tensor(636),G1tensor(626) &
    ,G0tensor(1742),G0tensor(468),G0tensor(558),G0tensor(1068),G0tensor(229),G0tensor(1291)])
  call ol_merge_tensors(G1tensor(1131),[G1tensor(1116),G1tensor(1071),G1tensor(1056),G1tensor(701),G1tensor(671),G0tensor(1859) &
    ,G0tensor(1853),G0tensor(1847),G0tensor(1566),G0tensor(1043),G0tensor(652),G0tensor(7),G0tensor(1321)])
  call ol_merge_tensors(G0tensor(1665),[G0tensor(332),G0tensor(289),G0tensor(560),G0tensor(1346)])
  call ol_merge_tensors(G1tensor(1256),[G1tensor(1241),G1tensor(1226),G1tensor(1211),G1tensor(1196),G1tensor(1181),G1tensor(1166) &
    ,G1tensor(1151),G0tensor(1672),G0tensor(1641),G0tensor(1591),G0tensor(363),G0tensor(1010),G0tensor(1421),G0tensor(1351)])
  call ol_merge_tensors(G2tensor(344),[G2tensor(318),G1tensor(1021),G1tensor(991),G0tensor(1679),G0tensor(1045),G0tensor(708) &
    ,G0tensor(12),G0tensor(1381)])
  call ol_merge_tensors(G1tensor(1221),[G1tensor(1206),G1tensor(1161),G1tensor(1146),G0tensor(1658),G0tensor(1629),G0tensor(1585) &
    ,G0tensor(1578),G0tensor(352),G0tensor(307),G0tensor(1386)])
  call ol_merge_tensors(G2tensor(315),[G0tensor(206),G0tensor(176),G0tensor(141),G0tensor(1686),G0tensor(397),G0tensor(298) &
    ,G0tensor(34),G0tensor(1416)])
  call ol_merge_tensors(G2tensor(345),[G2tensor(341),G2tensor(340),G2tensor(339),G2tensor(337),G2tensor(343),G2tensor(317) &
    ,G2tensor(316),G1tensor(1016),G1tensor(1011),G1tensor(1006),G1tensor(1001),G1tensor(996),G1tensor(986),G0tensor(1896) &
    ,G0tensor(338),G0tensor(309),G0tensor(530),G0tensor(535)])
  call ol_merge_tensors(G1tensor(1261),[G1tensor(1246),G1tensor(1231),G1tensor(1216),G1tensor(1201),G1tensor(1186),G1tensor(1171) &
    ,G1tensor(1156),G0tensor(1598),G0tensor(417),G0tensor(1055),G0tensor(1378),G0tensor(753),G0tensor(20)])
  call ol_merge_tensors(G0tensor(1785),[G0tensor(1749),G0tensor(1690),G0tensor(1663),G0tensor(1650),G0tensor(1244),G0tensor(1224) &
    ,G0tensor(1129),G0tensor(930),G0tensor(915),G0tensor(329),G0tensor(1355),G0tensor(572),G0tensor(35)])
  call ol_merge_tensors(G0tensor(1755),[G0tensor(1696),G0tensor(1684),G0tensor(1677),G0tensor(1394),G0tensor(1379),G0tensor(1414) &
    ,G0tensor(612),G0tensor(1287),G0tensor(1145),G0tensor(77),G0tensor(727),G0tensor(632),G0tensor(10)])
  call ol_merge_tensors(G0tensor(1797),[G0tensor(1791),G0tensor(1761),G0tensor(1714),G0tensor(1708),G0tensor(1702),G0tensor(1464) &
    ,G0tensor(1458),G0tensor(1453),G0tensor(1000),G0tensor(314),G0tensor(90),G0tensor(1338),G0tensor(700)])
  call ol_merge_tensors(G0tensor(1942),[G0tensor(1720),G0tensor(1603),G0tensor(1570),G0tensor(1496),G0tensor(1489),G0tensor(1483) &
    ,G0tensor(403),G0tensor(1175),G0tensor(810),G0tensor(787),G0tensor(617),G0tensor(410),G0tensor(775)])
  call ol_merge_tensors(G2tensor(509),[G2tensor(48),G0tensor(1152),G0tensor(1319),G0tensor(1268),G0tensor(1373),G0tensor(313) &
    ,G0tensor(1345),G0tensor(64),G0tensor(119),G0tensor(747),G0tensor(735)])
  call ol_merge_tensors(G0tensor(1732),[G0tensor(1615),G0tensor(1538),G0tensor(1531),G0tensor(1525),G0tensor(413),G0tensor(380) &
    ,G0tensor(1324),G0tensor(168),G0tensor(540),G0tensor(1382),G0tensor(570),G0tensor(512),G0tensor(75)])
  call ol_merge_tensors(G0tensor(1947),[G0tensor(1915),G0tensor(1846),G0tensor(1810),G0tensor(1803),G0tensor(1179),G0tensor(1169) &
    ,G0tensor(969),G0tensor(703),G0tensor(292),G0tensor(1228),G0tensor(1203),G0tensor(987),G0tensor(1435),G0tensor(134)])
  call ol_merge_tensors(G0tensor(1954),[G0tensor(1929),G0tensor(1852),G0tensor(1816),G0tensor(1104),G0tensor(1093),G0tensor(1103) &
    ,G0tensor(1015),G0tensor(294),G0tensor(1035),G0tensor(212),G0tensor(272),G0tensor(475),G0tensor(975),G0tensor(174)])
  call ol_merge_tensors(G1tensor(388),[G1tensor(364),G1tensor(255),G1tensor(232),G0tensor(1780),G0tensor(1762),G0tensor(1756) &
    ,G0tensor(1750),G0tensor(1049),G0tensor(1402),G0tensor(1117),G0tensor(204)])
  call ol_merge_tensors(G0tensor(1967),[G0tensor(1961),G0tensor(1922),G0tensor(1908),G0tensor(1779),G0tensor(1772),G0tensor(637) &
    ,G0tensor(1312),G0tensor(3),G0tensor(537),G0tensor(252),G0tensor(790),G0tensor(244)])
  call ol_merge_tensors(G0tensor(994),[G0tensor(654),G0tensor(590),G0tensor(554),G0tensor(388),G0tensor(432),G0tensor(400) &
    ,G0tensor(1135),G0tensor(300)])
  call ol_merge_tensors(G0tensor(869),[G0tensor(964),G0tensor(724),G0tensor(1329),G0tensor(1418),G0tensor(1413),G0tensor(355) &
    ,G0tensor(350),G0tensor(882)])
  call ol_merge_tensors(G0tensor(1743),[G0tensor(824),G0tensor(723),G0tensor(1238),G0tensor(1442),G0tensor(563),G0tensor(462) &
    ,G0tensor(260),G0tensor(533)])
  call ol_merge_tensors(G2tensor(25),[G2tensor(23),G2tensor(21),G2tensor(19),G0tensor(1760),G0tensor(1737),G0tensor(973) &
    ,G0tensor(517),G0tensor(613),G0tensor(910)])
  call ol_merge_tensors(G2tensor(378),[G2tensor(374),G2tensor(347),G2tensor(348),G0tensor(1857),G0tensor(1716),G0tensor(1647) &
    ,G0tensor(524),G0tensor(548),G0tensor(320)])
  call ol_merge_tensors(G0tensor(1552),[G0tensor(1545),G0tensor(1517),G0tensor(1510),G0tensor(1504),G0tensor(419),G0tensor(835) &
    ,G0tensor(777),G0tensor(170),G0tensor(1407),G0tensor(710),G0tensor(368)])
  call ol_merge_tensors(G0tensor(1744),[G0tensor(1739),G0tensor(1733),G0tensor(1727),G0tensor(1721),G0tensor(49),G0tensor(57) &
    ,G0tensor(660)])
  call ol_merge_tensors(G0tensor(1894),[G0tensor(1470),G0tensor(1420),G0tensor(1325),G0tensor(1310),G0tensor(1290),G0tensor(1053) &
    ,G0tensor(258),G0tensor(528),G0tensor(1333),G0tensor(364),G0tensor(334)])
  call ol_merge_tensors(G0tensor(1882),[G0tensor(1870),G0tensor(1864),G0tensor(333),G0tensor(318)])
  call ol_merge_tensors(G0tensor(1889),[G0tensor(1876),G0tensor(362),G0tensor(327),G0tensor(1008)])
  call ol_merge_tensors(G0tensor(1902),[G0tensor(1125)])
  call ol_merge_tensors(G0tensor(1982),[G0tensor(1956),G0tensor(1127),G0tensor(1258),G0tensor(1165)])
  call ol_merge_tensors(G0tensor(1976),[G0tensor(1949),G0tensor(1943),G0tensor(1112),G0tensor(1077)])
  call ol_merge_tensors(G0tensor(1969),[G0tensor(394)])
  call ol_merge_tensors(G0tensor(480),[G0tensor(1167),G0tensor(593),G0tensor(1142)])
  call ol_merge_tensors(G0tensor(1748),[G0tensor(1719),G0tensor(918),G0tensor(478),G0tensor(1230),G0tensor(1192)])
  call ol_merge_tensors(G0tensor(1828),[G0tensor(1692),G0tensor(1605),G0tensor(574),G0tensor(1210),G0tensor(429)])
  call ol_merge_tensors(G0tensor(1754),[G0tensor(1731),G0tensor(944),G0tensor(490),G0tensor(1220),G0tensor(1202)])
  call ol_merge_tensors(G0tensor(1839),[G0tensor(1698),G0tensor(1617),G0tensor(509),G0tensor(1215),G0tensor(439)])
  call ol_merge_tensors(G0tensor(1968),[G0tensor(1596),G0tensor(1505),G0tensor(1465),G0tensor(1429),G0tensor(1254),G0tensor(1178) &
    ,G0tensor(1039),G0tensor(849),G0tensor(699),G0tensor(679),G0tensor(908),G0tensor(579),G0tensor(788)])
  call ol_merge_tensors(G0tensor(1),[G0tensor(1941),G0tensor(1784),G0tensor(988),G0tensor(1128),G0tensor(575)])
  call ol_merge_tensors(G0tensor(1887),[G0tensor(1880),G0tensor(1773),G0tensor(1765),G0tensor(1518),G0tensor(1454),G0tensor(1374) &
    ,G0tensor(1264),G0tensor(1144),G0tensor(1363),G0tensor(928),G0tensor(959),G0tensor(677),G0tensor(868)])
  call ol_merge_tensors(G0tensor(1955),[G0tensor(1948),G0tensor(1726),G0tensor(1609),G0tensor(1589),G0tensor(1576),G0tensor(1560) &
    ,G0tensor(1526),G0tensor(1484),G0tensor(1364),G0tensor(1330),G0tensor(774),G0tensor(739),G0tensor(719)])
  call ol_merge_tensors(G0tensor(1900),[G0tensor(1824),G0tensor(1817),G0tensor(1804),G0tensor(1565),G0tensor(1539),G0tensor(1497) &
    ,G0tensor(1476),G0tensor(1443),G0tensor(1359),G0tensor(1314),G0tensor(1260),G0tensor(764),G0tensor(763)])
  call ol_merge_tensors(G0tensor(1974),[G0tensor(1790),G0tensor(1099),G0tensor(1009),G0tensor(839)])
  call ol_merge_tensors(G0tensor(1980),[G0tensor(1796),G0tensor(1118),G0tensor(889),G0tensor(878)])
  call ol_merge_tensors(G0tensor(111),[G0tensor(1863),G0tensor(1809),G0tensor(1652),G0tensor(1584),G0tensor(1572)])
  call ol_merge_tensors(G0tensor(1869),[G0tensor(1845),G0tensor(1704),G0tensor(1628),G0tensor(1623)])
  call ol_merge_tensors(G0tensor(1875),[G0tensor(1851),G0tensor(1710),G0tensor(1640),G0tensor(1635)])
  call ol_merge_tensors(G2tensor(3),[G2tensor(300),G2tensor(225),G2tensor(177)])
  call ol_merge_tensors(G2tensor(5),[G2tensor(372),G2tensor(367),G2tensor(365)])
  call ol_merge_tensors(G2tensor(29),[G2tensor(373),G2tensor(210),G2tensor(183)])
  call ol_merge_tensors(G2tensor(512),[G2tensor(27)])
  call ol_merge_tensors(G2tensor(87),[G2tensor(57)])
  call ol_merge_tensors(G2tensor(78),[G2tensor(51)])
  call ol_merge_tensors(G2tensor(162),[G2tensor(524)])
  call ol_merge_tensors(G2tensor(596),[G2tensor(114)])
  call ol_merge_tensors(G2tensor(599),[G2tensor(542)])
  call ol_merge_tensors(G2tensor(138),[G2tensor(545)])
  call ol_merge_tensors(G2tensor(252),[G2tensor(174)])
  call ol_merge_tensors(G2tensor(246),[G2tensor(608)])
  call ol_merge_tensors(G2tensor(213),[G2tensor(237)])
  call ol_merge_tensors(G2tensor(329),[G2tensor(319),G2tensor(322),G2tensor(320)])
  call ol_merge_tensors(G2tensor(330),[G2tensor(325),G2tensor(626),G2tensor(321)])
  call ol_merge_tensors(G2tensor(333),[G2tensor(326),G2tensor(323),G2tensor(623)])
call TI_bubble_red(G2tensor(33),28,mass2set(:,1),G0tensor(236),M2L1R1,G0tensor(266),G0tensor(296))
call TI_bubble_red(G2tensor(369),28,mass2set(:,2),G0tensor(331),M2L1R1,G0tensor(361))
call TI_bubble_red(G2tensor(500),28,mass2set(:,3),G0tensor(396),M2L1R1,G0tensor(426))
call TI_bubble_red(G2tensor(569),25,mass2set(:,4),G0tensor(456),M2L1R1,G0tensor(481),G0tensor(516))
call TI_bubble_red(G2tensor(228),22,mass2set(:,5),G0tensor(546),M2L1R1,G0tensor(576),G0tensor(601))
call TI_bubble_red(G2tensor(31),28,mass2set(:,6),G0tensor(636),M2L1R1,G0tensor(666))
call TI_bubble_red(G2tensor(334),19,mass2set(:,6),G0tensor(701),M2L1R1,G0tensor(731))
call TI_bubble_red(G2tensor(279),22,mass2set(:,7),G0tensor(761),M2L1R1,G0tensor(796),G0tensor(821))
call TI_bubble_red(G2tensor(494),28,mass2set(:,8),G0tensor(851),M2L1R1,G0tensor(881))
call TI_bubble_red(G2tensor(342),19,mass2set(:,8),G0tensor(906),M2L1R1,G0tensor(936))
call TI_bubble_red(G2tensor(306),22,mass2set(:,9),G0tensor(971),M2L1R1,G0tensor(1001),G0tensor(1031))
call TI_bubble_red(G2tensor(186),22,mass2set(:,10),G0tensor(1066),M2L1R1,G0tensor(1096),G0tensor(1131))
call TI_bubble_red(G2tensor(198),22,mass2set(:,11),G0tensor(1161),M2L1R1,G0tensor(1191))
call TI_bubble_red(G2tensor(303),22,mass2set(:,12),G0tensor(1226),M2L1R1,G0tensor(1251))
call TI_bubble_red(G2tensor(99),25,mass2set(:,7),G0tensor(1281),M2L1R1,G0tensor(1311),G0tensor(1336))
call TI_bubble_red(G2tensor(572),25,mass2set(:,13),G0tensor(1371),M2L1R1,G0tensor(1406),G0tensor(1436))
call TI_bubble_red(G2tensor(539),25,mass2set(:,9),G0tensor(585),M2L1R1,G0tensor(40),G0tensor(765))
call TI_bubble_red(G2tensor(584),25,mass2set(:,10),G0tensor(130),M2L1R1,G0tensor(732),G0tensor(797))
call TI_bubble_red(G2tensor(587),25,mass2set(:,11),G0tensor(800),M2L1R1,G0tensor(139))
call TI_bubble_red(G2tensor(536),25,mass2set(:,12),G0tensor(199),M2L1R1,G0tensor(234))
call TI_bubble_red(G2tensor(344),19,mass2set(:,14),G0tensor(280),M2L1R1,G0tensor(857),G0tensor(885))
call TI_bubble_red(G2tensor(315),19,mass2set(:,2),G0tensor(190),M2L1R1,G0tensor(195))
call TI_bubble_red(G2tensor(345),19,mass2set(:,3),G0tensor(305),M2L1R1,G0tensor(210))
call TI_bubble_red(G2tensor(509),25,mass2set(:,5),G0tensor(215),M2L1R1,G0tensor(518),G0tensor(469))
call TI_bubble_red(G2tensor(25),28,mass2set(:,15),G0tensor(433),M2L1R1)
call TI_bubble_red(G2tensor(378),19,mass2set(:,15),G0tensor(449),M2L1R1)
call TI_bubble_red(G2tensor(3),28,mass2set(:,16),G0tensor(479),M2L1R1,G0tensor(1235))
call TI_bubble_red(G2tensor(5),28,mass2set(:,17),G0tensor(1217),M2L1R1,G0tensor(458))
call TI_bubble_red(G2tensor(29),28,mass2set(:,18),G0tensor(1445),M2L1R1,G0tensor(459))
call TI_bubble_red(G2tensor(512),25,mass2set(:,19),G0tensor(1237),M2L1R1,G0tensor(473))
call TI_bubble_red(G2tensor(87),25,mass2set(:,20),G0tensor(568),M2L1R1,G0tensor(515))
call TI_bubble_red(G2tensor(78),25,mass2set(:,21),G0tensor(529),M2L1R1,G0tensor(507))
call TI_bubble_red(G2tensor(162),25,mass2set(:,15),G0tensor(644),M2L1R1)
call TI_bubble_red(G2tensor(596),25,mass2set(:,22),G0tensor(917),M2L1R1,G0tensor(230))
call TI_bubble_red(G2tensor(599),25,mass2set(:,23),G0tensor(335),M2L1R1,G0tensor(778))
call TI_bubble_red(G2tensor(138),25,mass2set(:,24),G0tensor(569),M2L1R1,G0tensor(624))
call TI_bubble_red(G2tensor(252),22,mass2set(:,19),G0tensor(600),M2L1R1,G0tensor(583))
call TI_bubble_red(G2tensor(246),22,mass2set(:,20),G0tensor(1353),M2L1R1,G0tensor(662))
call TI_bubble_red(G2tensor(213),22,mass2set(:,21),G0tensor(1029),M2L1R1,G0tensor(240))
call TI_bubble_red(G2tensor(297),22,mass2set(:,15),G0tensor(684),M2L1R1)
call TI_bubble_red(G2tensor(329),19,mass2set(:,16),G0tensor(799),M2L1R1,G0tensor(947))
call TI_bubble_red(G2tensor(330),19,mass2set(:,17),G0tensor(704),M2L1R1,G0tensor(450))
call TI_bubble_red(G2tensor(333),19,mass2set(:,18),G0tensor(709),M2L1R1,G0tensor(360))
  call ol_merge_tensors(G0tensor(518),[G0tensor(936),G0tensor(881),G0tensor(576),G0tensor(516),G0tensor(1983)])
  call ol_merge_tensors(G0tensor(469),[G0tensor(731),G0tensor(666),G0tensor(601),G0tensor(481),G0tensor(1970)])
  call ol_merge_tensors(G0tensor(195),[G0tensor(885),G0tensor(732),G0tensor(765),G0tensor(1096),G0tensor(1031),G0tensor(361) &
    ,G0tensor(1984),G0tensor(266)])
  call ol_merge_tensors(G0tensor(857),[G0tensor(1406),G0tensor(1336),G0tensor(821),G0tensor(1978),G0tensor(296)])
  call ol_merge_tensors(G0tensor(210),[G0tensor(234),G0tensor(139),G0tensor(797),G0tensor(40),G0tensor(1436),G0tensor(1311) &
    ,G0tensor(1251),G0tensor(1191),G0tensor(1131),G0tensor(1001),G0tensor(796),G0tensor(1971),G0tensor(426)])
  call ol_merge_tensors(G0tensor(947),[G0tensor(583),G0tensor(230),G0tensor(473),G0tensor(1235)])
  call ol_merge_tensors(G0tensor(450),[G0tensor(662),G0tensor(778),G0tensor(515),G0tensor(458)])
  call ol_merge_tensors(G0tensor(360),[G0tensor(240),G0tensor(624),G0tensor(507),G0tensor(459)])
call TI_bubble_red(G1tensor(971),20,mass2set(:,25),G0tensor(748),M2L1R1,G0tensor(744))
call TI_bubble_red(G1tensor(1251),18,mass2set(:,26),G0tensor(789),M2L1R1,G0tensor(769))
call TI_bubble_red(G1tensor(766),24,mass2set(:,27),G0tensor(874),M2L1R1,G0tensor(863),G0tensor(873))
call TI_bubble_red(G1tensor(321),20,mass2set(:,28),G0tensor(879),M2L1R1,G0tensor(1034),G0tensor(983))
call TI_bubble_red(G1tensor(746),24,mass2set(:,29),G0tensor(914),M2L1R1,G0tensor(1054),G0tensor(963))
call TI_bubble_red(G1tensor(395),20,mass2set(:,30),G0tensor(978),M2L1R1,G0tensor(265),G0tensor(1163))
call TI_bubble_red(G1tensor(771),24,mass2set(:,31),G0tensor(990),M2L1R1,G0tensor(1199),G0tensor(1113))
call TI_bubble_red(G1tensor(461),20,mass2set(:,32),G0tensor(1107),M2L1R1,G0tensor(1209),G0tensor(1108))
call TI_bubble_red(G1tensor(761),24,mass2set(:,25),G0tensor(1132),M2L1R1,G0tensor(437))
call TI_bubble_red(G1tensor(981),20,mass2set(:,31),G0tensor(553),M2L1R1,G0tensor(823),G0tensor(1432))
call TI_bubble_red(G1tensor(851),18,mass2set(:,33),G0tensor(1437),M2L1R1,G0tensor(588),G0tensor(598))
call TI_bubble_red(G1tensor(956),20,mass2set(:,29),G0tensor(137),M2L1R1,G0tensor(1208),G0tensor(1233))
call TI_bubble_red(G1tensor(876),18,mass2set(:,34),G0tensor(147),M2L1R1,G0tensor(227),G0tensor(237))
call TI_bubble_red(G1tensor(871),18,mass2set(:,35),G0tensor(523),M2L1R1,G0tensor(217),G0tensor(405))
call TI_bubble_red(G1tensor(976),20,mass2set(:,27),G0tensor(552),M2L1R1,G0tensor(1124),G0tensor(1138))



end subroutine vamp_10

end module ol_vamp_10_ppttj_ew_ttxbbxg_3_/**/REALKIND
