
module ol_vamp_3_ppttj_ew_ttxbbxg_3_/**/REALKIND
contains

! **********************************************************************
subroutine vamp_3(M)
! P(0:3,nlegs) = incoming external momenta
! Uses tree structures 'wf', factors 'c', and denominators 'den' from loop_ppttj_ew_ttxbbxg_3.
! Sets colour stripped amplitudes A from the module loop_amplitudes_ppttj_ew_ttxbbxg_3.
! **********************************************************************
  use KIND_TYPES, only: REALKIND, QREALKIND, intkind2
  use ol_parameters_decl_/**/DREALKIND, only: l_switch
  use ol_parameters_decl_/**/QREALKIND ! masses
  use ol_vert_interface_/**/REALKIND
  use ol_prop_interface_/**/REALKIND
  use ol_last_step_/**/REALKIND
  use ol_tables_storage_ppttj_ew_ttxbbxg_3_/**/DREALKIND
  use ol_tensor_sum_storage_ppttj_ew_ttxbbxg_3_/**/REALKIND
  use ol_loop_handling_/**/REALKIND
  use ofred_reduction_/**/REALKIND, only: Hotf_4pt_reduction, Hotf_4pt_reduction_last
  use ofred_reduction_/**/REALKIND, only: Hotf_5pt_reduction, Hotf_5pt_reduction_last
  use ol_loop_reduction_/**/REALKIND, only: TI_bubble_red, TI_triangle_red
use ol_loop_reduction_/**/REALKIND, only: compute_scalar_box

  use ol_loop_storage_ppttj_ew_ttxbbxg_3_/**/REALKIND
#ifndef PRECISION_dp
  use ol_loop_storage_ppttj_ew_ttxbbxg_3_/**/DREALKIND, only: &
    & p_switch, Hel, merge_step, merge_mism, merge_tables, merge_hels, ntryL
#endif
  use hol_initialisation_/**/REALKIND, only: G0_hol_initialisation
  use ol_h_vert_interface_/**/REALKIND
  use ol_h_prop_interface_/**/REALKIND
  use ol_h_last_step_/**/REALKIND
  use ol_merging_/**/REALKIND, only: ol_merge, ol_merge_tensors, ol_merge_last

  implicit none

  type(Hpolcont) :: Gcoeff(32)
  type(Hpolcont), intent(in) :: M(8,32)


#ifndef PRECISION_dp
  if (ntryL==1 .OR. p_switch == 1) Gcoeff(:)%hf = Hel
#else
  if (ntryL==1 .OR. p_switch == 2) Gcoeff(:)%hf = Hel
#endif

  ! =============================================
  call Hloop_WQ_A(ntryL,G0H32(1),wf4(:,5),G0H8(77),m3h4x8(:,208),heltab2x32(:,:,714))
  call Hloop_Q_A(ntryL,G0H8(77),20,nMT,G1H8(131),n2h8(156))
  Gcoeff(:)%j = (c(103)*M(4,:)%j-c(104)*M(7,:)%j) * den(5)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(715),h0tab(:,715),[20,2,1,8],[nMB,nMW,nMB,0],4,1,wf4(:,5))
  call Hloop_VQ_A(ntryL,G0H32(1),wf4(:,5),G0H8(77),m3h4x8(:,209),heltab2x32(:,:,715))
  call Hloop_Q_A(ntryL,G0H8(77),20,nMB,G1H8(132),n2h8(157))
  Gcoeff(:)%j = (-(c(98)*M(3,:)%j)) * den(5)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(716),h0tab(:,716),[20,2,1,8],[nMT,0,nMT,nMW],4,1,wf4(:,5))
  call Hloop_SQ_A(ntryL,G0H32(1),wf4(:,5),G0H8(77),ngPtb,m3h4x8(:,210),heltab2x32(:,:,716))
  call Hloop_Q_A(ntryL,G0H8(77),20,nMT,G1H8(133),n2h8(158))
  Gcoeff(:)%j = (-(c(100)*M(3,:)%j)) * den(5)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(717),h0tab(:,717),[20,2,1,8],[nMT,nMZ,nMT,nMW],4,1,wf4(:,5))
  call Hloop_SQ_A(ntryL,G0H32(1),wf4(:,5),G0H8(77),ngPtb,m3h4x8(:,211),heltab2x32(:,:,717))
  call Hloop_Q_A(ntryL,G0H8(77),20,nMT,G1H8(134),n2h8(159))
  Gcoeff(:)%j = (c(56)*M(3,:)%j) * den(5)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(718),h0tab(:,718),[20,2,1,8],[nMB,nMW,nMB,nMH],4,1,wf4(:,5))
  call Hloop_SQ_A(ntryL,G0H32(1),wf4(:,5),G0H8(77),ngH,m3h4x8(:,212),heltab2x32(:,:,718))
  call Hloop_Q_A(ntryL,G0H8(77),20,nMB,G1H8(135),n2h8(160))
  Gcoeff(:)%j = (-(c(56)*M(3,:)%j)) * den(5)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(719),h0tab(:,719),[20,2,1,8],[nMB,nMW,nMB,nMZ],4,1,wf4(:,5))
  call Hloop_SQ_A(ntryL,G0H32(1),wf4(:,5),G0H8(77),ngX,m3h4x8(:,213),heltab2x32(:,:,719))
  call Hloop_Q_A(ntryL,G0H8(77),20,nMB,G1H8(136),n2h8(161))
  Gcoeff(:)%j = (c(103)*M(4,:)%j-c(104)*M(7,:)%j) * den(5)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(720),h0tab(:,720),[20,2,1,8],[nMT,0,nMT,nMW],4,1,wf4(:,5))
  call Hloop_SQ_A(ntryL,G0H32(1),wf4(:,5),G0H8(77),ngPtb,m3h4x8(:,214),heltab2x32(:,:,720))
  call Hloop_Q_A(ntryL,G0H8(77),20,nMT,G1H8(138),n2h8(162))
  Gcoeff(:)%j = (c(2)*M(8,:)%j) * den(5)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(721),h0tab(:,721),[20,2,1,8],[0,nMT,0,nMB],4,1,wf4(:,5))
  call Hloop_AQ_V(ntryL,G0H32(1),wf4(:,5),G0H8(77),m3h4x8(:,215),heltab2x32(:,:,721))
  Gcoeff(:)%j = (-(c(5)*M(8,:)%j)) * den(5)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(722),h0tab(:,722),[20,2,1,8],[nMZ,nMT,0,nMB],4,1,wf4(:,5))
  call Hloop_AQ_Z(ntryL,G0H32(1),wf4(:,5),G0H8(78),ngZd,m3h4x8(:,216),heltab2x32(:,:,722))
  Gcoeff(:)%j = (-(c(5)*M(8,:)%j)) * den(5)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(723),h0tab(:,723),[20,2,1,8],[0,nMT,nMZ,nMB],4,1,wf4(:,5))
  call Hloop_AQ_V(ntryL,G0H32(1),wf4(:,5),G0H8(79),m3h4x8(:,217),heltab2x32(:,:,723))
  Gcoeff(:)%j = (c(7)*M(8,:)%j) * den(5)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(724),h0tab(:,724),[20,2,1,8],[nMZ,nMT,nMZ,nMB],4,1,wf4(:,5))
  call Hloop_AQ_Z(ntryL,G0H32(1),wf4(:,5),G0H8(80),ngZd,m3h4x8(:,218),heltab2x32(:,:,724))
  Gcoeff(:)%j = (-(c(18)*M(4,:)%j)+c(17)*M(7,:)%j) * den(5)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(725),h0tab(:,725),[20,2,1,8],[0,nMT,0,nMB],4,1,wf4(:,5))
  call Hloop_AQ_V(ntryL,G0H32(1),wf4(:,5),G0H8(81),m3h4x8(:,219),heltab2x32(:,:,725))
  Gcoeff(:)%j = (-(c(18)*M(4,:)%j)+c(17)*M(7,:)%j) * den(5)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(726),h0tab(:,726),[20,2,1,8],[0,nMT,0,nMB],4,1,wf4(:,5))
  call Hloop_AQ_V(ntryL,G0H32(1),wf4(:,5),G0H8(82),m3h4x8(:,220),heltab2x32(:,:,726))
  Gcoeff(:)%j = (c(23)*M(4,:)%j-c(22)*M(7,:)%j) * den(5)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(727),h0tab(:,727),[20,2,1,8],[0,nMT,nMZ,nMB],4,1,wf4(:,5))
  call Hloop_AQ_V(ntryL,G0H32(1),wf4(:,5),G0H8(83),m3h4x8(:,221),heltab2x32(:,:,727))
  Gcoeff(:)%j = (c(23)*M(4,:)%j-c(22)*M(7,:)%j) * den(5)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(728),h0tab(:,728),[20,2,1,8],[nMZ,nMT,0,nMB],4,1,wf4(:,5))
  call Hloop_AQ_Z(ntryL,G0H32(1),wf4(:,5),G0H8(84),ngZd,m3h4x8(:,222),heltab2x32(:,:,728))
  Gcoeff(:)%j = (-(c(79)*M(3,:)%j)) * den(5)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(729),h0tab(:,729),[20,2,1,8],[nMT,0,nMT,nMW],4,1,wf4(:,5))
  call Hloop_WQ_A(ntryL,G0H32(1),wf4(:,5),G0H8(85),m3h4x8(:,223),heltab2x32(:,:,729))
  call Hloop_Q_A(ntryL,G0H8(85),20,nMT,G1H8(139),n2h8(163))
  Gcoeff(:)%j = (-(c(76)*M(3,:)%j)) * den(5)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(730),h0tab(:,730),[20,2,1,8],[nMB,nMW,nMB,0],4,1,wf4(:,5))
  call Hloop_VQ_A(ntryL,G0H32(1),wf4(:,5),G0H8(85),m3h4x8(:,224),heltab2x32(:,:,730))
  call Hloop_Q_A(ntryL,G0H8(85),20,nMB,G1H8(140),n2h8(164))
  Gcoeff(:)%j = (-(c(81)*M(3,:)%j)) * den(5)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(731),h0tab(:,731),[20,2,1,8],[nMT,nMZ,nMT,nMW],4,1,wf4(:,5))
  call Hloop_WQ_A(ntryL,G0H32(1),wf4(:,5),G0H8(85),m3h4x8(:,225),heltab2x32(:,:,731))
  call Hloop_Q_A(ntryL,G0H8(85),20,nMT,G1H8(141),n2h8(165))
  Gcoeff(:)%j = (-(c(81)*M(3,:)%j)) * den(5)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(732),h0tab(:,732),[20,2,1,8],[nMB,nMW,nMB,nMZ],4,1,wf4(:,5))
  call Hloop_ZQ_A(ntryL,G0H32(1),wf4(:,5),G0H8(85),ngZd,m3h4x8(:,226),heltab2x32(:,:,732))
  call Hloop_Q_A(ntryL,G0H8(85),20,nMB,G1H8(142),n2h8(166))
  Gcoeff(:)%j = (c(86)*M(4,:)%j-c(87)*M(7,:)%j) * den(5)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(733),h0tab(:,733),[20,2,1,8],[nMT,0,nMT,nMW],4,1,wf4(:,5))
  call Hloop_WQ_A(ntryL,G0H32(1),wf4(:,5),G0H8(85),m3h4x8(:,227),heltab2x32(:,:,733))
  call Hloop_Q_A(ntryL,G0H8(85),20,nMT,G1H8(143),n2h8(167))
  Gcoeff(:)%j = (c(86)*M(4,:)%j-c(87)*M(7,:)%j) * den(5)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(734),h0tab(:,734),[20,2,1,8],[nMB,nMW,nMB,0],4,1,wf4(:,5))
  call Hloop_VQ_A(ntryL,G0H32(1),wf4(:,5),G0H8(85),m3h4x8(:,228),heltab2x32(:,:,734))
  call Hloop_Q_A(ntryL,G0H8(85),20,nMB,G1H8(144),n2h8(168))
  Gcoeff(:)%j = (c(49)*M(8,:)%j) * den(5)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(735),h0tab(:,735),[20,1,2,8],[nMH,nMT,nMH,nMB],4,1,wf4(:,5))
  call Hloop_AQ_S(ntryL,G0H32(1),wf4(:,5),G0H8(85),ngH,m3h4x8(:,229),heltab2x32(:,:,735))
  Gcoeff(:)%j = (c(49)*M(8,:)%j) * den(5)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(736),h0tab(:,736),[20,1,2,8],[nMH,nMT,nMZ,nMB],4,1,wf4(:,5))
  call Hloop_AQ_S(ntryL,G0H32(1),wf4(:,5),G0H8(86),ngH,m3h4x8(:,230),heltab2x32(:,:,736))
  Gcoeff(:)%j = (c(49)*M(8,:)%j) * den(5)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(737),h0tab(:,737),[20,1,2,8],[nMZ,nMT,nMH,nMB],4,1,wf4(:,5))
  call Hloop_AQ_S(ntryL,G0H32(1),wf4(:,5),G0H8(87),ngX,m3h4x8(:,231),heltab2x32(:,:,737))
  Gcoeff(:)%j = (c(49)*M(8,:)%j) * den(5)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(738),h0tab(:,738),[20,1,2,8],[nMZ,nMT,nMZ,nMB],4,1,wf4(:,5))
  call Hloop_AQ_S(ntryL,G0H32(1),wf4(:,5),G0H8(88),ngX,m3h4x8(:,232),heltab2x32(:,:,738))
  Gcoeff(:)%j = (c(36)*M(8,:)%j) * den(5)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(739),h0tab(:,739),[20,1,2,8],[nMW,nMB,nMW,nMT],4,1,wf4(:,5))
  call Hloop_AQ_S(ntryL,G0H32(1),wf4(:,5),G0H8(89),ngPtb,m3h4x8(:,233),heltab2x32(:,:,739))
  Gcoeff(:)%j = (c(113)*M(8,:)%j) * den(5)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(740),h0tab(:,740),[20,1,2,8],[nMH,nMT,0,nMB],4,1,wf4(:,5))
  call Hloop_AQ_S(ntryL,G0H32(1),wf4(:,5),G0H8(90),ngH,m3h4x8(:,234),heltab2x32(:,:,740))
  Gcoeff(:)%j = (c(113)*M(8,:)%j) * den(5)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(741),h0tab(:,741),[20,1,2,8],[nMZ,nMT,0,nMB],4,1,wf4(:,5))
  call Hloop_AQ_S(ntryL,G0H32(1),wf4(:,5),G0H8(91),ngX,m3h4x8(:,235),heltab2x32(:,:,741))
  Gcoeff(:)%j = (-(c(115)*M(8,:)%j)) * den(5)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(742),h0tab(:,742),[20,1,2,8],[nMH,nMT,nMZ,nMB],4,1,wf4(:,5))
  call Hloop_AQ_S(ntryL,G0H32(1),wf4(:,5),G0H8(92),ngH,m3h4x8(:,236),heltab2x32(:,:,742))
  Gcoeff(:)%j = (-(c(115)*M(8,:)%j)) * den(5)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(743),h0tab(:,743),[20,1,2,8],[nMZ,nMT,nMZ,nMB],4,1,wf4(:,5))
  call Hloop_AQ_S(ntryL,G0H32(1),wf4(:,5),G0H8(93),ngX,m3h4x8(:,237),heltab2x32(:,:,743))
  Gcoeff(:)%j = (c(54)*M(8,:)%j) * den(5)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(744),h0tab(:,744),[20,1,2,8],[nMW,nMB,nMW,nMT],4,1,wf4(:,5))
  call Hloop_AQ_S(ntryL,G0H32(1),wf4(:,5),G0H8(94),ngPtb,m3h4x8(:,238),heltab2x32(:,:,744))
  Gcoeff(:)%j = (-(c(119)*M(4,:)%j)+c(118)*M(7,:)%j) * den(5)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(745),h0tab(:,745),[20,1,2,8],[nMH,nMT,0,nMB],4,1,wf4(:,5))
  call Hloop_AQ_S(ntryL,G0H32(1),wf4(:,5),G0H8(95),ngH,m3h4x8(:,239),heltab2x32(:,:,745))
  Gcoeff(:)%j = (-(c(119)*M(4,:)%j)+c(118)*M(7,:)%j) * den(5)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(746),h0tab(:,746),[20,1,2,8],[nMZ,nMT,0,nMB],4,1,wf4(:,5))
  call Hloop_AQ_S(ntryL,G0H32(1),wf4(:,5),G0H8(96),ngX,m3h4x8(:,240),heltab2x32(:,:,746))
  Gcoeff(:)%j = (c(113)*M(8,:)%j) * den(5)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(747),h0tab(:,747),[20,1,2,8],[0,nMT,nMH,nMB],4,1,wf4(:,5))
  call Hloop_AQ_V(ntryL,G0H32(1),wf4(:,5),G0H8(97),m3h4x8(:,241),heltab2x32(:,:,747))
  Gcoeff(:)%j = (c(113)*M(8,:)%j) * den(5)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(748),h0tab(:,748),[20,1,2,8],[0,nMT,nMZ,nMB],4,1,wf4(:,5))
  call Hloop_AQ_V(ntryL,G0H32(1),wf4(:,5),G0H8(98),m3h4x8(:,242),heltab2x32(:,:,748))
  Gcoeff(:)%j = (-(c(115)*M(8,:)%j)) * den(5)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(749),h0tab(:,749),[20,1,2,8],[nMZ,nMT,nMH,nMB],4,1,wf4(:,5))
  call Hloop_AQ_Z(ntryL,G0H32(1),wf4(:,5),G0H8(99),ngZd,m3h4x8(:,243),heltab2x32(:,:,749))
  Gcoeff(:)%j = (-(c(115)*M(8,:)%j)) * den(5)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(750),h0tab(:,750),[20,1,2,8],[nMZ,nMT,nMZ,nMB],4,1,wf4(:,5))
  call Hloop_AQ_Z(ntryL,G0H32(1),wf4(:,5),G0H8(100),ngZd,m3h4x8(:,244),heltab2x32(:,:,750))
  Gcoeff(:)%j = (c(54)*M(8,:)%j) * den(5)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(751),h0tab(:,751),[20,1,2,8],[nMW,nMB,nMW,nMT],4,1,wf4(:,5))
  call Hloop_AQ_W(ntryL,G0H32(1),wf4(:,5),G0H8(101),m3h4x8(:,245),heltab2x32(:,:,751))
  Gcoeff(:)%j = (-(c(119)*M(4,:)%j)+c(118)*M(7,:)%j) * den(5)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(752),h0tab(:,752),[20,1,2,8],[0,nMT,nMH,nMB],4,1,wf4(:,5))
  call Hloop_AQ_V(ntryL,G0H32(1),wf4(:,5),G0H8(102),m3h4x8(:,246),heltab2x32(:,:,752))
  Gcoeff(:)%j = (-(c(119)*M(4,:)%j)+c(118)*M(7,:)%j) * den(5)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(753),h0tab(:,753),[20,1,2,8],[0,nMT,nMZ,nMB],4,1,wf4(:,5))
  call Hloop_AQ_V(ntryL,G0H32(1),wf4(:,5),G0H8(103),m3h4x8(:,247),heltab2x32(:,:,753))
  Gcoeff(:)%j = (c(2)*M(8,:)%j) * den(5)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(754),h0tab(:,754),[20,1,2,8],[0,nMT,0,nMB],4,1,wf4(:,5))
  call Hloop_AQ_V(ntryL,G0H32(1),wf4(:,5),G0H8(104),m3h4x8(:,248),heltab2x32(:,:,754))
  Gcoeff(:)%j = (-(c(5)*M(8,:)%j)) * den(5)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(755),h0tab(:,755),[20,1,2,8],[0,nMT,nMZ,nMB],4,1,wf4(:,5))
  call Hloop_AQ_V(ntryL,G0H32(1),wf4(:,5),G0H8(105),m3h4x8(:,249),heltab2x32(:,:,755))
  Gcoeff(:)%j = (-(c(5)*M(8,:)%j)) * den(5)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(756),h0tab(:,756),[20,1,2,8],[nMZ,nMT,0,nMB],4,1,wf4(:,5))
  call Hloop_AQ_Z(ntryL,G0H32(1),wf4(:,5),G0H8(106),ngZd,m3h4x8(:,250),heltab2x32(:,:,756))
  Gcoeff(:)%j = (c(7)*M(8,:)%j) * den(5)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(757),h0tab(:,757),[20,1,2,8],[nMZ,nMT,nMZ,nMB],4,1,wf4(:,5))
  call Hloop_AQ_Z(ntryL,G0H32(1),wf4(:,5),G0H8(107),ngZd,m3h4x8(:,251),heltab2x32(:,:,757))
  Gcoeff(:)%j = (c(28)*M(8,:)%j) * den(5)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(758),h0tab(:,758),[20,1,2,8],[nMW,nMB,nMW,nMT],4,1,wf4(:,5))
  call Hloop_AQ_W(ntryL,G0H32(1),wf4(:,5),G0H8(108),m3h4x8(:,252),heltab2x32(:,:,758))
  Gcoeff(:)%j = (-(c(18)*M(4,:)%j)+c(17)*M(7,:)%j) * den(5)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(759),h0tab(:,759),[20,1,2,8],[0,nMT,0,nMB],4,1,wf4(:,5))
  call Hloop_AQ_V(ntryL,G0H32(1),wf4(:,5),G0H8(109),m3h4x8(:,253),heltab2x32(:,:,759))
  Gcoeff(:)%j = (-(c(18)*M(4,:)%j)+c(17)*M(7,:)%j) * den(5)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(760),h0tab(:,760),[20,1,2,8],[0,nMT,0,nMB],4,1,wf4(:,5))
  call Hloop_AQ_V(ntryL,G0H32(1),wf4(:,5),G0H8(110),m3h4x8(:,254),heltab2x32(:,:,760))
  Gcoeff(:)%j = (c(23)*M(4,:)%j-c(22)*M(7,:)%j) * den(5)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(761),h0tab(:,761),[20,1,2,8],[nMZ,nMT,0,nMB],4,1,wf4(:,5))
  call Hloop_AQ_Z(ntryL,G0H32(1),wf4(:,5),G0H8(111),ngZd,m3h4x8(:,255),heltab2x32(:,:,761))
  Gcoeff(:)%j = (c(23)*M(4,:)%j-c(22)*M(7,:)%j) * den(5)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(762),h0tab(:,762),[20,1,2,8],[0,nMT,nMZ,nMB],4,1,wf4(:,5))
  call Hloop_AQ_V(ntryL,G0H32(1),wf4(:,5),G0H8(112),m3h4x8(:,256),heltab2x32(:,:,762))
  Gcoeff(:)%j = (c(40)*M(3,:)%j) * den(5)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(763),h0tab(:,763),[20,1,8,2],[nMH,nMT,nMW,nMB],4,1,wf4(:,5))
  call Hloop_AQ_S(ntryL,G0H32(1),wf4(:,5),G0H8(113),ngH,m3h4x8(:,257),heltab2x32(:,:,763))
  Gcoeff(:)%j = (c(40)*M(3,:)%j) * den(5)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(764),h0tab(:,764),[20,1,8,2],[nMW,nMB,nMH,nMT],4,1,wf4(:,5))
  call Hloop_AQ_S(ntryL,G0H32(1),wf4(:,5),G0H8(114),ngPtb,m3h4x8(:,258),heltab2x32(:,:,764))
  Gcoeff(:)%j = (c(40)*M(3,:)%j) * den(5)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(765),h0tab(:,765),[20,1,8,2],[nMZ,nMT,nMW,nMB],4,1,wf4(:,5))
  call Hloop_AQ_S(ntryL,G0H32(1),wf4(:,5),G0H8(115),ngX,m3h4x8(:,259),heltab2x32(:,:,765))
  Gcoeff(:)%j = (c(40)*M(3,:)%j) * den(5)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(766),h0tab(:,766),[20,1,8,2],[nMW,nMB,nMZ,nMT],4,1,wf4(:,5))
  call Hloop_AQ_S(ntryL,G0H32(1),wf4(:,5),G0H8(116),ngPtb,m3h4x8(:,260),heltab2x32(:,:,766))
  Gcoeff(:)%j = (c(96)*M(3,:)%j) * den(5)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(767),h0tab(:,767),[20,1,8,2],[nMW,nMB,0,nMT],4,1,wf4(:,5))
  call Hloop_AQ_S(ntryL,G0H32(1),wf4(:,5),G0H8(117),ngPtb,m3h4x8(:,261),heltab2x32(:,:,767))
  Gcoeff(:)%j = (-(c(100)*M(3,:)%j)) * den(5)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(768),h0tab(:,768),[20,1,8,2],[nMW,nMB,nMZ,nMT],4,1,wf4(:,5))
  call Hloop_AQ_S(ntryL,G0H32(1),wf4(:,5),G0H8(118),ngPtb,m3h4x8(:,262),heltab2x32(:,:,768))
  Gcoeff(:)%j = (c(60)*M(3,:)%j) * den(5)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(769),h0tab(:,769),[20,1,8,2],[nMH,nMT,nMW,nMB],4,1,wf4(:,5))
  call Hloop_AQ_S(ntryL,G0H32(1),wf4(:,5),G0H8(119),ngH,m3h4x8(:,263),heltab2x32(:,:,769))
  Gcoeff(:)%j = (c(60)*M(3,:)%j) * den(5)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(770),h0tab(:,770),[20,1,8,2],[nMZ,nMT,nMW,nMB],4,1,wf4(:,5))
  call Hloop_AQ_S(ntryL,G0H32(1),wf4(:,5),G0H8(120),ngX,m3h4x8(:,264),heltab2x32(:,:,770))
  Gcoeff(:)%j = (c(103)*M(4,:)%j-c(104)*M(7,:)%j) * den(5)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(771),h0tab(:,771),[20,1,8,2],[nMW,nMB,0,nMT],4,1,wf4(:,5))
  call Hloop_AQ_S(ntryL,G0H32(1),wf4(:,5),G0H8(121),ngPtb,m3h4x8(:,265),heltab2x32(:,:,771))
  Gcoeff(:)%j = (c(96)*M(3,:)%j) * den(5)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(772),h0tab(:,772),[20,1,8,2],[0,nMT,nMW,nMB],4,1,wf4(:,5))
  call Hloop_AQ_V(ntryL,G0H32(1),wf4(:,5),G0H8(122),m3h4x8(:,266),heltab2x32(:,:,772))
  Gcoeff(:)%j = (-(c(100)*M(3,:)%j)) * den(5)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(773),h0tab(:,773),[20,1,8,2],[nMZ,nMT,nMW,nMB],4,1,wf4(:,5))
  call Hloop_AQ_Z(ntryL,G0H32(1),wf4(:,5),G0H8(123),ngZd,m3h4x8(:,267),heltab2x32(:,:,773))
  Gcoeff(:)%j = (c(60)*M(3,:)%j) * den(5)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(774),h0tab(:,774),[20,1,8,2],[nMW,nMB,nMH,nMT],4,1,wf4(:,5))
  call Hloop_AQ_W(ntryL,G0H32(1),wf4(:,5),G0H8(124),m3h4x8(:,268),heltab2x32(:,:,774))
  Gcoeff(:)%j = (c(60)*M(3,:)%j) * den(5)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(775),h0tab(:,775),[20,1,8,2],[nMW,nMB,nMZ,nMT],4,1,wf4(:,5))
  call Hloop_AQ_W(ntryL,G0H32(1),wf4(:,5),G0H8(125),m3h4x8(:,269),heltab2x32(:,:,775))
  Gcoeff(:)%j = (c(103)*M(4,:)%j-c(104)*M(7,:)%j) * den(5)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(776),h0tab(:,776),[20,1,8,2],[0,nMT,nMW,nMB],4,1,wf4(:,5))
  call Hloop_AQ_V(ntryL,G0H32(1),wf4(:,5),G0H8(126),m3h4x8(:,270),heltab2x32(:,:,776))
  Gcoeff(:)%j = (c(77)*M(3,:)%j) * den(5)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(777),h0tab(:,777),[20,1,8,2],[0,nMT,nMW,nMB],4,1,wf4(:,5))
  call Hloop_AQ_V(ntryL,G0H32(1),wf4(:,5),G0H8(127),m3h4x8(:,271),heltab2x32(:,:,777))
  Gcoeff(:)%j = (c(77)*M(3,:)%j) * den(5)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(778),h0tab(:,778),[20,1,8,2],[nMW,nMB,0,nMT],4,1,wf4(:,5))
  call Hloop_AQ_W(ntryL,G0H32(1),wf4(:,5),G0H8(128),m3h4x8(:,272),heltab2x32(:,:,778))
  Gcoeff(:)%j = (-(c(81)*M(3,:)%j)) * den(5)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(779),h0tab(:,779),[20,1,8,2],[nMZ,nMT,nMW,nMB],4,1,wf4(:,5))
  call Hloop_AQ_Z(ntryL,G0H32(1),wf4(:,5),G0H8(129),ngZd,m3h4x8(:,273),heltab2x32(:,:,779))
  Gcoeff(:)%j = (-(c(81)*M(3,:)%j)) * den(5)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(780),h0tab(:,780),[20,1,8,2],[nMW,nMB,nMZ,nMT],4,1,wf4(:,5))
  call Hloop_AQ_W(ntryL,G0H32(1),wf4(:,5),G0H8(130),m3h4x8(:,274),heltab2x32(:,:,780))
  Gcoeff(:)%j = (c(86)*M(4,:)%j-c(87)*M(7,:)%j) * den(5)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(781),h0tab(:,781),[20,1,8,2],[0,nMT,nMW,nMB],4,1,wf4(:,5))
  call Hloop_AQ_V(ntryL,G0H32(1),wf4(:,5),G0H8(131),m3h4x8(:,275),heltab2x32(:,:,781))
  Gcoeff(:)%j = (c(86)*M(4,:)%j-c(87)*M(7,:)%j) * den(5)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(782),h0tab(:,782),[20,1,8,2],[nMW,nMB,0,nMT],4,1,wf4(:,5))
  call Hloop_AQ_W(ntryL,G0H32(1),wf4(:,5),G0H8(132),m3h4x8(:,276),heltab2x32(:,:,782))
  Gcoeff(:)%j = (c(49)*M(8,:)%j) * den(10)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(783),h0tab(:,783),[24,2,1,4],[nMH,nMT,nMH,nMB],4,1,wf4(:,9))
  call Hloop_QA_S(ntryL,G0H32(1),wf4(:,9),G0H8(133),ngH,m3h4x8(:,277),heltab2x32(:,:,783))
  Gcoeff(:)%j = (c(49)*M(8,:)%j) * den(10)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(784),h0tab(:,784),[24,2,1,4],[nMZ,nMT,nMH,nMB],4,1,wf4(:,9))
  call Hloop_QA_S(ntryL,G0H32(1),wf4(:,9),G0H8(134),ngX,m3h4x8(:,278),heltab2x32(:,:,784))
  Gcoeff(:)%j = (c(49)*M(8,:)%j) * den(10)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(785),h0tab(:,785),[24,2,1,4],[nMH,nMT,nMZ,nMB],4,1,wf4(:,9))
  call Hloop_QA_S(ntryL,G0H32(1),wf4(:,9),G0H8(135),ngH,m3h4x8(:,279),heltab2x32(:,:,785))
  Gcoeff(:)%j = (c(49)*M(8,:)%j) * den(10)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(786),h0tab(:,786),[24,2,1,4],[nMZ,nMT,nMZ,nMB],4,1,wf4(:,9))
  call Hloop_QA_S(ntryL,G0H32(1),wf4(:,9),G0H8(136),ngX,m3h4x8(:,280),heltab2x32(:,:,786))
  Gcoeff(:)%j = (c(36)*M(8,:)%j) * den(10)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(787),h0tab(:,787),[24,2,1,4],[nMW,nMB,nMW,nMT],4,1,wf4(:,9))
  call Hloop_QA_S(ntryL,G0H32(1),wf4(:,9),G0H8(137),ngPbt,m3h4x8(:,281),heltab2x32(:,:,787))
  Gcoeff(:)%j = (c(113)*M(8,:)%j) * den(10)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(788),h0tab(:,788),[24,2,1,4],[0,nMT,nMH,nMB],4,1,wf4(:,9))
  call Hloop_QA_V(ntryL,G0H32(1),wf4(:,9),G0H8(138),m3h4x8(:,282),heltab2x32(:,:,788))
  Gcoeff(:)%j = (c(113)*M(8,:)%j) * den(10)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(789),h0tab(:,789),[24,2,1,4],[0,nMT,nMZ,nMB],4,1,wf4(:,9))
  call Hloop_QA_V(ntryL,G0H32(1),wf4(:,9),G0H8(139),m3h4x8(:,283),heltab2x32(:,:,789))
  Gcoeff(:)%j = (-(c(115)*M(8,:)%j)) * den(10)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(790),h0tab(:,790),[24,2,1,4],[nMZ,nMT,nMH,nMB],4,1,wf4(:,9))
  call Hloop_QA_Z(ntryL,G0H32(1),wf4(:,9),G0H8(140),ngZd,m3h4x8(:,284),heltab2x32(:,:,790))
  Gcoeff(:)%j = (-(c(115)*M(8,:)%j)) * den(10)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(791),h0tab(:,791),[24,2,1,4],[nMZ,nMT,nMZ,nMB],4,1,wf4(:,9))
  call Hloop_QA_Z(ntryL,G0H32(1),wf4(:,9),G0H8(141),ngZd,m3h4x8(:,285),heltab2x32(:,:,791))
  Gcoeff(:)%j = (c(54)*M(8,:)%j) * den(10)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(792),h0tab(:,792),[24,2,1,4],[nMW,nMB,nMW,nMT],4,1,wf4(:,9))
  call Hloop_QA_W(ntryL,G0H32(1),wf4(:,9),G0H8(142),m3h4x8(:,286),heltab2x32(:,:,792))
  Gcoeff(:)%j = (-(c(119)*M(6,:)%j)+c(118)*M(7,:)%j) * den(10)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(793),h0tab(:,793),[24,2,1,4],[0,nMT,nMH,nMB],4,1,wf4(:,9))
  call Hloop_QA_V(ntryL,G0H32(1),wf4(:,9),G0H8(143),m3h4x8(:,287),heltab2x32(:,:,793))
  Gcoeff(:)%j = (-(c(119)*M(6,:)%j)+c(118)*M(7,:)%j) * den(10)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(794),h0tab(:,794),[24,2,1,4],[0,nMT,nMZ,nMB],4,1,wf4(:,9))
  call Hloop_QA_V(ntryL,G0H32(1),wf4(:,9),G0H8(144),m3h4x8(:,288),heltab2x32(:,:,794))
  Gcoeff(:)%j = (c(113)*M(8,:)%j) * den(10)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(795),h0tab(:,795),[24,2,1,4],[nMH,nMT,0,nMB],4,1,wf4(:,9))
  call Hloop_QA_S(ntryL,G0H32(1),wf4(:,9),G0H8(145),ngH,m3h4x8(:,289),heltab2x32(:,:,795))
  Gcoeff(:)%j = (c(113)*M(8,:)%j) * den(10)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(796),h0tab(:,796),[24,2,1,4],[nMZ,nMT,0,nMB],4,1,wf4(:,9))
  call Hloop_QA_S(ntryL,G0H32(1),wf4(:,9),G0H8(146),ngX,m3h4x8(:,290),heltab2x32(:,:,796))
  Gcoeff(:)%j = (-(c(115)*M(8,:)%j)) * den(10)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(797),h0tab(:,797),[24,2,1,4],[nMH,nMT,nMZ,nMB],4,1,wf4(:,9))
  call Hloop_QA_S(ntryL,G0H32(1),wf4(:,9),G0H8(147),ngH,m3h4x8(:,291),heltab2x32(:,:,797))
  Gcoeff(:)%j = (-(c(115)*M(8,:)%j)) * den(10)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(798),h0tab(:,798),[24,2,1,4],[nMZ,nMT,nMZ,nMB],4,1,wf4(:,9))
  call Hloop_QA_S(ntryL,G0H32(1),wf4(:,9),G0H8(148),ngX,m3h4x8(:,292),heltab2x32(:,:,798))
  Gcoeff(:)%j = (c(54)*M(8,:)%j) * den(10)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(799),h0tab(:,799),[24,2,1,4],[nMW,nMB,nMW,nMT],4,1,wf4(:,9))
  call Hloop_QA_S(ntryL,G0H32(1),wf4(:,9),G0H8(149),ngPbt,m3h4x8(:,293),heltab2x32(:,:,799))
  Gcoeff(:)%j = (-(c(119)*M(6,:)%j)+c(118)*M(7,:)%j) * den(10)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(800),h0tab(:,800),[24,2,1,4],[nMH,nMT,0,nMB],4,1,wf4(:,9))
  call Hloop_QA_S(ntryL,G0H32(1),wf4(:,9),G0H8(150),ngH,m3h4x8(:,294),heltab2x32(:,:,800))
  Gcoeff(:)%j = (-(c(119)*M(6,:)%j)+c(118)*M(7,:)%j) * den(10)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(801),h0tab(:,801),[24,2,1,4],[nMZ,nMT,0,nMB],4,1,wf4(:,9))
  call Hloop_QA_S(ntryL,G0H32(1),wf4(:,9),G0H8(151),ngX,m3h4x8(:,295),heltab2x32(:,:,801))
  Gcoeff(:)%j = (c(2)*M(8,:)%j) * den(10)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(802),h0tab(:,802),[24,2,1,4],[0,nMT,0,nMB],4,1,wf4(:,9))
  call Hloop_QA_V(ntryL,G0H32(1),wf4(:,9),G0H8(152),m3h4x8(:,296),heltab2x32(:,:,802))
  Gcoeff(:)%j = (-(c(5)*M(8,:)%j)) * den(10)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(803),h0tab(:,803),[24,2,1,4],[nMZ,nMT,0,nMB],4,1,wf4(:,9))
  call Hloop_QA_Z(ntryL,G0H32(1),wf4(:,9),G0H8(153),ngZd,m3h4x8(:,297),heltab2x32(:,:,803))
  Gcoeff(:)%j = (-(c(5)*M(8,:)%j)) * den(10)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(804),h0tab(:,804),[24,2,1,4],[0,nMT,nMZ,nMB],4,1,wf4(:,9))
  call Hloop_QA_V(ntryL,G0H32(1),wf4(:,9),G0H8(154),m3h4x8(:,298),heltab2x32(:,:,804))
  Gcoeff(:)%j = (c(7)*M(8,:)%j) * den(10)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(805),h0tab(:,805),[24,2,1,4],[nMZ,nMT,nMZ,nMB],4,1,wf4(:,9))
  call Hloop_QA_Z(ntryL,G0H32(1),wf4(:,9),G0H8(155),ngZd,m3h4x8(:,299),heltab2x32(:,:,805))
  Gcoeff(:)%j = (c(28)*M(8,:)%j) * den(10)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(806),h0tab(:,806),[24,2,1,4],[nMW,nMB,nMW,nMT],4,1,wf4(:,9))
  call Hloop_QA_W(ntryL,G0H32(1),wf4(:,9),G0H8(156),m3h4x8(:,300),heltab2x32(:,:,806))
  Gcoeff(:)%j = (-(c(18)*M(6,:)%j)+c(17)*M(7,:)%j) * den(10)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(807),h0tab(:,807),[24,2,1,4],[0,nMT,0,nMB],4,1,wf4(:,9))
  call Hloop_QA_V(ntryL,G0H32(1),wf4(:,9),G0H8(157),m3h4x8(:,301),heltab2x32(:,:,807))
  Gcoeff(:)%j = (-(c(18)*M(6,:)%j)+c(17)*M(7,:)%j) * den(10)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(808),h0tab(:,808),[24,2,1,4],[0,nMT,0,nMB],4,1,wf4(:,9))
  call Hloop_QA_V(ntryL,G0H32(1),wf4(:,9),G0H8(158),m3h4x8(:,302),heltab2x32(:,:,808))
  Gcoeff(:)%j = (c(23)*M(6,:)%j-c(22)*M(7,:)%j) * den(10)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(809),h0tab(:,809),[24,2,1,4],[0,nMT,nMZ,nMB],4,1,wf4(:,9))
  call Hloop_QA_V(ntryL,G0H32(1),wf4(:,9),G0H8(159),m3h4x8(:,303),heltab2x32(:,:,809))
  Gcoeff(:)%j = (c(23)*M(6,:)%j-c(22)*M(7,:)%j) * den(10)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(810),h0tab(:,810),[24,2,1,4],[nMZ,nMT,0,nMB],4,1,wf4(:,9))
  call Hloop_QA_Z(ntryL,G0H32(1),wf4(:,9),G0H8(160),ngZd,m3h4x8(:,304),heltab2x32(:,:,810))
  Gcoeff(:)%j = (c(49)*M(8,:)%j) * den(10)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(811),h0tab(:,811),[24,1,2,4],[nMH,nMT,nMH,nMB],4,1,wf4(:,9))
  call Hloop_QA_S(ntryL,G0H32(1),wf4(:,9),G0H8(161),ngH,m3h4x8(:,305),heltab2x32(:,:,811))
  Gcoeff(:)%j = (c(49)*M(8,:)%j) * den(10)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(812),h0tab(:,812),[24,1,2,4],[nMH,nMT,nMZ,nMB],4,1,wf4(:,9))
  call Hloop_QA_S(ntryL,G0H32(1),wf4(:,9),G0H8(162),ngH,m3h4x8(:,306),heltab2x32(:,:,812))
  Gcoeff(:)%j = (c(49)*M(8,:)%j) * den(10)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(813),h0tab(:,813),[24,1,2,4],[nMZ,nMT,nMH,nMB],4,1,wf4(:,9))
  call Hloop_QA_S(ntryL,G0H32(1),wf4(:,9),G0H8(163),ngX,m3h4x8(:,307),heltab2x32(:,:,813))
  Gcoeff(:)%j = (c(49)*M(8,:)%j) * den(10)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(814),h0tab(:,814),[24,1,2,4],[nMZ,nMT,nMZ,nMB],4,1,wf4(:,9))
  call Hloop_QA_S(ntryL,G0H32(1),wf4(:,9),G0H8(164),ngX,m3h4x8(:,308),heltab2x32(:,:,814))
  Gcoeff(:)%j = (c(48)*M(5,:)%j) * den(10)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(815),h0tab(:,815),[24,1,2,4],[nMT,nMH,nMT,nMW],4,1,wf4(:,9))
  call Hloop_SA_Q(ntryL,G0H32(1),wf4(:,9),G0H8(165),ngPbt,m3h4x8(:,309),heltab2x32(:,:,815))
  call Hloop_A_Q(ntryL,G0H8(165),24,nMT,G1H8(145),n2h8(169))
  Gcoeff(:)%j = (c(37)*M(5,:)%j) * den(10)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(816),h0tab(:,816),[24,1,2,4],[nMB,nMW,nMB,nMH],4,1,wf4(:,9))
  call Hloop_SA_Q(ntryL,G0H32(1),wf4(:,9),G0H8(165),ngH,m3h4x8(:,310),heltab2x32(:,:,816))
  call Hloop_A_Q(ntryL,G0H8(165),24,nMB,G1H8(146),n2h8(170))
  Gcoeff(:)%j = (-(c(48)*M(5,:)%j)) * den(10)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(817),h0tab(:,817),[24,1,2,4],[nMT,nMZ,nMT,nMW],4,1,wf4(:,9))
  call Hloop_SA_Q(ntryL,G0H32(1),wf4(:,9),G0H8(165),ngPbt,m3h4x8(:,311),heltab2x32(:,:,817))
  call Hloop_A_Q(ntryL,G0H8(165),24,nMT,G1H8(147),n2h8(171))
  Gcoeff(:)%j = (-(c(37)*M(5,:)%j)) * den(10)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(818),h0tab(:,818),[24,1,2,4],[nMB,nMW,nMB,nMZ],4,1,wf4(:,9))
  call Hloop_SA_Q(ntryL,G0H32(1),wf4(:,9),G0H8(165),ngX,m3h4x8(:,312),heltab2x32(:,:,818))
  call Hloop_A_Q(ntryL,G0H8(165),24,nMB,G1H8(148),n2h8(172))
  Gcoeff(:)%j = (c(113)*M(8,:)%j) * den(10)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(819),h0tab(:,819),[24,1,2,4],[nMH,nMT,0,nMB],4,1,wf4(:,9))
  call Hloop_QA_S(ntryL,G0H32(1),wf4(:,9),G0H8(165),ngH,m3h4x8(:,313),heltab2x32(:,:,819))
  Gcoeff(:)%j = (c(113)*M(8,:)%j) * den(10)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(820),h0tab(:,820),[24,1,2,4],[nMZ,nMT,0,nMB],4,1,wf4(:,9))
  call Hloop_QA_S(ntryL,G0H32(1),wf4(:,9),G0H8(166),ngX,m3h4x8(:,314),heltab2x32(:,:,820))
  Gcoeff(:)%j = (-(c(115)*M(8,:)%j)) * den(10)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(821),h0tab(:,821),[24,1,2,4],[nMH,nMT,nMZ,nMB],4,1,wf4(:,9))
  call Hloop_QA_S(ntryL,G0H32(1),wf4(:,9),G0H8(167),ngH,m3h4x8(:,315),heltab2x32(:,:,821))
  Gcoeff(:)%j = (-(c(115)*M(8,:)%j)) * den(10)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(822),h0tab(:,822),[24,1,2,4],[nMZ,nMT,nMZ,nMB],4,1,wf4(:,9))
  call Hloop_QA_S(ntryL,G0H32(1),wf4(:,9),G0H8(168),ngX,m3h4x8(:,316),heltab2x32(:,:,822))
  Gcoeff(:)%j = (-(c(119)*M(6,:)%j)+c(118)*M(7,:)%j) * den(10)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(823),h0tab(:,823),[24,1,2,4],[nMH,nMT,0,nMB],4,1,wf4(:,9))
  call Hloop_QA_S(ntryL,G0H32(1),wf4(:,9),G0H8(169),ngH,m3h4x8(:,317),heltab2x32(:,:,823))
  Gcoeff(:)%j = (-(c(119)*M(6,:)%j)+c(118)*M(7,:)%j) * den(10)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(824),h0tab(:,824),[24,1,2,4],[nMZ,nMT,0,nMB],4,1,wf4(:,9))
  call Hloop_QA_S(ntryL,G0H32(1),wf4(:,9),G0H8(170),ngX,m3h4x8(:,318),heltab2x32(:,:,824))
  Gcoeff(:)%j = (c(113)*M(8,:)%j) * den(10)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(825),h0tab(:,825),[24,1,2,4],[0,nMT,nMH,nMB],4,1,wf4(:,9))
  call Hloop_QA_V(ntryL,G0H32(1),wf4(:,9),G0H8(171),m3h4x8(:,319),heltab2x32(:,:,825))
  Gcoeff(:)%j = (c(113)*M(8,:)%j) * den(10)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(826),h0tab(:,826),[24,1,2,4],[0,nMT,nMZ,nMB],4,1,wf4(:,9))
  call Hloop_QA_V(ntryL,G0H32(1),wf4(:,9),G0H8(172),m3h4x8(:,320),heltab2x32(:,:,826))
  Gcoeff(:)%j = (-(c(115)*M(8,:)%j)) * den(10)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(827),h0tab(:,827),[24,1,2,4],[nMZ,nMT,nMH,nMB],4,1,wf4(:,9))
  call Hloop_QA_Z(ntryL,G0H32(1),wf4(:,9),G0H8(173),ngZd,m3h4x8(:,321),heltab2x32(:,:,827))
  Gcoeff(:)%j = (-(c(115)*M(8,:)%j)) * den(10)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(828),h0tab(:,828),[24,1,2,4],[nMZ,nMT,nMZ,nMB],4,1,wf4(:,9))
  call Hloop_QA_Z(ntryL,G0H32(1),wf4(:,9),G0H8(174),ngZd,m3h4x8(:,322),heltab2x32(:,:,828))
  Gcoeff(:)%j = (-(c(119)*M(6,:)%j)+c(118)*M(7,:)%j) * den(10)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(829),h0tab(:,829),[24,1,2,4],[0,nMT,nMH,nMB],4,1,wf4(:,9))
  call Hloop_QA_V(ntryL,G0H32(1),wf4(:,9),G0H8(175),m3h4x8(:,323),heltab2x32(:,:,829))
  Gcoeff(:)%j = (-(c(119)*M(6,:)%j)+c(118)*M(7,:)%j) * den(10)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(830),h0tab(:,830),[24,1,2,4],[0,nMT,nMZ,nMB],4,1,wf4(:,9))
  call Hloop_QA_V(ntryL,G0H32(1),wf4(:,9),G0H8(176),m3h4x8(:,324),heltab2x32(:,:,830))
  Gcoeff(:)%j = (-(c(95)*M(5,:)%j)) * den(10)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(831),h0tab(:,831),[24,1,2,4],[nMB,nMW,nMB,0],4,1,wf4(:,9))
  call Hloop_VA_Q(ntryL,G0H32(1),wf4(:,9),G0H8(177),m3h4x8(:,325),heltab2x32(:,:,831))
  call Hloop_A_Q(ntryL,G0H8(177),24,nMB,G1H8(149),n2h8(173))
  Gcoeff(:)%j = (-(c(100)*M(5,:)%j)) * den(10)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(832),h0tab(:,832),[24,1,2,4],[nMB,nMW,nMB,nMZ],4,1,wf4(:,9))
  call Hloop_ZA_Q(ntryL,G0H32(1),wf4(:,9),G0H8(177),ngZd,m3h4x8(:,326),heltab2x32(:,:,832))
  call Hloop_A_Q(ntryL,G0H8(177),24,nMB,G1H8(150),n2h8(174))
  Gcoeff(:)%j = (c(62)*M(5,:)%j) * den(10)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(833),h0tab(:,833),[24,1,2,4],[nMT,nMH,nMT,nMW],4,1,wf4(:,9))
  call Hloop_WA_Q(ntryL,G0H32(1),wf4(:,9),G0H8(177),m3h4x8(:,327),heltab2x32(:,:,833))
  call Hloop_A_Q(ntryL,G0H8(177),24,nMT,G1H8(151),n2h8(175))
  Gcoeff(:)%j = (-(c(62)*M(5,:)%j)) * den(10)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(834),h0tab(:,834),[24,1,2,4],[nMT,nMZ,nMT,nMW],4,1,wf4(:,9))
  call Hloop_WA_Q(ntryL,G0H32(1),wf4(:,9),G0H8(177),m3h4x8(:,328),heltab2x32(:,:,834))
  call Hloop_A_Q(ntryL,G0H8(177),24,nMT,G1H8(152),n2h8(176))
  Gcoeff(:)%j = (c(103)*M(6,:)%j-c(104)*M(7,:)%j) * den(10)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(835),h0tab(:,835),[24,1,2,4],[nMB,nMW,nMB,0],4,1,wf4(:,9))
  call Hloop_VA_Q(ntryL,G0H32(1),wf4(:,9),G0H8(177),m3h4x8(:,329),heltab2x32(:,:,835))
  call Hloop_A_Q(ntryL,G0H8(177),24,nMB,G1H8(153),n2h8(177))
  Gcoeff(:)%j = (-(c(98)*M(5,:)%j)) * den(10)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(836),h0tab(:,836),[24,1,2,4],[nMT,0,nMT,nMW],4,1,wf4(:,9))
  call Hloop_SA_Q(ntryL,G0H32(1),wf4(:,9),G0H8(177),ngPbt,m3h4x8(:,330),heltab2x32(:,:,836))
  call Hloop_A_Q(ntryL,G0H8(177),24,nMT,G1H8(154),n2h8(178))
  Gcoeff(:)%j = (-(c(100)*M(5,:)%j)) * den(10)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(837),h0tab(:,837),[24,1,2,4],[nMT,nMZ,nMT,nMW],4,1,wf4(:,9))
  call Hloop_SA_Q(ntryL,G0H32(1),wf4(:,9),G0H8(177),ngPbt,m3h4x8(:,331),heltab2x32(:,:,837))
  call Hloop_A_Q(ntryL,G0H8(177),24,nMT,G1H8(155),n2h8(179))
  Gcoeff(:)%j = (c(56)*M(5,:)%j) * den(10)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(838),h0tab(:,838),[24,1,2,4],[nMB,nMW,nMB,nMH],4,1,wf4(:,9))
  call Hloop_SA_Q(ntryL,G0H32(1),wf4(:,9),G0H8(177),ngH,m3h4x8(:,332),heltab2x32(:,:,838))
  call Hloop_A_Q(ntryL,G0H8(177),24,nMB,G1H8(156),n2h8(180))
  Gcoeff(:)%j = (-(c(56)*M(5,:)%j)) * den(10)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(839),h0tab(:,839),[24,1,2,4],[nMB,nMW,nMB,nMZ],4,1,wf4(:,9))
  call Hloop_SA_Q(ntryL,G0H32(1),wf4(:,9),G0H8(177),ngX,m3h4x8(:,333),heltab2x32(:,:,839))
  call Hloop_A_Q(ntryL,G0H8(177),24,nMB,G1H8(157),n2h8(181))
  Gcoeff(:)%j = (c(103)*M(6,:)%j-c(104)*M(7,:)%j) * den(10)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(840),h0tab(:,840),[24,1,2,4],[nMT,0,nMT,nMW],4,1,wf4(:,9))
  call Hloop_SA_Q(ntryL,G0H32(1),wf4(:,9),G0H8(177),ngPbt,m3h4x8(:,334),heltab2x32(:,:,840))
  call Hloop_A_Q(ntryL,G0H8(177),24,nMT,G1H8(158),n2h8(182))
  Gcoeff(:)%j = (c(2)*M(8,:)%j) * den(10)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(841),h0tab(:,841),[24,1,2,4],[0,nMT,0,nMB],4,1,wf4(:,9))
  call Hloop_QA_V(ntryL,G0H32(1),wf4(:,9),G0H8(177),m3h4x8(:,335),heltab2x32(:,:,841))
  Gcoeff(:)%j = (-(c(5)*M(8,:)%j)) * den(10)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(842),h0tab(:,842),[24,1,2,4],[0,nMT,nMZ,nMB],4,1,wf4(:,9))
  call Hloop_QA_V(ntryL,G0H32(1),wf4(:,9),G0H8(178),m3h4x8(:,336),heltab2x32(:,:,842))
  Gcoeff(:)%j = (-(c(5)*M(8,:)%j)) * den(10)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(843),h0tab(:,843),[24,1,2,4],[nMZ,nMT,0,nMB],4,1,wf4(:,9))
  call Hloop_QA_Z(ntryL,G0H32(1),wf4(:,9),G0H8(179),ngZd,m3h4x8(:,337),heltab2x32(:,:,843))
  Gcoeff(:)%j = (c(7)*M(8,:)%j) * den(10)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(844),h0tab(:,844),[24,1,2,4],[nMZ,nMT,nMZ,nMB],4,1,wf4(:,9))
  call Hloop_QA_Z(ntryL,G0H32(1),wf4(:,9),G0H8(180),ngZd,m3h4x8(:,338),heltab2x32(:,:,844))
  Gcoeff(:)%j = (-(c(18)*M(6,:)%j)+c(17)*M(7,:)%j) * den(10)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(845),h0tab(:,845),[24,1,2,4],[0,nMT,0,nMB],4,1,wf4(:,9))
  call Hloop_QA_V(ntryL,G0H32(1),wf4(:,9),G0H8(181),m3h4x8(:,339),heltab2x32(:,:,845))
  Gcoeff(:)%j = (-(c(18)*M(6,:)%j)+c(17)*M(7,:)%j) * den(10)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(846),h0tab(:,846),[24,1,2,4],[0,nMT,0,nMB],4,1,wf4(:,9))
  call Hloop_QA_V(ntryL,G0H32(1),wf4(:,9),G0H8(182),m3h4x8(:,340),heltab2x32(:,:,846))
  Gcoeff(:)%j = (c(23)*M(6,:)%j-c(22)*M(7,:)%j) * den(10)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(847),h0tab(:,847),[24,1,2,4],[nMZ,nMT,0,nMB],4,1,wf4(:,9))
  call Hloop_QA_Z(ntryL,G0H32(1),wf4(:,9),G0H8(183),ngZd,m3h4x8(:,341),heltab2x32(:,:,847))
  Gcoeff(:)%j = (c(23)*M(6,:)%j-c(22)*M(7,:)%j) * den(10)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(848),h0tab(:,848),[24,1,2,4],[0,nMT,nMZ,nMB],4,1,wf4(:,9))
  call Hloop_QA_V(ntryL,G0H32(1),wf4(:,9),G0H8(184),m3h4x8(:,342),heltab2x32(:,:,848))
  Gcoeff(:)%j = (-(c(79)*M(5,:)%j)) * den(10)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(849),h0tab(:,849),[24,1,2,4],[nMT,0,nMT,nMW],4,1,wf4(:,9))
  call Hloop_WA_Q(ntryL,G0H32(1),wf4(:,9),G0H8(185),m3h4x8(:,343),heltab2x32(:,:,849))
  call Hloop_A_Q(ntryL,G0H8(185),24,nMT,G1H8(159),n2h8(183))
  Gcoeff(:)%j = (-(c(76)*M(5,:)%j)) * den(10)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(850),h0tab(:,850),[24,1,2,4],[nMB,nMW,nMB,0],4,1,wf4(:,9))
  call Hloop_VA_Q(ntryL,G0H32(1),wf4(:,9),G0H8(185),m3h4x8(:,344),heltab2x32(:,:,850))
  call Hloop_A_Q(ntryL,G0H8(185),24,nMB,G1H8(160),n2h8(184))
  Gcoeff(:)%j = (-(c(81)*M(5,:)%j)) * den(10)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(851),h0tab(:,851),[24,1,2,4],[nMT,nMZ,nMT,nMW],4,1,wf4(:,9))
  call Hloop_WA_Q(ntryL,G0H32(1),wf4(:,9),G0H8(185),m3h4x8(:,345),heltab2x32(:,:,851))
  call Hloop_A_Q(ntryL,G0H8(185),24,nMT,G1H8(161),n2h8(185))
  Gcoeff(:)%j = (-(c(81)*M(5,:)%j)) * den(10)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(852),h0tab(:,852),[24,1,2,4],[nMB,nMW,nMB,nMZ],4,1,wf4(:,9))
  call Hloop_ZA_Q(ntryL,G0H32(1),wf4(:,9),G0H8(185),ngZd,m3h4x8(:,346),heltab2x32(:,:,852))
  call Hloop_A_Q(ntryL,G0H8(185),24,nMB,G1H8(162),n2h8(186))
  Gcoeff(:)%j = (c(86)*M(6,:)%j-c(87)*M(7,:)%j) * den(10)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(853),h0tab(:,853),[24,1,2,4],[nMT,0,nMT,nMW],4,1,wf4(:,9))
  call Hloop_WA_Q(ntryL,G0H32(1),wf4(:,9),G0H8(185),m3h4x8(:,347),heltab2x32(:,:,853))
  call Hloop_A_Q(ntryL,G0H8(185),24,nMT,G1H8(163),n2h8(187))
  Gcoeff(:)%j = (c(86)*M(6,:)%j-c(87)*M(7,:)%j) * den(10)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(854),h0tab(:,854),[24,1,2,4],[nMB,nMW,nMB,0],4,1,wf4(:,9))
  call Hloop_VA_Q(ntryL,G0H32(1),wf4(:,9),G0H8(185),m3h4x8(:,348),heltab2x32(:,:,854))
  call Hloop_A_Q(ntryL,G0H8(185),24,nMB,G1H8(164),n2h8(188))
  Gcoeff(:)%j = (c(40)*M(5,:)%j) * den(10)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(855),h0tab(:,855),[24,1,4,2],[nMT,nMH,nMB,nMW],4,1,wf4(:,9))
  call Hloop_SA_Q(ntryL,G0H32(1),wf4(:,9),G0H8(185),ngPbt,m3h4x8(:,349),heltab2x32(:,:,855))
  call Hloop_A_Q(ntryL,G0H8(185),24,nMT,G1H8(165),n2h8(189))
  Gcoeff(:)%j = (c(40)*M(5,:)%j) * den(10)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(856),h0tab(:,856),[24,1,4,2],[nMB,nMW,nMT,nMH],4,1,wf4(:,9))
  call Hloop_SA_Q(ntryL,G0H32(1),wf4(:,9),G0H8(185),ngH,m3h4x8(:,350),heltab2x32(:,:,856))
  call Hloop_A_Q(ntryL,G0H8(185),24,nMB,G1H8(166),n2h8(190))
  Gcoeff(:)%j = (c(40)*M(5,:)%j) * den(10)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(857),h0tab(:,857),[24,1,4,2],[nMT,nMZ,nMB,nMW],4,1,wf4(:,9))
  call Hloop_SA_Q(ntryL,G0H32(1),wf4(:,9),G0H8(185),ngPbt,m3h4x8(:,351),heltab2x32(:,:,857))
  call Hloop_A_Q(ntryL,G0H8(185),24,nMT,G1H8(167),n2h8(191))
  Gcoeff(:)%j = (c(40)*M(5,:)%j) * den(10)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(858),h0tab(:,858),[24,1,4,2],[nMB,nMW,nMT,nMZ],4,1,wf4(:,9))
  call Hloop_SA_Q(ntryL,G0H32(1),wf4(:,9),G0H8(185),ngX,m3h4x8(:,352),heltab2x32(:,:,858))
  call Hloop_A_Q(ntryL,G0H8(185),24,nMB,G1H8(168),n2h8(192))
  Gcoeff(:)%j = (c(96)*M(5,:)%j) * den(10)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(859),h0tab(:,859),[24,1,4,2],[nMB,nMW,nMT,0],4,1,wf4(:,9))
  call Hloop_VA_Q(ntryL,G0H32(1),wf4(:,9),G0H8(185),m3h4x8(:,353),heltab2x32(:,:,859))
  call Hloop_A_Q(ntryL,G0H8(185),24,nMB,G1H8(169),n2h8(193))
  Gcoeff(:)%j = (-(c(100)*M(5,:)%j)) * den(10)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(860),h0tab(:,860),[24,1,4,2],[nMB,nMW,nMT,nMZ],4,1,wf4(:,9))
  call Hloop_ZA_Q(ntryL,G0H32(1),wf4(:,9),G0H8(185),ngZd,m3h4x8(:,354),heltab2x32(:,:,860))
  call Hloop_A_Q(ntryL,G0H8(185),24,nMB,G1H8(170),n2h8(194))
  Gcoeff(:)%j = (c(60)*M(5,:)%j) * den(10)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(861),h0tab(:,861),[24,1,4,2],[nMT,nMH,nMB,nMW],4,1,wf4(:,9))
  call Hloop_WA_Q(ntryL,G0H32(1),wf4(:,9),G0H8(185),m3h4x8(:,355),heltab2x32(:,:,861))
  call Hloop_A_Q(ntryL,G0H8(185),24,nMT,G1H8(171),n2h8(195))
  Gcoeff(:)%j = (c(60)*M(5,:)%j) * den(10)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(862),h0tab(:,862),[24,1,4,2],[nMT,nMZ,nMB,nMW],4,1,wf4(:,9))
  call Hloop_WA_Q(ntryL,G0H32(1),wf4(:,9),G0H8(185),m3h4x8(:,356),heltab2x32(:,:,862))
  call Hloop_A_Q(ntryL,G0H8(185),24,nMT,G1H8(172),n2h8(196))
  Gcoeff(:)%j = (c(103)*M(6,:)%j-c(104)*M(7,:)%j) * den(10)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(863),h0tab(:,863),[24,1,4,2],[nMB,nMW,nMT,0],4,1,wf4(:,9))
  call Hloop_VA_Q(ntryL,G0H32(1),wf4(:,9),G0H8(185),m3h4x8(:,357),heltab2x32(:,:,863))
  call Hloop_A_Q(ntryL,G0H8(185),24,nMB,G1H8(173),n2h8(197))
  Gcoeff(:)%j = (c(96)*M(5,:)%j) * den(10)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(864),h0tab(:,864),[24,1,4,2],[nMT,0,nMB,nMW],4,1,wf4(:,9))
  call Hloop_SA_Q(ntryL,G0H32(1),wf4(:,9),G0H8(185),ngPbt,m3h4x8(:,358),heltab2x32(:,:,864))
  call Hloop_A_Q(ntryL,G0H8(185),24,nMT,G1H8(174),n2h8(198))
  Gcoeff(:)%j = (-(c(100)*M(5,:)%j)) * den(10)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(865),h0tab(:,865),[24,1,4,2],[nMT,nMZ,nMB,nMW],4,1,wf4(:,9))
  call Hloop_SA_Q(ntryL,G0H32(1),wf4(:,9),G0H8(185),ngPbt,m3h4x8(:,359),heltab2x32(:,:,865))
  call Hloop_A_Q(ntryL,G0H8(185),24,nMT,G1H8(175),n2h8(199))
  Gcoeff(:)%j = (c(60)*M(5,:)%j) * den(10)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(866),h0tab(:,866),[24,1,4,2],[nMB,nMW,nMT,nMH],4,1,wf4(:,9))
  call Hloop_SA_Q(ntryL,G0H32(1),wf4(:,9),G0H8(185),ngH,m3h4x8(:,360),heltab2x32(:,:,866))
  call Hloop_A_Q(ntryL,G0H8(185),24,nMB,G1H8(176),n2h8(200))
  Gcoeff(:)%j = (c(60)*M(5,:)%j) * den(10)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(867),h0tab(:,867),[24,1,4,2],[nMB,nMW,nMT,nMZ],4,1,wf4(:,9))
  call Hloop_SA_Q(ntryL,G0H32(1),wf4(:,9),G0H8(185),ngX,m3h4x8(:,361),heltab2x32(:,:,867))
  call Hloop_A_Q(ntryL,G0H8(185),24,nMB,G1H8(177),n2h8(201))
  Gcoeff(:)%j = (c(103)*M(6,:)%j-c(104)*M(7,:)%j) * den(10)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(868),h0tab(:,868),[24,1,4,2],[nMT,0,nMB,nMW],4,1,wf4(:,9))
  call Hloop_SA_Q(ntryL,G0H32(1),wf4(:,9),G0H8(185),ngPbt,m3h4x8(:,362),heltab2x32(:,:,868))
  call Hloop_A_Q(ntryL,G0H8(185),24,nMT,G1H8(178),n2h8(202))
  Gcoeff(:)%j = (c(77)*M(5,:)%j) * den(10)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(869),h0tab(:,869),[24,1,4,2],[nMT,0,nMB,nMW],4,1,wf4(:,9))
  call Hloop_WA_Q(ntryL,G0H32(1),wf4(:,9),G0H8(185),m3h4x8(:,363),heltab2x32(:,:,869))
  call Hloop_A_Q(ntryL,G0H8(185),24,nMT,G1H8(179),n2h8(203))
  Gcoeff(:)%j = (c(77)*M(5,:)%j) * den(10)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(870),h0tab(:,870),[24,1,4,2],[nMB,nMW,nMT,0],4,1,wf4(:,9))
  call Hloop_VA_Q(ntryL,G0H32(1),wf4(:,9),G0H8(185),m3h4x8(:,364),heltab2x32(:,:,870))
  call Hloop_A_Q(ntryL,G0H8(185),24,nMB,G1H8(180),n2h8(204))
  Gcoeff(:)%j = (-(c(81)*M(5,:)%j)) * den(10)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(871),h0tab(:,871),[24,1,4,2],[nMT,nMZ,nMB,nMW],4,1,wf4(:,9))
  call Hloop_WA_Q(ntryL,G0H32(1),wf4(:,9),G0H8(185),m3h4x8(:,365),heltab2x32(:,:,871))
  call Hloop_A_Q(ntryL,G0H8(185),24,nMT,G1H8(181),n2h8(205))
  Gcoeff(:)%j = (-(c(81)*M(5,:)%j)) * den(10)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(872),h0tab(:,872),[24,1,4,2],[nMB,nMW,nMT,nMZ],4,1,wf4(:,9))
  call Hloop_ZA_Q(ntryL,G0H32(1),wf4(:,9),G0H8(185),ngZd,m3h4x8(:,366),heltab2x32(:,:,872))
  call Hloop_A_Q(ntryL,G0H8(185),24,nMB,G1H8(182),n2h8(206))
  Gcoeff(:)%j = (c(86)*M(6,:)%j-c(87)*M(7,:)%j) * den(10)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(873),h0tab(:,873),[24,1,4,2],[nMB,nMW,nMT,0],4,1,wf4(:,9))
  call Hloop_VA_Q(ntryL,G0H32(1),wf4(:,9),G0H8(185),m3h4x8(:,367),heltab2x32(:,:,873))
  call Hloop_A_Q(ntryL,G0H8(185),24,nMB,G1H8(183),n2h8(207))
  Gcoeff(:)%j = (c(86)*M(6,:)%j-c(87)*M(7,:)%j) * den(10)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(874),h0tab(:,874),[24,1,4,2],[nMT,0,nMB,nMW],4,1,wf4(:,9))
  call Hloop_WA_Q(ntryL,G0H32(1),wf4(:,9),G0H8(185),m3h4x8(:,368),heltab2x32(:,:,874))
  call Hloop_A_Q(ntryL,G0H8(185),24,nMT,G1H8(184),n2h8(208))
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H16(38),[G1H16(21)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H16(49),[G1H16(43)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H16(87),[G1H16(50)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H16(92),[G1H16(51)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H16(97),[G1H16(63)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H16(148),[G1H16(127),G1H16(98)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H16(158),[G1H16(117)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H16(159),[G1H16(122)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H16(147),[G1H16(128)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H16(194),[G1H16(187)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H16(201),[G1H16(203)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H16(12),[G1H16(1)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H16(8),[G1H16(2)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H16(9),[G1H16(3)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H16(27),[G1H16(15),G1H16(10)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H16(23),[G1H16(18)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H16(24),[G1H16(19)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H16(28),[G1H16(16)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H16(78),[G1H16(71)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H16(81),[G1H16(79)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H16(86),[G1H16(84)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H16(96),[G1H16(89)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H16(134),[G1H16(130)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H16(139),[G1H16(141)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H16(145),[G1H16(143)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H16(153),[G1H16(149)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H16(209),[G1H16(202)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H16(213),[G1H16(210)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H16(220),[G1H16(214)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H16(221),[G1H16(215)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H16(222),[G1H16(216)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H16(231),[G1H16(226),G1H16(223)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H16(232),[G1H16(224)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H16(233),[G1H16(225)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H16(230),[G1H16(227)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H16(243),[G1H16(240)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H16(247),[G1H16(244)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H16(254),[G1H16(248)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H16(255),[G1H16(249)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H16(256),[G1H16(250)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H16(265),[G1H16(260),G1H16(257)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H16(266),[G1H16(258)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H16(267),[G1H16(259)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H16(264),[G1H16(261)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G0H8(9),[G0H8(5)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G0H8(14),[G0H8(10)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G0H8(19),[G0H8(15)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G0H8(20),[G0H8(16)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G0H8(29),[G0H8(25)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G0H8(34),[G0H8(30)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H8(8),[G1H8(4)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H8(9),[G1H8(5)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H8(14),[G1H8(10)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H8(15),[G1H8(11)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G0H8(39),[G0H8(35)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G0H8(40),[G0H8(36)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H8(21),[G1H8(20),G1H8(16)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H8(23),[G1H8(17)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H8(22),[G1H8(18)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H8(34),[G1H8(29)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H8(35),[G1H8(30)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H8(41),[G1H8(36)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H8(42),[G1H8(37)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H8(49),[G1H8(48),G1H8(43)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H8(51),[G1H8(44)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H8(50),[G1H8(45)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H8(60),[G1H8(56)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H8(65),[G1H8(61)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H8(71),[G1H8(66)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H8(70),[G1H8(67)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H8(82),[G1H8(77)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H8(83),[G1H8(78)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H8(89),[G1H8(84)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H8(90),[G1H8(85)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H8(97),[G1H8(96),G1H8(91)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H8(99),[G1H8(92)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H8(98),[G1H8(93)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G0H8(49),[G0H8(45)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G0H8(54),[G0H8(50)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H8(108),[G1H8(104)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H8(109),[G1H8(105)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H8(114),[G1H8(110)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H8(115),[G1H8(111)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G0H8(59),[G0H8(55)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G0H8(60),[G0H8(56)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H8(121),[G1H8(120),G1H8(116)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H8(123),[G1H8(117)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H8(122),[G1H8(118)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G0H8(69),[G0H8(65)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G0H8(70),[G0H8(66)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G0H8(75),[G0H8(71)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G0H8(76),[G0H8(72)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H8(132),[G1H8(128)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H8(138),[G1H8(133)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G0H8(82),[G0H8(81),G0H8(77)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G0H8(84),[G0H8(78)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G0H8(83),[G0H8(79)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H8(143),[G1H8(139)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H8(144),[G1H8(140)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G0H8(95),[G0H8(90)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G0H8(96),[G0H8(91)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G0H8(102),[G0H8(97)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G0H8(103),[G0H8(98)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G0H8(110),[G0H8(109),G0H8(104)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G0H8(112),[G0H8(105)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G0H8(111),[G0H8(106)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G0H8(121),[G0H8(117)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G0H8(126),[G0H8(122)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G0H8(131),[G0H8(127)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G0H8(132),[G0H8(128)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G0H8(143),[G0H8(138)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G0H8(144),[G0H8(139)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G0H8(150),[G0H8(145)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G0H8(151),[G0H8(146)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G0H8(158),[G0H8(157),G0H8(152)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G0H8(160),[G0H8(153)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G0H8(159),[G0H8(154)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G0H8(169),[G0H8(165)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G0H8(170),[G0H8(166)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G0H8(175),[G0H8(171)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G0H8(176),[G0H8(172)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H8(153),[G1H8(149)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H8(158),[G1H8(154)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G0H8(182),[G0H8(181),G0H8(177)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G0H8(184),[G0H8(178)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G0H8(183),[G0H8(179)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H8(163),[G1H8(159)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H8(164),[G1H8(160)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H8(173),[G1H8(169)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H8(178),[G1H8(174)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H8(184),[G1H8(179)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H8(183),[G1H8(180)])
  call Hloop_QS_A(ntryL,G1H16(6),wf4(:,3),G1H4(1),ngH,m3h4x4(:,1),heltab2x16(:,:,161))
  call Hloop_Q_A(ntryL,G1H4(1),19,nMB,G2H4(3),n2h4(161))
  call Hloop_QS_A(ntryL,G1H16(7),wf4(:,3),G1H4(2),ngH,m3h4x4(:,2),heltab2x16(:,:,162))
  call Hloop_Q_A(ntryL,G1H4(2),19,nMB,G2H4(4),n2h4(162))
  call Hloop_QS_A(ntryL,G1H16(13),wf4(:,3),G1H4(5),ngH,m3h4x4(:,3),heltab2x16(:,:,163))
  call Hloop_Q_A(ntryL,G1H4(5),19,nMT,G2H4(5),n2h4(163))
  call Hloop_QS_A(ntryL,G1H16(14),wf4(:,6),G1H4(6),ngX,m3h4x4(:,4),heltab2x16(:,:,164))
  call Hloop_Q_A(ntryL,G1H4(6),19,nMB,G2H4(7),n2h4(164))
  call Hloop_QS_A(ntryL,G1H16(25),wf4(:,6),G1H4(7),ngX,m3h4x4(:,5),heltab2x16(:,:,165))
  call Hloop_Q_A(ntryL,G1H4(7),19,nMB,G2H4(9),n2h4(165))
  call Hloop_QS_A(ntryL,G1H16(20),wf4(:,6),G1H4(8),ngX,m3h4x4(:,6),heltab2x16(:,:,166))
  call Hloop_Q_A(ntryL,G1H4(8),19,nMT,G2H4(10),n2h4(166))
  call Hloop_QS_A(ntryL,G1H16(38),wf4(:,3),G1H4(11),ngH,m3h4x4(:,7),heltab2x16(:,:,167))
  call Hloop_Q_A(ntryL,G1H4(11),19,nMB,G2H4(26),n2h4(167))
  call Hloop_QS_A(ntryL,G1H16(22),wf4(:,3),G1H4(12),ngH,m3h4x4(:,8),heltab2x16(:,:,168))
  call Hloop_Q_A(ntryL,G1H4(12),19,nMB,G2H4(28),n2h4(168))
  call Hloop_QS_A(ntryL,G1H16(37),wf4(:,3),G1H4(13),ngH,m3h4x4(:,9),heltab2x16(:,:,169))
  call Hloop_Q_A(ntryL,G1H4(13),19,nMT,G2H4(34),n2h4(169))
  call Hloop_QS_A(ntryL,G1H16(49),wf4(:,6),G1H4(14),ngX,m3h4x4(:,10),heltab2x16(:,:,170))
  call Hloop_Q_A(ntryL,G1H4(14),19,nMB,G2H4(36),n2h4(170))
  call Hloop_QS_A(ntryL,G1H16(44),wf4(:,6),G1H4(17),ngX,m3h4x4(:,11),heltab2x16(:,:,171))
  call Hloop_Q_A(ntryL,G1H4(17),19,nMB,G2H4(44),n2h4(171))
  call Hloop_QS_A(ntryL,G1H16(53),wf4(:,6),G1H4(18),ngX,m3h4x4(:,12),heltab2x16(:,:,172))
  call Hloop_Q_A(ntryL,G1H4(18),19,nMT,G2H4(45),n2h4(172))
  call Hloop_QV_A(ntryL,G1H16(87),wf4(:,1),G1H4(19),m3h4x4(:,13),heltab2x16(:,:,173))
  call Hloop_Q_A(ntryL,G1H4(19),19,nMB,G2H4(46),n2h4(173))
  call Hloop_QV_A(ntryL,G1H16(92),wf4(:,1),G1H4(20),m3h4x4(:,14),heltab2x16(:,:,174))
  call Hloop_Q_A(ntryL,G1H4(20),19,nMB,G2H4(47),n2h4(174))
  call Hloop_QV_A(ntryL,G1H16(97),wf4(:,1),G1H4(23),m3h4x4(:,15),heltab2x16(:,:,175))
  call Hloop_Q_A(ntryL,G1H4(23),19,nMT,G2H4(48),n2h4(175))
  call Hloop_QZ_A(ntryL,G1H16(68),wf4(:,7),G1H4(24),ngZd,m3h4x4(:,16),heltab2x16(:,:,176))
  call Hloop_Q_A(ntryL,G1H4(24),19,nMB,G2H4(50),n2h4(176))
  call Hloop_QZ_A(ntryL,G1H16(73),wf4(:,7),G1H4(25),ngZd,m3h4x4(:,17),heltab2x16(:,:,177))
  call Hloop_Q_A(ntryL,G1H4(25),19,nMB,G2H4(64),n2h4(177))
  call Hloop_QZ_A(ntryL,G1H16(74),wf4(:,7),G1H4(26),ngZu,m3h4x4(:,18),heltab2x16(:,:,178))
  call Hloop_Q_A(ntryL,G1H4(26),19,nMT,G2H4(65),n2h4(178))
  call Hloop_QV_A(ntryL,G1H16(148),wf4(:,1),G1H4(29),m3h4x4(:,19),heltab2x16(:,:,179))
  call Hloop_Q_A(ntryL,G1H4(29),19,nMB,G2H4(66),n2h4(179))
  call Hloop_QV_A(ntryL,G1H16(158),wf4(:,1),G1H4(30),m3h4x4(:,20),heltab2x16(:,:,180))
  call Hloop_Q_A(ntryL,G1H4(30),19,nMB,G2H4(67),n2h4(180))
  call Hloop_QV_A(ntryL,G1H16(159),wf4(:,1),G1H4(31),m3h4x4(:,21),heltab2x16(:,:,181))
  call Hloop_Q_A(ntryL,G1H4(31),19,nMT,G2H4(68),n2h4(181))
  call Hloop_QZ_A(ntryL,G1H16(147),wf4(:,7),G1H4(32),ngZd,m3h4x4(:,22),heltab2x16(:,:,182))
  call Hloop_Q_A(ntryL,G1H4(32),19,nMB,G2H4(70),n2h4(182))
  call Hloop_QZ_A(ntryL,G1H16(137),wf4(:,7),G1H4(35),ngZd,m3h4x4(:,23),heltab2x16(:,:,183))
  call Hloop_Q_A(ntryL,G1H4(35),19,nMB,G2H4(90),n2h4(183))
  call Hloop_QZ_A(ntryL,G1H16(142),wf4(:,7),G1H4(36),ngZu,m3h4x4(:,24),heltab2x16(:,:,184))
  call Hloop_Q_A(ntryL,G1H4(36),19,nMT,G2H4(91),n2h4(184))
  call Hloop_AS_Q(ntryL,G1H16(165),wf4(:,3),G1H4(37),ngH,m3h4x4(:,25),heltab2x16(:,:,185))
  call Hloop_A_Q(ntryL,G1H4(37),19,nMB,G2H4(92),n2h4(185))
  call Hloop_AS_Q(ntryL,G1H16(166),wf4(:,3),G1H4(38),ngH,m3h4x4(:,26),heltab2x16(:,:,186))
  call Hloop_A_Q(ntryL,G1H4(38),19,nMB,G2H4(97),n2h4(186))
  call Hloop_AS_Q(ntryL,G1H16(177),wf4(:,3),G1H4(41),ngH,m3h4x4(:,27),heltab2x16(:,:,187))
  call Hloop_A_Q(ntryL,G1H4(41),19,nMT,G2H4(98),n2h4(187))
  call Hloop_AS_Q(ntryL,G1H16(172),wf4(:,6),G1H4(42),ngX,m3h4x4(:,28),heltab2x16(:,:,188))
  call Hloop_A_Q(ntryL,G1H4(42),19,nMB,G2H4(100),n2h4(188))
  call Hloop_AS_Q(ntryL,G1H16(173),wf4(:,6),G1H4(43),ngX,m3h4x4(:,29),heltab2x16(:,:,189))
  call Hloop_A_Q(ntryL,G1H4(43),19,nMB,G2H4(106),n2h4(189))
  call Hloop_AS_Q(ntryL,G1H16(174),wf4(:,6),G1H4(44),ngX,m3h4x4(:,30),heltab2x16(:,:,190))
  call Hloop_A_Q(ntryL,G1H4(44),19,nMT,G2H4(107),n2h4(190))
  call Hloop_AS_Q(ntryL,G1H16(194),wf4(:,3),G1H4(47),ngH,m3h4x4(:,31),heltab2x16(:,:,191))
  call Hloop_A_Q(ntryL,G1H4(47),19,nMB,G2H4(108),n2h4(191))
  call Hloop_AS_Q(ntryL,G1H16(188),wf4(:,3),G1H4(48),ngH,m3h4x4(:,32),heltab2x16(:,:,192))
  call Hloop_A_Q(ntryL,G1H4(48),19,nMB,G2H4(109),n2h4(192))
  call Hloop_AS_Q(ntryL,G1H16(193),wf4(:,3),G1H4(49),ngH,m3h4x4(:,33),heltab2x16(:,:,193))
  call Hloop_A_Q(ntryL,G1H4(49),19,nMT,G2H4(110),n2h4(193))
  call Hloop_AS_Q(ntryL,G1H16(201),wf4(:,6),G1H4(50),ngX,m3h4x4(:,34),heltab2x16(:,:,194))
  call Hloop_A_Q(ntryL,G1H4(50),19,nMB,G2H4(112),n2h4(194))
  call Hloop_AS_Q(ntryL,G1H16(199),wf4(:,6),G1H4(53),ngX,m3h4x4(:,35),heltab2x16(:,:,195))
  call Hloop_A_Q(ntryL,G1H4(53),19,nMB,G2H4(123),n2h4(195))
  call Hloop_AS_Q(ntryL,G1H16(200),wf4(:,6),G1H4(54),ngX,m3h4x4(:,36),heltab2x16(:,:,196))
  call Hloop_A_Q(ntryL,G1H4(54),19,nMT,G2H4(124),n2h4(196))
  call Hloop_AV_Q(ntryL,G1H16(12),wf4(:,1),G1H4(55),m3h4x4(:,37),heltab2x16(:,:,197))
  call Hloop_A_Q(ntryL,G1H4(55),19,nMB,G2H4(125),n2h4(197))
  call Hloop_AV_Q(ntryL,G1H16(8),wf4(:,1),G1H4(56),m3h4x4(:,38),heltab2x16(:,:,198))
  call Hloop_A_Q(ntryL,G1H4(56),19,nMB,G2H4(127),n2h4(198))
  call Hloop_AV_Q(ntryL,G1H16(9),wf4(:,1),G1H4(59),m3h4x4(:,39),heltab2x16(:,:,199))
  call Hloop_A_Q(ntryL,G1H4(59),19,nMT,G2H4(129),n2h4(199))
  call Hloop_AZ_Q(ntryL,G1H16(4),wf4(:,7),G1H4(60),ngZd,m3h4x4(:,40),heltab2x16(:,:,200))
  call Hloop_A_Q(ntryL,G1H4(60),19,nMB,G2H4(130),n2h4(200))
  call Hloop_AZ_Q(ntryL,G1H16(5),wf4(:,7),G1H4(61),ngZd,m3h4x4(:,41),heltab2x16(:,:,201))
  call Hloop_A_Q(ntryL,G1H4(61),19,nMB,G2H4(145),n2h4(201))
  call Hloop_AZ_Q(ntryL,G1H16(11),wf4(:,7),G1H4(62),ngZu,m3h4x4(:,42),heltab2x16(:,:,202))
  call Hloop_A_Q(ntryL,G1H4(62),19,nMT,G2H4(146),n2h4(202))
  call Hloop_AV_Q(ntryL,G1H16(27),wf4(:,1),G1H4(65),m3h4x4(:,43),heltab2x16(:,:,203))
  call Hloop_A_Q(ntryL,G1H4(65),19,nMB,G2H4(148),n2h4(203))
  call Hloop_AV_Q(ntryL,G1H16(23),wf4(:,1),G1H4(66),m3h4x4(:,44),heltab2x16(:,:,204))
  call Hloop_A_Q(ntryL,G1H4(66),19,nMB,G2H4(150),n2h4(204))
  call Hloop_AV_Q(ntryL,G1H16(24),wf4(:,1),G1H4(67),m3h4x4(:,45),heltab2x16(:,:,205))
  call Hloop_A_Q(ntryL,G1H4(67),19,nMT,G2H4(1),n2h4(205))
  call Hloop_AZ_Q(ntryL,G1H16(28),wf4(:,7),G1H4(68),ngZd,m3h4x4(:,46),heltab2x16(:,:,206))
  call Hloop_A_Q(ntryL,G1H4(68),19,nMB,G2H4(2),n2h4(206))
  call Hloop_AZ_Q(ntryL,G1H16(17),wf4(:,7),G1H4(71),ngZd,m3h4x4(:,47),heltab2x16(:,:,207))
  call Hloop_A_Q(ntryL,G1H4(71),19,nMB,G2H4(13),n2h4(207))
  call Hloop_AZ_Q(ntryL,G1H16(26),wf4(:,7),G1H4(72),ngZu,m3h4x4(:,48),heltab2x16(:,:,208))
  call Hloop_A_Q(ntryL,G1H4(72),19,nMT,G2H4(14),n2h4(208))
  call Hloop_AQ_S(ntryL,G1H16(29),ex3(:),G1H8(4),ngH,m3h2x8(:,161),heltab2x16(:,:,209))
  call Hloop_AQ_S(ntryL,G1H16(30),ex3(:),G1H8(5),ngX,m3h2x8(:,162),heltab2x16(:,:,210))
  call Hloop_AQ_S(ntryL,G1H16(31),ex3(:),G1H8(10),ngPtb,m3h2x8(:,163),heltab2x16(:,:,211))
  call Hloop_AQ_S(ntryL,G1H16(32),ex3(:),G1H8(11),ngH,m3h2x8(:,164),heltab2x16(:,:,212))
  call Hloop_AQ_S(ntryL,G1H16(33),ex3(:),G1H8(20),ngX,m3h2x8(:,165),heltab2x16(:,:,213))
  call Hloop_AQ_S(ntryL,G1H16(34),ex3(:),G1H8(16),ngX,m3h2x8(:,166),heltab2x16(:,:,214))
  call Hloop_AQ_S(ntryL,G1H16(35),ex3(:),G1H8(17),ngPtb,m3h2x8(:,167),heltab2x16(:,:,215))
  call Hloop_AQ_S(ntryL,G1H16(36),ex3(:),G1H8(18),ngH,m3h2x8(:,168),heltab2x16(:,:,216))
  call Hloop_AQ_S(ntryL,G1H16(41),ex3(:),G1H8(29),ngPtb,m3h2x8(:,169),heltab2x16(:,:,217))
  call Hloop_AQ_Z(ntryL,G1H16(42),ex3(:),G1H8(30),ngZd,m3h2x8(:,170),heltab2x16(:,:,218))
  call Hloop_AQ_W(ntryL,G1H16(39),ex3(:),G1H8(36),m3h2x8(:,171),heltab2x16(:,:,219))
  call Hloop_AQ_Z(ntryL,G1H16(40),ex3(:),G1H8(37),ngZd,m3h2x8(:,172),heltab2x16(:,:,220))
  call Hloop_AQ_W(ntryL,G1H16(47),ex3(:),G1H8(48),m3h2x8(:,173),heltab2x16(:,:,221))
  call Hloop_AQ_Z(ntryL,G1H16(48),ex3(:),G1H8(43),ngZd,m3h2x8(:,174),heltab2x16(:,:,222))
  call Hloop_AQ_W(ntryL,G1H16(45),ex3(:),G1H8(44),m3h2x8(:,175),heltab2x16(:,:,223))
  call Hloop_VQ_A(ntryL,G1H16(46),ex3(:),G1H8(45),m3h2x8(:,176),heltab2x16(:,:,224))
  call Hloop_Q_A(ntryL,G1H8(45),20,nMB,G2H8(1),n2h8(209))
  call Hloop_VQ_A(ntryL,G1H16(54),ex3(:),G1H8(56),m3h2x8(:,177),heltab2x16(:,:,225))
  call Hloop_Q_A(ntryL,G1H8(56),20,nMB,G2H8(2),n2h8(210))
  call Hloop_AQ_S(ntryL,G1H16(56),ex3(:),G1H8(61),ngPtb,m3h2x8(:,178),heltab2x16(:,:,226))
  call Hloop_AQ_S(ntryL,G1H16(55),ex3(:),G1H8(66),ngH,m3h2x8(:,179),heltab2x16(:,:,227))
  call Hloop_AQ_S(ntryL,G1H16(52),ex3(:),G1H8(67),ngX,m3h2x8(:,180),heltab2x16(:,:,228))
  call Hloop_AQ_S(ntryL,G1H16(57),ex3(:),G1H8(77),ngPtb,m3h2x8(:,181),heltab2x16(:,:,229))
  call Hloop_AQ_S(ntryL,G1H16(58),ex3(:),G1H8(78),ngPtb,m3h2x8(:,182),heltab2x16(:,:,230))
  call Hloop_AQ_S(ntryL,G1H16(59),ex3(:),G1H8(84),ngH,m3h2x8(:,183),heltab2x16(:,:,231))
  call Hloop_AQ_S(ntryL,G1H16(60),ex3(:),G1H8(85),ngPtb,m3h2x8(:,184),heltab2x16(:,:,232))
  call Hloop_AQ_W(ntryL,G1H16(61),ex3(:),G1H8(96),m3h2x8(:,185),heltab2x16(:,:,233))
  call Hloop_AQ_Z(ntryL,G1H16(62),ex3(:),G1H8(91),ngZd,m3h2x8(:,186),heltab2x16(:,:,234))
  call Hloop_AQ_W(ntryL,G1H16(67),ex3(:),G1H8(92),m3h2x8(:,187),heltab2x16(:,:,235))
  call Hloop_AQ_W(ntryL,G1H16(64),ex3(:),G1H8(93),m3h2x8(:,188),heltab2x16(:,:,236))
  call Hloop_AQ_W(ntryL,G1H16(65),ex3(:),G1H8(104),m3h2x8(:,189),heltab2x16(:,:,237))
  call Hloop_VQ_A(ntryL,G1H16(66),ex3(:),G1H8(105),m3h2x8(:,190),heltab2x16(:,:,238))
  call Hloop_Q_A(ntryL,G1H8(105),20,nMB,G2H8(3),n2h8(211))
  call Hloop_VQ_A(ntryL,G1H16(72),ex3(:),G1H8(110),m3h2x8(:,191),heltab2x16(:,:,239))
  call Hloop_Q_A(ntryL,G1H8(110),20,nMB,G2H8(4),n2h8(212))
  call Hloop_AQ_S(ntryL,G1H16(69),ex1(:),G1H8(111),ngH,m3h2x8(:,192),heltab2x16(:,:,240))
  call Hloop_AQ_S(ntryL,G1H16(70),ex1(:),G1H8(120),ngX,m3h2x8(:,193),heltab2x16(:,:,241))
  call Hloop_AQ_V(ntryL,G1H16(78),ex1(:),G1H8(116),m3h2x8(:,194),heltab2x16(:,:,242))
  call Hloop_AQ_Z(ntryL,G1H16(77),ex1(:),G1H8(117),ngZu,m3h2x8(:,195),heltab2x16(:,:,243))
  call Hloop_AQ_S(ntryL,G1H16(75),ex1(:),G1H8(118),ngH,m3h2x8(:,196),heltab2x16(:,:,244))
  call Hloop_AQ_S(ntryL,G1H16(76),ex1(:),G1H8(128),ngX,m3h2x8(:,197),heltab2x16(:,:,245))
  call Hloop_AQ_V(ntryL,G1H16(81),ex1(:),G1H8(133),m3h2x8(:,198),heltab2x16(:,:,246))
  call Hloop_AQ_Z(ntryL,G1H16(80),ex1(:),G1H8(139),ngZu,m3h2x8(:,199),heltab2x16(:,:,247))
  call Hloop_AS_Q(ntryL,G1H16(82),wf4(:,11),G1H4(73),ngPbt,m3h4x4(:,49),heltab2x16(:,:,248))
  call Hloop_A_Q(ntryL,G1H4(73),22,nMT,G2H4(15),n2h4(209))
  call Hloop_AS_Q(ntryL,G1H16(83),wf4(:,11),G1H4(74),ngPbt,m3h4x4(:,50),heltab2x16(:,:,249))
  call Hloop_A_Q(ntryL,G1H4(74),22,nMT,G2H4(6),n2h4(210))
  call Hloop_AS_Q(ntryL,G1H16(86),wf4(:,11),G1H4(77),ngPbt,m3h4x4(:,51),heltab2x16(:,:,250))
  call Hloop_A_Q(ntryL,G1H4(77),22,nMT,G2H4(18),n2h4(211))
  call Hloop_AS_Q(ntryL,G1H16(85),wf4(:,11),G1H4(78),ngPbt,m3h4x4(:,52),heltab2x16(:,:,251))
  call Hloop_A_Q(ntryL,G1H4(78),22,nMT,G2H4(8),n2h4(212))
  call Hloop_AW_Q(ntryL,G1H16(91),wf4(:,13),G1H4(79),m3h4x4(:,53),heltab2x16(:,:,252))
  call Hloop_A_Q(ntryL,G1H4(79),22,nMT,G2H4(19),n2h4(213))
  call Hloop_AW_Q(ntryL,G1H16(88),wf4(:,13),G1H4(80),m3h4x4(:,54),heltab2x16(:,:,253))
  call Hloop_A_Q(ntryL,G1H4(80),22,nMT,G2H4(20),n2h4(214))
  call Hloop_AW_Q(ntryL,G1H16(96),wf4(:,13),G1H4(83),m3h4x4(:,55),heltab2x16(:,:,254))
  call Hloop_A_Q(ntryL,G1H4(83),22,nMT,G2H4(11),n2h4(215))
  call Hloop_AW_Q(ntryL,G1H16(90),wf4(:,13),G1H4(84),m3h4x4(:,56),heltab2x16(:,:,255))
  call Hloop_A_Q(ntryL,G1H4(84),22,nMT,G2H4(12),n2h4(216))
  call Hloop_AQ_S(ntryL,G1H16(93),ex1(:),G1H8(140),ngH,m3h2x8(:,200),heltab2x16(:,:,256))
  call Hloop_AQ_S(ntryL,G1H16(94),ex1(:),G1H8(149),ngPbt,m3h2x8(:,201),heltab2x16(:,:,257))
  call Hloop_AQ_S(ntryL,G1H16(95),ex1(:),G1H8(154),ngPbt,m3h2x8(:,202),heltab2x16(:,:,258))
  call Hloop_AQ_S(ntryL,G1H16(101),ex1(:),G1H8(159),ngPbt,m3h2x8(:,203),heltab2x16(:,:,259))
  call Hloop_AQ_S(ntryL,G1H16(102),ex1(:),G1H8(160),ngH,m3h2x8(:,204),heltab2x16(:,:,260))
  call Hloop_AQ_S(ntryL,G1H16(99),ex1(:),G1H8(169),ngX,m3h2x8(:,205),heltab2x16(:,:,261))
  call Hloop_AQ_V(ntryL,G1H16(100),ex1(:),G1H8(174),m3h2x8(:,206),heltab2x16(:,:,262))
  call Hloop_AQ_Z(ntryL,G1H16(103),ex1(:),G1H8(179),ngZu,m3h2x8(:,207),heltab2x16(:,:,263))
  call Hloop_AQ_W(ntryL,G1H16(104),ex1(:),G1H8(180),m3h2x8(:,208),heltab2x16(:,:,264))
  call Hloop_AQ_W(ntryL,G1H16(105),ex1(:),G1H8(45),m3h2x8(:,209),heltab2x16(:,:,265))
  call Hloop_AQ_V(ntryL,G1H16(106),ex1(:),G1H8(56),m3h2x8(:,210),heltab2x16(:,:,266))
  call Hloop_AQ_W(ntryL,G1H16(107),ex1(:),G1H8(105),m3h2x8(:,211),heltab2x16(:,:,267))
  call Hloop_AQ_Z(ntryL,G1H16(108),ex1(:),G1H8(110),ngZu,m3h2x8(:,212),heltab2x16(:,:,268))
  call Hloop_AQ_W(ntryL,G1H16(109),ex1(:),G1H8(185),m3h2x8(:,213),heltab2x16(:,:,269))
  call Hloop_VQ_A(ntryL,G1H16(110),ex1(:),G1H8(186),m3h2x8(:,214),heltab2x16(:,:,270))
  call Hloop_Q_A(ntryL,G1H8(186),17,nMT,G2H8(5),n2h8(213))
  call Hloop_AQ_S(ntryL,G1H16(111),ex1(:),G1H8(186),ngH,m3h2x8(:,215),heltab2x16(:,:,271))
  call Hloop_AQ_S(ntryL,G1H16(112),ex1(:),G1H8(187),ngPbt,m3h2x8(:,216),heltab2x16(:,:,272))
  call Hloop_AQ_S(ntryL,G1H16(113),ex1(:),G1H8(188),ngX,m3h2x8(:,217),heltab2x16(:,:,273))
  call Hloop_AQ_S(ntryL,G1H16(114),ex1(:),G1H8(189),ngPbt,m3h2x8(:,218),heltab2x16(:,:,274))
  call Hloop_AQ_S(ntryL,G1H16(115),ex1(:),G1H8(190),ngPbt,m3h2x8(:,219),heltab2x16(:,:,275))
  call Hloop_AQ_S(ntryL,G1H16(116),ex1(:),G1H8(191),ngPbt,m3h2x8(:,220),heltab2x16(:,:,276))
  call Hloop_AQ_S(ntryL,G1H16(121),ex1(:),G1H8(192),ngH,m3h2x8(:,221),heltab2x16(:,:,277))
  call Hloop_AQ_V(ntryL,G1H16(118),ex1(:),G1H8(193),m3h2x8(:,222),heltab2x16(:,:,278))
  call Hloop_AQ_Z(ntryL,G1H16(119),ex1(:),G1H8(194),ngZu,m3h2x8(:,223),heltab2x16(:,:,279))
  call Hloop_AQ_W(ntryL,G1H16(120),ex1(:),G1H8(195),m3h2x8(:,224),heltab2x16(:,:,280))
  call Hloop_AQ_V(ntryL,G1H16(126),ex1(:),G1H8(196),m3h2x8(:,225),heltab2x16(:,:,281))
  call Hloop_AQ_W(ntryL,G1H16(123),ex1(:),G1H8(197),m3h2x8(:,226),heltab2x16(:,:,282))
  call Hloop_AQ_Z(ntryL,G1H16(124),ex1(:),G1H8(198),ngZu,m3h2x8(:,227),heltab2x16(:,:,283))
  call Hloop_AQ_W(ntryL,G1H16(125),ex1(:),G1H8(199),m3h2x8(:,228),heltab2x16(:,:,284))
  call Hloop_VQ_A(ntryL,G1H16(131),ex1(:),G1H8(200),m3h2x8(:,229),heltab2x16(:,:,285))
  call Hloop_Q_A(ntryL,G1H8(200),17,nMT,G2H8(6),n2h8(214))
  call Hloop_QA_S(ntryL,G1H16(132),ex2(:),G1H8(200),ngH,m3h2x8(:,230),heltab2x16(:,:,286))
  call Hloop_QA_S(ntryL,G1H16(129),ex2(:),G1H8(201),ngX,m3h2x8(:,231),heltab2x16(:,:,287))
  call Hloop_QA_V(ntryL,G1H16(134),ex2(:),G1H8(202),m3h2x8(:,232),heltab2x16(:,:,288))
  call Hloop_QA_Z(ntryL,G1H16(133),ex2(:),G1H8(203),ngZu,m3h2x8(:,233),heltab2x16(:,:,289))
  call Hloop_QA_S(ntryL,G1H16(135),ex2(:),G1H8(204),ngH,m3h2x8(:,234),heltab2x16(:,:,290))
  call Hloop_QA_S(ntryL,G1H16(136),ex2(:),G1H8(205),ngX,m3h2x8(:,235),heltab2x16(:,:,291))
  call Hloop_QA_V(ntryL,G1H16(139),ex2(:),G1H8(206),m3h2x8(:,236),heltab2x16(:,:,292))
  call Hloop_QA_Z(ntryL,G1H16(138),ex2(:),G1H8(207),ngZu,m3h2x8(:,237),heltab2x16(:,:,293))
  call Hloop_AQ_S(ntryL,G1H16(140),ex3(:),G1H8(208),ngH,m3h2x8(:,238),heltab2x16(:,:,294))
  call Hloop_AQ_S(ntryL,G1H16(146),ex3(:),G1H8(209),ngX,m3h2x8(:,239),heltab2x16(:,:,295))
  call Hloop_AQ_V(ntryL,G1H16(145),ex3(:),G1H8(210),m3h2x8(:,240),heltab2x16(:,:,296))
  call Hloop_AQ_Z(ntryL,G1H16(144),ex3(:),G1H8(211),ngZd,m3h2x8(:,241),heltab2x16(:,:,297))
  call Hloop_AQ_S(ntryL,G1H16(151),ex3(:),G1H8(212),ngH,m3h2x8(:,242),heltab2x16(:,:,298))
  call Hloop_AQ_S(ntryL,G1H16(152),ex3(:),G1H8(213),ngX,m3h2x8(:,243),heltab2x16(:,:,299))
  call Hloop_AQ_V(ntryL,G1H16(153),ex3(:),G1H8(214),m3h2x8(:,244),heltab2x16(:,:,300))
  call Hloop_AQ_Z(ntryL,G1H16(150),ex3(:),G1H8(215),ngZd,m3h2x8(:,245),heltab2x16(:,:,301))
  call Hloop_QA_S(ntryL,G1H16(154),ex2(:),G1H8(216),ngH,m3h2x8(:,246),heltab2x16(:,:,302))
  call Hloop_QA_S(ntryL,G1H16(155),ex2(:),G1H8(217),ngPtb,m3h2x8(:,247),heltab2x16(:,:,303))
  call Hloop_QA_S(ntryL,G1H16(156),ex2(:),G1H8(218),ngPtb,m3h2x8(:,248),heltab2x16(:,:,304))
  call Hloop_QA_S(ntryL,G1H16(157),ex2(:),G1H8(219),ngPtb,m3h2x8(:,249),heltab2x16(:,:,305))
  call Hloop_QA_S(ntryL,G1H16(163),ex2(:),G1H8(220),ngH,m3h2x8(:,250),heltab2x16(:,:,306))
  call Hloop_QA_S(ntryL,G1H16(164),ex2(:),G1H8(221),ngX,m3h2x8(:,251),heltab2x16(:,:,307))
  call Hloop_QA_V(ntryL,G1H16(160),ex2(:),G1H8(222),m3h2x8(:,252),heltab2x16(:,:,308))
  call Hloop_QA_Z(ntryL,G1H16(161),ex2(:),G1H8(223),ngZu,m3h2x8(:,253),heltab2x16(:,:,309))
  call Hloop_QA_W(ntryL,G1H16(162),ex2(:),G1H8(224),m3h2x8(:,254),heltab2x16(:,:,310))
  call Hloop_QA_W(ntryL,G1H16(170),ex2(:),G1H8(225),m3h2x8(:,255),heltab2x16(:,:,311))
  call Hloop_QA_V(ntryL,G1H16(171),ex2(:),G1H8(226),m3h2x8(:,256),heltab2x16(:,:,312))
  call Hloop_QA_W(ntryL,G1H16(167),ex2(:),G1H8(227),m3h2x8(:,257),heltab2x16(:,:,313))
  call Hloop_QA_Z(ntryL,G1H16(168),ex2(:),G1H8(228),ngZu,m3h2x8(:,258),heltab2x16(:,:,314))
  call Hloop_QA_W(ntryL,G1H16(169),ex2(:),G1H8(229),m3h2x8(:,259),heltab2x16(:,:,315))
  call Hloop_VA_Q(ntryL,G1H16(178),ex2(:),G1H8(230),m3h2x8(:,260),heltab2x16(:,:,316))
  call Hloop_A_Q(ntryL,G1H8(230),18,nMT,G2H8(7),n2h8(215))
  call Hloop_QA_S(ntryL,G1H16(180),ex2(:),G1H8(230),ngH,m3h2x8(:,261),heltab2x16(:,:,317))
  call Hloop_QA_S(ntryL,G1H16(179),ex2(:),G1H8(231),ngPtb,m3h2x8(:,262),heltab2x16(:,:,318))
  call Hloop_QA_S(ntryL,G1H16(175),ex2(:),G1H8(232),ngX,m3h2x8(:,263),heltab2x16(:,:,319))
  call Hloop_QA_S(ntryL,G1H16(176),ex2(:),G1H8(233),ngPtb,m3h2x8(:,264),heltab2x16(:,:,320))
  call Hloop_QA_S(ntryL,G1H16(181),ex2(:),G1H8(234),ngPtb,m3h2x8(:,265),heltab2x16(:,:,321))
  call Hloop_QA_S(ntryL,G1H16(182),ex2(:),G1H8(235),ngPtb,m3h2x8(:,266),heltab2x16(:,:,322))
  call Hloop_QA_S(ntryL,G1H16(183),ex2(:),G1H8(236),ngH,m3h2x8(:,267),heltab2x16(:,:,323))
  call Hloop_QA_V(ntryL,G1H16(184),ex2(:),G1H8(237),m3h2x8(:,268),heltab2x16(:,:,324))
  call Hloop_QA_Z(ntryL,G1H16(185),ex2(:),G1H8(238),ngZu,m3h2x8(:,269),heltab2x16(:,:,325))
  call Hloop_QA_W(ntryL,G1H16(186),ex2(:),G1H8(239),m3h2x8(:,270),heltab2x16(:,:,326))
  call Hloop_QA_V(ntryL,G1H16(191),ex2(:),G1H8(240),m3h2x8(:,271),heltab2x16(:,:,327))
  call Hloop_QA_W(ntryL,G1H16(192),ex2(:),G1H8(241),m3h2x8(:,272),heltab2x16(:,:,328))
  call Hloop_QA_Z(ntryL,G1H16(189),ex2(:),G1H8(242),ngZu,m3h2x8(:,273),heltab2x16(:,:,329))
  call Hloop_QA_W(ntryL,G1H16(190),ex2(:),G1H8(243),m3h2x8(:,274),heltab2x16(:,:,330))
  call Hloop_VA_Q(ntryL,G1H16(197),ex2(:),G1H8(244),m3h2x8(:,275),heltab2x16(:,:,331))
  call Hloop_A_Q(ntryL,G1H8(244),18,nMT,G2H8(8),n2h8(216))
  call Hloop_AQ_S(ntryL,G1H16(198),ex1(:),G1H8(244),ngH,m3h2x8(:,276),heltab2x16(:,:,332))
  call Hloop_AQ_S(ntryL,G1H16(195),ex1(:),G1H8(245),ngX,m3h2x8(:,277),heltab2x16(:,:,333))
  call Hloop_AQ_S(ntryL,G1H16(196),ex1(:),G1H8(246),ngPbt,m3h2x8(:,278),heltab2x16(:,:,334))
  call Hloop_AQ_S(ntryL,G1H16(204),ex1(:),G1H8(247),ngH,m3h2x8(:,279),heltab2x16(:,:,335))
  call Hloop_AQ_S(ntryL,G1H16(206),ex1(:),G1H8(248),ngX,m3h2x8(:,280),heltab2x16(:,:,336))
  call Hloop_AQ_S(ntryL,G1H16(205),ex1(:),G1H8(249),ngPbt,m3h2x8(:,281),heltab2x16(:,:,337))
  call Hloop_AQ_V(ntryL,G1H16(209),ex1(:),G1H8(250),m3h2x8(:,282),heltab2x16(:,:,338))
  call Hloop_AQ_Z(ntryL,G1H16(207),ex1(:),G1H8(251),ngZu,m3h2x8(:,283),heltab2x16(:,:,339))
  call Hloop_AQ_W(ntryL,G1H16(208),ex1(:),G1H8(252),m3h2x8(:,284),heltab2x16(:,:,340))
  call Hloop_AQ_V(ntryL,G1H16(213),ex1(:),G1H8(253),m3h2x8(:,285),heltab2x16(:,:,341))
  call Hloop_AQ_Z(ntryL,G1H16(211),ex1(:),G1H8(254),ngZu,m3h2x8(:,286),heltab2x16(:,:,342))
  call Hloop_AQ_W(ntryL,G1H16(212),ex1(:),G1H8(255),m3h2x8(:,287),heltab2x16(:,:,343))
  call Hloop_AQ_S(ntryL,G1H16(220),ex1(:),G1H8(256),ngH,m3h2x8(:,288),heltab2x16(:,:,344))
  call Hloop_AQ_S(ntryL,G1H16(221),ex1(:),G1H8(257),ngX,m3h2x8(:,289),heltab2x16(:,:,345))
  call Hloop_AQ_S(ntryL,G1H16(222),ex1(:),G1H8(258),ngPbt,m3h2x8(:,290),heltab2x16(:,:,346))
  call Hloop_AQ_S(ntryL,G1H16(217),ex1(:),G1H8(259),ngH,m3h2x8(:,291),heltab2x16(:,:,347))
  call Hloop_AQ_S(ntryL,G1H16(218),ex1(:),G1H8(260),ngX,m3h2x8(:,292),heltab2x16(:,:,348))
  call Hloop_AQ_S(ntryL,G1H16(219),ex1(:),G1H8(261),ngPbt,m3h2x8(:,293),heltab2x16(:,:,349))
  call Hloop_AQ_V(ntryL,G1H16(231),ex1(:),G1H8(262),m3h2x8(:,294),heltab2x16(:,:,350))
  call Hloop_AQ_Z(ntryL,G1H16(232),ex1(:),G1H8(263),ngZu,m3h2x8(:,295),heltab2x16(:,:,351))
  call Hloop_AQ_W(ntryL,G1H16(233),ex1(:),G1H8(264),m3h2x8(:,296),heltab2x16(:,:,352))
  call Hloop_AQ_V(ntryL,G1H16(230),ex1(:),G1H8(265),m3h2x8(:,297),heltab2x16(:,:,353))
  call Hloop_AQ_Z(ntryL,G1H16(228),ex1(:),G1H8(266),ngZu,m3h2x8(:,298),heltab2x16(:,:,354))
  call Hloop_AQ_W(ntryL,G1H16(229),ex1(:),G1H8(267),m3h2x8(:,299),heltab2x16(:,:,355))
  call Hloop_QA_S(ntryL,G1H16(234),ex2(:),G1H8(268),ngH,m3h2x8(:,300),heltab2x16(:,:,356))
  call Hloop_QA_S(ntryL,G1H16(235),ex2(:),G1H8(269),ngX,m3h2x8(:,301),heltab2x16(:,:,357))
  call Hloop_QA_S(ntryL,G1H16(236),ex2(:),G1H8(270),ngPtb,m3h2x8(:,302),heltab2x16(:,:,358))
  call Hloop_QA_S(ntryL,G1H16(237),ex2(:),G1H8(271),ngH,m3h2x8(:,303),heltab2x16(:,:,359))
  call Hloop_QA_S(ntryL,G1H16(238),ex2(:),G1H8(272),ngX,m3h2x8(:,304),heltab2x16(:,:,360))
  call Hloop_QA_S(ntryL,G1H16(239),ex2(:),G1H8(273),ngPtb,m3h2x8(:,305),heltab2x16(:,:,361))
  call Hloop_QA_V(ntryL,G1H16(243),ex2(:),G1H8(274),m3h2x8(:,306),heltab2x16(:,:,362))
  call Hloop_QA_Z(ntryL,G1H16(241),ex2(:),G1H8(275),ngZu,m3h2x8(:,307),heltab2x16(:,:,363))
  call Hloop_QA_W(ntryL,G1H16(242),ex2(:),G1H8(276),m3h2x8(:,308),heltab2x16(:,:,364))
  call Hloop_QA_V(ntryL,G1H16(247),ex2(:),G1H8(277),m3h2x8(:,309),heltab2x16(:,:,365))
  call Hloop_QA_Z(ntryL,G1H16(245),ex2(:),G1H8(278),ngZu,m3h2x8(:,310),heltab2x16(:,:,366))
  call Hloop_QA_W(ntryL,G1H16(246),ex2(:),G1H8(279),m3h2x8(:,311),heltab2x16(:,:,367))
  call Hloop_QA_S(ntryL,G1H16(254),ex2(:),G1H8(280),ngH,m3h2x8(:,312),heltab2x16(:,:,368))
  call Hloop_QA_S(ntryL,G1H16(255),ex2(:),G1H8(281),ngX,m3h2x8(:,313),heltab2x16(:,:,369))
  call Hloop_QA_S(ntryL,G1H16(256),ex2(:),G1H8(282),ngPtb,m3h2x8(:,314),heltab2x16(:,:,370))
  call Hloop_QA_S(ntryL,G1H16(251),ex2(:),G1H8(283),ngH,m3h2x8(:,315),heltab2x16(:,:,371))
  call Hloop_QA_S(ntryL,G1H16(252),ex2(:),G1H8(284),ngX,m3h2x8(:,316),heltab2x16(:,:,372))
  call Hloop_QA_S(ntryL,G1H16(253),ex2(:),G1H8(285),ngPtb,m3h2x8(:,317),heltab2x16(:,:,373))
  call Hloop_QA_V(ntryL,G1H16(265),ex2(:),G1H8(286),m3h2x8(:,318),heltab2x16(:,:,374))
  call Hloop_QA_Z(ntryL,G1H16(266),ex2(:),G1H8(287),ngZu,m3h2x8(:,319),heltab2x16(:,:,375))
  call Hloop_QA_W(ntryL,G1H16(267),ex2(:),G1H8(288),m3h2x8(:,320),heltab2x16(:,:,376))
  call Hloop_QA_V(ntryL,G1H16(264),ex2(:),G1H8(289),m3h2x8(:,321),heltab2x16(:,:,377))
  call Hloop_QA_Z(ntryL,G1H16(262),ex2(:),G1H8(290),ngZu,m3h2x8(:,322),heltab2x16(:,:,378))
  call Hloop_QA_W(ntryL,G1H16(263),ex2(:),G1H8(291),m3h2x8(:,323),heltab2x16(:,:,379))
  call Hloop_AQ_S(ntryL,G1H16(268),ex1(:),G1H8(292),ngH,m3h2x8(:,324),heltab2x16(:,:,380))
  call Hloop_AQ_S(ntryL,G1H16(269),ex1(:),G1H8(293),ngX,m3h2x8(:,325),heltab2x16(:,:,381))
  call Hloop_AQ_S(ntryL,G1H16(270),ex1(:),G1H8(294),ngPbt,m3h2x8(:,326),heltab2x16(:,:,382))
  call Hloop_AQ_S(ntryL,G1H16(271),ex1(:),G1H8(295),ngH,m3h2x8(:,327),heltab2x16(:,:,383))
  call Hloop_AQ_S(ntryL,G1H16(272),ex1(:),G1H8(296),ngX,m3h2x8(:,328),heltab2x16(:,:,384))
  call Hloop_AQ_S(ntryL,G1H16(273),ex1(:),G1H8(297),ngX,m3h2x8(:,329),heltab2x16(:,:,385))
  call Hloop_AQ_S(ntryL,G1H16(274),ex1(:),G1H8(298),ngPbt,m3h2x8(:,330),heltab2x16(:,:,386))
  call Hloop_AQ_S(ntryL,G1H16(275),ex1(:),G1H8(299),ngH,m3h2x8(:,331),heltab2x16(:,:,387))
  call Hloop_AQ_S(ntryL,G1H16(276),ex1(:),G1H8(300),ngPbt,m3h2x8(:,332),heltab2x16(:,:,388))
  call Hloop_AQ_Z(ntryL,G1H16(277),ex1(:),G1H8(301),ngZu,m3h2x8(:,333),heltab2x16(:,:,389))
  call Hloop_AQ_W(ntryL,G1H16(278),ex1(:),G1H8(302),m3h2x8(:,334),heltab2x16(:,:,390))
  call Hloop_AQ_Z(ntryL,G1H16(279),ex1(:),G1H8(303),ngZu,m3h2x8(:,335),heltab2x16(:,:,391))
  call Hloop_AQ_W(ntryL,G1H16(280),ex1(:),G1H8(304),m3h2x8(:,336),heltab2x16(:,:,392))
  call Hloop_AQ_Z(ntryL,G1H16(281),ex1(:),G1H8(305),ngZu,m3h2x8(:,337),heltab2x16(:,:,393))
  call Hloop_AQ_W(ntryL,G1H16(282),ex1(:),G1H8(306),m3h2x8(:,338),heltab2x16(:,:,394))
  call Hloop_VQ_A(ntryL,G1H16(283),ex1(:),G1H8(307),m3h2x8(:,339),heltab2x16(:,:,395))
  call Hloop_Q_A(ntryL,G1H8(307),17,nMT,G2H8(9),n2h8(217))
  call Hloop_VQ_A(ntryL,G1H16(284),ex1(:),G1H8(307),m3h2x8(:,340),heltab2x16(:,:,396))
  call Hloop_Q_A(ntryL,G1H8(307),17,nMT,G2H8(10),n2h8(218))
  call Hloop_AQ_S(ntryL,G1H16(285),ex1(:),G1H8(307),ngPbt,m3h2x8(:,341),heltab2x16(:,:,397))
  call Hloop_AQ_S(ntryL,G1H16(286),ex1(:),G1H8(308),ngH,m3h2x8(:,342),heltab2x16(:,:,398))
  call Hloop_AQ_S(ntryL,G1H16(287),ex1(:),G1H8(309),ngX,m3h2x8(:,343),heltab2x16(:,:,399))
  call Hloop_AQ_S(ntryL,G1H16(288),ex1(:),G1H8(310),ngPbt,m3h2x8(:,344),heltab2x16(:,:,400))
  call Hloop_AQ_S(ntryL,G1H16(289),ex1(:),G1H8(311),ngPbt,m3h2x8(:,345),heltab2x16(:,:,401))
  call Hloop_AQ_S(ntryL,G1H16(290),ex1(:),G1H8(312),ngH,m3h2x8(:,346),heltab2x16(:,:,402))
  call Hloop_AQ_S(ntryL,G1H16(291),ex1(:),G1H8(313),ngPbt,m3h2x8(:,347),heltab2x16(:,:,403))
  call Hloop_AQ_W(ntryL,G1H16(292),ex1(:),G1H8(314),m3h2x8(:,348),heltab2x16(:,:,404))
  call Hloop_AQ_Z(ntryL,G1H16(293),ex1(:),G1H8(315),ngZu,m3h2x8(:,349),heltab2x16(:,:,405))
  call Hloop_AQ_W(ntryL,G1H16(294),ex1(:),G1H8(316),m3h2x8(:,350),heltab2x16(:,:,406))
  call Hloop_AQ_W(ntryL,G1H16(295),ex1(:),G1H8(317),m3h2x8(:,351),heltab2x16(:,:,407))
  call Hloop_AQ_W(ntryL,G1H16(296),ex1(:),G1H8(318),m3h2x8(:,352),heltab2x16(:,:,408))
  call Hloop_VQ_A(ntryL,G1H16(297),ex1(:),G1H8(319),m3h2x8(:,353),heltab2x16(:,:,409))
  call Hloop_Q_A(ntryL,G1H8(319),17,nMT,G2H8(11),n2h8(219))
  call Hloop_VQ_A(ntryL,G1H16(298),ex1(:),G1H8(319),m3h2x8(:,354),heltab2x16(:,:,410))
  call Hloop_Q_A(ntryL,G1H8(319),17,nMT,G2H8(12),n2h8(220))
  call Hloop_SQ_A(ntryL,G0H8(1),ex3(:),G0H4(1),ngPtb,m3h2x4(:,161),heltab2x8(:,:,161))
  call Hloop_Q_A(ntryL,G0H4(1),21,nMT,G1H4(85),n2h4(217))
  call Hloop_SQ_A(ntryL,G0H8(2),ex3(:),G0H4(1),ngH,m3h2x4(:,162),heltab2x8(:,:,162))
  call Hloop_Q_A(ntryL,G0H4(1),21,nMB,G1H4(86),n2h4(218))
  call Hloop_SQ_A(ntryL,G0H8(3),ex3(:),G0H4(1),ngPtb,m3h2x4(:,163),heltab2x8(:,:,163))
  call Hloop_Q_A(ntryL,G0H4(1),21,nMT,G1H4(89),n2h4(219))
  call Hloop_SQ_A(ntryL,G0H8(4),ex3(:),G0H4(1),ngX,m3h2x4(:,164),heltab2x8(:,:,164))
  call Hloop_Q_A(ntryL,G0H4(1),21,nMB,G1H4(90),n2h4(220))
  call Hloop_VQ_A(ntryL,G0H8(9),ex3(:),G0H4(1),m3h2x4(:,165),heltab2x8(:,:,165))
  call Hloop_Q_A(ntryL,G0H4(1),21,nMB,G1H4(91),n2h4(221))
  call Hloop_ZQ_A(ntryL,G0H8(6),ex3(:),G0H4(1),ngZd,m3h2x4(:,166),heltab2x8(:,:,166))
  call Hloop_Q_A(ntryL,G0H4(1),21,nMB,G1H4(92),n2h4(222))
  call Hloop_WQ_A(ntryL,G0H8(7),ex3(:),G0H4(1),m3h2x4(:,167),heltab2x8(:,:,167))
  call Hloop_Q_A(ntryL,G0H4(1),21,nMT,G1H4(95),n2h4(223))
  call Hloop_WQ_A(ntryL,G0H8(8),ex3(:),G0H4(1),m3h2x4(:,168),heltab2x8(:,:,168))
  call Hloop_Q_A(ntryL,G0H4(1),21,nMT,G1H4(96),n2h4(224))
  call Hloop_SQ_A(ntryL,G0H8(14),ex3(:),G0H4(1),ngPtb,m3h2x4(:,169),heltab2x8(:,:,169))
  call Hloop_Q_A(ntryL,G0H4(1),21,nMT,G1H4(97),n2h4(225))
  call Hloop_SQ_A(ntryL,G0H8(11),ex3(:),G0H4(1),ngPtb,m3h2x4(:,170),heltab2x8(:,:,170))
  call Hloop_Q_A(ntryL,G0H4(1),21,nMT,G1H4(98),n2h4(226))
  call Hloop_SQ_A(ntryL,G0H8(12),ex3(:),G0H4(1),ngH,m3h2x4(:,171),heltab2x8(:,:,171))
  call Hloop_Q_A(ntryL,G0H4(1),21,nMB,G1H4(101),n2h4(227))
  call Hloop_SQ_A(ntryL,G0H8(13),ex3(:),G0H4(1),ngX,m3h2x4(:,172),heltab2x8(:,:,172))
  call Hloop_Q_A(ntryL,G0H4(1),21,nMB,G1H4(102),n2h4(228))
  call Hloop_WQ_A(ntryL,G0H8(19),ex3(:),G0H4(1),m3h2x4(:,173),heltab2x8(:,:,173))
  call Hloop_Q_A(ntryL,G0H4(1),21,nMT,G1H4(103),n2h4(229))
  call Hloop_VQ_A(ntryL,G0H8(20),ex3(:),G0H4(1),m3h2x4(:,174),heltab2x8(:,:,174))
  call Hloop_Q_A(ntryL,G0H4(1),21,nMB,G1H4(104),n2h4(230))
  call Hloop_WQ_A(ntryL,G0H8(17),ex3(:),G0H4(1),m3h2x4(:,175),heltab2x8(:,:,175))
  call Hloop_Q_A(ntryL,G0H4(1),21,nMT,G1H4(107),n2h4(231))
  call Hloop_ZQ_A(ntryL,G0H8(18),ex3(:),G0H4(1),ngZd,m3h2x4(:,176),heltab2x8(:,:,176))
  call Hloop_Q_A(ntryL,G0H4(1),21,nMB,G1H4(108),n2h4(232))
  call Hloop_SA_Q(ntryL,G0H8(21),ex2(:),G0H4(1),ngH,m3h2x4(:,177),heltab2x8(:,:,177))
  call Hloop_A_Q(ntryL,G0H4(1),19,nMT,G1H4(109),n2h4(233))
  call Hloop_SA_Q(ntryL,G0H8(22),ex2(:),G0H4(1),ngPtb,m3h2x4(:,178),heltab2x8(:,:,178))
  call Hloop_A_Q(ntryL,G0H4(1),19,nMB,G1H4(110),n2h4(234))
  call Hloop_SA_Q(ntryL,G0H8(23),ex2(:),G0H4(1),ngX,m3h2x4(:,179),heltab2x8(:,:,179))
  call Hloop_A_Q(ntryL,G0H4(1),19,nMT,G1H4(113),n2h4(235))
  call Hloop_SA_Q(ntryL,G0H8(24),ex2(:),G0H4(1),ngPtb,m3h2x4(:,180),heltab2x8(:,:,180))
  call Hloop_A_Q(ntryL,G0H4(1),19,nMB,G1H4(114),n2h4(236))
  call Hloop_QA_S(ntryL,G1H8(137),ex2(:),G1H4(115),ngH,m3h2x4(:,181),heltab2x8(:,:,181))
  call Hloop_QA_S(ntryL,G1H8(1),ex2(:),G1H4(116),ngH,m3h2x4(:,182),heltab2x8(:,:,182))
  call Hloop_QA_S(ntryL,G1H8(2),ex2(:),G1H4(119),ngX,m3h2x4(:,183),heltab2x8(:,:,183))
  call Hloop_QA_S(ntryL,G1H8(3),ex2(:),G1H4(120),ngX,m3h2x4(:,184),heltab2x8(:,:,184))
  call Hloop_SA_Q(ntryL,G0H8(29),ex2(:),G0H4(1),ngPtb,m3h2x4(:,185),heltab2x8(:,:,185))
  call Hloop_A_Q(ntryL,G0H4(1),19,nMB,G1H4(121),n2h4(237))
  call Hloop_SA_Q(ntryL,G0H8(26),ex2(:),G0H4(1),ngPtb,m3h2x4(:,186),heltab2x8(:,:,186))
  call Hloop_A_Q(ntryL,G0H4(1),19,nMB,G1H4(122),n2h4(238))
  call Hloop_SA_Q(ntryL,G0H8(27),ex2(:),G0H4(1),ngH,m3h2x4(:,187),heltab2x8(:,:,187))
  call Hloop_A_Q(ntryL,G0H4(1),19,nMT,G1H4(125),n2h4(239))
  call Hloop_SA_Q(ntryL,G0H8(28),ex2(:),G0H4(1),ngX,m3h2x4(:,188),heltab2x8(:,:,188))
  call Hloop_A_Q(ntryL,G0H4(1),19,nMT,G1H4(126),n2h4(240))
  call Hloop_VA_Q(ntryL,G0H8(34),ex2(:),G0H4(1),m3h2x4(:,189),heltab2x8(:,:,189))
  call Hloop_A_Q(ntryL,G0H4(1),19,nMT,G1H4(127),n2h4(241))
  call Hloop_ZA_Q(ntryL,G0H8(31),ex2(:),G0H4(1),ngZu,m3h2x4(:,190),heltab2x8(:,:,190))
  call Hloop_A_Q(ntryL,G0H4(1),19,nMT,G1H4(128),n2h4(242))
  call Hloop_WA_Q(ntryL,G0H8(32),ex2(:),G0H4(1),m3h2x4(:,191),heltab2x8(:,:,191))
  call Hloop_A_Q(ntryL,G0H4(1),19,nMB,G1H4(131),n2h4(243))
  call Hloop_WA_Q(ntryL,G0H8(33),ex2(:),G0H4(1),m3h2x4(:,192),heltab2x8(:,:,192))
  call Hloop_A_Q(ntryL,G0H4(1),19,nMB,G1H4(132),n2h4(244))
  call Hloop_QA_S(ntryL,G1H8(8),ex2(:),G1H4(133),ngH,m3h2x4(:,193),heltab2x8(:,:,193))
  call Hloop_QA_S(ntryL,G1H8(9),ex2(:),G1H4(134),ngX,m3h2x4(:,194),heltab2x8(:,:,194))
  call Hloop_QA_S(ntryL,G1H8(6),ex2(:),G1H4(137),ngH,m3h2x4(:,195),heltab2x8(:,:,195))
  call Hloop_QA_S(ntryL,G1H8(7),ex2(:),G1H4(138),ngX,m3h2x4(:,196),heltab2x8(:,:,196))
  call Hloop_QA_V(ntryL,G1H8(14),ex2(:),G1H4(139),m3h2x4(:,197),heltab2x8(:,:,197))
  call Hloop_QA_V(ntryL,G1H8(15),ex2(:),G1H4(140),m3h2x4(:,198),heltab2x8(:,:,198))
  call Hloop_QA_Z(ntryL,G1H8(12),ex2(:),G1H4(143),ngZu,m3h2x4(:,199),heltab2x8(:,:,199))
  call Hloop_QA_Z(ntryL,G1H8(13),ex2(:),G1H4(144),ngZu,m3h2x4(:,200),heltab2x8(:,:,200))
  call Hloop_VA_Q(ntryL,G0H8(39),ex2(:),G0H4(1),m3h2x4(:,201),heltab2x8(:,:,201))
  call Hloop_A_Q(ntryL,G0H4(1),19,nMT,G1H4(1),n2h4(245))
  call Hloop_WA_Q(ntryL,G0H8(40),ex2(:),G0H4(1),m3h2x4(:,202),heltab2x8(:,:,202))
  call Hloop_A_Q(ntryL,G0H4(1),19,nMB,G1H4(2),n2h4(246))
  call Hloop_ZA_Q(ntryL,G0H8(37),ex2(:),G0H4(1),ngZu,m3h2x4(:,203),heltab2x8(:,:,203))
  call Hloop_A_Q(ntryL,G0H4(1),19,nMT,G1H4(5),n2h4(247))
  call Hloop_WA_Q(ntryL,G0H8(38),ex2(:),G0H4(1),m3h2x4(:,204),heltab2x8(:,:,204))
  call Hloop_A_Q(ntryL,G0H4(1),19,nMB,G1H4(6),n2h4(248))
  call Hloop_QA_V(ntryL,G1H8(21),ex2(:),G1H4(7),m3h2x4(:,205),heltab2x8(:,:,205))
  call Hloop_QA_V(ntryL,G1H8(23),ex2(:),G1H4(8),m3h2x4(:,206),heltab2x8(:,:,206))
  call Hloop_QA_Z(ntryL,G1H8(22),ex2(:),G1H4(11),ngZu,m3h2x4(:,207),heltab2x8(:,:,207))
  call Hloop_QA_Z(ntryL,G1H8(19),ex2(:),G1H4(12),ngZu,m3h2x4(:,208),heltab2x8(:,:,208))
  call Hloop_QA_S(ntryL,G1H8(24),ex2(:),G1H4(13),ngH,m3h2x4(:,209),heltab2x8(:,:,209))
  call Hloop_QA_S(ntryL,G1H8(25),ex2(:),G1H4(14),ngH,m3h2x4(:,210),heltab2x8(:,:,210))
  call Hloop_QA_S(ntryL,G1H8(26),ex2(:),G1H4(17),ngX,m3h2x4(:,211),heltab2x8(:,:,211))
  call Hloop_QA_S(ntryL,G1H8(27),ex2(:),G1H4(18),ngX,m3h2x4(:,212),heltab2x8(:,:,212))
  call Hloop_QA_S(ntryL,G1H8(28),ex2(:),G1H4(19),ngPtb,m3h2x4(:,213),heltab2x8(:,:,213))
  call Hloop_QA_S(ntryL,G1H8(34),ex2(:),G1H4(20),ngH,m3h2x4(:,214),heltab2x8(:,:,214))
  call Hloop_QA_S(ntryL,G1H8(35),ex2(:),G1H4(23),ngX,m3h2x4(:,215),heltab2x8(:,:,215))
  call Hloop_QA_S(ntryL,G1H8(31),ex2(:),G1H4(24),ngH,m3h2x4(:,216),heltab2x8(:,:,216))
  call Hloop_QA_S(ntryL,G1H8(32),ex2(:),G1H4(25),ngX,m3h2x4(:,217),heltab2x8(:,:,217))
  call Hloop_QA_S(ntryL,G1H8(33),ex2(:),G1H4(26),ngPtb,m3h2x4(:,218),heltab2x8(:,:,218))
  call Hloop_QA_V(ntryL,G1H8(41),ex2(:),G1H4(29),m3h2x4(:,219),heltab2x8(:,:,219))
  call Hloop_QA_V(ntryL,G1H8(42),ex2(:),G1H4(30),m3h2x4(:,220),heltab2x8(:,:,220))
  call Hloop_QA_Z(ntryL,G1H8(38),ex2(:),G1H4(31),ngZu,m3h2x4(:,221),heltab2x8(:,:,221))
  call Hloop_QA_Z(ntryL,G1H8(39),ex2(:),G1H4(32),ngZu,m3h2x4(:,222),heltab2x8(:,:,222))
  call Hloop_QA_W(ntryL,G1H8(40),ex2(:),G1H4(35),m3h2x4(:,223),heltab2x8(:,:,223))
  call Hloop_QA_V(ntryL,G1H8(49),ex2(:),G1H4(36),m3h2x4(:,224),heltab2x8(:,:,224))
  call Hloop_QA_V(ntryL,G1H8(51),ex2(:),G1H4(37),m3h2x4(:,225),heltab2x8(:,:,225))
  call Hloop_QA_Z(ntryL,G1H8(50),ex2(:),G1H4(38),ngZu,m3h2x4(:,226),heltab2x8(:,:,226))
  call Hloop_QA_Z(ntryL,G1H8(46),ex2(:),G1H4(41),ngZu,m3h2x4(:,227),heltab2x8(:,:,227))
  call Hloop_QA_W(ntryL,G1H8(47),ex2(:),G1H4(42),m3h2x4(:,228),heltab2x8(:,:,228))
  call Hloop_AQ_S(ntryL,G1H8(52),ex3(:),G1H4(43),ngH,m3h2x4(:,229),heltab2x8(:,:,229))
  call Hloop_AQ_S(ntryL,G1H8(53),ex3(:),G1H4(44),ngPtb,m3h2x4(:,230),heltab2x8(:,:,230))
  call Hloop_AQ_S(ntryL,G1H8(54),ex3(:),G1H4(47),ngX,m3h2x4(:,231),heltab2x8(:,:,231))
  call Hloop_AQ_S(ntryL,G1H8(55),ex3(:),G1H4(48),ngPtb,m3h2x4(:,232),heltab2x8(:,:,232))
  call Hloop_AQ_S(ntryL,G1H8(60),ex3(:),G1H4(49),ngPtb,m3h2x4(:,233),heltab2x8(:,:,233))
  call Hloop_AQ_S(ntryL,G1H8(57),ex3(:),G1H4(50),ngPtb,m3h2x4(:,234),heltab2x8(:,:,234))
  call Hloop_AQ_S(ntryL,G1H8(58),ex3(:),G1H4(53),ngH,m3h2x4(:,235),heltab2x8(:,:,235))
  call Hloop_AQ_S(ntryL,G1H8(59),ex3(:),G1H4(54),ngX,m3h2x4(:,236),heltab2x8(:,:,236))
  call Hloop_AQ_V(ntryL,G1H8(65),ex3(:),G1H4(55),m3h2x4(:,237),heltab2x8(:,:,237))
  call Hloop_AQ_Z(ntryL,G1H8(62),ex3(:),G1H4(56),ngZd,m3h2x4(:,238),heltab2x8(:,:,238))
  call Hloop_AQ_W(ntryL,G1H8(63),ex3(:),G1H4(59),m3h2x4(:,239),heltab2x8(:,:,239))
  call Hloop_AQ_W(ntryL,G1H8(64),ex3(:),G1H4(60),m3h2x4(:,240),heltab2x8(:,:,240))
  call Hloop_AQ_V(ntryL,G1H8(71),ex3(:),G1H4(61),m3h2x4(:,241),heltab2x8(:,:,241))
  call Hloop_AQ_W(ntryL,G1H8(70),ex3(:),G1H4(62),m3h2x4(:,242),heltab2x8(:,:,242))
  call Hloop_AQ_Z(ntryL,G1H8(68),ex3(:),G1H4(65),ngZd,m3h2x4(:,243),heltab2x8(:,:,243))
  call Hloop_AQ_W(ntryL,G1H8(69),ex3(:),G1H4(66),m3h2x4(:,244),heltab2x8(:,:,244))
  call Hloop_AQ_S(ntryL,G1H8(72),ex1(:),G1H4(67),ngH,m3h2x4(:,245),heltab2x8(:,:,245))
  call Hloop_AQ_S(ntryL,G1H8(73),ex1(:),G1H4(68),ngH,m3h2x4(:,246),heltab2x8(:,:,246))
  call Hloop_AQ_S(ntryL,G1H8(74),ex1(:),G1H4(71),ngX,m3h2x4(:,247),heltab2x8(:,:,247))
  call Hloop_AQ_S(ntryL,G1H8(75),ex1(:),G1H4(72),ngX,m3h2x4(:,248),heltab2x8(:,:,248))
  call Hloop_AQ_S(ntryL,G1H8(76),ex1(:),G1H4(73),ngPbt,m3h2x4(:,249),heltab2x8(:,:,249))
  call Hloop_AQ_S(ntryL,G1H8(82),ex1(:),G1H4(74),ngH,m3h2x4(:,250),heltab2x8(:,:,250))
  call Hloop_AQ_S(ntryL,G1H8(83),ex1(:),G1H4(77),ngX,m3h2x4(:,251),heltab2x8(:,:,251))
  call Hloop_AQ_S(ntryL,G1H8(79),ex1(:),G1H4(78),ngH,m3h2x4(:,252),heltab2x8(:,:,252))
  call Hloop_AQ_S(ntryL,G1H8(80),ex1(:),G1H4(79),ngX,m3h2x4(:,253),heltab2x8(:,:,253))
  call Hloop_AQ_S(ntryL,G1H8(81),ex1(:),G1H4(80),ngPbt,m3h2x4(:,254),heltab2x8(:,:,254))
  call Hloop_AQ_V(ntryL,G1H8(89),ex1(:),G1H4(83),m3h2x4(:,255),heltab2x8(:,:,255))
  call Hloop_AQ_V(ntryL,G1H8(90),ex1(:),G1H4(84),m3h2x4(:,256),heltab2x8(:,:,256))
  call Hloop_AQ_Z(ntryL,G1H8(86),ex1(:),G1H4(145),ngZu,m3h2x4(:,257),heltab2x8(:,:,257))
  call Hloop_AQ_Z(ntryL,G1H8(87),ex1(:),G1H4(146),ngZu,m3h2x4(:,258),heltab2x8(:,:,258))
  call Hloop_AQ_W(ntryL,G1H8(88),ex1(:),G1H4(147),m3h2x4(:,259),heltab2x8(:,:,259))
  call Hloop_AQ_V(ntryL,G1H8(97),ex1(:),G1H4(148),m3h2x4(:,260),heltab2x8(:,:,260))
  call Hloop_AQ_V(ntryL,G1H8(99),ex1(:),G1H4(149),m3h2x4(:,261),heltab2x8(:,:,261))
  call Hloop_AQ_Z(ntryL,G1H8(98),ex1(:),G1H4(150),ngZu,m3h2x4(:,262),heltab2x8(:,:,262))
  call Hloop_AQ_Z(ntryL,G1H8(94),ex1(:),G1H4(151),ngZu,m3h2x4(:,263),heltab2x8(:,:,263))
  call Hloop_AQ_W(ntryL,G1H8(95),ex1(:),G1H4(152),m3h2x4(:,264),heltab2x8(:,:,264))
  call Hloop_SQ_A(ntryL,G0H8(41),ex1(:),G0H4(1),ngH,m3h2x4(:,265),heltab2x8(:,:,265))
  call Hloop_Q_A(ntryL,G0H4(1),19,nMT,G1H4(153),n2h4(249))
  call Hloop_SQ_A(ntryL,G0H8(42),ex1(:),G0H4(1),ngPbt,m3h2x4(:,266),heltab2x8(:,:,266))
  call Hloop_Q_A(ntryL,G0H4(1),19,nMB,G1H4(154),n2h4(250))
  call Hloop_SQ_A(ntryL,G0H8(43),ex1(:),G0H4(1),ngX,m3h2x4(:,267),heltab2x8(:,:,267))
  call Hloop_Q_A(ntryL,G0H4(1),19,nMT,G1H4(155),n2h4(251))
  call Hloop_SQ_A(ntryL,G0H8(44),ex1(:),G0H4(1),ngPbt,m3h2x4(:,268),heltab2x8(:,:,268))
  call Hloop_Q_A(ntryL,G0H4(1),19,nMB,G1H4(156),n2h4(252))
  call Hloop_AQ_S(ntryL,G1H8(100),ex1(:),G1H4(157),ngH,m3h2x4(:,269),heltab2x8(:,:,269))
  call Hloop_AQ_S(ntryL,G1H8(101),ex1(:),G1H4(158),ngH,m3h2x4(:,270),heltab2x8(:,:,270))
  call Hloop_AQ_S(ntryL,G1H8(102),ex1(:),G1H4(159),ngX,m3h2x4(:,271),heltab2x8(:,:,271))
  call Hloop_AQ_S(ntryL,G1H8(103),ex1(:),G1H4(160),ngX,m3h2x4(:,272),heltab2x8(:,:,272))
  call Hloop_SQ_A(ntryL,G0H8(49),ex1(:),G0H4(1),ngPbt,m3h2x4(:,273),heltab2x8(:,:,273))
  call Hloop_Q_A(ntryL,G0H4(1),19,nMB,G1H4(161),n2h4(253))
  call Hloop_SQ_A(ntryL,G0H8(46),ex1(:),G0H4(1),ngPbt,m3h2x4(:,274),heltab2x8(:,:,274))
  call Hloop_Q_A(ntryL,G0H4(1),19,nMB,G1H4(162),n2h4(254))
  call Hloop_SQ_A(ntryL,G0H8(47),ex1(:),G0H4(1),ngH,m3h2x4(:,275),heltab2x8(:,:,275))
  call Hloop_Q_A(ntryL,G0H4(1),19,nMT,G1H4(163),n2h4(255))
  call Hloop_SQ_A(ntryL,G0H8(48),ex1(:),G0H4(1),ngX,m3h2x4(:,276),heltab2x8(:,:,276))
  call Hloop_Q_A(ntryL,G0H4(1),19,nMT,G1H4(164),n2h4(256))
  call Hloop_VQ_A(ntryL,G0H8(54),ex1(:),G0H4(1),m3h2x4(:,277),heltab2x8(:,:,277))
  call Hloop_Q_A(ntryL,G0H4(1),19,nMT,G1H4(165),n2h4(257))
  call Hloop_ZQ_A(ntryL,G0H8(51),ex1(:),G0H4(1),ngZu,m3h2x4(:,278),heltab2x8(:,:,278))
  call Hloop_Q_A(ntryL,G0H4(1),19,nMT,G1H4(166),n2h4(258))
  call Hloop_WQ_A(ntryL,G0H8(52),ex1(:),G0H4(1),m3h2x4(:,279),heltab2x8(:,:,279))
  call Hloop_Q_A(ntryL,G0H4(1),19,nMB,G1H4(167),n2h4(259))
  call Hloop_WQ_A(ntryL,G0H8(53),ex1(:),G0H4(1),m3h2x4(:,280),heltab2x8(:,:,280))
  call Hloop_Q_A(ntryL,G0H4(1),19,nMB,G1H4(168),n2h4(260))
  call Hloop_AQ_S(ntryL,G1H8(108),ex1(:),G1H4(169),ngH,m3h2x4(:,281),heltab2x8(:,:,281))
  call Hloop_AQ_S(ntryL,G1H8(109),ex1(:),G1H4(170),ngX,m3h2x4(:,282),heltab2x8(:,:,282))
  call Hloop_AQ_S(ntryL,G1H8(106),ex1(:),G1H4(171),ngH,m3h2x4(:,283),heltab2x8(:,:,283))
  call Hloop_AQ_S(ntryL,G1H8(107),ex1(:),G1H4(172),ngX,m3h2x4(:,284),heltab2x8(:,:,284))
  call Hloop_AQ_V(ntryL,G1H8(114),ex1(:),G1H4(173),m3h2x4(:,285),heltab2x8(:,:,285))
  call Hloop_AQ_V(ntryL,G1H8(115),ex1(:),G1H4(174),m3h2x4(:,286),heltab2x8(:,:,286))
  call Hloop_AQ_Z(ntryL,G1H8(112),ex1(:),G1H4(175),ngZu,m3h2x4(:,287),heltab2x8(:,:,287))
  call Hloop_AQ_Z(ntryL,G1H8(113),ex1(:),G1H4(176),ngZu,m3h2x4(:,288),heltab2x8(:,:,288))
  call Hloop_VQ_A(ntryL,G0H8(59),ex1(:),G0H4(1),m3h2x4(:,289),heltab2x8(:,:,289))
  call Hloop_Q_A(ntryL,G0H4(1),19,nMT,G1H4(177),n2h4(261))
  call Hloop_WQ_A(ntryL,G0H8(60),ex1(:),G0H4(1),m3h2x4(:,290),heltab2x8(:,:,290))
  call Hloop_Q_A(ntryL,G0H4(1),19,nMB,G1H4(178),n2h4(262))
  call Hloop_ZQ_A(ntryL,G0H8(57),ex1(:),G0H4(1),ngZu,m3h2x4(:,291),heltab2x8(:,:,291))
  call Hloop_Q_A(ntryL,G0H4(1),19,nMT,G1H4(179),n2h4(263))
  call Hloop_WQ_A(ntryL,G0H8(58),ex1(:),G0H4(1),m3h2x4(:,292),heltab2x8(:,:,292))
  call Hloop_Q_A(ntryL,G0H4(1),19,nMB,G1H4(180),n2h4(264))
  call Hloop_AQ_V(ntryL,G1H8(121),ex1(:),G1H4(181),m3h2x4(:,293),heltab2x8(:,:,293))
  call Hloop_AQ_V(ntryL,G1H8(123),ex1(:),G1H4(182),m3h2x4(:,294),heltab2x8(:,:,294))
  call Hloop_AQ_Z(ntryL,G1H8(122),ex1(:),G1H4(183),ngZu,m3h2x4(:,295),heltab2x8(:,:,295))
  call Hloop_AQ_Z(ntryL,G1H8(119),ex1(:),G1H4(184),ngZu,m3h2x4(:,296),heltab2x8(:,:,296))
  call Hloop_SA_Q(ntryL,G0H8(61),ex2(:),G0H4(1),ngH,m3h2x4(:,297),heltab2x8(:,:,297))
  call Hloop_A_Q(ntryL,G0H4(1),22,nMT,G1H4(185),n2h4(265))
  call Hloop_SA_Q(ntryL,G0H8(62),ex2(:),G0H4(1),ngX,m3h2x4(:,298),heltab2x8(:,:,298))
  call Hloop_A_Q(ntryL,G0H4(1),22,nMT,G1H4(186),n2h4(266))
  call Hloop_SA_Q(ntryL,G0H8(63),ex2(:),G0H4(1),ngH,m3h2x4(:,299),heltab2x8(:,:,299))
  call Hloop_A_Q(ntryL,G0H4(1),22,nMT,G1H4(187),n2h4(267))
  call Hloop_SA_Q(ntryL,G0H8(64),ex2(:),G0H4(1),ngX,m3h2x4(:,300),heltab2x8(:,:,300))
  call Hloop_A_Q(ntryL,G0H4(1),22,nMT,G1H4(188),n2h4(268))
  call Hloop_QA_S(ntryL,G1H8(124),ex2(:),G1H4(189),ngH,m3h2x4(:,301),heltab2x8(:,:,301))
  call Hloop_QA_S(ntryL,G1H8(125),ex2(:),G1H4(190),ngPtb,m3h2x4(:,302),heltab2x8(:,:,302))
  call Hloop_QA_S(ntryL,G1H8(126),ex2(:),G1H4(191),ngX,m3h2x4(:,303),heltab2x8(:,:,303))
  call Hloop_QA_S(ntryL,G1H8(127),ex2(:),G1H4(192),ngPtb,m3h2x4(:,304),heltab2x8(:,:,304))
  call Hloop_VA_Q(ntryL,G0H8(69),ex2(:),G0H4(1),m3h2x4(:,305),heltab2x8(:,:,305))
  call Hloop_A_Q(ntryL,G0H4(1),22,nMT,G1H4(193),n2h4(269))
  call Hloop_VA_Q(ntryL,G0H8(70),ex2(:),G0H4(1),m3h2x4(:,306),heltab2x8(:,:,306))
  call Hloop_A_Q(ntryL,G0H4(1),22,nMT,G1H4(194),n2h4(270))
  call Hloop_ZA_Q(ntryL,G0H8(67),ex2(:),G0H4(1),ngZu,m3h2x4(:,307),heltab2x8(:,:,307))
  call Hloop_A_Q(ntryL,G0H4(1),22,nMT,G1H4(195),n2h4(271))
  call Hloop_ZA_Q(ntryL,G0H8(68),ex2(:),G0H4(1),ngZu,m3h2x4(:,308),heltab2x8(:,:,308))
  call Hloop_A_Q(ntryL,G0H4(1),22,nMT,G1H4(196),n2h4(272))
  call Hloop_SA_Q(ntryL,G0H8(75),ex2(:),G0H4(1),ngH,m3h2x4(:,309),heltab2x8(:,:,309))
  call Hloop_A_Q(ntryL,G0H4(1),22,nMT,G1H4(197),n2h4(273))
  call Hloop_SA_Q(ntryL,G0H8(76),ex2(:),G0H4(1),ngX,m3h2x4(:,310),heltab2x8(:,:,310))
  call Hloop_A_Q(ntryL,G0H4(1),22,nMT,G1H4(198),n2h4(274))
  call Hloop_SA_Q(ntryL,G0H8(73),ex2(:),G0H4(1),ngH,m3h2x4(:,311),heltab2x8(:,:,311))
  call Hloop_A_Q(ntryL,G0H4(1),22,nMT,G1H4(199),n2h4(275))
  call Hloop_SA_Q(ntryL,G0H8(74),ex2(:),G0H4(1),ngX,m3h2x4(:,312),heltab2x8(:,:,312))
  call Hloop_A_Q(ntryL,G0H4(1),22,nMT,G1H4(200),n2h4(276))
  call Hloop_QA_S(ntryL,G1H8(132),ex2(:),G1H4(201),ngPtb,m3h2x4(:,313),heltab2x8(:,:,313))
  call Hloop_QA_S(ntryL,G1H8(129),ex2(:),G1H4(202),ngPtb,m3h2x4(:,314),heltab2x8(:,:,314))
  call Hloop_QA_S(ntryL,G1H8(130),ex2(:),G1H4(203),ngH,m3h2x4(:,315),heltab2x8(:,:,315))
  call Hloop_QA_S(ntryL,G1H8(131),ex2(:),G1H4(204),ngX,m3h2x4(:,316),heltab2x8(:,:,316))
  call Hloop_QA_V(ntryL,G1H8(138),ex2(:),G1H4(205),m3h2x4(:,317),heltab2x8(:,:,317))
  call Hloop_QA_Z(ntryL,G1H8(134),ex2(:),G1H4(206),ngZu,m3h2x4(:,318),heltab2x8(:,:,318))
  call Hloop_QA_W(ntryL,G1H8(135),ex2(:),G1H4(207),m3h2x4(:,319),heltab2x8(:,:,319))
  call Hloop_QA_W(ntryL,G1H8(136),ex2(:),G1H4(208),m3h2x4(:,320),heltab2x8(:,:,320))
  call Hloop_VA_Q(ntryL,G0H8(82),ex2(:),G0H4(1),m3h2x4(:,321),heltab2x8(:,:,321))
  call Hloop_A_Q(ntryL,G0H4(1),22,nMT,G1H4(209),n2h4(277))
  call Hloop_ZA_Q(ntryL,G0H8(84),ex2(:),G0H4(1),ngZu,m3h2x4(:,322),heltab2x8(:,:,322))
  call Hloop_A_Q(ntryL,G0H4(1),22,nMT,G1H4(210),n2h4(278))
  call Hloop_VA_Q(ntryL,G0H8(83),ex2(:),G0H4(1),m3h2x4(:,323),heltab2x8(:,:,323))
  call Hloop_A_Q(ntryL,G0H4(1),22,nMT,G1H4(211),n2h4(279))
  call Hloop_ZA_Q(ntryL,G0H8(80),ex2(:),G0H4(1),ngZu,m3h2x4(:,324),heltab2x8(:,:,324))
  call Hloop_A_Q(ntryL,G0H4(1),22,nMT,G1H4(212),n2h4(280))
  call Hloop_QA_V(ntryL,G1H8(143),ex2(:),G1H4(213),m3h2x4(:,325),heltab2x8(:,:,325))
  call Hloop_QA_W(ntryL,G1H8(144),ex2(:),G1H4(214),m3h2x4(:,326),heltab2x8(:,:,326))
  call Hloop_QA_Z(ntryL,G1H8(141),ex2(:),G1H4(215),ngZu,m3h2x4(:,327),heltab2x8(:,:,327))
  call Hloop_QA_W(ntryL,G1H8(142),ex2(:),G1H4(216),m3h2x4(:,328),heltab2x8(:,:,328))
  call Hloop_SQ_A(ntryL,G0H8(85),ex1(:),G0H4(1),ngH,m3h2x4(:,329),heltab2x8(:,:,329))
  call Hloop_Q_A(ntryL,G0H4(1),21,nMT,G1H4(217),n2h4(281))
  call Hloop_SQ_A(ntryL,G0H8(86),ex1(:),G0H4(1),ngH,m3h2x4(:,330),heltab2x8(:,:,330))
  call Hloop_Q_A(ntryL,G0H4(1),21,nMT,G1H4(218),n2h4(282))
  call Hloop_SQ_A(ntryL,G0H8(87),ex1(:),G0H4(1),ngX,m3h2x4(:,331),heltab2x8(:,:,331))
  call Hloop_Q_A(ntryL,G0H4(1),21,nMT,G1H4(219),n2h4(283))
  call Hloop_SQ_A(ntryL,G0H8(88),ex1(:),G0H4(1),ngX,m3h2x4(:,332),heltab2x8(:,:,332))
  call Hloop_Q_A(ntryL,G0H4(1),21,nMT,G1H4(220),n2h4(284))
  call Hloop_SQ_A(ntryL,G0H8(89),ex1(:),G0H4(1),ngPbt,m3h2x4(:,333),heltab2x8(:,:,333))
  call Hloop_Q_A(ntryL,G0H4(1),21,nMB,G1H4(221),n2h4(285))
  call Hloop_SQ_A(ntryL,G0H8(95),ex1(:),G0H4(1),ngH,m3h2x4(:,334),heltab2x8(:,:,334))
  call Hloop_Q_A(ntryL,G0H4(1),21,nMT,G1H4(222),n2h4(286))
  call Hloop_SQ_A(ntryL,G0H8(96),ex1(:),G0H4(1),ngX,m3h2x4(:,335),heltab2x8(:,:,335))
  call Hloop_Q_A(ntryL,G0H4(1),21,nMT,G1H4(223),n2h4(287))
  call Hloop_SQ_A(ntryL,G0H8(92),ex1(:),G0H4(1),ngH,m3h2x4(:,336),heltab2x8(:,:,336))
  call Hloop_Q_A(ntryL,G0H4(1),21,nMT,G1H4(224),n2h4(288))
  call Hloop_SQ_A(ntryL,G0H8(93),ex1(:),G0H4(1),ngX,m3h2x4(:,337),heltab2x8(:,:,337))
  call Hloop_Q_A(ntryL,G0H4(1),21,nMT,G1H4(225),n2h4(289))
  call Hloop_SQ_A(ntryL,G0H8(94),ex1(:),G0H4(1),ngPbt,m3h2x4(:,338),heltab2x8(:,:,338))
  call Hloop_Q_A(ntryL,G0H4(1),21,nMB,G1H4(226),n2h4(290))
  call Hloop_VQ_A(ntryL,G0H8(102),ex1(:),G0H4(1),m3h2x4(:,339),heltab2x8(:,:,339))
  call Hloop_Q_A(ntryL,G0H4(1),21,nMT,G1H4(227),n2h4(291))
  call Hloop_VQ_A(ntryL,G0H8(103),ex1(:),G0H4(1),m3h2x4(:,340),heltab2x8(:,:,340))
  call Hloop_Q_A(ntryL,G0H4(1),21,nMT,G1H4(228),n2h4(292))
  call Hloop_ZQ_A(ntryL,G0H8(99),ex1(:),G0H4(1),ngZu,m3h2x4(:,341),heltab2x8(:,:,341))
  call Hloop_Q_A(ntryL,G0H4(1),21,nMT,G1H4(229),n2h4(293))
  call Hloop_ZQ_A(ntryL,G0H8(100),ex1(:),G0H4(1),ngZu,m3h2x4(:,342),heltab2x8(:,:,342))
  call Hloop_Q_A(ntryL,G0H4(1),21,nMT,G1H4(230),n2h4(294))
  call Hloop_WQ_A(ntryL,G0H8(101),ex1(:),G0H4(1),m3h2x4(:,343),heltab2x8(:,:,343))
  call Hloop_Q_A(ntryL,G0H4(1),21,nMB,G1H4(231),n2h4(295))
  call Hloop_VQ_A(ntryL,G0H8(110),ex1(:),G0H4(1),m3h2x4(:,344),heltab2x8(:,:,344))
  call Hloop_Q_A(ntryL,G0H4(1),21,nMT,G1H4(232),n2h4(296))
  call Hloop_VQ_A(ntryL,G0H8(112),ex1(:),G0H4(1),m3h2x4(:,345),heltab2x8(:,:,345))
  call Hloop_Q_A(ntryL,G0H4(1),21,nMT,G1H4(233),n2h4(297))
  call Hloop_ZQ_A(ntryL,G0H8(111),ex1(:),G0H4(1),ngZu,m3h2x4(:,346),heltab2x8(:,:,346))
  call Hloop_Q_A(ntryL,G0H4(1),21,nMT,G1H4(234),n2h4(298))
  call Hloop_ZQ_A(ntryL,G0H8(107),ex1(:),G0H4(1),ngZu,m3h2x4(:,347),heltab2x8(:,:,347))
  call Hloop_Q_A(ntryL,G0H4(1),21,nMT,G1H4(235),n2h4(299))
  call Hloop_WQ_A(ntryL,G0H8(108),ex1(:),G0H4(1),m3h2x4(:,348),heltab2x8(:,:,348))
  call Hloop_Q_A(ntryL,G0H4(1),21,nMB,G1H4(236),n2h4(300))
  call Hloop_SQ_A(ntryL,G0H8(113),ex1(:),G0H4(1),ngH,m3h2x4(:,349),heltab2x8(:,:,349))
  call Hloop_Q_A(ntryL,G0H4(1),21,nMT,G1H4(237),n2h4(301))
  call Hloop_SQ_A(ntryL,G0H8(114),ex1(:),G0H4(1),ngPbt,m3h2x4(:,350),heltab2x8(:,:,350))
  call Hloop_Q_A(ntryL,G0H4(1),21,nMB,G1H4(238),n2h4(302))
  call Hloop_SQ_A(ntryL,G0H8(115),ex1(:),G0H4(1),ngX,m3h2x4(:,351),heltab2x8(:,:,351))
  call Hloop_Q_A(ntryL,G0H4(1),21,nMT,G1H4(239),n2h4(303))
  call Hloop_SQ_A(ntryL,G0H8(116),ex1(:),G0H4(1),ngPbt,m3h2x4(:,352),heltab2x8(:,:,352))
  call Hloop_Q_A(ntryL,G0H4(1),21,nMB,G1H4(240),n2h4(304))
  call Hloop_SQ_A(ntryL,G0H8(121),ex1(:),G0H4(1),ngPbt,m3h2x4(:,353),heltab2x8(:,:,353))
  call Hloop_Q_A(ntryL,G0H4(1),21,nMB,G1H4(241),n2h4(305))
  call Hloop_SQ_A(ntryL,G0H8(118),ex1(:),G0H4(1),ngPbt,m3h2x4(:,354),heltab2x8(:,:,354))
  call Hloop_Q_A(ntryL,G0H4(1),21,nMB,G1H4(242),n2h4(306))
  call Hloop_SQ_A(ntryL,G0H8(119),ex1(:),G0H4(1),ngH,m3h2x4(:,355),heltab2x8(:,:,355))
  call Hloop_Q_A(ntryL,G0H4(1),21,nMT,G1H4(243),n2h4(307))
  call Hloop_SQ_A(ntryL,G0H8(120),ex1(:),G0H4(1),ngX,m3h2x4(:,356),heltab2x8(:,:,356))
  call Hloop_Q_A(ntryL,G0H4(1),21,nMT,G1H4(244),n2h4(308))
  call Hloop_VQ_A(ntryL,G0H8(126),ex1(:),G0H4(1),m3h2x4(:,357),heltab2x8(:,:,357))
  call Hloop_Q_A(ntryL,G0H4(1),21,nMT,G1H4(245),n2h4(309))
  call Hloop_ZQ_A(ntryL,G0H8(123),ex1(:),G0H4(1),ngZu,m3h2x4(:,358),heltab2x8(:,:,358))
  call Hloop_Q_A(ntryL,G0H4(1),21,nMT,G1H4(246),n2h4(310))
  call Hloop_WQ_A(ntryL,G0H8(124),ex1(:),G0H4(1),m3h2x4(:,359),heltab2x8(:,:,359))
  call Hloop_Q_A(ntryL,G0H4(1),21,nMB,G1H4(247),n2h4(311))
  call Hloop_WQ_A(ntryL,G0H8(125),ex1(:),G0H4(1),m3h2x4(:,360),heltab2x8(:,:,360))
  call Hloop_Q_A(ntryL,G0H4(1),21,nMB,G1H4(248),n2h4(312))
  call Hloop_VQ_A(ntryL,G0H8(131),ex1(:),G0H4(1),m3h2x4(:,361),heltab2x8(:,:,361))
  call Hloop_Q_A(ntryL,G0H4(1),21,nMT,G1H4(249),n2h4(313))
  call Hloop_WQ_A(ntryL,G0H8(132),ex1(:),G0H4(1),m3h2x4(:,362),heltab2x8(:,:,362))
  call Hloop_Q_A(ntryL,G0H4(1),21,nMB,G1H4(250),n2h4(314))
  call Hloop_ZQ_A(ntryL,G0H8(129),ex1(:),G0H4(1),ngZu,m3h2x4(:,363),heltab2x8(:,:,363))
  call Hloop_Q_A(ntryL,G0H4(1),21,nMT,G1H4(251),n2h4(315))
  call Hloop_WQ_A(ntryL,G0H8(130),ex1(:),G0H4(1),m3h2x4(:,364),heltab2x8(:,:,364))
  call Hloop_Q_A(ntryL,G0H4(1),21,nMB,G1H4(252),n2h4(316))
  call Hloop_SA_Q(ntryL,G0H8(133),ex2(:),G0H4(1),ngH,m3h2x4(:,365),heltab2x8(:,:,365))
  call Hloop_A_Q(ntryL,G0H4(1),26,nMT,G1H4(253),n2h4(317))
  call Hloop_SA_Q(ntryL,G0H8(134),ex2(:),G0H4(1),ngX,m3h2x4(:,366),heltab2x8(:,:,366))
  call Hloop_A_Q(ntryL,G0H4(1),26,nMT,G1H4(254),n2h4(318))
  call Hloop_SA_Q(ntryL,G0H8(135),ex2(:),G0H4(1),ngH,m3h2x4(:,367),heltab2x8(:,:,367))
  call Hloop_A_Q(ntryL,G0H4(1),26,nMT,G1H4(255),n2h4(319))
  call Hloop_SA_Q(ntryL,G0H8(136),ex2(:),G0H4(1),ngX,m3h2x4(:,368),heltab2x8(:,:,368))
  call Hloop_A_Q(ntryL,G0H4(1),26,nMT,G1H4(256),n2h4(320))
  call Hloop_SA_Q(ntryL,G0H8(137),ex2(:),G0H4(1),ngPtb,m3h2x4(:,369),heltab2x8(:,:,369))
  call Hloop_A_Q(ntryL,G0H4(1),26,nMB,G1H4(257),n2h4(321))
  call Hloop_VA_Q(ntryL,G0H8(143),ex2(:),G0H4(1),m3h2x4(:,370),heltab2x8(:,:,370))
  call Hloop_A_Q(ntryL,G0H4(1),26,nMT,G1H4(258),n2h4(322))
  call Hloop_VA_Q(ntryL,G0H8(144),ex2(:),G0H4(1),m3h2x4(:,371),heltab2x8(:,:,371))
  call Hloop_A_Q(ntryL,G0H4(1),26,nMT,G1H4(259),n2h4(323))
  call Hloop_ZA_Q(ntryL,G0H8(140),ex2(:),G0H4(1),ngZu,m3h2x4(:,372),heltab2x8(:,:,372))
  call Hloop_A_Q(ntryL,G0H4(1),26,nMT,G1H4(260),n2h4(324))
  call Hloop_ZA_Q(ntryL,G0H8(141),ex2(:),G0H4(1),ngZu,m3h2x4(:,373),heltab2x8(:,:,373))
  call Hloop_A_Q(ntryL,G0H4(1),26,nMT,G1H4(261),n2h4(325))
  call Hloop_WA_Q(ntryL,G0H8(142),ex2(:),G0H4(1),m3h2x4(:,374),heltab2x8(:,:,374))
  call Hloop_A_Q(ntryL,G0H4(1),26,nMB,G1H4(262),n2h4(326))
  call Hloop_SA_Q(ntryL,G0H8(150),ex2(:),G0H4(1),ngH,m3h2x4(:,375),heltab2x8(:,:,375))
  call Hloop_A_Q(ntryL,G0H4(1),26,nMT,G1H4(263),n2h4(327))
  call Hloop_SA_Q(ntryL,G0H8(151),ex2(:),G0H4(1),ngX,m3h2x4(:,376),heltab2x8(:,:,376))
  call Hloop_A_Q(ntryL,G0H4(1),26,nMT,G1H4(264),n2h4(328))
  call Hloop_SA_Q(ntryL,G0H8(147),ex2(:),G0H4(1),ngH,m3h2x4(:,377),heltab2x8(:,:,377))
  call Hloop_A_Q(ntryL,G0H4(1),26,nMT,G1H4(265),n2h4(329))
  call Hloop_SA_Q(ntryL,G0H8(148),ex2(:),G0H4(1),ngX,m3h2x4(:,378),heltab2x8(:,:,378))
  call Hloop_A_Q(ntryL,G0H4(1),26,nMT,G1H4(266),n2h4(330))
  call Hloop_SA_Q(ntryL,G0H8(149),ex2(:),G0H4(1),ngPtb,m3h2x4(:,379),heltab2x8(:,:,379))
  call Hloop_A_Q(ntryL,G0H4(1),26,nMB,G1H4(267),n2h4(331))
  call Hloop_VA_Q(ntryL,G0H8(158),ex2(:),G0H4(1),m3h2x4(:,380),heltab2x8(:,:,380))
  call Hloop_A_Q(ntryL,G0H4(1),26,nMT,G1H4(268),n2h4(332))
  call Hloop_ZA_Q(ntryL,G0H8(160),ex2(:),G0H4(1),ngZu,m3h2x4(:,381),heltab2x8(:,:,381))
  call Hloop_A_Q(ntryL,G0H4(1),26,nMT,G1H4(269),n2h4(333))
  call Hloop_VA_Q(ntryL,G0H8(159),ex2(:),G0H4(1),m3h2x4(:,382),heltab2x8(:,:,382))
  call Hloop_A_Q(ntryL,G0H4(1),26,nMT,G1H4(270),n2h4(334))
  call Hloop_ZA_Q(ntryL,G0H8(155),ex2(:),G0H4(1),ngZu,m3h2x4(:,383),heltab2x8(:,:,383))
  call Hloop_A_Q(ntryL,G0H4(1),26,nMT,G1H4(271),n2h4(335))
  call Hloop_WA_Q(ntryL,G0H8(156),ex2(:),G0H4(1),m3h2x4(:,384),heltab2x8(:,:,384))
  call Hloop_A_Q(ntryL,G0H4(1),26,nMB,G1H4(272),n2h4(336))
  call Hloop_SQ_A(ntryL,G0H8(161),ex1(:),G0H4(1),ngH,m3h2x4(:,385),heltab2x8(:,:,385))
  call Hloop_Q_A(ntryL,G0H4(1),25,nMT,G1H4(273),n2h4(337))
  call Hloop_SQ_A(ntryL,G0H8(162),ex1(:),G0H4(1),ngH,m3h2x4(:,386),heltab2x8(:,:,386))
  call Hloop_Q_A(ntryL,G0H4(1),25,nMT,G1H4(274),n2h4(338))
  call Hloop_SQ_A(ntryL,G0H8(163),ex1(:),G0H4(1),ngX,m3h2x4(:,387),heltab2x8(:,:,387))
  call Hloop_Q_A(ntryL,G0H4(1),25,nMT,G1H4(275),n2h4(339))
  call Hloop_SQ_A(ntryL,G0H8(164),ex1(:),G0H4(1),ngX,m3h2x4(:,388),heltab2x8(:,:,388))
  call Hloop_Q_A(ntryL,G0H4(1),25,nMT,G1H4(276),n2h4(340))
  call Hloop_AQ_S(ntryL,G1H8(145),ex1(:),G1H4(277),ngH,m3h2x4(:,389),heltab2x8(:,:,389))
  call Hloop_AQ_S(ntryL,G1H8(146),ex1(:),G1H4(278),ngPbt,m3h2x4(:,390),heltab2x8(:,:,390))
  call Hloop_AQ_S(ntryL,G1H8(147),ex1(:),G1H4(279),ngX,m3h2x4(:,391),heltab2x8(:,:,391))
  call Hloop_AQ_S(ntryL,G1H8(148),ex1(:),G1H4(280),ngPbt,m3h2x4(:,392),heltab2x8(:,:,392))
  call Hloop_SQ_A(ntryL,G0H8(169),ex1(:),G0H4(1),ngH,m3h2x4(:,393),heltab2x8(:,:,393))
  call Hloop_Q_A(ntryL,G0H4(1),25,nMT,G1H4(281),n2h4(341))
  call Hloop_SQ_A(ntryL,G0H8(170),ex1(:),G0H4(1),ngX,m3h2x4(:,394),heltab2x8(:,:,394))
  call Hloop_Q_A(ntryL,G0H4(1),25,nMT,G1H4(282),n2h4(342))
  call Hloop_SQ_A(ntryL,G0H8(167),ex1(:),G0H4(1),ngH,m3h2x4(:,395),heltab2x8(:,:,395))
  call Hloop_Q_A(ntryL,G0H4(1),25,nMT,G1H4(283),n2h4(343))
  call Hloop_SQ_A(ntryL,G0H8(168),ex1(:),G0H4(1),ngX,m3h2x4(:,396),heltab2x8(:,:,396))
  call Hloop_Q_A(ntryL,G0H4(1),25,nMT,G1H4(284),n2h4(344))
  call Hloop_VQ_A(ntryL,G0H8(175),ex1(:),G0H4(1),m3h2x4(:,397),heltab2x8(:,:,397))
  call Hloop_Q_A(ntryL,G0H4(1),25,nMT,G1H4(285),n2h4(345))
  call Hloop_VQ_A(ntryL,G0H8(176),ex1(:),G0H4(1),m3h2x4(:,398),heltab2x8(:,:,398))
  call Hloop_Q_A(ntryL,G0H4(1),25,nMT,G1H4(286),n2h4(346))
  call Hloop_ZQ_A(ntryL,G0H8(173),ex1(:),G0H4(1),ngZu,m3h2x4(:,399),heltab2x8(:,:,399))
  call Hloop_Q_A(ntryL,G0H4(1),25,nMT,G1H4(287),n2h4(347))
  call Hloop_ZQ_A(ntryL,G0H8(174),ex1(:),G0H4(1),ngZu,m3h2x4(:,400),heltab2x8(:,:,400))
  call Hloop_Q_A(ntryL,G0H4(1),25,nMT,G1H4(288),n2h4(348))
  call Hloop_AQ_S(ntryL,G1H8(153),ex1(:),G1H4(289),ngPbt,m3h2x4(:,401),heltab2x8(:,:,401))
  call Hloop_AQ_S(ntryL,G1H8(150),ex1(:),G1H4(290),ngPbt,m3h2x4(:,402),heltab2x8(:,:,402))
  call Hloop_AQ_S(ntryL,G1H8(151),ex1(:),G1H4(291),ngH,m3h2x4(:,403),heltab2x8(:,:,403))
  call Hloop_AQ_S(ntryL,G1H8(152),ex1(:),G1H4(292),ngX,m3h2x4(:,404),heltab2x8(:,:,404))
  call Hloop_AQ_V(ntryL,G1H8(158),ex1(:),G1H4(293),m3h2x4(:,405),heltab2x8(:,:,405))
  call Hloop_AQ_Z(ntryL,G1H8(155),ex1(:),G1H4(294),ngZu,m3h2x4(:,406),heltab2x8(:,:,406))
  call Hloop_AQ_W(ntryL,G1H8(156),ex1(:),G1H4(295),m3h2x4(:,407),heltab2x8(:,:,407))
  call Hloop_AQ_W(ntryL,G1H8(157),ex1(:),G1H4(296),m3h2x4(:,408),heltab2x8(:,:,408))
  call Hloop_VQ_A(ntryL,G0H8(182),ex1(:),G0H4(1),m3h2x4(:,409),heltab2x8(:,:,409))
  call Hloop_Q_A(ntryL,G0H4(1),25,nMT,G1H4(297),n2h4(349))
  call Hloop_VQ_A(ntryL,G0H8(184),ex1(:),G0H4(1),m3h2x4(:,410),heltab2x8(:,:,410))
  call Hloop_Q_A(ntryL,G0H4(1),25,nMT,G1H4(298),n2h4(350))
  call Hloop_ZQ_A(ntryL,G0H8(183),ex1(:),G0H4(1),ngZu,m3h2x4(:,411),heltab2x8(:,:,411))
  call Hloop_Q_A(ntryL,G0H4(1),25,nMT,G1H4(299),n2h4(351))
  call Hloop_ZQ_A(ntryL,G0H8(180),ex1(:),G0H4(1),ngZu,m3h2x4(:,412),heltab2x8(:,:,412))
  call Hloop_Q_A(ntryL,G0H4(1),25,nMT,G1H4(300),n2h4(352))
  call Hloop_AQ_V(ntryL,G1H8(163),ex1(:),G1H4(301),m3h2x4(:,413),heltab2x8(:,:,413))
  call Hloop_AQ_W(ntryL,G1H8(164),ex1(:),G1H4(302),m3h2x4(:,414),heltab2x8(:,:,414))
  call Hloop_AQ_Z(ntryL,G1H8(161),ex1(:),G1H4(303),ngZu,m3h2x4(:,415),heltab2x8(:,:,415))
  call Hloop_AQ_W(ntryL,G1H8(162),ex1(:),G1H4(304),m3h2x4(:,416),heltab2x8(:,:,416))
  call Hloop_AQ_S(ntryL,G1H8(165),ex1(:),G1H4(305),ngH,m3h2x4(:,417),heltab2x8(:,:,417))
  call Hloop_AQ_S(ntryL,G1H8(166),ex1(:),G1H4(306),ngPbt,m3h2x4(:,418),heltab2x8(:,:,418))
  call Hloop_AQ_S(ntryL,G1H8(167),ex1(:),G1H4(307),ngX,m3h2x4(:,419),heltab2x8(:,:,419))
  call Hloop_AQ_S(ntryL,G1H8(168),ex1(:),G1H4(308),ngPbt,m3h2x4(:,420),heltab2x8(:,:,420))
  call Hloop_AQ_S(ntryL,G1H8(173),ex1(:),G1H4(309),ngPbt,m3h2x4(:,421),heltab2x8(:,:,421))
  call Hloop_AQ_S(ntryL,G1H8(170),ex1(:),G1H4(310),ngPbt,m3h2x4(:,422),heltab2x8(:,:,422))
  call Hloop_AQ_S(ntryL,G1H8(171),ex1(:),G1H4(311),ngH,m3h2x4(:,423),heltab2x8(:,:,423))
  call Hloop_AQ_S(ntryL,G1H8(172),ex1(:),G1H4(312),ngX,m3h2x4(:,424),heltab2x8(:,:,424))
  call Hloop_AQ_V(ntryL,G1H8(178),ex1(:),G1H4(313),m3h2x4(:,425),heltab2x8(:,:,425))
  call Hloop_AQ_Z(ntryL,G1H8(175),ex1(:),G1H4(314),ngZu,m3h2x4(:,426),heltab2x8(:,:,426))
  call Hloop_AQ_W(ntryL,G1H8(176),ex1(:),G1H4(315),m3h2x4(:,427),heltab2x8(:,:,427))
  call Hloop_AQ_W(ntryL,G1H8(177),ex1(:),G1H4(316),m3h2x4(:,428),heltab2x8(:,:,428))
  call Hloop_AQ_V(ntryL,G1H8(184),ex1(:),G1H4(317),m3h2x4(:,429),heltab2x8(:,:,429))
  call Hloop_AQ_W(ntryL,G1H8(183),ex1(:),G1H4(318),m3h2x4(:,430),heltab2x8(:,:,430))
  call Hloop_AQ_Z(ntryL,G1H8(181),ex1(:),G1H4(319),ngZu,m3h2x4(:,431),heltab2x8(:,:,431))
  call Hloop_AQ_W(ntryL,G1H8(182),ex1(:),G1H4(320),m3h2x4(:,432),heltab2x8(:,:,432))
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(74),[G1H4(3)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(64),[G1H4(4)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(77),[G1H4(9)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(70),[G1H4(10)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(148),[G1H4(15)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(76),[G1H4(16)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(150),[G1H4(21)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(82),[G1H4(22)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(201),[G1H4(27)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(112),[G1H4(28)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(214),[G1H4(33)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(118),[G1H4(34)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(169),[G1H4(39)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(88),[G1H4(40)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(170),[G1H4(45)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(94),[G1H4(46)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(181),[G1H4(51)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(100),[G1H4(52)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(183),[G1H4(57)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(106),[G1H4(58)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(133),[G1H4(63)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(134),[G1H4(69)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(7),[G1H4(75)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(11),[G1H4(81)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(20),[G1H4(87)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(23),[G1H4(93)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(36),[G1H4(99)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(38),[G1H4(105)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(49),[G1H4(111)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(62),[G1H4(117)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(50),[G2H4(46),G2H4(7),G2H4(3)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(64),[G2H4(47),G2H4(9),G2H4(4)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(65),[G2H4(48),G2H4(10),G2H4(5)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(70),[G2H4(66),G2H4(36),G2H4(26)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(90),[G2H4(67),G2H4(44),G2H4(28)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(91),[G2H4(68),G2H4(45),G2H4(34)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(130),[G2H4(125),G2H4(100),G2H4(92)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(145),[G2H4(127),G2H4(106),G2H4(97)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(146),[G2H4(129),G2H4(107),G2H4(98)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(2),[G2H4(148),G2H4(112),G2H4(108)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(13),[G2H4(150),G2H4(123),G2H4(109)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(14),[G2H4(1),G2H4(124),G2H4(110)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(19),[G2H4(15)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(20),[G2H4(6)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(11),[G2H4(18)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(12),[G2H4(8)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(95),[G1H4(85)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(96),[G1H4(89)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(92),[G1H4(90)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(103),[G1H4(97)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(107),[G1H4(98)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(108),[G1H4(102)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(131),[G1H4(110)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(128),[G1H4(113)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(132),[G1H4(114)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(2),[G1H4(121)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(6),[G1H4(122)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(5),[G1H4(126)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(167),[G1H4(154)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(166),[G1H4(155)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(168),[G1H4(156)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(178),[G1H4(161)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(180),[G1H4(162)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(179),[G1H4(164)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(195),[G1H4(186)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(196),[G1H4(188)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(210),[G1H4(198)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(212),[G1H4(200)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(229),[G1H4(219)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(230),[G1H4(220)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(231),[G1H4(221)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(234),[G1H4(223)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(235),[G1H4(225)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(236),[G1H4(226)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(247),[G1H4(238)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(246),[G1H4(239)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(248),[G1H4(240)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(250),[G1H4(241)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(252),[G1H4(242)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(251),[G1H4(244)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(260),[G1H4(254)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(261),[G1H4(256)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(262),[G1H4(257)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(269),[G1H4(264)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(271),[G1H4(266)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(272),[G1H4(267)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(287),[G1H4(275)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(288),[G1H4(276)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(299),[G1H4(282)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(300),[G1H4(284)])
  call Hloop_SQ_A(ntryL,G1H4(74),ex3(:),G1H2(25),ngH,m3h2x2(:,189),heltab2x4(:,:,189))
  call Hloop_Q_A(ntryL,G1H2(25),23,nMB,G2H2(96),n2h2(73))
  call Hloop_SQ_A(ntryL,G1H4(64),ex3(:),G1H2(26),ngH,m3h2x2(:,190),heltab2x4(:,:,190))
  call Hloop_Q_A(ntryL,G1H2(26),23,nMB,G2H2(98),n2h2(74))
  call Hloop_SQ_A(ntryL,G1H4(77),ex3(:),G1H2(30),ngX,m3h2x2(:,191),heltab2x4(:,:,191))
  call Hloop_Q_A(ntryL,G1H2(30),23,nMB,G2H2(105),n2h2(75))
  call Hloop_SQ_A(ntryL,G1H4(70),ex3(:),G1H2(31),ngX,m3h2x2(:,192),heltab2x4(:,:,192))
  call Hloop_Q_A(ntryL,G1H2(31),23,nMB,G2H2(107),n2h2(76))
  call Hloop_VQ_A(ntryL,G1H4(148),ex3(:),G1H2(32),m3h2x2(:,193),heltab2x4(:,:,193))
  call Hloop_Q_A(ntryL,G1H2(32),23,nMB,G2H2(114),n2h2(77))
  call Hloop_VQ_A(ntryL,G1H4(76),ex3(:),G1H2(36),m3h2x2(:,194),heltab2x4(:,:,194))
  call Hloop_Q_A(ntryL,G1H2(36),23,nMB,G2H2(116),n2h2(78))
  call Hloop_ZQ_A(ntryL,G1H4(150),ex3(:),G1H2(37),ngZd,m3h2x2(:,195),heltab2x4(:,:,195))
  call Hloop_Q_A(ntryL,G1H2(37),23,nMB,G2H2(126),n2h2(79))
  call Hloop_ZQ_A(ntryL,G1H4(82),ex3(:),G1H2(38),ngZd,m3h2x2(:,196),heltab2x4(:,:,196))
  call Hloop_Q_A(ntryL,G1H2(38),23,nMB,G2H2(128),n2h2(80))
  call Hloop_SQ_A(ntryL,G1H4(201),ex1(:),G1H2(42),ngPbt,m3h2x2(:,197),heltab2x4(:,:,197))
  call Hloop_Q_A(ntryL,G1H2(42),23,nMB,G2H2(138),n2h2(81))
  call Hloop_SQ_A(ntryL,G1H4(112),ex1(:),G1H2(43),ngPbt,m3h2x2(:,198),heltab2x4(:,:,198))
  call Hloop_Q_A(ntryL,G1H2(43),23,nMB,G2H2(140),n2h2(82))
  call Hloop_WQ_A(ntryL,G1H4(214),ex1(:),G1H2(44),m3h2x2(:,199),heltab2x4(:,:,199))
  call Hloop_Q_A(ntryL,G1H2(44),23,nMB,G2H2(147),n2h2(83))
  call Hloop_WQ_A(ntryL,G1H4(118),ex1(:),G1H2(48),m3h2x2(:,200),heltab2x4(:,:,200))
  call Hloop_Q_A(ntryL,G1H2(48),23,nMB,G2H2(149),n2h2(84))
  call Hloop_SA_Q(ntryL,G1H4(169),ex4(:),G1H2(49),ngH,m3h2x2(:,201),heltab2x4(:,:,201))
  call Hloop_A_Q(ntryL,G1H2(49),27,nMB,G2H2(153),n2h2(85))
  call Hloop_SA_Q(ntryL,G1H4(88),ex4(:),G1H2(50),ngH,m3h2x2(:,202),heltab2x4(:,:,202))
  call Hloop_A_Q(ntryL,G1H2(50),27,nMB,G2H2(155),n2h2(86))
  call Hloop_SA_Q(ntryL,G1H4(170),ex4(:),G1H2(54),ngX,m3h2x2(:,203),heltab2x4(:,:,203))
  call Hloop_A_Q(ntryL,G1H2(54),27,nMB,G2H2(159),n2h2(87))
  call Hloop_SA_Q(ntryL,G1H4(94),ex4(:),G1H2(55),ngX,m3h2x2(:,204),heltab2x4(:,:,204))
  call Hloop_A_Q(ntryL,G1H2(55),27,nMB,G2H2(161),n2h2(88))
  call Hloop_VA_Q(ntryL,G1H4(181),ex4(:),G1H2(56),m3h2x2(:,205),heltab2x4(:,:,205))
  call Hloop_A_Q(ntryL,G1H2(56),27,nMB,G2H2(1),n2h2(89))
  call Hloop_VA_Q(ntryL,G1H4(100),ex4(:),G1H2(60),m3h2x2(:,206),heltab2x4(:,:,206))
  call Hloop_A_Q(ntryL,G1H2(60),27,nMB,G2H2(2),n2h2(90))
  call Hloop_ZA_Q(ntryL,G1H4(183),ex4(:),G1H2(61),ngZd,m3h2x2(:,207),heltab2x4(:,:,207))
  call Hloop_A_Q(ntryL,G1H2(61),27,nMB,G2H2(3),n2h2(91))
  call Hloop_ZA_Q(ntryL,G1H4(106),ex4(:),G1H2(62),ngZd,m3h2x2(:,208),heltab2x4(:,:,208))
  call Hloop_A_Q(ntryL,G1H2(62),27,nMB,G2H2(4),n2h2(92))
  call Hloop_SQ_A(ntryL,G1H4(133),ex3(:),G1H2(66),ngH,m3h2x2(:,209),heltab2x4(:,:,209))
  call Hloop_Q_A(ntryL,G1H2(66),23,nMB,G2H2(5),n2h2(93))
  call Hloop_SQ_A(ntryL,G1H4(134),ex3(:),G1H2(67),ngX,m3h2x2(:,210),heltab2x4(:,:,210))
  call Hloop_Q_A(ntryL,G1H2(67),23,nMB,G2H2(6),n2h2(94))
  call Hloop_VQ_A(ntryL,G1H4(7),ex3(:),G1H2(68),m3h2x2(:,211),heltab2x4(:,:,211))
  call Hloop_Q_A(ntryL,G1H2(68),23,nMB,G2H2(7),n2h2(95))
  call Hloop_ZQ_A(ntryL,G1H4(11),ex3(:),G1H2(72),ngZd,m3h2x2(:,212),heltab2x4(:,:,212))
  call Hloop_Q_A(ntryL,G1H2(72),23,nMB,G2H2(8),n2h2(96))
  call Hloop_SA_Q(ntryL,G1H4(20),ex4(:),G1H2(73),ngH,m3h2x2(:,213),heltab2x4(:,:,213))
  call Hloop_A_Q(ntryL,G1H2(73),27,nMB,G2H2(9),n2h2(97))
  call Hloop_SA_Q(ntryL,G1H4(23),ex4(:),G1H2(74),ngX,m3h2x2(:,214),heltab2x4(:,:,214))
  call Hloop_A_Q(ntryL,G1H2(74),27,nMB,G2H2(10),n2h2(98))
  call Hloop_VA_Q(ntryL,G1H4(36),ex4(:),G1H2(78),m3h2x2(:,215),heltab2x4(:,:,215))
  call Hloop_A_Q(ntryL,G1H2(78),27,nMB,G2H2(11),n2h2(99))
  call Hloop_ZA_Q(ntryL,G1H4(38),ex4(:),G1H2(79),ngZd,m3h2x2(:,216),heltab2x4(:,:,216))
  call Hloop_A_Q(ntryL,G1H2(79),27,nMB,G2H2(12),n2h2(100))
  call Hloop_SQ_A(ntryL,G1H4(49),ex1(:),G1H2(80),ngPbt,m3h2x2(:,217),heltab2x4(:,:,217))
  call Hloop_Q_A(ntryL,G1H2(80),23,nMB,G2H2(13),n2h2(101))
  call Hloop_WQ_A(ntryL,G1H4(62),ex1(:),G1H2(84),m3h2x2(:,218),heltab2x4(:,:,218))
  call Hloop_Q_A(ntryL,G1H2(84),23,nMB,G2H2(14),n2h2(102))
  call Hloop_SA_Q(ntryL,G1H4(123),ex2(:),G1H2(85),ngPtb,m3h2x2(:,219),heltab2x4(:,:,219))
  call Hloop_A_Q(ntryL,G1H2(85),27,nMB,G2H2(15),n2h2(103))
  call Hloop_SA_Q(ntryL,G1H4(124),ex2(:),G1H2(86),ngPtb,m3h2x2(:,220),heltab2x4(:,:,220))
  call Hloop_A_Q(ntryL,G1H2(86),27,nMB,G2H2(16),n2h2(104))
  call Hloop_WA_Q(ntryL,G1H4(129),ex2(:),G1H2(90),m3h2x2(:,221),heltab2x4(:,:,221))
  call Hloop_A_Q(ntryL,G1H2(90),27,nMB,G2H2(17),n2h2(105))
  call Hloop_WA_Q(ntryL,G1H4(130),ex2(:),G1H2(91),m3h2x2(:,222),heltab2x4(:,:,222))
  call Hloop_A_Q(ntryL,G1H2(91),27,nMB,G2H2(18),n2h2(106))
  call Hloop_SQ_A(ntryL,G1H4(135),ex3(:),G1H2(92),ngPtb,m3h2x2(:,223),heltab2x4(:,:,223))
  call Hloop_Q_A(ntryL,G1H2(92),29,nMT,G2H2(19),n2h2(107))
  call Hloop_SQ_A(ntryL,G1H4(136),ex3(:),G1H2(96),ngPtb,m3h2x2(:,224),heltab2x4(:,:,224))
  call Hloop_Q_A(ntryL,G1H2(96),29,nMT,G2H2(20),n2h2(108))
  call Hloop_WQ_A(ntryL,G1H4(141),ex3(:),G1H2(97),m3h2x2(:,225),heltab2x4(:,:,225))
  call Hloop_Q_A(ntryL,G1H2(97),29,nMT,G2H2(21),n2h2(109))
  call Hloop_WQ_A(ntryL,G1H4(142),ex3(:),G1H2(98),m3h2x2(:,226),heltab2x4(:,:,226))
  call Hloop_Q_A(ntryL,G1H2(98),29,nMT,G2H2(22),n2h2(110))
  call Hloop_QA_S(ntryL,G2H4(50),ex4(:),G2H2(23),ngH,m3h2x2(:,227),heltab2x4(:,:,227))
  call Hloop_QA_S(ntryL,G2H4(64),ex4(:),G2H2(24),ngX,m3h2x2(:,228),heltab2x4(:,:,228))
  call Hloop_QA_S(ntryL,G2H4(65),ex4(:),G2H2(25),ngPbt,m3h2x2(:,229),heltab2x4(:,:,229))
  call Hloop_QA_V(ntryL,G2H4(70),ex4(:),G2H2(26),m3h2x2(:,230),heltab2x4(:,:,230))
  call Hloop_QA_Z(ntryL,G2H4(90),ex4(:),G2H2(27),ngZd,m3h2x2(:,231),heltab2x4(:,:,231))
  call Hloop_QA_W(ntryL,G2H4(91),ex4(:),G2H2(28),m3h2x2(:,232),heltab2x4(:,:,232))
  call Hloop_AQ_S(ntryL,G2H4(130),ex3(:),G2H2(29),ngH,m3h2x2(:,233),heltab2x4(:,:,233))
  call Hloop_AQ_S(ntryL,G2H4(145),ex3(:),G2H2(30),ngX,m3h2x2(:,234),heltab2x4(:,:,234))
  call Hloop_AQ_S(ntryL,G2H4(146),ex3(:),G2H2(31),ngPtb,m3h2x2(:,235),heltab2x4(:,:,235))
  call Hloop_AQ_V(ntryL,G2H4(2),ex3(:),G2H2(32),m3h2x2(:,236),heltab2x4(:,:,236))
  call Hloop_AQ_Z(ntryL,G2H4(13),ex3(:),G2H2(33),ngZd,m3h2x2(:,237),heltab2x4(:,:,237))
  call Hloop_AQ_W(ntryL,G2H4(14),ex3(:),G2H2(34),m3h2x2(:,238),heltab2x4(:,:,238))
  call Hloop_SS_S(ntryL,G1H8(4),wf4(:,3),G1H2(102),m3h4x2(:,1),heltab2x8(:,:,433))
  call Hloop_SS_S(ntryL,G1H8(5),wf4(:,3),G1H2(103),m3h4x2(:,2),heltab2x8(:,:,434))
  call Hloop_SS_S(ntryL,G1H8(10),wf4(:,3),G1H2(104),m3h4x2(:,3),heltab2x8(:,:,435))
  call Hloop_SS_S(ntryL,G1H8(11),wf4(:,6),G1H2(108),m3h4x2(:,4),heltab2x8(:,:,436))
  call Hloop_SS_S(ntryL,G1H8(20),wf4(:,6),G1H2(109),m3h4x2(:,5),heltab2x8(:,:,437))
  call Hloop_ST_V(ntryL,G1H8(16),20,wf4(:,3),3,G2H2(35),m3h4x2(:,6),heltab2x8(:,:,438))
  call Hloop_ST_V(ntryL,G1H8(17),20,wf4(:,3),3,G2H2(36),m3h4x2(:,7),heltab2x8(:,:,439))
  call Hloop_TS_V(ntryL,G1H8(18),20,wf4(:,6),3,G2H2(37),m3h4x2(:,8),heltab2x8(:,:,440))
  call Hloop_ST_V(ntryL,G1H8(29),20,wf4(:,6),3,G2H2(38),m3h4x2(:,9),heltab2x8(:,:,441))
  call Hloop_VT_S(ntryL,G1H8(30),20,wf4(:,3),3,G2H2(39),m3h4x2(:,10),heltab2x8(:,:,442))
  call Hloop_VT_S(ntryL,G1H8(36),20,wf4(:,3),3,G2H2(40),m3h4x2(:,11),heltab2x8(:,:,443))
  call Hloop_VS_T(ntryL,G1H8(37),20,wf4(:,6),3,G2H2(41),m3h4x2(:,12),heltab2x8(:,:,444))
  call Hloop_VT_S(ntryL,G1H8(48),20,wf4(:,6),3,G2H2(42),m3h4x2(:,13),heltab2x8(:,:,445))
  call Hloop_VS_V(ntryL,G1H8(43),wf4(:,3),G1H2(110),m3h4x2(:,14),heltab2x8(:,:,446))
  call Hloop_VS_V(ntryL,G1H8(44),wf4(:,3),G1H2(114),m3h4x2(:,15),heltab2x8(:,:,447))
  call Hotf_4pt_reduction(G2H8(1),RedSet_4(8),mass4set(:,1),  & 
G1H8(319),G1H8(137),G1H8(1),G1H8(2),G1H8(3),8)
  call HG1shiftOLR(G1H8(137),8,8)
  call Hotf_4pt_reduction(G2H8(2),RedSet_4(8),mass4set(:,1),  & 
G1H8(8),G1H8(9),G1H8(6),G1H8(7),G1H8(14),8)
  call HG1shiftOLR(G1H8(9),8,8)
  call Hloop_TV_S(ntryL,G1H8(61),20,wf4(:,1),3,G2H2(43),m3h4x2(:,16),heltab2x8(:,:,448))
  call Hloop_TV_S(ntryL,G1H8(66),20,wf4(:,7),3,G2H2(44),m3h4x2(:,17),heltab2x8(:,:,449))
  call Hloop_SV_T(ntryL,G1H8(67),20,wf4(:,7),3,G2H2(45),m3h4x2(:,18),heltab2x8(:,:,450))
  call Hloop_TV_S(ntryL,G1H8(77),20,wf4(:,7),3,G2H2(46),m3h4x2(:,19),heltab2x8(:,:,451))
  call Hloop_SV_V(ntryL,G1H8(78),wf4(:,1),G1H2(115),m3h4x2(:,20),heltab2x8(:,:,452))
  call Hloop_SV_V(ntryL,G1H8(84),wf4(:,7),G1H2(116),m3h4x2(:,21),heltab2x8(:,:,453))
  call Hloop_SV_V(ntryL,G1H8(85),wf4(:,7),G1H2(120),m3h4x2(:,22),heltab2x8(:,:,454))
  call Hloop_VV_S(ntryL,G1H8(96),wf4(:,1),G1H2(121),m3h4x2(:,23),heltab2x8(:,:,455))
  call Hloop_VV_S(ntryL,G1H8(91),wf4(:,7),G1H2(122),m3h4x2(:,24),heltab2x8(:,:,456))
  call Hloop_VV_S(ntryL,G1H8(92),wf4(:,7),G1H2(126),m3h4x2(:,25),heltab2x8(:,:,457))
  call Hloop_UV_W(ntryL,G1H8(93),20,wf4(:,1),3,G2H2(47),m3h4x2(:,26),heltab2x8(:,:,458))
  call Hloop_UV_W(ntryL,G1H8(104),20,wf4(:,7),3,G2H2(48),m3h4x2(:,27),heltab2x8(:,:,459))
  call Hotf_4pt_reduction(G2H8(3),RedSet_4(8),mass4set(:,1),  & 
G1H8(15),G1H8(12),G1H8(13),G1H8(21),G1H8(23),8)
  call HG1shiftOLR(G1H8(12),8,8)
  call Hotf_4pt_reduction(G2H8(4),RedSet_4(8),mass4set(:,1),  & 
G1H8(22),G1H8(19),G1H8(24),G1H8(25),G1H8(26),8)
  call HG1shiftOLR(G1H8(19),8,8)
  call Hloop_SA_Q(ntryL,G1H8(111),ex4(:),G1H4(3),ngH,m3h2x4(:,433),heltab2x8(:,:,460))
  call Hloop_A_Q(ntryL,G1H4(3),25,nMB,G2H4(16),n2h4(353))
  call Hloop_SA_Q(ntryL,G1H8(120),ex4(:),G1H4(4),ngX,m3h2x4(:,434),heltab2x8(:,:,461))
  call Hloop_A_Q(ntryL,G1H4(4),25,nMB,G2H4(17),n2h4(354))
  call Hloop_VA_Q(ntryL,G1H8(116),ex4(:),G1H4(9),m3h2x4(:,435),heltab2x8(:,:,462))
  call Hloop_A_Q(ntryL,G1H4(9),25,nMB,G2H4(21),n2h4(355))
  call Hloop_ZA_Q(ntryL,G1H8(117),ex4(:),G1H4(10),ngZd,m3h2x4(:,436),heltab2x8(:,:,463))
  call Hloop_A_Q(ntryL,G1H4(10),25,nMB,G2H4(22),n2h4(356))
  call Hloop_SA_Q(ntryL,G1H8(118),ex4(:),G1H4(15),ngH,m3h2x4(:,437),heltab2x8(:,:,464))
  call Hloop_A_Q(ntryL,G1H4(15),25,nMB,G2H4(23),n2h4(357))
  call Hloop_SA_Q(ntryL,G1H8(128),ex4(:),G1H4(16),ngX,m3h2x4(:,438),heltab2x8(:,:,465))
  call Hloop_A_Q(ntryL,G1H4(16),25,nMB,G2H4(24),n2h4(358))
  call Hloop_VA_Q(ntryL,G1H8(133),ex4(:),G1H4(21),m3h2x4(:,439),heltab2x8(:,:,466))
  call Hloop_A_Q(ntryL,G1H4(21),25,nMB,G2H4(25),n2h4(359))
  call Hloop_ZA_Q(ntryL,G1H8(139),ex4(:),G1H4(22),ngZd,m3h2x4(:,440),heltab2x8(:,:,467))
  call Hloop_A_Q(ntryL,G1H4(22),25,nMB,G2H4(31),n2h4(360))
  call Hloop_AQ_S(ntryL,G2H4(19),ex1(:),G2H2(49),ngH,m3h2x2(:,239),heltab2x4(:,:,239))
  call Hloop_AQ_S(ntryL,G2H4(20),ex1(:),G2H2(50),ngX,m3h2x2(:,240),heltab2x4(:,:,240))
  call Hloop_AQ_V(ntryL,G2H4(11),ex1(:),G2H2(51),m3h2x2(:,241),heltab2x4(:,:,241))
  call Hloop_AQ_Z(ntryL,G2H4(12),ex1(:),G2H2(52),ngZu,m3h2x2(:,242),heltab2x4(:,:,242))
  call Hloop_SS_S(ntryL,G1H8(140),wf4(:,11),G1H2(127),m3h4x2(:,28),heltab2x8(:,:,468))
  call Hloop_SS_S(ntryL,G1H8(149),wf4(:,11),G1H2(128),m3h4x2(:,29),heltab2x8(:,:,469))
  call Hloop_ST_V(ntryL,G1H8(154),17,wf4(:,11),6,G2H2(53),m3h4x2(:,30),heltab2x8(:,:,470))
  call Hloop_ST_V(ntryL,G1H8(159),17,wf4(:,11),6,G2H2(54),m3h4x2(:,31),heltab2x8(:,:,471))
  call Hloop_TS_V(ntryL,G1H8(160),17,wf4(:,11),6,G2H2(55),m3h4x2(:,32),heltab2x8(:,:,472))
  call Hloop_TS_V(ntryL,G1H8(169),17,wf4(:,11),6,G2H2(56),m3h4x2(:,33),heltab2x8(:,:,473))
  call Hloop_VT_S(ntryL,G1H8(174),17,wf4(:,11),6,G2H2(57),m3h4x2(:,34),heltab2x8(:,:,474))
  call Hloop_VT_S(ntryL,G1H8(179),17,wf4(:,11),6,G2H2(58),m3h4x2(:,35),heltab2x8(:,:,475))
  call Hloop_VS_T(ntryL,G1H8(180),17,wf4(:,11),6,G2H2(59),m3h4x2(:,36),heltab2x8(:,:,476))
  call Hloop_VS_T(ntryL,G1H8(45),17,wf4(:,11),6,G2H2(60),m3h4x2(:,37),heltab2x8(:,:,477))
  call Hloop_VS_V(ntryL,G1H8(56),wf4(:,11),G1H2(132),m3h4x2(:,38),heltab2x8(:,:,478))
  call Hloop_VS_V(ntryL,G1H8(105),wf4(:,11),G1H2(133),m3h4x2(:,39),heltab2x8(:,:,479))
  call Hloop_VS_V(ntryL,G1H8(110),wf4(:,11),G1H2(134),m3h4x2(:,40),heltab2x8(:,:,480))
  call Hloop_VS_V(ntryL,G1H8(185),wf4(:,11),G1H2(138),m3h4x2(:,41),heltab2x8(:,:,481))
  call Hotf_4pt_reduction(G2H8(5),RedSet_4(16),mass4set(:,2),  & 
G1H8(27),G1H8(28),G1H8(34),G1H8(35),G1H8(31),8)
  call HG1shiftOLR(G1H8(28),8,8)
  call Hloop_TV_S(ntryL,G1H8(186),17,wf4(:,13),6,G2H2(61),m3h4x2(:,42),heltab2x8(:,:,482))
  call Hloop_SV_T(ntryL,G1H8(187),17,wf4(:,13),6,G2H2(62),m3h4x2(:,43),heltab2x8(:,:,483))
  call Hloop_TV_S(ntryL,G1H8(188),17,wf4(:,13),6,G2H2(63),m3h4x2(:,44),heltab2x8(:,:,484))
  call Hloop_SV_T(ntryL,G1H8(189),17,wf4(:,13),6,G2H2(64),m3h4x2(:,45),heltab2x8(:,:,485))
  call Hloop_SV_V(ntryL,G1H8(190),wf4(:,13),G1H2(139),m3h4x2(:,46),heltab2x8(:,:,486))
  call Hloop_SV_V(ntryL,G1H8(191),wf4(:,13),G1H2(140),m3h4x2(:,47),heltab2x8(:,:,487))
  call Hloop_SV_V(ntryL,G1H8(192),wf4(:,13),G1H2(144),m3h4x2(:,48),heltab2x8(:,:,488))
  call Hloop_VV_S(ntryL,G1H8(193),wf4(:,13),G1H2(145),m3h4x2(:,49),heltab2x8(:,:,489))
  call Hloop_VV_S(ntryL,G1H8(194),wf4(:,13),G1H2(146),m3h4x2(:,50),heltab2x8(:,:,490))
  call Hloop_VV_S(ntryL,G1H8(195),wf4(:,13),G1H2(150),m3h4x2(:,51),heltab2x8(:,:,491))
  call Hloop_UW_V(ntryL,G1H8(196),17,wf4(:,13),6,G2H2(65),m3h4x2(:,52),heltab2x8(:,:,492))
  call Hloop_UV_W(ntryL,G1H8(197),17,wf4(:,13),6,G2H2(66),m3h4x2(:,53),heltab2x8(:,:,493))
  call Hloop_UW_V(ntryL,G1H8(198),17,wf4(:,13),6,G2H2(67),m3h4x2(:,54),heltab2x8(:,:,494))
  call Hloop_UV_W(ntryL,G1H8(199),17,wf4(:,13),6,G2H2(68),m3h4x2(:,55),heltab2x8(:,:,495))
  call Hotf_4pt_reduction(G2H8(6),RedSet_4(16),mass4set(:,2),  & 
G1H8(32),G1H8(33),G1H8(41),G1H8(42),G1H8(38),8)
  call HG1shiftOLR(G1H8(33),8,8)
  call Hloop_SQ_A(ntryL,G1H8(200),ex3(:),G1H4(27),ngH,m3h2x4(:,441),heltab2x8(:,:,496))
  call Hloop_Q_A(ntryL,G1H4(27),22,nMB,G2H4(27),n2h4(361))
  call Hloop_SQ_A(ntryL,G1H8(201),ex3(:),G1H4(28),ngX,m3h2x4(:,442),heltab2x8(:,:,497))
  call Hloop_Q_A(ntryL,G1H4(28),22,nMB,G2H4(32),n2h4(362))
  call Hloop_VQ_A(ntryL,G1H8(202),ex3(:),G1H4(33),m3h2x4(:,443),heltab2x8(:,:,498))
  call Hloop_Q_A(ntryL,G1H4(33),22,nMB,G2H4(29),n2h4(363))
  call Hloop_ZQ_A(ntryL,G1H8(203),ex3(:),G1H4(34),ngZd,m3h2x4(:,444),heltab2x8(:,:,499))
  call Hloop_Q_A(ntryL,G1H4(34),22,nMB,G2H4(30),n2h4(364))
  call Hloop_SQ_A(ntryL,G1H8(204),ex3(:),G1H4(39),ngH,m3h2x4(:,445),heltab2x8(:,:,500))
  call Hloop_Q_A(ntryL,G1H4(39),22,nMB,G2H4(33),n2h4(365))
  call Hloop_SQ_A(ntryL,G1H8(205),ex3(:),G1H4(40),ngX,m3h2x4(:,446),heltab2x8(:,:,501))
  call Hloop_Q_A(ntryL,G1H4(40),22,nMB,G2H4(38),n2h4(366))
  call Hloop_VQ_A(ntryL,G1H8(206),ex3(:),G1H4(45),m3h2x4(:,447),heltab2x8(:,:,502))
  call Hloop_Q_A(ntryL,G1H4(45),22,nMB,G2H4(35),n2h4(367))
  call Hloop_ZQ_A(ntryL,G1H8(207),ex3(:),G1H4(46),ngZd,m3h2x4(:,448),heltab2x8(:,:,503))
  call Hloop_Q_A(ntryL,G1H4(46),22,nMB,G2H4(40),n2h4(368))
  call Hloop_SA_Q(ntryL,G1H8(208),ex2(:),G1H4(51),ngH,m3h2x4(:,449),heltab2x8(:,:,504))
  call Hloop_A_Q(ntryL,G1H4(51),22,nMT,G2H4(37),n2h4(369))
  call Hloop_SA_Q(ntryL,G1H8(209),ex2(:),G1H4(52),ngX,m3h2x4(:,450),heltab2x8(:,:,505))
  call Hloop_A_Q(ntryL,G1H4(52),22,nMT,G2H4(39),n2h4(370))
  call Hloop_VA_Q(ntryL,G1H8(210),ex2(:),G1H4(57),m3h2x4(:,451),heltab2x8(:,:,506))
  call Hloop_A_Q(ntryL,G1H4(57),22,nMT,G2H4(41),n2h4(371))
  call Hloop_ZA_Q(ntryL,G1H8(211),ex2(:),G1H4(58),ngZu,m3h2x4(:,452),heltab2x8(:,:,507))
  call Hloop_A_Q(ntryL,G1H4(58),22,nMT,G2H4(42),n2h4(372))
  call Hloop_SA_Q(ntryL,G1H8(212),ex2(:),G1H4(63),ngH,m3h2x4(:,453),heltab2x8(:,:,508))
  call Hloop_A_Q(ntryL,G1H4(63),22,nMT,G2H4(43),n2h4(373))
  call Hloop_SA_Q(ntryL,G1H8(213),ex2(:),G1H4(69),ngX,m3h2x4(:,454),heltab2x8(:,:,509))
  call Hloop_A_Q(ntryL,G1H4(69),22,nMT,G2H4(53),n2h4(374))
  call Hloop_VA_Q(ntryL,G1H8(214),ex2(:),G1H4(75),m3h2x4(:,455),heltab2x8(:,:,510))
  call Hloop_A_Q(ntryL,G1H4(75),22,nMT,G2H4(52),n2h4(375))
  call Hloop_ZA_Q(ntryL,G1H8(215),ex2(:),G1H4(81),ngZu,m3h2x4(:,456),heltab2x8(:,:,511))
  call Hloop_A_Q(ntryL,G1H4(81),22,nMT,G2H4(54),n2h4(376))
  call Hloop_SS_S(ntryL,G1H8(216),wf4(:,14),G1H2(151),m3h4x2(:,56),heltab2x8(:,:,512))
  call Hloop_SS_S(ntryL,G1H8(217),wf4(:,14),G1H2(152),m3h4x2(:,57),heltab2x8(:,:,513))
  call Hloop_TS_V(ntryL,G1H8(218),18,wf4(:,14),9,G2H2(69),m3h4x2(:,58),heltab2x8(:,:,514))
  call Hloop_TS_V(ntryL,G1H8(219),18,wf4(:,14),9,G2H2(70),m3h4x2(:,59),heltab2x8(:,:,515))
  call Hloop_TS_V(ntryL,G1H8(220),18,wf4(:,14),9,G2H2(71),m3h4x2(:,60),heltab2x8(:,:,516))
  call Hloop_TS_V(ntryL,G1H8(221),18,wf4(:,14),9,G2H2(72),m3h4x2(:,61),heltab2x8(:,:,517))
  call Hloop_VS_T(ntryL,G1H8(222),18,wf4(:,14),9,G2H2(73),m3h4x2(:,62),heltab2x8(:,:,518))
  call Hloop_VS_T(ntryL,G1H8(223),18,wf4(:,14),9,G2H2(74),m3h4x2(:,63),heltab2x8(:,:,519))
  call Hloop_VS_T(ntryL,G1H8(224),18,wf4(:,14),9,G2H2(75),m3h4x2(:,64),heltab2x8(:,:,520))
  call Hloop_VS_T(ntryL,G1H8(225),18,wf4(:,14),9,G2H2(76),m3h4x2(:,65),heltab2x8(:,:,521))
  call Hloop_VS_V(ntryL,G1H8(226),wf4(:,14),G1H2(156),m3h4x2(:,66),heltab2x8(:,:,522))
  call Hloop_VS_V(ntryL,G1H8(227),wf4(:,14),G1H2(157),m3h4x2(:,67),heltab2x8(:,:,523))
  call Hloop_VS_V(ntryL,G1H8(228),wf4(:,14),G1H2(158),m3h4x2(:,68),heltab2x8(:,:,524))
  call Hloop_VS_V(ntryL,G1H8(229),wf4(:,14),G1H2(162),m3h4x2(:,69),heltab2x8(:,:,525))
  call Hotf_4pt_reduction(G2H8(7),RedSet_4(13),mass4set(:,2),  & 
G1H8(39),G1H8(40),G1H8(49),G1H8(51),G1H8(50),8)
  call HG1shiftOLR(G1H8(40),4,8)
  call Hloop_TV_S(ntryL,G1H8(230),18,wf4(:,17),9,G2H2(77),m3h4x2(:,70),heltab2x8(:,:,526))
  call Hloop_SV_T(ntryL,G1H8(231),18,wf4(:,17),9,G2H2(78),m3h4x2(:,71),heltab2x8(:,:,527))
  call Hloop_TV_S(ntryL,G1H8(232),18,wf4(:,17),9,G2H2(79),m3h4x2(:,72),heltab2x8(:,:,528))
  call Hloop_SV_T(ntryL,G1H8(233),18,wf4(:,17),9,G2H2(80),m3h4x2(:,73),heltab2x8(:,:,529))
  call Hloop_SV_V(ntryL,G1H8(234),wf4(:,17),G1H2(163),m3h4x2(:,74),heltab2x8(:,:,530))
  call Hloop_SV_V(ntryL,G1H8(235),wf4(:,17),G1H2(164),m3h4x2(:,75),heltab2x8(:,:,531))
  call Hloop_SV_V(ntryL,G1H8(236),wf4(:,17),G1H2(168),m3h4x2(:,76),heltab2x8(:,:,532))
  call Hloop_VV_S(ntryL,G1H8(237),wf4(:,17),G1H2(169),m3h4x2(:,77),heltab2x8(:,:,533))
  call Hloop_VV_S(ntryL,G1H8(238),wf4(:,17),G1H2(170),m3h4x2(:,78),heltab2x8(:,:,534))
  call Hloop_VV_S(ntryL,G1H8(239),wf4(:,17),G1H2(174),m3h4x2(:,79),heltab2x8(:,:,535))
  call Hloop_UV_W(ntryL,G1H8(240),18,wf4(:,17),9,G2H2(81),m3h4x2(:,80),heltab2x8(:,:,536))
  call Hloop_UW_V(ntryL,G1H8(241),18,wf4(:,17),9,G2H2(82),m3h4x2(:,81),heltab2x8(:,:,537))
  call Hloop_UV_W(ntryL,G1H8(242),18,wf4(:,17),9,G2H2(83),m3h4x2(:,82),heltab2x8(:,:,538))
  call Hloop_UW_V(ntryL,G1H8(243),18,wf4(:,17),9,G2H2(84),m3h4x2(:,83),heltab2x8(:,:,539))
  call Hotf_4pt_reduction(G2H8(8),RedSet_4(13),mass4set(:,2),  & 
G1H8(46),G1H8(47),G1H8(52),G1H8(53),G1H8(54),8)
  call HG1shiftOLR(G1H8(47),4,8)
  call Hloop_SA_Q(ntryL,G1H8(244),ex2(:),G1H4(87),ngH,m3h2x4(:,457),heltab2x8(:,:,540))
  call Hloop_A_Q(ntryL,G1H4(87),19,nMT,G2H4(56),n2h4(377))
  call Hloop_SA_Q(ntryL,G1H8(245),ex2(:),G1H4(93),ngX,m3h2x4(:,458),heltab2x8(:,:,541))
  call Hloop_A_Q(ntryL,G1H4(93),19,nMT,G2H4(58),n2h4(378))
  call Hloop_SA_Q(ntryL,G1H8(246),ex2(:),G1H4(99),ngPtb,m3h2x4(:,459),heltab2x8(:,:,542))
  call Hloop_A_Q(ntryL,G1H4(99),19,nMB,G2H4(49),n2h4(379))
  call Hloop_SA_Q(ntryL,G1H8(247),ex2(:),G1H4(105),ngH,m3h2x4(:,460),heltab2x8(:,:,543))
  call Hloop_A_Q(ntryL,G1H4(105),19,nMT,G2H4(57),n2h4(380))
  call Hloop_SA_Q(ntryL,G1H8(248),ex2(:),G1H4(111),ngX,m3h2x4(:,461),heltab2x8(:,:,544))
  call Hloop_A_Q(ntryL,G1H4(111),19,nMT,G2H4(51),n2h4(381))
  call Hloop_SA_Q(ntryL,G1H8(249),ex2(:),G1H4(117),ngPtb,m3h2x4(:,462),heltab2x8(:,:,545))
  call Hloop_A_Q(ntryL,G1H4(117),19,nMB,G2H4(55),n2h4(382))
  call Hloop_VA_Q(ntryL,G1H8(250),ex2(:),G1H4(85),m3h2x4(:,463),heltab2x8(:,:,546))
  call Hloop_A_Q(ntryL,G1H4(85),19,nMT,G2H4(59),n2h4(383))
  call Hloop_ZA_Q(ntryL,G1H8(251),ex2(:),G1H4(89),ngZu,m3h2x4(:,464),heltab2x8(:,:,547))
  call Hloop_A_Q(ntryL,G1H4(89),19,nMT,G2H4(60),n2h4(384))
  call Hloop_WA_Q(ntryL,G1H8(252),ex2(:),G1H4(90),m3h2x4(:,465),heltab2x8(:,:,548))
  call Hloop_A_Q(ntryL,G1H4(90),19,nMB,G2H4(61),n2h4(385))
  call Hloop_VA_Q(ntryL,G1H8(253),ex2(:),G1H4(97),m3h2x4(:,466),heltab2x8(:,:,549))
  call Hloop_A_Q(ntryL,G1H4(97),19,nMT,G2H4(62),n2h4(386))
  call Hloop_ZA_Q(ntryL,G1H8(254),ex2(:),G1H4(98),ngZu,m3h2x4(:,467),heltab2x8(:,:,550))
  call Hloop_A_Q(ntryL,G1H4(98),19,nMT,G2H4(63),n2h4(387))
  call Hloop_WA_Q(ntryL,G1H8(255),ex2(:),G1H4(102),m3h2x4(:,468),heltab2x8(:,:,551))
  call Hloop_A_Q(ntryL,G1H4(102),19,nMB,G2H4(73),n2h4(388))
  call Hloop_SA_Q(ntryL,G1H8(256),ex2(:),G1H4(110),ngH,m3h2x4(:,469),heltab2x8(:,:,552))
  call Hloop_A_Q(ntryL,G1H4(110),19,nMT,G2H4(72),n2h4(389))
  call Hloop_SA_Q(ntryL,G1H8(257),ex2(:),G1H4(113),ngX,m3h2x4(:,470),heltab2x8(:,:,553))
  call Hloop_A_Q(ntryL,G1H4(113),19,nMT,G2H4(74),n2h4(390))
  call Hloop_SA_Q(ntryL,G1H8(258),ex2(:),G1H4(114),ngPtb,m3h2x4(:,471),heltab2x8(:,:,554))
  call Hloop_A_Q(ntryL,G1H4(114),19,nMB,G2H4(76),n2h4(391))
  call Hloop_SA_Q(ntryL,G1H8(259),ex2(:),G1H4(121),ngH,m3h2x4(:,472),heltab2x8(:,:,555))
  call Hloop_A_Q(ntryL,G1H4(121),19,nMT,G2H4(78),n2h4(392))
  call Hloop_SA_Q(ntryL,G1H8(260),ex2(:),G1H4(122),ngX,m3h2x4(:,473),heltab2x8(:,:,556))
  call Hloop_A_Q(ntryL,G1H4(122),19,nMT,G2H4(69),n2h4(393))
  call Hloop_SA_Q(ntryL,G1H8(261),ex2(:),G1H4(126),ngPtb,m3h2x4(:,474),heltab2x8(:,:,557))
  call Hloop_A_Q(ntryL,G1H4(126),19,nMB,G2H4(77),n2h4(394))
  call Hloop_VA_Q(ntryL,G1H8(262),ex2(:),G1H4(154),m3h2x4(:,475),heltab2x8(:,:,558))
  call Hloop_A_Q(ntryL,G1H4(154),19,nMT,G2H4(71),n2h4(395))
  call Hloop_ZA_Q(ntryL,G1H8(263),ex2(:),G1H4(155),ngZu,m3h2x4(:,476),heltab2x8(:,:,559))
  call Hloop_A_Q(ntryL,G1H4(155),19,nMT,G2H4(75),n2h4(396))
  call Hloop_WA_Q(ntryL,G1H8(264),ex2(:),G1H4(156),m3h2x4(:,477),heltab2x8(:,:,560))
  call Hloop_A_Q(ntryL,G1H4(156),19,nMB,G2H4(79),n2h4(397))
  call Hloop_VA_Q(ntryL,G1H8(265),ex2(:),G1H4(161),m3h2x4(:,478),heltab2x8(:,:,561))
  call Hloop_A_Q(ntryL,G1H4(161),19,nMT,G2H4(80),n2h4(398))
  call Hloop_ZA_Q(ntryL,G1H8(266),ex2(:),G1H4(162),ngZu,m3h2x4(:,479),heltab2x8(:,:,562))
  call Hloop_A_Q(ntryL,G1H4(162),19,nMT,G2H4(81),n2h4(399))
  call Hloop_WA_Q(ntryL,G1H8(267),ex2(:),G1H4(164),m3h2x4(:,480),heltab2x8(:,:,563))
  call Hloop_A_Q(ntryL,G1H4(164),19,nMB,G2H4(82),n2h4(400))
  call Hloop_SQ_A(ntryL,G1H8(268),ex1(:),G1H4(186),ngH,m3h2x4(:,481),heltab2x8(:,:,564))
  call Hloop_Q_A(ntryL,G1H4(186),19,nMT,G2H4(83),n2h4(401))
  call Hloop_SQ_A(ntryL,G1H8(269),ex1(:),G1H4(188),ngX,m3h2x4(:,482),heltab2x8(:,:,565))
  call Hloop_Q_A(ntryL,G1H4(188),19,nMT,G2H4(84),n2h4(402))
  call Hloop_SQ_A(ntryL,G1H8(270),ex1(:),G1H4(198),ngPbt,m3h2x4(:,483),heltab2x8(:,:,566))
  call Hloop_Q_A(ntryL,G1H4(198),19,nMB,G2H4(85),n2h4(403))
  call Hloop_SQ_A(ntryL,G1H8(271),ex1(:),G1H4(200),ngH,m3h2x4(:,484),heltab2x8(:,:,567))
  call Hloop_Q_A(ntryL,G1H4(200),19,nMT,G2H4(86),n2h4(404))
  call Hloop_SQ_A(ntryL,G1H8(272),ex1(:),G1H4(219),ngX,m3h2x4(:,485),heltab2x8(:,:,568))
  call Hloop_Q_A(ntryL,G1H4(219),19,nMT,G2H4(87),n2h4(405))
  call Hloop_SQ_A(ntryL,G1H8(273),ex1(:),G1H4(220),ngPbt,m3h2x4(:,486),heltab2x8(:,:,569))
  call Hloop_Q_A(ntryL,G1H4(220),19,nMB,G2H4(88),n2h4(406))
  call Hloop_VQ_A(ntryL,G1H8(274),ex1(:),G1H4(221),m3h2x4(:,487),heltab2x8(:,:,570))
  call Hloop_Q_A(ntryL,G1H4(221),19,nMT,G2H4(89),n2h4(407))
  call Hloop_ZQ_A(ntryL,G1H8(275),ex1(:),G1H4(223),ngZu,m3h2x4(:,488),heltab2x8(:,:,571))
  call Hloop_Q_A(ntryL,G1H4(223),19,nMT,G2H4(95),n2h4(408))
  call Hloop_WQ_A(ntryL,G1H8(276),ex1(:),G1H4(225),m3h2x4(:,489),heltab2x8(:,:,572))
  call Hloop_Q_A(ntryL,G1H4(225),19,nMB,G2H4(94),n2h4(409))
  call Hloop_VQ_A(ntryL,G1H8(277),ex1(:),G1H4(226),m3h2x4(:,490),heltab2x8(:,:,573))
  call Hloop_Q_A(ntryL,G1H4(226),19,nMT,G2H4(96),n2h4(410))
  call Hloop_ZQ_A(ntryL,G1H8(278),ex1(:),G1H4(238),ngZu,m3h2x4(:,491),heltab2x8(:,:,574))
  call Hloop_Q_A(ntryL,G1H4(238),19,nMT,G2H4(93),n2h4(411))
  call Hloop_WQ_A(ntryL,G1H8(279),ex1(:),G1H4(239),m3h2x4(:,492),heltab2x8(:,:,575))
  call Hloop_Q_A(ntryL,G1H4(239),19,nMB,G2H4(102),n2h4(412))
  call Hloop_SQ_A(ntryL,G1H8(280),ex1(:),G1H4(240),ngH,m3h2x4(:,493),heltab2x8(:,:,576))
  call Hloop_Q_A(ntryL,G1H4(240),19,nMT,G2H4(104),n2h4(413))
  call Hloop_SQ_A(ntryL,G1H8(281),ex1(:),G1H4(241),ngX,m3h2x4(:,494),heltab2x8(:,:,577))
  call Hloop_Q_A(ntryL,G1H4(241),19,nMT,G2H4(99),n2h4(414))
  call Hloop_SQ_A(ntryL,G1H8(282),ex1(:),G1H4(242),ngPbt,m3h2x4(:,495),heltab2x8(:,:,578))
  call Hloop_Q_A(ntryL,G1H4(242),19,nMB,G2H4(103),n2h4(415))
  call Hloop_SQ_A(ntryL,G1H8(283),ex1(:),G1H4(244),ngH,m3h2x4(:,496),heltab2x8(:,:,579))
  call Hloop_Q_A(ntryL,G1H4(244),19,nMT,G2H4(101),n2h4(416))
  call Hloop_SQ_A(ntryL,G1H8(284),ex1(:),G1H4(254),ngX,m3h2x4(:,497),heltab2x8(:,:,580))
  call Hloop_Q_A(ntryL,G1H4(254),19,nMT,G2H4(105),n2h4(417))
  call Hloop_SQ_A(ntryL,G1H8(285),ex1(:),G1H4(256),ngPbt,m3h2x4(:,498),heltab2x8(:,:,581))
  call Hloop_Q_A(ntryL,G1H4(256),19,nMB,G2H4(115),n2h4(418))
  call Hloop_VQ_A(ntryL,G1H8(286),ex1(:),G1H4(257),m3h2x4(:,499),heltab2x8(:,:,582))
  call Hloop_Q_A(ntryL,G1H4(257),19,nMT,G2H4(114),n2h4(419))
  call Hloop_ZQ_A(ntryL,G1H8(287),ex1(:),G1H4(264),ngZu,m3h2x4(:,500),heltab2x8(:,:,583))
  call Hloop_Q_A(ntryL,G1H4(264),19,nMT,G2H4(116),n2h4(420))
  call Hloop_WQ_A(ntryL,G1H8(288),ex1(:),G1H4(266),m3h2x4(:,501),heltab2x8(:,:,584))
  call Hloop_Q_A(ntryL,G1H4(266),19,nMB,G2H4(118),n2h4(421))
  call Hloop_VQ_A(ntryL,G1H8(289),ex1(:),G1H4(267),m3h2x4(:,502),heltab2x8(:,:,585))
  call Hloop_Q_A(ntryL,G1H4(267),19,nMT,G2H4(120),n2h4(422))
  call Hloop_ZQ_A(ntryL,G1H8(290),ex1(:),G1H4(275),ngZu,m3h2x4(:,503),heltab2x8(:,:,586))
  call Hloop_Q_A(ntryL,G1H4(275),19,nMT,G2H4(111),n2h4(423))
  call Hloop_WQ_A(ntryL,G1H8(291),ex1(:),G1H4(276),m3h2x4(:,504),heltab2x8(:,:,587))
  call Hloop_Q_A(ntryL,G1H4(276),19,nMB,G2H4(119),n2h4(424))
  call Hloop_SS_S(ntryL,G1H8(292),wf4(:,18),G1H2(175),m3h4x2(:,84),heltab2x8(:,:,588))
  call Hloop_SS_S(ntryL,G1H8(293),wf4(:,18),G1H2(176),m3h4x2(:,85),heltab2x8(:,:,589))
  call Hloop_SS_S(ntryL,G1H8(294),wf4(:,18),G1H2(180),m3h4x2(:,86),heltab2x8(:,:,590))
  call Hloop_SS_S(ntryL,G1H8(295),wf4(:,19),G1H2(181),m3h4x2(:,87),heltab2x8(:,:,591))
  call Hloop_SS_S(ntryL,G1H8(296),wf4(:,19),G1H2(182),m3h4x2(:,88),heltab2x8(:,:,592))
  call Hloop_ST_V(ntryL,G1H8(297),17,wf4(:,18),12,G2H2(85),m3h4x2(:,89),heltab2x8(:,:,593))
  call Hloop_ST_V(ntryL,G1H8(298),17,wf4(:,18),12,G2H2(86),m3h4x2(:,90),heltab2x8(:,:,594))
  call Hloop_TS_V(ntryL,G1H8(299),17,wf4(:,19),12,G2H2(87),m3h4x2(:,91),heltab2x8(:,:,595))
  call Hloop_ST_V(ntryL,G1H8(300),17,wf4(:,19),12,G2H2(88),m3h4x2(:,92),heltab2x8(:,:,596))
  call Hloop_VT_S(ntryL,G1H8(301),17,wf4(:,18),12,G2H2(89),m3h4x2(:,93),heltab2x8(:,:,597))
  call Hloop_VT_S(ntryL,G1H8(302),17,wf4(:,18),12,G2H2(90),m3h4x2(:,94),heltab2x8(:,:,598))
  call Hloop_VS_T(ntryL,G1H8(303),17,wf4(:,19),12,G2H2(91),m3h4x2(:,95),heltab2x8(:,:,599))
  call Hloop_VT_S(ntryL,G1H8(304),17,wf4(:,19),12,G2H2(92),m3h4x2(:,96),heltab2x8(:,:,600))
  call Hloop_VS_V(ntryL,G1H8(305),wf4(:,18),G1H2(186),m3h4x2(:,97),heltab2x8(:,:,601))
  call Hloop_VS_V(ntryL,G1H8(306),wf4(:,18),G1H2(187),m3h4x2(:,98),heltab2x8(:,:,602))
  call Hotf_4pt_reduction(G2H8(9),RedSet_4(31),mass4set(:,3),  & 
G1H8(55),G1H8(60),G1H8(57),G1H8(58),G1H8(59),8)
  call HG1shiftOLR(G1H8(60),2,8)
  call Hotf_4pt_reduction(G2H8(10),RedSet_4(31),mass4set(:,3),  & 
G1H8(65),G1H8(62),G1H8(63),G1H8(64),G1H8(71),8)
  call HG1shiftOLR(G1H8(62),2,8)
  call Hloop_SV_T(ntryL,G1H8(307),17,wf4(:,2),12,G2H2(93),m3h4x2(:,99),heltab2x8(:,:,603))
  call Hloop_TV_S(ntryL,G1H8(308),17,wf4(:,20),12,G2H2(95),m3h4x2(:,100),heltab2x8(:,:,604))
  call Hloop_SV_T(ntryL,G1H8(309),17,wf4(:,20),12,G2H2(102),m3h4x2(:,101),heltab2x8(:,:,605))
  call Hloop_SV_T(ntryL,G1H8(310),17,wf4(:,20),12,G2H2(104),m3h4x2(:,102),heltab2x8(:,:,606))
  call Hloop_SV_V(ntryL,G1H8(311),wf4(:,2),G1H2(188),m3h4x2(:,103),heltab2x8(:,:,607))
  call Hloop_SV_V(ntryL,G1H8(312),wf4(:,20),G1H2(192),m3h4x2(:,104),heltab2x8(:,:,608))
  call Hloop_SV_V(ntryL,G1H8(313),wf4(:,20),G1H2(193),m3h4x2(:,105),heltab2x8(:,:,609))
  call Hloop_VV_S(ntryL,G1H8(314),wf4(:,2),G1H2(194),m3h4x2(:,106),heltab2x8(:,:,610))
  call Hloop_VV_S(ntryL,G1H8(315),wf4(:,20),G1H2(198),m3h4x2(:,107),heltab2x8(:,:,611))
  call Hloop_VV_S(ntryL,G1H8(316),wf4(:,20),G1H2(199),m3h4x2(:,108),heltab2x8(:,:,612))
  call Hloop_UW_V(ntryL,G1H8(317),17,wf4(:,2),12,G2H2(99),m3h4x2(:,109),heltab2x8(:,:,613))
  call Hloop_UW_V(ntryL,G1H8(318),17,wf4(:,20),12,G2H2(101),m3h4x2(:,110),heltab2x8(:,:,614))
  call Hotf_4pt_reduction(G2H8(11),RedSet_4(31),mass4set(:,3),  & 
G1H8(70),G1H8(68),G1H8(69),G1H8(72),G1H8(73),8)
  call HG1shiftOLR(G1H8(68),2,8)
  call Hotf_4pt_reduction(G2H8(12),RedSet_4(31),mass4set(:,3),  & 
G1H8(74),G1H8(75),G1H8(76),G1H8(82),G1H8(83),8)
  call HG1shiftOLR(G1H8(75),2,8)
  call Hloop_QA_S(ntryL,G1H4(95),ex2(:),G1H2(200),ngH,m3h2x2(:,243),heltab2x4(:,:,243))
  call Hloop_QA_S(ntryL,G1H4(86),ex2(:),G1H2(204),ngPtb,m3h2x2(:,244),heltab2x4(:,:,244))
  call Hloop_QA_S(ntryL,G1H4(96),ex2(:),G1H2(205),ngX,m3h2x2(:,245),heltab2x4(:,:,245))
  call Hloop_QA_S(ntryL,G1H4(92),ex2(:),G1H2(206),ngPtb,m3h2x2(:,246),heltab2x4(:,:,246))
  call Hloop_QA_S(ntryL,G1H4(91),ex2(:),G1H2(210),ngPtb,m3h2x2(:,247),heltab2x4(:,:,247))
  call Hloop_QA_V(ntryL,G1H4(103),ex2(:),G1H2(211),m3h2x2(:,248),heltab2x4(:,:,248))
  call Hloop_QA_Z(ntryL,G1H4(107),ex2(:),G1H2(212),ngZu,m3h2x2(:,249),heltab2x4(:,:,249))
  call Hloop_QA_W(ntryL,G1H4(101),ex2(:),G1H2(216),m3h2x2(:,250),heltab2x4(:,:,250))
  call Hloop_QA_W(ntryL,G1H4(108),ex2(:),G1H2(217),m3h2x2(:,251),heltab2x4(:,:,251))
  call Hloop_QA_W(ntryL,G1H4(104),ex2(:),G1H2(218),m3h2x2(:,252),heltab2x4(:,:,252))
  call Hloop_AQ_S(ntryL,G1H4(109),ex3(:),G1H2(222),ngPtb,m3h2x2(:,253),heltab2x4(:,:,253))
  call Hloop_AQ_S(ntryL,G1H4(131),ex3(:),G1H2(223),ngH,m3h2x2(:,254),heltab2x4(:,:,254))
  call Hloop_AQ_S(ntryL,G1H4(128),ex3(:),G1H2(224),ngPtb,m3h2x2(:,255),heltab2x4(:,:,255))
  call Hloop_AQ_S(ntryL,G1H4(132),ex3(:),G1H2(228),ngX,m3h2x2(:,256),heltab2x4(:,:,256))
  call Hloop_SQ_A(ntryL,G1H4(115),ex3(:),G1H2(229),ngH,m3h2x2(:,257),heltab2x4(:,:,257))
  call Hloop_Q_A(ntryL,G1H2(229),23,nMB,G2H2(108),n2h2(111))
  call Hloop_SQ_A(ntryL,G1H4(116),ex3(:),G1H2(230),ngH,m3h2x2(:,258),heltab2x4(:,:,258))
  call Hloop_Q_A(ntryL,G1H2(230),23,nMB,G2H2(110),n2h2(112))
  call Hloop_SQ_A(ntryL,G1H4(119),ex3(:),G1H2(234),ngX,m3h2x2(:,259),heltab2x4(:,:,259))
  call Hloop_Q_A(ntryL,G1H2(234),23,nMB,G2H2(111),n2h2(113))
  call Hloop_SQ_A(ntryL,G1H4(120),ex3(:),G1H2(235),ngX,m3h2x2(:,260),heltab2x4(:,:,260))
  call Hloop_Q_A(ntryL,G1H2(235),23,nMB,G2H2(113),n2h2(114))
  call Hloop_AQ_V(ntryL,G1H4(2),ex3(:),G1H2(236),m3h2x2(:,261),heltab2x4(:,:,261))
  call Hloop_AQ_Z(ntryL,G1H4(6),ex3(:),G1H2(240),ngZd,m3h2x2(:,262),heltab2x4(:,:,262))
  call Hloop_AQ_W(ntryL,G1H4(125),ex3(:),G1H2(241),m3h2x2(:,263),heltab2x4(:,:,263))
  call Hloop_AQ_W(ntryL,G1H4(5),ex3(:),G1H2(242),m3h2x2(:,264),heltab2x4(:,:,264))
  call Hloop_AQ_S(ntryL,G1H4(127),ex3(:),G1H2(246),ngPtb,m3h2x2(:,265),heltab2x4(:,:,265))
  call Hloop_SQ_A(ntryL,G1H4(137),ex3(:),G1H2(247),ngH,m3h2x2(:,266),heltab2x4(:,:,266))
  call Hloop_Q_A(ntryL,G1H2(247),23,nMB,G2H2(120),n2h2(115))
  call Hloop_SQ_A(ntryL,G1H4(138),ex3(:),G1H2(248),ngX,m3h2x2(:,267),heltab2x4(:,:,267))
  call Hloop_Q_A(ntryL,G1H2(248),23,nMB,G2H2(122),n2h2(116))
  call Hloop_VQ_A(ntryL,G1H4(139),ex3(:),G1H2(252),m3h2x2(:,268),heltab2x4(:,:,268))
  call Hloop_Q_A(ntryL,G1H2(252),23,nMB,G2H2(117),n2h2(117))
  call Hloop_VQ_A(ntryL,G1H4(140),ex3(:),G1H2(253),m3h2x2(:,269),heltab2x4(:,:,269))
  call Hloop_Q_A(ntryL,G1H2(253),23,nMB,G2H2(119),n2h2(118))
  call Hloop_ZQ_A(ntryL,G1H4(143),ex3(:),G1H2(254),ngZd,m3h2x2(:,270),heltab2x4(:,:,270))
  call Hloop_Q_A(ntryL,G1H2(254),23,nMB,G2H2(123),n2h2(119))
  call Hloop_ZQ_A(ntryL,G1H4(144),ex3(:),G1H2(258),ngZd,m3h2x2(:,271),heltab2x4(:,:,271))
  call Hloop_Q_A(ntryL,G1H2(258),23,nMB,G2H2(125),n2h2(120))
  call Hloop_AQ_W(ntryL,G1H4(1),ex3(:),G1H2(259),m3h2x2(:,272),heltab2x4(:,:,272))
  call Hloop_VQ_A(ntryL,G1H4(8),ex3(:),G1H2(260),m3h2x2(:,273),heltab2x4(:,:,273))
  call Hloop_Q_A(ntryL,G1H2(260),23,nMB,G2H2(132),n2h2(121))
  call Hloop_ZQ_A(ntryL,G1H4(12),ex3(:),G1H2(264),ngZd,m3h2x2(:,274),heltab2x4(:,:,274))
  call Hloop_Q_A(ntryL,G1H2(264),23,nMB,G2H2(134),n2h2(122))
  call Hloop_SA_Q(ntryL,G1H4(13),ex4(:),G1H2(265),ngH,m3h2x2(:,275),heltab2x4(:,:,275))
  call Hloop_A_Q(ntryL,G1H2(265),27,nMB,G2H2(129),n2h2(123))
  call Hloop_SA_Q(ntryL,G1H4(14),ex4(:),G1H2(266),ngH,m3h2x2(:,276),heltab2x4(:,:,276))
  call Hloop_A_Q(ntryL,G1H2(266),27,nMB,G2H2(131),n2h2(124))
  call Hloop_SA_Q(ntryL,G1H4(17),ex4(:),G1H2(270),ngX,m3h2x2(:,277),heltab2x4(:,:,277))
  call Hloop_A_Q(ntryL,G1H2(270),27,nMB,G2H2(135),n2h2(125))
  call Hloop_SA_Q(ntryL,G1H4(18),ex4(:),G1H2(271),ngX,m3h2x2(:,278),heltab2x4(:,:,278))
  call Hloop_A_Q(ntryL,G1H2(271),27,nMB,G2H2(137),n2h2(126))
  call Hloop_SA_Q(ntryL,G1H4(19),ex4(:),G1H2(272),ngPbt,m3h2x2(:,279),heltab2x4(:,:,279))
  call Hloop_A_Q(ntryL,G1H2(272),27,nMT,G2H2(144),n2h2(127))
  call Hloop_SA_Q(ntryL,G1H4(24),ex4(:),G1H2(276),ngH,m3h2x2(:,280),heltab2x4(:,:,280))
  call Hloop_A_Q(ntryL,G1H2(276),27,nMB,G2H2(146),n2h2(128))
  call Hloop_SA_Q(ntryL,G1H4(25),ex4(:),G1H2(277),ngX,m3h2x2(:,281),heltab2x4(:,:,281))
  call Hloop_A_Q(ntryL,G1H2(277),27,nMB,G2H2(141),n2h2(129))
  call Hloop_SA_Q(ntryL,G1H4(26),ex4(:),G1H2(278),ngPbt,m3h2x2(:,282),heltab2x4(:,:,282))
  call Hloop_A_Q(ntryL,G1H2(278),27,nMT,G2H2(143),n2h2(130))
  call Hloop_VA_Q(ntryL,G1H4(29),ex4(:),G1H2(282),m3h2x2(:,283),heltab2x4(:,:,283))
  call Hloop_A_Q(ntryL,G1H2(282),27,nMB,G2H2(150),n2h2(131))
  call Hloop_VA_Q(ntryL,G1H4(30),ex4(:),G1H2(283),m3h2x2(:,284),heltab2x4(:,:,284))
  call Hloop_A_Q(ntryL,G1H2(283),27,nMB,G2H2(152),n2h2(132))
  call Hloop_ZA_Q(ntryL,G1H4(31),ex4(:),G1H2(284),ngZd,m3h2x2(:,285),heltab2x4(:,:,285))
  call Hloop_A_Q(ntryL,G1H2(284),27,nMB,G2H2(156),n2h2(133))
  call Hloop_ZA_Q(ntryL,G1H4(32),ex4(:),G1H2(288),ngZd,m3h2x2(:,286),heltab2x4(:,:,286))
  call Hloop_A_Q(ntryL,G1H2(288),27,nMB,G2H2(158),n2h2(134))
  call Hloop_WA_Q(ntryL,G1H4(35),ex4(:),G1H2(289),m3h2x2(:,287),heltab2x4(:,:,287))
  call Hloop_A_Q(ntryL,G1H2(289),27,nMT,G2H2(162),n2h2(135))
  call Hloop_VA_Q(ntryL,G1H4(37),ex4(:),G1H2(290),m3h2x2(:,288),heltab2x4(:,:,288))
  call Hloop_A_Q(ntryL,G1H2(290),27,nMB,G2H2(164),n2h2(136))
  call Hloop_ZA_Q(ntryL,G1H4(41),ex4(:),G1H2(294),ngZd,m3h2x2(:,289),heltab2x4(:,:,289))
  call Hloop_A_Q(ntryL,G1H2(294),27,nMB,G2H2(165),n2h2(137))
  call Hloop_WA_Q(ntryL,G1H4(42),ex4(:),G1H2(295),m3h2x2(:,290),heltab2x4(:,:,290))
  call Hloop_A_Q(ntryL,G1H2(295),27,nMT,G2H2(166),n2h2(138))
  call Hloop_SQ_A(ntryL,G1H4(43),ex1(:),G1H2(296),ngH,m3h2x2(:,291),heltab2x4(:,:,291))
  call Hloop_Q_A(ntryL,G1H2(296),23,nMT,G2H2(167),n2h2(139))
  call Hloop_SQ_A(ntryL,G1H4(44),ex1(:),G1H2(300),ngPbt,m3h2x2(:,292),heltab2x4(:,:,292))
  call Hloop_Q_A(ntryL,G1H2(300),23,nMB,G2H2(168),n2h2(140))
  call Hloop_SQ_A(ntryL,G1H4(47),ex1(:),G1H2(301),ngX,m3h2x2(:,293),heltab2x4(:,:,293))
  call Hloop_Q_A(ntryL,G1H2(301),23,nMT,G2H2(169),n2h2(141))
  call Hloop_SQ_A(ntryL,G1H4(48),ex1(:),G1H2(302),ngPbt,m3h2x2(:,294),heltab2x4(:,:,294))
  call Hloop_Q_A(ntryL,G1H2(302),23,nMB,G2H2(170),n2h2(142))
  call Hloop_SQ_A(ntryL,G1H4(50),ex1(:),G1H2(306),ngPbt,m3h2x2(:,295),heltab2x4(:,:,295))
  call Hloop_Q_A(ntryL,G1H2(306),23,nMB,G2H2(171),n2h2(143))
  call Hloop_SQ_A(ntryL,G1H4(53),ex1(:),G1H2(307),ngH,m3h2x2(:,296),heltab2x4(:,:,296))
  call Hloop_Q_A(ntryL,G1H2(307),23,nMT,G2H2(172),n2h2(144))
  call Hloop_SQ_A(ntryL,G1H4(54),ex1(:),G1H2(308),ngX,m3h2x2(:,297),heltab2x4(:,:,297))
  call Hloop_Q_A(ntryL,G1H2(308),23,nMT,G2H2(173),n2h2(145))
  call Hloop_VQ_A(ntryL,G1H4(55),ex1(:),G1H2(312),m3h2x2(:,298),heltab2x4(:,:,298))
  call Hloop_Q_A(ntryL,G1H2(312),23,nMT,G2H2(174),n2h2(146))
  call Hloop_ZQ_A(ntryL,G1H4(56),ex1(:),G1H2(313),ngZu,m3h2x2(:,299),heltab2x4(:,:,299))
  call Hloop_Q_A(ntryL,G1H2(313),23,nMT,G2H2(175),n2h2(147))
  call Hloop_WQ_A(ntryL,G1H4(59),ex1(:),G1H2(314),m3h2x2(:,300),heltab2x4(:,:,300))
  call Hloop_Q_A(ntryL,G1H2(314),23,nMB,G2H2(176),n2h2(148))
  call Hloop_WQ_A(ntryL,G1H4(60),ex1(:),G1H2(318),m3h2x2(:,301),heltab2x4(:,:,301))
  call Hloop_Q_A(ntryL,G1H2(318),23,nMB,G2H2(177),n2h2(149))
  call Hloop_VQ_A(ntryL,G1H4(61),ex1(:),G1H2(319),m3h2x2(:,302),heltab2x4(:,:,302))
  call Hloop_Q_A(ntryL,G1H2(319),23,nMT,G2H2(178),n2h2(150))
  call Hloop_ZQ_A(ntryL,G1H4(65),ex1(:),G1H2(320),ngZu,m3h2x2(:,303),heltab2x4(:,:,303))
  call Hloop_Q_A(ntryL,G1H2(320),23,nMT,G2H2(179),n2h2(151))
  call Hloop_WQ_A(ntryL,G1H4(66),ex1(:),G1H2(324),m3h2x2(:,304),heltab2x4(:,:,304))
  call Hloop_Q_A(ntryL,G1H2(324),23,nMB,G2H2(180),n2h2(152))
  call Hloop_SQ_A(ntryL,G1H4(67),ex3(:),G1H2(325),ngH,m3h2x2(:,305),heltab2x4(:,:,305))
  call Hloop_Q_A(ntryL,G1H2(325),23,nMB,G2H2(181),n2h2(153))
  call Hloop_SQ_A(ntryL,G1H4(68),ex3(:),G1H2(326),ngH,m3h2x2(:,306),heltab2x4(:,:,306))
  call Hloop_Q_A(ntryL,G1H2(326),23,nMB,G2H2(182),n2h2(154))
  call Hloop_SQ_A(ntryL,G1H4(71),ex3(:),G1H2(330),ngX,m3h2x2(:,307),heltab2x4(:,:,307))
  call Hloop_Q_A(ntryL,G1H2(330),23,nMB,G2H2(183),n2h2(155))
  call Hloop_SQ_A(ntryL,G1H4(72),ex3(:),G1H2(331),ngX,m3h2x2(:,308),heltab2x4(:,:,308))
  call Hloop_Q_A(ntryL,G1H2(331),23,nMB,G2H2(184),n2h2(156))
  call Hloop_SQ_A(ntryL,G1H4(73),ex3(:),G1H2(332),ngPtb,m3h2x2(:,309),heltab2x4(:,:,309))
  call Hloop_Q_A(ntryL,G1H2(332),23,nMT,G2H2(185),n2h2(157))
  call Hloop_SQ_A(ntryL,G1H4(78),ex3(:),G1H2(336),ngH,m3h2x2(:,310),heltab2x4(:,:,310))
  call Hloop_Q_A(ntryL,G1H2(336),23,nMB,G2H2(186),n2h2(158))
  call Hloop_SQ_A(ntryL,G1H4(79),ex3(:),G1H2(337),ngX,m3h2x2(:,311),heltab2x4(:,:,311))
  call Hloop_Q_A(ntryL,G1H2(337),23,nMB,G2H2(187),n2h2(159))
  call Hloop_SQ_A(ntryL,G1H4(80),ex3(:),G1H2(338),ngPtb,m3h2x2(:,312),heltab2x4(:,:,312))
  call Hloop_Q_A(ntryL,G1H2(338),23,nMT,G2H2(188),n2h2(160))
  call Hloop_VQ_A(ntryL,G1H4(83),ex3(:),G1H2(342),m3h2x2(:,313),heltab2x4(:,:,313))
  call Hloop_Q_A(ntryL,G1H2(342),23,nMB,G2H2(189),n2h2(161))
  call Hloop_VQ_A(ntryL,G1H4(84),ex3(:),G1H2(343),m3h2x2(:,314),heltab2x4(:,:,314))
  call Hloop_Q_A(ntryL,G1H2(343),23,nMB,G2H2(190),n2h2(162))
  call Hloop_ZQ_A(ntryL,G1H4(145),ex3(:),G1H2(344),ngZd,m3h2x2(:,315),heltab2x4(:,:,315))
  call Hloop_Q_A(ntryL,G1H2(344),23,nMB,G2H2(191),n2h2(163))
  call Hloop_ZQ_A(ntryL,G1H4(146),ex3(:),G1H2(348),ngZd,m3h2x2(:,316),heltab2x4(:,:,316))
  call Hloop_Q_A(ntryL,G1H2(348),23,nMB,G2H2(192),n2h2(164))
  call Hloop_WQ_A(ntryL,G1H4(147),ex3(:),G1H2(349),m3h2x2(:,317),heltab2x4(:,:,317))
  call Hloop_Q_A(ntryL,G1H2(349),23,nMT,G2H2(193),n2h2(165))
  call Hloop_VQ_A(ntryL,G1H4(149),ex3(:),G1H2(350),m3h2x2(:,318),heltab2x4(:,:,318))
  call Hloop_Q_A(ntryL,G1H2(350),23,nMB,G2H2(194),n2h2(166))
  call Hloop_ZQ_A(ntryL,G1H4(151),ex3(:),G1H2(354),ngZd,m3h2x2(:,319),heltab2x4(:,:,319))
  call Hloop_Q_A(ntryL,G1H2(354),23,nMB,G2H2(195),n2h2(167))
  call Hloop_WQ_A(ntryL,G1H4(152),ex3(:),G1H2(355),m3h2x2(:,320),heltab2x4(:,:,320))
  call Hloop_Q_A(ntryL,G1H2(355),23,nMT,G2H2(196),n2h2(168))
  call Hloop_QA_S(ntryL,G1H4(153),ex4(:),G1H2(356),ngPbt,m3h2x2(:,321),heltab2x4(:,:,321))
  call Hloop_QA_S(ntryL,G1H4(167),ex4(:),G1H2(360),ngH,m3h2x2(:,322),heltab2x4(:,:,322))
  call Hloop_QA_S(ntryL,G1H4(166),ex4(:),G1H2(361),ngPbt,m3h2x2(:,323),heltab2x4(:,:,323))
  call Hloop_QA_S(ntryL,G1H4(168),ex4(:),G1H2(362),ngX,m3h2x2(:,324),heltab2x4(:,:,324))
  call Hloop_SA_Q(ntryL,G1H4(157),ex4(:),G1H2(366),ngH,m3h2x2(:,325),heltab2x4(:,:,325))
  call Hloop_A_Q(ntryL,G1H2(366),27,nMB,G2H2(197),n2h2(169))
  call Hloop_SA_Q(ntryL,G1H4(158),ex4(:),G1H2(367),ngH,m3h2x2(:,326),heltab2x4(:,:,326))
  call Hloop_A_Q(ntryL,G1H2(367),27,nMB,G2H2(198),n2h2(170))
  call Hloop_SA_Q(ntryL,G1H4(159),ex4(:),G1H2(368),ngX,m3h2x2(:,327),heltab2x4(:,:,327))
  call Hloop_A_Q(ntryL,G1H2(368),27,nMB,G2H2(199),n2h2(171))
  call Hloop_SA_Q(ntryL,G1H4(160),ex4(:),G1H2(372),ngX,m3h2x2(:,328),heltab2x4(:,:,328))
  call Hloop_A_Q(ntryL,G1H2(372),27,nMB,G2H2(200),n2h2(172))
  call Hloop_QA_V(ntryL,G1H4(178),ex4(:),G1H2(373),m3h2x2(:,329),heltab2x4(:,:,329))
  call Hloop_QA_Z(ntryL,G1H4(180),ex4(:),G1H2(374),ngZd,m3h2x2(:,330),heltab2x4(:,:,330))
  call Hloop_QA_W(ntryL,G1H4(163),ex4(:),G1H2(378),m3h2x2(:,331),heltab2x4(:,:,331))
  call Hloop_QA_W(ntryL,G1H4(179),ex4(:),G1H2(379),m3h2x2(:,332),heltab2x4(:,:,332))
  call Hloop_QA_S(ntryL,G1H4(165),ex4(:),G1H2(380),ngPbt,m3h2x2(:,333),heltab2x4(:,:,333))
  call Hloop_SA_Q(ntryL,G1H4(171),ex4(:),G1H2(384),ngH,m3h2x2(:,334),heltab2x4(:,:,334))
  call Hloop_A_Q(ntryL,G1H2(384),27,nMB,G2H2(201),n2h2(173))
  call Hloop_SA_Q(ntryL,G1H4(172),ex4(:),G1H2(385),ngX,m3h2x2(:,335),heltab2x4(:,:,335))
  call Hloop_A_Q(ntryL,G1H2(385),27,nMB,G2H2(202),n2h2(174))
  call Hloop_VA_Q(ntryL,G1H4(173),ex4(:),G1H2(386),m3h2x2(:,336),heltab2x4(:,:,336))
  call Hloop_A_Q(ntryL,G1H2(386),27,nMB,G2H2(203),n2h2(175))
  call Hloop_VA_Q(ntryL,G1H4(174),ex4(:),G1H2(390),m3h2x2(:,337),heltab2x4(:,:,337))
  call Hloop_A_Q(ntryL,G1H2(390),27,nMB,G2H2(204),n2h2(176))
  call Hloop_ZA_Q(ntryL,G1H4(175),ex4(:),G1H2(391),ngZd,m3h2x2(:,338),heltab2x4(:,:,338))
  call Hloop_A_Q(ntryL,G1H2(391),27,nMB,G2H2(205),n2h2(177))
  call Hloop_ZA_Q(ntryL,G1H4(176),ex4(:),G1H2(392),ngZd,m3h2x2(:,339),heltab2x4(:,:,339))
  call Hloop_A_Q(ntryL,G1H2(392),27,nMB,G2H2(206),n2h2(178))
  call Hloop_QA_W(ntryL,G1H4(177),ex4(:),G1H2(396),m3h2x2(:,340),heltab2x4(:,:,340))
  call Hloop_VA_Q(ntryL,G1H4(182),ex4(:),G1H2(397),m3h2x2(:,341),heltab2x4(:,:,341))
  call Hloop_A_Q(ntryL,G1H2(397),27,nMB,G2H2(207),n2h2(179))
  call Hloop_ZA_Q(ntryL,G1H4(184),ex4(:),G1H2(398),ngZd,m3h2x2(:,342),heltab2x4(:,:,342))
  call Hloop_A_Q(ntryL,G1H2(398),27,nMB,G2H2(208),n2h2(180))
  call Hloop_AQ_S(ntryL,G1H4(185),ex1(:),G1H2(402),ngH,m3h2x2(:,343),heltab2x4(:,:,343))
  call Hloop_AQ_S(ntryL,G1H4(195),ex1(:),G1H2(403),ngH,m3h2x2(:,344),heltab2x4(:,:,344))
  call Hloop_AQ_S(ntryL,G1H4(187),ex1(:),G1H2(404),ngX,m3h2x2(:,345),heltab2x4(:,:,345))
  call Hloop_AQ_S(ntryL,G1H4(196),ex1(:),G1H2(408),ngX,m3h2x2(:,346),heltab2x4(:,:,346))
  call Hloop_SQ_A(ntryL,G1H4(189),ex1(:),G1H2(409),ngH,m3h2x2(:,347),heltab2x4(:,:,347))
  call Hloop_Q_A(ntryL,G1H2(409),23,nMT,G2H2(209),n2h2(181))
  call Hloop_SQ_A(ntryL,G1H4(190),ex1(:),G1H2(410),ngPbt,m3h2x2(:,348),heltab2x4(:,:,348))
  call Hloop_Q_A(ntryL,G1H2(410),23,nMB,G2H2(210),n2h2(182))
  call Hloop_SQ_A(ntryL,G1H4(191),ex1(:),G1H2(414),ngX,m3h2x2(:,349),heltab2x4(:,:,349))
  call Hloop_Q_A(ntryL,G1H2(414),23,nMT,G2H2(211),n2h2(183))
  call Hloop_SQ_A(ntryL,G1H4(192),ex1(:),G1H2(415),ngPbt,m3h2x2(:,350),heltab2x4(:,:,350))
  call Hloop_Q_A(ntryL,G1H2(415),23,nMB,G2H2(212),n2h2(184))
  call Hloop_AQ_S(ntryL,G1H4(193),ex1(:),G1H2(416),ngH,m3h2x2(:,351),heltab2x4(:,:,351))
  call Hloop_AQ_S(ntryL,G1H4(194),ex1(:),G1H2(420),ngX,m3h2x2(:,352),heltab2x4(:,:,352))
  call Hloop_AQ_V(ntryL,G1H4(197),ex1(:),G1H2(421),m3h2x2(:,353),heltab2x4(:,:,353))
  call Hloop_AQ_V(ntryL,G1H4(210),ex1(:),G1H2(422),m3h2x2(:,354),heltab2x4(:,:,354))
  call Hloop_AQ_Z(ntryL,G1H4(199),ex1(:),G1H2(426),ngZu,m3h2x2(:,355),heltab2x4(:,:,355))
  call Hloop_AQ_Z(ntryL,G1H4(212),ex1(:),G1H2(427),ngZu,m3h2x2(:,356),heltab2x4(:,:,356))
  call Hloop_SQ_A(ntryL,G1H4(202),ex1(:),G1H2(428),ngPbt,m3h2x2(:,357),heltab2x4(:,:,357))
  call Hloop_Q_A(ntryL,G1H2(428),23,nMB,G2H2(213),n2h2(185))
  call Hloop_SQ_A(ntryL,G1H4(203),ex1(:),G1H2(432),ngH,m3h2x2(:,358),heltab2x4(:,:,358))
  call Hloop_Q_A(ntryL,G1H2(432),23,nMT,G2H2(214),n2h2(186))
  call Hloop_SQ_A(ntryL,G1H4(204),ex1(:),G1H2(433),ngX,m3h2x2(:,359),heltab2x4(:,:,359))
  call Hloop_Q_A(ntryL,G1H2(433),23,nMT,G2H2(215),n2h2(187))
  call Hloop_VQ_A(ntryL,G1H4(205),ex1(:),G1H2(434),m3h2x2(:,360),heltab2x4(:,:,360))
  call Hloop_Q_A(ntryL,G1H2(434),23,nMT,G2H2(216),n2h2(188))
  call Hloop_ZQ_A(ntryL,G1H4(206),ex1(:),G1H2(438),ngZu,m3h2x2(:,361),heltab2x4(:,:,361))
  call Hloop_Q_A(ntryL,G1H2(438),23,nMT,G2H2(217),n2h2(189))
  call Hloop_WQ_A(ntryL,G1H4(207),ex1(:),G1H2(439),m3h2x2(:,362),heltab2x4(:,:,362))
  call Hloop_Q_A(ntryL,G1H2(439),23,nMB,G2H2(218),n2h2(190))
  call Hloop_WQ_A(ntryL,G1H4(208),ex1(:),G1H2(440),m3h2x2(:,363),heltab2x4(:,:,363))
  call Hloop_Q_A(ntryL,G1H2(440),23,nMB,G2H2(219),n2h2(191))
  call Hloop_AQ_V(ntryL,G1H4(209),ex1(:),G1H2(444),m3h2x2(:,364),heltab2x4(:,:,364))
  call Hloop_AQ_Z(ntryL,G1H4(211),ex1(:),G1H2(445),ngZu,m3h2x2(:,365),heltab2x4(:,:,365))
  call Hloop_VQ_A(ntryL,G1H4(213),ex1(:),G1H2(446),m3h2x2(:,366),heltab2x4(:,:,366))
  call Hloop_Q_A(ntryL,G1H2(446),23,nMT,G2H2(220),n2h2(192))
  call Hloop_ZQ_A(ntryL,G1H4(215),ex1(:),G1H2(450),ngZu,m3h2x2(:,367),heltab2x4(:,:,367))
  call Hloop_Q_A(ntryL,G1H2(450),23,nMT,G2H2(221),n2h2(193))
  call Hloop_WQ_A(ntryL,G1H4(216),ex1(:),G1H2(451),m3h2x2(:,368),heltab2x4(:,:,368))
  call Hloop_Q_A(ntryL,G1H2(451),23,nMB,G2H2(222),n2h2(194))
  call Hloop_QA_S(ntryL,G1H4(217),ex2(:),G1H2(452),ngH,m3h2x2(:,369),heltab2x4(:,:,369))
  call Hloop_QA_S(ntryL,G1H4(218),ex2(:),G1H2(456),ngX,m3h2x2(:,370),heltab2x4(:,:,370))
  call Hloop_QA_S(ntryL,G1H4(229),ex2(:),G1H2(457),ngH,m3h2x2(:,371),heltab2x4(:,:,371))
  call Hloop_QA_S(ntryL,G1H4(230),ex2(:),G1H2(458),ngX,m3h2x2(:,372),heltab2x4(:,:,372))
  call Hloop_QA_S(ntryL,G1H4(231),ex2(:),G1H2(462),ngPtb,m3h2x2(:,373),heltab2x4(:,:,373))
  call Hloop_QA_V(ntryL,G1H4(222),ex2(:),G1H2(463),m3h2x2(:,374),heltab2x4(:,:,374))
  call Hloop_QA_V(ntryL,G1H4(234),ex2(:),G1H2(464),m3h2x2(:,375),heltab2x4(:,:,375))
  call Hloop_QA_Z(ntryL,G1H4(224),ex2(:),G1H2(468),ngZu,m3h2x2(:,376),heltab2x4(:,:,376))
  call Hloop_QA_Z(ntryL,G1H4(235),ex2(:),G1H2(469),ngZu,m3h2x2(:,377),heltab2x4(:,:,377))
  call Hloop_QA_W(ntryL,G1H4(236),ex2(:),G1H2(470),m3h2x2(:,378),heltab2x4(:,:,378))
  call Hloop_QA_S(ntryL,G1H4(227),ex2(:),G1H2(474),ngH,m3h2x2(:,379),heltab2x4(:,:,379))
  call Hloop_QA_S(ntryL,G1H4(228),ex2(:),G1H2(475),ngX,m3h2x2(:,380),heltab2x4(:,:,380))
  call Hloop_QA_V(ntryL,G1H4(232),ex2(:),G1H2(476),m3h2x2(:,381),heltab2x4(:,:,381))
  call Hloop_QA_Z(ntryL,G1H4(233),ex2(:),G1H2(480),ngZu,m3h2x2(:,382),heltab2x4(:,:,382))
  call Hloop_QA_S(ntryL,G1H4(237),ex4(:),G1H2(481),ngPbt,m3h2x2(:,383),heltab2x4(:,:,383))
  call Hloop_QA_S(ntryL,G1H4(247),ex4(:),G1H2(482),ngH,m3h2x2(:,384),heltab2x4(:,:,384))
  call Hloop_QA_S(ntryL,G1H4(246),ex4(:),G1H2(486),ngPbt,m3h2x2(:,385),heltab2x4(:,:,385))
  call Hloop_QA_S(ntryL,G1H4(248),ex4(:),G1H2(487),ngX,m3h2x2(:,386),heltab2x4(:,:,386))
  call Hloop_QA_V(ntryL,G1H4(250),ex4(:),G1H2(488),m3h2x2(:,387),heltab2x4(:,:,387))
  call Hloop_QA_Z(ntryL,G1H4(252),ex4(:),G1H2(492),ngZd,m3h2x2(:,388),heltab2x4(:,:,388))
  call Hloop_QA_W(ntryL,G1H4(243),ex4(:),G1H2(493),m3h2x2(:,389),heltab2x4(:,:,389))
  call Hloop_QA_W(ntryL,G1H4(251),ex4(:),G1H2(494),m3h2x2(:,390),heltab2x4(:,:,390))
  call Hloop_QA_S(ntryL,G1H4(245),ex4(:),G1H2(498),ngPbt,m3h2x2(:,391),heltab2x4(:,:,391))
  call Hloop_QA_W(ntryL,G1H4(249),ex4(:),G1H2(499),m3h2x2(:,392),heltab2x4(:,:,392))
  call Hloop_AQ_S(ntryL,G1H4(253),ex1(:),G1H2(500),ngH,m3h2x2(:,393),heltab2x4(:,:,393))
  call Hloop_AQ_S(ntryL,G1H4(260),ex1(:),G1H2(504),ngH,m3h2x2(:,394),heltab2x4(:,:,394))
  call Hloop_AQ_S(ntryL,G1H4(255),ex1(:),G1H2(505),ngX,m3h2x2(:,395),heltab2x4(:,:,395))
  call Hloop_AQ_S(ntryL,G1H4(261),ex1(:),G1H2(506),ngX,m3h2x2(:,396),heltab2x4(:,:,396))
  call Hloop_AQ_S(ntryL,G1H4(262),ex1(:),G1H2(510),ngPbt,m3h2x2(:,397),heltab2x4(:,:,397))
  call Hloop_AQ_S(ntryL,G1H4(258),ex1(:),G1H2(511),ngH,m3h2x2(:,398),heltab2x4(:,:,398))
  call Hloop_AQ_S(ntryL,G1H4(259),ex1(:),G1H2(512),ngX,m3h2x2(:,399),heltab2x4(:,:,399))
  call Hloop_AQ_V(ntryL,G1H4(263),ex1(:),G1H2(516),m3h2x2(:,400),heltab2x4(:,:,400))
  call Hloop_AQ_V(ntryL,G1H4(269),ex1(:),G1H2(517),m3h2x2(:,401),heltab2x4(:,:,401))
  call Hloop_AQ_Z(ntryL,G1H4(265),ex1(:),G1H2(518),ngZu,m3h2x2(:,402),heltab2x4(:,:,402))
  call Hloop_AQ_Z(ntryL,G1H4(271),ex1(:),G1H2(522),ngZu,m3h2x2(:,403),heltab2x4(:,:,403))
  call Hloop_AQ_W(ntryL,G1H4(272),ex1(:),G1H2(523),m3h2x2(:,404),heltab2x4(:,:,404))
  call Hloop_AQ_V(ntryL,G1H4(268),ex1(:),G1H2(524),m3h2x2(:,405),heltab2x4(:,:,405))
  call Hloop_AQ_Z(ntryL,G1H4(270),ex1(:),G1H2(528),ngZu,m3h2x2(:,406),heltab2x4(:,:,406))
  call Hloop_QA_S(ntryL,G1H4(273),ex2(:),G1H2(529),ngH,m3h2x2(:,407),heltab2x4(:,:,407))
  call Hloop_QA_S(ntryL,G1H4(274),ex2(:),G1H2(530),ngX,m3h2x2(:,408),heltab2x4(:,:,408))
  call Hloop_QA_S(ntryL,G1H4(287),ex2(:),G1H2(534),ngH,m3h2x2(:,409),heltab2x4(:,:,409))
  call Hloop_QA_S(ntryL,G1H4(288),ex2(:),G1H2(535),ngX,m3h2x2(:,410),heltab2x4(:,:,410))
  call Hloop_SA_Q(ntryL,G1H4(277),ex2(:),G1H2(536),ngH,m3h2x2(:,411),heltab2x4(:,:,411))
  call Hloop_A_Q(ntryL,G1H2(536),27,nMT,G2H2(223),n2h2(195))
  call Hloop_SA_Q(ntryL,G1H4(278),ex2(:),G1H2(540),ngPtb,m3h2x2(:,412),heltab2x4(:,:,412))
  call Hloop_A_Q(ntryL,G1H2(540),27,nMB,G2H2(224),n2h2(196))
  call Hloop_SA_Q(ntryL,G1H4(279),ex2(:),G1H2(541),ngX,m3h2x2(:,413),heltab2x4(:,:,413))
  call Hloop_A_Q(ntryL,G1H2(541),27,nMT,G2H2(225),n2h2(197))
  call Hloop_SA_Q(ntryL,G1H4(280),ex2(:),G1H2(542),ngPtb,m3h2x2(:,414),heltab2x4(:,:,414))
  call Hloop_A_Q(ntryL,G1H2(542),27,nMB,G2H2(226),n2h2(198))
  call Hloop_QA_V(ntryL,G1H4(281),ex2(:),G1H2(546),m3h2x2(:,415),heltab2x4(:,:,415))
  call Hloop_QA_V(ntryL,G1H4(299),ex2(:),G1H2(547),m3h2x2(:,416),heltab2x4(:,:,416))
  call Hloop_QA_Z(ntryL,G1H4(283),ex2(:),G1H2(548),ngZu,m3h2x2(:,417),heltab2x4(:,:,417))
  call Hloop_QA_Z(ntryL,G1H4(300),ex2(:),G1H2(552),ngZu,m3h2x2(:,418),heltab2x4(:,:,418))
  call Hloop_QA_S(ntryL,G1H4(285),ex2(:),G1H2(553),ngH,m3h2x2(:,419),heltab2x4(:,:,419))
  call Hloop_QA_S(ntryL,G1H4(286),ex2(:),G1H2(554),ngX,m3h2x2(:,420),heltab2x4(:,:,420))
  call Hloop_SA_Q(ntryL,G1H4(289),ex2(:),G1H2(558),ngPtb,m3h2x2(:,421),heltab2x4(:,:,421))
  call Hloop_A_Q(ntryL,G1H2(558),27,nMB,G2H2(227),n2h2(199))
  call Hloop_SA_Q(ntryL,G1H4(290),ex2(:),G1H2(559),ngPtb,m3h2x2(:,422),heltab2x4(:,:,422))
  call Hloop_A_Q(ntryL,G1H2(559),27,nMB,G2H2(228),n2h2(200))
  call Hloop_SA_Q(ntryL,G1H4(291),ex2(:),G1H2(560),ngH,m3h2x2(:,423),heltab2x4(:,:,423))
  call Hloop_A_Q(ntryL,G1H2(560),27,nMT,G2H2(229),n2h2(201))
  call Hloop_SA_Q(ntryL,G1H4(292),ex2(:),G1H2(564),ngX,m3h2x2(:,424),heltab2x4(:,:,424))
  call Hloop_A_Q(ntryL,G1H2(564),27,nMT,G2H2(230),n2h2(202))
  call Hloop_VA_Q(ntryL,G1H4(293),ex2(:),G1H2(565),m3h2x2(:,425),heltab2x4(:,:,425))
  call Hloop_A_Q(ntryL,G1H2(565),27,nMT,G2H2(231),n2h2(203))
  call Hloop_ZA_Q(ntryL,G1H4(294),ex2(:),G1H2(566),ngZu,m3h2x2(:,426),heltab2x4(:,:,426))
  call Hloop_A_Q(ntryL,G1H2(566),27,nMT,G2H2(232),n2h2(204))
  call Hloop_WA_Q(ntryL,G1H4(295),ex2(:),G1H2(570),m3h2x2(:,427),heltab2x4(:,:,427))
  call Hloop_A_Q(ntryL,G1H2(570),27,nMB,G2H2(233),n2h2(205))
  call Hloop_WA_Q(ntryL,G1H4(296),ex2(:),G1H2(571),m3h2x2(:,428),heltab2x4(:,:,428))
  call Hloop_A_Q(ntryL,G1H2(571),27,nMB,G2H2(234),n2h2(206))
  call Hloop_QA_V(ntryL,G1H4(297),ex2(:),G1H2(572),m3h2x2(:,429),heltab2x4(:,:,429))
  call Hloop_QA_Z(ntryL,G1H4(298),ex2(:),G1H2(576),ngZu,m3h2x2(:,430),heltab2x4(:,:,430))
  call Hloop_VA_Q(ntryL,G1H4(301),ex2(:),G1H2(25),m3h2x2(:,431),heltab2x4(:,:,431))
  call Hloop_A_Q(ntryL,G1H2(25),27,nMT,G2H2(235),n2h2(207))
  call Hloop_WA_Q(ntryL,G1H4(302),ex2(:),G1H2(26),m3h2x2(:,432),heltab2x4(:,:,432))
  call Hloop_A_Q(ntryL,G1H2(26),27,nMB,G2H2(236),n2h2(208))
  call Hloop_ZA_Q(ntryL,G1H4(303),ex2(:),G1H2(30),ngZu,m3h2x2(:,433),heltab2x4(:,:,433))
  call Hloop_A_Q(ntryL,G1H2(30),27,nMT,G2H2(237),n2h2(209))
  call Hloop_WA_Q(ntryL,G1H4(304),ex2(:),G1H2(31),m3h2x2(:,434),heltab2x4(:,:,434))
  call Hloop_A_Q(ntryL,G1H2(31),27,nMB,G2H2(238),n2h2(210))
  call Hloop_SQ_A(ntryL,G1H4(305),ex3(:),G1H2(32),ngH,m3h2x2(:,435),heltab2x4(:,:,435))
  call Hloop_Q_A(ntryL,G1H2(32),29,nMB,G2H2(239),n2h2(211))
  call Hloop_SQ_A(ntryL,G1H4(306),ex3(:),G1H2(36),ngPtb,m3h2x2(:,436),heltab2x4(:,:,436))
  call Hloop_Q_A(ntryL,G1H2(36),29,nMT,G2H2(240),n2h2(212))
  call Hloop_SQ_A(ntryL,G1H4(307),ex3(:),G1H2(37),ngX,m3h2x2(:,437),heltab2x4(:,:,437))
  call Hloop_Q_A(ntryL,G1H2(37),29,nMB,G2H2(241),n2h2(213))
  call Hloop_SQ_A(ntryL,G1H4(308),ex3(:),G1H2(38),ngPtb,m3h2x2(:,438),heltab2x4(:,:,438))
  call Hloop_Q_A(ntryL,G1H2(38),29,nMT,G2H2(242),n2h2(214))
  call Hloop_SQ_A(ntryL,G1H4(309),ex3(:),G1H2(42),ngPtb,m3h2x2(:,439),heltab2x4(:,:,439))
  call Hloop_Q_A(ntryL,G1H2(42),29,nMT,G2H2(243),n2h2(215))
  call Hloop_SQ_A(ntryL,G1H4(310),ex3(:),G1H2(43),ngPtb,m3h2x2(:,440),heltab2x4(:,:,440))
  call Hloop_Q_A(ntryL,G1H2(43),29,nMT,G2H2(244),n2h2(216))
  call Hloop_SQ_A(ntryL,G1H4(311),ex3(:),G1H2(44),ngH,m3h2x2(:,441),heltab2x4(:,:,441))
  call Hloop_Q_A(ntryL,G1H2(44),29,nMB,G2H2(245),n2h2(217))
  call Hloop_SQ_A(ntryL,G1H4(312),ex3(:),G1H2(48),ngX,m3h2x2(:,442),heltab2x4(:,:,442))
  call Hloop_Q_A(ntryL,G1H2(48),29,nMB,G2H2(246),n2h2(218))



end subroutine vamp_3

end module ol_vamp_3_ppttj_ew_ttxbbxg_3_/**/REALKIND
