
module ol_colourmatrix_ppttj_ew_ttxbbxg_3_/**/REALKIND
  use KIND_TYPES, only: REALKIND
  implicit none
  logical, save           :: colmat_not_initialised = .true.
  complex(REALKIND), save :: K1(136,8), K2(8,8), KL(8,8), Cas(5) = 0
  contains
  subroutine colourmatrix_init
    use ol_parameters_decl_/**/REALKIND, only: CI
    implicit none
    integer :: k, co
    colmat_not_initialised = .false.
    ! colour matrix

  K1(  1,:) = [  36,   0,  12,   0,  12,   0,   0,   0]
  K1(  2,:) = [   0,   0,   0,   0,   0,   0,   0,   0]
  K1(  3,:) = [  12,   0,  36,   0,   0,   0,  12,   0]
  K1(  4,:) = [   0,   0,   0,   0,   0,   0,   0,   0]
  K1(  5,:) = [  12,   0,   0,   0,  36,   0,  12,   0]
  K1(  6,:) = [   0,   0,   0,   0,   0,   0,   0,   0]
  K1(  7,:) = [   0,   0,  12,   0,  12,   0,  36,   0]
  K1(  8,:) = [   0,   0,   0,   0,   0,   0,   0,   0]
  K1(  9,:) = [  48,   0,  16,   0,  16,   0,   0,   0]
  K1( 10,:) = [   0,   0,   0,   0,   0,   0,   0,   0]
  K1( 11,:) = [  16,   0,  48,   0,   0,   0,  16,   0]
  K1( 12,:) = [   0,   0,   0,   0,   0,   0,   0,   0]
  K1( 13,:) = [  16,   0,   0,   0,  48,   0,  16,   0]
  K1( 14,:) = [   0,   0,   0,   0,   0,   0,   0,   0]
  K1( 15,:) = [   0,   0,  16,   0,  16,   0,  48,   0]
  K1( 16,:) = [   0,   0,   0,   0,   0,   0,   0,   0]
  K1( 17,:) = [   6,   0,   2,   0,   2,   0,   0,   0]
  K1( 18,:) = [   0,   0,   0,   0,   0,   0,   0,   0]
  K1( 19,:) = [   2,   0,   0,   0,  -6,   0, -16,   0]
  K1( 20,:) = [   0,   0,   0,   0,   0,   0,   0,   0]
  K1( 21,:) = [   2,   0,  -6,   0,   0,   0, -16,   0]
  K1( 22,:) = [   0,   0,   0,   0,   0,   0,   0,   0]
  K1( 23,:) = [   0,   0, -16,   0, -16,   0, -48,   0]
  K1( 24,:) = [   0,   0,   0,   0,   0,   0,   0,   0]
  K1( 25,:) = [  48,   0,  16,   0,  16,   0,   0,   0]
  K1( 26,:) = [   0,   0,   0,   0,   0,   0,   0,   0]
  K1( 27,:) = [  16,   0,  48,   0,   0,   0,  16,   0]
  K1( 28,:) = [   0,   0,   0,   0,   0,   0,   0,   0]
  K1( 29,:) = [  16,   0,   0,   0,  48,   0,  16,   0]
  K1( 30,:) = [   0,   0,   0,   0,   0,   0,   0,   0]
  K1( 31,:) = [   0,   0,  16,   0,  16,   0,  48,   0]
  K1( 32,:) = [   0,   0,   0,   0,   0,   0,   0,   0]
  K1( 33,:) = [   0,   0,  16,   0,  -2,   0,   6,   0]
  K1( 34,:) = [   0,   0,   0,   0,   0,   0,   0,   0]
  K1( 35,:) = [  16,   0,   0,   0,   6,   0,  -2,   0]
  K1( 36,:) = [   0,   0,   0,   0,   0,   0,   0,   0]
  K1( 37,:) = [  -2,   0,   6,   0,   0,   0,  16,   0]
  K1( 38,:) = [   0,   0,   0,   0,   0,   0,   0,   0]
  K1( 39,:) = [   6,   0,  -2,   0,  16,   0,   0,   0]
  K1( 40,:) = [   0,   0,   0,   0,   0,   0,   0,   0]
  K1( 41,:) = [   0,   0,   2,   0, -16,   0,  -6,   0]
  K1( 42,:) = [   0,   0,   0,   0,   0,   0,   0,   0]
  K1( 43,:) = [   2,   0,   6,   0,   0,   0,   2,   0]
  K1( 44,:) = [   0,   0,   0,   0,   0,   0,   0,   0]
  K1( 45,:) = [ -16,   0,   0,   0, -48,   0, -16,   0]
  K1( 46,:) = [   0,   0,   0,   0,   0,   0,   0,   0]
  K1( 47,:) = [  -6,   0,   2,   0, -16,   0,   0,   0]
  K1( 48,:) = [   0,   0,   0,   0,   0,   0,   0,   0]
  K1( 49,:) = [  48,   0,  16,   0,  16,   0,   0,   0]
  K1( 50,:) = [   0,   0,   0,   0,   0,   0,   0,   0]
  K1( 51,:) = [  16,   0,  48,   0,   0,   0,  16,   0]
  K1( 52,:) = [   0,   0,   0,   0,   0,   0,   0,   0]
  K1( 53,:) = [  16,   0,   0,   0,  48,   0,  16,   0]
  K1( 54,:) = [   0,   0,   0,   0,   0,   0,   0,   0]
  K1( 55,:) = [   0,   0,  16,   0,  16,   0,  48,   0]
  K1( 56,:) = [   0,   0,   0,   0,   0,   0,   0,   0]
  K1( 57,:) = [   0,   0, -16,   0,   2,   0,  -6,   0]
  K1( 58,:) = [   0,   0,   0,   0,   0,   0,   0,   0]
  K1( 59,:) = [ -16,   0, -48,   0,   0,   0, -16,   0]
  K1( 60,:) = [   0,   0,   0,   0,   0,   0,   0,   0]
  K1( 61,:) = [   2,   0,   0,   0,   6,   0,   2,   0]
  K1( 62,:) = [   0,   0,   0,   0,   0,   0,   0,   0]
  K1( 63,:) = [  -6,   0, -16,   0,   2,   0,   0,   0]
  K1( 64,:) = [   0,   0,   0,   0,   0,   0,   0,   0]
  K1( 65,:) = [   0,   0,  -2,   0,  16,   0,   6,   0]
  K1( 66,:) = [   0,   0,   0,   0,   0,   0,   0,   0]
  K1( 67,:) = [  -2,   0,   0,   0,   6,   0,  16,   0]
  K1( 68,:) = [   0,   0,   0,   0,   0,   0,   0,   0]
  K1( 69,:) = [  16,   0,   6,   0,   0,   0,  -2,   0]
  K1( 70,:) = [   0,   0,   0,   0,   0,   0,   0,   0]
  K1( 71,:) = [   6,   0,  16,   0,  -2,   0,   0,   0]
  K1( 72,:) = [   0,   0,   0,   0,   0,   0,   0,   0]
  K1( 73,:) = [ -48,   0, -16,   0, -16,   0,   0,   0]
  K1( 74,:) = [   0,   0,   0,   0,   0,   0,   0,   0]
  K1( 75,:) = [ -16,   0,   0,   0,  -6,   0,   2,   0]
  K1( 76,:) = [   0,   0,   0,   0,   0,   0,   0,   0]
  K1( 77,:) = [ -16,   0,  -6,   0,   0,   0,   2,   0]
  K1( 78,:) = [   0,   0,   0,   0,   0,   0,   0,   0]
  K1( 79,:) = [   0,   0,   2,   0,   2,   0,   6,   0]
  K1( 80,:) = [   0,   0,   0,   0,   0,   0,   0,   0]
  K1( 81,:) = [  48,   0,  16,   0,  16,   0,   0,   0]
  K1( 82,:) = [   0,   0,   0,   0,   0,   0,   0,   0]
  K1( 83,:) = [  16,   0,  48,   0,   0,   0,  16,   0]
  K1( 84,:) = [   0,   0,   0,   0,   0,   0,   0,   0]
  K1( 85,:) = [  16,   0,   0,   0,  48,   0,  16,   0]
  K1( 86,:) = [   0,   0,   0,   0,   0,   0,   0,   0]
  K1( 87,:) = [   0,   0,  16,   0,  16,   0,  48,   0]
  K1( 88,:) = [   0,   0,   0,   0,   0,   0,   0,   0]
  K1( 89,:) = [ -54,   0, -18,   0, -18,   0,   0,   0]
  K1( 90,:) = [   0,   0,   0,   0,   0,   0,   0,   0]
  K1( 91,:) = [ -18,   0,   0,   0,   0,   0,  18,   0]
  K1( 92,:) = [   0,   0,   0,   0,   0,   0,   0,   0]
  K1( 93,:) = [ -18,   0,   0,   0, -54,   0, -18,   0]
  K1( 94,:) = [   0,   0,   0,   0,   0,   0,   0,   0]
  K1( 95,:) = [   0,   0,  18,   0, -18,   0,   0,   0]
  K1( 96,:) = [   0,   0,   0,   0,   0,   0,   0,   0]
  K1( 97,:) = [ -54,   0, -18,   0, -18,   0,   0,   0]
  K1( 98,:) = [   0,   0,   0,   0,   0,   0,   0,   0]
  K1( 99,:) = [ -18,   0, -54,   0,   0,   0, -18,   0]
  K1(100,:) = [   0,   0,   0,   0,   0,   0,   0,   0]
  K1(101,:) = [ -18,   0,   0,   0,   0,   0,  18,   0]
  K1(102,:) = [   0,   0,   0,   0,   0,   0,   0,   0]
  K1(103,:) = [   0,   0, -18,   0,  18,   0,   0,   0]
  K1(104,:) = [   0,   0,   0,   0,   0,   0,   0,   0]
  K1(105,:) = [   0,   0, -18,   0,  18,   0,   0,   0]
  K1(106,:) = [   0,   0,   0,   0,   0,   0,   0,   0]
  K1(107,:) = [ -18,   0, -54,   0,   0,   0, -18,   0]
  K1(108,:) = [   0,   0,   0,   0,   0,   0,   0,   0]
  K1(109,:) = [  18,   0,   0,   0,   0,   0, -18,   0]
  K1(110,:) = [   0,   0,   0,   0,   0,   0,   0,   0]
  K1(111,:) = [   0,   0, -18,   0, -18,   0, -54,   0]
  K1(112,:) = [   0,   0,   0,   0,   0,   0,   0,   0]
  K1(113,:) = [   0,   0,  18,   0, -18,   0,   0,   0]
  K1(114,:) = [   0,   0,   0,   0,   0,   0,   0,   0]
  K1(115,:) = [  18,   0,   0,   0,   0,   0, -18,   0]
  K1(116,:) = [   0,   0,   0,   0,   0,   0,   0,   0]
  K1(117,:) = [ -18,   0,   0,   0, -54,   0, -18,   0]
  K1(118,:) = [   0,   0,   0,   0,   0,   0,   0,   0]
  K1(119,:) = [   0,   0, -18,   0, -18,   0, -54,   0]
  K1(120,:) = [   0,   0,   0,   0,   0,   0,   0,   0]
  K1(121,:) = [ 108,   0,  36,   0,  36,   0,   0,   0]
  K1(122,:) = [   0,   0,   0,   0,   0,   0,   0,   0]
  K1(123,:) = [  36,   0, 108,   0,   0,   0,  36,   0]
  K1(124,:) = [   0,   0,   0,   0,   0,   0,   0,   0]
  K1(125,:) = [  36,   0,   0,   0, 108,   0,  36,   0]
  K1(126,:) = [   0,   0,   0,   0,   0,   0,   0,   0]
  K1(127,:) = [   0,   0,  36,   0,  36,   0, 108,   0]
  K1(128,:) = [   0,   0,   0,   0,   0,   0,   0,   0]
  K1(129,:) = [   0,  36,   0,  12,   0,  12,   0,   0]
  K1(130,:) = [  36,   0,  12,   0,  12,   0,   0,   0]
  K1(131,:) = [   0,  12,   0,  36,   0,   0,   0,  12]
  K1(132,:) = [  12,   0,  36,   0,   0,   0,  12,   0]
  K1(133,:) = [   0,  12,   0,   0,   0,  36,   0,  12]
  K1(134,:) = [  12,   0,   0,   0,  36,   0,  12,   0]
  K1(135,:) = [   0,   0,   0,  12,   0,  12,   0,  36]
  K1(136,:) = [   0,   0,  12,   0,  12,   0,  36,   0]
  K1 = (1._/**/REALKIND / 3) * K1

  K2(1,:) = [ 12,  0,  0,  4,  0,  4,  0,  0]
  K2(2,:) = [  0, 12,  4,  0,  4,  0,  0,  0]
  K2(3,:) = [  4,  0,  0, 12,  0,  0,  0,  4]
  K2(4,:) = [  0,  4, 12,  0,  0,  0,  4,  0]
  K2(5,:) = [  4,  0,  0,  0,  0, 12,  0,  4]
  K2(6,:) = [  0,  4,  0,  0, 12,  0,  4,  0]
  K2(7,:) = [  0,  0,  0,  4,  0,  4,  0, 12]
  K2(8,:) = [  0,  0,  4,  0,  4,  0, 12,  0]

  KL(1,:) = [  0, 12,  0,  4,  0,  4,  0,  0]
  KL(2,:) = [ 12,  0,  4,  0,  4,  0,  0,  0]
  KL(3,:) = [  0,  4,  0, 12,  0,  0,  4,  0]
  KL(4,:) = [  4,  0, 12,  0,  0,  0,  0,  4]
  KL(5,:) = [  0,  4,  0,  0,  0, 12,  4,  0]
  KL(6,:) = [  4,  0,  0,  0, 12,  0,  0,  4]
  KL(7,:) = [  0,  0,  0,  4,  0,  4, 12,  0]
  KL(8,:) = [  0,  0,  4,  0,  4,  0,  0, 12]

#if 1 > 0
    co = 0
    do k = 1, 5
      co = co + k
      Cas(k) = K1(1+8*co,1)/K1(1,1)
    end do
#endif
  end subroutine colourmatrix_init
end module ol_colourmatrix_ppttj_ew_ttxbbxg_3_/**/REALKIND



module ol_forced_parameters_ppttj_ew_ttxbbxg_3_/**/REALKIND
  implicit none
  contains
  subroutine check_forced_parameters
    use ol_parameters_decl_/**/REALKIND
    use ol_loop_parameters_decl_/**/REALKIND
#ifndef PRECISION_dp
    use ol_loop_parameters_decl_/**/DREALKIND, only: LeadingColour, nc, nf, CKMORDER
#endif
    implicit none
    logical, save :: checks_not_written = .true.

    if (checks_not_written) then
    ! e.g.
    ! if (ME /= 0) write(*,101) 'ME = 0'
  if (CKMORDER /= 0) write(*,101) 'CKMORDER = 0'
  if (nc /= 3) write(*,101) 'nc = 3'
  if (nf /= 6) write(*,101) 'nf = 6'
  if (MU /= 0) write(*,101) 'MU = 0'
  if (MD /= 0) write(*,101) 'MD = 0'
  if (MS /= 0) write(*,101) 'MS = 0'
  if (MC /= 0) write(*,101) 'MC = 0'
  if (LeadingColour /= 0) write(*,101) 'LeadingColour = 0'
  if (wMT /= 0) write(*,101) 'wMT = 0'
  if (wMT /= 0) write(*,101) 'wMT = 0'
  if (wMB /= 0) write(*,101) 'wMB = 0'
  if (wMB /= 0) write(*,101) 'wMB = 0'


    checks_not_written = .false.
    end if

    101 format('[OpenLoops] === WARNING ===',/,'[OpenLoops] code was generated with ',A,/,'[OpenLoops] ===============')
  end subroutine check_forced_parameters
end module ol_forced_parameters_ppttj_ew_ttxbbxg_3_/**/REALKIND


! **********************************************************************
module ol_loop_storage_ppttj_ew_ttxbbxg_3_/**/REALKIND
! **********************************************************************
  use KIND_TYPES, only: REALKIND, intkind1, intkind2
  use ol_data_types_/**/REALKIND, only: wfun, Hpolcont

#ifdef PRECISION_dp
  integer(intkind1), save :: ntryL = 1
  integer(intkind1), save :: p_switch = 0 ! switch for dp or qp. Used for memory allocation of the OL types
  ! the following are flags for memory allocation of the hol coefficients in dp or qp
  logical, save :: dp_not_alloc = .TRUE., qp_not_alloc = .TRUE.
  integer, save :: n_merge_steps  ! total number of merging steps
  integer, save :: n_merge_mism   ! number of merging mismatches
  integer, save :: merge_step = 1 ! current merging step
  integer(intkind2), save, allocatable :: merge_tables(:,:,:) ! merging tables
  integer(intkind2), save, allocatable :: merge_mism(:)       ! array of merging mismatches
  integer(intkind2), save, allocatable :: merge_hels(:)       ! array with relevant helicities for a merging step
  logical, save :: merge_tables_on = .false.
  integer(intkind2), parameter :: nheltot = 32 ! number of helicity configurations
  integer(intkind2), save :: nhel = 32 ! number of non-vanishing helicity configurations (adapted at runtime)
  integer(intkind2), save :: Hel(32) ! physical helicity states
#endif

  complex(REALKIND), save :: den(135)

  ! external wave functions ex1(h1),... for h<n> helicities
  type(wfun) :: ex1(2), ex2(2), ex3(2), ex4(2), ex5(2)

  ! wf<h>(h,n) n wave functions with h helicity configurations
  type(wfun) :: wf4(4,96), wf8(8,174), wf32(32,299)

  ! diagram prefactors
  integer,           save :: fac_status_loop1 = -1, fac_status_loop2 = -1
  complex(REALKIND), save :: f(233), c(205)

  !Vector in helicity and colour space for Born-Loop interference
  type(Hpolcont),   save :: M0_col1_helarray(8,32), M0M1_hel_cc(8,32,16)
  complex(REALKIND), save :: M2ctcc(16)

end module ol_loop_storage_ppttj_ew_ttxbbxg_3_/**/REALKIND






! **********************************************************************
module ol_loop_ppttj_ew_ttxbbxg_3_/**/REALKIND
! **********************************************************************
  use KIND_TYPES, only: REALKIND, DREALKIND, intkind1, intkind2
  use ol_data_types_/**/REALKIND, only: wfun, Hpolcont
  use ol_loop_storage_ppttj_ew_ttxbbxg_3_/**/REALKIND
  implicit none

!*********************************************************************************
  contains

! **********************************************************************
subroutine fac_init_loop()
! Writes diagram prefactors to 'f', rsp. 'c'
! **********************************************************************
  use ol_parameters_decl_/**/REALKIND
  use ol_loop_parameters_decl_/**/REALKIND
  use ol_init, only: set_parameter, tree_parameters_flush, parameters_flush
#ifndef PRECISION_dp
  use ol_loop_parameters_decl_/**/DREALKIND, only: SwF, SwB
!  use ol_loop_parameters_decl_/**/DREALKIND, only: DOI
#endif
  implicit none
  call set_parameter("ew_renorm", 1)
  if (parameters_status == 0) call tree_parameters_flush()
  if (loop_parameters_status == 0) call parameters_flush()
  fac_status_loop1 = parameters_status
  fac_status_loop2 = loop_parameters_status
  ! factors of the diagrams
    f(  1) = (2*CI*eQED**2*gQCD)/9._/**/REALKIND
    f(  2) = CI*eQED**2*gQCD
    f(  3) = (2*CI*countertermnorm*eQED**4*gQCD)/9._/**/REALKIND
    f(  4) = (CI*countertermnorm*eQED**4*gQCD)/3._/**/REALKIND
    f(  5) = (2*CI*countertermnorm*eQED**4*gQCD)/3._/**/REALKIND
    f(  6) = CI*countertermnorm*eQED**4*gQCD
    f(  7) = CI*gQCD**3
    f(  8) = gQCD**3
    f(  9) = (2*CI*countertermnorm*eQED**2*gQCD**3)/9._/**/REALKIND
    f( 10) = CI*countertermnorm*eQED**2*gQCD**3
    f( 11) = countertermnorm*eQED**2*gQCD**3
    f( 12) = (2*CI*countertermnorm*ctGbb*eQED**2*gQCD**3)/9._/**/REALKIND
    f( 13) = CI*countertermnorm*ctGbb*eQED**2*gQCD**3
    f( 14) = (2*CI*countertermnorm*ctGtt*eQED**2*gQCD**3)/9._/**/REALKIND
    f( 15) = CI*countertermnorm*ctGtt*eQED**2*gQCD**3
    f( 16) = (2*CI*countertermnorm*ctVbb*eQED**2*gQCD**3)/9._/**/REALKIND
    f( 17) = CI*countertermnorm*ctVbb*eQED**2*gQCD**3
    f( 18) = (2*CI*countertermnorm*ctVtt*eQED**2*gQCD**3)/9._/**/REALKIND
    f( 19) = CI*countertermnorm*ctVtt*eQED**2*gQCD**3
    f( 20) = countertermnorm*ctZGG*eQED**2*gQCD**3
    f( 21) = (CI*eQED**2*gQCD)/(2._/**/REALKIND*sw**2)
    f( 22) = (CI*countertermnorm*eQED**4*gQCD)/(2._/**/REALKIND*sw**2)
    f( 23) = (CI*countertermnorm*eQED**4*EWctVbt*gQCD)/(2._/**/REALKIND*sw**2)
    f( 24) = (CI*countertermnorm*eQED**4*EWctVtb*gQCD)/(2._/**/REALKIND*sw**2)
    f( 25) = (CI*countertermnorm*eQED**2*gQCD**3)/(2._/**/REALKIND*sw**2)
    f( 26) = (CI*countertermnorm*ctGbb*eQED**2*gQCD**3)/(2._/**/REALKIND*sw**2)
    f( 27) = (CI*countertermnorm*ctGtt*eQED**2*gQCD**3)/(2._/**/REALKIND*sw**2)
    f( 28) = (CI*countertermnorm*ctVbt*eQED**2*gQCD**3)/(2._/**/REALKIND*sw**2)
    f( 29) = (CI*eQED**2*gQCD)/(2._/**/REALKIND*MW**2*sw**2)
    f( 30) = (CI*countertermnorm*eQED**4*gQCD)/(2._/**/REALKIND*MW**2*sw**2)
    f( 31) = (CI*countertermnorm*eQED**2*gQCD**3)/(2._/**/REALKIND*MW**2*sw**2)
    f( 32) = (CI*countertermnorm*ctGbb*eQED**2*gQCD**3)/(2._/**/REALKIND*MW**2*sw**2)
    f( 33) = (CI*countertermnorm*ctGtt*eQED**2*gQCD**3)/(2._/**/REALKIND*MW**2*sw**2)
    f( 34) = (CI*eQED**2*gQCD*MB*MT)/(4._/**/REALKIND*MW**2*sw**2)
    f( 35) = (CI*countertermnorm*eQED**4*gQCD*MB*MT)/(4._/**/REALKIND*MW**2*sw**2)
    f( 36) = (CI*countertermnorm*eQED**2*gQCD**3*MB*MT)/(4._/**/REALKIND*MW**2*sw**2)
    f( 37) = (CI*countertermnorm*ctGbb*eQED**2*gQCD**3*MB*MT)/(4._/**/REALKIND*MW**2*sw**2)
    f( 38) = (CI*countertermnorm*ctGtt*eQED**2*gQCD**3*MB*MT)/(4._/**/REALKIND*MW**2*sw**2)
    f( 39) = (CI*countertermnorm*ctSbb*eQED**2*gQCD**3*MB*MT)/(4._/**/REALKIND*MW**2*sw**2)
    f( 40) = (CI*countertermnorm*ctStt*eQED**2*gQCD**3*MB*MT)/(4._/**/REALKIND*MW**2*sw**2)
    f( 41) = (CI*countertermnorm*eQED**4*gQCD)/(2._/**/REALKIND*MW*sw**2)
    f( 42) = (CI*countertermnorm*eQED**4*gQCD*MB*MT)/(2._/**/REALKIND*MW**2*sw)
    f( 43) = (countertermnorm*eQED**4*gQCD*MB*MT)/(MW**2*sw*2._/**/REALKIND)
    f( 44) = (countertermnorm*eQED**4*gQCD*MB)/(MW*sw*3._/**/REALKIND)
    f( 45) = (countertermnorm*eQED**4*gQCD*MB)/(MW*sw*2._/**/REALKIND)
    f( 46) = (CI*countertermnorm*ctHGG*eQED**2*gQCD**3*MB)/(2._/**/REALKIND*MW*sw)
    f( 47) = (countertermnorm*eQED**4*gQCD*MT)/(MW*sw*6._/**/REALKIND)
    f( 48) = (countertermnorm*eQED**4*gQCD*MT)/(MW*sw*2._/**/REALKIND)
    f( 49) = (CI*countertermnorm*ctHGG*eQED**2*gQCD**3*MT)/(2._/**/REALKIND*MW*sw)
    f( 50) = (CI*countertermnorm*eQED**4*gQCD)/(MW**2*sqrt2*sw)
    f( 51) = (2*eQED**4*gQCD*integralnorm*SwB)/81._/**/REALKIND
    f( 52) = (4*eQED**4*gQCD*integralnorm*SwB)/81._/**/REALKIND
    f( 53) = (8*eQED**4*gQCD*integralnorm*SwB)/81._/**/REALKIND
    f( 54) = (eQED**4*gQCD*integralnorm*SwB)/9._/**/REALKIND
    f( 55) = (2*eQED**4*gQCD*integralnorm*SwB)/9._/**/REALKIND
    f( 56) = (4*eQED**4*gQCD*integralnorm*SwB)/9._/**/REALKIND
    f( 57) = eQED**4*gQCD*integralnorm*SwB
    f( 58) = (eQED**4*gQCD*integralnorm*SwB)/(cw**2*2._/**/REALKIND)
    f( 59) = (CI*eQED**2*gQCD**3*integralnorm*SwB)/9._/**/REALKIND
    f( 60) = (2*CI*eQED**2*gQCD**3*integralnorm*SwB)/9._/**/REALKIND
    f( 61) = (4*CI*eQED**2*gQCD**3*integralnorm*SwB)/9._/**/REALKIND
    f( 62) = CI*eQED**2*gQCD**3*integralnorm*SwB
    f( 63) = (eQED**2*gQCD**3*integralnorm*SwB)/9._/**/REALKIND
    f( 64) = (2*eQED**2*gQCD**3*integralnorm*SwB)/9._/**/REALKIND
    f( 65) = (4*eQED**2*gQCD**3*integralnorm*SwB)/9._/**/REALKIND
    f( 66) = eQED**2*gQCD**3*integralnorm*SwB
    f( 67) = (2*eQED**4*gQCD*integralnorm*MW**2*SwB)/9._/**/REALKIND
    f( 68) = (eQED**4*gQCD*integralnorm*MW**2*SwB)/(cw**2*2._/**/REALKIND)
    f( 69) = (eQED**4*gQCD*integralnorm*SwB)/(sw**4*8._/**/REALKIND)
    f( 70) = (eQED**4*gQCD*integralnorm*SwB)/(sw**4*4._/**/REALKIND)
    f( 71) = (cw**2*eQED**4*gQCD*integralnorm*SwB)/(sw**4*2._/**/REALKIND)
    f( 72) = (eQED**4*gQCD*integralnorm*MB*SwB)/(sw**4*4._/**/REALKIND)
    f( 73) = (eQED**4*gQCD*integralnorm*MT*SwB)/(sw**4*4._/**/REALKIND)
    f( 74) = (eQED**4*gQCD*integralnorm*MB*MT*SwB)/(sw**4*16._/**/REALKIND)
    f( 75) = (eQED**4*gQCD*integralnorm*MB*MT*SwB)/(sw**4*4._/**/REALKIND)
    f( 76) = (eQED**4*gQCD*integralnorm*MB*MT*SwB)/(cw**4*sw**4*16._/**/REALKIND)
    f( 77) = (eQED**4*gQCD*integralnorm*MB*MT*SwB)/(cw**4*sw**4*8._/**/REALKIND)
    f( 78) = (eQED**4*gQCD*integralnorm*SwB)/(MW**4*sw**4*4._/**/REALKIND)
    f( 79) = (eQED**4*gQCD*integralnorm*MB**2*SwB)/(MW**4*sw**4*8._/**/REALKIND)
    f( 80) = (eQED**4*gQCD*integralnorm*MB*MH**2*SwB)/(MW**4*sw**4*8._/**/REALKIND)
    f( 81) = (eQED**4*gQCD*integralnorm*MH**4*SwB)/(MW**4*sw**4*8._/**/REALKIND)
    f( 82) = (eQED**4*gQCD*integralnorm*MB*MT*SwB)/(MW**4*sw**4*8._/**/REALKIND)
    f( 83) = (eQED**4*gQCD*integralnorm*MB**3*MT*SwB)/(MW**4*sw**4*16._/**/REALKIND)
    f( 84) = (eQED**4*gQCD*integralnorm*MH**2*MT*SwB)/(MW**4*sw**4*8._/**/REALKIND)
    f( 85) = (eQED**4*gQCD*integralnorm*MB**2*MH**2*MT*SwB)/(MW**4*sw**4*16._/**/REALKIND)
    f( 86) = (3*eQED**4*gQCD*integralnorm*lambdaHHH*MB**2*MH**2*MT*SwB)/(MW**4*sw**4*16._/**/REALKIND)
    f( 87) = (eQED**4*gQCD*integralnorm*MB*MH**4*MT*SwB)/(MW**4*sw**4*32._/**/REALKIND)
    f( 88) = (eQED**4*gQCD*integralnorm*MB*MH**4*MT*SwB)/(MW**4*sw**4*16._/**/REALKIND)
    f( 89) = (9*eQED**4*gQCD*integralnorm*lambdaHHH**2*MB*MH**4*MT*SwB)/(MW**4*sw**4*32._/**/REALKIND)
    f( 90) = (eQED**4*gQCD*integralnorm*MT**2*SwB)/(MW**4*sw**4*8._/**/REALKIND)
    f( 91) = (eQED**4*gQCD*integralnorm*MB**2*MT**2*SwB)/(MW**4*sw**4*16._/**/REALKIND)
    f( 92) = (eQED**4*gQCD*integralnorm*MB*MH**2*MT**2*SwB)/(MW**4*sw**4*16._/**/REALKIND)
    f( 93) = (3*eQED**4*gQCD*integralnorm*lambdaHHH*MB*MH**2*MT**2*SwB)/(MW**4*sw**4*16._/**/REALKIND)
    f( 94) = (eQED**4*gQCD*integralnorm*MB*MT**3*SwB)/(MW**4*sw**4*16._/**/REALKIND)
    f( 95) = (eQED**4*gQCD*integralnorm*SwB)/(MW**2*sw**4*8._/**/REALKIND)
    f( 96) = (eQED**4*gQCD*integralnorm*SwB)/(MW**2*sw**4*4._/**/REALKIND)
    f( 97) = (eQED**4*gQCD*integralnorm*MB*SwB)/(MW**2*sw**4*8._/**/REALKIND)
    f( 98) = (eQED**4*gQCD*integralnorm*MB**2*SwB)/(MW**2*sw**4*8._/**/REALKIND)
    f( 99) = (eQED**4*gQCD*integralnorm*MH**2*SwB)/(MW**2*sw**4*8._/**/REALKIND)
    f(100) = (eQED**4*gQCD*integralnorm*MT*SwB)/(MW**2*sw**4*8._/**/REALKIND)
    f(101) = (eQED**4*gQCD*integralnorm*MB*MT*SwB)/(MW**2*sw**4*16._/**/REALKIND)
    f(102) = (eQED**4*gQCD*integralnorm*MB*MT*SwB)/(MW**2*sw**4*8._/**/REALKIND)
    f(103) = (eQED**4*gQCD*integralnorm*MB*MT*SwB)/(cw**2*MW**2*sw**4*16._/**/REALKIND)
    f(104) = (eQED**4*gQCD*integralnorm*MT**2*SwB)/(MW**2*sw**4*8._/**/REALKIND)
    f(105) = (eQED**4*gQCD*integralnorm*MW**2*SwB)/(sw**4*2._/**/REALKIND)
    f(106) = (cw*eQED**4*gQCD*integralnorm*SwB)/(sw**3*2._/**/REALKIND)
    f(107) = (eQED**4*gQCD*integralnorm*MB*SwB)/(cw**3*sw**3*4._/**/REALKIND)
    f(108) = (cw*eQED**4*gQCD*integralnorm*MB*SwB)/(sw**3*4._/**/REALKIND)
    f(109) = (cw*eQED**4*gQCD*integralnorm*MB*SwB)/(sw**3*2._/**/REALKIND)
    f(110) = (eQED**4*gQCD*integralnorm*MT*SwB)/(cw**3*sw**3*4._/**/REALKIND)
    f(111) = (cw*eQED**4*gQCD*integralnorm*MT*SwB)/(sw**3*4._/**/REALKIND)
    f(112) = (cw*eQED**4*gQCD*integralnorm*MT*SwB)/(sw**3*2._/**/REALKIND)
    f(113) = (eQED**4*gQCD*integralnorm*MB**2*SwB)/(cw*MW**2*sw**3*8._/**/REALKIND)
    f(114) = (eQED**4*gQCD*integralnorm*MB*MH**2*SwB)/(cw*MW**2*sw**3*8._/**/REALKIND)
    f(115) = (eQED**4*gQCD*integralnorm*MB*MT*SwB)/(cw*MW**2*sw**3*8._/**/REALKIND)
    f(116) = (eQED**4*gQCD*integralnorm*MH**2*MT*SwB)/(cw*MW**2*sw**3*8._/**/REALKIND)
    f(117) = (eQED**4*gQCD*integralnorm*MT**2*SwB)/(cw*MW**2*sw**3*8._/**/REALKIND)
    f(118) = (eQED**4*gQCD*integralnorm*SwB)/(sw**2*18._/**/REALKIND)
    f(119) = (eQED**4*gQCD*integralnorm*SwB)/(sw**2*9._/**/REALKIND)
    f(120) = (eQED**4*gQCD*integralnorm*SwB)/(sw**2*6._/**/REALKIND)
    f(121) = (2*eQED**4*gQCD*integralnorm*SwB)/(sw**2*9._/**/REALKIND)
    f(122) = (eQED**4*gQCD*integralnorm*SwB)/(sw**2*3._/**/REALKIND)
    f(123) = (eQED**4*gQCD*integralnorm*SwB)/(sw**2*2._/**/REALKIND)
    f(124) = (eQED**4*gQCD*integralnorm*SwB)/(cw**2*sw**2*4._/**/REALKIND)
    f(125) = (cw**2*eQED**4*gQCD*integralnorm*SwB)/sw**2
    f(126) = (CI*eQED**2*gQCD**3*integralnorm*SwB)/(2._/**/REALKIND*sw**2)
    f(127) = (eQED**2*gQCD**3*integralnorm*SwB)/(sw**2*2._/**/REALKIND)
    f(128) = (eQED**4*gQCD*integralnorm*MB*SwB)/(sw**2*6._/**/REALKIND)
    f(129) = (eQED**4*gQCD*integralnorm*MB*SwB)/(sw**2*3._/**/REALKIND)
    f(130) = (eQED**4*gQCD*integralnorm*MB*SwB)/(cw**2*sw**2*2._/**/REALKIND)
    f(131) = (eQED**4*gQCD*integralnorm*MT*SwB)/(sw**2*12._/**/REALKIND)
    f(132) = (eQED**4*gQCD*integralnorm*MT*SwB)/(sw**2*6._/**/REALKIND)
    f(133) = (eQED**4*gQCD*integralnorm*MT*SwB)/(cw**2*sw**2*2._/**/REALKIND)
    f(134) = (eQED**4*gQCD*integralnorm*SwB)/(MW**2*sw**2*18._/**/REALKIND)
    f(135) = (eQED**4*gQCD*integralnorm*SwB)/(MW**2*sw**2*9._/**/REALKIND)
    f(136) = (eQED**4*gQCD*integralnorm*SwB)/(MW**2*sw**2*6._/**/REALKIND)
    f(137) = (2*eQED**4*gQCD*integralnorm*SwB)/(MW**2*sw**2*9._/**/REALKIND)
    f(138) = (eQED**4*gQCD*integralnorm*SwB)/(MW**2*sw**2*3._/**/REALKIND)
    f(139) = (eQED**4*gQCD*integralnorm*SwB)/(MW**2*sw**2*2._/**/REALKIND)
    f(140) = (CI*eQED**2*gQCD**3*integralnorm*SwB)/(2._/**/REALKIND*MW**2*sw**2)
    f(141) = (eQED**2*gQCD**3*integralnorm*SwB)/(MW**2*sw**2*2._/**/REALKIND)
    f(142) = (eQED**4*gQCD*integralnorm*MB**2*SwB)/(MW**2*sw**2*18._/**/REALKIND)
    f(143) = (eQED**4*gQCD*integralnorm*MB**2*SwB)/(MW**2*sw**2*4._/**/REALKIND)
    f(144) = (CI*eQED**2*gQCD**3*integralnorm*MB**2*SwB)/(4._/**/REALKIND*MW**2*sw**2)
    f(145) = (eQED**2*gQCD**3*integralnorm*MB**2*SwB)/(MW**2*sw**2*4._/**/REALKIND)
    f(146) = (eQED**4*gQCD*integralnorm*MB*MH**2*SwB)/(MW**2*sw**2*6._/**/REALKIND)
    f(147) = (eQED**4*gQCD*integralnorm*MB*MT*SwB)/(MW**2*sw**2*36._/**/REALKIND)
    f(148) = (eQED**4*gQCD*integralnorm*MB*MT*SwB)/(MW**2*sw**2*18._/**/REALKIND)
    f(149) = (eQED**4*gQCD*integralnorm*MB*MT*SwB)/(MW**2*sw**2*9._/**/REALKIND)
    f(150) = (eQED**4*gQCD*integralnorm*MB*MT*SwB)/(MW**2*sw**2*4._/**/REALKIND)
    f(151) = (CI*eQED**2*gQCD**3*integralnorm*MB*MT*SwB)/(4._/**/REALKIND*MW**2*sw**2)
    f(152) = (eQED**2*gQCD**3*integralnorm*MB*MT*SwB)/(MW**2*sw**2*4._/**/REALKIND)
    f(153) = (eQED**4*gQCD*integralnorm*MH**2*MT*SwB)/(MW**2*sw**2*12._/**/REALKIND)
    f(154) = (eQED**4*gQCD*integralnorm*MT**2*SwB)/(MW**2*sw**2*18._/**/REALKIND)
    f(155) = (eQED**4*gQCD*integralnorm*MT**2*SwB)/(MW**2*sw**2*4._/**/REALKIND)
    f(156) = (CI*eQED**2*gQCD**3*integralnorm*MT**2*SwB)/(4._/**/REALKIND*MW**2*sw**2)
    f(157) = (eQED**2*gQCD**3*integralnorm*MT**2*SwB)/(MW**2*sw**2*4._/**/REALKIND)
    f(158) = (eQED**4*gQCD*integralnorm*MW**2*SwB)/(sw**2*2._/**/REALKIND)
    f(159) = (eQED**4*gQCD*integralnorm*MW**2*SwB)/(cw**4*sw**2)
    f(160) = (eQED**4*gQCD*integralnorm*SwB)/(cw*sw*2._/**/REALKIND)
    f(161) = (cw*eQED**4*gQCD*integralnorm*SwB)/(sw*3._/**/REALKIND)
    f(162) = (2*cw*eQED**4*gQCD*integralnorm*SwB)/(sw*3._/**/REALKIND)
    f(163) = (eQED**4*gQCD*integralnorm*MB*SwB)/(cw*sw*4._/**/REALKIND)
    f(164) = (eQED**4*gQCD*integralnorm*MT*SwB)/(cw*sw*4._/**/REALKIND)
    f(165) = (eQED**4*gQCD*integralnorm*MW**2*sw*SwB)/(cw*3._/**/REALKIND)
    f(166) = (2*eQED**4*gQCD*integralnorm*MW**2*sw*SwB)/(cw*3._/**/REALKIND)
    f(167) = (eQED**4*gQCD*integralnorm*MW**2*sw**2*SwB)/cw**2
    f(168) = (eQED**4*gQCD*integralnorm*(cw - sw)*(cw + sw)*SwB)/(cw**2*sw**2*4._/**/REALKIND)
    f(169) = -((eQED**4*gQCD*integralnorm*(cw - sw)*(cw + sw)*SwB)/(sw**4*4._/**/REALKIND))
    f(170) = (eQED**4*gQCD*integralnorm*(-cw + sw)*(cw + sw)*SwB)/(cw**2*sw**4*8._/**/REALKIND)
    f(171) = -((eQED**4*gQCD*integralnorm*SwB*(cw**4*4._/**/REALKIND + sw**4*4._/**/REALKIND  &
      - cw**2*sw**2*8._/**/REALKIND))/(cw**2*MW**2*sw**4*4._/**/REALKIND*8._/**/REALKIND))
    f(172) = -((eQED**4*gQCD*integralnorm*(cw - sw)*(cw + sw)*SwB)/(cw*MW**2*sw**3*4._/**/REALKIND))
    f(173) = -((eQED**4*gQCD*integralnorm*MB*MH**2*(cw - sw)*(cw + sw)*SwB)/(cw*MW**2*sw**3*8._/**/REALKIND))
    f(174) = -((eQED**4*gQCD*integralnorm*MH**2*MT*(cw - sw)*(cw + sw)*SwB)/(cw*MW**2*sw**3*8._/**/REALKIND))
    f(175) = -((eQED**4*gQCD*integralnorm*(cw - sw)*(cw + sw)*SwB)/(cw*sw*6._/**/REALKIND))
    f(176) = -((eQED**4*gQCD*integralnorm*(cw - sw)*(cw + sw)*SwB)/(cw*sw*3._/**/REALKIND))
    f(177) = (eQED**4*gQCD*integralnorm*SwB*(cw**4*2._/**/REALKIND + sw**4*2._/**/REALKIND  &
      - cw**2*sw**2*4._/**/REALKIND))/(cw**2*sw**2*2._/**/REALKIND*4._/**/REALKIND)
    f(178) = (2*eQED**4*gQCD*integralnorm*SwF)/81._/**/REALKIND
    f(179) = (4*eQED**4*gQCD*integralnorm*SwF)/81._/**/REALKIND
    f(180) = (8*eQED**4*gQCD*integralnorm*SwF)/81._/**/REALKIND
    f(181) = (eQED**4*gQCD*integralnorm*SwF)/9._/**/REALKIND
    f(182) = (16*eQED**4*gQCD*integralnorm*SwF)/81._/**/REALKIND
    f(183) = (2*eQED**4*gQCD*integralnorm*SwF)/9._/**/REALKIND
    f(184) = (eQED**4*gQCD*integralnorm*SwF)/3._/**/REALKIND
    f(185) = (4*eQED**4*gQCD*integralnorm*SwF)/9._/**/REALKIND
    f(186) = (2*eQED**4*gQCD*integralnorm*SwF)/3._/**/REALKIND
    f(187) = (8*eQED**4*gQCD*integralnorm*SwF)/9._/**/REALKIND
    f(188) = eQED**4*gQCD*integralnorm*SwF
    f(189) = 2*eQED**4*gQCD*integralnorm*SwF
    f(190) = 3*eQED**4*gQCD*integralnorm*SwF
    f(191) = (eQED**2*gQCD**3*integralnorm*SwF)/9._/**/REALKIND
    f(192) = (2*eQED**2*gQCD**3*integralnorm*SwF)/9._/**/REALKIND
    f(193) = (4*eQED**2*gQCD**3*integralnorm*SwF)/9._/**/REALKIND
    f(194) = (8*eQED**2*gQCD**3*integralnorm*SwF)/9._/**/REALKIND
    f(195) = eQED**2*gQCD**3*integralnorm*SwF
    f(196) = 2*eQED**2*gQCD**3*integralnorm*SwF
    f(197) = (eQED**4*gQCD*integralnorm*SwF)/(sw**4*4._/**/REALKIND)
    f(198) = (eQED**4*gQCD*integralnorm*SwF)/(sw**4*2._/**/REALKIND)
    f(199) = (eQED**4*gQCD*integralnorm*SwF)/(MW**4*sw**4*4._/**/REALKIND)
    f(200) = (eQED**4*gQCD*integralnorm*ME**2*SwF)/(MW**4*sw**4*4._/**/REALKIND)
    f(201) = (eQED**4*gQCD*integralnorm*ML**2*SwF)/(MW**4*sw**4*4._/**/REALKIND)
    f(202) = (eQED**4*gQCD*integralnorm*MM**2*SwF)/(MW**4*sw**4*4._/**/REALKIND)
    f(203) = (eQED**4*gQCD*integralnorm*MB**3*MT*SwF)/(MW**4*sw**4*16._/**/REALKIND)
    f(204) = (eQED**4*gQCD*integralnorm*MB*ME**2*MT*SwF)/(MW**4*sw**4*16._/**/REALKIND)
    f(205) = (eQED**4*gQCD*integralnorm*MB*ML**2*MT*SwF)/(MW**4*sw**4*16._/**/REALKIND)
    f(206) = (eQED**4*gQCD*integralnorm*MB*MM**2*MT*SwF)/(MW**4*sw**4*16._/**/REALKIND)
    f(207) = (eQED**4*gQCD*integralnorm*MB*MT**3*SwF)/(MW**4*sw**4*16._/**/REALKIND)
    f(208) = (eQED**4*gQCD*integralnorm*SwF)/(MW**2*sw**4*4._/**/REALKIND)
    f(209) = (eQED**4*gQCD*integralnorm*ME*SwF)/(MW**2*sw**4*4._/**/REALKIND)
    f(210) = (eQED**4*gQCD*integralnorm*ML*SwF)/(MW**2*sw**4*4._/**/REALKIND)
    f(211) = (eQED**4*gQCD*integralnorm*MM*SwF)/(MW**2*sw**4*4._/**/REALKIND)
    f(212) = (eQED**4*gQCD*integralnorm*MB**2*SwF)/(MW**2*sw**2*18._/**/REALKIND)
    f(213) = (eQED**4*gQCD*integralnorm*MB**2*SwF)/(MW**2*sw**2*4._/**/REALKIND)
    f(214) = (eQED**2*gQCD**3*integralnorm*MB**2*SwF)/(MW**2*sw**2*4._/**/REALKIND)
    f(215) = (eQED**4*gQCD*integralnorm*MB*ME*SwF)/(MW**2*sw**2*6._/**/REALKIND)
    f(216) = (eQED**4*gQCD*integralnorm*MB*ME*SwF)/(MW**2*sw**2*4._/**/REALKIND)
    f(217) = (eQED**4*gQCD*integralnorm*MB*ML*SwF)/(MW**2*sw**2*6._/**/REALKIND)
    f(218) = (eQED**4*gQCD*integralnorm*MB*ML*SwF)/(MW**2*sw**2*4._/**/REALKIND)
    f(219) = (eQED**4*gQCD*integralnorm*MB*MM*SwF)/(MW**2*sw**2*6._/**/REALKIND)
    f(220) = (eQED**4*gQCD*integralnorm*MB*MM*SwF)/(MW**2*sw**2*4._/**/REALKIND)
    f(221) = (eQED**4*gQCD*integralnorm*MB*MT*SwF)/(MW**2*sw**2*36._/**/REALKIND)
    f(222) = (eQED**4*gQCD*integralnorm*MB*MT*SwF)/(MW**2*sw**2*9._/**/REALKIND)
    f(223) = (eQED**4*gQCD*integralnorm*MB*MT*SwF)/(MW**2*sw**2*4._/**/REALKIND)
    f(224) = (eQED**2*gQCD**3*integralnorm*MB*MT*SwF)/(MW**2*sw**2*4._/**/REALKIND)
    f(225) = (eQED**4*gQCD*integralnorm*ME*MT*SwF)/(MW**2*sw**2*12._/**/REALKIND)
    f(226) = (eQED**4*gQCD*integralnorm*ME*MT*SwF)/(MW**2*sw**2*4._/**/REALKIND)
    f(227) = (eQED**4*gQCD*integralnorm*ML*MT*SwF)/(MW**2*sw**2*12._/**/REALKIND)
    f(228) = (eQED**4*gQCD*integralnorm*ML*MT*SwF)/(MW**2*sw**2*4._/**/REALKIND)
    f(229) = (eQED**4*gQCD*integralnorm*MM*MT*SwF)/(MW**2*sw**2*12._/**/REALKIND)
    f(230) = (eQED**4*gQCD*integralnorm*MM*MT*SwF)/(MW**2*sw**2*4._/**/REALKIND)
    f(231) = (eQED**4*gQCD*integralnorm*MT**2*SwF)/(MW**2*sw**2*18._/**/REALKIND)
    f(232) = (eQED**4*gQCD*integralnorm*MT**2*SwF)/(MW**2*sw**2*4._/**/REALKIND)
    f(233) = (eQED**2*gQCD**3*integralnorm*MT**2*SwF)/(MW**2*sw**2*4._/**/REALKIND)

  c = [ 6*f(51), 6*f(52), 6*f(53), 6*f(54), 6*f(55), 6*f(56), 6*f(57), 6*f(58), 3*CI*f(59), 3*CI*f(60), 9*CI*f(60), 3*CI*f(61) &
    , 3*CI*f(62), 9*CI*f(62), f(63), 3*f(63), f(64), 3*f(64), 8*f(64), f(65), 3*f(65), f(66), 3*f(66), 8*f(66), 6*f(67), 6*f(68) &
    , 6*f(69), 6*f(70), 6*f(71), 6*f(72), 6*f(73), 6*f(74), 6*f(75), 6*f(76), 6*f(77), 6*f(78), 6*f(79), 6*f(80), 6*f(81), 6*f(82) &
    , 6*f(83), 6*f(84), 6*f(85), 6*f(86), 6*f(87), 6*f(88), 6*f(89), 6*f(90), 6*f(91), 6*f(92), 6*f(93), 6*f(94), 6*f(95), 6*f(96) &
    , 6*f(97), 6*f(98), 6*f(99), 6*f(100), 6*f(101), 6*f(102), 6*f(103), 6*f(104), 6*f(105), 6*f(106), 6*f(107), 6*f(108) &
    , 6*f(109), 6*f(110), 6*f(111), 6*f(112), 6*f(113), 6*f(114), 6*f(115), 6*f(116), 6*f(117), 6*f(118), 6*f(119), 6*f(120) &
    , 6*f(121), 6*f(122), 6*f(123), 6*f(124), 6*f(125), 3*CI*f(126), 9*CI*f(126), f(127), 3*f(127), 8*f(127), 6*f(128), 6*f(129) &
    , 6*f(130), 6*f(131), 6*f(132), 6*f(133), 6*f(134), 6*f(135), 6*f(136), 6*f(137), 6*f(138), 6*f(139), 3*CI*f(140), 9*CI*f(140) &
    , f(141), 3*f(141), 8*f(141), 6*f(142), 6*f(143), 3*CI*f(144), f(145), 3*f(145), 6*f(146), 6*f(147), 6*f(148), 6*f(149) &
    , 6*f(150), 3*CI*f(151), 9*CI*f(151), f(152), 3*f(152), 8*f(152), 6*f(153), 6*f(154), 6*f(155), 3*CI*f(156), f(157), 3*f(157) &
    , 6*f(158), 6*f(159), 6*f(160), 6*f(161), 6*f(162), 6*f(163), 6*f(164), 6*f(165), 6*f(166), 6*f(167), 6*f(168), 6*f(169) &
    , 6*f(170), 6*f(171), 6*f(172), 6*f(173), 6*f(174), 6*f(175), 6*f(176), 6*f(177), 18*f(178), 18*f(179), 18*f(180), 18*f(181) &
    , 18*f(182), 6*f(183), 18*f(183), 6*f(184), 18*f(185), 6*f(186), 18*f(187), 6*f(188), 18*f(188), 18*f(189), 6*f(190), 3*f(191) &
    , 3*f(192), 3*f(193), 3*f(194), 3*f(195), 3*f(196), 6*f(197), 18*f(197), 18*f(198), 18*f(199), 6*f(200), 6*f(201), 6*f(202) &
    , 18*f(203), 6*f(204), 6*f(205), 6*f(206), 18*f(207), 18*f(208), 6*f(209), 6*f(210), 6*f(211), 18*f(212), 18*f(213), 3*f(214) &
    , 6*f(215), 6*f(216), 6*f(217), 6*f(218), 6*f(219), 6*f(220), 18*f(221), 18*f(222), 18*f(223), 3*f(224), 6*f(225), 6*f(226) &
    , 6*f(227), 6*f(228), 6*f(229), 6*f(230), 18*f(231), 18*f(232), 3*f(233) ]
  c = (1._/**/REALKIND / 6) * c
end subroutine fac_init_loop

subroutine denominators()
  use ol_parameters_decl_/**/REALKIND ! masses
  use ol_momenta_decl_/**/REALKIND, only: L
  implicit none
  ! propagators
  den(1) = 1 /((L(5,3))+L(6,3))
  den(2) = 1 /((L(5,12))+L(6,12))
  den(4) = 1 /((L(5,3) - MH2)+L(6,3))
  den(5) = 1 /((L(5,20) - MB2)+L(6,20))
  den(7) = 1 /((L(5,3) - MZ2)+L(6,3))
  den(10) = 1 /((L(5,24) - MB2)+L(6,24))
  den(14) = 1 /((L(5,17) - MT2)+L(6,17))
  den(15) = 1 /((L(5,6) - MW2)+L(6,6))
  den(18) = 1 /((L(5,9) - MW2)+L(6,9))
  den(19) = 1 /((L(5,18) - MT2)+L(6,18))
  den(22) = 1 /((L(5,12) - MH2)+L(6,12))
  den(24) = 1 /((L(5,12) - MZ2)+L(6,12))
  den(34) = 1 /((L(5,28) - MH2)+L(6,28))
  den(37) = 1 /((L(5,28) - MZ2)+L(6,28))
  den(40) = 1 /((L(5,28))+L(6,28))
  den(45) = 1 /((L(5,11) - MB2)+L(6,11))
  den(60) = 1 /((L(5,7) - MB2)+L(6,7))
  den(67) = 1 /((L(5,14) - MT2)+L(6,14))
  den(70) = 1 /((L(5,25) - MW2)+L(6,25))
  den(77) = 1 /((L(5,22) - MW2)+L(6,22))
  den(80) = 1 /((L(5,13) - MT2)+L(6,13))
  den(93) = 1 /((L(5,19) - MH2)+L(6,19))
  den(96) = 1 /((L(5,19) - MZ2)+L(6,19))
  den(100) = 1 /((L(5,19))+L(6,19))

  ! denominators
  den(3) = den(1)*den(2)
  den(6) = den(4)*den(5)
  den(8) = den(5)*den(7)
  den(9) = den(1)*den(5)
  den(11) = den(4)*den(10)
  den(12) = den(7)*den(10)
  den(13) = den(1)*den(10)
  den(16) = den(14)*den(15)
  den(17) = den(10)*den(15)
  den(20) = den(18)*den(19)
  den(21) = den(5)*den(18)
  den(23) = den(14)*den(22)
  den(25) = den(14)*den(24)
  den(26) = den(2)*den(14)
  den(27) = den(19)*den(22)
  den(28) = den(19)*den(24)
  den(29) = den(2)*den(19)
  den(30) = den(2)*den(4)
  den(31) = den(1)*den(22)
  den(32) = den(2)*den(7)
  den(33) = den(1)*den(24)
  den(35) = den(5)*den(34)
  den(36) = den(4)*den(35)
  den(38) = den(5)*den(37)
  den(39) = den(7)*den(38)
  den(41) = den(5)*den(40)
  den(42) = den(7)*den(41)
  den(43) = den(1)*den(38)
  den(44) = den(1)*den(41)
  den(46) = den(4)*den(45)
  den(47) = den(5)*den(46)
  den(48) = den(7)*den(45)
  den(49) = den(5)*den(48)
  den(50) = den(1)*den(45)
  den(51) = den(5)*den(50)
  den(52) = den(10)*den(34)
  den(53) = den(4)*den(52)
  den(54) = den(10)*den(37)
  den(55) = den(7)*den(54)
  den(56) = den(10)*den(40)
  den(57) = den(7)*den(56)
  den(58) = den(1)*den(54)
  den(59) = den(1)*den(56)
  den(61) = den(4)*den(60)
  den(62) = den(10)*den(61)
  den(63) = den(7)*den(60)
  den(64) = den(10)*den(63)
  den(65) = den(1)*den(60)
  den(66) = den(10)*den(65)
  den(68) = den(15)*den(67)
  den(69) = den(14)*den(68)
  den(71) = den(14)*den(70)
  den(72) = den(15)*den(71)
  den(73) = den(10)*den(70)
  den(74) = den(15)*den(73)
  den(75) = den(15)*den(60)
  den(76) = den(10)*den(75)
  den(78) = den(19)*den(77)
  den(79) = den(18)*den(78)
  den(81) = den(18)*den(80)
  den(82) = den(19)*den(81)
  den(83) = den(5)*den(77)
  den(84) = den(18)*den(83)
  den(85) = den(18)*den(45)
  den(86) = den(5)*den(85)
  den(87) = den(22)*den(67)
  den(88) = den(14)*den(87)
  den(89) = den(24)*den(67)
  den(90) = den(14)*den(89)
  den(91) = den(2)*den(67)
  den(92) = den(14)*den(91)
  den(94) = den(14)*den(93)
  den(95) = den(22)*den(94)
  den(97) = den(14)*den(96)
  den(98) = den(24)*den(97)
  den(99) = den(2)*den(97)
  den(101) = den(14)*den(100)
  den(102) = den(24)*den(101)
  den(103) = den(2)*den(101)
  den(104) = den(22)*den(80)
  den(105) = den(19)*den(104)
  den(106) = den(24)*den(80)
  den(107) = den(19)*den(106)
  den(108) = den(2)*den(80)
  den(109) = den(19)*den(108)
  den(110) = den(19)*den(93)
  den(111) = den(22)*den(110)
  den(112) = den(19)*den(96)
  den(113) = den(24)*den(112)
  den(114) = den(2)*den(112)
  den(115) = den(19)*den(100)
  den(116) = den(24)*den(115)
  den(117) = den(2)*den(115)
  den(118) = den(1)*den(100)
  den(119) = den(2)*den(40)
  den(120) = den(4)*den(38)
  den(121) = den(7)*den(35)
  den(122) = den(4)*den(41)
  den(123) = den(1)*den(35)
  den(124) = den(4)*den(54)
  den(125) = den(7)*den(52)
  den(126) = den(4)*den(56)
  den(127) = den(1)*den(52)
  den(128) = den(24)*den(94)
  den(129) = den(22)*den(97)
  den(130) = den(2)*den(94)
  den(131) = den(22)*den(101)
  den(132) = den(24)*den(110)
  den(133) = den(22)*den(112)
  den(134) = den(2)*den(110)
  den(135) = den(22)*den(115)

end subroutine denominators

#ifdef PRECISION_dp
! **********************************************************************
subroutine init_merging_tables(tot_num_hels, tot_num_merge_steps)
!-----------------------------------------------------------------------
! In the first event the merging tables are fully initialised
! **********************************************************************
  implicit none
  integer, intent(in) :: tot_num_hels, tot_num_merge_steps
  n_merge_steps = tot_num_merge_steps
  allocate(merge_tables(tot_num_hels,2,n_merge_steps))
  allocate(merge_mism(n_merge_steps+1))
  allocate(merge_hels(n_merge_steps))
  merge_tables_on = .true.
  merge_mism = 0_intkind2
  merge_tables = -1_intkind2
  merge_hels = -1_intkind2
end subroutine init_merging_tables

! **********************************************************************
subroutine update_merging_tables(tot_num_hels)
!-----------------------------------------------------------------------
! After the first evaluation the merging tables are adapted
! **********************************************************************
  implicit none
  integer, intent(in) :: tot_num_hels
  integer(intkind2), allocatable ::  merge_tables_tmp(:,:,:), merge_hels_tmp(:)

  if(merge_mism(1) == 0) then ! helicity configurations match in all merging steps
    if(allocated(merge_tables)) deallocate(merge_tables)
    if(allocated(merge_hels)) deallocate(merge_hels)
    if(allocated(merge_mism)) deallocate(merge_mism)
    allocate(merge_mism(1))
    allocate(merge_hels(1))
    allocate(merge_tables(1,1,1)) ! dummy allocation
    merge_mism = 0_intkind2
    merge_tables = -1_intkind2
    merge_hels = -1_intkind2
  else
    n_merge_mism = merge_mism(1)
    allocate(merge_tables_tmp(tot_num_hels,2,n_merge_mism))
    merge_tables_tmp(:,:,1:n_merge_mism) = merge_tables(:,:,1:n_merge_mism)
    if(allocated(merge_tables)) then
      deallocate(merge_tables)
      allocate(merge_tables(tot_num_hels,2,n_merge_mism))
    end if
    merge_tables = merge_tables_tmp
    if(allocated(merge_tables_tmp)) deallocate(merge_tables_tmp)
    allocate(merge_hels_tmp(n_merge_mism))
    merge_hels_tmp(1:n_merge_mism) = merge_hels(1:n_merge_mism)
    if(allocated(merge_hels)) then
      deallocate(merge_hels)
      allocate(merge_hels(n_merge_mism))
    end if
    merge_hels = merge_hels_tmp
    if(allocated(merge_hels_tmp)) deallocate(merge_hels_tmp)
  end if
  merge_tables_on = .true.
end subroutine update_merging_tables
#endif


!
!
!
! **********************************************************************
#ifdef PRECISION_dp
recursive subroutine amp2(P_scatt, M02, M2ct, M2colint, qp_kinematics)
#else
recursive subroutine amp2(P_scatt, M02, M2ct, M2colint, qp_kinematics)
  use ol_loop_storage_ppttj_ew_ttxbbxg_3_/**/DREALKIND, only: nhel, Hel
#endif
! P_scatt(0:3,Npart) = incoming external momenta
! M2  = helicity-summed squared matrix element for top anti-top bottom anti-bottom glue -> 0
! **********************************************************************
  use ol_parameters_decl_/**/REALKIND !, only: ci, parameters_status, ZERO, scalefactor, >masses<
  use ol_parameters_init_/**/REALKIND, only: ensure_mp_init
  use ol_kinematics_/**/REALKIND, only: init_kinematics
  use ol_momenta_decl_/**/DREALKIND, only: momenta_nan_check
  use ol_data_types_/**/REALKIND
  use ol_h_helicity_bookkeeping_/**/REALKIND, only: &
    & helbookkeeping_wf, helsync, flip_phase
  use ol_helicity_init, only: helbookkeeping_flip, helsync_flip
  use ol_hel_propagators_/**/REALKIND
  use ol_hel_wavefunctions_/**/REALKIND
  use ol_wavefunctions_/**/REALKIND, only: wf_V_Std
  use ol_hel_vertices_/**/REALKIND
  use ol_hel_contractions_/**/REALKIND
  use ol_external_ppttj_ew_ttxbbxg_3, only: &
    & external_perm_ppttj_ew_ttxbbxg_3, &
    & external_perm_inv_ppttj_ew_ttxbbxg_3, &
    & extcomb_perm_ppttj_ew_ttxbbxg_3, &
    & average_factor_ppttj_ew_ttxbbxg_3, &
    & photonid_ppttj_ew_ttxbbxg_3
  use ol_ew_renormalisation_/**/REALKIND, only: photon_factors
  use ol_external_ppttj_ew_ttxbbxg_3, only: &
    & H, hel_not_initialised, hel_init, POLSEL
  use ol_colourmatrix_ppttj_ew_ttxbbxg_3_/**/REALKIND, only: &
    & colmat_not_initialised, colourmatrix_init
  use ol_forced_parameters_ppttj_ew_ttxbbxg_3_/**/REALKIND, only: &
    & check_forced_parameters
  use ol_heltables_OLR_ppttj_ew_ttxbbxg_3
  use ol_kinematics_/**/REALKIND, only: LC2Std_Rep_cmplx
  use ol_h_counterterms_/**/REALKIND
  use ol_loop_parameters_decl_/**/REALKIND ! counterterms
  use ol_loop_parameters_decl_/**/DREALKIND, only: &
    & IR_is_on, DOI, CT_is_on, R2_is_on, TP_is_on
  use ol_init, only: set_parameter, parameters_flush
#ifdef PRECISION_dp
  use ol_kinematics_/**/QREALKIND, only: conv_mom_scatt2in_qp=>conv_mom_scatt2in, &
                                         internal_momenta_qp=>internal_momenta
  use ol_momenta_decl_/**/DREALKIND, only: L
  use ol_momenta_decl_/**/QREALKIND, only: L_qp=>L
#endif
  implicit none

  real(DREALKIND), intent(in)  :: P_scatt(0:3,5)
  real(REALKIND),  intent(out) :: M02, M2ct, M2colint(16)
  logical, intent(in) :: qp_kinematics
  integer(intkind1), save :: ntry = 0

  integer           :: shift, k, r, m, n, i
  real(REALKIND)    :: P(0:3,5)
#ifdef PRECISION_dp
  real(QREALKIND)    :: P_qp(0:3,5)
#endif
  integer           :: extmasses2(5)
  real(REALKIND)    :: M2add, M2add_ct, M2add_colint(16)
  complex(REALKIND) :: M1(8), M2(8)
  real(REALKIND)    :: P_scatt_intern(0:3,5)
  real(REALKIND), save :: scalebackfactor, old_scalefactor = 0
  real(REALKIND)       :: bornphotonfactor
  integer(intkind1) :: nsync
  type(Hpolcont),   save :: M1helarray(8,32)
  type(Hpolcont) :: M1helarray_ct(8,32)
  integer, allocatable :: extcombs_permuted(:)
  integer              :: extcombs(16), nextcombs
  integer              :: CT_on_bak, R2_on_bak, TP_on_bak, DOI_bak

#if 5 > 3
  integer :: ind_cc_comb(5)
#endif
  type(Hpolcont) :: A(32,299)

  !Aj are not used at the moment
  !complex(REALKIND) :: Aj(299)

  complex(REALKIND) :: omega(2) ! phases for helicity correlations

  if(ntry == 0) then
    ! recursive initialization call needed for the correct helicity bokkeeping
    ntry = 1
    CT_on_bak = CT_is_on
    R2_on_bak = R2_is_on
    TP_on_bak = TP_is_on
    DOI_bak = DOI
    call set_parameter("ct_on", 1)
    call set_parameter("r2_on", 1)
    call set_parameter("tp_on", 1)
    DOI = 1
    call amp2(P_scatt, M02, M2ct, M2colint, qp_kinematics)
    call set_parameter("ct_on", CT_on_bak)
    call set_parameter("r2_on", R2_on_bak)
    call set_parameter("tp_on", TP_on_bak)
    DOI = DOI_bak
  end if


  call set_parameter("ew_renorm", 1)
  call parameters_flush()
  call ensure_mp_init()

  if (colmat_not_initialised) call colourmatrix_init()

  if (fac_status_loop1 /= parameters_status .or. fac_status_loop2 /= loop_parameters_status) then
    ! Note: if fac_init would only be called when parameters changed which are relevant for the factors,
    ! a different 'status' would have to be used, because forced_parameters should be called after every parameter change.
    call check_forced_parameters()
    call fac_init_loop()
  end if

  if (momenta_nan_check(P_scatt) /= 0) then
    M02 = 0
    return
  end if

  extmasses2 = [ nMT, nMT, nMB, nMB, 0 ]
  ! Convert 2 -> n-2 PS-point to n -> 0 (so that P(1) + ... + P(n) = 0) and compute
  ! internal-propagator momenta in light-cone representation
  call init_kinematics(P_scatt, extmasses2, P, &
     external_perm_inv_ppttj_ew_ttxbbxg_3, 5, qp_kinematics)

  ! denominators
  call denominators()

   if (heltables_not_init) call init_heltables()

  ! external WFs
  ! Here the external wavefunctions are initialiased
  call pol_wf_Q(P(:,1), rMT, H1, ex1, POLSEL(1),1)
  call pol_wf_A(P(:,2), rMT, H2, ex2, POLSEL(2),2)
  call pol_wf_Q(P(:,3), rMB, H3, ex3, POLSEL(3),3)
  call pol_wf_A(P(:,4), rMB, H4, ex4, POLSEL(4),4)
  call pol_wf_V(P(:,5), rZERO, H5, ex5, POLSEL(5),5)



  ! internal WFs
  ! e.g. call vert_VQ_A(ntry, ex3, ex1, wf1, n1, t1) ...
  call vert_QA_V(ntry, ex1(:), ex2(:), wf4(:,1), n3(:,1), t3x4(:,:,1))
  call vert_QA_V(ntry, ex3(:), ex4(:), wf4(:,2), n3(:,2), t3x4(:,:,2))
  call vert_UV_W(ntry, wf4(:,1), 3, ex5(:), 16, wf8(:,1), n3(:,3), t3x8(:,:,1))
  call vert_AQ_S(gH,ntry, ex2(:), ex1(:), wf4(:,3), n3(:,4), t3x4(:,:,3))
  call vert_VQ_A(ntry, ex5(:), ex3(:), wf4(:,4), n3(:,5), t3x4(:,:,4))
  call prop_Q_A(ntry, wf4(:,4), 20, MB, 1_intkind1, wf4(:,5), n2(1))
  call vert_SA_Q(gH,ntry, wf4(:,3), ex4(:), wf8(:,2), n3(:,6), t3x8(:,:,2))
  call vert_AQ_S(gX,ntry, ex2(:), ex1(:), wf4(:,6), n3(:,7), t3x4(:,:,5))
  call vert_SA_Q(gX,ntry, wf4(:,6), ex4(:), wf8(:,3), n3(:,8), t3x8(:,:,3))
  call vert_AV_Q(ntry, ex4(:), wf4(:,1), wf8(:,4), n3(:,9), t3x8(:,:,4))
  call vert_QA_Z(gZu,ntry, ex1(:), ex2(:), wf4(:,7), n3(:,10), t3x4(:,:,6))
  call vert_AZ_Q(gZd,ntry, ex4(:), wf4(:,7), wf8(:,5), n3(:,11), t3x8(:,:,5))
  call vert_AV_Q(ntry, ex4(:), ex5(:), wf4(:,8), n3(:,12), t3x4(:,:,7))
  call prop_A_Q(ntry, wf4(:,8), 24, MB, 1_intkind1, wf4(:,9), n2(2))
  call vert_QS_A(gH,ntry, ex3(:), wf4(:,3), wf8(:,6), n3(:,13), t3x8(:,:,6))
  call vert_QS_A(gX,ntry, ex3(:), wf4(:,6), wf8(:,7), n3(:,14), t3x8(:,:,7))
  call vert_VQ_A(ntry, wf4(:,1), ex3(:), wf8(:,8), n3(:,15), t3x8(:,:,8))
  call vert_ZQ_A(gZd,ntry, wf4(:,7), ex3(:), wf8(:,9), n3(:,16), t3x8(:,:,9))
  call vert_VQ_A(ntry, ex5(:), ex1(:), wf4(:,10), n3(:,17), t3x4(:,:,8))
  call vert_AQ_S(gPtb,ntry, ex2(:), ex3(:), wf4(:,11), n3(:,18), t3x4(:,:,9))
  call prop_Q_A(ntry, wf4(:,10), 17, MT, 1_intkind1, wf4(:,12), n2(3))
  call vert_AQ_S(gPbt,ntry, ex4(:), wf4(:,12), wf8(:,10), n3(:,19), t3x8(:,:,10))
  call vert_QA_W(ntry, ex3(:), ex2(:), wf4(:,13), n3(:,20), t3x4(:,:,10))
  call vert_QA_W(ntry, wf4(:,12), ex4(:), wf8(:,11), n3(:,21), t3x8(:,:,11))
  call vert_QS_A(gPbt,ntry, ex1(:), wf4(:,11), wf8(:,12), n3(:,22), t3x8(:,:,12))
  call vert_WQ_A(ntry, wf4(:,13), ex1(:), wf8(:,13), n3(:,23), t3x8(:,:,13))
  call vert_AQ_S(gPbt,ntry, ex4(:), ex1(:), wf4(:,14), n3(:,24), t3x4(:,:,11))
  call vert_AV_Q(ntry, ex2(:), ex5(:), wf4(:,15), n3(:,25), t3x4(:,:,12))
  call prop_A_Q(ntry, wf4(:,15), 18, MT, 1_intkind1, wf4(:,16), n2(4))
  call vert_QS_A(gPtb,ntry, ex3(:), wf4(:,14), wf8(:,14), n3(:,26), t3x8(:,:,14))
  call vert_QA_W(ntry, ex1(:), ex4(:), wf4(:,17), n3(:,27), t3x4(:,:,13))
  call vert_WQ_A(ntry, wf4(:,17), ex3(:), wf8(:,15), n3(:,28), t3x8(:,:,15))
  call vert_SA_Q(gPtb,ntry, wf4(:,14), ex2(:), wf8(:,16), n3(:,29), t3x8(:,:,16))
  call vert_AW_Q(ntry, ex2(:), wf4(:,17), wf8(:,17), n3(:,30), t3x8(:,:,17))
  call vert_AQ_S(gH,ntry, ex4(:), ex3(:), wf4(:,18), n3(:,31), t3x4(:,:,14))
  call vert_AQ_S(gH,ntry, ex2(:), wf4(:,12), wf8(:,18), n3(:,32), t3x8(:,:,18))
  call vert_AQ_S(gX,ntry, ex4(:), ex3(:), wf4(:,19), n3(:,33), t3x4(:,:,15))
  call vert_AQ_S(gX,ntry, ex2(:), wf4(:,12), wf8(:,19), n3(:,34), t3x8(:,:,19))
  call vert_QA_V(ntry, wf4(:,12), ex2(:), wf8(:,20), n3(:,35), t3x8(:,:,20))
  call vert_QA_Z(gZd,ntry, ex3(:), ex4(:), wf4(:,20), n3(:,36), t3x4(:,:,16))
  call vert_QA_Z(gZu,ntry, wf4(:,12), ex2(:), wf8(:,21), n3(:,37), t3x8(:,:,21))
  call vert_AQ_S(gH,ntry, wf4(:,16), ex1(:), wf8(:,22), n3(:,38), t3x8(:,:,22))
  call vert_AQ_S(gX,ntry, wf4(:,16), ex1(:), wf8(:,23), n3(:,39), t3x8(:,:,23))
  call vert_QA_V(ntry, ex1(:), wf4(:,16), wf8(:,24), n3(:,40), t3x8(:,:,24))
  call vert_QA_Z(gZu,ntry, ex1(:), wf4(:,16), wf8(:,25), n3(:,41), t3x8(:,:,25))
  call counter_SG_G(ntry, wf4(:,3), ex5(:), wf8(:,26), n3(:,42), t3x8(:,:,26))
  call counter_GG_S(ntry, wf4(:,1), ex5(:), wf8(:,27), n3(:,43), t3x8(:,:,27))
  call counter_VG_G(ntry, wf4(:,7), ex5(:), 16, wf8(:,28), 19, n3(:,44), t3x8(:,:,28))
  call counter_GG_V(ntry, wf4(:,1), 3, ex5(:), 16, wf8(:,29), n3(:,45), t3x8(:,:,29))
  call counter_SA_Q(gH,ntry, wf4(:,3), ex4(:), wf8(:,30), n3(:,46), t3x8(:,:,30))
  call counter_SA_Q(EWctHbb,ntry, wf4(:,3), ex4(:), wf8(:,31), n3(:,47), t3x8(:,:,31))
  call counter_SA_Q(gX,ntry, wf4(:,6), ex4(:), wf8(:,32), n3(:,48), t3x8(:,:,32))
  call counter_SA_Q(EWctXbb,ntry, wf4(:,6), ex4(:), wf8(:,33), n3(:,49), t3x8(:,:,33))
  call counter_AV_Q(ntry, ex4(:), wf4(:,1), wf8(:,34), n3(:,50), t3x8(:,:,34))
  call counter_AV_Q_LR(EWctAbb,ntry, ex4(:), wf4(:,1), wf8(:,35), n3(:,51), t3x8(:,:,35))
  call counter_AZ_Q(gZd,ntry, ex4(:), wf4(:,7), wf8(:,36), n3(:,52), t3x8(:,:,36))
  call counter_AZ_Q(EWctVbb,ntry, ex4(:), wf4(:,7), wf8(:,37), n3(:,53), t3x8(:,:,37))
  call counter_AV_Q_LR(EWctGbb,ntry, ex4(:), wf4(:,1), wf8(:,38), n3(:,54), t3x8(:,:,38))
  call counter_AV_Q(ntry, ex4(:), ex5(:), wf4(:,21), n3(:,55), t3x4(:,:,17))
  call prop_A_Q(ntry, wf4(:,21), 24, MB, 1_intkind1, wf4(:,22), n2(5))
  call counter_AV_Q_LR(EWctGbb,ntry, ex4(:), ex5(:), wf4(:,23), n3(:,56), t3x4(:,:,18))
  call prop_A_Q(ntry, wf4(:,23), 24, MB, 1_intkind1, wf4(:,24), n2(6))
  call counter_QS_A(gH,ntry, ex3(:), wf4(:,3), wf8(:,39), n3(:,57), t3x8(:,:,39))
  call counter_QS_A(EWctHbb,ntry, ex3(:), wf4(:,3), wf8(:,40), n3(:,58), t3x8(:,:,40))
  call counter_QS_A(gX,ntry, ex3(:), wf4(:,6), wf8(:,41), n3(:,59), t3x8(:,:,41))
  call counter_QS_A(EWctXbb,ntry, ex3(:), wf4(:,6), wf8(:,42), n3(:,60), t3x8(:,:,42))
  call counter_VQ_A(ntry, wf4(:,1), ex3(:), wf8(:,43), n3(:,61), t3x8(:,:,43))
  call counter_VQ_A_LR(EWctAbb,ntry, wf4(:,1), ex3(:), wf8(:,44), n3(:,62), t3x8(:,:,44))
  call counter_ZQ_A(gZd,ntry, wf4(:,7), ex3(:), wf8(:,45), n3(:,63), t3x8(:,:,45))
  call counter_ZQ_A(EWctVbb,ntry, wf4(:,7), ex3(:), wf8(:,46), n3(:,64), t3x8(:,:,46))
  call counter_VQ_A_LR(EWctGbb,ntry, wf4(:,1), ex3(:), wf8(:,47), n3(:,65), t3x8(:,:,47))
  call counter_VQ_A(ntry, ex5(:), ex3(:), wf4(:,25), n3(:,66), t3x4(:,:,19))
  call prop_Q_A(ntry, wf4(:,25), 20, MB, 1_intkind1, wf4(:,26), n2(7))
  call counter_VQ_A_LR(EWctGbb,ntry, ex5(:), ex3(:), wf4(:,27), n3(:,67), t3x4(:,:,20))
  call prop_Q_A(ntry, wf4(:,27), 20, MB, 1_intkind1, wf4(:,28), n2(8))
  call counter_QA_V_LR(EWctGbb,ntry, ex3(:), ex4(:), wf4(:,29), n3(:,68), t3x4(:,:,21))
  call counter_AQ_S(ctSbt,ntry, ex4(:), wf4(:,12), wf8(:,48), n3(:,69), t3x8(:,:,48))
  call counter_AQ_S(EWctPbt,ntry, ex4(:), wf4(:,12), wf8(:,49), n3(:,70), t3x8(:,:,49))
  call counter_QA_W(ntry, wf4(:,12), ex4(:), wf8(:,50), n3(:,71), t3x8(:,:,50))
  call counter_QS_A(ctStb,ntry, ex3(:), wf4(:,14), wf8(:,51), n3(:,72), t3x8(:,:,51))
  call counter_QS_A(EWctPtb,ntry, ex3(:), wf4(:,14), wf8(:,52), n3(:,73), t3x8(:,:,52))
  call counter_WQ_A(ntry, wf4(:,17), ex3(:), wf8(:,53), n3(:,74), t3x8(:,:,53))
  call counter_AQ_S(gH,ntry, ex4(:), ex3(:), wf4(:,30), n3(:,75), t3x4(:,:,22))
  call counter_AQ_S(EWctHbb,ntry, ex4(:), ex3(:), wf4(:,31), n3(:,76), t3x4(:,:,23))
  call counter_AQ_S(gX,ntry, ex4(:), ex3(:), wf4(:,32), n3(:,77), t3x4(:,:,24))
  call counter_AQ_S(EWctXbb,ntry, ex4(:), ex3(:), wf4(:,33), n3(:,78), t3x4(:,:,25))
  call counter_QA_V(ntry, ex3(:), ex4(:), wf4(:,34), n3(:,79), t3x4(:,:,26))
  call counter_QA_V_LR(EWctAbb,ntry, ex3(:), ex4(:), wf4(:,35), n3(:,80), t3x4(:,:,27))
  call counter_QA_Z(gZd,ntry, ex3(:), ex4(:), wf4(:,36), n3(:,81), t3x4(:,:,28))
  call counter_QA_Z(EWctVbb,ntry, ex3(:), ex4(:), wf4(:,37), n3(:,82), t3x4(:,:,29))
  call counter_SA_Q(ctStb,ntry, wf4(:,14), ex2(:), wf8(:,54), n3(:,83), t3x8(:,:,54))
  call counter_SA_Q(EWctPtb,ntry, wf4(:,14), ex2(:), wf8(:,55), n3(:,84), t3x8(:,:,55))
  call counter_AW_Q(ntry, ex2(:), wf4(:,17), wf8(:,56), n3(:,85), t3x8(:,:,56))
  call counter_AV_Q(ntry, ex2(:), ex5(:), wf4(:,38), n3(:,86), t3x4(:,:,30))
  call prop_A_Q(ntry, wf4(:,38), 18, MT, 1_intkind1, wf4(:,39), n2(9))
  call counter_AV_Q_LR(EWctGtt,ntry, ex2(:), ex5(:), wf4(:,40), n3(:,87), t3x4(:,:,31))
  call prop_A_Q(ntry, wf4(:,40), 18, MT, 1_intkind1, wf4(:,41), n2(10))
  call counter_AQ_S(gH,ntry, ex2(:), wf4(:,12), wf8(:,57), n3(:,88), t3x8(:,:,57))
  call counter_AQ_S(EWctHtt,ntry, ex2(:), wf4(:,12), wf8(:,58), n3(:,89), t3x8(:,:,58))
  call counter_AQ_S(gX,ntry, ex2(:), wf4(:,12), wf8(:,59), n3(:,90), t3x8(:,:,59))
  call counter_AQ_S(EWctXtt,ntry, ex2(:), wf4(:,12), wf8(:,60), n3(:,91), t3x8(:,:,60))
  call counter_QA_V(ntry, wf4(:,12), ex2(:), wf8(:,61), n3(:,92), t3x8(:,:,61))
  call counter_QA_V_LR(EWctAtt,ntry, wf4(:,12), ex2(:), wf8(:,62), n3(:,93), t3x8(:,:,62))
  call counter_QA_Z(gZu,ntry, wf4(:,12), ex2(:), wf8(:,63), n3(:,94), t3x8(:,:,63))
  call counter_QA_Z(EWctVtt,ntry, wf4(:,12), ex2(:), wf8(:,64), n3(:,95), t3x8(:,:,64))
  call counter_QA_V_LR(EWctGtt,ntry, wf4(:,12), ex2(:), wf8(:,65), n3(:,96), t3x8(:,:,65))
  call vert_AQ_S(gH,ntry, wf4(:,39), ex1(:), wf8(:,66), n3(:,97), t3x8(:,:,66))
  call vert_AQ_S(gH,ntry, wf4(:,41), ex1(:), wf8(:,67), n3(:,98), t3x8(:,:,67))
  call vert_AQ_S(gX,ntry, wf4(:,39), ex1(:), wf8(:,68), n3(:,99), t3x8(:,:,68))
  call vert_AQ_S(gX,ntry, wf4(:,41), ex1(:), wf8(:,69), n3(:,100), t3x8(:,:,69))
  call vert_QA_V(ntry, ex1(:), wf4(:,39), wf8(:,70), n3(:,101), t3x8(:,:,70))
  call vert_QA_V(ntry, ex1(:), wf4(:,41), wf8(:,71), n3(:,102), t3x8(:,:,71))
  call vert_QA_Z(gZu,ntry, ex1(:), wf4(:,39), wf8(:,72), n3(:,103), t3x8(:,:,72))
  call vert_QA_Z(gZu,ntry, ex1(:), wf4(:,41), wf8(:,73), n3(:,104), t3x8(:,:,73))
  call counter_AQ_S(ctStb,ntry, ex2(:), ex3(:), wf4(:,42), n3(:,105), t3x4(:,:,32))
  call counter_AQ_S(EWctPtb,ntry, ex2(:), ex3(:), wf4(:,43), n3(:,106), t3x4(:,:,33))
  call counter_QA_W(ntry, ex3(:), ex2(:), wf4(:,44), n3(:,107), t3x4(:,:,34))
  call vert_QS_A(gPbt,ntry, ex1(:), wf4(:,42), wf8(:,74), n3(:,108), t3x8(:,:,74))
  call vert_QS_A(gPbt,ntry, ex1(:), wf4(:,43), wf8(:,75), n3(:,109), t3x8(:,:,75))
  call vert_WQ_A(ntry, wf4(:,44), ex1(:), wf8(:,76), n3(:,110), t3x8(:,:,76))
  call counter_QS_A(ctSbt,ntry, ex1(:), wf4(:,11), wf8(:,77), n3(:,111), t3x8(:,:,77))
  call counter_QS_A(EWctPbt,ntry, ex1(:), wf4(:,11), wf8(:,78), n3(:,112), t3x8(:,:,78))
  call counter_WQ_A(ntry, wf4(:,13), ex1(:), wf8(:,79), n3(:,113), t3x8(:,:,79))
  call counter_VQ_A(ntry, ex5(:), ex1(:), wf4(:,45), n3(:,114), t3x4(:,:,35))
  call prop_Q_A(ntry, wf4(:,45), 17, MT, 1_intkind1, wf4(:,46), n2(11))
  call vert_AQ_S(gPbt,ntry, ex4(:), wf4(:,46), wf8(:,80), n3(:,115), t3x8(:,:,80))
  call counter_VQ_A_LR(EWctGtt,ntry, ex5(:), ex1(:), wf4(:,47), n3(:,116), t3x4(:,:,36))
  call prop_Q_A(ntry, wf4(:,47), 17, MT, 1_intkind1, wf4(:,48), n2(12))
  call vert_AQ_S(gPbt,ntry, ex4(:), wf4(:,48), wf8(:,81), n3(:,117), t3x8(:,:,81))
  call vert_QA_W(ntry, wf4(:,46), ex4(:), wf8(:,82), n3(:,118), t3x8(:,:,82))
  call vert_QA_W(ntry, wf4(:,48), ex4(:), wf8(:,83), n3(:,119), t3x8(:,:,83))
  call counter_AQ_S(gH,ntry, wf4(:,16), ex1(:), wf8(:,84), n3(:,120), t3x8(:,:,84))
  call counter_AQ_S(EWctHtt,ntry, wf4(:,16), ex1(:), wf8(:,85), n3(:,121), t3x8(:,:,85))
  call counter_AQ_S(gX,ntry, wf4(:,16), ex1(:), wf8(:,86), n3(:,122), t3x8(:,:,86))
  call counter_AQ_S(EWctXtt,ntry, wf4(:,16), ex1(:), wf8(:,87), n3(:,123), t3x8(:,:,87))
  call counter_QA_V(ntry, ex1(:), wf4(:,16), wf8(:,88), n3(:,124), t3x8(:,:,88))
  call counter_QA_V_LR(EWctAtt,ntry, ex1(:), wf4(:,16), wf8(:,89), n3(:,125), t3x8(:,:,89))
  call counter_QA_Z(gZu,ntry, ex1(:), wf4(:,16), wf8(:,90), n3(:,126), t3x8(:,:,90))
  call counter_QA_Z(EWctVtt,ntry, ex1(:), wf4(:,16), wf8(:,91), n3(:,127), t3x8(:,:,91))
  call counter_QA_V_LR(EWctGtt,ntry, ex1(:), wf4(:,16), wf8(:,92), n3(:,128), t3x8(:,:,92))
  call vert_AQ_S(gH,ntry, ex2(:), wf4(:,46), wf8(:,93), n3(:,129), t3x8(:,:,93))
  call vert_AQ_S(gH,ntry, ex2(:), wf4(:,48), wf8(:,94), n3(:,130), t3x8(:,:,94))
  call vert_AQ_S(gX,ntry, ex2(:), wf4(:,46), wf8(:,95), n3(:,131), t3x8(:,:,95))
  call vert_AQ_S(gX,ntry, ex2(:), wf4(:,48), wf8(:,96), n3(:,132), t3x8(:,:,96))
  call vert_QA_V(ntry, wf4(:,46), ex2(:), wf8(:,97), n3(:,133), t3x8(:,:,97))
  call vert_QA_V(ntry, wf4(:,48), ex2(:), wf8(:,98), n3(:,134), t3x8(:,:,98))
  call vert_QA_Z(gZu,ntry, wf4(:,46), ex2(:), wf8(:,99), n3(:,135), t3x8(:,:,99))
  call vert_QA_Z(gZu,ntry, wf4(:,48), ex2(:), wf8(:,100), n3(:,136), t3x8(:,:,100))
  call counter_AQ_S(ctSbt,ntry, ex4(:), ex1(:), wf4(:,49), n3(:,137), t3x4(:,:,37))
  call vert_QS_A(gPtb,ntry, ex3(:), wf4(:,49), wf8(:,101), n3(:,138), t3x8(:,:,101))
  call counter_AQ_S(EWctPbt,ntry, ex4(:), ex1(:), wf4(:,50), n3(:,139), t3x4(:,:,38))
  call vert_QS_A(gPtb,ntry, ex3(:), wf4(:,50), wf8(:,102), n3(:,140), t3x8(:,:,102))
  call counter_QA_W(ntry, ex1(:), ex4(:), wf4(:,51), n3(:,141), t3x4(:,:,39))
  call vert_WQ_A(ntry, wf4(:,51), ex3(:), wf8(:,103), n3(:,142), t3x8(:,:,103))
  call vert_SA_Q(gPtb,ntry, wf4(:,49), ex2(:), wf8(:,104), n3(:,143), t3x8(:,:,104))
  call vert_SA_Q(gPtb,ntry, wf4(:,50), ex2(:), wf8(:,105), n3(:,144), t3x8(:,:,105))
  call vert_AW_Q(ntry, ex2(:), wf4(:,51), wf8(:,106), n3(:,145), t3x8(:,:,106))
  call counter_QA_V_LR(EWctGtt,ntry, ex1(:), ex2(:), wf4(:,52), n3(:,146), t3x4(:,:,40))
  call vert_UV_W(ntry, wf4(:,52), 3, ex5(:), 16, wf8(:,107), n3(:,147), t3x8(:,:,107))
  call counter_AQ_S(gH,ntry, ex2(:), ex1(:), wf4(:,53), n3(:,148), t3x4(:,:,41))
  call vert_SA_Q(gH,ntry, wf4(:,53), ex4(:), wf8(:,108), n3(:,149), t3x8(:,:,108))
  call counter_AQ_S(EWctHtt,ntry, ex2(:), ex1(:), wf4(:,54), n3(:,150), t3x4(:,:,42))
  call vert_SA_Q(gH,ntry, wf4(:,54), ex4(:), wf8(:,109), n3(:,151), t3x8(:,:,109))
  call counter_AQ_S(gX,ntry, ex2(:), ex1(:), wf4(:,55), n3(:,152), t3x4(:,:,43))
  call vert_SA_Q(gX,ntry, wf4(:,55), ex4(:), wf8(:,110), n3(:,153), t3x8(:,:,110))
  call counter_AQ_S(EWctXtt,ntry, ex2(:), ex1(:), wf4(:,56), n3(:,154), t3x4(:,:,44))
  call vert_SA_Q(gX,ntry, wf4(:,56), ex4(:), wf8(:,111), n3(:,155), t3x8(:,:,111))
  call counter_QA_V(ntry, ex1(:), ex2(:), wf4(:,57), n3(:,156), t3x4(:,:,45))
  call vert_AV_Q(ntry, ex4(:), wf4(:,57), wf8(:,112), n3(:,157), t3x8(:,:,112))
  call counter_QA_V_LR(EWctAtt,ntry, ex1(:), ex2(:), wf4(:,58), n3(:,158), t3x4(:,:,46))
  call vert_AV_Q(ntry, ex4(:), wf4(:,58), wf8(:,113), n3(:,159), t3x8(:,:,113))
  call counter_QA_Z(gZu,ntry, ex1(:), ex2(:), wf4(:,59), n3(:,160), t3x4(:,:,47))
  call vert_AZ_Q(gZd,ntry, ex4(:), wf4(:,59), wf8(:,114), n3(:,161), t3x8(:,:,114))
  call counter_QA_Z(EWctVtt,ntry, ex1(:), ex2(:), wf4(:,60), n3(:,162), t3x4(:,:,48))
  call vert_AZ_Q(gZd,ntry, ex4(:), wf4(:,60), wf8(:,115), n3(:,163), t3x8(:,:,115))
  call vert_AV_Q(ntry, ex4(:), wf4(:,52), wf8(:,116), n3(:,164), t3x8(:,:,116))
  call vert_QS_A(gH,ntry, ex3(:), wf4(:,53), wf8(:,117), n3(:,165), t3x8(:,:,117))
  call vert_QS_A(gH,ntry, ex3(:), wf4(:,54), wf8(:,118), n3(:,166), t3x8(:,:,118))
  call vert_QS_A(gX,ntry, ex3(:), wf4(:,55), wf8(:,119), n3(:,167), t3x8(:,:,119))
  call vert_QS_A(gX,ntry, ex3(:), wf4(:,56), wf8(:,120), n3(:,168), t3x8(:,:,120))
  call vert_VQ_A(ntry, wf4(:,57), ex3(:), wf8(:,121), n3(:,169), t3x8(:,:,121))
  call vert_VQ_A(ntry, wf4(:,58), ex3(:), wf8(:,122), n3(:,170), t3x8(:,:,122))
  call vert_ZQ_A(gZd,ntry, wf4(:,59), ex3(:), wf8(:,123), n3(:,171), t3x8(:,:,123))
  call vert_ZQ_A(gZd,ntry, wf4(:,60), ex3(:), wf8(:,124), n3(:,172), t3x8(:,:,124))
  call vert_VQ_A(ntry, wf4(:,52), ex3(:), wf8(:,125), n3(:,173), t3x8(:,:,125))
  call vert_AQ_S(gH,ntry, ex4(:), wf4(:,5), wf8(:,126), n3(:,174), t3x8(:,:,126))
  call counter_S_S(EWctHH,ntry, wf4(:,3), 3, wf4(:,61), n2(13))
  call vert_AQ_S(gX,ntry, ex4(:), wf4(:,5), wf8(:,127), n3(:,175), t3x8(:,:,127))
  call counter_S_S(EWctXX,ntry, wf4(:,6), 3, wf4(:,62), n2(14))
  call vert_QA_V(ntry, wf4(:,5), ex4(:), wf8(:,128), n3(:,176), t3x8(:,:,128))
  call counter_S_V(EWctXA,ntry, wf4(:,6), 3, wf4(:,63), n2(15))
  call vert_QA_Z(gZd,ntry, wf4(:,5), ex4(:), wf8(:,129), n3(:,177), t3x8(:,:,129))
  call counter_S_V(EWctXZ,ntry, wf4(:,6), 3, wf4(:,64), n2(16))
  call counter_V_S(EWctXA,ntry, wf4(:,1), 3, wf4(:,65), n2(17))
  call counter_V_S(EWctXZ,ntry, wf4(:,7), 3, wf4(:,66), n2(18))
  call counter_V_V(EWctAA,ntry, wf4(:,1), 3, wf4(:,67), n2(19))
  call counter_V_V(EWctAZ,ntry, wf4(:,1), 3, wf4(:,68), n2(20))
  call counter_V_V(EWctAZ,ntry, wf4(:,7), 3, wf4(:,69), n2(21))
  call counter_V_V(EWctZZ,ntry, wf4(:,7), 3, wf4(:,70), n2(22))
  call counter_Q_A(ctbb,5,ntry, wf4(:,5), 20, wf4(:,71), n2(23))
  call prop_A_Q(ntry, wf8(:,2), 11, MB, 1_intkind1, wf8(:,130), n2(24))
  call counter_Q_A_LR(EWctbb,ntry, wf4(:,5), 20, wf4(:,72), n2(25))
  call prop_A_Q(ntry, wf8(:,3), 11, MB, 1_intkind1, wf8(:,131), n2(26))
  call prop_A_Q(ntry, wf8(:,4), 11, MB, 1_intkind1, wf8(:,132), n2(27))
  call prop_A_Q(ntry, wf8(:,5), 11, MB, 1_intkind1, wf8(:,133), n2(28))
  call vert_AQ_S(gH,ntry, wf4(:,9), ex3(:), wf8(:,134), n3(:,178), t3x8(:,:,130))
  call vert_AQ_S(gX,ntry, wf4(:,9), ex3(:), wf8(:,135), n3(:,179), t3x8(:,:,131))
  call vert_QA_V(ntry, ex3(:), wf4(:,9), wf8(:,136), n3(:,180), t3x8(:,:,132))
  call vert_QA_Z(gZd,ntry, ex3(:), wf4(:,9), wf8(:,137), n3(:,181), t3x8(:,:,133))
  call counter_A_Q(ctbb,5,ntry, wf4(:,9), 24, wf4(:,73), n2(29))
  call prop_Q_A(ntry, wf8(:,6), 7, MB, 1_intkind1, wf8(:,138), n2(30))
  call counter_A_Q_LR(EWctbb,ntry, wf4(:,9), 24, wf4(:,74), n2(31))
  call prop_Q_A(ntry, wf8(:,7), 7, MB, 1_intkind1, wf8(:,139), n2(32))
  call prop_Q_A(ntry, wf8(:,8), 7, MB, 1_intkind1, wf8(:,140), n2(33))
  call prop_Q_A(ntry, wf8(:,9), 7, MB, 1_intkind1, wf8(:,141), n2(34))
  call vert_SA_Q(gPbt,ntry, wf4(:,11), ex4(:), wf8(:,142), n3(:,182), t3x8(:,:,134))
  call counter_Q_A(cttt,6,ntry, wf4(:,12), 17, wf4(:,75), n2(35))
  call prop_A_Q(ntry, wf8(:,142), 14, MT, 1_intkind1, wf8(:,143), n2(36))
  call counter_Q_A_LR(EWcttt,ntry, wf4(:,12), 17, wf4(:,76), n2(37))
  call vert_AW_Q(ntry, ex4(:), wf4(:,13), wf8(:,144), n3(:,183), t3x8(:,:,135))
  call prop_A_Q(ntry, wf8(:,144), 14, MT, 1_intkind1, wf8(:,145), n2(38))
  call counter_S_S(EWctPP,ntry, wf4(:,11), 6, wf4(:,77), n2(39))
  call counter_S_V(EWctPW,ntry, wf4(:,11), 6, wf4(:,78), n2(40))
  call counter_V_S(EWctPW,ntry, wf4(:,13), 6, wf4(:,79), n2(41))
  call counter_V_V(EWctWW,ntry, wf4(:,13), 6, wf4(:,80), n2(42))
  call vert_AQ_S(gPbt,ntry, wf4(:,9), ex1(:), wf8(:,146), n3(:,184), t3x8(:,:,136))
  call vert_QA_W(ntry, ex1(:), wf4(:,9), wf8(:,147), n3(:,185), t3x8(:,:,137))
  call prop_Q_A(ntry, wf8(:,12), 7, MB, 1_intkind1, wf8(:,148), n2(43))
  call prop_Q_A(ntry, wf8(:,13), 7, MB, 1_intkind1, wf8(:,149), n2(44))
  call vert_AQ_S(gPtb,ntry, wf4(:,16), ex3(:), wf8(:,150), n3(:,186), t3x8(:,:,138))
  call counter_S_S(EWctPP,ntry, wf4(:,14), 9, wf4(:,81), n2(45))
  call vert_QA_W(ntry, ex3(:), wf4(:,16), wf8(:,151), n3(:,187), t3x8(:,:,139))
  call counter_S_V(EWctPW,ntry, wf4(:,14), 9, wf4(:,82), n2(46))
  call counter_V_S(EWctPW,ntry, wf4(:,17), 9, wf4(:,83), n2(47))
  call counter_V_V(EWctWW,ntry, wf4(:,17), 9, wf4(:,84), n2(48))
  call counter_A_Q(cttt,6,ntry, wf4(:,16), 18, wf4(:,85), n2(49))
  call prop_Q_A(ntry, wf8(:,14), 13, MT, 1_intkind1, wf8(:,152), n2(50))
  call counter_A_Q_LR(EWcttt,ntry, wf4(:,16), 18, wf4(:,86), n2(51))
  call prop_Q_A(ntry, wf8(:,15), 13, MT, 1_intkind1, wf8(:,153), n2(52))
  call vert_AQ_S(gPtb,ntry, ex2(:), wf4(:,5), wf8(:,154), n3(:,188), t3x8(:,:,140))
  call vert_QA_W(ntry, wf4(:,5), ex2(:), wf8(:,155), n3(:,189), t3x8(:,:,141))
  call prop_A_Q(ntry, wf8(:,16), 11, MB, 1_intkind1, wf8(:,156), n2(53))
  call prop_A_Q(ntry, wf8(:,17), 11, MB, 1_intkind1, wf8(:,157), n2(54))
  call vert_SA_Q(gH,ntry, wf4(:,18), ex2(:), wf8(:,158), n3(:,190), t3x8(:,:,142))
  call prop_A_Q(ntry, wf8(:,158), 14, MT, 1_intkind1, wf8(:,159), n2(55))
  call vert_SA_Q(gX,ntry, wf4(:,19), ex2(:), wf8(:,160), n3(:,191), t3x8(:,:,143))
  call prop_A_Q(ntry, wf8(:,160), 14, MT, 1_intkind1, wf8(:,161), n2(56))
  call vert_AV_Q(ntry, ex2(:), wf4(:,2), wf8(:,162), n3(:,192), t3x8(:,:,144))
  call prop_A_Q(ntry, wf8(:,162), 14, MT, 1_intkind1, wf8(:,163), n2(57))
  call vert_AZ_Q(gZu,ntry, ex2(:), wf4(:,20), wf8(:,164), n3(:,193), t3x8(:,:,145))
  call prop_A_Q(ntry, wf8(:,164), 14, MT, 1_intkind1, wf8(:,165), n2(58))
  call counter_S_S(EWctHH,ntry, wf4(:,18), 12, wf4(:,87), n2(59))
  call counter_S_S(EWctXX,ntry, wf4(:,19), 12, wf4(:,88), n2(60))
  call counter_V_S(EWctXA,ntry, wf4(:,2), 12, wf4(:,89), n2(61))
  call counter_V_S(EWctXZ,ntry, wf4(:,20), 12, wf4(:,90), n2(62))
  call counter_S_V(EWctXA,ntry, wf4(:,19), 12, wf4(:,91), n2(63))
  call counter_S_V(EWctXZ,ntry, wf4(:,19), 12, wf4(:,92), n2(64))
  call counter_V_V(EWctAA,ntry, wf4(:,2), 12, wf4(:,93), n2(65))
  call counter_V_V(EWctAZ,ntry, wf4(:,20), 12, wf4(:,94), n2(66))
  call counter_V_V(EWctAZ,ntry, wf4(:,2), 12, wf4(:,95), n2(67))
  call counter_V_V(EWctZZ,ntry, wf4(:,20), 12, wf4(:,96), n2(68))
  call vert_QS_A(gH,ntry, ex1(:), wf4(:,18), wf8(:,166), n3(:,194), t3x8(:,:,146))
  call prop_Q_A(ntry, wf8(:,166), 13, MT, 1_intkind1, wf8(:,167), n2(69))
  call vert_QS_A(gX,ntry, ex1(:), wf4(:,19), wf8(:,168), n3(:,195), t3x8(:,:,147))
  call prop_Q_A(ntry, wf8(:,168), 13, MT, 1_intkind1, wf8(:,169), n2(70))
  call vert_VQ_A(ntry, wf4(:,2), ex1(:), wf8(:,170), n3(:,196), t3x8(:,:,148))
  call prop_Q_A(ntry, wf8(:,170), 13, MT, 1_intkind1, wf8(:,171), n2(71))
  call vert_ZQ_A(gZu,ntry, wf4(:,20), ex1(:), wf8(:,172), n3(:,197), t3x8(:,:,149))
  call prop_Q_A(ntry, wf8(:,172), 13, MT, 1_intkind1, wf8(:,173), n2(72))
  call vert_UV_W(ntry, wf4(:,2), 12, ex5(:), 16, wf8(:,174), n3(:,198), t3x8(:,:,150))


  call init_hybrid_exwf(ex1)
  call init_hybrid_exwf(ex2)
  call init_hybrid_exwf(ex3)
  call init_hybrid_exwf(ex4)
  call init_hybrid_exwf(ex5)
  call init_hybrid_wf(wf4)
  call init_hybrid_wf(wf8)


  if (ntry==1) then
    call physical_helicities()
  end if

  ! computation of the colour-stripped amplitudes
  do nsync = ntry+ntry-1, ntry+1  !  nsync = 1,2  for 1st point and nsync = 3 later
    call diagrams()
    if (nsync == 1) call helsync(nsync, A, nhel, Hel)
  end do

  ! In the following loop the coefficients \Gamma_{i} of the expansion in
  ! the colour basis are computed for every helicity state and stored in M1helarray.
  ! Also the colour vector for the Born-loop interference is computed and saved in
  ! M0_col1_helarray
  do k = 1, nhel
    call colourvectors(A, k, M1helarray(:,k),M1helarray_ct(:,k))
    call colborninterf(M1helarray(:,k), M0_col1_helarray(:,k), 0)
  end do
  M1helarray(:,nhel+1:)%j = 0
  M0_col1_helarray(:,nhel+1:)%hf = -1_intkind2
  M0_col1_helarray(:,nhel+1:)%j = 0

  M2add = 0
  M2add_ct = 0
  M2add_colint = 0

  M02 = 0
  M2ct = 0
  M2colint = 0

  do k = 1, nhel
    call colint(M1helarray(:,k)%j, M2add)
    call colint_ct(M1helarray(:,k)%j, M1helarray_ct(:,k)%j, M2add_ct, 0)
    if (IR_is_on > 0) then
      call colint_IR(M1helarray(:,k)%j, M2add_colint)
    end if
    !summation over helicity configurations
    M02 = M02 + M2add
    M2ct = M2ct + M2add_ct
    M2colint = M2colint + M2add_colint
  end do

  call photon_factors(photonid_ppttj_ew_ttxbbxg_3, &
                    &  0, bornphotonfactor)
  M02 = bornphotonfactor * M02
  M2ct = bornphotonfactor * M2ct
  M2colint = bornphotonfactor * M2colint

  !! used for born-loop colour-correlators
  extcombs = [(i, i = 0, 16-1)]
  nextcombs = 5*(5+1)/2 + 1
  if(nextcombs>0) then
    allocate(extcombs_permuted(nextcombs))
  end if
  do k = 1, nextcombs
    extcombs_permuted(k) = extcomb_perm_ppttj_ew_ttxbbxg_3(extcombs(k))
  end do

#if 1 > 0 && 5 > 3
  !!Born-loop colour correlators interference
ind_cc_comb = [8,12,9,13,14]
  M0M1_hel_cc(:,:,:)%j = 0
  do n = 1, 5
    M2add_ct = 0
    m = ind_cc_comb(n)
      do k = 1, nhel
        call colint_ct(M1helarray(:,k)%j, M1helarray_ct(:,k)%j, M2add_ct, m)
        call colborninterf(M1helarray(:,k), M0M1_hel_cc(:,k,m), m)
        M2ctcc(m) = M2ctcc(m) + M2add_ct
      end do
  end do
  M0M1_hel_cc(:,nhel+1:,:)%hf = -1_intkind2
  M0M1_hel_cc(:,nhel+1:,:)%j = 0
#endif

  ntry=2


  contains

subroutine physical_helicities()
  implicit none

integer :: i1,i2,i3,i4,i5
integer :: n

n=0

do i5= 1, 2
do i4= 1, 2
do i3= 1, 2
do i2= 1, 2
do i1= 1, 2
n = n + 1
 if((ex1(i1)%hf==-1_intkind2) .OR. (ex2(i2)%hf==-1_intkind2) .OR. (ex3(i3)%hf==-1_intkind2) .OR. (ex4(i4)%hf==-1_intkind2)  &
    .OR. (ex5(i5)%hf==-1_intkind2)) then
  Hel(n) = -1_intkind2
 else
  Hel(n) = ex1(i1)%hf + ex2(i2)%hf + ex3(i3)%hf + ex4(i4)%hf + ex5(i5)%hf
 end if
end do
end do
end do
end do
end do

end subroutine physical_helicities

subroutine diagrams()
  implicit none
  integer :: h
  ! e.g. call cont_VV(nsync, wf3, wf6, A(:,1), n64, t64, nhel, den(5)) ...

    call Hcont_VV(nsync, wf4(:,2), wf8(:,1), A(:,1), n3(:,199), t3x32(:,:,1), nhel, den(3))
    call Hcont_QA(nsync, wf4(:,5), wf8(:,2), A(:,2), n3(:,200), t3x32(:,:,2), nhel, den(6))
    call Hcont_QA(nsync, wf4(:,5), wf8(:,3), A(:,3), n3(:,201), t3x32(:,:,3), nhel, den(8))
    call Hcont_QA(nsync, wf4(:,5), wf8(:,4), A(:,4), n3(:,202), t3x32(:,:,4), nhel, den(9))
    call Hcont_QA(nsync, wf4(:,5), wf8(:,5), A(:,5), n3(:,203), t3x32(:,:,5), nhel, den(8))
    call Hcont_QA(nsync, wf4(:,5), wf8(:,4), A(:,6), n3(:,204), t3x32(:,:,6), nhel, den(9))
    call Hcont_QA(nsync, wf4(:,9), wf8(:,6), A(:,7), n3(:,205), t3x32(:,:,7), nhel, den(11))
    call Hcont_QA(nsync, wf4(:,9), wf8(:,7), A(:,8), n3(:,206), t3x32(:,:,8), nhel, den(12))
    call Hcont_QA(nsync, wf4(:,9), wf8(:,8), A(:,9), n3(:,207), t3x32(:,:,9), nhel, den(13))
    call Hcont_QA(nsync, wf4(:,9), wf8(:,9), A(:,10), n3(:,208), t3x32(:,:,10), nhel, den(12))
    call Hcont_QA(nsync, wf4(:,9), wf8(:,8), A(:,11), n3(:,209), t3x32(:,:,11), nhel, den(13))
    call Hcont_SS(nsync, wf4(:,11), wf8(:,10), A(:,12), n3(:,210), t3x32(:,:,12), nhel, den(16))
    call Hcont_VV(nsync, wf4(:,13), wf8(:,11), A(:,13), n3(:,211), t3x32(:,:,13), nhel, den(16))
    call Hcont_QA(nsync, wf4(:,9), wf8(:,12), A(:,14), n3(:,212), t3x32(:,:,14), nhel, den(17))
    call Hcont_QA(nsync, wf4(:,9), wf8(:,13), A(:,15), n3(:,213), t3x32(:,:,15), nhel, den(17))
    call Hcont_QA(nsync, wf4(:,16), wf8(:,14), A(:,16), n3(:,214), t3x32(:,:,16), nhel, den(20))
    call Hcont_QA(nsync, wf4(:,16), wf8(:,15), A(:,17), n3(:,215), t3x32(:,:,17), nhel, den(20))
    call Hcont_QA(nsync, wf4(:,5), wf8(:,16), A(:,18), n3(:,216), t3x32(:,:,18), nhel, den(21))
    call Hcont_QA(nsync, wf4(:,5), wf8(:,17), A(:,19), n3(:,217), t3x32(:,:,19), nhel, den(21))
    call Hcont_SS(nsync, wf4(:,18), wf8(:,18), A(:,20), n3(:,218), t3x32(:,:,20), nhel, den(23))
    call Hcont_SS(nsync, wf4(:,19), wf8(:,19), A(:,21), n3(:,219), t3x32(:,:,21), nhel, den(25))
    call Hcont_VV(nsync, wf4(:,2), wf8(:,20), A(:,22), n3(:,220), t3x32(:,:,22), nhel, den(26))
    call Hcont_VV(nsync, wf4(:,20), wf8(:,21), A(:,23), n3(:,221), t3x32(:,:,23), nhel, den(25))
    call Hcont_VV(nsync, wf4(:,2), wf8(:,20), A(:,24), n3(:,222), t3x32(:,:,24), nhel, den(26))
    call Hcont_SS(nsync, wf4(:,18), wf8(:,22), A(:,25), n3(:,223), t3x32(:,:,25), nhel, den(27))
    call Hcont_SS(nsync, wf4(:,19), wf8(:,23), A(:,26), n3(:,224), t3x32(:,:,26), nhel, den(28))
    call Hcont_VV(nsync, wf4(:,2), wf8(:,24), A(:,27), n3(:,225), t3x32(:,:,27), nhel, den(29))
    call Hcont_VV(nsync, wf4(:,20), wf8(:,25), A(:,28), n3(:,226), t3x32(:,:,28), nhel, den(28))
    call Hcont_VV(nsync, wf4(:,2), wf8(:,24), A(:,29), n3(:,227), t3x32(:,:,29), nhel, den(29))

    call Hcont_VV(nsync, wf4(:,2), wf8(:,26), A(:,30), n3(:,228), t3x32(:,:,30), nhel, den(30))
    call Hcont_SS(nsync, wf4(:,18), wf8(:,27), A(:,31), n3(:,229), t3x32(:,:,31), nhel, den(31))
    call Hcont_VV(nsync, wf4(:,2), wf8(:,28), A(:,32), n3(:,230), t3x32(:,:,32), nhel, den(32))
    call Hcont_VV(nsync, wf4(:,20), wf8(:,29), A(:,33), n3(:,231), t3x32(:,:,33), nhel, den(33))
    call Hcont_QA(nsync, wf4(:,5), wf8(:,30), A(:,34), n3(:,232), t3x32(:,:,34), nhel, den(6))
    call Hcont_QA(nsync, wf4(:,5), wf8(:,31), A(:,35), n3(:,233), t3x32(:,:,35), nhel, den(6))
    call Hcont_QA(nsync, wf4(:,5), wf8(:,32), A(:,36), n3(:,234), t3x32(:,:,36), nhel, den(8))
    call Hcont_QA(nsync, wf4(:,5), wf8(:,33), A(:,37), n3(:,235), t3x32(:,:,37), nhel, den(8))
    call Hcont_QA(nsync, wf4(:,5), wf8(:,34), A(:,38), n3(:,236), t3x32(:,:,38), nhel, den(9))
    call Hcont_QA(nsync, wf4(:,5), wf8(:,35), A(:,39), n3(:,237), t3x32(:,:,39), nhel, den(9))
    call Hcont_QA(nsync, wf4(:,5), wf8(:,36), A(:,40), n3(:,238), t3x32(:,:,40), nhel, den(8))
    call Hcont_QA(nsync, wf4(:,5), wf8(:,37), A(:,41), n3(:,239), t3x32(:,:,41), nhel, den(8))
    call Hcont_QA(nsync, wf4(:,5), wf8(:,38), A(:,42), n3(:,240), t3x32(:,:,42), nhel, den(9))
    call Hcont_QA(nsync, wf8(:,6), wf4(:,22), A(:,43), n3(:,241), t3x32(:,:,43), nhel, den(11))
    call Hcont_QA(nsync, wf8(:,6), wf4(:,24), A(:,44), n3(:,242), t3x32(:,:,44), nhel, den(11))
    call Hcont_QA(nsync, wf8(:,7), wf4(:,22), A(:,45), n3(:,243), t3x32(:,:,45), nhel, den(12))
    call Hcont_QA(nsync, wf8(:,7), wf4(:,24), A(:,46), n3(:,244), t3x32(:,:,46), nhel, den(12))
    call Hcont_QA(nsync, wf8(:,8), wf4(:,22), A(:,47), n3(:,245), t3x32(:,:,47), nhel, den(13))
    call Hcont_QA(nsync, wf8(:,8), wf4(:,24), A(:,48), n3(:,246), t3x32(:,:,48), nhel, den(13))
    call Hcont_QA(nsync, wf8(:,9), wf4(:,22), A(:,49), n3(:,247), t3x32(:,:,49), nhel, den(12))
    call Hcont_QA(nsync, wf8(:,9), wf4(:,24), A(:,50), n3(:,248), t3x32(:,:,50), nhel, den(12))
    call Hcont_QA(nsync, wf8(:,8), wf4(:,24), A(:,51), n3(:,249), t3x32(:,:,51), nhel, den(13))
    call Hcont_QA(nsync, wf4(:,9), wf8(:,39), A(:,52), n3(:,250), t3x32(:,:,52), nhel, den(11))
    call Hcont_QA(nsync, wf4(:,9), wf8(:,40), A(:,53), n3(:,251), t3x32(:,:,53), nhel, den(11))
    call Hcont_QA(nsync, wf4(:,9), wf8(:,41), A(:,54), n3(:,252), t3x32(:,:,54), nhel, den(12))
    call Hcont_QA(nsync, wf4(:,9), wf8(:,42), A(:,55), n3(:,253), t3x32(:,:,55), nhel, den(12))
    call Hcont_QA(nsync, wf4(:,9), wf8(:,43), A(:,56), n3(:,254), t3x32(:,:,56), nhel, den(13))
    call Hcont_QA(nsync, wf4(:,9), wf8(:,44), A(:,57), n3(:,255), t3x32(:,:,57), nhel, den(13))
    call Hcont_QA(nsync, wf4(:,9), wf8(:,45), A(:,58), n3(:,256), t3x32(:,:,58), nhel, den(12))
    call Hcont_QA(nsync, wf4(:,9), wf8(:,46), A(:,59), n3(:,257), t3x32(:,:,59), nhel, den(12))
    call Hcont_QA(nsync, wf4(:,9), wf8(:,47), A(:,60), n3(:,258), t3x32(:,:,60), nhel, den(13))
    call Hcont_QA(nsync, wf8(:,2), wf4(:,26), A(:,61), n3(:,259), t3x32(:,:,61), nhel, den(6))
    call Hcont_QA(nsync, wf8(:,2), wf4(:,28), A(:,62), n3(:,260), t3x32(:,:,62), nhel, den(6))
    call Hcont_QA(nsync, wf8(:,3), wf4(:,26), A(:,63), n3(:,261), t3x32(:,:,63), nhel, den(8))
    call Hcont_QA(nsync, wf8(:,3), wf4(:,28), A(:,64), n3(:,262), t3x32(:,:,64), nhel, den(8))
    call Hcont_QA(nsync, wf8(:,4), wf4(:,26), A(:,65), n3(:,263), t3x32(:,:,65), nhel, den(9))
    call Hcont_QA(nsync, wf8(:,4), wf4(:,28), A(:,66), n3(:,264), t3x32(:,:,66), nhel, den(9))
    call Hcont_QA(nsync, wf8(:,5), wf4(:,26), A(:,67), n3(:,265), t3x32(:,:,67), nhel, den(8))
    call Hcont_QA(nsync, wf8(:,5), wf4(:,28), A(:,68), n3(:,266), t3x32(:,:,68), nhel, den(8))
    call Hcont_QA(nsync, wf8(:,4), wf4(:,28), A(:,69), n3(:,267), t3x32(:,:,69), nhel, den(9))
    call Hcont_VV(nsync, wf8(:,1), wf4(:,29), A(:,70), n3(:,268), t3x32(:,:,70), nhel, den(3))
    call Hcont_SS(nsync, wf4(:,11), wf8(:,48), A(:,71), n3(:,269), t3x32(:,:,71), nhel, den(16))
    call Hcont_SS(nsync, wf4(:,11), wf8(:,49), A(:,72), n3(:,270), t3x32(:,:,72), nhel, den(16))
    call Hcont_VV(nsync, wf4(:,13), wf8(:,50), A(:,73), n3(:,271), t3x32(:,:,73), nhel, den(16))
    call Hcont_VV(nsync, wf4(:,13), wf8(:,50), A(:,74), n3(:,272), t3x32(:,:,74), nhel, den(16))
    call Hcont_QA(nsync, wf8(:,12), wf4(:,22), A(:,75), n3(:,273), t3x32(:,:,75), nhel, den(17))
    call Hcont_QA(nsync, wf8(:,12), wf4(:,24), A(:,76), n3(:,274), t3x32(:,:,76), nhel, den(17))
    call Hcont_QA(nsync, wf8(:,13), wf4(:,22), A(:,77), n3(:,275), t3x32(:,:,77), nhel, den(17))
    call Hcont_QA(nsync, wf8(:,13), wf4(:,24), A(:,78), n3(:,276), t3x32(:,:,78), nhel, den(17))
    call Hcont_QA(nsync, wf4(:,16), wf8(:,51), A(:,79), n3(:,277), t3x32(:,:,79), nhel, den(20))
    call Hcont_QA(nsync, wf4(:,16), wf8(:,52), A(:,80), n3(:,278), t3x32(:,:,80), nhel, den(20))
    call Hcont_QA(nsync, wf4(:,16), wf8(:,53), A(:,81), n3(:,279), t3x32(:,:,81), nhel, den(20))
    call Hcont_QA(nsync, wf4(:,16), wf8(:,53), A(:,82), n3(:,280), t3x32(:,:,82), nhel, den(20))
    call Hcont_QA(nsync, wf8(:,16), wf4(:,26), A(:,83), n3(:,281), t3x32(:,:,83), nhel, den(21))
    call Hcont_QA(nsync, wf8(:,16), wf4(:,28), A(:,84), n3(:,282), t3x32(:,:,84), nhel, den(21))
    call Hcont_QA(nsync, wf8(:,17), wf4(:,26), A(:,85), n3(:,283), t3x32(:,:,85), nhel, den(21))
    call Hcont_QA(nsync, wf8(:,17), wf4(:,28), A(:,86), n3(:,284), t3x32(:,:,86), nhel, den(21))
    call Hcont_SS(nsync, wf8(:,18), wf4(:,30), A(:,87), n3(:,285), t3x32(:,:,87), nhel, den(23))
    call Hcont_SS(nsync, wf8(:,18), wf4(:,31), A(:,88), n3(:,286), t3x32(:,:,88), nhel, den(23))
    call Hcont_SS(nsync, wf8(:,19), wf4(:,32), A(:,89), n3(:,287), t3x32(:,:,89), nhel, den(25))
    call Hcont_SS(nsync, wf8(:,19), wf4(:,33), A(:,90), n3(:,288), t3x32(:,:,90), nhel, den(25))
    call Hcont_VV(nsync, wf8(:,20), wf4(:,34), A(:,91), n3(:,289), t3x32(:,:,91), nhel, den(26))
    call Hcont_VV(nsync, wf8(:,20), wf4(:,35), A(:,92), n3(:,290), t3x32(:,:,92), nhel, den(26))
    call Hcont_VV(nsync, wf8(:,21), wf4(:,36), A(:,93), n3(:,291), t3x32(:,:,93), nhel, den(25))
    call Hcont_VV(nsync, wf8(:,21), wf4(:,37), A(:,94), n3(:,292), t3x32(:,:,94), nhel, den(25))
    call Hcont_VV(nsync, wf8(:,20), wf4(:,29), A(:,95), n3(:,293), t3x32(:,:,95), nhel, den(26))
    call Hcont_SS(nsync, wf8(:,22), wf4(:,30), A(:,96), n3(:,294), t3x32(:,:,96), nhel, den(27))
    call Hcont_SS(nsync, wf8(:,22), wf4(:,31), A(:,97), n3(:,295), t3x32(:,:,97), nhel, den(27))
    call Hcont_SS(nsync, wf8(:,23), wf4(:,32), A(:,98), n3(:,296), t3x32(:,:,98), nhel, den(28))
    call Hcont_SS(nsync, wf8(:,23), wf4(:,33), A(:,99), n3(:,297), t3x32(:,:,99), nhel, den(28))
    call Hcont_VV(nsync, wf8(:,24), wf4(:,34), A(:,100), n3(:,298), t3x32(:,:,100), nhel, den(29))
    call Hcont_VV(nsync, wf8(:,24), wf4(:,35), A(:,101), n3(:,299), t3x32(:,:,101), nhel, den(29))
    call Hcont_VV(nsync, wf8(:,25), wf4(:,36), A(:,102), n3(:,300), t3x32(:,:,102), nhel, den(28))
    call Hcont_VV(nsync, wf8(:,25), wf4(:,37), A(:,103), n3(:,301), t3x32(:,:,103), nhel, den(28))
    call Hcont_VV(nsync, wf8(:,24), wf4(:,29), A(:,104), n3(:,302), t3x32(:,:,104), nhel, den(29))
    call Hcont_QA(nsync, wf4(:,5), wf8(:,54), A(:,105), n3(:,303), t3x32(:,:,105), nhel, den(21))
    call Hcont_QA(nsync, wf4(:,5), wf8(:,55), A(:,106), n3(:,304), t3x32(:,:,106), nhel, den(21))
    call Hcont_QA(nsync, wf4(:,5), wf8(:,56), A(:,107), n3(:,305), t3x32(:,:,107), nhel, den(21))
    call Hcont_QA(nsync, wf4(:,5), wf8(:,56), A(:,108), n3(:,306), t3x32(:,:,108), nhel, den(21))
    call Hcont_QA(nsync, wf8(:,14), wf4(:,39), A(:,109), n3(:,307), t3x32(:,:,109), nhel, den(20))
    call Hcont_QA(nsync, wf8(:,14), wf4(:,41), A(:,110), n3(:,308), t3x32(:,:,110), nhel, den(20))
    call Hcont_QA(nsync, wf8(:,15), wf4(:,39), A(:,111), n3(:,309), t3x32(:,:,111), nhel, den(20))
    call Hcont_QA(nsync, wf8(:,15), wf4(:,41), A(:,112), n3(:,310), t3x32(:,:,112), nhel, den(20))
    call Hcont_SS(nsync, wf4(:,18), wf8(:,57), A(:,113), n3(:,311), t3x32(:,:,113), nhel, den(23))
    call Hcont_SS(nsync, wf4(:,18), wf8(:,58), A(:,114), n3(:,312), t3x32(:,:,114), nhel, den(23))
    call Hcont_SS(nsync, wf4(:,19), wf8(:,59), A(:,115), n3(:,313), t3x32(:,:,115), nhel, den(25))
    call Hcont_SS(nsync, wf4(:,19), wf8(:,60), A(:,116), n3(:,314), t3x32(:,:,116), nhel, den(25))
    call Hcont_VV(nsync, wf4(:,2), wf8(:,61), A(:,117), n3(:,315), t3x32(:,:,117), nhel, den(26))
    call Hcont_VV(nsync, wf4(:,2), wf8(:,62), A(:,118), n3(:,316), t3x32(:,:,118), nhel, den(26))
    call Hcont_VV(nsync, wf4(:,20), wf8(:,63), A(:,119), n3(:,317), t3x32(:,:,119), nhel, den(25))
    call Hcont_VV(nsync, wf4(:,20), wf8(:,64), A(:,120), n3(:,318), t3x32(:,:,120), nhel, den(25))
    call Hcont_VV(nsync, wf4(:,2), wf8(:,65), A(:,121), n3(:,319), t3x32(:,:,121), nhel, den(26))
    call Hcont_SS(nsync, wf4(:,18), wf8(:,66), A(:,122), n3(:,320), t3x32(:,:,122), nhel, den(27))
    call Hcont_SS(nsync, wf4(:,18), wf8(:,67), A(:,123), n3(:,321), t3x32(:,:,123), nhel, den(27))
    call Hcont_SS(nsync, wf4(:,19), wf8(:,68), A(:,124), n3(:,322), t3x32(:,:,124), nhel, den(28))
    call Hcont_SS(nsync, wf4(:,19), wf8(:,69), A(:,125), n3(:,323), t3x32(:,:,125), nhel, den(28))
    call Hcont_VV(nsync, wf4(:,2), wf8(:,70), A(:,126), n3(:,324), t3x32(:,:,126), nhel, den(29))
    call Hcont_VV(nsync, wf4(:,2), wf8(:,71), A(:,127), n3(:,325), t3x32(:,:,127), nhel, den(29))
    call Hcont_VV(nsync, wf4(:,20), wf8(:,72), A(:,128), n3(:,326), t3x32(:,:,128), nhel, den(28))
    call Hcont_VV(nsync, wf4(:,20), wf8(:,73), A(:,129), n3(:,327), t3x32(:,:,129), nhel, den(28))
    call Hcont_VV(nsync, wf4(:,2), wf8(:,71), A(:,130), n3(:,328), t3x32(:,:,130), nhel, den(29))
    call Hcont_SS(nsync, wf8(:,10), wf4(:,42), A(:,131), n3(:,329), t3x32(:,:,131), nhel, den(16))
    call Hcont_SS(nsync, wf8(:,10), wf4(:,43), A(:,132), n3(:,330), t3x32(:,:,132), nhel, den(16))
    call Hcont_VV(nsync, wf8(:,11), wf4(:,44), A(:,133), n3(:,331), t3x32(:,:,133), nhel, den(16))
    call Hcont_VV(nsync, wf8(:,11), wf4(:,44), A(:,134), n3(:,332), t3x32(:,:,134), nhel, den(16))
    call Hcont_QA(nsync, wf4(:,9), wf8(:,74), A(:,135), n3(:,333), t3x32(:,:,135), nhel, den(17))
    call Hcont_QA(nsync, wf4(:,9), wf8(:,75), A(:,136), n3(:,334), t3x32(:,:,136), nhel, den(17))
    call Hcont_QA(nsync, wf4(:,9), wf8(:,76), A(:,137), n3(:,335), t3x32(:,:,137), nhel, den(17))
    call Hcont_QA(nsync, wf4(:,9), wf8(:,76), A(:,138), n3(:,336), t3x32(:,:,138), nhel, den(17))
    call Hcont_QA(nsync, wf4(:,9), wf8(:,77), A(:,139), n3(:,337), t3x32(:,:,139), nhel, den(17))
    call Hcont_QA(nsync, wf4(:,9), wf8(:,78), A(:,140), n3(:,338), t3x32(:,:,140), nhel, den(17))
    call Hcont_QA(nsync, wf4(:,9), wf8(:,79), A(:,141), n3(:,339), t3x32(:,:,141), nhel, den(17))
    call Hcont_QA(nsync, wf4(:,9), wf8(:,79), A(:,142), n3(:,340), t3x32(:,:,142), nhel, den(17))
    call Hcont_SS(nsync, wf4(:,11), wf8(:,80), A(:,143), n3(:,341), t3x32(:,:,143), nhel, den(16))
    call Hcont_SS(nsync, wf4(:,11), wf8(:,81), A(:,144), n3(:,342), t3x32(:,:,144), nhel, den(16))
    call Hcont_VV(nsync, wf4(:,13), wf8(:,82), A(:,145), n3(:,343), t3x32(:,:,145), nhel, den(16))
    call Hcont_VV(nsync, wf4(:,13), wf8(:,83), A(:,146), n3(:,344), t3x32(:,:,146), nhel, den(16))
    call Hcont_SS(nsync, wf4(:,18), wf8(:,84), A(:,147), n3(:,345), t3x32(:,:,147), nhel, den(27))
    call Hcont_SS(nsync, wf4(:,18), wf8(:,85), A(:,148), n3(:,346), t3x32(:,:,148), nhel, den(27))
    call Hcont_SS(nsync, wf4(:,19), wf8(:,86), A(:,149), n3(:,347), t3x32(:,:,149), nhel, den(28))
    call Hcont_SS(nsync, wf4(:,19), wf8(:,87), A(:,150), n3(:,348), t3x32(:,:,150), nhel, den(28))
    call Hcont_VV(nsync, wf4(:,2), wf8(:,88), A(:,151), n3(:,349), t3x32(:,:,151), nhel, den(29))
    call Hcont_VV(nsync, wf4(:,2), wf8(:,89), A(:,152), n3(:,350), t3x32(:,:,152), nhel, den(29))
    call Hcont_VV(nsync, wf4(:,20), wf8(:,90), A(:,153), n3(:,351), t3x32(:,:,153), nhel, den(28))
    call Hcont_VV(nsync, wf4(:,20), wf8(:,91), A(:,154), n3(:,352), t3x32(:,:,154), nhel, den(28))
    call Hcont_VV(nsync, wf4(:,2), wf8(:,92), A(:,155), n3(:,353), t3x32(:,:,155), nhel, den(29))
    call Hcont_SS(nsync, wf4(:,18), wf8(:,93), A(:,156), n3(:,354), t3x32(:,:,156), nhel, den(23))
    call Hcont_SS(nsync, wf4(:,18), wf8(:,94), A(:,157), n3(:,355), t3x32(:,:,157), nhel, den(23))
    call Hcont_SS(nsync, wf4(:,19), wf8(:,95), A(:,158), n3(:,356), t3x32(:,:,158), nhel, den(25))
    call Hcont_SS(nsync, wf4(:,19), wf8(:,96), A(:,159), n3(:,357), t3x32(:,:,159), nhel, den(25))
    call Hcont_VV(nsync, wf4(:,2), wf8(:,97), A(:,160), n3(:,358), t3x32(:,:,160), nhel, den(26))
    call Hcont_VV(nsync, wf4(:,2), wf8(:,98), A(:,161), n3(:,359), t3x32(:,:,161), nhel, den(26))
    call Hcont_VV(nsync, wf4(:,20), wf8(:,99), A(:,162), n3(:,360), t3x32(:,:,162), nhel, den(25))
    call Hcont_VV(nsync, wf4(:,20), wf8(:,100), A(:,163), n3(:,361), t3x32(:,:,163), nhel, den(25))
    call Hcont_VV(nsync, wf4(:,2), wf8(:,98), A(:,164), n3(:,362), t3x32(:,:,164), nhel, den(26))
    call Hcont_QA(nsync, wf4(:,16), wf8(:,101), A(:,165), n3(:,363), t3x32(:,:,165), nhel, den(20))
    call Hcont_QA(nsync, wf4(:,16), wf8(:,102), A(:,166), n3(:,364), t3x32(:,:,166), nhel, den(20))
    call Hcont_QA(nsync, wf4(:,16), wf8(:,103), A(:,167), n3(:,365), t3x32(:,:,167), nhel, den(20))
    call Hcont_QA(nsync, wf4(:,16), wf8(:,103), A(:,168), n3(:,366), t3x32(:,:,168), nhel, den(20))
    call Hcont_QA(nsync, wf4(:,5), wf8(:,104), A(:,169), n3(:,367), t3x32(:,:,169), nhel, den(21))
    call Hcont_QA(nsync, wf4(:,5), wf8(:,105), A(:,170), n3(:,368), t3x32(:,:,170), nhel, den(21))
    call Hcont_QA(nsync, wf4(:,5), wf8(:,106), A(:,171), n3(:,369), t3x32(:,:,171), nhel, den(21))
    call Hcont_QA(nsync, wf4(:,5), wf8(:,106), A(:,172), n3(:,370), t3x32(:,:,172), nhel, den(21))
    call Hcont_VV(nsync, wf4(:,2), wf8(:,107), A(:,173), n3(:,371), t3x32(:,:,173), nhel, den(3))
    call Hcont_QA(nsync, wf4(:,5), wf8(:,108), A(:,174), n3(:,372), t3x32(:,:,174), nhel, den(6))
    call Hcont_QA(nsync, wf4(:,5), wf8(:,109), A(:,175), n3(:,373), t3x32(:,:,175), nhel, den(6))
    call Hcont_QA(nsync, wf4(:,5), wf8(:,110), A(:,176), n3(:,374), t3x32(:,:,176), nhel, den(8))
    call Hcont_QA(nsync, wf4(:,5), wf8(:,111), A(:,177), n3(:,375), t3x32(:,:,177), nhel, den(8))
    call Hcont_QA(nsync, wf4(:,5), wf8(:,112), A(:,178), n3(:,376), t3x32(:,:,178), nhel, den(9))
    call Hcont_QA(nsync, wf4(:,5), wf8(:,113), A(:,179), n3(:,377), t3x32(:,:,179), nhel, den(9))
    call Hcont_QA(nsync, wf4(:,5), wf8(:,114), A(:,180), n3(:,378), t3x32(:,:,180), nhel, den(8))
    call Hcont_QA(nsync, wf4(:,5), wf8(:,115), A(:,181), n3(:,379), t3x32(:,:,181), nhel, den(8))
    call Hcont_QA(nsync, wf4(:,5), wf8(:,116), A(:,182), n3(:,380), t3x32(:,:,182), nhel, den(9))
    call Hcont_QA(nsync, wf4(:,9), wf8(:,117), A(:,183), n3(:,381), t3x32(:,:,183), nhel, den(11))
    call Hcont_QA(nsync, wf4(:,9), wf8(:,118), A(:,184), n3(:,382), t3x32(:,:,184), nhel, den(11))
    call Hcont_QA(nsync, wf4(:,9), wf8(:,119), A(:,185), n3(:,383), t3x32(:,:,185), nhel, den(12))
    call Hcont_QA(nsync, wf4(:,9), wf8(:,120), A(:,186), n3(:,384), t3x32(:,:,186), nhel, den(12))
    call Hcont_QA(nsync, wf4(:,9), wf8(:,121), A(:,187), n3(:,385), t3x32(:,:,187), nhel, den(13))
    call Hcont_QA(nsync, wf4(:,9), wf8(:,122), A(:,188), n3(:,386), t3x32(:,:,188), nhel, den(13))
    call Hcont_QA(nsync, wf4(:,9), wf8(:,123), A(:,189), n3(:,387), t3x32(:,:,189), nhel, den(12))
    call Hcont_QA(nsync, wf4(:,9), wf8(:,124), A(:,190), n3(:,388), t3x32(:,:,190), nhel, den(12))
    call Hcont_QA(nsync, wf4(:,9), wf8(:,125), A(:,191), n3(:,389), t3x32(:,:,191), nhel, den(13))
    call Hcont_SS(nsync, wf8(:,126), wf4(:,61), A(:,192), n3(:,390), t3x32(:,:,192), nhel, den(36))
    call Hcont_SS(nsync, wf8(:,127), wf4(:,62), A(:,193), n3(:,391), t3x32(:,:,193), nhel, den(39))
    call Hcont_VV(nsync, wf8(:,128), wf4(:,63), A(:,194), n3(:,392), t3x32(:,:,194), nhel, den(42))
    call Hcont_VV(nsync, wf8(:,129), wf4(:,64), A(:,195), n3(:,393), t3x32(:,:,195), nhel, den(39))
    call Hcont_SS(nsync, wf8(:,127), wf4(:,65), A(:,196), n3(:,394), t3x32(:,:,196), nhel, den(43))
    call Hcont_SS(nsync, wf8(:,127), wf4(:,66), A(:,197), n3(:,395), t3x32(:,:,197), nhel, den(39))
    call Hcont_VV(nsync, wf8(:,128), wf4(:,67), A(:,198), n3(:,396), t3x32(:,:,198), nhel, den(44))
    call Hcont_VV(nsync, wf8(:,129), wf4(:,68), A(:,199), n3(:,397), t3x32(:,:,199), nhel, den(43))
    call Hcont_VV(nsync, wf8(:,128), wf4(:,69), A(:,200), n3(:,398), t3x32(:,:,200), nhel, den(42))
    call Hcont_VV(nsync, wf8(:,129), wf4(:,70), A(:,201), n3(:,399), t3x32(:,:,201), nhel, den(39))
    call Hcont_QA(nsync, wf4(:,71), wf8(:,130), A(:,202), n3(:,400), t3x32(:,:,202), nhel, den(47))
    call Hcont_QA(nsync, wf8(:,130), wf4(:,72), A(:,203), n3(:,401), t3x32(:,:,203), nhel, den(47))
    call Hcont_QA(nsync, wf4(:,71), wf8(:,131), A(:,204), n3(:,402), t3x32(:,:,204), nhel, den(49))
    call Hcont_QA(nsync, wf4(:,72), wf8(:,131), A(:,205), n3(:,403), t3x32(:,:,205), nhel, den(49))
    call Hcont_QA(nsync, wf4(:,71), wf8(:,132), A(:,206), n3(:,404), t3x32(:,:,206), nhel, den(51))
    call Hcont_QA(nsync, wf4(:,72), wf8(:,132), A(:,207), n3(:,405), t3x32(:,:,207), nhel, den(51))
    call Hcont_QA(nsync, wf4(:,71), wf8(:,133), A(:,208), n3(:,406), t3x32(:,:,208), nhel, den(49))
    call Hcont_QA(nsync, wf4(:,72), wf8(:,133), A(:,209), n3(:,407), t3x32(:,:,209), nhel, den(49))
    call Hcont_QA(nsync, wf4(:,72), wf8(:,132), A(:,210), n3(:,408), t3x32(:,:,210), nhel, den(51))
    call Hcont_SS(nsync, wf4(:,61), wf8(:,134), A(:,211), n3(:,409), t3x32(:,:,211), nhel, den(53))
    call Hcont_SS(nsync, wf4(:,62), wf8(:,135), A(:,212), n3(:,410), t3x32(:,:,212), nhel, den(55))
    call Hcont_VV(nsync, wf4(:,63), wf8(:,136), A(:,213), n3(:,411), t3x32(:,:,213), nhel, den(57))
    call Hcont_VV(nsync, wf4(:,64), wf8(:,137), A(:,214), n3(:,412), t3x32(:,:,214), nhel, den(55))
    call Hcont_SS(nsync, wf4(:,65), wf8(:,135), A(:,215), n3(:,413), t3x32(:,:,215), nhel, den(58))
    call Hcont_SS(nsync, wf4(:,66), wf8(:,135), A(:,216), n3(:,414), t3x32(:,:,216), nhel, den(55))
    call Hcont_VV(nsync, wf4(:,67), wf8(:,136), A(:,217), n3(:,415), t3x32(:,:,217), nhel, den(59))
    call Hcont_VV(nsync, wf4(:,68), wf8(:,137), A(:,218), n3(:,416), t3x32(:,:,218), nhel, den(58))
    call Hcont_VV(nsync, wf4(:,69), wf8(:,136), A(:,219), n3(:,417), t3x32(:,:,219), nhel, den(57))
    call Hcont_VV(nsync, wf4(:,70), wf8(:,137), A(:,220), n3(:,418), t3x32(:,:,220), nhel, den(55))
    call Hcont_QA(nsync, wf4(:,73), wf8(:,138), A(:,221), n3(:,419), t3x32(:,:,221), nhel, den(62))
    call Hcont_QA(nsync, wf8(:,138), wf4(:,74), A(:,222), n3(:,420), t3x32(:,:,222), nhel, den(62))
    call Hcont_QA(nsync, wf4(:,73), wf8(:,139), A(:,223), n3(:,421), t3x32(:,:,223), nhel, den(64))
    call Hcont_QA(nsync, wf4(:,74), wf8(:,139), A(:,224), n3(:,422), t3x32(:,:,224), nhel, den(64))
    call Hcont_QA(nsync, wf4(:,73), wf8(:,140), A(:,225), n3(:,423), t3x32(:,:,225), nhel, den(66))
    call Hcont_QA(nsync, wf4(:,74), wf8(:,140), A(:,226), n3(:,424), t3x32(:,:,226), nhel, den(66))
    call Hcont_QA(nsync, wf4(:,73), wf8(:,141), A(:,227), n3(:,425), t3x32(:,:,227), nhel, den(64))
    call Hcont_QA(nsync, wf4(:,74), wf8(:,141), A(:,228), n3(:,426), t3x32(:,:,228), nhel, den(64))
    call Hcont_QA(nsync, wf4(:,74), wf8(:,140), A(:,229), n3(:,427), t3x32(:,:,229), nhel, den(66))
    call Hcont_QA(nsync, wf4(:,75), wf8(:,143), A(:,230), n3(:,428), t3x32(:,:,230), nhel, den(69))
    call Hcont_QA(nsync, wf8(:,143), wf4(:,76), A(:,231), n3(:,429), t3x32(:,:,231), nhel, den(69))
    call Hcont_QA(nsync, wf4(:,75), wf8(:,145), A(:,232), n3(:,430), t3x32(:,:,232), nhel, den(69))
    call Hcont_QA(nsync, wf4(:,76), wf8(:,145), A(:,233), n3(:,431), t3x32(:,:,233), nhel, den(69))
    call Hcont_SS(nsync, wf8(:,10), wf4(:,77), A(:,234), n3(:,432), t3x32(:,:,234), nhel, den(72))
    call Hcont_VV(nsync, wf8(:,11), wf4(:,78), A(:,235), n3(:,433), t3x32(:,:,235), nhel, den(72))
    call Hcont_SS(nsync, wf8(:,10), wf4(:,79), A(:,236), n3(:,434), t3x32(:,:,236), nhel, den(72))
    call Hcont_VV(nsync, wf8(:,11), wf4(:,80), A(:,237), n3(:,435), t3x32(:,:,237), nhel, den(72))
    call Hcont_SS(nsync, wf4(:,77), wf8(:,146), A(:,238), n3(:,436), t3x32(:,:,238), nhel, den(74))
    call Hcont_SS(nsync, wf4(:,79), wf8(:,146), A(:,239), n3(:,437), t3x32(:,:,239), nhel, den(74))
    call Hcont_VV(nsync, wf4(:,78), wf8(:,147), A(:,240), n3(:,438), t3x32(:,:,240), nhel, den(74))
    call Hcont_VV(nsync, wf4(:,80), wf8(:,147), A(:,241), n3(:,439), t3x32(:,:,241), nhel, den(74))
    call Hcont_QA(nsync, wf4(:,73), wf8(:,148), A(:,242), n3(:,440), t3x32(:,:,242), nhel, den(76))
    call Hcont_QA(nsync, wf4(:,74), wf8(:,148), A(:,243), n3(:,441), t3x32(:,:,243), nhel, den(76))
    call Hcont_QA(nsync, wf4(:,73), wf8(:,149), A(:,244), n3(:,442), t3x32(:,:,244), nhel, den(76))
    call Hcont_QA(nsync, wf4(:,74), wf8(:,149), A(:,245), n3(:,443), t3x32(:,:,245), nhel, den(76))
    call Hcont_SS(nsync, wf8(:,150), wf4(:,81), A(:,246), n3(:,444), t3x32(:,:,246), nhel, den(79))
    call Hcont_VV(nsync, wf8(:,151), wf4(:,82), A(:,247), n3(:,445), t3x32(:,:,247), nhel, den(79))
    call Hcont_SS(nsync, wf8(:,150), wf4(:,83), A(:,248), n3(:,446), t3x32(:,:,248), nhel, den(79))
    call Hcont_VV(nsync, wf8(:,151), wf4(:,84), A(:,249), n3(:,447), t3x32(:,:,249), nhel, den(79))
    call Hcont_QA(nsync, wf4(:,85), wf8(:,152), A(:,250), n3(:,448), t3x32(:,:,250), nhel, den(82))
    call Hcont_QA(nsync, wf8(:,152), wf4(:,86), A(:,251), n3(:,449), t3x32(:,:,251), nhel, den(82))
    call Hcont_QA(nsync, wf4(:,85), wf8(:,153), A(:,252), n3(:,450), t3x32(:,:,252), nhel, den(82))
    call Hcont_QA(nsync, wf4(:,86), wf8(:,153), A(:,253), n3(:,451), t3x32(:,:,253), nhel, den(82))
    call Hcont_SS(nsync, wf4(:,81), wf8(:,154), A(:,254), n3(:,452), t3x32(:,:,254), nhel, den(84))
    call Hcont_VV(nsync, wf4(:,82), wf8(:,155), A(:,255), n3(:,453), t3x32(:,:,255), nhel, den(84))
    call Hcont_SS(nsync, wf4(:,83), wf8(:,154), A(:,256), n3(:,454), t3x32(:,:,256), nhel, den(84))
    call Hcont_VV(nsync, wf4(:,84), wf8(:,155), A(:,257), n3(:,455), t3x32(:,:,257), nhel, den(84))
    call Hcont_QA(nsync, wf4(:,71), wf8(:,156), A(:,258), n3(:,456), t3x32(:,:,258), nhel, den(86))
    call Hcont_QA(nsync, wf4(:,72), wf8(:,156), A(:,259), n3(:,457), t3x32(:,:,259), nhel, den(86))
    call Hcont_QA(nsync, wf4(:,71), wf8(:,157), A(:,260), n3(:,458), t3x32(:,:,260), nhel, den(86))
    call Hcont_QA(nsync, wf4(:,72), wf8(:,157), A(:,261), n3(:,459), t3x32(:,:,261), nhel, den(86))
    call Hcont_QA(nsync, wf4(:,75), wf8(:,159), A(:,262), n3(:,460), t3x32(:,:,262), nhel, den(88))
    call Hcont_QA(nsync, wf4(:,76), wf8(:,159), A(:,263), n3(:,461), t3x32(:,:,263), nhel, den(88))
    call Hcont_QA(nsync, wf4(:,75), wf8(:,161), A(:,264), n3(:,462), t3x32(:,:,264), nhel, den(90))
    call Hcont_QA(nsync, wf4(:,76), wf8(:,161), A(:,265), n3(:,463), t3x32(:,:,265), nhel, den(90))
    call Hcont_QA(nsync, wf4(:,75), wf8(:,163), A(:,266), n3(:,464), t3x32(:,:,266), nhel, den(92))
    call Hcont_QA(nsync, wf4(:,76), wf8(:,163), A(:,267), n3(:,465), t3x32(:,:,267), nhel, den(92))
    call Hcont_QA(nsync, wf4(:,75), wf8(:,165), A(:,268), n3(:,466), t3x32(:,:,268), nhel, den(90))
    call Hcont_QA(nsync, wf4(:,76), wf8(:,165), A(:,269), n3(:,467), t3x32(:,:,269), nhel, den(90))
    call Hcont_QA(nsync, wf4(:,76), wf8(:,163), A(:,270), n3(:,468), t3x32(:,:,270), nhel, den(92))
    call Hcont_SS(nsync, wf8(:,18), wf4(:,87), A(:,271), n3(:,469), t3x32(:,:,271), nhel, den(95))
    call Hcont_SS(nsync, wf8(:,19), wf4(:,88), A(:,272), n3(:,470), t3x32(:,:,272), nhel, den(98))
    call Hcont_SS(nsync, wf8(:,19), wf4(:,89), A(:,273), n3(:,471), t3x32(:,:,273), nhel, den(99))
    call Hcont_SS(nsync, wf8(:,19), wf4(:,90), A(:,274), n3(:,472), t3x32(:,:,274), nhel, den(98))
    call Hcont_VV(nsync, wf8(:,20), wf4(:,91), A(:,275), n3(:,473), t3x32(:,:,275), nhel, den(102))
    call Hcont_VV(nsync, wf8(:,21), wf4(:,92), A(:,276), n3(:,474), t3x32(:,:,276), nhel, den(98))
    call Hcont_VV(nsync, wf8(:,20), wf4(:,93), A(:,277), n3(:,475), t3x32(:,:,277), nhel, den(103))
    call Hcont_VV(nsync, wf8(:,20), wf4(:,94), A(:,278), n3(:,476), t3x32(:,:,278), nhel, den(102))
    call Hcont_VV(nsync, wf8(:,21), wf4(:,95), A(:,279), n3(:,477), t3x32(:,:,279), nhel, den(99))
    call Hcont_VV(nsync, wf8(:,21), wf4(:,96), A(:,280), n3(:,478), t3x32(:,:,280), nhel, den(98))
    call Hcont_QA(nsync, wf4(:,85), wf8(:,167), A(:,281), n3(:,479), t3x32(:,:,281), nhel, den(105))
    call Hcont_QA(nsync, wf4(:,86), wf8(:,167), A(:,282), n3(:,480), t3x32(:,:,282), nhel, den(105))
    call Hcont_QA(nsync, wf4(:,85), wf8(:,169), A(:,283), n3(:,481), t3x32(:,:,283), nhel, den(107))
    call Hcont_QA(nsync, wf4(:,86), wf8(:,169), A(:,284), n3(:,482), t3x32(:,:,284), nhel, den(107))
    call Hcont_QA(nsync, wf4(:,85), wf8(:,171), A(:,285), n3(:,483), t3x32(:,:,285), nhel, den(109))
    call Hcont_QA(nsync, wf4(:,86), wf8(:,171), A(:,286), n3(:,484), t3x32(:,:,286), nhel, den(109))
    call Hcont_QA(nsync, wf4(:,85), wf8(:,173), A(:,287), n3(:,485), t3x32(:,:,287), nhel, den(107))
    call Hcont_QA(nsync, wf4(:,86), wf8(:,173), A(:,288), n3(:,486), t3x32(:,:,288), nhel, den(107))
    call Hcont_QA(nsync, wf4(:,86), wf8(:,171), A(:,289), n3(:,487), t3x32(:,:,289), nhel, den(109))
    call Hcont_SS(nsync, wf8(:,22), wf4(:,87), A(:,290), n3(:,488), t3x32(:,:,290), nhel, den(111))
    call Hcont_SS(nsync, wf8(:,23), wf4(:,88), A(:,291), n3(:,489), t3x32(:,:,291), nhel, den(113))
    call Hcont_SS(nsync, wf8(:,23), wf4(:,89), A(:,292), n3(:,490), t3x32(:,:,292), nhel, den(114))
    call Hcont_SS(nsync, wf8(:,23), wf4(:,90), A(:,293), n3(:,491), t3x32(:,:,293), nhel, den(113))
    call Hcont_VV(nsync, wf8(:,24), wf4(:,91), A(:,294), n3(:,492), t3x32(:,:,294), nhel, den(116))
    call Hcont_VV(nsync, wf8(:,25), wf4(:,92), A(:,295), n3(:,493), t3x32(:,:,295), nhel, den(113))
    call Hcont_VV(nsync, wf8(:,24), wf4(:,93), A(:,296), n3(:,494), t3x32(:,:,296), nhel, den(117))
    call Hcont_VV(nsync, wf8(:,24), wf4(:,94), A(:,297), n3(:,495), t3x32(:,:,297), nhel, den(116))
    call Hcont_VV(nsync, wf8(:,25), wf4(:,95), A(:,298), n3(:,496), t3x32(:,:,298), nhel, den(114))
    call Hcont_VV(nsync, wf8(:,25), wf4(:,96), A(:,299), n3(:,497), t3x32(:,:,299), nhel, den(113))

end subroutine diagrams


elemental function diagmap(j, n)
  implicit none
  integer, intent(in) :: j, n
  complex(REALKIND) :: diagmap
  diagmap = A(j,n)%j
end function diagmap

function diagsum(j, pos, neg)
  implicit none
  integer, intent(in) :: j, pos(:), neg(:)
  complex(REALKIND) :: diagsum
  diagsum = sum(diagmap(j, pos)) - sum(diagmap(j, neg))
end function diagsum

subroutine colourvectors(A, j, M1, M2)
  implicit none
  type(Hpolcont) :: A(:,:)
  integer, intent(in) :: j
  type(Hpolcont), intent(out) :: M1(8), M2(8) ! M1helarray(8,32)
  integer :: empty(0), i

  M1(1)%j = (-A(j,22)%j-A(j,27)%j)*f(1)+(A(j,23)%j+A(j,28)%j)*f(2)+(-A(j,20)%j-A(j,21)%j-A(j,25)%j-A(j,26)%j)*f(34)
  M1(2)%j = ((-A(j,24)%j-A(j,29)%j)*f(7))/6._/**/REALKIND
  M1(3)%j = (-A(j,17)%j-A(j,19)%j)*f(21)+(-A(j,16)%j-A(j,18)%j)*f(29)
  M1(4)%j = ((A(j,6)%j+A(j,29)%j)*f(7))/2._/**/REALKIND+(CI*A(j,1)%j*f(8))/2._/**/REALKIND
  M1(5)%j = (-A(j,13)%j-A(j,15)%j)*f(21)+(-A(j,12)%j-A(j,14)%j)*f(29)
  M1(6)%j = ((A(j,11)%j+A(j,24)%j)*f(7))/2._/**/REALKIND-(CI*A(j,1)%j*f(8))/2._/**/REALKIND
  M1(7)%j = (-A(j,4)%j-A(j,9)%j)*f(1)+(A(j,5)%j+A(j,10)%j)*f(2)+(-A(j,2)%j-A(j,3)%j-A(j,7)%j-A(j,8)%j)*f(34)
  M1(8)%j = ((-A(j,6)%j-A(j,11)%j)*f(7))/6._/**/REALKIND

  M2(1)%j = (A(j,266)%j+A(j,285)%j)*f(9)+(-A(j,268)%j-A(j,287)%j)*f(10)+((-A(j,95)%j-A(j,104)%j-A(j,121)%j-A(j,130)%j-A(j,155)%j &
       -A(j,164)%j+A(j,270)%j+A(j,289)%j)*f(10))/6._/**/REALKIND+(-A(j,126)%j-A(j,160)%j)*f(14)+(A(j,128)%j+A(j,162)%j)*f(15)+( &
       -A(j,91)%j-A(j,100)%j)*f(16)+(A(j,93)%j+A(j,102)%j)*f(17)+(-A(j,117)%j-A(j,151)%j)*f(18)+(A(j,119)%j+A(j,153)%j)*f(19) &
       -A(j,33)%j*f(20)+(A(j,262)%j+A(j,264)%j+A(j,281)%j+A(j,283)%j)*f(36)+(-A(j,122)%j-A(j,124)%j-A(j,156)%j-A(j,158)%j)*f(38)+( &
       -A(j,87)%j-A(j,89)%j-A(j,96)%j-A(j,98)%j)*f(39)+(-A(j,113)%j-A(j,115)%j-A(j,147)%j-A(j,149)%j)*f(40)-A(j,31)%j*f(46)
  M2(2)%j = (-A(j,127)%j-A(j,161)%j+A(j,267)%j+A(j,277)%j+A(j,286)%j+A(j,296)%j)*f(3)+(A(j,118)%j+A(j,152)%j-A(j,279)%j &
       -A(j,298)%j)*f(4)+(-A(j,92)%j-A(j,101)%j+A(j,278)%j+A(j,297)%j)*f(5)+(A(j,94)%j+A(j,103)%j+A(j,120)%j+A(j,129)%j+A(j,154)%j &
       +A(j,163)%j-A(j,269)%j-A(j,280)%j-A(j,288)%j-A(j,299)%j)*f(6)+(-A(j,123)%j-A(j,125)%j-A(j,157)%j-A(j,159)%j+A(j,263)%j &
       +A(j,265)%j+A(j,271)%j+A(j,272)%j+A(j,282)%j+A(j,284)%j+A(j,290)%j+A(j,291)%j)*f(35)+(A(j,88)%j+A(j,97)%j+A(j,114)%j &
       +A(j,148)%j)*f(42)+(-A(j,90)%j-A(j,99)%j+A(j,116)%j+A(j,150)%j)*f(43)+(-A(j,275)%j-A(j,294)%j)*f(44)+(A(j,276)%j &
       +A(j,295)%j)*f(45)+(-A(j,273)%j-A(j,292)%j)*f(47)+(-A(j,274)%j-A(j,293)%j)*f(48)
  M2(3)%j = (-A(j,86)%j-A(j,112)%j+A(j,249)%j+A(j,253)%j+A(j,257)%j+A(j,261)%j)*f(22)+(-A(j,168)%j-A(j,172)%j)*f(23)+(-A(j,82)%j &
       -A(j,108)%j)*f(24)+(-A(j,84)%j-A(j,110)%j+A(j,246)%j+A(j,251)%j+A(j,254)%j+A(j,259)%j)*f(30)+(-A(j,247)%j+A(j,248)%j &
       -A(j,255)%j+A(j,256)%j)*f(41)+(-A(j,80)%j-A(j,106)%j+A(j,166)%j+A(j,170)%j)*f(50)
  M2(4)%j = ((A(j,42)%j+A(j,69)%j+A(j,104)%j+A(j,130)%j+A(j,155)%j+A(j,182)%j-A(j,210)%j-A(j,289)%j)*f(10))/2._/**/REALKIND &
       +(CI*(A(j,70)%j+A(j,173)%j)*f(11))/2._/**/REALKIND+(A(j,252)%j+A(j,260)%j)*f(25)-A(j,85)%j*f(26)-A(j,111)%j*f(27)+( &
       -A(j,81)%j-A(j,107)%j-A(j,167)%j-A(j,171)%j)*f(28)+(-A(j,79)%j-A(j,105)%j-A(j,165)%j-A(j,169)%j+A(j,250)%j &
       +A(j,258)%j)*f(31)-A(j,83)%j*f(32)-A(j,109)%j*f(33)
  M2(5)%j = (-A(j,78)%j-A(j,146)%j+A(j,233)%j+A(j,237)%j+A(j,241)%j+A(j,245)%j)*f(22)+(-A(j,74)%j-A(j,142)%j)*f(23)+(-A(j,134)%j &
       -A(j,138)%j)*f(24)+(-A(j,76)%j-A(j,144)%j+A(j,231)%j+A(j,234)%j+A(j,238)%j+A(j,243)%j)*f(30)+(A(j,235)%j-A(j,236)%j &
       -A(j,239)%j+A(j,240)%j)*f(41)+(A(j,72)%j-A(j,132)%j-A(j,136)%j+A(j,140)%j)*f(50)
  M2(6)%j = ((A(j,51)%j+A(j,60)%j+A(j,95)%j+A(j,121)%j+A(j,164)%j+A(j,191)%j-A(j,229)%j-A(j,270)%j)*f(10))/2._/**/REALKIND+(CI*( &
       -A(j,70)%j-A(j,173)%j)*f(11))/2._/**/REALKIND+(A(j,232)%j+A(j,244)%j)*f(25)-A(j,77)%j*f(26)-A(j,145)%j*f(27)+(-A(j,73)%j &
       -A(j,133)%j-A(j,137)%j-A(j,141)%j)*f(28)+(-A(j,71)%j-A(j,131)%j-A(j,135)%j-A(j,139)%j+A(j,230)%j+A(j,242)%j)*f(31) &
       -A(j,75)%j*f(32)-A(j,143)%j*f(33)
  M2(7)%j = (-A(j,48)%j-A(j,66)%j+A(j,198)%j+A(j,207)%j+A(j,217)%j+A(j,226)%j)*f(3)+(A(j,179)%j+A(j,188)%j-A(j,200)%j &
       -A(j,219)%j)*f(4)+(-A(j,39)%j-A(j,57)%j+A(j,199)%j+A(j,218)%j)*f(5)+(A(j,41)%j+A(j,50)%j+A(j,59)%j+A(j,68)%j+A(j,181)%j &
       +A(j,190)%j-A(j,201)%j-A(j,209)%j-A(j,220)%j-A(j,228)%j)*f(6)+(-A(j,44)%j-A(j,46)%j-A(j,62)%j-A(j,64)%j+A(j,192)%j &
       +A(j,193)%j+A(j,203)%j+A(j,205)%j+A(j,211)%j+A(j,212)%j+A(j,222)%j+A(j,224)%j)*f(35)+(A(j,35)%j+A(j,53)%j+A(j,175)%j &
       +A(j,184)%j)*f(42)+(-A(j,37)%j-A(j,55)%j+A(j,177)%j+A(j,186)%j)*f(43)+(-A(j,196)%j-A(j,215)%j)*f(44)+(A(j,197)%j &
       +A(j,216)%j)*f(45)+(-A(j,194)%j-A(j,213)%j)*f(47)+(-A(j,195)%j-A(j,214)%j)*f(48)
  M2(8)%j = (A(j,206)%j+A(j,225)%j)*f(9)+(-A(j,208)%j-A(j,227)%j)*f(10)+((-A(j,42)%j-A(j,51)%j-A(j,60)%j-A(j,69)%j-A(j,182)%j &
       -A(j,191)%j+A(j,210)%j+A(j,229)%j)*f(10))/6._/**/REALKIND+(-A(j,47)%j-A(j,65)%j)*f(12)+(A(j,49)%j+A(j,67)%j)*f(13)+( &
       -A(j,38)%j-A(j,56)%j)*f(16)+(A(j,40)%j+A(j,58)%j)*f(17)+(-A(j,178)%j-A(j,187)%j)*f(18)+(A(j,180)%j+A(j,189)%j)*f(19) &
       -A(j,32)%j*f(20)+(A(j,202)%j+A(j,204)%j+A(j,221)%j+A(j,223)%j)*f(36)+(-A(j,43)%j-A(j,45)%j-A(j,61)%j-A(j,63)%j)*f(37)+( &
       -A(j,34)%j-A(j,36)%j-A(j,52)%j-A(j,54)%j)*f(39)+(-A(j,174)%j-A(j,176)%j-A(j,183)%j-A(j,185)%j)*f(40)-A(j,30)%j*f(49)


  M1(:)%hf = Hel(j)
  M2(:)%hf = Hel(j)

  !M(i) corresponds to \Gamma_{i} in Fabios thesis

end subroutine colourvectors


! **********************************************************************
subroutine colint(M, M2colint)
! M(i)   = <M|Ci> colour component of matrix element
! COLINT = <M|M>
!        = Sum_{i,j} <M|Ci> * <Ci|Cj> * <Cj|M>
!        = colour-summed squared matrix element
! K2(i,j) = <Ci|Cj>
! **********************************************************************
  use ol_colourmatrix_ppttj_ew_ttxbbxg_3_/**/REALKIND, only: K1
  implicit none

  complex(REALKIND), intent(in)  :: M(8)
  real(REALKIND),    intent(out) :: M2colint
  integer :: i, j

  M2colint = 0

    do i = 1, 8
      do j = 1, 8
        M2colint = M2colint + real(conjg(M(i))*K1(i,j)*M(j))
      end do
    end do

end subroutine colint

! **********************************************************************
subroutine colint_ct(M, Mct, M2colint_ct, l)
! M(i)   = <M|Ci> colour component of matrix element
! COLINT = <M|M>
!        = Sum_{i,j} <M|Ci> * <Ci|Cj> * <Cj|M>
!        = colour-summed squared matrix element
! K2(i,j) = <Ci|Cj>
! **********************************************************************
  use ol_colourmatrix_ppttj_ew_ttxbbxg_3_/**/REALKIND, only: K2
  implicit none
  complex(REALKIND), intent(in)  :: M(8), Mct(8)
  real(REALKIND),    intent(out) :: M2colint_ct
  integer, intent(in) :: l
  integer ::  i, j

  M2colint_ct = 0

  do i = 1, 8
    do j = 1, 8
      M2colint_ct = M2colint_ct + real(conjg(M(i))*K2(i+8*l,j)*Mct(j))
    end do
  end do

end subroutine colint_ct

! **********************************************************************
subroutine colint_IR(M, M2IRadd)
! M(i)   = <M|Ci> colour component of matrix element
! K1(i,j) = .....
! **********************************************************************
  use ol_colourmatrix_ppttj_ew_ttxbbxg_3_/**/REALKIND, only: K1
  implicit none

  complex(REALKIND), intent(in)  :: M(8)
  real(REALKIND),    intent(out) :: M2IRadd(16)
  integer ::  i, j, k, colmatpos

  M2IRadd = 0

  do k = 1, 17-1
    colmatpos = 8*k
    do i = 1, 8
      do j = 1, 8
        M2IRadd(k) = M2IRadd(k) + real(conjg(M(i))*K1(i+colmatpos,j)*M(j))
      end do
    end do
  end do

end subroutine colint_IR

! **********************************************************************
subroutine colintmunu(M1, M2, M2colint)
! M1(i)    = <M1|Ci> colour component of matrix element
! M2(i)    = <M2|Ci> colour component of matrix element
! M2colint = <M1|M2>
!          = Sum_{i,j} <M1|Ci> * <Ci|Cj> * <Cj|M2>
!          = colour-summed squared matrix element
! K2(i,j) = <Ci|Cj>
! **********************************************************************
  use ol_colourmatrix_ppttj_ew_ttxbbxg_3_/**/REALKIND, only: K2
  implicit none

  complex(REALKIND), intent(in)  :: M1(8)
  complex(REALKIND), intent(in)  :: M2(8)
  complex(REALKIND),    intent(out) :: M2colint
  integer :: i, j

  M2colint = 0

  do i = 1, 8
    do j = 1, 8
      M2colint = M2colint + M1(i)*K2(i,j)*conjg(M2(j))
    end do
  end do

end subroutine colintmunu





! **********************************************************************
subroutine colborninterf(M, M0_col, l)
! M(i)         = <M|Ci> colour component of matrix element
! M0_col(i)    = <M2|Ci> colour component of matrix element,
!                see \tilde{M}_{j} in Fabios thesis
! M2colint = Sum_{i} <M1|Ci> * <Ci|Cj>
!          = colour-summed squared matrix element
! KL(i,j) = <Ci|Cj> with elements Cj of 1-loop colour basis
! **********************************************************************
  use ol_colourmatrix_ppttj_ew_ttxbbxg_3_/**/REALKIND, only: KL
  implicit none

  type(Hpolcont), intent(in)  :: M(8)
  type(Hpolcont), intent(out)  :: M0_col(8)
  integer, intent(in) :: l
  integer :: i, j

  do j = 1, 8 !size(KL(1,:))
    M0_col(j)%j = 0
    M0_col(j)%hf = M(1)%hf
    do i = 1, 8 !size(KL(:,1))
      M0_col(j)%j = M0_col(j)%j  + conjg(M(i)%j)*KL(i+8*l,j)
    end do
  end do

end subroutine colborninterf

end subroutine amp2

end module ol_loop_ppttj_ew_ttxbbxg_3_/**/REALKIND
