
module ol_colourmatrix_ppttj_ew_ttxaaa_2_/**/REALKIND
  use KIND_TYPES, only: REALKIND
  implicit none
  logical, save           :: colmat_not_initialised = .true.
  complex(REALKIND), save :: K1(17,1), K2(1,1), KL(1,1), Cas(5) = 0
  contains
  subroutine colourmatrix_init
    use ol_parameters_decl_/**/REALKIND, only: CI
    implicit none
    integer :: k, co
    colmat_not_initialised = .false.
    ! colour matrix

  K1( 1,:) = [ 3]
  K1( 2,:) = [ 0]
  K1( 3,:) = [ 0]
  K1( 4,:) = [ 0]
  K1( 5,:) = [ 0]
  K1( 6,:) = [ 0]
  K1( 7,:) = [ 0]
  K1( 8,:) = [ 0]
  K1( 9,:) = [ 0]
  K1(10,:) = [ 0]
  K1(11,:) = [ 0]
  K1(12,:) = [ 0]
  K1(13,:) = [ 0]
  K1(14,:) = [ 0]
  K1(15,:) = [ 0]
  K1(16,:) = [ 0]
  K1(17,:) = [ 3]

  K2(1,:) = [ 3]

  KL(1,:) = [ 3]

#if 1 > 0
    co = 0
    do k = 1, 5
      co = co + k
      Cas(k) = K1(1+1*co,1)/K1(1,1)
    end do
#endif
  end subroutine colourmatrix_init
end module ol_colourmatrix_ppttj_ew_ttxaaa_2_/**/REALKIND



module ol_forced_parameters_ppttj_ew_ttxaaa_2_/**/REALKIND
  implicit none
  contains
  subroutine check_forced_parameters
    use ol_parameters_decl_/**/REALKIND
    use ol_loop_parameters_decl_/**/REALKIND
#ifndef PRECISION_dp
    use ol_loop_parameters_decl_/**/DREALKIND, only: LeadingColour, nc, nf, CKMORDER
#endif
    implicit none
    logical, save :: checks_not_written = .true.

    if (checks_not_written) then
    ! e.g.
    ! if (ME /= 0) write(*,101) 'ME = 0'
  if (CKMORDER /= 0) write(*,101) 'CKMORDER = 0'
  if (nc /= 3) write(*,101) 'nc = 3'
  if (nf /= 6) write(*,101) 'nf = 6'
  if (MU /= 0) write(*,101) 'MU = 0'
  if (MD /= 0) write(*,101) 'MD = 0'
  if (MS /= 0) write(*,101) 'MS = 0'
  if (MC /= 0) write(*,101) 'MC = 0'
  if (LeadingColour /= 0) write(*,101) 'LeadingColour = 0'
  if (wMT /= 0) write(*,101) 'wMT = 0'
  if (wMT /= 0) write(*,101) 'wMT = 0'


    checks_not_written = .false.
    end if

    101 format('[OpenLoops] === WARNING ===',/,'[OpenLoops] code was generated with ',A,/,'[OpenLoops] ===============')
  end subroutine check_forced_parameters
end module ol_forced_parameters_ppttj_ew_ttxaaa_2_/**/REALKIND


! **********************************************************************
module ol_loop_storage_ppttj_ew_ttxaaa_2_/**/REALKIND
! **********************************************************************
  use KIND_TYPES, only: REALKIND, intkind1, intkind2
  use ol_data_types_/**/REALKIND, only: wfun, Hpolcont

#ifdef PRECISION_dp
  integer(intkind1), save :: ntryL = 1
  integer(intkind1), save :: p_switch = 0 ! switch for dp or qp. Used for memory allocation of the OL types
  ! the following are flags for memory allocation of the hol coefficients in dp or qp
  logical, save :: dp_not_alloc = .TRUE., qp_not_alloc = .TRUE.
  integer, save :: n_merge_steps  ! total number of merging steps
  integer, save :: n_merge_mism   ! number of merging mismatches
  integer, save :: merge_step = 1 ! current merging step
  integer(intkind2), save, allocatable :: merge_tables(:,:,:) ! merging tables
  integer(intkind2), save, allocatable :: merge_mism(:)       ! array of merging mismatches
  integer(intkind2), save, allocatable :: merge_hels(:)       ! array with relevant helicities for a merging step
  logical, save :: merge_tables_on = .false.
  integer(intkind2), parameter :: nheltot = 32 ! number of helicity configurations
  integer(intkind2), save :: nhel = 32 ! number of non-vanishing helicity configurations (adapted at runtime)
  integer(intkind2), save :: Hel(32) ! physical helicity states
#endif

  complex(REALKIND), save :: den(81)

  ! external wave functions ex1(h1),... for h<n> helicities
  type(wfun) :: ex1(2), ex2(2), ex3(2), ex4(2), ex5(2)

  ! wf<h>(h,n) n wave functions with h helicity configurations
  type(wfun) :: wf4(4,37), wf8(8,61), wf32(32,44)

  ! diagram prefactors
  integer,           save :: fac_status_loop1 = -1, fac_status_loop2 = -1
  complex(REALKIND), save :: f(95), c(89)

  !Vector in helicity and colour space for Born-Loop interference
  type(Hpolcont),   save :: M0_col1_helarray(1,32), M0M1_hel_cc(1,32,16)
  complex(REALKIND), save :: M2ctcc(16)

end module ol_loop_storage_ppttj_ew_ttxaaa_2_/**/REALKIND






! **********************************************************************
module ol_loop_ppttj_ew_ttxaaa_2_/**/REALKIND
! **********************************************************************
  use KIND_TYPES, only: REALKIND, DREALKIND, intkind1, intkind2
  use ol_data_types_/**/REALKIND, only: wfun, Hpolcont
  use ol_loop_storage_ppttj_ew_ttxaaa_2_/**/REALKIND
  implicit none

!*********************************************************************************
  contains

! **********************************************************************
subroutine fac_init_loop()
! Writes diagram prefactors to 'f', rsp. 'c'
! **********************************************************************
  use ol_parameters_decl_/**/REALKIND
  use ol_loop_parameters_decl_/**/REALKIND
  use ol_init, only: set_parameter, tree_parameters_flush, parameters_flush
#ifndef PRECISION_dp
  use ol_loop_parameters_decl_/**/DREALKIND, only: SwF, SwB
!  use ol_loop_parameters_decl_/**/DREALKIND, only: DOI
#endif
  implicit none
  call set_parameter("ew_renorm", 1)
  if (parameters_status == 0) call tree_parameters_flush()
  if (loop_parameters_status == 0) call parameters_flush()
  fac_status_loop1 = parameters_status
  fac_status_loop2 = loop_parameters_status
  ! factors of the diagrams
    f( 1) = (8*CI*eQED**3)/27._/**/REALKIND
    f( 2) = (8*CI*countertermnorm*eQED**5)/27._/**/REALKIND
    f( 3) = (4*CI*countertermnorm*eQED**5)/9._/**/REALKIND
    f( 4) = (2*CI*countertermnorm*eQED**5*EWctR2AAAA)/3._/**/REALKIND
    f( 5) = CI*countertermnorm*eQED**5*EWctR2AAAZ
    f( 6) = (CI*countertermnorm*eQED**5*EWctHAA*MT)/(3._/**/REALKIND*MW*sw)
    f( 7) = (32*eQED**5*integralnorm*SwB)/243._/**/REALKIND
    f( 8) = (8*eQED**5*integralnorm*SwB)/27._/**/REALKIND
    f( 9) = (4*eQED**5*integralnorm*SwB)/9._/**/REALKIND
    f(10) = (2*eQED**5*integralnorm*SwB)/3._/**/REALKIND
    f(11) = (8*eQED**5*integralnorm*SwB)/9._/**/REALKIND
    f(12) = (4*eQED**5*integralnorm*SwB)/3._/**/REALKIND
    f(13) = (8*eQED**5*integralnorm*SwB)/3._/**/REALKIND
    f(14) = (4*eQED**5*integralnorm*MW**2*SwB)/9._/**/REALKIND
    f(15) = (2*eQED**5*integralnorm*MW**2*SwB)/3._/**/REALKIND
    f(16) = (4*eQED**5*integralnorm*MW**2*SwB)/3._/**/REALKIND
    f(17) = (2*eQED**5*integralnorm*MW**4*SwB)/3._/**/REALKIND
    f(18) = (eQED**5*integralnorm*SwB)/(sw**2*54._/**/REALKIND)
    f(19) = (eQED**5*integralnorm*SwB)/(sw**2*27._/**/REALKIND)
    f(20) = (eQED**5*integralnorm*SwB)/(sw**2*18._/**/REALKIND)
    f(21) = (2*eQED**5*integralnorm*SwB)/(sw**2*27._/**/REALKIND)
    f(22) = (eQED**5*integralnorm*SwB)/(sw**2*9._/**/REALKIND)
    f(23) = (4*eQED**5*integralnorm*SwB)/(sw**2*27._/**/REALKIND)
    f(24) = (eQED**5*integralnorm*SwB)/(sw**2*6._/**/REALKIND)
    f(25) = (2*eQED**5*integralnorm*SwB)/(sw**2*9._/**/REALKIND)
    f(26) = (eQED**5*integralnorm*SwB)/(sw**2*3._/**/REALKIND)
    f(27) = (eQED**5*integralnorm*SwB)/(sw**2*2._/**/REALKIND)
    f(28) = (eQED**5*integralnorm*SwB)/sw**2
    f(29) = (eQED**5*integralnorm*MT*SwB)/(sw**2*6._/**/REALKIND)
    f(30) = (eQED**5*integralnorm*MT*SwB)/(sw**2*4._/**/REALKIND)
    f(31) = (eQED**5*integralnorm*MT*SwB)/(sw**2*3._/**/REALKIND)
    f(32) = (eQED**5*integralnorm*MT*SwB)/(sw**2*2._/**/REALKIND)
    f(33) = (eQED**5*integralnorm*MH**2*MT*SwB)/(sw**2*6._/**/REALKIND)
    f(34) = (eQED**5*integralnorm*MH**2*MT*SwB)/(sw**2*4._/**/REALKIND)
    f(35) = (eQED**5*integralnorm*SwB)/(MW**2*sw**2*54._/**/REALKIND)
    f(36) = (eQED**5*integralnorm*SwB)/(MW**2*sw**2*27._/**/REALKIND)
    f(37) = (eQED**5*integralnorm*SwB)/(MW**2*sw**2*18._/**/REALKIND)
    f(38) = (2*eQED**5*integralnorm*SwB)/(MW**2*sw**2*27._/**/REALKIND)
    f(39) = (eQED**5*integralnorm*SwB)/(MW**2*sw**2*9._/**/REALKIND)
    f(40) = (4*eQED**5*integralnorm*SwB)/(MW**2*sw**2*27._/**/REALKIND)
    f(41) = (eQED**5*integralnorm*SwB)/(MW**2*sw**2*6._/**/REALKIND)
    f(42) = (2*eQED**5*integralnorm*SwB)/(MW**2*sw**2*9._/**/REALKIND)
    f(43) = (eQED**5*integralnorm*SwB)/(MW**2*sw**2*3._/**/REALKIND)
    f(44) = (eQED**5*integralnorm*SwB)/(MW**2*sw**2*2._/**/REALKIND)
    f(45) = (2*eQED**5*integralnorm*SwB)/(MW**2*sw**2*3._/**/REALKIND)
    f(46) = (eQED**5*integralnorm*SwB)/(MW**2*sw**2)
    f(47) = (eQED**5*integralnorm*MH**2*MT*SwB)/(MW**2*sw**2*6._/**/REALKIND)
    f(48) = (eQED**5*integralnorm*MH**2*MT*SwB)/(MW**2*sw**2*4._/**/REALKIND)
    f(49) = (eQED**5*integralnorm*MH**2*MT*SwB)/(MW**2*sw**2*3._/**/REALKIND)
    f(50) = (eQED**5*integralnorm*MH**2*MT*SwB)/(MW**2*sw**2*2._/**/REALKIND)
    f(51) = (2*eQED**5*integralnorm*MT**2*SwB)/(MW**2*sw**2*27._/**/REALKIND)
    f(52) = (eQED**5*integralnorm*MW**2*SwB)/(sw**2*6._/**/REALKIND)
    f(53) = (eQED**5*integralnorm*MW**2*SwB)/(sw**2*3._/**/REALKIND)
    f(54) = (eQED**5*integralnorm*MW**2*SwB)/(sw**2*2._/**/REALKIND)
    f(55) = (eQED**5*integralnorm*MT*MW**2*SwB)/(sw**2*4._/**/REALKIND)
    f(56) = (eQED**5*integralnorm*MT*MW**2*SwB)/(sw**2*3._/**/REALKIND)
    f(57) = (eQED**5*integralnorm*MT*MW**2*SwB)/(sw**2*2._/**/REALKIND)
    f(58) = (2*cw*eQED**5*integralnorm*SwB)/(sw*3._/**/REALKIND)
    f(59) = (cw*eQED**5*integralnorm*SwB)/sw
    f(60) = (2*cw*eQED**5*integralnorm*MW**2*SwB)/(sw*3._/**/REALKIND)
    f(61) = (cw*eQED**5*integralnorm*MW**2*SwB)/sw
    f(62) = (2*eQED**5*integralnorm*MW**2*sw*SwB)/(cw*3._/**/REALKIND)
    f(63) = (eQED**5*integralnorm*MW**2*sw*SwB)/cw
    f(64) = (2*eQED**5*integralnorm*MW**2*sw*SwB)/cw
    f(65) = (eQED**5*integralnorm*MW**4*sw*SwB)/cw
    f(66) = -((eQED**5*integralnorm*(cw - sw)*(cw + sw)*SwB)/(cw*sw*3._/**/REALKIND))
    f(67) = -((eQED**5*integralnorm*(cw - sw)*(cw + sw)*SwB)/(cw*sw*2._/**/REALKIND))
    f(68) = (-2*eQED**5*integralnorm*(cw - sw)*(cw + sw)*SwB)/(cw*sw*3._/**/REALKIND)
    f(69) = -((eQED**5*integralnorm*(cw - sw)*(cw + sw)*SwB)/(cw*sw))
    f(70) = (-2*eQED**5*integralnorm*(cw - sw)*(cw + sw)*SwB)/(cw*sw)
    f(71) = -((eQED**5*integralnorm*MW**2*(cw - sw)*(cw + sw)*SwB)/(cw*sw*3._/**/REALKIND))
    f(72) = -((eQED**5*integralnorm*MW**2*(cw - sw)*(cw + sw)*SwB)/(cw*sw*2._/**/REALKIND))
    f(73) = -((eQED**5*integralnorm*MW**2*(cw - sw)*(cw + sw)*SwB)/(cw*sw))
    f(74) = (2*eQED**5*integralnorm*SwF)/243._/**/REALKIND
    f(75) = (4*eQED**5*integralnorm*SwF)/243._/**/REALKIND
    f(76) = (8*eQED**5*integralnorm*SwF)/243._/**/REALKIND
    f(77) = (eQED**5*integralnorm*SwF)/27._/**/REALKIND
    f(78) = (2*eQED**5*integralnorm*SwF)/27._/**/REALKIND
    f(79) = (32*eQED**5*integralnorm*SwF)/243._/**/REALKIND
    f(80) = (4*eQED**5*integralnorm*SwF)/27._/**/REALKIND
    f(81) = (64*eQED**5*integralnorm*SwF)/243._/**/REALKIND
    f(82) = (8*eQED**5*integralnorm*SwF)/27._/**/REALKIND
    f(83) = (4*eQED**5*integralnorm*SwF)/9._/**/REALKIND
    f(84) = (16*eQED**5*integralnorm*SwF)/27._/**/REALKIND
    f(85) = (2*eQED**5*integralnorm*SwF)/3._/**/REALKIND
    f(86) = eQED**5*integralnorm*SwF
    f(87) = (eQED**5*integralnorm*MB*MT*SwF)/(MW**2*sw**2*108._/**/REALKIND)
    f(88) = (eQED**5*integralnorm*MB*MT*SwF)/(MW**2*sw**2*54._/**/REALKIND)
    f(89) = (eQED**5*integralnorm*ME*MT*SwF)/(MW**2*sw**2*6._/**/REALKIND)
    f(90) = (eQED**5*integralnorm*ME*MT*SwF)/(MW**2*sw**2*4._/**/REALKIND)
    f(91) = (eQED**5*integralnorm*ML*MT*SwF)/(MW**2*sw**2*6._/**/REALKIND)
    f(92) = (eQED**5*integralnorm*ML*MT*SwF)/(MW**2*sw**2*4._/**/REALKIND)
    f(93) = (eQED**5*integralnorm*MM*MT*SwF)/(MW**2*sw**2*6._/**/REALKIND)
    f(94) = (eQED**5*integralnorm*MM*MT*SwF)/(MW**2*sw**2*4._/**/REALKIND)
    f(95) = (2*eQED**5*integralnorm*MT**2*SwF)/(MW**2*sw**2*27._/**/REALKIND)

  c = [ f(7), f(8), f(9), f(10), f(11), f(12), f(13), f(14), f(15), f(16), f(17), f(18), f(19), f(20), f(21), f(22), f(23), f(24) &
    , f(25), f(26), f(27), f(28), f(29), f(30), f(31), f(32), f(33), f(34), f(35), f(36), f(37), f(38), f(39), f(40), f(41), f(42) &
    , f(43), f(44), f(45), f(46), f(47), f(48), f(49), f(50), f(51), f(52), f(53), f(54), f(55), f(56), f(57), f(58), f(59), f(60) &
    , f(61), f(62), f(63), f(64), f(65), f(66), f(67), f(68), f(69), f(70), f(71), f(72), f(73), 3*f(74), 3*f(75), 3*f(76) &
    , 3*f(77), 3*f(78), 3*f(79), 3*f(80), 3*f(81), 3*f(82), f(83), 3*f(84), f(85), f(86), 3*f(87), 3*f(88), f(89), f(90), f(91) &
    , f(92), f(93), f(94), 3*f(95) ]
end subroutine fac_init_loop

subroutine denominators()
  use ol_parameters_decl_/**/REALKIND ! masses
  use ol_momenta_decl_/**/REALKIND, only: L
  implicit none
  ! propagators
  den(1) = 1 /((L(5,5) - MT2)+L(6,5))
  den(2) = 1 /((L(5,10) - MT2)+L(6,10))
  den(4) = 1 /((L(5,18) - MT2)+L(6,18))
  den(6) = 1 /((L(5,9) - MT2)+L(6,9))
  den(7) = 1 /((L(5,6) - MT2)+L(6,6))
  den(9) = 1 /((L(5,17) - MT2)+L(6,17))
  den(13) = 1 /((L(5,3))+L(6,3))
  den(14) = 1 /((L(5,3) - MZ2)+L(6,3))
  den(15) = 1 /((L(5,24) - MH2)+L(6,24))
  den(18) = 1 /((L(5,20) - MH2)+L(6,20))
  den(21) = 1 /((L(5,12) - MH2)+L(6,12))
  den(24) = 1 /((L(5,26) - MT2)+L(6,26))
  den(27) = 1 /((L(5,21) - MT2)+L(6,21))
  den(32) = 1 /((L(5,13) - MT2)+L(6,13))
  den(35) = 1 /((L(5,22) - MT2)+L(6,22))
  den(38) = 1 /((L(5,25) - MT2)+L(6,25))
  den(41) = 1 /((L(5,14) - MT2)+L(6,14))
  den(54) = 1 /((L(5,3) - MH2)+L(6,3))
  den(55) = 1 /((L(5,7) - MH2)+L(6,7))
  den(57) = 1 /((L(5,7) - MZ2)+L(6,7))
  den(59) = 1 /((L(5,7))+L(6,7))
  den(64) = 1 /((L(5,11) - MH2)+L(6,11))
  den(66) = 1 /((L(5,11) - MZ2)+L(6,11))
  den(68) = 1 /((L(5,11))+L(6,11))
  den(73) = 1 /((L(5,19) - MH2)+L(6,19))
  den(75) = 1 /((L(5,19) - MZ2)+L(6,19))
  den(77) = 1 /((L(5,19))+L(6,19))

  ! denominators
  den(3) = den(1)*den(2)
  den(5) = den(1)*den(4)
  den(8) = den(6)*den(7)
  den(10) = den(7)*den(9)
  den(11) = den(4)*den(6)
  den(12) = den(2)*den(9)
  den(16) = den(1)*den(15)
  den(17) = den(7)*den(15)
  den(19) = den(6)*den(18)
  den(20) = den(2)*den(18)
  den(22) = den(9)*den(21)
  den(23) = den(4)*den(21)
  den(25) = den(2)*den(24)
  den(26) = den(1)*den(25)
  den(28) = den(1)*den(27)
  den(29) = den(2)*den(28)
  den(30) = den(4)*den(24)
  den(31) = den(1)*den(30)
  den(33) = den(1)*den(32)
  den(34) = den(4)*den(33)
  den(36) = den(7)*den(35)
  den(37) = den(6)*den(36)
  den(39) = den(6)*den(38)
  den(40) = den(7)*den(39)
  den(42) = den(7)*den(41)
  den(43) = den(9)*den(42)
  den(44) = den(9)*den(38)
  den(45) = den(7)*den(44)
  den(46) = den(4)*den(35)
  den(47) = den(6)*den(46)
  den(48) = den(6)*den(32)
  den(49) = den(4)*den(48)
  den(50) = den(2)*den(41)
  den(51) = den(9)*den(50)
  den(52) = den(9)*den(27)
  den(53) = den(2)*den(52)
  den(56) = den(1)*den(55)
  den(58) = den(1)*den(57)
  den(60) = den(1)*den(59)
  den(61) = den(7)*den(55)
  den(62) = den(7)*den(57)
  den(63) = den(7)*den(59)
  den(65) = den(6)*den(64)
  den(67) = den(6)*den(66)
  den(69) = den(6)*den(68)
  den(70) = den(2)*den(64)
  den(71) = den(2)*den(66)
  den(72) = den(2)*den(68)
  den(74) = den(9)*den(73)
  den(76) = den(9)*den(75)
  den(78) = den(9)*den(77)
  den(79) = den(4)*den(73)
  den(80) = den(4)*den(75)
  den(81) = den(4)*den(77)

end subroutine denominators

#ifdef PRECISION_dp
! **********************************************************************
subroutine init_merging_tables(tot_num_hels, tot_num_merge_steps)
!-----------------------------------------------------------------------
! In the first event the merging tables are fully initialised
! **********************************************************************
  implicit none
  integer, intent(in) :: tot_num_hels, tot_num_merge_steps
  n_merge_steps = tot_num_merge_steps
  allocate(merge_tables(tot_num_hels,2,n_merge_steps))
  allocate(merge_mism(n_merge_steps+1))
  allocate(merge_hels(n_merge_steps))
  merge_tables_on = .true.
  merge_mism = 0_intkind2
  merge_tables = -1_intkind2
  merge_hels = -1_intkind2
end subroutine init_merging_tables

! **********************************************************************
subroutine update_merging_tables(tot_num_hels)
!-----------------------------------------------------------------------
! After the first evaluation the merging tables are adapted
! **********************************************************************
  implicit none
  integer, intent(in) :: tot_num_hels
  integer(intkind2), allocatable ::  merge_tables_tmp(:,:,:), merge_hels_tmp(:)

  if(merge_mism(1) == 0) then ! helicity configurations match in all merging steps
    if(allocated(merge_tables)) deallocate(merge_tables)
    if(allocated(merge_hels)) deallocate(merge_hels)
    if(allocated(merge_mism)) deallocate(merge_mism)
    allocate(merge_mism(1))
    allocate(merge_hels(1))
    allocate(merge_tables(1,1,1)) ! dummy allocation
    merge_mism = 0_intkind2
    merge_tables = -1_intkind2
    merge_hels = -1_intkind2
  else
    n_merge_mism = merge_mism(1)
    allocate(merge_tables_tmp(tot_num_hels,2,n_merge_mism))
    merge_tables_tmp(:,:,1:n_merge_mism) = merge_tables(:,:,1:n_merge_mism)
    if(allocated(merge_tables)) then
      deallocate(merge_tables)
      allocate(merge_tables(tot_num_hels,2,n_merge_mism))
    end if
    merge_tables = merge_tables_tmp
    if(allocated(merge_tables_tmp)) deallocate(merge_tables_tmp)
    allocate(merge_hels_tmp(n_merge_mism))
    merge_hels_tmp(1:n_merge_mism) = merge_hels(1:n_merge_mism)
    if(allocated(merge_hels)) then
      deallocate(merge_hels)
      allocate(merge_hels(n_merge_mism))
    end if
    merge_hels = merge_hels_tmp
    if(allocated(merge_hels_tmp)) deallocate(merge_hels_tmp)
  end if
  merge_tables_on = .true.
end subroutine update_merging_tables
#endif


!
!
!
! **********************************************************************
#ifdef PRECISION_dp
recursive subroutine amp2(P_scatt, M02, M2ct, M2colint, qp_kinematics)
#else
recursive subroutine amp2(P_scatt, M02, M2ct, M2colint, qp_kinematics)
  use ol_loop_storage_ppttj_ew_ttxaaa_2_/**/DREALKIND, only: nhel, Hel
#endif
! P_scatt(0:3,Npart) = incoming external momenta
! M2  = helicity-summed squared matrix element for top anti-top gamma gamma gamma -> 0
! **********************************************************************
  use ol_parameters_decl_/**/REALKIND !, only: ci, parameters_status, ZERO, scalefactor, >masses<
  use ol_parameters_init_/**/REALKIND, only: ensure_mp_init
  use ol_kinematics_/**/REALKIND, only: init_kinematics
  use ol_momenta_decl_/**/DREALKIND, only: momenta_nan_check
  use ol_data_types_/**/REALKIND
  use ol_h_helicity_bookkeeping_/**/REALKIND, only: &
    & helbookkeeping_wf, helsync, flip_phase
  use ol_helicity_init, only: helbookkeeping_flip, helsync_flip
  use ol_hel_propagators_/**/REALKIND
  use ol_hel_wavefunctions_/**/REALKIND
  use ol_wavefunctions_/**/REALKIND, only: wf_V_Std
  use ol_hel_vertices_/**/REALKIND
  use ol_hel_contractions_/**/REALKIND
  use ol_external_ppttj_ew_ttxaaa_2, only: &
    & external_perm_ppttj_ew_ttxaaa_2, &
    & external_perm_inv_ppttj_ew_ttxaaa_2, &
    & extcomb_perm_ppttj_ew_ttxaaa_2, &
    & average_factor_ppttj_ew_ttxaaa_2, &
    & photonid_ppttj_ew_ttxaaa_2
  use ol_ew_renormalisation_/**/REALKIND, only: photon_factors
  use ol_external_ppttj_ew_ttxaaa_2, only: &
    & H, hel_not_initialised, hel_init, POLSEL
  use ol_colourmatrix_ppttj_ew_ttxaaa_2_/**/REALKIND, only: &
    & colmat_not_initialised, colourmatrix_init
  use ol_forced_parameters_ppttj_ew_ttxaaa_2_/**/REALKIND, only: &
    & check_forced_parameters
  use ol_heltables_OLR_ppttj_ew_ttxaaa_2
  use ol_kinematics_/**/REALKIND, only: LC2Std_Rep_cmplx
  use ol_h_counterterms_/**/REALKIND
  use ol_loop_parameters_decl_/**/REALKIND ! counterterms
  use ol_loop_parameters_decl_/**/DREALKIND, only: &
    & IR_is_on, DOI, CT_is_on, R2_is_on, TP_is_on
  use ol_init, only: set_parameter, parameters_flush
#ifdef PRECISION_dp
  use ol_kinematics_/**/QREALKIND, only: conv_mom_scatt2in_qp=>conv_mom_scatt2in, &
                                         internal_momenta_qp=>internal_momenta
  use ol_momenta_decl_/**/DREALKIND, only: L
  use ol_momenta_decl_/**/QREALKIND, only: L_qp=>L
#endif
  implicit none

  real(DREALKIND), intent(in)  :: P_scatt(0:3,5)
  real(REALKIND),  intent(out) :: M02, M2ct, M2colint(16)
  logical, intent(in) :: qp_kinematics
  integer(intkind1), save :: ntry = 0

  integer           :: shift, k, r, m, n, i
  real(REALKIND)    :: P(0:3,5)
#ifdef PRECISION_dp
  real(QREALKIND)    :: P_qp(0:3,5)
#endif
  integer           :: extmasses2(5)
  real(REALKIND)    :: M2add, M2add_ct, M2add_colint(16)
  complex(REALKIND) :: M1(1), M2(1)
  real(REALKIND)    :: P_scatt_intern(0:3,5)
  real(REALKIND), save :: scalebackfactor, old_scalefactor = 0
  real(REALKIND)       :: bornphotonfactor
  integer(intkind1) :: nsync
  type(Hpolcont),   save :: M1helarray(1,32)
  type(Hpolcont) :: M1helarray_ct(1,32)
  integer, allocatable :: extcombs_permuted(:)
  integer              :: extcombs(16), nextcombs
  integer              :: CT_on_bak, R2_on_bak, TP_on_bak, DOI_bak

#if 5 > 3
  integer :: ind_cc_comb(5)
#endif
  type(Hpolcont) :: A(32,44)

  !Aj are not used at the moment
  !complex(REALKIND) :: Aj(44)

  complex(REALKIND) :: omega(2) ! phases for helicity correlations

  if(ntry == 0) then
    ! recursive initialization call needed for the correct helicity bokkeeping
    ntry = 1
    CT_on_bak = CT_is_on
    R2_on_bak = R2_is_on
    TP_on_bak = TP_is_on
    DOI_bak = DOI
    call set_parameter("ct_on", 1)
    call set_parameter("r2_on", 1)
    call set_parameter("tp_on", 1)
    DOI = 1
    call amp2(P_scatt, M02, M2ct, M2colint, qp_kinematics)
    call set_parameter("ct_on", CT_on_bak)
    call set_parameter("r2_on", R2_on_bak)
    call set_parameter("tp_on", TP_on_bak)
    DOI = DOI_bak
  end if


  call set_parameter("ew_renorm", 1)
  call parameters_flush()
  call ensure_mp_init()

  if (colmat_not_initialised) call colourmatrix_init()

  if (fac_status_loop1 /= parameters_status .or. fac_status_loop2 /= loop_parameters_status) then
    ! Note: if fac_init would only be called when parameters changed which are relevant for the factors,
    ! a different 'status' would have to be used, because forced_parameters should be called after every parameter change.
    call check_forced_parameters()
    call fac_init_loop()
  end if

  if (momenta_nan_check(P_scatt) /= 0) then
    M02 = 0
    return
  end if

  extmasses2 = [ nMT, nMT, 0, 0, 0 ]
  ! Convert 2 -> n-2 PS-point to n -> 0 (so that P(1) + ... + P(n) = 0) and compute
  ! internal-propagator momenta in light-cone representation
  call init_kinematics(P_scatt, extmasses2, P, &
     external_perm_inv_ppttj_ew_ttxaaa_2, 5, qp_kinematics)

  ! denominators
  call denominators()

   if (heltables_not_init) call init_heltables()

  ! external WFs
  ! Here the external wavefunctions are initialiased
  call pol_wf_Q(P(:,1), rMT, H1, ex1, POLSEL(1),1)
  call pol_wf_A(P(:,2), rMT, H2, ex2, POLSEL(2),2)
  call pol_wf_V(P(:,3), rZERO, H3, ex3, POLSEL(3),3)
  call pol_wf_V(P(:,4), rZERO, H4, ex4, POLSEL(4),4)
  call pol_wf_V(P(:,5), rZERO, H5, ex5, POLSEL(5),5)



  ! internal WFs
  ! e.g. call vert_VQ_A(ntry, ex3, ex1, wf1, n1, t1) ...
  call vert_VQ_A(ntry, ex3(:), ex1(:), wf4(:,1), n3(:,1), t3x4(:,:,1))
  call vert_AV_Q(ntry, ex2(:), ex4(:), wf4(:,2), n3(:,2), t3x4(:,:,2))
  call prop_Q_A(ntry, wf4(:,1), 5, MT, 1_intkind1, wf4(:,3), n2(1))
  call prop_A_Q(ntry, wf4(:,2), 10, MT, 1_intkind1, wf4(:,4), n2(2))
  call vert_VQ_A(ntry, ex5(:), wf4(:,3), wf8(:,1), n3(:,3), t3x8(:,:,1))
  call vert_AV_Q(ntry, ex2(:), ex5(:), wf4(:,5), n3(:,4), t3x4(:,:,3))
  call prop_A_Q(ntry, wf4(:,5), 18, MT, 1_intkind1, wf4(:,6), n2(3))
  call vert_VQ_A(ntry, ex4(:), wf4(:,3), wf8(:,2), n3(:,5), t3x8(:,:,2))
  call vert_VQ_A(ntry, ex4(:), ex1(:), wf4(:,7), n3(:,6), t3x4(:,:,4))
  call vert_AV_Q(ntry, ex2(:), ex3(:), wf4(:,8), n3(:,7), t3x4(:,:,5))
  call prop_Q_A(ntry, wf4(:,7), 9, MT, 1_intkind1, wf4(:,9), n2(4))
  call prop_A_Q(ntry, wf4(:,8), 6, MT, 1_intkind1, wf4(:,10), n2(5))
  call vert_VQ_A(ntry, ex5(:), wf4(:,9), wf8(:,3), n3(:,8), t3x8(:,:,3))
  call vert_VQ_A(ntry, ex5(:), ex1(:), wf4(:,11), n3(:,9), t3x4(:,:,6))
  call prop_Q_A(ntry, wf4(:,11), 17, MT, 1_intkind1, wf4(:,12), n2(6))
  call vert_VQ_A(ntry, ex4(:), wf4(:,12), wf8(:,4), n3(:,10), t3x8(:,:,4))
  call vert_VQ_A(ntry, ex3(:), wf4(:,9), wf8(:,5), n3(:,11), t3x8(:,:,5))
  call vert_VQ_A(ntry, ex3(:), wf4(:,12), wf8(:,6), n3(:,12), t3x8(:,:,6))
  call vert_QA_V(ntry, ex1(:), ex2(:), wf4(:,13), n3(:,13), t3x4(:,:,7))
  call counter_VVV_V(ntry, ex3(:), ex4(:), ex5(:), wf8(:,7), n4(:,1), t4x8(:,:,1))
  call vert_QA_Z(gZu,ntry, ex1(:), ex2(:), wf4(:,14), n3(:,14), t3x4(:,:,8))
  call counter_VQ_A_LR(EWctAtt,ntry, ex5(:), wf4(:,3), wf8(:,8), n3(:,15), t3x8(:,:,7))
  call counter_VQ_A_LR(EWctAtt,ntry, ex4(:), wf4(:,3), wf8(:,9), n3(:,16), t3x8(:,:,8))
  call counter_VV_S(ntry, ex4(:), ex5(:), wf4(:,15), n3(:,17), t3x4(:,:,9))
  call vert_AQ_S(gH,ntry, ex2(:), wf4(:,3), wf8(:,10), n3(:,18), t3x8(:,:,9))
  call counter_VQ_A_LR(EWctAtt,ntry, ex5(:), wf4(:,9), wf8(:,11), n3(:,19), t3x8(:,:,10))
  call counter_VQ_A_LR(EWctAtt,ntry, ex4(:), wf4(:,12), wf8(:,12), n3(:,20), t3x8(:,:,11))
  call vert_AQ_S(gH,ntry, wf4(:,10), ex1(:), wf8(:,13), n3(:,21), t3x8(:,:,12))
  call counter_VQ_A_LR(EWctAtt,ntry, ex3(:), wf4(:,9), wf8(:,14), n3(:,22), t3x8(:,:,13))
  call counter_VV_S(ntry, ex3(:), ex5(:), wf4(:,16), n3(:,23), t3x4(:,:,10))
  call vert_AQ_S(gH,ntry, ex2(:), wf4(:,9), wf8(:,15), n3(:,24), t3x8(:,:,14))
  call counter_VQ_A_LR(EWctAtt,ntry, ex3(:), wf4(:,12), wf8(:,16), n3(:,25), t3x8(:,:,15))
  call vert_AQ_S(gH,ntry, wf4(:,4), ex1(:), wf8(:,17), n3(:,26), t3x8(:,:,16))
  call counter_VV_S(ntry, ex3(:), ex4(:), wf4(:,17), n3(:,27), t3x4(:,:,11))
  call vert_AQ_S(gH,ntry, ex2(:), wf4(:,12), wf8(:,18), n3(:,28), t3x8(:,:,17))
  call vert_AQ_S(gH,ntry, wf4(:,6), ex1(:), wf8(:,19), n3(:,29), t3x8(:,:,18))
  call counter_AV_Q_LR(EWctAtt,ntry, ex2(:), ex5(:), wf4(:,18), n3(:,30), t3x4(:,:,12))
  call prop_A_Q(ntry, wf4(:,18), 18, MT, 1_intkind1, wf4(:,19), n2(7))
  call counter_AV_Q_LR(EWctAtt,ntry, ex2(:), ex4(:), wf4(:,20), n3(:,31), t3x4(:,:,13))
  call prop_A_Q(ntry, wf4(:,20), 10, MT, 1_intkind1, wf4(:,21), n2(8))
  call counter_AV_Q_LR(EWctAtt,ntry, ex2(:), ex3(:), wf4(:,22), n3(:,32), t3x4(:,:,14))
  call prop_A_Q(ntry, wf4(:,22), 6, MT, 1_intkind1, wf4(:,23), n2(9))
  call counter_VQ_A_LR(EWctAtt,ntry, ex5(:), ex1(:), wf4(:,24), n3(:,33), t3x4(:,:,15))
  call prop_Q_A(ntry, wf4(:,24), 17, MT, 1_intkind1, wf4(:,25), n2(10))
  call vert_VQ_A(ntry, ex4(:), wf4(:,25), wf8(:,20), n3(:,34), t3x8(:,:,19))
  call counter_VQ_A_LR(EWctAtt,ntry, ex4(:), ex1(:), wf4(:,26), n3(:,35), t3x4(:,:,16))
  call prop_Q_A(ntry, wf4(:,26), 9, MT, 1_intkind1, wf4(:,27), n2(11))
  call vert_VQ_A(ntry, ex5(:), wf4(:,27), wf8(:,21), n3(:,36), t3x8(:,:,20))
  call vert_VQ_A(ntry, ex3(:), wf4(:,25), wf8(:,22), n3(:,37), t3x8(:,:,21))
  call vert_VQ_A(ntry, ex3(:), wf4(:,27), wf8(:,23), n3(:,38), t3x8(:,:,22))
  call counter_VQ_A_LR(EWctAtt,ntry, ex3(:), ex1(:), wf4(:,28), n3(:,39), t3x4(:,:,17))
  call prop_Q_A(ntry, wf4(:,28), 5, MT, 1_intkind1, wf4(:,29), n2(12))
  call vert_VQ_A(ntry, ex5(:), wf4(:,29), wf8(:,24), n3(:,40), t3x8(:,:,23))
  call vert_VQ_A(ntry, ex4(:), wf4(:,29), wf8(:,25), n3(:,41), t3x8(:,:,24))
  call vert_AV_Q(ntry, wf4(:,4), ex5(:), wf8(:,26), n3(:,42), t3x8(:,:,25))
  call counter_Q_A_LR(EWcttt,ntry, wf4(:,3), 5, wf4(:,30), n2(13))
  call prop_A_Q(ntry, wf8(:,26), 26, MT, 1_intkind1, wf8(:,27), n2(14))
  call counter_A_Q_LR(EWcttt,ntry, wf4(:,4), 10, wf4(:,31), n2(15))
  call prop_Q_A(ntry, wf8(:,1), 21, MT, 1_intkind1, wf8(:,28), n2(16))
  call vert_AV_Q(ntry, wf4(:,6), ex4(:), wf8(:,29), n3(:,43), t3x8(:,:,26))
  call prop_A_Q(ntry, wf8(:,29), 26, MT, 1_intkind1, wf8(:,30), n2(17))
  call counter_A_Q_LR(EWcttt,ntry, wf4(:,6), 18, wf4(:,32), n2(18))
  call prop_Q_A(ntry, wf8(:,2), 13, MT, 1_intkind1, wf8(:,31), n2(19))
  call vert_AV_Q(ntry, wf4(:,10), ex5(:), wf8(:,32), n3(:,44), t3x8(:,:,27))
  call counter_Q_A_LR(EWcttt,ntry, wf4(:,9), 9, wf4(:,33), n2(20))
  call prop_A_Q(ntry, wf8(:,32), 22, MT, 1_intkind1, wf8(:,33), n2(21))
  call counter_A_Q_LR(EWcttt,ntry, wf4(:,10), 6, wf4(:,34), n2(22))
  call prop_Q_A(ntry, wf8(:,3), 25, MT, 1_intkind1, wf8(:,34), n2(23))
  call vert_AV_Q(ntry, wf4(:,10), ex4(:), wf8(:,35), n3(:,45), t3x8(:,:,28))
  call counter_Q_A_LR(EWcttt,ntry, wf4(:,12), 17, wf4(:,35), n2(24))
  call prop_A_Q(ntry, wf8(:,35), 14, MT, 1_intkind1, wf8(:,36), n2(25))
  call prop_Q_A(ntry, wf8(:,4), 25, MT, 1_intkind1, wf8(:,37), n2(26))
  call vert_AV_Q(ntry, wf4(:,6), ex3(:), wf8(:,38), n3(:,46), t3x8(:,:,29))
  call prop_A_Q(ntry, wf8(:,38), 22, MT, 1_intkind1, wf8(:,39), n2(27))
  call prop_Q_A(ntry, wf8(:,5), 13, MT, 1_intkind1, wf8(:,40), n2(28))
  call vert_AV_Q(ntry, wf4(:,4), ex3(:), wf8(:,41), n3(:,47), t3x8(:,:,30))
  call prop_A_Q(ntry, wf8(:,41), 14, MT, 1_intkind1, wf8(:,42), n2(29))
  call prop_Q_A(ntry, wf8(:,6), 21, MT, 1_intkind1, wf8(:,43), n2(30))
  call vert_AQ_S(gH,ntry, ex2(:), ex1(:), wf4(:,36), n3(:,48), t3x4(:,:,18))
  call vert_AQ_S(gX,ntry, ex2(:), ex1(:), wf4(:,37), n3(:,49), t3x4(:,:,19))
  call vert_AQ_S(gX,ntry, ex2(:), wf4(:,3), wf8(:,44), n3(:,50), t3x8(:,:,31))
  call vert_QA_V(ntry, wf4(:,3), ex2(:), wf8(:,45), n3(:,51), t3x8(:,:,32))
  call vert_QA_Z(gZu,ntry, wf4(:,3), ex2(:), wf8(:,46), n3(:,52), t3x8(:,:,33))
  call vert_AQ_S(gX,ntry, wf4(:,10), ex1(:), wf8(:,47), n3(:,53), t3x8(:,:,34))
  call vert_QA_V(ntry, ex1(:), wf4(:,10), wf8(:,48), n3(:,54), t3x8(:,:,35))
  call vert_QA_Z(gZu,ntry, ex1(:), wf4(:,10), wf8(:,49), n3(:,55), t3x8(:,:,36))
  call vert_AQ_S(gX,ntry, ex2(:), wf4(:,9), wf8(:,50), n3(:,56), t3x8(:,:,37))
  call vert_QA_V(ntry, wf4(:,9), ex2(:), wf8(:,51), n3(:,57), t3x8(:,:,38))
  call vert_QA_Z(gZu,ntry, wf4(:,9), ex2(:), wf8(:,52), n3(:,58), t3x8(:,:,39))
  call vert_AQ_S(gX,ntry, wf4(:,4), ex1(:), wf8(:,53), n3(:,59), t3x8(:,:,40))
  call vert_QA_V(ntry, ex1(:), wf4(:,4), wf8(:,54), n3(:,60), t3x8(:,:,41))
  call vert_QA_Z(gZu,ntry, ex1(:), wf4(:,4), wf8(:,55), n3(:,61), t3x8(:,:,42))
  call vert_AQ_S(gX,ntry, ex2(:), wf4(:,12), wf8(:,56), n3(:,62), t3x8(:,:,43))
  call vert_QA_V(ntry, wf4(:,12), ex2(:), wf8(:,57), n3(:,63), t3x8(:,:,44))
  call vert_QA_Z(gZu,ntry, wf4(:,12), ex2(:), wf8(:,58), n3(:,64), t3x8(:,:,45))
  call vert_AQ_S(gX,ntry, wf4(:,6), ex1(:), wf8(:,59), n3(:,65), t3x8(:,:,46))
  call vert_QA_V(ntry, ex1(:), wf4(:,6), wf8(:,60), n3(:,66), t3x8(:,:,47))
  call vert_QA_Z(gZu,ntry, ex1(:), wf4(:,6), wf8(:,61), n3(:,67), t3x8(:,:,48))


  call init_hybrid_exwf(ex1)
  call init_hybrid_exwf(ex2)
  call init_hybrid_exwf(ex3)
  call init_hybrid_exwf(ex4)
  call init_hybrid_exwf(ex5)
  call init_hybrid_wf(wf4)
  call init_hybrid_wf(wf8)


  if (ntry==1) then
    call physical_helicities()
  end if

  ! computation of the colour-stripped amplitudes
  do nsync = ntry+ntry-1, ntry+1  !  nsync = 1,2  for 1st point and nsync = 3 later
    call diagrams()
    if (nsync == 1) call helsync(nsync, A, nhel, Hel)
  end do

  ! In the following loop the coefficients \Gamma_{i} of the expansion in
  ! the colour basis are computed for every helicity state and stored in M1helarray.
  ! Also the colour vector for the Born-loop interference is computed and saved in
  ! M0_col1_helarray
  do k = 1, nhel
    call colourvectors(A, k, M1helarray(:,k),M1helarray_ct(:,k))
    call colborninterf(M1helarray(:,k), M0_col1_helarray(:,k), 0)
  end do
  M1helarray(:,nhel+1:)%j = 0
  M0_col1_helarray(:,nhel+1:)%hf = -1_intkind2
  M0_col1_helarray(:,nhel+1:)%j = 0

  M2add = 0
  M2add_ct = 0
  M2add_colint = 0

  M02 = 0
  M2ct = 0
  M2colint = 0

  do k = 1, nhel
    call colint(M1helarray(:,k)%j, M2add)
    call colint_ct(M1helarray(:,k)%j, M1helarray_ct(:,k)%j, M2add_ct, 0)
    if (IR_is_on > 0) then
      call colint_IR(M1helarray(:,k)%j, M2add_colint)
    end if
    !summation over helicity configurations
    M02 = M02 + M2add
    M2ct = M2ct + M2add_ct
    M2colint = M2colint + M2add_colint
  end do

  call photon_factors(photonid_ppttj_ew_ttxaaa_2, &
                    &  0, bornphotonfactor)
  M02 = bornphotonfactor * M02
  M2ct = bornphotonfactor * M2ct
  M2colint = bornphotonfactor * M2colint

  !! used for born-loop colour-correlators
  extcombs = [(i, i = 0, 16-1)]
  nextcombs = 5*(5+1)/2 + 1
  if(nextcombs>0) then
    allocate(extcombs_permuted(nextcombs))
  end if
  do k = 1, nextcombs
    extcombs_permuted(k) = extcomb_perm_ppttj_ew_ttxaaa_2(extcombs(k))
  end do

#if 1 > 0 && 5 > 3
  !!Born-loop colour correlators interference
ind_cc_comb = [8,12,9,13,14]
  M0M1_hel_cc(:,:,:)%j = 0
  do n = 1, 5
    M2add_ct = 0
    m = ind_cc_comb(n)
      do k = 1, nhel
        call colint_ct(M1helarray(:,k)%j, M1helarray_ct(:,k)%j, M2add_ct, m)
        call colborninterf(M1helarray(:,k), M0M1_hel_cc(:,k,m), m)
        M2ctcc(m) = M2ctcc(m) + M2add_ct
      end do
  end do
  M0M1_hel_cc(:,nhel+1:,:)%hf = -1_intkind2
  M0M1_hel_cc(:,nhel+1:,:)%j = 0
#endif

  ntry=2


  contains

subroutine physical_helicities()
  implicit none

integer :: i1,i2,i3,i4,i5
integer :: n

n=0

do i5= 1, 2
do i4= 1, 2
do i3= 1, 2
do i2= 1, 2
do i1= 1, 2
n = n + 1
 if((ex1(i1)%hf==-1_intkind2) .OR. (ex2(i2)%hf==-1_intkind2) .OR. (ex3(i3)%hf==-1_intkind2) .OR. (ex4(i4)%hf==-1_intkind2)  &
    .OR. (ex5(i5)%hf==-1_intkind2)) then
  Hel(n) = -1_intkind2
 else
  Hel(n) = ex1(i1)%hf + ex2(i2)%hf + ex3(i3)%hf + ex4(i4)%hf + ex5(i5)%hf
 end if
end do
end do
end do
end do
end do

end subroutine physical_helicities

subroutine diagrams()
  implicit none
  integer :: h
  ! e.g. call cont_VV(nsync, wf3, wf6, A(:,1), n64, t64, nhel, den(5)) ...

    call Hcont_QA(nsync, wf4(:,4), wf8(:,1), A(:,1), n3(:,68), t3x32(:,:,1), nhel, den(3))
    call Hcont_QA(nsync, wf4(:,6), wf8(:,2), A(:,2), n3(:,69), t3x32(:,:,2), nhel, den(5))
    call Hcont_QA(nsync, wf4(:,10), wf8(:,3), A(:,3), n3(:,70), t3x32(:,:,3), nhel, den(8))
    call Hcont_QA(nsync, wf4(:,10), wf8(:,4), A(:,4), n3(:,71), t3x32(:,:,4), nhel, den(10))
    call Hcont_QA(nsync, wf4(:,6), wf8(:,5), A(:,5), n3(:,72), t3x32(:,:,5), nhel, den(11))
    call Hcont_QA(nsync, wf4(:,4), wf8(:,6), A(:,6), n3(:,73), t3x32(:,:,6), nhel, den(12))

    call Hcont_VV(nsync, wf4(:,13), wf8(:,7), A(:,7), n3(:,74), t3x32(:,:,7), nhel, den(13))
    call Hcont_VV(nsync, wf8(:,7), wf4(:,14), A(:,8), n3(:,75), t3x32(:,:,8), nhel, den(14))
    call Hcont_QA(nsync, wf4(:,4), wf8(:,8), A(:,9), n3(:,76), t3x32(:,:,9), nhel, den(3))
    call Hcont_QA(nsync, wf4(:,6), wf8(:,9), A(:,10), n3(:,77), t3x32(:,:,10), nhel, den(5))
    call Hcont_SS(nsync, wf4(:,15), wf8(:,10), A(:,11), n3(:,78), t3x32(:,:,11), nhel, den(16))
    call Hcont_QA(nsync, wf4(:,10), wf8(:,11), A(:,12), n3(:,79), t3x32(:,:,12), nhel, den(8))
    call Hcont_QA(nsync, wf4(:,10), wf8(:,12), A(:,13), n3(:,80), t3x32(:,:,13), nhel, den(10))
    call Hcont_SS(nsync, wf4(:,15), wf8(:,13), A(:,14), n3(:,81), t3x32(:,:,14), nhel, den(17))
    call Hcont_QA(nsync, wf4(:,6), wf8(:,14), A(:,15), n3(:,82), t3x32(:,:,15), nhel, den(11))
    call Hcont_SS(nsync, wf4(:,16), wf8(:,15), A(:,16), n3(:,83), t3x32(:,:,16), nhel, den(19))
    call Hcont_QA(nsync, wf4(:,4), wf8(:,16), A(:,17), n3(:,84), t3x32(:,:,17), nhel, den(12))
    call Hcont_SS(nsync, wf4(:,16), wf8(:,17), A(:,18), n3(:,85), t3x32(:,:,18), nhel, den(20))
    call Hcont_SS(nsync, wf4(:,17), wf8(:,18), A(:,19), n3(:,86), t3x32(:,:,19), nhel, den(22))
    call Hcont_SS(nsync, wf4(:,17), wf8(:,19), A(:,20), n3(:,87), t3x32(:,:,20), nhel, den(23))
    call Hcont_QA(nsync, wf8(:,2), wf4(:,19), A(:,21), n3(:,88), t3x32(:,:,21), nhel, den(5))
    call Hcont_QA(nsync, wf8(:,1), wf4(:,21), A(:,22), n3(:,89), t3x32(:,:,22), nhel, den(3))
    call Hcont_QA(nsync, wf8(:,5), wf4(:,19), A(:,23), n3(:,90), t3x32(:,:,23), nhel, den(11))
    call Hcont_QA(nsync, wf8(:,6), wf4(:,21), A(:,24), n3(:,91), t3x32(:,:,24), nhel, den(12))
    call Hcont_QA(nsync, wf8(:,3), wf4(:,23), A(:,25), n3(:,92), t3x32(:,:,25), nhel, den(8))
    call Hcont_QA(nsync, wf8(:,4), wf4(:,23), A(:,26), n3(:,93), t3x32(:,:,26), nhel, den(10))
    call Hcont_QA(nsync, wf4(:,10), wf8(:,20), A(:,27), n3(:,94), t3x32(:,:,27), nhel, den(10))
    call Hcont_QA(nsync, wf4(:,10), wf8(:,21), A(:,28), n3(:,95), t3x32(:,:,28), nhel, den(8))
    call Hcont_QA(nsync, wf4(:,4), wf8(:,22), A(:,29), n3(:,96), t3x32(:,:,29), nhel, den(12))
    call Hcont_QA(nsync, wf4(:,6), wf8(:,23), A(:,30), n3(:,97), t3x32(:,:,30), nhel, den(11))
    call Hcont_QA(nsync, wf4(:,4), wf8(:,24), A(:,31), n3(:,98), t3x32(:,:,31), nhel, den(3))
    call Hcont_QA(nsync, wf4(:,6), wf8(:,25), A(:,32), n3(:,99), t3x32(:,:,32), nhel, den(5))
    call Hcont_QA(nsync, wf4(:,30), wf8(:,27), A(:,33), n3(:,100), t3x32(:,:,33), nhel, den(26))
    call Hcont_QA(nsync, wf4(:,31), wf8(:,28), A(:,34), n3(:,101), t3x32(:,:,34), nhel, den(29))
    call Hcont_QA(nsync, wf4(:,30), wf8(:,30), A(:,35), n3(:,102), t3x32(:,:,35), nhel, den(31))
    call Hcont_QA(nsync, wf4(:,32), wf8(:,31), A(:,36), n3(:,103), t3x32(:,:,36), nhel, den(34))
    call Hcont_QA(nsync, wf4(:,33), wf8(:,33), A(:,37), n3(:,104), t3x32(:,:,37), nhel, den(37))
    call Hcont_QA(nsync, wf4(:,34), wf8(:,34), A(:,38), n3(:,105), t3x32(:,:,38), nhel, den(40))
    call Hcont_QA(nsync, wf4(:,35), wf8(:,36), A(:,39), n3(:,106), t3x32(:,:,39), nhel, den(43))
    call Hcont_QA(nsync, wf4(:,34), wf8(:,37), A(:,40), n3(:,107), t3x32(:,:,40), nhel, den(45))
    call Hcont_QA(nsync, wf4(:,33), wf8(:,39), A(:,41), n3(:,108), t3x32(:,:,41), nhel, den(47))
    call Hcont_QA(nsync, wf4(:,32), wf8(:,40), A(:,42), n3(:,109), t3x32(:,:,42), nhel, den(49))
    call Hcont_QA(nsync, wf4(:,35), wf8(:,42), A(:,43), n3(:,110), t3x32(:,:,43), nhel, den(51))
    call Hcont_QA(nsync, wf4(:,31), wf8(:,43), A(:,44), n3(:,111), t3x32(:,:,44), nhel, den(53))

end subroutine diagrams


elemental function diagmap(j, n)
  implicit none
  integer, intent(in) :: j, n
  complex(REALKIND) :: diagmap
  diagmap = A(j,n)%j
end function diagmap

function diagsum(j, pos, neg)
  implicit none
  integer, intent(in) :: j, pos(:), neg(:)
  complex(REALKIND) :: diagsum
  diagsum = sum(diagmap(j, pos)) - sum(diagmap(j, neg))
end function diagsum

subroutine colourvectors(A, j, M1, M2)
  implicit none
  type(Hpolcont) :: A(:,:)
  integer, intent(in) :: j
  type(Hpolcont), intent(out) :: M1(1), M2(1) ! M1helarray(1,32)
  integer :: empty(0), i

  M1(1)%j = (A(j,1)%j+A(j,2)%j+A(j,3)%j+A(j,4)%j+A(j,5)%j+A(j,6)%j)*f(1)

  M2(1)%j = (-A(j,33)%j-A(j,34)%j-A(j,35)%j-A(j,36)%j-A(j,37)%j-A(j,38)%j-A(j,39)%j-A(j,40)%j-A(j,41)%j-A(j,42)%j-A(j,43)%j &
       -A(j,44)%j)*f(2)+(-A(j,9)%j-A(j,10)%j-A(j,12)%j-A(j,13)%j-A(j,15)%j-A(j,17)%j-A(j,21)%j-A(j,22)%j-A(j,23)%j-A(j,24)%j &
       -A(j,25)%j-A(j,26)%j-A(j,27)%j-A(j,28)%j-A(j,29)%j-A(j,30)%j-A(j,31)%j-A(j,32)%j)*f(3)+A(j,7)%j*f(4)-A(j,8)%j*f(5)+( &
       -A(j,11)%j-A(j,14)%j-A(j,16)%j-A(j,18)%j-A(j,19)%j-A(j,20)%j)*f(6)


  M1(:)%hf = Hel(j)
  M2(:)%hf = Hel(j)

  !M(i) corresponds to \Gamma_{i} in Fabios thesis

end subroutine colourvectors


! **********************************************************************
subroutine colint(M, M2colint)
! M(i)   = <M|Ci> colour component of matrix element
! COLINT = <M|M>
!        = Sum_{i,j} <M|Ci> * <Ci|Cj> * <Cj|M>
!        = colour-summed squared matrix element
! K2(i,j) = <Ci|Cj>
! **********************************************************************
  use ol_colourmatrix_ppttj_ew_ttxaaa_2_/**/REALKIND, only: K1
  implicit none

  complex(REALKIND), intent(in)  :: M(1)
  real(REALKIND),    intent(out) :: M2colint
  integer :: i, j

  M2colint = 0

    do i = 1, 1
      do j = 1, 1
        M2colint = M2colint + real(conjg(M(i))*K1(i,j)*M(j))
      end do
    end do

end subroutine colint

! **********************************************************************
subroutine colint_ct(M, Mct, M2colint_ct, l)
! M(i)   = <M|Ci> colour component of matrix element
! COLINT = <M|M>
!        = Sum_{i,j} <M|Ci> * <Ci|Cj> * <Cj|M>
!        = colour-summed squared matrix element
! K2(i,j) = <Ci|Cj>
! **********************************************************************
  use ol_colourmatrix_ppttj_ew_ttxaaa_2_/**/REALKIND, only: K2
  implicit none
  complex(REALKIND), intent(in)  :: M(1), Mct(1)
  real(REALKIND),    intent(out) :: M2colint_ct
  integer, intent(in) :: l
  integer ::  i, j

  M2colint_ct = 0

  do i = 1, 1
    do j = 1, 1
      M2colint_ct = M2colint_ct + real(conjg(M(i))*K2(i+1*l,j)*Mct(j))
    end do
  end do

end subroutine colint_ct

! **********************************************************************
subroutine colint_IR(M, M2IRadd)
! M(i)   = <M|Ci> colour component of matrix element
! K1(i,j) = .....
! **********************************************************************
  use ol_colourmatrix_ppttj_ew_ttxaaa_2_/**/REALKIND, only: K1
  implicit none

  complex(REALKIND), intent(in)  :: M(1)
  real(REALKIND),    intent(out) :: M2IRadd(16)
  integer ::  i, j, k, colmatpos

  M2IRadd = 0

  do k = 1, 17-1
    colmatpos = 1*k
    do i = 1, 1
      do j = 1, 1
        M2IRadd(k) = M2IRadd(k) + real(conjg(M(i))*K1(i+colmatpos,j)*M(j))
      end do
    end do
  end do

end subroutine colint_IR

! **********************************************************************
subroutine colintmunu(M1, M2, M2colint)
! M1(i)    = <M1|Ci> colour component of matrix element
! M2(i)    = <M2|Ci> colour component of matrix element
! M2colint = <M1|M2>
!          = Sum_{i,j} <M1|Ci> * <Ci|Cj> * <Cj|M2>
!          = colour-summed squared matrix element
! K2(i,j) = <Ci|Cj>
! **********************************************************************
  use ol_colourmatrix_ppttj_ew_ttxaaa_2_/**/REALKIND, only: K2
  implicit none

  complex(REALKIND), intent(in)  :: M1(1)
  complex(REALKIND), intent(in)  :: M2(1)
  complex(REALKIND),    intent(out) :: M2colint
  integer :: i, j

  M2colint = 0

  do i = 1, 1
    do j = 1, 1
      M2colint = M2colint + M1(i)*K2(i,j)*conjg(M2(j))
    end do
  end do

end subroutine colintmunu





! **********************************************************************
subroutine colborninterf(M, M0_col, l)
! M(i)         = <M|Ci> colour component of matrix element
! M0_col(i)    = <M2|Ci> colour component of matrix element,
!                see \tilde{M}_{j} in Fabios thesis
! M2colint = Sum_{i} <M1|Ci> * <Ci|Cj>
!          = colour-summed squared matrix element
! KL(i,j) = <Ci|Cj> with elements Cj of 1-loop colour basis
! **********************************************************************
  use ol_colourmatrix_ppttj_ew_ttxaaa_2_/**/REALKIND, only: KL
  implicit none

  type(Hpolcont), intent(in)  :: M(1)
  type(Hpolcont), intent(out)  :: M0_col(1)
  integer, intent(in) :: l
  integer :: i, j

  do j = 1, 1 !size(KL(1,:))
    M0_col(j)%j = 0
    M0_col(j)%hf = M(1)%hf
    do i = 1, 1 !size(KL(:,1))
      M0_col(j)%j = M0_col(j)%j  + conjg(M(i)%j)*KL(i+1*l,j)
    end do
  end do

end subroutine colborninterf

end subroutine amp2

end module ol_loop_ppttj_ew_ttxaaa_2_/**/REALKIND
