
module ol_vamp_1_ppttj_ew_ttxbbxg_1_/**/REALKIND
contains

! **********************************************************************
subroutine vamp_1(M)
! P(0:3,nlegs) = incoming external momenta
! Uses tree structures 'wf', factors 'c', and denominators 'den' from loop_ppttj_ew_ttxbbxg_1.
! Sets colour stripped amplitudes A from the module loop_amplitudes_ppttj_ew_ttxbbxg_1.
! **********************************************************************
  use KIND_TYPES, only: REALKIND, QREALKIND, intkind2
  use ol_parameters_decl_/**/DREALKIND, only: l_switch
  use ol_parameters_decl_/**/QREALKIND ! masses
  use ol_vert_interface_/**/REALKIND
  use ol_prop_interface_/**/REALKIND
  use ol_last_step_/**/REALKIND
  use ol_tables_storage_ppttj_ew_ttxbbxg_1_/**/DREALKIND
  use ol_tensor_sum_storage_ppttj_ew_ttxbbxg_1_/**/REALKIND
  use ol_loop_handling_/**/REALKIND
  use ofred_reduction_/**/REALKIND, only: Hotf_4pt_reduction, Hotf_4pt_reduction_last
  use ofred_reduction_/**/REALKIND, only: Hotf_5pt_reduction, Hotf_5pt_reduction_last
  use ol_loop_reduction_/**/REALKIND, only: TI_bubble_red, TI_triangle_red
use ol_loop_reduction_/**/REALKIND, only: compute_scalar_box

  use ol_loop_storage_ppttj_ew_ttxbbxg_1_/**/REALKIND
#ifndef PRECISION_dp
  use ol_loop_storage_ppttj_ew_ttxbbxg_1_/**/DREALKIND, only: ntryL, p_switch, Hel
#endif
  use hol_initialisation_/**/REALKIND, only: G0_hol_initialisation
  use ol_h_vert_interface_/**/REALKIND
  use ol_h_prop_interface_/**/REALKIND
  use ol_h_last_step_/**/REALKIND
  use ol_merging_/**/REALKIND, only: ol_merge, ol_merge_tensors, ol_merge_last

  implicit none

  type(Hpolcont) :: Gcoeff(32)
  type(Hpolcont), intent(in) :: M(8,32)


#ifndef PRECISION_dp
  if (ntryL==1 .OR. p_switch == 1) Gcoeff(:)%hf = Hel
#else
  if (ntryL==1 .OR. p_switch == 2) Gcoeff(:)%hf = Hel
#endif

  ! =============================================


! Dressing, otf merging and otf reduction calls to build loop structures

Gcoeff(:)%j = (-(c(53)*M(3,:)%j)+c(52)*M(7,:)%j)
call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1),h0tab(:,1),[16,4,1,2,8],[nMB,nMH,nMT,0,nMB],5,0)
  call Hloop_AV_Q(ntryL,G0H32(1),ex5(:),G0H16(1),m3h2x16(:,1),heltab2x32(:,:,1))
  call Hloop_A_Q(ntryL,G0H16(1),16,nMB,G1H16(1),n2h16(1))
Gcoeff(:)%j = (-(c(53)*M(3,:)%j)+c(52)*M(7,:)%j)
call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(2),h0tab(:,2),[16,4,1,2,8],[nMB,nMZ,nMT,0,nMB],5,0)
  call Hloop_AV_Q(ntryL,G0H32(1),ex5(:),G0H16(1),m3h2x16(:,2),heltab2x32(:,:,2))
  call Hloop_A_Q(ntryL,G0H16(1),16,nMB,G1H16(2),n2h16(2))
Gcoeff(:)%j = (-(c(53)*M(5,:)%j)+c(52)*M(7,:)%j)
call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(3),h0tab(:,3),[16,4,1,2,8],[nMB,0,nMT,nMH,nMB],5,0)
  call Hloop_AV_Q(ntryL,G0H32(1),ex5(:),G0H16(1),m3h2x16(:,3),heltab2x32(:,:,3))
  call Hloop_A_Q(ntryL,G0H16(1),16,nMB,G1H16(3),n2h16(3))
Gcoeff(:)%j = (-(c(53)*M(5,:)%j)+c(52)*M(7,:)%j)
call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(4),h0tab(:,4),[16,4,1,2,8],[nMB,0,nMT,nMZ,nMB],5,0)
  call Hloop_AV_Q(ntryL,G0H32(1),ex5(:),G0H16(1),m3h2x16(:,4),heltab2x32(:,:,4))
  call Hloop_A_Q(ntryL,G0H16(1),16,nMB,G1H16(4),n2h16(4))
Gcoeff(:)%j = (-(c(10)*M(3,:)%j)+c(9)*M(7,:)%j)
call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(5),h0tab(:,5),[16,4,1,2,8],[nMB,0,nMT,0,nMB],5,0)
  call Hloop_AV_Q(ntryL,G0H32(1),ex5(:),G0H16(1),m3h2x16(:,5),heltab2x32(:,:,5))
  call Hloop_A_Q(ntryL,G0H16(1),16,nMB,G1H16(5),n2h16(5))
Gcoeff(:)%j = (-(c(10)*M(5,:)%j)+c(9)*M(7,:)%j)
call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(6),h0tab(:,6),[16,4,1,2,8],[nMB,0,nMT,0,nMB],5,0)
  call Hloop_AV_Q(ntryL,G0H32(1),ex5(:),G0H16(1),m3h2x16(:,6),heltab2x32(:,:,6))
  call Hloop_A_Q(ntryL,G0H16(1),16,nMB,G1H16(6),n2h16(6))
Gcoeff(:)%j = (c(15)*M(3,:)%j-c(14)*M(7,:)%j)
call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(7),h0tab(:,7),[16,4,1,2,8],[nMB,nMZ,nMT,0,nMB],5,0)
  call Hloop_AV_Q(ntryL,G0H32(1),ex5(:),G0H16(1),m3h2x16(:,7),heltab2x32(:,:,7))
  call Hloop_A_Q(ntryL,G0H16(1),16,nMB,G1H16(7),n2h16(7))
Gcoeff(:)%j = (c(15)*M(5,:)%j-c(14)*M(7,:)%j)
call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(8),h0tab(:,8),[16,4,1,2,8],[nMB,0,nMT,nMZ,nMB],5,0)
  call Hloop_AV_Q(ntryL,G0H32(1),ex5(:),G0H16(1),m3h2x16(:,8),heltab2x32(:,:,8))
  call Hloop_A_Q(ntryL,G0H16(1),16,nMB,G1H16(8),n2h16(8))
Gcoeff(:)%j = (c(30)*M(2,:)%j+c(27)*(-M(4,:)%j-M(6,:)%j)+c(26)*M(8,:)%j)
call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(9),h0tab(:,9),[16,4,1,2,8],[nMB,0,nMT,0,nMB],5,0)
  call Hloop_AV_Q(ntryL,G0H32(1),ex5(:),G0H16(1),m3h2x16(:,9),heltab2x32(:,:,9))
  call Hloop_A_Q(ntryL,G0H16(1),16,nMB,G1H16(9),n2h16(9))
Gcoeff(:)%j = (c(50)*(-M(3,:)%j+M(5,:)%j))
call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(10),h0tab(:,10),[16,2,1,4,8],[0,nMT,nMH,nMB,0],5,0)
  call Hloop_UV_W(ntryL,G0H32(1),0,ex5(:),16,G1H16(10),m3h2x16(:,10),heltab2x32(:,:,10))
Gcoeff(:)%j = (c(50)*(-M(3,:)%j+M(5,:)%j))
call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(11),h0tab(:,11),[16,2,1,4,8],[0,nMT,nMZ,nMB,0],5,0)
  call Hloop_UV_W(ntryL,G0H32(1),0,ex5(:),16,G1H16(11),m3h2x16(:,11),heltab2x32(:,:,11))
Gcoeff(:)%j = (c(2)*(-M(3,:)%j+M(5,:)%j))
call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(12),h0tab(:,12),[16,2,1,4,8],[0,nMT,0,nMB,0],5,0)
  call Hloop_UV_W(ntryL,G0H32(1),0,ex5(:),16,G1H16(12),m3h2x16(:,12),heltab2x32(:,:,12))
Gcoeff(:)%j = (c(5)*(M(3,:)%j-M(5,:)%j))
call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(13),h0tab(:,13),[16,2,1,4,8],[0,nMT,nMZ,nMB,0],5,0)
  call Hloop_UV_W(ntryL,G0H32(1),0,ex5(:),16,G1H16(13),m3h2x16(:,13),heltab2x32(:,:,13))
Gcoeff(:)%j = (c(19)*(-M(4,:)%j+M(6,:)%j)+c(20)*(M(2,:)%j-M(8,:)%j))
call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(14),h0tab(:,14),[16,2,1,4,8],[0,nMT,0,nMB,0],5,0)
  call Hloop_UV_W(ntryL,G0H32(1),0,ex5(:),16,G1H16(14),m3h2x16(:,14),heltab2x32(:,:,14))
Gcoeff(:)%j = (-(c(53)*M(5,:)%j)+c(52)*M(7,:)%j)
call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(15),h0tab(:,15),[16,4,2,1,8],[nMB,0,nMT,nMH,nMB],5,0)
  call Hloop_AV_Q(ntryL,G0H32(1),ex5(:),G0H16(1),m3h2x16(:,15),heltab2x32(:,:,15))
  call Hloop_A_Q(ntryL,G0H16(1),16,nMB,G1H16(15),n2h16(10))
Gcoeff(:)%j = (-(c(53)*M(5,:)%j)+c(52)*M(7,:)%j)
call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(16),h0tab(:,16),[16,4,2,1,8],[nMB,0,nMT,nMZ,nMB],5,0)
  call Hloop_AV_Q(ntryL,G0H32(1),ex5(:),G0H16(1),m3h2x16(:,16),heltab2x32(:,:,16))
  call Hloop_A_Q(ntryL,G0H16(1),16,nMB,G1H16(16),n2h16(11))
Gcoeff(:)%j = (-(c(53)*M(3,:)%j)+c(52)*M(7,:)%j)
call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(17),h0tab(:,17),[16,4,2,1,8],[nMB,nMH,nMT,0,nMB],5,0)
  call Hloop_AV_Q(ntryL,G0H32(1),ex5(:),G0H16(1),m3h2x16(:,17),heltab2x32(:,:,17))
  call Hloop_A_Q(ntryL,G0H16(1),16,nMB,G1H16(17),n2h16(12))
Gcoeff(:)%j = (-(c(53)*M(3,:)%j)+c(52)*M(7,:)%j)
call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(18),h0tab(:,18),[16,4,2,1,8],[nMB,nMZ,nMT,0,nMB],5,0)
  call Hloop_AV_Q(ntryL,G0H32(1),ex5(:),G0H16(1),m3h2x16(:,18),heltab2x32(:,:,18))
  call Hloop_A_Q(ntryL,G0H16(1),16,nMB,G1H16(18),n2h16(13))
Gcoeff(:)%j = (-(c(10)*M(5,:)%j)+c(9)*M(7,:)%j)
call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(19),h0tab(:,19),[16,4,2,1,8],[nMB,0,nMT,0,nMB],5,0)
  call Hloop_AV_Q(ntryL,G0H32(1),ex5(:),G0H16(1),m3h2x16(:,19),heltab2x32(:,:,19))
  call Hloop_A_Q(ntryL,G0H16(1),16,nMB,G1H16(19),n2h16(14))
Gcoeff(:)%j = (-(c(10)*M(3,:)%j)+c(9)*M(7,:)%j)
call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(20),h0tab(:,20),[16,4,2,1,8],[nMB,0,nMT,0,nMB],5,0)
  call Hloop_AV_Q(ntryL,G0H32(1),ex5(:),G0H16(1),m3h2x16(:,20),heltab2x32(:,:,20))
  call Hloop_A_Q(ntryL,G0H16(1),16,nMB,G1H16(20),n2h16(15))
Gcoeff(:)%j = (c(15)*M(5,:)%j-c(14)*M(7,:)%j)
call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(21),h0tab(:,21),[16,4,2,1,8],[nMB,0,nMT,nMZ,nMB],5,0)
  call Hloop_AV_Q(ntryL,G0H32(1),ex5(:),G0H16(1),m3h2x16(:,21),heltab2x32(:,:,21))
  call Hloop_A_Q(ntryL,G0H16(1),16,nMB,G1H16(21),n2h16(16))
Gcoeff(:)%j = (c(15)*M(3,:)%j-c(14)*M(7,:)%j)
call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(22),h0tab(:,22),[16,4,2,1,8],[nMB,nMZ,nMT,0,nMB],5,0)
  call Hloop_AV_Q(ntryL,G0H32(1),ex5(:),G0H16(1),m3h2x16(:,22),heltab2x32(:,:,22))
  call Hloop_A_Q(ntryL,G0H16(1),16,nMB,G1H16(22),n2h16(17))
Gcoeff(:)%j = (c(27)*(-M(4,:)%j-M(6,:)%j)+c(26)*M(8,:)%j)
call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(23),h0tab(:,23),[16,4,2,1,8],[nMB,0,nMT,0,nMB],5,0)
  call Hloop_AV_Q(ntryL,G0H32(1),ex5(:),G0H16(1),m3h2x16(:,23),heltab2x32(:,:,23))
  call Hloop_A_Q(ntryL,G0H16(1),16,nMB,G1H16(23),n2h16(18))
Gcoeff(:)%j = (c(42)*(-M(1,:)%j+M(7,:)%j))
call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(24),h0tab(:,24),[16,4,2,1,8],[0,nMB,nMW,nMB,0],5,0)
  call Hloop_UV_W(ntryL,G0H32(1),0,ex5(:),16,G1H16(24),m3h2x16(:,24),heltab2x32(:,:,24))
Gcoeff(:)%j = (c(37)*(-M(1,:)%j+M(7,:)%j))
call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(25),h0tab(:,25),[16,4,2,1,8],[0,nMB,nMW,nMB,0],5,0)
  call Hloop_UV_W(ntryL,G0H32(1),0,ex5(:),16,G1H16(25),m3h2x16(:,25),heltab2x32(:,:,25))
Gcoeff(:)%j = (-(c(45)*M(1,:)%j)+c(44)*M(3,:)%j)
call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(26),h0tab(:,26),[16,2,1,8,4],[nMB,nMW,nMB,0,nMB],5,0)
  call Hloop_QV_A(ntryL,G0H32(1),ex5(:),G0H16(1),m3h2x16(:,26),heltab2x32(:,:,26))
  call Hloop_Q_A(ntryL,G0H16(1),16,nMB,G1H16(26),n2h16(19))
Gcoeff(:)%j = (c(44)*M(3,:)%j-c(45)*M(7,:)%j)
call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(27),h0tab(:,27),[16,2,1,8,4],[nMT,0,nMT,nMW,nMT],5,0)
  call Hloop_QV_A(ntryL,G0H32(1),ex5(:),G0H16(1),m3h2x16(:,27),heltab2x32(:,:,27))
  call Hloop_Q_A(ntryL,G0H16(1),16,nMT,G1H16(27),n2h16(20))
Gcoeff(:)%j = (c(39)*M(3,:)%j-c(40)*M(7,:)%j)
call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(28),h0tab(:,28),[16,2,1,8,4],[nMT,0,nMT,nMW,nMT],5,0)
  call Hloop_QV_A(ntryL,G0H32(1),ex5(:),G0H16(1),m3h2x16(:,28),heltab2x32(:,:,28))
  call Hloop_Q_A(ntryL,G0H16(1),16,nMT,G1H16(28),n2h16(21))
Gcoeff(:)%j = (-(c(40)*M(1,:)%j)+c(39)*M(3,:)%j)
call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(29),h0tab(:,29),[16,2,1,8,4],[nMB,nMW,nMB,0,nMB],5,0)
  call Hloop_QV_A(ntryL,G0H32(1),ex5(:),G0H16(1),m3h2x16(:,29),heltab2x32(:,:,29))
  call Hloop_Q_A(ntryL,G0H16(1),16,nMB,G1H16(29),n2h16(22))
Gcoeff(:)%j = (c(50)*(-M(3,:)%j+M(5,:)%j))
call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(30),h0tab(:,30),[16,2,1,8,4],[0,nMT,nMH,nMB,0],5,0)
  call Hloop_UV_W(ntryL,G0H32(1),0,ex5(:),16,G1H16(30),m3h2x16(:,30),heltab2x32(:,:,30))
Gcoeff(:)%j = (c(50)*(-M(3,:)%j+M(5,:)%j))
call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(31),h0tab(:,31),[16,2,1,8,4],[0,nMT,nMZ,nMB,0],5,0)
  call Hloop_UV_W(ntryL,G0H32(1),0,ex5(:),16,G1H16(31),m3h2x16(:,31),heltab2x32(:,:,31))
Gcoeff(:)%j = (c(2)*(-M(3,:)%j+M(5,:)%j))
call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(32),h0tab(:,32),[16,2,1,8,4],[0,nMT,0,nMB,0],5,0)
  call Hloop_UV_W(ntryL,G0H32(1),0,ex5(:),16,G1H16(32),m3h2x16(:,32),heltab2x32(:,:,32))
Gcoeff(:)%j = (c(5)*(M(3,:)%j-M(5,:)%j))
call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(33),h0tab(:,33),[16,2,1,8,4],[0,nMT,nMZ,nMB,0],5,0)
  call Hloop_UV_W(ntryL,G0H32(1),0,ex5(:),16,G1H16(33),m3h2x16(:,33),heltab2x32(:,:,33))
Gcoeff(:)%j = (c(21)*M(4,:)%j+c(19)*M(6,:)%j)
call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(34),h0tab(:,34),[16,2,1,8,4],[0,nMT,0,nMB,0],5,0)
  call Hloop_UV_W(ntryL,G0H32(1),0,ex5(:),16,G1H16(34),m3h2x16(:,34),heltab2x32(:,:,34))
Gcoeff(:)%j = (-(c(45)*M(1,:)%j)+c(44)*M(5,:)%j)
call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(35),h0tab(:,35),[16,1,2,4,8],[nMB,nMW,nMB,0,nMB],5,0)
  call Hloop_AV_Q(ntryL,G0H32(1),ex5(:),G0H16(1),m3h2x16(:,35),heltab2x32(:,:,35))
  call Hloop_A_Q(ntryL,G0H16(1),16,nMB,G1H16(35),n2h16(23))
Gcoeff(:)%j = (c(44)*M(5,:)%j-c(45)*M(7,:)%j)
call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(36),h0tab(:,36),[16,1,2,4,8],[nMT,0,nMT,nMW,nMT],5,0)
  call Hloop_AV_Q(ntryL,G0H32(1),ex5(:),G0H16(1),m3h2x16(:,36),heltab2x32(:,:,36))
  call Hloop_A_Q(ntryL,G0H16(1),16,nMT,G1H16(36),n2h16(24))
Gcoeff(:)%j = (c(39)*M(5,:)%j-c(40)*M(7,:)%j)
call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(37),h0tab(:,37),[16,1,2,4,8],[nMT,0,nMT,nMW,nMT],5,0)
  call Hloop_AV_Q(ntryL,G0H32(1),ex5(:),G0H16(1),m3h2x16(:,37),heltab2x32(:,:,37))
  call Hloop_A_Q(ntryL,G0H16(1),16,nMT,G1H16(37),n2h16(25))
Gcoeff(:)%j = (-(c(40)*M(1,:)%j)+c(39)*M(5,:)%j)
call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(38),h0tab(:,38),[16,1,2,4,8],[nMB,nMW,nMB,0,nMB],5,0)
  call Hloop_AV_Q(ntryL,G0H32(1),ex5(:),G0H16(1),m3h2x16(:,38),heltab2x32(:,:,38))
  call Hloop_A_Q(ntryL,G0H16(1),16,nMB,G1H16(38),n2h16(26))
Gcoeff(:)%j = (c(50)*(-M(3,:)%j+M(5,:)%j))
call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(39),h0tab(:,39),[16,1,2,4,8],[0,nMT,nMH,nMB,0],5,0)
  call Hloop_UV_W(ntryL,G0H32(1),0,ex5(:),16,G1H16(39),m3h2x16(:,39),heltab2x32(:,:,39))
Gcoeff(:)%j = (c(50)*(-M(3,:)%j+M(5,:)%j))
call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(40),h0tab(:,40),[16,1,2,4,8],[0,nMT,nMZ,nMB,0],5,0)
  call Hloop_UV_W(ntryL,G0H32(1),0,ex5(:),16,G1H16(40),m3h2x16(:,40),heltab2x32(:,:,40))
Gcoeff(:)%j = (c(2)*(-M(3,:)%j+M(5,:)%j))
call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(41),h0tab(:,41),[16,1,2,4,8],[0,nMT,0,nMB,0],5,0)
  call Hloop_UV_W(ntryL,G0H32(1),0,ex5(:),16,G1H16(41),m3h2x16(:,41),heltab2x32(:,:,41))
Gcoeff(:)%j = (c(5)*(M(3,:)%j-M(5,:)%j))
call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(42),h0tab(:,42),[16,1,2,4,8],[0,nMT,nMZ,nMB,0],5,0)
  call Hloop_UV_W(ntryL,G0H32(1),0,ex5(:),16,G1H16(42),m3h2x16(:,42),heltab2x32(:,:,42))
Gcoeff(:)%j = (-(c(19)*M(4,:)%j)-c(21)*M(6,:)%j)
call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(43),h0tab(:,43),[16,1,2,4,8],[0,nMT,0,nMB,0],5,0)
  call Hloop_UV_W(ntryL,G0H32(1),0,ex5(:),16,G1H16(43),m3h2x16(:,43),heltab2x32(:,:,43))
Gcoeff(:)%j = (c(50)*(-M(3,:)%j+M(5,:)%j))
call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(44),h0tab(:,44),[16,1,2,8,4],[0,nMT,nMH,nMB,0],5,0)
  call Hloop_UV_W(ntryL,G0H32(1),0,ex5(:),16,G1H16(44),m3h2x16(:,44),heltab2x32(:,:,44))
Gcoeff(:)%j = (c(50)*(-M(3,:)%j+M(5,:)%j))
call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(45),h0tab(:,45),[16,1,2,8,4],[0,nMT,nMZ,nMB,0],5,0)
  call Hloop_UV_W(ntryL,G0H32(1),0,ex5(:),16,G1H16(45),m3h2x16(:,45),heltab2x32(:,:,45))
Gcoeff(:)%j = (c(2)*(-M(3,:)%j+M(5,:)%j))
call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(46),h0tab(:,46),[16,1,2,8,4],[0,nMT,0,nMB,0],5,0)
  call Hloop_UV_W(ntryL,G0H32(1),0,ex5(:),16,G1H16(46),m3h2x16(:,46),heltab2x32(:,:,46))
Gcoeff(:)%j = (c(5)*(M(3,:)%j-M(5,:)%j))
call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(47),h0tab(:,47),[16,1,2,8,4],[0,nMT,nMZ,nMB,0],5,0)
  call Hloop_UV_W(ntryL,G0H32(1),0,ex5(:),16,G1H16(47),m3h2x16(:,47),heltab2x32(:,:,47))
Gcoeff(:)%j = (c(19)*(-M(4,:)%j+M(6,:)%j)+c(20)*(-M(2,:)%j+M(8,:)%j))
call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(48),h0tab(:,48),[16,1,2,8,4],[0,nMT,0,nMB,0],5,0)
  call Hloop_UV_W(ntryL,G0H32(1),0,ex5(:),16,G1H16(48),m3h2x16(:,48),heltab2x32(:,:,48))
Gcoeff(:)%j = (c(42)*(-M(1,:)%j+M(7,:)%j))
call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(49),h0tab(:,49),[16,2,4,1,8],[0,nMT,nMW,nMB,0],5,0)
  call Hloop_UV_W(ntryL,G0H32(1),0,ex5(:),16,G1H16(49),m3h2x16(:,49),heltab2x32(:,:,49))
Gcoeff(:)%j = (c(37)*(-M(1,:)%j+M(7,:)%j))
call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(50),h0tab(:,50),[16,2,4,1,8],[0,nMT,nMW,nMB,0],5,0)
  call Hloop_UV_W(ntryL,G0H32(1),0,ex5(:),16,G1H16(50),m3h2x16(:,50),heltab2x32(:,:,50))
Gcoeff(:)%j = (c(44)*M(3,:)%j-c(45)*M(7,:)%j)
call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(51),h0tab(:,51),[16,2,8,1,4],[nMT,0,nMB,nMW,nMT],5,0)
  call Hloop_QV_A(ntryL,G0H32(1),ex5(:),G0H16(1),m3h2x16(:,51),heltab2x32(:,:,51))
  call Hloop_Q_A(ntryL,G0H16(1),16,nMT,G1H16(51),n2h16(27))
Gcoeff(:)%j = (-(c(45)*M(1,:)%j)+c(44)*M(3,:)%j)
call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(52),h0tab(:,52),[16,2,8,1,4],[nMB,nMW,nMT,0,nMB],5,0)
  call Hloop_QV_A(ntryL,G0H32(1),ex5(:),G0H16(1),m3h2x16(:,52),heltab2x32(:,:,52))
  call Hloop_Q_A(ntryL,G0H16(1),16,nMB,G1H16(52),n2h16(28))
Gcoeff(:)%j = (c(39)*M(3,:)%j-c(40)*M(7,:)%j)
call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(53),h0tab(:,53),[16,2,8,1,4],[nMT,0,nMB,nMW,nMT],5,0)
  call Hloop_QV_A(ntryL,G0H32(1),ex5(:),G0H16(1),m3h2x16(:,53),heltab2x32(:,:,53))
  call Hloop_Q_A(ntryL,G0H16(1),16,nMT,G1H16(53),n2h16(29))
Gcoeff(:)%j = (-(c(40)*M(1,:)%j)+c(39)*M(3,:)%j)
call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(54),h0tab(:,54),[16,2,8,1,4],[nMB,nMW,nMT,0,nMB],5,0)
  call Hloop_QV_A(ntryL,G0H32(1),ex5(:),G0H16(1),m3h2x16(:,54),heltab2x32(:,:,54))
  call Hloop_Q_A(ntryL,G0H16(1),16,nMB,G1H16(54),n2h16(30))
Gcoeff(:)%j = (-(c(45)*M(1,:)%j)+c(44)*M(5,:)%j)
call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(55),h0tab(:,55),[16,1,4,2,8],[nMB,nMW,nMT,0,nMB],5,0)
  call Hloop_AV_Q(ntryL,G0H32(1),ex5(:),G0H16(1),m3h2x16(:,55),heltab2x32(:,:,55))
  call Hloop_A_Q(ntryL,G0H16(1),16,nMB,G1H16(55),n2h16(31))
Gcoeff(:)%j = (c(44)*M(5,:)%j-c(45)*M(7,:)%j)
call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(56),h0tab(:,56),[16,1,4,2,8],[nMT,0,nMB,nMW,nMT],5,0)
  call Hloop_AV_Q(ntryL,G0H32(1),ex5(:),G0H16(1),m3h2x16(:,56),heltab2x32(:,:,56))
  call Hloop_A_Q(ntryL,G0H16(1),16,nMT,G1H16(56),n2h16(32))
Gcoeff(:)%j = (c(39)*M(5,:)%j-c(40)*M(7,:)%j)
call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(57),h0tab(:,57),[16,1,4,2,8],[nMT,0,nMB,nMW,nMT],5,0)
  call Hloop_AV_Q(ntryL,G0H32(1),ex5(:),G0H16(1),m3h2x16(:,57),heltab2x32(:,:,57))
  call Hloop_A_Q(ntryL,G0H16(1),16,nMT,G1H16(57),n2h16(33))
Gcoeff(:)%j = (-(c(40)*M(1,:)%j)+c(39)*M(5,:)%j)
call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(58),h0tab(:,58),[16,1,4,2,8],[nMB,nMW,nMT,0,nMB],5,0)
  call Hloop_AV_Q(ntryL,G0H32(1),ex5(:),G0H16(1),m3h2x16(:,58),heltab2x32(:,:,58))
  call Hloop_A_Q(ntryL,G0H16(1),16,nMB,G1H16(58),n2h16(34))
Gcoeff(:)%j = (c(52)*M(1,:)%j-c(53)*M(5,:)%j)
call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(59),h0tab(:,59),[16,1,4,8,2],[nMT,nMH,nMB,0,nMT],5,0)
  call Hloop_AV_Q(ntryL,G0H32(1),ex5(:),G0H16(1),m3h2x16(:,59),heltab2x32(:,:,59))
  call Hloop_A_Q(ntryL,G0H16(1),16,nMT,G1H16(59),n2h16(35))
Gcoeff(:)%j = (c(52)*M(1,:)%j-c(53)*M(5,:)%j)
call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(60),h0tab(:,60),[16,1,4,8,2],[nMT,nMZ,nMB,0,nMT],5,0)
  call Hloop_AV_Q(ntryL,G0H32(1),ex5(:),G0H16(1),m3h2x16(:,60),heltab2x32(:,:,60))
  call Hloop_A_Q(ntryL,G0H16(1),16,nMT,G1H16(60),n2h16(36))
Gcoeff(:)%j = (c(52)*M(1,:)%j-c(53)*M(3,:)%j)
call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(61),h0tab(:,61),[16,1,4,8,2],[nMT,0,nMB,nMH,nMT],5,0)
  call Hloop_AV_Q(ntryL,G0H32(1),ex5(:),G0H16(1),m3h2x16(:,61),heltab2x32(:,:,61))
  call Hloop_A_Q(ntryL,G0H16(1),16,nMT,G1H16(61),n2h16(37))
Gcoeff(:)%j = (c(52)*M(1,:)%j-c(53)*M(3,:)%j)
call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(62),h0tab(:,62),[16,1,4,8,2],[nMT,0,nMB,nMZ,nMT],5,0)
  call Hloop_AV_Q(ntryL,G0H32(1),ex5(:),G0H16(1),m3h2x16(:,62),heltab2x32(:,:,62))
  call Hloop_A_Q(ntryL,G0H16(1),16,nMT,G1H16(62),n2h16(38))
Gcoeff(:)%j = (c(9)*M(1,:)%j-c(10)*M(5,:)%j)
call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(63),h0tab(:,63),[16,1,4,8,2],[nMT,0,nMB,0,nMT],5,0)
  call Hloop_AV_Q(ntryL,G0H32(1),ex5(:),G0H16(1),m3h2x16(:,63),heltab2x32(:,:,63))
  call Hloop_A_Q(ntryL,G0H16(1),16,nMT,G1H16(63),n2h16(39))
Gcoeff(:)%j = (c(9)*M(1,:)%j-c(10)*M(3,:)%j)
call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(64),h0tab(:,64),[16,1,4,8,2],[nMT,0,nMB,0,nMT],5,0)
  call Hloop_AV_Q(ntryL,G0H32(1),ex5(:),G0H16(1),m3h2x16(:,64),heltab2x32(:,:,64))
  call Hloop_A_Q(ntryL,G0H16(1),16,nMT,G1H16(64),n2h16(40))
Gcoeff(:)%j = (-(c(14)*M(1,:)%j)+c(15)*M(5,:)%j)
call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(65),h0tab(:,65),[16,1,4,8,2],[nMT,nMZ,nMB,0,nMT],5,0)
  call Hloop_AV_Q(ntryL,G0H32(1),ex5(:),G0H16(1),m3h2x16(:,65),heltab2x32(:,:,65))
  call Hloop_A_Q(ntryL,G0H16(1),16,nMT,G1H16(65),n2h16(41))
Gcoeff(:)%j = (-(c(14)*M(1,:)%j)+c(15)*M(3,:)%j)
call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(66),h0tab(:,66),[16,1,4,8,2],[nMT,0,nMB,nMZ,nMT],5,0)
  call Hloop_AV_Q(ntryL,G0H32(1),ex5(:),G0H16(1),m3h2x16(:,66),heltab2x32(:,:,66))
  call Hloop_A_Q(ntryL,G0H16(1),16,nMT,G1H16(66),n2h16(42))
Gcoeff(:)%j = (c(26)*M(2,:)%j+c(27)*(-M(4,:)%j-M(6,:)%j)+c(30)*M(8,:)%j)
call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(67),h0tab(:,67),[16,1,4,8,2],[nMT,0,nMB,0,nMT],5,0)
  call Hloop_AV_Q(ntryL,G0H32(1),ex5(:),G0H16(1),m3h2x16(:,67),heltab2x32(:,:,67))
  call Hloop_A_Q(ntryL,G0H16(1),16,nMT,G1H16(67),n2h16(43))
Gcoeff(:)%j = (c(42)*(M(1,:)%j-M(7,:)%j))
call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(68),h0tab(:,68),[16,1,8,2,4],[0,nMT,nMW,nMB,0],5,0)
  call Hloop_UV_W(ntryL,G0H32(1),0,ex5(:),16,G1H16(68),m3h2x16(:,68),heltab2x32(:,:,68))
Gcoeff(:)%j = (c(37)*(M(1,:)%j-M(7,:)%j))
call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(69),h0tab(:,69),[16,1,8,2,4],[0,nMT,nMW,nMB,0],5,0)
  call Hloop_UV_W(ntryL,G0H32(1),0,ex5(:),16,G1H16(69),m3h2x16(:,69),heltab2x32(:,:,69))
Gcoeff(:)%j = (c(52)*M(1,:)%j-c(53)*M(5,:)%j)
call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(70),h0tab(:,70),[16,1,8,4,2],[nMT,nMH,nMB,0,nMT],5,0)
  call Hloop_AV_Q(ntryL,G0H32(1),ex5(:),G0H16(1),m3h2x16(:,70),heltab2x32(:,:,70))
  call Hloop_A_Q(ntryL,G0H16(1),16,nMT,G1H16(70),n2h16(44))
Gcoeff(:)%j = (c(52)*M(1,:)%j-c(53)*M(5,:)%j)
call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(71),h0tab(:,71),[16,1,8,4,2],[nMT,nMZ,nMB,0,nMT],5,0)
  call Hloop_AV_Q(ntryL,G0H32(1),ex5(:),G0H16(1),m3h2x16(:,71),heltab2x32(:,:,71))
  call Hloop_A_Q(ntryL,G0H16(1),16,nMT,G1H16(71),n2h16(45))
Gcoeff(:)%j = (c(52)*M(1,:)%j-c(53)*M(3,:)%j)
call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(72),h0tab(:,72),[16,1,8,4,2],[nMT,0,nMB,nMH,nMT],5,0)
  call Hloop_AV_Q(ntryL,G0H32(1),ex5(:),G0H16(1),m3h2x16(:,72),heltab2x32(:,:,72))
  call Hloop_A_Q(ntryL,G0H16(1),16,nMT,G1H16(72),n2h16(46))
Gcoeff(:)%j = (c(52)*M(1,:)%j-c(53)*M(3,:)%j)
call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(73),h0tab(:,73),[16,1,8,4,2],[nMT,0,nMB,nMZ,nMT],5,0)
  call Hloop_AV_Q(ntryL,G0H32(1),ex5(:),G0H16(1),m3h2x16(:,73),heltab2x32(:,:,73))
  call Hloop_A_Q(ntryL,G0H16(1),16,nMT,G1H16(73),n2h16(47))
Gcoeff(:)%j = (c(9)*M(1,:)%j-c(10)*M(5,:)%j)
call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(74),h0tab(:,74),[16,1,8,4,2],[nMT,0,nMB,0,nMT],5,0)
  call Hloop_AV_Q(ntryL,G0H32(1),ex5(:),G0H16(1),m3h2x16(:,74),heltab2x32(:,:,74))
  call Hloop_A_Q(ntryL,G0H16(1),16,nMT,G1H16(74),n2h16(48))
Gcoeff(:)%j = (c(9)*M(1,:)%j-c(10)*M(3,:)%j)
call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(75),h0tab(:,75),[16,1,8,4,2],[nMT,0,nMB,0,nMT],5,0)
  call Hloop_AV_Q(ntryL,G0H32(1),ex5(:),G0H16(1),m3h2x16(:,75),heltab2x32(:,:,75))
  call Hloop_A_Q(ntryL,G0H16(1),16,nMT,G1H16(75),n2h16(49))
Gcoeff(:)%j = (-(c(14)*M(1,:)%j)+c(15)*M(5,:)%j)
call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(76),h0tab(:,76),[16,1,8,4,2],[nMT,nMZ,nMB,0,nMT],5,0)
  call Hloop_AV_Q(ntryL,G0H32(1),ex5(:),G0H16(1),m3h2x16(:,76),heltab2x32(:,:,76))
  call Hloop_A_Q(ntryL,G0H16(1),16,nMT,G1H16(76),n2h16(50))
Gcoeff(:)%j = (-(c(14)*M(1,:)%j)+c(15)*M(3,:)%j)
call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(77),h0tab(:,77),[16,1,8,4,2],[nMT,0,nMB,nMZ,nMT],5,0)
  call Hloop_AV_Q(ntryL,G0H32(1),ex5(:),G0H16(1),m3h2x16(:,77),heltab2x32(:,:,77))
  call Hloop_A_Q(ntryL,G0H16(1),16,nMT,G1H16(77),n2h16(51))
Gcoeff(:)%j = (c(26)*M(2,:)%j+c(27)*(-M(4,:)%j-M(6,:)%j))
call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(78),h0tab(:,78),[16,1,8,4,2],[nMT,0,nMB,0,nMT],5,0)
  call Hloop_AV_Q(ntryL,G0H32(1),ex5(:),G0H16(1),m3h2x16(:,78),heltab2x32(:,:,78))
  call Hloop_A_Q(ntryL,G0H16(1),16,nMT,G1H16(78),n2h16(52))
Gcoeff(:)%j = (c(42)*(M(1,:)%j-M(7,:)%j))
call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(79),h0tab(:,79),[16,1,8,4,2],[0,nMT,nMW,nMT,0],5,0)
  call Hloop_UV_W(ntryL,G0H32(1),0,ex5(:),16,G1H16(79),m3h2x16(:,79),heltab2x32(:,:,79))
Gcoeff(:)%j = (c(37)*(M(1,:)%j-M(7,:)%j))
call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(80),h0tab(:,80),[16,1,8,4,2],[0,nMT,nMW,nMT,0],5,0)
  call Hloop_UV_W(ntryL,G0H32(1),0,ex5(:),16,G1H16(80),m3h2x16(:,80),heltab2x32(:,:,80))
  call ol_merge(ntryL,G1H16(9),[G1H16(6),G1H16(5)])
  call ol_merge(ntryL,G1H16(14),[G1H16(12)])
  call ol_merge(ntryL,G1H16(23),[G1H16(20),G1H16(19)])
  call ol_merge(ntryL,G1H16(34),[G1H16(32)])
  call ol_merge(ntryL,G1H16(43),[G1H16(41)])
  call ol_merge(ntryL,G1H16(48),[G1H16(46)])
  call ol_merge(ntryL,G1H16(67),[G1H16(64),G1H16(63)])
  call ol_merge(ntryL,G1H16(78),[G1H16(75),G1H16(74)])
  call Hloop_AQ_S(ntryL,G1H16(1),ex3(:),G1H8(1),ngH,m3h2x8(:,1),heltab2x16(:,:,1))
  call Hloop_AQ_S(ntryL,G1H16(2),ex3(:),G1H8(2),ngX,m3h2x8(:,2),heltab2x16(:,:,2))
  call Hloop_AQ_V(ntryL,G1H16(3),ex3(:),G1H8(3),m3h2x8(:,3),heltab2x16(:,:,3))
  call Hloop_AQ_V(ntryL,G1H16(4),ex3(:),G1H8(4),m3h2x8(:,4),heltab2x16(:,:,4))
  call Hloop_AQ_V(ntryL,G1H16(9),ex3(:),G1H8(5),m3h2x8(:,5),heltab2x16(:,:,5))
  call Hloop_AQ_Z(ntryL,G1H16(7),ex3(:),G1H8(6),ngZd,m3h2x8(:,6),heltab2x16(:,:,6))
  call Hloop_AQ_V(ntryL,G1H16(8),ex3(:),G1H8(7),m3h2x8(:,7),heltab2x16(:,:,7))
  call Hloop_VA_Q(ntryL,G1H16(10),ex2(:),G1H8(8),m3h2x8(:,8),heltab2x16(:,:,8))
  call Hloop_A_Q(ntryL,G1H8(8),18,nMT,G2H8(1),n2h8(1))
  call Hloop_VA_Q(ntryL,G1H16(11),ex2(:),G1H8(8),m3h2x8(:,9),heltab2x16(:,:,9))
  call Hloop_A_Q(ntryL,G1H8(8),18,nMT,G2H8(2),n2h8(2))
  call Hloop_VA_Q(ntryL,G1H16(14),ex2(:),G1H8(8),m3h2x8(:,10),heltab2x16(:,:,10))
  call Hloop_A_Q(ntryL,G1H8(8),18,nMT,G2H8(3),n2h8(3))
  call Hloop_VA_Q(ntryL,G1H16(13),ex2(:),G1H8(8),m3h2x8(:,11),heltab2x16(:,:,11))
  call Hloop_A_Q(ntryL,G1H8(8),18,nMT,G2H8(4),n2h8(4))
  call Hloop_AQ_V(ntryL,G1H16(15),ex3(:),G1H8(8),m3h2x8(:,12),heltab2x16(:,:,12))
  call Hloop_AQ_V(ntryL,G1H16(16),ex3(:),G1H8(9),m3h2x8(:,13),heltab2x16(:,:,13))
  call Hloop_AQ_S(ntryL,G1H16(17),ex3(:),G1H8(10),ngH,m3h2x8(:,14),heltab2x16(:,:,14))
  call Hloop_AQ_S(ntryL,G1H16(18),ex3(:),G1H8(11),ngX,m3h2x8(:,15),heltab2x16(:,:,15))
  call Hloop_AQ_V(ntryL,G1H16(23),ex3(:),G1H8(12),m3h2x8(:,16),heltab2x16(:,:,16))
  call Hloop_AQ_V(ntryL,G1H16(21),ex3(:),G1H8(13),m3h2x8(:,17),heltab2x16(:,:,17))
  call Hloop_AQ_Z(ntryL,G1H16(22),ex3(:),G1H8(14),ngZd,m3h2x8(:,18),heltab2x16(:,:,18))
  call Hloop_VQ_A(ntryL,G1H16(24),ex3(:),G1H8(15),m3h2x8(:,19),heltab2x16(:,:,19))
  call Hloop_Q_A(ntryL,G1H8(15),20,nMB,G2H8(5),n2h8(5))
  call Hloop_VQ_A(ntryL,G1H16(25),ex3(:),G1H8(15),m3h2x8(:,20),heltab2x16(:,:,20))
  call Hloop_Q_A(ntryL,G1H8(15),20,nMB,G2H8(6),n2h8(6))
  call Hloop_QA_S(ntryL,G1H16(26),ex2(:),G1H8(15),ngPtb,m3h2x8(:,21),heltab2x16(:,:,21))
  call Hloop_QA_V(ntryL,G1H16(27),ex2(:),G1H8(16),m3h2x8(:,22),heltab2x16(:,:,22))
  call Hloop_QA_V(ntryL,G1H16(28),ex2(:),G1H8(17),m3h2x8(:,23),heltab2x16(:,:,23))
  call Hloop_QA_W(ntryL,G1H16(29),ex2(:),G1H8(18),m3h2x8(:,24),heltab2x16(:,:,24))
  call Hloop_VA_Q(ntryL,G1H16(30),ex2(:),G1H8(19),m3h2x8(:,25),heltab2x16(:,:,25))
  call Hloop_A_Q(ntryL,G1H8(19),18,nMT,G2H8(7),n2h8(7))
  call Hloop_VA_Q(ntryL,G1H16(31),ex2(:),G1H8(19),m3h2x8(:,26),heltab2x16(:,:,26))
  call Hloop_A_Q(ntryL,G1H8(19),18,nMT,G2H8(8),n2h8(8))
  call Hloop_VA_Q(ntryL,G1H16(34),ex2(:),G1H8(19),m3h2x8(:,27),heltab2x16(:,:,27))
  call Hloop_A_Q(ntryL,G1H8(19),18,nMT,G2H8(9),n2h8(9))
  call Hloop_VA_Q(ntryL,G1H16(33),ex2(:),G1H8(19),m3h2x8(:,28),heltab2x16(:,:,28))
  call Hloop_A_Q(ntryL,G1H8(19),18,nMT,G2H8(10),n2h8(10))
  call Hloop_AQ_S(ntryL,G1H16(35),ex1(:),G1H8(19),ngPbt,m3h2x8(:,29),heltab2x16(:,:,29))
  call Hloop_AQ_V(ntryL,G1H16(36),ex1(:),G1H8(20),m3h2x8(:,30),heltab2x16(:,:,30))
  call Hloop_AQ_V(ntryL,G1H16(37),ex1(:),G1H8(21),m3h2x8(:,31),heltab2x16(:,:,31))
  call Hloop_AQ_W(ntryL,G1H16(38),ex1(:),G1H8(22),m3h2x8(:,32),heltab2x16(:,:,32))
  call Hloop_VQ_A(ntryL,G1H16(39),ex1(:),G1H8(23),m3h2x8(:,33),heltab2x16(:,:,33))
  call Hloop_Q_A(ntryL,G1H8(23),17,nMT,G2H8(11),n2h8(11))
  call Hloop_VQ_A(ntryL,G1H16(40),ex1(:),G1H8(23),m3h2x8(:,34),heltab2x16(:,:,34))
  call Hloop_Q_A(ntryL,G1H8(23),17,nMT,G2H8(12),n2h8(12))
  call Hloop_VQ_A(ntryL,G1H16(43),ex1(:),G1H8(23),m3h2x8(:,35),heltab2x16(:,:,35))
  call Hloop_Q_A(ntryL,G1H8(23),17,nMT,G2H8(13),n2h8(13))
  call Hloop_VQ_A(ntryL,G1H16(42),ex1(:),G1H8(23),m3h2x8(:,36),heltab2x16(:,:,36))
  call Hloop_Q_A(ntryL,G1H8(23),17,nMT,G2H8(14),n2h8(14))
  call Hloop_VQ_A(ntryL,G1H16(44),ex1(:),G1H8(23),m3h2x8(:,37),heltab2x16(:,:,37))
  call Hloop_Q_A(ntryL,G1H8(23),17,nMT,G2H8(15),n2h8(15))
  call Hloop_VQ_A(ntryL,G1H16(45),ex1(:),G1H8(23),m3h2x8(:,38),heltab2x16(:,:,38))
  call Hloop_Q_A(ntryL,G1H8(23),17,nMT,G2H8(16),n2h8(16))
  call Hloop_VQ_A(ntryL,G1H16(48),ex1(:),G1H8(23),m3h2x8(:,39),heltab2x16(:,:,39))
  call Hloop_Q_A(ntryL,G1H8(23),17,nMT,G2H8(17),n2h8(17))
  call Hloop_VQ_A(ntryL,G1H16(47),ex1(:),G1H8(23),m3h2x8(:,40),heltab2x16(:,:,40))
  call Hloop_Q_A(ntryL,G1H8(23),17,nMT,G2H8(18),n2h8(18))
  call Hloop_VA_Q(ntryL,G1H16(49),ex2(:),G1H8(23),m3h2x8(:,41),heltab2x16(:,:,41))
  call Hloop_A_Q(ntryL,G1H8(23),18,nMT,G2H8(19),n2h8(19))
  call Hloop_VA_Q(ntryL,G1H16(50),ex2(:),G1H8(23),m3h2x8(:,42),heltab2x16(:,:,42))
  call Hloop_A_Q(ntryL,G1H8(23),18,nMT,G2H8(20),n2h8(20))
  call Hloop_QA_V(ntryL,G1H16(51),ex2(:),G1H8(23),m3h2x8(:,43),heltab2x16(:,:,43))
  call Hloop_QA_S(ntryL,G1H16(52),ex2(:),G1H8(24),ngPtb,m3h2x8(:,44),heltab2x16(:,:,44))
  call Hloop_QA_V(ntryL,G1H16(53),ex2(:),G1H8(25),m3h2x8(:,45),heltab2x16(:,:,45))
  call Hloop_QA_W(ntryL,G1H16(54),ex2(:),G1H8(26),m3h2x8(:,46),heltab2x16(:,:,46))
  call Hloop_AQ_S(ntryL,G1H16(55),ex1(:),G1H8(27),ngPbt,m3h2x8(:,47),heltab2x16(:,:,47))
  call Hloop_AQ_V(ntryL,G1H16(56),ex1(:),G1H8(28),m3h2x8(:,48),heltab2x16(:,:,48))
  call Hloop_AQ_V(ntryL,G1H16(57),ex1(:),G1H8(29),m3h2x8(:,49),heltab2x16(:,:,49))
  call Hloop_AQ_W(ntryL,G1H16(58),ex1(:),G1H8(30),m3h2x8(:,50),heltab2x16(:,:,50))
  call Hloop_AQ_S(ntryL,G1H16(59),ex1(:),G1H8(31),ngH,m3h2x8(:,51),heltab2x16(:,:,51))
  call Hloop_AQ_S(ntryL,G1H16(60),ex1(:),G1H8(32),ngX,m3h2x8(:,52),heltab2x16(:,:,52))
  call Hloop_AQ_V(ntryL,G1H16(61),ex1(:),G1H8(33),m3h2x8(:,53),heltab2x16(:,:,53))
  call Hloop_AQ_V(ntryL,G1H16(62),ex1(:),G1H8(34),m3h2x8(:,54),heltab2x16(:,:,54))
  call Hloop_AQ_V(ntryL,G1H16(67),ex1(:),G1H8(35),m3h2x8(:,55),heltab2x16(:,:,55))
  call Hloop_AQ_Z(ntryL,G1H16(65),ex1(:),G1H8(36),ngZu,m3h2x8(:,56),heltab2x16(:,:,56))
  call Hloop_AQ_V(ntryL,G1H16(66),ex1(:),G1H8(37),m3h2x8(:,57),heltab2x16(:,:,57))
  call Hloop_VQ_A(ntryL,G1H16(68),ex1(:),G1H8(38),m3h2x8(:,58),heltab2x16(:,:,58))
  call Hloop_Q_A(ntryL,G1H8(38),17,nMT,G2H8(21),n2h8(21))
  call Hloop_VQ_A(ntryL,G1H16(69),ex1(:),G1H8(38),m3h2x8(:,59),heltab2x16(:,:,59))
  call Hloop_Q_A(ntryL,G1H8(38),17,nMT,G2H8(22),n2h8(22))
  call Hloop_AQ_S(ntryL,G1H16(70),ex1(:),G1H8(38),ngH,m3h2x8(:,60),heltab2x16(:,:,60))
  call Hloop_AQ_S(ntryL,G1H16(71),ex1(:),G1H8(39),ngX,m3h2x8(:,61),heltab2x16(:,:,61))
  call Hloop_AQ_V(ntryL,G1H16(72),ex1(:),G1H8(40),m3h2x8(:,62),heltab2x16(:,:,62))
  call Hloop_AQ_V(ntryL,G1H16(73),ex1(:),G1H8(41),m3h2x8(:,63),heltab2x16(:,:,63))
  call Hloop_AQ_V(ntryL,G1H16(78),ex1(:),G1H8(42),m3h2x8(:,64),heltab2x16(:,:,64))
  call Hloop_AQ_Z(ntryL,G1H16(76),ex1(:),G1H8(43),ngZu,m3h2x8(:,65),heltab2x16(:,:,65))
  call Hloop_AQ_V(ntryL,G1H16(77),ex1(:),G1H8(44),m3h2x8(:,66),heltab2x16(:,:,66))
  call Hloop_VQ_A(ntryL,G1H16(79),ex1(:),G1H8(45),m3h2x8(:,67),heltab2x16(:,:,67))
  call Hloop_Q_A(ntryL,G1H8(45),17,nMT,G2H8(23),n2h8(23))
  call Hloop_VQ_A(ntryL,G1H16(80),ex1(:),G1H8(45),m3h2x8(:,68),heltab2x16(:,:,68))
  call Hloop_Q_A(ntryL,G1H8(45),17,nMT,G2H8(24),n2h8(24))
  call Hloop_SQ_A(ntryL,G1H8(1),ex1(:),G1H4(1),ngH,m3h2x4(:,1),heltab2x8(:,:,1))
  call Hloop_Q_A(ntryL,G1H4(1),21,nMT,G2H4(1),n2h4(1))
  call Hloop_SQ_A(ntryL,G1H8(2),ex1(:),G1H4(1),ngX,m3h2x4(:,2),heltab2x8(:,:,2))
  call Hloop_Q_A(ntryL,G1H4(1),21,nMT,G2H4(2),n2h4(2))
  call Hloop_VQ_A(ntryL,G1H8(3),ex1(:),G1H4(1),m3h2x4(:,3),heltab2x8(:,:,3))
  call Hloop_Q_A(ntryL,G1H4(1),21,nMT,G2H4(3),n2h4(3))
  call Hloop_VQ_A(ntryL,G1H8(4),ex1(:),G1H4(1),m3h2x4(:,4),heltab2x8(:,:,4))
  call Hloop_Q_A(ntryL,G1H4(1),21,nMT,G2H4(4),n2h4(4))
  call Hloop_VQ_A(ntryL,G1H8(5),ex1(:),G1H4(1),m3h2x4(:,5),heltab2x8(:,:,5))
  call Hloop_Q_A(ntryL,G1H4(1),21,nMT,G2H4(5),n2h4(5))
  call Hloop_ZQ_A(ntryL,G1H8(6),ex1(:),G1H4(1),ngZu,m3h2x4(:,6),heltab2x8(:,:,6))
  call Hloop_Q_A(ntryL,G1H4(1),21,nMT,G2H4(6),n2h4(6))
  call Hloop_VQ_A(ntryL,G1H8(7),ex1(:),G1H4(1),m3h2x4(:,7),heltab2x8(:,:,7))
  call Hloop_Q_A(ntryL,G1H4(1),21,nMT,G2H4(7),n2h4(7))
  call Hloop_AQ_S(ntryL,G2H8(1),ex1(:),G2H4(8),ngH,m3h2x4(:,8),heltab2x8(:,:,8))
  call Hloop_AQ_S(ntryL,G2H8(2),ex1(:),G2H4(9),ngX,m3h2x4(:,9),heltab2x8(:,:,9))
  call Hloop_AQ_V(ntryL,G2H8(3),ex1(:),G2H4(10),m3h2x4(:,10),heltab2x8(:,:,10))
  call Hloop_AQ_Z(ntryL,G2H8(4),ex1(:),G2H4(11),ngZu,m3h2x4(:,11),heltab2x8(:,:,11))
  call Hloop_VA_Q(ntryL,G1H8(8),ex2(:),G1H4(1),m3h2x4(:,12),heltab2x8(:,:,12))
  call Hloop_A_Q(ntryL,G1H4(1),22,nMT,G2H4(12),n2h4(8))
  call Hloop_VA_Q(ntryL,G1H8(9),ex2(:),G1H4(1),m3h2x4(:,13),heltab2x8(:,:,13))
  call Hloop_A_Q(ntryL,G1H4(1),22,nMT,G2H4(13),n2h4(9))
  call Hloop_SA_Q(ntryL,G1H8(10),ex2(:),G1H4(1),ngH,m3h2x4(:,14),heltab2x8(:,:,14))
  call Hloop_A_Q(ntryL,G1H4(1),22,nMT,G2H4(14),n2h4(10))
  call Hloop_SA_Q(ntryL,G1H8(11),ex2(:),G1H4(1),ngX,m3h2x4(:,15),heltab2x8(:,:,15))
  call Hloop_A_Q(ntryL,G1H4(1),22,nMT,G2H4(15),n2h4(11))
  call Hloop_VA_Q(ntryL,G1H8(12),ex2(:),G1H4(1),m3h2x4(:,16),heltab2x8(:,:,16))
  call Hloop_A_Q(ntryL,G1H4(1),22,nMT,G2H4(16),n2h4(12))
  call Hloop_VA_Q(ntryL,G1H8(13),ex2(:),G1H4(1),m3h2x4(:,17),heltab2x8(:,:,17))
  call Hloop_A_Q(ntryL,G1H4(1),22,nMT,G2H4(17),n2h4(13))
  call Hloop_ZA_Q(ntryL,G1H8(14),ex2(:),G1H4(1),ngZu,m3h2x4(:,18),heltab2x8(:,:,18))
  call Hloop_A_Q(ntryL,G1H4(1),22,nMT,G2H4(18),n2h4(14))
  call Hloop_QA_S(ntryL,G2H8(5),ex2(:),G2H4(19),ngPtb,m3h2x4(:,19),heltab2x8(:,:,19))
  call Hloop_QA_W(ntryL,G2H8(6),ex2(:),G2H4(20),m3h2x4(:,20),heltab2x8(:,:,20))
  call Hloop_SQ_A(ntryL,G1H8(15),ex1(:),G1H4(1),ngPbt,m3h2x4(:,21),heltab2x8(:,:,21))
  call Hloop_Q_A(ntryL,G1H4(1),19,nMB,G2H4(21),n2h4(15))
  call Hloop_VQ_A(ntryL,G1H8(16),ex1(:),G1H4(1),m3h2x4(:,22),heltab2x8(:,:,22))
  call Hloop_Q_A(ntryL,G1H4(1),19,nMT,G2H4(22),n2h4(16))
  call Hloop_VQ_A(ntryL,G1H8(17),ex1(:),G1H4(1),m3h2x4(:,23),heltab2x8(:,:,23))
  call Hloop_Q_A(ntryL,G1H4(1),19,nMT,G2H4(23),n2h4(17))
  call Hloop_WQ_A(ntryL,G1H8(18),ex1(:),G1H4(1),m3h2x4(:,24),heltab2x8(:,:,24))
  call Hloop_Q_A(ntryL,G1H4(1),19,nMB,G2H4(24),n2h4(18))
  call Hloop_AQ_S(ntryL,G2H8(7),ex1(:),G2H4(25),ngH,m3h2x4(:,25),heltab2x8(:,:,25))
  call Hloop_AQ_S(ntryL,G2H8(8),ex1(:),G2H4(26),ngX,m3h2x4(:,26),heltab2x8(:,:,26))
  call Hloop_AQ_V(ntryL,G2H8(9),ex1(:),G2H4(27),m3h2x4(:,27),heltab2x8(:,:,27))
  call Hloop_AQ_Z(ntryL,G2H8(10),ex1(:),G2H4(28),ngZu,m3h2x4(:,28),heltab2x8(:,:,28))
  call Hloop_SA_Q(ntryL,G1H8(19),ex2(:),G1H4(1),ngPtb,m3h2x4(:,29),heltab2x8(:,:,29))
  call Hloop_A_Q(ntryL,G1H4(1),19,nMB,G2H4(29),n2h4(19))
  call Hloop_VA_Q(ntryL,G1H8(20),ex2(:),G1H4(1),m3h2x4(:,30),heltab2x8(:,:,30))
  call Hloop_A_Q(ntryL,G1H4(1),19,nMT,G2H4(30),n2h4(20))
  call Hloop_VA_Q(ntryL,G1H8(21),ex2(:),G1H4(1),m3h2x4(:,31),heltab2x8(:,:,31))
  call Hloop_A_Q(ntryL,G1H4(1),19,nMT,G2H4(31),n2h4(21))
  call Hloop_WA_Q(ntryL,G1H8(22),ex2(:),G1H4(1),m3h2x4(:,32),heltab2x8(:,:,32))
  call Hloop_A_Q(ntryL,G1H4(1),19,nMB,G2H4(32),n2h4(22))
  call Hloop_QA_S(ntryL,G2H8(11),ex2(:),G2H4(33),ngH,m3h2x4(:,33),heltab2x8(:,:,33))
  call Hloop_QA_S(ntryL,G2H8(12),ex2(:),G2H4(34),ngX,m3h2x4(:,34),heltab2x8(:,:,34))
  call Hloop_QA_V(ntryL,G2H8(13),ex2(:),G2H4(35),m3h2x4(:,35),heltab2x8(:,:,35))
  call Hloop_QA_Z(ntryL,G2H8(14),ex2(:),G2H4(36),ngZu,m3h2x4(:,36),heltab2x8(:,:,36))
  call Hloop_QA_S(ntryL,G2H8(15),ex2(:),G2H4(37),ngH,m3h2x4(:,37),heltab2x8(:,:,37))
  call Hloop_QA_S(ntryL,G2H8(16),ex2(:),G2H4(38),ngX,m3h2x4(:,38),heltab2x8(:,:,38))
  call Hloop_QA_V(ntryL,G2H8(17),ex2(:),G2H4(39),m3h2x4(:,39),heltab2x8(:,:,39))
  call Hloop_QA_Z(ntryL,G2H8(18),ex2(:),G2H4(40),ngZu,m3h2x4(:,40),heltab2x8(:,:,40))
  call Hloop_AQ_S(ntryL,G2H8(19),ex3(:),G2H4(41),ngPtb,m3h2x4(:,41),heltab2x8(:,:,41))
  call Hloop_AQ_W(ntryL,G2H8(20),ex3(:),G2H4(42),m3h2x4(:,42),heltab2x8(:,:,42))
  call Hloop_VA_Q(ntryL,G1H8(23),ex4(:),G1H4(1),m3h2x4(:,43),heltab2x8(:,:,43))
  call Hloop_A_Q(ntryL,G1H4(1),26,nMB,G2H4(43),n2h4(23))
  call Hloop_SA_Q(ntryL,G1H8(24),ex4(:),G1H4(1),ngPbt,m3h2x4(:,44),heltab2x8(:,:,44))
  call Hloop_A_Q(ntryL,G1H4(1),26,nMT,G2H4(44),n2h4(24))
  call Hloop_VA_Q(ntryL,G1H8(25),ex4(:),G1H4(1),m3h2x4(:,45),heltab2x8(:,:,45))
  call Hloop_A_Q(ntryL,G1H4(1),26,nMB,G2H4(45),n2h4(25))
  call Hloop_WA_Q(ntryL,G1H8(26),ex4(:),G1H4(1),m3h2x4(:,46),heltab2x8(:,:,46))
  call Hloop_A_Q(ntryL,G1H4(1),26,nMT,G2H4(46),n2h4(26))
  call Hloop_SQ_A(ntryL,G1H8(27),ex3(:),G1H4(1),ngPtb,m3h2x4(:,47),heltab2x8(:,:,47))
  call Hloop_Q_A(ntryL,G1H4(1),21,nMT,G2H4(47),n2h4(27))
  call Hloop_VQ_A(ntryL,G1H8(28),ex3(:),G1H4(1),m3h2x4(:,48),heltab2x8(:,:,48))
  call Hloop_Q_A(ntryL,G1H4(1),21,nMB,G2H4(48),n2h4(28))
  call Hloop_VQ_A(ntryL,G1H8(29),ex3(:),G1H4(1),m3h2x4(:,49),heltab2x8(:,:,49))
  call Hloop_Q_A(ntryL,G1H4(1),21,nMB,G2H4(49),n2h4(29))
  call Hloop_WQ_A(ntryL,G1H8(30),ex3(:),G1H4(1),m3h2x4(:,50),heltab2x8(:,:,50))
  call Hloop_Q_A(ntryL,G1H4(1),21,nMT,G2H4(50),n2h4(30))
  call Hloop_SQ_A(ntryL,G1H8(31),ex3(:),G1H4(1),ngH,m3h2x4(:,51),heltab2x8(:,:,51))
  call Hloop_Q_A(ntryL,G1H4(1),21,nMB,G2H4(51),n2h4(31))
  call Hloop_SQ_A(ntryL,G1H8(32),ex3(:),G1H4(1),ngX,m3h2x4(:,52),heltab2x8(:,:,52))
  call Hloop_Q_A(ntryL,G1H4(1),21,nMB,G2H4(52),n2h4(32))
  call Hloop_VQ_A(ntryL,G1H8(33),ex3(:),G1H4(1),m3h2x4(:,53),heltab2x8(:,:,53))
  call Hloop_Q_A(ntryL,G1H4(1),21,nMB,G2H4(53),n2h4(33))
  call Hloop_VQ_A(ntryL,G1H8(34),ex3(:),G1H4(1),m3h2x4(:,54),heltab2x8(:,:,54))
  call Hloop_Q_A(ntryL,G1H4(1),21,nMB,G2H4(54),n2h4(34))
  call Hloop_VQ_A(ntryL,G1H8(35),ex3(:),G1H4(1),m3h2x4(:,55),heltab2x8(:,:,55))
  call Hloop_Q_A(ntryL,G1H4(1),21,nMB,G2H4(55),n2h4(35))
  call Hloop_ZQ_A(ntryL,G1H8(36),ex3(:),G1H4(1),ngZd,m3h2x4(:,56),heltab2x8(:,:,56))
  call Hloop_Q_A(ntryL,G1H4(1),21,nMB,G2H4(56),n2h4(36))
  call Hloop_VQ_A(ntryL,G1H8(37),ex3(:),G1H4(1),m3h2x4(:,57),heltab2x8(:,:,57))
  call Hloop_Q_A(ntryL,G1H4(1),21,nMB,G2H4(57),n2h4(37))
  call Hloop_QA_S(ntryL,G2H8(21),ex4(:),G2H4(58),ngPbt,m3h2x4(:,58),heltab2x8(:,:,58))
  call Hloop_QA_W(ntryL,G2H8(22),ex4(:),G2H4(59),m3h2x4(:,59),heltab2x8(:,:,59))
  call Hloop_SA_Q(ntryL,G1H8(38),ex4(:),G1H4(1),ngH,m3h2x4(:,60),heltab2x8(:,:,60))
  call Hloop_A_Q(ntryL,G1H4(1),25,nMB,G2H4(60),n2h4(38))
  call Hloop_SA_Q(ntryL,G1H8(39),ex4(:),G1H4(1),ngX,m3h2x4(:,61),heltab2x8(:,:,61))
  call Hloop_A_Q(ntryL,G1H4(1),25,nMB,G2H4(61),n2h4(39))
  call Hloop_VA_Q(ntryL,G1H8(40),ex4(:),G1H4(1),m3h2x4(:,62),heltab2x8(:,:,62))
  call Hloop_A_Q(ntryL,G1H4(1),25,nMB,G2H4(62),n2h4(40))
  call Hloop_VA_Q(ntryL,G1H8(41),ex4(:),G1H4(1),m3h2x4(:,63),heltab2x8(:,:,63))
  call Hloop_A_Q(ntryL,G1H4(1),25,nMB,G2H4(63),n2h4(41))
  call Hloop_VA_Q(ntryL,G1H8(42),ex4(:),G1H4(1),m3h2x4(:,64),heltab2x8(:,:,64))
  call Hloop_A_Q(ntryL,G1H4(1),25,nMB,G2H4(64),n2h4(42))
  call Hloop_ZA_Q(ntryL,G1H8(43),ex4(:),G1H4(1),ngZd,m3h2x4(:,65),heltab2x8(:,:,65))
  call Hloop_A_Q(ntryL,G1H4(1),25,nMB,G2H4(65),n2h4(43))
  call Hloop_VA_Q(ntryL,G1H8(44),ex4(:),G1H4(1),m3h2x4(:,66),heltab2x8(:,:,66))
  call Hloop_A_Q(ntryL,G1H4(1),25,nMB,G2H4(66),n2h4(44))
  call Hloop_QA_S(ntryL,G2H8(23),ex4(:),G2H4(67),ngPbt,m3h2x4(:,67),heltab2x8(:,:,67))
  call Hloop_QA_W(ntryL,G2H8(24),ex4(:),G2H4(68),m3h2x4(:,68),heltab2x8(:,:,68))
  call ol_merge(ntryL,G2H4(6),[G2H4(2)])
  call ol_merge(ntryL,G2H4(18),[G2H4(15)])
  call ol_merge(ntryL,G2H4(24),[G2H4(21)])
  call ol_merge(ntryL,G2H4(32),[G2H4(29)])
  call ol_merge(ntryL,G2H4(46),[G2H4(44)])
  call ol_merge(ntryL,G2H4(50),[G2H4(47)])
  call ol_merge(ntryL,G2H4(56),[G2H4(52)])
  call ol_merge(ntryL,G2H4(65),[G2H4(61)])
  call Hloop_QA_V(ntryL,G2H4(1),ex2(:),G2H2(1),m3h2x2(:,1),heltab2x4(:,:,1))
  call Hloop_QA_V(ntryL,G2H4(6),ex2(:),G2H2(2),m3h2x2(:,2),heltab2x4(:,:,2))
  call Hloop_QA_S(ntryL,G2H4(3),ex2(:),G2H2(3),ngH,m3h2x2(:,3),heltab2x4(:,:,3))
  call Hloop_QA_S(ntryL,G2H4(4),ex2(:),G2H2(4),ngX,m3h2x2(:,4),heltab2x4(:,:,4))
  call Hloop_QA_V(ntryL,G2H4(5),ex2(:),G2H2(5),m3h2x2(:,5),heltab2x4(:,:,5))
  call Hloop_QA_Z(ntryL,G2H4(7),ex2(:),G2H2(6),ngZu,m3h2x2(:,6),heltab2x4(:,:,6))
call Hotf_5pt_reduction(G2H4(8),RedSet_5(1),mass5set(:,1),  & 
G1H4(1),G1H4(2),G1H4(3),G1H4(4),G1H4(5),G1H4(6),4)
call HG1shiftOLR(G1H4(2),8,4)
call Hotf_5pt_reduction(G2H4(9),RedSet_5(1),mass5set(:,2),  & 
G1H4(7),G1H4(8),G1H4(9),G1H4(10),G1H4(11),G1H4(12),4)
call HG1shiftOLR(G1H4(8),8,4)
call Hotf_5pt_reduction(G2H4(10),RedSet_5(1),mass5set(:,3),  & 
G1H4(13),G1H4(14),G1H4(15),G1H4(16),G1H4(17),G1H4(18),4)
call HG1shiftOLR(G1H4(14),8,4)
call Hotf_5pt_reduction(G2H4(11),RedSet_5(1),mass5set(:,2),  & 
G1H4(19),G1H4(20),G1H4(21),G1H4(22),G1H4(23),G1H4(24),4)
call HG1shiftOLR(G1H4(20),8,4)
  call Hloop_AQ_S(ntryL,G2H4(12),ex1(:),G2H2(7),ngH,m3h2x2(:,7),heltab2x4(:,:,7))
  call Hloop_AQ_S(ntryL,G2H4(13),ex1(:),G2H2(8),ngX,m3h2x2(:,8),heltab2x4(:,:,8))
  call Hloop_AQ_V(ntryL,G2H4(14),ex1(:),G2H2(9),m3h2x2(:,9),heltab2x4(:,:,9))
  call Hloop_AQ_V(ntryL,G2H4(18),ex1(:),G2H2(10),m3h2x2(:,10),heltab2x4(:,:,10))
  call Hloop_AQ_V(ntryL,G2H4(16),ex1(:),G2H2(11),m3h2x2(:,11),heltab2x4(:,:,11))
  call Hloop_AQ_Z(ntryL,G2H4(17),ex1(:),G2H2(12),ngZu,m3h2x2(:,12),heltab2x4(:,:,12))
call Hotf_5pt_reduction(G2H4(19),RedSet_5(2),mass5set(:,4),  & 
G1H4(25),G1H4(26),G1H4(27),G1H4(28),G1H4(29),G1H4(30),4)
call HG1shiftOLR(G1H4(26),8,4)
call Hotf_5pt_reduction(G2H4(20),RedSet_5(2),mass5set(:,4),  & 
G1H4(31),G1H4(32),G1H4(33),G1H4(34),G1H4(35),G1H4(36),4)
call HG1shiftOLR(G1H4(32),8,4)
  call Hloop_QA_V(ntryL,G2H4(24),ex4(:),G2H2(13),m3h2x2(:,13),heltab2x4(:,:,13))
  call Hloop_QA_S(ntryL,G2H4(22),ex4(:),G2H2(14),ngPbt,m3h2x2(:,14),heltab2x4(:,:,14))
  call Hloop_QA_W(ntryL,G2H4(23),ex4(:),G2H2(15),m3h2x2(:,15),heltab2x4(:,:,15))
call Hotf_5pt_reduction(G2H4(25),RedSet_5(3),mass5set(:,1),  & 
G1H4(37),G1H4(38),G1H4(39),G1H4(40),G1H4(41),G1H4(42),4)
call HG1shiftOLR(G1H4(38),4,4)
call Hotf_5pt_reduction(G2H4(26),RedSet_5(3),mass5set(:,2),  & 
G1H4(43),G1H4(44),G1H4(45),G1H4(46),G1H4(47),G1H4(48),4)
call HG1shiftOLR(G1H4(44),4,4)
call Hotf_5pt_reduction(G2H4(27),RedSet_5(3),mass5set(:,3),  & 
G1H4(49),G1H4(50),G1H4(51),G1H4(52),G1H4(53),G1H4(54),4)
call HG1shiftOLR(G1H4(50),4,4)
call Hotf_5pt_reduction(G2H4(28),RedSet_5(3),mass5set(:,2),  & 
G1H4(55),G1H4(56),G1H4(57),G1H4(58),G1H4(59),G1H4(60),4)
call HG1shiftOLR(G1H4(56),4,4)
  call Hloop_AQ_V(ntryL,G2H4(32),ex3(:),G2H2(16),m3h2x2(:,16),heltab2x4(:,:,16))
  call Hloop_AQ_S(ntryL,G2H4(30),ex3(:),G2H2(17),ngPtb,m3h2x2(:,17),heltab2x4(:,:,17))
  call Hloop_AQ_W(ntryL,G2H4(31),ex3(:),G2H2(18),m3h2x2(:,18),heltab2x4(:,:,18))
call Hotf_5pt_reduction(G2H4(33),RedSet_5(4),mass5set(:,1),  & 
G1H4(61),G1H4(62),G1H4(63),G1H4(64),G1H4(65),G1H4(66),4)
call HG1shiftOLR(G1H4(62),8,4)
call Hotf_5pt_reduction(G2H4(34),RedSet_5(4),mass5set(:,2),  & 
G1H4(67),G1H4(68),G1H4(69),G1H4(70),G1H4(71),G1H4(72),4)
call HG1shiftOLR(G1H4(68),8,4)
call Hotf_5pt_reduction(G2H4(35),RedSet_5(4),mass5set(:,3),  & 
G1H4(73),G1H4(74),G1H4(75),G1H4(76),G1H4(77),G1H4(78),4)
call HG1shiftOLR(G1H4(74),8,4)
call Hotf_5pt_reduction(G2H4(36),RedSet_5(4),mass5set(:,2),  & 
G1H4(79),G1H4(80),G1H4(81),G1H4(82),G1H4(83),G1H4(84),4)
call HG1shiftOLR(G1H4(80),8,4)
call Hotf_5pt_reduction(G2H4(37),RedSet_5(5),mass5set(:,1),  & 
G1H4(85),G1H4(86),G1H4(87),G1H4(88),G1H4(89),G1H4(90),4)
call HG1shiftOLR(G1H4(86),4,4)
call Hotf_5pt_reduction(G2H4(38),RedSet_5(5),mass5set(:,2),  & 
G1H4(91),G1H4(92),G1H4(93),G1H4(94),G1H4(95),G1H4(96),4)
call HG1shiftOLR(G1H4(92),4,4)
call Hotf_5pt_reduction(G2H4(39),RedSet_5(5),mass5set(:,3),  & 
G1H4(97),G1H4(98),G1H4(99),G1H4(100),G1H4(101),G1H4(102),4)
call HG1shiftOLR(G1H4(98),4,4)
call Hotf_5pt_reduction(G2H4(40),RedSet_5(5),mass5set(:,2),  & 
G1H4(103),G1H4(104),G1H4(105),G1H4(106),G1H4(107),G1H4(108),4)
call HG1shiftOLR(G1H4(104),4,4)
call Hotf_5pt_reduction(G2H4(41),RedSet_5(6),mass5set(:,5),  & 
G1H4(109),G1H4(110),G1H4(111),G1H4(112),G1H4(113),G1H4(114),4)
call HG1shiftOLR(G1H4(110),8,4)
call Hotf_5pt_reduction(G2H4(42),RedSet_5(6),mass5set(:,5),  & 
G1H4(115),G1H4(116),G1H4(117),G1H4(118),G1H4(119),G1H4(120),4)
call HG1shiftOLR(G1H4(116),8,4)
  call Hloop_AQ_S(ntryL,G2H4(43),ex1(:),G2H2(19),ngPbt,m3h2x2(:,19),heltab2x4(:,:,19))
  call Hloop_AQ_V(ntryL,G2H4(46),ex1(:),G2H2(20),m3h2x2(:,20),heltab2x4(:,:,20))
  call Hloop_AQ_W(ntryL,G2H4(45),ex1(:),G2H2(21),m3h2x2(:,21),heltab2x4(:,:,21))
  call Hloop_QA_V(ntryL,G2H4(50),ex2(:),G2H2(22),m3h2x2(:,22),heltab2x4(:,:,22))
  call Hloop_QA_S(ntryL,G2H4(48),ex2(:),G2H2(23),ngPtb,m3h2x2(:,23),heltab2x4(:,:,23))
  call Hloop_QA_W(ntryL,G2H4(49),ex2(:),G2H2(24),m3h2x2(:,24),heltab2x4(:,:,24))
  call Hloop_QA_V(ntryL,G2H4(51),ex4(:),G2H2(25),m3h2x2(:,25),heltab2x4(:,:,25))
  call Hloop_QA_V(ntryL,G2H4(56),ex4(:),G2H2(26),m3h2x2(:,26),heltab2x4(:,:,26))
  call Hloop_QA_S(ntryL,G2H4(53),ex4(:),G2H2(27),ngH,m3h2x2(:,27),heltab2x4(:,:,27))
  call Hloop_QA_S(ntryL,G2H4(54),ex4(:),G2H2(28),ngX,m3h2x2(:,28),heltab2x4(:,:,28))
  call Hloop_QA_V(ntryL,G2H4(55),ex4(:),G2H2(29),m3h2x2(:,29),heltab2x4(:,:,29))
  call Hloop_QA_Z(ntryL,G2H4(57),ex4(:),G2H2(30),ngZd,m3h2x2(:,30),heltab2x4(:,:,30))
call Hotf_5pt_reduction(G2H4(58),RedSet_5(7),mass5set(:,5),  & 
G1H4(121),G1H4(122),G1H4(123),G1H4(124),G1H4(125),G1H4(126),4)
call HG1shiftOLR(G1H4(122),4,4)
call Hotf_5pt_reduction(G2H4(59),RedSet_5(7),mass5set(:,5),  & 
G1H4(127),G1H4(128),G1H4(129),G1H4(130),G1H4(131),G1H4(132),4)
call HG1shiftOLR(G1H4(128),4,4)
  call Hloop_AQ_V(ntryL,G2H4(60),ex3(:),G2H2(31),m3h2x2(:,31),heltab2x4(:,:,31))
  call Hloop_AQ_V(ntryL,G2H4(65),ex3(:),G2H2(32),m3h2x2(:,32),heltab2x4(:,:,32))
  call Hloop_AQ_S(ntryL,G2H4(62),ex3(:),G2H2(33),ngH,m3h2x2(:,33),heltab2x4(:,:,33))
  call Hloop_AQ_S(ntryL,G2H4(63),ex3(:),G2H2(34),ngX,m3h2x2(:,34),heltab2x4(:,:,34))
  call Hloop_AQ_V(ntryL,G2H4(64),ex3(:),G2H2(35),m3h2x2(:,35),heltab2x4(:,:,35))
  call Hloop_AQ_Z(ntryL,G2H4(66),ex3(:),G2H2(36),ngZd,m3h2x2(:,36),heltab2x4(:,:,36))
call Hotf_5pt_reduction(G2H4(67),RedSet_5(8),mass5set(:,6),  & 
G1H4(133),G1H4(134),G1H4(135),G1H4(136),G1H4(137),G1H4(138),4)
call HG1shiftOLR(G1H4(134),2,4)
call Hotf_5pt_reduction(G2H4(68),RedSet_5(8),mass5set(:,6),  & 
G1H4(139),G1H4(140),G1H4(141),G1H4(142),G1H4(143),G1H4(144),4)
call HG1shiftOLR(G1H4(140),2,4)
  call Hloop_SQ_A(ntryL,G1H4(1),ex3(:),G1H2(1),ngH,m3h2x2(:,37),heltab2x4(:,:,37))
  call Hloop_Q_A(ntryL,G1H2(1),23,nMB,G2H2(37),n2h2(1))
call HGT_raise_alpha_OLR(G1H4(2),1,1,4)
call HGT_raise_alpha_invQ_OLR(G1H4(2),2,5,4)
  call Hloop_VA_Q(ntryL,G1H4(2),ex4(:),G1H2(1),m3h2x2(:,38),heltab2x4(:,:,38))
  call Hloop_SQ_A(ntryL,G1H4(5),ex3(:),G1H2(2),ngH,m3h2x2(:,39),heltab2x4(:,:,39))
  call Hloop_Q_A(ntryL,G1H2(2),23,nMB,G2H2(38),n2h2(2))
  call Hloop_SQ_A(ntryL,G1H4(6),ex3(:),G1H2(2),ngH,m3h2x2(:,40),heltab2x4(:,:,40))
  call Hloop_Q_A(ntryL,G1H2(2),23,nMB,G2H2(39),n2h2(3))
  call Hloop_SQ_A(ntryL,G1H4(7),ex3(:),G1H2(2),ngX,m3h2x2(:,41),heltab2x4(:,:,41))
  call Hloop_Q_A(ntryL,G1H2(2),23,nMB,G2H2(40),n2h2(4))
call HGT_raise_alpha_OLR(G1H4(8),1,1,4)
call HGT_raise_alpha_invQ_OLR(G1H4(8),2,5,4)
  call Hloop_VA_Q(ntryL,G1H4(8),ex4(:),G1H2(2),m3h2x2(:,42),heltab2x4(:,:,42))
  call Hloop_SQ_A(ntryL,G1H4(11),ex3(:),G1H2(3),ngX,m3h2x2(:,43),heltab2x4(:,:,43))
  call Hloop_Q_A(ntryL,G1H2(3),23,nMB,G2H2(41),n2h2(5))
  call Hloop_SQ_A(ntryL,G1H4(12),ex3(:),G1H2(3),ngX,m3h2x2(:,44),heltab2x4(:,:,44))
  call Hloop_Q_A(ntryL,G1H2(3),23,nMB,G2H2(42),n2h2(6))
  call Hloop_VQ_A(ntryL,G1H4(13),ex3(:),G1H2(3),m3h2x2(:,45),heltab2x4(:,:,45))
  call Hloop_Q_A(ntryL,G1H2(3),23,nMB,G2H2(43),n2h2(7))
call HGT_raise_alpha_OLR(G1H4(14),1,1,4)
call HGT_raise_alpha_invQ_OLR(G1H4(14),2,5,4)
  call Hloop_VA_Q(ntryL,G1H4(14),ex4(:),G1H2(3),m3h2x2(:,46),heltab2x4(:,:,46))
  call Hloop_VQ_A(ntryL,G1H4(17),ex3(:),G1H2(4),m3h2x2(:,47),heltab2x4(:,:,47))
  call Hloop_Q_A(ntryL,G1H2(4),23,nMB,G2H2(44),n2h2(8))
  call Hloop_VQ_A(ntryL,G1H4(18),ex3(:),G1H2(4),m3h2x2(:,48),heltab2x4(:,:,48))
  call Hloop_Q_A(ntryL,G1H2(4),23,nMB,G2H2(45),n2h2(9))
  call Hloop_ZQ_A(ntryL,G1H4(19),ex3(:),G1H2(4),ngZd,m3h2x2(:,49),heltab2x4(:,:,49))
  call Hloop_Q_A(ntryL,G1H2(4),23,nMB,G2H2(46),n2h2(10))
call HGT_raise_alpha_OLR(G1H4(20),1,1,4)
call HGT_raise_alpha_invQ_OLR(G1H4(20),2,5,4)
  call Hloop_VA_Q(ntryL,G1H4(20),ex4(:),G1H2(4),m3h2x2(:,50),heltab2x4(:,:,50))
  call Hloop_ZQ_A(ntryL,G1H4(23),ex3(:),G1H2(5),ngZd,m3h2x2(:,51),heltab2x4(:,:,51))
  call Hloop_Q_A(ntryL,G1H2(5),23,nMB,G2H2(47),n2h2(11))
  call Hloop_ZQ_A(ntryL,G1H4(24),ex3(:),G1H2(5),ngZd,m3h2x2(:,52),heltab2x4(:,:,52))
  call Hloop_Q_A(ntryL,G1H2(5),23,nMB,G2H2(48),n2h2(12))
  call Hloop_SQ_A(ntryL,G1H4(25),ex1(:),G1H2(5),ngPbt,m3h2x2(:,53),heltab2x4(:,:,53))
  call Hloop_Q_A(ntryL,G1H2(5),23,nMB,G2H2(49),n2h2(13))
call HGT_raise_alpha_OLR(G1H4(26),1,1,4)
call HGT_raise_alpha_invQ_OLR(G1H4(26),2,5,4)
  call Hloop_VA_Q(ntryL,G1H4(26),ex4(:),G1H2(5),m3h2x2(:,54),heltab2x4(:,:,54))
  call Hloop_SQ_A(ntryL,G1H4(29),ex1(:),G1H2(6),ngPbt,m3h2x2(:,55),heltab2x4(:,:,55))
  call Hloop_Q_A(ntryL,G1H2(6),23,nMB,G2H2(50),n2h2(14))
  call Hloop_SQ_A(ntryL,G1H4(30),ex1(:),G1H2(6),ngPbt,m3h2x2(:,56),heltab2x4(:,:,56))
  call Hloop_Q_A(ntryL,G1H2(6),23,nMB,G2H2(51),n2h2(15))
  call Hloop_WQ_A(ntryL,G1H4(31),ex1(:),G1H2(6),m3h2x2(:,57),heltab2x4(:,:,57))
  call Hloop_Q_A(ntryL,G1H2(6),23,nMB,G2H2(52),n2h2(16))
call HGT_raise_alpha_OLR(G1H4(32),1,1,4)
call HGT_raise_alpha_invQ_OLR(G1H4(32),2,5,4)
  call Hloop_VA_Q(ntryL,G1H4(32),ex4(:),G1H2(6),m3h2x2(:,58),heltab2x4(:,:,58))
  call Hloop_WQ_A(ntryL,G1H4(35),ex1(:),G1H2(7),m3h2x2(:,59),heltab2x4(:,:,59))
  call Hloop_Q_A(ntryL,G1H2(7),23,nMB,G2H2(53),n2h2(17))
  call Hloop_WQ_A(ntryL,G1H4(36),ex1(:),G1H2(7),m3h2x2(:,60),heltab2x4(:,:,60))
  call Hloop_Q_A(ntryL,G1H2(7),23,nMB,G2H2(54),n2h2(18))
  call Hloop_SA_Q(ntryL,G1H4(37),ex4(:),G1H2(7),ngH,m3h2x2(:,61),heltab2x4(:,:,61))
  call Hloop_A_Q(ntryL,G1H2(7),27,nMB,G2H2(55),n2h2(19))
call HGT_raise_alpha_OLR(G1H4(38),1,1,4)
call HGT_raise_alpha_invQ_OLR(G1H4(38),2,5,4)
  call Hloop_VQ_A(ntryL,G1H4(38),ex3(:),G1H2(7),m3h2x2(:,62),heltab2x4(:,:,62))
  call Hloop_SA_Q(ntryL,G1H4(41),ex4(:),G1H2(8),ngH,m3h2x2(:,63),heltab2x4(:,:,63))
  call Hloop_A_Q(ntryL,G1H2(8),27,nMB,G2H2(56),n2h2(20))
  call Hloop_SA_Q(ntryL,G1H4(42),ex4(:),G1H2(8),ngH,m3h2x2(:,64),heltab2x4(:,:,64))
  call Hloop_A_Q(ntryL,G1H2(8),27,nMB,G2H2(57),n2h2(21))
  call Hloop_SA_Q(ntryL,G1H4(43),ex4(:),G1H2(8),ngX,m3h2x2(:,65),heltab2x4(:,:,65))
  call Hloop_A_Q(ntryL,G1H2(8),27,nMB,G2H2(58),n2h2(22))
call HGT_raise_alpha_OLR(G1H4(44),1,1,4)
call HGT_raise_alpha_invQ_OLR(G1H4(44),2,5,4)
  call Hloop_VQ_A(ntryL,G1H4(44),ex3(:),G1H2(8),m3h2x2(:,66),heltab2x4(:,:,66))
  call Hloop_SA_Q(ntryL,G1H4(47),ex4(:),G1H2(9),ngX,m3h2x2(:,67),heltab2x4(:,:,67))
  call Hloop_A_Q(ntryL,G1H2(9),27,nMB,G2H2(59),n2h2(23))
  call Hloop_SA_Q(ntryL,G1H4(48),ex4(:),G1H2(9),ngX,m3h2x2(:,68),heltab2x4(:,:,68))
  call Hloop_A_Q(ntryL,G1H2(9),27,nMB,G2H2(60),n2h2(24))
  call Hloop_VA_Q(ntryL,G1H4(49),ex4(:),G1H2(9),m3h2x2(:,69),heltab2x4(:,:,69))
  call Hloop_A_Q(ntryL,G1H2(9),27,nMB,G2H2(61),n2h2(25))
call HGT_raise_alpha_OLR(G1H4(50),1,1,4)
call HGT_raise_alpha_invQ_OLR(G1H4(50),2,5,4)
  call Hloop_VQ_A(ntryL,G1H4(50),ex3(:),G1H2(9),m3h2x2(:,70),heltab2x4(:,:,70))
  call Hloop_VA_Q(ntryL,G1H4(53),ex4(:),G1H2(10),m3h2x2(:,71),heltab2x4(:,:,71))
  call Hloop_A_Q(ntryL,G1H2(10),27,nMB,G2H2(62),n2h2(26))
  call Hloop_VA_Q(ntryL,G1H4(54),ex4(:),G1H2(10),m3h2x2(:,72),heltab2x4(:,:,72))
  call Hloop_A_Q(ntryL,G1H2(10),27,nMB,G2H2(63),n2h2(27))
  call Hloop_ZA_Q(ntryL,G1H4(55),ex4(:),G1H2(10),ngZd,m3h2x2(:,73),heltab2x4(:,:,73))
  call Hloop_A_Q(ntryL,G1H2(10),27,nMB,G2H2(64),n2h2(28))
call HGT_raise_alpha_OLR(G1H4(56),1,1,4)
call HGT_raise_alpha_invQ_OLR(G1H4(56),2,5,4)
  call Hloop_VQ_A(ntryL,G1H4(56),ex3(:),G1H2(10),m3h2x2(:,74),heltab2x4(:,:,74))
  call Hloop_ZA_Q(ntryL,G1H4(59),ex4(:),G1H2(11),ngZd,m3h2x2(:,75),heltab2x4(:,:,75))
  call Hloop_A_Q(ntryL,G1H2(11),27,nMB,G2H2(65),n2h2(29))
  call Hloop_ZA_Q(ntryL,G1H4(60),ex4(:),G1H2(11),ngZd,m3h2x2(:,76),heltab2x4(:,:,76))
  call Hloop_A_Q(ntryL,G1H2(11),27,nMB,G2H2(66),n2h2(30))
  call Hloop_SQ_A(ntryL,G1H4(61),ex3(:),G1H2(11),ngH,m3h2x2(:,77),heltab2x4(:,:,77))
  call Hloop_Q_A(ntryL,G1H2(11),23,nMB,G2H2(67),n2h2(31))
call HGT_raise_alpha_OLR(G1H4(62),1,1,4)
call HGT_raise_alpha_invQ_OLR(G1H4(62),2,5,4)
  call Hloop_VA_Q(ntryL,G1H4(62),ex4(:),G1H2(11),m3h2x2(:,78),heltab2x4(:,:,78))
  call Hloop_SQ_A(ntryL,G1H4(65),ex3(:),G1H2(12),ngH,m3h2x2(:,79),heltab2x4(:,:,79))
  call Hloop_Q_A(ntryL,G1H2(12),23,nMB,G2H2(68),n2h2(32))
  call Hloop_SQ_A(ntryL,G1H4(66),ex3(:),G1H2(12),ngH,m3h2x2(:,80),heltab2x4(:,:,80))
  call Hloop_Q_A(ntryL,G1H2(12),23,nMB,G2H2(69),n2h2(33))
  call Hloop_SQ_A(ntryL,G1H4(67),ex3(:),G1H2(12),ngX,m3h2x2(:,81),heltab2x4(:,:,81))
  call Hloop_Q_A(ntryL,G1H2(12),23,nMB,G2H2(70),n2h2(34))
call HGT_raise_alpha_OLR(G1H4(68),1,1,4)
call HGT_raise_alpha_invQ_OLR(G1H4(68),2,5,4)
  call Hloop_VA_Q(ntryL,G1H4(68),ex4(:),G1H2(12),m3h2x2(:,82),heltab2x4(:,:,82))
  call Hloop_SQ_A(ntryL,G1H4(71),ex3(:),G1H2(13),ngX,m3h2x2(:,83),heltab2x4(:,:,83))
  call Hloop_Q_A(ntryL,G1H2(13),23,nMB,G2H2(71),n2h2(35))
  call Hloop_SQ_A(ntryL,G1H4(72),ex3(:),G1H2(13),ngX,m3h2x2(:,84),heltab2x4(:,:,84))
  call Hloop_Q_A(ntryL,G1H2(13),23,nMB,G2H2(72),n2h2(36))
  call Hloop_VQ_A(ntryL,G1H4(73),ex3(:),G1H2(13),m3h2x2(:,85),heltab2x4(:,:,85))
  call Hloop_Q_A(ntryL,G1H2(13),23,nMB,G2H2(73),n2h2(37))
call HGT_raise_alpha_OLR(G1H4(74),1,1,4)
call HGT_raise_alpha_invQ_OLR(G1H4(74),2,5,4)
  call Hloop_VA_Q(ntryL,G1H4(74),ex4(:),G1H2(13),m3h2x2(:,86),heltab2x4(:,:,86))
  call Hloop_VQ_A(ntryL,G1H4(77),ex3(:),G1H2(14),m3h2x2(:,87),heltab2x4(:,:,87))
  call Hloop_Q_A(ntryL,G1H2(14),23,nMB,G2H2(74),n2h2(38))
  call Hloop_VQ_A(ntryL,G1H4(78),ex3(:),G1H2(14),m3h2x2(:,88),heltab2x4(:,:,88))
  call Hloop_Q_A(ntryL,G1H2(14),23,nMB,G2H2(75),n2h2(39))
  call Hloop_ZQ_A(ntryL,G1H4(79),ex3(:),G1H2(14),ngZd,m3h2x2(:,89),heltab2x4(:,:,89))
  call Hloop_Q_A(ntryL,G1H2(14),23,nMB,G2H2(76),n2h2(40))
call HGT_raise_alpha_OLR(G1H4(80),1,1,4)
call HGT_raise_alpha_invQ_OLR(G1H4(80),2,5,4)
  call Hloop_VA_Q(ntryL,G1H4(80),ex4(:),G1H2(14),m3h2x2(:,90),heltab2x4(:,:,90))
  call Hloop_ZQ_A(ntryL,G1H4(83),ex3(:),G1H2(15),ngZd,m3h2x2(:,91),heltab2x4(:,:,91))
  call Hloop_Q_A(ntryL,G1H2(15),23,nMB,G2H2(77),n2h2(41))
  call Hloop_ZQ_A(ntryL,G1H4(84),ex3(:),G1H2(15),ngZd,m3h2x2(:,92),heltab2x4(:,:,92))
  call Hloop_Q_A(ntryL,G1H2(15),23,nMB,G2H2(78),n2h2(42))
  call Hloop_SA_Q(ntryL,G1H4(85),ex4(:),G1H2(15),ngH,m3h2x2(:,93),heltab2x4(:,:,93))
  call Hloop_A_Q(ntryL,G1H2(15),27,nMB,G2H2(79),n2h2(43))
call HGT_raise_alpha_OLR(G1H4(86),1,1,4)
call HGT_raise_alpha_invQ_OLR(G1H4(86),2,5,4)
  call Hloop_VQ_A(ntryL,G1H4(86),ex3(:),G1H2(15),m3h2x2(:,94),heltab2x4(:,:,94))
  call Hloop_SA_Q(ntryL,G1H4(89),ex4(:),G1H2(16),ngH,m3h2x2(:,95),heltab2x4(:,:,95))
  call Hloop_A_Q(ntryL,G1H2(16),27,nMB,G2H2(80),n2h2(44))
  call Hloop_SA_Q(ntryL,G1H4(90),ex4(:),G1H2(16),ngH,m3h2x2(:,96),heltab2x4(:,:,96))
  call Hloop_A_Q(ntryL,G1H2(16),27,nMB,G2H2(81),n2h2(45))
  call Hloop_SA_Q(ntryL,G1H4(91),ex4(:),G1H2(16),ngX,m3h2x2(:,97),heltab2x4(:,:,97))
  call Hloop_A_Q(ntryL,G1H2(16),27,nMB,G2H2(82),n2h2(46))
call HGT_raise_alpha_OLR(G1H4(92),1,1,4)
call HGT_raise_alpha_invQ_OLR(G1H4(92),2,5,4)
  call Hloop_VQ_A(ntryL,G1H4(92),ex3(:),G1H2(16),m3h2x2(:,98),heltab2x4(:,:,98))
  call Hloop_SA_Q(ntryL,G1H4(95),ex4(:),G1H2(17),ngX,m3h2x2(:,99),heltab2x4(:,:,99))
  call Hloop_A_Q(ntryL,G1H2(17),27,nMB,G2H2(83),n2h2(47))
  call Hloop_SA_Q(ntryL,G1H4(96),ex4(:),G1H2(17),ngX,m3h2x2(:,100),heltab2x4(:,:,100))
  call Hloop_A_Q(ntryL,G1H2(17),27,nMB,G2H2(84),n2h2(48))
  call Hloop_VA_Q(ntryL,G1H4(97),ex4(:),G1H2(17),m3h2x2(:,101),heltab2x4(:,:,101))
  call Hloop_A_Q(ntryL,G1H2(17),27,nMB,G2H2(85),n2h2(49))
call HGT_raise_alpha_OLR(G1H4(98),1,1,4)
call HGT_raise_alpha_invQ_OLR(G1H4(98),2,5,4)
  call Hloop_VQ_A(ntryL,G1H4(98),ex3(:),G1H2(17),m3h2x2(:,102),heltab2x4(:,:,102))
  call Hloop_VA_Q(ntryL,G1H4(101),ex4(:),G1H2(18),m3h2x2(:,103),heltab2x4(:,:,103))
  call Hloop_A_Q(ntryL,G1H2(18),27,nMB,G2H2(86),n2h2(50))
  call Hloop_VA_Q(ntryL,G1H4(102),ex4(:),G1H2(18),m3h2x2(:,104),heltab2x4(:,:,104))
  call Hloop_A_Q(ntryL,G1H2(18),27,nMB,G2H2(87),n2h2(51))
  call Hloop_ZA_Q(ntryL,G1H4(103),ex4(:),G1H2(18),ngZd,m3h2x2(:,105),heltab2x4(:,:,105))
  call Hloop_A_Q(ntryL,G1H2(18),27,nMB,G2H2(88),n2h2(52))
call HGT_raise_alpha_OLR(G1H4(104),1,1,4)
call HGT_raise_alpha_invQ_OLR(G1H4(104),2,5,4)
  call Hloop_VQ_A(ntryL,G1H4(104),ex3(:),G1H2(18),m3h2x2(:,106),heltab2x4(:,:,106))
  call Hloop_ZA_Q(ntryL,G1H4(107),ex4(:),G1H2(19),ngZd,m3h2x2(:,107),heltab2x4(:,:,107))
  call Hloop_A_Q(ntryL,G1H2(19),27,nMB,G2H2(89),n2h2(53))
  call Hloop_ZA_Q(ntryL,G1H4(108),ex4(:),G1H2(19),ngZd,m3h2x2(:,108),heltab2x4(:,:,108))
  call Hloop_A_Q(ntryL,G1H2(19),27,nMB,G2H2(90),n2h2(54))
  call Hloop_SQ_A(ntryL,G1H4(109),ex1(:),G1H2(19),ngPbt,m3h2x2(:,109),heltab2x4(:,:,109))
  call Hloop_Q_A(ntryL,G1H2(19),23,nMB,G2H2(91),n2h2(55))
call HGT_raise_alpha_OLR(G1H4(110),1,1,4)
call HGT_raise_alpha_invQ_OLR(G1H4(110),2,5,4)
  call Hloop_VA_Q(ntryL,G1H4(110),ex4(:),G1H2(19),m3h2x2(:,110),heltab2x4(:,:,110))
  call Hloop_SQ_A(ntryL,G1H4(113),ex1(:),G1H2(20),ngPbt,m3h2x2(:,111),heltab2x4(:,:,111))
  call Hloop_Q_A(ntryL,G1H2(20),23,nMB,G2H2(92),n2h2(56))
  call Hloop_SQ_A(ntryL,G1H4(114),ex1(:),G1H2(20),ngPbt,m3h2x2(:,112),heltab2x4(:,:,112))
  call Hloop_Q_A(ntryL,G1H2(20),23,nMB,G2H2(93),n2h2(57))
  call Hloop_WQ_A(ntryL,G1H4(115),ex1(:),G1H2(20),m3h2x2(:,113),heltab2x4(:,:,113))
  call Hloop_Q_A(ntryL,G1H2(20),23,nMB,G2H2(94),n2h2(58))
call HGT_raise_alpha_OLR(G1H4(116),1,1,4)
call HGT_raise_alpha_invQ_OLR(G1H4(116),2,5,4)
  call Hloop_VA_Q(ntryL,G1H4(116),ex4(:),G1H2(20),m3h2x2(:,114),heltab2x4(:,:,114))
  call Hloop_WQ_A(ntryL,G1H4(119),ex1(:),G1H2(21),m3h2x2(:,115),heltab2x4(:,:,115))
  call Hloop_Q_A(ntryL,G1H2(21),23,nMB,G2H2(95),n2h2(59))
  call Hloop_WQ_A(ntryL,G1H4(120),ex1(:),G1H2(21),m3h2x2(:,116),heltab2x4(:,:,116))
  call Hloop_Q_A(ntryL,G1H2(21),23,nMB,G2H2(96),n2h2(60))
  call Hloop_SA_Q(ntryL,G1H4(121),ex2(:),G1H2(21),ngPtb,m3h2x2(:,117),heltab2x4(:,:,117))
  call Hloop_A_Q(ntryL,G1H2(21),27,nMB,G2H2(97),n2h2(61))
call HGT_raise_alpha_OLR(G1H4(122),1,1,4)
call HGT_raise_alpha_invQ_OLR(G1H4(122),2,5,4)
  call Hloop_VQ_A(ntryL,G1H4(122),ex3(:),G1H2(21),m3h2x2(:,118),heltab2x4(:,:,118))
  call Hloop_SA_Q(ntryL,G1H4(125),ex2(:),G1H2(22),ngPtb,m3h2x2(:,119),heltab2x4(:,:,119))
  call Hloop_A_Q(ntryL,G1H2(22),27,nMB,G2H2(98),n2h2(62))
  call Hloop_SA_Q(ntryL,G1H4(126),ex2(:),G1H2(22),ngPtb,m3h2x2(:,120),heltab2x4(:,:,120))
  call Hloop_A_Q(ntryL,G1H2(22),27,nMB,G2H2(99),n2h2(63))
  call Hloop_WA_Q(ntryL,G1H4(127),ex2(:),G1H2(22),m3h2x2(:,121),heltab2x4(:,:,121))
  call Hloop_A_Q(ntryL,G1H2(22),27,nMB,G2H2(100),n2h2(64))
call HGT_raise_alpha_OLR(G1H4(128),1,1,4)
call HGT_raise_alpha_invQ_OLR(G1H4(128),2,5,4)
  call Hloop_VQ_A(ntryL,G1H4(128),ex3(:),G1H2(22),m3h2x2(:,122),heltab2x4(:,:,122))
  call Hloop_WA_Q(ntryL,G1H4(131),ex2(:),G1H2(23),m3h2x2(:,123),heltab2x4(:,:,123))
  call Hloop_A_Q(ntryL,G1H2(23),27,nMB,G2H2(101),n2h2(65))
  call Hloop_WA_Q(ntryL,G1H4(132),ex2(:),G1H2(23),m3h2x2(:,124),heltab2x4(:,:,124))
  call Hloop_A_Q(ntryL,G1H2(23),27,nMB,G2H2(102),n2h2(66))
  call Hloop_SQ_A(ntryL,G1H4(133),ex3(:),G1H2(23),ngPtb,m3h2x2(:,125),heltab2x4(:,:,125))
  call Hloop_Q_A(ntryL,G1H2(23),29,nMT,G2H2(103),n2h2(67))
call HGT_raise_alpha_OLR(G1H4(134),1,1,4)
call HGT_raise_alpha_invQ_OLR(G1H4(134),2,5,4)
  call Hloop_VA_Q(ntryL,G1H4(134),ex2(:),G1H2(23),m3h2x2(:,126),heltab2x4(:,:,126))
  call Hloop_SQ_A(ntryL,G1H4(137),ex3(:),G1H2(24),ngPtb,m3h2x2(:,127),heltab2x4(:,:,127))
  call Hloop_Q_A(ntryL,G1H2(24),29,nMT,G2H2(104),n2h2(68))
  call Hloop_SQ_A(ntryL,G1H4(138),ex3(:),G1H2(24),ngPtb,m3h2x2(:,128),heltab2x4(:,:,128))
  call Hloop_Q_A(ntryL,G1H2(24),29,nMT,G2H2(105),n2h2(69))
  call Hloop_WQ_A(ntryL,G1H4(139),ex3(:),G1H2(24),m3h2x2(:,129),heltab2x4(:,:,129))
  call Hloop_Q_A(ntryL,G1H2(24),29,nMT,G2H2(106),n2h2(70))
call HGT_raise_alpha_OLR(G1H4(140),1,1,4)
call HGT_raise_alpha_invQ_OLR(G1H4(140),2,5,4)
  call Hloop_VA_Q(ntryL,G1H4(140),ex2(:),G1H2(24),m3h2x2(:,130),heltab2x4(:,:,130))
  call Hloop_WQ_A(ntryL,G1H4(143),ex3(:),G1H2(25),m3h2x2(:,131),heltab2x4(:,:,131))
  call Hloop_Q_A(ntryL,G1H2(25),29,nMT,G2H2(107),n2h2(71))
  call Hloop_WQ_A(ntryL,G1H4(144),ex3(:),G1H2(25),m3h2x2(:,132),heltab2x4(:,:,132))
  call Hloop_Q_A(ntryL,G1H2(25),29,nMT,G2H2(108),n2h2(72))
  call ol_merge(ntryL,G2H2(46),[G2H2(40)])
  call ol_merge(ntryL,G2H2(48),[G2H2(42)])
  call ol_merge(ntryL,G2H2(52),[G2H2(49)])
  call ol_merge(ntryL,G2H2(54),[G2H2(51)])
  call ol_merge(ntryL,G2H2(64),[G2H2(58)])
  call ol_merge(ntryL,G2H2(66),[G2H2(60)])
  call ol_merge(ntryL,G2H2(76),[G2H2(70)])
  call ol_merge(ntryL,G2H2(78),[G2H2(72)])
  call ol_merge(ntryL,G2H2(88),[G2H2(82)])
  call ol_merge(ntryL,G2H2(90),[G2H2(84)])
  call ol_merge(ntryL,G2H2(94),[G2H2(91)])
  call ol_merge(ntryL,G2H2(96),[G2H2(93)])
  call ol_merge(ntryL,G2H2(100),[G2H2(97)])
  call ol_merge(ntryL,G2H2(102),[G2H2(99)])
  call ol_merge(ntryL,G2H2(106),[G2H2(103)])
  call ol_merge(ntryL,G2H2(108),[G2H2(105)])
call Hotf_5pt_reduction(G2H2(1),RedSet_5(9),mass5set(:,7),  & 
G1H2(25),G1H2(26),G1H2(27),G1H2(28),G1H2(29),G1H2(30),2)
call HG1shiftOLR(G1H2(26),8,2)
call Hotf_5pt_reduction(G2H2(2),RedSet_5(9),mass5set(:,8),  & 
G1H2(31),G1H2(32),G1H2(33),G1H2(34),G1H2(35),G1H2(36),2)
call HG1shiftOLR(G1H2(32),8,2)
call Hotf_5pt_reduction(G2H2(3),RedSet_5(9),mass5set(:,9),  & 
G1H2(37),G1H2(38),G1H2(39),G1H2(40),G1H2(41),G1H2(42),2)
call HG1shiftOLR(G1H2(38),8,2)
call Hotf_5pt_reduction(G2H2(4),RedSet_5(9),mass5set(:,10),  & 
G1H2(43),G1H2(44),G1H2(45),G1H2(46),G1H2(47),G1H2(48),2)
call HG1shiftOLR(G1H2(44),8,2)
call Hotf_5pt_reduction(G2H2(5),RedSet_5(9),mass5set(:,11),  & 
G1H2(49),G1H2(50),G1H2(51),G1H2(52),G1H2(53),G1H2(54),2)
call HG1shiftOLR(G1H2(50),8,2)
call Hotf_5pt_reduction(G2H2(6),RedSet_5(9),mass5set(:,10),  & 
G1H2(55),G1H2(56),G1H2(57),G1H2(58),G1H2(59),G1H2(60),2)
call HG1shiftOLR(G1H2(56),8,2)
call Hotf_5pt_reduction(G2H2(7),RedSet_5(2),mass5set(:,9),  & 
G1H2(61),G1H2(62),G1H2(63),G1H2(64),G1H2(65),G1H2(66),2)
call HG1shiftOLR(G1H2(62),8,2)
call Hotf_5pt_reduction(G2H2(8),RedSet_5(2),mass5set(:,10),  & 
G1H2(67),G1H2(68),G1H2(69),G1H2(70),G1H2(71),G1H2(72),2)
call HG1shiftOLR(G1H2(68),8,2)
call Hotf_5pt_reduction(G2H2(9),RedSet_5(2),mass5set(:,7),  & 
G1H2(73),G1H2(74),G1H2(75),G1H2(76),G1H2(77),G1H2(78),2)
call HG1shiftOLR(G1H2(74),8,2)
call Hotf_5pt_reduction(G2H2(10),RedSet_5(2),mass5set(:,8),  & 
G1H2(79),G1H2(80),G1H2(81),G1H2(82),G1H2(83),G1H2(84),2)
call HG1shiftOLR(G1H2(80),8,2)
call Hotf_5pt_reduction(G2H2(11),RedSet_5(2),mass5set(:,11),  & 
G1H2(85),G1H2(86),G1H2(87),G1H2(88),G1H2(89),G1H2(90),2)
call HG1shiftOLR(G1H2(86),8,2)
call Hotf_5pt_reduction(G2H2(12),RedSet_5(2),mass5set(:,10),  & 
G1H2(91),G1H2(92),G1H2(93),G1H2(94),G1H2(95),G1H2(96),2)
call HG1shiftOLR(G1H2(92),8,2)
call Hotf_5pt_reduction(G2H2(13),RedSet_5(3),mass5set(:,12),  & 
G1H2(97),G1H2(98),G1H2(99),G1H2(100),G1H2(101),G1H2(102),2)
call HG1shiftOLR(G1H2(98),4,2)
call Hotf_5pt_reduction(G2H2(14),RedSet_5(3),mass5set(:,13),  & 
G1H2(103),G1H2(104),G1H2(105),G1H2(106),G1H2(107),G1H2(108),2)
call HG1shiftOLR(G1H2(104),4,2)
call Hotf_5pt_reduction(G2H2(15),RedSet_5(3),mass5set(:,13),  & 
G1H2(109),G1H2(110),G1H2(111),G1H2(112),G1H2(113),G1H2(114),2)
call HG1shiftOLR(G1H2(110),4,2)
call Hotf_5pt_reduction(G2H2(16),RedSet_5(4),mass5set(:,12),  & 
G1H2(115),G1H2(116),G1H2(117),G1H2(118),G1H2(119),G1H2(120),2)
call HG1shiftOLR(G1H2(116),8,2)
call Hotf_5pt_reduction(G2H2(17),RedSet_5(4),mass5set(:,13),  & 
G1H2(121),G1H2(122),G1H2(123),G1H2(124),G1H2(125),G1H2(126),2)
call HG1shiftOLR(G1H2(122),8,2)
call Hotf_5pt_reduction(G2H2(18),RedSet_5(4),mass5set(:,13),  & 
G1H2(127),G1H2(128),G1H2(129),G1H2(130),G1H2(131),G1H2(132),2)
call HG1shiftOLR(G1H2(128),8,2)
call Hotf_5pt_reduction(G2H2(19),RedSet_5(10),mass5set(:,14),  & 
G1H2(133),G1H2(134),G1H2(135),G1H2(136),G1H2(137),G1H2(138),2)
call HG1shiftOLR(G1H2(134),4,2)
call Hotf_5pt_reduction(G2H2(20),RedSet_5(10),mass5set(:,15),  & 
G1H2(139),G1H2(140),G1H2(141),G1H2(142),G1H2(143),G1H2(144),2)
call HG1shiftOLR(G1H2(140),4,2)
call Hotf_5pt_reduction(G2H2(21),RedSet_5(10),mass5set(:,14),  & 
G1H2(145),G1H2(146),G1H2(147),G1H2(148),G1H2(149),G1H2(150),2)
call HG1shiftOLR(G1H2(146),4,2)
call Hotf_5pt_reduction(G2H2(22),RedSet_5(11),mass5set(:,15),  & 
G1H2(151),G1H2(152),G1H2(153),G1H2(154),G1H2(155),G1H2(156),2)
call HG1shiftOLR(G1H2(152),8,2)
call Hotf_5pt_reduction(G2H2(23),RedSet_5(11),mass5set(:,14),  & 
G1H2(157),G1H2(158),G1H2(159),G1H2(160),G1H2(161),G1H2(162),2)
call HG1shiftOLR(G1H2(158),8,2)
call Hotf_5pt_reduction(G2H2(24),RedSet_5(11),mass5set(:,14),  & 
G1H2(163),G1H2(164),G1H2(165),G1H2(166),G1H2(167),G1H2(168),2)
call HG1shiftOLR(G1H2(164),8,2)
call Hotf_5pt_reduction(G2H2(25),RedSet_5(12),mass5set(:,16),  & 
G1H2(169),G1H2(170),G1H2(171),G1H2(172),G1H2(173),G1H2(174),2)
call HG1shiftOLR(G1H2(170),2,2)
call Hotf_5pt_reduction(G2H2(26),RedSet_5(12),mass5set(:,17),  & 
G1H2(175),G1H2(176),G1H2(177),G1H2(178),G1H2(179),G1H2(180),2)
call HG1shiftOLR(G1H2(176),2,2)
call Hotf_5pt_reduction(G2H2(27),RedSet_5(12),mass5set(:,18),  & 
G1H2(181),G1H2(182),G1H2(183),G1H2(184),G1H2(185),G1H2(186),2)
call HG1shiftOLR(G1H2(182),2,2)
call Hotf_5pt_reduction(G2H2(28),RedSet_5(12),mass5set(:,19),  & 
G1H2(187),G1H2(188),G1H2(189),G1H2(190),G1H2(191),G1H2(192),2)
call HG1shiftOLR(G1H2(188),2,2)
call Hotf_5pt_reduction(G2H2(29),RedSet_5(12),mass5set(:,20),  & 
G1H2(193),G1H2(194),G1H2(195),G1H2(196),G1H2(197),G1H2(198),2)
call HG1shiftOLR(G1H2(194),2,2)
call Hotf_5pt_reduction(G2H2(30),RedSet_5(12),mass5set(:,19),  & 
G1H2(199),G1H2(200),G1H2(201),G1H2(202),G1H2(203),G1H2(204),2)
call HG1shiftOLR(G1H2(200),2,2)
call Hotf_5pt_reduction(G2H2(31),RedSet_5(8),mass5set(:,16),  & 
G1H2(205),G1H2(206),G1H2(207),G1H2(208),G1H2(209),G1H2(210),2)
call HG1shiftOLR(G1H2(206),2,2)
call Hotf_5pt_reduction(G2H2(32),RedSet_5(8),mass5set(:,17),  & 
G1H2(211),G1H2(212),G1H2(213),G1H2(214),G1H2(215),G1H2(216),2)
call HG1shiftOLR(G1H2(212),2,2)
call Hotf_5pt_reduction(G2H2(33),RedSet_5(8),mass5set(:,18),  & 
G1H2(217),G1H2(218),G1H2(219),G1H2(220),G1H2(221),G1H2(222),2)
call HG1shiftOLR(G1H2(218),2,2)
call Hotf_5pt_reduction(G2H2(34),RedSet_5(8),mass5set(:,19),  & 
G1H2(223),G1H2(224),G1H2(225),G1H2(226),G1H2(227),G1H2(228),2)
call HG1shiftOLR(G1H2(224),2,2)
call Hotf_5pt_reduction(G2H2(35),RedSet_5(8),mass5set(:,20),  & 
G1H2(229),G1H2(230),G1H2(231),G1H2(232),G1H2(233),G1H2(234),2)
call HG1shiftOLR(G1H2(230),2,2)
call Hotf_5pt_reduction(G2H2(36),RedSet_5(8),mass5set(:,19),  & 
G1H2(235),G1H2(236),G1H2(237),G1H2(238),G1H2(239),G1H2(240),2)
call HG1shiftOLR(G1H2(236),2,2)
  call Hcheck_last_QA_V(ntryL,l_switch,G2H2(37),ex4(:),G2tensor(1),m3h2x1(:,1),heltab2x2(:,:,1))
  call Hcheck_last_QA_V(ntryL,l_switch,G2H2(39),ex4(:),G2tensor(2),m3h2x1(:,2),heltab2x2(:,:,2))
  call Hcheck_last_QA_V(ntryL,l_switch,G2H2(46),ex4(:),G2tensor(3),m3h2x1(:,3),heltab2x2(:,:,3))
  call Hcheck_last_QA_V(ntryL,l_switch,G2H2(48),ex4(:),G2tensor(4),m3h2x1(:,4),heltab2x2(:,:,4))
  call Hcheck_last_QA_V(ntryL,l_switch,G2H2(43),ex4(:),G2tensor(5),m3h2x1(:,5),heltab2x2(:,:,5))
  call Hcheck_last_QA_V(ntryL,l_switch,G2H2(45),ex4(:),G2tensor(6),m3h2x1(:,6),heltab2x2(:,:,6))
  call Hcheck_last_QA_V(ntryL,l_switch,G2H2(52),ex4(:),G2tensor(7),m3h2x1(:,7),heltab2x2(:,:,7))
  call Hcheck_last_QA_V(ntryL,l_switch,G2H2(54),ex4(:),G2tensor(8),m3h2x1(:,8),heltab2x2(:,:,8))
  call Hcheck_last_AQ_V(ntryL,l_switch,G2H2(55),ex3(:),G2tensor(9),m3h2x1(:,9),heltab2x2(:,:,9))
  call Hcheck_last_AQ_V(ntryL,l_switch,G2H2(57),ex3(:),G2tensor(10),m3h2x1(:,10),heltab2x2(:,:,10))
  call Hcheck_last_AQ_V(ntryL,l_switch,G2H2(64),ex3(:),G2tensor(11),m3h2x1(:,11),heltab2x2(:,:,11))
  call Hcheck_last_AQ_V(ntryL,l_switch,G2H2(66),ex3(:),G2tensor(12),m3h2x1(:,12),heltab2x2(:,:,12))
  call Hcheck_last_AQ_V(ntryL,l_switch,G2H2(61),ex3(:),G2tensor(13),m3h2x1(:,13),heltab2x2(:,:,13))
  call Hcheck_last_AQ_V(ntryL,l_switch,G2H2(63),ex3(:),G2tensor(14),m3h2x1(:,14),heltab2x2(:,:,14))
  call Hcheck_last_QA_V(ntryL,l_switch,G2H2(67),ex4(:),G2tensor(15),m3h2x1(:,15),heltab2x2(:,:,15))
  call Hcheck_last_QA_V(ntryL,l_switch,G2H2(69),ex4(:),G2tensor(16),m3h2x1(:,16),heltab2x2(:,:,16))
  call Hcheck_last_QA_V(ntryL,l_switch,G2H2(76),ex4(:),G2tensor(17),m3h2x1(:,17),heltab2x2(:,:,17))
  call Hcheck_last_QA_V(ntryL,l_switch,G2H2(78),ex4(:),G2tensor(18),m3h2x1(:,18),heltab2x2(:,:,18))
  call Hcheck_last_QA_V(ntryL,l_switch,G2H2(73),ex4(:),G2tensor(19),m3h2x1(:,19),heltab2x2(:,:,19))
  call Hcheck_last_QA_V(ntryL,l_switch,G2H2(75),ex4(:),G2tensor(20),m3h2x1(:,20),heltab2x2(:,:,20))
  call Hcheck_last_AQ_V(ntryL,l_switch,G2H2(79),ex3(:),G2tensor(21),m3h2x1(:,21),heltab2x2(:,:,21))
  call Hcheck_last_AQ_V(ntryL,l_switch,G2H2(81),ex3(:),G2tensor(22),m3h2x1(:,22),heltab2x2(:,:,22))
  call Hcheck_last_AQ_V(ntryL,l_switch,G2H2(88),ex3(:),G2tensor(23),m3h2x1(:,23),heltab2x2(:,:,23))
  call Hcheck_last_AQ_V(ntryL,l_switch,G2H2(90),ex3(:),G2tensor(24),m3h2x1(:,24),heltab2x2(:,:,24))
  call Hcheck_last_AQ_V(ntryL,l_switch,G2H2(85),ex3(:),G2tensor(25),m3h2x1(:,25),heltab2x2(:,:,25))
  call Hcheck_last_AQ_V(ntryL,l_switch,G2H2(87),ex3(:),G2tensor(26),m3h2x1(:,26),heltab2x2(:,:,26))
  call Hcheck_last_QA_V(ntryL,l_switch,G2H2(94),ex4(:),G2tensor(27),m3h2x1(:,27),heltab2x2(:,:,27))
  call Hcheck_last_QA_V(ntryL,l_switch,G2H2(96),ex4(:),G2tensor(28),m3h2x1(:,28),heltab2x2(:,:,28))
  call Hcheck_last_AQ_V(ntryL,l_switch,G2H2(100),ex3(:),G2tensor(29),m3h2x1(:,29),heltab2x2(:,:,29))
  call Hcheck_last_AQ_V(ntryL,l_switch,G2H2(102),ex3(:),G2tensor(30),m3h2x1(:,30),heltab2x2(:,:,30))
  call Hcheck_last_QA_V(ntryL,l_switch,G2H2(106),ex2(:),G2tensor(31),m3h2x1(:,31),heltab2x2(:,:,31))
  call Hcheck_last_QA_V(ntryL,l_switch,G2H2(108),ex2(:),G2tensor(32),m3h2x1(:,32),heltab2x2(:,:,32))
  call Hloop_VA_Q(ntryL,G1H2(25),ex4(:),G1H1(1),m3h2x1(:,33),heltab2x2(:,:,33))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,nMB,G2tensor(33),n2h1(1))
  call Hloop_VA_Q(ntryL,G1H2(26),ex4(:),G1H1(1),m3h2x1(:,34),heltab2x2(:,:,34))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),8,nMB,G2tensor(34),n2h1(2))
  call Hloop_VA_Q(ntryL,G1H2(30),ex4(:),G1H1(1),m3h2x1(:,35),heltab2x2(:,:,35))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,nMB,G2tensor(35),n2h1(3))
  call Hloop_VA_Q(ntryL,G1H2(31),ex4(:),G1H1(1),m3h2x1(:,36),heltab2x2(:,:,36))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,nMB,G2tensor(36),n2h1(4))
  call Hloop_VA_Q(ntryL,G1H2(32),ex4(:),G1H1(1),m3h2x1(:,37),heltab2x2(:,:,37))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),8,nMB,G2tensor(37),n2h1(5))
  call Hloop_VA_Q(ntryL,G1H2(36),ex4(:),G1H1(1),m3h2x1(:,38),heltab2x2(:,:,38))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,nMB,G2tensor(38),n2h1(6))
  call Hloop_SA_Q(ntryL,G1H2(37),ex4(:),G1H1(1),ngH,m3h2x1(:,39),heltab2x2(:,:,39))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,nMB,G2tensor(39),n2h1(7))
  call Hloop_SA_Q(ntryL,G1H2(38),ex4(:),G1H1(1),ngH,m3h2x1(:,40),heltab2x2(:,:,40))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),8,nMB,G2tensor(40),n2h1(8))
  call Hloop_SA_Q(ntryL,G1H2(42),ex4(:),G1H1(1),ngH,m3h2x1(:,41),heltab2x2(:,:,41))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,nMB,G2tensor(41),n2h1(9))
  call Hloop_SA_Q(ntryL,G1H2(43),ex4(:),G1H1(1),ngX,m3h2x1(:,42),heltab2x2(:,:,42))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,nMB,G2tensor(42),n2h1(10))
  call Hloop_SA_Q(ntryL,G1H2(44),ex4(:),G1H1(1),ngX,m3h2x1(:,43),heltab2x2(:,:,43))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),8,nMB,G2tensor(43),n2h1(11))
  call Hloop_SA_Q(ntryL,G1H2(48),ex4(:),G1H1(1),ngX,m3h2x1(:,44),heltab2x2(:,:,44))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,nMB,G2tensor(44),n2h1(12))
  call Hloop_VA_Q(ntryL,G1H2(49),ex4(:),G1H1(1),m3h2x1(:,45),heltab2x2(:,:,45))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,nMB,G2tensor(45),n2h1(13))
  call Hloop_VA_Q(ntryL,G1H2(50),ex4(:),G1H1(1),m3h2x1(:,46),heltab2x2(:,:,46))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),8,nMB,G2tensor(46),n2h1(14))
  call Hloop_VA_Q(ntryL,G1H2(54),ex4(:),G1H1(1),m3h2x1(:,47),heltab2x2(:,:,47))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,nMB,G2tensor(47),n2h1(15))
  call Hloop_ZA_Q(ntryL,G1H2(55),ex4(:),G1H1(1),ngZd,m3h2x1(:,48),heltab2x2(:,:,48))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,nMB,G2tensor(48),n2h1(16))
  call Hloop_ZA_Q(ntryL,G1H2(56),ex4(:),G1H1(1),ngZd,m3h2x1(:,49),heltab2x2(:,:,49))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),8,nMB,G2tensor(49),n2h1(17))
  call Hloop_ZA_Q(ntryL,G1H2(60),ex4(:),G1H1(1),ngZd,m3h2x1(:,50),heltab2x2(:,:,50))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,nMB,G2tensor(50),n2h1(18))
  call Hloop_SA_Q(ntryL,G1H2(61),ex4(:),G1H1(1),ngH,m3h2x1(:,51),heltab2x2(:,:,51))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,nMB,G2tensor(51),n2h1(19))
  call Hloop_SA_Q(ntryL,G1H2(62),ex4(:),G1H1(1),ngH,m3h2x1(:,52),heltab2x2(:,:,52))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),8,nMB,G2tensor(52),n2h1(20))
  call Hloop_SA_Q(ntryL,G1H2(66),ex4(:),G1H1(1),ngH,m3h2x1(:,53),heltab2x2(:,:,53))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,nMB,G2tensor(53),n2h1(21))
  call Hloop_SA_Q(ntryL,G1H2(67),ex4(:),G1H1(1),ngX,m3h2x1(:,54),heltab2x2(:,:,54))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,nMB,G2tensor(54),n2h1(22))
  call Hloop_SA_Q(ntryL,G1H2(68),ex4(:),G1H1(1),ngX,m3h2x1(:,55),heltab2x2(:,:,55))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),8,nMB,G2tensor(55),n2h1(23))
  call Hloop_SA_Q(ntryL,G1H2(72),ex4(:),G1H1(1),ngX,m3h2x1(:,56),heltab2x2(:,:,56))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,nMB,G2tensor(56),n2h1(24))
  call Hloop_VA_Q(ntryL,G1H2(73),ex4(:),G1H1(1),m3h2x1(:,57),heltab2x2(:,:,57))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,nMB,G2tensor(57),n2h1(25))
  call Hloop_VA_Q(ntryL,G1H2(74),ex4(:),G1H1(1),m3h2x1(:,58),heltab2x2(:,:,58))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),8,nMB,G2tensor(58),n2h1(26))
  call Hloop_VA_Q(ntryL,G1H2(78),ex4(:),G1H1(1),m3h2x1(:,59),heltab2x2(:,:,59))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,nMB,G2tensor(59),n2h1(27))
  call Hloop_VA_Q(ntryL,G1H2(79),ex4(:),G1H1(1),m3h2x1(:,60),heltab2x2(:,:,60))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,nMB,G2tensor(60),n2h1(28))
  call Hloop_VA_Q(ntryL,G1H2(80),ex4(:),G1H1(1),m3h2x1(:,61),heltab2x2(:,:,61))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),8,nMB,G2tensor(61),n2h1(29))
  call Hloop_VA_Q(ntryL,G1H2(84),ex4(:),G1H1(1),m3h2x1(:,62),heltab2x2(:,:,62))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,nMB,G2tensor(62),n2h1(30))
  call Hloop_VA_Q(ntryL,G1H2(85),ex4(:),G1H1(1),m3h2x1(:,63),heltab2x2(:,:,63))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,nMB,G2tensor(63),n2h1(31))
  call Hloop_VA_Q(ntryL,G1H2(86),ex4(:),G1H1(1),m3h2x1(:,64),heltab2x2(:,:,64))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),8,nMB,G2tensor(64),n2h1(32))
  call Hloop_VA_Q(ntryL,G1H2(90),ex4(:),G1H1(1),m3h2x1(:,65),heltab2x2(:,:,65))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,nMB,G2tensor(65),n2h1(33))
  call Hloop_ZA_Q(ntryL,G1H2(91),ex4(:),G1H1(1),ngZd,m3h2x1(:,66),heltab2x2(:,:,66))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,nMB,G2tensor(66),n2h1(34))
  call Hloop_ZA_Q(ntryL,G1H2(92),ex4(:),G1H1(1),ngZd,m3h2x1(:,67),heltab2x2(:,:,67))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),8,nMB,G2tensor(67),n2h1(35))
  call Hloop_ZA_Q(ntryL,G1H2(96),ex4(:),G1H1(1),ngZd,m3h2x1(:,68),heltab2x2(:,:,68))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,nMB,G2tensor(68),n2h1(36))
  call Hloop_VQ_A(ntryL,G1H2(97),ex3(:),G1H1(1),m3h2x1(:,69),heltab2x2(:,:,69))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,nMB,G2tensor(69),n2h1(37))
  call Hloop_VQ_A(ntryL,G1H2(98),ex3(:),G1H1(1),m3h2x1(:,70),heltab2x2(:,:,70))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),4,nMB,G2tensor(70),n2h1(38))
  call Hloop_VQ_A(ntryL,G1H2(102),ex3(:),G1H1(1),m3h2x1(:,71),heltab2x2(:,:,71))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,nMB,G2tensor(71),n2h1(39))
  call Hloop_SQ_A(ntryL,G1H2(103),ex3(:),G1H1(1),ngPtb,m3h2x1(:,72),heltab2x2(:,:,72))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,nMT,G2tensor(72),n2h1(40))
  call Hloop_SQ_A(ntryL,G1H2(104),ex3(:),G1H1(1),ngPtb,m3h2x1(:,73),heltab2x2(:,:,73))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),4,nMT,G2tensor(73),n2h1(41))
  call Hloop_SQ_A(ntryL,G1H2(108),ex3(:),G1H1(1),ngPtb,m3h2x1(:,74),heltab2x2(:,:,74))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,nMT,G2tensor(74),n2h1(42))
  call Hloop_WQ_A(ntryL,G1H2(109),ex3(:),G1H1(1),m3h2x1(:,75),heltab2x2(:,:,75))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,nMT,G2tensor(75),n2h1(43))
  call Hloop_WQ_A(ntryL,G1H2(110),ex3(:),G1H1(1),m3h2x1(:,76),heltab2x2(:,:,76))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),4,nMT,G2tensor(76),n2h1(44))
  call Hloop_WQ_A(ntryL,G1H2(114),ex3(:),G1H1(1),m3h2x1(:,77),heltab2x2(:,:,77))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,nMT,G2tensor(77),n2h1(45))
  call Hloop_VA_Q(ntryL,G1H2(115),ex4(:),G1H1(1),m3h2x1(:,78),heltab2x2(:,:,78))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,nMB,G2tensor(78),n2h1(46))
  call Hloop_VA_Q(ntryL,G1H2(116),ex4(:),G1H1(1),m3h2x1(:,79),heltab2x2(:,:,79))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),8,nMB,G2tensor(79),n2h1(47))
  call Hloop_VA_Q(ntryL,G1H2(120),ex4(:),G1H1(1),m3h2x1(:,80),heltab2x2(:,:,80))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,nMB,G2tensor(80),n2h1(48))
  call Hloop_SA_Q(ntryL,G1H2(121),ex4(:),G1H1(1),ngPbt,m3h2x1(:,81),heltab2x2(:,:,81))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,nMT,G2tensor(81),n2h1(49))
  call Hloop_SA_Q(ntryL,G1H2(122),ex4(:),G1H1(1),ngPbt,m3h2x1(:,82),heltab2x2(:,:,82))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),8,nMT,G2tensor(82),n2h1(50))
  call Hloop_SA_Q(ntryL,G1H2(126),ex4(:),G1H1(1),ngPbt,m3h2x1(:,83),heltab2x2(:,:,83))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,nMT,G2tensor(83),n2h1(51))
  call Hloop_WA_Q(ntryL,G1H2(127),ex4(:),G1H1(1),m3h2x1(:,84),heltab2x2(:,:,84))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,nMT,G2tensor(84),n2h1(52))
  call Hloop_WA_Q(ntryL,G1H2(128),ex4(:),G1H1(1),m3h2x1(:,85),heltab2x2(:,:,85))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),8,nMT,G2tensor(85),n2h1(53))
  call Hloop_WA_Q(ntryL,G1H2(132),ex4(:),G1H1(1),m3h2x1(:,86),heltab2x2(:,:,86))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,nMT,G2tensor(86),n2h1(54))
  call Hloop_SQ_A(ntryL,G1H2(133),ex3(:),G1H1(1),ngPtb,m3h2x1(:,87),heltab2x2(:,:,87))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,nMT,G2tensor(87),n2h1(55))
  call Hloop_SQ_A(ntryL,G1H2(134),ex3(:),G1H1(1),ngPtb,m3h2x1(:,88),heltab2x2(:,:,88))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),4,nMT,G2tensor(88),n2h1(56))
  call Hloop_SQ_A(ntryL,G1H2(138),ex3(:),G1H1(1),ngPtb,m3h2x1(:,89),heltab2x2(:,:,89))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,nMT,G2tensor(89),n2h1(57))
  call Hloop_VQ_A(ntryL,G1H2(139),ex3(:),G1H1(1),m3h2x1(:,90),heltab2x2(:,:,90))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,nMB,G2tensor(90),n2h1(58))
  call Hloop_VQ_A(ntryL,G1H2(140),ex3(:),G1H1(1),m3h2x1(:,91),heltab2x2(:,:,91))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),4,nMB,G2tensor(91),n2h1(59))
  call Hloop_VQ_A(ntryL,G1H2(144),ex3(:),G1H1(1),m3h2x1(:,92),heltab2x2(:,:,92))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,nMB,G2tensor(92),n2h1(60))
  call Hloop_WQ_A(ntryL,G1H2(145),ex3(:),G1H1(1),m3h2x1(:,93),heltab2x2(:,:,93))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,nMT,G2tensor(93),n2h1(61))
  call Hloop_WQ_A(ntryL,G1H2(146),ex3(:),G1H1(1),m3h2x1(:,94),heltab2x2(:,:,94))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),4,nMT,G2tensor(94),n2h1(62))
  call Hloop_WQ_A(ntryL,G1H2(150),ex3(:),G1H1(1),m3h2x1(:,95),heltab2x2(:,:,95))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,nMT,G2tensor(95),n2h1(63))
  call Hloop_VA_Q(ntryL,G1H2(151),ex4(:),G1H1(1),m3h2x1(:,96),heltab2x2(:,:,96))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,nMB,G2tensor(96),n2h1(64))
  call Hloop_VA_Q(ntryL,G1H2(152),ex4(:),G1H1(1),m3h2x1(:,97),heltab2x2(:,:,97))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),8,nMB,G2tensor(97),n2h1(65))
  call Hloop_VA_Q(ntryL,G1H2(156),ex4(:),G1H1(1),m3h2x1(:,98),heltab2x2(:,:,98))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,nMB,G2tensor(98),n2h1(66))
  call Hloop_SA_Q(ntryL,G1H2(157),ex4(:),G1H1(1),ngPbt,m3h2x1(:,99),heltab2x2(:,:,99))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,nMT,G2tensor(99),n2h1(67))
  call Hloop_SA_Q(ntryL,G1H2(158),ex4(:),G1H1(1),ngPbt,m3h2x1(:,100),heltab2x2(:,:,100))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),8,nMT,G2tensor(100),n2h1(68))
  call Hloop_SA_Q(ntryL,G1H2(162),ex4(:),G1H1(1),ngPbt,m3h2x1(:,101),heltab2x2(:,:,101))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,nMT,G2tensor(101),n2h1(69))
  call Hloop_WA_Q(ntryL,G1H2(163),ex4(:),G1H1(1),m3h2x1(:,102),heltab2x2(:,:,102))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,nMT,G2tensor(102),n2h1(70))
  call Hloop_WA_Q(ntryL,G1H2(164),ex4(:),G1H1(1),m3h2x1(:,103),heltab2x2(:,:,103))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),8,nMT,G2tensor(103),n2h1(71))
  call Hloop_WA_Q(ntryL,G1H2(168),ex4(:),G1H1(1),m3h2x1(:,104),heltab2x2(:,:,104))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,nMT,G2tensor(104),n2h1(72))
  call Hloop_VA_Q(ntryL,G1H2(169),ex2(:),G1H1(1),m3h2x1(:,105),heltab2x2(:,:,105))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,nMT,G2tensor(105),n2h1(73))
  call Hloop_VA_Q(ntryL,G1H2(170),ex2(:),G1H1(1),m3h2x1(:,106),heltab2x2(:,:,106))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),2,nMT,G2tensor(106),n2h1(74))
  call Hloop_VA_Q(ntryL,G1H2(174),ex2(:),G1H1(1),m3h2x1(:,107),heltab2x2(:,:,107))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,nMT,G2tensor(107),n2h1(75))
  call Hloop_VA_Q(ntryL,G1H2(175),ex2(:),G1H1(1),m3h2x1(:,108),heltab2x2(:,:,108))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,nMT,G2tensor(108),n2h1(76))
  call Hloop_VA_Q(ntryL,G1H2(176),ex2(:),G1H1(1),m3h2x1(:,109),heltab2x2(:,:,109))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),2,nMT,G2tensor(109),n2h1(77))
  call Hloop_VA_Q(ntryL,G1H2(180),ex2(:),G1H1(1),m3h2x1(:,110),heltab2x2(:,:,110))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,nMT,G2tensor(110),n2h1(78))
  call Hloop_SA_Q(ntryL,G1H2(181),ex2(:),G1H1(1),ngH,m3h2x1(:,111),heltab2x2(:,:,111))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,nMT,G2tensor(111),n2h1(79))
  call Hloop_SA_Q(ntryL,G1H2(182),ex2(:),G1H1(1),ngH,m3h2x1(:,112),heltab2x2(:,:,112))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),2,nMT,G2tensor(112),n2h1(80))
  call Hloop_SA_Q(ntryL,G1H2(186),ex2(:),G1H1(1),ngH,m3h2x1(:,113),heltab2x2(:,:,113))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,nMT,G2tensor(113),n2h1(81))
  call Hloop_SA_Q(ntryL,G1H2(187),ex2(:),G1H1(1),ngX,m3h2x1(:,114),heltab2x2(:,:,114))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,nMT,G2tensor(114),n2h1(82))
  call Hloop_SA_Q(ntryL,G1H2(188),ex2(:),G1H1(1),ngX,m3h2x1(:,115),heltab2x2(:,:,115))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),2,nMT,G2tensor(115),n2h1(83))
  call Hloop_SA_Q(ntryL,G1H2(192),ex2(:),G1H1(1),ngX,m3h2x1(:,116),heltab2x2(:,:,116))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,nMT,G2tensor(116),n2h1(84))
  call Hloop_VA_Q(ntryL,G1H2(193),ex2(:),G1H1(1),m3h2x1(:,117),heltab2x2(:,:,117))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,nMT,G2tensor(117),n2h1(85))
  call Hloop_VA_Q(ntryL,G1H2(194),ex2(:),G1H1(1),m3h2x1(:,118),heltab2x2(:,:,118))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),2,nMT,G2tensor(118),n2h1(86))
  call Hloop_VA_Q(ntryL,G1H2(198),ex2(:),G1H1(1),m3h2x1(:,119),heltab2x2(:,:,119))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,nMT,G2tensor(119),n2h1(87))
  call Hloop_ZA_Q(ntryL,G1H2(199),ex2(:),G1H1(1),ngZu,m3h2x1(:,120),heltab2x2(:,:,120))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,nMT,G2tensor(120),n2h1(88))
  call Hloop_ZA_Q(ntryL,G1H2(200),ex2(:),G1H1(1),ngZu,m3h2x1(:,121),heltab2x2(:,:,121))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),2,nMT,G2tensor(121),n2h1(89))
  call Hloop_ZA_Q(ntryL,G1H2(204),ex2(:),G1H1(1),ngZu,m3h2x1(:,122),heltab2x2(:,:,122))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,nMT,G2tensor(122),n2h1(90))
  call Hloop_VA_Q(ntryL,G1H2(205),ex2(:),G1H1(1),m3h2x1(:,123),heltab2x2(:,:,123))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,nMT,G2tensor(123),n2h1(91))
  call Hloop_VA_Q(ntryL,G1H2(206),ex2(:),G1H1(1),m3h2x1(:,124),heltab2x2(:,:,124))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),2,nMT,G2tensor(124),n2h1(92))
  call Hloop_VA_Q(ntryL,G1H2(210),ex2(:),G1H1(1),m3h2x1(:,125),heltab2x2(:,:,125))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,nMT,G2tensor(125),n2h1(93))
  call Hloop_VA_Q(ntryL,G1H2(211),ex2(:),G1H1(1),m3h2x1(:,126),heltab2x2(:,:,126))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,nMT,G2tensor(126),n2h1(94))
  call Hloop_VA_Q(ntryL,G1H2(212),ex2(:),G1H1(1),m3h2x1(:,127),heltab2x2(:,:,127))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),2,nMT,G2tensor(127),n2h1(95))
  call Hloop_VA_Q(ntryL,G1H2(216),ex2(:),G1H1(1),m3h2x1(:,128),heltab2x2(:,:,128))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,nMT,G2tensor(128),n2h1(96))
  call Hloop_SA_Q(ntryL,G1H2(217),ex2(:),G1H1(1),ngH,m3h2x1(:,129),heltab2x2(:,:,129))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,nMT,G2tensor(129),n2h1(97))
  call Hloop_SA_Q(ntryL,G1H2(218),ex2(:),G1H1(1),ngH,m3h2x1(:,130),heltab2x2(:,:,130))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),2,nMT,G2tensor(130),n2h1(98))
  call Hloop_SA_Q(ntryL,G1H2(222),ex2(:),G1H1(1),ngH,m3h2x1(:,131),heltab2x2(:,:,131))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,nMT,G2tensor(131),n2h1(99))
  call Hloop_SA_Q(ntryL,G1H2(223),ex2(:),G1H1(1),ngX,m3h2x1(:,132),heltab2x2(:,:,132))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,nMT,G2tensor(132),n2h1(100))
  call Hloop_SA_Q(ntryL,G1H2(224),ex2(:),G1H1(1),ngX,m3h2x1(:,133),heltab2x2(:,:,133))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),2,nMT,G2tensor(133),n2h1(101))
  call Hloop_SA_Q(ntryL,G1H2(228),ex2(:),G1H1(1),ngX,m3h2x1(:,134),heltab2x2(:,:,134))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,nMT,G2tensor(134),n2h1(102))
  call Hloop_VA_Q(ntryL,G1H2(229),ex2(:),G1H1(1),m3h2x1(:,135),heltab2x2(:,:,135))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,nMT,G2tensor(135),n2h1(103))
  call Hloop_VA_Q(ntryL,G1H2(230),ex2(:),G1H1(1),m3h2x1(:,136),heltab2x2(:,:,136))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),2,nMT,G2tensor(136),n2h1(104))
  call Hloop_VA_Q(ntryL,G1H2(234),ex2(:),G1H1(1),m3h2x1(:,137),heltab2x2(:,:,137))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,nMT,G2tensor(137),n2h1(105))
  call Hloop_ZA_Q(ntryL,G1H2(235),ex2(:),G1H1(1),ngZu,m3h2x1(:,138),heltab2x2(:,:,138))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,nMT,G2tensor(138),n2h1(106))
  call Hloop_ZA_Q(ntryL,G1H2(236),ex2(:),G1H1(1),ngZu,m3h2x1(:,139),heltab2x2(:,:,139))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),2,nMT,G2tensor(139),n2h1(107))
  call Hloop_ZA_Q(ntryL,G1H2(240),ex2(:),G1H1(1),ngZu,m3h2x1(:,140),heltab2x2(:,:,140))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,nMT,G2tensor(140),n2h1(108))
  call ol_merge_tensors(G2tensor(48),[G2tensor(42)])
  call ol_merge_tensors(G2tensor(66),[G2tensor(54)])
  call ol_merge_tensors(G2tensor(75),[G2tensor(72)])
  call ol_merge_tensors(G2tensor(84),[G2tensor(81)])
  call ol_merge_tensors(G2tensor(93),[G2tensor(87)])
  call ol_merge_tensors(G2tensor(102),[G2tensor(99)])
  call ol_merge_tensors(G2tensor(120),[G2tensor(114)])
  call ol_merge_tensors(G2tensor(138),[G2tensor(132)])
call Hotf_5pt_reduction_last(G2tensor(1),RedSet_5(1),mass5set(:,1),  & 
G1tensor(1),G1tensor(2),G1tensor(3),G1tensor(4),G1tensor(5),G1tensor(6))
call G_TensorShift(G1tensor(2),8)
call Hotf_5pt_reduction_last(G2tensor(3),RedSet_5(1),mass5set(:,2),  & 
G1tensor(7),G1tensor(8),G1tensor(9),G1tensor(10),G1tensor(11),G1tensor(12))
call G_TensorShift(G1tensor(8),8)
call Hotf_5pt_reduction_last(G2tensor(5),RedSet_5(1),mass5set(:,3),  & 
G1tensor(13),G1tensor(14),G1tensor(15),G1tensor(16),G1tensor(17),G1tensor(18))
call G_TensorShift(G1tensor(14),8)
call Hotf_5pt_reduction_last(G2tensor(7),RedSet_5(2),mass5set(:,4),  & 
G1tensor(19),G1tensor(20),G1tensor(21),G1tensor(22),G1tensor(23),G1tensor(24))
call G_TensorShift(G1tensor(20),8)
call Hotf_5pt_reduction_last(G2tensor(9),RedSet_5(3),mass5set(:,1),  & 
G1tensor(25),G1tensor(26),G1tensor(27),G1tensor(28),G1tensor(29),G1tensor(30))
call G_TensorShift(G1tensor(26),4)
call Hotf_5pt_reduction_last(G2tensor(11),RedSet_5(3),mass5set(:,2),  & 
G1tensor(31),G1tensor(32),G1tensor(33),G1tensor(34),G1tensor(35),G1tensor(36))
call G_TensorShift(G1tensor(32),4)
call Hotf_5pt_reduction_last(G2tensor(13),RedSet_5(3),mass5set(:,3),  & 
G1tensor(37),G1tensor(38),G1tensor(39),G1tensor(40),G1tensor(41),G1tensor(42))
call G_TensorShift(G1tensor(38),4)
call Hotf_5pt_reduction_last(G2tensor(15),RedSet_5(4),mass5set(:,1),  & 
G1tensor(43),G1tensor(44),G1tensor(45),G1tensor(46),G1tensor(47),G1tensor(48))
call G_TensorShift(G1tensor(44),8)
call Hotf_5pt_reduction_last(G2tensor(17),RedSet_5(4),mass5set(:,2),  & 
G1tensor(49),G1tensor(50),G1tensor(51),G1tensor(52),G1tensor(53),G1tensor(54))
call G_TensorShift(G1tensor(50),8)
call Hotf_5pt_reduction_last(G2tensor(19),RedSet_5(4),mass5set(:,3),  & 
G1tensor(55),G1tensor(56),G1tensor(57),G1tensor(58),G1tensor(59),G1tensor(60))
call G_TensorShift(G1tensor(56),8)
call Hotf_5pt_reduction_last(G2tensor(21),RedSet_5(5),mass5set(:,1),  & 
G1tensor(61),G1tensor(62),G1tensor(63),G1tensor(64),G1tensor(65),G1tensor(66))
call G_TensorShift(G1tensor(62),4)
call Hotf_5pt_reduction_last(G2tensor(23),RedSet_5(5),mass5set(:,2),  & 
G1tensor(67),G1tensor(68),G1tensor(69),G1tensor(70),G1tensor(71),G1tensor(72))
call G_TensorShift(G1tensor(68),4)
call Hotf_5pt_reduction_last(G2tensor(25),RedSet_5(5),mass5set(:,3),  & 
G1tensor(73),G1tensor(74),G1tensor(75),G1tensor(76),G1tensor(77),G1tensor(78))
call G_TensorShift(G1tensor(74),4)
call Hotf_5pt_reduction_last(G2tensor(27),RedSet_5(6),mass5set(:,5),  & 
G1tensor(79),G1tensor(80),G1tensor(81),G1tensor(82),G1tensor(83),G1tensor(84))
call G_TensorShift(G1tensor(80),8)
call Hotf_5pt_reduction_last(G2tensor(29),RedSet_5(7),mass5set(:,5),  & 
G1tensor(85),G1tensor(86),G1tensor(87),G1tensor(88),G1tensor(89),G1tensor(90))
call G_TensorShift(G1tensor(86),4)
call Hotf_5pt_reduction_last(G2tensor(31),RedSet_5(8),mass5set(:,6),  & 
G1tensor(91),G1tensor(92),G1tensor(93),G1tensor(94),G1tensor(95),G1tensor(96))
call G_TensorShift(G1tensor(92),2)
call Hotf_5pt_reduction_last(G2tensor(33),RedSet_5(9),mass5set(:,7),  & 
G1tensor(97),G1tensor(98),G1tensor(99),G1tensor(100),G1tensor(101),G1tensor(102))
call G_TensorShift(G1tensor(98),8)
call Hotf_5pt_reduction_last(G2tensor(36),RedSet_5(9),mass5set(:,8),  & 
G1tensor(103),G1tensor(104),G1tensor(105),G1tensor(106),G1tensor(107),G1tensor(108))
call G_TensorShift(G1tensor(104),8)
call Hotf_5pt_reduction_last(G2tensor(39),RedSet_5(9),mass5set(:,9),  & 
G1tensor(109),G1tensor(110),G1tensor(111),G1tensor(112),G1tensor(113),G1tensor(114))
call G_TensorShift(G1tensor(110),8)
call Hotf_5pt_reduction_last(G2tensor(48),RedSet_5(9),mass5set(:,10),  & 
G1tensor(115),G1tensor(116),G1tensor(117),G1tensor(118),G1tensor(119),G1tensor(120))
call G_TensorShift(G1tensor(116),8)
call Hotf_5pt_reduction_last(G2tensor(45),RedSet_5(9),mass5set(:,11),  & 
G1tensor(121),G1tensor(122),G1tensor(123),G1tensor(124),G1tensor(125),G1tensor(126))
call G_TensorShift(G1tensor(122),8)
call Hotf_5pt_reduction_last(G2tensor(51),RedSet_5(2),mass5set(:,9),  & 
G1tensor(127),G1tensor(128),G1tensor(129),G1tensor(130),G1tensor(131),G1tensor(132))
call G_TensorShift(G1tensor(128),8)
call Hotf_5pt_reduction_last(G2tensor(66),RedSet_5(2),mass5set(:,10),  & 
G1tensor(133),G1tensor(134),G1tensor(135),G1tensor(136),G1tensor(137),G1tensor(138))
call G_TensorShift(G1tensor(134),8)
call Hotf_5pt_reduction_last(G2tensor(57),RedSet_5(2),mass5set(:,7),  & 
G1tensor(139),G1tensor(140),G1tensor(141),G1tensor(142),G1tensor(143),G1tensor(144))
call G_TensorShift(G1tensor(140),8)
call Hotf_5pt_reduction_last(G2tensor(60),RedSet_5(2),mass5set(:,8),  & 
G1tensor(145),G1tensor(146),G1tensor(147),G1tensor(148),G1tensor(149),G1tensor(150))
call G_TensorShift(G1tensor(146),8)
call Hotf_5pt_reduction_last(G2tensor(63),RedSet_5(2),mass5set(:,11),  & 
G1tensor(151),G1tensor(152),G1tensor(153),G1tensor(154),G1tensor(155),G1tensor(156))
call G_TensorShift(G1tensor(152),8)
call Hotf_5pt_reduction_last(G2tensor(69),RedSet_5(3),mass5set(:,12),  & 
G1tensor(157),G1tensor(158),G1tensor(159),G1tensor(160),G1tensor(161),G1tensor(162))
call G_TensorShift(G1tensor(158),4)
call Hotf_5pt_reduction_last(G2tensor(75),RedSet_5(3),mass5set(:,13),  & 
G1tensor(163),G1tensor(164),G1tensor(165),G1tensor(166),G1tensor(167),G1tensor(168))
call G_TensorShift(G1tensor(164),4)
call Hotf_5pt_reduction_last(G2tensor(78),RedSet_5(4),mass5set(:,12),  & 
G1tensor(169),G1tensor(170),G1tensor(171),G1tensor(172),G1tensor(173),G1tensor(174))
call G_TensorShift(G1tensor(170),8)
call Hotf_5pt_reduction_last(G2tensor(84),RedSet_5(4),mass5set(:,13),  & 
G1tensor(175),G1tensor(176),G1tensor(177),G1tensor(178),G1tensor(179),G1tensor(180))
call G_TensorShift(G1tensor(176),8)
call Hotf_5pt_reduction_last(G2tensor(93),RedSet_5(10),mass5set(:,14),  & 
G1tensor(181),G1tensor(182),G1tensor(183),G1tensor(184),G1tensor(185),G1tensor(186))
call G_TensorShift(G1tensor(182),4)
call Hotf_5pt_reduction_last(G2tensor(90),RedSet_5(10),mass5set(:,15),  & 
G1tensor(187),G1tensor(188),G1tensor(189),G1tensor(190),G1tensor(191),G1tensor(192))
call G_TensorShift(G1tensor(188),4)
call Hotf_5pt_reduction_last(G2tensor(96),RedSet_5(11),mass5set(:,15),  & 
G1tensor(193),G1tensor(194),G1tensor(195),G1tensor(196),G1tensor(197),G1tensor(198))
call G_TensorShift(G1tensor(194),8)
call Hotf_5pt_reduction_last(G2tensor(102),RedSet_5(11),mass5set(:,14),  & 
G1tensor(199),G1tensor(200),G1tensor(201),G1tensor(202),G1tensor(203),G1tensor(204))
call G_TensorShift(G1tensor(200),8)
call Hotf_5pt_reduction_last(G2tensor(105),RedSet_5(12),mass5set(:,16),  & 
G1tensor(205),G1tensor(206),G1tensor(207),G1tensor(208),G1tensor(209),G1tensor(210))
call G_TensorShift(G1tensor(206),2)
call Hotf_5pt_reduction_last(G2tensor(108),RedSet_5(12),mass5set(:,17),  & 
G1tensor(211),G1tensor(212),G1tensor(213),G1tensor(214),G1tensor(215),G1tensor(216))
call G_TensorShift(G1tensor(212),2)
call Hotf_5pt_reduction_last(G2tensor(111),RedSet_5(12),mass5set(:,18),  & 
G1tensor(217),G1tensor(218),G1tensor(219),G1tensor(220),G1tensor(221),G1tensor(222))
call G_TensorShift(G1tensor(218),2)
call Hotf_5pt_reduction_last(G2tensor(120),RedSet_5(12),mass5set(:,19),  & 
G1tensor(223),G1tensor(224),G1tensor(225),G1tensor(226),G1tensor(227),G1tensor(228))
call G_TensorShift(G1tensor(224),2)
call Hotf_5pt_reduction_last(G2tensor(117),RedSet_5(12),mass5set(:,20),  & 
G1tensor(229),G1tensor(230),G1tensor(231),G1tensor(232),G1tensor(233),G1tensor(234))
call G_TensorShift(G1tensor(230),2)
call Hotf_5pt_reduction_last(G2tensor(123),RedSet_5(8),mass5set(:,16),  & 
G1tensor(235),G1tensor(236),G1tensor(237),G1tensor(238),G1tensor(239),G1tensor(240))
call G_TensorShift(G1tensor(236),2)
call Hotf_5pt_reduction_last(G2tensor(126),RedSet_5(8),mass5set(:,17),  & 
G1tensor(241),G1tensor(242),G1tensor(243),G1tensor(244),G1tensor(245),G1tensor(246))
call G_TensorShift(G1tensor(242),2)
call Hotf_5pt_reduction_last(G2tensor(129),RedSet_5(8),mass5set(:,18),  & 
G1tensor(247),G1tensor(248),G1tensor(249),G1tensor(250),G1tensor(251),G1tensor(252))
call G_TensorShift(G1tensor(248),2)
call Hotf_5pt_reduction_last(G2tensor(138),RedSet_5(8),mass5set(:,19),  & 
G1tensor(253),G1tensor(254),G1tensor(255),G1tensor(256),G1tensor(257),G1tensor(258))
call G_TensorShift(G1tensor(254),2)
call Hotf_5pt_reduction_last(G2tensor(135),RedSet_5(8),mass5set(:,20),  & 
G1tensor(259),G1tensor(260),G1tensor(261),G1tensor(262),G1tensor(263),G1tensor(264))
call G_TensorShift(G1tensor(260),2)
call ol_merge_tensors(T1sum(1),[G1tensor(1)])
call ol_merge_tensors(T1sum(2),[G1tensor(7)])
call ol_merge_tensors(T1sum(3),[G1tensor(13)])
call ol_merge_tensors(T1sum(4),[G1tensor(19)])
call ol_merge_tensors(T1sum(5),[G1tensor(25)])
call ol_merge_tensors(T1sum(6),[G1tensor(31)])
call ol_merge_tensors(T1sum(7),[G1tensor(37)])
call ol_merge_tensors(T1sum(8),[G1tensor(43)])
call ol_merge_tensors(T1sum(9),[G1tensor(49)])
call ol_merge_tensors(T1sum(10),[G1tensor(55)])
call ol_merge_tensors(T1sum(11),[G1tensor(61)])
call ol_merge_tensors(T1sum(12),[G1tensor(67)])
call ol_merge_tensors(T1sum(13),[G1tensor(73)])
call ol_merge_tensors(T1sum(14),[G1tensor(79)])
call ol_merge_tensors(T1sum(15),[G1tensor(85)])
call ol_merge_tensors(T1sum(16),[G1tensor(91)])
call ol_merge_tensors(T1sum(17),[G1tensor(97)])
call ol_merge_tensors(T1sum(18),[G1tensor(103)])
call ol_merge_tensors(T1sum(19),[G1tensor(109)])
call ol_merge_tensors(T1sum(20),[G1tensor(115)])
call ol_merge_tensors(T1sum(21),[G1tensor(121)])
call ol_merge_tensors(T1sum(22),[G1tensor(127)])
call ol_merge_tensors(T1sum(23),[G1tensor(133)])
call ol_merge_tensors(T1sum(24),[G1tensor(139)])
call ol_merge_tensors(T1sum(25),[G1tensor(145)])
call ol_merge_tensors(T1sum(26),[G1tensor(151)])
call ol_merge_tensors(T1sum(27),[G1tensor(157)])
call ol_merge_tensors(T1sum(28),[G1tensor(163)])
call ol_merge_tensors(T1sum(29),[G1tensor(169)])
call ol_merge_tensors(T1sum(30),[G1tensor(175)])
call ol_merge_tensors(T1sum(31),[G1tensor(181)])
call ol_merge_tensors(T1sum(32),[G1tensor(187)])
call ol_merge_tensors(T1sum(33),[G1tensor(193)])
call ol_merge_tensors(T1sum(34),[G1tensor(199)])
call ol_merge_tensors(T1sum(35),[G1tensor(205)])
call ol_merge_tensors(T1sum(36),[G1tensor(211)])
call ol_merge_tensors(T1sum(37),[G1tensor(217)])
call ol_merge_tensors(T1sum(38),[G1tensor(223)])
call ol_merge_tensors(T1sum(39),[G1tensor(229)])
call ol_merge_tensors(T1sum(40),[G1tensor(235)])
call ol_merge_tensors(T1sum(41),[G1tensor(241)])
call ol_merge_tensors(T1sum(42),[G1tensor(247)])
call ol_merge_tensors(T1sum(43),[G1tensor(253)])
call ol_merge_tensors(T1sum(44),[G1tensor(259)])
Gcoeff(:)%j = (c(52)*M(7,:)%j) * den(4)
call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(81),h0tab(:,81),[16,3,8,4],[nMB,nMB,0,nMB],4,1,wf4(:,3))
  call Hloop_QV_A(ntryL,G0H32(1),ex5(:),G0H16(1),m3h2x16(:,81),heltab2x32(:,:,81))
  call Hloop_Q_A(ntryL,G0H16(1),16,nMB,G1H16(6),n2h16(53))
Gcoeff(:)%j = (c(52)*M(7,:)%j) * den(7)
call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(82),h0tab(:,82),[16,3,8,4],[nMB,nMB,0,nMB],4,1,wf4(:,6))
  call Hloop_QV_A(ntryL,G0H32(1),ex5(:),G0H16(1),m3h2x16(:,82),heltab2x32(:,:,82))
  call Hloop_Q_A(ntryL,G0H16(1),16,nMB,G1H16(5),n2h16(54))
Gcoeff(:)%j = (-(c(49)*M(3,:)%j)+c(48)*M(7,:)%j) * den(1)
call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(83),h0tab(:,83),[16,3,8,4],[nMB,nMB,nMH,nMB],4,1,wf4(:,1))
  call Hloop_QV_A(ntryL,G0H32(1),ex5(:),G0H16(1),m3h2x16(:,83),heltab2x32(:,:,83))
  call Hloop_Q_A(ntryL,G0H16(1),16,nMB,G1H16(12),n2h16(55))
Gcoeff(:)%j = (c(49)*M(3,:)%j-c(48)*M(7,:)%j) * den(1)
call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(84),h0tab(:,84),[16,3,8,4],[nMB,nMB,nMZ,nMB],4,1,wf4(:,1))
  call Hloop_QV_A(ntryL,G0H32(1),ex5(:),G0H16(1),m3h2x16(:,84),heltab2x32(:,:,84))
  call Hloop_Q_A(ntryL,G0H16(1),16,nMB,G1H16(20),n2h16(56))
Gcoeff(:)%j = (c(45)*M(3,:)%j-c(44)*M(7,:)%j) * den(1)
call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(85),h0tab(:,85),[16,3,8,4],[nMT,nMT,nMW,nMT],4,1,wf4(:,1))
  call Hloop_QV_A(ntryL,G0H32(1),ex5(:),G0H16(1),m3h2x16(:,85),heltab2x32(:,:,85))
  call Hloop_Q_A(ntryL,G0H16(1),16,nMT,G1H16(19),n2h16(57))
Gcoeff(:)%j = (c(9)*M(7,:)%j) * den(1)
call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(86),h0tab(:,86),[16,3,8,4],[nMB,nMB,0,nMB],4,1,wf4(:,1))
  call Hloop_QV_A(ntryL,G0H32(1),ex5(:),G0H16(1),m3h2x16(:,86),heltab2x32(:,:,86))
  call Hloop_Q_A(ntryL,G0H16(1),16,nMB,G1H16(32),n2h16(58))
Gcoeff(:)%j = (-(c(14)*M(7,:)%j)) * den(7)
call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(87),h0tab(:,87),[16,3,8,4],[nMB,nMB,0,nMB],4,1,wf4(:,7))
  call Hloop_QV_A(ntryL,G0H32(1),ex5(:),G0H16(1),m3h2x16(:,87),heltab2x32(:,:,87))
  call Hloop_Q_A(ntryL,G0H16(1),16,nMB,G1H16(41),n2h16(59))
Gcoeff(:)%j = (c(8)*M(3,:)%j-c(7)*M(7,:)%j) * den(1)
call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(88),h0tab(:,88),[16,3,8,4],[nMB,nMB,0,nMB],4,1,wf4(:,1))
  call Hloop_QV_A(ntryL,G0H32(1),ex5(:),G0H16(1),m3h2x16(:,88),heltab2x32(:,:,88))
  call Hloop_Q_A(ntryL,G0H16(1),16,nMB,G1H16(46),n2h16(60))
Gcoeff(:)%j = (c(15)*M(3,:)%j-c(14)*M(7,:)%j) * den(1)
call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(89),h0tab(:,89),[16,3,8,4],[nMB,nMB,nMZ,nMB],4,1,wf4(:,1))
  call Hloop_QV_A(ntryL,G0H32(1),ex5(:),G0H16(1),m3h2x16(:,89),heltab2x32(:,:,89))
  call Hloop_Q_A(ntryL,G0H16(1),16,nMB,G1H16(64),n2h16(61))
Gcoeff(:)%j = (c(40)*M(3,:)%j-c(39)*M(7,:)%j) * den(1)
call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(90),h0tab(:,90),[16,3,8,4],[nMT,nMT,nMW,nMT],4,1,wf4(:,1))
  call Hloop_QV_A(ntryL,G0H32(1),ex5(:),G0H16(1),m3h2x16(:,90),heltab2x32(:,:,90))
  call Hloop_Q_A(ntryL,G0H16(1),16,nMT,G1H16(63),n2h16(62))
Gcoeff(:)%j = (c(30)*M(2,:)%j-c(27)*M(4,:)%j+c(26)*M(8,:)%j) * den(1)
call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(91),h0tab(:,91),[16,3,8,4],[nMB,nMB,0,nMB],4,1,wf4(:,1))
  call Hloop_QV_A(ntryL,G0H32(1),ex5(:),G0H16(1),m3h2x16(:,91),heltab2x32(:,:,91))
  call Hloop_Q_A(ntryL,G0H16(1),16,nMB,G1H16(75),n2h16(63))
Gcoeff(:)%j = (c(35)*M(4,:)%j+c(30)*(M(2,:)%j-M(8,:)%j)) * den(1)
call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(92),h0tab(:,92),[16,3,8,4],[0,0,nMB,0],4,1,wf4(:,1))
  call Hloop_UV_W(ntryL,G0H32(1),0,ex5(:),16,G1H16(74),m3h2x16(:,92),heltab2x32(:,:,92))
Gcoeff(:)%j = (c(52)*M(7,:)%j) * den(4)
call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(93),h0tab(:,93),[16,3,4,8],[nMB,nMB,0,nMB],4,1,wf4(:,3))
  call Hloop_AV_Q(ntryL,G0H32(1),ex5(:),G0H16(1),m3h2x16(:,93),heltab2x32(:,:,93))
  call Hloop_A_Q(ntryL,G0H16(1),16,nMB,G1H16(1),n2h16(64))
Gcoeff(:)%j = (c(52)*M(7,:)%j) * den(7)
call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(94),h0tab(:,94),[16,3,4,8],[nMB,nMB,0,nMB],4,1,wf4(:,6))
  call Hloop_AV_Q(ntryL,G0H32(1),ex5(:),G0H16(1),m3h2x16(:,94),heltab2x32(:,:,94))
  call Hloop_A_Q(ntryL,G0H16(1),16,nMB,G1H16(2),n2h16(65))
Gcoeff(:)%j = (-(c(49)*M(5,:)%j)+c(48)*M(7,:)%j) * den(1)
call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(95),h0tab(:,95),[16,3,4,8],[nMB,nMB,nMH,nMB],4,1,wf4(:,1))
  call Hloop_AV_Q(ntryL,G0H32(1),ex5(:),G0H16(1),m3h2x16(:,95),heltab2x32(:,:,95))
  call Hloop_A_Q(ntryL,G0H16(1),16,nMB,G1H16(3),n2h16(66))
Gcoeff(:)%j = (c(49)*M(5,:)%j-c(48)*M(7,:)%j) * den(1)
call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(96),h0tab(:,96),[16,3,4,8],[nMB,nMB,nMZ,nMB],4,1,wf4(:,1))
  call Hloop_AV_Q(ntryL,G0H32(1),ex5(:),G0H16(1),m3h2x16(:,96),heltab2x32(:,:,96))
  call Hloop_A_Q(ntryL,G0H16(1),16,nMB,G1H16(4),n2h16(67))
Gcoeff(:)%j = (c(45)*M(5,:)%j-c(44)*M(7,:)%j) * den(1)
call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(97),h0tab(:,97),[16,3,4,8],[nMT,nMT,nMW,nMT],4,1,wf4(:,1))
  call Hloop_AV_Q(ntryL,G0H32(1),ex5(:),G0H16(1),m3h2x16(:,97),heltab2x32(:,:,97))
  call Hloop_A_Q(ntryL,G0H16(1),16,nMT,G1H16(9),n2h16(68))
Gcoeff(:)%j = (c(9)*M(7,:)%j) * den(1)
call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(98),h0tab(:,98),[16,3,4,8],[nMB,nMB,0,nMB],4,1,wf4(:,1))
  call Hloop_AV_Q(ntryL,G0H32(1),ex5(:),G0H16(1),m3h2x16(:,98),heltab2x32(:,:,98))
  call Hloop_A_Q(ntryL,G0H16(1),16,nMB,G1H16(7),n2h16(69))
Gcoeff(:)%j = (-(c(14)*M(7,:)%j)) * den(7)
call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(99),h0tab(:,99),[16,3,4,8],[nMB,nMB,0,nMB],4,1,wf4(:,7))
  call Hloop_AV_Q(ntryL,G0H32(1),ex5(:),G0H16(1),m3h2x16(:,99),heltab2x32(:,:,99))
  call Hloop_A_Q(ntryL,G0H16(1),16,nMB,G1H16(8),n2h16(70))
Gcoeff(:)%j = (c(8)*M(5,:)%j-c(7)*M(7,:)%j) * den(1)
call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(100),h0tab(:,100),[16,3,4,8],[nMB,nMB,0,nMB],4,1,wf4(:,1))
  call Hloop_AV_Q(ntryL,G0H32(1),ex5(:),G0H16(1),m3h2x16(:,100),heltab2x32(:,:,100))
  call Hloop_A_Q(ntryL,G0H16(1),16,nMB,G1H16(10),n2h16(71))
Gcoeff(:)%j = (c(15)*M(5,:)%j-c(14)*M(7,:)%j) * den(1)
call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(101),h0tab(:,101),[16,3,4,8],[nMB,nMB,nMZ,nMB],4,1,wf4(:,1))
  call Hloop_AV_Q(ntryL,G0H32(1),ex5(:),G0H16(1),m3h2x16(:,101),heltab2x32(:,:,101))
  call Hloop_A_Q(ntryL,G0H16(1),16,nMB,G1H16(11),n2h16(72))
Gcoeff(:)%j = (c(40)*M(5,:)%j-c(39)*M(7,:)%j) * den(1)
call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(102),h0tab(:,102),[16,3,4,8],[nMT,nMT,nMW,nMT],4,1,wf4(:,1))
  call Hloop_AV_Q(ntryL,G0H32(1),ex5(:),G0H16(1),m3h2x16(:,102),heltab2x32(:,:,102))
  call Hloop_A_Q(ntryL,G0H16(1),16,nMT,G1H16(14),n2h16(73))
Gcoeff(:)%j = (c(30)*M(2,:)%j-c(27)*M(6,:)%j+c(26)*M(8,:)%j) * den(1)
call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(103),h0tab(:,103),[16,3,4,8],[nMB,nMB,0,nMB],4,1,wf4(:,1))
  call Hloop_AV_Q(ntryL,G0H32(1),ex5(:),G0H16(1),m3h2x16(:,103),heltab2x32(:,:,103))
  call Hloop_A_Q(ntryL,G0H16(1),16,nMB,G1H16(13),n2h16(74))
Gcoeff(:)%j = (c(35)*M(6,:)%j+c(30)*(M(2,:)%j-M(8,:)%j)) * den(1)
call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(104),h0tab(:,104),[16,3,4,8],[0,0,nMB,0],4,1,wf4(:,1))
  call Hloop_UV_W(ntryL,G0H32(1),0,ex5(:),16,G1H16(15),m3h2x16(:,104),heltab2x32(:,:,104))
Gcoeff(:)%j = (c(51)*M(7,:)%j) * den(4)
call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(105),h0tab(:,105),[16,4,3,8],[0,nMB,nMB,0],4,1,wf4(:,3))
  call Hloop_UV_W(ntryL,G0H32(1),0,ex5(:),16,G1H16(16),m3h2x16(:,105),heltab2x32(:,:,105))
Gcoeff(:)%j = (c(51)*M(7,:)%j) * den(7)
call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(106),h0tab(:,106),[16,4,3,8],[0,nMB,nMB,0],4,1,wf4(:,6))
  call Hloop_UV_W(ntryL,G0H32(1),0,ex5(:),16,G1H16(17),m3h2x16(:,106),heltab2x32(:,:,106))
Gcoeff(:)%j = (-(c(20)*M(2,:)%j)) * den(1)
call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(107),h0tab(:,107),[16,4,3,8],[nMB,0,0,nMB],4,1,wf4(:,1))
  call Hloop_AV_Q(ntryL,G0H32(1),ex5(:),G0H16(1),m3h2x16(:,107),heltab2x32(:,:,107))
  call Hloop_A_Q(ntryL,G0H16(1),16,nMB,G1H16(18),n2h16(75))
Gcoeff(:)%j = (c(3)*M(7,:)%j) * den(1)
call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(108),h0tab(:,108),[16,4,3,8],[0,nMB,nMB,0],4,1,wf4(:,1))
  call Hloop_UV_W(ntryL,G0H32(1),0,ex5(:),16,G1H16(23),m3h2x16(:,108),heltab2x32(:,:,108))
Gcoeff(:)%j = (-(c(6)*M(7,:)%j)) * den(7)
call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(109),h0tab(:,109),[16,4,3,8],[0,nMB,nMB,0],4,1,wf4(:,7))
  call Hloop_UV_W(ntryL,G0H32(1),0,ex5(:),16,G1H16(21),m3h2x16(:,109),heltab2x32(:,:,109))
Gcoeff(:)%j = (c(20)*M(2,:)%j) * den(1)
call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(110),h0tab(:,110),[16,4,3,8],[0,nMB,nMB,0],4,1,wf4(:,1))
  call Hloop_UV_W(ntryL,G0H32(1),0,ex5(:),16,G1H16(22),m3h2x16(:,110),heltab2x32(:,:,110))
Gcoeff(:)%j = (c(44)*M(5,:)%j) * den(15)
call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(111),h0tab(:,111),[16,1,8,6],[nMT,0,nMB,nMT],4,1,wf4(:,11))
  call Hloop_AV_Q(ntryL,G0H32(1),ex5(:),G0H16(1),m3h2x16(:,111),heltab2x32(:,:,111))
  call Hloop_A_Q(ntryL,G0H16(1),16,nMT,G1H16(24),n2h16(76))
Gcoeff(:)%j = (c(39)*M(5,:)%j) * den(15)
call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(112),h0tab(:,112),[16,1,8,6],[nMT,0,nMB,nMT],4,1,wf4(:,13))
  call Hloop_AV_Q(ntryL,G0H32(1),ex5(:),G0H16(1),m3h2x16(:,112),heltab2x32(:,:,112))
  call Hloop_A_Q(ntryL,G0H16(1),16,nMT,G1H16(25),n2h16(77))
Gcoeff(:)%j = (c(44)*M(5,:)%j) * den(15)
call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(113),h0tab(:,113),[16,6,1,8],[nMB,nMT,0,nMB],4,1,wf4(:,11))
  call Hloop_AV_Q(ntryL,G0H32(1),ex5(:),G0H16(1),m3h2x16(:,113),heltab2x32(:,:,113))
  call Hloop_A_Q(ntryL,G0H16(1),16,nMB,G1H16(26),n2h16(78))
Gcoeff(:)%j = (c(39)*M(5,:)%j) * den(15)
call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(114),h0tab(:,114),[16,6,1,8],[nMB,nMT,0,nMB],4,1,wf4(:,13))
  call Hloop_AV_Q(ntryL,G0H32(1),ex5(:),G0H16(1),m3h2x16(:,114),heltab2x32(:,:,114))
  call Hloop_A_Q(ntryL,G0H16(1),16,nMB,G1H16(27),n2h16(79))
Gcoeff(:)%j = (c(43)*M(5,:)%j) * den(15)
call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(115),h0tab(:,115),[16,1,6,8],[0,nMT,nMB,0],4,1,wf4(:,11))
  call Hloop_UV_W(ntryL,G0H32(1),0,ex5(:),16,G1H16(28),m3h2x16(:,115),heltab2x32(:,:,115))
Gcoeff(:)%j = (c(38)*M(5,:)%j) * den(15)
call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(116),h0tab(:,116),[16,1,6,8],[0,nMT,nMB,0],4,1,wf4(:,13))
  call Hloop_UV_W(ntryL,G0H32(1),0,ex5(:),16,G1H16(29),m3h2x16(:,116),heltab2x32(:,:,116))
Gcoeff(:)%j = (c(44)*M(3,:)%j) * den(18)
call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(117),h0tab(:,117),[16,2,4,9],[nMT,0,nMB,nMT],4,1,wf4(:,14))
  call Hloop_QV_A(ntryL,G0H32(1),ex5(:),G0H16(1),m3h2x16(:,117),heltab2x32(:,:,117))
  call Hloop_Q_A(ntryL,G0H16(1),16,nMT,G1H16(30),n2h16(80))
Gcoeff(:)%j = (c(39)*M(3,:)%j) * den(18)
call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(118),h0tab(:,118),[16,2,4,9],[nMT,0,nMB,nMT],4,1,wf4(:,17))
  call Hloop_QV_A(ntryL,G0H32(1),ex5(:),G0H16(1),m3h2x16(:,118),heltab2x32(:,:,118))
  call Hloop_Q_A(ntryL,G0H16(1),16,nMT,G1H16(31),n2h16(81))
Gcoeff(:)%j = (c(44)*M(3,:)%j) * den(18)
call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(119),h0tab(:,119),[16,4,2,9],[nMB,0,nMT,nMB],4,1,wf4(:,14))
  call Hloop_AV_Q(ntryL,G0H32(1),ex5(:),G0H16(1),m3h2x16(:,119),heltab2x32(:,:,119))
  call Hloop_A_Q(ntryL,G0H16(1),16,nMB,G1H16(34),n2h16(82))
Gcoeff(:)%j = (c(39)*M(3,:)%j) * den(18)
call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(120),h0tab(:,120),[16,4,2,9],[nMB,0,nMT,nMB],4,1,wf4(:,17))
  call Hloop_AV_Q(ntryL,G0H32(1),ex5(:),G0H16(1),m3h2x16(:,120),heltab2x32(:,:,120))
  call Hloop_A_Q(ntryL,G0H16(1),16,nMB,G1H16(33),n2h16(83))
Gcoeff(:)%j = (-(c(43)*M(3,:)%j)) * den(18)
call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(121),h0tab(:,121),[16,2,9,4],[0,nMT,nMB,0],4,1,wf4(:,14))
  call Hloop_UV_W(ntryL,G0H32(1),0,ex5(:),16,G1H16(35),m3h2x16(:,121),heltab2x32(:,:,121))
Gcoeff(:)%j = (-(c(38)*M(3,:)%j)) * den(18)
call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(122),h0tab(:,122),[16,2,9,4],[0,nMT,nMB,0],4,1,wf4(:,17))
  call Hloop_UV_W(ntryL,G0H32(1),0,ex5(:),16,G1H16(36),m3h2x16(:,122),heltab2x32(:,:,122))
Gcoeff(:)%j = (c(52)*M(1,:)%j) * den(22)
call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(123),h0tab(:,123),[16,1,2,12],[nMT,0,nMT,nMT],4,1,wf4(:,18))
  call Hloop_AV_Q(ntryL,G0H32(1),ex5(:),G0H16(1),m3h2x16(:,123),heltab2x32(:,:,123))
  call Hloop_A_Q(ntryL,G0H16(1),16,nMT,G1H16(37),n2h16(84))
Gcoeff(:)%j = (c(52)*M(1,:)%j) * den(24)
call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(124),h0tab(:,124),[16,1,2,12],[nMT,0,nMT,nMT],4,1,wf4(:,19))
  call Hloop_AV_Q(ntryL,G0H32(1),ex5(:),G0H16(1),m3h2x16(:,124),heltab2x32(:,:,124))
  call Hloop_A_Q(ntryL,G0H16(1),16,nMT,G1H16(38),n2h16(85))
Gcoeff(:)%j = (c(56)*M(1,:)%j-c(57)*M(5,:)%j) * den(2)
call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(125),h0tab(:,125),[16,1,2,12],[nMT,nMH,nMT,nMT],4,1,wf4(:,2))
  call Hloop_AV_Q(ntryL,G0H32(1),ex5(:),G0H16(1),m3h2x16(:,125),heltab2x32(:,:,125))
  call Hloop_A_Q(ntryL,G0H16(1),16,nMT,G1H16(39),n2h16(86))
Gcoeff(:)%j = (-(c(56)*M(1,:)%j)+c(57)*M(5,:)%j) * den(2)
call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(126),h0tab(:,126),[16,1,2,12],[nMT,nMZ,nMT,nMT],4,1,wf4(:,2))
  call Hloop_AV_Q(ntryL,G0H32(1),ex5(:),G0H16(1),m3h2x16(:,126),heltab2x32(:,:,126))
  call Hloop_A_Q(ntryL,G0H16(1),16,nMT,G1H16(40),n2h16(87))
Gcoeff(:)%j = (-(c(44)*M(1,:)%j)+c(45)*M(5,:)%j) * den(2)
call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(127),h0tab(:,127),[16,1,2,12],[nMB,nMW,nMB,nMB],4,1,wf4(:,2))
  call Hloop_AV_Q(ntryL,G0H32(1),ex5(:),G0H16(1),m3h2x16(:,127),heltab2x32(:,:,127))
  call Hloop_A_Q(ntryL,G0H16(1),16,nMB,G1H16(43),n2h16(88))
Gcoeff(:)%j = (c(9)*M(1,:)%j) * den(2)
call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(128),h0tab(:,128),[16,1,2,12],[nMT,0,nMT,nMT],4,1,wf4(:,2))
  call Hloop_AV_Q(ntryL,G0H32(1),ex5(:),G0H16(1),m3h2x16(:,128),heltab2x32(:,:,128))
  call Hloop_A_Q(ntryL,G0H16(1),16,nMT,G1H16(42),n2h16(89))
Gcoeff(:)%j = (-(c(14)*M(1,:)%j)) * den(24)
call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(129),h0tab(:,129),[16,1,2,12],[nMT,0,nMT,nMT],4,1,wf4(:,20))
  call Hloop_AV_Q(ntryL,G0H32(1),ex5(:),G0H16(1),m3h2x16(:,129),heltab2x32(:,:,129))
  call Hloop_A_Q(ntryL,G0H16(1),16,nMT,G1H16(44),n2h16(90))
Gcoeff(:)%j = (-(c(12)*M(1,:)%j)+c(13)*M(5,:)%j) * den(2)
call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(130),h0tab(:,130),[16,1,2,12],[nMT,0,nMT,nMT],4,1,wf4(:,2))
  call Hloop_AV_Q(ntryL,G0H32(1),ex5(:),G0H16(1),m3h2x16(:,130),heltab2x32(:,:,130))
  call Hloop_A_Q(ntryL,G0H16(1),16,nMT,G1H16(45),n2h16(91))
Gcoeff(:)%j = (-(c(14)*M(1,:)%j)+c(15)*M(5,:)%j) * den(2)
call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(131),h0tab(:,131),[16,1,2,12],[nMT,nMZ,nMT,nMT],4,1,wf4(:,2))
  call Hloop_AV_Q(ntryL,G0H32(1),ex5(:),G0H16(1),m3h2x16(:,131),heltab2x32(:,:,131))
  call Hloop_A_Q(ntryL,G0H16(1),16,nMT,G1H16(48),n2h16(92))
Gcoeff(:)%j = (-(c(39)*M(1,:)%j)+c(40)*M(5,:)%j) * den(2)
call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(132),h0tab(:,132),[16,1,2,12],[nMB,nMW,nMB,nMB],4,1,wf4(:,2))
  call Hloop_AV_Q(ntryL,G0H32(1),ex5(:),G0H16(1),m3h2x16(:,132),heltab2x32(:,:,132))
  call Hloop_A_Q(ntryL,G0H16(1),16,nMB,G1H16(47),n2h16(93))
Gcoeff(:)%j = (c(26)*M(2,:)%j-c(27)*M(6,:)%j+c(30)*M(8,:)%j) * den(2)
call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(133),h0tab(:,133),[16,1,2,12],[nMT,0,nMT,nMT],4,1,wf4(:,2))
  call Hloop_AV_Q(ntryL,G0H32(1),ex5(:),G0H16(1),m3h2x16(:,133),heltab2x32(:,:,133))
  call Hloop_A_Q(ntryL,G0H16(1),16,nMT,G1H16(49),n2h16(94))
Gcoeff(:)%j = (c(35)*M(6,:)%j+c(30)*(-M(2,:)%j+M(8,:)%j)) * den(2)
call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(134),h0tab(:,134),[16,1,2,12],[0,nMT,0,0],4,1,wf4(:,2))
  call Hloop_UV_W(ntryL,G0H32(1),0,ex5(:),16,G1H16(50),m3h2x16(:,134),heltab2x32(:,:,134))
Gcoeff(:)%j = (c(52)*M(1,:)%j) * den(22)
call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(135),h0tab(:,135),[16,2,1,12],[nMT,0,nMT,nMT],4,1,wf4(:,18))
  call Hloop_QV_A(ntryL,G0H32(1),ex5(:),G0H16(1),m3h2x16(:,135),heltab2x32(:,:,135))
  call Hloop_Q_A(ntryL,G0H16(1),16,nMT,G1H16(51),n2h16(95))
Gcoeff(:)%j = (c(52)*M(1,:)%j) * den(24)
call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(136),h0tab(:,136),[16,2,1,12],[nMT,0,nMT,nMT],4,1,wf4(:,19))
  call Hloop_QV_A(ntryL,G0H32(1),ex5(:),G0H16(1),m3h2x16(:,136),heltab2x32(:,:,136))
  call Hloop_Q_A(ntryL,G0H16(1),16,nMT,G1H16(52),n2h16(96))
Gcoeff(:)%j = (c(56)*M(1,:)%j-c(57)*M(3,:)%j) * den(2)
call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(137),h0tab(:,137),[16,2,1,12],[nMT,nMH,nMT,nMT],4,1,wf4(:,2))
  call Hloop_QV_A(ntryL,G0H32(1),ex5(:),G0H16(1),m3h2x16(:,137),heltab2x32(:,:,137))
  call Hloop_Q_A(ntryL,G0H16(1),16,nMT,G1H16(53),n2h16(97))
Gcoeff(:)%j = (-(c(56)*M(1,:)%j)+c(57)*M(3,:)%j) * den(2)
call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(138),h0tab(:,138),[16,2,1,12],[nMT,nMZ,nMT,nMT],4,1,wf4(:,2))
  call Hloop_QV_A(ntryL,G0H32(1),ex5(:),G0H16(1),m3h2x16(:,138),heltab2x32(:,:,138))
  call Hloop_Q_A(ntryL,G0H16(1),16,nMT,G1H16(54),n2h16(98))
Gcoeff(:)%j = (-(c(44)*M(1,:)%j)+c(45)*M(3,:)%j) * den(2)
call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(139),h0tab(:,139),[16,2,1,12],[nMB,nMW,nMB,nMB],4,1,wf4(:,2))
  call Hloop_QV_A(ntryL,G0H32(1),ex5(:),G0H16(1),m3h2x16(:,139),heltab2x32(:,:,139))
  call Hloop_Q_A(ntryL,G0H16(1),16,nMB,G1H16(55),n2h16(99))
Gcoeff(:)%j = (c(9)*M(1,:)%j) * den(2)
call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(140),h0tab(:,140),[16,2,1,12],[nMT,0,nMT,nMT],4,1,wf4(:,2))
  call Hloop_QV_A(ntryL,G0H32(1),ex5(:),G0H16(1),m3h2x16(:,140),heltab2x32(:,:,140))
  call Hloop_Q_A(ntryL,G0H16(1),16,nMT,G1H16(56),n2h16(100))
Gcoeff(:)%j = (-(c(14)*M(1,:)%j)) * den(24)
call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(141),h0tab(:,141),[16,2,1,12],[nMT,0,nMT,nMT],4,1,wf4(:,20))
  call Hloop_QV_A(ntryL,G0H32(1),ex5(:),G0H16(1),m3h2x16(:,141),heltab2x32(:,:,141))
  call Hloop_Q_A(ntryL,G0H16(1),16,nMT,G1H16(57),n2h16(101))
Gcoeff(:)%j = (-(c(12)*M(1,:)%j)+c(13)*M(3,:)%j) * den(2)
call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(142),h0tab(:,142),[16,2,1,12],[nMT,0,nMT,nMT],4,1,wf4(:,2))
  call Hloop_QV_A(ntryL,G0H32(1),ex5(:),G0H16(1),m3h2x16(:,142),heltab2x32(:,:,142))
  call Hloop_Q_A(ntryL,G0H16(1),16,nMT,G1H16(58),n2h16(102))
Gcoeff(:)%j = (-(c(14)*M(1,:)%j)+c(15)*M(3,:)%j) * den(2)
call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(143),h0tab(:,143),[16,2,1,12],[nMT,nMZ,nMT,nMT],4,1,wf4(:,2))
  call Hloop_QV_A(ntryL,G0H32(1),ex5(:),G0H16(1),m3h2x16(:,143),heltab2x32(:,:,143))
  call Hloop_Q_A(ntryL,G0H16(1),16,nMT,G1H16(59),n2h16(103))
Gcoeff(:)%j = (-(c(39)*M(1,:)%j)+c(40)*M(3,:)%j) * den(2)
call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(144),h0tab(:,144),[16,2,1,12],[nMB,nMW,nMB,nMB],4,1,wf4(:,2))
  call Hloop_QV_A(ntryL,G0H32(1),ex5(:),G0H16(1),m3h2x16(:,144),heltab2x32(:,:,144))
  call Hloop_Q_A(ntryL,G0H16(1),16,nMB,G1H16(60),n2h16(104))
Gcoeff(:)%j = (c(26)*M(2,:)%j-c(27)*M(4,:)%j+c(30)*M(8,:)%j) * den(2)
call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(145),h0tab(:,145),[16,2,1,12],[nMT,0,nMT,nMT],4,1,wf4(:,2))
  call Hloop_QV_A(ntryL,G0H32(1),ex5(:),G0H16(1),m3h2x16(:,145),heltab2x32(:,:,145))
  call Hloop_Q_A(ntryL,G0H16(1),16,nMT,G1H16(61),n2h16(105))
Gcoeff(:)%j = (c(35)*M(4,:)%j+c(30)*(-M(2,:)%j+M(8,:)%j)) * den(2)
call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(146),h0tab(:,146),[16,2,1,12],[0,nMT,0,0],4,1,wf4(:,2))
  call Hloop_UV_W(ntryL,G0H32(1),0,ex5(:),16,G1H16(62),m3h2x16(:,146),heltab2x32(:,:,146))
Gcoeff(:)%j = (c(51)*M(1,:)%j) * den(22)
call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(147),h0tab(:,147),[16,1,12,2],[0,nMT,nMT,0],4,1,wf4(:,18))
  call Hloop_UV_W(ntryL,G0H32(1),0,ex5(:),16,G1H16(67),m3h2x16(:,147),heltab2x32(:,:,147))
Gcoeff(:)%j = (c(51)*M(1,:)%j) * den(24)
call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(148),h0tab(:,148),[16,1,12,2],[0,nMT,nMT,0],4,1,wf4(:,19))
  call Hloop_UV_W(ntryL,G0H32(1),0,ex5(:),16,G1H16(65),m3h2x16(:,148),heltab2x32(:,:,148))
Gcoeff(:)%j = (-(c(20)*M(8,:)%j)) * den(2)
call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(149),h0tab(:,149),[16,1,12,2],[nMT,0,0,nMT],4,1,wf4(:,2))
  call Hloop_AV_Q(ntryL,G0H32(1),ex5(:),G0H16(1),m3h2x16(:,149),heltab2x32(:,:,149))
  call Hloop_A_Q(ntryL,G0H16(1),16,nMT,G1H16(66),n2h16(106))
Gcoeff(:)%j = (c(3)*M(1,:)%j) * den(2)
call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(150),h0tab(:,150),[16,1,12,2],[0,nMT,nMT,0],4,1,wf4(:,2))
  call Hloop_UV_W(ntryL,G0H32(1),0,ex5(:),16,G1H16(68),m3h2x16(:,150),heltab2x32(:,:,150))
Gcoeff(:)%j = (-(c(6)*M(1,:)%j)) * den(24)
call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(151),h0tab(:,151),[16,1,12,2],[0,nMT,nMT,0],4,1,wf4(:,20))
  call Hloop_UV_W(ntryL,G0H32(1),0,ex5(:),16,G1H16(69),m3h2x16(:,151),heltab2x32(:,:,151))
Gcoeff(:)%j = (c(20)*M(8,:)%j) * den(2)
call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(152),h0tab(:,152),[16,1,12,2],[0,nMT,nMT,0],4,1,wf4(:,2))
  call Hloop_UV_W(ntryL,G0H32(1),0,ex5(:),16,G1H16(70),m3h2x16(:,152),heltab2x32(:,:,152))
Gcoeff(:)%j = (-(c(45)*M(1,:)%j)+c(44)*M(5,:)%j) * den(14)
call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(153),h0tab(:,153),[17,4,2,8],[0,nMB,nMW,nMT],4,1,wf4(:,12))
  call Hloop_AQ_V(ntryL,G0H32(1),wf4(:,12),G0H8(1),m3h4x8(:,1),heltab2x32(:,:,153))
Gcoeff(:)%j = (-(c(45)*M(1,:)%j)+c(44)*M(5,:)%j) * den(14)
call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(154),h0tab(:,154),[17,4,2,8],[nMW,nMT,0,nMB],4,1,wf4(:,12))
  call Hloop_AQ_S(ntryL,G0H32(1),wf4(:,12),G0H8(2),ngPbt,m3h4x8(:,2),heltab2x32(:,:,154))
Gcoeff(:)%j = (-(c(40)*M(1,:)%j)+c(39)*M(5,:)%j) * den(14)
call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(155),h0tab(:,155),[17,4,2,8],[nMW,nMT,0,nMB],4,1,wf4(:,12))
  call Hloop_AQ_W(ntryL,G0H32(1),wf4(:,12),G0H8(3),m3h4x8(:,3),heltab2x32(:,:,155))
Gcoeff(:)%j = (-(c(40)*M(1,:)%j)+c(39)*M(5,:)%j) * den(14)
call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(156),h0tab(:,156),[17,4,2,8],[0,nMB,nMW,nMT],4,1,wf4(:,12))
  call Hloop_AQ_V(ntryL,G0H32(1),wf4(:,12),G0H8(4),m3h4x8(:,4),heltab2x32(:,:,156))
Gcoeff(:)%j = (-(c(45)*M(1,:)%j)+c(44)*M(5,:)%j) * den(14)
call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(157),h0tab(:,157),[17,2,4,8],[nMW,nMB,0,nMB],4,1,wf4(:,12))
  call Hloop_AQ_S(ntryL,G0H32(1),wf4(:,12),G0H8(5),ngPbt,m3h4x8(:,5),heltab2x32(:,:,157))
Gcoeff(:)%j = (-(c(45)*M(1,:)%j)+c(44)*M(5,:)%j) * den(14)
call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(158),h0tab(:,158),[17,2,4,8],[0,nMT,nMW,nMT],4,1,wf4(:,12))
  call Hloop_AQ_V(ntryL,G0H32(1),wf4(:,12),G0H8(6),m3h4x8(:,6),heltab2x32(:,:,158))
Gcoeff(:)%j = (c(52)*M(1,:)%j-c(53)*M(5,:)%j) * den(14)
call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(159),h0tab(:,159),[17,2,4,8],[nMT,nMH,nMB,0],4,1,wf4(:,12))
  call Hloop_VQ_A(ntryL,G0H32(1),wf4(:,12),G0H8(7),m3h4x8(:,7),heltab2x32(:,:,159))
  call Hloop_Q_A(ntryL,G0H8(7),17,nMT,G1H8(45),n2h8(25))
Gcoeff(:)%j = (c(52)*M(1,:)%j-c(53)*M(5,:)%j) * den(14)
call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(160),h0tab(:,160),[17,2,4,8],[nMT,nMZ,nMB,0],4,1,wf4(:,12))
  call Hloop_VQ_A(ntryL,G0H32(1),wf4(:,12),G0H8(7),m3h4x8(:,8),heltab2x32(:,:,160))
  call Hloop_Q_A(ntryL,G0H8(7),17,nMT,G1H8(1),n2h8(26))
Gcoeff(:)%j = (c(52)*M(1,:)%j-c(53)*M(5,:)%j) * den(14)
call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(161),h0tab(:,161),[17,2,4,8],[nMT,0,nMB,nMH],4,1,wf4(:,12))
  call Hloop_SQ_A(ntryL,G0H32(1),wf4(:,12),G0H8(7),ngH,m3h4x8(:,9),heltab2x32(:,:,161))
  call Hloop_Q_A(ntryL,G0H8(7),17,nMT,G1H8(2),n2h8(27))
Gcoeff(:)%j = (c(52)*M(1,:)%j-c(53)*M(5,:)%j) * den(14)
call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(162),h0tab(:,162),[17,2,4,8],[nMT,0,nMB,nMZ],4,1,wf4(:,12))
  call Hloop_SQ_A(ntryL,G0H32(1),wf4(:,12),G0H8(7),ngX,m3h4x8(:,10),heltab2x32(:,:,162))
  call Hloop_Q_A(ntryL,G0H8(7),17,nMT,G1H8(3),n2h8(28))
Gcoeff(:)%j = (-(c(40)*M(1,:)%j)+c(39)*M(5,:)%j) * den(14)
call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(163),h0tab(:,163),[17,2,4,8],[0,nMT,nMW,nMT],4,1,wf4(:,12))
  call Hloop_AQ_V(ntryL,G0H32(1),wf4(:,12),G0H8(7),m3h4x8(:,11),heltab2x32(:,:,163))
Gcoeff(:)%j = (-(c(40)*M(1,:)%j)+c(39)*M(5,:)%j) * den(14)
call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(164),h0tab(:,164),[17,2,4,8],[nMW,nMB,0,nMB],4,1,wf4(:,12))
  call Hloop_AQ_W(ntryL,G0H32(1),wf4(:,12),G0H8(8),m3h4x8(:,12),heltab2x32(:,:,164))
Gcoeff(:)%j = (c(9)*M(1,:)%j-c(10)*M(5,:)%j) * den(14)
call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(165),h0tab(:,165),[17,2,4,8],[nMT,0,nMB,0],4,1,wf4(:,12))
  call Hloop_VQ_A(ntryL,G0H32(1),wf4(:,12),G0H8(9),m3h4x8(:,13),heltab2x32(:,:,165))
  call Hloop_Q_A(ntryL,G0H8(9),17,nMT,G1H8(4),n2h8(29))
Gcoeff(:)%j = (c(9)*M(1,:)%j-c(10)*M(5,:)%j) * den(14)
call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(166),h0tab(:,166),[17,2,4,8],[nMT,0,nMB,0],4,1,wf4(:,12))
  call Hloop_VQ_A(ntryL,G0H32(1),wf4(:,12),G0H8(9),m3h4x8(:,14),heltab2x32(:,:,166))
  call Hloop_Q_A(ntryL,G0H8(9),17,nMT,G1H8(5),n2h8(30))
Gcoeff(:)%j = (-(c(14)*M(1,:)%j)+c(15)*M(5,:)%j) * den(14)
call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(167),h0tab(:,167),[17,2,4,8],[nMT,nMZ,nMB,0],4,1,wf4(:,12))
  call Hloop_VQ_A(ntryL,G0H32(1),wf4(:,12),G0H8(9),m3h4x8(:,15),heltab2x32(:,:,167))
  call Hloop_Q_A(ntryL,G0H8(9),17,nMT,G1H8(6),n2h8(31))
Gcoeff(:)%j = (-(c(14)*M(1,:)%j)+c(15)*M(5,:)%j) * den(14)
call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(168),h0tab(:,168),[17,2,4,8],[nMT,0,nMB,nMZ],4,1,wf4(:,12))
  call Hloop_ZQ_A(ntryL,G0H32(1),wf4(:,12),G0H8(9),ngZu,m3h4x8(:,16),heltab2x32(:,:,168))
  call Hloop_Q_A(ntryL,G0H8(9),17,nMT,G1H8(7),n2h8(32))
Gcoeff(:)%j = (c(26)*M(2,:)%j+c(33)*M(6,:)%j) * den(14)
call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(169),h0tab(:,169),[17,2,4,8],[nMT,0,nMB,0],4,1,wf4(:,12))
  call Hloop_VQ_A(ntryL,G0H32(1),wf4(:,12),G0H8(9),m3h4x8(:,17),heltab2x32(:,:,169))
  call Hloop_Q_A(ntryL,G0H8(9),17,nMT,G1H8(8),n2h8(33))
Gcoeff(:)%j = (c(52)*M(1,:)%j-c(53)*M(5,:)%j) * den(14)
call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(170),h0tab(:,170),[17,2,8,4],[nMT,nMH,nMB,0],4,1,wf4(:,12))
  call Hloop_VQ_A(ntryL,G0H32(1),wf4(:,12),G0H8(9),m3h4x8(:,18),heltab2x32(:,:,170))
  call Hloop_Q_A(ntryL,G0H8(9),17,nMT,G1H8(9),n2h8(34))
Gcoeff(:)%j = (c(52)*M(1,:)%j-c(53)*M(5,:)%j) * den(14)
call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(171),h0tab(:,171),[17,2,8,4],[nMT,nMZ,nMB,0],4,1,wf4(:,12))
  call Hloop_VQ_A(ntryL,G0H32(1),wf4(:,12),G0H8(9),m3h4x8(:,19),heltab2x32(:,:,171))
  call Hloop_Q_A(ntryL,G0H8(9),17,nMT,G1H8(10),n2h8(35))
Gcoeff(:)%j = (c(52)*M(1,:)%j-c(53)*M(5,:)%j) * den(14)
call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(172),h0tab(:,172),[17,2,8,4],[nMT,0,nMB,nMH],4,1,wf4(:,12))
  call Hloop_SQ_A(ntryL,G0H32(1),wf4(:,12),G0H8(9),ngH,m3h4x8(:,20),heltab2x32(:,:,172))
  call Hloop_Q_A(ntryL,G0H8(9),17,nMT,G1H8(11),n2h8(36))
Gcoeff(:)%j = (c(52)*M(1,:)%j-c(53)*M(5,:)%j) * den(14)
call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(173),h0tab(:,173),[17,2,8,4],[nMT,0,nMB,nMZ],4,1,wf4(:,12))
  call Hloop_SQ_A(ntryL,G0H32(1),wf4(:,12),G0H8(9),ngX,m3h4x8(:,21),heltab2x32(:,:,173))
  call Hloop_Q_A(ntryL,G0H8(9),17,nMT,G1H8(12),n2h8(37))
Gcoeff(:)%j = (c(9)*M(1,:)%j-c(10)*M(5,:)%j) * den(14)
call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(174),h0tab(:,174),[17,2,8,4],[nMT,0,nMB,0],4,1,wf4(:,12))
  call Hloop_VQ_A(ntryL,G0H32(1),wf4(:,12),G0H8(9),m3h4x8(:,22),heltab2x32(:,:,174))
  call Hloop_Q_A(ntryL,G0H8(9),17,nMT,G1H8(13),n2h8(38))
Gcoeff(:)%j = (c(9)*M(1,:)%j-c(10)*M(5,:)%j) * den(14)
call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(175),h0tab(:,175),[17,2,8,4],[nMT,0,nMB,0],4,1,wf4(:,12))
  call Hloop_VQ_A(ntryL,G0H32(1),wf4(:,12),G0H8(9),m3h4x8(:,23),heltab2x32(:,:,175))
  call Hloop_Q_A(ntryL,G0H8(9),17,nMT,G1H8(14),n2h8(39))
Gcoeff(:)%j = (-(c(14)*M(1,:)%j)+c(15)*M(5,:)%j) * den(14)
call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(176),h0tab(:,176),[17,2,8,4],[nMT,nMZ,nMB,0],4,1,wf4(:,12))
  call Hloop_VQ_A(ntryL,G0H32(1),wf4(:,12),G0H8(9),m3h4x8(:,24),heltab2x32(:,:,176))
  call Hloop_Q_A(ntryL,G0H8(9),17,nMT,G1H8(15),n2h8(40))
Gcoeff(:)%j = (-(c(14)*M(1,:)%j)+c(15)*M(5,:)%j) * den(14)
call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(177),h0tab(:,177),[17,2,8,4],[nMT,0,nMB,nMZ],4,1,wf4(:,12))
  call Hloop_ZQ_A(ntryL,G0H32(1),wf4(:,12),G0H8(9),ngZu,m3h4x8(:,25),heltab2x32(:,:,177))
  call Hloop_Q_A(ntryL,G0H8(9),17,nMT,G1H8(16),n2h8(41))
Gcoeff(:)%j = (c(31)*M(2,:)%j-c(28)*M(6,:)%j) * den(14)
call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(178),h0tab(:,178),[17,2,8,4],[nMT,0,nMB,0],4,1,wf4(:,12))
  call Hloop_VQ_A(ntryL,G0H32(1),wf4(:,12),G0H8(9),m3h4x8(:,26),heltab2x32(:,:,178))
  call Hloop_Q_A(ntryL,G0H8(9),17,nMT,G1H8(17),n2h8(42))
Gcoeff(:)%j = (-(c(45)*M(1,:)%j)+c(44)*M(3,:)%j) * den(19)
call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(179),h0tab(:,179),[18,4,1,8],[nMT,nMW,nMB,0],4,1,wf4(:,16))
  call Hloop_VA_Q(ntryL,G0H32(1),wf4(:,16),G0H8(9),m3h4x8(:,27),heltab2x32(:,:,179))
  call Hloop_A_Q(ntryL,G0H8(9),18,nMT,G1H8(18),n2h8(43))
Gcoeff(:)%j = (-(c(45)*M(1,:)%j)+c(44)*M(3,:)%j) * den(19)
call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(180),h0tab(:,180),[18,4,1,8],[nMB,0,nMT,nMW],4,1,wf4(:,16))
  call Hloop_SA_Q(ntryL,G0H32(1),wf4(:,16),G0H8(9),ngPtb,m3h4x8(:,28),heltab2x32(:,:,180))
  call Hloop_A_Q(ntryL,G0H8(9),18,nMB,G1H8(19),n2h8(44))
Gcoeff(:)%j = (-(c(40)*M(1,:)%j)+c(39)*M(3,:)%j) * den(19)
call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(181),h0tab(:,181),[18,4,1,8],[nMT,nMW,nMB,0],4,1,wf4(:,16))
  call Hloop_VA_Q(ntryL,G0H32(1),wf4(:,16),G0H8(9),m3h4x8(:,29),heltab2x32(:,:,181))
  call Hloop_A_Q(ntryL,G0H8(9),18,nMT,G1H8(20),n2h8(45))
Gcoeff(:)%j = (-(c(40)*M(1,:)%j)+c(39)*M(3,:)%j) * den(19)
call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(182),h0tab(:,182),[18,4,1,8],[nMB,0,nMT,nMW],4,1,wf4(:,16))
  call Hloop_WA_Q(ntryL,G0H32(1),wf4(:,16),G0H8(9),m3h4x8(:,30),heltab2x32(:,:,182))
  call Hloop_A_Q(ntryL,G0H8(9),18,nMB,G1H8(21),n2h8(46))
Gcoeff(:)%j = (c(52)*M(1,:)%j-c(53)*M(3,:)%j) * den(19)
call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(183),h0tab(:,183),[18,1,4,8],[nMT,nMH,nMB,0],4,1,wf4(:,16))
  call Hloop_VA_Q(ntryL,G0H32(1),wf4(:,16),G0H8(9),m3h4x8(:,31),heltab2x32(:,:,183))
  call Hloop_A_Q(ntryL,G0H8(9),18,nMT,G1H8(22),n2h8(47))
Gcoeff(:)%j = (c(52)*M(1,:)%j-c(53)*M(3,:)%j) * den(19)
call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(184),h0tab(:,184),[18,1,4,8],[nMT,nMZ,nMB,0],4,1,wf4(:,16))
  call Hloop_VA_Q(ntryL,G0H32(1),wf4(:,16),G0H8(9),m3h4x8(:,32),heltab2x32(:,:,184))
  call Hloop_A_Q(ntryL,G0H8(9),18,nMT,G1H8(23),n2h8(48))
Gcoeff(:)%j = (c(52)*M(1,:)%j-c(53)*M(3,:)%j) * den(19)
call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(185),h0tab(:,185),[18,1,4,8],[nMT,0,nMB,nMH],4,1,wf4(:,16))
  call Hloop_SA_Q(ntryL,G0H32(1),wf4(:,16),G0H8(9),ngH,m3h4x8(:,33),heltab2x32(:,:,185))
  call Hloop_A_Q(ntryL,G0H8(9),18,nMT,G1H8(24),n2h8(49))
Gcoeff(:)%j = (c(52)*M(1,:)%j-c(53)*M(3,:)%j) * den(19)
call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(186),h0tab(:,186),[18,1,4,8],[nMT,0,nMB,nMZ],4,1,wf4(:,16))
  call Hloop_SA_Q(ntryL,G0H32(1),wf4(:,16),G0H8(9),ngX,m3h4x8(:,34),heltab2x32(:,:,186))
  call Hloop_A_Q(ntryL,G0H8(9),18,nMT,G1H8(25),n2h8(50))
Gcoeff(:)%j = (c(9)*M(1,:)%j-c(10)*M(3,:)%j) * den(19)
call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(187),h0tab(:,187),[18,1,4,8],[nMT,0,nMB,0],4,1,wf4(:,16))
  call Hloop_VA_Q(ntryL,G0H32(1),wf4(:,16),G0H8(9),m3h4x8(:,35),heltab2x32(:,:,187))
  call Hloop_A_Q(ntryL,G0H8(9),18,nMT,G1H8(26),n2h8(51))
Gcoeff(:)%j = (c(9)*M(1,:)%j-c(10)*M(3,:)%j) * den(19)
call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(188),h0tab(:,188),[18,1,4,8],[nMT,0,nMB,0],4,1,wf4(:,16))
  call Hloop_VA_Q(ntryL,G0H32(1),wf4(:,16),G0H8(9),m3h4x8(:,36),heltab2x32(:,:,188))
  call Hloop_A_Q(ntryL,G0H8(9),18,nMT,G1H8(27),n2h8(52))
Gcoeff(:)%j = (-(c(14)*M(1,:)%j)+c(15)*M(3,:)%j) * den(19)
call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(189),h0tab(:,189),[18,1,4,8],[nMT,nMZ,nMB,0],4,1,wf4(:,16))
  call Hloop_VA_Q(ntryL,G0H32(1),wf4(:,16),G0H8(9),m3h4x8(:,37),heltab2x32(:,:,189))
  call Hloop_A_Q(ntryL,G0H8(9),18,nMT,G1H8(28),n2h8(53))
Gcoeff(:)%j = (-(c(14)*M(1,:)%j)+c(15)*M(3,:)%j) * den(19)
call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(190),h0tab(:,190),[18,1,4,8],[nMT,0,nMB,nMZ],4,1,wf4(:,16))
  call Hloop_ZA_Q(ntryL,G0H32(1),wf4(:,16),G0H8(9),ngZu,m3h4x8(:,38),heltab2x32(:,:,190))
  call Hloop_A_Q(ntryL,G0H8(9),18,nMT,G1H8(29),n2h8(54))
Gcoeff(:)%j = (c(31)*M(2,:)%j-c(28)*M(4,:)%j) * den(19)
call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(191),h0tab(:,191),[18,1,4,8],[nMT,0,nMB,0],4,1,wf4(:,16))
  call Hloop_VA_Q(ntryL,G0H32(1),wf4(:,16),G0H8(9),m3h4x8(:,39),heltab2x32(:,:,191))
  call Hloop_A_Q(ntryL,G0H8(9),18,nMT,G1H8(30),n2h8(55))
Gcoeff(:)%j = (-(c(45)*M(1,:)%j)+c(44)*M(3,:)%j) * den(19)
call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(192),h0tab(:,192),[18,1,8,4],[nMW,nMB,0,nMB],4,1,wf4(:,16))
  call Hloop_QA_S(ntryL,G0H32(1),wf4(:,16),G0H8(9),ngPtb,m3h4x8(:,40),heltab2x32(:,:,192))
Gcoeff(:)%j = (-(c(45)*M(1,:)%j)+c(44)*M(3,:)%j) * den(19)
call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(193),h0tab(:,193),[18,1,8,4],[0,nMT,nMW,nMT],4,1,wf4(:,16))
  call Hloop_QA_V(ntryL,G0H32(1),wf4(:,16),G0H8(10),m3h4x8(:,41),heltab2x32(:,:,193))
Gcoeff(:)%j = (c(52)*M(1,:)%j-c(53)*M(3,:)%j) * den(19)
call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(194),h0tab(:,194),[18,1,8,4],[nMT,nMH,nMB,0],4,1,wf4(:,16))
  call Hloop_VA_Q(ntryL,G0H32(1),wf4(:,16),G0H8(11),m3h4x8(:,42),heltab2x32(:,:,194))
  call Hloop_A_Q(ntryL,G0H8(11),18,nMT,G1H8(31),n2h8(56))
Gcoeff(:)%j = (c(52)*M(1,:)%j-c(53)*M(3,:)%j) * den(19)
call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(195),h0tab(:,195),[18,1,8,4],[nMT,nMZ,nMB,0],4,1,wf4(:,16))
  call Hloop_VA_Q(ntryL,G0H32(1),wf4(:,16),G0H8(11),m3h4x8(:,43),heltab2x32(:,:,195))
  call Hloop_A_Q(ntryL,G0H8(11),18,nMT,G1H8(32),n2h8(57))
Gcoeff(:)%j = (c(52)*M(1,:)%j-c(53)*M(3,:)%j) * den(19)
call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(196),h0tab(:,196),[18,1,8,4],[nMT,0,nMB,nMH],4,1,wf4(:,16))
  call Hloop_SA_Q(ntryL,G0H32(1),wf4(:,16),G0H8(11),ngH,m3h4x8(:,44),heltab2x32(:,:,196))
  call Hloop_A_Q(ntryL,G0H8(11),18,nMT,G1H8(33),n2h8(58))
Gcoeff(:)%j = (c(52)*M(1,:)%j-c(53)*M(3,:)%j) * den(19)
call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(197),h0tab(:,197),[18,1,8,4],[nMT,0,nMB,nMZ],4,1,wf4(:,16))
  call Hloop_SA_Q(ntryL,G0H32(1),wf4(:,16),G0H8(11),ngX,m3h4x8(:,45),heltab2x32(:,:,197))
  call Hloop_A_Q(ntryL,G0H8(11),18,nMT,G1H8(34),n2h8(59))
Gcoeff(:)%j = (-(c(40)*M(1,:)%j)+c(39)*M(3,:)%j) * den(19)
call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(198),h0tab(:,198),[18,1,8,4],[0,nMT,nMW,nMT],4,1,wf4(:,16))
  call Hloop_QA_V(ntryL,G0H32(1),wf4(:,16),G0H8(11),m3h4x8(:,46),heltab2x32(:,:,198))
Gcoeff(:)%j = (-(c(40)*M(1,:)%j)+c(39)*M(3,:)%j) * den(19)
call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(199),h0tab(:,199),[18,1,8,4],[nMW,nMB,0,nMB],4,1,wf4(:,16))
  call Hloop_QA_W(ntryL,G0H32(1),wf4(:,16),G0H8(12),m3h4x8(:,47),heltab2x32(:,:,199))
Gcoeff(:)%j = (c(9)*M(1,:)%j-c(10)*M(3,:)%j) * den(19)
call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(200),h0tab(:,200),[18,1,8,4],[nMT,0,nMB,0],4,1,wf4(:,16))
  call Hloop_VA_Q(ntryL,G0H32(1),wf4(:,16),G0H8(13),m3h4x8(:,48),heltab2x32(:,:,200))
  call Hloop_A_Q(ntryL,G0H8(13),18,nMT,G1H8(35),n2h8(60))
Gcoeff(:)%j = (c(9)*M(1,:)%j-c(10)*M(3,:)%j) * den(19)
call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(201),h0tab(:,201),[18,1,8,4],[nMT,0,nMB,0],4,1,wf4(:,16))
  call Hloop_VA_Q(ntryL,G0H32(1),wf4(:,16),G0H8(13),m3h4x8(:,49),heltab2x32(:,:,201))
  call Hloop_A_Q(ntryL,G0H8(13),18,nMT,G1H8(36),n2h8(61))
Gcoeff(:)%j = (-(c(14)*M(1,:)%j)+c(15)*M(3,:)%j) * den(19)
call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(202),h0tab(:,202),[18,1,8,4],[nMT,nMZ,nMB,0],4,1,wf4(:,16))
  call Hloop_VA_Q(ntryL,G0H32(1),wf4(:,16),G0H8(13),m3h4x8(:,50),heltab2x32(:,:,202))
  call Hloop_A_Q(ntryL,G0H8(13),18,nMT,G1H8(37),n2h8(62))
Gcoeff(:)%j = (-(c(14)*M(1,:)%j)+c(15)*M(3,:)%j) * den(19)
call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(203),h0tab(:,203),[18,1,8,4],[nMT,0,nMB,nMZ],4,1,wf4(:,16))
  call Hloop_ZA_Q(ntryL,G0H32(1),wf4(:,16),G0H8(13),ngZu,m3h4x8(:,51),heltab2x32(:,:,203))
  call Hloop_A_Q(ntryL,G0H8(13),18,nMT,G1H8(38),n2h8(63))
Gcoeff(:)%j = (c(26)*M(2,:)%j+c(33)*M(4,:)%j) * den(19)
call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(204),h0tab(:,204),[18,1,8,4],[nMT,0,nMB,0],4,1,wf4(:,16))
  call Hloop_VA_Q(ntryL,G0H32(1),wf4(:,16),G0H8(13),m3h4x8(:,52),heltab2x32(:,:,204))
  call Hloop_A_Q(ntryL,G0H8(13),18,nMT,G1H8(39),n2h8(64))
Gcoeff(:)%j = (-(c(53)*M(3,:)%j)+c(52)*M(7,:)%j) * den(5)
call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(205),h0tab(:,205),[20,2,1,8],[0,nMT,nMH,nMB],4,1,wf4(:,5))
  call Hloop_AQ_V(ntryL,G0H32(1),wf4(:,5),G0H8(13),m3h4x8(:,53),heltab2x32(:,:,205))
Gcoeff(:)%j = (-(c(53)*M(3,:)%j)+c(52)*M(7,:)%j) * den(5)
call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(206),h0tab(:,206),[20,2,1,8],[0,nMT,nMZ,nMB],4,1,wf4(:,5))
  call Hloop_AQ_V(ntryL,G0H32(1),wf4(:,5),G0H8(14),m3h4x8(:,54),heltab2x32(:,:,206))
Gcoeff(:)%j = (-(c(53)*M(3,:)%j)+c(52)*M(7,:)%j) * den(5)
call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(207),h0tab(:,207),[20,2,1,8],[nMH,nMT,0,nMB],4,1,wf4(:,5))
  call Hloop_AQ_S(ntryL,G0H32(1),wf4(:,5),G0H8(15),ngH,m3h4x8(:,55),heltab2x32(:,:,207))
Gcoeff(:)%j = (-(c(53)*M(3,:)%j)+c(52)*M(7,:)%j) * den(5)
call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(208),h0tab(:,208),[20,2,1,8],[nMZ,nMT,0,nMB],4,1,wf4(:,5))
  call Hloop_AQ_S(ntryL,G0H32(1),wf4(:,5),G0H8(16),ngX,m3h4x8(:,56),heltab2x32(:,:,208))
Gcoeff(:)%j = (c(44)*M(3,:)%j-c(45)*M(7,:)%j) * den(5)
call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(209),h0tab(:,209),[20,2,1,8],[nMB,nMW,nMB,0],4,1,wf4(:,5))
  call Hloop_VQ_A(ntryL,G0H32(1),wf4(:,5),G0H8(17),m3h4x8(:,57),heltab2x32(:,:,209))
  call Hloop_Q_A(ntryL,G0H8(17),20,nMB,G1H8(40),n2h8(65))
Gcoeff(:)%j = (c(44)*M(3,:)%j-c(45)*M(7,:)%j) * den(5)
call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(210),h0tab(:,210),[20,2,1,8],[nMT,0,nMT,nMW],4,1,wf4(:,5))
  call Hloop_SQ_A(ntryL,G0H32(1),wf4(:,5),G0H8(17),ngPtb,m3h4x8(:,58),heltab2x32(:,:,210))
  call Hloop_Q_A(ntryL,G0H8(17),20,nMT,G1H8(41),n2h8(66))
Gcoeff(:)%j = (-(c(10)*M(3,:)%j)+c(9)*M(7,:)%j) * den(5)
call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(211),h0tab(:,211),[20,2,1,8],[0,nMT,0,nMB],4,1,wf4(:,5))
  call Hloop_AQ_V(ntryL,G0H32(1),wf4(:,5),G0H8(17),m3h4x8(:,59),heltab2x32(:,:,211))
Gcoeff(:)%j = (-(c(10)*M(3,:)%j)+c(9)*M(7,:)%j) * den(5)
call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(212),h0tab(:,212),[20,2,1,8],[0,nMT,0,nMB],4,1,wf4(:,5))
  call Hloop_AQ_V(ntryL,G0H32(1),wf4(:,5),G0H8(18),m3h4x8(:,60),heltab2x32(:,:,212))
Gcoeff(:)%j = (c(15)*M(3,:)%j-c(14)*M(7,:)%j) * den(5)
call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(213),h0tab(:,213),[20,2,1,8],[0,nMT,nMZ,nMB],4,1,wf4(:,5))
  call Hloop_AQ_V(ntryL,G0H32(1),wf4(:,5),G0H8(19),m3h4x8(:,61),heltab2x32(:,:,213))
Gcoeff(:)%j = (c(15)*M(3,:)%j-c(14)*M(7,:)%j) * den(5)
call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(214),h0tab(:,214),[20,2,1,8],[nMZ,nMT,0,nMB],4,1,wf4(:,5))
  call Hloop_AQ_Z(ntryL,G0H32(1),wf4(:,5),G0H8(20),ngZd,m3h4x8(:,62),heltab2x32(:,:,214))
Gcoeff(:)%j = (c(33)*M(4,:)%j+c(26)*M(8,:)%j) * den(5)
call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(215),h0tab(:,215),[20,2,1,8],[0,nMT,0,nMB],4,1,wf4(:,5))
  call Hloop_AQ_V(ntryL,G0H32(1),wf4(:,5),G0H8(21),m3h4x8(:,63),heltab2x32(:,:,215))
Gcoeff(:)%j = (c(39)*M(3,:)%j-c(40)*M(7,:)%j) * den(5)
call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(216),h0tab(:,216),[20,2,1,8],[nMT,0,nMT,nMW],4,1,wf4(:,5))
  call Hloop_WQ_A(ntryL,G0H32(1),wf4(:,5),G0H8(22),m3h4x8(:,64),heltab2x32(:,:,216))
  call Hloop_Q_A(ntryL,G0H8(22),20,nMT,G1H8(42),n2h8(67))
Gcoeff(:)%j = (c(39)*M(3,:)%j-c(40)*M(7,:)%j) * den(5)
call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(217),h0tab(:,217),[20,2,1,8],[nMB,nMW,nMB,0],4,1,wf4(:,5))
  call Hloop_VQ_A(ntryL,G0H32(1),wf4(:,5),G0H8(22),m3h4x8(:,65),heltab2x32(:,:,217))
  call Hloop_Q_A(ntryL,G0H8(22),20,nMB,G1H8(43),n2h8(68))
Gcoeff(:)%j = (-(c(53)*M(3,:)%j)+c(52)*M(7,:)%j) * den(5)
call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(218),h0tab(:,218),[20,1,2,8],[nMH,nMT,0,nMB],4,1,wf4(:,5))
  call Hloop_AQ_S(ntryL,G0H32(1),wf4(:,5),G0H8(22),ngH,m3h4x8(:,66),heltab2x32(:,:,218))
Gcoeff(:)%j = (-(c(53)*M(3,:)%j)+c(52)*M(7,:)%j) * den(5)
call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(219),h0tab(:,219),[20,1,2,8],[nMZ,nMT,0,nMB],4,1,wf4(:,5))
  call Hloop_AQ_S(ntryL,G0H32(1),wf4(:,5),G0H8(23),ngX,m3h4x8(:,67),heltab2x32(:,:,219))
Gcoeff(:)%j = (-(c(53)*M(3,:)%j)+c(52)*M(7,:)%j) * den(5)
call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(220),h0tab(:,220),[20,1,2,8],[0,nMT,nMH,nMB],4,1,wf4(:,5))
  call Hloop_AQ_V(ntryL,G0H32(1),wf4(:,5),G0H8(24),m3h4x8(:,68),heltab2x32(:,:,220))
Gcoeff(:)%j = (-(c(53)*M(3,:)%j)+c(52)*M(7,:)%j) * den(5)
call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(221),h0tab(:,221),[20,1,2,8],[0,nMT,nMZ,nMB],4,1,wf4(:,5))
  call Hloop_AQ_V(ntryL,G0H32(1),wf4(:,5),G0H8(25),m3h4x8(:,69),heltab2x32(:,:,221))
Gcoeff(:)%j = (-(c(10)*M(3,:)%j)+c(9)*M(7,:)%j) * den(5)
call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(222),h0tab(:,222),[20,1,2,8],[0,nMT,0,nMB],4,1,wf4(:,5))
  call Hloop_AQ_V(ntryL,G0H32(1),wf4(:,5),G0H8(26),m3h4x8(:,70),heltab2x32(:,:,222))
Gcoeff(:)%j = (-(c(10)*M(3,:)%j)+c(9)*M(7,:)%j) * den(5)
call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(223),h0tab(:,223),[20,1,2,8],[0,nMT,0,nMB],4,1,wf4(:,5))
  call Hloop_AQ_V(ntryL,G0H32(1),wf4(:,5),G0H8(27),m3h4x8(:,71),heltab2x32(:,:,223))
Gcoeff(:)%j = (c(15)*M(3,:)%j-c(14)*M(7,:)%j) * den(5)
call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(224),h0tab(:,224),[20,1,2,8],[nMZ,nMT,0,nMB],4,1,wf4(:,5))
  call Hloop_AQ_Z(ntryL,G0H32(1),wf4(:,5),G0H8(28),ngZd,m3h4x8(:,72),heltab2x32(:,:,224))
Gcoeff(:)%j = (c(15)*M(3,:)%j-c(14)*M(7,:)%j) * den(5)
call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(225),h0tab(:,225),[20,1,2,8],[0,nMT,nMZ,nMB],4,1,wf4(:,5))
  call Hloop_AQ_V(ntryL,G0H32(1),wf4(:,5),G0H8(29),m3h4x8(:,73),heltab2x32(:,:,225))
Gcoeff(:)%j = (-(c(28)*M(4,:)%j)+c(31)*M(8,:)%j) * den(5)
call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(226),h0tab(:,226),[20,1,2,8],[0,nMT,0,nMB],4,1,wf4(:,5))
  call Hloop_AQ_V(ntryL,G0H32(1),wf4(:,5),G0H8(30),m3h4x8(:,74),heltab2x32(:,:,226))
Gcoeff(:)%j = (c(44)*M(3,:)%j-c(45)*M(7,:)%j) * den(5)
call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(227),h0tab(:,227),[20,1,8,2],[nMW,nMB,0,nMT],4,1,wf4(:,5))
  call Hloop_AQ_S(ntryL,G0H32(1),wf4(:,5),G0H8(31),ngPtb,m3h4x8(:,75),heltab2x32(:,:,227))
Gcoeff(:)%j = (c(44)*M(3,:)%j-c(45)*M(7,:)%j) * den(5)
call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(228),h0tab(:,228),[20,1,8,2],[0,nMT,nMW,nMB],4,1,wf4(:,5))
  call Hloop_AQ_V(ntryL,G0H32(1),wf4(:,5),G0H8(32),m3h4x8(:,76),heltab2x32(:,:,228))
Gcoeff(:)%j = (c(39)*M(3,:)%j-c(40)*M(7,:)%j) * den(5)
call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(229),h0tab(:,229),[20,1,8,2],[0,nMT,nMW,nMB],4,1,wf4(:,5))
  call Hloop_AQ_V(ntryL,G0H32(1),wf4(:,5),G0H8(33),m3h4x8(:,77),heltab2x32(:,:,229))
Gcoeff(:)%j = (c(39)*M(3,:)%j-c(40)*M(7,:)%j) * den(5)
call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(230),h0tab(:,230),[20,1,8,2],[nMW,nMB,0,nMT],4,1,wf4(:,5))
  call Hloop_AQ_W(ntryL,G0H32(1),wf4(:,5),G0H8(34),m3h4x8(:,78),heltab2x32(:,:,230))
Gcoeff(:)%j = (-(c(53)*M(5,:)%j)+c(52)*M(7,:)%j) * den(10)
call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(231),h0tab(:,231),[24,2,1,4],[0,nMT,nMH,nMB],4,1,wf4(:,9))
  call Hloop_QA_V(ntryL,G0H32(1),wf4(:,9),G0H8(35),m3h4x8(:,79),heltab2x32(:,:,231))
Gcoeff(:)%j = (-(c(53)*M(5,:)%j)+c(52)*M(7,:)%j) * den(10)
call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(232),h0tab(:,232),[24,2,1,4],[0,nMT,nMZ,nMB],4,1,wf4(:,9))
  call Hloop_QA_V(ntryL,G0H32(1),wf4(:,9),G0H8(36),m3h4x8(:,80),heltab2x32(:,:,232))
Gcoeff(:)%j = (-(c(53)*M(5,:)%j)+c(52)*M(7,:)%j) * den(10)
call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(233),h0tab(:,233),[24,2,1,4],[nMH,nMT,0,nMB],4,1,wf4(:,9))
  call Hloop_QA_S(ntryL,G0H32(1),wf4(:,9),G0H8(37),ngH,m3h4x8(:,81),heltab2x32(:,:,233))
Gcoeff(:)%j = (-(c(53)*M(5,:)%j)+c(52)*M(7,:)%j) * den(10)
call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(234),h0tab(:,234),[24,2,1,4],[nMZ,nMT,0,nMB],4,1,wf4(:,9))
  call Hloop_QA_S(ntryL,G0H32(1),wf4(:,9),G0H8(38),ngX,m3h4x8(:,82),heltab2x32(:,:,234))
Gcoeff(:)%j = (-(c(10)*M(5,:)%j)+c(9)*M(7,:)%j) * den(10)
call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(235),h0tab(:,235),[24,2,1,4],[0,nMT,0,nMB],4,1,wf4(:,9))
  call Hloop_QA_V(ntryL,G0H32(1),wf4(:,9),G0H8(39),m3h4x8(:,83),heltab2x32(:,:,235))
Gcoeff(:)%j = (-(c(10)*M(5,:)%j)+c(9)*M(7,:)%j) * den(10)
call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(236),h0tab(:,236),[24,2,1,4],[0,nMT,0,nMB],4,1,wf4(:,9))
  call Hloop_QA_V(ntryL,G0H32(1),wf4(:,9),G0H8(40),m3h4x8(:,84),heltab2x32(:,:,236))
Gcoeff(:)%j = (c(15)*M(5,:)%j-c(14)*M(7,:)%j) * den(10)
call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(237),h0tab(:,237),[24,2,1,4],[0,nMT,nMZ,nMB],4,1,wf4(:,9))
  call Hloop_QA_V(ntryL,G0H32(1),wf4(:,9),G0H8(41),m3h4x8(:,85),heltab2x32(:,:,237))
Gcoeff(:)%j = (c(15)*M(5,:)%j-c(14)*M(7,:)%j) * den(10)
call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(238),h0tab(:,238),[24,2,1,4],[nMZ,nMT,0,nMB],4,1,wf4(:,9))
  call Hloop_QA_Z(ntryL,G0H32(1),wf4(:,9),G0H8(42),ngZd,m3h4x8(:,86),heltab2x32(:,:,238))
Gcoeff(:)%j = (-(c(28)*M(6,:)%j)+c(31)*M(8,:)%j) * den(10)
call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(239),h0tab(:,239),[24,2,1,4],[0,nMT,0,nMB],4,1,wf4(:,9))
  call Hloop_QA_V(ntryL,G0H32(1),wf4(:,9),G0H8(43),m3h4x8(:,87),heltab2x32(:,:,239))
Gcoeff(:)%j = (-(c(53)*M(5,:)%j)+c(52)*M(7,:)%j) * den(10)
call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(240),h0tab(:,240),[24,1,2,4],[nMH,nMT,0,nMB],4,1,wf4(:,9))
  call Hloop_QA_S(ntryL,G0H32(1),wf4(:,9),G0H8(44),ngH,m3h4x8(:,88),heltab2x32(:,:,240))
Gcoeff(:)%j = (-(c(53)*M(5,:)%j)+c(52)*M(7,:)%j) * den(10)
call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(241),h0tab(:,241),[24,1,2,4],[nMZ,nMT,0,nMB],4,1,wf4(:,9))
  call Hloop_QA_S(ntryL,G0H32(1),wf4(:,9),G0H8(45),ngX,m3h4x8(:,89),heltab2x32(:,:,241))
Gcoeff(:)%j = (-(c(53)*M(5,:)%j)+c(52)*M(7,:)%j) * den(10)
call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(242),h0tab(:,242),[24,1,2,4],[0,nMT,nMH,nMB],4,1,wf4(:,9))
  call Hloop_QA_V(ntryL,G0H32(1),wf4(:,9),G0H8(46),m3h4x8(:,90),heltab2x32(:,:,242))
Gcoeff(:)%j = (-(c(53)*M(5,:)%j)+c(52)*M(7,:)%j) * den(10)
call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(243),h0tab(:,243),[24,1,2,4],[0,nMT,nMZ,nMB],4,1,wf4(:,9))
  call Hloop_QA_V(ntryL,G0H32(1),wf4(:,9),G0H8(47),m3h4x8(:,91),heltab2x32(:,:,243))
Gcoeff(:)%j = (c(44)*M(5,:)%j-c(45)*M(7,:)%j) * den(10)
call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(244),h0tab(:,244),[24,1,2,4],[nMB,nMW,nMB,0],4,1,wf4(:,9))
  call Hloop_VA_Q(ntryL,G0H32(1),wf4(:,9),G0H8(48),m3h4x8(:,92),heltab2x32(:,:,244))
  call Hloop_A_Q(ntryL,G0H8(48),24,nMB,G1H8(44),n2h8(69))
Gcoeff(:)%j = (c(44)*M(5,:)%j-c(45)*M(7,:)%j) * den(10)
call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(245),h0tab(:,245),[24,1,2,4],[nMT,0,nMT,nMW],4,1,wf4(:,9))
  call Hloop_SA_Q(ntryL,G0H32(1),wf4(:,9),G0H8(48),ngPbt,m3h4x8(:,93),heltab2x32(:,:,245))
  call Hloop_A_Q(ntryL,G0H8(48),24,nMT,G1H8(46),n2h8(70))
Gcoeff(:)%j = (-(c(10)*M(5,:)%j)+c(9)*M(7,:)%j) * den(10)
call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(246),h0tab(:,246),[24,1,2,4],[0,nMT,0,nMB],4,1,wf4(:,9))
  call Hloop_QA_V(ntryL,G0H32(1),wf4(:,9),G0H8(48),m3h4x8(:,94),heltab2x32(:,:,246))
Gcoeff(:)%j = (-(c(10)*M(5,:)%j)+c(9)*M(7,:)%j) * den(10)
call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(247),h0tab(:,247),[24,1,2,4],[0,nMT,0,nMB],4,1,wf4(:,9))
  call Hloop_QA_V(ntryL,G0H32(1),wf4(:,9),G0H8(49),m3h4x8(:,95),heltab2x32(:,:,247))
Gcoeff(:)%j = (c(15)*M(5,:)%j-c(14)*M(7,:)%j) * den(10)
call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(248),h0tab(:,248),[24,1,2,4],[nMZ,nMT,0,nMB],4,1,wf4(:,9))
  call Hloop_QA_Z(ntryL,G0H32(1),wf4(:,9),G0H8(50),ngZd,m3h4x8(:,96),heltab2x32(:,:,248))
Gcoeff(:)%j = (c(15)*M(5,:)%j-c(14)*M(7,:)%j) * den(10)
call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(249),h0tab(:,249),[24,1,2,4],[0,nMT,nMZ,nMB],4,1,wf4(:,9))
  call Hloop_QA_V(ntryL,G0H32(1),wf4(:,9),G0H8(51),m3h4x8(:,97),heltab2x32(:,:,249))
Gcoeff(:)%j = (c(33)*M(6,:)%j+c(26)*M(8,:)%j) * den(10)
call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(250),h0tab(:,250),[24,1,2,4],[0,nMT,0,nMB],4,1,wf4(:,9))
  call Hloop_QA_V(ntryL,G0H32(1),wf4(:,9),G0H8(52),m3h4x8(:,98),heltab2x32(:,:,250))
Gcoeff(:)%j = (c(39)*M(5,:)%j-c(40)*M(7,:)%j) * den(10)
call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(251),h0tab(:,251),[24,1,2,4],[nMT,0,nMT,nMW],4,1,wf4(:,9))
  call Hloop_WA_Q(ntryL,G0H32(1),wf4(:,9),G0H8(53),m3h4x8(:,99),heltab2x32(:,:,251))
  call Hloop_A_Q(ntryL,G0H8(53),24,nMT,G1H8(47),n2h8(71))
Gcoeff(:)%j = (c(39)*M(5,:)%j-c(40)*M(7,:)%j) * den(10)
call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(252),h0tab(:,252),[24,1,2,4],[nMB,nMW,nMB,0],4,1,wf4(:,9))
  call Hloop_VA_Q(ntryL,G0H32(1),wf4(:,9),G0H8(53),m3h4x8(:,100),heltab2x32(:,:,252))
  call Hloop_A_Q(ntryL,G0H8(53),24,nMB,G1H8(48),n2h8(72))
Gcoeff(:)%j = (c(44)*M(5,:)%j-c(45)*M(7,:)%j) * den(10)
call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(253),h0tab(:,253),[24,1,4,2],[nMB,nMW,nMT,0],4,1,wf4(:,9))
  call Hloop_VA_Q(ntryL,G0H32(1),wf4(:,9),G0H8(53),m3h4x8(:,101),heltab2x32(:,:,253))
  call Hloop_A_Q(ntryL,G0H8(53),24,nMB,G1H8(49),n2h8(73))
Gcoeff(:)%j = (c(44)*M(5,:)%j-c(45)*M(7,:)%j) * den(10)
call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(254),h0tab(:,254),[24,1,4,2],[nMT,0,nMB,nMW],4,1,wf4(:,9))
  call Hloop_SA_Q(ntryL,G0H32(1),wf4(:,9),G0H8(53),ngPbt,m3h4x8(:,102),heltab2x32(:,:,254))
  call Hloop_A_Q(ntryL,G0H8(53),24,nMT,G1H8(50),n2h8(74))
Gcoeff(:)%j = (c(39)*M(5,:)%j-c(40)*M(7,:)%j) * den(10)
call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(255),h0tab(:,255),[24,1,4,2],[nMB,nMW,nMT,0],4,1,wf4(:,9))
  call Hloop_VA_Q(ntryL,G0H32(1),wf4(:,9),G0H8(53),m3h4x8(:,103),heltab2x32(:,:,255))
  call Hloop_A_Q(ntryL,G0H8(53),24,nMB,G1H8(51),n2h8(75))
Gcoeff(:)%j = (c(39)*M(5,:)%j-c(40)*M(7,:)%j) * den(10)
call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(256),h0tab(:,256),[24,1,4,2],[nMT,0,nMB,nMW],4,1,wf4(:,9))
  call Hloop_WA_Q(ntryL,G0H32(1),wf4(:,9),G0H8(53),m3h4x8(:,104),heltab2x32(:,:,256))
  call Hloop_A_Q(ntryL,G0H8(53),24,nMT,G1H8(52),n2h8(76))
  call ol_merge(ntryL,G1H16(75),[G1H16(46),G1H16(32)])
  call ol_merge(ntryL,G1H16(13),[G1H16(10),G1H16(7)])
  call ol_merge(ntryL,G1H16(22),[G1H16(23)])
  call ol_merge(ntryL,G1H16(49),[G1H16(45),G1H16(42)])
  call ol_merge(ntryL,G1H16(61),[G1H16(58),G1H16(56)])
  call ol_merge(ntryL,G1H16(70),[G1H16(68)])
  call ol_merge(ntryL,G1H8(8),[G1H8(5),G1H8(4)])
  call ol_merge(ntryL,G1H8(17),[G1H8(14),G1H8(13)])
  call ol_merge(ntryL,G1H8(30),[G1H8(27),G1H8(26)])
  call ol_merge(ntryL,G1H8(39),[G1H8(36),G1H8(35)])
  call ol_merge(ntryL,G0H8(21),[G0H8(18),G0H8(17)])
  call ol_merge(ntryL,G0H8(30),[G0H8(27),G0H8(26)])
  call ol_merge(ntryL,G0H8(43),[G0H8(40),G0H8(39)])
  call ol_merge(ntryL,G0H8(52),[G0H8(49),G0H8(48)])
  call Hloop_QS_A(ntryL,G1H16(6),wf4(:,3),G1H4(1),ngH,m3h4x4(:,1),heltab2x16(:,:,69))
  call Hloop_Q_A(ntryL,G1H4(1),19,nMB,G2H4(2),n2h4(69))
  call Hloop_QS_A(ntryL,G1H16(5),wf4(:,6),G1H4(2),ngX,m3h4x4(:,2),heltab2x16(:,:,70))
  call Hloop_Q_A(ntryL,G1H4(2),19,nMB,G2H4(15),n2h4(70))
  call Hloop_QV_A(ntryL,G1H16(12),wf4(:,1),G1H4(5),m3h4x4(:,3),heltab2x16(:,:,71))
  call Hloop_Q_A(ntryL,G1H4(5),19,nMB,G2H4(21),n2h4(71))
  call Hloop_QV_A(ntryL,G1H16(20),wf4(:,1),G1H4(6),m3h4x4(:,4),heltab2x16(:,:,72))
  call Hloop_Q_A(ntryL,G1H4(6),19,nMB,G2H4(29),n2h4(72))
  call Hloop_QV_A(ntryL,G1H16(19),wf4(:,1),G1H4(7),m3h4x4(:,5),heltab2x16(:,:,73))
  call Hloop_Q_A(ntryL,G1H4(7),19,nMT,G2H4(44),n2h4(73))
  call Hloop_QV_A(ntryL,G1H16(75),wf4(:,1),G1H4(8),m3h4x4(:,6),heltab2x16(:,:,74))
  call Hloop_Q_A(ntryL,G1H4(8),19,nMB,G2H4(47),n2h4(74))
  call Hloop_QZ_A(ntryL,G1H16(41),wf4(:,7),G1H4(11),ngZd,m3h4x4(:,7),heltab2x16(:,:,75))
  call Hloop_Q_A(ntryL,G1H4(11),19,nMB,G2H4(52),n2h4(75))
  call Hloop_QV_A(ntryL,G1H16(64),wf4(:,1),G1H4(12),m3h4x4(:,8),heltab2x16(:,:,76))
  call Hloop_Q_A(ntryL,G1H4(12),19,nMB,G2H4(61),n2h4(76))
  call Hloop_QV_A(ntryL,G1H16(63),wf4(:,1),G1H4(13),m3h4x4(:,9),heltab2x16(:,:,77))
  call Hloop_Q_A(ntryL,G1H4(13),19,nMT,G2H4(1),n2h4(77))
  call Hloop_UV_W(ntryL,G1H16(74),16,wf4(:,1),3,G2H4(6),m3h4x4(:,10),heltab2x16(:,:,78))
  call Hloop_AS_Q(ntryL,G1H16(1),wf4(:,3),G1H4(14),ngH,m3h4x4(:,11),heltab2x16(:,:,79))
  call Hloop_A_Q(ntryL,G1H4(14),19,nMB,G2H4(3),n2h4(78))
  call Hloop_AS_Q(ntryL,G1H16(2),wf4(:,6),G1H4(17),ngX,m3h4x4(:,12),heltab2x16(:,:,80))
  call Hloop_A_Q(ntryL,G1H4(17),19,nMB,G2H4(4),n2h4(79))
  call Hloop_AV_Q(ntryL,G1H16(3),wf4(:,1),G1H4(18),m3h4x4(:,13),heltab2x16(:,:,81))
  call Hloop_A_Q(ntryL,G1H4(18),19,nMB,G2H4(5),n2h4(80))
  call Hloop_AV_Q(ntryL,G1H16(4),wf4(:,1),G1H4(19),m3h4x4(:,14),heltab2x16(:,:,82))
  call Hloop_A_Q(ntryL,G1H4(19),19,nMB,G2H4(7),n2h4(81))
  call Hloop_AV_Q(ntryL,G1H16(9),wf4(:,1),G1H4(20),m3h4x4(:,15),heltab2x16(:,:,83))
  call Hloop_A_Q(ntryL,G1H4(20),19,nMT,G2H4(8),n2h4(82))
  call Hloop_AV_Q(ntryL,G1H16(13),wf4(:,1),G1H4(23),m3h4x4(:,16),heltab2x16(:,:,84))
  call Hloop_A_Q(ntryL,G1H4(23),19,nMB,G2H4(9),n2h4(83))
  call Hloop_AZ_Q(ntryL,G1H16(8),wf4(:,7),G1H4(24),ngZd,m3h4x4(:,17),heltab2x16(:,:,85))
  call Hloop_A_Q(ntryL,G1H4(24),19,nMB,G2H4(10),n2h4(84))
  call Hloop_AV_Q(ntryL,G1H16(11),wf4(:,1),G1H4(25),m3h4x4(:,18),heltab2x16(:,:,86))
  call Hloop_A_Q(ntryL,G1H4(25),19,nMB,G2H4(11),n2h4(85))
  call Hloop_AV_Q(ntryL,G1H16(14),wf4(:,1),G1H4(26),m3h4x4(:,19),heltab2x16(:,:,87))
  call Hloop_A_Q(ntryL,G1H4(26),19,nMT,G2H4(12),n2h4(86))
  call Hloop_UV_W(ntryL,G1H16(15),16,wf4(:,1),3,G2H4(13),m3h4x4(:,20),heltab2x16(:,:,88))
  call Hloop_VQ_A(ntryL,G1H16(16),ex3(:),G1H8(5),m3h2x8(:,69),heltab2x16(:,:,89))
  call Hloop_Q_A(ntryL,G1H8(5),20,nMB,G2H8(1),n2h8(77))
  call Hloop_VQ_A(ntryL,G1H16(17),ex3(:),G1H8(4),m3h2x8(:,70),heltab2x16(:,:,90))
  call Hloop_Q_A(ntryL,G1H8(4),20,nMB,G2H8(2),n2h8(78))
  call Hloop_AQ_V(ntryL,G1H16(18),ex3(:),G1H8(14),m3h2x8(:,71),heltab2x16(:,:,91))
  call Hloop_VQ_A(ntryL,G1H16(22),ex3(:),G1H8(13),m3h2x8(:,72),heltab2x16(:,:,92))
  call Hloop_Q_A(ntryL,G1H8(13),20,nMB,G2H8(3),n2h8(79))
  call Hloop_VQ_A(ntryL,G1H16(21),ex3(:),G1H8(27),m3h2x8(:,73),heltab2x16(:,:,93))
  call Hloop_Q_A(ntryL,G1H8(27),20,nMB,G2H8(4),n2h8(80))
  call Hloop_AQ_V(ntryL,G1H16(24),ex1(:),G1H8(26),m3h2x8(:,74),heltab2x16(:,:,94))
  call Hloop_AQ_V(ntryL,G1H16(25),ex1(:),G1H8(36),m3h2x8(:,75),heltab2x16(:,:,95))
  call Hloop_AS_Q(ntryL,G1H16(26),wf4(:,11),G1H4(29),ngPbt,m3h4x4(:,21),heltab2x16(:,:,96))
  call Hloop_A_Q(ntryL,G1H4(29),22,nMT,G2H4(14),n2h4(87))
  call Hloop_AW_Q(ntryL,G1H16(27),wf4(:,13),G1H4(30),m3h4x4(:,22),heltab2x16(:,:,97))
  call Hloop_A_Q(ntryL,G1H4(30),22,nMT,G2H4(18),n2h4(88))
  call Hloop_VQ_A(ntryL,G1H16(28),ex1(:),G1H8(35),m3h2x8(:,76),heltab2x16(:,:,98))
  call Hloop_Q_A(ntryL,G1H8(35),17,nMT,G2H8(5),n2h8(81))
  call Hloop_VQ_A(ntryL,G1H16(29),ex1(:),G1H8(5),m3h2x8(:,77),heltab2x16(:,:,99))
  call Hloop_Q_A(ntryL,G1H8(5),17,nMT,G2H8(6),n2h8(82))
  call Hloop_QA_V(ntryL,G1H16(30),ex2(:),G1H8(4),m3h2x8(:,78),heltab2x16(:,:,100))
  call Hloop_QA_V(ntryL,G1H16(31),ex2(:),G1H8(13),m3h2x8(:,79),heltab2x16(:,:,101))
  call Hloop_AQ_V(ntryL,G1H16(34),ex3(:),G1H8(27),m3h2x8(:,80),heltab2x16(:,:,102))
  call Hloop_AQ_V(ntryL,G1H16(33),ex3(:),G1H8(35),m3h2x8(:,81),heltab2x16(:,:,103))
  call Hloop_VA_Q(ntryL,G1H16(35),ex2(:),G1H8(5),m3h2x8(:,82),heltab2x16(:,:,104))
  call Hloop_A_Q(ntryL,G1H8(5),18,nMT,G2H8(7),n2h8(83))
  call Hloop_VA_Q(ntryL,G1H16(36),ex2(:),G1H8(5),m3h2x8(:,83),heltab2x16(:,:,105))
  call Hloop_A_Q(ntryL,G1H8(5),18,nMT,G2H8(8),n2h8(84))
  call Hloop_AQ_V(ntryL,G1H16(37),ex1(:),G1H8(5),m3h2x8(:,84),heltab2x16(:,:,106))
  call Hloop_AQ_V(ntryL,G1H16(38),ex1(:),G1H8(53),m3h2x8(:,85),heltab2x16(:,:,107))
  call Hloop_AQ_S(ntryL,G1H16(39),ex1(:),G1H8(54),ngH,m3h2x8(:,86),heltab2x16(:,:,108))
  call Hloop_AQ_S(ntryL,G1H16(40),ex1(:),G1H8(55),ngX,m3h2x8(:,87),heltab2x16(:,:,109))
  call Hloop_AQ_S(ntryL,G1H16(43),ex1(:),G1H8(56),ngPbt,m3h2x8(:,88),heltab2x16(:,:,110))
  call Hloop_AQ_V(ntryL,G1H16(49),ex1(:),G1H8(57),m3h2x8(:,89),heltab2x16(:,:,111))
  call Hloop_AQ_V(ntryL,G1H16(44),ex1(:),G1H8(58),m3h2x8(:,90),heltab2x16(:,:,112))
  call Hloop_AQ_Z(ntryL,G1H16(48),ex1(:),G1H8(59),ngZu,m3h2x8(:,91),heltab2x16(:,:,113))
  call Hloop_AQ_W(ntryL,G1H16(47),ex1(:),G1H8(60),m3h2x8(:,92),heltab2x16(:,:,114))
  call Hloop_VQ_A(ntryL,G1H16(50),ex1(:),G1H8(61),m3h2x8(:,93),heltab2x16(:,:,115))
  call Hloop_Q_A(ntryL,G1H8(61),17,nMT,G2H8(9),n2h8(85))
  call Hloop_QA_V(ntryL,G1H16(51),ex2(:),G1H8(61),m3h2x8(:,94),heltab2x16(:,:,116))
  call Hloop_QA_V(ntryL,G1H16(52),ex2(:),G1H8(62),m3h2x8(:,95),heltab2x16(:,:,117))
  call Hloop_QA_S(ntryL,G1H16(53),ex2(:),G1H8(63),ngH,m3h2x8(:,96),heltab2x16(:,:,118))
  call Hloop_QA_S(ntryL,G1H16(54),ex2(:),G1H8(64),ngX,m3h2x8(:,97),heltab2x16(:,:,119))
  call Hloop_QA_S(ntryL,G1H16(55),ex2(:),G1H8(65),ngPtb,m3h2x8(:,98),heltab2x16(:,:,120))
  call Hloop_QA_V(ntryL,G1H16(61),ex2(:),G1H8(66),m3h2x8(:,99),heltab2x16(:,:,121))
  call Hloop_QA_V(ntryL,G1H16(57),ex2(:),G1H8(67),m3h2x8(:,100),heltab2x16(:,:,122))
  call Hloop_QA_Z(ntryL,G1H16(59),ex2(:),G1H8(68),ngZu,m3h2x8(:,101),heltab2x16(:,:,123))
  call Hloop_QA_W(ntryL,G1H16(60),ex2(:),G1H8(69),m3h2x8(:,102),heltab2x16(:,:,124))
  call Hloop_VA_Q(ntryL,G1H16(62),ex2(:),G1H8(70),m3h2x8(:,103),heltab2x16(:,:,125))
  call Hloop_A_Q(ntryL,G1H8(70),18,nMT,G2H8(10),n2h8(86))
  call Hloop_VQ_A(ntryL,G1H16(67),ex1(:),G1H8(70),m3h2x8(:,104),heltab2x16(:,:,126))
  call Hloop_Q_A(ntryL,G1H8(70),17,nMT,G2H8(11),n2h8(87))
  call Hloop_VQ_A(ntryL,G1H16(65),ex1(:),G1H8(70),m3h2x8(:,105),heltab2x16(:,:,127))
  call Hloop_Q_A(ntryL,G1H8(70),17,nMT,G2H8(12),n2h8(88))
  call Hloop_AQ_V(ntryL,G1H16(66),ex1(:),G1H8(70),m3h2x8(:,106),heltab2x16(:,:,128))
  call Hloop_VQ_A(ntryL,G1H16(70),ex1(:),G1H8(71),m3h2x8(:,107),heltab2x16(:,:,129))
  call Hloop_Q_A(ntryL,G1H8(71),17,nMT,G2H8(13),n2h8(89))
  call Hloop_VQ_A(ntryL,G1H16(69),ex1(:),G1H8(71),m3h2x8(:,108),heltab2x16(:,:,130))
  call Hloop_Q_A(ntryL,G1H8(71),17,nMT,G2H8(14),n2h8(90))
  call Hloop_VQ_A(ntryL,G0H8(1),ex3(:),G0H4(1),m3h2x4(:,69),heltab2x8(:,:,69))
  call Hloop_Q_A(ntryL,G0H4(1),21,nMB,G1H4(31),n2h4(89))
  call Hloop_SQ_A(ntryL,G0H8(2),ex3(:),G0H4(1),ngPtb,m3h2x4(:,70),heltab2x8(:,:,70))
  call Hloop_Q_A(ntryL,G0H4(1),21,nMT,G1H4(32),n2h4(90))
  call Hloop_WQ_A(ntryL,G0H8(3),ex3(:),G0H4(1),m3h2x4(:,71),heltab2x8(:,:,71))
  call Hloop_Q_A(ntryL,G0H4(1),21,nMT,G1H4(35),n2h4(91))
  call Hloop_VQ_A(ntryL,G0H8(4),ex3(:),G0H4(1),m3h2x4(:,72),heltab2x8(:,:,72))
  call Hloop_Q_A(ntryL,G0H4(1),21,nMB,G1H4(36),n2h4(92))
  call Hloop_SA_Q(ntryL,G0H8(5),ex2(:),G0H4(1),ngPtb,m3h2x4(:,73),heltab2x8(:,:,73))
  call Hloop_A_Q(ntryL,G0H4(1),19,nMB,G1H4(37),n2h4(93))
  call Hloop_VA_Q(ntryL,G0H8(6),ex2(:),G0H4(1),m3h2x4(:,74),heltab2x8(:,:,74))
  call Hloop_A_Q(ntryL,G0H4(1),19,nMT,G1H4(38),n2h4(94))
  call Hloop_QA_S(ntryL,G1H8(45),ex2(:),G1H4(41),ngH,m3h2x4(:,75),heltab2x8(:,:,75))
  call Hloop_QA_S(ntryL,G1H8(1),ex2(:),G1H4(42),ngX,m3h2x4(:,76),heltab2x8(:,:,76))
  call Hloop_QA_V(ntryL,G1H8(2),ex2(:),G1H4(43),m3h2x4(:,77),heltab2x8(:,:,77))
  call Hloop_QA_V(ntryL,G1H8(3),ex2(:),G1H4(44),m3h2x4(:,78),heltab2x8(:,:,78))
  call Hloop_VA_Q(ntryL,G0H8(7),ex2(:),G0H4(1),m3h2x4(:,79),heltab2x8(:,:,79))
  call Hloop_A_Q(ntryL,G0H4(1),19,nMT,G1H4(47),n2h4(95))
  call Hloop_WA_Q(ntryL,G0H8(8),ex2(:),G0H4(1),m3h2x4(:,80),heltab2x8(:,:,80))
  call Hloop_A_Q(ntryL,G0H4(1),19,nMB,G1H4(48),n2h4(96))
  call Hloop_QA_V(ntryL,G1H8(8),ex2(:),G1H4(49),m3h2x4(:,81),heltab2x8(:,:,81))
  call Hloop_QA_Z(ntryL,G1H8(6),ex2(:),G1H4(50),ngZu,m3h2x4(:,82),heltab2x8(:,:,82))
  call Hloop_QA_V(ntryL,G1H8(7),ex2(:),G1H4(53),m3h2x4(:,83),heltab2x8(:,:,83))
  call Hloop_QA_S(ntryL,G1H8(9),ex2(:),G1H4(54),ngH,m3h2x4(:,84),heltab2x8(:,:,84))
  call Hloop_QA_S(ntryL,G1H8(10),ex2(:),G1H4(55),ngX,m3h2x4(:,85),heltab2x8(:,:,85))
  call Hloop_QA_V(ntryL,G1H8(11),ex2(:),G1H4(56),m3h2x4(:,86),heltab2x8(:,:,86))
  call Hloop_QA_V(ntryL,G1H8(12),ex2(:),G1H4(59),m3h2x4(:,87),heltab2x8(:,:,87))
  call Hloop_QA_V(ntryL,G1H8(17),ex2(:),G1H4(60),m3h2x4(:,88),heltab2x8(:,:,88))
  call Hloop_QA_Z(ntryL,G1H8(15),ex2(:),G1H4(61),ngZu,m3h2x4(:,89),heltab2x8(:,:,89))
  call Hloop_QA_V(ntryL,G1H8(16),ex2(:),G1H4(62),m3h2x4(:,90),heltab2x8(:,:,90))
  call Hloop_AQ_S(ntryL,G1H8(18),ex3(:),G1H4(65),ngPtb,m3h2x4(:,91),heltab2x8(:,:,91))
  call Hloop_AQ_V(ntryL,G1H8(19),ex3(:),G1H4(66),m3h2x4(:,92),heltab2x8(:,:,92))
  call Hloop_AQ_W(ntryL,G1H8(20),ex3(:),G1H4(67),m3h2x4(:,93),heltab2x8(:,:,93))
  call Hloop_AQ_V(ntryL,G1H8(21),ex3(:),G1H4(68),m3h2x4(:,94),heltab2x8(:,:,94))
  call Hloop_AQ_S(ntryL,G1H8(22),ex1(:),G1H4(71),ngH,m3h2x4(:,95),heltab2x8(:,:,95))
  call Hloop_AQ_S(ntryL,G1H8(23),ex1(:),G1H4(72),ngX,m3h2x4(:,96),heltab2x8(:,:,96))
  call Hloop_AQ_V(ntryL,G1H8(24),ex1(:),G1H4(73),m3h2x4(:,97),heltab2x8(:,:,97))
  call Hloop_AQ_V(ntryL,G1H8(25),ex1(:),G1H4(74),m3h2x4(:,98),heltab2x8(:,:,98))
  call Hloop_AQ_V(ntryL,G1H8(30),ex1(:),G1H4(77),m3h2x4(:,99),heltab2x8(:,:,99))
  call Hloop_AQ_Z(ntryL,G1H8(28),ex1(:),G1H4(78),ngZu,m3h2x4(:,100),heltab2x8(:,:,100))
  call Hloop_AQ_V(ntryL,G1H8(29),ex1(:),G1H4(79),m3h2x4(:,101),heltab2x8(:,:,101))
  call Hloop_SQ_A(ntryL,G0H8(9),ex1(:),G0H4(1),ngPbt,m3h2x4(:,102),heltab2x8(:,:,102))
  call Hloop_Q_A(ntryL,G0H4(1),19,nMB,G1H4(80),n2h4(97))
  call Hloop_VQ_A(ntryL,G0H8(10),ex1(:),G0H4(1),m3h2x4(:,103),heltab2x8(:,:,103))
  call Hloop_Q_A(ntryL,G0H4(1),19,nMT,G1H4(83),n2h4(98))
  call Hloop_AQ_S(ntryL,G1H8(31),ex1(:),G1H4(84),ngH,m3h2x4(:,104),heltab2x8(:,:,104))
  call Hloop_AQ_S(ntryL,G1H8(32),ex1(:),G1H4(85),ngX,m3h2x4(:,105),heltab2x8(:,:,105))
  call Hloop_AQ_V(ntryL,G1H8(33),ex1(:),G1H4(86),m3h2x4(:,106),heltab2x8(:,:,106))
  call Hloop_AQ_V(ntryL,G1H8(34),ex1(:),G1H4(89),m3h2x4(:,107),heltab2x8(:,:,107))
  call Hloop_VQ_A(ntryL,G0H8(11),ex1(:),G0H4(1),m3h2x4(:,108),heltab2x8(:,:,108))
  call Hloop_Q_A(ntryL,G0H4(1),19,nMT,G1H4(90),n2h4(99))
  call Hloop_WQ_A(ntryL,G0H8(12),ex1(:),G0H4(1),m3h2x4(:,109),heltab2x8(:,:,109))
  call Hloop_Q_A(ntryL,G0H4(1),19,nMB,G1H4(91),n2h4(100))
  call Hloop_AQ_V(ntryL,G1H8(39),ex1(:),G1H4(92),m3h2x4(:,110),heltab2x8(:,:,110))
  call Hloop_AQ_Z(ntryL,G1H8(37),ex1(:),G1H4(95),ngZu,m3h2x4(:,111),heltab2x8(:,:,111))
  call Hloop_AQ_V(ntryL,G1H8(38),ex1(:),G1H4(96),m3h2x4(:,112),heltab2x8(:,:,112))
  call Hloop_VA_Q(ntryL,G0H8(13),ex2(:),G0H4(1),m3h2x4(:,113),heltab2x8(:,:,113))
  call Hloop_A_Q(ntryL,G0H4(1),22,nMT,G1H4(97),n2h4(101))
  call Hloop_VA_Q(ntryL,G0H8(14),ex2(:),G0H4(1),m3h2x4(:,114),heltab2x8(:,:,114))
  call Hloop_A_Q(ntryL,G0H4(1),22,nMT,G1H4(98),n2h4(102))
  call Hloop_SA_Q(ntryL,G0H8(15),ex2(:),G0H4(1),ngH,m3h2x4(:,115),heltab2x8(:,:,115))
  call Hloop_A_Q(ntryL,G0H4(1),22,nMT,G1H4(101),n2h4(103))
  call Hloop_SA_Q(ntryL,G0H8(16),ex2(:),G0H4(1),ngX,m3h2x4(:,116),heltab2x8(:,:,116))
  call Hloop_A_Q(ntryL,G0H4(1),22,nMT,G1H4(102),n2h4(104))
  call Hloop_QA_S(ntryL,G1H8(40),ex2(:),G1H4(103),ngPtb,m3h2x4(:,117),heltab2x8(:,:,117))
  call Hloop_QA_V(ntryL,G1H8(41),ex2(:),G1H4(104),m3h2x4(:,118),heltab2x8(:,:,118))
  call Hloop_VA_Q(ntryL,G0H8(21),ex2(:),G0H4(1),m3h2x4(:,119),heltab2x8(:,:,119))
  call Hloop_A_Q(ntryL,G0H4(1),22,nMT,G1H4(107),n2h4(105))
  call Hloop_VA_Q(ntryL,G0H8(19),ex2(:),G0H4(1),m3h2x4(:,120),heltab2x8(:,:,120))
  call Hloop_A_Q(ntryL,G0H4(1),22,nMT,G1H4(108),n2h4(106))
  call Hloop_ZA_Q(ntryL,G0H8(20),ex2(:),G0H4(1),ngZu,m3h2x4(:,121),heltab2x8(:,:,121))
  call Hloop_A_Q(ntryL,G0H4(1),22,nMT,G1H4(109),n2h4(107))
  call Hloop_QA_V(ntryL,G1H8(42),ex2(:),G1H4(110),m3h2x4(:,122),heltab2x8(:,:,122))
  call Hloop_QA_W(ntryL,G1H8(43),ex2(:),G1H4(113),m3h2x4(:,123),heltab2x8(:,:,123))
  call Hloop_SQ_A(ntryL,G0H8(22),ex1(:),G0H4(1),ngH,m3h2x4(:,124),heltab2x8(:,:,124))
  call Hloop_Q_A(ntryL,G0H4(1),21,nMT,G1H4(114),n2h4(108))
  call Hloop_SQ_A(ntryL,G0H8(23),ex1(:),G0H4(1),ngX,m3h2x4(:,125),heltab2x8(:,:,125))
  call Hloop_Q_A(ntryL,G0H4(1),21,nMT,G1H4(115),n2h4(109))
  call Hloop_VQ_A(ntryL,G0H8(24),ex1(:),G0H4(1),m3h2x4(:,126),heltab2x8(:,:,126))
  call Hloop_Q_A(ntryL,G0H4(1),21,nMT,G1H4(116),n2h4(110))
  call Hloop_VQ_A(ntryL,G0H8(25),ex1(:),G0H4(1),m3h2x4(:,127),heltab2x8(:,:,127))
  call Hloop_Q_A(ntryL,G0H4(1),21,nMT,G1H4(119),n2h4(111))
  call Hloop_VQ_A(ntryL,G0H8(30),ex1(:),G0H4(1),m3h2x4(:,128),heltab2x8(:,:,128))
  call Hloop_Q_A(ntryL,G0H4(1),21,nMT,G1H4(120),n2h4(112))
  call Hloop_ZQ_A(ntryL,G0H8(28),ex1(:),G0H4(1),ngZu,m3h2x4(:,129),heltab2x8(:,:,129))
  call Hloop_Q_A(ntryL,G0H4(1),21,nMT,G1H4(121),n2h4(113))
  call Hloop_VQ_A(ntryL,G0H8(29),ex1(:),G0H4(1),m3h2x4(:,130),heltab2x8(:,:,130))
  call Hloop_Q_A(ntryL,G0H4(1),21,nMT,G1H4(122),n2h4(114))
  call Hloop_SQ_A(ntryL,G0H8(31),ex1(:),G0H4(1),ngPbt,m3h2x4(:,131),heltab2x8(:,:,131))
  call Hloop_Q_A(ntryL,G0H4(1),21,nMB,G1H4(125),n2h4(115))
  call Hloop_VQ_A(ntryL,G0H8(32),ex1(:),G0H4(1),m3h2x4(:,132),heltab2x8(:,:,132))
  call Hloop_Q_A(ntryL,G0H4(1),21,nMT,G1H4(126),n2h4(116))
  call Hloop_VQ_A(ntryL,G0H8(33),ex1(:),G0H4(1),m3h2x4(:,133),heltab2x8(:,:,133))
  call Hloop_Q_A(ntryL,G0H4(1),21,nMT,G1H4(127),n2h4(117))
  call Hloop_WQ_A(ntryL,G0H8(34),ex1(:),G0H4(1),m3h2x4(:,134),heltab2x8(:,:,134))
  call Hloop_Q_A(ntryL,G0H4(1),21,nMB,G1H4(128),n2h4(118))
  call Hloop_VA_Q(ntryL,G0H8(35),ex2(:),G0H4(1),m3h2x4(:,135),heltab2x8(:,:,135))
  call Hloop_A_Q(ntryL,G0H4(1),26,nMT,G1H4(131),n2h4(119))
  call Hloop_VA_Q(ntryL,G0H8(36),ex2(:),G0H4(1),m3h2x4(:,136),heltab2x8(:,:,136))
  call Hloop_A_Q(ntryL,G0H4(1),26,nMT,G1H4(132),n2h4(120))
  call Hloop_SA_Q(ntryL,G0H8(37),ex2(:),G0H4(1),ngH,m3h2x4(:,137),heltab2x8(:,:,137))
  call Hloop_A_Q(ntryL,G0H4(1),26,nMT,G1H4(133),n2h4(121))
  call Hloop_SA_Q(ntryL,G0H8(38),ex2(:),G0H4(1),ngX,m3h2x4(:,138),heltab2x8(:,:,138))
  call Hloop_A_Q(ntryL,G0H4(1),26,nMT,G1H4(134),n2h4(122))
  call Hloop_VA_Q(ntryL,G0H8(43),ex2(:),G0H4(1),m3h2x4(:,139),heltab2x8(:,:,139))
  call Hloop_A_Q(ntryL,G0H4(1),26,nMT,G1H4(137),n2h4(123))
  call Hloop_VA_Q(ntryL,G0H8(41),ex2(:),G0H4(1),m3h2x4(:,140),heltab2x8(:,:,140))
  call Hloop_A_Q(ntryL,G0H4(1),26,nMT,G1H4(138),n2h4(124))
  call Hloop_ZA_Q(ntryL,G0H8(42),ex2(:),G0H4(1),ngZu,m3h2x4(:,141),heltab2x8(:,:,141))
  call Hloop_A_Q(ntryL,G0H4(1),26,nMT,G1H4(139),n2h4(125))
  call Hloop_SQ_A(ntryL,G0H8(44),ex1(:),G0H4(1),ngH,m3h2x4(:,142),heltab2x8(:,:,142))
  call Hloop_Q_A(ntryL,G0H4(1),25,nMT,G1H4(140),n2h4(126))
  call Hloop_SQ_A(ntryL,G0H8(45),ex1(:),G0H4(1),ngX,m3h2x4(:,143),heltab2x8(:,:,143))
  call Hloop_Q_A(ntryL,G0H4(1),25,nMT,G1H4(143),n2h4(127))
  call Hloop_VQ_A(ntryL,G0H8(46),ex1(:),G0H4(1),m3h2x4(:,144),heltab2x8(:,:,144))
  call Hloop_Q_A(ntryL,G0H4(1),25,nMT,G1H4(144),n2h4(128))
  call Hloop_VQ_A(ntryL,G0H8(47),ex1(:),G0H4(1),m3h2x4(:,145),heltab2x8(:,:,145))
  call Hloop_Q_A(ntryL,G0H4(1),25,nMT,G1H4(1),n2h4(129))
  call Hloop_AQ_S(ntryL,G1H8(44),ex1(:),G1H4(2),ngPbt,m3h2x4(:,146),heltab2x8(:,:,146))
  call Hloop_AQ_V(ntryL,G1H8(46),ex1(:),G1H4(5),m3h2x4(:,147),heltab2x8(:,:,147))
  call Hloop_VQ_A(ntryL,G0H8(52),ex1(:),G0H4(1),m3h2x4(:,148),heltab2x8(:,:,148))
  call Hloop_Q_A(ntryL,G0H4(1),25,nMT,G1H4(6),n2h4(130))
  call Hloop_ZQ_A(ntryL,G0H8(50),ex1(:),G0H4(1),ngZu,m3h2x4(:,149),heltab2x8(:,:,149))
  call Hloop_Q_A(ntryL,G0H4(1),25,nMT,G1H4(7),n2h4(131))
  call Hloop_VQ_A(ntryL,G0H8(51),ex1(:),G0H4(1),m3h2x4(:,150),heltab2x8(:,:,150))
  call Hloop_Q_A(ntryL,G0H4(1),25,nMT,G1H4(8),n2h4(132))
  call Hloop_AQ_V(ntryL,G1H8(47),ex1(:),G1H4(11),m3h2x4(:,151),heltab2x8(:,:,151))
  call Hloop_AQ_W(ntryL,G1H8(48),ex1(:),G1H4(12),m3h2x4(:,152),heltab2x8(:,:,152))
  call Hloop_AQ_S(ntryL,G1H8(49),ex1(:),G1H4(13),ngPbt,m3h2x4(:,153),heltab2x8(:,:,153))
  call Hloop_AQ_V(ntryL,G1H8(50),ex1(:),G1H4(14),m3h2x4(:,154),heltab2x8(:,:,154))
  call Hloop_AQ_W(ntryL,G1H8(51),ex1(:),G1H4(17),m3h2x4(:,155),heltab2x8(:,:,155))
  call Hloop_AQ_V(ntryL,G1H8(52),ex1(:),G1H4(18),m3h2x4(:,156),heltab2x8(:,:,156))
  call ol_merge(ntryL,G1H4(71),[G1H4(3)])
  call ol_merge(ntryL,G1H4(64),[G1H4(4)])
  call ol_merge(ntryL,G1H4(72),[G1H4(9)])
  call ol_merge(ntryL,G1H4(70),[G1H4(10)])
  call ol_merge(ntryL,G1H4(77),[G1H4(15)])
  call ol_merge(ntryL,G2H4(13),[G1H4(76),G1H4(16)])
  call ol_merge(ntryL,G1H4(78),[G1H4(21)])
  call ol_merge(ntryL,G1H4(82),[G1H4(22)])
  call ol_merge(ntryL,G1H4(103),[G1H4(27)])
  call ol_merge(ntryL,G1H4(112),[G1H4(28)])
  call ol_merge(ntryL,G1H4(113),[G1H4(33)])
  call ol_merge(ntryL,G1H4(118),[G1H4(34)])
  call ol_merge(ntryL,G1H4(84),[G1H4(39)])
  call ol_merge(ntryL,G1H4(88),[G1H4(40)])
  call ol_merge(ntryL,G1H4(85),[G1H4(45)])
  call ol_merge(ntryL,G1H4(94),[G1H4(46)])
  call ol_merge(ntryL,G1H4(92),[G1H4(51)])
  call ol_merge(ntryL,G2H4(6),[G1H4(100),G1H4(52)])
  call ol_merge(ntryL,G1H4(95),[G1H4(57)])
  call ol_merge(ntryL,G1H4(106),[G1H4(58)])
  call ol_merge(ntryL,G1H4(41),[G1H4(63)])
  call ol_merge(ntryL,G1H4(42),[G1H4(69)])
  call ol_merge(ntryL,G1H4(49),[G1H4(75)])
  call ol_merge(ntryL,G1H4(50),[G1H4(81)])
  call ol_merge(ntryL,G1H4(54),[G1H4(87)])
  call ol_merge(ntryL,G1H4(55),[G1H4(93)])
  call ol_merge(ntryL,G1H4(60),[G1H4(99)])
  call ol_merge(ntryL,G1H4(61),[G1H4(105)])
  call ol_merge(ntryL,G1H4(65),[G1H4(111)])
  call ol_merge(ntryL,G1H4(67),[G1H4(117)])
  call ol_merge(ntryL,G2H4(52),[G2H4(47),G2H4(15),G2H4(2)])
  call ol_merge(ntryL,G2H4(10),[G2H4(9),G2H4(4),G2H4(3)])
  call ol_merge(ntryL,G2H4(18),[G2H4(14)])
  call ol_merge(ntryL,G1H4(35),[G1H4(32)])
  call ol_merge(ntryL,G1H4(48),[G1H4(37)])
  call ol_merge(ntryL,G1H4(91),[G1H4(80)])
  call ol_merge(ntryL,G1H4(109),[G1H4(102)])
  call ol_merge(ntryL,G1H4(121),[G1H4(115)])
  call ol_merge(ntryL,G1H4(128),[G1H4(125)])
  call ol_merge(ntryL,G1H4(139),[G1H4(134)])
  call ol_merge(ntryL,G1H4(7),[G1H4(143)])
  call Hloop_SQ_A(ntryL,G1H4(71),ex3(:),G1H2(25),ngH,m3h2x2(:,133),heltab2x4(:,:,133))
  call Hloop_Q_A(ntryL,G1H2(25),23,nMB,G2H2(40),n2h2(73))
  call Hloop_SQ_A(ntryL,G1H4(64),ex3(:),G1H2(26),ngH,m3h2x2(:,134),heltab2x4(:,:,134))
  call Hloop_Q_A(ntryL,G1H2(26),23,nMB,G2H2(42),n2h2(74))
  call Hloop_SQ_A(ntryL,G1H4(72),ex3(:),G1H2(30),ngX,m3h2x2(:,135),heltab2x4(:,:,135))
  call Hloop_Q_A(ntryL,G1H2(30),23,nMB,G2H2(49),n2h2(75))
  call Hloop_SQ_A(ntryL,G1H4(70),ex3(:),G1H2(31),ngX,m3h2x2(:,136),heltab2x4(:,:,136))
  call Hloop_Q_A(ntryL,G1H2(31),23,nMB,G2H2(51),n2h2(76))
  call Hloop_VQ_A(ntryL,G1H4(77),ex3(:),G1H2(32),m3h2x2(:,137),heltab2x4(:,:,137))
  call Hloop_Q_A(ntryL,G1H2(32),23,nMB,G2H2(58),n2h2(77))
call Hotf_4pt_reduction(G2H4(13),RedSet_4(2),mass4set(:,1),  & 
G1H4(19),G1H4(20),G1H4(23),G1H4(24),G1H4(25),4)
call HG1shiftOLR(G1H4(20),8,4)
  call Hloop_ZQ_A(ntryL,G1H4(78),ex3(:),G1H2(36),ngZd,m3h2x2(:,138),heltab2x4(:,:,138))
  call Hloop_Q_A(ntryL,G1H2(36),23,nMB,G2H2(60),n2h2(78))
  call Hloop_ZQ_A(ntryL,G1H4(82),ex3(:),G1H2(37),ngZd,m3h2x2(:,139),heltab2x4(:,:,139))
  call Hloop_Q_A(ntryL,G1H2(37),23,nMB,G2H2(70),n2h2(79))
  call Hloop_SQ_A(ntryL,G1H4(103),ex1(:),G1H2(38),ngPbt,m3h2x2(:,140),heltab2x4(:,:,140))
  call Hloop_Q_A(ntryL,G1H2(38),23,nMB,G2H2(72),n2h2(80))
  call Hloop_SQ_A(ntryL,G1H4(112),ex1(:),G1H2(42),ngPbt,m3h2x2(:,141),heltab2x4(:,:,141))
  call Hloop_Q_A(ntryL,G1H2(42),23,nMB,G2H2(82),n2h2(81))
  call Hloop_WQ_A(ntryL,G1H4(113),ex1(:),G1H2(43),m3h2x2(:,142),heltab2x4(:,:,142))
  call Hloop_Q_A(ntryL,G1H2(43),23,nMB,G2H2(84),n2h2(82))
  call Hloop_WQ_A(ntryL,G1H4(118),ex1(:),G1H2(44),m3h2x2(:,143),heltab2x4(:,:,143))
  call Hloop_Q_A(ntryL,G1H2(44),23,nMB,G2H2(91),n2h2(83))
  call Hloop_SA_Q(ntryL,G1H4(84),ex4(:),G1H2(48),ngH,m3h2x2(:,144),heltab2x4(:,:,144))
  call Hloop_A_Q(ntryL,G1H2(48),27,nMB,G2H2(93),n2h2(84))
  call Hloop_SA_Q(ntryL,G1H4(88),ex4(:),G1H2(49),ngH,m3h2x2(:,145),heltab2x4(:,:,145))
  call Hloop_A_Q(ntryL,G1H2(49),27,nMB,G2H2(97),n2h2(85))
  call Hloop_SA_Q(ntryL,G1H4(85),ex4(:),G1H2(50),ngX,m3h2x2(:,146),heltab2x4(:,:,146))
  call Hloop_A_Q(ntryL,G1H2(50),27,nMB,G2H2(99),n2h2(86))
  call Hloop_SA_Q(ntryL,G1H4(94),ex4(:),G1H2(54),ngX,m3h2x2(:,147),heltab2x4(:,:,147))
  call Hloop_A_Q(ntryL,G1H2(54),27,nMB,G2H2(103),n2h2(87))
  call Hloop_VA_Q(ntryL,G1H4(92),ex4(:),G1H2(55),m3h2x2(:,148),heltab2x4(:,:,148))
  call Hloop_A_Q(ntryL,G1H2(55),27,nMB,G2H2(105),n2h2(88))
call Hotf_4pt_reduction(G2H4(6),RedSet_4(12),mass4set(:,1),  & 
G1H4(26),G1H4(29),G1H4(30),G1H4(3),G1H4(4),4)
call HG1shiftOLR(G1H4(29),4,4)
  call Hloop_ZA_Q(ntryL,G1H4(95),ex4(:),G1H2(56),ngZd,m3h2x2(:,149),heltab2x4(:,:,149))
  call Hloop_A_Q(ntryL,G1H2(56),27,nMB,G2H2(1),n2h2(89))
  call Hloop_ZA_Q(ntryL,G1H4(106),ex4(:),G1H2(60),ngZd,m3h2x2(:,150),heltab2x4(:,:,150))
  call Hloop_A_Q(ntryL,G1H2(60),27,nMB,G2H2(2),n2h2(90))
  call Hloop_SQ_A(ntryL,G1H4(41),ex3(:),G1H2(61),ngH,m3h2x2(:,151),heltab2x4(:,:,151))
  call Hloop_Q_A(ntryL,G1H2(61),23,nMB,G2H2(3),n2h2(91))
  call Hloop_SQ_A(ntryL,G1H4(42),ex3(:),G1H2(62),ngX,m3h2x2(:,152),heltab2x4(:,:,152))
  call Hloop_Q_A(ntryL,G1H2(62),23,nMB,G2H2(4),n2h2(92))
  call Hloop_VQ_A(ntryL,G1H4(49),ex3(:),G1H2(66),m3h2x2(:,153),heltab2x4(:,:,153))
  call Hloop_Q_A(ntryL,G1H2(66),23,nMB,G2H2(5),n2h2(93))
  call Hloop_ZQ_A(ntryL,G1H4(50),ex3(:),G1H2(67),ngZd,m3h2x2(:,154),heltab2x4(:,:,154))
  call Hloop_Q_A(ntryL,G1H2(67),23,nMB,G2H2(6),n2h2(94))
  call Hloop_SA_Q(ntryL,G1H4(54),ex4(:),G1H2(68),ngH,m3h2x2(:,155),heltab2x4(:,:,155))
  call Hloop_A_Q(ntryL,G1H2(68),27,nMB,G2H2(7),n2h2(95))
  call Hloop_SA_Q(ntryL,G1H4(55),ex4(:),G1H2(72),ngX,m3h2x2(:,156),heltab2x4(:,:,156))



end subroutine vamp_1

end module ol_vamp_1_ppttj_ew_ttxbbxg_1_/**/REALKIND
