
module ol_colourmatrix_ppttj_ew_ttxggg_1_/**/REALKIND
  use KIND_TYPES, only: REALKIND
  implicit none
  logical, save           :: colmat_not_initialised = .true.
  complex(REALKIND), save :: K1(102,6), K2(6,11), KL(6,11)
  contains
  subroutine colourmatrix_init
    use ol_parameters_decl_/**/REALKIND, only: CI
    implicit none
    colmat_not_initialised = .false.
    ! colour matrix

  K1(  1,:) = [ 64, -8, -8,  1,  1, 10]
  K1(  2,:) = [ -8, 64,  1, 10, -8,  1]
  K1(  3,:) = [ -8,  1, 64, -8, 10,  1]
  K1(  4,:) = [  1, 10, -8, 64,  1, -8]
  K1(  5,:) = [  1, -8, 10,  1, 64, -8]
  K1(  6,:) = [ 10,  1,  1, -8, -8, 64]
  K1(  7,:) = [  0,  0,  0,  0,  0,  0]
  K1(  8,:) = [  0,  0,  0,  0,  0,  0]
  K1(  9,:) = [  0,  0,  0,  0,  0,  0]
  K1( 10,:) = [  0,  0,  0,  0,  0,  0]
  K1( 11,:) = [  0,  0,  0,  0,  0,  0]
  K1( 12,:) = [  0,  0,  0,  0,  0,  0]
  K1( 13,:) = [  0,  0,  0,  0,  0,  0]
  K1( 14,:) = [  0,  0,  0,  0,  0,  0]
  K1( 15,:) = [  0,  0,  0,  0,  0,  0]
  K1( 16,:) = [  0,  0,  0,  0,  0,  0]
  K1( 17,:) = [  0,  0,  0,  0,  0,  0]
  K1( 18,:) = [  0,  0,  0,  0,  0,  0]
  K1( 19,:) = [  0,  0,  0,  0,  0,  0]
  K1( 20,:) = [  0,  0,  0,  0,  0,  0]
  K1( 21,:) = [  0,  0,  0,  0,  0,  0]
  K1( 22,:) = [  0,  0,  0,  0,  0,  0]
  K1( 23,:) = [  0,  0,  0,  0,  0,  0]
  K1( 24,:) = [  0,  0,  0,  0,  0,  0]
  K1( 25,:) = [  0,  0,  0,  0,  0,  0]
  K1( 26,:) = [  0,  0,  0,  0,  0,  0]
  K1( 27,:) = [  0,  0,  0,  0,  0,  0]
  K1( 28,:) = [  0,  0,  0,  0,  0,  0]
  K1( 29,:) = [  0,  0,  0,  0,  0,  0]
  K1( 30,:) = [  0,  0,  0,  0,  0,  0]
  K1( 31,:) = [  0,  0,  0,  0,  0,  0]
  K1( 32,:) = [  0,  0,  0,  0,  0,  0]
  K1( 33,:) = [  0,  0,  0,  0,  0,  0]
  K1( 34,:) = [  0,  0,  0,  0,  0,  0]
  K1( 35,:) = [  0,  0,  0,  0,  0,  0]
  K1( 36,:) = [  0,  0,  0,  0,  0,  0]
  K1( 37,:) = [  0,  0,  0,  0,  0,  0]
  K1( 38,:) = [  0,  0,  0,  0,  0,  0]
  K1( 39,:) = [  0,  0,  0,  0,  0,  0]
  K1( 40,:) = [  0,  0,  0,  0,  0,  0]
  K1( 41,:) = [  0,  0,  0,  0,  0,  0]
  K1( 42,:) = [  0,  0,  0,  0,  0,  0]
  K1( 43,:) = [  0,  0,  0,  0,  0,  0]
  K1( 44,:) = [  0,  0,  0,  0,  0,  0]
  K1( 45,:) = [  0,  0,  0,  0,  0,  0]
  K1( 46,:) = [  0,  0,  0,  0,  0,  0]
  K1( 47,:) = [  0,  0,  0,  0,  0,  0]
  K1( 48,:) = [  0,  0,  0,  0,  0,  0]
  K1( 49,:) = [  0,  0,  0,  0,  0,  0]
  K1( 50,:) = [  0,  0,  0,  0,  0,  0]
  K1( 51,:) = [  0,  0,  0,  0,  0,  0]
  K1( 52,:) = [  0,  0,  0,  0,  0,  0]
  K1( 53,:) = [  0,  0,  0,  0,  0,  0]
  K1( 54,:) = [  0,  0,  0,  0,  0,  0]
  K1( 55,:) = [  0,  0,  0,  0,  0,  0]
  K1( 56,:) = [  0,  0,  0,  0,  0,  0]
  K1( 57,:) = [  0,  0,  0,  0,  0,  0]
  K1( 58,:) = [  0,  0,  0,  0,  0,  0]
  K1( 59,:) = [  0,  0,  0,  0,  0,  0]
  K1( 60,:) = [  0,  0,  0,  0,  0,  0]
  K1( 61,:) = [  0,  0,  0,  0,  0,  0]
  K1( 62,:) = [  0,  0,  0,  0,  0,  0]
  K1( 63,:) = [  0,  0,  0,  0,  0,  0]
  K1( 64,:) = [  0,  0,  0,  0,  0,  0]
  K1( 65,:) = [  0,  0,  0,  0,  0,  0]
  K1( 66,:) = [  0,  0,  0,  0,  0,  0]
  K1( 67,:) = [  0,  0,  0,  0,  0,  0]
  K1( 68,:) = [  0,  0,  0,  0,  0,  0]
  K1( 69,:) = [  0,  0,  0,  0,  0,  0]
  K1( 70,:) = [  0,  0,  0,  0,  0,  0]
  K1( 71,:) = [  0,  0,  0,  0,  0,  0]
  K1( 72,:) = [  0,  0,  0,  0,  0,  0]
  K1( 73,:) = [  0,  0,  0,  0,  0,  0]
  K1( 74,:) = [  0,  0,  0,  0,  0,  0]
  K1( 75,:) = [  0,  0,  0,  0,  0,  0]
  K1( 76,:) = [  0,  0,  0,  0,  0,  0]
  K1( 77,:) = [  0,  0,  0,  0,  0,  0]
  K1( 78,:) = [  0,  0,  0,  0,  0,  0]
  K1( 79,:) = [  0,  0,  0,  0,  0,  0]
  K1( 80,:) = [  0,  0,  0,  0,  0,  0]
  K1( 81,:) = [  0,  0,  0,  0,  0,  0]
  K1( 82,:) = [  0,  0,  0,  0,  0,  0]
  K1( 83,:) = [  0,  0,  0,  0,  0,  0]
  K1( 84,:) = [  0,  0,  0,  0,  0,  0]
  K1( 85,:) = [  0,  0,  0,  0,  0,  0]
  K1( 86,:) = [  0,  0,  0,  0,  0,  0]
  K1( 87,:) = [  0,  0,  0,  0,  0,  0]
  K1( 88,:) = [  0,  0,  0,  0,  0,  0]
  K1( 89,:) = [  0,  0,  0,  0,  0,  0]
  K1( 90,:) = [  0,  0,  0,  0,  0,  0]
  K1( 91,:) = [  0,  0,  0,  0,  0,  0]
  K1( 92,:) = [  0,  0,  0,  0,  0,  0]
  K1( 93,:) = [  0,  0,  0,  0,  0,  0]
  K1( 94,:) = [  0,  0,  0,  0,  0,  0]
  K1( 95,:) = [  0,  0,  0,  0,  0,  0]
  K1( 96,:) = [  0,  0,  0,  0,  0,  0]
  K1( 97,:) = [ 64, -8, -8,  1,  1, 10]
  K1( 98,:) = [ -8, 64,  1, 10, -8,  1]
  K1( 99,:) = [ -8,  1, 64, -8, 10,  1]
  K1(100,:) = [  1, 10, -8, 64,  1, -8]
  K1(101,:) = [  1, -8, 10,  1, 64, -8]
  K1(102,:) = [ 10,  1,  1, -8, -8, 64]
  K1 = (1._/**/REALKIND / 9) * K1

  K2(1,:) = [ 64, -8, -8,  1,  1, 10, 24, -3, 24, 21, -6]
  K2(2,:) = [ -8, 64,  1, 10, -8,  1, -3, 24, 24, -6, 21]
  K2(3,:) = [ -8,  1, 64, -8, 10,  1, 24, 24, -3, -6, 21]
  K2(4,:) = [  1, 10, -8, 64,  1, -8, -3, 24, 24, 21, -6]
  K2(5,:) = [  1, -8, 10,  1, 64, -8, 24, 24, -3, 21, -6]
  K2(6,:) = [ 10,  1,  1, -8, -8, 64, 24, -3, 24, -6, 21]
  K2 = (1._/**/REALKIND / 9) * K2

  KL(1,:) = [ 64, -8, -8,  1,  1, 10, 24, -3, 24, 21, -6]
  KL(2,:) = [ -8, 64,  1, 10, -8,  1, -3, 24, 24, -6, 21]
  KL(3,:) = [ -8,  1, 64, -8, 10,  1, 24, 24, -3, -6, 21]
  KL(4,:) = [  1, 10, -8, 64,  1, -8, -3, 24, 24, 21, -6]
  KL(5,:) = [  1, -8, 10,  1, 64, -8, 24, 24, -3, 21, -6]
  KL(6,:) = [ 10,  1,  1, -8, -8, 64, 24, -3, 24, -6, 21]
  KL = (1._/**/REALKIND / 9) * KL

  end subroutine colourmatrix_init
end module ol_colourmatrix_ppttj_ew_ttxggg_1_/**/REALKIND



module ol_forced_parameters_ppttj_ew_ttxggg_1_/**/REALKIND
  implicit none
  contains
  subroutine check_forced_parameters
    use ol_parameters_decl_/**/REALKIND
    use ol_loop_parameters_decl_/**/REALKIND
#ifndef PRECISION_dp
    use ol_loop_parameters_decl_/**/DREALKIND, only: LeadingColour, nc, nf, CKMORDER
#endif
    implicit none
    logical, save :: checks_not_written = .true.

    if (checks_not_written) then
    ! e.g.
    ! if (ME /= 0) write(*,101) 'ME = 0'
  if (CKMORDER /= 0) write(*,101) 'CKMORDER = 0'
  if (nc /= 3) write(*,101) 'nc = 3'
  if (nf /= 6) write(*,101) 'nf = 6'
  if (MU /= 0) write(*,101) 'MU = 0'
  if (MD /= 0) write(*,101) 'MD = 0'
  if (MS /= 0) write(*,101) 'MS = 0'
  if (MC /= 0) write(*,101) 'MC = 0'
  if (LeadingColour /= 0) write(*,101) 'LeadingColour = 0'
  if (wMT /= 0) write(*,101) 'wMT = 0'
  if (wMT /= 0) write(*,101) 'wMT = 0'


    checks_not_written = .false.
    end if

    101 format('[OpenLoops] === WARNING ===',/,'[OpenLoops] code was generated with ',A,/,'[OpenLoops] ===============')
  end subroutine check_forced_parameters
end module ol_forced_parameters_ppttj_ew_ttxggg_1_/**/REALKIND
! **********************************************************************
module ol_loop_storage_ppttj_ew_ttxggg_1_/**/REALKIND
! **********************************************************************
  use KIND_TYPES, only: REALKIND, intkind1, intkind2  
  use ol_data_types_/**/REALKIND, only: wfun, Hpolcont
  
#ifdef PRECISION_dp
  integer(intkind1), save :: ntry = 1, ntryL = 1
  integer(intkind1), save :: p_switch = 0 ! switch for dp or qp. Used for memory allocation of the OL types 
  ! the following are flags for memory allocation of the hol coefficients in dp or qp 
  logical, save :: dp_not_alloc = .TRUE., qp_not_alloc = .TRUE.
  integer(intkind2), parameter :: nheltot = 32 ! number of helicity configurations
  integer(intkind2), save :: nhel = 32 ! number of non-vanishing helicity configurations (adapted at runtime)
  integer(intkind2), save :: Hel(32) ! physical helicity states
#endif

  complex(REALKIND), save :: den(124)

  ! external wave functions ex1(h1),... for h<n> helicities
  type(wfun) :: ex1(2), ex2(2), ex3(2), ex4(2), ex5(2)

  ! wf<h>(h,n) n wave functions with h helicity configurations
  type(wfun) :: wf4(4,44), wf8(8,106), wf32(32,94)

  ! diagram prefactors
  integer,           save :: fac_status_loop1 = -1, fac_status_loop2 = -1
  complex(REALKIND), save :: f(33), c(24)

  !Vector in helicity and colour space for Born-Loop interference
  type(Hpolcont),   save :: M0_col1_helarray(11,32)

end module ol_loop_storage_ppttj_ew_ttxggg_1_/**/REALKIND






! **********************************************************************
module ol_loop_ppttj_ew_ttxggg_1_/**/REALKIND
! **********************************************************************
  use KIND_TYPES, only: REALKIND, DREALKIND, intkind1, intkind2  
  use ol_data_types_/**/REALKIND, only: wfun, Hpolcont
  use ol_loop_storage_ppttj_ew_ttxggg_1_/**/REALKIND
  implicit none

!*********************************************************************************
  contains

! **********************************************************************
subroutine fac_init_loop()
! Writes diagram prefactors to 'f', rsp. 'c'
! **********************************************************************
  use ol_parameters_decl_/**/REALKIND
  use ol_loop_parameters_decl_/**/REALKIND
  use ol_init, only: set_parameter, tree_parameters_flush, parameters_flush
#ifndef PRECISION_dp
  use ol_loop_parameters_decl_/**/DREALKIND, only: SwF, SwB
!  use ol_loop_parameters_decl_/**/DREALKIND, only: DOI
#endif
  implicit none
  call set_parameter("ew_renorm", 1)
  if (parameters_status == 0) call tree_parameters_flush()
  if (loop_parameters_status == 0) call parameters_flush()
  fac_status_loop1 = parameters_status
  fac_status_loop2 = loop_parameters_status
  ! factors of the diagrams
    f( 1) = CI*gQCD**3
    f( 2) = gQCD**3
    f( 3) = (2*CI*countertermnorm*eQED**2*gQCD**3)/3._/**/REALKIND
    f( 4) = CI*countertermnorm*eQED**2*gQCD**3
    f( 5) = countertermnorm*eQED**2*gQCD**3
    f( 6) = CI*countertermnorm*ctZGG*eQED**2*gQCD**3
    f( 7) = countertermnorm*ctZGG*eQED**2*gQCD**3
    f( 8) = (CI*countertermnorm*ctHGG*eQED**2*gQCD**3*MT)/(2._/**/REALKIND*MW*sw)
    f( 9) = (countertermnorm*ctHGG*eQED**2*gQCD**3*MT)/(MW*sw*2._/**/REALKIND)
    f(10) = (4*CI*eQED**2*gQCD**3*integralnorm*SwB)/9._/**/REALKIND
    f(11) = CI*eQED**2*gQCD**3*integralnorm*SwB
    f(12) = (4*eQED**2*gQCD**3*integralnorm*SwB)/9._/**/REALKIND
    f(13) = eQED**2*gQCD**3*integralnorm*SwB
    f(14) = (CI*eQED**2*gQCD**3*integralnorm*SwB)/(2._/**/REALKIND*sw**2)
    f(15) = (eQED**2*gQCD**3*integralnorm*SwB)/(sw**2*2._/**/REALKIND)
    f(16) = (CI*eQED**2*gQCD**3*integralnorm*SwB)/(2._/**/REALKIND*MW**2*sw**2)
    f(17) = (eQED**2*gQCD**3*integralnorm*SwB)/(MW**2*sw**2*2._/**/REALKIND)
    f(18) = (CI*eQED**2*gQCD**3*integralnorm*MT**2*SwB)/(4._/**/REALKIND*MW**2*sw**2)
    f(19) = (eQED**2*gQCD**3*integralnorm*MT**2*SwB)/(MW**2*sw**2*4._/**/REALKIND)
    f(20) = (2*CI*eQED**2*gQCD**3*integralnorm*SwF)/9._/**/REALKIND
    f(21) = (4*CI*eQED**2*gQCD**3*integralnorm*SwF)/9._/**/REALKIND
    f(22) = (8*CI*eQED**2*gQCD**3*integralnorm*SwF)/9._/**/REALKIND
    f(23) = CI*eQED**2*gQCD**3*integralnorm*SwF
    f(24) = 2*CI*eQED**2*gQCD**3*integralnorm*SwF
    f(25) = (2*eQED**2*gQCD**3*integralnorm*SwF)/9._/**/REALKIND
    f(26) = (4*eQED**2*gQCD**3*integralnorm*SwF)/9._/**/REALKIND
    f(27) = (8*eQED**2*gQCD**3*integralnorm*SwF)/9._/**/REALKIND
    f(28) = eQED**2*gQCD**3*integralnorm*SwF
    f(29) = 2*eQED**2*gQCD**3*integralnorm*SwF
    f(30) = (CI*eQED**2*gQCD**3*integralnorm*MB*MT*SwF)/(4._/**/REALKIND*MW**2*sw**2)
    f(31) = (eQED**2*gQCD**3*integralnorm*MB*MT*SwF)/(MW**2*sw**2*4._/**/REALKIND)
    f(32) = (CI*eQED**2*gQCD**3*integralnorm*MT**2*SwF)/(4._/**/REALKIND*MW**2*sw**2)
    f(33) = (eQED**2*gQCD**3*integralnorm*MT**2*SwF)/(MW**2*sw**2*4._/**/REALKIND)

  c = [ CI*f(10), CI*f(11), f(12), f(13), CI*f(14), f(15), CI*f(16), f(17), CI*f(18), f(19), CI*f(20), CI*f(21), CI*f(22) &
    , CI*f(23), CI*f(24), f(25), f(26), f(27), f(28), f(29), CI*f(30), f(31), CI*f(32), f(33) ]
end subroutine fac_init_loop

subroutine denominators()
  use ol_parameters_decl_/**/REALKIND ! masses
  use ol_momenta_decl_/**/REALKIND, only: L
  implicit none
  ! propagators
  den(1) = 1 /((L(5,3))+L(6,3))
  den(2) = 1 /((L(5,12))+L(6,12))
  den(4) = 1 /((L(5,20))+L(6,20))
  den(6) = 1 /((L(5,24))+L(6,24))
  den(8) = 1 /((L(5,5) - MT2)+L(6,5))
  den(9) = 1 /((L(5,10) - MT2)+L(6,10))
  den(11) = 1 /((L(5,18) - MT2)+L(6,18))
  den(14) = 1 /((L(5,9) - MT2)+L(6,9))
  den(15) = 1 /((L(5,6) - MT2)+L(6,6))
  den(17) = 1 /((L(5,17) - MT2)+L(6,17))
  den(26) = 1 /((L(5,3) - MZ2)+L(6,3))
  den(27) = 1 /((L(5,28))+L(6,28))
  den(28) = 1 /((L(5,3) - MH2)+L(6,3))
  den(35) = 1 /((L(5,24) - MH2)+L(6,24))
  den(37) = 1 /((L(5,24) - MZ2)+L(6,24))
  den(41) = 1 /((L(5,20) - MH2)+L(6,20))
  den(43) = 1 /((L(5,20) - MZ2)+L(6,20))
  den(47) = 1 /((L(5,12) - MH2)+L(6,12))
  den(49) = 1 /((L(5,12) - MZ2)+L(6,12))
  den(53) = 1 /((L(5,26) - MT2)+L(6,26))
  den(56) = 1 /((L(5,21) - MT2)+L(6,21))
  den(61) = 1 /((L(5,13) - MT2)+L(6,13))
  den(66) = 1 /((L(5,22) - MT2)+L(6,22))
  den(69) = 1 /((L(5,25) - MT2)+L(6,25))
  den(72) = 1 /((L(5,14) - MT2)+L(6,14))
  den(95) = 1 /((L(5,7) - MH2)+L(6,7))
  den(97) = 1 /((L(5,7) - MZ2)+L(6,7))
  den(99) = 1 /((L(5,7))+L(6,7))
  den(104) = 1 /((L(5,11) - MH2)+L(6,11))
  den(106) = 1 /((L(5,11) - MZ2)+L(6,11))
  den(108) = 1 /((L(5,11))+L(6,11))
  den(114) = 1 /((L(5,19) - MH2)+L(6,19))
  den(116) = 1 /((L(5,19) - MZ2)+L(6,19))
  den(118) = 1 /((L(5,19))+L(6,19))

  ! denominators
  den(3) = den(1)*den(2)
  den(5) = den(1)*den(4)
  den(7) = den(1)*den(6)
  den(10) = den(8)*den(9)
  den(12) = den(8)*den(11)
  den(13) = den(6)*den(8)
  den(16) = den(14)*den(15)
  den(18) = den(15)*den(17)
  den(19) = den(6)*den(15)
  den(20) = den(11)*den(14)
  den(21) = den(4)*den(14)
  den(22) = den(9)*den(17)
  den(23) = den(4)*den(9)
  den(24) = den(2)*den(17)
  den(25) = den(2)*den(11)
  den(29) = den(2)*den(28)
  den(30) = den(2)*den(26)
  den(31) = den(4)*den(28)
  den(32) = den(4)*den(26)
  den(33) = den(6)*den(28)
  den(34) = den(6)*den(26)
  den(36) = den(8)*den(35)
  den(38) = den(8)*den(37)
  den(39) = den(15)*den(35)
  den(40) = den(15)*den(37)
  den(42) = den(14)*den(41)
  den(44) = den(14)*den(43)
  den(45) = den(9)*den(41)
  den(46) = den(9)*den(43)
  den(48) = den(17)*den(47)
  den(50) = den(17)*den(49)
  den(51) = den(11)*den(47)
  den(52) = den(11)*den(49)
  den(54) = den(9)*den(53)
  den(55) = den(8)*den(54)
  den(57) = den(8)*den(56)
  den(58) = den(9)*den(57)
  den(59) = den(11)*den(53)
  den(60) = den(8)*den(59)
  den(62) = den(8)*den(61)
  den(63) = den(11)*den(62)
  den(64) = den(6)*den(53)
  den(65) = den(8)*den(64)
  den(67) = den(15)*den(66)
  den(68) = den(14)*den(67)
  den(70) = den(14)*den(69)
  den(71) = den(15)*den(70)
  den(73) = den(15)*den(72)
  den(74) = den(17)*den(73)
  den(75) = den(17)*den(69)
  den(76) = den(15)*den(75)
  den(77) = den(6)*den(69)
  den(78) = den(15)*den(77)
  den(79) = den(11)*den(66)
  den(80) = den(14)*den(79)
  den(81) = den(14)*den(61)
  den(82) = den(11)*den(81)
  den(83) = den(4)*den(66)
  den(84) = den(14)*den(83)
  den(85) = den(9)*den(72)
  den(86) = den(17)*den(85)
  den(87) = den(17)*den(56)
  den(88) = den(9)*den(87)
  den(89) = den(4)*den(56)
  den(90) = den(9)*den(89)
  den(91) = den(2)*den(72)
  den(92) = den(17)*den(91)
  den(93) = den(2)*den(61)
  den(94) = den(11)*den(93)
  den(96) = den(8)*den(95)
  den(98) = den(8)*den(97)
  den(100) = den(8)*den(99)
  den(101) = den(15)*den(95)
  den(102) = den(15)*den(97)
  den(103) = den(15)*den(99)
  den(105) = den(14)*den(104)
  den(107) = den(14)*den(106)
  den(109) = den(14)*den(108)
  den(110) = den(9)*den(104)
  den(111) = den(9)*den(106)
  den(112) = den(9)*den(108)
  den(113) = den(2)*den(27)
  den(115) = den(17)*den(114)
  den(117) = den(17)*den(116)
  den(119) = den(17)*den(118)
  den(120) = den(11)*den(114)
  den(121) = den(11)*den(116)
  den(122) = den(11)*den(118)
  den(123) = den(4)*den(27)
  den(124) = den(6)*den(27)

end subroutine denominators

!
!
!
!
!
! **********************************************************************
#ifdef PRECISION_dp
subroutine amp2(P_scatt, M02, M2ct, M2colint, qp_kinematics)
#else
subroutine amp2(P_scatt, M02, M2ct, M2colint, qp_kinematics)
  use ol_loop_storage_ppttj_ew_ttxggg_1_/**/DREALKIND, only: ntry, nhel, Hel
#endif
! P_scatt(0:3,Npart) = incoming external momenta
! M2  = helicity-summed squared matrix element for top anti-top glue glue glue -> 0
! **********************************************************************
  use ol_parameters_decl_/**/REALKIND !, only: ci, parameters_status, ZERO, scalefactor, >masses<
  use ol_parameters_init_/**/REALKIND, only: ensure_mp_init
  use ol_kinematics_/**/REALKIND, only: init_kinematics
  use ol_momenta_decl_/**/DREALKIND, only: momenta_nan_check
  use ol_data_types_/**/REALKIND
  use ol_h_helicity_bookkeeping_/**/REALKIND, only: &
    & helbookkeeping_wf, helsync, flip_phase
  use ol_helicity_init, only: helbookkeeping_flip, helsync_flip
  use ol_hel_propagators_/**/REALKIND
  use ol_hel_wavefunctions_/**/REALKIND
  use ol_wavefunctions_/**/REALKIND, only: wf_V_Std
  use ol_hel_vertices_/**/REALKIND
  use ol_hel_contractions_/**/REALKIND
  use ol_external_ppttj_ew_ttxggg_1, only: external_perm_ppttj_ew_ttxggg_1, &
    & external_perm_inv_ppttj_ew_ttxggg_1, extcomb_perm_ppttj_ew_ttxggg_1, &
    & average_factor_ppttj_ew_ttxggg_1
  use ol_external_ppttj_ew_ttxggg_1, only: H, hel_not_initialised, hel_init, POLSEL
  use ol_colourmatrix_ppttj_ew_ttxggg_1_/**/REALKIND, only: colmat_not_initialised, colourmatrix_init
  use ol_forced_parameters_ppttj_ew_ttxggg_1_/**/REALKIND, only: check_forced_parameters
  use ol_heltables_OLR_ppttj_ew_ttxggg_1
  use ol_kinematics_/**/REALKIND, only: LC2Std_Rep_cmplx
  use ol_h_counterterms_/**/REALKIND
  use ol_loop_parameters_decl_/**/REALKIND ! counterterms
  use ol_loop_parameters_decl_/**/DREALKIND, only: IR_is_on
  use ol_init, only: set_parameter, parameters_flush
#ifdef PRECISION_dp
  use ol_kinematics_/**/QREALKIND, only: conv_mom_scatt2in_qp=>conv_mom_scatt2in, &
                                         internal_momenta_qp=>internal_momenta
  use ol_momenta_decl_/**/DREALKIND, only: L
  use ol_momenta_decl_/**/QREALKIND, only: L_qp=>L
#endif
  implicit none

  real(DREALKIND), intent(in)  :: P_scatt(0:3,5)
  real(REALKIND),  intent(out) :: M02, M2ct, M2colint(16)
  logical, intent(in) :: qp_kinematics

  integer           :: shift, k, r, m, n
  real(REALKIND)    :: P(0:3,5)
#ifdef PRECISION_dp
  real(QREALKIND)    :: P_qp(0:3,5)
#endif
  integer           :: extmasses2(5)
  real(REALKIND)    :: M2add, M2add_ct, M2add_colint(16)
  complex(REALKIND) :: M1(6), M2(11) 
  real(REALKIND)    :: P_scatt_intern(0:3,5)
  real(REALKIND), save :: scalebackfactor, old_scalefactor = 0
  integer(intkind1) :: nsync
  type(Hpolcont),   save :: M1helarray(6,32)
  type(Hpolcont) :: M1helarray_ct(11,32)

  type(Hpolcont) :: A(32,94)

  !Aj are not used at the moment
  !complex(REALKIND) :: Aj(94)

  complex(REALKIND) :: omega(2) ! phases for helicity correlations

  call set_parameter("ew_renorm", 1)
  call parameters_flush()
  call ensure_mp_init()

  if (colmat_not_initialised) call colourmatrix_init()

  if (fac_status_loop1 /= parameters_status .or. fac_status_loop2 /= loop_parameters_status) then
    ! Note: if fac_init would only be called when parameters changed which are relevant for the factors,
    ! a different 'status' would have to be used, because forced_parameters should be called after every parameter change.
    call check_forced_parameters()
    call fac_init_loop()
  end if

  if (momenta_nan_check(P_scatt) /= 0) then
    M02 = 0
    return
  end if

  extmasses2 = [ nMT, nMT, 0, 0, 0 ]
  ! Convert 2 -> n-2 PS-point to n -> 0 (so that P(1) + ... + P(n) = 0) and compute
  ! internal-propagator momenta in light-cone representation
  call init_kinematics(P_scatt, extmasses2, P, external_perm_inv_ppttj_ew_ttxggg_1, 5, qp_kinematics)

  ! denominators
  call denominators()

   if (heltables_not_init) call init_heltables()

  ! external WFs
  ! Here the external wavefunctions are initialiased
  call pol_wf_Q(P(:,1), rMT, H1, ex1, POLSEL(1),1)
  call pol_wf_A(P(:,2), rMT, H2, ex2, POLSEL(2),2)
  call pol_wf_V(P(:,3), rZERO, H3, ex3, POLSEL(3),3)
  call pol_wf_V(P(:,4), rZERO, H4, ex4, POLSEL(4),4)
  call pol_wf_V(P(:,5), rZERO, H5, ex5, POLSEL(5),5)



  ! internal WFs
  ! e.g. call vert_VQ_A(ntry, ex3, ex1, wf1, n1, t1) ...
  call vert_QA_V(ntry, ex1(:), ex2(:), wf4(:,1), n3(:,1), t3x4(:,:,1))
  call vert_GGG_G(ntry, ex3(:), ex4(:), ex5(:), wf8(:,1), n4(:,1), t4x8(:,:,1))
  call vert_GGG_G(ntry, ex4(:), ex5(:), ex3(:), wf8(:,2), n4(:,2), t4x8(:,:,2))
  call vert_GGG_G(ntry, ex5(:), ex3(:), ex4(:), wf8(:,3), n4(:,3), t4x8(:,:,3))
  call vert_UV_W(ntry, ex3(:), 4, ex4(:), 8, wf4(:,2), n3(:,2), t3x4(:,:,2))
  call vert_UV_W(ntry, wf4(:,1), 3, ex5(:), 16, wf8(:,4), n3(:,3), t3x8(:,:,1))
  call vert_UV_W(ntry, ex3(:), 4, ex5(:), 16, wf4(:,3), n3(:,4), t3x4(:,:,3))
  call vert_UV_W(ntry, wf4(:,1), 3, ex4(:), 8, wf8(:,5), n3(:,5), t3x8(:,:,2))
  call vert_UV_W(ntry, ex4(:), 8, ex5(:), 16, wf4(:,4), n3(:,6), t3x4(:,:,4))
  call vert_UV_W(ntry, wf4(:,1), 3, ex3(:), 4, wf8(:,6), n3(:,7), t3x8(:,:,3))
  call vert_VQ_A(ntry, ex3(:), ex1(:), wf4(:,5), n3(:,8), t3x4(:,:,5))
  call vert_AV_Q(ntry, ex2(:), ex4(:), wf4(:,6), n3(:,9), t3x4(:,:,6))
  call prop_Q_A(ntry, wf4(:,5), 5, MT, 1_intkind1, wf4(:,7), n2(1))
  call prop_A_Q(ntry, wf4(:,6), 10, MT, 1_intkind1, wf4(:,8), n2(2))
  call vert_VQ_A(ntry, ex5(:), wf4(:,7), wf8(:,7), n3(:,10), t3x8(:,:,4))
  call vert_AV_Q(ntry, ex2(:), ex5(:), wf4(:,9), n3(:,11), t3x4(:,:,7))
  call prop_A_Q(ntry, wf4(:,9), 18, MT, 1_intkind1, wf4(:,10), n2(3))
  call vert_VQ_A(ntry, ex4(:), wf4(:,7), wf8(:,8), n3(:,12), t3x8(:,:,5))
  call vert_QA_V(ntry, wf4(:,7), ex2(:), wf8(:,9), n3(:,13), t3x8(:,:,6))
  call vert_VQ_A(ntry, ex4(:), ex1(:), wf4(:,11), n3(:,14), t3x4(:,:,8))
  call vert_AV_Q(ntry, ex2(:), ex3(:), wf4(:,12), n3(:,15), t3x4(:,:,9))
  call prop_Q_A(ntry, wf4(:,11), 9, MT, 1_intkind1, wf4(:,13), n2(4))
  call prop_A_Q(ntry, wf4(:,12), 6, MT, 1_intkind1, wf4(:,14), n2(5))
  call vert_VQ_A(ntry, ex5(:), wf4(:,13), wf8(:,10), n3(:,16), t3x8(:,:,7))
  call vert_VQ_A(ntry, ex5(:), ex1(:), wf4(:,15), n3(:,17), t3x4(:,:,10))
  call prop_Q_A(ntry, wf4(:,15), 17, MT, 1_intkind1, wf4(:,16), n2(6))
  call vert_VQ_A(ntry, ex4(:), wf4(:,16), wf8(:,11), n3(:,18), t3x8(:,:,8))
  call vert_QA_V(ntry, ex1(:), wf4(:,14), wf8(:,12), n3(:,19), t3x8(:,:,9))
  call vert_VQ_A(ntry, ex3(:), wf4(:,13), wf8(:,13), n3(:,20), t3x8(:,:,10))
  call vert_QA_V(ntry, wf4(:,13), ex2(:), wf8(:,14), n3(:,21), t3x8(:,:,11))
  call vert_VQ_A(ntry, ex3(:), wf4(:,16), wf8(:,15), n3(:,22), t3x8(:,:,12))
  call vert_QA_V(ntry, ex1(:), wf4(:,8), wf8(:,16), n3(:,23), t3x8(:,:,13))
  call vert_QA_V(ntry, wf4(:,16), ex2(:), wf8(:,17), n3(:,24), t3x8(:,:,14))
  call vert_QA_V(ntry, ex1(:), wf4(:,10), wf8(:,18), n3(:,25), t3x8(:,:,15))
  call counter_GGG_V(ctAGGG,ntry, ex3(:), ex4(:), ex5(:), wf8(:,19), n4(:,4), t4x8(:,:,4))
  call counter_GGG_V(ctAGGG,ntry, ex3(:), ex5(:), ex4(:), wf8(:,20), n4(:,5), t4x8(:,:,5))
  call vert_QA_Z(gZu,ntry, ex1(:), ex2(:), wf4(:,17), n3(:,26), t3x4(:,:,11))
  call counter_GGG_V(ctZGGG,ntry, ex3(:), ex4(:), ex5(:), wf8(:,21), n4(:,6), t4x8(:,:,6))
  call counter_GGG_V(ctZGGG,ntry, ex3(:), ex5(:), ex4(:), wf8(:,22), n4(:,7), t4x8(:,:,7))
  call counter_QA_V_LR(EWctGtt,ntry, ex1(:), ex2(:), wf4(:,18), n3(:,27), t3x4(:,:,12))
  call vert_AQ_S(gH,ntry, ex2(:), ex1(:), wf4(:,19), n3(:,28), t3x4(:,:,13))
  call counter_SG_G(ntry, wf4(:,19), ex5(:), wf8(:,23), n3(:,29), t3x8(:,:,16))
  call counter_VG_G(ntry, wf4(:,17), ex5(:), 16, wf8(:,24), 19, n3(:,30), t3x8(:,:,17))
  call counter_SG_G(ntry, wf4(:,19), ex4(:), wf8(:,25), n3(:,31), t3x8(:,:,18))
  call counter_VG_G(ntry, wf4(:,17), ex4(:), 8, wf8(:,26), 11, n3(:,32), t3x8(:,:,19))
  call counter_SG_G(ntry, wf4(:,19), ex3(:), wf8(:,27), n3(:,33), t3x8(:,:,20))
  call counter_VG_G(ntry, wf4(:,17), ex3(:), 4, wf8(:,28), 7, n3(:,34), t3x8(:,:,21))
  call counter_VQ_A_LR(EWctGtt,ntry, ex5(:), wf4(:,7), wf8(:,29), n3(:,35), t3x8(:,:,22))
  call counter_VQ_A_LR(EWctGtt,ntry, ex4(:), wf4(:,7), wf8(:,30), n3(:,36), t3x8(:,:,23))
  call counter_GG_S(ntry, ex4(:), ex5(:), wf4(:,20), n3(:,37), t3x4(:,:,14))
  call vert_AQ_S(gH,ntry, ex2(:), wf4(:,7), wf8(:,31), n3(:,38), t3x8(:,:,24))
  call counter_GG_V(ntry, ex4(:), 8, ex5(:), 16, wf4(:,21), n3(:,39), t3x4(:,:,15))
  call vert_QA_Z(gZu,ntry, wf4(:,7), ex2(:), wf8(:,32), n3(:,40), t3x8(:,:,25))
  call counter_VQ_A_LR(EWctGtt,ntry, ex5(:), wf4(:,13), wf8(:,33), n3(:,41), t3x8(:,:,26))
  call counter_VQ_A_LR(EWctGtt,ntry, ex4(:), wf4(:,16), wf8(:,34), n3(:,42), t3x8(:,:,27))
  call vert_AQ_S(gH,ntry, wf4(:,14), ex1(:), wf8(:,35), n3(:,43), t3x8(:,:,28))
  call vert_QA_Z(gZu,ntry, ex1(:), wf4(:,14), wf8(:,36), n3(:,44), t3x8(:,:,29))
  call counter_VQ_A_LR(EWctGtt,ntry, ex3(:), wf4(:,13), wf8(:,37), n3(:,45), t3x8(:,:,30))
  call counter_GG_S(ntry, ex3(:), ex5(:), wf4(:,22), n3(:,46), t3x4(:,:,16))
  call vert_AQ_S(gH,ntry, ex2(:), wf4(:,13), wf8(:,38), n3(:,47), t3x8(:,:,31))
  call counter_GG_V(ntry, ex3(:), 4, ex5(:), 16, wf4(:,23), n3(:,48), t3x4(:,:,17))
  call vert_QA_Z(gZu,ntry, wf4(:,13), ex2(:), wf8(:,39), n3(:,49), t3x8(:,:,32))
  call counter_VQ_A_LR(EWctGtt,ntry, ex3(:), wf4(:,16), wf8(:,40), n3(:,50), t3x8(:,:,33))
  call vert_AQ_S(gH,ntry, wf4(:,8), ex1(:), wf8(:,41), n3(:,51), t3x8(:,:,34))
  call vert_QA_Z(gZu,ntry, ex1(:), wf4(:,8), wf8(:,42), n3(:,52), t3x8(:,:,35))
  call counter_GG_S(ntry, ex3(:), ex4(:), wf4(:,24), n3(:,53), t3x4(:,:,18))
  call vert_AQ_S(gH,ntry, ex2(:), wf4(:,16), wf8(:,43), n3(:,54), t3x8(:,:,36))
  call counter_GG_V(ntry, ex3(:), 4, ex4(:), 8, wf4(:,25), n3(:,55), t3x4(:,:,19))
  call vert_QA_Z(gZu,ntry, wf4(:,16), ex2(:), wf8(:,44), n3(:,56), t3x8(:,:,37))
  call vert_AQ_S(gH,ntry, wf4(:,10), ex1(:), wf8(:,45), n3(:,57), t3x8(:,:,38))
  call vert_QA_Z(gZu,ntry, ex1(:), wf4(:,10), wf8(:,46), n3(:,58), t3x8(:,:,39))
  call counter_QA_V_LR(EWctGtt,ntry, wf4(:,7), ex2(:), wf8(:,47), n3(:,59), t3x8(:,:,40))
  call counter_AV_Q_LR(EWctGtt,ntry, ex2(:), ex5(:), wf4(:,26), n3(:,60), t3x4(:,:,20))
  call prop_A_Q(ntry, wf4(:,26), 18, MT, 1_intkind1, wf4(:,27), n2(7))
  call counter_AV_Q_LR(EWctGtt,ntry, ex2(:), ex4(:), wf4(:,28), n3(:,61), t3x4(:,:,21))
  call prop_A_Q(ntry, wf4(:,28), 10, MT, 1_intkind1, wf4(:,29), n2(8))
  call counter_QA_V_LR(EWctGtt,ntry, wf4(:,13), ex2(:), wf8(:,48), n3(:,62), t3x8(:,:,41))
  call counter_QA_V_LR(EWctGtt,ntry, wf4(:,16), ex2(:), wf8(:,49), n3(:,63), t3x8(:,:,42))
  call vert_QA_V(ntry, ex1(:), wf4(:,27), wf8(:,50), n3(:,64), t3x8(:,:,43))
  call vert_QA_V(ntry, ex1(:), wf4(:,29), wf8(:,51), n3(:,65), t3x8(:,:,44))
  call counter_AV_Q_LR(EWctGtt,ntry, ex2(:), ex3(:), wf4(:,30), n3(:,66), t3x4(:,:,22))
  call prop_A_Q(ntry, wf4(:,30), 6, MT, 1_intkind1, wf4(:,31), n2(9))
  call vert_QA_V(ntry, ex1(:), wf4(:,31), wf8(:,52), n3(:,67), t3x8(:,:,45))
  call counter_QA_V_LR(EWctGtt,ntry, ex1(:), wf4(:,14), wf8(:,53), n3(:,68), t3x8(:,:,46))
  call counter_VQ_A_LR(EWctGtt,ntry, ex5(:), ex1(:), wf4(:,32), n3(:,69), t3x4(:,:,23))
  call prop_Q_A(ntry, wf4(:,32), 17, MT, 1_intkind1, wf4(:,33), n2(10))
  call vert_VQ_A(ntry, ex4(:), wf4(:,33), wf8(:,54), n3(:,70), t3x8(:,:,47))
  call counter_VQ_A_LR(EWctGtt,ntry, ex4(:), ex1(:), wf4(:,34), n3(:,71), t3x4(:,:,24))
  call prop_Q_A(ntry, wf4(:,34), 9, MT, 1_intkind1, wf4(:,35), n2(11))
  call vert_VQ_A(ntry, ex5(:), wf4(:,35), wf8(:,55), n3(:,72), t3x8(:,:,48))
  call counter_QA_V_LR(EWctGtt,ntry, ex1(:), wf4(:,8), wf8(:,56), n3(:,73), t3x8(:,:,49))
  call vert_VQ_A(ntry, ex3(:), wf4(:,33), wf8(:,57), n3(:,74), t3x8(:,:,50))
  call counter_QA_V_LR(EWctGtt,ntry, ex1(:), wf4(:,10), wf8(:,58), n3(:,75), t3x8(:,:,51))
  call vert_QA_V(ntry, wf4(:,33), ex2(:), wf8(:,59), n3(:,76), t3x8(:,:,52))
  call vert_VQ_A(ntry, ex3(:), wf4(:,35), wf8(:,60), n3(:,77), t3x8(:,:,53))
  call vert_QA_V(ntry, wf4(:,35), ex2(:), wf8(:,61), n3(:,78), t3x8(:,:,54))
  call counter_VQ_A_LR(EWctGtt,ntry, ex3(:), ex1(:), wf4(:,36), n3(:,79), t3x4(:,:,25))
  call prop_Q_A(ntry, wf4(:,36), 5, MT, 1_intkind1, wf4(:,37), n2(12))
  call vert_VQ_A(ntry, ex5(:), wf4(:,37), wf8(:,62), n3(:,80), t3x8(:,:,55))
  call vert_VQ_A(ntry, ex4(:), wf4(:,37), wf8(:,63), n3(:,81), t3x8(:,:,56))
  call vert_QA_V(ntry, wf4(:,37), ex2(:), wf8(:,64), n3(:,82), t3x8(:,:,57))
  call vert_UV_W(ntry, wf4(:,18), 3, ex5(:), 16, wf8(:,65), n3(:,83), t3x8(:,:,58))
  call vert_UV_W(ntry, wf4(:,18), 3, ex4(:), 8, wf8(:,66), n3(:,84), t3x8(:,:,59))
  call vert_UV_W(ntry, wf4(:,18), 3, ex3(:), 4, wf8(:,67), n3(:,85), t3x8(:,:,60))
  call vert_AV_Q(ntry, wf4(:,8), ex5(:), wf8(:,68), n3(:,86), t3x8(:,:,61))
  call counter_Q_A_LR(EWcttt,ntry, wf4(:,7), 5, wf4(:,38), n2(13))
  call prop_A_Q(ntry, wf8(:,68), 26, MT, 1_intkind1, wf8(:,69), n2(14))
  call counter_A_Q_LR(EWcttt,ntry, wf4(:,8), 10, wf4(:,39), n2(15))
  call prop_Q_A(ntry, wf8(:,7), 21, MT, 1_intkind1, wf8(:,70), n2(16))
  call vert_AV_Q(ntry, wf4(:,10), ex4(:), wf8(:,71), n3(:,87), t3x8(:,:,62))
  call prop_A_Q(ntry, wf8(:,71), 26, MT, 1_intkind1, wf8(:,72), n2(17))
  call counter_A_Q_LR(EWcttt,ntry, wf4(:,10), 18, wf4(:,40), n2(18))
  call prop_Q_A(ntry, wf8(:,8), 13, MT, 1_intkind1, wf8(:,73), n2(19))
  call vert_AV_Q(ntry, ex2(:), wf4(:,4), wf8(:,74), n3(:,88), t3x8(:,:,63))
  call prop_A_Q(ntry, wf8(:,74), 26, MT, 1_intkind1, wf8(:,75), n2(20))
  call vert_AV_Q(ntry, wf4(:,14), ex5(:), wf8(:,76), n3(:,89), t3x8(:,:,64))
  call counter_Q_A_LR(EWcttt,ntry, wf4(:,13), 9, wf4(:,41), n2(21))
  call prop_A_Q(ntry, wf8(:,76), 22, MT, 1_intkind1, wf8(:,77), n2(22))
  call counter_A_Q_LR(EWcttt,ntry, wf4(:,14), 6, wf4(:,42), n2(23))
  call prop_Q_A(ntry, wf8(:,10), 25, MT, 1_intkind1, wf8(:,78), n2(24))
  call vert_AV_Q(ntry, wf4(:,14), ex4(:), wf8(:,79), n3(:,90), t3x8(:,:,65))
  call counter_Q_A_LR(EWcttt,ntry, wf4(:,16), 17, wf4(:,43), n2(25))
  call prop_A_Q(ntry, wf8(:,79), 14, MT, 1_intkind1, wf8(:,80), n2(26))
  call prop_Q_A(ntry, wf8(:,11), 25, MT, 1_intkind1, wf8(:,81), n2(27))
  call vert_VQ_A(ntry, wf4(:,4), ex1(:), wf8(:,82), n3(:,91), t3x8(:,:,66))
  call prop_Q_A(ntry, wf8(:,82), 25, MT, 1_intkind1, wf8(:,83), n2(28))
  call vert_AV_Q(ntry, wf4(:,10), ex3(:), wf8(:,84), n3(:,92), t3x8(:,:,67))
  call prop_A_Q(ntry, wf8(:,84), 22, MT, 1_intkind1, wf8(:,85), n2(29))
  call prop_Q_A(ntry, wf8(:,13), 13, MT, 1_intkind1, wf8(:,86), n2(30))
  call vert_AV_Q(ntry, ex2(:), wf4(:,3), wf8(:,87), n3(:,93), t3x8(:,:,68))
  call prop_A_Q(ntry, wf8(:,87), 22, MT, 1_intkind1, wf8(:,88), n2(31))
  call vert_AV_Q(ntry, wf4(:,8), ex3(:), wf8(:,89), n3(:,94), t3x8(:,:,69))
  call prop_A_Q(ntry, wf8(:,89), 14, MT, 1_intkind1, wf8(:,90), n2(32))
  call prop_Q_A(ntry, wf8(:,15), 21, MT, 1_intkind1, wf8(:,91), n2(33))
  call vert_VQ_A(ntry, wf4(:,3), ex1(:), wf8(:,92), n3(:,95), t3x8(:,:,70))
  call prop_Q_A(ntry, wf8(:,92), 21, MT, 1_intkind1, wf8(:,93), n2(34))
  call vert_AV_Q(ntry, ex2(:), wf4(:,2), wf8(:,94), n3(:,96), t3x8(:,:,71))
  call prop_A_Q(ntry, wf8(:,94), 14, MT, 1_intkind1, wf8(:,95), n2(35))
  call vert_VQ_A(ntry, wf4(:,2), ex1(:), wf8(:,96), n3(:,97), t3x8(:,:,72))
  call prop_Q_A(ntry, wf8(:,96), 13, MT, 1_intkind1, wf8(:,97), n2(36))
  call vert_AQ_S(gX,ntry, ex2(:), ex1(:), wf4(:,44), n3(:,98), t3x4(:,:,26))
  call vert_AQ_S(gX,ntry, ex2(:), wf4(:,7), wf8(:,98), n3(:,99), t3x8(:,:,73))
  call vert_AQ_S(gX,ntry, wf4(:,14), ex1(:), wf8(:,99), n3(:,100), t3x8(:,:,74))
  call vert_AQ_S(gX,ntry, ex2(:), wf4(:,13), wf8(:,100), n3(:,101), t3x8(:,:,75))
  call vert_AQ_S(gX,ntry, wf4(:,8), ex1(:), wf8(:,101), n3(:,102), t3x8(:,:,76))
  call vert_UV_W(ntry, wf4(:,2), 12, ex5(:), 16, wf8(:,102), n3(:,103), t3x8(:,:,77))
  call vert_AQ_S(gX,ntry, ex2(:), wf4(:,16), wf8(:,103), n3(:,104), t3x8(:,:,78))
  call vert_AQ_S(gX,ntry, wf4(:,10), ex1(:), wf8(:,104), n3(:,105), t3x8(:,:,79))
  call vert_UV_W(ntry, ex4(:), 8, wf4(:,3), 20, wf8(:,105), n3(:,106), t3x8(:,:,80))
  call vert_UV_W(ntry, ex3(:), 4, wf4(:,4), 24, wf8(:,106), n3(:,107), t3x8(:,:,81))


  call init_hybrid_exwf(ex1)
  call init_hybrid_exwf(ex2)
  call init_hybrid_exwf(ex3)
  call init_hybrid_exwf(ex4)
  call init_hybrid_exwf(ex5)
  call init_hybrid_wf(wf4)
  call init_hybrid_wf(wf8)


  if (ntry==1) then
    call physical_helicities()
  end if

  ! computation of the colour-stripped amplitudes
  do nsync = ntry+ntry-1, ntry+1  !  nsync = 1,2  for 1st point and nsync = 3 later
    call diagrams()
    if (nsync == 1) call helsync(nsync, A, nhel, Hel)
  end do

  ! In the following loop the coefficients \Gamma_{i} of the expansion in
  ! the colour basis are computed for every helicity state and stored in M1helarray.
  ! Also the colour vector for the Born-loop interference is computed and saved in
  ! M0_col1_helarray
  do k = 1, nhel
    call colourvectors(A, k, M1helarray(:,k),M1helarray_ct(:,k))
    call colborninterf(M1helarray(:,k), M0_col1_helarray(:,k))
  end do
  M1helarray(:,nhel+1:)%j = 0
  M0_col1_helarray(:,nhel+1:)%hf = -1_intkind2
  M0_col1_helarray(:,nhel+1:)%j = 0

  M2add = 0
  M2add_ct = 0
  M2add_colint = 0

  M02 = 0
  M2ct = 0
  M2colint = 0
  
  do k = 1, nhel
    call colint(M1helarray(:,k)%j, M2add)
    call colint_ct(M1helarray(:,k)%j, M1helarray_ct(:,k)%j, M2add_ct)
    if (IR_is_on > 0) then
      call colint_IR(M1helarray(:,k)%j, M2add_colint)
    end if
    !summation over helicity configurations
    M02 = M02 + M2add
    M2ct = M2ct + M2add_ct
    M2colint = M2colint + M2add_colint
  end do



  contains

subroutine physical_helicities()
  implicit none 

integer :: i1,i2,i3,i4,i5
integer :: n

n=0

do i5= 1, 2
do i4= 1, 2
do i3= 1, 2
do i2= 1, 2
do i1= 1, 2
n = n + 1
 if((ex1(i1)%hf==-1_intkind2) .OR. (ex2(i2)%hf==-1_intkind2) .OR. (ex3(i3)%hf==-1_intkind2) .OR. (ex4(i4)%hf==-1_intkind2)  &
    .OR. (ex5(i5)%hf==-1_intkind2)) then
  Hel(n) = -1_intkind2
 else
  Hel(n) = ex1(i1)%hf + ex2(i2)%hf + ex3(i3)%hf + ex4(i4)%hf + ex5(i5)%hf
 end if
end do
end do
end do
end do
end do

end subroutine physical_helicities

subroutine diagrams()
  implicit none
  integer :: h
  ! e.g. call cont_VV(nsync, wf3, wf6, A(:,1), n64, t64, nhel, den(5)) ...

    call Hcont_VV(nsync, wf4(:,1), wf8(:,1), A(:,1), n3(:,108), t3x32(:,:,1), nhel, den(1))
    call Hcont_VV(nsync, wf4(:,1), wf8(:,2), A(:,2), n3(:,109), t3x32(:,:,2), nhel, den(1))
    call Hcont_VV(nsync, wf4(:,1), wf8(:,3), A(:,3), n3(:,110), t3x32(:,:,3), nhel, den(1))
    call Hcont_VV(nsync, wf4(:,2), wf8(:,4), A(:,4), n3(:,111), t3x32(:,:,4), nhel, den(3))
    call Hcont_VV(nsync, wf4(:,3), wf8(:,5), A(:,5), n3(:,112), t3x32(:,:,5), nhel, den(5))
    call Hcont_VV(nsync, wf4(:,4), wf8(:,6), A(:,6), n3(:,113), t3x32(:,:,6), nhel, den(7))
    call Hcont_QA(nsync, wf4(:,8), wf8(:,7), A(:,7), n3(:,114), t3x32(:,:,7), nhel, den(10))
    call Hcont_QA(nsync, wf4(:,10), wf8(:,8), A(:,8), n3(:,115), t3x32(:,:,8), nhel, den(12))
    call Hcont_VV(nsync, wf4(:,4), wf8(:,9), A(:,9), n3(:,116), t3x32(:,:,9), nhel, den(13))
    call Hcont_QA(nsync, wf4(:,14), wf8(:,10), A(:,10), n3(:,117), t3x32(:,:,10), nhel, den(16))
    call Hcont_QA(nsync, wf4(:,14), wf8(:,11), A(:,11), n3(:,118), t3x32(:,:,11), nhel, den(18))
    call Hcont_VV(nsync, wf4(:,4), wf8(:,12), A(:,12), n3(:,119), t3x32(:,:,12), nhel, den(19))
    call Hcont_QA(nsync, wf4(:,10), wf8(:,13), A(:,13), n3(:,120), t3x32(:,:,13), nhel, den(20))
    call Hcont_VV(nsync, wf4(:,3), wf8(:,14), A(:,14), n3(:,121), t3x32(:,:,14), nhel, den(21))
    call Hcont_QA(nsync, wf4(:,8), wf8(:,15), A(:,15), n3(:,122), t3x32(:,:,15), nhel, den(22))
    call Hcont_VV(nsync, wf4(:,3), wf8(:,16), A(:,16), n3(:,123), t3x32(:,:,16), nhel, den(23))
    call Hcont_VV(nsync, wf4(:,2), wf8(:,17), A(:,17), n3(:,124), t3x32(:,:,17), nhel, den(24))
    call Hcont_VV(nsync, wf4(:,2), wf8(:,18), A(:,18), n3(:,125), t3x32(:,:,18), nhel, den(25))

    call Hcont_VV(nsync, wf4(:,1), wf8(:,19), A(:,19), n3(:,126), t3x32(:,:,19), nhel, den(1))
    call Hcont_VV(nsync, wf4(:,1), wf8(:,20), A(:,20), n3(:,127), t3x32(:,:,20), nhel, den(1))
    call Hcont_VV(nsync, wf4(:,17), wf8(:,21), A(:,21), n3(:,128), t3x32(:,:,21), nhel, den(26))
    call Hcont_VV(nsync, wf4(:,17), wf8(:,22), A(:,22), n3(:,129), t3x32(:,:,22), nhel, den(26))
    call Hcont_VV(nsync, wf8(:,1), wf4(:,18), A(:,23), n3(:,130), t3x32(:,:,23), nhel, den(27))
    call Hcont_VV(nsync, wf8(:,2), wf4(:,18), A(:,24), n3(:,131), t3x32(:,:,24), nhel, den(27))
    call Hcont_VV(nsync, wf8(:,3), wf4(:,18), A(:,25), n3(:,132), t3x32(:,:,25), nhel, den(27))
    call Hcont_VV(nsync, wf4(:,2), wf8(:,23), A(:,26), n3(:,133), t3x32(:,:,26), nhel, den(29))
    call Hcont_VV(nsync, wf4(:,2), wf8(:,24), A(:,27), n3(:,134), t3x32(:,:,27), nhel, den(30))
    call Hcont_VV(nsync, wf4(:,3), wf8(:,25), A(:,28), n3(:,135), t3x32(:,:,28), nhel, den(31))
    call Hcont_VV(nsync, wf4(:,3), wf8(:,26), A(:,29), n3(:,136), t3x32(:,:,29), nhel, den(32))
    call Hcont_VV(nsync, wf4(:,4), wf8(:,27), A(:,30), n3(:,137), t3x32(:,:,30), nhel, den(33))
    call Hcont_VV(nsync, wf4(:,4), wf8(:,28), A(:,31), n3(:,138), t3x32(:,:,31), nhel, den(34))
    call Hcont_QA(nsync, wf4(:,8), wf8(:,29), A(:,32), n3(:,139), t3x32(:,:,32), nhel, den(10))
    call Hcont_QA(nsync, wf4(:,10), wf8(:,30), A(:,33), n3(:,140), t3x32(:,:,33), nhel, den(12))
    call Hcont_SS(nsync, wf4(:,20), wf8(:,31), A(:,34), n3(:,141), t3x32(:,:,34), nhel, den(36))
    call Hcont_VV(nsync, wf4(:,21), wf8(:,32), A(:,35), n3(:,142), t3x32(:,:,35), nhel, den(38))
    call Hcont_QA(nsync, wf4(:,14), wf8(:,33), A(:,36), n3(:,143), t3x32(:,:,36), nhel, den(16))
    call Hcont_QA(nsync, wf4(:,14), wf8(:,34), A(:,37), n3(:,144), t3x32(:,:,37), nhel, den(18))
    call Hcont_SS(nsync, wf4(:,20), wf8(:,35), A(:,38), n3(:,145), t3x32(:,:,38), nhel, den(39))
    call Hcont_VV(nsync, wf4(:,21), wf8(:,36), A(:,39), n3(:,146), t3x32(:,:,39), nhel, den(40))
    call Hcont_QA(nsync, wf4(:,10), wf8(:,37), A(:,40), n3(:,147), t3x32(:,:,40), nhel, den(20))
    call Hcont_SS(nsync, wf4(:,22), wf8(:,38), A(:,41), n3(:,148), t3x32(:,:,41), nhel, den(42))
    call Hcont_VV(nsync, wf4(:,23), wf8(:,39), A(:,42), n3(:,149), t3x32(:,:,42), nhel, den(44))
    call Hcont_QA(nsync, wf4(:,8), wf8(:,40), A(:,43), n3(:,150), t3x32(:,:,43), nhel, den(22))
    call Hcont_SS(nsync, wf4(:,22), wf8(:,41), A(:,44), n3(:,151), t3x32(:,:,44), nhel, den(45))
    call Hcont_VV(nsync, wf4(:,23), wf8(:,42), A(:,45), n3(:,152), t3x32(:,:,45), nhel, den(46))
    call Hcont_SS(nsync, wf4(:,24), wf8(:,43), A(:,46), n3(:,153), t3x32(:,:,46), nhel, den(48))
    call Hcont_VV(nsync, wf4(:,25), wf8(:,44), A(:,47), n3(:,154), t3x32(:,:,47), nhel, den(50))
    call Hcont_SS(nsync, wf4(:,24), wf8(:,45), A(:,48), n3(:,155), t3x32(:,:,48), nhel, den(51))
    call Hcont_VV(nsync, wf4(:,25), wf8(:,46), A(:,49), n3(:,156), t3x32(:,:,49), nhel, den(52))
    call Hcont_VV(nsync, wf4(:,4), wf8(:,47), A(:,50), n3(:,157), t3x32(:,:,50), nhel, den(13))
    call Hcont_QA(nsync, wf8(:,8), wf4(:,27), A(:,51), n3(:,158), t3x32(:,:,51), nhel, den(12))
    call Hcont_QA(nsync, wf8(:,7), wf4(:,29), A(:,52), n3(:,159), t3x32(:,:,52), nhel, den(10))
    call Hcont_VV(nsync, wf4(:,3), wf8(:,48), A(:,53), n3(:,160), t3x32(:,:,53), nhel, den(21))
    call Hcont_QA(nsync, wf8(:,13), wf4(:,27), A(:,54), n3(:,161), t3x32(:,:,54), nhel, den(20))
    call Hcont_VV(nsync, wf4(:,2), wf8(:,49), A(:,55), n3(:,162), t3x32(:,:,55), nhel, den(24))
    call Hcont_VV(nsync, wf4(:,2), wf8(:,50), A(:,56), n3(:,163), t3x32(:,:,56), nhel, den(25))
    call Hcont_QA(nsync, wf8(:,15), wf4(:,29), A(:,57), n3(:,164), t3x32(:,:,57), nhel, den(22))
    call Hcont_VV(nsync, wf4(:,3), wf8(:,51), A(:,58), n3(:,165), t3x32(:,:,58), nhel, den(23))
    call Hcont_QA(nsync, wf8(:,10), wf4(:,31), A(:,59), n3(:,166), t3x32(:,:,59), nhel, den(16))
    call Hcont_QA(nsync, wf8(:,11), wf4(:,31), A(:,60), n3(:,167), t3x32(:,:,60), nhel, den(18))
    call Hcont_VV(nsync, wf4(:,4), wf8(:,52), A(:,61), n3(:,168), t3x32(:,:,61), nhel, den(19))
    call Hcont_VV(nsync, wf4(:,4), wf8(:,53), A(:,62), n3(:,169), t3x32(:,:,62), nhel, den(19))
    call Hcont_QA(nsync, wf4(:,14), wf8(:,54), A(:,63), n3(:,170), t3x32(:,:,63), nhel, den(18))
    call Hcont_QA(nsync, wf4(:,14), wf8(:,55), A(:,64), n3(:,171), t3x32(:,:,64), nhel, den(16))
    call Hcont_VV(nsync, wf4(:,3), wf8(:,56), A(:,65), n3(:,172), t3x32(:,:,65), nhel, den(23))
    call Hcont_QA(nsync, wf4(:,8), wf8(:,57), A(:,66), n3(:,173), t3x32(:,:,66), nhel, den(22))
    call Hcont_VV(nsync, wf4(:,2), wf8(:,58), A(:,67), n3(:,174), t3x32(:,:,67), nhel, den(25))
    call Hcont_VV(nsync, wf4(:,2), wf8(:,59), A(:,68), n3(:,175), t3x32(:,:,68), nhel, den(24))
    call Hcont_QA(nsync, wf4(:,10), wf8(:,60), A(:,69), n3(:,176), t3x32(:,:,69), nhel, den(20))
    call Hcont_VV(nsync, wf4(:,3), wf8(:,61), A(:,70), n3(:,177), t3x32(:,:,70), nhel, den(21))
    call Hcont_QA(nsync, wf4(:,8), wf8(:,62), A(:,71), n3(:,178), t3x32(:,:,71), nhel, den(10))
    call Hcont_QA(nsync, wf4(:,10), wf8(:,63), A(:,72), n3(:,179), t3x32(:,:,72), nhel, den(12))
    call Hcont_VV(nsync, wf4(:,4), wf8(:,64), A(:,73), n3(:,180), t3x32(:,:,73), nhel, den(13))
    call Hcont_VV(nsync, wf4(:,2), wf8(:,65), A(:,74), n3(:,181), t3x32(:,:,74), nhel, den(3))
    call Hcont_VV(nsync, wf4(:,3), wf8(:,66), A(:,75), n3(:,182), t3x32(:,:,75), nhel, den(5))
    call Hcont_VV(nsync, wf4(:,4), wf8(:,67), A(:,76), n3(:,183), t3x32(:,:,76), nhel, den(7))
    call Hcont_QA(nsync, wf4(:,38), wf8(:,69), A(:,77), n3(:,184), t3x32(:,:,77), nhel, den(55))
    call Hcont_QA(nsync, wf4(:,39), wf8(:,70), A(:,78), n3(:,185), t3x32(:,:,78), nhel, den(58))
    call Hcont_QA(nsync, wf4(:,38), wf8(:,72), A(:,79), n3(:,186), t3x32(:,:,79), nhel, den(60))
    call Hcont_QA(nsync, wf4(:,40), wf8(:,73), A(:,80), n3(:,187), t3x32(:,:,80), nhel, den(63))
    call Hcont_QA(nsync, wf4(:,38), wf8(:,75), A(:,81), n3(:,188), t3x32(:,:,81), nhel, den(65))
    call Hcont_QA(nsync, wf4(:,41), wf8(:,77), A(:,82), n3(:,189), t3x32(:,:,82), nhel, den(68))
    call Hcont_QA(nsync, wf4(:,42), wf8(:,78), A(:,83), n3(:,190), t3x32(:,:,83), nhel, den(71))
    call Hcont_QA(nsync, wf4(:,43), wf8(:,80), A(:,84), n3(:,191), t3x32(:,:,84), nhel, den(74))
    call Hcont_QA(nsync, wf4(:,42), wf8(:,81), A(:,85), n3(:,192), t3x32(:,:,85), nhel, den(76))
    call Hcont_QA(nsync, wf4(:,42), wf8(:,83), A(:,86), n3(:,193), t3x32(:,:,86), nhel, den(78))
    call Hcont_QA(nsync, wf4(:,41), wf8(:,85), A(:,87), n3(:,194), t3x32(:,:,87), nhel, den(80))
    call Hcont_QA(nsync, wf4(:,40), wf8(:,86), A(:,88), n3(:,195), t3x32(:,:,88), nhel, den(82))
    call Hcont_QA(nsync, wf4(:,41), wf8(:,88), A(:,89), n3(:,196), t3x32(:,:,89), nhel, den(84))
    call Hcont_QA(nsync, wf4(:,43), wf8(:,90), A(:,90), n3(:,197), t3x32(:,:,90), nhel, den(86))
    call Hcont_QA(nsync, wf4(:,39), wf8(:,91), A(:,91), n3(:,198), t3x32(:,:,91), nhel, den(88))
    call Hcont_QA(nsync, wf4(:,39), wf8(:,93), A(:,92), n3(:,199), t3x32(:,:,92), nhel, den(90))
    call Hcont_QA(nsync, wf4(:,43), wf8(:,95), A(:,93), n3(:,200), t3x32(:,:,93), nhel, den(92))
    call Hcont_QA(nsync, wf4(:,40), wf8(:,97), A(:,94), n3(:,201), t3x32(:,:,94), nhel, den(94))

end subroutine diagrams


elemental function diagmap(j, n)
  implicit none
  integer, intent(in) :: j, n
  complex(REALKIND) :: diagmap
  diagmap = A(j,n)%j
end function diagmap

function diagsum(j, pos, neg)
  implicit none
  integer, intent(in) :: j, pos(:), neg(:)
  complex(REALKIND) :: diagsum
  diagsum = sum(diagmap(j, pos)) - sum(diagmap(j, neg))
end function diagsum

subroutine colourvectors(A, j, M1, M2)
  implicit none
  type(Hpolcont) :: A(:,:)
  integer, intent(in) :: j
  type(Hpolcont), intent(out) :: M1(6), M2(11) ! M1helarray(11,32)
  integer :: empty(0), i

  M1(1)%j = (A(j,1)%j-A(j,2)%j-A(j,4)%j+A(j,6)%j+A(j,11)%j)*f(1)+CI*(A(j,12)%j+A(j,17)%j)*f(2)
  M1(2)%j = (A(j,2)%j-A(j,3)%j-A(j,5)%j-A(j,6)%j+A(j,10)%j)*f(1)+CI*(-A(j,12)%j+A(j,14)%j)*f(2)
  M1(3)%j = (-A(j,1)%j+A(j,3)%j+A(j,4)%j+A(j,5)%j+A(j,15)%j)*f(1)+CI*(A(j,16)%j-A(j,17)%j)*f(2)
  M1(4)%j = (A(j,2)%j-A(j,3)%j-A(j,5)%j-A(j,6)%j+A(j,7)%j)*f(1)+CI*(A(j,9)%j-A(j,16)%j)*f(2)
  M1(5)%j = (-A(j,1)%j+A(j,3)%j+A(j,4)%j+A(j,5)%j+A(j,13)%j)*f(1)+CI*(-A(j,14)%j+A(j,18)%j)*f(2)
  M1(6)%j = (A(j,1)%j-A(j,2)%j-A(j,4)%j+A(j,6)%j+A(j,8)%j)*f(1)+CI*(-A(j,9)%j-A(j,18)%j)*f(2)

  M2( 1)%j = (A(j,23)%j-A(j,24)%j+A(j,37)%j+A(j,60)%j+A(j,63)%j-A(j,74)%j+A(j,76)%j-A(j,84)%j-A(j,85)%j)*f(4)+CI*(A(j,55)%j &
        +A(j,61)%j+A(j,62)%j+A(j,68)%j-A(j,86)%j-A(j,93)%j)*f(5)
  M2( 2)%j = (A(j,24)%j-A(j,25)%j+A(j,36)%j+A(j,59)%j+A(j,64)%j-A(j,75)%j-A(j,76)%j-A(j,82)%j-A(j,83)%j)*f(4)+CI*(A(j,53)%j &
        -A(j,61)%j-A(j,62)%j+A(j,70)%j+A(j,86)%j-A(j,89)%j)*f(5)
  M2( 3)%j = (-A(j,23)%j+A(j,25)%j+A(j,43)%j+A(j,57)%j+A(j,66)%j+A(j,74)%j+A(j,75)%j-A(j,90)%j-A(j,91)%j)*f(4)+CI*(-A(j,55)%j &
        +A(j,58)%j+A(j,65)%j-A(j,68)%j-A(j,92)%j+A(j,93)%j)*f(5)
  M2( 4)%j = (A(j,24)%j-A(j,25)%j+A(j,32)%j+A(j,52)%j+A(j,71)%j-A(j,75)%j-A(j,76)%j-A(j,77)%j-A(j,78)%j)*f(4)+CI*(A(j,50)%j &
        -A(j,58)%j-A(j,65)%j+A(j,73)%j-A(j,81)%j+A(j,92)%j)*f(5)
  M2( 5)%j = (-A(j,23)%j+A(j,25)%j+A(j,40)%j+A(j,54)%j+A(j,69)%j+A(j,74)%j+A(j,75)%j-A(j,87)%j-A(j,88)%j)*f(4)+CI*(-A(j,53)%j &
        +A(j,56)%j+A(j,67)%j-A(j,70)%j+A(j,89)%j-A(j,94)%j)*f(5)
  M2( 6)%j = (A(j,23)%j-A(j,24)%j+A(j,33)%j+A(j,51)%j+A(j,72)%j-A(j,74)%j+A(j,76)%j-A(j,79)%j-A(j,80)%j)*f(4)+CI*(-A(j,50)%j &
        -A(j,56)%j-A(j,67)%j-A(j,73)%j+A(j,81)%j+A(j,94)%j)*f(5)
  M2( 7)%j = 2*(-A(j,47)%j-A(j,49)%j)*f(7)+2*(-A(j,46)%j-A(j,48)%j)*f(8)
  M2( 8)%j = 2*(-A(j,42)%j-A(j,45)%j)*f(7)+2*(-A(j,41)%j-A(j,44)%j)*f(8)
  M2( 9)%j = 2*(-A(j,35)%j-A(j,39)%j)*f(7)+2*(-A(j,34)%j-A(j,38)%j)*f(8)
  M2(10)%j = -(A(j,19)%j*f(3))+A(j,21)%j*f(4)+2*CI*(A(j,27)%j-A(j,29)%j+A(j,31)%j)*f(6)+2*CI*(-A(j,26)%j+A(j,28)%j &
        -A(j,30)%j)*f(9)
  M2(11)%j = -(A(j,20)%j*f(3))+A(j,22)%j*f(4)+2*CI*(-A(j,27)%j+A(j,29)%j-A(j,31)%j)*f(6)+2*CI*(A(j,26)%j-A(j,28)%j &
        +A(j,30)%j)*f(9)


  M1(:)%hf = Hel(j)
  M2(:)%hf = Hel(j)  

  !M(i) corresponds to \Gamma_{i} in Fabio's thesis

end subroutine colourvectors


! **********************************************************************
subroutine colint(M, M2colint)
! M(i)   = <M|Ci> colour component of matrix element
! COLINT = <M|M>
!        = Sum_{i,j} <M|Ci> * <Ci|Cj> * <Cj|M>
!        = colour-summed squared matrix element
! K2(i,j) = <Ci|Cj>
! **********************************************************************
  use ol_colourmatrix_ppttj_ew_ttxggg_1_/**/REALKIND, only: K1
  implicit none

  complex(REALKIND), intent(in)  :: M(6)
  real(REALKIND),    intent(out) :: M2colint
  integer :: i, j

  M2colint = 0

    do i = 1, 6
      do j = 1, 6
        M2colint = M2colint + real(conjg(M(i))*K1(i,j)*M(j))
      end do
    end do

end subroutine colint

! **********************************************************************
subroutine colint_ct(M, Mct, M2colint_ct)
! M(i)   = <M|Ci> colour component of matrix element
! COLINT = <M|M>
!        = Sum_{i,j} <M|Ci> * <Ci|Cj> * <Cj|M>
!        = colour-summed squared matrix element
! K2(i,j) = <Ci|Cj>
! **********************************************************************
  use ol_colourmatrix_ppttj_ew_ttxggg_1_/**/REALKIND, only: K2
  implicit none

  complex(REALKIND), intent(in)  :: M(6), Mct(11)
  real(REALKIND),    intent(out) :: M2colint_ct
  integer ::  i, j

  M2colint_ct = 0

    do i = 1, 6
      do j = 1, 11
        M2colint_ct = M2colint_ct + real(conjg(M(i))*K2(i,j)*Mct(j))
      end do
    end do


end subroutine colint_ct

! **********************************************************************
subroutine colint_IR(M, M2IRadd)
! M(i)   = <M|Ci> colour component of matrix element
! K1(i,j) = .....
! **********************************************************************
  use ol_colourmatrix_ppttj_ew_ttxggg_1_/**/REALKIND, only: K1
  implicit none

  complex(REALKIND), intent(in)  :: M(6)
  real(REALKIND),    intent(out) :: M2IRadd(16)
  integer ::  i, j, k, colmatpos

  M2IRadd = 0

  do k = 1, 17-1
    colmatpos = 6*k
    do i = 1, 6
      do j = 1, 6
	M2IRadd(k) = M2IRadd(k) + real(conjg(M(i))*K1(i+colmatpos,j)*M(j))
      end do
    end do
  end do
  
end subroutine colint_IR

! **********************************************************************
subroutine colintmunu(M1, M2, M2colint)
! M1(i)    = <M1|Ci> colour component of matrix element
! M2(i)    = <M2|Ci> colour component of matrix element
! M2colint = <M1|M2>
!          = Sum_{i,j} <M1|Ci> * <Ci|Cj> * <Cj|M2>
!          = colour-summed squared matrix element
! K2(i,j) = <Ci|Cj>
! **********************************************************************
  use ol_colourmatrix_ppttj_ew_ttxggg_1_/**/REALKIND, only: K2
  implicit none

  complex(REALKIND), intent(in)  :: M1(6)
  complex(REALKIND), intent(in)  :: M2(6)
  complex(REALKIND),    intent(out) :: M2colint
  integer :: i, j

  M2colint = 0

  do i = 1, 6
    do j = 1, 6
      M2colint = M2colint + M1(i)*K2(i,j)*conjg(M2(j))
    end do
  end do

end subroutine colintmunu





! **********************************************************************
subroutine colborninterf(M, M0_col)
! M(i)         = <M|Ci> colour component of matrix element
! M0_col(i)    = <M2|Ci> colour component of matrix element,
!                see \tilde{M}_{j} in Fabio's thesis
! M2colint = Sum_{i} <M1|Ci> * <Ci|Cj>
!          = colour-summed squared matrix element
! KL(i,j) = <Ci|Cj> with elements Cj of 1-loop colour basis
! **********************************************************************
  use ol_colourmatrix_ppttj_ew_ttxggg_1_/**/REALKIND, only: KL
  implicit none

  type(Hpolcont), intent(in)  :: M(6)
  type(Hpolcont), intent(out)  :: M0_col(11)
  integer :: i, j


  do j = 1, 11 !size(KL(1,:))
    M0_col(j)%j = 0
    M0_col(j)%hf = M(1)%hf
    do i = 1, 6 !size(KL(:,1))
      M0_col(j)%j = M0_col(j)%j  + conjg(M(i)%j)*KL(i,j)
    end do    
  end do

end subroutine colborninterf

end subroutine amp2

end module ol_loop_ppttj_ew_ttxggg_1_/**/REALKIND
