
module ol_vamp_1_ppttj_ttxbbxg_1_/**/REALKIND
contains

! **********************************************************************
subroutine vamp_1(M)
! P(0:3,nlegs) = incoming external momenta
! Uses tree structures 'wf', factors 'c', and denominators 'den' from loop_ppttj_ttxbbxg_1.
! Sets colour stripped amplitudes A from the module loop_amplitudes_ppttj_ttxbbxg_1.
! **********************************************************************
  use KIND_TYPES, only: REALKIND, QREALKIND, intkind2
  use ol_parameters_decl_/**/DREALKIND, only: l_switch
  use ol_parameters_decl_/**/QREALKIND ! masses
  use ol_vert_interface_/**/REALKIND
  use ol_prop_interface_/**/REALKIND
  use ol_last_step_/**/REALKIND
  use ol_tables_storage_ppttj_ttxbbxg_1_/**/DREALKIND
  use ol_tensor_sum_storage_ppttj_ttxbbxg_1_/**/REALKIND
  use ol_loop_handling_/**/REALKIND
  use ofred_reduction_/**/REALKIND, only: Hotf_4pt_reduction, Hotf_4pt_reduction_last
  use ofred_reduction_/**/REALKIND, only: Hotf_5pt_reduction, Hotf_5pt_reduction_last
  use ol_loop_reduction_/**/REALKIND, only: TI_bubble_red, TI_triangle_red
use ol_loop_reduction_/**/REALKIND, only: compute_scalar_box

  use ol_loop_storage_ppttj_ttxbbxg_1_/**/REALKIND
#ifndef PRECISION_dp
  use ol_loop_storage_ppttj_ttxbbxg_1_/**/DREALKIND, only: &
    & p_switch, Hel, merge_step, merge_mism, merge_tables, merge_hels
#endif
  use hol_initialisation_/**/REALKIND, only: G0_hol_initialisation
  use ol_h_vert_interface_/**/REALKIND
  use ol_h_prop_interface_/**/REALKIND
  use ol_h_last_step_/**/REALKIND
  use ol_merging_/**/REALKIND, only: ol_merge, ol_merge_tensors, ol_merge_last

  implicit none

  type(Hpolcont) :: Gcoeff(32)
  type(Hpolcont), intent(in) :: M(4,32)


#ifndef PRECISION_dp
  if (ntryL==1 .OR. p_switch == 1) Gcoeff(:)%hf = Hel
#else
  if (ntryL==1 .OR. p_switch == 2) Gcoeff(:)%hf = Hel
#endif

  ! =============================================


! Dressing, otf merging and otf reduction calls to build loop structures

  Gcoeff(:)%j = (c(14)*M(1,:)%j+c(11)*(-M(2,:)%j-M(3,:)%j)+c(10)*M(4,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1),h0tab(:,1),[16,4,1,2,8],[nMB,0,nMT,0,nMB],5,0)
  call Hloop_AV_Q(ntryL,G0H32(1),ex5(:),G0H16(1),m3h2x16(:,1),heltab2x32(:,:,1))
  call Hloop_A_Q(ntryL,G0H16(1),16,nMB,G1H16(1),n2h16(1))
  Gcoeff(:)%j = (c(3)*(-M(2,:)%j+M(3,:)%j)+c(4)*(M(1,:)%j-M(4,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(2),h0tab(:,2),[16,2,1,4,8],[0,nMT,0,nMB,0],5,0)
  call Hloop_UV_W(ntryL,G0H32(1),0,ex5(:),16,G1H16(2),m3h2x16(:,2),heltab2x32(:,:,2))
  Gcoeff(:)%j = (c(11)*(-M(2,:)%j-M(3,:)%j)+c(10)*M(4,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(3),h0tab(:,3),[16,4,2,1,8],[nMB,0,nMT,0,nMB],5,0)
  call Hloop_AV_Q(ntryL,G0H32(1),ex5(:),G0H16(1),m3h2x16(:,3),heltab2x32(:,:,3))
  call Hloop_A_Q(ntryL,G0H16(1),16,nMB,G1H16(3),n2h16(2))
  Gcoeff(:)%j = (c(5)*M(2,:)%j+c(3)*M(3,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(4),h0tab(:,4),[16,2,1,8,4],[0,nMT,0,nMB,0],5,0)
  call Hloop_UV_W(ntryL,G0H32(1),0,ex5(:),16,G1H16(4),m3h2x16(:,4),heltab2x32(:,:,4))
  Gcoeff(:)%j = (-(c(3)*M(2,:)%j)-c(5)*M(3,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(5),h0tab(:,5),[16,1,2,4,8],[0,nMT,0,nMB,0],5,0)
  call Hloop_UV_W(ntryL,G0H32(1),0,ex5(:),16,G1H16(5),m3h2x16(:,5),heltab2x32(:,:,5))
  Gcoeff(:)%j = (c(3)*(-M(2,:)%j+M(3,:)%j)+c(4)*(-M(1,:)%j+M(4,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(6),h0tab(:,6),[16,1,2,8,4],[0,nMT,0,nMB,0],5,0)
  call Hloop_UV_W(ntryL,G0H32(1),0,ex5(:),16,G1H16(6),m3h2x16(:,6),heltab2x32(:,:,6))
  Gcoeff(:)%j = (c(10)*M(1,:)%j+c(11)*(-M(2,:)%j-M(3,:)%j)+c(14)*M(4,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(7),h0tab(:,7),[16,1,4,8,2],[nMT,0,nMB,0,nMT],5,0)
  call Hloop_AV_Q(ntryL,G0H32(1),ex5(:),G0H16(1),m3h2x16(:,7),heltab2x32(:,:,7))
  call Hloop_A_Q(ntryL,G0H16(1),16,nMT,G1H16(7),n2h16(3))
  Gcoeff(:)%j = (c(10)*M(1,:)%j+c(11)*(-M(2,:)%j-M(3,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(8),h0tab(:,8),[16,1,8,4,2],[nMT,0,nMB,0,nMT],5,0)
  call Hloop_AV_Q(ntryL,G0H32(1),ex5(:),G0H16(1),m3h2x16(:,8),heltab2x32(:,:,8))
  call Hloop_A_Q(ntryL,G0H16(1),16,nMT,G1H16(8),n2h16(4))
  call Hloop_AQ_V(ntryL,G1H16(1),ex3(:),G1H8(1),m3h2x8(:,1),heltab2x16(:,:,1))
  call Hloop_VA_Q(ntryL,G1H16(2),ex2(:),G1H8(2),m3h2x8(:,2),heltab2x16(:,:,2))
  call Hloop_A_Q(ntryL,G1H8(2),18,nMT,G2H8(1),n2h8(1))
  call Hloop_AQ_V(ntryL,G1H16(3),ex3(:),G1H8(2),m3h2x8(:,3),heltab2x16(:,:,3))
  call Hloop_VA_Q(ntryL,G1H16(4),ex2(:),G1H8(3),m3h2x8(:,4),heltab2x16(:,:,4))
  call Hloop_A_Q(ntryL,G1H8(3),18,nMT,G2H8(2),n2h8(2))
  call Hloop_VQ_A(ntryL,G1H16(5),ex1(:),G1H8(3),m3h2x8(:,5),heltab2x16(:,:,5))
  call Hloop_Q_A(ntryL,G1H8(3),17,nMT,G2H8(3),n2h8(3))
  call Hloop_VQ_A(ntryL,G1H16(6),ex1(:),G1H8(3),m3h2x8(:,6),heltab2x16(:,:,6))
  call Hloop_Q_A(ntryL,G1H8(3),17,nMT,G2H8(4),n2h8(4))
  call Hloop_AQ_V(ntryL,G1H16(7),ex1(:),G1H8(3),m3h2x8(:,7),heltab2x16(:,:,7))
  call Hloop_AQ_V(ntryL,G1H16(8),ex1(:),G1H8(4),m3h2x8(:,8),heltab2x16(:,:,8))
  call Hloop_VQ_A(ntryL,G1H8(1),ex1(:),G1H4(1),m3h2x4(:,1),heltab2x8(:,:,1))
  call Hloop_Q_A(ntryL,G1H4(1),21,nMT,G2H4(1),n2h4(1))
  call Hloop_AQ_V(ntryL,G2H8(1),ex1(:),G2H4(2),m3h2x4(:,2),heltab2x8(:,:,2))
  call Hloop_VA_Q(ntryL,G1H8(2),ex2(:),G1H4(1),m3h2x4(:,3),heltab2x8(:,:,3))
  call Hloop_A_Q(ntryL,G1H4(1),22,nMT,G2H4(3),n2h4(2))
  call Hloop_AQ_V(ntryL,G2H8(2),ex1(:),G2H4(4),m3h2x4(:,4),heltab2x8(:,:,4))
  call Hloop_QA_V(ntryL,G2H8(3),ex2(:),G2H4(5),m3h2x4(:,5),heltab2x8(:,:,5))
  call Hloop_QA_V(ntryL,G2H8(4),ex2(:),G2H4(6),m3h2x4(:,6),heltab2x8(:,:,6))
  call Hloop_VQ_A(ntryL,G1H8(3),ex3(:),G1H4(1),m3h2x4(:,7),heltab2x8(:,:,7))
  call Hloop_Q_A(ntryL,G1H4(1),21,nMB,G2H4(7),n2h4(3))
  call Hloop_VA_Q(ntryL,G1H8(4),ex4(:),G1H4(1),m3h2x4(:,8),heltab2x8(:,:,8))
  call Hloop_A_Q(ntryL,G1H4(1),25,nMB,G2H4(8),n2h4(4))
  call Hloop_QA_V(ntryL,G2H4(1),ex2(:),G2H2(1),m3h2x2(:,1),heltab2x4(:,:,1))
  call Hotf_5pt_reduction(G2H4(2),RedSet_5(1),mass5set(:,1),  & 
G1H4(1),G1H4(2),G1H4(3),G1H4(4),G1H4(5),G1H4(6),4)
  call HG1shiftOLR(G1H4(2),8,4)
  call Hloop_AQ_V(ntryL,G2H4(3),ex1(:),G2H2(2),m3h2x2(:,2),heltab2x4(:,:,2))
  call Hotf_5pt_reduction(G2H4(4),RedSet_5(2),mass5set(:,1),  & 
G1H4(7),G1H4(8),G1H4(9),G1H4(10),G1H4(11),G1H4(12),4)
  call HG1shiftOLR(G1H4(8),4,4)
  call Hotf_5pt_reduction(G2H4(5),RedSet_5(3),mass5set(:,1),  & 
G1H4(13),G1H4(14),G1H4(15),G1H4(16),G1H4(17),G1H4(18),4)
  call HG1shiftOLR(G1H4(14),8,4)
  call Hotf_5pt_reduction(G2H4(6),RedSet_5(4),mass5set(:,1),  & 
G1H4(19),G1H4(20),G1H4(21),G1H4(22),G1H4(23),G1H4(24),4)
  call HG1shiftOLR(G1H4(20),4,4)
  call Hloop_QA_V(ntryL,G2H4(7),ex4(:),G2H2(3),m3h2x2(:,3),heltab2x4(:,:,3))
  call Hloop_AQ_V(ntryL,G2H4(8),ex3(:),G2H2(4),m3h2x2(:,4),heltab2x4(:,:,4))
  call Hloop_VQ_A(ntryL,G1H4(1),ex3(:),G1H2(1),m3h2x2(:,5),heltab2x4(:,:,5))
  call Hloop_Q_A(ntryL,G1H2(1),23,nMB,G2H2(5),n2h2(1))
call HGT_raise_alpha_OLR(G1H4(2),1,1,4)
call HGT_raise_alpha_invQ_OLR(G1H4(2),2,5,4)
  call Hloop_VA_Q(ntryL,G1H4(2),ex4(:),G1H2(1),m3h2x2(:,6),heltab2x4(:,:,6))
  call Hloop_VQ_A(ntryL,G1H4(5),ex3(:),G1H2(2),m3h2x2(:,7),heltab2x4(:,:,7))
  call Hloop_Q_A(ntryL,G1H2(2),23,nMB,G2H2(6),n2h2(2))
  call Hloop_VQ_A(ntryL,G1H4(6),ex3(:),G1H2(2),m3h2x2(:,8),heltab2x4(:,:,8))
  call Hloop_Q_A(ntryL,G1H2(2),23,nMB,G2H2(7),n2h2(3))
  call Hloop_VA_Q(ntryL,G1H4(7),ex4(:),G1H2(2),m3h2x2(:,9),heltab2x4(:,:,9))
  call Hloop_A_Q(ntryL,G1H2(2),27,nMB,G2H2(8),n2h2(4))
call HGT_raise_alpha_OLR(G1H4(8),1,1,4)
call HGT_raise_alpha_invQ_OLR(G1H4(8),2,5,4)
  call Hloop_VQ_A(ntryL,G1H4(8),ex3(:),G1H2(2),m3h2x2(:,10),heltab2x4(:,:,10))
  call Hloop_VA_Q(ntryL,G1H4(11),ex4(:),G1H2(3),m3h2x2(:,11),heltab2x4(:,:,11))
  call Hloop_A_Q(ntryL,G1H2(3),27,nMB,G2H2(9),n2h2(5))
  call Hloop_VA_Q(ntryL,G1H4(12),ex4(:),G1H2(3),m3h2x2(:,12),heltab2x4(:,:,12))
  call Hloop_A_Q(ntryL,G1H2(3),27,nMB,G2H2(10),n2h2(6))
  call Hloop_VQ_A(ntryL,G1H4(13),ex3(:),G1H2(3),m3h2x2(:,13),heltab2x4(:,:,13))
  call Hloop_Q_A(ntryL,G1H2(3),23,nMB,G2H2(11),n2h2(7))
call HGT_raise_alpha_OLR(G1H4(14),1,1,4)
call HGT_raise_alpha_invQ_OLR(G1H4(14),2,5,4)
  call Hloop_VA_Q(ntryL,G1H4(14),ex4(:),G1H2(3),m3h2x2(:,14),heltab2x4(:,:,14))
  call Hloop_VQ_A(ntryL,G1H4(17),ex3(:),G1H2(4),m3h2x2(:,15),heltab2x4(:,:,15))
  call Hloop_Q_A(ntryL,G1H2(4),23,nMB,G2H2(12),n2h2(8))
  call Hloop_VQ_A(ntryL,G1H4(18),ex3(:),G1H2(4),m3h2x2(:,16),heltab2x4(:,:,16))
  call Hloop_Q_A(ntryL,G1H2(4),23,nMB,G2H2(13),n2h2(9))
  call Hloop_VA_Q(ntryL,G1H4(19),ex4(:),G1H2(4),m3h2x2(:,17),heltab2x4(:,:,17))
  call Hloop_A_Q(ntryL,G1H2(4),27,nMB,G2H2(14),n2h2(10))
call HGT_raise_alpha_OLR(G1H4(20),1,1,4)
call HGT_raise_alpha_invQ_OLR(G1H4(20),2,5,4)
  call Hloop_VQ_A(ntryL,G1H4(20),ex3(:),G1H2(4),m3h2x2(:,18),heltab2x4(:,:,18))
  call Hloop_VA_Q(ntryL,G1H4(23),ex4(:),G1H2(5),m3h2x2(:,19),heltab2x4(:,:,19))
  call Hloop_A_Q(ntryL,G1H2(5),27,nMB,G2H2(15),n2h2(11))
  call Hloop_VA_Q(ntryL,G1H4(24),ex4(:),G1H2(5),m3h2x2(:,20),heltab2x4(:,:,20))
  call Hloop_A_Q(ntryL,G1H2(5),27,nMB,G2H2(16),n2h2(12))
  call Hotf_5pt_reduction(G2H2(1),RedSet_5(5),mass5set(:,2),  & 
G1H2(5),G1H2(6),G1H2(7),G1H2(8),G1H2(9),G1H2(10),2)
  call HG1shiftOLR(G1H2(6),8,2)
  call Hotf_5pt_reduction(G2H2(2),RedSet_5(6),mass5set(:,2),  & 
G1H2(11),G1H2(12),G1H2(13),G1H2(14),G1H2(15),G1H2(16),2)
  call HG1shiftOLR(G1H2(12),8,2)
  call Hotf_5pt_reduction(G2H2(3),RedSet_5(7),mass5set(:,3),  & 
G1H2(17),G1H2(18),G1H2(19),G1H2(20),G1H2(21),G1H2(22),2)
  call HG1shiftOLR(G1H2(18),2,2)
  call Hotf_5pt_reduction(G2H2(4),RedSet_5(8),mass5set(:,3),  & 
G1H2(23),G1H2(24),G1H2(25),G1H2(26),G1H2(27),G1H2(28),2)
  call HG1shiftOLR(G1H2(24),2,2)
  call Hcheck_last_QA_V(ntryL,l_switch,G2H2(5),ex4(:),G2tensor(1),m3h2x1(:,1),heltab2x2(:,:,1))
  call Hcheck_last_QA_V(ntryL,l_switch,G2H2(7),ex4(:),G2tensor(2),m3h2x1(:,2),heltab2x2(:,:,2))
  call Hcheck_last_AQ_V(ntryL,l_switch,G2H2(8),ex3(:),G2tensor(3),m3h2x1(:,3),heltab2x2(:,:,3))
  call Hcheck_last_AQ_V(ntryL,l_switch,G2H2(10),ex3(:),G2tensor(4),m3h2x1(:,4),heltab2x2(:,:,4))
  call Hcheck_last_QA_V(ntryL,l_switch,G2H2(11),ex4(:),G2tensor(5),m3h2x1(:,5),heltab2x2(:,:,5))
  call Hcheck_last_QA_V(ntryL,l_switch,G2H2(13),ex4(:),G2tensor(6),m3h2x1(:,6),heltab2x2(:,:,6))
  call Hcheck_last_AQ_V(ntryL,l_switch,G2H2(14),ex3(:),G2tensor(7),m3h2x1(:,7),heltab2x2(:,:,7))
  call Hcheck_last_AQ_V(ntryL,l_switch,G2H2(16),ex3(:),G2tensor(8),m3h2x1(:,8),heltab2x2(:,:,8))
  call Hloop_VA_Q(ntryL,G1H2(5),ex4(:),G1H1(1),m3h2x1(:,9),heltab2x2(:,:,9))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,nMB,G2tensor(9),n2h1(1))
  call Hloop_VA_Q(ntryL,G1H2(6),ex4(:),G1H1(1),m3h2x1(:,10),heltab2x2(:,:,10))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),8,nMB,G2tensor(10),n2h1(2))
  call Hloop_VA_Q(ntryL,G1H2(10),ex4(:),G1H1(1),m3h2x1(:,11),heltab2x2(:,:,11))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,nMB,G2tensor(11),n2h1(3))
  call Hloop_VA_Q(ntryL,G1H2(11),ex4(:),G1H1(1),m3h2x1(:,12),heltab2x2(:,:,12))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,nMB,G2tensor(12),n2h1(4))
  call Hloop_VA_Q(ntryL,G1H2(12),ex4(:),G1H1(1),m3h2x1(:,13),heltab2x2(:,:,13))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),8,nMB,G2tensor(13),n2h1(5))
  call Hloop_VA_Q(ntryL,G1H2(16),ex4(:),G1H1(1),m3h2x1(:,14),heltab2x2(:,:,14))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,nMB,G2tensor(14),n2h1(6))
  call Hloop_VA_Q(ntryL,G1H2(17),ex2(:),G1H1(1),m3h2x1(:,15),heltab2x2(:,:,15))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,nMT,G2tensor(15),n2h1(7))
  call Hloop_VA_Q(ntryL,G1H2(18),ex2(:),G1H1(1),m3h2x1(:,16),heltab2x2(:,:,16))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),2,nMT,G2tensor(16),n2h1(8))
  call Hloop_VA_Q(ntryL,G1H2(22),ex2(:),G1H1(1),m3h2x1(:,17),heltab2x2(:,:,17))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,nMT,G2tensor(17),n2h1(9))
  call Hloop_VA_Q(ntryL,G1H2(23),ex2(:),G1H1(1),m3h2x1(:,18),heltab2x2(:,:,18))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,nMT,G2tensor(18),n2h1(10))
  call Hloop_VA_Q(ntryL,G1H2(24),ex2(:),G1H1(1),m3h2x1(:,19),heltab2x2(:,:,19))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),2,nMT,G2tensor(19),n2h1(11))
  call Hloop_VA_Q(ntryL,G1H2(28),ex2(:),G1H1(1),m3h2x1(:,20),heltab2x2(:,:,20))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,nMT,G2tensor(20),n2h1(12))
  call Hotf_5pt_reduction_last(G2tensor(1),RedSet_5(1),mass5set(:,1),  & 
G1tensor(1),G1tensor(2),G1tensor(3),G1tensor(4),G1tensor(5),G1tensor(6))
  call G_TensorShift(G1tensor(2),8)
  call Hotf_5pt_reduction_last(G2tensor(3),RedSet_5(2),mass5set(:,1),  & 
G1tensor(7),G1tensor(8),G1tensor(9),G1tensor(10),G1tensor(11),G1tensor(12))
  call G_TensorShift(G1tensor(8),4)
  call Hotf_5pt_reduction_last(G2tensor(5),RedSet_5(3),mass5set(:,1),  & 
G1tensor(13),G1tensor(14),G1tensor(15),G1tensor(16),G1tensor(17),G1tensor(18))
  call G_TensorShift(G1tensor(14),8)
  call Hotf_5pt_reduction_last(G2tensor(7),RedSet_5(4),mass5set(:,1),  & 
G1tensor(19),G1tensor(20),G1tensor(21),G1tensor(22),G1tensor(23),G1tensor(24))
  call G_TensorShift(G1tensor(20),4)
  call Hotf_5pt_reduction_last(G2tensor(9),RedSet_5(5),mass5set(:,2),  & 
G1tensor(25),G1tensor(26),G1tensor(27),G1tensor(28),G1tensor(29),G1tensor(30))
  call G_TensorShift(G1tensor(26),8)
  call Hotf_5pt_reduction_last(G2tensor(12),RedSet_5(6),mass5set(:,2),  & 
G1tensor(31),G1tensor(32),G1tensor(33),G1tensor(34),G1tensor(35),G1tensor(36))
  call G_TensorShift(G1tensor(32),8)
  call Hotf_5pt_reduction_last(G2tensor(15),RedSet_5(7),mass5set(:,3),  & 
G1tensor(37),G1tensor(38),G1tensor(39),G1tensor(40),G1tensor(41),G1tensor(42))
  call G_TensorShift(G1tensor(38),2)
  call Hotf_5pt_reduction_last(G2tensor(18),RedSet_5(8),mass5set(:,3),  & 
G1tensor(43),G1tensor(44),G1tensor(45),G1tensor(46),G1tensor(47),G1tensor(48))
  call G_TensorShift(G1tensor(44),2)
  call ol_merge_tensors(T1sum(1),[G1tensor(1)])
  call ol_merge_tensors(T1sum(2),[G1tensor(7)])
  call ol_merge_tensors(T1sum(3),[G1tensor(13)])
  call ol_merge_tensors(T1sum(4),[G1tensor(19)])
  call ol_merge_tensors(T1sum(5),[G1tensor(25)])
  call ol_merge_tensors(T1sum(6),[G1tensor(31)])
  call ol_merge_tensors(T1sum(7),[G1tensor(37)])
  call ol_merge_tensors(T1sum(8),[G1tensor(43)])
  Gcoeff(:)%j = (c(14)*M(1,:)%j-c(11)*M(2,:)%j+c(10)*M(4,:)%j) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(9),h0tab(:,9),[16,3,8,4],[nMB,nMB,0,nMB],4,1,wf4(:,1))
  call Hloop_QV_A(ntryL,G0H32(1),ex5(:),G0H16(1),m3h2x16(:,9),heltab2x32(:,:,9))
  call Hloop_Q_A(ntryL,G0H16(1),16,nMB,G1H16(1),n2h16(5))
  Gcoeff(:)%j = (c(19)*M(2,:)%j+c(14)*(M(1,:)%j-M(4,:)%j)) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(10),h0tab(:,10),[16,3,8,4],[0,0,nMB,0],4,1,wf4(:,1))
  call Hloop_UV_W(ntryL,G0H32(1),0,ex5(:),16,G1H16(2),m3h2x16(:,10),heltab2x32(:,:,10))
  Gcoeff(:)%j = (c(14)*M(1,:)%j-c(11)*M(3,:)%j+c(10)*M(4,:)%j) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(11),h0tab(:,11),[16,3,4,8],[nMB,nMB,0,nMB],4,1,wf4(:,1))
  call Hloop_AV_Q(ntryL,G0H32(1),ex5(:),G0H16(1),m3h2x16(:,11),heltab2x32(:,:,11))
  call Hloop_A_Q(ntryL,G0H16(1),16,nMB,G1H16(3),n2h16(6))
  Gcoeff(:)%j = (c(19)*M(3,:)%j+c(14)*(M(1,:)%j-M(4,:)%j)) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(12),h0tab(:,12),[16,3,4,8],[0,0,nMB,0],4,1,wf4(:,1))
  call Hloop_UV_W(ntryL,G0H32(1),0,ex5(:),16,G1H16(4),m3h2x16(:,12),heltab2x32(:,:,12))
  Gcoeff(:)%j = (-(c(4)*M(1,:)%j)) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(13),h0tab(:,13),[16,4,3,8],[nMB,0,0,nMB],4,1,wf4(:,1))
  call Hloop_AV_Q(ntryL,G0H32(1),ex5(:),G0H16(1),m3h2x16(:,13),heltab2x32(:,:,13))
  call Hloop_A_Q(ntryL,G0H16(1),16,nMB,G1H16(5),n2h16(7))
  Gcoeff(:)%j = (c(4)*M(1,:)%j) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(14),h0tab(:,14),[16,4,3,8],[0,nMB,nMB,0],4,1,wf4(:,1))
  call Hloop_UV_W(ntryL,G0H32(1),0,ex5(:),16,G1H16(6),m3h2x16(:,14),heltab2x32(:,:,14))
  Gcoeff(:)%j = (c(10)*M(1,:)%j-c(11)*M(3,:)%j+c(14)*M(4,:)%j) * den(2)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(15),h0tab(:,15),[16,1,2,12],[nMT,0,nMT,nMT],4,1,wf4(:,2))
  call Hloop_AV_Q(ntryL,G0H32(1),ex5(:),G0H16(1),m3h2x16(:,15),heltab2x32(:,:,15))
  call Hloop_A_Q(ntryL,G0H16(1),16,nMT,G1H16(7),n2h16(8))
  Gcoeff(:)%j = (c(19)*M(3,:)%j+c(14)*(-M(1,:)%j+M(4,:)%j)) * den(2)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(16),h0tab(:,16),[16,1,2,12],[0,nMT,0,0],4,1,wf4(:,2))
  call Hloop_UV_W(ntryL,G0H32(1),0,ex5(:),16,G1H16(8),m3h2x16(:,16),heltab2x32(:,:,16))
  Gcoeff(:)%j = (c(10)*M(1,:)%j-c(11)*M(2,:)%j+c(14)*M(4,:)%j) * den(2)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(17),h0tab(:,17),[16,2,1,12],[nMT,0,nMT,nMT],4,1,wf4(:,2))
  call Hloop_QV_A(ntryL,G0H32(1),ex5(:),G0H16(1),m3h2x16(:,17),heltab2x32(:,:,17))
  call Hloop_Q_A(ntryL,G0H16(1),16,nMT,G1H16(9),n2h16(9))
  Gcoeff(:)%j = (c(19)*M(2,:)%j+c(14)*(-M(1,:)%j+M(4,:)%j)) * den(2)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(18),h0tab(:,18),[16,2,1,12],[0,nMT,0,0],4,1,wf4(:,2))
  call Hloop_UV_W(ntryL,G0H32(1),0,ex5(:),16,G1H16(10),m3h2x16(:,18),heltab2x32(:,:,18))
  Gcoeff(:)%j = (-(c(4)*M(4,:)%j)) * den(2)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(19),h0tab(:,19),[16,1,12,2],[nMT,0,0,nMT],4,1,wf4(:,2))
  call Hloop_AV_Q(ntryL,G0H32(1),ex5(:),G0H16(1),m3h2x16(:,19),heltab2x32(:,:,19))
  call Hloop_A_Q(ntryL,G0H16(1),16,nMT,G1H16(11),n2h16(10))
  Gcoeff(:)%j = (c(4)*M(4,:)%j) * den(2)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(20),h0tab(:,20),[16,1,12,2],[0,nMT,nMT,0],4,1,wf4(:,2))
  call Hloop_UV_W(ntryL,G0H32(1),0,ex5(:),16,G1H16(12),m3h2x16(:,20),heltab2x32(:,:,20))
  Gcoeff(:)%j = (c(10)*M(1,:)%j+c(17)*M(3,:)%j) * den(8)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(21),h0tab(:,21),[17,2,4,8],[nMT,0,nMB,0],4,1,wf4(:,8))
  call Hloop_VQ_A(ntryL,G0H32(1),wf4(:,8),G0H8(1),m3h4x8(:,1),heltab2x32(:,:,21))
  call Hloop_Q_A(ntryL,G0H8(1),17,nMT,G1H8(1),n2h8(5))
  Gcoeff(:)%j = (c(15)*M(1,:)%j-c(12)*M(3,:)%j) * den(8)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(22),h0tab(:,22),[17,2,8,4],[nMT,0,nMB,0],4,1,wf4(:,8))
  call Hloop_VQ_A(ntryL,G0H32(1),wf4(:,8),G0H8(1),m3h4x8(:,2),heltab2x32(:,:,22))
  call Hloop_Q_A(ntryL,G0H8(1),17,nMT,G1H8(2),n2h8(6))
  Gcoeff(:)%j = (c(15)*M(1,:)%j-c(12)*M(2,:)%j) * den(10)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(23),h0tab(:,23),[18,1,4,8],[nMT,0,nMB,0],4,1,wf4(:,10))
  call Hloop_VA_Q(ntryL,G0H32(1),wf4(:,10),G0H8(1),m3h4x8(:,3),heltab2x32(:,:,23))
  call Hloop_A_Q(ntryL,G0H8(1),18,nMT,G1H8(3),n2h8(7))
  Gcoeff(:)%j = (c(10)*M(1,:)%j+c(17)*M(2,:)%j) * den(10)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(24),h0tab(:,24),[18,1,8,4],[nMT,0,nMB,0],4,1,wf4(:,10))
  call Hloop_VA_Q(ntryL,G0H32(1),wf4(:,10),G0H8(1),m3h4x8(:,4),heltab2x32(:,:,24))
  call Hloop_A_Q(ntryL,G0H8(1),18,nMT,G1H8(4),n2h8(8))
  Gcoeff(:)%j = (c(17)*M(2,:)%j+c(10)*M(4,:)%j) * den(4)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(25),h0tab(:,25),[20,2,1,8],[0,nMT,0,nMB],4,1,wf4(:,4))
  call Hloop_AQ_V(ntryL,G0H32(1),wf4(:,4),G0H8(1),m3h4x8(:,5),heltab2x32(:,:,25))
  Gcoeff(:)%j = (-(c(12)*M(2,:)%j)+c(15)*M(4,:)%j) * den(4)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(26),h0tab(:,26),[20,1,2,8],[0,nMT,0,nMB],4,1,wf4(:,4))
  call Hloop_AQ_V(ntryL,G0H32(1),wf4(:,4),G0H8(2),m3h4x8(:,6),heltab2x32(:,:,26))
  Gcoeff(:)%j = (-(c(12)*M(3,:)%j)+c(15)*M(4,:)%j) * den(6)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(27),h0tab(:,27),[24,2,1,4],[0,nMT,0,nMB],4,1,wf4(:,6))
  call Hloop_QA_V(ntryL,G0H32(1),wf4(:,6),G0H8(3),m3h4x8(:,7),heltab2x32(:,:,27))
  Gcoeff(:)%j = (c(17)*M(3,:)%j+c(10)*M(4,:)%j) * den(6)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(28),h0tab(:,28),[24,1,2,4],[0,nMT,0,nMB],4,1,wf4(:,6))
  call Hloop_QA_V(ntryL,G0H32(1),wf4(:,6),G0H8(4),m3h4x8(:,8),heltab2x32(:,:,28))
  call Hloop_QV_A(ntryL,G1H16(1),wf4(:,1),G1H4(1),m3h4x4(:,1),heltab2x16(:,:,9))
  call Hloop_Q_A(ntryL,G1H4(1),19,nMB,G2H4(1),n2h4(9))
  call Hloop_UV_W(ntryL,G1H16(2),16,wf4(:,1),3,G2H4(2),m3h4x4(:,2),heltab2x16(:,:,10))
  call Hloop_AV_Q(ntryL,G1H16(3),wf4(:,1),G1H4(2),m3h4x4(:,3),heltab2x16(:,:,11))
  call Hloop_A_Q(ntryL,G1H4(2),19,nMB,G2H4(3),n2h4(10))
  call Hloop_UV_W(ntryL,G1H16(4),16,wf4(:,1),3,G2H4(4),m3h4x4(:,4),heltab2x16(:,:,12))
  call Hloop_AQ_V(ntryL,G1H16(5),ex3(:),G1H8(5),m3h2x8(:,9),heltab2x16(:,:,13))
  call Hloop_VQ_A(ntryL,G1H16(6),ex3(:),G1H8(6),m3h2x8(:,10),heltab2x16(:,:,14))
  call Hloop_Q_A(ntryL,G1H8(6),20,nMB,G2H8(1),n2h8(9))
  call Hloop_AQ_V(ntryL,G1H16(7),ex1(:),G1H8(6),m3h2x8(:,11),heltab2x16(:,:,15))
  call Hloop_VQ_A(ntryL,G1H16(8),ex1(:),G1H8(7),m3h2x8(:,12),heltab2x16(:,:,16))
  call Hloop_Q_A(ntryL,G1H8(7),17,nMT,G2H8(2),n2h8(10))
  call Hloop_QA_V(ntryL,G1H16(9),ex2(:),G1H8(7),m3h2x8(:,13),heltab2x16(:,:,17))
  call Hloop_VA_Q(ntryL,G1H16(10),ex2(:),G1H8(8),m3h2x8(:,14),heltab2x16(:,:,18))
  call Hloop_A_Q(ntryL,G1H8(8),18,nMT,G2H8(3),n2h8(11))
  call Hloop_AQ_V(ntryL,G1H16(11),ex1(:),G1H8(8),m3h2x8(:,15),heltab2x16(:,:,19))
  call Hloop_VQ_A(ntryL,G1H16(12),ex1(:),G1H8(9),m3h2x8(:,16),heltab2x16(:,:,20))
  call Hloop_Q_A(ntryL,G1H8(9),17,nMT,G2H8(4),n2h8(12))
  call Hloop_QA_V(ntryL,G1H8(1),ex2(:),G1H4(5),m3h2x4(:,9),heltab2x8(:,:,9))
  call Hloop_QA_V(ntryL,G1H8(2),ex2(:),G1H4(6),m3h2x4(:,10),heltab2x8(:,:,10))
  call Hloop_AQ_V(ntryL,G1H8(3),ex1(:),G1H4(7),m3h2x4(:,11),heltab2x8(:,:,11))
  call Hloop_AQ_V(ntryL,G1H8(4),ex1(:),G1H4(8),m3h2x4(:,12),heltab2x8(:,:,12))
  call Hloop_VA_Q(ntryL,G0H8(1),ex2(:),G0H4(1),m3h2x4(:,13),heltab2x8(:,:,13))
  call Hloop_A_Q(ntryL,G0H4(1),22,nMT,G1H4(11),n2h4(11))
  call Hloop_VQ_A(ntryL,G0H8(2),ex1(:),G0H4(1),m3h2x4(:,14),heltab2x8(:,:,14))
  call Hloop_Q_A(ntryL,G0H4(1),21,nMT,G1H4(12),n2h4(12))
  call Hloop_VA_Q(ntryL,G0H8(3),ex2(:),G0H4(1),m3h2x4(:,15),heltab2x8(:,:,15))
  call Hloop_A_Q(ntryL,G0H4(1),26,nMT,G1H4(13),n2h4(13))
  call Hloop_VQ_A(ntryL,G0H8(4),ex1(:),G0H4(1),m3h2x4(:,16),heltab2x8(:,:,16))
  call Hloop_Q_A(ntryL,G0H4(1),25,nMT,G1H4(14),n2h4(14))
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(7),[G1H4(3)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(4),[G1H4(16),G1H4(4)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(8),[G1H4(9)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(2),[G1H4(22),G1H4(10)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(5),[G1H4(15)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(6),[G1H4(21)])
  call Hloop_VQ_A(ntryL,G1H4(7),ex3(:),G1H2(5),m3h2x2(:,21),heltab2x4(:,:,21))
  call Hloop_Q_A(ntryL,G1H2(5),23,nMB,G2H2(1),n2h2(13))
  call Hotf_4pt_reduction(G2H4(4),RedSet_4(2),mass4set(:,1),  & 
G1H4(17),G1H4(18),G1H4(19),G1H4(20),G1H4(23),4)
  call HG1shiftOLR(G1H4(18),8,4)
  call Hloop_VA_Q(ntryL,G1H4(8),ex4(:),G1H2(6),m3h2x2(:,22),heltab2x4(:,:,22))
  call Hloop_A_Q(ntryL,G1H2(6),27,nMB,G2H2(2),n2h2(14))
  call Hotf_4pt_reduction(G2H4(2),RedSet_4(7),mass4set(:,1),  & 
G1H4(24),G1H4(1),G1H4(2),G1H4(3),G1H4(16),4)
  call HG1shiftOLR(G1H4(1),4,4)
  call Hloop_VQ_A(ntryL,G1H4(5),ex3(:),G1H2(10),m3h2x2(:,23),heltab2x4(:,:,23))
  call Hloop_Q_A(ntryL,G1H2(10),23,nMB,G2H2(3),n2h2(15))
  call Hloop_VA_Q(ntryL,G1H4(6),ex4(:),G1H2(11),m3h2x2(:,24),heltab2x4(:,:,24))
  call Hloop_A_Q(ntryL,G1H2(11),27,nMB,G2H2(4),n2h2(16))
  call Hloop_QA_V(ntryL,G2H4(1),ex4(:),G2H2(5),m3h2x2(:,25),heltab2x4(:,:,25))
  call Hloop_AQ_V(ntryL,G2H4(3),ex3(:),G2H2(7),m3h2x2(:,26),heltab2x4(:,:,26))
  call Hloop_UV_W(ntryL,G1H8(5),20,wf4(:,1),3,G2H2(8),m3h4x2(:,1),heltab2x8(:,:,17))
  call Hotf_4pt_reduction(G2H8(1),RedSet_4(19),mass4set(:,2),  & 
G1H8(9),G1H8(1),G1H8(2),G1H8(3),G1H8(4),8)
  call HG1shiftOLR(G1H8(1),8,8)
  call Hloop_VA_Q(ntryL,G1H8(6),ex2(:),G1H4(4),m3h2x4(:,17),heltab2x8(:,:,18))
  call Hloop_A_Q(ntryL,G1H4(4),19,nMT,G2H4(5),n2h4(15))
  call Hloop_QA_V(ntryL,G2H8(2),ex2(:),G2H4(6),m3h2x4(:,18),heltab2x8(:,:,19))
  call Hloop_VQ_A(ntryL,G1H8(7),ex1(:),G1H4(9),m3h2x4(:,19),heltab2x8(:,:,20))
  call Hloop_Q_A(ntryL,G1H4(9),19,nMT,G2H4(7),n2h4(16))
  call Hloop_AQ_V(ntryL,G2H8(3),ex1(:),G2H4(8),m3h2x4(:,20),heltab2x8(:,:,21))
  call Hloop_UV_W(ntryL,G1H8(8),17,wf4(:,2),12,G2H2(10),m3h4x2(:,2),heltab2x8(:,:,22))
  call Hotf_4pt_reduction(G2H8(4),RedSet_4(28),mass4set(:,3),  & 
G1H8(5),G1H8(6),G1H8(7),G1H8(8),G1H8(10),8)
  call HG1shiftOLR(G1H8(6),2,8)
  call Hloop_AQ_V(ntryL,G1H4(11),ex1(:),G1H2(12),m3h2x2(:,27),heltab2x4(:,:,27))
  call Hloop_QA_V(ntryL,G1H4(12),ex2(:),G1H2(16),m3h2x2(:,28),heltab2x4(:,:,28))
  call Hloop_AQ_V(ntryL,G1H4(13),ex1(:),G1H2(17),m3h2x2(:,29),heltab2x4(:,:,29))
  call Hloop_QA_V(ntryL,G1H4(14),ex2(:),G1H2(18),m3h2x2(:,30),heltab2x4(:,:,30))
  call Hloop_VQ_A(ntryL,G1H4(17),ex3(:),G1H2(22),m3h2x2(:,31),heltab2x4(:,:,31))
  call Hloop_Q_A(ntryL,G1H2(22),23,nMB,G2H2(11),n2h2(17))
call HGT_raise_alpha_OLR(G1H4(18),1,1,4)
call HGT_raise_alpha_invQ_OLR(G1H4(18),2,5,4)
  call Hloop_VA_Q(ntryL,G1H4(18),ex4(:),G1H2(23),m3h2x2(:,32),heltab2x4(:,:,32))
  call Hloop_VQ_A(ntryL,G1H4(20),ex3(:),G1H2(24),m3h2x2(:,33),heltab2x4(:,:,33))
  call Hloop_Q_A(ntryL,G1H2(24),23,nMB,G2H2(13),n2h2(18))
  call Hloop_VQ_A(ntryL,G1H4(23),ex3(:),G1H2(28),m3h2x2(:,34),heltab2x4(:,:,34))
  call Hloop_Q_A(ntryL,G1H2(28),23,nMB,G2H2(14),n2h2(19))
  call Hloop_VA_Q(ntryL,G1H4(24),ex4(:),G1H2(5),m3h2x2(:,35),heltab2x4(:,:,35))
  call Hloop_A_Q(ntryL,G1H2(5),27,nMB,G2H2(16),n2h2(20))
call HGT_raise_alpha_OLR(G1H4(1),1,1,4)
call HGT_raise_alpha_invQ_OLR(G1H4(1),2,5,4)
  call Hloop_VQ_A(ntryL,G1H4(1),ex3(:),G1H2(6),m3h2x2(:,36),heltab2x4(:,:,36))
  call Hloop_VA_Q(ntryL,G1H4(3),ex4(:),G1H2(10),m3h2x2(:,37),heltab2x4(:,:,37))
  call Hloop_A_Q(ntryL,G1H2(10),27,nMB,G2H2(17),n2h2(21))
  call Hloop_VA_Q(ntryL,G1H4(16),ex4(:),G1H2(11),m3h2x2(:,38),heltab2x4(:,:,38))
  call Hloop_A_Q(ntryL,G1H2(11),27,nMB,G2H2(18),n2h2(22))
  call Hloop_QV_A(ntryL,G1H8(9),wf4(:,1),G1H2(22),m3h4x2(:,3),heltab2x8(:,:,23))
  call Hloop_Q_A(ntryL,G1H2(22),23,nMB,G2H2(19),n2h2(23))
call HGT_raise_alpha_OLR(G1H8(1),1,1,8)
call HGT_raise_alpha_invQ_OLR(G1H8(1),2,5,8)
  call Hloop_VA_Q(ntryL,G1H8(1),ex4(:),G1H4(22),m3h2x4(:,21),heltab2x8(:,:,24))
  call Hloop_QV_A(ntryL,G1H8(3),wf4(:,1),G1H2(24),m3h4x2(:,4),heltab2x8(:,:,25))
  call Hloop_Q_A(ntryL,G1H2(24),23,nMB,G2H2(20),n2h2(24))
  call Hloop_QV_A(ntryL,G1H8(4),wf4(:,1),G1H2(28),m3h4x2(:,5),heltab2x8(:,:,26))
  call Hloop_Q_A(ntryL,G1H2(28),23,nMB,G2H2(21),n2h2(25))
  call Hloop_QV_A(ntryL,G1H8(5),wf4(:,2),G1H2(5),m3h4x2(:,6),heltab2x8(:,:,27))
  call Hloop_Q_A(ntryL,G1H2(5),29,nMT,G2H2(22),n2h2(26))
call HGT_raise_alpha_OLR(G1H8(6),1,1,8)
call HGT_raise_alpha_invQ_OLR(G1H8(6),2,5,8)
  call Hloop_VA_Q(ntryL,G1H8(6),ex2(:),G1H4(10),m3h2x4(:,22),heltab2x8(:,:,28))
  call Hloop_QV_A(ntryL,G1H8(8),wf4(:,2),G1H2(10),m3h4x2(:,7),heltab2x8(:,:,29))
  call Hloop_Q_A(ntryL,G1H2(10),29,nMT,G2H2(23),n2h2(27))
  call Hloop_QV_A(ntryL,G1H8(10),wf4(:,2),G1H2(11),m3h4x2(:,8),heltab2x8(:,:,30))
  call Hloop_Q_A(ntryL,G1H2(11),29,nMT,G2H2(24),n2h2(28))
call HGT_w2_OLR(G1H2(1),1,1,2)
call HGT_w2_invQ_OLR(G1H2(1),2,5,2)
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(1),[G1H2(17)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(12),[G1H2(13)])
call HGT_w2_OLR(G1H2(2),1,1,2)
call HGT_w2_invQ_OLR(G1H2(2),2,5,2)
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(2),[G1H2(12)])
call HGT_w2_OLR(G1H2(3),1,1,2)
call HGT_w2_invQ_OLR(G1H2(3),2,5,2)
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(3),[G1H2(18)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(16),[G1H2(7)])
call HGT_w2_OLR(G1H2(4),1,1,2)
call HGT_w2_invQ_OLR(G1H2(4),2,5,2)
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(4),[G1H2(16)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(8),[G1H2(15),G1H2(9)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(10),[G1H2(27),G1H2(21)])
  call Hloop_VQ_A(ntryL,G1H2(1),ex3(:),G1H1(1),m3h2x1(:,21),heltab2x2(:,:,21))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,nMB,G2tensor(1),n2h1(13))
  call Hcheck_last_QA_V(ntryL,l_switch,G2H2(6),ex4(:),G2tensor(3),m3h2x1(:,22),heltab2x2(:,:,22))
  call Hloop_VA_Q(ntryL,G1H2(2),ex4(:),G1H1(1),m3h2x1(:,23),heltab2x2(:,:,23))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,nMB,G2tensor(5),n2h1(14))
  call Hcheck_last_AQ_V(ntryL,l_switch,G2H2(9),ex3(:),G2tensor(7),m3h2x1(:,24),heltab2x2(:,:,24))
  call Hloop_VQ_A(ntryL,G1H2(3),ex3(:),G1H1(1),m3h2x1(:,25),heltab2x2(:,:,25))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,nMB,G2tensor(9),n2h1(15))
  call Hcheck_last_QA_V(ntryL,l_switch,G2H2(12),ex4(:),G2tensor(12),m3h2x1(:,26),heltab2x2(:,:,26))
  call Hloop_VA_Q(ntryL,G1H2(4),ex4(:),G1H1(1),m3h2x1(:,27),heltab2x2(:,:,27))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,nMB,G2tensor(15),n2h1(16))
  call Hcheck_last_AQ_V(ntryL,l_switch,G2H2(15),ex3(:),G2tensor(18),m3h2x1(:,28),heltab2x2(:,:,28))
  call Hloop_VA_Q(ntryL,G1H2(8),ex4(:),G1H1(1),m3h2x1(:,29),heltab2x2(:,:,29))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,nMB,G2tensor(21),n2h1(17))
  call Hotf_4pt_reduction(G2H2(8),RedSet_4(19),mass4set(:,4),  & 
G1H2(22),G1H2(24),G1H2(28),G1H2(5),G1H2(10),2)
  call HG1shiftOLR(G1H2(24),8,2)
  call Hloop_VA_Q(ntryL,G1H2(14),ex4(:),G1H1(1),m3h2x1(:,30),heltab2x2(:,:,30))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,nMB,G2tensor(22),n2h1(18))
  call Hloop_VA_Q(ntryL,G1H2(19),ex2(:),G1H1(1),m3h2x1(:,31),heltab2x2(:,:,31))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,nMT,G2tensor(23),n2h1(19))
  call Hloop_VA_Q(ntryL,G1H2(20),ex2(:),G1H1(1),m3h2x1(:,32),heltab2x2(:,:,32))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,nMT,G2tensor(24),n2h1(20))
  call Hotf_4pt_reduction(G2H2(10),RedSet_4(28),mass4set(:,5),  & 
G1H2(11),G1H2(17),G1H2(13),G1H2(12),G1H2(18),2)
  call HG1shiftOLR(G1H2(17),2,2)
  call Hloop_VA_Q(ntryL,G1H2(25),ex2(:),G1H1(1),m3h2x1(:,33),heltab2x2(:,:,33))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,nMT,G2tensor(25),n2h1(21))
  call Hloop_VA_Q(ntryL,G1H2(26),ex2(:),G1H1(1),m3h2x1(:,34),heltab2x2(:,:,34))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,nMT,G2tensor(26),n2h1(22))
  call Hcheck_last_QA_V(ntryL,l_switch,G2H2(1),ex4(:),G2tensor(27),m3h2x1(:,35),heltab2x2(:,:,35))
  call Hcheck_last_AQ_V(ntryL,l_switch,G2H2(2),ex3(:),G2tensor(28),m3h2x1(:,36),heltab2x2(:,:,36))
  call Hcheck_last_QA_V(ntryL,l_switch,G2H2(3),ex4(:),G2tensor(29),m3h2x1(:,37),heltab2x2(:,:,37))
  call Hcheck_last_AQ_V(ntryL,l_switch,G2H2(4),ex3(:),G2tensor(30),m3h2x1(:,38),heltab2x2(:,:,38))
  call Hotf_4pt_reduction(G2H2(5),RedSet_4(7),mass4set(:,6),  & 
G1H2(7),G1H2(16),G1H2(15),G1H2(9),G1H2(27),2)
  call HG1shiftOLR(G1H2(16),4,2)
  call Hotf_4pt_reduction(G2H2(7),RedSet_4(2),mass4set(:,6),  & 
G1H2(21),G1H2(1),G1H2(2),G1H2(3),G1H2(4),2)
  call HG1shiftOLR(G1H2(1),8,2)
  call Hotf_4pt_reduction(G2H4(5),RedSet_4(12),mass4set(:,7),  & 
G1H4(15),G1H4(21),G1H4(7),G1H4(8),G1H4(5),4)
  call HG1shiftOLR(G1H4(21),12,4)
  call Hotf_4pt_reduction(G2H4(6),RedSet_4(12),mass4set(:,8),  & 
G1H4(6),G1H4(4),G1H4(9),G1H4(11),G1H4(12),4)
  call HG1shiftOLR(G1H4(4),12,4)
  call Hotf_4pt_reduction(G2H4(7),RedSet_4(4),mass4set(:,7),  & 
G1H4(13),G1H4(14),G1H4(17),G1H4(18),G1H4(20),4)
  call HG1shiftOLR(G1H4(14),12,4)
  call Hotf_4pt_reduction(G2H4(8),RedSet_4(4),mass4set(:,8),  & 
G1H4(23),G1H4(24),G1H4(1),G1H4(3),G1H4(16),4)
  call HG1shiftOLR(G1H4(24),12,4)
  call Hcheck_last_QA_V(ntryL,l_switch,G2H2(11),ex4(:),G2tensor(31),m3h2x1(:,39),heltab2x2(:,:,39))
  call Hcheck_last_QA_V(ntryL,l_switch,G2H2(14),ex4(:),G2tensor(32),m3h2x1(:,40),heltab2x2(:,:,40))
  call Hcheck_last_AQ_V(ntryL,l_switch,G2H2(16),ex3(:),G2tensor(33),m3h2x1(:,41),heltab2x2(:,:,41))
  call Hcheck_last_AQ_V(ntryL,l_switch,G2H2(18),ex3(:),G2tensor(34),m3h2x1(:,42),heltab2x2(:,:,42))
  call Hcheck_last_QA_V(ntryL,l_switch,G2H2(19),ex4(:),G2tensor(35),m3h2x1(:,43),heltab2x2(:,:,43))
  call Hcheck_last_QA_V(ntryL,l_switch,G2H2(21),ex4(:),G2tensor(36),m3h2x1(:,44),heltab2x2(:,:,44))
  call Hcheck_last_QA_V(ntryL,l_switch,G2H2(22),ex2(:),G2tensor(37),m3h2x1(:,45),heltab2x2(:,:,45))
  call Hcheck_last_QA_V(ntryL,l_switch,G2H2(24),ex2(:),G2tensor(38),m3h2x1(:,46),heltab2x2(:,:,46))
  call Hloop_VA_Q(ntryL,G1H2(22),ex4(:),G1H1(1),m3h2x1(:,47),heltab2x2(:,:,47))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,nMB,G2tensor(39),n2h1(23))
  call Hloop_VA_Q(ntryL,G1H2(24),ex4(:),G1H1(1),m3h2x1(:,48),heltab2x2(:,:,48))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),8,nMB,G2tensor(40),n2h1(24))
  call Hloop_VA_Q(ntryL,G1H2(10),ex4(:),G1H1(1),m3h2x1(:,49),heltab2x2(:,:,49))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,nMB,G2tensor(41),n2h1(25))
  call Hloop_VA_Q(ntryL,G1H2(11),ex2(:),G1H1(1),m3h2x1(:,50),heltab2x2(:,:,50))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,nMT,G2tensor(42),n2h1(26))
  call Hloop_VA_Q(ntryL,G1H2(17),ex2(:),G1H1(1),m3h2x1(:,51),heltab2x2(:,:,51))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),2,nMT,G2tensor(43),n2h1(27))
  call Hloop_VA_Q(ntryL,G1H2(18),ex2(:),G1H1(1),m3h2x1(:,52),heltab2x2(:,:,52))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,nMT,G2tensor(44),n2h1(28))
  call Hloop_VQ_A(ntryL,G1H2(7),ex3(:),G1H1(1),m3h2x1(:,53),heltab2x2(:,:,53))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,nMB,G2tensor(45),n2h1(29))
  call Hloop_VQ_A(ntryL,G1H2(16),ex3(:),G1H1(1),m3h2x1(:,54),heltab2x2(:,:,54))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),4,nMB,G2tensor(46),n2h1(30))
  call Hloop_VQ_A(ntryL,G1H2(27),ex3(:),G1H1(1),m3h2x1(:,55),heltab2x2(:,:,55))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,nMB,G2tensor(47),n2h1(31))
  call Hloop_VA_Q(ntryL,G1H2(21),ex4(:),G1H1(1),m3h2x1(:,56),heltab2x2(:,:,56))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,nMB,G2tensor(48),n2h1(32))
  call Hloop_VA_Q(ntryL,G1H2(1),ex4(:),G1H1(1),m3h2x1(:,57),heltab2x2(:,:,57))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),8,nMB,G2tensor(49),n2h1(33))
  call Hloop_VA_Q(ntryL,G1H2(4),ex4(:),G1H1(1),m3h2x1(:,58),heltab2x2(:,:,58))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,nMB,G2tensor(50),n2h1(34))
  call Hloop_AV_Q(ntryL,G1H4(15),wf4(:,2),G1H1(1),m3h4x1(:,1),heltab2x4(:,:,39))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,nMT,G2tensor(51),n2h1(35))
  call Hloop_AV_Q(ntryL,G1H4(21),wf4(:,2),G1H1(1),m3h4x1(:,2),heltab2x4(:,:,40))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),12,nMT,G2tensor(52),n2h1(36))
  call Hloop_AV_Q(ntryL,G1H4(5),wf4(:,2),G1H1(1),m3h4x1(:,3),heltab2x4(:,:,41))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,nMT,G2tensor(53),n2h1(37))
  call Hcheck_last_UV_W(ntryL,l_switch,G1H4(6),19,wf4(:,2),12,G2tensor(54),m3h4x1(:,4),heltab2x4(:,:,42))
  call Hcheck_last_UV_W(ntryL,l_switch,G1H4(4),0,wf4(:,2),12,G2tensor(55),m3h4x1(:,5),heltab2x4(:,:,43))
  call Hcheck_last_UV_W(ntryL,l_switch,G1H4(12),19,wf4(:,2),12,G2tensor(56),m3h4x1(:,6),heltab2x4(:,:,44))
  call Hloop_QV_A(ntryL,G1H4(13),wf4(:,2),G1H1(1),m3h4x1(:,7),heltab2x4(:,:,45))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,nMT,G2tensor(57),n2h1(39))
  call Hloop_QV_A(ntryL,G1H4(14),wf4(:,2),G1H1(1),m3h4x1(:,8),heltab2x4(:,:,46))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),12,nMT,G2tensor(58),n2h1(40))
  call Hloop_QV_A(ntryL,G1H4(20),wf4(:,2),G1H1(1),m3h4x1(:,9),heltab2x4(:,:,47))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,nMT,G2tensor(59),n2h1(41))
  call Hcheck_last_UV_W(ntryL,l_switch,G1H4(23),19,wf4(:,2),12,G2tensor(60),m3h4x1(:,10),heltab2x4(:,:,48))
  call Hcheck_last_UV_W(ntryL,l_switch,G1H4(24),0,wf4(:,2),12,G2tensor(61),m3h4x1(:,11),heltab2x4(:,:,49))
  call Hcheck_last_UV_W(ntryL,l_switch,G1H4(16),19,wf4(:,2),12,G2tensor(62),m3h4x1(:,12),heltab2x4(:,:,50))
  call ol_merge_tensors(G2tensor(60),[G2tensor(4),G2tensor(2),G1tensor(12),G1tensor(6)])
  call ol_merge_tensors(G2tensor(54),[G2tensor(8),G2tensor(6),G1tensor(24),G1tensor(18)])
  call ol_merge_tensors(G2tensor(10),[G1tensor(26)])
  call ol_merge_tensors(G2tensor(11),[G1tensor(30)])
  call ol_merge_tensors(G2tensor(13),[G1tensor(32)])
  call ol_merge_tensors(G2tensor(14),[G1tensor(36)])
  call ol_merge_tensors(G2tensor(27),[G2tensor(16),G1tensor(38),G1tensor(3)])
  call ol_merge_tensors(G2tensor(17),[G1tensor(42)])
  call ol_merge_tensors(G2tensor(28),[G2tensor(19),G1tensor(44),G1tensor(9)])
  call ol_merge_tensors(G2tensor(20),[G1tensor(48)])
  call ol_merge_tensors(G2tensor(1),[G1tensor(2)])
  call ol_merge_tensors(G2tensor(31),[G1tensor(16),G1tensor(4)])
  call ol_merge_tensors(G2tensor(3),[G1tensor(5)])
  call ol_merge_tensors(G2tensor(5),[G1tensor(33),G1tensor(8)])
  call ol_merge_tensors(G2tensor(33),[G1tensor(22),G1tensor(10)])
  call ol_merge_tensors(G2tensor(7),[G1tensor(11)])
  call ol_merge_tensors(G2tensor(9),[G1tensor(14)])
  call ol_merge_tensors(G2tensor(29),[G1tensor(15)])
  call ol_merge_tensors(G2tensor(12),[G1tensor(17)])
  call ol_merge_tensors(G2tensor(15),[G1tensor(27),G1tensor(20)])
  call ol_merge_tensors(G2tensor(30),[G1tensor(21)])
  call ol_merge_tensors(G2tensor(18),[G1tensor(23)])
  call ol_merge_tensors(G2tensor(21),[G1tensor(28)])
  call ol_merge_tensors(G2tensor(39),[G1tensor(35),G1tensor(29)])
  call ol_merge_tensors(G2tensor(22),[G1tensor(34)])
  call ol_merge_tensors(G2tensor(23),[G1tensor(39)])
  call ol_merge_tensors(G2tensor(24),[G1tensor(40)])
  call ol_merge_tensors(G2tensor(42),[G1tensor(47),G1tensor(41)])
  call ol_merge_tensors(G2tensor(25),[G1tensor(45)])
  call ol_merge_tensors(G2tensor(26),[G1tensor(46)])
  call Hotf_4pt_reduction_last(G2tensor(60),RedSet_4(4),mass4set(:,8),  & 
G1tensor(1),G1tensor(7),G1tensor(13),G1tensor(19),G1tensor(25))
  call G_TensorShift(G1tensor(7),12)
  call Hotf_4pt_reduction_last(G2tensor(54),RedSet_4(12),mass4set(:,8),  & 
G1tensor(31),G1tensor(37),G1tensor(43),G1tensor(12),G1tensor(6))
  call G_TensorShift(G1tensor(37),12)
  call Hotf_4pt_reduction_last(G2tensor(10),RedSet_4(35),mass4set(:,9),  & 
G1tensor(24),G1tensor(18),G1tensor(26),G1tensor(30),G1tensor(32))
  call G_TensorShift(G1tensor(18),2)
  call Hotf_4pt_reduction_last(G2tensor(11),RedSet_4(20),mass4set(:,10),  & 
G1tensor(36),G1tensor(38),G1tensor(3),G1tensor(42),G1tensor(44))
  call G_TensorShift(G1tensor(38),10)
  call Hotf_4pt_reduction_last(G2tensor(13),RedSet_4(36),mass4set(:,9),  & 
G1tensor(9),G1tensor(48),G1tensor(2),G1tensor(16),G1tensor(4))
  call G_TensorShift(G1tensor(48),1)
  call Hotf_4pt_reduction_last(G2tensor(14),RedSet_4(24),mass4set(:,10),  & 
G1tensor(5),G1tensor(33),G1tensor(8),G1tensor(22),G1tensor(10))
  call G_TensorShift(G1tensor(33),9)
  call Hotf_4pt_reduction_last(G2tensor(27),RedSet_4(1),mass4set(:,11),  & 
G1tensor(11),G1tensor(14),G1tensor(15),G1tensor(17),G1tensor(27))
  call G_TensorShift(G1tensor(14),8)
  call Hotf_4pt_reduction_last(G2tensor(17),RedSet_4(29),mass4set(:,12),  & 
G1tensor(20),G1tensor(21),G1tensor(23),G1tensor(28),G1tensor(35))
  call G_TensorShift(G1tensor(21),10)
  call Hotf_4pt_reduction_last(G2tensor(28),RedSet_4(6),mass4set(:,11),  & 
G1tensor(29),G1tensor(34),G1tensor(39),G1tensor(40),G1tensor(47))
  call G_TensorShift(G1tensor(34),4)
  call Hotf_4pt_reduction_last(G2tensor(20),RedSet_4(33),mass4set(:,12),  & 
G1tensor(41),G1tensor(45),G1tensor(46),G1tensor(49),G1tensor(50))
  call G_TensorShift(G1tensor(45),6)
  call Hotf_4pt_reduction_last(G2tensor(1),RedSet_4(37),mass4set(:,13),  & 
G1tensor(51),G1tensor(52),G1tensor(53),G1tensor(54),G1tensor(55))
  call G_TensorShift(G1tensor(52),4)
  call Hotf_4pt_reduction_last(G2tensor(31),RedSet_4(2),mass4set(:,1),  & 
G1tensor(56),G1tensor(57),G1tensor(58),G1tensor(59),G1tensor(60))
  call G_TensorShift(G1tensor(57),8)
  call Hotf_4pt_reduction_last(G2tensor(3),RedSet_4(3),mass4set(:,14),  & 
G1tensor(61),G1tensor(62),G1tensor(63),G1tensor(64),G1tensor(65))
  call G_TensorShift(G1tensor(62),8)
  call Hotf_4pt_reduction_last(G2tensor(5),RedSet_4(22),mass4set(:,13),  & 
G1tensor(66),G1tensor(67),G1tensor(68),G1tensor(69),G1tensor(70))
  call G_TensorShift(G1tensor(67),8)
  call Hotf_4pt_reduction_last(G2tensor(33),RedSet_4(7),mass4set(:,1),  & 
G1tensor(71),G1tensor(72),G1tensor(73),G1tensor(74),G1tensor(75))
  call G_TensorShift(G1tensor(72),4)
  call Hotf_4pt_reduction_last(G2tensor(7),RedSet_4(8),mass4set(:,14),  & 
G1tensor(76),G1tensor(77),G1tensor(78),G1tensor(79),G1tensor(80))
  call G_TensorShift(G1tensor(77),4)
  call Hotf_4pt_reduction_last(G2tensor(9),RedSet_4(38),mass4set(:,13),  & 
G1tensor(81),G1tensor(82),G1tensor(83),G1tensor(84),G1tensor(85))
  call G_TensorShift(G1tensor(82),4)
  call Hotf_4pt_reduction_last(G2tensor(29),RedSet_4(10),mass4set(:,11),  & 
G1tensor(86),G1tensor(87),G1tensor(88),G1tensor(89),G1tensor(90))
  call G_TensorShift(G1tensor(87),8)
  call Hotf_4pt_reduction_last(G2tensor(12),RedSet_4(11),mass4set(:,14),  & 
G1tensor(91),G1tensor(92),G1tensor(93),G1tensor(94),G1tensor(95))
  call G_TensorShift(G1tensor(92),8)
  call Hotf_4pt_reduction_last(G2tensor(15),RedSet_4(17),mass4set(:,13),  & 
G1tensor(96),G1tensor(97),G1tensor(98),G1tensor(99),G1tensor(100))
  call G_TensorShift(G1tensor(97),8)
  call Hotf_4pt_reduction_last(G2tensor(30),RedSet_4(14),mass4set(:,11),  & 
G1tensor(101),G1tensor(102),G1tensor(103),G1tensor(104),G1tensor(105))
  call G_TensorShift(G1tensor(102),4)
  call Hotf_4pt_reduction_last(G2tensor(18),RedSet_4(15),mass4set(:,14),  & 
G1tensor(106),G1tensor(107),G1tensor(108),G1tensor(109),G1tensor(110))
  call G_TensorShift(G1tensor(107),4)
  call Hotf_4pt_reduction_last(G2tensor(21),RedSet_4(18),mass4set(:,15),  & 
G1tensor(111),G1tensor(112),G1tensor(113),G1tensor(114),G1tensor(115))
  call G_TensorShift(G1tensor(112),8)
  call Hotf_4pt_reduction_last(G2tensor(39),RedSet_4(19),mass4set(:,4),  & 
G1tensor(116),G1tensor(117),G1tensor(118),G1tensor(119),G1tensor(120))
  call G_TensorShift(G1tensor(117),8)
  call Hotf_4pt_reduction_last(G2tensor(22),RedSet_4(23),mass4set(:,15),  & 
G1tensor(121),G1tensor(122),G1tensor(123),G1tensor(124),G1tensor(125))
  call G_TensorShift(G1tensor(122),8)
  call Hotf_4pt_reduction_last(G2tensor(23),RedSet_4(26),mass4set(:,16),  & 
G1tensor(126),G1tensor(127),G1tensor(128),G1tensor(129),G1tensor(130))
  call G_TensorShift(G1tensor(127),2)
  call Hotf_4pt_reduction_last(G2tensor(24),RedSet_4(27),mass4set(:,17),  & 
G1tensor(131),G1tensor(132),G1tensor(133),G1tensor(134),G1tensor(135))
  call G_TensorShift(G1tensor(132),2)
  call Hotf_4pt_reduction_last(G2tensor(42),RedSet_4(28),mass4set(:,5),  & 
G1tensor(136),G1tensor(137),G1tensor(138),G1tensor(139),G1tensor(140))
  call G_TensorShift(G1tensor(137),2)
  call Hotf_4pt_reduction_last(G2tensor(25),RedSet_4(31),mass4set(:,16),  & 
G1tensor(141),G1tensor(142),G1tensor(143),G1tensor(144),G1tensor(145))
  call G_TensorShift(G1tensor(142),2)
  call Hotf_4pt_reduction_last(G2tensor(26),RedSet_4(32),mass4set(:,17),  & 
G1tensor(146),G1tensor(147),G1tensor(148),G1tensor(149),G1tensor(150))
  call G_TensorShift(G1tensor(147),2)
  call Hotf_4pt_reduction_last(G2tensor(35),RedSet_4(19),mass4set(:,2),  & 
G1tensor(151),G1tensor(152),G1tensor(153),G1tensor(154),G1tensor(155))
  call G_TensorShift(G1tensor(152),8)
  call Hotf_4pt_reduction_last(G2tensor(37),RedSet_4(28),mass4set(:,3),  & 
G1tensor(156),G1tensor(157),G1tensor(158),G1tensor(159),G1tensor(160))
  call G_TensorShift(G1tensor(157),2)
  call Hotf_4pt_reduction_last(G2tensor(45),RedSet_4(7),mass4set(:,6),  & 
G1tensor(161),G1tensor(162),G1tensor(163),G1tensor(164),G1tensor(165))
  call G_TensorShift(G1tensor(162),4)
  call Hotf_4pt_reduction_last(G2tensor(48),RedSet_4(2),mass4set(:,6),  & 
G1tensor(166),G1tensor(167),G1tensor(168),G1tensor(169),G1tensor(170))
  call G_TensorShift(G1tensor(167),8)
  call Hotf_4pt_reduction_last(G2tensor(51),RedSet_4(12),mass4set(:,7),  & 
G1tensor(171),G1tensor(172),G1tensor(173),G1tensor(174),G1tensor(175))
  call G_TensorShift(G1tensor(172),12)
  call Hotf_4pt_reduction_last(G2tensor(57),RedSet_4(4),mass4set(:,7),  & 
G1tensor(176),G1tensor(177),G1tensor(178),G1tensor(179),G1tensor(180))
  call G_TensorShift(G1tensor(177),12)
  call Hotf_4pt_reduction_last(G1tensor(1),RedSet_4(4),mass4set(:,8),  & 
G0tensor(1),G0tensor(2),G0tensor(3),G0tensor(4),G0tensor(5))
  call Hotf_4pt_reduction_last(G1tensor(31),RedSet_4(12),mass4set(:,8),  & 
G0tensor(6),G0tensor(7),G0tensor(8),G0tensor(9),G0tensor(10))
  call Hotf_4pt_reduction_last(G1tensor(24),RedSet_4(35),mass4set(:,9),  & 
G0tensor(11),G0tensor(12),G0tensor(13),G0tensor(14),G0tensor(15))
  call Hotf_4pt_reduction_last(G1tensor(36),RedSet_4(20),mass4set(:,10),  & 
G0tensor(16),G0tensor(17),G0tensor(18),G0tensor(19),G0tensor(20))
  call Hotf_4pt_reduction_last(G1tensor(9),RedSet_4(36),mass4set(:,9),  & 
G0tensor(21),G0tensor(22),G0tensor(23),G0tensor(24),G0tensor(25))
  call Hotf_4pt_reduction_last(G1tensor(5),RedSet_4(24),mass4set(:,10),  & 
G0tensor(26),G0tensor(27),G0tensor(28),G0tensor(29),G0tensor(30))
  call Hotf_4pt_reduction_last(G1tensor(11),RedSet_4(1),mass4set(:,11),  & 
G0tensor(31),G0tensor(32),G0tensor(33),G0tensor(34),G0tensor(35))
  call Hotf_4pt_reduction_last(G1tensor(20),RedSet_4(29),mass4set(:,12),  & 
G0tensor(36),G0tensor(37),G0tensor(38),G0tensor(39),G0tensor(40))
  call Hotf_4pt_reduction_last(G1tensor(29),RedSet_4(6),mass4set(:,11),  & 
G0tensor(41),G0tensor(42),G0tensor(43),G0tensor(44),G0tensor(45))
  call Hotf_4pt_reduction_last(G1tensor(41),RedSet_4(33),mass4set(:,12),  & 
G0tensor(46),G0tensor(47),G0tensor(48),G0tensor(49),G0tensor(50))
  call Hotf_4pt_reduction_last(G1tensor(51),RedSet_4(37),mass4set(:,13),  & 
G0tensor(51),G0tensor(52),G0tensor(53),G0tensor(54),G0tensor(55))
  call Hotf_4pt_reduction_last(G1tensor(56),RedSet_4(2),mass4set(:,1),  & 
G0tensor(56),G0tensor(57),G0tensor(58),G0tensor(59),G0tensor(60))
  call Hotf_4pt_reduction_last(G1tensor(61),RedSet_4(3),mass4set(:,14),  & 
G0tensor(61),G0tensor(62),G0tensor(63),G0tensor(64),G0tensor(65))
  call Hotf_4pt_reduction_last(G1tensor(66),RedSet_4(22),mass4set(:,13),  & 
G0tensor(66),G0tensor(67),G0tensor(68),G0tensor(69),G0tensor(70))
  call Hotf_4pt_reduction_last(G1tensor(71),RedSet_4(7),mass4set(:,1),  & 
G0tensor(71),G0tensor(72),G0tensor(73),G0tensor(74),G0tensor(75))
  call Hotf_4pt_reduction_last(G1tensor(76),RedSet_4(8),mass4set(:,14),  & 
G0tensor(76),G0tensor(77),G0tensor(78),G0tensor(79),G0tensor(80))
  call Hotf_4pt_reduction_last(G1tensor(81),RedSet_4(38),mass4set(:,13),  & 
G0tensor(81),G0tensor(82),G0tensor(83),G0tensor(84),G0tensor(85))
  call Hotf_4pt_reduction_last(G1tensor(86),RedSet_4(10),mass4set(:,11),  & 
G0tensor(86),G0tensor(87),G0tensor(88),G0tensor(89),G0tensor(90))
  call Hotf_4pt_reduction_last(G1tensor(91),RedSet_4(11),mass4set(:,14),  & 
G0tensor(91),G0tensor(92),G0tensor(93),G0tensor(94),G0tensor(95))
  call Hotf_4pt_reduction_last(G1tensor(96),RedSet_4(17),mass4set(:,13),  & 
G0tensor(96),G0tensor(97),G0tensor(98),G0tensor(99),G0tensor(100))
  call Hotf_4pt_reduction_last(G1tensor(101),RedSet_4(14),mass4set(:,11),  & 
G0tensor(101),G0tensor(102),G0tensor(103),G0tensor(104),G0tensor(105))
  call Hotf_4pt_reduction_last(G1tensor(106),RedSet_4(15),mass4set(:,14),  & 
G0tensor(106),G0tensor(107),G0tensor(108),G0tensor(109),G0tensor(110))
  call Hotf_4pt_reduction_last(G1tensor(111),RedSet_4(18),mass4set(:,15),  & 
G0tensor(111),G0tensor(112),G0tensor(113),G0tensor(114),G0tensor(115))
  call Hotf_4pt_reduction_last(G1tensor(116),RedSet_4(19),mass4set(:,4),  & 
G0tensor(116),G0tensor(117),G0tensor(118),G0tensor(119),G0tensor(120))
  call Hotf_4pt_reduction_last(G1tensor(121),RedSet_4(23),mass4set(:,15),  & 
G0tensor(121),G0tensor(122),G0tensor(123),G0tensor(124),G0tensor(125))
  call Hotf_4pt_reduction_last(G1tensor(126),RedSet_4(26),mass4set(:,16),  & 
G0tensor(126),G0tensor(127),G0tensor(128),G0tensor(129),G0tensor(130))
  call Hotf_4pt_reduction_last(G1tensor(131),RedSet_4(27),mass4set(:,17),  & 
G0tensor(131),G0tensor(132),G0tensor(133),G0tensor(134),G0tensor(135))
  call Hotf_4pt_reduction_last(G1tensor(136),RedSet_4(28),mass4set(:,5),  & 
G0tensor(136),G0tensor(137),G0tensor(138),G0tensor(139),G0tensor(140))
  call Hotf_4pt_reduction_last(G1tensor(141),RedSet_4(31),mass4set(:,16),  & 
G0tensor(141),G0tensor(142),G0tensor(143),G0tensor(144),G0tensor(145))
  call Hotf_4pt_reduction_last(G1tensor(146),RedSet_4(32),mass4set(:,17),  & 
G0tensor(146),G0tensor(147),G0tensor(148),G0tensor(149),G0tensor(150))
  call Hotf_4pt_reduction_last(G1tensor(151),RedSet_4(19),mass4set(:,2),  & 
G0tensor(151),G0tensor(152),G0tensor(153),G0tensor(154),G0tensor(155))
  call Hotf_4pt_reduction_last(G1tensor(156),RedSet_4(28),mass4set(:,3),  & 
G0tensor(156),G0tensor(157),G0tensor(158),G0tensor(159),G0tensor(160))
  call Hotf_4pt_reduction_last(G1tensor(161),RedSet_4(7),mass4set(:,6),  & 
G0tensor(161),G0tensor(162),G0tensor(163),G0tensor(164),G0tensor(165))
  call Hotf_4pt_reduction_last(G1tensor(166),RedSet_4(2),mass4set(:,6),  & 
G0tensor(166),G0tensor(167),G0tensor(168),G0tensor(169),G0tensor(170))
  call Hotf_4pt_reduction_last(G1tensor(171),RedSet_4(12),mass4set(:,7),  & 
G0tensor(171),G0tensor(172),G0tensor(173),G0tensor(174),G0tensor(175))
  call Hotf_4pt_reduction_last(G1tensor(176),RedSet_4(4),mass4set(:,7),  & 
G0tensor(176),G0tensor(177),G0tensor(178),G0tensor(179),G0tensor(180))
  call ol_merge_tensors(T0sum(1),[G0tensor(1)])
  call ol_merge_tensors(T0sum(2),[G0tensor(6)])
  call ol_merge_tensors(T0sum(3),[G0tensor(11)])
  call ol_merge_tensors(T0sum(4),[G0tensor(16)])
  call ol_merge_tensors(T0sum(5),[G0tensor(21)])
  call ol_merge_tensors(T0sum(6),[G0tensor(26)])
  call ol_merge_tensors(T0sum(7),[G0tensor(31)])
  call ol_merge_tensors(T0sum(8),[G0tensor(36)])
  call ol_merge_tensors(T0sum(9),[G0tensor(41)])
  call ol_merge_tensors(T0sum(10),[G0tensor(46)])
  call ol_merge_tensors(T0sum(11),[G0tensor(51)])
  call ol_merge_tensors(T0sum(12),[G0tensor(56)])
  call ol_merge_tensors(T0sum(13),[G0tensor(61)])
  call ol_merge_tensors(T0sum(14),[G0tensor(66)])
  call ol_merge_tensors(T0sum(15),[G0tensor(71)])
  call ol_merge_tensors(T0sum(16),[G0tensor(76)])
  call ol_merge_tensors(T0sum(17),[G0tensor(81)])
  call ol_merge_tensors(T0sum(18),[G0tensor(86)])
  call ol_merge_tensors(T0sum(19),[G0tensor(91)])
  call ol_merge_tensors(T0sum(20),[G0tensor(96)])
  call ol_merge_tensors(T0sum(21),[G0tensor(101)])
  call ol_merge_tensors(T0sum(22),[G0tensor(106)])
  call ol_merge_tensors(T0sum(23),[G0tensor(111)])
  call ol_merge_tensors(T0sum(24),[G0tensor(116)])
  call ol_merge_tensors(T0sum(25),[G0tensor(121)])
  call ol_merge_tensors(T0sum(26),[G0tensor(126)])
  call ol_merge_tensors(T0sum(27),[G0tensor(131)])
  call ol_merge_tensors(T0sum(28),[G0tensor(136)])
  call ol_merge_tensors(T0sum(29),[G0tensor(141)])
  call ol_merge_tensors(T0sum(30),[G0tensor(146)])
  call ol_merge_tensors(T0sum(31),[G0tensor(151)])
  call ol_merge_tensors(T0sum(32),[G0tensor(156)])
  call ol_merge_tensors(T0sum(33),[G0tensor(161)])
  call ol_merge_tensors(T0sum(34),[G0tensor(166)])
  call ol_merge_tensors(T0sum(35),[G0tensor(171)])
  call ol_merge_tensors(T0sum(36),[G0tensor(176)])
  Gcoeff(:)%j = (c(19)*M(3,:)%j+c(14)*(M(1,:)%j-M(4,:)%j)) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(29),h0tab(:,29),[19,4,8],[0,nMB,0],4,1,wf4(:,1))
  call Hloop_GGG_G_12(ntryL,G0H32(1),ex5(:),wf4(:,1),G0H4(1),m4h2x4x4(:,1),heltab3x32(:,:,1))
  Gcoeff(:)%j = (c(19)*M(2,:)%j+c(14)*(M(1,:)%j-M(4,:)%j)) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(30),h0tab(:,30),[19,4,8],[0,nMB,0],4,1,wf4(:,1))
  call Hloop_GGG_G_12(ntryL,G0H32(1),wf4(:,1),ex5(:),G0H4(2),m4h4x2x4(:,1),heltab3x32(:,:,2))
  Gcoeff(:)%j = (c(19)*(M(2,:)%j-M(3,:)%j)) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(31),h0tab(:,31),[19,4,8],[0,nMB,0],4,1,wf4(:,1))
  call Hloop_GGG_G_23(ntryL,G0H32(1),ex5(:),wf4(:,1),G0H4(3),m4h2x4x4(:,2),heltab3x32(:,:,3))
  Gcoeff(:)%j = (c(19)*M(2,:)%j+c(14)*(-M(1,:)%j+M(4,:)%j)) * den(2)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(32),h0tab(:,32),[28,1,2],[0,nMT,0],4,1,wf4(:,2))
  call Hloop_GGG_G_12(ntryL,G0H32(1),ex5(:),wf4(:,2),G0H4(4),m4h2x4x4(:,3),heltab3x32(:,:,4))
  Gcoeff(:)%j = (c(19)*M(3,:)%j+c(14)*(-M(1,:)%j+M(4,:)%j)) * den(2)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(33),h0tab(:,33),[28,1,2],[0,nMT,0],4,1,wf4(:,2))
  call Hloop_GGG_G_12(ntryL,G0H32(1),wf4(:,2),ex5(:),G0H4(5),m4h4x2x4(:,2),heltab3x32(:,:,5))
  Gcoeff(:)%j = (c(19)*(-M(2,:)%j+M(3,:)%j)) * den(2)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(34),h0tab(:,34),[28,1,2],[0,nMT,0],4,1,wf4(:,2))
  call Hloop_GGG_G_23(ntryL,G0H32(1),ex5(:),wf4(:,2),G0H4(6),m4h2x4x4(:,4),heltab3x32(:,:,6))
  Gcoeff(:)%j = (-(c(26)*M(3,:)%j)+c(25)*(M(1,:)%j+M(4,:)%j)) * den(3)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(35),h0tab(:,35),[16,3,12],[0,0,0],3,2,wf4(:,1),wf4(:,2))
  call Hloop_AV_Q(ntryL,G0H32(1),ex5(:),G0H16(1),m3h2x16(:,21),heltab2x32(:,:,29))
  call Hloop_A_Q(ntryL,G0H16(1),16,0,G1H16(1),n2h16(11))
  Gcoeff(:)%j = (-(c(24)*M(3,:)%j)+c(23)*(M(1,:)%j+M(4,:)%j)) * den(3)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(36),h0tab(:,36),[16,3,12],[nMT,nMT,nMT],3,2,wf4(:,1),wf4(:,2))
  call Hloop_AV_Q(ntryL,G0H32(1),ex5(:),G0H16(1),m3h2x16(:,22),heltab2x32(:,:,30))
  call Hloop_A_Q(ntryL,G0H16(1),16,nMT,G1H16(2),n2h16(12))
  Gcoeff(:)%j = (-(c(26)*M(2,:)%j)+c(25)*(M(1,:)%j+M(4,:)%j)) * den(3)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(37),h0tab(:,37),[16,3,12],[0,0,0],3,2,wf4(:,1),wf4(:,2))
  call Hloop_QV_A(ntryL,G0H32(1),ex5(:),G0H16(1),m3h2x16(:,23),heltab2x32(:,:,31))
  call Hloop_Q_A(ntryL,G0H16(1),16,0,G1H16(3),n2h16(13))
  Gcoeff(:)%j = (-(c(24)*M(2,:)%j)+c(23)*(M(1,:)%j+M(4,:)%j)) * den(3)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(38),h0tab(:,38),[16,3,12],[nMT,nMT,nMT],3,2,wf4(:,1),wf4(:,2))
  call Hloop_QV_A(ntryL,G0H32(1),ex5(:),G0H16(1),m3h2x16(:,24),heltab2x32(:,:,32))
  call Hloop_Q_A(ntryL,G0H16(1),16,nMT,G1H16(4),n2h16(14))
  Gcoeff(:)%j = (-(c(26)*M(3,:)%j)+c(25)*(M(1,:)%j+M(4,:)%j)) * den(3)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(39),h0tab(:,39),[16,3,12],[0,0,0],3,2,wf4(:,1),wf4(:,2))
  call Hloop_AV_Q(ntryL,G0H32(1),ex5(:),G0H16(1),m3h2x16(:,25),heltab2x32(:,:,33))
  call Hloop_A_Q(ntryL,G0H16(1),16,0,G1H16(5),n2h16(15))
  Gcoeff(:)%j = (-(c(24)*M(3,:)%j)+c(23)*(M(1,:)%j+M(4,:)%j)) * den(3)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(40),h0tab(:,40),[16,3,12],[nMB,nMB,nMB],3,2,wf4(:,1),wf4(:,2))
  call Hloop_AV_Q(ntryL,G0H32(1),ex5(:),G0H16(1),m3h2x16(:,26),heltab2x32(:,:,34))
  call Hloop_A_Q(ntryL,G0H16(1),16,nMB,G1H16(6),n2h16(16))
  Gcoeff(:)%j = (-(c(26)*M(2,:)%j)+c(25)*(M(1,:)%j+M(4,:)%j)) * den(3)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(41),h0tab(:,41),[16,3,12],[0,0,0],3,2,wf4(:,1),wf4(:,2))
  call Hloop_QV_A(ntryL,G0H32(1),ex5(:),G0H16(1),m3h2x16(:,27),heltab2x32(:,:,35))
  call Hloop_Q_A(ntryL,G0H16(1),16,0,G1H16(7),n2h16(17))
  Gcoeff(:)%j = (-(c(24)*M(2,:)%j)+c(23)*(M(1,:)%j+M(4,:)%j)) * den(3)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(42),h0tab(:,42),[16,3,12],[nMB,nMB,nMB],3,2,wf4(:,1),wf4(:,2))
  call Hloop_QV_A(ntryL,G0H32(1),ex5(:),G0H16(1),m3h2x16(:,28),heltab2x32(:,:,36))
  call Hloop_Q_A(ntryL,G0H16(1),16,nMB,G1H16(8),n2h16(18))
  Gcoeff(:)%j = (c(6)*(-M(2,:)%j+M(3,:)%j)) * den(3)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(43),h0tab(:,43),[16,3,12],[0,0,0],3,2,wf4(:,1),wf4(:,2))
  call Hloop_DV_C(ntryL,G0H32(1),0,ex5(:),G1H16(9),m3h2x16(:,29),heltab2x32(:,:,37))
  Gcoeff(:)%j = (c(6)*(M(2,:)%j-M(3,:)%j)) * den(3)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(44),h0tab(:,44),[16,3,12],[0,0,0],3,2,wf4(:,1),wf4(:,2))
  call Hloop_CV_D(ntryL,G0H32(1),0,ex5(:),16,G1H16(10),m3h2x16(:,30),heltab2x32(:,:,38))
  Gcoeff(:)%j = (c(6)*(M(2,:)%j-M(3,:)%j)) * den(3)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(45),h0tab(:,45),[16,3,12],[0,0,0],3,2,wf4(:,1),wf4(:,2))
  call Hloop_UV_W(ntryL,G0H32(1),0,ex5(:),16,G1H16(11),m3h2x16(:,31),heltab2x32(:,:,39))
  Gcoeff(:)%j = (-(c(11)*M(2,:)%j)+c(10)*M(4,:)%j) * den(5)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(46),h0tab(:,46),[20,3,8],[nMB,nMB,0],3,2,wf4(:,4),wf4(:,1))
  call Hloop_VQ_A(ntryL,G0H32(1),wf4(:,4),G0H8(1),m3h4x8(:,9),heltab2x32(:,:,40))
  call Hloop_Q_A(ntryL,G0H8(1),20,nMB,G1H8(9),n2h8(15))
  Gcoeff(:)%j = (c(6)*M(2,:)%j-c(4)*M(4,:)%j) * den(5)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(47),h0tab(:,47),[20,3,8],[0,0,nMB],3,2,wf4(:,4),wf4(:,1))
  call Hloop_AQ_V(ntryL,G0H32(1),wf4(:,4),G0H8(2),m3h4x8(:,10),heltab2x32(:,:,41))
  Gcoeff(:)%j = (-(c(11)*M(3,:)%j)+c(10)*M(4,:)%j) * den(7)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(48),h0tab(:,48),[24,3,4],[nMB,nMB,0],3,2,wf4(:,6),wf4(:,1))
  call Hloop_VA_Q(ntryL,G0H32(1),wf4(:,6),G0H8(3),m3h4x8(:,11),heltab2x32(:,:,42))
  call Hloop_A_Q(ntryL,G0H8(3),24,nMB,G1H8(1),n2h8(16))
  Gcoeff(:)%j = (-(c(6)*M(3,:)%j)+c(4)*M(4,:)%j) * den(7)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(49),h0tab(:,49),[24,3,4],[0,0,nMB],3,2,wf4(:,6),wf4(:,1))
  call Hloop_QA_V(ntryL,G0H32(1),wf4(:,6),G0H8(4),m3h4x8(:,12),heltab2x32(:,:,43))
  Gcoeff(:)%j = (-(c(11)*M(3,:)%j)+c(10)*M(4,:)%j) * den(26)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(50),h0tab(:,50),[16,7,8],[nMB,0,nMB],3,1,wf8(:,20))
  call Hloop_AV_Q(ntryL,G0H32(1),ex5(:),G0H16(1),m3h2x16(:,32),heltab2x32(:,:,44))
  call Hloop_A_Q(ntryL,G0H16(1),16,nMB,G1H16(12),n2h16(19))
  Gcoeff(:)%j = (-(c(6)*M(3,:)%j)+c(4)*M(4,:)%j) * den(26)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(51),h0tab(:,51),[16,7,8],[0,nMB,0],3,1,wf8(:,20))
  call Hloop_UV_W(ntryL,G0H32(1),0,ex5(:),16,G1H16(13),m3h2x16(:,33),heltab2x32(:,:,45))
  Gcoeff(:)%j = (-(c(11)*M(2,:)%j)+c(10)*M(4,:)%j) * den(21)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(52),h0tab(:,52),[16,4,11],[nMB,0,nMB],3,1,wf8(:,18))
  call Hloop_AV_Q(ntryL,G0H32(1),ex5(:),G0H16(1),m3h2x16(:,34),heltab2x32(:,:,46))
  call Hloop_A_Q(ntryL,G0H16(1),16,nMB,G1H16(14),n2h16(20))
  Gcoeff(:)%j = (-(c(6)*M(2,:)%j)+c(4)*M(4,:)%j) * den(21)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(53),h0tab(:,53),[16,4,11],[0,nMB,0],3,1,wf8(:,18))
  call Hloop_UV_W(ntryL,G0H32(1),0,ex5(:),16,G1H16(15),m3h2x16(:,35),heltab2x32(:,:,47))
  Gcoeff(:)%j = (c(3)*(M(2,:)%j-M(3,:)%j)) * den(16)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(54),h0tab(:,54),[19,4,8],[nMB,0,nMB],3,1,wf8(:,1))
  call Hloop_AV_Q(ntryL,G0H32(1),wf8(:,1),G0H4(7),m3h8x4(:,1),heltab2x32(:,:,48))
  call Hloop_A_Q(ntryL,G0H4(7),19,nMB,G1H4(15),n2h4(19))
  Gcoeff(:)%j = (c(19)*(M(2,:)%j-M(3,:)%j)) * den(16)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(55),h0tab(:,55),[19,4,8],[0,nMB,0],3,1,wf8(:,1))
  call Hloop_UV_W(ntryL,G0H32(1),0,wf8(:,1),19,G1H4(21),m3h8x4(:,2),heltab2x32(:,:,49))
  Gcoeff(:)%j = (c(10)*M(1,:)%j-c(11)*M(3,:)%j) * den(9)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(56),h0tab(:,56),[17,2,12],[0,nMT,nMT],3,2,wf4(:,8),wf4(:,2))
  call Hloop_AQ_V(ntryL,G0H32(1),wf4(:,8),G0H8(1),m3h4x8(:,13),heltab2x32(:,:,50))
  Gcoeff(:)%j = (c(4)*M(1,:)%j-c(6)*M(3,:)%j) * den(9)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(57),h0tab(:,57),[17,2,12],[nMT,0,0],3,2,wf4(:,8),wf4(:,2))
  call Hloop_VQ_A(ntryL,G0H32(1),wf4(:,8),G0H8(3),m3h4x8(:,14),heltab2x32(:,:,51))
  call Hloop_Q_A(ntryL,G0H8(3),17,nMT,G1H8(3),n2h8(17))
  Gcoeff(:)%j = (c(10)*M(1,:)%j-c(11)*M(2,:)%j) * den(11)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(58),h0tab(:,58),[18,1,12],[0,nMT,nMT],3,2,wf4(:,10),wf4(:,2))
  call Hloop_QA_V(ntryL,G0H32(1),wf4(:,10),G0H8(3),m3h4x8(:,15),heltab2x32(:,:,52))
  Gcoeff(:)%j = (-(c(4)*M(1,:)%j)+c(6)*M(2,:)%j) * den(11)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(59),h0tab(:,59),[18,1,12],[nMT,0,0],3,2,wf4(:,10),wf4(:,2))
  call Hloop_VA_Q(ntryL,G0H32(1),wf4(:,10),G0H8(5),m3h4x8(:,16),heltab2x32(:,:,53))
  call Hloop_A_Q(ntryL,G0H8(5),18,nMT,G1H8(4),n2h8(18))
  Gcoeff(:)%j = (c(10)*M(1,:)%j-c(11)*M(2,:)%j) * den(34)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(60),h0tab(:,60),[16,2,13],[nMT,0,nMT],3,1,wf8(:,24))
  call Hloop_QV_A(ntryL,G0H32(1),ex5(:),G0H16(1),m3h2x16(:,36),heltab2x32(:,:,54))
  call Hloop_Q_A(ntryL,G0H16(1),16,nMT,G1H16(16),n2h16(21))
  Gcoeff(:)%j = (-(c(4)*M(1,:)%j)+c(6)*M(2,:)%j) * den(34)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(61),h0tab(:,61),[16,2,13],[0,nMT,0],3,1,wf8(:,24))
  call Hloop_UV_W(ntryL,G0H32(1),0,ex5(:),16,G1H16(17),m3h2x16(:,37),heltab2x32(:,:,55))
  Gcoeff(:)%j = (c(10)*M(1,:)%j-c(11)*M(3,:)%j) * den(29)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(62),h0tab(:,62),[16,1,14],[nMT,0,nMT],3,1,wf8(:,22))
  call Hloop_AV_Q(ntryL,G0H32(1),ex5(:),G0H16(1),m3h2x16(:,38),heltab2x32(:,:,56))
  call Hloop_A_Q(ntryL,G0H16(1),16,nMT,G1H16(18),n2h16(22))
  Gcoeff(:)%j = (c(4)*M(1,:)%j-c(6)*M(3,:)%j) * den(29)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(63),h0tab(:,63),[16,1,14],[0,nMT,0],3,1,wf8(:,22))
  call Hloop_UV_W(ntryL,G0H32(1),0,ex5(:),16,G1H16(19),m3h2x16(:,39),heltab2x32(:,:,57))
  Gcoeff(:)%j = (c(3)*(-M(2,:)%j+M(3,:)%j)) * den(13)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(64),h0tab(:,64),[28,1,2],[nMT,0,nMT],3,1,wf8(:,16))
  call Hloop_AV_Q(ntryL,G0H32(1),wf8(:,16),G0H4(7),m3h8x4(:,3),heltab2x32(:,:,58))
  call Hloop_A_Q(ntryL,G0H4(7),28,nMT,G1H4(5),n2h4(20))
  Gcoeff(:)%j = (c(19)*(-M(2,:)%j+M(3,:)%j)) * den(13)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(65),h0tab(:,65),[28,1,2],[0,nMT,0],3,1,wf8(:,16))
  call Hloop_UV_W(ntryL,G0H32(1),0,wf8(:,16),28,G1H4(6),m3h8x4(:,4),heltab2x32(:,:,59))
  Gcoeff(:)%j = (c(10)*M(1,:)%j-c(11)*M(3,:)%j) * den(31)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(66),h0tab(:,66),[19,4,8],[nMB,0,nMB],3,1,wf8(:,4))
  call Hloop_AV_Q(ntryL,G0H32(1),wf8(:,4),G0H4(7),m3h8x4(:,5),heltab2x32(:,:,60))
  call Hloop_A_Q(ntryL,G0H4(7),19,nMB,G1H4(4),n2h4(21))
  Gcoeff(:)%j = (c(4)*M(1,:)%j-c(6)*M(3,:)%j) * den(31)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(67),h0tab(:,67),[19,4,8],[0,nMB,0],3,1,wf8(:,4))
  call Hloop_UV_W(ntryL,G0H32(1),0,wf8(:,4),19,G1H4(12),m3h8x4(:,6),heltab2x32(:,:,61))
  Gcoeff(:)%j = (c(10)*M(1,:)%j-c(11)*M(2,:)%j) * den(36)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(68),h0tab(:,68),[19,4,8],[nMB,0,nMB],3,1,wf8(:,5))
  call Hloop_AV_Q(ntryL,G0H32(1),wf8(:,5),G0H4(7),m3h8x4(:,7),heltab2x32(:,:,62))
  call Hloop_A_Q(ntryL,G0H4(7),19,nMB,G1H4(13),n2h4(22))
  Gcoeff(:)%j = (c(4)*M(1,:)%j-c(6)*M(2,:)%j) * den(36)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(69),h0tab(:,69),[19,4,8],[0,nMB,0],3,1,wf8(:,5))
  call Hloop_UV_W(ntryL,G0H32(1),0,wf8(:,5),19,G1H4(14),m3h8x4(:,8),heltab2x32(:,:,63))
  Gcoeff(:)%j = (-(c(11)*M(2,:)%j)+c(10)*M(4,:)%j) * den(18)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(70),h0tab(:,70),[28,1,2],[nMT,0,nMT],3,1,wf8(:,17))
  call Hloop_AV_Q(ntryL,G0H32(1),wf8(:,17),G0H4(7),m3h8x4(:,9),heltab2x32(:,:,64))
  call Hloop_A_Q(ntryL,G0H4(7),28,nMT,G1H4(20),n2h4(23))
  Gcoeff(:)%j = (-(c(6)*M(2,:)%j)+c(4)*M(4,:)%j) * den(18)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(71),h0tab(:,71),[28,1,2],[0,nMT,0],3,1,wf8(:,17))
  call Hloop_UV_W(ntryL,G0H32(1),0,wf8(:,17),28,G1H4(23),m3h8x4(:,10),heltab2x32(:,:,65))
  Gcoeff(:)%j = (-(c(11)*M(3,:)%j)+c(10)*M(4,:)%j) * den(23)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(72),h0tab(:,72),[28,1,2],[nMT,0,nMT],3,1,wf8(:,19))
  call Hloop_AV_Q(ntryL,G0H32(1),wf8(:,19),G0H4(7),m3h8x4(:,11),heltab2x32(:,:,66))
  call Hloop_A_Q(ntryL,G0H4(7),28,nMT,G1H4(24),n2h4(24))
  Gcoeff(:)%j = (-(c(6)*M(3,:)%j)+c(4)*M(4,:)%j) * den(23)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(73),h0tab(:,73),[28,1,2],[0,nMT,0],3,1,wf8(:,19))
  call Hloop_UV_W(ntryL,G0H32(1),0,wf8(:,19),28,G1H4(16),m3h8x4(:,12),heltab2x32(:,:,67))
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(14),[G1H4(12),G1H4(21),G1H4(19),G0H4(3),G0H4(2) &
    ,G0H4(1)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H8(9),[G1H8(2)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(16),[G1H4(23),G1H4(6),G0H4(6),G0H4(5),G0H4(4)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H16(5),[G1H16(1)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H16(7),[G1H16(3)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(13),[G1H4(4),G1H4(15)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(24),[G1H4(20),G1H4(5)])
  call Hloop_VQ_A(ntryL,G1H4(14),ex3(:),G1H2(8),m3h2x2(:,39),heltab2x4(:,:,51))
  call Hloop_Q_A(ntryL,G1H2(8),23,nMB,G2H2(6),n2h2(29))
  call Hloop_VA_Q(ntryL,G1H4(2),ex4(:),G1H2(14),m3h2x2(:,40),heltab2x4(:,:,52))
  call Hloop_A_Q(ntryL,G1H2(14),27,nMB,G2H2(9),n2h2(30))
  call Hloop_QV_A(ntryL,G1H8(9),wf4(:,1),G1H2(19),m3h4x2(:,9),heltab2x8(:,:,31))
  call Hloop_Q_A(ntryL,G1H2(19),23,nMB,G2H2(12),n2h2(31))
  call Hloop_QV_A(ntryL,G1H8(7),wf4(:,2),G1H2(20),m3h4x2(:,10),heltab2x8(:,:,32))
  call Hloop_Q_A(ntryL,G1H2(20),29,nMT,G2H2(15),n2h2(32))
  call Hloop_VQ_A(ntryL,G1H4(16),ex1(:),G1H2(25),m3h2x2(:,41),heltab2x4(:,:,53))
  call Hloop_Q_A(ntryL,G1H2(25),29,nMT,G2H2(8),n2h2(33))
  call Hloop_AV_Q(ntryL,G1H16(5),wf4(:,1),G1H4(12),m3h4x4(:,5),heltab2x16(:,:,21))
  call Hloop_A_Q(ntryL,G1H4(12),19,0,G2H4(4),n2h4(25))
  call Hloop_AV_Q(ntryL,G1H16(2),wf4(:,1),G1H4(21),m3h4x4(:,6),heltab2x16(:,:,22))
  call Hloop_A_Q(ntryL,G1H4(21),19,nMT,G2H4(2),n2h4(26))
  call Hloop_QV_A(ntryL,G1H16(7),wf4(:,1),G1H4(19),m3h4x4(:,7),heltab2x16(:,:,23))
  call Hloop_Q_A(ntryL,G1H4(19),19,0,G2H4(1),n2h4(27))
  call Hloop_QV_A(ntryL,G1H16(4),wf4(:,1),G1H4(23),m3h4x4(:,8),heltab2x16(:,:,24))
  call Hloop_Q_A(ntryL,G1H4(23),19,nMT,G2H4(3),n2h4(28))
  call Hloop_AV_Q(ntryL,G1H16(6),wf4(:,1),G1H4(6),m3h4x4(:,9),heltab2x16(:,:,25))
  call Hloop_A_Q(ntryL,G1H4(6),19,nMB,G2H4(5),n2h4(29))
  call Hloop_QV_A(ntryL,G1H16(8),wf4(:,1),G1H4(4),m3h4x4(:,10),heltab2x16(:,:,26))
  call Hloop_Q_A(ntryL,G1H4(4),19,nMB,G2H4(6),n2h4(30))
  call Hloop_DV_C(ntryL,G1H16(9),16,wf4(:,1),G2H4(7),m3h4x4(:,11),heltab2x16(:,:,27))
  call Hloop_CV_D(ntryL,G1H16(10),16,wf4(:,1),3,G2H4(8),m3h4x4(:,12),heltab2x16(:,:,28))
  call Hloop_UV_W(ntryL,G1H16(11),16,wf4(:,1),3,G2H4(9),m3h4x4(:,13),heltab2x16(:,:,29))
  call Hloop_UV_W(ntryL,G0H8(2),20,wf4(:,1),3,G1H2(26),m3h4x2(:,11),heltab2x8(:,:,33))
  call Hloop_AV_Q(ntryL,G1H8(1),wf4(:,1),G1H2(22),m3h4x2(:,12),heltab2x8(:,:,34))
  call Hloop_A_Q(ntryL,G1H2(22),27,nMB,G2H2(10),n2h2(34))
  call Hloop_UV_W(ntryL,G0H8(4),24,wf4(:,1),3,G1H2(24),m3h4x2(:,13),heltab2x8(:,:,35))
  call Hloop_AQ_V(ntryL,G1H16(12),wf8(:,20),G1H2(10),m3h8x2(:,1),heltab2x16(:,:,30))
  call Hloop_VQ_A(ntryL,G1H16(13),wf8(:,20),G1H2(11),m3h8x2(:,2),heltab2x16(:,:,31))
  call Hloop_Q_A(ntryL,G1H2(11),23,nMB,G2H2(1),n2h2(35))
  call Hloop_AQ_V(ntryL,G1H16(14),ex3(:),G1H8(5),m3h2x8(:,17),heltab2x16(:,:,32))
  call Hloop_VQ_A(ntryL,G1H16(15),ex3(:),G1H8(6),m3h2x8(:,18),heltab2x16(:,:,33))
  call Hloop_Q_A(ntryL,G1H8(6),20,nMB,G2H8(1),n2h8(19))
  call Hloop_AQ_V(ntryL,G1H4(13),ex3(:),G1H2(17),m3h2x2(:,42),heltab2x4(:,:,54))
  call Hloop_VA_Q(ntryL,G0H8(1),ex2(:),G0H4(7),m3h2x4(:,23),heltab2x8(:,:,36))
  call Hloop_A_Q(ntryL,G0H4(7),19,nMT,G1H4(15),n2h4(31))
  call Hloop_QA_V(ntryL,G1H8(3),ex2(:),G1H4(20),m3h2x4(:,24),heltab2x8(:,:,37))
  call Hloop_VQ_A(ntryL,G0H8(3),ex1(:),G0H4(3),m3h2x4(:,25),heltab2x8(:,:,38))
  call Hloop_Q_A(ntryL,G0H4(3),19,nMT,G1H4(5),n2h4(32))
  call Hloop_AQ_V(ntryL,G1H8(4),ex1(:),G1H4(14),m3h2x4(:,26),heltab2x8(:,:,39))
  call Hloop_QA_V(ntryL,G1H16(16),ex2(:),G1H8(8),m3h2x8(:,19),heltab2x16(:,:,34))
  call Hloop_VA_Q(ntryL,G1H16(17),ex2(:),G1H8(10),m3h2x8(:,20),heltab2x16(:,:,35))
  call Hloop_A_Q(ntryL,G1H8(10),18,nMT,G2H8(2),n2h8(20))
  call Hloop_AQ_V(ntryL,G1H16(18),ex1(:),G1H8(2),m3h2x8(:,21),heltab2x16(:,:,36))
  call Hloop_VQ_A(ntryL,G1H16(19),ex1(:),G1H8(9),m3h2x8(:,22),heltab2x16(:,:,37))
  call Hloop_Q_A(ntryL,G1H8(9),17,nMT,G2H8(3),n2h8(21))
  call Hloop_AQ_V(ntryL,G1H4(24),ex1(:),G1H2(18),m3h2x2(:,43),heltab2x4(:,:,55))
call HGT_w2_OLR(G1H2(23),1,1,2)
call HGT_w2_invQ_OLR(G1H2(23),2,5,2)
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(23),[G1H2(24)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(1),[G2H2(20),G2H2(13)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(26),[G1H2(28)])
call HGT_w2_OLR(G1H2(6),1,1,2)
call HGT_w2_invQ_OLR(G1H2(6),2,5,2)
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(6),[G1H2(26)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(5),[G1H4(17)])
call HGT_w2_OLR(G1H4(10),1,1,4)
call HGT_w2_invQ_OLR(G1H4(10),2,5,4)
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(10),[G1H4(5)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(10),[G1H2(3),G1H2(5)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(17),[G1H2(2)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(15),[G1H4(7)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(2),[G1H4(8)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(20),[G1H4(9)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(9),[G1H4(3),G1H4(11)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(3),[G1H4(18)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(14),[G1H4(1)])
  call Hloop_VQ_A(ntryL,G1H2(23),ex3(:),G1H1(1),m3h2x1(:,59),heltab2x2(:,:,59))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,nMB,G2tensor(4),n2h1(43))
  call Hcheck_last_QA_V(ntryL,l_switch,G2H2(1),ex4(:),G2tensor(2),m3h2x1(:,60),heltab2x2(:,:,60))
  call Hloop_VA_Q(ntryL,G1H2(6),ex4(:),G1H1(1),m3h2x1(:,61),heltab2x2(:,:,61))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,nMB,G2tensor(8),n2h1(44))
  call Hcheck_last_AQ_V(ntryL,l_switch,G2H2(17),ex3(:),G2tensor(6),m3h2x1(:,62),heltab2x2(:,:,62))
call HGT_w2_OLR(G1H4(22),1,1,4)
call HGT_w2_invQ_OLR(G1H4(22),2,5,4)
  call Hloop_QV_A(ntryL,G1H4(22),wf4(:,1),G1H1(1),m3h4x1(:,13),heltab2x4(:,:,56))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,nMB,G2tensor(16),n2h1(45))
  call Hloop_QV_A(ntryL,G1H4(10),wf4(:,2),G1H1(1),m3h4x1(:,14),heltab2x4(:,:,57))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,nMT,G2tensor(19),n2h1(46))
  call Hcheck_last_QA_V(ntryL,l_switch,G2H2(23),ex2(:),G2tensor(60),m3h2x1(:,63),heltab2x2(:,:,63))
  call Hloop_VA_Q(ntryL,G1H2(10),ex4(:),G1H1(1),m3h2x1(:,64),heltab2x2(:,:,64))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,nMB,G2tensor(54),n2h1(47))
  call Hloop_VA_Q(ntryL,G1H2(13),ex2(:),G1H1(1),m3h2x1(:,65),heltab2x2(:,:,65))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,nMT,G2tensor(10),n2h1(48))
  call Hloop_VA_Q(ntryL,G1H2(12),ex2(:),G1H1(1),m3h2x1(:,66),heltab2x2(:,:,66))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,nMT,G2tensor(11),n2h1(49))
  call Hloop_VQ_A(ntryL,G1H2(15),ex3(:),G1H1(1),m3h2x1(:,67),heltab2x2(:,:,67))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,nMB,G2tensor(13),n2h1(50))
  call Hloop_VQ_A(ntryL,G1H2(9),ex3(:),G1H1(1),m3h2x1(:,68),heltab2x2(:,:,68))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,nMB,G2tensor(14),n2h1(51))
  call Hloop_VA_Q(ntryL,G1H2(17),ex4(:),G1H1(1),m3h2x1(:,69),heltab2x2(:,:,69))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,nMB,G2tensor(27),n2h1(52))
  call Hloop_AV_Q(ntryL,G1H4(15),wf4(:,2),G1H1(1),m3h4x1(:,15),heltab2x4(:,:,58))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,nMT,G2tensor(17),n2h1(53))
  call Hloop_AV_Q(ntryL,G2H4(2),wf4(:,2),G2H1(1),m3h4x1(:,16),heltab2x4(:,:,59))
  call Hcheck_last_A_Q(ntryL,l_switch,G2H1(1),31,nMT,G3tensor(1),n2h1(54))
  call Hcheck_last_UV_W(ntryL,l_switch,G1H4(20),19,wf4(:,2),12,G2tensor(28),m3h4x1(:,17),heltab2x4(:,:,60))
  call Hcheck_last_UV_W(ntryL,l_switch,G2H4(9),19,wf4(:,2),12,G3tensor(2),m3h4x1(:,18),heltab2x4(:,:,61))
  call Hloop_QV_A(ntryL,G2H4(3),wf4(:,2),G2H1(1),m3h4x1(:,19),heltab2x4(:,:,62))
  call Hcheck_last_Q_A(ntryL,l_switch,G2H1(1),31,nMT,G3tensor(3),n2h1(55))
  call Hcheck_last_UV_W(ntryL,l_switch,G1H4(14),19,wf4(:,2),12,G2tensor(20),m3h4x1(:,20),heltab2x4(:,:,63))
  call Hcheck_last_QA_V(ntryL,l_switch,G2H2(6),ex4(:),G2tensor(1),m3h2x1(:,70),heltab2x2(:,:,70))
  call Hcheck_last_AQ_V(ntryL,l_switch,G2H2(9),ex3(:),G2tensor(31),m3h2x1(:,71),heltab2x2(:,:,71))
  call Hcheck_last_QA_V(ntryL,l_switch,G2H2(12),ex4(:),G2tensor(3),m3h2x1(:,72),heltab2x2(:,:,72))
  call Hcheck_last_QA_V(ntryL,l_switch,G2H2(15),ex2(:),G2tensor(5),m3h2x1(:,73),heltab2x2(:,:,73))
  call Hcheck_last_QA_V(ntryL,l_switch,G2H2(8),ex2(:),G2tensor(33),m3h2x1(:,74),heltab2x2(:,:,74))
  call Hloop_AV_Q(ntryL,G2H4(4),wf4(:,2),G2H1(1),m3h4x1(:,21),heltab2x4(:,:,64))
  call Hcheck_last_A_Q(ntryL,l_switch,G2H1(1),31,0,G3tensor(4),n2h1(56))
  call Hloop_QV_A(ntryL,G2H4(1),wf4(:,2),G2H1(1),m3h4x1(:,22),heltab2x4(:,:,65))
  call Hcheck_last_Q_A(ntryL,l_switch,G2H1(1),31,0,G3tensor(5),n2h1(57))
  call Hloop_AV_Q(ntryL,G2H4(5),wf4(:,2),G2H1(1),m3h4x1(:,23),heltab2x4(:,:,66))
  call Hcheck_last_A_Q(ntryL,l_switch,G2H1(1),31,nMB,G3tensor(6),n2h1(58))
  call Hloop_QV_A(ntryL,G2H4(6),wf4(:,2),G2H1(1),m3h4x1(:,24),heltab2x4(:,:,67))
  call Hcheck_last_Q_A(ntryL,l_switch,G2H1(1),31,nMB,G3tensor(7),n2h1(59))
  call Hcheck_last_DV_C(ntryL,l_switch,G2H4(7),19,wf4(:,2),G3tensor(8),m3h4x1(:,25),heltab2x4(:,:,68))
  call Hcheck_last_CV_D(ntryL,l_switch,G2H4(8),19,wf4(:,2),12,G3tensor(9),m3h4x1(:,26),heltab2x4(:,:,69))
  call Hcheck_last_AQ_V(ntryL,l_switch,G2H2(10),ex3(:),G2tensor(7),m3h2x1(:,75),heltab2x2(:,:,75))
  call Hloop_VA_Q(ntryL,G1H8(5),wf8(:,18),G1H1(1),m3h8x1(:,1),heltab2x8(:,:,40))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,nMB,G2tensor(9),n2h1(60))
  call Hcheck_last_QA_V(ntryL,l_switch,G2H8(1),wf8(:,18),G2tensor(29),m3h8x1(:,2),heltab2x8(:,:,41))
  call Hloop_VQ_A(ntryL,G1H8(8),wf8(:,24),G1H1(1),m3h8x1(:,3),heltab2x8(:,:,42))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,nMT,G2tensor(12),n2h1(61))
  call Hcheck_last_AQ_V(ntryL,l_switch,G2H8(2),wf8(:,24),G2tensor(15),m3h8x1(:,4),heltab2x8(:,:,43))
  call Hloop_VA_Q(ntryL,G1H8(2),wf8(:,22),G1H1(1),m3h8x1(:,5),heltab2x8(:,:,44))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,nMT,G2tensor(30),n2h1(62))
  call Hcheck_last_QA_V(ntryL,l_switch,G2H8(3),wf8(:,22),G2tensor(18),m3h8x1(:,6),heltab2x8(:,:,45))
  call Hloop_VA_Q(ntryL,G1H2(18),ex2(:),G1H1(1),m3h2x1(:,76),heltab2x2(:,:,76))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,nMT,G2tensor(21),n2h1(63))
  call ol_merge_tensors(G3tensor(9),[G3tensor(8),G3tensor(5),G3tensor(4),G3tensor(2),G2tensor(34),G2tensor(32),G1tensor(75) &
    ,G1tensor(60),G1tensor(12),G1tensor(19),G0tensor(75),G0tensor(60),G0tensor(9),G0tensor(4)])
  call ol_merge_tensors(G2tensor(29),[G2tensor(36),G1tensor(155),G0tensor(155)])
  call ol_merge_tensors(G2tensor(18),[G2tensor(56),G2tensor(38),G1tensor(160),G1tensor(110),G1tensor(95),G1tensor(6),G0tensor(160) &
    ,G0tensor(110),G0tensor(95),G0tensor(10)])
  call ol_merge_tensors(G2tensor(40),[G1tensor(117),G1tensor(4),G1tensor(32),G0tensor(117),G0tensor(25),G0tensor(15)])
  call ol_merge_tensors(G2tensor(9),[G2tensor(41),G1tensor(120),G1tensor(10),G1tensor(44),G0tensor(120),G0tensor(30) &
    ,G0tensor(20)])
  call ol_merge_tensors(G2tensor(20),[G2tensor(43),G1tensor(137),G1tensor(47),G1tensor(27),G1tensor(13),G0tensor(137),G0tensor(45) &
    ,G0tensor(35),G0tensor(3)])
  call ol_merge_tensors(G2tensor(30),[G2tensor(53),G2tensor(44),G1tensor(175),G1tensor(140),G1tensor(50),G1tensor(35) &
    ,G0tensor(175),G0tensor(140),G0tensor(50),G0tensor(40)])
  call ol_merge_tensors(G2tensor(3),[G2tensor(46),G1tensor(162),G1tensor(153),G0tensor(162),G0tensor(153)])
  call ol_merge_tensors(G3tensor(7),[G3tensor(6),G2tensor(50),G2tensor(47),G1tensor(170),G1tensor(165),G0tensor(170) &
    ,G0tensor(165)])
  call ol_merge_tensors(G2tensor(7),[G2tensor(49),G1tensor(167),G0tensor(167)])
  call ol_merge_tensors(G2tensor(21),[G2tensor(52),G1tensor(172),G0tensor(172)])
  call ol_merge_tensors(G2tensor(33),[G2tensor(55),G1tensor(97),G1tensor(82),G1tensor(26),G1tensor(37),G0tensor(97),G0tensor(82) &
    ,G0tensor(13),G0tensor(7)])
  call ol_merge_tensors(G2tensor(58),[G1tensor(177),G0tensor(177)])
  call ol_merge_tensors(G2tensor(12),[G2tensor(59),G1tensor(180),G0tensor(180)])
  call ol_merge_tensors(G2tensor(61),[G1tensor(67),G1tensor(52),G1tensor(2),G1tensor(7),G0tensor(67),G0tensor(52),G0tensor(23) &
    ,G0tensor(2)])
  call ol_merge_tensors(G2tensor(15),[G2tensor(62),G1tensor(80),G1tensor(65),G1tensor(25),G0tensor(80),G0tensor(65),G0tensor(5)])
  call ol_merge_tensors(G2tensor(28),[G1tensor(105),G1tensor(90),G1tensor(43),G0tensor(105),G0tensor(90),G0tensor(8)])
  call ol_merge_tensors(G1tensor(38),[G1tensor(18),G0tensor(17),G0tensor(12)])
  call ol_merge_tensors(G1tensor(112),[G1tensor(30),G0tensor(112),G0tensor(14)])
  call ol_merge_tensors(G1tensor(107),[G1tensor(100),G1tensor(3),G0tensor(107),G0tensor(100),G0tensor(18)])
  call ol_merge_tensors(G1tensor(115),[G1tensor(42),G0tensor(115),G0tensor(19)])
  call ol_merge_tensors(G1tensor(148),[G1tensor(143),G1tensor(33),G1tensor(48),G0tensor(148),G0tensor(143),G0tensor(27) &
    ,G0tensor(22)])
  call ol_merge_tensors(G1tensor(122),[G1tensor(16),G0tensor(122),G0tensor(24)])
  call ol_merge_tensors(G1tensor(77),[G1tensor(70),G1tensor(8),G0tensor(77),G0tensor(70),G0tensor(28)])
  call ol_merge_tensors(G1tensor(125),[G1tensor(22),G0tensor(125),G0tensor(29)])
  call ol_merge_tensors(G1tensor(53),[G1tensor(21),G1tensor(14),G0tensor(53),G0tensor(37),G0tensor(32)])
  call ol_merge_tensors(G2tensor(1),[G1tensor(127),G1tensor(88),G1tensor(58),G1tensor(15),G0tensor(127),G0tensor(88),G0tensor(58) &
    ,G0tensor(33)])
  call ol_merge_tensors(G1tensor(132),[G1tensor(63),G1tensor(17),G0tensor(132),G0tensor(63),G0tensor(34)])
  call ol_merge_tensors(G1tensor(130),[G1tensor(23),G0tensor(130),G0tensor(38)])
  call ol_merge_tensors(G1tensor(135),[G1tensor(28),G0tensor(135),G0tensor(39)])
  call ol_merge_tensors(G1tensor(123),[G1tensor(68),G1tensor(45),G1tensor(34),G0tensor(123),G0tensor(68),G0tensor(47) &
    ,G0tensor(42)])
  call ol_merge_tensors(G2tensor(31),[G1tensor(142),G1tensor(103),G1tensor(73),G1tensor(39),G0tensor(142),G0tensor(103) &
    ,G0tensor(73),G0tensor(43)])
  call ol_merge_tensors(G1tensor(147),[G1tensor(78),G1tensor(40),G0tensor(147),G0tensor(78),G0tensor(44)])
  call ol_merge_tensors(G1tensor(145),[G1tensor(46),G0tensor(145),G0tensor(48)])
  call ol_merge_tensors(G1tensor(150),[G1tensor(49),G0tensor(150),G0tensor(49)])
  call ol_merge_tensors(G2tensor(4),[G1tensor(84),G1tensor(57),G1tensor(54),G0tensor(84),G0tensor(57),G0tensor(54)])
  call ol_merge_tensors(G1tensor(62),[G1tensor(55),G0tensor(62),G0tensor(55)])
  call ol_merge_tensors(G2tensor(2),[G1tensor(154),G1tensor(94),G1tensor(64),G1tensor(59),G0tensor(154),G0tensor(94),G0tensor(64) &
    ,G0tensor(59)])
  call ol_merge_tensors(G2tensor(8),[G1tensor(118),G1tensor(99),G1tensor(72),G1tensor(69),G0tensor(118),G0tensor(99),G0tensor(72) &
    ,G0tensor(69)])
  call ol_merge_tensors(G2tensor(6),[G1tensor(109),G1tensor(79),G1tensor(74),G0tensor(109),G0tensor(79),G0tensor(74)])
  call ol_merge_tensors(G1tensor(87),[G1tensor(83),G0tensor(87),G0tensor(83)])
  call ol_merge_tensors(G1tensor(92),[G1tensor(85),G0tensor(92),G0tensor(85)])
  call ol_merge_tensors(G1tensor(93),[G1tensor(89),G0tensor(93),G0tensor(89)])
  call ol_merge_tensors(G1tensor(113),[G1tensor(102),G1tensor(98),G0tensor(113),G0tensor(102),G0tensor(98)])
  call ol_merge_tensors(G1tensor(108),[G1tensor(104),G0tensor(108),G0tensor(104)])
  call ol_merge_tensors(G2tensor(54),[G1tensor(169),G1tensor(124),G1tensor(119),G1tensor(114),G0tensor(169),G0tensor(124) &
    ,G0tensor(119),G0tensor(114)])
  call ol_merge_tensors(G1tensor(133),[G1tensor(128),G0tensor(133),G0tensor(128)])
  call ol_merge_tensors(G2tensor(10),[G1tensor(144),G1tensor(138),G1tensor(129),G0tensor(144),G0tensor(138),G0tensor(129)])
  call ol_merge_tensors(G2tensor(11),[G1tensor(149),G1tensor(139),G1tensor(134),G0tensor(149),G0tensor(139),G0tensor(134)])
  call ol_merge_tensors(G2tensor(16),[G1tensor(152),G0tensor(152)])
  call ol_merge_tensors(G2tensor(19),[G1tensor(178),G1tensor(157),G0tensor(178),G0tensor(157)])
  call ol_merge_tensors(G2tensor(5),[G1tensor(158),G0tensor(158)])
  call ol_merge_tensors(G2tensor(60),[G1tensor(159),G0tensor(159)])
  call ol_merge_tensors(G2tensor(13),[G1tensor(163),G0tensor(163)])
  call ol_merge_tensors(G2tensor(14),[G1tensor(164),G0tensor(164)])
  call ol_merge_tensors(G2tensor(27),[G1tensor(168),G0tensor(168)])
  call ol_merge_tensors(G2tensor(17),[G1tensor(173),G0tensor(173)])
  call ol_merge_tensors(G3tensor(3),[G3tensor(1),G1tensor(179),G1tensor(174),G0tensor(179),G0tensor(174)])
  call TI_triangle_red(G3tensor(9),RedBasis(2),mass3set(:,1),G0tensor(1),G0tensor(6),G0tensor(11),G0tensor(16),M2L1R1)
  call TI_triangle_red(G2tensor(29),RedBasis(14),mass3set(:,2),G0tensor(21),G0tensor(26),G0tensor(31),G0tensor(36),M2L1R1,[nMB], &
    G0tensor(41))
  call TI_triangle_red(G2tensor(18),RedBasis(10),mass3set(:,3),G0tensor(46),G0tensor(51),G0tensor(56),G0tensor(61),M2L1R1,[nMT], &
    G0tensor(66))
  call TI_triangle_red(G2tensor(40),RedBasis(47),mass3set(:,4),G0tensor(71),G0tensor(76),G0tensor(81),G0tensor(86),M2L1R1,[nMB], &
    G0tensor(91))
  call TI_triangle_red(G2tensor(9),RedBasis(14),mass3set(:,5),G0tensor(96),G0tensor(101),G0tensor(106),G0tensor(111),M2L1R1,[nMB], &
    G0tensor(116))
  call TI_triangle_red(G2tensor(20),RedBasis(4),mass3set(:,6),G0tensor(121),G0tensor(126),G0tensor(131), &
    G0tensor(136),M2L1R1,[nMT],G0tensor(141))
  call TI_triangle_red(G2tensor(30),RedBasis(10),mass3set(:,7),G0tensor(146),G0tensor(151),G0tensor(156), &
    G0tensor(161),M2L1R1,[nMT],G0tensor(166))
  call TI_triangle_red(G2tensor(3),RedBasis(17),mass3set(:,8),G0tensor(171),G0tensor(176),G0tensor(75),G0tensor(60),M2L1R1,[nMB], &
    G0tensor(9))
  call TI_triangle_red(G3tensor(7),RedBasis(2),mass3set(:,9),G0tensor(4),G0tensor(155),G0tensor(160),G0tensor(110),M2L1R1,[nMB], &
    G0tensor(95))
  call TI_triangle_red(G2tensor(7),RedBasis(53),mass3set(:,8),G0tensor(10),G0tensor(117),G0tensor(25),G0tensor(15),M2L1R1,[nMB], &
    G0tensor(120))
  call TI_triangle_red(G2tensor(21),RedBasis(49),mass3set(:,7),G0tensor(30),G0tensor(20),G0tensor(137),G0tensor(45),M2L1R1,[nMT], &
    G0tensor(35))
  call TI_triangle_red(G2tensor(33),RedBasis(49),mass3set(:,3),G0tensor(3),G0tensor(175),G0tensor(140),G0tensor(50),M2L1R1,[nMT], &
    G0tensor(40))
  call TI_triangle_red(G2tensor(58),RedBasis(51),mass3set(:,7),G0tensor(162),G0tensor(153),G0tensor(170), &
    G0tensor(165),M2L1R1,[nMT],G0tensor(167))
  call TI_triangle_red(G2tensor(12),RedBasis(1),mass3set(:,7),G0tensor(172),G0tensor(97),G0tensor(82),G0tensor(13),M2L1R1,[nMT], &
    G0tensor(7))
  call TI_triangle_red(G2tensor(61),RedBasis(51),mass3set(:,3),G0tensor(177),G0tensor(180),G0tensor(67),G0tensor(52),M2L1R1,[nMT], &
    G0tensor(23))
  call TI_triangle_red(G2tensor(15),RedBasis(1),mass3set(:,3),G0tensor(2),G0tensor(80),G0tensor(65),G0tensor(5),M2L1R1,[nMT], &
    G0tensor(105))
  call TI_triangle_red(G2tensor(28),RedBasis(11),mass3set(:,6),G0tensor(90),G0tensor(8),G0tensor(17),G0tensor(12),M2L1R1,[nMT], &
    G0tensor(112))
  call TI_triangle_red(G2tensor(1),RedBasis(6),mass3set(:,2),G0tensor(14),G0tensor(107),G0tensor(100),G0tensor(18),M2L1R1,[nMB], &
    G0tensor(115))
  call TI_triangle_red(G2tensor(31),RedBasis(9),mass3set(:,2),G0tensor(19),G0tensor(148),G0tensor(143),G0tensor(27),M2L1R1,[nMB], &
    G0tensor(22))
  call TI_triangle_red(G2tensor(4),RedBasis(53),mass3set(:,10),G0tensor(122),G0tensor(24),G0tensor(77),G0tensor(70),M2L1R1,[nMB], &
    G0tensor(28))
  call TI_triangle_red(G2tensor(2),RedBasis(3),mass3set(:,2),G0tensor(125),G0tensor(29),G0tensor(53),G0tensor(37),M2L1R1,[nMB], &
    G0tensor(32))
  call TI_triangle_red(G2tensor(8),RedBasis(17),mass3set(:,10),G0tensor(127),G0tensor(88),G0tensor(58),G0tensor(33),M2L1R1,[nMB], &
    G0tensor(132))
  call TI_triangle_red(G2tensor(6),RedBasis(7),mass3set(:,2),G0tensor(63),G0tensor(34),G0tensor(130),G0tensor(38),M2L1R1,[nMB], &
    G0tensor(135))
  call TI_triangle_red(G2tensor(54),RedBasis(3),mass3set(:,5),G0tensor(39),G0tensor(123),G0tensor(68),G0tensor(47),M2L1R1,[nMB], &
    G0tensor(42))
  call TI_triangle_red(G2tensor(10),RedBasis(24),mass3set(:,11),G0tensor(142),G0tensor(103),G0tensor(73), &
    G0tensor(43),M2L1R1,[nMT],G0tensor(147))
  call TI_triangle_red(G2tensor(11),RedBasis(22),mass3set(:,7),G0tensor(78),G0tensor(44),G0tensor(145),G0tensor(48),M2L1R1,[nMT], &
    G0tensor(150))
  call TI_triangle_red(G2tensor(16),RedBasis(47),mass3set(:,12),G0tensor(49),G0tensor(84),G0tensor(57),G0tensor(54),M2L1R1,[nMB], &
    G0tensor(62))
  call TI_triangle_red(G2tensor(19),RedBasis(4),mass3set(:,13),G0tensor(55),G0tensor(154),G0tensor(94),G0tensor(64),M2L1R1,[nMT], &
    G0tensor(59))
  call TI_triangle_red(G2tensor(5),RedBasis(24),mass3set(:,14),G0tensor(118),G0tensor(99),G0tensor(72),G0tensor(69),M2L1R1,[nMT], &
    G0tensor(109))
  call TI_triangle_red(G2tensor(60),RedBasis(22),mass3set(:,3),G0tensor(79),G0tensor(74),G0tensor(87),G0tensor(83),M2L1R1,[nMT], &
    G0tensor(92))
  call TI_triangle_red(G2tensor(13),RedBasis(9),mass3set(:,5),G0tensor(85),G0tensor(93),G0tensor(89),G0tensor(113),M2L1R1,[nMB], &
    G0tensor(102))
  call TI_triangle_red(G2tensor(14),RedBasis(7),mass3set(:,5),G0tensor(98),G0tensor(108),G0tensor(104),G0tensor(169),M2L1R1,[nMB], &
    G0tensor(124))
  call TI_triangle_red(G2tensor(27),RedBasis(6),mass3set(:,5),G0tensor(119),G0tensor(114),G0tensor(133), &
    G0tensor(128),M2L1R1,[nMB],G0tensor(144))
  call TI_triangle_red(G2tensor(17),RedBasis(11),mass3set(:,13),G0tensor(138),G0tensor(129),G0tensor(149), &
    G0tensor(139),M2L1R1,[nMT],G0tensor(134))
  call TI_triangle_red(G3tensor(3),RedBasis(2),mass3set(:,15),G0tensor(152),G0tensor(178),G0tensor(157), &
    G0tensor(158),M2L1R1,[nMT],G0tensor(159))
  call TI_triangle_red(G1tensor(38),RedBasis(57),mass3set(:,16),G0tensor(163),G0tensor(164),G0tensor(168), &
    G0tensor(173),M2L1R1,[nMT,nMB],G0tensor(179),G0tensor(174))
  call TI_triangle_red(G1tensor(112),RedBasis(48),mass3set(:,17),G0tensor(181),G0tensor(182),G0tensor(183), &
    G0tensor(184),M2L1R1,[nMB,nMT],G0tensor(185),G0tensor(186))
  call TI_triangle_red(G1tensor(107),RedBasis(16),mass3set(:,18),G0tensor(187),G0tensor(188),G0tensor(189), &
    G0tensor(190),M2L1R1,[nMB,nMT],G0tensor(191),G0tensor(192))
  call TI_triangle_red(G1tensor(115),RedBasis(15),mass3set(:,19),G0tensor(193),G0tensor(194),G0tensor(195), &
    G0tensor(196),M2L1R1,[nMB,nMT],G0tensor(197),G0tensor(198))
  call TI_triangle_red(G1tensor(148),RedBasis(28),mass3set(:,16),G0tensor(199),G0tensor(200),G0tensor(201), &
    G0tensor(202),M2L1R1,[nMT,nMB],G0tensor(203),G0tensor(204))
  call TI_triangle_red(G1tensor(122),RedBasis(50),mass3set(:,17),G0tensor(205),G0tensor(206),G0tensor(207), &
    G0tensor(208),M2L1R1,[nMB,nMT],G0tensor(209),G0tensor(210))
  call TI_triangle_red(G1tensor(77),RedBasis(20),mass3set(:,18),G0tensor(211),G0tensor(212),G0tensor(213), &
    G0tensor(214),M2L1R1,[nMB,nMT],G0tensor(215),G0tensor(216))
  call TI_triangle_red(G1tensor(125),RedBasis(19),mass3set(:,19),G0tensor(217),G0tensor(218),G0tensor(219), &
    G0tensor(220),M2L1R1,[nMB,nMT],G0tensor(221),G0tensor(222))
  call TI_triangle_red(G1tensor(53),RedBasis(54),mass3set(:,20),G0tensor(223),G0tensor(224),G0tensor(225), &
    G0tensor(226),M2L1R1,[nMB,nMT],G0tensor(227),G0tensor(228))
  call TI_triangle_red(G1tensor(132),RedBasis(5),mass3set(:,21),G0tensor(229),G0tensor(230),G0tensor(231), &
    G0tensor(232),M2L1R1,[nMT,nMB],G0tensor(233),G0tensor(234))
  call TI_triangle_red(G1tensor(130),RedBasis(23),mass3set(:,22),G0tensor(235),G0tensor(236),G0tensor(237), &
    G0tensor(238),M2L1R1,[nMT,nMB],G0tensor(239),G0tensor(240))
  call TI_triangle_red(G1tensor(135),RedBasis(15),mass3set(:,23),G0tensor(241),G0tensor(242),G0tensor(243), &
    G0tensor(244),M2L1R1,[nMT,nMB],G0tensor(245),G0tensor(246))
  call TI_triangle_red(G1tensor(123),RedBasis(21),mass3set(:,20),G0tensor(247),G0tensor(248),G0tensor(249), &
    G0tensor(250),M2L1R1,[nMB,nMT],G0tensor(251),G0tensor(252))
  call TI_triangle_red(G1tensor(147),RedBasis(8),mass3set(:,21),G0tensor(253),G0tensor(254),G0tensor(255), &
    G0tensor(256),M2L1R1,[nMT,nMB],G0tensor(257),G0tensor(258))
  call TI_triangle_red(G1tensor(145),RedBasis(27),mass3set(:,22),G0tensor(259),G0tensor(260),G0tensor(261), &
    G0tensor(262),M2L1R1,[nMT,nMB],G0tensor(263),G0tensor(264))
  call TI_triangle_red(G1tensor(150),RedBasis(26),mass3set(:,23),G0tensor(265),G0tensor(266),G0tensor(267), &
    G0tensor(268),M2L1R1,[nMT,nMB],G0tensor(269),G0tensor(270))
  call TI_triangle_red(G1tensor(62),RedBasis(52),mass3set(:,18),G0tensor(271),G0tensor(272),G0tensor(273), &
    G0tensor(274),M2L1R1,[nMB,nMT],G0tensor(275),G0tensor(276))
  call TI_triangle_red(G1tensor(87),RedBasis(56),mass3set(:,20),G0tensor(277),G0tensor(278),G0tensor(279), &
    G0tensor(280),M2L1R1,[nMB,nMT],G0tensor(281),G0tensor(282))
  call TI_triangle_red(G1tensor(92),RedBasis(55),mass3set(:,18),G0tensor(283),G0tensor(284),G0tensor(285), &
    G0tensor(286),M2L1R1,[nMB,nMT],G0tensor(287),G0tensor(288))
  call TI_triangle_red(G1tensor(93),RedBasis(12),mass3set(:,21),G0tensor(289),G0tensor(290),G0tensor(291), &
    G0tensor(292),M2L1R1,[nMT,nMB],G0tensor(293),G0tensor(294))
  call TI_triangle_red(G1tensor(113),RedBasis(18),mass3set(:,20),G0tensor(295),G0tensor(296),G0tensor(297), &
    G0tensor(298),M2L1R1,[nMB,nMT],G0tensor(299),G0tensor(300))
  call TI_triangle_red(G1tensor(108),RedBasis(13),mass3set(:,21),G0tensor(301),G0tensor(302),G0tensor(303), &
    G0tensor(304),M2L1R1,[nMT,nMB],G0tensor(305),G0tensor(306))
  call TI_triangle_red(G1tensor(133),RedBasis(25),mass3set(:,16),G0tensor(307),G0tensor(308),G0tensor(309), &
    G0tensor(310),M2L1R1,[nMT,nMB],G0tensor(311),G0tensor(312))
  call ol_merge_tensors(T0sum(37),[G0tensor(1)])
  call ol_merge_tensors(T0sum(38),[G0tensor(21)])
  call ol_merge_tensors(T0sum(39),[G0tensor(46)])
  call ol_merge_tensors(T0sum(40),[G0tensor(71)])
  call ol_merge_tensors(T0sum(41),[G0tensor(96)])
  call ol_merge_tensors(T0sum(42),[G0tensor(121)])
  call ol_merge_tensors(T0sum(43),[G0tensor(146)])
  call ol_merge_tensors(T0sum(44),[G0tensor(171)])
  call ol_merge_tensors(T0sum(45),[G0tensor(4)])
  call ol_merge_tensors(T0sum(46),[G0tensor(10)])
  call ol_merge_tensors(T0sum(47),[G0tensor(30)])
  call ol_merge_tensors(T0sum(48),[G0tensor(3)])
  call ol_merge_tensors(T0sum(49),[G0tensor(162)])
  call ol_merge_tensors(T0sum(50),[G0tensor(172)])
  call ol_merge_tensors(T0sum(51),[G0tensor(177)])
  call ol_merge_tensors(T0sum(52),[G0tensor(2)])
  call ol_merge_tensors(T0sum(53),[G0tensor(90)])
  call ol_merge_tensors(T0sum(54),[G0tensor(163)])
  call ol_merge_tensors(T0sum(55),[G0tensor(181)])
  call ol_merge_tensors(T0sum(56),[G0tensor(187)])
  call ol_merge_tensors(T0sum(57),[G0tensor(193)])
  call ol_merge_tensors(T0sum(58),[G0tensor(199)])
  call ol_merge_tensors(T0sum(59),[G0tensor(205)])
  call ol_merge_tensors(T0sum(60),[G0tensor(211)])
  call ol_merge_tensors(T0sum(61),[G0tensor(217)])
  call ol_merge_tensors(T0sum(62),[G0tensor(223)])
  call ol_merge_tensors(T0sum(63),[G0tensor(14)])
  call ol_merge_tensors(T0sum(64),[G0tensor(229)])
  call ol_merge_tensors(T0sum(65),[G0tensor(235)])
  call ol_merge_tensors(T0sum(66),[G0tensor(241)])
  call ol_merge_tensors(T0sum(67),[G0tensor(247)])
  call ol_merge_tensors(T0sum(68),[G0tensor(19)])
  call ol_merge_tensors(T0sum(69),[G0tensor(253)])
  call ol_merge_tensors(T0sum(70),[G0tensor(259)])
  call ol_merge_tensors(T0sum(71),[G0tensor(265)])
  call ol_merge_tensors(T0sum(72),[G0tensor(122)])
  call ol_merge_tensors(T0sum(73),[G0tensor(271)])
  call ol_merge_tensors(T0sum(74),[G0tensor(125)])
  call ol_merge_tensors(T0sum(75),[G0tensor(127)])
  call ol_merge_tensors(T0sum(76),[G0tensor(63)])
  call ol_merge_tensors(T0sum(77),[G0tensor(277)])
  call ol_merge_tensors(T0sum(78),[G0tensor(283)])
  call ol_merge_tensors(T0sum(79),[G0tensor(289)])
  call ol_merge_tensors(T0sum(80),[G0tensor(295)])
  call ol_merge_tensors(T0sum(81),[G0tensor(301)])
  call ol_merge_tensors(T0sum(82),[G0tensor(39)])
  call ol_merge_tensors(T0sum(83),[G0tensor(307)])
  call ol_merge_tensors(T0sum(84),[G0tensor(142)])
  call ol_merge_tensors(T0sum(85),[G0tensor(78)])
  call ol_merge_tensors(T0sum(86),[G0tensor(49)])
  call ol_merge_tensors(T0sum(87),[G0tensor(55)])
  call ol_merge_tensors(T0sum(88),[G0tensor(118)])
  call ol_merge_tensors(T0sum(89),[G0tensor(79)])
  call ol_merge_tensors(T0sum(90),[G0tensor(85)])
  call ol_merge_tensors(T0sum(91),[G0tensor(98)])
  call ol_merge_tensors(T0sum(92),[G0tensor(119)])
  call ol_merge_tensors(T0sum(93),[G0tensor(138)])
  call ol_merge_tensors(T0sum(94),[G0tensor(152)])
  Gcoeff(:)%j = (c(1)*(M(2,:)%j-M(3,:)%j)) * den(3)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(74),h0tab(:,74),[16,15],[0,0],3,2,wf4(:,1),wf4(:,2))
  call Hloop_UV_W(ntryL,G0H32(1),0,ex5(:),16,G1H16(1),m3h2x16(:,40),heltab2x32(:,:,68))
  Gcoeff(:)%j = (c(1)*(-M(2,:)%j+M(3,:)%j)) * den(3)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(75),h0tab(:,75),[16,15],[0,0],3,2,wf4(:,2),wf4(:,1))
  call Hloop_UV_W(ntryL,G0H32(1),0,ex5(:),16,G1H16(3),m3h2x16(:,41),heltab2x32(:,:,69))
  Gcoeff(:)%j = (c(2)*(-M(2,:)%j+M(3,:)%j)) * den(3)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(76),h0tab(:,76),[16,15],[0,0],3,2,wf4(:,1),wf4(:,2))
  call Hloop_UV_W(ntryL,G0H32(1),0,ex5(:),16,G1H16(5),m3h2x16(:,42),heltab2x32(:,:,70))
  Gcoeff(:)%j = (c(1)*(-M(2,:)%j+M(3,:)%j)) * den(3)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(77),h0tab(:,77),[28,3],[0,0],3,2,wf4(:,2),wf4(:,1))
  call Hloop_GGG_G_12(ntryL,G0H32(1),ex5(:),wf4(:,2),G0H4(2),m4h2x4x4(:,5),heltab3x32(:,:,7))
  Gcoeff(:)%j = (c(1)*(M(2,:)%j-M(3,:)%j)) * den(3)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(78),h0tab(:,78),[28,3],[0,0],3,2,wf4(:,2),wf4(:,1))
  call Hloop_GGG_G_12(ntryL,G0H32(1),wf4(:,2),ex5(:),G0H4(1),m4h4x2x4(:,3),heltab3x32(:,:,8))
  Gcoeff(:)%j = (c(2)*(M(2,:)%j-M(3,:)%j)) * den(3)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(79),h0tab(:,79),[28,3],[0,0],3,2,wf4(:,2),wf4(:,1))
  call Hloop_GGG_G_23(ntryL,G0H32(1),ex5(:),wf4(:,2),G0H4(6),m4h2x4x4(:,6),heltab3x32(:,:,9))
  Gcoeff(:)%j = (c(1)*(M(2,:)%j-M(3,:)%j)) * den(3)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(80),h0tab(:,80),[19,12],[0,0],3,2,wf4(:,1),wf4(:,2))
  call Hloop_GGG_G_12(ntryL,G0H32(1),ex5(:),wf4(:,1),G0H4(5),m4h2x4x4(:,7),heltab3x32(:,:,10))
  Gcoeff(:)%j = (c(1)*(-M(2,:)%j+M(3,:)%j)) * den(3)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(81),h0tab(:,81),[19,12],[0,0],3,2,wf4(:,1),wf4(:,2))
  call Hloop_GGG_G_12(ntryL,G0H32(1),wf4(:,1),ex5(:),G0H4(4),m4h4x2x4(:,4),heltab3x32(:,:,11))
  Gcoeff(:)%j = (c(2)*(-M(2,:)%j+M(3,:)%j)) * den(3)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(82),h0tab(:,82),[19,12],[0,0],3,2,wf4(:,1),wf4(:,2))
  call Hloop_GGG_G_23(ntryL,G0H32(1),ex5(:),wf4(:,1),G0H4(7),m4h2x4x4(:,8),heltab3x32(:,:,12))
  Gcoeff(:)%j = (c(22)*(M(2,:)%j-M(3,:)%j)) * den(17)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(83),h0tab(:,83),[19,12],[0,0],2,2,wf8(:,1),wf4(:,2))
  call Hloop_QV_A(ntryL,G0H32(1),wf8(:,1),G0H4(3),m3h8x4(:,13),heltab2x32(:,:,71))
  call Hloop_Q_A(ntryL,G0H4(3),19,0,G1H4(2),n2h4(33))
  Gcoeff(:)%j = (c(21)*(M(2,:)%j-M(3,:)%j)) * den(17)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(84),h0tab(:,84),[19,12],[nMT,nMT],2,2,wf8(:,1),wf4(:,2))
  call Hloop_QV_A(ntryL,G0H32(1),wf8(:,1),G0H4(3),m3h8x4(:,14),heltab2x32(:,:,72))
  call Hloop_Q_A(ntryL,G0H4(3),19,nMT,G1H4(16),n2h4(34))
  Gcoeff(:)%j = (c(22)*(M(2,:)%j-M(3,:)%j)) * den(17)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(85),h0tab(:,85),[19,12],[0,0],2,2,wf8(:,1),wf4(:,2))
  call Hloop_QV_A(ntryL,G0H32(1),wf8(:,1),G0H4(3),m3h8x4(:,15),heltab2x32(:,:,73))
  call Hloop_Q_A(ntryL,G0H4(3),19,0,G1H4(12),n2h4(35))
  Gcoeff(:)%j = (c(21)*(M(2,:)%j-M(3,:)%j)) * den(17)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(86),h0tab(:,86),[19,12],[nMB,nMB],2,2,wf8(:,1),wf4(:,2))
  call Hloop_QV_A(ntryL,G0H32(1),wf8(:,1),G0H4(3),m3h8x4(:,16),heltab2x32(:,:,74))
  call Hloop_Q_A(ntryL,G0H4(3),19,nMB,G1H4(21),n2h4(36))
  Gcoeff(:)%j = (c(7)*(M(2,:)%j-M(3,:)%j)) * den(17)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(87),h0tab(:,87),[19,12],[0,0],2,2,wf8(:,1),wf4(:,2))
  call Hloop_CV_D(ntryL,G0H32(1),0,wf8(:,1),19,G1H4(19),m3h8x4(:,17),heltab2x32(:,:,75))
  Gcoeff(:)%j = (c(2)*(-M(2,:)%j+M(3,:)%j)) * den(17)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(88),h0tab(:,88),[19,12],[0,0],2,2,wf8(:,1),wf4(:,2))
  call Hloop_UV_W(ntryL,G0H32(1),0,wf8(:,1),19,G1H4(23),m3h8x4(:,18),heltab2x32(:,:,76))
  Gcoeff(:)%j = (c(22)*(-M(2,:)%j+M(3,:)%j)) * den(14)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(89),h0tab(:,89),[28,3],[0,0],2,2,wf8(:,16),wf4(:,1))
  call Hloop_QV_A(ntryL,G0H32(1),wf8(:,16),G0H4(3),m3h8x4(:,19),heltab2x32(:,:,77))
  call Hloop_Q_A(ntryL,G0H4(3),28,0,G1H4(6),n2h4(37))
  Gcoeff(:)%j = (c(21)*(-M(2,:)%j+M(3,:)%j)) * den(14)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(90),h0tab(:,90),[28,3],[nMT,nMT],2,2,wf8(:,16),wf4(:,1))
  call Hloop_QV_A(ntryL,G0H32(1),wf8(:,16),G0H4(3),m3h8x4(:,20),heltab2x32(:,:,78))
  call Hloop_Q_A(ntryL,G0H4(3),28,nMT,G1H4(4),n2h4(38))
  Gcoeff(:)%j = (c(22)*(-M(2,:)%j+M(3,:)%j)) * den(14)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(91),h0tab(:,91),[28,3],[0,0],2,2,wf8(:,16),wf4(:,1))
  call Hloop_QV_A(ntryL,G0H32(1),wf8(:,16),G0H4(3),m3h8x4(:,21),heltab2x32(:,:,79))
  call Hloop_Q_A(ntryL,G0H4(3),28,0,G1H4(13),n2h4(39))
  Gcoeff(:)%j = (c(21)*(-M(2,:)%j+M(3,:)%j)) * den(14)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(92),h0tab(:,92),[28,3],[nMB,nMB],2,2,wf8(:,16),wf4(:,1))
  call Hloop_QV_A(ntryL,G0H32(1),wf8(:,16),G0H4(3),m3h8x4(:,22),heltab2x32(:,:,80))
  call Hloop_Q_A(ntryL,G0H4(3),28,nMB,G1H4(24),n2h4(40))
  Gcoeff(:)%j = (c(7)*(-M(2,:)%j+M(3,:)%j)) * den(14)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(93),h0tab(:,93),[28,3],[0,0],2,2,wf8(:,16),wf4(:,1))
  call Hloop_CV_D(ntryL,G0H32(1),0,wf8(:,16),28,G1H4(17),m3h8x4(:,23),heltab2x32(:,:,81))
  Gcoeff(:)%j = (c(2)*(M(2,:)%j-M(3,:)%j)) * den(14)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(94),h0tab(:,94),[28,3],[0,0],2,2,wf8(:,16),wf4(:,1))
  call Hloop_UV_W(ntryL,G0H32(1),0,wf8(:,16),28,G1H4(5),m3h8x4(:,24),heltab2x32(:,:,82))
  Gcoeff(:)%j = (c(18)*M(2,:)%j-c(13)*M(4,:)%j) * den(22)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(95),h0tab(:,95),[20,11],[0,nMB],2,2,wf4(:,4),wf8(:,18))
  call Hloop_AQ_V(ntryL,G0H32(1),wf4(:,4),G0H8(5),m3h4x8(:,17),heltab2x32(:,:,83))
  Gcoeff(:)%j = (-(c(26)*M(2,:)%j)+c(25)*M(4,:)%j) * den(19)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(96),h0tab(:,96),[28,3],[0,0],2,2,wf8(:,17),wf4(:,1))
  call Hloop_QV_A(ntryL,G0H32(1),wf8(:,17),G0H4(3),m3h8x4(:,25),heltab2x32(:,:,84))
  call Hloop_Q_A(ntryL,G0H4(3),28,0,G1H4(7),n2h4(41))
  Gcoeff(:)%j = (-(c(24)*M(2,:)%j)+c(23)*M(4,:)%j) * den(19)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(97),h0tab(:,97),[28,3],[nMT,nMT],2,2,wf8(:,17),wf4(:,1))
  call Hloop_QV_A(ntryL,G0H32(1),wf8(:,17),G0H4(3),m3h8x4(:,26),heltab2x32(:,:,85))
  call Hloop_Q_A(ntryL,G0H4(3),28,nMT,G1H4(8),n2h4(42))
  Gcoeff(:)%j = (-(c(26)*M(2,:)%j)+c(25)*M(4,:)%j) * den(19)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(98),h0tab(:,98),[28,3],[0,0],2,2,wf8(:,17),wf4(:,1))
  call Hloop_QV_A(ntryL,G0H32(1),wf8(:,17),G0H4(3),m3h8x4(:,27),heltab2x32(:,:,86))
  call Hloop_Q_A(ntryL,G0H4(3),28,0,G1H4(9),n2h4(43))
  Gcoeff(:)%j = (-(c(24)*M(2,:)%j)+c(23)*M(4,:)%j) * den(19)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(99),h0tab(:,99),[28,3],[nMB,nMB],2,2,wf8(:,17),wf4(:,1))
  call Hloop_QV_A(ntryL,G0H32(1),wf8(:,17),G0H4(3),m3h8x4(:,28),heltab2x32(:,:,87))
  call Hloop_Q_A(ntryL,G0H4(3),28,nMB,G1H4(3),n2h4(44))
  Gcoeff(:)%j = (-(c(20)*M(2,:)%j)+c(16)*M(4,:)%j) * den(19)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(100),h0tab(:,100),[28,3],[0,0],2,2,wf8(:,17),wf4(:,1))
  call Hloop_CV_D(ntryL,G0H32(1),0,wf8(:,17),28,G1H4(11),m3h8x4(:,29),heltab2x32(:,:,88))
  Gcoeff(:)%j = (c(9)*M(2,:)%j-c(8)*M(4,:)%j) * den(19)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(101),h0tab(:,101),[28,3],[0,0],2,2,wf8(:,17),wf4(:,1))
  call Hloop_UV_W(ntryL,G0H32(1),0,wf8(:,17),28,G1H4(18),m3h8x4(:,30),heltab2x32(:,:,89))
  Gcoeff(:)%j = (c(18)*M(3,:)%j-c(13)*M(4,:)%j) * den(27)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(102),h0tab(:,102),[24,7],[nMB,0],2,2,wf4(:,6),wf8(:,20))
  call Hloop_VA_Q(ntryL,G0H32(1),wf4(:,6),G0H8(2),m3h4x8(:,18),heltab2x32(:,:,90))
  call Hloop_A_Q(ntryL,G0H8(2),24,nMB,G1H8(7),n2h8(22))
  Gcoeff(:)%j = (-(c(26)*M(3,:)%j)+c(25)*M(4,:)%j) * den(24)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(103),h0tab(:,103),[28,3],[0,0],2,2,wf8(:,19),wf4(:,1))
  call Hloop_QV_A(ntryL,G0H32(1),wf8(:,19),G0H4(3),m3h8x4(:,31),heltab2x32(:,:,91))
  call Hloop_Q_A(ntryL,G0H4(3),28,0,G1H4(1),n2h4(45))
  Gcoeff(:)%j = (-(c(24)*M(3,:)%j)+c(23)*M(4,:)%j) * den(24)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(104),h0tab(:,104),[28,3],[nMT,nMT],2,2,wf8(:,19),wf4(:,1))
  call Hloop_QV_A(ntryL,G0H32(1),wf8(:,19),G0H4(3),m3h8x4(:,32),heltab2x32(:,:,92))
  call Hloop_Q_A(ntryL,G0H4(3),28,nMT,G1H4(22),n2h4(46))
  Gcoeff(:)%j = (-(c(26)*M(3,:)%j)+c(25)*M(4,:)%j) * den(24)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(105),h0tab(:,105),[28,3],[0,0],2,2,wf8(:,19),wf4(:,1))
  call Hloop_QV_A(ntryL,G0H32(1),wf8(:,19),G0H4(3),m3h8x4(:,33),heltab2x32(:,:,93))
  call Hloop_Q_A(ntryL,G0H4(3),28,0,G1H4(10),n2h4(47))
  Gcoeff(:)%j = (-(c(24)*M(3,:)%j)+c(23)*M(4,:)%j) * den(24)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(106),h0tab(:,106),[28,3],[nMB,nMB],2,2,wf8(:,19),wf4(:,1))
  call Hloop_QV_A(ntryL,G0H32(1),wf8(:,19),G0H4(3),m3h8x4(:,34),heltab2x32(:,:,94))
  call Hloop_Q_A(ntryL,G0H4(3),28,nMB,G1H4(15),n2h4(48))
  Gcoeff(:)%j = (-(c(20)*M(3,:)%j)+c(16)*M(4,:)%j) * den(24)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(107),h0tab(:,107),[28,3],[0,0],2,2,wf8(:,19),wf4(:,1))
  call Hloop_CV_D(ntryL,G0H32(1),0,wf8(:,19),28,G1H4(20),m3h8x4(:,35),heltab2x32(:,:,95))
  Gcoeff(:)%j = (c(9)*M(3,:)%j-c(8)*M(4,:)%j) * den(24)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(108),h0tab(:,108),[28,3],[0,0],2,2,wf8(:,19),wf4(:,1))
  call Hloop_UV_W(ntryL,G0H32(1),0,wf8(:,19),28,G1H4(14),m3h8x4(:,36),heltab2x32(:,:,96))
  Gcoeff(:)%j = (c(25)*M(1,:)%j-c(26)*M(3,:)%j) * den(32)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(109),h0tab(:,109),[19,12],[0,0],2,2,wf8(:,4),wf4(:,2))
  call Hloop_QV_A(ntryL,G0H32(1),wf8(:,4),G0H4(3),m3h8x4(:,37),heltab2x32(:,:,97))
  call Hloop_Q_A(ntryL,G0H4(3),19,0,G1H4(25),n2h4(49))
  Gcoeff(:)%j = (c(23)*M(1,:)%j-c(24)*M(3,:)%j) * den(32)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(110),h0tab(:,110),[19,12],[nMT,nMT],2,2,wf8(:,4),wf4(:,2))
  call Hloop_QV_A(ntryL,G0H32(1),wf8(:,4),G0H4(3),m3h8x4(:,38),heltab2x32(:,:,98))
  call Hloop_Q_A(ntryL,G0H4(3),19,nMT,G1H4(26),n2h4(50))
  Gcoeff(:)%j = (c(25)*M(1,:)%j-c(26)*M(3,:)%j) * den(32)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(111),h0tab(:,111),[19,12],[0,0],2,2,wf8(:,4),wf4(:,2))
  call Hloop_QV_A(ntryL,G0H32(1),wf8(:,4),G0H4(3),m3h8x4(:,39),heltab2x32(:,:,99))
  call Hloop_Q_A(ntryL,G0H4(3),19,0,G1H4(27),n2h4(51))
  Gcoeff(:)%j = (c(23)*M(1,:)%j-c(24)*M(3,:)%j) * den(32)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(112),h0tab(:,112),[19,12],[nMB,nMB],2,2,wf8(:,4),wf4(:,2))
  call Hloop_QV_A(ntryL,G0H32(1),wf8(:,4),G0H4(3),m3h8x4(:,40),heltab2x32(:,:,100))
  call Hloop_Q_A(ntryL,G0H4(3),19,nMB,G1H4(28),n2h4(52))
  Gcoeff(:)%j = (c(16)*M(1,:)%j-c(20)*M(3,:)%j) * den(32)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(113),h0tab(:,113),[19,12],[0,0],2,2,wf8(:,4),wf4(:,2))
  call Hloop_CV_D(ntryL,G0H32(1),0,wf8(:,4),19,G1H4(29),m3h8x4(:,41),heltab2x32(:,:,101))
  Gcoeff(:)%j = (-(c(8)*M(1,:)%j)+c(9)*M(3,:)%j) * den(32)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(114),h0tab(:,114),[19,12],[0,0],2,2,wf8(:,4),wf4(:,2))
  call Hloop_UV_W(ntryL,G0H32(1),0,wf8(:,4),19,G1H4(30),m3h8x4(:,42),heltab2x32(:,:,102))
  Gcoeff(:)%j = (-(c(13)*M(1,:)%j)+c(18)*M(3,:)%j) * den(30)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(115),h0tab(:,115),[17,14],[0,nMT],2,2,wf4(:,8),wf8(:,22))
  call Hloop_AQ_V(ntryL,G0H32(1),wf4(:,8),G0H8(4),m3h4x8(:,19),heltab2x32(:,:,103))
  Gcoeff(:)%j = (c(25)*M(1,:)%j-c(26)*M(2,:)%j) * den(37)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(116),h0tab(:,116),[19,12],[0,0],2,2,wf8(:,5),wf4(:,2))
  call Hloop_QV_A(ntryL,G0H32(1),wf8(:,5),G0H4(3),m3h8x4(:,43),heltab2x32(:,:,104))
  call Hloop_Q_A(ntryL,G0H4(3),19,0,G1H4(31),n2h4(53))
  Gcoeff(:)%j = (c(23)*M(1,:)%j-c(24)*M(2,:)%j) * den(37)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(117),h0tab(:,117),[19,12],[nMT,nMT],2,2,wf8(:,5),wf4(:,2))
  call Hloop_QV_A(ntryL,G0H32(1),wf8(:,5),G0H4(3),m3h8x4(:,44),heltab2x32(:,:,105))
  call Hloop_Q_A(ntryL,G0H4(3),19,nMT,G1H4(32),n2h4(54))
  Gcoeff(:)%j = (c(25)*M(1,:)%j-c(26)*M(2,:)%j) * den(37)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(118),h0tab(:,118),[19,12],[0,0],2,2,wf8(:,5),wf4(:,2))
  call Hloop_QV_A(ntryL,G0H32(1),wf8(:,5),G0H4(3),m3h8x4(:,45),heltab2x32(:,:,106))
  call Hloop_Q_A(ntryL,G0H4(3),19,0,G1H4(33),n2h4(55))
  Gcoeff(:)%j = (c(23)*M(1,:)%j-c(24)*M(2,:)%j) * den(37)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(119),h0tab(:,119),[19,12],[nMB,nMB],2,2,wf8(:,5),wf4(:,2))
  call Hloop_QV_A(ntryL,G0H32(1),wf8(:,5),G0H4(3),m3h8x4(:,46),heltab2x32(:,:,107))
  call Hloop_Q_A(ntryL,G0H4(3),19,nMB,G1H4(34),n2h4(56))
  Gcoeff(:)%j = (c(16)*M(1,:)%j-c(20)*M(2,:)%j) * den(37)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(120),h0tab(:,120),[19,12],[0,0],2,2,wf8(:,5),wf4(:,2))
  call Hloop_CV_D(ntryL,G0H32(1),0,wf8(:,5),19,G1H4(35),m3h8x4(:,47),heltab2x32(:,:,108))
  Gcoeff(:)%j = (-(c(8)*M(1,:)%j)+c(9)*M(2,:)%j) * den(37)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(121),h0tab(:,121),[19,12],[0,0],2,2,wf8(:,5),wf4(:,2))
  call Hloop_UV_W(ntryL,G0H32(1),0,wf8(:,5),19,G1H4(36),m3h8x4(:,48),heltab2x32(:,:,109))
  Gcoeff(:)%j = (-(c(13)*M(1,:)%j)+c(18)*M(2,:)%j) * den(35)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(122),h0tab(:,122),[18,13],[nMT,0],2,2,wf4(:,10),wf8(:,24))
  call Hloop_VA_Q(ntryL,G0H32(1),wf4(:,10),G0H8(1),m3h4x8(:,20),heltab2x32(:,:,110))
  call Hloop_A_Q(ntryL,G0H8(1),18,nMT,G1H8(1),n2h8(23))
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(14),[G1H4(18),G1H4(5),G0H4(6),G0H4(1),G0H4(2)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(36),[G1H4(30),G1H4(23),G0H4(7),G0H4(4),G0H4(5)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(33),[G1H4(31),G1H4(27),G1H4(25),G1H4(12),G1H4(2)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(32),[G1H4(26),G1H4(16)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(34),[G1H4(28),G1H4(21)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(35),[G1H4(29),G1H4(19)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(10),[G1H4(1),G1H4(9),G1H4(7),G1H4(13),G1H4(6)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(22),[G1H4(8),G1H4(4)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(15),[G1H4(3),G1H4(24)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(20),[G1H4(11),G1H4(17)])
  call Hcheck_last_GGG_G_12(ntryL,l_switch,G1H16(1),wf4(:,1),wf4(:,2),G1tensor(1),m4h4x4x1(:,1),heltab3x16(:,:,1))
  call Hcheck_last_GGG_G_12(ntryL,l_switch,G1H16(3),wf4(:,2),wf4(:,1),G1tensor(31),m4h4x4x1(:,2),heltab3x16(:,:,2))
  call Hcheck_last_GGG_G_23(ntryL,l_switch,G1H16(5),wf4(:,1),wf4(:,2),G1tensor(24),m4h4x4x1(:,3),heltab3x16(:,:,3))
  call Hcheck_last_UV_W(ntryL,l_switch,G1H4(14),28,wf4(:,1),3,G2tensor(39),m3h4x1(:,27),heltab2x4(:,:,70))
  call Hcheck_last_UV_W(ntryL,l_switch,G1H4(36),19,wf4(:,2),12,G2tensor(22),m3h4x1(:,28),heltab2x4(:,:,71))
  call Hloop_QV_A(ntryL,G1H4(33),wf4(:,2),G1H1(1),m3h4x1(:,29),heltab2x4(:,:,72))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,0,G2tensor(23),n2h1(64))
  call Hloop_QV_A(ntryL,G1H4(32),wf4(:,2),G1H1(1),m3h4x1(:,30),heltab2x4(:,:,73))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,nMT,G2tensor(24),n2h1(65))
  call Hloop_QV_A(ntryL,G1H4(34),wf4(:,2),G1H1(1),m3h4x1(:,31),heltab2x4(:,:,74))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,nMB,G2tensor(42),n2h1(66))
  call Hcheck_last_CV_D(ntryL,l_switch,G1H4(35),19,wf4(:,2),12,G2tensor(25),m3h4x1(:,32),heltab2x4(:,:,75))
  call Hloop_QV_A(ntryL,G1H4(10),wf4(:,1),G1H1(1),m3h4x1(:,33),heltab2x4(:,:,76))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,0,G2tensor(26),n2h1(67))
  call Hloop_QV_A(ntryL,G1H4(22),wf4(:,1),G1H1(1),m3h4x1(:,34),heltab2x4(:,:,77))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,nMT,G2tensor(35),n2h1(68))
  call Hloop_QV_A(ntryL,G1H4(15),wf4(:,1),G1H1(1),m3h4x1(:,35),heltab2x4(:,:,78))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,nMB,G2tensor(37),n2h1(69))
  call Hcheck_last_CV_D(ntryL,l_switch,G1H4(20),28,wf4(:,1),3,G2tensor(45),m3h4x1(:,36),heltab2x4(:,:,79))
  call Hloop_VA_Q(ntryL,G0H8(5),wf8(:,18),G0H1(1),m3h8x1(:,7),heltab2x8(:,:,46))
  call Hcheck_last_A_Q(ntryL,l_switch,G0H1(1),31,nMB,G1tensor(36),n2h1(70))
  call Hcheck_last_AQ_V(ntryL,l_switch,G1H8(7),wf8(:,20),G1tensor(9),m3h8x1(:,8),heltab2x8(:,:,47))
  call Hloop_VA_Q(ntryL,G0H8(4),wf8(:,22),G0H1(1),m3h8x1(:,9),heltab2x8(:,:,48))
  call Hcheck_last_A_Q(ntryL,l_switch,G0H1(1),31,nMT,G1tensor(5),n2h1(71))
  call Hcheck_last_AQ_V(ntryL,l_switch,G1H8(1),wf8(:,24),G1tensor(11),m3h8x1(:,10),heltab2x8(:,:,49))
  call ol_merge_tensors(G2tensor(45),[G2tensor(26),G2tensor(39),G0tensor(88),G0tensor(24),G0tensor(52),G0tensor(50),G0tensor(81) &
    ,G0tensor(6)])
  call ol_merge_tensors(G2tensor(25),[G2tensor(23),G2tensor(22),G0tensor(103),G0tensor(27),G0tensor(18),G0tensor(17),G0tensor(131) &
    ,G0tensor(11)])
  call ol_merge_tensors(G1tensor(24),[G1tensor(31),G1tensor(1),G0tensor(83),G0tensor(38),G0tensor(37),G0tensor(5),G0tensor(61) &
    ,G0tensor(36),G0tensor(16)])
  call ol_merge_tensors(G0tensor(279),[G0tensor(236),G0tensor(225),G0tensor(104),G0tensor(89),G0tensor(84),G0tensor(77) &
    ,G0tensor(107),G0tensor(26)])
  call ol_merge_tensors(G0tensor(108),[G0tensor(60),G0tensor(31)])
  call ol_merge_tensors(G0tensor(312),[G0tensor(306),G0tensor(299),G0tensor(294),G0tensor(287),G0tensor(281),G0tensor(275) &
    ,G0tensor(270),G0tensor(264),G0tensor(258),G0tensor(251),G0tensor(246),G0tensor(240),G0tensor(234),G0tensor(227),G0tensor(221) &
    ,G0tensor(215),G0tensor(209),G0tensor(204),G0tensor(197),G0tensor(191),G0tensor(185),G0tensor(174),G0tensor(144),G0tensor(124) &
    ,G0tensor(102),G0tensor(62),G0tensor(42),G0tensor(135),G0tensor(132),G0tensor(32),G0tensor(28),G0tensor(22),G0tensor(115) &
    ,G0tensor(120),G0tensor(95),G0tensor(9),G0tensor(116),G0tensor(91),G0tensor(41)])
  call ol_merge_tensors(G0tensor(284),[G0tensor(188),G0tensor(168),G0tensor(154),G0tensor(170),G0tensor(175),G0tensor(51)])
  call ol_merge_tensors(G0tensor(304),[G0tensor(292),G0tensor(69),G0tensor(12),G0tensor(56)])
  call ol_merge_tensors(G0tensor(311),[G0tensor(305),G0tensor(300),G0tensor(293),G0tensor(288),G0tensor(282),G0tensor(276) &
    ,G0tensor(269),G0tensor(263),G0tensor(257),G0tensor(252),G0tensor(245),G0tensor(239),G0tensor(233),G0tensor(228),G0tensor(222) &
    ,G0tensor(216),G0tensor(210),G0tensor(203),G0tensor(198),G0tensor(192),G0tensor(186),G0tensor(179),G0tensor(159),G0tensor(134) &
    ,G0tensor(92),G0tensor(109),G0tensor(59),G0tensor(150),G0tensor(147),G0tensor(112),G0tensor(105),G0tensor(23),G0tensor(7) &
    ,G0tensor(167),G0tensor(40),G0tensor(35),G0tensor(166),G0tensor(141),G0tensor(66)])
  call ol_merge_tensors(G0tensor(303),[G0tensor(255),G0tensor(200),G0tensor(164),G0tensor(114),G0tensor(130),G0tensor(143) &
    ,G0tensor(25),G0tensor(101),G0tensor(76)])
  call ol_merge_tensors(G1tensor(9),[G0tensor(208),G0tensor(184),G0tensor(123),G0tensor(15),G0tensor(86)])
  call ol_merge_tensors(G1tensor(36),[G0tensor(214),G0tensor(190),G0tensor(34),G0tensor(33),G0tensor(106)])
  call ol_merge_tensors(G0tensor(220),[G0tensor(196),G0tensor(169),G0tensor(47),G0tensor(110),G0tensor(111)])
  call ol_merge_tensors(G0tensor(248),[G0tensor(224),G0tensor(207),G0tensor(67),G0tensor(20),G0tensor(151),G0tensor(126)])
  call ol_merge_tensors(G1tensor(11),[G0tensor(256),G0tensor(232),G0tensor(44),G0tensor(65),G0tensor(136)])
  call ol_merge_tensors(G1tensor(5),[G0tensor(262),G0tensor(238),G0tensor(139),G0tensor(43),G0tensor(156)])
  call ol_merge_tensors(G0tensor(268),[G0tensor(244),G0tensor(158),G0tensor(48),G0tensor(13),G0tensor(161)])
  call ol_merge_tensors(G2tensor(37),[G0tensor(57),G0tensor(117),G0tensor(155),G0tensor(176)])
  call ol_merge_tensors(G0tensor(308),[G0tensor(291),G0tensor(231),G0tensor(93),G0tensor(53),G0tensor(100),G0tensor(75)])
  call ol_merge_tensors(G2tensor(42),[G0tensor(128),G0tensor(113),G0tensor(160)])
  call ol_merge_tensors(G0tensor(309),[G0tensor(272),G0tensor(212),G0tensor(201),G0tensor(129),G0tensor(145),G0tensor(73) &
    ,G0tensor(80),G0tensor(180),G0tensor(137)])
  call ol_merge_tensors(G2tensor(35),[G0tensor(178),G0tensor(165),G0tensor(45)])
  call ol_merge_tensors(G0tensor(296),[G0tensor(278),G0tensor(183),G0tensor(87),G0tensor(72),G0tensor(8),G0tensor(97) &
    ,G0tensor(153),G0tensor(140)])
  call ol_merge_tensors(G0tensor(74),[G0tensor(64),G0tensor(82)])
  call ol_merge_tensors(G0tensor(297),[G0tensor(260),G0tensor(249),G0tensor(133),G0tensor(68),G0tensor(58),G0tensor(148)])
  call ol_merge_tensors(G0tensor(286),[G0tensor(274),G0tensor(54),G0tensor(29),G0tensor(70)])
  call ol_merge_tensors(G2tensor(24),[G0tensor(157),G0tensor(149),G0tensor(99),G0tensor(94)])
  call ol_merge_tensors(G0tensor(194),[G0tensor(182),G0tensor(173)])
  call ol_merge_tensors(G0tensor(302),[G0tensor(298),G0tensor(195),G0tensor(189)])
  call ol_merge_tensors(G0tensor(267),[G0tensor(261),G0tensor(218),G0tensor(206),G0tensor(202)])
  call ol_merge_tensors(G0tensor(266),[G0tensor(254),G0tensor(250),G0tensor(219),G0tensor(213)])
  call ol_merge_tensors(G0tensor(273),[G0tensor(242),G0tensor(230),G0tensor(226)])
  call ol_merge_tensors(G0tensor(310),[G0tensor(243),G0tensor(237)])
  call ol_merge_tensors(G0tensor(290),[G0tensor(285),G0tensor(280)])
call TI_bubble_red(G2tensor(45),28,mass2set(:,1),G0tensor(1),M2L1R1)
call TI_bubble_red(G2tensor(25),19,mass2set(:,1),G0tensor(21),M2L1R1)
call TI_bubble_red(G2tensor(37),28,mass2set(:,2),G0tensor(46),M2L1R1,G0tensor(71))
call TI_bubble_red(G2tensor(42),19,mass2set(:,2),G0tensor(96),M2L1R1,G0tensor(121))
call TI_bubble_red(G2tensor(35),28,mass2set(:,3),G0tensor(146),M2L1R1,G0tensor(171))
call TI_bubble_red(G2tensor(24),19,mass2set(:,3),G0tensor(4),M2L1R1,G0tensor(10))
  call ol_merge_tensors(G0tensor(121),[G0tensor(71),G0tensor(312)])
  call ol_merge_tensors(G0tensor(10),[G0tensor(171),G0tensor(311)])
call TI_bubble_red(G1tensor(24),16,mass2set(:,1),G0tensor(30),M2L1R1)
call TI_bubble_red(G1tensor(9),24,mass2set(:,4),G0tensor(3),M2L1R1,G0tensor(162))
call TI_bubble_red(G1tensor(36),20,mass2set(:,5),G0tensor(172),M2L1R1,G0tensor(177))
call TI_bubble_red(G1tensor(11),18,mass2set(:,6),G0tensor(2),M2L1R1,G0tensor(90))
call TI_bubble_red(G1tensor(5),17,mass2set(:,7),G0tensor(163),M2L1R1,G0tensor(181))
  call ol_merge_tensors(G0tensor(177),[G0tensor(162),G0tensor(121)])
  call ol_merge_tensors(G0tensor(181),[G0tensor(90),G0tensor(10)])
  call ol_merge_tensors(T0sum(95),[G0tensor(1)])
  call ol_merge_tensors(T0sum(96),[G0tensor(21)])
  call ol_merge_tensors(T0sum(97),[G0tensor(30)])
  call ol_merge_tensors(T0sum(98),[G0tensor(279)])
  call ol_merge_tensors(T0sum(99),[G0tensor(108)])
  call ol_merge_tensors(T0sum(100),[G0tensor(177)])
  call ol_merge_tensors(T0sum(101),[G0tensor(284)])
  call ol_merge_tensors(T0sum(102),[G0tensor(304)])
  call ol_merge_tensors(T0sum(103),[G0tensor(181)])
  call ol_merge_tensors(T0sum(104),[G0tensor(303)])
  call ol_merge_tensors(T0sum(105),[G0tensor(3)])
  call ol_merge_tensors(T0sum(106),[G0tensor(172)])
  call ol_merge_tensors(T0sum(107),[G0tensor(220)])
  call ol_merge_tensors(T0sum(108),[G0tensor(248)])
  call ol_merge_tensors(T0sum(109),[G0tensor(2)])
  call ol_merge_tensors(T0sum(110),[G0tensor(163)])
  call ol_merge_tensors(T0sum(111),[G0tensor(268)])
  call ol_merge_tensors(T0sum(112),[G0tensor(46)])
  call ol_merge_tensors(T0sum(113),[G0tensor(308)])
  call ol_merge_tensors(T0sum(114),[G0tensor(96)])
  call ol_merge_tensors(T0sum(115),[G0tensor(309)])
  call ol_merge_tensors(T0sum(116),[G0tensor(146)])
  call ol_merge_tensors(T0sum(117),[G0tensor(296)])
  call ol_merge_tensors(T0sum(118),[G0tensor(74)])
  call ol_merge_tensors(T0sum(119),[G0tensor(297)])
  call ol_merge_tensors(T0sum(120),[G0tensor(286)])
  call ol_merge_tensors(T0sum(121),[G0tensor(4)])
  call ol_merge_tensors(T0sum(122),[G0tensor(194)])
  call ol_merge_tensors(T0sum(123),[G0tensor(302)])
  call ol_merge_tensors(T0sum(124),[G0tensor(267)])
  call ol_merge_tensors(T0sum(125),[G0tensor(266)])
  call ol_merge_tensors(T0sum(126),[G0tensor(273)])
  call ol_merge_tensors(T0sum(127),[G0tensor(310)])
  call ol_merge_tensors(T0sum(128),[G0tensor(290)])


! Compute scalar Master integrals 

  call compute_scalar_box([ 18, 19, 23 ],masses2_46,RedSet_4(1),ScalarBoxes(1))
  call compute_scalar_box([ 16, 19, 23 ],masses2_33,RedSet_4(2),ScalarBoxes(2))
  call compute_scalar_box([ 16, 18, 23 ],masses2_38,RedSet_4(3),ScalarBoxes(3))
  call compute_scalar_box([ 16, 18, 19 ],masses2_36,RedSet_4(4),ScalarBoxes(4))
  call compute_scalar_box([ 2, 3, 7 ],masses2_46,RedSet_4(5),ScalarBoxes(5))
  call compute_scalar_box([ 18, 19, 27 ],masses2_46,RedSet_4(6),ScalarBoxes(6))
  call compute_scalar_box([ 16, 19, 27 ],masses2_33,RedSet_4(7),ScalarBoxes(7))
  call compute_scalar_box([ 16, 18, 27 ],masses2_38,RedSet_4(8),ScalarBoxes(8))
  call compute_scalar_box([ 2, 3, 11 ],masses2_46,RedSet_4(9),ScalarBoxes(9))
  call compute_scalar_box([ 17, 19, 23 ],masses2_46,RedSet_4(10),ScalarBoxes(10))
  call compute_scalar_box([ 16, 17, 23 ],masses2_38,RedSet_4(11),ScalarBoxes(11))
  call compute_scalar_box([ 16, 17, 19 ],masses2_36,RedSet_4(12),ScalarBoxes(12))
  call compute_scalar_box([ 1, 3, 7 ],masses2_46,RedSet_4(13),ScalarBoxes(13))
  call compute_scalar_box([ 17, 19, 27 ],masses2_46,RedSet_4(14),ScalarBoxes(14))
  call compute_scalar_box([ 16, 17, 27 ],masses2_38,RedSet_4(15),ScalarBoxes(15))
  call compute_scalar_box([ 1, 3, 11 ],masses2_46,RedSet_4(16),ScalarBoxes(16))
  call compute_scalar_box([ 20, 21, 23 ],masses2_37,RedSet_4(17),ScalarBoxes(17))
  call compute_scalar_box([ 16, 21, 23 ],masses2_44,RedSet_4(18),ScalarBoxes(18))
  call compute_scalar_box([ 16, 20, 23 ],masses2_40,RedSet_4(19),ScalarBoxes(19))
  call compute_scalar_box([ 16, 20, 21 ],masses2_42,RedSet_4(20),ScalarBoxes(20))
  call compute_scalar_box([ 4, 5, 7 ],masses2_37,RedSet_4(21),ScalarBoxes(21))
  call compute_scalar_box([ 20, 22, 23 ],masses2_37,RedSet_4(22),ScalarBoxes(22))
  call compute_scalar_box([ 16, 22, 23 ],masses2_44,RedSet_4(23),ScalarBoxes(23))
  call compute_scalar_box([ 16, 20, 22 ],masses2_42,RedSet_4(24),ScalarBoxes(24))
  call compute_scalar_box([ 4, 6, 7 ],masses2_37,RedSet_4(25),ScalarBoxes(25))
  call compute_scalar_box([ 17, 21, 29 ],masses2_34,RedSet_4(26),ScalarBoxes(26))
  call compute_scalar_box([ 16, 21, 29 ],masses2_49,RedSet_4(27),ScalarBoxes(27))
  call compute_scalar_box([ 16, 17, 29 ],masses2_45,RedSet_4(28),ScalarBoxes(28))
  call compute_scalar_box([ 16, 17, 21 ],masses2_47,RedSet_4(29),ScalarBoxes(29))
  call compute_scalar_box([ 1, 5, 13 ],masses2_34,RedSet_4(30),ScalarBoxes(30))
  call compute_scalar_box([ 17, 25, 29 ],masses2_34,RedSet_4(31),ScalarBoxes(31))
  call compute_scalar_box([ 16, 25, 29 ],masses2_49,RedSet_4(32),ScalarBoxes(32))
  call compute_scalar_box([ 16, 17, 25 ],masses2_47,RedSet_4(33),ScalarBoxes(33))
  call compute_scalar_box([ 1, 9, 13 ],masses2_34,RedSet_4(34),ScalarBoxes(34))
! end of process


end subroutine vamp_1

end module ol_vamp_1_ppttj_ttxbbxg_1_/**/REALKIND
