
module ol_colourmatrix_ppttj_ttxgggg_1_/**/REALKIND
  use KIND_TYPES, only: REALKIND
  implicit none
  logical, save           :: colmat_not_initialised = .true.
  complex(REALKIND), save :: K1(552,24)
  contains
  subroutine colourmatrix_init
    use ol_parameters_decl_/**/REALKIND, only: CI
    implicit none
    integer :: k, co
    colmat_not_initialised = .false.
    ! colour matrix

  K1(  1,:) = [  3072,  -384,  -384,    48,    48,   480,  -384,    48,    48,    -6,    -6,   -60,    48,    -6,   480,   -60, &
                 426,   372,    -6,   -60,   -60,   372,   372,  -168]
  K1(  2,:) = [  -384,  3072,    48,   480,  -384,    48,    48,  -384,    -6,   -60,    48,    -6,    -6,   -60,   -60,   372, &
                 372,  -168,    48,    -6,   480,   -60,   426,   372]
  K1(  3,:) = [  -384,    48,  3072,  -384,   480,    48,    48,    -6,   480,   -60,   426,   372,  -384,    48,    48,    -6, &
                  -6,   -60,   -60,    -6,   372,  -168,   -60,   372]
  K1(  4,:) = [    48,   480,  -384,  3072,    48,  -384,    -6,   -60,   -60,   372,   372,  -168,    48,  -384,    -6,   -60, &
                  48,    -6,    -6,    48,   426,   372,   480,   -60]
  K1(  5,:) = [    48,  -384,   480,    48,  3072,  -384,    -6,    48,   426,   372,   480,   -60,   -60,    -6,   372,  -168, &
                 -60,   372,  -384,    48,    48,    -6,    -6,   -60]
  K1(  6,:) = [   480,    48,    48,  -384,  -384,  3072,   -60,    -6,   372,  -168,   -60,   372,    -6,    48,   426,   372, &
                 480,   -60,    48,  -384,    -6,   -60,    48,    -6]
  K1(  7,:) = [  -384,    48,    48,    -6,    -6,   -60,  3072,  -384,  -384,    48,    48,   480,   480,   -60,    48,    -6, &
                 372,   426,   -60,   372,    -6,   -60,  -168,   372]
  K1(  8,:) = [    48,  -384,    -6,   -60,    48,    -6,  -384,  3072,    48,   480,  -384,    48,   -60,   372,    -6,   -60, &
                -168,   372,   480,   -60,    48,    -6,   372,   426]
  K1(  9,:) = [    48,    -6,   480,   -60,   426,   372,  -384,    48,  3072,  -384,   480,    48,    48,    -6,  -384,    48, &
                 -60,    -6,   372,  -168,   -60,    -6,   372,   -60]
  K1( 10,:) = [    -6,   -60,   -60,   372,   372,  -168,    48,   480,  -384,  3072,    48,  -384,    -6,   -60,    48,  -384, &
                  -6,    48,   426,   372,    -6,    48,   -60,   480]
  K1( 11,:) = [    -6,    48,   426,   372,   480,   -60,    48,  -384,   480,    48,  3072,  -384,   372,  -168,   -60,    -6, &
                 372,   -60,    48,    -6,  -384,    48,   -60,    -6]
  K1( 12,:) = [   -60,    -6,   372,  -168,   -60,   372,   480,    48,    48,  -384,  -384,  3072,   426,   372,    -6,    48, &
                 -60,   480,    -6,   -60,    48,  -384,    -6,    48]
  K1( 13,:) = [    48,    -6,  -384,    48,   -60,    -6,   480,   -60,    48,    -6,   372,   426,  3072,  -384,  -384,    48, &
                  48,   480,   372,   -60,  -168,   372,    -6,   -60]
  K1( 14,:) = [    -6,   -60,    48,  -384,    -6,    48,   -60,   372,    -6,   -60,  -168,   372,  -384,  3072,    48,   480, &
                -384,    48,   -60,   480,   372,   426,    48,    -6]
  K1( 15,:) = [   480,   -60,    48,    -6,   372,   426,    48,    -6,  -384,    48,   -60,    -6,  -384,    48,  3072,  -384, &
                 480,    48,  -168,   372,   372,   -60,   -60,    -6]
  K1( 16,:) = [   -60,   372,    -6,   -60,  -168,   372,    -6,   -60,    48,  -384,    -6,    48,    48,   480,  -384,  3072, &
                  48,  -384,   372,   426,   -60,   480,    -6,    48]
  K1( 17,:) = [   426,   372,    -6,    48,   -60,   480,   372,  -168,   -60,    -6,   372,   -60,    48,  -384,   480,    48, &
                3072,  -384,    -6,    48,   -60,    -6,  -384,    48]
  K1( 18,:) = [   372,  -168,   -60,    -6,   372,   -60,   426,   372,    -6,    48,   -60,   480,   480,    48,    48,  -384, &
                -384,  3072,   -60,    -6,    -6,    48,    48,  -384]
  K1( 19,:) = [    -6,    48,   -60,    -6,  -384,    48,   -60,   480,   372,   426,    48,    -6,   372,   -60,  -168,   372, &
                  -6,   -60,  3072,  -384,  -384,    48,    48,   480]
  K1( 20,:) = [   -60,    -6,    -6,    48,    48,  -384,   372,   -60,  -168,   372,    -6,   -60,   -60,   480,   372,   426, &
                  48,    -6,  -384,  3072,    48,   480,  -384,    48]
  K1( 21,:) = [   -60,   480,   372,   426,    48,    -6,    -6,    48,   -60,    -6,  -384,    48,  -168,   372,   372,   -60, &
                 -60,    -6,  -384,    48,  3072,  -384,   480,    48]
  K1( 22,:) = [   372,   -60,  -168,   372,    -6,   -60,   -60,    -6,    -6,    48,    48,  -384,   372,   426,   -60,   480, &
                  -6,    48,    48,   480,  -384,  3072,    48,  -384]
  K1( 23,:) = [   372,   426,   -60,   480,    -6,    48,  -168,   372,   372,   -60,   -60,    -6,    -6,    48,   -60,    -6, &
                -384,    48,    48,  -384,   480,    48,  3072,  -384]
  K1( 24,:) = [  -168,   372,   372,   -60,   -60,    -6,   372,   426,   -60,   480,    -6,    48,   -60,    -6,    -6,    48, &
                  48,  -384,   480,    48,    48,  -384,  -384,  3072]
  K1( 25,:) = [  4096,  -512,  -512,    64,    64,   640,  -512,    64,    64,    -8,    -8,   -80,    64,    -8,   640,   -80, &
                 568,   496,    -8,   -80,   -80,   496,   496,  -224]
  K1( 26,:) = [  -512,  4096,    64,   640,  -512,    64,    64,  -512,    -8,   -80,    64,    -8,    -8,   -80,   -80,   496, &
                 496,  -224,    64,    -8,   640,   -80,   568,   496]
  K1( 27,:) = [  -512,    64,  4096,  -512,   640,    64,    64,    -8,   640,   -80,   568,   496,  -512,    64,    64,    -8, &
                  -8,   -80,   -80,    -8,   496,  -224,   -80,   496]
  K1( 28,:) = [    64,   640,  -512,  4096,    64,  -512,    -8,   -80,   -80,   496,   496,  -224,    64,  -512,    -8,   -80, &
                  64,    -8,    -8,    64,   568,   496,   640,   -80]
  K1( 29,:) = [    64,  -512,   640,    64,  4096,  -512,    -8,    64,   568,   496,   640,   -80,   -80,    -8,   496,  -224, &
                 -80,   496,  -512,    64,    64,    -8,    -8,   -80]
  K1( 30,:) = [   640,    64,    64,  -512,  -512,  4096,   -80,    -8,   496,  -224,   -80,   496,    -8,    64,   568,   496, &
                 640,   -80,    64,  -512,    -8,   -80,    64,    -8]
  K1( 31,:) = [  -512,    64,    64,    -8,    -8,   -80,  4096,  -512,  -512,    64,    64,   640,   640,   -80,    64,    -8, &
                 496,   568,   -80,   496,    -8,   -80,  -224,   496]
  K1( 32,:) = [    64,  -512,    -8,   -80,    64,    -8,  -512,  4096,    64,   640,  -512,    64,   -80,   496,    -8,   -80, &
                -224,   496,   640,   -80,    64,    -8,   496,   568]
  K1( 33,:) = [    64,    -8,   640,   -80,   568,   496,  -512,    64,  4096,  -512,   640,    64,    64,    -8,  -512,    64, &
                 -80,    -8,   496,  -224,   -80,    -8,   496,   -80]
  K1( 34,:) = [    -8,   -80,   -80,   496,   496,  -224,    64,   640,  -512,  4096,    64,  -512,    -8,   -80,    64,  -512, &
                  -8,    64,   568,   496,    -8,    64,   -80,   640]
  K1( 35,:) = [    -8,    64,   568,   496,   640,   -80,    64,  -512,   640,    64,  4096,  -512,   496,  -224,   -80,    -8, &
                 496,   -80,    64,    -8,  -512,    64,   -80,    -8]
  K1( 36,:) = [   -80,    -8,   496,  -224,   -80,   496,   640,    64,    64,  -512,  -512,  4096,   568,   496,    -8,    64, &
                 -80,   640,    -8,   -80,    64,  -512,    -8,    64]
  K1( 37,:) = [    64,    -8,  -512,    64,   -80,    -8,   640,   -80,    64,    -8,   496,   568,  4096,  -512,  -512,    64, &
                  64,   640,   496,   -80,  -224,   496,    -8,   -80]
  K1( 38,:) = [    -8,   -80,    64,  -512,    -8,    64,   -80,   496,    -8,   -80,  -224,   496,  -512,  4096,    64,   640, &
                -512,    64,   -80,   640,   496,   568,    64,    -8]
  K1( 39,:) = [   640,   -80,    64,    -8,   496,   568,    64,    -8,  -512,    64,   -80,    -8,  -512,    64,  4096,  -512, &
                 640,    64,  -224,   496,   496,   -80,   -80,    -8]
  K1( 40,:) = [   -80,   496,    -8,   -80,  -224,   496,    -8,   -80,    64,  -512,    -8,    64,    64,   640,  -512,  4096, &
                  64,  -512,   496,   568,   -80,   640,    -8,    64]
  K1( 41,:) = [   568,   496,    -8,    64,   -80,   640,   496,  -224,   -80,    -8,   496,   -80,    64,  -512,   640,    64, &
                4096,  -512,    -8,    64,   -80,    -8,  -512,    64]
  K1( 42,:) = [   496,  -224,   -80,    -8,   496,   -80,   568,   496,    -8,    64,   -80,   640,   640,    64,    64,  -512, &
                -512,  4096,   -80,    -8,    -8,    64,    64,  -512]
  K1( 43,:) = [    -8,    64,   -80,    -8,  -512,    64,   -80,   640,   496,   568,    64,    -8,   496,   -80,  -224,   496, &
                  -8,   -80,  4096,  -512,  -512,    64,    64,   640]
  K1( 44,:) = [   -80,    -8,    -8,    64,    64,  -512,   496,   -80,  -224,   496,    -8,   -80,   -80,   640,   496,   568, &
                  64,    -8,  -512,  4096,    64,   640,  -512,    64]
  K1( 45,:) = [   -80,   640,   496,   568,    64,    -8,    -8,    64,   -80,    -8,  -512,    64,  -224,   496,   496,   -80, &
                 -80,    -8,  -512,    64,  4096,  -512,   640,    64]
  K1( 46,:) = [   496,   -80,  -224,   496,    -8,   -80,   -80,    -8,    -8,    64,    64,  -512,   496,   568,   -80,   640, &
                  -8,    64,    64,   640,  -512,  4096,    64,  -512]
  K1( 47,:) = [   496,   568,   -80,   640,    -8,    64,  -224,   496,   496,   -80,   -80,    -8,    -8,    64,   -80,    -8, &
                -512,    64,    64,  -512,   640,    64,  4096,  -512]
  K1( 48,:) = [  -224,   496,   496,   -80,   -80,    -8,   496,   568,   -80,   640,    -8,    64,   -80,    -8,    -8,    64, &
                  64,  -512,   640,    64,    64,  -512,  -512,  4096]
  K1( 49,:) = [    -1,   -10,   -10,    62,    62,   -28,   -10,  -100,    62,  -514,    53,    44,    62,    53,   -28,    44, &
                -442,   116,  -514,    44,    44,   116,   116,  -136]
  K1( 50,:) = [   -10,    -1,    62,   -28,   -10,    62,  -100,   -10,    53,    44,    62,  -514,  -514,    44,    44,   116, &
                 116,  -136,    62,    53,   -28,    44,  -442,   116]
  K1( 51,:) = [   -10,    62,    -1,   -10,   -28,    62,    62,    53,   -28,    44,  -442,   116,   -10,  -100,    62,  -514, &
                  53,    44,    44,  -514,   116,  -136,    44,   116]
  K1( 52,:) = [    62,   -28,   -10,    -1,    62,   -10,  -514,    44,    44,   116,   116,  -136,  -100,   -10,    53,    44, &
                  62,  -514,    53,    62,  -442,   116,   -28,    44]
  K1( 53,:) = [    62,   -10,   -28,    62,    -1,   -10,    53,    62,  -442,   116,   -28,    44,    44,  -514,   116,  -136, &
                  44,   116,   -10,  -100,    62,  -514,    53,    44]
  K1( 54,:) = [   -28,    62,    62,   -10,   -10,    -1,    44,  -514,   116,  -136,    44,   116,    53,    62,  -442,   116, &
                 -28,    44,  -100,   -10,    53,    44,    62,  -514]
  K1( 55,:) = [   -10,  -100,    62,  -514,    53,    44,    -1,   -10,   -10,    62,    62,   -28,   -28,    44,    62,    53, &
                 116,  -442,    44,   116,  -514,    44,  -136,   116]
  K1( 56,:) = [  -100,   -10,    53,    44,    62,  -514,   -10,    -1,    62,   -28,   -10,    62,    44,   116,  -514,    44, &
                -136,   116,   -28,    44,    62,    53,   116,  -442]
  K1( 57,:) = [    62,    53,   -28,    44,  -442,   116,   -10,    62,    -1,   -10,   -28,    62,    62,  -514,   -10,  -100, &
                  44,    53,   116,  -136,    44,  -514,   116,    44]
  K1( 58,:) = [  -514,    44,    44,   116,   116,  -136,    62,   -28,   -10,    -1,    62,   -10,    53,    44,  -100,   -10, &
                -514,    62,  -442,   116,    53,    62,    44,   -28]
  K1( 59,:) = [    53,    62,  -442,   116,   -28,    44,    62,   -10,   -28,    62,    -1,   -10,   116,  -136,    44,  -514, &
                 116,    44,    62,  -514,   -10,  -100,    44,    53]
  K1( 60,:) = [    44,  -514,   116,  -136,    44,   116,   -28,    62,    62,   -10,   -10,    -1,  -442,   116,    53,    62, &
                  44,   -28,    53,    44,  -100,   -10,  -514,    62]
  K1( 61,:) = [    62,  -514,   -10,  -100,    44,    53,   -28,    44,    62,    53,   116,  -442,    -1,   -10,   -10,    62, &
                  62,   -28,   116,    44,  -136,   116,  -514,    44]
  K1( 62,:) = [    53,    44,  -100,   -10,  -514,    62,    44,   116,  -514,    44,  -136,   116,   -10,    -1,    62,   -28, &
                 -10,    62,    44,   -28,   116,  -442,    62,    53]
  K1( 63,:) = [   -28,    44,    62,    53,   116,  -442,    62,  -514,   -10,  -100,    44,    53,   -10,    62,    -1,   -10, &
                 -28,    62,  -136,   116,   116,    44,    44,  -514]
  K1( 64,:) = [    44,   116,  -514,    44,  -136,   116,    53,    44,  -100,   -10,  -514,    62,    62,   -28,   -10,    -1, &
                  62,   -10,   116,  -442,    44,   -28,    53,    62]
  K1( 65,:) = [  -442,   116,    53,    62,    44,   -28,   116,  -136,    44,  -514,   116,    44,    62,   -10,   -28,    62, &
                  -1,   -10,  -514,    62,    44,    53,   -10,  -100]
  K1( 66,:) = [   116,  -136,    44,  -514,   116,    44,  -442,   116,    53,    62,    44,   -28,   -28,    62,    62,   -10, &
                 -10,    -1,    44,    53,  -514,    62,  -100,   -10]
  K1( 67,:) = [  -514,    62,    44,    53,   -10,  -100,    44,   -28,   116,  -442,    62,    53,   116,    44,  -136,   116, &
                -514,    44,    -1,   -10,   -10,    62,    62,   -28]
  K1( 68,:) = [    44,    53,  -514,    62,  -100,   -10,   116,    44,  -136,   116,  -514,    44,    44,   -28,   116,  -442, &
                  62,    53,   -10,    -1,    62,   -28,   -10,    62]
  K1( 69,:) = [    44,   -28,   116,  -442,    62,    53,  -514,    62,    44,    53,   -10,  -100,  -136,   116,   116,    44, &
                  44,  -514,   -10,    62,    -1,   -10,   -28,    62]
  K1( 70,:) = [   116,    44,  -136,   116,  -514,    44,    44,    53,  -514,    62,  -100,   -10,   116,  -442,    44,   -28, &
                  53,    62,    62,   -28,   -10,    -1,    62,   -10]
  K1( 71,:) = [   116,  -442,    44,   -28,    53,    62,  -136,   116,   116,    44,    44,  -514,  -514,    62,    44,    53, &
                 -10,  -100,    62,   -10,   -28,    62,    -1,   -10]
  K1( 72,:) = [  -136,   116,   116,    44,    44,  -514,   116,  -442,    44,   -28,    53,    62,    44,    53,  -514,    62, &
                -100,   -10,   -28,    62,    62,   -10,   -10,    -1]
  K1( 73,:) = [  4096,  -512,  -512,    64,    64,   640,  -512,    64,    64,    -8,    -8,   -80,    64,    -8,   640,   -80, &
                 568,   496,    -8,   -80,   -80,   496,   496,  -224]
  K1( 74,:) = [  -512,  4096,    64,   640,  -512,    64,    64,  -512,    -8,   -80,    64,    -8,    -8,   -80,   -80,   496, &
                 496,  -224,    64,    -8,   640,   -80,   568,   496]
  K1( 75,:) = [  -512,    64,  4096,  -512,   640,    64,    64,    -8,   640,   -80,   568,   496,  -512,    64,    64,    -8, &
                  -8,   -80,   -80,    -8,   496,  -224,   -80,   496]
  K1( 76,:) = [    64,   640,  -512,  4096,    64,  -512,    -8,   -80,   -80,   496,   496,  -224,    64,  -512,    -8,   -80, &
                  64,    -8,    -8,    64,   568,   496,   640,   -80]
  K1( 77,:) = [    64,  -512,   640,    64,  4096,  -512,    -8,    64,   568,   496,   640,   -80,   -80,    -8,   496,  -224, &
                 -80,   496,  -512,    64,    64,    -8,    -8,   -80]
  K1( 78,:) = [   640,    64,    64,  -512,  -512,  4096,   -80,    -8,   496,  -224,   -80,   496,    -8,    64,   568,   496, &
                 640,   -80,    64,  -512,    -8,   -80,    64,    -8]
  K1( 79,:) = [  -512,    64,    64,    -8,    -8,   -80,  4096,  -512,  -512,    64,    64,   640,   640,   -80,    64,    -8, &
                 496,   568,   -80,   496,    -8,   -80,  -224,   496]
  K1( 80,:) = [    64,  -512,    -8,   -80,    64,    -8,  -512,  4096,    64,   640,  -512,    64,   -80,   496,    -8,   -80, &
                -224,   496,   640,   -80,    64,    -8,   496,   568]
  K1( 81,:) = [    64,    -8,   640,   -80,   568,   496,  -512,    64,  4096,  -512,   640,    64,    64,    -8,  -512,    64, &
                 -80,    -8,   496,  -224,   -80,    -8,   496,   -80]
  K1( 82,:) = [    -8,   -80,   -80,   496,   496,  -224,    64,   640,  -512,  4096,    64,  -512,    -8,   -80,    64,  -512, &
                  -8,    64,   568,   496,    -8,    64,   -80,   640]
  K1( 83,:) = [    -8,    64,   568,   496,   640,   -80,    64,  -512,   640,    64,  4096,  -512,   496,  -224,   -80,    -8, &
                 496,   -80,    64,    -8,  -512,    64,   -80,    -8]
  K1( 84,:) = [   -80,    -8,   496,  -224,   -80,   496,   640,    64,    64,  -512,  -512,  4096,   568,   496,    -8,    64, &
                 -80,   640,    -8,   -80,    64,  -512,    -8,    64]
  K1( 85,:) = [    64,    -8,  -512,    64,   -80,    -8,   640,   -80,    64,    -8,   496,   568,  4096,  -512,  -512,    64, &
                  64,   640,   496,   -80,  -224,   496,    -8,   -80]
  K1( 86,:) = [    -8,   -80,    64,  -512,    -8,    64,   -80,   496,    -8,   -80,  -224,   496,  -512,  4096,    64,   640, &
                -512,    64,   -80,   640,   496,   568,    64,    -8]
  K1( 87,:) = [   640,   -80,    64,    -8,   496,   568,    64,    -8,  -512,    64,   -80,    -8,  -512,    64,  4096,  -512, &
                 640,    64,  -224,   496,   496,   -80,   -80,    -8]
  K1( 88,:) = [   -80,   496,    -8,   -80,  -224,   496,    -8,   -80,    64,  -512,    -8,    64,    64,   640,  -512,  4096, &
                  64,  -512,   496,   568,   -80,   640,    -8,    64]
  K1( 89,:) = [   568,   496,    -8,    64,   -80,   640,   496,  -224,   -80,    -8,   496,   -80,    64,  -512,   640,    64, &
                4096,  -512,    -8,    64,   -80,    -8,  -512,    64]
  K1( 90,:) = [   496,  -224,   -80,    -8,   496,   -80,   568,   496,    -8,    64,   -80,   640,   640,    64,    64,  -512, &
                -512,  4096,   -80,    -8,    -8,    64,    64,  -512]
  K1( 91,:) = [    -8,    64,   -80,    -8,  -512,    64,   -80,   640,   496,   568,    64,    -8,   496,   -80,  -224,   496, &
                  -8,   -80,  4096,  -512,  -512,    64,    64,   640]
  K1( 92,:) = [   -80,    -8,    -8,    64,    64,  -512,   496,   -80,  -224,   496,    -8,   -80,   -80,   640,   496,   568, &
                  64,    -8,  -512,  4096,    64,   640,  -512,    64]
  K1( 93,:) = [   -80,   640,   496,   568,    64,    -8,    -8,    64,   -80,    -8,  -512,    64,  -224,   496,   496,   -80, &
                 -80,    -8,  -512,    64,  4096,  -512,   640,    64]
  K1( 94,:) = [   496,   -80,  -224,   496,    -8,   -80,   -80,    -8,    -8,    64,    64,  -512,   496,   568,   -80,   640, &
                  -8,    64,    64,   640,  -512,  4096,    64,  -512]
  K1( 95,:) = [   496,   568,   -80,   640,    -8,    64,  -224,   496,   496,   -80,   -80,    -8,    -8,    64,   -80,    -8, &
                -512,    64,    64,  -512,   640,    64,  4096,  -512]
  K1( 96,:) = [  -224,   496,   496,   -80,   -80,    -8,   496,   568,   -80,   640,    -8,    64,   -80,    -8,    -8,    64, &
                  64,  -512,   640,    64,    64,  -512,  -512,  4096]
  K1( 97,:) = [     9,    90,    90,  -558,  -558,   252,     9,    90,     9,     9,   -72,    90,   -72,     9,    90,    90, &
                 576,  -558,   576,   -72,     9,  -558,   -72,   252]
  K1( 98,:) = [    90,     9,  -558,   252,    90,  -558,    90,     9,   -72,    90,     9,     9,   576,   -72,     9,  -558, &
                 -72,   252,   -72,     9,    90,    90,   576,  -558]
  K1( 99,:) = [    90,  -558,     9,    90,   252,  -558,   -72,     9,    90,    90,   576,  -558,     9,    90,     9,     9, &
                 -72,    90,   -72,   576,   -72,   252,     9,  -558]
  K1(100,:) = [  -558,   252,    90,     9,  -558,    90,   576,   -72,     9,  -558,   -72,   252,    90,     9,   -72,    90, &
                   9,     9,     9,   -72,   576,  -558,    90,    90]
  K1(101,:) = [  -558,    90,   252,  -558,     9,    90,     9,   -72,   576,  -558,    90,    90,   -72,   576,   -72,   252, &
                   9,  -558,     9,    90,     9,     9,   -72,    90]
  K1(102,:) = [   252,  -558,  -558,    90,    90,     9,   -72,   576,   -72,   252,     9,  -558,     9,   -72,   576,  -558, &
                  90,    90,    90,     9,   -72,    90,     9,     9]
  K1(103,:) = [     9,    90,   -72,   576,     9,   -72,   -72,  -720,   -72,   -72,   576,  -720,   -72,  -153,     9,     9, &
                 576,  -639,  -153,   495,   -72,    90,   -72,  -558]
  K1(104,:) = [    90,     9,     9,   -72,   -72,   576,  -720,   -72,   576,  -720,   -72,   -72,  -153,   495,   -72,    90, &
                 -72,  -558,   -72,  -153,     9,     9,   576,  -639]
  K1(105,:) = [     9,   -72,    90,     9,   576,   -72,   -72,   576,   576,   576,   576,   -72,     9,   -72,   -72,   -72, &
                 -72,     9,   576,   -72,   -72,     9,     9,    90]
  K1(106,:) = [     9,    90,    90,  -558,  -558,   252,   -72,  -720,   576, -4608,   -72,   576,     9,    90,   -72,   576, &
                   9,   -72,  -639,  -558,     9,   -72,    90,  -720]
  K1(107,:) = [   -72,     9,   576,   -72,    90,     9,   576,   -72,   576,   -72,   576,   576,   576,   -72,   -72,     9, &
                   9,    90,     9,   -72,   -72,   -72,   -72,     9]
  K1(108,:) = [    90,     9,  -558,   252,    90,  -558,  -720,   -72,   -72,   576,   576, -4608,  -639,  -558,     9,   -72, &
                  90,  -720,     9,    90,   -72,   576,     9,   -72]
  K1(109,:) = [   -72,   576,     9,    90,   -72,     9,   -72,  -153,     9,     9,   576,  -639,   -72,  -720,   -72,   -72, &
                 576,  -720,   495,  -153,   -72,  -558,   -72,    90]
  K1(110,:) = [     9,   -72,    90,     9,   576,   -72,  -153,   495,   -72,    90,   -72,  -558,  -720,   -72,   576,  -720, &
                 -72,   -72,  -153,   -72,   576,  -639,     9,     9]
  K1(111,:) = [    90,     9,     9,   -72,   -72,   576,     9,   -72,   -72,   -72,   -72,     9,   -72,   576,   576,   576, &
                 576,   -72,   -72,   576,     9,    90,   -72,     9]
  K1(112,:) = [    90,  -558,     9,    90,   252,  -558,     9,    90,   -72,   576,     9,   -72,   -72,  -720,   576, -4608, &
                 -72,   576,  -558,  -639,    90,  -720,     9,   -72]
  K1(113,:) = [   576,   -72,   -72,     9,     9,    90,   576,   -72,   -72,     9,     9,    90,   576,   -72,   576,   -72, &
                 576,   576,   -72,     9,   -72,     9,   -72,   -72]
  K1(114,:) = [  -558,   252,    90,     9,  -558,    90,  -639,  -558,     9,   -72,    90,  -720,  -720,   -72,   -72,   576, &
                 576, -4608,    90,     9,     9,   -72,   -72,   576]
  K1(115,:) = [   576,   -72,   -72,     9,     9,    90,  -153,   -72,   576,  -639,     9,     9,   495,  -153,   -72,  -558, &
                 -72,    90,   -72,  -720,   -72,   -72,   576,  -720]
  K1(116,:) = [   -72,     9,   576,   -72,    90,     9,   495,  -153,   -72,  -558,   -72,    90,  -153,   -72,   576,  -639, &
                   9,     9,  -720,   -72,   576,  -720,   -72,   -72]
  K1(117,:) = [     9,    90,   -72,   576,     9,   -72,   -72,     9,   -72,     9,   -72,   -72,   -72,   576,     9,    90, &
                 -72,     9,   -72,   576,   576,   576,   576,   -72]
  K1(118,:) = [  -558,    90,   252,  -558,     9,    90,    90,     9,     9,   -72,   -72,   576,  -558,  -639,    90,  -720, &
                   9,   -72,   -72,  -720,   576, -4608,   -72,   576]
  K1(119,:) = [   -72,   576,     9,    90,   -72,     9,   -72,   576,     9,    90,   -72,     9,   -72,     9,   -72,     9, &
                 -72,   -72,   576,   -72,   576,   -72,   576,   576]
  K1(120,:) = [   252,  -558,  -558,    90,    90,     9,  -558,  -639,    90,  -720,     9,   -72,    90,     9,     9,   -72, &
                 -72,   576,  -720,   -72,   -72,   576,   576, -4608]
  K1(121,:) = [ -4608,   576,   576,   -72,   -72,  -720,   576,   -72,   -72,     9,     9,    90,   -72,     9,  -720,    90, &
                -639,  -558,     9,    90,    90,  -558,  -558,   252]
  K1(122,:) = [   576, -4608,   -72,  -720,   576,   -72,   -72,   576,     9,    90,   -72,     9,     9,    90,    90,  -558, &
                -558,   252,   -72,     9,  -720,    90,  -639,  -558]
  K1(123,:) = [   576,   -72, -4608,   576,  -720,   -72,   -72,     9,  -720,    90,  -639,  -558,   576,   -72,   -72,     9, &
                   9,    90,    90,     9,  -558,   252,    90,  -558]
  K1(124,:) = [   -72,  -720,   576, -4608,   -72,   576,     9,    90,    90,  -558,  -558,   252,   -72,   576,     9,    90, &
                 -72,     9,     9,   -72,  -639,  -558,  -720,    90]
  K1(125,:) = [   -72,   576,  -720,   -72, -4608,   576,     9,   -72,  -639,  -558,  -720,    90,    90,     9,  -558,   252, &
                  90,  -558,   576,   -72,   -72,     9,     9,    90]
  K1(126,:) = [  -720,   -72,   -72,   576,   576, -4608,    90,     9,  -558,   252,    90,  -558,     9,   -72,  -639,  -558, &
                -720,    90,   -72,   576,     9,    90,   -72,     9]
  K1(127,:) = [   576,   -72,   -72,     9,     9,    90,   576,   -72,   -72,     9,     9,    90,   576,   -72,   576,   -72, &
                 576,   576,   -72,     9,   -72,     9,   -72,   -72]
  K1(128,:) = [   -72,   576,     9,    90,   -72,     9,   -72,   576,     9,    90,   -72,     9,   -72,     9,   -72,     9, &
                 -72,   -72,   576,   -72,   576,   -72,   576,   576]
  K1(129,:) = [   -72,     9,  -720,    90,  -639,  -558,   -72,     9,   -72,     9,   -72,   -72,   576,   -72,  -720,    90, &
                -153,     9,   576,   -72,  -153,   576,   495,   -72]
  K1(130,:) = [     9,    90,    90,  -558,  -558,   252,     9,    90,     9,     9,   -72,    90,   -72,     9,    90,    90, &
                 576,  -558,   576,   -72,     9,  -558,   -72,   252]
  K1(131,:) = [     9,   -72,  -639,  -558,  -720,    90,     9,   -72,   -72,   -72,   -72,     9,   576,   -72,  -153,   576, &
                 495,   -72,   576,   -72,  -720,    90,  -153,     9]
  K1(132,:) = [    90,     9,  -558,   252,    90,  -558,    90,     9,   -72,    90,     9,     9,   576,   -72,     9,  -558, &
                 -72,   252,   -72,     9,    90,    90,   576,  -558]
  K1(133,:) = [   -72,     9,   576,   -72,    90,     9,   576,   -72,   576,   -72,   576,   576,   576,   -72,   -72,     9, &
                   9,    90,     9,   -72,   -72,   -72,   -72,     9]
  K1(134,:) = [     9,    90,   -72,   576,     9,   -72,   -72,     9,   -72,     9,   -72,   -72,   -72,   576,     9,    90, &
                 -72,     9,   -72,   576,   576,   576,   576,   -72]
  K1(135,:) = [  -720,    90,   -72,     9,  -558,  -639,   576,   -72,  -720,    90,  -153,     9,   -72,     9,   -72,     9, &
                 -72,   -72,   -72,   576,   495,   -72,  -153,   576]
  K1(136,:) = [    90,  -558,     9,    90,   252,  -558,   -72,     9,    90,    90,   576,  -558,     9,    90,     9,     9, &
                 -72,    90,   -72,   576,   -72,   252,     9,  -558]
  K1(137,:) = [  -639,  -558,     9,   -72,    90,  -720,   576,   -72,  -153,   576,   495,   -72,     9,   -72,   -72,   -72, &
                 -72,     9,   -72,   576,  -153,     9,  -720,    90]
  K1(138,:) = [  -558,   252,    90,     9,  -558,    90,   576,   -72,     9,  -558,   -72,   252,    90,     9,   -72,    90, &
                   9,     9,     9,   -72,   576,  -558,    90,    90]
  K1(139,:) = [     9,   -72,    90,     9,   576,   -72,   -72,   576,   576,   576,   576,   -72,     9,   -72,   -72,   -72, &
                 -72,     9,   576,   -72,   -72,     9,     9,    90]
  K1(140,:) = [    90,     9,     9,   -72,   -72,   576,     9,   -72,   -72,   -72,   -72,     9,   -72,   576,   576,   576, &
                 576,   -72,   -72,   576,     9,    90,   -72,     9]
  K1(141,:) = [    90,  -720,  -558,  -639,   -72,     9,   -72,   576,  -153,     9,  -720,    90,   -72,   576,   495,   -72, &
                -153,   576,   -72,     9,   -72,     9,   -72,   -72]
  K1(142,:) = [  -558,    90,   252,  -558,     9,    90,     9,   -72,   576,  -558,    90,    90,   -72,   576,   -72,   252, &
                   9,  -558,     9,    90,     9,     9,   -72,    90]
  K1(143,:) = [  -558,  -639,    90,  -720,     9,   -72,   -72,   576,   495,   -72,  -153,   576,   -72,   576,  -153,     9, &
                -720,    90,     9,   -72,   -72,   -72,   -72,     9]
  K1(144,:) = [   252,  -558,  -558,    90,    90,     9,   -72,   576,   -72,   252,     9,  -558,     9,   -72,   576,  -558, &
                  90,    90,    90,     9,   -72,    90,     9,     9]
  K1(145,:) = [  9216, -1152, -1152,   144,   144,  1440, -1152,   144,   144,   -18,   -18,  -180,   144,   -18,  1440,  -180, &
                1278,  1116,   -18,  -180,  -180,  1116,  1116,  -504]
  K1(146,:) = [ -1152,  9216,   144,  1440, -1152,   144,   144, -1152,   -18,  -180,   144,   -18,   -18,  -180,  -180,  1116, &
                1116,  -504,   144,   -18,  1440,  -180,  1278,  1116]
  K1(147,:) = [ -1152,   144,  9216, -1152,  1440,   144,   144,   -18,  1440,  -180,  1278,  1116, -1152,   144,   144,   -18, &
                 -18,  -180,  -180,   -18,  1116,  -504,  -180,  1116]
  K1(148,:) = [   144,  1440, -1152,  9216,   144, -1152,   -18,  -180,  -180,  1116,  1116,  -504,   144, -1152,   -18,  -180, &
                 144,   -18,   -18,   144,  1278,  1116,  1440,  -180]
  K1(149,:) = [   144, -1152,  1440,   144,  9216, -1152,   -18,   144,  1278,  1116,  1440,  -180,  -180,   -18,  1116,  -504, &
                -180,  1116, -1152,   144,   144,   -18,   -18,  -180]
  K1(150,:) = [  1440,   144,   144, -1152, -1152,  9216,  -180,   -18,  1116,  -504,  -180,  1116,   -18,   144,  1278,  1116, &
                1440,  -180,   144, -1152,   -18,  -180,   144,   -18]
  K1(151,:) = [ -1152,   144,   144,   -18,   -18,  -180,  9216, -1152, -1152,   144,   144,  1440,  1440,  -180,   144,   -18, &
                1116,  1278,  -180,  1116,   -18,  -180,  -504,  1116]
  K1(152,:) = [   144, -1152,   -18,  -180,   144,   -18, -1152,  9216,   144,  1440, -1152,   144,  -180,  1116,   -18,  -180, &
                -504,  1116,  1440,  -180,   144,   -18,  1116,  1278]
  K1(153,:) = [   144,   -18,  1440,  -180,  1278,  1116, -1152,   144,  9216, -1152,  1440,   144,   144,   -18, -1152,   144, &
                -180,   -18,  1116,  -504,  -180,   -18,  1116,  -180]
  K1(154,:) = [   -18,  -180,  -180,  1116,  1116,  -504,   144,  1440, -1152,  9216,   144, -1152,   -18,  -180,   144, -1152, &
                 -18,   144,  1278,  1116,   -18,   144,  -180,  1440]
  K1(155,:) = [   -18,   144,  1278,  1116,  1440,  -180,   144, -1152,  1440,   144,  9216, -1152,  1116,  -504,  -180,   -18, &
                1116,  -180,   144,   -18, -1152,   144,  -180,   -18]
  K1(156,:) = [  -180,   -18,  1116,  -504,  -180,  1116,  1440,   144,   144, -1152, -1152,  9216,  1278,  1116,   -18,   144, &
                -180,  1440,   -18,  -180,   144, -1152,   -18,   144]
  K1(157,:) = [   144,   -18, -1152,   144,  -180,   -18,  1440,  -180,   144,   -18,  1116,  1278,  9216, -1152, -1152,   144, &
                 144,  1440,  1116,  -180,  -504,  1116,   -18,  -180]
  K1(158,:) = [   -18,  -180,   144, -1152,   -18,   144,  -180,  1116,   -18,  -180,  -504,  1116, -1152,  9216,   144,  1440, &
               -1152,   144,  -180,  1440,  1116,  1278,   144,   -18]
  K1(159,:) = [  1440,  -180,   144,   -18,  1116,  1278,   144,   -18, -1152,   144,  -180,   -18, -1152,   144,  9216, -1152, &
                1440,   144,  -504,  1116,  1116,  -180,  -180,   -18]
  K1(160,:) = [  -180,  1116,   -18,  -180,  -504,  1116,   -18,  -180,   144, -1152,   -18,   144,   144,  1440, -1152,  9216, &
                 144, -1152,  1116,  1278,  -180,  1440,   -18,   144]
  K1(161,:) = [  1278,  1116,   -18,   144,  -180,  1440,  1116,  -504,  -180,   -18,  1116,  -180,   144, -1152,  1440,   144, &
                9216, -1152,   -18,   144,  -180,   -18, -1152,   144]
  K1(162,:) = [  1116,  -504,  -180,   -18,  1116,  -180,  1278,  1116,   -18,   144,  -180,  1440,  1440,   144,   144, -1152, &
               -1152,  9216,  -180,   -18,   -18,   144,   144, -1152]
  K1(163,:) = [   -18,   144,  -180,   -18, -1152,   144,  -180,  1440,  1116,  1278,   144,   -18,  1116,  -180,  -504,  1116, &
                 -18,  -180,  9216, -1152, -1152,   144,   144,  1440]
  K1(164,:) = [  -180,   -18,   -18,   144,   144, -1152,  1116,  -180,  -504,  1116,   -18,  -180,  -180,  1440,  1116,  1278, &
                 144,   -18, -1152,  9216,   144,  1440, -1152,   144]
  K1(165,:) = [  -180,  1440,  1116,  1278,   144,   -18,   -18,   144,  -180,   -18, -1152,   144,  -504,  1116,  1116,  -180, &
                -180,   -18, -1152,   144,  9216, -1152,  1440,   144]
  K1(166,:) = [  1116,  -180,  -504,  1116,   -18,  -180,  -180,   -18,   -18,   144,   144, -1152,  1116,  1278,  -180,  1440, &
                 -18,   144,   144,  1440, -1152,  9216,   144, -1152]
  K1(167,:) = [  1116,  1278,  -180,  1440,   -18,   144,  -504,  1116,  1116,  -180,  -180,   -18,   -18,   144,  -180,   -18, &
               -1152,   144,   144, -1152,  1440,   144,  9216, -1152]
  K1(168,:) = [  -504,  1116,  1116,  -180,  -180,   -18,  1116,  1278,  -180,  1440,   -18,   144,  -180,   -18,   -18,   144, &
                 144, -1152,  1440,   144,   144, -1152, -1152,  9216]
  K1(169,:) = [   -72,  -720,   -72,   -72,   576,  -720,     9,    90,   -72,   576,     9,   -72,     9,     9,   -72,  -153, &
                -639,   576,   -72,    90,  -153,   495,  -558,   -72]
  K1(170,:) = [  -720,   -72,   576,  -720,   -72,   -72,    90,     9,     9,   -72,   -72,   576,   -72,    90,  -153,   495, &
                -558,   -72,     9,     9,   -72,  -153,  -639,   576]
  K1(171,:) = [   -72,   576,   576,   576,   576,   -72,     9,   -72,    90,     9,   576,   -72,   -72,   -72,     9,   -72, &
                   9,   -72,   -72,     9,   576,   -72,    90,     9]
  K1(172,:) = [   -72,  -720,   576, -4608,   -72,   576,     9,    90,    90,  -558,  -558,   252,   -72,   576,     9,    90, &
                 -72,     9,     9,   -72,  -639,  -558,  -720,    90]
  K1(173,:) = [   576,   -72,   576,   -72,   576,   576,   -72,     9,   576,   -72,    90,     9,   -72,     9,   576,   -72, &
                  90,     9,   -72,   -72,     9,   -72,     9,   -72]
  K1(174,:) = [  -720,   -72,   -72,   576,   576, -4608,    90,     9,  -558,   252,    90,  -558,     9,   -72,  -639,  -558, &
                -720,    90,   -72,   576,     9,    90,   -72,     9]
  K1(175,:) = [     9,    90,     9,     9,   -72,    90,     9,    90,    90,  -558,  -558,   252,    90,    90,   -72,     9, &
                -558,   576,     9,  -558,   576,   -72,   252,   -72]
  K1(176,:) = [    90,     9,   -72,    90,     9,     9,    90,     9,  -558,   252,    90,  -558,     9,  -558,   576,   -72, &
                 252,   -72,    90,    90,   -72,     9,  -558,   576]
  K1(177,:) = [   -72,     9,    90,    90,   576,  -558,    90,  -558,     9,    90,   252,  -558,     9,     9,     9,    90, &
                  90,   -72,   -72,   252,   -72,   576,  -558,     9]
  K1(178,:) = [   576,   -72,     9,  -558,   -72,   252,  -558,   252,    90,     9,  -558,    90,   -72,    90,    90,     9, &
                   9,     9,   576,  -558,     9,   -72,    90,    90]
  K1(179,:) = [     9,   -72,   576,  -558,    90,    90,  -558,    90,   252,  -558,     9,    90,   -72,   252,   -72,   576, &
                -558,     9,     9,     9,     9,    90,    90,   -72]
  K1(180,:) = [   -72,   576,   -72,   252,     9,  -558,   252,  -558,  -558,    90,    90,     9,   576,  -558,     9,   -72, &
                  90,    90,   -72,    90,    90,     9,     9,     9]
  K1(181,:) = [     9,   -72,   -72,   -72,   -72,     9,    90,     9,     9,   -72,   -72,   576,   576,   576,   -72,   576, &
                 -72,   576,     9,    90,   -72,   576,     9,   -72]
  K1(182,:) = [     9,    90,   -72,   576,     9,   -72,    90,  -558,     9,    90,   252,  -558,   576, -4608,   -72,  -720, &
                 576,   -72,    90,  -720,  -558,  -639,   -72,     9]
  K1(183,:) = [   -72,  -153,     9,     9,   576,  -639,   -72,   576,     9,    90,   -72,     9,   -72,   -72,   -72,  -720, &
                -720,   576,   -72,  -558,   495,  -153,    90,   -72]
  K1(184,:) = [  -153,   495,   -72,    90,   -72,  -558,     9,   -72,    90,     9,   576,   -72,   576,  -720,  -720,   -72, &
                 -72,   -72,   576,  -639,  -153,   -72,     9,     9]
  K1(185,:) = [  -639,  -558,     9,   -72,    90,  -720,  -558,   252,    90,     9,  -558,    90,   -72,   576,  -720,   -72, &
               -4608,   576,     9,   -72,    90,     9,   576,   -72]
  K1(186,:) = [   576,   -72,   -72,     9,     9,    90,   576,   -72,   -72,     9,     9,    90,   576,   -72,   576,   -72, &
                 576,   576,   -72,     9,   -72,     9,   -72,   -72]
  K1(187,:) = [   -72,     9,   -72,     9,   -72,   -72,     9,    90,   -72,   576,     9,   -72,     9,    90,   -72,   576, &
                   9,   -72,   576,   576,   -72,   576,   -72,   576]
  K1(188,:) = [    90,     9,     9,   -72,   -72,   576,  -558,    90,   252,  -558,     9,    90,    90,  -720,  -558,  -639, &
                 -72,     9,   576, -4608,   -72,  -720,   576,   -72]
  K1(189,:) = [  -153,   -72,   576,  -639,     9,     9,   576,   -72,   -72,     9,     9,    90,   -72,  -558,   495,  -153, &
                  90,   -72,   -72,   -72,   -72,  -720,  -720,   576]
  K1(190,:) = [   495,  -153,   -72,  -558,   -72,    90,   -72,     9,   576,   -72,    90,     9,   576,  -639,  -153,   -72, &
                   9,     9,   576,  -720,  -720,   -72,   -72,   -72]
  K1(191,:) = [  -558,  -639,    90,  -720,     9,   -72,   252,  -558,  -558,    90,    90,     9,     9,   -72,    90,     9, &
                 576,   -72,   -72,   576,  -720,   -72, -4608,   576]
  K1(192,:) = [   -72,   576,     9,    90,   -72,     9,   -72,   576,     9,    90,   -72,     9,   -72,     9,   -72,     9, &
                 -72,   -72,   576,   -72,   576,   -72,   576,   576]
  K1(193,:) = [   576,   -72,   -72,     9,     9,    90,   576,   -72,   -72,     9,     9,    90,   576,   -72,   576,   -72, &
                 576,   576,   -72,     9,   -72,     9,   -72,   -72]
  K1(194,:) = [   -72,   576,     9,    90,   -72,     9,   -72,   576,     9,    90,   -72,     9,   -72,     9,   -72,     9, &
                 -72,   -72,   576,   -72,   576,   -72,   576,   576]
  K1(195,:) = [   -72,     9,   -72,     9,   -72,   -72,   -72,     9,  -720,    90,  -639,  -558,  -720,    90,   576,   -72, &
                   9,  -153,  -153,   576,   576,   -72,   -72,   495]
  K1(196,:) = [     9,    90,     9,     9,   -72,    90,     9,    90,    90,  -558,  -558,   252,    90,    90,   -72,     9, &
                -558,   576,     9,  -558,   576,   -72,   252,   -72]
  K1(197,:) = [     9,   -72,   -72,   -72,   -72,     9,     9,   -72,  -639,  -558,  -720,    90,  -153,   576,   576,   -72, &
                 -72,   495,  -720,    90,   576,   -72,     9,  -153]
  K1(198,:) = [    90,     9,   -72,    90,     9,     9,    90,     9,  -558,   252,    90,  -558,     9,  -558,   576,   -72, &
                 252,   -72,    90,    90,   -72,     9,  -558,   576]
  K1(199,:) = [   576,   -72,   -72,     9,     9,    90, -4608,   576,   576,   -72,   -72,  -720,  -720,    90,   -72,     9, &
                -558,  -639,    90,  -558,     9,    90,   252,  -558]
  K1(200,:) = [   -72,   576,     9,    90,   -72,     9,   576, -4608,   -72,  -720,   576,   -72,    90,  -558,     9,    90, &
                 252,  -558,  -720,    90,   -72,     9,  -558,  -639]
  K1(201,:) = [   -72,     9,  -720,    90,  -639,  -558,   576,   -72, -4608,   576,  -720,   -72,   -72,     9,   576,   -72, &
                  90,     9,  -558,   252,    90,     9,  -558,    90]
  K1(202,:) = [     9,    90,    90,  -558,  -558,   252,   -72,  -720,   576, -4608,   -72,   576,     9,    90,   -72,   576, &
                   9,   -72,  -639,  -558,     9,   -72,    90,  -720]
  K1(203,:) = [     9,   -72,  -639,  -558,  -720,    90,   -72,   576,  -720,   -72, -4608,   576,  -558,   252,    90,     9, &
                -558,    90,   -72,     9,   576,   -72,    90,     9]
  K1(204,:) = [    90,     9,  -558,   252,    90,  -558,  -720,   -72,   -72,   576,   576, -4608,  -639,  -558,     9,   -72, &
                  90,  -720,     9,    90,   -72,   576,     9,   -72]
  K1(205,:) = [   576,   -72,  -720,    90,  -153,     9,  -720,    90,   -72,     9,  -558,  -639,   -72,     9,   -72,     9, &
                 -72,   -72,   495,   -72,   -72,   576,   576,  -153]
  K1(206,:) = [   -72,     9,    90,    90,   576,  -558,    90,  -558,     9,    90,   252,  -558,     9,     9,     9,    90, &
                  90,   -72,   -72,   252,   -72,   576,  -558,     9]
  K1(207,:) = [   576,   -72,   576,   -72,   576,   576,   -72,     9,   576,   -72,    90,     9,   -72,     9,   576,   -72, &
                  90,     9,   -72,   -72,     9,   -72,     9,   -72]
  K1(208,:) = [   -72,     9,   -72,     9,   -72,   -72,     9,    90,   -72,   576,     9,   -72,     9,    90,   -72,   576, &
                   9,   -72,   576,   576,   -72,   576,   -72,   576]
  K1(209,:) = [   576,   -72,     9,  -558,   -72,   252,  -558,   252,    90,     9,  -558,    90,   -72,    90,    90,     9, &
                   9,     9,   576,  -558,     9,   -72,    90,    90]
  K1(210,:) = [   576,   -72,  -153,   576,   495,   -72,  -639,  -558,     9,   -72,    90,  -720,   -72,   -72,     9,   -72, &
                   9,   -72,  -153,     9,   -72,   576,    90,  -720]
  K1(211,:) = [   -72,   576,  -153,     9,  -720,    90,    90,  -720,  -558,  -639,   -72,     9,   495,   -72,   -72,   576, &
                 576,  -153,   -72,     9,   -72,     9,   -72,   -72]
  K1(212,:) = [     9,   -72,   576,  -558,    90,    90,  -558,    90,   252,  -558,     9,    90,   -72,   252,   -72,   576, &
                -558,     9,     9,     9,     9,    90,    90,   -72]
  K1(213,:) = [   -72,   576,   576,   576,   576,   -72,     9,   -72,    90,     9,   576,   -72,   -72,   -72,     9,   -72, &
                   9,   -72,   -72,     9,   576,   -72,    90,     9]
  K1(214,:) = [     9,   -72,   -72,   -72,   -72,     9,    90,     9,     9,   -72,   -72,   576,   576,   576,   -72,   576, &
                 -72,   576,     9,    90,   -72,   576,     9,   -72]
  K1(215,:) = [   -72,   576,   -72,   252,     9,  -558,   252,  -558,  -558,    90,    90,     9,   576,  -558,     9,   -72, &
                  90,    90,   -72,    90,    90,     9,     9,     9]
  K1(216,:) = [   -72,   576,   495,   -72,  -153,   576,  -558,  -639,    90,  -720,     9,   -72,  -153,     9,   -72,   576, &
                  90,  -720,   -72,   -72,     9,   -72,     9,   -72]
  K1(217,:) = [ -5184,   648,   648,   -81,   -81,  -810,     0,     0,     0,     0,     0,     0,  -648,    81, -1296,   162, &
               -1215, -1134,    81,    81,   162,  -567,  -486,   324]
  K1(218,:) = [   648, -5184,   -81,  -810,   648,   -81,     0,     0,     0,     0,     0,     0,    81,    81,   162,  -567, &
                -486,   324,  -648,    81, -1296,   162, -1215, -1134]
  K1(219,:) = [   648,   -81,   648,   -81,   648,   648,     0,     0,  1296,  -162,   729,   567,   648,   -81,     0,     0, &
                  81,   162,    81,  -648,  -567,     0,    81,  -567]
  K1(220,:) = [   -81,  -810,   -81,   -81,   648,  -810,     0,     0,  -162,  1134,   567,  -324,   -81,   -81,     0,  -162, &
                 -81,     0,   -81,   648,  -729,   567,  -810,     0]
  K1(221,:) = [   -81,   648,   648,   648,   648,   -81,     0,     0,   729,   567,  1296,  -162,    81,  -648,  -567,     0, &
                  81,  -567,   648,   -81,     0,     0,    81,   162]
  K1(222,:) = [  -810,   -81,   648,  -810,   -81,   -81,     0,     0,   567,  -324,  -162,  1134,   -81,   648,  -729,   567, &
                -810,     0,   -81,   -81,     0,  -162,   -81,     0]
  K1(223,:) = [     0,     0,     0,     0,     0,     0, -5184,   648,   648,   -81,   -81,  -810, -1296,   162,  -648,    81, &
               -1134, -1215,   162,  -567,    81,    81,   324,  -486]
  K1(224,:) = [     0,     0,     0,     0,     0,     0,   648, -5184,   -81,  -810,   648,   -81,   162,  -567,    81,    81, &
                 324,  -486, -1296,   162,  -648,    81, -1134, -1215]
  K1(225,:) = [     0,     0,  1296,  -162,   729,   567,   648,   -81,   648,   -81,   648,   648,     0,     0,   648,   -81, &
                 162,    81,  -567,     0,    81,  -648,  -567,    81]
  K1(226,:) = [     0,     0,  -162,  1134,   567,  -324,   -81,  -810,   -81,   -81,   648,  -810,     0,  -162,   -81,   -81, &
                   0,   -81,  -729,   567,   -81,   648,     0,  -810]
  K1(227,:) = [     0,     0,   729,   567,  1296,  -162,   -81,   648,   648,   648,   648,   -81,  -567,     0,    81,  -648, &
                -567,    81,     0,     0,   648,   -81,   162,    81]
  K1(228,:) = [     0,     0,   567,  -324,  -162,  1134,  -810,   -81,   648,  -810,   -81,   -81,  -729,   567,   -81,   648, &
                   0,  -810,     0,  -162,   -81,   -81,     0,   -81]
  K1(229,:) = [  -648,    81,   648,   -81,    81,   -81, -1296,   162,     0,     0,  -567,  -729, -5184,   648,     0,     0, &
                -648, -1296,  -486,    81,   324,  -567,    81,   162]
  K1(230,:) = [    81,    81,   -81,   -81,  -648,   648,   162,  -567,     0,  -162,     0,   567,   648,   648,     0,  1296, &
                 648,     0,    81,   648,  -567,   729,   -81,     0]
  K1(231,:) = [ -1296,   162,     0,     0,  -567,  -729,  -648,    81,   648,   -81,    81,   -81,     0,     0, -5184,   648, &
               -1296,  -648,   324,  -567,  -486,    81,   162,    81]
  K1(232,:) = [   162,  -567,     0,  -162,     0,   567,    81,    81,   -81,   -81,  -648,   648,     0,  1296,   648,   648, &
                   0,   648,  -567,   729,    81,   648,     0,   -81]
  K1(233,:) = [ -1215,  -486,    81,   -81,    81,  -810, -1134,   324,   162,     0,  -567,     0,  -648,   648, -1296,     0, &
               -5184,     0,    81,   -81,   162,     0,   648,     0]
  K1(234,:) = [ -1134,   324,   162,     0,  -567,     0, -1215,  -486,    81,   -81,    81,  -810, -1296,     0,  -648,   648, &
                   0, -5184,   162,     0,    81,   -81,     0,   648]
  K1(235,:) = [    81,  -648,    81,   -81,   648,   -81,   162, -1296,  -567,  -729,     0,     0,  -486,    81,   324,  -567, &
                  81,   162, -5184,   648,     0,     0,  -648, -1296]
  K1(236,:) = [    81,    81,  -648,   648,   -81,   -81,  -567,   162,     0,   567,     0,  -162,    81,   648,  -567,   729, &
                 -81,     0,   648,   648,     0,  1296,   648,     0]
  K1(237,:) = [   162, -1296,  -567,  -729,     0,     0,    81,  -648,    81,   -81,   648,   -81,   324,  -567,  -486,    81, &
                 162,    81,     0,     0, -5184,   648, -1296,  -648]
  K1(238,:) = [  -567,   162,     0,   567,     0,  -162,    81,    81,  -648,   648,   -81,   -81,  -567,   729,    81,   648, &
                   0,   -81,     0,  1296,   648,   648,     0,   648]
  K1(239,:) = [  -486, -1215,    81,  -810,    81,   -81,   324, -1134,  -567,     0,   162,     0,    81,   -81,   162,     0, &
                 648,     0,  -648,   648, -1296,     0, -5184,     0]
  K1(240,:) = [   324, -1134,  -567,     0,   162,     0,  -486, -1215,    81,  -810,    81,   -81,   162,     0,    81,   -81, &
                   0,   648, -1296,     0,  -648,   648,     0, -5184]
  K1(241,:) = [  9216, -1152, -1152,   144,   144,  1440, -1152,   144,   144,   -18,   -18,  -180,   144,   -18,  1440,  -180, &
                1278,  1116,   -18,  -180,  -180,  1116,  1116,  -504]
  K1(242,:) = [ -1152,  9216,   144,  1440, -1152,   144,   144, -1152,   -18,  -180,   144,   -18,   -18,  -180,  -180,  1116, &
                1116,  -504,   144,   -18,  1440,  -180,  1278,  1116]
  K1(243,:) = [ -1152,   144,  9216, -1152,  1440,   144,   144,   -18,  1440,  -180,  1278,  1116, -1152,   144,   144,   -18, &
                 -18,  -180,  -180,   -18,  1116,  -504,  -180,  1116]
  K1(244,:) = [   144,  1440, -1152,  9216,   144, -1152,   -18,  -180,  -180,  1116,  1116,  -504,   144, -1152,   -18,  -180, &
                 144,   -18,   -18,   144,  1278,  1116,  1440,  -180]
  K1(245,:) = [   144, -1152,  1440,   144,  9216, -1152,   -18,   144,  1278,  1116,  1440,  -180,  -180,   -18,  1116,  -504, &
                -180,  1116, -1152,   144,   144,   -18,   -18,  -180]
  K1(246,:) = [  1440,   144,   144, -1152, -1152,  9216,  -180,   -18,  1116,  -504,  -180,  1116,   -18,   144,  1278,  1116, &
                1440,  -180,   144, -1152,   -18,  -180,   144,   -18]
  K1(247,:) = [ -1152,   144,   144,   -18,   -18,  -180,  9216, -1152, -1152,   144,   144,  1440,  1440,  -180,   144,   -18, &
                1116,  1278,  -180,  1116,   -18,  -180,  -504,  1116]
  K1(248,:) = [   144, -1152,   -18,  -180,   144,   -18, -1152,  9216,   144,  1440, -1152,   144,  -180,  1116,   -18,  -180, &
                -504,  1116,  1440,  -180,   144,   -18,  1116,  1278]
  K1(249,:) = [   144,   -18,  1440,  -180,  1278,  1116, -1152,   144,  9216, -1152,  1440,   144,   144,   -18, -1152,   144, &
                -180,   -18,  1116,  -504,  -180,   -18,  1116,  -180]
  K1(250,:) = [   -18,  -180,  -180,  1116,  1116,  -504,   144,  1440, -1152,  9216,   144, -1152,   -18,  -180,   144, -1152, &
                 -18,   144,  1278,  1116,   -18,   144,  -180,  1440]
  K1(251,:) = [   -18,   144,  1278,  1116,  1440,  -180,   144, -1152,  1440,   144,  9216, -1152,  1116,  -504,  -180,   -18, &
                1116,  -180,   144,   -18, -1152,   144,  -180,   -18]
  K1(252,:) = [  -180,   -18,  1116,  -504,  -180,  1116,  1440,   144,   144, -1152, -1152,  9216,  1278,  1116,   -18,   144, &
                -180,  1440,   -18,  -180,   144, -1152,   -18,   144]
  K1(253,:) = [   144,   -18, -1152,   144,  -180,   -18,  1440,  -180,   144,   -18,  1116,  1278,  9216, -1152, -1152,   144, &
                 144,  1440,  1116,  -180,  -504,  1116,   -18,  -180]
  K1(254,:) = [   -18,  -180,   144, -1152,   -18,   144,  -180,  1116,   -18,  -180,  -504,  1116, -1152,  9216,   144,  1440, &
               -1152,   144,  -180,  1440,  1116,  1278,   144,   -18]
  K1(255,:) = [  1440,  -180,   144,   -18,  1116,  1278,   144,   -18, -1152,   144,  -180,   -18, -1152,   144,  9216, -1152, &
                1440,   144,  -504,  1116,  1116,  -180,  -180,   -18]
  K1(256,:) = [  -180,  1116,   -18,  -180,  -504,  1116,   -18,  -180,   144, -1152,   -18,   144,   144,  1440, -1152,  9216, &
                 144, -1152,  1116,  1278,  -180,  1440,   -18,   144]
  K1(257,:) = [  1278,  1116,   -18,   144,  -180,  1440,  1116,  -504,  -180,   -18,  1116,  -180,   144, -1152,  1440,   144, &
                9216, -1152,   -18,   144,  -180,   -18, -1152,   144]
  K1(258,:) = [  1116,  -504,  -180,   -18,  1116,  -180,  1278,  1116,   -18,   144,  -180,  1440,  1440,   144,   144, -1152, &
               -1152,  9216,  -180,   -18,   -18,   144,   144, -1152]
  K1(259,:) = [   -18,   144,  -180,   -18, -1152,   144,  -180,  1440,  1116,  1278,   144,   -18,  1116,  -180,  -504,  1116, &
                 -18,  -180,  9216, -1152, -1152,   144,   144,  1440]
  K1(260,:) = [  -180,   -18,   -18,   144,   144, -1152,  1116,  -180,  -504,  1116,   -18,  -180,  -180,  1440,  1116,  1278, &
                 144,   -18, -1152,  9216,   144,  1440, -1152,   144]
  K1(261,:) = [  -180,  1440,  1116,  1278,   144,   -18,   -18,   144,  -180,   -18, -1152,   144,  -504,  1116,  1116,  -180, &
                -180,   -18, -1152,   144,  9216, -1152,  1440,   144]
  K1(262,:) = [  1116,  -180,  -504,  1116,   -18,  -180,  -180,   -18,   -18,   144,   144, -1152,  1116,  1278,  -180,  1440, &
                 -18,   144,   144,  1440, -1152,  9216,   144, -1152]
  K1(263,:) = [  1116,  1278,  -180,  1440,   -18,   144,  -504,  1116,  1116,  -180,  -180,   -18,   -18,   144,  -180,   -18, &
               -1152,   144,   144, -1152,  1440,   144,  9216, -1152]
  K1(264,:) = [  -504,  1116,  1116,  -180,  -180,   -18,  1116,  1278,  -180,  1440,   -18,   144,  -180,   -18,   -18,   144, &
                 144, -1152,  1440,   144,   144, -1152, -1152,  9216]
  K1(265,:) = [   576,   576,   -72,   576,   -72,   576,   -72,   -72,     9,   -72,     9,   -72,     9,   -72,    90,     9, &
                 576,   -72,     9,   -72,    90,     9,   576,   -72]
  K1(266,:) = [   576, -4608,   -72,  -720,   576,   -72,   -72,   576,     9,    90,   -72,     9,     9,    90,    90,  -558, &
                -558,   252,   -72,     9,  -720,    90,  -639,  -558]
  K1(267,:) = [   -72,   -72,   -72,  -720,  -720,   576,     9,     9,   -72,  -153,  -639,   576,     9,    90,   -72,   576, &
                   9,   -72,    90,   -72,  -558,   -72,  -153,   495]
  K1(268,:) = [   576,  -720,  -720,   -72,   -72,   -72,   -72,    90,  -153,   495,  -558,   -72,    90,     9,     9,   -72, &
                 -72,   576,     9,     9,  -639,   576,   -72,  -153]
  K1(269,:) = [   -72,   576,  -720,   -72, -4608,   576,     9,   -72,  -639,  -558,  -720,    90,    90,     9,  -558,   252, &
                  90,  -558,   576,   -72,   -72,     9,     9,    90]
  K1(270,:) = [   576,   -72,   576,   -72,   576,   576,   -72,     9,   576,   -72,    90,     9,   -72,     9,   576,   -72, &
                  90,     9,   -72,   -72,     9,   -72,     9,   -72]
  K1(271,:) = [   -72,   -72,     9,   -72,     9,   -72,   576,   576,   -72,   576,   -72,   576,    90,     9,     9,   -72, &
                 -72,   576,    90,     9,     9,   -72,   -72,   576]
  K1(272,:) = [   -72,   576,     9,    90,   -72,     9,   576, -4608,   -72,  -720,   576,   -72,    90,  -558,     9,    90, &
                 252,  -558,  -720,    90,   -72,     9,  -558,  -639]
  K1(273,:) = [     9,     9,   -72,  -153,  -639,   576,   -72,   -72,   -72,  -720,  -720,   576,   -72,   576,     9,    90, &
                 -72,     9,  -558,   -72,    90,   -72,   495,  -153]
  K1(274,:) = [   -72,    90,  -153,   495,  -558,   -72,   576,  -720,  -720,   -72,   -72,   -72,     9,   -72,    90,     9, &
                 576,   -72,  -639,   576,     9,     9,  -153,   -72]
  K1(275,:) = [     9,   -72,  -639,  -558,  -720,    90,   -72,   576,  -720,   -72, -4608,   576,  -558,   252,    90,     9, &
                -558,    90,   -72,     9,   576,   -72,    90,     9]
  K1(276,:) = [   -72,     9,   576,   -72,    90,     9,   576,   -72,   576,   -72,   576,   576,   576,   -72,   -72,     9, &
                   9,    90,     9,   -72,   -72,   -72,   -72,     9]
  K1(277,:) = [     9,     9,     9,    90,    90,   -72,    90,    90,   -72,     9,  -558,   576,     9,    90,    90,  -558, &
                -558,   252,  -558,     9,   252,   -72,   576,   -72]
  K1(278,:) = [   -72,    90,    90,     9,     9,     9,     9,  -558,   576,   -72,   252,   -72,    90,     9,  -558,   252, &
                  90,  -558,    90,    90,  -558,   576,   -72,     9]
  K1(279,:) = [    90,    90,   -72,     9,  -558,   576,     9,     9,     9,    90,    90,   -72,    90,  -558,     9,    90, &
                 252,  -558,   252,   -72,  -558,     9,   -72,   576]
  K1(280,:) = [     9,  -558,   576,   -72,   252,   -72,   -72,    90,    90,     9,     9,     9,  -558,   252,    90,     9, &
                -558,    90,  -558,   576,    90,    90,     9,   -72]
  K1(281,:) = [   576,  -558,     9,   -72,    90,    90,   -72,   252,   -72,   576,  -558,     9,  -558,    90,   252,  -558, &
                   9,    90,     9,     9,    90,   -72,     9,    90]
  K1(282,:) = [   -72,   252,   -72,   576,  -558,     9,   576,  -558,     9,   -72,    90,    90,   252,  -558,  -558,    90, &
                  90,     9,    90,   -72,     9,     9,    90,     9]
  K1(283,:) = [     9,   -72,    90,     9,   576,   -72,    90,  -720,  -558,  -639,   -72,     9,  -558,    90,   252,  -558, &
                   9,    90, -4608,   576,   576,   -72,   -72,  -720]
  K1(284,:) = [   -72,     9,   -72,     9,   -72,   -72,     9,    90,   -72,   576,     9,   -72,     9,    90,   -72,   576, &
                   9,   -72,   576,   576,   -72,   576,   -72,   576]
  K1(285,:) = [    90,  -720,  -558,  -639,   -72,     9,     9,   -72,    90,     9,   576,   -72,   252,  -558,  -558,    90, &
                  90,     9,   576,   -72, -4608,   576,  -720,   -72]
  K1(286,:) = [     9,    90,   -72,   576,     9,   -72,   -72,     9,   -72,     9,   -72,   -72,   -72,   576,     9,    90, &
                 -72,     9,   -72,   576,   576,   576,   576,   -72]
  K1(287,:) = [   576,  -639,  -153,   -72,     9,     9,   -72,  -558,   495,  -153,    90,   -72,   576,   -72,   -72,     9, &
                   9,    90,   -72,   -72,  -720,   576,   -72,  -720]
  K1(288,:) = [   -72,  -558,   495,  -153,    90,   -72,   576,  -639,  -153,   -72,     9,     9,   -72,     9,   576,   -72, &
                  90,     9,  -720,   576,   -72,   -72,  -720,   -72]
  K1(289,:) = [   -72,     9,   -72,     9,   -72,   -72,  -720,    90,   576,   -72,     9,  -153,   -72,     9,  -720,    90, &
                -639,  -558,   576,  -153,   -72,   495,   576,   -72]
  K1(290,:) = [     9,     9,     9,    90,    90,   -72,    90,    90,   -72,     9,  -558,   576,     9,    90,    90,  -558, &
                -558,   252,  -558,     9,   252,   -72,   576,   -72]
  K1(291,:) = [   -72,     9,   576,   -72,    90,     9,   576,   -72,   576,   -72,   576,   576,   576,   -72,   -72,     9, &
                   9,    90,     9,   -72,   -72,   -72,   -72,     9]
  K1(292,:) = [     9,    90,   -72,   576,     9,   -72,   -72,     9,   -72,     9,   -72,   -72,   -72,   576,     9,    90, &
                 -72,     9,   -72,   576,   576,   576,   576,   -72]
  K1(293,:) = [   -72,    90,    90,     9,     9,     9,     9,  -558,   576,   -72,   252,   -72,    90,     9,  -558,   252, &
                  90,  -558,    90,    90,  -558,   576,   -72,     9]
  K1(294,:) = [   -72,   -72,     9,   -72,     9,   -72,  -153,   576,   576,   -72,   -72,   495,     9,   -72,  -639,  -558, &
                -720,    90,    90,  -720,     9,  -153,   576,   -72]
  K1(295,:) = [  -720,    90,   576,   -72,     9,  -153,   -72,     9,   -72,     9,   -72,   -72,  -720,    90,   -72,     9, &
                -558,  -639,   -72,   495,   576,  -153,   -72,   576]
  K1(296,:) = [    90,    90,   -72,     9,  -558,   576,     9,     9,     9,    90,    90,   -72,    90,  -558,     9,    90, &
                 252,  -558,   252,   -72,  -558,     9,   -72,   576]
  K1(297,:) = [   576,   -72,   576,   -72,   576,   576,   -72,     9,   576,   -72,    90,     9,   -72,     9,   576,   -72, &
                  90,     9,   -72,   -72,     9,   -72,     9,   -72]
  K1(298,:) = [   -72,     9,   -72,     9,   -72,   -72,     9,    90,   -72,   576,     9,   -72,     9,    90,   -72,   576, &
                   9,   -72,   576,   576,   -72,   576,   -72,   576]
  K1(299,:) = [     9,  -558,   576,   -72,   252,   -72,   -72,    90,    90,     9,     9,     9,  -558,   252,    90,     9, &
                -558,    90,  -558,   576,    90,    90,     9,   -72]
  K1(300,:) = [  -153,   576,   576,   -72,   -72,   495,   -72,   -72,     9,   -72,     9,   -72,  -639,  -558,     9,   -72, &
                  90,  -720,     9,  -153,    90,  -720,   -72,   576]
  K1(301,:) = [   -72,     9,   576,   -72,    90,     9,  -720,    90,   -72,     9,  -558,  -639, -4608,   576,   576,   -72, &
                 -72,  -720,  -558,    90,   252,  -558,     9,    90]
  K1(302,:) = [     9,    90,   -72,   576,     9,   -72,    90,  -558,     9,    90,   252,  -558,   576, -4608,   -72,  -720, &
                 576,   -72,    90,  -720,  -558,  -639,   -72,     9]
  K1(303,:) = [  -720,    90,   -72,     9,  -558,  -639,   -72,     9,   576,   -72,    90,     9,   576,   -72, -4608,   576, &
                -720,   -72,   252,  -558,  -558,    90,    90,     9]
  K1(304,:) = [    90,  -558,     9,    90,   252,  -558,     9,    90,   -72,   576,     9,   -72,   -72,  -720,   576, -4608, &
                 -72,   576,  -558,  -639,    90,  -720,     9,   -72]
  K1(305,:) = [  -639,  -558,     9,   -72,    90,  -720,  -558,   252,    90,     9,  -558,    90,   -72,   576,  -720,   -72, &
               -4608,   576,     9,   -72,    90,     9,   576,   -72]
  K1(306,:) = [  -558,   252,    90,     9,  -558,    90,  -639,  -558,     9,   -72,    90,  -720,  -720,   -72,   -72,   576, &
                 576, -4608,    90,     9,     9,   -72,   -72,   576]
  K1(307,:) = [   576,  -558,     9,   -72,    90,    90,   -72,   252,   -72,   576,  -558,     9,  -558,    90,   252,  -558, &
                   9,    90,     9,     9,    90,   -72,     9,    90]
  K1(308,:) = [  -153,     9,   -72,   576,    90,  -720,   495,   -72,   -72,   576,   576,  -153,    90,  -720,  -558,  -639, &
                 -72,     9,     9,   -72,   -72,   -72,   -72,     9]
  K1(309,:) = [   -72,   252,   -72,   576,  -558,     9,   576,  -558,     9,   -72,    90,    90,   252,  -558,  -558,    90, &
                  90,     9,    90,   -72,     9,     9,    90,     9]
  K1(310,:) = [   495,   -72,   -72,   576,   576,  -153,  -153,     9,   -72,   576,    90,  -720,  -558,  -639,    90,  -720, &
                   9,   -72,   -72,   -72,     9,   -72,     9,   -72]
  K1(311,:) = [   576,   576,   -72,   576,   -72,   576,   -72,   -72,     9,   -72,     9,   -72,     9,   -72,    90,     9, &
                 576,   -72,     9,   -72,    90,     9,   576,   -72]
  K1(312,:) = [   -72,   -72,     9,   -72,     9,   -72,   576,   576,   -72,   576,   -72,   576,    90,     9,     9,   -72, &
                 -72,   576,    90,     9,     9,   -72,   -72,   576]
  K1(313,:) = [   648,   -81,   648,   -81,   648,   648,   648,   -81,     0,     0,    81,   162,     0,     0,  1296,  -162, &
                 729,   567,  -648,    81,    81,  -567,  -567,     0]
  K1(314,:) = [   -81,   -81,   -81,  -810,  -810,   648,   -81,   -81,     0,  -162,   -81,     0,     0,     0,  -162,  1134, &
                 567,  -324,   648,   -81,  -810,     0,  -729,   567]
  K1(315,:) = [   648,   -81, -5184,   648,  -810,   -81,  -648,    81, -1296,   162, -1215, -1134,     0,     0,     0,     0, &
                   0,     0,    81,    81,  -486,   324,   162,  -567]
  K1(316,:) = [   -81,  -810,   648, -5184,   -81,   648,    81,    81,   162,  -567,  -486,   324,     0,     0,     0,     0, &
                   0,     0,    81,  -648, -1215, -1134, -1296,   162]
  K1(317,:) = [   648,  -810,  -810,   -81,   -81,   -81,   -81,   648,  -729,   567,  -810,     0,     0,     0,   567,  -324, &
                -162,  1134,   -81,   -81,   -81,     0,     0,  -162]
  K1(318,:) = [   648,   648,   -81,   648,   -81,   648,    81,  -648,  -567,     0,    81,  -567,     0,     0,   729,   567, &
                1296,  -162,   -81,   648,    81,   162,     0,     0]
  K1(319,:) = [   648,   -81,  -648,    81,   -81,    81, -5184,   648,     0,     0,  -648, -1296, -1296,   162,     0,     0, &
                -567,  -729,    81,  -486,    81,   162,   324,  -567]
  K1(320,:) = [   -81,   -81,    81,    81,   648,  -648,   648,   648,     0,  1296,   648,     0,   162,  -567,     0,  -162, &
                   0,   567,   648,    81,   -81,     0,  -567,   729]
  K1(321,:) = [     0,     0, -1296,   162,  -729,  -567,     0,     0, -5184,   648, -1296,  -648,  -648,    81,   648,   -81, &
                  81,   -81,  -567,   324,   162,    81,  -486,    81]
  K1(322,:) = [     0,  -162,   162,  -567,   567,     0,     0,  1296,   648,   648,     0,   648,    81,    81,   -81,   -81, &
                -648,   648,   729,  -567,     0,   -81,    81,   648]
  K1(323,:) = [    81,   -81, -1215,  -486,  -810,    81,  -648,   648, -1296,     0, -5184,     0, -1134,   324,   162,     0, &
                -567,     0,   -81,    81,   648,     0,   162,     0]
  K1(324,:) = [   162,     0, -1134,   324,     0,  -567, -1296,     0,  -648,   648,     0, -5184, -1215,  -486,    81,   -81, &
                  81,  -810,     0,   162,     0,   648,    81,   -81]
  K1(325,:) = [     0,     0,     0,     0,     0,     0, -1296,   162,  -648,    81, -1134, -1215, -5184,   648,   648,   -81, &
                 -81,  -810,  -567,   162,   324,  -486,    81,    81]
  K1(326,:) = [     0,     0,     0,     0,     0,     0,   162,  -567,    81,    81,   324,  -486,   648, -5184,   -81,  -810, &
                 648,   -81,   162, -1296, -1134, -1215,  -648,    81]
  K1(327,:) = [  1296,  -162,     0,     0,   567,   729,     0,     0,   648,   -81,   162,    81,   648,   -81,   648,   -81, &
                 648,   648,     0,  -567,  -567,    81,    81,  -648]
  K1(328,:) = [  -162,  1134,     0,     0,  -324,   567,     0,  -162,   -81,   -81,     0,   -81,   -81,  -810,   -81,   -81, &
                 648,  -810,   567,  -729,     0,  -810,   -81,   648]
  K1(329,:) = [   729,   567,     0,     0,  -162,  1296,  -567,     0,    81,  -648,  -567,    81,   -81,   648,   648,   648, &
                 648,   -81,     0,     0,   162,    81,   648,   -81]
  K1(330,:) = [   567,  -324,     0,     0,  1134,  -162,  -729,   567,   -81,   648,     0,  -810,  -810,   -81,   648,  -810, &
                 -81,   -81,  -162,     0,     0,   -81,   -81,   -81]
  K1(331,:) = [  -648,   648,    81,    81,   -81,   -81,    81,   648,  -567,   729,   -81,     0,  -567,   162,     0,   567, &
                   0,  -162,   648,   648,   648,     0,     0,  1296]
  K1(332,:) = [    81,   -81,    81,  -648,   -81,   648,  -486,    81,   324,  -567,    81,   162,   162, -1296,  -567,  -729, &
                   0,     0,   648, -5184,  -648, -1296,     0,     0]
  K1(333,:) = [    81,  -810,  -486, -1215,   -81,    81,    81,   -81,   162,     0,   648,     0,   324, -1134,  -567,     0, &
                 162,     0,   648,  -648, -5184,     0, -1296,     0]
  K1(334,:) = [  -567,     0,   324, -1134,     0,   162,   162,     0,    81,   -81,     0,   648,  -486, -1215,    81,  -810, &
                  81,   -81,     0, -1296,     0, -5184,  -648,   648]
  K1(335,:) = [  -567,  -729,   162, -1296,     0,     0,   324,  -567,  -486,    81,   162,    81,    81,  -648,    81,   -81, &
                 648,   -81,     0,     0, -1296,  -648, -5184,   648]
  K1(336,:) = [     0,   567,  -567,   162,  -162,     0,  -567,   729,    81,   648,     0,   -81,    81,    81,  -648,   648, &
                 -81,   -81,  1296,     0,     0,   648,   648,   648]
  K1(337,:) = [ -5184,   648,     0,     0,  -648, -1296,   648,   -81,  -648,    81,   -81,    81,     0,     0, -1296,   162, &
                -729,  -567,    81,   162,    81,  -486,  -567,   324]
  K1(338,:) = [   648,   648,     0,  1296,   648,     0,   -81,   -81,    81,    81,   648,  -648,     0,  -162,   162,  -567, &
                 567,     0,   -81,     0,   648,    81,   729,  -567]
  K1(339,:) = [     0,     0, -5184,   648, -1296,  -648,     0,     0, -1296,   162,  -729,  -567,   648,   -81,  -648,    81, &
                 -81,    81,   162,    81,  -567,   324,    81,  -486]
  K1(340,:) = [     0,  1296,   648,   648,     0,   648,     0,  -162,   162,  -567,   567,     0,   -81,   -81,    81,    81, &
                 648,  -648,     0,   -81,   729,  -567,   648,    81]
  K1(341,:) = [  -648,   648, -1296,     0, -5184,     0,    81,   -81, -1215,  -486,  -810,    81,   162,     0, -1134,   324, &
                   0,  -567,   648,     0,   -81,    81,     0,   162]
  K1(342,:) = [ -1296,     0,  -648,   648,     0, -5184,   162,     0, -1134,   324,     0,  -567,    81,   -81, -1215,  -486, &
                -810,    81,     0,   648,     0,   162,   -81,    81]
  K1(343,:) = [   648,   -81,     0,     0,    81,   162,   648,   -81,   648,   -81,   648,   648,  1296,  -162,     0,     0, &
                 567,   729,    81,  -567,  -648,    81,     0,  -567]
  K1(344,:) = [   -81,   -81,     0,  -162,   -81,     0,   -81,   -81,   -81,  -810,  -810,   648,  -162,  1134,     0,     0, &
                -324,   567,  -810,     0,   648,   -81,   567,  -729]
  K1(345,:) = [  -648,    81, -1296,   162, -1215, -1134,   648,   -81, -5184,   648,  -810,   -81,     0,     0,     0,     0, &
                   0,     0,  -486,   324,    81,    81,  -567,   162]
  K1(346,:) = [    81,    81,   162,  -567,  -486,   324,   -81,  -810,   648, -5184,   -81,   648,     0,     0,     0,     0, &
                   0,     0, -1215, -1134,    81,  -648,   162, -1296]
  K1(347,:) = [   -81,   648,  -729,   567,  -810,     0,   648,  -810,  -810,   -81,   -81,   -81,   567,  -324,     0,     0, &
                1134,  -162,   -81,     0,   -81,   -81,  -162,     0]
  K1(348,:) = [    81,  -648,  -567,     0,    81,  -567,   648,   648,   -81,   648,   -81,   648,   729,   567,     0,     0, &
                -162,  1296,    81,   162,   -81,   648,     0,     0]
  K1(349,:) = [     0,     0,   648,   -81,   162,    81,  1296,  -162,     0,     0,   567,   729,   648,   -81,   648,   -81, &
                 648,   648,  -567,    81,     0,  -567,  -648,    81]
  K1(350,:) = [     0,  -162,   -81,   -81,     0,   -81,  -162,  1134,     0,     0,  -324,   567,   -81,   -81,   -81,  -810, &
                -810,   648,     0,  -810,   567,  -729,   648,   -81]
  K1(351,:) = [ -1296,   162,  -648,    81, -1134, -1215,     0,     0,     0,     0,     0,     0,   648,   -81, -5184,   648, &
                -810,   -81,   324,  -486,  -567,   162,    81,    81]
  K1(352,:) = [   162,  -567,    81,    81,   324,  -486,     0,     0,     0,     0,     0,     0,   -81,  -810,   648, -5184, &
                 -81,   648, -1134, -1215,   162, -1296,    81,  -648]
  K1(353,:) = [  -729,   567,   -81,   648,     0,  -810,   567,  -324,     0,     0,  1134,  -162,   648,  -810,  -810,   -81, &
                 -81,   -81,     0,   -81,  -162,     0,   -81,   -81]
  K1(354,:) = [  -567,     0,    81,  -648,  -567,    81,   729,   567,     0,     0,  -162,  1296,   648,   648,   -81,   648, &
                 -81,   648,   162,    81,     0,     0,   -81,   648]
  K1(355,:) = [    81,   -81,   162,     0,   648,     0,    81,  -810,  -486, -1215,   -81,    81,  -567,     0,   324, -1134, &
                   0,   162, -5184,     0,   648,  -648,     0, -1296]
  K1(356,:) = [   162,     0,    81,   -81,     0,   648,  -567,     0,   324, -1134,     0,   162,    81,  -810,  -486, -1215, &
                 -81,    81,     0, -5184,     0, -1296,   648,  -648]
  K1(357,:) = [    81,   648,  -567,   729,   -81,     0,  -648,   648,    81,    81,   -81,   -81,     0,   567,  -567,   162, &
                -162,     0,   648,     0,   648,   648,  1296,     0]
  K1(358,:) = [  -486,    81,   324,  -567,    81,   162,    81,   -81,    81,  -648,   -81,   648,  -567,  -729,   162, -1296, &
                   0,     0,  -648, -1296,   648, -5184,     0,     0]
  K1(359,:) = [  -567,   729,    81,   648,     0,   -81,     0,   567,  -567,   162,  -162,     0,  -648,   648,    81,    81, &
                 -81,   -81,     0,   648,  1296,     0,   648,   648]
  K1(360,:) = [   324,  -567,  -486,    81,   162,    81,  -567,  -729,   162, -1296,     0,     0,    81,   -81,    81,  -648, &
                 -81,   648, -1296,  -648,     0,     0,   648, -5184]
  K1(361,:) = [  9216, -1152, -1152,   144,   144,  1440, -1152,   144,   144,   -18,   -18,  -180,   144,   -18,  1440,  -180, &
                1278,  1116,   -18,  -180,  -180,  1116,  1116,  -504]
  K1(362,:) = [ -1152,  9216,   144,  1440, -1152,   144,   144, -1152,   -18,  -180,   144,   -18,   -18,  -180,  -180,  1116, &
                1116,  -504,   144,   -18,  1440,  -180,  1278,  1116]
  K1(363,:) = [ -1152,   144,  9216, -1152,  1440,   144,   144,   -18,  1440,  -180,  1278,  1116, -1152,   144,   144,   -18, &
                 -18,  -180,  -180,   -18,  1116,  -504,  -180,  1116]
  K1(364,:) = [   144,  1440, -1152,  9216,   144, -1152,   -18,  -180,  -180,  1116,  1116,  -504,   144, -1152,   -18,  -180, &
                 144,   -18,   -18,   144,  1278,  1116,  1440,  -180]
  K1(365,:) = [   144, -1152,  1440,   144,  9216, -1152,   -18,   144,  1278,  1116,  1440,  -180,  -180,   -18,  1116,  -504, &
                -180,  1116, -1152,   144,   144,   -18,   -18,  -180]
  K1(366,:) = [  1440,   144,   144, -1152, -1152,  9216,  -180,   -18,  1116,  -504,  -180,  1116,   -18,   144,  1278,  1116, &
                1440,  -180,   144, -1152,   -18,  -180,   144,   -18]
  K1(367,:) = [ -1152,   144,   144,   -18,   -18,  -180,  9216, -1152, -1152,   144,   144,  1440,  1440,  -180,   144,   -18, &
                1116,  1278,  -180,  1116,   -18,  -180,  -504,  1116]
  K1(368,:) = [   144, -1152,   -18,  -180,   144,   -18, -1152,  9216,   144,  1440, -1152,   144,  -180,  1116,   -18,  -180, &
                -504,  1116,  1440,  -180,   144,   -18,  1116,  1278]
  K1(369,:) = [   144,   -18,  1440,  -180,  1278,  1116, -1152,   144,  9216, -1152,  1440,   144,   144,   -18, -1152,   144, &
                -180,   -18,  1116,  -504,  -180,   -18,  1116,  -180]
  K1(370,:) = [   -18,  -180,  -180,  1116,  1116,  -504,   144,  1440, -1152,  9216,   144, -1152,   -18,  -180,   144, -1152, &
                 -18,   144,  1278,  1116,   -18,   144,  -180,  1440]
  K1(371,:) = [   -18,   144,  1278,  1116,  1440,  -180,   144, -1152,  1440,   144,  9216, -1152,  1116,  -504,  -180,   -18, &
                1116,  -180,   144,   -18, -1152,   144,  -180,   -18]
  K1(372,:) = [  -180,   -18,  1116,  -504,  -180,  1116,  1440,   144,   144, -1152, -1152,  9216,  1278,  1116,   -18,   144, &
                -180,  1440,   -18,  -180,   144, -1152,   -18,   144]
  K1(373,:) = [   144,   -18, -1152,   144,  -180,   -18,  1440,  -180,   144,   -18,  1116,  1278,  9216, -1152, -1152,   144, &
                 144,  1440,  1116,  -180,  -504,  1116,   -18,  -180]
  K1(374,:) = [   -18,  -180,   144, -1152,   -18,   144,  -180,  1116,   -18,  -180,  -504,  1116, -1152,  9216,   144,  1440, &
               -1152,   144,  -180,  1440,  1116,  1278,   144,   -18]
  K1(375,:) = [  1440,  -180,   144,   -18,  1116,  1278,   144,   -18, -1152,   144,  -180,   -18, -1152,   144,  9216, -1152, &
                1440,   144,  -504,  1116,  1116,  -180,  -180,   -18]
  K1(376,:) = [  -180,  1116,   -18,  -180,  -504,  1116,   -18,  -180,   144, -1152,   -18,   144,   144,  1440, -1152,  9216, &
                 144, -1152,  1116,  1278,  -180,  1440,   -18,   144]
  K1(377,:) = [  1278,  1116,   -18,   144,  -180,  1440,  1116,  -504,  -180,   -18,  1116,  -180,   144, -1152,  1440,   144, &
                9216, -1152,   -18,   144,  -180,   -18, -1152,   144]
  K1(378,:) = [  1116,  -504,  -180,   -18,  1116,  -180,  1278,  1116,   -18,   144,  -180,  1440,  1440,   144,   144, -1152, &
               -1152,  9216,  -180,   -18,   -18,   144,   144, -1152]
  K1(379,:) = [   -18,   144,  -180,   -18, -1152,   144,  -180,  1440,  1116,  1278,   144,   -18,  1116,  -180,  -504,  1116, &
                 -18,  -180,  9216, -1152, -1152,   144,   144,  1440]
  K1(380,:) = [  -180,   -18,   -18,   144,   144, -1152,  1116,  -180,  -504,  1116,   -18,  -180,  -180,  1440,  1116,  1278, &
                 144,   -18, -1152,  9216,   144,  1440, -1152,   144]
  K1(381,:) = [  -180,  1440,  1116,  1278,   144,   -18,   -18,   144,  -180,   -18, -1152,   144,  -504,  1116,  1116,  -180, &
                -180,   -18, -1152,   144,  9216, -1152,  1440,   144]
  K1(382,:) = [  1116,  -180,  -504,  1116,   -18,  -180,  -180,   -18,   -18,   144,   144, -1152,  1116,  1278,  -180,  1440, &
                 -18,   144,   144,  1440, -1152,  9216,   144, -1152]
  K1(383,:) = [  1116,  1278,  -180,  1440,   -18,   144,  -504,  1116,  1116,  -180,  -180,   -18,   -18,   144,  -180,   -18, &
               -1152,   144,   144, -1152,  1440,   144,  9216, -1152]
  K1(384,:) = [  -504,  1116,  1116,  -180,  -180,   -18,  1116,  1278,  -180,  1440,   -18,   144,  -180,   -18,   -18,   144, &
                 144, -1152,  1440,   144,   144, -1152, -1152,  9216]
  K1(385,:) = [ -4608,   576,   576,   -72,   -72,  -720,   576,   -72,   -72,     9,     9,    90,   -72,     9,  -720,    90, &
                -639,  -558,     9,    90,    90,  -558,  -558,   252]
  K1(386,:) = [   576,   576,   -72,   576,   -72,   576,   -72,   -72,     9,   -72,     9,   -72,     9,   -72,    90,     9, &
                 576,   -72,     9,   -72,    90,     9,   576,   -72]
  K1(387,:) = [   576,   -72, -4608,   576,  -720,   -72,   -72,     9,  -720,    90,  -639,  -558,   576,   -72,   -72,     9, &
                   9,    90,    90,     9,  -558,   252,    90,  -558]
  K1(388,:) = [   -72,   576,   576,   576,   576,   -72,     9,   -72,    90,     9,   576,   -72,   -72,   -72,     9,   -72, &
                   9,   -72,   -72,     9,   576,   -72,    90,     9]
  K1(389,:) = [   -72,   -72,  -720,   576,   -72,  -720,     9,     9,  -639,   576,   -72,  -153,    90,   -72,  -558,   -72, &
                -153,   495,     9,    90,   -72,   576,     9,   -72]
  K1(390,:) = [  -720,   576,   -72,   -72,  -720,   -72,    90,   -72,  -558,   -72,  -153,   495,     9,     9,  -639,   576, &
                 -72,  -153,    90,     9,     9,   -72,   -72,   576]
  K1(391,:) = [   576,   -72,   -72,     9,     9,    90, -4608,   576,   576,   -72,   -72,  -720,  -720,    90,   -72,     9, &
                -558,  -639,    90,  -558,     9,    90,   252,  -558]
  K1(392,:) = [   -72,   -72,     9,   -72,     9,   -72,   576,   576,   -72,   576,   -72,   576,    90,     9,     9,   -72, &
                 -72,   576,    90,     9,     9,   -72,   -72,   576]
  K1(393,:) = [   -72,     9,  -720,    90,  -639,  -558,   576,   -72, -4608,   576,  -720,   -72,   -72,     9,   576,   -72, &
                  90,     9,  -558,   252,    90,     9,  -558,    90]
  K1(394,:) = [     9,   -72,    90,     9,   576,   -72,   -72,   576,   576,   576,   576,   -72,     9,   -72,   -72,   -72, &
                 -72,     9,   576,   -72,   -72,     9,     9,    90]
  K1(395,:) = [     9,     9,  -639,   576,   -72,  -153,   -72,   -72,  -720,   576,   -72,  -720,  -558,   -72,    90,   -72, &
                 495,  -153,   -72,   576,     9,    90,   -72,     9]
  K1(396,:) = [    90,   -72,  -558,   -72,  -153,   495,  -720,   576,   -72,   -72,  -720,   -72,  -639,   576,     9,     9, &
                -153,   -72,     9,   -72,    90,     9,   576,   -72]
  K1(397,:) = [   -72,     9,   576,   -72,    90,     9,  -720,    90,   -72,     9,  -558,  -639, -4608,   576,   576,   -72, &
                 -72,  -720,  -558,    90,   252,  -558,     9,    90]
  K1(398,:) = [     9,   -72,   -72,   -72,   -72,     9,    90,     9,     9,   -72,   -72,   576,   576,   576,   -72,   576, &
                 -72,   576,     9,    90,   -72,   576,     9,   -72]
  K1(399,:) = [  -720,    90,   -72,     9,  -558,  -639,   -72,     9,   576,   -72,    90,     9,   576,   -72, -4608,   576, &
                -720,   -72,   252,  -558,  -558,    90,    90,     9]
  K1(400,:) = [    90,     9,     9,   -72,   -72,   576,     9,   -72,   -72,   -72,   -72,     9,   -72,   576,   576,   576, &
                 576,   -72,   -72,   576,     9,    90,   -72,     9]
  K1(401,:) = [  -639,   576,     9,     9,  -153,   -72,  -558,   -72,    90,   -72,   495,  -153,   -72,   -72,  -720,   576, &
                 -72,  -720,   576,   -72,   -72,     9,     9,    90]
  K1(402,:) = [  -558,   -72,    90,   -72,   495,  -153,  -639,   576,     9,     9,  -153,   -72,  -720,   576,   -72,   -72, &
                -720,   -72,   -72,     9,   576,   -72,    90,     9]
  K1(403,:) = [     9,     9,    90,   -72,     9,    90,    90,    90,  -558,   576,   -72,     9,  -558,     9,   252,   -72, &
                 576,   -72,     9,    90,    90,  -558,  -558,   252]
  K1(404,:) = [    90,   -72,     9,     9,    90,     9,  -558,     9,   252,   -72,   576,   -72,    90,    90,  -558,   576, &
                 -72,     9,    90,     9,  -558,   252,    90,  -558]
  K1(405,:) = [    90,    90,  -558,   576,   -72,     9,     9,     9,    90,   -72,     9,    90,   252,   -72,  -558,     9, &
                 -72,   576,    90,  -558,     9,    90,   252,  -558]
  K1(406,:) = [  -558,     9,   252,   -72,   576,   -72,    90,   -72,     9,     9,    90,     9,  -558,   576,    90,    90, &
                   9,   -72,  -558,   252,    90,     9,  -558,    90]
  K1(407,:) = [  -558,   576,    90,    90,     9,   -72,   252,   -72,  -558,     9,   -72,   576,     9,     9,    90,   -72, &
                   9,    90,  -558,    90,   252,  -558,     9,    90]
  K1(408,:) = [   252,   -72,  -558,     9,   -72,   576,  -558,   576,    90,    90,     9,   -72,    90,   -72,     9,     9, &
                  90,     9,   252,  -558,  -558,    90,    90,     9]
  K1(409,:) = [     9,     9,    90,   -72,     9,    90,    90,    90,  -558,   576,   -72,     9,  -558,     9,   252,   -72, &
                 576,   -72,     9,    90,    90,  -558,  -558,   252]
  K1(410,:) = [     9,   -72,   -72,   -72,   -72,     9,    90,  -720,     9,  -153,   576,   -72,   576,  -153,   -72,   495, &
                 576,   -72,   -72,     9,  -720,    90,  -639,  -558]
  K1(411,:) = [    90,   -72,     9,     9,    90,     9,  -558,     9,   252,   -72,   576,   -72,    90,    90,  -558,   576, &
                 -72,     9,    90,     9,  -558,   252,    90,  -558]
  K1(412,:) = [   -72,   -72,     9,   -72,     9,   -72,   576,  -153,   -72,   495,   576,   -72,    90,  -720,     9,  -153, &
                 576,   -72,     9,   -72,  -639,  -558,  -720,    90]
  K1(413,:) = [     9,   -72,    90,     9,   576,   -72,   -72,   576,   576,   576,   576,   -72,     9,   -72,   -72,   -72, &
                 -72,     9,   576,   -72,   -72,     9,     9,    90]
  K1(414,:) = [    90,     9,     9,   -72,   -72,   576,     9,   -72,   -72,   -72,   -72,     9,   -72,   576,   576,   576, &
                 576,   -72,   -72,   576,     9,    90,   -72,     9]
  K1(415,:) = [    90,    90,  -558,   576,   -72,     9,     9,     9,    90,   -72,     9,    90,   252,   -72,  -558,     9, &
                 -72,   576,    90,  -558,     9,    90,   252,  -558]
  K1(416,:) = [    90,  -720,     9,  -153,   576,   -72,     9,   -72,   -72,   -72,   -72,     9,   -72,   495,   576,  -153, &
                 -72,   576,  -720,    90,   -72,     9,  -558,  -639]
  K1(417,:) = [  -558,     9,   252,   -72,   576,   -72,    90,   -72,     9,     9,    90,     9,  -558,   576,    90,    90, &
                   9,   -72,  -558,   252,    90,     9,  -558,    90]
  K1(418,:) = [   576,  -153,   -72,   495,   576,   -72,   -72,   -72,     9,   -72,     9,   -72,     9,  -153,    90,  -720, &
                 -72,   576,  -639,  -558,     9,   -72,    90,  -720]
  K1(419,:) = [   -72,   576,   576,   576,   576,   -72,     9,   -72,    90,     9,   576,   -72,   -72,   -72,     9,   -72, &
                   9,   -72,   -72,     9,   576,   -72,    90,     9]
  K1(420,:) = [     9,   -72,   -72,   -72,   -72,     9,    90,     9,     9,   -72,   -72,   576,   576,   576,   -72,   576, &
                 -72,   576,     9,    90,   -72,   576,     9,   -72]
  K1(421,:) = [  -558,   576,    90,    90,     9,   -72,   252,   -72,  -558,     9,   -72,   576,     9,     9,    90,   -72, &
                   9,    90,  -558,    90,   252,  -558,     9,    90]
  K1(422,:) = [     9,  -153,    90,  -720,   -72,   576,   -72,   495,   576,  -153,   -72,   576,     9,   -72,   -72,   -72, &
                 -72,     9,    90,  -720,  -558,  -639,   -72,     9]
  K1(423,:) = [   252,   -72,  -558,     9,   -72,   576,  -558,   576,    90,    90,     9,   -72,    90,   -72,     9,     9, &
                  90,     9,   252,  -558,  -558,    90,    90,     9]
  K1(424,:) = [   -72,   495,   576,  -153,   -72,   576,     9,  -153,    90,  -720,   -72,   576,   -72,   -72,     9,   -72, &
                   9,   -72,  -558,  -639,    90,  -720,     9,   -72]
  K1(425,:) = [   576,   576,   -72,   576,   -72,   576,   -72,   -72,     9,   -72,     9,   -72,     9,   -72,    90,     9, &
                 576,   -72,     9,   -72,    90,     9,   576,   -72]
  K1(426,:) = [   -72,   -72,     9,   -72,     9,   -72,   576,   576,   -72,   576,   -72,   576,    90,     9,     9,   -72, &
                 -72,   576,    90,     9,     9,   -72,   -72,   576]
  K1(427,:) = [     9,   -72,    90,     9,   576,   -72,    90,  -720,  -558,  -639,   -72,     9,  -558,    90,   252,  -558, &
                   9,    90, -4608,   576,   576,   -72,   -72,  -720]
  K1(428,:) = [    90,     9,     9,   -72,   -72,   576,  -558,    90,   252,  -558,     9,    90,    90,  -720,  -558,  -639, &
                 -72,     9,   576, -4608,   -72,  -720,   576,   -72]
  K1(429,:) = [    90,  -720,  -558,  -639,   -72,     9,     9,   -72,    90,     9,   576,   -72,   252,  -558,  -558,    90, &
                  90,     9,   576,   -72, -4608,   576,  -720,   -72]
  K1(430,:) = [  -558,    90,   252,  -558,     9,    90,    90,     9,     9,   -72,   -72,   576,  -558,  -639,    90,  -720, &
                   9,   -72,   -72,  -720,   576, -4608,   -72,   576]
  K1(431,:) = [  -558,  -639,    90,  -720,     9,   -72,   252,  -558,  -558,    90,    90,     9,     9,   -72,    90,     9, &
                 576,   -72,   -72,   576,  -720,   -72, -4608,   576]
  K1(432,:) = [   252,  -558,  -558,    90,    90,     9,  -558,  -639,    90,  -720,     9,   -72,    90,     9,     9,   -72, &
                 -72,   576,  -720,   -72,   -72,   576,   576, -4608]
  K1(433,:) = [   -81,   -81,  -810,   648,   -81,  -810,   -81,   -81,   -81,     0,     0,  -162,   648,   -81,  -810,     0, &
                -729,   567,     0,     0,  -162,  1134,   567,  -324]
  K1(434,:) = [   -81,   648,   648,   648,   648,   -81,   -81,   648,    81,   162,     0,     0,  -648,    81,    81,  -567, &
                -567,     0,     0,     0,  1296,  -162,   729,   567]
  K1(435,:) = [  -810,   648,   -81,   -81,  -810,   -81,   648,   -81,  -810,     0,  -729,   567,   -81,   -81,   -81,     0, &
                   0,  -162,     0,     0,   567,  -324,  -162,  1134]
  K1(436,:) = [   648,   648,   -81,   648,   -81,   648,  -648,    81,    81,  -567,  -567,     0,   -81,   648,    81,   162, &
                   0,     0,     0,     0,   729,   567,  1296,  -162]
  K1(437,:) = [   -81,   648,  -810,   -81, -5184,   648,    81,  -648, -1215, -1134, -1296,   162,    81,    81,  -486,   324, &
                 162,  -567,     0,     0,     0,     0,     0,     0]
  K1(438,:) = [  -810,   -81,   -81,   648,   648, -5184,    81,    81,  -486,   324,   162,  -567,    81,  -648, -1215, -1134, &
               -1296,   162,     0,     0,     0,     0,     0,     0]
  K1(439,:) = [   -81,   -81,   648,  -648,    81,    81,   648,   648,   648,     0,     0,  1296,   648,    81,   -81,     0, &
                -567,   729,   162,  -567,     0,  -162,     0,   567]
  K1(440,:) = [   -81,   648,   -81,    81,  -648,    81,   648, -5184,  -648, -1296,     0,     0,    81,  -486,    81,   162, &
                 324,  -567, -1296,   162,     0,     0,  -567,  -729]
  K1(441,:) = [   -81,    81,  -810,    81, -1215,  -486,   648,  -648, -5184,     0, -1296,     0,   -81,    81,   648,     0, &
                 162,     0, -1134,   324,   162,     0,  -567,     0]
  K1(442,:) = [     0,   162,     0,  -567, -1134,   324,     0, -1296,     0, -5184,  -648,   648,     0,   162,     0,   648, &
                  81,   -81, -1215,  -486,    81,   -81,    81,  -810]
  K1(443,:) = [     0,     0,  -729,  -567, -1296,   162,     0,     0, -1296,  -648, -5184,   648,  -567,   324,   162,    81, &
                -486,    81,  -648,    81,   648,   -81,    81,   -81]
  K1(444,:) = [  -162,     0,   567,     0,   162,  -567,  1296,     0,     0,   648,   648,   648,   729,  -567,     0,   -81, &
                  81,   648,    81,    81,   -81,   -81,  -648,   648]
  K1(445,:) = [   648,  -648,   -81,   -81,    81,    81,   648,    81,   -81,     0,  -567,   729,   648,   648,   648,     0, &
                   0,  1296,  -567,   162,     0,   567,     0,  -162]
  K1(446,:) = [   -81,    81,   -81,   648,    81,  -648,    81,  -486,    81,   162,   324,  -567,   648, -5184,  -648, -1296, &
                   0,     0,   162, -1296,  -567,  -729,     0,     0]
  K1(447,:) = [  -810,    81,   -81,    81,  -486, -1215,   -81,    81,   648,     0,   162,     0,   648,  -648, -5184,     0, &
               -1296,     0,   324, -1134,  -567,     0,   162,     0]
  K1(448,:) = [     0,  -567,     0,   162,   324, -1134,     0,   162,     0,   648,    81,   -81,     0, -1296,     0, -5184, &
                -648,   648,  -486, -1215,    81,  -810,    81,   -81]
  K1(449,:) = [  -729,  -567,     0,     0,   162, -1296,  -567,   324,   162,    81,  -486,    81,     0,     0, -1296,  -648, &
               -5184,   648,    81,  -648,    81,   -81,   648,   -81]
  K1(450,:) = [   567,     0,  -162,     0,  -567,   162,   729,  -567,     0,   -81,    81,   648,  1296,     0,     0,   648, &
                 648,   648,    81,    81,  -648,   648,   -81,   -81]
  K1(451,:) = [     0,     0,     0,     0,     0,     0,   162, -1296, -1134, -1215,  -648,    81,  -567,   162,   324,  -486, &
                  81,    81, -5184,   648,   648,   -81,   -81,  -810]
  K1(452,:) = [     0,     0,     0,     0,     0,     0,  -567,   162,   324,  -486,    81,    81,   162, -1296, -1134, -1215, &
                -648,    81,   648, -5184,   -81,  -810,   648,   -81]
  K1(453,:) = [  -162,  1296,   567,   729,     0,     0,     0,     0,   162,    81,   648,   -81,     0,  -567,  -567,    81, &
                  81,  -648,   648,   -81,   648,   -81,   648,   648]
  K1(454,:) = [  1134,  -162,  -324,   567,     0,     0,  -162,     0,     0,   -81,   -81,   -81,   567,  -729,     0,  -810, &
                 -81,   648,   -81,  -810,   -81,   -81,   648,  -810]
  K1(455,:) = [   567,   729,  -162,  1296,     0,     0,     0,  -567,  -567,    81,    81,  -648,     0,     0,   162,    81, &
                 648,   -81,   -81,   648,   648,   648,   648,   -81]
  K1(456,:) = [  -324,   567,  1134,  -162,     0,     0,   567,  -729,     0,  -810,   -81,   648,  -162,     0,     0,   -81, &
                 -81,   -81,  -810,   -81,   648,  -810,   -81,   -81]
  K1(457,:) = [   648,   648,   648,     0,     0,  1296,   -81,   -81,   648,  -648,    81,    81,   -81,     0,   648,    81, &
                 729,  -567,     0,  -162,   162,  -567,   567,     0]
  K1(458,:) = [   648, -5184,  -648, -1296,     0,     0,   -81,   648,   -81,    81,  -648,    81,    81,   162,    81,  -486, &
                -567,   324,     0,     0, -1296,   162,  -729,  -567]
  K1(459,:) = [   648,  -648, -5184,     0, -1296,     0,   -81,    81,  -810,    81, -1215,  -486,   648,     0,   -81,    81, &
                   0,   162,   162,     0, -1134,   324,     0,  -567]
  K1(460,:) = [     0, -1296,     0, -5184,  -648,   648,     0,   162,     0,  -567, -1134,   324,     0,   648,     0,   162, &
                 -81,    81,    81,   -81, -1215,  -486,  -810,    81]
  K1(461,:) = [     0,     0, -1296,  -648, -5184,   648,     0,     0,  -729,  -567, -1296,   162,   162,    81,  -567,   324, &
                  81,  -486,   648,   -81,  -648,    81,   -81,    81]
  K1(462,:) = [  1296,     0,     0,   648,   648,   648,  -162,     0,   567,     0,   162,  -567,     0,   -81,   729,  -567, &
                 648,    81,   -81,   -81,    81,    81,   648,  -648]
  K1(463,:) = [   -81,   -81,   -81,     0,     0,  -162,   -81,   -81,  -810,   648,   -81,  -810,  -810,     0,   648,   -81, &
                 567,  -729,  -162,  1134,     0,     0,  -324,   567]
  K1(464,:) = [   -81,   648,    81,   162,     0,     0,   -81,   648,   648,   648,   648,   -81,    81,  -567,  -648,    81, &
                   0,  -567,  1296,  -162,     0,     0,   567,   729]
  K1(465,:) = [   648,   -81,  -810,     0,  -729,   567,  -810,   648,   -81,   -81,  -810,   -81,   -81,     0,   -81,   -81, &
                -162,     0,   567,  -324,     0,     0,  1134,  -162]
  K1(466,:) = [  -648,    81,    81,  -567,  -567,     0,   648,   648,   -81,   648,   -81,   648,    81,   162,   -81,   648, &
                   0,     0,   729,   567,     0,     0,  -162,  1296]
  K1(467,:) = [    81,  -648, -1215, -1134, -1296,   162,   -81,   648,  -810,   -81, -5184,   648,  -486,   324,    81,    81, &
                -567,   162,     0,     0,     0,     0,     0,     0]
  K1(468,:) = [    81,    81,  -486,   324,   162,  -567,  -810,   -81,   -81,   648,   648, -5184, -1215, -1134,    81,  -648, &
                 162, -1296,     0,     0,     0,     0,     0,     0]
  K1(469,:) = [   -81,    81,   648,     0,   162,     0,  -810,    81,   -81,    81,  -486, -1215, -5184,     0,   648,  -648, &
                   0, -1296,  -567,     0,   324, -1134,     0,   162]
  K1(470,:) = [     0,   162,     0,   648,    81,   -81,     0,  -567,     0,   162,   324, -1134,     0, -5184,     0, -1296, &
                 648,  -648,    81,  -810,  -486, -1215,   -81,    81]
  K1(471,:) = [   648,    81,   -81,     0,  -567,   729,   648,  -648,   -81,   -81,    81,    81,   648,     0,   648,   648, &
                1296,     0,     0,   567,  -567,   162,  -162,     0]
  K1(472,:) = [    81,  -486,    81,   162,   324,  -567,   -81,    81,   -81,   648,    81,  -648,  -648, -1296,   648, -5184, &
                   0,     0,  -567,  -729,   162, -1296,     0,     0]
  K1(473,:) = [   729,  -567,     0,   -81,    81,   648,   567,     0,  -162,     0,  -567,   162,     0,   648,  1296,     0, &
                 648,   648,  -648,   648,    81,    81,   -81,   -81]
  K1(474,:) = [  -567,   324,   162,    81,  -486,    81,  -729,  -567,     0,     0,   162, -1296, -1296,  -648,     0,     0, &
                 648, -5184,    81,   -81,    81,  -648,   -81,   648]
  K1(475,:) = [     0,     0,   162,    81,   648,   -81,  -162,  1296,   567,   729,     0,     0,  -567,    81,     0,  -567, &
                -648,    81,   648,   -81,   648,   -81,   648,   648]
  K1(476,:) = [  -162,     0,     0,   -81,   -81,   -81,  1134,  -162,  -324,   567,     0,     0,     0,  -810,   567,  -729, &
                 648,   -81,   -81,   -81,   -81,  -810,  -810,   648]
  K1(477,:) = [   162, -1296, -1134, -1215,  -648,    81,     0,     0,     0,     0,     0,     0,   324,  -486,  -567,   162, &
                  81,    81,   648,   -81, -5184,   648,  -810,   -81]
  K1(478,:) = [  -567,   162,   324,  -486,    81,    81,     0,     0,     0,     0,     0,     0, -1134, -1215,   162, -1296, &
                  81,  -648,   -81,  -810,   648, -5184,   -81,   648]
  K1(479,:) = [   567,  -729,     0,  -810,   -81,   648,  -324,   567,  1134,  -162,     0,     0,     0,   -81,  -162,     0, &
                 -81,   -81,   648,  -810,  -810,   -81,   -81,   -81]
  K1(480,:) = [     0,  -567,  -567,    81,    81,  -648,   567,   729,  -162,  1296,     0,     0,   162,    81,     0,     0, &
                 -81,   648,   648,   648,   -81,   648,   -81,   648]
  K1(481,:) = [ -5184,     0,   648,  -648,     0, -1296,   648,     0,   -81,    81,     0,   162,   -81,    81,  -810,    81, &
               -1215,  -486,     0,   162,     0,  -567, -1134,   324]
  K1(482,:) = [     0, -5184,     0, -1296,   648,  -648,     0,   648,     0,   162,   -81,    81,     0,   162,     0,  -567, &
               -1134,   324,   -81,    81,  -810,    81, -1215,  -486]
  K1(483,:) = [   648,     0,   648,   648,  1296,     0,   -81,     0,   648,    81,   729,  -567,   -81,   -81,   648,  -648, &
                  81,    81,  -162,     0,   567,     0,   162,  -567]
  K1(484,:) = [  -648, -1296,   648, -5184,     0,     0,    81,   162,    81,  -486,  -567,   324,   -81,   648,   -81,    81, &
                -648,    81,     0,     0,  -729,  -567, -1296,   162]
  K1(485,:) = [     0,   648,  1296,     0,   648,   648,     0,   -81,   729,  -567,   648,    81,  -162,     0,   567,     0, &
                 162,  -567,   -81,   -81,   648,  -648,    81,    81]
  K1(486,:) = [ -1296,  -648,     0,     0,   648, -5184,   162,    81,  -567,   324,    81,  -486,     0,     0,  -729,  -567, &
               -1296,   162,   -81,   648,   -81,    81,  -648,    81]
  K1(487,:) = [   648,     0,   -81,    81,     0,   162, -5184,     0,   648,  -648,     0, -1296,  -810,    81,   -81,    81, &
                -486, -1215,     0,  -567,     0,   162,   324, -1134]
  K1(488,:) = [     0,   648,     0,   162,   -81,    81,     0, -5184,     0, -1296,   648,  -648,     0,  -567,     0,   162, &
                 324, -1134,  -810,    81,   -81,    81,  -486, -1215]
  K1(489,:) = [   -81,     0,   648,    81,   729,  -567,   648,     0,   648,   648,  1296,     0,   648,  -648,   -81,   -81, &
                  81,    81,   567,     0,  -162,     0,  -567,   162]
  K1(490,:) = [    81,   162,    81,  -486,  -567,   324,  -648, -1296,   648, -5184,     0,     0,   -81,    81,   -81,   648, &
                  81,  -648,  -729,  -567,     0,     0,   162, -1296]
  K1(491,:) = [     0,   -81,   729,  -567,   648,    81,     0,   648,  1296,     0,   648,   648,   567,     0,  -162,     0, &
                -567,   162,   648,  -648,   -81,   -81,    81,    81]
  K1(492,:) = [   162,    81,  -567,   324,    81,  -486, -1296,  -648,     0,     0,   648, -5184,  -729,  -567,     0,     0, &
                 162, -1296,   -81,    81,   -81,   648,    81,  -648]
  K1(493,:) = [   -81,     0,   -81,   -81,  -162,     0,  -810,     0,   648,   -81,   567,  -729,   -81,   -81,  -810,   648, &
                 -81,  -810,  1134,  -162,  -324,   567,     0,     0]
  K1(494,:) = [    81,   162,   -81,   648,     0,     0,    81,  -567,  -648,    81,     0,  -567,   -81,   648,   648,   648, &
                 648,   -81,  -162,  1296,   567,   729,     0,     0]
  K1(495,:) = [  -810,     0,   648,   -81,   567,  -729,   -81,     0,   -81,   -81,  -162,     0,  -810,   648,   -81,   -81, &
                -810,   -81,  -324,   567,  1134,  -162,     0,     0]
  K1(496,:) = [    81,  -567,  -648,    81,     0,  -567,    81,   162,   -81,   648,     0,     0,   648,   648,   -81,   648, &
                 -81,   648,   567,   729,  -162,  1296,     0,     0]
  K1(497,:) = [ -1215, -1134,    81,  -648,   162, -1296,  -486,   324,    81,    81,  -567,   162,   -81,   648,  -810,   -81, &
               -5184,   648,     0,     0,     0,     0,     0,     0]
  K1(498,:) = [  -486,   324,    81,    81,  -567,   162, -1215, -1134,    81,  -648,   162, -1296,  -810,   -81,   -81,   648, &
                 648, -5184,     0,     0,     0,     0,     0,     0]
  K1(499,:) = [     0,   -81,  -162,     0,   -81,   -81,     0,  -810,   567,  -729,   648,   -81,  1134,  -162,  -324,   567, &
                   0,     0,   -81,   -81,  -810,   648,   -81,  -810]
  K1(500,:) = [   162,    81,     0,     0,   -81,   648,  -567,    81,     0,  -567,  -648,    81,  -162,  1296,   567,   729, &
                   0,     0,   -81,   648,   648,   648,   648,   -81]
  K1(501,:) = [     0,  -810,   567,  -729,   648,   -81,     0,   -81,  -162,     0,   -81,   -81,  -324,   567,  1134,  -162, &
                   0,     0,  -810,   648,   -81,   -81,  -810,   -81]
  K1(502,:) = [  -567,    81,     0,  -567,  -648,    81,   162,    81,     0,     0,   -81,   648,   567,   729,  -162,  1296, &
                   0,     0,   648,   648,   -81,   648,   -81,   648]
  K1(503,:) = [ -1134, -1215,   162, -1296,    81,  -648,   324,  -486,  -567,   162,    81,    81,     0,     0,     0,     0, &
                   0,     0,   -81,   648,  -810,   -81, -5184,   648]
  K1(504,:) = [   324,  -486,  -567,   162,    81,    81, -1134, -1215,   162, -1296,    81,  -648,     0,     0,     0,     0, &
                   0,     0,  -810,   -81,   -81,   648,   648, -5184]
  K1(505,:) = [  9216, -1152, -1152,   144,   144,  1440, -1152,   144,   144,   -18,   -18,  -180,   144,   -18,  1440,  -180, &
                1278,  1116,   -18,  -180,  -180,  1116,  1116,  -504]
  K1(506,:) = [ -1152,  9216,   144,  1440, -1152,   144,   144, -1152,   -18,  -180,   144,   -18,   -18,  -180,  -180,  1116, &
                1116,  -504,   144,   -18,  1440,  -180,  1278,  1116]
  K1(507,:) = [ -1152,   144,  9216, -1152,  1440,   144,   144,   -18,  1440,  -180,  1278,  1116, -1152,   144,   144,   -18, &
                 -18,  -180,  -180,   -18,  1116,  -504,  -180,  1116]
  K1(508,:) = [   144,  1440, -1152,  9216,   144, -1152,   -18,  -180,  -180,  1116,  1116,  -504,   144, -1152,   -18,  -180, &
                 144,   -18,   -18,   144,  1278,  1116,  1440,  -180]
  K1(509,:) = [   144, -1152,  1440,   144,  9216, -1152,   -18,   144,  1278,  1116,  1440,  -180,  -180,   -18,  1116,  -504, &
                -180,  1116, -1152,   144,   144,   -18,   -18,  -180]
  K1(510,:) = [  1440,   144,   144, -1152, -1152,  9216,  -180,   -18,  1116,  -504,  -180,  1116,   -18,   144,  1278,  1116, &
                1440,  -180,   144, -1152,   -18,  -180,   144,   -18]
  K1(511,:) = [ -1152,   144,   144,   -18,   -18,  -180,  9216, -1152, -1152,   144,   144,  1440,  1440,  -180,   144,   -18, &
                1116,  1278,  -180,  1116,   -18,  -180,  -504,  1116]
  K1(512,:) = [   144, -1152,   -18,  -180,   144,   -18, -1152,  9216,   144,  1440, -1152,   144,  -180,  1116,   -18,  -180, &
                -504,  1116,  1440,  -180,   144,   -18,  1116,  1278]
  K1(513,:) = [   144,   -18,  1440,  -180,  1278,  1116, -1152,   144,  9216, -1152,  1440,   144,   144,   -18, -1152,   144, &
                -180,   -18,  1116,  -504,  -180,   -18,  1116,  -180]
  K1(514,:) = [   -18,  -180,  -180,  1116,  1116,  -504,   144,  1440, -1152,  9216,   144, -1152,   -18,  -180,   144, -1152, &
                 -18,   144,  1278,  1116,   -18,   144,  -180,  1440]
  K1(515,:) = [   -18,   144,  1278,  1116,  1440,  -180,   144, -1152,  1440,   144,  9216, -1152,  1116,  -504,  -180,   -18, &
                1116,  -180,   144,   -18, -1152,   144,  -180,   -18]
  K1(516,:) = [  -180,   -18,  1116,  -504,  -180,  1116,  1440,   144,   144, -1152, -1152,  9216,  1278,  1116,   -18,   144, &
                -180,  1440,   -18,  -180,   144, -1152,   -18,   144]
  K1(517,:) = [   144,   -18, -1152,   144,  -180,   -18,  1440,  -180,   144,   -18,  1116,  1278,  9216, -1152, -1152,   144, &
                 144,  1440,  1116,  -180,  -504,  1116,   -18,  -180]
  K1(518,:) = [   -18,  -180,   144, -1152,   -18,   144,  -180,  1116,   -18,  -180,  -504,  1116, -1152,  9216,   144,  1440, &
               -1152,   144,  -180,  1440,  1116,  1278,   144,   -18]
  K1(519,:) = [  1440,  -180,   144,   -18,  1116,  1278,   144,   -18, -1152,   144,  -180,   -18, -1152,   144,  9216, -1152, &
                1440,   144,  -504,  1116,  1116,  -180,  -180,   -18]
  K1(520,:) = [  -180,  1116,   -18,  -180,  -504,  1116,   -18,  -180,   144, -1152,   -18,   144,   144,  1440, -1152,  9216, &
                 144, -1152,  1116,  1278,  -180,  1440,   -18,   144]
  K1(521,:) = [  1278,  1116,   -18,   144,  -180,  1440,  1116,  -504,  -180,   -18,  1116,  -180,   144, -1152,  1440,   144, &
                9216, -1152,   -18,   144,  -180,   -18, -1152,   144]
  K1(522,:) = [  1116,  -504,  -180,   -18,  1116,  -180,  1278,  1116,   -18,   144,  -180,  1440,  1440,   144,   144, -1152, &
               -1152,  9216,  -180,   -18,   -18,   144,   144, -1152]
  K1(523,:) = [   -18,   144,  -180,   -18, -1152,   144,  -180,  1440,  1116,  1278,   144,   -18,  1116,  -180,  -504,  1116, &
                 -18,  -180,  9216, -1152, -1152,   144,   144,  1440]
  K1(524,:) = [  -180,   -18,   -18,   144,   144, -1152,  1116,  -180,  -504,  1116,   -18,  -180,  -180,  1440,  1116,  1278, &
                 144,   -18, -1152,  9216,   144,  1440, -1152,   144]
  K1(525,:) = [  -180,  1440,  1116,  1278,   144,   -18,   -18,   144,  -180,   -18, -1152,   144,  -504,  1116,  1116,  -180, &
                -180,   -18, -1152,   144,  9216, -1152,  1440,   144]
  K1(526,:) = [  1116,  -180,  -504,  1116,   -18,  -180,  -180,   -18,   -18,   144,   144, -1152,  1116,  1278,  -180,  1440, &
                 -18,   144,   144,  1440, -1152,  9216,   144, -1152]
  K1(527,:) = [  1116,  1278,  -180,  1440,   -18,   144,  -504,  1116,  1116,  -180,  -180,   -18,   -18,   144,  -180,   -18, &
               -1152,   144,   144, -1152,  1440,   144,  9216, -1152]
  K1(528,:) = [  -504,  1116,  1116,  -180,  -180,   -18,  1116,  1278,  -180,  1440,   -18,   144,  -180,   -18,   -18,   144, &
                 144, -1152,  1440,   144,   144, -1152, -1152,  9216]
  K1(529,:) = [     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0, &
                   0,     0,     0,     0,     0,     0,     0,     0]
  K1(530,:) = [     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0, &
                   0,     0,     0,     0,     0,     0,     0,     0]
  K1(531,:) = [     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0, &
                   0,     0,     0,     0,     0,     0,     0,     0]
  K1(532,:) = [     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0, &
                   0,     0,     0,     0,     0,     0,     0,     0]
  K1(533,:) = [     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0, &
                   0,     0,     0,     0,     0,     0,     0,     0]
  K1(534,:) = [     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0, &
                   0,     0,     0,     0,     0,     0,     0,     0]
  K1(535,:) = [     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0, &
                   0,     0,     0,     0,     0,     0,     0,     0]
  K1(536,:) = [     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0, &
                   0,     0,     0,     0,     0,     0,     0,     0]
  K1(537,:) = [     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0, &
                   0,     0,     0,     0,     0,     0,     0,     0]
  K1(538,:) = [     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0, &
                   0,     0,     0,     0,     0,     0,     0,     0]
  K1(539,:) = [     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0, &
                   0,     0,     0,     0,     0,     0,     0,     0]
  K1(540,:) = [     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0, &
                   0,     0,     0,     0,     0,     0,     0,     0]
  K1(541,:) = [     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0, &
                   0,     0,     0,     0,     0,     0,     0,     0]
  K1(542,:) = [     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0, &
                   0,     0,     0,     0,     0,     0,     0,     0]
  K1(543,:) = [     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0, &
                   0,     0,     0,     0,     0,     0,     0,     0]
  K1(544,:) = [     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0, &
                   0,     0,     0,     0,     0,     0,     0,     0]
  K1(545,:) = [     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0, &
                   0,     0,     0,     0,     0,     0,     0,     0]
  K1(546,:) = [     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0, &
                   0,     0,     0,     0,     0,     0,     0,     0]
  K1(547,:) = [     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0, &
                   0,     0,     0,     0,     0,     0,     0,     0]
  K1(548,:) = [     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0, &
                   0,     0,     0,     0,     0,     0,     0,     0]
  K1(549,:) = [     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0, &
                   0,     0,     0,     0,     0,     0,     0,     0]
  K1(550,:) = [     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0, &
                   0,     0,     0,     0,     0,     0,     0,     0]
  K1(551,:) = [     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0, &
                   0,     0,     0,     0,     0,     0,     0,     0]
  K1(552,:) = [     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0, &
                   0,     0,     0,     0,     0,     0,     0,     0]
  K1 = (1._/**/REALKIND / 324) * K1


  end subroutine colourmatrix_init
end module ol_colourmatrix_ppttj_ttxgggg_1_/**/REALKIND



module ol_forced_parameters_ppttj_ttxgggg_1_/**/REALKIND
  implicit none
  contains
  subroutine check_forced_parameters
    use ol_parameters_decl_/**/REALKIND
    use ol_loop_parameters_decl_/**/REALKIND
#ifndef PRECISION_dp
    use ol_loop_parameters_decl_/**/DREALKIND, only: LeadingColour, nc, nf, CKMORDER
#endif
    implicit none
    logical, save :: checks_not_written = .true.

    if (checks_not_written) then
    ! e.g.
    ! if (ME /= 0) write(*,101) 'ME = 0'
  if (CKMORDER /= 0) write(*,101) 'CKMORDER = 0'
  if (nc /= 3) write(*,101) 'nc = 3'
  if (nf /= 6) write(*,101) 'nf = 6'
  if (MU /= 0) write(*,101) 'MU = 0'
  if (MD /= 0) write(*,101) 'MD = 0'
  if (MS /= 0) write(*,101) 'MS = 0'
  if (MC /= 0) write(*,101) 'MC = 0'
  if (LeadingColour /= 0) write(*,101) 'LeadingColour = 0'
  if (wMT /= 0) write(*,101) 'wMT = 0'
  if (wMT /= 0) write(*,101) 'wMT = 0'


    checks_not_written = .false.
    end if

    101 format('[OpenLoops] === WARNING ===',/,'[OpenLoops] code was generated with ',A,/,'[OpenLoops] ===============')
  end subroutine check_forced_parameters
end module ol_forced_parameters_ppttj_ttxgggg_1_/**/REALKIND

module ol_tree_ppttj_ttxgggg_1_/**/REALKIND
  use KIND_TYPES, only: REALKIND, DREALKIND, intkind1, intkind2
  implicit none
  integer,           save :: factors_status = -1
  complex(REALKIND), save :: f(2)
  complex(REALKIND), save :: den(215)
#ifdef PRECISION_dp
  integer(intkind1), save :: ntry = 1
  integer(intkind2), parameter :: nheltot = 64 ! number of helicity configurations
  integer(intkind2), save :: nhel = 64 ! number of non-vanishing helicity configurations (adapted at runtime)
  integer(intkind2), save :: Hel(64) ! physical helicity states
  complex(DREALKIND) :: M1helarr(24,64) ! cache
#endif

  contains

subroutine factors_init()
  use ol_parameters_decl_/**/REALKIND
  use ol_loop_parameters_decl_/**/REALKIND, only: loop_parameters_status
  implicit none
  factors_status = parameters_status
  ! factors of the diagrams
    f(1) = CI*gQCD**4
    f(2) = gQCD**4

end subroutine factors_init


subroutine born_denominators_init()
  use ol_parameters_decl_/**/REALKIND ! masses
  use ol_momenta_decl_/**/REALKIND, only: L
  implicit none

  ! propagators

  den(1) = 1 /((L(5,3))+L(6,3))
  den(2) = 1 /((L(5,12))+L(6,12))
  den(4) = 1 /((L(5,20))+L(6,20))
  den(6) = 1 /((L(5,36))+L(6,36))
  den(8) = 1 /((L(5,56))+L(6,56))
  den(10) = 1 /((L(5,24))+L(6,24))
  den(12) = 1 /((L(5,40))+L(6,40))
  den(14) = 1 /((L(5,52))+L(6,52))
  den(16) = 1 /((L(5,48))+L(6,48))
  den(18) = 1 /((L(5,44))+L(6,44))
  den(20) = 1 /((L(5,28))+L(6,28))
  den(22) = 1 /((L(5,5) - MT2)+L(6,5))
  den(24) = 1 /((L(5,6) - MT2)+L(6,6))
  den(26) = 1 /((L(5,9) - MT2)+L(6,9))
  den(28) = 1 /((L(5,10) - MT2)+L(6,10))
  den(30) = 1 /((L(5,17) - MT2)+L(6,17))
  den(32) = 1 /((L(5,18) - MT2)+L(6,18))
  den(34) = 1 /((L(5,33) - MT2)+L(6,33))
  den(36) = 1 /((L(5,34) - MT2)+L(6,34))
  den(39) = 1 /((L(5,19))+L(6,19))
  den(45) = 1 /((L(5,11))+L(6,11))
  den(51) = 1 /((L(5,7))+L(6,7))
  den(67) = 1 /((L(5,21) - MT2)+L(6,21))
  den(70) = 1 /((L(5,26) - MT2)+L(6,26))
  den(75) = 1 /((L(5,13) - MT2)+L(6,13))
  den(87) = 1 /((L(5,42) - MT2)+L(6,42))
  den(94) = 1 /((L(5,50) - MT2)+L(6,50))
  den(99) = 1 /((L(5,25) - MT2)+L(6,25))
  den(102) = 1 /((L(5,22) - MT2)+L(6,22))
  den(109) = 1 /((L(5,14) - MT2)+L(6,14))
  den(118) = 1 /((L(5,41) - MT2)+L(6,41))
  den(126) = 1 /((L(5,49) - MT2)+L(6,49))
  den(142) = 1 /((L(5,38) - MT2)+L(6,38))
  den(162) = 1 /((L(5,37) - MT2)+L(6,37))
  den(183) = 1 /((L(5,35))+L(6,35))

  ! denominators

  den(3) = den(1)*den(2)
  den(5) = den(1)*den(4)
  den(7) = den(1)*den(6)
  den(9) = den(1)*den(8)
  den(11) = den(1)*den(10)
  den(13) = den(1)*den(12)
  den(15) = den(1)*den(14)
  den(17) = den(1)*den(16)
  den(19) = den(1)*den(18)
  den(21) = den(1)*den(20)
  den(23) = den(8)*den(22)
  den(25) = den(8)*den(24)
  den(27) = den(14)*den(26)
  den(29) = den(14)*den(28)
  den(31) = den(18)*den(30)
  den(33) = den(18)*den(32)
  den(35) = den(20)*den(34)
  den(37) = den(20)*den(36)
  den(38) = den(3)*den(16)
  den(40) = den(1)*den(39)
  den(41) = den(2)*den(40)
  den(42) = den(2)*den(20)
  den(43) = den(1)*den(42)
  den(44) = den(5)*den(12)
  den(46) = den(1)*den(45)
  den(47) = den(4)*den(46)
  den(48) = den(4)*den(20)
  den(49) = den(1)*den(48)
  den(50) = den(7)*den(10)
  den(52) = den(1)*den(51)
  den(53) = den(10)*den(52)
  den(54) = den(10)*den(20)
  den(55) = den(1)*den(54)
  den(56) = den(6)*den(46)
  den(57) = den(6)*den(18)
  den(58) = den(1)*den(57)
  den(59) = den(12)*den(52)
  den(60) = den(12)*den(18)
  den(61) = den(1)*den(60)
  den(62) = den(16)*den(52)
  den(63) = den(14)*den(16)
  den(64) = den(1)*den(63)
  den(65) = den(22)*den(28)
  den(66) = den(16)*den(65)
  den(68) = den(22)*den(67)
  den(69) = den(28)*den(68)
  den(71) = den(28)*den(70)
  den(72) = den(22)*den(71)
  den(73) = den(22)*den(32)
  den(74) = den(12)*den(73)
  den(76) = den(22)*den(75)
  den(77) = den(32)*den(76)
  den(78) = den(32)*den(70)
  den(79) = den(22)*den(78)
  den(80) = den(22)*den(36)
  den(81) = den(10)*den(80)
  den(82) = den(22)*den(51)
  den(83) = den(10)*den(82)
  den(84) = den(10)*den(70)
  den(85) = den(22)*den(84)
  den(86) = den(36)*den(76)
  den(88) = den(36)*den(87)
  den(89) = den(22)*den(88)
  den(90) = den(12)*den(82)
  den(91) = den(12)*den(87)
  den(92) = den(22)*den(91)
  den(93) = den(16)*den(82)
  den(95) = den(16)*den(94)
  den(96) = den(22)*den(95)
  den(97) = den(24)*den(26)
  den(98) = den(16)*den(97)
  den(100) = den(26)*den(99)
  den(101) = den(24)*den(100)
  den(103) = den(24)*den(102)
  den(104) = den(26)*den(103)
  den(105) = den(24)*den(30)
  den(106) = den(12)*den(105)
  den(107) = den(30)*den(99)
  den(108) = den(24)*den(107)
  den(110) = den(24)*den(109)
  den(111) = den(30)*den(110)
  den(112) = den(24)*den(34)
  den(113) = den(10)*den(112)
  den(114) = den(24)*den(51)
  den(115) = den(10)*den(114)
  den(116) = den(10)*den(99)
  den(117) = den(24)*den(116)
  den(119) = den(34)*den(118)
  den(120) = den(24)*den(119)
  den(121) = den(34)*den(110)
  den(122) = den(12)*den(114)
  den(123) = den(12)*den(118)
  den(124) = den(24)*den(123)
  den(125) = den(16)*den(114)
  den(127) = den(16)*den(126)
  den(128) = den(24)*den(127)
  den(129) = den(26)*den(32)
  den(130) = den(6)*den(129)
  den(131) = den(26)*den(75)
  den(132) = den(32)*den(131)
  den(133) = den(32)*den(102)
  den(134) = den(26)*den(133)
  den(135) = den(26)*den(36)
  den(136) = den(4)*den(135)
  den(137) = den(26)*den(45)
  den(138) = den(4)*den(137)
  den(139) = den(4)*den(102)
  den(140) = den(26)*den(139)
  den(141) = den(36)*den(131)
  den(143) = den(36)*den(142)
  den(144) = den(26)*den(143)
  den(145) = den(6)*den(137)
  den(146) = den(6)*den(142)
  den(147) = den(26)*den(146)
  den(148) = den(16)*den(137)
  den(149) = den(26)*den(95)
  den(150) = den(28)*den(30)
  den(151) = den(6)*den(150)
  den(152) = den(30)*den(67)
  den(153) = den(28)*den(152)
  den(154) = den(28)*den(109)
  den(155) = den(30)*den(154)
  den(156) = den(28)*den(34)
  den(157) = den(4)*den(156)
  den(158) = den(28)*den(45)
  den(159) = den(4)*den(158)
  den(160) = den(4)*den(67)
  den(161) = den(28)*den(160)
  den(163) = den(34)*den(162)
  den(164) = den(28)*den(163)
  den(165) = den(34)*den(154)
  den(166) = den(6)*den(158)
  den(167) = den(6)*den(162)
  den(168) = den(28)*den(167)
  den(169) = den(16)*den(158)
  den(170) = den(28)*den(127)
  den(171) = den(30)*den(36)
  den(172) = den(2)*den(171)
  den(173) = den(30)*den(39)
  den(174) = den(2)*den(173)
  den(175) = den(2)*den(109)
  den(176) = den(30)*den(175)
  den(177) = den(32)*den(34)
  den(178) = den(2)*den(177)
  den(179) = den(32)*den(39)
  den(180) = den(2)*den(179)
  den(181) = den(2)*den(75)
  den(182) = den(32)*den(181)
  den(184) = den(34)*den(183)
  den(185) = den(2)*den(184)
  den(186) = den(34)*den(175)
  den(187) = den(36)*den(183)
  den(188) = den(2)*den(187)
  den(189) = den(36)*den(181)
  den(190) = den(16)*den(181)
  den(191) = den(2)*den(127)
  den(192) = den(36)*den(152)
  den(193) = den(30)*den(143)
  den(194) = den(6)*den(173)
  den(195) = den(30)*den(146)
  den(196) = den(12)*den(173)
  den(197) = den(30)*den(91)
  den(198) = den(32)*den(163)
  den(199) = den(34)*den(133)
  den(200) = den(6)*den(179)
  den(201) = den(32)*den(167)
  den(202) = den(12)*den(179)
  den(203) = den(32)*den(123)
  den(204) = den(4)*den(184)
  den(205) = den(34)*den(139)
  den(206) = den(4)*den(187)
  den(207) = den(36)*den(160)
  den(208) = den(12)*den(160)
  den(209) = den(4)*den(123)
  den(210) = den(10)*den(184)
  den(211) = den(34)*den(84)
  den(212) = den(10)*den(187)
  den(213) = den(36)*den(116)
  den(214) = den(10)*den(167)
  den(215) = den(6)*den(116)

end subroutine born_denominators_init


! **********************************************************************
#ifdef PRECISION_dp
subroutine amp2(P_scatt, M2, I, MOM, nextcombs, extcombs, M2munu) &
    & bind(c,name="ol_f_amp2_ppttj_ttxgggg_1")
#else
subroutine amp2(P_scatt, M2, I, MOM, nextcombs, extcombs, M2munu)
  use ol_tree_ppttj_ttxgggg_1_/**/DREALKIND, only: &
    & ntry, nhel, Hel, M1helarr
#endif
! P_scatt(0:3,Npart) = incoming external momenta
! M2  = helicity-summed squared matrix element for top anti-top glue glue glue glue -> 0
! I   = emitter, 0 means none (replace wave function I in the current crossing by the momentum MOM),
!       for I < 0 emitter for PowHeg B^mu,nu
! MOM = external "polarisation vector" for gluon emitter
! nextcombs is the length of the array extcombs
! The elements of the array extcombs specify for which external particle combinations
!   the colour correlations will be calculated. For particles i,j: i*(i-1)/2+j
!   i=j=0 -> 0 means no colour insertion.
! M2munu = Spin correlated born squared amplitude in PowHeg format B^mu,nu for emitter -I
! **********************************************************************
  use ol_parameters_decl_/**/REALKIND !, only: ci, parameters_status, ZERO, scalefactor, >masses<
  use ol_parameters_init_/**/REALKIND, only: ensure_mp_init
  use ol_init, only: tree_parameters_flush
  use ol_kinematics_/**/REALKIND, only: init_kinematics
  use ol_momenta_decl_/**/DREALKIND, only: momenta_nan_check
  use ol_momenta_decl_/**/REALKIND, only: L
  use ol_data_types_/**/REALKIND
  use ol_helicity_bookkeeping_/**/REALKIND, only: &
    & helbookkeeping_wf, helsync, flip_phase
  use ol_helicity_init, only: helbookkeeping_flip, helsync_flip
  use ol_h_propagators_/**/REALKIND
  use ol_h_wavefunctions_/**/REALKIND
  use ol_wavefunctions_/**/REALKIND, only: wf_V_Std
  use ol_h_vertices_/**/REALKIND
  use ol_h_contractions_/**/REALKIND
  use ol_external_ppttj_ttxgggg_1, only: &
    & external_perm_ppttj_ttxgggg_1, &
    & external_perm_inv_ppttj_ttxgggg_1, &
    & extcomb_perm_ppttj_ttxgggg_1, &
    & average_factor_ppttj_ttxgggg_1, &
    & photonid_ppttj_ttxgggg_1
  use ol_external_ppttj_ttxgggg_1, only: &
    & H, hel_not_initialised, hel_init, POLSEL
  use ol_colourmatrix_ppttj_ttxgggg_1_/**/REALKIND, only: &
    & colmat_not_initialised, colourmatrix_init
  use ol_forced_parameters_ppttj_ttxgggg_1_/**/REALKIND, only: &
    & check_forced_parameters
  use ol_heltables_ppttj_ttxgggg_1
  use ol_kinematics_/**/REALKIND, only: LC2Std_Rep_cmplx
  use ol_ew_renormalisation_/**/REALKIND, only: photon_factors
  implicit none

  real(DREALKIND), intent(in)  :: P_scatt(0:3,6)
  real(REALKIND),  intent(out) :: M2(0:23-1)
  real(REALKIND),  intent(out) :: M2munu(4,4)
  integer,         intent(in)  :: I
  real(REALKIND),  intent(in)  :: MOM(0:3)
  integer,         intent(in)  :: nextcombs
  integer,         intent(in)  :: extcombs(nextcombs)

  integer           :: ReplacePol, JBmunu, extcombs_permuted(nextcombs), shift, k, r, m, n
  real(REALKIND)    :: P(0:3,6)
  integer           :: extmasses2(6)
  real(REALKIND)    :: M2add(0:23-1)
  complex(REALKIND) :: M2munuadd(2)
  complex(REALKIND) :: MOM_LC(4), M1(24), M1helarray(24,64)
  real(REALKIND)    :: P_scatt_intern(0:3,6)
  complex(REALKIND) :: epLC(1:4), epStd(1:4,2)
  real(REALKIND), save :: scalebackfactor, old_scalefactor = 0, bornphotonfactor
  integer(intkind1) :: nsync

  ! type(wfun) :: ex1(h1), ex2(h2), ... ! external wave functions for h<n> helicities
  type(wfun) :: ex1(2), ex2(2), ex3(2), ex4(2), ex5(2), ex6(2)

  ! type(wfun) :: wf<h>(h,n), ... ! n wave functions with h helicity configurations
  type(wfun) :: wf4(4,23), wf8(8,100), wf16(16,33), wf64(64,159)

  type(polcont) :: A(64,159)
  complex(REALKIND) :: Aj(159)

  complex(REALKIND) :: omega(2) ! phases for helicity correlations

  call tree_parameters_flush()
  call ensure_mp_init()

  if (hel_not_initialised) call hel_init()
  if (colmat_not_initialised) call colourmatrix_init()
  if (factors_status /= parameters_status) then
    ! Note: if factors_init would only be called when parameters changed which are relevant for the factors,
    ! a different 'status' would have to be used, because check_forced_parameters should be called after every parameter change.
    call check_forced_parameters()
    call factors_init()
  end if

  if (momenta_nan_check(P_scatt) /= 0) then
    M2 = 0
    return
  end if

  extmasses2 = [ nMT, nMT, 0, 0, 0, 0 ]
  ! Convert 2 -> n-2 PS-point to n -> 0 (so that P(1) + ... + P(n) = 0) and compute
  ! internal-propagator momenta in light-cone representation
  call init_kinematics(P_scatt, extmasses2, P, &
      &  external_perm_inv_ppttj_ttxgggg_1, 6,.false.)

  ! denominators
  call born_denominators_init()

  ReplacePol = 0
  JBmunu = 0
  if (I > 0) then
    ReplacePol = external_perm_ppttj_ttxgggg_1(I)
  else if (I < 0) then
    JBmunu = external_perm_ppttj_ttxgggg_1(-I)
  end if

  do k = 1, nextcombs
    extcombs_permuted(k) = &
       & extcomb_perm_ppttj_ttxgggg_1(extcombs(k))
  end do

  if (heltables_not_init) call init_heltables()

  42 continue
  ! external WFs
  call pol_wf_Q(P(:,1), rMT, H1, ex1, POLSEL(1))
  call pol_wf_A(P(:,2), rMT, H2, ex2, POLSEL(2))
  call pol_wf_V(P(:,3), rZERO, H3, ex3, POLSEL(3))
  call pol_wf_V(P(:,4), rZERO, H4, ex4, POLSEL(4))
  call pol_wf_V(P(:,5), rZERO, H5, ex5, POLSEL(5))
  call pol_wf_V(P(:,6), rZERO, H6, ex6, POLSEL(6))


  if (ntry == 1) then
    shift = 1
    ! call helbookkeeping_flip(H1, 1, shift, eflip, exthel, firstpol)
    ! call helbookkeeping_wf(H1, ex1, shift) ...

    if (any(POLSEL /= 0)) then

      call pol_wf_Q(P(:,1), rMT, H1, ex1, 0)
      call pol_wf_A(P(:,2), rMT, H2, ex2, 0)
      call pol_wf_V(P(:,3), rZERO, H3, ex3, 0)
      call pol_wf_V(P(:,4), rZERO, H4, ex4, 0)
      call pol_wf_V(P(:,5), rZERO, H5, ex5, 0)
      call pol_wf_V(P(:,6), rZERO, H6, ex6, 0)

    end if

    call helbookkeeping_flip(H1, 1, shift, eflip, exthel, firstpol)
    call helbookkeeping_wf(H1, ex1, shift)
    call helbookkeeping_flip(H2, 2, shift, eflip, exthel, firstpol)
    call helbookkeeping_wf(H2, ex2, shift)
    call helbookkeeping_flip(H3, 3, shift, eflip, exthel, firstpol)
    call helbookkeeping_wf(H3, ex3, shift)
    call helbookkeeping_flip(H4, 4, shift, eflip, exthel, firstpol)
    call helbookkeeping_wf(H4, ex4, shift)
    call helbookkeeping_flip(H5, 5, shift, eflip, exthel, firstpol)
    call helbookkeeping_wf(H5, ex5, shift)
    call helbookkeeping_flip(H6, 6, shift, eflip, exthel, firstpol)
    call helbookkeeping_wf(H6, ex6, shift)

  end if

  ! internal WFs
  ! e.g. call vert_VQ_A(ntry, ex3, ex1, wf1, n1, t1) ...
  call vert_QA_V(ntry, ex1, ex2, wf4(:,1), n3(:,1), t3x4(:,:,1))
  call vert_UV_W(ntry, ex3, 4, ex4, 8, wf4(:,2), n3(:,2), t3x4(:,:,2))
  call vert_GGG_G(ntry, wf4(:,1), ex5, ex6, wf16(:,1), n4(:,1), t4x16(:,:,1))
  call vert_GGG_G(ntry, ex5, ex6, wf4(:,1), wf16(:,2), n4(:,2), t4x16(:,:,2))
  call vert_GGG_G(ntry, ex6, wf4(:,1), ex5, wf16(:,3), n4(:,3), t4x16(:,:,3))
  call vert_UV_W(ntry, ex3, 4, ex5, 16, wf4(:,3), n3(:,3), t3x4(:,:,3))
  call vert_GGG_G(ntry, wf4(:,1), ex4, ex6, wf16(:,4), n4(:,4), t4x16(:,:,4))
  call vert_GGG_G(ntry, ex4, ex6, wf4(:,1), wf16(:,5), n4(:,5), t4x16(:,:,5))
  call vert_GGG_G(ntry, ex6, wf4(:,1), ex4, wf16(:,6), n4(:,6), t4x16(:,:,6))
  call vert_UV_W(ntry, ex3, 4, ex6, 32, wf4(:,4), n3(:,4), t3x4(:,:,4))
  call vert_GGG_G(ntry, wf4(:,1), ex4, ex5, wf16(:,7), n4(:,7), t4x16(:,:,7))
  call vert_GGG_G(ntry, ex4, ex5, wf4(:,1), wf16(:,8), n4(:,8), t4x16(:,:,8))
  call vert_GGG_G(ntry, ex5, wf4(:,1), ex4, wf16(:,9), n4(:,9), t4x16(:,:,9))
  call vert_GGG_G(ntry, ex4, ex5, ex6, wf8(:,1), n4(:,10), t4x8(:,:,1))
  call vert_UV_W(ntry, wf4(:,1), 3, ex3, 4, wf8(:,2), n3(:,5), t3x8(:,:,1))
  call vert_GGG_G(ntry, ex5, ex6, ex4, wf8(:,3), n4(:,11), t4x8(:,:,2))
  call vert_GGG_G(ntry, ex6, ex4, ex5, wf8(:,4), n4(:,12), t4x8(:,:,3))
  call vert_UV_W(ntry, ex4, 8, ex5, 16, wf4(:,5), n3(:,6), t3x4(:,:,5))
  call vert_GGG_G(ntry, wf4(:,1), ex3, ex6, wf16(:,10), n4(:,13), t4x16(:,:,10))
  call vert_GGG_G(ntry, ex3, ex6, wf4(:,1), wf16(:,11), n4(:,14), t4x16(:,:,11))
  call vert_GGG_G(ntry, ex6, wf4(:,1), ex3, wf16(:,12), n4(:,15), t4x16(:,:,12))
  call vert_UV_W(ntry, ex4, 8, ex6, 32, wf4(:,6), n3(:,7), t3x4(:,:,6))
  call vert_GGG_G(ntry, wf4(:,1), ex3, ex5, wf16(:,13), n4(:,16), t4x16(:,:,13))
  call vert_GGG_G(ntry, ex3, ex5, wf4(:,1), wf16(:,14), n4(:,17), t4x16(:,:,14))
  call vert_GGG_G(ntry, ex5, wf4(:,1), ex3, wf16(:,15), n4(:,18), t4x16(:,:,15))
  call vert_GGG_G(ntry, ex3, ex5, ex6, wf8(:,5), n4(:,19), t4x8(:,:,4))
  call vert_UV_W(ntry, wf4(:,1), 3, ex4, 8, wf8(:,6), n3(:,8), t3x8(:,:,2))
  call vert_GGG_G(ntry, ex5, ex6, ex3, wf8(:,7), n4(:,20), t4x8(:,:,5))
  call vert_GGG_G(ntry, ex6, ex3, ex5, wf8(:,8), n4(:,21), t4x8(:,:,6))
  call vert_UV_W(ntry, ex5, 16, ex6, 32, wf4(:,7), n3(:,9), t3x4(:,:,7))
  call vert_GGG_G(ntry, wf4(:,1), ex3, ex4, wf16(:,16), n4(:,22), t4x16(:,:,16))
  call vert_GGG_G(ntry, ex3, ex4, wf4(:,1), wf16(:,17), n4(:,23), t4x16(:,:,17))
  call vert_GGG_G(ntry, ex4, wf4(:,1), ex3, wf16(:,18), n4(:,24), t4x16(:,:,18))
  call vert_GGG_G(ntry, ex3, ex4, ex6, wf8(:,9), n4(:,25), t4x8(:,:,7))
  call vert_UV_W(ntry, wf4(:,1), 3, ex5, 16, wf8(:,10), n3(:,10), t3x8(:,:,3))
  call vert_GGG_G(ntry, ex4, ex6, ex3, wf8(:,11), n4(:,26), t4x8(:,:,8))
  call vert_GGG_G(ntry, ex6, ex3, ex4, wf8(:,12), n4(:,27), t4x8(:,:,9))
  call vert_GGG_G(ntry, ex3, ex4, ex5, wf8(:,13), n4(:,28), t4x8(:,:,10))
  call vert_UV_W(ntry, wf4(:,1), 3, ex6, 32, wf8(:,14), n3(:,11), t3x8(:,:,4))
  call vert_GGG_G(ntry, ex4, ex5, ex3, wf8(:,15), n4(:,29), t4x8(:,:,11))
  call vert_GGG_G(ntry, ex5, ex3, ex4, wf8(:,16), n4(:,30), t4x8(:,:,12))
  call vert_VQ_A(ntry, ex3, ex1, wf4(:,8), n3(:,12), t3x4(:,:,8))
  call prop_Q_A(ntry, wf4(:,8), 5, MT, 1_intkind1, wf4(:,9), n2(1))
  call vert_QA_V(ntry, wf4(:,9), ex2, wf8(:,17), n3(:,13), t3x8(:,:,5))
  call vert_AV_Q(ntry, ex2, ex3, wf4(:,10), n3(:,14), t3x4(:,:,9))
  call prop_A_Q(ntry, wf4(:,10), 6, MT, 1_intkind1, wf4(:,11), n2(2))
  call vert_QA_V(ntry, ex1, wf4(:,11), wf8(:,18), n3(:,15), t3x8(:,:,6))
  call vert_VQ_A(ntry, ex4, ex1, wf4(:,12), n3(:,16), t3x4(:,:,10))
  call prop_Q_A(ntry, wf4(:,12), 9, MT, 1_intkind1, wf4(:,13), n2(3))
  call vert_QA_V(ntry, wf4(:,13), ex2, wf8(:,19), n3(:,17), t3x8(:,:,7))
  call vert_AV_Q(ntry, ex2, ex4, wf4(:,14), n3(:,18), t3x4(:,:,11))
  call prop_A_Q(ntry, wf4(:,14), 10, MT, 1_intkind1, wf4(:,15), n2(4))
  call vert_QA_V(ntry, ex1, wf4(:,15), wf8(:,20), n3(:,19), t3x8(:,:,8))
  call vert_VQ_A(ntry, ex5, ex1, wf4(:,16), n3(:,20), t3x4(:,:,12))
  call prop_Q_A(ntry, wf4(:,16), 17, MT, 1_intkind1, wf4(:,17), n2(5))
  call vert_QA_V(ntry, wf4(:,17), ex2, wf8(:,21), n3(:,21), t3x8(:,:,9))
  call vert_AV_Q(ntry, ex2, ex5, wf4(:,18), n3(:,22), t3x4(:,:,13))
  call prop_A_Q(ntry, wf4(:,18), 18, MT, 1_intkind1, wf4(:,19), n2(6))
  call vert_QA_V(ntry, ex1, wf4(:,19), wf8(:,22), n3(:,23), t3x8(:,:,10))
  call vert_VQ_A(ntry, ex6, ex1, wf4(:,20), n3(:,24), t3x4(:,:,14))
  call prop_Q_A(ntry, wf4(:,20), 33, MT, 1_intkind1, wf4(:,21), n2(7))
  call vert_QA_V(ntry, wf4(:,21), ex2, wf8(:,23), n3(:,25), t3x8(:,:,11))
  call vert_AV_Q(ntry, ex2, ex6, wf4(:,22), n3(:,26), t3x4(:,:,15))
  call prop_A_Q(ntry, wf4(:,22), 34, MT, 1_intkind1, wf4(:,23), n2(8))
  call vert_QA_V(ntry, ex1, wf4(:,23), wf8(:,24), n3(:,27), t3x8(:,:,12))
  call vert_UV_W(ntry, wf4(:,1), 3, wf4(:,2), 12, wf16(:,19), n3(:,28), t3x16(:,:,1))
  call vert_UV_W(ntry, wf4(:,2), 12, ex6, 32, wf8(:,25), n3(:,29), t3x8(:,:,13))
  call vert_UV_W(ntry, wf4(:,2), 12, ex5, 16, wf8(:,26), n3(:,30), t3x8(:,:,14))
  call vert_UV_W(ntry, wf4(:,1), 3, wf4(:,3), 20, wf16(:,20), n3(:,31), t3x16(:,:,2))
  call vert_UV_W(ntry, wf4(:,3), 20, ex6, 32, wf8(:,27), n3(:,32), t3x8(:,:,15))
  call vert_UV_W(ntry, ex4, 8, wf4(:,3), 20, wf8(:,28), n3(:,33), t3x8(:,:,16))
  call vert_UV_W(ntry, wf4(:,1), 3, wf4(:,4), 36, wf16(:,21), n3(:,34), t3x16(:,:,3))
  call vert_UV_W(ntry, wf4(:,5), 24, ex6, 32, wf8(:,29), n3(:,35), t3x8(:,:,17))
  call vert_UV_W(ntry, ex3, 4, wf4(:,5), 24, wf8(:,30), n3(:,36), t3x8(:,:,18))
  call vert_UV_W(ntry, ex5, 16, wf4(:,4), 36, wf8(:,31), n3(:,37), t3x8(:,:,19))
  call vert_UV_W(ntry, ex4, 8, wf4(:,4), 36, wf8(:,32), n3(:,38), t3x8(:,:,20))
  call vert_UV_W(ntry, ex5, 16, wf4(:,6), 40, wf8(:,33), n3(:,39), t3x8(:,:,21))
  call vert_UV_W(ntry, ex3, 4, wf4(:,6), 40, wf8(:,34), n3(:,40), t3x8(:,:,22))
  call vert_UV_W(ntry, ex4, 8, wf4(:,7), 48, wf8(:,35), n3(:,41), t3x8(:,:,23))
  call vert_UV_W(ntry, ex3, 4, wf4(:,7), 48, wf8(:,36), n3(:,42), t3x8(:,:,24))
  call vert_QA_V(ntry, wf4(:,9), wf4(:,15), wf16(:,22), n3(:,43), t3x16(:,:,4))
  call vert_VQ_A(ntry, ex5, wf4(:,9), wf8(:,37), n3(:,44), t3x8(:,:,25))
  call vert_AV_Q(ntry, wf4(:,15), ex6, wf8(:,38), n3(:,45), t3x8(:,:,26))
  call prop_Q_A(ntry, wf8(:,37), 21, MT, 1_intkind1, wf8(:,39), n2(9))
  call vert_AV_Q(ntry, wf4(:,15), ex5, wf8(:,40), n3(:,46), t3x8(:,:,27))
  call vert_VQ_A(ntry, ex6, wf4(:,9), wf8(:,41), n3(:,47), t3x8(:,:,28))
  call prop_A_Q(ntry, wf8(:,40), 26, MT, 1_intkind1, wf8(:,42), n2(10))
  call vert_QA_V(ntry, wf4(:,9), wf4(:,19), wf16(:,23), n3(:,48), t3x16(:,:,5))
  call vert_VQ_A(ntry, ex4, wf4(:,9), wf8(:,43), n3(:,49), t3x8(:,:,29))
  call vert_AV_Q(ntry, wf4(:,19), ex6, wf8(:,44), n3(:,50), t3x8(:,:,30))
  call prop_Q_A(ntry, wf8(:,43), 13, MT, 1_intkind1, wf8(:,45), n2(11))
  call vert_AV_Q(ntry, wf4(:,19), ex4, wf8(:,46), n3(:,51), t3x8(:,:,31))
  call prop_A_Q(ntry, wf8(:,46), 26, MT, 1_intkind1, wf8(:,47), n2(12))
  call vert_QA_V(ntry, wf4(:,9), wf4(:,23), wf16(:,24), n3(:,52), t3x16(:,:,6))
  call vert_AV_Q(ntry, ex2, wf4(:,5), wf8(:,48), n3(:,53), t3x8(:,:,32))
  call prop_A_Q(ntry, wf8(:,48), 26, MT, 1_intkind1, wf8(:,49), n2(13))
  call vert_AV_Q(ntry, wf4(:,23), ex5, wf8(:,50), n3(:,54), t3x8(:,:,33))
  call vert_AV_Q(ntry, wf4(:,23), ex4, wf8(:,51), n3(:,55), t3x8(:,:,34))
  call prop_A_Q(ntry, wf8(:,51), 42, MT, 1_intkind1, wf8(:,52), n2(14))
  call vert_AV_Q(ntry, ex2, wf4(:,6), wf8(:,53), n3(:,56), t3x8(:,:,35))
  call prop_A_Q(ntry, wf8(:,53), 42, MT, 1_intkind1, wf8(:,54), n2(15))
  call vert_AV_Q(ntry, ex2, wf4(:,7), wf8(:,55), n3(:,57), t3x8(:,:,36))
  call prop_A_Q(ntry, wf8(:,55), 50, MT, 1_intkind1, wf8(:,56), n2(16))
  call vert_QA_V(ntry, wf4(:,13), wf4(:,11), wf16(:,25), n3(:,58), t3x16(:,:,7))
  call vert_VQ_A(ntry, ex5, wf4(:,13), wf8(:,57), n3(:,59), t3x8(:,:,37))
  call vert_AV_Q(ntry, wf4(:,11), ex6, wf8(:,58), n3(:,60), t3x8(:,:,38))
  call prop_Q_A(ntry, wf8(:,57), 25, MT, 1_intkind1, wf8(:,59), n2(17))
  call vert_AV_Q(ntry, wf4(:,11), ex5, wf8(:,60), n3(:,61), t3x8(:,:,39))
  call vert_VQ_A(ntry, ex6, wf4(:,13), wf8(:,61), n3(:,62), t3x8(:,:,40))
  call prop_A_Q(ntry, wf8(:,60), 22, MT, 1_intkind1, wf8(:,62), n2(18))
  call vert_QA_V(ntry, wf4(:,17), wf4(:,11), wf16(:,26), n3(:,63), t3x16(:,:,8))
  call vert_VQ_A(ntry, ex4, wf4(:,17), wf8(:,63), n3(:,64), t3x8(:,:,41))
  call prop_Q_A(ntry, wf8(:,63), 25, MT, 1_intkind1, wf8(:,64), n2(19))
  call vert_AV_Q(ntry, wf4(:,11), ex4, wf8(:,65), n3(:,65), t3x8(:,:,42))
  call vert_VQ_A(ntry, ex6, wf4(:,17), wf8(:,66), n3(:,66), t3x8(:,:,43))
  call prop_A_Q(ntry, wf8(:,65), 14, MT, 1_intkind1, wf8(:,67), n2(20))
  call vert_QA_V(ntry, wf4(:,21), wf4(:,11), wf16(:,27), n3(:,67), t3x16(:,:,9))
  call vert_VQ_A(ntry, wf4(:,5), ex1, wf8(:,68), n3(:,68), t3x8(:,:,44))
  call prop_Q_A(ntry, wf8(:,68), 25, MT, 1_intkind1, wf8(:,69), n2(21))
  call vert_VQ_A(ntry, ex4, wf4(:,21), wf8(:,70), n3(:,69), t3x8(:,:,45))
  call prop_Q_A(ntry, wf8(:,70), 41, MT, 1_intkind1, wf8(:,71), n2(22))
  call vert_VQ_A(ntry, ex5, wf4(:,21), wf8(:,72), n3(:,70), t3x8(:,:,46))
  call vert_VQ_A(ntry, wf4(:,6), ex1, wf8(:,73), n3(:,71), t3x8(:,:,47))
  call prop_Q_A(ntry, wf8(:,73), 41, MT, 1_intkind1, wf8(:,74), n2(23))
  call vert_VQ_A(ntry, wf4(:,7), ex1, wf8(:,75), n3(:,72), t3x8(:,:,48))
  call prop_Q_A(ntry, wf8(:,75), 49, MT, 1_intkind1, wf8(:,76), n2(24))
  call vert_QA_V(ntry, wf4(:,13), wf4(:,19), wf16(:,28), n3(:,73), t3x16(:,:,10))
  call vert_VQ_A(ntry, ex3, wf4(:,13), wf8(:,77), n3(:,74), t3x8(:,:,49))
  call prop_Q_A(ntry, wf8(:,77), 13, MT, 1_intkind1, wf8(:,78), n2(25))
  call vert_AV_Q(ntry, wf4(:,19), ex3, wf8(:,79), n3(:,75), t3x8(:,:,50))
  call prop_A_Q(ntry, wf8(:,79), 22, MT, 1_intkind1, wf8(:,80), n2(26))
  call vert_QA_V(ntry, wf4(:,13), wf4(:,23), wf16(:,29), n3(:,76), t3x16(:,:,11))
  call vert_AV_Q(ntry, ex2, wf4(:,3), wf8(:,81), n3(:,77), t3x8(:,:,51))
  call prop_A_Q(ntry, wf8(:,81), 22, MT, 1_intkind1, wf8(:,82), n2(27))
  call vert_AV_Q(ntry, wf4(:,23), ex3, wf8(:,83), n3(:,78), t3x8(:,:,52))
  call prop_A_Q(ntry, wf8(:,83), 38, MT, 1_intkind1, wf8(:,84), n2(28))
  call vert_AV_Q(ntry, ex2, wf4(:,4), wf8(:,85), n3(:,79), t3x8(:,:,53))
  call prop_A_Q(ntry, wf8(:,85), 38, MT, 1_intkind1, wf8(:,86), n2(29))
  call vert_QA_V(ntry, wf4(:,17), wf4(:,15), wf16(:,30), n3(:,80), t3x16(:,:,12))
  call vert_VQ_A(ntry, ex3, wf4(:,17), wf8(:,87), n3(:,81), t3x8(:,:,54))
  call prop_Q_A(ntry, wf8(:,87), 21, MT, 1_intkind1, wf8(:,88), n2(30))
  call vert_AV_Q(ntry, wf4(:,15), ex3, wf8(:,89), n3(:,82), t3x8(:,:,55))
  call prop_A_Q(ntry, wf8(:,89), 14, MT, 1_intkind1, wf8(:,90), n2(31))
  call vert_QA_V(ntry, wf4(:,21), wf4(:,15), wf16(:,31), n3(:,83), t3x16(:,:,13))
  call vert_VQ_A(ntry, wf4(:,3), ex1, wf8(:,91), n3(:,84), t3x8(:,:,56))
  call prop_Q_A(ntry, wf8(:,91), 21, MT, 1_intkind1, wf8(:,92), n2(32))
  call vert_VQ_A(ntry, ex3, wf4(:,21), wf8(:,93), n3(:,85), t3x8(:,:,57))
  call prop_Q_A(ntry, wf8(:,93), 37, MT, 1_intkind1, wf8(:,94), n2(33))
  call vert_VQ_A(ntry, wf4(:,4), ex1, wf8(:,95), n3(:,86), t3x8(:,:,58))
  call prop_Q_A(ntry, wf8(:,95), 37, MT, 1_intkind1, wf8(:,96), n2(34))
  call vert_QA_V(ntry, wf4(:,17), wf4(:,23), wf16(:,32), n3(:,87), t3x16(:,:,14))
  call vert_AV_Q(ntry, ex2, wf4(:,2), wf8(:,97), n3(:,88), t3x8(:,:,59))
  call prop_A_Q(ntry, wf8(:,97), 14, MT, 1_intkind1, wf8(:,98), n2(35))
  call vert_QA_V(ntry, wf4(:,21), wf4(:,19), wf16(:,33), n3(:,89), t3x16(:,:,15))
  call vert_VQ_A(ntry, wf4(:,2), ex1, wf8(:,99), n3(:,90), t3x8(:,:,60))
  call prop_Q_A(ntry, wf8(:,99), 13, MT, 1_intkind1, wf8(:,100), n2(36))


  ! colour-stripped amplitudes
  do nsync = ntry+ntry-1, ntry+1  !  nsync = 1,2  for 1st point and nsync = 3 later
    call diagrams()
    if (nsync == 1) then
      call helsync(nsync, A, nhel, Hel)
      call helsync_flip(nsync, nhel, Hel, eflip, exthel)
      if (any(POLSEL /= 0)) then
        ntry = 2
        goto 42
      end if
    end if
  end do

  do k = 1, nhel
    call colourvector(A, k, M1helarray(:,k))
  end do
  M1helarray(:,nhel+1:) = 0
  M1helarr = M1helarray ! fill cache

  M2 = 0
  if (ReplacePol == 0) then ! no helicity correlation

    do k = 1, nhel
      call colint(M1helarray(:,k), M2add, extcombs_permuted)
      M2 = M2 + M2add
    end do

  else ! helicity correlation

    call flip_phase(P(:,ReplacePol), firstpol(ReplacePol), MOM, omega)
    do k = 1, nhel
      M1 = M1helarray(:,k)
      r = eflip(k, ReplacePol) ! Flip helicity of external particle ReplacePol (gluon emitter).
      if (r <= nhel) then      ! Only add flipped helicity configuration if it does not vanish.
        M1 = M1 + omega(exthel(k,ReplacePol)) * M1helarray(:,r)
      end if
      call colint2(M1helarray(:,k), M1, M2add, extcombs_permuted)
      M2 = M2 + M2add
    end do
    M2 = 0.5_/**/REALKIND * M2

  end if

  M2munu = 0
  if ( JBmunu /= 0 ) then ! POWHEGs Bmunu helicity correlation
    P_scatt_intern = P_scatt
    ! get wfs
    call wf_V_Std(P_scatt_intern(:,-I), rZERO, -1, epLC)
    call LC2Std_Rep_cmplx(epLC, epStd(:,1))
    call wf_V_Std(P_scatt_intern(:,-I), rZERO, 1, epLC)
    call LC2Std_Rep_cmplx(epLC, epStd(:,2))

    ! sum over helicities
    do k = 1, nhel
      !same helicity case
      call colintmunu(M1helarray(:,k), M1helarray(:,k), M2munuadd(1))
      !opposite helicity case
      r = eflip(k, JBmunu) ! Flip helicity of external particle JBmunu (gluon emitter).
      if (r <= nhel) then  ! Only add opposite helicity configuration if it does not vanish.
        call colintmunu(M1helarray(:,k), M1helarray(:,r), M2munuadd(2))
      else
        M2munuadd(2) = 0
      end if
      ! Fill B^(mu,nu) = sum_(k) sum_(l1,l2) M^*_(k) M_(k) (eps^(mu)_(l1))^* eps^(nu)_(l2)
      do m = 1,4
        do n = 1,4
          M2munu(m,n) = M2munu(m,n) + M2munuadd(1)*conjg(epStd(m,exthel(k,JBmunu)))*epStd(n,exthel(k,JBmunu))
          if (r <= nhel) then
            M2munu(m,n) = M2munu(m,n) + M2munuadd(2)*conjg(epStd(m,exthel(k,JBmunu)))*epStd(n,exthel(r,JBmunu))
          end if
        end do
      end do
    end do

    M2munu = M2munu / average_factor_ppttj_ttxgggg_1
  end if

  ! Colour and helicity average and symmetry factor of outgoing particles
  M2add = M2 / average_factor_ppttj_ttxgggg_1

  do k = 0, 23-1
    M2(k) = M2add(extcomb_perm_ppttj_ttxgggg_1(k))
  end do

  ! photon-factors
  call photon_factors(photonid_ppttj_ttxgggg_1, 0, bornphotonfactor)
  M2 = bornphotonfactor * M2
  M2munu = bornphotonfactor * M2munu

  if (ntry == 1) ntry = 2

  if (scalefactor /= old_scalefactor) then
    scalebackfactor = scalefactor**(2*6-8)
    old_scalefactor = scalefactor
  end if
  M2 = scalebackfactor * M2
  M2munu = scalebackfactor * M2munu

  contains

subroutine diagrams()
  implicit none
  ! e.g. call cont_VV(nsync, wf3, wf6, A(:,1), n64, t64, nhel, den(5)) ...

    call cont_VV(nsync, wf4(:,2), wf16(:,1), A(:,1), n3(:,91), t3x64(:,:,1), nhel, den(3))
    call cont_VV(nsync, wf4(:,2), wf16(:,2), A(:,2), n3(:,92), t3x64(:,:,2), nhel, den(3))
    call cont_VV(nsync, wf4(:,2), wf16(:,3), A(:,3), n3(:,93), t3x64(:,:,3), nhel, den(3))
    call cont_VV(nsync, wf4(:,3), wf16(:,4), A(:,4), n3(:,94), t3x64(:,:,4), nhel, den(5))
    call cont_VV(nsync, wf4(:,3), wf16(:,5), A(:,5), n3(:,95), t3x64(:,:,5), nhel, den(5))
    call cont_VV(nsync, wf4(:,3), wf16(:,6), A(:,6), n3(:,96), t3x64(:,:,6), nhel, den(5))
    call cont_VV(nsync, wf4(:,4), wf16(:,7), A(:,7), n3(:,97), t3x64(:,:,7), nhel, den(7))
    call cont_VV(nsync, wf4(:,4), wf16(:,8), A(:,8), n3(:,98), t3x64(:,:,8), nhel, den(7))
    call cont_VV(nsync, wf4(:,4), wf16(:,9), A(:,9), n3(:,99), t3x64(:,:,9), nhel, den(7))
    call cont_VV(nsync, wf8(:,1), wf8(:,2), A(:,10), n3(:,100), t3x64(:,:,10), nhel, den(9))
    call cont_VV(nsync, wf8(:,2), wf8(:,3), A(:,11), n3(:,101), t3x64(:,:,11), nhel, den(9))
    call cont_VV(nsync, wf8(:,2), wf8(:,4), A(:,12), n3(:,102), t3x64(:,:,12), nhel, den(9))
    call cont_VV(nsync, wf4(:,5), wf16(:,10), A(:,13), n3(:,103), t3x64(:,:,13), nhel, den(11))
    call cont_VV(nsync, wf4(:,5), wf16(:,11), A(:,14), n3(:,104), t3x64(:,:,14), nhel, den(11))
    call cont_VV(nsync, wf4(:,5), wf16(:,12), A(:,15), n3(:,105), t3x64(:,:,15), nhel, den(11))
    call cont_VV(nsync, wf4(:,6), wf16(:,13), A(:,16), n3(:,106), t3x64(:,:,16), nhel, den(13))
    call cont_VV(nsync, wf4(:,6), wf16(:,14), A(:,17), n3(:,107), t3x64(:,:,17), nhel, den(13))
    call cont_VV(nsync, wf4(:,6), wf16(:,15), A(:,18), n3(:,108), t3x64(:,:,18), nhel, den(13))
    call cont_VV(nsync, wf8(:,5), wf8(:,6), A(:,19), n3(:,109), t3x64(:,:,19), nhel, den(15))
    call cont_VV(nsync, wf8(:,6), wf8(:,7), A(:,20), n3(:,110), t3x64(:,:,20), nhel, den(15))
    call cont_VV(nsync, wf8(:,6), wf8(:,8), A(:,21), n3(:,111), t3x64(:,:,21), nhel, den(15))
    call cont_VV(nsync, wf4(:,7), wf16(:,16), A(:,22), n3(:,112), t3x64(:,:,22), nhel, den(17))
    call cont_VV(nsync, wf4(:,7), wf16(:,17), A(:,23), n3(:,113), t3x64(:,:,23), nhel, den(17))
    call cont_VV(nsync, wf4(:,7), wf16(:,18), A(:,24), n3(:,114), t3x64(:,:,24), nhel, den(17))
    call cont_VV(nsync, wf8(:,9), wf8(:,10), A(:,25), n3(:,115), t3x64(:,:,25), nhel, den(19))
    call cont_VV(nsync, wf8(:,10), wf8(:,11), A(:,26), n3(:,116), t3x64(:,:,26), nhel, den(19))
    call cont_VV(nsync, wf8(:,10), wf8(:,12), A(:,27), n3(:,117), t3x64(:,:,27), nhel, den(19))
    call cont_VV(nsync, wf8(:,13), wf8(:,14), A(:,28), n3(:,118), t3x64(:,:,28), nhel, den(21))
    call cont_VV(nsync, wf8(:,14), wf8(:,15), A(:,29), n3(:,119), t3x64(:,:,29), nhel, den(21))
    call cont_VV(nsync, wf8(:,14), wf8(:,16), A(:,30), n3(:,120), t3x64(:,:,30), nhel, den(21))
    call cont_VV(nsync, wf8(:,1), wf8(:,17), A(:,31), n3(:,121), t3x64(:,:,31), nhel, den(23))
    call cont_VV(nsync, wf8(:,3), wf8(:,17), A(:,32), n3(:,122), t3x64(:,:,32), nhel, den(23))
    call cont_VV(nsync, wf8(:,4), wf8(:,17), A(:,33), n3(:,123), t3x64(:,:,33), nhel, den(23))
    call cont_VV(nsync, wf8(:,1), wf8(:,18), A(:,34), n3(:,124), t3x64(:,:,34), nhel, den(25))
    call cont_VV(nsync, wf8(:,3), wf8(:,18), A(:,35), n3(:,125), t3x64(:,:,35), nhel, den(25))
    call cont_VV(nsync, wf8(:,4), wf8(:,18), A(:,36), n3(:,126), t3x64(:,:,36), nhel, den(25))
    call cont_VV(nsync, wf8(:,5), wf8(:,19), A(:,37), n3(:,127), t3x64(:,:,37), nhel, den(27))
    call cont_VV(nsync, wf8(:,7), wf8(:,19), A(:,38), n3(:,128), t3x64(:,:,38), nhel, den(27))
    call cont_VV(nsync, wf8(:,8), wf8(:,19), A(:,39), n3(:,129), t3x64(:,:,39), nhel, den(27))
    call cont_VV(nsync, wf8(:,5), wf8(:,20), A(:,40), n3(:,130), t3x64(:,:,40), nhel, den(29))
    call cont_VV(nsync, wf8(:,7), wf8(:,20), A(:,41), n3(:,131), t3x64(:,:,41), nhel, den(29))
    call cont_VV(nsync, wf8(:,8), wf8(:,20), A(:,42), n3(:,132), t3x64(:,:,42), nhel, den(29))
    call cont_VV(nsync, wf8(:,9), wf8(:,21), A(:,43), n3(:,133), t3x64(:,:,43), nhel, den(31))
    call cont_VV(nsync, wf8(:,11), wf8(:,21), A(:,44), n3(:,134), t3x64(:,:,44), nhel, den(31))
    call cont_VV(nsync, wf8(:,12), wf8(:,21), A(:,45), n3(:,135), t3x64(:,:,45), nhel, den(31))
    call cont_VV(nsync, wf8(:,9), wf8(:,22), A(:,46), n3(:,136), t3x64(:,:,46), nhel, den(33))
    call cont_VV(nsync, wf8(:,11), wf8(:,22), A(:,47), n3(:,137), t3x64(:,:,47), nhel, den(33))
    call cont_VV(nsync, wf8(:,12), wf8(:,22), A(:,48), n3(:,138), t3x64(:,:,48), nhel, den(33))
    call cont_VV(nsync, wf8(:,13), wf8(:,23), A(:,49), n3(:,139), t3x64(:,:,49), nhel, den(35))
    call cont_VV(nsync, wf8(:,15), wf8(:,23), A(:,50), n3(:,140), t3x64(:,:,50), nhel, den(35))
    call cont_VV(nsync, wf8(:,16), wf8(:,23), A(:,51), n3(:,141), t3x64(:,:,51), nhel, den(35))
    call cont_VV(nsync, wf8(:,13), wf8(:,24), A(:,52), n3(:,142), t3x64(:,:,52), nhel, den(37))
    call cont_VV(nsync, wf8(:,15), wf8(:,24), A(:,53), n3(:,143), t3x64(:,:,53), nhel, den(37))
    call cont_VV(nsync, wf8(:,16), wf8(:,24), A(:,54), n3(:,144), t3x64(:,:,54), nhel, den(37))
    call cont_VV(nsync, wf4(:,7), wf16(:,19), A(:,55), n3(:,145), t3x64(:,:,55), nhel, den(38))
    call cont_VV(nsync, wf8(:,10), wf8(:,25), A(:,56), n3(:,146), t3x64(:,:,56), nhel, den(41))
    call cont_VV(nsync, wf8(:,14), wf8(:,26), A(:,57), n3(:,147), t3x64(:,:,57), nhel, den(43))
    call cont_VV(nsync, wf4(:,6), wf16(:,20), A(:,58), n3(:,148), t3x64(:,:,58), nhel, den(44))
    call cont_VV(nsync, wf8(:,6), wf8(:,27), A(:,59), n3(:,149), t3x64(:,:,59), nhel, den(47))
    call cont_VV(nsync, wf8(:,14), wf8(:,28), A(:,60), n3(:,150), t3x64(:,:,60), nhel, den(49))
    call cont_VV(nsync, wf4(:,5), wf16(:,21), A(:,61), n3(:,151), t3x64(:,:,61), nhel, den(50))
    call cont_VV(nsync, wf8(:,2), wf8(:,29), A(:,62), n3(:,152), t3x64(:,:,62), nhel, den(53))
    call cont_VV(nsync, wf8(:,14), wf8(:,30), A(:,63), n3(:,153), t3x64(:,:,63), nhel, den(55))
    call cont_VV(nsync, wf8(:,6), wf8(:,31), A(:,64), n3(:,154), t3x64(:,:,64), nhel, den(56))
    call cont_VV(nsync, wf8(:,10), wf8(:,32), A(:,65), n3(:,155), t3x64(:,:,65), nhel, den(58))
    call cont_VV(nsync, wf8(:,2), wf8(:,33), A(:,66), n3(:,156), t3x64(:,:,66), nhel, den(59))
    call cont_VV(nsync, wf8(:,10), wf8(:,34), A(:,67), n3(:,157), t3x64(:,:,67), nhel, den(61))
    call cont_VV(nsync, wf8(:,2), wf8(:,35), A(:,68), n3(:,158), t3x64(:,:,68), nhel, den(62))
    call cont_VV(nsync, wf8(:,6), wf8(:,36), A(:,69), n3(:,159), t3x64(:,:,69), nhel, den(64))
    call cont_VV(nsync, wf4(:,7), wf16(:,22), A(:,70), n3(:,160), t3x64(:,:,70), nhel, den(66))
    call cont_QA(nsync, wf8(:,38), wf8(:,39), A(:,71), n3(:,161), t3x64(:,:,71), nhel, den(69))
    call cont_QA(nsync, wf8(:,41), wf8(:,42), A(:,72), n3(:,162), t3x64(:,:,72), nhel, den(72))
    call cont_VV(nsync, wf4(:,6), wf16(:,23), A(:,73), n3(:,163), t3x64(:,:,73), nhel, den(74))
    call cont_QA(nsync, wf8(:,44), wf8(:,45), A(:,74), n3(:,164), t3x64(:,:,74), nhel, den(77))
    call cont_QA(nsync, wf8(:,41), wf8(:,47), A(:,75), n3(:,165), t3x64(:,:,75), nhel, den(79))
    call cont_VV(nsync, wf4(:,5), wf16(:,24), A(:,76), n3(:,166), t3x64(:,:,76), nhel, den(81))
    call cont_VV(nsync, wf8(:,17), wf8(:,29), A(:,77), n3(:,167), t3x64(:,:,77), nhel, den(83))
    call cont_QA(nsync, wf8(:,41), wf8(:,49), A(:,78), n3(:,168), t3x64(:,:,78), nhel, den(85))
    call cont_QA(nsync, wf8(:,45), wf8(:,50), A(:,79), n3(:,169), t3x64(:,:,79), nhel, den(86))
    call cont_QA(nsync, wf8(:,37), wf8(:,52), A(:,80), n3(:,170), t3x64(:,:,80), nhel, den(89))
    call cont_VV(nsync, wf8(:,17), wf8(:,33), A(:,81), n3(:,171), t3x64(:,:,81), nhel, den(90))
    call cont_QA(nsync, wf8(:,37), wf8(:,54), A(:,82), n3(:,172), t3x64(:,:,82), nhel, den(92))
    call cont_VV(nsync, wf8(:,17), wf8(:,35), A(:,83), n3(:,173), t3x64(:,:,83), nhel, den(93))
    call cont_QA(nsync, wf8(:,43), wf8(:,56), A(:,84), n3(:,174), t3x64(:,:,84), nhel, den(96))
    call cont_VV(nsync, wf4(:,7), wf16(:,25), A(:,85), n3(:,175), t3x64(:,:,85), nhel, den(98))
    call cont_QA(nsync, wf8(:,58), wf8(:,59), A(:,86), n3(:,176), t3x64(:,:,86), nhel, den(101))
    call cont_QA(nsync, wf8(:,61), wf8(:,62), A(:,87), n3(:,177), t3x64(:,:,87), nhel, den(104))
    call cont_VV(nsync, wf4(:,6), wf16(:,26), A(:,88), n3(:,178), t3x64(:,:,88), nhel, den(106))
    call cont_QA(nsync, wf8(:,58), wf8(:,64), A(:,89), n3(:,179), t3x64(:,:,89), nhel, den(108))
    call cont_QA(nsync, wf8(:,66), wf8(:,67), A(:,90), n3(:,180), t3x64(:,:,90), nhel, den(111))
    call cont_VV(nsync, wf4(:,5), wf16(:,27), A(:,91), n3(:,181), t3x64(:,:,91), nhel, den(113))
    call cont_VV(nsync, wf8(:,18), wf8(:,29), A(:,92), n3(:,182), t3x64(:,:,92), nhel, den(115))
    call cont_QA(nsync, wf8(:,58), wf8(:,69), A(:,93), n3(:,183), t3x64(:,:,93), nhel, den(117))
    call cont_QA(nsync, wf8(:,60), wf8(:,71), A(:,94), n3(:,184), t3x64(:,:,94), nhel, den(120))
    call cont_QA(nsync, wf8(:,67), wf8(:,72), A(:,95), n3(:,185), t3x64(:,:,95), nhel, den(121))
    call cont_VV(nsync, wf8(:,18), wf8(:,33), A(:,96), n3(:,186), t3x64(:,:,96), nhel, den(122))
    call cont_QA(nsync, wf8(:,60), wf8(:,74), A(:,97), n3(:,187), t3x64(:,:,97), nhel, den(124))
    call cont_VV(nsync, wf8(:,18), wf8(:,35), A(:,98), n3(:,188), t3x64(:,:,98), nhel, den(125))
    call cont_QA(nsync, wf8(:,65), wf8(:,76), A(:,99), n3(:,189), t3x64(:,:,99), nhel, den(128))
    call cont_VV(nsync, wf4(:,4), wf16(:,28), A(:,100), n3(:,190), t3x64(:,:,100), nhel, den(130))
    call cont_QA(nsync, wf8(:,44), wf8(:,78), A(:,101), n3(:,191), t3x64(:,:,101), nhel, den(132))
    call cont_QA(nsync, wf8(:,61), wf8(:,80), A(:,102), n3(:,192), t3x64(:,:,102), nhel, den(134))
    call cont_VV(nsync, wf4(:,3), wf16(:,29), A(:,103), n3(:,193), t3x64(:,:,103), nhel, den(136))
    call cont_VV(nsync, wf8(:,19), wf8(:,27), A(:,104), n3(:,194), t3x64(:,:,104), nhel, den(138))
    call cont_QA(nsync, wf8(:,61), wf8(:,82), A(:,105), n3(:,195), t3x64(:,:,105), nhel, den(140))
    call cont_QA(nsync, wf8(:,50), wf8(:,78), A(:,106), n3(:,196), t3x64(:,:,106), nhel, den(141))
    call cont_QA(nsync, wf8(:,57), wf8(:,84), A(:,107), n3(:,197), t3x64(:,:,107), nhel, den(144))
    call cont_VV(nsync, wf8(:,19), wf8(:,31), A(:,108), n3(:,198), t3x64(:,:,108), nhel, den(145))
    call cont_QA(nsync, wf8(:,57), wf8(:,86), A(:,109), n3(:,199), t3x64(:,:,109), nhel, den(147))
    call cont_VV(nsync, wf8(:,19), wf8(:,36), A(:,110), n3(:,200), t3x64(:,:,110), nhel, den(148))
    call cont_QA(nsync, wf8(:,56), wf8(:,77), A(:,111), n3(:,201), t3x64(:,:,111), nhel, den(149))
    call cont_VV(nsync, wf4(:,4), wf16(:,30), A(:,112), n3(:,202), t3x64(:,:,112), nhel, den(151))
    call cont_QA(nsync, wf8(:,38), wf8(:,88), A(:,113), n3(:,203), t3x64(:,:,113), nhel, den(153))
    call cont_QA(nsync, wf8(:,66), wf8(:,90), A(:,114), n3(:,204), t3x64(:,:,114), nhel, den(155))
    call cont_VV(nsync, wf4(:,3), wf16(:,31), A(:,115), n3(:,205), t3x64(:,:,115), nhel, den(157))
    call cont_VV(nsync, wf8(:,20), wf8(:,27), A(:,116), n3(:,206), t3x64(:,:,116), nhel, den(159))
    call cont_QA(nsync, wf8(:,38), wf8(:,92), A(:,117), n3(:,207), t3x64(:,:,117), nhel, den(161))
    call cont_QA(nsync, wf8(:,40), wf8(:,94), A(:,118), n3(:,208), t3x64(:,:,118), nhel, den(164))
    call cont_QA(nsync, wf8(:,72), wf8(:,90), A(:,119), n3(:,209), t3x64(:,:,119), nhel, den(165))
    call cont_VV(nsync, wf8(:,20), wf8(:,31), A(:,120), n3(:,210), t3x64(:,:,120), nhel, den(166))
    call cont_QA(nsync, wf8(:,40), wf8(:,96), A(:,121), n3(:,211), t3x64(:,:,121), nhel, den(168))
    call cont_VV(nsync, wf8(:,20), wf8(:,36), A(:,122), n3(:,212), t3x64(:,:,122), nhel, den(169))
    call cont_QA(nsync, wf8(:,76), wf8(:,89), A(:,123), n3(:,213), t3x64(:,:,123), nhel, den(170))
    call cont_VV(nsync, wf4(:,2), wf16(:,32), A(:,124), n3(:,214), t3x64(:,:,124), nhel, den(172))
    call cont_VV(nsync, wf8(:,21), wf8(:,25), A(:,125), n3(:,215), t3x64(:,:,125), nhel, den(174))
    call cont_QA(nsync, wf8(:,66), wf8(:,98), A(:,126), n3(:,216), t3x64(:,:,126), nhel, den(176))
    call cont_VV(nsync, wf4(:,2), wf16(:,33), A(:,127), n3(:,217), t3x64(:,:,127), nhel, den(178))
    call cont_VV(nsync, wf8(:,22), wf8(:,25), A(:,128), n3(:,218), t3x64(:,:,128), nhel, den(180))
    call cont_QA(nsync, wf8(:,44), wf8(:,100), A(:,129), n3(:,219), t3x64(:,:,129), nhel, den(182))
    call cont_VV(nsync, wf8(:,23), wf8(:,26), A(:,130), n3(:,220), t3x64(:,:,130), nhel, den(185))
    call cont_QA(nsync, wf8(:,72), wf8(:,98), A(:,131), n3(:,221), t3x64(:,:,131), nhel, den(186))
    call cont_VV(nsync, wf8(:,24), wf8(:,26), A(:,132), n3(:,222), t3x64(:,:,132), nhel, den(188))
    call cont_QA(nsync, wf8(:,50), wf8(:,100), A(:,133), n3(:,223), t3x64(:,:,133), nhel, den(189))
    call cont_QA(nsync, wf8(:,55), wf8(:,100), A(:,134), n3(:,224), t3x64(:,:,134), nhel, den(190))
    call cont_QA(nsync, wf8(:,76), wf8(:,97), A(:,135), n3(:,225), t3x64(:,:,135), nhel, den(191))
    call cont_QA(nsync, wf8(:,51), wf8(:,88), A(:,136), n3(:,226), t3x64(:,:,136), nhel, den(192))
    call cont_QA(nsync, wf8(:,63), wf8(:,84), A(:,137), n3(:,227), t3x64(:,:,137), nhel, den(193))
    call cont_VV(nsync, wf8(:,21), wf8(:,32), A(:,138), n3(:,228), t3x64(:,:,138), nhel, den(194))
    call cont_QA(nsync, wf8(:,63), wf8(:,86), A(:,139), n3(:,229), t3x64(:,:,139), nhel, den(195))
    call cont_VV(nsync, wf8(:,21), wf8(:,34), A(:,140), n3(:,230), t3x64(:,:,140), nhel, den(196))
    call cont_QA(nsync, wf8(:,54), wf8(:,87), A(:,141), n3(:,231), t3x64(:,:,141), nhel, den(197))
    call cont_QA(nsync, wf8(:,46), wf8(:,94), A(:,142), n3(:,232), t3x64(:,:,142), nhel, den(198))
    call cont_QA(nsync, wf8(:,70), wf8(:,80), A(:,143), n3(:,233), t3x64(:,:,143), nhel, den(199))
    call cont_VV(nsync, wf8(:,22), wf8(:,32), A(:,144), n3(:,234), t3x64(:,:,144), nhel, den(200))
    call cont_QA(nsync, wf8(:,46), wf8(:,96), A(:,145), n3(:,235), t3x64(:,:,145), nhel, den(201))
    call cont_VV(nsync, wf8(:,22), wf8(:,34), A(:,146), n3(:,236), t3x64(:,:,146), nhel, den(202))
    call cont_QA(nsync, wf8(:,74), wf8(:,79), A(:,147), n3(:,237), t3x64(:,:,147), nhel, den(203))
    call cont_VV(nsync, wf8(:,23), wf8(:,28), A(:,148), n3(:,238), t3x64(:,:,148), nhel, den(204))
    call cont_QA(nsync, wf8(:,70), wf8(:,82), A(:,149), n3(:,239), t3x64(:,:,149), nhel, den(205))
    call cont_VV(nsync, wf8(:,24), wf8(:,28), A(:,150), n3(:,240), t3x64(:,:,150), nhel, den(206))
    call cont_QA(nsync, wf8(:,51), wf8(:,92), A(:,151), n3(:,241), t3x64(:,:,151), nhel, den(207))
    call cont_QA(nsync, wf8(:,53), wf8(:,92), A(:,152), n3(:,242), t3x64(:,:,152), nhel, den(208))
    call cont_QA(nsync, wf8(:,74), wf8(:,81), A(:,153), n3(:,243), t3x64(:,:,153), nhel, den(209))
    call cont_VV(nsync, wf8(:,23), wf8(:,30), A(:,154), n3(:,244), t3x64(:,:,154), nhel, den(210))
    call cont_QA(nsync, wf8(:,49), wf8(:,93), A(:,155), n3(:,245), t3x64(:,:,155), nhel, den(211))
    call cont_VV(nsync, wf8(:,24), wf8(:,30), A(:,156), n3(:,246), t3x64(:,:,156), nhel, den(212))
    call cont_QA(nsync, wf8(:,69), wf8(:,83), A(:,157), n3(:,247), t3x64(:,:,157), nhel, den(213))
    call cont_QA(nsync, wf8(:,48), wf8(:,96), A(:,158), n3(:,248), t3x64(:,:,158), nhel, den(214))
    call cont_QA(nsync, wf8(:,69), wf8(:,85), A(:,159), n3(:,249), t3x64(:,:,159), nhel, den(215))

end subroutine diagrams


elemental function diagmap(j, n)
  implicit none
  integer, intent(in) :: j, n
  complex(REALKIND) :: diagmap
  diagmap = A(j,n)%j
end function diagmap

function diagsum(j, pos, neg)
  implicit none
  integer, intent(in) :: j, pos(:), neg(:)
  complex(REALKIND) :: diagsum
  diagsum = sum(diagmap(j, pos)) - sum(diagmap(j, neg))
end function diagsum

subroutine colourvector(A, j, M1)
  implicit none
  type(polcont) :: A(:,:)
  integer, intent(in) :: j
  complex(REALKIND), intent(out) :: M1(24) ! M1helarray(24,64)
  integer :: empty(0)

  M1( 1) = (A(j,34)%j-A(j,35)%j+A(j,49)%j-A(j,50)%j+A(j,92)%j+A(j,95)%j+A(j,98)%j+A(j,130)%j+A(j,135)%j+A(j,154)%j)*f(1) &
        +CI*(A(j,2)%j-A(j,3)%j+A(j,10)%j-A(j,11)%j-A(j,13)%j+A(j,15)%j+A(j,22)%j-A(j,23)%j-A(j,28)%j+A(j,29)%j+A(j,55)%j-A(j,57)%j &
        +A(j,62)%j-A(j,63)%j+A(j,68)%j+A(j,91)%j+A(j,99)%j+A(j,131)%j)*f(2)
  M1( 2) = (A(j,35)%j-A(j,36)%j+A(j,43)%j-A(j,44)%j+A(j,90)%j-A(j,96)%j-A(j,98)%j+A(j,125)%j-A(j,135)%j+A(j,140)%j)*f(1) &
        +CI*(A(j,1)%j-A(j,2)%j+A(j,11)%j-A(j,12)%j-A(j,16)%j+A(j,18)%j-A(j,22)%j+A(j,23)%j-A(j,25)%j+A(j,26)%j-A(j,55)%j-A(j,56)%j &
        -A(j,66)%j-A(j,67)%j-A(j,68)%j+A(j,88)%j-A(j,99)%j+A(j,126)%j)*f(2)
  M1( 3) = (-A(j,34)%j+A(j,36)%j+A(j,50)%j-A(j,51)%j-A(j,92)%j+A(j,94)%j+A(j,96)%j-A(j,148)%j+A(j,153)%j-A(j,154)%j)*f(1) &
        +CI*(A(j,5)%j-A(j,6)%j-A(j,10)%j+A(j,12)%j+A(j,13)%j-A(j,15)%j+A(j,16)%j-A(j,17)%j-A(j,29)%j+A(j,30)%j+A(j,58)%j+A(j,60)%j &
        -A(j,62)%j+A(j,63)%j+A(j,66)%j-A(j,91)%j+A(j,97)%j+A(j,149)%j)*f(2)
  M1( 4) = (A(j,35)%j-A(j,36)%j+A(j,37)%j-A(j,38)%j+A(j,87)%j-A(j,96)%j-A(j,98)%j+A(j,104)%j+A(j,110)%j-A(j,153)%j)*f(1) &
        +CI*(A(j,4)%j-A(j,5)%j+A(j,11)%j-A(j,12)%j-A(j,16)%j+A(j,17)%j-A(j,19)%j+A(j,20)%j-A(j,22)%j+A(j,24)%j-A(j,58)%j-A(j,59)%j &
        -A(j,66)%j-A(j,68)%j-A(j,69)%j+A(j,85)%j-A(j,97)%j+A(j,105)%j)*f(2)
  M1( 5) = (-A(j,34)%j+A(j,36)%j+A(j,44)%j-A(j,45)%j+A(j,89)%j-A(j,92)%j+A(j,96)%j-A(j,138)%j-A(j,140)%j+A(j,159)%j)*f(1) &
        +CI*(A(j,8)%j-A(j,9)%j-A(j,10)%j+A(j,12)%j+A(j,13)%j-A(j,14)%j+A(j,16)%j-A(j,18)%j-A(j,26)%j+A(j,27)%j+A(j,61)%j-A(j,62)%j &
        +A(j,65)%j+A(j,66)%j+A(j,67)%j-A(j,88)%j+A(j,93)%j+A(j,139)%j)*f(2)
  M1( 6) = (A(j,34)%j-A(j,35)%j+A(j,38)%j-A(j,39)%j+A(j,86)%j+A(j,92)%j+A(j,98)%j-A(j,108)%j-A(j,110)%j-A(j,159)%j)*f(1) &
        +CI*(A(j,7)%j-A(j,8)%j+A(j,10)%j-A(j,11)%j-A(j,13)%j+A(j,14)%j-A(j,20)%j+A(j,21)%j+A(j,22)%j-A(j,24)%j-A(j,61)%j+A(j,62)%j &
        +A(j,64)%j+A(j,68)%j+A(j,69)%j-A(j,85)%j-A(j,93)%j+A(j,109)%j)*f(2)
  M1( 7) = (A(j,40)%j-A(j,41)%j-A(j,49)%j+A(j,51)%j+A(j,116)%j+A(j,119)%j+A(j,122)%j-A(j,130)%j-A(j,135)%j+A(j,148)%j)*f(1)+CI*( &
        -A(j,2)%j+A(j,3)%j-A(j,4)%j+A(j,6)%j+A(j,19)%j-A(j,20)%j+A(j,23)%j-A(j,24)%j+A(j,28)%j-A(j,30)%j-A(j,55)%j+A(j,57)%j &
        +A(j,59)%j-A(j,60)%j+A(j,69)%j+A(j,115)%j+A(j,123)%j-A(j,131)%j)*f(2)
  M1( 8) = (A(j,41)%j-A(j,42)%j-A(j,43)%j+A(j,45)%j+A(j,114)%j-A(j,120)%j-A(j,122)%j-A(j,125)%j+A(j,135)%j+A(j,138)%j)*f(1)+CI*( &
        -A(j,1)%j+A(j,2)%j-A(j,7)%j+A(j,9)%j+A(j,20)%j-A(j,21)%j-A(j,23)%j+A(j,24)%j+A(j,25)%j-A(j,27)%j+A(j,55)%j+A(j,56)%j &
        -A(j,64)%j-A(j,65)%j-A(j,69)%j+A(j,112)%j-A(j,123)%j-A(j,126)%j)*f(2)
  M1( 9) = (-A(j,40)%j+A(j,42)%j+A(j,50)%j-A(j,51)%j-A(j,116)%j+A(j,118)%j+A(j,120)%j-A(j,148)%j-A(j,154)%j+A(j,158)%j)*f(1) &
        +CI*(A(j,4)%j-A(j,6)%j+A(j,7)%j-A(j,8)%j+A(j,14)%j-A(j,15)%j-A(j,19)%j+A(j,21)%j-A(j,29)%j+A(j,30)%j-A(j,59)%j+A(j,60)%j &
        -A(j,61)%j+A(j,63)%j+A(j,64)%j-A(j,115)%j+A(j,121)%j+A(j,155)%j)*f(2)
  M1(10) = (A(j,31)%j-A(j,32)%j+A(j,41)%j-A(j,42)%j+A(j,72)%j+A(j,77)%j+A(j,83)%j-A(j,120)%j-A(j,122)%j-A(j,158)%j)*f(1)+CI*( &
        -A(j,7)%j+A(j,8)%j-A(j,10)%j+A(j,11)%j+A(j,13)%j-A(j,14)%j+A(j,20)%j-A(j,21)%j-A(j,22)%j+A(j,24)%j+A(j,61)%j-A(j,62)%j &
        -A(j,64)%j-A(j,68)%j-A(j,69)%j+A(j,70)%j+A(j,78)%j-A(j,121)%j)*f(2)
  M1(11) = (-A(j,40)%j+A(j,42)%j+A(j,44)%j-A(j,45)%j+A(j,113)%j-A(j,116)%j+A(j,120)%j-A(j,138)%j-A(j,140)%j+A(j,152)%j)*f(1) &
        +CI*(A(j,4)%j-A(j,5)%j+A(j,7)%j-A(j,9)%j+A(j,17)%j-A(j,18)%j-A(j,19)%j+A(j,21)%j-A(j,26)%j+A(j,27)%j-A(j,58)%j-A(j,59)%j &
        +A(j,64)%j+A(j,65)%j+A(j,67)%j-A(j,112)%j+A(j,117)%j+A(j,141)%j)*f(2)
  M1(12) = (A(j,32)%j-A(j,33)%j+A(j,40)%j-A(j,41)%j+A(j,71)%j-A(j,81)%j-A(j,83)%j+A(j,116)%j+A(j,122)%j-A(j,152)%j)*f(1)+CI*( &
        -A(j,4)%j+A(j,5)%j-A(j,11)%j+A(j,12)%j+A(j,16)%j-A(j,17)%j+A(j,19)%j-A(j,20)%j+A(j,22)%j-A(j,24)%j+A(j,58)%j+A(j,59)%j &
        +A(j,66)%j+A(j,68)%j+A(j,69)%j-A(j,70)%j+A(j,82)%j-A(j,117)%j)*f(2)
  M1(13) = (A(j,46)%j-A(j,47)%j-A(j,49)%j+A(j,51)%j+A(j,128)%j-A(j,130)%j+A(j,143)%j+A(j,146)%j+A(j,148)%j-A(j,153)%j)*f(1)+CI*( &
        -A(j,1)%j+A(j,3)%j-A(j,5)%j+A(j,6)%j+A(j,17)%j-A(j,18)%j+A(j,25)%j-A(j,26)%j+A(j,28)%j-A(j,30)%j+A(j,56)%j+A(j,57)%j &
        -A(j,58)%j-A(j,60)%j+A(j,67)%j+A(j,127)%j+A(j,147)%j-A(j,149)%j)*f(2)
  M1(14) = (-A(j,37)%j+A(j,39)%j+A(j,47)%j-A(j,48)%j+A(j,102)%j-A(j,104)%j+A(j,108)%j-A(j,144)%j-A(j,146)%j+A(j,153)%j)*f(1)+CI*( &
        -A(j,4)%j+A(j,5)%j-A(j,7)%j+A(j,9)%j-A(j,17)%j+A(j,18)%j+A(j,19)%j-A(j,21)%j+A(j,26)%j-A(j,27)%j+A(j,58)%j+A(j,59)%j &
        -A(j,64)%j-A(j,65)%j-A(j,67)%j+A(j,100)%j-A(j,105)%j-A(j,147)%j)*f(2)
  M1(15) = (-A(j,46)%j+A(j,48)%j+A(j,49)%j-A(j,50)%j-A(j,128)%j+A(j,130)%j+A(j,142)%j+A(j,144)%j+A(j,154)%j-A(j,158)%j)*f(1) &
        +CI*(A(j,1)%j-A(j,3)%j+A(j,8)%j-A(j,9)%j-A(j,14)%j+A(j,15)%j-A(j,25)%j+A(j,27)%j-A(j,28)%j+A(j,29)%j-A(j,56)%j-A(j,57)%j &
        +A(j,61)%j-A(j,63)%j+A(j,65)%j-A(j,127)%j+A(j,145)%j-A(j,155)%j)*f(2)
  M1(16) = (-A(j,31)%j+A(j,33)%j+A(j,47)%j-A(j,48)%j+A(j,75)%j-A(j,77)%j+A(j,81)%j-A(j,144)%j-A(j,146)%j+A(j,158)%j)*f(1)+CI*( &
        -A(j,8)%j+A(j,9)%j+A(j,10)%j-A(j,12)%j-A(j,13)%j+A(j,14)%j-A(j,16)%j+A(j,18)%j+A(j,26)%j-A(j,27)%j-A(j,61)%j+A(j,62)%j &
        -A(j,65)%j-A(j,66)%j-A(j,67)%j+A(j,73)%j-A(j,78)%j-A(j,145)%j)*f(2)
  M1(17) = (A(j,38)%j-A(j,39)%j-A(j,46)%j+A(j,48)%j+A(j,101)%j-A(j,108)%j-A(j,110)%j-A(j,128)%j+A(j,134)%j+A(j,144)%j)*f(1) &
        +CI*(A(j,1)%j-A(j,2)%j+A(j,7)%j-A(j,9)%j-A(j,20)%j+A(j,21)%j+A(j,23)%j-A(j,24)%j-A(j,25)%j+A(j,27)%j-A(j,55)%j-A(j,56)%j &
        +A(j,64)%j+A(j,65)%j+A(j,69)%j-A(j,100)%j+A(j,111)%j+A(j,129)%j)*f(2)
  M1(18) = (A(j,32)%j-A(j,33)%j+A(j,46)%j-A(j,47)%j+A(j,74)%j-A(j,81)%j-A(j,83)%j+A(j,128)%j-A(j,134)%j+A(j,146)%j)*f(1)+CI*( &
        -A(j,1)%j+A(j,2)%j-A(j,11)%j+A(j,12)%j+A(j,16)%j-A(j,18)%j+A(j,22)%j-A(j,23)%j+A(j,25)%j-A(j,26)%j+A(j,55)%j+A(j,56)%j &
        +A(j,66)%j+A(j,67)%j+A(j,68)%j-A(j,73)%j+A(j,84)%j-A(j,129)%j)*f(2)
  M1(19) = (-A(j,43)%j+A(j,45)%j+A(j,52)%j-A(j,53)%j-A(j,125)%j+A(j,132)%j+A(j,137)%j+A(j,138)%j+A(j,156)%j-A(j,159)%j)*f(1)+CI*( &
        -A(j,1)%j+A(j,3)%j-A(j,8)%j+A(j,9)%j+A(j,14)%j-A(j,15)%j+A(j,25)%j-A(j,27)%j+A(j,28)%j-A(j,29)%j+A(j,56)%j+A(j,57)%j &
        -A(j,61)%j+A(j,63)%j-A(j,65)%j+A(j,124)%j-A(j,139)%j+A(j,157)%j)*f(2)
  M1(20) = (-A(j,37)%j+A(j,39)%j+A(j,53)%j-A(j,54)%j-A(j,104)%j+A(j,107)%j+A(j,108)%j-A(j,150)%j-A(j,156)%j+A(j,159)%j)*f(1)+CI*( &
        -A(j,4)%j+A(j,6)%j-A(j,7)%j+A(j,8)%j-A(j,14)%j+A(j,15)%j+A(j,19)%j-A(j,21)%j+A(j,29)%j-A(j,30)%j+A(j,59)%j-A(j,60)%j &
        +A(j,61)%j-A(j,63)%j-A(j,64)%j+A(j,103)%j-A(j,109)%j-A(j,157)%j)*f(2)
  M1(21) = (A(j,43)%j-A(j,44)%j-A(j,52)%j+A(j,54)%j+A(j,125)%j-A(j,132)%j+A(j,136)%j+A(j,140)%j+A(j,150)%j-A(j,152)%j)*f(1) &
        +CI*(A(j,1)%j-A(j,3)%j+A(j,5)%j-A(j,6)%j-A(j,17)%j+A(j,18)%j-A(j,25)%j+A(j,26)%j-A(j,28)%j+A(j,30)%j-A(j,56)%j-A(j,57)%j &
        +A(j,58)%j+A(j,60)%j-A(j,67)%j-A(j,124)%j-A(j,141)%j+A(j,151)%j)*f(2)
  M1(22) = (-A(j,31)%j+A(j,33)%j+A(j,53)%j-A(j,54)%j-A(j,77)%j+A(j,80)%j+A(j,81)%j-A(j,150)%j+A(j,152)%j-A(j,156)%j)*f(1)+CI*( &
        -A(j,5)%j+A(j,6)%j+A(j,10)%j-A(j,12)%j-A(j,13)%j+A(j,15)%j-A(j,16)%j+A(j,17)%j+A(j,29)%j-A(j,30)%j-A(j,58)%j-A(j,60)%j &
        +A(j,62)%j-A(j,63)%j-A(j,66)%j+A(j,76)%j-A(j,82)%j-A(j,151)%j)*f(2)
  M1(23) = (A(j,37)%j-A(j,38)%j-A(j,52)%j+A(j,54)%j+A(j,104)%j+A(j,106)%j+A(j,110)%j-A(j,132)%j-A(j,134)%j+A(j,150)%j)*f(1) &
        +CI*(A(j,2)%j-A(j,3)%j+A(j,4)%j-A(j,6)%j-A(j,19)%j+A(j,20)%j-A(j,23)%j+A(j,24)%j-A(j,28)%j+A(j,30)%j+A(j,55)%j-A(j,57)%j &
        -A(j,59)%j+A(j,60)%j-A(j,69)%j-A(j,103)%j-A(j,111)%j+A(j,133)%j)*f(2)
  M1(24) = (A(j,31)%j-A(j,32)%j+A(j,52)%j-A(j,53)%j+A(j,77)%j+A(j,79)%j+A(j,83)%j+A(j,132)%j+A(j,134)%j+A(j,156)%j)*f(1)+CI*( &
        -A(j,2)%j+A(j,3)%j-A(j,10)%j+A(j,11)%j+A(j,13)%j-A(j,15)%j-A(j,22)%j+A(j,23)%j+A(j,28)%j-A(j,29)%j-A(j,55)%j+A(j,57)%j &
        -A(j,62)%j+A(j,63)%j-A(j,68)%j-A(j,76)%j-A(j,84)%j-A(j,133)%j)*f(2)

end subroutine colourvector


! **********************************************************************
subroutine colint(M, M2colint, extcombs)
! M(i)   = <M|Ci> colour component of matrix element
! COLINT = <M|M>
!        = Sum_{i,j} <M|Ci> * <Ci|Cj> * <Cj|M>
!        = colour-summed squared matrix element
! K1(i,j) = <Ci|Cj>
! M2colint is an array which contains the colour interference for each colour matrix
! The elements of the array extcombs specifies for which external particle
! combinations the colour correlations will be calculated. For particles i,j: i*(i-1)/2+j
! i=j=0 -> 0 means no colour insertion.
! **********************************************************************
  use ol_colourmatrix_ppttj_ttxgggg_1_/**/REALKIND, only: K1
  implicit none

  complex(REALKIND), intent(in)  :: M(24)
  real(REALKIND),    intent(out) :: M2colint(0:23-1)
  integer,           intent(in)  :: extcombs(:)
  integer :: extcomb, colmatpos, i, j, eco

  M2colint = 0

  do eco = 1, size(extcombs)
    extcomb = extcombs(eco)
    colmatpos = 24*extcomb
    do i = 1, 24
      do j = 1, 24
        M2colint(extcomb) = M2colint(extcomb) + real(conjg(M(i))*K1(i+colmatpos,j)*M(j))
      end do
    end do
  end do

end subroutine colint


! **********************************************************************
subroutine colint2(M1, M2, M2colint, extcombs)
! M1(i)   = <M1|Ci> colour component of matrix element
! M2(i)   = <M2|Ci> colour component of matrix element
! COLINT = <M|M>
!        = Sum_{i,j} <M1|Ci> * <Ci|Cj> * <Cj|M2>
!        = colour-summed squared matrix element
! K1(i,j) = <Ci|Cj>
! M2colint is an array which contains the colour interference for each colour matrix
! The elements of the array extcombs specifies for which external particle
! combinations the colour correlations will be calculated. For particles i,j: i*(i-1)/2+j
! i=j=0 -> 0 means no colour insertion.
! **********************************************************************
  use ol_colourmatrix_ppttj_ttxgggg_1_/**/REALKIND, only: K1
  implicit none

  complex(REALKIND), intent(in)  :: M1(24), M2(24)
  real(REALKIND),    intent(out) :: M2colint(0:23-1)
  integer,           intent(in)  :: extcombs(:)
  integer :: extcomb, colmatpos, i, j, eco

  M2colint = 0

  do eco = 1, size(extcombs)
    extcomb = extcombs(eco)
    colmatpos = 24*extcomb
    do i = 1, 24
      do j = 1, 24
        M2colint(extcomb) = M2colint(extcomb) + real(conjg(M1(i))*K1(i+colmatpos,j)*M2(j))
      end do
    end do
  end do

end subroutine colint2


! **********************************************************************
subroutine colintmunu(M1, M2, M2colint)
! M1(i)    = <M1|Ci> colour component of matrix element
! M2(i)    = <M2|Ci> colour component of matrix element
! M2colint = <M1|M2>
!          = Sum_{i,j} <M1|Ci> * <Ci|Cj> * <Cj|M2>
!          = colour-summed squared matrix element
! K1(i,j) = <Ci|Cj>
! **********************************************************************
  use ol_colourmatrix_ppttj_ttxgggg_1_/**/REALKIND, only: K1
  implicit none

  complex(REALKIND), intent(in)  :: M1(24)
  complex(REALKIND), intent(in)  :: M2(24)
  complex(REALKIND),    intent(out) :: M2colint
  integer :: i, j

  M2colint = 0

  do i = 1, 24
    do j = 1, 24
      M2colint = M2colint + M1(i)*K1(i,j)*conjg(M2(j))
    end do
  end do

end subroutine colintmunu

end subroutine amp2


#ifdef PRECISION_dp
subroutine colourvector(M1out, nhelout) &
  & bind(c,name="ol_tree_colvect_ppttj_ttxgggg_1")
  ! Retrieve M1helarr from cache. Cache must have been filled before by calling amp2().
  ! [out] M1out(:,h): colour vector for each helicity configuration h
  ! [out] nhelout: number of non-vanishing helicity configurations
  implicit none
  complex(DREALKIND) :: M1out(24,64)
  integer, intent(out) :: nhelout
  M1out = M1helarr
  nhelout = nhel
end subroutine colourvector
#endif


! =================================================== !
! Only interfaces for easier usage of AMP2_<procname> !
! =================================================== !

#ifdef PRECISION_dp
subroutine amp2tree(P, M2) &
    & bind(c,name="ol_f_amp2tree_ppttj_ttxgggg_1")
#else
subroutine amp2tree(P, M2)
#endif
  ! This is an interface for AMP2.
  ! Calculates the squared matrix element without fuss.
  implicit none
  real(DREALKIND), intent(in)  :: P(0:3,6)
  real(REALKIND),  intent(out) :: M2
  real(REALKIND) :: M2tmp(0:23-1)
  real(REALKIND) :: M2munu(4,4)
  call amp2(P, M2tmp, 0, [ 0._/**/REALKIND, 0._/**/REALKIND, 0._/**/REALKIND, 0._/**/REALKIND ], 1, [ 0 ], M2munu)
  M2 = M2tmp(0)
end subroutine amp2tree


#ifdef PRECISION_dp
subroutine amp2ccone(P, M2, I, J) &
    & bind(c,name="ol_f_amp2ccone_ppttj_ttxgggg_1")
#else
subroutine amp2ccone(P, M2, I, J)
#endif
  ! This is an interface for AMP2.
  ! Calculates the squared matrix for the colour correlation matrix for particles I and J.
  implicit none
  real(DREALKIND), intent(in)  :: P(0:3,6)
  real(REALKIND),  intent(out) :: M2
  integer,         intent(in)  :: I, J
  integer        :: extcomb
  real(REALKIND) :: M2tmp(0:23-1)
  real(REALKIND) :: M2munu(4,4)
  if (J <= I) then
    extcomb = I*(I-1)/2 + J
  else
    extcomb = J*(J-1)/2 + I
  end if
  call amp2(P, M2tmp, 0, [ 0._/**/REALKIND, 0._/**/REALKIND, 0._/**/REALKIND, 0._/**/REALKIND ], 1, [ extcomb ], M2munu)
  M2 = M2tmp(extcomb)
end subroutine amp2ccone


#ifdef PRECISION_dp
subroutine amp2ccall(P, M2) &
    & bind(c,name="ol_f_amp2ccall_ppttj_ttxgggg_1")
#else
subroutine amp2ccall(P, M2)
#endif
  ! This is an interface for AMP2.
  ! Calculates the squared matrix for all colour correlation matrices.
  ! The correlation between particles i and j is at position i*(i-1)/2+j of the array M2.
  ! M2(0) is AMP2tree
  implicit none
  real(DREALKIND), intent(in)  :: P(0:3,6)
  real(REALKIND),  intent(out) :: M2(0:23-1)
  real(REALKIND) :: M2munu(4,4)
  integer :: k
  call amp2(P, M2, 0, [ 0._/**/REALKIND, 0._/**/REALKIND, 0._/**/REALKIND, 0._/**/REALKIND ], &
    23, [ (k, k = 0, 23-1) ], M2munu)
end subroutine amp2ccall


#ifdef PRECISION_dp
subroutine amp2hcone(P, M2, I, J, MOM) &
    & bind(c,name="ol_f_amp2hcone_ppttj_ttxgggg_1")
#else
subroutine amp2hcone(P, M2, I, J, MOM)
#endif
  ! This is an interface for AMP2.
  ! Calculates the helicity correlation for emitter I with momentum MOM and spectator J
  implicit none
  real(DREALKIND), intent(in)  :: P(0:3,6)
  real(REALKIND),  intent(out) :: M2
  integer,         intent(in)  :: I, J
  real(REALKIND),  intent(in)  :: MOM(0:3)
  integer        :: extcomb
  real(REALKIND) :: M2tmp(0:23-1)
  real(REALKIND) :: M2munu(4,4)
  if (J <= I) then
    extcomb = I*(I-1)/2 + J
  else
    extcomb = J*(J-1)/2 + I
  end if
  call amp2(P, M2tmp, I, MOM, 1, [ extcomb ], M2munu)
  M2 = M2tmp(extcomb)
end subroutine amp2hcone


#ifdef PRECISION_dp
subroutine amp2hcall(P, M2, I, MOM) &
    & bind(c,name="ol_f_amp2hcall_ppttj_ttxgggg_1")
#else
subroutine amp2hcall(P, M2, I, MOM)
#endif
  ! This is an interface for AMP2.
  ! Calculates all helicity correlations for emitter I with momentum MOM.
  ! The correlator for spectator j is at position j of the array M2.
  implicit none
  real(DREALKIND), intent(in)  :: P(0:3,6)
  real(REALKIND),  intent(out) :: M2(6)
  integer,         intent(in)  :: I
  real(REALKIND),  intent(in)  :: MOM(0:3)
  real(REALKIND) :: M2tmp(0:23-1)
  real(REALKIND) :: M2munu(4,4)
  integer        :: J, extcombs(6)
  do J = 1, 6
    if (J <= I) then
      extcombs(J) = I*(I-1)/2 + J
    else
      extcombs(J) = J*(J-1)/2 + I
    end if
  end do
  call amp2(P, M2tmp, I, MOM, 6,extcombs, M2munu)
  do J = 1, 6
    M2(J) = M2tmp(extcombs(J))
  end do
end subroutine amp2hcall


#ifdef PRECISION_dp

subroutine amp2tree_c(p, m2) &
    & bind(c,name="ol_amp2tree_ppttj_ttxgggg_1")
  use, intrinsic :: iso_c_binding, only: c_double
  implicit none
  real(c_double), intent(in)  :: p(0:3,6)
  real(c_double), intent(out) :: m2
  real(DREALKIND) :: f_p(0:3,6)
  real(DREALKIND) :: f_m2
  f_p = p
  call amp2tree(f_p, f_m2)
  m2 = f_m2
end subroutine amp2tree_c

subroutine amp2ccone_c(p, m2, i, j) &
    & bind(c,name="ol_amp2ccone_ppttj_ttxgggg_1")
  use, intrinsic :: iso_c_binding, only: c_double, c_int
  implicit none
  real(c_double), intent(in)  :: p(0:3,6)
  real(c_double), intent(out) :: m2
  integer(c_int), intent(in) :: i, j
  real(DREALKIND) :: f_p(0:3,6)
  real(DREALKIND) :: f_m2
  integer :: f_i, f_j
  f_p = p
  f_i = i
  f_j = j
  call amp2ccone(f_p, f_m2, f_i, f_j)
  m2 = f_m2
end subroutine amp2ccone_c

subroutine amp2ccall_c(p, m2) &
    & bind(c,name="ol_amp2ccall_ppttj_ttxgggg_1")
  use, intrinsic :: iso_c_binding, only: c_double
  implicit none
  real(c_double), intent(in)  :: p(0:3,6)
  real(c_double), intent(out) :: m2(0:23-1)
  real(DREALKIND) :: f_p(0:3,6)
  real(DREALKIND) :: f_m2(0:23-1)
  f_p = p
  call amp2ccall(f_p, f_m2)
  m2 = f_m2
end subroutine amp2ccall_c

subroutine amp2hcone_c(p, m2, i, j, mom) &
    & bind(c,name="ol_amp2hcone_ppttj_ttxgggg_1")
  use, intrinsic :: iso_c_binding, only: c_double, c_int
  implicit none
  real(c_double), intent(in)  :: p(0:3,6)
  real(c_double), intent(out) :: m2
  integer(c_int), intent(in) :: i, j
  real(c_double), intent(in) :: mom(0:3)
  real(DREALKIND) :: f_p(0:3,6)
  real(DREALKIND) :: f_m2
  integer :: f_i, f_j
  real(DREALKIND) :: f_mom(0:3)
  f_p = p
  f_i = i
  f_j = j
  f_mom = mom
  call amp2hcone(f_p, f_m2, f_i, f_j, f_mom)
  m2 = f_m2
end subroutine amp2hcone_c

subroutine amp2hcall_c(p, m2, i, mom) &
    & bind(c,name="ol_amp2hcall_ppttj_ttxgggg_1")
  use, intrinsic :: iso_c_binding, only: c_double, c_int
  implicit none
  real(c_double), intent(in)  :: p(0:3,6)
  real(c_double), intent(out) :: m2(6)
  integer(c_int), intent(in) :: i
  real(c_double), intent(in) :: mom(0:3)
  real(DREALKIND) :: f_p(0:3,6)
  real(DREALKIND) :: f_m2(6)
  integer :: f_i
  real(DREALKIND) :: f_mom(0:3)
  f_p = p
  f_i = i
  f_mom = mom
  call amp2hcall(f_p, f_m2, f_i, f_mom)
  m2 = f_m2
end subroutine amp2hcall_c

#endif

end module ol_tree_ppttj_ttxgggg_1_/**/REALKIND
