
module ol_vamp_2_pptt_ew_ttxbbx_3_/**/REALKIND
contains

! **********************************************************************
subroutine vamp_2(M)
! P(0:3,nlegs) = incoming external momenta
! Uses tree structures 'wf', factors 'c', and denominators 'den' from loop_pptt_ew_ttxbbx_3.
! Sets colour stripped amplitudes A from the module loop_amplitudes_pptt_ew_ttxbbx_3.
! **********************************************************************
  use KIND_TYPES, only: REALKIND, QREALKIND, intkind2
  use ol_parameters_decl_/**/DREALKIND, only: l_switch
  use ol_parameters_decl_/**/QREALKIND ! masses
  use ol_vert_interface_/**/REALKIND
  use ol_prop_interface_/**/REALKIND
  use ol_last_step_/**/REALKIND
  use ol_tables_storage_pptt_ew_ttxbbx_3_/**/DREALKIND
  use ol_tensor_sum_storage_pptt_ew_ttxbbx_3_/**/REALKIND
  use ol_loop_handling_/**/REALKIND
  use ofred_reduction_/**/REALKIND, only: Hotf_4pt_reduction, Hotf_4pt_reduction_last
  use ofred_reduction_/**/REALKIND, only: Hotf_5pt_reduction, Hotf_5pt_reduction_last
  use ol_loop_reduction_/**/REALKIND, only: TI_bubble_red, TI_triangle_red

  use ol_loop_storage_pptt_ew_ttxbbx_3_/**/REALKIND
#ifndef PRECISION_dp
  use ol_loop_storage_pptt_ew_ttxbbx_3_/**/DREALKIND, only: &
    & p_switch, Hel, merge_step, merge_mism, merge_tables, merge_hels, ntryL
#endif
  use hol_initialisation_/**/REALKIND, only: G0_hol_initialisation
  use ol_h_vert_interface_/**/REALKIND
  use ol_h_prop_interface_/**/REALKIND
  use ol_h_last_step_/**/REALKIND
  use ol_merging_/**/REALKIND, only: ol_merge, ol_merge_tensors, ol_merge_last

  implicit none

  type(Hpolcont) :: Gcoeff(16)
  type(Hpolcont), intent(in) :: M(4,16)


#ifndef PRECISION_dp
  if (ntryL==1 .OR. p_switch == 1) Gcoeff(:)%hf = Hel
#else
  if (ntryL==1 .OR. p_switch == 2) Gcoeff(:)%hf = Hel
#endif

  ! =============================================
  call Hloop_QS_A(ntryL,G0H16(1),wf4(:,4),G0H4(8),ngX,m3h4x4(:,117),heltab2x16(:,:,308))
  call Hloop_Q_A(ntryL,G0H4(8),12,nML,G1H4(18),n2h4(106))
  Gcoeff(:)%j = (c(159)*M(4,:)%j) * den(10)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(309),h0tab(:,309),[12,3],[nMT,nMT],2,2,wf4(:,4),wf4(:,3))
  call Hloop_QS_A(ntryL,G0H16(1),wf4(:,4),G0H4(9),ngX,m3h4x4(:,118),heltab2x16(:,:,309))
  call Hloop_Q_A(ntryL,G0H4(9),12,nMT,G1H4(21),n2h4(107))
  Gcoeff(:)%j = (c(155)*M(4,:)%j) * den(10)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(310),h0tab(:,310),[12,3],[nMB,nMB],2,2,wf4(:,4),wf4(:,3))
  call Hloop_QS_A(ntryL,G0H16(1),wf4(:,4),G0H4(10),ngX,m3h4x4(:,119),heltab2x16(:,:,310))
  call Hloop_Q_A(ntryL,G0H4(10),12,nMB,G1H4(22),n2h4(108))
  Gcoeff(:)%j = (c(41)*M(4,:)%j) * den(9)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(311),h0tab(:,311),[12,3],[nMH,nMH],2,2,wf4(:,2),wf4(:,1))
  call Hloop_SS_S(ntryL,G0H16(1),wf4(:,2),G0H4(11),m3h4x4(:,120),heltab2x16(:,:,311))
  Gcoeff(:)%j = (c(39)*M(4,:)%j) * den(9)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(312),h0tab(:,312),[12,3],[nMZ,nMZ],2,2,wf4(:,2),wf4(:,1))
  call Hloop_SS_S(ntryL,G0H16(1),wf4(:,2),G0H4(12),m3h4x4(:,121),heltab2x16(:,:,312))
  Gcoeff(:)%j = (c(40)*M(4,:)%j) * den(9)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(313),h0tab(:,313),[12,3],[nMW,nMW],2,2,wf4(:,2),wf4(:,1))
  call Hloop_SS_S(ntryL,G0H16(1),wf4(:,2),G0H4(13),m3h4x4(:,122),heltab2x16(:,:,313))
  Gcoeff(:)%j = (c(40)*M(4,:)%j) * den(10)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(314),h0tab(:,314),[12,3],[nMH,nMZ],2,2,wf4(:,4),wf4(:,3))
  call Hloop_SS_S(ntryL,G0H16(1),wf4(:,4),G0H4(14),m3h4x4(:,123),heltab2x16(:,:,314))
  Gcoeff(:)%j = (-(c(28)*M(4,:)%j)) * den(9)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(315),h0tab(:,315),[12,3],[nMZ,nMZ],2,2,wf4(:,2),wf4(:,1))
  call Hloop_SS_S(ntryL,G0H16(1),wf4(:,2),G0H4(18),m3h4x4(:,124),heltab2x16(:,:,315))
  Gcoeff(:)%j = (-(c(26)*M(4,:)%j)) * den(9)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(316),h0tab(:,316),[12,3],[nMW,nMW],2,2,wf4(:,2),wf4(:,1))
  call Hloop_SS_S(ntryL,G0H16(1),wf4(:,2),G0H4(3),m3h4x4(:,125),heltab2x16(:,:,316))
  Gcoeff(:)%j = (-(c(26)*M(4,:)%j)) * den(9)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(317),h0tab(:,317),[12,3],[nMW,nMW],2,2,wf4(:,2),wf4(:,1))
  call Hloop_SS_S(ntryL,G0H16(1),wf4(:,2),G0H4(4),m3h4x4(:,126),heltab2x16(:,:,317))
  Gcoeff(:)%j = (c(26)*M(4,:)%j) * den(15)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(318),h0tab(:,318),[12,3],[nMW,nMW],2,2,wf4(:,4),wf4(:,1))
  call Hloop_SS_S(ntryL,G0H16(1),wf4(:,4),G0H4(5),m3h4x4(:,127),heltab2x16(:,:,318))
  Gcoeff(:)%j = (-(c(26)*M(4,:)%j)) * den(15)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(319),h0tab(:,319),[12,3],[nMW,nMW],2,2,wf4(:,4),wf4(:,1))
  call Hloop_SS_S(ntryL,G0H16(1),wf4(:,4),G0H4(6),m3h4x4(:,128),heltab2x16(:,:,319))
  Gcoeff(:)%j = (-(c(26)*M(4,:)%j)) * den(16)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(320),h0tab(:,320),[12,3],[nMW,nMW],2,2,wf4(:,2),wf4(:,3))
  call Hloop_SS_S(ntryL,G0H16(1),wf4(:,2),G0H4(15),m3h4x4(:,129),heltab2x16(:,:,320))
  Gcoeff(:)%j = (c(26)*M(4,:)%j) * den(16)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(321),h0tab(:,321),[12,3],[nMW,nMW],2,2,wf4(:,2),wf4(:,3))
  call Hloop_SS_S(ntryL,G0H16(1),wf4(:,2),G0H4(16),m3h4x4(:,130),heltab2x16(:,:,321))
  Gcoeff(:)%j = (c(26)*M(4,:)%j) * den(10)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(322),h0tab(:,322),[12,3],[nMW,nMW],2,2,wf4(:,4),wf4(:,3))
  call Hloop_SS_S(ntryL,G0H16(1),wf4(:,4),G0H4(17),m3h4x4(:,131),heltab2x16(:,:,322))
  Gcoeff(:)%j = (c(26)*M(4,:)%j) * den(10)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(323),h0tab(:,323),[12,3],[nMW,nMW],2,2,wf4(:,4),wf4(:,3))
  call Hloop_SS_S(ntryL,G0H16(1),wf4(:,4),G0H4(22),m3h4x4(:,132),heltab2x16(:,:,323))
  Gcoeff(:)%j = (c(29)*M(4,:)%j) * den(9)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(324),h0tab(:,324),[12,3],[nMZ,nMZ],2,2,wf4(:,2),wf4(:,1))
  call Hloop_VS_V(ntryL,G0H16(1),wf4(:,2),G0H4(20),m3h4x4(:,133),heltab2x16(:,:,324))
  Gcoeff(:)%j = (c(27)*M(4,:)%j) * den(9)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(325),h0tab(:,325),[12,3],[nMW,nMW],2,2,wf4(:,2),wf4(:,1))
  call Hloop_VS_V(ntryL,G0H16(1),wf4(:,2),G0H4(21),m3h4x4(:,134),heltab2x16(:,:,325))
  Gcoeff(:)%j = (c(55)*M(4,:)%j) * den(9)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(326),h0tab(:,326),[12,3],[nMZ,nMZ],2,2,wf4(:,2),wf4(:,1))
  call Hloop_VT_S(ntryL,G0H16(1),0,wf4(:,2),12,G1H4(11),m3h4x4(:,135),heltab2x16(:,:,326))
  Gcoeff(:)%j = (c(53)*M(4,:)%j) * den(9)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(327),h0tab(:,327),[12,3],[nMW,nMW],2,2,wf4(:,2),wf4(:,1))
  call Hloop_VT_S(ntryL,G0H16(1),0,wf4(:,2),12,G1H4(17),m3h4x4(:,136),heltab2x16(:,:,327))
  Gcoeff(:)%j = (c(53)*M(4,:)%j) * den(9)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(328),h0tab(:,328),[12,3],[nMW,nMW],2,2,wf4(:,2),wf4(:,1))
  call Hloop_VT_S(ntryL,G0H16(1),0,wf4(:,2),12,G1H4(55),m3h4x4(:,137),heltab2x16(:,:,328))
  Gcoeff(:)%j = (-(c(53)*M(4,:)%j)) * den(15)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(329),h0tab(:,329),[12,3],[nMW,nMW],2,2,wf4(:,4),wf4(:,1))
  call Hloop_VT_S(ntryL,G0H16(1),0,wf4(:,4),12,G1H4(56),m3h4x4(:,138),heltab2x16(:,:,329))
  Gcoeff(:)%j = (c(53)*M(4,:)%j) * den(15)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(330),h0tab(:,330),[12,3],[nMW,nMW],2,2,wf4(:,4),wf4(:,1))
  call Hloop_VT_S(ntryL,G0H16(1),0,wf4(:,4),12,G1H4(57),m3h4x4(:,139),heltab2x16(:,:,330))
  Gcoeff(:)%j = (-(c(53)*M(4,:)%j)) * den(16)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(331),h0tab(:,331),[12,3],[nMW,nMW],2,2,wf4(:,2),wf4(:,3))
  call Hloop_VT_S(ntryL,G0H16(1),0,wf4(:,2),12,G1H4(61),m3h4x4(:,140),heltab2x16(:,:,331))
  Gcoeff(:)%j = (c(53)*M(4,:)%j) * den(16)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(332),h0tab(:,332),[12,3],[nMW,nMW],2,2,wf4(:,2),wf4(:,3))
  call Hloop_VT_S(ntryL,G0H16(1),0,wf4(:,2),12,G1H4(59),m3h4x4(:,141),heltab2x16(:,:,332))
  Gcoeff(:)%j = (c(55)*M(4,:)%j) * den(10)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(333),h0tab(:,333),[12,3],[nMH,nMZ],2,2,wf4(:,4),wf4(:,3))
  call Hloop_VS_T(ntryL,G0H16(1),0,wf4(:,4),12,G1H4(60),m3h4x4(:,142),heltab2x16(:,:,333))
  Gcoeff(:)%j = (c(53)*M(4,:)%j) * den(10)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(334),h0tab(:,334),[12,3],[nMW,nMW],2,2,wf4(:,4),wf4(:,3))
  call Hloop_VT_S(ntryL,G0H16(1),0,wf4(:,4),12,G1H4(70),m3h4x4(:,143),heltab2x16(:,:,334))
  Gcoeff(:)%j = (c(53)*M(4,:)%j) * den(10)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(335),h0tab(:,335),[12,3],[nMW,nMW],2,2,wf4(:,4),wf4(:,3))
  call Hloop_VT_S(ntryL,G0H16(1),0,wf4(:,4),12,G1H4(71),m3h4x4(:,144),heltab2x16(:,:,335))
  Gcoeff(:)%j = (c(175)*M(4,:)%j) * den(17)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(336),h0tab(:,336),[12,3],[nME,nME],2,2,wf4(:,6),wf4(:,1))
  call Hloop_QV_A(ntryL,G0H16(1),wf4(:,6),G0H4(25),m3h4x4(:,145),heltab2x16(:,:,336))
  call Hloop_Q_A(ntryL,G0H4(25),12,nME,G1H4(72),n2h4(109))
  Gcoeff(:)%j = (c(179)*M(4,:)%j) * den(17)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(337),h0tab(:,337),[12,3],[nMM,nMM],2,2,wf4(:,6),wf4(:,1))
  call Hloop_QV_A(ntryL,G0H16(1),wf4(:,6),G0H4(23),m3h4x4(:,146),heltab2x16(:,:,337))
  call Hloop_Q_A(ntryL,G0H4(23),12,nMM,G1H4(39),n2h4(110))
  Gcoeff(:)%j = (c(177)*M(4,:)%j) * den(17)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(338),h0tab(:,338),[12,3],[nML,nML],2,2,wf4(:,6),wf4(:,1))
  call Hloop_QV_A(ntryL,G0H16(1),wf4(:,6),G0H4(24),m3h4x4(:,147),heltab2x16(:,:,338))
  call Hloop_Q_A(ntryL,G0H4(24),12,nML,G1H4(42),n2h4(111))
  Gcoeff(:)%j = (-(c(181)*M(4,:)%j)) * den(17)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(339),h0tab(:,339),[12,3],[nMT,nMT],2,2,wf4(:,6),wf4(:,1))
  call Hloop_QV_A(ntryL,G0H16(1),wf4(:,6),G0H4(19),m3h4x4(:,148),heltab2x16(:,:,339))
  call Hloop_Q_A(ntryL,G0H4(19),12,nMT,G1H4(41),n2h4(112))
  Gcoeff(:)%j = (c(172)*M(4,:)%j) * den(17)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(340),h0tab(:,340),[12,3],[nMB,nMB],2,2,wf4(:,6),wf4(:,1))
  call Hloop_QV_A(ntryL,G0H16(1),wf4(:,6),G0H4(1),m3h4x4(:,149),heltab2x16(:,:,340))
  call Hloop_Q_A(ntryL,G0H4(1),12,nMB,G1H4(43),n2h4(113))
  Gcoeff(:)%j = (c(176)*M(4,:)%j) * den(15)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(341),h0tab(:,341),[12,3],[nME,nME],2,2,wf4(:,8),wf4(:,1))
  call Hloop_QZ_A(ntryL,G0H16(1),wf4(:,8),G0H4(2),ngZl,m3h4x4(:,150),heltab2x16(:,:,341))
  call Hloop_Q_A(ntryL,G0H4(2),12,nME,G1H4(46),n2h4(114))
  Gcoeff(:)%j = (c(180)*M(4,:)%j) * den(15)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(342),h0tab(:,342),[12,3],[nMM,nMM],2,2,wf4(:,8),wf4(:,1))
  call Hloop_QZ_A(ntryL,G0H16(1),wf4(:,8),G0H4(7),ngZl,m3h4x4(:,151),heltab2x16(:,:,342))
  call Hloop_Q_A(ntryL,G0H4(7),12,nMM,G1H4(45),n2h4(115))
  Gcoeff(:)%j = (c(178)*M(4,:)%j) * den(15)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(343),h0tab(:,343),[12,3],[nML,nML],2,2,wf4(:,8),wf4(:,1))
  call Hloop_QZ_A(ntryL,G0H16(1),wf4(:,8),G0H4(8),ngZl,m3h4x4(:,152),heltab2x16(:,:,343))
  call Hloop_Q_A(ntryL,G0H4(8),12,nML,G1H4(74),n2h4(116))
  Gcoeff(:)%j = (c(182)*M(4,:)%j) * den(15)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(344),h0tab(:,344),[12,3],[nMT,nMT],2,2,wf4(:,8),wf4(:,1))
  call Hloop_QZ_A(ntryL,G0H16(1),wf4(:,8),G0H4(9),ngZu,m3h4x4(:,153),heltab2x16(:,:,344))
  call Hloop_Q_A(ntryL,G0H4(9),12,nMT,G1H4(4),n2h4(117))
  Gcoeff(:)%j = (c(174)*M(4,:)%j) * den(15)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(345),h0tab(:,345),[12,3],[nMB,nMB],2,2,wf4(:,8),wf4(:,1))
  call Hloop_QZ_A(ntryL,G0H16(1),wf4(:,8),G0H4(10),ngZd,m3h4x4(:,154),heltab2x16(:,:,345))
  call Hloop_Q_A(ntryL,G0H4(10),12,nMB,G1H4(69),n2h4(118))
  Gcoeff(:)%j = (c(175)*M(4,:)%j) * den(11)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(346),h0tab(:,346),[12,3],[nME,nME],2,2,wf4(:,6),wf4(:,3))
  call Hloop_QV_A(ntryL,G0H16(1),wf4(:,6),G0H4(25),m3h4x4(:,155),heltab2x16(:,:,346))
  call Hloop_Q_A(ntryL,G0H4(25),12,nME,G1H4(2),n2h4(119))
  Gcoeff(:)%j = (c(179)*M(4,:)%j) * den(11)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(347),h0tab(:,347),[12,3],[nMM,nMM],2,2,wf4(:,6),wf4(:,3))
  call Hloop_QV_A(ntryL,G0H16(1),wf4(:,6),G0H4(23),m3h4x4(:,156),heltab2x16(:,:,347))
  call Hloop_Q_A(ntryL,G0H4(23),12,nMM,G1H4(12),n2h4(120))
  Gcoeff(:)%j = (c(177)*M(4,:)%j) * den(11)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(348),h0tab(:,348),[12,3],[nML,nML],2,2,wf4(:,6),wf4(:,3))
  call Hloop_QV_A(ntryL,G0H16(1),wf4(:,6),G0H4(24),m3h4x4(:,157),heltab2x16(:,:,348))
  call Hloop_Q_A(ntryL,G0H4(24),12,nML,G1H4(13),n2h4(121))
  Gcoeff(:)%j = (c(181)*M(4,:)%j) * den(11)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(349),h0tab(:,349),[12,3],[nMT,nMT],2,2,wf4(:,6),wf4(:,3))
  call Hloop_QV_A(ntryL,G0H16(1),wf4(:,6),G0H4(19),m3h4x4(:,158),heltab2x16(:,:,349))
  call Hloop_Q_A(ntryL,G0H4(19),12,nMT,G1H4(14),n2h4(122))
  Gcoeff(:)%j = (c(172)*M(4,:)%j) * den(11)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(350),h0tab(:,350),[12,3],[nMB,nMB],2,2,wf4(:,6),wf4(:,3))
  call Hloop_QV_A(ntryL,G0H16(1),wf4(:,6),G0H4(1),m3h4x4(:,159),heltab2x16(:,:,350))
  call Hloop_Q_A(ntryL,G0H4(1),12,nMB,G1H4(5),n2h4(123))
  Gcoeff(:)%j = (c(176)*M(4,:)%j) * den(10)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(351),h0tab(:,351),[12,3],[nME,nME],2,2,wf4(:,8),wf4(:,3))
  call Hloop_QZ_A(ntryL,G0H16(1),wf4(:,8),G0H4(2),ngZl,m3h4x4(:,160),heltab2x16(:,:,351))
  call Hloop_Q_A(ntryL,G0H4(2),12,nME,G1H4(52),n2h4(124))
  Gcoeff(:)%j = (c(180)*M(4,:)%j) * den(10)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(352),h0tab(:,352),[12,3],[nMM,nMM],2,2,wf4(:,8),wf4(:,3))
  call Hloop_QZ_A(ntryL,G0H16(1),wf4(:,8),G0H4(7),ngZl,m3h4x4(:,161),heltab2x16(:,:,352))
  call Hloop_Q_A(ntryL,G0H4(7),12,nMM,G1H4(49),n2h4(125))
  Gcoeff(:)%j = (c(178)*M(4,:)%j) * den(10)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(353),h0tab(:,353),[12,3],[nML,nML],2,2,wf4(:,8),wf4(:,3))
  call Hloop_QZ_A(ntryL,G0H16(1),wf4(:,8),G0H4(8),ngZl,m3h4x4(:,162),heltab2x16(:,:,353))
  call Hloop_Q_A(ntryL,G0H4(8),12,nML,G1H4(26),n2h4(126))
  Gcoeff(:)%j = (-(c(182)*M(4,:)%j)) * den(10)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(354),h0tab(:,354),[12,3],[nMT,nMT],2,2,wf4(:,8),wf4(:,3))
  call Hloop_QZ_A(ntryL,G0H16(1),wf4(:,8),G0H4(9),ngZu,m3h4x4(:,163),heltab2x16(:,:,354))
  call Hloop_Q_A(ntryL,G0H4(9),12,nMT,G1H4(35),n2h4(127))
  Gcoeff(:)%j = (c(174)*M(4,:)%j) * den(10)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(355),h0tab(:,355),[12,3],[nMB,nMB],2,2,wf4(:,8),wf4(:,3))
  call Hloop_QZ_A(ntryL,G0H16(1),wf4(:,8),G0H4(10),ngZd,m3h4x4(:,164),heltab2x16(:,:,355))
  call Hloop_Q_A(ntryL,G0H4(10),12,nMB,G1H4(53),n2h4(128))
  Gcoeff(:)%j = (c(108)*M(4,:)%j) * den(17)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(356),h0tab(:,356),[12,3],[nMW,nMW],2,2,wf4(:,6),wf4(:,1))
  call Hloop_TV_S(ntryL,G0H16(1),0,wf4(:,6),12,G1H4(50),m3h4x4(:,165),heltab2x16(:,:,356))
  Gcoeff(:)%j = (c(129)*M(4,:)%j) * den(15)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(357),h0tab(:,357),[12,3],[nMW,nMW],2,2,wf4(:,8),wf4(:,1))
  call Hloop_TV_S(ntryL,G0H16(1),0,wf4(:,8),12,G1H4(27),m3h4x4(:,166),heltab2x16(:,:,357))
  Gcoeff(:)%j = (-(c(68)*M(4,:)%j)) * den(10)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(358),h0tab(:,358),[12,3],[nMH,nMZ],2,2,wf4(:,8),wf4(:,3))
  call Hloop_SV_T(ntryL,G0H16(1),0,wf4(:,8),12,G1H4(36),m3h4x4(:,167),heltab2x16(:,:,358))
  Gcoeff(:)%j = (c(84)*M(4,:)%j) * den(17)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(359),h0tab(:,359),[12,3],[nMW,nMW],2,2,wf4(:,6),wf4(:,1))
  call Hloop_CV_D(ntryL,G0H16(1),0,wf4(:,6),12,G1H4(54),m3h4x4(:,168),heltab2x16(:,:,359))
  Gcoeff(:)%j = (-(c(84)*M(4,:)%j)) * den(17)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(360),h0tab(:,360),[12,3],[nMW,nMW],2,2,wf4(:,6),wf4(:,1))
  call Hloop_CV_D(ntryL,G0H16(1),0,wf4(:,6),12,G1H4(51),m3h4x4(:,169),heltab2x16(:,:,360))
  Gcoeff(:)%j = (-(c(63)*M(4,:)%j)) * den(15)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(361),h0tab(:,361),[12,3],[nMW,nMW],2,2,wf4(:,8),wf4(:,1))
  call Hloop_CV_D(ntryL,G0H16(1),0,wf4(:,8),12,G1H4(28),m3h4x4(:,170),heltab2x16(:,:,361))
  Gcoeff(:)%j = (c(63)*M(4,:)%j) * den(15)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(362),h0tab(:,362),[12,3],[nMW,nMW],2,2,wf4(:,8),wf4(:,1))
  call Hloop_CV_D(ntryL,G0H16(1),0,wf4(:,8),12,G1H4(25),m3h4x4(:,171),heltab2x16(:,:,362))
  Gcoeff(:)%j = (c(84)*M(4,:)%j) * den(11)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(363),h0tab(:,363),[12,3],[nMW,nMW],2,2,wf4(:,6),wf4(:,3))
  call Hloop_CV_D(ntryL,G0H16(1),0,wf4(:,6),12,G1H4(58),m3h4x4(:,172),heltab2x16(:,:,363))
  Gcoeff(:)%j = (c(84)*M(4,:)%j) * den(11)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(364),h0tab(:,364),[12,3],[nMW,nMW],2,2,wf4(:,6),wf4(:,3))
  call Hloop_CV_D(ntryL,G0H16(1),0,wf4(:,6),12,G1H4(48),m3h4x4(:,173),heltab2x16(:,:,364))
  Gcoeff(:)%j = (-(c(63)*M(4,:)%j)) * den(10)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(365),h0tab(:,365),[12,3],[nMW,nMW],2,2,wf4(:,8),wf4(:,3))
  call Hloop_CV_D(ntryL,G0H16(1),0,wf4(:,8),12,G1H4(66),m3h4x4(:,174),heltab2x16(:,:,365))
  Gcoeff(:)%j = (-(c(63)*M(4,:)%j)) * den(10)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(366),h0tab(:,366),[12,3],[nMW,nMW],2,2,wf4(:,8),wf4(:,3))
  call Hloop_CV_D(ntryL,G0H16(1),0,wf4(:,8),12,G1H4(65),m3h4x4(:,175),heltab2x16(:,:,366))
  Gcoeff(:)%j = (c(85)*M(4,:)%j) * den(17)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(367),h0tab(:,367),[12,3],[nMW,nMW],2,2,wf4(:,6),wf4(:,1))
  call Hloop_UV_W(ntryL,G0H16(1),0,wf4(:,6),12,G1H4(62),m3h4x4(:,176),heltab2x16(:,:,367))
  Gcoeff(:)%j = (-(c(64)*M(4,:)%j)) * den(15)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(368),h0tab(:,368),[12,3],[nMW,nMW],2,2,wf4(:,8),wf4(:,1))
  call Hloop_UV_W(ntryL,G0H16(1),0,wf4(:,8),12,G1H4(38),m3h4x4(:,177),heltab2x16(:,:,368))
  Gcoeff(:)%j = (-(c(84)*M(4,:)%j)) * den(17)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(369),h0tab(:,369),[12,3],[nMW,nMW],2,2,wf4(:,6),wf4(:,1))
  call Hloop_VV_S(ntryL,G0H16(1),wf4(:,6),G0H4(25),m3h4x4(:,178),heltab2x16(:,:,369))
  Gcoeff(:)%j = (c(84)*M(4,:)%j) * den(17)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(370),h0tab(:,370),[12,3],[nMW,nMW],2,2,wf4(:,6),wf4(:,1))
  call Hloop_VV_S(ntryL,G0H16(1),wf4(:,6),G0H4(23),m3h4x4(:,179),heltab2x16(:,:,370))
  Gcoeff(:)%j = (-(c(119)*M(4,:)%j)) * den(15)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(371),h0tab(:,371),[12,3],[nMW,nMW],2,2,wf4(:,8),wf4(:,1))
  call Hloop_VV_S(ntryL,G0H16(1),wf4(:,8),G0H4(24),m3h4x4(:,180),heltab2x16(:,:,371))
  Gcoeff(:)%j = (c(119)*M(4,:)%j) * den(15)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(372),h0tab(:,372),[12,3],[nMW,nMW],2,2,wf4(:,8),wf4(:,1))
  call Hloop_VV_S(ntryL,G0H16(1),wf4(:,8),G0H4(19),m3h4x4(:,181),heltab2x16(:,:,372))
  Gcoeff(:)%j = (c(84)*M(4,:)%j) * den(11)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(373),h0tab(:,373),[12,3],[nMW,nMW],2,2,wf4(:,6),wf4(:,3))
  call Hloop_VV_S(ntryL,G0H16(1),wf4(:,6),G0H4(1),m3h4x4(:,182),heltab2x16(:,:,373))
  Gcoeff(:)%j = (c(84)*M(4,:)%j) * den(11)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(374),h0tab(:,374),[12,3],[nMW,nMW],2,2,wf4(:,6),wf4(:,3))
  call Hloop_VV_S(ntryL,G0H16(1),wf4(:,6),G0H4(2),m3h4x4(:,183),heltab2x16(:,:,374))
  Gcoeff(:)%j = (-(c(62)*M(4,:)%j)) * den(10)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(375),h0tab(:,375),[12,3],[nMH,nMZ],2,2,wf4(:,8),wf4(:,3))
  call Hloop_VV_S(ntryL,G0H16(1),wf4(:,8),G0H4(7),m3h4x4(:,184),heltab2x16(:,:,375))
  Gcoeff(:)%j = (c(119)*M(4,:)%j) * den(10)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(376),h0tab(:,376),[12,3],[nMW,nMW],2,2,wf4(:,8),wf4(:,3))
  call Hloop_VV_S(ntryL,G0H16(1),wf4(:,8),G0H4(8),m3h4x4(:,185),heltab2x16(:,:,376))
  Gcoeff(:)%j = (c(119)*M(4,:)%j) * den(10)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(377),h0tab(:,377),[12,3],[nMW,nMW],2,2,wf4(:,8),wf4(:,3))
  call Hloop_VV_S(ntryL,G0H16(1),wf4(:,8),G0H4(9),m3h4x4(:,186),heltab2x16(:,:,377))
  Gcoeff(:)%j = (-(c(166)*M(4,:)%j)) * den(18)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(378),h0tab(:,378),[12,3],[nME,nME],2,2,wf4(:,2),wf4(:,5))
  call Hloop_QS_A(ntryL,G0H16(1),wf4(:,2),G0H4(10),ngH,m3h4x4(:,187),heltab2x16(:,:,378))
  call Hloop_Q_A(ntryL,G0H4(10),12,nME,G1H4(33),n2h4(129))
  Gcoeff(:)%j = (-(c(170)*M(4,:)%j)) * den(18)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(379),h0tab(:,379),[12,3],[nMM,nMM],2,2,wf4(:,2),wf4(:,5))
  call Hloop_QS_A(ntryL,G0H16(1),wf4(:,2),G0H4(10),ngH,m3h4x4(:,188),heltab2x16(:,:,379))
  call Hloop_Q_A(ntryL,G0H4(10),12,nMM,G1H4(29),n2h4(130))
  Gcoeff(:)%j = (-(c(168)*M(4,:)%j)) * den(18)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(380),h0tab(:,380),[12,3],[nML,nML],2,2,wf4(:,2),wf4(:,5))
  call Hloop_QS_A(ntryL,G0H16(1),wf4(:,2),G0H4(10),ngH,m3h4x4(:,189),heltab2x16(:,:,380))
  call Hloop_Q_A(ntryL,G0H4(10),12,nML,G1H4(67),n2h4(131))
  Gcoeff(:)%j = (c(173)*M(4,:)%j) * den(18)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(381),h0tab(:,381),[12,3],[nMT,nMT],2,2,wf4(:,2),wf4(:,5))
  call Hloop_QS_A(ntryL,G0H16(1),wf4(:,2),G0H4(10),ngH,m3h4x4(:,190),heltab2x16(:,:,381))
  call Hloop_Q_A(ntryL,G0H4(10),12,nMT,G1H4(63),n2h4(132))
  Gcoeff(:)%j = (-(c(164)*M(4,:)%j)) * den(18)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(382),h0tab(:,382),[12,3],[nMB,nMB],2,2,wf4(:,2),wf4(:,5))
  call Hloop_QS_A(ntryL,G0H16(1),wf4(:,2),G0H4(10),ngH,m3h4x4(:,191),heltab2x16(:,:,382))
  call Hloop_Q_A(ntryL,G0H4(10),12,nMB,G1H4(34),n2h4(133))
  Gcoeff(:)%j = (c(166)*M(4,:)%j) * den(12)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(383),h0tab(:,383),[12,3],[nME,nME],2,2,wf4(:,4),wf4(:,5))
  call Hloop_QS_A(ntryL,G0H16(1),wf4(:,4),G0H4(10),ngX,m3h4x4(:,192),heltab2x16(:,:,383))
  call Hloop_Q_A(ntryL,G0H4(10),12,nME,G1H4(47),n2h4(134))
  Gcoeff(:)%j = (c(170)*M(4,:)%j) * den(12)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(384),h0tab(:,384),[12,3],[nMM,nMM],2,2,wf4(:,4),wf4(:,5))
  call Hloop_QS_A(ntryL,G0H16(1),wf4(:,4),G0H4(10),ngX,m3h4x4(:,193),heltab2x16(:,:,384))
  call Hloop_Q_A(ntryL,G0H4(10),12,nMM,G1H4(68),n2h4(135))
  Gcoeff(:)%j = (c(168)*M(4,:)%j) * den(12)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(385),h0tab(:,385),[12,3],[nML,nML],2,2,wf4(:,4),wf4(:,5))
  call Hloop_QS_A(ntryL,G0H16(1),wf4(:,4),G0H4(10),ngX,m3h4x4(:,194),heltab2x16(:,:,385))
  call Hloop_Q_A(ntryL,G0H4(10),12,nML,G1H4(64),n2h4(136))
  Gcoeff(:)%j = (c(173)*M(4,:)%j) * den(12)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(386),h0tab(:,386),[12,3],[nMT,nMT],2,2,wf4(:,4),wf4(:,5))
  call Hloop_QS_A(ntryL,G0H16(1),wf4(:,4),G0H4(10),ngX,m3h4x4(:,195),heltab2x16(:,:,386))
  call Hloop_Q_A(ntryL,G0H4(10),12,nMT,G1H4(37),n2h4(137))
  Gcoeff(:)%j = (c(164)*M(4,:)%j) * den(12)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(387),h0tab(:,387),[12,3],[nMB,nMB],2,2,wf4(:,4),wf4(:,5))
  call Hloop_QS_A(ntryL,G0H16(1),wf4(:,4),G0H4(10),ngX,m3h4x4(:,196),heltab2x16(:,:,387))
  call Hloop_Q_A(ntryL,G0H4(10),12,nMB,G1H4(31),n2h4(138))
  Gcoeff(:)%j = (c(167)*M(4,:)%j) * den(16)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(388),h0tab(:,388),[12,3],[nME,nME],2,2,wf4(:,2),wf4(:,7))
  call Hloop_QS_A(ntryL,G0H16(1),wf4(:,2),G0H4(10),ngH,m3h4x4(:,197),heltab2x16(:,:,388))
  call Hloop_Q_A(ntryL,G0H4(10),12,nME,G1H4(40),n2h4(139))
  Gcoeff(:)%j = (c(171)*M(4,:)%j) * den(16)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(389),h0tab(:,389),[12,3],[nMM,nMM],2,2,wf4(:,2),wf4(:,7))
  call Hloop_QS_A(ntryL,G0H16(1),wf4(:,2),G0H4(10),ngH,m3h4x4(:,198),heltab2x16(:,:,389))
  call Hloop_Q_A(ntryL,G0H4(10),12,nMM,G1H4(75),n2h4(140))
  Gcoeff(:)%j = (c(169)*M(4,:)%j) * den(16)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(390),h0tab(:,390),[12,3],[nML,nML],2,2,wf4(:,2),wf4(:,7))
  call Hloop_QS_A(ntryL,G0H16(1),wf4(:,2),G0H4(10),ngH,m3h4x4(:,199),heltab2x16(:,:,390))
  call Hloop_Q_A(ntryL,G0H4(10),12,nML,G1H4(76),n2h4(141))
  Gcoeff(:)%j = (c(174)*M(4,:)%j) * den(16)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(391),h0tab(:,391),[12,3],[nMT,nMT],2,2,wf4(:,2),wf4(:,7))
  call Hloop_QS_A(ntryL,G0H16(1),wf4(:,2),G0H4(10),ngH,m3h4x4(:,200),heltab2x16(:,:,391))
  call Hloop_Q_A(ntryL,G0H4(10),12,nMT,G1H4(77),n2h4(142))
  Gcoeff(:)%j = (c(165)*M(4,:)%j) * den(16)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(392),h0tab(:,392),[12,3],[nMB,nMB],2,2,wf4(:,2),wf4(:,7))
  call Hloop_QS_A(ntryL,G0H16(1),wf4(:,2),G0H4(10),ngH,m3h4x4(:,201),heltab2x16(:,:,392))
  call Hloop_Q_A(ntryL,G0H4(10),12,nMB,G1H4(78),n2h4(143))
  Gcoeff(:)%j = (-(c(167)*M(4,:)%j)) * den(10)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(393),h0tab(:,393),[12,3],[nME,nME],2,2,wf4(:,4),wf4(:,7))
  call Hloop_QS_A(ntryL,G0H16(1),wf4(:,4),G0H4(10),ngX,m3h4x4(:,202),heltab2x16(:,:,393))
  call Hloop_Q_A(ntryL,G0H4(10),12,nME,G1H4(79),n2h4(144))
  Gcoeff(:)%j = (-(c(171)*M(4,:)%j)) * den(10)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(394),h0tab(:,394),[12,3],[nMM,nMM],2,2,wf4(:,4),wf4(:,7))
  call Hloop_QS_A(ntryL,G0H16(1),wf4(:,4),G0H4(10),ngX,m3h4x4(:,203),heltab2x16(:,:,394))
  call Hloop_Q_A(ntryL,G0H4(10),12,nMM,G1H4(80),n2h4(145))
  Gcoeff(:)%j = (-(c(169)*M(4,:)%j)) * den(10)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(395),h0tab(:,395),[12,3],[nML,nML],2,2,wf4(:,4),wf4(:,7))
  call Hloop_QS_A(ntryL,G0H16(1),wf4(:,4),G0H4(10),ngX,m3h4x4(:,204),heltab2x16(:,:,395))
  call Hloop_Q_A(ntryL,G0H4(10),12,nML,G1H4(81),n2h4(146))
  Gcoeff(:)%j = (c(174)*M(4,:)%j) * den(10)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(396),h0tab(:,396),[12,3],[nMT,nMT],2,2,wf4(:,4),wf4(:,7))
  call Hloop_QS_A(ntryL,G0H16(1),wf4(:,4),G0H4(10),ngX,m3h4x4(:,205),heltab2x16(:,:,396))
  call Hloop_Q_A(ntryL,G0H4(10),12,nMT,G1H4(82),n2h4(147))
  Gcoeff(:)%j = (-(c(165)*M(4,:)%j)) * den(10)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(397),h0tab(:,397),[12,3],[nMB,nMB],2,2,wf4(:,4),wf4(:,7))
  call Hloop_QS_A(ntryL,G0H16(1),wf4(:,4),G0H4(10),ngX,m3h4x4(:,206),heltab2x16(:,:,397))
  call Hloop_Q_A(ntryL,G0H4(10),12,nMB,G1H4(83),n2h4(148))
  Gcoeff(:)%j = (-(c(100)*M(4,:)%j)) * den(18)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(398),h0tab(:,398),[12,3],[nMW,nMW],2,2,wf4(:,2),wf4(:,5))
  call Hloop_SS_S(ntryL,G0H16(1),wf4(:,2),G0H4(10),m3h4x4(:,207),heltab2x16(:,:,398))
  Gcoeff(:)%j = (c(128)*M(4,:)%j) * den(16)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(399),h0tab(:,399),[12,3],[nMW,nMW],2,2,wf4(:,2),wf4(:,7))
  call Hloop_SS_S(ntryL,G0H16(1),wf4(:,2),G0H4(26),m3h4x4(:,208),heltab2x16(:,:,399))
  Gcoeff(:)%j = (c(66)*M(4,:)%j) * den(10)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(400),h0tab(:,400),[12,3],[nMH,nMZ],2,2,wf4(:,4),wf4(:,7))
  call Hloop_SS_S(ntryL,G0H16(1),wf4(:,4),G0H4(27),m3h4x4(:,209),heltab2x16(:,:,400))
  Gcoeff(:)%j = (-(c(81)*M(4,:)%j)) * den(18)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(401),h0tab(:,401),[12,3],[nMW,nMW],2,2,wf4(:,2),wf4(:,5))
  call Hloop_SS_S(ntryL,G0H16(1),wf4(:,2),G0H4(28),m3h4x4(:,210),heltab2x16(:,:,401))
  Gcoeff(:)%j = (c(81)*M(4,:)%j) * den(18)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(402),h0tab(:,402),[12,3],[nMW,nMW],2,2,wf4(:,2),wf4(:,5))
  call Hloop_SS_S(ntryL,G0H16(1),wf4(:,2),G0H4(29),m3h4x4(:,211),heltab2x16(:,:,402))
  Gcoeff(:)%j = (c(81)*M(4,:)%j) * den(12)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(403),h0tab(:,403),[12,3],[nMW,nMW],2,2,wf4(:,4),wf4(:,5))
  call Hloop_SS_S(ntryL,G0H16(1),wf4(:,4),G0H4(30),m3h4x4(:,212),heltab2x16(:,:,403))
  Gcoeff(:)%j = (c(81)*M(4,:)%j) * den(12)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(404),h0tab(:,404),[12,3],[nMW,nMW],2,2,wf4(:,4),wf4(:,5))
  call Hloop_SS_S(ntryL,G0H16(1),wf4(:,4),G0H4(31),m3h4x4(:,213),heltab2x16(:,:,404))
  Gcoeff(:)%j = (-(c(60)*M(4,:)%j)) * den(16)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(405),h0tab(:,405),[12,3],[nMW,nMW],2,2,wf4(:,2),wf4(:,7))
  call Hloop_SS_S(ntryL,G0H16(1),wf4(:,2),G0H4(32),m3h4x4(:,214),heltab2x16(:,:,405))
  Gcoeff(:)%j = (c(60)*M(4,:)%j) * den(16)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(406),h0tab(:,406),[12,3],[nMW,nMW],2,2,wf4(:,2),wf4(:,7))
  call Hloop_SS_S(ntryL,G0H16(1),wf4(:,2),G0H4(33),m3h4x4(:,215),heltab2x16(:,:,406))
  Gcoeff(:)%j = (c(60)*M(4,:)%j) * den(10)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(407),h0tab(:,407),[12,3],[nMW,nMW],2,2,wf4(:,4),wf4(:,7))
  call Hloop_SS_S(ntryL,G0H16(1),wf4(:,4),G0H4(34),m3h4x4(:,216),heltab2x16(:,:,407))
  Gcoeff(:)%j = (c(60)*M(4,:)%j) * den(10)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(408),h0tab(:,408),[12,3],[nMW,nMW],2,2,wf4(:,4),wf4(:,7))
  call Hloop_SS_S(ntryL,G0H16(1),wf4(:,4),G0H4(35),m3h4x4(:,217),heltab2x16(:,:,408))
  Gcoeff(:)%j = (-(c(82)*M(4,:)%j)) * den(18)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(409),h0tab(:,409),[12,3],[nMW,nMW],2,2,wf4(:,2),wf4(:,5))
  call Hloop_VS_V(ntryL,G0H16(1),wf4(:,2),G0H4(36),m3h4x4(:,218),heltab2x16(:,:,409))
  Gcoeff(:)%j = (-(c(61)*M(4,:)%j)) * den(16)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(410),h0tab(:,410),[12,3],[nMW,nMW],2,2,wf4(:,2),wf4(:,7))
  call Hloop_VS_V(ntryL,G0H16(1),wf4(:,2),G0H4(37),m3h4x4(:,219),heltab2x16(:,:,410))
  Gcoeff(:)%j = (-(c(81)*M(4,:)%j)) * den(18)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(411),h0tab(:,411),[12,3],[nMW,nMW],2,2,wf4(:,2),wf4(:,5))
  call Hloop_VT_S(ntryL,G0H16(1),0,wf4(:,2),12,G1H4(84),m3h4x4(:,220),heltab2x16(:,:,411))
  Gcoeff(:)%j = (c(81)*M(4,:)%j) * den(18)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(412),h0tab(:,412),[12,3],[nMW,nMW],2,2,wf4(:,2),wf4(:,5))
  call Hloop_VT_S(ntryL,G0H16(1),0,wf4(:,2),12,G1H4(85),m3h4x4(:,221),heltab2x16(:,:,412))
  Gcoeff(:)%j = (c(81)*M(4,:)%j) * den(12)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(413),h0tab(:,413),[12,3],[nMW,nMW],2,2,wf4(:,4),wf4(:,5))
  call Hloop_VT_S(ntryL,G0H16(1),0,wf4(:,4),12,G1H4(86),m3h4x4(:,222),heltab2x16(:,:,413))
  Gcoeff(:)%j = (c(81)*M(4,:)%j) * den(12)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(414),h0tab(:,414),[12,3],[nMW,nMW],2,2,wf4(:,4),wf4(:,5))
  call Hloop_VT_S(ntryL,G0H16(1),0,wf4(:,4),12,G1H4(87),m3h4x4(:,223),heltab2x16(:,:,414))
  Gcoeff(:)%j = (c(118)*M(4,:)%j) * den(16)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(415),h0tab(:,415),[12,3],[nMW,nMW],2,2,wf4(:,2),wf4(:,7))
  call Hloop_VT_S(ntryL,G0H16(1),0,wf4(:,2),12,G1H4(88),m3h4x4(:,224),heltab2x16(:,:,415))
  Gcoeff(:)%j = (-(c(118)*M(4,:)%j)) * den(16)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(416),h0tab(:,416),[12,3],[nMW,nMW],2,2,wf4(:,2),wf4(:,7))
  call Hloop_VT_S(ntryL,G0H16(1),0,wf4(:,2),12,G1H4(89),m3h4x4(:,225),heltab2x16(:,:,416))
  Gcoeff(:)%j = (c(59)*M(4,:)%j) * den(10)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(417),h0tab(:,417),[12,3],[nMH,nMZ],2,2,wf4(:,4),wf4(:,7))
  call Hloop_VS_T(ntryL,G0H16(1),0,wf4(:,4),12,G1H4(90),m3h4x4(:,226),heltab2x16(:,:,417))
  Gcoeff(:)%j = (-(c(118)*M(4,:)%j)) * den(10)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(418),h0tab(:,418),[12,3],[nMW,nMW],2,2,wf4(:,4),wf4(:,7))
  call Hloop_VT_S(ntryL,G0H16(1),0,wf4(:,4),12,G1H4(91),m3h4x4(:,227),heltab2x16(:,:,418))
  Gcoeff(:)%j = (-(c(118)*M(4,:)%j)) * den(10)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(419),h0tab(:,419),[12,3],[nMW,nMW],2,2,wf4(:,4),wf4(:,7))
  call Hloop_VT_S(ntryL,G0H16(1),0,wf4(:,4),12,G1H4(92),m3h4x4(:,228),heltab2x16(:,:,419))
  Gcoeff(:)%j = (c(138)*M(4,:)%j) * den(13)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(420),h0tab(:,420),[12,3],[nME,nME],2,2,wf4(:,6),wf4(:,5))
  call Hloop_QV_A(ntryL,G0H16(1),wf4(:,6),G0H4(38),m3h4x4(:,229),heltab2x16(:,:,420))
  call Hloop_Q_A(ntryL,G0H4(38),12,nME,G1H4(93),n2h4(149))
  Gcoeff(:)%j = (c(138)*M(4,:)%j) * den(13)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(421),h0tab(:,421),[12,3],[nMM,nMM],2,2,wf4(:,6),wf4(:,5))
  call Hloop_QV_A(ntryL,G0H16(1),wf4(:,6),G0H4(38),m3h4x4(:,230),heltab2x16(:,:,421))
  call Hloop_Q_A(ntryL,G0H4(38),12,nMM,G1H4(94),n2h4(150))
  Gcoeff(:)%j = (c(138)*M(4,:)%j) * den(13)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(422),h0tab(:,422),[12,3],[nML,nML],2,2,wf4(:,6),wf4(:,5))
  call Hloop_QV_A(ntryL,G0H16(1),wf4(:,6),G0H4(38),m3h4x4(:,231),heltab2x16(:,:,422))
  call Hloop_Q_A(ntryL,G0H4(38),12,nML,G1H4(95),n2h4(151))
  Gcoeff(:)%j = (c(137)*M(4,:)%j) * den(13)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(423),h0tab(:,423),[12,3],[0,0],2,2,wf4(:,6),wf4(:,5))
  call Hloop_QV_A(ntryL,G0H16(1),wf4(:,6),G0H4(38),m3h4x4(:,232),heltab2x16(:,:,423))
  call Hloop_Q_A(ntryL,G0H4(38),12,0,G1H4(96),n2h4(152))
  Gcoeff(:)%j = (c(135)*M(4,:)%j) * den(13)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(424),h0tab(:,424),[12,3],[nMT,nMT],2,2,wf4(:,6),wf4(:,5))
  call Hloop_QV_A(ntryL,G0H16(1),wf4(:,6),G0H4(38),m3h4x4(:,233),heltab2x16(:,:,424))
  call Hloop_Q_A(ntryL,G0H4(38),12,nMT,G1H4(97),n2h4(153))
  Gcoeff(:)%j = (c(134)*M(4,:)%j) * den(13)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(425),h0tab(:,425),[12,3],[0,0],2,2,wf4(:,6),wf4(:,5))
  call Hloop_QV_A(ntryL,G0H16(1),wf4(:,6),G0H4(38),m3h4x4(:,234),heltab2x16(:,:,425))
  call Hloop_Q_A(ntryL,G0H4(38),12,0,G1H4(98),n2h4(154))
  Gcoeff(:)%j = (c(133)*M(4,:)%j) * den(13)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(426),h0tab(:,426),[12,3],[nMB,nMB],2,2,wf4(:,6),wf4(:,5))
  call Hloop_QV_A(ntryL,G0H16(1),wf4(:,6),G0H4(38),m3h4x4(:,235),heltab2x16(:,:,426))
  call Hloop_Q_A(ntryL,G0H4(38),12,nMB,G1H4(99),n2h4(155))
  Gcoeff(:)%j = (c(142)*M(4,:)%j) * den(12)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(427),h0tab(:,427),[12,3],[nME,nME],2,2,wf4(:,8),wf4(:,5))
  call Hloop_QZ_A(ntryL,G0H16(1),wf4(:,8),G0H4(38),ngZl,m3h4x4(:,236),heltab2x16(:,:,427))
  call Hloop_Q_A(ntryL,G0H4(38),12,nME,G1H4(100),n2h4(156))
  Gcoeff(:)%j = (c(142)*M(4,:)%j) * den(12)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(428),h0tab(:,428),[12,3],[nMM,nMM],2,2,wf4(:,8),wf4(:,5))
  call Hloop_QZ_A(ntryL,G0H16(1),wf4(:,8),G0H4(38),ngZl,m3h4x4(:,237),heltab2x16(:,:,428))
  call Hloop_Q_A(ntryL,G0H4(38),12,nMM,G1H4(101),n2h4(157))
  Gcoeff(:)%j = (c(142)*M(4,:)%j) * den(12)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(429),h0tab(:,429),[12,3],[nML,nML],2,2,wf4(:,8),wf4(:,5))
  call Hloop_QZ_A(ntryL,G0H16(1),wf4(:,8),G0H4(38),ngZl,m3h4x4(:,238),heltab2x16(:,:,429))
  call Hloop_Q_A(ntryL,G0H4(38),12,nML,G1H4(102),n2h4(158))
  Gcoeff(:)%j = (-(c(143)*M(4,:)%j)) * den(12)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(430),h0tab(:,430),[12,3],[0,0],2,2,wf4(:,8),wf4(:,5))
  call Hloop_QZ_A(ntryL,G0H16(1),wf4(:,8),G0H4(38),ngZu,m3h4x4(:,239),heltab2x16(:,:,430))
  call Hloop_Q_A(ntryL,G0H4(38),12,0,G1H4(103),n2h4(159))
  Gcoeff(:)%j = (-(c(141)*M(4,:)%j)) * den(12)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(431),h0tab(:,431),[12,3],[nMT,nMT],2,2,wf4(:,8),wf4(:,5))
  call Hloop_QZ_A(ntryL,G0H16(1),wf4(:,8),G0H4(38),ngZu,m3h4x4(:,240),heltab2x16(:,:,431))
  call Hloop_Q_A(ntryL,G0H4(38),12,nMT,G1H4(104),n2h4(160))
  Gcoeff(:)%j = (c(141)*M(4,:)%j) * den(12)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(432),h0tab(:,432),[12,3],[0,0],2,2,wf4(:,8),wf4(:,5))
  call Hloop_QZ_A(ntryL,G0H16(1),wf4(:,8),G0H4(38),ngZd,m3h4x4(:,241),heltab2x16(:,:,432))
  call Hloop_Q_A(ntryL,G0H4(38),12,0,G1H4(105),n2h4(161))
  Gcoeff(:)%j = (c(139)*M(4,:)%j) * den(12)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(433),h0tab(:,433),[12,3],[nMB,nMB],2,2,wf4(:,8),wf4(:,5))
  call Hloop_QZ_A(ntryL,G0H16(1),wf4(:,8),G0H4(38),ngZd,m3h4x4(:,242),heltab2x16(:,:,433))
  call Hloop_Q_A(ntryL,G0H4(38),12,nMB,G1H4(106),n2h4(162))
  Gcoeff(:)%j = (-(c(140)*M(4,:)%j)) * den(11)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(434),h0tab(:,434),[12,3],[nME,nME],2,2,wf4(:,6),wf4(:,7))
  call Hloop_QV_A(ntryL,G0H16(1),wf4(:,6),G0H4(38),m3h4x4(:,243),heltab2x16(:,:,434))
  call Hloop_Q_A(ntryL,G0H4(38),12,nME,G1H4(107),n2h4(163))
  Gcoeff(:)%j = (-(c(140)*M(4,:)%j)) * den(11)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(435),h0tab(:,435),[12,3],[nMM,nMM],2,2,wf4(:,6),wf4(:,7))
  call Hloop_QV_A(ntryL,G0H16(1),wf4(:,6),G0H4(38),m3h4x4(:,244),heltab2x16(:,:,435))
  call Hloop_Q_A(ntryL,G0H4(38),12,nMM,G1H4(108),n2h4(164))
  Gcoeff(:)%j = (-(c(140)*M(4,:)%j)) * den(11)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(436),h0tab(:,436),[12,3],[nML,nML],2,2,wf4(:,6),wf4(:,7))
  call Hloop_QV_A(ntryL,G0H16(1),wf4(:,6),G0H4(38),m3h4x4(:,245),heltab2x16(:,:,436))
  call Hloop_Q_A(ntryL,G0H4(38),12,nML,G1H4(109),n2h4(165))
  Gcoeff(:)%j = (c(141)*M(4,:)%j) * den(11)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(437),h0tab(:,437),[12,3],[0,0],2,2,wf4(:,6),wf4(:,7))
  call Hloop_QV_A(ntryL,G0H16(1),wf4(:,6),G0H4(38),m3h4x4(:,246),heltab2x16(:,:,437))
  call Hloop_Q_A(ntryL,G0H4(38),12,0,G1H4(110),n2h4(166))
  Gcoeff(:)%j = (c(139)*M(4,:)%j) * den(11)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(438),h0tab(:,438),[12,3],[nMT,nMT],2,2,wf4(:,6),wf4(:,7))
  call Hloop_QV_A(ntryL,G0H16(1),wf4(:,6),G0H4(38),m3h4x4(:,247),heltab2x16(:,:,438))
  call Hloop_Q_A(ntryL,G0H4(38),12,nMT,G1H4(111),n2h4(167))
  Gcoeff(:)%j = (-(c(139)*M(4,:)%j)) * den(11)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(439),h0tab(:,439),[12,3],[0,0],2,2,wf4(:,6),wf4(:,7))
  call Hloop_QV_A(ntryL,G0H16(1),wf4(:,6),G0H4(38),m3h4x4(:,248),heltab2x16(:,:,439))
  call Hloop_Q_A(ntryL,G0H4(38),12,0,G1H4(112),n2h4(168))
  Gcoeff(:)%j = (-(c(136)*M(4,:)%j)) * den(11)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(440),h0tab(:,440),[12,3],[nMB,nMB],2,2,wf4(:,6),wf4(:,7))
  call Hloop_QV_A(ntryL,G0H16(1),wf4(:,6),G0H4(38),m3h4x4(:,249),heltab2x16(:,:,440))
  call Hloop_Q_A(ntryL,G0H4(38),12,nMB,G1H4(113),n2h4(169))
  Gcoeff(:)%j = (-(c(147)*M(4,:)%j)) * den(10)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(441),h0tab(:,441),[12,3],[0,0],2,2,wf4(:,8),wf4(:,7))
  call Hloop_QZ_A(ntryL,G0H16(1),wf4(:,8),G0H4(38),ngZn,m3h4x4(:,250),heltab2x16(:,:,441))
  call Hloop_Q_A(ntryL,G0H4(38),12,0,G1H4(114),n2h4(170))
  Gcoeff(:)%j = (-(c(144)*M(4,:)%j)) * den(10)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(442),h0tab(:,442),[12,3],[nME,nME],2,2,wf4(:,8),wf4(:,7))
  call Hloop_QZ_A(ntryL,G0H16(1),wf4(:,8),G0H4(38),ngZl,m3h4x4(:,251),heltab2x16(:,:,442))
  call Hloop_Q_A(ntryL,G0H4(38),12,nME,G1H4(115),n2h4(171))
  Gcoeff(:)%j = (-(c(144)*M(4,:)%j)) * den(10)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(443),h0tab(:,443),[12,3],[nMM,nMM],2,2,wf4(:,8),wf4(:,7))
  call Hloop_QZ_A(ntryL,G0H16(1),wf4(:,8),G0H4(38),ngZl,m3h4x4(:,252),heltab2x16(:,:,443))
  call Hloop_Q_A(ntryL,G0H4(38),12,nMM,G1H4(116),n2h4(172))
  Gcoeff(:)%j = (-(c(144)*M(4,:)%j)) * den(10)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(444),h0tab(:,444),[12,3],[nML,nML],2,2,wf4(:,8),wf4(:,7))
  call Hloop_QZ_A(ntryL,G0H16(1),wf4(:,8),G0H4(38),ngZl,m3h4x4(:,253),heltab2x16(:,:,444))
  call Hloop_Q_A(ntryL,G0H4(38),12,nML,G1H4(117),n2h4(173))
  Gcoeff(:)%j = (-(c(146)*M(4,:)%j)) * den(10)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(445),h0tab(:,445),[12,3],[0,0],2,2,wf4(:,8),wf4(:,7))
  call Hloop_QZ_A(ntryL,G0H16(1),wf4(:,8),G0H4(38),ngZu,m3h4x4(:,254),heltab2x16(:,:,445))
  call Hloop_Q_A(ntryL,G0H4(38),12,0,G1H4(118),n2h4(174))
  Gcoeff(:)%j = (-(c(145)*M(4,:)%j)) * den(10)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(446),h0tab(:,446),[12,3],[nMT,nMT],2,2,wf4(:,8),wf4(:,7))
  call Hloop_QZ_A(ntryL,G0H16(1),wf4(:,8),G0H4(38),ngZu,m3h4x4(:,255),heltab2x16(:,:,446))
  call Hloop_Q_A(ntryL,G0H4(38),12,nMT,G1H4(119),n2h4(175))
  Gcoeff(:)%j = (-(c(146)*M(4,:)%j)) * den(10)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(447),h0tab(:,447),[12,3],[0,0],2,2,wf4(:,8),wf4(:,7))
  call Hloop_QZ_A(ntryL,G0H16(1),wf4(:,8),G0H4(38),ngZd,m3h4x4(:,256),heltab2x16(:,:,447))
  call Hloop_Q_A(ntryL,G0H4(38),12,0,G1H4(120),n2h4(176))
  Gcoeff(:)%j = (-(c(145)*M(4,:)%j)) * den(10)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(448),h0tab(:,448),[12,3],[nMB,nMB],2,2,wf4(:,8),wf4(:,7))
  call Hloop_QZ_A(ntryL,G0H16(1),wf4(:,8),G0H4(38),ngZd,m3h4x4(:,257),heltab2x16(:,:,448))
  call Hloop_Q_A(ntryL,G0H4(38),12,nMB,G1H4(121),n2h4(177))
  Gcoeff(:)%j = (-(c(5)*M(4,:)%j)) * den(13)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(449),h0tab(:,449),[12,3],[nMW,nMW],2,2,wf4(:,6),wf4(:,5))
  call Hloop_TV_S(ntryL,G0H16(1),0,wf4(:,6),12,G1H4(122),m3h4x4(:,258),heltab2x16(:,:,449))
  Gcoeff(:)%j = (-(c(131)*M(4,:)%j)) * den(12)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(450),h0tab(:,450),[12,3],[nMW,nMW],2,2,wf4(:,8),wf4(:,5))
  call Hloop_TV_S(ntryL,G0H16(1),0,wf4(:,8),12,G1H4(123),m3h4x4(:,259),heltab2x16(:,:,450))
  Gcoeff(:)%j = (c(130)*M(4,:)%j) * den(11)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(451),h0tab(:,451),[12,3],[nMW,nMW],2,2,wf4(:,6),wf4(:,7))
  call Hloop_TV_S(ntryL,G0H16(1),0,wf4(:,6),12,G1H4(124),m3h4x4(:,260),heltab2x16(:,:,451))
  Gcoeff(:)%j = (-(c(76)*M(4,:)%j)) * den(10)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(452),h0tab(:,452),[12,3],[nMH,nMZ],2,2,wf4(:,8),wf4(:,7))
  call Hloop_SV_T(ntryL,G0H16(1),0,wf4(:,8),12,G1H4(125),m3h4x4(:,261),heltab2x16(:,:,452))
  Gcoeff(:)%j = (c(132)*M(4,:)%j) * den(10)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(453),h0tab(:,453),[12,3],[nMW,nMW],2,2,wf4(:,8),wf4(:,7))
  call Hloop_TV_S(ntryL,G0H16(1),0,wf4(:,8),12,G1H4(126),m3h4x4(:,262),heltab2x16(:,:,453))
  Gcoeff(:)%j = (c(5)*M(4,:)%j) * den(13)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(454),h0tab(:,454),[12,3],[nMW,nMW],2,2,wf4(:,6),wf4(:,5))
  call Hloop_CV_D(ntryL,G0H16(1),0,wf4(:,6),12,G1H4(127),m3h4x4(:,263),heltab2x16(:,:,454))
  Gcoeff(:)%j = (c(5)*M(4,:)%j) * den(13)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(455),h0tab(:,455),[12,3],[nMW,nMW],2,2,wf4(:,6),wf4(:,5))
  call Hloop_CV_D(ntryL,G0H16(1),0,wf4(:,6),12,G1H4(128),m3h4x4(:,264),heltab2x16(:,:,455))
  Gcoeff(:)%j = (-(c(117)*M(4,:)%j)) * den(12)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(456),h0tab(:,456),[12,3],[nMW,nMW],2,2,wf4(:,8),wf4(:,5))
  call Hloop_CV_D(ntryL,G0H16(1),0,wf4(:,8),12,G1H4(129),m3h4x4(:,265),heltab2x16(:,:,456))
  Gcoeff(:)%j = (-(c(117)*M(4,:)%j)) * den(12)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(457),h0tab(:,457),[12,3],[nMW,nMW],2,2,wf4(:,8),wf4(:,5))
  call Hloop_CV_D(ntryL,G0H16(1),0,wf4(:,8),12,G1H4(130),m3h4x4(:,266),heltab2x16(:,:,457))
  Gcoeff(:)%j = (c(116)*M(4,:)%j) * den(11)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(458),h0tab(:,458),[12,3],[nMW,nMW],2,2,wf4(:,6),wf4(:,7))
  call Hloop_CV_D(ntryL,G0H16(1),0,wf4(:,6),12,G1H4(131),m3h4x4(:,267),heltab2x16(:,:,458))
  Gcoeff(:)%j = (c(116)*M(4,:)%j) * den(11)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(459),h0tab(:,459),[12,3],[nMW,nMW],2,2,wf4(:,6),wf4(:,7))
  call Hloop_CV_D(ntryL,G0H16(1),0,wf4(:,6),12,G1H4(132),m3h4x4(:,268),heltab2x16(:,:,459))
  Gcoeff(:)%j = (-(c(77)*M(4,:)%j)) * den(10)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(460),h0tab(:,460),[12,3],[nMW,nMW],2,2,wf4(:,8),wf4(:,7))
  call Hloop_CV_D(ntryL,G0H16(1),0,wf4(:,8),12,G1H4(133),m3h4x4(:,269),heltab2x16(:,:,460))
  Gcoeff(:)%j = (-(c(77)*M(4,:)%j)) * den(10)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(461),h0tab(:,461),[12,3],[nMW,nMW],2,2,wf4(:,8),wf4(:,7))
  call Hloop_CV_D(ntryL,G0H16(1),0,wf4(:,8),12,G1H4(134),m3h4x4(:,270),heltab2x16(:,:,461))
  Gcoeff(:)%j = (-(c(5)*M(4,:)%j)) * den(13)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(462),h0tab(:,462),[12,3],[nMW,nMW],2,2,wf4(:,6),wf4(:,5))
  call Hloop_UV_W(ntryL,G0H16(1),0,wf4(:,6),12,G1H4(135),m3h4x4(:,271),heltab2x16(:,:,462))
  Gcoeff(:)%j = (c(117)*M(4,:)%j) * den(12)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(463),h0tab(:,463),[12,3],[nMW,nMW],2,2,wf4(:,8),wf4(:,5))
  call Hloop_UV_W(ntryL,G0H16(1),0,wf4(:,8),12,G1H4(136),m3h4x4(:,272),heltab2x16(:,:,463))
  Gcoeff(:)%j = (-(c(116)*M(4,:)%j)) * den(11)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(464),h0tab(:,464),[12,3],[nMW,nMW],2,2,wf4(:,6),wf4(:,7))
  call Hloop_UV_W(ntryL,G0H16(1),0,wf4(:,6),12,G1H4(137),m3h4x4(:,273),heltab2x16(:,:,464))
  Gcoeff(:)%j = (c(77)*M(4,:)%j) * den(10)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(465),h0tab(:,465),[12,3],[nMW,nMW],2,2,wf4(:,8),wf4(:,7))
  call Hloop_UV_W(ntryL,G0H16(1),0,wf4(:,8),12,G1H4(138),m3h4x4(:,274),heltab2x16(:,:,465))
  Gcoeff(:)%j = (c(19)*M(4,:)%j) * den(13)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(466),h0tab(:,466),[12,3],[nMW,nMW],2,2,wf4(:,6),wf4(:,5))
  call Hloop_VV_S(ntryL,G0H16(1),wf4(:,6),G0H4(38),m3h4x4(:,275),heltab2x16(:,:,466))
  Gcoeff(:)%j = (c(19)*M(4,:)%j) * den(13)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(467),h0tab(:,467),[12,3],[nMW,nMW],2,2,wf4(:,6),wf4(:,5))
  call Hloop_VV_S(ntryL,G0H16(1),wf4(:,6),G0H4(39),m3h4x4(:,276),heltab2x16(:,:,467))
  Gcoeff(:)%j = (c(121)*M(4,:)%j) * den(12)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(468),h0tab(:,468),[12,3],[nMW,nMW],2,2,wf4(:,8),wf4(:,5))
  call Hloop_VV_S(ntryL,G0H16(1),wf4(:,8),G0H4(40),m3h4x4(:,277),heltab2x16(:,:,468))
  Gcoeff(:)%j = (c(121)*M(4,:)%j) * den(12)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(469),h0tab(:,469),[12,3],[nMW,nMW],2,2,wf4(:,8),wf4(:,5))
  call Hloop_VV_S(ntryL,G0H16(1),wf4(:,8),G0H4(41),m3h4x4(:,278),heltab2x16(:,:,469))
  Gcoeff(:)%j = (-(c(120)*M(4,:)%j)) * den(11)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(470),h0tab(:,470),[12,3],[nMW,nMW],2,2,wf4(:,6),wf4(:,7))
  call Hloop_VV_S(ntryL,G0H16(1),wf4(:,6),G0H4(42),m3h4x4(:,279),heltab2x16(:,:,470))
  Gcoeff(:)%j = (-(c(120)*M(4,:)%j)) * den(11)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(471),h0tab(:,471),[12,3],[nMW,nMW],2,2,wf4(:,6),wf4(:,7))
  call Hloop_VV_S(ntryL,G0H16(1),wf4(:,6),G0H4(43),m3h4x4(:,280),heltab2x16(:,:,471))
  Gcoeff(:)%j = (-(c(114)*M(4,:)%j)) * den(10)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(472),h0tab(:,472),[12,3],[nMH,nMZ],2,2,wf4(:,8),wf4(:,7))
  call Hloop_VV_S(ntryL,G0H16(1),wf4(:,8),G0H4(44),m3h4x4(:,281),heltab2x16(:,:,472))
  Gcoeff(:)%j = (-(c(122)*M(4,:)%j)) * den(10)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(473),h0tab(:,473),[12,3],[nMW,nMW],2,2,wf4(:,8),wf4(:,7))
  call Hloop_VV_S(ntryL,G0H16(1),wf4(:,8),G0H4(45),m3h4x4(:,282),heltab2x16(:,:,473))
  Gcoeff(:)%j = (-(c(122)*M(4,:)%j)) * den(10)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(474),h0tab(:,474),[12,3],[nMW,nMW],2,2,wf4(:,8),wf4(:,7))
  call Hloop_VV_S(ntryL,G0H16(1),wf4(:,8),G0H4(46),m3h4x4(:,283),heltab2x16(:,:,474))
  Gcoeff(:)%j = (-(c(152)*M(2,:)%j)) * den(14)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(475),h0tab(:,475),[9,6],[nME,0],2,2,wf4(:,9),wf4(:,10))
  call Hloop_AS_Q(ntryL,G0H16(1),wf4(:,9),G0H4(47),ngPnl,m3h4x4(:,284),heltab2x16(:,:,475))
  call Hloop_A_Q(ntryL,G0H4(47),9,nME,G1H4(139),n2h4(178))
  Gcoeff(:)%j = (-(c(154)*M(2,:)%j)) * den(14)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(476),h0tab(:,476),[9,6],[nMM,0],2,2,wf4(:,9),wf4(:,10))
  call Hloop_AS_Q(ntryL,G0H16(1),wf4(:,9),G0H4(47),ngPnl,m3h4x4(:,285),heltab2x16(:,:,476))
  call Hloop_A_Q(ntryL,G0H4(47),9,nMM,G1H4(140),n2h4(179))
  Gcoeff(:)%j = (-(c(153)*M(2,:)%j)) * den(14)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(477),h0tab(:,477),[9,6],[nML,0],2,2,wf4(:,9),wf4(:,10))
  call Hloop_AS_Q(ntryL,G0H16(1),wf4(:,9),G0H4(47),ngPnl,m3h4x4(:,286),heltab2x16(:,:,477))
  call Hloop_A_Q(ntryL,G0H4(47),9,nML,G1H4(141),n2h4(180))
  Gcoeff(:)%j = (c(151)*M(2,:)%j) * den(14)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(478),h0tab(:,478),[9,6],[nMB,nMT],2,2,wf4(:,9),wf4(:,10))
  call Hloop_AS_Q(ntryL,G0H16(1),wf4(:,9),G0H4(47),ngPtb,m3h4x4(:,287),heltab2x16(:,:,478))
  call Hloop_A_Q(ntryL,G0H4(47),9,nMB,G1H4(142),n2h4(181))
  Gcoeff(:)%j = (c(33)*M(2,:)%j) * den(14)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(479),h0tab(:,479),[9,6],[nMW,nMH],2,2,wf4(:,9),wf4(:,10))
  call Hloop_SS_S(ntryL,G0H16(1),wf4(:,9),G0H4(47),m3h4x4(:,288),heltab2x16(:,:,479))
  Gcoeff(:)%j = (-(c(125)*M(2,:)%j)) * den(14)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(480),h0tab(:,480),[9,6],[nMW,nMZ],2,2,wf4(:,9),wf4(:,10))
  call Hloop_SS_S(ntryL,G0H16(1),wf4(:,9),G0H4(48),m3h4x4(:,289),heltab2x16(:,:,480))
  Gcoeff(:)%j = (-(c(125)*M(2,:)%j)) * den(14)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(481),h0tab(:,481),[9,6],[nMW,nMZ],2,2,wf4(:,9),wf4(:,10))
  call Hloop_SS_S(ntryL,G0H16(1),wf4(:,9),G0H4(49),m3h4x4(:,290),heltab2x16(:,:,481))
  Gcoeff(:)%j = (c(75)*M(2,:)%j) * den(14)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(482),h0tab(:,482),[9,6],[nMW,0],2,2,wf4(:,9),wf4(:,10))
  call Hloop_VS_V(ntryL,G0H16(1),wf4(:,9),G0H4(50),m3h4x4(:,291),heltab2x16(:,:,482))
  Gcoeff(:)%j = (c(8)*M(2,:)%j) * den(14)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(483),h0tab(:,483),[9,6],[nMW,nMZ],2,2,wf4(:,9),wf4(:,10))
  call Hloop_VS_V(ntryL,G0H16(1),wf4(:,9),G0H4(51),m3h4x4(:,292),heltab2x16(:,:,483))
  Gcoeff(:)%j = (-(c(92)*M(2,:)%j)) * den(14)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(484),h0tab(:,484),[9,6],[0,nMW],2,2,wf4(:,9),wf4(:,10))
  call Hloop_TS_V(ntryL,G0H16(1),0,wf4(:,9),9,G1H4(143),m3h4x4(:,293),heltab2x16(:,:,484))
  Gcoeff(:)%j = (c(126)*M(2,:)%j) * den(14)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(485),h0tab(:,485),[9,6],[nMZ,nMW],2,2,wf4(:,9),wf4(:,10))
  call Hloop_TS_V(ntryL,G0H16(1),0,wf4(:,9),9,G1H4(144),m3h4x4(:,294),heltab2x16(:,:,485))
  Gcoeff(:)%j = (c(47)*M(2,:)%j) * den(14)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(486),h0tab(:,486),[9,6],[nMW,nMH],2,2,wf4(:,9),wf4(:,10))
  call Hloop_TS_V(ntryL,G0H16(1),0,wf4(:,9),9,G1H4(145),m3h4x4(:,295),heltab2x16(:,:,486))
  Gcoeff(:)%j = (c(47)*M(2,:)%j) * den(14)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(487),h0tab(:,487),[9,6],[nMW,nMZ],2,2,wf4(:,9),wf4(:,10))
  call Hloop_TS_V(ntryL,G0H16(1),0,wf4(:,9),9,G1H4(146),m3h4x4(:,296),heltab2x16(:,:,487))
  Gcoeff(:)%j = (-(c(161)*M(2,:)%j)) * den(14)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(488),h0tab(:,488),[9,6],[nME,0],2,2,wf4(:,9),wf4(:,12))
  call Hloop_AS_Q(ntryL,G0H16(1),wf4(:,9),G0H4(52),ngPnl,m3h4x4(:,297),heltab2x16(:,:,488))
  call Hloop_A_Q(ntryL,G0H4(52),9,nME,G1H4(147),n2h4(182))
  Gcoeff(:)%j = (-(c(163)*M(2,:)%j)) * den(14)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(489),h0tab(:,489),[9,6],[nMM,0],2,2,wf4(:,9),wf4(:,12))
  call Hloop_AS_Q(ntryL,G0H16(1),wf4(:,9),G0H4(52),ngPnl,m3h4x4(:,298),heltab2x16(:,:,489))
  call Hloop_A_Q(ntryL,G0H4(52),9,nMM,G1H4(148),n2h4(183))
  Gcoeff(:)%j = (-(c(162)*M(2,:)%j)) * den(14)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(490),h0tab(:,490),[9,6],[nML,0],2,2,wf4(:,9),wf4(:,12))
  call Hloop_AS_Q(ntryL,G0H16(1),wf4(:,9),G0H4(52),ngPnl,m3h4x4(:,299),heltab2x16(:,:,490))
  call Hloop_A_Q(ntryL,G0H4(52),9,nML,G1H4(149),n2h4(184))
  Gcoeff(:)%j = (c(160)*M(2,:)%j) * den(14)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(491),h0tab(:,491),[9,6],[nMB,nMT],2,2,wf4(:,9),wf4(:,12))
  call Hloop_AS_Q(ntryL,G0H16(1),wf4(:,9),G0H4(52),ngPtb,m3h4x4(:,300),heltab2x16(:,:,491))
  call Hloop_A_Q(ntryL,G0H4(52),9,nMB,G1H4(150),n2h4(185))
  Gcoeff(:)%j = (c(51)*M(2,:)%j) * den(14)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(492),h0tab(:,492),[9,6],[nMW,nMH],2,2,wf4(:,9),wf4(:,12))
  call Hloop_SS_S(ntryL,G0H16(1),wf4(:,9),G0H4(52),m3h4x4(:,301),heltab2x16(:,:,492))
  Gcoeff(:)%j = (c(22)*M(2,:)%j) * den(14)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(493),h0tab(:,493),[9,6],[nMW,nMZ],2,2,wf4(:,9),wf4(:,12))
  call Hloop_SS_S(ntryL,G0H16(1),wf4(:,9),G0H4(53),m3h4x4(:,302),heltab2x16(:,:,493))
  Gcoeff(:)%j = (c(75)*M(2,:)%j) * den(14)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(494),h0tab(:,494),[9,6],[nMW,0],2,2,wf4(:,9),wf4(:,12))
  call Hloop_SS_S(ntryL,G0H16(1),wf4(:,9),G0H4(54),m3h4x4(:,303),heltab2x16(:,:,494))
  Gcoeff(:)%j = (-(c(124)*M(2,:)%j)) * den(14)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(495),h0tab(:,495),[9,6],[nMW,nMZ],2,2,wf4(:,9),wf4(:,12))
  call Hloop_SS_S(ntryL,G0H16(1),wf4(:,9),G0H4(55),m3h4x4(:,304),heltab2x16(:,:,495))
  Gcoeff(:)%j = (c(75)*M(2,:)%j) * den(14)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(496),h0tab(:,496),[9,6],[nMW,0],2,2,wf4(:,9),wf4(:,12))
  call Hloop_VS_V(ntryL,G0H16(1),wf4(:,9),G0H4(56),m3h4x4(:,305),heltab2x16(:,:,496))
  Gcoeff(:)%j = (-(c(75)*M(2,:)%j)) * den(14)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(497),h0tab(:,497),[9,6],[nMW,nMZ],2,2,wf4(:,9),wf4(:,12))
  call Hloop_VS_V(ntryL,G0H16(1),wf4(:,9),G0H4(57),m3h4x4(:,306),heltab2x16(:,:,497))
  Gcoeff(:)%j = (c(75)*M(2,:)%j) * den(14)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(498),h0tab(:,498),[9,6],[0,nMW],2,2,wf4(:,9),wf4(:,12))
  call Hloop_TS_V(ntryL,G0H16(1),0,wf4(:,9),9,G1H4(151),m3h4x4(:,307),heltab2x16(:,:,498))
  Gcoeff(:)%j = (-(c(123)*M(2,:)%j)) * den(14)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(499),h0tab(:,499),[9,6],[nMZ,nMW],2,2,wf4(:,9),wf4(:,12))
  call Hloop_TS_V(ntryL,G0H16(1),0,wf4(:,9),9,G1H4(152),m3h4x4(:,308),heltab2x16(:,:,499))
  Gcoeff(:)%j = (c(22)*M(2,:)%j) * den(14)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(500),h0tab(:,500),[9,6],[nMW,nMH],2,2,wf4(:,9),wf4(:,12))
  call Hloop_TS_V(ntryL,G0H16(1),0,wf4(:,9),9,G1H4(153),m3h4x4(:,309),heltab2x16(:,:,500))
  Gcoeff(:)%j = (c(161)*M(2,:)%j) * den(14)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(501),h0tab(:,501),[9,6],[nME,0],2,2,wf4(:,11),wf4(:,10))
  call Hloop_AW_Q(ntryL,G0H16(1),wf4(:,11),G0H4(58),m3h4x4(:,310),heltab2x16(:,:,501))
  call Hloop_A_Q(ntryL,G0H4(58),9,nME,G1H4(154),n2h4(186))
  Gcoeff(:)%j = (c(163)*M(2,:)%j) * den(14)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(502),h0tab(:,502),[9,6],[nMM,0],2,2,wf4(:,11),wf4(:,10))
  call Hloop_AW_Q(ntryL,G0H16(1),wf4(:,11),G0H4(58),m3h4x4(:,311),heltab2x16(:,:,502))
  call Hloop_A_Q(ntryL,G0H4(58),9,nMM,G1H4(155),n2h4(187))
  Gcoeff(:)%j = (c(162)*M(2,:)%j) * den(14)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(503),h0tab(:,503),[9,6],[nML,0],2,2,wf4(:,11),wf4(:,10))
  call Hloop_AW_Q(ntryL,G0H16(1),wf4(:,11),G0H4(58),m3h4x4(:,312),heltab2x16(:,:,503))
  call Hloop_A_Q(ntryL,G0H4(58),9,nML,G1H4(156),n2h4(188))
  Gcoeff(:)%j = (c(160)*M(2,:)%j) * den(14)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(504),h0tab(:,504),[9,6],[nMB,nMT],2,2,wf4(:,11),wf4(:,10))
  call Hloop_AW_Q(ntryL,G0H16(1),wf4(:,11),G0H4(58),m3h4x4(:,313),heltab2x16(:,:,504))
  call Hloop_A_Q(ntryL,G0H4(58),9,nMB,G1H4(157),n2h4(189))
  Gcoeff(:)%j = (c(51)*M(2,:)%j) * den(14)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(505),h0tab(:,505),[9,6],[nMW,nMH],2,2,wf4(:,11),wf4(:,10))
  call Hloop_TV_S(ntryL,G0H16(1),0,wf4(:,11),9,G1H4(158),m3h4x4(:,314),heltab2x16(:,:,505))
  Gcoeff(:)%j = (c(75)*M(2,:)%j) * den(14)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(506),h0tab(:,506),[9,6],[nMW,0],2,2,wf4(:,11),wf4(:,10))
  call Hloop_DV_C(ntryL,G0H16(1),0,wf4(:,11),G1H4(159),m3h4x4(:,315),heltab2x16(:,:,506))
  Gcoeff(:)%j = (-(c(124)*M(2,:)%j)) * den(14)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(507),h0tab(:,507),[9,6],[nMW,nMZ],2,2,wf4(:,11),wf4(:,10))
  call Hloop_DV_C(ntryL,G0H16(1),0,wf4(:,11),G1H4(160),m3h4x4(:,316),heltab2x16(:,:,507))
  Gcoeff(:)%j = (c(22)*M(2,:)%j) * den(14)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(508),h0tab(:,508),[9,6],[nMW,nMZ],2,2,wf4(:,11),wf4(:,10))
  call Hloop_CV_D(ntryL,G0H16(1),0,wf4(:,11),9,G1H4(161),m3h4x4(:,317),heltab2x16(:,:,508))
  Gcoeff(:)%j = (-(c(75)*M(2,:)%j)) * den(14)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(509),h0tab(:,509),[9,6],[nMW,0],2,2,wf4(:,11),wf4(:,10))
  call Hloop_UV_W(ntryL,G0H16(1),0,wf4(:,11),9,G1H4(162),m3h4x4(:,318),heltab2x16(:,:,509))
  Gcoeff(:)%j = (c(75)*M(2,:)%j) * den(14)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(510),h0tab(:,510),[9,6],[nMW,nMZ],2,2,wf4(:,11),wf4(:,10))
  call Hloop_UV_W(ntryL,G0H16(1),0,wf4(:,11),9,G1H4(163),m3h4x4(:,319),heltab2x16(:,:,510))
  Gcoeff(:)%j = (-(c(75)*M(2,:)%j)) * den(14)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(511),h0tab(:,511),[9,6],[0,nMW],2,2,wf4(:,11),wf4(:,10))
  call Hloop_SV_V(ntryL,G0H16(1),wf4(:,11),G0H4(58),m3h4x4(:,320),heltab2x16(:,:,511))
  Gcoeff(:)%j = (c(123)*M(2,:)%j) * den(14)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(512),h0tab(:,512),[9,6],[nMZ,nMW],2,2,wf4(:,11),wf4(:,10))
  call Hloop_SV_V(ntryL,G0H16(1),wf4(:,11),G0H4(59),m3h4x4(:,321),heltab2x16(:,:,512))
  Gcoeff(:)%j = (c(22)*M(2,:)%j) * den(14)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(513),h0tab(:,513),[9,6],[nMW,nMH],2,2,wf4(:,11),wf4(:,10))
  call Hloop_SV_V(ntryL,G0H16(1),wf4(:,11),G0H4(60),m3h4x4(:,322),heltab2x16(:,:,513))
  Gcoeff(:)%j = (c(148)*M(2,:)%j) * den(14)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(514),h0tab(:,514),[9,6],[nME,0],2,2,wf4(:,11),wf4(:,12))
  call Hloop_AW_Q(ntryL,G0H16(1),wf4(:,11),G0H4(61),m3h4x4(:,323),heltab2x16(:,:,514))
  call Hloop_A_Q(ntryL,G0H4(61),9,nME,G1H4(164),n2h4(190))
  Gcoeff(:)%j = (c(148)*M(2,:)%j) * den(14)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(515),h0tab(:,515),[9,6],[nMM,0],2,2,wf4(:,11),wf4(:,12))
  call Hloop_AW_Q(ntryL,G0H16(1),wf4(:,11),G0H4(61),m3h4x4(:,324),heltab2x16(:,:,515))
  call Hloop_A_Q(ntryL,G0H4(61),9,nMM,G1H4(165),n2h4(191))
  Gcoeff(:)%j = (c(148)*M(2,:)%j) * den(14)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(516),h0tab(:,516),[9,6],[nML,0],2,2,wf4(:,11),wf4(:,12))
  call Hloop_AW_Q(ntryL,G0H16(1),wf4(:,11),G0H4(61),m3h4x4(:,325),heltab2x16(:,:,516))
  call Hloop_A_Q(ntryL,G0H4(61),9,nML,G1H4(166),n2h4(192))
  Gcoeff(:)%j = (c(150)*M(2,:)%j) * den(14)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(517),h0tab(:,517),[9,6],[0,0],2,2,wf4(:,11),wf4(:,12))
  call Hloop_AW_Q(ntryL,G0H16(1),wf4(:,11),G0H4(61),m3h4x4(:,326),heltab2x16(:,:,517))
  call Hloop_A_Q(ntryL,G0H4(61),9,0,G1H4(167),n2h4(193))
  Gcoeff(:)%j = (c(149)*M(2,:)%j) * den(14)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(518),h0tab(:,518),[9,6],[nMB,nMT],2,2,wf4(:,11),wf4(:,12))
  call Hloop_AW_Q(ntryL,G0H16(1),wf4(:,11),G0H4(61),m3h4x4(:,327),heltab2x16(:,:,518))
  call Hloop_A_Q(ntryL,G0H4(61),9,nMB,G1H4(168),n2h4(194))
  Gcoeff(:)%j = (c(21)*M(2,:)%j) * den(14)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(519),h0tab(:,519),[9,6],[nMW,nMH],2,2,wf4(:,11),wf4(:,12))
  call Hloop_TV_S(ntryL,G0H16(1),0,wf4(:,11),9,G1H4(169),m3h4x4(:,328),heltab2x16(:,:,519))
  Gcoeff(:)%j = (c(21)*M(2,:)%j) * den(14)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(520),h0tab(:,520),[9,6],[nMW,nMZ],2,2,wf4(:,11),wf4(:,12))
  call Hloop_TV_S(ntryL,G0H16(1),0,wf4(:,11),9,G1H4(170),m3h4x4(:,329),heltab2x16(:,:,520))
  Gcoeff(:)%j = (c(75)*M(2,:)%j) * den(14)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(521),h0tab(:,521),[9,6],[nMW,0],2,2,wf4(:,11),wf4(:,12))
  call Hloop_DV_C(ntryL,G0H16(1),0,wf4(:,11),G1H4(171),m3h4x4(:,330),heltab2x16(:,:,521))
  Gcoeff(:)%j = (c(23)*M(2,:)%j) * den(14)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(522),h0tab(:,522),[9,6],[nMW,nMZ],2,2,wf4(:,11),wf4(:,12))
  call Hloop_DV_C(ntryL,G0H16(1),0,wf4(:,11),G1H4(172),m3h4x4(:,331),heltab2x16(:,:,522))
  Gcoeff(:)%j = (c(75)*M(2,:)%j) * den(14)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(523),h0tab(:,523),[9,6],[nMW,0],2,2,wf4(:,11),wf4(:,12))
  call Hloop_CV_D(ntryL,G0H16(1),0,wf4(:,11),9,G1H4(173),m3h4x4(:,332),heltab2x16(:,:,523))
  Gcoeff(:)%j = (c(23)*M(2,:)%j) * den(14)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(524),h0tab(:,524),[9,6],[nMW,nMZ],2,2,wf4(:,11),wf4(:,12))
  call Hloop_CV_D(ntryL,G0H16(1),0,wf4(:,11),9,G1H4(174),m3h4x4(:,333),heltab2x16(:,:,524))
  Gcoeff(:)%j = (-(c(75)*M(2,:)%j)) * den(14)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(525),h0tab(:,525),[9,6],[nMW,0],2,2,wf4(:,11),wf4(:,12))
  call Hloop_UV_W(ntryL,G0H16(1),0,wf4(:,11),9,G1H4(175),m3h4x4(:,334),heltab2x16(:,:,525))
  Gcoeff(:)%j = (-(c(23)*M(2,:)%j)) * den(14)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(526),h0tab(:,526),[9,6],[nMW,nMZ],2,2,wf4(:,11),wf4(:,12))
  call Hloop_UV_W(ntryL,G0H16(1),0,wf4(:,11),9,G1H4(176),m3h4x4(:,335),heltab2x16(:,:,526))
  Gcoeff(:)%j = (c(113)*M(2,:)%j) * den(14)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(527),h0tab(:,527),[9,6],[0,nMW],2,2,wf4(:,11),wf4(:,12))
  call Hloop_SV_V(ntryL,G0H16(1),wf4(:,11),G0H4(61),m3h4x4(:,336),heltab2x16(:,:,527))
  Gcoeff(:)%j = (c(20)*M(2,:)%j) * den(14)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(528),h0tab(:,528),[9,6],[nMZ,nMW],2,2,wf4(:,11),wf4(:,12))
  call Hloop_SV_V(ntryL,G0H16(1),wf4(:,11),G0H4(62),m3h4x4(:,337),heltab2x16(:,:,528))
  Gcoeff(:)%j = (c(57)*M(2,:)%j) * den(14)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(529),h0tab(:,529),[9,6],[nMW,nMH],2,2,wf4(:,11),wf4(:,12))
  call Hloop_SV_V(ntryL,G0H16(1),wf4(:,11),G0H4(63),m3h4x4(:,338),heltab2x16(:,:,529))
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(46),[G1H4(72),G1H4(7),G1H4(44)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(45),[G1H4(39),G1H4(20),G1H4(73)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(74),[G1H4(42),G1H4(19),G1H4(9)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(4),[G1H4(41),G1H4(15),G1H4(10)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(69),[G1H4(43),G1H4(23),G1H4(6)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(52),[G1H4(2),G1H4(3),G1H4(24)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(49),[G1H4(12),G1H4(16),G1H4(30)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(26),[G1H4(13),G1H4(18),G1H4(32)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(35),[G1H4(14),G1H4(21),G1H4(1)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(53),[G1H4(5),G1H4(22),G1H4(8)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(27),[G1H4(50),G0H4(13)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(36),[G0H4(14)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(25),[G1H4(28),G1H4(51),G1H4(54),G0H4(6),G0H4(5),G0H4(4) &
    ,G0H4(3)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(65),[G1H4(66),G1H4(48),G1H4(58),G0H4(22),G0H4(17) &
    ,G0H4(16),G0H4(15)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(38),[G1H4(62),G0H4(21)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(57),[G1H4(56),G1H4(55),G1H4(17),G0H4(19),G0H4(24) &
    ,G0H4(23),G0H4(25)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(71),[G1H4(70),G1H4(59),G1H4(61),G0H4(9),G0H4(8),G0H4(2) &
    ,G0H4(1)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(60),[G0H4(7)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(100),[G1H4(93),G1H4(47),G1H4(33)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(101),[G1H4(94),G1H4(68),G1H4(29)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(102),[G1H4(95),G1H4(64),G1H4(67)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(104),[G1H4(97),G1H4(37),G1H4(63)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(106),[G1H4(99),G1H4(31),G1H4(34)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(115),[G1H4(107),G1H4(79),G1H4(40)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(116),[G1H4(108),G1H4(80),G1H4(75)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(117),[G1H4(109),G1H4(81),G1H4(76)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(119),[G1H4(111),G1H4(82),G1H4(77)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(121),[G1H4(113),G1H4(83),G1H4(78)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(123),[G1H4(122),G0H4(10)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(126),[G1H4(124),G0H4(26)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(125),[G0H4(27)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(130),[G1H4(129),G1H4(128),G1H4(127),G0H4(31),G0H4(30) &
    ,G0H4(29),G0H4(28)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(134),[G1H4(133),G1H4(132),G1H4(131),G0H4(35),G0H4(34) &
    ,G0H4(33),G0H4(32)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(136),[G1H4(135),G0H4(36)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(138),[G1H4(137),G0H4(37)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(87),[G1H4(86),G1H4(85),G1H4(84),G0H4(41),G0H4(40) &
    ,G0H4(39),G0H4(38)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(92),[G1H4(91),G1H4(89),G1H4(88),G0H4(46),G0H4(45) &
    ,G0H4(43),G0H4(42)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(90),[G0H4(44)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(105),[G1H4(103),G1H4(98),G1H4(96)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(118),[G1H4(110)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(120),[G1H4(112)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(154),[G1H4(139)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(155),[G1H4(140)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(156),[G1H4(141)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(157),[G1H4(142)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(158),[G0H4(47)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(160),[G0H4(48)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(161),[G0H4(49)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(162),[G0H4(50)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(163),[G0H4(51)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(143),[G0H4(58)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(144),[G0H4(59)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(145),[G0H4(60)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(164),[G1H4(147)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(165),[G1H4(148)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(166),[G1H4(149)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(168),[G1H4(150)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(169),[G0H4(52)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(172),[G0H4(53)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(173),[G0H4(54)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(174),[G0H4(55)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(175),[G0H4(56)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(176),[G0H4(57)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(151),[G0H4(61)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(152),[G0H4(62)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(153),[G0H4(63)])
  call Hloop_QS_A(ntryL,G1H4(46),wf4(:,1),G1H1(1),ngH,m3h4x1(:,35),heltab2x4(:,:,132))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),15,nME,G2tensor(19),n2h1(51))
  call Hloop_QS_A(ntryL,G1H4(45),wf4(:,1),G1H1(1),ngH,m3h4x1(:,36),heltab2x4(:,:,133))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),15,nMM,G2tensor(7),n2h1(52))
  call Hloop_QS_A(ntryL,G1H4(74),wf4(:,1),G1H1(1),ngH,m3h4x1(:,37),heltab2x4(:,:,134))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),15,nML,G2tensor(16),n2h1(53))
  call Hloop_QS_A(ntryL,G1H4(4),wf4(:,1),G1H1(1),ngH,m3h4x1(:,38),heltab2x4(:,:,135))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),15,nMT,G2tensor(40),n2h1(54))
  call Hloop_QS_A(ntryL,G1H4(69),wf4(:,1),G1H1(1),ngH,m3h4x1(:,39),heltab2x4(:,:,136))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),15,nMB,G2tensor(55),n2h1(55))
  call Hloop_QS_A(ntryL,G1H4(52),wf4(:,3),G1H1(1),ngX,m3h4x1(:,40),heltab2x4(:,:,137))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),15,nME,G2tensor(35),n2h1(56))
  call Hloop_QS_A(ntryL,G1H4(49),wf4(:,3),G1H1(1),ngX,m3h4x1(:,41),heltab2x4(:,:,138))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),15,nMM,G2tensor(45),n2h1(57))
  call Hloop_QS_A(ntryL,G1H4(26),wf4(:,3),G1H1(1),ngX,m3h4x1(:,42),heltab2x4(:,:,139))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),15,nML,G2tensor(53),n2h1(58))
  call Hloop_QS_A(ntryL,G1H4(35),wf4(:,3),G1H1(1),ngX,m3h4x1(:,43),heltab2x4(:,:,140))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),15,nMT,G2tensor(29),n2h1(59))
  call Hloop_QS_A(ntryL,G1H4(53),wf4(:,3),G1H1(1),ngX,m3h4x1(:,44),heltab2x4(:,:,141))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),15,nMB,G2tensor(5),n2h1(60))
  call Hcheck_last_SS_S(ntryL,l_switch,G0H4(11),wf4(:,1),G0tensor(219),m3h4x1(:,45),heltab2x4(:,:,142))
  call Hcheck_last_SS_S(ntryL,l_switch,G0H4(12),wf4(:,1),G0tensor(225),m3h4x1(:,46),heltab2x4(:,:,143))
  call Hcheck_last_SS_S(ntryL,l_switch,G1H4(27),wf4(:,1),G1tensor(71),m3h4x1(:,47),heltab2x4(:,:,144))
  call Hcheck_last_SS_S(ntryL,l_switch,G1H4(36),wf4(:,3),G1tensor(76),m3h4x1(:,48),heltab2x4(:,:,145))
  call Hcheck_last_SS_S(ntryL,l_switch,G0H4(18),wf4(:,1),G0tensor(232),m3h4x1(:,49),heltab2x4(:,:,146))
  call Hcheck_last_SS_S(ntryL,l_switch,G1H4(25),wf4(:,1),G1tensor(81),m3h4x1(:,50),heltab2x4(:,:,147))
  call Hcheck_last_SS_S(ntryL,l_switch,G1H4(65),wf4(:,3),G1tensor(86),m3h4x1(:,51),heltab2x4(:,:,148))
  call Hcheck_last_VS_V(ntryL,l_switch,G0H4(20),wf4(:,1),G0tensor(238),m3h4x1(:,52),heltab2x4(:,:,149))
  call Hcheck_last_VS_V(ntryL,l_switch,G1H4(38),wf4(:,1),G1tensor(91),m3h4x1(:,53),heltab2x4(:,:,150))
  call Hcheck_last_ST_V(ntryL,l_switch,G1H4(11),12,wf4(:,1),3,G2tensor(11),m3h4x1(:,54),heltab2x4(:,:,151))
  call Hcheck_last_ST_V(ntryL,l_switch,G1H4(57),12,wf4(:,1),3,G2tensor(52),m3h4x1(:,55),heltab2x4(:,:,152))
  call Hcheck_last_ST_V(ntryL,l_switch,G1H4(71),12,wf4(:,3),3,G2tensor(8),m3h4x1(:,56),heltab2x4(:,:,153))
  call Hcheck_last_TS_V(ntryL,l_switch,G1H4(60),12,wf4(:,3),3,G2tensor(51),m3h4x1(:,57),heltab2x4(:,:,154))
  call Hloop_QV_A(ntryL,G1H4(100),wf4(:,5),G1H1(1),m3h4x1(:,58),heltab2x4(:,:,155))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),15,nME,G2tensor(41),n2h1(61))
  call Hloop_QV_A(ntryL,G1H4(101),wf4(:,5),G1H1(1),m3h4x1(:,59),heltab2x4(:,:,156))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),15,nMM,G2tensor(26),n2h1(62))
  call Hloop_QV_A(ntryL,G1H4(102),wf4(:,5),G1H1(1),m3h4x1(:,60),heltab2x4(:,:,157))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),15,nML,G2tensor(14),n2h1(63))
  call Hloop_QV_A(ntryL,G1H4(104),wf4(:,5),G1H1(1),m3h4x1(:,61),heltab2x4(:,:,158))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),15,nMT,G2tensor(12),n2h1(64))
  call Hloop_QV_A(ntryL,G1H4(106),wf4(:,5),G1H1(1),m3h4x1(:,62),heltab2x4(:,:,159))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),15,nMB,G2tensor(44),n2h1(65))
  call Hloop_QZ_A(ntryL,G1H4(115),wf4(:,7),G1H1(1),ngZl,m3h4x1(:,63),heltab2x4(:,:,160))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),15,nME,G2tensor(4),n2h1(66))
  call Hloop_QZ_A(ntryL,G1H4(116),wf4(:,7),G1H1(1),ngZl,m3h4x1(:,64),heltab2x4(:,:,161))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),15,nMM,G2tensor(31),n2h1(67))
  call Hloop_QZ_A(ntryL,G1H4(117),wf4(:,7),G1H1(1),ngZl,m3h4x1(:,65),heltab2x4(:,:,162))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),15,nML,G2tensor(9),n2h1(68))
  call Hloop_QZ_A(ntryL,G1H4(119),wf4(:,7),G1H1(1),ngZu,m3h4x1(:,66),heltab2x4(:,:,163))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),15,nMT,G2tensor(10),n2h1(69))
  call Hloop_QZ_A(ntryL,G1H4(121),wf4(:,7),G1H1(1),ngZd,m3h4x1(:,67),heltab2x4(:,:,164))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),15,nMB,G2tensor(1),n2h1(70))
  call Hcheck_last_TV_S(ntryL,l_switch,G1H4(123),12,wf4(:,5),3,G2tensor(2),m3h4x1(:,68),heltab2x4(:,:,165))
  call Hcheck_last_TV_S(ntryL,l_switch,G1H4(126),12,wf4(:,7),3,G2tensor(46),m3h4x1(:,69),heltab2x4(:,:,166))
  call Hcheck_last_TV_S(ntryL,l_switch,G1H4(125),12,wf4(:,7),3,G2tensor(6),m3h4x1(:,70),heltab2x4(:,:,167))
  call Hcheck_last_CV_D(ntryL,l_switch,G1H4(130),12,wf4(:,5),3,G2tensor(54),m3h4x1(:,71),heltab2x4(:,:,168))
  call Hcheck_last_CV_D(ntryL,l_switch,G1H4(134),12,wf4(:,7),3,G2tensor(18),m3h4x1(:,72),heltab2x4(:,:,169))
  call Hcheck_last_UV_W(ntryL,l_switch,G1H4(136),12,wf4(:,5),3,G2tensor(39),m3h4x1(:,73),heltab2x4(:,:,170))
  call Hcheck_last_UV_W(ntryL,l_switch,G1H4(138),12,wf4(:,7),3,G2tensor(33),m3h4x1(:,74),heltab2x4(:,:,171))
  call Hcheck_last_SV_V(ntryL,l_switch,G1H4(87),wf4(:,5),G1tensor(96),m3h4x1(:,75),heltab2x4(:,:,172))
  call Hcheck_last_SV_V(ntryL,l_switch,G1H4(92),wf4(:,7),G1tensor(101),m3h4x1(:,76),heltab2x4(:,:,173))
  call Hcheck_last_SV_V(ntryL,l_switch,G1H4(90),wf4(:,7),G1tensor(106),m3h4x1(:,77),heltab2x4(:,:,174))
  call Hloop_QV_A(ntryL,G1H4(105),wf4(:,5),G1H1(1),m3h4x1(:,78),heltab2x4(:,:,175))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),15,0,G2tensor(37),n2h1(71))
  call Hloop_QZ_A(ntryL,G1H4(118),wf4(:,7),G1H1(1),ngZu,m3h4x1(:,79),heltab2x4(:,:,176))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),15,0,G2tensor(27),n2h1(72))
  call Hloop_QZ_A(ntryL,G1H4(120),wf4(:,7),G1H1(1),ngZd,m3h4x1(:,80),heltab2x4(:,:,177))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),15,0,G2tensor(13),n2h1(73))
  call Hloop_QZ_A(ntryL,G1H4(114),wf4(:,7),G1H1(1),ngZn,m3h4x1(:,81),heltab2x4(:,:,178))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),15,0,G2tensor(62),n2h1(74))
  call Hloop_AS_Q(ntryL,G1H4(154),wf4(:,10),G1H1(1),ngPln,m3h4x1(:,82),heltab2x4(:,:,179))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),15,0,G2tensor(43),n2h1(75))
  call Hloop_AS_Q(ntryL,G1H4(155),wf4(:,10),G1H1(1),ngPln,m3h4x1(:,83),heltab2x4(:,:,180))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),15,0,G2tensor(56),n2h1(76))
  call Hloop_AS_Q(ntryL,G1H4(156),wf4(:,10),G1H1(1),ngPln,m3h4x1(:,84),heltab2x4(:,:,181))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),15,0,G2tensor(15),n2h1(77))
  call Hloop_AS_Q(ntryL,G1H4(157),wf4(:,10),G1H1(1),ngPbt,m3h4x1(:,85),heltab2x4(:,:,182))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),15,nMT,G2tensor(60),n2h1(78))
  call Hcheck_last_SS_S(ntryL,l_switch,G1H4(158),wf4(:,10),G1tensor(111),m3h4x1(:,86),heltab2x4(:,:,183))
  call Hcheck_last_SS_S(ntryL,l_switch,G1H4(160),wf4(:,10),G1tensor(116),m3h4x1(:,87),heltab2x4(:,:,184))
  call Hcheck_last_SS_S(ntryL,l_switch,G1H4(161),wf4(:,10),G1tensor(121),m3h4x1(:,88),heltab2x4(:,:,185))
  call Hcheck_last_VS_V(ntryL,l_switch,G1H4(162),wf4(:,10),G1tensor(126),m3h4x1(:,89),heltab2x4(:,:,186))
  call Hcheck_last_VS_V(ntryL,l_switch,G1H4(163),wf4(:,10),G1tensor(131),m3h4x1(:,90),heltab2x4(:,:,187))
  call Hcheck_last_VT_S(ntryL,l_switch,G1H4(143),9,wf4(:,10),6,G2tensor(50),m3h4x1(:,91),heltab2x4(:,:,188))
  call Hcheck_last_VT_S(ntryL,l_switch,G1H4(144),9,wf4(:,10),6,G2tensor(42),m3h4x1(:,92),heltab2x4(:,:,189))
  call Hcheck_last_VS_T(ntryL,l_switch,G1H4(145),9,wf4(:,10),6,G2tensor(28),m3h4x1(:,93),heltab2x4(:,:,190))
  call Hcheck_last_VS_T(ntryL,l_switch,G1H4(146),9,wf4(:,10),6,G2tensor(25),m3h4x1(:,94),heltab2x4(:,:,191))
  call Hloop_AW_Q(ntryL,G1H4(164),wf4(:,12),G1H1(1),m3h4x1(:,95),heltab2x4(:,:,192))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),15,0,G2tensor(59),n2h1(79))
  call Hloop_AW_Q(ntryL,G1H4(165),wf4(:,12),G1H1(1),m3h4x1(:,96),heltab2x4(:,:,193))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),15,0,G2tensor(36),n2h1(80))
  call Hloop_AW_Q(ntryL,G1H4(166),wf4(:,12),G1H1(1),m3h4x1(:,97),heltab2x4(:,:,194))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),15,0,G2tensor(3),n2h1(81))
  call Hloop_AW_Q(ntryL,G1H4(168),wf4(:,12),G1H1(1),m3h4x1(:,98),heltab2x4(:,:,195))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),15,nMT,G2tensor(17),n2h1(82))
  call Hcheck_last_SV_T(ntryL,l_switch,G1H4(169),9,wf4(:,12),6,G2tensor(58),m3h4x1(:,99),heltab2x4(:,:,196))
  call Hcheck_last_DV_C(ntryL,l_switch,G1H4(172),9,wf4(:,12),G2tensor(47),m3h4x1(:,100),heltab2x4(:,:,197))
  call Hcheck_last_CV_D(ntryL,l_switch,G1H4(173),9,wf4(:,12),6,G2tensor(23),m3h4x1(:,101),heltab2x4(:,:,198))
  call Hcheck_last_CV_D(ntryL,l_switch,G1H4(174),9,wf4(:,12),6,G2tensor(48),m3h4x1(:,102),heltab2x4(:,:,199))
  call Hcheck_last_UV_W(ntryL,l_switch,G1H4(175),9,wf4(:,12),6,G2tensor(22),m3h4x1(:,103),heltab2x4(:,:,200))
  call Hcheck_last_UV_W(ntryL,l_switch,G1H4(176),9,wf4(:,12),6,G2tensor(24),m3h4x1(:,104),heltab2x4(:,:,201))
  call Hcheck_last_VV_S(ntryL,l_switch,G1H4(151),wf4(:,12),G1tensor(136),m3h4x1(:,105),heltab2x4(:,:,202))
  call Hcheck_last_VV_S(ntryL,l_switch,G1H4(152),wf4(:,12),G1tensor(141),m3h4x1(:,106),heltab2x4(:,:,203))
  call Hcheck_last_VV_S(ntryL,l_switch,G1H4(153),wf4(:,12),G1tensor(146),m3h4x1(:,107),heltab2x4(:,:,204))
  call Hcheck_last_SS_S(ntryL,l_switch,G1H4(159),wf4(:,10),G1tensor(151),m3h4x1(:,108),heltab2x4(:,:,205))
  call Hloop_AW_Q(ntryL,G1H4(167),wf4(:,12),G1H1(1),m3h4x1(:,109),heltab2x4(:,:,206))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),15,0,G2tensor(34),n2h1(83))
  call Hcheck_last_SV_T(ntryL,l_switch,G1H4(170),9,wf4(:,12),6,G2tensor(20),m3h4x1(:,110),heltab2x4(:,:,207))
  call Hcheck_last_DV_C(ntryL,l_switch,G1H4(171),9,wf4(:,12),G2tensor(38),m3h4x1(:,111),heltab2x4(:,:,208))
  call ol_merge_tensors(G0tensor(248),[G0tensor(22),G0tensor(6)])
  call ol_merge_tensors(G0tensor(405),[G0tensor(307),G0tensor(234),G0tensor(227),G0tensor(141),G0tensor(11)])
  call ol_merge_tensors(G0tensor(356),[G0tensor(255),G0tensor(27),G0tensor(86),G0tensor(16)])
  call ol_merge_tensors(G0tensor(470),[G0tensor(463),G0tensor(451),G0tensor(438),G0tensor(430),G0tensor(417),G0tensor(410) &
    ,G0tensor(368),G0tensor(357),G0tensor(345),G0tensor(339),G0tensor(327),G0tensor(315),G0tensor(309),G0tensor(298),G0tensor(290) &
    ,G0tensor(284),G0tensor(270),G0tensor(256),G0tensor(242),G0tensor(236),G0tensor(229),G0tensor(218),G0tensor(194),G0tensor(189) &
    ,G0tensor(184),G0tensor(177),G0tensor(171),G0tensor(165),G0tensor(159),G0tensor(148),G0tensor(92),G0tensor(140),G0tensor(78) &
    ,G0tensor(119),G0tensor(104),G0tensor(13),G0tensor(4),G0tensor(151),G0tensor(91),G0tensor(56),G0tensor(21)])
  call ol_merge_tensors(G0tensor(450),[G0tensor(443),G0tensor(437),G0tensor(397),G0tensor(385),G0tensor(358),G0tensor(351) &
    ,G0tensor(328),G0tensor(321),G0tensor(277),G0tensor(272),G0tensor(263),G0tensor(257),G0tensor(250),G0tensor(164),G0tensor(158) &
    ,G0tensor(143),G0tensor(139),G0tensor(115),G0tensor(110),G0tensor(34),G0tensor(29),G0tensor(142),G0tensor(14),G0tensor(45) &
    ,G0tensor(96),G0tensor(66),G0tensor(26)])
  call ol_merge_tensors(G0tensor(429),[G0tensor(422),G0tensor(409),G0tensor(391),G0tensor(379),G0tensor(373),G0tensor(346) &
    ,G0tensor(333),G0tensor(310),G0tensor(303),G0tensor(264),G0tensor(249),G0tensor(243),G0tensor(237),G0tensor(231),G0tensor(223) &
    ,G0tensor(90),G0tensor(83),G0tensor(87),G0tensor(70),G0tensor(49),G0tensor(39),G0tensor(147),G0tensor(20),G0tensor(40) &
    ,G0tensor(127),G0tensor(61),G0tensor(31)])
  call ol_merge_tensors(G2tensor(6),[G2tensor(51),G1tensor(106),G1tensor(76),G0tensor(262),G0tensor(9),G0tensor(41)])
  call ol_merge_tensors(G0tensor(433),[G0tensor(325),G0tensor(268),G0tensor(33),G0tensor(81),G0tensor(46)])
  call ol_merge_tensors(G0tensor(344),[G0tensor(241),G0tensor(235),G0tensor(54),G0tensor(51)])
  call ol_merge_tensors(G2tensor(11),[G0tensor(238),G0tensor(232),G0tensor(225),G0tensor(276),G0tensor(109),G0tensor(76)])
  call ol_merge_tensors(G2tensor(33),[G2tensor(39),G2tensor(18),G2tensor(54),G2tensor(46),G2tensor(2),G2tensor(8),G2tensor(52) &
    ,G1tensor(101),G1tensor(96),G1tensor(91),G1tensor(86),G1tensor(81),G1tensor(71),G0tensor(282),G0tensor(216),G0tensor(106)])
  call ol_merge_tensors(G0tensor(454),[G0tensor(440),G0tensor(419),G0tensor(287),G0tensor(111)])
  call ol_merge_tensors(G0tensor(295),[G0tensor(116)])
  call ol_merge_tensors(G0tensor(464),[G0tensor(458),G0tensor(452),G0tensor(445),G0tensor(431),G0tensor(424),G0tensor(416) &
    ,G0tensor(403),G0tensor(398),G0tensor(392),G0tensor(386),G0tensor(380),G0tensor(374),G0tensor(363),G0tensor(352),G0tensor(340) &
    ,G0tensor(334),G0tensor(322),G0tensor(316),G0tensor(304),G0tensor(296),G0tensor(289),G0tensor(278),G0tensor(271),G0tensor(265) &
    ,G0tensor(258),G0tensor(251),G0tensor(244),G0tensor(230),G0tensor(224),G0tensor(212),G0tensor(206),G0tensor(200),G0tensor(178) &
    ,G0tensor(172),G0tensor(154),G0tensor(117),G0tensor(125),G0tensor(100),G0tensor(55),G0tensor(52),G0tensor(94),G0tensor(37) &
    ,G0tensor(50),G0tensor(132),G0tensor(59),G0tensor(10),G0tensor(15),G0tensor(2),G0tensor(121)])
  call ol_merge_tensors(G0tensor(469),[G0tensor(457),G0tensor(444),G0tensor(436),G0tensor(423),G0tensor(415),G0tensor(408) &
    ,G0tensor(297),G0tensor(291),G0tensor(283),G0tensor(217),G0tensor(211),G0tensor(205),G0tensor(195),G0tensor(183),G0tensor(166) &
    ,G0tensor(144),G0tensor(128),G0tensor(150),G0tensor(123),G0tensor(77),G0tensor(84),G0tensor(62),G0tensor(60),G0tensor(124) &
    ,G0tensor(126)])
  call ol_merge_tensors(G0tensor(427),[G0tensor(420),G0tensor(389),G0tensor(371),G0tensor(19),G0tensor(136)])
  call ol_merge_tensors(G0tensor(175),[G0tensor(170),G0tensor(25),G0tensor(18),G0tensor(3),G0tensor(146)])
  call ol_merge_tensors(G0tensor(376),[G0tensor(370),G0tensor(7),G0tensor(8)])
  call ol_merge_tensors(G0tensor(448),[G0tensor(441),G0tensor(395),G0tensor(32),G0tensor(137),G0tensor(64)])
  call ol_merge_tensors(G0tensor(382),[G0tensor(30),G0tensor(24),G0tensor(69)])
  call ol_merge_tensors(G0tensor(301),[G0tensor(247),G0tensor(226),G0tensor(221),G0tensor(108),G0tensor(48)])
  call ol_merge_tensors(G0tensor(330),[G0tensor(260),G0tensor(239),G0tensor(220),G0tensor(99),G0tensor(43)])
  call ol_merge_tensors(G2tensor(10),[G2tensor(12),G2tensor(29),G2tensor(40),G0tensor(199),G0tensor(102),G0tensor(63) &
    ,G0tensor(38)])
  call ol_merge_tensors(G0tensor(203),[G0tensor(113),G0tensor(53),G0tensor(44)])
  call ol_merge_tensors(G0tensor(407),[G0tensor(68),G0tensor(47)])
  call ol_merge_tensors(G0tensor(414),[G0tensor(210),G0tensor(122),G0tensor(58),G0tensor(95)])
  call ol_merge_tensors(G0tensor(286),[G0tensor(281),G0tensor(191),G0tensor(161),G0tensor(88),G0tensor(67)])
  call ol_merge_tensors(G0tensor(293),[G0tensor(280),G0tensor(180),G0tensor(133),G0tensor(130),G0tensor(72)])
  call ol_merge_tensors(G2tensor(1),[G2tensor(44),G2tensor(5),G2tensor(55),G0tensor(186),G0tensor(153),G0tensor(135) &
    ,G0tensor(73)])
  call ol_merge_tensors(G0tensor(80),[G0tensor(75)])
  call ol_merge_tensors(G2tensor(58),[G2tensor(28),G1tensor(146),G1tensor(111),G0tensor(421),G0tensor(89),G0tensor(112)])
  call ol_merge_tensors(G0tensor(428),[G0tensor(145),G0tensor(82)])
  call ol_merge_tensors(G0tensor(319),[G0tensor(275),G0tensor(267),G0tensor(261),G0tensor(155),G0tensor(93)])
  call ol_merge_tensors(G0tensor(348),[G0tensor(274),G0tensor(253),G0tensor(246),G0tensor(107),G0tensor(97)])
  call ol_merge_tensors(G2tensor(42),[G1tensor(141),G0tensor(435),G0tensor(120),G0tensor(114)])
  call ol_merge_tensors(G0tensor(156),[G0tensor(134)])
  call ol_merge_tensors(G2tensor(20),[G2tensor(24),G2tensor(48),G2tensor(47),G2tensor(25),G1tensor(131),G1tensor(121) &
    ,G1tensor(116),G0tensor(442),G0tensor(162),G0tensor(138)])
  call ol_merge_tensors(G0tensor(449),[G0tensor(163),G0tensor(157)])
  call ol_merge_tensors(G0tensor(461),[G0tensor(455),G0tensor(401),G0tensor(383),G0tensor(377),G0tensor(168)])
  call ol_merge_tensors(G0tensor(466),[G0tensor(366),G0tensor(355),G0tensor(343),G0tensor(337),G0tensor(169)])
  call ol_merge_tensors(G0tensor(400),[G0tensor(394),G0tensor(388),G0tensor(174)])
  call ol_merge_tensors(G0tensor(367),[G0tensor(326),G0tensor(314),G0tensor(308),G0tensor(176)])
  call ol_merge_tensors(G0tensor(187),[G0tensor(181)])
  call ol_merge_tensors(G2tensor(38),[G2tensor(22),G2tensor(23),G1tensor(151),G1tensor(126),G0tensor(456),G0tensor(192) &
    ,G0tensor(182)])
  call ol_merge_tensors(G0tensor(462),[G0tensor(193),G0tensor(188)])
  call ol_merge_tensors(G0tensor(361),[G0tensor(349),G0tensor(336),G0tensor(331),G0tensor(208),G0tensor(197)])
  call ol_merge_tensors(G0tensor(360),[G0tensor(318),G0tensor(312),G0tensor(300),G0tensor(202),G0tensor(198)])
  call ol_merge_tensors(G2tensor(50),[G1tensor(136),G0tensor(468),G0tensor(209),G0tensor(204)])
  call ol_merge_tensors(G0tensor(467),[G0tensor(434),G0tensor(413),G0tensor(406),G0tensor(215)])
  call ol_merge_tensors(G0tensor(219),[G0tensor(372),G0tensor(233),G0tensor(222)])
  call ol_merge_tensors(G0tensor(412),[G0tensor(338),G0tensor(313),G0tensor(269),G0tensor(254),G0tensor(240),G0tensor(228)])
  call ol_merge_tensors(G0tensor(460),[G0tensor(447),G0tensor(426),G0tensor(294),G0tensor(288)])
  call ol_merge_tensors(G0tensor(390),[G0tensor(306),G0tensor(302)])
  call ol_merge_tensors(G0tensor(396),[G0tensor(324),G0tensor(320)])
  call ol_merge_tensors(G0tensor(378),[G0tensor(342),G0tensor(332)])
  call ol_merge_tensors(G0tensor(384),[G0tensor(354),G0tensor(350)])
  call ol_merge_tensors(G2tensor(62),[G2tensor(13),G2tensor(27),G2tensor(37),G0tensor(402),G0tensor(365),G0tensor(362)])
  call ol_merge_tensors(G2tensor(4),[G2tensor(41),G2tensor(35),G2tensor(19)])
  call ol_merge_tensors(G2tensor(31),[G2tensor(26),G2tensor(45),G2tensor(7)])
  call ol_merge_tensors(G2tensor(9),[G2tensor(14),G2tensor(53),G2tensor(16)])
  call ol_merge_tensors(G2tensor(59),[G2tensor(43)])
  call ol_merge_tensors(G2tensor(36),[G2tensor(56)])
  call ol_merge_tensors(G2tensor(3),[G2tensor(15)])
  call ol_merge_tensors(G2tensor(17),[G2tensor(60)])
call TI_bubble_red(G2tensor(6),12,mass2set(:,1),G0tensor(245),M2L1R1,G0tensor(1),G0tensor(252))
call TI_bubble_red(G2tensor(11),12,mass2set(:,2),G0tensor(259),M2L1R1,G0tensor(266))
call TI_bubble_red(G2tensor(33),12,mass2set(:,3),G0tensor(36),M2L1R1,G0tensor(273))
call TI_bubble_red(G2tensor(10),12,mass2set(:,4),G0tensor(71),M2L1R1,G0tensor(279))
call TI_bubble_red(G2tensor(1),12,mass2set(:,5),G0tensor(285),M2L1R1,G0tensor(101))
call TI_bubble_red(G2tensor(58),9,mass2set(:,6),G0tensor(292),M2L1R1,G0tensor(299),G0tensor(305))
call TI_bubble_red(G2tensor(42),9,mass2set(:,7),G0tensor(311),M2L1R1,G0tensor(317),G0tensor(323))
call TI_bubble_red(G2tensor(20),9,mass2set(:,8),G0tensor(329),M2L1R1,G0tensor(335),G0tensor(341))
call TI_bubble_red(G2tensor(38),9,mass2set(:,9),G0tensor(347),M2L1R1,G0tensor(353))
call TI_bubble_red(G2tensor(50),9,mass2set(:,10),G0tensor(359),M2L1R1,G0tensor(364))
call TI_bubble_red(G2tensor(62),12,mass2set(:,11),G0tensor(369),M2L1R1)
call TI_bubble_red(G2tensor(4),12,mass2set(:,12),G0tensor(131),M2L1R1,G0tensor(28))
call TI_bubble_red(G2tensor(31),12,mass2set(:,13),G0tensor(5),M2L1R1,G0tensor(12))
call TI_bubble_red(G2tensor(9),12,mass2set(:,14),G0tensor(17),M2L1R1,G0tensor(23))
call TI_bubble_red(G2tensor(59),9,mass2set(:,15),G0tensor(35),M2L1R1,G0tensor(152))
call TI_bubble_red(G2tensor(36),9,mass2set(:,16),G0tensor(42),M2L1R1,G0tensor(103))
call TI_bubble_red(G2tensor(3),9,mass2set(:,17),G0tensor(57),M2L1R1,G0tensor(65))
call TI_bubble_red(G2tensor(17),9,mass2set(:,18),G0tensor(74),M2L1R1,G0tensor(79),G0tensor(85))
call TI_bubble_red(G2tensor(34),9,mass2set(:,11),G0tensor(98),M2L1R1)
  call ol_merge_tensors(G0tensor(85),[G0tensor(101),G0tensor(470)])
  call ol_merge_tensors(G0tensor(335),[G0tensor(323),G0tensor(266),G0tensor(1),G0tensor(450)])
  call ol_merge_tensors(G0tensor(299),[G0tensor(252),G0tensor(429)])
  call ol_merge_tensors(G0tensor(364),[G0tensor(353),G0tensor(341),G0tensor(317),G0tensor(305),G0tensor(469),G0tensor(273)])
  call ol_merge_tensors(G0tensor(79),[G0tensor(279),G0tensor(464)])
  call ol_merge_tensors(G0tensor(152),[G0tensor(28)])
  call ol_merge_tensors(G0tensor(103),[G0tensor(12)])
  call ol_merge_tensors(G0tensor(65),[G0tensor(23)])
  call ol_merge_tensors(T0sum(106),[G0tensor(248)])
  call ol_merge_tensors(T0sum(107),[G0tensor(405)])
  call ol_merge_tensors(T0sum(108),[G0tensor(356)])
  call ol_merge_tensors(T0sum(109),[G0tensor(85)])
  call ol_merge_tensors(T0sum(110),[G0tensor(335)])
  call ol_merge_tensors(T0sum(111),[G0tensor(299)])
  call ol_merge_tensors(T0sum(112),[G0tensor(245)])
  call ol_merge_tensors(T0sum(113),[G0tensor(433)])
  call ol_merge_tensors(T0sum(114),[G0tensor(344)])
  call ol_merge_tensors(T0sum(115),[G0tensor(259)])
  call ol_merge_tensors(T0sum(116),[G0tensor(36)])
  call ol_merge_tensors(T0sum(117),[G0tensor(364)])
  call ol_merge_tensors(T0sum(118),[G0tensor(454)])
  call ol_merge_tensors(T0sum(119),[G0tensor(295)])
  call ol_merge_tensors(T0sum(120),[G0tensor(79)])
  call ol_merge_tensors(T0sum(121),[G0tensor(427)])
  call ol_merge_tensors(T0sum(122),[G0tensor(175)])
  call ol_merge_tensors(T0sum(123),[G0tensor(376)])
  call ol_merge_tensors(T0sum(124),[G0tensor(448)])
  call ol_merge_tensors(T0sum(125),[G0tensor(382)])
  call ol_merge_tensors(T0sum(126),[G0tensor(301)])
  call ol_merge_tensors(T0sum(127),[G0tensor(330)])
  call ol_merge_tensors(T0sum(128),[G0tensor(71)])
  call ol_merge_tensors(T0sum(129),[G0tensor(203)])
  call ol_merge_tensors(T0sum(130),[G0tensor(407)])
  call ol_merge_tensors(T0sum(131),[G0tensor(414)])
  call ol_merge_tensors(T0sum(132),[G0tensor(286)])
  call ol_merge_tensors(T0sum(133),[G0tensor(293)])
  call ol_merge_tensors(T0sum(134),[G0tensor(285)])
  call ol_merge_tensors(T0sum(135),[G0tensor(80)])
  call ol_merge_tensors(T0sum(136),[G0tensor(292)])
  call ol_merge_tensors(T0sum(137),[G0tensor(428)])
  call ol_merge_tensors(T0sum(138),[G0tensor(319)])
  call ol_merge_tensors(T0sum(139),[G0tensor(348)])
  call ol_merge_tensors(T0sum(140),[G0tensor(311)])
  call ol_merge_tensors(T0sum(141),[G0tensor(156)])
  call ol_merge_tensors(T0sum(142),[G0tensor(329)])
  call ol_merge_tensors(T0sum(143),[G0tensor(449)])
  call ol_merge_tensors(T0sum(144),[G0tensor(461)])
  call ol_merge_tensors(T0sum(145),[G0tensor(466)])
  call ol_merge_tensors(T0sum(146),[G0tensor(400)])
  call ol_merge_tensors(T0sum(147),[G0tensor(367)])
  call ol_merge_tensors(T0sum(148),[G0tensor(187)])
  call ol_merge_tensors(T0sum(149),[G0tensor(347)])
  call ol_merge_tensors(T0sum(150),[G0tensor(462)])
  call ol_merge_tensors(T0sum(151),[G0tensor(361)])
  call ol_merge_tensors(T0sum(152),[G0tensor(360)])
  call ol_merge_tensors(T0sum(153),[G0tensor(359)])
  call ol_merge_tensors(T0sum(154),[G0tensor(214)])
  call ol_merge_tensors(T0sum(155),[G0tensor(467)])
  call ol_merge_tensors(T0sum(156),[G0tensor(219)])
  call ol_merge_tensors(T0sum(157),[G0tensor(412)])
  call ol_merge_tensors(T0sum(158),[G0tensor(460)])
  call ol_merge_tensors(T0sum(159),[G0tensor(390)])
  call ol_merge_tensors(T0sum(160),[G0tensor(396)])
  call ol_merge_tensors(T0sum(161),[G0tensor(378)])
  call ol_merge_tensors(T0sum(162),[G0tensor(384)])
  call ol_merge_tensors(T0sum(163),[G0tensor(369)])
  call ol_merge_tensors(T0sum(164),[G0tensor(131)])
  call ol_merge_tensors(T0sum(165),[G0tensor(152)])
  call ol_merge_tensors(T0sum(166),[G0tensor(5)])
  call ol_merge_tensors(T0sum(167),[G0tensor(103)])
  call ol_merge_tensors(T0sum(168),[G0tensor(17)])
  call ol_merge_tensors(T0sum(169),[G0tensor(65)])
  call ol_merge_tensors(T0sum(170),[G0tensor(35)])
  call ol_merge_tensors(T0sum(171),[G0tensor(42)])
  call ol_merge_tensors(T0sum(172),[G0tensor(57)])
  call ol_merge_tensors(T0sum(173),[G0tensor(74)])
  call ol_merge_tensors(T0sum(174),[G0tensor(98)])
! end of process


end subroutine vamp_2

end module ol_vamp_2_pptt_ew_ttxbbx_3_/**/REALKIND
