
module ol_vamp_1_pptt_ew_ttxbbx_4_/**/REALKIND
contains

! **********************************************************************
subroutine vamp_1(M)
! P(0:3,nlegs) = incoming external momenta
! Uses tree structures 'wf', factors 'c', and denominators 'den' from loop_pptt_ew_ttxbbx_4.
! Sets colour stripped amplitudes A from the module loop_amplitudes_pptt_ew_ttxbbx_4.
! **********************************************************************
  use KIND_TYPES, only: REALKIND, QREALKIND, intkind2
  use ol_parameters_decl_/**/DREALKIND, only: l_switch
  use ol_parameters_decl_/**/QREALKIND ! masses
  use ol_vert_interface_/**/REALKIND
  use ol_prop_interface_/**/REALKIND
  use ol_last_step_/**/REALKIND
  use ol_tables_storage_pptt_ew_ttxbbx_4_/**/DREALKIND
  use ol_tensor_sum_storage_pptt_ew_ttxbbx_4_/**/REALKIND
  use ol_loop_handling_/**/REALKIND
  use ofred_reduction_/**/REALKIND, only: Hotf_4pt_reduction, Hotf_4pt_reduction_last
  use ofred_reduction_/**/REALKIND, only: Hotf_5pt_reduction, Hotf_5pt_reduction_last
  use ol_loop_reduction_/**/REALKIND, only: TI_bubble_red, TI_triangle_red

  use ol_loop_storage_pptt_ew_ttxbbx_4_/**/REALKIND
#ifndef PRECISION_dp
  use ol_loop_storage_pptt_ew_ttxbbx_4_/**/DREALKIND, only: &
    & p_switch, Hel, merge_step, merge_mism, merge_tables, merge_hels
#endif
  use hol_initialisation_/**/REALKIND, only: G0_hol_initialisation
  use ol_h_vert_interface_/**/REALKIND
  use ol_h_prop_interface_/**/REALKIND
  use ol_h_last_step_/**/REALKIND
  use ol_merging_/**/REALKIND, only: ol_merge, ol_merge_tensors, ol_merge_last

  implicit none

  type(Hpolcont) :: Gcoeff(16)
  type(Hpolcont), intent(in) :: M(2,16)


#ifndef PRECISION_dp
  if (ntryL==1 .OR. p_switch == 1) Gcoeff(:)%hf = Hel
#else
  if (ntryL==1 .OR. p_switch == 2) Gcoeff(:)%hf = Hel
#endif

  ! =============================================


! Dressing, otf merging and otf reduction calls to build loop structures

  Gcoeff(:)%j = (c(33)*M(2,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(1),h0tab(:,1),[8,2,1,4],[nMH,nMT,nMH,nMB],4,0)
  call Hloop_QA_S(ntryL,G0H16(1),ex4(:),G0H8(1),ngH,m3h2x8(:,1),heltab2x16(:,:,1))
  Gcoeff(:)%j = (c(33)*M(2,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(2),h0tab(:,2),[8,2,1,4],[nMZ,nMT,nMH,nMB],4,0)
  call Hloop_QA_S(ntryL,G0H16(1),ex4(:),G0H8(2),ngX,m3h2x8(:,2),heltab2x16(:,:,2))
  Gcoeff(:)%j = (c(33)*M(2,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(3),h0tab(:,3),[8,2,1,4],[nMH,nMT,nMZ,nMB],4,0)
  call Hloop_QA_S(ntryL,G0H16(1),ex4(:),G0H8(3),ngH,m3h2x8(:,3),heltab2x16(:,:,3))
  Gcoeff(:)%j = (c(33)*M(2,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(4),h0tab(:,4),[8,2,1,4],[nMZ,nMT,nMZ,nMB],4,0)
  call Hloop_QA_S(ntryL,G0H16(1),ex4(:),G0H8(4),ngX,m3h2x8(:,4),heltab2x16(:,:,4))
  Gcoeff(:)%j = (c(20)*M(2,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(5),h0tab(:,5),[8,2,1,4],[nMW,nMB,nMW,nMT],4,0)
  call Hloop_QA_S(ntryL,G0H16(1),ex4(:),G0H8(5),ngPbt,m3h2x8(:,5),heltab2x16(:,:,5))
  Gcoeff(:)%j = (c(84)*M(2,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(6),h0tab(:,6),[8,2,1,4],[0,nMT,nMH,nMB],4,0)
  call Hloop_QA_V(ntryL,G0H16(1),ex4(:),G0H8(6),m3h2x8(:,6),heltab2x16(:,:,6))
  Gcoeff(:)%j = (c(84)*M(2,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(7),h0tab(:,7),[8,2,1,4],[0,nMT,nMZ,nMB],4,0)
  call Hloop_QA_V(ntryL,G0H16(1),ex4(:),G0H8(7),m3h2x8(:,7),heltab2x16(:,:,7))
  Gcoeff(:)%j = (-(c(86)*M(2,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(8),h0tab(:,8),[8,2,1,4],[nMZ,nMT,nMH,nMB],4,0)
  call Hloop_QA_Z(ntryL,G0H16(1),ex4(:),G0H8(8),ngZd,m3h2x8(:,8),heltab2x16(:,:,8))
  Gcoeff(:)%j = (-(c(86)*M(2,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(9),h0tab(:,9),[8,2,1,4],[nMZ,nMT,nMZ,nMB],4,0)
  call Hloop_QA_Z(ntryL,G0H16(1),ex4(:),G0H8(9),ngZd,m3h2x8(:,9),heltab2x16(:,:,9))
  Gcoeff(:)%j = (c(38)*M(2,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(10),h0tab(:,10),[8,2,1,4],[nMW,nMB,nMW,nMT],4,0)
  call Hloop_QA_W(ntryL,G0H16(1),ex4(:),G0H8(10),m3h2x8(:,10),heltab2x16(:,:,10))
  Gcoeff(:)%j = (c(84)*M(2,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(11),h0tab(:,11),[8,2,1,4],[nMH,nMT,0,nMB],4,0)
  call Hloop_QA_S(ntryL,G0H16(1),ex4(:),G0H8(11),ngH,m3h2x8(:,11),heltab2x16(:,:,11))
  Gcoeff(:)%j = (c(84)*M(2,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(12),h0tab(:,12),[8,2,1,4],[nMZ,nMT,0,nMB],4,0)
  call Hloop_QA_S(ntryL,G0H16(1),ex4(:),G0H8(12),ngX,m3h2x8(:,12),heltab2x16(:,:,12))
  Gcoeff(:)%j = (-(c(86)*M(2,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(13),h0tab(:,13),[8,2,1,4],[nMH,nMT,nMZ,nMB],4,0)
  call Hloop_QA_S(ntryL,G0H16(1),ex4(:),G0H8(13),ngH,m3h2x8(:,13),heltab2x16(:,:,13))
  Gcoeff(:)%j = (-(c(86)*M(2,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(14),h0tab(:,14),[8,2,1,4],[nMZ,nMT,nMZ,nMB],4,0)
  call Hloop_QA_S(ntryL,G0H16(1),ex4(:),G0H8(14),ngX,m3h2x8(:,14),heltab2x16(:,:,14))
  Gcoeff(:)%j = (c(38)*M(2,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(15),h0tab(:,15),[8,2,1,4],[nMW,nMB,nMW,nMT],4,0)
  call Hloop_QA_S(ntryL,G0H16(1),ex4(:),G0H8(15),ngPbt,m3h2x8(:,15),heltab2x16(:,:,15))
  Gcoeff(:)%j = (c(2)*M(2,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(16),h0tab(:,16),[8,2,1,4],[0,nMT,0,nMB],4,0)
  call Hloop_QA_V(ntryL,G0H16(1),ex4(:),G0H8(16),m3h2x8(:,16),heltab2x16(:,:,16))
  Gcoeff(:)%j = (-(c(5)*M(2,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(17),h0tab(:,17),[8,2,1,4],[nMZ,nMT,0,nMB],4,0)
  call Hloop_QA_Z(ntryL,G0H16(1),ex4(:),G0H8(17),ngZd,m3h2x8(:,17),heltab2x16(:,:,17))
  Gcoeff(:)%j = (-(c(5)*M(2,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(18),h0tab(:,18),[8,2,1,4],[0,nMT,nMZ,nMB],4,0)
  call Hloop_QA_V(ntryL,G0H16(1),ex4(:),G0H8(18),m3h2x8(:,18),heltab2x16(:,:,18))
  Gcoeff(:)%j = (c(7)*M(2,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(19),h0tab(:,19),[8,2,1,4],[nMZ,nMT,nMZ,nMB],4,0)
  call Hloop_QA_Z(ntryL,G0H16(1),ex4(:),G0H8(19),ngZd,m3h2x8(:,19),heltab2x16(:,:,19))
  Gcoeff(:)%j = (c(12)*M(2,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(20),h0tab(:,20),[8,2,1,4],[nMW,nMB,nMW,nMT],4,0)
  call Hloop_QA_W(ntryL,G0H16(1),ex4(:),G0H8(20),m3h2x8(:,20),heltab2x16(:,:,20))
  Gcoeff(:)%j = (c(33)*M(2,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(21),h0tab(:,21),[8,1,2,4],[nMH,nMT,nMH,nMB],4,0)
  call Hloop_QA_S(ntryL,G0H16(1),ex4(:),G0H8(21),ngH,m3h2x8(:,21),heltab2x16(:,:,21))
  Gcoeff(:)%j = (c(33)*M(2,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(22),h0tab(:,22),[8,1,2,4],[nMH,nMT,nMZ,nMB],4,0)
  call Hloop_QA_S(ntryL,G0H16(1),ex4(:),G0H8(22),ngH,m3h2x8(:,22),heltab2x16(:,:,22))
  Gcoeff(:)%j = (c(33)*M(2,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(23),h0tab(:,23),[8,1,2,4],[nMZ,nMT,nMH,nMB],4,0)
  call Hloop_QA_S(ntryL,G0H16(1),ex4(:),G0H8(23),ngX,m3h2x8(:,23),heltab2x16(:,:,23))
  Gcoeff(:)%j = (c(33)*M(2,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(24),h0tab(:,24),[8,1,2,4],[nMZ,nMT,nMZ,nMB],4,0)
  call Hloop_QA_S(ntryL,G0H16(1),ex4(:),G0H8(24),ngX,m3h2x8(:,24),heltab2x16(:,:,24))
  Gcoeff(:)%j = (c(32)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(25),h0tab(:,25),[8,1,2,4],[nMT,nMH,nMT,nMW],4,0)
  call Hloop_SA_Q(ntryL,G0H16(1),ex4(:),G0H8(25),ngPbt,m3h2x8(:,25),heltab2x16(:,:,25))
  call Hloop_A_Q(ntryL,G0H8(25),8,nMT,G1H8(1),n2h8(1))
  Gcoeff(:)%j = (c(21)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(26),h0tab(:,26),[8,1,2,4],[nMB,nMW,nMB,nMH],4,0)
  call Hloop_SA_Q(ntryL,G0H16(1),ex4(:),G0H8(25),ngH,m3h2x8(:,26),heltab2x16(:,:,26))
  call Hloop_A_Q(ntryL,G0H8(25),8,nMB,G1H8(2),n2h8(2))
  Gcoeff(:)%j = (-(c(32)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(27),h0tab(:,27),[8,1,2,4],[nMT,nMZ,nMT,nMW],4,0)
  call Hloop_SA_Q(ntryL,G0H16(1),ex4(:),G0H8(25),ngPbt,m3h2x8(:,27),heltab2x16(:,:,27))
  call Hloop_A_Q(ntryL,G0H8(25),8,nMT,G1H8(3),n2h8(3))
  Gcoeff(:)%j = (-(c(21)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(28),h0tab(:,28),[8,1,2,4],[nMB,nMW,nMB,nMZ],4,0)
  call Hloop_SA_Q(ntryL,G0H16(1),ex4(:),G0H8(25),ngX,m3h2x8(:,28),heltab2x16(:,:,28))
  call Hloop_A_Q(ntryL,G0H8(25),8,nMB,G1H8(4),n2h8(4))
  Gcoeff(:)%j = (c(84)*M(2,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(29),h0tab(:,29),[8,1,2,4],[nMH,nMT,0,nMB],4,0)
  call Hloop_QA_S(ntryL,G0H16(1),ex4(:),G0H8(25),ngH,m3h2x8(:,29),heltab2x16(:,:,29))
  Gcoeff(:)%j = (c(84)*M(2,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(30),h0tab(:,30),[8,1,2,4],[nMZ,nMT,0,nMB],4,0)
  call Hloop_QA_S(ntryL,G0H16(1),ex4(:),G0H8(26),ngX,m3h2x8(:,30),heltab2x16(:,:,30))
  Gcoeff(:)%j = (-(c(86)*M(2,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(31),h0tab(:,31),[8,1,2,4],[nMH,nMT,nMZ,nMB],4,0)
  call Hloop_QA_S(ntryL,G0H16(1),ex4(:),G0H8(27),ngH,m3h2x8(:,31),heltab2x16(:,:,31))
  Gcoeff(:)%j = (-(c(86)*M(2,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(32),h0tab(:,32),[8,1,2,4],[nMZ,nMT,nMZ,nMB],4,0)
  call Hloop_QA_S(ntryL,G0H16(1),ex4(:),G0H8(28),ngX,m3h2x8(:,32),heltab2x16(:,:,32))
  Gcoeff(:)%j = (c(84)*M(2,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(33),h0tab(:,33),[8,1,2,4],[0,nMT,nMH,nMB],4,0)
  call Hloop_QA_V(ntryL,G0H16(1),ex4(:),G0H8(29),m3h2x8(:,33),heltab2x16(:,:,33))
  Gcoeff(:)%j = (c(84)*M(2,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(34),h0tab(:,34),[8,1,2,4],[0,nMT,nMZ,nMB],4,0)
  call Hloop_QA_V(ntryL,G0H16(1),ex4(:),G0H8(30),m3h2x8(:,34),heltab2x16(:,:,34))
  Gcoeff(:)%j = (-(c(86)*M(2,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(35),h0tab(:,35),[8,1,2,4],[nMZ,nMT,nMH,nMB],4,0)
  call Hloop_QA_Z(ntryL,G0H16(1),ex4(:),G0H8(31),ngZd,m3h2x8(:,35),heltab2x16(:,:,35))
  Gcoeff(:)%j = (-(c(86)*M(2,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(36),h0tab(:,36),[8,1,2,4],[nMZ,nMT,nMZ,nMB],4,0)
  call Hloop_QA_Z(ntryL,G0H16(1),ex4(:),G0H8(32),ngZd,m3h2x8(:,36),heltab2x16(:,:,36))
  Gcoeff(:)%j = (-(c(74)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(37),h0tab(:,37),[8,1,2,4],[nMB,nMW,nMB,0],4,0)
  call Hloop_VA_Q(ntryL,G0H16(1),ex4(:),G0H8(33),m3h2x8(:,37),heltab2x16(:,:,37))
  call Hloop_A_Q(ntryL,G0H8(33),8,nMB,G1H8(5),n2h8(5))
  Gcoeff(:)%j = (-(c(79)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(38),h0tab(:,38),[8,1,2,4],[nMB,nMW,nMB,nMZ],4,0)
  call Hloop_ZA_Q(ntryL,G0H16(1),ex4(:),G0H8(33),ngZd,m3h2x8(:,38),heltab2x16(:,:,38))
  call Hloop_A_Q(ntryL,G0H8(33),8,nMB,G1H8(6),n2h8(6))
  Gcoeff(:)%j = (c(46)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(39),h0tab(:,39),[8,1,2,4],[nMT,nMH,nMT,nMW],4,0)
  call Hloop_WA_Q(ntryL,G0H16(1),ex4(:),G0H8(33),m3h2x8(:,39),heltab2x16(:,:,39))
  call Hloop_A_Q(ntryL,G0H8(33),8,nMT,G1H8(7),n2h8(7))
  Gcoeff(:)%j = (-(c(46)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(40),h0tab(:,40),[8,1,2,4],[nMT,nMZ,nMT,nMW],4,0)
  call Hloop_WA_Q(ntryL,G0H16(1),ex4(:),G0H8(33),m3h2x8(:,40),heltab2x16(:,:,40))
  call Hloop_A_Q(ntryL,G0H8(33),8,nMT,G1H8(8),n2h8(8))
  Gcoeff(:)%j = (-(c(77)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(41),h0tab(:,41),[8,1,2,4],[nMT,0,nMT,nMW],4,0)
  call Hloop_SA_Q(ntryL,G0H16(1),ex4(:),G0H8(33),ngPbt,m3h2x8(:,41),heltab2x16(:,:,41))
  call Hloop_A_Q(ntryL,G0H8(33),8,nMT,G1H8(9),n2h8(9))
  Gcoeff(:)%j = (-(c(79)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(42),h0tab(:,42),[8,1,2,4],[nMT,nMZ,nMT,nMW],4,0)
  call Hloop_SA_Q(ntryL,G0H16(1),ex4(:),G0H8(33),ngPbt,m3h2x8(:,42),heltab2x16(:,:,42))
  call Hloop_A_Q(ntryL,G0H8(33),8,nMT,G1H8(10),n2h8(10))
  Gcoeff(:)%j = (c(40)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(43),h0tab(:,43),[8,1,2,4],[nMB,nMW,nMB,nMH],4,0)
  call Hloop_SA_Q(ntryL,G0H16(1),ex4(:),G0H8(33),ngH,m3h2x8(:,43),heltab2x16(:,:,43))
  call Hloop_A_Q(ntryL,G0H8(33),8,nMB,G1H8(11),n2h8(11))
  Gcoeff(:)%j = (-(c(40)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(44),h0tab(:,44),[8,1,2,4],[nMB,nMW,nMB,nMZ],4,0)
  call Hloop_SA_Q(ntryL,G0H16(1),ex4(:),G0H8(33),ngX,m3h2x8(:,44),heltab2x16(:,:,44))
  call Hloop_A_Q(ntryL,G0H8(33),8,nMB,G1H8(12),n2h8(12))
  Gcoeff(:)%j = (c(2)*M(2,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(45),h0tab(:,45),[8,1,2,4],[0,nMT,0,nMB],4,0)
  call Hloop_QA_V(ntryL,G0H16(1),ex4(:),G0H8(33),m3h2x8(:,45),heltab2x16(:,:,45))
  Gcoeff(:)%j = (-(c(5)*M(2,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(46),h0tab(:,46),[8,1,2,4],[0,nMT,nMZ,nMB],4,0)
  call Hloop_QA_V(ntryL,G0H16(1),ex4(:),G0H8(34),m3h2x8(:,46),heltab2x16(:,:,46))
  Gcoeff(:)%j = (-(c(5)*M(2,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(47),h0tab(:,47),[8,1,2,4],[nMZ,nMT,0,nMB],4,0)
  call Hloop_QA_Z(ntryL,G0H16(1),ex4(:),G0H8(35),ngZd,m3h2x8(:,47),heltab2x16(:,:,47))
  Gcoeff(:)%j = (c(7)*M(2,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(48),h0tab(:,48),[8,1,2,4],[nMZ,nMT,nMZ,nMB],4,0)
  call Hloop_QA_Z(ntryL,G0H16(1),ex4(:),G0H8(36),ngZd,m3h2x8(:,48),heltab2x16(:,:,48))
  Gcoeff(:)%j = (-(c(63)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(49),h0tab(:,49),[8,1,2,4],[nMT,0,nMT,nMW],4,0)
  call Hloop_WA_Q(ntryL,G0H16(1),ex4(:),G0H8(37),m3h2x8(:,49),heltab2x16(:,:,49))
  call Hloop_A_Q(ntryL,G0H8(37),8,nMT,G1H8(13),n2h8(13))
  Gcoeff(:)%j = (-(c(60)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(50),h0tab(:,50),[8,1,2,4],[nMB,nMW,nMB,0],4,0)
  call Hloop_VA_Q(ntryL,G0H16(1),ex4(:),G0H8(37),m3h2x8(:,50),heltab2x16(:,:,50))
  call Hloop_A_Q(ntryL,G0H8(37),8,nMB,G1H8(14),n2h8(14))
  Gcoeff(:)%j = (-(c(65)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(51),h0tab(:,51),[8,1,2,4],[nMT,nMZ,nMT,nMW],4,0)
  call Hloop_WA_Q(ntryL,G0H16(1),ex4(:),G0H8(37),m3h2x8(:,51),heltab2x16(:,:,51))
  call Hloop_A_Q(ntryL,G0H8(37),8,nMT,G1H8(15),n2h8(15))
  Gcoeff(:)%j = (-(c(65)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(52),h0tab(:,52),[8,1,2,4],[nMB,nMW,nMB,nMZ],4,0)
  call Hloop_ZA_Q(ntryL,G0H16(1),ex4(:),G0H8(37),ngZd,m3h2x8(:,52),heltab2x16(:,:,52))
  call Hloop_A_Q(ntryL,G0H8(37),8,nMB,G1H8(16),n2h8(16))
  Gcoeff(:)%j = (c(24)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(53),h0tab(:,53),[8,1,4,2],[nMT,nMH,nMB,nMW],4,0)
  call Hloop_SA_Q(ntryL,G0H16(1),ex4(:),G0H8(37),ngPbt,m3h2x8(:,53),heltab2x16(:,:,53))
  call Hloop_A_Q(ntryL,G0H8(37),8,nMT,G1H8(17),n2h8(17))
  Gcoeff(:)%j = (c(24)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(54),h0tab(:,54),[8,1,4,2],[nMB,nMW,nMT,nMH],4,0)
  call Hloop_SA_Q(ntryL,G0H16(1),ex4(:),G0H8(37),ngH,m3h2x8(:,54),heltab2x16(:,:,54))
  call Hloop_A_Q(ntryL,G0H8(37),8,nMB,G1H8(18),n2h8(18))
  Gcoeff(:)%j = (c(24)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(55),h0tab(:,55),[8,1,4,2],[nMT,nMZ,nMB,nMW],4,0)
  call Hloop_SA_Q(ntryL,G0H16(1),ex4(:),G0H8(37),ngPbt,m3h2x8(:,55),heltab2x16(:,:,55))
  call Hloop_A_Q(ntryL,G0H8(37),8,nMT,G1H8(19),n2h8(19))
  Gcoeff(:)%j = (c(24)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(56),h0tab(:,56),[8,1,4,2],[nMB,nMW,nMT,nMZ],4,0)
  call Hloop_SA_Q(ntryL,G0H16(1),ex4(:),G0H8(37),ngX,m3h2x8(:,56),heltab2x16(:,:,56))
  call Hloop_A_Q(ntryL,G0H8(37),8,nMB,G1H8(20),n2h8(20))
  Gcoeff(:)%j = (c(75)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(57),h0tab(:,57),[8,1,4,2],[nMB,nMW,nMT,0],4,0)
  call Hloop_VA_Q(ntryL,G0H16(1),ex4(:),G0H8(37),m3h2x8(:,57),heltab2x16(:,:,57))
  call Hloop_A_Q(ntryL,G0H8(37),8,nMB,G1H8(21),n2h8(21))
  Gcoeff(:)%j = (-(c(79)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(58),h0tab(:,58),[8,1,4,2],[nMB,nMW,nMT,nMZ],4,0)
  call Hloop_ZA_Q(ntryL,G0H16(1),ex4(:),G0H8(37),ngZd,m3h2x8(:,58),heltab2x16(:,:,58))
  call Hloop_A_Q(ntryL,G0H8(37),8,nMB,G1H8(22),n2h8(22))
  Gcoeff(:)%j = (c(44)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(59),h0tab(:,59),[8,1,4,2],[nMT,nMH,nMB,nMW],4,0)
  call Hloop_WA_Q(ntryL,G0H16(1),ex4(:),G0H8(37),m3h2x8(:,59),heltab2x16(:,:,59))
  call Hloop_A_Q(ntryL,G0H8(37),8,nMT,G1H8(23),n2h8(23))
  Gcoeff(:)%j = (c(44)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(60),h0tab(:,60),[8,1,4,2],[nMT,nMZ,nMB,nMW],4,0)
  call Hloop_WA_Q(ntryL,G0H16(1),ex4(:),G0H8(37),m3h2x8(:,60),heltab2x16(:,:,60))
  call Hloop_A_Q(ntryL,G0H8(37),8,nMT,G1H8(24),n2h8(24))
  Gcoeff(:)%j = (c(75)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(61),h0tab(:,61),[8,1,4,2],[nMT,0,nMB,nMW],4,0)
  call Hloop_SA_Q(ntryL,G0H16(1),ex4(:),G0H8(37),ngPbt,m3h2x8(:,61),heltab2x16(:,:,61))
  call Hloop_A_Q(ntryL,G0H8(37),8,nMT,G1H8(25),n2h8(25))
  Gcoeff(:)%j = (-(c(79)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(62),h0tab(:,62),[8,1,4,2],[nMT,nMZ,nMB,nMW],4,0)
  call Hloop_SA_Q(ntryL,G0H16(1),ex4(:),G0H8(37),ngPbt,m3h2x8(:,62),heltab2x16(:,:,62))
  call Hloop_A_Q(ntryL,G0H8(37),8,nMT,G1H8(26),n2h8(26))
  Gcoeff(:)%j = (c(44)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(63),h0tab(:,63),[8,1,4,2],[nMB,nMW,nMT,nMH],4,0)
  call Hloop_SA_Q(ntryL,G0H16(1),ex4(:),G0H8(37),ngH,m3h2x8(:,63),heltab2x16(:,:,63))
  call Hloop_A_Q(ntryL,G0H8(37),8,nMB,G1H8(27),n2h8(27))
  Gcoeff(:)%j = (c(44)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(64),h0tab(:,64),[8,1,4,2],[nMB,nMW,nMT,nMZ],4,0)
  call Hloop_SA_Q(ntryL,G0H16(1),ex4(:),G0H8(37),ngX,m3h2x8(:,64),heltab2x16(:,:,64))
  call Hloop_A_Q(ntryL,G0H8(37),8,nMB,G1H8(28),n2h8(28))
  Gcoeff(:)%j = (c(61)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(65),h0tab(:,65),[8,1,4,2],[nMT,0,nMB,nMW],4,0)
  call Hloop_WA_Q(ntryL,G0H16(1),ex4(:),G0H8(37),m3h2x8(:,65),heltab2x16(:,:,65))
  call Hloop_A_Q(ntryL,G0H8(37),8,nMT,G1H8(29),n2h8(29))
  Gcoeff(:)%j = (c(61)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(66),h0tab(:,66),[8,1,4,2],[nMB,nMW,nMT,0],4,0)
  call Hloop_VA_Q(ntryL,G0H16(1),ex4(:),G0H8(37),m3h2x8(:,66),heltab2x16(:,:,66))
  call Hloop_A_Q(ntryL,G0H8(37),8,nMB,G1H8(30),n2h8(30))
  Gcoeff(:)%j = (-(c(65)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(67),h0tab(:,67),[8,1,4,2],[nMT,nMZ,nMB,nMW],4,0)
  call Hloop_WA_Q(ntryL,G0H16(1),ex4(:),G0H8(37),m3h2x8(:,67),heltab2x16(:,:,67))
  call Hloop_A_Q(ntryL,G0H8(37),8,nMT,G1H8(31),n2h8(31))
  Gcoeff(:)%j = (-(c(65)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(68),h0tab(:,68),[8,1,4,2],[nMB,nMW,nMT,nMZ],4,0)
  call Hloop_ZA_Q(ntryL,G0H16(1),ex4(:),G0H8(37),ngZd,m3h2x8(:,68),heltab2x16(:,:,68))
  call Hloop_A_Q(ntryL,G0H8(37),8,nMB,G1H8(32),n2h8(32))
  call Hloop_SA_Q(ntryL,G0H8(1),ex2(:),G0H4(1),ngH,m3h2x4(:,1),heltab2x8(:,:,1))
  call Hloop_A_Q(ntryL,G0H4(1),10,nMT,G1H4(1),n2h4(1))
  call Hloop_SA_Q(ntryL,G0H8(2),ex2(:),G0H4(1),ngX,m3h2x4(:,2),heltab2x8(:,:,2))
  call Hloop_A_Q(ntryL,G0H4(1),10,nMT,G1H4(2),n2h4(2))
  call Hloop_SA_Q(ntryL,G0H8(3),ex2(:),G0H4(1),ngH,m3h2x4(:,3),heltab2x8(:,:,3))
  call Hloop_A_Q(ntryL,G0H4(1),10,nMT,G1H4(3),n2h4(3))
  call Hloop_SA_Q(ntryL,G0H8(4),ex2(:),G0H4(1),ngX,m3h2x4(:,4),heltab2x8(:,:,4))
  call Hloop_A_Q(ntryL,G0H4(1),10,nMT,G1H4(4),n2h4(4))
  call Hloop_SA_Q(ntryL,G0H8(5),ex2(:),G0H4(1),ngPtb,m3h2x4(:,5),heltab2x8(:,:,5))
  call Hloop_A_Q(ntryL,G0H4(1),10,nMB,G1H4(5),n2h4(5))
  call Hloop_VA_Q(ntryL,G0H8(6),ex2(:),G0H4(1),m3h2x4(:,6),heltab2x8(:,:,6))
  call Hloop_A_Q(ntryL,G0H4(1),10,nMT,G1H4(6),n2h4(6))
  call Hloop_VA_Q(ntryL,G0H8(7),ex2(:),G0H4(1),m3h2x4(:,7),heltab2x8(:,:,7))
  call Hloop_A_Q(ntryL,G0H4(1),10,nMT,G1H4(7),n2h4(7))
  call Hloop_ZA_Q(ntryL,G0H8(8),ex2(:),G0H4(1),ngZu,m3h2x4(:,8),heltab2x8(:,:,8))
  call Hloop_A_Q(ntryL,G0H4(1),10,nMT,G1H4(8),n2h4(8))
  call Hloop_ZA_Q(ntryL,G0H8(9),ex2(:),G0H4(1),ngZu,m3h2x4(:,9),heltab2x8(:,:,9))
  call Hloop_A_Q(ntryL,G0H4(1),10,nMT,G1H4(9),n2h4(9))
  call Hloop_WA_Q(ntryL,G0H8(10),ex2(:),G0H4(1),m3h2x4(:,10),heltab2x8(:,:,10))
  call Hloop_A_Q(ntryL,G0H4(1),10,nMB,G1H4(10),n2h4(10))
  call Hloop_SA_Q(ntryL,G0H8(11),ex2(:),G0H4(1),ngH,m3h2x4(:,11),heltab2x8(:,:,11))
  call Hloop_A_Q(ntryL,G0H4(1),10,nMT,G1H4(11),n2h4(11))
  call Hloop_SA_Q(ntryL,G0H8(12),ex2(:),G0H4(1),ngX,m3h2x4(:,12),heltab2x8(:,:,12))
  call Hloop_A_Q(ntryL,G0H4(1),10,nMT,G1H4(12),n2h4(12))
  call Hloop_SA_Q(ntryL,G0H8(13),ex2(:),G0H4(1),ngH,m3h2x4(:,13),heltab2x8(:,:,13))
  call Hloop_A_Q(ntryL,G0H4(1),10,nMT,G1H4(13),n2h4(13))
  call Hloop_SA_Q(ntryL,G0H8(14),ex2(:),G0H4(1),ngX,m3h2x4(:,14),heltab2x8(:,:,14))
  call Hloop_A_Q(ntryL,G0H4(1),10,nMT,G1H4(14),n2h4(14))
  call Hloop_SA_Q(ntryL,G0H8(15),ex2(:),G0H4(1),ngPtb,m3h2x4(:,15),heltab2x8(:,:,15))
  call Hloop_A_Q(ntryL,G0H4(1),10,nMB,G1H4(15),n2h4(15))
  call Hloop_VA_Q(ntryL,G0H8(16),ex2(:),G0H4(1),m3h2x4(:,16),heltab2x8(:,:,16))
  call Hloop_A_Q(ntryL,G0H4(1),10,nMT,G1H4(16),n2h4(16))
  call Hloop_ZA_Q(ntryL,G0H8(17),ex2(:),G0H4(1),ngZu,m3h2x4(:,17),heltab2x8(:,:,17))
  call Hloop_A_Q(ntryL,G0H4(1),10,nMT,G1H4(17),n2h4(17))
  call Hloop_VA_Q(ntryL,G0H8(18),ex2(:),G0H4(1),m3h2x4(:,18),heltab2x8(:,:,18))
  call Hloop_A_Q(ntryL,G0H4(1),10,nMT,G1H4(18),n2h4(18))
  call Hloop_ZA_Q(ntryL,G0H8(19),ex2(:),G0H4(1),ngZu,m3h2x4(:,19),heltab2x8(:,:,19))
  call Hloop_A_Q(ntryL,G0H4(1),10,nMT,G1H4(19),n2h4(19))
  call Hloop_WA_Q(ntryL,G0H8(20),ex2(:),G0H4(1),m3h2x4(:,20),heltab2x8(:,:,20))
  call Hloop_A_Q(ntryL,G0H4(1),10,nMB,G1H4(20),n2h4(20))
  call Hloop_SQ_A(ntryL,G0H8(21),ex1(:),G0H4(1),ngH,m3h2x4(:,21),heltab2x8(:,:,21))
  call Hloop_Q_A(ntryL,G0H4(1),9,nMT,G1H4(21),n2h4(21))
  call Hloop_SQ_A(ntryL,G0H8(22),ex1(:),G0H4(1),ngH,m3h2x4(:,22),heltab2x8(:,:,22))
  call Hloop_Q_A(ntryL,G0H4(1),9,nMT,G1H4(22),n2h4(22))
  call Hloop_SQ_A(ntryL,G0H8(23),ex1(:),G0H4(1),ngX,m3h2x4(:,23),heltab2x8(:,:,23))
  call Hloop_Q_A(ntryL,G0H4(1),9,nMT,G1H4(23),n2h4(23))
  call Hloop_SQ_A(ntryL,G0H8(24),ex1(:),G0H4(1),ngX,m3h2x4(:,24),heltab2x8(:,:,24))
  call Hloop_Q_A(ntryL,G0H4(1),9,nMT,G1H4(24),n2h4(24))
  call Hloop_AQ_S(ntryL,G1H8(1),ex1(:),G1H4(25),ngH,m3h2x4(:,25),heltab2x8(:,:,25))
  call Hloop_AQ_S(ntryL,G1H8(2),ex1(:),G1H4(26),ngPbt,m3h2x4(:,26),heltab2x8(:,:,26))
  call Hloop_AQ_S(ntryL,G1H8(3),ex1(:),G1H4(27),ngX,m3h2x4(:,27),heltab2x8(:,:,27))
  call Hloop_AQ_S(ntryL,G1H8(4),ex1(:),G1H4(28),ngPbt,m3h2x4(:,28),heltab2x8(:,:,28))
  call Hloop_SQ_A(ntryL,G0H8(25),ex1(:),G0H4(1),ngH,m3h2x4(:,29),heltab2x8(:,:,29))
  call Hloop_Q_A(ntryL,G0H4(1),9,nMT,G1H4(29),n2h4(25))
  call Hloop_SQ_A(ntryL,G0H8(26),ex1(:),G0H4(1),ngX,m3h2x4(:,30),heltab2x8(:,:,30))
  call Hloop_Q_A(ntryL,G0H4(1),9,nMT,G1H4(30),n2h4(26))
  call Hloop_SQ_A(ntryL,G0H8(27),ex1(:),G0H4(1),ngH,m3h2x4(:,31),heltab2x8(:,:,31))
  call Hloop_Q_A(ntryL,G0H4(1),9,nMT,G1H4(31),n2h4(27))
  call Hloop_SQ_A(ntryL,G0H8(28),ex1(:),G0H4(1),ngX,m3h2x4(:,32),heltab2x8(:,:,32))
  call Hloop_Q_A(ntryL,G0H4(1),9,nMT,G1H4(32),n2h4(28))
  call Hloop_VQ_A(ntryL,G0H8(29),ex1(:),G0H4(1),m3h2x4(:,33),heltab2x8(:,:,33))
  call Hloop_Q_A(ntryL,G0H4(1),9,nMT,G1H4(33),n2h4(29))
  call Hloop_VQ_A(ntryL,G0H8(30),ex1(:),G0H4(1),m3h2x4(:,34),heltab2x8(:,:,34))
  call Hloop_Q_A(ntryL,G0H4(1),9,nMT,G1H4(34),n2h4(30))
  call Hloop_ZQ_A(ntryL,G0H8(31),ex1(:),G0H4(1),ngZu,m3h2x4(:,35),heltab2x8(:,:,35))
  call Hloop_Q_A(ntryL,G0H4(1),9,nMT,G1H4(35),n2h4(31))
  call Hloop_ZQ_A(ntryL,G0H8(32),ex1(:),G0H4(1),ngZu,m3h2x4(:,36),heltab2x8(:,:,36))
  call Hloop_Q_A(ntryL,G0H4(1),9,nMT,G1H4(36),n2h4(32))
  call Hloop_AQ_S(ntryL,G1H8(5),ex1(:),G1H4(37),ngPbt,m3h2x4(:,37),heltab2x8(:,:,37))
  call Hloop_AQ_S(ntryL,G1H8(6),ex1(:),G1H4(38),ngPbt,m3h2x4(:,38),heltab2x8(:,:,38))
  call Hloop_AQ_S(ntryL,G1H8(7),ex1(:),G1H4(39),ngH,m3h2x4(:,39),heltab2x8(:,:,39))
  call Hloop_AQ_S(ntryL,G1H8(8),ex1(:),G1H4(40),ngX,m3h2x4(:,40),heltab2x8(:,:,40))
  call Hloop_AQ_V(ntryL,G1H8(9),ex1(:),G1H4(41),m3h2x4(:,41),heltab2x8(:,:,41))
  call Hloop_AQ_Z(ntryL,G1H8(10),ex1(:),G1H4(42),ngZu,m3h2x4(:,42),heltab2x8(:,:,42))
  call Hloop_AQ_W(ntryL,G1H8(11),ex1(:),G1H4(43),m3h2x4(:,43),heltab2x8(:,:,43))
  call Hloop_AQ_W(ntryL,G1H8(12),ex1(:),G1H4(44),m3h2x4(:,44),heltab2x8(:,:,44))
  call Hloop_VQ_A(ntryL,G0H8(33),ex1(:),G0H4(1),m3h2x4(:,45),heltab2x8(:,:,45))
  call Hloop_Q_A(ntryL,G0H4(1),9,nMT,G1H4(45),n2h4(33))
  call Hloop_VQ_A(ntryL,G0H8(34),ex1(:),G0H4(1),m3h2x4(:,46),heltab2x8(:,:,46))
  call Hloop_Q_A(ntryL,G0H4(1),9,nMT,G1H4(46),n2h4(34))
  call Hloop_ZQ_A(ntryL,G0H8(35),ex1(:),G0H4(1),ngZu,m3h2x4(:,47),heltab2x8(:,:,47))
  call Hloop_Q_A(ntryL,G0H4(1),9,nMT,G1H4(47),n2h4(35))
  call Hloop_ZQ_A(ntryL,G0H8(36),ex1(:),G0H4(1),ngZu,m3h2x4(:,48),heltab2x8(:,:,48))
  call Hloop_Q_A(ntryL,G0H4(1),9,nMT,G1H4(48),n2h4(36))
  call Hloop_AQ_V(ntryL,G1H8(13),ex1(:),G1H4(49),m3h2x4(:,49),heltab2x8(:,:,49))
  call Hloop_AQ_W(ntryL,G1H8(14),ex1(:),G1H4(50),m3h2x4(:,50),heltab2x8(:,:,50))
  call Hloop_AQ_Z(ntryL,G1H8(15),ex1(:),G1H4(51),ngZu,m3h2x4(:,51),heltab2x8(:,:,51))
  call Hloop_AQ_W(ntryL,G1H8(16),ex1(:),G1H4(52),m3h2x4(:,52),heltab2x8(:,:,52))
  call Hloop_AQ_S(ntryL,G1H8(17),ex1(:),G1H4(53),ngH,m3h2x4(:,53),heltab2x8(:,:,53))
  call Hloop_AQ_S(ntryL,G1H8(18),ex1(:),G1H4(54),ngPbt,m3h2x4(:,54),heltab2x8(:,:,54))
  call Hloop_AQ_S(ntryL,G1H8(19),ex1(:),G1H4(55),ngX,m3h2x4(:,55),heltab2x8(:,:,55))
  call Hloop_AQ_S(ntryL,G1H8(20),ex1(:),G1H4(56),ngPbt,m3h2x4(:,56),heltab2x8(:,:,56))
  call Hloop_AQ_S(ntryL,G1H8(21),ex1(:),G1H4(57),ngPbt,m3h2x4(:,57),heltab2x8(:,:,57))
  call Hloop_AQ_S(ntryL,G1H8(22),ex1(:),G1H4(58),ngPbt,m3h2x4(:,58),heltab2x8(:,:,58))
  call Hloop_AQ_S(ntryL,G1H8(23),ex1(:),G1H4(59),ngH,m3h2x4(:,59),heltab2x8(:,:,59))
  call Hloop_AQ_S(ntryL,G1H8(24),ex1(:),G1H4(60),ngX,m3h2x4(:,60),heltab2x8(:,:,60))
  call Hloop_AQ_V(ntryL,G1H8(25),ex1(:),G1H4(61),m3h2x4(:,61),heltab2x8(:,:,61))
  call Hloop_AQ_Z(ntryL,G1H8(26),ex1(:),G1H4(62),ngZu,m3h2x4(:,62),heltab2x8(:,:,62))
  call Hloop_AQ_W(ntryL,G1H8(27),ex1(:),G1H4(63),m3h2x4(:,63),heltab2x8(:,:,63))
  call Hloop_AQ_W(ntryL,G1H8(28),ex1(:),G1H4(64),m3h2x4(:,64),heltab2x8(:,:,64))
  call Hloop_AQ_V(ntryL,G1H8(29),ex1(:),G1H4(65),m3h2x4(:,65),heltab2x8(:,:,65))
  call Hloop_AQ_W(ntryL,G1H8(30),ex1(:),G1H4(66),m3h2x4(:,66),heltab2x8(:,:,66))
  call Hloop_AQ_Z(ntryL,G1H8(31),ex1(:),G1H4(67),ngZu,m3h2x4(:,67),heltab2x8(:,:,67))
  call Hloop_AQ_W(ntryL,G1H8(32),ex1(:),G1H4(68),m3h2x4(:,68),heltab2x8(:,:,68))
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(8),[G1H4(2)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(9),[G1H4(4)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(10),[G1H4(5)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(17),[G1H4(12)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(19),[G1H4(14)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(20),[G1H4(15)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(35),[G1H4(23)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(36),[G1H4(24)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(47),[G1H4(30)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(48),[G1H4(32)])
  call Hloop_AQ_S(ntryL,G1H4(1),ex1(:),G1H2(1),ngH,m3h2x2(:,1),heltab2x4(:,:,1))
  call Hloop_AQ_S(ntryL,G1H4(8),ex1(:),G1H2(2),ngH,m3h2x2(:,2),heltab2x4(:,:,2))
  call Hloop_AQ_S(ntryL,G1H4(3),ex1(:),G1H2(3),ngX,m3h2x2(:,3),heltab2x4(:,:,3))
  call Hloop_AQ_S(ntryL,G1H4(9),ex1(:),G1H2(4),ngX,m3h2x2(:,4),heltab2x4(:,:,4))
  call Hloop_AQ_S(ntryL,G1H4(10),ex1(:),G1H2(5),ngPbt,m3h2x2(:,5),heltab2x4(:,:,5))
  call Hloop_AQ_S(ntryL,G1H4(6),ex1(:),G1H2(6),ngH,m3h2x2(:,6),heltab2x4(:,:,6))
  call Hloop_AQ_S(ntryL,G1H4(7),ex1(:),G1H2(7),ngX,m3h2x2(:,7),heltab2x4(:,:,7))
  call Hloop_AQ_V(ntryL,G1H4(11),ex1(:),G1H2(8),m3h2x2(:,8),heltab2x4(:,:,8))
  call Hloop_AQ_V(ntryL,G1H4(17),ex1(:),G1H2(9),m3h2x2(:,9),heltab2x4(:,:,9))
  call Hloop_AQ_Z(ntryL,G1H4(13),ex1(:),G1H2(10),ngZu,m3h2x2(:,10),heltab2x4(:,:,10))
  call Hloop_AQ_Z(ntryL,G1H4(19),ex1(:),G1H2(11),ngZu,m3h2x2(:,11),heltab2x4(:,:,11))
  call Hloop_AQ_W(ntryL,G1H4(20),ex1(:),G1H2(12),m3h2x2(:,12),heltab2x4(:,:,12))
  call Hloop_AQ_V(ntryL,G1H4(16),ex1(:),G1H2(13),m3h2x2(:,13),heltab2x4(:,:,13))
  call Hloop_AQ_Z(ntryL,G1H4(18),ex1(:),G1H2(14),ngZu,m3h2x2(:,14),heltab2x4(:,:,14))
  call Hloop_QA_S(ntryL,G1H4(21),ex2(:),G1H2(15),ngH,m3h2x2(:,15),heltab2x4(:,:,15))
  call Hloop_QA_S(ntryL,G1H4(22),ex2(:),G1H2(16),ngX,m3h2x2(:,16),heltab2x4(:,:,16))
  call Hloop_QA_S(ntryL,G1H4(35),ex2(:),G1H2(17),ngH,m3h2x2(:,17),heltab2x4(:,:,17))
  call Hloop_QA_S(ntryL,G1H4(36),ex2(:),G1H2(18),ngX,m3h2x2(:,18),heltab2x4(:,:,18))
  call Hloop_SA_Q(ntryL,G1H4(25),ex2(:),G1H2(19),ngH,m3h2x2(:,19),heltab2x4(:,:,19))
  call Hloop_A_Q(ntryL,G1H2(19),11,nMT,G2H2(1),n2h2(1))
  call Hloop_SA_Q(ntryL,G1H4(26),ex2(:),G1H2(19),ngPtb,m3h2x2(:,20),heltab2x4(:,:,20))
  call Hloop_A_Q(ntryL,G1H2(19),11,nMB,G2H2(2),n2h2(2))
  call Hloop_SA_Q(ntryL,G1H4(27),ex2(:),G1H2(19),ngX,m3h2x2(:,21),heltab2x4(:,:,21))
  call Hloop_A_Q(ntryL,G1H2(19),11,nMT,G2H2(3),n2h2(3))
  call Hloop_SA_Q(ntryL,G1H4(28),ex2(:),G1H2(19),ngPtb,m3h2x2(:,22),heltab2x4(:,:,22))
  call Hloop_A_Q(ntryL,G1H2(19),11,nMB,G2H2(4),n2h2(4))
  call Hloop_QA_V(ntryL,G1H4(29),ex2(:),G1H2(19),m3h2x2(:,23),heltab2x4(:,:,23))
  call Hloop_QA_V(ntryL,G1H4(47),ex2(:),G1H2(20),m3h2x2(:,24),heltab2x4(:,:,24))
  call Hloop_QA_Z(ntryL,G1H4(31),ex2(:),G1H2(21),ngZu,m3h2x2(:,25),heltab2x4(:,:,25))
  call Hloop_QA_Z(ntryL,G1H4(48),ex2(:),G1H2(22),ngZu,m3h2x2(:,26),heltab2x4(:,:,26))
  call Hloop_QA_S(ntryL,G1H4(33),ex2(:),G1H2(23),ngH,m3h2x2(:,27),heltab2x4(:,:,27))
  call Hloop_QA_S(ntryL,G1H4(34),ex2(:),G1H2(24),ngX,m3h2x2(:,28),heltab2x4(:,:,28))
  call Hloop_SA_Q(ntryL,G1H4(37),ex2(:),G1H2(25),ngPtb,m3h2x2(:,29),heltab2x4(:,:,29))
  call Hloop_A_Q(ntryL,G1H2(25),11,nMB,G2H2(5),n2h2(5))
  call Hloop_SA_Q(ntryL,G1H4(38),ex2(:),G1H2(25),ngPtb,m3h2x2(:,30),heltab2x4(:,:,30))
  call Hloop_A_Q(ntryL,G1H2(25),11,nMB,G2H2(6),n2h2(6))
  call Hloop_SA_Q(ntryL,G1H4(39),ex2(:),G1H2(25),ngH,m3h2x2(:,31),heltab2x4(:,:,31))
  call Hloop_A_Q(ntryL,G1H2(25),11,nMT,G2H2(7),n2h2(7))
  call Hloop_SA_Q(ntryL,G1H4(40),ex2(:),G1H2(25),ngX,m3h2x2(:,32),heltab2x4(:,:,32))
  call Hloop_A_Q(ntryL,G1H2(25),11,nMT,G2H2(8),n2h2(8))
  call Hloop_VA_Q(ntryL,G1H4(41),ex2(:),G1H2(25),m3h2x2(:,33),heltab2x4(:,:,33))
  call Hloop_A_Q(ntryL,G1H2(25),11,nMT,G2H2(9),n2h2(9))
  call Hloop_ZA_Q(ntryL,G1H4(42),ex2(:),G1H2(25),ngZu,m3h2x2(:,34),heltab2x4(:,:,34))
  call Hloop_A_Q(ntryL,G1H2(25),11,nMT,G2H2(10),n2h2(10))
  call Hloop_WA_Q(ntryL,G1H4(43),ex2(:),G1H2(25),m3h2x2(:,35),heltab2x4(:,:,35))
  call Hloop_A_Q(ntryL,G1H2(25),11,nMB,G2H2(11),n2h2(11))
  call Hloop_WA_Q(ntryL,G1H4(44),ex2(:),G1H2(25),m3h2x2(:,36),heltab2x4(:,:,36))
  call Hloop_A_Q(ntryL,G1H2(25),11,nMB,G2H2(12),n2h2(12))
  call Hloop_QA_V(ntryL,G1H4(45),ex2(:),G1H2(25),m3h2x2(:,37),heltab2x4(:,:,37))
  call Hloop_QA_Z(ntryL,G1H4(46),ex2(:),G1H2(26),ngZu,m3h2x2(:,38),heltab2x4(:,:,38))
  call Hloop_VA_Q(ntryL,G1H4(49),ex2(:),G1H2(27),m3h2x2(:,39),heltab2x4(:,:,39))
  call Hloop_A_Q(ntryL,G1H2(27),11,nMT,G2H2(13),n2h2(13))
  call Hloop_WA_Q(ntryL,G1H4(50),ex2(:),G1H2(27),m3h2x2(:,40),heltab2x4(:,:,40))
  call Hloop_A_Q(ntryL,G1H2(27),11,nMB,G2H2(14),n2h2(14))
  call Hloop_ZA_Q(ntryL,G1H4(51),ex2(:),G1H2(27),ngZu,m3h2x2(:,41),heltab2x4(:,:,41))
  call Hloop_A_Q(ntryL,G1H2(27),11,nMT,G2H2(15),n2h2(15))
  call Hloop_WA_Q(ntryL,G1H4(52),ex2(:),G1H2(27),m3h2x2(:,42),heltab2x4(:,:,42))
  call Hloop_A_Q(ntryL,G1H2(27),11,nMB,G2H2(16),n2h2(16))
  call Hloop_SQ_A(ntryL,G1H4(53),ex3(:),G1H2(27),ngH,m3h2x2(:,43),heltab2x4(:,:,43))
  call Hloop_Q_A(ntryL,G1H2(27),13,nMB,G2H2(17),n2h2(17))
  call Hloop_SQ_A(ntryL,G1H4(54),ex3(:),G1H2(27),ngPtb,m3h2x2(:,44),heltab2x4(:,:,44))
  call Hloop_Q_A(ntryL,G1H2(27),13,nMT,G2H2(18),n2h2(18))
  call Hloop_SQ_A(ntryL,G1H4(55),ex3(:),G1H2(27),ngX,m3h2x2(:,45),heltab2x4(:,:,45))
  call Hloop_Q_A(ntryL,G1H2(27),13,nMB,G2H2(19),n2h2(19))
  call Hloop_SQ_A(ntryL,G1H4(56),ex3(:),G1H2(27),ngPtb,m3h2x2(:,46),heltab2x4(:,:,46))
  call Hloop_Q_A(ntryL,G1H2(27),13,nMT,G2H2(20),n2h2(20))
  call Hloop_SQ_A(ntryL,G1H4(57),ex3(:),G1H2(27),ngPtb,m3h2x2(:,47),heltab2x4(:,:,47))
  call Hloop_Q_A(ntryL,G1H2(27),13,nMT,G2H2(21),n2h2(21))
  call Hloop_SQ_A(ntryL,G1H4(58),ex3(:),G1H2(27),ngPtb,m3h2x2(:,48),heltab2x4(:,:,48))
  call Hloop_Q_A(ntryL,G1H2(27),13,nMT,G2H2(22),n2h2(22))
  call Hloop_SQ_A(ntryL,G1H4(59),ex3(:),G1H2(27),ngH,m3h2x2(:,49),heltab2x4(:,:,49))
  call Hloop_Q_A(ntryL,G1H2(27),13,nMB,G2H2(23),n2h2(23))
  call Hloop_SQ_A(ntryL,G1H4(60),ex3(:),G1H2(27),ngX,m3h2x2(:,50),heltab2x4(:,:,50))
  call Hloop_Q_A(ntryL,G1H2(27),13,nMB,G2H2(24),n2h2(24))
  call Hloop_VQ_A(ntryL,G1H4(61),ex3(:),G1H2(27),m3h2x2(:,51),heltab2x4(:,:,51))
  call Hloop_Q_A(ntryL,G1H2(27),13,nMB,G2H2(25),n2h2(25))
  call Hloop_ZQ_A(ntryL,G1H4(62),ex3(:),G1H2(27),ngZd,m3h2x2(:,52),heltab2x4(:,:,52))
  call Hloop_Q_A(ntryL,G1H2(27),13,nMB,G2H2(26),n2h2(26))
  call Hloop_WQ_A(ntryL,G1H4(63),ex3(:),G1H2(27),m3h2x2(:,53),heltab2x4(:,:,53))
  call Hloop_Q_A(ntryL,G1H2(27),13,nMT,G2H2(27),n2h2(27))
  call Hloop_WQ_A(ntryL,G1H4(64),ex3(:),G1H2(27),m3h2x2(:,54),heltab2x4(:,:,54))
  call Hloop_Q_A(ntryL,G1H2(27),13,nMT,G2H2(28),n2h2(28))
  call Hloop_VQ_A(ntryL,G1H4(65),ex3(:),G1H2(27),m3h2x2(:,55),heltab2x4(:,:,55))
  call Hloop_Q_A(ntryL,G1H2(27),13,nMB,G2H2(29),n2h2(29))
  call Hloop_WQ_A(ntryL,G1H4(66),ex3(:),G1H2(27),m3h2x2(:,56),heltab2x4(:,:,56))
  call Hloop_Q_A(ntryL,G1H2(27),13,nMT,G2H2(30),n2h2(30))
  call Hloop_ZQ_A(ntryL,G1H4(67),ex3(:),G1H2(27),ngZd,m3h2x2(:,57),heltab2x4(:,:,57))
  call Hloop_Q_A(ntryL,G1H2(27),13,nMB,G2H2(31),n2h2(31))
  call Hloop_WQ_A(ntryL,G1H4(68),ex3(:),G1H2(27),m3h2x2(:,58),heltab2x4(:,:,58))
  call Hloop_Q_A(ntryL,G1H2(27),13,nMT,G2H2(32),n2h2(32))
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(11),[G2H2(2)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(10),[G2H2(3)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(12),[G2H2(4)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(14),[G2H2(5)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(16),[G2H2(6)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(15),[G2H2(8)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(27),[G2H2(18)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(26),[G2H2(19)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(28),[G2H2(20)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(30),[G2H2(21)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(32),[G2H2(22)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(31),[G2H2(24)])
  call Hloop_SQ_A(ntryL,G1H2(1),ex3(:),G1H1(1),ngH,m3h2x1(:,1),heltab2x2(:,:,1))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),15,nMB,G2tensor(1),n2h1(1))
  call Hloop_SQ_A(ntryL,G1H2(2),ex3(:),G1H1(1),ngH,m3h2x1(:,2),heltab2x2(:,:,2))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),15,nMB,G2tensor(2),n2h1(2))
  call Hloop_SQ_A(ntryL,G1H2(3),ex3(:),G1H1(1),ngX,m3h2x1(:,3),heltab2x2(:,:,3))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),15,nMB,G2tensor(3),n2h1(3))
  call Hloop_SQ_A(ntryL,G1H2(4),ex3(:),G1H1(1),ngX,m3h2x1(:,4),heltab2x2(:,:,4))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),15,nMB,G2tensor(4),n2h1(4))
  call Hloop_SQ_A(ntryL,G1H2(5),ex3(:),G1H1(1),ngPtb,m3h2x1(:,5),heltab2x2(:,:,5))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),15,nMT,G2tensor(5),n2h1(5))
  call Hloop_SQ_A(ntryL,G1H2(6),ex3(:),G1H1(1),ngH,m3h2x1(:,6),heltab2x2(:,:,6))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),15,nMB,G2tensor(6),n2h1(6))
  call Hloop_SQ_A(ntryL,G1H2(7),ex3(:),G1H1(1),ngX,m3h2x1(:,7),heltab2x2(:,:,7))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),15,nMB,G2tensor(7),n2h1(7))
  call Hloop_VQ_A(ntryL,G1H2(8),ex3(:),G1H1(1),m3h2x1(:,8),heltab2x2(:,:,8))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),15,nMB,G2tensor(8),n2h1(8))
  call Hloop_VQ_A(ntryL,G1H2(9),ex3(:),G1H1(1),m3h2x1(:,9),heltab2x2(:,:,9))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),15,nMB,G2tensor(9),n2h1(9))
  call Hloop_ZQ_A(ntryL,G1H2(10),ex3(:),G1H1(1),ngZd,m3h2x1(:,10),heltab2x2(:,:,10))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),15,nMB,G2tensor(10),n2h1(10))
  call Hloop_ZQ_A(ntryL,G1H2(11),ex3(:),G1H1(1),ngZd,m3h2x1(:,11),heltab2x2(:,:,11))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),15,nMB,G2tensor(11),n2h1(11))
  call Hloop_WQ_A(ntryL,G1H2(12),ex3(:),G1H1(1),m3h2x1(:,12),heltab2x2(:,:,12))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),15,nMT,G2tensor(12),n2h1(12))
  call Hloop_VQ_A(ntryL,G1H2(13),ex3(:),G1H1(1),m3h2x1(:,13),heltab2x2(:,:,13))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),15,nMB,G2tensor(13),n2h1(13))
  call Hloop_ZQ_A(ntryL,G1H2(14),ex3(:),G1H1(1),ngZd,m3h2x1(:,14),heltab2x2(:,:,14))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),15,nMB,G2tensor(14),n2h1(14))
  call Hloop_SQ_A(ntryL,G1H2(15),ex3(:),G1H1(1),ngH,m3h2x1(:,15),heltab2x2(:,:,15))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),15,nMB,G2tensor(15),n2h1(15))
  call Hloop_SQ_A(ntryL,G1H2(16),ex3(:),G1H1(1),ngX,m3h2x1(:,16),heltab2x2(:,:,16))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),15,nMB,G2tensor(16),n2h1(16))
  call Hloop_SQ_A(ntryL,G1H2(17),ex3(:),G1H1(1),ngH,m3h2x1(:,17),heltab2x2(:,:,17))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),15,nMB,G2tensor(17),n2h1(17))
  call Hloop_SQ_A(ntryL,G1H2(18),ex3(:),G1H1(1),ngX,m3h2x1(:,18),heltab2x2(:,:,18))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),15,nMB,G2tensor(18),n2h1(18))
  call Hcheck_last_AQ_S(ntryL,l_switch,G2H2(1),ex3(:),G2tensor(19),ngPtb,m3h2x1(:,19),heltab2x2(:,:,19))
  call Hcheck_last_AQ_S(ntryL,l_switch,G2H2(11),ex3(:),G2tensor(20),ngH,m3h2x1(:,20),heltab2x2(:,:,20))
  call Hcheck_last_AQ_S(ntryL,l_switch,G2H2(10),ex3(:),G2tensor(21),ngPtb,m3h2x1(:,21),heltab2x2(:,:,21))
  call Hcheck_last_AQ_S(ntryL,l_switch,G2H2(12),ex3(:),G2tensor(22),ngX,m3h2x1(:,22),heltab2x2(:,:,22))
  call Hloop_VQ_A(ntryL,G1H2(19),ex3(:),G1H1(1),m3h2x1(:,23),heltab2x2(:,:,23))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),15,nMB,G2tensor(23),n2h1(19))
  call Hloop_VQ_A(ntryL,G1H2(20),ex3(:),G1H1(1),m3h2x1(:,24),heltab2x2(:,:,24))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),15,nMB,G2tensor(24),n2h1(20))
  call Hloop_ZQ_A(ntryL,G1H2(21),ex3(:),G1H1(1),ngZd,m3h2x1(:,25),heltab2x2(:,:,25))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),15,nMB,G2tensor(25),n2h1(21))
  call Hloop_ZQ_A(ntryL,G1H2(22),ex3(:),G1H1(1),ngZd,m3h2x1(:,26),heltab2x2(:,:,26))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),15,nMB,G2tensor(26),n2h1(22))
  call Hloop_SQ_A(ntryL,G1H2(23),ex3(:),G1H1(1),ngH,m3h2x1(:,27),heltab2x2(:,:,27))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),15,nMB,G2tensor(27),n2h1(23))
  call Hloop_SQ_A(ntryL,G1H2(24),ex3(:),G1H1(1),ngX,m3h2x1(:,28),heltab2x2(:,:,28))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),15,nMB,G2tensor(28),n2h1(24))
  call Hcheck_last_AQ_V(ntryL,l_switch,G2H2(14),ex3(:),G2tensor(29),m3h2x1(:,29),heltab2x2(:,:,29))
  call Hcheck_last_AQ_Z(ntryL,l_switch,G2H2(16),ex3(:),G2tensor(30),ngZd,m3h2x1(:,30),heltab2x2(:,:,30))
  call Hcheck_last_AQ_W(ntryL,l_switch,G2H2(7),ex3(:),G2tensor(31),m3h2x1(:,31),heltab2x2(:,:,31))
  call Hcheck_last_AQ_W(ntryL,l_switch,G2H2(15),ex3(:),G2tensor(32),m3h2x1(:,32),heltab2x2(:,:,32))
  call Hcheck_last_AQ_S(ntryL,l_switch,G2H2(9),ex3(:),G2tensor(33),ngPtb,m3h2x1(:,33),heltab2x2(:,:,33))
  call Hloop_VQ_A(ntryL,G1H2(25),ex3(:),G1H1(1),m3h2x1(:,34),heltab2x2(:,:,34))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),15,nMB,G2tensor(34),n2h1(25))
  call Hloop_ZQ_A(ntryL,G1H2(26),ex3(:),G1H1(1),ngZd,m3h2x1(:,35),heltab2x2(:,:,35))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),15,nMB,G2tensor(35),n2h1(26))
  call Hcheck_last_AQ_W(ntryL,l_switch,G2H2(13),ex3(:),G2tensor(36),m3h2x1(:,36),heltab2x2(:,:,36))
  call Hcheck_last_QA_S(ntryL,l_switch,G2H2(17),ex2(:),G2tensor(37),ngPtb,m3h2x1(:,37),heltab2x2(:,:,37))
  call Hcheck_last_QA_S(ntryL,l_switch,G2H2(27),ex2(:),G2tensor(38),ngH,m3h2x1(:,38),heltab2x2(:,:,38))
  call Hcheck_last_QA_S(ntryL,l_switch,G2H2(26),ex2(:),G2tensor(39),ngPtb,m3h2x1(:,39),heltab2x2(:,:,39))
  call Hcheck_last_QA_S(ntryL,l_switch,G2H2(28),ex2(:),G2tensor(40),ngX,m3h2x1(:,40),heltab2x2(:,:,40))
  call Hcheck_last_QA_V(ntryL,l_switch,G2H2(30),ex2(:),G2tensor(41),m3h2x1(:,41),heltab2x2(:,:,41))
  call Hcheck_last_QA_Z(ntryL,l_switch,G2H2(32),ex2(:),G2tensor(42),ngZu,m3h2x1(:,42),heltab2x2(:,:,42))
  call Hcheck_last_QA_W(ntryL,l_switch,G2H2(23),ex2(:),G2tensor(43),m3h2x1(:,43),heltab2x2(:,:,43))
  call Hcheck_last_QA_W(ntryL,l_switch,G2H2(31),ex2(:),G2tensor(44),m3h2x1(:,44),heltab2x2(:,:,44))
  call Hcheck_last_QA_S(ntryL,l_switch,G2H2(25),ex2(:),G2tensor(45),ngPtb,m3h2x1(:,45),heltab2x2(:,:,45))
  call Hcheck_last_QA_W(ntryL,l_switch,G2H2(29),ex2(:),G2tensor(46),m3h2x1(:,46),heltab2x2(:,:,46))
  call ol_merge_tensors(G2tensor(10),[G2tensor(3)])
  call ol_merge_tensors(G2tensor(11),[G2tensor(4)])
  call ol_merge_tensors(G2tensor(12),[G2tensor(5)])
  call ol_merge_tensors(G2tensor(14),[G2tensor(7)])
  call ol_merge_tensors(G2tensor(25),[G2tensor(16)])
  call ol_merge_tensors(G2tensor(26),[G2tensor(18)])
  call ol_merge_tensors(G2tensor(31),[G2tensor(19)])
  call ol_merge_tensors(G2tensor(32),[G2tensor(21)])
  call ol_merge_tensors(G2tensor(30),[G2tensor(22)])
  call ol_merge_tensors(G2tensor(35),[G2tensor(28)])
  call ol_merge_tensors(G2tensor(36),[G2tensor(33)])
  call ol_merge_tensors(G2tensor(43),[G2tensor(37)])
  call ol_merge_tensors(G2tensor(44),[G2tensor(39)])
  call ol_merge_tensors(G2tensor(42),[G2tensor(40)])
  call ol_merge_tensors(G2tensor(46),[G2tensor(45)])
  call Hotf_4pt_reduction_last(G2tensor(1),RedSet_4(1),mass4set(:,1),  & 
G1tensor(1),G1tensor(2),G1tensor(3),G1tensor(4),G1tensor(5))
  call G_TensorShift(G1tensor(2),4)
  call Hotf_4pt_reduction_last(G2tensor(2),RedSet_4(1),mass4set(:,2),  & 
G1tensor(6),G1tensor(7),G1tensor(8),G1tensor(9),G1tensor(10))
  call G_TensorShift(G1tensor(7),4)
  call Hotf_4pt_reduction_last(G2tensor(10),RedSet_4(1),mass4set(:,3),  & 
G1tensor(11),G1tensor(12),G1tensor(13),G1tensor(14),G1tensor(15))
  call G_TensorShift(G1tensor(12),4)
  call Hotf_4pt_reduction_last(G2tensor(11),RedSet_4(1),mass4set(:,4),  & 
G1tensor(16),G1tensor(17),G1tensor(18),G1tensor(19),G1tensor(20))
  call G_TensorShift(G1tensor(17),4)
  call Hotf_4pt_reduction_last(G2tensor(12),RedSet_4(1),mass4set(:,5),  & 
G1tensor(21),G1tensor(22),G1tensor(23),G1tensor(24),G1tensor(25))
  call G_TensorShift(G1tensor(22),4)
  call Hotf_4pt_reduction_last(G2tensor(6),RedSet_4(1),mass4set(:,6),  & 
G1tensor(26),G1tensor(27),G1tensor(28),G1tensor(29),G1tensor(30))
  call G_TensorShift(G1tensor(27),4)
  call Hotf_4pt_reduction_last(G2tensor(14),RedSet_4(1),mass4set(:,7),  & 
G1tensor(31),G1tensor(32),G1tensor(33),G1tensor(34),G1tensor(35))
  call G_TensorShift(G1tensor(32),4)
  call Hotf_4pt_reduction_last(G2tensor(8),RedSet_4(1),mass4set(:,8),  & 
G1tensor(36),G1tensor(37),G1tensor(38),G1tensor(39),G1tensor(40))
  call G_TensorShift(G1tensor(37),4)
  call Hotf_4pt_reduction_last(G2tensor(9),RedSet_4(1),mass4set(:,9),  & 
G1tensor(41),G1tensor(42),G1tensor(43),G1tensor(44),G1tensor(45))
  call G_TensorShift(G1tensor(42),4)
  call Hotf_4pt_reduction_last(G2tensor(13),RedSet_4(1),mass4set(:,10),  & 
G1tensor(46),G1tensor(47),G1tensor(48),G1tensor(49),G1tensor(50))
  call G_TensorShift(G1tensor(47),4)
  call Hotf_4pt_reduction_last(G2tensor(15),RedSet_4(2),mass4set(:,1),  & 
G1tensor(51),G1tensor(52),G1tensor(53),G1tensor(54),G1tensor(55))
  call G_TensorShift(G1tensor(52),4)
  call Hotf_4pt_reduction_last(G2tensor(25),RedSet_4(2),mass4set(:,3),  & 
G1tensor(56),G1tensor(57),G1tensor(58),G1tensor(59),G1tensor(60))
  call G_TensorShift(G1tensor(57),4)
  call Hotf_4pt_reduction_last(G2tensor(17),RedSet_4(2),mass4set(:,2),  & 
G1tensor(61),G1tensor(62),G1tensor(63),G1tensor(64),G1tensor(65))
  call G_TensorShift(G1tensor(62),4)
  call Hotf_4pt_reduction_last(G2tensor(26),RedSet_4(2),mass4set(:,4),  & 
G1tensor(66),G1tensor(67),G1tensor(68),G1tensor(69),G1tensor(70))
  call G_TensorShift(G1tensor(67),4)
  call Hotf_4pt_reduction_last(G2tensor(31),RedSet_4(2),mass4set(:,11),  & 
G1tensor(71),G1tensor(72),G1tensor(73),G1tensor(74),G1tensor(75))
  call G_TensorShift(G1tensor(72),4)
  call Hotf_4pt_reduction_last(G2tensor(20),RedSet_4(2),mass4set(:,12),  & 
G1tensor(76),G1tensor(77),G1tensor(78),G1tensor(79),G1tensor(80))
  call G_TensorShift(G1tensor(77),4)
  call Hotf_4pt_reduction_last(G2tensor(32),RedSet_4(2),mass4set(:,13),  & 
G1tensor(81),G1tensor(82),G1tensor(83),G1tensor(84),G1tensor(85))
  call G_TensorShift(G1tensor(82),4)
  call Hotf_4pt_reduction_last(G2tensor(30),RedSet_4(2),mass4set(:,14),  & 
G1tensor(86),G1tensor(87),G1tensor(88),G1tensor(89),G1tensor(90))
  call G_TensorShift(G1tensor(87),4)
  call Hotf_4pt_reduction_last(G2tensor(23),RedSet_4(2),mass4set(:,8),  & 
G1tensor(91),G1tensor(92),G1tensor(93),G1tensor(94),G1tensor(95))
  call G_TensorShift(G1tensor(92),4)
  call Hotf_4pt_reduction_last(G2tensor(24),RedSet_4(2),mass4set(:,9),  & 
G1tensor(96),G1tensor(97),G1tensor(98),G1tensor(99),G1tensor(100))
  call G_TensorShift(G1tensor(97),4)
  call Hotf_4pt_reduction_last(G2tensor(27),RedSet_4(2),mass4set(:,6),  & 
G1tensor(101),G1tensor(102),G1tensor(103),G1tensor(104),G1tensor(105))
  call G_TensorShift(G1tensor(102),4)
  call Hotf_4pt_reduction_last(G2tensor(35),RedSet_4(2),mass4set(:,7),  & 
G1tensor(106),G1tensor(107),G1tensor(108),G1tensor(109),G1tensor(110))
  call G_TensorShift(G1tensor(107),4)
  call Hotf_4pt_reduction_last(G2tensor(29),RedSet_4(2),mass4set(:,15),  & 
G1tensor(111),G1tensor(112),G1tensor(113),G1tensor(114),G1tensor(115))
  call G_TensorShift(G1tensor(112),4)
  call Hotf_4pt_reduction_last(G2tensor(36),RedSet_4(2),mass4set(:,16),  & 
G1tensor(116),G1tensor(117),G1tensor(118),G1tensor(119),G1tensor(120))
  call G_TensorShift(G1tensor(117),4)
  call Hotf_4pt_reduction_last(G2tensor(34),RedSet_4(2),mass4set(:,10),  & 
G1tensor(121),G1tensor(122),G1tensor(123),G1tensor(124),G1tensor(125))
  call G_TensorShift(G1tensor(122),4)
  call Hotf_4pt_reduction_last(G2tensor(43),RedSet_4(3),mass4set(:,17),  & 
G1tensor(126),G1tensor(127),G1tensor(128),G1tensor(129),G1tensor(130))
  call G_TensorShift(G1tensor(127),2)
  call Hotf_4pt_reduction_last(G2tensor(38),RedSet_4(3),mass4set(:,18),  & 
G1tensor(131),G1tensor(132),G1tensor(133),G1tensor(134),G1tensor(135))
  call G_TensorShift(G1tensor(132),2)
  call Hotf_4pt_reduction_last(G2tensor(44),RedSet_4(3),mass4set(:,19),  & 
G1tensor(136),G1tensor(137),G1tensor(138),G1tensor(139),G1tensor(140))
  call G_TensorShift(G1tensor(137),2)
  call Hotf_4pt_reduction_last(G2tensor(42),RedSet_4(3),mass4set(:,20),  & 
G1tensor(141),G1tensor(142),G1tensor(143),G1tensor(144),G1tensor(145))
  call G_TensorShift(G1tensor(142),2)
  call Hotf_4pt_reduction_last(G2tensor(41),RedSet_4(3),mass4set(:,21),  & 
G1tensor(146),G1tensor(147),G1tensor(148),G1tensor(149),G1tensor(150))
  call G_TensorShift(G1tensor(147),2)
  call Hotf_4pt_reduction_last(G2tensor(46),RedSet_4(3),mass4set(:,22),  & 
G1tensor(151),G1tensor(152),G1tensor(153),G1tensor(154),G1tensor(155))
  call G_TensorShift(G1tensor(152),2)
  call Hotf_4pt_reduction_last(G1tensor(1),RedSet_4(1),mass4set(:,1),  & 
G0tensor(1),G0tensor(2),G0tensor(3),G0tensor(4),G0tensor(5))
  call Hotf_4pt_reduction_last(G1tensor(6),RedSet_4(1),mass4set(:,2),  & 
G0tensor(6),G0tensor(7),G0tensor(8),G0tensor(9),G0tensor(10))
  call Hotf_4pt_reduction_last(G1tensor(11),RedSet_4(1),mass4set(:,3),  & 
G0tensor(11),G0tensor(12),G0tensor(13),G0tensor(14),G0tensor(15))
  call Hotf_4pt_reduction_last(G1tensor(16),RedSet_4(1),mass4set(:,4),  & 
G0tensor(16),G0tensor(17),G0tensor(18),G0tensor(19),G0tensor(20))
  call Hotf_4pt_reduction_last(G1tensor(21),RedSet_4(1),mass4set(:,5),  & 
G0tensor(21),G0tensor(22),G0tensor(23),G0tensor(24),G0tensor(25))
  call Hotf_4pt_reduction_last(G1tensor(26),RedSet_4(1),mass4set(:,6),  & 
G0tensor(26),G0tensor(27),G0tensor(28),G0tensor(29),G0tensor(30))
  call Hotf_4pt_reduction_last(G1tensor(31),RedSet_4(1),mass4set(:,7),  & 
G0tensor(31),G0tensor(32),G0tensor(33),G0tensor(34),G0tensor(35))
  call Hotf_4pt_reduction_last(G1tensor(36),RedSet_4(1),mass4set(:,8),  & 
G0tensor(36),G0tensor(37),G0tensor(38),G0tensor(39),G0tensor(40))
  call Hotf_4pt_reduction_last(G1tensor(41),RedSet_4(1),mass4set(:,9),  & 
G0tensor(41),G0tensor(42),G0tensor(43),G0tensor(44),G0tensor(45))
  call Hotf_4pt_reduction_last(G1tensor(46),RedSet_4(1),mass4set(:,10),  & 
G0tensor(46),G0tensor(47),G0tensor(48),G0tensor(49),G0tensor(50))
  call Hotf_4pt_reduction_last(G1tensor(51),RedSet_4(2),mass4set(:,1),  & 
G0tensor(51),G0tensor(52),G0tensor(53),G0tensor(54),G0tensor(55))
  call Hotf_4pt_reduction_last(G1tensor(56),RedSet_4(2),mass4set(:,3),  & 
G0tensor(56),G0tensor(57),G0tensor(58),G0tensor(59),G0tensor(60))
  call Hotf_4pt_reduction_last(G1tensor(61),RedSet_4(2),mass4set(:,2),  & 
G0tensor(61),G0tensor(62),G0tensor(63),G0tensor(64),G0tensor(65))
  call Hotf_4pt_reduction_last(G1tensor(66),RedSet_4(2),mass4set(:,4),  & 
G0tensor(66),G0tensor(67),G0tensor(68),G0tensor(69),G0tensor(70))
  call Hotf_4pt_reduction_last(G1tensor(71),RedSet_4(2),mass4set(:,11),  & 
G0tensor(71),G0tensor(72),G0tensor(73),G0tensor(74),G0tensor(75))
  call Hotf_4pt_reduction_last(G1tensor(76),RedSet_4(2),mass4set(:,12),  & 
G0tensor(76),G0tensor(77),G0tensor(78),G0tensor(79),G0tensor(80))
  call Hotf_4pt_reduction_last(G1tensor(81),RedSet_4(2),mass4set(:,13),  & 
G0tensor(81),G0tensor(82),G0tensor(83),G0tensor(84),G0tensor(85))
  call Hotf_4pt_reduction_last(G1tensor(86),RedSet_4(2),mass4set(:,14),  & 
G0tensor(86),G0tensor(87),G0tensor(88),G0tensor(89),G0tensor(90))
  call Hotf_4pt_reduction_last(G1tensor(91),RedSet_4(2),mass4set(:,8),  & 
G0tensor(91),G0tensor(92),G0tensor(93),G0tensor(94),G0tensor(95))
  call Hotf_4pt_reduction_last(G1tensor(96),RedSet_4(2),mass4set(:,9),  & 
G0tensor(96),G0tensor(97),G0tensor(98),G0tensor(99),G0tensor(100))
  call Hotf_4pt_reduction_last(G1tensor(101),RedSet_4(2),mass4set(:,6),  & 
G0tensor(101),G0tensor(102),G0tensor(103),G0tensor(104),G0tensor(105))
  call Hotf_4pt_reduction_last(G1tensor(106),RedSet_4(2),mass4set(:,7),  & 
G0tensor(106),G0tensor(107),G0tensor(108),G0tensor(109),G0tensor(110))
  call Hotf_4pt_reduction_last(G1tensor(111),RedSet_4(2),mass4set(:,15),  & 
G0tensor(111),G0tensor(112),G0tensor(113),G0tensor(114),G0tensor(115))
  call Hotf_4pt_reduction_last(G1tensor(116),RedSet_4(2),mass4set(:,16),  & 
G0tensor(116),G0tensor(117),G0tensor(118),G0tensor(119),G0tensor(120))
  call Hotf_4pt_reduction_last(G1tensor(121),RedSet_4(2),mass4set(:,10),  & 
G0tensor(121),G0tensor(122),G0tensor(123),G0tensor(124),G0tensor(125))
  call Hotf_4pt_reduction_last(G1tensor(126),RedSet_4(3),mass4set(:,17),  & 
G0tensor(126),G0tensor(127),G0tensor(128),G0tensor(129),G0tensor(130))
  call Hotf_4pt_reduction_last(G1tensor(131),RedSet_4(3),mass4set(:,18),  & 
G0tensor(131),G0tensor(132),G0tensor(133),G0tensor(134),G0tensor(135))
  call Hotf_4pt_reduction_last(G1tensor(136),RedSet_4(3),mass4set(:,19),  & 
G0tensor(136),G0tensor(137),G0tensor(138),G0tensor(139),G0tensor(140))
  call Hotf_4pt_reduction_last(G1tensor(141),RedSet_4(3),mass4set(:,20),  & 
G0tensor(141),G0tensor(142),G0tensor(143),G0tensor(144),G0tensor(145))
  call Hotf_4pt_reduction_last(G1tensor(146),RedSet_4(3),mass4set(:,21),  & 
G0tensor(146),G0tensor(147),G0tensor(148),G0tensor(149),G0tensor(150))
  call Hotf_4pt_reduction_last(G1tensor(151),RedSet_4(3),mass4set(:,22),  & 
G0tensor(151),G0tensor(152),G0tensor(153),G0tensor(154),G0tensor(155))
  call ol_merge_tensors(T0sum(1),[G0tensor(1)])
  call ol_merge_tensors(T0sum(2),[G0tensor(6)])
  call ol_merge_tensors(T0sum(3),[G0tensor(11)])
  call ol_merge_tensors(T0sum(4),[G0tensor(16)])
  call ol_merge_tensors(T0sum(5),[G0tensor(21)])
  call ol_merge_tensors(T0sum(6),[G0tensor(26)])
  call ol_merge_tensors(T0sum(7),[G0tensor(31)])
  call ol_merge_tensors(T0sum(8),[G0tensor(36)])
  call ol_merge_tensors(T0sum(9),[G0tensor(41)])
  call ol_merge_tensors(T0sum(10),[G0tensor(46)])
  call ol_merge_tensors(T0sum(11),[G0tensor(51)])
  call ol_merge_tensors(T0sum(12),[G0tensor(56)])
  call ol_merge_tensors(T0sum(13),[G0tensor(61)])
  call ol_merge_tensors(T0sum(14),[G0tensor(66)])
  call ol_merge_tensors(T0sum(15),[G0tensor(71)])
  call ol_merge_tensors(T0sum(16),[G0tensor(76)])
  call ol_merge_tensors(T0sum(17),[G0tensor(81)])
  call ol_merge_tensors(T0sum(18),[G0tensor(86)])
  call ol_merge_tensors(T0sum(19),[G0tensor(91)])
  call ol_merge_tensors(T0sum(20),[G0tensor(96)])
  call ol_merge_tensors(T0sum(21),[G0tensor(101)])
  call ol_merge_tensors(T0sum(22),[G0tensor(106)])
  call ol_merge_tensors(T0sum(23),[G0tensor(111)])
  call ol_merge_tensors(T0sum(24),[G0tensor(116)])
  call ol_merge_tensors(T0sum(25),[G0tensor(121)])
  call ol_merge_tensors(T0sum(26),[G0tensor(126)])
  call ol_merge_tensors(T0sum(27),[G0tensor(131)])
  call ol_merge_tensors(T0sum(28),[G0tensor(136)])
  call ol_merge_tensors(T0sum(29),[G0tensor(141)])
  call ol_merge_tensors(T0sum(30),[G0tensor(146)])
  call ol_merge_tensors(T0sum(31),[G0tensor(151)])
  Gcoeff(:)%j = (c(25)*M(2,:)%j) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(69),h0tab(:,69),[8,3,4],[nMB,nMB,nMH],3,1,wf4(:,1))
  call Hloop_SA_Q(ntryL,G0H16(1),ex4(:),G0H8(37),ngH,m3h2x8(:,69),heltab2x16(:,:,69))
  call Hloop_A_Q(ntryL,G0H8(37),8,nMB,G1H8(1),n2h8(33))
  Gcoeff(:)%j = (-(c(25)*M(2,:)%j)) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(70),h0tab(:,70),[8,3,4],[nMB,nMB,nMZ],3,1,wf4(:,1))
  call Hloop_SA_Q(ntryL,G0H16(1),ex4(:),G0H8(1),ngX,m3h2x8(:,70),heltab2x16(:,:,70))
  call Hloop_A_Q(ntryL,G0H8(1),8,nMB,G1H8(2),n2h8(34))
  Gcoeff(:)%j = (-(c(32)*M(2,:)%j)) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(71),h0tab(:,71),[8,3,4],[nMT,nMT,nMW],3,1,wf4(:,1))
  call Hloop_SA_Q(ntryL,G0H16(1),ex4(:),G0H8(2),ngPbt,m3h2x8(:,71),heltab2x16(:,:,71))
  call Hloop_A_Q(ntryL,G0H8(2),8,nMT,G1H8(3),n2h8(35))
  Gcoeff(:)%j = (c(25)*M(2,:)%j) * den(2)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(72),h0tab(:,72),[8,3,4],[nMB,nMB,nMH],3,1,wf4(:,3))
  call Hloop_SA_Q(ntryL,G0H16(1),ex4(:),G0H8(3),ngH,m3h2x8(:,72),heltab2x16(:,:,72))
  call Hloop_A_Q(ntryL,G0H8(3),8,nMB,G1H8(4),n2h8(36))
  Gcoeff(:)%j = (-(c(25)*M(2,:)%j)) * den(2)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(73),h0tab(:,73),[8,3,4],[nMB,nMB,nMZ],3,1,wf4(:,3))
  call Hloop_SA_Q(ntryL,G0H16(1),ex4(:),G0H8(4),ngX,m3h2x8(:,73),heltab2x16(:,:,73))
  call Hloop_A_Q(ntryL,G0H8(4),8,nMB,G1H8(5),n2h8(37))
  Gcoeff(:)%j = (c(32)*M(2,:)%j) * den(2)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(74),h0tab(:,74),[8,3,4],[nMT,nMT,nMW],3,1,wf4(:,3))
  call Hloop_SA_Q(ntryL,G0H16(1),ex4(:),G0H8(5),ngPbt,m3h2x8(:,74),heltab2x16(:,:,74))
  call Hloop_A_Q(ntryL,G0H8(5),8,nMT,G1H8(6),n2h8(38))
  Gcoeff(:)%j = (c(28)*M(2,:)%j) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(75),h0tab(:,75),[8,3,4],[nMH,nMH,nMB],3,1,wf4(:,1))
  call Hloop_QA_S(ntryL,G0H16(1),ex4(:),G0H8(6),ngH,m3h2x8(:,75),heltab2x16(:,:,75))
  Gcoeff(:)%j = (-(c(27)*M(2,:)%j)) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(76),h0tab(:,76),[8,3,4],[nMZ,nMZ,nMB],3,1,wf4(:,1))
  call Hloop_QA_S(ntryL,G0H16(1),ex4(:),G0H8(7),ngX,m3h2x8(:,76),heltab2x16(:,:,76))
  Gcoeff(:)%j = (-(c(26)*M(2,:)%j)) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(77),h0tab(:,77),[8,3,4],[nMW,nMW,nMT],3,1,wf4(:,1))
  call Hloop_QA_S(ntryL,G0H16(1),ex4(:),G0H8(8),ngPbt,m3h2x8(:,77),heltab2x16(:,:,77))
  Gcoeff(:)%j = (c(27)*M(2,:)%j) * den(2)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(78),h0tab(:,78),[8,3,4],[nMZ,nMH,nMB],3,1,wf4(:,3))
  call Hloop_QA_S(ntryL,G0H16(1),ex4(:),G0H8(9),ngX,m3h2x8(:,78),heltab2x16(:,:,78))
  Gcoeff(:)%j = (c(27)*M(2,:)%j) * den(2)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(79),h0tab(:,79),[8,3,4],[nMH,nMZ,nMB],3,1,wf4(:,3))
  call Hloop_QA_S(ntryL,G0H16(1),ex4(:),G0H8(10),ngH,m3h2x8(:,79),heltab2x16(:,:,79))
  Gcoeff(:)%j = (-(c(83)*M(2,:)%j)) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(80),h0tab(:,80),[8,3,4],[nMB,nMB,0],3,1,wf4(:,1))
  call Hloop_VA_Q(ntryL,G0H16(1),ex4(:),G0H8(11),m3h2x8(:,80),heltab2x16(:,:,80))
  call Hloop_A_Q(ntryL,G0H8(11),8,nMB,G1H8(7),n2h8(39))
  Gcoeff(:)%j = (-(c(86)*M(2,:)%j)) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(81),h0tab(:,81),[8,3,4],[nMB,nMB,nMZ],3,1,wf4(:,1))
  call Hloop_ZA_Q(ntryL,G0H16(1),ex4(:),G0H8(12),ngZd,m3h2x8(:,81),heltab2x16(:,:,81))
  call Hloop_A_Q(ntryL,G0H8(12),8,nMB,G1H8(8),n2h8(40))
  Gcoeff(:)%j = (-(c(46)*M(2,:)%j)) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(82),h0tab(:,82),[8,3,4],[nMT,nMT,nMW],3,1,wf4(:,1))
  call Hloop_WA_Q(ntryL,G0H16(1),ex4(:),G0H8(13),m3h2x8(:,82),heltab2x16(:,:,82))
  call Hloop_A_Q(ntryL,G0H8(13),8,nMT,G1H8(9),n2h8(41))
  Gcoeff(:)%j = (-(c(83)*M(2,:)%j)) * den(2)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(83),h0tab(:,83),[8,3,4],[nMB,nMB,0],3,1,wf4(:,3))
  call Hloop_VA_Q(ntryL,G0H16(1),ex4(:),G0H8(14),m3h2x8(:,83),heltab2x16(:,:,83))
  call Hloop_A_Q(ntryL,G0H8(14),8,nMB,G1H8(10),n2h8(42))
  Gcoeff(:)%j = (-(c(86)*M(2,:)%j)) * den(2)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(84),h0tab(:,84),[8,3,4],[nMB,nMB,nMZ],3,1,wf4(:,3))
  call Hloop_ZA_Q(ntryL,G0H16(1),ex4(:),G0H8(15),ngZd,m3h2x8(:,84),heltab2x16(:,:,84))
  call Hloop_A_Q(ntryL,G0H8(15),8,nMB,G1H8(11),n2h8(43))
  Gcoeff(:)%j = (c(46)*M(2,:)%j) * den(2)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(85),h0tab(:,85),[8,3,4],[nMT,nMT,nMW],3,1,wf4(:,3))
  call Hloop_WA_Q(ntryL,G0H16(1),ex4(:),G0H8(16),m3h2x8(:,85),heltab2x16(:,:,85))
  call Hloop_A_Q(ntryL,G0H8(16),8,nMT,G1H8(12),n2h8(44))
  Gcoeff(:)%j = (c(57)*M(2,:)%j) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(86),h0tab(:,86),[8,3,4],[nMZ,nMZ,nMB],3,1,wf4(:,1))
  call Hloop_QA_Z(ntryL,G0H16(1),ex4(:),G0H8(17),ngZd,m3h2x8(:,86),heltab2x16(:,:,86))
  Gcoeff(:)%j = (-(c(42)*M(2,:)%j)) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(87),h0tab(:,87),[8,3,4],[nMW,nMW,nMT],3,1,wf4(:,1))
  call Hloop_QA_W(ntryL,G0H16(1),ex4(:),G0H8(18),m3h2x8(:,87),heltab2x16(:,:,87))
  Gcoeff(:)%j = (-(c(57)*M(2,:)%j)) * den(2)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(88),h0tab(:,88),[8,3,4],[nMZ,nMH,nMB],3,1,wf4(:,3))
  call Hloop_QA_Z(ntryL,G0H16(1),ex4(:),G0H8(19),ngZd,m3h2x8(:,88),heltab2x16(:,:,88))
  Gcoeff(:)%j = (c(42)*M(2,:)%j) * den(2)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(89),h0tab(:,89),[8,3,4],[nMW,nMW,nMT],3,1,wf4(:,3))
  call Hloop_QA_W(ntryL,G0H16(1),ex4(:),G0H8(20),m3h2x8(:,89),heltab2x16(:,:,89))
  Gcoeff(:)%j = (c(57)*M(2,:)%j) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(90),h0tab(:,90),[8,3,4],[nMZ,nMZ,nMB],3,1,wf4(:,1))
  call Hloop_QA_S(ntryL,G0H16(1),ex4(:),G0H8(21),ngX,m3h2x8(:,90),heltab2x16(:,:,90))
  Gcoeff(:)%j = (-(c(42)*M(2,:)%j)) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(91),h0tab(:,91),[8,3,4],[nMW,nMW,nMT],3,1,wf4(:,1))
  call Hloop_QA_S(ntryL,G0H16(1),ex4(:),G0H8(22),ngPbt,m3h2x8(:,91),heltab2x16(:,:,91))
  Gcoeff(:)%j = (-(c(57)*M(2,:)%j)) * den(2)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(92),h0tab(:,92),[8,3,4],[nMH,nMZ,nMB],3,1,wf4(:,3))
  call Hloop_QA_S(ntryL,G0H16(1),ex4(:),G0H8(23),ngH,m3h2x8(:,92),heltab2x16(:,:,92))
  Gcoeff(:)%j = (-(c(42)*M(2,:)%j)) * den(2)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(93),h0tab(:,93),[8,3,4],[nMW,nMW,nMT],3,1,wf4(:,3))
  call Hloop_QA_S(ntryL,G0H16(1),ex4(:),G0H8(24),ngPbt,m3h2x8(:,93),heltab2x16(:,:,93))
  Gcoeff(:)%j = (-(c(73)*M(2,:)%j)) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(94),h0tab(:,94),[8,3,4],[nMZ,nMZ,nMB],3,1,wf4(:,1))
  call Hloop_QA_Z(ntryL,G0H16(1),ex4(:),G0H8(25),ngZd,m3h2x8(:,94),heltab2x16(:,:,94))
  Gcoeff(:)%j = (-(c(15)*M(2,:)%j)) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(95),h0tab(:,95),[8,3,4],[nMW,nMW,nMT],3,1,wf4(:,1))
  call Hloop_QA_W(ntryL,G0H16(1),ex4(:),G0H8(26),m3h2x8(:,95),heltab2x16(:,:,95))
  Gcoeff(:)%j = (c(80)*M(2,:)%j) * den(3)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(96),h0tab(:,96),[8,3,4],[nMB,nMB,nMH],3,1,wf4(:,5))
  call Hloop_SA_Q(ntryL,G0H16(1),ex4(:),G0H8(27),ngH,m3h2x8(:,96),heltab2x16(:,:,96))
  call Hloop_A_Q(ntryL,G0H8(27),8,nMB,G1H8(13),n2h8(45))
  Gcoeff(:)%j = (-(c(80)*M(2,:)%j)) * den(3)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(97),h0tab(:,97),[8,3,4],[nMB,nMB,nMZ],3,1,wf4(:,5))
  call Hloop_SA_Q(ntryL,G0H16(1),ex4(:),G0H8(28),ngX,m3h2x8(:,97),heltab2x16(:,:,97))
  call Hloop_A_Q(ntryL,G0H8(28),8,nMB,G1H8(14),n2h8(46))
  Gcoeff(:)%j = (c(77)*M(2,:)%j) * den(3)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(98),h0tab(:,98),[8,3,4],[nMT,nMT,nMW],3,1,wf4(:,5))
  call Hloop_SA_Q(ntryL,G0H16(1),ex4(:),G0H8(29),ngPbt,m3h2x8(:,98),heltab2x16(:,:,98))
  call Hloop_A_Q(ntryL,G0H8(29),8,nMT,G1H8(15),n2h8(47))
  Gcoeff(:)%j = (-(c(81)*M(2,:)%j)) * den(2)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(99),h0tab(:,99),[8,3,4],[nMB,nMB,nMH],3,1,wf4(:,7))
  call Hloop_SA_Q(ntryL,G0H16(1),ex4(:),G0H8(30),ngH,m3h2x8(:,99),heltab2x16(:,:,99))
  call Hloop_A_Q(ntryL,G0H8(30),8,nMB,G1H8(16),n2h8(48))
  Gcoeff(:)%j = (c(81)*M(2,:)%j) * den(2)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(100),h0tab(:,100),[8,3,4],[nMB,nMB,nMZ],3,1,wf4(:,7))
  call Hloop_SA_Q(ntryL,G0H16(1),ex4(:),G0H8(31),ngX,m3h2x8(:,100),heltab2x16(:,:,100))
  call Hloop_A_Q(ntryL,G0H8(31),8,nMB,G1H8(17),n2h8(49))
  Gcoeff(:)%j = (c(79)*M(2,:)%j) * den(2)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(101),h0tab(:,101),[8,3,4],[nMT,nMT,nMW],3,1,wf4(:,7))
  call Hloop_SA_Q(ntryL,G0H16(1),ex4(:),G0H8(32),ngPbt,m3h2x8(:,101),heltab2x16(:,:,101))
  call Hloop_A_Q(ntryL,G0H8(32),8,nMT,G1H8(18),n2h8(50))
  Gcoeff(:)%j = (c(78)*M(2,:)%j) * den(3)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(102),h0tab(:,102),[8,3,4],[nMW,nMW,nMT],3,1,wf4(:,5))
  call Hloop_QA_S(ntryL,G0H16(1),ex4(:),G0H8(33),ngPbt,m3h2x8(:,102),heltab2x16(:,:,102))
  Gcoeff(:)%j = (c(55)*M(2,:)%j) * den(2)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(103),h0tab(:,103),[8,3,4],[nMZ,nMH,nMB],3,1,wf4(:,7))
  call Hloop_QA_S(ntryL,G0H16(1),ex4(:),G0H8(34),ngX,m3h2x8(:,103),heltab2x16(:,:,103))
  Gcoeff(:)%j = (c(55)*M(2,:)%j) * den(2)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(104),h0tab(:,104),[8,3,4],[nMH,nMZ,nMB],3,1,wf4(:,7))
  call Hloop_QA_S(ntryL,G0H16(1),ex4(:),G0H8(35),ngH,m3h2x8(:,104),heltab2x16(:,:,104))
  Gcoeff(:)%j = (-(c(104)*M(2,:)%j)) * den(2)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(105),h0tab(:,105),[8,3,4],[nMW,nMW,nMT],3,1,wf4(:,7))
  call Hloop_QA_S(ntryL,G0H16(1),ex4(:),G0H8(36),ngPbt,m3h2x8(:,105),heltab2x16(:,:,105))
  Gcoeff(:)%j = (-(c(1)*M(2,:)%j)) * den(3)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(106),h0tab(:,106),[8,3,4],[nMB,nMB,0],3,1,wf4(:,5))
  call Hloop_VA_Q(ntryL,G0H16(1),ex4(:),G0H8(37),m3h2x8(:,106),heltab2x16(:,:,106))
  call Hloop_A_Q(ntryL,G0H8(37),8,nMB,G1H8(19),n2h8(51))
  Gcoeff(:)%j = (-(c(5)*M(2,:)%j)) * den(3)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(107),h0tab(:,107),[8,3,4],[nMB,nMB,nMZ],3,1,wf4(:,5))
  call Hloop_ZA_Q(ntryL,G0H16(1),ex4(:),G0H8(1),ngZd,m3h2x8(:,107),heltab2x16(:,:,107))
  call Hloop_A_Q(ntryL,G0H8(1),8,nMB,G1H8(20),n2h8(52))
  Gcoeff(:)%j = (c(63)*M(2,:)%j) * den(3)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(108),h0tab(:,108),[8,3,4],[nMT,nMT,nMW],3,1,wf4(:,5))
  call Hloop_WA_Q(ntryL,G0H16(1),ex4(:),G0H8(2),m3h2x8(:,108),heltab2x16(:,:,108))
  call Hloop_A_Q(ntryL,G0H8(2),8,nMT,G1H8(21),n2h8(53))
  Gcoeff(:)%j = (c(4)*M(2,:)%j) * den(2)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(109),h0tab(:,109),[8,3,4],[nMB,nMB,0],3,1,wf4(:,7))
  call Hloop_VA_Q(ntryL,G0H16(1),ex4(:),G0H8(3),m3h2x8(:,109),heltab2x16(:,:,109))
  call Hloop_A_Q(ntryL,G0H8(3),8,nMB,G1H8(22),n2h8(54))
  Gcoeff(:)%j = (c(7)*M(2,:)%j) * den(2)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(110),h0tab(:,110),[8,3,4],[nMB,nMB,nMZ],3,1,wf4(:,7))
  call Hloop_ZA_Q(ntryL,G0H16(1),ex4(:),G0H8(4),ngZd,m3h2x8(:,110),heltab2x16(:,:,110))
  call Hloop_A_Q(ntryL,G0H8(4),8,nMB,G1H8(23),n2h8(55))
  Gcoeff(:)%j = (c(65)*M(2,:)%j) * den(2)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(111),h0tab(:,111),[8,3,4],[nMT,nMT,nMW],3,1,wf4(:,7))
  call Hloop_WA_Q(ntryL,G0H16(1),ex4(:),G0H8(5),m3h2x8(:,111),heltab2x16(:,:,111))
  call Hloop_A_Q(ntryL,G0H8(5),8,nMT,G1H8(24),n2h8(56))
  Gcoeff(:)%j = (c(64)*M(2,:)%j) * den(3)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(112),h0tab(:,112),[8,3,4],[nMW,nMW,nMT],3,1,wf4(:,5))
  call Hloop_QA_W(ntryL,G0H16(1),ex4(:),G0H8(11),m3h2x8(:,112),heltab2x16(:,:,112))
  Gcoeff(:)%j = (-(c(70)*M(2,:)%j)) * den(2)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(113),h0tab(:,113),[8,3,4],[nMZ,nMH,nMB],3,1,wf4(:,7))
  call Hloop_QA_Z(ntryL,G0H16(1),ex4(:),G0H8(12),ngZd,m3h2x8(:,113),heltab2x16(:,:,113))
  Gcoeff(:)%j = (-(c(92)*M(2,:)%j)) * den(2)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(114),h0tab(:,114),[8,3,4],[nMW,nMW,nMT],3,1,wf4(:,7))
  call Hloop_QA_W(ntryL,G0H16(1),ex4(:),G0H8(13),m3h2x8(:,114),heltab2x16(:,:,114))
  Gcoeff(:)%j = (-(c(64)*M(2,:)%j)) * den(3)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(115),h0tab(:,115),[8,3,4],[nMW,nMW,nMT],3,1,wf4(:,5))
  call Hloop_QA_S(ntryL,G0H16(1),ex4(:),G0H8(14),ngPbt,m3h2x8(:,115),heltab2x16(:,:,115))
  Gcoeff(:)%j = (-(c(70)*M(2,:)%j)) * den(2)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(116),h0tab(:,116),[8,3,4],[nMH,nMZ,nMB],3,1,wf4(:,7))
  call Hloop_QA_S(ntryL,G0H16(1),ex4(:),G0H8(15),ngH,m3h2x8(:,116),heltab2x16(:,:,116))
  Gcoeff(:)%j = (c(92)*M(2,:)%j) * den(2)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(117),h0tab(:,117),[8,3,4],[nMW,nMW,nMT],3,1,wf4(:,7))
  call Hloop_QA_S(ntryL,G0H16(1),ex4(:),G0H8(16),ngPbt,m3h2x8(:,117),heltab2x16(:,:,117))
  Gcoeff(:)%j = (c(64)*M(2,:)%j) * den(3)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(118),h0tab(:,118),[8,3,4],[nMW,nMW,nMT],3,1,wf4(:,5))
  call Hloop_QA_W(ntryL,G0H16(1),ex4(:),G0H8(27),m3h2x8(:,118),heltab2x16(:,:,118))
  Gcoeff(:)%j = (c(48)*M(2,:)%j) * den(2)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(119),h0tab(:,119),[8,3,4],[nMW,nMW,nMT],3,1,wf4(:,7))
  call Hloop_QA_W(ntryL,G0H16(1),ex4(:),G0H8(28),m3h2x8(:,119),heltab2x16(:,:,119))
  Gcoeff(:)%j = (c(24)*M(1,:)%j) * den(5)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(120),h0tab(:,120),[8,1,6],[nMH,nMT,nMB],3,1,wf4(:,10))
  call Hloop_QA_S(ntryL,G0H16(1),ex4(:),G0H8(29),ngH,m3h2x8(:,120),heltab2x16(:,:,120))
  Gcoeff(:)%j = (c(24)*M(1,:)%j) * den(5)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(121),h0tab(:,121),[8,1,6],[nMZ,nMT,nMB],3,1,wf4(:,10))
  call Hloop_QA_S(ntryL,G0H16(1),ex4(:),G0H8(30),ngX,m3h2x8(:,121),heltab2x16(:,:,121))
  Gcoeff(:)%j = (c(26)*M(1,:)%j) * den(5)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(122),h0tab(:,122),[8,1,6],[nMT,nMH,nMW],3,1,wf4(:,10))
  call Hloop_SA_Q(ntryL,G0H16(1),ex4(:),G0H8(31),ngPbt,m3h2x8(:,122),heltab2x16(:,:,122))
  call Hloop_A_Q(ntryL,G0H8(31),8,nMT,G1H8(25),n2h8(57))
  Gcoeff(:)%j = (c(22)*M(1,:)%j) * den(5)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(123),h0tab(:,123),[8,1,6],[nMB,nMW,nMH],3,1,wf4(:,10))
  call Hloop_SA_Q(ntryL,G0H16(1),ex4(:),G0H8(32),ngH,m3h2x8(:,123),heltab2x16(:,:,123))
  call Hloop_A_Q(ntryL,G0H8(32),8,nMB,G1H8(26),n2h8(58))
  Gcoeff(:)%j = (c(75)*M(1,:)%j) * den(5)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(124),h0tab(:,124),[8,1,6],[0,nMT,nMB],3,1,wf4(:,10))
  call Hloop_QA_V(ntryL,G0H16(1),ex4(:),G0H8(37),m3h2x8(:,124),heltab2x16(:,:,124))
  Gcoeff(:)%j = (-(c(79)*M(1,:)%j)) * den(5)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(125),h0tab(:,125),[8,1,6],[nMZ,nMT,nMB],3,1,wf4(:,10))
  call Hloop_QA_Z(ntryL,G0H16(1),ex4(:),G0H8(1),ngZd,m3h2x8(:,125),heltab2x16(:,:,125))
  Gcoeff(:)%j = (c(76)*M(1,:)%j) * den(5)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(126),h0tab(:,126),[8,1,6],[nMB,nMW,0],3,1,wf4(:,10))
  call Hloop_VA_Q(ntryL,G0H16(1),ex4(:),G0H8(2),m3h2x8(:,126),heltab2x16(:,:,126))
  call Hloop_A_Q(ntryL,G0H8(2),8,nMB,G1H8(27),n2h8(59))
  Gcoeff(:)%j = (c(104)*M(1,:)%j) * den(5)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(127),h0tab(:,127),[8,1,6],[nMB,nMW,nMZ],3,1,wf4(:,10))
  call Hloop_ZA_Q(ntryL,G0H16(1),ex4(:),G0H8(3),ngZd,m3h2x8(:,127),heltab2x16(:,:,127))
  call Hloop_A_Q(ntryL,G0H8(3),8,nMB,G1H8(28),n2h8(60))
  Gcoeff(:)%j = (c(42)*M(1,:)%j) * den(5)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(128),h0tab(:,128),[8,1,6],[nMT,nMH,nMW],3,1,wf4(:,10))
  call Hloop_WA_Q(ntryL,G0H16(1),ex4(:),G0H8(4),m3h2x8(:,128),heltab2x16(:,:,128))
  call Hloop_A_Q(ntryL,G0H8(4),8,nMT,G1H8(29),n2h8(61))
  Gcoeff(:)%j = (-(c(42)*M(1,:)%j)) * den(5)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(129),h0tab(:,129),[8,1,6],[nMT,nMZ,nMW],3,1,wf4(:,10))
  call Hloop_WA_Q(ntryL,G0H16(1),ex4(:),G0H8(5),m3h2x8(:,129),heltab2x16(:,:,129))
  call Hloop_A_Q(ntryL,G0H8(5),8,nMT,G1H8(30),n2h8(62))
  Gcoeff(:)%j = (-(c(78)*M(1,:)%j)) * den(5)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(130),h0tab(:,130),[8,1,6],[nMT,0,nMW],3,1,wf4(:,10))
  call Hloop_SA_Q(ntryL,G0H16(1),ex4(:),G0H8(31),ngPbt,m3h2x8(:,130),heltab2x16(:,:,130))
  call Hloop_A_Q(ntryL,G0H8(31),8,nMT,G1H8(31),n2h8(63))
  Gcoeff(:)%j = (c(104)*M(1,:)%j) * den(5)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(131),h0tab(:,131),[8,1,6],[nMT,nMZ,nMW],3,1,wf4(:,10))
  call Hloop_SA_Q(ntryL,G0H16(1),ex4(:),G0H8(32),ngPbt,m3h2x8(:,131),heltab2x16(:,:,131))
  call Hloop_A_Q(ntryL,G0H8(32),8,nMT,G1H8(32),n2h8(64))
  Gcoeff(:)%j = (c(39)*M(1,:)%j) * den(5)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(132),h0tab(:,132),[8,1,6],[nMB,nMW,nMH],3,1,wf4(:,10))
  call Hloop_SA_Q(ntryL,G0H16(1),ex4(:),G0H8(2),ngH,m3h2x8(:,132),heltab2x16(:,:,132))
  call Hloop_A_Q(ntryL,G0H8(2),8,nMB,G1H8(33),n2h8(65))
  Gcoeff(:)%j = (c(39)*M(1,:)%j) * den(5)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(133),h0tab(:,133),[8,1,6],[nMB,nMW,nMZ],3,1,wf4(:,10))
  call Hloop_SA_Q(ntryL,G0H16(1),ex4(:),G0H8(3),ngX,m3h2x8(:,133),heltab2x16(:,:,133))
  call Hloop_A_Q(ntryL,G0H8(3),8,nMB,G1H8(34),n2h8(66))
  Gcoeff(:)%j = (-(c(64)*M(1,:)%j)) * den(5)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(134),h0tab(:,134),[8,1,6],[nMT,0,nMW],3,1,wf4(:,10))
  call Hloop_WA_Q(ntryL,G0H16(1),ex4(:),G0H8(4),m3h2x8(:,134),heltab2x16(:,:,134))
  call Hloop_A_Q(ntryL,G0H8(4),8,nMT,G1H8(35),n2h8(67))
  Gcoeff(:)%j = (c(62)*M(1,:)%j) * den(5)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(135),h0tab(:,135),[8,1,6],[nMB,nMW,0],3,1,wf4(:,10))
  call Hloop_VA_Q(ntryL,G0H16(1),ex4(:),G0H8(5),m3h2x8(:,135),heltab2x16(:,:,135))
  call Hloop_A_Q(ntryL,G0H8(5),8,nMB,G1H8(36),n2h8(68))
  Gcoeff(:)%j = (c(92)*M(1,:)%j) * den(5)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(136),h0tab(:,136),[8,1,6],[nMT,nMZ,nMW],3,1,wf4(:,10))
  call Hloop_WA_Q(ntryL,G0H16(1),ex4(:),G0H8(31),m3h2x8(:,136),heltab2x16(:,:,136))
  call Hloop_A_Q(ntryL,G0H8(31),8,nMT,G1H8(37),n2h8(69))
  Gcoeff(:)%j = (c(92)*M(1,:)%j) * den(5)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(137),h0tab(:,137),[8,1,6],[nMB,nMW,nMZ],3,1,wf4(:,10))
  call Hloop_ZA_Q(ntryL,G0H16(1),ex4(:),G0H8(32),ngZd,m3h2x8(:,137),heltab2x16(:,:,137))
  call Hloop_A_Q(ntryL,G0H8(32),8,nMB,G1H8(38),n2h8(70))
  Gcoeff(:)%j = (c(44)*M(1,:)%j) * den(5)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(138),h0tab(:,138),[8,1,6],[nMH,nMT,nMB],3,1,wf4(:,12))
  call Hloop_QA_S(ntryL,G0H16(1),ex4(:),G0H8(2),ngH,m3h2x8(:,138),heltab2x16(:,:,138))
  Gcoeff(:)%j = (c(44)*M(1,:)%j) * den(5)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(139),h0tab(:,139),[8,1,6],[nMZ,nMT,nMB],3,1,wf4(:,12))
  call Hloop_QA_S(ntryL,G0H16(1),ex4(:),G0H8(3),ngX,m3h2x8(:,139),heltab2x16(:,:,139))
  Gcoeff(:)%j = (c(42)*M(1,:)%j) * den(5)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(140),h0tab(:,140),[8,1,6],[nMT,nMH,nMW],3,1,wf4(:,12))
  call Hloop_SA_Q(ntryL,G0H16(1),ex4(:),G0H8(4),ngPbt,m3h2x8(:,140),heltab2x16(:,:,140))
  call Hloop_A_Q(ntryL,G0H8(4),8,nMT,G1H8(39),n2h8(71))
  Gcoeff(:)%j = (c(39)*M(1,:)%j) * den(5)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(141),h0tab(:,141),[8,1,6],[nMB,nMW,nMH],3,1,wf4(:,12))
  call Hloop_SA_Q(ntryL,G0H16(1),ex4(:),G0H8(5),ngH,m3h2x8(:,141),heltab2x16(:,:,141))
  call Hloop_A_Q(ntryL,G0H8(5),8,nMB,G1H8(40),n2h8(72))
  Gcoeff(:)%j = (c(42)*M(1,:)%j) * den(5)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(142),h0tab(:,142),[8,1,6],[nMT,nMZ,nMW],3,1,wf4(:,12))
  call Hloop_SA_Q(ntryL,G0H16(1),ex4(:),G0H8(31),ngPbt,m3h2x8(:,142),heltab2x16(:,:,142))
  call Hloop_A_Q(ntryL,G0H8(31),8,nMT,G1H8(41),n2h8(73))
  Gcoeff(:)%j = (-(c(39)*M(1,:)%j)) * den(5)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(143),h0tab(:,143),[8,1,6],[nMB,nMW,nMZ],3,1,wf4(:,12))
  call Hloop_SA_Q(ntryL,G0H16(1),ex4(:),G0H8(32),ngX,m3h2x8(:,143),heltab2x16(:,:,143))
  call Hloop_A_Q(ntryL,G0H8(32),8,nMB,G1H8(42),n2h8(74))
  Gcoeff(:)%j = (c(61)*M(1,:)%j) * den(5)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(144),h0tab(:,144),[8,1,6],[0,nMT,nMB],3,1,wf4(:,12))
  call Hloop_QA_V(ntryL,G0H16(1),ex4(:),G0H8(4),m3h2x8(:,144),heltab2x16(:,:,144))
  Gcoeff(:)%j = (-(c(65)*M(1,:)%j)) * den(5)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(145),h0tab(:,145),[8,1,6],[nMZ,nMT,nMB],3,1,wf4(:,12))
  call Hloop_QA_Z(ntryL,G0H16(1),ex4(:),G0H8(5),ngZd,m3h2x8(:,145),heltab2x16(:,:,145))
  Gcoeff(:)%j = (-(c(62)*M(1,:)%j)) * den(5)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(146),h0tab(:,146),[8,1,6],[nMB,nMW,0],3,1,wf4(:,12))
  call Hloop_VA_Q(ntryL,G0H16(1),ex4(:),G0H8(31),m3h2x8(:,146),heltab2x16(:,:,146))
  call Hloop_A_Q(ntryL,G0H8(31),8,nMB,G1H8(43),n2h8(75))
  Gcoeff(:)%j = (-(c(92)*M(1,:)%j)) * den(5)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(147),h0tab(:,147),[8,1,6],[nMB,nMW,nMZ],3,1,wf4(:,12))
  call Hloop_ZA_Q(ntryL,G0H16(1),ex4(:),G0H8(32),ngZd,m3h2x8(:,147),heltab2x16(:,:,147))
  call Hloop_A_Q(ntryL,G0H8(32),8,nMB,G1H8(44),n2h8(76))
  Gcoeff(:)%j = (c(15)*M(1,:)%j) * den(5)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(148),h0tab(:,148),[8,1,6],[nMT,nMH,nMW],3,1,wf4(:,12))
  call Hloop_WA_Q(ntryL,G0H16(1),ex4(:),G0H8(31),m3h2x8(:,148),heltab2x16(:,:,148))
  call Hloop_A_Q(ntryL,G0H8(31),8,nMT,G1H8(45),n2h8(77))
  Gcoeff(:)%j = (c(64)*M(1,:)%j) * den(5)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(149),h0tab(:,149),[8,1,6],[nMT,0,nMW],3,1,wf4(:,12))
  call Hloop_SA_Q(ntryL,G0H16(1),ex4(:),G0H8(32),ngPbt,m3h2x8(:,149),heltab2x16(:,:,149))
  call Hloop_A_Q(ntryL,G0H8(32),8,nMT,G1H8(46),n2h8(78))
  Gcoeff(:)%j = (-(c(92)*M(1,:)%j)) * den(5)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(150),h0tab(:,150),[8,1,6],[nMT,nMZ,nMW],3,1,wf4(:,12))
  call Hloop_SA_Q(ntryL,G0H16(1),ex4(:),G0H8(31),ngPbt,m3h2x8(:,150),heltab2x16(:,:,150))
  call Hloop_A_Q(ntryL,G0H8(31),8,nMT,G1H8(47),n2h8(79))
  Gcoeff(:)%j = (c(14)*M(1,:)%j) * den(5)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(151),h0tab(:,151),[8,1,6],[nMB,nMW,nMH],3,1,wf4(:,12))
  call Hloop_SA_Q(ntryL,G0H16(1),ex4(:),G0H8(32),ngH,m3h2x8(:,151),heltab2x16(:,:,151))
  call Hloop_A_Q(ntryL,G0H8(32),8,nMB,G1H8(48),n2h8(80))
  Gcoeff(:)%j = (-(c(64)*M(1,:)%j)) * den(5)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(152),h0tab(:,152),[8,1,6],[nMT,0,nMW],3,1,wf4(:,12))
  call Hloop_WA_Q(ntryL,G0H16(1),ex4(:),G0H8(31),m3h2x8(:,152),heltab2x16(:,:,152))
  call Hloop_A_Q(ntryL,G0H8(31),8,nMT,G1H8(49),n2h8(81))
  Gcoeff(:)%j = (c(62)*M(1,:)%j) * den(5)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(153),h0tab(:,153),[8,1,6],[nMB,nMW,0],3,1,wf4(:,12))
  call Hloop_VA_Q(ntryL,G0H16(1),ex4(:),G0H8(32),m3h2x8(:,153),heltab2x16(:,:,153))
  call Hloop_A_Q(ntryL,G0H8(32),8,nMB,G1H8(50),n2h8(82))
  Gcoeff(:)%j = (-(c(48)*M(1,:)%j)) * den(5)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(154),h0tab(:,154),[8,1,6],[nMT,nMZ,nMW],3,1,wf4(:,12))
  call Hloop_WA_Q(ntryL,G0H16(1),ex4(:),G0H8(31),m3h2x8(:,154),heltab2x16(:,:,154))
  call Hloop_A_Q(ntryL,G0H8(31),8,nMT,G1H8(51),n2h8(83))
  Gcoeff(:)%j = (-(c(48)*M(1,:)%j)) * den(5)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(155),h0tab(:,155),[8,1,6],[nMB,nMW,nMZ],3,1,wf4(:,12))
  call Hloop_ZA_Q(ntryL,G0H16(1),ex4(:),G0H8(32),ngZd,m3h2x8(:,155),heltab2x16(:,:,155))
  call Hloop_A_Q(ntryL,G0H8(32),8,nMB,G1H8(52),n2h8(84))
  Gcoeff(:)%j = (c(24)*M(1,:)%j) * den(4)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(156),h0tab(:,156),[9,2,4],[nMT,nMH,nMB],3,1,wf4(:,9))
  call Hloop_QS_A(ntryL,G0H16(1),wf4(:,9),G0H4(1),ngPtb,m3h4x4(:,1),heltab2x16(:,:,156))
  call Hloop_Q_A(ntryL,G0H4(1),9,nMT,G1H4(2),n2h4(37))
  Gcoeff(:)%j = (c(24)*M(1,:)%j) * den(4)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(157),h0tab(:,157),[9,2,4],[nMT,nMZ,nMB],3,1,wf4(:,9))
  call Hloop_QS_A(ntryL,G0H16(1),wf4(:,9),G0H4(1),ngPtb,m3h4x4(:,2),heltab2x16(:,:,157))
  call Hloop_Q_A(ntryL,G0H4(1),9,nMT,G1H4(4),n2h4(38))
  Gcoeff(:)%j = (c(26)*M(1,:)%j) * den(4)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(158),h0tab(:,158),[9,2,4],[nMH,nMT,nMW],3,1,wf4(:,9))
  call Hloop_SS_S(ntryL,G0H16(1),wf4(:,9),G0H4(1),m3h4x4(:,3),heltab2x16(:,:,158))
  Gcoeff(:)%j = (c(22)*M(1,:)%j) * den(4)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(159),h0tab(:,159),[9,2,4],[nMW,nMB,nMH],3,1,wf4(:,9))
  call Hloop_SS_S(ntryL,G0H16(1),wf4(:,9),G0H4(2),m3h4x4(:,4),heltab2x16(:,:,159))
  Gcoeff(:)%j = (c(75)*M(1,:)%j) * den(4)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(160),h0tab(:,160),[9,2,4],[nMT,0,nMB],3,1,wf4(:,9))
  call Hloop_QS_A(ntryL,G0H16(1),wf4(:,9),G0H4(3),ngPtb,m3h4x4(:,5),heltab2x16(:,:,160))
  call Hloop_Q_A(ntryL,G0H4(3),9,nMT,G1H4(5),n2h4(39))
  Gcoeff(:)%j = (-(c(79)*M(1,:)%j)) * den(4)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(161),h0tab(:,161),[9,2,4],[nMT,nMZ,nMB],3,1,wf4(:,9))
  call Hloop_QS_A(ntryL,G0H16(1),wf4(:,9),G0H4(3),ngPtb,m3h4x4(:,6),heltab2x16(:,:,161))
  call Hloop_Q_A(ntryL,G0H4(3),9,nMT,G1H4(12),n2h4(40))
  Gcoeff(:)%j = (c(76)*M(1,:)%j) * den(4)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(162),h0tab(:,162),[9,2,4],[nMW,nMB,0],3,1,wf4(:,9))
  call Hloop_VS_T(ntryL,G0H16(1),0,wf4(:,9),9,G1H4(14),m3h4x4(:,7),heltab2x16(:,:,162))
  Gcoeff(:)%j = (c(104)*M(1,:)%j) * den(4)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(163),h0tab(:,163),[9,2,4],[nMW,nMB,nMZ],3,1,wf4(:,9))
  call Hloop_VS_T(ntryL,G0H16(1),0,wf4(:,9),9,G1H4(15),m3h4x4(:,8),heltab2x16(:,:,163))
  Gcoeff(:)%j = (c(42)*M(1,:)%j) * den(4)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(164),h0tab(:,164),[9,2,4],[nMH,nMT,nMW],3,1,wf4(:,9))
  call Hloop_VS_T(ntryL,G0H16(1),0,wf4(:,9),9,G1H4(23),m3h4x4(:,9),heltab2x16(:,:,164))
  Gcoeff(:)%j = (c(42)*M(1,:)%j) * den(4)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(165),h0tab(:,165),[9,2,4],[nMZ,nMT,nMW],3,1,wf4(:,9))
  call Hloop_VS_T(ntryL,G0H16(1),0,wf4(:,9),9,G1H4(24),m3h4x4(:,10),heltab2x16(:,:,165))
  Gcoeff(:)%j = (-(c(78)*M(1,:)%j)) * den(4)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(166),h0tab(:,166),[9,2,4],[0,nMT,nMW],3,1,wf4(:,9))
  call Hloop_TS_V(ntryL,G0H16(1),0,wf4(:,9),9,G1H4(30),m3h4x4(:,11),heltab2x16(:,:,166))
  Gcoeff(:)%j = (c(104)*M(1,:)%j) * den(4)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(167),h0tab(:,167),[9,2,4],[nMZ,nMT,nMW],3,1,wf4(:,9))
  call Hloop_TS_V(ntryL,G0H16(1),0,wf4(:,9),9,G1H4(32),m3h4x4(:,12),heltab2x16(:,:,167))
  Gcoeff(:)%j = (c(39)*M(1,:)%j) * den(4)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(168),h0tab(:,168),[9,2,4],[nMW,nMB,nMH],3,1,wf4(:,9))
  call Hloop_TS_V(ntryL,G0H16(1),0,wf4(:,9),9,G1H4(1),m3h4x4(:,13),heltab2x16(:,:,168))
  Gcoeff(:)%j = (-(c(39)*M(1,:)%j)) * den(4)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(169),h0tab(:,169),[9,2,4],[nMW,nMB,nMZ],3,1,wf4(:,9))
  call Hloop_TS_V(ntryL,G0H16(1),0,wf4(:,9),9,G1H4(8),m3h4x4(:,14),heltab2x16(:,:,169))
  Gcoeff(:)%j = (c(64)*M(1,:)%j) * den(4)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(170),h0tab(:,170),[9,2,4],[0,nMT,nMW],3,1,wf4(:,9))
  call Hloop_VS_V(ntryL,G0H16(1),wf4(:,9),G0H4(3),m3h4x4(:,15),heltab2x16(:,:,170))
  Gcoeff(:)%j = (-(c(62)*M(1,:)%j)) * den(4)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(171),h0tab(:,171),[9,2,4],[nMW,nMB,0],3,1,wf4(:,9))
  call Hloop_VS_V(ntryL,G0H16(1),wf4(:,9),G0H4(4),m3h4x4(:,16),heltab2x16(:,:,171))
  Gcoeff(:)%j = (-(c(92)*M(1,:)%j)) * den(4)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(172),h0tab(:,172),[9,2,4],[nMZ,nMT,nMW],3,1,wf4(:,9))
  call Hloop_VS_V(ntryL,G0H16(1),wf4(:,9),G0H4(5),m3h4x4(:,17),heltab2x16(:,:,172))
  Gcoeff(:)%j = (-(c(92)*M(1,:)%j)) * den(4)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(173),h0tab(:,173),[9,2,4],[nMW,nMB,nMZ],3,1,wf4(:,9))
  call Hloop_VS_V(ntryL,G0H16(1),wf4(:,9),G0H4(6),m3h4x4(:,18),heltab2x16(:,:,173))
  Gcoeff(:)%j = (c(44)*M(1,:)%j) * den(4)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(174),h0tab(:,174),[9,2,4],[nMT,nMH,nMB],3,1,wf4(:,11))
  call Hloop_QW_A(ntryL,G0H16(1),wf4(:,11),G0H4(7),m3h4x4(:,19),heltab2x16(:,:,174))
  call Hloop_Q_A(ntryL,G0H4(7),9,nMT,G1H4(3),n2h4(41))
  Gcoeff(:)%j = (c(44)*M(1,:)%j) * den(4)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(175),h0tab(:,175),[9,2,4],[nMT,nMZ,nMB],3,1,wf4(:,11))
  call Hloop_QW_A(ntryL,G0H16(1),wf4(:,11),G0H4(7),m3h4x4(:,20),heltab2x16(:,:,175))
  call Hloop_Q_A(ntryL,G0H4(7),9,nMT,G1H4(9),n2h4(42))
  Gcoeff(:)%j = (c(42)*M(1,:)%j) * den(4)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(176),h0tab(:,176),[9,2,4],[nMH,nMT,nMW],3,1,wf4(:,11))
  call Hloop_SV_T(ntryL,G0H16(1),0,wf4(:,11),9,G1H4(10),m3h4x4(:,21),heltab2x16(:,:,176))
  Gcoeff(:)%j = (c(39)*M(1,:)%j) * den(4)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(177),h0tab(:,177),[9,2,4],[nMW,nMB,nMH],3,1,wf4(:,11))
  call Hloop_TV_S(ntryL,G0H16(1),0,wf4(:,11),9,G1H4(6),m3h4x4(:,22),heltab2x16(:,:,177))
  Gcoeff(:)%j = (-(c(42)*M(1,:)%j)) * den(4)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(178),h0tab(:,178),[9,2,4],[nMZ,nMT,nMW],3,1,wf4(:,11))
  call Hloop_SV_T(ntryL,G0H16(1),0,wf4(:,11),9,G1H4(7),m3h4x4(:,23),heltab2x16(:,:,178))
  Gcoeff(:)%j = (c(39)*M(1,:)%j) * den(4)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(179),h0tab(:,179),[9,2,4],[nMW,nMB,nMZ],3,1,wf4(:,11))
  call Hloop_TV_S(ntryL,G0H16(1),0,wf4(:,11),9,G1H4(11),m3h4x4(:,24),heltab2x16(:,:,179))
  Gcoeff(:)%j = (c(61)*M(1,:)%j) * den(4)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(180),h0tab(:,180),[9,2,4],[nMT,0,nMB],3,1,wf4(:,11))
  call Hloop_QW_A(ntryL,G0H16(1),wf4(:,11),G0H4(7),m3h4x4(:,25),heltab2x16(:,:,180))
  call Hloop_Q_A(ntryL,G0H4(7),9,nMT,G1H4(17),n2h4(43))
  Gcoeff(:)%j = (-(c(65)*M(1,:)%j)) * den(4)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(181),h0tab(:,181),[9,2,4],[nMT,nMZ,nMB],3,1,wf4(:,11))
  call Hloop_QW_A(ntryL,G0H16(1),wf4(:,11),G0H4(7),m3h4x4(:,26),heltab2x16(:,:,181))
  call Hloop_Q_A(ntryL,G0H4(7),9,nMT,G1H4(13),n2h4(44))
  Gcoeff(:)%j = (c(62)*M(1,:)%j) * den(4)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(182),h0tab(:,182),[9,2,4],[nMW,nMB,0],3,1,wf4(:,11))
  call Hloop_VV_S(ntryL,G0H16(1),wf4(:,11),G0H4(7),m3h4x4(:,27),heltab2x16(:,:,182))
  Gcoeff(:)%j = (c(92)*M(1,:)%j) * den(4)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(183),h0tab(:,183),[9,2,4],[nMW,nMB,nMZ],3,1,wf4(:,11))
  call Hloop_VV_S(ntryL,G0H16(1),wf4(:,11),G0H4(8),m3h4x4(:,28),heltab2x16(:,:,183))
  Gcoeff(:)%j = (c(15)*M(1,:)%j) * den(4)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(184),h0tab(:,184),[9,2,4],[nMH,nMT,nMW],3,1,wf4(:,11))
  call Hloop_VV_S(ntryL,G0H16(1),wf4(:,11),G0H4(9),m3h4x4(:,29),heltab2x16(:,:,184))
  Gcoeff(:)%j = (-(c(64)*M(1,:)%j)) * den(4)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(185),h0tab(:,185),[9,2,4],[0,nMT,nMW],3,1,wf4(:,11))
  call Hloop_SV_V(ntryL,G0H16(1),wf4(:,11),G0H4(10),m3h4x4(:,30),heltab2x16(:,:,185))
  Gcoeff(:)%j = (c(92)*M(1,:)%j) * den(4)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(186),h0tab(:,186),[9,2,4],[nMZ,nMT,nMW],3,1,wf4(:,11))
  call Hloop_SV_V(ntryL,G0H16(1),wf4(:,11),G0H4(11),m3h4x4(:,31),heltab2x16(:,:,186))
  Gcoeff(:)%j = (c(14)*M(1,:)%j) * den(4)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(187),h0tab(:,187),[9,2,4],[nMW,nMB,nMH],3,1,wf4(:,11))
  call Hloop_SV_V(ntryL,G0H16(1),wf4(:,11),G0H4(12),m3h4x4(:,32),heltab2x16(:,:,187))
  Gcoeff(:)%j = (-(c(64)*M(1,:)%j)) * den(4)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(188),h0tab(:,188),[9,2,4],[0,nMT,nMW],3,1,wf4(:,11))
  call Hloop_UW_V(ntryL,G0H16(1),0,wf4(:,11),9,G1H4(19),m3h4x4(:,33),heltab2x16(:,:,188))
  Gcoeff(:)%j = (c(62)*M(1,:)%j) * den(4)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(189),h0tab(:,189),[9,2,4],[nMW,nMB,0],3,1,wf4(:,11))
  call Hloop_UV_W(ntryL,G0H16(1),0,wf4(:,11),9,G1H4(20),m3h4x4(:,34),heltab2x16(:,:,189))
  Gcoeff(:)%j = (-(c(48)*M(1,:)%j)) * den(4)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(190),h0tab(:,190),[9,2,4],[nMZ,nMT,nMW],3,1,wf4(:,11))
  call Hloop_UW_V(ntryL,G0H16(1),0,wf4(:,11),9,G1H4(16),m3h4x4(:,35),heltab2x16(:,:,190))
  Gcoeff(:)%j = (-(c(48)*M(1,:)%j)) * den(4)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(191),h0tab(:,191),[9,2,4],[nMW,nMB,nMZ],3,1,wf4(:,11))
  call Hloop_UV_W(ntryL,G0H16(1),0,wf4(:,11),9,G1H4(18),m3h4x4(:,36),heltab2x16(:,:,191))
  Gcoeff(:)%j = (c(36)*M(2,:)%j) * den(6)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(192),h0tab(:,192),[12,1,2],[nMT,nMH,nMT],3,1,wf4(:,2))
  call Hloop_AS_Q(ntryL,G0H16(1),wf4(:,2),G0H4(13),ngH,m3h4x4(:,37),heltab2x16(:,:,192))
  call Hloop_A_Q(ntryL,G0H4(13),12,nMT,G1H4(21),n2h4(45))
  Gcoeff(:)%j = (-(c(36)*M(2,:)%j)) * den(6)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(193),h0tab(:,193),[12,1,2],[nMT,nMZ,nMT],3,1,wf4(:,2))
  call Hloop_AS_Q(ntryL,G0H16(1),wf4(:,2),G0H4(13),ngH,m3h4x4(:,38),heltab2x16(:,:,193))
  call Hloop_A_Q(ntryL,G0H4(13),12,nMT,G1H4(22),n2h4(46))
  Gcoeff(:)%j = (-(c(21)*M(2,:)%j)) * den(6)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(194),h0tab(:,194),[12,1,2],[nMB,nMW,nMB],3,1,wf4(:,2))
  call Hloop_AS_Q(ntryL,G0H16(1),wf4(:,2),G0H4(13),ngH,m3h4x4(:,39),heltab2x16(:,:,194))
  call Hloop_A_Q(ntryL,G0H4(13),12,nMB,G1H4(35),n2h4(47))
  Gcoeff(:)%j = (c(36)*M(2,:)%j) * den(7)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(195),h0tab(:,195),[12,1,2],[nMT,nMH,nMT],3,1,wf4(:,4))
  call Hloop_AS_Q(ntryL,G0H16(1),wf4(:,4),G0H4(13),ngX,m3h4x4(:,40),heltab2x16(:,:,195))
  call Hloop_A_Q(ntryL,G0H4(13),12,nMT,G1H4(36),n2h4(48))
  Gcoeff(:)%j = (-(c(36)*M(2,:)%j)) * den(7)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(196),h0tab(:,196),[12,1,2],[nMT,nMZ,nMT],3,1,wf4(:,4))
  call Hloop_AS_Q(ntryL,G0H16(1),wf4(:,4),G0H4(13),ngX,m3h4x4(:,41),heltab2x16(:,:,196))
  call Hloop_A_Q(ntryL,G0H4(13),12,nMT,G1H4(25),n2h4(49))
  Gcoeff(:)%j = (c(21)*M(2,:)%j) * den(7)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(197),h0tab(:,197),[12,1,2],[nMB,nMW,nMB],3,1,wf4(:,4))
  call Hloop_AS_Q(ntryL,G0H16(1),wf4(:,4),G0H4(13),ngX,m3h4x4(:,42),heltab2x16(:,:,197))
  call Hloop_A_Q(ntryL,G0H4(13),12,nMB,G1H4(26),n2h4(50))
  Gcoeff(:)%j = (c(35)*M(2,:)%j) * den(6)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(198),h0tab(:,198),[12,1,2],[nMH,nMT,nMH],3,1,wf4(:,2))
  call Hloop_SS_S(ntryL,G0H16(1),wf4(:,2),G0H4(13),m3h4x4(:,43),heltab2x16(:,:,198))
  Gcoeff(:)%j = (-(c(34)*M(2,:)%j)) * den(6)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(199),h0tab(:,199),[12,1,2],[nMZ,nMT,nMZ],3,1,wf4(:,2))
  call Hloop_SS_S(ntryL,G0H16(1),wf4(:,2),G0H4(14),m3h4x4(:,44),heltab2x16(:,:,199))
  Gcoeff(:)%j = (-(c(22)*M(2,:)%j)) * den(6)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(200),h0tab(:,200),[12,1,2],[nMW,nMB,nMW],3,1,wf4(:,2))
  call Hloop_SS_S(ntryL,G0H16(1),wf4(:,2),G0H4(15),m3h4x4(:,45),heltab2x16(:,:,200))
  Gcoeff(:)%j = (c(34)*M(2,:)%j) * den(7)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(201),h0tab(:,201),[12,1,2],[nMH,nMT,nMZ],3,1,wf4(:,4))
  call Hloop_SS_S(ntryL,G0H16(1),wf4(:,4),G0H4(16),m3h4x4(:,46),heltab2x16(:,:,201))
  Gcoeff(:)%j = (c(34)*M(2,:)%j) * den(7)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(202),h0tab(:,202),[12,1,2],[nMZ,nMT,nMH],3,1,wf4(:,4))
  call Hloop_SS_S(ntryL,G0H16(1),wf4(:,4),G0H4(17),m3h4x4(:,47),heltab2x16(:,:,202))
  Gcoeff(:)%j = (-(c(85)*M(2,:)%j)) * den(6)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(203),h0tab(:,203),[12,1,2],[nMT,0,nMT],3,1,wf4(:,2))
  call Hloop_AS_Q(ntryL,G0H16(1),wf4(:,2),G0H4(18),ngH,m3h4x4(:,48),heltab2x16(:,:,203))
  call Hloop_A_Q(ntryL,G0H4(18),12,nMT,G1H4(27),n2h4(51))
  Gcoeff(:)%j = (-(c(86)*M(2,:)%j)) * den(6)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(204),h0tab(:,204),[12,1,2],[nMT,nMZ,nMT],3,1,wf4(:,2))
  call Hloop_AS_Q(ntryL,G0H16(1),wf4(:,2),G0H4(18),ngH,m3h4x4(:,49),heltab2x16(:,:,204))
  call Hloop_A_Q(ntryL,G0H4(18),12,nMT,G1H4(28),n2h4(52))
  Gcoeff(:)%j = (-(c(40)*M(2,:)%j)) * den(6)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(205),h0tab(:,205),[12,1,2],[nMB,nMW,nMB],3,1,wf4(:,2))
  call Hloop_AS_Q(ntryL,G0H16(1),wf4(:,2),G0H4(18),ngH,m3h4x4(:,50),heltab2x16(:,:,205))
  call Hloop_A_Q(ntryL,G0H4(18),12,nMB,G1H4(29),n2h4(53))
  Gcoeff(:)%j = (-(c(85)*M(2,:)%j)) * den(7)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(206),h0tab(:,206),[12,1,2],[nMT,0,nMT],3,1,wf4(:,4))
  call Hloop_AS_Q(ntryL,G0H16(1),wf4(:,4),G0H4(18),ngX,m3h4x4(:,51),heltab2x16(:,:,206))
  call Hloop_A_Q(ntryL,G0H4(18),12,nMT,G1H4(47),n2h4(54))
  Gcoeff(:)%j = (-(c(86)*M(2,:)%j)) * den(7)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(207),h0tab(:,207),[12,1,2],[nMT,nMZ,nMT],3,1,wf4(:,4))
  call Hloop_AS_Q(ntryL,G0H16(1),wf4(:,4),G0H4(18),ngX,m3h4x4(:,52),heltab2x16(:,:,207))
  call Hloop_A_Q(ntryL,G0H4(18),12,nMT,G1H4(31),n2h4(55))
  Gcoeff(:)%j = (c(40)*M(2,:)%j) * den(7)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(208),h0tab(:,208),[12,1,2],[nMB,nMW,nMB],3,1,wf4(:,4))
  call Hloop_AS_Q(ntryL,G0H16(1),wf4(:,4),G0H4(18),ngX,m3h4x4(:,53),heltab2x16(:,:,208))
  call Hloop_A_Q(ntryL,G0H4(18),12,nMB,G1H4(48),n2h4(56))
  Gcoeff(:)%j = (-(c(57)*M(2,:)%j)) * den(6)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(209),h0tab(:,209),[12,1,2],[nMZ,nMT,nMZ],3,1,wf4(:,2))
  call Hloop_VT_S(ntryL,G0H16(1),0,wf4(:,2),12,G1H4(33),m3h4x4(:,54),heltab2x16(:,:,209))
  Gcoeff(:)%j = (-(c(39)*M(2,:)%j)) * den(6)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(210),h0tab(:,210),[12,1,2],[nMW,nMB,nMW],3,1,wf4(:,2))
  call Hloop_VT_S(ntryL,G0H16(1),0,wf4(:,2),12,G1H4(34),m3h4x4(:,55),heltab2x16(:,:,210))
  Gcoeff(:)%j = (c(57)*M(2,:)%j) * den(7)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(211),h0tab(:,211),[12,1,2],[nMH,nMT,nMZ],3,1,wf4(:,4))
  call Hloop_VS_T(ntryL,G0H16(1),0,wf4(:,4),12,G1H4(37),m3h4x4(:,56),heltab2x16(:,:,211))
  Gcoeff(:)%j = (c(39)*M(2,:)%j) * den(7)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(212),h0tab(:,212),[12,1,2],[nMW,nMB,nMW],3,1,wf4(:,4))
  call Hloop_VT_S(ntryL,G0H16(1),0,wf4(:,4),12,G1H4(38),m3h4x4(:,57),heltab2x16(:,:,212))
  Gcoeff(:)%j = (-(c(57)*M(2,:)%j)) * den(6)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(213),h0tab(:,213),[12,1,2],[nMZ,nMT,nMZ],3,1,wf4(:,2))
  call Hloop_ST_V(ntryL,G0H16(1),0,wf4(:,2),12,G1H4(39),m3h4x4(:,58),heltab2x16(:,:,213))
  Gcoeff(:)%j = (-(c(39)*M(2,:)%j)) * den(6)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(214),h0tab(:,214),[12,1,2],[nMW,nMB,nMW],3,1,wf4(:,2))
  call Hloop_ST_V(ntryL,G0H16(1),0,wf4(:,2),12,G1H4(40),m3h4x4(:,59),heltab2x16(:,:,214))
  Gcoeff(:)%j = (c(57)*M(2,:)%j) * den(7)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(215),h0tab(:,215),[12,1,2],[nMZ,nMT,nMH],3,1,wf4(:,4))
  call Hloop_TS_V(ntryL,G0H16(1),0,wf4(:,4),12,G1H4(41),m3h4x4(:,60),heltab2x16(:,:,215))
  Gcoeff(:)%j = (-(c(39)*M(2,:)%j)) * den(7)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(216),h0tab(:,216),[12,1,2],[nMW,nMB,nMW],3,1,wf4(:,4))
  call Hloop_ST_V(ntryL,G0H16(1),0,wf4(:,4),12,G1H4(42),m3h4x4(:,61),heltab2x16(:,:,216))
  Gcoeff(:)%j = (-(c(70)*M(2,:)%j)) * den(6)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(217),h0tab(:,217),[12,1,2],[nMZ,nMT,nMZ],3,1,wf4(:,2))
  call Hloop_VS_V(ntryL,G0H16(1),wf4(:,2),G0H4(18),m3h4x4(:,62),heltab2x16(:,:,217))
  Gcoeff(:)%j = (-(c(14)*M(2,:)%j)) * den(6)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(218),h0tab(:,218),[12,1,2],[nMW,nMB,nMW],3,1,wf4(:,2))
  call Hloop_VS_V(ntryL,G0H16(1),wf4(:,2),G0H4(19),m3h4x4(:,63),heltab2x16(:,:,218))
  Gcoeff(:)%j = (c(88)*M(2,:)%j) * den(8)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(219),h0tab(:,219),[12,1,2],[nMT,nMH,nMT],3,1,wf4(:,6))
  call Hloop_AV_Q(ntryL,G0H16(1),wf4(:,6),G0H4(20),m3h4x4(:,64),heltab2x16(:,:,219))
  call Hloop_A_Q(ntryL,G0H4(20),12,nMT,G1H4(43),n2h4(57))
  Gcoeff(:)%j = (-(c(88)*M(2,:)%j)) * den(8)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(220),h0tab(:,220),[12,1,2],[nMT,nMZ,nMT],3,1,wf4(:,6))
  call Hloop_AV_Q(ntryL,G0H16(1),wf4(:,6),G0H4(20),m3h4x4(:,65),heltab2x16(:,:,220))
  call Hloop_A_Q(ntryL,G0H4(20),12,nMT,G1H4(44),n2h4(58))
  Gcoeff(:)%j = (c(74)*M(2,:)%j) * den(8)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(221),h0tab(:,221),[12,1,2],[nMB,nMW,nMB],3,1,wf4(:,6))
  call Hloop_AV_Q(ntryL,G0H16(1),wf4(:,6),G0H4(20),m3h4x4(:,66),heltab2x16(:,:,221))
  call Hloop_A_Q(ntryL,G0H4(20),12,nMB,G1H4(45),n2h4(59))
  Gcoeff(:)%j = (-(c(89)*M(2,:)%j)) * den(7)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(222),h0tab(:,222),[12,1,2],[nMT,nMH,nMT],3,1,wf4(:,8))
  call Hloop_AZ_Q(ntryL,G0H16(1),wf4(:,8),G0H4(20),ngZu,m3h4x4(:,67),heltab2x16(:,:,222))
  call Hloop_A_Q(ntryL,G0H4(20),12,nMT,G1H4(46),n2h4(60))
  Gcoeff(:)%j = (c(89)*M(2,:)%j) * den(7)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(223),h0tab(:,223),[12,1,2],[nMT,nMZ,nMT],3,1,wf4(:,8))
  call Hloop_AZ_Q(ntryL,G0H16(1),wf4(:,8),G0H4(20),ngZu,m3h4x4(:,68),heltab2x16(:,:,223))
  call Hloop_A_Q(ntryL,G0H4(20),12,nMT,G1H4(49),n2h4(61))
  Gcoeff(:)%j = (c(79)*M(2,:)%j) * den(7)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(224),h0tab(:,224),[12,1,2],[nMB,nMW,nMB],3,1,wf4(:,8))
  call Hloop_AZ_Q(ntryL,G0H16(1),wf4(:,8),G0H4(20),ngZd,m3h4x4(:,69),heltab2x16(:,:,224))
  call Hloop_A_Q(ntryL,G0H4(20),12,nMB,G1H4(50),n2h4(62))
  Gcoeff(:)%j = (-(c(76)*M(2,:)%j)) * den(8)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(225),h0tab(:,225),[12,1,2],[nMW,nMB,nMW],3,1,wf4(:,6))
  call Hloop_TV_S(ntryL,G0H16(1),0,wf4(:,6),12,G1H4(51),m3h4x4(:,70),heltab2x16(:,:,225))
  Gcoeff(:)%j = (-(c(59)*M(2,:)%j)) * den(7)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(226),h0tab(:,226),[12,1,2],[nMH,nMT,nMZ],3,1,wf4(:,8))
  call Hloop_SV_T(ntryL,G0H16(1),0,wf4(:,8),12,G1H4(52),m3h4x4(:,71),heltab2x16(:,:,226))
  Gcoeff(:)%j = (-(c(59)*M(2,:)%j)) * den(7)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(227),h0tab(:,227),[12,1,2],[nMZ,nMT,nMH],3,1,wf4(:,8))
  call Hloop_TV_S(ntryL,G0H16(1),0,wf4(:,8),12,G1H4(53),m3h4x4(:,72),heltab2x16(:,:,227))
  Gcoeff(:)%j = (-(c(104)*M(2,:)%j)) * den(7)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(228),h0tab(:,228),[12,1,2],[nMW,nMB,nMW],3,1,wf4(:,8))
  call Hloop_TV_S(ntryL,G0H16(1),0,wf4(:,8),12,G1H4(54),m3h4x4(:,73),heltab2x16(:,:,228))
  Gcoeff(:)%j = (-(c(3)*M(2,:)%j)) * den(8)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(229),h0tab(:,229),[12,1,2],[nMT,0,nMT],3,1,wf4(:,6))
  call Hloop_AV_Q(ntryL,G0H16(1),wf4(:,6),G0H4(20),m3h4x4(:,74),heltab2x16(:,:,229))
  call Hloop_A_Q(ntryL,G0H4(20),12,nMT,G1H4(55),n2h4(63))
  Gcoeff(:)%j = (-(c(5)*M(2,:)%j)) * den(8)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(230),h0tab(:,230),[12,1,2],[nMT,nMZ,nMT],3,1,wf4(:,6))
  call Hloop_AV_Q(ntryL,G0H16(1),wf4(:,6),G0H4(20),m3h4x4(:,75),heltab2x16(:,:,230))
  call Hloop_A_Q(ntryL,G0H4(20),12,nMT,G1H4(56),n2h4(64))
  Gcoeff(:)%j = (c(60)*M(2,:)%j) * den(8)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(231),h0tab(:,231),[12,1,2],[nMB,nMW,nMB],3,1,wf4(:,6))
  call Hloop_AV_Q(ntryL,G0H16(1),wf4(:,6),G0H4(20),m3h4x4(:,76),heltab2x16(:,:,231))
  call Hloop_A_Q(ntryL,G0H4(20),12,nMB,G1H4(57),n2h4(65))
  Gcoeff(:)%j = (c(6)*M(2,:)%j) * den(7)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(232),h0tab(:,232),[12,1,2],[nMT,0,nMT],3,1,wf4(:,8))
  call Hloop_AZ_Q(ntryL,G0H16(1),wf4(:,8),G0H4(20),ngZu,m3h4x4(:,77),heltab2x16(:,:,232))
  call Hloop_A_Q(ntryL,G0H4(20),12,nMT,G1H4(58),n2h4(66))
  Gcoeff(:)%j = (c(7)*M(2,:)%j) * den(7)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(233),h0tab(:,233),[12,1,2],[nMT,nMZ,nMT],3,1,wf4(:,8))
  call Hloop_AZ_Q(ntryL,G0H16(1),wf4(:,8),G0H4(20),ngZu,m3h4x4(:,78),heltab2x16(:,:,233))
  call Hloop_A_Q(ntryL,G0H4(20),12,nMT,G1H4(59),n2h4(67))
  Gcoeff(:)%j = (c(65)*M(2,:)%j) * den(7)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(234),h0tab(:,234),[12,1,2],[nMB,nMW,nMB],3,1,wf4(:,8))
  call Hloop_AZ_Q(ntryL,G0H16(1),wf4(:,8),G0H4(20),ngZd,m3h4x4(:,79),heltab2x16(:,:,234))
  call Hloop_A_Q(ntryL,G0H4(20),12,nMB,G1H4(60),n2h4(68))
  Gcoeff(:)%j = (c(62)*M(2,:)%j) * den(8)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(235),h0tab(:,235),[12,1,2],[nMW,nMB,nMW],3,1,wf4(:,6))
  call Hloop_VV_S(ntryL,G0H16(1),wf4(:,6),G0H4(20),m3h4x4(:,80),heltab2x16(:,:,235))
  Gcoeff(:)%j = (-(c(73)*M(2,:)%j)) * den(7)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(236),h0tab(:,236),[12,1,2],[nMH,nMT,nMZ],3,1,wf4(:,8))
  call Hloop_VV_S(ntryL,G0H16(1),wf4(:,8),G0H4(21),m3h4x4(:,81),heltab2x16(:,:,236))
  Gcoeff(:)%j = (c(92)*M(2,:)%j) * den(7)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(237),h0tab(:,237),[12,1,2],[nMW,nMB,nMW],3,1,wf4(:,8))
  call Hloop_VV_S(ntryL,G0H16(1),wf4(:,8),G0H4(22),m3h4x4(:,82),heltab2x16(:,:,237))
  Gcoeff(:)%j = (-(c(62)*M(2,:)%j)) * den(8)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(238),h0tab(:,238),[12,1,2],[nMW,nMB,nMW],3,1,wf4(:,6))
  call Hloop_SV_V(ntryL,G0H16(1),wf4(:,6),G0H4(23),m3h4x4(:,83),heltab2x16(:,:,238))
  Gcoeff(:)%j = (-(c(73)*M(2,:)%j)) * den(7)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(239),h0tab(:,239),[12,1,2],[nMZ,nMT,nMH],3,1,wf4(:,8))
  call Hloop_SV_V(ntryL,G0H16(1),wf4(:,8),G0H4(24),m3h4x4(:,84),heltab2x16(:,:,239))
  Gcoeff(:)%j = (-(c(92)*M(2,:)%j)) * den(7)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(240),h0tab(:,240),[12,1,2],[nMW,nMB,nMW],3,1,wf4(:,8))
  call Hloop_SV_V(ntryL,G0H16(1),wf4(:,8),G0H4(25),m3h4x4(:,85),heltab2x16(:,:,240))
  Gcoeff(:)%j = (-(c(62)*M(2,:)%j)) * den(8)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(241),h0tab(:,241),[12,1,2],[nMW,nMB,nMW],3,1,wf4(:,6))
  call Hloop_UV_W(ntryL,G0H16(1),0,wf4(:,6),12,G1H4(61),m3h4x4(:,86),heltab2x16(:,:,241))
  Gcoeff(:)%j = (c(48)*M(2,:)%j) * den(7)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(242),h0tab(:,242),[12,1,2],[nMW,nMB,nMW],3,1,wf4(:,8))
  call Hloop_UV_W(ntryL,G0H16(1),0,wf4(:,8),12,G1H4(62),m3h4x4(:,87),heltab2x16(:,:,242))
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(3),[G1H4(2)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(9),[G1H4(4)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(10),[G0H4(1)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(6),[G0H4(2)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(17),[G1H4(5)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(13),[G1H4(12)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(14),[G0H4(7)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(15),[G0H4(8)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(23),[G0H4(9)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(30),[G0H4(10)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(32),[G0H4(11)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(1),[G0H4(12)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(19),[G0H4(3)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(20),[G0H4(4)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(16),[G0H4(5)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(18),[G0H4(6)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(46),[G1H4(43),G1H4(36),G1H4(21)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(49),[G1H4(44),G1H4(25),G1H4(22)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(50),[G1H4(45),G1H4(26),G1H4(35)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(54),[G1H4(51),G0H4(15)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(52),[G0H4(16)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(53),[G0H4(17)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(58),[G1H4(55),G1H4(47),G1H4(27)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(59),[G1H4(56),G1H4(31),G1H4(28)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(60),[G1H4(57),G1H4(48),G1H4(29)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(38),[G1H4(34),G0H4(22),G0H4(20)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(37),[G0H4(21)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(42),[G1H4(40),G0H4(25),G0H4(23)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(41),[G0H4(24)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(62),[G1H4(61),G0H4(19)])
  call Hloop_AS_Q(ntryL,G1H8(1),wf4(:,1),G1H2(27),ngH,m3h4x2(:,1),heltab2x8(:,:,69))
  call Hloop_A_Q(ntryL,G1H2(27),11,nMB,G2H2(2),n2h2(33))
  call Hloop_AS_Q(ntryL,G1H8(2),wf4(:,1),G1H2(1),ngH,m3h4x2(:,2),heltab2x8(:,:,70))
  call Hloop_A_Q(ntryL,G1H2(1),11,nMB,G2H2(3),n2h2(34))
  call Hloop_AS_Q(ntryL,G1H8(3),wf4(:,1),G1H2(2),ngH,m3h4x2(:,3),heltab2x8(:,:,71))
  call Hloop_A_Q(ntryL,G1H2(2),11,nMT,G2H2(4),n2h2(35))
  call Hloop_AS_Q(ntryL,G1H8(4),wf4(:,3),G1H2(3),ngX,m3h4x2(:,4),heltab2x8(:,:,72))
  call Hloop_A_Q(ntryL,G1H2(3),11,nMB,G2H2(5),n2h2(36))
  call Hloop_AS_Q(ntryL,G1H8(5),wf4(:,3),G1H2(4),ngX,m3h4x2(:,5),heltab2x8(:,:,73))
  call Hloop_A_Q(ntryL,G1H2(4),11,nMB,G2H2(6),n2h2(37))
  call Hloop_AS_Q(ntryL,G1H8(6),wf4(:,3),G1H2(5),ngX,m3h4x2(:,6),heltab2x8(:,:,74))
  call Hloop_A_Q(ntryL,G1H2(5),11,nMT,G2H2(8),n2h2(38))
  call Hloop_SS_S(ntryL,G0H8(6),wf4(:,1),G0H2(1),m3h4x2(:,7),heltab2x8(:,:,75))
  call Hloop_SS_S(ntryL,G0H8(7),wf4(:,1),G0H2(2),m3h4x2(:,8),heltab2x8(:,:,76))
  call Hloop_SS_S(ntryL,G0H8(8),wf4(:,1),G0H2(3),m3h4x2(:,9),heltab2x8(:,:,77))
  call Hloop_SS_S(ntryL,G0H8(9),wf4(:,3),G0H2(4),m3h4x2(:,10),heltab2x8(:,:,78))
  call Hloop_SS_S(ntryL,G0H8(10),wf4(:,3),G0H2(5),m3h4x2(:,11),heltab2x8(:,:,79))
  call Hloop_AS_Q(ntryL,G1H8(7),wf4(:,1),G1H2(6),ngH,m3h4x2(:,12),heltab2x8(:,:,80))
  call Hloop_A_Q(ntryL,G1H2(6),11,nMB,G2H2(18),n2h2(39))
  call Hloop_AS_Q(ntryL,G1H8(8),wf4(:,1),G1H2(7),ngH,m3h4x2(:,13),heltab2x8(:,:,81))
  call Hloop_A_Q(ntryL,G1H2(7),11,nMB,G2H2(19),n2h2(40))
  call Hloop_AS_Q(ntryL,G1H8(9),wf4(:,1),G1H2(8),ngH,m3h4x2(:,14),heltab2x8(:,:,82))
  call Hloop_A_Q(ntryL,G1H2(8),11,nMT,G2H2(20),n2h2(41))
  call Hloop_AS_Q(ntryL,G1H8(10),wf4(:,3),G1H2(9),ngX,m3h4x2(:,15),heltab2x8(:,:,83))
  call Hloop_A_Q(ntryL,G1H2(9),11,nMB,G2H2(21),n2h2(42))
  call Hloop_AS_Q(ntryL,G1H8(11),wf4(:,3),G1H2(10),ngX,m3h4x2(:,16),heltab2x8(:,:,84))
  call Hloop_A_Q(ntryL,G1H2(10),11,nMB,G2H2(22),n2h2(43))
  call Hloop_AS_Q(ntryL,G1H8(12),wf4(:,3),G1H2(11),ngX,m3h4x2(:,17),heltab2x8(:,:,85))
  call Hloop_A_Q(ntryL,G1H2(11),11,nMT,G2H2(24),n2h2(44))
  call Hloop_VT_S(ntryL,G0H8(17),8,wf4(:,1),3,G1H2(12),m3h4x2(:,18),heltab2x8(:,:,86))
  call Hloop_VT_S(ntryL,G0H8(18),8,wf4(:,1),3,G1H2(13),m3h4x2(:,19),heltab2x8(:,:,87))
  call Hloop_VS_T(ntryL,G0H8(19),8,wf4(:,3),3,G1H2(14),m3h4x2(:,20),heltab2x8(:,:,88))
  call Hloop_VT_S(ntryL,G0H8(20),8,wf4(:,3),3,G1H2(15),m3h4x2(:,21),heltab2x8(:,:,89))
  call Hloop_ST_V(ntryL,G0H8(21),8,wf4(:,1),3,G1H2(16),m3h4x2(:,22),heltab2x8(:,:,90))
  call Hloop_ST_V(ntryL,G0H8(22),8,wf4(:,1),3,G1H2(17),m3h4x2(:,23),heltab2x8(:,:,91))
  call Hloop_TS_V(ntryL,G0H8(23),8,wf4(:,3),3,G1H2(18),m3h4x2(:,24),heltab2x8(:,:,92))
  call Hloop_ST_V(ntryL,G0H8(24),8,wf4(:,3),3,G1H2(19),m3h4x2(:,25),heltab2x8(:,:,93))
  call Hloop_VS_V(ntryL,G0H8(25),wf4(:,1),G0H2(6),m3h4x2(:,26),heltab2x8(:,:,94))
  call Hloop_VS_V(ntryL,G0H8(26),wf4(:,1),G0H2(7),m3h4x2(:,27),heltab2x8(:,:,95))
  call Hloop_AV_Q(ntryL,G1H8(13),wf4(:,5),G1H2(20),m3h4x2(:,28),heltab2x8(:,:,96))
  call Hloop_A_Q(ntryL,G1H2(20),11,nMB,G2H2(1),n2h2(45))
  call Hloop_AV_Q(ntryL,G1H8(14),wf4(:,5),G1H2(21),m3h4x2(:,29),heltab2x8(:,:,97))
  call Hloop_A_Q(ntryL,G1H2(21),11,nMB,G2H2(11),n2h2(46))
  call Hloop_AV_Q(ntryL,G1H8(15),wf4(:,5),G1H2(22),m3h4x2(:,30),heltab2x8(:,:,98))
  call Hloop_A_Q(ntryL,G1H2(22),11,nMT,G2H2(10),n2h2(47))
  call Hloop_AZ_Q(ntryL,G1H8(16),wf4(:,7),G1H2(23),ngZd,m3h4x2(:,31),heltab2x8(:,:,99))
  call Hloop_A_Q(ntryL,G1H2(23),11,nMB,G2H2(12),n2h2(48))
  call Hloop_AZ_Q(ntryL,G1H8(17),wf4(:,7),G1H2(24),ngZd,m3h4x2(:,32),heltab2x8(:,:,100))
  call Hloop_A_Q(ntryL,G1H2(24),11,nMB,G2H2(14),n2h2(49))
  call Hloop_AZ_Q(ntryL,G1H8(18),wf4(:,7),G1H2(25),ngZu,m3h4x2(:,33),heltab2x8(:,:,101))
  call Hloop_A_Q(ntryL,G1H2(25),11,nMT,G2H2(16),n2h2(50))
  call Hloop_SV_T(ntryL,G0H8(33),8,wf4(:,5),3,G1H2(26),m3h4x2(:,34),heltab2x8(:,:,102))
  call Hloop_SV_T(ntryL,G0H8(34),8,wf4(:,7),3,G1H2(27),m3h4x2(:,35),heltab2x8(:,:,103))
  call Hloop_TV_S(ntryL,G0H8(35),8,wf4(:,7),3,G1H2(1),m3h4x2(:,36),heltab2x8(:,:,104))
  call Hloop_SV_T(ntryL,G0H8(36),8,wf4(:,7),3,G1H2(2),m3h4x2(:,37),heltab2x8(:,:,105))
  call Hloop_AV_Q(ntryL,G1H8(19),wf4(:,5),G1H2(3),m3h4x2(:,38),heltab2x8(:,:,106))
  call Hloop_A_Q(ntryL,G1H2(3),11,nMB,G2H2(7),n2h2(51))
  call Hloop_AV_Q(ntryL,G1H8(20),wf4(:,5),G1H2(4),m3h4x2(:,39),heltab2x8(:,:,107))
  call Hloop_A_Q(ntryL,G1H2(4),11,nMB,G2H2(15),n2h2(52))
  call Hloop_AV_Q(ntryL,G1H8(21),wf4(:,5),G1H2(5),m3h4x2(:,40),heltab2x8(:,:,108))
  call Hloop_A_Q(ntryL,G1H2(5),11,nMT,G2H2(9),n2h2(53))
  call Hloop_AZ_Q(ntryL,G1H8(22),wf4(:,7),G1H2(6),ngZd,m3h4x2(:,41),heltab2x8(:,:,109))
  call Hloop_A_Q(ntryL,G1H2(6),11,nMB,G2H2(13),n2h2(54))
  call Hloop_AZ_Q(ntryL,G1H8(23),wf4(:,7),G1H2(7),ngZd,m3h4x2(:,42),heltab2x8(:,:,110))
  call Hloop_A_Q(ntryL,G1H2(7),11,nMB,G2H2(17),n2h2(55))
  call Hloop_AZ_Q(ntryL,G1H8(24),wf4(:,7),G1H2(8),ngZu,m3h4x2(:,43),heltab2x8(:,:,111))
  call Hloop_A_Q(ntryL,G1H2(8),11,nMT,G2H2(27),n2h2(56))
  call Hloop_VV_S(ntryL,G0H8(11),wf4(:,5),G0H2(8),m3h4x2(:,44),heltab2x8(:,:,112))
  call Hloop_VV_S(ntryL,G0H8(12),wf4(:,7),G0H2(9),m3h4x2(:,45),heltab2x8(:,:,113))
  call Hloop_VV_S(ntryL,G0H8(13),wf4(:,7),G0H2(10),m3h4x2(:,46),heltab2x8(:,:,114))
  call Hloop_SV_V(ntryL,G0H8(14),wf4(:,5),G0H2(11),m3h4x2(:,47),heltab2x8(:,:,115))
  call Hloop_SV_V(ntryL,G0H8(15),wf4(:,7),G0H2(12),m3h4x2(:,48),heltab2x8(:,:,116))
  call Hloop_SV_V(ntryL,G0H8(16),wf4(:,7),G0H2(13),m3h4x2(:,49),heltab2x8(:,:,117))
  call Hloop_UW_V(ntryL,G0H8(27),8,wf4(:,5),3,G1H2(9),m3h4x2(:,50),heltab2x8(:,:,118))
  call Hloop_UW_V(ntryL,G0H8(28),8,wf4(:,7),3,G1H2(10),m3h4x2(:,51),heltab2x8(:,:,119))
  call Hloop_SQ_A(ntryL,G0H8(29),ex1(:),G0H4(1),ngH,m3h2x4(:,69),heltab2x8(:,:,120))
  call Hloop_Q_A(ntryL,G0H4(1),9,nMT,G1H4(63),n2h4(69))
  call Hloop_SQ_A(ntryL,G0H8(30),ex1(:),G0H4(2),ngX,m3h2x4(:,70),heltab2x8(:,:,121))
  call Hloop_Q_A(ntryL,G0H4(2),9,nMT,G1H4(64),n2h4(70))
  call Hloop_AQ_S(ntryL,G1H8(25),ex1(:),G1H4(65),ngH,m3h2x4(:,71),heltab2x8(:,:,122))
  call Hloop_AQ_S(ntryL,G1H8(26),ex1(:),G1H4(66),ngPbt,m3h2x4(:,72),heltab2x8(:,:,123))
  call Hloop_VQ_A(ntryL,G0H8(37),ex1(:),G0H4(7),m3h2x4(:,73),heltab2x8(:,:,124))
  call Hloop_Q_A(ntryL,G0H4(7),9,nMT,G1H4(67),n2h4(71))
  call Hloop_ZQ_A(ntryL,G0H8(1),ex1(:),G0H4(8),ngZu,m3h2x4(:,74),heltab2x8(:,:,125))
  call Hloop_Q_A(ntryL,G0H4(8),9,nMT,G1H4(68),n2h4(72))
  call Hloop_AQ_S(ntryL,G1H8(27),ex1(:),G1H4(2),ngPbt,m3h2x4(:,75),heltab2x8(:,:,126))
  call Hloop_AQ_S(ntryL,G1H8(28),ex1(:),G1H4(4),ngPbt,m3h2x4(:,76),heltab2x8(:,:,127))
  call Hloop_AQ_S(ntryL,G1H8(29),ex1(:),G1H4(5),ngH,m3h2x4(:,77),heltab2x8(:,:,128))
  call Hloop_AQ_S(ntryL,G1H8(30),ex1(:),G1H4(12),ngX,m3h2x4(:,78),heltab2x8(:,:,129))
  call Hloop_AQ_V(ntryL,G1H8(31),ex1(:),G1H4(43),m3h2x4(:,79),heltab2x8(:,:,130))
  call Hloop_AQ_Z(ntryL,G1H8(32),ex1(:),G1H4(36),ngZu,m3h2x4(:,80),heltab2x8(:,:,131))
  call Hloop_AQ_W(ntryL,G1H8(33),ex1(:),G1H4(21),m3h2x4(:,81),heltab2x8(:,:,132))
  call Hloop_AQ_W(ntryL,G1H8(34),ex1(:),G1H4(44),m3h2x4(:,82),heltab2x8(:,:,133))
  call Hloop_AQ_V(ntryL,G1H8(35),ex1(:),G1H4(25),m3h2x4(:,83),heltab2x8(:,:,134))
  call Hloop_AQ_W(ntryL,G1H8(36),ex1(:),G1H4(22),m3h2x4(:,84),heltab2x8(:,:,135))
  call Hloop_AQ_Z(ntryL,G1H8(37),ex1(:),G1H4(45),ngZu,m3h2x4(:,85),heltab2x8(:,:,136))
  call Hloop_AQ_W(ntryL,G1H8(38),ex1(:),G1H4(26),m3h2x4(:,86),heltab2x8(:,:,137))
  call Hloop_SQ_A(ntryL,G0H8(2),ex1(:),G0H4(9),ngH,m3h2x4(:,87),heltab2x8(:,:,138))
  call Hloop_Q_A(ntryL,G0H4(9),9,nMT,G1H4(35),n2h4(73))
  call Hloop_SQ_A(ntryL,G0H8(3),ex1(:),G0H4(10),ngX,m3h2x4(:,88),heltab2x8(:,:,139))
  call Hloop_Q_A(ntryL,G0H4(10),9,nMT,G1H4(51),n2h4(74))
  call Hloop_AQ_S(ntryL,G1H8(39),ex1(:),G1H4(55),ngH,m3h2x4(:,89),heltab2x8(:,:,140))
  call Hloop_AQ_S(ntryL,G1H8(40),ex1(:),G1H4(47),ngPbt,m3h2x4(:,90),heltab2x8(:,:,141))
  call Hloop_AQ_S(ntryL,G1H8(41),ex1(:),G1H4(27),ngX,m3h2x4(:,91),heltab2x8(:,:,142))
  call Hloop_AQ_S(ntryL,G1H8(42),ex1(:),G1H4(56),ngPbt,m3h2x4(:,92),heltab2x8(:,:,143))
  call Hloop_VQ_A(ntryL,G0H8(4),ex1(:),G0H4(11),m3h2x4(:,93),heltab2x8(:,:,144))
  call Hloop_Q_A(ntryL,G0H4(11),9,nMT,G1H4(31),n2h4(75))
  call Hloop_ZQ_A(ntryL,G0H8(5),ex1(:),G0H4(12),ngZu,m3h2x4(:,94),heltab2x8(:,:,145))
  call Hloop_Q_A(ntryL,G0H4(12),9,nMT,G1H4(28),n2h4(76))
  call Hloop_AQ_S(ntryL,G1H8(43),ex1(:),G1H4(57),ngPbt,m3h2x4(:,95),heltab2x8(:,:,146))
  call Hloop_AQ_S(ntryL,G1H8(44),ex1(:),G1H4(48),ngPbt,m3h2x4(:,96),heltab2x8(:,:,147))
  call Hloop_AQ_S(ntryL,G1H8(45),ex1(:),G1H4(29),ngH,m3h2x4(:,97),heltab2x8(:,:,148))
  call Hloop_AQ_V(ntryL,G1H8(46),ex1(:),G1H4(34),m3h2x4(:,98),heltab2x8(:,:,149))
  call Hloop_AQ_Z(ntryL,G1H8(47),ex1(:),G1H4(40),ngZu,m3h2x4(:,99),heltab2x8(:,:,150))
  call Hloop_AQ_W(ntryL,G1H8(48),ex1(:),G1H4(61),m3h2x4(:,100),heltab2x8(:,:,151))
  call Hloop_AQ_V(ntryL,G1H8(49),ex1(:),G1H4(69),m3h2x4(:,101),heltab2x8(:,:,152))
  call Hloop_AQ_W(ntryL,G1H8(50),ex1(:),G1H4(70),m3h2x4(:,102),heltab2x8(:,:,153))
  call Hloop_AQ_Z(ntryL,G1H8(51),ex1(:),G1H4(71),ngZu,m3h2x4(:,103),heltab2x8(:,:,154))
  call Hloop_AQ_W(ntryL,G1H8(52),ex1(:),G1H4(72),m3h2x4(:,104),heltab2x8(:,:,155))
  call Hloop_QA_S(ntryL,G1H4(3),ex2(:),G1H2(11),ngH,m3h2x2(:,59),heltab2x4(:,:,59))
  call Hloop_QA_S(ntryL,G1H4(9),ex2(:),G1H2(20),ngX,m3h2x2(:,60),heltab2x4(:,:,60))
  call Hloop_SA_Q(ntryL,G1H4(10),ex2(:),G1H2(21),ngH,m3h2x2(:,61),heltab2x4(:,:,61))
  call Hloop_A_Q(ntryL,G1H2(21),11,nMT,G2H2(26),n2h2(57))
  call Hloop_SA_Q(ntryL,G1H4(6),ex2(:),G1H2(22),ngPtb,m3h2x2(:,62),heltab2x4(:,:,62))
  call Hloop_A_Q(ntryL,G1H2(22),11,nMB,G2H2(28),n2h2(58))
  call Hloop_QA_V(ntryL,G1H4(17),ex2(:),G1H2(23),m3h2x2(:,63),heltab2x4(:,:,63))
  call Hloop_QA_Z(ntryL,G1H4(13),ex2(:),G1H2(24),ngZu,m3h2x2(:,64),heltab2x4(:,:,64))
  call Hloop_SA_Q(ntryL,G1H4(14),ex2(:),G1H2(25),ngPtb,m3h2x2(:,65),heltab2x4(:,:,65))
  call Hloop_A_Q(ntryL,G1H2(25),11,nMB,G2H2(30),n2h2(59))
  call Hloop_SA_Q(ntryL,G1H4(15),ex2(:),G1H2(3),ngPtb,m3h2x2(:,66),heltab2x4(:,:,66))
  call Hloop_A_Q(ntryL,G1H2(3),11,nMB,G2H2(32),n2h2(60))
  call Hloop_SA_Q(ntryL,G1H4(23),ex2(:),G1H2(4),ngH,m3h2x2(:,67),heltab2x4(:,:,67))
  call Hloop_A_Q(ntryL,G1H2(4),11,nMT,G2H2(23),n2h2(61))
  call Hloop_SA_Q(ntryL,G1H4(24),ex2(:),G1H2(5),ngX,m3h2x2(:,68),heltab2x4(:,:,68))
  call Hloop_A_Q(ntryL,G1H2(5),11,nMT,G2H2(31),n2h2(62))
  call Hloop_VA_Q(ntryL,G1H4(30),ex2(:),G1H2(6),m3h2x2(:,69),heltab2x4(:,:,69))
  call Hloop_A_Q(ntryL,G1H2(6),11,nMT,G2H2(25),n2h2(63))
  call Hloop_ZA_Q(ntryL,G1H4(32),ex2(:),G1H2(7),ngZu,m3h2x2(:,70),heltab2x4(:,:,70))
  call Hloop_A_Q(ntryL,G1H2(7),11,nMT,G2H2(29),n2h2(64))
  call Hloop_WA_Q(ntryL,G1H4(1),ex2(:),G1H2(8),m3h2x2(:,71),heltab2x4(:,:,71))
  call Hloop_A_Q(ntryL,G1H2(8),11,nMB,G2H2(33),n2h2(65))
  call Hloop_WA_Q(ntryL,G1H4(8),ex2(:),G1H2(21),m3h2x2(:,72),heltab2x4(:,:,72))
  call Hloop_A_Q(ntryL,G1H2(21),11,nMB,G2H2(34),n2h2(66))
  call Hloop_VA_Q(ntryL,G1H4(19),ex2(:),G1H2(22),m3h2x2(:,73),heltab2x4(:,:,73))
  call Hloop_A_Q(ntryL,G1H2(22),11,nMT,G2H2(35),n2h2(67))
  call Hloop_WA_Q(ntryL,G1H4(20),ex2(:),G1H2(25),m3h2x2(:,74),heltab2x4(:,:,74))
  call Hloop_A_Q(ntryL,G1H2(25),11,nMB,G2H2(36),n2h2(68))
  call Hloop_ZA_Q(ntryL,G1H4(16),ex2(:),G1H2(3),ngZu,m3h2x2(:,75),heltab2x4(:,:,75))
  call Hloop_A_Q(ntryL,G1H2(3),11,nMT,G2H2(37),n2h2(69))
  call Hloop_WA_Q(ntryL,G1H4(18),ex2(:),G1H2(4),m3h2x2(:,76),heltab2x4(:,:,76))
  call Hloop_A_Q(ntryL,G1H2(4),11,nMB,G2H2(38),n2h2(70))
  call Hloop_SA_Q(ntryL,G1H4(7),ex2(:),G1H2(5),ngX,m3h2x2(:,77),heltab2x4(:,:,77))
  call Hloop_A_Q(ntryL,G1H2(5),11,nMT,G2H2(39),n2h2(71))
  call Hloop_SA_Q(ntryL,G1H4(11),ex2(:),G1H2(6),ngPtb,m3h2x2(:,78),heltab2x4(:,:,78))
  call Hloop_A_Q(ntryL,G1H2(6),11,nMB,G2H2(40),n2h2(72))
  call Hloop_AQ_S(ntryL,G1H4(46),ex1(:),G1H2(7),ngH,m3h2x2(:,79),heltab2x4(:,:,79))
  call Hloop_AQ_S(ntryL,G1H4(49),ex1(:),G1H2(8),ngX,m3h2x2(:,80),heltab2x4(:,:,80))
  call Hloop_AQ_S(ntryL,G1H4(50),ex1(:),G1H2(21),ngPbt,m3h2x2(:,81),heltab2x4(:,:,81))
  call Hloop_SQ_A(ntryL,G0H4(13),ex1(:),G0H2(14),ngH,m3h2x2(:,82),heltab2x4(:,:,82))
  call Hloop_Q_A(ntryL,G0H2(14),13,nMT,G1H2(22),n2h2(73))
  call Hloop_SQ_A(ntryL,G0H4(14),ex1(:),G0H2(14),ngX,m3h2x2(:,83),heltab2x4(:,:,83))
  call Hloop_Q_A(ntryL,G0H2(14),13,nMT,G1H2(25),n2h2(74))
  call Hloop_SQ_A(ntryL,G1H4(54),ex1(:),G1H2(3),ngPbt,m3h2x2(:,84),heltab2x4(:,:,84))
  call Hloop_Q_A(ntryL,G1H2(3),13,nMB,G2H2(41),n2h2(75))
  call Hloop_SQ_A(ntryL,G1H4(52),ex1(:),G1H2(4),ngH,m3h2x2(:,85),heltab2x4(:,:,85))
  call Hloop_Q_A(ntryL,G1H2(4),13,nMT,G2H2(42),n2h2(76))
  call Hloop_SQ_A(ntryL,G1H4(53),ex1(:),G1H2(5),ngX,m3h2x2(:,86),heltab2x4(:,:,86))
  call Hloop_Q_A(ntryL,G1H2(5),13,nMT,G2H2(43),n2h2(77))
  call Hloop_AQ_V(ntryL,G1H4(58),ex1(:),G1H2(6),m3h2x2(:,87),heltab2x4(:,:,87))
  call Hloop_AQ_Z(ntryL,G1H4(59),ex1(:),G1H2(3),ngZu,m3h2x2(:,88),heltab2x4(:,:,88))
  call Hloop_AQ_W(ntryL,G1H4(60),ex1(:),G1H2(4),m3h2x2(:,89),heltab2x4(:,:,89))
  call Hloop_SQ_A(ntryL,G1H4(33),ex1(:),G1H2(5),ngX,m3h2x2(:,90),heltab2x4(:,:,90))
  call Hloop_Q_A(ntryL,G1H2(5),13,nMT,G2H2(44),n2h2(78))
  call Hloop_SQ_A(ntryL,G1H4(38),ex1(:),G1H2(5),ngPbt,m3h2x2(:,91),heltab2x4(:,:,91))
  call Hloop_Q_A(ntryL,G1H2(5),13,nMB,G2H2(45),n2h2(79))
  call Hloop_SQ_A(ntryL,G1H4(37),ex1(:),G1H2(5),ngH,m3h2x2(:,92),heltab2x4(:,:,92))
  call Hloop_Q_A(ntryL,G1H2(5),13,nMT,G2H2(46),n2h2(80))
  call Hloop_ZQ_A(ntryL,G1H4(39),ex1(:),G1H2(5),ngZu,m3h2x2(:,93),heltab2x4(:,:,93))
  call Hloop_Q_A(ntryL,G1H2(5),13,nMT,G2H2(47),n2h2(81))
  call Hloop_WQ_A(ntryL,G1H4(42),ex1(:),G1H2(5),m3h2x2(:,94),heltab2x4(:,:,94))
  call Hloop_Q_A(ntryL,G1H2(5),13,nMB,G2H2(48),n2h2(82))
  call Hloop_ZQ_A(ntryL,G1H4(41),ex1(:),G1H2(5),ngZu,m3h2x2(:,95),heltab2x4(:,:,95))
  call Hloop_Q_A(ntryL,G1H2(5),13,nMT,G2H2(49),n2h2(83))
  call Hloop_ZQ_A(ntryL,G0H4(18),ex1(:),G0H2(14),ngZu,m3h2x2(:,96),heltab2x4(:,:,96))
  call Hloop_Q_A(ntryL,G0H2(14),13,nMT,G1H2(5),n2h2(84))
  call Hloop_WQ_A(ntryL,G1H4(62),ex1(:),G1H2(28),m3h2x2(:,97),heltab2x4(:,:,97))
  call Hloop_Q_A(ntryL,G1H2(28),13,nMB,G2H2(50),n2h2(85))
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(12),[G2H2(1),G2H2(5),G2H2(2)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(14),[G2H2(11),G2H2(6),G2H2(3)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(16),[G2H2(10),G2H2(8),G2H2(4)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(12),[G0H2(2)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(2),[G1H2(26),G1H2(15),G1H2(13),G0H2(10),G0H2(8) &
    ,G0H2(3)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(27),[G1H2(14),G0H2(9),G0H2(4)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(1),[G0H2(5)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(13),[G2H2(7),G2H2(21),G2H2(18)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(17),[G2H2(15),G2H2(22),G2H2(19)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(27),[G2H2(9),G2H2(24),G2H2(20)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(16),[G0H2(6)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(10),[G1H2(9),G1H2(19),G1H2(17),G0H2(13),G0H2(11) &
    ,G0H2(7)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(18),[G0H2(12)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(68),[G1H4(64)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(28),[G1H4(51)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(33),[G2H2(28)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(36),[G2H2(30)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(38),[G2H2(32)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(37),[G2H2(31)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(39),[G2H2(29)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(40),[G2H2(34)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(47),[G1H2(25)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(48),[G2H2(41)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(49),[G2H2(43)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(44),[G1H2(5)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(50),[G2H2(45)])
  call Hcheck_last_AQ_S(ntryL,l_switch,G2H2(12),ex3(:),G2tensor(3),ngH,m3h2x1(:,47),heltab2x2(:,:,47))
  call Hcheck_last_AQ_S(ntryL,l_switch,G2H2(14),ex3(:),G2tensor(4),ngX,m3h2x1(:,48),heltab2x2(:,:,48))
  call Hcheck_last_AQ_S(ntryL,l_switch,G2H2(16),ex3(:),G2tensor(5),ngPtb,m3h2x1(:,49),heltab2x2(:,:,49))
  call Hloop_SQ_A(ntryL,G0H2(1),ex3(:),G0H1(1),ngH,m3h2x1(:,50),heltab2x2(:,:,50))
  call Hcheck_last_Q_A(ntryL,l_switch,G0H1(1),15,nMB,G1tensor(1),n2h1(27))
  call Hloop_SQ_A(ntryL,G1H2(12),ex3(:),G1H1(1),ngX,m3h2x1(:,51),heltab2x2(:,:,51))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),15,nMB,G2tensor(7),n2h1(28))
  call Hloop_SQ_A(ntryL,G1H2(2),ex3(:),G1H1(1),ngPtb,m3h2x1(:,52),heltab2x2(:,:,52))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),15,nMT,G2tensor(16),n2h1(29))
  call Hloop_SQ_A(ntryL,G1H2(27),ex3(:),G1H1(1),ngH,m3h2x1(:,53),heltab2x2(:,:,53))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),15,nMB,G2tensor(18),n2h1(30))
  call Hloop_SQ_A(ntryL,G1H2(1),ex3(:),G1H1(1),ngX,m3h2x1(:,54),heltab2x2(:,:,54))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),15,nMB,G2tensor(19),n2h1(31))
  call Hcheck_last_AQ_V(ntryL,l_switch,G2H2(13),ex3(:),G2tensor(21),m3h2x1(:,55),heltab2x2(:,:,55))
  call Hcheck_last_AQ_Z(ntryL,l_switch,G2H2(17),ex3(:),G2tensor(22),ngZd,m3h2x1(:,56),heltab2x2(:,:,56))
  call Hcheck_last_AQ_W(ntryL,l_switch,G2H2(27),ex3(:),G2tensor(28),m3h2x1(:,57),heltab2x2(:,:,57))
  call Hloop_ZQ_A(ntryL,G1H2(16),ex3(:),G1H1(1),ngZd,m3h2x1(:,58),heltab2x2(:,:,58))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),15,nMB,G2tensor(33),n2h1(32))
  call Hloop_WQ_A(ntryL,G1H2(10),ex3(:),G1H1(1),m3h2x1(:,59),heltab2x2(:,:,59))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),15,nMT,G2tensor(37),n2h1(33))
  call Hloop_ZQ_A(ntryL,G1H2(18),ex3(:),G1H1(1),ngZd,m3h2x1(:,60),heltab2x2(:,:,60))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),15,nMB,G2tensor(39),n2h1(34))
  call Hloop_QS_A(ntryL,G1H4(63),wf4(:,10),G1H1(1),ngPbt,m3h4x1(:,1),heltab2x4(:,:,98))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),15,nMB,G2tensor(40),n2h1(35))
  call Hloop_QS_A(ntryL,G1H4(68),wf4(:,10),G1H1(1),ngPbt,m3h4x1(:,2),heltab2x4(:,:,99))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),15,nMB,G2tensor(45),n2h1(36))
  call Hcheck_last_SS_S(ntryL,l_switch,G1H4(65),wf4(:,10),G1tensor(6),m3h4x1(:,3),heltab2x4(:,:,100))
  call Hcheck_last_SS_S(ntryL,l_switch,G1H4(66),wf4(:,10),G1tensor(11),m3h4x1(:,4),heltab2x4(:,:,101))
  call Hloop_QS_A(ntryL,G1H4(67),wf4(:,10),G1H1(1),ngPbt,m3h4x1(:,5),heltab2x4(:,:,102))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),15,nMB,G2tensor(1),n2h1(37))
  call Hcheck_last_ST_V(ntryL,l_switch,G1H4(2),9,wf4(:,10),6,G2tensor(2),m3h4x1(:,6),heltab2x4(:,:,103))
  call Hcheck_last_ST_V(ntryL,l_switch,G1H4(4),9,wf4(:,10),6,G2tensor(10),m3h4x1(:,7),heltab2x4(:,:,104))
  call Hcheck_last_TS_V(ntryL,l_switch,G1H4(5),9,wf4(:,10),6,G2tensor(11),m3h4x1(:,8),heltab2x4(:,:,105))
  call Hcheck_last_TS_V(ntryL,l_switch,G1H4(12),9,wf4(:,10),6,G2tensor(12),m3h4x1(:,9),heltab2x4(:,:,106))
  call Hcheck_last_VT_S(ntryL,l_switch,G1H4(43),9,wf4(:,10),6,G2tensor(6),m3h4x1(:,10),heltab2x4(:,:,107))
  call Hcheck_last_VT_S(ntryL,l_switch,G1H4(36),9,wf4(:,10),6,G2tensor(14),m3h4x1(:,11),heltab2x4(:,:,108))
  call Hcheck_last_VS_T(ntryL,l_switch,G1H4(21),9,wf4(:,10),6,G2tensor(8),m3h4x1(:,12),heltab2x4(:,:,109))
  call Hcheck_last_VS_T(ntryL,l_switch,G1H4(44),9,wf4(:,10),6,G2tensor(9),m3h4x1(:,13),heltab2x4(:,:,110))
  call Hcheck_last_VS_V(ntryL,l_switch,G1H4(25),wf4(:,10),G1tensor(16),m3h4x1(:,14),heltab2x4(:,:,111))
  call Hcheck_last_VS_V(ntryL,l_switch,G1H4(22),wf4(:,10),G1tensor(21),m3h4x1(:,15),heltab2x4(:,:,112))
  call Hcheck_last_VS_V(ntryL,l_switch,G1H4(45),wf4(:,10),G1tensor(26),m3h4x1(:,16),heltab2x4(:,:,113))
  call Hcheck_last_VS_V(ntryL,l_switch,G1H4(26),wf4(:,10),G1tensor(31),m3h4x1(:,17),heltab2x4(:,:,114))
  call Hloop_QW_A(ntryL,G1H4(35),wf4(:,12),G1H1(1),m3h4x1(:,18),heltab2x4(:,:,115))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),15,nMB,G2tensor(13),n2h1(38))
  call Hloop_QW_A(ntryL,G1H4(28),wf4(:,12),G1H1(1),m3h4x1(:,19),heltab2x4(:,:,116))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),15,nMB,G2tensor(15),n2h1(39))
  call Hcheck_last_TV_S(ntryL,l_switch,G1H4(55),9,wf4(:,12),6,G2tensor(25),m3h4x1(:,20),heltab2x4(:,:,117))
  call Hcheck_last_SV_T(ntryL,l_switch,G1H4(47),9,wf4(:,12),6,G2tensor(17),m3h4x1(:,21),heltab2x4(:,:,118))
  call Hcheck_last_TV_S(ntryL,l_switch,G1H4(27),9,wf4(:,12),6,G2tensor(26),m3h4x1(:,22),heltab2x4(:,:,119))
  call Hcheck_last_SV_T(ntryL,l_switch,G1H4(56),9,wf4(:,12),6,G2tensor(31),m3h4x1(:,23),heltab2x4(:,:,120))
  call Hloop_QW_A(ntryL,G1H4(31),wf4(:,12),G1H1(1),m3h4x1(:,24),heltab2x4(:,:,121))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),15,nMB,G2tensor(20),n2h1(40))
  call Hcheck_last_SV_V(ntryL,l_switch,G1H4(57),wf4(:,12),G1tensor(36),m3h4x1(:,25),heltab2x4(:,:,122))
  call Hcheck_last_SV_V(ntryL,l_switch,G1H4(48),wf4(:,12),G1tensor(41),m3h4x1(:,26),heltab2x4(:,:,123))
  call Hcheck_last_SV_V(ntryL,l_switch,G1H4(29),wf4(:,12),G1tensor(46),m3h4x1(:,27),heltab2x4(:,:,124))
  call Hcheck_last_VV_S(ntryL,l_switch,G1H4(34),wf4(:,12),G1tensor(51),m3h4x1(:,28),heltab2x4(:,:,125))
  call Hcheck_last_VV_S(ntryL,l_switch,G1H4(40),wf4(:,12),G1tensor(56),m3h4x1(:,29),heltab2x4(:,:,126))
  call Hcheck_last_VV_S(ntryL,l_switch,G1H4(61),wf4(:,12),G1tensor(61),m3h4x1(:,30),heltab2x4(:,:,127))
  call Hcheck_last_UW_V(ntryL,l_switch,G1H4(69),9,wf4(:,12),6,G2tensor(32),m3h4x1(:,31),heltab2x4(:,:,128))
  call Hcheck_last_UV_W(ntryL,l_switch,G1H4(70),9,wf4(:,12),6,G2tensor(30),m3h4x1(:,32),heltab2x4(:,:,129))
  call Hcheck_last_UW_V(ntryL,l_switch,G1H4(71),9,wf4(:,12),6,G2tensor(23),m3h4x1(:,33),heltab2x4(:,:,130))
  call Hcheck_last_UV_W(ntryL,l_switch,G1H4(72),9,wf4(:,12),6,G2tensor(24),m3h4x1(:,34),heltab2x4(:,:,131))
  call Hloop_SQ_A(ntryL,G1H2(11),ex3(:),G1H1(1),ngH,m3h2x1(:,61),heltab2x2(:,:,61))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),15,nMB,G2tensor(27),n2h1(41))
  call Hloop_SQ_A(ntryL,G1H2(20),ex3(:),G1H1(1),ngX,m3h2x1(:,62),heltab2x2(:,:,62))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),15,nMB,G2tensor(35),n2h1(42))
  call Hcheck_last_AQ_S(ntryL,l_switch,G2H2(26),ex3(:),G2tensor(29),ngPtb,m3h2x1(:,63),heltab2x2(:,:,63))
  call Hcheck_last_AQ_S(ntryL,l_switch,G2H2(33),ex3(:),G2tensor(36),ngH,m3h2x1(:,64),heltab2x2(:,:,64))
  call Hloop_VQ_A(ntryL,G1H2(23),ex3(:),G1H1(1),m3h2x1(:,65),heltab2x2(:,:,65))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),15,nMB,G2tensor(34),n2h1(43))
  call Hloop_ZQ_A(ntryL,G1H2(24),ex3(:),G1H1(1),ngZd,m3h2x1(:,66),heltab2x2(:,:,66))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),15,nMB,G2tensor(43),n2h1(44))
  call Hcheck_last_AQ_V(ntryL,l_switch,G2H2(36),ex3(:),G2tensor(38),m3h2x1(:,67),heltab2x2(:,:,67))
  call Hcheck_last_AQ_Z(ntryL,l_switch,G2H2(38),ex3(:),G2tensor(44),ngZd,m3h2x1(:,68),heltab2x2(:,:,68))
  call Hcheck_last_AQ_W(ntryL,l_switch,G2H2(23),ex3(:),G2tensor(42),m3h2x1(:,69),heltab2x2(:,:,69))
  call Hcheck_last_AQ_W(ntryL,l_switch,G2H2(37),ex3(:),G2tensor(41),m3h2x1(:,70),heltab2x2(:,:,70))
  call Hcheck_last_AQ_S(ntryL,l_switch,G2H2(25),ex3(:),G2tensor(46),ngPtb,m3h2x1(:,71),heltab2x2(:,:,71))
  call Hcheck_last_AQ_S(ntryL,l_switch,G2H2(39),ex3(:),G2tensor(47),ngPtb,m3h2x1(:,72),heltab2x2(:,:,72))
  call Hcheck_last_AQ_S(ntryL,l_switch,G2H2(40),ex3(:),G2tensor(48),ngX,m3h2x1(:,73),heltab2x2(:,:,73))
  call Hcheck_last_AQ_W(ntryL,l_switch,G2H2(35),ex3(:),G2tensor(49),m3h2x1(:,74),heltab2x2(:,:,74))
  call Hloop_SA_Q(ntryL,G1H2(7),ex2(:),G1H1(1),ngH,m3h2x1(:,75),heltab2x2(:,:,75))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),15,nMT,G2tensor(50),n2h1(45))
  call Hloop_SA_Q(ntryL,G1H2(8),ex2(:),G1H1(1),ngX,m3h2x1(:,76),heltab2x2(:,:,76))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),15,nMT,G2tensor(51),n2h1(46))
  call Hloop_SA_Q(ntryL,G1H2(21),ex2(:),G1H1(1),ngPtb,m3h2x1(:,77),heltab2x2(:,:,77))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),15,nMB,G2tensor(52),n2h1(47))
  call Hcheck_last_QA_S(ntryL,l_switch,G1H2(22),ex2(:),G1tensor(66),ngH,m3h2x1(:,78),heltab2x2(:,:,78))
  call Hcheck_last_QA_S(ntryL,l_switch,G2H2(47),ex2(:),G2tensor(53),ngX,m3h2x1(:,79),heltab2x2(:,:,79))
  call Hcheck_last_QA_S(ntryL,l_switch,G2H2(48),ex2(:),G2tensor(54),ngPtb,m3h2x1(:,80),heltab2x2(:,:,80))
  call Hcheck_last_QA_S(ntryL,l_switch,G2H2(42),ex2(:),G2tensor(55),ngX,m3h2x1(:,81),heltab2x2(:,:,81))
  call Hcheck_last_QA_S(ntryL,l_switch,G2H2(49),ex2(:),G2tensor(56),ngH,m3h2x1(:,82),heltab2x2(:,:,82))
  call Hloop_VA_Q(ntryL,G1H2(6),ex2(:),G1H1(1),m3h2x1(:,83),heltab2x2(:,:,83))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),15,nMT,G2tensor(57),n2h1(48))
  call Hloop_ZA_Q(ntryL,G1H2(3),ex2(:),G1H1(1),ngZu,m3h2x1(:,84),heltab2x2(:,:,84))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),15,nMT,G2tensor(58),n2h1(49))
  call Hloop_WA_Q(ntryL,G1H2(4),ex2(:),G1H1(1),m3h2x1(:,85),heltab2x2(:,:,85))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),15,nMB,G2tensor(59),n2h1(50))
  call Hcheck_last_QA_Z(ntryL,l_switch,G2H2(44),ex2(:),G2tensor(60),ngZu,m3h2x1(:,86),heltab2x2(:,:,86))
  call Hcheck_last_QA_W(ntryL,l_switch,G2H2(50),ex2(:),G2tensor(61),m3h2x1(:,87),heltab2x2(:,:,87))
  call Hcheck_last_QA_Z(ntryL,l_switch,G2H2(46),ex2(:),G2tensor(62),ngZu,m3h2x1(:,88),heltab2x2(:,:,88))
  call ol_merge_tensors(G1tensor(2),[G0tensor(2)])
  call ol_merge_tensors(G1tensor(127),[G1tensor(28),G1tensor(8),G1tensor(3),G0tensor(127),G0tensor(28),G0tensor(8),G0tensor(3)])
  call ol_merge_tensors(G1tensor(1),[G1tensor(54),G1tensor(4),G0tensor(54),G0tensor(4)])
  call ol_merge_tensors(G1tensor(40),[G1tensor(15),G1tensor(5),G0tensor(40),G0tensor(15),G0tensor(5)])
  call ol_merge_tensors(G1tensor(7),[G0tensor(7)])
  call ol_merge_tensors(G2tensor(18),[G1tensor(64),G1tensor(9),G0tensor(64),G0tensor(9)])
  call ol_merge_tensors(G1tensor(45),[G1tensor(20),G1tensor(10),G0tensor(45),G0tensor(20),G0tensor(10)])
  call ol_merge_tensors(G1tensor(12),[G0tensor(12)])
  call ol_merge_tensors(G1tensor(137),[G1tensor(33),G1tensor(18),G1tensor(13),G0tensor(137),G0tensor(33),G0tensor(18) &
    ,G0tensor(13)])
  call ol_merge_tensors(G2tensor(39),[G2tensor(19),G1tensor(59),G1tensor(14),G0tensor(59),G0tensor(14)])
  call ol_merge_tensors(G1tensor(17),[G0tensor(17)])
  call ol_merge_tensors(G2tensor(33),[G2tensor(7),G1tensor(69),G1tensor(19),G0tensor(69),G0tensor(19)])
  call ol_merge_tensors(G1tensor(22),[G0tensor(22)])
  call ol_merge_tensors(G1tensor(147),[G1tensor(142),G1tensor(132),G1tensor(23),G0tensor(147),G0tensor(142),G0tensor(132) &
    ,G0tensor(23)])
  call ol_merge_tensors(G2tensor(37),[G2tensor(16),G1tensor(24),G0tensor(24)])
  call ol_merge_tensors(G1tensor(25),[G0tensor(25)])
  call ol_merge_tensors(G1tensor(27),[G0tensor(27)])
  call ol_merge_tensors(G1tensor(104),[G1tensor(29),G0tensor(104),G0tensor(29)])
  call ol_merge_tensors(G1tensor(50),[G1tensor(35),G1tensor(30),G0tensor(50),G0tensor(35),G0tensor(30)])
  call ol_merge_tensors(G1tensor(32),[G0tensor(32)])
  call ol_merge_tensors(G1tensor(109),[G1tensor(34),G0tensor(109),G0tensor(34)])
  call ol_merge_tensors(G1tensor(37),[G0tensor(37)])
  call ol_merge_tensors(G1tensor(152),[G1tensor(48),G1tensor(43),G1tensor(38),G0tensor(152),G0tensor(48),G0tensor(43) &
    ,G0tensor(38)])
  call ol_merge_tensors(G1tensor(94),[G1tensor(39),G0tensor(94),G0tensor(39)])
  call ol_merge_tensors(G1tensor(42),[G0tensor(42)])
  call ol_merge_tensors(G1tensor(99),[G1tensor(44),G0tensor(99),G0tensor(44)])
  call ol_merge_tensors(G1tensor(47),[G0tensor(47)])
  call ol_merge_tensors(G1tensor(124),[G1tensor(49),G0tensor(124),G0tensor(49)])
  call ol_merge_tensors(G1tensor(66),[G1tensor(52),G0tensor(52)])
  call ol_merge_tensors(G2tensor(27),[G1tensor(103),G1tensor(63),G1tensor(53),G0tensor(103),G0tensor(63),G0tensor(53)])
  call ol_merge_tensors(G2tensor(13),[G2tensor(40),G1tensor(95),G1tensor(60),G1tensor(55),G0tensor(95),G0tensor(60) &
    ,G0tensor(55)])
  call ol_merge_tensors(G2tensor(62),[G2tensor(55),G1tensor(57),G0tensor(57)])
  call ol_merge_tensors(G2tensor(43),[G2tensor(35),G1tensor(108),G1tensor(68),G1tensor(58),G0tensor(108),G0tensor(68) &
    ,G0tensor(58)])
  call ol_merge_tensors(G2tensor(56),[G1tensor(62),G0tensor(62)])
  call ol_merge_tensors(G2tensor(15),[G2tensor(45),G1tensor(100),G1tensor(70),G1tensor(65),G0tensor(100),G0tensor(70) &
    ,G0tensor(65)])
  call ol_merge_tensors(G2tensor(60),[G2tensor(53),G1tensor(67),G0tensor(67)])
  call ol_merge_tensors(G2tensor(50),[G1tensor(72),G0tensor(72)])
  call ol_merge_tensors(G2tensor(42),[G2tensor(29),G1tensor(73),G0tensor(73)])
  call ol_merge_tensors(G2tensor(28),[G2tensor(5),G1tensor(119),G1tensor(84),G1tensor(74),G0tensor(119),G0tensor(84) &
    ,G0tensor(74)])
  call ol_merge_tensors(G2tensor(25),[G2tensor(11),G1tensor(46),G1tensor(6),G1tensor(130),G1tensor(75),G0tensor(130) &
    ,G0tensor(75)])
  call ol_merge_tensors(G2tensor(59),[G2tensor(52),G1tensor(112),G1tensor(87),G1tensor(77),G0tensor(112),G0tensor(87) &
    ,G0tensor(77)])
  call ol_merge_tensors(G2tensor(36),[G1tensor(78),G0tensor(78)])
  call ol_merge_tensors(G2tensor(3),[G1tensor(79),G0tensor(79)])
  call ol_merge_tensors(G2tensor(17),[G2tensor(8),G1tensor(61),G1tensor(11),G1tensor(135),G1tensor(80),G0tensor(135) &
    ,G0tensor(80)])
  call ol_merge_tensors(G2tensor(58),[G2tensor(51),G1tensor(82),G0tensor(82)])
  call ol_merge_tensors(G2tensor(47),[G2tensor(41),G1tensor(83),G0tensor(83)])
  call ol_merge_tensors(G2tensor(23),[G2tensor(26),G2tensor(14),G2tensor(12),G1tensor(56),G1tensor(26),G1tensor(140),G1tensor(85) &
    ,G0tensor(140),G0tensor(85)])
  call ol_merge_tensors(G2tensor(48),[G2tensor(44),G1tensor(88),G0tensor(88)])
  call ol_merge_tensors(G2tensor(22),[G2tensor(4),G1tensor(89),G0tensor(89)])
  call ol_merge_tensors(G2tensor(24),[G2tensor(31),G2tensor(9),G2tensor(10),G1tensor(41),G1tensor(31),G1tensor(145),G1tensor(90) &
    ,G0tensor(145),G0tensor(90)])
  call ol_merge_tensors(G1tensor(92),[G0tensor(92)])
  call ol_merge_tensors(G2tensor(34),[G1tensor(123),G1tensor(98),G1tensor(93),G0tensor(123),G0tensor(98),G0tensor(93)])
  call ol_merge_tensors(G1tensor(97),[G0tensor(97)])
  call ol_merge_tensors(G1tensor(102),[G0tensor(102)])
  call ol_merge_tensors(G2tensor(20),[G2tensor(1),G1tensor(125),G1tensor(110),G1tensor(105),G0tensor(125),G0tensor(110) &
    ,G0tensor(105)])
  call ol_merge_tensors(G1tensor(107),[G0tensor(107)])
  call ol_merge_tensors(G2tensor(38),[G1tensor(113),G0tensor(113)])
  call ol_merge_tensors(G2tensor(21),[G1tensor(114),G0tensor(114)])
  call ol_merge_tensors(G2tensor(30),[G2tensor(2),G1tensor(36),G1tensor(21),G1tensor(150),G1tensor(115),G0tensor(150) &
    ,G0tensor(115)])
  call ol_merge_tensors(G2tensor(57),[G1tensor(117),G0tensor(117)])
  call ol_merge_tensors(G2tensor(49),[G2tensor(46),G1tensor(118),G0tensor(118)])
  call ol_merge_tensors(G2tensor(32),[G2tensor(6),G1tensor(51),G1tensor(16),G1tensor(155),G1tensor(120),G0tensor(155) &
    ,G0tensor(120)])
  call ol_merge_tensors(G1tensor(122),[G0tensor(122)])
  call ol_merge_tensors(G1tensor(128),[G0tensor(128)])
  call ol_merge_tensors(G1tensor(154),[G1tensor(139),G1tensor(129),G0tensor(154),G0tensor(139),G0tensor(129)])
  call ol_merge_tensors(G1tensor(133),[G0tensor(133)])
  call ol_merge_tensors(G1tensor(134),[G0tensor(134)])
  call ol_merge_tensors(G1tensor(138),[G0tensor(138)])
  call ol_merge_tensors(G1tensor(143),[G0tensor(143)])
  call ol_merge_tensors(G1tensor(144),[G0tensor(144)])
  call ol_merge_tensors(G1tensor(148),[G0tensor(148)])
  call ol_merge_tensors(G1tensor(149),[G0tensor(149)])
  call ol_merge_tensors(G1tensor(153),[G0tensor(153)])
  call ol_merge_tensors(G2tensor(61),[G2tensor(54)])
  call TI_triangle_red(G2tensor(18),RedBasis(2),mass3set(:,1),G0tensor(1),G0tensor(6),G0tensor(11), &
    G0tensor(16),M2L1R1,[nMB,nMZ,nMH],G0tensor(21),G0tensor(26),G0tensor(31))
  call TI_triangle_red(G2tensor(39),RedBasis(2),mass3set(:,2),G0tensor(36),G0tensor(41),G0tensor(46), &
    G0tensor(51),M2L1R1,[nMB,nMH,nMZ],G0tensor(56),G0tensor(61),G0tensor(66))
  call TI_triangle_red(G2tensor(33),RedBasis(2),mass3set(:,3),G0tensor(71),G0tensor(76),G0tensor(81), &
    G0tensor(86),M2L1R1,[nMB,nMZ],G0tensor(91),G0tensor(96))
  call TI_triangle_red(G2tensor(37),RedBasis(2),mass3set(:,4),G0tensor(101),G0tensor(106),G0tensor(111), &
    G0tensor(116),M2L1R1,[nMT,nMW],G0tensor(121),G0tensor(126))
  call TI_triangle_red(G2tensor(27),RedBasis(5),mass3set(:,5),G0tensor(131),G0tensor(136),G0tensor(141), &
    G0tensor(146),M2L1R1,[nMB,nMT,nMH],G0tensor(151),G0tensor(2),G0tensor(127))
  call TI_triangle_red(G2tensor(13),RedBasis(4),mass3set(:,6),G0tensor(28),G0tensor(8),G0tensor(3), &
    G0tensor(54),M2L1R1,[nMB,nMH,nMT],G0tensor(4),G0tensor(40),G0tensor(15))
  call TI_triangle_red(G2tensor(62),RedBasis(8),mass3set(:,7),G0tensor(5),G0tensor(7),G0tensor(64), &
    G0tensor(9),M2L1R1,[nMZ,nMH,nMT],G0tensor(45),G0tensor(20),G0tensor(10))
  call TI_triangle_red(G2tensor(43),RedBasis(5),mass3set(:,8),G0tensor(12),G0tensor(137),G0tensor(33), &
    G0tensor(18),M2L1R1,[nMB,nMT,nMZ],G0tensor(13),G0tensor(59),G0tensor(14))
  call TI_triangle_red(G2tensor(56),RedBasis(8),mass3set(:,9),G0tensor(17),G0tensor(69),G0tensor(19), &
    G0tensor(22),M2L1R1,[nMH,nMZ,nMT],G0tensor(147),G0tensor(142),G0tensor(132))
  call TI_triangle_red(G2tensor(15),RedBasis(4),mass3set(:,10),G0tensor(23),G0tensor(24),G0tensor(25), &
    G0tensor(27),M2L1R1,[nMB,nMZ,nMT],G0tensor(104),G0tensor(29),G0tensor(50))
  call TI_triangle_red(G2tensor(60),RedBasis(8),mass3set(:,11),G0tensor(35),G0tensor(30),G0tensor(32), &
    G0tensor(109),M2L1R1,[nMZ,nMT],G0tensor(34),G0tensor(37))
  call TI_triangle_red(G2tensor(50),RedBasis(8),mass3set(:,12),G0tensor(152),G0tensor(48),G0tensor(43), &
    G0tensor(38),M2L1R1,[nMT,nMH],G0tensor(94),G0tensor(39))
  call TI_triangle_red(G2tensor(42),RedBasis(5),mass3set(:,13),G0tensor(42),G0tensor(99),G0tensor(44), &
    G0tensor(47),M2L1R1,[nMW,nMH,nMT],G0tensor(124),G0tensor(49),G0tensor(52))
  call TI_triangle_red(G2tensor(28),RedBasis(2),mass3set(:,14),G0tensor(103),G0tensor(63),G0tensor(53), &
    G0tensor(95),M2L1R1,[nMW,nMT],G0tensor(60),G0tensor(55))
  call TI_triangle_red(G2tensor(25),RedBasis(4),mass3set(:,15),G0tensor(57),G0tensor(108),G0tensor(68), &
    G0tensor(58),M2L1R1,[nMW,nMT,nMH],G0tensor(62),G0tensor(100),G0tensor(70))
  call TI_triangle_red(G2tensor(59),RedBasis(8),mass3set(:,16),G0tensor(65),G0tensor(67),G0tensor(72), &
    G0tensor(73),M2L1R1,[nMB,nMW],G0tensor(119),G0tensor(84))
  call TI_triangle_red(G2tensor(36),RedBasis(5),mass3set(:,17),G0tensor(74),G0tensor(130),G0tensor(75), &
    G0tensor(112),M2L1R1,[nMH,nMW,nMB],G0tensor(87),G0tensor(77),G0tensor(78))
  call TI_triangle_red(G2tensor(3),RedBasis(2),mass3set(:,18),G0tensor(79),G0tensor(135),G0tensor(80), &
    G0tensor(82),M2L1R1,[nMH,nMB],G0tensor(83),G0tensor(140))
  call TI_triangle_red(G2tensor(17),RedBasis(4),mass3set(:,19),G0tensor(85),G0tensor(88),G0tensor(89), &
    G0tensor(145),M2L1R1,[nMH,nMB,nMW],G0tensor(90),G0tensor(92),G0tensor(123))
  call TI_triangle_red(G2tensor(58),RedBasis(8),mass3set(:,20),G0tensor(98),G0tensor(93),G0tensor(97), &
    G0tensor(102),M2L1R1,[nMT,nMZ],G0tensor(125),G0tensor(110))
  call TI_triangle_red(G2tensor(47),RedBasis(5),mass3set(:,21),G0tensor(105),G0tensor(107),G0tensor(113), &
    G0tensor(114),M2L1R1,[nMW,nMZ,nMT],G0tensor(150),G0tensor(115),G0tensor(117))
  call TI_triangle_red(G2tensor(23),RedBasis(4),mass3set(:,22),G0tensor(118),G0tensor(155),G0tensor(120), &
    G0tensor(122),M2L1R1,[nMW,nMT,nMZ],G0tensor(128),G0tensor(154),G0tensor(139))
  call TI_triangle_red(G2tensor(48),RedBasis(5),mass3set(:,23),G0tensor(129),G0tensor(133),G0tensor(134), &
    G0tensor(138),M2L1R1,[nMZ,nMW,nMB],G0tensor(143),G0tensor(144),G0tensor(148))
  call TI_triangle_red(G2tensor(22),RedBasis(2),mass3set(:,24),G0tensor(149),G0tensor(153),G0tensor(156), &
    G0tensor(157),M2L1R1,[nMZ,nMB],G0tensor(158),G0tensor(159))
  call TI_triangle_red(G2tensor(24),RedBasis(4),mass3set(:,25),G0tensor(160),G0tensor(161),G0tensor(162), &
    G0tensor(163),M2L1R1,[nMZ,nMB,nMW],G0tensor(164),G0tensor(165),G0tensor(166))
  call TI_triangle_red(G2tensor(34),RedBasis(5),mass3set(:,26),G0tensor(167),G0tensor(168),G0tensor(169), &
    G0tensor(170),M2L1R1,[nMB,nMT],G0tensor(171),G0tensor(172))
  call TI_triangle_red(G2tensor(20),RedBasis(4),mass3set(:,27),G0tensor(173),G0tensor(174),G0tensor(175), &
    G0tensor(176),M2L1R1,[nMB,nMT],G0tensor(177),G0tensor(178))
  call TI_triangle_red(G2tensor(38),RedBasis(5),mass3set(:,28),G0tensor(179),G0tensor(180),G0tensor(181), &
    G0tensor(182),M2L1R1,[nMW,nMB],G0tensor(183),G0tensor(184))
  call TI_triangle_red(G2tensor(21),RedBasis(2),mass3set(:,29),G0tensor(185),G0tensor(186),G0tensor(187), &
    G0tensor(188),M2L1R1,[nMB],G0tensor(189))
  call TI_triangle_red(G2tensor(30),RedBasis(4),mass3set(:,30),G0tensor(190),G0tensor(191),G0tensor(192), &
    G0tensor(193),M2L1R1,[nMB,nMW],G0tensor(194),G0tensor(195))
  call TI_triangle_red(G2tensor(57),RedBasis(8),mass3set(:,31),G0tensor(196),G0tensor(197),G0tensor(198), &
    G0tensor(199),M2L1R1,[nMT],G0tensor(200))
  call TI_triangle_red(G2tensor(49),RedBasis(5),mass3set(:,32),G0tensor(201),G0tensor(202),G0tensor(203), &
    G0tensor(204),M2L1R1,[nMW,nMT],G0tensor(205),G0tensor(206))
  call TI_triangle_red(G2tensor(32),RedBasis(4),mass3set(:,33),G0tensor(207),G0tensor(208),G0tensor(209), &
    G0tensor(210),M2L1R1,[nMW,nMT],G0tensor(211),G0tensor(212))
  call TI_triangle_red(G2tensor(61),RedBasis(8),mass3set(:,34),G0tensor(213),G0tensor(214),G0tensor(215), &
    G0tensor(216),M2L1R1,[nMW,nMB],G0tensor(217),G0tensor(218))
  call TI_triangle_red(G1tensor(2),RedBasis(9),mass3set(:,35),G0tensor(219),G0tensor(220),G0tensor(221), &
    G0tensor(222),M2L1R1,[nMH,nMT],G0tensor(223),G0tensor(224))
  call TI_triangle_red(G1tensor(127),RedBasis(3),mass3set(:,5),G0tensor(225),G0tensor(226),G0tensor(227), &
    G0tensor(228),M2L1R1,[nMB,nMT,nMH],G0tensor(229),G0tensor(230),G0tensor(231))
  call TI_triangle_red(G1tensor(1),RedBasis(2),mass3set(:,36),G0tensor(232),G0tensor(233),G0tensor(234), &
    G0tensor(235),M2L1R1,[nMB,nMH],G0tensor(236),G0tensor(237))
  call TI_triangle_red(G1tensor(40),RedBasis(1),mass3set(:,6),G0tensor(238),G0tensor(239),G0tensor(240), &
    G0tensor(241),M2L1R1,[nMB,nMH,nMT],G0tensor(242),G0tensor(243),G0tensor(244))
  call TI_triangle_red(G1tensor(7),RedBasis(9),mass3set(:,9),G0tensor(245),G0tensor(246),G0tensor(247), &
    G0tensor(248),M2L1R1,[nMH,nMZ,nMT],G0tensor(249),G0tensor(250),G0tensor(251))
  call TI_triangle_red(G1tensor(45),RedBasis(1),mass3set(:,10),G0tensor(252),G0tensor(253),G0tensor(254), &
    G0tensor(255),M2L1R1,[nMB,nMZ,nMT],G0tensor(256),G0tensor(257),G0tensor(258))
  call TI_triangle_red(G1tensor(12),RedBasis(9),mass3set(:,7),G0tensor(259),G0tensor(260),G0tensor(261), &
    G0tensor(262),M2L1R1,[nMZ,nMH,nMT],G0tensor(263),G0tensor(264),G0tensor(265))
  call TI_triangle_red(G1tensor(137),RedBasis(3),mass3set(:,8),G0tensor(266),G0tensor(267),G0tensor(268), &
    G0tensor(269),M2L1R1,[nMB,nMT,nMZ],G0tensor(270),G0tensor(271),G0tensor(272))
  call TI_triangle_red(G1tensor(17),RedBasis(9),mass3set(:,11),G0tensor(273),G0tensor(274),G0tensor(275), &
    G0tensor(276),M2L1R1,[nMZ,nMT],G0tensor(277),G0tensor(278))
  call TI_triangle_red(G1tensor(22),RedBasis(9),mass3set(:,34),G0tensor(279),G0tensor(280),G0tensor(281), &
    G0tensor(282),M2L1R1,[nMW,nMB],G0tensor(283),G0tensor(284))
  call TI_triangle_red(G1tensor(147),RedBasis(3),mass3set(:,37),G0tensor(285),G0tensor(286),G0tensor(287), &
    G0tensor(288),M2L1R1,[nMT,nMB,nMW],G0tensor(289),G0tensor(290),G0tensor(291))
  call TI_triangle_red(G1tensor(25),RedBasis(1),mass3set(:,38),G0tensor(292),G0tensor(293),G0tensor(294), &
    G0tensor(295),M2L1R1,[nMT,nMW,nMB],G0tensor(296),G0tensor(297),G0tensor(298))
  call TI_triangle_red(G1tensor(27),RedBasis(9),mass3set(:,39),G0tensor(299),G0tensor(300),G0tensor(301), &
    G0tensor(302),M2L1R1,[nMH,nMT],G0tensor(303),G0tensor(304))
  call TI_triangle_red(G1tensor(104),RedBasis(2),mass3set(:,40),G0tensor(305),G0tensor(306),G0tensor(307), &
    G0tensor(308),M2L1R1,[nMB,nMH],G0tensor(309),G0tensor(310))
  call TI_triangle_red(G1tensor(50),RedBasis(1),mass3set(:,27),G0tensor(311),G0tensor(312),G0tensor(313), &
    G0tensor(314),M2L1R1,[nMB,nMT],G0tensor(315),G0tensor(316))
  call TI_triangle_red(G1tensor(32),RedBasis(9),mass3set(:,41),G0tensor(317),G0tensor(318),G0tensor(319), &
    G0tensor(320),M2L1R1,[nMZ,nMT],G0tensor(321),G0tensor(322))
  call TI_triangle_red(G1tensor(109),RedBasis(2),mass3set(:,42),G0tensor(323),G0tensor(324),G0tensor(325), &
    G0tensor(326),M2L1R1,[nMB,nMZ],G0tensor(327),G0tensor(328))
  call TI_triangle_red(G1tensor(37),RedBasis(9),mass3set(:,43),G0tensor(329),G0tensor(330),G0tensor(331), &
    G0tensor(332),M2L1R1,[nMH,nMT],G0tensor(333),G0tensor(334))
  call TI_triangle_red(G1tensor(152),RedBasis(3),mass3set(:,26),G0tensor(335),G0tensor(336),G0tensor(337), &
    G0tensor(338),M2L1R1,[nMB,nMT],G0tensor(339),G0tensor(340))
  call TI_triangle_red(G1tensor(94),RedBasis(2),mass3set(:,44),G0tensor(341),G0tensor(342),G0tensor(343), &
    G0tensor(344),M2L1R1,[nMB,nMH],G0tensor(345),G0tensor(346))
  call TI_triangle_red(G1tensor(42),RedBasis(9),mass3set(:,45),G0tensor(347),G0tensor(348),G0tensor(349), &
    G0tensor(350),M2L1R1,[nMZ,nMT],G0tensor(351),G0tensor(352))
  call TI_triangle_red(G1tensor(99),RedBasis(2),mass3set(:,46),G0tensor(353),G0tensor(354),G0tensor(355), &
    G0tensor(356),M2L1R1,[nMB,nMZ],G0tensor(357),G0tensor(358))
  call TI_triangle_red(G1tensor(47),RedBasis(9),mass3set(:,47),G0tensor(359),G0tensor(360),G0tensor(361), &
    G0tensor(362),M2L1R1,[nMT],G0tensor(363))
  call TI_triangle_red(G1tensor(124),RedBasis(2),mass3set(:,48),G0tensor(364),G0tensor(365),G0tensor(366), &
    G0tensor(367),M2L1R1,[nMB],G0tensor(368))
  call TI_triangle_red(G1tensor(66),RedBasis(8),mass3set(:,35),G0tensor(369),G0tensor(370),G0tensor(371), &
    G0tensor(372),M2L1R1,[nMH,nMT],G0tensor(373),G0tensor(374))
  call TI_triangle_red(G1tensor(92),RedBasis(8),mass3set(:,43),G0tensor(375),G0tensor(376),G0tensor(377), &
    G0tensor(378),M2L1R1,[nMH,nMT],G0tensor(379),G0tensor(380))
  call TI_triangle_red(G1tensor(97),RedBasis(8),mass3set(:,45),G0tensor(381),G0tensor(382),G0tensor(383), &
    G0tensor(384),M2L1R1,[nMZ,nMT],G0tensor(385),G0tensor(386))
  call TI_triangle_red(G1tensor(102),RedBasis(8),mass3set(:,39),G0tensor(387),G0tensor(388),G0tensor(389), &
    G0tensor(390),M2L1R1,[nMH,nMT],G0tensor(391),G0tensor(392))
  call TI_triangle_red(G1tensor(107),RedBasis(8),mass3set(:,41),G0tensor(393),G0tensor(394),G0tensor(395), &
    G0tensor(396),M2L1R1,[nMZ,nMT],G0tensor(397),G0tensor(398))
  call TI_triangle_red(G1tensor(122),RedBasis(8),mass3set(:,47),G0tensor(399),G0tensor(400),G0tensor(401), &
    G0tensor(402),M2L1R1,[nMT],G0tensor(403))
  call TI_triangle_red(G1tensor(128),RedBasis(7),mass3set(:,49),G0tensor(404),G0tensor(405),G0tensor(406), &
    G0tensor(407),M2L1R1,[nMW,nMH,nMB],G0tensor(408),G0tensor(409),G0tensor(410))
  call TI_triangle_red(G1tensor(154),RedBasis(6),mass3set(:,50),G0tensor(411),G0tensor(412),G0tensor(413), &
    G0tensor(414),M2L1R1,[nMW,nMT,nMB],G0tensor(415),G0tensor(416),G0tensor(417))
  call TI_triangle_red(G1tensor(133),RedBasis(7),mass3set(:,51),G0tensor(418),G0tensor(419),G0tensor(420), &
    G0tensor(421),M2L1R1,[nMH,nMW,nMT],G0tensor(422),G0tensor(423),G0tensor(424))
  call TI_triangle_red(G1tensor(134),RedBasis(6),mass3set(:,52),G0tensor(425),G0tensor(426),G0tensor(427), &
    G0tensor(428),M2L1R1,[nMH,nMB,nMT],G0tensor(429),G0tensor(430),G0tensor(431))
  call TI_triangle_red(G1tensor(138),RedBasis(7),mass3set(:,53),G0tensor(432),G0tensor(433),G0tensor(434), &
    G0tensor(435),M2L1R1,[nMW,nMZ,nMB],G0tensor(436),G0tensor(437),G0tensor(438))
  call TI_triangle_red(G1tensor(143),RedBasis(7),mass3set(:,54),G0tensor(439),G0tensor(440),G0tensor(441), &
    G0tensor(442),M2L1R1,[nMZ,nMW,nMT],G0tensor(443),G0tensor(444),G0tensor(445))
  call TI_triangle_red(G1tensor(144),RedBasis(6),mass3set(:,55),G0tensor(446),G0tensor(447),G0tensor(448), &
    G0tensor(449),M2L1R1,[nMZ,nMB,nMT],G0tensor(450),G0tensor(451),G0tensor(452))
  call TI_triangle_red(G1tensor(148),RedBasis(7),mass3set(:,56),G0tensor(453),G0tensor(454),G0tensor(455), &
    G0tensor(456),M2L1R1,[nMW,nMT],G0tensor(457),G0tensor(458))
  call TI_triangle_red(G1tensor(149),RedBasis(6),mass3set(:,57),G0tensor(459),G0tensor(460),G0tensor(461), &
    G0tensor(462),M2L1R1,[nMB,nMT],G0tensor(463),G0tensor(464))
  call TI_triangle_red(G1tensor(153),RedBasis(7),mass3set(:,58),G0tensor(465),G0tensor(466),G0tensor(467), &
    G0tensor(468),M2L1R1,[nMW,nMB],G0tensor(469),G0tensor(470))
  call ol_merge_tensors(T0sum(32),[G0tensor(219)])
  call ol_merge_tensors(T0sum(33),[G0tensor(225)])
  call ol_merge_tensors(T0sum(34),[G0tensor(232)])
  call ol_merge_tensors(T0sum(35),[G0tensor(238)])
  call ol_merge_tensors(T0sum(36),[G0tensor(245)])
  call ol_merge_tensors(T0sum(37),[G0tensor(1)])
  call ol_merge_tensors(T0sum(38),[G0tensor(252)])
  call ol_merge_tensors(T0sum(39),[G0tensor(259)])
  call ol_merge_tensors(T0sum(40),[G0tensor(266)])
  call ol_merge_tensors(T0sum(41),[G0tensor(36)])
  call ol_merge_tensors(T0sum(42),[G0tensor(273)])
  call ol_merge_tensors(T0sum(43),[G0tensor(71)])
  call ol_merge_tensors(T0sum(44),[G0tensor(279)])
  call ol_merge_tensors(T0sum(45),[G0tensor(285)])
  call ol_merge_tensors(T0sum(46),[G0tensor(101)])
  call ol_merge_tensors(T0sum(47),[G0tensor(292)])
  call ol_merge_tensors(T0sum(48),[G0tensor(299)])
  call ol_merge_tensors(T0sum(49),[G0tensor(305)])
  call ol_merge_tensors(T0sum(50),[G0tensor(311)])
  call ol_merge_tensors(T0sum(51),[G0tensor(317)])
  call ol_merge_tensors(T0sum(52),[G0tensor(323)])
  call ol_merge_tensors(T0sum(53),[G0tensor(329)])
  call ol_merge_tensors(T0sum(54),[G0tensor(335)])
  call ol_merge_tensors(T0sum(55),[G0tensor(341)])
  call ol_merge_tensors(T0sum(56),[G0tensor(347)])
  call ol_merge_tensors(T0sum(57),[G0tensor(353)])
  call ol_merge_tensors(T0sum(58),[G0tensor(359)])
  call ol_merge_tensors(T0sum(59),[G0tensor(364)])
  call ol_merge_tensors(T0sum(60),[G0tensor(369)])
  call ol_merge_tensors(T0sum(61),[G0tensor(131)])
  call ol_merge_tensors(T0sum(62),[G0tensor(28)])
  call ol_merge_tensors(T0sum(63),[G0tensor(5)])
  call ol_merge_tensors(T0sum(64),[G0tensor(12)])
  call ol_merge_tensors(T0sum(65),[G0tensor(17)])
  call ol_merge_tensors(T0sum(66),[G0tensor(23)])
  call ol_merge_tensors(T0sum(67),[G0tensor(35)])
  call ol_merge_tensors(T0sum(68),[G0tensor(152)])
  call ol_merge_tensors(T0sum(69),[G0tensor(42)])
  call ol_merge_tensors(T0sum(70),[G0tensor(103)])
  call ol_merge_tensors(T0sum(71),[G0tensor(57)])
  call ol_merge_tensors(T0sum(72),[G0tensor(65)])
  call ol_merge_tensors(T0sum(73),[G0tensor(74)])
  call ol_merge_tensors(T0sum(74),[G0tensor(79)])
  call ol_merge_tensors(T0sum(75),[G0tensor(85)])
  call ol_merge_tensors(T0sum(76),[G0tensor(98)])
  call ol_merge_tensors(T0sum(77),[G0tensor(105)])
  call ol_merge_tensors(T0sum(78),[G0tensor(118)])
  call ol_merge_tensors(T0sum(79),[G0tensor(129)])
  call ol_merge_tensors(T0sum(80),[G0tensor(149)])
  call ol_merge_tensors(T0sum(81),[G0tensor(160)])
  call ol_merge_tensors(T0sum(82),[G0tensor(375)])
  call ol_merge_tensors(T0sum(83),[G0tensor(167)])
  call ol_merge_tensors(T0sum(84),[G0tensor(381)])
  call ol_merge_tensors(T0sum(85),[G0tensor(387)])
  call ol_merge_tensors(T0sum(86),[G0tensor(173)])
  call ol_merge_tensors(T0sum(87),[G0tensor(393)])
  call ol_merge_tensors(T0sum(88),[G0tensor(179)])
  call ol_merge_tensors(T0sum(89),[G0tensor(185)])
  call ol_merge_tensors(T0sum(90),[G0tensor(190)])
  call ol_merge_tensors(T0sum(91),[G0tensor(196)])
  call ol_merge_tensors(T0sum(92),[G0tensor(201)])
  call ol_merge_tensors(T0sum(93),[G0tensor(207)])
  call ol_merge_tensors(T0sum(94),[G0tensor(399)])
  call ol_merge_tensors(T0sum(95),[G0tensor(404)])
  call ol_merge_tensors(T0sum(96),[G0tensor(411)])
  call ol_merge_tensors(T0sum(97),[G0tensor(418)])
  call ol_merge_tensors(T0sum(98),[G0tensor(425)])
  call ol_merge_tensors(T0sum(99),[G0tensor(432)])
  call ol_merge_tensors(T0sum(100),[G0tensor(439)])
  call ol_merge_tensors(T0sum(101),[G0tensor(446)])
  call ol_merge_tensors(T0sum(102),[G0tensor(453)])
  call ol_merge_tensors(T0sum(103),[G0tensor(459)])
  call ol_merge_tensors(T0sum(104),[G0tensor(465)])
  call ol_merge_tensors(T0sum(105),[G0tensor(213)])
  Gcoeff(:)%j = (-(c(133)*M(2,:)%j)) * den(9)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(243),h0tab(:,243),[12,3],[nME,nME],2,2,wf4(:,2),wf4(:,1))
  call Hloop_QS_A(ntryL,G0H16(1),wf4(:,2),G0H4(3),ngH,m3h4x4(:,88),heltab2x16(:,:,243))
  call Hloop_Q_A(ntryL,G0H4(3),12,nME,G1H4(3),n2h4(77))
  Gcoeff(:)%j = (-(c(135)*M(2,:)%j)) * den(9)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(244),h0tab(:,244),[12,3],[nMM,nMM],2,2,wf4(:,2),wf4(:,1))
  call Hloop_QS_A(ntryL,G0H16(1),wf4(:,2),G0H4(4),ngH,m3h4x4(:,89),heltab2x16(:,:,244))
  call Hloop_Q_A(ntryL,G0H4(4),12,nMM,G1H4(9),n2h4(78))
  Gcoeff(:)%j = (-(c(134)*M(2,:)%j)) * den(9)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(245),h0tab(:,245),[12,3],[nML,nML],2,2,wf4(:,2),wf4(:,1))
  call Hloop_QS_A(ntryL,G0H16(1),wf4(:,2),G0H4(5),ngH,m3h4x4(:,90),heltab2x16(:,:,245))
  call Hloop_Q_A(ntryL,G0H4(5),12,nML,G1H4(10),n2h4(79))
  Gcoeff(:)%j = (-(c(136)*M(2,:)%j)) * den(9)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(246),h0tab(:,246),[12,3],[nMT,nMT],2,2,wf4(:,2),wf4(:,1))
  call Hloop_QS_A(ntryL,G0H16(1),wf4(:,2),G0H4(6),ngH,m3h4x4(:,91),heltab2x16(:,:,246))
  call Hloop_Q_A(ntryL,G0H4(6),12,nMT,G1H4(6),n2h4(80))
  Gcoeff(:)%j = (-(c(132)*M(2,:)%j)) * den(9)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(247),h0tab(:,247),[12,3],[nMB,nMB],2,2,wf4(:,2),wf4(:,1))
  call Hloop_QS_A(ntryL,G0H16(1),wf4(:,2),G0H4(15),ngH,m3h4x4(:,92),heltab2x16(:,:,247))
  call Hloop_Q_A(ntryL,G0H4(15),12,nMB,G1H4(17),n2h4(81))
  Gcoeff(:)%j = (c(133)*M(2,:)%j) * den(15)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(248),h0tab(:,248),[12,3],[nME,nME],2,2,wf4(:,4),wf4(:,1))
  call Hloop_QS_A(ntryL,G0H16(1),wf4(:,4),G0H4(16),ngX,m3h4x4(:,93),heltab2x16(:,:,248))
  call Hloop_Q_A(ntryL,G0H4(16),12,nME,G1H4(13),n2h4(82))
  Gcoeff(:)%j = (c(135)*M(2,:)%j) * den(15)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(249),h0tab(:,249),[12,3],[nMM,nMM],2,2,wf4(:,4),wf4(:,1))
  call Hloop_QS_A(ntryL,G0H16(1),wf4(:,4),G0H4(17),ngX,m3h4x4(:,94),heltab2x16(:,:,249))
  call Hloop_Q_A(ntryL,G0H4(17),12,nMM,G1H4(14),n2h4(83))
  Gcoeff(:)%j = (c(134)*M(2,:)%j) * den(15)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(250),h0tab(:,250),[12,3],[nML,nML],2,2,wf4(:,4),wf4(:,1))
  call Hloop_QS_A(ntryL,G0H16(1),wf4(:,4),G0H4(22),ngX,m3h4x4(:,95),heltab2x16(:,:,250))
  call Hloop_Q_A(ntryL,G0H4(22),12,nML,G1H4(15),n2h4(84))
  Gcoeff(:)%j = (-(c(136)*M(2,:)%j)) * den(15)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(251),h0tab(:,251),[12,3],[nMT,nMT],2,2,wf4(:,4),wf4(:,1))
  call Hloop_QS_A(ntryL,G0H16(1),wf4(:,4),G0H4(20),ngX,m3h4x4(:,96),heltab2x16(:,:,251))
  call Hloop_Q_A(ntryL,G0H4(20),12,nMT,G1H4(23),n2h4(85))
  Gcoeff(:)%j = (c(132)*M(2,:)%j) * den(15)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(252),h0tab(:,252),[12,3],[nMB,nMB],2,2,wf4(:,4),wf4(:,1))
  call Hloop_QS_A(ntryL,G0H16(1),wf4(:,4),G0H4(21),ngX,m3h4x4(:,97),heltab2x16(:,:,252))
  call Hloop_Q_A(ntryL,G0H4(21),12,nMB,G1H4(24),n2h4(86))
  Gcoeff(:)%j = (-(c(133)*M(2,:)%j)) * den(16)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(253),h0tab(:,253),[12,3],[nME,nME],2,2,wf4(:,2),wf4(:,3))
  call Hloop_QS_A(ntryL,G0H16(1),wf4(:,2),G0H4(25),ngH,m3h4x4(:,98),heltab2x16(:,:,253))
  call Hloop_Q_A(ntryL,G0H4(25),12,nME,G1H4(30),n2h4(87))
  Gcoeff(:)%j = (-(c(135)*M(2,:)%j)) * den(16)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(254),h0tab(:,254),[12,3],[nMM,nMM],2,2,wf4(:,2),wf4(:,3))
  call Hloop_QS_A(ntryL,G0H16(1),wf4(:,2),G0H4(23),ngH,m3h4x4(:,99),heltab2x16(:,:,254))
  call Hloop_Q_A(ntryL,G0H4(23),12,nMM,G1H4(32),n2h4(88))
  Gcoeff(:)%j = (-(c(134)*M(2,:)%j)) * den(16)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(255),h0tab(:,255),[12,3],[nML,nML],2,2,wf4(:,2),wf4(:,3))
  call Hloop_QS_A(ntryL,G0H16(1),wf4(:,2),G0H4(24),ngH,m3h4x4(:,100),heltab2x16(:,:,255))
  call Hloop_Q_A(ntryL,G0H4(24),12,nML,G1H4(1),n2h4(89))
  Gcoeff(:)%j = (c(136)*M(2,:)%j) * den(16)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(256),h0tab(:,256),[12,3],[nMT,nMT],2,2,wf4(:,2),wf4(:,3))
  call Hloop_QS_A(ntryL,G0H16(1),wf4(:,2),G0H4(19),ngH,m3h4x4(:,101),heltab2x16(:,:,256))
  call Hloop_Q_A(ntryL,G0H4(19),12,nMT,G1H4(8),n2h4(90))
  Gcoeff(:)%j = (-(c(132)*M(2,:)%j)) * den(16)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(257),h0tab(:,257),[12,3],[nMB,nMB],2,2,wf4(:,2),wf4(:,3))
  call Hloop_QS_A(ntryL,G0H16(1),wf4(:,2),G0H4(1),ngH,m3h4x4(:,102),heltab2x16(:,:,257))
  call Hloop_Q_A(ntryL,G0H4(1),12,nMB,G1H4(19),n2h4(91))
  Gcoeff(:)%j = (c(133)*M(2,:)%j) * den(10)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(258),h0tab(:,258),[12,3],[nME,nME],2,2,wf4(:,4),wf4(:,3))
  call Hloop_QS_A(ntryL,G0H16(1),wf4(:,4),G0H4(2),ngX,m3h4x4(:,103),heltab2x16(:,:,258))
  call Hloop_Q_A(ntryL,G0H4(2),12,nME,G1H4(20),n2h4(92))
  Gcoeff(:)%j = (c(135)*M(2,:)%j) * den(10)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(259),h0tab(:,259),[12,3],[nMM,nMM],2,2,wf4(:,4),wf4(:,3))
  call Hloop_QS_A(ntryL,G0H16(1),wf4(:,4),G0H4(7),ngX,m3h4x4(:,104),heltab2x16(:,:,259))
  call Hloop_Q_A(ntryL,G0H4(7),12,nMM,G1H4(16),n2h4(93))
  Gcoeff(:)%j = (c(134)*M(2,:)%j) * den(10)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(260),h0tab(:,260),[12,3],[nML,nML],2,2,wf4(:,4),wf4(:,3))
  call Hloop_QS_A(ntryL,G0H16(1),wf4(:,4),G0H4(8),ngX,m3h4x4(:,105),heltab2x16(:,:,260))
  call Hloop_Q_A(ntryL,G0H4(8),12,nML,G1H4(18),n2h4(94))
  Gcoeff(:)%j = (c(136)*M(2,:)%j) * den(10)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(261),h0tab(:,261),[12,3],[nMT,nMT],2,2,wf4(:,4),wf4(:,3))
  call Hloop_QS_A(ntryL,G0H16(1),wf4(:,4),G0H4(9),ngX,m3h4x4(:,106),heltab2x16(:,:,261))
  call Hloop_Q_A(ntryL,G0H4(9),12,nMT,G1H4(7),n2h4(95))
  Gcoeff(:)%j = (c(132)*M(2,:)%j) * den(10)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(262),h0tab(:,262),[12,3],[nMB,nMB],2,2,wf4(:,4),wf4(:,3))
  call Hloop_QS_A(ntryL,G0H16(1),wf4(:,4),G0H4(10),ngX,m3h4x4(:,107),heltab2x16(:,:,262))
  call Hloop_Q_A(ntryL,G0H4(10),12,nMB,G1H4(11),n2h4(96))
  Gcoeff(:)%j = (c(31)*M(2,:)%j) * den(9)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(263),h0tab(:,263),[12,3],[nMH,nMH],2,2,wf4(:,2),wf4(:,1))
  call Hloop_SS_S(ntryL,G0H16(1),wf4(:,2),G0H4(11),m3h4x4(:,108),heltab2x16(:,:,263))
  Gcoeff(:)%j = (c(29)*M(2,:)%j) * den(9)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(264),h0tab(:,264),[12,3],[nMZ,nMZ],2,2,wf4(:,2),wf4(:,1))
  call Hloop_SS_S(ntryL,G0H16(1),wf4(:,2),G0H4(12),m3h4x4(:,109),heltab2x16(:,:,264))
  Gcoeff(:)%j = (c(30)*M(2,:)%j) * den(9)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(265),h0tab(:,265),[12,3],[nMW,nMW],2,2,wf4(:,2),wf4(:,1))
  call Hloop_SS_S(ntryL,G0H16(1),wf4(:,2),G0H4(13),m3h4x4(:,110),heltab2x16(:,:,265))
  Gcoeff(:)%j = (c(30)*M(2,:)%j) * den(10)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(266),h0tab(:,266),[12,3],[nMH,nMZ],2,2,wf4(:,4),wf4(:,3))
  call Hloop_SS_S(ntryL,G0H16(1),wf4(:,4),G0H4(14),m3h4x4(:,111),heltab2x16(:,:,266))
  Gcoeff(:)%j = (-(c(18)*M(2,:)%j)) * den(9)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(267),h0tab(:,267),[12,3],[nMZ,nMZ],2,2,wf4(:,2),wf4(:,1))
  call Hloop_SS_S(ntryL,G0H16(1),wf4(:,2),G0H4(18),m3h4x4(:,112),heltab2x16(:,:,267))
  Gcoeff(:)%j = (-(c(16)*M(2,:)%j)) * den(9)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(268),h0tab(:,268),[12,3],[nMW,nMW],2,2,wf4(:,2),wf4(:,1))
  call Hloop_SS_S(ntryL,G0H16(1),wf4(:,2),G0H4(3),m3h4x4(:,113),heltab2x16(:,:,268))
  Gcoeff(:)%j = (-(c(16)*M(2,:)%j)) * den(9)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(269),h0tab(:,269),[12,3],[nMW,nMW],2,2,wf4(:,2),wf4(:,1))
  call Hloop_SS_S(ntryL,G0H16(1),wf4(:,2),G0H4(4),m3h4x4(:,114),heltab2x16(:,:,269))
  Gcoeff(:)%j = (c(16)*M(2,:)%j) * den(15)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(270),h0tab(:,270),[12,3],[nMW,nMW],2,2,wf4(:,4),wf4(:,1))
  call Hloop_SS_S(ntryL,G0H16(1),wf4(:,4),G0H4(5),m3h4x4(:,115),heltab2x16(:,:,270))
  Gcoeff(:)%j = (-(c(16)*M(2,:)%j)) * den(15)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(271),h0tab(:,271),[12,3],[nMW,nMW],2,2,wf4(:,4),wf4(:,1))
  call Hloop_SS_S(ntryL,G0H16(1),wf4(:,4),G0H4(6),m3h4x4(:,116),heltab2x16(:,:,271))
  Gcoeff(:)%j = (-(c(16)*M(2,:)%j)) * den(16)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(272),h0tab(:,272),[12,3],[nMW,nMW],2,2,wf4(:,2),wf4(:,3))
  call Hloop_SS_S(ntryL,G0H16(1),wf4(:,2),G0H4(15),m3h4x4(:,117),heltab2x16(:,:,272))
  Gcoeff(:)%j = (c(16)*M(2,:)%j) * den(16)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(273),h0tab(:,273),[12,3],[nMW,nMW],2,2,wf4(:,2),wf4(:,3))
  call Hloop_SS_S(ntryL,G0H16(1),wf4(:,2),G0H4(16),m3h4x4(:,118),heltab2x16(:,:,273))
  Gcoeff(:)%j = (c(16)*M(2,:)%j) * den(10)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(274),h0tab(:,274),[12,3],[nMW,nMW],2,2,wf4(:,4),wf4(:,3))
  call Hloop_SS_S(ntryL,G0H16(1),wf4(:,4),G0H4(17),m3h4x4(:,119),heltab2x16(:,:,274))
  Gcoeff(:)%j = (c(16)*M(2,:)%j) * den(10)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(275),h0tab(:,275),[12,3],[nMW,nMW],2,2,wf4(:,4),wf4(:,3))
  call Hloop_SS_S(ntryL,G0H16(1),wf4(:,4),G0H4(22),m3h4x4(:,120),heltab2x16(:,:,275))
  Gcoeff(:)%j = (c(19)*M(2,:)%j) * den(9)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(276),h0tab(:,276),[12,3],[nMZ,nMZ],2,2,wf4(:,2),wf4(:,1))
  call Hloop_VS_V(ntryL,G0H16(1),wf4(:,2),G0H4(20),m3h4x4(:,121),heltab2x16(:,:,276))
  Gcoeff(:)%j = (c(17)*M(2,:)%j) * den(9)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(277),h0tab(:,277),[12,3],[nMW,nMW],2,2,wf4(:,2),wf4(:,1))
  call Hloop_VS_V(ntryL,G0H16(1),wf4(:,2),G0H4(21),m3h4x4(:,122),heltab2x16(:,:,277))
  Gcoeff(:)%j = (c(45)*M(2,:)%j) * den(9)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(278),h0tab(:,278),[12,3],[nMZ,nMZ],2,2,wf4(:,2),wf4(:,1))
  call Hloop_VT_S(ntryL,G0H16(1),0,wf4(:,2),12,G1H4(46),m3h4x4(:,123),heltab2x16(:,:,278))
  Gcoeff(:)%j = (c(43)*M(2,:)%j) * den(9)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(279),h0tab(:,279),[12,3],[nMW,nMW],2,2,wf4(:,2),wf4(:,1))
  call Hloop_VT_S(ntryL,G0H16(1),0,wf4(:,2),12,G1H4(49),m3h4x4(:,124),heltab2x16(:,:,279))
  Gcoeff(:)%j = (c(43)*M(2,:)%j) * den(9)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(280),h0tab(:,280),[12,3],[nMW,nMW],2,2,wf4(:,2),wf4(:,1))
  call Hloop_VT_S(ntryL,G0H16(1),0,wf4(:,2),12,G1H4(50),m3h4x4(:,125),heltab2x16(:,:,280))
  Gcoeff(:)%j = (-(c(43)*M(2,:)%j)) * den(15)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(281),h0tab(:,281),[12,3],[nMW,nMW],2,2,wf4(:,4),wf4(:,1))
  call Hloop_VT_S(ntryL,G0H16(1),0,wf4(:,4),12,G1H4(54),m3h4x4(:,126),heltab2x16(:,:,281))
  Gcoeff(:)%j = (c(43)*M(2,:)%j) * den(15)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(282),h0tab(:,282),[12,3],[nMW,nMW],2,2,wf4(:,4),wf4(:,1))
  call Hloop_VT_S(ntryL,G0H16(1),0,wf4(:,4),12,G1H4(52),m3h4x4(:,127),heltab2x16(:,:,282))
  Gcoeff(:)%j = (-(c(43)*M(2,:)%j)) * den(16)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(283),h0tab(:,283),[12,3],[nMW,nMW],2,2,wf4(:,2),wf4(:,3))
  call Hloop_VT_S(ntryL,G0H16(1),0,wf4(:,2),12,G1H4(53),m3h4x4(:,128),heltab2x16(:,:,283))
  Gcoeff(:)%j = (c(43)*M(2,:)%j) * den(16)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(284),h0tab(:,284),[12,3],[nMW,nMW],2,2,wf4(:,2),wf4(:,3))
  call Hloop_VT_S(ntryL,G0H16(1),0,wf4(:,2),12,G1H4(58),m3h4x4(:,129),heltab2x16(:,:,284))
  Gcoeff(:)%j = (c(45)*M(2,:)%j) * den(10)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(285),h0tab(:,285),[12,3],[nMH,nMZ],2,2,wf4(:,4),wf4(:,3))
  call Hloop_VS_T(ntryL,G0H16(1),0,wf4(:,4),12,G1H4(59),m3h4x4(:,130),heltab2x16(:,:,285))
  Gcoeff(:)%j = (c(43)*M(2,:)%j) * den(10)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(286),h0tab(:,286),[12,3],[nMW,nMW],2,2,wf4(:,4),wf4(:,3))
  call Hloop_VT_S(ntryL,G0H16(1),0,wf4(:,4),12,G1H4(60),m3h4x4(:,131),heltab2x16(:,:,286))
  Gcoeff(:)%j = (c(43)*M(2,:)%j) * den(10)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(287),h0tab(:,287),[12,3],[nMW,nMW],2,2,wf4(:,4),wf4(:,3))
  call Hloop_VT_S(ntryL,G0H16(1),0,wf4(:,4),12,G1H4(33),m3h4x4(:,132),heltab2x16(:,:,287))
  Gcoeff(:)%j = (c(152)*M(2,:)%j) * den(17)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(288),h0tab(:,288),[12,3],[nME,nME],2,2,wf4(:,6),wf4(:,1))
  call Hloop_QV_A(ntryL,G0H16(1),wf4(:,6),G0H4(25),m3h4x4(:,133),heltab2x16(:,:,288))
  call Hloop_Q_A(ntryL,G0H4(25),12,nME,G1H4(38),n2h4(97))
  Gcoeff(:)%j = (c(156)*M(2,:)%j) * den(17)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(289),h0tab(:,289),[12,3],[nMM,nMM],2,2,wf4(:,6),wf4(:,1))
  call Hloop_QV_A(ntryL,G0H16(1),wf4(:,6),G0H4(23),m3h4x4(:,134),heltab2x16(:,:,289))
  call Hloop_Q_A(ntryL,G0H4(23),12,nMM,G1H4(37),n2h4(98))
  Gcoeff(:)%j = (c(154)*M(2,:)%j) * den(17)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(290),h0tab(:,290),[12,3],[nML,nML],2,2,wf4(:,6),wf4(:,1))
  call Hloop_QV_A(ntryL,G0H16(1),wf4(:,6),G0H4(24),m3h4x4(:,135),heltab2x16(:,:,290))
  call Hloop_Q_A(ntryL,G0H4(24),12,nML,G1H4(39),n2h4(99))
  Gcoeff(:)%j = (-(c(158)*M(2,:)%j)) * den(17)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(291),h0tab(:,291),[12,3],[nMT,nMT],2,2,wf4(:,6),wf4(:,1))
  call Hloop_QV_A(ntryL,G0H16(1),wf4(:,6),G0H4(19),m3h4x4(:,136),heltab2x16(:,:,291))
  call Hloop_Q_A(ntryL,G0H4(19),12,nMT,G1H4(42),n2h4(100))
  Gcoeff(:)%j = (c(149)*M(2,:)%j) * den(17)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(292),h0tab(:,292),[12,3],[nMB,nMB],2,2,wf4(:,6),wf4(:,1))
  call Hloop_QV_A(ntryL,G0H16(1),wf4(:,6),G0H4(1),m3h4x4(:,137),heltab2x16(:,:,292))
  call Hloop_Q_A(ntryL,G0H4(1),12,nMB,G1H4(41),n2h4(101))
  Gcoeff(:)%j = (c(153)*M(2,:)%j) * den(15)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(293),h0tab(:,293),[12,3],[nME,nME],2,2,wf4(:,8),wf4(:,1))
  call Hloop_QZ_A(ntryL,G0H16(1),wf4(:,8),G0H4(2),ngZl,m3h4x4(:,138),heltab2x16(:,:,293))
  call Hloop_Q_A(ntryL,G0H4(2),12,nME,G1H4(62),n2h4(102))
  Gcoeff(:)%j = (c(157)*M(2,:)%j) * den(15)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(294),h0tab(:,294),[12,3],[nMM,nMM],2,2,wf4(:,8),wf4(:,1))
  call Hloop_QZ_A(ntryL,G0H16(1),wf4(:,8),G0H4(7),ngZl,m3h4x4(:,139),heltab2x16(:,:,294))
  call Hloop_Q_A(ntryL,G0H4(7),12,nMM,G1H4(64),n2h4(103))
  Gcoeff(:)%j = (c(155)*M(2,:)%j) * den(15)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(295),h0tab(:,295),[12,3],[nML,nML],2,2,wf4(:,8),wf4(:,1))
  call Hloop_QZ_A(ntryL,G0H16(1),wf4(:,8),G0H4(8),ngZl,m3h4x4(:,140),heltab2x16(:,:,295))
  call Hloop_Q_A(ntryL,G0H4(8),12,nML,G1H4(51),n2h4(104))
  Gcoeff(:)%j = (c(159)*M(2,:)%j) * den(15)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(296),h0tab(:,296),[12,3],[nMT,nMT],2,2,wf4(:,8),wf4(:,1))
  call Hloop_QZ_A(ntryL,G0H16(1),wf4(:,8),G0H4(9),ngZu,m3h4x4(:,141),heltab2x16(:,:,296))
  call Hloop_Q_A(ntryL,G0H4(9),12,nMT,G1H4(63),n2h4(105))
  Gcoeff(:)%j = (c(151)*M(2,:)%j) * den(15)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(297),h0tab(:,297),[12,3],[nMB,nMB],2,2,wf4(:,8),wf4(:,1))
  call Hloop_QZ_A(ntryL,G0H16(1),wf4(:,8),G0H4(10),ngZd,m3h4x4(:,142),heltab2x16(:,:,297))
  call Hloop_Q_A(ntryL,G0H4(10),12,nMB,G1H4(68),n2h4(106))
  Gcoeff(:)%j = (c(152)*M(2,:)%j) * den(11)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(298),h0tab(:,298),[12,3],[nME,nME],2,2,wf4(:,6),wf4(:,3))
  call Hloop_QV_A(ntryL,G0H16(1),wf4(:,6),G0H4(25),m3h4x4(:,143),heltab2x16(:,:,298))
  call Hloop_Q_A(ntryL,G0H4(25),12,nME,G1H4(65),n2h4(107))
  Gcoeff(:)%j = (c(156)*M(2,:)%j) * den(11)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(299),h0tab(:,299),[12,3],[nMM,nMM],2,2,wf4(:,6),wf4(:,3))
  call Hloop_QV_A(ntryL,G0H16(1),wf4(:,6),G0H4(23),m3h4x4(:,144),heltab2x16(:,:,299))
  call Hloop_Q_A(ntryL,G0H4(23),12,nMM,G1H4(66),n2h4(108))
  Gcoeff(:)%j = (c(154)*M(2,:)%j) * den(11)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(300),h0tab(:,300),[12,3],[nML,nML],2,2,wf4(:,6),wf4(:,3))
  call Hloop_QV_A(ntryL,G0H16(1),wf4(:,6),G0H4(24),m3h4x4(:,145),heltab2x16(:,:,300))
  call Hloop_Q_A(ntryL,G0H4(24),12,nML,G1H4(67),n2h4(109))
  Gcoeff(:)%j = (c(158)*M(2,:)%j) * den(11)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(301),h0tab(:,301),[12,3],[nMT,nMT],2,2,wf4(:,6),wf4(:,3))
  call Hloop_QV_A(ntryL,G0H16(1),wf4(:,6),G0H4(19),m3h4x4(:,146),heltab2x16(:,:,301))
  call Hloop_Q_A(ntryL,G0H4(19),12,nMT,G1H4(2),n2h4(110))
  Gcoeff(:)%j = (c(149)*M(2,:)%j) * den(11)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(302),h0tab(:,302),[12,3],[nMB,nMB],2,2,wf4(:,6),wf4(:,3))
  call Hloop_QV_A(ntryL,G0H16(1),wf4(:,6),G0H4(1),m3h4x4(:,147),heltab2x16(:,:,302))
  call Hloop_Q_A(ntryL,G0H4(1),12,nMB,G1H4(4),n2h4(111))
  Gcoeff(:)%j = (c(153)*M(2,:)%j) * den(10)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(303),h0tab(:,303),[12,3],[nME,nME],2,2,wf4(:,8),wf4(:,3))
  call Hloop_QZ_A(ntryL,G0H16(1),wf4(:,8),G0H4(2),ngZl,m3h4x4(:,148),heltab2x16(:,:,303))
  call Hloop_Q_A(ntryL,G0H4(2),12,nME,G1H4(5),n2h4(112))
  Gcoeff(:)%j = (c(157)*M(2,:)%j) * den(10)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(304),h0tab(:,304),[12,3],[nMM,nMM],2,2,wf4(:,8),wf4(:,3))
  call Hloop_QZ_A(ntryL,G0H16(1),wf4(:,8),G0H4(7),ngZl,m3h4x4(:,149),heltab2x16(:,:,304))
  call Hloop_Q_A(ntryL,G0H4(7),12,nMM,G1H4(12),n2h4(113))
  Gcoeff(:)%j = (c(155)*M(2,:)%j) * den(10)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(305),h0tab(:,305),[12,3],[nML,nML],2,2,wf4(:,8),wf4(:,3))
  call Hloop_QZ_A(ntryL,G0H16(1),wf4(:,8),G0H4(8),ngZl,m3h4x4(:,150),heltab2x16(:,:,305))
  call Hloop_Q_A(ntryL,G0H4(8),12,nML,G1H4(43),n2h4(114))
  Gcoeff(:)%j = (-(c(159)*M(2,:)%j)) * den(10)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(306),h0tab(:,306),[12,3],[nMT,nMT],2,2,wf4(:,8),wf4(:,3))
  call Hloop_QZ_A(ntryL,G0H16(1),wf4(:,8),G0H4(9),ngZu,m3h4x4(:,151),heltab2x16(:,:,306))
  call Hloop_Q_A(ntryL,G0H4(9),12,nMT,G1H4(36),n2h4(115))
  Gcoeff(:)%j = (c(151)*M(2,:)%j) * den(10)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(307),h0tab(:,307),[12,3],[nMB,nMB],2,2,wf4(:,8),wf4(:,3))
  call Hloop_QZ_A(ntryL,G0H16(1),wf4(:,8),G0H4(10),ngZd,m3h4x4(:,152),heltab2x16(:,:,307))
  call Hloop_Q_A(ntryL,G0H4(10),12,nMB,G1H4(21),n2h4(116))
  Gcoeff(:)%j = (c(87)*M(2,:)%j) * den(17)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(308),h0tab(:,308),[12,3],[nMW,nMW],2,2,wf4(:,6),wf4(:,1))
  call Hloop_TV_S(ntryL,G0H16(1),0,wf4(:,6),12,G1H4(44),m3h4x4(:,153),heltab2x16(:,:,308))
  Gcoeff(:)%j = (c(106)*M(2,:)%j) * den(15)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(309),h0tab(:,309),[12,3],[nMW,nMW],2,2,wf4(:,8),wf4(:,1))
  call Hloop_TV_S(ntryL,G0H16(1),0,wf4(:,8),12,G1H4(25),m3h4x4(:,154),heltab2x16(:,:,309))
  Gcoeff(:)%j = (-(c(58)*M(2,:)%j)) * den(10)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(310),h0tab(:,310),[12,3],[nMH,nMZ],2,2,wf4(:,8),wf4(:,3))
  call Hloop_SV_T(ntryL,G0H16(1),0,wf4(:,8),12,G1H4(22),m3h4x4(:,155),heltab2x16(:,:,310))
  Gcoeff(:)%j = (c(71)*M(2,:)%j) * den(17)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(311),h0tab(:,311),[12,3],[nMW,nMW],2,2,wf4(:,6),wf4(:,1))
  call Hloop_CV_D(ntryL,G0H16(1),0,wf4(:,6),12,G1H4(45),m3h4x4(:,156),heltab2x16(:,:,311))
  Gcoeff(:)%j = (-(c(71)*M(2,:)%j)) * den(17)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(312),h0tab(:,312),[12,3],[nMW,nMW],2,2,wf4(:,6),wf4(:,1))
  call Hloop_CV_D(ntryL,G0H16(1),0,wf4(:,6),12,G1H4(26),m3h4x4(:,157),heltab2x16(:,:,312))
  Gcoeff(:)%j = (-(c(53)*M(2,:)%j)) * den(15)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(313),h0tab(:,313),[12,3],[nMW,nMW],2,2,wf4(:,8),wf4(:,1))
  call Hloop_CV_D(ntryL,G0H16(1),0,wf4(:,8),12,G1H4(35),m3h4x4(:,158),heltab2x16(:,:,313))
  Gcoeff(:)%j = (c(53)*M(2,:)%j) * den(15)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(314),h0tab(:,314),[12,3],[nMW,nMW],2,2,wf4(:,8),wf4(:,1))
  call Hloop_CV_D(ntryL,G0H16(1),0,wf4(:,8),12,G1H4(28),m3h4x4(:,159),heltab2x16(:,:,314))
  Gcoeff(:)%j = (c(71)*M(2,:)%j) * den(11)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(315),h0tab(:,315),[12,3],[nMW,nMW],2,2,wf4(:,6),wf4(:,3))
  call Hloop_CV_D(ntryL,G0H16(1),0,wf4(:,6),12,G1H4(55),m3h4x4(:,160),heltab2x16(:,:,315))
  Gcoeff(:)%j = (c(71)*M(2,:)%j) * den(11)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(316),h0tab(:,316),[12,3],[nMW,nMW],2,2,wf4(:,6),wf4(:,3))
  call Hloop_CV_D(ntryL,G0H16(1),0,wf4(:,6),12,G1H4(47),m3h4x4(:,161),heltab2x16(:,:,316))
  Gcoeff(:)%j = (-(c(53)*M(2,:)%j)) * den(10)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(317),h0tab(:,317),[12,3],[nMW,nMW],2,2,wf4(:,8),wf4(:,3))
  call Hloop_CV_D(ntryL,G0H16(1),0,wf4(:,8),12,G1H4(27),m3h4x4(:,162),heltab2x16(:,:,317))
  Gcoeff(:)%j = (-(c(53)*M(2,:)%j)) * den(10)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(318),h0tab(:,318),[12,3],[nMW,nMW],2,2,wf4(:,8),wf4(:,3))
  call Hloop_CV_D(ntryL,G0H16(1),0,wf4(:,8),12,G1H4(56),m3h4x4(:,163),heltab2x16(:,:,318))
  Gcoeff(:)%j = (c(72)*M(2,:)%j) * den(17)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(319),h0tab(:,319),[12,3],[nMW,nMW],2,2,wf4(:,6),wf4(:,1))
  call Hloop_UV_W(ntryL,G0H16(1),0,wf4(:,6),12,G1H4(31),m3h4x4(:,164),heltab2x16(:,:,319))
  Gcoeff(:)%j = (-(c(54)*M(2,:)%j)) * den(15)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(320),h0tab(:,320),[12,3],[nMW,nMW],2,2,wf4(:,8),wf4(:,1))
  call Hloop_UV_W(ntryL,G0H16(1),0,wf4(:,8),12,G1H4(57),m3h4x4(:,165),heltab2x16(:,:,320))
  Gcoeff(:)%j = (-(c(71)*M(2,:)%j)) * den(17)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(321),h0tab(:,321),[12,3],[nMW,nMW],2,2,wf4(:,6),wf4(:,1))
  call Hloop_VV_S(ntryL,G0H16(1),wf4(:,6),G0H4(25),m3h4x4(:,166),heltab2x16(:,:,321))
  Gcoeff(:)%j = (c(71)*M(2,:)%j) * den(17)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(322),h0tab(:,322),[12,3],[nMW,nMW],2,2,wf4(:,6),wf4(:,1))
  call Hloop_VV_S(ntryL,G0H16(1),wf4(:,6),G0H4(23),m3h4x4(:,167),heltab2x16(:,:,322))
  Gcoeff(:)%j = (-(c(96)*M(2,:)%j)) * den(15)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(323),h0tab(:,323),[12,3],[nMW,nMW],2,2,wf4(:,8),wf4(:,1))
  call Hloop_VV_S(ntryL,G0H16(1),wf4(:,8),G0H4(24),m3h4x4(:,168),heltab2x16(:,:,323))
  Gcoeff(:)%j = (c(96)*M(2,:)%j) * den(15)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(324),h0tab(:,324),[12,3],[nMW,nMW],2,2,wf4(:,8),wf4(:,1))
  call Hloop_VV_S(ntryL,G0H16(1),wf4(:,8),G0H4(19),m3h4x4(:,169),heltab2x16(:,:,324))
  Gcoeff(:)%j = (c(71)*M(2,:)%j) * den(11)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(325),h0tab(:,325),[12,3],[nMW,nMW],2,2,wf4(:,6),wf4(:,3))
  call Hloop_VV_S(ntryL,G0H16(1),wf4(:,6),G0H4(1),m3h4x4(:,170),heltab2x16(:,:,325))
  Gcoeff(:)%j = (c(71)*M(2,:)%j) * den(11)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(326),h0tab(:,326),[12,3],[nMW,nMW],2,2,wf4(:,6),wf4(:,3))
  call Hloop_VV_S(ntryL,G0H16(1),wf4(:,6),G0H4(2),m3h4x4(:,171),heltab2x16(:,:,326))
  Gcoeff(:)%j = (-(c(52)*M(2,:)%j)) * den(10)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(327),h0tab(:,327),[12,3],[nMH,nMZ],2,2,wf4(:,8),wf4(:,3))
  call Hloop_VV_S(ntryL,G0H16(1),wf4(:,8),G0H4(7),m3h4x4(:,172),heltab2x16(:,:,327))
  Gcoeff(:)%j = (c(96)*M(2,:)%j) * den(10)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(328),h0tab(:,328),[12,3],[nMW,nMW],2,2,wf4(:,8),wf4(:,3))
  call Hloop_VV_S(ntryL,G0H16(1),wf4(:,8),G0H4(8),m3h4x4(:,173),heltab2x16(:,:,328))



end subroutine vamp_1

end module ol_vamp_1_pptt_ew_ttxbbx_4_/**/REALKIND
