
module ol_vamp_1_pptt_ew_ttxbbx_1_/**/REALKIND
contains

! **********************************************************************
subroutine vamp_1(M)
! P(0:3,nlegs) = incoming external momenta
! Uses tree structures 'wf', factors 'c', and denominators 'den' from loop_pptt_ew_ttxbbx_1.
! Sets colour stripped amplitudes A from the module loop_amplitudes_pptt_ew_ttxbbx_1.
! **********************************************************************
  use KIND_TYPES, only: REALKIND, QREALKIND, intkind2
  use ol_parameters_decl_/**/DREALKIND, only: l_switch
  use ol_parameters_decl_/**/QREALKIND ! masses
  use ol_vert_interface_/**/REALKIND
  use ol_prop_interface_/**/REALKIND
  use ol_last_step_/**/REALKIND
  use ol_tables_storage_pptt_ew_ttxbbx_1_/**/DREALKIND
  use ol_tensor_sum_storage_pptt_ew_ttxbbx_1_/**/REALKIND
  use ol_loop_handling_/**/REALKIND
  use ofred_reduction_/**/REALKIND, only: Hotf_4pt_reduction, Hotf_4pt_reduction_last
  use ofred_reduction_/**/REALKIND, only: Hotf_5pt_reduction, Hotf_5pt_reduction_last
  use ol_loop_reduction_/**/REALKIND, only: TI_bubble_red, TI_triangle_red

  use ol_loop_storage_pptt_ew_ttxbbx_1_/**/REALKIND
#ifndef PRECISION_dp
  use ol_loop_storage_pptt_ew_ttxbbx_1_/**/DREALKIND, only: &
    & p_switch, Hel, merge_step, merge_mism, merge_tables, merge_hels
#endif
  use hol_initialisation_/**/REALKIND, only: G0_hol_initialisation
  use ol_h_vert_interface_/**/REALKIND
  use ol_h_prop_interface_/**/REALKIND
  use ol_h_last_step_/**/REALKIND
  use ol_merging_/**/REALKIND, only: ol_merge, ol_merge_tensors, ol_merge_last

  implicit none

  type(Hpolcont) :: Gcoeff(16)
  type(Hpolcont), intent(in) :: M(4,16)


#ifndef PRECISION_dp
  if (ntryL==1 .OR. p_switch == 1) Gcoeff(:)%hf = Hel
#else
  if (ntryL==1 .OR. p_switch == 2) Gcoeff(:)%hf = Hel
#endif

  ! =============================================


! Dressing, otf merging and otf reduction calls to build loop structures

  Gcoeff(:)%j = (-(c(31)*M(1,:)%j)+c(30)*M(3,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(1),h0tab(:,1),[8,2,1,4],[0,nMT,nMH,nMB],4,0)
  call Hloop_QA_V(ntryL,G0H16(1),ex4(:),G0H8(1),m3h2x8(:,1),heltab2x16(:,:,1))
  Gcoeff(:)%j = (-(c(31)*M(1,:)%j)+c(30)*M(3,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(2),h0tab(:,2),[8,2,1,4],[0,nMT,nMZ,nMB],4,0)
  call Hloop_QA_V(ntryL,G0H16(1),ex4(:),G0H8(2),m3h2x8(:,2),heltab2x16(:,:,2))
  Gcoeff(:)%j = (-(c(31)*M(1,:)%j)+c(30)*M(3,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(3),h0tab(:,3),[8,2,1,4],[nMH,nMT,0,nMB],4,0)
  call Hloop_QA_S(ntryL,G0H16(1),ex4(:),G0H8(3),ngH,m3h2x8(:,3),heltab2x16(:,:,3))
  Gcoeff(:)%j = (-(c(31)*M(1,:)%j)+c(30)*M(3,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(4),h0tab(:,4),[8,2,1,4],[nMZ,nMT,0,nMB],4,0)
  call Hloop_QA_S(ntryL,G0H16(1),ex4(:),G0H8(4),ngX,m3h2x8(:,4),heltab2x16(:,:,4))
  Gcoeff(:)%j = (-(c(4)*M(1,:)%j)+c(3)*M(3,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(5),h0tab(:,5),[8,2,1,4],[0,nMT,0,nMB],4,0)
  call Hloop_QA_V(ntryL,G0H16(1),ex4(:),G0H8(5),m3h2x8(:,5),heltab2x16(:,:,5))
  Gcoeff(:)%j = (-(c(4)*M(1,:)%j)+c(3)*M(3,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(6),h0tab(:,6),[8,2,1,4],[0,nMT,0,nMB],4,0)
  call Hloop_QA_V(ntryL,G0H16(1),ex4(:),G0H8(6),m3h2x8(:,6),heltab2x16(:,:,6))
  Gcoeff(:)%j = (c(9)*M(1,:)%j-c(8)*M(3,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(7),h0tab(:,7),[8,2,1,4],[0,nMT,nMZ,nMB],4,0)
  call Hloop_QA_V(ntryL,G0H16(1),ex4(:),G0H8(7),m3h2x8(:,7),heltab2x16(:,:,7))
  Gcoeff(:)%j = (c(9)*M(1,:)%j-c(8)*M(3,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(8),h0tab(:,8),[8,2,1,4],[nMZ,nMT,0,nMB],4,0)
  call Hloop_QA_Z(ntryL,G0H16(1),ex4(:),G0H8(8),ngZd,m3h2x8(:,8),heltab2x16(:,:,8))
  Gcoeff(:)%j = (-(c(17)*M(2,:)%j)+c(18)*M(4,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(9),h0tab(:,9),[8,2,1,4],[0,nMT,0,nMB],4,0)
  call Hloop_QA_V(ntryL,G0H16(1),ex4(:),G0H8(9),m3h2x8(:,9),heltab2x16(:,:,9))
  Gcoeff(:)%j = (-(c(31)*M(1,:)%j)+c(30)*M(3,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(10),h0tab(:,10),[8,1,2,4],[nMH,nMT,0,nMB],4,0)
  call Hloop_QA_S(ntryL,G0H16(1),ex4(:),G0H8(10),ngH,m3h2x8(:,10),heltab2x16(:,:,10))
  Gcoeff(:)%j = (-(c(31)*M(1,:)%j)+c(30)*M(3,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(11),h0tab(:,11),[8,1,2,4],[nMZ,nMT,0,nMB],4,0)
  call Hloop_QA_S(ntryL,G0H16(1),ex4(:),G0H8(11),ngX,m3h2x8(:,11),heltab2x16(:,:,11))
  Gcoeff(:)%j = (-(c(31)*M(1,:)%j)+c(30)*M(3,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(12),h0tab(:,12),[8,1,2,4],[0,nMT,nMH,nMB],4,0)
  call Hloop_QA_V(ntryL,G0H16(1),ex4(:),G0H8(12),m3h2x8(:,12),heltab2x16(:,:,12))
  Gcoeff(:)%j = (-(c(31)*M(1,:)%j)+c(30)*M(3,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(13),h0tab(:,13),[8,1,2,4],[0,nMT,nMZ,nMB],4,0)
  call Hloop_QA_V(ntryL,G0H16(1),ex4(:),G0H8(13),m3h2x8(:,13),heltab2x16(:,:,13))
  Gcoeff(:)%j = (c(25)*M(1,:)%j-c(26)*M(3,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(14),h0tab(:,14),[8,1,2,4],[nMB,nMW,nMB,0],4,0)
  call Hloop_VA_Q(ntryL,G0H16(1),ex4(:),G0H8(14),m3h2x8(:,14),heltab2x16(:,:,14))
  call Hloop_A_Q(ntryL,G0H8(14),8,nMB,G1H8(1),n2h8(1))
  Gcoeff(:)%j = (c(25)*M(1,:)%j-c(26)*M(3,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(15),h0tab(:,15),[8,1,2,4],[nMT,0,nMT,nMW],4,0)
  call Hloop_SA_Q(ntryL,G0H16(1),ex4(:),G0H8(14),ngPbt,m3h2x8(:,15),heltab2x16(:,:,15))
  call Hloop_A_Q(ntryL,G0H8(14),8,nMT,G1H8(2),n2h8(2))
  Gcoeff(:)%j = (-(c(4)*M(1,:)%j)+c(3)*M(3,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(16),h0tab(:,16),[8,1,2,4],[0,nMT,0,nMB],4,0)
  call Hloop_QA_V(ntryL,G0H16(1),ex4(:),G0H8(14),m3h2x8(:,16),heltab2x16(:,:,16))
  Gcoeff(:)%j = (-(c(4)*M(1,:)%j)+c(3)*M(3,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(17),h0tab(:,17),[8,1,2,4],[0,nMT,0,nMB],4,0)
  call Hloop_QA_V(ntryL,G0H16(1),ex4(:),G0H8(15),m3h2x8(:,17),heltab2x16(:,:,17))
  Gcoeff(:)%j = (c(9)*M(1,:)%j-c(8)*M(3,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(18),h0tab(:,18),[8,1,2,4],[nMZ,nMT,0,nMB],4,0)
  call Hloop_QA_Z(ntryL,G0H16(1),ex4(:),G0H8(16),ngZd,m3h2x8(:,18),heltab2x16(:,:,18))
  Gcoeff(:)%j = (c(9)*M(1,:)%j-c(8)*M(3,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(19),h0tab(:,19),[8,1,2,4],[0,nMT,nMZ,nMB],4,0)
  call Hloop_QA_V(ntryL,G0H16(1),ex4(:),G0H8(17),m3h2x8(:,19),heltab2x16(:,:,19))
  Gcoeff(:)%j = (c(20)*M(2,:)%j+c(15)*M(4,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(20),h0tab(:,20),[8,1,2,4],[0,nMT,0,nMB],4,0)
  call Hloop_QA_V(ntryL,G0H16(1),ex4(:),G0H8(18),m3h2x8(:,20),heltab2x16(:,:,20))
  Gcoeff(:)%j = (c(22)*M(1,:)%j-c(23)*M(3,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(21),h0tab(:,21),[8,1,2,4],[nMT,0,nMT,nMW],4,0)
  call Hloop_WA_Q(ntryL,G0H16(1),ex4(:),G0H8(19),m3h2x8(:,21),heltab2x16(:,:,21))
  call Hloop_A_Q(ntryL,G0H8(19),8,nMT,G1H8(3),n2h8(3))
  Gcoeff(:)%j = (c(22)*M(1,:)%j-c(23)*M(3,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(22),h0tab(:,22),[8,1,2,4],[nMB,nMW,nMB,0],4,0)
  call Hloop_VA_Q(ntryL,G0H16(1),ex4(:),G0H8(19),m3h2x8(:,22),heltab2x16(:,:,22))
  call Hloop_A_Q(ntryL,G0H8(19),8,nMB,G1H8(4),n2h8(4))
  Gcoeff(:)%j = (c(25)*M(1,:)%j-c(26)*M(3,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(23),h0tab(:,23),[8,1,4,2],[nMB,nMW,nMT,0],4,0)
  call Hloop_VA_Q(ntryL,G0H16(1),ex4(:),G0H8(19),m3h2x8(:,23),heltab2x16(:,:,23))
  call Hloop_A_Q(ntryL,G0H8(19),8,nMB,G1H8(5),n2h8(5))
  Gcoeff(:)%j = (c(25)*M(1,:)%j-c(26)*M(3,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(24),h0tab(:,24),[8,1,4,2],[nMT,0,nMB,nMW],4,0)
  call Hloop_SA_Q(ntryL,G0H16(1),ex4(:),G0H8(19),ngPbt,m3h2x8(:,24),heltab2x16(:,:,24))
  call Hloop_A_Q(ntryL,G0H8(19),8,nMT,G1H8(6),n2h8(6))
  Gcoeff(:)%j = (c(22)*M(1,:)%j-c(23)*M(3,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(25),h0tab(:,25),[8,1,4,2],[nMB,nMW,nMT,0],4,0)
  call Hloop_VA_Q(ntryL,G0H16(1),ex4(:),G0H8(19),m3h2x8(:,25),heltab2x16(:,:,25))
  call Hloop_A_Q(ntryL,G0H8(19),8,nMB,G1H8(7),n2h8(7))
  Gcoeff(:)%j = (c(22)*M(1,:)%j-c(23)*M(3,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(26),h0tab(:,26),[8,1,4,2],[nMT,0,nMB,nMW],4,0)
  call Hloop_WA_Q(ntryL,G0H16(1),ex4(:),G0H8(19),m3h2x8(:,26),heltab2x16(:,:,26))
  call Hloop_A_Q(ntryL,G0H8(19),8,nMT,G1H8(8),n2h8(8))
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G0H8(9),[G0H8(6),G0H8(5)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G0H8(18),[G0H8(15),G0H8(14)])
  call Hloop_VA_Q(ntryL,G0H8(1),ex2(:),G0H4(1),m3h2x4(:,1),heltab2x8(:,:,1))
  call Hloop_A_Q(ntryL,G0H4(1),10,nMT,G1H4(1),n2h4(1))
  call Hloop_VA_Q(ntryL,G0H8(2),ex2(:),G0H4(1),m3h2x4(:,2),heltab2x8(:,:,2))
  call Hloop_A_Q(ntryL,G0H4(1),10,nMT,G1H4(2),n2h4(2))
  call Hloop_SA_Q(ntryL,G0H8(3),ex2(:),G0H4(1),ngH,m3h2x4(:,3),heltab2x8(:,:,3))
  call Hloop_A_Q(ntryL,G0H4(1),10,nMT,G1H4(3),n2h4(3))
  call Hloop_SA_Q(ntryL,G0H8(4),ex2(:),G0H4(1),ngX,m3h2x4(:,4),heltab2x8(:,:,4))
  call Hloop_A_Q(ntryL,G0H4(1),10,nMT,G1H4(4),n2h4(4))
  call Hloop_VA_Q(ntryL,G0H8(9),ex2(:),G0H4(1),m3h2x4(:,5),heltab2x8(:,:,5))
  call Hloop_A_Q(ntryL,G0H4(1),10,nMT,G1H4(5),n2h4(5))
  call Hloop_VA_Q(ntryL,G0H8(7),ex2(:),G0H4(1),m3h2x4(:,6),heltab2x8(:,:,6))
  call Hloop_A_Q(ntryL,G0H4(1),10,nMT,G1H4(6),n2h4(6))
  call Hloop_ZA_Q(ntryL,G0H8(8),ex2(:),G0H4(1),ngZu,m3h2x4(:,7),heltab2x8(:,:,7))
  call Hloop_A_Q(ntryL,G0H4(1),10,nMT,G1H4(7),n2h4(7))
  call Hloop_SQ_A(ntryL,G0H8(10),ex1(:),G0H4(1),ngH,m3h2x4(:,8),heltab2x8(:,:,8))
  call Hloop_Q_A(ntryL,G0H4(1),9,nMT,G1H4(8),n2h4(8))
  call Hloop_SQ_A(ntryL,G0H8(11),ex1(:),G0H4(1),ngX,m3h2x4(:,9),heltab2x8(:,:,9))
  call Hloop_Q_A(ntryL,G0H4(1),9,nMT,G1H4(9),n2h4(9))
  call Hloop_VQ_A(ntryL,G0H8(12),ex1(:),G0H4(1),m3h2x4(:,10),heltab2x8(:,:,10))
  call Hloop_Q_A(ntryL,G0H4(1),9,nMT,G1H4(10),n2h4(10))
  call Hloop_VQ_A(ntryL,G0H8(13),ex1(:),G0H4(1),m3h2x4(:,11),heltab2x8(:,:,11))
  call Hloop_Q_A(ntryL,G0H4(1),9,nMT,G1H4(11),n2h4(11))
  call Hloop_AQ_S(ntryL,G1H8(1),ex1(:),G1H4(12),ngPbt,m3h2x4(:,12),heltab2x8(:,:,12))
  call Hloop_AQ_V(ntryL,G1H8(2),ex1(:),G1H4(13),m3h2x4(:,13),heltab2x8(:,:,13))
  call Hloop_VQ_A(ntryL,G0H8(18),ex1(:),G0H4(1),m3h2x4(:,14),heltab2x8(:,:,14))
  call Hloop_Q_A(ntryL,G0H4(1),9,nMT,G1H4(14),n2h4(12))
  call Hloop_ZQ_A(ntryL,G0H8(16),ex1(:),G0H4(1),ngZu,m3h2x4(:,15),heltab2x8(:,:,15))
  call Hloop_Q_A(ntryL,G0H4(1),9,nMT,G1H4(15),n2h4(13))
  call Hloop_VQ_A(ntryL,G0H8(17),ex1(:),G0H4(1),m3h2x4(:,16),heltab2x8(:,:,16))
  call Hloop_Q_A(ntryL,G0H4(1),9,nMT,G1H4(16),n2h4(14))
  call Hloop_AQ_V(ntryL,G1H8(3),ex1(:),G1H4(17),m3h2x4(:,17),heltab2x8(:,:,17))
  call Hloop_AQ_W(ntryL,G1H8(4),ex1(:),G1H4(18),m3h2x4(:,18),heltab2x8(:,:,18))
  call Hloop_AQ_S(ntryL,G1H8(5),ex1(:),G1H4(19),ngPbt,m3h2x4(:,19),heltab2x8(:,:,19))
  call Hloop_AQ_V(ntryL,G1H8(6),ex1(:),G1H4(20),m3h2x4(:,20),heltab2x8(:,:,20))
  call Hloop_AQ_W(ntryL,G1H8(7),ex1(:),G1H4(21),m3h2x4(:,21),heltab2x8(:,:,21))
  call Hloop_AQ_V(ntryL,G1H8(8),ex1(:),G1H4(22),m3h2x4(:,22),heltab2x8(:,:,22))
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(7),[G1H4(4)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(15),[G1H4(9)])
  call Hloop_AQ_S(ntryL,G1H4(1),ex1(:),G1H2(1),ngH,m3h2x2(:,1),heltab2x4(:,:,1))
  call Hloop_AQ_S(ntryL,G1H4(2),ex1(:),G1H2(2),ngX,m3h2x2(:,2),heltab2x4(:,:,2))
  call Hloop_AQ_V(ntryL,G1H4(3),ex1(:),G1H2(3),m3h2x2(:,3),heltab2x4(:,:,3))
  call Hloop_AQ_V(ntryL,G1H4(7),ex1(:),G1H2(4),m3h2x2(:,4),heltab2x4(:,:,4))
  call Hloop_AQ_V(ntryL,G1H4(5),ex1(:),G1H2(5),m3h2x2(:,5),heltab2x4(:,:,5))
  call Hloop_AQ_Z(ntryL,G1H4(6),ex1(:),G1H2(6),ngZu,m3h2x2(:,6),heltab2x4(:,:,6))
  call Hloop_QA_V(ntryL,G1H4(8),ex2(:),G1H2(7),m3h2x2(:,7),heltab2x4(:,:,7))
  call Hloop_QA_V(ntryL,G1H4(15),ex2(:),G1H2(8),m3h2x2(:,8),heltab2x4(:,:,8))
  call Hloop_QA_S(ntryL,G1H4(10),ex2(:),G1H2(9),ngH,m3h2x2(:,9),heltab2x4(:,:,9))
  call Hloop_QA_S(ntryL,G1H4(11),ex2(:),G1H2(10),ngX,m3h2x2(:,10),heltab2x4(:,:,10))
  call Hloop_SA_Q(ntryL,G1H4(12),ex2(:),G1H2(11),ngPtb,m3h2x2(:,11),heltab2x4(:,:,11))
  call Hloop_A_Q(ntryL,G1H2(11),11,nMB,G2H2(1),n2h2(1))
  call Hloop_VA_Q(ntryL,G1H4(13),ex2(:),G1H2(11),m3h2x2(:,12),heltab2x4(:,:,12))
  call Hloop_A_Q(ntryL,G1H2(11),11,nMT,G2H2(2),n2h2(2))
  call Hloop_QA_V(ntryL,G1H4(14),ex2(:),G1H2(11),m3h2x2(:,13),heltab2x4(:,:,13))
  call Hloop_QA_Z(ntryL,G1H4(16),ex2(:),G1H2(12),ngZu,m3h2x2(:,14),heltab2x4(:,:,14))
  call Hloop_VA_Q(ntryL,G1H4(17),ex2(:),G1H2(13),m3h2x2(:,15),heltab2x4(:,:,15))
  call Hloop_A_Q(ntryL,G1H2(13),11,nMT,G2H2(3),n2h2(3))
  call Hloop_WA_Q(ntryL,G1H4(18),ex2(:),G1H2(13),m3h2x2(:,16),heltab2x4(:,:,16))
  call Hloop_A_Q(ntryL,G1H2(13),11,nMB,G2H2(4),n2h2(4))
  call Hloop_SQ_A(ntryL,G1H4(19),ex3(:),G1H2(13),ngPtb,m3h2x2(:,17),heltab2x4(:,:,17))
  call Hloop_Q_A(ntryL,G1H2(13),13,nMT,G2H2(5),n2h2(5))
  call Hloop_VQ_A(ntryL,G1H4(20),ex3(:),G1H2(13),m3h2x2(:,18),heltab2x4(:,:,18))
  call Hloop_Q_A(ntryL,G1H2(13),13,nMB,G2H2(6),n2h2(6))
  call Hloop_WQ_A(ntryL,G1H4(21),ex3(:),G1H2(13),m3h2x2(:,19),heltab2x4(:,:,19))
  call Hloop_Q_A(ntryL,G1H2(13),13,nMT,G2H2(7),n2h2(7))
  call Hloop_VQ_A(ntryL,G1H4(22),ex3(:),G1H2(13),m3h2x2(:,20),heltab2x4(:,:,20))
  call Hloop_Q_A(ntryL,G1H2(13),13,nMB,G2H2(8),n2h2(8))
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(4),[G2H2(1)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(7),[G2H2(5)])
  call Hloop_SQ_A(ntryL,G1H2(1),ex3(:),G1H1(1),ngH,m3h2x1(:,1),heltab2x2(:,:,1))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),15,nMB,G2tensor(1),n2h1(1))
  call Hloop_SQ_A(ntryL,G1H2(2),ex3(:),G1H1(1),ngX,m3h2x1(:,2),heltab2x2(:,:,2))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),15,nMB,G2tensor(2),n2h1(2))
  call Hloop_VQ_A(ntryL,G1H2(3),ex3(:),G1H1(1),m3h2x1(:,3),heltab2x2(:,:,3))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),15,nMB,G2tensor(3),n2h1(3))
  call Hloop_VQ_A(ntryL,G1H2(4),ex3(:),G1H1(1),m3h2x1(:,4),heltab2x2(:,:,4))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),15,nMB,G2tensor(4),n2h1(4))
  call Hloop_VQ_A(ntryL,G1H2(5),ex3(:),G1H1(1),m3h2x1(:,5),heltab2x2(:,:,5))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),15,nMB,G2tensor(5),n2h1(5))
  call Hloop_ZQ_A(ntryL,G1H2(6),ex3(:),G1H1(1),ngZd,m3h2x1(:,6),heltab2x2(:,:,6))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),15,nMB,G2tensor(6),n2h1(6))
  call Hloop_VQ_A(ntryL,G1H2(7),ex3(:),G1H1(1),m3h2x1(:,7),heltab2x2(:,:,7))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),15,nMB,G2tensor(7),n2h1(7))
  call Hloop_VQ_A(ntryL,G1H2(8),ex3(:),G1H1(1),m3h2x1(:,8),heltab2x2(:,:,8))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),15,nMB,G2tensor(8),n2h1(8))
  call Hloop_SQ_A(ntryL,G1H2(9),ex3(:),G1H1(1),ngH,m3h2x1(:,9),heltab2x2(:,:,9))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),15,nMB,G2tensor(9),n2h1(9))
  call Hloop_SQ_A(ntryL,G1H2(10),ex3(:),G1H1(1),ngX,m3h2x1(:,10),heltab2x2(:,:,10))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),15,nMB,G2tensor(10),n2h1(10))
  call Hcheck_last_AQ_V(ntryL,l_switch,G2H2(4),ex3(:),G2tensor(11),m3h2x1(:,11),heltab2x2(:,:,11))
  call Hcheck_last_AQ_S(ntryL,l_switch,G2H2(2),ex3(:),G2tensor(12),ngPtb,m3h2x1(:,12),heltab2x2(:,:,12))
  call Hloop_VQ_A(ntryL,G1H2(11),ex3(:),G1H1(1),m3h2x1(:,13),heltab2x2(:,:,13))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),15,nMB,G2tensor(13),n2h1(11))
  call Hloop_ZQ_A(ntryL,G1H2(12),ex3(:),G1H1(1),ngZd,m3h2x1(:,14),heltab2x2(:,:,14))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),15,nMB,G2tensor(14),n2h1(12))
  call Hcheck_last_AQ_W(ntryL,l_switch,G2H2(3),ex3(:),G2tensor(15),m3h2x1(:,15),heltab2x2(:,:,15))
  call Hcheck_last_QA_V(ntryL,l_switch,G2H2(7),ex2(:),G2tensor(16),m3h2x1(:,16),heltab2x2(:,:,16))
  call Hcheck_last_QA_S(ntryL,l_switch,G2H2(6),ex2(:),G2tensor(17),ngPtb,m3h2x1(:,17),heltab2x2(:,:,17))
  call Hcheck_last_QA_W(ntryL,l_switch,G2H2(8),ex2(:),G2tensor(18),m3h2x1(:,18),heltab2x2(:,:,18))
  call ol_merge_tensors(G2tensor(6),[G2tensor(2)])
  call ol_merge_tensors(G2tensor(14),[G2tensor(10)])
  call ol_merge_tensors(G2tensor(15),[G2tensor(12)])
  call ol_merge_tensors(G2tensor(18),[G2tensor(17)])
  call Hotf_4pt_reduction_last(G2tensor(1),RedSet_4(1),mass4set(:,1),  & 
G1tensor(1),G1tensor(2),G1tensor(3),G1tensor(4),G1tensor(5))
  call G_TensorShift(G1tensor(2),4)
  call Hotf_4pt_reduction_last(G2tensor(6),RedSet_4(1),mass4set(:,2),  & 
G1tensor(6),G1tensor(7),G1tensor(8),G1tensor(9),G1tensor(10))
  call G_TensorShift(G1tensor(7),4)
  call Hotf_4pt_reduction_last(G2tensor(3),RedSet_4(1),mass4set(:,3),  & 
G1tensor(11),G1tensor(12),G1tensor(13),G1tensor(14),G1tensor(15))
  call G_TensorShift(G1tensor(12),4)
  call Hotf_4pt_reduction_last(G2tensor(4),RedSet_4(1),mass4set(:,4),  & 
G1tensor(16),G1tensor(17),G1tensor(18),G1tensor(19),G1tensor(20))
  call G_TensorShift(G1tensor(17),4)
  call Hotf_4pt_reduction_last(G2tensor(5),RedSet_4(1),mass4set(:,5),  & 
G1tensor(21),G1tensor(22),G1tensor(23),G1tensor(24),G1tensor(25))
  call G_TensorShift(G1tensor(22),4)
  call Hotf_4pt_reduction_last(G2tensor(7),RedSet_4(2),mass4set(:,3),  & 
G1tensor(26),G1tensor(27),G1tensor(28),G1tensor(29),G1tensor(30))
  call G_TensorShift(G1tensor(27),4)
  call Hotf_4pt_reduction_last(G2tensor(8),RedSet_4(2),mass4set(:,4),  & 
G1tensor(31),G1tensor(32),G1tensor(33),G1tensor(34),G1tensor(35))
  call G_TensorShift(G1tensor(32),4)
  call Hotf_4pt_reduction_last(G2tensor(9),RedSet_4(2),mass4set(:,1),  & 
G1tensor(36),G1tensor(37),G1tensor(38),G1tensor(39),G1tensor(40))
  call G_TensorShift(G1tensor(37),4)
  call Hotf_4pt_reduction_last(G2tensor(14),RedSet_4(2),mass4set(:,2),  & 
G1tensor(41),G1tensor(42),G1tensor(43),G1tensor(44),G1tensor(45))
  call G_TensorShift(G1tensor(42),4)
  call Hotf_4pt_reduction_last(G2tensor(11),RedSet_4(2),mass4set(:,6),  & 
G1tensor(46),G1tensor(47),G1tensor(48),G1tensor(49),G1tensor(50))
  call G_TensorShift(G1tensor(47),4)
  call Hotf_4pt_reduction_last(G2tensor(15),RedSet_4(2),mass4set(:,7),  & 
G1tensor(51),G1tensor(52),G1tensor(53),G1tensor(54),G1tensor(55))
  call G_TensorShift(G1tensor(52),4)
  call Hotf_4pt_reduction_last(G2tensor(13),RedSet_4(2),mass4set(:,5),  & 
G1tensor(56),G1tensor(57),G1tensor(58),G1tensor(59),G1tensor(60))
  call G_TensorShift(G1tensor(57),4)
  call Hotf_4pt_reduction_last(G2tensor(16),RedSet_4(3),mass4set(:,8),  & 
G1tensor(61),G1tensor(62),G1tensor(63),G1tensor(64),G1tensor(65))
  call G_TensorShift(G1tensor(62),2)
  call Hotf_4pt_reduction_last(G2tensor(18),RedSet_4(3),mass4set(:,9),  & 
G1tensor(66),G1tensor(67),G1tensor(68),G1tensor(69),G1tensor(70))
  call G_TensorShift(G1tensor(67),2)
  call Hotf_4pt_reduction_last(G1tensor(1),RedSet_4(1),mass4set(:,1),  & 
G0tensor(1),G0tensor(2),G0tensor(3),G0tensor(4),G0tensor(5))
  call Hotf_4pt_reduction_last(G1tensor(6),RedSet_4(1),mass4set(:,2),  & 
G0tensor(6),G0tensor(7),G0tensor(8),G0tensor(9),G0tensor(10))
  call Hotf_4pt_reduction_last(G1tensor(11),RedSet_4(1),mass4set(:,3),  & 
G0tensor(11),G0tensor(12),G0tensor(13),G0tensor(14),G0tensor(15))
  call Hotf_4pt_reduction_last(G1tensor(16),RedSet_4(1),mass4set(:,4),  & 
G0tensor(16),G0tensor(17),G0tensor(18),G0tensor(19),G0tensor(20))
  call Hotf_4pt_reduction_last(G1tensor(21),RedSet_4(1),mass4set(:,5),  & 
G0tensor(21),G0tensor(22),G0tensor(23),G0tensor(24),G0tensor(25))
  call Hotf_4pt_reduction_last(G1tensor(26),RedSet_4(2),mass4set(:,3),  & 
G0tensor(26),G0tensor(27),G0tensor(28),G0tensor(29),G0tensor(30))
  call Hotf_4pt_reduction_last(G1tensor(31),RedSet_4(2),mass4set(:,4),  & 
G0tensor(31),G0tensor(32),G0tensor(33),G0tensor(34),G0tensor(35))
  call Hotf_4pt_reduction_last(G1tensor(36),RedSet_4(2),mass4set(:,1),  & 
G0tensor(36),G0tensor(37),G0tensor(38),G0tensor(39),G0tensor(40))
  call Hotf_4pt_reduction_last(G1tensor(41),RedSet_4(2),mass4set(:,2),  & 
G0tensor(41),G0tensor(42),G0tensor(43),G0tensor(44),G0tensor(45))
  call Hotf_4pt_reduction_last(G1tensor(46),RedSet_4(2),mass4set(:,6),  & 
G0tensor(46),G0tensor(47),G0tensor(48),G0tensor(49),G0tensor(50))
  call Hotf_4pt_reduction_last(G1tensor(51),RedSet_4(2),mass4set(:,7),  & 
G0tensor(51),G0tensor(52),G0tensor(53),G0tensor(54),G0tensor(55))
  call Hotf_4pt_reduction_last(G1tensor(56),RedSet_4(2),mass4set(:,5),  & 
G0tensor(56),G0tensor(57),G0tensor(58),G0tensor(59),G0tensor(60))
  call Hotf_4pt_reduction_last(G1tensor(61),RedSet_4(3),mass4set(:,8),  & 
G0tensor(61),G0tensor(62),G0tensor(63),G0tensor(64),G0tensor(65))
  call Hotf_4pt_reduction_last(G1tensor(66),RedSet_4(3),mass4set(:,9),  & 
G0tensor(66),G0tensor(67),G0tensor(68),G0tensor(69),G0tensor(70))
  call ol_merge_tensors(T0sum(1),[G0tensor(1)])
  call ol_merge_tensors(T0sum(2),[G0tensor(6)])
  call ol_merge_tensors(T0sum(3),[G0tensor(11)])
  call ol_merge_tensors(T0sum(4),[G0tensor(16)])
  call ol_merge_tensors(T0sum(5),[G0tensor(21)])
  call ol_merge_tensors(T0sum(6),[G0tensor(26)])
  call ol_merge_tensors(T0sum(7),[G0tensor(31)])
  call ol_merge_tensors(T0sum(8),[G0tensor(36)])
  call ol_merge_tensors(T0sum(9),[G0tensor(41)])
  call ol_merge_tensors(T0sum(10),[G0tensor(46)])
  call ol_merge_tensors(T0sum(11),[G0tensor(51)])
  call ol_merge_tensors(T0sum(12),[G0tensor(56)])
  call ol_merge_tensors(T0sum(13),[G0tensor(61)])
  call ol_merge_tensors(T0sum(14),[G0tensor(66)])
  Gcoeff(:)%j = (-(c(32)*M(3,:)%j)) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(27),h0tab(:,27),[8,3,4],[nMB,nMB,0],3,1,wf4(:,1))
  call Hloop_VA_Q(ntryL,G0H16(1),ex4(:),G0H8(19),m3h2x8(:,27),heltab2x16(:,:,27))
  call Hloop_A_Q(ntryL,G0H8(19),8,nMB,G1H8(1),n2h8(9))
  Gcoeff(:)%j = (-(c(32)*M(3,:)%j)) * den(2)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(28),h0tab(:,28),[8,3,4],[nMB,nMB,0],3,1,wf4(:,3))
  call Hloop_VA_Q(ntryL,G0H16(1),ex4(:),G0H8(6),m3h2x8(:,28),heltab2x16(:,:,28))
  call Hloop_A_Q(ntryL,G0H8(6),8,nMB,G1H8(2),n2h8(10))
  Gcoeff(:)%j = (-(c(29)*M(1,:)%j)+c(28)*M(3,:)%j) * den(3)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(29),h0tab(:,29),[8,3,4],[nMB,nMB,nMH],3,1,wf4(:,5))
  call Hloop_SA_Q(ntryL,G0H16(1),ex4(:),G0H8(5),ngH,m3h2x8(:,29),heltab2x16(:,:,29))
  call Hloop_A_Q(ntryL,G0H8(5),8,nMB,G1H8(3),n2h8(11))
  Gcoeff(:)%j = (c(29)*M(1,:)%j-c(28)*M(3,:)%j) * den(3)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(30),h0tab(:,30),[8,3,4],[nMB,nMB,nMZ],3,1,wf4(:,5))
  call Hloop_SA_Q(ntryL,G0H16(1),ex4(:),G0H8(15),ngX,m3h2x8(:,30),heltab2x16(:,:,30))
  call Hloop_A_Q(ntryL,G0H8(15),8,nMB,G1H8(4),n2h8(12))
  Gcoeff(:)%j = (c(26)*M(1,:)%j-c(25)*M(3,:)%j) * den(3)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(31),h0tab(:,31),[8,3,4],[nMT,nMT,nMW],3,1,wf4(:,5))
  call Hloop_SA_Q(ntryL,G0H16(1),ex4(:),G0H8(14),ngPbt,m3h2x8(:,31),heltab2x16(:,:,31))
  call Hloop_A_Q(ntryL,G0H8(14),8,nMT,G1H8(5),n2h8(13))
  Gcoeff(:)%j = (-(c(5)*M(3,:)%j)) * den(3)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(32),h0tab(:,32),[8,3,4],[nMB,nMB,0],3,1,wf4(:,5))
  call Hloop_VA_Q(ntryL,G0H16(1),ex4(:),G0H8(1),m3h2x8(:,32),heltab2x16(:,:,32))
  call Hloop_A_Q(ntryL,G0H8(1),8,nMB,G1H8(6),n2h8(14))
  Gcoeff(:)%j = (c(10)*M(3,:)%j) * den(2)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(33),h0tab(:,33),[8,3,4],[nMB,nMB,0],3,1,wf4(:,7))
  call Hloop_VA_Q(ntryL,G0H16(1),ex4(:),G0H8(2),m3h2x8(:,33),heltab2x16(:,:,33))
  call Hloop_A_Q(ntryL,G0H8(2),8,nMB,G1H8(7),n2h8(15))
  Gcoeff(:)%j = (c(2)*M(1,:)%j-c(1)*M(3,:)%j) * den(3)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(34),h0tab(:,34),[8,3,4],[nMB,nMB,0],3,1,wf4(:,5))
  call Hloop_VA_Q(ntryL,G0H16(1),ex4(:),G0H8(3),m3h2x8(:,34),heltab2x16(:,:,34))
  call Hloop_A_Q(ntryL,G0H8(3),8,nMB,G1H8(8),n2h8(16))
  Gcoeff(:)%j = (c(9)*M(1,:)%j-c(8)*M(3,:)%j) * den(3)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(35),h0tab(:,35),[8,3,4],[nMB,nMB,nMZ],3,1,wf4(:,5))
  call Hloop_ZA_Q(ntryL,G0H16(1),ex4(:),G0H8(4),ngZd,m3h2x8(:,35),heltab2x16(:,:,35))
  call Hloop_A_Q(ntryL,G0H8(4),8,nMB,G1H8(9),n2h8(17))
  Gcoeff(:)%j = (c(23)*M(1,:)%j-c(22)*M(3,:)%j) * den(3)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(36),h0tab(:,36),[8,3,4],[nMT,nMT,nMW],3,1,wf4(:,5))
  call Hloop_WA_Q(ntryL,G0H16(1),ex4(:),G0H8(9),m3h2x8(:,36),heltab2x16(:,:,36))
  call Hloop_A_Q(ntryL,G0H8(9),8,nMT,G1H8(10),n2h8(18))
  Gcoeff(:)%j = (-(c(16)*M(2,:)%j)+c(15)*M(4,:)%j) * den(3)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(37),h0tab(:,37),[8,3,4],[nMB,nMB,0],3,1,wf4(:,5))
  call Hloop_VA_Q(ntryL,G0H16(1),ex4(:),G0H8(7),m3h2x8(:,37),heltab2x16(:,:,37))
  call Hloop_A_Q(ntryL,G0H8(7),8,nMB,G1H8(11),n2h8(19))
  Gcoeff(:)%j = (-(c(12)*M(2,:)%j)+c(11)*M(4,:)%j) * den(3)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(38),h0tab(:,38),[8,3,4],[0,0,nMB],3,1,wf4(:,5))
  call Hloop_QA_V(ntryL,G0H16(1),ex4(:),G0H8(8),m3h2x8(:,38),heltab2x16(:,:,38))
  Gcoeff(:)%j = (-(c(27)*M(1,:)%j)) * den(5)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(39),h0tab(:,39),[8,1,6],[0,nMT,nMB],3,1,wf4(:,10))
  call Hloop_QA_V(ntryL,G0H16(1),ex4(:),G0H8(10),m3h2x8(:,39),heltab2x16(:,:,39))
  Gcoeff(:)%j = (-(c(24)*M(1,:)%j)) * den(5)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(40),h0tab(:,40),[8,1,6],[0,nMT,nMB],3,1,wf4(:,12))
  call Hloop_QA_V(ntryL,G0H16(1),ex4(:),G0H8(11),m3h2x8(:,40),heltab2x16(:,:,40))
  Gcoeff(:)%j = (-(c(27)*M(1,:)%j)) * den(4)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(41),h0tab(:,41),[9,2,4],[nMT,0,nMB],3,1,wf4(:,9))
  call Hloop_QS_A(ntryL,G0H16(1),wf4(:,9),G0H4(1),ngPtb,m3h4x4(:,1),heltab2x16(:,:,41))
  call Hloop_Q_A(ntryL,G0H4(1),9,nMT,G1H4(4),n2h4(15))
  Gcoeff(:)%j = (-(c(24)*M(1,:)%j)) * den(4)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(42),h0tab(:,42),[9,2,4],[nMT,0,nMB],3,1,wf4(:,11))
  call Hloop_QW_A(ntryL,G0H16(1),wf4(:,11),G0H4(1),m3h4x4(:,2),heltab2x16(:,:,42))
  call Hloop_Q_A(ntryL,G0H4(1),9,nMT,G1H4(9),n2h4(16))
  Gcoeff(:)%j = (-(c(32)*M(3,:)%j)) * den(6)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(43),h0tab(:,43),[12,1,2],[nMT,0,nMT],3,1,wf4(:,2))
  call Hloop_AS_Q(ntryL,G0H16(1),wf4(:,2),G0H4(1),ngH,m3h4x4(:,3),heltab2x16(:,:,43))
  call Hloop_A_Q(ntryL,G0H4(1),12,nMT,G1H4(1),n2h4(17))
  Gcoeff(:)%j = (-(c(32)*M(3,:)%j)) * den(7)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(44),h0tab(:,44),[12,1,2],[nMT,0,nMT],3,1,wf4(:,4))
  call Hloop_AS_Q(ntryL,G0H16(1),wf4(:,4),G0H4(1),ngX,m3h4x4(:,4),heltab2x16(:,:,44))
  call Hloop_A_Q(ntryL,G0H4(1),12,nMT,G1H4(2),n2h4(18))
  Gcoeff(:)%j = (-(c(34)*M(1,:)%j)+c(33)*M(3,:)%j) * den(8)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(45),h0tab(:,45),[12,1,2],[nMT,nMH,nMT],3,1,wf4(:,6))
  call Hloop_AV_Q(ntryL,G0H16(1),wf4(:,6),G0H4(1),m3h4x4(:,5),heltab2x16(:,:,45))
  call Hloop_A_Q(ntryL,G0H4(1),12,nMT,G1H4(3),n2h4(19))
  Gcoeff(:)%j = (c(34)*M(1,:)%j-c(33)*M(3,:)%j) * den(8)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(46),h0tab(:,46),[12,1,2],[nMT,nMZ,nMT],3,1,wf4(:,6))
  call Hloop_AV_Q(ntryL,G0H16(1),wf4(:,6),G0H4(1),m3h4x4(:,6),heltab2x16(:,:,46))
  call Hloop_A_Q(ntryL,G0H4(1),12,nMT,G1H4(7),n2h4(20))
  Gcoeff(:)%j = (c(26)*M(1,:)%j-c(25)*M(3,:)%j) * den(8)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(47),h0tab(:,47),[12,1,2],[nMB,nMW,nMB],3,1,wf4(:,6))
  call Hloop_AV_Q(ntryL,G0H16(1),wf4(:,6),G0H4(1),m3h4x4(:,7),heltab2x16(:,:,47))
  call Hloop_A_Q(ntryL,G0H4(1),12,nMB,G1H4(5),n2h4(21))
  Gcoeff(:)%j = (-(c(5)*M(3,:)%j)) * den(8)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(48),h0tab(:,48),[12,1,2],[nMT,0,nMT],3,1,wf4(:,6))
  call Hloop_AV_Q(ntryL,G0H16(1),wf4(:,6),G0H4(1),m3h4x4(:,8),heltab2x16(:,:,48))
  call Hloop_A_Q(ntryL,G0H4(1),12,nMT,G1H4(6),n2h4(22))
  Gcoeff(:)%j = (c(10)*M(3,:)%j) * den(7)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(49),h0tab(:,49),[12,1,2],[nMT,0,nMT],3,1,wf4(:,8))
  call Hloop_AZ_Q(ntryL,G0H16(1),wf4(:,8),G0H4(1),ngZu,m3h4x4(:,9),heltab2x16(:,:,49))
  call Hloop_A_Q(ntryL,G0H4(1),12,nMT,G1H4(8),n2h4(23))
  Gcoeff(:)%j = (c(7)*M(1,:)%j-c(6)*M(3,:)%j) * den(8)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(50),h0tab(:,50),[12,1,2],[nMT,0,nMT],3,1,wf4(:,6))
  call Hloop_AV_Q(ntryL,G0H16(1),wf4(:,6),G0H4(1),m3h4x4(:,10),heltab2x16(:,:,50))
  call Hloop_A_Q(ntryL,G0H4(1),12,nMT,G1H4(15),n2h4(24))
  Gcoeff(:)%j = (c(9)*M(1,:)%j-c(8)*M(3,:)%j) * den(8)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(51),h0tab(:,51),[12,1,2],[nMT,nMZ,nMT],3,1,wf4(:,6))
  call Hloop_AV_Q(ntryL,G0H16(1),wf4(:,6),G0H4(1),m3h4x4(:,11),heltab2x16(:,:,51))
  call Hloop_A_Q(ntryL,G0H4(1),12,nMT,G1H4(10),n2h4(25))
  Gcoeff(:)%j = (c(23)*M(1,:)%j-c(22)*M(3,:)%j) * den(8)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(52),h0tab(:,52),[12,1,2],[nMB,nMW,nMB],3,1,wf4(:,6))
  call Hloop_AV_Q(ntryL,G0H16(1),wf4(:,6),G0H4(1),m3h4x4(:,12),heltab2x16(:,:,52))
  call Hloop_A_Q(ntryL,G0H4(1),12,nMB,G1H4(11),n2h4(26))
  Gcoeff(:)%j = (-(c(16)*M(2,:)%j)+c(15)*M(4,:)%j) * den(8)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(53),h0tab(:,53),[12,1,2],[nMT,0,nMT],3,1,wf4(:,6))
  call Hloop_AV_Q(ntryL,G0H16(1),wf4(:,6),G0H4(1),m3h4x4(:,13),heltab2x16(:,:,53))
  call Hloop_A_Q(ntryL,G0H4(1),12,nMT,G1H4(12),n2h4(27))
  Gcoeff(:)%j = (-(c(12)*M(2,:)%j)+c(11)*M(4,:)%j) * den(8)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(54),h0tab(:,54),[12,1,2],[0,nMT,0],3,1,wf4(:,6))
  call Hloop_UV_W(ntryL,G0H16(1),0,wf4(:,6),12,G1H4(13),m3h4x4(:,14),heltab2x16(:,:,54))
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H8(11),[G1H8(8),G1H8(6)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(9),[G1H4(4)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(12),[G1H4(15),G1H4(8),G1H4(6),G1H4(2),G1H4(1)])
  call Hloop_AS_Q(ntryL,G1H8(1),wf4(:,1),G1H2(13),ngH,m3h4x2(:,1),heltab2x8(:,:,23))
  call Hloop_A_Q(ntryL,G1H2(13),11,nMB,G2H2(1),n2h2(9))
  call Hloop_AS_Q(ntryL,G1H8(2),wf4(:,3),G1H2(1),ngX,m3h4x2(:,2),heltab2x8(:,:,24))
  call Hloop_A_Q(ntryL,G1H2(1),11,nMB,G2H2(5),n2h2(10))
  call Hloop_AV_Q(ntryL,G1H8(3),wf4(:,5),G1H2(2),m3h4x2(:,3),heltab2x8(:,:,25))
  call Hloop_A_Q(ntryL,G1H2(2),11,nMB,G2H2(4),n2h2(11))
  call Hloop_AV_Q(ntryL,G1H8(4),wf4(:,5),G1H2(3),m3h4x2(:,4),heltab2x8(:,:,26))
  call Hloop_A_Q(ntryL,G1H2(3),11,nMB,G2H2(2),n2h2(12))
  call Hloop_AV_Q(ntryL,G1H8(5),wf4(:,5),G1H2(4),m3h4x2(:,5),heltab2x8(:,:,27))
  call Hloop_A_Q(ntryL,G1H2(4),11,nMT,G2H2(3),n2h2(13))
  call Hloop_AV_Q(ntryL,G1H8(11),wf4(:,5),G1H2(5),m3h4x2(:,6),heltab2x8(:,:,28))
  call Hloop_A_Q(ntryL,G1H2(5),11,nMB,G2H2(7),n2h2(14))
  call Hloop_AZ_Q(ntryL,G1H8(7),wf4(:,7),G1H2(6),ngZd,m3h4x2(:,7),heltab2x8(:,:,29))
  call Hloop_A_Q(ntryL,G1H2(6),11,nMB,G2H2(6),n2h2(15))
  call Hloop_AV_Q(ntryL,G1H8(9),wf4(:,5),G1H2(7),m3h4x2(:,8),heltab2x8(:,:,30))
  call Hloop_A_Q(ntryL,G1H2(7),11,nMB,G2H2(8),n2h2(16))
  call Hloop_AV_Q(ntryL,G1H8(10),wf4(:,5),G1H2(8),m3h4x2(:,9),heltab2x8(:,:,31))
  call Hloop_A_Q(ntryL,G1H2(8),11,nMT,G2H2(9),n2h2(17))
  call Hloop_UV_W(ntryL,G0H8(8),8,wf4(:,5),3,G1H2(9),m3h4x2(:,10),heltab2x8(:,:,32))
  call Hloop_VQ_A(ntryL,G0H8(10),ex1(:),G0H4(1),m3h2x4(:,23),heltab2x8(:,:,33))
  call Hloop_Q_A(ntryL,G0H4(1),9,nMT,G1H4(14),n2h4(28))
  call Hloop_VQ_A(ntryL,G0H8(11),ex1(:),G0H4(1),m3h2x4(:,24),heltab2x8(:,:,34))
  call Hloop_Q_A(ntryL,G0H4(1),9,nMT,G1H4(16),n2h4(29))
  call Hloop_QA_V(ntryL,G1H4(9),ex2(:),G1H2(10),m3h2x2(:,21),heltab2x4(:,:,21))
  call Hloop_AQ_V(ntryL,G1H4(12),ex1(:),G1H2(11),m3h2x2(:,22),heltab2x4(:,:,22))
  call Hloop_AQ_S(ntryL,G1H4(3),ex1(:),G1H2(12),ngH,m3h2x2(:,23),heltab2x4(:,:,23))
  call Hloop_AQ_S(ntryL,G1H4(7),ex1(:),G1H2(13),ngX,m3h2x2(:,24),heltab2x4(:,:,24))
  call Hloop_AQ_S(ntryL,G1H4(5),ex1(:),G1H2(1),ngPbt,m3h2x2(:,25),heltab2x4(:,:,25))
  call Hloop_AQ_Z(ntryL,G1H4(10),ex1(:),G1H2(2),ngZu,m3h2x2(:,26),heltab2x4(:,:,26))
  call Hloop_AQ_W(ntryL,G1H4(11),ex1(:),G1H2(3),m3h2x2(:,27),heltab2x4(:,:,27))
  call Hloop_VQ_A(ntryL,G1H4(13),ex1(:),G1H2(4),m3h2x2(:,28),heltab2x4(:,:,28))
  call Hloop_Q_A(ntryL,G1H2(4),13,nMT,G2H2(10),n2h2(18))
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(6),[G2H2(7),G2H2(5),G2H2(1)])
  call Hcheck_last_AQ_V(ntryL,l_switch,G2H2(6),ex3(:),G2tensor(2),m3h2x1(:,19),heltab2x2(:,:,19))
  call Hcheck_last_AQ_S(ntryL,l_switch,G2H2(4),ex3(:),G2tensor(10),ngH,m3h2x1(:,20),heltab2x2(:,:,20))
  call Hcheck_last_AQ_S(ntryL,l_switch,G2H2(2),ex3(:),G2tensor(12),ngX,m3h2x1(:,21),heltab2x2(:,:,21))
  call Hcheck_last_AQ_S(ntryL,l_switch,G2H2(3),ex3(:),G2tensor(17),ngPtb,m3h2x1(:,22),heltab2x2(:,:,22))
  call Hcheck_last_AQ_Z(ntryL,l_switch,G2H2(8),ex3(:),G2tensor(1),ngZd,m3h2x1(:,23),heltab2x2(:,:,23))
  call Hcheck_last_AQ_W(ntryL,l_switch,G2H2(9),ex3(:),G2tensor(6),m3h2x1(:,24),heltab2x2(:,:,24))
  call Hloop_VQ_A(ntryL,G1H2(9),ex3(:),G1H1(1),m3h2x1(:,25),heltab2x2(:,:,25))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),15,nMB,G2tensor(3),n2h1(13))
  call Hloop_QS_A(ntryL,G1H4(14),wf4(:,10),G1H1(1),ngPbt,m3h4x1(:,1),heltab2x4(:,:,29))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),15,nMB,G2tensor(4),n2h1(14))
  call Hloop_QW_A(ntryL,G1H4(16),wf4(:,12),G1H1(1),m3h4x1(:,2),heltab2x4(:,:,30))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),15,nMB,G2tensor(5),n2h1(15))
  call Hloop_VQ_A(ntryL,G1H2(10),ex3(:),G1H1(1),m3h2x1(:,26),heltab2x2(:,:,26))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),15,nMB,G2tensor(7),n2h1(16))
  call Hloop_VA_Q(ntryL,G1H2(11),ex2(:),G1H1(1),m3h2x1(:,27),heltab2x2(:,:,27))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),15,nMT,G2tensor(8),n2h1(17))
  call Hloop_SA_Q(ntryL,G1H2(12),ex2(:),G1H1(1),ngH,m3h2x1(:,28),heltab2x2(:,:,28))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),15,nMT,G2tensor(9),n2h1(18))
  call Hloop_SA_Q(ntryL,G1H2(13),ex2(:),G1H1(1),ngX,m3h2x1(:,29),heltab2x2(:,:,29))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),15,nMT,G2tensor(14),n2h1(19))
  call Hloop_SA_Q(ntryL,G1H2(1),ex2(:),G1H1(1),ngPtb,m3h2x1(:,30),heltab2x2(:,:,30))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),15,nMB,G2tensor(11),n2h1(20))
  call Hloop_ZA_Q(ntryL,G1H2(2),ex2(:),G1H1(1),ngZu,m3h2x1(:,31),heltab2x2(:,:,31))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),15,nMT,G2tensor(15),n2h1(21))
  call Hloop_WA_Q(ntryL,G1H2(3),ex2(:),G1H1(1),m3h2x1(:,32),heltab2x2(:,:,32))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),15,nMB,G2tensor(13),n2h1(22))
  call Hcheck_last_QA_V(ntryL,l_switch,G2H2(10),ex2(:),G2tensor(16),m3h2x1(:,33),heltab2x2(:,:,33))
  call ol_merge_tensors(G1tensor(2),[G0tensor(2)])
  call ol_merge_tensors(G1tensor(3),[G0tensor(3)])
  call ol_merge_tensors(G1tensor(39),[G1tensor(4),G0tensor(39),G0tensor(4)])
  call ol_merge_tensors(G1tensor(25),[G1tensor(10),G1tensor(5),G0tensor(25),G0tensor(10),G0tensor(5)])
  call ol_merge_tensors(G1tensor(7),[G0tensor(7)])
  call ol_merge_tensors(G1tensor(8),[G0tensor(8)])
  call ol_merge_tensors(G1tensor(44),[G1tensor(9),G0tensor(44),G0tensor(9)])
  call ol_merge_tensors(G1tensor(12),[G0tensor(12)])
  call ol_merge_tensors(G1tensor(67),[G1tensor(23),G1tensor(18),G1tensor(13),G0tensor(67),G0tensor(23),G0tensor(18) &
    ,G0tensor(13)])
  call ol_merge_tensors(G1tensor(29),[G1tensor(14),G0tensor(29),G0tensor(14)])
  call ol_merge_tensors(G1tensor(15),[G0tensor(15)])
  call ol_merge_tensors(G1tensor(17),[G0tensor(17)])
  call ol_merge_tensors(G1tensor(34),[G1tensor(19),G0tensor(34),G0tensor(19)])
  call ol_merge_tensors(G1tensor(20),[G0tensor(20)])
  call ol_merge_tensors(G1tensor(22),[G0tensor(22)])
  call ol_merge_tensors(G2tensor(3),[G1tensor(59),G1tensor(24),G0tensor(59),G0tensor(24)])
  call ol_merge_tensors(G1tensor(27),[G0tensor(27)])
  call ol_merge_tensors(G2tensor(7),[G1tensor(58),G1tensor(33),G1tensor(28),G0tensor(58),G0tensor(33),G0tensor(28)])
  call ol_merge_tensors(G1tensor(30),[G0tensor(30)])
  call ol_merge_tensors(G1tensor(32),[G0tensor(32)])
  call ol_merge_tensors(G1tensor(35),[G0tensor(35)])
  call ol_merge_tensors(G1tensor(37),[G0tensor(37)])
  call ol_merge_tensors(G1tensor(38),[G0tensor(38)])
  call ol_merge_tensors(G2tensor(5),[G2tensor(4),G1tensor(60),G1tensor(45),G1tensor(40),G0tensor(60),G0tensor(45),G0tensor(40)])
  call ol_merge_tensors(G1tensor(42),[G0tensor(42)])
  call ol_merge_tensors(G1tensor(43),[G0tensor(43)])
  call ol_merge_tensors(G2tensor(13),[G2tensor(11),G1tensor(47),G0tensor(47)])
  call ol_merge_tensors(G1tensor(48),[G0tensor(48)])
  call ol_merge_tensors(G2tensor(2),[G1tensor(49),G0tensor(49)])
  call ol_merge_tensors(G1tensor(65),[G1tensor(50),G0tensor(65),G0tensor(50)])
  call ol_merge_tensors(G2tensor(8),[G1tensor(52),G0tensor(52)])
  call ol_merge_tensors(G1tensor(53),[G0tensor(53)])
  call ol_merge_tensors(G2tensor(6),[G2tensor(17),G1tensor(54),G0tensor(54)])
  call ol_merge_tensors(G1tensor(70),[G1tensor(55),G0tensor(70),G0tensor(55)])
  call ol_merge_tensors(G2tensor(16),[G1tensor(57),G0tensor(57)])
  call ol_merge_tensors(G1tensor(62),[G0tensor(62)])
  call ol_merge_tensors(G1tensor(63),[G0tensor(63)])
  call ol_merge_tensors(G1tensor(64),[G0tensor(64)])
  call ol_merge_tensors(G1tensor(68),[G0tensor(68)])
  call ol_merge_tensors(G1tensor(69),[G0tensor(69)])
  call ol_merge_tensors(G2tensor(1),[G2tensor(12)])
  call ol_merge_tensors(G2tensor(15),[G2tensor(14)])
  call TI_triangle_red(G2tensor(3),RedBasis(2),mass3set(:,1),G0tensor(1),G0tensor(6),G0tensor(11),G0tensor(16),M2L1R1,[nMB], &
    G0tensor(21))
  call TI_triangle_red(G2tensor(7),RedBasis(5),mass3set(:,2),G0tensor(26),G0tensor(31),G0tensor(36),G0tensor(41),M2L1R1,[nMB,nMT], &
    G0tensor(46),G0tensor(51))
  call TI_triangle_red(G2tensor(5),RedBasis(4),mass3set(:,3),G0tensor(56),G0tensor(61),G0tensor(66),G0tensor(2),M2L1R1,[nMB,nMT], &
    G0tensor(3),G0tensor(39))
  call TI_triangle_red(G2tensor(13),RedBasis(8),mass3set(:,4),G0tensor(4),G0tensor(25),G0tensor(10),G0tensor(5),M2L1R1,[nMB,nMW], &
    G0tensor(7),G0tensor(8))
  call TI_triangle_red(G2tensor(2),RedBasis(2),mass3set(:,5),G0tensor(44),G0tensor(9),G0tensor(12),G0tensor(67),M2L1R1,[nMB], &
    G0tensor(23))
  call TI_triangle_red(G2tensor(8),RedBasis(8),mass3set(:,6),G0tensor(18),G0tensor(13),G0tensor(29),G0tensor(14),M2L1R1,[nMT], &
    G0tensor(15))
  call TI_triangle_red(G2tensor(6),RedBasis(2),mass3set(:,7),G0tensor(17),G0tensor(34),G0tensor(19),G0tensor(20),M2L1R1,[nMW,nMT], &
    G0tensor(22),G0tensor(59))
  call TI_triangle_red(G2tensor(16),RedBasis(8),mass3set(:,8),G0tensor(24),G0tensor(27),G0tensor(58),G0tensor(33),M2L1R1,[nMT], &
    G0tensor(28))
  call TI_triangle_red(G2tensor(10),RedBasis(2),mass3set(:,9),G0tensor(30),G0tensor(32),G0tensor(35), &
    G0tensor(37),M2L1R1,[nMH,nMB],G0tensor(38),G0tensor(60))
  call TI_triangle_red(G2tensor(1),RedBasis(2),mass3set(:,10),G0tensor(45),G0tensor(40),G0tensor(42), &
    G0tensor(43),M2L1R1,[nMZ,nMB],G0tensor(47),G0tensor(48))
  call TI_triangle_red(G2tensor(9),RedBasis(8),mass3set(:,11),G0tensor(49),G0tensor(65),G0tensor(50), &
    G0tensor(52),M2L1R1,[nMT,nMH],G0tensor(53),G0tensor(54))
  call TI_triangle_red(G2tensor(15),RedBasis(8),mass3set(:,12),G0tensor(70),G0tensor(55),G0tensor(57), &
    G0tensor(62),M2L1R1,[nMT,nMZ],G0tensor(63),G0tensor(64))
  call TI_triangle_red(G1tensor(2),RedBasis(9),mass3set(:,13),G0tensor(68),G0tensor(69),G0tensor(71), &
    G0tensor(72),M2L1R1,[nMH,nMT],G0tensor(73),G0tensor(74))
  call TI_triangle_red(G1tensor(3),RedBasis(3),mass3set(:,14),G0tensor(75),G0tensor(76),G0tensor(77), &
    G0tensor(78),M2L1R1,[nMB,nMT,nMH],G0tensor(79),G0tensor(80),G0tensor(81))
  call TI_triangle_red(G1tensor(39),RedBasis(2),mass3set(:,15),G0tensor(82),G0tensor(83),G0tensor(84), &
    G0tensor(85),M2L1R1,[nMB,nMH],G0tensor(86),G0tensor(87))
  call TI_triangle_red(G1tensor(25),RedBasis(1),mass3set(:,3),G0tensor(88),G0tensor(89),G0tensor(90), &
    G0tensor(91),M2L1R1,[nMB,nMT],G0tensor(92),G0tensor(93))
  call TI_triangle_red(G1tensor(7),RedBasis(9),mass3set(:,16),G0tensor(94),G0tensor(95),G0tensor(96), &
    G0tensor(97),M2L1R1,[nMZ,nMT],G0tensor(98),G0tensor(99))
  call TI_triangle_red(G1tensor(8),RedBasis(3),mass3set(:,17),G0tensor(100),G0tensor(101),G0tensor(102), &
    G0tensor(103),M2L1R1,[nMB,nMT,nMZ],G0tensor(104),G0tensor(105),G0tensor(106))
  call TI_triangle_red(G1tensor(44),RedBasis(2),mass3set(:,18),G0tensor(107),G0tensor(108),G0tensor(109), &
    G0tensor(110),M2L1R1,[nMB,nMZ],G0tensor(111),G0tensor(112))
  call TI_triangle_red(G1tensor(12),RedBasis(9),mass3set(:,19),G0tensor(113),G0tensor(114),G0tensor(115), &
    G0tensor(116),M2L1R1,[nMH,nMT],G0tensor(117),G0tensor(118))
  call TI_triangle_red(G1tensor(67),RedBasis(3),mass3set(:,2),G0tensor(119),G0tensor(120),G0tensor(121), &
    G0tensor(122),M2L1R1,[nMB,nMT],G0tensor(123),G0tensor(124))
  call TI_triangle_red(G1tensor(29),RedBasis(2),mass3set(:,20),G0tensor(125),G0tensor(126),G0tensor(127), &
    G0tensor(128),M2L1R1,[nMB,nMH],G0tensor(129),G0tensor(130))
  call TI_triangle_red(G1tensor(15),RedBasis(1),mass3set(:,21),G0tensor(131),G0tensor(132),G0tensor(133), &
    G0tensor(134),M2L1R1,[nMB,nMH,nMT],G0tensor(135),G0tensor(136),G0tensor(137))
  call TI_triangle_red(G1tensor(17),RedBasis(9),mass3set(:,22),G0tensor(138),G0tensor(139),G0tensor(140), &
    G0tensor(141),M2L1R1,[nMZ,nMT],G0tensor(142),G0tensor(143))
  call TI_triangle_red(G1tensor(34),RedBasis(2),mass3set(:,23),G0tensor(144),G0tensor(145),G0tensor(146), &
    G0tensor(147),M2L1R1,[nMB,nMZ],G0tensor(148),G0tensor(149))
  call TI_triangle_red(G1tensor(20),RedBasis(1),mass3set(:,24),G0tensor(150),G0tensor(151),G0tensor(152), &
    G0tensor(153),M2L1R1,[nMB,nMZ,nMT],G0tensor(154),G0tensor(155),G0tensor(156))
  call TI_triangle_red(G1tensor(22),RedBasis(9),mass3set(:,8),G0tensor(157),G0tensor(158),G0tensor(159), &
    G0tensor(160),M2L1R1,[nMT],G0tensor(161))
  call TI_triangle_red(G1tensor(27),RedBasis(8),mass3set(:,19),G0tensor(162),G0tensor(163),G0tensor(164), &
    G0tensor(165),M2L1R1,[nMH,nMT],G0tensor(166),G0tensor(167))
  call TI_triangle_red(G1tensor(30),RedBasis(4),mass3set(:,21),G0tensor(168),G0tensor(169),G0tensor(170), &
    G0tensor(171),M2L1R1,[nMB,nMH,nMT],G0tensor(172),G0tensor(173),G0tensor(174))
  call TI_triangle_red(G1tensor(32),RedBasis(8),mass3set(:,22),G0tensor(175),G0tensor(176),G0tensor(177), &
    G0tensor(178),M2L1R1,[nMZ,nMT],G0tensor(179),G0tensor(180))
  call TI_triangle_red(G1tensor(35),RedBasis(4),mass3set(:,24),G0tensor(181),G0tensor(182),G0tensor(183), &
    G0tensor(184),M2L1R1,[nMB,nMZ,nMT],G0tensor(185),G0tensor(186),G0tensor(187))
  call TI_triangle_red(G1tensor(37),RedBasis(8),mass3set(:,13),G0tensor(188),G0tensor(189),G0tensor(190), &
    G0tensor(191),M2L1R1,[nMH,nMT],G0tensor(192),G0tensor(193))
  call TI_triangle_red(G1tensor(38),RedBasis(5),mass3set(:,14),G0tensor(194),G0tensor(195),G0tensor(196), &
    G0tensor(197),M2L1R1,[nMB,nMT,nMH],G0tensor(198),G0tensor(199),G0tensor(200))
  call TI_triangle_red(G1tensor(42),RedBasis(8),mass3set(:,16),G0tensor(201),G0tensor(202),G0tensor(203), &
    G0tensor(204),M2L1R1,[nMZ,nMT],G0tensor(205),G0tensor(206))
  call TI_triangle_red(G1tensor(43),RedBasis(5),mass3set(:,17),G0tensor(207),G0tensor(208),G0tensor(209), &
    G0tensor(210),M2L1R1,[nMB,nMT,nMZ],G0tensor(211),G0tensor(212),G0tensor(213))
  call TI_triangle_red(G1tensor(48),RedBasis(5),mass3set(:,25),G0tensor(214),G0tensor(215),G0tensor(216), &
    G0tensor(217),M2L1R1,[nMW,nMB],G0tensor(218),G0tensor(219))
  call TI_triangle_red(G1tensor(65),RedBasis(4),mass3set(:,26),G0tensor(220),G0tensor(221),G0tensor(222), &
    G0tensor(223),M2L1R1,[nMB,nMW],G0tensor(224),G0tensor(225))
  call TI_triangle_red(G1tensor(53),RedBasis(5),mass3set(:,27),G0tensor(226),G0tensor(227),G0tensor(228), &
    G0tensor(229),M2L1R1,[nMW,nMT],G0tensor(230),G0tensor(231))
  call TI_triangle_red(G1tensor(70),RedBasis(4),mass3set(:,28),G0tensor(232),G0tensor(233),G0tensor(234), &
    G0tensor(235),M2L1R1,[nMW,nMT],G0tensor(236),G0tensor(237))
  call TI_triangle_red(G1tensor(62),RedBasis(3),mass3set(:,29),G0tensor(238),G0tensor(239),G0tensor(240), &
    G0tensor(241),M2L1R1,[nMT,nMB,nMW],G0tensor(242),G0tensor(243),G0tensor(244))
  call TI_triangle_red(G1tensor(63),RedBasis(7),mass3set(:,30),G0tensor(245),G0tensor(246),G0tensor(247), &
    G0tensor(248),M2L1R1,[nMW,nMT],G0tensor(249),G0tensor(250))
  call TI_triangle_red(G1tensor(64),RedBasis(6),mass3set(:,31),G0tensor(251),G0tensor(252),G0tensor(253), &
    G0tensor(254),M2L1R1,[nMB,nMT],G0tensor(255),G0tensor(256))
  call TI_triangle_red(G1tensor(68),RedBasis(7),mass3set(:,32),G0tensor(257),G0tensor(258),G0tensor(259), &
    G0tensor(260),M2L1R1,[nMW,nMB],G0tensor(261),G0tensor(262))
  call TI_triangle_red(G1tensor(69),RedBasis(6),mass3set(:,33),G0tensor(263),G0tensor(264),G0tensor(265), &
    G0tensor(266),M2L1R1,[nMW,nMT,nMB],G0tensor(267),G0tensor(268),G0tensor(269))
  call ol_merge_tensors(T0sum(15),[G0tensor(68)])
  call ol_merge_tensors(T0sum(16),[G0tensor(75)])
  call ol_merge_tensors(T0sum(17),[G0tensor(82)])
  call ol_merge_tensors(T0sum(18),[G0tensor(88)])
  call ol_merge_tensors(T0sum(19),[G0tensor(94)])
  call ol_merge_tensors(T0sum(20),[G0tensor(100)])
  call ol_merge_tensors(T0sum(21),[G0tensor(107)])
  call ol_merge_tensors(T0sum(22),[G0tensor(113)])
  call ol_merge_tensors(T0sum(23),[G0tensor(119)])
  call ol_merge_tensors(T0sum(24),[G0tensor(125)])
  call ol_merge_tensors(T0sum(25),[G0tensor(131)])
  call ol_merge_tensors(T0sum(26),[G0tensor(138)])
  call ol_merge_tensors(T0sum(27),[G0tensor(144)])
  call ol_merge_tensors(T0sum(28),[G0tensor(150)])
  call ol_merge_tensors(T0sum(29),[G0tensor(157)])
  call ol_merge_tensors(T0sum(30),[G0tensor(1)])
  call ol_merge_tensors(T0sum(31),[G0tensor(162)])
  call ol_merge_tensors(T0sum(32),[G0tensor(26)])
  call ol_merge_tensors(T0sum(33),[G0tensor(168)])
  call ol_merge_tensors(T0sum(34),[G0tensor(175)])
  call ol_merge_tensors(T0sum(35),[G0tensor(181)])
  call ol_merge_tensors(T0sum(36),[G0tensor(188)])
  call ol_merge_tensors(T0sum(37),[G0tensor(194)])
  call ol_merge_tensors(T0sum(38),[G0tensor(56)])
  call ol_merge_tensors(T0sum(39),[G0tensor(201)])
  call ol_merge_tensors(T0sum(40),[G0tensor(207)])
  call ol_merge_tensors(T0sum(41),[G0tensor(4)])
  call ol_merge_tensors(T0sum(42),[G0tensor(214)])
  call ol_merge_tensors(T0sum(43),[G0tensor(44)])
  call ol_merge_tensors(T0sum(44),[G0tensor(220)])
  call ol_merge_tensors(T0sum(45),[G0tensor(18)])
  call ol_merge_tensors(T0sum(46),[G0tensor(226)])
  call ol_merge_tensors(T0sum(47),[G0tensor(17)])
  call ol_merge_tensors(T0sum(48),[G0tensor(232)])
  call ol_merge_tensors(T0sum(49),[G0tensor(24)])
  call ol_merge_tensors(T0sum(50),[G0tensor(238)])
  call ol_merge_tensors(T0sum(51),[G0tensor(245)])
  call ol_merge_tensors(T0sum(52),[G0tensor(251)])
  call ol_merge_tensors(T0sum(53),[G0tensor(257)])
  call ol_merge_tensors(T0sum(54),[G0tensor(263)])
  call ol_merge_tensors(T0sum(55),[G0tensor(30)])
  call ol_merge_tensors(T0sum(56),[G0tensor(45)])
  call ol_merge_tensors(T0sum(57),[G0tensor(49)])
  call ol_merge_tensors(T0sum(58),[G0tensor(70)])
  Gcoeff(:)%j = (-(c(38)*M(2,:)%j)+c(37)*M(4,:)%j) * den(9)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(55),h0tab(:,55),[12,3],[0,0],2,2,wf4(:,6),wf4(:,5))
  call Hloop_QV_A(ntryL,G0H16(1),wf4(:,6),G0H4(1),m3h4x4(:,15),heltab2x16(:,:,55))
  call Hloop_Q_A(ntryL,G0H4(1),12,0,G1H4(17),n2h4(30))
  Gcoeff(:)%j = (-(c(36)*M(2,:)%j)+c(35)*M(4,:)%j) * den(9)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(56),h0tab(:,56),[12,3],[nMT,nMT],2,2,wf4(:,6),wf4(:,5))
  call Hloop_QV_A(ntryL,G0H16(1),wf4(:,6),G0H4(1),m3h4x4(:,16),heltab2x16(:,:,56))
  call Hloop_Q_A(ntryL,G0H4(1),12,nMT,G1H4(18),n2h4(31))
  Gcoeff(:)%j = (-(c(38)*M(2,:)%j)+c(37)*M(4,:)%j) * den(9)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(57),h0tab(:,57),[12,3],[0,0],2,2,wf4(:,6),wf4(:,5))
  call Hloop_QV_A(ntryL,G0H16(1),wf4(:,6),G0H4(1),m3h4x4(:,17),heltab2x16(:,:,57))
  call Hloop_Q_A(ntryL,G0H4(1),12,0,G1H4(19),n2h4(32))
  Gcoeff(:)%j = (-(c(36)*M(2,:)%j)+c(35)*M(4,:)%j) * den(9)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(58),h0tab(:,58),[12,3],[nMB,nMB],2,2,wf4(:,6),wf4(:,5))
  call Hloop_QV_A(ntryL,G0H16(1),wf4(:,6),G0H4(1),m3h4x4(:,18),heltab2x16(:,:,58))
  call Hloop_Q_A(ntryL,G0H4(1),12,nMB,G1H4(20),n2h4(33))
  Gcoeff(:)%j = (-(c(21)*M(2,:)%j)+c(19)*M(4,:)%j) * den(9)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(59),h0tab(:,59),[12,3],[0,0],2,2,wf4(:,6),wf4(:,5))
  call Hloop_CV_D(ntryL,G0H16(1),0,wf4(:,6),12,G1H4(21),m3h4x4(:,19),heltab2x16(:,:,59))
  Gcoeff(:)%j = (c(14)*M(2,:)%j-c(13)*M(4,:)%j) * den(9)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(60),h0tab(:,60),[12,3],[0,0],2,2,wf4(:,6),wf4(:,5))
  call Hloop_UV_W(ntryL,G0H16(1),0,wf4(:,6),12,G1H4(22),m3h4x4(:,20),heltab2x16(:,:,60))
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(19),[G1H4(17)])
  call Hloop_QV_A(ntryL,G1H4(19),wf4(:,5),G1H1(1),m3h4x1(:,3),heltab2x4(:,:,31))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),15,0,G2tensor(18),n2h1(23))
  call Hloop_QV_A(ntryL,G1H4(18),wf4(:,5),G1H1(1),m3h4x1(:,4),heltab2x4(:,:,32))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),15,nMT,G2tensor(4),n2h1(24))
  call Hloop_QV_A(ntryL,G1H4(20),wf4(:,5),G1H1(1),m3h4x1(:,5),heltab2x4(:,:,33))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),15,nMB,G2tensor(11),n2h1(25))
  call Hcheck_last_CV_D(ntryL,l_switch,G1H4(21),12,wf4(:,5),3,G2tensor(17),m3h4x1(:,6),heltab2x4(:,:,34))
  call Hcheck_last_UV_W(ntryL,l_switch,G1H4(22),12,wf4(:,5),3,G2tensor(12),m3h4x1(:,7),heltab2x4(:,:,35))
  call ol_merge_tensors(G2tensor(12),[G2tensor(17),G2tensor(18),G0tensor(160),G0tensor(33),G0tensor(6)])
  call ol_merge_tensors(G0tensor(258),[G0tensor(146),G0tensor(127),G0tensor(121),G0tensor(36),G0tensor(11)])
  call ol_merge_tensors(G0tensor(110),[G0tensor(91),G0tensor(85),G0tensor(2),G0tensor(16)])
  call ol_merge_tensors(G0tensor(269),[G0tensor(262),G0tensor(255),G0tensor(243),G0tensor(224),G0tensor(219),G0tensor(211) &
    ,G0tensor(198),G0tensor(185),G0tensor(172),G0tensor(154),G0tensor(148),G0tensor(135),G0tensor(129),G0tensor(123),G0tensor(111) &
    ,G0tensor(104),G0tensor(92),G0tensor(86),G0tensor(79),G0tensor(48),G0tensor(60),G0tensor(23),G0tensor(7),G0tensor(3) &
    ,G0tensor(46),G0tensor(21)])
  call ol_merge_tensors(G0tensor(253),[G0tensor(247),G0tensor(177),G0tensor(164),G0tensor(58),G0tensor(31)])
  call ol_merge_tensors(G0tensor(210),[G0tensor(197),G0tensor(183),G0tensor(170),G0tensor(66),G0tensor(41)])
  call ol_merge_tensors(G0tensor(268),[G0tensor(256),G0tensor(250),G0tensor(242),G0tensor(237),G0tensor(231),G0tensor(212) &
    ,G0tensor(206),G0tensor(199),G0tensor(193),G0tensor(187),G0tensor(180),G0tensor(174),G0tensor(167),G0tensor(161),G0tensor(156) &
    ,G0tensor(143),G0tensor(137),G0tensor(124),G0tensor(118),G0tensor(105),G0tensor(99),G0tensor(93),G0tensor(80),G0tensor(74) &
    ,G0tensor(63),G0tensor(53),G0tensor(28),G0tensor(59),G0tensor(15),G0tensor(39),G0tensor(51)])
  call ol_merge_tensors(G0tensor(202),[G0tensor(189),G0tensor(27),G0tensor(61)])
  call ol_merge_tensors(G0tensor(239),[G0tensor(221),G0tensor(25)])
  call ol_merge_tensors(G0tensor(215),[G0tensor(10)])
  call ol_merge_tensors(G2tensor(11),[G0tensor(40),G0tensor(32),G0tensor(9),G0tensor(5)])
  call ol_merge_tensors(G0tensor(267),[G0tensor(261),G0tensor(249),G0tensor(244),G0tensor(236),G0tensor(230),G0tensor(225) &
    ,G0tensor(218),G0tensor(22),G0tensor(8)])
  call ol_merge_tensors(G0tensor(216),[G0tensor(12)])
  call ol_merge_tensors(G0tensor(254),[G0tensor(223),G0tensor(67)])
  call ol_merge_tensors(G0tensor(233),[G0tensor(159),G0tensor(140),G0tensor(120),G0tensor(115),G0tensor(13)])
  call ol_merge_tensors(G0tensor(227),[G0tensor(158),G0tensor(95),G0tensor(89),G0tensor(69),G0tensor(29)])
  call ol_merge_tensors(G2tensor(4),[G0tensor(62),G0tensor(52),G0tensor(34),G0tensor(14)])
  call ol_merge_tensors(G0tensor(228),[G0tensor(19)])
  call ol_merge_tensors(G0tensor(266),[G0tensor(235),G0tensor(20)])
  call ol_merge_tensors(G0tensor(200),[G0tensor(192),G0tensor(173),G0tensor(166),G0tensor(136),G0tensor(130),G0tensor(117) &
    ,G0tensor(87),G0tensor(81),G0tensor(73),G0tensor(54),G0tensor(38)])
  call ol_merge_tensors(G0tensor(213),[G0tensor(205),G0tensor(186),G0tensor(179),G0tensor(155),G0tensor(149),G0tensor(142) &
    ,G0tensor(112),G0tensor(106),G0tensor(98),G0tensor(64),G0tensor(47)])
  call ol_merge_tensors(G0tensor(76),[G0tensor(71),G0tensor(65)])
  call ol_merge_tensors(G0tensor(132),[G0tensor(114),G0tensor(50)])
  call ol_merge_tensors(G0tensor(101),[G0tensor(96),G0tensor(55)])
  call ol_merge_tensors(G0tensor(151),[G0tensor(139),G0tensor(57)])
  call ol_merge_tensors(G0tensor(191),[G0tensor(83),G0tensor(72)])
  call ol_merge_tensors(G0tensor(196),[G0tensor(84),G0tensor(77)])
  call ol_merge_tensors(G0tensor(264),[G0tensor(152),G0tensor(133),G0tensor(122),G0tensor(103),G0tensor(90),G0tensor(78)])
  call ol_merge_tensors(G0tensor(204),[G0tensor(108),G0tensor(97)])
  call ol_merge_tensors(G0tensor(209),[G0tensor(109),G0tensor(102)])
  call ol_merge_tensors(G0tensor(165),[G0tensor(126),G0tensor(116)])
  call ol_merge_tensors(G0tensor(171),[G0tensor(134),G0tensor(128)])
  call ol_merge_tensors(G0tensor(178),[G0tensor(145),G0tensor(141)])
  call ol_merge_tensors(G0tensor(184),[G0tensor(153),G0tensor(147)])
  call ol_merge_tensors(G0tensor(169),[G0tensor(163)])
  call ol_merge_tensors(G0tensor(182),[G0tensor(176)])
  call ol_merge_tensors(G0tensor(195),[G0tensor(190)])
  call ol_merge_tensors(G0tensor(208),[G0tensor(203)])
  call ol_merge_tensors(G0tensor(248),[G0tensor(222),G0tensor(217)])
  call ol_merge_tensors(G0tensor(260),[G0tensor(234),G0tensor(229)])
  call ol_merge_tensors(G0tensor(246),[G0tensor(240)])
  call ol_merge_tensors(G0tensor(252),[G0tensor(241)])
  call ol_merge_tensors(G0tensor(265),[G0tensor(259)])
call TI_bubble_red(G2tensor(12),12,mass2set(:,1),G0tensor(68),M2L1R1)
call TI_bubble_red(G2tensor(11),12,mass2set(:,2),G0tensor(75),M2L1R1,G0tensor(82))
call TI_bubble_red(G2tensor(4),12,mass2set(:,3),G0tensor(88),M2L1R1,G0tensor(94))
  call ol_merge_tensors(G0tensor(82),[G0tensor(269)])
  call ol_merge_tensors(G0tensor(94),[G0tensor(268)])
  call ol_merge_tensors(T0sum(59),[G0tensor(68)])
  call ol_merge_tensors(T0sum(60),[G0tensor(258)])
  call ol_merge_tensors(T0sum(61),[G0tensor(110)])
  call ol_merge_tensors(T0sum(62),[G0tensor(82)])
  call ol_merge_tensors(T0sum(63),[G0tensor(253)])
  call ol_merge_tensors(T0sum(64),[G0tensor(210)])
  call ol_merge_tensors(T0sum(65),[G0tensor(94)])
  call ol_merge_tensors(T0sum(66),[G0tensor(202)])
  call ol_merge_tensors(T0sum(67),[G0tensor(239)])
  call ol_merge_tensors(T0sum(68),[G0tensor(215)])
  call ol_merge_tensors(T0sum(69),[G0tensor(75)])
  call ol_merge_tensors(T0sum(70),[G0tensor(267)])
  call ol_merge_tensors(T0sum(71),[G0tensor(216)])
  call ol_merge_tensors(T0sum(72),[G0tensor(254)])
  call ol_merge_tensors(T0sum(73),[G0tensor(233)])
  call ol_merge_tensors(T0sum(74),[G0tensor(227)])
  call ol_merge_tensors(T0sum(75),[G0tensor(88)])
  call ol_merge_tensors(T0sum(76),[G0tensor(228)])
  call ol_merge_tensors(T0sum(77),[G0tensor(266)])
  call ol_merge_tensors(T0sum(78),[G0tensor(35)])
  call ol_merge_tensors(T0sum(79),[G0tensor(37)])
  call ol_merge_tensors(T0sum(80),[G0tensor(200)])
  call ol_merge_tensors(T0sum(81),[G0tensor(42)])
  call ol_merge_tensors(T0sum(82),[G0tensor(43)])
  call ol_merge_tensors(T0sum(83),[G0tensor(213)])
  call ol_merge_tensors(T0sum(84),[G0tensor(76)])
  call ol_merge_tensors(T0sum(85),[G0tensor(132)])
  call ol_merge_tensors(T0sum(86),[G0tensor(101)])
  call ol_merge_tensors(T0sum(87),[G0tensor(151)])
  call ol_merge_tensors(T0sum(88),[G0tensor(191)])
  call ol_merge_tensors(T0sum(89),[G0tensor(196)])
  call ol_merge_tensors(T0sum(90),[G0tensor(264)])
  call ol_merge_tensors(T0sum(91),[G0tensor(204)])
  call ol_merge_tensors(T0sum(92),[G0tensor(209)])
  call ol_merge_tensors(T0sum(93),[G0tensor(165)])
  call ol_merge_tensors(T0sum(94),[G0tensor(171)])
  call ol_merge_tensors(T0sum(95),[G0tensor(178)])
  call ol_merge_tensors(T0sum(96),[G0tensor(184)])
  call ol_merge_tensors(T0sum(97),[G0tensor(169)])
  call ol_merge_tensors(T0sum(98),[G0tensor(182)])
  call ol_merge_tensors(T0sum(99),[G0tensor(195)])
  call ol_merge_tensors(T0sum(100),[G0tensor(208)])
  call ol_merge_tensors(T0sum(101),[G0tensor(248)])
  call ol_merge_tensors(T0sum(102),[G0tensor(260)])
  call ol_merge_tensors(T0sum(103),[G0tensor(246)])
  call ol_merge_tensors(T0sum(104),[G0tensor(252)])
  call ol_merge_tensors(T0sum(105),[G0tensor(265)])
! end of process


end subroutine vamp_1

end module ol_vamp_1_pptt_ew_ttxbbx_1_/**/REALKIND
