
module ol_colourmatrix_pptt_ew_ttxbbx_3_/**/REALKIND
  use KIND_TYPES, only: REALKIND
  implicit none
  logical, save           :: colmat_not_initialised = .true.
  complex(REALKIND), save :: K1(48,4), K2(4,4), KL(4,4), Cas(4) = 0
  contains
  subroutine colourmatrix_init
    use ol_parameters_decl_/**/REALKIND, only: CI
    implicit none
    integer :: k, co
    colmat_not_initialised = .false.
    ! colour matrix

  K1( 1,:) = [   0,   0,   0,   0]
  K1( 2,:) = [   0,   9,   3,   0]
  K1( 3,:) = [   0,   3,   9,   0]
  K1( 4,:) = [   0,   0,   0,   0]
  K1( 5,:) = [   0,   0,   0,   0]
  K1( 6,:) = [   0,  12,   4,   0]
  K1( 7,:) = [   0,   4,  12,   0]
  K1( 8,:) = [   0,   0,   0,   0]
  K1( 9,:) = [   0,   0,   0,   0]
  K1(10,:) = [   0,   0,  -4,   0]
  K1(11,:) = [   0,  -4, -12,   0]
  K1(12,:) = [   0,   0,   0,   0]
  K1(13,:) = [   0,   0,   0,   0]
  K1(14,:) = [   0,  12,   4,   0]
  K1(15,:) = [   0,   4,  12,   0]
  K1(16,:) = [   0,   0,   0,   0]
  K1(17,:) = [   0,   0,   0,   0]
  K1(18,:) = [   0,   0,   4,   0]
  K1(19,:) = [   0,   4,   0,   0]
  K1(20,:) = [   0,   0,   0,   0]
  K1(21,:) = [   0,   0,   0,   0]
  K1(22,:) = [   0, -12,  -4,   0]
  K1(23,:) = [   0,  -4,   0,   0]
  K1(24,:) = [   0,   0,   0,   0]
  K1(25,:) = [   0,   0,   0,   0]
  K1(26,:) = [   0,  12,   4,   0]
  K1(27,:) = [   0,   4,  12,   0]
  K1(28,:) = [   0,   0,   0,   0]
  K1(29,:) = [   0,   0,   0,   0]
  K1(30,:) = [   0, -12,  -4,   0]
  K1(31,:) = [   0,  -4,   0,   0]
  K1(32,:) = [   0,   0,   0,   0]
  K1(33,:) = [   0,   0,   0,   0]
  K1(34,:) = [   0,   0,   4,   0]
  K1(35,:) = [   0,   4,   0,   0]
  K1(36,:) = [   0,   0,   0,   0]
  K1(37,:) = [   0,   0,   0,   0]
  K1(38,:) = [   0,   0,  -4,   0]
  K1(39,:) = [   0,  -4, -12,   0]
  K1(40,:) = [   0,   0,   0,   0]
  K1(41,:) = [   0,   0,   0,   0]
  K1(42,:) = [   0,  12,   4,   0]
  K1(43,:) = [   0,   4,  12,   0]
  K1(44,:) = [   0,   0,   0,   0]
  K1(45,:) = [   0,   9,   3,   0]
  K1(46,:) = [   9,   0,   0,   3]
  K1(47,:) = [   3,   0,   0,   9]
  K1(48,:) = [   0,   3,   9,   0]

  K2(1,:) = [ 0, 9, 0, 3]
  K2(2,:) = [ 9, 0, 3, 0]
  K2(3,:) = [ 3, 0, 9, 0]
  K2(4,:) = [ 0, 3, 0, 9]

  KL(1,:) = [ 0, 9, 0, 3]
  KL(2,:) = [ 9, 0, 3, 0]
  KL(3,:) = [ 3, 0, 9, 0]
  KL(4,:) = [ 0, 3, 0, 9]

#if 1 > 0
    co = 0
    do k = 1, 4
      co = co + k
      Cas(k) = K1(1+4*co,1)/K1(1,1)
    end do
#endif
  end subroutine colourmatrix_init
end module ol_colourmatrix_pptt_ew_ttxbbx_3_/**/REALKIND



module ol_forced_parameters_pptt_ew_ttxbbx_3_/**/REALKIND
  implicit none
  contains
  subroutine check_forced_parameters
    use ol_parameters_decl_/**/REALKIND
    use ol_loop_parameters_decl_/**/REALKIND
#ifndef PRECISION_dp
    use ol_loop_parameters_decl_/**/DREALKIND, only: LeadingColour, nc, nf, CKMORDER
#endif
    implicit none
    logical, save :: checks_not_written = .true.

    if (checks_not_written) then
    ! e.g.
    ! if (ME /= 0) write(*,101) 'ME = 0'
  if (CKMORDER /= 0) write(*,101) 'CKMORDER = 0'
  if (nc /= 3) write(*,101) 'nc = 3'
  if (nf /= 6) write(*,101) 'nf = 6'
  if (MU /= 0) write(*,101) 'MU = 0'
  if (MD /= 0) write(*,101) 'MD = 0'
  if (MS /= 0) write(*,101) 'MS = 0'
  if (MC /= 0) write(*,101) 'MC = 0'
  if (LeadingColour /= 0) write(*,101) 'LeadingColour = 0'
  if (wMT /= 0) write(*,101) 'wMT = 0'
  if (wMT /= 0) write(*,101) 'wMT = 0'
  if (wMB /= 0) write(*,101) 'wMB = 0'
  if (wMB /= 0) write(*,101) 'wMB = 0'


    checks_not_written = .false.
    end if

    101 format('[OpenLoops] === WARNING ===',/,'[OpenLoops] code was generated with ',A,/,'[OpenLoops] ===============')
  end subroutine check_forced_parameters
end module ol_forced_parameters_pptt_ew_ttxbbx_3_/**/REALKIND


! **********************************************************************
module ol_loop_storage_pptt_ew_ttxbbx_3_/**/REALKIND
! **********************************************************************
  use KIND_TYPES, only: REALKIND, intkind1, intkind2
  use ol_data_types_/**/REALKIND, only: wfun, Hpolcont

#ifdef PRECISION_dp
  integer(intkind1), save :: ntryL = 1
  integer(intkind1), save :: p_switch = 0 ! switch for dp or qp. Used for memory allocation of the OL types
  ! the following are flags for memory allocation of the hol coefficients in dp or qp
  logical, save :: dp_not_alloc = .TRUE., qp_not_alloc = .TRUE.
  integer, save :: n_merge_steps  ! total number of merging steps
  integer, save :: n_merge_mism   ! number of merging mismatches
  integer, save :: merge_step = 1 ! current merging step
  integer(intkind2), save, allocatable :: merge_tables(:,:,:) ! merging tables
  integer(intkind2), save, allocatable :: merge_mism(:)       ! array of merging mismatches
  integer(intkind2), save, allocatable :: merge_hels(:)       ! array with relevant helicities for a merging step
  logical, save :: merge_tables_on = .false.
  integer(intkind2), parameter :: nheltot = 16 ! number of helicity configurations
  integer(intkind2), save :: nhel = 16 ! number of non-vanishing helicity configurations (adapted at runtime)
  integer(intkind2), save :: Hel(16) ! physical helicity states
#endif

  complex(REALKIND), save :: den(18)

  ! external wave functions ex1(h1),... for h<n> helicities
  type(wfun) :: ex1(2), ex2(2), ex3(2), ex4(2)

  ! wf<h>(h,n) n wave functions with h helicity configurations
  type(wfun) :: wf4(4,50), wf16(16,47)

  ! diagram prefactors
  integer,           save :: fac_status_loop1 = -1, fac_status_loop2 = -1
  complex(REALKIND), save :: f(197), c(182)

  !Vector in helicity and colour space for Born-Loop interference
  type(Hpolcont),   save :: M0_col1_helarray(4,16), M0M1_hel_cc(4,16,11)
  complex(REALKIND), save :: M2ctcc(11)

end module ol_loop_storage_pptt_ew_ttxbbx_3_/**/REALKIND






! **********************************************************************
module ol_loop_pptt_ew_ttxbbx_3_/**/REALKIND
! **********************************************************************
  use KIND_TYPES, only: REALKIND, DREALKIND, intkind1, intkind2
  use ol_data_types_/**/REALKIND, only: wfun, Hpolcont
  use ol_loop_storage_pptt_ew_ttxbbx_3_/**/REALKIND
  implicit none

!*********************************************************************************
  contains

! **********************************************************************
subroutine fac_init_loop()
! Writes diagram prefactors to 'f', rsp. 'c'
! **********************************************************************
  use ol_parameters_decl_/**/REALKIND
  use ol_loop_parameters_decl_/**/REALKIND
  use ol_init, only: set_parameter, tree_parameters_flush, parameters_flush
#ifndef PRECISION_dp
  use ol_loop_parameters_decl_/**/DREALKIND, only: SwF, SwB
!  use ol_loop_parameters_decl_/**/DREALKIND, only: DOI
#endif
  implicit none
  call set_parameter("ew_renorm", 1)
  if (parameters_status == 0) call tree_parameters_flush()
  if (loop_parameters_status == 0) call parameters_flush()
  fac_status_loop1 = parameters_status
  fac_status_loop2 = loop_parameters_status
  ! factors of the diagrams
    f(  1) = (2*CI*eQED**2)/9._/**/REALKIND
    f(  2) = CI*eQED**2
    f(  3) = (2*CI*countertermnorm*eQED**4)/9._/**/REALKIND
    f(  4) = (CI*countertermnorm*eQED**4)/3._/**/REALKIND
    f(  5) = (2*CI*countertermnorm*eQED**4)/3._/**/REALKIND
    f(  6) = CI*countertermnorm*eQED**4
    f(  7) = CI*gQCD**2
    f(  8) = CI*countertermnorm*eQED**2*gQCD**2
    f(  9) = (2*CI*countertermnorm*ctVbb*eQED**2*gQCD**2)/9._/**/REALKIND
    f( 10) = CI*countertermnorm*ctVbb*eQED**2*gQCD**2
    f( 11) = (2*CI*countertermnorm*ctVtt*eQED**2*gQCD**2)/9._/**/REALKIND
    f( 12) = CI*countertermnorm*ctVtt*eQED**2*gQCD**2
    f( 13) = (CI*eQED**2)/(2._/**/REALKIND*sw**2)
    f( 14) = (CI*countertermnorm*eQED**4)/(2._/**/REALKIND*sw**2)
    f( 15) = (CI*countertermnorm*eQED**4*EWctVbt)/(2._/**/REALKIND*sw**2)
    f( 16) = (CI*countertermnorm*eQED**4*EWctVtb)/(2._/**/REALKIND*sw**2)
    f( 17) = (CI*countertermnorm*ctVbt*eQED**2*gQCD**2)/(2._/**/REALKIND*sw**2)
    f( 18) = (CI*eQED**2)/(2._/**/REALKIND*MW**2*sw**2)
    f( 19) = (CI*countertermnorm*eQED**4)/(2._/**/REALKIND*MW**2*sw**2)
    f( 20) = (CI*countertermnorm*eQED**2*gQCD**2)/(2._/**/REALKIND*MW**2*sw**2)
    f( 21) = (CI*eQED**2*MB*MT)/(4._/**/REALKIND*MW**2*sw**2)
    f( 22) = (CI*countertermnorm*eQED**4*MB*MT)/(4._/**/REALKIND*MW**2*sw**2)
    f( 23) = (CI*countertermnorm*ctSbb*eQED**2*gQCD**2*MB*MT)/(4._/**/REALKIND*MW**2*sw**2)
    f( 24) = (CI*countertermnorm*ctStt*eQED**2*gQCD**2*MB*MT)/(4._/**/REALKIND*MW**2*sw**2)
    f( 25) = (CI*countertermnorm*eQED**4)/(2._/**/REALKIND*MW*sw**2)
    f( 26) = (CI*countertermnorm*eQED**4*MB*MT)/(2._/**/REALKIND*MW**2*sw)
    f( 27) = (countertermnorm*eQED**4*MB*MT)/(MW**2*sw*2._/**/REALKIND)
    f( 28) = (countertermnorm*eQED**4*MB)/(MW*sw*3._/**/REALKIND)
    f( 29) = (countertermnorm*eQED**4*MB)/(MW*sw*2._/**/REALKIND)
    f( 30) = (countertermnorm*eQED**4*MT)/(MW*sw*6._/**/REALKIND)
    f( 31) = (countertermnorm*eQED**4*MT)/(MW*sw*2._/**/REALKIND)
    f( 32) = (CI*countertermnorm*eQED**4)/(MW**2*sqrt2*sw)
    f( 33) = (2*eQED**4*integralnorm*SwB)/81._/**/REALKIND
    f( 34) = (4*eQED**4*integralnorm*SwB)/81._/**/REALKIND
    f( 35) = (8*eQED**4*integralnorm*SwB)/81._/**/REALKIND
    f( 36) = (eQED**4*integralnorm*SwB)/9._/**/REALKIND
    f( 37) = (2*eQED**4*integralnorm*SwB)/9._/**/REALKIND
    f( 38) = (4*eQED**4*integralnorm*SwB)/9._/**/REALKIND
    f( 39) = eQED**4*integralnorm*SwB
    f( 40) = (eQED**4*integralnorm*SwB)/(cw**2*2._/**/REALKIND)
    f( 41) = (eQED**2*gQCD**2*integralnorm*SwB)/9._/**/REALKIND
    f( 42) = (2*eQED**2*gQCD**2*integralnorm*SwB)/9._/**/REALKIND
    f( 43) = (4*eQED**2*gQCD**2*integralnorm*SwB)/9._/**/REALKIND
    f( 44) = eQED**2*gQCD**2*integralnorm*SwB
    f( 45) = (2*eQED**4*integralnorm*MW**2*SwB)/9._/**/REALKIND
    f( 46) = (eQED**4*integralnorm*MW**2*SwB)/(cw**2*2._/**/REALKIND)
    f( 47) = (eQED**4*integralnorm*SwB)/(sw**4*8._/**/REALKIND)
    f( 48) = (eQED**4*integralnorm*SwB)/(sw**4*4._/**/REALKIND)
    f( 49) = (cw**2*eQED**4*integralnorm*SwB)/(sw**4*2._/**/REALKIND)
    f( 50) = (eQED**4*integralnorm*MB*SwB)/(sw**4*4._/**/REALKIND)
    f( 51) = (eQED**4*integralnorm*MT*SwB)/(sw**4*4._/**/REALKIND)
    f( 52) = (eQED**4*integralnorm*MB*MT*SwB)/(sw**4*16._/**/REALKIND)
    f( 53) = (eQED**4*integralnorm*MB*MT*SwB)/(sw**4*4._/**/REALKIND)
    f( 54) = (eQED**4*integralnorm*MB*MT*SwB)/(cw**4*sw**4*16._/**/REALKIND)
    f( 55) = (eQED**4*integralnorm*MB*MT*SwB)/(cw**4*sw**4*8._/**/REALKIND)
    f( 56) = (eQED**4*integralnorm*SwB)/(MW**4*sw**4*4._/**/REALKIND)
    f( 57) = (eQED**4*integralnorm*MB**2*SwB)/(MW**4*sw**4*8._/**/REALKIND)
    f( 58) = (eQED**4*integralnorm*MB*MH**2*SwB)/(MW**4*sw**4*8._/**/REALKIND)
    f( 59) = (eQED**4*integralnorm*MH**4*SwB)/(MW**4*sw**4*8._/**/REALKIND)
    f( 60) = (eQED**4*integralnorm*MB*MT*SwB)/(MW**4*sw**4*8._/**/REALKIND)
    f( 61) = (eQED**4*integralnorm*MB**3*MT*SwB)/(MW**4*sw**4*16._/**/REALKIND)
    f( 62) = (eQED**4*integralnorm*MH**2*MT*SwB)/(MW**4*sw**4*8._/**/REALKIND)
    f( 63) = (eQED**4*integralnorm*MB**2*MH**2*MT*SwB)/(MW**4*sw**4*16._/**/REALKIND)
    f( 64) = (3*eQED**4*integralnorm*lambdaHHH*MB**2*MH**2*MT*SwB)/(MW**4*sw**4*16._/**/REALKIND)
    f( 65) = (eQED**4*integralnorm*MB*MH**4*MT*SwB)/(MW**4*sw**4*32._/**/REALKIND)
    f( 66) = (eQED**4*integralnorm*MB*MH**4*MT*SwB)/(MW**4*sw**4*16._/**/REALKIND)
    f( 67) = (9*eQED**4*integralnorm*lambdaHHH**2*MB*MH**4*MT*SwB)/(MW**4*sw**4*32._/**/REALKIND)
    f( 68) = (eQED**4*integralnorm*MT**2*SwB)/(MW**4*sw**4*8._/**/REALKIND)
    f( 69) = (eQED**4*integralnorm*MB**2*MT**2*SwB)/(MW**4*sw**4*16._/**/REALKIND)
    f( 70) = (eQED**4*integralnorm*MB*MH**2*MT**2*SwB)/(MW**4*sw**4*16._/**/REALKIND)
    f( 71) = (3*eQED**4*integralnorm*lambdaHHH*MB*MH**2*MT**2*SwB)/(MW**4*sw**4*16._/**/REALKIND)
    f( 72) = (eQED**4*integralnorm*MB*MT**3*SwB)/(MW**4*sw**4*16._/**/REALKIND)
    f( 73) = (eQED**4*integralnorm*SwB)/(MW**2*sw**4*8._/**/REALKIND)
    f( 74) = (eQED**4*integralnorm*SwB)/(MW**2*sw**4*4._/**/REALKIND)
    f( 75) = (eQED**4*integralnorm*MB*SwB)/(MW**2*sw**4*8._/**/REALKIND)
    f( 76) = (eQED**4*integralnorm*MB**2*SwB)/(MW**2*sw**4*8._/**/REALKIND)
    f( 77) = (eQED**4*integralnorm*MH**2*SwB)/(MW**2*sw**4*8._/**/REALKIND)
    f( 78) = (eQED**4*integralnorm*MT*SwB)/(MW**2*sw**4*8._/**/REALKIND)
    f( 79) = (eQED**4*integralnorm*MB*MT*SwB)/(MW**2*sw**4*16._/**/REALKIND)
    f( 80) = (eQED**4*integralnorm*MB*MT*SwB)/(MW**2*sw**4*8._/**/REALKIND)
    f( 81) = (eQED**4*integralnorm*MB*MT*SwB)/(cw**2*MW**2*sw**4*16._/**/REALKIND)
    f( 82) = (eQED**4*integralnorm*MT**2*SwB)/(MW**2*sw**4*8._/**/REALKIND)
    f( 83) = (eQED**4*integralnorm*MW**2*SwB)/(sw**4*2._/**/REALKIND)
    f( 84) = (cw*eQED**4*integralnorm*SwB)/(sw**3*2._/**/REALKIND)
    f( 85) = (eQED**4*integralnorm*MB*SwB)/(cw**3*sw**3*4._/**/REALKIND)
    f( 86) = (cw*eQED**4*integralnorm*MB*SwB)/(sw**3*4._/**/REALKIND)
    f( 87) = (cw*eQED**4*integralnorm*MB*SwB)/(sw**3*2._/**/REALKIND)
    f( 88) = (eQED**4*integralnorm*MT*SwB)/(cw**3*sw**3*4._/**/REALKIND)
    f( 89) = (cw*eQED**4*integralnorm*MT*SwB)/(sw**3*4._/**/REALKIND)
    f( 90) = (cw*eQED**4*integralnorm*MT*SwB)/(sw**3*2._/**/REALKIND)
    f( 91) = (eQED**4*integralnorm*MB**2*SwB)/(cw*MW**2*sw**3*8._/**/REALKIND)
    f( 92) = (eQED**4*integralnorm*MB*MH**2*SwB)/(cw*MW**2*sw**3*8._/**/REALKIND)
    f( 93) = (eQED**4*integralnorm*MB*MT*SwB)/(cw*MW**2*sw**3*8._/**/REALKIND)
    f( 94) = (eQED**4*integralnorm*MH**2*MT*SwB)/(cw*MW**2*sw**3*8._/**/REALKIND)
    f( 95) = (eQED**4*integralnorm*MT**2*SwB)/(cw*MW**2*sw**3*8._/**/REALKIND)
    f( 96) = (eQED**4*integralnorm*SwB)/(sw**2*18._/**/REALKIND)
    f( 97) = (eQED**4*integralnorm*SwB)/(sw**2*9._/**/REALKIND)
    f( 98) = (eQED**4*integralnorm*SwB)/(sw**2*6._/**/REALKIND)
    f( 99) = (2*eQED**4*integralnorm*SwB)/(sw**2*9._/**/REALKIND)
    f(100) = (eQED**4*integralnorm*SwB)/(sw**2*3._/**/REALKIND)
    f(101) = (eQED**4*integralnorm*SwB)/(sw**2*2._/**/REALKIND)
    f(102) = (eQED**4*integralnorm*SwB)/(cw**2*sw**2*4._/**/REALKIND)
    f(103) = (cw**2*eQED**4*integralnorm*SwB)/sw**2
    f(104) = (eQED**2*gQCD**2*integralnorm*SwB)/(sw**2*2._/**/REALKIND)
    f(105) = (eQED**4*integralnorm*MB*SwB)/(sw**2*6._/**/REALKIND)
    f(106) = (eQED**4*integralnorm*MB*SwB)/(sw**2*3._/**/REALKIND)
    f(107) = (eQED**4*integralnorm*MB*SwB)/(cw**2*sw**2*2._/**/REALKIND)
    f(108) = (eQED**4*integralnorm*MT*SwB)/(sw**2*12._/**/REALKIND)
    f(109) = (eQED**4*integralnorm*MT*SwB)/(sw**2*6._/**/REALKIND)
    f(110) = (eQED**4*integralnorm*MT*SwB)/(cw**2*sw**2*2._/**/REALKIND)
    f(111) = (eQED**4*integralnorm*SwB)/(MW**2*sw**2*18._/**/REALKIND)
    f(112) = (eQED**4*integralnorm*SwB)/(MW**2*sw**2*9._/**/REALKIND)
    f(113) = (eQED**4*integralnorm*SwB)/(MW**2*sw**2*6._/**/REALKIND)
    f(114) = (2*eQED**4*integralnorm*SwB)/(MW**2*sw**2*9._/**/REALKIND)
    f(115) = (eQED**4*integralnorm*SwB)/(MW**2*sw**2*3._/**/REALKIND)
    f(116) = (eQED**4*integralnorm*SwB)/(MW**2*sw**2*2._/**/REALKIND)
    f(117) = (eQED**2*gQCD**2*integralnorm*SwB)/(MW**2*sw**2*2._/**/REALKIND)
    f(118) = (eQED**4*integralnorm*MB**2*SwB)/(MW**2*sw**2*18._/**/REALKIND)
    f(119) = (eQED**4*integralnorm*MB**2*SwB)/(MW**2*sw**2*4._/**/REALKIND)
    f(120) = (eQED**2*gQCD**2*integralnorm*MB**2*SwB)/(MW**2*sw**2*4._/**/REALKIND)
    f(121) = (eQED**4*integralnorm*MB*MH**2*SwB)/(MW**2*sw**2*6._/**/REALKIND)
    f(122) = (eQED**4*integralnorm*MB*MT*SwB)/(MW**2*sw**2*36._/**/REALKIND)
    f(123) = (eQED**4*integralnorm*MB*MT*SwB)/(MW**2*sw**2*18._/**/REALKIND)
    f(124) = (eQED**4*integralnorm*MB*MT*SwB)/(MW**2*sw**2*9._/**/REALKIND)
    f(125) = (eQED**4*integralnorm*MB*MT*SwB)/(MW**2*sw**2*4._/**/REALKIND)
    f(126) = (eQED**2*gQCD**2*integralnorm*MB*MT*SwB)/(MW**2*sw**2*4._/**/REALKIND)
    f(127) = (eQED**4*integralnorm*MH**2*MT*SwB)/(MW**2*sw**2*12._/**/REALKIND)
    f(128) = (eQED**4*integralnorm*MT**2*SwB)/(MW**2*sw**2*18._/**/REALKIND)
    f(129) = (eQED**4*integralnorm*MT**2*SwB)/(MW**2*sw**2*4._/**/REALKIND)
    f(130) = (eQED**2*gQCD**2*integralnorm*MT**2*SwB)/(MW**2*sw**2*4._/**/REALKIND)
    f(131) = (eQED**4*integralnorm*MW**2*SwB)/(sw**2*2._/**/REALKIND)
    f(132) = (eQED**4*integralnorm*MW**2*SwB)/(cw**4*sw**2)
    f(133) = (eQED**4*integralnorm*SwB)/(cw*sw*2._/**/REALKIND)
    f(134) = (cw*eQED**4*integralnorm*SwB)/(sw*3._/**/REALKIND)
    f(135) = (2*cw*eQED**4*integralnorm*SwB)/(sw*3._/**/REALKIND)
    f(136) = (eQED**4*integralnorm*MB*SwB)/(cw*sw*4._/**/REALKIND)
    f(137) = (eQED**4*integralnorm*MT*SwB)/(cw*sw*4._/**/REALKIND)
    f(138) = (eQED**4*integralnorm*MW**2*sw*SwB)/(cw*3._/**/REALKIND)
    f(139) = (2*eQED**4*integralnorm*MW**2*sw*SwB)/(cw*3._/**/REALKIND)
    f(140) = (eQED**4*integralnorm*MW**2*sw**2*SwB)/cw**2
    f(141) = (eQED**4*integralnorm*(cw - sw)*(cw + sw)*SwB)/(cw**2*sw**2*4._/**/REALKIND)
    f(142) = -((eQED**4*integralnorm*(cw - sw)*(cw + sw)*SwB)/(sw**4*4._/**/REALKIND))
    f(143) = (eQED**4*integralnorm*(-cw + sw)*(cw + sw)*SwB)/(cw**2*sw**4*8._/**/REALKIND)
    f(144) = -((eQED**4*integralnorm*SwB*(cw**4*4._/**/REALKIND + sw**4*4._/**/REALKIND  &
      - cw**2*sw**2*8._/**/REALKIND))/(cw**2*MW**2*sw**4*4._/**/REALKIND*8._/**/REALKIND))
    f(145) = -((eQED**4*integralnorm*(cw - sw)*(cw + sw)*SwB)/(cw*MW**2*sw**3*4._/**/REALKIND))
    f(146) = -((eQED**4*integralnorm*MB*MH**2*(cw - sw)*(cw + sw)*SwB)/(cw*MW**2*sw**3*8._/**/REALKIND))
    f(147) = -((eQED**4*integralnorm*MH**2*MT*(cw - sw)*(cw + sw)*SwB)/(cw*MW**2*sw**3*8._/**/REALKIND))
    f(148) = -((eQED**4*integralnorm*(cw - sw)*(cw + sw)*SwB)/(cw*sw*6._/**/REALKIND))
    f(149) = -((eQED**4*integralnorm*(cw - sw)*(cw + sw)*SwB)/(cw*sw*3._/**/REALKIND))
    f(150) = (eQED**4*integralnorm*SwB*(cw**4*2._/**/REALKIND + sw**4*2._/**/REALKIND  &
      - cw**2*sw**2*4._/**/REALKIND))/(cw**2*sw**2*2._/**/REALKIND*4._/**/REALKIND)
    f(151) = (2*eQED**4*integralnorm*SwF)/81._/**/REALKIND
    f(152) = (4*eQED**4*integralnorm*SwF)/81._/**/REALKIND
    f(153) = (8*eQED**4*integralnorm*SwF)/81._/**/REALKIND
    f(154) = (eQED**4*integralnorm*SwF)/9._/**/REALKIND
    f(155) = (16*eQED**4*integralnorm*SwF)/81._/**/REALKIND
    f(156) = (2*eQED**4*integralnorm*SwF)/9._/**/REALKIND
    f(157) = (eQED**4*integralnorm*SwF)/3._/**/REALKIND
    f(158) = (4*eQED**4*integralnorm*SwF)/9._/**/REALKIND
    f(159) = (2*eQED**4*integralnorm*SwF)/3._/**/REALKIND
    f(160) = (8*eQED**4*integralnorm*SwF)/9._/**/REALKIND
    f(161) = eQED**4*integralnorm*SwF
    f(162) = 2*eQED**4*integralnorm*SwF
    f(163) = 3*eQED**4*integralnorm*SwF
    f(164) = (eQED**4*integralnorm*SwF)/(sw**4*4._/**/REALKIND)
    f(165) = (eQED**4*integralnorm*SwF)/(sw**4*2._/**/REALKIND)
    f(166) = (eQED**4*integralnorm*SwF)/(MW**4*sw**4*4._/**/REALKIND)
    f(167) = (eQED**4*integralnorm*ME**2*SwF)/(MW**4*sw**4*4._/**/REALKIND)
    f(168) = (eQED**4*integralnorm*ML**2*SwF)/(MW**4*sw**4*4._/**/REALKIND)
    f(169) = (eQED**4*integralnorm*MM**2*SwF)/(MW**4*sw**4*4._/**/REALKIND)
    f(170) = (eQED**4*integralnorm*MB**3*MT*SwF)/(MW**4*sw**4*16._/**/REALKIND)
    f(171) = (eQED**4*integralnorm*MB*ME**2*MT*SwF)/(MW**4*sw**4*16._/**/REALKIND)
    f(172) = (eQED**4*integralnorm*MB*ML**2*MT*SwF)/(MW**4*sw**4*16._/**/REALKIND)
    f(173) = (eQED**4*integralnorm*MB*MM**2*MT*SwF)/(MW**4*sw**4*16._/**/REALKIND)
    f(174) = (eQED**4*integralnorm*MB*MT**3*SwF)/(MW**4*sw**4*16._/**/REALKIND)
    f(175) = (eQED**4*integralnorm*SwF)/(MW**2*sw**4*4._/**/REALKIND)
    f(176) = (eQED**4*integralnorm*ME*SwF)/(MW**2*sw**4*4._/**/REALKIND)
    f(177) = (eQED**4*integralnorm*ML*SwF)/(MW**2*sw**4*4._/**/REALKIND)
    f(178) = (eQED**4*integralnorm*MM*SwF)/(MW**2*sw**4*4._/**/REALKIND)
    f(179) = (eQED**4*integralnorm*MB**2*SwF)/(MW**2*sw**2*18._/**/REALKIND)
    f(180) = (eQED**4*integralnorm*MB**2*SwF)/(MW**2*sw**2*4._/**/REALKIND)
    f(181) = (eQED**4*integralnorm*MB*ME*SwF)/(MW**2*sw**2*6._/**/REALKIND)
    f(182) = (eQED**4*integralnorm*MB*ME*SwF)/(MW**2*sw**2*4._/**/REALKIND)
    f(183) = (eQED**4*integralnorm*MB*ML*SwF)/(MW**2*sw**2*6._/**/REALKIND)
    f(184) = (eQED**4*integralnorm*MB*ML*SwF)/(MW**2*sw**2*4._/**/REALKIND)
    f(185) = (eQED**4*integralnorm*MB*MM*SwF)/(MW**2*sw**2*6._/**/REALKIND)
    f(186) = (eQED**4*integralnorm*MB*MM*SwF)/(MW**2*sw**2*4._/**/REALKIND)
    f(187) = (eQED**4*integralnorm*MB*MT*SwF)/(MW**2*sw**2*36._/**/REALKIND)
    f(188) = (eQED**4*integralnorm*MB*MT*SwF)/(MW**2*sw**2*9._/**/REALKIND)
    f(189) = (eQED**4*integralnorm*MB*MT*SwF)/(MW**2*sw**2*4._/**/REALKIND)
    f(190) = (eQED**4*integralnorm*ME*MT*SwF)/(MW**2*sw**2*12._/**/REALKIND)
    f(191) = (eQED**4*integralnorm*ME*MT*SwF)/(MW**2*sw**2*4._/**/REALKIND)
    f(192) = (eQED**4*integralnorm*ML*MT*SwF)/(MW**2*sw**2*12._/**/REALKIND)
    f(193) = (eQED**4*integralnorm*ML*MT*SwF)/(MW**2*sw**2*4._/**/REALKIND)
    f(194) = (eQED**4*integralnorm*MM*MT*SwF)/(MW**2*sw**2*12._/**/REALKIND)
    f(195) = (eQED**4*integralnorm*MM*MT*SwF)/(MW**2*sw**2*4._/**/REALKIND)
    f(196) = (eQED**4*integralnorm*MT**2*SwF)/(MW**2*sw**2*18._/**/REALKIND)
    f(197) = (eQED**4*integralnorm*MT**2*SwF)/(MW**2*sw**2*4._/**/REALKIND)

  c = [ 6*f(33), 6*f(34), 6*f(35), 6*f(36), 6*f(37), 6*f(38), 6*f(39), 6*f(40), f(41), 3*f(41), f(42), 3*f(42), 8*f(42), f(43) &
    , 3*f(43), f(44), 3*f(44), 8*f(44), 6*f(45), 6*f(46), 6*f(47), 6*f(48), 6*f(49), 6*f(50), 6*f(51), 6*f(52), 6*f(53), 6*f(54) &
    , 6*f(55), 6*f(56), 6*f(57), 6*f(58), 6*f(59), 6*f(60), 6*f(61), 6*f(62), 6*f(63), 6*f(64), 6*f(65), 6*f(66), 6*f(67), 6*f(68) &
    , 6*f(69), 6*f(70), 6*f(71), 6*f(72), 6*f(73), 6*f(74), 6*f(75), 6*f(76), 6*f(77), 6*f(78), 6*f(79), 6*f(80), 6*f(81), 6*f(82) &
    , 6*f(83), 6*f(84), 6*f(85), 6*f(86), 6*f(87), 6*f(88), 6*f(89), 6*f(90), 6*f(91), 6*f(92), 6*f(93), 6*f(94), 6*f(95), 6*f(96) &
    , 6*f(97), 6*f(98), 6*f(99), 6*f(100), 6*f(101), 6*f(102), 6*f(103), f(104), 3*f(104), 8*f(104), 6*f(105), 6*f(106), 6*f(107) &
    , 6*f(108), 6*f(109), 6*f(110), 6*f(111), 6*f(112), 6*f(113), 6*f(114), 6*f(115), 6*f(116), f(117), 3*f(117), 8*f(117) &
    , 6*f(118), 6*f(119), f(120), 3*f(120), 6*f(121), 6*f(122), 6*f(123), 6*f(124), 6*f(125), f(126), 3*f(126), 8*f(126), 6*f(127) &
    , 6*f(128), 6*f(129), f(130), 3*f(130), 6*f(131), 6*f(132), 6*f(133), 6*f(134), 6*f(135), 6*f(136), 6*f(137), 6*f(138) &
    , 6*f(139), 6*f(140), 6*f(141), 6*f(142), 6*f(143), 6*f(144), 6*f(145), 6*f(146), 6*f(147), 6*f(148), 6*f(149), 6*f(150) &
    , 18*f(151), 18*f(152), 18*f(153), 18*f(154), 18*f(155), 6*f(156), 18*f(156), 6*f(157), 18*f(158), 6*f(159), 18*f(160) &
    , 6*f(161), 18*f(161), 18*f(162), 6*f(163), 6*f(164), 18*f(164), 18*f(165), 18*f(166), 6*f(167), 6*f(168), 6*f(169), 18*f(170) &
    , 6*f(171), 6*f(172), 6*f(173), 18*f(174), 18*f(175), 6*f(176), 6*f(177), 6*f(178), 18*f(179), 18*f(180), 6*f(181), 6*f(182) &
    , 6*f(183), 6*f(184), 6*f(185), 6*f(186), 18*f(187), 18*f(188), 18*f(189), 6*f(190), 6*f(191), 6*f(192), 6*f(193), 6*f(194) &
    , 6*f(195), 18*f(196), 18*f(197) ]
  c = (1._/**/REALKIND / 6) * c
end subroutine fac_init_loop

subroutine denominators()
  use ol_parameters_decl_/**/REALKIND ! masses
  use ol_momenta_decl_/**/REALKIND, only: L
  implicit none
  ! propagators
  den(1) = 1 /((L(5,3) - MH2)+L(6,3))
  den(2) = 1 /((L(5,3) - MZ2)+L(6,3))
  den(3) = 1 /((L(5,3))+L(6,3))
  den(4) = 1 /((L(5,9) - MW2)+L(6,9))
  den(5) = 1 /((L(5,6) - MW2)+L(6,6))
  den(6) = 1 /((L(5,12) - MH2)+L(6,12))
  den(7) = 1 /((L(5,12) - MZ2)+L(6,12))
  den(8) = 1 /((L(5,12))+L(6,12))

  ! denominators
  den(9) = den(1)*den(6)
  den(10) = den(2)*den(7)
  den(11) = den(2)*den(8)
  den(12) = den(3)*den(7)
  den(13) = den(3)*den(8)
  den(14) = den(4)*den(5)
  den(15) = den(1)*den(7)
  den(16) = den(2)*den(6)
  den(17) = den(1)*den(8)
  den(18) = den(3)*den(6)

end subroutine denominators

#ifdef PRECISION_dp
! **********************************************************************
subroutine init_merging_tables(tot_num_hels, tot_num_merge_steps)
!-----------------------------------------------------------------------
! In the first event the merging tables are fully initialised
! **********************************************************************
  implicit none
  integer, intent(in) :: tot_num_hels, tot_num_merge_steps
  n_merge_steps = tot_num_merge_steps
  allocate(merge_tables(tot_num_hels,2,n_merge_steps))
  allocate(merge_mism(n_merge_steps+1))
  allocate(merge_hels(n_merge_steps))
  merge_tables_on = .true.
  merge_mism = 0_intkind2
  merge_tables = -1_intkind2
  merge_hels = -1_intkind2
end subroutine init_merging_tables

! **********************************************************************
subroutine update_merging_tables(tot_num_hels)
!-----------------------------------------------------------------------
! After the first evaluation the merging tables are adapted
! **********************************************************************
  implicit none
  integer, intent(in) :: tot_num_hels
  integer(intkind2), allocatable ::  merge_tables_tmp(:,:,:), merge_hels_tmp(:)

  if(merge_mism(1) == 0) then ! helicity configurations match in all merging steps
    if(allocated(merge_tables)) deallocate(merge_tables)
    if(allocated(merge_hels)) deallocate(merge_hels)
    if(allocated(merge_mism)) deallocate(merge_mism)
    allocate(merge_mism(1))
    allocate(merge_hels(1))
    allocate(merge_tables(1,1,1)) ! dummy allocation
    merge_mism = 0_intkind2
    merge_tables = -1_intkind2
    merge_hels = -1_intkind2
  else
    n_merge_mism = merge_mism(1)
    allocate(merge_tables_tmp(tot_num_hels,2,n_merge_mism))
    merge_tables_tmp(:,:,1:n_merge_mism) = merge_tables(:,:,1:n_merge_mism)
    if(allocated(merge_tables)) then
      deallocate(merge_tables)
      allocate(merge_tables(tot_num_hels,2,n_merge_mism))
    end if
    merge_tables = merge_tables_tmp
    if(allocated(merge_tables_tmp)) deallocate(merge_tables_tmp)
    allocate(merge_hels_tmp(n_merge_mism))
    merge_hels_tmp(1:n_merge_mism) = merge_hels(1:n_merge_mism)
    if(allocated(merge_hels)) then
      deallocate(merge_hels)
      allocate(merge_hels(n_merge_mism))
    end if
    merge_hels = merge_hels_tmp
    if(allocated(merge_hels_tmp)) deallocate(merge_hels_tmp)
  end if
  merge_tables_on = .true.
end subroutine update_merging_tables
#endif


!
!
!
! **********************************************************************
#ifdef PRECISION_dp
recursive subroutine amp2(P_scatt, M02, M2ct, M2colint, qp_kinematics)
#else
recursive subroutine amp2(P_scatt, M02, M2ct, M2colint, qp_kinematics)
  use ol_loop_storage_pptt_ew_ttxbbx_3_/**/DREALKIND, only: nhel, Hel
#endif
! P_scatt(0:3,Npart) = incoming external momenta
! M2  = helicity-summed squared matrix element for top anti-top bottom anti-bottom -> 0
! **********************************************************************
  use ol_parameters_decl_/**/REALKIND !, only: ci, parameters_status, ZERO, scalefactor, >masses<
  use ol_parameters_init_/**/REALKIND, only: ensure_mp_init
  use ol_kinematics_/**/REALKIND, only: init_kinematics
  use ol_momenta_decl_/**/DREALKIND, only: momenta_nan_check
  use ol_data_types_/**/REALKIND
  use ol_h_helicity_bookkeeping_/**/REALKIND, only: &
    & helbookkeeping_wf, helsync, flip_phase
  use ol_helicity_init, only: helbookkeeping_flip, helsync_flip
  use ol_hel_propagators_/**/REALKIND
  use ol_hel_wavefunctions_/**/REALKIND
  use ol_wavefunctions_/**/REALKIND, only: wf_V_Std
  use ol_hel_vertices_/**/REALKIND
  use ol_hel_contractions_/**/REALKIND
  use ol_external_pptt_ew_ttxbbx_3, only: &
    & external_perm_pptt_ew_ttxbbx_3, &
    & external_perm_inv_pptt_ew_ttxbbx_3, &
    & extcomb_perm_pptt_ew_ttxbbx_3, &
    & average_factor_pptt_ew_ttxbbx_3, &
    & photonid_pptt_ew_ttxbbx_3
  use ol_ew_renormalisation_/**/REALKIND, only: photon_factors
  use ol_external_pptt_ew_ttxbbx_3, only: &
    & H, hel_not_initialised, hel_init, POLSEL
  use ol_colourmatrix_pptt_ew_ttxbbx_3_/**/REALKIND, only: &
    & colmat_not_initialised, colourmatrix_init
  use ol_forced_parameters_pptt_ew_ttxbbx_3_/**/REALKIND, only: &
    & check_forced_parameters
  use ol_heltables_OLR_pptt_ew_ttxbbx_3
  use ol_kinematics_/**/REALKIND, only: LC2Std_Rep_cmplx
  use ol_h_counterterms_/**/REALKIND
  use ol_loop_parameters_decl_/**/REALKIND ! counterterms
  use ol_loop_parameters_decl_/**/DREALKIND, only: IR_is_on
  use ol_init, only: set_parameter, parameters_flush
#ifdef PRECISION_dp
  use ol_kinematics_/**/QREALKIND, only: conv_mom_scatt2in_qp=>conv_mom_scatt2in, &
                                         internal_momenta_qp=>internal_momenta
  use ol_momenta_decl_/**/DREALKIND, only: L
  use ol_momenta_decl_/**/QREALKIND, only: L_qp=>L
#endif
  implicit none

  real(DREALKIND), intent(in)  :: P_scatt(0:3,4)
  real(REALKIND),  intent(out) :: M02, M2ct, M2colint(11)
  logical, intent(in) :: qp_kinematics
  integer(intkind1), save :: ntry = 0

  integer           :: shift, k, r, m, n, i
  real(REALKIND)    :: P(0:3,4)
#ifdef PRECISION_dp
  real(QREALKIND)    :: P_qp(0:3,4)
#endif
  integer           :: extmasses2(4)
  real(REALKIND)    :: M2add, M2add_ct, M2add_colint(11)
  complex(REALKIND) :: M1(4), M2(4)
  real(REALKIND)    :: P_scatt_intern(0:3,4)
  real(REALKIND), save :: scalebackfactor, old_scalefactor = 0
  real(REALKIND)       :: bornphotonfactor
  integer(intkind1) :: nsync
  type(Hpolcont),   save :: M1helarray(4,16)
  type(Hpolcont) :: M1helarray_ct(4,16)
  integer, allocatable :: extcombs_permuted(:)
  integer              :: extcombs(11), nextcombs
  integer              :: CT_on_bak, R2_on_bak, TP_on_bak

#if 4 > 3
  integer :: ind_cc_comb(2)
#endif
  type(Hpolcont) :: A(16,47)

  !Aj are not used at the moment
  !complex(REALKIND) :: Aj(47)

  complex(REALKIND) :: omega(2) ! phases for helicity correlations

  if(ntry == 0) then
    ! recursive initialization call needed for the correct helicity bokkeeping
    ntry = 1
    CT_on_bak = CT_is_on
    R2_on_bak = R2_is_on
    TP_on_bak = TP_is_on
    call set_parameter("ct_on", 1)
    call set_parameter("r2_on", 1)
    call set_parameter("tp_on", 1)
    call amp2(P_scatt, M02, M2ct, M2colint, qp_kinematics)
    call set_parameter("ct_on", CT_on_bak)
    call set_parameter("r2_on", R2_on_bak)
    call set_parameter("tp_on", TP_on_bak)
  end if


  call set_parameter("ew_renorm", 1)
  call parameters_flush()
  call ensure_mp_init()

  if (colmat_not_initialised) call colourmatrix_init()

  if (fac_status_loop1 /= parameters_status .or. fac_status_loop2 /= loop_parameters_status) then
    ! Note: if fac_init would only be called when parameters changed which are relevant for the factors,
    ! a different 'status' would have to be used, because forced_parameters should be called after every parameter change.
    call check_forced_parameters()
    call fac_init_loop()
  end if

  if (momenta_nan_check(P_scatt) /= 0) then
    M02 = 0
    return
  end if

  extmasses2 = [ nMT, nMT, nMB, nMB ]
  ! Convert 2 -> n-2 PS-point to n -> 0 (so that P(1) + ... + P(n) = 0) and compute
  ! internal-propagator momenta in light-cone representation
  call init_kinematics(P_scatt, extmasses2, P, &
     external_perm_inv_pptt_ew_ttxbbx_3, 4, qp_kinematics)

  ! denominators
  call denominators()

   if (heltables_not_init) call init_heltables()

  ! external WFs
  ! Here the external wavefunctions are initialiased
  call pol_wf_Q(P(:,1), rMT, H1, ex1, POLSEL(1),1)
  call pol_wf_A(P(:,2), rMT, H2, ex2, POLSEL(2),2)
  call pol_wf_Q(P(:,3), rMB, H3, ex3, POLSEL(3),3)
  call pol_wf_A(P(:,4), rMB, H4, ex4, POLSEL(4),4)



  ! internal WFs
  ! e.g. call vert_VQ_A(ntry, ex3, ex1, wf1, n1, t1) ...
  call vert_AQ_S(gH,ntry, ex2(:), ex1(:), wf4(:,1), n3(:,1), t3x4(:,:,1))
  call vert_AQ_S(gH,ntry, ex4(:), ex3(:), wf4(:,2), n3(:,2), t3x4(:,:,2))
  call vert_AQ_S(gX,ntry, ex2(:), ex1(:), wf4(:,3), n3(:,3), t3x4(:,:,3))
  call vert_AQ_S(gX,ntry, ex4(:), ex3(:), wf4(:,4), n3(:,4), t3x4(:,:,4))
  call vert_QA_V(ntry, ex1(:), ex2(:), wf4(:,5), n3(:,5), t3x4(:,:,5))
  call vert_QA_V(ntry, ex3(:), ex4(:), wf4(:,6), n3(:,6), t3x4(:,:,6))
  call vert_QA_Z(gZu,ntry, ex1(:), ex2(:), wf4(:,7), n3(:,7), t3x4(:,:,7))
  call vert_QA_Z(gZd,ntry, ex3(:), ex4(:), wf4(:,8), n3(:,8), t3x4(:,:,8))
  call vert_AQ_S(gPbt,ntry, ex4(:), ex1(:), wf4(:,9), n3(:,9), t3x4(:,:,9))
  call vert_AQ_S(gPtb,ntry, ex2(:), ex3(:), wf4(:,10), n3(:,10), t3x4(:,:,10))
  call vert_QA_W(ntry, ex1(:), ex4(:), wf4(:,11), n3(:,11), t3x4(:,:,11))
  call vert_QA_W(ntry, ex3(:), ex2(:), wf4(:,12), n3(:,12), t3x4(:,:,12))
  call counter_AQ_S(gH,ntry, ex4(:), ex3(:), wf4(:,13), n3(:,13), t3x4(:,:,13))
  call counter_AQ_S(EWctHbb,ntry, ex4(:), ex3(:), wf4(:,14), n3(:,14), t3x4(:,:,14))
  call counter_AQ_S(gX,ntry, ex4(:), ex3(:), wf4(:,15), n3(:,15), t3x4(:,:,15))
  call counter_AQ_S(EWctXbb,ntry, ex4(:), ex3(:), wf4(:,16), n3(:,16), t3x4(:,:,16))
  call counter_QA_V(ntry, ex3(:), ex4(:), wf4(:,17), n3(:,17), t3x4(:,:,17))
  call counter_QA_V_LR(EWctAbb,ntry, ex3(:), ex4(:), wf4(:,18), n3(:,18), t3x4(:,:,18))
  call counter_QA_Z(gZd,ntry, ex3(:), ex4(:), wf4(:,19), n3(:,19), t3x4(:,:,19))
  call counter_QA_Z(EWctVbb,ntry, ex3(:), ex4(:), wf4(:,20), n3(:,20), t3x4(:,:,20))
  call counter_QA_V_LR(EWctGbb,ntry, ex3(:), ex4(:), wf4(:,21), n3(:,21), t3x4(:,:,21))
  call counter_AQ_S(ctStb,ntry, ex2(:), ex3(:), wf4(:,22), n3(:,22), t3x4(:,:,22))
  call counter_AQ_S(EWctPtb,ntry, ex2(:), ex3(:), wf4(:,23), n3(:,23), t3x4(:,:,23))
  call counter_QA_W(ntry, ex3(:), ex2(:), wf4(:,24), n3(:,24), t3x4(:,:,24))
  call counter_AQ_S(ctSbt,ntry, ex4(:), ex1(:), wf4(:,25), n3(:,25), t3x4(:,:,25))
  call counter_AQ_S(EWctPbt,ntry, ex4(:), ex1(:), wf4(:,26), n3(:,26), t3x4(:,:,26))
  call counter_QA_W(ntry, ex1(:), ex4(:), wf4(:,27), n3(:,27), t3x4(:,:,27))
  call counter_AQ_S(gH,ntry, ex2(:), ex1(:), wf4(:,28), n3(:,28), t3x4(:,:,28))
  call counter_AQ_S(EWctHtt,ntry, ex2(:), ex1(:), wf4(:,29), n3(:,29), t3x4(:,:,29))
  call counter_AQ_S(gX,ntry, ex2(:), ex1(:), wf4(:,30), n3(:,30), t3x4(:,:,30))
  call counter_AQ_S(EWctXtt,ntry, ex2(:), ex1(:), wf4(:,31), n3(:,31), t3x4(:,:,31))
  call counter_QA_V(ntry, ex1(:), ex2(:), wf4(:,32), n3(:,32), t3x4(:,:,32))
  call counter_QA_V_LR(EWctAtt,ntry, ex1(:), ex2(:), wf4(:,33), n3(:,33), t3x4(:,:,33))
  call counter_QA_Z(gZu,ntry, ex1(:), ex2(:), wf4(:,34), n3(:,34), t3x4(:,:,34))
  call counter_QA_Z(EWctVtt,ntry, ex1(:), ex2(:), wf4(:,35), n3(:,35), t3x4(:,:,35))
  call counter_QA_V_LR(EWctGtt,ntry, ex1(:), ex2(:), wf4(:,36), n3(:,36), t3x4(:,:,36))
  call counter_S_S(EWctHH,ntry, wf4(:,1), 3, wf4(:,37), n2(1))
  call counter_S_S(EWctXX,ntry, wf4(:,3), 3, wf4(:,38), n2(2))
  call counter_S_V(EWctXA,ntry, wf4(:,3), 3, wf4(:,39), n2(3))
  call counter_S_V(EWctXZ,ntry, wf4(:,3), 3, wf4(:,40), n2(4))
  call counter_V_S(EWctXA,ntry, wf4(:,5), 3, wf4(:,41), n2(5))
  call counter_V_S(EWctXZ,ntry, wf4(:,7), 3, wf4(:,42), n2(6))
  call counter_V_V(EWctAA,ntry, wf4(:,5), 3, wf4(:,43), n2(7))
  call counter_V_V(EWctAZ,ntry, wf4(:,5), 3, wf4(:,44), n2(8))
  call counter_V_V(EWctAZ,ntry, wf4(:,7), 3, wf4(:,45), n2(9))
  call counter_V_V(EWctZZ,ntry, wf4(:,7), 3, wf4(:,46), n2(10))
  call counter_S_S(EWctPP,ntry, wf4(:,9), 9, wf4(:,47), n2(11))
  call counter_S_V(EWctPW,ntry, wf4(:,9), 9, wf4(:,48), n2(12))
  call counter_V_S(EWctPW,ntry, wf4(:,11), 9, wf4(:,49), n2(13))
  call counter_V_V(EWctWW,ntry, wf4(:,11), 9, wf4(:,50), n2(14))


  call init_hybrid_exwf(ex1)
  call init_hybrid_exwf(ex2)
  call init_hybrid_exwf(ex3)
  call init_hybrid_exwf(ex4)
  call init_hybrid_wf(wf4)


  if (ntry==1) then
    call physical_helicities()
  end if

  ! computation of the colour-stripped amplitudes
  do nsync = ntry+ntry-1, ntry+1  !  nsync = 1,2  for 1st point and nsync = 3 later
    call diagrams()
    if (nsync == 1) call helsync(nsync, A, nhel, Hel)
  end do

  ! In the following loop the coefficients \Gamma_{i} of the expansion in
  ! the colour basis are computed for every helicity state and stored in M1helarray.
  ! Also the colour vector for the Born-loop interference is computed and saved in
  ! M0_col1_helarray
  do k = 1, nhel
    call colourvectors(A, k, M1helarray(:,k),M1helarray_ct(:,k))
    call colborninterf(M1helarray(:,k), M0_col1_helarray(:,k), 0)
  end do
  M1helarray(:,nhel+1:)%j = 0
  M0_col1_helarray(:,nhel+1:)%hf = -1_intkind2
  M0_col1_helarray(:,nhel+1:)%j = 0

  M2add = 0
  M2add_ct = 0
  M2add_colint = 0

  M02 = 0
  M2ct = 0
  M2colint = 0

  do k = 1, nhel
    call colint(M1helarray(:,k)%j, M2add)
    call colint_ct(M1helarray(:,k)%j, M1helarray_ct(:,k)%j, M2add_ct, 0)
    if (IR_is_on > 0) then
      call colint_IR(M1helarray(:,k)%j, M2add_colint)
    end if
    !summation over helicity configurations
    M02 = M02 + M2add
    M2ct = M2ct + M2add_ct
    M2colint = M2colint + M2add_colint
  end do

  call photon_factors(photonid_pptt_ew_ttxbbx_3, &
                    &  0, bornphotonfactor)
  M02 = bornphotonfactor * M02
  M2ct = bornphotonfactor * M2ct
  M2colint = bornphotonfactor * M2colint

  !! used for born-loop colour-correlators
  extcombs = [(i, i = 0, 11-1)]
  nextcombs = 4*(4+1)/2 + 1
  if(nextcombs>0) then
    allocate(extcombs_permuted(nextcombs))
  end if
  do k = 1, nextcombs
    extcombs_permuted(k) = extcomb_perm_pptt_ew_ttxbbx_3(extcombs(k))
  end do

#if 1 > 0 && 4 > 3
  !!Born-loop colour correlators interference
ind_cc_comb = [8,9]
  M0M1_hel_cc(:,:,:)%j = 0
  do n = 1, 2
    M2add_ct = 0
    m = ind_cc_comb(n)
      do k = 1, nhel
        call colint_ct(M1helarray(:,k)%j, M1helarray_ct(:,k)%j, M2add_ct, m)
        call colborninterf(M1helarray(:,k), M0M1_hel_cc(:,k,m), m)
        M2ctcc(m) = M2ctcc(m) + M2add_ct
      end do
  end do
  M0M1_hel_cc(:,nhel+1:,:)%hf = -1_intkind2
  M0M1_hel_cc(:,nhel+1:,:)%j = 0
#endif

  ntry=2


  contains

subroutine physical_helicities()
  implicit none

integer :: i1,i2,i3,i4
integer :: n

n=0

do i4= 1, 2
do i3= 1, 2
do i2= 1, 2
do i1= 1, 2
n = n + 1
 if((ex1(i1)%hf==-1_intkind2) .OR. (ex2(i2)%hf==-1_intkind2) .OR. (ex3(i3)%hf==-1_intkind2) .OR. (ex4(i4)%hf==-1_intkind2)) then
  Hel(n) = -1_intkind2
 else
  Hel(n) = ex1(i1)%hf + ex2(i2)%hf + ex3(i3)%hf + ex4(i4)%hf
 end if
end do
end do
end do
end do

end subroutine physical_helicities

subroutine diagrams()
  implicit none
  integer :: h
  ! e.g. call cont_VV(nsync, wf3, wf6, A(:,1), n64, t64, nhel, den(5)) ...

    call Hcont_SS(nsync, wf4(:,1), wf4(:,2), A(:,1), n3(:,37), t3x16(:,:,1), nhel, den(1))
    call Hcont_SS(nsync, wf4(:,3), wf4(:,4), A(:,2), n3(:,38), t3x16(:,:,2), nhel, den(2))
    call Hcont_VV(nsync, wf4(:,5), wf4(:,6), A(:,3), n3(:,39), t3x16(:,:,3), nhel, den(3))
    call Hcont_VV(nsync, wf4(:,7), wf4(:,8), A(:,4), n3(:,40), t3x16(:,:,4), nhel, den(2))
    call Hcont_VV(nsync, wf4(:,5), wf4(:,6), A(:,5), n3(:,41), t3x16(:,:,5), nhel, den(3))
    call Hcont_SS(nsync, wf4(:,9), wf4(:,10), A(:,6), n3(:,42), t3x16(:,:,6), nhel, den(4))
    call Hcont_VV(nsync, wf4(:,11), wf4(:,12), A(:,7), n3(:,43), t3x16(:,:,7), nhel, den(4))

    call Hcont_SS(nsync, wf4(:,1), wf4(:,13), A(:,8), n3(:,44), t3x16(:,:,8), nhel, den(1))
    call Hcont_SS(nsync, wf4(:,1), wf4(:,14), A(:,9), n3(:,45), t3x16(:,:,9), nhel, den(1))
    call Hcont_SS(nsync, wf4(:,3), wf4(:,15), A(:,10), n3(:,46), t3x16(:,:,10), nhel, den(2))
    call Hcont_SS(nsync, wf4(:,3), wf4(:,16), A(:,11), n3(:,47), t3x16(:,:,11), nhel, den(2))
    call Hcont_VV(nsync, wf4(:,5), wf4(:,17), A(:,12), n3(:,48), t3x16(:,:,12), nhel, den(3))
    call Hcont_VV(nsync, wf4(:,5), wf4(:,18), A(:,13), n3(:,49), t3x16(:,:,13), nhel, den(3))
    call Hcont_VV(nsync, wf4(:,7), wf4(:,19), A(:,14), n3(:,50), t3x16(:,:,14), nhel, den(2))
    call Hcont_VV(nsync, wf4(:,7), wf4(:,20), A(:,15), n3(:,51), t3x16(:,:,15), nhel, den(2))
    call Hcont_VV(nsync, wf4(:,5), wf4(:,21), A(:,16), n3(:,52), t3x16(:,:,16), nhel, den(3))
    call Hcont_SS(nsync, wf4(:,9), wf4(:,22), A(:,17), n3(:,53), t3x16(:,:,17), nhel, den(4))
    call Hcont_SS(nsync, wf4(:,9), wf4(:,23), A(:,18), n3(:,54), t3x16(:,:,18), nhel, den(4))
    call Hcont_VV(nsync, wf4(:,11), wf4(:,24), A(:,19), n3(:,55), t3x16(:,:,19), nhel, den(4))
    call Hcont_VV(nsync, wf4(:,11), wf4(:,24), A(:,20), n3(:,56), t3x16(:,:,20), nhel, den(4))
    call Hcont_SS(nsync, wf4(:,10), wf4(:,25), A(:,21), n3(:,57), t3x16(:,:,21), nhel, den(5))
    call Hcont_SS(nsync, wf4(:,10), wf4(:,26), A(:,22), n3(:,58), t3x16(:,:,22), nhel, den(5))
    call Hcont_VV(nsync, wf4(:,12), wf4(:,27), A(:,23), n3(:,59), t3x16(:,:,23), nhel, den(5))
    call Hcont_VV(nsync, wf4(:,12), wf4(:,27), A(:,24), n3(:,60), t3x16(:,:,24), nhel, den(5))
    call Hcont_SS(nsync, wf4(:,2), wf4(:,28), A(:,25), n3(:,61), t3x16(:,:,25), nhel, den(6))
    call Hcont_SS(nsync, wf4(:,2), wf4(:,29), A(:,26), n3(:,62), t3x16(:,:,26), nhel, den(6))
    call Hcont_SS(nsync, wf4(:,4), wf4(:,30), A(:,27), n3(:,63), t3x16(:,:,27), nhel, den(7))
    call Hcont_SS(nsync, wf4(:,4), wf4(:,31), A(:,28), n3(:,64), t3x16(:,:,28), nhel, den(7))
    call Hcont_VV(nsync, wf4(:,6), wf4(:,32), A(:,29), n3(:,65), t3x16(:,:,29), nhel, den(8))
    call Hcont_VV(nsync, wf4(:,6), wf4(:,33), A(:,30), n3(:,66), t3x16(:,:,30), nhel, den(8))
    call Hcont_VV(nsync, wf4(:,8), wf4(:,34), A(:,31), n3(:,67), t3x16(:,:,31), nhel, den(7))
    call Hcont_VV(nsync, wf4(:,8), wf4(:,35), A(:,32), n3(:,68), t3x16(:,:,32), nhel, den(7))
    call Hcont_VV(nsync, wf4(:,6), wf4(:,36), A(:,33), n3(:,69), t3x16(:,:,33), nhel, den(8))
    call Hcont_SS(nsync, wf4(:,2), wf4(:,37), A(:,34), n3(:,70), t3x16(:,:,34), nhel, den(9))
    call Hcont_SS(nsync, wf4(:,4), wf4(:,38), A(:,35), n3(:,71), t3x16(:,:,35), nhel, den(10))
    call Hcont_VV(nsync, wf4(:,6), wf4(:,39), A(:,36), n3(:,72), t3x16(:,:,36), nhel, den(11))
    call Hcont_VV(nsync, wf4(:,8), wf4(:,40), A(:,37), n3(:,73), t3x16(:,:,37), nhel, den(10))
    call Hcont_SS(nsync, wf4(:,4), wf4(:,41), A(:,38), n3(:,74), t3x16(:,:,38), nhel, den(12))
    call Hcont_SS(nsync, wf4(:,4), wf4(:,42), A(:,39), n3(:,75), t3x16(:,:,39), nhel, den(10))
    call Hcont_VV(nsync, wf4(:,6), wf4(:,43), A(:,40), n3(:,76), t3x16(:,:,40), nhel, den(13))
    call Hcont_VV(nsync, wf4(:,8), wf4(:,44), A(:,41), n3(:,77), t3x16(:,:,41), nhel, den(12))
    call Hcont_VV(nsync, wf4(:,6), wf4(:,45), A(:,42), n3(:,78), t3x16(:,:,42), nhel, den(11))
    call Hcont_VV(nsync, wf4(:,8), wf4(:,46), A(:,43), n3(:,79), t3x16(:,:,43), nhel, den(10))
    call Hcont_SS(nsync, wf4(:,10), wf4(:,47), A(:,44), n3(:,80), t3x16(:,:,44), nhel, den(14))
    call Hcont_VV(nsync, wf4(:,12), wf4(:,48), A(:,45), n3(:,81), t3x16(:,:,45), nhel, den(14))
    call Hcont_SS(nsync, wf4(:,10), wf4(:,49), A(:,46), n3(:,82), t3x16(:,:,46), nhel, den(14))
    call Hcont_VV(nsync, wf4(:,12), wf4(:,50), A(:,47), n3(:,83), t3x16(:,:,47), nhel, den(14))

end subroutine diagrams


elemental function diagmap(j, n)
  implicit none
  integer, intent(in) :: j, n
  complex(REALKIND) :: diagmap
  diagmap = A(j,n)%j
end function diagmap

function diagsum(j, pos, neg)
  implicit none
  integer, intent(in) :: j, pos(:), neg(:)
  complex(REALKIND) :: diagsum
  diagsum = sum(diagmap(j, pos)) - sum(diagmap(j, neg))
end function diagsum

subroutine colourvectors(A, j, M1, M2)
  implicit none
  type(Hpolcont) :: A(:,:)
  integer, intent(in) :: j
  type(Hpolcont), intent(out) :: M1(4), M2(4) ! M1helarray(4,16)
  integer :: empty(0), i

  M1(1)%j = (A(j,5)%j*f(7))/2._/**/REALKIND
  M1(2)%j = -(A(j,7)%j*f(13))-A(j,6)%j*f(18)
  M1(3)%j = -(A(j,3)%j*f(1))+A(j,4)%j*f(2)+(-A(j,1)%j-A(j,2)%j)*f(21)
  M1(4)%j = -(A(j,5)%j*f(7))/6._/**/REALKIND

  M2(1)%j = ((A(j,16)%j+A(j,33)%j)*f(8))/2._/**/REALKIND+(-A(j,19)%j-A(j,23)%j)*f(17)+(-A(j,17)%j-A(j,21)%j)*f(20)
  M2(2)%j = A(j,47)%j*f(14)-A(j,24)%j*f(15)-A(j,20)%j*f(16)+A(j,44)%j*f(19)+(-A(j,45)%j+A(j,46)%j)*f(25)+(-A(j,18)%j &
       +A(j,22)%j)*f(32)
  M2(3)%j = ((-A(j,16)%j-A(j,33)%j)*f(8))/6._/**/REALKIND-A(j,12)%j*f(9)+A(j,14)%j*f(10)-A(j,29)%j*f(11)+A(j,31)%j*f(12)+( &
       -A(j,8)%j-A(j,10)%j)*f(23)+(-A(j,25)%j-A(j,27)%j)*f(24)
  M2(4)%j = A(j,40)%j*f(3)+(A(j,30)%j-A(j,42)%j)*f(4)+(-A(j,13)%j+A(j,41)%j)*f(5)+(A(j,15)%j+A(j,32)%j-A(j,43)%j)*f(6)+(A(j,34)%j &
       +A(j,35)%j)*f(22)+(A(j,9)%j+A(j,26)%j)*f(26)+(-A(j,11)%j+A(j,28)%j)*f(27)-A(j,38)%j*f(28)+A(j,39)%j*f(29)-A(j,36)%j*f(30) &
       -A(j,37)%j*f(31)


  M1(:)%hf = Hel(j)
  M2(:)%hf = Hel(j)

  !M(i) corresponds to \Gamma_{i} in Fabios thesis

end subroutine colourvectors


! **********************************************************************
subroutine colint(M, M2colint)
! M(i)   = <M|Ci> colour component of matrix element
! COLINT = <M|M>
!        = Sum_{i,j} <M|Ci> * <Ci|Cj> * <Cj|M>
!        = colour-summed squared matrix element
! K2(i,j) = <Ci|Cj>
! **********************************************************************
  use ol_colourmatrix_pptt_ew_ttxbbx_3_/**/REALKIND, only: K1
  implicit none

  complex(REALKIND), intent(in)  :: M(4)
  real(REALKIND),    intent(out) :: M2colint
  integer :: i, j

  M2colint = 0

    do i = 1, 4
      do j = 1, 4
        M2colint = M2colint + real(conjg(M(i))*K1(i,j)*M(j))
      end do
    end do

end subroutine colint

! **********************************************************************
subroutine colint_ct(M, Mct, M2colint_ct, l)
! M(i)   = <M|Ci> colour component of matrix element
! COLINT = <M|M>
!        = Sum_{i,j} <M|Ci> * <Ci|Cj> * <Cj|M>
!        = colour-summed squared matrix element
! K2(i,j) = <Ci|Cj>
! **********************************************************************
  use ol_colourmatrix_pptt_ew_ttxbbx_3_/**/REALKIND, only: K2
  implicit none
  complex(REALKIND), intent(in)  :: M(4), Mct(4)
  real(REALKIND),    intent(out) :: M2colint_ct
  integer, intent(in) :: l
  integer ::  i, j

  M2colint_ct = 0

  do i = 1, 4
    do j = 1, 4
      M2colint_ct = M2colint_ct + real(conjg(M(i))*K2(i+4*l,j)*Mct(j))
    end do
  end do

end subroutine colint_ct

! **********************************************************************
subroutine colint_IR(M, M2IRadd)
! M(i)   = <M|Ci> colour component of matrix element
! K1(i,j) = .....
! **********************************************************************
  use ol_colourmatrix_pptt_ew_ttxbbx_3_/**/REALKIND, only: K1
  implicit none

  complex(REALKIND), intent(in)  :: M(4)
  real(REALKIND),    intent(out) :: M2IRadd(11)
  integer ::  i, j, k, colmatpos

  M2IRadd = 0

  do k = 1, 12-1
    colmatpos = 4*k
    do i = 1, 4
      do j = 1, 4
        M2IRadd(k) = M2IRadd(k) + real(conjg(M(i))*K1(i+colmatpos,j)*M(j))
      end do
    end do
  end do

end subroutine colint_IR

! **********************************************************************
subroutine colintmunu(M1, M2, M2colint)
! M1(i)    = <M1|Ci> colour component of matrix element
! M2(i)    = <M2|Ci> colour component of matrix element
! M2colint = <M1|M2>
!          = Sum_{i,j} <M1|Ci> * <Ci|Cj> * <Cj|M2>
!          = colour-summed squared matrix element
! K2(i,j) = <Ci|Cj>
! **********************************************************************
  use ol_colourmatrix_pptt_ew_ttxbbx_3_/**/REALKIND, only: K2
  implicit none

  complex(REALKIND), intent(in)  :: M1(4)
  complex(REALKIND), intent(in)  :: M2(4)
  complex(REALKIND),    intent(out) :: M2colint
  integer :: i, j

  M2colint = 0

  do i = 1, 4
    do j = 1, 4
      M2colint = M2colint + M1(i)*K2(i,j)*conjg(M2(j))
    end do
  end do

end subroutine colintmunu





! **********************************************************************
subroutine colborninterf(M, M0_col, l)
! M(i)         = <M|Ci> colour component of matrix element
! M0_col(i)    = <M2|Ci> colour component of matrix element,
!                see \tilde{M}_{j} in Fabios thesis
! M2colint = Sum_{i} <M1|Ci> * <Ci|Cj>
!          = colour-summed squared matrix element
! KL(i,j) = <Ci|Cj> with elements Cj of 1-loop colour basis
! **********************************************************************
  use ol_colourmatrix_pptt_ew_ttxbbx_3_/**/REALKIND, only: KL
  implicit none

  type(Hpolcont), intent(in)  :: M(4)
  type(Hpolcont), intent(out)  :: M0_col(4)
  integer, intent(in) :: l
  integer :: i, j

  do j = 1, 4 !size(KL(1,:))
    M0_col(j)%j = 0
    M0_col(j)%hf = M(1)%hf
    do i = 1, 4 !size(KL(:,1))
      M0_col(j)%j = M0_col(j)%j  + conjg(M(i)%j)*KL(i+4*l,j)
    end do
  end do

end subroutine colborninterf

end subroutine amp2

end module ol_loop_pptt_ew_ttxbbx_3_/**/REALKIND
