
module ol_vamp_1_pptt_ew_ttxddx_1_/**/REALKIND
contains

! **********************************************************************
subroutine vamp_1(M)
! P(0:3,nlegs) = incoming external momenta
! Uses tree structures 'wf', factors 'c', and denominators 'den' from loop_pptt_ew_ttxddx_1.
! Sets colour stripped amplitudes A from the module loop_amplitudes_pptt_ew_ttxddx_1.
! **********************************************************************
  use KIND_TYPES, only: REALKIND, QREALKIND, intkind2
  use ol_parameters_decl_/**/DREALKIND, only: l_switch
  use ol_parameters_decl_/**/QREALKIND ! masses
  use ol_vert_interface_/**/REALKIND
  use ol_prop_interface_/**/REALKIND
  use ol_last_step_/**/REALKIND
  use ol_tables_storage_pptt_ew_ttxddx_1_/**/DREALKIND
  use ol_tensor_sum_storage_pptt_ew_ttxddx_1_/**/REALKIND
  use ol_loop_handling_/**/REALKIND
  use ofred_reduction_/**/REALKIND, only: Hotf_4pt_reduction, Hotf_4pt_reduction_last
  use ofred_reduction_/**/REALKIND, only: Hotf_5pt_reduction, Hotf_5pt_reduction_last
  use ol_loop_reduction_/**/REALKIND, only: TI_bubble_red, TI_triangle_red

  use ol_loop_storage_pptt_ew_ttxddx_1_/**/REALKIND
#ifndef PRECISION_dp
  use ol_loop_storage_pptt_ew_ttxddx_1_/**/DREALKIND, only: ntryL, p_switch, Hel
#endif
  use hol_initialisation_/**/REALKIND, only: G0_hol_initialisation
  use ol_h_vert_interface_/**/REALKIND
  use ol_h_prop_interface_/**/REALKIND
  use ol_h_last_step_/**/REALKIND
  use ol_merging_/**/REALKIND, only: ol_merge, ol_merge_tensors, ol_merge_last

  implicit none

  type(Hpolcont) :: Gcoeff(16)
  type(Hpolcont), intent(in) :: M(4,16)


#ifndef PRECISION_dp
  if (ntryL==1 .OR. p_switch == 1) Gcoeff(:)%hf = Hel
#else
  if (ntryL==1 .OR. p_switch == 2) Gcoeff(:)%hf = Hel
#endif

  ! =============================================


! Dressing, otf merging and otf reduction calls to build loop structures

Gcoeff(:)%j = (-(c(4)*M(1,:)%j)+c(3)*M(3,:)%j)
call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(1),h0tab(:,1),[8,2,1,4],[0,nMT,0,0],4,0)
  call Hloop_QA_V(ntryL,G0H16(1),ex4(:),G0H8(1),m3h2x8(:,1),heltab2x16(:,:,1))
Gcoeff(:)%j = (-(c(4)*M(1,:)%j)+c(3)*M(3,:)%j)
call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(2),h0tab(:,2),[8,2,1,4],[0,nMT,0,0],4,0)
  call Hloop_QA_V(ntryL,G0H16(1),ex4(:),G0H8(2),m3h2x8(:,2),heltab2x16(:,:,2))
Gcoeff(:)%j = (c(9)*M(1,:)%j-c(8)*M(3,:)%j)
call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(3),h0tab(:,3),[8,2,1,4],[0,nMT,nMZ,0],4,0)
  call Hloop_QA_V(ntryL,G0H16(1),ex4(:),G0H8(3),m3h2x8(:,3),heltab2x16(:,:,3))
Gcoeff(:)%j = (c(9)*M(1,:)%j-c(8)*M(3,:)%j)
call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(4),h0tab(:,4),[8,2,1,4],[nMZ,nMT,0,0],4,0)
  call Hloop_QA_Z(ntryL,G0H16(1),ex4(:),G0H8(4),ngZd,m3h2x8(:,4),heltab2x16(:,:,4))
Gcoeff(:)%j = (-(c(17)*M(2,:)%j)+c(18)*M(4,:)%j)
call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(5),h0tab(:,5),[8,2,1,4],[0,nMT,0,0],4,0)
  call Hloop_QA_V(ntryL,G0H16(1),ex4(:),G0H8(5),m3h2x8(:,5),heltab2x16(:,:,5))
Gcoeff(:)%j = (-(c(4)*M(1,:)%j)+c(3)*M(3,:)%j)
call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(6),h0tab(:,6),[8,1,2,4],[0,nMT,0,0],4,0)
  call Hloop_QA_V(ntryL,G0H16(1),ex4(:),G0H8(6),m3h2x8(:,6),heltab2x16(:,:,6))
Gcoeff(:)%j = (-(c(4)*M(1,:)%j)+c(3)*M(3,:)%j)
call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(7),h0tab(:,7),[8,1,2,4],[0,nMT,0,0],4,0)
  call Hloop_QA_V(ntryL,G0H16(1),ex4(:),G0H8(7),m3h2x8(:,7),heltab2x16(:,:,7))
Gcoeff(:)%j = (c(9)*M(1,:)%j-c(8)*M(3,:)%j)
call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(8),h0tab(:,8),[8,1,2,4],[nMZ,nMT,0,0],4,0)
  call Hloop_QA_Z(ntryL,G0H16(1),ex4(:),G0H8(8),ngZd,m3h2x8(:,8),heltab2x16(:,:,8))
Gcoeff(:)%j = (c(9)*M(1,:)%j-c(8)*M(3,:)%j)
call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(9),h0tab(:,9),[8,1,2,4],[0,nMT,nMZ,0],4,0)
  call Hloop_QA_V(ntryL,G0H16(1),ex4(:),G0H8(9),m3h2x8(:,9),heltab2x16(:,:,9))
Gcoeff(:)%j = (c(20)*M(2,:)%j+c(15)*M(4,:)%j)
call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(10),h0tab(:,10),[8,1,2,4],[0,nMT,0,0],4,0)
  call Hloop_QA_V(ntryL,G0H16(1),ex4(:),G0H8(10),m3h2x8(:,10),heltab2x16(:,:,10))
  call ol_merge(ntryL,G0H8(5),[G0H8(2),G0H8(1)])
  call ol_merge(ntryL,G0H8(10),[G0H8(7),G0H8(6)])
  call Hloop_VA_Q(ntryL,G0H8(5),ex2(:),G0H4(1),m3h2x4(:,1),heltab2x8(:,:,1))
  call Hloop_A_Q(ntryL,G0H4(1),10,nMT,G1H4(1),n2h4(1))
  call Hloop_VA_Q(ntryL,G0H8(3),ex2(:),G0H4(1),m3h2x4(:,2),heltab2x8(:,:,2))
  call Hloop_A_Q(ntryL,G0H4(1),10,nMT,G1H4(2),n2h4(2))
  call Hloop_ZA_Q(ntryL,G0H8(4),ex2(:),G0H4(1),ngZu,m3h2x4(:,3),heltab2x8(:,:,3))
  call Hloop_A_Q(ntryL,G0H4(1),10,nMT,G1H4(3),n2h4(3))
  call Hloop_VQ_A(ntryL,G0H8(10),ex1(:),G0H4(1),m3h2x4(:,4),heltab2x8(:,:,4))
  call Hloop_Q_A(ntryL,G0H4(1),9,nMT,G1H4(4),n2h4(4))
  call Hloop_ZQ_A(ntryL,G0H8(8),ex1(:),G0H4(1),ngZu,m3h2x4(:,5),heltab2x8(:,:,5))
  call Hloop_Q_A(ntryL,G0H4(1),9,nMT,G1H4(5),n2h4(5))
  call Hloop_VQ_A(ntryL,G0H8(9),ex1(:),G0H4(1),m3h2x4(:,6),heltab2x8(:,:,6))
  call Hloop_Q_A(ntryL,G0H4(1),9,nMT,G1H4(6),n2h4(6))
  call Hloop_AQ_V(ntryL,G1H4(1),ex1(:),G1H2(1),m3h2x2(:,1),heltab2x4(:,:,1))
  call Hloop_AQ_Z(ntryL,G1H4(2),ex1(:),G1H2(2),ngZu,m3h2x2(:,2),heltab2x4(:,:,2))
  call Hloop_AQ_V(ntryL,G1H4(3),ex1(:),G1H2(3),m3h2x2(:,3),heltab2x4(:,:,3))
  call Hloop_QA_V(ntryL,G1H4(4),ex2(:),G1H2(4),m3h2x2(:,4),heltab2x4(:,:,4))
  call Hloop_QA_V(ntryL,G1H4(5),ex2(:),G1H2(5),m3h2x2(:,5),heltab2x4(:,:,5))
  call Hloop_QA_Z(ntryL,G1H4(6),ex2(:),G1H2(6),ngZu,m3h2x2(:,6),heltab2x4(:,:,6))
  call Hloop_VQ_A(ntryL,G1H2(1),ex3(:),G1H1(1),m3h2x1(:,1),heltab2x2(:,:,1))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),15,0,G2tensor(1),n2h1(1))
  call Hloop_ZQ_A(ntryL,G1H2(2),ex3(:),G1H1(1),ngZd,m3h2x1(:,2),heltab2x2(:,:,2))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),15,0,G2tensor(2),n2h1(2))
  call Hloop_VQ_A(ntryL,G1H2(3),ex3(:),G1H1(1),m3h2x1(:,3),heltab2x2(:,:,3))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),15,0,G2tensor(3),n2h1(3))
  call Hloop_VQ_A(ntryL,G1H2(4),ex3(:),G1H1(1),m3h2x1(:,4),heltab2x2(:,:,4))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),15,0,G2tensor(4),n2h1(4))
  call Hloop_VQ_A(ntryL,G1H2(5),ex3(:),G1H1(1),m3h2x1(:,5),heltab2x2(:,:,5))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),15,0,G2tensor(5),n2h1(5))
  call Hloop_ZQ_A(ntryL,G1H2(6),ex3(:),G1H1(1),ngZd,m3h2x1(:,6),heltab2x2(:,:,6))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),15,0,G2tensor(6),n2h1(6))
call Hotf_4pt_reduction_last(G2tensor(1),RedSet_4(1),mass4set(:,1),  & 
G1tensor(1),G1tensor(2),G1tensor(3),G1tensor(4),G1tensor(5))
call G_TensorShift(G1tensor(2),4)
call Hotf_4pt_reduction_last(G2tensor(2),RedSet_4(1),mass4set(:,2),  & 
G1tensor(6),G1tensor(7),G1tensor(8),G1tensor(9),G1tensor(10))
call G_TensorShift(G1tensor(7),4)
call Hotf_4pt_reduction_last(G2tensor(3),RedSet_4(1),mass4set(:,3),  & 
G1tensor(11),G1tensor(12),G1tensor(13),G1tensor(14),G1tensor(15))
call G_TensorShift(G1tensor(12),4)
call Hotf_4pt_reduction_last(G2tensor(4),RedSet_4(2),mass4set(:,1),  & 
G1tensor(16),G1tensor(17),G1tensor(18),G1tensor(19),G1tensor(20))
call G_TensorShift(G1tensor(17),4)
call Hotf_4pt_reduction_last(G2tensor(5),RedSet_4(2),mass4set(:,3),  & 
G1tensor(21),G1tensor(22),G1tensor(23),G1tensor(24),G1tensor(25))
call G_TensorShift(G1tensor(22),4)
call Hotf_4pt_reduction_last(G2tensor(6),RedSet_4(2),mass4set(:,2),  & 
G1tensor(26),G1tensor(27),G1tensor(28),G1tensor(29),G1tensor(30))
call G_TensorShift(G1tensor(27),4)
call Hotf_4pt_reduction_last(G1tensor(1),RedSet_4(1),mass4set(:,1),  & 
G0tensor(1),G0tensor(2),G0tensor(3),G0tensor(4),G0tensor(5))
call Hotf_4pt_reduction_last(G1tensor(6),RedSet_4(1),mass4set(:,2),  & 
G0tensor(6),G0tensor(7),G0tensor(8),G0tensor(9),G0tensor(10))
call Hotf_4pt_reduction_last(G1tensor(11),RedSet_4(1),mass4set(:,3),  & 
G0tensor(11),G0tensor(12),G0tensor(13),G0tensor(14),G0tensor(15))
call Hotf_4pt_reduction_last(G1tensor(16),RedSet_4(2),mass4set(:,1),  & 
G0tensor(16),G0tensor(17),G0tensor(18),G0tensor(19),G0tensor(20))
call Hotf_4pt_reduction_last(G1tensor(21),RedSet_4(2),mass4set(:,3),  & 
G0tensor(21),G0tensor(22),G0tensor(23),G0tensor(24),G0tensor(25))
call Hotf_4pt_reduction_last(G1tensor(26),RedSet_4(2),mass4set(:,2),  & 
G0tensor(26),G0tensor(27),G0tensor(28),G0tensor(29),G0tensor(30))
call ol_merge_tensors(T0sum(1),[G0tensor(1)])
call ol_merge_tensors(T0sum(2),[G0tensor(6)])
call ol_merge_tensors(T0sum(3),[G0tensor(11)])
call ol_merge_tensors(T0sum(4),[G0tensor(16)])
call ol_merge_tensors(T0sum(5),[G0tensor(21)])
call ol_merge_tensors(T0sum(6),[G0tensor(26)])
Gcoeff(:)%j = (-(c(5)*M(3,:)%j)) * den(1)
call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(11),h0tab(:,11),[8,3,4],[0,0,0],3,1,wf4(:,1))
  call Hloop_VA_Q(ntryL,G0H16(1),ex4(:),G0H8(2),m3h2x8(:,11),heltab2x16(:,:,11))
  call Hloop_A_Q(ntryL,G0H8(2),8,0,G1H8(1),n2h8(1))
Gcoeff(:)%j = (c(10)*M(3,:)%j) * den(2)
call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(12),h0tab(:,12),[8,3,4],[0,0,0],3,1,wf4(:,3))
  call Hloop_VA_Q(ntryL,G0H16(1),ex4(:),G0H8(1),m3h2x8(:,12),heltab2x16(:,:,12))
  call Hloop_A_Q(ntryL,G0H8(1),8,0,G1H8(2),n2h8(2))
Gcoeff(:)%j = (c(2)*M(1,:)%j-c(1)*M(3,:)%j) * den(1)
call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(13),h0tab(:,13),[8,3,4],[0,0,0],3,1,wf4(:,1))
  call Hloop_VA_Q(ntryL,G0H16(1),ex4(:),G0H8(7),m3h2x8(:,13),heltab2x16(:,:,13))
  call Hloop_A_Q(ntryL,G0H8(7),8,0,G1H8(3),n2h8(3))
Gcoeff(:)%j = (c(9)*M(1,:)%j-c(8)*M(3,:)%j) * den(1)
call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(14),h0tab(:,14),[8,3,4],[0,0,nMZ],3,1,wf4(:,1))
  call Hloop_ZA_Q(ntryL,G0H16(1),ex4(:),G0H8(6),ngZd,m3h2x8(:,14),heltab2x16(:,:,14))
  call Hloop_A_Q(ntryL,G0H8(6),8,0,G1H8(4),n2h8(4))
Gcoeff(:)%j = (c(23)*M(1,:)%j-c(22)*M(3,:)%j) * den(1)
call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(15),h0tab(:,15),[8,3,4],[0,0,nMW],3,1,wf4(:,1))
  call Hloop_WA_Q(ntryL,G0H16(1),ex4(:),G0H8(5),m3h2x8(:,15),heltab2x16(:,:,15))
  call Hloop_A_Q(ntryL,G0H8(5),8,0,G1H8(5),n2h8(5))
Gcoeff(:)%j = (-(c(16)*M(2,:)%j)+c(15)*M(4,:)%j) * den(1)
call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(16),h0tab(:,16),[8,3,4],[0,0,0],3,1,wf4(:,1))
  call Hloop_VA_Q(ntryL,G0H16(1),ex4(:),G0H8(3),m3h2x8(:,16),heltab2x16(:,:,16))
  call Hloop_A_Q(ntryL,G0H8(3),8,0,G1H8(6),n2h8(6))
Gcoeff(:)%j = (-(c(12)*M(2,:)%j)+c(11)*M(4,:)%j) * den(1)
call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(17),h0tab(:,17),[8,3,4],[0,0,0],3,1,wf4(:,1))
  call Hloop_QA_V(ntryL,G0H16(1),ex4(:),G0H8(4),m3h2x8(:,17),heltab2x16(:,:,17))
Gcoeff(:)%j = (-(c(27)*M(1,:)%j)+c(26)*M(3,:)%j) * den(3)
call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(18),h0tab(:,18),[12,1,2],[nMT,nMH,nMT],3,1,wf4(:,2))
  call Hloop_AV_Q(ntryL,G0H16(1),wf4(:,2),G0H4(1),m3h4x4(:,1),heltab2x16(:,:,18))
  call Hloop_A_Q(ntryL,G0H4(1),12,nMT,G1H4(1),n2h4(7))
Gcoeff(:)%j = (c(27)*M(1,:)%j-c(26)*M(3,:)%j) * den(3)
call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(19),h0tab(:,19),[12,1,2],[nMT,nMZ,nMT],3,1,wf4(:,2))
  call Hloop_AV_Q(ntryL,G0H16(1),wf4(:,2),G0H4(1),m3h4x4(:,2),heltab2x16(:,:,19))
  call Hloop_A_Q(ntryL,G0H4(1),12,nMT,G1H4(2),n2h4(8))
Gcoeff(:)%j = (c(25)*M(1,:)%j-c(24)*M(3,:)%j) * den(3)
call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(20),h0tab(:,20),[12,1,2],[nMB,nMW,nMB],3,1,wf4(:,2))
  call Hloop_AV_Q(ntryL,G0H16(1),wf4(:,2),G0H4(1),m3h4x4(:,3),heltab2x16(:,:,20))
  call Hloop_A_Q(ntryL,G0H4(1),12,nMB,G1H4(3),n2h4(9))
Gcoeff(:)%j = (-(c(5)*M(3,:)%j)) * den(3)
call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(21),h0tab(:,21),[12,1,2],[nMT,0,nMT],3,1,wf4(:,2))
  call Hloop_AV_Q(ntryL,G0H16(1),wf4(:,2),G0H4(1),m3h4x4(:,4),heltab2x16(:,:,21))
  call Hloop_A_Q(ntryL,G0H4(1),12,nMT,G1H4(4),n2h4(10))
Gcoeff(:)%j = (c(10)*M(3,:)%j) * den(4)
call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(22),h0tab(:,22),[12,1,2],[nMT,0,nMT],3,1,wf4(:,4))
  call Hloop_AZ_Q(ntryL,G0H16(1),wf4(:,4),G0H4(1),ngZu,m3h4x4(:,5),heltab2x16(:,:,22))
  call Hloop_A_Q(ntryL,G0H4(1),12,nMT,G1H4(5),n2h4(11))
Gcoeff(:)%j = (c(7)*M(1,:)%j-c(6)*M(3,:)%j) * den(3)
call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(23),h0tab(:,23),[12,1,2],[nMT,0,nMT],3,1,wf4(:,2))
  call Hloop_AV_Q(ntryL,G0H16(1),wf4(:,2),G0H4(1),m3h4x4(:,6),heltab2x16(:,:,23))
  call Hloop_A_Q(ntryL,G0H4(1),12,nMT,G1H4(6),n2h4(12))
Gcoeff(:)%j = (c(9)*M(1,:)%j-c(8)*M(3,:)%j) * den(3)
call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(24),h0tab(:,24),[12,1,2],[nMT,nMZ,nMT],3,1,wf4(:,2))
  call Hloop_AV_Q(ntryL,G0H16(1),wf4(:,2),G0H4(1),m3h4x4(:,7),heltab2x16(:,:,24))
  call Hloop_A_Q(ntryL,G0H4(1),12,nMT,G1H4(7),n2h4(13))
Gcoeff(:)%j = (c(23)*M(1,:)%j-c(22)*M(3,:)%j) * den(3)
call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(25),h0tab(:,25),[12,1,2],[nMB,nMW,nMB],3,1,wf4(:,2))
  call Hloop_AV_Q(ntryL,G0H16(1),wf4(:,2),G0H4(1),m3h4x4(:,8),heltab2x16(:,:,25))
  call Hloop_A_Q(ntryL,G0H4(1),12,nMB,G1H4(8),n2h4(14))
Gcoeff(:)%j = (-(c(16)*M(2,:)%j)+c(15)*M(4,:)%j) * den(3)
call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(26),h0tab(:,26),[12,1,2],[nMT,0,nMT],3,1,wf4(:,2))
  call Hloop_AV_Q(ntryL,G0H16(1),wf4(:,2),G0H4(1),m3h4x4(:,9),heltab2x16(:,:,26))
  call Hloop_A_Q(ntryL,G0H4(1),12,nMT,G1H4(9),n2h4(15))
Gcoeff(:)%j = (-(c(12)*M(2,:)%j)+c(11)*M(4,:)%j) * den(3)
call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(27),h0tab(:,27),[12,1,2],[0,nMT,0],3,1,wf4(:,2))
  call Hloop_UV_W(ntryL,G0H16(1),0,wf4(:,2),12,G1H4(10),m3h4x4(:,10),heltab2x16(:,:,27))
  call ol_merge(ntryL,G1H8(6),[G1H8(3),G1H8(1)])
  call ol_merge(ntryL,G1H4(9),[G1H4(6),G1H4(5),G1H4(4)])
  call Hloop_AV_Q(ntryL,G1H8(6),wf4(:,1),G1H2(1),m3h4x2(:,1),heltab2x8(:,:,7))
  call Hloop_A_Q(ntryL,G1H2(1),11,0,G2H2(1),n2h2(1))
  call Hloop_AZ_Q(ntryL,G1H8(2),wf4(:,3),G1H2(2),ngZd,m3h4x2(:,2),heltab2x8(:,:,8))
  call Hloop_A_Q(ntryL,G1H2(2),11,0,G2H2(2),n2h2(2))
  call Hloop_AV_Q(ntryL,G1H8(4),wf4(:,1),G1H2(3),m3h4x2(:,3),heltab2x8(:,:,9))
  call Hloop_A_Q(ntryL,G1H2(3),11,0,G2H2(3),n2h2(3))
  call Hloop_AV_Q(ntryL,G1H8(5),wf4(:,1),G1H2(4),m3h4x2(:,4),heltab2x8(:,:,10))
  call Hloop_A_Q(ntryL,G1H2(4),11,0,G2H2(4),n2h2(4))
  call Hloop_UV_W(ntryL,G0H8(4),8,wf4(:,1),3,G1H2(5),m3h4x2(:,5),heltab2x8(:,:,11))
  call Hloop_AQ_S(ntryL,G1H4(1),ex1(:),G1H2(6),ngH,m3h2x2(:,7),heltab2x4(:,:,7))
  call Hloop_AQ_S(ntryL,G1H4(2),ex1(:),G1H2(1),ngX,m3h2x2(:,8),heltab2x4(:,:,8))
  call Hloop_AQ_S(ntryL,G1H4(3),ex1(:),G1H2(2),ngPbt,m3h2x2(:,9),heltab2x4(:,:,9))
  call Hloop_AQ_V(ntryL,G1H4(9),ex1(:),G1H2(3),m3h2x2(:,10),heltab2x4(:,:,10))
  call Hloop_AQ_Z(ntryL,G1H4(7),ex1(:),G1H2(4),ngZu,m3h2x2(:,11),heltab2x4(:,:,11))
  call Hloop_AQ_W(ntryL,G1H4(8),ex1(:),G1H2(7),m3h2x2(:,12),heltab2x4(:,:,12))
  call Hloop_VQ_A(ntryL,G1H4(10),ex1(:),G1H2(8),m3h2x2(:,13),heltab2x4(:,:,13))
  call Hloop_Q_A(ntryL,G1H2(8),13,nMT,G2H2(5),n2h2(5))
  call ol_merge(ntryL,G2H2(2),[G2H2(1)])
  call Hcheck_last_AQ_V(ntryL,l_switch,G2H2(2),ex3(:),G2tensor(1),m3h2x1(:,7),heltab2x2(:,:,7))
  call Hcheck_last_AQ_Z(ntryL,l_switch,G2H2(3),ex3(:),G2tensor(2),ngZd,m3h2x1(:,8),heltab2x2(:,:,8))
  call Hcheck_last_AQ_W(ntryL,l_switch,G2H2(4),ex3(:),G2tensor(3),m3h2x1(:,9),heltab2x2(:,:,9))
  call Hloop_VQ_A(ntryL,G1H2(5),ex3(:),G1H1(1),m3h2x1(:,10),heltab2x2(:,:,10))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),15,0,G2tensor(4),n2h1(7))
  call Hloop_SA_Q(ntryL,G1H2(6),ex2(:),G1H1(1),ngH,m3h2x1(:,11),heltab2x2(:,:,11))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),15,nMT,G2tensor(5),n2h1(8))
  call Hloop_SA_Q(ntryL,G1H2(1),ex2(:),G1H1(1),ngX,m3h2x1(:,12),heltab2x2(:,:,12))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),15,nMT,G2tensor(6),n2h1(9))
  call Hloop_SA_Q(ntryL,G1H2(2),ex2(:),G1H1(1),ngPtb,m3h2x1(:,13),heltab2x2(:,:,13))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),15,nMB,G2tensor(7),n2h1(10))
  call Hloop_VA_Q(ntryL,G1H2(3),ex2(:),G1H1(1),m3h2x1(:,14),heltab2x2(:,:,14))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),15,nMT,G2tensor(8),n2h1(11))
  call Hloop_ZA_Q(ntryL,G1H2(4),ex2(:),G1H1(1),ngZu,m3h2x1(:,15),heltab2x2(:,:,15))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),15,nMT,G2tensor(9),n2h1(12))
  call Hloop_WA_Q(ntryL,G1H2(7),ex2(:),G1H1(1),m3h2x1(:,16),heltab2x2(:,:,16))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),15,nMB,G2tensor(10),n2h1(13))
  call Hcheck_last_QA_V(ntryL,l_switch,G2H2(5),ex2(:),G2tensor(11),m3h2x1(:,17),heltab2x2(:,:,17))
  call ol_merge_tensors(G1tensor(2),[G0tensor(2)])
  call ol_merge_tensors(G1tensor(13),[G1tensor(3),G0tensor(13),G0tensor(3)])
  call ol_merge_tensors(G2tensor(4),[G2tensor(1),G1tensor(19),G1tensor(4),G0tensor(19),G0tensor(4)])
  call ol_merge_tensors(G1tensor(10),[G1tensor(5),G0tensor(10),G0tensor(5)])
  call ol_merge_tensors(G1tensor(7),[G0tensor(7)])
  call ol_merge_tensors(G1tensor(8),[G0tensor(8)])
  call ol_merge_tensors(G1tensor(29),[G1tensor(9),G0tensor(29),G0tensor(9)])
  call ol_merge_tensors(G1tensor(12),[G0tensor(12)])
  call ol_merge_tensors(G1tensor(24),[G1tensor(14),G0tensor(24),G0tensor(14)])
  call ol_merge_tensors(G1tensor(15),[G0tensor(15)])
  call ol_merge_tensors(G2tensor(11),[G1tensor(17),G0tensor(17)])
  call ol_merge_tensors(G1tensor(23),[G1tensor(18),G0tensor(23),G0tensor(18)])
  call ol_merge_tensors(G1tensor(30),[G1tensor(20),G0tensor(30),G0tensor(20)])
  call ol_merge_tensors(G1tensor(22),[G0tensor(22)])
  call ol_merge_tensors(G1tensor(25),[G0tensor(25)])
  call ol_merge_tensors(G1tensor(27),[G0tensor(27)])
  call ol_merge_tensors(G1tensor(28),[G0tensor(28)])
  call ol_merge_tensors(G2tensor(9),[G2tensor(6)])
  call ol_merge_tensors(G2tensor(10),[G2tensor(7)])
call TI_triangle_red(G2tensor(4),RedBasis(2),mass3set(:,1),G0tensor(1),G0tensor(6),G0tensor(11),G0tensor(16),M2L1R1)
call TI_triangle_red(G2tensor(11),RedBasis(6),mass3set(:,2),G0tensor(21),G0tensor(26),G0tensor(2),G0tensor(13),M2L1R1,[nMT], &
    G0tensor(3))
call TI_triangle_red(G2tensor(2),RedBasis(2),mass3set(:,3),G0tensor(19),G0tensor(4),G0tensor(10),G0tensor(5),M2L1R1,[nMZ], &
    G0tensor(7))
call TI_triangle_red(G2tensor(3),RedBasis(2),mass3set(:,4),G0tensor(8),G0tensor(29),G0tensor(9),G0tensor(12),M2L1R1,[nMW], &
    G0tensor(24))
call TI_triangle_red(G2tensor(5),RedBasis(6),mass3set(:,5),G0tensor(14),G0tensor(15),G0tensor(17),G0tensor(23),M2L1R1,[nMT,nMH], &
    G0tensor(18),G0tensor(30))
call TI_triangle_red(G2tensor(9),RedBasis(6),mass3set(:,6),G0tensor(20),G0tensor(22),G0tensor(25),G0tensor(27),M2L1R1,[nMT,nMZ], &
    G0tensor(28),G0tensor(31))
call TI_triangle_red(G2tensor(10),RedBasis(6),mass3set(:,7),G0tensor(32),G0tensor(33),G0tensor(34),G0tensor(35),M2L1R1,[nMB,nMW], &
    G0tensor(36),G0tensor(37))
call TI_triangle_red(G2tensor(8),RedBasis(6),mass3set(:,8),G0tensor(38),G0tensor(39),G0tensor(40),G0tensor(41),M2L1R1,[nMT], &
    G0tensor(42))
call TI_triangle_red(G1tensor(2),RedBasis(7),mass3set(:,2),G0tensor(43),G0tensor(44),G0tensor(45),G0tensor(46),M2L1R1,[nMT], &
    G0tensor(47))
call TI_triangle_red(G1tensor(13),RedBasis(3),mass3set(:,9),G0tensor(48),G0tensor(49),G0tensor(50),G0tensor(51),M2L1R1,[nMT], &
    G0tensor(52))
call TI_triangle_red(G1tensor(10),RedBasis(1),mass3set(:,2),G0tensor(53),G0tensor(54),G0tensor(55),G0tensor(56),M2L1R1,[nMT], &
    G0tensor(57))
call TI_triangle_red(G1tensor(7),RedBasis(7),mass3set(:,10),G0tensor(58),G0tensor(59),G0tensor(60),G0tensor(61),M2L1R1,[nMZ,nMT], &
    G0tensor(62),G0tensor(63))
call TI_triangle_red(G1tensor(8),RedBasis(3),mass3set(:,11),G0tensor(64),G0tensor(65),G0tensor(66),G0tensor(67),M2L1R1,[nMT,nMZ], &
    G0tensor(68),G0tensor(69))
call TI_triangle_red(G1tensor(29),RedBasis(2),mass3set(:,12),G0tensor(70),G0tensor(71),G0tensor(72),G0tensor(73),M2L1R1,[nMZ], &
    G0tensor(74))
call TI_triangle_red(G1tensor(12),RedBasis(7),mass3set(:,13),G0tensor(75),G0tensor(76),G0tensor(77),G0tensor(78),M2L1R1,[nMZ,nMT], &
    G0tensor(79),G0tensor(80))
call TI_triangle_red(G1tensor(24),RedBasis(2),mass3set(:,14),G0tensor(81),G0tensor(82),G0tensor(83),G0tensor(84),M2L1R1,[nMZ], &
    G0tensor(85))
call TI_triangle_red(G1tensor(15),RedBasis(1),mass3set(:,13),G0tensor(86),G0tensor(87),G0tensor(88),G0tensor(89),M2L1R1,[nMZ,nMT], &
    G0tensor(90),G0tensor(91))
call TI_triangle_red(G1tensor(23),RedBasis(5),mass3set(:,9),G0tensor(92),G0tensor(93),G0tensor(94),G0tensor(95),M2L1R1,[nMT], &
    G0tensor(96))
call TI_triangle_red(G1tensor(30),RedBasis(4),mass3set(:,2),G0tensor(97),G0tensor(98),G0tensor(99),G0tensor(100),M2L1R1,[nMT], &
    G0tensor(101))
call TI_triangle_red(G1tensor(22),RedBasis(6),mass3set(:,13),G0tensor(102),G0tensor(103),G0tensor(104), &
    G0tensor(105),M2L1R1,[nMZ,nMT],G0tensor(106),G0tensor(107))
call TI_triangle_red(G1tensor(25),RedBasis(4),mass3set(:,13),G0tensor(108),G0tensor(109),G0tensor(110), &
    G0tensor(111),M2L1R1,[nMZ,nMT],G0tensor(112),G0tensor(113))
call TI_triangle_red(G1tensor(27),RedBasis(6),mass3set(:,10),G0tensor(114),G0tensor(115),G0tensor(116), &
    G0tensor(117),M2L1R1,[nMZ,nMT],G0tensor(118),G0tensor(119))
call TI_triangle_red(G1tensor(28),RedBasis(5),mass3set(:,11),G0tensor(120),G0tensor(121),G0tensor(122), &
    G0tensor(123),M2L1R1,[nMT,nMZ],G0tensor(124),G0tensor(125))
call ol_merge_tensors(T0sum(7),[G0tensor(43)])
call ol_merge_tensors(T0sum(8),[G0tensor(48)])
call ol_merge_tensors(T0sum(9),[G0tensor(1)])
call ol_merge_tensors(T0sum(10),[G0tensor(53)])
call ol_merge_tensors(T0sum(11),[G0tensor(58)])
call ol_merge_tensors(T0sum(12),[G0tensor(64)])
call ol_merge_tensors(T0sum(13),[G0tensor(70)])
call ol_merge_tensors(T0sum(14),[G0tensor(75)])
call ol_merge_tensors(T0sum(15),[G0tensor(81)])
call ol_merge_tensors(T0sum(16),[G0tensor(86)])
call ol_merge_tensors(T0sum(17),[G0tensor(21)])
call ol_merge_tensors(T0sum(18),[G0tensor(92)])
call ol_merge_tensors(T0sum(19),[G0tensor(97)])
call ol_merge_tensors(T0sum(20),[G0tensor(102)])
call ol_merge_tensors(T0sum(21),[G0tensor(108)])
call ol_merge_tensors(T0sum(22),[G0tensor(114)])
call ol_merge_tensors(T0sum(23),[G0tensor(120)])
call ol_merge_tensors(T0sum(24),[G0tensor(19)])
call ol_merge_tensors(T0sum(25),[G0tensor(8)])
call ol_merge_tensors(T0sum(26),[G0tensor(14)])
call ol_merge_tensors(T0sum(27),[G0tensor(20)])
call ol_merge_tensors(T0sum(28),[G0tensor(32)])
call ol_merge_tensors(T0sum(29),[G0tensor(38)])
Gcoeff(:)%j = (-(c(31)*M(2,:)%j)+c(30)*M(4,:)%j) * den(5)
call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(28),h0tab(:,28),[12,3],[0,0],2,2,wf4(:,2),wf4(:,1))
  call Hloop_QV_A(ntryL,G0H16(1),wf4(:,2),G0H4(1),m3h4x4(:,11),heltab2x16(:,:,28))
  call Hloop_Q_A(ntryL,G0H4(1),12,0,G1H4(6),n2h4(16))
Gcoeff(:)%j = (-(c(29)*M(2,:)%j)+c(28)*M(4,:)%j) * den(5)
call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(29),h0tab(:,29),[12,3],[nMT,nMT],2,2,wf4(:,2),wf4(:,1))
  call Hloop_QV_A(ntryL,G0H16(1),wf4(:,2),G0H4(1),m3h4x4(:,12),heltab2x16(:,:,29))
  call Hloop_Q_A(ntryL,G0H4(1),12,nMT,G1H4(5),n2h4(17))
Gcoeff(:)%j = (-(c(31)*M(2,:)%j)+c(30)*M(4,:)%j) * den(5)
call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(30),h0tab(:,30),[12,3],[0,0],2,2,wf4(:,2),wf4(:,1))
  call Hloop_QV_A(ntryL,G0H16(1),wf4(:,2),G0H4(1),m3h4x4(:,13),heltab2x16(:,:,30))
  call Hloop_Q_A(ntryL,G0H4(1),12,0,G1H4(4),n2h4(18))
Gcoeff(:)%j = (-(c(29)*M(2,:)%j)+c(28)*M(4,:)%j) * den(5)
call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(31),h0tab(:,31),[12,3],[nMB,nMB],2,2,wf4(:,2),wf4(:,1))
  call Hloop_QV_A(ntryL,G0H16(1),wf4(:,2),G0H4(1),m3h4x4(:,14),heltab2x16(:,:,31))
  call Hloop_Q_A(ntryL,G0H4(1),12,nMB,G1H4(1),n2h4(19))
Gcoeff(:)%j = (-(c(21)*M(2,:)%j)+c(19)*M(4,:)%j) * den(5)
call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(32),h0tab(:,32),[12,3],[0,0],2,2,wf4(:,2),wf4(:,1))
  call Hloop_CV_D(ntryL,G0H16(1),0,wf4(:,2),12,G1H4(2),m3h4x4(:,15),heltab2x16(:,:,32))
Gcoeff(:)%j = (c(14)*M(2,:)%j-c(13)*M(4,:)%j) * den(5)
call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(33),h0tab(:,33),[12,3],[0,0],2,2,wf4(:,2),wf4(:,1))
  call Hloop_UV_W(ntryL,G0H16(1),0,wf4(:,2),12,G1H4(3),m3h4x4(:,16),heltab2x16(:,:,33))
  call ol_merge(ntryL,G1H4(4),[G1H4(6)])
  call Hloop_QV_A(ntryL,G1H4(4),wf4(:,1),G1H1(1),m3h4x1(:,1),heltab2x4(:,:,14))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),15,0,G2tensor(1),n2h1(14))
  call Hloop_QV_A(ntryL,G1H4(5),wf4(:,1),G1H1(1),m3h4x1(:,2),heltab2x4(:,:,15))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),15,nMT,G2tensor(6),n2h1(15))
  call Hloop_QV_A(ntryL,G1H4(1),wf4(:,1),G1H1(1),m3h4x1(:,3),heltab2x4(:,:,16))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),15,nMB,G2tensor(7),n2h1(16))
  call Hcheck_last_CV_D(ntryL,l_switch,G1H4(2),12,wf4(:,1),3,G2tensor(4),m3h4x1(:,4),heltab2x4(:,:,17))
  call Hcheck_last_UV_W(ntryL,l_switch,G1H4(3),12,wf4(:,1),3,G2tensor(11),m3h4x1(:,5),heltab2x4(:,:,18))
  call ol_merge_tensors(G2tensor(11),[G2tensor(4),G2tensor(1),G0tensor(46),G0tensor(29),G0tensor(4),G0tensor(13),G0tensor(6)])
  call ol_merge_tensors(G0tensor(94),[G0tensor(83),G0tensor(50),G0tensor(11)])
  call ol_merge_tensors(G0tensor(100),[G0tensor(73),G0tensor(56),G0tensor(16)])
  call ol_merge_tensors(G0tensor(115),[G0tensor(98),G0tensor(26)])
  call ol_merge_tensors(G0tensor(104),[G0tensor(93),G0tensor(2)])
  call ol_merge_tensors(G0tensor(124),[G0tensor(119),G0tensor(113),G0tensor(107),G0tensor(101),G0tensor(96),G0tensor(91) &
    ,G0tensor(80),G0tensor(68),G0tensor(63),G0tensor(57),G0tensor(52),G0tensor(47),G0tensor(42),G0tensor(28),G0tensor(18) &
    ,G0tensor(3)])
  call ol_merge_tensors(G0tensor(125),[G0tensor(118),G0tensor(112),G0tensor(106),G0tensor(90),G0tensor(85),G0tensor(79) &
    ,G0tensor(74),G0tensor(69),G0tensor(62),G0tensor(31),G0tensor(7)])
  call ol_merge_tensors(G0tensor(37),[G0tensor(24)])
  call ol_merge_tensors(G2tensor(6),[G0tensor(41),G0tensor(27),G0tensor(23)])
  call ol_merge_tensors(G0tensor(65),[G0tensor(60),G0tensor(22)])
  call ol_merge_tensors(G0tensor(87),[G0tensor(76),G0tensor(25)])
  call ol_merge_tensors(G2tensor(7),[G0tensor(35)])
  call ol_merge_tensors(G0tensor(77),[G0tensor(49),G0tensor(45),G0tensor(39)])
  call ol_merge_tensors(G0tensor(59),[G0tensor(54),G0tensor(44),G0tensor(40)])
  call ol_merge_tensors(G0tensor(88),[G0tensor(67),G0tensor(55),G0tensor(51)])
  call ol_merge_tensors(G0tensor(117),[G0tensor(71),G0tensor(61)])
  call ol_merge_tensors(G0tensor(122),[G0tensor(72),G0tensor(66)])
  call ol_merge_tensors(G0tensor(105),[G0tensor(82),G0tensor(78)])
  call ol_merge_tensors(G0tensor(111),[G0tensor(89),G0tensor(84)])
  call ol_merge_tensors(G0tensor(123),[G0tensor(110),G0tensor(99),G0tensor(95)])
  call ol_merge_tensors(G0tensor(109),[G0tensor(103)])
  call ol_merge_tensors(G0tensor(121),[G0tensor(116)])
call TI_bubble_red(G2tensor(11),12,mass2set(:,1),G0tensor(43),M2L1R1)
call TI_bubble_red(G2tensor(6),12,mass2set(:,2),G0tensor(48),M2L1R1,G0tensor(1))
call TI_bubble_red(G2tensor(7),12,mass2set(:,3),G0tensor(53),M2L1R1,G0tensor(58))
  call ol_merge_tensors(G0tensor(1),[G0tensor(124)])
  call ol_merge_tensors(G0tensor(36),[G0tensor(58)])
call ol_merge_tensors(T0sum(30),[G0tensor(43)])
call ol_merge_tensors(T0sum(31),[G0tensor(94)])
call ol_merge_tensors(T0sum(32),[G0tensor(100)])
call ol_merge_tensors(T0sum(33),[G0tensor(115)])
call ol_merge_tensors(T0sum(34),[G0tensor(104)])
call ol_merge_tensors(T0sum(35),[G0tensor(1)])
call ol_merge_tensors(T0sum(36),[G0tensor(10)])
call ol_merge_tensors(T0sum(37),[G0tensor(5)])
call ol_merge_tensors(T0sum(38),[G0tensor(125)])
call ol_merge_tensors(T0sum(39),[G0tensor(9)])
call ol_merge_tensors(T0sum(40),[G0tensor(12)])
call ol_merge_tensors(T0sum(41),[G0tensor(37)])
call ol_merge_tensors(T0sum(42),[G0tensor(15)])
call ol_merge_tensors(T0sum(43),[G0tensor(17)])
call ol_merge_tensors(T0sum(44),[G0tensor(48)])
call ol_merge_tensors(T0sum(45),[G0tensor(30)])
call ol_merge_tensors(T0sum(46),[G0tensor(65)])
call ol_merge_tensors(T0sum(47),[G0tensor(87)])
call ol_merge_tensors(T0sum(48),[G0tensor(33)])
call ol_merge_tensors(T0sum(49),[G0tensor(34)])
call ol_merge_tensors(T0sum(50),[G0tensor(53)])
call ol_merge_tensors(T0sum(51),[G0tensor(36)])
call ol_merge_tensors(T0sum(52),[G0tensor(77)])
call ol_merge_tensors(T0sum(53),[G0tensor(59)])
call ol_merge_tensors(T0sum(54),[G0tensor(88)])
call ol_merge_tensors(T0sum(55),[G0tensor(117)])
call ol_merge_tensors(T0sum(56),[G0tensor(122)])
call ol_merge_tensors(T0sum(57),[G0tensor(105)])
call ol_merge_tensors(T0sum(58),[G0tensor(111)])
call ol_merge_tensors(T0sum(59),[G0tensor(123)])
call ol_merge_tensors(T0sum(60),[G0tensor(109)])
call ol_merge_tensors(T0sum(61),[G0tensor(121)])
! end of process


end subroutine vamp_1

end module ol_vamp_1_pptt_ew_ttxddx_1_/**/REALKIND
