
module ol_colourmatrix_pptt_ttxgg_1_/**/REALKIND
  use KIND_TYPES, only: REALKIND
  implicit none
  logical, save           :: colmat_not_initialised = .true.
  complex(REALKIND), save :: K1(24,2), K2(2,2), KL(2,3)
  contains
  subroutine colourmatrix_init
    use ol_parameters_decl_/**/REALKIND, only: CI
    implicit none
    colmat_not_initialised = .false.
    ! colour matrix

  K1( 1,:) = [  48,  -6]
  K1( 2,:) = [  -6,  48]
  K1( 3,:) = [  64,  -8]
  K1( 4,:) = [  -8,  64]
  K1( 5,:) = [  -1, -10]
  K1( 6,:) = [ -10,  -1]
  K1( 7,:) = [  64,  -8]
  K1( 8,:) = [  -8,  64]
  K1( 9,:) = [   9,   9]
  K1(10,:) = [   9, -72]
  K1(11,:) = [ -72,   9]
  K1(12,:) = [   9,   9]
  K1(13,:) = [ 144, -18]
  K1(14,:) = [ -18, 144]
  K1(15,:) = [ -72,   9]
  K1(16,:) = [   9,   9]
  K1(17,:) = [   9,   9]
  K1(18,:) = [   9, -72]
  K1(19,:) = [ -81,   0]
  K1(20,:) = [   0, -81]
  K1(21,:) = [ 144, -18]
  K1(22,:) = [ -18, 144]
  K1(23,:) = [   0,   0]
  K1(24,:) = [   0,   0]
  K1 = (1._/**/REALKIND / 9) * K1

  K2(1,:) = [ 16, -2]
  K2(2,:) = [ -2, 16]
  K2 = (1._/**/REALKIND / 3) * K2

  KL(1,:) = [ 16, -2,  6]
  KL(2,:) = [ -2, 16,  6]
  KL = (1._/**/REALKIND / 3) * KL

  end subroutine colourmatrix_init
end module ol_colourmatrix_pptt_ttxgg_1_/**/REALKIND



module ol_forced_parameters_pptt_ttxgg_1_/**/REALKIND
  implicit none
  contains
  subroutine check_forced_parameters
    use ol_parameters_decl_/**/REALKIND
    use ol_loop_parameters_decl_/**/REALKIND
#ifndef PRECISION_dp
    use ol_loop_parameters_decl_/**/DREALKIND, only: LeadingColour, nc, nf, CKMORDER
#endif
    implicit none
    logical, save :: checks_not_written = .true.

    if (checks_not_written) then
    ! e.g.
    ! if (ME /= 0) write(*,101) 'ME = 0'
  if (CKMORDER /= 0) write(*,101) 'CKMORDER = 0'
  if (nc /= 3) write(*,101) 'nc = 3'
  if (nf /= 6) write(*,101) 'nf = 6'
  if (MU /= 0) write(*,101) 'MU = 0'
  if (MD /= 0) write(*,101) 'MD = 0'
  if (MS /= 0) write(*,101) 'MS = 0'
  if (MC /= 0) write(*,101) 'MC = 0'
  if (LeadingColour /= 0) write(*,101) 'LeadingColour = 0'
  if (wMT /= 0) write(*,101) 'wMT = 0'
  if (wMT /= 0) write(*,101) 'wMT = 0'


    checks_not_written = .false.
    end if

    101 format('[OpenLoops] === WARNING ===',/,'[OpenLoops] code was generated with ',A,/,'[OpenLoops] ===============')
  end subroutine check_forced_parameters
end module ol_forced_parameters_pptt_ttxgg_1_/**/REALKIND
! **********************************************************************
module ol_loop_storage_pptt_ttxgg_1_/**/REALKIND
! **********************************************************************
  use KIND_TYPES, only: REALKIND, intkind1, intkind2  
  use ol_data_types_/**/REALKIND, only: wfun, Hpolcont
  
#ifdef PRECISION_dp
  integer(intkind1), save :: ntry = 1, ntryL = 1
  integer(intkind1), save :: p_switch = 0 ! switch for dp or qp. Used for memory allocation of the OL types 
  ! the following are flags for memory allocation of the hol coefficients in dp or qp 
  logical, save :: dp_not_alloc = .TRUE., qp_not_alloc = .TRUE.
  integer(intkind2), parameter :: nheltot = 16 ! number of helicity configurations
  integer(intkind2), save :: nhel = 16 ! number of non-vanishing helicity configurations (adapted at runtime)
  integer(intkind2), save :: Hel(16) ! physical helicity states
#endif

  complex(REALKIND), save :: den(9)

  ! external wave functions ex1(h1),... for h<n> helicities
  type(wfun) :: ex1(2), ex2(2), ex3(2), ex4(2)

  ! wf<h>(h,n) n wave functions with h helicity configurations
  type(wfun) :: wf4(4,19), wf16(16,12)

  ! diagram prefactors
  integer,           save :: fac_status_loop1 = -1, fac_status_loop2 = -1
  complex(REALKIND), save :: f(14), c(16)

  !Vector in helicity and colour space for Born-Loop interference
  type(Hpolcont),   save :: M0_col1_helarray(3,16)

end module ol_loop_storage_pptt_ttxgg_1_/**/REALKIND






! **********************************************************************
module ol_loop_pptt_ttxgg_1_/**/REALKIND
! **********************************************************************
  use KIND_TYPES, only: REALKIND, DREALKIND, intkind1, intkind2  
  use ol_data_types_/**/REALKIND, only: wfun, Hpolcont
  use ol_loop_storage_pptt_ttxgg_1_/**/REALKIND
  implicit none

!*********************************************************************************
  contains

! **********************************************************************
subroutine fac_init_loop()
! Writes diagram prefactors to 'f', rsp. 'c'
! **********************************************************************
  use ol_parameters_decl_/**/REALKIND
  use ol_loop_parameters_decl_/**/REALKIND
  use ol_init, only: set_parameter, tree_parameters_flush, parameters_flush
#ifndef PRECISION_dp
  use ol_loop_parameters_decl_/**/DREALKIND, only: SwF, SwB
!  use ol_loop_parameters_decl_/**/DREALKIND, only: DOI
#endif
  implicit none
  call set_parameter("ew_renorm", 0)
  if (parameters_status == 0) call tree_parameters_flush()
  if (loop_parameters_status == 0) call parameters_flush()
  fac_status_loop1 = parameters_status
  fac_status_loop2 = loop_parameters_status
  ! factors of the diagrams
    f( 1) = CI*gQCD**2
    f( 2) = gQCD**2
    f( 3) = CI*countertermnorm*gQCD**4
    f( 4) = countertermnorm*gQCD**4
    f( 5) = CI*countertermnorm*ctGtt*gQCD**4
    f( 6) = countertermnorm*ctGtt*gQCD**4
    f( 7) = countertermnorm*ctVVV*gQCD**4
    f( 8) = (CI*gQCD**4*integralnorm*SwB)/2._/**/REALKIND
    f( 9) = CI*gQCD**4*integralnorm*SwB
    f(10) = gQCD**4*integralnorm*SwB
    f(11) = CI*gQCD**4*integralnorm*SwF
    f(12) = 2*CI*gQCD**4*integralnorm*SwF
    f(13) = gQCD**4*integralnorm*SwF
    f(14) = 2*gQCD**4*integralnorm*SwF

  c = [ 9*CI*f(8), 18*CI*f(8), CI*f(9), 3*CI*f(9), 9*CI*f(9), 18*CI*f(9), f(10), 3*f(10), 8*f(10), 9*f(10), 3*CI*f(11), 3*CI*f(12) &
    , f(13), 3*f(13), f(14), 3*f(14) ]
  c = (1._/**/REALKIND / 6) * c
end subroutine fac_init_loop

subroutine denominators()
  use ol_parameters_decl_/**/REALKIND ! masses
  use ol_momenta_decl_/**/REALKIND, only: L
  implicit none
  ! propagators
  den(1) = 1 /((L(5,3))+L(6,3))
  den(2) = 1 /((L(5,5) - MT2)+L(6,5))
  den(3) = 1 /((L(5,9) - MT2)+L(6,9))
  den(4) = 1 /((L(5,6) - MT2)+L(6,6))
  den(5) = 1 /((L(5,10) - MT2)+L(6,10))
  den(6) = 1 /((L(5,12))+L(6,12))

  ! denominators
  den(7) = den(1)*den(6)
  den(8) = den(2)*den(5)
  den(9) = den(3)*den(4)

end subroutine denominators

!
!
!
!
!
! **********************************************************************
#ifdef PRECISION_dp
subroutine amp2(P_scatt, M02, M2ct, M2colint, qp_kinematics)
#else
subroutine amp2(P_scatt, M02, M2ct, M2colint, qp_kinematics)
  use ol_loop_storage_pptt_ttxgg_1_/**/DREALKIND, only: ntry, nhel, Hel
#endif
! P_scatt(0:3,Npart) = incoming external momenta
! M2  = helicity-summed squared matrix element for top anti-top glue glue -> 0
! **********************************************************************
  use ol_parameters_decl_/**/REALKIND !, only: ci, parameters_status, ZERO, scalefactor, >masses<
  use ol_parameters_init_/**/REALKIND, only: ensure_mp_init
  use ol_kinematics_/**/REALKIND, only: init_kinematics
  use ol_momenta_decl_/**/DREALKIND, only: momenta_nan_check
  use ol_data_types_/**/REALKIND
  use ol_h_helicity_bookkeeping_/**/REALKIND, only: &
    & helbookkeeping_wf, helsync, flip_phase
  use ol_helicity_init, only: helbookkeeping_flip, helsync_flip
  use ol_hel_propagators_/**/REALKIND
  use ol_hel_wavefunctions_/**/REALKIND
  use ol_wavefunctions_/**/REALKIND, only: wf_V_Std
  use ol_hel_vertices_/**/REALKIND
  use ol_hel_contractions_/**/REALKIND
  use ol_external_pptt_ttxgg_1, only: external_perm_pptt_ttxgg_1, &
    & external_perm_inv_pptt_ttxgg_1, extcomb_perm_pptt_ttxgg_1, &
    & average_factor_pptt_ttxgg_1
  use ol_external_pptt_ttxgg_1, only: H, hel_not_initialised, hel_init, POLSEL
  use ol_colourmatrix_pptt_ttxgg_1_/**/REALKIND, only: colmat_not_initialised, colourmatrix_init
  use ol_forced_parameters_pptt_ttxgg_1_/**/REALKIND, only: check_forced_parameters
  use ol_heltables_OLR_pptt_ttxgg_1
  use ol_kinematics_/**/REALKIND, only: LC2Std_Rep_cmplx
  use ol_h_counterterms_/**/REALKIND
  use ol_loop_parameters_decl_/**/REALKIND ! counterterms
  use ol_loop_parameters_decl_/**/DREALKIND, only: IR_is_on
  use ol_init, only: set_parameter, parameters_flush
#ifdef PRECISION_dp
  use ol_kinematics_/**/QREALKIND, only: conv_mom_scatt2in_qp=>conv_mom_scatt2in, &
                                         internal_momenta_qp=>internal_momenta
  use ol_momenta_decl_/**/DREALKIND, only: L
  use ol_momenta_decl_/**/QREALKIND, only: L_qp=>L
#endif
  implicit none

  real(DREALKIND), intent(in)  :: P_scatt(0:3,4)
  real(REALKIND),  intent(out) :: M02, M2ct, M2colint(11)
  logical, intent(in) :: qp_kinematics

  integer           :: shift, k, r, m, n
  real(REALKIND)    :: P(0:3,4)
#ifdef PRECISION_dp
  real(QREALKIND)    :: P_qp(0:3,4)
#endif
  integer           :: extmasses2(4)
  real(REALKIND)    :: M2add, M2add_ct, M2add_colint(11)
  complex(REALKIND) :: M1(2), M2(2) 
  real(REALKIND)    :: P_scatt_intern(0:3,4)
  real(REALKIND), save :: scalebackfactor, old_scalefactor = 0
  integer(intkind1) :: nsync
  type(Hpolcont),   save :: M1helarray(2,16)
  type(Hpolcont) :: M1helarray_ct(2,16)

  type(Hpolcont) :: A(16,12)

  !Aj are not used at the moment
  !complex(REALKIND) :: Aj(12)

  complex(REALKIND) :: omega(2) ! phases for helicity correlations

  call set_parameter("ew_renorm", 0)
  call parameters_flush()
  call ensure_mp_init()

  if (colmat_not_initialised) call colourmatrix_init()

  if (fac_status_loop1 /= parameters_status .or. fac_status_loop2 /= loop_parameters_status) then
    ! Note: if fac_init would only be called when parameters changed which are relevant for the factors,
    ! a different 'status' would have to be used, because forced_parameters should be called after every parameter change.
    call check_forced_parameters()
    call fac_init_loop()
  end if

  if (momenta_nan_check(P_scatt) /= 0) then
    M02 = 0
    return
  end if

  extmasses2 = [ nMT, nMT, 0, 0 ]
  ! Convert 2 -> n-2 PS-point to n -> 0 (so that P(1) + ... + P(n) = 0) and compute
  ! internal-propagator momenta in light-cone representation
  call init_kinematics(P_scatt, extmasses2, P, external_perm_inv_pptt_ttxgg_1, 4, qp_kinematics)

  ! denominators
  call denominators()

   if (heltables_not_init) call init_heltables()

  ! external WFs
  ! Here the external wavefunctions are initialiased
  call pol_wf_Q(P(:,1), rMT, H1, ex1, POLSEL(1),1)
  call pol_wf_A(P(:,2), rMT, H2, ex2, POLSEL(2),2)
  call pol_wf_V(P(:,3), rZERO, H3, ex3, POLSEL(3),3)
  call pol_wf_V(P(:,4), rZERO, H4, ex4, POLSEL(4),4)



  ! internal WFs
  ! e.g. call vert_VQ_A(ntry, ex3, ex1, wf1, n1, t1) ...
  call vert_QA_V(ntry, ex1(:), ex2(:), wf4(:,1), n3(:,1), t3x4(:,:,1))
  call vert_UV_W(ntry, ex3(:), 4, ex4(:), 8, wf4(:,2), n3(:,2), t3x4(:,:,2))
  call vert_VQ_A(ntry, ex3(:), ex1(:), wf4(:,3), n3(:,3), t3x4(:,:,3))
  call vert_AV_Q(ntry, ex2(:), ex4(:), wf4(:,4), n3(:,4), t3x4(:,:,4))
  call prop_Q_A(ntry, wf4(:,3), 5, MT, 1_intkind1, wf4(:,5), n2(1))
  call vert_VQ_A(ntry, ex4(:), ex1(:), wf4(:,6), n3(:,5), t3x4(:,:,5))
  call vert_AV_Q(ntry, ex2(:), ex3(:), wf4(:,7), n3(:,6), t3x4(:,:,6))
  call prop_Q_A(ntry, wf4(:,6), 9, MT, 1_intkind1, wf4(:,8), n2(2))
  call counter_UV_W(ntry, ex3(:), 4, ex4(:), 8, wf4(:,9), n3(:,7), t3x4(:,:,7))
  call counter_AV_Q(ntry, ex2(:), ex4(:), wf4(:,10), n3(:,8), t3x4(:,:,8))
  call counter_AV_Q(ntry, ex2(:), ex3(:), wf4(:,11), n3(:,9), t3x4(:,:,9))
  call counter_VQ_A(ntry, ex4(:), ex1(:), wf4(:,12), n3(:,10), t3x4(:,:,10))
  call prop_A_Q(ntry, wf4(:,7), 6, MT, 1_intkind1, wf4(:,13), n2(3))
  call counter_VQ_A(ntry, ex3(:), ex1(:), wf4(:,14), n3(:,11), t3x4(:,:,11))
  call prop_A_Q(ntry, wf4(:,4), 10, MT, 1_intkind1, wf4(:,15), n2(4))
  call counter_QA_V(ntry, ex1(:), ex2(:), wf4(:,16), n3(:,12), t3x4(:,:,12))
  call counter_V_V(ctGG,21,ntry, wf4(:,1), 3, wf4(:,17), n2(5))
  call counter_Q_A(cttt,6,ntry, wf4(:,5), 5, wf4(:,18), n2(6))
  call counter_Q_A(cttt,6,ntry, wf4(:,8), 9, wf4(:,19), n2(7))


  call init_hybrid_exwf(ex1)
  call init_hybrid_exwf(ex2)
  call init_hybrid_exwf(ex3)
  call init_hybrid_exwf(ex4)
  call init_hybrid_wf(wf4)


  if (ntry==1) then
    call physical_helicities()
  end if

  ! computation of the colour-stripped amplitudes
  do nsync = ntry+ntry-1, ntry+1  !  nsync = 1,2  for 1st point and nsync = 3 later
    call diagrams()
    if (nsync == 1) call helsync(nsync, A, nhel, Hel)
  end do

  ! In the following loop the coefficients \Gamma_{i} of the expansion in
  ! the colour basis are computed for every helicity state and stored in M1helarray.
  ! Also the colour vector for the Born-loop interference is computed and saved in
  ! M0_col1_helarray
  do k = 1, nhel
    call colourvectors(A, k, M1helarray(:,k),M1helarray_ct(:,k))
    call colborninterf(M1helarray(:,k), M0_col1_helarray(:,k))
  end do
  M1helarray(:,nhel+1:)%j = 0
  M0_col1_helarray(:,nhel+1:)%hf = -1_intkind2
  M0_col1_helarray(:,nhel+1:)%j = 0

  M2add = 0
  M2add_ct = 0
  M2add_colint = 0

  M02 = 0
  M2ct = 0
  M2colint = 0
  
  do k = 1, nhel
    call colint(M1helarray(:,k)%j, M2add)
    call colint_ct(M1helarray(:,k)%j, M1helarray_ct(:,k)%j, M2add_ct)
    if (IR_is_on > 0) then
      call colint_IR(M1helarray(:,k)%j, M2add_colint)
    end if
    !summation over helicity configurations
    M02 = M02 + M2add
    M2ct = M2ct + M2add_ct
    M2colint = M2colint + M2add_colint
  end do



  contains

subroutine physical_helicities()
  implicit none 

integer :: i1,i2,i3,i4
integer :: n

n=0

do i4= 1, 2
do i3= 1, 2
do i2= 1, 2
do i1= 1, 2
n = n + 1
 if((ex1(i1)%hf==-1_intkind2) .OR. (ex2(i2)%hf==-1_intkind2) .OR. (ex3(i3)%hf==-1_intkind2) .OR. (ex4(i4)%hf==-1_intkind2)) then
  Hel(n) = -1_intkind2
 else
  Hel(n) = ex1(i1)%hf + ex2(i2)%hf + ex3(i3)%hf + ex4(i4)%hf
 end if
end do
end do
end do
end do

end subroutine physical_helicities

subroutine diagrams()
  implicit none
  integer :: h
  ! e.g. call cont_VV(nsync, wf3, wf6, A(:,1), n64, t64, nhel, den(5)) ...

    call Hcont_VV(nsync, wf4(:,1), wf4(:,2), A(:,1), n3(:,13), t3x16(:,:,1), nhel, den(1))
    call Hcont_QA(nsync, wf4(:,4), wf4(:,5), A(:,2), n3(:,14), t3x16(:,:,2), nhel, den(2))
    call Hcont_QA(nsync, wf4(:,7), wf4(:,8), A(:,3), n3(:,15), t3x16(:,:,3), nhel, den(3))

    call Hcont_VV(nsync, wf4(:,1), wf4(:,9), A(:,4), n3(:,16), t3x16(:,:,4), nhel, den(1))
    call Hcont_QA(nsync, wf4(:,5), wf4(:,10), A(:,5), n3(:,17), t3x16(:,:,5), nhel, den(2))
    call Hcont_QA(nsync, wf4(:,8), wf4(:,11), A(:,6), n3(:,18), t3x16(:,:,6), nhel, den(3))
    call Hcont_QA(nsync, wf4(:,12), wf4(:,13), A(:,7), n3(:,19), t3x16(:,:,7), nhel, den(4))
    call Hcont_QA(nsync, wf4(:,14), wf4(:,15), A(:,8), n3(:,20), t3x16(:,:,8), nhel, den(5))
    call Hcont_VV(nsync, wf4(:,2), wf4(:,16), A(:,9), n3(:,21), t3x16(:,:,9), nhel, den(6))
    call Hcont_VV(nsync, wf4(:,2), wf4(:,17), A(:,10), n3(:,22), t3x16(:,:,10), nhel, den(7))
    call Hcont_QA(nsync, wf4(:,15), wf4(:,18), A(:,11), n3(:,23), t3x16(:,:,11), nhel, den(8))
    call Hcont_QA(nsync, wf4(:,13), wf4(:,19), A(:,12), n3(:,24), t3x16(:,:,12), nhel, den(9))

end subroutine diagrams


elemental function diagmap(j, n)
  implicit none
  integer, intent(in) :: j, n
  complex(REALKIND) :: diagmap
  diagmap = A(j,n)%j
end function diagmap

function diagsum(j, pos, neg)
  implicit none
  integer, intent(in) :: j, pos(:), neg(:)
  complex(REALKIND) :: diagsum
  diagsum = sum(diagmap(j, pos)) - sum(diagmap(j, neg))
end function diagsum

subroutine colourvectors(A, j, M1, M2)
  implicit none
  type(Hpolcont) :: A(:,:)
  integer, intent(in) :: j
  type(Hpolcont), intent(out) :: M1(2), M2(2) ! M1helarray(2,16)
  integer :: empty(0), i

  M1(1)%j = A(j,3)%j*f(1)+CI*A(j,1)%j*f(2)
  M1(2)%j = A(j,2)%j*f(1)-CI*A(j,1)%j*f(2)

  M2(1)%j = -(A(j,12)%j*f(3))-CI*A(j,10)%j*f(4)+(A(j,6)%j+A(j,7)%j)*f(5)+CI*A(j,9)%j*f(6)+CI*A(j,4)%j*f(7)
  M2(2)%j = -(A(j,11)%j*f(3))+CI*A(j,10)%j*f(4)+(A(j,5)%j+A(j,8)%j)*f(5)-CI*A(j,9)%j*f(6)-CI*A(j,4)%j*f(7)


  M1(:)%hf = Hel(j)
  M2(:)%hf = Hel(j)  

  !M(i) corresponds to \Gamma_{i} in Fabios thesis

end subroutine colourvectors


! **********************************************************************
subroutine colint(M, M2colint)
! M(i)   = <M|Ci> colour component of matrix element
! COLINT = <M|M>
!        = Sum_{i,j} <M|Ci> * <Ci|Cj> * <Cj|M>
!        = colour-summed squared matrix element
! K2(i,j) = <Ci|Cj>
! **********************************************************************
  use ol_colourmatrix_pptt_ttxgg_1_/**/REALKIND, only: K1
  implicit none

  complex(REALKIND), intent(in)  :: M(2)
  real(REALKIND),    intent(out) :: M2colint
  integer :: i, j

  M2colint = 0

    do i = 1, 2
      do j = 1, 2
        M2colint = M2colint + real(conjg(M(i))*K1(i,j)*M(j))
      end do
    end do

end subroutine colint

! **********************************************************************
subroutine colint_ct(M, Mct, M2colint_ct)
! M(i)   = <M|Ci> colour component of matrix element
! COLINT = <M|M>
!        = Sum_{i,j} <M|Ci> * <Ci|Cj> * <Cj|M>
!        = colour-summed squared matrix element
! K2(i,j) = <Ci|Cj>
! **********************************************************************
  use ol_colourmatrix_pptt_ttxgg_1_/**/REALKIND, only: K2
  implicit none

  complex(REALKIND), intent(in)  :: M(2), Mct(2)
  real(REALKIND),    intent(out) :: M2colint_ct
  integer ::  i, j

  M2colint_ct = 0

    do i = 1, 2
      do j = 1, 2
        M2colint_ct = M2colint_ct + real(conjg(M(i))*K2(i,j)*Mct(j))
      end do
    end do


end subroutine colint_ct

! **********************************************************************
subroutine colint_IR(M, M2IRadd)
! M(i)   = <M|Ci> colour component of matrix element
! K1(i,j) = .....
! **********************************************************************
  use ol_colourmatrix_pptt_ttxgg_1_/**/REALKIND, only: K1
  implicit none

  complex(REALKIND), intent(in)  :: M(2)
  real(REALKIND),    intent(out) :: M2IRadd(11)
  integer ::  i, j, k, colmatpos

  M2IRadd = 0

  do k = 1, 12-1
    colmatpos = 2*k
    do i = 1, 2
      do j = 1, 2
	M2IRadd(k) = M2IRadd(k) + real(conjg(M(i))*K1(i+colmatpos,j)*M(j))
      end do
    end do
  end do
  
end subroutine colint_IR

! **********************************************************************
subroutine colintmunu(M1, M2, M2colint)
! M1(i)    = <M1|Ci> colour component of matrix element
! M2(i)    = <M2|Ci> colour component of matrix element
! M2colint = <M1|M2>
!          = Sum_{i,j} <M1|Ci> * <Ci|Cj> * <Cj|M2>
!          = colour-summed squared matrix element
! K2(i,j) = <Ci|Cj>
! **********************************************************************
  use ol_colourmatrix_pptt_ttxgg_1_/**/REALKIND, only: K2
  implicit none

  complex(REALKIND), intent(in)  :: M1(2)
  complex(REALKIND), intent(in)  :: M2(2)
  complex(REALKIND),    intent(out) :: M2colint
  integer :: i, j

  M2colint = 0

  do i = 1, 2
    do j = 1, 2
      M2colint = M2colint + M1(i)*K2(i,j)*conjg(M2(j))
    end do
  end do

end subroutine colintmunu





! **********************************************************************
subroutine colborninterf(M, M0_col)
! M(i)         = <M|Ci> colour component of matrix element
! M0_col(i)    = <M2|Ci> colour component of matrix element,
!                see \tilde{M}_{j} in Fabios thesis
! M2colint = Sum_{i} <M1|Ci> * <Ci|Cj>
!          = colour-summed squared matrix element
! KL(i,j) = <Ci|Cj> with elements Cj of 1-loop colour basis
! **********************************************************************
  use ol_colourmatrix_pptt_ttxgg_1_/**/REALKIND, only: KL
  implicit none

  type(Hpolcont), intent(in)  :: M(2)
  type(Hpolcont), intent(out)  :: M0_col(3)
  integer :: i, j


  do j = 1, 3 !size(KL(1,:))
    M0_col(j)%j = 0
    M0_col(j)%hf = M(1)%hf
    do i = 1, 2 !size(KL(:,1))
      M0_col(j)%j = M0_col(j)%j  + conjg(M(i)%j)*KL(i,j)
    end do    
  end do

end subroutine colborninterf

end subroutine amp2

end module ol_loop_pptt_ttxgg_1_/**/REALKIND
