
module ol_vamp_1_pptllj_nenexuxtdbx_1_/**/REALKIND
contains

! **********************************************************************
subroutine vamp_1(M)
! P(0:3,nlegs) = incoming external momenta
! Uses tree structures 'wf', factors 'c', and denominators 'den' from loop_pptllj_nenexuxtdbx_1.
! Sets colour stripped amplitudes A from the module loop_amplitudes_pptllj_nenexuxtdbx_1.
! **********************************************************************
  use KIND_TYPES, only: REALKIND, QREALKIND, intkind2
  use ol_parameters_decl_/**/DREALKIND, only: l_switch
  use ol_parameters_decl_/**/QREALKIND ! masses
  use ol_vert_interface_/**/REALKIND
  use ol_prop_interface_/**/REALKIND
  use ol_last_step_/**/REALKIND
  use ol_tables_storage_pptllj_nenexuxtdbx_1_/**/DREALKIND
  use ol_tensor_sum_storage_pptllj_nenexuxtdbx_1_/**/REALKIND
  use ol_loop_handling_/**/REALKIND
  use ofred_reduction_/**/REALKIND, only: Hotf_4pt_reduction, Hotf_4pt_reduction_last
  use ofred_reduction_/**/REALKIND, only: Hotf_5pt_reduction, Hotf_5pt_reduction_last
  use ol_loop_reduction_/**/REALKIND, only: TI_bubble_red, TI_triangle_red
use ol_loop_reduction_/**/REALKIND, only: compute_scalar_box

  use ol_loop_storage_pptllj_nenexuxtdbx_1_/**/REALKIND
#ifndef PRECISION_dp
  use ol_loop_storage_pptllj_nenexuxtdbx_1_/**/DREALKIND, only: ntryL, p_switch, Hel
#endif
  use hol_initialisation_/**/REALKIND, only: G0_hol_initialisation
  use ol_h_vert_interface_/**/REALKIND
  use ol_h_prop_interface_/**/REALKIND
  use ol_h_last_step_/**/REALKIND
  use ol_merging_/**/REALKIND, only: ol_merge, ol_merge_tensors, ol_merge_last

  implicit none

  type(Hpolcont) :: Gcoeff(64)
  type(Hpolcont), intent(in) :: M(2,64)


#ifndef PRECISION_dp
  if (ntryL==1 .OR. p_switch == 1) Gcoeff(:)%hf = Hel
#else
  if (ntryL==1 .OR. p_switch == 2) Gcoeff(:)%hf = Hel
#endif

  ! =============================================


! Dressing, otf merging and otf reduction calls to build loop structures

Gcoeff(:)%j = (-(c(9)*M(1,:)%j)+c(10)*M(2,:)%j) * den(1)
call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(1),h0tab(:,1),[32,3,16,4,8],[nMW,nMW,0,0,nMT],5,1,wf4(:,1))
  call Hloop_QA_S(ntryL,G0H64(1),ex6(:),G0H32(1),ngPbt,m3h2x32(:,1),heltab2x64(:,:,1))
Gcoeff(:)%j = (-(c(3)*M(1,:)%j)+c(4)*M(2,:)%j) * den(1)
call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(2),h0tab(:,2),[32,3,16,4,8],[nMW,nMW,0,0,nMT],5,1,wf4(:,1))
  call Hloop_QA_W(ntryL,G0H64(1),ex6(:),G0H32(2),m3h2x32(:,2),heltab2x64(:,:,2))
Gcoeff(:)%j = (-(c(6)*M(1,:)%j)+c(7)*M(2,:)%j) * den(1)
call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(3),h0tab(:,3),[32,3,8,4,16],[nMT,nMT,0,0,nMW],5,1,wf4(:,1))
  call Hloop_WA_Q(ntryL,G0H64(1),ex6(:),G0H32(3),m3h2x32(:,3),heltab2x64(:,:,3))
  call Hloop_A_Q(ntryL,G0H32(3),32,nMT,G1H32(1),n2h32(1))
Gcoeff(:)%j = (-(c(6)*M(1,:)%j)+c(7)*M(2,:)%j) * den(1)
call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(4),h0tab(:,4),[32,3,8,4,16],[nMB,nMB,nMW,0,0],5,1,wf4(:,1))
  call Hloop_VA_Q(ntryL,G0H64(1),ex6(:),G0H32(3),m3h2x32(:,4),heltab2x64(:,:,4))
  call Hloop_A_Q(ntryL,G0H32(3),32,nMB,G1H32(2),n2h32(2))
Gcoeff(:)%j = (-(c(6)*M(1,:)%j)+c(7)*M(2,:)%j) * den(1)
call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(5),h0tab(:,5),[32,8,4,3,16],[nMT,0,0,0,nMW],5,1,wf4(:,1))
  call Hloop_WA_Q(ntryL,G0H64(1),ex6(:),G0H32(3),m3h2x32(:,5),heltab2x64(:,:,5))
  call Hloop_A_Q(ntryL,G0H32(3),32,nMT,G1H32(3),n2h32(3))
Gcoeff(:)%j = (-(c(6)*M(1,:)%j)+c(7)*M(2,:)%j) * den(1)
call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(6),h0tab(:,6),[32,8,4,3,16],[nMB,nMW,0,0,0],5,1,wf4(:,1))
  call Hloop_VA_Q(ntryL,G0H64(1),ex6(:),G0H32(3),m3h2x32(:,6),heltab2x64(:,:,6))
  call Hloop_A_Q(ntryL,G0H32(3),32,nMB,G1H32(4),n2h32(4))
Gcoeff(:)%j = (-(c(6)*M(1,:)%j)+c(7)*M(2,:)%j) * den(1)
call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(7),h0tab(:,7),[32,3,8,16,4],[nMT,nMT,0,0,nMW],5,1,wf4(:,1))
  call Hloop_WA_Q(ntryL,G0H64(1),ex6(:),G0H32(3),m3h2x32(:,7),heltab2x64(:,:,7))
  call Hloop_A_Q(ntryL,G0H32(3),32,nMT,G1H32(5),n2h32(5))
Gcoeff(:)%j = (-(c(6)*M(1,:)%j)+c(7)*M(2,:)%j) * den(1)
call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(8),h0tab(:,8),[32,3,8,16,4],[nMB,nMB,nMW,0,0],5,1,wf4(:,1))
  call Hloop_VA_Q(ntryL,G0H64(1),ex6(:),G0H32(3),m3h2x32(:,8),heltab2x64(:,:,8))
  call Hloop_A_Q(ntryL,G0H32(3),32,nMB,G1H32(6),n2h32(6))
Gcoeff(:)%j = (-(c(9)*M(1,:)%j)+c(10)*M(2,:)%j) * den(1)
call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(9),h0tab(:,9),[32,4,16,3,8],[0,0,nMW,nMW,nMB],5,1,wf4(:,1))
  call Hloop_QA_V(ntryL,G0H64(1),ex6(:),G0H32(3),m3h2x32(:,9),heltab2x64(:,:,9))
Gcoeff(:)%j = (-(c(3)*M(1,:)%j)+c(4)*M(2,:)%j) * den(1)
call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(10),h0tab(:,10),[32,4,16,3,8],[0,0,nMW,nMW,nMB],5,1,wf4(:,1))
  call Hloop_QA_V(ntryL,G0H64(1),ex6(:),G0H32(4),m3h2x32(:,10),heltab2x64(:,:,10))
Gcoeff(:)%j = (-(c(9)*M(1,:)%j)+c(10)*M(2,:)%j) * den(1)
call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(11),h0tab(:,11),[32,3,4,16,8],[nMW,nMW,0,0,nMT],5,1,wf4(:,1))
  call Hloop_QA_S(ntryL,G0H64(1),ex6(:),G0H32(5),ngPbt,m3h2x32(:,11),heltab2x64(:,:,11))
Gcoeff(:)%j = (-(c(3)*M(1,:)%j)+c(4)*M(2,:)%j) * den(1)
call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(12),h0tab(:,12),[32,3,4,16,8],[nMW,nMW,0,0,nMT],5,1,wf4(:,1))
  call Hloop_QA_W(ntryL,G0H64(1),ex6(:),G0H32(6),m3h2x32(:,12),heltab2x64(:,:,12))
Gcoeff(:)%j = (-(c(9)*M(1,:)%j)+c(10)*M(2,:)%j) * den(1)
call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(13),h0tab(:,13),[32,8,3,4,16],[nMB,nMW,nMW,0,0],5,1,wf4(:,1))
  call Hloop_VA_Q(ntryL,G0H64(1),ex6(:),G0H32(7),m3h2x32(:,13),heltab2x64(:,:,13))
  call Hloop_A_Q(ntryL,G0H32(7),32,nMB,G1H32(7),n2h32(7))
Gcoeff(:)%j = (-(c(3)*M(1,:)%j)+c(4)*M(2,:)%j) * den(1)
call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(14),h0tab(:,14),[32,8,3,4,16],[nMB,nMW,nMW,0,0],5,1,wf4(:,1))
  call Hloop_VA_Q(ntryL,G0H64(1),ex6(:),G0H32(7),m3h2x32(:,14),heltab2x64(:,:,14))
  call Hloop_A_Q(ntryL,G0H32(7),32,nMB,G1H32(8),n2h32(8))
Gcoeff(:)%j = (-(c(6)*M(1,:)%j)+c(7)*M(2,:)%j) * den(1)
call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(15),h0tab(:,15),[32,4,3,16,8],[0,0,0,nMW,nMB],5,1,wf4(:,1))
  call Hloop_QA_V(ntryL,G0H64(1),ex6(:),G0H32(7),m3h2x32(:,15),heltab2x64(:,:,15))
Gcoeff(:)%j = (-(c(6)*M(1,:)%j)+c(7)*M(2,:)%j) * den(1)
call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(16),h0tab(:,16),[32,4,3,16,8],[nMW,0,0,0,nMT],5,1,wf4(:,1))
  call Hloop_QA_W(ntryL,G0H64(1),ex6(:),G0H32(8),m3h2x32(:,16),heltab2x64(:,:,16))
  call Hloop_SV_V(ntryL,G0H32(1),wf4(:,1),G0H8(1),m3h4x8(:,1),heltab2x32(:,:,1))
  call Hloop_UW_V(ntryL,G0H32(2),32,wf4(:,1),3,G1H8(1),m3h4x8(:,2),heltab2x32(:,:,2))
  call Hloop_AZ_Q(ntryL,G1H32(1),wf4(:,1),G1H8(2),ngZu,m3h4x8(:,3),heltab2x32(:,:,3))
  call Hloop_A_Q(ntryL,G1H8(2),35,nMT,G2H8(1),n2h8(1))
  call Hloop_AZ_Q(ntryL,G1H32(2),wf4(:,1),G1H8(2),ngZd,m3h4x8(:,4),heltab2x32(:,:,4))
  call Hloop_A_Q(ntryL,G1H8(2),35,nMB,G2H8(2),n2h8(2))
  call Hloop_AQ_V(ntryL,G1H32(3),ex4(:),G1H16(1),m3h2x16(:,1),heltab2x32(:,:,5))
  call Hloop_AQ_W(ntryL,G1H32(4),ex4(:),G1H16(2),m3h2x16(:,2),heltab2x32(:,:,6))
  call Hloop_AZ_Q(ntryL,G1H32(5),wf4(:,1),G1H8(2),ngZu,m3h4x8(:,5),heltab2x32(:,:,7))
  call Hloop_A_Q(ntryL,G1H8(2),35,nMT,G2H8(3),n2h8(3))
  call Hloop_AZ_Q(ntryL,G1H32(6),wf4(:,1),G1H8(2),ngZd,m3h4x8(:,6),heltab2x32(:,:,8))
  call Hloop_A_Q(ntryL,G1H8(2),35,nMB,G2H8(4),n2h8(4))
  call Hloop_VA_Q(ntryL,G0H32(3),ex3(:),G0H16(1),m3h2x16(:,3),heltab2x32(:,:,9))
  call Hloop_A_Q(ntryL,G0H16(1),36,0,G1H16(3),n2h16(1))
  call Hloop_VA_Q(ntryL,G0H32(4),ex3(:),G0H16(1),m3h2x16(:,4),heltab2x32(:,:,10))
  call Hloop_A_Q(ntryL,G0H16(1),36,0,G1H16(4),n2h16(2))
  call Hloop_SV_V(ntryL,G0H32(5),wf4(:,1),G0H8(2),m3h4x8(:,7),heltab2x32(:,:,11))
  call Hloop_UW_V(ntryL,G0H32(6),32,wf4(:,1),3,G1H8(2),m3h4x8(:,8),heltab2x32(:,:,12))
  call Hloop_AQ_S(ntryL,G1H32(7),ex4(:),G1H16(5),ngPbt,m3h2x16(:,5),heltab2x32(:,:,13))
  call Hloop_AQ_W(ntryL,G1H32(8),ex4(:),G1H16(6),m3h2x16(:,6),heltab2x32(:,:,14))
  call Hloop_VA_Q(ntryL,G0H32(7),ex3(:),G0H16(1),m3h2x16(:,7),heltab2x32(:,:,15))
  call Hloop_A_Q(ntryL,G0H16(1),36,0,G1H16(7),n2h16(3))
  call Hloop_WA_Q(ntryL,G0H32(8),ex3(:),G0H16(1),m3h2x16(:,8),heltab2x32(:,:,16))
  call Hloop_A_Q(ntryL,G0H16(1),36,0,G1H16(8),n2h16(4))
  call ol_merge(ntryL,G1H8(1),[G0H8(1)])
  call ol_merge(ntryL,G1H8(2),[G0H8(2)])
  call Hloop_WQ_A(ntryL,G1H8(1),ex5(:),G1H4(1),m3h2x4(:,1),heltab2x8(:,:,1))
  call Hloop_Q_A(ntryL,G1H4(1),51,0,G2H4(1),n2h4(1))
  call Hloop_AQ_V(ntryL,G2H8(1),ex4(:),G2H4(2),m3h2x4(:,2),heltab2x8(:,:,2))
  call Hloop_AQ_W(ntryL,G2H8(2),ex4(:),G2H4(3),m3h2x4(:,3),heltab2x8(:,:,3))
  call Hloop_VA_Q(ntryL,G1H16(1),ex3(:),G1H8(1),m3h2x8(:,1),heltab2x16(:,:,1))
  call Hloop_A_Q(ntryL,G1H8(1),44,0,G2H8(1),n2h8(5))
  call Hloop_WA_Q(ntryL,G1H16(2),ex3(:),G1H8(1),m3h2x8(:,2),heltab2x16(:,:,2))
  call Hloop_A_Q(ntryL,G1H8(1),44,0,G2H8(2),n2h8(6))
  call Hloop_AQ_V(ntryL,G2H8(3),ex4(:),G2H4(4),m3h2x4(:,4),heltab2x8(:,:,4))
  call Hloop_AQ_W(ntryL,G2H8(4),ex4(:),G2H4(5),m3h2x4(:,5),heltab2x8(:,:,5))
  call Hloop_AQ_W(ntryL,G1H16(3),ex5(:),G1H8(1),m3h2x8(:,3),heltab2x16(:,:,3))
  call Hloop_AQ_W(ntryL,G1H16(4),ex5(:),G1H8(3),m3h2x8(:,4),heltab2x16(:,:,4))
  call Hloop_WA_Q(ntryL,G1H8(2),ex3(:),G1H4(1),m3h2x4(:,6),heltab2x8(:,:,6))
  call Hloop_A_Q(ntryL,G1H4(1),39,0,G2H4(6),n2h4(2))
  call Hloop_SV_V(ntryL,G1H16(5),wf4(:,1),G1H4(1),m3h4x4(:,1),heltab2x16(:,:,5))
  call Hloop_UW_V(ntryL,G1H16(6),40,wf4(:,1),3,G2H4(7),m3h4x4(:,2),heltab2x16(:,:,6))
  call Hloop_AZ_Q(ntryL,G1H16(7),wf4(:,1),G1H4(2),ngZu,m3h4x4(:,3),heltab2x16(:,:,7))
  call Hloop_A_Q(ntryL,G1H4(2),39,0,G2H4(8),n2h4(3))
  call Hloop_AZ_Q(ntryL,G1H16(8),wf4(:,1),G1H4(2),ngZd,m3h4x4(:,4),heltab2x16(:,:,8))
  call Hloop_A_Q(ntryL,G1H4(2),39,0,G2H4(9),n2h4(4))
  call ol_merge(ntryL,G2H4(7),[G1H4(1)])
  call Hloop_QA_V(ntryL,G2H4(1),ex3(:),G2H2(1),m3h2x2(:,1),heltab2x4(:,:,1))
call Hotf_5pt_reduction(G2H4(2),RedSet_5(1),mass5set(:,1),  & 
G1H4(2),G1H4(1),G1H4(3),G1H4(4),G1H4(5),G1H4(6),4)
call HG1shiftOLR(G1H4(1),16,4)
call Hotf_5pt_reduction(G2H4(3),RedSet_5(1),mass5set(:,2),  & 
G1H4(7),G1H4(8),G1H4(9),G1H4(10),G1H4(11),G1H4(12),4)
call HG1shiftOLR(G1H4(8),16,4)
call Hotf_5pt_reduction(G2H8(1),RedSet_5(2),mass5set(:,3),  & 
G1H8(2),G1H8(4),G1H8(5),G1H8(6),G1H8(7),G1H8(8),8)
call HG1shiftOLR(G1H8(4),16,8)
call Hotf_5pt_reduction(G2H8(2),RedSet_5(2),mass5set(:,4),  & 
G1H8(9),G1H8(10),G1H8(11),G1H8(12),G1H8(13),G1H8(14),8)
call HG1shiftOLR(G1H8(10),16,8)
call Hotf_5pt_reduction(G2H4(4),RedSet_5(3),mass5set(:,1),  & 
G1H4(13),G1H4(14),G1H4(15),G1H4(16),G1H4(17),G1H4(18),4)
call HG1shiftOLR(G1H4(14),4,4)
call Hotf_5pt_reduction(G2H4(5),RedSet_5(3),mass5set(:,2),  & 
G1H4(19),G1H4(20),G1H4(21),G1H4(22),G1H4(23),G1H4(24),4)
call HG1shiftOLR(G1H4(20),4,4)
  call Hloop_VV_S(ntryL,G1H8(1),wf4(:,1),G1H2(1),m3h4x2(:,1),heltab2x8(:,:,7))
  call Hloop_UV_W(ntryL,G1H8(3),52,wf4(:,1),3,G2H2(2),m3h4x2(:,2),heltab2x8(:,:,8))
  call Hloop_AQ_V(ntryL,G2H4(6),ex5(:),G2H2(3),m3h2x2(:,2),heltab2x4(:,:,2))
call Hotf_5pt_reduction(G2H4(7),RedSet_5(4),mass5set(:,5),  & 
G1H4(25),G1H4(26),G1H4(27),G1H4(28),G1H4(29),G1H4(30),4)
call HG1shiftOLR(G1H4(26),16,4)
  call Hloop_AQ_W(ntryL,G2H4(8),ex5(:),G2H2(4),m3h2x2(:,3),heltab2x4(:,:,3))
  call Hloop_AQ_V(ntryL,G2H4(9),ex5(:),G2H2(5),m3h2x2(:,4),heltab2x4(:,:,4))
  call Hloop_VA_Q(ntryL,G1H4(2),ex3(:),G1H2(2),m3h2x2(:,5),heltab2x4(:,:,5))
  call Hloop_A_Q(ntryL,G1H2(2),47,0,G2H2(6),n2h2(1))
call HGT_raise_alpha_OLR(G1H4(1),1,1,4)
call HGT_raise_alpha_invQ_OLR(G1H4(1),2,5,4)
  call Hloop_WQ_A(ntryL,G1H4(1),ex5(:),G1H2(2),m3h2x2(:,6),heltab2x4(:,:,6))
  call Hloop_VA_Q(ntryL,G1H4(5),ex3(:),G1H2(3),m3h2x2(:,7),heltab2x4(:,:,7))
  call Hloop_A_Q(ntryL,G1H2(3),47,0,G2H2(7),n2h2(2))
  call Hloop_VA_Q(ntryL,G1H4(6),ex3(:),G1H2(3),m3h2x2(:,8),heltab2x4(:,:,8))
  call Hloop_A_Q(ntryL,G1H2(3),47,0,G2H2(8),n2h2(3))
  call Hloop_WA_Q(ntryL,G1H4(7),ex3(:),G1H2(3),m3h2x2(:,9),heltab2x4(:,:,9))
  call Hloop_A_Q(ntryL,G1H2(3),47,0,G2H2(9),n2h2(4))
call HGT_raise_alpha_OLR(G1H4(8),1,1,4)
call HGT_raise_alpha_invQ_OLR(G1H4(8),2,5,4)
  call Hloop_VQ_A(ntryL,G1H4(8),ex5(:),G1H2(3),m3h2x2(:,10),heltab2x4(:,:,10))
  call Hloop_WA_Q(ntryL,G1H4(11),ex3(:),G1H2(4),m3h2x2(:,11),heltab2x4(:,:,11))
  call Hloop_A_Q(ntryL,G1H2(4),47,0,G2H2(10),n2h2(5))
  call Hloop_WA_Q(ntryL,G1H4(12),ex3(:),G1H2(4),m3h2x2(:,12),heltab2x4(:,:,12))
  call Hloop_A_Q(ntryL,G1H2(4),47,0,G2H2(11),n2h2(6))
  call Hloop_AZ_Q(ntryL,G1H8(2),wf4(:,1),G1H2(4),ngZu,m3h4x2(:,3),heltab2x8(:,:,9))
  call Hloop_A_Q(ntryL,G1H2(4),47,0,G2H2(12),n2h2(7))
call HGT_raise_alpha_OLR(G1H8(4),1,1,8)
call HGT_raise_alpha_invQ_OLR(G1H8(4),2,5,8)
  call Hloop_WQ_A(ntryL,G1H8(4),ex5(:),G1H4(2),m3h2x4(:,7),heltab2x8(:,:,10))
  call Hloop_AZ_Q(ntryL,G1H8(7),wf4(:,1),G1H2(4),ngZu,m3h4x2(:,4),heltab2x8(:,:,11))
  call Hloop_A_Q(ntryL,G1H2(4),47,0,G2H2(13),n2h2(8))
  call Hloop_AZ_Q(ntryL,G1H8(8),wf4(:,1),G1H2(4),ngZu,m3h4x2(:,5),heltab2x8(:,:,12))
  call Hloop_A_Q(ntryL,G1H2(4),47,0,G2H2(14),n2h2(9))
  call Hloop_AZ_Q(ntryL,G1H8(9),wf4(:,1),G1H2(4),ngZd,m3h4x2(:,6),heltab2x8(:,:,13))
  call Hloop_A_Q(ntryL,G1H2(4),47,0,G2H2(15),n2h2(10))
call HGT_raise_alpha_OLR(G1H8(10),1,1,8)
call HGT_raise_alpha_invQ_OLR(G1H8(10),2,5,8)
  call Hloop_VQ_A(ntryL,G1H8(10),ex5(:),G1H4(1),m3h2x4(:,8),heltab2x8(:,:,14))
  call Hloop_AZ_Q(ntryL,G1H8(13),wf4(:,1),G1H2(4),ngZd,m3h4x2(:,7),heltab2x8(:,:,15))
  call Hloop_A_Q(ntryL,G1H2(4),47,0,G2H2(16),n2h2(11))
  call Hloop_AZ_Q(ntryL,G1H8(14),wf4(:,1),G1H2(4),ngZd,m3h4x2(:,8),heltab2x8(:,:,16))
  call Hloop_A_Q(ntryL,G1H2(4),47,0,G2H2(17),n2h2(12))
  call Hloop_VQ_A(ntryL,G1H4(13),ex5(:),G1H2(4),m3h2x2(:,13),heltab2x4(:,:,13))
  call Hloop_Q_A(ntryL,G1H2(4),59,0,G2H2(18),n2h2(13))
call HGT_raise_alpha_OLR(G1H4(14),1,1,4)
call HGT_raise_alpha_invQ_OLR(G1H4(14),2,5,4)
  call Hloop_WA_Q(ntryL,G1H4(14),ex3(:),G1H2(4),m3h2x2(:,14),heltab2x4(:,:,14))
  call Hloop_VQ_A(ntryL,G1H4(17),ex5(:),G1H2(5),m3h2x2(:,15),heltab2x4(:,:,15))
  call Hloop_Q_A(ntryL,G1H2(5),59,0,G2H2(19),n2h2(14))
  call Hloop_VQ_A(ntryL,G1H4(18),ex5(:),G1H2(5),m3h2x2(:,16),heltab2x4(:,:,16))
  call Hloop_Q_A(ntryL,G1H2(5),59,0,G2H2(20),n2h2(15))
  call Hloop_WQ_A(ntryL,G1H4(19),ex5(:),G1H2(5),m3h2x2(:,17),heltab2x4(:,:,17))
  call Hloop_Q_A(ntryL,G1H2(5),59,0,G2H2(21),n2h2(16))
call HGT_raise_alpha_OLR(G1H4(20),1,1,4)
call HGT_raise_alpha_invQ_OLR(G1H4(20),2,5,4)
  call Hloop_VA_Q(ntryL,G1H4(20),ex3(:),G1H2(5),m3h2x2(:,18),heltab2x4(:,:,18))
  call Hloop_WQ_A(ntryL,G1H4(23),ex5(:),G1H2(6),m3h2x2(:,19),heltab2x4(:,:,19))
  call Hloop_Q_A(ntryL,G1H2(6),59,0,G2H2(22),n2h2(17))
  call Hloop_WQ_A(ntryL,G1H4(24),ex5(:),G1H2(6),m3h2x2(:,20),heltab2x4(:,:,20))
  call Hloop_Q_A(ntryL,G1H2(6),59,0,G2H2(23),n2h2(18))
  call Hloop_WA_Q(ntryL,G1H4(25),ex3(:),G1H2(6),m3h2x2(:,21),heltab2x4(:,:,21))
  call Hloop_A_Q(ntryL,G1H2(6),47,0,G2H2(24),n2h2(19))
call HGT_raise_alpha_OLR(G1H4(26),1,1,4)
call HGT_raise_alpha_invQ_OLR(G1H4(26),2,5,4)
  call Hloop_VQ_A(ntryL,G1H4(26),ex5(:),G1H2(6),m3h2x2(:,22),heltab2x4(:,:,22))
  call Hloop_WA_Q(ntryL,G1H4(29),ex3(:),G1H2(7),m3h2x2(:,23),heltab2x4(:,:,23))
  call Hloop_A_Q(ntryL,G1H2(7),47,0,G2H2(25),n2h2(20))
  call Hloop_WA_Q(ntryL,G1H4(30),ex3(:),G1H2(7),m3h2x2(:,24),heltab2x4(:,:,24))
  call Hloop_A_Q(ntryL,G1H2(7),47,0,G2H2(26),n2h2(21))
call Hotf_5pt_reduction(G2H2(1),RedSet_5(5),mass5set(:,6),  & 
G1H2(7),G1H2(8),G1H2(9),G1H2(10),G1H2(11),G1H2(12),2)
call HG1shiftOLR(G1H2(8),8,2)
  call Hloop_SQ_A(ntryL,G1H2(1),ex4(:),G1H1(1),ngPbt,m3h2x1(:,1),heltab2x2(:,:,1))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,nMB,G2tensor(1),n2h1(1))
call Hotf_5pt_reduction(G2H2(2),RedSet_5(6),mass5set(:,7),  & 
G1H2(1),G1H2(13),G1H2(14),G1H2(15),G1H2(16),G1H2(17),2)
call HG1shiftOLR(G1H2(13),8,2)
call Hotf_5pt_reduction(G2H2(3),RedSet_5(7),mass5set(:,6),  & 
G1H2(18),G1H2(19),G1H2(20),G1H2(21),G1H2(22),G1H2(23),2)
call HG1shiftOLR(G1H2(19),8,2)
call Hotf_5pt_reduction(G2H2(4),RedSet_5(8),mass5set(:,8),  & 
G1H2(24),G1H2(25),G1H2(26),G1H2(27),G1H2(28),G1H2(29),2)
call HG1shiftOLR(G1H2(25),8,2)
call Hotf_5pt_reduction(G2H2(5),RedSet_5(8),mass5set(:,9),  & 
G1H2(30),G1H2(31),G1H2(32),G1H2(33),G1H2(34),G1H2(35),2)
call HG1shiftOLR(G1H2(31),8,2)
  call Hcheck_last_AQ_W(ntryL,l_switch,G2H2(6),ex5(:),G2tensor(2),m3h2x1(:,2),heltab2x2(:,:,2))
  call Hcheck_last_AQ_W(ntryL,l_switch,G2H2(8),ex5(:),G2tensor(3),m3h2x1(:,3),heltab2x2(:,:,3))
  call Hcheck_last_AQ_V(ntryL,l_switch,G2H2(9),ex5(:),G2tensor(4),m3h2x1(:,4),heltab2x2(:,:,4))
  call Hcheck_last_AQ_V(ntryL,l_switch,G2H2(11),ex5(:),G2tensor(5),m3h2x1(:,5),heltab2x2(:,:,5))
  call Hcheck_last_AQ_W(ntryL,l_switch,G2H2(12),ex5(:),G2tensor(6),m3h2x1(:,6),heltab2x2(:,:,6))
  call Hcheck_last_AQ_W(ntryL,l_switch,G2H2(14),ex5(:),G2tensor(7),m3h2x1(:,7),heltab2x2(:,:,7))
  call Hcheck_last_AQ_V(ntryL,l_switch,G2H2(15),ex5(:),G2tensor(8),m3h2x1(:,8),heltab2x2(:,:,8))
  call Hcheck_last_AQ_V(ntryL,l_switch,G2H2(17),ex5(:),G2tensor(9),m3h2x1(:,9),heltab2x2(:,:,9))
  call Hcheck_last_QA_W(ntryL,l_switch,G2H2(18),ex3(:),G2tensor(10),m3h2x1(:,10),heltab2x2(:,:,10))
  call Hcheck_last_QA_W(ntryL,l_switch,G2H2(20),ex3(:),G2tensor(11),m3h2x1(:,11),heltab2x2(:,:,11))
  call Hcheck_last_QA_V(ntryL,l_switch,G2H2(21),ex3(:),G2tensor(12),m3h2x1(:,12),heltab2x2(:,:,12))
  call Hcheck_last_QA_V(ntryL,l_switch,G2H2(23),ex3(:),G2tensor(13),m3h2x1(:,13),heltab2x2(:,:,13))
  call Hcheck_last_AQ_V(ntryL,l_switch,G2H2(24),ex5(:),G2tensor(14),m3h2x1(:,14),heltab2x2(:,:,14))
  call Hcheck_last_AQ_V(ntryL,l_switch,G2H2(26),ex5(:),G2tensor(15),m3h2x1(:,15),heltab2x2(:,:,15))
  call Hloop_VQ_A(ntryL,G1H2(7),ex4(:),G1H1(1),m3h2x1(:,16),heltab2x2(:,:,16))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,nMT,G2tensor(16),n2h1(2))
  call Hloop_VQ_A(ntryL,G1H2(8),ex4(:),G1H1(1),m3h2x1(:,17),heltab2x2(:,:,17))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),8,nMT,G2tensor(17),n2h1(3))
  call Hloop_VQ_A(ntryL,G1H2(12),ex4(:),G1H1(1),m3h2x1(:,18),heltab2x2(:,:,18))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,nMT,G2tensor(18),n2h1(4))
  call Hloop_WQ_A(ntryL,G1H2(1),ex4(:),G1H1(1),m3h2x1(:,19),heltab2x2(:,:,19))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,nMB,G2tensor(19),n2h1(5))
  call Hloop_WQ_A(ntryL,G1H2(13),ex4(:),G1H1(1),m3h2x1(:,20),heltab2x2(:,:,20))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),8,nMB,G2tensor(20),n2h1(6))
  call Hloop_WQ_A(ntryL,G1H2(17),ex4(:),G1H1(1),m3h2x1(:,21),heltab2x2(:,:,21))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,nMB,G2tensor(21),n2h1(7))
  call Hloop_VQ_A(ntryL,G1H2(18),ex4(:),G1H1(1),m3h2x1(:,22),heltab2x2(:,:,22))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,nMT,G2tensor(22),n2h1(8))
  call Hloop_VQ_A(ntryL,G1H2(19),ex4(:),G1H1(1),m3h2x1(:,23),heltab2x2(:,:,23))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),8,nMT,G2tensor(23),n2h1(9))
  call Hloop_VQ_A(ntryL,G1H2(23),ex4(:),G1H1(1),m3h2x1(:,24),heltab2x2(:,:,24))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,nMT,G2tensor(24),n2h1(10))
  call Hloop_WQ_A(ntryL,G1H2(24),ex4(:),G1H1(1),m3h2x1(:,25),heltab2x2(:,:,25))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,nMB,G2tensor(25),n2h1(11))
  call Hloop_WQ_A(ntryL,G1H2(25),ex4(:),G1H1(1),m3h2x1(:,26),heltab2x2(:,:,26))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),8,nMB,G2tensor(26),n2h1(12))
  call Hloop_WQ_A(ntryL,G1H2(29),ex4(:),G1H1(1),m3h2x1(:,27),heltab2x2(:,:,27))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,nMB,G2tensor(27),n2h1(13))
  call Hloop_VQ_A(ntryL,G1H2(30),ex4(:),G1H1(1),m3h2x1(:,28),heltab2x2(:,:,28))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,nMT,G2tensor(28),n2h1(14))
  call Hloop_VQ_A(ntryL,G1H2(31),ex4(:),G1H1(1),m3h2x1(:,29),heltab2x2(:,:,29))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),8,nMT,G2tensor(29),n2h1(15))
  call Hloop_VQ_A(ntryL,G1H2(35),ex4(:),G1H1(1),m3h2x1(:,30),heltab2x2(:,:,30))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,nMT,G2tensor(30),n2h1(16))
  call ol_merge_tensors(G2tensor(19),[G2tensor(1)])
call Hotf_5pt_reduction_last(G2tensor(19),RedSet_5(6),mass5set(:,7),  & 
G1tensor(1),G1tensor(2),G1tensor(3),G1tensor(4),G1tensor(5),G1tensor(6))
call G_TensorShift(G1tensor(2),8)
call Hotf_5pt_reduction_last(G2tensor(2),RedSet_5(1),mass5set(:,1),  & 
G1tensor(7),G1tensor(8),G1tensor(9),G1tensor(10),G1tensor(11),G1tensor(12))
call G_TensorShift(G1tensor(8),16)
call Hotf_5pt_reduction_last(G2tensor(4),RedSet_5(1),mass5set(:,2),  & 
G1tensor(13),G1tensor(14),G1tensor(15),G1tensor(16),G1tensor(17),G1tensor(18))
call G_TensorShift(G1tensor(14),16)
call Hotf_5pt_reduction_last(G2tensor(6),RedSet_5(2),mass5set(:,3),  & 
G1tensor(19),G1tensor(20),G1tensor(21),G1tensor(22),G1tensor(23),G1tensor(24))
call G_TensorShift(G1tensor(20),16)
call Hotf_5pt_reduction_last(G2tensor(8),RedSet_5(2),mass5set(:,4),  & 
G1tensor(25),G1tensor(26),G1tensor(27),G1tensor(28),G1tensor(29),G1tensor(30))
call G_TensorShift(G1tensor(26),16)
call Hotf_5pt_reduction_last(G2tensor(10),RedSet_5(3),mass5set(:,1),  & 
G1tensor(31),G1tensor(32),G1tensor(33),G1tensor(34),G1tensor(35),G1tensor(36))
call G_TensorShift(G1tensor(32),4)
call Hotf_5pt_reduction_last(G2tensor(12),RedSet_5(3),mass5set(:,2),  & 
G1tensor(37),G1tensor(38),G1tensor(39),G1tensor(40),G1tensor(41),G1tensor(42))
call G_TensorShift(G1tensor(38),4)
call Hotf_5pt_reduction_last(G2tensor(14),RedSet_5(4),mass5set(:,5),  & 
G1tensor(43),G1tensor(44),G1tensor(45),G1tensor(46),G1tensor(47),G1tensor(48))
call G_TensorShift(G1tensor(44),16)
call Hotf_5pt_reduction_last(G2tensor(16),RedSet_5(5),mass5set(:,6),  & 
G1tensor(49),G1tensor(50),G1tensor(51),G1tensor(52),G1tensor(53),G1tensor(54))
call G_TensorShift(G1tensor(50),8)
call Hotf_5pt_reduction_last(G2tensor(22),RedSet_5(7),mass5set(:,6),  & 
G1tensor(55),G1tensor(56),G1tensor(57),G1tensor(58),G1tensor(59),G1tensor(60))
call G_TensorShift(G1tensor(56),8)
call Hotf_5pt_reduction_last(G2tensor(25),RedSet_5(8),mass5set(:,8),  & 
G1tensor(61),G1tensor(62),G1tensor(63),G1tensor(64),G1tensor(65),G1tensor(66))
call G_TensorShift(G1tensor(62),8)
call Hotf_5pt_reduction_last(G2tensor(28),RedSet_5(8),mass5set(:,9),  & 
G1tensor(67),G1tensor(68),G1tensor(69),G1tensor(70),G1tensor(71),G1tensor(72))
call G_TensorShift(G1tensor(68),8)
call ol_merge_tensors(T1sum(1),[G1tensor(1)])
call ol_merge_tensors(T1sum(2),[G1tensor(7)])
call ol_merge_tensors(T1sum(3),[G1tensor(13)])
call ol_merge_tensors(T1sum(4),[G1tensor(19)])
call ol_merge_tensors(T1sum(5),[G1tensor(25)])
call ol_merge_tensors(T1sum(6),[G1tensor(31)])
call ol_merge_tensors(T1sum(7),[G1tensor(37)])
call ol_merge_tensors(T1sum(8),[G1tensor(43)])
call ol_merge_tensors(T1sum(9),[G1tensor(49)])
call ol_merge_tensors(T1sum(10),[G1tensor(55)])
call ol_merge_tensors(T1sum(11),[G1tensor(61)])
call ol_merge_tensors(T1sum(12),[G1tensor(67)])
Gcoeff(:)%j = (c(8)*M(1,:)%j) * den(4)
call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(17),h0tab(:,17),[32,8,3,20],[0,nMT,nMT,nMB],4,2,wf4(:,1),wf4(:,2))
  call Hloop_QA_V(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,17),heltab2x64(:,:,17))
Gcoeff(:)%j = (c(8)*M(1,:)%j) * den(4)
call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(18),h0tab(:,18),[32,3,20,8],[nMB,nMB,nMT,0],4,2,wf4(:,1),wf4(:,2))
  call Hloop_VA_Q(ntryL,G0H64(1),ex6(:),G0H32(2),m3h2x32(:,18),heltab2x64(:,:,18))
  call Hloop_A_Q(ntryL,G0H32(2),32,nMB,G1H32(1),n2h32(9))
Gcoeff(:)%j = (c(8)*M(1,:)%j) * den(39)
call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(19),h0tab(:,19),[40,3,4,16],[0,0,0,0],4,2,wf4(:,4),wf4(:,1))
  call Hloop_QW_A(ntryL,G0H64(1),wf4(:,4),G0H16(1),m3h4x16(:,1),heltab2x64(:,:,19))
  call Hloop_Q_A(ntryL,G0H16(1),40,0,G1H16(1),n2h16(5))
Gcoeff(:)%j = (c(8)*M(1,:)%j) * den(39)
call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(20),h0tab(:,20),[40,3,16,4],[0,0,0,0],4,2,wf4(:,4),wf4(:,1))
  call Hloop_AW_Q(ntryL,G0H64(1),wf4(:,4),G0H16(1),m3h4x16(:,2),heltab2x64(:,:,20))
  call Hloop_A_Q(ntryL,G0H16(1),40,0,G1H16(2),n2h16(6))
Gcoeff(:)%j = (-(c(6)*M(1,:)%j)+c(7)*M(2,:)%j) * den(13)
call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(21),h0tab(:,21),[32,7,16,8],[0,0,nMW,nMB],4,1,wf8(:,9))
  call Hloop_QA_V(ntryL,G0H64(1),ex6(:),G0H32(3),m3h2x32(:,19),heltab2x64(:,:,21))
Gcoeff(:)%j = (-(c(6)*M(1,:)%j)+c(7)*M(2,:)%j) * den(13)
call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(22),h0tab(:,22),[32,7,16,8],[nMW,0,0,nMT],4,1,wf8(:,9))
  call Hloop_QA_W(ntryL,G0H64(1),ex6(:),G0H32(4),m3h2x32(:,20),heltab2x64(:,:,22))
Gcoeff(:)%j = (-(c(6)*M(1,:)%j)+c(7)*M(2,:)%j) * den(13)
call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(23),h0tab(:,23),[32,8,7,16],[nMT,0,0,nMW],4,1,wf8(:,9))
  call Hloop_WA_Q(ntryL,G0H64(1),ex6(:),G0H32(5),m3h2x32(:,21),heltab2x64(:,:,23))
  call Hloop_A_Q(ntryL,G0H32(5),32,nMT,G1H32(2),n2h32(10))
Gcoeff(:)%j = (-(c(6)*M(1,:)%j)+c(7)*M(2,:)%j) * den(13)
call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(24),h0tab(:,24),[32,8,7,16],[nMB,nMW,0,0],4,1,wf8(:,9))
  call Hloop_VA_Q(ntryL,G0H64(1),ex6(:),G0H32(6),m3h2x32(:,22),heltab2x64(:,:,24))
  call Hloop_A_Q(ntryL,G0H32(6),32,nMB,G1H32(3),n2h32(11))
Gcoeff(:)%j = (-(c(6)*M(1,:)%j)+c(7)*M(2,:)%j) * den(7)
call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(25),h0tab(:,25),[32,4,16,11],[0,0,nMW,nMB],4,1,wf8(:,3))
  call Hloop_QA_V(ntryL,G0H64(1),ex6(:),G0H32(7),m3h2x32(:,23),heltab2x64(:,:,25))
Gcoeff(:)%j = (-(c(6)*M(1,:)%j)+c(7)*M(2,:)%j) * den(7)
call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(26),h0tab(:,26),[32,4,16,11],[nMW,0,0,nMT],4,1,wf8(:,3))
  call Hloop_QA_W(ntryL,G0H64(1),ex6(:),G0H32(8),m3h2x32(:,24),heltab2x64(:,:,26))
Gcoeff(:)%j = (-(c(6)*M(1,:)%j)+c(7)*M(2,:)%j) * den(7)
call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(27),h0tab(:,27),[32,11,4,16],[nMT,0,0,nMW],4,1,wf8(:,3))
  call Hloop_WA_Q(ntryL,G0H64(1),ex6(:),G0H32(2),m3h2x32(:,25),heltab2x64(:,:,27))
  call Hloop_A_Q(ntryL,G0H32(2),32,nMT,G1H32(4),n2h32(12))
Gcoeff(:)%j = (-(c(6)*M(1,:)%j)+c(7)*M(2,:)%j) * den(7)
call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(28),h0tab(:,28),[32,11,4,16],[nMB,nMW,0,0],4,1,wf8(:,3))
  call Hloop_VA_Q(ntryL,G0H64(1),ex6(:),G0H32(5),m3h2x32(:,26),heltab2x64(:,:,28))
  call Hloop_A_Q(ntryL,G0H32(5),32,nMB,G1H32(5),n2h32(13))
Gcoeff(:)%j = (-(c(6)*M(1,:)%j)+c(7)*M(2,:)%j) * den(28)
call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(29),h0tab(:,29),[32,8,4,19],[nMT,0,0,nMW],4,1,wf8(:,30))
  call Hloop_WA_Q(ntryL,G0H64(1),ex6(:),G0H32(6),m3h2x32(:,27),heltab2x64(:,:,29))
  call Hloop_A_Q(ntryL,G0H32(6),32,nMT,G1H32(6),n2h32(14))
Gcoeff(:)%j = (-(c(6)*M(1,:)%j)+c(7)*M(2,:)%j) * den(28)
call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(30),h0tab(:,30),[32,8,4,19],[nMB,nMW,0,0],4,1,wf8(:,30))
  call Hloop_VA_Q(ntryL,G0H64(1),ex6(:),G0H32(2),m3h2x32(:,28),heltab2x64(:,:,30))
  call Hloop_A_Q(ntryL,G0H32(2),32,nMB,G1H32(7),n2h32(15))
Gcoeff(:)%j = (-(c(6)*M(1,:)%j)+c(7)*M(2,:)%j) * den(28)
call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(31),h0tab(:,31),[32,4,19,8],[nMW,0,0,nMT],4,1,wf8(:,30))
  call Hloop_QA_W(ntryL,G0H64(1),ex6(:),G0H32(5),m3h2x32(:,29),heltab2x64(:,:,31))
Gcoeff(:)%j = (-(c(6)*M(1,:)%j)+c(7)*M(2,:)%j) * den(28)
call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(32),h0tab(:,32),[32,4,19,8],[0,0,nMW,nMB],4,1,wf8(:,30))
  call Hloop_QA_V(ntryL,G0H64(1),ex6(:),G0H32(6),m3h2x32(:,30),heltab2x64(:,:,32))
Gcoeff(:)%j = (-(c(6)*M(1,:)%j)+c(7)*M(2,:)%j) * den(22)
call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(33),h0tab(:,33),[35,8,4,16],[nMT,0,0,nMW],4,1,wf8(:,23))
  call Hloop_WA_Q(ntryL,G0H64(1),wf8(:,23),G0H8(1),m3h8x8(:,1),heltab2x64(:,:,33))
  call Hloop_A_Q(ntryL,G0H8(1),35,nMT,G1H8(1),n2h8(9))
Gcoeff(:)%j = (-(c(6)*M(1,:)%j)+c(7)*M(2,:)%j) * den(22)
call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(34),h0tab(:,34),[35,8,4,16],[nMB,nMW,0,0],4,1,wf8(:,23))
  call Hloop_VA_Q(ntryL,G0H64(1),wf8(:,23),G0H8(2),m3h8x8(:,2),heltab2x64(:,:,34))
  call Hloop_A_Q(ntryL,G0H8(2),35,nMB,G1H8(3),n2h8(10))
Gcoeff(:)%j = (-(c(6)*M(1,:)%j)+c(7)*M(2,:)%j) * den(22)
call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(35),h0tab(:,35),[35,4,16,8],[0,0,nMW,nMB],4,1,wf8(:,23))
  call Hloop_QA_V(ntryL,G0H64(1),wf8(:,23),G0H8(1),m3h8x8(:,3),heltab2x64(:,:,35))
Gcoeff(:)%j = (-(c(6)*M(1,:)%j)+c(7)*M(2,:)%j) * den(22)
call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(36),h0tab(:,36),[35,4,16,8],[nMW,0,0,nMT],4,1,wf8(:,23))
  call Hloop_QA_W(ntryL,G0H64(1),wf8(:,23),G0H8(2),m3h8x8(:,4),heltab2x64(:,:,36))
  call Hloop_VQ_A(ntryL,G0H32(1),ex4(:),G0H16(1),m3h2x16(:,9),heltab2x32(:,:,17))
  call Hloop_Q_A(ntryL,G0H16(1),40,nMT,G1H16(3),n2h16(7))
  call Hloop_AZ_Q(ntryL,G1H32(1),wf4(:,1),G1H8(2),ngZd,m3h4x8(:,9),heltab2x32(:,:,18))
  call Hloop_A_Q(ntryL,G1H8(2),35,nMB,G2H8(3),n2h8(11))
  call Hloop_QZ_A(ntryL,G1H16(1),wf4(:,1),G1H4(5),ngZu,m3h4x4(:,5),heltab2x16(:,:,9))
  call Hloop_Q_A(ntryL,G1H4(5),43,0,G2H4(1),n2h4(10))
  call Hloop_AZ_Q(ntryL,G1H16(2),wf4(:,1),G1H4(6),ngZd,m3h4x4(:,6),heltab2x16(:,:,10))
  call Hloop_A_Q(ntryL,G1H4(6),43,0,G2H4(2),n2h4(11))
  call Hloop_VA_Q(ntryL,G0H32(3),wf8(:,9),G0H4(1),m3h8x4(:,1),heltab2x32(:,:,19))
  call Hloop_A_Q(ntryL,G0H4(1),39,0,G1H4(7),n2h4(12))
  call Hloop_WA_Q(ntryL,G0H32(4),wf8(:,9),G0H4(1),m3h8x4(:,2),heltab2x32(:,:,20))
  call Hloop_A_Q(ntryL,G0H4(1),39,0,G1H4(8),n2h4(13))
  call Hloop_AQ_V(ntryL,G1H32(2),ex4(:),G1H16(4),m3h2x16(:,10),heltab2x32(:,:,21))
  call Hloop_AQ_W(ntryL,G1H32(3),ex4(:),G1H16(5),m3h2x16(:,11),heltab2x32(:,:,22))
  call Hloop_VA_Q(ntryL,G0H32(7),ex3(:),G0H16(1),m3h2x16(:,12),heltab2x32(:,:,23))
  call Hloop_A_Q(ntryL,G0H16(1),36,0,G1H16(6),n2h16(8))
  call Hloop_WA_Q(ntryL,G0H32(8),ex3(:),G0H16(1),m3h2x16(:,13),heltab2x32(:,:,24))
  call Hloop_A_Q(ntryL,G0H16(1),36,0,G1H16(7),n2h16(9))
  call Hloop_AQ_V(ntryL,G1H32(4),wf8(:,3),G1H4(11),m3h8x4(:,3),heltab2x32(:,:,25))
  call Hloop_AQ_W(ntryL,G1H32(5),wf8(:,3),G1H4(12),m3h8x4(:,4),heltab2x32(:,:,26))
  call Hloop_AQ_V(ntryL,G1H32(6),ex4(:),G1H16(8),m3h2x16(:,14),heltab2x32(:,:,27))
  call Hloop_AQ_W(ntryL,G1H32(7),ex4(:),G1H16(1),m3h2x16(:,15),heltab2x32(:,:,28))
  call Hloop_WA_Q(ntryL,G0H32(5),ex3(:),G0H16(1),m3h2x16(:,16),heltab2x32(:,:,29))
  call Hloop_A_Q(ntryL,G0H16(1),36,0,G1H16(2),n2h16(10))
  call Hloop_VA_Q(ntryL,G0H32(6),ex3(:),G0H16(1),m3h2x16(:,17),heltab2x32(:,:,30))
  call Hloop_A_Q(ntryL,G0H16(1),36,0,G1H16(9),n2h16(11))
  call Hloop_AQ_V(ntryL,G1H8(1),ex4(:),G1H4(13),m3h2x4(:,9),heltab2x8(:,:,17))
  call Hloop_AQ_W(ntryL,G1H8(3),ex4(:),G1H4(14),m3h2x4(:,10),heltab2x8(:,:,18))
  call Hloop_VA_Q(ntryL,G0H8(1),ex3(:),G0H4(1),m3h2x4(:,11),heltab2x8(:,:,19))
  call Hloop_A_Q(ntryL,G0H4(1),39,0,G1H4(17),n2h4(14))
  call Hloop_WA_Q(ntryL,G0H8(2),ex3(:),G0H4(1),m3h2x4(:,12),heltab2x8(:,:,20))
  call Hloop_A_Q(ntryL,G0H4(1),39,0,G1H4(18),n2h4(15))
  call ol_merge(ntryL,G1H4(13),[G1H4(3)])
  call ol_merge(ntryL,G1H4(11),[G1H4(4)])
  call ol_merge(ntryL,G1H4(14),[G1H4(9)])
  call ol_merge(ntryL,G1H4(12),[G1H4(28),G1H4(10)])
  call Hloop_VA_Q(ntryL,G1H4(13),ex3(:),G1H2(7),m3h2x2(:,25),heltab2x4(:,:,25))
  call Hloop_A_Q(ntryL,G1H2(7),47,0,G2H2(1),n2h2(22))
  call Hloop_VA_Q(ntryL,G1H4(11),ex3(:),G1H2(8),m3h2x2(:,26),heltab2x4(:,:,26))
  call Hloop_A_Q(ntryL,G1H2(8),47,0,G2H2(2),n2h2(23))
  call Hloop_WA_Q(ntryL,G1H4(14),ex3(:),G1H2(12),m3h2x2(:,27),heltab2x4(:,:,27))
  call Hloop_A_Q(ntryL,G1H2(12),47,0,G2H2(3),n2h2(24))
  call Hloop_WA_Q(ntryL,G1H4(12),ex3(:),G1H2(1),m3h2x2(:,28),heltab2x4(:,:,28))
  call Hloop_A_Q(ntryL,G1H2(1),47,0,G2H2(4),n2h2(25))
  call Hloop_AZ_Q(ntryL,G1H8(5),wf4(:,1),G1H2(13),ngZu,m3h4x2(:,9),heltab2x8(:,:,21))
  call Hloop_A_Q(ntryL,G1H2(13),47,0,G2H2(5),n2h2(26))
  call Hloop_AZ_Q(ntryL,G1H8(6),wf4(:,1),G1H2(17),ngZu,m3h4x2(:,10),heltab2x8(:,:,22))
  call Hloop_A_Q(ntryL,G1H2(17),47,0,G2H2(6),n2h2(27))
  call Hloop_AZ_Q(ntryL,G1H8(11),wf4(:,1),G1H2(18),ngZd,m3h4x2(:,11),heltab2x8(:,:,23))
  call Hloop_A_Q(ntryL,G1H2(18),47,0,G2H2(8),n2h2(28))
  call Hloop_AZ_Q(ntryL,G1H8(12),wf4(:,1),G1H2(19),ngZd,m3h4x2(:,12),heltab2x8(:,:,24))
  call Hloop_A_Q(ntryL,G1H2(19),47,0,G2H2(9),n2h2(29))
  call Hloop_VQ_A(ntryL,G1H4(15),ex5(:),G1H2(23),m3h2x2(:,29),heltab2x4(:,:,29))
  call Hloop_Q_A(ntryL,G1H2(23),59,0,G2H2(11),n2h2(30))
  call Hloop_VQ_A(ntryL,G1H4(16),ex5(:),G1H2(24),m3h2x2(:,30),heltab2x4(:,:,30))
  call Hloop_Q_A(ntryL,G1H2(24),59,0,G2H2(12),n2h2(31))
  call Hloop_WQ_A(ntryL,G1H4(21),ex5(:),G1H2(25),m3h2x2(:,31),heltab2x4(:,:,31))
  call Hloop_Q_A(ntryL,G1H2(25),59,0,G2H2(14),n2h2(32))
  call Hloop_WQ_A(ntryL,G1H4(22),ex5(:),G1H2(29),m3h2x2(:,32),heltab2x4(:,:,32))
  call Hloop_Q_A(ntryL,G1H2(29),59,0,G2H2(15),n2h2(33))
  call Hloop_WA_Q(ntryL,G1H4(27),ex3(:),G1H2(30),m3h2x2(:,33),heltab2x4(:,:,33))
  call Hloop_A_Q(ntryL,G1H2(30),47,0,G2H2(17),n2h2(34))
  call Hloop_QZ_A(ntryL,G1H16(3),wf4(:,1),G1H4(19),ngZu,m3h4x4(:,7),heltab2x16(:,:,11))
  call Hloop_Q_A(ntryL,G1H4(19),43,nMT,G2H4(3),n2h4(16))
call Hotf_4pt_reduction(G2H8(3),RedSet_4(25),mass4set(:,1),  & 
G1H8(4),G1H8(7),G1H8(8),G1H8(9),G1H8(10),8)
call HG1shiftOLR(G1H8(7),8,8)
  call Hloop_QA_V(ntryL,G2H4(1),ex3(:),G2H2(18),m3h2x2(:,34),heltab2x4(:,:,34))
  call Hloop_AQ_V(ntryL,G2H4(2),ex5(:),G2H2(20),m3h2x2(:,35),heltab2x4(:,:,35))
  call Hloop_AQ_W(ntryL,G1H4(7),ex5(:),G1H2(31),m3h2x2(:,36),heltab2x4(:,:,36))
  call Hloop_AQ_V(ntryL,G1H4(8),ex5(:),G1H2(35),m3h2x2(:,37),heltab2x4(:,:,37))
  call Hloop_VA_Q(ntryL,G1H16(4),wf8(:,9),G1H2(7),m3h8x2(:,1),heltab2x16(:,:,12))
  call Hloop_A_Q(ntryL,G1H2(7),47,0,G2H2(21),n2h2(35))
  call Hloop_WA_Q(ntryL,G1H16(5),wf8(:,9),G1H2(8),m3h8x2(:,2),heltab2x16(:,:,13))
  call Hloop_A_Q(ntryL,G1H2(8),47,0,G2H2(23),n2h2(36))
  call Hloop_AQ_W(ntryL,G1H16(6),ex5(:),G1H8(13),m3h2x8(:,5),heltab2x16(:,:,14))
  call Hloop_AQ_V(ntryL,G1H16(7),ex5(:),G1H8(14),m3h2x8(:,6),heltab2x16(:,:,15))
  call Hloop_VA_Q(ntryL,G1H16(8),ex3(:),G1H8(2),m3h2x8(:,7),heltab2x16(:,:,16))
  call Hloop_A_Q(ntryL,G1H8(2),44,0,G2H8(4),n2h8(12))
  call Hloop_WA_Q(ntryL,G1H16(1),ex3(:),G1H8(1),m3h2x8(:,8),heltab2x16(:,:,17))
  call Hloop_A_Q(ntryL,G1H8(1),44,0,G2H8(1),n2h8(13))
  call Hloop_AQ_V(ntryL,G1H16(2),wf8(:,30),G1H2(12),m3h8x2(:,3),heltab2x16(:,:,18))
  call Hloop_AQ_W(ntryL,G1H16(9),wf8(:,30),G1H2(1),m3h8x2(:,4),heltab2x16(:,:,19))
  call Hloop_AQ_W(ntryL,G1H4(17),ex5(:),G1H2(13),m3h2x2(:,38),heltab2x4(:,:,38))
  call Hloop_AQ_V(ntryL,G1H4(18),ex5(:),G1H2(17),m3h2x2(:,39),heltab2x4(:,:,39))
  call Hloop_AW_Q(ntryL,G1H8(4),wf4(:,2),G1H2(18),m3h4x2(:,13),heltab2x8(:,:,25))
  call Hloop_A_Q(ntryL,G1H2(18),55,nMT,G2H2(24),n2h2(37))
call HGT_raise_alpha_OLR(G1H8(7),1,1,8)
call HGT_raise_alpha_invQ_OLR(G1H8(7),2,5,8)
  call Hloop_VQ_A(ntryL,G1H8(7),ex4(:),G1H4(20),m3h2x4(:,13),heltab2x8(:,:,26))
  call Hloop_AW_Q(ntryL,G1H8(9),wf4(:,2),G1H2(19),m3h4x2(:,14),heltab2x8(:,:,27))
  call Hloop_A_Q(ntryL,G1H2(19),55,nMT,G2H2(26),n2h2(38))
  call Hloop_AW_Q(ntryL,G1H8(10),wf4(:,2),G1H2(23),m3h4x2(:,15),heltab2x8(:,:,28))
  call Hloop_A_Q(ntryL,G1H2(23),55,nMT,G2H2(27),n2h2(39))
  call ol_merge(ntryL,G2H2(21),[G2H2(13)])
  call ol_merge(ntryL,G2H2(23),[G2H2(25),G2H2(16)])
  call ol_merge(ntryL,G1H2(22),[G1H2(11)])
  call ol_merge(ntryL,G1H2(1),[G1H2(28),G1H2(16)])
  call ol_merge(ntryL,G1H2(17),[G1H2(20)])
  call ol_merge(ntryL,G1H2(35),[G1H2(33),G1H2(21)])
  call ol_merge(ntryL,G1H2(31),[G1H2(27)])
  call ol_merge(ntryL,G1H2(12),[G1H2(34)])
call HGT_w2_OLR(G1H2(2),1,1,2)
call HGT_w2_invQ_OLR(G1H2(2),2,5,2)
  call Hloop_VA_Q(ntryL,G1H2(2),ex3(:),G1H1(1),m3h2x1(:,31),heltab2x2(:,:,31))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,0,G2tensor(1),n2h1(17))
  call Hcheck_last_AQ_W(ntryL,l_switch,G2H2(7),ex5(:),G2tensor(19),m3h2x1(:,32),heltab2x2(:,:,32))
call HGT_w2_OLR(G1H2(3),1,1,2)
call HGT_w2_invQ_OLR(G1H2(3),2,5,2)
  call Hloop_WA_Q(ntryL,G1H2(3),ex3(:),G1H1(1),m3h2x1(:,33),heltab2x2(:,:,33))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,0,G2tensor(2),n2h1(18))
  call Hcheck_last_AQ_V(ntryL,l_switch,G2H2(10),ex5(:),G2tensor(4),m3h2x1(:,34),heltab2x2(:,:,34))
call HGT_w2_OLR(G1H4(2),1,1,4)
call HGT_w2_invQ_OLR(G1H4(2),2,5,4)
  call Hloop_AZ_Q(ntryL,G1H4(2),wf4(:,1),G1H1(1),ngZu,m3h4x1(:,1),heltab2x4(:,:,40))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,0,G2tensor(6),n2h1(19))
  call Hcheck_last_AQ_W(ntryL,l_switch,G2H2(21),ex5(:),G2tensor(8),m3h2x1(:,35),heltab2x2(:,:,35))
call HGT_w2_OLR(G1H4(1),1,1,4)
call HGT_w2_invQ_OLR(G1H4(1),2,5,4)
  call Hloop_AZ_Q(ntryL,G1H4(1),wf4(:,1),G1H1(1),ngZd,m3h4x1(:,2),heltab2x4(:,:,41))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,0,G2tensor(10),n2h1(20))
  call Hcheck_last_AQ_V(ntryL,l_switch,G2H2(23),ex5(:),G2tensor(12),m3h2x1(:,36),heltab2x2(:,:,36))
call HGT_w2_OLR(G1H2(4),1,1,2)
call HGT_w2_invQ_OLR(G1H2(4),2,5,2)
  call Hloop_VQ_A(ntryL,G1H2(4),ex5(:),G1H1(1),m3h2x1(:,37),heltab2x2(:,:,37))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(14),n2h1(21))
  call Hcheck_last_QA_W(ntryL,l_switch,G2H2(19),ex3(:),G2tensor(16),m3h2x1(:,38),heltab2x2(:,:,38))
call HGT_w2_OLR(G1H2(5),1,1,2)
call HGT_w2_invQ_OLR(G1H2(5),2,5,2)
  call Hloop_WQ_A(ntryL,G1H2(5),ex5(:),G1H1(1),m3h2x1(:,39),heltab2x2(:,:,39))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(22),n2h1(22))
  call Hcheck_last_QA_V(ntryL,l_switch,G2H2(22),ex3(:),G2tensor(25),m3h2x1(:,40),heltab2x2(:,:,40))
call HGT_w2_OLR(G1H2(6),1,1,2)
call HGT_w2_invQ_OLR(G1H2(6),2,5,2)
  call Hloop_WA_Q(ntryL,G1H2(6),ex3(:),G1H1(1),m3h2x1(:,41),heltab2x2(:,:,41))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,0,G2tensor(28),n2h1(23))
  call Hloop_VQ_A(ntryL,G1H2(9),ex4(:),G1H1(1),m3h2x1(:,42),heltab2x2(:,:,42))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,nMT,G2tensor(31),n2h1(24))
  call Hloop_VQ_A(ntryL,G1H2(10),ex4(:),G1H1(1),m3h2x1(:,43),heltab2x2(:,:,43))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,nMT,G2tensor(32),n2h1(25))
  call Hloop_VQ_A(ntryL,G1H2(22),ex4(:),G1H1(1),m3h2x1(:,44),heltab2x2(:,:,44))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,nMT,G2tensor(33),n2h1(26))
  call Hloop_WQ_A(ntryL,G1H2(14),ex4(:),G1H1(1),m3h2x1(:,45),heltab2x2(:,:,45))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,nMB,G2tensor(34),n2h1(27))
  call Hloop_WQ_A(ntryL,G1H2(15),ex4(:),G1H1(1),m3h2x1(:,46),heltab2x2(:,:,46))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,nMB,G2tensor(35),n2h1(28))
  call Hloop_WQ_A(ntryL,G1H2(1),ex4(:),G1H1(1),m3h2x1(:,47),heltab2x2(:,:,47))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,nMB,G2tensor(36),n2h1(29))
  call Hloop_VQ_A(ntryL,G1H2(17),ex4(:),G1H1(1),m3h2x1(:,48),heltab2x2(:,:,48))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,nMT,G2tensor(37),n2h1(30))
  call Hloop_VQ_A(ntryL,G1H2(35),ex4(:),G1H1(1),m3h2x1(:,49),heltab2x2(:,:,49))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,nMT,G2tensor(38),n2h1(31))
  call Hloop_WQ_A(ntryL,G1H2(26),ex4(:),G1H1(1),m3h2x1(:,50),heltab2x2(:,:,50))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,nMB,G2tensor(39),n2h1(32))
  call Hloop_WQ_A(ntryL,G1H2(31),ex4(:),G1H1(1),m3h2x1(:,51),heltab2x2(:,:,51))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,nMB,G2tensor(40),n2h1(33))
  call Hloop_VQ_A(ntryL,G1H2(32),ex4(:),G1H1(1),m3h2x1(:,52),heltab2x2(:,:,52))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,nMT,G2tensor(41),n2h1(34))
  call Hloop_VQ_A(ntryL,G1H2(12),ex4(:),G1H1(1),m3h2x1(:,53),heltab2x2(:,:,53))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,nMT,G2tensor(42),n2h1(35))
  call Hcheck_last_AQ_W(ntryL,l_switch,G2H2(1),ex5(:),G2tensor(43),m3h2x1(:,54),heltab2x2(:,:,54))
  call Hcheck_last_AQ_W(ntryL,l_switch,G2H2(2),ex5(:),G2tensor(44),m3h2x1(:,55),heltab2x2(:,:,55))
  call Hcheck_last_AQ_V(ntryL,l_switch,G2H2(3),ex5(:),G2tensor(45),m3h2x1(:,56),heltab2x2(:,:,56))
  call Hcheck_last_AQ_V(ntryL,l_switch,G2H2(4),ex5(:),G2tensor(46),m3h2x1(:,57),heltab2x2(:,:,57))
  call Hcheck_last_AQ_W(ntryL,l_switch,G2H2(5),ex5(:),G2tensor(47),m3h2x1(:,58),heltab2x2(:,:,58))
  call Hcheck_last_AQ_W(ntryL,l_switch,G2H2(6),ex5(:),G2tensor(48),m3h2x1(:,59),heltab2x2(:,:,59))
  call Hcheck_last_AQ_V(ntryL,l_switch,G2H2(8),ex5(:),G2tensor(49),m3h2x1(:,60),heltab2x2(:,:,60))
  call Hcheck_last_AQ_V(ntryL,l_switch,G2H2(9),ex5(:),G2tensor(50),m3h2x1(:,61),heltab2x2(:,:,61))
  call Hcheck_last_QA_W(ntryL,l_switch,G2H2(11),ex3(:),G2tensor(51),m3h2x1(:,62),heltab2x2(:,:,62))
  call Hcheck_last_QA_W(ntryL,l_switch,G2H2(12),ex3(:),G2tensor(52),m3h2x1(:,63),heltab2x2(:,:,63))
  call Hcheck_last_QA_V(ntryL,l_switch,G2H2(14),ex3(:),G2tensor(53),m3h2x1(:,64),heltab2x2(:,:,64))
  call Hcheck_last_QA_V(ntryL,l_switch,G2H2(15),ex3(:),G2tensor(54),m3h2x1(:,65),heltab2x2(:,:,65))
  call Hcheck_last_AQ_V(ntryL,l_switch,G2H2(17),ex5(:),G2tensor(55),m3h2x1(:,66),heltab2x2(:,:,66))
call Hotf_4pt_reduction(G2H4(3),RedSet_4(21),mass4set(:,2),  & 
G1H4(23),G1H4(24),G1H4(25),G1H4(26),G1H4(29),4)
call HG1shiftOLR(G1H4(24),20,4)
call Hotf_4pt_reduction(G2H2(18),RedSet_4(20),mass4set(:,3),  & 
G1H2(24),G1H2(25),G1H2(29),G1H2(30),G1H2(7),2)
call HG1shiftOLR(G1H2(25),16,2)
call Hotf_4pt_reduction(G2H2(20),RedSet_4(35),mass4set(:,3),  & 
G1H2(8),G1H2(18),G1H2(19),G1H2(23),G1H2(11),2)
call HG1shiftOLR(G1H2(18),4,2)
  call Hloop_WQ_A(ntryL,G1H8(13),wf8(:,3),G1H1(1),m3h8x1(:,1),heltab2x8(:,:,29))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,nMB,G2tensor(56),n2h1(36))
  call Hloop_VQ_A(ntryL,G1H8(14),wf8(:,3),G1H1(1),m3h8x1(:,2),heltab2x8(:,:,30))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,nMT,G2tensor(57),n2h1(37))
  call Hcheck_last_AQ_W(ntryL,l_switch,G2H8(4),wf8(:,30),G2tensor(58),m3h8x1(:,3),heltab2x8(:,:,31))
  call Hcheck_last_AQ_V(ntryL,l_switch,G2H8(1),wf8(:,30),G2tensor(59),m3h8x1(:,4),heltab2x8(:,:,32))
  call Hloop_WQ_A(ntryL,G1H2(13),ex4(:),G1H1(1),m3h2x1(:,67),heltab2x2(:,:,67))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,nMB,G2tensor(60),n2h1(38))
  call Hcheck_last_AQ_V(ntryL,l_switch,G2H2(24),ex4(:),G2tensor(61),m3h2x1(:,68),heltab2x2(:,:,68))
  call Hcheck_last_AQ_V(ntryL,l_switch,G2H2(27),ex4(:),G2tensor(62),m3h2x1(:,69),heltab2x2(:,:,69))
  call Hloop_QW_A(ntryL,G1H4(23),wf4(:,2),G1H1(1),m3h4x1(:,3),heltab2x4(:,:,42))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,nMB,G2tensor(63),n2h1(39))
  call Hloop_QW_A(ntryL,G1H4(24),wf4(:,2),G1H1(1),m3h4x1(:,4),heltab2x4(:,:,43))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),20,nMB,G2tensor(64),n2h1(40))
  call Hloop_QW_A(ntryL,G1H4(29),wf4(:,2),G1H1(1),m3h4x1(:,5),heltab2x4(:,:,44))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,nMB,G2tensor(65),n2h1(41))
  call Hloop_VQ_A(ntryL,G1H2(24),ex5(:),G1H1(1),m3h2x1(:,70),heltab2x2(:,:,70))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(66),n2h1(42))
  call Hloop_VQ_A(ntryL,G1H2(25),ex5(:),G1H1(1),m3h2x1(:,71),heltab2x2(:,:,71))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),16,0,G2tensor(67),n2h1(43))
  call Hloop_VQ_A(ntryL,G1H2(7),ex5(:),G1H1(1),m3h2x1(:,72),heltab2x2(:,:,72))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(68),n2h1(44))
  call Hloop_VA_Q(ntryL,G1H2(8),ex3(:),G1H1(1),m3h2x1(:,73),heltab2x2(:,:,73))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,0,G2tensor(69),n2h1(45))
  call Hloop_VA_Q(ntryL,G1H2(18),ex3(:),G1H1(1),m3h2x1(:,74),heltab2x2(:,:,74))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),4,0,G2tensor(70),n2h1(46))
  call Hloop_VA_Q(ntryL,G1H2(11),ex3(:),G1H1(1),m3h2x1(:,75),heltab2x2(:,:,75))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,0,G2tensor(71),n2h1(47))
  call ol_merge_tensors(G2tensor(11),[G2tensor(3),G1tensor(36),G1tensor(12)])
  call ol_merge_tensors(G2tensor(13),[G2tensor(5),G1tensor(42),G1tensor(18)])
  call ol_merge_tensors(G2tensor(58),[G2tensor(7),G1tensor(24)])
  call ol_merge_tensors(G2tensor(59),[G2tensor(9),G1tensor(30)])
  call ol_merge_tensors(G2tensor(15),[G1tensor(48)])
  call ol_merge_tensors(G2tensor(17),[G1tensor(50)])
  call ol_merge_tensors(G2tensor(18),[G1tensor(54)])
  call ol_merge_tensors(G2tensor(20),[G1tensor(2)])
  call ol_merge_tensors(G2tensor(56),[G2tensor(21),G1tensor(6)])
  call ol_merge_tensors(G2tensor(55),[G2tensor(23),G1tensor(56),G1tensor(45)])
  call ol_merge_tensors(G2tensor(24),[G1tensor(60)])
  call ol_merge_tensors(G2tensor(47),[G2tensor(26),G1tensor(62),G1tensor(21)])
  call ol_merge_tensors(G2tensor(27),[G1tensor(66)])
  call ol_merge_tensors(G2tensor(49),[G2tensor(29),G1tensor(68),G1tensor(27)])
  call ol_merge_tensors(G2tensor(30),[G1tensor(72)])
  call ol_merge_tensors(G2tensor(34),[G1tensor(3)])
  call ol_merge_tensors(G2tensor(35),[G1tensor(4)])
  call ol_merge_tensors(G2tensor(36),[G1tensor(65),G1tensor(5)])
  call ol_merge_tensors(G2tensor(1),[G1tensor(8)])
  call ol_merge_tensors(G2tensor(43),[G1tensor(9)])
  call ol_merge_tensors(G2tensor(44),[G1tensor(10)])
  call ol_merge_tensors(G2tensor(19),[G1tensor(11)])
  call ol_merge_tensors(G2tensor(2),[G1tensor(14)])
  call ol_merge_tensors(G2tensor(45),[G1tensor(15)])
  call ol_merge_tensors(G2tensor(46),[G1tensor(46),G1tensor(16)])
  call ol_merge_tensors(G2tensor(4),[G1tensor(17)])
  call ol_merge_tensors(G2tensor(6),[G1tensor(20)])
  call ol_merge_tensors(G2tensor(48),[G1tensor(22)])
  call ol_merge_tensors(G2tensor(8),[G1tensor(23)])
  call ol_merge_tensors(G2tensor(10),[G1tensor(26)])
  call ol_merge_tensors(G2tensor(50),[G1tensor(28)])
  call ol_merge_tensors(G2tensor(12),[G1tensor(47),G1tensor(29)])
  call ol_merge_tensors(G2tensor(14),[G1tensor(32)])
  call ol_merge_tensors(G2tensor(51),[G1tensor(33)])
  call ol_merge_tensors(G2tensor(52),[G1tensor(34)])
  call ol_merge_tensors(G2tensor(16),[G1tensor(35)])
  call ol_merge_tensors(G2tensor(22),[G1tensor(38)])
  call ol_merge_tensors(G2tensor(53),[G1tensor(39)])
  call ol_merge_tensors(G2tensor(54),[G1tensor(40)])
  call ol_merge_tensors(G2tensor(25),[G1tensor(41)])
  call ol_merge_tensors(G2tensor(28),[G1tensor(44)])
  call ol_merge_tensors(G2tensor(31),[G1tensor(51)])
  call ol_merge_tensors(G2tensor(32),[G1tensor(52)])
  call ol_merge_tensors(G2tensor(33),[G1tensor(59),G1tensor(53)])
  call ol_merge_tensors(G2tensor(37),[G1tensor(57)])
  call ol_merge_tensors(G2tensor(38),[G1tensor(70),G1tensor(58)])
  call ol_merge_tensors(G2tensor(39),[G1tensor(63)])
  call ol_merge_tensors(G2tensor(40),[G1tensor(64)])
  call ol_merge_tensors(G2tensor(41),[G1tensor(69)])
  call ol_merge_tensors(G2tensor(42),[G1tensor(71)])
call Hotf_4pt_reduction_last(G2tensor(11),RedSet_4(9),mass4set(:,4),  & 
G1tensor(1),G1tensor(7),G1tensor(13),G1tensor(19),G1tensor(25))
call G_TensorShift(G1tensor(7),20)
call Hotf_4pt_reduction_last(G2tensor(13),RedSet_4(9),mass4set(:,5),  & 
G1tensor(31),G1tensor(37),G1tensor(43),G1tensor(49),G1tensor(55))
call G_TensorShift(G1tensor(37),20)
call Hotf_4pt_reduction_last(G2tensor(58),RedSet_4(14),mass4set(:,6),  & 
G1tensor(61),G1tensor(67),G1tensor(36),G1tensor(12),G1tensor(42))
call G_TensorShift(G1tensor(67),19)
call Hotf_4pt_reduction_last(G2tensor(59),RedSet_4(14),mass4set(:,7),  & 
G1tensor(18),G1tensor(24),G1tensor(30),G1tensor(48),G1tensor(50))
call G_TensorShift(G1tensor(24),19)
call Hotf_4pt_reduction_last(G2tensor(15),RedSet_4(21),mass4set(:,8),  & 
G1tensor(54),G1tensor(2),G1tensor(6),G1tensor(56),G1tensor(45))
call G_TensorShift(G1tensor(2),20)
call Hotf_4pt_reduction_last(G2tensor(17),RedSet_4(35),mass4set(:,9),  & 
G1tensor(60),G1tensor(62),G1tensor(21),G1tensor(66),G1tensor(68))
call G_TensorShift(G1tensor(62),4)
call Hotf_4pt_reduction_last(G2tensor(18),RedSet_4(26),mass4set(:,10),  & 
G1tensor(27),G1tensor(72),G1tensor(3),G1tensor(4),G1tensor(65))
call G_TensorShift(G1tensor(72),12)
call Hotf_4pt_reduction_last(G2tensor(20),RedSet_4(36),mass4set(:,11),  & 
G1tensor(5),G1tensor(8),G1tensor(9),G1tensor(10),G1tensor(11))
call G_TensorShift(G1tensor(8),3)
call Hotf_4pt_reduction_last(G2tensor(56),RedSet_4(4),mass4set(:,12),  & 
G1tensor(14),G1tensor(15),G1tensor(46),G1tensor(16),G1tensor(17))
call G_TensorShift(G1tensor(15),11)
call Hotf_4pt_reduction_last(G2tensor(55),RedSet_4(20),mass4set(:,9),  & 
G1tensor(20),G1tensor(22),G1tensor(23),G1tensor(26),G1tensor(28))
call G_TensorShift(G1tensor(22),16)
call Hotf_4pt_reduction_last(G2tensor(24),RedSet_4(30),mass4set(:,10),  & 
G1tensor(47),G1tensor(29),G1tensor(32),G1tensor(33),G1tensor(34))
call G_TensorShift(G1tensor(29),24)
call Hotf_4pt_reduction_last(G2tensor(47),RedSet_4(11),mass4set(:,13),  & 
G1tensor(35),G1tensor(38),G1tensor(39),G1tensor(40),G1tensor(41))
call G_TensorShift(G1tensor(38),16)
call Hotf_4pt_reduction_last(G2tensor(27),RedSet_4(33),mass4set(:,14),  & 
G1tensor(44),G1tensor(51),G1tensor(52),G1tensor(59),G1tensor(53))
call G_TensorShift(G1tensor(51),24)
call Hotf_4pt_reduction_last(G2tensor(49),RedSet_4(11),mass4set(:,15),  & 
G1tensor(57),G1tensor(70),G1tensor(58),G1tensor(63),G1tensor(64))
call G_TensorShift(G1tensor(70),16)
call Hotf_4pt_reduction_last(G2tensor(30),RedSet_4(33),mass4set(:,16),  & 
G1tensor(69),G1tensor(71),G1tensor(73),G1tensor(74),G1tensor(75))
call G_TensorShift(G1tensor(71),24)
call Hotf_4pt_reduction_last(G2tensor(34),RedSet_4(1),mass4set(:,17),  & 
G1tensor(76),G1tensor(77),G1tensor(78),G1tensor(79),G1tensor(80))
call G_TensorShift(G1tensor(77),8)
call Hotf_4pt_reduction_last(G2tensor(35),RedSet_4(2),mass4set(:,17),  & 
G1tensor(81),G1tensor(82),G1tensor(83),G1tensor(84),G1tensor(85))
call G_TensorShift(G1tensor(82),8)
call Hotf_4pt_reduction_last(G2tensor(36),RedSet_4(3),mass4set(:,12),  & 
G1tensor(86),G1tensor(87),G1tensor(88),G1tensor(89),G1tensor(90))
call G_TensorShift(G1tensor(87),8)
call Hotf_4pt_reduction_last(G2tensor(1),RedSet_4(37),mass4set(:,18),  & 
G1tensor(91),G1tensor(92),G1tensor(93),G1tensor(94),G1tensor(95))
call G_TensorShift(G1tensor(92),4)
call Hotf_4pt_reduction_last(G2tensor(43),RedSet_4(6),mass4set(:,6),  & 
G1tensor(96),G1tensor(97),G1tensor(98),G1tensor(99),G1tensor(100))
call G_TensorShift(G1tensor(97),16)
call Hotf_4pt_reduction_last(G2tensor(44),RedSet_4(7),mass4set(:,6),  & 
G1tensor(101),G1tensor(102),G1tensor(103),G1tensor(104),G1tensor(105))
call G_TensorShift(G1tensor(102),16)
call Hotf_4pt_reduction_last(G2tensor(19),RedSet_4(8),mass4set(:,4),  & 
G1tensor(106),G1tensor(107),G1tensor(108),G1tensor(109),G1tensor(110))
call G_TensorShift(G1tensor(107),16)
call Hotf_4pt_reduction_last(G2tensor(2),RedSet_4(37),mass4set(:,5),  & 
G1tensor(111),G1tensor(112),G1tensor(113),G1tensor(114),G1tensor(115))
call G_TensorShift(G1tensor(112),4)
call Hotf_4pt_reduction_last(G2tensor(45),RedSet_4(6),mass4set(:,7),  & 
G1tensor(116),G1tensor(117),G1tensor(118),G1tensor(119),G1tensor(120))
call G_TensorShift(G1tensor(117),16)
call Hotf_4pt_reduction_last(G2tensor(46),RedSet_4(7),mass4set(:,7),  & 
G1tensor(121),G1tensor(122),G1tensor(123),G1tensor(124),G1tensor(125))
call G_TensorShift(G1tensor(122),16)
call Hotf_4pt_reduction_last(G2tensor(4),RedSet_4(8),mass4set(:,19),  & 
G1tensor(126),G1tensor(127),G1tensor(128),G1tensor(129),G1tensor(130))
call G_TensorShift(G1tensor(127),16)
call Hotf_4pt_reduction_last(G2tensor(6),RedSet_4(38),mass4set(:,20),  & 
G1tensor(131),G1tensor(132),G1tensor(133),G1tensor(134),G1tensor(135))
call G_TensorShift(G1tensor(132),3)
call Hotf_4pt_reduction_last(G2tensor(48),RedSet_4(12),mass4set(:,6),  & 
G1tensor(136),G1tensor(137),G1tensor(138),G1tensor(139),G1tensor(140))
call G_TensorShift(G1tensor(137),16)
call Hotf_4pt_reduction_last(G2tensor(8),RedSet_4(13),mass4set(:,6),  & 
G1tensor(141),G1tensor(142),G1tensor(143),G1tensor(144),G1tensor(145))
call G_TensorShift(G1tensor(142),16)
call Hotf_4pt_reduction_last(G2tensor(10),RedSet_4(38),mass4set(:,7),  & 
G1tensor(146),G1tensor(147),G1tensor(148),G1tensor(149),G1tensor(150))
call G_TensorShift(G1tensor(147),3)
call Hotf_4pt_reduction_last(G2tensor(50),RedSet_4(12),mass4set(:,21),  & 
G1tensor(151),G1tensor(152),G1tensor(153),G1tensor(154),G1tensor(155))
call G_TensorShift(G1tensor(152),16)
call Hotf_4pt_reduction_last(G2tensor(12),RedSet_4(13),mass4set(:,7),  & 
G1tensor(156),G1tensor(157),G1tensor(158),G1tensor(159),G1tensor(160))
call G_TensorShift(G1tensor(157),16)
call Hotf_4pt_reduction_last(G2tensor(14),RedSet_4(39),mass4set(:,18),  & 
G1tensor(161),G1tensor(162),G1tensor(163),G1tensor(164),G1tensor(165))
call G_TensorShift(G1tensor(162),16)
call Hotf_4pt_reduction_last(G2tensor(51),RedSet_4(16),mass4set(:,6),  & 
G1tensor(166),G1tensor(167),G1tensor(168),G1tensor(169),G1tensor(170))
call G_TensorShift(G1tensor(167),4)
call Hotf_4pt_reduction_last(G2tensor(52),RedSet_4(17),mass4set(:,6),  & 
G1tensor(171),G1tensor(172),G1tensor(173),G1tensor(174),G1tensor(175))
call G_TensorShift(G1tensor(172),4)
call Hotf_4pt_reduction_last(G2tensor(16),RedSet_4(18),mass4set(:,4),  & 
G1tensor(176),G1tensor(177),G1tensor(178),G1tensor(179),G1tensor(180))
call G_TensorShift(G1tensor(177),4)
call Hotf_4pt_reduction_last(G2tensor(22),RedSet_4(39),mass4set(:,5),  & 
G1tensor(181),G1tensor(182),G1tensor(183),G1tensor(184),G1tensor(185))
call G_TensorShift(G1tensor(182),16)
call Hotf_4pt_reduction_last(G2tensor(53),RedSet_4(16),mass4set(:,7),  & 
G1tensor(186),G1tensor(187),G1tensor(188),G1tensor(189),G1tensor(190))
call G_TensorShift(G1tensor(187),4)
call Hotf_4pt_reduction_last(G2tensor(54),RedSet_4(17),mass4set(:,7),  & 
G1tensor(191),G1tensor(192),G1tensor(193),G1tensor(194),G1tensor(195))
call G_TensorShift(G1tensor(192),4)
call Hotf_4pt_reduction_last(G2tensor(25),RedSet_4(18),mass4set(:,19),  & 
G1tensor(196),G1tensor(197),G1tensor(198),G1tensor(199),G1tensor(200))
call G_TensorShift(G1tensor(197),4)
call Hotf_4pt_reduction_last(G2tensor(28),RedSet_4(40),mass4set(:,8),  & 
G1tensor(201),G1tensor(202),G1tensor(203),G1tensor(204),G1tensor(205))
call G_TensorShift(G1tensor(202),4)
call Hotf_4pt_reduction_last(G2tensor(31),RedSet_4(23),mass4set(:,16),  & 
G1tensor(206),G1tensor(207),G1tensor(208),G1tensor(209),G1tensor(210))
call G_TensorShift(G1tensor(207),8)
call Hotf_4pt_reduction_last(G2tensor(32),RedSet_4(24),mass4set(:,16),  & 
G1tensor(211),G1tensor(212),G1tensor(213),G1tensor(214),G1tensor(215))
call G_TensorShift(G1tensor(212),8)
call Hotf_4pt_reduction_last(G2tensor(33),RedSet_4(25),mass4set(:,10),  & 
G1tensor(216),G1tensor(217),G1tensor(218),G1tensor(219),G1tensor(220))
call G_TensorShift(G1tensor(217),8)
call Hotf_4pt_reduction_last(G2tensor(37),RedSet_4(28),mass4set(:,16),  & 
G1tensor(221),G1tensor(222),G1tensor(223),G1tensor(224),G1tensor(225))
call G_TensorShift(G1tensor(222),8)
call Hotf_4pt_reduction_last(G2tensor(38),RedSet_4(29),mass4set(:,16),  & 
G1tensor(226),G1tensor(227),G1tensor(228),G1tensor(229),G1tensor(230))
call G_TensorShift(G1tensor(227),8)
call Hotf_4pt_reduction_last(G2tensor(39),RedSet_4(32),mass4set(:,12),  & 
G1tensor(231),G1tensor(232),G1tensor(233),G1tensor(234),G1tensor(235))
call G_TensorShift(G1tensor(232),8)
call Hotf_4pt_reduction_last(G2tensor(40),RedSet_4(29),mass4set(:,12),  & 
G1tensor(236),G1tensor(237),G1tensor(238),G1tensor(239),G1tensor(240))
call G_TensorShift(G1tensor(237),8)
call Hotf_4pt_reduction_last(G2tensor(41),RedSet_4(32),mass4set(:,22),  & 
G1tensor(241),G1tensor(242),G1tensor(243),G1tensor(244),G1tensor(245))
call G_TensorShift(G1tensor(242),8)
call Hotf_4pt_reduction_last(G2tensor(42),RedSet_4(3),mass4set(:,16),  & 
G1tensor(246),G1tensor(247),G1tensor(248),G1tensor(249),G1tensor(250))
call G_TensorShift(G1tensor(247),8)
call Hotf_4pt_reduction_last(G2tensor(57),RedSet_4(4),mass4set(:,16),  & 
G1tensor(251),G1tensor(252),G1tensor(253),G1tensor(254),G1tensor(255))
call G_TensorShift(G1tensor(252),11)
call Hotf_4pt_reduction_last(G2tensor(60),RedSet_4(28),mass4set(:,12),  & 
G1tensor(256),G1tensor(257),G1tensor(258),G1tensor(259),G1tensor(260))
call G_TensorShift(G1tensor(257),8)
call Hotf_4pt_reduction_last(G2tensor(61),RedSet_4(25),mass4set(:,1),  & 
G1tensor(261),G1tensor(262),G1tensor(263),G1tensor(264),G1tensor(265))
call G_TensorShift(G1tensor(262),8)
call Hotf_4pt_reduction_last(G2tensor(63),RedSet_4(21),mass4set(:,2),  & 
G1tensor(266),G1tensor(267),G1tensor(268),G1tensor(269),G1tensor(270))
call G_TensorShift(G1tensor(267),20)
call Hotf_4pt_reduction_last(G2tensor(66),RedSet_4(20),mass4set(:,3),  & 
G1tensor(271),G1tensor(272),G1tensor(273),G1tensor(274),G1tensor(275))
call G_TensorShift(G1tensor(272),16)
call Hotf_4pt_reduction_last(G2tensor(69),RedSet_4(35),mass4set(:,3),  & 
G1tensor(276),G1tensor(277),G1tensor(278),G1tensor(279),G1tensor(280))
call G_TensorShift(G1tensor(277),4)
call Hotf_4pt_reduction_last(G1tensor(1),RedSet_4(9),mass4set(:,4),  & 
G0tensor(1),G0tensor(2),G0tensor(3),G0tensor(4),G0tensor(5))
call Hotf_4pt_reduction_last(G1tensor(31),RedSet_4(9),mass4set(:,5),  & 
G0tensor(6),G0tensor(7),G0tensor(8),G0tensor(9),G0tensor(10))
call Hotf_4pt_reduction_last(G1tensor(61),RedSet_4(14),mass4set(:,6),  & 
G0tensor(11),G0tensor(12),G0tensor(13),G0tensor(14),G0tensor(15))
call Hotf_4pt_reduction_last(G1tensor(18),RedSet_4(14),mass4set(:,7),  & 
G0tensor(16),G0tensor(17),G0tensor(18),G0tensor(19),G0tensor(20))
call Hotf_4pt_reduction_last(G1tensor(54),RedSet_4(21),mass4set(:,8),  & 
G0tensor(21),G0tensor(22),G0tensor(23),G0tensor(24),G0tensor(25))
call Hotf_4pt_reduction_last(G1tensor(60),RedSet_4(35),mass4set(:,9),  & 
G0tensor(26),G0tensor(27),G0tensor(28),G0tensor(29),G0tensor(30))
call Hotf_4pt_reduction_last(G1tensor(27),RedSet_4(26),mass4set(:,10),  & 
G0tensor(31),G0tensor(32),G0tensor(33),G0tensor(34),G0tensor(35))
call Hotf_4pt_reduction_last(G1tensor(5),RedSet_4(36),mass4set(:,11),  & 
G0tensor(36),G0tensor(37),G0tensor(38),G0tensor(39),G0tensor(40))
call Hotf_4pt_reduction_last(G1tensor(14),RedSet_4(4),mass4set(:,12),  & 
G0tensor(41),G0tensor(42),G0tensor(43),G0tensor(44),G0tensor(45))
call Hotf_4pt_reduction_last(G1tensor(20),RedSet_4(20),mass4set(:,9),  & 
G0tensor(46),G0tensor(47),G0tensor(48),G0tensor(49),G0tensor(50))
call Hotf_4pt_reduction_last(G1tensor(47),RedSet_4(30),mass4set(:,10),  & 
G0tensor(51),G0tensor(52),G0tensor(53),G0tensor(54),G0tensor(55))
call Hotf_4pt_reduction_last(G1tensor(35),RedSet_4(11),mass4set(:,13),  & 
G0tensor(56),G0tensor(57),G0tensor(58),G0tensor(59),G0tensor(60))
call Hotf_4pt_reduction_last(G1tensor(44),RedSet_4(33),mass4set(:,14),  & 
G0tensor(61),G0tensor(62),G0tensor(63),G0tensor(64),G0tensor(65))
call Hotf_4pt_reduction_last(G1tensor(57),RedSet_4(11),mass4set(:,15),  & 
G0tensor(66),G0tensor(67),G0tensor(68),G0tensor(69),G0tensor(70))
call Hotf_4pt_reduction_last(G1tensor(69),RedSet_4(33),mass4set(:,16),  & 
G0tensor(71),G0tensor(72),G0tensor(73),G0tensor(74),G0tensor(75))
call Hotf_4pt_reduction_last(G1tensor(76),RedSet_4(1),mass4set(:,17),  & 
G0tensor(76),G0tensor(77),G0tensor(78),G0tensor(79),G0tensor(80))
call Hotf_4pt_reduction_last(G1tensor(81),RedSet_4(2),mass4set(:,17),  & 
G0tensor(81),G0tensor(82),G0tensor(83),G0tensor(84),G0tensor(85))
call Hotf_4pt_reduction_last(G1tensor(86),RedSet_4(3),mass4set(:,12),  & 
G0tensor(86),G0tensor(87),G0tensor(88),G0tensor(89),G0tensor(90))
call Hotf_4pt_reduction_last(G1tensor(91),RedSet_4(37),mass4set(:,18),  & 
G0tensor(91),G0tensor(92),G0tensor(93),G0tensor(94),G0tensor(95))
call Hotf_4pt_reduction_last(G1tensor(96),RedSet_4(6),mass4set(:,6),  & 
G0tensor(96),G0tensor(97),G0tensor(98),G0tensor(99),G0tensor(100))
call Hotf_4pt_reduction_last(G1tensor(101),RedSet_4(7),mass4set(:,6),  & 
G0tensor(101),G0tensor(102),G0tensor(103),G0tensor(104),G0tensor(105))
call Hotf_4pt_reduction_last(G1tensor(106),RedSet_4(8),mass4set(:,4),  & 
G0tensor(106),G0tensor(107),G0tensor(108),G0tensor(109),G0tensor(110))
call Hotf_4pt_reduction_last(G1tensor(111),RedSet_4(37),mass4set(:,5),  & 
G0tensor(111),G0tensor(112),G0tensor(113),G0tensor(114),G0tensor(115))
call Hotf_4pt_reduction_last(G1tensor(116),RedSet_4(6),mass4set(:,7),  & 
G0tensor(116),G0tensor(117),G0tensor(118),G0tensor(119),G0tensor(120))
call Hotf_4pt_reduction_last(G1tensor(121),RedSet_4(7),mass4set(:,7),  & 
G0tensor(121),G0tensor(122),G0tensor(123),G0tensor(124),G0tensor(125))
call Hotf_4pt_reduction_last(G1tensor(126),RedSet_4(8),mass4set(:,19),  & 
G0tensor(126),G0tensor(127),G0tensor(128),G0tensor(129),G0tensor(130))
call Hotf_4pt_reduction_last(G1tensor(131),RedSet_4(38),mass4set(:,20),  & 
G0tensor(131),G0tensor(132),G0tensor(133),G0tensor(134),G0tensor(135))
call Hotf_4pt_reduction_last(G1tensor(136),RedSet_4(12),mass4set(:,6),  & 
G0tensor(136),G0tensor(137),G0tensor(138),G0tensor(139),G0tensor(140))
call Hotf_4pt_reduction_last(G1tensor(141),RedSet_4(13),mass4set(:,6),  & 
G0tensor(141),G0tensor(142),G0tensor(143),G0tensor(144),G0tensor(145))
call Hotf_4pt_reduction_last(G1tensor(146),RedSet_4(38),mass4set(:,7),  & 
G0tensor(146),G0tensor(147),G0tensor(148),G0tensor(149),G0tensor(150))
call Hotf_4pt_reduction_last(G1tensor(151),RedSet_4(12),mass4set(:,21),  & 
G0tensor(151),G0tensor(152),G0tensor(153),G0tensor(154),G0tensor(155))
call Hotf_4pt_reduction_last(G1tensor(156),RedSet_4(13),mass4set(:,7),  & 
G0tensor(156),G0tensor(157),G0tensor(158),G0tensor(159),G0tensor(160))
call Hotf_4pt_reduction_last(G1tensor(161),RedSet_4(39),mass4set(:,18),  & 
G0tensor(161),G0tensor(162),G0tensor(163),G0tensor(164),G0tensor(165))
call Hotf_4pt_reduction_last(G1tensor(166),RedSet_4(16),mass4set(:,6),  & 
G0tensor(166),G0tensor(167),G0tensor(168),G0tensor(169),G0tensor(170))
call Hotf_4pt_reduction_last(G1tensor(171),RedSet_4(17),mass4set(:,6),  & 
G0tensor(171),G0tensor(172),G0tensor(173),G0tensor(174),G0tensor(175))
call Hotf_4pt_reduction_last(G1tensor(176),RedSet_4(18),mass4set(:,4),  & 
G0tensor(176),G0tensor(177),G0tensor(178),G0tensor(179),G0tensor(180))
call Hotf_4pt_reduction_last(G1tensor(181),RedSet_4(39),mass4set(:,5),  & 
G0tensor(181),G0tensor(182),G0tensor(183),G0tensor(184),G0tensor(185))
call Hotf_4pt_reduction_last(G1tensor(186),RedSet_4(16),mass4set(:,7),  & 
G0tensor(186),G0tensor(187),G0tensor(188),G0tensor(189),G0tensor(190))
call Hotf_4pt_reduction_last(G1tensor(191),RedSet_4(17),mass4set(:,7),  & 
G0tensor(191),G0tensor(192),G0tensor(193),G0tensor(194),G0tensor(195))
call Hotf_4pt_reduction_last(G1tensor(196),RedSet_4(18),mass4set(:,19),  & 
G0tensor(196),G0tensor(197),G0tensor(198),G0tensor(199),G0tensor(200))
call Hotf_4pt_reduction_last(G1tensor(201),RedSet_4(40),mass4set(:,8),  & 
G0tensor(201),G0tensor(202),G0tensor(203),G0tensor(204),G0tensor(205))
call Hotf_4pt_reduction_last(G1tensor(206),RedSet_4(23),mass4set(:,16),  & 
G0tensor(206),G0tensor(207),G0tensor(208),G0tensor(209),G0tensor(210))
call Hotf_4pt_reduction_last(G1tensor(211),RedSet_4(24),mass4set(:,16),  & 
G0tensor(211),G0tensor(212),G0tensor(213),G0tensor(214),G0tensor(215))
call Hotf_4pt_reduction_last(G1tensor(216),RedSet_4(25),mass4set(:,10),  & 
G0tensor(216),G0tensor(217),G0tensor(218),G0tensor(219),G0tensor(220))
call Hotf_4pt_reduction_last(G1tensor(221),RedSet_4(28),mass4set(:,16),  & 
G0tensor(221),G0tensor(222),G0tensor(223),G0tensor(224),G0tensor(225))
call Hotf_4pt_reduction_last(G1tensor(226),RedSet_4(29),mass4set(:,16),  & 
G0tensor(226),G0tensor(227),G0tensor(228),G0tensor(229),G0tensor(230))
call Hotf_4pt_reduction_last(G1tensor(231),RedSet_4(32),mass4set(:,12),  & 
G0tensor(231),G0tensor(232),G0tensor(233),G0tensor(234),G0tensor(235))
call Hotf_4pt_reduction_last(G1tensor(236),RedSet_4(29),mass4set(:,12),  & 
G0tensor(236),G0tensor(237),G0tensor(238),G0tensor(239),G0tensor(240))
call Hotf_4pt_reduction_last(G1tensor(241),RedSet_4(32),mass4set(:,22),  & 
G0tensor(241),G0tensor(242),G0tensor(243),G0tensor(244),G0tensor(245))
call Hotf_4pt_reduction_last(G1tensor(246),RedSet_4(3),mass4set(:,16),  & 
G0tensor(246),G0tensor(247),G0tensor(248),G0tensor(249),G0tensor(250))
call Hotf_4pt_reduction_last(G1tensor(251),RedSet_4(4),mass4set(:,16),  & 
G0tensor(251),G0tensor(252),G0tensor(253),G0tensor(254),G0tensor(255))
call Hotf_4pt_reduction_last(G1tensor(256),RedSet_4(28),mass4set(:,12),  & 
G0tensor(256),G0tensor(257),G0tensor(258),G0tensor(259),G0tensor(260))
call Hotf_4pt_reduction_last(G1tensor(261),RedSet_4(25),mass4set(:,1),  & 
G0tensor(261),G0tensor(262),G0tensor(263),G0tensor(264),G0tensor(265))
call Hotf_4pt_reduction_last(G1tensor(266),RedSet_4(21),mass4set(:,2),  & 
G0tensor(266),G0tensor(267),G0tensor(268),G0tensor(269),G0tensor(270))
call Hotf_4pt_reduction_last(G1tensor(271),RedSet_4(20),mass4set(:,3),  & 
G0tensor(271),G0tensor(272),G0tensor(273),G0tensor(274),G0tensor(275))
call Hotf_4pt_reduction_last(G1tensor(276),RedSet_4(35),mass4set(:,3),  & 
G0tensor(276),G0tensor(277),G0tensor(278),G0tensor(279),G0tensor(280))
call ol_merge_tensors(T0sum(1),[G0tensor(1)])
call ol_merge_tensors(T0sum(2),[G0tensor(6)])
call ol_merge_tensors(T0sum(3),[G0tensor(11)])
call ol_merge_tensors(T0sum(4),[G0tensor(16)])
call ol_merge_tensors(T0sum(5),[G0tensor(21)])
call ol_merge_tensors(T0sum(6),[G0tensor(26)])
call ol_merge_tensors(T0sum(7),[G0tensor(31)])
call ol_merge_tensors(T0sum(8),[G0tensor(36)])
call ol_merge_tensors(T0sum(9),[G0tensor(41)])
call ol_merge_tensors(T0sum(10),[G0tensor(46)])
call ol_merge_tensors(T0sum(11),[G0tensor(51)])
call ol_merge_tensors(T0sum(12),[G0tensor(56)])
call ol_merge_tensors(T0sum(13),[G0tensor(61)])
call ol_merge_tensors(T0sum(14),[G0tensor(66)])
call ol_merge_tensors(T0sum(15),[G0tensor(71)])
call ol_merge_tensors(T0sum(16),[G0tensor(76)])
call ol_merge_tensors(T0sum(17),[G0tensor(81)])
call ol_merge_tensors(T0sum(18),[G0tensor(86)])
call ol_merge_tensors(T0sum(19),[G0tensor(91)])
call ol_merge_tensors(T0sum(20),[G0tensor(96)])
call ol_merge_tensors(T0sum(21),[G0tensor(101)])
call ol_merge_tensors(T0sum(22),[G0tensor(106)])
call ol_merge_tensors(T0sum(23),[G0tensor(111)])
call ol_merge_tensors(T0sum(24),[G0tensor(116)])
call ol_merge_tensors(T0sum(25),[G0tensor(121)])
call ol_merge_tensors(T0sum(26),[G0tensor(126)])
call ol_merge_tensors(T0sum(27),[G0tensor(131)])
call ol_merge_tensors(T0sum(28),[G0tensor(136)])
call ol_merge_tensors(T0sum(29),[G0tensor(141)])
call ol_merge_tensors(T0sum(30),[G0tensor(146)])
call ol_merge_tensors(T0sum(31),[G0tensor(151)])
call ol_merge_tensors(T0sum(32),[G0tensor(156)])
call ol_merge_tensors(T0sum(33),[G0tensor(161)])
call ol_merge_tensors(T0sum(34),[G0tensor(166)])
call ol_merge_tensors(T0sum(35),[G0tensor(171)])
call ol_merge_tensors(T0sum(36),[G0tensor(176)])
call ol_merge_tensors(T0sum(37),[G0tensor(181)])
call ol_merge_tensors(T0sum(38),[G0tensor(186)])
call ol_merge_tensors(T0sum(39),[G0tensor(191)])
call ol_merge_tensors(T0sum(40),[G0tensor(196)])
call ol_merge_tensors(T0sum(41),[G0tensor(201)])
call ol_merge_tensors(T0sum(42),[G0tensor(206)])
call ol_merge_tensors(T0sum(43),[G0tensor(211)])
call ol_merge_tensors(T0sum(44),[G0tensor(216)])
call ol_merge_tensors(T0sum(45),[G0tensor(221)])
call ol_merge_tensors(T0sum(46),[G0tensor(226)])
call ol_merge_tensors(T0sum(47),[G0tensor(231)])
call ol_merge_tensors(T0sum(48),[G0tensor(236)])
call ol_merge_tensors(T0sum(49),[G0tensor(241)])
call ol_merge_tensors(T0sum(50),[G0tensor(246)])
call ol_merge_tensors(T0sum(51),[G0tensor(251)])
call ol_merge_tensors(T0sum(52),[G0tensor(256)])
call ol_merge_tensors(T0sum(53),[G0tensor(261)])
call ol_merge_tensors(T0sum(54),[G0tensor(266)])
call ol_merge_tensors(T0sum(55),[G0tensor(271)])
call ol_merge_tensors(T0sum(56),[G0tensor(276)])
Gcoeff(:)%j = (c(8)*M(1,:)%j) * den(8)
call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(37),h0tab(:,37),[32,11,20],[0,nMT,nMB],3,2,wf8(:,3),wf4(:,2))
  call Hloop_QA_V(ntryL,G0H64(1),ex6(:),G0H32(2),m3h2x32(:,31),heltab2x64(:,:,37))
Gcoeff(:)%j = (c(8)*M(1,:)%j) * den(23)
call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(38),h0tab(:,38),[35,8,20],[0,nMT,nMB],3,2,wf8(:,23),wf4(:,2))
  call Hloop_QA_V(ntryL,G0H64(1),wf8(:,23),G0H8(1),m3h8x8(:,5),heltab2x64(:,:,38))
Gcoeff(:)%j = (c(8)*M(1,:)%j) * den(11)
call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(39),h0tab(:,39),[32,3,28],[nMB,nMB,0],3,2,wf4(:,1),wf8(:,6))
  call Hloop_VA_Q(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,32),heltab2x64(:,:,39))
  call Hloop_A_Q(ntryL,G0H32(1),32,nMB,G1H32(8),n2h32(16))
Gcoeff(:)%j = (c(8)*M(1,:)%j) * den(26)
call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(40),h0tab(:,40),[52,3,8],[nMT,nMT,0],3,2,wf8(:,25),wf4(:,1))
  call Hloop_VA_Q(ntryL,G0H64(1),wf8(:,25),G0H8(2),m3h8x8(:,6),heltab2x64(:,:,40))
  call Hloop_A_Q(ntryL,G0H8(2),52,nMT,G1H8(3),n2h8(15))
Gcoeff(:)%j = (c(11)*M(1,:)%j) * den(38)
call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(41),h0tab(:,41),[32,8,23],[0,nMT,nMB],3,1,wf16(:,1))
  call Hloop_QA_V(ntryL,G0H64(1),ex6(:),G0H32(3),m3h2x32(:,33),heltab2x64(:,:,41))
Gcoeff(:)%j = (c(5)*M(1,:)%j) * den(38)
call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(42),h0tab(:,42),[32,8,23],[0,nMT,nMB],3,1,wf16(:,2))
  call Hloop_QA_V(ntryL,G0H64(1),ex6(:),G0H32(4),m3h2x32(:,34),heltab2x64(:,:,42))
Gcoeff(:)%j = (c(8)*M(1,:)%j) * den(14)
call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(43),h0tab(:,43),[40,7,16],[0,0,0],3,2,wf4(:,4),wf8(:,9))
  call Hloop_QW_A(ntryL,G0H64(1),wf4(:,4),G0H16(1),m3h4x16(:,3),heltab2x64(:,:,43))
  call Hloop_Q_A(ntryL,G0H16(1),40,0,G1H16(3),n2h16(12))
Gcoeff(:)%j = (c(8)*M(1,:)%j) * den(29)
call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(44),h0tab(:,44),[40,4,19],[0,0,0],3,2,wf4(:,4),wf8(:,30))
  call Hloop_QW_A(ntryL,G0H64(1),wf4(:,4),G0H16(1),m3h4x16(:,4),heltab2x64(:,:,44))
  call Hloop_Q_A(ntryL,G0H16(1),40,0,G1H16(4),n2h16(13))
Gcoeff(:)%j = (c(8)*M(1,:)%j) * den(17)
call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(45),h0tab(:,45),[44,3,16],[0,0,0],3,2,wf8(:,12),wf4(:,1))
  call Hloop_VA_Q(ntryL,G0H64(1),wf8(:,12),G0H8(2),m3h8x8(:,7),heltab2x64(:,:,45))
  call Hloop_A_Q(ntryL,G0H8(2),44,0,G1H8(5),n2h8(16))
Gcoeff(:)%j = (c(8)*M(1,:)%j) * den(32)
call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(46),h0tab(:,46),[56,3,4],[0,0,0],3,2,wf8(:,33),wf4(:,1))
  call Hloop_VQ_A(ntryL,G0H64(1),wf8(:,33),G0H8(2),m3h8x8(:,8),heltab2x64(:,:,46))
  call Hloop_Q_A(ntryL,G0H8(2),56,0,G1H8(6),n2h8(17))
Gcoeff(:)%j = (c(11)*M(1,:)%j) * den(41)
call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(47),h0tab(:,47),[43,4,16],[0,0,0],3,1,wf16(:,7))
  call Hloop_QW_A(ntryL,G0H64(1),wf16(:,7),G0H4(1),m3h16x4(:,1),heltab2x64(:,:,47))
  call Hloop_Q_A(ntryL,G0H4(1),43,0,G1H4(30),n2h4(17))
Gcoeff(:)%j = (c(5)*M(1,:)%j) * den(41)
call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(48),h0tab(:,48),[43,4,16],[0,0,0],3,1,wf16(:,8))
  call Hloop_QW_A(ntryL,G0H64(1),wf16(:,8),G0H4(1),m3h16x4(:,2),heltab2x64(:,:,48))
  call Hloop_Q_A(ntryL,G0H4(1),43,0,G1H4(5),n2h4(18))
Gcoeff(:)%j = (c(8)*M(1,:)%j) * den(42)
call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(49),h0tab(:,49),[32,8,23],[0,nMT,nMB],3,1,wf16(:,9))
  call Hloop_QA_V(ntryL,G0H64(1),ex6(:),G0H32(7),m3h2x32(:,35),heltab2x64(:,:,49))
Gcoeff(:)%j = (c(8)*M(1,:)%j) * den(43)
call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(50),h0tab(:,50),[43,4,16],[0,0,0],3,1,wf16(:,10))
  call Hloop_QW_A(ntryL,G0H64(1),wf16(:,10),G0H4(1),m3h16x4(:,3),heltab2x64(:,:,50))
  call Hloop_Q_A(ntryL,G0H4(1),43,0,G1H4(6),n2h4(19))
Gcoeff(:)%j = (c(8)*M(1,:)%j) * den(44)
call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(51),h0tab(:,51),[32,8,23],[0,nMT,nMB],3,1,wf16(:,11))
  call Hloop_QA_V(ntryL,G0H64(1),ex6(:),G0H32(8),m3h2x32(:,36),heltab2x64(:,:,51))
Gcoeff(:)%j = (c(8)*M(1,:)%j) * den(45)
call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(52),h0tab(:,52),[43,4,16],[0,0,0],3,1,wf16(:,12))
  call Hloop_QW_A(ntryL,G0H64(1),wf16(:,12),G0H4(1),m3h16x4(:,4),heltab2x64(:,:,52))
  call Hloop_Q_A(ntryL,G0H4(1),43,0,G1H4(3),n2h4(20))
Gcoeff(:)%j = (-(c(2)*M(1,:)%j)) * den(46)
call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(53),h0tab(:,53),[32,8,23],[0,nMT,nMB],3,1,wf16(:,13))
  call Hloop_QA_V(ntryL,G0H64(1),ex6(:),G0H32(5),m3h2x32(:,37),heltab2x64(:,:,53))
Gcoeff(:)%j = (c(1)*M(1,:)%j) * den(46)
call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(54),h0tab(:,54),[32,8,23],[0,nMT,nMB],3,1,wf16(:,14))
  call Hloop_QA_V(ntryL,G0H64(1),ex6(:),G0H32(6),m3h2x32(:,38),heltab2x64(:,:,54))
Gcoeff(:)%j = (-(c(2)*M(1,:)%j)) * den(49)
call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(55),h0tab(:,55),[43,4,16],[0,0,0],3,1,wf16(:,15))
  call Hloop_QW_A(ntryL,G0H64(1),wf16(:,15),G0H4(1),m3h16x4(:,5),heltab2x64(:,:,55))
  call Hloop_Q_A(ntryL,G0H4(1),43,0,G1H4(4),n2h4(21))
Gcoeff(:)%j = (c(1)*M(1,:)%j) * den(49)
call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(56),h0tab(:,56),[43,4,16],[0,0,0],3,1,wf16(:,16))
  call Hloop_QW_A(ntryL,G0H64(1),wf16(:,16),G0H4(1),m3h16x4(:,6),heltab2x64(:,:,56))
  call Hloop_Q_A(ntryL,G0H4(1),43,0,G1H4(9),n2h4(22))
  call ol_merge(ntryL,G1H4(9),[G1H4(4),G1H4(3),G1H4(6),G1H4(5),G1H4(30)])
  call Hloop_AW_Q(ntryL,G1H8(8),wf4(:,2),G1H2(28),m3h4x2(:,16),heltab2x8(:,:,33))
  call Hloop_A_Q(ntryL,G1H2(28),55,nMT,G2H2(13),n2h2(40))
  call Hloop_VQ_A(ntryL,G0H32(2),wf8(:,3),G0H4(1),m3h8x4(:,5),heltab2x32(:,:,31))
  call Hloop_Q_A(ntryL,G0H4(1),43,nMT,G1H4(28),n2h4(23))
  call Hloop_VQ_A(ntryL,G0H8(1),ex4(:),G0H4(1),m3h2x4(:,14),heltab2x8(:,:,34))
  call Hloop_Q_A(ntryL,G0H4(1),43,nMT,G1H4(10),n2h4(24))
  call Hloop_AZ_Q(ntryL,G1H32(8),wf4(:,1),G1H8(11),ngZd,m3h4x8(:,10),heltab2x32(:,:,32))
  call Hloop_A_Q(ntryL,G1H8(11),35,nMB,G2H8(2),n2h8(18))
  call Hloop_AZ_Q(ntryL,G1H8(3),wf4(:,1),G1H2(16),ngZu,m3h4x2(:,17),heltab2x8(:,:,35))
  call Hloop_A_Q(ntryL,G1H2(16),55,nMT,G2H2(25),n2h2(41))
  call Hloop_VQ_A(ntryL,G0H32(3),ex4(:),G0H16(1),m3h2x16(:,18),heltab2x32(:,:,33))
  call Hloop_Q_A(ntryL,G0H16(1),40,nMT,G1H16(5),n2h16(14))
  call Hloop_VQ_A(ntryL,G0H32(4),ex4(:),G0H16(1),m3h2x16(:,19),heltab2x32(:,:,34))
  call Hloop_Q_A(ntryL,G0H16(1),40,nMT,G1H16(6),n2h16(15))
  call Hloop_QA_V(ntryL,G1H16(3),wf8(:,9),G1H2(20),m3h8x2(:,5),heltab2x16(:,:,20))
  call Hloop_QA_V(ntryL,G1H16(4),ex3(:),G1H8(12),m3h2x8(:,9),heltab2x16(:,:,21))
  call Hloop_AZ_Q(ntryL,G1H8(5),wf4(:,1),G1H2(33),ngZd,m3h4x2(:,18),heltab2x8(:,:,36))
  call Hloop_A_Q(ntryL,G1H2(33),47,0,G2H2(16),n2h2(42))
  call Hloop_QZ_A(ntryL,G1H8(6),wf4(:,1),G1H2(21),ngZu,m3h4x2(:,19),heltab2x8(:,:,37))
  call Hloop_Q_A(ntryL,G1H2(21),59,0,G2H2(7),n2h2(43))
  call Hloop_QA_V(ntryL,G1H4(9),ex3(:),G1H2(27),m3h2x2(:,40),heltab2x4(:,:,45))
  call Hloop_VQ_A(ntryL,G0H32(7),ex4(:),G0H16(1),m3h2x16(:,20),heltab2x32(:,:,35))
  call Hloop_Q_A(ntryL,G0H16(1),40,nMT,G1H16(7),n2h16(16))
  call Hloop_VQ_A(ntryL,G0H32(8),ex4(:),G0H16(1),m3h2x16(:,21),heltab2x32(:,:,36))
  call Hloop_Q_A(ntryL,G0H16(1),40,nMT,G1H16(8),n2h16(17))
  call Hloop_VQ_A(ntryL,G0H32(5),ex4(:),G0H16(1),m3h2x16(:,22),heltab2x32(:,:,37))
  call Hloop_Q_A(ntryL,G0H16(1),40,nMT,G1H16(1),n2h16(18))
  call Hloop_VQ_A(ntryL,G0H32(6),ex4(:),G0H16(1),m3h2x16(:,23),heltab2x32(:,:,38))
  call Hloop_Q_A(ntryL,G0H16(1),40,nMT,G1H16(2),n2h16(19))
  call ol_merge(ntryL,G1H4(28),[G1H4(26)])
  call ol_merge(ntryL,G1H2(27),[G1H2(29)])
  call ol_merge(ntryL,G1H2(20),[G1H2(30)])
call HGT_w2_OLR(G1H4(20),1,1,4)
call HGT_w2_invQ_OLR(G1H4(20),2,5,4)
  call Hloop_AW_Q(ntryL,G1H4(20),wf4(:,2),G1H1(1),m3h4x1(:,6),heltab2x4(:,:,46))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,nMT,G2tensor(3),n2h1(48))
  call Hcheck_last_AQ_V(ntryL,l_switch,G2H2(26),ex4(:),G2tensor(5),m3h2x1(:,76),heltab2x2(:,:,76))
  call Hloop_QW_A(ntryL,G1H4(25),wf4(:,2),G1H1(1),m3h4x1(:,7),heltab2x4(:,:,47))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,nMB,G2tensor(7),n2h1(49))
  call Hloop_QW_A(ntryL,G1H4(28),wf4(:,2),G1H1(1),m3h4x1(:,8),heltab2x4(:,:,48))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,nMB,G2tensor(9),n2h1(50))
  call Hloop_VQ_A(ntryL,G1H2(27),ex5(:),G1H1(1),m3h2x1(:,77),heltab2x2(:,:,77))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(21),n2h1(51))
  call Hloop_VQ_A(ntryL,G1H2(20),ex5(:),G1H1(1),m3h2x1(:,78),heltab2x2(:,:,78))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(23),n2h1(52))
  call Hloop_VA_Q(ntryL,G1H2(19),ex3(:),G1H1(1),m3h2x1(:,79),heltab2x2(:,:,79))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,0,G2tensor(26),n2h1(53))
  call Hloop_VA_Q(ntryL,G1H2(23),ex3(:),G1H1(1),m3h2x1(:,80),heltab2x2(:,:,80))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,0,G2tensor(29),n2h1(54))
  call Hcheck_last_AQ_V(ntryL,l_switch,G2H2(13),ex4(:),G2tensor(11),m3h2x1(:,81),heltab2x2(:,:,81))
  call Hloop_QW_A(ntryL,G1H4(10),wf4(:,2),G1H1(1),m3h4x1(:,9),heltab2x4(:,:,49))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,nMB,G2tensor(13),n2h1(55))
  call Hcheck_last_AQ_V(ntryL,l_switch,G2H8(2),wf8(:,6),G2tensor(58),m3h8x1(:,5),heltab2x8(:,:,38))
  call Hcheck_last_AQ_V(ntryL,l_switch,G2H2(25),ex4(:),G2tensor(59),m3h2x1(:,82),heltab2x2(:,:,82))
  call Hloop_QS_A(ntryL,G1H16(5),wf16(:,1),G1H1(1),ngPbt,m3h16x1(:,1),heltab2x16(:,:,22))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,nMB,G2tensor(15),n2h1(56))
  call Hloop_QW_A(ntryL,G1H16(6),wf16(:,2),G1H1(1),m3h16x1(:,2),heltab2x16(:,:,23))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,nMB,G2tensor(17),n2h1(57))
  call Hloop_VQ_A(ntryL,G1H8(12),wf8(:,30),G1H1(1),m3h8x1(:,6),heltab2x8(:,:,39))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(18),n2h1(58))
  call Hcheck_last_AQ_V(ntryL,l_switch,G2H2(16),ex5(:),G2tensor(20),m3h2x1(:,83),heltab2x2(:,:,83))
  call Hcheck_last_QA_V(ntryL,l_switch,G2H2(7),ex3(:),G2tensor(56),m3h2x1(:,84),heltab2x2(:,:,84))
  call Hloop_QW_A(ntryL,G1H16(7),wf16(:,9),G1H1(1),m3h16x1(:,3),heltab2x16(:,:,24))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,nMB,G2tensor(55),n2h1(59))
  call Hloop_QW_A(ntryL,G1H16(8),wf16(:,11),G1H1(1),m3h16x1(:,4),heltab2x16(:,:,25))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,nMB,G2tensor(24),n2h1(60))
  call Hloop_QS_A(ntryL,G1H16(1),wf16(:,13),G1H1(1),ngPbt,m3h16x1(:,5),heltab2x16(:,:,26))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,nMB,G2tensor(47),n2h1(61))
  call Hloop_QW_A(ntryL,G1H16(2),wf16(:,14),G1H1(1),m3h16x1(:,6),heltab2x16(:,:,27))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,nMB,G2tensor(27),n2h1(62))
  call ol_merge_tensors(G2tensor(58),[G2tensor(62),G1tensor(265),G1tensor(200),G1tensor(130),G1tensor(55),G0tensor(265) &
    ,G0tensor(200),G0tensor(130),G0tensor(10)])
  call ol_merge_tensors(G2tensor(64),[G1tensor(267),G0tensor(267)])
  call ol_merge_tensors(G2tensor(27),[G2tensor(47),G2tensor(24),G2tensor(55),G2tensor(17),G2tensor(15),G2tensor(65),G1tensor(270) &
    ,G0tensor(270)])
  call ol_merge_tensors(G2tensor(56),[G2tensor(67),G1tensor(272),G0tensor(272)])
  call ol_merge_tensors(G2tensor(71),[G2tensor(68),G1tensor(280),G1tensor(275),G0tensor(280),G0tensor(275)])
  call ol_merge_tensors(G2tensor(20),[G2tensor(70),G1tensor(277),G1tensor(242),G1tensor(153),G1tensor(58),G0tensor(277) &
    ,G0tensor(242),G0tensor(153),G0tensor(68)])
  call ol_merge_tensors(G2tensor(59),[G1tensor(162),G1tensor(92),G1tensor(7),G0tensor(162),G0tensor(92),G0tensor(2)])
  call ol_merge_tensors(G1tensor(170),[G1tensor(100),G1tensor(13),G0tensor(170),G0tensor(100),G0tensor(3)])
  call ol_merge_tensors(G1tensor(175),[G1tensor(105),G1tensor(19),G0tensor(175),G0tensor(105),G0tensor(4)])
  call ol_merge_tensors(G1tensor(180),[G1tensor(110),G1tensor(25),G0tensor(180),G0tensor(110),G0tensor(5)])
  call ol_merge_tensors(G1tensor(182),[G1tensor(112),G1tensor(37),G0tensor(182),G0tensor(112),G0tensor(7)])
  call ol_merge_tensors(G1tensor(190),[G1tensor(120),G1tensor(43),G0tensor(190),G0tensor(120),G0tensor(8)])
  call ol_merge_tensors(G1tensor(195),[G1tensor(125),G1tensor(56),G1tensor(49),G0tensor(195),G0tensor(125),G0tensor(24) &
    ,G0tensor(9)])
  call ol_merge_tensors(G1tensor(132),[G1tensor(97),G1tensor(93),G1tensor(67),G0tensor(132),G0tensor(97),G0tensor(93) &
    ,G0tensor(12)])
  call ol_merge_tensors(G1tensor(87),[G1tensor(41),G1tensor(11),G1tensor(36),G0tensor(87),G0tensor(60),G0tensor(40) &
    ,G0tensor(13)])
  call ol_merge_tensors(G1tensor(140),[G1tensor(12),G0tensor(140),G0tensor(14)])
  call ol_merge_tensors(G1tensor(145),[G1tensor(42),G0tensor(145),G0tensor(15)])
  call ol_merge_tensors(G1tensor(147),[G1tensor(117),G1tensor(113),G1tensor(24),G0tensor(147),G0tensor(117),G0tensor(113) &
    ,G0tensor(17)])
  call ol_merge_tensors(G1tensor(247),[G1tensor(64),G1tensor(30),G0tensor(247),G0tensor(70),G0tensor(18)])
  call ol_merge_tensors(G1tensor(155),[G1tensor(48),G0tensor(155),G0tensor(19)])
  call ol_merge_tensors(G1tensor(160),[G1tensor(45),G1tensor(50),G0tensor(160),G0tensor(25),G0tensor(20)])
  call ol_merge_tensors(G1tensor(202),[G1tensor(2),G0tensor(202),G0tensor(22)])
  call ol_merge_tensors(G1tensor(217),[G1tensor(28),G1tensor(68),G1tensor(6),G0tensor(217),G0tensor(50),G0tensor(30) &
    ,G0tensor(23)])
  call ol_merge_tensors(G1tensor(72),[G1tensor(62),G0tensor(32),G0tensor(27)])
  call ol_merge_tensors(G1tensor(207),[G1tensor(193),G1tensor(188),G1tensor(21),G0tensor(207),G0tensor(193),G0tensor(188) &
    ,G0tensor(28)])
  call ol_merge_tensors(G1tensor(212),[G1tensor(66),G0tensor(212),G0tensor(29)])
  call ol_merge_tensors(G1tensor(210),[G1tensor(3),G0tensor(210),G0tensor(33)])
  call ol_merge_tensors(G1tensor(215),[G1tensor(4),G0tensor(215),G0tensor(34)])
  call ol_merge_tensors(G1tensor(220),[G1tensor(34),G1tensor(65),G0tensor(220),G0tensor(55),G0tensor(35)])
  call ol_merge_tensors(G1tensor(257),[G1tensor(103),G1tensor(98),G1tensor(15),G1tensor(8),G0tensor(257),G0tensor(103) &
    ,G0tensor(98),G0tensor(42),G0tensor(37)])
  call ol_merge_tensors(G1tensor(77),[G1tensor(9),G0tensor(77),G0tensor(38)])
  call ol_merge_tensors(G1tensor(82),[G1tensor(10),G0tensor(82),G0tensor(39)])
  call ol_merge_tensors(G1tensor(80),[G1tensor(46),G0tensor(80),G0tensor(43)])
  call ol_merge_tensors(G1tensor(85),[G1tensor(16),G0tensor(85),G0tensor(44)])
  call ol_merge_tensors(G1tensor(90),[G1tensor(53),G1tensor(17),G0tensor(90),G0tensor(65),G0tensor(45)])
  call ol_merge_tensors(G1tensor(203),[G1tensor(29),G1tensor(22),G0tensor(203),G0tensor(52),G0tensor(47)])
  call ol_merge_tensors(G1tensor(252),[G1tensor(222),G1tensor(123),G1tensor(118),G1tensor(23),G0tensor(252),G0tensor(222) &
    ,G0tensor(123),G0tensor(118),G0tensor(48)])
  call ol_merge_tensors(G1tensor(227),[G1tensor(158),G1tensor(63),G1tensor(26),G0tensor(227),G0tensor(158),G0tensor(69) &
    ,G0tensor(49)])
  call ol_merge_tensors(G1tensor(225),[G1tensor(32),G0tensor(225),G0tensor(53)])
  call ol_merge_tensors(G1tensor(230),[G1tensor(74),G1tensor(33),G0tensor(230),G0tensor(74),G0tensor(54)])
  call ol_merge_tensors(G1tensor(133),[G1tensor(51),G1tensor(38),G0tensor(133),G0tensor(62),G0tensor(57)])
  call ol_merge_tensors(G1tensor(232),[G1tensor(138),G1tensor(39),G0tensor(232),G0tensor(138),G0tensor(58)])
  call ol_merge_tensors(G1tensor(237),[G1tensor(143),G1tensor(40),G0tensor(237),G0tensor(143),G0tensor(59)])
  call ol_merge_tensors(G1tensor(235),[G1tensor(52),G0tensor(235),G0tensor(63)])
  call ol_merge_tensors(G1tensor(240),[G1tensor(59),G0tensor(240),G0tensor(64)])
  call ol_merge_tensors(G1tensor(148),[G1tensor(71),G1tensor(70),G0tensor(148),G0tensor(72),G0tensor(67)])
  call ol_merge_tensors(G1tensor(245),[G1tensor(73),G0tensor(245),G0tensor(73)])
  call ol_merge_tensors(G1tensor(255),[G1tensor(250),G1tensor(75),G0tensor(255),G0tensor(250),G0tensor(75)])
  call ol_merge_tensors(G1tensor(83),[G1tensor(78),G0tensor(83),G0tensor(78)])
  call ol_merge_tensors(G1tensor(234),[G1tensor(88),G1tensor(79),G0tensor(234),G0tensor(88),G0tensor(79)])
  call ol_merge_tensors(G1tensor(239),[G1tensor(89),G1tensor(84),G0tensor(239),G0tensor(89),G0tensor(84)])
  call ol_merge_tensors(G1tensor(102),[G1tensor(94),G0tensor(102),G0tensor(94)])
  call ol_merge_tensors(G1tensor(107),[G1tensor(95),G0tensor(107),G0tensor(95)])
  call ol_merge_tensors(G1tensor(108),[G1tensor(99),G0tensor(108),G0tensor(99)])
  call ol_merge_tensors(G1tensor(144),[G1tensor(139),G1tensor(109),G1tensor(104),G0tensor(144),G0tensor(139),G0tensor(109) &
    ,G0tensor(104)])
  call ol_merge_tensors(G1tensor(204),[G1tensor(122),G1tensor(114),G0tensor(204),G0tensor(122),G0tensor(114)])
  call ol_merge_tensors(G1tensor(127),[G1tensor(115),G0tensor(127),G0tensor(115)])
  call ol_merge_tensors(G1tensor(128),[G1tensor(119),G0tensor(128),G0tensor(119)])
  call ol_merge_tensors(G1tensor(159),[G1tensor(154),G1tensor(129),G1tensor(124),G0tensor(159),G0tensor(154),G0tensor(129) &
    ,G0tensor(124)])
  call ol_merge_tensors(G1tensor(137),[G1tensor(134),G0tensor(137),G0tensor(134)])
  call ol_merge_tensors(G1tensor(142),[G1tensor(135),G0tensor(142),G0tensor(135)])
  call ol_merge_tensors(G1tensor(152),[G1tensor(149),G0tensor(152),G0tensor(149)])
  call ol_merge_tensors(G1tensor(205),[G1tensor(157),G1tensor(150),G0tensor(205),G0tensor(157),G0tensor(150)])
  call ol_merge_tensors(G1tensor(167),[G1tensor(163),G0tensor(167),G0tensor(163)])
  call ol_merge_tensors(G1tensor(172),[G1tensor(164),G0tensor(172),G0tensor(164)])
  call ol_merge_tensors(G1tensor(177),[G1tensor(165),G0tensor(177),G0tensor(165)])
  call ol_merge_tensors(G1tensor(173),[G1tensor(168),G0tensor(173),G0tensor(168)])
  call ol_merge_tensors(G1tensor(178),[G1tensor(169),G0tensor(178),G0tensor(169)])
  call ol_merge_tensors(G1tensor(179),[G1tensor(174),G0tensor(179),G0tensor(174)])
  call ol_merge_tensors(G1tensor(187),[G1tensor(183),G0tensor(187),G0tensor(183)])
  call ol_merge_tensors(G1tensor(192),[G1tensor(184),G0tensor(192),G0tensor(184)])
  call ol_merge_tensors(G1tensor(197),[G1tensor(185),G0tensor(197),G0tensor(185)])
  call ol_merge_tensors(G1tensor(198),[G1tensor(189),G0tensor(198),G0tensor(189)])
  call ol_merge_tensors(G1tensor(199),[G1tensor(194),G0tensor(199),G0tensor(194)])
  call ol_merge_tensors(G1tensor(213),[G1tensor(208),G0tensor(213),G0tensor(208)])
  call ol_merge_tensors(G1tensor(224),[G1tensor(218),G1tensor(209),G0tensor(224),G0tensor(218),G0tensor(209)])
  call ol_merge_tensors(G1tensor(249),[G1tensor(229),G1tensor(219),G1tensor(214),G0tensor(249),G0tensor(229),G0tensor(219) &
    ,G0tensor(214)])
  call ol_merge_tensors(G1tensor(243),[G1tensor(228),G1tensor(223),G0tensor(243),G0tensor(228),G0tensor(223)])
  call ol_merge_tensors(G1tensor(258),[G1tensor(238),G1tensor(233),G0tensor(258),G0tensor(238),G0tensor(233)])
  call ol_merge_tensors(G1tensor(248),[G1tensor(244),G0tensor(248),G0tensor(244)])
  call ol_merge_tensors(G1tensor(253),[G0tensor(253)])
  call ol_merge_tensors(G1tensor(254),[G0tensor(254)])
  call ol_merge_tensors(G1tensor(259),[G0tensor(259)])
  call ol_merge_tensors(G1tensor(260),[G0tensor(260)])
  call ol_merge_tensors(G2tensor(3),[G1tensor(262),G0tensor(262)])
  call ol_merge_tensors(G2tensor(11),[G1tensor(263),G0tensor(263)])
  call ol_merge_tensors(G2tensor(5),[G1tensor(264),G0tensor(264)])
  call ol_merge_tensors(G2tensor(7),[G1tensor(268),G0tensor(268)])
  call ol_merge_tensors(G2tensor(9),[G1tensor(269),G0tensor(269)])
  call ol_merge_tensors(G2tensor(21),[G1tensor(273),G0tensor(273)])
  call ol_merge_tensors(G2tensor(23),[G1tensor(274),G0tensor(274)])
  call ol_merge_tensors(G2tensor(26),[G1tensor(278),G0tensor(278)])
  call ol_merge_tensors(G2tensor(29),[G1tensor(279),G0tensor(279)])
call TI_triangle_red(G2tensor(58),RedBasis(1),mass3set(:,1),G0tensor(1),G0tensor(6),G0tensor(11),G0tensor(16),M2L1R1,[nMB], &
    G0tensor(21))
call TI_triangle_red(G2tensor(64),RedBasis(60),mass3set(:,2),G0tensor(26),G0tensor(31),G0tensor(36),G0tensor(41),M2L1R1,[nMT], &
    G0tensor(46))
call TI_triangle_red(G2tensor(27),RedBasis(7),mass3set(:,3),G0tensor(51),G0tensor(56),G0tensor(61),G0tensor(66),M2L1R1,[nMB,nMT], &
    G0tensor(71),G0tensor(76))
call TI_triangle_red(G2tensor(56),RedBasis(59),mass3set(:,4),G0tensor(81),G0tensor(86),G0tensor(91),G0tensor(96),M2L1R1)
call TI_triangle_red(G2tensor(71),RedBasis(15),mass3set(:,4),G0tensor(101),G0tensor(106),G0tensor(111),G0tensor(116),M2L1R1)
call TI_triangle_red(G2tensor(20),RedBasis(11),mass3set(:,4),G0tensor(121),G0tensor(126),G0tensor(131),G0tensor(136),M2L1R1)
call TI_triangle_red(G2tensor(59),RedBasis(25),mass3set(:,5),G0tensor(141),G0tensor(146),G0tensor(151),G0tensor(156),M2L1R1,[nMT], &
    G0tensor(161))
call TI_triangle_red(G2tensor(3),RedBasis(15),mass3set(:,6),G0tensor(166),G0tensor(171),G0tensor(176), &
    G0tensor(181),M2L1R1,[nMT,nMB],G0tensor(186),G0tensor(191))
call TI_triangle_red(G2tensor(11),RedBasis(19),mass3set(:,7),G0tensor(196),G0tensor(201),G0tensor(206), &
    G0tensor(211),M2L1R1,[nMB,nMT],G0tensor(216),G0tensor(221))
call TI_triangle_red(G2tensor(5),RedBasis(17),mass3set(:,7),G0tensor(226),G0tensor(231),G0tensor(236), &
    G0tensor(241),M2L1R1,[nMB,nMT],G0tensor(246),G0tensor(251))
call TI_triangle_red(G2tensor(7),RedBasis(15),mass3set(:,8),G0tensor(256),G0tensor(261),G0tensor(266), &
    G0tensor(271),M2L1R1,[nMB,nMT],G0tensor(276),G0tensor(265))
call TI_triangle_red(G2tensor(9),RedBasis(2),mass3set(:,3),G0tensor(200),G0tensor(130),G0tensor(10), &
    G0tensor(267),M2L1R1,[nMB,nMT],G0tensor(270),G0tensor(272))
call TI_triangle_red(G2tensor(21),RedBasis(6),mass3set(:,4),G0tensor(280),G0tensor(275),G0tensor(277),G0tensor(242),M2L1R1)
call TI_triangle_red(G2tensor(23),RedBasis(10),mass3set(:,4),G0tensor(153),G0tensor(68),G0tensor(162),G0tensor(92),M2L1R1)
call TI_triangle_red(G2tensor(26),RedBasis(14),mass3set(:,4),G0tensor(2),G0tensor(170),G0tensor(100),G0tensor(3),M2L1R1)
call TI_triangle_red(G2tensor(29),RedBasis(48),mass3set(:,4),G0tensor(175),G0tensor(105),G0tensor(4),G0tensor(180),M2L1R1)
call TI_triangle_red(G2tensor(13),RedBasis(4),mass3set(:,3),G0tensor(110),G0tensor(5),G0tensor(182), &
    G0tensor(112),M2L1R1,[nMB,nMT],G0tensor(7),G0tensor(190))
call TI_triangle_red(G2tensor(18),RedBasis(9),mass3set(:,4),G0tensor(120),G0tensor(8),G0tensor(195),G0tensor(125),M2L1R1)
call TI_triangle_red(G1tensor(170),RedBasis(4),mass3set(:,9),G0tensor(24),G0tensor(9),G0tensor(132),G0tensor(97),M2L1R1,[nMW,nMT], &
    G0tensor(93),G0tensor(12))
call TI_triangle_red(G1tensor(175),RedBasis(2),mass3set(:,9),G0tensor(87),G0tensor(60),G0tensor(40),G0tensor(13),M2L1R1,[nMW,nMT], &
    G0tensor(140),G0tensor(14))
call TI_triangle_red(G1tensor(180),RedBasis(1),mass3set(:,10),G0tensor(145),G0tensor(15),G0tensor(147), &
    G0tensor(117),M2L1R1,[nMW,nMT],G0tensor(113),G0tensor(17))
call TI_triangle_red(G1tensor(182),RedBasis(25),mass3set(:,11),G0tensor(247),G0tensor(70),G0tensor(18), &
    G0tensor(155),M2L1R1,[nMW,nMB],G0tensor(19),G0tensor(160))
call TI_triangle_red(G1tensor(190),RedBasis(4),mass3set(:,12),G0tensor(25),G0tensor(20),G0tensor(202), &
    G0tensor(22),M2L1R1,[nMB,nMW],G0tensor(217),G0tensor(50))
call TI_triangle_red(G1tensor(195),RedBasis(2),mass3set(:,12),G0tensor(30),G0tensor(23),G0tensor(32), &
    G0tensor(27),M2L1R1,[nMB,nMW],G0tensor(207),G0tensor(193))
call TI_triangle_red(G1tensor(132),RedBasis(53),mass3set(:,13),G0tensor(188),G0tensor(28),G0tensor(212),G0tensor(29),M2L1R1,[nMT], &
    G0tensor(210))
call TI_triangle_red(G1tensor(87),RedBasis(9),mass3set(:,14),G0tensor(33),G0tensor(215),G0tensor(34),G0tensor(220),M2L1R1,[nMW], &
    G0tensor(55))
call TI_triangle_red(G1tensor(140),RedBasis(8),mass3set(:,9),G0tensor(35),G0tensor(257),G0tensor(103), &
    G0tensor(98),M2L1R1,[nMW,nMT],G0tensor(42),G0tensor(37))
call TI_triangle_red(G1tensor(145),RedBasis(7),mass3set(:,9),G0tensor(77),G0tensor(38),G0tensor(82),G0tensor(39),M2L1R1,[nMW,nMT], &
    G0tensor(80),G0tensor(43))
call TI_triangle_red(G1tensor(147),RedBasis(53),mass3set(:,12),G0tensor(85),G0tensor(44),G0tensor(90), &
    G0tensor(65),M2L1R1,[nMB,nMW],G0tensor(45),G0tensor(203))
call TI_triangle_red(G1tensor(247),RedBasis(9),mass3set(:,15),G0tensor(52),G0tensor(47),G0tensor(252),G0tensor(222),M2L1R1,[nMW], &
    G0tensor(123))
call TI_triangle_red(G1tensor(155),RedBasis(8),mass3set(:,16),G0tensor(118),G0tensor(48),G0tensor(227),G0tensor(158),M2L1R1,[nMB], &
    G0tensor(69))
call TI_triangle_red(G1tensor(160),RedBasis(7),mass3set(:,12),G0tensor(49),G0tensor(225),G0tensor(53), &
    G0tensor(230),M2L1R1,[nMB,nMW],G0tensor(74),G0tensor(54))
call TI_triangle_red(G1tensor(202),RedBasis(60),mass3set(:,17),G0tensor(133),G0tensor(62),G0tensor(57), &
    G0tensor(232),M2L1R1,[nMW,nMB],G0tensor(138),G0tensor(58))
call TI_triangle_red(G1tensor(217),RedBasis(15),mass3set(:,18),G0tensor(237),G0tensor(143),G0tensor(59), &
    G0tensor(235),M2L1R1,[nMW],G0tensor(63))
call TI_triangle_red(G1tensor(72),RedBasis(11),mass3set(:,18),G0tensor(240),G0tensor(64),G0tensor(148),G0tensor(72),M2L1R1,[nMW], &
    G0tensor(67))
call TI_triangle_red(G1tensor(207),RedBasis(14),mass3set(:,15),G0tensor(245),G0tensor(73),G0tensor(255), &
    G0tensor(250),M2L1R1,[nMW],G0tensor(75))
call TI_triangle_red(G1tensor(212),RedBasis(48),mass3set(:,15),G0tensor(83),G0tensor(78),G0tensor(234),G0tensor(88),M2L1R1,[nMW], &
    G0tensor(79))
call TI_triangle_red(G1tensor(210),RedBasis(18),mass3set(:,19),G0tensor(239),G0tensor(89),G0tensor(84), &
    G0tensor(102),M2L1R1,[nMT,nMW],G0tensor(94),G0tensor(107))
call TI_triangle_red(G1tensor(215),RedBasis(16),mass3set(:,19),G0tensor(95),G0tensor(108),G0tensor(99), &
    G0tensor(144),M2L1R1,[nMT,nMW],G0tensor(139),G0tensor(109))
call TI_triangle_red(G1tensor(220),RedBasis(1),mass3set(:,20),G0tensor(104),G0tensor(204),G0tensor(122), &
    G0tensor(114),M2L1R1,[nMT,nMW],G0tensor(127),G0tensor(115))
call TI_triangle_red(G1tensor(257),RedBasis(6),mass3set(:,14),G0tensor(128),G0tensor(119),G0tensor(159), &
    G0tensor(154),M2L1R1,[nMW],G0tensor(129))
call TI_triangle_red(G1tensor(77),RedBasis(50),mass3set(:,21),G0tensor(124),G0tensor(137),G0tensor(134), &
    G0tensor(142),M2L1R1,[nMW],G0tensor(135))
call TI_triangle_red(G1tensor(82),RedBasis(49),mass3set(:,21),G0tensor(152),G0tensor(149),G0tensor(205), &
    G0tensor(157),M2L1R1,[nMW],G0tensor(150))
call TI_triangle_red(G1tensor(80),RedBasis(23),mass3set(:,22),G0tensor(167),G0tensor(163),G0tensor(172), &
    G0tensor(164),M2L1R1,[nMB,nMW],G0tensor(177),G0tensor(165))
call TI_triangle_red(G1tensor(85),RedBasis(22),mass3set(:,22),G0tensor(173),G0tensor(168),G0tensor(178), &
    G0tensor(169),M2L1R1,[nMB,nMW],G0tensor(179),G0tensor(174))
call TI_triangle_red(G1tensor(90),RedBasis(21),mass3set(:,23),G0tensor(187),G0tensor(183),G0tensor(192), &
    G0tensor(184),M2L1R1,[nMB],G0tensor(197))
call TI_triangle_red(G1tensor(203),RedBasis(59),mass3set(:,18),G0tensor(185),G0tensor(198),G0tensor(189), &
    G0tensor(199),M2L1R1,[nMW],G0tensor(194))
call TI_triangle_red(G1tensor(252),RedBasis(6),mass3set(:,15),G0tensor(213),G0tensor(208),G0tensor(224), &
    G0tensor(218),M2L1R1,[nMW],G0tensor(209))
call TI_triangle_red(G1tensor(227),RedBasis(10),mass3set(:,15),G0tensor(249),G0tensor(229),G0tensor(219), &
    G0tensor(214),M2L1R1,[nMW],G0tensor(243))
call TI_triangle_red(G1tensor(225),RedBasis(27),mass3set(:,19),G0tensor(228),G0tensor(223),G0tensor(258), &
    G0tensor(238),M2L1R1,[nMT,nMW],G0tensor(233),G0tensor(248))
call TI_triangle_red(G1tensor(230),RedBasis(26),mass3set(:,19),G0tensor(244),G0tensor(253),G0tensor(254), &
    G0tensor(259),M2L1R1,[nMT,nMW],G0tensor(260),G0tensor(262))
call TI_triangle_red(G1tensor(133),RedBasis(56),mass3set(:,4),G0tensor(263),G0tensor(264),G0tensor(268),G0tensor(269),M2L1R1)
call TI_triangle_red(G1tensor(232),RedBasis(11),mass3set(:,14),G0tensor(273),G0tensor(274),G0tensor(278), &
    G0tensor(279),M2L1R1,[nMW],G0tensor(281))
call TI_triangle_red(G1tensor(237),RedBasis(10),mass3set(:,14),G0tensor(282),G0tensor(283),G0tensor(284), &
    G0tensor(285),M2L1R1,[nMW],G0tensor(286))
call TI_triangle_red(G1tensor(235),RedBasis(29),mass3set(:,23),G0tensor(287),G0tensor(288),G0tensor(289), &
    G0tensor(290),M2L1R1,[nMB],G0tensor(291))
call TI_triangle_red(G1tensor(240),RedBasis(26),mass3set(:,23),G0tensor(292),G0tensor(293),G0tensor(294), &
    G0tensor(295),M2L1R1,[nMB],G0tensor(296))
call TI_triangle_red(G1tensor(148),RedBasis(56),mass3set(:,15),G0tensor(297),G0tensor(298),G0tensor(299), &
    G0tensor(300),M2L1R1,[nMW],G0tensor(301))
call TI_triangle_red(G1tensor(245),RedBasis(29),mass3set(:,24),G0tensor(302),G0tensor(303),G0tensor(304), &
    G0tensor(305),M2L1R1,[nMT],G0tensor(306))
call TI_triangle_red(G1tensor(255),RedBasis(21),mass3set(:,19),G0tensor(307),G0tensor(308),G0tensor(309), &
    G0tensor(310),M2L1R1,[nMT,nMW],G0tensor(311),G0tensor(312))
call TI_triangle_red(G1tensor(83),RedBasis(25),mass3set(:,25),G0tensor(313),G0tensor(314),G0tensor(315), &
    G0tensor(316),M2L1R1,[nMB,nMW],G0tensor(317),G0tensor(318))
call TI_triangle_red(G1tensor(234),RedBasis(24),mass3set(:,22),G0tensor(319),G0tensor(320),G0tensor(321), &
    G0tensor(322),M2L1R1,[nMB,nMW],G0tensor(323),G0tensor(324))
call TI_triangle_red(G1tensor(239),RedBasis(17),mass3set(:,22),G0tensor(325),G0tensor(326),G0tensor(327), &
    G0tensor(328),M2L1R1,[nMB,nMW],G0tensor(329),G0tensor(330))
call TI_triangle_red(G1tensor(102),RedBasis(52),mass3set(:,13),G0tensor(331),G0tensor(332),G0tensor(333), &
    G0tensor(334),M2L1R1,[nMT],G0tensor(335))
call TI_triangle_red(G1tensor(107),RedBasis(51),mass3set(:,5),G0tensor(336),G0tensor(337),G0tensor(338), &
    G0tensor(339),M2L1R1,[nMT],G0tensor(340))
call TI_triangle_red(G1tensor(108),RedBasis(5),mass3set(:,9),G0tensor(341),G0tensor(342),G0tensor(343), &
    G0tensor(344),M2L1R1,[nMW,nMT],G0tensor(345),G0tensor(346))
call TI_triangle_red(G1tensor(144),RedBasis(3),mass3set(:,9),G0tensor(347),G0tensor(348),G0tensor(349), &
    G0tensor(350),M2L1R1,[nMW,nMT],G0tensor(351),G0tensor(352))
call TI_triangle_red(G1tensor(204),RedBasis(52),mass3set(:,12),G0tensor(353),G0tensor(354),G0tensor(355), &
    G0tensor(356),M2L1R1,[nMB,nMW],G0tensor(357),G0tensor(358))
call TI_triangle_red(G1tensor(127),RedBasis(51),mass3set(:,1),G0tensor(359),G0tensor(360),G0tensor(361), &
    G0tensor(362),M2L1R1,[nMB],G0tensor(363))
call TI_triangle_red(G1tensor(128),RedBasis(5),mass3set(:,16),G0tensor(364),G0tensor(365),G0tensor(366), &
    G0tensor(367),M2L1R1,[nMB],G0tensor(368))
call TI_triangle_red(G1tensor(159),RedBasis(3),mass3set(:,16),G0tensor(369),G0tensor(370),G0tensor(371), &
    G0tensor(372),M2L1R1,[nMB],G0tensor(373))
call TI_triangle_red(G1tensor(137),RedBasis(55),mass3set(:,13),G0tensor(374),G0tensor(375),G0tensor(376), &
    G0tensor(377),M2L1R1,[nMT],G0tensor(378))
call TI_triangle_red(G1tensor(142),RedBasis(54),mass3set(:,13),G0tensor(379),G0tensor(380),G0tensor(381), &
    G0tensor(382),M2L1R1,[nMT],G0tensor(383))
call TI_triangle_red(G1tensor(152),RedBasis(55),mass3set(:,16),G0tensor(384),G0tensor(385),G0tensor(386), &
    G0tensor(387),M2L1R1,[nMB],G0tensor(388))
call TI_triangle_red(G1tensor(205),RedBasis(54),mass3set(:,12),G0tensor(389),G0tensor(390),G0tensor(391), &
    G0tensor(392),M2L1R1,[nMB,nMW],G0tensor(393),G0tensor(394))
call TI_triangle_red(G1tensor(167),RedBasis(58),mass3set(:,13),G0tensor(395),G0tensor(396),G0tensor(397), &
    G0tensor(398),M2L1R1,[nMT],G0tensor(399))
call TI_triangle_red(G1tensor(172),RedBasis(57),mass3set(:,13),G0tensor(400),G0tensor(401),G0tensor(402), &
    G0tensor(403),M2L1R1,[nMT],G0tensor(404))
call TI_triangle_red(G1tensor(177),RedBasis(29),mass3set(:,5),G0tensor(405),G0tensor(406),G0tensor(407), &
    G0tensor(408),M2L1R1,[nMT],G0tensor(409))
call TI_triangle_red(G1tensor(173),RedBasis(14),mass3set(:,14),G0tensor(410),G0tensor(411),G0tensor(412), &
    G0tensor(413),M2L1R1,[nMW],G0tensor(414))
call TI_triangle_red(G1tensor(178),RedBasis(13),mass3set(:,9),G0tensor(415),G0tensor(416),G0tensor(417), &
    G0tensor(418),M2L1R1,[nMW,nMT],G0tensor(419),G0tensor(420))
call TI_triangle_red(G1tensor(179),RedBasis(12),mass3set(:,9),G0tensor(421),G0tensor(422),G0tensor(423), &
    G0tensor(424),M2L1R1,[nMW,nMT],G0tensor(425),G0tensor(426))
call TI_triangle_red(G1tensor(187),RedBasis(58),mass3set(:,12),G0tensor(427),G0tensor(428),G0tensor(429), &
    G0tensor(430),M2L1R1,[nMB,nMW],G0tensor(431),G0tensor(432))
call TI_triangle_red(G1tensor(192),RedBasis(57),mass3set(:,12),G0tensor(433),G0tensor(434),G0tensor(435), &
    G0tensor(436),M2L1R1,[nMB,nMW],G0tensor(437),G0tensor(438))
call TI_triangle_red(G1tensor(197),RedBasis(29),mass3set(:,1),G0tensor(439),G0tensor(440),G0tensor(441), &
    G0tensor(442),M2L1R1,[nMB],G0tensor(443))
call TI_triangle_red(G1tensor(198),RedBasis(13),mass3set(:,16),G0tensor(444),G0tensor(445),G0tensor(446), &
    G0tensor(447),M2L1R1,[nMB],G0tensor(448))
call TI_triangle_red(G1tensor(199),RedBasis(12),mass3set(:,16),G0tensor(449),G0tensor(450),G0tensor(451), &
    G0tensor(452),M2L1R1,[nMB],G0tensor(453))
call TI_triangle_red(G1tensor(213),RedBasis(20),mass3set(:,24),G0tensor(454),G0tensor(455),G0tensor(456), &
    G0tensor(457),M2L1R1,[nMT],G0tensor(458))
call TI_triangle_red(G1tensor(224),RedBasis(19),mass3set(:,19),G0tensor(459),G0tensor(460),G0tensor(461), &
    G0tensor(462),M2L1R1,[nMT,nMW],G0tensor(463),G0tensor(464))
call TI_triangle_red(G1tensor(249),RedBasis(17),mass3set(:,19),G0tensor(465),G0tensor(466),G0tensor(467), &
    G0tensor(468),M2L1R1,[nMT,nMW],G0tensor(469),G0tensor(470))
call TI_triangle_red(G1tensor(243),RedBasis(28),mass3set(:,24),G0tensor(471),G0tensor(472),G0tensor(473), &
    G0tensor(474),M2L1R1,[nMT],G0tensor(475))
call TI_triangle_red(G1tensor(258),RedBasis(28),mass3set(:,22),G0tensor(476),G0tensor(477),G0tensor(478), &
    G0tensor(479),M2L1R1,[nMB,nMW],G0tensor(480),G0tensor(481))
call TI_triangle_red(G1tensor(248),RedBasis(24),mass3set(:,24),G0tensor(482),G0tensor(483),G0tensor(484), &
    G0tensor(485),M2L1R1,[nMT],G0tensor(486))
call TI_triangle_red(G1tensor(253),RedBasis(23),mass3set(:,24),G0tensor(487),G0tensor(488),G0tensor(489), &
    G0tensor(490),M2L1R1,[nMT],G0tensor(491))
call TI_triangle_red(G1tensor(254),RedBasis(22),mass3set(:,19),G0tensor(492),G0tensor(493),G0tensor(494), &
    G0tensor(495),M2L1R1,[nMT,nMW],G0tensor(496),G0tensor(497))
call TI_triangle_red(G1tensor(259),RedBasis(19),mass3set(:,22),G0tensor(498),G0tensor(499),G0tensor(500), &
    G0tensor(501),M2L1R1,[nMB,nMW],G0tensor(502),G0tensor(503))
call TI_triangle_red(G1tensor(260),RedBasis(27),mass3set(:,23),G0tensor(504),G0tensor(505),G0tensor(506), &
    G0tensor(507),M2L1R1,[nMB],G0tensor(508))
call ol_merge_tensors(T0sum(57),[G0tensor(1)])
call ol_merge_tensors(T0sum(58),[G0tensor(26)])
call ol_merge_tensors(T0sum(59),[G0tensor(51)])
call ol_merge_tensors(T0sum(60),[G0tensor(81)])
call ol_merge_tensors(T0sum(61),[G0tensor(101)])
call ol_merge_tensors(T0sum(62),[G0tensor(121)])
call ol_merge_tensors(T0sum(63),[G0tensor(141)])
call ol_merge_tensors(T0sum(64),[G0tensor(24)])
call ol_merge_tensors(T0sum(65),[G0tensor(87)])
call ol_merge_tensors(T0sum(66),[G0tensor(145)])
call ol_merge_tensors(T0sum(67),[G0tensor(247)])
call ol_merge_tensors(T0sum(68),[G0tensor(25)])
call ol_merge_tensors(T0sum(69),[G0tensor(30)])
call ol_merge_tensors(T0sum(70),[G0tensor(188)])
call ol_merge_tensors(T0sum(71),[G0tensor(33)])
call ol_merge_tensors(T0sum(72),[G0tensor(35)])
call ol_merge_tensors(T0sum(73),[G0tensor(77)])
call ol_merge_tensors(T0sum(74),[G0tensor(85)])
call ol_merge_tensors(T0sum(75),[G0tensor(52)])
call ol_merge_tensors(T0sum(76),[G0tensor(118)])
call ol_merge_tensors(T0sum(77),[G0tensor(49)])
call ol_merge_tensors(T0sum(78),[G0tensor(133)])
call ol_merge_tensors(T0sum(79),[G0tensor(237)])
call ol_merge_tensors(T0sum(80),[G0tensor(240)])
call ol_merge_tensors(T0sum(81),[G0tensor(245)])
call ol_merge_tensors(T0sum(82),[G0tensor(83)])
call ol_merge_tensors(T0sum(83),[G0tensor(239)])
call ol_merge_tensors(T0sum(84),[G0tensor(95)])
call ol_merge_tensors(T0sum(85),[G0tensor(104)])
call ol_merge_tensors(T0sum(86),[G0tensor(128)])
call ol_merge_tensors(T0sum(87),[G0tensor(124)])
call ol_merge_tensors(T0sum(88),[G0tensor(152)])
call ol_merge_tensors(T0sum(89),[G0tensor(167)])
call ol_merge_tensors(T0sum(90),[G0tensor(173)])
call ol_merge_tensors(T0sum(91),[G0tensor(187)])
call ol_merge_tensors(T0sum(92),[G0tensor(185)])
call ol_merge_tensors(T0sum(93),[G0tensor(213)])
call ol_merge_tensors(T0sum(94),[G0tensor(249)])
call ol_merge_tensors(T0sum(95),[G0tensor(228)])
call ol_merge_tensors(T0sum(96),[G0tensor(244)])
call ol_merge_tensors(T0sum(97),[G0tensor(263)])
call ol_merge_tensors(T0sum(98),[G0tensor(273)])
call ol_merge_tensors(T0sum(99),[G0tensor(282)])
call ol_merge_tensors(T0sum(100),[G0tensor(287)])
call ol_merge_tensors(T0sum(101),[G0tensor(292)])
call ol_merge_tensors(T0sum(102),[G0tensor(297)])
call ol_merge_tensors(T0sum(103),[G0tensor(302)])
call ol_merge_tensors(T0sum(104),[G0tensor(307)])
call ol_merge_tensors(T0sum(105),[G0tensor(313)])
call ol_merge_tensors(T0sum(106),[G0tensor(319)])
call ol_merge_tensors(T0sum(107),[G0tensor(325)])
call ol_merge_tensors(T0sum(108),[G0tensor(331)])
call ol_merge_tensors(T0sum(109),[G0tensor(336)])
call ol_merge_tensors(T0sum(110),[G0tensor(341)])
call ol_merge_tensors(T0sum(111),[G0tensor(347)])
call ol_merge_tensors(T0sum(112),[G0tensor(353)])
call ol_merge_tensors(T0sum(113),[G0tensor(359)])
call ol_merge_tensors(T0sum(114),[G0tensor(364)])
call ol_merge_tensors(T0sum(115),[G0tensor(369)])
call ol_merge_tensors(T0sum(116),[G0tensor(374)])
call ol_merge_tensors(T0sum(117),[G0tensor(379)])
call ol_merge_tensors(T0sum(118),[G0tensor(384)])
call ol_merge_tensors(T0sum(119),[G0tensor(389)])
call ol_merge_tensors(T0sum(120),[G0tensor(395)])
call ol_merge_tensors(T0sum(121),[G0tensor(400)])
call ol_merge_tensors(T0sum(122),[G0tensor(405)])
call ol_merge_tensors(T0sum(123),[G0tensor(410)])
call ol_merge_tensors(T0sum(124),[G0tensor(415)])
call ol_merge_tensors(T0sum(125),[G0tensor(421)])
call ol_merge_tensors(T0sum(126),[G0tensor(427)])
call ol_merge_tensors(T0sum(127),[G0tensor(433)])
call ol_merge_tensors(T0sum(128),[G0tensor(439)])
call ol_merge_tensors(T0sum(129),[G0tensor(444)])
call ol_merge_tensors(T0sum(130),[G0tensor(449)])
call ol_merge_tensors(T0sum(131),[G0tensor(454)])
call ol_merge_tensors(T0sum(132),[G0tensor(459)])
call ol_merge_tensors(T0sum(133),[G0tensor(465)])
call ol_merge_tensors(T0sum(134),[G0tensor(471)])
call ol_merge_tensors(T0sum(135),[G0tensor(476)])
call ol_merge_tensors(T0sum(136),[G0tensor(482)])
call ol_merge_tensors(T0sum(137),[G0tensor(487)])
call ol_merge_tensors(T0sum(138),[G0tensor(492)])
call ol_merge_tensors(T0sum(139),[G0tensor(498)])
call ol_merge_tensors(T0sum(140),[G0tensor(504)])
call ol_merge_tensors(T0sum(141),[G0tensor(166)])
call ol_merge_tensors(T0sum(142),[G0tensor(196)])
call ol_merge_tensors(T0sum(143),[G0tensor(226)])
call ol_merge_tensors(T0sum(144),[G0tensor(256)])
call ol_merge_tensors(T0sum(145),[G0tensor(200)])
call ol_merge_tensors(T0sum(146),[G0tensor(280)])
call ol_merge_tensors(T0sum(147),[G0tensor(153)])
call ol_merge_tensors(T0sum(148),[G0tensor(2)])
call ol_merge_tensors(T0sum(149),[G0tensor(175)])
call ol_merge_tensors(T0sum(150),[G0tensor(110)])
call ol_merge_tensors(T0sum(151),[G0tensor(120)])
Gcoeff(:)%j = (c(8)*M(1,:)%j) * den(33)
call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(57),h0tab(:,57),[52,11],[nMT,0],2,2,wf8(:,25),wf8(:,3))
  call Hloop_VA_Q(ntryL,G0H64(1),wf8(:,25),G0H8(2),m3h8x8(:,9),heltab2x64(:,:,57))
  call Hloop_A_Q(ntryL,G0H8(2),52,nMT,G1H8(2),n2h8(19))
Gcoeff(:)%j = (c(8)*M(1,:)%j) * den(34)
call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(58),h0tab(:,58),[35,28],[nMB,0],2,2,wf8(:,23),wf8(:,6))
  call Hloop_VA_Q(ntryL,G0H64(1),wf8(:,23),G0H8(1),m3h8x8(:,10),heltab2x64(:,:,58))
  call Hloop_A_Q(ntryL,G0H8(1),35,nMB,G1H8(1),n2h8(20))
Gcoeff(:)%j = (c(8)*M(1,:)%j) * den(35)
call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(59),h0tab(:,59),[56,7],[0,0],2,2,wf8(:,33),wf8(:,9))
  call Hloop_VQ_A(ntryL,G0H64(1),wf8(:,33),G0H8(2),m3h8x8(:,11),heltab2x64(:,:,59))
  call Hloop_Q_A(ntryL,G0H8(2),56,0,G1H8(4),n2h8(21))
Gcoeff(:)%j = (c(8)*M(1,:)%j) * den(36)
call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(60),h0tab(:,60),[44,19],[0,0],2,2,wf8(:,12),wf8(:,30))
  call Hloop_QA_V(ntryL,G0H64(1),wf8(:,12),G0H8(1),m3h8x8(:,12),heltab2x64(:,:,60))
  call Hcheck_last_AQ_V(ntryL,l_switch,G1H8(2),wf8(:,3),G1tensor(1),m3h8x1(:,7),heltab2x8(:,:,40))
  call Hcheck_last_AQ_V(ntryL,l_switch,G1H8(1),wf8(:,6),G1tensor(31),m3h8x1(:,8),heltab2x8(:,:,41))
  call Hcheck_last_QA_V(ntryL,l_switch,G1H8(4),wf8(:,9),G1tensor(61),m3h8x1(:,9),heltab2x8(:,:,42))
  call Hloop_VQ_A(ntryL,G0H8(1),wf8(:,30),G0H1(1),m3h8x1(:,10),heltab2x8(:,:,43))
  call Hcheck_last_Q_A(ntryL,l_switch,G0H1(1),63,0,G1tensor(18),n2h1(63))
  call ol_merge_tensors(G0tensor(440),[G0tensor(360),G0tensor(70),G0tensor(171),G0tensor(6)])
  call ol_merge_tensors(G1tensor(31),[G0tensor(447),G0tensor(367),G0tensor(22),G0tensor(211),G0tensor(11)])
  call ol_merge_tensors(G0tensor(452),[G0tensor(372),G0tensor(230),G0tensor(158),G0tensor(27),G0tensor(241),G0tensor(16)])
  call ol_merge_tensors(G0tensor(508),[G0tensor(502),G0tensor(480),G0tensor(453),G0tensor(448),G0tensor(443),G0tensor(437) &
    ,G0tensor(431),G0tensor(393),G0tensor(388),G0tensor(373),G0tensor(368),G0tensor(363),G0tensor(357),G0tensor(329),G0tensor(323) &
    ,G0tensor(317),G0tensor(296),G0tensor(291),G0tensor(197),G0tensor(179),G0tensor(177),G0tensor(58),G0tensor(74),G0tensor(69) &
    ,G0tensor(45),G0tensor(207),G0tensor(217),G0tensor(160),G0tensor(7),G0tensor(270),G0tensor(276),G0tensor(246),G0tensor(216) &
    ,G0tensor(191),G0tensor(71),G0tensor(21)])
  call ol_merge_tensors(G0tensor(484),[G0tensor(473),G0tensor(467),G0tensor(461),G0tensor(456),G0tensor(5),G0tensor(56) &
    ,G0tensor(31)])
  call ol_merge_tensors(G0tensor(406),[G0tensor(337),G0tensor(15),G0tensor(261),G0tensor(146),G0tensor(36)])
  call ol_merge_tensors(G0tensor(494),[G0tensor(489),G0tensor(130),G0tensor(41)])
  call ol_merge_tensors(G0tensor(496),[G0tensor(491),G0tensor(486),G0tensor(475),G0tensor(469),G0tensor(463),G0tensor(458) &
    ,G0tensor(426),G0tensor(420),G0tensor(409),G0tensor(404),G0tensor(399),G0tensor(383),G0tensor(378),G0tensor(352),G0tensor(346) &
    ,G0tensor(340),G0tensor(335),G0tensor(311),G0tensor(306),G0tensor(260),G0tensor(233),G0tensor(127),G0tensor(139),G0tensor(94) &
    ,G0tensor(43),G0tensor(37),G0tensor(210),G0tensor(17),G0tensor(14),G0tensor(12),G0tensor(190),G0tensor(272),G0tensor(265) &
    ,G0tensor(251),G0tensor(221),G0tensor(186),G0tensor(161),G0tensor(76),G0tensor(46)])
  call ol_merge_tensors(G0tensor(271),[G0tensor(61)])
  call ol_merge_tensors(G0tensor(328),[G0tensor(295),G0tensor(184),G0tensor(169),G0tensor(267),G0tensor(66)])
  call ol_merge_tensors(G0tensor(386),[G0tensor(376),G0tensor(303),G0tensor(299),G0tensor(288),G0tensor(274),G0tensor(268) &
    ,G0tensor(126),G0tensor(106),G0tensor(86)])
  call ol_merge_tensors(G0tensor(505),[G0tensor(455),G0tensor(451),G0tensor(446),G0tensor(333),G0tensor(264),G0tensor(183) &
    ,G0tensor(119),G0tensor(234),G0tensor(255),G0tensor(215),G0tensor(212),G0tensor(8),G0tensor(4),G0tensor(100),G0tensor(275) &
    ,G0tensor(91)])
  call ol_merge_tensors(G1tensor(61),[G0tensor(381),G0tensor(293),G0tensor(283),G0tensor(269),G0tensor(68),G0tensor(96)])
  call ol_merge_tensors(G0tensor(3),[G0tensor(242),G0tensor(111)])
  call ol_merge_tensors(G0tensor(125),[G0tensor(180),G0tensor(92),G0tensor(116)])
  call ol_merge_tensors(G0tensor(488),[G0tensor(472),G0tensor(411),G0tensor(402),G0tensor(397),G0tensor(371),G0tensor(366) &
    ,G0tensor(219),G0tensor(224),G0tensor(170),G0tensor(162),G0tensor(277),G0tensor(131)])
  call ol_merge_tensors(G1tensor(18),[G0tensor(483),G0tensor(227),G0tensor(252),G0tensor(195),G0tensor(105),G0tensor(136)])
  call ol_merge_tensors(G0tensor(396),[G0tensor(380),G0tensor(38),G0tensor(28),G0tensor(9),G0tensor(236),G0tensor(206) &
    ,G0tensor(151)])
  call ol_merge_tensors(G1tensor(1),[G0tensor(401),G0tensor(332),G0tensor(60),G0tensor(156)])
  call ol_merge_tensors(G0tensor(201),[G0tensor(176)])
  call ol_merge_tensors(G0tensor(231),[G0tensor(181)])
  call ol_merge_tensors(G0tensor(182),[G0tensor(10),G0tensor(266)])
  call ol_merge_tensors(G0tensor(507),[G0tensor(501),G0tensor(112)])
  call ol_merge_tensors(G0tensor(499),[G0tensor(413),G0tensor(168),G0tensor(149),G0tensor(154),G0tensor(40),G0tensor(132)])
  call ol_merge_tensors(G0tensor(418),[G0tensor(344),G0tensor(147),G0tensor(97)])
  call ol_merge_tensors(G0tensor(503),[G0tensor(497),G0tensor(481),G0tensor(470),G0tensor(464),G0tensor(438),G0tensor(432) &
    ,G0tensor(425),G0tensor(419),G0tensor(414),G0tensor(394),G0tensor(358),G0tensor(351),G0tensor(345),G0tensor(330),G0tensor(324) &
    ,G0tensor(318),G0tensor(312),G0tensor(301),G0tensor(286),G0tensor(281),G0tensor(262),G0tensor(248),G0tensor(243),G0tensor(209) &
    ,G0tensor(194),G0tensor(174),G0tensor(165),G0tensor(150),G0tensor(135),G0tensor(129),G0tensor(115),G0tensor(109),G0tensor(107) &
    ,G0tensor(79),G0tensor(75),G0tensor(67),G0tensor(63),G0tensor(138),G0tensor(54),G0tensor(123),G0tensor(203),G0tensor(80) &
    ,G0tensor(42),G0tensor(55),G0tensor(193),G0tensor(50),G0tensor(19),G0tensor(113),G0tensor(140),G0tensor(93)])
  call ol_merge_tensors(G0tensor(424),[G0tensor(350),G0tensor(39),G0tensor(98),G0tensor(117),G0tensor(13)])
  call ol_merge_tensors(G0tensor(428),[G0tensor(390),G0tensor(62),G0tensor(225),G0tensor(44),G0tensor(20),G0tensor(18)])
  call ol_merge_tensors(G0tensor(434),[G0tensor(354),G0tensor(232),G0tensor(23),G0tensor(155)])
  call ol_merge_tensors(G0tensor(493),[G0tensor(460),G0tensor(218),G0tensor(250),G0tensor(59),G0tensor(32),G0tensor(202)])
  call ol_merge_tensors(G0tensor(375),[G0tensor(342),G0tensor(338),G0tensor(257),G0tensor(29)])
  call ol_merge_tensors(G0tensor(320),[G0tensor(279),G0tensor(142),G0tensor(103),G0tensor(34)])
  call ol_merge_tensors(G0tensor(326),[G0tensor(285),G0tensor(157),G0tensor(82),G0tensor(220)])
  call ol_merge_tensors(G0tensor(355),[G0tensor(308),G0tensor(298),G0tensor(223),G0tensor(208),G0tensor(189),G0tensor(47) &
    ,G0tensor(90)])
  call ol_merge_tensors(G0tensor(385),[G0tensor(365),G0tensor(361),G0tensor(48),G0tensor(65)])
  call ol_merge_tensors(G0tensor(466),[G0tensor(214),G0tensor(88),G0tensor(235),G0tensor(53),G0tensor(222)])
  call ol_merge_tensors(G0tensor(314),[G0tensor(198),G0tensor(205),G0tensor(134),G0tensor(204),G0tensor(64),G0tensor(143) &
    ,G0tensor(57)])
  call ol_merge_tensors(G0tensor(435),[G0tensor(429),G0tensor(89),G0tensor(73),G0tensor(148)])
  call ol_merge_tensors(G0tensor(108),[G0tensor(78),G0tensor(72)])
  call ol_merge_tensors(G0tensor(457),[G0tensor(99),G0tensor(84)])
  call ol_merge_tensors(G0tensor(462),[G0tensor(238),G0tensor(122),G0tensor(102)])
  call ol_merge_tensors(G0tensor(495),[G0tensor(468),G0tensor(310),G0tensor(259),G0tensor(114),G0tensor(144)])
  call ol_merge_tensors(G0tensor(477),[G0tensor(349),G0tensor(343),G0tensor(284),G0tensor(278),G0tensor(163),G0tensor(137) &
    ,G0tensor(159)])
  call ol_merge_tensors(G0tensor(316),[G0tensor(178),G0tensor(172)])
  call ol_merge_tensors(G0tensor(322),[G0tensor(290),G0tensor(192),G0tensor(164)])
  call ol_merge_tensors(G0tensor(391),[G0tensor(300),G0tensor(253),G0tensor(229),G0tensor(199)])
  call ol_merge_tensors(G0tensor(474),[G0tensor(304),G0tensor(254),G0tensor(258)])
  call ol_merge_tensors(G0tensor(506),[G0tensor(479),G0tensor(294),G0tensor(289)])
  call ol_merge_tensors(G0tensor(490),[G0tensor(485),G0tensor(309),G0tensor(305)])
  call ol_merge_tensors(G0tensor(500),[G0tensor(478),G0tensor(327),G0tensor(321),G0tensor(315)])
  call ol_merge_tensors(G0tensor(382),[G0tensor(377),G0tensor(348),G0tensor(339),G0tensor(334)])
  call ol_merge_tensors(G0tensor(392),[G0tensor(387),G0tensor(370),G0tensor(362),G0tensor(356)])
  call ol_merge_tensors(G0tensor(416),[G0tensor(407),G0tensor(398)])
  call ol_merge_tensors(G0tensor(422),[G0tensor(408),G0tensor(403)])
  call ol_merge_tensors(G0tensor(423),[G0tensor(417),G0tensor(412)])
  call ol_merge_tensors(G0tensor(445),[G0tensor(441),G0tensor(430)])
  call ol_merge_tensors(G0tensor(450),[G0tensor(442),G0tensor(436)])
call TI_bubble_red(G1tensor(31),35,mass2set(:,1),G0tensor(1),M2L1R1,G0tensor(26))
call TI_bubble_red(G1tensor(61),56,mass2set(:,2),G0tensor(51),M2L1R1)
call TI_bubble_red(G1tensor(18),44,mass2set(:,2),G0tensor(81),M2L1R1)
call TI_bubble_red(G1tensor(1),52,mass2set(:,3),G0tensor(101),M2L1R1,G0tensor(121))
  call ol_merge_tensors(G0tensor(508),[G0tensor(26)])
  call ol_merge_tensors(G0tensor(121),[G0tensor(496)])
call ol_merge_tensors(T0sum(152),[G0tensor(440)])
call ol_merge_tensors(T0sum(153),[G0tensor(1)])
call ol_merge_tensors(T0sum(154),[G0tensor(508)])
call ol_merge_tensors(T0sum(155),[G0tensor(452)])
call ol_merge_tensors(T0sum(156),[G0tensor(484)])
call ol_merge_tensors(T0sum(157),[G0tensor(406)])
call ol_merge_tensors(T0sum(158),[G0tensor(494)])
call ol_merge_tensors(T0sum(159),[G0tensor(121)])
call ol_merge_tensors(T0sum(160),[G0tensor(271)])
call ol_merge_tensors(T0sum(161),[G0tensor(328)])
call ol_merge_tensors(T0sum(162),[G0tensor(386)])
call ol_merge_tensors(T0sum(163),[G0tensor(505)])
call ol_merge_tensors(T0sum(164),[G0tensor(51)])
call ol_merge_tensors(T0sum(165),[G0tensor(3)])
call ol_merge_tensors(T0sum(166),[G0tensor(125)])
call ol_merge_tensors(T0sum(167),[G0tensor(488)])
call ol_merge_tensors(T0sum(168),[G0tensor(81)])
call ol_merge_tensors(T0sum(169),[G0tensor(396)])
call ol_merge_tensors(T0sum(170),[G0tensor(101)])
call ol_merge_tensors(T0sum(171),[G0tensor(201)])
call ol_merge_tensors(T0sum(172),[G0tensor(231)])
call ol_merge_tensors(T0sum(173),[G0tensor(182)])
call ol_merge_tensors(T0sum(174),[G0tensor(507)])
call ol_merge_tensors(T0sum(175),[G0tensor(499)])
call ol_merge_tensors(T0sum(176),[G0tensor(418)])
call ol_merge_tensors(T0sum(177),[G0tensor(503)])
call ol_merge_tensors(T0sum(178),[G0tensor(424)])
call ol_merge_tensors(T0sum(179),[G0tensor(428)])
call ol_merge_tensors(T0sum(180),[G0tensor(434)])
call ol_merge_tensors(T0sum(181),[G0tensor(493)])
call ol_merge_tensors(T0sum(182),[G0tensor(375)])
call ol_merge_tensors(T0sum(183),[G0tensor(320)])
call ol_merge_tensors(T0sum(184),[G0tensor(326)])
call ol_merge_tensors(T0sum(185),[G0tensor(355)])
call ol_merge_tensors(T0sum(186),[G0tensor(385)])
call ol_merge_tensors(T0sum(187),[G0tensor(466)])
call ol_merge_tensors(T0sum(188),[G0tensor(314)])
call ol_merge_tensors(T0sum(189),[G0tensor(435)])
call ol_merge_tensors(T0sum(190),[G0tensor(108)])
call ol_merge_tensors(T0sum(191),[G0tensor(457)])
call ol_merge_tensors(T0sum(192),[G0tensor(462)])
call ol_merge_tensors(T0sum(193),[G0tensor(495)])
call ol_merge_tensors(T0sum(194),[G0tensor(477)])
call ol_merge_tensors(T0sum(195),[G0tensor(316)])
call ol_merge_tensors(T0sum(196),[G0tensor(322)])
call ol_merge_tensors(T0sum(197),[G0tensor(391)])
call ol_merge_tensors(T0sum(198),[G0tensor(474)])
call ol_merge_tensors(T0sum(199),[G0tensor(506)])
call ol_merge_tensors(T0sum(200),[G0tensor(490)])
call ol_merge_tensors(T0sum(201),[G0tensor(500)])
call ol_merge_tensors(T0sum(202),[G0tensor(382)])
call ol_merge_tensors(T0sum(203),[G0tensor(392)])
call ol_merge_tensors(T0sum(204),[G0tensor(416)])
call ol_merge_tensors(T0sum(205),[G0tensor(422)])
call ol_merge_tensors(T0sum(206),[G0tensor(423)])
call ol_merge_tensors(T0sum(207),[G0tensor(445)])
call ol_merge_tensors(T0sum(208),[G0tensor(450)])


! Compute scalar Master integrals 

call compute_scalar_box([ 36, 52, 55 ],masses2_51,RedSet_4(1),ScalarBoxes(1))
call compute_scalar_box([ 32, 52, 55 ],masses2_51,RedSet_4(2),ScalarBoxes(2))
call compute_scalar_box([ 32, 36, 55 ],masses2_47,RedSet_4(3),ScalarBoxes(3))
call compute_scalar_box([ 32, 36, 52 ],masses2_47,RedSet_4(4),ScalarBoxes(4))
call compute_scalar_box([ 4, 20, 23 ],masses2_50,RedSet_4(5),ScalarBoxes(5))
call compute_scalar_box([ 35, 43, 47 ],masses2_61,RedSet_4(6),ScalarBoxes(6))
call compute_scalar_box([ 32, 43, 47 ],masses2_61,RedSet_4(7),ScalarBoxes(7))
call compute_scalar_box([ 32, 35, 47 ],masses2_63,RedSet_4(8),ScalarBoxes(8))
call compute_scalar_box([ 32, 35, 43 ],masses2_63,RedSet_4(9),ScalarBoxes(9))
call compute_scalar_box([ 3, 11, 15 ],masses2_60,RedSet_4(10),ScalarBoxes(10))
call compute_scalar_box([ 35, 43, 47 ],masses2_56,RedSet_4(6),ScalarBoxes(11))
call compute_scalar_box([ 32, 43, 47 ],masses2_56,RedSet_4(7),ScalarBoxes(12))
call compute_scalar_box([ 32, 35, 47 ],masses2_53,RedSet_4(8),ScalarBoxes(13))
call compute_scalar_box([ 32, 35, 43 ],masses2_55,RedSet_4(9),ScalarBoxes(14))
call compute_scalar_box([ 3, 11, 15 ],masses2_57,RedSet_4(10),ScalarBoxes(15))
call compute_scalar_box([ 40, 44, 47 ],masses2_45,RedSet_4(11),ScalarBoxes(16))
call compute_scalar_box([ 32, 44, 47 ],masses2_61,RedSet_4(12),ScalarBoxes(17))
call compute_scalar_box([ 32, 40, 47 ],masses2_61,RedSet_4(13),ScalarBoxes(18))
call compute_scalar_box([ 32, 40, 44 ],masses2_61,RedSet_4(14),ScalarBoxes(19))
call compute_scalar_box([ 8, 12, 15 ],masses2_44,RedSet_4(15),ScalarBoxes(20))
call compute_scalar_box([ 40, 44, 47 ],masses2_64,RedSet_4(11),ScalarBoxes(21))
call compute_scalar_box([ 32, 44, 47 ],masses2_52,RedSet_4(12),ScalarBoxes(22))
call compute_scalar_box([ 32, 40, 47 ],masses2_56,RedSet_4(13),ScalarBoxes(23))
call compute_scalar_box([ 32, 40, 44 ],masses2_56,RedSet_4(14),ScalarBoxes(24))
call compute_scalar_box([ 8, 12, 15 ],masses2_65,RedSet_4(15),ScalarBoxes(25))
call compute_scalar_box([ 35, 43, 59 ],masses2_61,RedSet_4(16),ScalarBoxes(26))
call compute_scalar_box([ 32, 43, 59 ],masses2_61,RedSet_4(17),ScalarBoxes(27))
call compute_scalar_box([ 32, 35, 59 ],masses2_63,RedSet_4(18),ScalarBoxes(28))
call compute_scalar_box([ 3, 11, 27 ],masses2_60,RedSet_4(19),ScalarBoxes(29))
call compute_scalar_box([ 35, 43, 59 ],masses2_56,RedSet_4(16),ScalarBoxes(30))
call compute_scalar_box([ 32, 43, 59 ],masses2_56,RedSet_4(17),ScalarBoxes(31))
call compute_scalar_box([ 32, 35, 59 ],masses2_53,RedSet_4(18),ScalarBoxes(32))
call compute_scalar_box([ 3, 11, 27 ],masses2_57,RedSet_4(19),ScalarBoxes(33))
call compute_scalar_box([ 40, 43, 47 ],masses2_68,RedSet_4(20),ScalarBoxes(34))
call compute_scalar_box([ 32, 40, 43 ],masses2_58,RedSet_4(21),ScalarBoxes(35))
call compute_scalar_box([ 8, 11, 15 ],masses2_69,RedSet_4(22),ScalarBoxes(36))
call compute_scalar_box([ 35, 51, 55 ],masses2_66,RedSet_4(23),ScalarBoxes(37))
call compute_scalar_box([ 32, 51, 55 ],masses2_66,RedSet_4(24),ScalarBoxes(38))
call compute_scalar_box([ 32, 35, 55 ],masses2_70,RedSet_4(25),ScalarBoxes(39))
call compute_scalar_box([ 32, 35, 51 ],masses2_70,RedSet_4(26),ScalarBoxes(40))
call compute_scalar_box([ 3, 19, 23 ],masses2_67,RedSet_4(27),ScalarBoxes(41))
call compute_scalar_box([ 35, 39, 55 ],masses2_66,RedSet_4(28),ScalarBoxes(42))
call compute_scalar_box([ 32, 39, 55 ],masses2_66,RedSet_4(29),ScalarBoxes(43))
call compute_scalar_box([ 32, 35, 39 ],masses2_70,RedSet_4(30),ScalarBoxes(44))
call compute_scalar_box([ 3, 7, 23 ],masses2_67,RedSet_4(31),ScalarBoxes(45))
call compute_scalar_box([ 36, 39, 55 ],masses2_47,RedSet_4(32),ScalarBoxes(46))
call compute_scalar_box([ 32, 39, 55 ],masses2_47,RedSet_4(29),ScalarBoxes(47))
call compute_scalar_box([ 32, 36, 39 ],masses2_43,RedSet_4(33),ScalarBoxes(48))
call compute_scalar_box([ 4, 7, 23 ],masses2_46,RedSet_4(34),ScalarBoxes(49))
call compute_scalar_box([ 36, 39, 55 ],masses2_44,RedSet_4(32),ScalarBoxes(50))
call compute_scalar_box([ 32, 36, 55 ],masses2_66,RedSet_4(3),ScalarBoxes(51))
call compute_scalar_box([ 32, 36, 39 ],masses2_66,RedSet_4(33),ScalarBoxes(52))
call compute_scalar_box([ 4, 7, 23 ],masses2_45,RedSet_4(34),ScalarBoxes(53))
! end of process


end subroutine vamp_1

end module ol_vamp_1_pptllj_nenexuxtdbx_1_/**/REALKIND
