
! **********************************************************************
module ol_tables_storage_pptllj_nenexuxtdbx_1_/**/REALKIND
! **********************************************************************
  use KIND_TYPES, only: REALKIND, QREALKIND, intkind2
  use ol_data_types_/**/REALKIND, only: hol
  use ol_data_types_/**/REALKIND, only: basis, redset4, redset5
 use ol_data_types_/**/REALKIND, only: scalarbox 

  implicit none

  ! helicity tables for the 1-loop recursion
integer(intkind2), save :: h0tab(64,60)
integer(intkind2), save :: heltab2x2(2,2,84)
integer(intkind2), save :: heltab2x4(2,4,49)
integer(intkind2), save :: heltab2x8(2,8,43)
integer(intkind2), save :: heltab2x16(2,16,27)
integer(intkind2), save :: heltab2x32(2,32,38)
integer(intkind2), save :: heltab2x64(2,64,60)


  ! number of helicity states for openloops recursion steps
integer(intkind2), save :: m0h(60)
integer(intkind2), save :: m3h2x1(3,84)
integer(intkind2), save :: m3h4x1(3,9)
integer(intkind2), save :: m3h8x1(3,10)
integer(intkind2), save :: m3h16x1(3,6)
integer(intkind2), save :: m3h2x2(3,40)
integer(intkind2), save :: m3h4x2(3,19)
integer(intkind2), save :: m3h8x2(3,5)
integer(intkind2), save :: m3h2x4(3,14)
integer(intkind2), save :: m3h4x4(3,7)
integer(intkind2), save :: m3h8x4(3,5)
integer(intkind2), save :: m3h16x4(3,6)
integer(intkind2), save :: m3h2x8(3,9)
integer(intkind2), save :: m3h4x8(3,10)
integer(intkind2), save :: m3h8x8(3,12)
integer(intkind2), save :: m3h2x16(3,23)
integer(intkind2), save :: m3h4x16(3,4)
integer(intkind2), save :: m3h2x32(3,38)

integer(intkind2), save :: n2h1(63)
integer(intkind2), save :: n2h2(43)
integer(intkind2), save :: n2h4(24)
integer(intkind2), save :: n2h8(21)
integer(intkind2), save :: n2h16(19)
integer(intkind2), save :: n2h32(16)


contains

!**********************************************************************
subroutine HOL_m3_init()
!**********************************************************************
! initialize m3 arrays for helicity summation
!**********************************************************************
  use KIND_TYPES, only: REALKIND, intkind2

m3h2x1(1,:)=2
m3h2x1(2,:)=1
m3h2x1(3,:)=2
m3h4x1(1,:)=4
m3h4x1(2,:)=1
m3h4x1(3,:)=4
m3h8x1(1,:)=8
m3h8x1(2,:)=1
m3h8x1(3,:)=8
m3h16x1(1,:)=16
m3h16x1(2,:)=1
m3h16x1(3,:)=16
m3h2x2(1,:)=2
m3h2x2(2,:)=2
m3h2x2(3,:)=4
m3h4x2(1,:)=4
m3h4x2(2,:)=2
m3h4x2(3,:)=8
m3h8x2(1,:)=8
m3h8x2(2,:)=2
m3h8x2(3,:)=16
m3h2x4(1,:)=2
m3h2x4(2,:)=4
m3h2x4(3,:)=8
m3h4x4(1,:)=4
m3h4x4(2,:)=4
m3h4x4(3,:)=16
m3h8x4(1,:)=8
m3h8x4(2,:)=4
m3h8x4(3,:)=32
m3h16x4(1,:)=16
m3h16x4(2,:)=4
m3h16x4(3,:)=64
m3h2x8(1,:)=2
m3h2x8(2,:)=8
m3h2x8(3,:)=16
m3h4x8(1,:)=4
m3h4x8(2,:)=8
m3h4x8(3,:)=32
m3h8x8(1,:)=8
m3h8x8(2,:)=8
m3h8x8(3,:)=64
m3h2x16(1,:)=2
m3h2x16(2,:)=16
m3h2x16(3,:)=32
m3h4x16(1,:)=4
m3h4x16(2,:)=16
m3h4x16(3,:)=64
m3h2x32(1,:)=2
m3h2x32(2,:)=32
m3h2x32(3,:)=64

n2h1(:)=1
n2h2(:)=2
n2h4(:)=4
n2h8(:)=8
n2h16(:)=16
n2h32(:)=32


end subroutine HOL_m3_init

!**********************************************************************

end module ol_tables_storage_pptllj_nenexuxtdbx_1_/**/REALKIND

! **********************************************************************
module ol_tensor_sum_storage_pptllj_nenexuxtdbx_1_/**/REALKIND
! **********************************************************************
  use KIND_TYPES, only: REALKIND, QREALKIND, intkind2
  use ol_data_types_/**/REALKIND, only: hol, hcl, met
  use ol_data_types_/**/REALKIND, only: basis, redset4, redset5
 use ol_data_types_/**/REALKIND, only: scalarbox 

  implicit none

  type(met), save :: M2L1R1

  ! Declarations of loop wave function tensors

  type(hol), save :: G0H1(1)
  type(hol), save :: G1H1(1)
  type(hol), save :: G1H2(35)
  type(hol), save :: G2H2(27)
  type(hol), save :: G0H4(1)
  type(hol), save :: G1H4(30)
  type(hol), save :: G2H4(9)
  type(hol), save :: G0H8(2)
  type(hol), save :: G1H8(14)
  type(hol), save :: G2H8(4)
  type(hol), save :: G0H16(1)
  type(hol), save :: G1H16(9)
  type(hol), save :: G0H32(8)
  type(hol), save :: G1H32(8)
  type(hol), save :: G0H64(1)
  type(hcl), save, dimension(508) :: G0tensor
  type(hcl), save, dimension(280) :: G1tensor
  type(hcl), save, dimension(71) :: G2tensor



  ! Declarations for on-the-fly tensor reduction 
type (basis),      save :: RedBasis(60)
type (redset4),    save :: RedSet_4(40)
type (redset5),    save :: RedSet_5(8)
integer, save :: mass2set(0:1,3)
integer, save :: mass3set(0:2,25)
integer, save :: mass4set(0:3,22)
integer, save :: mass5set(0:4,9)



  ! Declarations for TI calls

  integer, save :: momenta_1(2)
  integer, save :: momenta_2(2)
  integer, save :: momenta_3(2)
  integer, save :: momenta_4(2)
  integer, save :: momenta_5(2)
  integer, save :: momenta_6(2)
  integer, save :: momenta_7(2)
  integer, save :: momenta_8(2)
  integer, save :: momenta_9(2)
  integer, save :: momenta_10(2)
  integer, save :: momenta_11(2)
  integer, save :: momenta_12(2)
  integer, save :: momenta_13(2)
  integer, save :: momenta_14(2)
  integer, save :: momenta_15(2)
  integer, save :: momenta_16(2)
  integer, save :: momenta_17(3)
  integer, save :: momenta_18(3)
  integer, save :: momenta_19(3)
  integer, save :: momenta_20(3)
  integer, save :: momenta_21(3)
  integer, save :: momenta_22(3)
  integer, save :: momenta_23(3)
  integer, save :: momenta_24(3)
  integer, save :: momenta_25(3)
  integer, save :: momenta_26(3)
  integer, save :: momenta_27(3)
  integer, save :: momenta_28(3)
  integer, save :: momenta_29(3)
  integer, save :: momenta_30(3)
  integer, save :: momenta_31(3)
  integer, save :: momenta_32(3)
  integer, save :: momenta_33(3)
  integer, save :: momenta_34(3)
  integer, save :: momenta_35(3)
  integer, save :: momenta_36(3)
  integer, save :: momenta_37(3)
  integer, save :: momenta_38(3)
  integer, save :: momenta_39(3)
  integer, save :: momenta_40(3)
  integer, save :: momenta_41(3)
  integer, save :: momenta_42(3)
  integer, save :: momenta_43(3)
  integer, save :: momenta_44(3)
  integer, save :: momenta_45(3)
  integer, save :: momenta_46(3)
  integer, save :: momenta_47(3)
  integer, save :: momenta_48(3)
  integer, save :: momenta_49(3)
  integer, save :: momenta_50(3)
  integer, save :: momenta_51(3)
  integer, save :: momenta_52(3)
  integer, save :: momenta_53(3)
  integer, save :: momenta_54(3)
  integer, save :: momenta_55(3)
  integer, save :: momenta_56(3)
  integer, save :: momenta_57(3)
  integer, save :: momenta_58(3)
  integer, save :: momenta_59(4)
  integer, save :: momenta_60(4)
  integer, save :: momenta_61(4)
  integer, save :: momenta_62(4)
  integer, save :: momenta_63(4)
  integer, save :: momenta_64(4)
  integer, save :: momenta_65(4)
  integer, save :: momenta_66(4)
  integer, save :: momenta_67(4)
  integer, save :: momenta_68(4)
  integer, save :: momenta_69(4)
  integer, save :: momenta_70(4)
  integer, save :: momenta_71(4)
  integer, save :: momenta_72(4)
  integer, save :: momenta_73(4)
  integer, save :: momenta_74(4)
  integer, save :: momenta_75(4)
  integer, save :: momenta_76(4)
  integer, save :: momenta_77(4)
  integer, save :: momenta_78(4)
  integer, save :: momenta_79(4)
  integer, save :: momenta_80(4)
  integer, save :: momenta_81(4)
  integer, save :: momenta_82(4)
  integer, save :: momenta_83(4)
  integer, save :: momenta_84(4)
  integer, save :: momenta_85(4)
  integer, save :: momenta_86(4)
  integer, save :: momenta_87(4)
  integer, save :: momenta_88(4)
  integer, save :: momenta_89(4)
  integer, save :: momenta_90(4)
  integer, save :: momenta_91(5)
  integer, save :: momenta_92(5)
  integer, save :: momenta_93(5)
  integer, save :: momenta_94(5)
  integer, save :: momenta_95(5)
  integer, save :: momenta_96(5)
  integer, save :: momenta_97(5)
  integer, save :: momenta_98(5)

  integer, save :: masses2_1(2)
  integer, save :: masses2_2(2)
  integer, save :: masses2_3(2)
  integer, save :: masses2_4(2)
  integer, save :: masses2_5(2)
  integer, save :: masses2_6(2)
  integer, save :: masses2_7(2)
  integer, save :: masses2_8(2)
  integer, save :: masses2_9(2)
  integer, save :: masses2_10(2)
  integer, save :: masses2_11(2)
  integer, save :: masses2_12(2)
  integer, save :: masses2_13(2)
  integer, save :: masses2_14(2)
  integer, save :: masses2_15(2)
  integer, save :: masses2_16(2)
  integer, save :: masses2_17(3)
  integer, save :: masses2_18(3)
  integer, save :: masses2_19(3)
  integer, save :: masses2_20(3)
  integer, save :: masses2_21(3)
  integer, save :: masses2_22(3)
  integer, save :: masses2_23(3)
  integer, save :: masses2_24(3)
  integer, save :: masses2_25(3)
  integer, save :: masses2_26(3)
  integer, save :: masses2_27(3)
  integer, save :: masses2_28(3)
  integer, save :: masses2_29(3)
  integer, save :: masses2_30(3)
  integer, save :: masses2_31(3)
  integer, save :: masses2_32(3)
  integer, save :: masses2_33(3)
  integer, save :: masses2_34(3)
  integer, save :: masses2_35(3)
  integer, save :: masses2_36(3)
  integer, save :: masses2_37(3)
  integer, save :: masses2_38(3)
  integer, save :: masses2_39(3)
  integer, save :: masses2_40(3)
  integer, save :: masses2_41(3)
  integer, save :: masses2_42(4)
  integer, save :: masses2_43(4)
  integer, save :: masses2_44(4)
  integer, save :: masses2_45(4)
  integer, save :: masses2_46(4)
  integer, save :: masses2_47(4)
  integer, save :: masses2_48(4)
  integer, save :: masses2_49(4)
  integer, save :: masses2_50(4)
  integer, save :: masses2_51(4)
  integer, save :: masses2_52(4)
  integer, save :: masses2_53(4)
  integer, save :: masses2_54(4)
  integer, save :: masses2_55(4)
  integer, save :: masses2_56(4)
  integer, save :: masses2_57(4)
  integer, save :: masses2_58(4)
  integer, save :: masses2_59(4)
  integer, save :: masses2_60(4)
  integer, save :: masses2_61(4)
  integer, save :: masses2_62(4)
  integer, save :: masses2_63(4)
  integer, save :: masses2_64(4)
  integer, save :: masses2_65(4)
  integer, save :: masses2_66(4)
  integer, save :: masses2_67(4)
  integer, save :: masses2_68(4)
  integer, save :: masses2_69(4)
  integer, save :: masses2_70(4)
  integer, save :: masses2_71(5)
  integer, save :: masses2_72(5)
  integer, save :: masses2_73(5)
  integer, save :: masses2_74(5)
  integer, save :: masses2_75(5)
  integer, save :: masses2_76(5)
  integer, save :: masses2_77(5)
  integer, save :: masses2_78(5)
  integer, save :: masses2_79(5)

type(scalarbox), save :: ScalarBoxes(53)

integer, save :: sbarray_1(5)
integer, save :: sbarray_2(5)
integer, save :: sbarray_3(5)
integer, save :: sbarray_4(5)
integer, save :: sbarray_5(5)
integer, save :: sbarray_6(5)
integer, save :: sbarray_7(5)
integer, save :: sbarray_8(5)
integer, save :: sbarray_9(5)
integer, save :: sbarray_10(5)
integer, save :: sbarray_11(5)
integer, save :: sbarray_12(5)

  type(hcl), save, dimension(208) :: T0sum
  type(hcl), save, dimension(12) :: T1sum


  contains

!**********************************************************************
subroutine HOL_memory_allocation()
!**********************************************************************
! allocation of memory for the types hol
!**********************************************************************
  use KIND_TYPES, only: REALKIND
  use ol_data_types_/**/REALKIND, only: hol
  use hol_initialisation_/**/REALKIND, only: hol_allocation
  implicit none

    call hol_allocation(4,1,4,1,G0H1,1)
  call hol_allocation(4,5,4,1,G1H1,1)
  call hol_allocation(4,5,4,2,G1H2,35)
  call hol_allocation(4,15,4,2,G2H2,27)
  call hol_allocation(4,1,4,4,G0H4,1)
  call hol_allocation(4,5,4,4,G1H4,30)
  call hol_allocation(4,15,4,4,G2H4,9)
  call hol_allocation(4,1,4,8,G0H8,2)
  call hol_allocation(4,5,4,8,G1H8,14)
  call hol_allocation(4,15,4,8,G2H8,4)
  call hol_allocation(4,1,4,16,G0H16,1)
  call hol_allocation(4,5,4,16,G1H16,9)
  call hol_allocation(4,1,4,32,G0H32,8)
  call hol_allocation(4,5,4,32,G1H32,8)
  call hol_allocation(4,1,4,64,G0H64,1)


end subroutine HOL_memory_allocation


!**********************************************************************
subroutine HOL_memory_deallocation_/**/REALKIND(dmode)
!**********************************************************************
! allocation of memory for the types hol
!**********************************************************************
  use KIND_TYPES, only: REALKIND
  use ol_data_types_/**/REALKIND, only: hol
  use hol_initialisation_/**/REALKIND, only: hol_deallocation
  implicit none
  integer,   intent(in)    :: dmode

    call hol_deallocation(G0H1,1,dmode)
  call hol_deallocation(G1H1,1,dmode)
  call hol_deallocation(G1H2,35,dmode)
  call hol_deallocation(G2H2,27,dmode)
  call hol_deallocation(G0H4,1,dmode)
  call hol_deallocation(G1H4,30,dmode)
  call hol_deallocation(G2H4,9,dmode)
  call hol_deallocation(G0H8,2,dmode)
  call hol_deallocation(G1H8,14,dmode)
  call hol_deallocation(G2H8,4,dmode)
  call hol_deallocation(G0H16,1,dmode)
  call hol_deallocation(G1H16,9,dmode)
  call hol_deallocation(G0H32,8,dmode)
  call hol_deallocation(G1H32,8,dmode)
  call hol_deallocation(G0H64,1,dmode)


end subroutine HOL_memory_deallocation_/**/REALKIND

!**********************************************************************
subroutine HCL_memory_allocation()
!**********************************************************************
! allocation of memory for the types hcl
!**********************************************************************
  use KIND_TYPES, only: REALKIND
  use ol_data_types_/**/REALKIND, only: hcl
  use hol_initialisation_/**/REALKIND, only: hcl_allocation
  implicit none

  call hcl_allocation(1,G0tensor, 508)
call hcl_allocation(5,G1tensor, 280)
call hcl_allocation(15,G2tensor, 71)


end subroutine HCL_memory_allocation


!**********************************************************************
subroutine HCL_memory_deallocation_/**/REALKIND(dmode)
!**********************************************************************
! deallocation of memory for the types hcl
!**********************************************************************
  use KIND_TYPES, only: REALKIND
  use ol_data_types_/**/REALKIND, only: hcl
  use hol_initialisation_/**/REALKIND, only: hcl_deallocation
  implicit none
  integer,   intent(in)    :: dmode

  call hcl_deallocation(G0tensor, 508,dmode)
call hcl_deallocation(G1tensor, 280,dmode)
call hcl_deallocation(G2tensor, 71,dmode)

  call hcl_deallocation(T0sum,208,dmode)
call hcl_deallocation(T1sum,12,dmode)


end subroutine HCL_memory_deallocation_/**/REALKIND


!**********************************************************************
subroutine Tsum_memory_allocation()
!**********************************************************************
! allocation of memory for the types hcl
!**********************************************************************
  use KIND_TYPES, only: REALKIND
  use ol_data_types_/**/REALKIND, only: hcl
  use hol_initialisation_/**/REALKIND, only: hcl_allocation
  implicit none

  call hcl_allocation(1,T0sum,208)
call hcl_allocation(5,T1sum,12)


end subroutine Tsum_memory_allocation


#ifdef PRECISION_dp
subroutine max_point(r) &
    & bind(c,name="ol_f_max_point_pptllj_nenexuxtdbx_1")
  ! Return the number maximal tensor rank
  implicit none
  integer, intent(out) :: r
  r = 5
end subroutine max_point

subroutine tensor_rank(r) &
    & bind(c,name="ol_f_tensor_rank_pptllj_nenexuxtdbx_1")
  ! Return the number maximal tensor rank
  implicit none
  integer, intent(out) :: r
  r = 1
end subroutine tensor_rank
#endif

subroutine reset_tensor_sum()
  use hol_initialisation_/**/REALKIND, only: hcl_allocation
  use ol_parameters_init_/**/REALKIND, only: init_hcl
  implicit none
  integer :: i

  do i = 1,208
    call init_hcl(T0sum(i))
  end do
  do i = 1,12
    call init_hcl(T1sum(i))
  end do

end subroutine reset_tensor_sum


subroutine scale_one_tsum(tsum, spow)
  use ol_parameters_decl_/**/REALKIND, only: scalefactor
  implicit none
  complex(REALKIND), intent(inout) :: tsum(:)
  integer, intent(in) :: spow ! rank 0 scale power
  real(REALKIND) :: sfinv, sfac
  integer :: sz
  sfinv = 1/scalefactor
  sfac = scalefactor**spow
  sz = size(tsum)
  tsum(1) = sfac*tsum(1)
  if (sz > 1) then ! rank 1
    sfac = sfac*sfinv
    tsum(2:5) = sfac*tsum(2:5)
  end if
  if (sz > 5) then ! rank 2
    sfac = sfac*sfinv
    tsum(6:15) = sfac*tsum(6:15)
  end if
  if (sz > 15) then ! rank 3
    sfac = sfac*sfinv
    tsum(16:35) = sfac*tsum(16:35)
  end if
  if (sz > 35) then ! rank 4
    sfac = sfac*sfinv
    tsum(36:70) = sfac*tsum(36:70)
  end if
  if (sz > 70) then ! rank 5
    sfac = sfac*sfinv
    tsum(71:126) = sfac*tsum(71:126)
  end if
  if (sz > 126) then ! rank 6
    sfac = sfac*sfinv
    tsum(127:210) = sfac*tsum(127:210)
  end if
  if (sz > 210) then ! rank 7
    sfac = sfac*sfinv
    tsum(211:330) = sfac*tsum(211:330)
  end if
end subroutine scale_one_tsum


subroutine scale_tensor_sum()
  implicit none
  call scale_one_tsum(T1sum(1)%cmp, 2)
  call scale_one_tsum(T1sum(2)%cmp, 2)
  call scale_one_tsum(T1sum(3)%cmp, 2)
  call scale_one_tsum(T1sum(4)%cmp, 2)
  call scale_one_tsum(T1sum(5)%cmp, 2)
  call scale_one_tsum(T1sum(6)%cmp, 2)
  call scale_one_tsum(T1sum(7)%cmp, 2)
  call scale_one_tsum(T1sum(8)%cmp, 2)
  call scale_one_tsum(T1sum(9)%cmp, 2)
  call scale_one_tsum(T1sum(10)%cmp, 2)
  call scale_one_tsum(T1sum(11)%cmp, 2)
  call scale_one_tsum(T1sum(12)%cmp, 2)
  call scale_one_tsum(T0sum(1)%cmp, 0)
  call scale_one_tsum(T0sum(2)%cmp, 0)
  call scale_one_tsum(T0sum(3)%cmp, 0)
  call scale_one_tsum(T0sum(4)%cmp, 0)
  call scale_one_tsum(T0sum(5)%cmp, 0)
  call scale_one_tsum(T0sum(6)%cmp, 0)
  call scale_one_tsum(T0sum(7)%cmp, 0)
  call scale_one_tsum(T0sum(8)%cmp, 0)
  call scale_one_tsum(T0sum(9)%cmp, 0)
  call scale_one_tsum(T0sum(10)%cmp, 0)
  call scale_one_tsum(T0sum(11)%cmp, 0)
  call scale_one_tsum(T0sum(12)%cmp, 0)
  call scale_one_tsum(T0sum(13)%cmp, 0)
  call scale_one_tsum(T0sum(14)%cmp, 0)
  call scale_one_tsum(T0sum(15)%cmp, 0)
  call scale_one_tsum(T0sum(16)%cmp, 0)
  call scale_one_tsum(T0sum(17)%cmp, 0)
  call scale_one_tsum(T0sum(18)%cmp, 0)
  call scale_one_tsum(T0sum(19)%cmp, 0)
  call scale_one_tsum(T0sum(20)%cmp, 0)
  call scale_one_tsum(T0sum(21)%cmp, 0)
  call scale_one_tsum(T0sum(22)%cmp, 0)
  call scale_one_tsum(T0sum(23)%cmp, 0)
  call scale_one_tsum(T0sum(24)%cmp, 0)
  call scale_one_tsum(T0sum(25)%cmp, 0)
  call scale_one_tsum(T0sum(26)%cmp, 0)
  call scale_one_tsum(T0sum(27)%cmp, 0)
  call scale_one_tsum(T0sum(28)%cmp, 0)
  call scale_one_tsum(T0sum(29)%cmp, 0)
  call scale_one_tsum(T0sum(30)%cmp, 0)
  call scale_one_tsum(T0sum(31)%cmp, 0)
  call scale_one_tsum(T0sum(32)%cmp, 0)
  call scale_one_tsum(T0sum(33)%cmp, 0)
  call scale_one_tsum(T0sum(34)%cmp, 0)
  call scale_one_tsum(T0sum(35)%cmp, 0)
  call scale_one_tsum(T0sum(36)%cmp, 0)
  call scale_one_tsum(T0sum(37)%cmp, 0)
  call scale_one_tsum(T0sum(38)%cmp, 0)
  call scale_one_tsum(T0sum(39)%cmp, 0)
  call scale_one_tsum(T0sum(40)%cmp, 0)
  call scale_one_tsum(T0sum(41)%cmp, 0)
  call scale_one_tsum(T0sum(42)%cmp, 0)
  call scale_one_tsum(T0sum(43)%cmp, 0)
  call scale_one_tsum(T0sum(44)%cmp, 0)
  call scale_one_tsum(T0sum(45)%cmp, 0)
  call scale_one_tsum(T0sum(46)%cmp, 0)
  call scale_one_tsum(T0sum(47)%cmp, 0)
  call scale_one_tsum(T0sum(48)%cmp, 0)
  call scale_one_tsum(T0sum(49)%cmp, 0)
  call scale_one_tsum(T0sum(50)%cmp, 0)
  call scale_one_tsum(T0sum(51)%cmp, 0)
  call scale_one_tsum(T0sum(52)%cmp, 0)
  call scale_one_tsum(T0sum(53)%cmp, 0)
  call scale_one_tsum(T0sum(54)%cmp, 0)
  call scale_one_tsum(T0sum(55)%cmp, 0)
  call scale_one_tsum(T0sum(56)%cmp, 0)
  call scale_one_tsum(T0sum(57)%cmp, -2)
  call scale_one_tsum(T0sum(58)%cmp, -2)
  call scale_one_tsum(T0sum(59)%cmp, -2)
  call scale_one_tsum(T0sum(60)%cmp, -2)
  call scale_one_tsum(T0sum(61)%cmp, -2)
  call scale_one_tsum(T0sum(62)%cmp, -2)
  call scale_one_tsum(T0sum(63)%cmp, -2)
  call scale_one_tsum(T0sum(64)%cmp, -2)
  call scale_one_tsum(T0sum(65)%cmp, -2)
  call scale_one_tsum(T0sum(66)%cmp, -2)
  call scale_one_tsum(T0sum(67)%cmp, -2)
  call scale_one_tsum(T0sum(68)%cmp, -2)
  call scale_one_tsum(T0sum(69)%cmp, -2)
  call scale_one_tsum(T0sum(70)%cmp, -2)
  call scale_one_tsum(T0sum(71)%cmp, -2)
  call scale_one_tsum(T0sum(72)%cmp, -2)
  call scale_one_tsum(T0sum(73)%cmp, -2)
  call scale_one_tsum(T0sum(74)%cmp, -2)
  call scale_one_tsum(T0sum(75)%cmp, -2)
  call scale_one_tsum(T0sum(76)%cmp, -2)
  call scale_one_tsum(T0sum(77)%cmp, -2)
  call scale_one_tsum(T0sum(78)%cmp, -2)
  call scale_one_tsum(T0sum(79)%cmp, -2)
  call scale_one_tsum(T0sum(80)%cmp, -2)
  call scale_one_tsum(T0sum(81)%cmp, -2)
  call scale_one_tsum(T0sum(82)%cmp, -2)
  call scale_one_tsum(T0sum(83)%cmp, -2)
  call scale_one_tsum(T0sum(84)%cmp, -2)
  call scale_one_tsum(T0sum(85)%cmp, -2)
  call scale_one_tsum(T0sum(86)%cmp, -2)
  call scale_one_tsum(T0sum(87)%cmp, -2)
  call scale_one_tsum(T0sum(88)%cmp, -2)
  call scale_one_tsum(T0sum(89)%cmp, -2)
  call scale_one_tsum(T0sum(90)%cmp, -2)
  call scale_one_tsum(T0sum(91)%cmp, -2)
  call scale_one_tsum(T0sum(92)%cmp, -2)
  call scale_one_tsum(T0sum(93)%cmp, -2)
  call scale_one_tsum(T0sum(94)%cmp, -2)
  call scale_one_tsum(T0sum(95)%cmp, -2)
  call scale_one_tsum(T0sum(96)%cmp, -2)
  call scale_one_tsum(T0sum(97)%cmp, -2)
  call scale_one_tsum(T0sum(98)%cmp, -2)
  call scale_one_tsum(T0sum(99)%cmp, -2)
  call scale_one_tsum(T0sum(100)%cmp, -2)
  call scale_one_tsum(T0sum(101)%cmp, -2)
  call scale_one_tsum(T0sum(102)%cmp, -2)
  call scale_one_tsum(T0sum(103)%cmp, -2)
  call scale_one_tsum(T0sum(104)%cmp, -2)
  call scale_one_tsum(T0sum(105)%cmp, -2)
  call scale_one_tsum(T0sum(106)%cmp, -2)
  call scale_one_tsum(T0sum(107)%cmp, -2)
  call scale_one_tsum(T0sum(108)%cmp, -2)
  call scale_one_tsum(T0sum(109)%cmp, -2)
  call scale_one_tsum(T0sum(110)%cmp, -2)
  call scale_one_tsum(T0sum(111)%cmp, -2)
  call scale_one_tsum(T0sum(112)%cmp, -2)
  call scale_one_tsum(T0sum(113)%cmp, -2)
  call scale_one_tsum(T0sum(114)%cmp, -2)
  call scale_one_tsum(T0sum(115)%cmp, -2)
  call scale_one_tsum(T0sum(116)%cmp, -2)
  call scale_one_tsum(T0sum(117)%cmp, -2)
  call scale_one_tsum(T0sum(118)%cmp, -2)
  call scale_one_tsum(T0sum(119)%cmp, -2)
  call scale_one_tsum(T0sum(120)%cmp, -2)
  call scale_one_tsum(T0sum(121)%cmp, -2)
  call scale_one_tsum(T0sum(122)%cmp, -2)
  call scale_one_tsum(T0sum(123)%cmp, -2)
  call scale_one_tsum(T0sum(124)%cmp, -2)
  call scale_one_tsum(T0sum(125)%cmp, -2)
  call scale_one_tsum(T0sum(126)%cmp, -2)
  call scale_one_tsum(T0sum(127)%cmp, -2)
  call scale_one_tsum(T0sum(128)%cmp, -2)
  call scale_one_tsum(T0sum(129)%cmp, -2)
  call scale_one_tsum(T0sum(130)%cmp, -2)
  call scale_one_tsum(T0sum(131)%cmp, -2)
  call scale_one_tsum(T0sum(132)%cmp, -2)
  call scale_one_tsum(T0sum(133)%cmp, -2)
  call scale_one_tsum(T0sum(134)%cmp, -2)
  call scale_one_tsum(T0sum(135)%cmp, -2)
  call scale_one_tsum(T0sum(136)%cmp, -2)
  call scale_one_tsum(T0sum(137)%cmp, -2)
  call scale_one_tsum(T0sum(138)%cmp, -2)
  call scale_one_tsum(T0sum(139)%cmp, -2)
  call scale_one_tsum(T0sum(140)%cmp, -2)
  call scale_one_tsum(T0sum(141)%cmp, -2)
  call scale_one_tsum(T0sum(142)%cmp, -2)
  call scale_one_tsum(T0sum(143)%cmp, -2)
  call scale_one_tsum(T0sum(144)%cmp, -2)
  call scale_one_tsum(T0sum(145)%cmp, -2)
  call scale_one_tsum(T0sum(146)%cmp, -2)
  call scale_one_tsum(T0sum(147)%cmp, -2)
  call scale_one_tsum(T0sum(148)%cmp, -2)
  call scale_one_tsum(T0sum(149)%cmp, -2)
  call scale_one_tsum(T0sum(150)%cmp, -2)
  call scale_one_tsum(T0sum(151)%cmp, -2)
  call scale_one_tsum(T0sum(152)%cmp, -4)
  call scale_one_tsum(T0sum(153)%cmp, -4)
  call scale_one_tsum(T0sum(154)%cmp, -4)
  call scale_one_tsum(T0sum(155)%cmp, -4)
  call scale_one_tsum(T0sum(156)%cmp, -4)
  call scale_one_tsum(T0sum(157)%cmp, -4)
  call scale_one_tsum(T0sum(158)%cmp, -4)
  call scale_one_tsum(T0sum(159)%cmp, -4)
  call scale_one_tsum(T0sum(160)%cmp, -4)
  call scale_one_tsum(T0sum(161)%cmp, -4)
  call scale_one_tsum(T0sum(162)%cmp, -4)
  call scale_one_tsum(T0sum(163)%cmp, -4)
  call scale_one_tsum(T0sum(164)%cmp, -4)
  call scale_one_tsum(T0sum(165)%cmp, -4)
  call scale_one_tsum(T0sum(166)%cmp, -4)
  call scale_one_tsum(T0sum(167)%cmp, -4)
  call scale_one_tsum(T0sum(168)%cmp, -4)
  call scale_one_tsum(T0sum(169)%cmp, -4)
  call scale_one_tsum(T0sum(170)%cmp, -4)
  call scale_one_tsum(T0sum(171)%cmp, -4)
  call scale_one_tsum(T0sum(172)%cmp, -4)
  call scale_one_tsum(T0sum(173)%cmp, -4)
  call scale_one_tsum(T0sum(174)%cmp, -4)
  call scale_one_tsum(T0sum(175)%cmp, -4)
  call scale_one_tsum(T0sum(176)%cmp, -4)
  call scale_one_tsum(T0sum(177)%cmp, -4)
  call scale_one_tsum(T0sum(178)%cmp, -4)
  call scale_one_tsum(T0sum(179)%cmp, -4)
  call scale_one_tsum(T0sum(180)%cmp, -4)
  call scale_one_tsum(T0sum(181)%cmp, -4)
  call scale_one_tsum(T0sum(182)%cmp, -4)
  call scale_one_tsum(T0sum(183)%cmp, -4)
  call scale_one_tsum(T0sum(184)%cmp, -4)
  call scale_one_tsum(T0sum(185)%cmp, -4)
  call scale_one_tsum(T0sum(186)%cmp, -4)
  call scale_one_tsum(T0sum(187)%cmp, -4)
  call scale_one_tsum(T0sum(188)%cmp, -4)
  call scale_one_tsum(T0sum(189)%cmp, -4)
  call scale_one_tsum(T0sum(190)%cmp, -4)
  call scale_one_tsum(T0sum(191)%cmp, -4)
  call scale_one_tsum(T0sum(192)%cmp, -4)
  call scale_one_tsum(T0sum(193)%cmp, -4)
  call scale_one_tsum(T0sum(194)%cmp, -4)
  call scale_one_tsum(T0sum(195)%cmp, -4)
  call scale_one_tsum(T0sum(196)%cmp, -4)
  call scale_one_tsum(T0sum(197)%cmp, -4)
  call scale_one_tsum(T0sum(198)%cmp, -4)
  call scale_one_tsum(T0sum(199)%cmp, -4)
  call scale_one_tsum(T0sum(200)%cmp, -4)
  call scale_one_tsum(T0sum(201)%cmp, -4)
  call scale_one_tsum(T0sum(202)%cmp, -4)
  call scale_one_tsum(T0sum(203)%cmp, -4)
  call scale_one_tsum(T0sum(204)%cmp, -4)
  call scale_one_tsum(T0sum(205)%cmp, -4)
  call scale_one_tsum(T0sum(206)%cmp, -4)
  call scale_one_tsum(T0sum(207)%cmp, -4)
  call scale_one_tsum(T0sum(208)%cmp, -4)

end subroutine scale_tensor_sum

! **********************************************************************
subroutine set_integral_masses_and_momenta()
! **********************************************************************

  use ol_parameters_decl_/**/REALKIND
  momenta_1 = [ 0, 0 ]
  momenta_2 = [ 32, 31 ]
  momenta_3 = [ 35, 28 ]
  momenta_4 = [ 36, 27 ]
  momenta_5 = [ 39, 24 ]
  momenta_6 = [ 40, 23 ]
  momenta_7 = [ 43, 20 ]
  momenta_8 = [ 44, 19 ]
  momenta_9 = [ 47, 16 ]
  momenta_10 = [ 48, 15 ]
  momenta_11 = [ 51, 12 ]
  momenta_12 = [ 52, 11 ]
  momenta_13 = [ 55, 8 ]
  momenta_14 = [ 56, 7 ]
  momenta_15 = [ 59, 4 ]
  momenta_16 = [ 60, 3 ]
  momenta_17 = [ 32, 3, 28 ]
  momenta_18 = [ 32, 4, 27 ]
  momenta_19 = [ 32, 7, 24 ]
  momenta_20 = [ 32, 8, 23 ]
  momenta_21 = [ 32, 11, 20 ]
  momenta_22 = [ 32, 12, 19 ]
  momenta_23 = [ 32, 15, 16 ]
  momenta_24 = [ 32, 19, 12 ]
  momenta_25 = [ 32, 20, 11 ]
  momenta_26 = [ 32, 23, 8 ]
  momenta_27 = [ 32, 27, 4 ]
  momenta_28 = [ 35, 4, 24 ]
  momenta_29 = [ 35, 8, 20 ]
  momenta_30 = [ 35, 12, 16 ]
  momenta_31 = [ 35, 16, 12 ]
  momenta_32 = [ 35, 20, 8 ]
  momenta_33 = [ 35, 24, 4 ]
  momenta_34 = [ 36, 3, 24 ]
  momenta_35 = [ 36, 11, 16 ]
  momenta_36 = [ 36, 16, 11 ]
  momenta_37 = [ 36, 19, 8 ]
  momenta_38 = [ 39, 8, 16 ]
  momenta_39 = [ 39, 16, 8 ]
  momenta_40 = [ 40, 3, 20 ]
  momenta_41 = [ 40, 4, 19 ]
  momenta_42 = [ 40, 7, 16 ]
  momenta_43 = [ 40, 19, 4 ]
  momenta_44 = [ 40, 20, 3 ]
  momenta_45 = [ 43, 4, 16 ]
  momenta_46 = [ 43, 16, 4 ]
  momenta_47 = [ 44, 3, 16 ]
  momenta_48 = [ 44, 16, 3 ]
  momenta_49 = [ 48, 3, 12 ]
  momenta_50 = [ 48, 8, 7 ]
  momenta_51 = [ 48, 11, 4 ]
  momenta_52 = [ 48, 12, 3 ]
  momenta_53 = [ 51, 4, 8 ]
  momenta_54 = [ 51, 8, 4 ]
  momenta_55 = [ 52, 3, 8 ]
  momenta_56 = [ 52, 8, 3 ]
  momenta_57 = [ 56, 3, 4 ]
  momenta_58 = [ 56, 4, 3 ]
  momenta_59 = [ 32, 3, 4, 24 ]
  momenta_60 = [ 32, 3, 8, 20 ]
  momenta_61 = [ 32, 3, 12, 16 ]
  momenta_62 = [ 32, 3, 16, 12 ]
  momenta_63 = [ 32, 3, 20, 8 ]
  momenta_64 = [ 32, 3, 24, 4 ]
  momenta_65 = [ 32, 4, 3, 24 ]
  momenta_66 = [ 32, 4, 16, 11 ]
  momenta_67 = [ 32, 4, 19, 8 ]
  momenta_68 = [ 32, 7, 16, 8 ]
  momenta_69 = [ 32, 8, 3, 20 ]
  momenta_70 = [ 32, 8, 4, 19 ]
  momenta_71 = [ 32, 8, 7, 16 ]
  momenta_72 = [ 32, 11, 4, 16 ]
  momenta_73 = [ 32, 11, 16, 4 ]
  momenta_74 = [ 32, 12, 3, 16 ]
  momenta_75 = [ 32, 19, 4, 8 ]
  momenta_76 = [ 32, 20, 3, 8 ]
  momenta_77 = [ 35, 4, 16, 8 ]
  momenta_78 = [ 35, 8, 4, 16 ]
  momenta_79 = [ 35, 8, 16, 4 ]
  momenta_80 = [ 35, 16, 4, 8 ]
  momenta_81 = [ 36, 3, 8, 16 ]
  momenta_82 = [ 36, 3, 16, 8 ]
  momenta_83 = [ 36, 16, 3, 8 ]
  momenta_84 = [ 40, 3, 4, 16 ]
  momenta_85 = [ 40, 3, 16, 4 ]
  momenta_86 = [ 40, 4, 3, 16 ]
  momenta_87 = [ 40, 4, 16, 3 ]
  momenta_88 = [ 48, 3, 8, 4 ]
  momenta_89 = [ 48, 8, 3, 4 ]
  momenta_90 = [ 48, 8, 4, 3 ]
  momenta_91 = [ 32, 3, 4, 16, 8 ]
  momenta_92 = [ 32, 3, 8, 4, 16 ]
  momenta_93 = [ 32, 3, 8, 16, 4 ]
  momenta_94 = [ 32, 3, 16, 4, 8 ]
  momenta_95 = [ 32, 4, 3, 16, 8 ]
  momenta_96 = [ 32, 4, 16, 3, 8 ]
  momenta_97 = [ 32, 8, 3, 4, 16 ]
  momenta_98 = [ 32, 8, 4, 3, 16 ]

  masses2_1 = [ 0, 0 ]
  masses2_2 = [ nMB, 0 ]
  masses2_3 = [ nMT, 0 ]
  masses2_4 = [ nMW, 0 ]
  masses2_5 = [ 0, nMB ]
  masses2_6 = [ nMB, nMB ]
  masses2_7 = [ nMT, nMB ]
  masses2_8 = [ nMW, nMB ]
  masses2_9 = [ 0, nMT ]
  masses2_10 = [ nMB, nMT ]
  masses2_11 = [ nMT, nMT ]
  masses2_12 = [ nMW, nMT ]
  masses2_13 = [ 0, nMW ]
  masses2_14 = [ nMB, nMW ]
  masses2_15 = [ nMT, nMW ]
  masses2_16 = [ nMW, nMW ]
  masses2_17 = [ 0, 0, 0 ]
  masses2_18 = [ nMB, 0, 0 ]
  masses2_19 = [ nMT, 0, 0 ]
  masses2_20 = [ nMW, 0, 0 ]
  masses2_21 = [ nMB, 0, nMT ]
  masses2_22 = [ nMT, 0, nMT ]
  masses2_23 = [ nMB, 0, nMW ]
  masses2_24 = [ nMW, 0, nMW ]
  masses2_25 = [ 0, nMB, 0 ]
  masses2_26 = [ 0, nMB, nMB ]
  masses2_27 = [ nMT, nMB, nMB ]
  masses2_28 = [ nMW, nMB, nMB ]
  masses2_29 = [ 0, nMB, nMT ]
  masses2_30 = [ 0, nMB, nMW ]
  masses2_31 = [ nMW, nMB, nMW ]
  masses2_32 = [ 0, nMT, 0 ]
  masses2_33 = [ nMW, nMT, 0 ]
  masses2_34 = [ 0, nMT, nMT ]
  masses2_35 = [ nMB, nMT, nMT ]
  masses2_36 = [ nMW, nMT, nMT ]
  masses2_37 = [ 0, nMW, 0 ]
  masses2_38 = [ nMT, nMW, 0 ]
  masses2_39 = [ 0, nMW, nMW ]
  masses2_40 = [ nMB, nMW, nMW ]
  masses2_41 = [ nMT, nMW, nMW ]
  masses2_42 = [ 0, 0, 0, 0 ]
  masses2_43 = [ nMB, 0, 0, 0 ]
  masses2_44 = [ nMT, 0, 0, 0 ]
  masses2_45 = [ nMW, 0, 0, 0 ]
  masses2_46 = [ 0, 0, 0, nMW ]
  masses2_47 = [ nMB, 0, 0, nMW ]
  masses2_48 = [ nMW, 0, 0, nMW ]
  masses2_49 = [ nMB, 0, nMT, nMT ]
  masses2_50 = [ 0, 0, nMW, nMW ]
  masses2_51 = [ nMB, 0, nMW, nMW ]
  masses2_52 = [ 0, nMB, 0, 0 ]
  masses2_53 = [ 0, nMB, nMB, 0 ]
  masses2_54 = [ 0, nMB, nMB, nMT ]
  masses2_55 = [ 0, nMB, nMB, nMW ]
  masses2_56 = [ 0, nMB, nMW, 0 ]
  masses2_57 = [ nMB, nMB, nMW, 0 ]
  masses2_58 = [ 0, nMB, nMW, nMW ]
  masses2_59 = [ 0, nMT, 0, 0 ]
  masses2_60 = [ nMT, nMT, 0, 0 ]
  masses2_61 = [ nMW, nMT, 0, 0 ]
  masses2_62 = [ 0, nMT, nMT, 0 ]
  masses2_63 = [ nMW, nMT, nMT, 0 ]
  masses2_64 = [ 0, nMW, 0, 0 ]
  masses2_65 = [ nMB, nMW, 0, 0 ]
  masses2_66 = [ nMT, nMW, 0, 0 ]
  masses2_67 = [ nMW, nMW, 0, 0 ]
  masses2_68 = [ 0, nMW, nMW, 0 ]
  masses2_69 = [ nMB, nMW, nMW, 0 ]
  masses2_70 = [ nMT, nMW, nMW, 0 ]
  masses2_71 = [ nMB, 0, 0, 0, nMW ]
  masses2_72 = [ nMB, 0, 0, nMW, nMW ]
  masses2_73 = [ 0, nMB, nMB, nMW, 0 ]
  masses2_74 = [ 0, nMB, nMW, 0, 0 ]
  masses2_75 = [ 0, nMB, nMW, nMW, 0 ]
  masses2_76 = [ nMW, nMT, 0, 0, 0 ]
  masses2_77 = [ nMW, nMT, nMT, 0, 0 ]
  masses2_78 = [ nMT, nMW, 0, 0, 0 ]
  masses2_79 = [ nMT, nMW, nMW, 0, 0 ]


end subroutine  set_integral_masses_and_momenta

! **********************************************************************
subroutine integrate_tensor_sum(M2out)
! **********************************************************************
  use ol_parameters_decl_/**/REALKIND ! only: ZERO, masses
#ifndef PRECISION_dp
  use ol_parameters_decl_/**/DREALKIND, only: a_switch
#endif
  use ol_parameters_init_/**/REALKIND, only: init_met, add_met, met_to_real
  use ol_loop_routines_/**/REALKIND, only: TI_call_OL
  implicit none
  real(REALKIND), intent(out) :: M2out
  type(met) :: M2
  call init_met(M2)

sbarray_1 = [1, 2, 3, 4, 5]
sbarray_2 = [6, 7, 8, 9, 10]
sbarray_3 = [11, 12, 13, 14, 15]
sbarray_4 = [16, 17, 18, 19, 20]
sbarray_5 = [21, 22, 23, 24, 25]
sbarray_6 = [26, 27, 28, 9, 29]
sbarray_7 = [30, 31, 32, 14, 33]
sbarray_8 = [34, 12, 23, 35, 36]
sbarray_9 = [37, 38, 39, 40, 41]
sbarray_10 = [42, 43, 39, 44, 45]
sbarray_11 = [46, 47, 3, 48, 49]
sbarray_12 = [50, 43, 51, 52, 53]


#ifdef LOOPSQUARED
  if (a_switch == 1 .or. a_switch == 7) then
#endif
  call TI_call_OL(0,0, momenta_60, masses2_63, T0sum(1), M2,[9], ScalarBoxes(:))
  call TI_call_OL(0,0, momenta_60, masses2_55, T0sum(2), M2,[14], ScalarBoxes(:))
  call TI_call_OL(0,0, momenta_70, masses2_61, T0sum(3), M2,[19], ScalarBoxes(:))
  call TI_call_OL(0,0, momenta_70, masses2_56, T0sum(4), M2,[24], ScalarBoxes(:))
  call TI_call_OL(0,0, momenta_69, masses2_58, T0sum(5), M2,[35], ScalarBoxes(:))
  call TI_call_OL(0,0, momenta_85, masses2_68, T0sum(6), M2,[41], ScalarBoxes(:))
  call TI_call_OL(0,0, momenta_62, masses2_70, T0sum(7), M2,[40], ScalarBoxes(:))
  call TI_call_OL(0,0, momenta_87, masses2_48, T0sum(8), M2,[5], ScalarBoxes(:))
  call TI_call_OL(0,0, momenta_66, masses2_47, T0sum(9), M2,[4], ScalarBoxes(:))
  call TI_call_OL(0,0, momenta_84, masses2_68, T0sum(10), M2,[34], ScalarBoxes(:))
  call TI_call_OL(0,0, momenta_59, masses2_70, T0sum(11), M2,[44], ScalarBoxes(:))
  call TI_call_OL(0,0, momenta_86, masses2_45, T0sum(12), M2,[16], ScalarBoxes(:))
  call TI_call_OL(0,0, momenta_65, masses2_43, T0sum(13), M2,[48], ScalarBoxes(:))
  call TI_call_OL(0,0, momenta_86, masses2_64, T0sum(14), M2,[21], ScalarBoxes(:))
  call TI_call_OL(0,0, momenta_65, masses2_66, T0sum(15), M2,[52], ScalarBoxes(:))
  call TI_call_OL(0,0, momenta_83, masses2_51, T0sum(16), M2,[1], ScalarBoxes(:))
  call TI_call_OL(0,0, momenta_76, masses2_51, T0sum(17), M2,[2], ScalarBoxes(:))
  call TI_call_OL(0,0, momenta_67, masses2_47, T0sum(18), M2,[3], ScalarBoxes(:))
  call TI_call_OL(0,0, momenta_88, masses2_62, T0sum(19), M2,[10], ScalarBoxes(:))
  call TI_call_OL(0,0, momenta_78, masses2_61, T0sum(20), M2,[6], ScalarBoxes(:))
  call TI_call_OL(0,0, momenta_72, masses2_61, T0sum(21), M2,[7], ScalarBoxes(:))
  call TI_call_OL(0,0, momenta_61, masses2_63, T0sum(22), M2,[8], ScalarBoxes(:))
  call TI_call_OL(0,0, momenta_88, masses2_55, T0sum(23), M2,[15], ScalarBoxes(:))
  call TI_call_OL(0,0, momenta_78, masses2_56, T0sum(24), M2,[11], ScalarBoxes(:))
  call TI_call_OL(0,0, momenta_72, masses2_56, T0sum(25), M2,[12], ScalarBoxes(:))
  call TI_call_OL(0,0, momenta_61, masses2_53, T0sum(26), M2,[13], ScalarBoxes(:))
  call TI_call_OL(0,0, momenta_90, masses2_59, T0sum(27), M2,[20], ScalarBoxes(:))
  call TI_call_OL(0,0, momenta_74, masses2_61, T0sum(28), M2,[17], ScalarBoxes(:))
  call TI_call_OL(0,0, momenta_71, masses2_61, T0sum(29), M2,[18], ScalarBoxes(:))
  call TI_call_OL(0,0, momenta_90, masses2_56, T0sum(30), M2,[25], ScalarBoxes(:))
  call TI_call_OL(0,0, momenta_74, masses2_52, T0sum(31), M2,[22], ScalarBoxes(:))
  call TI_call_OL(0,0, momenta_71, masses2_56, T0sum(32), M2,[23], ScalarBoxes(:))
  call TI_call_OL(0,0, momenta_81, masses2_62, T0sum(33), M2,[29], ScalarBoxes(:))
  call TI_call_OL(0,0, momenta_79, masses2_61, T0sum(34), M2,[26], ScalarBoxes(:))
  call TI_call_OL(0,0, momenta_73, masses2_61, T0sum(35), M2,[27], ScalarBoxes(:))
  call TI_call_OL(0,0, momenta_64, masses2_63, T0sum(36), M2,[28], ScalarBoxes(:))
  call TI_call_OL(0,0, momenta_81, masses2_55, T0sum(37), M2,[33], ScalarBoxes(:))
  call TI_call_OL(0,0, momenta_79, masses2_56, T0sum(38), M2,[30], ScalarBoxes(:))
  call TI_call_OL(0,0, momenta_73, masses2_56, T0sum(39), M2,[31], ScalarBoxes(:))
  call TI_call_OL(0,0, momenta_64, masses2_53, T0sum(40), M2,[32], ScalarBoxes(:))
  call TI_call_OL(0,0, momenta_89, masses2_58, T0sum(41), M2,[36], ScalarBoxes(:))
  call TI_call_OL(0,0, momenta_80, masses2_66, T0sum(42), M2,[37], ScalarBoxes(:))
  call TI_call_OL(0,0, momenta_75, masses2_66, T0sum(43), M2,[38], ScalarBoxes(:))
  call TI_call_OL(0,0, momenta_63, masses2_70, T0sum(44), M2,[39], ScalarBoxes(:))
  call TI_call_OL(0,0, momenta_77, masses2_66, T0sum(45), M2,[42], ScalarBoxes(:))
  call TI_call_OL(0,0, momenta_68, masses2_66, T0sum(46), M2,[43], ScalarBoxes(:))
  call TI_call_OL(0,0, momenta_82, masses2_47, T0sum(47), M2,[46], ScalarBoxes(:))
  call TI_call_OL(0,0, momenta_68, masses2_47, T0sum(48), M2,[47], ScalarBoxes(:))
  call TI_call_OL(0,0, momenta_82, masses2_44, T0sum(49), M2,[50], ScalarBoxes(:))
  call TI_call_OL(0,0, momenta_67, masses2_66, T0sum(50), M2,[51], ScalarBoxes(:))
  call TI_call_OL(0,0, momenta_66, masses2_66, T0sum(51), M2,[27], ScalarBoxes(:))
  call TI_call_OL(0,0, momenta_77, masses2_47, T0sum(52), M2,[30], ScalarBoxes(:))
  call TI_call_OL(0,0, momenta_63, masses2_54, T0sum(53), M2)
  call TI_call_OL(0,0, momenta_69, masses2_49, T0sum(54), M2)
  call TI_call_OL(0,0, momenta_84, masses2_42, T0sum(55), M2)
  call TI_call_OL(0,0, momenta_85, masses2_42, T0sum(56), M2)
  call TI_call_OL(0,0, momenta_17, masses2_26, T0sum(57), M2)
  call TI_call_OL(0,0, momenta_56, masses2_22, T0sum(58), M2)
  call TI_call_OL(0,0, momenta_20, masses2_21, T0sum(59), M2)
  call TI_call_OL(0,0, momenta_57, masses2_17, T0sum(60), M2)
  call TI_call_OL(0,0, momenta_40, masses2_17, T0sum(61), M2)
  call TI_call_OL(0,0, momenta_47, masses2_17, T0sum(62), M2)
  call TI_call_OL(0,0, momenta_55, masses2_34, T0sum(63), M2)
  call TI_call_OL(0,0, momenta_29, masses2_33, T0sum(64), M2)
  call TI_call_OL(0,0, momenta_21, masses2_33, T0sum(65), M2)
  call TI_call_OL(0,0, momenta_17, masses2_36, T0sum(66), M2)
  call TI_call_OL(0,0, momenta_55, masses2_28, T0sum(67), M2)
  call TI_call_OL(0,0, momenta_29, masses2_30, T0sum(68), M2)
  call TI_call_OL(0,0, momenta_21, masses2_30, T0sum(69), M2)
  call TI_call_OL(0,0, momenta_54, masses2_32, T0sum(70), M2)
  call TI_call_OL(0,0, momenta_41, masses2_20, T0sum(71), M2)
  call TI_call_OL(0,0, momenta_22, masses2_33, T0sum(72), M2)
  call TI_call_OL(0,0, momenta_20, masses2_33, T0sum(73), M2)
  call TI_call_OL(0,0, momenta_54, masses2_30, T0sum(74), M2)
  call TI_call_OL(0,0, momenta_41, masses2_37, T0sum(75), M2)
  call TI_call_OL(0,0, momenta_22, masses2_25, T0sum(76), M2)
  call TI_call_OL(0,0, momenta_20, masses2_30, T0sum(77), M2)
  call TI_call_OL(0,0, momenta_56, masses2_31, T0sum(78), M2)
  call TI_call_OL(0,0, momenta_40, masses2_39, T0sum(79), M2)
  call TI_call_OL(0,0, momenta_47, masses2_39, T0sum(80), M2)
  call TI_call_OL(0,0, momenta_46, masses2_37, T0sum(81), M2)
  call TI_call_OL(0,0, momenta_43, masses2_37, T0sum(82), M2)
  call TI_call_OL(0,0, momenta_31, masses2_38, T0sum(83), M2)
  call TI_call_OL(0,0, momenta_24, masses2_38, T0sum(84), M2)
  call TI_call_OL(0,0, momenta_17, masses2_41, T0sum(85), M2)
  call TI_call_OL(0,0, momenta_45, masses2_20, T0sum(86), M2)
  call TI_call_OL(0,0, momenta_48, masses2_24, T0sum(87), M2)
  call TI_call_OL(0,0, momenta_44, masses2_24, T0sum(88), M2)
  call TI_call_OL(0,0, momenta_36, masses2_23, T0sum(89), M2)
  call TI_call_OL(0,0, momenta_25, masses2_23, T0sum(90), M2)
  call TI_call_OL(0,0, momenta_18, masses2_18, T0sum(91), M2)
  call TI_call_OL(0,0, momenta_57, masses2_39, T0sum(92), M2)
  call TI_call_OL(0,0, momenta_45, masses2_37, T0sum(93), M2)
  call TI_call_OL(0,0, momenta_42, masses2_37, T0sum(94), M2)
  call TI_call_OL(0,0, momenta_28, masses2_38, T0sum(95), M2)
  call TI_call_OL(0,0, momenta_19, masses2_38, T0sum(96), M2)
  call TI_call_OL(0,0, momenta_58, masses2_17, T0sum(97), M2)
  call TI_call_OL(0,0, momenta_47, masses2_20, T0sum(98), M2)
  call TI_call_OL(0,0, momenta_42, masses2_20, T0sum(99), M2)
  call TI_call_OL(0,0, momenta_34, masses2_18, T0sum(100), M2)
  call TI_call_OL(0,0, momenta_19, masses2_18, T0sum(101), M2)
  call TI_call_OL(0,0, momenta_58, masses2_37, T0sum(102), M2)
  call TI_call_OL(0,0, momenta_34, masses2_19, T0sum(103), M2)
  call TI_call_OL(0,0, momenta_18, masses2_38, T0sum(104), M2)
  call TI_call_OL(0,0, momenta_55, masses2_40, T0sum(105), M2)
  call TI_call_OL(0,0, momenta_37, masses2_23, T0sum(106), M2)
  call TI_call_OL(0,0, momenta_26, masses2_23, T0sum(107), M2)
  call TI_call_OL(0,0, momenta_51, masses2_32, T0sum(108), M2)
  call TI_call_OL(0,0, momenta_49, masses2_34, T0sum(109), M2)
  call TI_call_OL(0,0, momenta_30, masses2_33, T0sum(110), M2)
  call TI_call_OL(0,0, momenta_23, masses2_33, T0sum(111), M2)
  call TI_call_OL(0,0, momenta_51, masses2_30, T0sum(112), M2)
  call TI_call_OL(0,0, momenta_49, masses2_26, T0sum(113), M2)
  call TI_call_OL(0,0, momenta_30, masses2_25, T0sum(114), M2)
  call TI_call_OL(0,0, momenta_23, masses2_25, T0sum(115), M2)
  call TI_call_OL(0,0, momenta_52, masses2_32, T0sum(116), M2)
  call TI_call_OL(0,0, momenta_50, masses2_32, T0sum(117), M2)
  call TI_call_OL(0,0, momenta_52, masses2_25, T0sum(118), M2)
  call TI_call_OL(0,0, momenta_50, masses2_30, T0sum(119), M2)
  call TI_call_OL(0,0, momenta_38, masses2_32, T0sum(120), M2)
  call TI_call_OL(0,0, momenta_35, masses2_32, T0sum(121), M2)
  call TI_call_OL(0,0, momenta_34, masses2_34, T0sum(122), M2)
  call TI_call_OL(0,0, momenta_46, masses2_20, T0sum(123), M2)
  call TI_call_OL(0,0, momenta_33, masses2_33, T0sum(124), M2)
  call TI_call_OL(0,0, momenta_27, masses2_33, T0sum(125), M2)
  call TI_call_OL(0,0, momenta_38, masses2_30, T0sum(126), M2)
  call TI_call_OL(0,0, momenta_35, masses2_30, T0sum(127), M2)
  call TI_call_OL(0,0, momenta_34, masses2_26, T0sum(128), M2)
  call TI_call_OL(0,0, momenta_33, masses2_25, T0sum(129), M2)
  call TI_call_OL(0,0, momenta_27, masses2_25, T0sum(130), M2)
  call TI_call_OL(0,0, momenta_53, masses2_19, T0sum(131), M2)
  call TI_call_OL(0,0, momenta_32, masses2_38, T0sum(132), M2)
  call TI_call_OL(0,0, momenta_26, masses2_38, T0sum(133), M2)
  call TI_call_OL(0,0, momenta_39, masses2_19, T0sum(134), M2)
  call TI_call_OL(0,0, momenta_39, masses2_23, T0sum(135), M2)
  call TI_call_OL(0,0, momenta_37, masses2_19, T0sum(136), M2)
  call TI_call_OL(0,0, momenta_36, masses2_19, T0sum(137), M2)
  call TI_call_OL(0,0, momenta_25, masses2_38, T0sum(138), M2)
  call TI_call_OL(0,0, momenta_32, masses2_23, T0sum(139), M2)
  call TI_call_OL(0,0, momenta_28, masses2_18, T0sum(140), M2)
  call TI_call_OL(0,0, momenta_40, masses2_27, T0sum(141), M2)
  call TI_call_OL(0,0, momenta_32, masses2_29, T0sum(142), M2)
  call TI_call_OL(0,0, momenta_26, masses2_29, T0sum(143), M2)
  call TI_call_OL(0,0, momenta_40, masses2_35, T0sum(144), M2)
  call TI_call_OL(0,0, momenta_21, masses2_21, T0sum(145), M2)
  call TI_call_OL(0,0, momenta_45, masses2_17, T0sum(146), M2)
  call TI_call_OL(0,0, momenta_42, masses2_17, T0sum(147), M2)
  call TI_call_OL(0,0, momenta_46, masses2_17, T0sum(148), M2)
  call TI_call_OL(0,0, momenta_43, masses2_17, T0sum(149), M2)
  call TI_call_OL(0,0, momenta_29, masses2_21, T0sum(150), M2)
  call TI_call_OL(0,0, momenta_41, masses2_17, T0sum(151), M2)
  call TI_call_OL(0,0, momenta_16, masses2_6, T0sum(152), M2)
  call TI_call_OL(0,0, momenta_3, masses2_5, T0sum(153), M2)
  call TI_call_OL(0,0, momenta_1, masses2_2, T0sum(154), M2)
  call TI_call_OL(0,0, momenta_2, masses2_5, T0sum(155), M2)
  call TI_call_OL(0,0, momenta_13, masses2_3, T0sum(156), M2)
  call TI_call_OL(0,0, momenta_16, masses2_11, T0sum(157), M2)
  call TI_call_OL(0,0, momenta_12, masses2_3, T0sum(158), M2)
  call TI_call_OL(0,0, momenta_1, masses2_3, T0sum(159), M2)
  call TI_call_OL(0,0, momenta_6, masses2_10, T0sum(160), M2)
  call TI_call_OL(0,0, momenta_2, masses2_2, T0sum(161), M2)
  call TI_call_OL(0,0, momenta_16, masses2_1, T0sum(162), M2)
  call TI_call_OL(0,0, momenta_15, masses2_1, T0sum(163), M2)
  call TI_call_OL(0,0, momenta_14, masses2_1, T0sum(164), M2)
  call TI_call_OL(0,0, momenta_7, masses2_1, T0sum(165), M2)
  call TI_call_OL(0,0, momenta_6, masses2_1, T0sum(166), M2)
  call TI_call_OL(0,0, momenta_9, masses2_1, T0sum(167), M2)
  call TI_call_OL(0,0, momenta_8, masses2_1, T0sum(168), M2)
  call TI_call_OL(0,0, momenta_13, masses2_9, T0sum(169), M2)
  call TI_call_OL(0,0, momenta_12, masses2_9, T0sum(170), M2)
  call TI_call_OL(0,0, momenta_7, masses2_7, T0sum(171), M2)
  call TI_call_OL(0,0, momenta_6, masses2_7, T0sum(172), M2)
  call TI_call_OL(0,0, momenta_7, masses2_10, T0sum(173), M2)
  call TI_call_OL(0,0, momenta_3, masses2_2, T0sum(174), M2)
  call TI_call_OL(0,0, momenta_7, masses2_4, T0sum(175), M2)
  call TI_call_OL(0,0, momenta_3, masses2_12, T0sum(176), M2)
  call TI_call_OL(0,0, momenta_1, masses2_4, T0sum(177), M2)
  call TI_call_OL(0,0, momenta_2, masses2_12, T0sum(178), M2)
  call TI_call_OL(0,0, momenta_13, masses2_8, T0sum(179), M2)
  call TI_call_OL(0,0, momenta_12, masses2_8, T0sum(180), M2)
  call TI_call_OL(0,0, momenta_7, masses2_13, T0sum(181), M2)
  call TI_call_OL(0,0, momenta_11, masses2_9, T0sum(182), M2)
  call TI_call_OL(0,0, momenta_8, masses2_4, T0sum(183), M2)
  call TI_call_OL(0,0, momenta_6, masses2_4, T0sum(184), M2)
  call TI_call_OL(0,0, momenta_15, masses2_13, T0sum(185), M2)
  call TI_call_OL(0,0, momenta_11, masses2_5, T0sum(186), M2)
  call TI_call_OL(0,0, momenta_6, masses2_13, T0sum(187), M2)
  call TI_call_OL(0,0, momenta_16, masses2_16, T0sum(188), M2)
  call TI_call_OL(0,0, momenta_9, masses2_13, T0sum(189), M2)
  call TI_call_OL(0,0, momenta_8, masses2_13, T0sum(190), M2)
  call TI_call_OL(0,0, momenta_11, masses2_3, T0sum(191), M2)
  call TI_call_OL(0,0, momenta_3, masses2_15, T0sum(192), M2)
  call TI_call_OL(0,0, momenta_2, masses2_15, T0sum(193), M2)
  call TI_call_OL(0,0, momenta_9, masses2_4, T0sum(194), M2)
  call TI_call_OL(0,0, momenta_12, masses2_14, T0sum(195), M2)
  call TI_call_OL(0,0, momenta_4, masses2_2, T0sum(196), M2)
  call TI_call_OL(0,0, momenta_14, masses2_13, T0sum(197), M2)
  call TI_call_OL(0,0, momenta_5, masses2_3, T0sum(198), M2)
  call TI_call_OL(0,0, momenta_5, masses2_2, T0sum(199), M2)
  call TI_call_OL(0,0, momenta_4, masses2_3, T0sum(200), M2)
  call TI_call_OL(0,0, momenta_13, masses2_14, T0sum(201), M2)
  call TI_call_OL(0,0, momenta_10, masses2_9, T0sum(202), M2)
  call TI_call_OL(0,0, momenta_10, masses2_5, T0sum(203), M2)
  call TI_call_OL(0,0, momenta_5, masses2_9, T0sum(204), M2)
  call TI_call_OL(0,0, momenta_4, masses2_9, T0sum(205), M2)
  call TI_call_OL(0,0, momenta_15, masses2_4, T0sum(206), M2)
  call TI_call_OL(0,0, momenta_5, masses2_5, T0sum(207), M2)
  call TI_call_OL(0,0, momenta_4, masses2_5, T0sum(208), M2)

  call TI_call_OL(0,1, momenta_96, masses2_72, T1sum(1), M2,sbarray_1, ScalarBoxes(:))
  call TI_call_OL(0,1, momenta_92, masses2_77, T1sum(2), M2,sbarray_2, ScalarBoxes(:))
  call TI_call_OL(0,1, momenta_92, masses2_73, T1sum(3), M2,sbarray_3, ScalarBoxes(:))
  call TI_call_OL(0,1, momenta_98, masses2_76, T1sum(4), M2,sbarray_4, ScalarBoxes(:))
  call TI_call_OL(0,1, momenta_98, masses2_74, T1sum(5), M2,sbarray_5, ScalarBoxes(:))
  call TI_call_OL(0,1, momenta_93, masses2_77, T1sum(6), M2,sbarray_6, ScalarBoxes(:))
  call TI_call_OL(0,1, momenta_93, masses2_73, T1sum(7), M2,sbarray_7, ScalarBoxes(:))
  call TI_call_OL(0,1, momenta_97, masses2_75, T1sum(8), M2,sbarray_8, ScalarBoxes(:))
  call TI_call_OL(0,1, momenta_94, masses2_79, T1sum(9), M2,sbarray_9, ScalarBoxes(:))
  call TI_call_OL(0,1, momenta_91, masses2_79, T1sum(10), M2,sbarray_10, ScalarBoxes(:))
  call TI_call_OL(0,1, momenta_95, masses2_71, T1sum(11), M2,sbarray_11, ScalarBoxes(:))
  call TI_call_OL(0,1, momenta_95, masses2_78, T1sum(12), M2,sbarray_12, ScalarBoxes(:))

  call add_met(M2,M2L1R1)

#ifdef LOOPSQUARED
  end if
#endif

  call met_to_real(M2out,M2)

#ifdef PRECISION_dp
  call HOL_memory_deallocation_/**/REALKIND(1)
  call HCL_memory_deallocation_/**/REALKIND(1)
#endif

end subroutine integrate_tensor_sum

end module ol_tensor_sum_storage_pptllj_nenexuxtdbx_1_/**/REALKIND
