
module ol_colourmatrix_pptllj_nenexutxdxb_1_/**/REALKIND
  use KIND_TYPES, only: REALKIND
  implicit none
  logical, save           :: colmat_not_initialised = .true.
  complex(REALKIND), save :: K1(1,1), K2(1,1), KL(1,2), Cas(6)
  contains
  subroutine colourmatrix_init
    use ol_parameters_decl_/**/REALKIND, only: CI
    implicit none
    colmat_not_initialised = .false.
    ! colour matrix

  K1(1,:) = [ 9]

  K2(1,:) = [ 9]

  KL(1,:) = [ 9, 3]
  Cas = 0
  end subroutine colourmatrix_init
end module ol_colourmatrix_pptllj_nenexutxdxb_1_/**/REALKIND



module ol_forced_parameters_pptllj_nenexutxdxb_1_/**/REALKIND
  implicit none
  contains
  subroutine check_forced_parameters
    use ol_parameters_decl_/**/REALKIND
    use ol_loop_parameters_decl_/**/REALKIND
#ifndef PRECISION_dp
    use ol_loop_parameters_decl_/**/DREALKIND, only: LeadingColour, nc, nf, CKMORDER
#endif
    implicit none
    logical, save :: checks_not_written = .true.

    if (checks_not_written) then
    ! e.g.
    ! if (ME /= 0) write(*,101) 'ME = 0'
  if (CKMORDER /= 0) write(*,101) 'CKMORDER = 0'
  if (nc /= 3) write(*,101) 'nc = 3'
  if (nf /= 6) write(*,101) 'nf = 6'
  if (MU /= 0) write(*,101) 'MU = 0'
  if (MD /= 0) write(*,101) 'MD = 0'
  if (MS /= 0) write(*,101) 'MS = 0'
  if (MC /= 0) write(*,101) 'MC = 0'
  if (LeadingColour /= 0) write(*,101) 'LeadingColour = 0'
  if (wMT /= 0) write(*,101) 'wMT = 0'
  if (wMB /= 0) write(*,101) 'wMB = 0'


    checks_not_written = .false.
    end if

    101 format('[OpenLoops] === WARNING ===',/,'[OpenLoops] code was generated with ',A,/,'[OpenLoops] ===============')
  end subroutine check_forced_parameters
end module ol_forced_parameters_pptllj_nenexutxdxb_1_/**/REALKIND
! **********************************************************************
module ol_loop_storage_pptllj_nenexutxdxb_1_/**/REALKIND
! **********************************************************************
  use KIND_TYPES, only: REALKIND, intkind1, intkind2
  use ol_data_types_/**/REALKIND, only: wfun, Hpolcont

#ifdef PRECISION_dp
  integer(intkind1), save :: ntry = 1, ntryL = 1
  integer(intkind1), save :: p_switch = 0 ! switch for dp or qp. Used for memory allocation of the OL types
  ! the following are flags for memory allocation of the hol coefficients in dp or qp
  logical, save :: dp_not_alloc = .TRUE., qp_not_alloc = .TRUE.
  integer(intkind2), parameter :: nheltot = 64 ! number of helicity configurations
  integer(intkind2), save :: nhel = 64 ! number of non-vanishing helicity configurations (adapted at runtime)
  integer(intkind2), save :: Hel(64) ! physical helicity states
#endif

  complex(REALKIND), save :: den(49)

  ! external wave functions ex1(h1),... for h<n> helicities
  type(wfun) :: ex1(2), ex2(2), ex3(2), ex4(2), ex5(2), ex6(2)

  ! wf<h>(h,n) n wave functions with h helicity configurations
  type(wfun) :: wf4(4,8), wf8(8,51), wf16(16,16), wf64(64,40)

  ! diagram prefactors
  integer,           save :: fac_status_loop1 = -1, fac_status_loop2 = -1
  complex(REALKIND), save :: f(28), c(11)

  !Vector in helicity and colour space for Born-Loop interference
  type(Hpolcont),   save :: M0_col1_helarray(2,64), M0M1_hel_cc(2,64,22)
  complex(REALKIND), save :: M2ctcc(22)

end module ol_loop_storage_pptllj_nenexutxdxb_1_/**/REALKIND






! **********************************************************************
module ol_loop_pptllj_nenexutxdxb_1_/**/REALKIND
! **********************************************************************
  use KIND_TYPES, only: REALKIND, DREALKIND, intkind1, intkind2
  use ol_data_types_/**/REALKIND, only: wfun, Hpolcont
  use ol_loop_storage_pptllj_nenexutxdxb_1_/**/REALKIND
  implicit none

!*********************************************************************************
  contains

! **********************************************************************
subroutine fac_init_loop()
! Writes diagram prefactors to 'f', rsp. 'c'
! **********************************************************************
  use ol_parameters_decl_/**/REALKIND
  use ol_loop_parameters_decl_/**/REALKIND
  use ol_init, only: set_parameter, tree_parameters_flush, parameters_flush
#ifndef PRECISION_dp
  use ol_loop_parameters_decl_/**/DREALKIND, only: SwF, SwB
!  use ol_loop_parameters_decl_/**/DREALKIND, only: DOI
#endif
  implicit none
  call set_parameter("ew_renorm", 0)
  if (parameters_status == 0) call tree_parameters_flush()
  if (loop_parameters_status == 0) call parameters_flush()
  fac_status_loop1 = parameters_status
  fac_status_loop2 = loop_parameters_status
  ! factors of the diagrams
    f( 1) = -(CI*countertermnorm*ctSqq*eQED**4*gQCD**2*(cw - sw)*(cw + sw))/(4._/**/REALKIND*cw*MW**2*sw**3)
    f( 2) = (CI*eQED**4)/(4._/**/REALKIND*sw**4)
    f( 3) = (CI*countertermnorm*ctVbt*eQED**4*gQCD**2)/(4._/**/REALKIND*sw**4)
    f( 4) = (CI*countertermnorm*ctVqq*eQED**4*gQCD**2)/(4._/**/REALKIND*sw**4)
    f( 5) = (CI*countertermnorm*ctSqq*eQED**4*gQCD**2*ME**2)/(4._/**/REALKIND*MW**4*sw**4)
    f( 6) = (CI*eQED**4*ME)/(4._/**/REALKIND*MW**2*sw**4)
    f( 7) = (CI*countertermnorm*eQED**4*gQCD**2*ME)/(4._/**/REALKIND*MW**2*sw**4)
    f( 8) = (CI*countertermnorm*ctSqq*eQED**4*gQCD**2*ME)/(4._/**/REALKIND*MW**2*sw**4)
    f( 9) = (CI*countertermnorm*ctVqq*eQED**4*gQCD**2*ME)/(4._/**/REALKIND*MW**2*sw**4)
    f(10) = (CI*cw*eQED**4)/(2._/**/REALKIND*sw**3)
    f(11) = (CI*countertermnorm*ctVbt*cw*eQED**4*gQCD**2)/(2._/**/REALKIND*sw**3)
    f(12) = (CI*countertermnorm*ctVqq*cw*eQED**4*gQCD**2)/(2._/**/REALKIND*sw**3)
    f(13) = (CI*eQED**4)/(2._/**/REALKIND*sw**2)
    f(14) = (CI*countertermnorm*eQED**4*gQCD**2)/(2._/**/REALKIND*sw**2)
    f(15) = (CI*countertermnorm*ctVbb*eQED**4*gQCD**2)/(2._/**/REALKIND*sw**2)
    f(16) = (CI*countertermnorm*ctVbt*eQED**4*gQCD**2)/(2._/**/REALKIND*sw**2)
    f(17) = (CI*countertermnorm*ctVqq*eQED**4*gQCD**2)/(2._/**/REALKIND*sw**2)
    f(18) = (CI*countertermnorm*ctVtt*eQED**4*gQCD**2)/(2._/**/REALKIND*sw**2)
    f(19) = (CI*countertermnorm*ctSqq*eQED**4*gQCD**2)/(2._/**/REALKIND*MW**2*sw**2)
    f(20) = (CI*eQED**4)/(2._/**/REALKIND*cw*sw)
    f(21) = (CI*countertermnorm*eQED**4*gQCD**2)/(2._/**/REALKIND*cw*sw)
    f(22) = (CI*countertermnorm*ctSqq*eQED**4*gQCD**2)/(2._/**/REALKIND*cw*sw)
    f(23) = (CI*countertermnorm*ctVqq*eQED**4*gQCD**2)/(2._/**/REALKIND*cw*sw)
    f(24) = (eQED**4*gQCD**2*integralnorm*SwB)/(sw**4*4._/**/REALKIND)
    f(25) = (eQED**4*gQCD**2*integralnorm*ME*SwB)/(MW**2*sw**4*4._/**/REALKIND)
    f(26) = (cw*eQED**4*gQCD**2*integralnorm*SwB)/(sw**3*2._/**/REALKIND)
    f(27) = (eQED**4*gQCD**2*integralnorm*SwB)/(sw**2*2._/**/REALKIND)
    f(28) = (eQED**4*gQCD**2*integralnorm*SwB)/(cw*sw*2._/**/REALKIND)

  c = [ 8*f(24), 8*f(25), f(26), 3*f(26), 8*f(26), f(27), 3*f(27), 8*f(27), f(28), 3*f(28), 8*f(28) ]
  c = (1._/**/REALKIND / 6) * c
end subroutine fac_init_loop

subroutine denominators()
  use ol_parameters_decl_/**/REALKIND ! masses
  use ol_momenta_decl_/**/REALKIND, only: L
  implicit none
  ! propagators
  den(1) = 1 /((L(5,3) - MZ2)+L(6,3))
  den(2) = 1 /((L(5,20) - MW2)+L(6,20))
  den(3) = 1 /((L(5,40) - MW2)+L(6,40))
  den(6) = 1 /((L(5,11) - MT2)+L(6,11))
  den(9) = 1 /((L(5,28) - MB2)+L(6,28))
  den(12) = 1 /((L(5,7))+L(6,7))
  den(15) = 1 /((L(5,44))+L(6,44))
  den(18) = 1 /((L(5,41) - ME2)+L(6,41))
  den(21) = 1 /((L(5,35) - MB2)+L(6,35))
  den(24) = 1 /((L(5,52) - MT2)+L(6,52))
  den(27) = 1 /((L(5,19))+L(6,19))
  den(30) = 1 /((L(5,56))+L(6,56))
  den(37) = 1 /((L(5,23) - MW2)+L(6,23))
  den(40) = 1 /((L(5,43) - MW2)+L(6,43))
  den(46) = 1 /((L(5,22) - ME2)+L(6,22))

  ! denominators
  den(4) = den(1)*den(2)
  den(5) = den(3)*den(4)
  den(7) = den(1)*den(6)
  den(8) = den(2)*den(7)
  den(10) = den(2)*den(9)
  den(11) = den(1)*den(10)
  den(13) = den(1)*den(12)
  den(14) = den(3)*den(13)
  den(16) = den(3)*den(15)
  den(17) = den(1)*den(16)
  den(19) = den(3)*den(18)
  den(20) = den(2)*den(19)
  den(22) = den(1)*den(21)
  den(23) = den(2)*den(22)
  den(25) = den(2)*den(24)
  den(26) = den(1)*den(25)
  den(28) = den(1)*den(27)
  den(29) = den(3)*den(28)
  den(31) = den(3)*den(30)
  den(32) = den(1)*den(31)
  den(33) = den(7)*den(25)
  den(34) = den(10)*den(22)
  den(35) = den(13)*den(31)
  den(36) = den(16)*den(28)
  den(38) = den(4)*den(37)
  den(39) = den(1)*den(3)
  den(41) = den(39)*den(40)
  den(42) = den(13)*den(37)
  den(43) = den(7)*den(40)
  den(44) = den(28)*den(37)
  den(45) = den(22)*den(40)
  den(47) = den(2)*den(46)
  den(48) = den(37)*den(47)
  den(49) = den(19)*den(40)

end subroutine denominators

!
!
!
!
!
! **********************************************************************
#ifdef PRECISION_dp
subroutine amp2(P_scatt, M02, M2ct, M2colint, qp_kinematics)
#else
subroutine amp2(P_scatt, M02, M2ct, M2colint, qp_kinematics)
  use ol_loop_storage_pptllj_nenexutxdxb_1_/**/DREALKIND, only: ntry, nhel, Hel
#endif
! P_scatt(0:3,Npart) = incoming external momenta
! M2  = helicity-summed squared matrix element for nu_e anti-nu_e up anti-top anti-down bottom -> 0
! **********************************************************************
  use ol_parameters_decl_/**/REALKIND !, only: ci, parameters_status, ZERO, scalefactor, >masses<
  use ol_parameters_init_/**/REALKIND, only: ensure_mp_init
  use ol_kinematics_/**/REALKIND, only: init_kinematics
  use ol_momenta_decl_/**/DREALKIND, only: momenta_nan_check
  use ol_data_types_/**/REALKIND
  use ol_h_helicity_bookkeeping_/**/REALKIND, only: &
    & helbookkeeping_wf, helsync, flip_phase
  use ol_helicity_init, only: helbookkeeping_flip, helsync_flip
  use ol_hel_propagators_/**/REALKIND
  use ol_hel_wavefunctions_/**/REALKIND
  use ol_wavefunctions_/**/REALKIND, only: wf_V_Std
  use ol_hel_vertices_/**/REALKIND
  use ol_hel_contractions_/**/REALKIND
  use ol_external_pptllj_nenexutxdxb_1, only: external_perm_pptllj_nenexutxdxb_1, &
    & external_perm_inv_pptllj_nenexutxdxb_1, extcomb_perm_pptllj_nenexutxdxb_1, &
    & average_factor_pptllj_nenexutxdxb_1
  use ol_external_pptllj_nenexutxdxb_1, only: H, hel_not_initialised, hel_init, POLSEL
  use ol_colourmatrix_pptllj_nenexutxdxb_1_/**/REALKIND, only: colmat_not_initialised, colourmatrix_init
  use ol_forced_parameters_pptllj_nenexutxdxb_1_/**/REALKIND, only: check_forced_parameters
  use ol_heltables_OLR_pptllj_nenexutxdxb_1
  use ol_kinematics_/**/REALKIND, only: LC2Std_Rep_cmplx
  use ol_h_counterterms_/**/REALKIND
  use ol_loop_parameters_decl_/**/REALKIND ! counterterms
  use ol_loop_parameters_decl_/**/DREALKIND, only: IR_is_on
  use ol_init, only: set_parameter, parameters_flush
#ifdef PRECISION_dp
  use ol_kinematics_/**/QREALKIND, only: conv_mom_scatt2in_qp=>conv_mom_scatt2in, &
                                         internal_momenta_qp=>internal_momenta
  use ol_momenta_decl_/**/DREALKIND, only: L
  use ol_momenta_decl_/**/QREALKIND, only: L_qp=>L
#endif
  implicit none

  real(DREALKIND), intent(in)  :: P_scatt(0:3,6)
  real(REALKIND),  intent(out) :: M02, M2ct, M2colint(22)
  logical, intent(in) :: qp_kinematics

  integer           :: shift, k, r, m, n, i
  real(REALKIND)    :: P(0:3,6)
#ifdef PRECISION_dp
  real(QREALKIND)    :: P_qp(0:3,6)
#endif
  integer           :: extmasses2(6)
  real(REALKIND)    :: M2add, M2add_ct, M2add_colint(22)
  complex(REALKIND) :: M1(1), M2(1)
  real(REALKIND)    :: P_scatt_intern(0:3,6)
  real(REALKIND), save :: scalebackfactor, old_scalefactor = 0
  integer(intkind1) :: nsync
  type(Hpolcont),   save :: M1helarray(1,64)
  type(Hpolcont) :: M1helarray_ct(1,64)
  integer, allocatable :: extcombs_permuted(:)
  integer              :: extcombs(22), nextcombs, ind_cc_comb(9)

  type(Hpolcont) :: A(64,40)

  !Aj are not used at the moment
  !complex(REALKIND) :: Aj(40)

  complex(REALKIND) :: omega(2) ! phases for helicity correlations

  call set_parameter("ew_renorm", 0)
  call parameters_flush()
  call ensure_mp_init()

  if (colmat_not_initialised) call colourmatrix_init()

  if (fac_status_loop1 /= parameters_status .or. fac_status_loop2 /= loop_parameters_status) then
    ! Note: if fac_init would only be called when parameters changed which are relevant for the factors,
    ! a different 'status' would have to be used, because forced_parameters should be called after every parameter change.
    call check_forced_parameters()
    call fac_init_loop()
  end if

  if (momenta_nan_check(P_scatt) /= 0) then
    M02 = 0
    return
  end if

  extmasses2 = [ 0, 0, 0, nMT, 0, nMB ]
  ! Convert 2 -> n-2 PS-point to n -> 0 (so that P(1) + ... + P(n) = 0) and compute
  ! internal-propagator momenta in light-cone representation
  call init_kinematics(P_scatt, extmasses2, P, external_perm_inv_pptllj_nenexutxdxb_1, 6, qp_kinematics)

  ! denominators
  call denominators()

   if (heltables_not_init) call init_heltables()

  ! external WFs
  ! Here the external wavefunctions are initialiased
  call pol_wf_Q(P(:,1), rZERO, H1, ex1, POLSEL(1),1)
  call pol_wf_A(P(:,2), rZERO, H2, ex2, POLSEL(2),2)
  call pol_wf_Q(P(:,3), rZERO, H3, ex3, POLSEL(3),3)
  call pol_wf_A(P(:,4), rMT, H4, ex4, POLSEL(4),4)
  call pol_wf_A(P(:,5), rZERO, H5, ex5, POLSEL(5),5)
  call pol_wf_Q(P(:,6), rMB, H6, ex6, POLSEL(6),6)



  ! internal WFs
  ! e.g. call vert_VQ_A(ntry, ex3, ex1, wf1, n1, t1) ...
  call vert_QA_Z(gZn,ntry, ex1(:), ex2(:), wf4(:,1), n3(:,1), t3x4(:,:,1))
  call vert_QA_W(ntry, ex3(:), ex5(:), wf4(:,2), n3(:,2), t3x4(:,:,2))
  call vert_AQ_S(gPtb,ntry, ex4(:), ex6(:), wf4(:,3), n3(:,3), t3x4(:,:,3))
  call vert_VV_S(ntry, wf4(:,1), wf4(:,2), wf16(:,1), n3(:,4), t3x16(:,:,1))
  call vert_QA_W(ntry, ex6(:), ex4(:), wf4(:,4), n3(:,5), t3x4(:,:,4))
  call vert_UV_W(ntry, wf4(:,1), 3, wf4(:,2), 20, wf16(:,2), n3(:,6), t3x16(:,:,2))
  call vert_AZ_Q(gZu,ntry, ex4(:), wf4(:,1), wf8(:,1), n3(:,7), t3x8(:,:,1))
  call vert_WQ_A(ntry, wf4(:,2), ex6(:), wf8(:,2), n3(:,8), t3x8(:,:,2))
  call prop_A_Q(ntry, wf8(:,1), 11, MT, 1_intkind1, wf8(:,3), n2(1))
  call vert_AW_Q(ntry, ex4(:), wf4(:,2), wf8(:,4), n3(:,9), t3x8(:,:,3))
  call vert_ZQ_A(gZd,ntry, wf4(:,1), ex6(:), wf8(:,5), n3(:,10), t3x8(:,:,4))
  call prop_A_Q(ntry, wf8(:,4), 28, MB, 1_intkind1, wf8(:,6), n2(2))
  call vert_ZQ_A(gZu,ntry, wf4(:,1), ex3(:), wf8(:,7), n3(:,11), t3x8(:,:,5))
  call vert_AW_Q(ntry, ex5(:), wf4(:,4), wf8(:,8), n3(:,12), t3x8(:,:,6))
  call prop_Q_A(ntry, wf8(:,7), 7, ZERO, 0_intkind1, wf8(:,9), n2(3))
  call vert_WQ_A(ntry, wf4(:,4), ex3(:), wf8(:,10), n3(:,13), t3x8(:,:,7))
  call vert_AZ_Q(gZd,ntry, ex5(:), wf4(:,1), wf8(:,11), n3(:,14), t3x8(:,:,8))
  call prop_Q_A(ntry, wf8(:,10), 44, ZERO, 0_intkind1, wf8(:,12), n2(4))
  call vert_QS_A(gPln,ntry, ex1(:), wf4(:,3), wf8(:,13), n3(:,15), t3x8(:,:,9))
  call vert_AW_Q(ntry, ex2(:), wf4(:,2), wf8(:,14), n3(:,16), t3x8(:,:,10))
  call prop_Q_A(ntry, wf8(:,13), 41, ME, 1_intkind1, wf8(:,15), n2(5))
  call vert_WQ_A(ntry, wf4(:,4), ex1(:), wf8(:,16), n3(:,17), t3x8(:,:,11))
  call prop_Q_A(ntry, wf8(:,16), 41, ME, 1_intkind1, wf8(:,17), n2(6))
  call counter_WQ_A(ntry, wf4(:,2), ex6(:), wf8(:,18), n3(:,18), t3x8(:,:,12))
  call counter_ZQ_A(gZd,ntry, wf4(:,1), ex6(:), wf8(:,19), n3(:,19), t3x8(:,:,13))
  call counter_SA_Q(gPdu,ntry, wf4(:,3), ex5(:), wf8(:,20), n3(:,20), t3x8(:,:,14))
  call counter_AW_Q(ntry, ex5(:), wf4(:,4), wf8(:,21), n3(:,21), t3x8(:,:,15))
  call counter_AZ_Q(gZd,ntry, ex5(:), wf4(:,1), wf8(:,22), n3(:,22), t3x8(:,:,16))
  call counter_AW_Q(ntry, ex4(:), wf4(:,2), wf8(:,23), n3(:,23), t3x8(:,:,17))
  call prop_Q_A(ntry, wf8(:,5), 35, MB, 1_intkind1, wf8(:,24), n2(7))
  call counter_AZ_Q(gZu,ntry, ex4(:), wf4(:,1), wf8(:,25), n3(:,24), t3x8(:,:,18))
  call prop_Q_A(ntry, wf8(:,2), 52, MT, 1_intkind1, wf8(:,26), n2(8))
  call counter_AQ_S(ctStb,ntry, ex4(:), ex6(:), wf4(:,5), n3(:,25), t3x4(:,:,5))
  call counter_QA_W(ntry, ex6(:), ex4(:), wf4(:,6), n3(:,26), t3x4(:,:,6))
  call vert_AW_Q(ntry, ex5(:), wf4(:,6), wf8(:,27), n3(:,27), t3x8(:,:,19))
  call vert_WQ_A(ntry, wf4(:,6), ex3(:), wf8(:,28), n3(:,28), t3x8(:,:,20))
  call prop_Q_A(ntry, wf8(:,28), 44, ZERO, 0_intkind1, wf8(:,29), n2(9))
  call counter_QS_A(gPdu,ntry, ex3(:), wf4(:,3), wf8(:,30), n3(:,29), t3x8(:,:,21))
  call prop_A_Q(ntry, wf8(:,11), 19, ZERO, 0_intkind1, wf8(:,31), n2(10))
  call counter_WQ_A(ntry, wf4(:,4), ex3(:), wf8(:,32), n3(:,30), t3x8(:,:,22))
  call counter_ZQ_A(gZu,ntry, wf4(:,1), ex3(:), wf8(:,33), n3(:,31), t3x8(:,:,23))
  call prop_A_Q(ntry, wf8(:,8), 56, ZERO, 0_intkind1, wf8(:,34), n2(11))
  call counter_AQ_S(gPdu,ntry, ex5(:), ex3(:), wf4(:,7), n3(:,32), t3x4(:,:,7))
  call vert_VS_T(ntry, wf4(:,1), 3, wf4(:,7), 20, wf16(:,3), n3(:,33), t3x16(:,:,3))
  call vert_SV_V(ntry, wf4(:,7), wf4(:,1), wf16(:,4), n3(:,34), t3x16(:,:,4))
  call counter_QA_W(ntry, ex3(:), ex5(:), wf4(:,8), n3(:,35), t3x4(:,:,8))
  call vert_VV_S(ntry, wf4(:,1), wf4(:,8), wf16(:,5), n3(:,36), t3x16(:,:,5))
  call vert_UV_W(ntry, wf4(:,1), 3, wf4(:,8), 20, wf16(:,6), n3(:,37), t3x16(:,:,6))
  call vert_QS_A(gPtb,ntry, ex6(:), wf4(:,7), wf8(:,35), n3(:,38), t3x8(:,:,24))
  call vert_WQ_A(ntry, wf4(:,8), ex6(:), wf8(:,36), n3(:,39), t3x8(:,:,25))
  call vert_SA_Q(gPtb,ntry, wf4(:,7), ex4(:), wf8(:,37), n3(:,40), t3x8(:,:,26))
  call prop_A_Q(ntry, wf8(:,37), 28, MB, 1_intkind1, wf8(:,38), n2(12))
  call vert_AW_Q(ntry, ex4(:), wf4(:,8), wf8(:,39), n3(:,41), t3x8(:,:,27))
  call prop_A_Q(ntry, wf8(:,39), 28, MB, 1_intkind1, wf8(:,40), n2(13))
  call vert_QS_A(gPln,ntry, ex1(:), wf4(:,5), wf8(:,41), n3(:,42), t3x8(:,:,28))
  call prop_Q_A(ntry, wf8(:,41), 41, ME, 1_intkind1, wf8(:,42), n2(14))
  call vert_WQ_A(ntry, wf4(:,6), ex1(:), wf8(:,43), n3(:,43), t3x8(:,:,29))
  call prop_Q_A(ntry, wf8(:,43), 41, ME, 1_intkind1, wf8(:,44), n2(15))
  call vert_SA_Q(gPnl,ntry, wf4(:,7), ex2(:), wf8(:,45), n3(:,44), t3x8(:,:,30))
  call vert_AW_Q(ntry, ex2(:), wf4(:,8), wf8(:,46), n3(:,45), t3x8(:,:,31))
  call counter_A_Q(cttt,6,ntry, wf8(:,3), 11, wf8(:,47), n2(16))
  call counter_A_Q(ctbb,5,ntry, wf8(:,6), 28, wf8(:,48), n2(17))
  call counter_Q_A(ctqq,2,ntry, wf8(:,9), 7, wf8(:,49), n2(18))
  call counter_Q_A(ctqq,1,ntry, wf8(:,12), 44, wf8(:,50), n2(19))
  call vert_SV_V(ntry, wf4(:,3), wf4(:,1), wf16(:,7), n3(:,46), t3x16(:,:,7))
  call vert_UV_W(ntry, wf4(:,4), 40, wf4(:,1), 3, wf16(:,8), n3(:,47), t3x16(:,:,8))
  call vert_QA_W(ntry, wf8(:,9), ex5(:), wf16(:,9), n3(:,48), t3x16(:,:,9))
  call vert_QA_W(ntry, ex6(:), wf8(:,3), wf16(:,10), n3(:,49), t3x16(:,:,10))
  call vert_QA_W(ntry, ex3(:), wf8(:,31), wf16(:,11), n3(:,50), t3x16(:,:,11))
  call vert_QA_W(ntry, wf8(:,24), ex4(:), wf16(:,12), n3(:,51), t3x16(:,:,12))
  call prop_A_Q(ntry, wf8(:,14), 22, ME, 1_intkind1, wf8(:,51), n2(20))
  call vert_AQ_S(gPln,ntry, wf8(:,51), ex1(:), wf16(:,13), n3(:,52), t3x16(:,:,13))
  call vert_QA_W(ntry, ex1(:), wf8(:,51), wf16(:,14), n3(:,53), t3x16(:,:,14))
  call vert_QA_W(ntry, wf8(:,15), ex2(:), wf16(:,15), n3(:,54), t3x16(:,:,15))
  call vert_QA_W(ntry, wf8(:,17), ex2(:), wf16(:,16), n3(:,55), t3x16(:,:,16))


  call init_hybrid_exwf(ex1)
  call init_hybrid_exwf(ex2)
  call init_hybrid_exwf(ex3)
  call init_hybrid_exwf(ex4)
  call init_hybrid_exwf(ex5)
  call init_hybrid_exwf(ex6)
  call init_hybrid_wf(wf4)
  call init_hybrid_wf(wf8)
  call init_hybrid_wf(wf16)


  if (ntry==1) then
    call physical_helicities()
  end if

  ! computation of the colour-stripped amplitudes
  do nsync = ntry+ntry-1, ntry+1  !  nsync = 1,2  for 1st point and nsync = 3 later
    call diagrams()
    if (nsync == 1) call helsync(nsync, A, nhel, Hel)
  end do

  ! In the following loop the coefficients \Gamma_{i} of the expansion in
  ! the colour basis are computed for every helicity state and stored in M1helarray.
  ! Also the colour vector for the Born-loop interference is computed and saved in
  ! M0_col1_helarray
  do k = 1, nhel
    call colourvectors(A, k, M1helarray(:,k),M1helarray_ct(:,k))
    call colborninterf(M1helarray(:,k), M0_col1_helarray(:,k), 0)
  end do
  M1helarray(:,nhel+1:)%j = 0
  M0_col1_helarray(:,nhel+1:)%hf = -1_intkind2
  M0_col1_helarray(:,nhel+1:)%j = 0

  M2add = 0
  M2add_ct = 0
  M2add_colint = 0

  M02 = 0
  M2ct = 0
  M2colint = 0

  do k = 1, nhel
    call colint(M1helarray(:,k)%j, M2add)
    call colint_ct(M1helarray(:,k)%j, M1helarray_ct(:,k)%j, M2add_ct, 0)
    if (IR_is_on > 0) then
      call colint_IR(M1helarray(:,k)%j, M2add_colint)
    end if
    !summation over helicity configurations
    M02 = M02 + M2add
    M2ct = M2ct + M2add_ct
    M2colint = M2colint + M2add_colint
  end do

  !! used for born-loop colour-correlators
  extcombs = [(i, i = 0, 22-1)]
  nextcombs = 6*(6+1)/2 + 1
  if(nextcombs>0) then
    allocate(extcombs_permuted(nextcombs))
  end if
  do k = 1, nextcombs
    extcombs_permuted(k) = extcomb_perm_pptllj_nenexutxdxb_1(extcombs(k))
  end do




  contains

subroutine physical_helicities()
  implicit none

integer :: i1,i2,i3,i4,i5,i6
integer :: n

n=0

do i6= 1, 2
do i5= 1, 2
do i4= 1, 2
do i3= 1, 2
do i2= 1, 2
do i1= 1, 2
n = n + 1
 if((ex1(i1)%hf==-1_intkind2) .OR. (ex2(i2)%hf==-1_intkind2) .OR. (ex3(i3)%hf==-1_intkind2) .OR. (ex4(i4)%hf==-1_intkind2)  &
    .OR. (ex5(i5)%hf==-1_intkind2) .OR. (ex6(i6)%hf==-1_intkind2)) then
  Hel(n) = -1_intkind2
 else
  Hel(n) = ex1(i1)%hf + ex2(i2)%hf + ex3(i3)%hf + ex4(i4)%hf + ex5(i5)%hf + ex6(i6)%hf
 end if
end do
end do
end do
end do
end do
end do

end subroutine physical_helicities

subroutine diagrams()
  implicit none
  integer :: h
  ! e.g. call cont_VV(nsync, wf3, wf6, A(:,1), n64, t64, nhel, den(5)) ...

    call Hcont_SS(nsync, wf4(:,3), wf16(:,1), A(:,1), n3(:,56), t3x64(:,:,1), nhel, den(5))
    call Hcont_VV(nsync, wf4(:,4), wf16(:,2), A(:,2), n3(:,57), t3x64(:,:,2), nhel, den(5))
    call Hcont_QA(nsync, wf8(:,2), wf8(:,3), A(:,3), n3(:,58), t3x64(:,:,3), nhel, den(8))
    call Hcont_QA(nsync, wf8(:,5), wf8(:,6), A(:,4), n3(:,59), t3x64(:,:,4), nhel, den(11))
    call Hcont_QA(nsync, wf8(:,8), wf8(:,9), A(:,5), n3(:,60), t3x64(:,:,5), nhel, den(14))
    call Hcont_QA(nsync, wf8(:,11), wf8(:,12), A(:,6), n3(:,61), t3x64(:,:,6), nhel, den(17))
    call Hcont_QA(nsync, wf8(:,14), wf8(:,15), A(:,7), n3(:,62), t3x64(:,:,7), nhel, den(20))
    call Hcont_QA(nsync, wf8(:,14), wf8(:,17), A(:,8), n3(:,63), t3x64(:,:,8), nhel, den(20))

    call Hcont_QA(nsync, wf8(:,3), wf8(:,18), A(:,9), n3(:,64), t3x64(:,:,9), nhel, den(8))
    call Hcont_QA(nsync, wf8(:,6), wf8(:,19), A(:,10), n3(:,65), t3x64(:,:,10), nhel, den(11))
    call Hcont_QA(nsync, wf8(:,9), wf8(:,20), A(:,11), n3(:,66), t3x64(:,:,11), nhel, den(14))
    call Hcont_QA(nsync, wf8(:,9), wf8(:,21), A(:,12), n3(:,67), t3x64(:,:,12), nhel, den(14))
    call Hcont_QA(nsync, wf8(:,12), wf8(:,22), A(:,13), n3(:,68), t3x64(:,:,13), nhel, den(17))
    call Hcont_QA(nsync, wf8(:,23), wf8(:,24), A(:,14), n3(:,69), t3x64(:,:,14), nhel, den(23))
    call Hcont_QA(nsync, wf8(:,25), wf8(:,26), A(:,15), n3(:,70), t3x64(:,:,15), nhel, den(26))
    call Hcont_SS(nsync, wf16(:,1), wf4(:,5), A(:,16), n3(:,71), t3x64(:,:,16), nhel, den(5))
    call Hcont_VV(nsync, wf16(:,2), wf4(:,6), A(:,17), n3(:,72), t3x64(:,:,17), nhel, den(5))
    call Hcont_QA(nsync, wf8(:,9), wf8(:,27), A(:,18), n3(:,73), t3x64(:,:,18), nhel, den(14))
    call Hcont_QA(nsync, wf8(:,11), wf8(:,29), A(:,19), n3(:,74), t3x64(:,:,19), nhel, den(17))
    call Hcont_QA(nsync, wf8(:,30), wf8(:,31), A(:,20), n3(:,75), t3x64(:,:,20), nhel, den(29))
    call Hcont_QA(nsync, wf8(:,31), wf8(:,32), A(:,21), n3(:,76), t3x64(:,:,21), nhel, den(29))
    call Hcont_QA(nsync, wf8(:,33), wf8(:,34), A(:,22), n3(:,77), t3x64(:,:,22), nhel, den(32))
    call Hcont_SS(nsync, wf4(:,3), wf16(:,3), A(:,23), n3(:,78), t3x64(:,:,23), nhel, den(5))
    call Hcont_VV(nsync, wf4(:,4), wf16(:,4), A(:,24), n3(:,79), t3x64(:,:,24), nhel, den(5))
    call Hcont_SS(nsync, wf4(:,3), wf16(:,5), A(:,25), n3(:,80), t3x64(:,:,25), nhel, den(5))
    call Hcont_VV(nsync, wf4(:,4), wf16(:,6), A(:,26), n3(:,81), t3x64(:,:,26), nhel, den(5))
    call Hcont_QA(nsync, wf8(:,3), wf8(:,35), A(:,27), n3(:,82), t3x64(:,:,27), nhel, den(8))
    call Hcont_QA(nsync, wf8(:,3), wf8(:,36), A(:,28), n3(:,83), t3x64(:,:,28), nhel, den(8))
    call Hcont_QA(nsync, wf8(:,5), wf8(:,38), A(:,29), n3(:,84), t3x64(:,:,29), nhel, den(11))
    call Hcont_QA(nsync, wf8(:,5), wf8(:,40), A(:,30), n3(:,85), t3x64(:,:,30), nhel, den(11))
    call Hcont_QA(nsync, wf8(:,14), wf8(:,42), A(:,31), n3(:,86), t3x64(:,:,31), nhel, den(20))
    call Hcont_QA(nsync, wf8(:,14), wf8(:,44), A(:,32), n3(:,87), t3x64(:,:,32), nhel, den(20))
    call Hcont_QA(nsync, wf8(:,15), wf8(:,45), A(:,33), n3(:,88), t3x64(:,:,33), nhel, den(20))
    call Hcont_QA(nsync, wf8(:,15), wf8(:,46), A(:,34), n3(:,89), t3x64(:,:,34), nhel, den(20))
    call Hcont_QA(nsync, wf8(:,17), wf8(:,45), A(:,35), n3(:,90), t3x64(:,:,35), nhel, den(20))
    call Hcont_QA(nsync, wf8(:,17), wf8(:,46), A(:,36), n3(:,91), t3x64(:,:,36), nhel, den(20))
    call Hcont_QA(nsync, wf8(:,26), wf8(:,47), A(:,37), n3(:,92), t3x64(:,:,37), nhel, den(33))
    call Hcont_QA(nsync, wf8(:,24), wf8(:,48), A(:,38), n3(:,93), t3x64(:,:,38), nhel, den(34))
    call Hcont_QA(nsync, wf8(:,34), wf8(:,49), A(:,39), n3(:,94), t3x64(:,:,39), nhel, den(35))
    call Hcont_QA(nsync, wf8(:,31), wf8(:,50), A(:,40), n3(:,95), t3x64(:,:,40), nhel, den(36))

end subroutine diagrams


elemental function diagmap(j, n)
  implicit none
  integer, intent(in) :: j, n
  complex(REALKIND) :: diagmap
  diagmap = A(j,n)%j
end function diagmap

function diagsum(j, pos, neg)
  implicit none
  integer, intent(in) :: j, pos(:), neg(:)
  complex(REALKIND) :: diagsum
  diagsum = sum(diagmap(j, pos)) - sum(diagmap(j, neg))
end function diagsum

subroutine colourvectors(A, j, M1, M2)
  implicit none
  type(Hpolcont) :: A(:,:)
  integer, intent(in) :: j
  type(Hpolcont), intent(out) :: M1(1), M2(1) ! M1helarray(1,64)
  integer :: empty(0), i

  M1(1)%j = A(j,8)%j*f(2)+A(j,7)%j*f(6)+A(j,2)%j*f(10)+(A(j,3)%j+A(j,4)%j+A(j,5)%j+A(j,6)%j)*f(13)-A(j,1)%j*f(20)

  M2(1)%j = -(A(j,23)%j*f(1))+A(j,32)%j*f(3)+A(j,36)%j*f(4)-A(j,33)%j*f(5)+A(j,31)%j*f(7)-A(j,35)%j*f(8)+A(j,34)%j*f(9) &
       +A(j,17)%j*f(11)+A(j,26)%j*f(12)+(-A(j,37)%j-A(j,38)%j-A(j,39)%j-A(j,40)%j)*f(14)+A(j,10)%j*f(15)+(A(j,9)%j+A(j,14)%j &
       +A(j,18)%j+A(j,19)%j)*f(16)+(A(j,12)%j+A(j,13)%j+A(j,21)%j+A(j,22)%j+A(j,28)%j+A(j,30)%j)*f(17)+A(j,15)%j*f(18)+(A(j,11)%j &
       +A(j,20)%j+A(j,27)%j+A(j,29)%j)*f(19)-A(j,16)%j*f(21)+A(j,24)%j*f(22)-A(j,25)%j*f(23)


  M1(:)%hf = Hel(j)
  M2(:)%hf = Hel(j)

  !M(i) corresponds to \Gamma_{i} in Fabios thesis

end subroutine colourvectors


! **********************************************************************
subroutine colint(M, M2colint)
! M(i)   = <M|Ci> colour component of matrix element
! COLINT = <M|M>
!        = Sum_{i,j} <M|Ci> * <Ci|Cj> * <Cj|M>
!        = colour-summed squared matrix element
! K2(i,j) = <Ci|Cj>
! **********************************************************************
  use ol_colourmatrix_pptllj_nenexutxdxb_1_/**/REALKIND, only: K1
  implicit none

  complex(REALKIND), intent(in)  :: M(1)
  real(REALKIND),    intent(out) :: M2colint
  integer :: i, j

  M2colint = 0

    do i = 1, 1
      do j = 1, 1
        M2colint = M2colint + real(conjg(M(i))*K1(i,j)*M(j))
      end do
    end do

end subroutine colint

! **********************************************************************
subroutine colint_ct(M, Mct, M2colint_ct, l)
! M(i)   = <M|Ci> colour component of matrix element
! COLINT = <M|M>
!        = Sum_{i,j} <M|Ci> * <Ci|Cj> * <Cj|M>
!        = colour-summed squared matrix element
! K2(i,j) = <Ci|Cj>
! **********************************************************************
  use ol_colourmatrix_pptllj_nenexutxdxb_1_/**/REALKIND, only: K2
  implicit none
  complex(REALKIND), intent(in)  :: M(1), Mct(1)
  real(REALKIND),    intent(out) :: M2colint_ct
  integer, intent(in) :: l
  integer ::  i, j

  M2colint_ct = 0

  do i = 1, 1
    do j = 1, 1
      M2colint_ct = M2colint_ct + real(conjg(M(i))*K2(i+1*l,j)*Mct(j))
    end do
  end do

end subroutine colint_ct

! **********************************************************************
subroutine colint_IR(M, M2IRadd)
! M(i)   = <M|Ci> colour component of matrix element
! K1(i,j) = .....
! **********************************************************************
  use ol_colourmatrix_pptllj_nenexutxdxb_1_/**/REALKIND, only: K1
  implicit none

  complex(REALKIND), intent(in)  :: M(1)
  real(REALKIND),    intent(out) :: M2IRadd(22)
  integer ::  i, j, k, colmatpos

  M2IRadd = 0

  do k = 1, 1-1
    colmatpos = 1*k
    do i = 1, 1
      do j = 1, 1
	      M2IRadd(k) = M2IRadd(k) + real(conjg(M(i))*K1(i+colmatpos,j)*M(j))
      end do
    end do
  end do

end subroutine colint_IR

! **********************************************************************
subroutine colintmunu(M1, M2, M2colint)
! M1(i)    = <M1|Ci> colour component of matrix element
! M2(i)    = <M2|Ci> colour component of matrix element
! M2colint = <M1|M2>
!          = Sum_{i,j} <M1|Ci> * <Ci|Cj> * <Cj|M2>
!          = colour-summed squared matrix element
! K2(i,j) = <Ci|Cj>
! **********************************************************************
  use ol_colourmatrix_pptllj_nenexutxdxb_1_/**/REALKIND, only: K2
  implicit none

  complex(REALKIND), intent(in)  :: M1(1)
  complex(REALKIND), intent(in)  :: M2(1)
  complex(REALKIND),    intent(out) :: M2colint
  integer :: i, j

  M2colint = 0

  do i = 1, 1
    do j = 1, 1
      M2colint = M2colint + M1(i)*K2(i,j)*conjg(M2(j))
    end do
  end do

end subroutine colintmunu





! **********************************************************************
subroutine colborninterf(M, M0_col, l)
! M(i)         = <M|Ci> colour component of matrix element
! M0_col(i)    = <M2|Ci> colour component of matrix element,
!                see \tilde{M}_{j} in Fabios thesis
! M2colint = Sum_{i} <M1|Ci> * <Ci|Cj>
!          = colour-summed squared matrix element
! KL(i,j) = <Ci|Cj> with elements Cj of 1-loop colour basis
! **********************************************************************
  use ol_colourmatrix_pptllj_nenexutxdxb_1_/**/REALKIND, only: KL
  implicit none

  type(Hpolcont), intent(in)  :: M(1)
  type(Hpolcont), intent(out)  :: M0_col(2)
  integer, intent(in) :: l
  integer :: i, j

  do j = 1, 2 !size(KL(1,:))
    M0_col(j)%j = 0
    M0_col(j)%hf = M(1)%hf
    do i = 1, 1 !size(KL(:,1))
      M0_col(j)%j = M0_col(j)%j  + conjg(M(i)%j)*KL(i+1*l,j)
    end do
  end do

end subroutine colborninterf

end subroutine amp2

end module ol_loop_pptllj_nenexutxdxb_1_/**/REALKIND
