
module ol_colourmatrix_pptllj_eexuxtdbx_1_/**/REALKIND
  use KIND_TYPES, only: REALKIND
  implicit none
  logical, save           :: colmat_not_initialised = .true.
  complex(REALKIND), save :: K1(1,1), K2(1,1), KL(1,2), Cas(6)
  contains
  subroutine colourmatrix_init
    use ol_parameters_decl_/**/REALKIND, only: CI
    implicit none
    colmat_not_initialised = .false.
    ! colour matrix

  K1(1,:) = [ 9]

  K2(1,:) = [ 9]

  KL(1,:) = [ 9, 3]
  Cas = 0
  end subroutine colourmatrix_init
end module ol_colourmatrix_pptllj_eexuxtdbx_1_/**/REALKIND



module ol_forced_parameters_pptllj_eexuxtdbx_1_/**/REALKIND
  implicit none
  contains
  subroutine check_forced_parameters
    use ol_parameters_decl_/**/REALKIND
    use ol_loop_parameters_decl_/**/REALKIND
#ifndef PRECISION_dp
    use ol_loop_parameters_decl_/**/DREALKIND, only: LeadingColour, nc, nf, CKMORDER
#endif
    implicit none
    logical, save :: checks_not_written = .true.

    if (checks_not_written) then
    ! e.g.
    ! if (ME /= 0) write(*,101) 'ME = 0'
  if (CKMORDER /= 0) write(*,101) 'CKMORDER = 0'
  if (nc /= 3) write(*,101) 'nc = 3'
  if (nf /= 6) write(*,101) 'nf = 6'
  if (MU /= 0) write(*,101) 'MU = 0'
  if (MD /= 0) write(*,101) 'MD = 0'
  if (MS /= 0) write(*,101) 'MS = 0'
  if (MC /= 0) write(*,101) 'MC = 0'
  if (LeadingColour /= 0) write(*,101) 'LeadingColour = 0'
  if (wME /= 0) write(*,101) 'wME = 0'
  if (wME /= 0) write(*,101) 'wME = 0'
  if (wMT /= 0) write(*,101) 'wMT = 0'
  if (wMB /= 0) write(*,101) 'wMB = 0'


    checks_not_written = .false.
    end if

    101 format('[OpenLoops] === WARNING ===',/,'[OpenLoops] code was generated with ',A,/,'[OpenLoops] ===============')
  end subroutine check_forced_parameters
end module ol_forced_parameters_pptllj_eexuxtdbx_1_/**/REALKIND
! **********************************************************************
module ol_loop_storage_pptllj_eexuxtdbx_1_/**/REALKIND
! **********************************************************************
  use KIND_TYPES, only: REALKIND, intkind1, intkind2
  use ol_data_types_/**/REALKIND, only: wfun, Hpolcont

#ifdef PRECISION_dp
  integer(intkind1), save :: ntry = 1, ntryL = 1
  integer(intkind1), save :: p_switch = 0 ! switch for dp or qp. Used for memory allocation of the OL types
  ! the following are flags for memory allocation of the hol coefficients in dp or qp
  logical, save :: dp_not_alloc = .TRUE., qp_not_alloc = .TRUE.
  integer(intkind2), parameter :: nheltot = 64 ! number of helicity configurations
  integer(intkind2), save :: nhel = 64 ! number of non-vanishing helicity configurations (adapted at runtime)
  integer(intkind2), save :: Hel(64) ! physical helicity states
#endif

  complex(REALKIND), save :: den(91)

  ! external wave functions ex1(h1),... for h<n> helicities
  type(wfun) :: ex1(2), ex2(2), ex3(2), ex4(2), ex5(2), ex6(2)

  ! wf<h>(h,n) n wave functions with h helicity configurations
  type(wfun) :: wf4(4,11), wf8(8,79), wf16(16,44), wf64(64,108)

  ! diagram prefactors
  integer,           save :: fac_status_loop1 = -1, fac_status_loop2 = -1
  complex(REALKIND), save :: f(67), c(29)

  !Vector in helicity and colour space for Born-Loop interference
  type(Hpolcont),   save :: M0_col1_helarray(2,64), M0M1_hel_cc(2,64,22)
  complex(REALKIND), save :: M2ctcc(22)

end module ol_loop_storage_pptllj_eexuxtdbx_1_/**/REALKIND






! **********************************************************************
module ol_loop_pptllj_eexuxtdbx_1_/**/REALKIND
! **********************************************************************
  use KIND_TYPES, only: REALKIND, DREALKIND, intkind1, intkind2
  use ol_data_types_/**/REALKIND, only: wfun, Hpolcont
  use ol_loop_storage_pptllj_eexuxtdbx_1_/**/REALKIND
  implicit none

!*********************************************************************************
  contains

! **********************************************************************
subroutine fac_init_loop()
! Writes diagram prefactors to 'f', rsp. 'c'
! **********************************************************************
  use ol_parameters_decl_/**/REALKIND
  use ol_loop_parameters_decl_/**/REALKIND
  use ol_init, only: set_parameter, tree_parameters_flush, parameters_flush
#ifndef PRECISION_dp
  use ol_loop_parameters_decl_/**/DREALKIND, only: SwF, SwB
!  use ol_loop_parameters_decl_/**/DREALKIND, only: DOI
#endif
  implicit none
  call set_parameter("ew_renorm", 0)
  if (parameters_status == 0) call tree_parameters_flush()
  if (loop_parameters_status == 0) call parameters_flush()
  fac_status_loop1 = parameters_status
  fac_status_loop2 = loop_parameters_status
  ! factors of the diagrams
    f( 1) = -(CI*countertermnorm*ctSqq*eQED**4*gQCD**2*(cw - sw)*(cw + sw))/(4._/**/REALKIND*cw*MW**2*sw**3)
    f( 2) = (CI*eQED**4)/(4._/**/REALKIND*sw**4)
    f( 3) = (CI*countertermnorm*ctVbt*eQED**4*gQCD**2)/(4._/**/REALKIND*sw**4)
    f( 4) = (CI*countertermnorm*ctVqq*eQED**4*gQCD**2)/(4._/**/REALKIND*sw**4)
    f( 5) = (CI*eQED**4*ME)/(4._/**/REALKIND*sw**4)
    f( 6) = (CI*countertermnorm*ctVbt*eQED**4*gQCD**2*ME)/(4._/**/REALKIND*sw**4)
    f( 7) = (CI*countertermnorm*ctVqq*eQED**4*gQCD**2*ME)/(4._/**/REALKIND*sw**4)
    f( 8) = (CI*countertermnorm*ctSqq*eQED**4*gQCD**2*MB*ME)/(8._/**/REALKIND*MW**4*sw**4)
    f( 9) = (CI*countertermnorm*ctSqq*eQED**4*gQCD**2*ME**2)/(4._/**/REALKIND*MW**4*sw**4)
    f(10) = (CI*countertermnorm*ctSqq*eQED**4*gQCD**2*ME*MH**2)/(8._/**/REALKIND*MW**4*sw**4)
    f(11) = (CI*countertermnorm*ctSqq*eQED**4*gQCD**2*ME*MT)/(8._/**/REALKIND*MW**4*sw**4)
    f(12) = (CI*eQED**4*ME)/(8._/**/REALKIND*MW**2*sw**4)
    f(13) = (CI*eQED**4*ME)/(4._/**/REALKIND*MW**2*sw**4)
    f(14) = (CI*countertermnorm*eQED**4*gQCD**2*ME)/(8._/**/REALKIND*MW**2*sw**4)
    f(15) = (CI*countertermnorm*eQED**4*gQCD**2*ME)/(4._/**/REALKIND*MW**2*sw**4)
    f(16) = (CI*countertermnorm*ctSqq*eQED**4*gQCD**2*ME)/(8._/**/REALKIND*MW**2*sw**4)
    f(17) = (CI*countertermnorm*ctSqq*eQED**4*gQCD**2*ME)/(4._/**/REALKIND*MW**2*sw**4)
    f(18) = (CI*countertermnorm*ctVqq*eQED**4*gQCD**2*ME)/(8._/**/REALKIND*MW**2*sw**4)
    f(19) = (CI*countertermnorm*ctVqq*eQED**4*gQCD**2*ME)/(4._/**/REALKIND*MW**2*sw**4)
    f(20) = (CI*eQED**4*MB*ME)/(8._/**/REALKIND*MW**2*sw**4)
    f(21) = (CI*countertermnorm*eQED**4*gQCD**2*MB*ME)/(8._/**/REALKIND*MW**2*sw**4)
    f(22) = (CI*countertermnorm*ctSbb*eQED**4*gQCD**2*MB*ME)/(8._/**/REALKIND*MW**2*sw**4)
    f(23) = (CI*countertermnorm*ctVbt*eQED**4*gQCD**2*MB*ME)/(8._/**/REALKIND*MW**2*sw**4)
    f(24) = (CI*countertermnorm*ctVqq*eQED**4*gQCD**2*MB*ME)/(8._/**/REALKIND*MW**2*sw**4)
    f(25) = (CI*eQED**4*ME*MT)/(8._/**/REALKIND*MW**2*sw**4)
    f(26) = (CI*countertermnorm*eQED**4*gQCD**2*ME*MT)/(8._/**/REALKIND*MW**2*sw**4)
    f(27) = (CI*countertermnorm*ctStt*eQED**4*gQCD**2*ME*MT)/(8._/**/REALKIND*MW**2*sw**4)
    f(28) = (CI*countertermnorm*ctVbt*eQED**4*gQCD**2*ME*MT)/(8._/**/REALKIND*MW**2*sw**4)
    f(29) = (CI*countertermnorm*ctVqq*eQED**4*gQCD**2*ME*MT)/(8._/**/REALKIND*MW**2*sw**4)
    f(30) = (CI*cw*eQED**4)/(2._/**/REALKIND*sw**3)
    f(31) = (CI*countertermnorm*ctVbt*cw*eQED**4*gQCD**2)/(2._/**/REALKIND*sw**3)
    f(32) = (CI*countertermnorm*ctVqq*cw*eQED**4*gQCD**2)/(2._/**/REALKIND*sw**3)
    f(33) = (CI*eQED**4)/(6._/**/REALKIND*sw**2)
    f(34) = (CI*eQED**4)/(3._/**/REALKIND*sw**2)
    f(35) = (CI*eQED**4)/(2._/**/REALKIND*sw**2)
    f(36) = (CI*countertermnorm*eQED**4*gQCD**2)/(6._/**/REALKIND*sw**2)
    f(37) = (CI*countertermnorm*eQED**4*gQCD**2)/(3._/**/REALKIND*sw**2)
    f(38) = (CI*countertermnorm*eQED**4*gQCD**2)/(2._/**/REALKIND*sw**2)
    f(39) = (CI*countertermnorm*ctSqq*eQED**4*gQCD**2)/(2._/**/REALKIND*sw**2)
    f(40) = (CI*countertermnorm*ctVbb*eQED**4*gQCD**2)/(6._/**/REALKIND*sw**2)
    f(41) = (CI*countertermnorm*ctVbb*eQED**4*gQCD**2)/(2._/**/REALKIND*sw**2)
    f(42) = (CI*countertermnorm*ctVbt*eQED**4*gQCD**2)/(6._/**/REALKIND*sw**2)
    f(43) = (CI*countertermnorm*ctVbt*eQED**4*gQCD**2)/(3._/**/REALKIND*sw**2)
    f(44) = (CI*countertermnorm*ctVbt*eQED**4*gQCD**2)/(2._/**/REALKIND*sw**2)
    f(45) = (CI*countertermnorm*ctVqq*eQED**4*gQCD**2)/(6._/**/REALKIND*sw**2)
    f(46) = (CI*countertermnorm*ctVqq*eQED**4*gQCD**2)/(3._/**/REALKIND*sw**2)
    f(47) = (CI*countertermnorm*ctVqq*eQED**4*gQCD**2)/(2._/**/REALKIND*sw**2)
    f(48) = (CI*countertermnorm*ctVtt*eQED**4*gQCD**2)/(3._/**/REALKIND*sw**2)
    f(49) = (CI*countertermnorm*ctVtt*eQED**4*gQCD**2)/(2._/**/REALKIND*sw**2)
    f(50) = (CI*countertermnorm*ctSqq*eQED**4*gQCD**2)/(6._/**/REALKIND*MW**2*sw**2)
    f(51) = (CI*countertermnorm*ctSqq*eQED**4*gQCD**2)/(3._/**/REALKIND*MW**2*sw**2)
    f(52) = (CI*countertermnorm*ctSqq*eQED**4*gQCD**2)/(2._/**/REALKIND*MW**2*sw**2)
    f(53) = (CI*eQED**4)/(2._/**/REALKIND*cw*sw)
    f(54) = (CI*countertermnorm*eQED**4*gQCD**2)/(2._/**/REALKIND*cw*sw)
    f(55) = (CI*countertermnorm*ctSqq*eQED**4*gQCD**2)/(2._/**/REALKIND*cw*sw)
    f(56) = (CI*countertermnorm*ctVqq*eQED**4*gQCD**2)/(2._/**/REALKIND*cw*sw)
    f(57) = (eQED**4*gQCD**2*integralnorm*SwB)/(sw**4*4._/**/REALKIND)
    f(58) = (eQED**4*gQCD**2*integralnorm*ME*SwB)/(sw**4*4._/**/REALKIND)
    f(59) = (eQED**4*gQCD**2*integralnorm*ME*SwB)/(MW**2*sw**4*8._/**/REALKIND)
    f(60) = (eQED**4*gQCD**2*integralnorm*ME*SwB)/(MW**2*sw**4*4._/**/REALKIND)
    f(61) = (eQED**4*gQCD**2*integralnorm*MB*ME*SwB)/(MW**2*sw**4*8._/**/REALKIND)
    f(62) = (eQED**4*gQCD**2*integralnorm*ME*MT*SwB)/(MW**2*sw**4*8._/**/REALKIND)
    f(63) = (cw*eQED**4*gQCD**2*integralnorm*SwB)/(sw**3*2._/**/REALKIND)
    f(64) = (eQED**4*gQCD**2*integralnorm*SwB)/(sw**2*6._/**/REALKIND)
    f(65) = (eQED**4*gQCD**2*integralnorm*SwB)/(sw**2*3._/**/REALKIND)
    f(66) = (eQED**4*gQCD**2*integralnorm*SwB)/(sw**2*2._/**/REALKIND)
    f(67) = (eQED**4*gQCD**2*integralnorm*SwB)/(cw*sw*2._/**/REALKIND)

  c = [ 8*f(57), f(58), 3*f(58), 8*f(58), f(59), 3*f(59), 8*f(59), 8*f(60), f(61), 3*f(61), 8*f(61), f(62), 3*f(62), 8*f(62) &
    , f(63), 3*f(63), 8*f(63), f(64), 3*f(64), 8*f(64), f(65), 3*f(65), 8*f(65), f(66), 3*f(66), 8*f(66), f(67), 3*f(67) &
    , 8*f(67) ]
  c = (1._/**/REALKIND / 6) * c
end subroutine fac_init_loop

subroutine denominators()
  use ol_parameters_decl_/**/REALKIND ! masses
  use ol_momenta_decl_/**/REALKIND, only: L
  implicit none
  ! propagators
  den(1) = 1 /((L(5,3) - MH2)+L(6,3))
  den(2) = 1 /((L(5,20) - MW2)+L(6,20))
  den(3) = 1 /((L(5,40) - MW2)+L(6,40))
  den(6) = 1 /((L(5,3) - MZ2)+L(6,3))
  den(9) = 1 /((L(5,3))+L(6,3))
  den(12) = 1 /((L(5,11) - MT2)+L(6,11))
  den(19) = 1 /((L(5,28) - MB2)+L(6,28))
  den(24) = 1 /((L(5,7))+L(6,7))
  den(29) = 1 /((L(5,44))+L(6,44))
  den(33) = 1 /((L(5,41))+L(6,41))
  den(36) = 1 /((L(5,35) - MB2)+L(6,35))
  den(43) = 1 /((L(5,52) - MT2)+L(6,52))
  den(48) = 1 /((L(5,19))+L(6,19))
  den(53) = 1 /((L(5,56))+L(6,56))
  den(67) = 1 /((L(5,23) - MW2)+L(6,23))
  den(72) = 1 /((L(5,43) - MW2)+L(6,43))
  den(88) = 1 /((L(5,22))+L(6,22))

  ! denominators
  den(4) = den(1)*den(2)
  den(5) = den(3)*den(4)
  den(7) = den(2)*den(6)
  den(8) = den(3)*den(7)
  den(10) = den(2)*den(9)
  den(11) = den(3)*den(10)
  den(13) = den(1)*den(12)
  den(14) = den(2)*den(13)
  den(15) = den(6)*den(12)
  den(16) = den(2)*den(15)
  den(17) = den(9)*den(12)
  den(18) = den(2)*den(17)
  den(20) = den(2)*den(19)
  den(21) = den(1)*den(20)
  den(22) = den(6)*den(20)
  den(23) = den(9)*den(20)
  den(25) = den(9)*den(24)
  den(26) = den(3)*den(25)
  den(27) = den(6)*den(24)
  den(28) = den(3)*den(27)
  den(30) = den(3)*den(29)
  den(31) = den(9)*den(30)
  den(32) = den(6)*den(30)
  den(34) = den(3)*den(33)
  den(35) = den(2)*den(34)
  den(37) = den(1)*den(36)
  den(38) = den(2)*den(37)
  den(39) = den(6)*den(36)
  den(40) = den(2)*den(39)
  den(41) = den(9)*den(36)
  den(42) = den(2)*den(41)
  den(44) = den(2)*den(43)
  den(45) = den(1)*den(44)
  den(46) = den(6)*den(44)
  den(47) = den(9)*den(44)
  den(49) = den(9)*den(48)
  den(50) = den(3)*den(49)
  den(51) = den(6)*den(48)
  den(52) = den(3)*den(51)
  den(54) = den(3)*den(53)
  den(55) = den(9)*den(54)
  den(56) = den(6)*den(54)
  den(57) = den(13)*den(44)
  den(58) = den(15)*den(44)
  den(59) = den(17)*den(44)
  den(60) = den(20)*den(37)
  den(61) = den(20)*den(39)
  den(62) = den(20)*den(41)
  den(63) = den(25)*den(54)
  den(64) = den(27)*den(54)
  den(65) = den(30)*den(49)
  den(66) = den(30)*den(51)
  den(68) = den(4)*den(67)
  den(69) = den(7)*den(67)
  den(70) = den(10)*den(67)
  den(71) = den(1)*den(3)
  den(73) = den(71)*den(72)
  den(74) = den(3)*den(6)
  den(75) = den(72)*den(74)
  den(76) = den(3)*den(9)
  den(77) = den(72)*den(76)
  den(78) = den(25)*den(67)
  den(79) = den(27)*den(67)
  den(80) = den(13)*den(72)
  den(81) = den(15)*den(72)
  den(82) = den(17)*den(72)
  den(83) = den(49)*den(67)
  den(84) = den(51)*den(67)
  den(85) = den(37)*den(72)
  den(86) = den(39)*den(72)
  den(87) = den(41)*den(72)
  den(89) = den(2)*den(88)
  den(90) = den(67)*den(89)
  den(91) = den(34)*den(72)

end subroutine denominators

!
!
!
!
!
! **********************************************************************
#ifdef PRECISION_dp
subroutine amp2(P_scatt, M02, M2ct, M2colint, qp_kinematics)
#else
subroutine amp2(P_scatt, M02, M2ct, M2colint, qp_kinematics)
  use ol_loop_storage_pptllj_eexuxtdbx_1_/**/DREALKIND, only: ntry, nhel, Hel
#endif
! P_scatt(0:3,Npart) = incoming external momenta
! M2  = helicity-summed squared matrix element for e- e+ anti-up top down anti-bottom -> 0
! **********************************************************************
  use ol_parameters_decl_/**/REALKIND !, only: ci, parameters_status, ZERO, scalefactor, >masses<
  use ol_parameters_init_/**/REALKIND, only: ensure_mp_init
  use ol_kinematics_/**/REALKIND, only: init_kinematics
  use ol_momenta_decl_/**/DREALKIND, only: momenta_nan_check
  use ol_data_types_/**/REALKIND
  use ol_h_helicity_bookkeeping_/**/REALKIND, only: &
    & helbookkeeping_wf, helsync, flip_phase
  use ol_helicity_init, only: helbookkeeping_flip, helsync_flip
  use ol_hel_propagators_/**/REALKIND
  use ol_hel_wavefunctions_/**/REALKIND
  use ol_wavefunctions_/**/REALKIND, only: wf_V_Std
  use ol_hel_vertices_/**/REALKIND
  use ol_hel_contractions_/**/REALKIND
  use ol_external_pptllj_eexuxtdbx_1, only: external_perm_pptllj_eexuxtdbx_1, &
    & external_perm_inv_pptllj_eexuxtdbx_1, extcomb_perm_pptllj_eexuxtdbx_1, &
    & average_factor_pptllj_eexuxtdbx_1
  use ol_external_pptllj_eexuxtdbx_1, only: H, hel_not_initialised, hel_init, POLSEL
  use ol_colourmatrix_pptllj_eexuxtdbx_1_/**/REALKIND, only: colmat_not_initialised, colourmatrix_init
  use ol_forced_parameters_pptllj_eexuxtdbx_1_/**/REALKIND, only: check_forced_parameters
  use ol_heltables_OLR_pptllj_eexuxtdbx_1
  use ol_kinematics_/**/REALKIND, only: LC2Std_Rep_cmplx
  use ol_h_counterterms_/**/REALKIND
  use ol_loop_parameters_decl_/**/REALKIND ! counterterms
  use ol_loop_parameters_decl_/**/DREALKIND, only: IR_is_on
  use ol_init, only: set_parameter, parameters_flush
#ifdef PRECISION_dp
  use ol_kinematics_/**/QREALKIND, only: conv_mom_scatt2in_qp=>conv_mom_scatt2in, &
                                         internal_momenta_qp=>internal_momenta
  use ol_momenta_decl_/**/DREALKIND, only: L
  use ol_momenta_decl_/**/QREALKIND, only: L_qp=>L
#endif
  implicit none

  real(DREALKIND), intent(in)  :: P_scatt(0:3,6)
  real(REALKIND),  intent(out) :: M02, M2ct, M2colint(22)
  logical, intent(in) :: qp_kinematics

  integer           :: shift, k, r, m, n, i
  real(REALKIND)    :: P(0:3,6)
#ifdef PRECISION_dp
  real(QREALKIND)    :: P_qp(0:3,6)
#endif
  integer           :: extmasses2(6)
  real(REALKIND)    :: M2add, M2add_ct, M2add_colint(22)
  complex(REALKIND) :: M1(1), M2(1)
  real(REALKIND)    :: P_scatt_intern(0:3,6)
  real(REALKIND), save :: scalebackfactor, old_scalefactor = 0
  integer(intkind1) :: nsync
  type(Hpolcont),   save :: M1helarray(1,64)
  type(Hpolcont) :: M1helarray_ct(1,64)
  integer, allocatable :: extcombs_permuted(:)
  integer              :: extcombs(22), nextcombs, ind_cc_comb(9)

  type(Hpolcont) :: A(64,108)

  !Aj are not used at the moment
  !complex(REALKIND) :: Aj(108)

  complex(REALKIND) :: omega(2) ! phases for helicity correlations

  call set_parameter("ew_renorm", 0)
  call parameters_flush()
  call ensure_mp_init()

  if (colmat_not_initialised) call colourmatrix_init()

  if (fac_status_loop1 /= parameters_status .or. fac_status_loop2 /= loop_parameters_status) then
    ! Note: if fac_init would only be called when parameters changed which are relevant for the factors,
    ! a different 'status' would have to be used, because forced_parameters should be called after every parameter change.
    call check_forced_parameters()
    call fac_init_loop()
  end if

  if (momenta_nan_check(P_scatt) /= 0) then
    M02 = 0
    return
  end if

  extmasses2 = [ nME, nME, 0, nMT, 0, nMB ]
  ! Convert 2 -> n-2 PS-point to n -> 0 (so that P(1) + ... + P(n) = 0) and compute
  ! internal-propagator momenta in light-cone representation
  call init_kinematics(P_scatt, extmasses2, P, external_perm_inv_pptllj_eexuxtdbx_1, 6, qp_kinematics)

  ! denominators
  call denominators()

   if (heltables_not_init) call init_heltables()

  ! external WFs
  ! Here the external wavefunctions are initialiased
  call pol_wf_Q(P(:,1), rME, H1, ex1, POLSEL(1),1)
  call pol_wf_A(P(:,2), rME, H2, ex2, POLSEL(2),2)
  call pol_wf_A(P(:,3), rZERO, H3, ex3, POLSEL(3),3)
  call pol_wf_Q(P(:,4), rMT, H4, ex4, POLSEL(4),4)
  call pol_wf_Q(P(:,5), rZERO, H5, ex5, POLSEL(5),5)
  call pol_wf_A(P(:,6), rMB, H6, ex6, POLSEL(6),6)



  ! internal WFs
  ! e.g. call vert_VQ_A(ntry, ex3, ex1, wf1, n1, t1) ...
  call vert_AQ_S(gH,ntry, ex2(:), ex1(:), wf4(:,1), n3(:,1), t3x4(:,:,1))
  call vert_QA_W(ntry, ex5(:), ex3(:), wf4(:,2), n3(:,2), t3x4(:,:,2))
  call vert_AQ_S(gPbt,ntry, ex6(:), ex4(:), wf4(:,3), n3(:,3), t3x4(:,:,3))
  call vert_TV_S(ntry, wf4(:,1), 3, wf4(:,2), 20, wf16(:,1), n3(:,4), t3x16(:,:,1))
  call vert_AQ_S(gX,ntry, ex2(:), ex1(:), wf4(:,4), n3(:,5), t3x4(:,:,4))
  call vert_TV_S(ntry, wf4(:,4), 3, wf4(:,2), 20, wf16(:,2), n3(:,6), t3x16(:,:,2))
  call vert_QA_W(ntry, ex4(:), ex6(:), wf4(:,5), n3(:,7), t3x4(:,:,5))
  call vert_SV_V(ntry, wf4(:,1), wf4(:,2), wf16(:,3), n3(:,8), t3x16(:,:,3))
  call vert_QA_V(ntry, ex1(:), ex2(:), wf4(:,6), n3(:,9), t3x4(:,:,6))
  call vert_VV_S(ntry, wf4(:,6), wf4(:,2), wf16(:,4), n3(:,10), t3x16(:,:,4))
  call vert_QA_Z(gZl,ntry, ex1(:), ex2(:), wf4(:,7), n3(:,11), t3x4(:,:,7))
  call vert_VV_S(ntry, wf4(:,7), wf4(:,2), wf16(:,5), n3(:,12), t3x16(:,:,5))
  call vert_UV_W(ntry, wf4(:,2), 20, wf4(:,6), 3, wf16(:,6), n3(:,13), t3x16(:,:,6))
  call vert_UV_W(ntry, wf4(:,2), 20, wf4(:,7), 3, wf16(:,7), n3(:,14), t3x16(:,:,7))
  call vert_QS_A(gH,ntry, ex4(:), wf4(:,1), wf8(:,1), n3(:,15), t3x8(:,:,1))
  call vert_AW_Q(ntry, ex6(:), wf4(:,2), wf8(:,2), n3(:,16), t3x8(:,:,2))
  call prop_Q_A(ntry, wf8(:,1), 11, MT, 1_intkind1, wf8(:,3), n2(1))
  call vert_QS_A(gX,ntry, ex4(:), wf4(:,4), wf8(:,4), n3(:,17), t3x8(:,:,3))
  call prop_Q_A(ntry, wf8(:,4), 11, MT, 1_intkind1, wf8(:,5), n2(2))
  call vert_VQ_A(ntry, wf4(:,6), ex4(:), wf8(:,6), n3(:,18), t3x8(:,:,4))
  call prop_Q_A(ntry, wf8(:,6), 11, MT, 1_intkind1, wf8(:,7), n2(3))
  call vert_ZQ_A(gZu,ntry, wf4(:,7), ex4(:), wf8(:,8), n3(:,19), t3x8(:,:,5))
  call prop_Q_A(ntry, wf8(:,8), 11, MT, 1_intkind1, wf8(:,9), n2(4))
  call vert_WQ_A(ntry, wf4(:,2), ex4(:), wf8(:,10), n3(:,20), t3x8(:,:,6))
  call vert_SA_Q(gH,ntry, wf4(:,1), ex6(:), wf8(:,11), n3(:,21), t3x8(:,:,7))
  call prop_Q_A(ntry, wf8(:,10), 28, MB, 1_intkind1, wf8(:,12), n2(5))
  call vert_SA_Q(gX,ntry, wf4(:,4), ex6(:), wf8(:,13), n3(:,22), t3x8(:,:,8))
  call vert_AV_Q(ntry, ex6(:), wf4(:,6), wf8(:,14), n3(:,23), t3x8(:,:,9))
  call vert_AZ_Q(gZd,ntry, ex6(:), wf4(:,7), wf8(:,15), n3(:,24), t3x8(:,:,10))
  call vert_AV_Q(ntry, ex3(:), wf4(:,6), wf8(:,16), n3(:,25), t3x8(:,:,11))
  call vert_WQ_A(ntry, wf4(:,5), ex5(:), wf8(:,17), n3(:,26), t3x8(:,:,12))
  call prop_A_Q(ntry, wf8(:,16), 7, ZERO, 0_intkind1, wf8(:,18), n2(6))
  call vert_AZ_Q(gZu,ntry, ex3(:), wf4(:,7), wf8(:,19), n3(:,27), t3x8(:,:,13))
  call prop_A_Q(ntry, wf8(:,19), 7, ZERO, 0_intkind1, wf8(:,20), n2(7))
  call vert_AW_Q(ntry, ex3(:), wf4(:,5), wf8(:,21), n3(:,28), t3x8(:,:,14))
  call vert_VQ_A(ntry, wf4(:,6), ex5(:), wf8(:,22), n3(:,29), t3x8(:,:,15))
  call prop_A_Q(ntry, wf8(:,21), 44, ZERO, 0_intkind1, wf8(:,23), n2(8))
  call vert_ZQ_A(gZd,ntry, wf4(:,7), ex5(:), wf8(:,24), n3(:,30), t3x8(:,:,16))
  call vert_QS_A(gPnl,ntry, ex1(:), wf4(:,3), wf8(:,25), n3(:,31), t3x8(:,:,17))
  call vert_AW_Q(ntry, ex2(:), wf4(:,2), wf8(:,26), n3(:,32), t3x8(:,:,18))
  call prop_Q_A(ntry, wf8(:,25), 41, ZERO, 0_intkind1, wf8(:,27), n2(9))
  call vert_WQ_A(ntry, wf4(:,5), ex1(:), wf8(:,28), n3(:,33), t3x8(:,:,19))
  call prop_Q_A(ntry, wf8(:,28), 41, ZERO, 0_intkind1, wf8(:,29), n2(10))
  call counter_AW_Q(ntry, ex6(:), wf4(:,2), wf8(:,30), n3(:,34), t3x8(:,:,20))
  call counter_SA_Q(gH,ntry, wf4(:,1), ex6(:), wf8(:,31), n3(:,35), t3x8(:,:,21))
  call counter_SA_Q(gX,ntry, wf4(:,4), ex6(:), wf8(:,32), n3(:,36), t3x8(:,:,22))
  call counter_AV_Q(ntry, ex6(:), wf4(:,6), wf8(:,33), n3(:,37), t3x8(:,:,23))
  call counter_AZ_Q(gZd,ntry, ex6(:), wf4(:,7), wf8(:,34), n3(:,38), t3x8(:,:,24))
  call counter_QS_A(gPud,ntry, ex5(:), wf4(:,3), wf8(:,35), n3(:,39), t3x8(:,:,25))
  call counter_WQ_A(ntry, wf4(:,5), ex5(:), wf8(:,36), n3(:,40), t3x8(:,:,26))
  call counter_VQ_A(ntry, wf4(:,6), ex5(:), wf8(:,37), n3(:,41), t3x8(:,:,27))
  call counter_ZQ_A(gZd,ntry, wf4(:,7), ex5(:), wf8(:,38), n3(:,42), t3x8(:,:,28))
  call counter_WQ_A(ntry, wf4(:,2), ex4(:), wf8(:,39), n3(:,43), t3x8(:,:,29))
  call prop_A_Q(ntry, wf8(:,11), 35, MB, 1_intkind1, wf8(:,40), n2(11))
  call prop_A_Q(ntry, wf8(:,13), 35, MB, 1_intkind1, wf8(:,41), n2(12))
  call prop_A_Q(ntry, wf8(:,14), 35, MB, 1_intkind1, wf8(:,42), n2(13))
  call prop_A_Q(ntry, wf8(:,15), 35, MB, 1_intkind1, wf8(:,43), n2(14))
  call counter_QS_A(gH,ntry, ex4(:), wf4(:,1), wf8(:,44), n3(:,44), t3x8(:,:,30))
  call prop_A_Q(ntry, wf8(:,2), 52, MT, 1_intkind1, wf8(:,45), n2(15))
  call counter_QS_A(gX,ntry, ex4(:), wf4(:,4), wf8(:,46), n3(:,45), t3x8(:,:,31))
  call counter_VQ_A(ntry, wf4(:,6), ex4(:), wf8(:,47), n3(:,46), t3x8(:,:,32))
  call counter_ZQ_A(gZu,ntry, wf4(:,7), ex4(:), wf8(:,48), n3(:,47), t3x8(:,:,33))
  call counter_AQ_S(ctSbt,ntry, ex6(:), ex4(:), wf4(:,8), n3(:,48), t3x4(:,:,8))
  call counter_QA_W(ntry, ex4(:), ex6(:), wf4(:,9), n3(:,49), t3x4(:,:,9))
  call vert_WQ_A(ntry, wf4(:,9), ex5(:), wf8(:,49), n3(:,50), t3x8(:,:,34))
  call vert_AW_Q(ntry, ex3(:), wf4(:,9), wf8(:,50), n3(:,51), t3x8(:,:,35))
  call prop_A_Q(ntry, wf8(:,50), 44, ZERO, 0_intkind1, wf8(:,51), n2(16))
  call counter_SA_Q(gPud,ntry, wf4(:,3), ex3(:), wf8(:,52), n3(:,52), t3x8(:,:,36))
  call prop_Q_A(ntry, wf8(:,22), 19, ZERO, 0_intkind1, wf8(:,53), n2(17))
  call prop_Q_A(ntry, wf8(:,24), 19, ZERO, 0_intkind1, wf8(:,54), n2(18))
  call counter_AW_Q(ntry, ex3(:), wf4(:,5), wf8(:,55), n3(:,53), t3x8(:,:,37))
  call counter_AV_Q(ntry, ex3(:), wf4(:,6), wf8(:,56), n3(:,54), t3x8(:,:,38))
  call prop_Q_A(ntry, wf8(:,17), 56, ZERO, 0_intkind1, wf8(:,57), n2(19))
  call counter_AZ_Q(gZu,ntry, ex3(:), wf4(:,7), wf8(:,58), n3(:,55), t3x8(:,:,39))
  call counter_AQ_S(gPud,ntry, ex3(:), ex5(:), wf4(:,10), n3(:,56), t3x4(:,:,10))
  call vert_SS_S(ntry, wf4(:,1), wf4(:,10), wf16(:,8), n3(:,57), t3x16(:,:,8))
  call vert_ST_V(ntry, wf4(:,10), 20, wf4(:,1), 3, wf16(:,9), n3(:,58), t3x16(:,:,9))
  call vert_ST_V(ntry, wf4(:,10), 20, wf4(:,4), 3, wf16(:,10), n3(:,59), t3x16(:,:,10))
  call counter_QA_W(ntry, ex5(:), ex3(:), wf4(:,11), n3(:,60), t3x4(:,:,11))
  call vert_TV_S(ntry, wf4(:,1), 3, wf4(:,11), 20, wf16(:,11), n3(:,61), t3x16(:,:,11))
  call vert_TV_S(ntry, wf4(:,4), 3, wf4(:,11), 20, wf16(:,12), n3(:,62), t3x16(:,:,12))
  call vert_SV_V(ntry, wf4(:,1), wf4(:,11), wf16(:,13), n3(:,63), t3x16(:,:,13))
  call vert_TV_S(ntry, wf4(:,10), 20, wf4(:,6), 3, wf16(:,14), n3(:,64), t3x16(:,:,14))
  call vert_TV_S(ntry, wf4(:,10), 20, wf4(:,7), 3, wf16(:,15), n3(:,65), t3x16(:,:,15))
  call vert_SV_V(ntry, wf4(:,10), wf4(:,6), wf16(:,16), n3(:,66), t3x16(:,:,16))
  call vert_SV_V(ntry, wf4(:,10), wf4(:,7), wf16(:,17), n3(:,67), t3x16(:,:,17))
  call vert_VV_S(ntry, wf4(:,6), wf4(:,11), wf16(:,18), n3(:,68), t3x16(:,:,18))
  call vert_VV_S(ntry, wf4(:,7), wf4(:,11), wf16(:,19), n3(:,69), t3x16(:,:,19))
  call vert_UV_W(ntry, wf4(:,11), 20, wf4(:,6), 3, wf16(:,20), n3(:,70), t3x16(:,:,20))
  call vert_UV_W(ntry, wf4(:,11), 20, wf4(:,7), 3, wf16(:,21), n3(:,71), t3x16(:,:,21))
  call vert_SA_Q(gPbt,ntry, wf4(:,10), ex6(:), wf8(:,59), n3(:,72), t3x8(:,:,40))
  call vert_AW_Q(ntry, ex6(:), wf4(:,11), wf8(:,60), n3(:,73), t3x8(:,:,41))
  call vert_QS_A(gPbt,ntry, ex4(:), wf4(:,10), wf8(:,61), n3(:,74), t3x8(:,:,42))
  call prop_Q_A(ntry, wf8(:,61), 28, MB, 1_intkind1, wf8(:,62), n2(20))
  call vert_WQ_A(ntry, wf4(:,11), ex4(:), wf8(:,63), n3(:,75), t3x8(:,:,43))
  call prop_Q_A(ntry, wf8(:,63), 28, MB, 1_intkind1, wf8(:,64), n2(21))
  call vert_QS_A(gPnl,ntry, ex1(:), wf4(:,8), wf8(:,65), n3(:,76), t3x8(:,:,44))
  call prop_Q_A(ntry, wf8(:,65), 41, ZERO, 0_intkind1, wf8(:,66), n2(22))
  call vert_WQ_A(ntry, wf4(:,9), ex1(:), wf8(:,67), n3(:,77), t3x8(:,:,45))
  call prop_Q_A(ntry, wf8(:,67), 41, ZERO, 0_intkind1, wf8(:,68), n2(23))
  call vert_SA_Q(gPln,ntry, wf4(:,10), ex2(:), wf8(:,69), n3(:,78), t3x8(:,:,46))
  call vert_AW_Q(ntry, ex2(:), wf4(:,11), wf8(:,70), n3(:,79), t3x8(:,:,47))
  call counter_Q_A(cttt,6,ntry, wf8(:,3), 11, wf8(:,71), n2(24))
  call counter_Q_A(cttt,6,ntry, wf8(:,5), 11, wf8(:,72), n2(25))
  call counter_Q_A(cttt,6,ntry, wf8(:,7), 11, wf8(:,73), n2(26))
  call counter_Q_A(cttt,6,ntry, wf8(:,9), 11, wf8(:,74), n2(27))
  call counter_Q_A(ctbb,5,ntry, wf8(:,12), 28, wf8(:,75), n2(28))
  call counter_A_Q(ctqq,2,ntry, wf8(:,18), 7, wf8(:,76), n2(29))
  call counter_A_Q(ctqq,2,ntry, wf8(:,20), 7, wf8(:,77), n2(30))
  call counter_A_Q(ctqq,1,ntry, wf8(:,23), 44, wf8(:,78), n2(31))
  call vert_ST_V(ntry, wf4(:,3), 40, wf4(:,1), 3, wf16(:,22), n3(:,80), t3x16(:,:,22))
  call vert_ST_V(ntry, wf4(:,3), 40, wf4(:,4), 3, wf16(:,23), n3(:,81), t3x16(:,:,23))
  call vert_SV_V(ntry, wf4(:,1), wf4(:,5), wf16(:,24), n3(:,82), t3x16(:,:,24))
  call vert_SV_V(ntry, wf4(:,3), wf4(:,6), wf16(:,25), n3(:,83), t3x16(:,:,25))
  call vert_SV_V(ntry, wf4(:,3), wf4(:,7), wf16(:,26), n3(:,84), t3x16(:,:,26))
  call vert_UV_W(ntry, wf4(:,6), 3, wf4(:,5), 40, wf16(:,27), n3(:,85), t3x16(:,:,27))
  call vert_UV_W(ntry, wf4(:,7), 3, wf4(:,5), 40, wf16(:,28), n3(:,86), t3x16(:,:,28))
  call vert_QA_W(ntry, ex5(:), wf8(:,18), wf16(:,29), n3(:,87), t3x16(:,:,29))
  call vert_QA_W(ntry, ex5(:), wf8(:,20), wf16(:,30), n3(:,88), t3x16(:,:,30))
  call vert_QA_W(ntry, wf8(:,3), ex6(:), wf16(:,31), n3(:,89), t3x16(:,:,31))
  call vert_QA_W(ntry, wf8(:,5), ex6(:), wf16(:,32), n3(:,90), t3x16(:,:,32))
  call vert_QA_W(ntry, wf8(:,7), ex6(:), wf16(:,33), n3(:,91), t3x16(:,:,33))
  call vert_QA_W(ntry, wf8(:,9), ex6(:), wf16(:,34), n3(:,92), t3x16(:,:,34))
  call vert_QA_W(ntry, wf8(:,53), ex3(:), wf16(:,35), n3(:,93), t3x16(:,:,35))
  call vert_QA_W(ntry, wf8(:,54), ex3(:), wf16(:,36), n3(:,94), t3x16(:,:,36))
  call vert_QA_W(ntry, ex4(:), wf8(:,40), wf16(:,37), n3(:,95), t3x16(:,:,37))
  call vert_QA_W(ntry, ex4(:), wf8(:,41), wf16(:,38), n3(:,96), t3x16(:,:,38))
  call vert_QA_W(ntry, ex4(:), wf8(:,42), wf16(:,39), n3(:,97), t3x16(:,:,39))
  call vert_QA_W(ntry, ex4(:), wf8(:,43), wf16(:,40), n3(:,98), t3x16(:,:,40))
  call prop_A_Q(ntry, wf8(:,26), 22, ZERO, 0_intkind1, wf8(:,79), n2(32))
  call vert_AQ_S(gPnl,ntry, wf8(:,79), ex1(:), wf16(:,41), n3(:,99), t3x16(:,:,41))
  call vert_QA_W(ntry, ex1(:), wf8(:,79), wf16(:,42), n3(:,100), t3x16(:,:,42))
  call vert_QA_W(ntry, wf8(:,27), ex2(:), wf16(:,43), n3(:,101), t3x16(:,:,43))
  call vert_QA_W(ntry, wf8(:,29), ex2(:), wf16(:,44), n3(:,102), t3x16(:,:,44))


  call init_hybrid_exwf(ex1)
  call init_hybrid_exwf(ex2)
  call init_hybrid_exwf(ex3)
  call init_hybrid_exwf(ex4)
  call init_hybrid_exwf(ex5)
  call init_hybrid_exwf(ex6)
  call init_hybrid_wf(wf4)
  call init_hybrid_wf(wf8)
  call init_hybrid_wf(wf16)


  if (ntry==1) then
    call physical_helicities()
  end if

  ! computation of the colour-stripped amplitudes
  do nsync = ntry+ntry-1, ntry+1  !  nsync = 1,2  for 1st point and nsync = 3 later
    call diagrams()
    if (nsync == 1) call helsync(nsync, A, nhel, Hel)
  end do

  ! In the following loop the coefficients \Gamma_{i} of the expansion in
  ! the colour basis are computed for every helicity state and stored in M1helarray.
  ! Also the colour vector for the Born-loop interference is computed and saved in
  ! M0_col1_helarray
  do k = 1, nhel
    call colourvectors(A, k, M1helarray(:,k),M1helarray_ct(:,k))
    call colborninterf(M1helarray(:,k), M0_col1_helarray(:,k), 0)
  end do
  M1helarray(:,nhel+1:)%j = 0
  M0_col1_helarray(:,nhel+1:)%hf = -1_intkind2
  M0_col1_helarray(:,nhel+1:)%j = 0

  M2add = 0
  M2add_ct = 0
  M2add_colint = 0

  M02 = 0
  M2ct = 0
  M2colint = 0

  do k = 1, nhel
    call colint(M1helarray(:,k)%j, M2add)
    call colint_ct(M1helarray(:,k)%j, M1helarray_ct(:,k)%j, M2add_ct, 0)
    if (IR_is_on > 0) then
      call colint_IR(M1helarray(:,k)%j, M2add_colint)
    end if
    !summation over helicity configurations
    M02 = M02 + M2add
    M2ct = M2ct + M2add_ct
    M2colint = M2colint + M2add_colint
  end do

  !! used for born-loop colour-correlators
  extcombs = [(i, i = 0, 22-1)]
  nextcombs = 6*(6+1)/2 + 1
  if(nextcombs>0) then
    allocate(extcombs_permuted(nextcombs))
  end if
  do k = 1, nextcombs
    extcombs_permuted(k) = extcomb_perm_pptllj_eexuxtdbx_1(extcombs(k))
  end do




  contains

subroutine physical_helicities()
  implicit none

integer :: i1,i2,i3,i4,i5,i6
integer :: n

n=0

do i6= 1, 2
do i5= 1, 2
do i4= 1, 2
do i3= 1, 2
do i2= 1, 2
do i1= 1, 2
n = n + 1
 if((ex1(i1)%hf==-1_intkind2) .OR. (ex2(i2)%hf==-1_intkind2) .OR. (ex3(i3)%hf==-1_intkind2) .OR. (ex4(i4)%hf==-1_intkind2)  &
    .OR. (ex5(i5)%hf==-1_intkind2) .OR. (ex6(i6)%hf==-1_intkind2)) then
  Hel(n) = -1_intkind2
 else
  Hel(n) = ex1(i1)%hf + ex2(i2)%hf + ex3(i3)%hf + ex4(i4)%hf + ex5(i5)%hf + ex6(i6)%hf
 end if
end do
end do
end do
end do
end do
end do

end subroutine physical_helicities

subroutine diagrams()
  implicit none
  integer :: h
  ! e.g. call cont_VV(nsync, wf3, wf6, A(:,1), n64, t64, nhel, den(5)) ...

    call Hcont_SS(nsync, wf4(:,3), wf16(:,1), A(:,1), n3(:,103), t3x64(:,:,1), nhel, den(5))
    call Hcont_SS(nsync, wf4(:,3), wf16(:,2), A(:,2), n3(:,104), t3x64(:,:,2), nhel, den(8))
    call Hcont_VV(nsync, wf4(:,5), wf16(:,3), A(:,3), n3(:,105), t3x64(:,:,3), nhel, den(5))
    call Hcont_SS(nsync, wf4(:,3), wf16(:,4), A(:,4), n3(:,106), t3x64(:,:,4), nhel, den(11))
    call Hcont_SS(nsync, wf4(:,3), wf16(:,5), A(:,5), n3(:,107), t3x64(:,:,5), nhel, den(8))
    call Hcont_VV(nsync, wf4(:,5), wf16(:,6), A(:,6), n3(:,108), t3x64(:,:,6), nhel, den(11))
    call Hcont_VV(nsync, wf4(:,5), wf16(:,7), A(:,7), n3(:,109), t3x64(:,:,7), nhel, den(8))
    call Hcont_QA(nsync, wf8(:,2), wf8(:,3), A(:,8), n3(:,110), t3x64(:,:,8), nhel, den(14))
    call Hcont_QA(nsync, wf8(:,2), wf8(:,5), A(:,9), n3(:,111), t3x64(:,:,9), nhel, den(16))
    call Hcont_QA(nsync, wf8(:,2), wf8(:,7), A(:,10), n3(:,112), t3x64(:,:,10), nhel, den(18))
    call Hcont_QA(nsync, wf8(:,2), wf8(:,9), A(:,11), n3(:,113), t3x64(:,:,11), nhel, den(16))
    call Hcont_QA(nsync, wf8(:,11), wf8(:,12), A(:,12), n3(:,114), t3x64(:,:,12), nhel, den(21))
    call Hcont_QA(nsync, wf8(:,12), wf8(:,13), A(:,13), n3(:,115), t3x64(:,:,13), nhel, den(22))
    call Hcont_QA(nsync, wf8(:,12), wf8(:,14), A(:,14), n3(:,116), t3x64(:,:,14), nhel, den(23))
    call Hcont_QA(nsync, wf8(:,12), wf8(:,15), A(:,15), n3(:,117), t3x64(:,:,15), nhel, den(22))
    call Hcont_QA(nsync, wf8(:,17), wf8(:,18), A(:,16), n3(:,118), t3x64(:,:,16), nhel, den(26))
    call Hcont_QA(nsync, wf8(:,17), wf8(:,20), A(:,17), n3(:,119), t3x64(:,:,17), nhel, den(28))
    call Hcont_QA(nsync, wf8(:,22), wf8(:,23), A(:,18), n3(:,120), t3x64(:,:,18), nhel, den(31))
    call Hcont_QA(nsync, wf8(:,23), wf8(:,24), A(:,19), n3(:,121), t3x64(:,:,19), nhel, den(32))
    call Hcont_QA(nsync, wf8(:,26), wf8(:,27), A(:,20), n3(:,122), t3x64(:,:,20), nhel, den(35))
    call Hcont_QA(nsync, wf8(:,26), wf8(:,29), A(:,21), n3(:,123), t3x64(:,:,21), nhel, den(35))

    call Hcont_QA(nsync, wf8(:,3), wf8(:,30), A(:,22), n3(:,124), t3x64(:,:,22), nhel, den(14))
    call Hcont_QA(nsync, wf8(:,5), wf8(:,30), A(:,23), n3(:,125), t3x64(:,:,23), nhel, den(16))
    call Hcont_QA(nsync, wf8(:,7), wf8(:,30), A(:,24), n3(:,126), t3x64(:,:,24), nhel, den(18))
    call Hcont_QA(nsync, wf8(:,9), wf8(:,30), A(:,25), n3(:,127), t3x64(:,:,25), nhel, den(16))
    call Hcont_QA(nsync, wf8(:,12), wf8(:,31), A(:,26), n3(:,128), t3x64(:,:,26), nhel, den(21))
    call Hcont_QA(nsync, wf8(:,12), wf8(:,32), A(:,27), n3(:,129), t3x64(:,:,27), nhel, den(22))
    call Hcont_QA(nsync, wf8(:,12), wf8(:,33), A(:,28), n3(:,130), t3x64(:,:,28), nhel, den(23))
    call Hcont_QA(nsync, wf8(:,12), wf8(:,34), A(:,29), n3(:,131), t3x64(:,:,29), nhel, den(22))
    call Hcont_QA(nsync, wf8(:,18), wf8(:,35), A(:,30), n3(:,132), t3x64(:,:,30), nhel, den(26))
    call Hcont_QA(nsync, wf8(:,20), wf8(:,35), A(:,31), n3(:,133), t3x64(:,:,31), nhel, den(28))
    call Hcont_QA(nsync, wf8(:,18), wf8(:,36), A(:,32), n3(:,134), t3x64(:,:,32), nhel, den(26))
    call Hcont_QA(nsync, wf8(:,20), wf8(:,36), A(:,33), n3(:,135), t3x64(:,:,33), nhel, den(28))
    call Hcont_QA(nsync, wf8(:,23), wf8(:,37), A(:,34), n3(:,136), t3x64(:,:,34), nhel, den(31))
    call Hcont_QA(nsync, wf8(:,23), wf8(:,38), A(:,35), n3(:,137), t3x64(:,:,35), nhel, den(32))
    call Hcont_QA(nsync, wf8(:,39), wf8(:,40), A(:,36), n3(:,138), t3x64(:,:,36), nhel, den(38))
    call Hcont_QA(nsync, wf8(:,39), wf8(:,41), A(:,37), n3(:,139), t3x64(:,:,37), nhel, den(40))
    call Hcont_QA(nsync, wf8(:,39), wf8(:,42), A(:,38), n3(:,140), t3x64(:,:,38), nhel, den(42))
    call Hcont_QA(nsync, wf8(:,39), wf8(:,43), A(:,39), n3(:,141), t3x64(:,:,39), nhel, den(40))
    call Hcont_QA(nsync, wf8(:,44), wf8(:,45), A(:,40), n3(:,142), t3x64(:,:,40), nhel, den(45))
    call Hcont_QA(nsync, wf8(:,45), wf8(:,46), A(:,41), n3(:,143), t3x64(:,:,41), nhel, den(46))
    call Hcont_QA(nsync, wf8(:,45), wf8(:,47), A(:,42), n3(:,144), t3x64(:,:,42), nhel, den(47))
    call Hcont_QA(nsync, wf8(:,45), wf8(:,48), A(:,43), n3(:,145), t3x64(:,:,43), nhel, den(46))
    call Hcont_SS(nsync, wf16(:,1), wf4(:,8), A(:,44), n3(:,146), t3x64(:,:,44), nhel, den(5))
    call Hcont_SS(nsync, wf16(:,2), wf4(:,8), A(:,45), n3(:,147), t3x64(:,:,45), nhel, den(8))
    call Hcont_VV(nsync, wf16(:,3), wf4(:,9), A(:,46), n3(:,148), t3x64(:,:,46), nhel, den(5))
    call Hcont_SS(nsync, wf16(:,4), wf4(:,8), A(:,47), n3(:,149), t3x64(:,:,47), nhel, den(11))
    call Hcont_SS(nsync, wf16(:,5), wf4(:,8), A(:,48), n3(:,150), t3x64(:,:,48), nhel, den(8))
    call Hcont_VV(nsync, wf16(:,6), wf4(:,9), A(:,49), n3(:,151), t3x64(:,:,49), nhel, den(11))
    call Hcont_VV(nsync, wf16(:,7), wf4(:,9), A(:,50), n3(:,152), t3x64(:,:,50), nhel, den(8))
    call Hcont_QA(nsync, wf8(:,18), wf8(:,49), A(:,51), n3(:,153), t3x64(:,:,51), nhel, den(26))
    call Hcont_QA(nsync, wf8(:,20), wf8(:,49), A(:,52), n3(:,154), t3x64(:,:,52), nhel, den(28))
    call Hcont_QA(nsync, wf8(:,22), wf8(:,51), A(:,53), n3(:,155), t3x64(:,:,53), nhel, den(31))
    call Hcont_QA(nsync, wf8(:,24), wf8(:,51), A(:,54), n3(:,156), t3x64(:,:,54), nhel, den(32))
    call Hcont_QA(nsync, wf8(:,52), wf8(:,53), A(:,55), n3(:,157), t3x64(:,:,55), nhel, den(50))
    call Hcont_QA(nsync, wf8(:,52), wf8(:,54), A(:,56), n3(:,158), t3x64(:,:,56), nhel, den(52))
    call Hcont_QA(nsync, wf8(:,53), wf8(:,55), A(:,57), n3(:,159), t3x64(:,:,57), nhel, den(50))
    call Hcont_QA(nsync, wf8(:,54), wf8(:,55), A(:,58), n3(:,160), t3x64(:,:,58), nhel, den(52))
    call Hcont_QA(nsync, wf8(:,56), wf8(:,57), A(:,59), n3(:,161), t3x64(:,:,59), nhel, den(55))
    call Hcont_QA(nsync, wf8(:,57), wf8(:,58), A(:,60), n3(:,162), t3x64(:,:,60), nhel, den(56))
    call Hcont_SS(nsync, wf4(:,3), wf16(:,8), A(:,61), n3(:,163), t3x64(:,:,61), nhel, den(5))
    call Hcont_VV(nsync, wf4(:,5), wf16(:,9), A(:,62), n3(:,164), t3x64(:,:,62), nhel, den(5))
    call Hcont_VV(nsync, wf4(:,5), wf16(:,10), A(:,63), n3(:,165), t3x64(:,:,63), nhel, den(8))
    call Hcont_SS(nsync, wf4(:,3), wf16(:,11), A(:,64), n3(:,166), t3x64(:,:,64), nhel, den(5))
    call Hcont_SS(nsync, wf4(:,3), wf16(:,12), A(:,65), n3(:,167), t3x64(:,:,65), nhel, den(8))
    call Hcont_VV(nsync, wf4(:,5), wf16(:,13), A(:,66), n3(:,168), t3x64(:,:,66), nhel, den(5))
    call Hcont_SS(nsync, wf4(:,3), wf16(:,14), A(:,67), n3(:,169), t3x64(:,:,67), nhel, den(11))
    call Hcont_SS(nsync, wf4(:,3), wf16(:,15), A(:,68), n3(:,170), t3x64(:,:,68), nhel, den(8))
    call Hcont_VV(nsync, wf4(:,5), wf16(:,16), A(:,69), n3(:,171), t3x64(:,:,69), nhel, den(11))
    call Hcont_VV(nsync, wf4(:,5), wf16(:,17), A(:,70), n3(:,172), t3x64(:,:,70), nhel, den(8))
    call Hcont_SS(nsync, wf4(:,3), wf16(:,18), A(:,71), n3(:,173), t3x64(:,:,71), nhel, den(11))
    call Hcont_SS(nsync, wf4(:,3), wf16(:,19), A(:,72), n3(:,174), t3x64(:,:,72), nhel, den(8))
    call Hcont_VV(nsync, wf4(:,5), wf16(:,20), A(:,73), n3(:,175), t3x64(:,:,73), nhel, den(11))
    call Hcont_VV(nsync, wf4(:,5), wf16(:,21), A(:,74), n3(:,176), t3x64(:,:,74), nhel, den(8))
    call Hcont_QA(nsync, wf8(:,3), wf8(:,59), A(:,75), n3(:,177), t3x64(:,:,75), nhel, den(14))
    call Hcont_QA(nsync, wf8(:,5), wf8(:,59), A(:,76), n3(:,178), t3x64(:,:,76), nhel, den(16))
    call Hcont_QA(nsync, wf8(:,3), wf8(:,60), A(:,77), n3(:,179), t3x64(:,:,77), nhel, den(14))
    call Hcont_QA(nsync, wf8(:,5), wf8(:,60), A(:,78), n3(:,180), t3x64(:,:,78), nhel, den(16))
    call Hcont_QA(nsync, wf8(:,7), wf8(:,59), A(:,79), n3(:,181), t3x64(:,:,79), nhel, den(18))
    call Hcont_QA(nsync, wf8(:,9), wf8(:,59), A(:,80), n3(:,182), t3x64(:,:,80), nhel, den(16))
    call Hcont_QA(nsync, wf8(:,7), wf8(:,60), A(:,81), n3(:,183), t3x64(:,:,81), nhel, den(18))
    call Hcont_QA(nsync, wf8(:,9), wf8(:,60), A(:,82), n3(:,184), t3x64(:,:,82), nhel, den(16))
    call Hcont_QA(nsync, wf8(:,11), wf8(:,62), A(:,83), n3(:,185), t3x64(:,:,83), nhel, den(21))
    call Hcont_QA(nsync, wf8(:,13), wf8(:,62), A(:,84), n3(:,186), t3x64(:,:,84), nhel, den(22))
    call Hcont_QA(nsync, wf8(:,11), wf8(:,64), A(:,85), n3(:,187), t3x64(:,:,85), nhel, den(21))
    call Hcont_QA(nsync, wf8(:,13), wf8(:,64), A(:,86), n3(:,188), t3x64(:,:,86), nhel, den(22))
    call Hcont_QA(nsync, wf8(:,14), wf8(:,62), A(:,87), n3(:,189), t3x64(:,:,87), nhel, den(23))
    call Hcont_QA(nsync, wf8(:,15), wf8(:,62), A(:,88), n3(:,190), t3x64(:,:,88), nhel, den(22))
    call Hcont_QA(nsync, wf8(:,14), wf8(:,64), A(:,89), n3(:,191), t3x64(:,:,89), nhel, den(23))
    call Hcont_QA(nsync, wf8(:,15), wf8(:,64), A(:,90), n3(:,192), t3x64(:,:,90), nhel, den(22))
    call Hcont_QA(nsync, wf8(:,26), wf8(:,66), A(:,91), n3(:,193), t3x64(:,:,91), nhel, den(35))
    call Hcont_QA(nsync, wf8(:,26), wf8(:,68), A(:,92), n3(:,194), t3x64(:,:,92), nhel, den(35))
    call Hcont_QA(nsync, wf8(:,27), wf8(:,69), A(:,93), n3(:,195), t3x64(:,:,93), nhel, den(35))
    call Hcont_QA(nsync, wf8(:,27), wf8(:,70), A(:,94), n3(:,196), t3x64(:,:,94), nhel, den(35))
    call Hcont_QA(nsync, wf8(:,29), wf8(:,69), A(:,95), n3(:,197), t3x64(:,:,95), nhel, den(35))
    call Hcont_QA(nsync, wf8(:,29), wf8(:,70), A(:,96), n3(:,198), t3x64(:,:,96), nhel, den(35))
    call Hcont_QA(nsync, wf8(:,45), wf8(:,71), A(:,97), n3(:,199), t3x64(:,:,97), nhel, den(57))
    call Hcont_QA(nsync, wf8(:,45), wf8(:,72), A(:,98), n3(:,200), t3x64(:,:,98), nhel, den(58))
    call Hcont_QA(nsync, wf8(:,45), wf8(:,73), A(:,99), n3(:,201), t3x64(:,:,99), nhel, den(59))
    call Hcont_QA(nsync, wf8(:,45), wf8(:,74), A(:,100), n3(:,202), t3x64(:,:,100), nhel, den(58))
    call Hcont_QA(nsync, wf8(:,40), wf8(:,75), A(:,101), n3(:,203), t3x64(:,:,101), nhel, den(60))
    call Hcont_QA(nsync, wf8(:,41), wf8(:,75), A(:,102), n3(:,204), t3x64(:,:,102), nhel, den(61))
    call Hcont_QA(nsync, wf8(:,42), wf8(:,75), A(:,103), n3(:,205), t3x64(:,:,103), nhel, den(62))
    call Hcont_QA(nsync, wf8(:,43), wf8(:,75), A(:,104), n3(:,206), t3x64(:,:,104), nhel, den(61))
    call Hcont_QA(nsync, wf8(:,57), wf8(:,76), A(:,105), n3(:,207), t3x64(:,:,105), nhel, den(63))
    call Hcont_QA(nsync, wf8(:,57), wf8(:,77), A(:,106), n3(:,208), t3x64(:,:,106), nhel, den(64))
    call Hcont_QA(nsync, wf8(:,53), wf8(:,78), A(:,107), n3(:,209), t3x64(:,:,107), nhel, den(65))
    call Hcont_QA(nsync, wf8(:,54), wf8(:,78), A(:,108), n3(:,210), t3x64(:,:,108), nhel, den(66))

end subroutine diagrams


elemental function diagmap(j, n)
  implicit none
  integer, intent(in) :: j, n
  complex(REALKIND) :: diagmap
  diagmap = A(j,n)%j
end function diagmap

function diagsum(j, pos, neg)
  implicit none
  integer, intent(in) :: j, pos(:), neg(:)
  complex(REALKIND) :: diagsum
  diagsum = sum(diagmap(j, pos)) - sum(diagmap(j, neg))
end function diagsum

subroutine colourvectors(A, j, M1, M2)
  implicit none
  type(Hpolcont) :: A(:,:)
  integer, intent(in) :: j
  type(Hpolcont), intent(out) :: M1(1), M2(1) ! M1helarray(1,64)
  integer :: empty(0), i

  M1(1)%j = A(j,21)%j*f(2)-A(j,3)%j*f(5)+(-A(j,1)%j+A(j,2)%j)*f(12)-A(j,20)%j*f(13)+(-A(j,12)%j+A(j,13)%j)*f(20)+(-A(j,8)%j &
       -A(j,9)%j)*f(25)+A(j,7)%j*f(30)+(A(j,14)%j+A(j,18)%j)*f(33)+(-A(j,10)%j-A(j,16)%j)*f(34)+(A(j,4)%j-A(j,6)%j+A(j,11)%j &
       +A(j,15)%j+A(j,17)%j+A(j,19)%j)*f(35)+A(j,5)%j*f(53)

  M2(1)%j = -(A(j,68)%j*f(1))+A(j,92)%j*f(3)+A(j,96)%j*f(4)-A(j,46)%j*f(6)-A(j,66)%j*f(7)+(-A(j,83)%j+A(j,84)%j)*f(8) &
       -A(j,93)%j*f(9)-A(j,61)%j*f(10)+(-A(j,75)%j-A(j,76)%j)*f(11)+(-A(j,44)%j+A(j,45)%j)*f(14)-A(j,91)%j*f(15)+(-A(j,62)%j &
       -A(j,63)%j)*f(16)+A(j,95)%j*f(17)+(-A(j,64)%j+A(j,65)%j)*f(18)-A(j,94)%j*f(19)+(A(j,101)%j-A(j,102)%j)*f(21)+(-A(j,26)%j &
       +A(j,27)%j)*f(22)+(-A(j,36)%j+A(j,37)%j)*f(23)+(-A(j,85)%j+A(j,86)%j)*f(24)+(A(j,97)%j+A(j,98)%j)*f(26)+(-A(j,40)%j &
       -A(j,41)%j)*f(27)+(-A(j,22)%j-A(j,23)%j)*f(28)+(-A(j,77)%j-A(j,78)%j)*f(29)+A(j,50)%j*f(31)+A(j,74)%j*f(32)+(-A(j,103)%j &
       -A(j,107)%j)*f(36)+(A(j,99)%j+A(j,105)%j)*f(37)+(A(j,47)%j-A(j,100)%j-A(j,104)%j-A(j,106)%j-A(j,108)%j)*f(38) &
       -A(j,69)%j*f(39)+A(j,28)%j*f(40)+A(j,29)%j*f(41)+(A(j,38)%j+A(j,53)%j)*f(42)+(-A(j,24)%j-A(j,51)%j)*f(43)+(A(j,25)%j &
       +A(j,39)%j-A(j,49)%j+A(j,52)%j+A(j,54)%j)*f(44)+(A(j,34)%j+A(j,57)%j+A(j,89)%j)*f(45)+(-A(j,32)%j-A(j,59)%j &
       -A(j,81)%j)*f(46)+(A(j,33)%j+A(j,35)%j+A(j,58)%j+A(j,60)%j+A(j,71)%j-A(j,73)%j+A(j,82)%j+A(j,90)%j)*f(47)-A(j,42)%j*f(48) &
       +A(j,43)%j*f(49)+(A(j,55)%j+A(j,87)%j)*f(50)+(-A(j,30)%j-A(j,79)%j)*f(51)+(A(j,31)%j+A(j,56)%j-A(j,67)%j+A(j,80)%j &
       +A(j,88)%j)*f(52)+A(j,48)%j*f(54)-A(j,70)%j*f(55)+A(j,72)%j*f(56)


  M1(:)%hf = Hel(j)
  M2(:)%hf = Hel(j)

  !M(i) corresponds to \Gamma_{i} in Fabios thesis

end subroutine colourvectors


! **********************************************************************
subroutine colint(M, M2colint)
! M(i)   = <M|Ci> colour component of matrix element
! COLINT = <M|M>
!        = Sum_{i,j} <M|Ci> * <Ci|Cj> * <Cj|M>
!        = colour-summed squared matrix element
! K2(i,j) = <Ci|Cj>
! **********************************************************************
  use ol_colourmatrix_pptllj_eexuxtdbx_1_/**/REALKIND, only: K1
  implicit none

  complex(REALKIND), intent(in)  :: M(1)
  real(REALKIND),    intent(out) :: M2colint
  integer :: i, j

  M2colint = 0

    do i = 1, 1
      do j = 1, 1
        M2colint = M2colint + real(conjg(M(i))*K1(i,j)*M(j))
      end do
    end do

end subroutine colint

! **********************************************************************
subroutine colint_ct(M, Mct, M2colint_ct, l)
! M(i)   = <M|Ci> colour component of matrix element
! COLINT = <M|M>
!        = Sum_{i,j} <M|Ci> * <Ci|Cj> * <Cj|M>
!        = colour-summed squared matrix element
! K2(i,j) = <Ci|Cj>
! **********************************************************************
  use ol_colourmatrix_pptllj_eexuxtdbx_1_/**/REALKIND, only: K2
  implicit none
  complex(REALKIND), intent(in)  :: M(1), Mct(1)
  real(REALKIND),    intent(out) :: M2colint_ct
  integer, intent(in) :: l
  integer ::  i, j

  M2colint_ct = 0

  do i = 1, 1
    do j = 1, 1
      M2colint_ct = M2colint_ct + real(conjg(M(i))*K2(i+1*l,j)*Mct(j))
    end do
  end do

end subroutine colint_ct

! **********************************************************************
subroutine colint_IR(M, M2IRadd)
! M(i)   = <M|Ci> colour component of matrix element
! K1(i,j) = .....
! **********************************************************************
  use ol_colourmatrix_pptllj_eexuxtdbx_1_/**/REALKIND, only: K1
  implicit none

  complex(REALKIND), intent(in)  :: M(1)
  real(REALKIND),    intent(out) :: M2IRadd(22)
  integer ::  i, j, k, colmatpos

  M2IRadd = 0

  do k = 1, 1-1
    colmatpos = 1*k
    do i = 1, 1
      do j = 1, 1
	      M2IRadd(k) = M2IRadd(k) + real(conjg(M(i))*K1(i+colmatpos,j)*M(j))
      end do
    end do
  end do

end subroutine colint_IR

! **********************************************************************
subroutine colintmunu(M1, M2, M2colint)
! M1(i)    = <M1|Ci> colour component of matrix element
! M2(i)    = <M2|Ci> colour component of matrix element
! M2colint = <M1|M2>
!          = Sum_{i,j} <M1|Ci> * <Ci|Cj> * <Cj|M2>
!          = colour-summed squared matrix element
! K2(i,j) = <Ci|Cj>
! **********************************************************************
  use ol_colourmatrix_pptllj_eexuxtdbx_1_/**/REALKIND, only: K2
  implicit none

  complex(REALKIND), intent(in)  :: M1(1)
  complex(REALKIND), intent(in)  :: M2(1)
  complex(REALKIND),    intent(out) :: M2colint
  integer :: i, j

  M2colint = 0

  do i = 1, 1
    do j = 1, 1
      M2colint = M2colint + M1(i)*K2(i,j)*conjg(M2(j))
    end do
  end do

end subroutine colintmunu





! **********************************************************************
subroutine colborninterf(M, M0_col, l)
! M(i)         = <M|Ci> colour component of matrix element
! M0_col(i)    = <M2|Ci> colour component of matrix element,
!                see \tilde{M}_{j} in Fabios thesis
! M2colint = Sum_{i} <M1|Ci> * <Ci|Cj>
!          = colour-summed squared matrix element
! KL(i,j) = <Ci|Cj> with elements Cj of 1-loop colour basis
! **********************************************************************
  use ol_colourmatrix_pptllj_eexuxtdbx_1_/**/REALKIND, only: KL
  implicit none

  type(Hpolcont), intent(in)  :: M(1)
  type(Hpolcont), intent(out)  :: M0_col(2)
  integer, intent(in) :: l
  integer :: i, j

  do j = 1, 2 !size(KL(1,:))
    M0_col(j)%j = 0
    M0_col(j)%hf = M(1)%hf
    do i = 1, 1 !size(KL(:,1))
      M0_col(j)%j = M0_col(j)%j  + conjg(M(i)%j)*KL(i+1*l,j)
    end do
  end do

end subroutine colborninterf

end subroutine amp2

end module ol_loop_pptllj_eexuxtdbx_1_/**/REALKIND
