
module ol_colourmatrix_ppthjj_uxtdbxhg_1_/**/REALKIND
  use KIND_TYPES, only: REALKIND
  implicit none
  logical, save           :: colmat_not_initialised = .true.
  complex(REALKIND), save :: K1(46,2), K2(2,2), KL(2,4)
  contains
  subroutine colourmatrix_init
    use ol_parameters_decl_/**/REALKIND, only: CI
    implicit none
    colmat_not_initialised = .false.
    ! colour matrix

  K1( 1,:) = [  12,   0]
  K1( 2,:) = [   0,  12]
  K1( 3,:) = [  16,   0]
  K1( 4,:) = [   0,  16]
  K1( 5,:) = [   0,  -2]
  K1( 6,:) = [  -2,   0]
  K1( 7,:) = [  16,   0]
  K1( 8,:) = [   0,  16]
  K1( 9,:) = [   2,   0]
  K1(10,:) = [   0, -16]
  K1(11,:) = [   0,   2]
  K1(12,:) = [   2,   0]
  K1(13,:) = [  16,   0]
  K1(14,:) = [   0,  16]
  K1(15,:) = [   0,   2]
  K1(16,:) = [   2,   0]
  K1(17,:) = [ -16,   0]
  K1(18,:) = [   0,   2]
  K1(19,:) = [   0,  -2]
  K1(20,:) = [  -2,   0]
  K1(21,:) = [  16,   0]
  K1(22,:) = [   0,  16]
  K1(23,:) = [   0,   0]
  K1(24,:) = [   0,   0]
  K1(25,:) = [   0,   0]
  K1(26,:) = [   0,   0]
  K1(27,:) = [   0,   0]
  K1(28,:) = [   0,   0]
  K1(29,:) = [   0,   0]
  K1(30,:) = [   0,   0]
  K1(31,:) = [   0,   0]
  K1(32,:) = [   0,   0]
  K1(33,:) = [ -18,   0]
  K1(34,:) = [   0,   0]
  K1(35,:) = [   0,   0]
  K1(36,:) = [   0, -18]
  K1(37,:) = [ -18,   0]
  K1(38,:) = [   0,   0]
  K1(39,:) = [   0,   0]
  K1(40,:) = [   0, -18]
  K1(41,:) = [   0,   0]
  K1(42,:) = [   0,   0]
  K1(43,:) = [  36,   0]
  K1(44,:) = [   0,  36]
  K1(45,:) = [   0,   0]
  K1(46,:) = [   0,   0]

  K2(1,:) = [ 12,  0]
  K2(2,:) = [  0, 12]

  KL(1,:) = [  4, 12,  0,  4]
  KL(2,:) = [  4,  0, 12,  4]

  end subroutine colourmatrix_init
end module ol_colourmatrix_ppthjj_uxtdbxhg_1_/**/REALKIND



module ol_forced_parameters_ppthjj_uxtdbxhg_1_/**/REALKIND
  implicit none
  contains
  subroutine check_forced_parameters
    use ol_parameters_decl_/**/REALKIND
    use ol_loop_parameters_decl_/**/REALKIND
#ifndef PRECISION_dp
    use ol_loop_parameters_decl_/**/DREALKIND, only: LeadingColour, nc, nf, CKMORDER
#endif
    implicit none
    logical, save :: checks_not_written = .true.

    if (checks_not_written) then
    ! e.g.
    ! if (ME /= 0) write(*,101) 'ME = 0'
  if (CKMORDER /= 0) write(*,101) 'CKMORDER = 0'
  if (nc /= 3) write(*,101) 'nc = 3'
  if (nf /= 6) write(*,101) 'nf = 6'
  if (MU /= 0) write(*,101) 'MU = 0'
  if (MD /= 0) write(*,101) 'MD = 0'
  if (MS /= 0) write(*,101) 'MS = 0'
  if (MC /= 0) write(*,101) 'MC = 0'
  if (YU /= 0) write(*,101) 'YU = 0'
  if (YD /= 0) write(*,101) 'YD = 0'
  if (YS /= 0) write(*,101) 'YS = 0'
  if (YC /= 0) write(*,101) 'YC = 0'
  if (LeadingColour /= 0) write(*,101) 'LeadingColour = 0'
  if (wMT /= 0) write(*,101) 'wMT = 0'
  if (wMB /= 0) write(*,101) 'wMB = 0'
  if (wMH /= 0) write(*,101) 'wMH = 0'


    checks_not_written = .false.
    end if

    101 format('[OpenLoops] === WARNING ===',/,'[OpenLoops] code was generated with ',A,/,'[OpenLoops] ===============')
  end subroutine check_forced_parameters
end module ol_forced_parameters_ppthjj_uxtdbxhg_1_/**/REALKIND
! **********************************************************************
module ol_loop_storage_ppthjj_uxtdbxhg_1_/**/REALKIND
! **********************************************************************
  use KIND_TYPES, only: REALKIND, intkind1, intkind2  
  use ol_data_types_/**/REALKIND, only: wfun, Hpolcont
  
#ifdef PRECISION_dp
  integer(intkind1), save :: ntry = 1, ntryL = 1
  integer(intkind1), save :: p_switch = 0 ! switch for dp or qp. Used for memory allocation of the OL types 
  ! the following are flags for memory allocation of the hol coefficients in dp or qp 
  logical, save :: dp_not_alloc = .TRUE., qp_not_alloc = .TRUE.
  integer(intkind2), parameter :: nheltot = 32 ! number of helicity configurations
  integer(intkind2), save :: nhel = 32 ! number of non-vanishing helicity configurations (adapted at runtime)
  integer(intkind2), save :: Hel(32) ! physical helicity states
#endif

  complex(REALKIND), save :: den(169)

  ! external wave functions ex1(h1),... for h<n> helicities
  type(wfun) :: ex1(2), ex2(2), ex3(2), ex4(2), ex5(1), ex6(2)

  ! wf<h>(h,n) n wave functions with h helicity configurations
  type(wfun) :: wf2(2,13), wf4(4,79), wf8(8,96), wf16(16,24), wf32(32,136)

  ! diagram prefactors
  integer,           save :: fac_status_loop1 = -1, fac_status_loop2 = -1
  complex(REALKIND), save :: f(45), c(22)

  !below the colour vector for Born-Loop interference
  type(Hpolcont),   save :: M0_col1_helarray(4,32)

end module ol_loop_storage_ppthjj_uxtdbxhg_1_/**/REALKIND






! **********************************************************************
module ol_loop_ppthjj_uxtdbxhg_1_/**/REALKIND
! **********************************************************************
  use KIND_TYPES, only: REALKIND, DREALKIND, intkind1, intkind2  
  use ol_data_types_/**/REALKIND, only: wfun, Hpolcont
  use ol_loop_storage_ppthjj_uxtdbxhg_1_/**/REALKIND
  implicit none

!*********************************************************************************
  contains

! **********************************************************************
subroutine fac_init_loop()
! Writes diagram prefactors to 'f', rsp. 'c'
! **********************************************************************
  use ol_parameters_decl_/**/REALKIND
  use ol_loop_parameters_decl_/**/REALKIND
  use ol_init, only: set_parameter, tree_parameters_flush, parameters_flush
#ifndef PRECISION_dp
  use ol_loop_parameters_decl_/**/DREALKIND, only: SwF, SwB
!  use ol_loop_parameters_decl_/**/DREALKIND, only: DOI
#endif
  implicit none
  call set_parameter("ew_renorm", 0)
  if (parameters_status == 0) call tree_parameters_flush()
  if (loop_parameters_status == 0) call parameters_flush()
  fac_status_loop1 = parameters_status
  fac_status_loop2 = loop_parameters_status
  ! factors of the diagrams
    f( 1) = (CI*countertermnorm*ctSqq*eQED**3*gQCD**3*MH**2)/(4._/**/REALKIND*MW**3*sw**3)
    f( 2) = (CI*eQED**3*gQCD)/(4._/**/REALKIND*MW*sw**3)
    f( 3) = (CI*countertermnorm*eQED**3*gQCD**3)/(4._/**/REALKIND*MW*sw**3)
    f( 4) = (CI*countertermnorm*ctGbb*eQED**3*gQCD**3)/(4._/**/REALKIND*MW*sw**3)
    f( 5) = (CI*countertermnorm*ctGqq*eQED**3*gQCD**3)/(4._/**/REALKIND*MW*sw**3)
    f( 6) = (CI*countertermnorm*ctGtt*eQED**3*gQCD**3)/(4._/**/REALKIND*MW*sw**3)
    f( 7) = (CI*countertermnorm*ctSqq*eQED**3*gQCD**3)/(4._/**/REALKIND*MW*sw**3)
    f( 8) = (CI*countertermnorm*ctVqq*eQED**3*gQCD**3)/(4._/**/REALKIND*MW*sw**3)
    f( 9) = (CI*eQED**3*gQCD*lambdaHWW*MW)/(2._/**/REALKIND*sw**3)
    f(10) = (CI*countertermnorm*eQED**3*gQCD**3*lambdaHWW*MW)/(2._/**/REALKIND*sw**3)
    f(11) = (CI*countertermnorm*ctGbb*eQED**3*gQCD**3*lambdaHWW*MW)/(2._/**/REALKIND*sw**3)
    f(12) = (CI*countertermnorm*ctGqq*eQED**3*gQCD**3*lambdaHWW*MW)/(2._/**/REALKIND*sw**3)
    f(13) = (CI*countertermnorm*ctGtt*eQED**3*gQCD**3*lambdaHWW*MW)/(2._/**/REALKIND*sw**3)
    f(14) = (CI*countertermnorm*ctVbt*eQED**3*gQCD**3*lambdaHWW*MW)/(2._/**/REALKIND*sw**3)
    f(15) = (CI*countertermnorm*ctVqq*eQED**3*gQCD**3*lambdaHWW*MW)/(2._/**/REALKIND*sw**3)
    f(16) = (CI*eQED**3*gQCD**3*integralnorm*SwB)/(4._/**/REALKIND*MW*sw**3)
    f(17) = (eQED**3*gQCD**3*integralnorm*SwB)/(MW*sw**3*4._/**/REALKIND)
    f(18) = (CI*eQED**3*gQCD**3*integralnorm*lambdaHWW*MW*SwB)/(2._/**/REALKIND*sw**3)
    f(19) = (eQED**3*gQCD**3*integralnorm*lambdaHWW*MW*SwB)/(sw**3*2._/**/REALKIND)
    f(20) = (CI*countertermnorm*ctSqq*eQED**3*gQCD**3*YB)/(4._/**/REALKIND*MW**3*sw**3)
    f(21) = (CI*eQED**3*gQCD*YB)/(4._/**/REALKIND*MW*sw**3)
    f(22) = (CI*countertermnorm*eQED**3*gQCD**3*YB)/(4._/**/REALKIND*MW*sw**3)
    f(23) = (CI*countertermnorm*ctGbb*eQED**3*gQCD**3*YB)/(4._/**/REALKIND*MW*sw**3)
    f(24) = (CI*countertermnorm*ctGqq*eQED**3*gQCD**3*YB)/(4._/**/REALKIND*MW*sw**3)
    f(25) = (CI*countertermnorm*ctGtt*eQED**3*gQCD**3*YB)/(4._/**/REALKIND*MW*sw**3)
    f(26) = (CI*countertermnorm*ctSbb*eQED**3*gQCD**3*YB)/(4._/**/REALKIND*MW*sw**3)
    f(27) = (CI*countertermnorm*ctVbt*eQED**3*gQCD**3*YB)/(4._/**/REALKIND*MW*sw**3)
    f(28) = (CI*countertermnorm*ctVqq*eQED**3*gQCD**3*YB)/(4._/**/REALKIND*MW*sw**3)
    f(29) = (CI*countertermnorm*ctHGG*eQED**3*gQCD**3*MB*YB)/(2._/**/REALKIND*MQ2sum*sw**2)
    f(30) = (CI*eQED**3*gQCD**3*integralnorm*SwB*YB)/(4._/**/REALKIND*MW*sw**3)
    f(31) = (eQED**3*gQCD**3*integralnorm*SwB*YB)/(MW*sw**3*4._/**/REALKIND)
    f(32) = (eQED**3*gQCD**3*integralnorm*SwF*YB)/(MW*sw**3*4._/**/REALKIND)
    f(33) = (CI*countertermnorm*ctSqq*eQED**3*gQCD**3*YT)/(4._/**/REALKIND*MW**3*sw**3)
    f(34) = (CI*eQED**3*gQCD*YT)/(4._/**/REALKIND*MW*sw**3)
    f(35) = (CI*countertermnorm*eQED**3*gQCD**3*YT)/(4._/**/REALKIND*MW*sw**3)
    f(36) = (CI*countertermnorm*ctGbb*eQED**3*gQCD**3*YT)/(4._/**/REALKIND*MW*sw**3)
    f(37) = (CI*countertermnorm*ctGqq*eQED**3*gQCD**3*YT)/(4._/**/REALKIND*MW*sw**3)
    f(38) = (CI*countertermnorm*ctGtt*eQED**3*gQCD**3*YT)/(4._/**/REALKIND*MW*sw**3)
    f(39) = (CI*countertermnorm*ctStt*eQED**3*gQCD**3*YT)/(4._/**/REALKIND*MW*sw**3)
    f(40) = (CI*countertermnorm*ctVbt*eQED**3*gQCD**3*YT)/(4._/**/REALKIND*MW*sw**3)
    f(41) = (CI*countertermnorm*ctVqq*eQED**3*gQCD**3*YT)/(4._/**/REALKIND*MW*sw**3)
    f(42) = (CI*countertermnorm*ctHGG*eQED**3*gQCD**3*MT*YT)/(2._/**/REALKIND*MQ2sum*sw**2)
    f(43) = (CI*eQED**3*gQCD**3*integralnorm*SwB*YT)/(4._/**/REALKIND*MW*sw**3)
    f(44) = (eQED**3*gQCD**3*integralnorm*SwB*YT)/(MW*sw**3*4._/**/REALKIND)
    f(45) = (eQED**3*gQCD**3*integralnorm*SwF*YT)/(MW*sw**3*4._/**/REALKIND)

  c = [ 3*CI*f(16), 9*CI*f(16), f(17), 3*f(17), 8*f(17), 3*CI*f(18), 9*CI*f(18), f(19), 3*f(19), 8*f(19), 3*CI*f(30), 9*CI*f(30) &
    , f(31), 3*f(31), 8*f(31), 3*f(32), 3*CI*f(43), 9*CI*f(43), f(44), 3*f(44), 8*f(44), 3*f(45) ]
  c = (1._/**/REALKIND / 6) * c
end subroutine fac_init_loop

subroutine denominators()
  use ol_parameters_decl_/**/REALKIND ! masses
  use ol_momenta_decl_/**/REALKIND, only: L
  implicit none
  ! propagators
  den(1) = 1 /((L(5,5) - MW2)+L(6,5))
  den(2) = 1 /((L(5,18) - MT2)+L(6,18))
  den(3) = 1 /((L(5,40) - MB2)+L(6,40))
  den(6) = 1 /((L(5,13) - MT2)+L(6,13))
  den(9) = 1 /((L(5,34) - MT2)+L(6,34))
  den(10) = 1 /((L(5,24) - MB2)+L(6,24))
  den(13) = 1 /((L(5,7) - MB2)+L(6,7))
  den(17) = 1 /((L(5,42) - MW2)+L(6,42))
  den(23) = 1 /((L(5,33))+L(6,33))
  den(24) = 1 /((L(5,10) - MW2)+L(6,10))
  den(25) = 1 /((L(5,37) - MW2)+L(6,37))
  den(28) = 1 /((L(5,36))+L(6,36))
  den(33) = 1 /((L(5,26) - MW2)+L(6,26))
  den(37) = 1 /((L(5,48))+L(6,48))
  den(39) = 1 /((L(5,50) - MT2)+L(6,50))
  den(44) = 1 /((L(5,21) - MW2)+L(6,21))
  den(49) = 1 /((L(5,11))+L(6,11))
  den(52) = 1 /((L(5,49))+L(6,49))
  den(59) = 1 /((L(5,56) - MB2)+L(6,56))
  den(70) = 1 /((L(5,45) - MT2)+L(6,45))
  den(73) = 1 /((L(5,23) - MB2)+L(6,23))
  den(80) = 1 /((L(5,29) - MT2)+L(6,29))
  den(83) = 1 /((L(5,39) - MB2)+L(6,39))
  den(109) = 1 /((L(5,15))+L(6,15))
  den(119) = 1 /((L(5,14))+L(6,14))
  den(122) = 1 /((L(5,27))+L(6,27))
  den(124) = 1 /((L(5,30))+L(6,30))
  den(127) = 1 /((L(5,58) - MW2)+L(6,58))
  den(139) = 1 /((L(5,53) - MW2)+L(6,53))

  ! denominators
  den(4) = den(1)*den(2)
  den(5) = den(3)*den(4)
  den(7) = den(1)*den(6)
  den(8) = den(2)*den(7)
  den(11) = den(1)*den(9)
  den(12) = den(10)*den(11)
  den(14) = den(1)*den(13)
  den(15) = den(10)*den(14)
  den(16) = den(7)*den(9)
  den(18) = den(9)*den(17)
  den(19) = den(1)*den(18)
  den(20) = den(3)*den(14)
  den(21) = den(3)*den(17)
  den(22) = den(1)*den(21)
  den(26) = den(23)*den(25)
  den(27) = den(24)*den(26)
  den(29) = den(25)*den(28)
  den(30) = den(24)*den(29)
  den(31) = den(2)*den(26)
  den(32) = den(2)*den(29)
  den(34) = den(10)*den(33)
  den(35) = den(23)*den(34)
  den(36) = den(10)*den(29)
  den(38) = den(14)*den(37)
  den(40) = den(37)*den(39)
  den(41) = den(1)*den(40)
  den(42) = den(2)*den(39)
  den(43) = den(1)*den(42)
  den(45) = den(1)*den(44)
  den(46) = den(9)*den(45)
  den(47) = den(9)*den(39)
  den(48) = den(1)*den(47)
  den(50) = den(24)*den(49)
  den(51) = den(37)*den(50)
  den(53) = den(37)*den(52)
  den(54) = den(24)*den(53)
  den(55) = den(24)*den(33)
  den(56) = den(23)*den(55)
  den(57) = den(2)*den(33)
  den(58) = den(23)*den(57)
  den(60) = den(10)*den(59)
  den(61) = den(1)*den(60)
  den(62) = den(3)*den(45)
  den(63) = den(3)*den(59)
  den(64) = den(1)*den(63)
  den(65) = den(10)*den(26)
  den(66) = den(28)*den(55)
  den(67) = den(28)*den(57)
  den(68) = den(28)*den(34)
  den(69) = den(1)*den(3)
  den(71) = den(69)*den(70)
  den(72) = den(2)*den(71)
  den(74) = den(4)*den(73)
  den(75) = den(3)*den(74)
  den(76) = den(2)**2
  den(77) = den(7)*den(76)
  den(78) = den(7)*den(42)
  den(79) = den(1)*den(10)
  den(81) = den(79)*den(80)
  den(82) = den(9)*den(81)
  den(84) = den(11)*den(83)
  den(85) = den(10)*den(84)
  den(86) = den(14)*den(60)
  den(87) = den(10)**2
  den(88) = den(14)*den(87)
  den(89) = den(9)**2
  den(90) = den(45)*den(89)
  den(91) = den(7)*den(89)
  den(92) = den(7)*den(47)
  den(93) = den(3)**2
  den(94) = den(45)*den(93)
  den(95) = den(14)*den(63)
  den(96) = den(14)*den(93)
  den(97) = den(23)**2
  den(98) = den(55)*den(97)
  den(99) = den(28)**2
  den(100) = den(55)*den(99)
  den(101) = den(57)*den(97)
  den(102) = den(26)*den(76)
  den(103) = den(57)*den(99)
  den(104) = den(29)*den(76)
  den(105) = den(34)*den(97)
  den(106) = den(26)*den(87)
  den(107) = den(34)*den(99)
  den(108) = den(29)*den(87)
  den(110) = den(14)*den(109)
  den(111) = den(14)*den(73)
  den(112) = den(14)*den(83)
  den(113) = den(7)*den(109)
  den(114) = den(7)*den(80)
  den(115) = den(7)*den(70)
  den(116) = den(45)*den(73)
  den(117) = den(45)*den(80)
  den(118) = den(50)*den(109)
  den(120) = den(24)*den(119)
  den(121) = den(109)*den(120)
  den(123) = den(55)*den(122)
  den(125) = den(55)*den(124)
  den(126) = den(2)*den(3)
  den(128) = den(126)*den(127)
  den(129) = den(57)*den(122)
  den(130) = den(57)*den(124)
  den(131) = den(42)*den(127)
  den(132) = den(9)*den(10)
  den(133) = den(127)*den(132)
  den(134) = den(34)*den(122)
  den(135) = den(34)*den(124)
  den(136) = den(60)*den(127)
  den(137) = den(26)*den(83)
  den(138) = den(26)*den(70)
  den(140) = den(26)*den(139)
  den(141) = den(18)*den(127)
  den(142) = den(47)*den(127)
  den(143) = den(29)*den(83)
  den(144) = den(29)*den(70)
  den(145) = den(29)*den(139)
  den(146) = den(21)*den(127)
  den(147) = den(63)*den(127)
  den(148) = den(1)*den(2)*den(3)
  den(149) = den(1)*den(9)*den(10)
  den(150) = den(2)*den(23)
  den(151) = den(2)*den(28)
  den(152) = den(10)*den(23)
  den(153) = den(10)*den(28)
  den(154) = den(2)*den(115)
  den(155) = den(10)*den(112)
  den(156) = den(9)*den(114)
  den(157) = den(9)*den(117)
  den(158) = den(3)*den(111)
  den(159) = den(3)*den(116)
  den(160) = den(23)*den(125)
  den(161) = den(28)*den(123)
  den(162) = den(2)*den(138)
  den(163) = den(23)*den(130)
  den(164) = den(2)*den(144)
  den(165) = den(28)*den(129)
  den(166) = den(10)*den(137)
  den(167) = den(23)*den(135)
  den(168) = den(10)*den(143)
  den(169) = den(28)*den(134)

end subroutine denominators

!
!
!
!
!
! **********************************************************************
#ifdef PRECISION_dp
subroutine amp2(P_scatt, M02, M2ct, M2colint, qp_kinematics)
#else
subroutine amp2(P_scatt, M02, M2ct, M2colint, qp_kinematics)
  use ol_loop_storage_ppthjj_uxtdbxhg_1_/**/DREALKIND, only: ntry, nhel, Hel
#endif
! P_scatt(0:3,Npart) = incoming external momenta
! M2  = helicity-summed squared matrix element for anti-up top down anti-bottom higgs glue -> 0
! **********************************************************************
  use ol_parameters_decl_/**/REALKIND !, only: ci, parameters_status, ZERO, scalefactor, >masses<
  use ol_parameters_init_/**/REALKIND, only: ensure_mp_init
  use ol_kinematics_/**/REALKIND, only: init_kinematics
  use ol_momenta_decl_/**/DREALKIND, only: momenta_nan_check
  use ol_data_types_/**/REALKIND
  use ol_h_helicity_bookkeeping_/**/REALKIND, only: &
    & helbookkeeping_wf, helsync, flip_phase
  use ol_helicity_init, only: helbookkeeping_flip, helsync_flip
  use ol_hel_propagators_/**/REALKIND
  use ol_hel_wavefunctions_/**/REALKIND
  use ol_wavefunctions_/**/REALKIND, only: wf_V_Std
  use ol_hel_vertices_/**/REALKIND
  use ol_hel_contractions_/**/REALKIND
  use ol_external_ppthjj_uxtdbxhg_1, only: external_perm_ppthjj_uxtdbxhg_1, &
    & external_perm_inv_ppthjj_uxtdbxhg_1, extcomb_perm_ppthjj_uxtdbxhg_1, &
    & average_factor_ppthjj_uxtdbxhg_1
  use ol_external_ppthjj_uxtdbxhg_1, only: H, hel_not_initialised, hel_init, POLSEL
  use ol_colourmatrix_ppthjj_uxtdbxhg_1_/**/REALKIND, only: colmat_not_initialised, colourmatrix_init
  use ol_forced_parameters_ppthjj_uxtdbxhg_1_/**/REALKIND, only: check_forced_parameters
  use ol_heltables_OLR_ppthjj_uxtdbxhg_1
  use ol_kinematics_/**/REALKIND, only: LC2Std_Rep_cmplx
  use ol_h_counterterms_/**/REALKIND
  use ol_loop_parameters_decl_/**/REALKIND ! counterterms
  use ol_loop_parameters_decl_/**/DREALKIND, only: IR_is_on
  use ol_init, only: set_parameter, parameters_flush
#ifdef PRECISION_dp
  use ol_kinematics_/**/QREALKIND, only: conv_mom_scatt2in_qp=>conv_mom_scatt2in, &
                                         internal_momenta_qp=>internal_momenta
  use ol_momenta_decl_/**/DREALKIND, only: L
  use ol_momenta_decl_/**/QREALKIND, only: L_qp=>L
#endif
  implicit none

  real(DREALKIND), intent(in)  :: P_scatt(0:3,6)
  real(REALKIND),  intent(out) :: M02, M2ct, M2colint(22)
  logical, intent(in) :: qp_kinematics

  integer           :: shift, k, r, m, n
  real(REALKIND)    :: P(0:3,6)
#ifdef PRECISION_dp
  real(QREALKIND)    :: P_qp(0:3,6)
#endif
  integer           :: extmasses2(6)
  real(REALKIND)    :: M2add, M2add_ct, M2add_colint(22)
  complex(REALKIND) :: M1(2), M2(2) 
  real(REALKIND)    :: P_scatt_intern(0:3,6)
  real(REALKIND), save :: scalebackfactor, old_scalefactor = 0
  integer(intkind1) :: nsync
  type(Hpolcont),   save :: M1helarray(2,32)
  type(Hpolcont) :: M1helarray_ct(2,32)

  type(Hpolcont) :: A(32,136)

  !Aj are not used at the moment
  !complex(REALKIND) :: Aj(136)

  complex(REALKIND) :: omega(2) ! phases for helicity correlations

  call set_parameter("ew_renorm", 0)
  call parameters_flush()
  call ensure_mp_init()

  if (colmat_not_initialised) call colourmatrix_init()

  if (fac_status_loop1 /= parameters_status .or. fac_status_loop2 /= loop_parameters_status) then
    ! Note: if fac_init would only be called when parameters changed which are relevant for the factors,
    ! a different 'status' would have to be used, because forced_parameters should be called after every parameter change.
    call check_forced_parameters()
    call fac_init_loop()
  end if

  if (momenta_nan_check(P_scatt) /= 0) then
    M02 = 0
    return
  end if

  extmasses2 = [ 0, nMT, 0, nMB, nMH, 0 ]
  ! Convert 2 -> n-2 PS-point to n -> 0 (so that P(1) + ... + P(n) = 0) and compute
  ! internal-propagator momenta in light-cone representation
  call init_kinematics(P_scatt, extmasses2, P, external_perm_inv_ppthjj_uxtdbxhg_1, 6, qp_kinematics)

  ! denominators
  call denominators()

   if (heltables_not_init) call init_heltables()

  ! external WFs
  ! Here the external wavefunctions are initialiased
  call pol_wf_A(P(:,1), rZERO, H1, ex1, POLSEL(1),1)
  call pol_wf_Q(P(:,2), rMT, H2, ex2, POLSEL(2),2)
  call pol_wf_Q(P(:,3), rZERO, H3, ex3, POLSEL(3),3)
  call pol_wf_A(P(:,4), rMB, H4, ex4, POLSEL(4),4)
  call pol_wf_S(P(:,5), rMH, H5, ex5, POLSEL(5),5)
  call pol_wf_V(P(:,6), rZERO, H6, ex6, POLSEL(6),6)



  ! internal WFs
  ! e.g. call vert_VQ_A(ntry, ex3, ex1, wf1, n1, t1) ...
  call vert_QA_W(ntry, ex3(:), ex1(:), wf4(:,1), n3(:,1), t3x4(:,:,1))
  call vert_QS_A(gH,ntry, ex2(:), ex5(:), wf2(:,1), n3(:,2), t3x2(:,:,1))
  call vert_AV_Q(ntry, ex4(:), ex6(:), wf4(:,2), n3(:,3), t3x4(:,:,2))
  call prop_Q_A(ntry, wf2(:,1), 18, MT, 1_intkind1, wf2(:,2), n2(1))
  call prop_A_Q(ntry, wf4(:,2), 40, MB, 1_intkind1, wf4(:,3), n2(2))
  call vert_WQ_A(ntry, wf4(:,1), wf2(:,2), wf8(:,1), n3(:,4), t3x8(:,:,1))
  call vert_AW_Q(ntry, ex4(:), wf4(:,1), wf8(:,2), n3(:,5), t3x8(:,:,2))
  call vert_VQ_A(ntry, ex6(:), wf2(:,2), wf4(:,4), n3(:,6), t3x4(:,:,3))
  call prop_A_Q(ntry, wf8(:,2), 13, MT, 1_intkind1, wf8(:,3), n2(3))
  call vert_VQ_A(ntry, ex6(:), ex2(:), wf4(:,5), n3(:,7), t3x4(:,:,4))
  call vert_SA_Q(gH,ntry, ex5(:), ex4(:), wf2(:,3), n3(:,8), t3x2(:,:,2))
  call prop_Q_A(ntry, wf4(:,5), 34, MT, 1_intkind1, wf4(:,6), n2(4))
  call prop_A_Q(ntry, wf2(:,3), 24, MB, 1_intkind1, wf2(:,4), n2(5))
  call vert_WQ_A(ntry, wf4(:,1), wf4(:,6), wf16(:,1), n3(:,9), t3x16(:,:,1))
  call vert_WQ_A(ntry, wf4(:,1), ex2(:), wf8(:,4), n3(:,10), t3x8(:,:,3))
  call vert_AV_Q(ntry, wf2(:,4), ex6(:), wf4(:,7), n3(:,11), t3x4(:,:,5))
  call prop_Q_A(ntry, wf8(:,4), 7, MB, 1_intkind1, wf8(:,5), n2(6))
  call vert_QS_A(gH,ntry, wf4(:,6), ex5(:), wf4(:,8), n3(:,12), t3x4(:,:,6))
  call vert_AQ_S(gPbt,ntry, ex4(:), wf4(:,6), wf8(:,6), n3(:,13), t3x8(:,:,4))
  call vert_TV_S(ntry, ex5(:), 16, wf4(:,1), 5, wf4(:,9), n3(:,14), t3x4(:,:,7))
  call vert_QA_W(ntry, wf4(:,6), ex4(:), wf8(:,7), n3(:,15), t3x8(:,:,5))
  call vert_SV_V(ntry, ex5(:), wf4(:,1), wf4(:,10), n3(:,16), t3x4(:,:,8))
  call vert_SA_Q(gH,ntry, ex5(:), wf4(:,3), wf4(:,11), n3(:,17), t3x4(:,:,9))
  call vert_AQ_S(gPbt,ntry, wf4(:,3), ex2(:), wf8(:,8), n3(:,18), t3x8(:,:,6))
  call vert_QA_W(ntry, ex2(:), wf4(:,3), wf8(:,9), n3(:,19), t3x8(:,:,7))
  call vert_AV_Q(ntry, ex1(:), ex6(:), wf4(:,12), n3(:,20), t3x4(:,:,10))
  call vert_AQ_S(gPbt,ntry, ex4(:), ex2(:), wf4(:,13), n3(:,21), t3x4(:,:,11))
  call prop_A_Q(ntry, wf4(:,12), 33, ZERO, 0_intkind1, wf4(:,14), n2(7))
  call vert_QA_W(ntry, ex3(:), wf4(:,14), wf8(:,10), n3(:,22), t3x8(:,:,8))
  call vert_ST_V(ntry, wf4(:,13), 10, ex5(:), 16, wf4(:,15), n3(:,23), t3x4(:,:,12))
  call vert_QA_W(ntry, ex2(:), ex4(:), wf4(:,16), n3(:,24), t3x4(:,:,13))
  call vert_SV_V(ntry, ex5(:), wf4(:,16), wf4(:,17), n3(:,25), t3x4(:,:,14))
  call vert_VQ_A(ntry, ex6(:), ex3(:), wf4(:,18), n3(:,26), t3x4(:,:,15))
  call prop_Q_A(ntry, wf4(:,18), 36, ZERO, 0_intkind1, wf4(:,19), n2(8))
  call vert_QA_W(ntry, wf4(:,19), ex1(:), wf8(:,11), n3(:,27), t3x8(:,:,9))
  call vert_QA_W(ntry, wf2(:,2), ex4(:), wf4(:,20), n3(:,28), t3x4(:,:,16))
  call vert_QA_W(ntry, ex2(:), wf2(:,4), wf4(:,21), n3(:,29), t3x4(:,:,17))
  call counter_WQ_A(ntry, wf4(:,1), wf2(:,2), wf8(:,12), n3(:,30), t3x8(:,:,10))
  call counter_VQ_A(ntry, ex6(:), wf2(:,2), wf4(:,22), n3(:,31), t3x4(:,:,18))
  call counter_WQ_A(ntry, wf4(:,1), wf4(:,6), wf16(:,2), n3(:,32), t3x16(:,:,2))
  call counter_AV_Q(ntry, wf2(:,4), ex6(:), wf4(:,23), n3(:,33), t3x4(:,:,19))
  call counter_QS_A(gH,ntry, wf4(:,6), ex5(:), wf4(:,24), n3(:,34), t3x4(:,:,20))
  call counter_SA_Q(gH,ntry, ex5(:), wf4(:,3), wf4(:,25), n3(:,35), t3x4(:,:,21))
  call counter_SG_G(ntry, ex5(:), ex6(:), wf2(:,5), n3(:,36), t3x2(:,:,3))
  call vert_AV_Q(ntry, ex4(:), wf2(:,5), wf4(:,26), n3(:,37), t3x4(:,:,22))
  call vert_VQ_A(ntry, wf2(:,5), ex2(:), wf4(:,27), n3(:,38), t3x4(:,:,23))
  call prop_Q_A(ntry, wf4(:,27), 50, MT, 1_intkind1, wf4(:,28), n2(9))
  call counter_AW_Q(ntry, ex4(:), wf4(:,1), wf8(:,13), n3(:,39), t3x8(:,:,11))
  call prop_Q_A(ntry, wf4(:,4), 50, MT, 1_intkind1, wf4(:,29), n2(10))
  call counter_AV_Q(ntry, ex4(:), ex6(:), wf4(:,30), n3(:,40), t3x4(:,:,24))
  call prop_A_Q(ntry, wf4(:,30), 40, MB, 1_intkind1, wf4(:,31), n2(11))
  call counter_AQ_S(ctSbt,ntry, ex4(:), wf4(:,6), wf8(:,14), n3(:,41), t3x8(:,:,12))
  call counter_QA_W(ntry, wf4(:,6), ex4(:), wf8(:,15), n3(:,42), t3x8(:,:,13))
  call prop_Q_A(ntry, wf4(:,8), 50, MT, 1_intkind1, wf4(:,32), n2(12))
  call vert_SA_Q(gH,ntry, ex5(:), wf4(:,31), wf4(:,33), n3(:,43), t3x4(:,:,25))
  call vert_AQ_S(gPbt,ntry, wf4(:,31), ex2(:), wf8(:,16), n3(:,44), t3x8(:,:,14))
  call vert_QA_W(ntry, ex2(:), wf4(:,31), wf8(:,17), n3(:,45), t3x8(:,:,15))
  call counter_SA_Q(gH,ntry, ex5(:), ex4(:), wf2(:,6), n3(:,46), t3x2(:,:,4))
  call prop_A_Q(ntry, wf2(:,6), 24, MB, 1_intkind1, wf2(:,7), n2(13))
  call vert_AV_Q(ntry, wf2(:,7), ex6(:), wf4(:,34), n3(:,47), t3x4(:,:,26))
  call vert_AW_Q(ntry, ex1(:), wf4(:,16), wf8(:,18), n3(:,48), t3x8(:,:,16))
  call vert_VQ_A(ntry, wf2(:,5), ex3(:), wf4(:,35), n3(:,49), t3x4(:,:,27))
  call prop_A_Q(ntry, wf8(:,18), 11, ZERO, 0_intkind1, wf8(:,19), n2(14))
  call vert_AV_Q(ntry, ex1(:), wf2(:,5), wf4(:,36), n3(:,50), t3x4(:,:,28))
  call vert_WQ_A(ntry, wf4(:,16), ex3(:), wf8(:,20), n3(:,51), t3x8(:,:,17))
  call prop_A_Q(ntry, wf4(:,36), 49, ZERO, 0_intkind1, wf4(:,37), n2(15))
  call counter_QA_W(ntry, wf2(:,2), ex4(:), wf4(:,38), n3(:,52), t3x4(:,:,29))
  call vert_QA_W(ntry, ex2(:), wf2(:,7), wf4(:,39), n3(:,53), t3x4(:,:,30))
  call vert_SS_S(ntry, wf4(:,13), ex5(:), wf4(:,40), n3(:,54), t3x4(:,:,31))
  call counter_AQ_S(gPud,ntry, wf4(:,14), ex3(:), wf8(:,21), n3(:,55), t3x8(:,:,18))
  call counter_QA_W(ntry, ex3(:), wf4(:,14), wf8(:,22), n3(:,56), t3x8(:,:,19))
  call vert_TV_S(ntry, ex5(:), 16, wf4(:,16), 10, wf4(:,41), n3(:,57), t3x4(:,:,32))
  call counter_VQ_A(ntry, ex6(:), ex3(:), wf4(:,42), n3(:,58), t3x4(:,:,33))
  call prop_Q_A(ntry, wf4(:,42), 36, ZERO, 0_intkind1, wf4(:,43), n2(16))
  call vert_QA_W(ntry, wf4(:,43), ex1(:), wf8(:,23), n3(:,59), t3x8(:,:,20))
  call vert_AQ_S(gPbt,ntry, ex4(:), wf2(:,2), wf4(:,44), n3(:,60), t3x4(:,:,34))
  call vert_AQ_S(gPbt,ntry, wf2(:,4), ex2(:), wf4(:,45), n3(:,61), t3x4(:,:,35))
  call counter_WQ_A(ntry, wf4(:,1), ex2(:), wf8(:,24), n3(:,62), t3x8(:,:,21))
  call prop_A_Q(ntry, wf4(:,7), 56, MB, 1_intkind1, wf4(:,46), n2(17))
  call counter_VQ_A(ntry, ex6(:), ex2(:), wf4(:,47), n3(:,63), t3x4(:,:,36))
  call prop_Q_A(ntry, wf4(:,47), 34, MT, 1_intkind1, wf4(:,48), n2(18))
  call vert_WQ_A(ntry, wf4(:,1), wf4(:,48), wf16(:,3), n3(:,64), t3x16(:,:,3))
  call counter_AQ_S(ctSbt,ntry, wf4(:,3), ex2(:), wf8(:,25), n3(:,65), t3x8(:,:,22))
  call counter_QA_W(ntry, ex2(:), wf4(:,3), wf8(:,26), n3(:,66), t3x8(:,:,23))
  call prop_A_Q(ntry, wf4(:,11), 56, MB, 1_intkind1, wf4(:,49), n2(19))
  call vert_QS_A(gH,ntry, wf4(:,48), ex5(:), wf4(:,50), n3(:,67), t3x4(:,:,37))
  call vert_AQ_S(gPbt,ntry, ex4(:), wf4(:,48), wf8(:,27), n3(:,68), t3x8(:,:,24))
  call vert_QA_W(ntry, wf4(:,48), ex4(:), wf8(:,28), n3(:,69), t3x8(:,:,25))
  call counter_QS_A(gH,ntry, ex2(:), ex5(:), wf2(:,8), n3(:,70), t3x2(:,:,5))
  call prop_Q_A(ntry, wf2(:,8), 18, MT, 1_intkind1, wf2(:,9), n2(20))
  call vert_WQ_A(ntry, wf4(:,1), wf2(:,9), wf8(:,29), n3(:,71), t3x8(:,:,26))
  call vert_VQ_A(ntry, ex6(:), wf2(:,9), wf4(:,51), n3(:,72), t3x4(:,:,38))
  call counter_QA_W(ntry, ex2(:), wf2(:,4), wf4(:,52), n3(:,73), t3x4(:,:,39))
  call vert_QA_W(ntry, wf2(:,9), ex4(:), wf4(:,53), n3(:,74), t3x4(:,:,40))
  call counter_AQ_S(ctSbt,ntry, ex4(:), ex2(:), wf4(:,54), n3(:,75), t3x4(:,:,41))
  call vert_ST_V(ntry, wf4(:,54), 10, ex5(:), 16, wf4(:,55), n3(:,76), t3x4(:,:,42))
  call counter_QA_W(ntry, ex2(:), ex4(:), wf4(:,56), n3(:,77), t3x4(:,:,43))
  call vert_SV_V(ntry, ex5(:), wf4(:,56), wf4(:,57), n3(:,78), t3x4(:,:,44))
  call counter_AQ_S(gPud,ntry, ex1(:), wf4(:,19), wf8(:,30), n3(:,79), t3x8(:,:,27))
  call counter_QA_W(ntry, wf4(:,19), ex1(:), wf8(:,31), n3(:,80), t3x8(:,:,28))
  call counter_AV_Q(ntry, ex1(:), ex6(:), wf4(:,58), n3(:,81), t3x4(:,:,45))
  call prop_A_Q(ntry, wf4(:,58), 33, ZERO, 0_intkind1, wf4(:,59), n2(21))
  call vert_QA_W(ntry, ex3(:), wf4(:,59), wf8(:,32), n3(:,82), t3x8(:,:,29))
  call counter_AQ_S(gPud,ntry, ex1(:), ex3(:), wf4(:,60), n3(:,83), t3x4(:,:,46))
  call vert_QS_A(gPbt,ntry, wf2(:,2), wf4(:,60), wf8(:,33), n3(:,84), t3x8(:,:,30))
  call counter_QA_W(ntry, ex3(:), ex1(:), wf4(:,61), n3(:,85), t3x4(:,:,47))
  call vert_WQ_A(ntry, wf4(:,61), wf2(:,2), wf8(:,34), n3(:,86), t3x8(:,:,31))
  call vert_SA_Q(gPbt,ntry, wf4(:,60), ex4(:), wf8(:,35), n3(:,87), t3x8(:,:,32))
  call prop_A_Q(ntry, wf8(:,35), 13, MT, 1_intkind1, wf8(:,36), n2(22))
  call vert_AW_Q(ntry, ex4(:), wf4(:,61), wf8(:,37), n3(:,88), t3x8(:,:,33))
  call prop_A_Q(ntry, wf8(:,37), 13, MT, 1_intkind1, wf8(:,38), n2(23))
  call vert_QS_A(gPbt,ntry, wf4(:,6), wf4(:,60), wf16(:,4), n3(:,89), t3x16(:,:,4))
  call vert_WQ_A(ntry, wf4(:,61), wf4(:,6), wf16(:,5), n3(:,90), t3x16(:,:,5))
  call vert_QS_A(gPbt,ntry, ex2(:), wf4(:,60), wf8(:,39), n3(:,91), t3x8(:,:,34))
  call prop_Q_A(ntry, wf8(:,39), 7, MB, 1_intkind1, wf8(:,40), n2(24))
  call vert_WQ_A(ntry, wf4(:,61), ex2(:), wf8(:,41), n3(:,92), t3x8(:,:,35))
  call prop_Q_A(ntry, wf8(:,41), 7, MB, 1_intkind1, wf8(:,42), n2(25))
  call vert_SS_S(ntry, wf4(:,60), ex5(:), wf4(:,62), n3(:,93), t3x4(:,:,48))
  call vert_ST_V(ntry, wf4(:,60), 5, ex5(:), 16, wf4(:,63), n3(:,94), t3x4(:,:,49))
  call vert_TV_S(ntry, ex5(:), 16, wf4(:,61), 5, wf4(:,64), n3(:,95), t3x4(:,:,50))
  call vert_SV_V(ntry, ex5(:), wf4(:,61), wf4(:,65), n3(:,96), t3x4(:,:,51))
  call vert_AW_Q(ntry, wf4(:,3), wf4(:,1), wf16(:,6), n3(:,97), t3x16(:,:,6))
  call counter_Q_A(cttt,6,ntry, wf2(:,2), 18, wf2(:,10), n2(26))
  call prop_A_Q(ntry, wf16(:,6), 45, MT, 1_intkind1, wf16(:,7), n2(27))
  call counter_A_Q(ctbb,5,ntry, wf4(:,3), 40, wf4(:,66), n2(28))
  call prop_Q_A(ntry, wf8(:,1), 23, MB, 1_intkind1, wf8(:,43), n2(29))
  call prop_Q_A(ntry, wf2(:,10), 18, MT, 1_intkind1, wf2(:,11), n2(30))
  call vert_VQ_A(ntry, ex6(:), wf2(:,11), wf4(:,67), n3(:,98), t3x4(:,:,52))
  call counter_A_Q(cttt,6,ntry, wf8(:,3), 13, wf8(:,44), n2(31))
  call vert_AW_Q(ntry, wf2(:,4), wf4(:,1), wf8(:,45), n3(:,99), t3x8(:,:,36))
  call counter_Q_A(cttt,6,ntry, wf4(:,6), 34, wf4(:,68), n2(32))
  call prop_A_Q(ntry, wf8(:,45), 29, MT, 1_intkind1, wf8(:,46), n2(33))
  call counter_A_Q(ctbb,5,ntry, wf2(:,4), 24, wf2(:,12), n2(34))
  call prop_Q_A(ntry, wf16(:,1), 39, MB, 1_intkind1, wf16(:,8), n2(35))
  call counter_Q_A(ctbb,5,ntry, wf8(:,5), 7, wf8(:,47), n2(36))
  call prop_A_Q(ntry, wf2(:,12), 24, MB, 1_intkind1, wf2(:,13), n2(37))
  call vert_AV_Q(ntry, wf2(:,13), ex6(:), wf4(:,69), n3(:,100), t3x4(:,:,53))
  call prop_Q_A(ntry, wf4(:,68), 34, MT, 1_intkind1, wf4(:,70), n2(38))
  call vert_AQ_S(gPbt,ntry, ex4(:), wf4(:,70), wf8(:,48), n3(:,101), t3x8(:,:,37))
  call vert_QA_W(ntry, wf4(:,70), ex4(:), wf8(:,49), n3(:,102), t3x8(:,:,38))
  call vert_QS_A(gH,ntry, wf4(:,70), ex5(:), wf4(:,71), n3(:,103), t3x4(:,:,54))
  call prop_A_Q(ntry, wf4(:,66), 40, MB, 1_intkind1, wf4(:,72), n2(39))
  call vert_AQ_S(gPbt,ntry, wf4(:,72), ex2(:), wf8(:,50), n3(:,104), t3x8(:,:,39))
  call vert_QA_W(ntry, ex2(:), wf4(:,72), wf8(:,51), n3(:,105), t3x8(:,:,40))
  call vert_SA_Q(gH,ntry, ex5(:), wf4(:,72), wf4(:,73), n3(:,106), t3x4(:,:,55))
  call counter_A_Q(ctqq,2,ntry, wf4(:,14), 33, wf4(:,74), n2(40))
  call prop_A_Q(ntry, wf4(:,74), 33, ZERO, 0_intkind1, wf4(:,75), n2(41))
  call vert_QA_W(ntry, ex3(:), wf4(:,75), wf8(:,52), n3(:,107), t3x8(:,:,41))
  call counter_Q_A(ctqq,1,ntry, wf4(:,19), 36, wf4(:,76), n2(42))
  call prop_Q_A(ntry, wf4(:,76), 36, ZERO, 0_intkind1, wf4(:,77), n2(43))
  call vert_QA_W(ntry, wf4(:,77), ex1(:), wf8(:,53), n3(:,108), t3x8(:,:,42))
  call vert_QA_W(ntry, wf2(:,11), ex4(:), wf4(:,78), n3(:,109), t3x4(:,:,56))
  call vert_QA_W(ntry, ex2(:), wf2(:,13), wf4(:,79), n3(:,110), t3x4(:,:,57))
  call vert_QA_V(ntry, wf8(:,5), ex4(:), wf16(:,9), n3(:,111), t3x16(:,:,7))
  call vert_QS_A(gH,ntry, wf8(:,5), ex5(:), wf8(:,54), n3(:,112), t3x8(:,:,43))
  call prop_Q_A(ntry, wf8(:,54), 23, MB, 1_intkind1, wf8(:,55), n2(44))
  call vert_VQ_A(ntry, ex6(:), wf8(:,5), wf16(:,10), n3(:,113), t3x16(:,:,8))
  call prop_Q_A(ntry, wf16(:,10), 39, MB, 1_intkind1, wf16(:,11), n2(45))
  call vert_QA_V(ntry, ex2(:), wf8(:,3), wf16(:,12), n3(:,114), t3x16(:,:,9))
  call vert_SA_Q(gH,ntry, ex5(:), wf8(:,3), wf8(:,56), n3(:,115), t3x8(:,:,44))
  call prop_A_Q(ntry, wf8(:,56), 29, MT, 1_intkind1, wf8(:,57), n2(46))
  call vert_AV_Q(ntry, wf8(:,3), ex6(:), wf16(:,13), n3(:,116), t3x16(:,:,10))
  call prop_A_Q(ntry, wf16(:,13), 45, MT, 1_intkind1, wf16(:,14), n2(47))
  call vert_QS_A(gPbt,ntry, ex2(:), wf4(:,9), wf8(:,58), n3(:,117), t3x8(:,:,45))
  call prop_Q_A(ntry, wf8(:,58), 23, MB, 1_intkind1, wf8(:,59), n2(48))
  call vert_WQ_A(ntry, wf4(:,10), ex2(:), wf8(:,60), n3(:,118), t3x8(:,:,46))
  call prop_Q_A(ntry, wf8(:,60), 23, MB, 1_intkind1, wf8(:,61), n2(49))
  call vert_SA_Q(gPbt,ntry, wf4(:,9), ex4(:), wf8(:,62), n3(:,119), t3x8(:,:,47))
  call prop_A_Q(ntry, wf8(:,62), 29, MT, 1_intkind1, wf8(:,63), n2(50))
  call vert_AW_Q(ntry, ex4(:), wf4(:,10), wf8(:,64), n3(:,120), t3x8(:,:,48))
  call prop_A_Q(ntry, wf8(:,64), 29, MT, 1_intkind1, wf8(:,65), n2(51))
  call vert_QA_V(ntry, ex3(:), wf8(:,19), wf16(:,15), n3(:,121), t3x16(:,:,11))
  call prop_Q_A(ntry, wf8(:,20), 14, ZERO, 0_intkind1, wf8(:,66), n2(52))
  call vert_QA_V(ntry, wf8(:,66), ex1(:), wf16(:,16), n3(:,122), t3x16(:,:,12))
  call vert_AW_Q(ntry, ex1(:), wf4(:,15), wf8(:,67), n3(:,123), t3x8(:,:,49))
  call prop_A_Q(ntry, wf8(:,67), 27, ZERO, 0_intkind1, wf8(:,68), n2(53))
  call vert_AW_Q(ntry, ex1(:), wf4(:,17), wf8(:,69), n3(:,124), t3x8(:,:,50))
  call prop_A_Q(ntry, wf8(:,69), 27, ZERO, 0_intkind1, wf8(:,70), n2(54))
  call vert_WQ_A(ntry, wf4(:,15), ex3(:), wf8(:,71), n3(:,125), t3x8(:,:,51))
  call prop_Q_A(ntry, wf8(:,71), 30, ZERO, 0_intkind1, wf8(:,72), n2(55))
  call vert_WQ_A(ntry, wf4(:,17), ex3(:), wf8(:,73), n3(:,126), t3x8(:,:,52))
  call prop_Q_A(ntry, wf8(:,73), 30, ZERO, 0_intkind1, wf8(:,74), n2(56))
  call vert_QA_W(ntry, wf2(:,2), wf4(:,3), wf8(:,75), n3(:,127), t3x8(:,:,53))
  call vert_AW_Q(ntry, ex1(:), wf4(:,20), wf8(:,76), n3(:,128), t3x8(:,:,54))
  call prop_A_Q(ntry, wf8(:,76), 27, ZERO, 0_intkind1, wf8(:,77), n2(57))
  call vert_WQ_A(ntry, wf4(:,20), ex3(:), wf8(:,78), n3(:,129), t3x8(:,:,55))
  call prop_Q_A(ntry, wf8(:,78), 30, ZERO, 0_intkind1, wf8(:,79), n2(58))
  call vert_QA_W(ntry, wf4(:,29), ex4(:), wf8(:,80), n3(:,130), t3x8(:,:,56))
  call vert_QA_W(ntry, wf4(:,6), wf2(:,4), wf8(:,81), n3(:,131), t3x8(:,:,57))
  call vert_AW_Q(ntry, ex1(:), wf4(:,21), wf8(:,82), n3(:,132), t3x8(:,:,58))
  call prop_A_Q(ntry, wf8(:,82), 27, ZERO, 0_intkind1, wf8(:,83), n2(59))
  call vert_WQ_A(ntry, wf4(:,21), ex3(:), wf8(:,84), n3(:,133), t3x8(:,:,59))
  call prop_Q_A(ntry, wf8(:,84), 30, ZERO, 0_intkind1, wf8(:,85), n2(60))
  call vert_QA_W(ntry, ex2(:), wf4(:,46), wf8(:,86), n3(:,134), t3x8(:,:,60))
  call vert_WQ_A(ntry, wf8(:,10), ex2(:), wf16(:,17), n3(:,135), t3x16(:,:,13))
  call prop_Q_A(ntry, wf16(:,17), 39, MB, 1_intkind1, wf16(:,18), n2(61))
  call vert_AW_Q(ntry, ex4(:), wf8(:,10), wf16(:,19), n3(:,136), t3x16(:,:,14))
  call prop_A_Q(ntry, wf16(:,19), 45, MT, 1_intkind1, wf16(:,20), n2(62))
  call vert_TV_S(ntry, ex5(:), 16, wf8(:,10), 37, wf8(:,87), n3(:,137), t3x8(:,:,61))
  call vert_SV_V(ntry, ex5(:), wf8(:,10), wf8(:,88), n3(:,138), t3x8(:,:,62))
  call vert_ST_V(ntry, wf8(:,6), 42, ex5(:), 16, wf8(:,89), n3(:,139), t3x8(:,:,63))
  call vert_SV_V(ntry, ex5(:), wf8(:,7), wf8(:,90), n3(:,140), t3x8(:,:,64))
  call vert_QA_W(ntry, wf4(:,32), ex4(:), wf8(:,91), n3(:,141), t3x8(:,:,65))
  call vert_WQ_A(ntry, wf8(:,11), ex2(:), wf16(:,21), n3(:,142), t3x16(:,:,15))
  call prop_Q_A(ntry, wf16(:,21), 39, MB, 1_intkind1, wf16(:,22), n2(63))
  call vert_AW_Q(ntry, ex4(:), wf8(:,11), wf16(:,23), n3(:,143), t3x16(:,:,16))
  call prop_A_Q(ntry, wf16(:,23), 45, MT, 1_intkind1, wf16(:,24), n2(64))
  call vert_TV_S(ntry, ex5(:), 16, wf8(:,11), 37, wf8(:,92), n3(:,144), t3x8(:,:,66))
  call vert_SV_V(ntry, ex5(:), wf8(:,11), wf8(:,93), n3(:,145), t3x8(:,:,67))
  call vert_ST_V(ntry, wf8(:,8), 42, ex5(:), 16, wf8(:,94), n3(:,146), t3x8(:,:,68))
  call vert_SV_V(ntry, ex5(:), wf8(:,9), wf8(:,95), n3(:,147), t3x8(:,:,69))
  call vert_QA_W(ntry, ex2(:), wf4(:,49), wf8(:,96), n3(:,148), t3x8(:,:,70))


  call init_hybrid_exwf(ex1)
  call init_hybrid_exwf(ex2)
  call init_hybrid_exwf(ex3)
  call init_hybrid_exwf(ex4)
  call init_hybrid_exwf(ex5)
  call init_hybrid_exwf(ex6)
  call init_hybrid_wf(wf2)
  call init_hybrid_wf(wf4)
  call init_hybrid_wf(wf8)
  call init_hybrid_wf(wf16)


  if (ntry==1) then
    call physical_helicities()
  end if

  ! computation of the colour-stripped amplitudes
  do nsync = ntry+ntry-1, ntry+1  !  nsync = 1,2  for 1st point and nsync = 3 later
    call diagrams()
    if (nsync == 1) call helsync(nsync, A, nhel, Hel)
  end do

  ! In the following loop the coefficients \Gamma_{i} of the expansion in
  ! the colour basis are computed for every helicity state and stored in M1helarray.
  ! Also the colour vector for the Born-loop interference is computed and saved in
  ! M0_col1_helarray
  do k = 1, nhel
    call colourvectors(A, k, M1helarray(:,k),M1helarray_ct(:,k))
    call colborninterf(M1helarray(:,k), M0_col1_helarray(:,k))
  end do
  M1helarray(:,nhel+1:)%j = 0
  M0_col1_helarray(:,nhel+1:)%hf = -1_intkind2
  M0_col1_helarray(:,nhel+1:)%j = 0

  M2add = 0
  M2add_ct = 0
  M2add_colint = 0

  M02 = 0
  M2ct = 0
  M2colint = 0
  
    do k = 1, nhel
      call colint(M1helarray(:,k)%j, M2add)
      call colint_ct(M1helarray(:,k)%j, M1helarray_ct(:,k)%j, M2add_ct)
      if (IR_is_on > 0) then
	call colint_IR(M1helarray(:,k)%j, M2add_colint)
      end if
      !summation over helicity configurations
      M02 = M02 + M2add
      M2ct = M2ct + M2add_ct
      M2colint = M2colint + M2add_colint
    end do



  contains

subroutine physical_helicities()
  implicit none 

integer :: i1,i2,i3,i4,i5,i6
integer :: n

n=0

do i6= 1, 2
do i5= 1, 1
do i4= 1, 2
do i3= 1, 2
do i2= 1, 2
do i1= 1, 2
n = n + 1
 if((ex1(i1)%hf==-1_intkind2) .OR. (ex2(i2)%hf==-1_intkind2) .OR. (ex3(i3)%hf==-1_intkind2) .OR. (ex4(i4)%hf==-1_intkind2)  &
    .OR. (ex5(i5)%hf==-1_intkind2) .OR. (ex6(i6)%hf==-1_intkind2)) then
  Hel(n) = -1_intkind2
 else
  Hel(n) = ex1(i1)%hf + ex2(i2)%hf + ex3(i3)%hf + ex4(i4)%hf + ex5(i5)%hf + ex6(i6)%hf
 end if
end do
end do
end do
end do
end do
end do

end subroutine physical_helicities

subroutine diagrams()
  implicit none
  integer :: h
  ! e.g. call cont_VV(nsync, wf3, wf6, A(:,1), n64, t64, nhel, den(5)) ...

    call Hcont_QA(nsync, wf4(:,3), wf8(:,1), A(:,1), n3(:,149), t3x32(:,:,1), nhel, den(5))
    call Hcont_QA(nsync, wf4(:,4), wf8(:,3), A(:,2), n3(:,150), t3x32(:,:,2), nhel, den(8))
    call Hcont_QA(nsync, wf2(:,4), wf16(:,1), A(:,3), n3(:,151), t3x32(:,:,3), nhel, den(12))
    call Hcont_QA(nsync, wf4(:,7), wf8(:,5), A(:,4), n3(:,152), t3x32(:,:,4), nhel, den(15))
    call Hcont_QA(nsync, wf8(:,3), wf4(:,8), A(:,5), n3(:,153), t3x32(:,:,5), nhel, den(16))
    call Hcont_SS(nsync, wf8(:,6), wf4(:,9), A(:,6), n3(:,154), t3x32(:,:,6), nhel, den(19))
    call Hcont_VV(nsync, wf8(:,7), wf4(:,10), A(:,7), n3(:,155), t3x32(:,:,7), nhel, den(19))
    call Hcont_QA(nsync, wf8(:,5), wf4(:,11), A(:,8), n3(:,156), t3x32(:,:,8), nhel, den(20))
    call Hcont_SS(nsync, wf4(:,9), wf8(:,8), A(:,9), n3(:,157), t3x32(:,:,9), nhel, den(22))
    call Hcont_VV(nsync, wf4(:,10), wf8(:,9), A(:,10), n3(:,158), t3x32(:,:,10), nhel, den(22))
    call Hcont_VV(nsync, wf8(:,10), wf4(:,15), A(:,11), n3(:,159), t3x32(:,:,11), nhel, den(27))
    call Hcont_VV(nsync, wf8(:,10), wf4(:,17), A(:,12), n3(:,160), t3x32(:,:,12), nhel, den(27))
    call Hcont_VV(nsync, wf4(:,15), wf8(:,11), A(:,13), n3(:,161), t3x32(:,:,13), nhel, den(30))
    call Hcont_VV(nsync, wf4(:,17), wf8(:,11), A(:,14), n3(:,162), t3x32(:,:,14), nhel, den(30))
    call Hcont_VV(nsync, wf8(:,10), wf4(:,20), A(:,15), n3(:,163), t3x32(:,:,15), nhel, den(31))
    call Hcont_VV(nsync, wf8(:,11), wf4(:,20), A(:,16), n3(:,164), t3x32(:,:,16), nhel, den(32))
    call Hcont_VV(nsync, wf8(:,10), wf4(:,21), A(:,17), n3(:,165), t3x32(:,:,17), nhel, den(35))
    call Hcont_VV(nsync, wf8(:,11), wf4(:,21), A(:,18), n3(:,166), t3x32(:,:,18), nhel, den(36))

    call Hcont_QA(nsync, wf4(:,3), wf8(:,12), A(:,19), n3(:,167), t3x32(:,:,19), nhel, den(5))
    call Hcont_QA(nsync, wf8(:,3), wf4(:,22), A(:,20), n3(:,168), t3x32(:,:,20), nhel, den(8))
    call Hcont_QA(nsync, wf2(:,4), wf16(:,2), A(:,21), n3(:,169), t3x32(:,:,21), nhel, den(12))
    call Hcont_QA(nsync, wf8(:,5), wf4(:,23), A(:,22), n3(:,170), t3x32(:,:,22), nhel, den(15))
    call Hcont_QA(nsync, wf8(:,3), wf4(:,24), A(:,23), n3(:,171), t3x32(:,:,23), nhel, den(16))
    call Hcont_QA(nsync, wf8(:,5), wf4(:,25), A(:,24), n3(:,172), t3x32(:,:,24), nhel, den(20))
    call Hcont_QA(nsync, wf8(:,5), wf4(:,26), A(:,25), n3(:,173), t3x32(:,:,25), nhel, den(38))
    call Hcont_QA(nsync, wf8(:,5), wf4(:,26), A(:,26), n3(:,174), t3x32(:,:,26), nhel, den(38))
    call Hcont_QA(nsync, wf8(:,2), wf4(:,28), A(:,27), n3(:,175), t3x32(:,:,27), nhel, den(41))
    call Hcont_QA(nsync, wf8(:,2), wf4(:,28), A(:,28), n3(:,176), t3x32(:,:,28), nhel, den(41))
    call Hcont_QA(nsync, wf8(:,13), wf4(:,29), A(:,29), n3(:,177), t3x32(:,:,29), nhel, den(43))
    call Hcont_QA(nsync, wf8(:,1), wf4(:,31), A(:,30), n3(:,178), t3x32(:,:,30), nhel, den(5))
    call Hcont_SS(nsync, wf4(:,9), wf8(:,14), A(:,31), n3(:,179), t3x32(:,:,31), nhel, den(46))
    call Hcont_VV(nsync, wf4(:,10), wf8(:,15), A(:,32), n3(:,180), t3x32(:,:,32), nhel, den(46))
    call Hcont_QA(nsync, wf8(:,13), wf4(:,32), A(:,33), n3(:,181), t3x32(:,:,33), nhel, den(48))
    call Hcont_QA(nsync, wf8(:,5), wf4(:,33), A(:,34), n3(:,182), t3x32(:,:,34), nhel, den(20))
    call Hcont_SS(nsync, wf4(:,9), wf8(:,16), A(:,35), n3(:,183), t3x32(:,:,35), nhel, den(22))
    call Hcont_VV(nsync, wf4(:,10), wf8(:,17), A(:,36), n3(:,184), t3x32(:,:,36), nhel, den(22))
    call Hcont_QA(nsync, wf16(:,1), wf2(:,7), A(:,37), n3(:,185), t3x32(:,:,37), nhel, den(12))
    call Hcont_QA(nsync, wf8(:,5), wf4(:,34), A(:,38), n3(:,186), t3x32(:,:,38), nhel, den(15))
    call Hcont_QA(nsync, wf4(:,35), wf8(:,19), A(:,39), n3(:,187), t3x32(:,:,39), nhel, den(51))
    call Hcont_QA(nsync, wf4(:,35), wf8(:,19), A(:,40), n3(:,188), t3x32(:,:,40), nhel, den(51))
    call Hcont_QA(nsync, wf8(:,20), wf4(:,37), A(:,41), n3(:,189), t3x32(:,:,41), nhel, den(54))
    call Hcont_QA(nsync, wf8(:,20), wf4(:,37), A(:,42), n3(:,190), t3x32(:,:,42), nhel, den(54))
    call Hcont_VV(nsync, wf8(:,10), wf4(:,38), A(:,43), n3(:,191), t3x32(:,:,43), nhel, den(31))
    call Hcont_VV(nsync, wf8(:,11), wf4(:,38), A(:,44), n3(:,192), t3x32(:,:,44), nhel, den(32))
    call Hcont_VV(nsync, wf8(:,10), wf4(:,39), A(:,45), n3(:,193), t3x32(:,:,45), nhel, den(35))
    call Hcont_VV(nsync, wf8(:,11), wf4(:,39), A(:,46), n3(:,194), t3x32(:,:,46), nhel, den(36))
    call Hcont_SS(nsync, wf4(:,40), wf8(:,21), A(:,47), n3(:,195), t3x32(:,:,47), nhel, den(56))
    call Hcont_VV(nsync, wf4(:,15), wf8(:,22), A(:,48), n3(:,196), t3x32(:,:,48), nhel, den(56))
    call Hcont_SS(nsync, wf8(:,21), wf4(:,41), A(:,49), n3(:,197), t3x32(:,:,49), nhel, den(56))
    call Hcont_VV(nsync, wf4(:,17), wf8(:,22), A(:,50), n3(:,198), t3x32(:,:,50), nhel, den(56))
    call Hcont_VV(nsync, wf4(:,15), wf8(:,23), A(:,51), n3(:,199), t3x32(:,:,51), nhel, den(30))
    call Hcont_VV(nsync, wf4(:,17), wf8(:,23), A(:,52), n3(:,200), t3x32(:,:,52), nhel, den(30))
    call Hcont_SS(nsync, wf8(:,21), wf4(:,44), A(:,53), n3(:,201), t3x32(:,:,53), nhel, den(58))
    call Hcont_VV(nsync, wf4(:,20), wf8(:,22), A(:,54), n3(:,202), t3x32(:,:,54), nhel, den(58))
    call Hcont_VV(nsync, wf4(:,20), wf8(:,23), A(:,55), n3(:,203), t3x32(:,:,55), nhel, den(32))
    call Hcont_SS(nsync, wf8(:,21), wf4(:,45), A(:,56), n3(:,204), t3x32(:,:,56), nhel, den(35))
    call Hcont_VV(nsync, wf4(:,21), wf8(:,22), A(:,57), n3(:,205), t3x32(:,:,57), nhel, den(35))
    call Hcont_VV(nsync, wf4(:,21), wf8(:,23), A(:,58), n3(:,206), t3x32(:,:,58), nhel, den(36))
    call Hcont_QA(nsync, wf8(:,24), wf4(:,46), A(:,59), n3(:,207), t3x32(:,:,59), nhel, den(61))
    call Hcont_QA(nsync, wf2(:,4), wf16(:,3), A(:,60), n3(:,208), t3x32(:,:,60), nhel, den(12))
    call Hcont_SS(nsync, wf4(:,9), wf8(:,25), A(:,61), n3(:,209), t3x32(:,:,61), nhel, den(62))
    call Hcont_VV(nsync, wf4(:,10), wf8(:,26), A(:,62), n3(:,210), t3x32(:,:,62), nhel, den(62))
    call Hcont_QA(nsync, wf8(:,24), wf4(:,49), A(:,63), n3(:,211), t3x32(:,:,63), nhel, den(64))
    call Hcont_QA(nsync, wf8(:,3), wf4(:,50), A(:,64), n3(:,212), t3x32(:,:,64), nhel, den(16))
    call Hcont_SS(nsync, wf4(:,9), wf8(:,27), A(:,65), n3(:,213), t3x32(:,:,65), nhel, den(19))
    call Hcont_VV(nsync, wf4(:,10), wf8(:,28), A(:,66), n3(:,214), t3x32(:,:,66), nhel, den(19))
    call Hcont_QA(nsync, wf4(:,3), wf8(:,29), A(:,67), n3(:,215), t3x32(:,:,67), nhel, den(5))
    call Hcont_QA(nsync, wf8(:,3), wf4(:,51), A(:,68), n3(:,216), t3x32(:,:,68), nhel, den(8))
    call Hcont_VV(nsync, wf8(:,10), wf4(:,52), A(:,69), n3(:,217), t3x32(:,:,69), nhel, den(65))
    call Hcont_VV(nsync, wf8(:,11), wf4(:,52), A(:,70), n3(:,218), t3x32(:,:,70), nhel, den(36))
    call Hcont_VV(nsync, wf8(:,10), wf4(:,53), A(:,71), n3(:,219), t3x32(:,:,71), nhel, den(31))
    call Hcont_VV(nsync, wf8(:,11), wf4(:,53), A(:,72), n3(:,220), t3x32(:,:,72), nhel, den(32))
    call Hcont_VV(nsync, wf8(:,10), wf4(:,55), A(:,73), n3(:,221), t3x32(:,:,73), nhel, den(27))
    call Hcont_VV(nsync, wf8(:,10), wf4(:,57), A(:,74), n3(:,222), t3x32(:,:,74), nhel, den(27))
    call Hcont_VV(nsync, wf8(:,11), wf4(:,55), A(:,75), n3(:,223), t3x32(:,:,75), nhel, den(30))
    call Hcont_VV(nsync, wf8(:,11), wf4(:,57), A(:,76), n3(:,224), t3x32(:,:,76), nhel, den(30))
    call Hcont_SS(nsync, wf4(:,40), wf8(:,30), A(:,77), n3(:,225), t3x32(:,:,77), nhel, den(66))
    call Hcont_SS(nsync, wf4(:,41), wf8(:,30), A(:,78), n3(:,226), t3x32(:,:,78), nhel, den(66))
    call Hcont_VV(nsync, wf4(:,15), wf8(:,31), A(:,79), n3(:,227), t3x32(:,:,79), nhel, den(66))
    call Hcont_VV(nsync, wf4(:,17), wf8(:,31), A(:,80), n3(:,228), t3x32(:,:,80), nhel, den(66))
    call Hcont_VV(nsync, wf4(:,15), wf8(:,32), A(:,81), n3(:,229), t3x32(:,:,81), nhel, den(27))
    call Hcont_VV(nsync, wf4(:,17), wf8(:,32), A(:,82), n3(:,230), t3x32(:,:,82), nhel, den(27))
    call Hcont_SS(nsync, wf4(:,44), wf8(:,30), A(:,83), n3(:,231), t3x32(:,:,83), nhel, den(67))
    call Hcont_VV(nsync, wf4(:,20), wf8(:,31), A(:,84), n3(:,232), t3x32(:,:,84), nhel, den(67))
    call Hcont_VV(nsync, wf4(:,20), wf8(:,32), A(:,85), n3(:,233), t3x32(:,:,85), nhel, den(31))
    call Hcont_SS(nsync, wf4(:,45), wf8(:,30), A(:,86), n3(:,234), t3x32(:,:,86), nhel, den(68))
    call Hcont_VV(nsync, wf4(:,21), wf8(:,31), A(:,87), n3(:,235), t3x32(:,:,87), nhel, den(68))
    call Hcont_VV(nsync, wf4(:,21), wf8(:,32), A(:,88), n3(:,236), t3x32(:,:,88), nhel, den(35))
    call Hcont_QA(nsync, wf4(:,3), wf8(:,33), A(:,89), n3(:,237), t3x32(:,:,89), nhel, den(5))
    call Hcont_QA(nsync, wf4(:,3), wf8(:,34), A(:,90), n3(:,238), t3x32(:,:,90), nhel, den(5))
    call Hcont_QA(nsync, wf4(:,4), wf8(:,36), A(:,91), n3(:,239), t3x32(:,:,91), nhel, den(8))
    call Hcont_QA(nsync, wf4(:,4), wf8(:,38), A(:,92), n3(:,240), t3x32(:,:,92), nhel, den(8))
    call Hcont_QA(nsync, wf2(:,4), wf16(:,4), A(:,93), n3(:,241), t3x32(:,:,93), nhel, den(12))
    call Hcont_QA(nsync, wf2(:,4), wf16(:,5), A(:,94), n3(:,242), t3x32(:,:,94), nhel, den(12))
    call Hcont_QA(nsync, wf4(:,7), wf8(:,40), A(:,95), n3(:,243), t3x32(:,:,95), nhel, den(15))
    call Hcont_QA(nsync, wf4(:,7), wf8(:,42), A(:,96), n3(:,244), t3x32(:,:,96), nhel, den(15))
    call Hcont_QA(nsync, wf4(:,8), wf8(:,36), A(:,97), n3(:,245), t3x32(:,:,97), nhel, den(16))
    call Hcont_QA(nsync, wf4(:,8), wf8(:,38), A(:,98), n3(:,246), t3x32(:,:,98), nhel, den(16))
    call Hcont_SS(nsync, wf8(:,6), wf4(:,62), A(:,99), n3(:,247), t3x32(:,:,99), nhel, den(19))
    call Hcont_VV(nsync, wf8(:,7), wf4(:,63), A(:,100), n3(:,248), t3x32(:,:,100), nhel, den(19))
    call Hcont_SS(nsync, wf8(:,6), wf4(:,64), A(:,101), n3(:,249), t3x32(:,:,101), nhel, den(19))
    call Hcont_VV(nsync, wf8(:,7), wf4(:,65), A(:,102), n3(:,250), t3x32(:,:,102), nhel, den(19))
    call Hcont_QA(nsync, wf4(:,11), wf8(:,40), A(:,103), n3(:,251), t3x32(:,:,103), nhel, den(20))
    call Hcont_QA(nsync, wf4(:,11), wf8(:,42), A(:,104), n3(:,252), t3x32(:,:,104), nhel, den(20))
    call Hcont_SS(nsync, wf8(:,8), wf4(:,62), A(:,105), n3(:,253), t3x32(:,:,105), nhel, den(22))
    call Hcont_VV(nsync, wf8(:,9), wf4(:,63), A(:,106), n3(:,254), t3x32(:,:,106), nhel, den(22))
    call Hcont_SS(nsync, wf8(:,8), wf4(:,64), A(:,107), n3(:,255), t3x32(:,:,107), nhel, den(22))
    call Hcont_VV(nsync, wf8(:,9), wf4(:,65), A(:,108), n3(:,256), t3x32(:,:,108), nhel, den(22))
    call Hcont_QA(nsync, wf2(:,10), wf16(:,7), A(:,109), n3(:,257), t3x32(:,:,109), nhel, den(72))
    call Hcont_QA(nsync, wf4(:,66), wf8(:,43), A(:,110), n3(:,258), t3x32(:,:,110), nhel, den(75))
    call Hcont_QA(nsync, wf8(:,3), wf4(:,67), A(:,111), n3(:,259), t3x32(:,:,111), nhel, den(77))
    call Hcont_QA(nsync, wf4(:,29), wf8(:,44), A(:,112), n3(:,260), t3x32(:,:,112), nhel, den(78))
    call Hcont_QA(nsync, wf4(:,68), wf8(:,46), A(:,113), n3(:,261), t3x32(:,:,113), nhel, den(82))
    call Hcont_QA(nsync, wf2(:,12), wf16(:,8), A(:,114), n3(:,262), t3x32(:,:,114), nhel, den(85))
    call Hcont_QA(nsync, wf4(:,46), wf8(:,47), A(:,115), n3(:,263), t3x32(:,:,115), nhel, den(86))
    call Hcont_QA(nsync, wf8(:,5), wf4(:,69), A(:,116), n3(:,264), t3x32(:,:,116), nhel, den(88))
    call Hcont_SS(nsync, wf4(:,9), wf8(:,48), A(:,117), n3(:,265), t3x32(:,:,117), nhel, den(90))
    call Hcont_VV(nsync, wf4(:,10), wf8(:,49), A(:,118), n3(:,266), t3x32(:,:,118), nhel, den(90))
    call Hcont_QA(nsync, wf8(:,3), wf4(:,71), A(:,119), n3(:,267), t3x32(:,:,119), nhel, den(91))
    call Hcont_QA(nsync, wf4(:,32), wf8(:,44), A(:,120), n3(:,268), t3x32(:,:,120), nhel, den(92))
    call Hcont_SS(nsync, wf4(:,9), wf8(:,50), A(:,121), n3(:,269), t3x32(:,:,121), nhel, den(94))
    call Hcont_VV(nsync, wf4(:,10), wf8(:,51), A(:,122), n3(:,270), t3x32(:,:,122), nhel, den(94))
    call Hcont_QA(nsync, wf4(:,49), wf8(:,47), A(:,123), n3(:,271), t3x32(:,:,123), nhel, den(95))
    call Hcont_QA(nsync, wf8(:,5), wf4(:,73), A(:,124), n3(:,272), t3x32(:,:,124), nhel, den(96))
    call Hcont_VV(nsync, wf4(:,15), wf8(:,52), A(:,125), n3(:,273), t3x32(:,:,125), nhel, den(98))
    call Hcont_VV(nsync, wf4(:,17), wf8(:,52), A(:,126), n3(:,274), t3x32(:,:,126), nhel, den(98))
    call Hcont_VV(nsync, wf4(:,15), wf8(:,53), A(:,127), n3(:,275), t3x32(:,:,127), nhel, den(100))
    call Hcont_VV(nsync, wf4(:,17), wf8(:,53), A(:,128), n3(:,276), t3x32(:,:,128), nhel, den(100))
    call Hcont_VV(nsync, wf4(:,20), wf8(:,52), A(:,129), n3(:,277), t3x32(:,:,129), nhel, den(101))
    call Hcont_VV(nsync, wf8(:,10), wf4(:,78), A(:,130), n3(:,278), t3x32(:,:,130), nhel, den(102))
    call Hcont_VV(nsync, wf4(:,20), wf8(:,53), A(:,131), n3(:,279), t3x32(:,:,131), nhel, den(103))
    call Hcont_VV(nsync, wf8(:,11), wf4(:,78), A(:,132), n3(:,280), t3x32(:,:,132), nhel, den(104))
    call Hcont_VV(nsync, wf4(:,21), wf8(:,52), A(:,133), n3(:,281), t3x32(:,:,133), nhel, den(105))
    call Hcont_VV(nsync, wf8(:,10), wf4(:,79), A(:,134), n3(:,282), t3x32(:,:,134), nhel, den(106))
    call Hcont_VV(nsync, wf4(:,21), wf8(:,53), A(:,135), n3(:,283), t3x32(:,:,135), nhel, den(107))
    call Hcont_VV(nsync, wf8(:,11), wf4(:,79), A(:,136), n3(:,284), t3x32(:,:,136), nhel, den(108))

end subroutine diagrams


elemental function diagmap(j, n)
  implicit none
  integer, intent(in) :: j, n
  complex(REALKIND) :: diagmap
  diagmap = A(j,n)%j
end function diagmap

function diagsum(j, pos, neg)
  implicit none
  integer, intent(in) :: j, pos(:), neg(:)
  complex(REALKIND) :: diagsum
  diagsum = sum(diagmap(j, pos)) - sum(diagmap(j, neg))
end function diagsum

subroutine colourvectors(A, j, M1, M2)
  implicit none
  type(Hpolcont) :: A(:,:)
  integer, intent(in) :: j
  type(Hpolcont), intent(out) :: M1(2), M2(2) ! M1helarray(2,32)
  integer :: empty(0), i

  M1(1)%j = (A(j,11)%j+A(j,13)%j)*f(2)+(A(j,12)%j+A(j,14)%j)*f(9)+(A(j,17)%j+A(j,18)%j)*f(21)+(A(j,15)%j+A(j,16)%j)*f(34)
  M1(2)%j = (A(j,6)%j+A(j,9)%j)*f(2)+(A(j,7)%j+A(j,10)%j)*f(9)+(A(j,3)%j+A(j,4)%j+A(j,8)%j)*f(21)+(A(j,1)%j+A(j,2)%j &
       +A(j,5)%j)*f(34)

  M2(1)%j = (A(j,47)%j+A(j,77)%j)*f(1)+(A(j,73)%j+A(j,75)%j-A(j,125)%j-A(j,127)%j)*f(3)+(A(j,51)%j+A(j,81)%j)*f(5)+(A(j,49)%j &
       +A(j,78)%j)*f(7)+(A(j,48)%j+A(j,79)%j)*f(8)+(-A(j,126)%j-A(j,128)%j)*f(10)+(A(j,52)%j+A(j,82)%j)*f(12)+(A(j,74)%j &
       +A(j,76)%j)*f(14)+(A(j,50)%j+A(j,80)%j)*f(15)+(A(j,56)%j+A(j,86)%j)*f(20)+(-A(j,133)%j-A(j,134)%j-A(j,135)%j &
       -A(j,136)%j)*f(22)+(A(j,58)%j+A(j,88)%j)*f(24)+(A(j,45)%j+A(j,46)%j)*f(26)+(A(j,69)%j+A(j,70)%j)*f(27)+(A(j,57)%j &
       +A(j,87)%j)*f(28)+(A(j,40)%j+A(j,42)%j)*f(29)+(A(j,53)%j+A(j,83)%j)*f(33)+(-A(j,129)%j-A(j,130)%j-A(j,131)%j &
       -A(j,132)%j)*f(35)+(A(j,55)%j+A(j,85)%j)*f(37)+(A(j,71)%j+A(j,72)%j)*f(39)+(A(j,43)%j+A(j,44)%j)*f(40)+(A(j,54)%j &
       +A(j,84)%j)*f(41)+(A(j,39)%j+A(j,41)%j)*f(42)
  M2(2)%j = (A(j,99)%j+A(j,105)%j)*f(1)+(A(j,31)%j+A(j,61)%j-A(j,117)%j-A(j,121)%j)*f(3)+A(j,35)%j*f(4)+A(j,65)%j*f(6)+(A(j,100)%j &
       +A(j,106)%j)*f(7)+(A(j,101)%j+A(j,107)%j)*f(8)+(-A(j,118)%j-A(j,122)%j)*f(10)+A(j,36)%j*f(11)+A(j,66)%j*f(13)+(A(j,32)%j &
       +A(j,62)%j)*f(14)+(A(j,102)%j+A(j,108)%j)*f(15)+(A(j,93)%j+A(j,95)%j+A(j,103)%j)*f(20)+(-A(j,113)%j-A(j,114)%j-A(j,115)%j &
       -A(j,116)%j-A(j,123)%j-A(j,124)%j)*f(22)+(A(j,22)%j+A(j,34)%j)*f(23)+A(j,60)%j*f(25)+(A(j,24)%j+A(j,37)%j+A(j,38)%j)*f(26) &
       +(A(j,21)%j+A(j,59)%j+A(j,63)%j)*f(27)+(A(j,94)%j+A(j,96)%j+A(j,104)%j)*f(28)+(A(j,26)%j+A(j,28)%j)*f(29)+(A(j,89)%j &
       +A(j,91)%j+A(j,97)%j)*f(33)+(-A(j,109)%j-A(j,110)%j-A(j,111)%j-A(j,112)%j-A(j,119)%j-A(j,120)%j)*f(35)+A(j,30)%j*f(36) &
       +(A(j,20)%j+A(j,64)%j)*f(38)+(A(j,23)%j+A(j,67)%j+A(j,68)%j)*f(39)+(A(j,19)%j+A(j,29)%j+A(j,33)%j)*f(40)+(A(j,90)%j &
       +A(j,92)%j+A(j,98)%j)*f(41)+(A(j,25)%j+A(j,27)%j)*f(42)


  M1(:)%hf = Hel(j)
  M2(:)%hf = Hel(j)  

  !M(i) corresponds to \Gamma_{i} in Fabio's thesis

end subroutine colourvectors


! **********************************************************************
subroutine colint(M, M2colint)
! M(i)   = <M|Ci> colour component of matrix element
! COLINT = <M|M>
!        = Sum_{i,j} <M|Ci> * <Ci|Cj> * <Cj|M>
!        = colour-summed squared matrix element
! K2(i,j) = <Ci|Cj>
! **********************************************************************
  use ol_colourmatrix_ppthjj_uxtdbxhg_1_/**/REALKIND, only: K1
  implicit none

  complex(REALKIND), intent(in)  :: M(2)
  real(REALKIND),    intent(out) :: M2colint
  integer :: i, j

  M2colint = 0

    do i = 1, 2
      do j = 1, 2
        M2colint = M2colint + real(conjg(M(i))*K1(i,j)*M(j))
      end do
    end do

end subroutine colint

! **********************************************************************
subroutine colint_ct(M, Mct, M2colint_ct)
! M(i)   = <M|Ci> colour component of matrix element
! COLINT = <M|M>
!        = Sum_{i,j} <M|Ci> * <Ci|Cj> * <Cj|M>
!        = colour-summed squared matrix element
! K2(i,j) = <Ci|Cj>
! **********************************************************************
  use ol_colourmatrix_ppthjj_uxtdbxhg_1_/**/REALKIND, only: K2
  implicit none

  complex(REALKIND), intent(in)  :: M(2), Mct(2)
  real(REALKIND),    intent(out) :: M2colint_ct
  integer ::  i, j

  M2colint_ct = 0

    do i = 1, 2
      do j = 1, 2
        M2colint_ct = M2colint_ct + real(conjg(M(i))*K2(i,j)*Mct(j))
      end do
    end do


end subroutine colint_ct

! **********************************************************************
subroutine colint_IR(M, M2IRadd)
! M(i)   = <M|Ci> colour component of matrix element
! K1(i,j) = .....
! **********************************************************************
  use ol_colourmatrix_ppthjj_uxtdbxhg_1_/**/REALKIND, only: K1
  implicit none

  complex(REALKIND), intent(in)  :: M(2)
  real(REALKIND),    intent(out) :: M2IRadd(22)
  integer ::  i, j, k, colmatpos

  M2IRadd = 0

  do k = 1, 23-1
    colmatpos = 2*k
    do i = 1, 2
      do j = 1, 2
	M2IRadd(k) = M2IRadd(k) + real(conjg(M(i))*K1(i+colmatpos,j)*M(j))
      end do
    end do
  end do
  
end subroutine colint_IR

! **********************************************************************
subroutine colintmunu(M1, M2, M2colint)
! M1(i)    = <M1|Ci> colour component of matrix element
! M2(i)    = <M2|Ci> colour component of matrix element
! M2colint = <M1|M2>
!          = Sum_{i,j} <M1|Ci> * <Ci|Cj> * <Cj|M2>
!          = colour-summed squared matrix element
! K2(i,j) = <Ci|Cj>
! **********************************************************************
  use ol_colourmatrix_ppthjj_uxtdbxhg_1_/**/REALKIND, only: K2
  implicit none

  complex(REALKIND), intent(in)  :: M1(2)
  complex(REALKIND), intent(in)  :: M2(2)
  complex(REALKIND),    intent(out) :: M2colint
  integer :: i, j

  M2colint = 0

  do i = 1, 2
    do j = 1, 2
      M2colint = M2colint + M1(i)*K2(i,j)*conjg(M2(j))
    end do
  end do

end subroutine colintmunu





! **********************************************************************
subroutine colborninterf(M, M0_col)
! M(i)         = <M|Ci> colour component of matrix element
! M0_col(i)    = <M2|Ci> colour component of matrix element,
!                see \tilde{M}_{j} in Fabio's thesis
! M2colint = Sum_{i} <M1|Ci> * <Ci|Cj>
!          = colour-summed squared matrix element
! KL(i,j) = <Ci|Cj> with elements Cj of 1-loop colour basis
! **********************************************************************
  use ol_colourmatrix_ppthjj_uxtdbxhg_1_/**/REALKIND, only: KL
  implicit none

  type(Hpolcont), intent(in)  :: M(2)
  type(Hpolcont), intent(out)  :: M0_col(4)
  integer :: i, j


  do j = 1, 4 !size(KL(1,:))
    M0_col(j)%j = 0
    M0_col(j)%hf = M(1)%hf
    do i = 1, 2 !size(KL(:,1))
      M0_col(j)%j = M0_col(j)%j  + conjg(M(i)%j)*KL(i,j)
    end do    
  end do

end subroutine colborninterf

end subroutine amp2

end module ol_loop_ppthjj_uxtdbxhg_1_/**/REALKIND
