
module ol_vamp_1_ppnnjj_ew_nenexdddxdx_1_/**/REALKIND
contains

! **********************************************************************
subroutine vamp_1(M)
! P(0:3,nlegs) = incoming external momenta
! Uses tree structures 'wf', factors 'c', and denominators 'den' from loop_ppnnjj_ew_nenexdddxdx_1.
! Sets colour stripped amplitudes A from the module loop_amplitudes_ppnnjj_ew_nenexdddxdx_1.
! **********************************************************************
  use KIND_TYPES, only: REALKIND, QREALKIND, intkind2
  use ol_parameters_decl_/**/DREALKIND, only: l_switch
  use ol_parameters_decl_/**/QREALKIND ! masses
  use ol_vert_interface_/**/REALKIND
  use ol_prop_interface_/**/REALKIND
  use ol_last_step_/**/REALKIND
  use ol_tables_storage_ppnnjj_ew_nenexdddxdx_1_/**/DREALKIND
  use ol_tensor_sum_storage_ppnnjj_ew_nenexdddxdx_1_/**/REALKIND
  use ol_loop_handling_/**/REALKIND
  use ofred_reduction_/**/REALKIND, only: Hotf_4pt_reduction, Hotf_4pt_reduction_last
  use ofred_reduction_/**/REALKIND, only: Hotf_5pt_reduction, Hotf_5pt_reduction_last
  use ol_loop_reduction_/**/REALKIND, only: TI_bubble_red, TI_triangle_red
use ol_loop_reduction_/**/REALKIND, only: compute_scalar_box

  use ol_loop_storage_ppnnjj_ew_nenexdddxdx_1_/**/REALKIND
#ifndef PRECISION_dp
  use ol_loop_storage_ppnnjj_ew_nenexdddxdx_1_/**/DREALKIND, only: &
    & ntryL, p_switch, Hel, merge_step, merge_mism, merge_tables, merge_hels
#endif
  use hol_initialisation_/**/REALKIND, only: G0_hol_initialisation
  use ol_h_vert_interface_/**/REALKIND
  use ol_h_prop_interface_/**/REALKIND
  use ol_h_last_step_/**/REALKIND
  use ol_merging_/**/REALKIND, only: ol_merge, ol_merge_tensors, ol_merge_last

  implicit none

  type(Hpolcont) :: Gcoeff(64)
  type(Hpolcont), intent(in) :: M(4,64)


#ifndef PRECISION_dp
  if (ntryL==1 .OR. p_switch == 1) Gcoeff(:)%hf = Hel
#else
  if (ntryL==1 .OR. p_switch == 2) Gcoeff(:)%hf = Hel
#endif

  ! =============================================


! Dressing, otf merging and otf reduction calls to build loop structures

  Gcoeff(:)%j = (-(c(5)*M(2,:)%j)+c(4)*M(4,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(1),h0tab(:,1),[32,8,2,1,4,16],[0,nMZ,0,nMZ,0,0],6,0)
  call Hloop_VA_Q(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,1),heltab2x64(:,:,1))
  call Hloop_A_Q(ntryL,G0H32(1),32,0,G1H32(1),n2h32(1))
  Gcoeff(:)%j = (-(c(4)*M(2,:)%j)+c(5)*M(4,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(2),h0tab(:,2),[32,4,1,2,8,16],[0,nMZ,0,nMZ,0,0],6,0)
  call Hloop_VA_Q(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,2),heltab2x64(:,:,2))
  call Hloop_A_Q(ntryL,G0H32(1),32,0,G1H32(2),n2h32(2))
  Gcoeff(:)%j = (-(c(4)*M(2,:)%j)+c(5)*M(4,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(3),h0tab(:,3),[32,4,1,2,16,8],[0,nMZ,0,nMZ,0,0],6,0)
  call Hloop_VA_Q(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,3),heltab2x64(:,:,3))
  call Hloop_A_Q(ntryL,G0H32(1),32,0,G1H32(3),n2h32(3))
  Gcoeff(:)%j = (-(c(5)*M(2,:)%j)+c(4)*M(4,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(4),h0tab(:,4),[32,2,1,4,16,8],[nMZ,0,nMZ,0,0,0],6,0)
  call Hloop_QA_Z(ntryL,G0H64(1),ex6(:),G0H32(1),ngZd,m3h2x32(:,4),heltab2x64(:,:,4))
  Gcoeff(:)%j = (-(c(5)*M(2,:)%j)+c(4)*M(4,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(5),h0tab(:,5),[32,8,1,2,4,16],[0,nMZ,0,nMZ,0,0],6,0)
  call Hloop_VA_Q(ntryL,G0H64(1),ex6(:),G0H32(2),m3h2x32(:,5),heltab2x64(:,:,5))
  call Hloop_A_Q(ntryL,G0H32(2),32,0,G1H32(4),n2h32(4))
  Gcoeff(:)%j = (-(c(4)*M(2,:)%j)+c(5)*M(4,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(6),h0tab(:,6),[32,4,2,1,8,16],[0,nMZ,0,nMZ,0,0],6,0)
  call Hloop_VA_Q(ntryL,G0H64(1),ex6(:),G0H32(2),m3h2x32(:,6),heltab2x64(:,:,6))
  call Hloop_A_Q(ntryL,G0H32(2),32,0,G1H32(5),n2h32(5))
  Gcoeff(:)%j = (-(c(5)*M(2,:)%j)+c(4)*M(4,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(7),h0tab(:,7),[32,4,16,2,1,8],[0,0,nMZ,0,nMZ,0],6,0)
  call Hloop_QA_V(ntryL,G0H64(1),ex6(:),G0H32(2),m3h2x32(:,7),heltab2x64(:,:,7))
  Gcoeff(:)%j = (-(c(4)*M(2,:)%j)+c(5)*M(4,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(8),h0tab(:,8),[32,2,1,8,16,4],[nMZ,0,nMZ,0,0,0],6,0)
  call Hloop_QA_Z(ntryL,G0H64(1),ex6(:),G0H32(3),ngZd,m3h2x32(:,8),heltab2x64(:,:,8))
  Gcoeff(:)%j = (-(c(4)*M(2,:)%j)+c(5)*M(4,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(9),h0tab(:,9),[32,4,2,1,16,8],[0,nMZ,0,nMZ,0,0],6,0)
  call Hloop_VA_Q(ntryL,G0H64(1),ex6(:),G0H32(4),m3h2x32(:,9),heltab2x64(:,:,9))
  call Hloop_A_Q(ntryL,G0H32(4),32,0,G1H32(6),n2h32(6))
  Gcoeff(:)%j = (-(c(5)*M(2,:)%j)+c(4)*M(4,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(10),h0tab(:,10),[32,4,16,1,2,8],[0,0,nMZ,0,nMZ,0],6,0)
  call Hloop_QA_V(ntryL,G0H64(1),ex6(:),G0H32(4),m3h2x32(:,10),heltab2x64(:,:,10))
  Gcoeff(:)%j = (-(c(5)*M(2,:)%j)+c(4)*M(4,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(11),h0tab(:,11),[32,2,1,16,4,8],[nMZ,0,nMZ,0,0,0],6,0)
  call Hloop_QA_Z(ntryL,G0H64(1),ex6(:),G0H32(5),ngZd,m3h2x32(:,11),heltab2x64(:,:,11))
  Gcoeff(:)%j = (-(c(4)*M(2,:)%j)+c(5)*M(4,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(12),h0tab(:,12),[32,2,1,16,8,4],[nMZ,0,nMZ,0,0,0],6,0)
  call Hloop_QA_Z(ntryL,G0H64(1),ex6(:),G0H32(6),ngZd,m3h2x32(:,12),heltab2x64(:,:,12))
  Gcoeff(:)%j = (-(c(5)*M(2,:)%j)+c(4)*M(4,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(13),h0tab(:,13),[32,1,2,4,16,8],[nMZ,0,nMZ,0,0,0],6,0)
  call Hloop_QA_Z(ntryL,G0H64(1),ex6(:),G0H32(7),ngZd,m3h2x32(:,13),heltab2x64(:,:,13))
  Gcoeff(:)%j = (-(c(4)*M(2,:)%j)+c(5)*M(4,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(14),h0tab(:,14),[32,1,2,8,16,4],[nMZ,0,nMZ,0,0,0],6,0)
  call Hloop_QA_Z(ntryL,G0H64(1),ex6(:),G0H32(8),ngZd,m3h2x32(:,14),heltab2x64(:,:,14))
  Gcoeff(:)%j = (-(c(5)*M(2,:)%j)+c(4)*M(4,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(15),h0tab(:,15),[32,1,2,16,4,8],[nMZ,0,nMZ,0,0,0],6,0)
  call Hloop_QA_Z(ntryL,G0H64(1),ex6(:),G0H32(9),ngZd,m3h2x32(:,15),heltab2x64(:,:,15))
  Gcoeff(:)%j = (-(c(4)*M(2,:)%j)+c(5)*M(4,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(16),h0tab(:,16),[32,1,2,16,8,4],[nMZ,0,nMZ,0,0,0],6,0)
  call Hloop_QA_Z(ntryL,G0H64(1),ex6(:),G0H32(10),ngZd,m3h2x32(:,16),heltab2x64(:,:,16))
  call Hloop_AQ_Z(ntryL,G1H32(1),ex4(:),G1H16(1),ngZd,m3h2x16(:,1),heltab2x32(:,:,1))
  call Hloop_AQ_Z(ntryL,G1H32(2),ex3(:),G1H16(2),ngZd,m3h2x16(:,2),heltab2x32(:,:,2))
  call Hloop_AQ_Z(ntryL,G1H32(3),ex3(:),G1H16(3),ngZd,m3h2x16(:,3),heltab2x32(:,:,3))
  call Hloop_ZA_Q(ntryL,G0H32(1),ex2(:),G0H16(1),ngZn,m3h2x16(:,4),heltab2x32(:,:,4))
  call Hloop_A_Q(ntryL,G0H16(1),34,0,G1H16(4),n2h16(1))
  call Hloop_AQ_Z(ntryL,G1H32(4),ex4(:),G1H16(5),ngZd,m3h2x16(:,5),heltab2x32(:,:,5))
  call Hloop_AQ_Z(ntryL,G1H32(5),ex3(:),G1H16(6),ngZd,m3h2x16(:,6),heltab2x32(:,:,6))
  call Hloop_VQ_A(ntryL,G0H32(2),ex3(:),G0H16(1),m3h2x16(:,7),heltab2x32(:,:,7))
  call Hloop_Q_A(ntryL,G0H16(1),36,0,G1H16(7),n2h16(2))
  call Hloop_ZA_Q(ntryL,G0H32(3),ex2(:),G0H16(1),ngZn,m3h2x16(:,8),heltab2x32(:,:,8))
  call Hloop_A_Q(ntryL,G0H16(1),34,0,G1H16(8),n2h16(3))
  call Hloop_AQ_Z(ntryL,G1H32(6),ex3(:),G1H16(9),ngZd,m3h2x16(:,9),heltab2x32(:,:,9))
  call Hloop_VQ_A(ntryL,G0H32(4),ex3(:),G0H16(1),m3h2x16(:,10),heltab2x32(:,:,10))
  call Hloop_Q_A(ntryL,G0H16(1),36,0,G1H16(10),n2h16(4))
  call Hloop_ZA_Q(ntryL,G0H32(5),ex2(:),G0H16(1),ngZn,m3h2x16(:,11),heltab2x32(:,:,11))
  call Hloop_A_Q(ntryL,G0H16(1),34,0,G1H16(11),n2h16(5))
  call Hloop_ZA_Q(ntryL,G0H32(6),ex2(:),G0H16(1),ngZn,m3h2x16(:,12),heltab2x32(:,:,12))
  call Hloop_A_Q(ntryL,G0H16(1),34,0,G1H16(12),n2h16(6))
  call Hloop_ZQ_A(ntryL,G0H32(7),ex1(:),G0H16(1),ngZn,m3h2x16(:,13),heltab2x32(:,:,13))
  call Hloop_Q_A(ntryL,G0H16(1),33,0,G1H16(13),n2h16(7))
  call Hloop_ZQ_A(ntryL,G0H32(8),ex1(:),G0H16(1),ngZn,m3h2x16(:,14),heltab2x32(:,:,14))
  call Hloop_Q_A(ntryL,G0H16(1),33,0,G1H16(14),n2h16(8))
  call Hloop_ZQ_A(ntryL,G0H32(9),ex1(:),G0H16(1),ngZn,m3h2x16(:,15),heltab2x32(:,:,15))
  call Hloop_Q_A(ntryL,G0H16(1),33,0,G1H16(15),n2h16(9))
  call Hloop_ZQ_A(ntryL,G0H32(10),ex1(:),G0H16(1),ngZn,m3h2x16(:,16),heltab2x32(:,:,16))
  call Hloop_Q_A(ntryL,G0H16(1),33,0,G1H16(16),n2h16(10))
  call Hloop_ZA_Q(ntryL,G1H16(1),ex2(:),G1H8(1),ngZn,m3h2x8(:,1),heltab2x16(:,:,1))
  call Hloop_A_Q(ntryL,G1H8(1),42,0,G2H8(1),n2h8(1))
  call Hloop_ZQ_A(ntryL,G1H16(2),ex1(:),G1H8(1),ngZn,m3h2x8(:,2),heltab2x16(:,:,2))
  call Hloop_Q_A(ntryL,G1H8(1),37,0,G2H8(2),n2h8(2))
  call Hloop_ZQ_A(ntryL,G1H16(3),ex1(:),G1H8(1),ngZn,m3h2x8(:,3),heltab2x16(:,:,3))
  call Hloop_Q_A(ntryL,G1H8(1),37,0,G2H8(3),n2h8(3))
  call Hloop_AQ_Z(ntryL,G1H16(4),ex1(:),G1H8(1),ngZn,m3h2x8(:,4),heltab2x16(:,:,4))
  call Hloop_ZQ_A(ntryL,G1H16(5),ex1(:),G1H8(2),ngZn,m3h2x8(:,5),heltab2x16(:,:,5))
  call Hloop_Q_A(ntryL,G1H8(2),41,0,G2H8(4),n2h8(4))
  call Hloop_ZA_Q(ntryL,G1H16(6),ex2(:),G1H8(2),ngZn,m3h2x8(:,6),heltab2x16(:,:,6))
  call Hloop_A_Q(ntryL,G1H8(2),38,0,G2H8(5),n2h8(5))
  call Hloop_QA_Z(ntryL,G1H16(7),ex5(:),G1H8(2),ngZd,m3h2x8(:,7),heltab2x16(:,:,7))
  call Hloop_AQ_Z(ntryL,G1H16(8),ex1(:),G1H8(3),ngZn,m3h2x8(:,8),heltab2x16(:,:,8))
  call Hloop_ZA_Q(ntryL,G1H16(9),ex2(:),G1H8(4),ngZn,m3h2x8(:,9),heltab2x16(:,:,9))
  call Hloop_A_Q(ntryL,G1H8(4),38,0,G2H8(6),n2h8(6))
  call Hloop_QA_Z(ntryL,G1H16(10),ex5(:),G1H8(4),ngZd,m3h2x8(:,10),heltab2x16(:,:,10))
  call Hloop_AQ_Z(ntryL,G1H16(11),ex1(:),G1H8(5),ngZn,m3h2x8(:,11),heltab2x16(:,:,11))
  call Hloop_AQ_Z(ntryL,G1H16(12),ex1(:),G1H8(6),ngZn,m3h2x8(:,12),heltab2x16(:,:,12))
  call Hloop_QA_Z(ntryL,G1H16(13),ex2(:),G1H8(7),ngZn,m3h2x8(:,13),heltab2x16(:,:,13))
  call Hloop_QA_Z(ntryL,G1H16(14),ex2(:),G1H8(8),ngZn,m3h2x8(:,14),heltab2x16(:,:,14))
  call Hloop_QA_Z(ntryL,G1H16(15),ex2(:),G1H8(9),ngZn,m3h2x8(:,15),heltab2x16(:,:,15))
  call Hloop_QA_Z(ntryL,G1H16(16),ex2(:),G1H8(10),ngZn,m3h2x8(:,16),heltab2x16(:,:,16))
  call Hloop_AQ_Z(ntryL,G2H8(1),ex1(:),G2H4(1),ngZn,m3h2x4(:,1),heltab2x8(:,:,1))
  call Hloop_QA_Z(ntryL,G2H8(2),ex2(:),G2H4(2),ngZn,m3h2x4(:,2),heltab2x8(:,:,2))
  call Hloop_QA_Z(ntryL,G2H8(3),ex2(:),G2H4(3),ngZn,m3h2x4(:,3),heltab2x8(:,:,3))
  call Hloop_ZQ_A(ntryL,G1H8(1),ex3(:),G1H4(1),ngZd,m3h2x4(:,4),heltab2x8(:,:,4))
  call Hloop_Q_A(ntryL,G1H4(1),39,0,G2H4(4),n2h4(1))
  call Hloop_QA_Z(ntryL,G2H8(4),ex2(:),G2H4(5),ngZn,m3h2x4(:,5),heltab2x8(:,:,5))
  call Hloop_AQ_Z(ntryL,G2H8(5),ex1(:),G2H4(6),ngZn,m3h2x4(:,6),heltab2x8(:,:,6))
  call Hloop_ZA_Q(ntryL,G1H8(2),ex2(:),G1H4(1),ngZn,m3h2x4(:,7),heltab2x8(:,:,7))
  call Hloop_A_Q(ntryL,G1H4(1),54,0,G2H4(7),n2h4(2))
  call Hloop_ZQ_A(ntryL,G1H8(3),ex4(:),G1H4(1),ngZd,m3h2x4(:,8),heltab2x8(:,:,8))
  call Hloop_Q_A(ntryL,G1H4(1),43,0,G2H4(8),n2h4(3))
  call Hloop_AQ_Z(ntryL,G2H8(6),ex1(:),G2H4(9),ngZn,m3h2x4(:,9),heltab2x8(:,:,9))
  call Hloop_ZQ_A(ntryL,G1H8(4),ex1(:),G1H4(1),ngZn,m3h2x4(:,10),heltab2x8(:,:,10))
  call Hloop_Q_A(ntryL,G1H4(1),53,0,G2H4(10),n2h4(4))
  call Hloop_ZA_Q(ntryL,G1H8(5),ex5(:),G1H4(1),ngZd,m3h2x4(:,11),heltab2x8(:,:,11))
  call Hloop_A_Q(ntryL,G1H4(1),51,0,G2H4(11),n2h4(5))
  call Hloop_ZA_Q(ntryL,G1H8(6),ex5(:),G1H4(1),ngZd,m3h2x4(:,12),heltab2x8(:,:,12))
  call Hloop_A_Q(ntryL,G1H4(1),51,0,G2H4(12),n2h4(6))
  call Hloop_ZQ_A(ntryL,G1H8(7),ex3(:),G1H4(1),ngZd,m3h2x4(:,13),heltab2x8(:,:,13))
  call Hloop_Q_A(ntryL,G1H4(1),39,0,G2H4(13),n2h4(7))
  call Hloop_ZQ_A(ntryL,G1H8(8),ex4(:),G1H4(1),ngZd,m3h2x4(:,14),heltab2x8(:,:,14))
  call Hloop_Q_A(ntryL,G1H4(1),43,0,G2H4(14),n2h4(8))
  call Hloop_ZA_Q(ntryL,G1H8(9),ex5(:),G1H4(1),ngZd,m3h2x4(:,15),heltab2x8(:,:,15))
  call Hloop_A_Q(ntryL,G1H4(1),51,0,G2H4(15),n2h4(9))
  call Hloop_ZA_Q(ntryL,G1H8(10),ex5(:),G1H4(1),ngZd,m3h2x4(:,16),heltab2x8(:,:,16))
  call Hloop_A_Q(ntryL,G1H4(1),51,0,G2H4(16),n2h4(10))
  call Hotf_5pt_reduction(G2H4(1),RedSet_5(1),mass5set(:,1),  & 
G1H4(1),G1H4(2),G1H4(3),G1H4(4),G1H4(5),G1H4(6),4)
  call HG1shiftOLR(G1H4(2),16,4)
  call Hotf_5pt_reduction(G2H4(2),RedSet_5(2),mass5set(:,1),  & 
G1H4(7),G1H4(8),G1H4(9),G1H4(10),G1H4(11),G1H4(12),4)
  call HG1shiftOLR(G1H4(8),16,4)
  call Hotf_5pt_reduction(G2H4(3),RedSet_5(2),mass5set(:,1),  & 
G1H4(13),G1H4(14),G1H4(15),G1H4(16),G1H4(17),G1H4(18),4)
  call HG1shiftOLR(G1H4(14),8,4)
  call Hloop_QA_V(ntryL,G2H4(4),ex5(:),G2H2(1),m3h2x2(:,1),heltab2x4(:,:,1))
  call Hotf_5pt_reduction(G2H4(5),RedSet_5(3),mass5set(:,1),  & 
G1H4(19),G1H4(20),G1H4(21),G1H4(22),G1H4(23),G1H4(24),4)
  call HG1shiftOLR(G1H4(20),16,4)
  call Hotf_5pt_reduction(G2H4(6),RedSet_5(4),mass5set(:,1),  & 
G1H4(25),G1H4(26),G1H4(27),G1H4(28),G1H4(29),G1H4(30),4)
  call HG1shiftOLR(G1H4(26),16,4)
  call Hloop_AQ_Z(ntryL,G2H4(7),ex1(:),G2H2(2),ngZn,m3h2x2(:,2),heltab2x4(:,:,2))
  call Hloop_QA_V(ntryL,G2H4(8),ex5(:),G2H2(3),m3h2x2(:,3),heltab2x4(:,:,3))
  call Hotf_5pt_reduction(G2H4(9),RedSet_5(4),mass5set(:,1),  & 
G1H4(31),G1H4(32),G1H4(33),G1H4(34),G1H4(35),G1H4(36),4)
  call HG1shiftOLR(G1H4(32),8,4)
  call Hloop_QA_Z(ntryL,G2H4(10),ex2(:),G2H2(4),ngZn,m3h2x2(:,4),heltab2x4(:,:,4))
  call Hloop_AQ_V(ntryL,G2H4(11),ex3(:),G2H2(5),m3h2x2(:,5),heltab2x4(:,:,5))
  call Hloop_AQ_V(ntryL,G2H4(12),ex4(:),G2H2(6),m3h2x2(:,6),heltab2x4(:,:,6))
  call Hloop_QA_V(ntryL,G2H4(13),ex5(:),G2H2(7),m3h2x2(:,7),heltab2x4(:,:,7))
  call Hloop_QA_V(ntryL,G2H4(14),ex5(:),G2H2(8),m3h2x2(:,8),heltab2x4(:,:,8))
  call Hloop_AQ_V(ntryL,G2H4(15),ex3(:),G2H2(9),m3h2x2(:,9),heltab2x4(:,:,9))
  call Hloop_AQ_V(ntryL,G2H4(16),ex4(:),G2H2(10),m3h2x2(:,10),heltab2x4(:,:,10))
  call Hloop_ZQ_A(ntryL,G1H4(1),ex3(:),G1H2(1),ngZd,m3h2x2(:,11),heltab2x4(:,:,11))
  call Hloop_Q_A(ntryL,G1H2(1),47,0,G2H2(11),n2h2(1))
call HGT_raise_alpha_OLR(G1H4(2),1,1,4)
call HGT_raise_alpha_invQ_OLR(G1H4(2),2,5,4)
  call Hloop_VA_Q(ntryL,G1H4(2),ex5(:),G1H2(1),m3h2x2(:,12),heltab2x4(:,:,12))
  call Hloop_ZQ_A(ntryL,G1H4(6),ex3(:),G1H2(2),ngZd,m3h2x2(:,13),heltab2x4(:,:,13))
  call Hloop_Q_A(ntryL,G1H2(2),47,0,G2H2(12),n2h2(2))
  call Hloop_ZQ_A(ntryL,G1H4(7),ex4(:),G1H2(2),ngZd,m3h2x2(:,14),heltab2x4(:,:,14))
  call Hloop_Q_A(ntryL,G1H2(2),47,0,G2H2(13),n2h2(3))
call HGT_raise_alpha_OLR(G1H4(8),1,1,4)
call HGT_raise_alpha_invQ_OLR(G1H4(8),2,5,4)
  call Hloop_VA_Q(ntryL,G1H4(8),ex5(:),G1H2(2),m3h2x2(:,15),heltab2x4(:,:,15))
  call Hloop_ZQ_A(ntryL,G1H4(12),ex4(:),G1H2(3),ngZd,m3h2x2(:,16),heltab2x4(:,:,16))
  call Hloop_Q_A(ntryL,G1H2(3),47,0,G2H2(14),n2h2(4))
  call Hloop_ZA_Q(ntryL,G1H4(13),ex5(:),G1H2(3),ngZd,m3h2x2(:,17),heltab2x4(:,:,17))
  call Hloop_A_Q(ntryL,G1H2(3),55,0,G2H2(15),n2h2(5))
call HGT_raise_alpha_OLR(G1H4(14),1,1,4)
call HGT_raise_alpha_invQ_OLR(G1H4(14),2,5,4)
  call Hloop_VQ_A(ntryL,G1H4(14),ex4(:),G1H2(3),m3h2x2(:,18),heltab2x4(:,:,18))
  call Hloop_ZA_Q(ntryL,G1H4(18),ex5(:),G1H2(4),ngZd,m3h2x2(:,19),heltab2x4(:,:,19))
  call Hloop_A_Q(ntryL,G1H2(4),55,0,G2H2(16),n2h2(6))
  call Hloop_ZQ_A(ntryL,G1H4(19),ex3(:),G1H2(4),ngZd,m3h2x2(:,20),heltab2x4(:,:,20))
  call Hloop_Q_A(ntryL,G1H2(4),47,0,G2H2(17),n2h2(7))
call HGT_raise_alpha_OLR(G1H4(20),1,1,4)
call HGT_raise_alpha_invQ_OLR(G1H4(20),2,5,4)
  call Hloop_VA_Q(ntryL,G1H4(20),ex5(:),G1H2(4),m3h2x2(:,21),heltab2x4(:,:,21))
  call Hloop_ZQ_A(ntryL,G1H4(24),ex3(:),G1H2(5),ngZd,m3h2x2(:,22),heltab2x4(:,:,22))
  call Hloop_Q_A(ntryL,G1H2(5),47,0,G2H2(18),n2h2(8))
  call Hloop_ZQ_A(ntryL,G1H4(25),ex4(:),G1H2(5),ngZd,m3h2x2(:,23),heltab2x4(:,:,23))
  call Hloop_Q_A(ntryL,G1H2(5),47,0,G2H2(19),n2h2(9))
call HGT_raise_alpha_OLR(G1H4(26),1,1,4)
call HGT_raise_alpha_invQ_OLR(G1H4(26),2,5,4)
  call Hloop_VA_Q(ntryL,G1H4(26),ex5(:),G1H2(5),m3h2x2(:,24),heltab2x4(:,:,24))
  call Hloop_ZQ_A(ntryL,G1H4(30),ex4(:),G1H2(6),ngZd,m3h2x2(:,25),heltab2x4(:,:,25))
  call Hloop_Q_A(ntryL,G1H2(6),47,0,G2H2(20),n2h2(10))
  call Hloop_ZA_Q(ntryL,G1H4(31),ex5(:),G1H2(6),ngZd,m3h2x2(:,26),heltab2x4(:,:,26))
  call Hloop_A_Q(ntryL,G1H2(6),55,0,G2H2(21),n2h2(11))
call HGT_raise_alpha_OLR(G1H4(32),1,1,4)
call HGT_raise_alpha_invQ_OLR(G1H4(32),2,5,4)
  call Hloop_VQ_A(ntryL,G1H4(32),ex4(:),G1H2(6),m3h2x2(:,27),heltab2x4(:,:,27))
  call Hloop_ZA_Q(ntryL,G1H4(36),ex5(:),G1H2(7),ngZd,m3h2x2(:,28),heltab2x4(:,:,28))
  call Hloop_A_Q(ntryL,G1H2(7),55,0,G2H2(22),n2h2(12))
  call Hotf_5pt_reduction(G2H2(1),RedSet_5(5),mass5set(:,2),  & 
G1H2(7),G1H2(8),G1H2(9),G1H2(10),G1H2(11),G1H2(12),2)
  call HG1shiftOLR(G1H2(8),8,2)
  call Hotf_5pt_reduction(G2H2(2),RedSet_5(6),mass5set(:,3),  & 
G1H2(13),G1H2(14),G1H2(15),G1H2(16),G1H2(17),G1H2(18),2)
  call HG1shiftOLR(G1H2(14),8,2)
  call Hotf_5pt_reduction(G2H2(3),RedSet_5(7),mass5set(:,2),  & 
G1H2(19),G1H2(20),G1H2(21),G1H2(22),G1H2(23),G1H2(24),2)
  call HG1shiftOLR(G1H2(20),4,2)
  call Hotf_5pt_reduction(G2H2(4),RedSet_5(8),mass5set(:,3),  & 
G1H2(25),G1H2(26),G1H2(27),G1H2(28),G1H2(29),G1H2(30),2)
  call HG1shiftOLR(G1H2(26),8,2)
  call Hotf_5pt_reduction(G2H2(5),RedSet_5(9),mass5set(:,2),  & 
G1H2(31),G1H2(32),G1H2(33),G1H2(34),G1H2(35),G1H2(36),2)
  call HG1shiftOLR(G1H2(32),8,2)
  call Hotf_5pt_reduction(G2H2(6),RedSet_5(9),mass5set(:,2),  & 
G1H2(37),G1H2(38),G1H2(39),G1H2(40),G1H2(41),G1H2(42),2)
  call HG1shiftOLR(G1H2(38),4,2)
  call Hotf_5pt_reduction(G2H2(7),RedSet_5(10),mass5set(:,2),  & 
G1H2(43),G1H2(44),G1H2(45),G1H2(46),G1H2(47),G1H2(48),2)
  call HG1shiftOLR(G1H2(44),8,2)
  call Hotf_5pt_reduction(G2H2(8),RedSet_5(11),mass5set(:,2),  & 
G1H2(49),G1H2(50),G1H2(51),G1H2(52),G1H2(53),G1H2(54),2)
  call HG1shiftOLR(G1H2(50),4,2)
  call Hotf_5pt_reduction(G2H2(9),RedSet_5(12),mass5set(:,2),  & 
G1H2(55),G1H2(56),G1H2(57),G1H2(58),G1H2(59),G1H2(60),2)
  call HG1shiftOLR(G1H2(56),8,2)
  call Hotf_5pt_reduction(G2H2(10),RedSet_5(12),mass5set(:,2),  & 
G1H2(61),G1H2(62),G1H2(63),G1H2(64),G1H2(65),G1H2(66),2)
  call HG1shiftOLR(G1H2(62),4,2)
  call Hcheck_last_QA_V(ntryL,l_switch,G2H2(11),ex5(:),G2tensor(1),m3h2x1(:,1),heltab2x2(:,:,1))
  call Hcheck_last_QA_V(ntryL,l_switch,G2H2(13),ex5(:),G2tensor(2),m3h2x1(:,2),heltab2x2(:,:,2))
  call Hcheck_last_AQ_V(ntryL,l_switch,G2H2(15),ex4(:),G2tensor(3),m3h2x1(:,3),heltab2x2(:,:,3))
  call Hcheck_last_QA_V(ntryL,l_switch,G2H2(17),ex5(:),G2tensor(4),m3h2x1(:,4),heltab2x2(:,:,4))
  call Hcheck_last_QA_V(ntryL,l_switch,G2H2(19),ex5(:),G2tensor(5),m3h2x1(:,5),heltab2x2(:,:,5))
  call Hcheck_last_AQ_V(ntryL,l_switch,G2H2(21),ex4(:),G2tensor(6),m3h2x1(:,6),heltab2x2(:,:,6))
  call Hloop_VQ_A(ntryL,G1H2(7),ex4(:),G1H1(1),m3h2x1(:,7),heltab2x2(:,:,7))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(7),n2h1(1))
  call Hloop_VQ_A(ntryL,G1H2(8),ex4(:),G1H1(1),m3h2x1(:,8),heltab2x2(:,:,8))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),8,0,G2tensor(8),n2h1(2))
  call Hloop_ZQ_A(ntryL,G1H2(13),ex4(:),G1H1(1),ngZd,m3h2x1(:,9),heltab2x2(:,:,9))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(9),n2h1(3))
  call Hloop_ZQ_A(ntryL,G1H2(14),ex4(:),G1H1(1),ngZd,m3h2x1(:,10),heltab2x2(:,:,10))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),8,0,G2tensor(10),n2h1(4))
  call Hloop_VQ_A(ntryL,G1H2(19),ex3(:),G1H1(1),m3h2x1(:,11),heltab2x2(:,:,11))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(11),n2h1(5))
  call Hloop_VQ_A(ntryL,G1H2(20),ex3(:),G1H1(1),m3h2x1(:,12),heltab2x2(:,:,12))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),4,0,G2tensor(12),n2h1(6))
  call Hloop_ZQ_A(ntryL,G1H2(25),ex4(:),G1H1(1),ngZd,m3h2x1(:,13),heltab2x2(:,:,13))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(13),n2h1(7))
  call Hloop_ZQ_A(ntryL,G1H2(26),ex4(:),G1H1(1),ngZd,m3h2x1(:,14),heltab2x2(:,:,14))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),8,0,G2tensor(14),n2h1(8))
  call Hloop_VQ_A(ntryL,G1H2(31),ex4(:),G1H1(1),m3h2x1(:,15),heltab2x2(:,:,15))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(15),n2h1(9))
  call Hloop_VQ_A(ntryL,G1H2(32),ex4(:),G1H1(1),m3h2x1(:,16),heltab2x2(:,:,16))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),8,0,G2tensor(16),n2h1(10))
  call Hloop_VQ_A(ntryL,G1H2(37),ex3(:),G1H1(1),m3h2x1(:,17),heltab2x2(:,:,17))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(17),n2h1(11))
  call Hloop_VQ_A(ntryL,G1H2(38),ex3(:),G1H1(1),m3h2x1(:,18),heltab2x2(:,:,18))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),4,0,G2tensor(18),n2h1(12))
  call Hloop_VQ_A(ntryL,G1H2(43),ex4(:),G1H1(1),m3h2x1(:,19),heltab2x2(:,:,19))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(19),n2h1(13))
  call Hloop_VQ_A(ntryL,G1H2(44),ex4(:),G1H1(1),m3h2x1(:,20),heltab2x2(:,:,20))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),8,0,G2tensor(20),n2h1(14))
  call Hloop_VQ_A(ntryL,G1H2(49),ex3(:),G1H1(1),m3h2x1(:,21),heltab2x2(:,:,21))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(21),n2h1(15))
  call Hloop_VQ_A(ntryL,G1H2(50),ex3(:),G1H1(1),m3h2x1(:,22),heltab2x2(:,:,22))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),4,0,G2tensor(22),n2h1(16))
  call Hloop_VQ_A(ntryL,G1H2(55),ex4(:),G1H1(1),m3h2x1(:,23),heltab2x2(:,:,23))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(23),n2h1(17))
  call Hloop_VQ_A(ntryL,G1H2(56),ex4(:),G1H1(1),m3h2x1(:,24),heltab2x2(:,:,24))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),8,0,G2tensor(24),n2h1(18))
  call Hloop_VQ_A(ntryL,G1H2(61),ex3(:),G1H1(1),m3h2x1(:,25),heltab2x2(:,:,25))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(25),n2h1(19))
  call Hloop_VQ_A(ntryL,G1H2(62),ex3(:),G1H1(1),m3h2x1(:,26),heltab2x2(:,:,26))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),4,0,G2tensor(26),n2h1(20))
  call Hotf_5pt_reduction_last(G2tensor(1),RedSet_5(1),mass5set(:,1),  & 
G1tensor(1),G1tensor(2),G1tensor(3),G1tensor(4),G1tensor(5),G1tensor(6))
  call G_TensorShift(G1tensor(2),16)
  call Hotf_5pt_reduction_last(G2tensor(2),RedSet_5(2),mass5set(:,1),  & 
G1tensor(7),G1tensor(8),G1tensor(9),G1tensor(10),G1tensor(11),G1tensor(12))
  call G_TensorShift(G1tensor(8),16)
  call Hotf_5pt_reduction_last(G2tensor(3),RedSet_5(2),mass5set(:,1),  & 
G1tensor(13),G1tensor(14),G1tensor(15),G1tensor(16),G1tensor(17),G1tensor(18))
  call G_TensorShift(G1tensor(14),8)
  call Hotf_5pt_reduction_last(G2tensor(4),RedSet_5(3),mass5set(:,1),  & 
G1tensor(19),G1tensor(20),G1tensor(21),G1tensor(22),G1tensor(23),G1tensor(24))
  call G_TensorShift(G1tensor(20),16)
  call Hotf_5pt_reduction_last(G2tensor(5),RedSet_5(4),mass5set(:,1),  & 
G1tensor(25),G1tensor(26),G1tensor(27),G1tensor(28),G1tensor(29),G1tensor(30))
  call G_TensorShift(G1tensor(26),16)
  call Hotf_5pt_reduction_last(G2tensor(6),RedSet_5(4),mass5set(:,1),  & 
G1tensor(31),G1tensor(32),G1tensor(33),G1tensor(34),G1tensor(35),G1tensor(36))
  call G_TensorShift(G1tensor(32),8)
  call Hotf_5pt_reduction_last(G2tensor(7),RedSet_5(5),mass5set(:,2),  & 
G1tensor(37),G1tensor(38),G1tensor(39),G1tensor(40),G1tensor(41),G1tensor(42))
  call G_TensorShift(G1tensor(38),8)
  call Hotf_5pt_reduction_last(G2tensor(9),RedSet_5(6),mass5set(:,3),  & 
G1tensor(43),G1tensor(44),G1tensor(45),G1tensor(46),G1tensor(47),G1tensor(48))
  call G_TensorShift(G1tensor(44),8)
  call Hotf_5pt_reduction_last(G2tensor(11),RedSet_5(7),mass5set(:,2),  & 
G1tensor(49),G1tensor(50),G1tensor(51),G1tensor(52),G1tensor(53),G1tensor(54))
  call G_TensorShift(G1tensor(50),4)
  call Hotf_5pt_reduction_last(G2tensor(13),RedSet_5(8),mass5set(:,3),  & 
G1tensor(55),G1tensor(56),G1tensor(57),G1tensor(58),G1tensor(59),G1tensor(60))
  call G_TensorShift(G1tensor(56),8)
  call Hotf_5pt_reduction_last(G2tensor(15),RedSet_5(9),mass5set(:,2),  & 
G1tensor(61),G1tensor(62),G1tensor(63),G1tensor(64),G1tensor(65),G1tensor(66))
  call G_TensorShift(G1tensor(62),8)
  call Hotf_5pt_reduction_last(G2tensor(17),RedSet_5(9),mass5set(:,2),  & 
G1tensor(67),G1tensor(68),G1tensor(69),G1tensor(70),G1tensor(71),G1tensor(72))
  call G_TensorShift(G1tensor(68),4)
  call Hotf_5pt_reduction_last(G2tensor(19),RedSet_5(10),mass5set(:,2),  & 
G1tensor(73),G1tensor(74),G1tensor(75),G1tensor(76),G1tensor(77),G1tensor(78))
  call G_TensorShift(G1tensor(74),8)
  call Hotf_5pt_reduction_last(G2tensor(21),RedSet_5(11),mass5set(:,2),  & 
G1tensor(79),G1tensor(80),G1tensor(81),G1tensor(82),G1tensor(83),G1tensor(84))
  call G_TensorShift(G1tensor(80),4)
  call Hotf_5pt_reduction_last(G2tensor(23),RedSet_5(12),mass5set(:,2),  & 
G1tensor(85),G1tensor(86),G1tensor(87),G1tensor(88),G1tensor(89),G1tensor(90))
  call G_TensorShift(G1tensor(86),8)
  call Hotf_5pt_reduction_last(G2tensor(25),RedSet_5(12),mass5set(:,2),  & 
G1tensor(91),G1tensor(92),G1tensor(93),G1tensor(94),G1tensor(95),G1tensor(96))
  call G_TensorShift(G1tensor(92),4)
  call ol_merge_tensors(T1sum(1),[G1tensor(1)])
  call ol_merge_tensors(T1sum(2),[G1tensor(7)])
  call ol_merge_tensors(T1sum(3),[G1tensor(13)])
  call ol_merge_tensors(T1sum(4),[G1tensor(19)])
  call ol_merge_tensors(T1sum(5),[G1tensor(25)])
  call ol_merge_tensors(T1sum(6),[G1tensor(31)])
  call ol_merge_tensors(T1sum(7),[G1tensor(37)])
  call ol_merge_tensors(T1sum(8),[G1tensor(43)])
  call ol_merge_tensors(T1sum(9),[G1tensor(49)])
  call ol_merge_tensors(T1sum(10),[G1tensor(55)])
  call ol_merge_tensors(T1sum(11),[G1tensor(61)])
  call ol_merge_tensors(T1sum(12),[G1tensor(67)])
  call ol_merge_tensors(T1sum(13),[G1tensor(73)])
  call ol_merge_tensors(T1sum(14),[G1tensor(79)])
  call ol_merge_tensors(T1sum(15),[G1tensor(85)])
  call ol_merge_tensors(T1sum(16),[G1tensor(91)])
  Gcoeff(:)%j = (-(c(2)*M(2,:)%j)+c(1)*M(4,:)%j) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(17),h0tab(:,17),[32,3,8,4,16],[0,0,0,0,0],5,1,wf4(:,1))
  call Hloop_VA_Q(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,17),heltab2x64(:,:,17))
  call Hloop_A_Q(ntryL,G0H32(1),32,0,G1H32(1),n2h32(7))
  Gcoeff(:)%j = (-(c(2)*M(2,:)%j)+c(1)*M(4,:)%j) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(18),h0tab(:,18),[32,3,8,4,16],[0,0,0,0,0],5,1,wf4(:,1))
  call Hloop_VA_Q(ntryL,G0H64(1),ex6(:),G0H32(2),m3h2x32(:,18),heltab2x64(:,:,18))
  call Hloop_A_Q(ntryL,G0H32(2),32,0,G1H32(2),n2h32(8))
  Gcoeff(:)%j = (-(c(5)*M(2,:)%j)+c(4)*M(4,:)%j) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(19),h0tab(:,19),[32,3,8,4,16],[0,0,nMZ,0,0],5,1,wf4(:,1))
  call Hloop_VA_Q(ntryL,G0H64(1),ex6(:),G0H32(3),m3h2x32(:,19),heltab2x64(:,:,19))
  call Hloop_A_Q(ntryL,G0H32(3),32,0,G1H32(3),n2h32(9))
  Gcoeff(:)%j = (-(c(5)*M(2,:)%j)+c(4)*M(4,:)%j) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(20),h0tab(:,20),[32,3,8,4,16],[0,0,0,0,nMZ],5,1,wf4(:,1))
  call Hloop_ZA_Q(ntryL,G0H64(1),ex6(:),G0H32(4),ngZd,m3h2x32(:,20),heltab2x64(:,:,20))
  call Hloop_A_Q(ntryL,G0H32(4),32,0,G1H32(4),n2h32(10))
  Gcoeff(:)%j = (c(13)*M(1,:)%j-c(15)*M(3,:)%j) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(21),h0tab(:,21),[32,3,8,4,16],[0,0,0,0,0],5,1,wf4(:,1))
  call Hloop_VA_Q(ntryL,G0H64(1),ex6(:),G0H32(5),m3h2x32(:,21),heltab2x64(:,:,21))
  call Hloop_A_Q(ntryL,G0H32(5),32,0,G1H32(5),n2h32(11))
  Gcoeff(:)%j = (-(c(1)*M(2,:)%j)+c(2)*M(4,:)%j) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(22),h0tab(:,22),[32,4,8,3,16],[0,0,0,0,0],5,1,wf4(:,1))
  call Hloop_VA_Q(ntryL,G0H64(1),ex6(:),G0H32(6),m3h2x32(:,22),heltab2x64(:,:,22))
  call Hloop_A_Q(ntryL,G0H32(6),32,0,G1H32(6),n2h32(12))
  Gcoeff(:)%j = (-(c(1)*M(2,:)%j)+c(2)*M(4,:)%j) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(23),h0tab(:,23),[32,4,8,3,16],[0,0,0,0,0],5,1,wf4(:,1))
  call Hloop_VA_Q(ntryL,G0H64(1),ex6(:),G0H32(7),m3h2x32(:,23),heltab2x64(:,:,23))
  call Hloop_A_Q(ntryL,G0H32(7),32,0,G1H32(7),n2h32(13))
  Gcoeff(:)%j = (-(c(4)*M(2,:)%j)+c(5)*M(4,:)%j) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(24),h0tab(:,24),[32,4,8,3,16],[0,nMZ,0,0,0],5,1,wf4(:,1))
  call Hloop_VA_Q(ntryL,G0H64(1),ex6(:),G0H32(8),m3h2x32(:,24),heltab2x64(:,:,24))
  call Hloop_A_Q(ntryL,G0H32(8),32,0,G1H32(8),n2h32(14))
  Gcoeff(:)%j = (-(c(4)*M(2,:)%j)+c(5)*M(4,:)%j) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(25),h0tab(:,25),[32,4,8,3,16],[0,0,0,0,nMZ],5,1,wf4(:,1))
  call Hloop_ZA_Q(ntryL,G0H64(1),ex6(:),G0H32(9),ngZd,m3h2x32(:,25),heltab2x64(:,:,25))
  call Hloop_A_Q(ntryL,G0H32(9),32,0,G1H32(9),n2h32(15))
  Gcoeff(:)%j = (c(15)*M(1,:)%j-c(13)*M(3,:)%j) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(26),h0tab(:,26),[32,4,8,3,16],[0,0,0,0,0],5,1,wf4(:,1))
  call Hloop_VA_Q(ntryL,G0H64(1),ex6(:),G0H32(10),m3h2x32(:,26),heltab2x64(:,:,26))
  call Hloop_A_Q(ntryL,G0H32(10),32,0,G1H32(10),n2h32(16))
  Gcoeff(:)%j = (-(c(1)*M(2,:)%j)+c(2)*M(4,:)%j) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(27),h0tab(:,27),[32,3,4,8,16],[0,0,0,0,0],5,1,wf4(:,1))
  call Hloop_VA_Q(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,27),heltab2x64(:,:,27))
  call Hloop_A_Q(ntryL,G0H32(1),32,0,G1H32(11),n2h32(17))
  Gcoeff(:)%j = (-(c(1)*M(2,:)%j)+c(2)*M(4,:)%j) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(28),h0tab(:,28),[32,3,4,8,16],[0,0,0,0,0],5,1,wf4(:,1))
  call Hloop_VA_Q(ntryL,G0H64(1),ex6(:),G0H32(2),m3h2x32(:,28),heltab2x64(:,:,28))
  call Hloop_A_Q(ntryL,G0H32(2),32,0,G1H32(12),n2h32(18))
  Gcoeff(:)%j = (-(c(4)*M(2,:)%j)+c(5)*M(4,:)%j) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(29),h0tab(:,29),[32,3,4,8,16],[0,0,nMZ,0,0],5,1,wf4(:,1))
  call Hloop_VA_Q(ntryL,G0H64(1),ex6(:),G0H32(3),m3h2x32(:,29),heltab2x64(:,:,29))
  call Hloop_A_Q(ntryL,G0H32(3),32,0,G1H32(13),n2h32(19))
  Gcoeff(:)%j = (-(c(4)*M(2,:)%j)+c(5)*M(4,:)%j) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(30),h0tab(:,30),[32,3,4,8,16],[0,0,0,0,nMZ],5,1,wf4(:,1))
  call Hloop_ZA_Q(ntryL,G0H64(1),ex6(:),G0H32(4),ngZd,m3h2x32(:,30),heltab2x64(:,:,30))
  call Hloop_A_Q(ntryL,G0H32(4),32,0,G1H32(14),n2h32(20))
  Gcoeff(:)%j = (c(15)*M(1,:)%j-c(13)*M(3,:)%j) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(31),h0tab(:,31),[32,3,4,8,16],[0,0,0,0,0],5,1,wf4(:,1))
  call Hloop_VA_Q(ntryL,G0H64(1),ex6(:),G0H32(5),m3h2x32(:,31),heltab2x64(:,:,31))
  call Hloop_A_Q(ntryL,G0H32(5),32,0,G1H32(15),n2h32(21))
  Gcoeff(:)%j = (-(c(2)*M(2,:)%j)+c(1)*M(4,:)%j) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(32),h0tab(:,32),[32,8,4,3,16],[0,0,0,0,0],5,1,wf4(:,1))
  call Hloop_VA_Q(ntryL,G0H64(1),ex6(:),G0H32(6),m3h2x32(:,32),heltab2x64(:,:,32))
  call Hloop_A_Q(ntryL,G0H32(6),32,0,G1H32(16),n2h32(22))
  Gcoeff(:)%j = (-(c(2)*M(2,:)%j)+c(1)*M(4,:)%j) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(33),h0tab(:,33),[32,8,4,3,16],[0,0,0,0,0],5,1,wf4(:,1))
  call Hloop_VA_Q(ntryL,G0H64(1),ex6(:),G0H32(7),m3h2x32(:,33),heltab2x64(:,:,33))
  call Hloop_A_Q(ntryL,G0H32(7),32,0,G1H32(17),n2h32(23))
  Gcoeff(:)%j = (-(c(5)*M(2,:)%j)+c(4)*M(4,:)%j) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(34),h0tab(:,34),[32,8,4,3,16],[0,nMZ,0,0,0],5,1,wf4(:,1))
  call Hloop_VA_Q(ntryL,G0H64(1),ex6(:),G0H32(8),m3h2x32(:,34),heltab2x64(:,:,34))
  call Hloop_A_Q(ntryL,G0H32(8),32,0,G1H32(18),n2h32(24))
  Gcoeff(:)%j = (-(c(5)*M(2,:)%j)+c(4)*M(4,:)%j) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(35),h0tab(:,35),[32,8,4,3,16],[0,0,0,0,nMZ],5,1,wf4(:,1))
  call Hloop_ZA_Q(ntryL,G0H64(1),ex6(:),G0H32(9),ngZd,m3h2x32(:,35),heltab2x64(:,:,35))
  call Hloop_A_Q(ntryL,G0H32(9),32,0,G1H32(19),n2h32(25))
  Gcoeff(:)%j = (c(13)*M(1,:)%j-c(15)*M(3,:)%j) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(36),h0tab(:,36),[32,8,4,3,16],[0,0,0,0,0],5,1,wf4(:,1))
  call Hloop_VA_Q(ntryL,G0H64(1),ex6(:),G0H32(10),m3h2x32(:,36),heltab2x64(:,:,36))
  call Hloop_A_Q(ntryL,G0H32(10),32,0,G1H32(20),n2h32(26))
  Gcoeff(:)%j = (-(c(2)*M(2,:)%j)+c(1)*M(4,:)%j) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(37),h0tab(:,37),[32,3,8,16,4],[0,0,0,0,0],5,1,wf4(:,1))
  call Hloop_VA_Q(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,37),heltab2x64(:,:,37))
  call Hloop_A_Q(ntryL,G0H32(1),32,0,G1H32(21),n2h32(27))
  Gcoeff(:)%j = (-(c(2)*M(2,:)%j)+c(1)*M(4,:)%j) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(38),h0tab(:,38),[32,3,8,16,4],[0,0,0,0,0],5,1,wf4(:,1))
  call Hloop_VA_Q(ntryL,G0H64(1),ex6(:),G0H32(2),m3h2x32(:,38),heltab2x64(:,:,38))
  call Hloop_A_Q(ntryL,G0H32(2),32,0,G1H32(22),n2h32(28))
  Gcoeff(:)%j = (-(c(5)*M(2,:)%j)+c(4)*M(4,:)%j) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(39),h0tab(:,39),[32,3,8,16,4],[0,0,0,0,nMZ],5,1,wf4(:,1))
  call Hloop_ZA_Q(ntryL,G0H64(1),ex6(:),G0H32(3),ngZd,m3h2x32(:,39),heltab2x64(:,:,39))
  call Hloop_A_Q(ntryL,G0H32(3),32,0,G1H32(23),n2h32(29))
  Gcoeff(:)%j = (-(c(5)*M(2,:)%j)+c(4)*M(4,:)%j) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(40),h0tab(:,40),[32,3,8,16,4],[0,0,nMZ,0,0],5,1,wf4(:,1))
  call Hloop_VA_Q(ntryL,G0H64(1),ex6(:),G0H32(4),m3h2x32(:,40),heltab2x64(:,:,40))
  call Hloop_A_Q(ntryL,G0H32(4),32,0,G1H32(24),n2h32(30))
  Gcoeff(:)%j = (-(c(17)*M(1,:)%j)-c(11)*M(3,:)%j) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(41),h0tab(:,41),[32,3,8,16,4],[0,0,0,0,0],5,1,wf4(:,1))
  call Hloop_VA_Q(ntryL,G0H64(1),ex6(:),G0H32(5),m3h2x32(:,41),heltab2x64(:,:,41))
  call Hloop_A_Q(ntryL,G0H32(5),32,0,G1H32(25),n2h32(31))
  Gcoeff(:)%j = (-(c(1)*M(2,:)%j)+c(2)*M(4,:)%j) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(42),h0tab(:,42),[32,4,16,3,8],[0,0,0,0,0],5,1,wf4(:,1))
  call Hloop_VA_Q(ntryL,G0H64(1),ex6(:),G0H32(6),m3h2x32(:,42),heltab2x64(:,:,42))
  call Hloop_A_Q(ntryL,G0H32(6),32,0,G1H32(26),n2h32(32))
  Gcoeff(:)%j = (-(c(1)*M(2,:)%j)+c(2)*M(4,:)%j) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(43),h0tab(:,43),[32,4,16,3,8],[0,0,0,0,0],5,1,wf4(:,1))
  call Hloop_VA_Q(ntryL,G0H64(1),ex6(:),G0H32(7),m3h2x32(:,43),heltab2x64(:,:,43))
  call Hloop_A_Q(ntryL,G0H32(7),32,0,G1H32(27),n2h32(33))
  Gcoeff(:)%j = (-(c(4)*M(2,:)%j)+c(5)*M(4,:)%j) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(44),h0tab(:,44),[32,4,16,3,8],[0,nMZ,0,0,0],5,1,wf4(:,1))
  call Hloop_VA_Q(ntryL,G0H64(1),ex6(:),G0H32(8),m3h2x32(:,44),heltab2x64(:,:,44))
  call Hloop_A_Q(ntryL,G0H32(8),32,0,G1H32(28),n2h32(34))
  Gcoeff(:)%j = (-(c(4)*M(2,:)%j)+c(5)*M(4,:)%j) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(45),h0tab(:,45),[32,4,16,3,8],[0,0,0,0,nMZ],5,1,wf4(:,1))
  call Hloop_ZA_Q(ntryL,G0H64(1),ex6(:),G0H32(9),ngZd,m3h2x32(:,45),heltab2x64(:,:,45))
  call Hloop_A_Q(ntryL,G0H32(9),32,0,G1H32(29),n2h32(35))
  Gcoeff(:)%j = (c(11)*M(1,:)%j+c(17)*M(3,:)%j) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(46),h0tab(:,46),[32,4,16,3,8],[0,0,0,0,0],5,1,wf4(:,1))
  call Hloop_VA_Q(ntryL,G0H64(1),ex6(:),G0H32(10),m3h2x32(:,46),heltab2x64(:,:,46))
  call Hloop_A_Q(ntryL,G0H32(10),32,0,G1H32(30),n2h32(36))
  Gcoeff(:)%j = (-(c(1)*M(2,:)%j)+c(2)*M(4,:)%j) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(47),h0tab(:,47),[32,3,4,16,8],[0,0,0,0,0],5,1,wf4(:,1))
  call Hloop_VA_Q(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,47),heltab2x64(:,:,47))
  call Hloop_A_Q(ntryL,G0H32(1),32,0,G1H32(31),n2h32(37))
  Gcoeff(:)%j = (-(c(1)*M(2,:)%j)+c(2)*M(4,:)%j) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(48),h0tab(:,48),[32,3,4,16,8],[0,0,0,0,0],5,1,wf4(:,1))
  call Hloop_VA_Q(ntryL,G0H64(1),ex6(:),G0H32(2),m3h2x32(:,48),heltab2x64(:,:,48))
  call Hloop_A_Q(ntryL,G0H32(2),32,0,G1H32(32),n2h32(38))
  Gcoeff(:)%j = (-(c(4)*M(2,:)%j)+c(5)*M(4,:)%j) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(49),h0tab(:,49),[32,3,4,16,8],[0,0,nMZ,0,0],5,1,wf4(:,1))
  call Hloop_VA_Q(ntryL,G0H64(1),ex6(:),G0H32(3),m3h2x32(:,49),heltab2x64(:,:,49))
  call Hloop_A_Q(ntryL,G0H32(3),32,0,G1H32(33),n2h32(39))
  Gcoeff(:)%j = (-(c(4)*M(2,:)%j)+c(5)*M(4,:)%j) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(50),h0tab(:,50),[32,3,4,16,8],[0,0,0,0,nMZ],5,1,wf4(:,1))
  call Hloop_ZA_Q(ntryL,G0H64(1),ex6(:),G0H32(4),ngZd,m3h2x32(:,50),heltab2x64(:,:,50))
  call Hloop_A_Q(ntryL,G0H32(4),32,0,G1H32(34),n2h32(40))
  Gcoeff(:)%j = (c(11)*M(1,:)%j+c(17)*M(3,:)%j) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(51),h0tab(:,51),[32,3,4,16,8],[0,0,0,0,0],5,1,wf4(:,1))
  call Hloop_VA_Q(ntryL,G0H64(1),ex6(:),G0H32(5),m3h2x32(:,51),heltab2x64(:,:,51))
  call Hloop_A_Q(ntryL,G0H32(5),32,0,G1H32(35),n2h32(41))
  Gcoeff(:)%j = (-(c(2)*M(2,:)%j)+c(1)*M(4,:)%j) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(52),h0tab(:,52),[32,4,3,16,8],[0,0,0,0,0],5,1,wf4(:,1))
  call Hloop_QA_V(ntryL,G0H64(1),ex6(:),G0H32(6),m3h2x32(:,52),heltab2x64(:,:,52))
  Gcoeff(:)%j = (-(c(2)*M(2,:)%j)+c(1)*M(4,:)%j) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(53),h0tab(:,53),[32,4,3,16,8],[0,0,0,0,0],5,1,wf4(:,1))
  call Hloop_QA_V(ntryL,G0H64(1),ex6(:),G0H32(7),m3h2x32(:,53),heltab2x64(:,:,53))
  Gcoeff(:)%j = (-(c(5)*M(2,:)%j)+c(4)*M(4,:)%j) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(54),h0tab(:,54),[32,4,3,16,8],[nMZ,0,0,0,0],5,1,wf4(:,1))
  call Hloop_QA_Z(ntryL,G0H64(1),ex6(:),G0H32(8),ngZd,m3h2x32(:,54),heltab2x64(:,:,54))
  Gcoeff(:)%j = (-(c(5)*M(2,:)%j)+c(4)*M(4,:)%j) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(55),h0tab(:,55),[32,4,3,16,8],[0,0,0,nMZ,0],5,1,wf4(:,1))
  call Hloop_QA_V(ntryL,G0H64(1),ex6(:),G0H32(9),m3h2x32(:,55),heltab2x64(:,:,55))
  Gcoeff(:)%j = (-(c(17)*M(1,:)%j)-c(11)*M(3,:)%j) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(56),h0tab(:,56),[32,4,3,16,8],[0,0,0,0,0],5,1,wf4(:,1))
  call Hloop_QA_V(ntryL,G0H64(1),ex6(:),G0H32(10),m3h2x32(:,56),heltab2x64(:,:,56))
  Gcoeff(:)%j = (-(c(5)*M(2,:)%j)+c(4)*M(4,:)%j) * den(2)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(57),h0tab(:,57),[32,2,1,8,20],[nMZ,0,nMZ,0,0],5,1,wf4(:,2))
  call Hloop_QA_Z(ntryL,G0H64(1),ex6(:),G0H32(1),ngZd,m3h2x32(:,57),heltab2x64(:,:,57))
  Gcoeff(:)%j = (-(c(21)*M(2,:)%j)+c(20)*M(4,:)%j) * den(2)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(58),h0tab(:,58),[32,2,1,8,20],[nMW,0,nMW,0,0],5,1,wf4(:,2))
  call Hloop_QA_W(ntryL,G0H64(1),ex6(:),G0H32(2),m3h2x32(:,58),heltab2x64(:,:,58))
  Gcoeff(:)%j = (-(c(5)*M(2,:)%j)+c(4)*M(4,:)%j) * den(2)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(59),h0tab(:,59),[32,1,2,8,20],[nMZ,0,nMZ,0,0],5,1,wf4(:,2))
  call Hloop_QA_Z(ntryL,G0H64(1),ex6(:),G0H32(3),ngZd,m3h2x32(:,59),heltab2x64(:,:,59))
  Gcoeff(:)%j = (-(c(4)*M(2,:)%j)+c(5)*M(4,:)%j) * den(13)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(60),h0tab(:,60),[32,2,1,4,24],[nMZ,0,nMZ,0,0],5,1,wf4(:,4))
  call Hloop_QA_Z(ntryL,G0H64(1),ex6(:),G0H32(4),ngZd,m3h2x32(:,60),heltab2x64(:,:,60))
  Gcoeff(:)%j = (-(c(20)*M(2,:)%j)+c(21)*M(4,:)%j) * den(13)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(61),h0tab(:,61),[32,2,1,4,24],[nMW,0,nMW,0,0],5,1,wf4(:,4))
  call Hloop_QA_W(ntryL,G0H64(1),ex6(:),G0H32(5),m3h2x32(:,61),heltab2x64(:,:,61))
  Gcoeff(:)%j = (-(c(4)*M(2,:)%j)+c(5)*M(4,:)%j) * den(13)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(62),h0tab(:,62),[32,1,2,4,24],[nMZ,0,nMZ,0,0],5,1,wf4(:,4))
  call Hloop_QA_Z(ntryL,G0H64(1),ex6(:),G0H32(11),ngZd,m3h2x32(:,62),heltab2x64(:,:,62))
  Gcoeff(:)%j = (-(c(4)*M(2,:)%j)+c(5)*M(4,:)%j) * den(23)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(63),h0tab(:,63),[36,8,1,2,16],[0,nMZ,0,nMZ,0],5,1,wf4(:,6))
  call Hloop_AV_Q(ntryL,G0H64(1),wf4(:,6),G0H16(1),m3h4x16(:,1),heltab2x64(:,:,63))
  call Hloop_A_Q(ntryL,G0H16(1),36,0,G1H16(1),n2h16(11))
  Gcoeff(:)%j = (-(c(20)*M(2,:)%j)+c(21)*M(4,:)%j) * den(23)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(64),h0tab(:,64),[36,8,1,2,16],[0,nMW,0,nMW,0],5,1,wf4(:,6))
  call Hloop_AV_Q(ntryL,G0H64(1),wf4(:,6),G0H16(1),m3h4x16(:,2),heltab2x64(:,:,64))
  call Hloop_A_Q(ntryL,G0H16(1),36,0,G1H16(2),n2h16(12))
  Gcoeff(:)%j = (-(c(4)*M(2,:)%j)+c(5)*M(4,:)%j) * den(23)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(65),h0tab(:,65),[36,8,2,1,16],[0,nMZ,0,nMZ,0],5,1,wf4(:,6))
  call Hloop_AV_Q(ntryL,G0H64(1),wf4(:,6),G0H16(1),m3h4x16(:,3),heltab2x64(:,:,65))
  call Hloop_A_Q(ntryL,G0H16(1),36,0,G1H16(3),n2h16(13))
  Gcoeff(:)%j = (-(c(5)*M(2,:)%j)+c(4)*M(4,:)%j) * den(32)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(66),h0tab(:,66),[40,4,1,2,16],[0,nMZ,0,nMZ,0],5,1,wf4(:,8))
  call Hloop_AV_Q(ntryL,G0H64(1),wf4(:,8),G0H16(1),m3h4x16(:,4),heltab2x64(:,:,66))
  call Hloop_A_Q(ntryL,G0H16(1),40,0,G1H16(4),n2h16(14))
  Gcoeff(:)%j = (-(c(21)*M(2,:)%j)+c(20)*M(4,:)%j) * den(32)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(67),h0tab(:,67),[40,4,1,2,16],[0,nMW,0,nMW,0],5,1,wf4(:,8))
  call Hloop_AV_Q(ntryL,G0H64(1),wf4(:,8),G0H16(1),m3h4x16(:,5),heltab2x64(:,:,67))
  call Hloop_A_Q(ntryL,G0H16(1),40,0,G1H16(5),n2h16(15))
  Gcoeff(:)%j = (-(c(5)*M(2,:)%j)+c(4)*M(4,:)%j) * den(32)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(68),h0tab(:,68),[40,4,2,1,16],[0,nMZ,0,nMZ,0],5,1,wf4(:,8))
  call Hloop_AV_Q(ntryL,G0H64(1),wf4(:,8),G0H16(1),m3h4x16(:,6),heltab2x64(:,:,68))
  call Hloop_A_Q(ntryL,G0H16(1),40,0,G1H16(6),n2h16(16))
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H32(5),[G1H32(2),G1H32(1)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H32(10),[G1H32(7),G1H32(6)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H32(15),[G1H32(12),G1H32(11)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H32(20),[G1H32(17),G1H32(16)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H32(25),[G1H32(22),G1H32(21)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H32(30),[G1H32(27),G1H32(26)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H32(35),[G1H32(32),G1H32(31)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G0H32(10),[G0H32(7),G0H32(6)])
  call Hloop_AZ_Q(ntryL,G1H32(5),wf4(:,1),G1H8(1),ngZd,m3h4x8(:,1),heltab2x32(:,:,17))
  call Hloop_A_Q(ntryL,G1H8(1),35,0,G2H8(1),n2h8(7))
  call Hloop_AZ_Q(ntryL,G1H32(3),wf4(:,1),G1H8(2),ngZd,m3h4x8(:,2),heltab2x32(:,:,18))
  call Hloop_A_Q(ntryL,G1H8(2),35,0,G2H8(2),n2h8(8))
  call Hloop_AZ_Q(ntryL,G1H32(4),wf4(:,1),G1H8(3),ngZd,m3h4x8(:,3),heltab2x32(:,:,19))
  call Hloop_A_Q(ntryL,G1H8(3),35,0,G2H8(3),n2h8(9))
  call Hloop_AQ_V(ntryL,G1H32(10),ex3(:),G1H16(7),m3h2x16(:,17),heltab2x32(:,:,20))
  call Hloop_AQ_Z(ntryL,G1H32(8),ex3(:),G1H16(8),ngZd,m3h2x16(:,18),heltab2x32(:,:,21))
  call Hloop_AQ_V(ntryL,G1H32(9),ex3(:),G1H16(9),m3h2x16(:,19),heltab2x32(:,:,22))
  call Hloop_AZ_Q(ntryL,G1H32(15),wf4(:,1),G1H8(4),ngZd,m3h4x8(:,4),heltab2x32(:,:,23))
  call Hloop_A_Q(ntryL,G1H8(4),35,0,G2H8(4),n2h8(10))
  call Hloop_AZ_Q(ntryL,G1H32(13),wf4(:,1),G1H8(5),ngZd,m3h4x8(:,5),heltab2x32(:,:,24))
  call Hloop_A_Q(ntryL,G1H8(5),35,0,G2H8(5),n2h8(11))
  call Hloop_AZ_Q(ntryL,G1H32(14),wf4(:,1),G1H8(6),ngZd,m3h4x8(:,6),heltab2x32(:,:,25))
  call Hloop_A_Q(ntryL,G1H8(6),35,0,G2H8(6),n2h8(12))
  call Hloop_AQ_V(ntryL,G1H32(20),ex4(:),G1H16(10),m3h2x16(:,20),heltab2x32(:,:,26))
  call Hloop_AQ_Z(ntryL,G1H32(18),ex4(:),G1H16(11),ngZd,m3h2x16(:,21),heltab2x32(:,:,27))
  call Hloop_AQ_V(ntryL,G1H32(19),ex4(:),G1H16(12),m3h2x16(:,22),heltab2x32(:,:,28))
  call Hloop_AZ_Q(ntryL,G1H32(25),wf4(:,1),G1H8(7),ngZd,m3h4x8(:,7),heltab2x32(:,:,29))
  call Hloop_A_Q(ntryL,G1H8(7),35,0,G2H8(7),n2h8(13))
  call Hloop_AZ_Q(ntryL,G1H32(23),wf4(:,1),G1H8(8),ngZd,m3h4x8(:,8),heltab2x32(:,:,30))
  call Hloop_A_Q(ntryL,G1H8(8),35,0,G2H8(8),n2h8(14))
  call Hloop_AZ_Q(ntryL,G1H32(24),wf4(:,1),G1H8(9),ngZd,m3h4x8(:,9),heltab2x32(:,:,31))
  call Hloop_A_Q(ntryL,G1H8(9),35,0,G2H8(9),n2h8(15))
  call Hloop_AQ_V(ntryL,G1H32(30),ex3(:),G1H16(13),m3h2x16(:,23),heltab2x32(:,:,32))
  call Hloop_AQ_Z(ntryL,G1H32(28),ex3(:),G1H16(14),ngZd,m3h2x16(:,24),heltab2x32(:,:,33))
  call Hloop_AQ_V(ntryL,G1H32(29),ex3(:),G1H16(15),m3h2x16(:,25),heltab2x32(:,:,34))
  call Hloop_AZ_Q(ntryL,G1H32(35),wf4(:,1),G1H8(10),ngZd,m3h4x8(:,10),heltab2x32(:,:,35))
  call Hloop_A_Q(ntryL,G1H8(10),35,0,G2H8(10),n2h8(16))
  call Hloop_AZ_Q(ntryL,G1H32(33),wf4(:,1),G1H8(1),ngZd,m3h4x8(:,11),heltab2x32(:,:,36))
  call Hloop_A_Q(ntryL,G1H8(1),35,0,G2H8(11),n2h8(17))
  call Hloop_AZ_Q(ntryL,G1H32(34),wf4(:,1),G1H8(2),ngZd,m3h4x8(:,12),heltab2x32(:,:,37))
  call Hloop_A_Q(ntryL,G1H8(2),35,0,G2H8(12),n2h8(18))
  call Hloop_VQ_A(ntryL,G0H32(10),ex3(:),G0H16(1),m3h2x16(:,26),heltab2x32(:,:,38))
  call Hloop_Q_A(ntryL,G0H16(1),36,0,G1H16(16),n2h16(17))
  call Hloop_ZQ_A(ntryL,G0H32(8),ex3(:),G0H16(1),ngZd,m3h2x16(:,27),heltab2x32(:,:,39))
  call Hloop_Q_A(ntryL,G0H16(1),36,0,G1H16(17),n2h16(18))
  call Hloop_VQ_A(ntryL,G0H32(9),ex3(:),G0H16(1),m3h2x16(:,28),heltab2x32(:,:,40))
  call Hloop_Q_A(ntryL,G0H16(1),36,0,G1H16(18),n2h16(19))
  call Hloop_ZA_Q(ntryL,G0H32(1),ex2(:),G0H16(1),ngZn,m3h2x16(:,29),heltab2x32(:,:,41))
  call Hloop_A_Q(ntryL,G0H16(1),34,0,G1H16(19),n2h16(20))
  call Hloop_WA_Q(ntryL,G0H32(2),ex2(:),G0H16(1),m3h2x16(:,30),heltab2x32(:,:,42))
  call Hloop_A_Q(ntryL,G0H16(1),34,0,G1H16(20),n2h16(21))
  call Hloop_ZQ_A(ntryL,G0H32(3),ex1(:),G0H16(1),ngZn,m3h2x16(:,31),heltab2x32(:,:,43))
  call Hloop_Q_A(ntryL,G0H16(1),33,0,G1H16(21),n2h16(22))
  call Hloop_ZA_Q(ntryL,G0H32(4),ex2(:),G0H16(1),ngZn,m3h2x16(:,32),heltab2x32(:,:,44))
  call Hloop_A_Q(ntryL,G0H16(1),34,0,G1H16(22),n2h16(23))
  call Hloop_WA_Q(ntryL,G0H32(5),ex2(:),G0H16(1),m3h2x16(:,33),heltab2x32(:,:,45))
  call Hloop_A_Q(ntryL,G0H16(1),34,0,G1H16(23),n2h16(24))
  call Hloop_ZQ_A(ntryL,G0H32(11),ex1(:),G0H16(1),ngZn,m3h2x16(:,34),heltab2x32(:,:,46))
  call Hloop_Q_A(ntryL,G0H16(1),33,0,G1H16(24),n2h16(25))
  call Hloop_AQ_Z(ntryL,G1H16(1),ex4(:),G1H8(3),ngZd,m3h2x8(:,17),heltab2x16(:,:,17))
  call Hloop_AQ_W(ntryL,G1H16(2),ex4(:),G1H8(4),m3h2x8(:,18),heltab2x16(:,:,18))
  call Hloop_AQ_Z(ntryL,G1H16(3),ex4(:),G1H8(5),ngZd,m3h2x8(:,19),heltab2x16(:,:,19))
  call Hloop_AQ_Z(ntryL,G1H16(4),ex3(:),G1H8(6),ngZd,m3h2x8(:,20),heltab2x16(:,:,20))
  call Hloop_AQ_W(ntryL,G1H16(5),ex3(:),G1H8(7),m3h2x8(:,21),heltab2x16(:,:,21))
  call Hloop_AQ_Z(ntryL,G1H16(6),ex3(:),G1H8(8),ngZd,m3h2x8(:,22),heltab2x16(:,:,22))
  call Hloop_AQ_V(ntryL,G2H8(1),ex4(:),G2H4(1),m3h2x4(:,17),heltab2x8(:,:,17))
  call Hloop_AQ_Z(ntryL,G2H8(2),ex4(:),G2H4(2),ngZd,m3h2x4(:,18),heltab2x8(:,:,18))
  call Hloop_AQ_V(ntryL,G2H8(3),ex4(:),G2H4(3),m3h2x4(:,19),heltab2x8(:,:,19))
  call Hloop_VQ_A(ntryL,G1H16(7),ex4(:),G1H8(9),m3h2x8(:,23),heltab2x16(:,:,23))
  call Hloop_Q_A(ntryL,G1H8(9),44,0,G2H8(1),n2h8(19))
  call Hloop_ZQ_A(ntryL,G1H16(8),ex4(:),G1H8(10),ngZd,m3h2x8(:,24),heltab2x16(:,:,24))
  call Hloop_Q_A(ntryL,G1H8(10),44,0,G2H8(2),n2h8(20))
  call Hloop_VQ_A(ntryL,G1H16(9),ex4(:),G1H8(1),m3h2x8(:,25),heltab2x16(:,:,25))
  call Hloop_Q_A(ntryL,G1H8(1),44,0,G2H8(3),n2h8(21))
  call Hloop_AQ_V(ntryL,G2H8(4),ex3(:),G2H4(4),m3h2x4(:,20),heltab2x8(:,:,20))
  call Hloop_AQ_Z(ntryL,G2H8(5),ex3(:),G2H4(5),ngZd,m3h2x4(:,21),heltab2x8(:,:,21))
  call Hloop_AQ_V(ntryL,G2H8(6),ex3(:),G2H4(6),m3h2x4(:,22),heltab2x8(:,:,22))
  call Hloop_VQ_A(ntryL,G1H16(10),ex3(:),G1H8(2),m3h2x8(:,26),heltab2x16(:,:,26))
  call Hloop_Q_A(ntryL,G1H8(2),44,0,G2H8(4),n2h8(22))
  call Hloop_ZQ_A(ntryL,G1H16(11),ex3(:),G1H8(9),ngZd,m3h2x8(:,27),heltab2x16(:,:,27))
  call Hloop_Q_A(ntryL,G1H8(9),44,0,G2H8(5),n2h8(23))
  call Hloop_VQ_A(ntryL,G1H16(12),ex3(:),G1H8(10),m3h2x8(:,28),heltab2x16(:,:,28))
  call Hloop_Q_A(ntryL,G1H8(10),44,0,G2H8(6),n2h8(24))
  call Hloop_AQ_V(ntryL,G2H8(7),ex4(:),G2H4(7),m3h2x4(:,23),heltab2x8(:,:,23))
  call Hloop_AQ_V(ntryL,G2H8(8),ex4(:),G2H4(8),m3h2x4(:,24),heltab2x8(:,:,24))
  call Hloop_AQ_Z(ntryL,G2H8(9),ex4(:),G2H4(9),ngZd,m3h2x4(:,25),heltab2x8(:,:,25))
  call Hloop_VA_Q(ntryL,G1H16(13),ex5(:),G1H8(1),m3h2x8(:,29),heltab2x16(:,:,29))
  call Hloop_A_Q(ntryL,G1H8(1),52,0,G2H8(7),n2h8(25))
  call Hloop_ZA_Q(ntryL,G1H16(14),ex5(:),G1H8(2),ngZd,m3h2x8(:,30),heltab2x16(:,:,30))
  call Hloop_A_Q(ntryL,G1H8(2),52,0,G2H8(8),n2h8(26))
  call Hloop_VA_Q(ntryL,G1H16(15),ex5(:),G1H8(9),m3h2x8(:,31),heltab2x16(:,:,31))
  call Hloop_A_Q(ntryL,G1H8(9),52,0,G2H8(9),n2h8(27))
  call Hloop_AQ_V(ntryL,G2H8(10),ex3(:),G2H4(10),m3h2x4(:,26),heltab2x8(:,:,26))
  call Hloop_AQ_Z(ntryL,G2H8(11),ex3(:),G2H4(11),ngZd,m3h2x4(:,27),heltab2x8(:,:,27))
  call Hloop_AQ_V(ntryL,G2H8(12),ex3(:),G2H4(12),m3h2x4(:,28),heltab2x8(:,:,28))
  call Hloop_QZ_A(ntryL,G1H16(16),wf4(:,1),G1H4(1),ngZd,m3h4x4(:,1),heltab2x16(:,:,32))
  call Hloop_Q_A(ntryL,G1H4(1),39,0,G2H4(13),n2h4(17))
  call Hloop_QZ_A(ntryL,G1H16(17),wf4(:,1),G1H4(2),ngZd,m3h4x4(:,2),heltab2x16(:,:,33))
  call Hloop_Q_A(ntryL,G1H4(2),39,0,G2H4(14),n2h4(18))
  call Hloop_QZ_A(ntryL,G1H16(18),wf4(:,1),G1H4(6),ngZd,m3h4x4(:,3),heltab2x16(:,:,34))
  call Hloop_Q_A(ntryL,G1H4(6),39,0,G2H4(15),n2h4(19))
  call Hloop_AQ_Z(ntryL,G1H16(19),ex1(:),G1H8(10),ngZn,m3h2x8(:,32),heltab2x16(:,:,35))
  call Hloop_AQ_W(ntryL,G1H16(20),ex1(:),G1H8(1),m3h2x8(:,33),heltab2x16(:,:,36))
  call Hloop_QA_Z(ntryL,G1H16(21),ex2(:),G1H8(2),ngZn,m3h2x8(:,34),heltab2x16(:,:,37))
  call Hloop_AQ_Z(ntryL,G1H16(22),ex1(:),G1H8(9),ngZn,m3h2x8(:,35),heltab2x16(:,:,38))
  call Hloop_AQ_W(ntryL,G1H16(23),ex1(:),G1H8(11),m3h2x8(:,36),heltab2x16(:,:,39))
  call Hloop_QA_Z(ntryL,G1H16(24),ex2(:),G1H8(12),ngZn,m3h2x8(:,37),heltab2x16(:,:,40))
  call Hloop_ZQ_A(ntryL,G1H8(3),ex1(:),G1H4(7),ngZn,m3h2x4(:,29),heltab2x8(:,:,29))
  call Hloop_Q_A(ntryL,G1H4(7),45,0,G2H4(16),n2h4(20))
  call Hloop_WQ_A(ntryL,G1H8(4),ex1(:),G1H4(8),m3h2x4(:,30),heltab2x8(:,:,30))
  call Hloop_Q_A(ntryL,G1H4(8),45,0,G2H4(17),n2h4(21))
  call Hloop_ZA_Q(ntryL,G1H8(5),ex2(:),G1H4(12),ngZn,m3h2x4(:,31),heltab2x8(:,:,31))
  call Hloop_A_Q(ntryL,G1H4(12),46,0,G2H4(18),n2h4(22))
  call Hloop_ZQ_A(ntryL,G1H8(6),ex1(:),G1H4(13),ngZn,m3h2x4(:,32),heltab2x8(:,:,32))
  call Hloop_Q_A(ntryL,G1H4(13),45,0,G2H4(19),n2h4(23))
  call Hloop_WQ_A(ntryL,G1H8(7),ex1(:),G1H4(14),m3h2x4(:,33),heltab2x8(:,:,33))
  call Hloop_Q_A(ntryL,G1H4(14),45,0,G2H4(20),n2h4(24))
  call Hloop_ZA_Q(ntryL,G1H8(8),ex2(:),G1H4(18),ngZn,m3h2x4(:,34),heltab2x8(:,:,34))
  call Hloop_A_Q(ntryL,G1H4(18),46,0,G2H4(21),n2h4(25))
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(23),[G1H4(5)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(29),[G1H4(11)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(35),[G1H4(17)])
  call Hloop_ZQ_A(ntryL,G1H4(3),ex3(:),G1H2(7),ngZd,m3h2x2(:,29),heltab2x4(:,:,29))
  call Hloop_Q_A(ntryL,G1H2(7),47,0,G2H2(1),n2h2(13))
  call Hloop_ZQ_A(ntryL,G1H4(4),ex3(:),G1H2(8),ngZd,m3h2x2(:,30),heltab2x4(:,:,30))
  call Hloop_Q_A(ntryL,G1H2(8),47,0,G2H2(2),n2h2(14))
  call Hloop_ZQ_A(ntryL,G1H4(23),ex3(:),G1H2(13),ngZd,m3h2x2(:,31),heltab2x4(:,:,31))
  call Hloop_Q_A(ntryL,G1H2(13),47,0,G2H2(3),n2h2(15))
  call Hloop_ZQ_A(ntryL,G1H4(9),ex4(:),G1H2(14),ngZd,m3h2x2(:,32),heltab2x4(:,:,32))
  call Hloop_Q_A(ntryL,G1H2(14),47,0,G2H2(4),n2h2(16))
  call Hloop_ZQ_A(ntryL,G1H4(10),ex4(:),G1H2(19),ngZd,m3h2x2(:,33),heltab2x4(:,:,33))
  call Hloop_Q_A(ntryL,G1H2(19),47,0,G2H2(5),n2h2(17))
  call Hloop_ZQ_A(ntryL,G1H4(29),ex4(:),G1H2(20),ngZd,m3h2x2(:,34),heltab2x4(:,:,34))
  call Hloop_Q_A(ntryL,G1H2(20),47,0,G2H2(6),n2h2(18))
  call Hloop_ZA_Q(ntryL,G1H4(15),ex5(:),G1H2(25),ngZd,m3h2x2(:,35),heltab2x4(:,:,35))
  call Hloop_A_Q(ntryL,G1H2(25),55,0,G2H2(7),n2h2(19))
  call Hloop_ZA_Q(ntryL,G1H4(16),ex5(:),G1H2(26),ngZd,m3h2x2(:,36),heltab2x4(:,:,36))
  call Hloop_A_Q(ntryL,G1H2(26),55,0,G2H2(8),n2h2(20))
  call Hloop_ZA_Q(ntryL,G1H4(35),ex5(:),G1H2(31),ngZd,m3h2x2(:,37),heltab2x4(:,:,37))
  call Hloop_A_Q(ntryL,G1H2(31),55,0,G2H2(9),n2h2(21))
  call Hloop_ZQ_A(ntryL,G1H4(21),ex3(:),G1H2(32),ngZd,m3h2x2(:,38),heltab2x4(:,:,38))
  call Hloop_Q_A(ntryL,G1H2(32),47,0,G2H2(10),n2h2(22))
  call Hloop_ZQ_A(ntryL,G1H4(22),ex3(:),G1H2(37),ngZd,m3h2x2(:,39),heltab2x4(:,:,39))
  call Hloop_Q_A(ntryL,G1H2(37),47,0,G2H2(11),n2h2(23))
  call Hloop_ZQ_A(ntryL,G1H4(27),ex4(:),G1H2(38),ngZd,m3h2x2(:,40),heltab2x4(:,:,40))
  call Hloop_Q_A(ntryL,G1H2(38),47,0,G2H2(13),n2h2(24))
  call Hloop_ZQ_A(ntryL,G1H4(28),ex4(:),G1H2(43),ngZd,m3h2x2(:,41),heltab2x4(:,:,41))
  call Hloop_Q_A(ntryL,G1H2(43),47,0,G2H2(15),n2h2(25))
  call Hloop_ZA_Q(ntryL,G1H4(33),ex5(:),G1H2(44),ngZd,m3h2x2(:,42),heltab2x4(:,:,42))
  call Hloop_A_Q(ntryL,G1H2(44),55,0,G2H2(17),n2h2(26))
  call Hloop_ZA_Q(ntryL,G1H4(34),ex5(:),G1H2(49),ngZd,m3h2x2(:,43),heltab2x4(:,:,43))
  call Hloop_A_Q(ntryL,G1H2(49),55,0,G2H2(19),n2h2(27))
  call Hotf_5pt_reduction(G2H4(1),RedSet_5(13),mass5set(:,4),  & 
G1H4(19),G1H4(20),G1H4(24),G1H4(25),G1H4(26),G1H4(30),4)
  call HG1shiftOLR(G1H4(20),16,4)
  call Hotf_5pt_reduction(G2H4(2),RedSet_5(13),mass5set(:,3),  & 
G1H4(31),G1H4(32),G1H4(36),G1H4(1),G1H4(2),G1H4(6),4)
  call HG1shiftOLR(G1H4(32),16,4)
  call Hotf_5pt_reduction(G2H4(3),RedSet_5(13),mass5set(:,5),  & 
G1H4(7),G1H4(8),G1H4(12),G1H4(13),G1H4(14),G1H4(18),4)
  call HG1shiftOLR(G1H4(8),16,4)
  call Hotf_5pt_reduction(G2H8(1),RedSet_5(14),mass5set(:,4),  & 
G1H8(3),G1H8(4),G1H8(5),G1H8(6),G1H8(7),G1H8(8),8)
  call HG1shiftOLR(G1H8(4),16,8)
  call Hotf_5pt_reduction(G2H8(2),RedSet_5(14),mass5set(:,6),  & 
G1H8(13),G1H8(14),G1H8(15),G1H8(16),G1H8(17),G1H8(18),8)
  call HG1shiftOLR(G1H8(14),16,8)
  call Hotf_5pt_reduction(G2H8(3),RedSet_5(14),mass5set(:,5),  & 
G1H8(19),G1H8(20),G1H8(21),G1H8(22),G1H8(23),G1H8(24),8)
  call HG1shiftOLR(G1H8(20),16,8)
  call Hotf_5pt_reduction(G2H4(4),RedSet_5(15),mass5set(:,4),  & 
G1H4(5),G1H4(11),G1H4(17),G1H4(3),G1H4(4),G1H4(23),4)
  call HG1shiftOLR(G1H4(11),16,4)
  call Hotf_5pt_reduction(G2H4(5),RedSet_5(15),mass5set(:,3),  & 
G1H4(9),G1H4(10),G1H4(29),G1H4(15),G1H4(16),G1H4(35),4)
  call HG1shiftOLR(G1H4(10),16,4)
  call Hotf_5pt_reduction(G2H4(6),RedSet_5(15),mass5set(:,5),  & 
G1H4(21),G1H4(22),G1H4(27),G1H4(28),G1H4(33),G1H4(34),4)
  call HG1shiftOLR(G1H4(22),16,4)
  call Hotf_5pt_reduction(G2H8(4),RedSet_5(16),mass5set(:,4),  & 
G1H8(25),G1H8(26),G1H8(27),G1H8(28),G1H8(29),G1H8(30),8)
  call HG1shiftOLR(G1H8(26),16,8)
  call Hotf_5pt_reduction(G2H8(5),RedSet_5(16),mass5set(:,6),  & 
G1H8(31),G1H8(32),G1H8(33),G1H8(34),G1H8(35),G1H8(36),8)
  call HG1shiftOLR(G1H8(32),16,8)
  call Hotf_5pt_reduction(G2H8(6),RedSet_5(16),mass5set(:,5),  & 
G1H8(37),G1H8(38),G1H8(39),G1H8(40),G1H8(41),G1H8(42),8)
  call HG1shiftOLR(G1H8(38),16,8)
  call Hotf_5pt_reduction(G2H4(7),RedSet_5(17),mass5set(:,4),  & 
G1H4(37),G1H4(38),G1H4(39),G1H4(40),G1H4(41),G1H4(42),4)
  call HG1shiftOLR(G1H4(38),4,4)
  call Hotf_5pt_reduction(G2H4(8),RedSet_5(17),mass5set(:,5),  & 
G1H4(43),G1H4(44),G1H4(45),G1H4(46),G1H4(47),G1H4(48),4)
  call HG1shiftOLR(G1H4(44),4,4)
  call Hotf_5pt_reduction(G2H4(9),RedSet_5(17),mass5set(:,3),  & 
G1H4(49),G1H4(50),G1H4(51),G1H4(52),G1H4(53),G1H4(54),4)
  call HG1shiftOLR(G1H4(50),4,4)
  call Hotf_5pt_reduction(G2H8(7),RedSet_5(18),mass5set(:,4),  & 
G1H8(43),G1H8(44),G1H8(45),G1H8(46),G1H8(47),G1H8(48),8)
  call HG1shiftOLR(G1H8(44),8,8)
  call Hotf_5pt_reduction(G2H8(8),RedSet_5(18),mass5set(:,6),  & 
G1H8(49),G1H8(50),G1H8(51),G1H8(52),G1H8(53),G1H8(54),8)
  call HG1shiftOLR(G1H8(50),8,8)
  call Hotf_5pt_reduction(G2H8(9),RedSet_5(18),mass5set(:,5),  & 
G1H8(55),G1H8(56),G1H8(57),G1H8(58),G1H8(59),G1H8(60),8)
  call HG1shiftOLR(G1H8(56),8,8)
  call Hotf_5pt_reduction(G2H4(10),RedSet_5(19),mass5set(:,4),  & 
G1H4(55),G1H4(56),G1H4(57),G1H4(58),G1H4(59),G1H4(60),4)
  call HG1shiftOLR(G1H4(56),8,4)
  call Hotf_5pt_reduction(G2H4(11),RedSet_5(19),mass5set(:,3),  & 
G1H4(61),G1H4(62),G1H4(63),G1H4(64),G1H4(65),G1H4(66),4)
  call HG1shiftOLR(G1H4(62),8,4)
  call Hotf_5pt_reduction(G2H4(12),RedSet_5(19),mass5set(:,5),  & 
G1H4(67),G1H4(68),G1H4(69),G1H4(70),G1H4(71),G1H4(72),4)
  call HG1shiftOLR(G1H4(68),8,4)
  call Hloop_QA_V(ntryL,G2H4(13),ex5(:),G2H2(21),m3h2x2(:,44),heltab2x4(:,:,44))
  call Hloop_QA_V(ntryL,G2H4(14),ex5(:),G2H2(23),m3h2x2(:,45),heltab2x4(:,:,45))
  call Hloop_QA_Z(ntryL,G2H4(15),ex5(:),G2H2(24),ngZd,m3h2x2(:,46),heltab2x4(:,:,46))
  call Hloop_ZQ_A(ntryL,G1H8(10),ex4(:),G1H4(73),ngZd,m3h2x4(:,35),heltab2x8(:,:,35))
  call Hloop_Q_A(ntryL,G1H4(73),43,0,G2H4(1),n2h4(26))
  call Hloop_WQ_A(ntryL,G1H8(1),ex4(:),G1H4(73),m3h2x4(:,36),heltab2x8(:,:,36))
  call Hloop_Q_A(ntryL,G1H4(73),43,0,G2H4(2),n2h4(27))
  call Hloop_ZQ_A(ntryL,G1H8(2),ex4(:),G1H4(73),ngZd,m3h2x4(:,37),heltab2x8(:,:,37))
  call Hloop_Q_A(ntryL,G1H4(73),43,0,G2H4(3),n2h4(28))
  call Hloop_ZQ_A(ntryL,G1H8(9),ex3(:),G1H4(73),ngZd,m3h2x4(:,38),heltab2x8(:,:,38))
  call Hloop_Q_A(ntryL,G1H4(73),39,0,G2H4(4),n2h4(29))
  call Hloop_WQ_A(ntryL,G1H8(11),ex3(:),G1H4(73),m3h2x4(:,39),heltab2x8(:,:,39))
  call Hloop_Q_A(ntryL,G1H4(73),39,0,G2H4(5),n2h4(30))
  call Hloop_ZQ_A(ntryL,G1H8(12),ex3(:),G1H4(73),ngZd,m3h2x4(:,40),heltab2x8(:,:,40))
  call Hloop_Q_A(ntryL,G1H4(73),39,0,G2H4(6),n2h4(31))
  call Hloop_QA_Z(ntryL,G2H4(16),ex2(:),G2H2(25),ngZn,m3h2x2(:,47),heltab2x4(:,:,47))
  call Hloop_QA_W(ntryL,G2H4(17),ex2(:),G2H2(26),m3h2x2(:,48),heltab2x4(:,:,48))
  call Hloop_AQ_Z(ntryL,G2H4(18),ex1(:),G2H2(27),ngZn,m3h2x2(:,49),heltab2x4(:,:,49))
  call Hloop_QA_Z(ntryL,G2H4(19),ex2(:),G2H2(28),ngZn,m3h2x2(:,50),heltab2x4(:,:,50))
  call Hloop_QA_W(ntryL,G2H4(20),ex2(:),G2H2(29),m3h2x2(:,51),heltab2x4(:,:,51))
  call Hloop_AQ_Z(ntryL,G2H4(21),ex1(:),G2H2(30),ngZn,m3h2x2(:,52),heltab2x4(:,:,52))
  call Hloop_VQ_A(ntryL,G1H4(19),ex3(:),G1H2(50),m3h2x2(:,53),heltab2x4(:,:,53))
  call Hloop_Q_A(ntryL,G1H2(50),47,0,G2H2(31),n2h2(28))
call HGT_raise_alpha_OLR(G1H4(20),1,1,4)
call HGT_raise_alpha_invQ_OLR(G1H4(20),2,5,4)
  call Hloop_VA_Q(ntryL,G1H4(20),ex5(:),G1H2(55),m3h2x2(:,54),heltab2x4(:,:,54))
  call Hloop_VQ_A(ntryL,G1H4(26),ex3(:),G1H2(56),m3h2x2(:,55),heltab2x4(:,:,55))
  call Hloop_Q_A(ntryL,G1H2(56),47,0,G2H2(32),n2h2(29))
  call Hloop_VQ_A(ntryL,G1H4(30),ex3(:),G1H2(61),m3h2x2(:,56),heltab2x4(:,:,56))
  call Hloop_Q_A(ntryL,G1H2(61),47,0,G2H2(33),n2h2(30))
  call Hloop_ZQ_A(ntryL,G1H4(31),ex3(:),G1H2(62),ngZd,m3h2x2(:,57),heltab2x4(:,:,57))
  call Hloop_Q_A(ntryL,G1H2(62),47,0,G2H2(34),n2h2(31))
call HGT_raise_alpha_OLR(G1H4(32),1,1,4)
call HGT_raise_alpha_invQ_OLR(G1H4(32),2,5,4)
  call Hloop_VA_Q(ntryL,G1H4(32),ex5(:),G1H2(7),m3h2x2(:,58),heltab2x4(:,:,58))
  call Hloop_ZQ_A(ntryL,G1H4(2),ex3(:),G1H2(8),ngZd,m3h2x2(:,59),heltab2x4(:,:,59))
  call Hloop_Q_A(ntryL,G1H2(8),47,0,G2H2(35),n2h2(32))
  call Hloop_ZQ_A(ntryL,G1H4(6),ex3(:),G1H2(13),ngZd,m3h2x2(:,60),heltab2x4(:,:,60))
  call Hloop_Q_A(ntryL,G1H2(13),47,0,G2H2(36),n2h2(33))
  call Hloop_VQ_A(ntryL,G1H4(7),ex3(:),G1H2(14),m3h2x2(:,61),heltab2x4(:,:,61))
  call Hloop_Q_A(ntryL,G1H2(14),47,0,G2H2(37),n2h2(34))
call HGT_raise_alpha_OLR(G1H4(8),1,1,4)
call HGT_raise_alpha_invQ_OLR(G1H4(8),2,5,4)
  call Hloop_ZA_Q(ntryL,G1H4(8),ex5(:),G1H2(19),ngZd,m3h2x2(:,62),heltab2x4(:,:,62))
  call Hloop_VQ_A(ntryL,G1H4(14),ex3(:),G1H2(20),m3h2x2(:,63),heltab2x4(:,:,63))
  call Hloop_Q_A(ntryL,G1H2(20),47,0,G2H2(38),n2h2(35))
  call Hloop_VQ_A(ntryL,G1H4(18),ex3(:),G1H2(25),m3h2x2(:,64),heltab2x4(:,:,64))
  call Hloop_Q_A(ntryL,G1H2(25),47,0,G2H2(39),n2h2(36))
  call Hloop_QZ_A(ntryL,G1H8(3),wf4(:,1),G1H2(26),ngZd,m3h4x2(:,1),heltab2x8(:,:,41))
  call Hloop_Q_A(ntryL,G1H2(26),47,0,G2H2(40),n2h2(37))
call HGT_raise_alpha_OLR(G1H8(4),1,1,8)
call HGT_raise_alpha_invQ_OLR(G1H8(4),2,5,8)
  call Hloop_VA_Q(ntryL,G1H8(4),ex5(:),G1H4(73),m3h2x4(:,41),heltab2x8(:,:,42))
  call Hloop_QZ_A(ntryL,G1H8(7),wf4(:,1),G1H2(31),ngZd,m3h4x2(:,2),heltab2x8(:,:,43))
  call Hloop_Q_A(ntryL,G1H2(31),47,0,G2H2(41),n2h2(38))
  call Hloop_QZ_A(ntryL,G1H8(8),wf4(:,1),G1H2(32),ngZd,m3h4x2(:,3),heltab2x8(:,:,44))
  call Hloop_Q_A(ntryL,G1H2(32),47,0,G2H2(42),n2h2(39))
  call Hloop_QZ_A(ntryL,G1H8(13),wf4(:,1),G1H2(37),ngZd,m3h4x2(:,4),heltab2x8(:,:,45))
  call Hloop_Q_A(ntryL,G1H2(37),47,0,G2H2(43),n2h2(40))
call HGT_raise_alpha_OLR(G1H8(14),1,1,8)
call HGT_raise_alpha_invQ_OLR(G1H8(14),2,5,8)
  call Hloop_VA_Q(ntryL,G1H8(14),ex5(:),G1H4(19),m3h2x4(:,42),heltab2x8(:,:,46))
  call Hloop_QZ_A(ntryL,G1H8(17),wf4(:,1),G1H2(38),ngZd,m3h4x2(:,5),heltab2x8(:,:,47))
  call Hloop_Q_A(ntryL,G1H2(38),47,0,G2H2(44),n2h2(41))
  call Hloop_QZ_A(ntryL,G1H8(18),wf4(:,1),G1H2(43),ngZd,m3h4x2(:,6),heltab2x8(:,:,48))
  call Hloop_Q_A(ntryL,G1H2(43),47,0,G2H2(45),n2h2(42))
  call Hloop_QZ_A(ntryL,G1H8(19),wf4(:,1),G1H2(44),ngZd,m3h4x2(:,7),heltab2x8(:,:,49))
  call Hloop_Q_A(ntryL,G1H2(44),47,0,G2H2(46),n2h2(43))
call HGT_raise_alpha_OLR(G1H8(20),1,1,8)
call HGT_raise_alpha_invQ_OLR(G1H8(20),2,5,8)
  call Hloop_ZA_Q(ntryL,G1H8(20),ex5(:),G1H4(20),ngZd,m3h2x4(:,43),heltab2x8(:,:,50))
  call Hloop_QZ_A(ntryL,G1H8(23),wf4(:,1),G1H2(49),ngZd,m3h4x2(:,8),heltab2x8(:,:,51))
  call Hloop_Q_A(ntryL,G1H2(49),47,0,G2H2(47),n2h2(44))
  call Hloop_QZ_A(ntryL,G1H8(24),wf4(:,1),G1H2(50),ngZd,m3h4x2(:,9),heltab2x8(:,:,52))
  call Hloop_Q_A(ntryL,G1H2(50),47,0,G2H2(48),n2h2(45))
  call Hloop_VQ_A(ntryL,G1H4(5),ex4(:),G1H2(56),m3h2x2(:,65),heltab2x4(:,:,65))
  call Hloop_Q_A(ntryL,G1H2(56),47,0,G2H2(49),n2h2(46))
call HGT_raise_alpha_OLR(G1H4(11),1,1,4)
call HGT_raise_alpha_invQ_OLR(G1H4(11),2,5,4)
  call Hloop_VA_Q(ntryL,G1H4(11),ex5(:),G1H2(61),m3h2x2(:,66),heltab2x4(:,:,66))
  call Hloop_VQ_A(ntryL,G1H4(4),ex4(:),G1H2(62),m3h2x2(:,67),heltab2x4(:,:,67))
  call Hloop_Q_A(ntryL,G1H2(62),47,0,G2H2(50),n2h2(47))
  call Hloop_VQ_A(ntryL,G1H4(23),ex4(:),G1H2(8),m3h2x2(:,68),heltab2x4(:,:,68))
  call Hloop_Q_A(ntryL,G1H2(8),47,0,G2H2(51),n2h2(48))
  call Hloop_ZQ_A(ntryL,G1H4(9),ex4(:),G1H2(13),ngZd,m3h2x2(:,69),heltab2x4(:,:,69))
  call Hloop_Q_A(ntryL,G1H2(13),47,0,G2H2(52),n2h2(49))
call HGT_raise_alpha_OLR(G1H4(10),1,1,4)
call HGT_raise_alpha_invQ_OLR(G1H4(10),2,5,4)
  call Hloop_VA_Q(ntryL,G1H4(10),ex5(:),G1H2(14),m3h2x2(:,70),heltab2x4(:,:,70))
  call Hloop_ZQ_A(ntryL,G1H4(16),ex4(:),G1H2(20),ngZd,m3h2x2(:,71),heltab2x4(:,:,71))
  call Hloop_Q_A(ntryL,G1H2(20),47,0,G2H2(53),n2h2(50))
  call Hloop_ZQ_A(ntryL,G1H4(35),ex4(:),G1H2(25),ngZd,m3h2x2(:,72),heltab2x4(:,:,72))
  call Hloop_Q_A(ntryL,G1H2(25),47,0,G2H2(54),n2h2(51))
  call Hloop_VQ_A(ntryL,G1H4(21),ex4(:),G1H2(26),m3h2x2(:,73),heltab2x4(:,:,73))
  call Hloop_Q_A(ntryL,G1H2(26),47,0,G2H2(55),n2h2(52))
call HGT_raise_alpha_OLR(G1H4(22),1,1,4)
call HGT_raise_alpha_invQ_OLR(G1H4(22),2,5,4)
  call Hloop_ZA_Q(ntryL,G1H4(22),ex5(:),G1H2(31),ngZd,m3h2x2(:,74),heltab2x4(:,:,74))
  call Hloop_VQ_A(ntryL,G1H4(33),ex4(:),G1H2(32),m3h2x2(:,75),heltab2x4(:,:,75))
  call Hloop_Q_A(ntryL,G1H2(32),47,0,G2H2(56),n2h2(53))
  call Hloop_VQ_A(ntryL,G1H4(34),ex4(:),G1H2(37),m3h2x2(:,76),heltab2x4(:,:,76))
  call Hloop_Q_A(ntryL,G1H2(37),47,0,G2H2(57),n2h2(54))
  call Hloop_QZ_A(ntryL,G1H8(25),wf4(:,1),G1H2(38),ngZd,m3h4x2(:,10),heltab2x8(:,:,53))
  call Hloop_Q_A(ntryL,G1H2(38),47,0,G2H2(58),n2h2(55))
call HGT_raise_alpha_OLR(G1H8(26),1,1,8)
call HGT_raise_alpha_invQ_OLR(G1H8(26),2,5,8)
  call Hloop_VA_Q(ntryL,G1H8(26),ex5(:),G1H4(26),m3h2x4(:,44),heltab2x8(:,:,54))
  call Hloop_QZ_A(ntryL,G1H8(29),wf4(:,1),G1H2(43),ngZd,m3h4x2(:,11),heltab2x8(:,:,55))
  call Hloop_Q_A(ntryL,G1H2(43),47,0,G2H2(59),n2h2(56))
  call Hloop_QZ_A(ntryL,G1H8(30),wf4(:,1),G1H2(44),ngZd,m3h4x2(:,12),heltab2x8(:,:,56))
  call Hloop_Q_A(ntryL,G1H2(44),47,0,G2H2(60),n2h2(57))
  call Hloop_QZ_A(ntryL,G1H8(31),wf4(:,1),G1H2(49),ngZd,m3h4x2(:,13),heltab2x8(:,:,57))
  call Hloop_Q_A(ntryL,G1H2(49),47,0,G2H2(61),n2h2(58))
call HGT_raise_alpha_OLR(G1H8(32),1,1,8)
call HGT_raise_alpha_invQ_OLR(G1H8(32),2,5,8)
  call Hloop_VA_Q(ntryL,G1H8(32),ex5(:),G1H4(30),m3h2x4(:,45),heltab2x8(:,:,58))
  call Hloop_QZ_A(ntryL,G1H8(35),wf4(:,1),G1H2(50),ngZd,m3h4x2(:,14),heltab2x8(:,:,59))
  call Hloop_Q_A(ntryL,G1H2(50),47,0,G2H2(62),n2h2(59))
  call Hloop_QZ_A(ntryL,G1H8(36),wf4(:,1),G1H2(56),ngZd,m3h4x2(:,15),heltab2x8(:,:,60))
  call Hloop_Q_A(ntryL,G1H2(56),47,0,G2H2(63),n2h2(60))
  call Hloop_QZ_A(ntryL,G1H8(37),wf4(:,1),G1H2(62),ngZd,m3h4x2(:,16),heltab2x8(:,:,61))
  call Hloop_Q_A(ntryL,G1H2(62),47,0,G2H2(64),n2h2(61))
call HGT_raise_alpha_OLR(G1H8(38),1,1,8)
call HGT_raise_alpha_invQ_OLR(G1H8(38),2,5,8)
  call Hloop_ZA_Q(ntryL,G1H8(38),ex5(:),G1H4(31),ngZd,m3h2x4(:,46),heltab2x8(:,:,62))
  call Hloop_QZ_A(ntryL,G1H8(41),wf4(:,1),G1H2(8),ngZd,m3h4x2(:,17),heltab2x8(:,:,63))
  call Hloop_Q_A(ntryL,G1H2(8),47,0,G2H2(65),n2h2(62))
  call Hloop_QZ_A(ntryL,G1H8(42),wf4(:,1),G1H2(13),ngZd,m3h4x2(:,18),heltab2x8(:,:,64))
  call Hloop_Q_A(ntryL,G1H2(13),47,0,G2H2(66),n2h2(63))
  call Hloop_VA_Q(ntryL,G1H4(37),ex5(:),G1H2(20),m3h2x2(:,77),heltab2x4(:,:,77))
  call Hloop_A_Q(ntryL,G1H2(20),59,0,G2H2(67),n2h2(64))
call HGT_raise_alpha_OLR(G1H4(38),1,1,4)
call HGT_raise_alpha_invQ_OLR(G1H4(38),2,5,4)
  call Hloop_VQ_A(ntryL,G1H4(38),ex3(:),G1H2(25),m3h2x2(:,78),heltab2x4(:,:,78))
  call Hloop_VA_Q(ntryL,G1H4(41),ex5(:),G1H2(26),m3h2x2(:,79),heltab2x4(:,:,79))
  call Hloop_A_Q(ntryL,G1H2(26),59,0,G2H2(68),n2h2(65))
  call Hloop_VA_Q(ntryL,G1H4(42),ex5(:),G1H2(32),m3h2x2(:,80),heltab2x4(:,:,80))
  call Hloop_A_Q(ntryL,G1H2(32),59,0,G2H2(69),n2h2(66))
  call Hloop_VA_Q(ntryL,G1H4(43),ex5(:),G1H2(37),m3h2x2(:,81),heltab2x4(:,:,81))
  call Hloop_A_Q(ntryL,G1H2(37),59,0,G2H2(70),n2h2(67))
call HGT_raise_alpha_OLR(G1H4(44),1,1,4)
call HGT_raise_alpha_invQ_OLR(G1H4(44),2,5,4)
  call Hloop_ZQ_A(ntryL,G1H4(44),ex3(:),G1H2(38),ngZd,m3h2x2(:,82),heltab2x4(:,:,82))
  call Hloop_VA_Q(ntryL,G1H4(47),ex5(:),G1H2(43),m3h2x2(:,83),heltab2x4(:,:,83))
  call Hloop_A_Q(ntryL,G1H2(43),59,0,G2H2(71),n2h2(68))
  call Hloop_VA_Q(ntryL,G1H4(48),ex5(:),G1H2(44),m3h2x2(:,84),heltab2x4(:,:,84))
  call Hloop_A_Q(ntryL,G1H2(44),59,0,G2H2(72),n2h2(69))
  call Hloop_ZA_Q(ntryL,G1H4(49),ex5(:),G1H2(49),ngZd,m3h2x2(:,85),heltab2x4(:,:,85))
  call Hloop_A_Q(ntryL,G1H2(49),59,0,G2H2(73),n2h2(70))
call HGT_raise_alpha_OLR(G1H4(50),1,1,4)
call HGT_raise_alpha_invQ_OLR(G1H4(50),2,5,4)
  call Hloop_VQ_A(ntryL,G1H4(50),ex3(:),G1H2(50),m3h2x2(:,86),heltab2x4(:,:,86))
  call Hloop_ZA_Q(ntryL,G1H4(53),ex5(:),G1H2(56),ngZd,m3h2x2(:,87),heltab2x4(:,:,87))
  call Hloop_A_Q(ntryL,G1H2(56),59,0,G2H2(74),n2h2(71))
  call Hloop_ZA_Q(ntryL,G1H4(54),ex5(:),G1H2(62),ngZd,m3h2x2(:,88),heltab2x4(:,:,88))
  call Hloop_A_Q(ntryL,G1H2(62),59,0,G2H2(75),n2h2(72))
  call Hloop_AZ_Q(ntryL,G1H8(43),wf4(:,1),G1H2(8),ngZd,m3h4x2(:,19),heltab2x8(:,:,65))
  call Hloop_A_Q(ntryL,G1H2(8),55,0,G2H2(76),n2h2(73))
call HGT_raise_alpha_OLR(G1H8(44),1,1,8)
call HGT_raise_alpha_invQ_OLR(G1H8(44),2,5,8)
  call Hloop_VQ_A(ntryL,G1H8(44),ex4(:),G1H4(32),m3h2x4(:,47),heltab2x8(:,:,66))
  call Hloop_AZ_Q(ntryL,G1H8(47),wf4(:,1),G1H2(13),ngZd,m3h4x2(:,20),heltab2x8(:,:,67))
  call Hloop_A_Q(ntryL,G1H2(13),55,0,G2H2(77),n2h2(74))
  call Hloop_AZ_Q(ntryL,G1H8(48),wf4(:,1),G1H2(20),ngZd,m3h4x2(:,21),heltab2x8(:,:,68))
  call Hloop_A_Q(ntryL,G1H2(20),55,0,G2H2(78),n2h2(75))
  call Hloop_AZ_Q(ntryL,G1H8(49),wf4(:,1),G1H2(26),ngZd,m3h4x2(:,22),heltab2x8(:,:,69))
  call Hloop_A_Q(ntryL,G1H2(26),55,0,G2H2(79),n2h2(76))
call HGT_raise_alpha_OLR(G1H8(50),1,1,8)
call HGT_raise_alpha_invQ_OLR(G1H8(50),2,5,8)
  call Hloop_VQ_A(ntryL,G1H8(50),ex4(:),G1H4(2),m3h2x4(:,48),heltab2x8(:,:,70))
  call Hloop_AZ_Q(ntryL,G1H8(53),wf4(:,1),G1H2(32),ngZd,m3h4x2(:,23),heltab2x8(:,:,71))
  call Hloop_A_Q(ntryL,G1H2(32),55,0,G2H2(80),n2h2(77))
  call Hloop_AZ_Q(ntryL,G1H8(54),wf4(:,1),G1H2(37),ngZd,m3h4x2(:,24),heltab2x8(:,:,72))
  call Hloop_A_Q(ntryL,G1H2(37),55,0,G2H2(81),n2h2(78))
  call Hloop_AZ_Q(ntryL,G1H8(55),wf4(:,1),G1H2(43),ngZd,m3h4x2(:,25),heltab2x8(:,:,73))
  call Hloop_A_Q(ntryL,G1H2(43),55,0,G2H2(82),n2h2(79))
call HGT_raise_alpha_OLR(G1H8(56),1,1,8)
call HGT_raise_alpha_invQ_OLR(G1H8(56),2,5,8)
  call Hloop_ZQ_A(ntryL,G1H8(56),ex4(:),G1H4(6),ngZd,m3h2x4(:,49),heltab2x8(:,:,74))
  call Hloop_AZ_Q(ntryL,G1H8(59),wf4(:,1),G1H2(44),ngZd,m3h4x2(:,26),heltab2x8(:,:,75))
  call Hloop_A_Q(ntryL,G1H2(44),55,0,G2H2(83),n2h2(80))
  call Hloop_AZ_Q(ntryL,G1H8(60),wf4(:,1),G1H2(49),ngZd,m3h4x2(:,27),heltab2x8(:,:,76))
  call Hloop_A_Q(ntryL,G1H2(49),55,0,G2H2(84),n2h2(81))
  call Hloop_VA_Q(ntryL,G1H4(55),ex5(:),G1H2(56),m3h2x2(:,89),heltab2x4(:,:,89))
  call Hloop_A_Q(ntryL,G1H2(56),55,0,G2H2(85),n2h2(82))
call HGT_raise_alpha_OLR(G1H4(56),1,1,4)
call HGT_raise_alpha_invQ_OLR(G1H4(56),2,5,4)
  call Hloop_VQ_A(ntryL,G1H4(56),ex4(:),G1H2(62),m3h2x2(:,90),heltab2x4(:,:,90))
  call Hloop_VA_Q(ntryL,G1H4(59),ex5(:),G1H2(8),m3h2x2(:,91),heltab2x4(:,:,91))
  call Hloop_A_Q(ntryL,G1H2(8),55,0,G2H2(86),n2h2(83))
  call Hloop_VA_Q(ntryL,G1H4(60),ex5(:),G1H2(13),m3h2x2(:,92),heltab2x4(:,:,92))
  call Hloop_A_Q(ntryL,G1H2(13),55,0,G2H2(87),n2h2(84))
  call Hloop_ZA_Q(ntryL,G1H4(61),ex5(:),G1H2(20),ngZd,m3h2x2(:,93),heltab2x4(:,:,93))
  call Hloop_A_Q(ntryL,G1H2(20),55,0,G2H2(88),n2h2(85))
call HGT_raise_alpha_OLR(G1H4(62),1,1,4)
call HGT_raise_alpha_invQ_OLR(G1H4(62),2,5,4)
  call Hloop_VQ_A(ntryL,G1H4(62),ex4(:),G1H2(26),m3h2x2(:,94),heltab2x4(:,:,94))
  call Hloop_ZA_Q(ntryL,G1H4(65),ex5(:),G1H2(32),ngZd,m3h2x2(:,95),heltab2x4(:,:,95))
  call Hloop_A_Q(ntryL,G1H2(32),55,0,G2H2(89),n2h2(86))
  call Hloop_ZA_Q(ntryL,G1H4(66),ex5(:),G1H2(37),ngZd,m3h2x2(:,96),heltab2x4(:,:,96))
  call Hloop_A_Q(ntryL,G1H2(37),55,0,G2H2(90),n2h2(87))
  call Hloop_VA_Q(ntryL,G1H4(67),ex5(:),G1H2(43),m3h2x2(:,97),heltab2x4(:,:,97))
  call Hloop_A_Q(ntryL,G1H2(43),55,0,G2H2(91),n2h2(88))
call HGT_raise_alpha_OLR(G1H4(68),1,1,4)
call HGT_raise_alpha_invQ_OLR(G1H4(68),2,5,4)
  call Hloop_ZQ_A(ntryL,G1H4(68),ex4(:),G1H2(44),ngZd,m3h2x2(:,98),heltab2x4(:,:,98))
  call Hloop_VA_Q(ntryL,G1H4(71),ex5(:),G1H2(49),m3h2x2(:,99),heltab2x4(:,:,99))
  call Hloop_A_Q(ntryL,G1H2(49),55,0,G2H2(92),n2h2(89))
  call Hloop_VA_Q(ntryL,G1H4(72),ex5(:),G1H2(56),m3h2x2(:,100),heltab2x4(:,:,100))
  call Hloop_A_Q(ntryL,G1H2(56),55,0,G2H2(93),n2h2(90))
call HGT_w2_OLR(G1H2(3),1,1,2)
call HGT_w2_invQ_OLR(G1H2(3),2,5,2)
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(28),[G1H2(3)])
call HGT_w2_OLR(G1H2(6),1,1,2)
call HGT_w2_invQ_OLR(G1H2(6),2,5,2)
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(30),[G1H2(6)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(46),[G1H2(10)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(36),[G1H2(12)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(30),[G1H2(18)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(52),[G1H2(22)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(42),[G1H2(24)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(58),[G1H2(34)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(64),[G1H2(40)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(60),[G1H2(48)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(66),[G1H2(54)])
call HGT_w2_OLR(G1H2(1),1,1,2)
call HGT_w2_invQ_OLR(G1H2(1),2,5,2)
  call Hloop_ZQ_A(ntryL,G1H2(1),ex3(:),G1H1(1),ngZd,m3h2x1(:,27),heltab2x2(:,:,27))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(1),n2h1(21))
  call Hcheck_last_QA_V(ntryL,l_switch,G2H2(12),ex5(:),G2tensor(2),m3h2x1(:,28),heltab2x2(:,:,28))
call HGT_w2_OLR(G1H2(2),1,1,2)
call HGT_w2_invQ_OLR(G1H2(2),2,5,2)
  call Hloop_ZQ_A(ntryL,G1H2(2),ex4(:),G1H1(1),ngZd,m3h2x1(:,29),heltab2x2(:,:,29))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(3),n2h1(22))
  call Hcheck_last_QA_V(ntryL,l_switch,G2H2(14),ex5(:),G2tensor(4),m3h2x1(:,30),heltab2x2(:,:,30))
  call Hotf_5pt_reduction(G2H2(28),RedSet_5(20),mass5set(:,1),  & 
G1H2(8),G1H2(13),G1H2(20),G1H2(32),G1H2(37),G1H2(43),2)
  call HG1shiftOLR(G1H2(13),16,2)
  call Hcheck_last_AQ_V(ntryL,l_switch,G2H2(16),ex4(:),G2tensor(5),m3h2x1(:,31),heltab2x2(:,:,31))
call HGT_w2_OLR(G1H2(4),1,1,2)
call HGT_w2_invQ_OLR(G1H2(4),2,5,2)
  call Hloop_ZQ_A(ntryL,G1H2(4),ex3(:),G1H1(1),ngZd,m3h2x1(:,32),heltab2x2(:,:,32))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(6),n2h1(23))
  call Hcheck_last_QA_V(ntryL,l_switch,G2H2(18),ex5(:),G2tensor(7),m3h2x1(:,33),heltab2x2(:,:,33))
call HGT_w2_OLR(G1H2(5),1,1,2)
call HGT_w2_invQ_OLR(G1H2(5),2,5,2)
  call Hloop_ZQ_A(ntryL,G1H2(5),ex4(:),G1H1(1),ngZd,m3h2x1(:,34),heltab2x2(:,:,34))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(9),n2h1(24))
  call Hcheck_last_QA_V(ntryL,l_switch,G2H2(20),ex5(:),G2tensor(11),m3h2x1(:,35),heltab2x2(:,:,35))
  call Hotf_5pt_reduction(G2H2(30),RedSet_5(21),mass5set(:,1),  & 
G1H2(49),G1H2(56),G1H2(3),G1H2(6),G1H2(10),G1H2(12),2)
  call HG1shiftOLR(G1H2(56),16,2)
  call Hcheck_last_AQ_V(ntryL,l_switch,G2H2(22),ex4(:),G2tensor(13),m3h2x1(:,36),heltab2x2(:,:,36))
  call Hloop_VQ_A(ntryL,G1H2(9),ex4(:),G1H1(1),m3h2x1(:,37),heltab2x2(:,:,37))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(15),n2h1(25))
  call Hloop_VQ_A(ntryL,G1H2(46),ex4(:),G1H1(1),m3h2x1(:,38),heltab2x2(:,:,38))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(17),n2h1(26))
  call Hloop_VQ_A(ntryL,G1H2(11),ex4(:),G1H1(1),m3h2x1(:,39),heltab2x2(:,:,39))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(19),n2h1(27))
  call Hloop_VQ_A(ntryL,G1H2(36),ex4(:),G1H1(1),m3h2x1(:,40),heltab2x2(:,:,40))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(21),n2h1(28))
  call Hloop_ZQ_A(ntryL,G1H2(15),ex4(:),G1H1(1),ngZd,m3h2x1(:,41),heltab2x2(:,:,41))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(23),n2h1(29))
  call Hloop_ZQ_A(ntryL,G1H2(16),ex4(:),G1H1(1),ngZd,m3h2x1(:,42),heltab2x2(:,:,42))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(25),n2h1(30))
  call Hloop_ZQ_A(ntryL,G1H2(17),ex4(:),G1H1(1),ngZd,m3h2x1(:,43),heltab2x2(:,:,43))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(27),n2h1(31))
  call Hloop_ZQ_A(ntryL,G1H2(30),ex4(:),G1H1(1),ngZd,m3h2x1(:,44),heltab2x2(:,:,44))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(28),n2h1(32))
  call Hloop_VQ_A(ntryL,G1H2(21),ex3(:),G1H1(1),m3h2x1(:,45),heltab2x2(:,:,45))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(29),n2h1(33))
  call Hloop_VQ_A(ntryL,G1H2(52),ex3(:),G1H1(1),m3h2x1(:,46),heltab2x2(:,:,46))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(30),n2h1(34))
  call Hloop_VQ_A(ntryL,G1H2(23),ex3(:),G1H1(1),m3h2x1(:,47),heltab2x2(:,:,47))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(31),n2h1(35))
  call Hloop_VQ_A(ntryL,G1H2(42),ex3(:),G1H1(1),m3h2x1(:,48),heltab2x2(:,:,48))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(32),n2h1(36))
  call Hloop_ZQ_A(ntryL,G1H2(27),ex4(:),G1H1(1),ngZd,m3h2x1(:,49),heltab2x2(:,:,49))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(33),n2h1(37))
  call Hloop_ZQ_A(ntryL,G1H2(28),ex4(:),G1H1(1),ngZd,m3h2x1(:,50),heltab2x2(:,:,50))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(34),n2h1(38))
  call Hloop_ZQ_A(ntryL,G1H2(29),ex4(:),G1H1(1),ngZd,m3h2x1(:,51),heltab2x2(:,:,51))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(35),n2h1(39))
  call Hloop_VQ_A(ntryL,G1H2(33),ex4(:),G1H1(1),m3h2x1(:,52),heltab2x2(:,:,52))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(36),n2h1(40))
  call Hloop_VQ_A(ntryL,G1H2(58),ex4(:),G1H1(1),m3h2x1(:,53),heltab2x2(:,:,53))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(37),n2h1(41))
  call Hloop_VQ_A(ntryL,G1H2(35),ex4(:),G1H1(1),m3h2x1(:,54),heltab2x2(:,:,54))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(38),n2h1(42))
  call Hloop_VQ_A(ntryL,G1H2(39),ex3(:),G1H1(1),m3h2x1(:,55),heltab2x2(:,:,55))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(39),n2h1(43))
  call Hloop_VQ_A(ntryL,G1H2(64),ex3(:),G1H1(1),m3h2x1(:,56),heltab2x2(:,:,56))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(40),n2h1(44))
  call Hloop_VQ_A(ntryL,G1H2(41),ex3(:),G1H1(1),m3h2x1(:,57),heltab2x2(:,:,57))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(41),n2h1(45))
  call Hloop_VQ_A(ntryL,G1H2(45),ex4(:),G1H1(1),m3h2x1(:,58),heltab2x2(:,:,58))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(42),n2h1(46))
  call Hloop_VQ_A(ntryL,G1H2(47),ex4(:),G1H1(1),m3h2x1(:,59),heltab2x2(:,:,59))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(43),n2h1(47))
  call Hloop_VQ_A(ntryL,G1H2(60),ex4(:),G1H1(1),m3h2x1(:,60),heltab2x2(:,:,60))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(44),n2h1(48))
  call Hloop_VQ_A(ntryL,G1H2(51),ex3(:),G1H1(1),m3h2x1(:,61),heltab2x2(:,:,61))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(45),n2h1(49))
  call Hloop_VQ_A(ntryL,G1H2(53),ex3(:),G1H1(1),m3h2x1(:,62),heltab2x2(:,:,62))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(46),n2h1(50))
  call Hloop_VQ_A(ntryL,G1H2(66),ex3(:),G1H1(1),m3h2x1(:,63),heltab2x2(:,:,63))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(47),n2h1(51))
  call Hloop_VQ_A(ntryL,G1H2(57),ex4(:),G1H1(1),m3h2x1(:,64),heltab2x2(:,:,64))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(48),n2h1(52))
  call Hloop_VQ_A(ntryL,G1H2(59),ex4(:),G1H1(1),m3h2x1(:,65),heltab2x2(:,:,65))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(49),n2h1(53))
  call Hloop_VQ_A(ntryL,G1H2(63),ex3(:),G1H1(1),m3h2x1(:,66),heltab2x2(:,:,66))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(50),n2h1(54))
  call Hloop_VQ_A(ntryL,G1H2(65),ex3(:),G1H1(1),m3h2x1(:,67),heltab2x2(:,:,67))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(51),n2h1(55))
  call Hcheck_last_QA_V(ntryL,l_switch,G2H2(1),ex5(:),G2tensor(52),m3h2x1(:,68),heltab2x2(:,:,68))
  call Hcheck_last_QA_V(ntryL,l_switch,G2H2(2),ex5(:),G2tensor(53),m3h2x1(:,69),heltab2x2(:,:,69))
  call Hcheck_last_QA_V(ntryL,l_switch,G2H2(3),ex5(:),G2tensor(54),m3h2x1(:,70),heltab2x2(:,:,70))
  call Hcheck_last_QA_V(ntryL,l_switch,G2H2(4),ex5(:),G2tensor(55),m3h2x1(:,71),heltab2x2(:,:,71))
  call Hcheck_last_QA_V(ntryL,l_switch,G2H2(5),ex5(:),G2tensor(56),m3h2x1(:,72),heltab2x2(:,:,72))
  call Hcheck_last_QA_V(ntryL,l_switch,G2H2(6),ex5(:),G2tensor(57),m3h2x1(:,73),heltab2x2(:,:,73))
  call Hcheck_last_AQ_V(ntryL,l_switch,G2H2(7),ex4(:),G2tensor(58),m3h2x1(:,74),heltab2x2(:,:,74))
  call Hcheck_last_AQ_V(ntryL,l_switch,G2H2(8),ex4(:),G2tensor(59),m3h2x1(:,75),heltab2x2(:,:,75))
  call Hcheck_last_AQ_V(ntryL,l_switch,G2H2(9),ex4(:),G2tensor(60),m3h2x1(:,76),heltab2x2(:,:,76))
  call Hcheck_last_QA_V(ntryL,l_switch,G2H2(10),ex5(:),G2tensor(61),m3h2x1(:,77),heltab2x2(:,:,77))
  call Hcheck_last_QA_V(ntryL,l_switch,G2H2(11),ex5(:),G2tensor(62),m3h2x1(:,78),heltab2x2(:,:,78))
  call Hcheck_last_QA_V(ntryL,l_switch,G2H2(13),ex5(:),G2tensor(63),m3h2x1(:,79),heltab2x2(:,:,79))
  call Hcheck_last_QA_V(ntryL,l_switch,G2H2(15),ex5(:),G2tensor(64),m3h2x1(:,80),heltab2x2(:,:,80))
  call Hcheck_last_AQ_V(ntryL,l_switch,G2H2(17),ex4(:),G2tensor(65),m3h2x1(:,81),heltab2x2(:,:,81))
  call Hcheck_last_AQ_V(ntryL,l_switch,G2H2(19),ex4(:),G2tensor(66),m3h2x1(:,82),heltab2x2(:,:,82))
  call Hotf_5pt_reduction(G2H2(21),RedSet_5(22),mass5set(:,4),  & 
G1H2(18),G1H2(22),G1H2(24),G1H2(34),G1H2(40),G1H2(48),2)
  call HG1shiftOLR(G1H2(22),8,2)
  call Hotf_5pt_reduction(G2H2(23),RedSet_5(22),mass5set(:,7),  & 
G1H2(54),G1H2(1),G1H2(2),G1H2(4),G1H2(5),G1H2(9),2)
  call HG1shiftOLR(G1H2(1),8,2)
  call Hotf_5pt_reduction(G2H2(24),RedSet_5(22),mass5set(:,8),  & 
G1H2(46),G1H2(11),G1H2(36),G1H2(15),G1H2(16),G1H2(17),2)
  call HG1shiftOLR(G1H2(11),8,2)
  call Hotf_5pt_reduction(G2H4(1),RedSet_5(7),mass5set(:,2),  & 
G1H4(7),G1H4(8),G1H4(14),G1H4(18),G1H4(5),G1H4(11),4)
  call HG1shiftOLR(G1H4(8),20,4)
  call Hotf_5pt_reduction(G2H4(2),RedSet_5(7),mass5set(:,9),  & 
G1H4(4),G1H4(23),G1H4(9),G1H4(10),G1H4(16),G1H4(35),4)
  call HG1shiftOLR(G1H4(23),20,4)
  call Hotf_5pt_reduction(G2H4(3),RedSet_5(11),mass5set(:,2),  & 
G1H4(21),G1H4(22),G1H4(33),G1H4(34),G1H4(37),G1H4(38),4)
  call HG1shiftOLR(G1H4(22),20,4)
  call Hotf_5pt_reduction(G2H4(4),RedSet_5(5),mass5set(:,2),  & 
G1H4(41),G1H4(42),G1H4(43),G1H4(44),G1H4(47),G1H4(48),4)
  call HG1shiftOLR(G1H4(42),24,4)
  call Hotf_5pt_reduction(G2H4(5),RedSet_5(5),mass5set(:,9),  & 
G1H4(49),G1H4(50),G1H4(53),G1H4(54),G1H4(55),G1H4(56),4)
  call HG1shiftOLR(G1H4(50),24,4)
  call Hotf_5pt_reduction(G2H4(6),RedSet_5(10),mass5set(:,2),  & 
G1H4(59),G1H4(60),G1H4(61),G1H4(62),G1H4(65),G1H4(66),4)
  call HG1shiftOLR(G1H4(60),24,4)
  call Hotf_5pt_reduction(G2H2(25),RedSet_5(23),mass5set(:,1),  & 
G1H2(30),G1H2(21),G1H2(52),G1H2(23),G1H2(42),G1H2(27),2)
  call HG1shiftOLR(G1H2(21),16,2)
  call Hotf_5pt_reduction(G2H2(26),RedSet_5(23),mass5set(:,10),  & 
G1H2(28),G1H2(29),G1H2(33),G1H2(58),G1H2(35),G1H2(39),2)
  call HG1shiftOLR(G1H2(29),16,2)
  call Hotf_5pt_reduction(G2H2(27),RedSet_5(24),mass5set(:,1),  & 
G1H2(64),G1H2(41),G1H2(45),G1H2(47),G1H2(60),G1H2(51),2)
  call HG1shiftOLR(G1H2(41),16,2)
  call Hotf_5pt_reduction(G2H2(29),RedSet_5(20),mass5set(:,10),  & 
G1H2(53),G1H2(66),G1H2(57),G1H2(59),G1H2(63),G1H2(65),2)
  call HG1shiftOLR(G1H2(66),16,2)
  call Hcheck_last_QA_V(ntryL,l_switch,G2H2(31),ex5(:),G2tensor(67),m3h2x1(:,83),heltab2x2(:,:,83))
  call Hcheck_last_QA_V(ntryL,l_switch,G2H2(33),ex5(:),G2tensor(68),m3h2x1(:,84),heltab2x2(:,:,84))
  call Hcheck_last_QA_V(ntryL,l_switch,G2H2(34),ex5(:),G2tensor(69),m3h2x1(:,85),heltab2x2(:,:,85))
  call Hcheck_last_QA_V(ntryL,l_switch,G2H2(36),ex5(:),G2tensor(70),m3h2x1(:,86),heltab2x2(:,:,86))
  call Hcheck_last_QA_Z(ntryL,l_switch,G2H2(37),ex5(:),G2tensor(71),ngZd,m3h2x1(:,87),heltab2x2(:,:,87))
  call Hcheck_last_QA_Z(ntryL,l_switch,G2H2(39),ex5(:),G2tensor(72),ngZd,m3h2x1(:,88),heltab2x2(:,:,88))
  call Hcheck_last_QA_V(ntryL,l_switch,G2H2(40),ex5(:),G2tensor(73),m3h2x1(:,89),heltab2x2(:,:,89))
  call Hcheck_last_QA_V(ntryL,l_switch,G2H2(42),ex5(:),G2tensor(74),m3h2x1(:,90),heltab2x2(:,:,90))
  call Hcheck_last_QA_V(ntryL,l_switch,G2H2(43),ex5(:),G2tensor(75),m3h2x1(:,91),heltab2x2(:,:,91))
  call Hcheck_last_QA_V(ntryL,l_switch,G2H2(45),ex5(:),G2tensor(76),m3h2x1(:,92),heltab2x2(:,:,92))
  call Hcheck_last_QA_Z(ntryL,l_switch,G2H2(46),ex5(:),G2tensor(77),ngZd,m3h2x1(:,93),heltab2x2(:,:,93))
  call Hcheck_last_QA_Z(ntryL,l_switch,G2H2(48),ex5(:),G2tensor(78),ngZd,m3h2x1(:,94),heltab2x2(:,:,94))
  call Hcheck_last_QA_V(ntryL,l_switch,G2H2(49),ex5(:),G2tensor(79),m3h2x1(:,95),heltab2x2(:,:,95))
  call Hcheck_last_QA_V(ntryL,l_switch,G2H2(51),ex5(:),G2tensor(80),m3h2x1(:,96),heltab2x2(:,:,96))
  call Hcheck_last_QA_V(ntryL,l_switch,G2H2(52),ex5(:),G2tensor(81),m3h2x1(:,97),heltab2x2(:,:,97))
  call Hcheck_last_QA_V(ntryL,l_switch,G2H2(54),ex5(:),G2tensor(82),m3h2x1(:,98),heltab2x2(:,:,98))
  call Hcheck_last_QA_Z(ntryL,l_switch,G2H2(55),ex5(:),G2tensor(83),ngZd,m3h2x1(:,99),heltab2x2(:,:,99))
  call Hcheck_last_QA_Z(ntryL,l_switch,G2H2(57),ex5(:),G2tensor(84),ngZd,m3h2x1(:,100),heltab2x2(:,:,100))
  call Hcheck_last_QA_V(ntryL,l_switch,G2H2(58),ex5(:),G2tensor(85),m3h2x1(:,101),heltab2x2(:,:,101))
  call Hcheck_last_QA_V(ntryL,l_switch,G2H2(60),ex5(:),G2tensor(86),m3h2x1(:,102),heltab2x2(:,:,102))
  call Hcheck_last_QA_V(ntryL,l_switch,G2H2(61),ex5(:),G2tensor(87),m3h2x1(:,103),heltab2x2(:,:,103))
  call Hcheck_last_QA_V(ntryL,l_switch,G2H2(63),ex5(:),G2tensor(88),m3h2x1(:,104),heltab2x2(:,:,104))
  call Hcheck_last_QA_Z(ntryL,l_switch,G2H2(64),ex5(:),G2tensor(89),ngZd,m3h2x1(:,105),heltab2x2(:,:,105))
  call Hcheck_last_QA_Z(ntryL,l_switch,G2H2(66),ex5(:),G2tensor(90),ngZd,m3h2x1(:,106),heltab2x2(:,:,106))
  call Hcheck_last_AQ_V(ntryL,l_switch,G2H2(67),ex3(:),G2tensor(91),m3h2x1(:,107),heltab2x2(:,:,107))
  call Hcheck_last_AQ_V(ntryL,l_switch,G2H2(69),ex3(:),G2tensor(92),m3h2x1(:,108),heltab2x2(:,:,108))
  call Hcheck_last_AQ_Z(ntryL,l_switch,G2H2(70),ex3(:),G2tensor(93),ngZd,m3h2x1(:,109),heltab2x2(:,:,109))
  call Hcheck_last_AQ_Z(ntryL,l_switch,G2H2(72),ex3(:),G2tensor(94),ngZd,m3h2x1(:,110),heltab2x2(:,:,110))
  call Hcheck_last_AQ_V(ntryL,l_switch,G2H2(73),ex3(:),G2tensor(95),m3h2x1(:,111),heltab2x2(:,:,111))
  call Hcheck_last_AQ_V(ntryL,l_switch,G2H2(75),ex3(:),G2tensor(96),m3h2x1(:,112),heltab2x2(:,:,112))
  call Hcheck_last_AQ_V(ntryL,l_switch,G2H2(76),ex4(:),G2tensor(97),m3h2x1(:,113),heltab2x2(:,:,113))
  call Hcheck_last_AQ_V(ntryL,l_switch,G2H2(78),ex4(:),G2tensor(98),m3h2x1(:,114),heltab2x2(:,:,114))
  call Hcheck_last_AQ_V(ntryL,l_switch,G2H2(79),ex4(:),G2tensor(99),m3h2x1(:,115),heltab2x2(:,:,115))
  call Hcheck_last_AQ_V(ntryL,l_switch,G2H2(81),ex4(:),G2tensor(100),m3h2x1(:,116),heltab2x2(:,:,116))
  call Hcheck_last_AQ_Z(ntryL,l_switch,G2H2(82),ex4(:),G2tensor(101),ngZd,m3h2x1(:,117),heltab2x2(:,:,117))
  call Hcheck_last_AQ_Z(ntryL,l_switch,G2H2(84),ex4(:),G2tensor(102),ngZd,m3h2x1(:,118),heltab2x2(:,:,118))
  call Hcheck_last_AQ_V(ntryL,l_switch,G2H2(85),ex4(:),G2tensor(103),m3h2x1(:,119),heltab2x2(:,:,119))
  call Hcheck_last_AQ_V(ntryL,l_switch,G2H2(87),ex4(:),G2tensor(104),m3h2x1(:,120),heltab2x2(:,:,120))
  call Hcheck_last_AQ_V(ntryL,l_switch,G2H2(88),ex4(:),G2tensor(105),m3h2x1(:,121),heltab2x2(:,:,121))
  call Hcheck_last_AQ_V(ntryL,l_switch,G2H2(90),ex4(:),G2tensor(106),m3h2x1(:,122),heltab2x2(:,:,122))
  call Hcheck_last_AQ_Z(ntryL,l_switch,G2H2(91),ex4(:),G2tensor(107),ngZd,m3h2x1(:,123),heltab2x2(:,:,123))
  call Hcheck_last_AQ_Z(ntryL,l_switch,G2H2(93),ex4(:),G2tensor(108),ngZd,m3h2x1(:,124),heltab2x2(:,:,124))
  call Hloop_ZA_Q(ntryL,G1H2(8),ex5(:),G1H1(1),ngZd,m3h2x1(:,125),heltab2x2(:,:,125))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,0,G2tensor(109),n2h1(56))
  call Hloop_ZA_Q(ntryL,G1H2(13),ex5(:),G1H1(1),ngZd,m3h2x1(:,126),heltab2x2(:,:,126))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),16,0,G2tensor(110),n2h1(57))
  call Hloop_ZA_Q(ntryL,G1H2(43),ex5(:),G1H1(1),ngZd,m3h2x1(:,127),heltab2x2(:,:,127))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,0,G2tensor(111),n2h1(58))
  call Hloop_ZA_Q(ntryL,G1H2(49),ex5(:),G1H1(1),ngZd,m3h2x1(:,128),heltab2x2(:,:,128))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,0,G2tensor(112),n2h1(59))
  call Hloop_ZA_Q(ntryL,G1H2(56),ex5(:),G1H1(1),ngZd,m3h2x1(:,129),heltab2x2(:,:,129))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),16,0,G2tensor(113),n2h1(60))
  call Hloop_ZA_Q(ntryL,G1H2(12),ex5(:),G1H1(1),ngZd,m3h2x1(:,130),heltab2x2(:,:,130))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,0,G2tensor(114),n2h1(61))
  call Hloop_VQ_A(ntryL,G1H2(18),ex4(:),G1H1(1),m3h2x1(:,131),heltab2x2(:,:,131))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(115),n2h1(62))
  call Hloop_VQ_A(ntryL,G1H2(22),ex4(:),G1H1(1),m3h2x1(:,132),heltab2x2(:,:,132))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),8,0,G2tensor(116),n2h1(63))
  call Hloop_VQ_A(ntryL,G1H2(48),ex4(:),G1H1(1),m3h2x1(:,133),heltab2x2(:,:,133))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(117),n2h1(64))
  call Hloop_VQ_A(ntryL,G1H2(54),ex4(:),G1H1(1),m3h2x1(:,134),heltab2x2(:,:,134))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(118),n2h1(65))
  call Hloop_VQ_A(ntryL,G1H2(1),ex4(:),G1H1(1),m3h2x1(:,135),heltab2x2(:,:,135))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),8,0,G2tensor(119),n2h1(66))
  call Hloop_VQ_A(ntryL,G1H2(9),ex4(:),G1H1(1),m3h2x1(:,136),heltab2x2(:,:,136))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(120),n2h1(67))
  call Hloop_ZQ_A(ntryL,G1H2(46),ex4(:),G1H1(1),ngZd,m3h2x1(:,137),heltab2x2(:,:,137))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(121),n2h1(68))
  call Hloop_ZQ_A(ntryL,G1H2(11),ex4(:),G1H1(1),ngZd,m3h2x1(:,138),heltab2x2(:,:,138))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),8,0,G2tensor(122),n2h1(69))
  call Hloop_ZQ_A(ntryL,G1H2(17),ex4(:),G1H1(1),ngZd,m3h2x1(:,139),heltab2x2(:,:,139))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(123),n2h1(70))
  call Hloop_QV_A(ntryL,G1H4(7),wf4(:,2),G1H1(1),m3h4x1(:,1),heltab2x4(:,:,101))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(124),n2h1(71))
  call Hloop_QV_A(ntryL,G1H4(8),wf4(:,2),G1H1(1),m3h4x1(:,2),heltab2x4(:,:,102))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),20,0,G2tensor(125),n2h1(72))
  call Hloop_QV_A(ntryL,G1H4(11),wf4(:,2),G1H1(1),m3h4x1(:,3),heltab2x4(:,:,103))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(126),n2h1(73))
  call Hloop_QV_A(ntryL,G1H4(4),wf4(:,2),G1H1(1),m3h4x1(:,4),heltab2x4(:,:,104))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(127),n2h1(74))
  call Hloop_QV_A(ntryL,G1H4(23),wf4(:,2),G1H1(1),m3h4x1(:,5),heltab2x4(:,:,105))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),20,0,G2tensor(128),n2h1(75))
  call Hloop_QV_A(ntryL,G1H4(35),wf4(:,2),G1H1(1),m3h4x1(:,6),heltab2x4(:,:,106))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(129),n2h1(76))
  call Hloop_QV_A(ntryL,G1H4(21),wf4(:,2),G1H1(1),m3h4x1(:,7),heltab2x4(:,:,107))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(130),n2h1(77))
  call Hloop_QV_A(ntryL,G1H4(22),wf4(:,2),G1H1(1),m3h4x1(:,8),heltab2x4(:,:,108))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),20,0,G2tensor(131),n2h1(78))
  call Hloop_QV_A(ntryL,G1H4(38),wf4(:,2),G1H1(1),m3h4x1(:,9),heltab2x4(:,:,109))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(132),n2h1(79))
  call Hloop_QV_A(ntryL,G1H4(41),wf4(:,4),G1H1(1),m3h4x1(:,10),heltab2x4(:,:,110))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(133),n2h1(80))
  call Hloop_QV_A(ntryL,G1H4(42),wf4(:,4),G1H1(1),m3h4x1(:,11),heltab2x4(:,:,111))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),24,0,G2tensor(134),n2h1(81))
  call Hloop_QV_A(ntryL,G1H4(48),wf4(:,4),G1H1(1),m3h4x1(:,12),heltab2x4(:,:,112))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(135),n2h1(82))
  call Hloop_QV_A(ntryL,G1H4(49),wf4(:,4),G1H1(1),m3h4x1(:,13),heltab2x4(:,:,113))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(136),n2h1(83))
  call Hloop_QV_A(ntryL,G1H4(50),wf4(:,4),G1H1(1),m3h4x1(:,14),heltab2x4(:,:,114))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),24,0,G2tensor(137),n2h1(84))
  call Hloop_QV_A(ntryL,G1H4(56),wf4(:,4),G1H1(1),m3h4x1(:,15),heltab2x4(:,:,115))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(138),n2h1(85))
  call Hloop_QV_A(ntryL,G1H4(59),wf4(:,4),G1H1(1),m3h4x1(:,16),heltab2x4(:,:,116))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(139),n2h1(86))
  call Hloop_QV_A(ntryL,G1H4(60),wf4(:,4),G1H1(1),m3h4x1(:,17),heltab2x4(:,:,117))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),24,0,G2tensor(140),n2h1(87))
  call Hloop_QV_A(ntryL,G1H4(66),wf4(:,4),G1H1(1),m3h4x1(:,18),heltab2x4(:,:,118))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(141),n2h1(88))
  call Hloop_ZA_Q(ntryL,G1H2(30),ex5(:),G1H1(1),ngZd,m3h2x1(:,140),heltab2x2(:,:,140))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,0,G2tensor(142),n2h1(89))
  call Hloop_ZA_Q(ntryL,G1H2(21),ex5(:),G1H1(1),ngZd,m3h2x1(:,141),heltab2x2(:,:,141))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),16,0,G2tensor(143),n2h1(90))
  call Hloop_ZA_Q(ntryL,G1H2(27),ex5(:),G1H1(1),ngZd,m3h2x1(:,142),heltab2x2(:,:,142))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,0,G2tensor(144),n2h1(91))
  call Hloop_WA_Q(ntryL,G1H2(28),ex5(:),G1H1(1),m3h2x1(:,143),heltab2x2(:,:,143))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,0,G2tensor(145),n2h1(92))
  call Hloop_WA_Q(ntryL,G1H2(29),ex5(:),G1H1(1),m3h2x1(:,144),heltab2x2(:,:,144))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),16,0,G2tensor(146),n2h1(93))
  call Hloop_WA_Q(ntryL,G1H2(39),ex5(:),G1H1(1),m3h2x1(:,145),heltab2x2(:,:,145))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,0,G2tensor(147),n2h1(94))
  call Hloop_ZA_Q(ntryL,G1H2(64),ex5(:),G1H1(1),ngZd,m3h2x1(:,146),heltab2x2(:,:,146))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,0,G2tensor(148),n2h1(95))
  call Hloop_ZA_Q(ntryL,G1H2(41),ex5(:),G1H1(1),ngZd,m3h2x1(:,147),heltab2x2(:,:,147))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),16,0,G2tensor(149),n2h1(96))
  call Hloop_ZA_Q(ntryL,G1H2(51),ex5(:),G1H1(1),ngZd,m3h2x1(:,148),heltab2x2(:,:,148))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,0,G2tensor(150),n2h1(97))
  call Hloop_WA_Q(ntryL,G1H2(53),ex5(:),G1H1(1),m3h2x1(:,149),heltab2x2(:,:,149))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,0,G2tensor(151),n2h1(98))
  call Hloop_WA_Q(ntryL,G1H2(66),ex5(:),G1H1(1),m3h2x1(:,150),heltab2x2(:,:,150))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),16,0,G2tensor(152),n2h1(99))
  call Hloop_WA_Q(ntryL,G1H2(65),ex5(:),G1H1(1),m3h2x1(:,151),heltab2x2(:,:,151))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,0,G2tensor(153),n2h1(100))
  call ol_merge_tensors(G2tensor(52),[G2tensor(8),G1tensor(38),G1tensor(3)])
  call ol_merge_tensors(G2tensor(10),[G1tensor(44)])
  call ol_merge_tensors(G2tensor(63),[G2tensor(12),G1tensor(50),G1tensor(27)])
  call ol_merge_tensors(G2tensor(14),[G1tensor(56)])
  call ol_merge_tensors(G2tensor(16),[G1tensor(62)])
  call ol_merge_tensors(G2tensor(65),[G2tensor(18),G1tensor(68),G1tensor(33)])
  call ol_merge_tensors(G2tensor(61),[G2tensor(20),G1tensor(74),G1tensor(21)])
  call ol_merge_tensors(G2tensor(55),[G2tensor(22),G1tensor(80),G1tensor(9)])
  call ol_merge_tensors(G2tensor(24),[G1tensor(86)])
  call ol_merge_tensors(G2tensor(58),[G2tensor(26),G1tensor(92),G1tensor(15)])
  call ol_merge_tensors(G2tensor(1),[G1tensor(2)])
  call ol_merge_tensors(G2tensor(53),[G1tensor(4)])
  call ol_merge_tensors(G2tensor(54),[G1tensor(23),G1tensor(5)])
  call ol_merge_tensors(G2tensor(2),[G1tensor(6)])
  call ol_merge_tensors(G2tensor(3),[G1tensor(8)])
  call ol_merge_tensors(G2tensor(56),[G1tensor(10)])
  call ol_merge_tensors(G2tensor(57),[G1tensor(29),G1tensor(11)])
  call ol_merge_tensors(G2tensor(4),[G1tensor(12)])
  call ol_merge_tensors(G2tensor(109),[G1tensor(14)])
  call ol_merge_tensors(G2tensor(59),[G1tensor(16)])
  call ol_merge_tensors(G2tensor(60),[G1tensor(35),G1tensor(17)])
  call ol_merge_tensors(G2tensor(5),[G1tensor(18)])
  call ol_merge_tensors(G2tensor(6),[G1tensor(20)])
  call ol_merge_tensors(G2tensor(62),[G1tensor(22)])
  call ol_merge_tensors(G2tensor(7),[G1tensor(24)])
  call ol_merge_tensors(G2tensor(9),[G1tensor(26)])
  call ol_merge_tensors(G2tensor(64),[G1tensor(28)])
  call ol_merge_tensors(G2tensor(11),[G1tensor(30)])
  call ol_merge_tensors(G2tensor(112),[G1tensor(32)])
  call ol_merge_tensors(G2tensor(66),[G1tensor(34)])
  call ol_merge_tensors(G2tensor(13),[G1tensor(36)])
  call ol_merge_tensors(G2tensor(15),[G1tensor(39)])
  call ol_merge_tensors(G2tensor(17),[G1tensor(76),G1tensor(40)])
  call ol_merge_tensors(G2tensor(19),[G1tensor(41)])
  call ol_merge_tensors(G2tensor(21),[G1tensor(66),G1tensor(42)])
  call ol_merge_tensors(G2tensor(23),[G1tensor(45)])
  call ol_merge_tensors(G2tensor(25),[G1tensor(46)])
  call ol_merge_tensors(G2tensor(27),[G1tensor(47)])
  call ol_merge_tensors(G2tensor(28),[G1tensor(60),G1tensor(48)])
  call ol_merge_tensors(G2tensor(29),[G1tensor(51)])
  call ol_merge_tensors(G2tensor(30),[G1tensor(82),G1tensor(52)])
  call ol_merge_tensors(G2tensor(31),[G1tensor(53)])
  call ol_merge_tensors(G2tensor(32),[G1tensor(72),G1tensor(54)])
  call ol_merge_tensors(G2tensor(33),[G1tensor(57)])
  call ol_merge_tensors(G2tensor(34),[G1tensor(58)])
  call ol_merge_tensors(G2tensor(35),[G1tensor(59)])
  call ol_merge_tensors(G2tensor(36),[G1tensor(63)])
  call ol_merge_tensors(G2tensor(37),[G1tensor(88),G1tensor(64)])
  call ol_merge_tensors(G2tensor(38),[G1tensor(65)])
  call ol_merge_tensors(G2tensor(39),[G1tensor(69)])
  call ol_merge_tensors(G2tensor(40),[G1tensor(94),G1tensor(70)])
  call ol_merge_tensors(G2tensor(41),[G1tensor(71)])
  call ol_merge_tensors(G2tensor(42),[G1tensor(75)])
  call ol_merge_tensors(G2tensor(43),[G1tensor(77)])
  call ol_merge_tensors(G2tensor(44),[G1tensor(90),G1tensor(78)])
  call ol_merge_tensors(G2tensor(45),[G1tensor(81)])
  call ol_merge_tensors(G2tensor(46),[G1tensor(83)])
  call ol_merge_tensors(G2tensor(47),[G1tensor(96),G1tensor(84)])
  call ol_merge_tensors(G2tensor(48),[G1tensor(87)])
  call ol_merge_tensors(G2tensor(49),[G1tensor(89)])
  call ol_merge_tensors(G2tensor(50),[G1tensor(93)])
  call ol_merge_tensors(G2tensor(51),[G1tensor(95)])
  call Hotf_5pt_reduction_last(G2tensor(52),RedSet_5(25),mass5set(:,2),  & 
G1tensor(1),G1tensor(7),G1tensor(13),G1tensor(19),G1tensor(25),G1tensor(31))
  call G_TensorShift(G1tensor(7),16)
  call Hotf_5pt_reduction_last(G2tensor(10),RedSet_5(26),mass5set(:,11),  & 
G1tensor(37),G1tensor(43),G1tensor(49),G1tensor(55),G1tensor(61),G1tensor(67))
  call G_TensorShift(G1tensor(43),1)
  call Hotf_5pt_reduction_last(G2tensor(63),RedSet_5(27),mass5set(:,2),  & 
G1tensor(73),G1tensor(79),G1tensor(85),G1tensor(91),G1tensor(38),G1tensor(3))
  call G_TensorShift(G1tensor(79),16)
  call Hotf_5pt_reduction_last(G2tensor(14),RedSet_5(28),mass5set(:,11),  & 
G1tensor(44),G1tensor(50),G1tensor(27),G1tensor(56),G1tensor(62),G1tensor(68))
  call G_TensorShift(G1tensor(50),2)
  call Hotf_5pt_reduction_last(G2tensor(16),RedSet_5(29),mass5set(:,2),  & 
G1tensor(33),G1tensor(74),G1tensor(21),G1tensor(80),G1tensor(9),G1tensor(86))
  call G_TensorShift(G1tensor(74),4)
  call Hotf_5pt_reduction_last(G2tensor(65),RedSet_5(30),mass5set(:,2),  & 
G1tensor(92),G1tensor(15),G1tensor(2),G1tensor(4),G1tensor(23),G1tensor(5))
  call G_TensorShift(G1tensor(15),8)
  call Hotf_5pt_reduction_last(G2tensor(61),RedSet_5(31),mass5set(:,2),  & 
G1tensor(6),G1tensor(8),G1tensor(10),G1tensor(29),G1tensor(11),G1tensor(12))
  call G_TensorShift(G1tensor(8),16)
  call Hotf_5pt_reduction_last(G2tensor(55),RedSet_5(32),mass5set(:,2),  & 
G1tensor(14),G1tensor(16),G1tensor(35),G1tensor(17),G1tensor(18),G1tensor(20))
  call G_TensorShift(G1tensor(16),16)
  call Hotf_5pt_reduction_last(G2tensor(24),RedSet_5(33),mass5set(:,2),  & 
G1tensor(22),G1tensor(24),G1tensor(26),G1tensor(28),G1tensor(30),G1tensor(32))
  call G_TensorShift(G1tensor(24),4)
  call Hotf_5pt_reduction_last(G2tensor(58),RedSet_5(34),mass5set(:,2),  & 
G1tensor(34),G1tensor(36),G1tensor(39),G1tensor(76),G1tensor(40),G1tensor(41))
  call G_TensorShift(G1tensor(36),8)
  call Hotf_5pt_reduction_last(G2tensor(1),RedSet_5(35),mass5set(:,1),  & 
G1tensor(66),G1tensor(42),G1tensor(45),G1tensor(46),G1tensor(47),G1tensor(60))
  call G_TensorShift(G1tensor(42),4)
  call Hotf_5pt_reduction_last(G2tensor(53),RedSet_5(36),mass5set(:,3),  & 
G1tensor(48),G1tensor(51),G1tensor(82),G1tensor(52),G1tensor(53),G1tensor(72))
  call G_TensorShift(G1tensor(51),16)
  call Hotf_5pt_reduction_last(G2tensor(54),RedSet_5(37),mass5set(:,12),  & 
G1tensor(54),G1tensor(57),G1tensor(58),G1tensor(59),G1tensor(63),G1tensor(88))
  call G_TensorShift(G1tensor(57),16)
  call Hotf_5pt_reduction_last(G2tensor(2),RedSet_5(38),mass5set(:,6),  & 
G1tensor(64),G1tensor(65),G1tensor(69),G1tensor(94),G1tensor(70),G1tensor(71))
  call G_TensorShift(G1tensor(65),16)
  call Hotf_5pt_reduction_last(G2tensor(3),RedSet_5(39),mass5set(:,1),  & 
G1tensor(75),G1tensor(77),G1tensor(90),G1tensor(78),G1tensor(81),G1tensor(83))
  call G_TensorShift(G1tensor(77),8)
  call Hotf_5pt_reduction_last(G2tensor(56),RedSet_5(40),mass5set(:,3),  & 
G1tensor(96),G1tensor(84),G1tensor(87),G1tensor(89),G1tensor(93),G1tensor(95))
  call G_TensorShift(G1tensor(84),16)
  call Hotf_5pt_reduction_last(G2tensor(57),RedSet_5(41),mass5set(:,12),  & 
G1tensor(97),G1tensor(98),G1tensor(99),G1tensor(100),G1tensor(101),G1tensor(102))
  call G_TensorShift(G1tensor(98),16)
  call Hotf_5pt_reduction_last(G2tensor(4),RedSet_5(42),mass5set(:,6),  & 
G1tensor(103),G1tensor(104),G1tensor(105),G1tensor(106),G1tensor(107),G1tensor(108))
  call G_TensorShift(G1tensor(104),16)
  call Hotf_5pt_reduction_last(G2tensor(109),RedSet_5(20),mass5set(:,1),  & 
G1tensor(109),G1tensor(110),G1tensor(111),G1tensor(112),G1tensor(113),G1tensor(114))
  call G_TensorShift(G1tensor(110),16)
  call Hotf_5pt_reduction_last(G2tensor(59),RedSet_5(43),mass5set(:,3),  & 
G1tensor(115),G1tensor(116),G1tensor(117),G1tensor(118),G1tensor(119),G1tensor(120))
  call G_TensorShift(G1tensor(116),8)
  call Hotf_5pt_reduction_last(G2tensor(60),RedSet_5(22),mass5set(:,12),  & 
G1tensor(121),G1tensor(122),G1tensor(123),G1tensor(124),G1tensor(125),G1tensor(126))
  call G_TensorShift(G1tensor(122),8)
  call Hotf_5pt_reduction_last(G2tensor(5),RedSet_5(44),mass5set(:,6),  & 
G1tensor(127),G1tensor(128),G1tensor(129),G1tensor(130),G1tensor(131),G1tensor(132))
  call G_TensorShift(G1tensor(128),8)
  call Hotf_5pt_reduction_last(G2tensor(6),RedSet_5(45),mass5set(:,1),  & 
G1tensor(133),G1tensor(134),G1tensor(135),G1tensor(136),G1tensor(137),G1tensor(138))
  call G_TensorShift(G1tensor(134),4)
  call Hotf_5pt_reduction_last(G2tensor(62),RedSet_5(46),mass5set(:,3),  & 
G1tensor(139),G1tensor(140),G1tensor(141),G1tensor(142),G1tensor(143),G1tensor(144))
  call G_TensorShift(G1tensor(140),16)
  call Hotf_5pt_reduction_last(G2tensor(7),RedSet_5(47),mass5set(:,6),  & 
G1tensor(145),G1tensor(146),G1tensor(147),G1tensor(148),G1tensor(149),G1tensor(150))
  call G_TensorShift(G1tensor(146),16)
  call Hotf_5pt_reduction_last(G2tensor(9),RedSet_5(48),mass5set(:,1),  & 
G1tensor(151),G1tensor(152),G1tensor(153),G1tensor(154),G1tensor(155),G1tensor(156))
  call G_TensorShift(G1tensor(152),8)
  call Hotf_5pt_reduction_last(G2tensor(64),RedSet_5(49),mass5set(:,3),  & 
G1tensor(157),G1tensor(158),G1tensor(159),G1tensor(160),G1tensor(161),G1tensor(162))
  call G_TensorShift(G1tensor(158),16)
  call Hotf_5pt_reduction_last(G2tensor(11),RedSet_5(50),mass5set(:,6),  & 
G1tensor(163),G1tensor(164),G1tensor(165),G1tensor(166),G1tensor(167),G1tensor(168))
  call G_TensorShift(G1tensor(164),16)
  call Hotf_5pt_reduction_last(G2tensor(112),RedSet_5(21),mass5set(:,1),  & 
G1tensor(169),G1tensor(170),G1tensor(171),G1tensor(172),G1tensor(173),G1tensor(174))
  call G_TensorShift(G1tensor(170),16)
  call Hotf_5pt_reduction_last(G2tensor(66),RedSet_5(51),mass5set(:,3),  & 
G1tensor(175),G1tensor(176),G1tensor(177),G1tensor(178),G1tensor(179),G1tensor(180))
  call G_TensorShift(G1tensor(176),8)
  call Hotf_5pt_reduction_last(G2tensor(13),RedSet_5(52),mass5set(:,6),  & 
G1tensor(181),G1tensor(182),G1tensor(183),G1tensor(184),G1tensor(185),G1tensor(186))
  call G_TensorShift(G1tensor(182),8)
  call Hotf_5pt_reduction_last(G2tensor(15),RedSet_5(53),mass5set(:,6),  & 
G1tensor(187),G1tensor(188),G1tensor(189),G1tensor(190),G1tensor(191),G1tensor(192))
  call G_TensorShift(G1tensor(188),8)
  call Hotf_5pt_reduction_last(G2tensor(17),RedSet_5(19),mass5set(:,13),  & 
G1tensor(193),G1tensor(194),G1tensor(195),G1tensor(196),G1tensor(197),G1tensor(198))
  call G_TensorShift(G1tensor(194),8)
  call Hotf_5pt_reduction_last(G2tensor(19),RedSet_5(54),mass5set(:,7),  & 
G1tensor(199),G1tensor(200),G1tensor(201),G1tensor(202),G1tensor(203),G1tensor(204))
  call G_TensorShift(G1tensor(200),8)
  call Hotf_5pt_reduction_last(G2tensor(21),RedSet_5(55),mass5set(:,2),  & 
G1tensor(205),G1tensor(206),G1tensor(207),G1tensor(208),G1tensor(209),G1tensor(210))
  call G_TensorShift(G1tensor(206),8)
  call Hotf_5pt_reduction_last(G2tensor(23),RedSet_5(56),mass5set(:,1),  & 
G1tensor(211),G1tensor(212),G1tensor(213),G1tensor(214),G1tensor(215),G1tensor(216))
  call G_TensorShift(G1tensor(212),8)
  call Hotf_5pt_reduction_last(G2tensor(25),RedSet_5(57),mass5set(:,1),  & 
G1tensor(217),G1tensor(218),G1tensor(219),G1tensor(220),G1tensor(221),G1tensor(222))
  call G_TensorShift(G1tensor(218),8)
  call Hotf_5pt_reduction_last(G2tensor(27),RedSet_5(58),mass5set(:,8),  & 
G1tensor(223),G1tensor(224),G1tensor(225),G1tensor(226),G1tensor(227),G1tensor(228))
  call G_TensorShift(G1tensor(224),8)
  call Hotf_5pt_reduction_last(G2tensor(28),RedSet_5(18),mass5set(:,14),  & 
G1tensor(229),G1tensor(230),G1tensor(231),G1tensor(232),G1tensor(233),G1tensor(234))
  call G_TensorShift(G1tensor(230),8)
  call Hotf_5pt_reduction_last(G2tensor(29),RedSet_5(59),mass5set(:,6),  & 
G1tensor(235),G1tensor(236),G1tensor(237),G1tensor(238),G1tensor(239),G1tensor(240))
  call G_TensorShift(G1tensor(236),4)
  call Hotf_5pt_reduction_last(G2tensor(30),RedSet_5(17),mass5set(:,13),  & 
G1tensor(241),G1tensor(242),G1tensor(243),G1tensor(244),G1tensor(245),G1tensor(246))
  call G_TensorShift(G1tensor(242),4)
  call Hotf_5pt_reduction_last(G2tensor(31),RedSet_5(60),mass5set(:,7),  & 
G1tensor(247),G1tensor(248),G1tensor(249),G1tensor(250),G1tensor(251),G1tensor(252))
  call G_TensorShift(G1tensor(248),4)
  call Hotf_5pt_reduction_last(G2tensor(32),RedSet_5(61),mass5set(:,2),  & 
G1tensor(253),G1tensor(254),G1tensor(255),G1tensor(256),G1tensor(257),G1tensor(258))
  call G_TensorShift(G1tensor(254),4)
  call Hotf_5pt_reduction_last(G2tensor(33),RedSet_5(62),mass5set(:,1),  & 
G1tensor(259),G1tensor(260),G1tensor(261),G1tensor(262),G1tensor(263),G1tensor(264))
  call G_TensorShift(G1tensor(260),8)
  call Hotf_5pt_reduction_last(G2tensor(34),RedSet_5(63),mass5set(:,1),  & 
G1tensor(265),G1tensor(266),G1tensor(267),G1tensor(268),G1tensor(269),G1tensor(270))
  call G_TensorShift(G1tensor(266),8)
  call Hotf_5pt_reduction_last(G2tensor(35),RedSet_5(64),mass5set(:,8),  & 
G1tensor(271),G1tensor(272),G1tensor(273),G1tensor(274),G1tensor(275),G1tensor(276))
  call G_TensorShift(G1tensor(272),8)
  call Hotf_5pt_reduction_last(G2tensor(36),RedSet_5(65),mass5set(:,6),  & 
G1tensor(277),G1tensor(278),G1tensor(279),G1tensor(280),G1tensor(281),G1tensor(282))
  call G_TensorShift(G1tensor(278),8)
  call Hotf_5pt_reduction_last(G2tensor(37),RedSet_5(66),mass5set(:,13),  & 
G1tensor(283),G1tensor(284),G1tensor(285),G1tensor(286),G1tensor(287),G1tensor(288))
  call G_TensorShift(G1tensor(284),8)
  call Hotf_5pt_reduction_last(G2tensor(38),RedSet_5(67),mass5set(:,7),  & 
G1tensor(289),G1tensor(290),G1tensor(291),G1tensor(292),G1tensor(293),G1tensor(294))
  call G_TensorShift(G1tensor(290),8)
  call Hotf_5pt_reduction_last(G2tensor(39),RedSet_5(68),mass5set(:,6),  & 
G1tensor(295),G1tensor(296),G1tensor(297),G1tensor(298),G1tensor(299),G1tensor(300))
  call G_TensorShift(G1tensor(296),4)
  call Hotf_5pt_reduction_last(G2tensor(40),RedSet_5(69),mass5set(:,13),  & 
G1tensor(301),G1tensor(302),G1tensor(303),G1tensor(304),G1tensor(305),G1tensor(306))
  call G_TensorShift(G1tensor(302),4)
  call Hotf_5pt_reduction_last(G2tensor(41),RedSet_5(70),mass5set(:,7),  & 
G1tensor(307),G1tensor(308),G1tensor(309),G1tensor(310),G1tensor(311),G1tensor(312))
  call G_TensorShift(G1tensor(308),4)
  call Hotf_5pt_reduction_last(G2tensor(42),RedSet_5(71),mass5set(:,6),  & 
G1tensor(313),G1tensor(314),G1tensor(315),G1tensor(316),G1tensor(317),G1tensor(318))
  call G_TensorShift(G1tensor(314),8)
  call Hotf_5pt_reduction_last(G2tensor(43),RedSet_5(72),mass5set(:,7),  & 
G1tensor(319),G1tensor(320),G1tensor(321),G1tensor(322),G1tensor(323),G1tensor(324))
  call G_TensorShift(G1tensor(320),8)
  call Hotf_5pt_reduction_last(G2tensor(44),RedSet_5(73),mass5set(:,2),  & 
G1tensor(325),G1tensor(326),G1tensor(327),G1tensor(328),G1tensor(329),G1tensor(330))
  call G_TensorShift(G1tensor(326),8)
  call Hotf_5pt_reduction_last(G2tensor(45),RedSet_5(74),mass5set(:,6),  & 
G1tensor(331),G1tensor(332),G1tensor(333),G1tensor(334),G1tensor(335),G1tensor(336))
  call G_TensorShift(G1tensor(332),4)
  call Hotf_5pt_reduction_last(G2tensor(46),RedSet_5(75),mass5set(:,7),  & 
G1tensor(337),G1tensor(338),G1tensor(339),G1tensor(340),G1tensor(341),G1tensor(342))
  call G_TensorShift(G1tensor(338),4)
  call Hotf_5pt_reduction_last(G2tensor(47),RedSet_5(76),mass5set(:,2),  & 
G1tensor(343),G1tensor(344),G1tensor(345),G1tensor(346),G1tensor(347),G1tensor(348))
  call G_TensorShift(G1tensor(344),4)
  call Hotf_5pt_reduction_last(G2tensor(48),RedSet_5(77),mass5set(:,6),  & 
G1tensor(349),G1tensor(350),G1tensor(351),G1tensor(352),G1tensor(353),G1tensor(354))
  call G_TensorShift(G1tensor(350),8)
  call Hotf_5pt_reduction_last(G2tensor(49),RedSet_5(78),mass5set(:,7),  & 
G1tensor(355),G1tensor(356),G1tensor(357),G1tensor(358),G1tensor(359),G1tensor(360))
  call G_TensorShift(G1tensor(356),8)
  call Hotf_5pt_reduction_last(G2tensor(50),RedSet_5(79),mass5set(:,6),  & 
G1tensor(361),G1tensor(362),G1tensor(363),G1tensor(364),G1tensor(365),G1tensor(366))
  call G_TensorShift(G1tensor(362),4)
  call Hotf_5pt_reduction_last(G2tensor(51),RedSet_5(80),mass5set(:,7),  & 
G1tensor(367),G1tensor(368),G1tensor(369),G1tensor(370),G1tensor(371),G1tensor(372))
  call G_TensorShift(G1tensor(368),4)
  call Hotf_5pt_reduction_last(G2tensor(67),RedSet_5(13),mass5set(:,4),  & 
G1tensor(373),G1tensor(374),G1tensor(375),G1tensor(376),G1tensor(377),G1tensor(378))
  call G_TensorShift(G1tensor(374),16)
  call Hotf_5pt_reduction_last(G2tensor(69),RedSet_5(13),mass5set(:,3),  & 
G1tensor(379),G1tensor(380),G1tensor(381),G1tensor(382),G1tensor(383),G1tensor(384))
  call G_TensorShift(G1tensor(380),16)
  call Hotf_5pt_reduction_last(G2tensor(71),RedSet_5(13),mass5set(:,5),  & 
G1tensor(385),G1tensor(386),G1tensor(387),G1tensor(388),G1tensor(389),G1tensor(390))
  call G_TensorShift(G1tensor(386),16)
  call Hotf_5pt_reduction_last(G2tensor(73),RedSet_5(14),mass5set(:,4),  & 
G1tensor(391),G1tensor(392),G1tensor(393),G1tensor(394),G1tensor(395),G1tensor(396))
  call G_TensorShift(G1tensor(392),16)
  call Hotf_5pt_reduction_last(G2tensor(75),RedSet_5(14),mass5set(:,6),  & 
G1tensor(397),G1tensor(398),G1tensor(399),G1tensor(400),G1tensor(401),G1tensor(402))
  call G_TensorShift(G1tensor(398),16)
  call Hotf_5pt_reduction_last(G2tensor(77),RedSet_5(14),mass5set(:,5),  & 
G1tensor(403),G1tensor(404),G1tensor(405),G1tensor(406),G1tensor(407),G1tensor(408))
  call G_TensorShift(G1tensor(404),16)
  call Hotf_5pt_reduction_last(G2tensor(79),RedSet_5(15),mass5set(:,4),  & 
G1tensor(409),G1tensor(410),G1tensor(411),G1tensor(412),G1tensor(413),G1tensor(414))
  call G_TensorShift(G1tensor(410),16)
  call Hotf_5pt_reduction_last(G2tensor(81),RedSet_5(15),mass5set(:,3),  & 
G1tensor(415),G1tensor(416),G1tensor(417),G1tensor(418),G1tensor(419),G1tensor(420))
  call G_TensorShift(G1tensor(416),16)
  call Hotf_5pt_reduction_last(G2tensor(83),RedSet_5(15),mass5set(:,5),  & 
G1tensor(421),G1tensor(422),G1tensor(423),G1tensor(424),G1tensor(425),G1tensor(426))
  call G_TensorShift(G1tensor(422),16)
  call Hotf_5pt_reduction_last(G2tensor(85),RedSet_5(16),mass5set(:,4),  & 
G1tensor(427),G1tensor(428),G1tensor(429),G1tensor(430),G1tensor(431),G1tensor(432))
  call G_TensorShift(G1tensor(428),16)
  call Hotf_5pt_reduction_last(G2tensor(87),RedSet_5(16),mass5set(:,6),  & 
G1tensor(433),G1tensor(434),G1tensor(435),G1tensor(436),G1tensor(437),G1tensor(438))
  call G_TensorShift(G1tensor(434),16)
  call Hotf_5pt_reduction_last(G2tensor(89),RedSet_5(16),mass5set(:,5),  & 
G1tensor(439),G1tensor(440),G1tensor(441),G1tensor(442),G1tensor(443),G1tensor(444))
  call G_TensorShift(G1tensor(440),16)
  call Hotf_5pt_reduction_last(G2tensor(91),RedSet_5(17),mass5set(:,4),  & 
G1tensor(445),G1tensor(446),G1tensor(447),G1tensor(448),G1tensor(449),G1tensor(450))
  call G_TensorShift(G1tensor(446),4)
  call Hotf_5pt_reduction_last(G2tensor(93),RedSet_5(17),mass5set(:,5),  & 
G1tensor(451),G1tensor(452),G1tensor(453),G1tensor(454),G1tensor(455),G1tensor(456))
  call G_TensorShift(G1tensor(452),4)
  call Hotf_5pt_reduction_last(G2tensor(95),RedSet_5(17),mass5set(:,3),  & 
G1tensor(457),G1tensor(458),G1tensor(459),G1tensor(460),G1tensor(461),G1tensor(462))
  call G_TensorShift(G1tensor(458),4)
  call Hotf_5pt_reduction_last(G2tensor(97),RedSet_5(18),mass5set(:,4),  & 
G1tensor(463),G1tensor(464),G1tensor(465),G1tensor(466),G1tensor(467),G1tensor(468))
  call G_TensorShift(G1tensor(464),8)
  call Hotf_5pt_reduction_last(G2tensor(99),RedSet_5(18),mass5set(:,6),  & 
G1tensor(469),G1tensor(470),G1tensor(471),G1tensor(472),G1tensor(473),G1tensor(474))
  call G_TensorShift(G1tensor(470),8)
  call Hotf_5pt_reduction_last(G2tensor(101),RedSet_5(18),mass5set(:,5),  & 
G1tensor(475),G1tensor(476),G1tensor(477),G1tensor(478),G1tensor(479),G1tensor(480))
  call G_TensorShift(G1tensor(476),8)
  call Hotf_5pt_reduction_last(G2tensor(103),RedSet_5(19),mass5set(:,4),  & 
G1tensor(481),G1tensor(482),G1tensor(483),G1tensor(484),G1tensor(485),G1tensor(486))
  call G_TensorShift(G1tensor(482),8)
  call Hotf_5pt_reduction_last(G2tensor(105),RedSet_5(19),mass5set(:,3),  & 
G1tensor(487),G1tensor(488),G1tensor(489),G1tensor(490),G1tensor(491),G1tensor(492))
  call G_TensorShift(G1tensor(488),8)
  call Hotf_5pt_reduction_last(G2tensor(107),RedSet_5(19),mass5set(:,5),  & 
G1tensor(493),G1tensor(494),G1tensor(495),G1tensor(496),G1tensor(497),G1tensor(498))
  call G_TensorShift(G1tensor(494),8)
  call Hotf_5pt_reduction_last(G2tensor(115),RedSet_5(22),mass5set(:,4),  & 
G1tensor(499),G1tensor(500),G1tensor(501),G1tensor(502),G1tensor(503),G1tensor(504))
  call G_TensorShift(G1tensor(500),8)
  call Hotf_5pt_reduction_last(G2tensor(118),RedSet_5(22),mass5set(:,7),  & 
G1tensor(505),G1tensor(506),G1tensor(507),G1tensor(508),G1tensor(509),G1tensor(510))
  call G_TensorShift(G1tensor(506),8)
  call Hotf_5pt_reduction_last(G2tensor(121),RedSet_5(22),mass5set(:,8),  & 
G1tensor(511),G1tensor(512),G1tensor(513),G1tensor(514),G1tensor(515),G1tensor(516))
  call G_TensorShift(G1tensor(512),8)
  call Hotf_5pt_reduction_last(G2tensor(124),RedSet_5(7),mass5set(:,2),  & 
G1tensor(517),G1tensor(518),G1tensor(519),G1tensor(520),G1tensor(521),G1tensor(522))
  call G_TensorShift(G1tensor(518),20)
  call Hotf_5pt_reduction_last(G2tensor(127),RedSet_5(7),mass5set(:,9),  & 
G1tensor(523),G1tensor(524),G1tensor(525),G1tensor(526),G1tensor(527),G1tensor(528))
  call G_TensorShift(G1tensor(524),20)
  call Hotf_5pt_reduction_last(G2tensor(130),RedSet_5(11),mass5set(:,2),  & 
G1tensor(529),G1tensor(530),G1tensor(531),G1tensor(532),G1tensor(533),G1tensor(534))
  call G_TensorShift(G1tensor(530),20)
  call Hotf_5pt_reduction_last(G2tensor(133),RedSet_5(5),mass5set(:,2),  & 
G1tensor(535),G1tensor(536),G1tensor(537),G1tensor(538),G1tensor(539),G1tensor(540))
  call G_TensorShift(G1tensor(536),24)
  call Hotf_5pt_reduction_last(G2tensor(136),RedSet_5(5),mass5set(:,9),  & 
G1tensor(541),G1tensor(542),G1tensor(543),G1tensor(544),G1tensor(545),G1tensor(546))
  call G_TensorShift(G1tensor(542),24)
  call Hotf_5pt_reduction_last(G2tensor(139),RedSet_5(10),mass5set(:,2),  & 
G1tensor(547),G1tensor(548),G1tensor(549),G1tensor(550),G1tensor(551),G1tensor(552))
  call G_TensorShift(G1tensor(548),24)
  call Hotf_5pt_reduction_last(G2tensor(142),RedSet_5(23),mass5set(:,1),  & 
G1tensor(553),G1tensor(554),G1tensor(555),G1tensor(556),G1tensor(557),G1tensor(558))
  call G_TensorShift(G1tensor(554),16)
  call Hotf_5pt_reduction_last(G2tensor(145),RedSet_5(23),mass5set(:,10),  & 
G1tensor(559),G1tensor(560),G1tensor(561),G1tensor(562),G1tensor(563),G1tensor(564))
  call G_TensorShift(G1tensor(560),16)
  call Hotf_5pt_reduction_last(G2tensor(148),RedSet_5(24),mass5set(:,1),  & 
G1tensor(565),G1tensor(566),G1tensor(567),G1tensor(568),G1tensor(569),G1tensor(570))
  call G_TensorShift(G1tensor(566),16)
  call Hotf_5pt_reduction_last(G2tensor(151),RedSet_5(20),mass5set(:,10),  & 
G1tensor(571),G1tensor(572),G1tensor(573),G1tensor(574),G1tensor(575),G1tensor(576))
  call G_TensorShift(G1tensor(572),16)
  call ol_merge_tensors(T1sum(17),[G1tensor(1)])
  call ol_merge_tensors(T1sum(18),[G1tensor(37)])
  call ol_merge_tensors(T1sum(19),[G1tensor(73)])
  call ol_merge_tensors(T1sum(20),[G1tensor(44)])
  call ol_merge_tensors(T1sum(21),[G1tensor(33)])
  call ol_merge_tensors(T1sum(22),[G1tensor(92)])
  call ol_merge_tensors(T1sum(23),[G1tensor(6)])
  call ol_merge_tensors(T1sum(24),[G1tensor(14)])
  call ol_merge_tensors(T1sum(25),[G1tensor(22)])
  call ol_merge_tensors(T1sum(26),[G1tensor(34)])
  call ol_merge_tensors(T1sum(27),[G1tensor(66)])
  call ol_merge_tensors(T1sum(28),[G1tensor(48)])
  call ol_merge_tensors(T1sum(29),[G1tensor(54)])
  call ol_merge_tensors(T1sum(30),[G1tensor(64)])
  call ol_merge_tensors(T1sum(31),[G1tensor(75)])
  call ol_merge_tensors(T1sum(32),[G1tensor(96)])
  call ol_merge_tensors(T1sum(33),[G1tensor(97)])
  call ol_merge_tensors(T1sum(34),[G1tensor(103)])
  call ol_merge_tensors(T1sum(35),[G1tensor(109)])
  call ol_merge_tensors(T1sum(36),[G1tensor(115)])
  call ol_merge_tensors(T1sum(37),[G1tensor(121)])
  call ol_merge_tensors(T1sum(38),[G1tensor(127)])
  call ol_merge_tensors(T1sum(39),[G1tensor(133)])
  call ol_merge_tensors(T1sum(40),[G1tensor(139)])
  call ol_merge_tensors(T1sum(41),[G1tensor(145)])
  call ol_merge_tensors(T1sum(42),[G1tensor(151)])
  call ol_merge_tensors(T1sum(43),[G1tensor(157)])
  call ol_merge_tensors(T1sum(44),[G1tensor(163)])
  call ol_merge_tensors(T1sum(45),[G1tensor(169)])
  call ol_merge_tensors(T1sum(46),[G1tensor(175)])
  call ol_merge_tensors(T1sum(47),[G1tensor(181)])
  call ol_merge_tensors(T1sum(48),[G1tensor(187)])
  call ol_merge_tensors(T1sum(49),[G1tensor(193)])
  call ol_merge_tensors(T1sum(50),[G1tensor(199)])
  call ol_merge_tensors(T1sum(51),[G1tensor(205)])
  call ol_merge_tensors(T1sum(52),[G1tensor(211)])
  call ol_merge_tensors(T1sum(53),[G1tensor(217)])
  call ol_merge_tensors(T1sum(54),[G1tensor(223)])
  call ol_merge_tensors(T1sum(55),[G1tensor(229)])
  call ol_merge_tensors(T1sum(56),[G1tensor(235)])
  call ol_merge_tensors(T1sum(57),[G1tensor(241)])
  call ol_merge_tensors(T1sum(58),[G1tensor(247)])
  call ol_merge_tensors(T1sum(59),[G1tensor(253)])
  call ol_merge_tensors(T1sum(60),[G1tensor(259)])
  call ol_merge_tensors(T1sum(61),[G1tensor(265)])
  call ol_merge_tensors(T1sum(62),[G1tensor(271)])
  call ol_merge_tensors(T1sum(63),[G1tensor(277)])
  call ol_merge_tensors(T1sum(64),[G1tensor(283)])
  call ol_merge_tensors(T1sum(65),[G1tensor(289)])
  call ol_merge_tensors(T1sum(66),[G1tensor(295)])
  call ol_merge_tensors(T1sum(67),[G1tensor(301)])
  call ol_merge_tensors(T1sum(68),[G1tensor(307)])
  call ol_merge_tensors(T1sum(69),[G1tensor(313)])
  call ol_merge_tensors(T1sum(70),[G1tensor(319)])
  call ol_merge_tensors(T1sum(71),[G1tensor(325)])
  call ol_merge_tensors(T1sum(72),[G1tensor(331)])
  call ol_merge_tensors(T1sum(73),[G1tensor(337)])
  call ol_merge_tensors(T1sum(74),[G1tensor(343)])
  call ol_merge_tensors(T1sum(75),[G1tensor(349)])
  call ol_merge_tensors(T1sum(76),[G1tensor(355)])
  call ol_merge_tensors(T1sum(77),[G1tensor(361)])
  call ol_merge_tensors(T1sum(78),[G1tensor(367)])
  call ol_merge_tensors(T1sum(79),[G1tensor(373)])
  call ol_merge_tensors(T1sum(80),[G1tensor(379)])
  call ol_merge_tensors(T1sum(81),[G1tensor(385)])
  call ol_merge_tensors(T1sum(82),[G1tensor(391)])
  call ol_merge_tensors(T1sum(83),[G1tensor(397)])
  call ol_merge_tensors(T1sum(84),[G1tensor(403)])
  call ol_merge_tensors(T1sum(85),[G1tensor(409)])
  call ol_merge_tensors(T1sum(86),[G1tensor(415)])
  call ol_merge_tensors(T1sum(87),[G1tensor(421)])
  call ol_merge_tensors(T1sum(88),[G1tensor(427)])
  call ol_merge_tensors(T1sum(89),[G1tensor(433)])
  call ol_merge_tensors(T1sum(90),[G1tensor(439)])
  call ol_merge_tensors(T1sum(91),[G1tensor(445)])
  call ol_merge_tensors(T1sum(92),[G1tensor(451)])
  call ol_merge_tensors(T1sum(93),[G1tensor(457)])
  call ol_merge_tensors(T1sum(94),[G1tensor(463)])
  call ol_merge_tensors(T1sum(95),[G1tensor(469)])
  call ol_merge_tensors(T1sum(96),[G1tensor(475)])
  call ol_merge_tensors(T1sum(97),[G1tensor(481)])
  call ol_merge_tensors(T1sum(98),[G1tensor(487)])
  call ol_merge_tensors(T1sum(99),[G1tensor(493)])
  call ol_merge_tensors(T1sum(100),[G1tensor(499)])
  call ol_merge_tensors(T1sum(101),[G1tensor(505)])
  call ol_merge_tensors(T1sum(102),[G1tensor(511)])
  call ol_merge_tensors(T1sum(103),[G1tensor(517)])
  call ol_merge_tensors(T1sum(104),[G1tensor(523)])
  call ol_merge_tensors(T1sum(105),[G1tensor(529)])
  call ol_merge_tensors(T1sum(106),[G1tensor(535)])
  call ol_merge_tensors(T1sum(107),[G1tensor(541)])
  call ol_merge_tensors(T1sum(108),[G1tensor(547)])
  call ol_merge_tensors(T1sum(109),[G1tensor(553)])
  call ol_merge_tensors(T1sum(110),[G1tensor(559)])
  call ol_merge_tensors(T1sum(111),[G1tensor(565)])
  call ol_merge_tensors(T1sum(112),[G1tensor(571)])
  Gcoeff(:)%j = (-(c(3)*M(4,:)%j)) * den(52)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(69),h0tab(:,69),[32,8,3,20],[0,0,0,0],4,2,wf4(:,1),wf4(:,2))
  call Hloop_QA_V(ntryL,G0H64(1),ex6(:),G0H32(7),m3h2x32(:,63),heltab2x64(:,:,69))
  Gcoeff(:)%j = (-(c(6)*M(4,:)%j)) * den(202)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(70),h0tab(:,70),[32,8,3,20],[0,0,0,0],4,2,wf4(:,1),wf4(:,3))
  call Hloop_QA_V(ntryL,G0H64(1),ex6(:),G0H32(6),m3h2x32(:,64),heltab2x64(:,:,70))
  Gcoeff(:)%j = (-(c(2)*M(2,:)%j)+c(1)*M(4,:)%j) * den(52)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(71),h0tab(:,71),[32,8,3,20],[0,0,0,0],4,2,wf4(:,1),wf4(:,2))
  call Hloop_QA_V(ntryL,G0H64(1),ex6(:),G0H32(10),m3h2x32(:,65),heltab2x64(:,:,71))
  Gcoeff(:)%j = (-(c(5)*M(2,:)%j)+c(4)*M(4,:)%j) * den(52)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(72),h0tab(:,72),[32,8,3,20],[nMZ,0,0,0],4,2,wf4(:,1),wf4(:,2))
  call Hloop_QA_Z(ntryL,G0H64(1),ex6(:),G0H32(8),ngZd,m3h2x32(:,66),heltab2x64(:,:,72))
  Gcoeff(:)%j = (-(c(27)*M(2,:)%j)+c(26)*M(4,:)%j) * den(52)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(73),h0tab(:,73),[32,8,3,20],[nMW,0,0,0],4,2,wf4(:,1),wf4(:,2))
  call Hloop_QA_W(ntryL,G0H64(1),ex6(:),G0H32(9),m3h2x32(:,67),heltab2x64(:,:,73))
  Gcoeff(:)%j = (c(12)*M(1,:)%j-c(11)*M(3,:)%j) * den(52)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(74),h0tab(:,74),[32,8,3,20],[0,0,0,0],4,2,wf4(:,1),wf4(:,2))
  call Hloop_QA_V(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,68),heltab2x64(:,:,74))
  Gcoeff(:)%j = (-(c(3)*M(4,:)%j)) * den(52)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(75),h0tab(:,75),[32,3,20,8],[0,0,0,0],4,2,wf4(:,1),wf4(:,2))
  call Hloop_VA_Q(ntryL,G0H64(1),ex6(:),G0H32(2),m3h2x32(:,69),heltab2x64(:,:,75))
  call Hloop_A_Q(ntryL,G0H32(2),32,0,G1H32(2),n2h32(42))
  Gcoeff(:)%j = (-(c(6)*M(4,:)%j)) * den(202)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(76),h0tab(:,76),[32,3,20,8],[0,0,0,0],4,2,wf4(:,1),wf4(:,3))
  call Hloop_VA_Q(ntryL,G0H64(1),ex6(:),G0H32(3),m3h2x32(:,70),heltab2x64(:,:,76))
  call Hloop_A_Q(ntryL,G0H32(3),32,0,G1H32(1),n2h32(43))
  Gcoeff(:)%j = (-(c(2)*M(2,:)%j)+c(1)*M(4,:)%j) * den(52)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(77),h0tab(:,77),[32,3,20,8],[0,0,0,0],4,2,wf4(:,1),wf4(:,2))
  call Hloop_VA_Q(ntryL,G0H64(1),ex6(:),G0H32(4),m3h2x32(:,71),heltab2x64(:,:,77))
  call Hloop_A_Q(ntryL,G0H32(4),32,0,G1H32(7),n2h32(44))
  Gcoeff(:)%j = (-(c(5)*M(2,:)%j)+c(4)*M(4,:)%j) * den(52)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(78),h0tab(:,78),[32,3,20,8],[0,0,0,nMZ],4,2,wf4(:,1),wf4(:,2))
  call Hloop_ZA_Q(ntryL,G0H64(1),ex6(:),G0H32(5),ngZd,m3h2x32(:,72),heltab2x64(:,:,78))
  call Hloop_A_Q(ntryL,G0H32(5),32,0,G1H32(6),n2h32(45))
  Gcoeff(:)%j = (-(c(27)*M(2,:)%j)+c(26)*M(4,:)%j) * den(52)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(79),h0tab(:,79),[32,3,20,8],[0,0,0,nMW],4,2,wf4(:,1),wf4(:,2))
  call Hloop_WA_Q(ntryL,G0H64(1),ex6(:),G0H32(11),m3h2x32(:,73),heltab2x64(:,:,79))
  call Hloop_A_Q(ntryL,G0H32(11),32,0,G1H32(12),n2h32(46))
  Gcoeff(:)%j = (c(12)*M(1,:)%j-c(11)*M(3,:)%j) * den(52)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(80),h0tab(:,80),[32,3,20,8],[0,0,0,0],4,2,wf4(:,1),wf4(:,2))
  call Hloop_VA_Q(ntryL,G0H64(1),ex6(:),G0H32(2),m3h2x32(:,74),heltab2x64(:,:,80))
  call Hloop_A_Q(ntryL,G0H32(2),32,0,G1H32(11),n2h32(47))
  Gcoeff(:)%j = (-(c(8)*M(1,:)%j)+c(7)*M(3,:)%j) * den(52)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(81),h0tab(:,81),[32,3,8,20],[0,0,0,0],4,2,wf4(:,1),wf4(:,2))
  call Hloop_VA_Q(ntryL,G0H64(1),ex6(:),G0H32(3),m3h2x32(:,75),heltab2x64(:,:,81))
  call Hloop_A_Q(ntryL,G0H32(3),32,0,G1H32(17),n2h32(48))
  Gcoeff(:)%j = (-(c(23)*M(2,:)%j)+c(22)*M(4,:)%j) * den(52)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(82),h0tab(:,82),[32,3,8,20],[nMW,nMW,0,0],4,2,wf4(:,1),wf4(:,2))
  call Hloop_QA_W(ntryL,G0H64(1),ex6(:),G0H32(4),m3h2x32(:,76),heltab2x64(:,:,82))
  Gcoeff(:)%j = (c(3)*M(2,:)%j) * den(204)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(83),h0tab(:,83),[32,4,3,24],[0,0,0,0],4,2,wf4(:,1),wf4(:,4))
  call Hloop_QA_V(ntryL,G0H64(1),ex6(:),G0H32(5),m3h2x32(:,77),heltab2x64(:,:,83))
  Gcoeff(:)%j = (c(6)*M(2,:)%j) * den(205)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(84),h0tab(:,84),[32,4,3,24],[0,0,0,0],4,2,wf4(:,1),wf4(:,5))
  call Hloop_QA_V(ntryL,G0H64(1),ex6(:),G0H32(11),m3h2x32(:,78),heltab2x64(:,:,84))
  Gcoeff(:)%j = (-(c(1)*M(2,:)%j)+c(2)*M(4,:)%j) * den(204)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(85),h0tab(:,85),[32,4,3,24],[0,0,0,0],4,2,wf4(:,1),wf4(:,4))
  call Hloop_QA_V(ntryL,G0H64(1),ex6(:),G0H32(2),m3h2x32(:,79),heltab2x64(:,:,85))
  Gcoeff(:)%j = (-(c(4)*M(2,:)%j)+c(5)*M(4,:)%j) * den(204)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(86),h0tab(:,86),[32,4,3,24],[nMZ,0,0,0],4,2,wf4(:,1),wf4(:,4))
  call Hloop_QA_Z(ntryL,G0H64(1),ex6(:),G0H32(3),ngZd,m3h2x32(:,80),heltab2x64(:,:,86))
  Gcoeff(:)%j = (-(c(26)*M(2,:)%j)+c(27)*M(4,:)%j) * den(204)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(87),h0tab(:,87),[32,4,3,24],[nMW,0,0,0],4,2,wf4(:,1),wf4(:,4))
  call Hloop_QA_W(ntryL,G0H64(1),ex6(:),G0H32(12),m3h2x32(:,81),heltab2x64(:,:,87))
  Gcoeff(:)%j = (c(11)*M(1,:)%j-c(12)*M(3,:)%j) * den(204)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(88),h0tab(:,88),[32,4,3,24],[0,0,0,0],4,2,wf4(:,1),wf4(:,4))
  call Hloop_QA_V(ntryL,G0H64(1),ex6(:),G0H32(13),m3h2x32(:,82),heltab2x64(:,:,88))
  Gcoeff(:)%j = (c(3)*M(2,:)%j) * den(204)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(89),h0tab(:,89),[32,3,24,4],[0,0,0,0],4,2,wf4(:,1),wf4(:,4))
  call Hloop_VA_Q(ntryL,G0H64(1),ex6(:),G0H32(14),m3h2x32(:,83),heltab2x64(:,:,89))
  call Hloop_A_Q(ntryL,G0H32(14),32,0,G1H32(16),n2h32(49))
  Gcoeff(:)%j = (c(6)*M(2,:)%j) * den(205)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(90),h0tab(:,90),[32,3,24,4],[0,0,0,0],4,2,wf4(:,1),wf4(:,5))
  call Hloop_VA_Q(ntryL,G0H64(1),ex6(:),G0H32(14),m3h2x32(:,84),heltab2x64(:,:,90))
  call Hloop_A_Q(ntryL,G0H32(14),32,0,G1H32(22),n2h32(50))
  Gcoeff(:)%j = (-(c(1)*M(2,:)%j)+c(2)*M(4,:)%j) * den(204)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(91),h0tab(:,91),[32,3,24,4],[0,0,0,0],4,2,wf4(:,1),wf4(:,4))
  call Hloop_VA_Q(ntryL,G0H64(1),ex6(:),G0H32(14),m3h2x32(:,85),heltab2x64(:,:,91))
  call Hloop_A_Q(ntryL,G0H32(14),32,0,G1H32(21),n2h32(51))
  Gcoeff(:)%j = (-(c(4)*M(2,:)%j)+c(5)*M(4,:)%j) * den(204)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(92),h0tab(:,92),[32,3,24,4],[0,0,0,nMZ],4,2,wf4(:,1),wf4(:,4))
  call Hloop_ZA_Q(ntryL,G0H64(1),ex6(:),G0H32(14),ngZd,m3h2x32(:,86),heltab2x64(:,:,92))
  call Hloop_A_Q(ntryL,G0H32(14),32,0,G1H32(27),n2h32(52))
  Gcoeff(:)%j = (-(c(26)*M(2,:)%j)+c(27)*M(4,:)%j) * den(204)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(93),h0tab(:,93),[32,3,24,4],[0,0,0,nMW],4,2,wf4(:,1),wf4(:,4))
  call Hloop_WA_Q(ntryL,G0H64(1),ex6(:),G0H32(14),m3h2x32(:,87),heltab2x64(:,:,93))
  call Hloop_A_Q(ntryL,G0H32(14),32,0,G1H32(26),n2h32(53))
  Gcoeff(:)%j = (c(11)*M(1,:)%j-c(12)*M(3,:)%j) * den(204)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(94),h0tab(:,94),[32,3,24,4],[0,0,0,0],4,2,wf4(:,1),wf4(:,4))
  call Hloop_VA_Q(ntryL,G0H64(1),ex6(:),G0H32(14),m3h2x32(:,88),heltab2x64(:,:,94))
  call Hloop_A_Q(ntryL,G0H32(14),32,0,G1H32(32),n2h32(54))
  Gcoeff(:)%j = (-(c(7)*M(1,:)%j)+c(8)*M(3,:)%j) * den(204)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(95),h0tab(:,95),[32,3,4,24],[0,0,0,0],4,2,wf4(:,1),wf4(:,4))
  call Hloop_VA_Q(ntryL,G0H64(1),ex6(:),G0H32(14),m3h2x32(:,89),heltab2x64(:,:,95))
  call Hloop_A_Q(ntryL,G0H32(14),32,0,G1H32(31),n2h32(55))
  Gcoeff(:)%j = (-(c(22)*M(2,:)%j)+c(23)*M(4,:)%j) * den(204)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(96),h0tab(:,96),[32,3,4,24],[nMW,nMW,0,0],4,2,wf4(:,1),wf4(:,4))
  call Hloop_QA_W(ntryL,G0H64(1),ex6(:),G0H32(14),m3h2x32(:,90),heltab2x64(:,:,96))
  Gcoeff(:)%j = (c(3)*M(2,:)%j) * den(54)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(97),h0tab(:,97),[36,3,8,16],[0,0,0,0],4,2,wf4(:,6),wf4(:,1))
  call Hloop_AV_Q(ntryL,G0H64(1),wf4(:,6),G0H16(1),m3h4x16(:,7),heltab2x64(:,:,97))
  call Hloop_A_Q(ntryL,G0H16(1),36,0,G1H16(1),n2h16(26))
  Gcoeff(:)%j = (c(6)*M(2,:)%j) * den(206)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(98),h0tab(:,98),[36,3,8,16],[0,0,0,0],4,2,wf4(:,7),wf4(:,1))
  call Hloop_AZ_Q(ntryL,G0H64(1),wf4(:,7),G0H16(1),ngZd,m3h4x16(:,8),heltab2x64(:,:,98))
  call Hloop_A_Q(ntryL,G0H16(1),36,0,G1H16(2),n2h16(27))
  Gcoeff(:)%j = (-(c(1)*M(2,:)%j)+c(2)*M(4,:)%j) * den(54)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(99),h0tab(:,99),[36,3,8,16],[0,0,0,0],4,2,wf4(:,6),wf4(:,1))
  call Hloop_AV_Q(ntryL,G0H64(1),wf4(:,6),G0H16(1),m3h4x16(:,9),heltab2x64(:,:,99))
  call Hloop_A_Q(ntryL,G0H16(1),36,0,G1H16(3),n2h16(28))
  Gcoeff(:)%j = (-(c(4)*M(2,:)%j)+c(5)*M(4,:)%j) * den(54)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(100),h0tab(:,100),[36,3,8,16],[0,0,nMZ,0],4,2,wf4(:,6),wf4(:,1))
  call Hloop_AV_Q(ntryL,G0H64(1),wf4(:,6),G0H16(1),m3h4x16(:,10),heltab2x64(:,:,100))
  call Hloop_A_Q(ntryL,G0H16(1),36,0,G1H16(4),n2h16(29))
  Gcoeff(:)%j = (-(c(26)*M(2,:)%j)+c(27)*M(4,:)%j) * den(54)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(101),h0tab(:,101),[36,3,8,16],[0,0,nMW,0],4,2,wf4(:,6),wf4(:,1))
  call Hloop_AV_Q(ntryL,G0H64(1),wf4(:,6),G0H16(1),m3h4x16(:,11),heltab2x64(:,:,101))
  call Hloop_A_Q(ntryL,G0H16(1),36,0,G1H16(5),n2h16(30))
  Gcoeff(:)%j = (c(11)*M(1,:)%j-c(12)*M(3,:)%j) * den(54)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(102),h0tab(:,102),[36,3,8,16],[0,0,0,0],4,2,wf4(:,6),wf4(:,1))
  call Hloop_AV_Q(ntryL,G0H64(1),wf4(:,6),G0H16(1),m3h4x16(:,12),heltab2x64(:,:,102))
  call Hloop_A_Q(ntryL,G0H16(1),36,0,G1H16(6),n2h16(31))
  Gcoeff(:)%j = (c(3)*M(2,:)%j) * den(54)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(103),h0tab(:,103),[36,3,16,8],[0,0,0,0],4,2,wf4(:,6),wf4(:,1))
  call Hloop_QV_A(ntryL,G0H64(1),wf4(:,6),G0H16(1),m3h4x16(:,13),heltab2x64(:,:,103))
  call Hloop_Q_A(ntryL,G0H16(1),36,0,G1H16(7),n2h16(32))
  Gcoeff(:)%j = (c(6)*M(2,:)%j) * den(206)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(104),h0tab(:,104),[36,3,16,8],[0,0,0,0],4,2,wf4(:,7),wf4(:,1))
  call Hloop_QZ_A(ntryL,G0H64(1),wf4(:,7),G0H16(1),ngZd,m3h4x16(:,14),heltab2x64(:,:,104))
  call Hloop_Q_A(ntryL,G0H16(1),36,0,G1H16(8),n2h16(33))
  Gcoeff(:)%j = (-(c(1)*M(2,:)%j)+c(2)*M(4,:)%j) * den(54)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(105),h0tab(:,105),[36,3,16,8],[0,0,0,0],4,2,wf4(:,6),wf4(:,1))
  call Hloop_QV_A(ntryL,G0H64(1),wf4(:,6),G0H16(1),m3h4x16(:,15),heltab2x64(:,:,105))
  call Hloop_Q_A(ntryL,G0H16(1),36,0,G1H16(9),n2h16(34))
  Gcoeff(:)%j = (-(c(4)*M(2,:)%j)+c(5)*M(4,:)%j) * den(54)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(106),h0tab(:,106),[36,3,16,8],[0,0,nMZ,0],4,2,wf4(:,6),wf4(:,1))
  call Hloop_QV_A(ntryL,G0H64(1),wf4(:,6),G0H16(1),m3h4x16(:,16),heltab2x64(:,:,106))
  call Hloop_Q_A(ntryL,G0H16(1),36,0,G1H16(10),n2h16(35))
  Gcoeff(:)%j = (-(c(26)*M(2,:)%j)+c(27)*M(4,:)%j) * den(54)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(107),h0tab(:,107),[36,3,16,8],[0,0,nMW,0],4,2,wf4(:,6),wf4(:,1))
  call Hloop_QV_A(ntryL,G0H64(1),wf4(:,6),G0H16(1),m3h4x16(:,17),heltab2x64(:,:,107))
  call Hloop_Q_A(ntryL,G0H16(1),36,0,G1H16(11),n2h16(36))
  Gcoeff(:)%j = (c(11)*M(1,:)%j-c(12)*M(3,:)%j) * den(54)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(108),h0tab(:,108),[36,3,16,8],[0,0,0,0],4,2,wf4(:,6),wf4(:,1))
  call Hloop_QV_A(ntryL,G0H64(1),wf4(:,6),G0H16(1),m3h4x16(:,18),heltab2x64(:,:,108))
  call Hloop_Q_A(ntryL,G0H16(1),36,0,G1H16(12),n2h16(37))
  Gcoeff(:)%j = (c(7)*M(1,:)%j-c(8)*M(3,:)%j) * den(54)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(109),h0tab(:,109),[36,8,3,16],[0,0,0,0],4,2,wf4(:,6),wf4(:,1))
  call Hloop_UV_W(ntryL,G0H64(1),0,wf4(:,6),36,G1H16(13),m3h4x16(:,19),heltab2x64(:,:,109))
  Gcoeff(:)%j = (-(c(22)*M(2,:)%j)+c(23)*M(4,:)%j) * den(54)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(110),h0tab(:,110),[36,8,3,16],[0,nMW,nMW,0],4,2,wf4(:,6),wf4(:,1))
  call Hloop_AV_Q(ntryL,G0H64(1),wf4(:,6),G0H16(1),m3h4x16(:,20),heltab2x64(:,:,110))
  call Hloop_A_Q(ntryL,G0H16(1),36,0,G1H16(14),n2h16(38))
  Gcoeff(:)%j = (-(c(3)*M(4,:)%j)) * den(207)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(111),h0tab(:,111),[40,3,4,16],[0,0,0,0],4,2,wf4(:,8),wf4(:,1))
  call Hloop_AV_Q(ntryL,G0H64(1),wf4(:,8),G0H16(1),m3h4x16(:,21),heltab2x64(:,:,111))
  call Hloop_A_Q(ntryL,G0H16(1),40,0,G1H16(15),n2h16(39))
  Gcoeff(:)%j = (-(c(6)*M(4,:)%j)) * den(208)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(112),h0tab(:,112),[40,3,4,16],[0,0,0,0],4,2,wf4(:,9),wf4(:,1))
  call Hloop_AZ_Q(ntryL,G0H64(1),wf4(:,9),G0H16(1),ngZd,m3h4x16(:,22),heltab2x64(:,:,112))
  call Hloop_A_Q(ntryL,G0H16(1),40,0,G1H16(16),n2h16(40))
  Gcoeff(:)%j = (-(c(2)*M(2,:)%j)+c(1)*M(4,:)%j) * den(207)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(113),h0tab(:,113),[40,3,4,16],[0,0,0,0],4,2,wf4(:,8),wf4(:,1))
  call Hloop_AV_Q(ntryL,G0H64(1),wf4(:,8),G0H16(1),m3h4x16(:,23),heltab2x64(:,:,113))
  call Hloop_A_Q(ntryL,G0H16(1),40,0,G1H16(17),n2h16(41))
  Gcoeff(:)%j = (-(c(5)*M(2,:)%j)+c(4)*M(4,:)%j) * den(207)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(114),h0tab(:,114),[40,3,4,16],[0,0,nMZ,0],4,2,wf4(:,8),wf4(:,1))
  call Hloop_AV_Q(ntryL,G0H64(1),wf4(:,8),G0H16(1),m3h4x16(:,24),heltab2x64(:,:,114))
  call Hloop_A_Q(ntryL,G0H16(1),40,0,G1H16(18),n2h16(42))
  Gcoeff(:)%j = (-(c(27)*M(2,:)%j)+c(26)*M(4,:)%j) * den(207)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(115),h0tab(:,115),[40,3,4,16],[0,0,nMW,0],4,2,wf4(:,8),wf4(:,1))
  call Hloop_AV_Q(ntryL,G0H64(1),wf4(:,8),G0H16(1),m3h4x16(:,25),heltab2x64(:,:,115))
  call Hloop_A_Q(ntryL,G0H16(1),40,0,G1H16(19),n2h16(43))
  Gcoeff(:)%j = (c(12)*M(1,:)%j-c(11)*M(3,:)%j) * den(207)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(116),h0tab(:,116),[40,3,4,16],[0,0,0,0],4,2,wf4(:,8),wf4(:,1))
  call Hloop_AV_Q(ntryL,G0H64(1),wf4(:,8),G0H16(1),m3h4x16(:,26),heltab2x64(:,:,116))
  call Hloop_A_Q(ntryL,G0H16(1),40,0,G1H16(20),n2h16(44))
  Gcoeff(:)%j = (-(c(3)*M(4,:)%j)) * den(207)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(117),h0tab(:,117),[40,3,16,4],[0,0,0,0],4,2,wf4(:,8),wf4(:,1))
  call Hloop_QV_A(ntryL,G0H64(1),wf4(:,8),G0H16(1),m3h4x16(:,27),heltab2x64(:,:,117))
  call Hloop_Q_A(ntryL,G0H16(1),40,0,G1H16(21),n2h16(45))
  Gcoeff(:)%j = (-(c(6)*M(4,:)%j)) * den(208)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(118),h0tab(:,118),[40,3,16,4],[0,0,0,0],4,2,wf4(:,9),wf4(:,1))
  call Hloop_QZ_A(ntryL,G0H64(1),wf4(:,9),G0H16(1),ngZd,m3h4x16(:,28),heltab2x64(:,:,118))
  call Hloop_Q_A(ntryL,G0H16(1),40,0,G1H16(22),n2h16(46))
  Gcoeff(:)%j = (-(c(2)*M(2,:)%j)+c(1)*M(4,:)%j) * den(207)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(119),h0tab(:,119),[40,3,16,4],[0,0,0,0],4,2,wf4(:,8),wf4(:,1))
  call Hloop_QV_A(ntryL,G0H64(1),wf4(:,8),G0H16(1),m3h4x16(:,29),heltab2x64(:,:,119))
  call Hloop_Q_A(ntryL,G0H16(1),40,0,G1H16(23),n2h16(47))
  Gcoeff(:)%j = (-(c(5)*M(2,:)%j)+c(4)*M(4,:)%j) * den(207)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(120),h0tab(:,120),[40,3,16,4],[0,0,nMZ,0],4,2,wf4(:,8),wf4(:,1))
  call Hloop_QV_A(ntryL,G0H64(1),wf4(:,8),G0H16(1),m3h4x16(:,30),heltab2x64(:,:,120))
  call Hloop_Q_A(ntryL,G0H16(1),40,0,G1H16(24),n2h16(48))
  Gcoeff(:)%j = (-(c(27)*M(2,:)%j)+c(26)*M(4,:)%j) * den(207)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(121),h0tab(:,121),[40,3,16,4],[0,0,nMW,0],4,2,wf4(:,8),wf4(:,1))
  call Hloop_QV_A(ntryL,G0H64(1),wf4(:,8),G0H16(1),m3h4x16(:,31),heltab2x64(:,:,121))
  call Hloop_Q_A(ntryL,G0H16(1),40,0,G1H16(25),n2h16(49))
  Gcoeff(:)%j = (c(12)*M(1,:)%j-c(11)*M(3,:)%j) * den(207)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(122),h0tab(:,122),[40,3,16,4],[0,0,0,0],4,2,wf4(:,8),wf4(:,1))
  call Hloop_QV_A(ntryL,G0H64(1),wf4(:,8),G0H16(1),m3h4x16(:,32),heltab2x64(:,:,122))
  call Hloop_Q_A(ntryL,G0H16(1),40,0,G1H16(26),n2h16(50))
  Gcoeff(:)%j = (c(8)*M(1,:)%j-c(7)*M(3,:)%j) * den(207)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(123),h0tab(:,123),[40,4,3,16],[0,0,0,0],4,2,wf4(:,8),wf4(:,1))
  call Hloop_UV_W(ntryL,G0H64(1),0,wf4(:,8),40,G1H16(27),m3h4x16(:,33),heltab2x64(:,:,123))
  Gcoeff(:)%j = (-(c(23)*M(2,:)%j)+c(22)*M(4,:)%j) * den(207)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(124),h0tab(:,124),[40,4,3,16],[0,nMW,nMW,0],4,2,wf4(:,8),wf4(:,1))
  call Hloop_AV_Q(ntryL,G0H64(1),wf4(:,8),G0H16(1),m3h4x16(:,34),heltab2x64(:,:,124))
  call Hloop_A_Q(ntryL,G0H16(1),40,0,G1H16(28),n2h16(51))
  Gcoeff(:)%j = (-(c(1)*M(2,:)%j)+c(2)*M(4,:)%j) * den(15)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(125),h0tab(:,125),[32,7,16,8],[0,0,0,0],4,1,wf8(:,12))
  call Hloop_VA_Q(ntryL,G0H64(1),ex6(:),G0H32(15),m3h2x32(:,91),heltab2x64(:,:,125))
  call Hloop_A_Q(ntryL,G0H32(15),32,0,G1H32(5),n2h32(56))
  Gcoeff(:)%j = (-(c(1)*M(2,:)%j)+c(2)*M(4,:)%j) * den(15)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(126),h0tab(:,126),[32,7,16,8],[0,0,0,0],4,1,wf8(:,12))
  call Hloop_VA_Q(ntryL,G0H64(1),ex6(:),G0H32(15),m3h2x32(:,92),heltab2x64(:,:,126))
  call Hloop_A_Q(ntryL,G0H32(15),32,0,G1H32(3),n2h32(57))
  Gcoeff(:)%j = (-(c(4)*M(2,:)%j)+c(5)*M(4,:)%j) * den(15)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(127),h0tab(:,127),[32,7,16,8],[0,0,0,nMZ],4,1,wf8(:,12))
  call Hloop_ZA_Q(ntryL,G0H64(1),ex6(:),G0H32(15),ngZd,m3h2x32(:,93),heltab2x64(:,:,127))
  call Hloop_A_Q(ntryL,G0H32(15),32,0,G1H32(4),n2h32(58))
  Gcoeff(:)%j = (-(c(4)*M(2,:)%j)+c(5)*M(4,:)%j) * den(15)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(128),h0tab(:,128),[32,7,16,8],[0,nMZ,0,0],4,1,wf8(:,12))
  call Hloop_VA_Q(ntryL,G0H64(1),ex6(:),G0H32(15),m3h2x32(:,94),heltab2x64(:,:,128))
  call Hloop_A_Q(ntryL,G0H32(15),32,0,G1H32(10),n2h32(59))
  Gcoeff(:)%j = (c(11)*M(1,:)%j+c(17)*M(3,:)%j) * den(15)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(129),h0tab(:,129),[32,7,16,8],[0,0,0,0],4,1,wf8(:,12))
  call Hloop_VA_Q(ntryL,G0H64(1),ex6(:),G0H32(15),m3h2x32(:,95),heltab2x64(:,:,129))
  call Hloop_A_Q(ntryL,G0H32(15),32,0,G1H32(8),n2h32(60))
  Gcoeff(:)%j = (-(c(2)*M(2,:)%j)+c(1)*M(4,:)%j) * den(15)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(130),h0tab(:,130),[32,7,16,8],[0,0,0,0],4,1,wf8(:,12))
  call Hloop_QA_V(ntryL,G0H64(1),ex6(:),G0H32(15),m3h2x32(:,96),heltab2x64(:,:,130))
  Gcoeff(:)%j = (-(c(2)*M(2,:)%j)+c(1)*M(4,:)%j) * den(15)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(131),h0tab(:,131),[32,7,16,8],[0,0,0,0],4,1,wf8(:,12))
  call Hloop_QA_V(ntryL,G0H64(1),ex6(:),G0H32(16),m3h2x32(:,97),heltab2x64(:,:,131))
  Gcoeff(:)%j = (-(c(5)*M(2,:)%j)+c(4)*M(4,:)%j) * den(15)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(132),h0tab(:,132),[32,7,16,8],[0,0,nMZ,0],4,1,wf8(:,12))
  call Hloop_QA_V(ntryL,G0H64(1),ex6(:),G0H32(17),m3h2x32(:,98),heltab2x64(:,:,132))
  Gcoeff(:)%j = (-(c(5)*M(2,:)%j)+c(4)*M(4,:)%j) * den(15)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(133),h0tab(:,133),[32,7,16,8],[nMZ,0,0,0],4,1,wf8(:,12))
  call Hloop_QA_Z(ntryL,G0H64(1),ex6(:),G0H32(18),ngZd,m3h2x32(:,99),heltab2x64(:,:,133))
  Gcoeff(:)%j = (-(c(17)*M(1,:)%j)-c(11)*M(3,:)%j) * den(15)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(134),h0tab(:,134),[32,7,16,8],[0,0,0,0],4,1,wf8(:,12))
  call Hloop_QA_V(ntryL,G0H64(1),ex6(:),G0H32(19),m3h2x32(:,100),heltab2x64(:,:,134))
  Gcoeff(:)%j = (-(c(1)*M(2,:)%j)+c(2)*M(4,:)%j) * den(15)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(135),h0tab(:,135),[32,7,8,16],[0,0,0,0],4,1,wf8(:,12))
  call Hloop_VA_Q(ntryL,G0H64(1),ex6(:),G0H32(20),m3h2x32(:,101),heltab2x64(:,:,135))
  call Hloop_A_Q(ntryL,G0H32(20),32,0,G1H32(9),n2h32(61))
  Gcoeff(:)%j = (-(c(1)*M(2,:)%j)+c(2)*M(4,:)%j) * den(15)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(136),h0tab(:,136),[32,7,8,16],[0,0,0,0],4,1,wf8(:,12))
  call Hloop_VA_Q(ntryL,G0H64(1),ex6(:),G0H32(20),m3h2x32(:,102),heltab2x64(:,:,136))
  call Hloop_A_Q(ntryL,G0H32(20),32,0,G1H32(15),n2h32(62))
  Gcoeff(:)%j = (-(c(4)*M(2,:)%j)+c(5)*M(4,:)%j) * den(15)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(137),h0tab(:,137),[32,7,8,16],[0,nMZ,0,0],4,1,wf8(:,12))
  call Hloop_VA_Q(ntryL,G0H64(1),ex6(:),G0H32(20),m3h2x32(:,103),heltab2x64(:,:,137))
  call Hloop_A_Q(ntryL,G0H32(20),32,0,G1H32(13),n2h32(63))
  Gcoeff(:)%j = (-(c(4)*M(2,:)%j)+c(5)*M(4,:)%j) * den(15)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(138),h0tab(:,138),[32,7,8,16],[0,0,0,nMZ],4,1,wf8(:,12))
  call Hloop_ZA_Q(ntryL,G0H64(1),ex6(:),G0H32(20),ngZd,m3h2x32(:,104),heltab2x64(:,:,138))
  call Hloop_A_Q(ntryL,G0H32(20),32,0,G1H32(14),n2h32(64))
  Gcoeff(:)%j = (c(15)*M(1,:)%j-c(13)*M(3,:)%j) * den(15)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(139),h0tab(:,139),[32,7,8,16],[0,0,0,0],4,1,wf8(:,12))
  call Hloop_VA_Q(ntryL,G0H64(1),ex6(:),G0H32(20),m3h2x32(:,105),heltab2x64(:,:,139))
  call Hloop_A_Q(ntryL,G0H32(20),32,0,G1H32(20),n2h32(65))
  Gcoeff(:)%j = (-(c(2)*M(2,:)%j)+c(1)*M(4,:)%j) * den(15)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(140),h0tab(:,140),[32,8,7,16],[0,0,0,0],4,1,wf8(:,12))
  call Hloop_VA_Q(ntryL,G0H64(1),ex6(:),G0H32(20),m3h2x32(:,106),heltab2x64(:,:,140))
  call Hloop_A_Q(ntryL,G0H32(20),32,0,G1H32(18),n2h32(66))
  Gcoeff(:)%j = (-(c(2)*M(2,:)%j)+c(1)*M(4,:)%j) * den(15)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(141),h0tab(:,141),[32,8,7,16],[0,0,0,0],4,1,wf8(:,12))
  call Hloop_VA_Q(ntryL,G0H64(1),ex6(:),G0H32(20),m3h2x32(:,107),heltab2x64(:,:,141))
  call Hloop_A_Q(ntryL,G0H32(20),32,0,G1H32(19),n2h32(67))
  Gcoeff(:)%j = (-(c(5)*M(2,:)%j)+c(4)*M(4,:)%j) * den(15)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(142),h0tab(:,142),[32,8,7,16],[0,nMZ,0,0],4,1,wf8(:,12))
  call Hloop_VA_Q(ntryL,G0H64(1),ex6(:),G0H32(20),m3h2x32(:,108),heltab2x64(:,:,142))
  call Hloop_A_Q(ntryL,G0H32(20),32,0,G1H32(25),n2h32(68))
  Gcoeff(:)%j = (-(c(5)*M(2,:)%j)+c(4)*M(4,:)%j) * den(15)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(143),h0tab(:,143),[32,8,7,16],[0,0,0,nMZ],4,1,wf8(:,12))
  call Hloop_ZA_Q(ntryL,G0H64(1),ex6(:),G0H32(20),ngZd,m3h2x32(:,109),heltab2x64(:,:,143))
  call Hloop_A_Q(ntryL,G0H32(20),32,0,G1H32(23),n2h32(69))
  Gcoeff(:)%j = (c(13)*M(1,:)%j-c(15)*M(3,:)%j) * den(15)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(144),h0tab(:,144),[32,8,7,16],[0,0,0,0],4,1,wf8(:,12))
  call Hloop_VA_Q(ntryL,G0H64(1),ex6(:),G0H32(20),m3h2x32(:,110),heltab2x64(:,:,144))
  call Hloop_A_Q(ntryL,G0H32(20),32,0,G1H32(24),n2h32(70))
  Gcoeff(:)%j = (-(c(2)*M(2,:)%j)+c(1)*M(4,:)%j) * den(4)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(145),h0tab(:,145),[32,4,16,11],[0,0,0,0],4,1,wf8(:,3))
  call Hloop_QA_V(ntryL,G0H64(1),ex6(:),G0H32(20),m3h2x32(:,111),heltab2x64(:,:,145))
  Gcoeff(:)%j = (-(c(2)*M(2,:)%j)+c(1)*M(4,:)%j) * den(4)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(146),h0tab(:,146),[32,4,16,11],[0,0,0,0],4,1,wf8(:,3))
  call Hloop_QA_V(ntryL,G0H64(1),ex6(:),G0H32(21),m3h2x32(:,112),heltab2x64(:,:,146))
  Gcoeff(:)%j = (-(c(5)*M(2,:)%j)+c(4)*M(4,:)%j) * den(4)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(147),h0tab(:,147),[32,4,16,11],[nMZ,0,0,0],4,1,wf8(:,3))
  call Hloop_QA_Z(ntryL,G0H64(1),ex6(:),G0H32(22),ngZd,m3h2x32(:,113),heltab2x64(:,:,147))
  Gcoeff(:)%j = (-(c(5)*M(2,:)%j)+c(4)*M(4,:)%j) * den(4)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(148),h0tab(:,148),[32,4,16,11],[0,0,nMZ,0],4,1,wf8(:,3))
  call Hloop_QA_V(ntryL,G0H64(1),ex6(:),G0H32(23),m3h2x32(:,114),heltab2x64(:,:,148))
  Gcoeff(:)%j = (-(c(17)*M(1,:)%j)-c(11)*M(3,:)%j) * den(4)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(149),h0tab(:,149),[32,4,16,11],[0,0,0,0],4,1,wf8(:,3))
  call Hloop_QA_V(ntryL,G0H64(1),ex6(:),G0H32(24),m3h2x32(:,115),heltab2x64(:,:,149))
  Gcoeff(:)%j = (-(c(1)*M(2,:)%j)+c(2)*M(4,:)%j) * den(4)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(150),h0tab(:,150),[32,4,16,11],[0,0,0,0],4,1,wf8(:,3))
  call Hloop_VA_Q(ntryL,G0H64(1),ex6(:),G0H32(25),m3h2x32(:,116),heltab2x64(:,:,150))
  call Hloop_A_Q(ntryL,G0H32(25),32,0,G1H32(30),n2h32(71))
  Gcoeff(:)%j = (-(c(1)*M(2,:)%j)+c(2)*M(4,:)%j) * den(4)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(151),h0tab(:,151),[32,4,16,11],[0,0,0,0],4,1,wf8(:,3))
  call Hloop_VA_Q(ntryL,G0H64(1),ex6(:),G0H32(25),m3h2x32(:,117),heltab2x64(:,:,151))
  call Hloop_A_Q(ntryL,G0H32(25),32,0,G1H32(28),n2h32(72))
  Gcoeff(:)%j = (-(c(4)*M(2,:)%j)+c(5)*M(4,:)%j) * den(4)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(152),h0tab(:,152),[32,4,16,11],[0,nMZ,0,0],4,1,wf8(:,3))
  call Hloop_VA_Q(ntryL,G0H64(1),ex6(:),G0H32(25),m3h2x32(:,118),heltab2x64(:,:,152))
  call Hloop_A_Q(ntryL,G0H32(25),32,0,G1H32(29),n2h32(73))
  Gcoeff(:)%j = (-(c(4)*M(2,:)%j)+c(5)*M(4,:)%j) * den(4)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(153),h0tab(:,153),[32,4,16,11],[0,0,0,nMZ],4,1,wf8(:,3))
  call Hloop_ZA_Q(ntryL,G0H64(1),ex6(:),G0H32(25),ngZd,m3h2x32(:,119),heltab2x64(:,:,153))
  call Hloop_A_Q(ntryL,G0H32(25),32,0,G1H32(35),n2h32(74))
  Gcoeff(:)%j = (c(11)*M(1,:)%j+c(17)*M(3,:)%j) * den(4)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(154),h0tab(:,154),[32,4,16,11],[0,0,0,0],4,1,wf8(:,3))
  call Hloop_VA_Q(ntryL,G0H64(1),ex6(:),G0H32(25),m3h2x32(:,120),heltab2x64(:,:,154))
  call Hloop_A_Q(ntryL,G0H32(25),32,0,G1H32(33),n2h32(75))
  Gcoeff(:)%j = (-(c(2)*M(2,:)%j)+c(1)*M(4,:)%j) * den(4)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(155),h0tab(:,155),[32,11,4,16],[0,0,0,0],4,1,wf8(:,3))
  call Hloop_VA_Q(ntryL,G0H64(1),ex6(:),G0H32(25),m3h2x32(:,121),heltab2x64(:,:,155))
  call Hloop_A_Q(ntryL,G0H32(25),32,0,G1H32(34),n2h32(76))
  Gcoeff(:)%j = (-(c(2)*M(2,:)%j)+c(1)*M(4,:)%j) * den(4)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(156),h0tab(:,156),[32,11,4,16],[0,0,0,0],4,1,wf8(:,3))
  call Hloop_VA_Q(ntryL,G0H64(1),ex6(:),G0H32(25),m3h2x32(:,122),heltab2x64(:,:,156))
  call Hloop_A_Q(ntryL,G0H32(25),32,0,G1H32(36),n2h32(77))
  Gcoeff(:)%j = (-(c(5)*M(2,:)%j)+c(4)*M(4,:)%j) * den(4)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(157),h0tab(:,157),[32,11,4,16],[0,nMZ,0,0],4,1,wf8(:,3))
  call Hloop_VA_Q(ntryL,G0H64(1),ex6(:),G0H32(25),m3h2x32(:,123),heltab2x64(:,:,157))
  call Hloop_A_Q(ntryL,G0H32(25),32,0,G1H32(37),n2h32(78))
  Gcoeff(:)%j = (-(c(5)*M(2,:)%j)+c(4)*M(4,:)%j) * den(4)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(158),h0tab(:,158),[32,11,4,16],[0,0,0,nMZ],4,1,wf8(:,3))
  call Hloop_ZA_Q(ntryL,G0H64(1),ex6(:),G0H32(25),ngZd,m3h2x32(:,124),heltab2x64(:,:,158))
  call Hloop_A_Q(ntryL,G0H32(25),32,0,G1H32(38),n2h32(79))
  Gcoeff(:)%j = (c(13)*M(1,:)%j-c(15)*M(3,:)%j) * den(4)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(159),h0tab(:,159),[32,11,4,16],[0,0,0,0],4,1,wf8(:,3))
  call Hloop_VA_Q(ntryL,G0H64(1),ex6(:),G0H32(25),m3h2x32(:,125),heltab2x64(:,:,159))
  call Hloop_A_Q(ntryL,G0H32(25),32,0,G1H32(39),n2h32(80))
  Gcoeff(:)%j = (-(c(1)*M(2,:)%j)+c(2)*M(4,:)%j) * den(4)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(160),h0tab(:,160),[32,4,11,16],[0,0,0,0],4,1,wf8(:,3))
  call Hloop_VA_Q(ntryL,G0H64(1),ex6(:),G0H32(25),m3h2x32(:,126),heltab2x64(:,:,160))
  call Hloop_A_Q(ntryL,G0H32(25),32,0,G1H32(40),n2h32(81))
  Gcoeff(:)%j = (-(c(1)*M(2,:)%j)+c(2)*M(4,:)%j) * den(4)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(161),h0tab(:,161),[32,4,11,16],[0,0,0,0],4,1,wf8(:,3))
  call Hloop_VA_Q(ntryL,G0H64(1),ex6(:),G0H32(25),m3h2x32(:,127),heltab2x64(:,:,161))
  call Hloop_A_Q(ntryL,G0H32(25),32,0,G1H32(41),n2h32(82))
  Gcoeff(:)%j = (-(c(4)*M(2,:)%j)+c(5)*M(4,:)%j) * den(4)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(162),h0tab(:,162),[32,4,11,16],[0,nMZ,0,0],4,1,wf8(:,3))
  call Hloop_VA_Q(ntryL,G0H64(1),ex6(:),G0H32(25),m3h2x32(:,128),heltab2x64(:,:,162))
  call Hloop_A_Q(ntryL,G0H32(25),32,0,G1H32(42),n2h32(83))
  Gcoeff(:)%j = (-(c(4)*M(2,:)%j)+c(5)*M(4,:)%j) * den(4)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(163),h0tab(:,163),[32,4,11,16],[0,0,0,nMZ],4,1,wf8(:,3))
  call Hloop_ZA_Q(ntryL,G0H64(1),ex6(:),G0H32(25),ngZd,m3h2x32(:,129),heltab2x64(:,:,163))
  call Hloop_A_Q(ntryL,G0H32(25),32,0,G1H32(43),n2h32(84))
  Gcoeff(:)%j = (c(15)*M(1,:)%j-c(13)*M(3,:)%j) * den(4)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(164),h0tab(:,164),[32,4,11,16],[0,0,0,0],4,1,wf8(:,3))
  call Hloop_VA_Q(ntryL,G0H64(1),ex6(:),G0H32(25),m3h2x32(:,130),heltab2x64(:,:,164))
  call Hloop_A_Q(ntryL,G0H32(25),32,0,G1H32(44),n2h32(85))
  Gcoeff(:)%j = (-(c(1)*M(2,:)%j)+c(2)*M(4,:)%j) * den(66)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(165),h0tab(:,165),[32,4,8,19],[0,0,0,0],4,1,wf8(:,68))
  call Hloop_VA_Q(ntryL,G0H64(1),ex6(:),G0H32(25),m3h2x32(:,131),heltab2x64(:,:,165))
  call Hloop_A_Q(ntryL,G0H32(25),32,0,G1H32(45),n2h32(86))
  Gcoeff(:)%j = (-(c(1)*M(2,:)%j)+c(2)*M(4,:)%j) * den(66)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(166),h0tab(:,166),[32,4,8,19],[0,0,0,0],4,1,wf8(:,68))
  call Hloop_VA_Q(ntryL,G0H64(1),ex6(:),G0H32(25),m3h2x32(:,132),heltab2x64(:,:,166))
  call Hloop_A_Q(ntryL,G0H32(25),32,0,G1H32(46),n2h32(87))
  Gcoeff(:)%j = (-(c(4)*M(2,:)%j)+c(5)*M(4,:)%j) * den(66)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(167),h0tab(:,167),[32,4,8,19],[0,nMZ,0,0],4,1,wf8(:,68))
  call Hloop_VA_Q(ntryL,G0H64(1),ex6(:),G0H32(25),m3h2x32(:,133),heltab2x64(:,:,167))
  call Hloop_A_Q(ntryL,G0H32(25),32,0,G1H32(47),n2h32(88))
  Gcoeff(:)%j = (-(c(4)*M(2,:)%j)+c(5)*M(4,:)%j) * den(66)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(168),h0tab(:,168),[32,4,8,19],[0,0,0,nMZ],4,1,wf8(:,68))
  call Hloop_ZA_Q(ntryL,G0H64(1),ex6(:),G0H32(25),ngZd,m3h2x32(:,134),heltab2x64(:,:,168))
  call Hloop_A_Q(ntryL,G0H32(25),32,0,G1H32(48),n2h32(89))
  Gcoeff(:)%j = (c(15)*M(1,:)%j-c(13)*M(3,:)%j) * den(66)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(169),h0tab(:,169),[32,4,8,19],[0,0,0,0],4,1,wf8(:,68))
  call Hloop_VA_Q(ntryL,G0H64(1),ex6(:),G0H32(25),m3h2x32(:,135),heltab2x64(:,:,169))
  call Hloop_A_Q(ntryL,G0H32(25),32,0,G1H32(49),n2h32(90))
  Gcoeff(:)%j = (-(c(2)*M(2,:)%j)+c(1)*M(4,:)%j) * den(66)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(170),h0tab(:,170),[32,8,4,19],[0,0,0,0],4,1,wf8(:,68))
  call Hloop_VA_Q(ntryL,G0H64(1),ex6(:),G0H32(25),m3h2x32(:,136),heltab2x64(:,:,170))
  call Hloop_A_Q(ntryL,G0H32(25),32,0,G1H32(50),n2h32(91))
  Gcoeff(:)%j = (-(c(2)*M(2,:)%j)+c(1)*M(4,:)%j) * den(66)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(171),h0tab(:,171),[32,8,4,19],[0,0,0,0],4,1,wf8(:,68))
  call Hloop_VA_Q(ntryL,G0H64(1),ex6(:),G0H32(25),m3h2x32(:,137),heltab2x64(:,:,171))
  call Hloop_A_Q(ntryL,G0H32(25),32,0,G1H32(51),n2h32(92))
  Gcoeff(:)%j = (-(c(5)*M(2,:)%j)+c(4)*M(4,:)%j) * den(66)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(172),h0tab(:,172),[32,8,4,19],[0,nMZ,0,0],4,1,wf8(:,68))
  call Hloop_VA_Q(ntryL,G0H64(1),ex6(:),G0H32(25),m3h2x32(:,138),heltab2x64(:,:,172))
  call Hloop_A_Q(ntryL,G0H32(25),32,0,G1H32(52),n2h32(93))
  Gcoeff(:)%j = (-(c(5)*M(2,:)%j)+c(4)*M(4,:)%j) * den(66)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(173),h0tab(:,173),[32,8,4,19],[0,0,0,nMZ],4,1,wf8(:,68))
  call Hloop_ZA_Q(ntryL,G0H64(1),ex6(:),G0H32(25),ngZd,m3h2x32(:,139),heltab2x64(:,:,173))
  call Hloop_A_Q(ntryL,G0H32(25),32,0,G1H32(53),n2h32(94))
  Gcoeff(:)%j = (c(13)*M(1,:)%j-c(15)*M(3,:)%j) * den(66)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(174),h0tab(:,174),[32,8,4,19],[0,0,0,0],4,1,wf8(:,68))
  call Hloop_VA_Q(ntryL,G0H64(1),ex6(:),G0H32(25),m3h2x32(:,140),heltab2x64(:,:,174))
  call Hloop_A_Q(ntryL,G0H32(25),32,0,G1H32(54),n2h32(95))
  Gcoeff(:)%j = (-(c(1)*M(2,:)%j)+c(2)*M(4,:)%j) * den(66)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(175),h0tab(:,175),[32,4,19,8],[0,0,0,0],4,1,wf8(:,68))
  call Hloop_VA_Q(ntryL,G0H64(1),ex6(:),G0H32(25),m3h2x32(:,141),heltab2x64(:,:,175))
  call Hloop_A_Q(ntryL,G0H32(25),32,0,G1H32(55),n2h32(96))
  Gcoeff(:)%j = (-(c(1)*M(2,:)%j)+c(2)*M(4,:)%j) * den(66)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(176),h0tab(:,176),[32,4,19,8],[0,0,0,0],4,1,wf8(:,68))
  call Hloop_VA_Q(ntryL,G0H64(1),ex6(:),G0H32(25),m3h2x32(:,142),heltab2x64(:,:,176))
  call Hloop_A_Q(ntryL,G0H32(25),32,0,G1H32(56),n2h32(97))
  Gcoeff(:)%j = (-(c(4)*M(2,:)%j)+c(5)*M(4,:)%j) * den(66)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(177),h0tab(:,177),[32,4,19,8],[0,nMZ,0,0],4,1,wf8(:,68))
  call Hloop_VA_Q(ntryL,G0H64(1),ex6(:),G0H32(25),m3h2x32(:,143),heltab2x64(:,:,177))
  call Hloop_A_Q(ntryL,G0H32(25),32,0,G1H32(57),n2h32(98))
  Gcoeff(:)%j = (-(c(4)*M(2,:)%j)+c(5)*M(4,:)%j) * den(66)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(178),h0tab(:,178),[32,4,19,8],[0,0,0,nMZ],4,1,wf8(:,68))
  call Hloop_ZA_Q(ntryL,G0H64(1),ex6(:),G0H32(25),ngZd,m3h2x32(:,144),heltab2x64(:,:,178))
  call Hloop_A_Q(ntryL,G0H32(25),32,0,G1H32(58),n2h32(99))
  Gcoeff(:)%j = (c(11)*M(1,:)%j+c(17)*M(3,:)%j) * den(66)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(179),h0tab(:,179),[32,4,19,8],[0,0,0,0],4,1,wf8(:,68))
  call Hloop_VA_Q(ntryL,G0H64(1),ex6(:),G0H32(25),m3h2x32(:,145),heltab2x64(:,:,179))
  call Hloop_A_Q(ntryL,G0H32(25),32,0,G1H32(59),n2h32(100))
  Gcoeff(:)%j = (-(c(2)*M(2,:)%j)+c(1)*M(4,:)%j) * den(66)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(180),h0tab(:,180),[32,4,19,8],[0,0,0,0],4,1,wf8(:,68))
  call Hloop_QA_V(ntryL,G0H64(1),ex6(:),G0H32(25),m3h2x32(:,146),heltab2x64(:,:,180))
  Gcoeff(:)%j = (-(c(2)*M(2,:)%j)+c(1)*M(4,:)%j) * den(66)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(181),h0tab(:,181),[32,4,19,8],[0,0,0,0],4,1,wf8(:,68))
  call Hloop_QA_V(ntryL,G0H64(1),ex6(:),G0H32(26),m3h2x32(:,147),heltab2x64(:,:,181))
  Gcoeff(:)%j = (-(c(5)*M(2,:)%j)+c(4)*M(4,:)%j) * den(66)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(182),h0tab(:,182),[32,4,19,8],[nMZ,0,0,0],4,1,wf8(:,68))
  call Hloop_QA_Z(ntryL,G0H64(1),ex6(:),G0H32(27),ngZd,m3h2x32(:,148),heltab2x64(:,:,182))
  Gcoeff(:)%j = (-(c(5)*M(2,:)%j)+c(4)*M(4,:)%j) * den(66)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(183),h0tab(:,183),[32,4,19,8],[0,0,nMZ,0],4,1,wf8(:,68))
  call Hloop_QA_V(ntryL,G0H64(1),ex6(:),G0H32(28),m3h2x32(:,149),heltab2x64(:,:,183))
  Gcoeff(:)%j = (-(c(17)*M(1,:)%j)-c(11)*M(3,:)%j) * den(66)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(184),h0tab(:,184),[32,4,19,8],[0,0,0,0],4,1,wf8(:,68))
  call Hloop_QA_V(ntryL,G0H64(1),ex6(:),G0H32(29),m3h2x32(:,150),heltab2x64(:,:,184))
  Gcoeff(:)%j = (-(c(2)*M(2,:)%j)+c(1)*M(4,:)%j) * den(57)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(185),h0tab(:,185),[35,8,4,16],[0,0,0,0],4,1,wf8(:,60))
  call Hloop_VA_Q(ntryL,G0H64(1),wf8(:,60),G0H8(1),m3h8x8(:,1),heltab2x64(:,:,185))
  call Hloop_A_Q(ntryL,G0H8(1),35,0,G1H8(10),n2h8(37))
  Gcoeff(:)%j = (-(c(2)*M(2,:)%j)+c(1)*M(4,:)%j) * den(57)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(186),h0tab(:,186),[35,8,4,16],[0,0,0,0],4,1,wf8(:,60))
  call Hloop_VA_Q(ntryL,G0H64(1),wf8(:,60),G0H8(1),m3h8x8(:,2),heltab2x64(:,:,186))
  call Hloop_A_Q(ntryL,G0H8(1),35,0,G1H8(1),n2h8(38))
  Gcoeff(:)%j = (-(c(5)*M(2,:)%j)+c(4)*M(4,:)%j) * den(57)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(187),h0tab(:,187),[35,8,4,16],[0,nMZ,0,0],4,1,wf8(:,60))
  call Hloop_VA_Q(ntryL,G0H64(1),wf8(:,60),G0H8(1),m3h8x8(:,3),heltab2x64(:,:,187))
  call Hloop_A_Q(ntryL,G0H8(1),35,0,G1H8(2),n2h8(39))
  Gcoeff(:)%j = (-(c(5)*M(2,:)%j)+c(4)*M(4,:)%j) * den(57)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(188),h0tab(:,188),[35,8,4,16],[0,0,0,nMZ],4,1,wf8(:,60))
  call Hloop_ZA_Q(ntryL,G0H64(1),wf8(:,60),G0H8(1),ngZd,m3h8x8(:,4),heltab2x64(:,:,188))
  call Hloop_A_Q(ntryL,G0H8(1),35,0,G1H8(9),n2h8(40))
  Gcoeff(:)%j = (c(13)*M(1,:)%j-c(15)*M(3,:)%j) * den(57)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(189),h0tab(:,189),[35,8,4,16],[0,0,0,0],4,1,wf8(:,60))
  call Hloop_VA_Q(ntryL,G0H64(1),wf8(:,60),G0H8(1),m3h8x8(:,5),heltab2x64(:,:,189))
  call Hloop_A_Q(ntryL,G0H8(1),35,0,G1H8(11),n2h8(41))
  Gcoeff(:)%j = (-(c(1)*M(2,:)%j)+c(2)*M(4,:)%j) * den(57)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(190),h0tab(:,190),[35,4,8,16],[0,0,0,0],4,1,wf8(:,60))
  call Hloop_VA_Q(ntryL,G0H64(1),wf8(:,60),G0H8(1),m3h8x8(:,6),heltab2x64(:,:,190))
  call Hloop_A_Q(ntryL,G0H8(1),35,0,G1H8(12),n2h8(42))
  Gcoeff(:)%j = (-(c(1)*M(2,:)%j)+c(2)*M(4,:)%j) * den(57)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(191),h0tab(:,191),[35,4,8,16],[0,0,0,0],4,1,wf8(:,60))
  call Hloop_VA_Q(ntryL,G0H64(1),wf8(:,60),G0H8(1),m3h8x8(:,7),heltab2x64(:,:,191))
  call Hloop_A_Q(ntryL,G0H8(1),35,0,G1H8(3),n2h8(43))
  Gcoeff(:)%j = (-(c(4)*M(2,:)%j)+c(5)*M(4,:)%j) * den(57)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(192),h0tab(:,192),[35,4,8,16],[0,nMZ,0,0],4,1,wf8(:,60))
  call Hloop_VA_Q(ntryL,G0H64(1),wf8(:,60),G0H8(1),m3h8x8(:,8),heltab2x64(:,:,192))
  call Hloop_A_Q(ntryL,G0H8(1),35,0,G1H8(4),n2h8(44))
  Gcoeff(:)%j = (-(c(4)*M(2,:)%j)+c(5)*M(4,:)%j) * den(57)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(193),h0tab(:,193),[35,4,8,16],[0,0,0,nMZ],4,1,wf8(:,60))
  call Hloop_ZA_Q(ntryL,G0H64(1),wf8(:,60),G0H8(1),ngZd,m3h8x8(:,9),heltab2x64(:,:,193))
  call Hloop_A_Q(ntryL,G0H8(1),35,0,G1H8(7),n2h8(45))
  Gcoeff(:)%j = (c(15)*M(1,:)%j-c(13)*M(3,:)%j) * den(57)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(194),h0tab(:,194),[35,4,8,16],[0,0,0,0],4,1,wf8(:,60))
  call Hloop_VA_Q(ntryL,G0H64(1),wf8(:,60),G0H8(1),m3h8x8(:,10),heltab2x64(:,:,194))
  call Hloop_A_Q(ntryL,G0H8(1),35,0,G1H8(8),n2h8(46))
  Gcoeff(:)%j = (-(c(2)*M(2,:)%j)+c(1)*M(4,:)%j) * den(57)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(195),h0tab(:,195),[35,4,16,8],[0,0,0,0],4,1,wf8(:,60))
  call Hloop_QA_V(ntryL,G0H64(1),wf8(:,60),G0H8(1),m3h8x8(:,11),heltab2x64(:,:,195))
  Gcoeff(:)%j = (-(c(2)*M(2,:)%j)+c(1)*M(4,:)%j) * den(57)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(196),h0tab(:,196),[35,4,16,8],[0,0,0,0],4,1,wf8(:,60))
  call Hloop_QA_V(ntryL,G0H64(1),wf8(:,60),G0H8(2),m3h8x8(:,12),heltab2x64(:,:,196))
  Gcoeff(:)%j = (-(c(5)*M(2,:)%j)+c(4)*M(4,:)%j) * den(57)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(197),h0tab(:,197),[35,4,16,8],[nMZ,0,0,0],4,1,wf8(:,60))
  call Hloop_QA_Z(ntryL,G0H64(1),wf8(:,60),G0H8(3),ngZd,m3h8x8(:,13),heltab2x64(:,:,197))
  Gcoeff(:)%j = (-(c(5)*M(2,:)%j)+c(4)*M(4,:)%j) * den(57)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(198),h0tab(:,198),[35,4,16,8],[0,0,nMZ,0],4,1,wf8(:,60))
  call Hloop_QA_V(ntryL,G0H64(1),wf8(:,60),G0H8(4),m3h8x8(:,14),heltab2x64(:,:,198))
  Gcoeff(:)%j = (-(c(17)*M(1,:)%j)-c(11)*M(3,:)%j) * den(57)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(199),h0tab(:,199),[35,4,16,8],[0,0,0,0],4,1,wf8(:,60))
  call Hloop_QA_V(ntryL,G0H64(1),wf8(:,60),G0H8(5),m3h8x8(:,15),heltab2x64(:,:,199))
  Gcoeff(:)%j = (-(c(1)*M(2,:)%j)+c(2)*M(4,:)%j) * den(57)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(200),h0tab(:,200),[35,4,16,8],[0,0,0,0],4,1,wf8(:,60))
  call Hloop_VA_Q(ntryL,G0H64(1),wf8(:,60),G0H8(6),m3h8x8(:,16),heltab2x64(:,:,200))
  call Hloop_A_Q(ntryL,G0H8(6),35,0,G1H8(13),n2h8(47))
  Gcoeff(:)%j = (-(c(1)*M(2,:)%j)+c(2)*M(4,:)%j) * den(57)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(201),h0tab(:,201),[35,4,16,8],[0,0,0,0],4,1,wf8(:,60))
  call Hloop_VA_Q(ntryL,G0H64(1),wf8(:,60),G0H8(6),m3h8x8(:,17),heltab2x64(:,:,201))
  call Hloop_A_Q(ntryL,G0H8(6),35,0,G1H8(14),n2h8(48))
  Gcoeff(:)%j = (-(c(4)*M(2,:)%j)+c(5)*M(4,:)%j) * den(57)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(202),h0tab(:,202),[35,4,16,8],[0,nMZ,0,0],4,1,wf8(:,60))
  call Hloop_VA_Q(ntryL,G0H64(1),wf8(:,60),G0H8(6),m3h8x8(:,18),heltab2x64(:,:,202))
  call Hloop_A_Q(ntryL,G0H8(6),35,0,G1H8(17),n2h8(49))
  Gcoeff(:)%j = (-(c(4)*M(2,:)%j)+c(5)*M(4,:)%j) * den(57)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(203),h0tab(:,203),[35,4,16,8],[0,0,0,nMZ],4,1,wf8(:,60))
  call Hloop_ZA_Q(ntryL,G0H64(1),wf8(:,60),G0H8(6),ngZd,m3h8x8(:,19),heltab2x64(:,:,203))
  call Hloop_A_Q(ntryL,G0H8(6),35,0,G1H8(18),n2h8(50))
  Gcoeff(:)%j = (c(11)*M(1,:)%j+c(17)*M(3,:)%j) * den(57)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(204),h0tab(:,204),[35,4,16,8],[0,0,0,0],4,1,wf8(:,60))
  call Hloop_VA_Q(ntryL,G0H64(1),wf8(:,60),G0H8(6),m3h8x8(:,20),heltab2x64(:,:,204))
  call Hloop_A_Q(ntryL,G0H8(6),35,0,G1H8(19),n2h8(51))
  Gcoeff(:)%j = (-(c(5)*M(2,:)%j)+c(4)*M(4,:)%j) * den(9)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(205),h0tab(:,205),[32,1,2,28],[nMZ,0,nMZ,0],4,1,wf8(:,7))
  call Hloop_QA_Z(ntryL,G0H64(1),ex6(:),G0H32(30),ngZd,m3h2x32(:,151),heltab2x64(:,:,205))
  Gcoeff(:)%j = (-(c(5)*M(2,:)%j)+c(4)*M(4,:)%j) * den(9)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(206),h0tab(:,206),[32,2,1,28],[nMZ,0,nMZ,0],4,1,wf8(:,7))
  call Hloop_QA_Z(ntryL,G0H64(1),ex6(:),G0H32(31),ngZd,m3h2x32(:,152),heltab2x64(:,:,206))
  Gcoeff(:)%j = (-(c(21)*M(2,:)%j)+c(20)*M(4,:)%j) * den(9)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(207),h0tab(:,207),[32,2,1,28],[nMW,0,nMW,0],4,1,wf8(:,7))
  call Hloop_QA_W(ntryL,G0H64(1),ex6(:),G0H32(32),m3h2x32(:,153),heltab2x64(:,:,207))
  Gcoeff(:)%j = (-(c(5)*M(2,:)%j)+c(4)*M(4,:)%j) * den(61)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(208),h0tab(:,208),[52,2,1,8],[nMZ,0,nMZ,0],4,1,wf8(:,64))
  call Hloop_QA_Z(ntryL,G0H64(1),wf8(:,64),G0H8(6),ngZd,m3h8x8(:,21),heltab2x64(:,:,208))
  Gcoeff(:)%j = (-(c(21)*M(2,:)%j)+c(20)*M(4,:)%j) * den(61)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(209),h0tab(:,209),[52,2,1,8],[nMW,0,nMW,0],4,1,wf8(:,64))
  call Hloop_QA_W(ntryL,G0H64(1),wf8(:,64),G0H8(7),m3h8x8(:,22),heltab2x64(:,:,209))
  Gcoeff(:)%j = (-(c(5)*M(2,:)%j)+c(4)*M(4,:)%j) * den(61)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(210),h0tab(:,210),[52,1,2,8],[nMZ,0,nMZ,0],4,1,wf8(:,64))
  call Hloop_QA_Z(ntryL,G0H64(1),wf8(:,64),G0H8(8),ngZd,m3h8x8(:,23),heltab2x64(:,:,210))
  Gcoeff(:)%j = (-(c(4)*M(2,:)%j)+c(5)*M(4,:)%j) * den(19)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(211),h0tab(:,211),[32,1,2,28],[nMZ,0,nMZ,0],4,1,wf8(:,15))
  call Hloop_QA_Z(ntryL,G0H64(1),ex6(:),G0H32(33),ngZd,m3h2x32(:,154),heltab2x64(:,:,211))
  Gcoeff(:)%j = (-(c(4)*M(2,:)%j)+c(5)*M(4,:)%j) * den(19)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(212),h0tab(:,212),[32,2,1,28],[nMZ,0,nMZ,0],4,1,wf8(:,15))
  call Hloop_QA_Z(ntryL,G0H64(1),ex6(:),G0H32(34),ngZd,m3h2x32(:,155),heltab2x64(:,:,212))
  Gcoeff(:)%j = (-(c(20)*M(2,:)%j)+c(21)*M(4,:)%j) * den(19)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(213),h0tab(:,213),[32,2,1,28],[nMW,0,nMW,0],4,1,wf8(:,15))
  call Hloop_QA_W(ntryL,G0H64(1),ex6(:),G0H32(35),m3h2x32(:,156),heltab2x64(:,:,213))
  Gcoeff(:)%j = (-(c(4)*M(2,:)%j)+c(5)*M(4,:)%j) * den(76)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(214),h0tab(:,214),[56,2,1,4],[nMZ,0,nMZ,0],4,1,wf8(:,95))
  call Hloop_QA_Z(ntryL,G0H64(1),wf8(:,95),G0H8(9),ngZd,m3h8x8(:,24),heltab2x64(:,:,214))
  Gcoeff(:)%j = (-(c(20)*M(2,:)%j)+c(21)*M(4,:)%j) * den(76)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(215),h0tab(:,215),[56,2,1,4],[nMW,0,nMW,0],4,1,wf8(:,95))
  call Hloop_QA_W(ntryL,G0H64(1),wf8(:,95),G0H8(10),m3h8x8(:,25),heltab2x64(:,:,215))
  Gcoeff(:)%j = (-(c(4)*M(2,:)%j)+c(5)*M(4,:)%j) * den(76)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(216),h0tab(:,216),[56,1,2,4],[nMZ,0,nMZ,0],4,1,wf8(:,95))
  call Hloop_QA_Z(ntryL,G0H64(1),wf8(:,95),G0H8(11),ngZd,m3h8x8(:,26),heltab2x64(:,:,216))
  Gcoeff(:)%j = (-(c(4)*M(2,:)%j)+c(5)*M(4,:)%j) * den(28)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(217),h0tab(:,217),[44,2,1,16],[nMZ,0,nMZ,0],4,1,wf8(:,22))
  call Hloop_AQ_Z(ntryL,G0H64(1),wf8(:,22),G0H8(12),ngZd,m3h8x8(:,27),heltab2x64(:,:,217))
  Gcoeff(:)%j = (-(c(4)*M(2,:)%j)+c(5)*M(4,:)%j) * den(28)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(218),h0tab(:,218),[44,1,2,16],[nMZ,0,nMZ,0],4,1,wf8(:,22))
  call Hloop_AQ_Z(ntryL,G0H64(1),wf8(:,22),G0H8(13),ngZd,m3h8x8(:,28),heltab2x64(:,:,218))
  Gcoeff(:)%j = (-(c(20)*M(2,:)%j)+c(21)*M(4,:)%j) * den(28)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(219),h0tab(:,219),[44,1,2,16],[nMW,0,nMW,0],4,1,wf8(:,22))
  call Hloop_AQ_W(ntryL,G0H64(1),wf8(:,22),G0H8(14),m3h8x8(:,29),heltab2x64(:,:,219))
  Gcoeff(:)%j = (-(c(4)*M(2,:)%j)+c(5)*M(4,:)%j) * den(69)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(220),h0tab(:,220),[52,2,1,8],[nMZ,0,nMZ,0],4,1,wf8(:,71))
  call Hloop_QA_Z(ntryL,G0H64(1),wf8(:,71),G0H8(15),ngZd,m3h8x8(:,30),heltab2x64(:,:,220))
  Gcoeff(:)%j = (-(c(20)*M(2,:)%j)+c(21)*M(4,:)%j) * den(69)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(221),h0tab(:,221),[52,2,1,8],[nMW,0,nMW,0],4,1,wf8(:,71))
  call Hloop_QA_W(ntryL,G0H64(1),wf8(:,71),G0H8(16),m3h8x8(:,31),heltab2x64(:,:,221))
  Gcoeff(:)%j = (-(c(4)*M(2,:)%j)+c(5)*M(4,:)%j) * den(69)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(222),h0tab(:,222),[52,1,2,8],[nMZ,0,nMZ,0],4,1,wf8(:,71))
  call Hloop_QA_Z(ntryL,G0H64(1),wf8(:,71),G0H8(17),ngZd,m3h8x8(:,32),heltab2x64(:,:,222))
  Gcoeff(:)%j = (-(c(5)*M(2,:)%j)+c(4)*M(4,:)%j) * den(36)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(223),h0tab(:,223),[44,2,1,16],[nMZ,0,nMZ,0],4,1,wf8(:,28))
  call Hloop_AQ_Z(ntryL,G0H64(1),wf8(:,28),G0H8(18),ngZd,m3h8x8(:,33),heltab2x64(:,:,223))
  Gcoeff(:)%j = (-(c(5)*M(2,:)%j)+c(4)*M(4,:)%j) * den(36)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(224),h0tab(:,224),[44,1,2,16],[nMZ,0,nMZ,0],4,1,wf8(:,28))
  call Hloop_AQ_Z(ntryL,G0H64(1),wf8(:,28),G0H8(19),ngZd,m3h8x8(:,34),heltab2x64(:,:,224))
  Gcoeff(:)%j = (-(c(21)*M(2,:)%j)+c(20)*M(4,:)%j) * den(36)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(225),h0tab(:,225),[44,1,2,16],[nMW,0,nMW,0],4,1,wf8(:,28))
  call Hloop_AQ_W(ntryL,G0H64(1),wf8(:,28),G0H8(20),m3h8x8(:,35),heltab2x64(:,:,225))
  Gcoeff(:)%j = (-(c(5)*M(2,:)%j)+c(4)*M(4,:)%j) * den(82)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(226),h0tab(:,226),[56,2,1,4],[nMZ,0,nMZ,0],4,1,wf8(:,101))
  call Hloop_QA_Z(ntryL,G0H64(1),wf8(:,101),G0H8(21),ngZd,m3h8x8(:,36),heltab2x64(:,:,226))
  Gcoeff(:)%j = (-(c(21)*M(2,:)%j)+c(20)*M(4,:)%j) * den(82)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(227),h0tab(:,227),[56,2,1,4],[nMW,0,nMW,0],4,1,wf8(:,101))
  call Hloop_QA_W(ntryL,G0H64(1),wf8(:,101),G0H8(22),m3h8x8(:,37),heltab2x64(:,:,227))
  Gcoeff(:)%j = (-(c(5)*M(2,:)%j)+c(4)*M(4,:)%j) * den(82)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(228),h0tab(:,228),[56,1,2,4],[nMZ,0,nMZ,0],4,1,wf8(:,101))
  call Hloop_QA_Z(ntryL,G0H64(1),wf8(:,101),G0H8(23),ngZd,m3h8x8(:,38),heltab2x64(:,:,228))
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G0H32(1),[G0H32(10),G0H32(7)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H32(11),[G1H32(7),G1H32(2)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G0H32(13),[G0H32(2),G0H32(5)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H32(32),[G1H32(21),G1H32(16)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H16(6),[G1H16(3),G1H16(2),G1H16(1)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H16(12),[G1H16(9),G1H16(8),G1H16(7)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H16(20),[G1H16(17),G1H16(16),G1H16(15)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H16(26),[G1H16(23),G1H16(22),G1H16(21)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H32(8),[G1H32(3),G1H32(5)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G0H32(19),[G0H32(16),G0H32(15)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H32(20),[G1H32(15),G1H32(9)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H32(24),[G1H32(19),G1H32(18)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G0H32(24),[G0H32(21),G0H32(20)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H32(33),[G1H32(28),G1H32(30)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H32(39),[G1H32(36),G1H32(34)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H32(44),[G1H32(41),G1H32(40)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H32(49),[G1H32(46),G1H32(45)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H32(54),[G1H32(51),G1H32(50)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H32(59),[G1H32(56),G1H32(55)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G0H32(29),[G0H32(26),G0H32(25)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H8(11),[G1H8(1),G1H8(10)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H8(8),[G1H8(3),G1H8(12)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G0H8(5),[G0H8(2),G0H8(1)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H8(19),[G1H8(14),G1H8(13)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G0H8(15),[G0H8(6)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G0H8(16),[G0H8(7)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G0H8(17),[G0H8(8)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G0H8(21),[G0H8(9)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G0H8(22),[G0H8(10)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G0H8(23),[G0H8(11)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G0H8(18),[G0H8(12)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G0H8(19),[G0H8(13)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G0H8(20),[G0H8(14)])
  call Hloop_VQ_A(ntryL,G0H32(1),ex4(:),G0H16(1),m3h2x16(:,35),heltab2x32(:,:,47))
  call Hloop_Q_A(ntryL,G0H16(1),40,0,G1H16(3),n2h16(52))
  call Hloop_VQ_A(ntryL,G0H32(6),ex4(:),G0H16(1),m3h2x16(:,36),heltab2x32(:,:,48))
  call Hloop_Q_A(ntryL,G0H16(1),40,0,G1H16(2),n2h16(53))
  call Hloop_ZQ_A(ntryL,G0H32(8),ex4(:),G0H16(1),ngZd,m3h2x16(:,37),heltab2x32(:,:,49))
  call Hloop_Q_A(ntryL,G0H16(1),40,0,G1H16(1),n2h16(54))
  call Hloop_WQ_A(ntryL,G0H32(9),ex4(:),G0H16(1),m3h2x16(:,38),heltab2x32(:,:,50))
  call Hloop_Q_A(ntryL,G0H16(1),40,0,G1H16(9),n2h16(55))
  call Hloop_AZ_Q(ntryL,G1H32(11),wf4(:,1),G1H8(20),ngZd,m3h4x8(:,13),heltab2x32(:,:,51))
  call Hloop_A_Q(ntryL,G1H8(20),35,0,G2H8(10),n2h8(52))
  call Hloop_AZ_Q(ntryL,G1H32(1),wf4(:,1),G1H8(23),ngZd,m3h4x8(:,14),heltab2x32(:,:,52))
  call Hloop_A_Q(ntryL,G1H8(23),35,0,G2H8(11),n2h8(53))
  call Hloop_AZ_Q(ntryL,G1H32(6),wf4(:,1),G1H8(24),ngZd,m3h4x8(:,15),heltab2x32(:,:,53))
  call Hloop_A_Q(ntryL,G1H8(24),35,0,G2H8(12),n2h8(54))
  call Hloop_AZ_Q(ntryL,G1H32(12),wf4(:,1),G1H8(25),ngZu,m3h4x8(:,16),heltab2x32(:,:,54))
  call Hloop_A_Q(ntryL,G1H8(25),35,0,G2H8(1),n2h8(55))
  call Hloop_AZ_Q(ntryL,G1H32(17),wf4(:,1),G1H8(26),ngZd,m3h4x8(:,17),heltab2x32(:,:,55))
  call Hloop_A_Q(ntryL,G1H8(26),35,0,G2H8(2),n2h8(56))
  call Hloop_UW_V(ntryL,G0H32(4),32,wf4(:,1),3,G1H8(29),m3h4x8(:,18),heltab2x32(:,:,56))
  call Hloop_VQ_A(ntryL,G0H32(13),ex3(:),G0H16(1),m3h2x16(:,39),heltab2x32(:,:,57))
  call Hloop_Q_A(ntryL,G0H16(1),36,0,G1H16(8),n2h16(56))
  call Hloop_VQ_A(ntryL,G0H32(11),ex3(:),G0H16(1),m3h2x16(:,40),heltab2x32(:,:,58))
  call Hloop_Q_A(ntryL,G0H16(1),36,0,G1H16(7),n2h16(57))
  call Hloop_ZQ_A(ntryL,G0H32(3),ex3(:),G0H16(1),ngZd,m3h2x16(:,41),heltab2x32(:,:,59))
  call Hloop_Q_A(ntryL,G0H16(1),36,0,G1H16(17),n2h16(58))
  call Hloop_WQ_A(ntryL,G0H32(12),ex3(:),G0H16(1),m3h2x16(:,42),heltab2x32(:,:,60))
  call Hloop_Q_A(ntryL,G0H16(1),36,0,G1H16(16),n2h16(59))
  call Hloop_AZ_Q(ntryL,G1H32(32),wf4(:,1),G1H8(30),ngZd,m3h4x8(:,19),heltab2x32(:,:,61))
  call Hloop_A_Q(ntryL,G1H8(30),35,0,G2H8(3),n2h8(57))
  call Hloop_AZ_Q(ntryL,G1H32(22),wf4(:,1),G1H8(31),ngZd,m3h4x8(:,20),heltab2x32(:,:,62))
  call Hloop_A_Q(ntryL,G1H8(31),35,0,G2H8(4),n2h8(58))
  call Hloop_AZ_Q(ntryL,G1H32(27),wf4(:,1),G1H8(32),ngZd,m3h4x8(:,21),heltab2x32(:,:,63))
  call Hloop_A_Q(ntryL,G1H8(32),35,0,G2H8(5),n2h8(59))
  call Hloop_AZ_Q(ntryL,G1H32(26),wf4(:,1),G1H8(35),ngZu,m3h4x8(:,22),heltab2x32(:,:,64))
  call Hloop_A_Q(ntryL,G1H8(35),35,0,G2H8(6),n2h8(60))
  call Hloop_AZ_Q(ntryL,G1H32(31),wf4(:,1),G1H8(36),ngZd,m3h4x8(:,23),heltab2x32(:,:,65))
  call Hloop_A_Q(ntryL,G1H8(36),35,0,G2H8(7),n2h8(61))
  call Hloop_UW_V(ntryL,G0H32(14),32,wf4(:,1),3,G1H8(37),m3h4x8(:,24),heltab2x32(:,:,66))
  call Hloop_AZ_Q(ntryL,G1H16(6),wf4(:,1),G1H4(67),ngZd,m3h4x4(:,4),heltab2x16(:,:,41))
  call Hloop_A_Q(ntryL,G1H4(67),39,0,G2H4(7),n2h4(44))
  call Hloop_AZ_Q(ntryL,G1H16(4),wf4(:,1),G1H4(68),ngZd,m3h4x4(:,5),heltab2x16(:,:,42))
  call Hloop_A_Q(ntryL,G1H4(68),39,0,G2H4(8),n2h4(45))
  call Hloop_AZ_Q(ntryL,G1H16(5),wf4(:,1),G1H4(71),ngZu,m3h4x4(:,6),heltab2x16(:,:,43))
  call Hloop_A_Q(ntryL,G1H4(71),39,0,G2H4(9),n2h4(46))
  call Hloop_QZ_A(ntryL,G1H16(12),wf4(:,1),G1H4(72),ngZd,m3h4x4(:,7),heltab2x16(:,:,44))
  call Hloop_Q_A(ntryL,G1H4(72),39,0,G2H4(10),n2h4(47))
  call Hloop_QZ_A(ntryL,G1H16(10),wf4(:,1),G1H4(7),ngZd,m3h4x4(:,8),heltab2x16(:,:,45))
  call Hloop_Q_A(ntryL,G1H4(7),39,0,G2H4(11),n2h4(48))
  call Hloop_QZ_A(ntryL,G1H16(11),wf4(:,1),G1H4(8),ngZu,m3h4x4(:,9),heltab2x16(:,:,46))
  call Hloop_Q_A(ntryL,G1H4(8),39,0,G2H4(12),n2h4(49))
  call Hloop_VQ_A(ntryL,G1H16(13),ex4(:),G1H8(38),m3h2x8(:,38),heltab2x16(:,:,47))
  call Hloop_Q_A(ntryL,G1H8(38),44,0,G2H8(8),n2h8(62))
  call Hloop_AQ_W(ntryL,G1H16(14),ex4(:),G1H8(41),m3h2x8(:,39),heltab2x16(:,:,48))
  call Hloop_AZ_Q(ntryL,G1H16(20),wf4(:,1),G1H4(11),ngZd,m3h4x4(:,10),heltab2x16(:,:,49))
  call Hloop_A_Q(ntryL,G1H4(11),43,0,G2H4(13),n2h4(50))
  call Hloop_AZ_Q(ntryL,G1H16(18),wf4(:,1),G1H4(4),ngZd,m3h4x4(:,11),heltab2x16(:,:,50))
  call Hloop_A_Q(ntryL,G1H4(4),43,0,G2H4(14),n2h4(51))
  call Hloop_AZ_Q(ntryL,G1H16(19),wf4(:,1),G1H4(23),ngZu,m3h4x4(:,12),heltab2x16(:,:,51))
  call Hloop_A_Q(ntryL,G1H4(23),43,0,G2H4(15),n2h4(52))
  call Hloop_QZ_A(ntryL,G1H16(26),wf4(:,1),G1H4(35),ngZd,m3h4x4(:,13),heltab2x16(:,:,52))
  call Hloop_Q_A(ntryL,G1H4(35),43,0,G2H4(16),n2h4(53))
  call Hloop_QZ_A(ntryL,G1H16(24),wf4(:,1),G1H4(21),ngZd,m3h4x4(:,14),heltab2x16(:,:,53))
  call Hloop_Q_A(ntryL,G1H4(21),43,0,G2H4(17),n2h4(54))
  call Hloop_QZ_A(ntryL,G1H16(25),wf4(:,1),G1H4(22),ngZu,m3h4x4(:,15),heltab2x16(:,:,54))
  call Hloop_Q_A(ntryL,G1H4(22),43,0,G2H4(18),n2h4(55))
  call Hloop_VQ_A(ntryL,G1H16(27),ex3(:),G1H8(42),m3h2x8(:,40),heltab2x16(:,:,55))
  call Hloop_Q_A(ntryL,G1H8(42),44,0,G2H8(9),n2h8(63))
  call Hloop_AQ_W(ntryL,G1H16(28),ex3(:),G1H8(43),m3h2x8(:,41),heltab2x16(:,:,56))
  call Hloop_AQ_V(ntryL,G1H32(8),wf8(:,12),G1H4(38),m3h8x4(:,1),heltab2x32(:,:,67))
  call Hloop_AQ_V(ntryL,G1H32(4),wf8(:,12),G1H4(41),m3h8x4(:,2),heltab2x32(:,:,68))
  call Hloop_AQ_Z(ntryL,G1H32(10),wf8(:,12),G1H4(42),ngZd,m3h8x4(:,3),heltab2x32(:,:,69))
  call Hloop_VQ_A(ntryL,G0H32(19),wf8(:,12),G0H4(1),m3h8x4(:,4),heltab2x32(:,:,70))
  call Hloop_Q_A(ntryL,G0H4(1),39,0,G1H4(48),n2h4(56))
  call Hloop_VQ_A(ntryL,G0H32(17),wf8(:,12),G0H4(1),m3h8x4(:,5),heltab2x32(:,:,71))
  call Hloop_Q_A(ntryL,G0H4(1),39,0,G1H4(49),n2h4(57))
  call Hloop_ZQ_A(ntryL,G0H32(18),wf8(:,12),G0H4(1),ngZd,m3h8x4(:,6),heltab2x32(:,:,72))
  call Hloop_Q_A(ntryL,G0H4(1),39,0,G1H4(50),n2h4(58))
  call Hloop_AQ_V(ntryL,G1H32(20),wf8(:,12),G1H4(56),m3h8x4(:,7),heltab2x32(:,:,73))
  call Hloop_AQ_Z(ntryL,G1H32(13),wf8(:,12),G1H4(59),ngZd,m3h8x4(:,8),heltab2x32(:,:,74))
  call Hloop_AQ_V(ntryL,G1H32(14),wf8(:,12),G1H4(60),m3h8x4(:,9),heltab2x32(:,:,75))
  call Hloop_AQ_V(ntryL,G1H32(24),ex4(:),G1H16(15),m3h2x16(:,43),heltab2x32(:,:,76))
  call Hloop_AQ_Z(ntryL,G1H32(25),ex4(:),G1H16(23),ngZd,m3h2x16(:,44),heltab2x32(:,:,77))
  call Hloop_AQ_V(ntryL,G1H32(23),ex4(:),G1H16(22),m3h2x16(:,45),heltab2x32(:,:,78))
  call Hloop_VQ_A(ntryL,G0H32(24),ex3(:),G0H16(1),m3h2x16(:,46),heltab2x32(:,:,79))
  call Hloop_Q_A(ntryL,G0H16(1),36,0,G1H16(21),n2h16(60))
  call Hloop_ZQ_A(ntryL,G0H32(22),ex3(:),G0H16(1),ngZd,m3h2x16(:,47),heltab2x32(:,:,80))
  call Hloop_Q_A(ntryL,G0H16(1),36,0,G1H16(6),n2h16(61))
  call Hloop_VQ_A(ntryL,G0H32(23),ex3(:),G0H16(1),m3h2x16(:,48),heltab2x32(:,:,81))



end subroutine vamp_1

end module ol_vamp_1_ppnnjj_ew_nenexdddxdx_1_/**/REALKIND
