
module ol_vamp_1_ppnnjj_ew_nenexbbxaa_2_/**/REALKIND
contains

! **********************************************************************
subroutine vamp_1(M)
! P(0:3,nlegs) = incoming external momenta
! Uses tree structures 'wf', factors 'c', and denominators 'den' from loop_ppnnjj_ew_nenexbbxaa_2.
! Sets colour stripped amplitudes A from the module loop_amplitudes_ppnnjj_ew_nenexbbxaa_2.
! **********************************************************************
  use KIND_TYPES, only: REALKIND, QREALKIND, intkind2
  use ol_parameters_decl_/**/DREALKIND, only: l_switch
  use ol_parameters_decl_/**/QREALKIND ! masses
  use ol_vert_interface_/**/REALKIND
  use ol_prop_interface_/**/REALKIND
  use ol_last_step_/**/REALKIND
  use ol_tables_storage_ppnnjj_ew_nenexbbxaa_2_/**/DREALKIND
  use ol_tensor_sum_storage_ppnnjj_ew_nenexbbxaa_2_/**/REALKIND
  use ol_loop_handling_/**/REALKIND
  use ofred_reduction_/**/REALKIND, only: Hotf_4pt_reduction, Hotf_4pt_reduction_last
  use ofred_reduction_/**/REALKIND, only: Hotf_5pt_reduction, Hotf_5pt_reduction_last
  use ol_loop_reduction_/**/REALKIND, only: TI_bubble_red, TI_triangle_red
use ol_loop_reduction_/**/REALKIND, only: compute_scalar_box

  use ol_loop_storage_ppnnjj_ew_nenexbbxaa_2_/**/REALKIND
#ifndef PRECISION_dp
  use ol_loop_storage_ppnnjj_ew_nenexbbxaa_2_/**/DREALKIND, only: &
    & ntryL, p_switch, Hel, merge_step, merge_mism, merge_tables, merge_hels
#endif
  use hol_initialisation_/**/REALKIND, only: G0_hol_initialisation
  use ol_h_vert_interface_/**/REALKIND
  use ol_h_prop_interface_/**/REALKIND
  use ol_h_last_step_/**/REALKIND
  use ol_merging_/**/REALKIND, only: ol_merge, ol_merge_tensors, ol_merge_last

  implicit none

  type(Hpolcont) :: Gcoeff(64)
  type(Hpolcont), intent(in) :: M(1,64)


#ifndef PRECISION_dp
  if (ntryL==1 .OR. p_switch == 1) Gcoeff(:)%hf = Hel
#else
  if (ntryL==1 .OR. p_switch == 2) Gcoeff(:)%hf = Hel
#endif

  ! =============================================


! Dressing, otf merging and otf reduction calls to build loop structures

  Gcoeff(:)%j = (c(2)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(1),h0tab(:,1),[32,8,2,1,4,16],[nMB,nMZ,0,nMZ,nMB,nMB],6,0)
  call Hloop_QV_A(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,1),heltab2x64(:,:,1))
  call Hloop_Q_A(ntryL,G0H32(1),32,nMB,G1H32(1),n2h32(1))
  Gcoeff(:)%j = (c(10)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(2),h0tab(:,2),[32,8,2,1,4,16],[nMT,nMW,0,nMW,nMT,nMT],6,0)
  call Hloop_QV_A(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,2),heltab2x64(:,:,2))
  call Hloop_Q_A(ntryL,G0H32(1),32,nMT,G1H32(2),n2h32(2))
  Gcoeff(:)%j = (c(2)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(3),h0tab(:,3),[32,4,1,2,8,16],[nMB,nMZ,0,nMZ,nMB,nMB],6,0)
  call Hloop_AV_Q(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,3),heltab2x64(:,:,3))
  call Hloop_A_Q(ntryL,G0H32(1),32,nMB,G1H32(3),n2h32(3))
  Gcoeff(:)%j = (c(10)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(4),h0tab(:,4),[32,4,1,2,8,16],[nMT,nMW,0,nMW,nMT,nMT],6,0)
  call Hloop_AV_Q(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,4),heltab2x64(:,:,4))
  call Hloop_A_Q(ntryL,G0H32(1),32,nMT,G1H32(4),n2h32(4))
  Gcoeff(:)%j = (-(c(12)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(5),h0tab(:,5),[32,8,4,1,2,16],[nMW,nMT,nMW,0,nMW,nMW],6,0)
  call Hloop_TV_S(ntryL,G0H64(1),0,ex6(:),32,G1H32(5),m3h2x32(:,5),heltab2x64(:,:,5))
  Gcoeff(:)%j = (-(c(12)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(6),h0tab(:,6),[32,8,4,1,2,16],[nMW,nMT,nMW,0,nMW,nMW],6,0)
  call Hloop_VV_S(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,6),heltab2x64(:,:,6))
  Gcoeff(:)%j = (-(c(19)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(7),h0tab(:,7),[32,8,4,1,2,16],[nMW,nMT,nMW,0,nMW,nMW],6,0)
  call Hloop_SV_V(ntryL,G0H64(1),ex6(:),G0H32(2),m3h2x32(:,7),heltab2x64(:,:,7))
  Gcoeff(:)%j = (c(12)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(8),h0tab(:,8),[32,8,4,1,2,16],[nMW,nMT,nMW,0,nMW,nMW],6,0)
  call Hloop_UV_W(ntryL,G0H64(1),0,ex6(:),32,G1H32(6),m3h2x32(:,8),heltab2x64(:,:,8))
  Gcoeff(:)%j = (-(c(11)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(9),h0tab(:,9),[32,4,1,2,16,8],[nMT,nMW,0,nMW,nMW,nMT],6,0)
  call Hloop_AV_Q(ntryL,G0H64(1),ex6(:),G0H32(3),m3h2x32(:,9),heltab2x64(:,:,9))
  call Hloop_A_Q(ntryL,G0H32(3),32,nMT,G1H32(7),n2h32(5))
  Gcoeff(:)%j = (c(11)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(10),h0tab(:,10),[32,4,1,2,16,8],[nMT,nMW,0,nMW,nMW,nMT],6,0)
  call Hloop_AV_Q(ntryL,G0H64(1),ex6(:),G0H32(3),m3h2x32(:,10),heltab2x64(:,:,10))
  call Hloop_A_Q(ntryL,G0H32(3),32,nMT,G1H32(8),n2h32(6))
  Gcoeff(:)%j = (-(c(12)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(11),h0tab(:,11),[32,2,1,4,8,16],[nMW,0,nMW,nMT,nMW,nMW],6,0)
  call Hloop_SV_V(ntryL,G0H64(1),ex6(:),G0H32(3),m3h2x32(:,11),heltab2x64(:,:,11))
  Gcoeff(:)%j = (-(c(12)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(12),h0tab(:,12),[32,2,1,4,8,16],[nMW,0,nMW,nMT,nMW,nMW],6,0)
  call Hloop_UW_V(ntryL,G0H64(1),0,ex6(:),32,G1H32(9),m3h2x32(:,12),heltab2x64(:,:,12))
  Gcoeff(:)%j = (-(c(19)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(13),h0tab(:,13),[32,2,1,4,8,16],[nMW,0,nMW,nMT,nMW,nMW],6,0)
  call Hloop_SV_V(ntryL,G0H64(1),ex6(:),G0H32(4),m3h2x32(:,13),heltab2x64(:,:,13))
  Gcoeff(:)%j = (c(12)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(14),h0tab(:,14),[32,2,1,4,8,16],[nMW,0,nMW,nMT,nMW,nMW],6,0)
  call Hloop_UW_V(ntryL,G0H64(1),0,ex6(:),32,G1H32(10),m3h2x32(:,14),heltab2x64(:,:,14))
  Gcoeff(:)%j = (-(c(11)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(15),h0tab(:,15),[32,2,1,4,16,8],[nMW,0,nMW,nMT,nMT,nMW],6,0)
  call Hloop_SV_V(ntryL,G0H64(1),ex6(:),G0H32(5),m3h2x32(:,15),heltab2x64(:,:,15))
  Gcoeff(:)%j = (c(11)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(16),h0tab(:,16),[32,2,1,4,16,8],[nMW,0,nMW,nMT,nMT,nMW],6,0)
  call Hloop_UW_V(ntryL,G0H64(1),0,ex6(:),32,G1H32(11),m3h2x32(:,16),heltab2x64(:,:,16))
  Gcoeff(:)%j = (c(2)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(17),h0tab(:,17),[32,8,1,2,4,16],[nMB,nMZ,0,nMZ,nMB,nMB],6,0)
  call Hloop_QV_A(ntryL,G0H64(1),ex6(:),G0H32(6),m3h2x32(:,17),heltab2x64(:,:,17))
  call Hloop_Q_A(ntryL,G0H32(6),32,nMB,G1H32(12),n2h32(7))
  Gcoeff(:)%j = (c(2)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(18),h0tab(:,18),[32,4,2,1,8,16],[nMB,nMZ,0,nMZ,nMB,nMB],6,0)
  call Hloop_AV_Q(ntryL,G0H64(1),ex6(:),G0H32(6),m3h2x32(:,18),heltab2x64(:,:,18))
  call Hloop_A_Q(ntryL,G0H32(6),32,nMB,G1H32(13),n2h32(8))
  Gcoeff(:)%j = (c(12)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(19),h0tab(:,19),[32,4,8,2,1,16],[nMW,nMT,nMW,0,nMW,nMW],6,0)
  call Hloop_SV_T(ntryL,G0H64(1),0,ex6(:),32,G1H32(14),m3h2x32(:,19),heltab2x64(:,:,19))
  Gcoeff(:)%j = (c(12)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(20),h0tab(:,20),[32,4,8,2,1,16],[nMW,nMT,nMW,0,nMW,nMW],6,0)
  call Hloop_VV_S(ntryL,G0H64(1),ex6(:),G0H32(6),m3h2x32(:,20),heltab2x64(:,:,20))
  Gcoeff(:)%j = (-(c(19)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(21),h0tab(:,21),[32,4,8,2,1,16],[nMW,nMT,nMW,0,nMW,nMW],6,0)
  call Hloop_SV_V(ntryL,G0H64(1),ex6(:),G0H32(7),m3h2x32(:,21),heltab2x64(:,:,21))
  Gcoeff(:)%j = (c(12)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(22),h0tab(:,22),[32,4,8,2,1,16],[nMW,nMT,nMW,0,nMW,nMW],6,0)
  call Hloop_UW_V(ntryL,G0H64(1),0,ex6(:),32,G1H32(15),m3h2x32(:,22),heltab2x64(:,:,22))
  Gcoeff(:)%j = (c(11)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(23),h0tab(:,23),[32,4,16,1,2,8],[nMT,nMW,nMW,0,nMW,nMT],6,0)
  call Hloop_AV_Q(ntryL,G0H64(1),ex6(:),G0H32(8),m3h2x32(:,23),heltab2x64(:,:,23))
  call Hloop_A_Q(ntryL,G0H32(8),32,nMT,G1H32(16),n2h32(9))
  Gcoeff(:)%j = (c(11)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(24),h0tab(:,24),[32,4,16,1,2,8],[nMT,nMW,nMW,0,nMW,nMT],6,0)
  call Hloop_AV_Q(ntryL,G0H64(1),ex6(:),G0H32(8),m3h2x32(:,24),heltab2x64(:,:,24))
  call Hloop_A_Q(ntryL,G0H32(8),32,nMT,G1H32(17),n2h32(10))
  Gcoeff(:)%j = (-(c(12)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(25),h0tab(:,25),[32,2,1,16,4,8],[nMW,0,nMW,nMW,nMT,nMW],6,0)
  call Hloop_SV_V(ntryL,G0H64(1),ex6(:),G0H32(8),m3h2x32(:,25),heltab2x64(:,:,25))
  Gcoeff(:)%j = (c(12)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(26),h0tab(:,26),[32,2,1,16,4,8],[nMW,0,nMW,nMW,nMT,nMW],6,0)
  call Hloop_UW_V(ntryL,G0H64(1),0,ex6(:),32,G1H32(18),m3h2x32(:,26),heltab2x64(:,:,26))
  Gcoeff(:)%j = (-(c(12)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(27),h0tab(:,27),[32,2,1,16,4,8],[nMW,0,nMW,nMW,nMT,nMW],6,0)
  call Hloop_SV_V(ntryL,G0H64(1),ex6(:),G0H32(9),m3h2x32(:,27),heltab2x64(:,:,27))
  Gcoeff(:)%j = (c(12)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(28),h0tab(:,28),[32,2,1,16,4,8],[nMW,0,nMW,nMW,nMT,nMW],6,0)
  call Hloop_UW_V(ntryL,G0H64(1),0,ex6(:),32,G1H32(19),m3h2x32(:,28),heltab2x64(:,:,28))
  Gcoeff(:)%j = (c(12)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(29),h0tab(:,29),[32,1,2,8,4,16],[nMW,0,nMW,nMT,nMW,nMW],6,0)
  call Hloop_SV_V(ntryL,G0H64(1),ex6(:),G0H32(10),m3h2x32(:,29),heltab2x64(:,:,29))
  Gcoeff(:)%j = (c(12)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(30),h0tab(:,30),[32,1,2,8,4,16],[nMW,0,nMW,nMT,nMW,nMW],6,0)
  call Hloop_UV_W(ntryL,G0H64(1),0,ex6(:),32,G1H32(20),m3h2x32(:,30),heltab2x64(:,:,30))
  Gcoeff(:)%j = (-(c(19)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(31),h0tab(:,31),[32,1,2,8,4,16],[nMW,0,nMW,nMT,nMW,nMW],6,0)
  call Hloop_SV_V(ntryL,G0H64(1),ex6(:),G0H32(11),m3h2x32(:,31),heltab2x64(:,:,31))
  Gcoeff(:)%j = (c(12)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(32),h0tab(:,32),[32,1,2,8,4,16],[nMW,0,nMW,nMT,nMW,nMW],6,0)
  call Hloop_UV_W(ntryL,G0H64(1),0,ex6(:),32,G1H32(21),m3h2x32(:,32),heltab2x64(:,:,32))
  Gcoeff(:)%j = (c(11)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(33),h0tab(:,33),[32,1,2,8,16,4],[nMW,0,nMW,nMT,nMT,nMW],6,0)
  call Hloop_SV_V(ntryL,G0H64(1),ex6(:),G0H32(12),m3h2x32(:,33),heltab2x64(:,:,33))
  Gcoeff(:)%j = (c(11)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(34),h0tab(:,34),[32,1,2,8,16,4],[nMW,0,nMW,nMT,nMT,nMW],6,0)
  call Hloop_UV_W(ntryL,G0H64(1),0,ex6(:),32,G1H32(22),m3h2x32(:,34),heltab2x64(:,:,34))
  Gcoeff(:)%j = (-(c(12)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(35),h0tab(:,35),[32,1,2,16,8,4],[nMW,0,nMW,nMW,nMT,nMW],6,0)
  call Hloop_SV_V(ntryL,G0H64(1),ex6(:),G0H32(13),m3h2x32(:,35),heltab2x64(:,:,35))
  Gcoeff(:)%j = (c(12)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(36),h0tab(:,36),[32,1,2,16,8,4],[nMW,0,nMW,nMW,nMT,nMW],6,0)
  call Hloop_SV_V(ntryL,G0H64(1),ex6(:),G0H32(14),m3h2x32(:,36),heltab2x64(:,:,36))
  Gcoeff(:)%j = (-(c(12)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(37),h0tab(:,37),[32,1,2,16,8,4],[nMW,0,nMW,nMW,nMT,nMW],6,0)
  call Hloop_UV_W(ntryL,G0H64(1),0,ex6(:),32,G1H32(23),m3h2x32(:,37),heltab2x64(:,:,37))
  Gcoeff(:)%j = (c(12)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(38),h0tab(:,38),[32,1,2,16,8,4],[nMW,0,nMW,nMW,nMT,nMW],6,0)
  call Hloop_UV_W(ntryL,G0H64(1),0,ex6(:),32,G1H32(24),m3h2x32(:,38),heltab2x64(:,:,38))
  Gcoeff(:)%j = (-(c(11)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(39),h0tab(:,39),[32,4,1,16,2,8],[nMT,nMW,0,0,nMW,nMT],6,0)
  call Hloop_AV_Q(ntryL,G0H64(1),ex6(:),G0H32(15),m3h2x32(:,39),heltab2x64(:,:,39))
  call Hloop_A_Q(ntryL,G0H32(15),32,nMT,G1H32(25),n2h32(11))
  Gcoeff(:)%j = (c(12)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(40),h0tab(:,40),[32,2,8,4,1,16],[0,nMW,nMT,nMW,0,0],6,0)
  call Hloop_QV_A(ntryL,G0H64(1),ex6(:),G0H32(15),m3h2x32(:,40),heltab2x64(:,:,40))
  call Hloop_Q_A(ntryL,G0H32(15),32,0,G1H32(26),n2h32(12))
  Gcoeff(:)%j = (c(12)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(41),h0tab(:,41),[32,2,16,1,4,8],[nMW,0,0,nMW,nMT,nMW],6,0)
  call Hloop_SV_V(ntryL,G0H64(1),ex6(:),G0H32(15),m3h2x32(:,41),heltab2x64(:,:,41))
  Gcoeff(:)%j = (-(c(12)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(42),h0tab(:,42),[32,2,16,1,4,8],[nMW,0,0,nMW,nMT,nMW],6,0)
  call Hloop_UW_V(ntryL,G0H64(1),0,ex6(:),32,G1H32(27),m3h2x32(:,42),heltab2x64(:,:,42))
  Gcoeff(:)%j = (c(12)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(43),h0tab(:,43),[32,1,4,8,2,16],[0,nMW,nMT,nMW,0,0],6,0)
  call Hloop_AV_Q(ntryL,G0H64(1),ex6(:),G0H32(16),m3h2x32(:,43),heltab2x64(:,:,43))
  call Hloop_A_Q(ntryL,G0H32(16),32,0,G1H32(28),n2h32(13))
  Gcoeff(:)%j = (-(c(11)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(44),h0tab(:,44),[32,1,4,16,8,2],[0,nMW,nMT,nMT,nMW,0],6,0)
  call Hloop_AV_Q(ntryL,G0H64(1),ex6(:),G0H32(16),m3h2x32(:,44),heltab2x64(:,:,44))
  call Hloop_A_Q(ntryL,G0H32(16),32,0,G1H32(29),n2h32(14))
  Gcoeff(:)%j = (c(12)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(45),h0tab(:,45),[32,1,4,8,16,2],[0,nMW,nMT,nMW,nMW,0],6,0)
  call Hloop_AV_Q(ntryL,G0H64(1),ex6(:),G0H32(16),m3h2x32(:,45),heltab2x64(:,:,45))
  call Hloop_A_Q(ntryL,G0H32(16),32,0,G1H32(30),n2h32(15))
  Gcoeff(:)%j = (-(c(12)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(46),h0tab(:,46),[32,1,4,8,16,2],[0,nMW,nMT,nMW,nMW,0],6,0)
  call Hloop_AV_Q(ntryL,G0H64(1),ex6(:),G0H32(16),m3h2x32(:,46),heltab2x64(:,:,46))
  call Hloop_A_Q(ntryL,G0H32(16),32,0,G1H32(31),n2h32(16))
  Gcoeff(:)%j = (-(c(12)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(47),h0tab(:,47),[32,1,16,2,8,4],[nMW,0,0,nMW,nMT,nMW],6,0)
  call Hloop_SV_V(ntryL,G0H64(1),ex6(:),G0H32(16),m3h2x32(:,47),heltab2x64(:,:,47))
  Gcoeff(:)%j = (-(c(12)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(48),h0tab(:,48),[32,1,16,2,8,4],[nMW,0,0,nMW,nMT,nMW],6,0)
  call Hloop_UV_W(ntryL,G0H64(1),0,ex6(:),32,G1H32(32),m3h2x32(:,48),heltab2x64(:,:,48))
  Gcoeff(:)%j = (-(c(12)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(49),h0tab(:,49),[32,1,16,4,8,2],[0,nMW,nMW,nMT,nMW,0],6,0)
  call Hloop_AV_Q(ntryL,G0H64(1),ex6(:),G0H32(17),m3h2x32(:,49),heltab2x64(:,:,49))
  call Hloop_A_Q(ntryL,G0H32(17),32,0,G1H32(33),n2h32(17))
  Gcoeff(:)%j = (-(c(12)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(50),h0tab(:,50),[32,1,16,4,8,2],[0,nMW,nMW,nMT,nMW,0],6,0)
  call Hloop_AV_Q(ntryL,G0H64(1),ex6(:),G0H32(17),m3h2x32(:,50),heltab2x64(:,:,50))
  call Hloop_A_Q(ntryL,G0H32(17),32,0,G1H32(34),n2h32(18))
  call Hloop_QA_Z(ntryL,G1H32(1),ex4(:),G1H16(1),ngZd,m3h2x16(:,1),heltab2x32(:,:,1))
  call Hloop_QA_W(ntryL,G1H32(2),ex4(:),G1H16(2),m3h2x16(:,2),heltab2x32(:,:,2))
  call Hloop_AQ_Z(ntryL,G1H32(3),ex3(:),G1H16(3),ngZd,m3h2x16(:,3),heltab2x32(:,:,3))
  call Hloop_AQ_W(ntryL,G1H32(4),ex3(:),G1H16(4),m3h2x16(:,4),heltab2x32(:,:,4))
  call Hloop_SA_Q(ntryL,G1H32(5),ex4(:),G1H16(5),ngPbt,m3h2x16(:,5),heltab2x32(:,:,5))
  call Hloop_A_Q(ntryL,G1H16(5),40,nMT,G2H16(1),n2h16(1))
  call Hloop_SA_Q(ntryL,G0H32(1),ex4(:),G0H16(1),ngPbt,m3h2x16(:,6),heltab2x32(:,:,6))
  call Hloop_A_Q(ntryL,G0H16(1),40,nMT,G1H16(5),n2h16(2))
  call Hloop_WA_Q(ntryL,G0H32(2),ex4(:),G0H16(1),m3h2x16(:,7),heltab2x32(:,:,7))
  call Hloop_A_Q(ntryL,G0H16(1),40,nMT,G1H16(6),n2h16(3))
  call Hloop_WA_Q(ntryL,G1H32(6),ex4(:),G1H16(7),m3h2x16(:,8),heltab2x32(:,:,8))
  call Hloop_A_Q(ntryL,G1H16(7),40,nMT,G2H16(2),n2h16(4))
  call Hloop_AQ_W(ntryL,G1H32(7),ex3(:),G1H16(7),m3h2x16(:,9),heltab2x32(:,:,9))
  call Hloop_AQ_W(ntryL,G1H32(8),ex3(:),G1H16(8),m3h2x16(:,10),heltab2x32(:,:,10))
  call Hloop_WA_Q(ntryL,G0H32(3),ex2(:),G0H16(1),m3h2x16(:,11),heltab2x32(:,:,11))
  call Hloop_A_Q(ntryL,G0H16(1),34,0,G1H16(9),n2h16(5))
  call Hloop_WA_Q(ntryL,G1H32(9),ex2(:),G1H16(10),m3h2x16(:,12),heltab2x32(:,:,12))
  call Hloop_A_Q(ntryL,G1H16(10),34,0,G2H16(3),n2h16(6))
  call Hloop_WA_Q(ntryL,G0H32(4),ex2(:),G0H16(1),m3h2x16(:,13),heltab2x32(:,:,13))
  call Hloop_A_Q(ntryL,G0H16(1),34,0,G1H16(10),n2h16(7))
  call Hloop_WA_Q(ntryL,G1H32(10),ex2(:),G1H16(11),m3h2x16(:,14),heltab2x32(:,:,14))
  call Hloop_A_Q(ntryL,G1H16(11),34,0,G2H16(4),n2h16(8))
  call Hloop_WA_Q(ntryL,G0H32(5),ex2(:),G0H16(1),m3h2x16(:,15),heltab2x32(:,:,15))
  call Hloop_A_Q(ntryL,G0H16(1),34,0,G1H16(11),n2h16(9))
  call Hloop_WA_Q(ntryL,G1H32(11),ex2(:),G1H16(12),m3h2x16(:,16),heltab2x32(:,:,16))
  call Hloop_A_Q(ntryL,G1H16(12),34,0,G2H16(5),n2h16(10))
  call Hloop_QA_Z(ntryL,G1H32(12),ex4(:),G1H16(12),ngZd,m3h2x16(:,17),heltab2x32(:,:,17))
  call Hloop_AQ_Z(ntryL,G1H32(13),ex3(:),G1H16(13),ngZd,m3h2x16(:,18),heltab2x32(:,:,18))
  call Hloop_SQ_A(ntryL,G1H32(14),ex3(:),G1H16(14),ngPtb,m3h2x16(:,19),heltab2x32(:,:,19))
  call Hloop_Q_A(ntryL,G1H16(14),36,nMT,G2H16(6),n2h16(11))
  call Hloop_SQ_A(ntryL,G0H32(6),ex3(:),G0H16(1),ngPtb,m3h2x16(:,20),heltab2x32(:,:,20))
  call Hloop_Q_A(ntryL,G0H16(1),36,nMT,G1H16(14),n2h16(12))
  call Hloop_WQ_A(ntryL,G0H32(7),ex3(:),G0H16(1),m3h2x16(:,21),heltab2x32(:,:,21))
  call Hloop_Q_A(ntryL,G0H16(1),36,nMT,G1H16(15),n2h16(13))
  call Hloop_WQ_A(ntryL,G1H32(15),ex3(:),G1H16(16),m3h2x16(:,22),heltab2x32(:,:,22))
  call Hloop_Q_A(ntryL,G1H16(16),36,nMT,G2H16(7),n2h16(14))
  call Hloop_AQ_S(ntryL,G1H32(16),ex3(:),G1H16(16),ngPtb,m3h2x16(:,23),heltab2x32(:,:,23))
  call Hloop_AQ_W(ntryL,G1H32(17),ex3(:),G1H16(17),m3h2x16(:,24),heltab2x32(:,:,24))
  call Hloop_WA_Q(ntryL,G0H32(8),ex2(:),G0H16(1),m3h2x16(:,25),heltab2x32(:,:,25))
  call Hloop_A_Q(ntryL,G0H16(1),34,0,G1H16(18),n2h16(15))
  call Hloop_WA_Q(ntryL,G1H32(18),ex2(:),G1H16(19),m3h2x16(:,26),heltab2x32(:,:,26))
  call Hloop_A_Q(ntryL,G1H16(19),34,0,G2H16(8),n2h16(16))
  call Hloop_WA_Q(ntryL,G0H32(9),ex2(:),G0H16(1),m3h2x16(:,27),heltab2x32(:,:,27))
  call Hloop_A_Q(ntryL,G0H16(1),34,0,G1H16(19),n2h16(17))
  call Hloop_WA_Q(ntryL,G1H32(19),ex2(:),G1H16(20),m3h2x16(:,28),heltab2x32(:,:,28))
  call Hloop_A_Q(ntryL,G1H16(20),34,0,G2H16(9),n2h16(18))
  call Hloop_WQ_A(ntryL,G0H32(10),ex1(:),G0H16(1),m3h2x16(:,29),heltab2x32(:,:,29))
  call Hloop_Q_A(ntryL,G0H16(1),33,0,G1H16(20),n2h16(19))
  call Hloop_WQ_A(ntryL,G1H32(20),ex1(:),G1H16(21),m3h2x16(:,30),heltab2x32(:,:,30))
  call Hloop_Q_A(ntryL,G1H16(21),33,0,G2H16(10),n2h16(20))
  call Hloop_WQ_A(ntryL,G0H32(11),ex1(:),G0H16(1),m3h2x16(:,31),heltab2x32(:,:,31))
  call Hloop_Q_A(ntryL,G0H16(1),33,0,G1H16(21),n2h16(21))
  call Hloop_WQ_A(ntryL,G1H32(21),ex1(:),G1H16(22),m3h2x16(:,32),heltab2x32(:,:,32))
  call Hloop_Q_A(ntryL,G1H16(22),33,0,G2H16(11),n2h16(22))
  call Hloop_WQ_A(ntryL,G0H32(12),ex1(:),G0H16(1),m3h2x16(:,33),heltab2x32(:,:,33))
  call Hloop_Q_A(ntryL,G0H16(1),33,0,G1H16(22),n2h16(23))
  call Hloop_WQ_A(ntryL,G1H32(22),ex1(:),G1H16(23),m3h2x16(:,34),heltab2x32(:,:,34))
  call Hloop_Q_A(ntryL,G1H16(23),33,0,G2H16(12),n2h16(24))
  call Hloop_WQ_A(ntryL,G0H32(13),ex1(:),G0H16(1),m3h2x16(:,35),heltab2x32(:,:,35))
  call Hloop_Q_A(ntryL,G0H16(1),33,0,G1H16(23),n2h16(25))
  call Hloop_WQ_A(ntryL,G0H32(14),ex1(:),G0H16(1),m3h2x16(:,36),heltab2x32(:,:,36))
  call Hloop_Q_A(ntryL,G0H16(1),33,0,G1H16(24),n2h16(26))
  call Hloop_WQ_A(ntryL,G1H32(23),ex1(:),G1H16(25),m3h2x16(:,37),heltab2x32(:,:,37))
  call Hloop_Q_A(ntryL,G1H16(25),33,0,G2H16(13),n2h16(27))
  call Hloop_WQ_A(ntryL,G1H32(24),ex1(:),G1H16(25),m3h2x16(:,38),heltab2x32(:,:,38))
  call Hloop_Q_A(ntryL,G1H16(25),33,0,G2H16(14),n2h16(28))
  call Hloop_AQ_W(ntryL,G1H32(25),ex3(:),G1H16(25),m3h2x16(:,39),heltab2x32(:,:,39))
  call Hloop_QA_W(ntryL,G1H32(26),ex2(:),G1H16(26),m3h2x16(:,40),heltab2x32(:,:,40))
  call Hloop_WA_Q(ntryL,G0H32(15),ex2(:),G0H16(1),m3h2x16(:,41),heltab2x32(:,:,41))
  call Hloop_A_Q(ntryL,G0H16(1),34,0,G1H16(27),n2h16(29))
  call Hloop_WA_Q(ntryL,G1H32(27),ex2(:),G1H16(28),m3h2x16(:,42),heltab2x32(:,:,42))
  call Hloop_A_Q(ntryL,G1H16(28),34,0,G2H16(15),n2h16(30))
  call Hloop_AQ_W(ntryL,G1H32(28),ex1(:),G1H16(28),m3h2x16(:,43),heltab2x32(:,:,43))
  call Hloop_AQ_W(ntryL,G1H32(29),ex1(:),G1H16(29),m3h2x16(:,44),heltab2x32(:,:,44))
  call Hloop_AQ_W(ntryL,G1H32(30),ex1(:),G1H16(30),m3h2x16(:,45),heltab2x32(:,:,45))
  call Hloop_AQ_W(ntryL,G1H32(31),ex1(:),G1H16(31),m3h2x16(:,46),heltab2x32(:,:,46))
  call Hloop_WQ_A(ntryL,G0H32(16),ex1(:),G0H16(1),m3h2x16(:,47),heltab2x32(:,:,47))
  call Hloop_Q_A(ntryL,G0H16(1),33,0,G1H16(32),n2h16(31))
  call Hloop_WQ_A(ntryL,G1H32(32),ex1(:),G1H16(33),m3h2x16(:,48),heltab2x32(:,:,48))
  call Hloop_Q_A(ntryL,G1H16(33),33,0,G2H16(16),n2h16(32))
  call Hloop_AQ_W(ntryL,G1H32(33),ex1(:),G1H16(33),m3h2x16(:,49),heltab2x32(:,:,49))
  call Hloop_AQ_W(ntryL,G1H32(34),ex1(:),G1H16(34),m3h2x16(:,50),heltab2x32(:,:,50))
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H16(1),[G1H16(6)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H16(2),[G1H16(5)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H16(6),[G1H16(15)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H16(7),[G1H16(14)])
  call Hloop_ZA_Q(ntryL,G1H16(1),ex2(:),G1H8(1),ngZn,m3h2x8(:,1),heltab2x16(:,:,1))
  call Hloop_A_Q(ntryL,G1H8(1),42,0,G2H8(1),n2h8(1))
  call Hloop_WA_Q(ntryL,G1H16(2),ex2(:),G1H8(1),m3h2x8(:,2),heltab2x16(:,:,2))
  call Hloop_A_Q(ntryL,G1H8(1),42,0,G2H8(2),n2h8(2))
  call Hloop_ZQ_A(ntryL,G1H16(3),ex1(:),G1H8(1),ngZn,m3h2x8(:,3),heltab2x16(:,:,3))
  call Hloop_Q_A(ntryL,G1H8(1),37,0,G2H8(3),n2h8(3))
  call Hloop_WQ_A(ntryL,G1H16(4),ex1(:),G1H8(1),m3h2x8(:,4),heltab2x16(:,:,4))
  call Hloop_Q_A(ntryL,G1H8(1),37,0,G2H8(4),n2h8(4))
  call Hloop_AQ_W(ntryL,G2H16(1),ex3(:),G2H8(5),m3h2x8(:,5),heltab2x16(:,:,5))
  call Hloop_AQ_W(ntryL,G2H16(2),ex3(:),G2H8(6),m3h2x8(:,6),heltab2x16(:,:,6))
  call Hloop_WQ_A(ntryL,G1H16(7),ex1(:),G1H8(1),m3h2x8(:,7),heltab2x16(:,:,7))
  call Hloop_Q_A(ntryL,G1H8(1),37,0,G2H8(7),n2h8(5))
  call Hloop_WQ_A(ntryL,G1H16(8),ex1(:),G1H8(1),m3h2x8(:,8),heltab2x16(:,:,8))
  call Hloop_Q_A(ntryL,G1H8(1),37,0,G2H8(8),n2h8(6))
  call Hloop_AQ_W(ntryL,G1H16(9),ex1(:),G1H8(1),m3h2x8(:,9),heltab2x16(:,:,9))
  call Hloop_AQ_W(ntryL,G2H16(3),ex1(:),G2H8(9),m3h2x8(:,10),heltab2x16(:,:,10))
  call Hloop_AQ_W(ntryL,G1H16(10),ex1(:),G1H8(2),m3h2x8(:,11),heltab2x16(:,:,11))
  call Hloop_AQ_W(ntryL,G2H16(4),ex1(:),G2H8(10),m3h2x8(:,12),heltab2x16(:,:,12))
  call Hloop_AQ_W(ntryL,G1H16(11),ex1(:),G1H8(3),m3h2x8(:,13),heltab2x16(:,:,13))
  call Hloop_AQ_W(ntryL,G2H16(5),ex1(:),G2H8(11),m3h2x8(:,14),heltab2x16(:,:,14))
  call Hloop_ZQ_A(ntryL,G1H16(12),ex1(:),G1H8(4),ngZn,m3h2x8(:,15),heltab2x16(:,:,15))
  call Hloop_Q_A(ntryL,G1H8(4),41,0,G2H8(12),n2h8(7))
  call Hloop_ZA_Q(ntryL,G1H16(13),ex2(:),G1H8(4),ngZn,m3h2x8(:,16),heltab2x16(:,:,16))
  call Hloop_A_Q(ntryL,G1H8(4),38,0,G2H8(13),n2h8(8))
  call Hloop_QA_W(ntryL,G2H16(6),ex4(:),G2H8(14),m3h2x8(:,17),heltab2x16(:,:,17))
  call Hloop_QA_W(ntryL,G2H16(7),ex4(:),G2H8(15),m3h2x8(:,18),heltab2x16(:,:,18))
  call Hloop_SV_V(ntryL,G1H16(16),ex5(:),G1H8(4),m3h2x8(:,19),heltab2x16(:,:,19))
  call Hloop_UV_W(ntryL,G1H16(17),36,ex5(:),16,G2H8(16),m3h2x8(:,20),heltab2x16(:,:,20))
  call Hloop_AQ_W(ntryL,G1H16(18),ex1(:),G1H8(5),m3h2x8(:,21),heltab2x16(:,:,21))
  call Hloop_AQ_W(ntryL,G2H16(8),ex1(:),G2H8(17),m3h2x8(:,22),heltab2x16(:,:,22))
  call Hloop_AQ_W(ntryL,G1H16(19),ex1(:),G1H8(6),m3h2x8(:,23),heltab2x16(:,:,23))
  call Hloop_AQ_W(ntryL,G2H16(9),ex1(:),G2H8(18),m3h2x8(:,24),heltab2x16(:,:,24))
  call Hloop_QA_W(ntryL,G1H16(20),ex2(:),G1H8(7),m3h2x8(:,25),heltab2x16(:,:,25))
  call Hloop_QA_W(ntryL,G2H16(10),ex2(:),G2H8(19),m3h2x8(:,26),heltab2x16(:,:,26))
  call Hloop_QA_W(ntryL,G1H16(21),ex2(:),G1H8(8),m3h2x8(:,27),heltab2x16(:,:,27))
  call Hloop_QA_W(ntryL,G2H16(11),ex2(:),G2H8(20),m3h2x8(:,28),heltab2x16(:,:,28))
  call Hloop_QA_W(ntryL,G1H16(22),ex2(:),G1H8(9),m3h2x8(:,29),heltab2x16(:,:,29))
  call Hloop_QA_W(ntryL,G2H16(12),ex2(:),G2H8(21),m3h2x8(:,30),heltab2x16(:,:,30))
  call Hloop_QA_W(ntryL,G1H16(23),ex2(:),G1H8(10),m3h2x8(:,31),heltab2x16(:,:,31))
  call Hloop_QA_W(ntryL,G1H16(24),ex2(:),G1H8(11),m3h2x8(:,32),heltab2x16(:,:,32))
  call Hloop_QA_W(ntryL,G2H16(13),ex2(:),G2H8(22),m3h2x8(:,33),heltab2x16(:,:,33))
  call Hloop_QA_W(ntryL,G2H16(14),ex2(:),G2H8(23),m3h2x8(:,34),heltab2x16(:,:,34))
  call Hloop_WQ_A(ntryL,G1H16(25),ex1(:),G1H8(12),m3h2x8(:,35),heltab2x16(:,:,35))
  call Hloop_Q_A(ntryL,G1H8(12),37,0,G2H8(24),n2h8(9))
  call Hloop_WA_Q(ntryL,G1H16(26),ex4(:),G1H8(12),m3h2x8(:,36),heltab2x16(:,:,36))
  call Hloop_A_Q(ntryL,G1H8(12),42,nMT,G2H8(25),n2h8(10))
  call Hloop_AV_Q(ntryL,G1H16(27),ex5(:),G1H8(12),m3h2x8(:,37),heltab2x16(:,:,37))
  call Hloop_A_Q(ntryL,G1H8(12),50,0,G2H8(26),n2h8(11))
  call Hotf_5pt_reduction(G2H16(15),RedSet_5(1),mass5set(:,1),  & 
G1H16(6),G1H16(5),G1H16(15),G1H16(14),G1H16(1),G1H16(2),16)
  call HG1shiftOLR(G1H16(5),8,16)
  call Hloop_WQ_A(ntryL,G1H16(28),ex3(:),G1H8(12),m3h2x8(:,38),heltab2x16(:,:,38))
  call Hloop_Q_A(ntryL,G1H8(12),37,nMT,G2H8(27),n2h8(12))
  call Hloop_WQ_A(ntryL,G1H16(29),ex3(:),G1H8(12),m3h2x8(:,39),heltab2x16(:,:,39))
  call Hloop_Q_A(ntryL,G1H8(12),37,nMT,G2H8(28),n2h8(13))
  call Hloop_WQ_A(ntryL,G1H16(30),ex3(:),G1H8(12),m3h2x8(:,40),heltab2x16(:,:,40))
  call Hloop_Q_A(ntryL,G1H8(12),37,nMT,G2H8(29),n2h8(14))
  call Hloop_WQ_A(ntryL,G1H16(31),ex3(:),G1H8(12),m3h2x8(:,41),heltab2x16(:,:,41))
  call Hloop_Q_A(ntryL,G1H8(12),37,nMT,G2H8(30),n2h8(15))
  call Hloop_QV_A(ntryL,G1H16(32),ex5(:),G1H8(12),m3h2x8(:,42),heltab2x16(:,:,42))
  call Hloop_Q_A(ntryL,G1H8(12),49,0,G2H8(31),n2h8(16))
  call Hotf_5pt_reduction(G2H16(16),RedSet_5(2),mass5set(:,1),  & 
G1H16(3),G1H16(4),G1H16(7),G1H16(8),G1H16(9),G1H16(10),16)
  call HG1shiftOLR(G1H16(4),4,16)
  call Hloop_VV_S(ntryL,G1H16(33),ex5(:),G1H8(12),m3h2x8(:,43),heltab2x16(:,:,43))
  call Hloop_UW_V(ntryL,G1H16(34),33,ex5(:),16,G2H8(32),m3h2x8(:,44),heltab2x16(:,:,44))
  call Hloop_AV_Q(ntryL,G1H16(6),ex5(:),G1H8(13),m3h2x8(:,45),heltab2x16(:,:,45))
  call Hloop_A_Q(ntryL,G1H8(13),50,0,G2H8(33),n2h8(17))
call HGT_raise_alpha_OLR(G1H16(5),1,1,16)
call HGT_raise_alpha_invQ_OLR(G1H16(5),2,5,16)
  call Hloop_WA_Q(ntryL,G1H16(5),ex4(:),G1H8(13),m3h2x8(:,46),heltab2x16(:,:,46))
  call Hloop_AV_Q(ntryL,G1H16(14),ex5(:),G1H8(14),m3h2x8(:,47),heltab2x16(:,:,47))
  call Hloop_A_Q(ntryL,G1H8(14),50,0,G2H8(34),n2h8(18))
  call Hloop_AV_Q(ntryL,G1H16(1),ex5(:),G1H8(14),m3h2x8(:,48),heltab2x16(:,:,48))
  call Hloop_A_Q(ntryL,G1H8(14),50,0,G2H8(35),n2h8(19))
  call Hloop_AV_Q(ntryL,G1H16(2),ex5(:),G1H8(14),m3h2x8(:,49),heltab2x16(:,:,49))
  call Hloop_A_Q(ntryL,G1H8(14),50,0,G2H8(36),n2h8(20))
  call Hloop_QV_A(ntryL,G1H16(3),ex5(:),G1H8(14),m3h2x8(:,50),heltab2x16(:,:,50))
  call Hloop_Q_A(ntryL,G1H8(14),49,0,G2H8(37),n2h8(21))
call HGT_raise_alpha_OLR(G1H16(4),1,1,16)
call HGT_raise_alpha_invQ_OLR(G1H16(4),2,5,16)
  call Hloop_WQ_A(ntryL,G1H16(4),ex3(:),G1H8(14),m3h2x8(:,51),heltab2x16(:,:,51))
  call Hloop_QV_A(ntryL,G1H16(8),ex5(:),G1H8(15),m3h2x8(:,52),heltab2x16(:,:,52))
  call Hloop_Q_A(ntryL,G1H8(15),49,0,G2H8(38),n2h8(22))
  call Hloop_QV_A(ntryL,G1H16(9),ex5(:),G1H8(15),m3h2x8(:,53),heltab2x16(:,:,53))
  call Hloop_Q_A(ntryL,G1H8(15),49,0,G2H8(39),n2h8(23))
  call Hloop_QV_A(ntryL,G1H16(10),ex5(:),G1H8(15),m3h2x8(:,54),heltab2x16(:,:,54))
  call Hloop_Q_A(ntryL,G1H8(15),49,0,G2H8(40),n2h8(24))
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H8(16),[G1H8(4)])
  call Hloop_AQ_Z(ntryL,G2H8(1),ex1(:),G2H4(1),ngZn,m3h2x4(:,1),heltab2x8(:,:,1))
  call Hloop_AQ_W(ntryL,G2H8(2),ex1(:),G2H4(2),m3h2x4(:,2),heltab2x8(:,:,2))
  call Hloop_QA_Z(ntryL,G2H8(3),ex2(:),G2H4(3),ngZn,m3h2x4(:,3),heltab2x8(:,:,3))
  call Hloop_QA_W(ntryL,G2H8(4),ex2(:),G2H4(4),m3h2x4(:,4),heltab2x8(:,:,4))
  call Hotf_5pt_reduction(G2H8(5),RedSet_5(3),mass5set(:,2),  & 
G1H8(15),G1H8(4),G1H8(16),G1H8(17),G1H8(18),G1H8(19),8)
  call HG1shiftOLR(G1H8(4),16,8)
  call Hotf_5pt_reduction(G2H8(6),RedSet_5(3),mass5set(:,2),  & 
G1H8(20),G1H8(21),G1H8(22),G1H8(23),G1H8(24),G1H8(25),8)
  call HG1shiftOLR(G1H8(21),16,8)
  call Hloop_QA_W(ntryL,G2H8(7),ex2(:),G2H4(5),m3h2x4(:,5),heltab2x8(:,:,5))
  call Hloop_QA_W(ntryL,G2H8(8),ex2(:),G2H4(6),m3h2x4(:,6),heltab2x8(:,:,6))
  call Hloop_WQ_A(ntryL,G1H8(1),ex3(:),G1H4(1),m3h2x4(:,7),heltab2x8(:,:,7))
  call Hloop_Q_A(ntryL,G1H4(1),39,nMT,G2H4(7),n2h4(1))
  call Hotf_5pt_reduction(G2H8(9),RedSet_5(4),mass5set(:,3),  & 
G1H8(1),G1H8(26),G1H8(27),G1H8(28),G1H8(29),G1H8(30),8)
  call HG1shiftOLR(G1H8(26),16,8)
  call Hloop_WQ_A(ntryL,G1H8(2),ex3(:),G1H4(1),m3h2x4(:,8),heltab2x8(:,:,8))
  call Hloop_Q_A(ntryL,G1H4(1),39,nMT,G2H4(8),n2h4(2))
  call Hotf_5pt_reduction(G2H8(10),RedSet_5(4),mass5set(:,3),  & 
G1H8(2),G1H8(31),G1H8(32),G1H8(33),G1H8(34),G1H8(35),8)
  call HG1shiftOLR(G1H8(31),16,8)
  call Hloop_WQ_A(ntryL,G1H8(3),ex3(:),G1H4(1),m3h2x4(:,9),heltab2x8(:,:,9))
  call Hloop_Q_A(ntryL,G1H4(1),39,nMT,G2H4(9),n2h4(3))
  call Hotf_5pt_reduction(G2H8(11),RedSet_5(4),mass5set(:,3),  & 
G1H8(3),G1H8(36),G1H8(37),G1H8(38),G1H8(39),G1H8(40),8)
  call HG1shiftOLR(G1H8(36),8,8)
  call Hloop_QA_Z(ntryL,G2H8(12),ex2(:),G2H4(10),ngZn,m3h2x4(:,10),heltab2x8(:,:,10))
  call Hloop_AQ_Z(ntryL,G2H8(13),ex1(:),G2H4(11),ngZn,m3h2x4(:,11),heltab2x8(:,:,11))
  call Hotf_5pt_reduction(G2H8(14),RedSet_5(5),mass5set(:,2),  & 
G1H8(41),G1H8(42),G1H8(43),G1H8(44),G1H8(45),G1H8(46),8)
  call HG1shiftOLR(G1H8(42),16,8)
  call Hotf_5pt_reduction(G2H8(15),RedSet_5(5),mass5set(:,2),  & 
G1H8(47),G1H8(48),G1H8(49),G1H8(50),G1H8(51),G1H8(52),8)
  call HG1shiftOLR(G1H8(48),16,8)
  call Hotf_5pt_reduction(G2H8(16),RedSet_5(6),mass5set(:,4),  & 
G1H8(53),G1H8(54),G1H8(55),G1H8(56),G1H8(57),G1H8(58),8)
  call HG1shiftOLR(G1H8(54),8,8)
  call Hloop_VV_S(ntryL,G1H8(5),ex5(:),G1H4(1),m3h2x4(:,12),heltab2x8(:,:,12))
  call Hloop_VV_S(ntryL,G2H8(17),ex5(:),G2H4(12),m3h2x4(:,13),heltab2x8(:,:,13))
  call Hloop_UW_V(ntryL,G1H8(6),35,ex5(:),16,G2H4(13),m3h2x4(:,14),heltab2x8(:,:,14))
  call Hotf_5pt_reduction(G2H8(18),RedSet_5(7),mass5set(:,5),  & 
G1H8(5),G1H8(6),G1H8(59),G1H8(60),G1H8(61),G1H8(62),8)
  call HG1shiftOLR(G1H8(6),8,8)
  call Hloop_WA_Q(ntryL,G1H8(7),ex4(:),G1H4(2),m3h2x4(:,15),heltab2x8(:,:,15))
  call Hloop_A_Q(ntryL,G1H4(2),43,nMT,G2H4(14),n2h4(4))
  call Hotf_5pt_reduction(G2H8(19),RedSet_5(8),mass5set(:,3),  & 
G1H8(7),G1H8(63),G1H8(64),G1H8(65),G1H8(66),G1H8(67),8)
  call HG1shiftOLR(G1H8(63),16,8)
  call Hloop_WA_Q(ntryL,G1H8(8),ex4(:),G1H4(2),m3h2x4(:,16),heltab2x8(:,:,16))
  call Hloop_A_Q(ntryL,G1H4(2),43,nMT,G2H4(15),n2h4(5))
  call Hotf_5pt_reduction(G2H8(20),RedSet_5(8),mass5set(:,3),  & 
G1H8(8),G1H8(68),G1H8(69),G1H8(70),G1H8(71),G1H8(72),8)
  call HG1shiftOLR(G1H8(68),16,8)
  call Hloop_WA_Q(ntryL,G1H8(9),ex4(:),G1H4(2),m3h2x4(:,17),heltab2x8(:,:,17))
  call Hloop_A_Q(ntryL,G1H4(2),43,nMT,G2H4(16),n2h4(6))
  call Hotf_5pt_reduction(G2H8(21),RedSet_5(8),mass5set(:,3),  & 
G1H8(9),G1H8(73),G1H8(74),G1H8(75),G1H8(76),G1H8(77),8)
  call HG1shiftOLR(G1H8(73),4,8)
  call Hloop_VV_S(ntryL,G1H8(10),ex5(:),G1H4(2),m3h2x4(:,18),heltab2x8(:,:,18))
  call Hloop_UV_W(ntryL,G1H8(11),35,ex5(:),16,G2H4(17),m3h2x4(:,19),heltab2x8(:,:,19))
  call Hloop_VV_S(ntryL,G2H8(22),ex5(:),G2H4(18),m3h2x4(:,20),heltab2x8(:,:,20))
  call Hotf_5pt_reduction(G2H8(23),RedSet_5(9),mass5set(:,5),  & 
G1H8(10),G1H8(11),G1H8(78),G1H8(79),G1H8(80),G1H8(81),8)
  call HG1shiftOLR(G1H8(11),4,8)
  call Hotf_5pt_reduction(G2H8(24),RedSet_5(10),mass5set(:,6),  & 
G1H8(82),G1H8(83),G1H8(84),G1H8(85),G1H8(86),G1H8(87),8)
  call HG1shiftOLR(G1H8(83),8,8)
  call Hloop_AQ_W(ntryL,G2H8(25),ex3(:),G2H4(19),m3h2x4(:,21),heltab2x8(:,:,21))
  call Hloop_AQ_W(ntryL,G2H8(26),ex1(:),G2H4(20),m3h2x4(:,22),heltab2x8(:,:,22))
  call Hloop_QA_W(ntryL,G2H8(27),ex4(:),G2H4(21),m3h2x4(:,23),heltab2x8(:,:,23))
  call Hotf_5pt_reduction(G2H8(28),RedSet_5(11),mass5set(:,7),  & 
G1H8(88),G1H8(89),G1H8(90),G1H8(91),G1H8(92),G1H8(93),8)
  call HG1shiftOLR(G1H8(89),2,8)
  call Hloop_QA_S(ntryL,G2H8(29),ex4(:),G2H4(22),ngPbt,m3h2x4(:,24),heltab2x8(:,:,24))
  call Hloop_QA_W(ntryL,G2H8(30),ex4(:),G2H4(23),m3h2x4(:,25),heltab2x8(:,:,25))
  call Hloop_QA_W(ntryL,G2H8(31),ex2(:),G2H4(24),m3h2x4(:,26),heltab2x8(:,:,26))
  call Hloop_SQ_A(ntryL,G1H8(12),ex3(:),G1H4(3),ngPtb,m3h2x4(:,27),heltab2x8(:,:,27))
  call Hloop_Q_A(ntryL,G1H4(3),53,nMT,G2H4(25),n2h4(7))
  call Hotf_5pt_reduction(G2H8(32),RedSet_5(12),mass5set(:,8),  & 
G1H8(12),G1H8(94),G1H8(95),G1H8(96),G1H8(97),G1H8(98),8)
  call HG1shiftOLR(G1H8(94),2,8)
  call Hloop_AQ_W(ntryL,G2H8(33),ex1(:),G2H4(26),m3h2x4(:,28),heltab2x8(:,:,28))
  call Hloop_AQ_W(ntryL,G2H8(35),ex1(:),G2H4(27),m3h2x4(:,29),heltab2x8(:,:,29))
  call Hloop_AQ_W(ntryL,G2H8(36),ex1(:),G2H4(28),m3h2x4(:,30),heltab2x8(:,:,30))
  call Hloop_QA_W(ntryL,G2H8(37),ex2(:),G2H4(29),m3h2x4(:,31),heltab2x8(:,:,31))
  call Hloop_QA_W(ntryL,G2H8(39),ex2(:),G2H4(30),m3h2x4(:,32),heltab2x8(:,:,32))
  call Hloop_QA_W(ntryL,G2H8(40),ex2(:),G2H4(31),m3h2x4(:,33),heltab2x8(:,:,33))
  call Hloop_WQ_A(ntryL,G1H8(15),ex1(:),G1H4(3),m3h2x4(:,34),heltab2x8(:,:,34))
  call Hloop_Q_A(ntryL,G1H4(3),45,0,G2H4(32),n2h4(8))
call HGT_OLR(G1H8(4),1,1,8)
call HGT_invQ_OLR(G1H8(4),2,5,8)
  call Hloop_SV_V(ntryL,G1H8(4),ex5(:),G1H4(3),m3h2x4(:,35),heltab2x8(:,:,35))
  call Hloop_WQ_A(ntryL,G1H8(18),ex1(:),G1H4(4),m3h2x4(:,36),heltab2x8(:,:,36))
  call Hloop_Q_A(ntryL,G1H4(4),45,0,G2H4(33),n2h4(9))
  call Hloop_WQ_A(ntryL,G1H8(19),ex1(:),G1H4(4),m3h2x4(:,37),heltab2x8(:,:,37))
  call Hloop_Q_A(ntryL,G1H4(4),45,0,G2H4(34),n2h4(10))
  call Hloop_WQ_A(ntryL,G1H8(20),ex1(:),G1H4(4),m3h2x4(:,38),heltab2x8(:,:,38))
  call Hloop_Q_A(ntryL,G1H4(4),45,0,G2H4(35),n2h4(11))
call HGT_raise_alpha_OLR(G1H8(21),1,1,8)
call HGT_raise_alpha_invQ_OLR(G1H8(21),2,5,8)
  call Hloop_UW_V(ntryL,G1H8(21),-16,ex5(:),16,G2H4(36),m3h2x4(:,39),heltab2x8(:,:,39))
  call Hloop_WQ_A(ntryL,G1H8(24),ex1(:),G1H4(4),m3h2x4(:,40),heltab2x8(:,:,40))
  call Hloop_Q_A(ntryL,G1H4(4),45,0,G2H4(37),n2h4(12))
  call Hloop_WQ_A(ntryL,G1H8(25),ex1(:),G1H4(4),m3h2x4(:,41),heltab2x8(:,:,41))
  call Hloop_Q_A(ntryL,G1H4(4),45,0,G2H4(38),n2h4(13))
  call Hloop_WQ_A(ntryL,G1H8(1),ex3(:),G1H4(4),m3h2x4(:,42),heltab2x8(:,:,42))
  call Hloop_Q_A(ntryL,G1H4(4),39,nMT,G2H4(39),n2h4(14))
call HGT_raise_alpha_OLR(G1H8(26),1,1,8)
call HGT_raise_alpha_invQ_OLR(G1H8(26),2,5,8)
  call Hloop_VV_S(ntryL,G1H8(26),ex5(:),G1H4(4),m3h2x4(:,43),heltab2x8(:,:,43))
  call Hloop_WQ_A(ntryL,G1H8(29),ex3(:),G1H4(5),m3h2x4(:,44),heltab2x8(:,:,44))
  call Hloop_Q_A(ntryL,G1H4(5),39,nMT,G2H4(40),n2h4(15))
  call Hloop_WQ_A(ntryL,G1H8(30),ex3(:),G1H4(5),m3h2x4(:,45),heltab2x8(:,:,45))
  call Hloop_Q_A(ntryL,G1H4(5),39,nMT,G2H4(41),n2h4(16))
  call Hloop_WQ_A(ntryL,G1H8(2),ex3(:),G1H4(5),m3h2x4(:,46),heltab2x8(:,:,46))
  call Hloop_Q_A(ntryL,G1H4(5),39,nMT,G2H4(42),n2h4(17))
call HGT_raise_alpha_OLR(G1H8(31),1,1,8)
call HGT_raise_alpha_invQ_OLR(G1H8(31),2,5,8)
  call Hloop_UV_W(ntryL,G1H8(31),-16,ex5(:),16,G2H4(43),m3h2x4(:,47),heltab2x8(:,:,47))
  call Hloop_WQ_A(ntryL,G1H8(34),ex3(:),G1H4(5),m3h2x4(:,48),heltab2x8(:,:,48))
  call Hloop_Q_A(ntryL,G1H4(5),39,nMT,G2H4(44),n2h4(18))
  call Hloop_WQ_A(ntryL,G1H8(35),ex3(:),G1H4(5),m3h2x4(:,49),heltab2x8(:,:,49))
  call Hloop_Q_A(ntryL,G1H4(5),39,nMT,G2H4(45),n2h4(19))
  call Hloop_WQ_A(ntryL,G1H8(3),ex3(:),G1H4(5),m3h2x4(:,50),heltab2x8(:,:,50))
  call Hloop_Q_A(ntryL,G1H4(5),39,nMT,G2H4(46),n2h4(20))
call HGT_raise_alpha_OLR(G1H8(36),1,1,8)
call HGT_raise_alpha_invQ_OLR(G1H8(36),2,5,8)
  call Hloop_WA_Q(ntryL,G1H8(36),ex4(:),G1H4(5),m3h2x4(:,51),heltab2x8(:,:,51))
  call Hloop_WQ_A(ntryL,G1H8(39),ex3(:),G1H4(6),m3h2x4(:,52),heltab2x8(:,:,52))
  call Hloop_Q_A(ntryL,G1H4(6),39,nMT,G2H4(47),n2h4(21))
  call Hloop_WQ_A(ntryL,G1H8(40),ex3(:),G1H4(6),m3h2x4(:,53),heltab2x8(:,:,53))
  call Hloop_Q_A(ntryL,G1H4(6),39,nMT,G2H4(48),n2h4(22))
  call Hloop_WA_Q(ntryL,G1H8(41),ex2(:),G1H4(6),m3h2x4(:,54),heltab2x8(:,:,54))
  call Hloop_A_Q(ntryL,G1H4(6),46,0,G2H4(49),n2h4(23))
call HGT_OLR(G1H8(42),1,1,8)
call HGT_invQ_OLR(G1H8(42),2,5,8)
  call Hloop_SV_V(ntryL,G1H8(42),ex5(:),G1H4(6),m3h2x4(:,55),heltab2x8(:,:,55))
  call Hloop_WA_Q(ntryL,G1H8(45),ex2(:),G1H4(7),m3h2x4(:,56),heltab2x8(:,:,56))
  call Hloop_A_Q(ntryL,G1H4(7),46,0,G2H4(50),n2h4(24))
  call Hloop_WA_Q(ntryL,G1H8(46),ex2(:),G1H4(7),m3h2x4(:,57),heltab2x8(:,:,57))
  call Hloop_A_Q(ntryL,G1H4(7),46,0,G2H4(51),n2h4(25))
  call Hloop_WA_Q(ntryL,G1H8(47),ex2(:),G1H4(7),m3h2x4(:,58),heltab2x8(:,:,58))
  call Hloop_A_Q(ntryL,G1H4(7),46,0,G2H4(52),n2h4(26))
call HGT_raise_alpha_OLR(G1H8(48),1,1,8)
call HGT_raise_alpha_invQ_OLR(G1H8(48),2,5,8)
  call Hloop_UV_W(ntryL,G1H8(48),-16,ex5(:),16,G2H4(53),m3h2x4(:,59),heltab2x8(:,:,59))
  call Hloop_WA_Q(ntryL,G1H8(51),ex2(:),G1H4(7),m3h2x4(:,60),heltab2x8(:,:,60))
  call Hloop_A_Q(ntryL,G1H4(7),46,0,G2H4(54),n2h4(27))
  call Hloop_WA_Q(ntryL,G1H8(52),ex2(:),G1H4(7),m3h2x4(:,61),heltab2x8(:,:,61))
  call Hloop_A_Q(ntryL,G1H4(7),46,0,G2H4(55),n2h4(28))
  call Hloop_WQ_A(ntryL,G1H8(53),ex1(:),G1H4(7),m3h2x4(:,62),heltab2x8(:,:,62))
  call Hloop_Q_A(ntryL,G1H4(7),53,0,G2H4(56),n2h4(29))
call HGT_OLR(G1H8(54),1,1,8)
call HGT_invQ_OLR(G1H8(54),2,5,8)
  call Hloop_Q_A(ntryL,G1H8(54),-8,nMT,G2H8(1),n2h8(32))
  call Hloop_QA_W(ntryL,G2H8(1),ex4(:),G2H4(57),m3h2x4(:,63),heltab2x8(:,:,63))
  call Hloop_WQ_A(ntryL,G1H8(57),ex1(:),G1H4(7),m3h2x4(:,64),heltab2x8(:,:,64))
  call Hloop_Q_A(ntryL,G1H4(7),53,0,G2H4(58),n2h4(30))
  call Hloop_WQ_A(ntryL,G1H8(58),ex1(:),G1H4(7),m3h2x4(:,65),heltab2x8(:,:,65))
  call Hloop_Q_A(ntryL,G1H4(7),53,0,G2H4(59),n2h4(31))
  call Hloop_UW_V(ntryL,G1H8(5),35,ex5(:),16,G2H4(60),m3h2x4(:,66),heltab2x8(:,:,66))
call HGT_raise_alpha_OLR(G1H8(6),1,1,8)
call HGT_raise_alpha_invQ_OLR(G1H8(6),2,5,8)
  call Hloop_WA_Q(ntryL,G1H8(6),ex4(:),G1H4(7),m3h2x4(:,67),heltab2x8(:,:,67))
  call Hloop_UW_V(ntryL,G1H8(61),35,ex5(:),16,G2H4(61),m3h2x4(:,68),heltab2x8(:,:,68))
  call Hloop_UW_V(ntryL,G1H8(62),35,ex5(:),16,G2H4(62),m3h2x4(:,69),heltab2x8(:,:,69))
  call Hloop_WA_Q(ntryL,G1H8(7),ex4(:),G1H4(8),m3h2x4(:,70),heltab2x8(:,:,70))
  call Hloop_A_Q(ntryL,G1H4(8),43,nMT,G2H4(63),n2h4(32))
call HGT_raise_alpha_OLR(G1H8(63),1,1,8)
call HGT_raise_alpha_invQ_OLR(G1H8(63),2,5,8)
  call Hloop_VV_S(ntryL,G1H8(63),ex5(:),G1H4(8),m3h2x4(:,71),heltab2x8(:,:,71))
  call Hloop_WA_Q(ntryL,G1H8(66),ex4(:),G1H4(9),m3h2x4(:,72),heltab2x8(:,:,72))
  call Hloop_A_Q(ntryL,G1H4(9),43,nMT,G2H4(64),n2h4(33))
  call Hloop_WA_Q(ntryL,G1H8(67),ex4(:),G1H4(9),m3h2x4(:,73),heltab2x8(:,:,73))
  call Hloop_A_Q(ntryL,G1H4(9),43,nMT,G2H4(65),n2h4(34))
  call Hloop_WA_Q(ntryL,G1H8(8),ex4(:),G1H4(9),m3h2x4(:,74),heltab2x8(:,:,74))
  call Hloop_A_Q(ntryL,G1H4(9),43,nMT,G2H4(66),n2h4(35))
call HGT_raise_alpha_OLR(G1H8(68),1,1,8)
call HGT_raise_alpha_invQ_OLR(G1H8(68),2,5,8)
  call Hloop_UW_V(ntryL,G1H8(68),-16,ex5(:),16,G2H4(67),m3h2x4(:,75),heltab2x8(:,:,75))
  call Hloop_WA_Q(ntryL,G1H8(71),ex4(:),G1H4(9),m3h2x4(:,76),heltab2x8(:,:,76))
  call Hloop_A_Q(ntryL,G1H4(9),43,nMT,G2H4(68),n2h4(36))
  call Hloop_WA_Q(ntryL,G1H8(72),ex4(:),G1H4(9),m3h2x4(:,77),heltab2x8(:,:,77))
  call Hloop_A_Q(ntryL,G1H4(9),43,nMT,G2H4(69),n2h4(37))
  call Hloop_WA_Q(ntryL,G1H8(9),ex4(:),G1H4(9),m3h2x4(:,78),heltab2x8(:,:,78))
  call Hloop_A_Q(ntryL,G1H4(9),43,nMT,G2H4(70),n2h4(38))
call HGT_raise_alpha_OLR(G1H8(73),1,1,8)
call HGT_raise_alpha_invQ_OLR(G1H8(73),2,5,8)
  call Hloop_WQ_A(ntryL,G1H8(73),ex3(:),G1H4(9),m3h2x4(:,79),heltab2x8(:,:,79))
  call Hloop_WA_Q(ntryL,G1H8(76),ex4(:),G1H4(10),m3h2x4(:,80),heltab2x8(:,:,80))
  call Hloop_A_Q(ntryL,G1H4(10),43,nMT,G2H4(71),n2h4(39))
  call Hloop_WA_Q(ntryL,G1H8(77),ex4(:),G1H4(10),m3h2x4(:,81),heltab2x8(:,:,81))
  call Hloop_A_Q(ntryL,G1H4(10),43,nMT,G2H4(72),n2h4(40))
  call Hloop_UV_W(ntryL,G1H8(10),35,ex5(:),16,G2H4(73),m3h2x4(:,82),heltab2x8(:,:,82))
call HGT_raise_alpha_OLR(G1H8(11),1,1,8)
call HGT_raise_alpha_invQ_OLR(G1H8(11),2,5,8)
  call Hloop_WQ_A(ntryL,G1H8(11),ex3(:),G1H4(10),m3h2x4(:,83),heltab2x8(:,:,83))
  call Hloop_UV_W(ntryL,G1H8(80),35,ex5(:),16,G2H4(74),m3h2x4(:,84),heltab2x8(:,:,84))
  call Hloop_UV_W(ntryL,G1H8(81),35,ex5(:),16,G2H4(75),m3h2x4(:,85),heltab2x8(:,:,85))
  call Hloop_QV_A(ntryL,G1H8(82),ex5(:),G1H4(11),m3h2x4(:,86),heltab2x8(:,:,86))
  call Hloop_Q_A(ntryL,G1H4(11),53,0,G2H4(76),n2h4(41))
call HGT_OLR(G1H8(83),1,1,8)
call HGT_invQ_OLR(G1H8(83),2,5,8)
  call Hloop_Q_A(ntryL,G1H8(83),-8,nMT,G2H8(2),n2h8(38))
  call Hloop_QA_W(ntryL,G2H8(2),ex4(:),G2H4(77),m3h2x4(:,87),heltab2x8(:,:,87))
  call Hloop_QV_A(ntryL,G1H8(86),ex5(:),G1H4(11),m3h2x4(:,88),heltab2x8(:,:,88))
  call Hloop_Q_A(ntryL,G1H4(11),53,0,G2H4(78),n2h4(42))
  call Hloop_QV_A(ntryL,G1H8(87),ex5(:),G1H4(11),m3h2x4(:,89),heltab2x8(:,:,89))
  call Hloop_Q_A(ntryL,G1H4(11),53,0,G2H4(79),n2h4(43))
  call Hloop_QV_A(ntryL,G1H8(88),ex5(:),G1H4(11),m3h2x4(:,90),heltab2x8(:,:,90))
  call Hloop_Q_A(ntryL,G1H4(11),53,nMT,G2H4(80),n2h4(44))
call HGT_OLR(G1H8(89),1,1,8)
call HGT_invQ_OLR(G1H8(89),2,5,8)
  call Hloop_Q_A(ntryL,G1H8(89),-2,0,G2H8(3),n2h8(39))
  call Hloop_QA_W(ntryL,G2H8(3),ex2(:),G2H4(81),m3h2x4(:,91),heltab2x8(:,:,91))
  call Hloop_QV_A(ntryL,G1H8(92),ex5(:),G1H4(11),m3h2x4(:,92),heltab2x8(:,:,92))
  call Hloop_Q_A(ntryL,G1H4(11),53,nMT,G2H4(82),n2h4(45))
  call Hloop_QV_A(ntryL,G1H8(93),ex5(:),G1H4(11),m3h2x4(:,93),heltab2x8(:,:,93))
  call Hloop_Q_A(ntryL,G1H4(11),53,nMT,G2H4(83),n2h4(46))
  call Hloop_WQ_A(ntryL,G1H8(12),ex3(:),G1H4(11),m3h2x4(:,94),heltab2x8(:,:,94))
  call Hloop_Q_A(ntryL,G1H4(11),53,nMT,G2H4(84),n2h4(47))
call HGT_OLR(G1H8(94),1,1,8)
call HGT_invQ_OLR(G1H8(94),2,5,8)
  call Hloop_Q_A(ntryL,G1H8(94),-2,0,G2H8(4),n2h8(40))
  call Hloop_QA_W(ntryL,G2H8(4),ex2(:),G2H4(85),m3h2x4(:,95),heltab2x8(:,:,95))
  call Hloop_WQ_A(ntryL,G1H8(97),ex3(:),G1H4(11),m3h2x4(:,96),heltab2x8(:,:,96))
  call Hloop_Q_A(ntryL,G1H4(11),53,nMT,G2H4(86),n2h4(48))
  call Hloop_WQ_A(ntryL,G1H8(98),ex3(:),G1H4(11),m3h2x4(:,97),heltab2x8(:,:,97))
  call Hloop_Q_A(ntryL,G1H4(11),53,nMT,G2H4(87),n2h4(49))
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(84),[G2H4(25)])
  call Hotf_5pt_reduction(G2H4(1),RedSet_5(13),mass5set(:,9),  & 
G1H4(11),G1H4(12),G1H4(13),G1H4(14),G1H4(15),G1H4(16),4)
  call HG1shiftOLR(G1H4(12),16,4)
  call Hotf_5pt_reduction(G2H4(2),RedSet_5(13),mass5set(:,10),  & 
G1H4(17),G1H4(18),G1H4(19),G1H4(20),G1H4(21),G1H4(22),4)
  call HG1shiftOLR(G1H4(18),16,4)
  call Hotf_5pt_reduction(G2H4(3),RedSet_5(14),mass5set(:,9),  & 
G1H4(23),G1H4(24),G1H4(25),G1H4(26),G1H4(27),G1H4(28),4)
  call HG1shiftOLR(G1H4(24),16,4)
  call Hotf_5pt_reduction(G2H4(4),RedSet_5(14),mass5set(:,10),  & 
G1H4(29),G1H4(30),G1H4(31),G1H4(32),G1H4(33),G1H4(34),4)
  call HG1shiftOLR(G1H4(30),16,4)
  call Hloop_VV_S(ntryL,G2H4(5),ex5(:),G2H2(1),m3h2x2(:,1),heltab2x4(:,:,1))
  call Hotf_5pt_reduction(G2H4(6),RedSet_5(14),mass5set(:,10),  & 
G1H4(35),G1H4(36),G1H4(37),G1H4(38),G1H4(39),G1H4(40),4)
  call HG1shiftOLR(G1H4(36),8,4)
  call Hloop_QA_S(ntryL,G2H4(7),ex4(:),G2H2(2),ngPbt,m3h2x2(:,2),heltab2x4(:,:,2))
  call Hloop_QA_W(ntryL,G2H4(8),ex4(:),G2H2(3),m3h2x2(:,3),heltab2x4(:,:,3))
  call Hotf_5pt_reduction(G2H4(9),RedSet_5(4),mass5set(:,3),  & 
G1H4(41),G1H4(42),G1H4(43),G1H4(44),G1H4(45),G1H4(46),4)
  call HG1shiftOLR(G1H4(42),8,4)
  call Hotf_5pt_reduction(G2H4(10),RedSet_5(15),mass5set(:,9),  & 
G1H4(47),G1H4(48),G1H4(49),G1H4(50),G1H4(51),G1H4(52),4)
  call HG1shiftOLR(G1H4(48),16,4)
  call Hotf_5pt_reduction(G2H4(11),RedSet_5(16),mass5set(:,9),  & 
G1H4(53),G1H4(54),G1H4(55),G1H4(56),G1H4(57),G1H4(58),4)
  call HG1shiftOLR(G1H4(54),16,4)
  call Hloop_SQ_A(ntryL,G1H4(1),ex3(:),G1H2(1),ngPtb,m3h2x2(:,4),heltab2x4(:,:,4))
  call Hloop_Q_A(ntryL,G1H2(1),55,nMT,G2H2(4),n2h2(1))
  call Hotf_5pt_reduction(G2H4(12),RedSet_5(7),mass5set(:,5),  & 
G1H4(1),G1H4(59),G1H4(60),G1H4(61),G1H4(62),G1H4(63),4)
  call HG1shiftOLR(G1H4(59),8,4)
  call Hotf_5pt_reduction(G2H4(13),RedSet_5(7),mass5set(:,5),  & 
G1H4(64),G1H4(65),G1H4(66),G1H4(67),G1H4(68),G1H4(69),4)
  call HG1shiftOLR(G1H4(65),8,4)
  call Hloop_AQ_S(ntryL,G2H4(14),ex3(:),G2H2(5),ngPtb,m3h2x2(:,5),heltab2x4(:,:,5))
  call Hloop_AQ_W(ntryL,G2H4(15),ex3(:),G2H2(6),m3h2x2(:,6),heltab2x4(:,:,6))
  call Hotf_5pt_reduction(G2H4(16),RedSet_5(8),mass5set(:,3),  & 
G1H4(70),G1H4(71),G1H4(72),G1H4(73),G1H4(74),G1H4(75),4)
  call HG1shiftOLR(G1H4(71),4,4)
  call Hloop_SA_Q(ntryL,G1H4(2),ex4(:),G1H2(1),ngPbt,m3h2x2(:,7),heltab2x4(:,:,7))
  call Hloop_A_Q(ntryL,G1H2(1),59,nMT,G2H2(7),n2h2(2))
  call Hotf_5pt_reduction(G2H4(17),RedSet_5(9),mass5set(:,5),  & 
G1H4(2),G1H4(76),G1H4(77),G1H4(78),G1H4(79),G1H4(80),4)
  call HG1shiftOLR(G1H4(76),4,4)
  call Hotf_5pt_reduction(G2H4(18),RedSet_5(9),mass5set(:,5),  & 
G1H4(81),G1H4(82),G1H4(83),G1H4(84),G1H4(85),G1H4(86),4)
  call HG1shiftOLR(G1H4(82),4,4)
  call Hotf_5pt_reduction(G2H4(19),RedSet_5(17),mass5set(:,11),  & 
G1H4(87),G1H4(88),G1H4(89),G1H4(90),G1H4(91),G1H4(92),4)
  call HG1shiftOLR(G1H4(88),16,4)
  call Hotf_5pt_reduction(G2H4(20),RedSet_5(1),mass5set(:,1),  & 
G1H4(93),G1H4(94),G1H4(95),G1H4(96),G1H4(97),G1H4(98),4)
  call HG1shiftOLR(G1H4(94),8,4)
  call Hotf_5pt_reduction(G2H4(21),RedSet_5(18),mass5set(:,11),  & 
G1H4(99),G1H4(100),G1H4(101),G1H4(102),G1H4(103),G1H4(104),4)
  call HG1shiftOLR(G1H4(100),16,4)
  call Hloop_SV_V(ntryL,G2H4(22),ex5(:),G2H2(8),m3h2x2(:,8),heltab2x4(:,:,8))
  call Hotf_5pt_reduction(G2H4(23),RedSet_5(18),mass5set(:,11),  & 
G1H4(105),G1H4(106),G1H4(107),G1H4(108),G1H4(109),G1H4(110),4)
  call HG1shiftOLR(G1H4(106),2,4)
  call Hotf_5pt_reduction(G2H4(24),RedSet_5(2),mass5set(:,1),  & 
G1H4(111),G1H4(112),G1H4(113),G1H4(114),G1H4(115),G1H4(116),4)
  call HG1shiftOLR(G1H4(112),4,4)
  call Hloop_QA_W(ntryL,G2H4(84),ex4(:),G2H2(9),m3h2x2(:,9),heltab2x4(:,:,9))
  call Hotf_5pt_reduction(G2H4(26),RedSet_5(1),mass5set(:,1),  & 
G1H4(117),G1H4(118),G1H4(119),G1H4(120),G1H4(121),G1H4(122),4)
  call HG1shiftOLR(G1H4(118),8,4)
  call Hotf_5pt_reduction(G2H4(28),RedSet_5(19),mass5set(:,12),  & 
G1H4(123),G1H4(124),G1H4(125),G1H4(126),G1H4(127),G1H4(128),4)
  call HG1shiftOLR(G1H4(124),8,4)
  call Hotf_5pt_reduction(G2H4(29),RedSet_5(2),mass5set(:,1),  & 
G1H4(129),G1H4(130),G1H4(131),G1H4(132),G1H4(133),G1H4(134),4)
  call HG1shiftOLR(G1H4(130),4,4)
  call Hotf_5pt_reduction(G2H4(31),RedSet_5(20),mass5set(:,12),  & 
G1H4(135),G1H4(136),G1H4(137),G1H4(138),G1H4(139),G1H4(140),4)
  call HG1shiftOLR(G1H4(136),4,4)
  call Hloop_QA_W(ntryL,G2H4(32),ex2(:),G2H2(10),m3h2x2(:,10),heltab2x4(:,:,10))
  call Hloop_QA_W(ntryL,G2H4(34),ex2(:),G2H2(11),m3h2x2(:,11),heltab2x4(:,:,11))
  call Hloop_QA_W(ntryL,G2H4(35),ex2(:),G2H2(12),m3h2x2(:,12),heltab2x4(:,:,12))
  call Hloop_QA_W(ntryL,G2H4(38),ex2(:),G2H2(13),m3h2x2(:,13),heltab2x4(:,:,13))
  call Hloop_QA_S(ntryL,G2H4(39),ex4(:),G2H2(14),ngPbt,m3h2x2(:,14),heltab2x4(:,:,14))
  call Hloop_QA_S(ntryL,G2H4(41),ex4(:),G2H2(15),ngPbt,m3h2x2(:,15),heltab2x4(:,:,15))
  call Hloop_QA_W(ntryL,G2H4(42),ex4(:),G2H2(16),m3h2x2(:,16),heltab2x4(:,:,16))
  call Hloop_QA_W(ntryL,G2H4(45),ex4(:),G2H2(17),m3h2x2(:,17),heltab2x4(:,:,17))
  call Hotf_5pt_reduction(G2H4(46),RedSet_5(4),mass5set(:,3),  & 
G1H4(141),G1H4(142),G1H4(143),G1H4(144),G1H4(145),G1H4(146),4)
  call HG1shiftOLR(G1H4(142),8,4)
  call Hotf_5pt_reduction(G2H4(48),RedSet_5(21),mass5set(:,3),  & 
G1H4(147),G1H4(148),G1H4(149),G1H4(150),G1H4(151),G1H4(152),4)
  call HG1shiftOLR(G1H4(148),8,4)
  call Hloop_AQ_W(ntryL,G2H4(49),ex1(:),G2H2(18),m3h2x2(:,18),heltab2x4(:,:,18))
  call Hloop_AQ_W(ntryL,G2H4(51),ex1(:),G2H2(19),m3h2x2(:,19),heltab2x4(:,:,19))
  call Hloop_AQ_W(ntryL,G2H4(52),ex1(:),G2H2(20),m3h2x2(:,20),heltab2x4(:,:,20))
  call Hloop_AQ_W(ntryL,G2H4(55),ex1(:),G2H2(21),m3h2x2(:,21),heltab2x4(:,:,21))
  call Hloop_QA_W(ntryL,G2H4(56),ex2(:),G2H2(22),m3h2x2(:,22),heltab2x4(:,:,22))
  call Hloop_QA_W(ntryL,G2H4(59),ex2(:),G2H2(23),m3h2x2(:,23),heltab2x4(:,:,23))
  call Hotf_5pt_reduction(G2H4(60),RedSet_5(7),mass5set(:,5),  & 
G1H4(153),G1H4(154),G1H4(155),G1H4(156),G1H4(157),G1H4(158),4)
  call HG1shiftOLR(G1H4(154),8,4)
  call Hotf_5pt_reduction(G2H4(62),RedSet_5(21),mass5set(:,3),  & 
G1H4(159),G1H4(160),G1H4(161),G1H4(162),G1H4(163),G1H4(164),4)
  call HG1shiftOLR(G1H4(160),8,4)
  call Hloop_AQ_S(ntryL,G2H4(63),ex3(:),G2H2(24),ngPtb,m3h2x2(:,24),heltab2x4(:,:,24))
  call Hloop_AQ_S(ntryL,G2H4(65),ex3(:),G2H2(25),ngPtb,m3h2x2(:,25),heltab2x4(:,:,25))
  call Hloop_AQ_W(ntryL,G2H4(66),ex3(:),G2H2(26),m3h2x2(:,26),heltab2x4(:,:,26))
  call Hloop_AQ_W(ntryL,G2H4(69),ex3(:),G2H2(27),m3h2x2(:,27),heltab2x4(:,:,27))
  call Hotf_5pt_reduction(G2H4(70),RedSet_5(8),mass5set(:,3),  & 
G1H4(165),G1H4(166),G1H4(167),G1H4(168),G1H4(169),G1H4(170),4)
  call HG1shiftOLR(G1H4(166),4,4)
  call Hotf_5pt_reduction(G2H4(72),RedSet_5(22),mass5set(:,3),  & 
G1H4(171),G1H4(172),G1H4(173),G1H4(174),G1H4(175),G1H4(176),4)
  call HG1shiftOLR(G1H4(172),4,4)
  call Hotf_5pt_reduction(G2H4(73),RedSet_5(9),mass5set(:,5),  & 
G1H4(177),G1H4(178),G1H4(179),G1H4(180),G1H4(181),G1H4(182),4)
  call HG1shiftOLR(G1H4(178),4,4)
  call Hotf_5pt_reduction(G2H4(75),RedSet_5(22),mass5set(:,3),  & 
G1H4(183),G1H4(184),G1H4(185),G1H4(186),G1H4(187),G1H4(188),4)
  call HG1shiftOLR(G1H4(184),4,4)
  call Hloop_QA_W(ntryL,G2H4(76),ex2(:),G2H2(28),m3h2x2(:,28),heltab2x4(:,:,28))
  call Hloop_QA_W(ntryL,G2H4(79),ex2(:),G2H2(29),m3h2x2(:,29),heltab2x4(:,:,29))
  call Hloop_QA_W(ntryL,G2H4(80),ex4(:),G2H2(30),m3h2x2(:,30),heltab2x4(:,:,30))
  call Hloop_QA_W(ntryL,G2H4(83),ex4(:),G2H2(31),m3h2x2(:,31),heltab2x4(:,:,31))
  call Hloop_QA_W(ntryL,G2H4(87),ex4(:),G2H2(32),m3h2x2(:,32),heltab2x4(:,:,32))
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(123),[G1H4(122)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(135),[G1H4(134)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(147),[G1H4(146)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(159),[G1H4(158)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(171),[G1H4(170)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(183),[G1H4(182)])
  call Hloop_ZQ_A(ntryL,G1H4(11),ex3(:),G1H2(1),ngZd,m3h2x2(:,33),heltab2x4(:,:,33))
  call Hloop_Q_A(ntryL,G1H2(1),47,nMB,G2H2(33),n2h2(3))
call HGT_OLR(G1H4(12),1,1,4)
call HGT_invQ_OLR(G1H4(12),2,5,4)
  call Hloop_A_Q(ntryL,G1H4(12),-16,nMB,G2H4(25),n2h4(50))
  call Hloop_AV_Q(ntryL,G2H4(25),ex5(:),G2H2(34),m3h2x2(:,34),heltab2x4(:,:,34))
  call Hloop_ZQ_A(ntryL,G1H4(16),ex3(:),G1H2(1),ngZd,m3h2x2(:,35),heltab2x4(:,:,35))
  call Hloop_Q_A(ntryL,G1H2(1),47,nMB,G2H2(35),n2h2(4))
  call Hloop_WQ_A(ntryL,G1H4(17),ex3(:),G1H2(1),m3h2x2(:,36),heltab2x4(:,:,36))
  call Hloop_Q_A(ntryL,G1H2(1),47,nMT,G2H2(36),n2h2(5))
call HGT_OLR(G1H4(18),1,1,4)
call HGT_invQ_OLR(G1H4(18),2,5,4)
  call Hloop_A_Q(ntryL,G1H4(18),-16,nMT,G2H4(1),n2h4(51))
  call Hloop_AV_Q(ntryL,G2H4(1),ex5(:),G2H2(37),m3h2x2(:,37),heltab2x4(:,:,37))
  call Hloop_WQ_A(ntryL,G1H4(22),ex3(:),G1H2(1),m3h2x2(:,38),heltab2x4(:,:,38))
  call Hloop_Q_A(ntryL,G1H2(1),47,nMT,G2H2(38),n2h2(6))
  call Hloop_ZA_Q(ntryL,G1H4(23),ex4(:),G1H2(1),ngZd,m3h2x2(:,39),heltab2x4(:,:,39))
  call Hloop_A_Q(ntryL,G1H2(1),47,nMB,G2H2(39),n2h2(7))
call HGT_OLR(G1H4(24),1,1,4)
call HGT_invQ_OLR(G1H4(24),2,5,4)
  call Hloop_Q_A(ntryL,G1H4(24),-16,nMB,G2H4(2),n2h4(52))
  call Hloop_QV_A(ntryL,G2H4(2),ex5(:),G2H2(40),m3h2x2(:,40),heltab2x4(:,:,40))
  call Hloop_ZA_Q(ntryL,G1H4(28),ex4(:),G1H2(1),ngZd,m3h2x2(:,41),heltab2x4(:,:,41))
  call Hloop_A_Q(ntryL,G1H2(1),47,nMB,G2H2(41),n2h2(8))
  call Hloop_WA_Q(ntryL,G1H4(29),ex4(:),G1H2(1),m3h2x2(:,42),heltab2x4(:,:,42))
  call Hloop_A_Q(ntryL,G1H2(1),47,nMT,G2H2(42),n2h2(9))
call HGT_OLR(G1H4(30),1,1,4)
call HGT_invQ_OLR(G1H4(30),2,5,4)
  call Hloop_Q_A(ntryL,G1H4(30),-16,nMT,G2H4(3),n2h4(53))
  call Hloop_QV_A(ntryL,G2H4(3),ex5(:),G2H2(43),m3h2x2(:,43),heltab2x4(:,:,43))
  call Hloop_WA_Q(ntryL,G1H4(34),ex4(:),G1H2(1),m3h2x2(:,44),heltab2x4(:,:,44))
  call Hloop_A_Q(ntryL,G1H2(1),47,nMT,G2H2(44),n2h2(10))
  call Hloop_UV_W(ntryL,G1H4(35),39,ex5(:),16,G2H2(45),m3h2x2(:,45),heltab2x4(:,:,45))
call HGT_OLR(G1H4(36),1,1,4)
call HGT_invQ_OLR(G1H4(36),2,5,4)
  call Hloop_Q_A(ntryL,G1H4(36),-8,nMT,G2H4(4),n2h4(54))
  call Hloop_QA_W(ntryL,G2H4(4),ex4(:),G2H2(46),m3h2x2(:,46),heltab2x4(:,:,46))
  call Hloop_UV_W(ntryL,G1H4(40),39,ex5(:),16,G2H2(47),m3h2x2(:,47),heltab2x4(:,:,47))
  call Hloop_QV_A(ntryL,G1H4(41),ex5(:),G1H2(1),m3h2x2(:,48),heltab2x4(:,:,48))
  call Hloop_Q_A(ntryL,G1H2(1),55,nMT,G2H2(48),n2h2(11))
call HGT_OLR(G1H4(42),1,1,4)
call HGT_invQ_OLR(G1H4(42),2,5,4)
  call Hloop_SA_Q(ntryL,G1H4(42),ex4(:),G1H2(1),ngPbt,m3h2x2(:,49),heltab2x4(:,:,49))
  call Hloop_QV_A(ntryL,G1H4(46),ex5(:),G1H2(2),m3h2x2(:,50),heltab2x4(:,:,50))
  call Hloop_Q_A(ntryL,G1H2(2),55,nMT,G2H2(49),n2h2(12))
  call Hloop_ZQ_A(ntryL,G1H4(47),ex3(:),G1H2(2),ngZd,m3h2x2(:,51),heltab2x4(:,:,51))
  call Hloop_Q_A(ntryL,G1H2(2),47,nMB,G2H2(50),n2h2(13))
call HGT_OLR(G1H4(48),1,1,4)
call HGT_invQ_OLR(G1H4(48),2,5,4)
  call Hloop_A_Q(ntryL,G1H4(48),-16,nMB,G2H4(5),n2h4(56))
  call Hloop_AV_Q(ntryL,G2H4(5),ex5(:),G2H2(51),m3h2x2(:,52),heltab2x4(:,:,52))
  call Hloop_ZQ_A(ntryL,G1H4(52),ex3(:),G1H2(2),ngZd,m3h2x2(:,53),heltab2x4(:,:,53))
  call Hloop_Q_A(ntryL,G1H2(2),47,nMB,G2H2(52),n2h2(14))
  call Hloop_ZA_Q(ntryL,G1H4(53),ex4(:),G1H2(2),ngZd,m3h2x2(:,54),heltab2x4(:,:,54))
  call Hloop_A_Q(ntryL,G1H2(2),47,nMB,G2H2(53),n2h2(15))
call HGT_OLR(G1H4(54),1,1,4)
call HGT_invQ_OLR(G1H4(54),2,5,4)
  call Hloop_Q_A(ntryL,G1H4(54),-16,nMB,G2H4(6),n2h4(57))
  call Hloop_QV_A(ntryL,G2H4(6),ex5(:),G2H2(54),m3h2x2(:,55),heltab2x4(:,:,55))
  call Hloop_ZA_Q(ntryL,G1H4(58),ex4(:),G1H2(2),ngZd,m3h2x2(:,56),heltab2x4(:,:,56))
  call Hloop_A_Q(ntryL,G1H2(2),47,nMB,G2H2(55),n2h2(16))
  call Hloop_SQ_A(ntryL,G1H4(1),ex3(:),G1H2(2),ngPtb,m3h2x2(:,57),heltab2x4(:,:,57))
  call Hloop_Q_A(ntryL,G1H2(2),55,nMT,G2H2(56),n2h2(17))
call HGT_raise_alpha_OLR(G1H4(59),1,1,4)
call HGT_raise_alpha_invQ_OLR(G1H4(59),2,5,4)
  call Hloop_WA_Q(ntryL,G1H4(59),ex4(:),G1H2(2),m3h2x2(:,58),heltab2x4(:,:,58))
  call Hloop_SQ_A(ntryL,G1H4(63),ex3(:),G1H2(3),ngPtb,m3h2x2(:,59),heltab2x4(:,:,59))
  call Hloop_Q_A(ntryL,G1H2(3),55,nMT,G2H2(57),n2h2(18))
  call Hloop_WQ_A(ntryL,G1H4(64),ex3(:),G1H2(3),m3h2x2(:,60),heltab2x4(:,:,60))
  call Hloop_Q_A(ntryL,G1H2(3),55,nMT,G2H2(58),n2h2(19))
call HGT_OLR(G1H4(65),1,1,4)
call HGT_invQ_OLR(G1H4(65),2,5,4)
  call Hloop_SA_Q(ntryL,G1H4(65),ex4(:),G1H2(3),ngPbt,m3h2x2(:,61),heltab2x4(:,:,61))
  call Hloop_WQ_A(ntryL,G1H4(69),ex3(:),G1H2(4),m3h2x2(:,62),heltab2x4(:,:,62))
  call Hloop_Q_A(ntryL,G1H2(4),55,nMT,G2H2(59),n2h2(20))
  call Hloop_AV_Q(ntryL,G1H4(70),ex5(:),G1H2(4),m3h2x2(:,63),heltab2x4(:,:,63))
  call Hloop_A_Q(ntryL,G1H2(4),59,nMT,G2H2(60),n2h2(21))
call HGT_OLR(G1H4(71),1,1,4)
call HGT_invQ_OLR(G1H4(71),2,5,4)
  call Hloop_SQ_A(ntryL,G1H4(71),ex3(:),G1H2(4),ngPtb,m3h2x2(:,64),heltab2x4(:,:,64))
  call Hloop_AV_Q(ntryL,G1H4(75),ex5(:),G1H2(5),m3h2x2(:,65),heltab2x4(:,:,65))
  call Hloop_A_Q(ntryL,G1H2(5),59,nMT,G2H2(61),n2h2(22))
  call Hloop_WA_Q(ntryL,G1H4(2),ex4(:),G1H2(5),m3h2x2(:,66),heltab2x4(:,:,66))
  call Hloop_A_Q(ntryL,G1H2(5),59,nMT,G2H2(62),n2h2(23))
call HGT_OLR(G1H4(76),1,1,4)
call HGT_invQ_OLR(G1H4(76),2,5,4)
  call Hloop_SQ_A(ntryL,G1H4(76),ex3(:),G1H2(5),ngPtb,m3h2x2(:,67),heltab2x4(:,:,67))
  call Hloop_WA_Q(ntryL,G1H4(80),ex4(:),G1H2(6),m3h2x2(:,68),heltab2x4(:,:,68))
  call Hloop_A_Q(ntryL,G1H2(6),59,nMT,G2H2(63),n2h2(24))
  call Hloop_SA_Q(ntryL,G1H4(81),ex4(:),G1H2(6),ngPbt,m3h2x2(:,69),heltab2x4(:,:,69))
  call Hloop_A_Q(ntryL,G1H2(6),59,nMT,G2H2(64),n2h2(25))
call HGT_raise_alpha_OLR(G1H4(82),1,1,4)
call HGT_raise_alpha_invQ_OLR(G1H4(82),2,5,4)
  call Hloop_WQ_A(ntryL,G1H4(82),ex3(:),G1H2(6),m3h2x2(:,70),heltab2x4(:,:,70))
  call Hloop_SA_Q(ntryL,G1H4(86),ex4(:),G1H2(7),ngPbt,m3h2x2(:,71),heltab2x4(:,:,71))
  call Hloop_A_Q(ntryL,G1H2(7),59,nMT,G2H2(65),n2h2(26))
  call Hloop_WQ_A(ntryL,G1H4(87),ex1(:),G1H2(7),m3h2x2(:,72),heltab2x4(:,:,72))
  call Hloop_Q_A(ntryL,G1H2(7),47,0,G2H2(66),n2h2(27))
call HGT_OLR(G1H4(88),1,1,4)
call HGT_invQ_OLR(G1H4(88),2,5,4)
  call Hloop_A_Q(ntryL,G1H4(88),-16,0,G2H4(7),n2h4(63))
  call Hloop_AV_Q(ntryL,G2H4(7),ex5(:),G2H2(67),m3h2x2(:,73),heltab2x4(:,:,73))
  call Hloop_WQ_A(ntryL,G1H4(92),ex1(:),G1H2(7),m3h2x2(:,74),heltab2x4(:,:,74))
  call Hloop_Q_A(ntryL,G1H2(7),47,0,G2H2(68),n2h2(28))
  call Hloop_WQ_A(ntryL,G1H4(93),ex3(:),G1H2(7),m3h2x2(:,75),heltab2x4(:,:,75))
  call Hloop_Q_A(ntryL,G1H2(7),55,nMT,G2H2(69),n2h2(29))
call HGT_OLR(G1H4(94),1,1,4)
call HGT_invQ_OLR(G1H4(94),2,5,4)
  call Hloop_SA_Q(ntryL,G1H4(94),ex4(:),G1H2(7),ngPbt,m3h2x2(:,76),heltab2x4(:,:,76))
  call Hloop_WQ_A(ntryL,G1H4(98),ex3(:),G1H2(8),m3h2x2(:,77),heltab2x4(:,:,77))
  call Hloop_Q_A(ntryL,G1H2(8),55,nMT,G2H2(70),n2h2(30))
  call Hloop_WA_Q(ntryL,G1H4(99),ex2(:),G1H2(8),m3h2x2(:,78),heltab2x4(:,:,78))
  call Hloop_A_Q(ntryL,G1H2(8),47,0,G2H2(71),n2h2(31))
call HGT_OLR(G1H4(100),1,1,4)
call HGT_invQ_OLR(G1H4(100),2,5,4)
  call Hloop_Q_A(ntryL,G1H4(100),-16,0,G2H4(8),n2h4(65))
  call Hloop_QV_A(ntryL,G2H4(8),ex5(:),G2H2(72),m3h2x2(:,79),heltab2x4(:,:,79))
  call Hloop_WA_Q(ntryL,G1H4(104),ex2(:),G1H2(8),m3h2x2(:,80),heltab2x4(:,:,80))
  call Hloop_A_Q(ntryL,G1H2(8),47,0,G2H2(73),n2h2(32))
  call Hloop_UW_V(ntryL,G1H4(105),45,ex5(:),16,G2H2(74),m3h2x2(:,81),heltab2x4(:,:,81))
call HGT_OLR(G1H4(106),1,1,4)
call HGT_invQ_OLR(G1H4(106),2,5,4)
  call Hloop_Q_A(ntryL,G1H4(106),-2,0,G2H4(9),n2h4(66))
  call Hloop_QA_W(ntryL,G2H4(9),ex2(:),G2H2(75),m3h2x2(:,82),heltab2x4(:,:,82))
  call Hloop_UW_V(ntryL,G1H4(110),45,ex5(:),16,G2H2(76),m3h2x2(:,83),heltab2x4(:,:,83))
  call Hloop_WA_Q(ntryL,G1H4(111),ex4(:),G1H2(8),m3h2x2(:,84),heltab2x4(:,:,84))
  call Hloop_A_Q(ntryL,G1H2(8),59,nMT,G2H2(77),n2h2(33))
call HGT_OLR(G1H4(112),1,1,4)
call HGT_invQ_OLR(G1H4(112),2,5,4)
  call Hloop_SQ_A(ntryL,G1H4(112),ex3(:),G1H2(8),ngPtb,m3h2x2(:,85),heltab2x4(:,:,85))
  call Hloop_WA_Q(ntryL,G1H4(116),ex4(:),G1H2(9),m3h2x2(:,86),heltab2x4(:,:,86))
  call Hloop_A_Q(ntryL,G1H2(9),59,nMT,G2H2(78),n2h2(34))
  call Hloop_WQ_A(ntryL,G1H4(117),ex3(:),G1H2(9),m3h2x2(:,87),heltab2x4(:,:,87))
  call Hloop_Q_A(ntryL,G1H2(9),55,nMT,G2H2(79),n2h2(35))
call HGT_raise_alpha_OLR(G1H4(118),1,1,4)
call HGT_raise_alpha_invQ_OLR(G1H4(118),2,5,4)
  call Hloop_WA_Q(ntryL,G1H4(118),ex4(:),G1H2(9),m3h2x2(:,88),heltab2x4(:,:,88))
  call Hloop_WQ_A(ntryL,G1H4(123),ex3(:),G1H2(10),m3h2x2(:,89),heltab2x4(:,:,89))
  call Hloop_Q_A(ntryL,G1H2(10),55,nMT,G2H2(80),n2h2(36))
call HGT_raise_alpha_OLR(G1H4(124),1,1,4)
call HGT_raise_alpha_invQ_OLR(G1H4(124),2,5,4)
  call Hloop_WA_Q(ntryL,G1H4(124),ex4(:),G1H2(10),m3h2x2(:,90),heltab2x4(:,:,90))
  call Hloop_WQ_A(ntryL,G1H4(128),ex3(:),G1H2(11),m3h2x2(:,91),heltab2x4(:,:,91))
  call Hloop_Q_A(ntryL,G1H2(11),55,nMT,G2H2(81),n2h2(37))
  call Hloop_WA_Q(ntryL,G1H4(129),ex4(:),G1H2(11),m3h2x2(:,92),heltab2x4(:,:,92))
  call Hloop_A_Q(ntryL,G1H2(11),59,nMT,G2H2(82),n2h2(38))
call HGT_raise_alpha_OLR(G1H4(130),1,1,4)
call HGT_raise_alpha_invQ_OLR(G1H4(130),2,5,4)
  call Hloop_WQ_A(ntryL,G1H4(130),ex3(:),G1H2(11),m3h2x2(:,93),heltab2x4(:,:,93))
  call Hloop_WA_Q(ntryL,G1H4(135),ex4(:),G1H2(12),m3h2x2(:,94),heltab2x4(:,:,94))
  call Hloop_A_Q(ntryL,G1H2(12),59,nMT,G2H2(83),n2h2(39))
call HGT_raise_alpha_OLR(G1H4(136),1,1,4)
call HGT_raise_alpha_invQ_OLR(G1H4(136),2,5,4)
  call Hloop_WQ_A(ntryL,G1H4(136),ex3(:),G1H2(12),m3h2x2(:,95),heltab2x4(:,:,95))
  call Hloop_WA_Q(ntryL,G1H4(140),ex4(:),G1H2(13),m3h2x2(:,96),heltab2x4(:,:,96))
  call Hloop_A_Q(ntryL,G1H2(13),59,nMT,G2H2(84),n2h2(40))
  call Hloop_QV_A(ntryL,G1H4(141),ex5(:),G1H2(13),m3h2x2(:,97),heltab2x4(:,:,97))
  call Hloop_Q_A(ntryL,G1H2(13),55,nMT,G2H2(85),n2h2(41))
call HGT_raise_alpha_OLR(G1H4(142),1,1,4)
call HGT_raise_alpha_invQ_OLR(G1H4(142),2,5,4)
  call Hloop_WA_Q(ntryL,G1H4(142),ex4(:),G1H2(13),m3h2x2(:,98),heltab2x4(:,:,98))
  call Hloop_QV_A(ntryL,G1H4(147),ex5(:),G1H2(14),m3h2x2(:,99),heltab2x4(:,:,99))
  call Hloop_Q_A(ntryL,G1H2(14),55,nMT,G2H2(86),n2h2(42))
call HGT_raise_alpha_OLR(G1H4(148),1,1,4)
call HGT_raise_alpha_invQ_OLR(G1H4(148),2,5,4)
  call Hloop_WA_Q(ntryL,G1H4(148),ex4(:),G1H2(14),m3h2x2(:,100),heltab2x4(:,:,100))
  call Hloop_QV_A(ntryL,G1H4(152),ex5(:),G1H2(15),m3h2x2(:,101),heltab2x4(:,:,101))
  call Hloop_Q_A(ntryL,G1H2(15),55,nMT,G2H2(87),n2h2(43))
  call Hloop_WQ_A(ntryL,G1H4(153),ex3(:),G1H2(15),m3h2x2(:,102),heltab2x4(:,:,102))
  call Hloop_Q_A(ntryL,G1H2(15),55,nMT,G2H2(88),n2h2(44))
call HGT_raise_alpha_OLR(G1H4(154),1,1,4)
call HGT_raise_alpha_invQ_OLR(G1H4(154),2,5,4)
  call Hloop_WA_Q(ntryL,G1H4(154),ex4(:),G1H2(15),m3h2x2(:,103),heltab2x4(:,:,103))
  call Hloop_WQ_A(ntryL,G1H4(159),ex3(:),G1H2(16),m3h2x2(:,104),heltab2x4(:,:,104))
  call Hloop_Q_A(ntryL,G1H2(16),55,nMT,G2H2(89),n2h2(45))
call HGT_raise_alpha_OLR(G1H4(160),1,1,4)
call HGT_raise_alpha_invQ_OLR(G1H4(160),2,5,4)
  call Hloop_WA_Q(ntryL,G1H4(160),ex4(:),G1H2(16),m3h2x2(:,105),heltab2x4(:,:,105))
  call Hloop_WQ_A(ntryL,G1H4(164),ex3(:),G1H2(17),m3h2x2(:,106),heltab2x4(:,:,106))
  call Hloop_Q_A(ntryL,G1H2(17),55,nMT,G2H2(90),n2h2(46))
  call Hloop_AV_Q(ntryL,G1H4(165),ex5(:),G1H2(17),m3h2x2(:,107),heltab2x4(:,:,107))
  call Hloop_A_Q(ntryL,G1H2(17),59,nMT,G2H2(91),n2h2(47))
call HGT_raise_alpha_OLR(G1H4(166),1,1,4)
call HGT_raise_alpha_invQ_OLR(G1H4(166),2,5,4)
  call Hloop_WQ_A(ntryL,G1H4(166),ex3(:),G1H2(17),m3h2x2(:,108),heltab2x4(:,:,108))
  call Hloop_AV_Q(ntryL,G1H4(171),ex5(:),G1H2(18),m3h2x2(:,109),heltab2x4(:,:,109))
  call Hloop_A_Q(ntryL,G1H2(18),59,nMT,G2H2(92),n2h2(48))
call HGT_raise_alpha_OLR(G1H4(172),1,1,4)
call HGT_raise_alpha_invQ_OLR(G1H4(172),2,5,4)
  call Hloop_WQ_A(ntryL,G1H4(172),ex3(:),G1H2(18),m3h2x2(:,110),heltab2x4(:,:,110))
  call Hloop_AV_Q(ntryL,G1H4(176),ex5(:),G1H2(19),m3h2x2(:,111),heltab2x4(:,:,111))
  call Hloop_A_Q(ntryL,G1H2(19),59,nMT,G2H2(93),n2h2(49))
  call Hloop_WA_Q(ntryL,G1H4(177),ex4(:),G1H2(19),m3h2x2(:,112),heltab2x4(:,:,112))
  call Hloop_A_Q(ntryL,G1H2(19),59,nMT,G2H2(94),n2h2(50))
call HGT_raise_alpha_OLR(G1H4(178),1,1,4)
call HGT_raise_alpha_invQ_OLR(G1H4(178),2,5,4)
  call Hloop_WQ_A(ntryL,G1H4(178),ex3(:),G1H2(19),m3h2x2(:,113),heltab2x4(:,:,113))
  call Hloop_WA_Q(ntryL,G1H4(183),ex4(:),G1H2(20),m3h2x2(:,114),heltab2x4(:,:,114))
  call Hloop_A_Q(ntryL,G1H2(20),59,nMT,G2H2(95),n2h2(51))
call HGT_raise_alpha_OLR(G1H4(184),1,1,4)
call HGT_raise_alpha_invQ_OLR(G1H4(184),2,5,4)
  call Hloop_WQ_A(ntryL,G1H4(184),ex3(:),G1H2(20),m3h2x2(:,115),heltab2x4(:,:,115))
  call Hloop_WA_Q(ntryL,G1H4(188),ex4(:),G1H2(21),m3h2x2(:,116),heltab2x4(:,:,116))
  call Hloop_A_Q(ntryL,G1H2(21),59,nMT,G2H2(96),n2h2(52))
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(58),[G2H2(4)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(62),[G2H2(7)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(74),[G2H2(8)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(88),[G2H2(56)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(94),[G2H2(64)])
  call Hotf_5pt_reduction(G2H2(1),RedSet_5(14),mass5set(:,10),  & 
G1H2(21),G1H2(22),G1H2(23),G1H2(24),G1H2(25),G1H2(26),2)
  call HG1shiftOLR(G1H2(22),8,2)
  call Hotf_5pt_reduction(G2H2(2),RedSet_5(4),mass5set(:,3),  & 
G1H2(27),G1H2(28),G1H2(29),G1H2(30),G1H2(31),G1H2(32),2)
  call HG1shiftOLR(G1H2(28),16,2)
  call Hcheck_last_VV_S(ntryL,l_switch,G2H2(3),ex5(:),G2tensor(1),m3h2x1(:,1),heltab2x2(:,:,1))
  call Hcheck_last_QA_S(ntryL,l_switch,G2H2(58),ex4(:),G2tensor(2),ngPbt,m3h2x1(:,2),heltab2x2(:,:,2))
  call Hotf_5pt_reduction(G2H2(5),RedSet_5(8),mass5set(:,3),  & 
G1H2(33),G1H2(34),G1H2(35),G1H2(36),G1H2(37),G1H2(38),2)
  call HG1shiftOLR(G1H2(34),16,2)
  call Hcheck_last_VV_S(ntryL,l_switch,G2H2(6),ex5(:),G2tensor(3),m3h2x1(:,3),heltab2x2(:,:,3))
  call Hcheck_last_AQ_S(ntryL,l_switch,G2H2(62),ex3(:),G2tensor(4),ngPtb,m3h2x1(:,4),heltab2x2(:,:,4))
  call Hotf_5pt_reduction(G2H2(74),RedSet_5(18),mass5set(:,11),  & 
G1H2(39),G1H2(40),G1H2(41),G1H2(42),G1H2(43),G1H2(44),2)
  call HG1shiftOLR(G1H2(40),2,2)
  call Hotf_5pt_reduction(G2H2(9),RedSet_5(12),mass5set(:,8),  & 
G1H2(45),G1H2(46),G1H2(47),G1H2(48),G1H2(49),G1H2(50),2)
  call HG1shiftOLR(G1H2(46),2,2)
  call Hcheck_last_VV_S(ntryL,l_switch,G2H2(10),ex5(:),G2tensor(5),m3h2x1(:,5),heltab2x2(:,:,5))
  call Hotf_5pt_reduction(G2H2(12),RedSet_5(3),mass5set(:,2),  & 
G1H2(51),G1H2(52),G1H2(53),G1H2(54),G1H2(55),G1H2(56),2)
  call HG1shiftOLR(G1H2(52),16,2)
  call Hcheck_last_SV_V(ntryL,l_switch,G2H2(14),ex5(:),G2tensor(6),m3h2x1(:,6),heltab2x2(:,:,6))
  call Hotf_5pt_reduction(G2H2(16),RedSet_5(4),mass5set(:,3),  & 
G1H2(57),G1H2(58),G1H2(59),G1H2(60),G1H2(61),G1H2(62),2)
  call HG1shiftOLR(G1H2(58),16,2)
  call Hcheck_last_VV_S(ntryL,l_switch,G2H2(18),ex5(:),G2tensor(7),m3h2x1(:,7),heltab2x2(:,:,7))
  call Hotf_5pt_reduction(G2H2(20),RedSet_5(5),mass5set(:,2),  & 
G1H2(63),G1H2(64),G1H2(65),G1H2(66),G1H2(67),G1H2(68),2)
  call HG1shiftOLR(G1H2(64),16,2)
  call Hotf_5pt_reduction(G2H2(22),RedSet_5(6),mass5set(:,4),  & 
G1H2(69),G1H2(70),G1H2(71),G1H2(72),G1H2(73),G1H2(74),2)
  call HG1shiftOLR(G1H2(70),8,2)
  call Hcheck_last_SV_V(ntryL,l_switch,G2H2(24),ex5(:),G2tensor(8),m3h2x1(:,8),heltab2x2(:,:,8))
  call Hotf_5pt_reduction(G2H2(26),RedSet_5(8),mass5set(:,3),  & 
G1H2(75),G1H2(76),G1H2(77),G1H2(78),G1H2(79),G1H2(80),2)
  call HG1shiftOLR(G1H2(76),16,2)
  call Hotf_5pt_reduction(G2H2(28),RedSet_5(10),mass5set(:,6),  & 
G1H2(81),G1H2(82),G1H2(83),G1H2(84),G1H2(85),G1H2(86),2)
  call HG1shiftOLR(G1H2(82),8,2)
  call Hotf_5pt_reduction(G2H2(30),RedSet_5(11),mass5set(:,7),  & 
G1H2(87),G1H2(88),G1H2(89),G1H2(90),G1H2(91),G1H2(92),2)
  call HG1shiftOLR(G1H2(88),2,2)
  call Hotf_5pt_reduction(G2H2(33),RedSet_5(13),mass5set(:,9),  & 
G1H2(93),G1H2(94),G1H2(95),G1H2(96),G1H2(97),G1H2(98),2)
  call HG1shiftOLR(G1H2(94),16,2)
  call Hotf_5pt_reduction(G2H2(36),RedSet_5(13),mass5set(:,10),  & 
G1H2(99),G1H2(100),G1H2(101),G1H2(102),G1H2(103),G1H2(104),2)
  call HG1shiftOLR(G1H2(100),16,2)
  call Hotf_5pt_reduction(G2H2(39),RedSet_5(14),mass5set(:,9),  & 
G1H2(105),G1H2(106),G1H2(107),G1H2(108),G1H2(109),G1H2(110),2)
  call HG1shiftOLR(G1H2(106),16,2)
  call Hotf_5pt_reduction(G2H2(42),RedSet_5(14),mass5set(:,10),  & 
G1H2(111),G1H2(112),G1H2(113),G1H2(114),G1H2(115),G1H2(116),2)
  call HG1shiftOLR(G1H2(112),16,2)
  call Hotf_5pt_reduction(G2H2(45),RedSet_5(14),mass5set(:,10),  & 
G1H2(117),G1H2(118),G1H2(119),G1H2(120),G1H2(121),G1H2(122),2)
  call HG1shiftOLR(G1H2(118),8,2)
  call Hcheck_last_QA_S(ntryL,l_switch,G2H2(48),ex4(:),G2tensor(9),ngPbt,m3h2x1(:,9),heltab2x2(:,:,9))
  call Hotf_5pt_reduction(G2H2(50),RedSet_5(15),mass5set(:,9),  & 
G1H2(123),G1H2(124),G1H2(125),G1H2(126),G1H2(127),G1H2(128),2)
  call HG1shiftOLR(G1H2(124),16,2)
  call Hotf_5pt_reduction(G2H2(53),RedSet_5(16),mass5set(:,9),  & 
G1H2(129),G1H2(130),G1H2(131),G1H2(132),G1H2(133),G1H2(134),2)
  call HG1shiftOLR(G1H2(130),16,2)
  call Hcheck_last_QA_W(ntryL,l_switch,G2H2(88),ex4(:),G2tensor(10),m3h2x1(:,10),heltab2x2(:,:,10))
  call Hcheck_last_AQ_S(ntryL,l_switch,G2H2(60),ex3(:),G2tensor(11),ngPtb,m3h2x1(:,11),heltab2x2(:,:,11))
  call Hcheck_last_AQ_W(ntryL,l_switch,G2H2(94),ex3(:),G2tensor(12),m3h2x1(:,12),heltab2x2(:,:,12))
  call Hotf_5pt_reduction(G2H2(66),RedSet_5(17),mass5set(:,11),  & 
G1H2(135),G1H2(136),G1H2(137),G1H2(138),G1H2(139),G1H2(140),2)
  call HG1shiftOLR(G1H2(136),16,2)
  call Hcheck_last_QA_S(ntryL,l_switch,G2H2(69),ex4(:),G2tensor(13),ngPbt,m3h2x1(:,13),heltab2x2(:,:,13))
  call Hotf_5pt_reduction(G2H2(71),RedSet_5(18),mass5set(:,11),  & 
G1H2(141),G1H2(142),G1H2(143),G1H2(144),G1H2(145),G1H2(146),2)
  call HG1shiftOLR(G1H2(142),16,2)
  call Hcheck_last_AQ_S(ntryL,l_switch,G2H2(77),ex3(:),G2tensor(14),ngPtb,m3h2x1(:,14),heltab2x2(:,:,14))
  call Hcheck_last_QA_W(ntryL,l_switch,G2H2(79),ex4(:),G2tensor(15),m3h2x1(:,15),heltab2x2(:,:,15))
  call Hcheck_last_AQ_W(ntryL,l_switch,G2H2(82),ex3(:),G2tensor(16),m3h2x1(:,16),heltab2x2(:,:,16))
  call Hcheck_last_QA_W(ntryL,l_switch,G2H2(85),ex4(:),G2tensor(17),m3h2x1(:,17),heltab2x2(:,:,17))
  call Hcheck_last_AQ_W(ntryL,l_switch,G2H2(91),ex3(:),G2tensor(18),m3h2x1(:,18),heltab2x2(:,:,18))
  call Hloop_SA_Q(ntryL,G1H2(21),ex4(:),G1H1(1),ngPbt,m3h2x1(:,19),heltab2x2(:,:,19))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,nMT,G2tensor(19),n2h1(1))
  call Hloop_SA_Q(ntryL,G1H2(22),ex4(:),G1H1(1),ngPbt,m3h2x1(:,20),heltab2x2(:,:,20))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),8,nMT,G2tensor(20),n2h1(2))
  call Hcheck_last_SV_T(ntryL,l_switch,G1H2(27),47,ex5(:),16,G2tensor(21),m3h2x1(:,21),heltab2x2(:,:,21))
  call Hcheck_last_SV_T(ntryL,l_switch,G1H2(28),0,ex5(:),16,G2tensor(22),m3h2x1(:,22),heltab2x2(:,:,22))
  call Hcheck_last_TV_S(ntryL,l_switch,G1H2(33),47,ex5(:),16,G2tensor(23),m3h2x1(:,23),heltab2x2(:,:,23))
  call Hcheck_last_TV_S(ntryL,l_switch,G1H2(34),0,ex5(:),16,G2tensor(24),m3h2x1(:,24),heltab2x2(:,:,24))
  call Hloop_WA_Q(ntryL,G1H2(39),ex2(:),G1H1(1),m3h2x1(:,25),heltab2x2(:,:,25))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,0,G2tensor(25),n2h1(5))
  call Hloop_WA_Q(ntryL,G1H2(40),ex2(:),G1H1(1),m3h2x1(:,26),heltab2x2(:,:,26))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),2,0,G2tensor(26),n2h1(6))
  call Hloop_WA_Q(ntryL,G1H2(45),ex2(:),G1H1(1),m3h2x1(:,27),heltab2x2(:,:,27))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,0,G2tensor(27),n2h1(7))
  call Hloop_WA_Q(ntryL,G1H2(46),ex2(:),G1H1(1),m3h2x1(:,28),heltab2x2(:,:,28))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),2,0,G2tensor(28),n2h1(8))
  call Hcheck_last_UV_W(ntryL,l_switch,G1H2(51),47,ex5(:),16,G2tensor(29),m3h2x1(:,29),heltab2x2(:,:,29))
  call Hcheck_last_UV_W(ntryL,l_switch,G1H2(52),0,ex5(:),16,G2tensor(30),m3h2x1(:,30),heltab2x2(:,:,30))
  call Hcheck_last_UW_V(ntryL,l_switch,G1H2(57),47,ex5(:),16,G2tensor(31),m3h2x1(:,31),heltab2x2(:,:,31))
  call Hcheck_last_UW_V(ntryL,l_switch,G1H2(58),0,ex5(:),16,G2tensor(32),m3h2x1(:,32),heltab2x2(:,:,32))
  call Hcheck_last_UW_V(ntryL,l_switch,G1H2(63),47,ex5(:),16,G2tensor(33),m3h2x1(:,33),heltab2x2(:,:,33))
  call Hcheck_last_UW_V(ntryL,l_switch,G1H2(64),0,ex5(:),16,G2tensor(34),m3h2x1(:,34),heltab2x2(:,:,34))
  call Hloop_WA_Q(ntryL,G1H2(69),ex4(:),G1H1(1),m3h2x1(:,35),heltab2x2(:,:,35))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,nMT,G2tensor(35),n2h1(12))
  call Hloop_WA_Q(ntryL,G1H2(70),ex4(:),G1H1(1),m3h2x1(:,36),heltab2x2(:,:,36))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),8,nMT,G2tensor(36),n2h1(13))
  call Hcheck_last_UV_W(ntryL,l_switch,G1H2(75),47,ex5(:),16,G2tensor(37),m3h2x1(:,37),heltab2x2(:,:,37))
  call Hcheck_last_UV_W(ntryL,l_switch,G1H2(76),0,ex5(:),16,G2tensor(38),m3h2x1(:,38),heltab2x2(:,:,38))
  call Hloop_WA_Q(ntryL,G1H2(81),ex4(:),G1H1(1),m3h2x1(:,39),heltab2x2(:,:,39))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,nMT,G2tensor(39),n2h1(15))
  call Hloop_WA_Q(ntryL,G1H2(82),ex4(:),G1H1(1),m3h2x1(:,40),heltab2x2(:,:,40))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),8,nMT,G2tensor(40),n2h1(16))
  call Hloop_WA_Q(ntryL,G1H2(87),ex2(:),G1H1(1),m3h2x1(:,41),heltab2x2(:,:,41))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,0,G2tensor(41),n2h1(17))
  call Hloop_WA_Q(ntryL,G1H2(88),ex2(:),G1H1(1),m3h2x1(:,42),heltab2x2(:,:,42))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),2,0,G2tensor(42),n2h1(18))
  call Hloop_QV_A(ntryL,G1H2(93),ex5(:),G1H1(1),m3h2x1(:,43),heltab2x2(:,:,43))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,nMB,G2tensor(43),n2h1(19))
  call Hloop_QV_A(ntryL,G1H2(94),ex5(:),G1H1(1),m3h2x1(:,44),heltab2x2(:,:,44))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),16,nMB,G2tensor(44),n2h1(20))
  call Hloop_QV_A(ntryL,G1H2(99),ex5(:),G1H1(1),m3h2x1(:,45),heltab2x2(:,:,45))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,nMT,G2tensor(45),n2h1(21))
  call Hloop_QV_A(ntryL,G1H2(100),ex5(:),G1H1(1),m3h2x1(:,46),heltab2x2(:,:,46))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),16,nMT,G2tensor(46),n2h1(22))
  call Hloop_AV_Q(ntryL,G1H2(105),ex5(:),G1H1(1),m3h2x1(:,47),heltab2x2(:,:,47))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,nMB,G2tensor(47),n2h1(23))
  call Hloop_AV_Q(ntryL,G1H2(106),ex5(:),G1H1(1),m3h2x1(:,48),heltab2x2(:,:,48))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),16,nMB,G2tensor(48),n2h1(24))
  call Hloop_AV_Q(ntryL,G1H2(111),ex5(:),G1H1(1),m3h2x1(:,49),heltab2x2(:,:,49))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,nMT,G2tensor(49),n2h1(25))
  call Hloop_AV_Q(ntryL,G1H2(112),ex5(:),G1H1(1),m3h2x1(:,50),heltab2x2(:,:,50))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),16,nMT,G2tensor(50),n2h1(26))
  call Hloop_WA_Q(ntryL,G1H2(117),ex4(:),G1H1(1),m3h2x1(:,51),heltab2x2(:,:,51))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,nMT,G2tensor(51),n2h1(27))
  call Hloop_WA_Q(ntryL,G1H2(118),ex4(:),G1H1(1),m3h2x1(:,52),heltab2x2(:,:,52))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),8,nMT,G2tensor(52),n2h1(28))
  call Hloop_QV_A(ntryL,G1H2(123),ex5(:),G1H1(1),m3h2x1(:,53),heltab2x2(:,:,53))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,nMB,G2tensor(53),n2h1(29))
  call Hloop_QV_A(ntryL,G1H2(124),ex5(:),G1H1(1),m3h2x1(:,54),heltab2x2(:,:,54))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),16,nMB,G2tensor(54),n2h1(30))
  call Hloop_AV_Q(ntryL,G1H2(129),ex5(:),G1H1(1),m3h2x1(:,55),heltab2x2(:,:,55))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,nMB,G2tensor(55),n2h1(31))
  call Hloop_AV_Q(ntryL,G1H2(130),ex5(:),G1H1(1),m3h2x1(:,56),heltab2x2(:,:,56))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),16,nMB,G2tensor(56),n2h1(32))
  call Hloop_QV_A(ntryL,G1H2(135),ex5(:),G1H1(1),m3h2x1(:,57),heltab2x2(:,:,57))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(57),n2h1(33))
  call Hloop_QV_A(ntryL,G1H2(136),ex5(:),G1H1(1),m3h2x1(:,58),heltab2x2(:,:,58))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),16,0,G2tensor(58),n2h1(34))
  call Hloop_AV_Q(ntryL,G1H2(141),ex5(:),G1H1(1),m3h2x1(:,59),heltab2x2(:,:,59))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,0,G2tensor(59),n2h1(35))
  call Hloop_AV_Q(ntryL,G1H2(142),ex5(:),G1H1(1),m3h2x1(:,60),heltab2x2(:,:,60))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),16,0,G2tensor(60),n2h1(36))
  call ol_merge_tensors(G2tensor(31),[G2tensor(21),G2tensor(6),G2tensor(1)])
  call ol_merge_tensors(G2tensor(10),[G2tensor(2)])
  call ol_merge_tensors(G2tensor(37),[G2tensor(23),G2tensor(8),G2tensor(3)])
  call ol_merge_tensors(G2tensor(12),[G2tensor(4)])
  call ol_merge_tensors(G2tensor(29),[G2tensor(5)])
  call ol_merge_tensors(G2tensor(33),[G2tensor(7)])
  call ol_merge_tensors(G2tensor(17),[G2tensor(9)])
  call ol_merge_tensors(G2tensor(18),[G2tensor(11)])
  call ol_merge_tensors(G2tensor(15),[G2tensor(13)])
  call ol_merge_tensors(G2tensor(16),[G2tensor(14)])
  call ol_merge_tensors(G2tensor(51),[G2tensor(19)])
  call Hotf_5pt_reduction_last(G2tensor(31),RedSet_5(4),mass5set(:,3),  & 
G1tensor(1),G1tensor(2),G1tensor(3),G1tensor(4),G1tensor(5),G1tensor(6))
  call G_TensorShift(G1tensor(2),16)
  call Hotf_5pt_reduction_last(G2tensor(10),RedSet_5(7),mass5set(:,5),  & 
G1tensor(7),G1tensor(8),G1tensor(9),G1tensor(10),G1tensor(11),G1tensor(12))
  call G_TensorShift(G1tensor(8),8)
  call Hotf_5pt_reduction_last(G2tensor(37),RedSet_5(8),mass5set(:,3),  & 
G1tensor(13),G1tensor(14),G1tensor(15),G1tensor(16),G1tensor(17),G1tensor(18))
  call G_TensorShift(G1tensor(14),16)
  call Hotf_5pt_reduction_last(G2tensor(12),RedSet_5(9),mass5set(:,5),  & 
G1tensor(19),G1tensor(20),G1tensor(21),G1tensor(22),G1tensor(23),G1tensor(24))
  call G_TensorShift(G1tensor(20),4)
  call Hotf_5pt_reduction_last(G2tensor(29),RedSet_5(3),mass5set(:,2),  & 
G1tensor(25),G1tensor(26),G1tensor(27),G1tensor(28),G1tensor(29),G1tensor(30))
  call G_TensorShift(G1tensor(26),16)
  call Hotf_5pt_reduction_last(G2tensor(33),RedSet_5(5),mass5set(:,2),  & 
G1tensor(31),G1tensor(32),G1tensor(33),G1tensor(34),G1tensor(35),G1tensor(36))
  call G_TensorShift(G1tensor(32),16)
  call Hotf_5pt_reduction_last(G2tensor(17),RedSet_5(4),mass5set(:,3),  & 
G1tensor(37),G1tensor(38),G1tensor(39),G1tensor(40),G1tensor(41),G1tensor(42))
  call G_TensorShift(G1tensor(38),8)
  call Hotf_5pt_reduction_last(G2tensor(18),RedSet_5(8),mass5set(:,3),  & 
G1tensor(43),G1tensor(44),G1tensor(45),G1tensor(46),G1tensor(47),G1tensor(48))
  call G_TensorShift(G1tensor(44),4)
  call Hotf_5pt_reduction_last(G2tensor(15),RedSet_5(1),mass5set(:,1),  & 
G1tensor(49),G1tensor(50),G1tensor(51),G1tensor(52),G1tensor(53),G1tensor(54))
  call G_TensorShift(G1tensor(50),8)
  call Hotf_5pt_reduction_last(G2tensor(16),RedSet_5(2),mass5set(:,1),  & 
G1tensor(55),G1tensor(56),G1tensor(57),G1tensor(58),G1tensor(59),G1tensor(60))
  call G_TensorShift(G1tensor(56),4)
  call Hotf_5pt_reduction_last(G2tensor(51),RedSet_5(14),mass5set(:,10),  & 
G1tensor(61),G1tensor(62),G1tensor(63),G1tensor(64),G1tensor(65),G1tensor(66))
  call G_TensorShift(G1tensor(62),8)
  call Hotf_5pt_reduction_last(G2tensor(25),RedSet_5(18),mass5set(:,11),  & 
G1tensor(67),G1tensor(68),G1tensor(69),G1tensor(70),G1tensor(71),G1tensor(72))
  call G_TensorShift(G1tensor(68),2)
  call Hotf_5pt_reduction_last(G2tensor(27),RedSet_5(12),mass5set(:,8),  & 
G1tensor(73),G1tensor(74),G1tensor(75),G1tensor(76),G1tensor(77),G1tensor(78))
  call G_TensorShift(G1tensor(74),2)
  call Hotf_5pt_reduction_last(G2tensor(35),RedSet_5(6),mass5set(:,4),  & 
G1tensor(79),G1tensor(80),G1tensor(81),G1tensor(82),G1tensor(83),G1tensor(84))
  call G_TensorShift(G1tensor(80),8)
  call Hotf_5pt_reduction_last(G2tensor(39),RedSet_5(10),mass5set(:,6),  & 
G1tensor(85),G1tensor(86),G1tensor(87),G1tensor(88),G1tensor(89),G1tensor(90))
  call G_TensorShift(G1tensor(86),8)
  call Hotf_5pt_reduction_last(G2tensor(41),RedSet_5(11),mass5set(:,7),  & 
G1tensor(91),G1tensor(92),G1tensor(93),G1tensor(94),G1tensor(95),G1tensor(96))
  call G_TensorShift(G1tensor(92),2)
  call Hotf_5pt_reduction_last(G2tensor(43),RedSet_5(13),mass5set(:,9),  & 
G1tensor(97),G1tensor(98),G1tensor(99),G1tensor(100),G1tensor(101),G1tensor(102))
  call G_TensorShift(G1tensor(98),16)
  call Hotf_5pt_reduction_last(G2tensor(45),RedSet_5(13),mass5set(:,10),  & 
G1tensor(103),G1tensor(104),G1tensor(105),G1tensor(106),G1tensor(107),G1tensor(108))
  call G_TensorShift(G1tensor(104),16)
  call Hotf_5pt_reduction_last(G2tensor(47),RedSet_5(14),mass5set(:,9),  & 
G1tensor(109),G1tensor(110),G1tensor(111),G1tensor(112),G1tensor(113),G1tensor(114))
  call G_TensorShift(G1tensor(110),16)
  call Hotf_5pt_reduction_last(G2tensor(49),RedSet_5(14),mass5set(:,10),  & 
G1tensor(115),G1tensor(116),G1tensor(117),G1tensor(118),G1tensor(119),G1tensor(120))
  call G_TensorShift(G1tensor(116),16)
  call Hotf_5pt_reduction_last(G2tensor(53),RedSet_5(15),mass5set(:,9),  & 
G1tensor(121),G1tensor(122),G1tensor(123),G1tensor(124),G1tensor(125),G1tensor(126))
  call G_TensorShift(G1tensor(122),16)
  call Hotf_5pt_reduction_last(G2tensor(55),RedSet_5(16),mass5set(:,9),  & 
G1tensor(127),G1tensor(128),G1tensor(129),G1tensor(130),G1tensor(131),G1tensor(132))
  call G_TensorShift(G1tensor(128),16)
  call Hotf_5pt_reduction_last(G2tensor(57),RedSet_5(17),mass5set(:,11),  & 
G1tensor(133),G1tensor(134),G1tensor(135),G1tensor(136),G1tensor(137),G1tensor(138))
  call G_TensorShift(G1tensor(134),16)
  call Hotf_5pt_reduction_last(G2tensor(59),RedSet_5(18),mass5set(:,11),  & 
G1tensor(139),G1tensor(140),G1tensor(141),G1tensor(142),G1tensor(143),G1tensor(144))
  call G_TensorShift(G1tensor(140),16)
  call ol_merge_tensors(T1sum(1),[G1tensor(1)])
  call ol_merge_tensors(T1sum(2),[G1tensor(7)])
  call ol_merge_tensors(T1sum(3),[G1tensor(13)])
  call ol_merge_tensors(T1sum(4),[G1tensor(19)])
  call ol_merge_tensors(T1sum(5),[G1tensor(25)])
  call ol_merge_tensors(T1sum(6),[G1tensor(31)])
  call ol_merge_tensors(T1sum(7),[G1tensor(37)])
  call ol_merge_tensors(T1sum(8),[G1tensor(43)])
  call ol_merge_tensors(T1sum(9),[G1tensor(49)])
  call ol_merge_tensors(T1sum(10),[G1tensor(55)])
  call ol_merge_tensors(T1sum(11),[G1tensor(61)])
  call ol_merge_tensors(T1sum(12),[G1tensor(67)])
  call ol_merge_tensors(T1sum(13),[G1tensor(73)])
  call ol_merge_tensors(T1sum(14),[G1tensor(79)])
  call ol_merge_tensors(T1sum(15),[G1tensor(85)])
  call ol_merge_tensors(T1sum(16),[G1tensor(91)])
  call ol_merge_tensors(T1sum(17),[G1tensor(97)])
  call ol_merge_tensors(T1sum(18),[G1tensor(103)])
  call ol_merge_tensors(T1sum(19),[G1tensor(109)])
  call ol_merge_tensors(T1sum(20),[G1tensor(115)])
  call ol_merge_tensors(T1sum(21),[G1tensor(121)])
  call ol_merge_tensors(T1sum(22),[G1tensor(127)])
  call ol_merge_tensors(T1sum(23),[G1tensor(133)])
  call ol_merge_tensors(T1sum(24),[G1tensor(139)])
  Gcoeff(:)%j = (-(c(12)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(51),h0tab(:,51),[48,2,1,4,8],[nMW,0,nMW,nMT,nMW],6,0)
  call Hloop_VWW_V(ntryL,G0H64(1),ex6(:),ex5(:),G0H16(1),m4h2x2x16(:,1),heltab3x64(:,:,1))
  Gcoeff(:)%j = (-(c(12)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(52),h0tab(:,52),[48,1,2,8,4],[nMW,0,nMW,nMT,nMW],6,0)
  call Hloop_VWW_V(ntryL,G0H64(1),ex6(:),ex5(:),G0H16(2),m4h2x2x16(:,2),heltab3x64(:,:,2))
  Gcoeff(:)%j = (-(c(71)*M(1,:)%j)) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(53),h0tab(:,53),[32,3,16,4,8],[nMB,nMB,nMB,nMH,nMB],5,1,wf4(:,1))
  call Hloop_AV_Q(ntryL,G0H64(1),ex6(:),G0H32(17),m3h2x32(:,51),heltab2x64(:,:,51))
  call Hloop_A_Q(ntryL,G0H32(17),32,nMB,G1H32(1),n2h32(19))
  Gcoeff(:)%j = (c(71)*M(1,:)%j) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(54),h0tab(:,54),[32,3,16,4,8],[nMB,nMB,nMB,nMZ,nMB],5,1,wf4(:,1))
  call Hloop_AV_Q(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,52),heltab2x64(:,:,52))
  call Hloop_A_Q(ntryL,G0H32(1),32,nMB,G1H32(2),n2h32(20))
  Gcoeff(:)%j = (c(67)*M(1,:)%j) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(55),h0tab(:,55),[32,3,16,4,8],[nMT,nMT,nMT,nMW,nMT],5,1,wf4(:,1))
  call Hloop_AV_Q(ntryL,G0H64(1),ex6(:),G0H32(2),m3h2x32(:,53),heltab2x64(:,:,53))
  call Hloop_A_Q(ntryL,G0H32(2),32,nMT,G1H32(3),n2h32(21))
  Gcoeff(:)%j = (-(c(138)*M(1,:)%j)) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(56),h0tab(:,56),[32,3,16,4,8],[nMW,nMW,nMW,nMT,nMW],5,1,wf4(:,1))
  call Hloop_SV_T(ntryL,G0H64(1),0,ex6(:),32,G1H32(4),m3h2x32(:,54),heltab2x64(:,:,54))
  Gcoeff(:)%j = (c(1)*M(1,:)%j) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(57),h0tab(:,57),[32,3,16,4,8],[nMB,nMB,nMB,0,nMB],5,1,wf4(:,1))
  call Hloop_AV_Q(ntryL,G0H64(1),ex6(:),G0H32(3),m3h2x32(:,55),heltab2x64(:,:,55))
  call Hloop_A_Q(ntryL,G0H32(3),32,nMB,G1H32(5),n2h32(22))
  Gcoeff(:)%j = (c(2)*M(1,:)%j) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(58),h0tab(:,58),[32,3,16,4,8],[nMB,nMB,nMB,nMZ,nMB],5,1,wf4(:,1))
  call Hloop_AV_Q(ntryL,G0H64(1),ex6(:),G0H32(4),m3h2x32(:,56),heltab2x64(:,:,56))
  call Hloop_A_Q(ntryL,G0H32(4),32,nMB,G1H32(6),n2h32(23))
  Gcoeff(:)%j = (c(51)*M(1,:)%j) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(59),h0tab(:,59),[32,3,16,4,8],[nMT,nMT,nMT,nMW,nMT],5,1,wf4(:,1))
  call Hloop_AV_Q(ntryL,G0H64(1),ex6(:),G0H32(5),m3h2x32(:,57),heltab2x64(:,:,57))
  call Hloop_A_Q(ntryL,G0H32(5),32,nMT,G1H32(7),n2h32(24))
  Gcoeff(:)%j = (c(89)*M(1,:)%j) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(60),h0tab(:,60),[32,3,16,4,8],[nMW,nMW,nMW,nMT,nMW],5,1,wf4(:,1))
  call Hloop_SV_V(ntryL,G0H64(1),ex6(:),G0H32(6),m3h2x32(:,58),heltab2x64(:,:,58))
  Gcoeff(:)%j = (c(89)*M(1,:)%j) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(61),h0tab(:,61),[32,3,16,4,8],[nMW,nMW,nMW,nMT,nMW],5,1,wf4(:,1))
  call Hloop_SV_T(ntryL,G0H64(1),0,ex6(:),32,G1H32(8),m3h2x32(:,59),heltab2x64(:,:,59))
  Gcoeff(:)%j = (-(c(125)*M(1,:)%j)) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(62),h0tab(:,62),[32,3,16,4,8],[nMW,nMW,nMW,nMT,nMW],5,1,wf4(:,1))
  call Hloop_VV_S(ntryL,G0H64(1),ex6(:),G0H32(7),m3h2x32(:,60),heltab2x64(:,:,60))
  Gcoeff(:)%j = (c(125)*M(1,:)%j) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(63),h0tab(:,63),[32,3,16,4,8],[nMW,nMW,nMW,nMT,nMW],5,1,wf4(:,1))
  call Hloop_SV_T(ntryL,G0H64(1),0,ex6(:),32,G1H32(9),m3h2x32(:,61),heltab2x64(:,:,61))
  Gcoeff(:)%j = (-(c(26)*M(1,:)%j)) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(64),h0tab(:,64),[32,3,16,4,8],[nMW,nMW,nMW,nMT,nMW],5,1,wf4(:,1))
  call Hloop_SV_V(ntryL,G0H64(1),ex6(:),G0H32(8),m3h2x32(:,62),heltab2x64(:,:,62))
  Gcoeff(:)%j = (-(c(89)*M(1,:)%j)) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(65),h0tab(:,65),[32,3,16,4,8],[nMW,nMW,nMW,nMT,nMW],5,1,wf4(:,1))
  call Hloop_UW_V(ntryL,G0H64(1),0,ex6(:),32,G1H32(10),m3h2x32(:,63),heltab2x64(:,:,63))
  Gcoeff(:)%j = (c(103)*M(1,:)%j) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(66),h0tab(:,66),[32,3,16,4,8],[nMW,nMW,nMW,nMT,nMW],5,1,wf4(:,1))
  call Hloop_VV_S(ntryL,G0H64(1),ex6(:),G0H32(9),m3h2x32(:,64),heltab2x64(:,:,64))
  Gcoeff(:)%j = (-(c(103)*M(1,:)%j)) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(67),h0tab(:,67),[32,3,16,4,8],[nMW,nMW,nMW,nMT,nMW],5,1,wf4(:,1))
  call Hloop_SV_V(ntryL,G0H64(1),ex6(:),G0H32(10),m3h2x32(:,65),heltab2x64(:,:,65))
  Gcoeff(:)%j = (c(89)*M(1,:)%j) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(68),h0tab(:,68),[32,3,16,4,8],[nMW,nMW,nMW,nMT,nMW],5,1,wf4(:,1))
  call Hloop_SV_T(ntryL,G0H64(1),0,ex6(:),32,G1H32(11),m3h2x32(:,66),heltab2x64(:,:,66))
  Gcoeff(:)%j = (c(146)*M(1,:)%j) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(69),h0tab(:,69),[32,3,16,4,8],[nMW,nMW,nMW,nMT,nMW],5,1,wf4(:,1))
  call Hloop_VV_S(ntryL,G0H64(1),ex6(:),G0H32(11),m3h2x32(:,67),heltab2x64(:,:,67))
  Gcoeff(:)%j = (c(26)*M(1,:)%j) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(70),h0tab(:,70),[32,3,16,4,8],[nMW,nMW,nMW,nMT,nMW],5,1,wf4(:,1))
  call Hloop_UW_V(ntryL,G0H64(1),0,ex6(:),32,G1H32(12),m3h2x32(:,68),heltab2x64(:,:,68))
  Gcoeff(:)%j = (-(c(26)*M(1,:)%j)) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(71),h0tab(:,71),[32,3,16,4,8],[nMW,nMW,nMW,nMT,nMW],5,1,wf4(:,1))
  call Hloop_SV_V(ntryL,G0H64(1),ex6(:),G0H32(12),m3h2x32(:,69),heltab2x64(:,:,69))
  Gcoeff(:)%j = (c(103)*M(1,:)%j) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(72),h0tab(:,72),[32,3,16,4,8],[nMW,nMW,nMW,nMT,nMW],5,1,wf4(:,1))
  call Hloop_UW_V(ntryL,G0H64(1),0,ex6(:),32,G1H32(13),m3h2x32(:,70),heltab2x64(:,:,70))
  Gcoeff(:)%j = (c(103)*M(1,:)%j) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(73),h0tab(:,73),[32,3,16,4,8],[nMW,nMW,nMW,nMT,nMW],5,1,wf4(:,1))
  call Hloop_VV_S(ntryL,G0H64(1),ex6(:),G0H32(13),m3h2x32(:,71),heltab2x64(:,:,71))
  Gcoeff(:)%j = (c(26)*M(1,:)%j) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(74),h0tab(:,74),[32,3,16,4,8],[nMW,nMW,nMW,nMT,nMW],5,1,wf4(:,1))
  call Hloop_UW_V(ntryL,G0H64(1),0,ex6(:),32,G1H32(14),m3h2x32(:,72),heltab2x64(:,:,72))
  Gcoeff(:)%j = (-(c(71)*M(1,:)%j)) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(75),h0tab(:,75),[32,3,8,4,16],[nMB,nMB,nMH,nMB,nMB],5,1,wf4(:,1))
  call Hloop_QV_A(ntryL,G0H64(1),ex6(:),G0H32(14),m3h2x32(:,73),heltab2x64(:,:,73))
  call Hloop_Q_A(ntryL,G0H32(14),32,nMB,G1H32(15),n2h32(25))
  Gcoeff(:)%j = (c(71)*M(1,:)%j) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(76),h0tab(:,76),[32,3,8,4,16],[nMB,nMB,nMZ,nMB,nMB],5,1,wf4(:,1))
  call Hloop_QV_A(ntryL,G0H64(1),ex6(:),G0H32(15),m3h2x32(:,74),heltab2x64(:,:,74))
  call Hloop_Q_A(ntryL,G0H32(15),32,nMB,G1H32(16),n2h32(26))
  Gcoeff(:)%j = (c(67)*M(1,:)%j) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(77),h0tab(:,77),[32,3,8,4,16],[nMT,nMT,nMW,nMT,nMT],5,1,wf4(:,1))
  call Hloop_QV_A(ntryL,G0H64(1),ex6(:),G0H32(16),m3h2x32(:,75),heltab2x64(:,:,75))
  call Hloop_Q_A(ntryL,G0H32(16),32,nMT,G1H32(17),n2h32(27))
  Gcoeff(:)%j = (-(c(138)*M(1,:)%j)) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(78),h0tab(:,78),[32,3,8,4,16],[nMW,nMW,nMT,nMW,nMW],5,1,wf4(:,1))
  call Hloop_TV_S(ntryL,G0H64(1),0,ex6(:),32,G1H32(18),m3h2x32(:,76),heltab2x64(:,:,76))
  Gcoeff(:)%j = (c(1)*M(1,:)%j) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(79),h0tab(:,79),[32,3,8,4,16],[nMB,nMB,0,nMB,nMB],5,1,wf4(:,1))
  call Hloop_QV_A(ntryL,G0H64(1),ex6(:),G0H32(17),m3h2x32(:,77),heltab2x64(:,:,77))
  call Hloop_Q_A(ntryL,G0H32(17),32,nMB,G1H32(19),n2h32(28))
  Gcoeff(:)%j = (c(2)*M(1,:)%j) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(80),h0tab(:,80),[32,3,8,4,16],[nMB,nMB,nMZ,nMB,nMB],5,1,wf4(:,1))
  call Hloop_QV_A(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,78),heltab2x64(:,:,78))
  call Hloop_Q_A(ntryL,G0H32(1),32,nMB,G1H32(20),n2h32(29))
  Gcoeff(:)%j = (c(51)*M(1,:)%j) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(81),h0tab(:,81),[32,3,8,4,16],[nMT,nMT,nMW,nMT,nMT],5,1,wf4(:,1))
  call Hloop_QV_A(ntryL,G0H64(1),ex6(:),G0H32(2),m3h2x32(:,79),heltab2x64(:,:,79))
  call Hloop_Q_A(ntryL,G0H32(2),32,nMT,G1H32(21),n2h32(30))
  Gcoeff(:)%j = (c(89)*M(1,:)%j) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(82),h0tab(:,82),[32,3,8,4,16],[nMW,nMW,nMT,nMW,nMW],5,1,wf4(:,1))
  call Hloop_SV_V(ntryL,G0H64(1),ex6(:),G0H32(3),m3h2x32(:,80),heltab2x64(:,:,80))
  Gcoeff(:)%j = (c(125)*M(1,:)%j) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(83),h0tab(:,83),[32,3,8,4,16],[nMW,nMW,nMT,nMW,nMW],5,1,wf4(:,1))
  call Hloop_VV_S(ntryL,G0H64(1),ex6(:),G0H32(4),m3h2x32(:,81),heltab2x64(:,:,81))
  Gcoeff(:)%j = (-(c(89)*M(1,:)%j)) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(84),h0tab(:,84),[32,3,8,4,16],[nMW,nMW,nMT,nMW,nMW],5,1,wf4(:,1))
  call Hloop_TV_S(ntryL,G0H64(1),0,ex6(:),32,G1H32(22),m3h2x32(:,82),heltab2x64(:,:,82))
  Gcoeff(:)%j = (c(125)*M(1,:)%j) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(85),h0tab(:,85),[32,3,8,4,16],[nMW,nMW,nMT,nMW,nMW],5,1,wf4(:,1))
  call Hloop_TV_S(ntryL,G0H64(1),0,ex6(:),32,G1H32(23),m3h2x32(:,83),heltab2x64(:,:,83))
  Gcoeff(:)%j = (c(89)*M(1,:)%j) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(86),h0tab(:,86),[32,3,8,4,16],[nMW,nMW,nMT,nMW,nMW],5,1,wf4(:,1))
  call Hloop_UV_W(ntryL,G0H64(1),0,ex6(:),32,G1H32(24),m3h2x32(:,84),heltab2x64(:,:,84))
  Gcoeff(:)%j = (c(26)*M(1,:)%j) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(87),h0tab(:,87),[32,3,8,4,16],[nMW,nMW,nMT,nMW,nMW],5,1,wf4(:,1))
  call Hloop_SV_V(ntryL,G0H64(1),ex6(:),G0H32(5),m3h2x32(:,85),heltab2x64(:,:,85))
  Gcoeff(:)%j = (c(103)*M(1,:)%j) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(88),h0tab(:,88),[32,3,8,4,16],[nMW,nMW,nMT,nMW,nMW],5,1,wf4(:,1))
  call Hloop_VV_S(ntryL,G0H64(1),ex6(:),G0H32(14),m3h2x32(:,86),heltab2x64(:,:,86))
  Gcoeff(:)%j = (-(c(103)*M(1,:)%j)) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(89),h0tab(:,89),[32,3,8,4,16],[nMW,nMW,nMT,nMW,nMW],5,1,wf4(:,1))
  call Hloop_SV_V(ntryL,G0H64(1),ex6(:),G0H32(15),m3h2x32(:,87),heltab2x64(:,:,87))
  Gcoeff(:)%j = (c(125)*M(1,:)%j) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(90),h0tab(:,90),[32,3,8,4,16],[nMW,nMW,nMT,nMW,nMW],5,1,wf4(:,1))
  call Hloop_VV_S(ntryL,G0H64(1),ex6(:),G0H32(16),m3h2x32(:,88),heltab2x64(:,:,88))
  Gcoeff(:)%j = (c(103)*M(1,:)%j) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(91),h0tab(:,91),[32,3,8,4,16],[nMW,nMW,nMT,nMW,nMW],5,1,wf4(:,1))
  call Hloop_TV_S(ntryL,G0H64(1),0,ex6(:),32,G1H32(25),m3h2x32(:,89),heltab2x64(:,:,89))
  Gcoeff(:)%j = (c(26)*M(1,:)%j) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(92),h0tab(:,92),[32,3,8,4,16],[nMW,nMW,nMT,nMW,nMW],5,1,wf4(:,1))
  call Hloop_UV_W(ntryL,G0H64(1),0,ex6(:),32,G1H32(26),m3h2x32(:,90),heltab2x64(:,:,90))
  Gcoeff(:)%j = (c(89)*M(1,:)%j) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(93),h0tab(:,93),[32,3,8,4,16],[nMW,nMW,nMT,nMW,nMW],5,1,wf4(:,1))
  call Hloop_UV_W(ntryL,G0H64(1),0,ex6(:),32,G1H32(27),m3h2x32(:,91),heltab2x64(:,:,91))
  Gcoeff(:)%j = (-(c(43)*M(1,:)%j)) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(94),h0tab(:,94),[32,3,8,4,16],[nMW,nMW,nMT,nMW,nMW],5,1,wf4(:,1))
  call Hloop_SV_V(ntryL,G0H64(1),ex6(:),G0H32(17),m3h2x32(:,92),heltab2x64(:,:,92))
  Gcoeff(:)%j = (c(103)*M(1,:)%j) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(95),h0tab(:,95),[32,3,8,4,16],[nMW,nMW,nMT,nMW,nMW],5,1,wf4(:,1))
  call Hloop_VV_S(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,93),heltab2x64(:,:,93))
  Gcoeff(:)%j = (c(26)*M(1,:)%j) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(96),h0tab(:,96),[32,3,8,4,16],[nMW,nMW,nMT,nMW,nMW],5,1,wf4(:,1))
  call Hloop_UV_W(ntryL,G0H64(1),0,ex6(:),32,G1H32(28),m3h2x32(:,94),heltab2x64(:,:,94))
  Gcoeff(:)%j = (-(c(71)*M(1,:)%j)) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(97),h0tab(:,97),[32,3,16,8,4],[nMB,nMB,nMB,nMH,nMB],5,1,wf4(:,1))
  call Hloop_QV_A(ntryL,G0H64(1),ex6(:),G0H32(2),m3h2x32(:,95),heltab2x64(:,:,95))
  call Hloop_Q_A(ntryL,G0H32(2),32,nMB,G1H32(29),n2h32(31))
  Gcoeff(:)%j = (c(71)*M(1,:)%j) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(98),h0tab(:,98),[32,3,16,8,4],[nMB,nMB,nMB,nMZ,nMB],5,1,wf4(:,1))
  call Hloop_QV_A(ntryL,G0H64(1),ex6(:),G0H32(2),m3h2x32(:,96),heltab2x64(:,:,96))
  call Hloop_Q_A(ntryL,G0H32(2),32,nMB,G1H32(30),n2h32(32))
  Gcoeff(:)%j = (c(67)*M(1,:)%j) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(99),h0tab(:,99),[32,3,16,8,4],[nMT,nMT,nMT,nMW,nMT],5,1,wf4(:,1))
  call Hloop_QV_A(ntryL,G0H64(1),ex6(:),G0H32(2),m3h2x32(:,97),heltab2x64(:,:,97))
  call Hloop_Q_A(ntryL,G0H32(2),32,nMT,G1H32(31),n2h32(33))
  Gcoeff(:)%j = (-(c(138)*M(1,:)%j)) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(100),h0tab(:,100),[32,3,16,8,4],[nMW,nMW,nMW,nMT,nMW],5,1,wf4(:,1))
  call Hloop_TV_S(ntryL,G0H64(1),0,ex6(:),32,G1H32(32),m3h2x32(:,98),heltab2x64(:,:,98))
  Gcoeff(:)%j = (c(1)*M(1,:)%j) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(101),h0tab(:,101),[32,3,16,8,4],[nMB,nMB,nMB,0,nMB],5,1,wf4(:,1))
  call Hloop_QV_A(ntryL,G0H64(1),ex6(:),G0H32(2),m3h2x32(:,99),heltab2x64(:,:,99))
  call Hloop_Q_A(ntryL,G0H32(2),32,nMB,G1H32(33),n2h32(34))
  Gcoeff(:)%j = (c(2)*M(1,:)%j) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(102),h0tab(:,102),[32,3,16,8,4],[nMB,nMB,nMB,nMZ,nMB],5,1,wf4(:,1))
  call Hloop_QV_A(ntryL,G0H64(1),ex6(:),G0H32(2),m3h2x32(:,100),heltab2x64(:,:,100))
  call Hloop_Q_A(ntryL,G0H32(2),32,nMB,G1H32(34),n2h32(35))
  Gcoeff(:)%j = (c(51)*M(1,:)%j) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(103),h0tab(:,103),[32,3,16,8,4],[nMT,nMT,nMT,nMW,nMT],5,1,wf4(:,1))
  call Hloop_QV_A(ntryL,G0H64(1),ex6(:),G0H32(2),m3h2x32(:,101),heltab2x64(:,:,101))
  call Hloop_Q_A(ntryL,G0H32(2),32,nMT,G1H32(35),n2h32(36))
  Gcoeff(:)%j = (c(89)*M(1,:)%j) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(104),h0tab(:,104),[32,3,16,8,4],[nMW,nMW,nMW,nMT,nMW],5,1,wf4(:,1))
  call Hloop_SV_V(ntryL,G0H64(1),ex6(:),G0H32(2),m3h2x32(:,102),heltab2x64(:,:,102))
  Gcoeff(:)%j = (c(89)*M(1,:)%j) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(105),h0tab(:,105),[32,3,16,8,4],[nMW,nMW,nMW,nMT,nMW],5,1,wf4(:,1))
  call Hloop_TV_S(ntryL,G0H64(1),0,ex6(:),32,G1H32(36),m3h2x32(:,103),heltab2x64(:,:,103))
  Gcoeff(:)%j = (-(c(125)*M(1,:)%j)) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(106),h0tab(:,106),[32,3,16,8,4],[nMW,nMW,nMW,nMT,nMW],5,1,wf4(:,1))
  call Hloop_TV_S(ntryL,G0H64(1),0,ex6(:),32,G1H32(37),m3h2x32(:,104),heltab2x64(:,:,104))
  Gcoeff(:)%j = (c(125)*M(1,:)%j) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(107),h0tab(:,107),[32,3,16,8,4],[nMW,nMW,nMW,nMT,nMW],5,1,wf4(:,1))
  call Hloop_VV_S(ntryL,G0H64(1),ex6(:),G0H32(18),m3h2x32(:,105),heltab2x64(:,:,105))
  Gcoeff(:)%j = (-(c(26)*M(1,:)%j)) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(108),h0tab(:,108),[32,3,16,8,4],[nMW,nMW,nMW,nMT,nMW],5,1,wf4(:,1))
  call Hloop_SV_V(ntryL,G0H64(1),ex6(:),G0H32(19),m3h2x32(:,106),heltab2x64(:,:,106))
  Gcoeff(:)%j = (c(103)*M(1,:)%j) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(109),h0tab(:,109),[32,3,16,8,4],[nMW,nMW,nMW,nMT,nMW],5,1,wf4(:,1))
  call Hloop_SV_V(ntryL,G0H64(1),ex6(:),G0H32(20),m3h2x32(:,107),heltab2x64(:,:,107))
  Gcoeff(:)%j = (-(c(89)*M(1,:)%j)) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(110),h0tab(:,110),[32,3,16,8,4],[nMW,nMW,nMW,nMT,nMW],5,1,wf4(:,1))
  call Hloop_TV_S(ntryL,G0H64(1),0,ex6(:),32,G1H32(38),m3h2x32(:,108),heltab2x64(:,:,108))
  Gcoeff(:)%j = (c(89)*M(1,:)%j) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(111),h0tab(:,111),[32,3,16,8,4],[nMW,nMW,nMW,nMT,nMW],5,1,wf4(:,1))
  call Hloop_UV_W(ntryL,G0H64(1),0,ex6(:),32,G1H32(39),m3h2x32(:,109),heltab2x64(:,:,109))
  Gcoeff(:)%j = (-(c(103)*M(1,:)%j)) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(112),h0tab(:,112),[32,3,16,8,4],[nMW,nMW,nMW,nMT,nMW],5,1,wf4(:,1))
  call Hloop_VV_S(ntryL,G0H64(1),ex6(:),G0H32(21),m3h2x32(:,110),heltab2x64(:,:,110))
  Gcoeff(:)%j = (c(146)*M(1,:)%j) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(113),h0tab(:,113),[32,3,16,8,4],[nMW,nMW,nMW,nMT,nMW],5,1,wf4(:,1))
  call Hloop_VV_S(ntryL,G0H64(1),ex6(:),G0H32(22),m3h2x32(:,111),heltab2x64(:,:,111))
  Gcoeff(:)%j = (c(26)*M(1,:)%j) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(114),h0tab(:,114),[32,3,16,8,4],[nMW,nMW,nMW,nMT,nMW],5,1,wf4(:,1))
  call Hloop_SV_V(ntryL,G0H64(1),ex6(:),G0H32(23),m3h2x32(:,112),heltab2x64(:,:,112))
  Gcoeff(:)%j = (-(c(26)*M(1,:)%j)) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(115),h0tab(:,115),[32,3,16,8,4],[nMW,nMW,nMW,nMT,nMW],5,1,wf4(:,1))
  call Hloop_UV_W(ntryL,G0H64(1),0,ex6(:),32,G1H32(40),m3h2x32(:,113),heltab2x64(:,:,113))
  Gcoeff(:)%j = (c(103)*M(1,:)%j) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(116),h0tab(:,116),[32,3,16,8,4],[nMW,nMW,nMW,nMT,nMW],5,1,wf4(:,1))
  call Hloop_UV_W(ntryL,G0H64(1),0,ex6(:),32,G1H32(41),m3h2x32(:,114),heltab2x64(:,:,114))
  Gcoeff(:)%j = (c(103)*M(1,:)%j) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(117),h0tab(:,117),[32,3,16,8,4],[nMW,nMW,nMW,nMT,nMW],5,1,wf4(:,1))
  call Hloop_VV_S(ntryL,G0H64(1),ex6(:),G0H32(24),m3h2x32(:,115),heltab2x64(:,:,115))
  Gcoeff(:)%j = (c(26)*M(1,:)%j) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(118),h0tab(:,118),[32,3,16,8,4],[nMW,nMW,nMW,nMT,nMW],5,1,wf4(:,1))
  call Hloop_UV_W(ntryL,G0H64(1),0,ex6(:),32,G1H32(42),m3h2x32(:,116),heltab2x64(:,:,116))
  Gcoeff(:)%j = (-(c(71)*M(1,:)%j)) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(119),h0tab(:,119),[32,4,8,3,16],[nMB,nMH,nMB,nMB,nMB],5,1,wf4(:,1))
  call Hloop_AV_Q(ntryL,G0H64(1),ex6(:),G0H32(25),m3h2x32(:,117),heltab2x64(:,:,117))
  call Hloop_A_Q(ntryL,G0H32(25),32,nMB,G1H32(43),n2h32(37))
  Gcoeff(:)%j = (c(71)*M(1,:)%j) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(120),h0tab(:,120),[32,4,8,3,16],[nMB,nMZ,nMB,nMB,nMB],5,1,wf4(:,1))
  call Hloop_AV_Q(ntryL,G0H64(1),ex6(:),G0H32(25),m3h2x32(:,118),heltab2x64(:,:,118))
  call Hloop_A_Q(ntryL,G0H32(25),32,nMB,G1H32(44),n2h32(38))
  Gcoeff(:)%j = (c(67)*M(1,:)%j) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(121),h0tab(:,121),[32,4,8,3,16],[nMT,nMW,nMT,nMT,nMT],5,1,wf4(:,1))
  call Hloop_AV_Q(ntryL,G0H64(1),ex6(:),G0H32(25),m3h2x32(:,119),heltab2x64(:,:,119))
  call Hloop_A_Q(ntryL,G0H32(25),32,nMT,G1H32(45),n2h32(39))
  Gcoeff(:)%j = (-(c(138)*M(1,:)%j)) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(122),h0tab(:,122),[32,4,8,3,16],[nMW,nMT,nMW,nMW,nMW],5,1,wf4(:,1))
  call Hloop_SV_T(ntryL,G0H64(1),0,ex6(:),32,G1H32(46),m3h2x32(:,120),heltab2x64(:,:,120))
  Gcoeff(:)%j = (c(1)*M(1,:)%j) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(123),h0tab(:,123),[32,4,8,3,16],[nMB,0,nMB,nMB,nMB],5,1,wf4(:,1))
  call Hloop_AV_Q(ntryL,G0H64(1),ex6(:),G0H32(25),m3h2x32(:,121),heltab2x64(:,:,121))
  call Hloop_A_Q(ntryL,G0H32(25),32,nMB,G1H32(47),n2h32(40))
  Gcoeff(:)%j = (c(2)*M(1,:)%j) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(124),h0tab(:,124),[32,4,8,3,16],[nMB,nMZ,nMB,nMB,nMB],5,1,wf4(:,1))
  call Hloop_AV_Q(ntryL,G0H64(1),ex6(:),G0H32(25),m3h2x32(:,122),heltab2x64(:,:,122))
  call Hloop_A_Q(ntryL,G0H32(25),32,nMB,G1H32(48),n2h32(41))
  Gcoeff(:)%j = (c(51)*M(1,:)%j) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(125),h0tab(:,125),[32,4,8,3,16],[nMT,nMW,nMT,nMT,nMT],5,1,wf4(:,1))
  call Hloop_AV_Q(ntryL,G0H64(1),ex6(:),G0H32(25),m3h2x32(:,123),heltab2x64(:,:,123))
  call Hloop_A_Q(ntryL,G0H32(25),32,nMT,G1H32(49),n2h32(42))
  Gcoeff(:)%j = (c(89)*M(1,:)%j) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(126),h0tab(:,126),[32,4,8,3,16],[nMW,nMT,nMW,nMW,nMW],5,1,wf4(:,1))
  call Hloop_SV_T(ntryL,G0H64(1),0,ex6(:),32,G1H32(50),m3h2x32(:,124),heltab2x64(:,:,124))
  Gcoeff(:)%j = (c(125)*M(1,:)%j) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(127),h0tab(:,127),[32,4,8,3,16],[nMW,nMT,nMW,nMW,nMW],5,1,wf4(:,1))
  call Hloop_VV_S(ntryL,G0H64(1),ex6(:),G0H32(25),m3h2x32(:,125),heltab2x64(:,:,125))
  Gcoeff(:)%j = (-(c(89)*M(1,:)%j)) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(128),h0tab(:,128),[32,4,8,3,16],[nMW,nMT,nMW,nMW,nMW],5,1,wf4(:,1))
  call Hloop_SV_T(ntryL,G0H64(1),0,ex6(:),32,G1H32(51),m3h2x32(:,126),heltab2x64(:,:,126))
  Gcoeff(:)%j = (c(125)*M(1,:)%j) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(129),h0tab(:,129),[32,4,8,3,16],[nMW,nMT,nMW,nMW,nMW],5,1,wf4(:,1))
  call Hloop_SV_V(ntryL,G0H64(1),ex6(:),G0H32(26),m3h2x32(:,127),heltab2x64(:,:,127))
  Gcoeff(:)%j = (c(89)*M(1,:)%j) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(130),h0tab(:,130),[32,4,8,3,16],[nMW,nMT,nMW,nMW,nMW],5,1,wf4(:,1))
  call Hloop_VV_S(ntryL,G0H64(1),ex6(:),G0H32(27),m3h2x32(:,128),heltab2x64(:,:,128))
  Gcoeff(:)%j = (c(26)*M(1,:)%j) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(131),h0tab(:,131),[32,4,8,3,16],[nMW,nMT,nMW,nMW,nMW],5,1,wf4(:,1))
  call Hloop_SV_T(ntryL,G0H64(1),0,ex6(:),32,G1H32(52),m3h2x32(:,129),heltab2x64(:,:,129))
  Gcoeff(:)%j = (c(103)*M(1,:)%j) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(132),h0tab(:,132),[32,4,8,3,16],[nMW,nMT,nMW,nMW,nMW],5,1,wf4(:,1))
  call Hloop_VV_S(ntryL,G0H64(1),ex6(:),G0H32(28),m3h2x32(:,130),heltab2x64(:,:,130))
  Gcoeff(:)%j = (-(c(103)*M(1,:)%j)) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(133),h0tab(:,133),[32,4,8,3,16],[nMW,nMT,nMW,nMW,nMW],5,1,wf4(:,1))
  call Hloop_SV_V(ntryL,G0H64(1),ex6(:),G0H32(29),m3h2x32(:,131),heltab2x64(:,:,131))
  Gcoeff(:)%j = (c(125)*M(1,:)%j) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(134),h0tab(:,134),[32,4,8,3,16],[nMW,nMT,nMW,nMW,nMW],5,1,wf4(:,1))
  call Hloop_UW_V(ntryL,G0H64(1),0,ex6(:),32,G1H32(53),m3h2x32(:,132),heltab2x64(:,:,132))
  Gcoeff(:)%j = (c(103)*M(1,:)%j) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(135),h0tab(:,135),[32,4,8,3,16],[nMW,nMT,nMW,nMW,nMW],5,1,wf4(:,1))
  call Hloop_SV_V(ntryL,G0H64(1),ex6(:),G0H32(30),m3h2x32(:,133),heltab2x64(:,:,133))
  Gcoeff(:)%j = (c(26)*M(1,:)%j) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(136),h0tab(:,136),[32,4,8,3,16],[nMW,nMT,nMW,nMW,nMW],5,1,wf4(:,1))
  call Hloop_VV_S(ntryL,G0H64(1),ex6(:),G0H32(31),m3h2x32(:,134),heltab2x64(:,:,134))
  Gcoeff(:)%j = (c(89)*M(1,:)%j) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(137),h0tab(:,137),[32,4,8,3,16],[nMW,nMT,nMW,nMW,nMW],5,1,wf4(:,1))
  call Hloop_UW_V(ntryL,G0H64(1),0,ex6(:),32,G1H32(54),m3h2x32(:,135),heltab2x64(:,:,135))
  Gcoeff(:)%j = (-(c(43)*M(1,:)%j)) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(138),h0tab(:,138),[32,4,8,3,16],[nMW,nMT,nMW,nMW,nMW],5,1,wf4(:,1))
  call Hloop_SV_V(ntryL,G0H64(1),ex6(:),G0H32(32),m3h2x32(:,136),heltab2x64(:,:,136))
  Gcoeff(:)%j = (c(103)*M(1,:)%j) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(139),h0tab(:,139),[32,4,8,3,16],[nMW,nMT,nMW,nMW,nMW],5,1,wf4(:,1))
  call Hloop_UW_V(ntryL,G0H64(1),0,ex6(:),32,G1H32(55),m3h2x32(:,137),heltab2x64(:,:,137))
  Gcoeff(:)%j = (c(26)*M(1,:)%j) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(140),h0tab(:,140),[32,4,8,3,16],[nMW,nMT,nMW,nMW,nMW],5,1,wf4(:,1))
  call Hloop_UW_V(ntryL,G0H64(1),0,ex6(:),32,G1H32(56),m3h2x32(:,138),heltab2x64(:,:,138))
  Gcoeff(:)%j = (-(c(71)*M(1,:)%j)) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(141),h0tab(:,141),[32,3,4,8,16],[nMB,nMB,nMH,nMB,nMB],5,1,wf4(:,1))
  call Hloop_AV_Q(ntryL,G0H64(1),ex6(:),G0H32(33),m3h2x32(:,139),heltab2x64(:,:,139))
  call Hloop_A_Q(ntryL,G0H32(33),32,nMB,G1H32(57),n2h32(43))
  Gcoeff(:)%j = (c(71)*M(1,:)%j) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(142),h0tab(:,142),[32,3,4,8,16],[nMB,nMB,nMZ,nMB,nMB],5,1,wf4(:,1))
  call Hloop_AV_Q(ntryL,G0H64(1),ex6(:),G0H32(33),m3h2x32(:,140),heltab2x64(:,:,140))
  call Hloop_A_Q(ntryL,G0H32(33),32,nMB,G1H32(58),n2h32(44))
  Gcoeff(:)%j = (c(67)*M(1,:)%j) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(143),h0tab(:,143),[32,3,4,8,16],[nMT,nMT,nMW,nMT,nMT],5,1,wf4(:,1))
  call Hloop_AV_Q(ntryL,G0H64(1),ex6(:),G0H32(33),m3h2x32(:,141),heltab2x64(:,:,141))
  call Hloop_A_Q(ntryL,G0H32(33),32,nMT,G1H32(59),n2h32(45))
  Gcoeff(:)%j = (-(c(138)*M(1,:)%j)) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(144),h0tab(:,144),[32,3,4,8,16],[nMW,nMW,nMT,nMW,nMW],5,1,wf4(:,1))
  call Hloop_SV_T(ntryL,G0H64(1),0,ex6(:),32,G1H32(60),m3h2x32(:,142),heltab2x64(:,:,142))
  Gcoeff(:)%j = (c(1)*M(1,:)%j) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(145),h0tab(:,145),[32,3,4,8,16],[nMB,nMB,0,nMB,nMB],5,1,wf4(:,1))
  call Hloop_AV_Q(ntryL,G0H64(1),ex6(:),G0H32(33),m3h2x32(:,143),heltab2x64(:,:,143))
  call Hloop_A_Q(ntryL,G0H32(33),32,nMB,G1H32(61),n2h32(46))
  Gcoeff(:)%j = (c(2)*M(1,:)%j) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(146),h0tab(:,146),[32,3,4,8,16],[nMB,nMB,nMZ,nMB,nMB],5,1,wf4(:,1))
  call Hloop_AV_Q(ntryL,G0H64(1),ex6(:),G0H32(33),m3h2x32(:,144),heltab2x64(:,:,144))
  call Hloop_A_Q(ntryL,G0H32(33),32,nMB,G1H32(62),n2h32(47))
  Gcoeff(:)%j = (c(51)*M(1,:)%j) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(147),h0tab(:,147),[32,3,4,8,16],[nMT,nMT,nMW,nMT,nMT],5,1,wf4(:,1))
  call Hloop_AV_Q(ntryL,G0H64(1),ex6(:),G0H32(33),m3h2x32(:,145),heltab2x64(:,:,145))
  call Hloop_A_Q(ntryL,G0H32(33),32,nMT,G1H32(63),n2h32(48))
  Gcoeff(:)%j = (c(89)*M(1,:)%j) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(148),h0tab(:,148),[32,3,4,8,16],[nMW,nMW,nMT,nMW,nMW],5,1,wf4(:,1))
  call Hloop_SV_V(ntryL,G0H64(1),ex6(:),G0H32(33),m3h2x32(:,146),heltab2x64(:,:,146))
  Gcoeff(:)%j = (c(125)*M(1,:)%j) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(149),h0tab(:,149),[32,3,4,8,16],[nMW,nMW,nMT,nMW,nMW],5,1,wf4(:,1))
  call Hloop_VV_S(ntryL,G0H64(1),ex6(:),G0H32(34),m3h2x32(:,147),heltab2x64(:,:,147))
  Gcoeff(:)%j = (-(c(125)*M(1,:)%j)) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(150),h0tab(:,150),[32,3,4,8,16],[nMW,nMW,nMT,nMW,nMW],5,1,wf4(:,1))
  call Hloop_SV_T(ntryL,G0H64(1),0,ex6(:),32,G1H32(64),m3h2x32(:,148),heltab2x64(:,:,148))
  Gcoeff(:)%j = (c(89)*M(1,:)%j) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(151),h0tab(:,151),[32,3,4,8,16],[nMW,nMW,nMT,nMW,nMW],5,1,wf4(:,1))
  call Hloop_SV_T(ntryL,G0H64(1),0,ex6(:),32,G1H32(65),m3h2x32(:,149),heltab2x64(:,:,149))
  Gcoeff(:)%j = (c(89)*M(1,:)%j) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(152),h0tab(:,152),[32,3,4,8,16],[nMW,nMW,nMT,nMW,nMW],5,1,wf4(:,1))
  call Hloop_UW_V(ntryL,G0H64(1),0,ex6(:),32,G1H32(66),m3h2x32(:,150),heltab2x64(:,:,150))
  Gcoeff(:)%j = (c(103)*M(1,:)%j) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(153),h0tab(:,153),[32,3,4,8,16],[nMW,nMW,nMT,nMW,nMW],5,1,wf4(:,1))
  call Hloop_SV_V(ntryL,G0H64(1),ex6(:),G0H32(35),m3h2x32(:,151),heltab2x64(:,:,151))
  Gcoeff(:)%j = (-(c(125)*M(1,:)%j)) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(154),h0tab(:,154),[32,3,4,8,16],[nMW,nMW,nMT,nMW,nMW],5,1,wf4(:,1))
  call Hloop_VV_S(ntryL,G0H64(1),ex6(:),G0H32(36),m3h2x32(:,152),heltab2x64(:,:,152))
  Gcoeff(:)%j = (-(c(26)*M(1,:)%j)) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(155),h0tab(:,155),[32,3,4,8,16],[nMW,nMW,nMT,nMW,nMW],5,1,wf4(:,1))
  call Hloop_SV_V(ntryL,G0H64(1),ex6(:),G0H32(37),m3h2x32(:,153),heltab2x64(:,:,153))
  Gcoeff(:)%j = (-(c(103)*M(1,:)%j)) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(156),h0tab(:,156),[32,3,4,8,16],[nMW,nMW,nMT,nMW,nMW],5,1,wf4(:,1))
  call Hloop_VV_S(ntryL,G0H64(1),ex6(:),G0H32(38),m3h2x32(:,154),heltab2x64(:,:,154))
  Gcoeff(:)%j = (c(103)*M(1,:)%j) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(157),h0tab(:,157),[32,3,4,8,16],[nMW,nMW,nMT,nMW,nMW],5,1,wf4(:,1))
  call Hloop_SV_T(ntryL,G0H64(1),0,ex6(:),32,G1H32(67),m3h2x32(:,155),heltab2x64(:,:,155))
  Gcoeff(:)%j = (-(c(89)*M(1,:)%j)) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(158),h0tab(:,158),[32,3,4,8,16],[nMW,nMW,nMT,nMW,nMW],5,1,wf4(:,1))
  call Hloop_UW_V(ntryL,G0H64(1),0,ex6(:),32,G1H32(68),m3h2x32(:,156),heltab2x64(:,:,156))
  Gcoeff(:)%j = (-(c(26)*M(1,:)%j)) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(159),h0tab(:,159),[32,3,4,8,16],[nMW,nMW,nMT,nMW,nMW],5,1,wf4(:,1))
  call Hloop_UW_V(ntryL,G0H64(1),0,ex6(:),32,G1H32(69),m3h2x32(:,157),heltab2x64(:,:,157))
  Gcoeff(:)%j = (-(c(43)*M(1,:)%j)) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(160),h0tab(:,160),[32,3,4,8,16],[nMW,nMW,nMT,nMW,nMW],5,1,wf4(:,1))
  call Hloop_SV_V(ntryL,G0H64(1),ex6(:),G0H32(39),m3h2x32(:,158),heltab2x64(:,:,158))
  Gcoeff(:)%j = (c(103)*M(1,:)%j) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(161),h0tab(:,161),[32,3,4,8,16],[nMW,nMW,nMT,nMW,nMW],5,1,wf4(:,1))
  call Hloop_VV_S(ntryL,G0H64(1),ex6(:),G0H32(40),m3h2x32(:,159),heltab2x64(:,:,159))
  Gcoeff(:)%j = (c(26)*M(1,:)%j) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(162),h0tab(:,162),[32,3,4,8,16],[nMW,nMW,nMT,nMW,nMW],5,1,wf4(:,1))
  call Hloop_UW_V(ntryL,G0H64(1),0,ex6(:),32,G1H32(70),m3h2x32(:,160),heltab2x64(:,:,160))
  Gcoeff(:)%j = (-(c(71)*M(1,:)%j)) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(163),h0tab(:,163),[32,8,4,3,16],[nMB,nMH,nMB,nMB,nMB],5,1,wf4(:,1))
  call Hloop_QV_A(ntryL,G0H64(1),ex6(:),G0H32(41),m3h2x32(:,161),heltab2x64(:,:,161))
  call Hloop_Q_A(ntryL,G0H32(41),32,nMB,G1H32(71),n2h32(49))
  Gcoeff(:)%j = (c(71)*M(1,:)%j) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(164),h0tab(:,164),[32,8,4,3,16],[nMB,nMZ,nMB,nMB,nMB],5,1,wf4(:,1))
  call Hloop_QV_A(ntryL,G0H64(1),ex6(:),G0H32(41),m3h2x32(:,162),heltab2x64(:,:,162))
  call Hloop_Q_A(ntryL,G0H32(41),32,nMB,G1H32(72),n2h32(50))
  Gcoeff(:)%j = (c(67)*M(1,:)%j) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(165),h0tab(:,165),[32,8,4,3,16],[nMT,nMW,nMT,nMT,nMT],5,1,wf4(:,1))
  call Hloop_QV_A(ntryL,G0H64(1),ex6(:),G0H32(41),m3h2x32(:,163),heltab2x64(:,:,163))
  call Hloop_Q_A(ntryL,G0H32(41),32,nMT,G1H32(73),n2h32(51))
  Gcoeff(:)%j = (-(c(138)*M(1,:)%j)) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(166),h0tab(:,166),[32,8,4,3,16],[nMW,nMT,nMW,nMW,nMW],5,1,wf4(:,1))
  call Hloop_TV_S(ntryL,G0H64(1),0,ex6(:),32,G1H32(74),m3h2x32(:,164),heltab2x64(:,:,164))
  Gcoeff(:)%j = (c(1)*M(1,:)%j) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(167),h0tab(:,167),[32,8,4,3,16],[nMB,0,nMB,nMB,nMB],5,1,wf4(:,1))
  call Hloop_QV_A(ntryL,G0H64(1),ex6(:),G0H32(41),m3h2x32(:,165),heltab2x64(:,:,165))
  call Hloop_Q_A(ntryL,G0H32(41),32,nMB,G1H32(75),n2h32(52))
  Gcoeff(:)%j = (c(2)*M(1,:)%j) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(168),h0tab(:,168),[32,8,4,3,16],[nMB,nMZ,nMB,nMB,nMB],5,1,wf4(:,1))
  call Hloop_QV_A(ntryL,G0H64(1),ex6(:),G0H32(41),m3h2x32(:,166),heltab2x64(:,:,166))
  call Hloop_Q_A(ntryL,G0H32(41),32,nMB,G1H32(76),n2h32(53))
  Gcoeff(:)%j = (c(51)*M(1,:)%j) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(169),h0tab(:,169),[32,8,4,3,16],[nMT,nMW,nMT,nMT,nMT],5,1,wf4(:,1))
  call Hloop_QV_A(ntryL,G0H64(1),ex6(:),G0H32(41),m3h2x32(:,167),heltab2x64(:,:,167))
  call Hloop_Q_A(ntryL,G0H32(41),32,nMT,G1H32(77),n2h32(54))
  Gcoeff(:)%j = (c(89)*M(1,:)%j) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(170),h0tab(:,170),[32,8,4,3,16],[nMW,nMT,nMW,nMW,nMW],5,1,wf4(:,1))
  call Hloop_TV_S(ntryL,G0H64(1),0,ex6(:),32,G1H32(78),m3h2x32(:,168),heltab2x64(:,:,168))
  Gcoeff(:)%j = (c(125)*M(1,:)%j) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(171),h0tab(:,171),[32,8,4,3,16],[nMW,nMT,nMW,nMW,nMW],5,1,wf4(:,1))
  call Hloop_VV_S(ntryL,G0H64(1),ex6(:),G0H32(41),m3h2x32(:,169),heltab2x64(:,:,169))
  Gcoeff(:)%j = (-(c(125)*M(1,:)%j)) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(172),h0tab(:,172),[32,8,4,3,16],[nMW,nMT,nMW,nMW,nMW],5,1,wf4(:,1))
  call Hloop_SV_V(ntryL,G0H64(1),ex6(:),G0H32(42),m3h2x32(:,170),heltab2x64(:,:,170))
  Gcoeff(:)%j = (c(89)*M(1,:)%j) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(173),h0tab(:,173),[32,8,4,3,16],[nMW,nMT,nMW,nMW,nMW],5,1,wf4(:,1))
  call Hloop_TV_S(ntryL,G0H64(1),0,ex6(:),32,G1H32(79),m3h2x32(:,171),heltab2x64(:,:,171))
  Gcoeff(:)%j = (c(89)*M(1,:)%j) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(174),h0tab(:,174),[32,8,4,3,16],[nMW,nMT,nMW,nMW,nMW],5,1,wf4(:,1))
  call Hloop_VV_S(ntryL,G0H64(1),ex6(:),G0H32(43),m3h2x32(:,172),heltab2x64(:,:,172))
  Gcoeff(:)%j = (c(103)*M(1,:)%j) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(175),h0tab(:,175),[32,8,4,3,16],[nMW,nMT,nMW,nMW,nMW],5,1,wf4(:,1))
  call Hloop_SV_V(ntryL,G0H64(1),ex6(:),G0H32(44),m3h2x32(:,173),heltab2x64(:,:,173))
  Gcoeff(:)%j = (-(c(125)*M(1,:)%j)) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(176),h0tab(:,176),[32,8,4,3,16],[nMW,nMT,nMW,nMW,nMW],5,1,wf4(:,1))
  call Hloop_UV_W(ntryL,G0H64(1),0,ex6(:),32,G1H32(80),m3h2x32(:,174),heltab2x64(:,:,174))
  Gcoeff(:)%j = (-(c(26)*M(1,:)%j)) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(177),h0tab(:,177),[32,8,4,3,16],[nMW,nMT,nMW,nMW,nMW],5,1,wf4(:,1))
  call Hloop_TV_S(ntryL,G0H64(1),0,ex6(:),32,G1H32(81),m3h2x32(:,175),heltab2x64(:,:,175))
  Gcoeff(:)%j = (-(c(103)*M(1,:)%j)) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(178),h0tab(:,178),[32,8,4,3,16],[nMW,nMT,nMW,nMW,nMW],5,1,wf4(:,1))
  call Hloop_VV_S(ntryL,G0H64(1),ex6(:),G0H32(45),m3h2x32(:,176),heltab2x64(:,:,176))
  Gcoeff(:)%j = (c(103)*M(1,:)%j) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(179),h0tab(:,179),[32,8,4,3,16],[nMW,nMT,nMW,nMW,nMW],5,1,wf4(:,1))
  call Hloop_SV_V(ntryL,G0H64(1),ex6(:),G0H32(46),m3h2x32(:,177),heltab2x64(:,:,177))
  Gcoeff(:)%j = (-(c(89)*M(1,:)%j)) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(180),h0tab(:,180),[32,8,4,3,16],[nMW,nMT,nMW,nMW,nMW],5,1,wf4(:,1))
  call Hloop_UV_W(ntryL,G0H64(1),0,ex6(:),32,G1H32(82),m3h2x32(:,178),heltab2x64(:,:,178))
  Gcoeff(:)%j = (-(c(26)*M(1,:)%j)) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(181),h0tab(:,181),[32,8,4,3,16],[nMW,nMT,nMW,nMW,nMW],5,1,wf4(:,1))
  call Hloop_VV_S(ntryL,G0H64(1),ex6(:),G0H32(47),m3h2x32(:,179),heltab2x64(:,:,179))
  Gcoeff(:)%j = (-(c(43)*M(1,:)%j)) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(182),h0tab(:,182),[32,8,4,3,16],[nMW,nMT,nMW,nMW,nMW],5,1,wf4(:,1))
  call Hloop_SV_V(ntryL,G0H64(1),ex6(:),G0H32(48),m3h2x32(:,180),heltab2x64(:,:,180))
  Gcoeff(:)%j = (c(103)*M(1,:)%j) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(183),h0tab(:,183),[32,8,4,3,16],[nMW,nMT,nMW,nMW,nMW],5,1,wf4(:,1))
  call Hloop_UV_W(ntryL,G0H64(1),0,ex6(:),32,G1H32(83),m3h2x32(:,181),heltab2x64(:,:,181))
  Gcoeff(:)%j = (c(26)*M(1,:)%j) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(184),h0tab(:,184),[32,8,4,3,16],[nMW,nMT,nMW,nMW,nMW],5,1,wf4(:,1))
  call Hloop_UV_W(ntryL,G0H64(1),0,ex6(:),32,G1H32(84),m3h2x32(:,182),heltab2x64(:,:,182))
  Gcoeff(:)%j = (c(68)*M(1,:)%j) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(185),h0tab(:,185),[32,3,8,16,4],[nMT,nMT,nMW,nMW,nMT],5,1,wf4(:,1))
  call Hloop_QV_A(ntryL,G0H64(1),ex6(:),G0H32(49),m3h2x32(:,183),heltab2x64(:,:,183))
  call Hloop_Q_A(ntryL,G0H32(49),32,nMT,G1H32(85),n2h32(55))
  Gcoeff(:)%j = (-(c(137)*M(1,:)%j)) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(186),h0tab(:,186),[32,3,8,16,4],[nMW,nMW,nMT,nMT,nMW],5,1,wf4(:,1))
  call Hloop_TV_S(ntryL,G0H64(1),0,ex6(:),32,G1H32(86),m3h2x32(:,184),heltab2x64(:,:,184))
  Gcoeff(:)%j = (c(52)*M(1,:)%j) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(187),h0tab(:,187),[32,3,8,16,4],[nMT,nMT,nMW,nMW,nMT],5,1,wf4(:,1))
  call Hloop_QV_A(ntryL,G0H64(1),ex6(:),G0H32(49),m3h2x32(:,185),heltab2x64(:,:,185))
  call Hloop_Q_A(ntryL,G0H32(49),32,nMT,G1H32(87),n2h32(56))
  Gcoeff(:)%j = (-(c(52)*M(1,:)%j)) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(188),h0tab(:,188),[32,3,8,16,4],[nMT,nMT,nMW,nMW,nMT],5,1,wf4(:,1))
  call Hloop_QV_A(ntryL,G0H64(1),ex6(:),G0H32(49),m3h2x32(:,186),heltab2x64(:,:,186))
  call Hloop_Q_A(ntryL,G0H32(49),32,nMT,G1H32(88),n2h32(57))
  Gcoeff(:)%j = (c(88)*M(1,:)%j) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(189),h0tab(:,189),[32,3,8,16,4],[nMW,nMW,nMT,nMT,nMW],5,1,wf4(:,1))
  call Hloop_SV_V(ntryL,G0H64(1),ex6(:),G0H32(49),m3h2x32(:,187),heltab2x64(:,:,187))
  Gcoeff(:)%j = (-(c(88)*M(1,:)%j)) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(190),h0tab(:,190),[32,3,8,16,4],[nMW,nMW,nMT,nMT,nMW],5,1,wf4(:,1))
  call Hloop_TV_S(ntryL,G0H64(1),0,ex6(:),32,G1H32(89),m3h2x32(:,188),heltab2x64(:,:,188))
  Gcoeff(:)%j = (c(124)*M(1,:)%j) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(191),h0tab(:,191),[32,3,8,16,4],[nMW,nMW,nMT,nMT,nMW],5,1,wf4(:,1))
  call Hloop_VV_S(ntryL,G0H64(1),ex6(:),G0H32(50),m3h2x32(:,189),heltab2x64(:,:,189))
  Gcoeff(:)%j = (c(52)*M(1,:)%j) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(192),h0tab(:,192),[32,3,8,16,4],[nMT,nMT,nMW,nMW,nMT],5,1,wf4(:,1))
  call Hloop_QV_A(ntryL,G0H64(1),ex6(:),G0H32(51),m3h2x32(:,190),heltab2x64(:,:,190))
  call Hloop_Q_A(ntryL,G0H32(51),32,nMT,G1H32(90),n2h32(58))
  Gcoeff(:)%j = (c(25)*M(1,:)%j) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(193),h0tab(:,193),[32,3,8,16,4],[nMW,nMW,nMT,nMT,nMW],5,1,wf4(:,1))
  call Hloop_SV_V(ntryL,G0H64(1),ex6(:),G0H32(51),m3h2x32(:,191),heltab2x64(:,:,191))
  Gcoeff(:)%j = (c(88)*M(1,:)%j) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(194),h0tab(:,194),[32,3,8,16,4],[nMW,nMW,nMT,nMT,nMW],5,1,wf4(:,1))
  call Hloop_UV_W(ntryL,G0H64(1),0,ex6(:),32,G1H32(91),m3h2x32(:,192),heltab2x64(:,:,192))
  Gcoeff(:)%j = (c(102)*M(1,:)%j) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(195),h0tab(:,195),[32,3,8,16,4],[nMW,nMW,nMT,nMT,nMW],5,1,wf4(:,1))
  call Hloop_VV_S(ntryL,G0H64(1),ex6(:),G0H32(52),m3h2x32(:,193),heltab2x64(:,:,193))
  Gcoeff(:)%j = (c(25)*M(1,:)%j) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(196),h0tab(:,196),[32,3,8,16,4],[nMW,nMW,nMT,nMT,nMW],5,1,wf4(:,1))
  call Hloop_UV_W(ntryL,G0H64(1),0,ex6(:),32,G1H32(92),m3h2x32(:,194),heltab2x64(:,:,194))
  Gcoeff(:)%j = (c(68)*M(1,:)%j) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(197),h0tab(:,197),[32,4,16,3,8],[nMW,nMT,nMT,nMT,nMW],5,1,wf4(:,1))
  call Hloop_SV_T(ntryL,G0H64(1),0,ex6(:),32,G1H32(93),m3h2x32(:,195),heltab2x64(:,:,195))
  Gcoeff(:)%j = (-(c(137)*M(1,:)%j)) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(198),h0tab(:,198),[32,4,16,3,8],[nMT,nMW,nMW,nMW,nMT],5,1,wf4(:,1))
  call Hloop_AV_Q(ntryL,G0H64(1),ex6(:),G0H32(53),m3h2x32(:,196),heltab2x64(:,:,196))
  call Hloop_A_Q(ntryL,G0H32(53),32,nMT,G1H32(94),n2h32(59))
  Gcoeff(:)%j = (c(52)*M(1,:)%j) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(199),h0tab(:,199),[32,4,16,3,8],[nMW,nMT,nMT,nMT,nMW],5,1,wf4(:,1))
  call Hloop_VV_S(ntryL,G0H64(1),ex6(:),G0H32(53),m3h2x32(:,197),heltab2x64(:,:,197))
  Gcoeff(:)%j = (-(c(52)*M(1,:)%j)) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(200),h0tab(:,200),[32,4,16,3,8],[nMW,nMT,nMT,nMT,nMW],5,1,wf4(:,1))
  call Hloop_SV_V(ntryL,G0H64(1),ex6(:),G0H32(54),m3h2x32(:,198),heltab2x64(:,:,198))
  Gcoeff(:)%j = (c(88)*M(1,:)%j) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(201),h0tab(:,201),[32,4,16,3,8],[nMT,nMW,nMW,nMW,nMT],5,1,wf4(:,1))
  call Hloop_AV_Q(ntryL,G0H64(1),ex6(:),G0H32(55),m3h2x32(:,199),heltab2x64(:,:,199))
  call Hloop_A_Q(ntryL,G0H32(55),32,nMT,G1H32(95),n2h32(60))
  Gcoeff(:)%j = (-(c(88)*M(1,:)%j)) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(202),h0tab(:,202),[32,4,16,3,8],[nMT,nMW,nMW,nMW,nMT],5,1,wf4(:,1))
  call Hloop_AV_Q(ntryL,G0H64(1),ex6(:),G0H32(55),m3h2x32(:,200),heltab2x64(:,:,200))
  call Hloop_A_Q(ntryL,G0H32(55),32,nMT,G1H32(96),n2h32(61))
  Gcoeff(:)%j = (c(124)*M(1,:)%j) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(203),h0tab(:,203),[32,4,16,3,8],[nMT,nMW,nMW,nMW,nMT],5,1,wf4(:,1))
  call Hloop_AV_Q(ntryL,G0H64(1),ex6(:),G0H32(55),m3h2x32(:,201),heltab2x64(:,:,201))
  call Hloop_A_Q(ntryL,G0H32(55),32,nMT,G1H32(97),n2h32(62))
  Gcoeff(:)%j = (c(52)*M(1,:)%j) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(204),h0tab(:,204),[32,4,16,3,8],[nMW,nMT,nMT,nMT,nMW],5,1,wf4(:,1))
  call Hloop_UW_V(ntryL,G0H64(1),0,ex6(:),32,G1H32(98),m3h2x32(:,202),heltab2x64(:,:,202))
  Gcoeff(:)%j = (c(25)*M(1,:)%j) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(205),h0tab(:,205),[32,4,16,3,8],[nMT,nMW,nMW,nMW,nMT],5,1,wf4(:,1))
  call Hloop_AV_Q(ntryL,G0H64(1),ex6(:),G0H32(55),m3h2x32(:,203),heltab2x64(:,:,203))
  call Hloop_A_Q(ntryL,G0H32(55),32,nMT,G1H32(99),n2h32(63))
  Gcoeff(:)%j = (c(88)*M(1,:)%j) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(206),h0tab(:,206),[32,4,16,3,8],[nMT,nMW,nMW,nMW,nMT],5,1,wf4(:,1))
  call Hloop_AV_Q(ntryL,G0H64(1),ex6(:),G0H32(55),m3h2x32(:,204),heltab2x64(:,:,204))
  call Hloop_A_Q(ntryL,G0H32(55),32,nMT,G1H32(100),n2h32(64))
  Gcoeff(:)%j = (c(102)*M(1,:)%j) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(207),h0tab(:,207),[32,4,16,3,8],[nMT,nMW,nMW,nMW,nMT],5,1,wf4(:,1))
  call Hloop_AV_Q(ntryL,G0H64(1),ex6(:),G0H32(55),m3h2x32(:,205),heltab2x64(:,:,205))
  call Hloop_A_Q(ntryL,G0H32(55),32,nMT,G1H32(101),n2h32(65))
  Gcoeff(:)%j = (c(25)*M(1,:)%j) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(208),h0tab(:,208),[32,4,16,3,8],[nMT,nMW,nMW,nMW,nMT],5,1,wf4(:,1))
  call Hloop_AV_Q(ntryL,G0H64(1),ex6(:),G0H32(55),m3h2x32(:,206),heltab2x64(:,:,206))
  call Hloop_A_Q(ntryL,G0H32(55),32,nMT,G1H32(102),n2h32(66))
  Gcoeff(:)%j = (c(68)*M(1,:)%j) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(209),h0tab(:,209),[32,3,4,16,8],[nMT,nMT,nMW,nMW,nMT],5,1,wf4(:,1))
  call Hloop_AV_Q(ntryL,G0H64(1),ex6(:),G0H32(55),m3h2x32(:,207),heltab2x64(:,:,207))
  call Hloop_A_Q(ntryL,G0H32(55),32,nMT,G1H32(103),n2h32(67))
  Gcoeff(:)%j = (-(c(137)*M(1,:)%j)) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(210),h0tab(:,210),[32,3,4,16,8],[nMW,nMW,nMT,nMT,nMW],5,1,wf4(:,1))
  call Hloop_SV_T(ntryL,G0H64(1),0,ex6(:),32,G1H32(104),m3h2x32(:,208),heltab2x64(:,:,208))
  Gcoeff(:)%j = (c(52)*M(1,:)%j) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(211),h0tab(:,211),[32,3,4,16,8],[nMT,nMT,nMW,nMW,nMT],5,1,wf4(:,1))
  call Hloop_AV_Q(ntryL,G0H64(1),ex6(:),G0H32(55),m3h2x32(:,209),heltab2x64(:,:,209))
  call Hloop_A_Q(ntryL,G0H32(55),32,nMT,G1H32(105),n2h32(68))
  Gcoeff(:)%j = (-(c(52)*M(1,:)%j)) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(212),h0tab(:,212),[32,3,4,16,8],[nMT,nMT,nMW,nMW,nMT],5,1,wf4(:,1))
  call Hloop_AV_Q(ntryL,G0H64(1),ex6(:),G0H32(55),m3h2x32(:,210),heltab2x64(:,:,210))
  call Hloop_A_Q(ntryL,G0H32(55),32,nMT,G1H32(106),n2h32(69))
  Gcoeff(:)%j = (c(88)*M(1,:)%j) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(213),h0tab(:,213),[32,3,4,16,8],[nMW,nMW,nMT,nMT,nMW],5,1,wf4(:,1))
  call Hloop_SV_V(ntryL,G0H64(1),ex6(:),G0H32(55),m3h2x32(:,211),heltab2x64(:,:,211))
  Gcoeff(:)%j = (-(c(124)*M(1,:)%j)) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(214),h0tab(:,214),[32,3,4,16,8],[nMW,nMW,nMT,nMT,nMW],5,1,wf4(:,1))
  call Hloop_VV_S(ntryL,G0H64(1),ex6(:),G0H32(56),m3h2x32(:,212),heltab2x64(:,:,212))
  Gcoeff(:)%j = (c(88)*M(1,:)%j) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(215),h0tab(:,215),[32,3,4,16,8],[nMW,nMW,nMT,nMT,nMW],5,1,wf4(:,1))
  call Hloop_SV_T(ntryL,G0H64(1),0,ex6(:),32,G1H32(107),m3h2x32(:,213),heltab2x64(:,:,213))
  Gcoeff(:)%j = (c(52)*M(1,:)%j) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(216),h0tab(:,216),[32,3,4,16,8],[nMT,nMT,nMW,nMW,nMT],5,1,wf4(:,1))
  call Hloop_AV_Q(ntryL,G0H64(1),ex6(:),G0H32(57),m3h2x32(:,214),heltab2x64(:,:,214))
  call Hloop_A_Q(ntryL,G0H32(57),32,nMT,G1H32(108),n2h32(70))
  Gcoeff(:)%j = (-(c(88)*M(1,:)%j)) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(217),h0tab(:,217),[32,3,4,16,8],[nMW,nMW,nMT,nMT,nMW],5,1,wf4(:,1))
  call Hloop_UW_V(ntryL,G0H64(1),0,ex6(:),32,G1H32(109),m3h2x32(:,215),heltab2x64(:,:,215))
  Gcoeff(:)%j = (-(c(25)*M(1,:)%j)) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(218),h0tab(:,218),[32,3,4,16,8],[nMW,nMW,nMT,nMT,nMW],5,1,wf4(:,1))
  call Hloop_SV_V(ntryL,G0H64(1),ex6(:),G0H32(57),m3h2x32(:,216),heltab2x64(:,:,216))
  Gcoeff(:)%j = (c(102)*M(1,:)%j) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(219),h0tab(:,219),[32,3,4,16,8],[nMW,nMW,nMT,nMT,nMW],5,1,wf4(:,1))
  call Hloop_VV_S(ntryL,G0H64(1),ex6(:),G0H32(58),m3h2x32(:,217),heltab2x64(:,:,217))
  Gcoeff(:)%j = (c(25)*M(1,:)%j) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(220),h0tab(:,220),[32,3,4,16,8],[nMW,nMW,nMT,nMT,nMW],5,1,wf4(:,1))
  call Hloop_UW_V(ntryL,G0H64(1),0,ex6(:),32,G1H32(110),m3h2x32(:,218),heltab2x64(:,:,218))
  Gcoeff(:)%j = (c(39)*M(1,:)%j) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(221),h0tab(:,221),[32,8,3,4,16],[nMB,nMZ,nMH,nMB,nMB],5,1,wf4(:,1))
  call Hloop_QV_A(ntryL,G0H64(1),ex6(:),G0H32(59),m3h2x32(:,219),heltab2x64(:,:,219))
  call Hloop_Q_A(ntryL,G0H32(59),32,nMB,G1H32(111),n2h32(71))
  Gcoeff(:)%j = (c(39)*M(1,:)%j) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(222),h0tab(:,222),[32,8,3,4,16],[nMB,nMH,nMZ,nMB,nMB],5,1,wf4(:,1))
  call Hloop_QV_A(ntryL,G0H64(1),ex6(:),G0H32(59),m3h2x32(:,220),heltab2x64(:,:,220))
  call Hloop_Q_A(ntryL,G0H32(59),32,nMB,G1H32(112),n2h32(72))
  Gcoeff(:)%j = (-(c(136)*M(1,:)%j)) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(223),h0tab(:,223),[32,8,3,4,16],[nMT,nMW,nMW,nMT,nMT],5,1,wf4(:,1))
  call Hloop_QV_A(ntryL,G0H64(1),ex6(:),G0H32(59),m3h2x32(:,221),heltab2x64(:,:,221))
  call Hloop_Q_A(ntryL,G0H32(59),32,nMT,G1H32(113),n2h32(73))
  Gcoeff(:)%j = (c(69)*M(1,:)%j) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(224),h0tab(:,224),[32,8,3,4,16],[nMW,nMT,nMT,nMW,nMW],5,1,wf4(:,1))
  call Hloop_TV_S(ntryL,G0H64(1),0,ex6(:),32,G1H32(114),m3h2x32(:,222),heltab2x64(:,:,222))
  Gcoeff(:)%j = (-(c(60)*M(1,:)%j)) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(225),h0tab(:,225),[32,8,3,4,16],[nMB,nMZ,nMH,nMB,nMB],5,1,wf4(:,1))
  call Hloop_QV_A(ntryL,G0H64(1),ex6(:),G0H32(59),m3h2x32(:,223),heltab2x64(:,:,223))
  call Hloop_Q_A(ntryL,G0H32(59),32,nMB,G1H32(115),n2h32(74))
  Gcoeff(:)%j = (-(c(87)*M(1,:)%j)) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(226),h0tab(:,226),[32,8,3,4,16],[nMT,nMW,nMW,nMT,nMT],5,1,wf4(:,1))
  call Hloop_QV_A(ntryL,G0H64(1),ex6(:),G0H32(59),m3h2x32(:,224),heltab2x64(:,:,224))
  call Hloop_Q_A(ntryL,G0H32(59),32,nMT,G1H32(116),n2h32(75))
  Gcoeff(:)%j = (-(c(60)*M(1,:)%j)) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(227),h0tab(:,227),[32,8,3,4,16],[nMB,nMH,nMZ,nMB,nMB],5,1,wf4(:,1))
  call Hloop_QV_A(ntryL,G0H64(1),ex6(:),G0H32(59),m3h2x32(:,225),heltab2x64(:,:,225))
  call Hloop_Q_A(ntryL,G0H32(59),32,nMB,G1H32(117),n2h32(76))
  Gcoeff(:)%j = (c(87)*M(1,:)%j) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(228),h0tab(:,228),[32,8,3,4,16],[nMT,nMW,nMW,nMT,nMT],5,1,wf4(:,1))
  call Hloop_QV_A(ntryL,G0H64(1),ex6(:),G0H32(59),m3h2x32(:,226),heltab2x64(:,:,226))
  call Hloop_Q_A(ntryL,G0H32(59),32,nMT,G1H32(118),n2h32(77))
  Gcoeff(:)%j = (-(c(53)*M(1,:)%j)) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(229),h0tab(:,229),[32,8,3,4,16],[nMW,nMT,nMT,nMW,nMW],5,1,wf4(:,1))
  call Hloop_VV_S(ntryL,G0H64(1),ex6(:),G0H32(59),m3h2x32(:,227),heltab2x64(:,:,227))
  Gcoeff(:)%j = (c(53)*M(1,:)%j) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(230),h0tab(:,230),[32,8,3,4,16],[nMW,nMT,nMT,nMW,nMW],5,1,wf4(:,1))
  call Hloop_SV_V(ntryL,G0H64(1),ex6(:),G0H32(60),m3h2x32(:,228),heltab2x64(:,:,228))
  Gcoeff(:)%j = (-(c(53)*M(1,:)%j)) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(231),h0tab(:,231),[32,8,3,4,16],[nMW,nMT,nMT,nMW,nMW],5,1,wf4(:,1))
  call Hloop_TV_S(ntryL,G0H64(1),0,ex6(:),32,G1H32(119),m3h2x32(:,229),heltab2x64(:,:,229))
  Gcoeff(:)%j = (c(24)*M(1,:)%j) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(232),h0tab(:,232),[32,8,3,4,16],[nMT,nMW,nMW,nMT,nMT],5,1,wf4(:,1))
  call Hloop_QV_A(ntryL,G0H64(1),ex6(:),G0H32(61),m3h2x32(:,230),heltab2x64(:,:,230))
  call Hloop_Q_A(ntryL,G0H32(61),32,nMT,G1H32(120),n2h32(78))
  Gcoeff(:)%j = (c(53)*M(1,:)%j) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(233),h0tab(:,233),[32,8,3,4,16],[nMW,nMT,nMT,nMW,nMW],5,1,wf4(:,1))
  call Hloop_UV_W(ntryL,G0H64(1),0,ex6(:),32,G1H32(121),m3h2x32(:,231),heltab2x64(:,:,231))
  Gcoeff(:)%j = (-(c(53)*M(1,:)%j)) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(234),h0tab(:,234),[32,8,3,4,16],[nMW,nMT,nMT,nMW,nMW],5,1,wf4(:,1))
  call Hloop_VV_S(ntryL,G0H64(1),ex6(:),G0H32(61),m3h2x32(:,232),heltab2x64(:,:,232))
  Gcoeff(:)%j = (-(c(76)*M(1,:)%j)) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(235),h0tab(:,235),[32,8,3,4,16],[nMW,nMT,nMT,nMW,nMW],5,1,wf4(:,1))
  call Hloop_SV_V(ntryL,G0H64(1),ex6(:),G0H32(62),m3h2x32(:,233),heltab2x64(:,:,233))
  Gcoeff(:)%j = (c(53)*M(1,:)%j) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(236),h0tab(:,236),[32,8,3,4,16],[nMW,nMT,nMT,nMW,nMW],5,1,wf4(:,1))
  call Hloop_UV_W(ntryL,G0H64(1),0,ex6(:),32,G1H32(122),m3h2x32(:,234),heltab2x64(:,:,234))
  Gcoeff(:)%j = (c(68)*M(1,:)%j) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(237),h0tab(:,237),[32,4,3,16,8],[nMW,nMT,nMT,nMT,nMW],5,1,wf4(:,1))
  call Hloop_SV_T(ntryL,G0H64(1),0,ex6(:),32,G1H32(123),m3h2x32(:,235),heltab2x64(:,:,235))
  Gcoeff(:)%j = (-(c(137)*M(1,:)%j)) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(238),h0tab(:,238),[32,4,3,16,8],[nMT,nMW,nMW,nMW,nMT],5,1,wf4(:,1))
  call Hloop_AV_Q(ntryL,G0H64(1),ex6(:),G0H32(63),m3h2x32(:,236),heltab2x64(:,:,236))
  call Hloop_A_Q(ntryL,G0H32(63),32,nMT,G1H32(124),n2h32(79))
  Gcoeff(:)%j = (c(52)*M(1,:)%j) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(239),h0tab(:,239),[32,4,3,16,8],[nMW,nMT,nMT,nMT,nMW],5,1,wf4(:,1))
  call Hloop_VV_S(ntryL,G0H64(1),ex6(:),G0H32(63),m3h2x32(:,237),heltab2x64(:,:,237))
  Gcoeff(:)%j = (-(c(52)*M(1,:)%j)) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(240),h0tab(:,240),[32,4,3,16,8],[nMW,nMT,nMT,nMT,nMW],5,1,wf4(:,1))
  call Hloop_SV_V(ntryL,G0H64(1),ex6(:),G0H32(64),m3h2x32(:,238),heltab2x64(:,:,238))
  Gcoeff(:)%j = (c(88)*M(1,:)%j) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(241),h0tab(:,241),[32,4,3,16,8],[nMT,nMW,nMW,nMW,nMT],5,1,wf4(:,1))
  call Hloop_AV_Q(ntryL,G0H64(1),ex6(:),G0H32(65),m3h2x32(:,239),heltab2x64(:,:,239))
  call Hloop_A_Q(ntryL,G0H32(65),32,nMT,G1H32(125),n2h32(80))
  Gcoeff(:)%j = (-(c(124)*M(1,:)%j)) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(242),h0tab(:,242),[32,4,3,16,8],[nMT,nMW,nMW,nMW,nMT],5,1,wf4(:,1))
  call Hloop_AV_Q(ntryL,G0H64(1),ex6(:),G0H32(65),m3h2x32(:,240),heltab2x64(:,:,240))
  call Hloop_A_Q(ntryL,G0H32(65),32,nMT,G1H32(126),n2h32(81))
  Gcoeff(:)%j = (c(88)*M(1,:)%j) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(243),h0tab(:,243),[32,4,3,16,8],[nMT,nMW,nMW,nMW,nMT],5,1,wf4(:,1))
  call Hloop_AV_Q(ntryL,G0H64(1),ex6(:),G0H32(65),m3h2x32(:,241),heltab2x64(:,:,241))
  call Hloop_A_Q(ntryL,G0H32(65),32,nMT,G1H32(127),n2h32(82))
  Gcoeff(:)%j = (c(52)*M(1,:)%j) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(244),h0tab(:,244),[32,4,3,16,8],[nMW,nMT,nMT,nMT,nMW],5,1,wf4(:,1))
  call Hloop_UW_V(ntryL,G0H64(1),0,ex6(:),32,G1H32(128),m3h2x32(:,242),heltab2x64(:,:,242))
  Gcoeff(:)%j = (-(c(88)*M(1,:)%j)) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(245),h0tab(:,245),[32,4,3,16,8],[nMT,nMW,nMW,nMW,nMT],5,1,wf4(:,1))
  call Hloop_AV_Q(ntryL,G0H64(1),ex6(:),G0H32(65),m3h2x32(:,243),heltab2x64(:,:,243))
  call Hloop_A_Q(ntryL,G0H32(65),32,nMT,G1H32(129),n2h32(83))
  Gcoeff(:)%j = (-(c(25)*M(1,:)%j)) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(246),h0tab(:,246),[32,4,3,16,8],[nMT,nMW,nMW,nMW,nMT],5,1,wf4(:,1))
  call Hloop_AV_Q(ntryL,G0H64(1),ex6(:),G0H32(65),m3h2x32(:,244),heltab2x64(:,:,244))
  call Hloop_A_Q(ntryL,G0H32(65),32,nMT,G1H32(130),n2h32(84))
  Gcoeff(:)%j = (c(102)*M(1,:)%j) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(247),h0tab(:,247),[32,4,3,16,8],[nMT,nMW,nMW,nMW,nMT],5,1,wf4(:,1))
  call Hloop_AV_Q(ntryL,G0H64(1),ex6(:),G0H32(65),m3h2x32(:,245),heltab2x64(:,:,245))
  call Hloop_A_Q(ntryL,G0H32(65),32,nMT,G1H32(131),n2h32(85))
  Gcoeff(:)%j = (c(25)*M(1,:)%j) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(248),h0tab(:,248),[32,4,3,16,8],[nMT,nMW,nMW,nMW,nMT],5,1,wf4(:,1))
  call Hloop_AV_Q(ntryL,G0H64(1),ex6(:),G0H32(65),m3h2x32(:,246),heltab2x64(:,:,246))
  call Hloop_A_Q(ntryL,G0H32(65),32,nMT,G1H32(132),n2h32(86))
  Gcoeff(:)%j = (c(39)*M(1,:)%j) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(249),h0tab(:,249),[32,4,3,8,16],[nMB,nMH,nMZ,nMB,nMB],5,1,wf4(:,1))
  call Hloop_AV_Q(ntryL,G0H64(1),ex6(:),G0H32(65),m3h2x32(:,247),heltab2x64(:,:,247))
  call Hloop_A_Q(ntryL,G0H32(65),32,nMB,G1H32(133),n2h32(87))
  Gcoeff(:)%j = (c(39)*M(1,:)%j) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(250),h0tab(:,250),[32,4,3,8,16],[nMB,nMZ,nMH,nMB,nMB],5,1,wf4(:,1))
  call Hloop_AV_Q(ntryL,G0H64(1),ex6(:),G0H32(65),m3h2x32(:,248),heltab2x64(:,:,248))
  call Hloop_A_Q(ntryL,G0H32(65),32,nMB,G1H32(134),n2h32(88))
  Gcoeff(:)%j = (-(c(136)*M(1,:)%j)) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(251),h0tab(:,251),[32,4,3,8,16],[nMT,nMW,nMW,nMT,nMT],5,1,wf4(:,1))
  call Hloop_AV_Q(ntryL,G0H64(1),ex6(:),G0H32(65),m3h2x32(:,249),heltab2x64(:,:,249))
  call Hloop_A_Q(ntryL,G0H32(65),32,nMT,G1H32(135),n2h32(89))
  Gcoeff(:)%j = (c(69)*M(1,:)%j) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(252),h0tab(:,252),[32,4,3,8,16],[nMW,nMT,nMT,nMW,nMW],5,1,wf4(:,1))
  call Hloop_SV_T(ntryL,G0H64(1),0,ex6(:),32,G1H32(136),m3h2x32(:,250),heltab2x64(:,:,250))
  Gcoeff(:)%j = (-(c(60)*M(1,:)%j)) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(253),h0tab(:,253),[32,4,3,8,16],[nMB,nMH,nMZ,nMB,nMB],5,1,wf4(:,1))
  call Hloop_AV_Q(ntryL,G0H64(1),ex6(:),G0H32(65),m3h2x32(:,251),heltab2x64(:,:,251))
  call Hloop_A_Q(ntryL,G0H32(65),32,nMB,G1H32(137),n2h32(90))
  Gcoeff(:)%j = (-(c(87)*M(1,:)%j)) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(254),h0tab(:,254),[32,4,3,8,16],[nMT,nMW,nMW,nMT,nMT],5,1,wf4(:,1))
  call Hloop_AV_Q(ntryL,G0H64(1),ex6(:),G0H32(65),m3h2x32(:,252),heltab2x64(:,:,252))
  call Hloop_A_Q(ntryL,G0H32(65),32,nMT,G1H32(138),n2h32(91))
  Gcoeff(:)%j = (-(c(60)*M(1,:)%j)) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(255),h0tab(:,255),[32,4,3,8,16],[nMB,nMZ,nMH,nMB,nMB],5,1,wf4(:,1))
  call Hloop_AV_Q(ntryL,G0H64(1),ex6(:),G0H32(65),m3h2x32(:,253),heltab2x64(:,:,253))
  call Hloop_A_Q(ntryL,G0H32(65),32,nMB,G1H32(139),n2h32(92))
  Gcoeff(:)%j = (c(87)*M(1,:)%j) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(256),h0tab(:,256),[32,4,3,8,16],[nMT,nMW,nMW,nMT,nMT],5,1,wf4(:,1))
  call Hloop_AV_Q(ntryL,G0H64(1),ex6(:),G0H32(65),m3h2x32(:,254),heltab2x64(:,:,254))
  call Hloop_A_Q(ntryL,G0H32(65),32,nMT,G1H32(140),n2h32(93))
  Gcoeff(:)%j = (-(c(53)*M(1,:)%j)) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(257),h0tab(:,257),[32,4,3,8,16],[nMW,nMT,nMT,nMW,nMW],5,1,wf4(:,1))
  call Hloop_VV_S(ntryL,G0H64(1),ex6(:),G0H32(65),m3h2x32(:,255),heltab2x64(:,:,255))
  Gcoeff(:)%j = (c(53)*M(1,:)%j) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(258),h0tab(:,258),[32,4,3,8,16],[nMW,nMT,nMT,nMW,nMW],5,1,wf4(:,1))
  call Hloop_SV_T(ntryL,G0H64(1),0,ex6(:),32,G1H32(141),m3h2x32(:,256),heltab2x64(:,:,256))
  Gcoeff(:)%j = (-(c(53)*M(1,:)%j)) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(259),h0tab(:,259),[32,4,3,8,16],[nMW,nMT,nMT,nMW,nMW],5,1,wf4(:,1))
  call Hloop_SV_V(ntryL,G0H64(1),ex6(:),G0H32(66),m3h2x32(:,257),heltab2x64(:,:,257))
  Gcoeff(:)%j = (c(24)*M(1,:)%j) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(260),h0tab(:,260),[32,4,3,8,16],[nMT,nMW,nMW,nMT,nMT],5,1,wf4(:,1))
  call Hloop_AV_Q(ntryL,G0H64(1),ex6(:),G0H32(67),m3h2x32(:,258),heltab2x64(:,:,258))
  call Hloop_A_Q(ntryL,G0H32(67),32,nMT,G1H32(142),n2h32(94))
  Gcoeff(:)%j = (c(53)*M(1,:)%j) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(261),h0tab(:,261),[32,4,3,8,16],[nMW,nMT,nMT,nMW,nMW],5,1,wf4(:,1))
  call Hloop_VV_S(ntryL,G0H64(1),ex6(:),G0H32(67),m3h2x32(:,259),heltab2x64(:,:,259))
  Gcoeff(:)%j = (-(c(53)*M(1,:)%j)) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(262),h0tab(:,262),[32,4,3,8,16],[nMW,nMT,nMT,nMW,nMW],5,1,wf4(:,1))
  call Hloop_UW_V(ntryL,G0H64(1),0,ex6(:),32,G1H32(143),m3h2x32(:,260),heltab2x64(:,:,260))
  Gcoeff(:)%j = (-(c(76)*M(1,:)%j)) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(263),h0tab(:,263),[32,4,3,8,16],[nMW,nMT,nMT,nMW,nMW],5,1,wf4(:,1))
  call Hloop_SV_V(ntryL,G0H64(1),ex6(:),G0H32(68),m3h2x32(:,261),heltab2x64(:,:,261))
  Gcoeff(:)%j = (c(53)*M(1,:)%j) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(264),h0tab(:,264),[32,4,3,8,16],[nMW,nMT,nMT,nMW,nMW],5,1,wf4(:,1))
  call Hloop_UW_V(ntryL,G0H64(1),0,ex6(:),32,G1H32(144),m3h2x32(:,262),heltab2x64(:,:,262))
  Gcoeff(:)%j = (c(18)*M(1,:)%j) * den(124)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(265),h0tab(:,265),[32,2,1,16,12],[nMW,0,nMW,nMW,nMW],5,1,wf4(:,43))
  call Hloop_SV_V(ntryL,G0H64(1),ex6(:),G0H32(69),m3h2x32(:,263),heltab2x64(:,:,263))
  Gcoeff(:)%j = (-(c(16)*M(1,:)%j)) * den(124)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(266),h0tab(:,266),[32,2,1,16,12],[nMW,0,nMW,nMW,nMW],5,1,wf4(:,43))
  call Hloop_UW_V(ntryL,G0H64(1),0,ex6(:),32,G1H32(145),m3h2x32(:,264),heltab2x64(:,:,264))
  Gcoeff(:)%j = (c(16)*M(1,:)%j) * den(20)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(267),h0tab(:,267),[32,2,1,16,12],[nMW,0,nMW,nMW,nMW],5,1,wf4(:,12))
  call Hloop_UW_V(ntryL,G0H64(1),0,ex6(:),32,G1H32(146),m3h2x32(:,265),heltab2x64(:,:,265))
  Gcoeff(:)%j = (c(16)*M(1,:)%j) * den(124)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(268),h0tab(:,268),[32,2,1,16,12],[nMW,0,nMW,nMW,nMW],5,1,wf4(:,43))
  call Hloop_SV_V(ntryL,G0H64(1),ex6(:),G0H32(70),m3h2x32(:,266),heltab2x64(:,:,266))
  Gcoeff(:)%j = (c(16)*M(1,:)%j) * den(20)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(269),h0tab(:,269),[32,2,1,16,12],[nMW,0,nMW,nMW,nMW],5,1,wf4(:,12))
  call Hloop_SV_V(ntryL,G0H64(1),ex6(:),G0H32(71),m3h2x32(:,267),heltab2x64(:,:,267))
  Gcoeff(:)%j = (-(c(17)*M(1,:)%j)) * den(124)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(270),h0tab(:,270),[32,2,1,16,12],[nMW,0,nMW,nMW,nMW],5,1,wf4(:,43))
  call Hloop_UW_V(ntryL,G0H64(1),0,ex6(:),32,G1H32(147),m3h2x32(:,268),heltab2x64(:,:,268))
  Gcoeff(:)%j = (c(50)*M(1,:)%j) * den(18)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(271),h0tab(:,271),[32,2,1,16,12],[0,nMW,0,0,0],5,1,wf4(:,10))
  call Hloop_QV_A(ntryL,G0H64(1),ex6(:),G0H32(72),m3h2x32(:,269),heltab2x64(:,:,269))
  call Hloop_Q_A(ntryL,G0H32(72),32,0,G1H32(148),n2h32(95))
  Gcoeff(:)%j = (c(53)*M(1,:)%j) * den(20)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(272),h0tab(:,272),[32,2,1,16,12],[0,nMW,0,0,0],5,1,wf4(:,11))
  call Hloop_QV_A(ntryL,G0H64(1),ex6(:),G0H32(72),m3h2x32(:,270),heltab2x64(:,:,270))
  call Hloop_Q_A(ntryL,G0H32(72),32,0,G1H32(149),n2h32(96))
  Gcoeff(:)%j = (c(75)*M(1,:)%j) * den(18)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(273),h0tab(:,273),[32,2,1,16,12],[nMW,0,nMW,nMW,nMW],5,1,wf4(:,10))
  call Hloop_SV_V(ntryL,G0H64(1),ex6(:),G0H32(72),m3h2x32(:,271),heltab2x64(:,:,271))
  Gcoeff(:)%j = (c(146)*M(1,:)%j) * den(20)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(274),h0tab(:,274),[32,2,1,16,12],[nMW,0,nMW,nMW,nMW],5,1,wf4(:,11))
  call Hloop_SV_V(ntryL,G0H64(1),ex6(:),G0H32(73),m3h2x32(:,272),heltab2x64(:,:,272))
  Gcoeff(:)%j = (c(75)*M(1,:)%j) * den(18)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(275),h0tab(:,275),[32,2,1,16,12],[nMW,0,nMW,nMW,nMW],5,1,wf4(:,10))
  call Hloop_UW_V(ntryL,G0H64(1),0,ex6(:),32,G1H32(150),m3h2x32(:,273),heltab2x64(:,:,273))
  Gcoeff(:)%j = (c(103)*M(1,:)%j) * den(20)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(276),h0tab(:,276),[32,2,1,16,12],[nMW,0,nMW,nMW,nMW],5,1,wf4(:,11))
  call Hloop_UW_V(ntryL,G0H64(1),0,ex6(:),32,G1H32(151),m3h2x32(:,274),heltab2x64(:,:,274))
  Gcoeff(:)%j = (c(75)*M(1,:)%j) * den(18)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(277),h0tab(:,277),[32,2,1,16,12],[nMW,0,nMW,nMW,nMW],5,1,wf4(:,10))
  call Hloop_SV_V(ntryL,G0H64(1),ex6(:),G0H32(74),m3h2x32(:,275),heltab2x64(:,:,275))
  Gcoeff(:)%j = (c(103)*M(1,:)%j) * den(20)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(278),h0tab(:,278),[32,2,1,16,12],[nMW,0,nMW,nMW,nMW],5,1,wf4(:,11))
  call Hloop_SV_V(ntryL,G0H64(1),ex6(:),G0H32(75),m3h2x32(:,276),heltab2x64(:,:,276))
  Gcoeff(:)%j = (-(c(50)*M(1,:)%j)) * den(18)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(279),h0tab(:,279),[32,2,1,16,12],[nMW,0,nMW,nMW,nMW],5,1,wf4(:,10))
  call Hloop_UW_V(ntryL,G0H64(1),0,ex6(:),32,G1H32(152),m3h2x32(:,277),heltab2x64(:,:,277))
  Gcoeff(:)%j = (c(26)*M(1,:)%j) * den(20)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(280),h0tab(:,280),[32,2,1,16,12],[nMW,0,nMW,nMW,nMW],5,1,wf4(:,11))
  call Hloop_UW_V(ntryL,G0H64(1),0,ex6(:),32,G1H32(153),m3h2x32(:,278),heltab2x64(:,:,278))
  Gcoeff(:)%j = (-(c(16)*M(1,:)%j)) * den(124)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(281),h0tab(:,281),[32,12,2,1,16],[nMW,nMW,0,nMW,nMW],5,1,wf4(:,43))
  call Hloop_SV_T(ntryL,G0H64(1),0,ex6(:),32,G1H32(154),m3h2x32(:,279),heltab2x64(:,:,279))
  Gcoeff(:)%j = (c(16)*M(1,:)%j) * den(20)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(282),h0tab(:,282),[32,12,2,1,16],[nMW,nMW,0,nMW,nMW],5,1,wf4(:,12))
  call Hloop_SV_T(ntryL,G0H64(1),0,ex6(:),32,G1H32(155),m3h2x32(:,280),heltab2x64(:,:,280))
  Gcoeff(:)%j = (c(20)*M(1,:)%j) * den(124)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(283),h0tab(:,283),[32,12,2,1,16],[nMW,nMW,0,nMW,nMW],5,1,wf4(:,43))
  call Hloop_SV_V(ntryL,G0H64(1),ex6(:),G0H32(76),m3h2x32(:,281),heltab2x64(:,:,281))
  Gcoeff(:)%j = (-(c(16)*M(1,:)%j)) * den(124)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(284),h0tab(:,284),[32,12,2,1,16],[nMW,nMW,0,nMW,nMW],5,1,wf4(:,43))
  call Hloop_VV_S(ntryL,G0H64(1),ex6(:),G0H32(77),m3h2x32(:,282),heltab2x64(:,:,282))
  Gcoeff(:)%j = (c(16)*M(1,:)%j) * den(20)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(285),h0tab(:,285),[32,12,2,1,16],[nMW,nMW,0,nMW,nMW],5,1,wf4(:,12))
  call Hloop_VV_S(ntryL,G0H64(1),ex6(:),G0H32(78),m3h2x32(:,283),heltab2x64(:,:,283))
  Gcoeff(:)%j = (-(c(17)*M(1,:)%j)) * den(124)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(286),h0tab(:,286),[32,12,2,1,16],[nMW,nMW,0,nMW,nMW],5,1,wf4(:,43))
  call Hloop_UW_V(ntryL,G0H64(1),0,ex6(:),32,G1H32(156),m3h2x32(:,284),heltab2x64(:,:,284))
  Gcoeff(:)%j = (c(50)*M(1,:)%j) * den(18)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(287),h0tab(:,287),[32,12,2,1,16],[0,0,nMW,0,0],5,1,wf4(:,10))
  call Hloop_QV_A(ntryL,G0H64(1),ex6(:),G0H32(79),m3h2x32(:,285),heltab2x64(:,:,285))
  call Hloop_Q_A(ntryL,G0H32(79),32,0,G1H32(157),n2h32(97))
  Gcoeff(:)%j = (c(53)*M(1,:)%j) * den(20)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(288),h0tab(:,288),[32,12,2,1,16],[0,0,nMW,0,0],5,1,wf4(:,11))
  call Hloop_QV_A(ntryL,G0H64(1),ex6(:),G0H32(79),m3h2x32(:,286),heltab2x64(:,:,286))
  call Hloop_Q_A(ntryL,G0H32(79),32,0,G1H32(158),n2h32(98))
  Gcoeff(:)%j = (c(75)*M(1,:)%j) * den(18)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(289),h0tab(:,289),[32,12,2,1,16],[nMW,nMW,0,nMW,nMW],5,1,wf4(:,10))
  call Hloop_SV_T(ntryL,G0H64(1),0,ex6(:),32,G1H32(159),m3h2x32(:,287),heltab2x64(:,:,287))
  Gcoeff(:)%j = (c(103)*M(1,:)%j) * den(20)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(290),h0tab(:,290),[32,12,2,1,16],[nMW,nMW,0,nMW,nMW],5,1,wf4(:,11))
  call Hloop_SV_T(ntryL,G0H64(1),0,ex6(:),32,G1H32(160),m3h2x32(:,288),heltab2x64(:,:,288))
  Gcoeff(:)%j = (c(75)*M(1,:)%j) * den(18)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(291),h0tab(:,291),[32,12,2,1,16],[nMW,nMW,0,nMW,nMW],5,1,wf4(:,10))
  call Hloop_SV_V(ntryL,G0H64(1),ex6(:),G0H32(79),m3h2x32(:,289),heltab2x64(:,:,289))
  Gcoeff(:)%j = (-(c(43)*M(1,:)%j)) * den(20)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(292),h0tab(:,292),[32,12,2,1,16],[nMW,nMW,0,nMW,nMW],5,1,wf4(:,11))
  call Hloop_SV_V(ntryL,G0H64(1),ex6(:),G0H32(80),m3h2x32(:,290),heltab2x64(:,:,290))
  Gcoeff(:)%j = (c(75)*M(1,:)%j) * den(18)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(293),h0tab(:,293),[32,12,2,1,16],[nMW,nMW,0,nMW,nMW],5,1,wf4(:,10))
  call Hloop_VV_S(ntryL,G0H64(1),ex6(:),G0H32(81),m3h2x32(:,291),heltab2x64(:,:,291))
  Gcoeff(:)%j = (c(103)*M(1,:)%j) * den(20)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(294),h0tab(:,294),[32,12,2,1,16],[nMW,nMW,0,nMW,nMW],5,1,wf4(:,11))
  call Hloop_VV_S(ntryL,G0H64(1),ex6(:),G0H32(82),m3h2x32(:,292),heltab2x64(:,:,292))
  Gcoeff(:)%j = (-(c(50)*M(1,:)%j)) * den(18)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(295),h0tab(:,295),[32,12,2,1,16],[nMW,nMW,0,nMW,nMW],5,1,wf4(:,10))
  call Hloop_UW_V(ntryL,G0H64(1),0,ex6(:),32,G1H32(161),m3h2x32(:,293),heltab2x64(:,:,293))
  Gcoeff(:)%j = (c(26)*M(1,:)%j) * den(20)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(296),h0tab(:,296),[32,12,2,1,16],[nMW,nMW,0,nMW,nMW],5,1,wf4(:,11))
  call Hloop_UW_V(ntryL,G0H64(1),0,ex6(:),32,G1H32(162),m3h2x32(:,294),heltab2x64(:,:,294))
  Gcoeff(:)%j = (c(18)*M(1,:)%j) * den(124)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(297),h0tab(:,297),[32,1,2,16,12],[nMW,0,nMW,nMW,nMW],5,1,wf4(:,43))
  call Hloop_SV_V(ntryL,G0H64(1),ex6(:),G0H32(83),m3h2x32(:,295),heltab2x64(:,:,295))
  Gcoeff(:)%j = (c(16)*M(1,:)%j) * den(124)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(298),h0tab(:,298),[32,1,2,16,12],[nMW,0,nMW,nMW,nMW],5,1,wf4(:,43))
  call Hloop_UV_W(ntryL,G0H64(1),0,ex6(:),32,G1H32(163),m3h2x32(:,296),heltab2x64(:,:,296))
  Gcoeff(:)%j = (c(16)*M(1,:)%j) * den(20)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(299),h0tab(:,299),[32,1,2,16,12],[nMW,0,nMW,nMW,nMW],5,1,wf4(:,12))
  call Hloop_UV_W(ntryL,G0H64(1),0,ex6(:),32,G1H32(164),m3h2x32(:,297),heltab2x64(:,:,297))
  Gcoeff(:)%j = (-(c(16)*M(1,:)%j)) * den(124)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(300),h0tab(:,300),[32,1,2,16,12],[nMW,0,nMW,nMW,nMW],5,1,wf4(:,43))
  call Hloop_SV_V(ntryL,G0H64(1),ex6(:),G0H32(84),m3h2x32(:,298),heltab2x64(:,:,298))
  Gcoeff(:)%j = (c(16)*M(1,:)%j) * den(20)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(301),h0tab(:,301),[32,1,2,16,12],[nMW,0,nMW,nMW,nMW],5,1,wf4(:,12))
  call Hloop_SV_V(ntryL,G0H64(1),ex6(:),G0H32(85),m3h2x32(:,299),heltab2x64(:,:,299))
  Gcoeff(:)%j = (-(c(17)*M(1,:)%j)) * den(124)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(302),h0tab(:,302),[32,1,2,16,12],[nMW,0,nMW,nMW,nMW],5,1,wf4(:,43))
  call Hloop_UV_W(ntryL,G0H64(1),0,ex6(:),32,G1H32(165),m3h2x32(:,300),heltab2x64(:,:,300))
  Gcoeff(:)%j = (c(50)*M(1,:)%j) * den(18)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(303),h0tab(:,303),[32,1,2,16,12],[0,nMW,0,0,0],5,1,wf4(:,10))
  call Hloop_AV_Q(ntryL,G0H64(1),ex6(:),G0H32(86),m3h2x32(:,301),heltab2x64(:,:,301))
  call Hloop_A_Q(ntryL,G0H32(86),32,0,G1H32(166),n2h32(99))
  Gcoeff(:)%j = (c(53)*M(1,:)%j) * den(20)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(304),h0tab(:,304),[32,1,2,16,12],[0,nMW,0,0,0],5,1,wf4(:,11))
  call Hloop_AV_Q(ntryL,G0H64(1),ex6(:),G0H32(86),m3h2x32(:,302),heltab2x64(:,:,302))
  call Hloop_A_Q(ntryL,G0H32(86),32,0,G1H32(167),n2h32(100))
  Gcoeff(:)%j = (c(75)*M(1,:)%j) * den(18)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(305),h0tab(:,305),[32,1,2,16,12],[nMW,0,nMW,nMW,nMW],5,1,wf4(:,10))
  call Hloop_SV_V(ntryL,G0H64(1),ex6(:),G0H32(86),m3h2x32(:,303),heltab2x64(:,:,303))
  Gcoeff(:)%j = (c(146)*M(1,:)%j) * den(20)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(306),h0tab(:,306),[32,1,2,16,12],[nMW,0,nMW,nMW,nMW],5,1,wf4(:,11))
  call Hloop_SV_V(ntryL,G0H64(1),ex6(:),G0H32(87),m3h2x32(:,304),heltab2x64(:,:,304))
  Gcoeff(:)%j = (c(75)*M(1,:)%j) * den(18)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(307),h0tab(:,307),[32,1,2,16,12],[nMW,0,nMW,nMW,nMW],5,1,wf4(:,10))
  call Hloop_UV_W(ntryL,G0H64(1),0,ex6(:),32,G1H32(168),m3h2x32(:,305),heltab2x64(:,:,305))
  Gcoeff(:)%j = (c(103)*M(1,:)%j) * den(20)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(308),h0tab(:,308),[32,1,2,16,12],[nMW,0,nMW,nMW,nMW],5,1,wf4(:,11))
  call Hloop_UV_W(ntryL,G0H64(1),0,ex6(:),32,G1H32(169),m3h2x32(:,306),heltab2x64(:,:,306))
  Gcoeff(:)%j = (c(75)*M(1,:)%j) * den(18)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(309),h0tab(:,309),[32,1,2,16,12],[nMW,0,nMW,nMW,nMW],5,1,wf4(:,10))
  call Hloop_SV_V(ntryL,G0H64(1),ex6(:),G0H32(88),m3h2x32(:,307),heltab2x64(:,:,307))
  Gcoeff(:)%j = (c(103)*M(1,:)%j) * den(20)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(310),h0tab(:,310),[32,1,2,16,12],[nMW,0,nMW,nMW,nMW],5,1,wf4(:,11))
  call Hloop_SV_V(ntryL,G0H64(1),ex6(:),G0H32(89),m3h2x32(:,308),heltab2x64(:,:,308))
  Gcoeff(:)%j = (-(c(50)*M(1,:)%j)) * den(18)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(311),h0tab(:,311),[32,1,2,16,12],[nMW,0,nMW,nMW,nMW],5,1,wf4(:,10))
  call Hloop_UV_W(ntryL,G0H64(1),0,ex6(:),32,G1H32(170),m3h2x32(:,309),heltab2x64(:,:,309))
  Gcoeff(:)%j = (c(26)*M(1,:)%j) * den(20)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(312),h0tab(:,312),[32,1,2,16,12],[nMW,0,nMW,nMW,nMW],5,1,wf4(:,11))
  call Hloop_UV_W(ntryL,G0H64(1),0,ex6(:),32,G1H32(171),m3h2x32(:,310),heltab2x64(:,:,310))
  Gcoeff(:)%j = (-(c(16)*M(1,:)%j)) * den(124)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(313),h0tab(:,313),[32,1,2,12,16],[nMW,0,nMW,nMW,nMW],5,1,wf4(:,43))
  call Hloop_SV_V(ntryL,G0H64(1),ex6(:),G0H32(90),m3h2x32(:,311),heltab2x64(:,:,311))
  Gcoeff(:)%j = (c(16)*M(1,:)%j) * den(20)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(314),h0tab(:,314),[32,1,2,12,16],[nMW,0,nMW,nMW,nMW],5,1,wf4(:,12))
  call Hloop_SV_V(ntryL,G0H64(1),ex6(:),G0H32(91),m3h2x32(:,312),heltab2x64(:,:,312))
  Gcoeff(:)%j = (c(20)*M(1,:)%j) * den(124)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(315),h0tab(:,315),[32,1,2,12,16],[nMW,0,nMW,nMW,nMW],5,1,wf4(:,43))
  call Hloop_SV_V(ntryL,G0H64(1),ex6(:),G0H32(92),m3h2x32(:,313),heltab2x64(:,:,313))
  Gcoeff(:)%j = (-(c(16)*M(1,:)%j)) * den(124)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(316),h0tab(:,316),[32,1,2,12,16],[nMW,0,nMW,nMW,nMW],5,1,wf4(:,43))
  call Hloop_UV_W(ntryL,G0H64(1),0,ex6(:),32,G1H32(172),m3h2x32(:,314),heltab2x64(:,:,314))
  Gcoeff(:)%j = (c(16)*M(1,:)%j) * den(20)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(317),h0tab(:,317),[32,1,2,12,16],[nMW,0,nMW,nMW,nMW],5,1,wf4(:,12))
  call Hloop_UV_W(ntryL,G0H64(1),0,ex6(:),32,G1H32(173),m3h2x32(:,315),heltab2x64(:,:,315))
  Gcoeff(:)%j = (-(c(17)*M(1,:)%j)) * den(124)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(318),h0tab(:,318),[32,1,2,12,16],[nMW,0,nMW,nMW,nMW],5,1,wf4(:,43))
  call Hloop_UV_W(ntryL,G0H64(1),0,ex6(:),32,G1H32(174),m3h2x32(:,316),heltab2x64(:,:,316))
  Gcoeff(:)%j = (c(50)*M(1,:)%j) * den(18)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(319),h0tab(:,319),[32,1,2,12,16],[0,nMW,0,0,0],5,1,wf4(:,10))
  call Hloop_AV_Q(ntryL,G0H64(1),ex6(:),G0H32(93),m3h2x32(:,317),heltab2x64(:,:,317))
  call Hloop_A_Q(ntryL,G0H32(93),32,0,G1H32(175),n2h32(101))
  Gcoeff(:)%j = (c(53)*M(1,:)%j) * den(20)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(320),h0tab(:,320),[32,1,2,12,16],[0,nMW,0,0,0],5,1,wf4(:,11))
  call Hloop_AV_Q(ntryL,G0H64(1),ex6(:),G0H32(93),m3h2x32(:,318),heltab2x64(:,:,318))
  call Hloop_A_Q(ntryL,G0H32(93),32,0,G1H32(176),n2h32(102))
  Gcoeff(:)%j = (c(75)*M(1,:)%j) * den(18)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(321),h0tab(:,321),[32,1,2,12,16],[nMW,0,nMW,nMW,nMW],5,1,wf4(:,10))
  call Hloop_SV_V(ntryL,G0H64(1),ex6(:),G0H32(93),m3h2x32(:,319),heltab2x64(:,:,319))
  Gcoeff(:)%j = (c(103)*M(1,:)%j) * den(20)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(322),h0tab(:,322),[32,1,2,12,16],[nMW,0,nMW,nMW,nMW],5,1,wf4(:,11))
  call Hloop_SV_V(ntryL,G0H64(1),ex6(:),G0H32(94),m3h2x32(:,320),heltab2x64(:,:,320))
  Gcoeff(:)%j = (c(75)*M(1,:)%j) * den(18)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(323),h0tab(:,323),[32,1,2,12,16],[nMW,0,nMW,nMW,nMW],5,1,wf4(:,10))
  call Hloop_SV_V(ntryL,G0H64(1),ex6(:),G0H32(95),m3h2x32(:,321),heltab2x64(:,:,321))
  Gcoeff(:)%j = (-(c(43)*M(1,:)%j)) * den(20)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(324),h0tab(:,324),[32,1,2,12,16],[nMW,0,nMW,nMW,nMW],5,1,wf4(:,11))
  call Hloop_SV_V(ntryL,G0H64(1),ex6(:),G0H32(96),m3h2x32(:,322),heltab2x64(:,:,322))
  Gcoeff(:)%j = (c(75)*M(1,:)%j) * den(18)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(325),h0tab(:,325),[32,1,2,12,16],[nMW,0,nMW,nMW,nMW],5,1,wf4(:,10))
  call Hloop_UV_W(ntryL,G0H64(1),0,ex6(:),32,G1H32(177),m3h2x32(:,323),heltab2x64(:,:,323))
  Gcoeff(:)%j = (c(103)*M(1,:)%j) * den(20)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(326),h0tab(:,326),[32,1,2,12,16],[nMW,0,nMW,nMW,nMW],5,1,wf4(:,11))
  call Hloop_UV_W(ntryL,G0H64(1),0,ex6(:),32,G1H32(178),m3h2x32(:,324),heltab2x64(:,:,324))
  Gcoeff(:)%j = (-(c(50)*M(1,:)%j)) * den(18)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(327),h0tab(:,327),[32,1,2,12,16],[nMW,0,nMW,nMW,nMW],5,1,wf4(:,10))
  call Hloop_UV_W(ntryL,G0H64(1),0,ex6(:),32,G1H32(179),m3h2x32(:,325),heltab2x64(:,:,325))
  Gcoeff(:)%j = (c(26)*M(1,:)%j) * den(20)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(328),h0tab(:,328),[32,1,2,12,16],[nMW,0,nMW,nMW,nMW],5,1,wf4(:,11))
  call Hloop_UV_W(ntryL,G0H64(1),0,ex6(:),32,G1H32(180),m3h2x32(:,326),heltab2x64(:,:,326))
  Gcoeff(:)%j = (c(16)*M(1,:)%j) * den(124)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(329),h0tab(:,329),[32,12,1,2,16],[nMW,nMW,0,nMW,nMW],5,1,wf4(:,43))
  call Hloop_TV_S(ntryL,G0H64(1),0,ex6(:),32,G1H32(181),m3h2x32(:,327),heltab2x64(:,:,327))
  Gcoeff(:)%j = (c(16)*M(1,:)%j) * den(20)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(330),h0tab(:,330),[32,12,1,2,16],[nMW,nMW,0,nMW,nMW],5,1,wf4(:,12))
  call Hloop_TV_S(ntryL,G0H64(1),0,ex6(:),32,G1H32(182),m3h2x32(:,328),heltab2x64(:,:,328))
  Gcoeff(:)%j = (c(20)*M(1,:)%j) * den(124)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(331),h0tab(:,331),[32,12,1,2,16],[nMW,nMW,0,nMW,nMW],5,1,wf4(:,43))
  call Hloop_SV_V(ntryL,G0H64(1),ex6(:),G0H32(97),m3h2x32(:,329),heltab2x64(:,:,329))
  Gcoeff(:)%j = (c(16)*M(1,:)%j) * den(124)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(332),h0tab(:,332),[32,12,1,2,16],[nMW,nMW,0,nMW,nMW],5,1,wf4(:,43))
  call Hloop_VV_S(ntryL,G0H64(1),ex6(:),G0H32(98),m3h2x32(:,330),heltab2x64(:,:,330))
  Gcoeff(:)%j = (c(16)*M(1,:)%j) * den(20)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(333),h0tab(:,333),[32,12,1,2,16],[nMW,nMW,0,nMW,nMW],5,1,wf4(:,12))
  call Hloop_VV_S(ntryL,G0H64(1),ex6(:),G0H32(99),m3h2x32(:,331),heltab2x64(:,:,331))
  Gcoeff(:)%j = (-(c(17)*M(1,:)%j)) * den(124)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(334),h0tab(:,334),[32,12,1,2,16],[nMW,nMW,0,nMW,nMW],5,1,wf4(:,43))
  call Hloop_UV_W(ntryL,G0H64(1),0,ex6(:),32,G1H32(183),m3h2x32(:,332),heltab2x64(:,:,332))
  Gcoeff(:)%j = (c(50)*M(1,:)%j) * den(18)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(335),h0tab(:,335),[32,12,1,2,16],[0,0,nMW,0,0],5,1,wf4(:,10))
  call Hloop_AV_Q(ntryL,G0H64(1),ex6(:),G0H32(100),m3h2x32(:,333),heltab2x64(:,:,333))
  call Hloop_A_Q(ntryL,G0H32(100),32,0,G1H32(184),n2h32(103))
  Gcoeff(:)%j = (c(53)*M(1,:)%j) * den(20)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(336),h0tab(:,336),[32,12,1,2,16],[0,0,nMW,0,0],5,1,wf4(:,11))
  call Hloop_AV_Q(ntryL,G0H64(1),ex6(:),G0H32(100),m3h2x32(:,334),heltab2x64(:,:,334))
  call Hloop_A_Q(ntryL,G0H32(100),32,0,G1H32(185),n2h32(104))
  Gcoeff(:)%j = (c(75)*M(1,:)%j) * den(18)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(337),h0tab(:,337),[32,12,1,2,16],[nMW,nMW,0,nMW,nMW],5,1,wf4(:,10))
  call Hloop_TV_S(ntryL,G0H64(1),0,ex6(:),32,G1H32(186),m3h2x32(:,335),heltab2x64(:,:,335))
  Gcoeff(:)%j = (c(103)*M(1,:)%j) * den(20)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(338),h0tab(:,338),[32,12,1,2,16],[nMW,nMW,0,nMW,nMW],5,1,wf4(:,11))
  call Hloop_TV_S(ntryL,G0H64(1),0,ex6(:),32,G1H32(187),m3h2x32(:,336),heltab2x64(:,:,336))
  Gcoeff(:)%j = (c(75)*M(1,:)%j) * den(18)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(339),h0tab(:,339),[32,12,1,2,16],[nMW,nMW,0,nMW,nMW],5,1,wf4(:,10))
  call Hloop_SV_V(ntryL,G0H64(1),ex6(:),G0H32(100),m3h2x32(:,337),heltab2x64(:,:,337))
  Gcoeff(:)%j = (-(c(43)*M(1,:)%j)) * den(20)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(340),h0tab(:,340),[32,12,1,2,16],[nMW,nMW,0,nMW,nMW],5,1,wf4(:,11))
  call Hloop_SV_V(ntryL,G0H64(1),ex6(:),G0H32(101),m3h2x32(:,338),heltab2x64(:,:,338))
  Gcoeff(:)%j = (c(75)*M(1,:)%j) * den(18)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(341),h0tab(:,341),[32,12,1,2,16],[nMW,nMW,0,nMW,nMW],5,1,wf4(:,10))
  call Hloop_VV_S(ntryL,G0H64(1),ex6(:),G0H32(102),m3h2x32(:,339),heltab2x64(:,:,339))
  Gcoeff(:)%j = (c(103)*M(1,:)%j) * den(20)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(342),h0tab(:,342),[32,12,1,2,16],[nMW,nMW,0,nMW,nMW],5,1,wf4(:,11))
  call Hloop_VV_S(ntryL,G0H64(1),ex6(:),G0H32(103),m3h2x32(:,340),heltab2x64(:,:,340))
  Gcoeff(:)%j = (-(c(50)*M(1,:)%j)) * den(18)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(343),h0tab(:,343),[32,12,1,2,16],[nMW,nMW,0,nMW,nMW],5,1,wf4(:,10))
  call Hloop_UV_W(ntryL,G0H64(1),0,ex6(:),32,G1H32(188),m3h2x32(:,341),heltab2x64(:,:,341))
  Gcoeff(:)%j = (c(26)*M(1,:)%j) * den(20)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(344),h0tab(:,344),[32,12,1,2,16],[nMW,nMW,0,nMW,nMW],5,1,wf4(:,11))
  call Hloop_UV_W(ntryL,G0H64(1),0,ex6(:),32,G1H32(189),m3h2x32(:,342),heltab2x64(:,:,342))
  Gcoeff(:)%j = (c(16)*M(1,:)%j) * den(124)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(345),h0tab(:,345),[32,2,1,12,16],[nMW,0,nMW,nMW,nMW],5,1,wf4(:,43))
  call Hloop_SV_V(ntryL,G0H64(1),ex6(:),G0H32(104),m3h2x32(:,343),heltab2x64(:,:,343))
  Gcoeff(:)%j = (c(16)*M(1,:)%j) * den(20)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(346),h0tab(:,346),[32,2,1,12,16],[nMW,0,nMW,nMW,nMW],5,1,wf4(:,12))
  call Hloop_SV_V(ntryL,G0H64(1),ex6(:),G0H32(105),m3h2x32(:,344),heltab2x64(:,:,344))
  Gcoeff(:)%j = (c(20)*M(1,:)%j) * den(124)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(347),h0tab(:,347),[32,2,1,12,16],[nMW,0,nMW,nMW,nMW],5,1,wf4(:,43))
  call Hloop_SV_V(ntryL,G0H64(1),ex6(:),G0H32(106),m3h2x32(:,345),heltab2x64(:,:,345))
  Gcoeff(:)%j = (c(16)*M(1,:)%j) * den(124)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(348),h0tab(:,348),[32,2,1,12,16],[nMW,0,nMW,nMW,nMW],5,1,wf4(:,43))
  call Hloop_UW_V(ntryL,G0H64(1),0,ex6(:),32,G1H32(190),m3h2x32(:,346),heltab2x64(:,:,346))
  Gcoeff(:)%j = (c(16)*M(1,:)%j) * den(20)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(349),h0tab(:,349),[32,2,1,12,16],[nMW,0,nMW,nMW,nMW],5,1,wf4(:,12))
  call Hloop_UW_V(ntryL,G0H64(1),0,ex6(:),32,G1H32(191),m3h2x32(:,347),heltab2x64(:,:,347))
  Gcoeff(:)%j = (-(c(17)*M(1,:)%j)) * den(124)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(350),h0tab(:,350),[32,2,1,12,16],[nMW,0,nMW,nMW,nMW],5,1,wf4(:,43))
  call Hloop_UW_V(ntryL,G0H64(1),0,ex6(:),32,G1H32(192),m3h2x32(:,348),heltab2x64(:,:,348))
  Gcoeff(:)%j = (c(50)*M(1,:)%j) * den(18)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(351),h0tab(:,351),[32,2,1,12,16],[0,nMW,0,0,0],5,1,wf4(:,10))
  call Hloop_QV_A(ntryL,G0H64(1),ex6(:),G0H32(107),m3h2x32(:,349),heltab2x64(:,:,349))
  call Hloop_Q_A(ntryL,G0H32(107),32,0,G1H32(193),n2h32(105))
  Gcoeff(:)%j = (c(53)*M(1,:)%j) * den(20)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(352),h0tab(:,352),[32,2,1,12,16],[0,nMW,0,0,0],5,1,wf4(:,11))
  call Hloop_QV_A(ntryL,G0H64(1),ex6(:),G0H32(107),m3h2x32(:,350),heltab2x64(:,:,350))
  call Hloop_Q_A(ntryL,G0H32(107),32,0,G1H32(194),n2h32(106))
  Gcoeff(:)%j = (c(75)*M(1,:)%j) * den(18)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(353),h0tab(:,353),[32,2,1,12,16],[nMW,0,nMW,nMW,nMW],5,1,wf4(:,10))
  call Hloop_SV_V(ntryL,G0H64(1),ex6(:),G0H32(107),m3h2x32(:,351),heltab2x64(:,:,351))
  Gcoeff(:)%j = (c(103)*M(1,:)%j) * den(20)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(354),h0tab(:,354),[32,2,1,12,16],[nMW,0,nMW,nMW,nMW],5,1,wf4(:,11))
  call Hloop_SV_V(ntryL,G0H64(1),ex6(:),G0H32(108),m3h2x32(:,352),heltab2x64(:,:,352))
  Gcoeff(:)%j = (c(75)*M(1,:)%j) * den(18)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(355),h0tab(:,355),[32,2,1,12,16],[nMW,0,nMW,nMW,nMW],5,1,wf4(:,10))
  call Hloop_SV_V(ntryL,G0H64(1),ex6(:),G0H32(109),m3h2x32(:,353),heltab2x64(:,:,353))
  Gcoeff(:)%j = (-(c(43)*M(1,:)%j)) * den(20)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(356),h0tab(:,356),[32,2,1,12,16],[nMW,0,nMW,nMW,nMW],5,1,wf4(:,11))
  call Hloop_SV_V(ntryL,G0H64(1),ex6(:),G0H32(110),m3h2x32(:,354),heltab2x64(:,:,354))
  Gcoeff(:)%j = (c(75)*M(1,:)%j) * den(18)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(357),h0tab(:,357),[32,2,1,12,16],[nMW,0,nMW,nMW,nMW],5,1,wf4(:,10))
  call Hloop_UW_V(ntryL,G0H64(1),0,ex6(:),32,G1H32(195),m3h2x32(:,355),heltab2x64(:,:,355))
  Gcoeff(:)%j = (c(103)*M(1,:)%j) * den(20)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(358),h0tab(:,358),[32,2,1,12,16],[nMW,0,nMW,nMW,nMW],5,1,wf4(:,11))
  call Hloop_UW_V(ntryL,G0H64(1),0,ex6(:),32,G1H32(196),m3h2x32(:,356),heltab2x64(:,:,356))
  Gcoeff(:)%j = (-(c(50)*M(1,:)%j)) * den(18)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(359),h0tab(:,359),[32,2,1,12,16],[nMW,0,nMW,nMW,nMW],5,1,wf4(:,10))
  call Hloop_UW_V(ntryL,G0H64(1),0,ex6(:),32,G1H32(197),m3h2x32(:,357),heltab2x64(:,:,357))
  Gcoeff(:)%j = (c(26)*M(1,:)%j) * den(20)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(360),h0tab(:,360),[32,2,1,12,16],[nMW,0,nMW,nMW,nMW],5,1,wf4(:,11))
  call Hloop_UW_V(ntryL,G0H64(1),0,ex6(:),32,G1H32(198),m3h2x32(:,358),heltab2x64(:,:,358))
  Gcoeff(:)%j = (c(16)*M(1,:)%j) * den(124)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(361),h0tab(:,361),[32,1,16,2,12],[nMW,0,0,nMW,nMW],5,1,wf4(:,43))
  call Hloop_SV_V(ntryL,G0H64(1),ex6(:),G0H32(111),m3h2x32(:,359),heltab2x64(:,:,359))
  Gcoeff(:)%j = (-(c(16)*M(1,:)%j)) * den(20)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(362),h0tab(:,362),[32,1,16,2,12],[nMW,0,0,nMW,nMW],5,1,wf4(:,12))
  call Hloop_SV_V(ntryL,G0H64(1),ex6(:),G0H32(112),m3h2x32(:,360),heltab2x64(:,:,360))
  Gcoeff(:)%j = (c(17)*M(1,:)%j) * den(124)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(363),h0tab(:,363),[32,1,16,2,12],[nMW,0,0,nMW,nMW],5,1,wf4(:,43))
  call Hloop_UV_W(ntryL,G0H64(1),0,ex6(:),32,G1H32(199),m3h2x32(:,361),heltab2x64(:,:,361))
  Gcoeff(:)%j = (-(c(50)*M(1,:)%j)) * den(18)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(364),h0tab(:,364),[32,1,16,2,12],[0,nMW,nMW,0,0],5,1,wf4(:,10))
  call Hloop_AV_Q(ntryL,G0H64(1),ex6(:),G0H32(113),m3h2x32(:,362),heltab2x64(:,:,362))
  call Hloop_A_Q(ntryL,G0H32(113),32,0,G1H32(200),n2h32(107))
  Gcoeff(:)%j = (-(c(53)*M(1,:)%j)) * den(20)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(365),h0tab(:,365),[32,1,16,2,12],[0,nMW,nMW,0,0],5,1,wf4(:,11))
  call Hloop_AV_Q(ntryL,G0H64(1),ex6(:),G0H32(113),m3h2x32(:,363),heltab2x64(:,:,363))
  call Hloop_A_Q(ntryL,G0H32(113),32,0,G1H32(201),n2h32(108))
  Gcoeff(:)%j = (-(c(75)*M(1,:)%j)) * den(18)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(366),h0tab(:,366),[32,1,16,2,12],[nMW,0,0,nMW,nMW],5,1,wf4(:,10))
  call Hloop_SV_V(ntryL,G0H64(1),ex6(:),G0H32(113),m3h2x32(:,364),heltab2x64(:,:,364))
  Gcoeff(:)%j = (-(c(103)*M(1,:)%j)) * den(20)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(367),h0tab(:,367),[32,1,16,2,12],[nMW,0,0,nMW,nMW],5,1,wf4(:,11))
  call Hloop_SV_V(ntryL,G0H64(1),ex6(:),G0H32(114),m3h2x32(:,365),heltab2x64(:,:,365))
  Gcoeff(:)%j = (c(50)*M(1,:)%j) * den(18)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(368),h0tab(:,368),[32,1,16,2,12],[nMW,0,0,nMW,nMW],5,1,wf4(:,10))
  call Hloop_UV_W(ntryL,G0H64(1),0,ex6(:),32,G1H32(202),m3h2x32(:,366),heltab2x64(:,:,366))
  Gcoeff(:)%j = (-(c(26)*M(1,:)%j)) * den(20)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(369),h0tab(:,369),[32,1,16,2,12],[nMW,0,0,nMW,nMW],5,1,wf4(:,11))
  call Hloop_UV_W(ntryL,G0H64(1),0,ex6(:),32,G1H32(203),m3h2x32(:,367),heltab2x64(:,:,367))
  Gcoeff(:)%j = (c(16)*M(1,:)%j) * den(124)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(370),h0tab(:,370),[32,1,16,12,2],[0,nMW,nMW,nMW,0],5,1,wf4(:,43))
  call Hloop_AV_Q(ntryL,G0H64(1),ex6(:),G0H32(115),m3h2x32(:,368),heltab2x64(:,:,368))
  call Hloop_A_Q(ntryL,G0H32(115),32,0,G1H32(204),n2h32(109))
  Gcoeff(:)%j = (-(c(16)*M(1,:)%j)) * den(20)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(371),h0tab(:,371),[32,1,16,12,2],[0,nMW,nMW,nMW,0],5,1,wf4(:,12))
  call Hloop_AV_Q(ntryL,G0H64(1),ex6(:),G0H32(115),m3h2x32(:,369),heltab2x64(:,:,369))
  call Hloop_A_Q(ntryL,G0H32(115),32,0,G1H32(205),n2h32(110))
  Gcoeff(:)%j = (c(17)*M(1,:)%j) * den(124)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(372),h0tab(:,372),[32,1,16,12,2],[0,nMW,nMW,nMW,0],5,1,wf4(:,43))
  call Hloop_AV_Q(ntryL,G0H64(1),ex6(:),G0H32(115),m3h2x32(:,370),heltab2x64(:,:,370))
  call Hloop_A_Q(ntryL,G0H32(115),32,0,G1H32(206),n2h32(111))
  Gcoeff(:)%j = (-(c(50)*M(1,:)%j)) * den(18)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(373),h0tab(:,373),[32,1,16,12,2],[nMW,0,0,0,nMW],5,1,wf4(:,10))
  call Hloop_UV_W(ntryL,G0H64(1),0,ex6(:),32,G1H32(207),m3h2x32(:,371),heltab2x64(:,:,371))
  Gcoeff(:)%j = (-(c(53)*M(1,:)%j)) * den(20)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(374),h0tab(:,374),[32,1,16,12,2],[nMW,0,0,0,nMW],5,1,wf4(:,11))
  call Hloop_UV_W(ntryL,G0H64(1),0,ex6(:),32,G1H32(208),m3h2x32(:,372),heltab2x64(:,:,372))
  Gcoeff(:)%j = (-(c(75)*M(1,:)%j)) * den(18)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(375),h0tab(:,375),[32,1,16,12,2],[0,nMW,nMW,nMW,0],5,1,wf4(:,10))
  call Hloop_AV_Q(ntryL,G0H64(1),ex6(:),G0H32(115),m3h2x32(:,373),heltab2x64(:,:,373))
  call Hloop_A_Q(ntryL,G0H32(115),32,0,G1H32(209),n2h32(112))
  Gcoeff(:)%j = (-(c(103)*M(1,:)%j)) * den(20)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(376),h0tab(:,376),[32,1,16,12,2],[0,nMW,nMW,nMW,0],5,1,wf4(:,11))
  call Hloop_AV_Q(ntryL,G0H64(1),ex6(:),G0H32(115),m3h2x32(:,374),heltab2x64(:,:,374))
  call Hloop_A_Q(ntryL,G0H32(115),32,0,G1H32(210),n2h32(113))
  Gcoeff(:)%j = (c(50)*M(1,:)%j) * den(18)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(377),h0tab(:,377),[32,1,16,12,2],[0,nMW,nMW,nMW,0],5,1,wf4(:,10))
  call Hloop_AV_Q(ntryL,G0H64(1),ex6(:),G0H32(115),m3h2x32(:,375),heltab2x64(:,:,375))
  call Hloop_A_Q(ntryL,G0H32(115),32,0,G1H32(211),n2h32(114))
  Gcoeff(:)%j = (-(c(26)*M(1,:)%j)) * den(20)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(378),h0tab(:,378),[32,1,16,12,2],[0,nMW,nMW,nMW,0],5,1,wf4(:,11))
  call Hloop_AV_Q(ntryL,G0H64(1),ex6(:),G0H32(115),m3h2x32(:,376),heltab2x64(:,:,376))
  call Hloop_A_Q(ntryL,G0H32(115),32,0,G1H32(212),n2h32(115))
  Gcoeff(:)%j = (-(c(16)*M(1,:)%j)) * den(124)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(379),h0tab(:,379),[32,2,16,1,12],[nMW,0,0,nMW,nMW],5,1,wf4(:,43))
  call Hloop_SV_V(ntryL,G0H64(1),ex6(:),G0H32(115),m3h2x32(:,377),heltab2x64(:,:,377))
  Gcoeff(:)%j = (-(c(16)*M(1,:)%j)) * den(20)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(380),h0tab(:,380),[32,2,16,1,12],[nMW,0,0,nMW,nMW],5,1,wf4(:,12))
  call Hloop_SV_V(ntryL,G0H64(1),ex6(:),G0H32(116),m3h2x32(:,378),heltab2x64(:,:,378))
  Gcoeff(:)%j = (c(17)*M(1,:)%j) * den(124)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(381),h0tab(:,381),[32,2,16,1,12],[nMW,0,0,nMW,nMW],5,1,wf4(:,43))
  call Hloop_UW_V(ntryL,G0H64(1),0,ex6(:),32,G1H32(213),m3h2x32(:,379),heltab2x64(:,:,379))
  Gcoeff(:)%j = (-(c(50)*M(1,:)%j)) * den(18)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(382),h0tab(:,382),[32,2,16,1,12],[0,nMW,nMW,0,0],5,1,wf4(:,10))
  call Hloop_QV_A(ntryL,G0H64(1),ex6(:),G0H32(117),m3h2x32(:,380),heltab2x64(:,:,380))
  call Hloop_Q_A(ntryL,G0H32(117),32,0,G1H32(214),n2h32(116))
  Gcoeff(:)%j = (-(c(53)*M(1,:)%j)) * den(20)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(383),h0tab(:,383),[32,2,16,1,12],[0,nMW,nMW,0,0],5,1,wf4(:,11))
  call Hloop_QV_A(ntryL,G0H64(1),ex6(:),G0H32(117),m3h2x32(:,381),heltab2x64(:,:,381))
  call Hloop_Q_A(ntryL,G0H32(117),32,0,G1H32(215),n2h32(117))
  Gcoeff(:)%j = (-(c(75)*M(1,:)%j)) * den(18)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(384),h0tab(:,384),[32,2,16,1,12],[nMW,0,0,nMW,nMW],5,1,wf4(:,10))
  call Hloop_SV_V(ntryL,G0H64(1),ex6(:),G0H32(117),m3h2x32(:,382),heltab2x64(:,:,382))
  Gcoeff(:)%j = (-(c(103)*M(1,:)%j)) * den(20)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(385),h0tab(:,385),[32,2,16,1,12],[nMW,0,0,nMW,nMW],5,1,wf4(:,11))
  call Hloop_SV_V(ntryL,G0H64(1),ex6(:),G0H32(118),m3h2x32(:,383),heltab2x64(:,:,383))
  Gcoeff(:)%j = (c(50)*M(1,:)%j) * den(18)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(386),h0tab(:,386),[32,2,16,1,12],[nMW,0,0,nMW,nMW],5,1,wf4(:,10))
  call Hloop_UW_V(ntryL,G0H64(1),0,ex6(:),32,G1H32(216),m3h2x32(:,384),heltab2x64(:,:,384))
  Gcoeff(:)%j = (-(c(26)*M(1,:)%j)) * den(20)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(387),h0tab(:,387),[32,2,16,1,12],[nMW,0,0,nMW,nMW],5,1,wf4(:,11))
  call Hloop_UW_V(ntryL,G0H64(1),0,ex6(:),32,G1H32(217),m3h2x32(:,385),heltab2x64(:,:,385))
  Gcoeff(:)%j = (-(c(17)*M(1,:)%j)) * den(124)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(388),h0tab(:,388),[32,2,12,1,16],[0,nMW,nMW,0,0],5,1,wf4(:,43))
  call Hloop_QV_A(ntryL,G0H64(1),ex6(:),G0H32(119),m3h2x32(:,386),heltab2x64(:,:,386))
  call Hloop_Q_A(ntryL,G0H32(119),32,0,G1H32(218),n2h32(118))
  Gcoeff(:)%j = (-(c(50)*M(1,:)%j)) * den(18)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(389),h0tab(:,389),[32,2,12,1,16],[0,nMW,nMW,0,0],5,1,wf4(:,10))
  call Hloop_QV_A(ntryL,G0H64(1),ex6(:),G0H32(119),m3h2x32(:,387),heltab2x64(:,:,387))
  call Hloop_Q_A(ntryL,G0H32(119),32,0,G1H32(219),n2h32(119))
  Gcoeff(:)%j = (c(26)*M(1,:)%j) * den(20)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(390),h0tab(:,390),[32,2,12,1,16],[0,nMW,nMW,0,0],5,1,wf4(:,11))
  call Hloop_QV_A(ntryL,G0H64(1),ex6(:),G0H32(119),m3h2x32(:,388),heltab2x64(:,:,388))
  call Hloop_Q_A(ntryL,G0H32(119),32,0,G1H32(220),n2h32(120))
  Gcoeff(:)%j = (-(c(75)*M(1,:)%j)) * den(18)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(391),h0tab(:,391),[32,2,12,1,16],[nMW,0,0,nMW,nMW],5,1,wf4(:,10))
  call Hloop_SV_V(ntryL,G0H64(1),ex6(:),G0H32(119),m3h2x32(:,389),heltab2x64(:,:,389))
  Gcoeff(:)%j = (-(c(76)*M(1,:)%j)) * den(20)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(392),h0tab(:,392),[32,2,12,1,16],[nMW,0,0,nMW,nMW],5,1,wf4(:,11))
  call Hloop_SV_V(ntryL,G0H64(1),ex6(:),G0H32(120),m3h2x32(:,390),heltab2x64(:,:,390))
  Gcoeff(:)%j = (c(50)*M(1,:)%j) * den(18)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(393),h0tab(:,393),[32,2,12,1,16],[nMW,0,0,nMW,nMW],5,1,wf4(:,10))
  call Hloop_UW_V(ntryL,G0H64(1),0,ex6(:),32,G1H32(221),m3h2x32(:,391),heltab2x64(:,:,391))
  Gcoeff(:)%j = (c(53)*M(1,:)%j) * den(20)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(394),h0tab(:,394),[32,2,12,1,16],[nMW,0,0,nMW,nMW],5,1,wf4(:,11))
  call Hloop_UW_V(ntryL,G0H64(1),0,ex6(:),32,G1H32(222),m3h2x32(:,392),heltab2x64(:,:,392))
  Gcoeff(:)%j = (-(c(16)*M(1,:)%j)) * den(124)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(395),h0tab(:,395),[32,1,12,16,2],[0,nMW,nMW,nMW,0],5,1,wf4(:,43))
  call Hloop_AV_Q(ntryL,G0H64(1),ex6(:),G0H32(121),m3h2x32(:,393),heltab2x64(:,:,393))
  call Hloop_A_Q(ntryL,G0H32(121),32,0,G1H32(223),n2h32(121))
  Gcoeff(:)%j = (-(c(16)*M(1,:)%j)) * den(20)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(396),h0tab(:,396),[32,1,12,16,2],[0,nMW,nMW,nMW,0],5,1,wf4(:,12))
  call Hloop_AV_Q(ntryL,G0H64(1),ex6(:),G0H32(121),m3h2x32(:,394),heltab2x64(:,:,394))
  call Hloop_A_Q(ntryL,G0H32(121),32,0,G1H32(224),n2h32(122))
  Gcoeff(:)%j = (c(17)*M(1,:)%j) * den(124)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(397),h0tab(:,397),[32,1,12,16,2],[0,nMW,nMW,nMW,0],5,1,wf4(:,43))
  call Hloop_AV_Q(ntryL,G0H64(1),ex6(:),G0H32(121),m3h2x32(:,395),heltab2x64(:,:,395))
  call Hloop_A_Q(ntryL,G0H32(121),32,0,G1H32(225),n2h32(123))
  Gcoeff(:)%j = (-(c(50)*M(1,:)%j)) * den(18)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(398),h0tab(:,398),[32,1,12,16,2],[nMW,0,0,0,nMW],5,1,wf4(:,10))
  call Hloop_UV_W(ntryL,G0H64(1),0,ex6(:),32,G1H32(226),m3h2x32(:,396),heltab2x64(:,:,396))
  Gcoeff(:)%j = (-(c(53)*M(1,:)%j)) * den(20)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(399),h0tab(:,399),[32,1,12,16,2],[nMW,0,0,0,nMW],5,1,wf4(:,11))
  call Hloop_UV_W(ntryL,G0H64(1),0,ex6(:),32,G1H32(227),m3h2x32(:,397),heltab2x64(:,:,397))
  Gcoeff(:)%j = (-(c(75)*M(1,:)%j)) * den(18)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(400),h0tab(:,400),[32,1,12,16,2],[0,nMW,nMW,nMW,0],5,1,wf4(:,10))
  call Hloop_AV_Q(ntryL,G0H64(1),ex6(:),G0H32(121),m3h2x32(:,398),heltab2x64(:,:,398))
  call Hloop_A_Q(ntryL,G0H32(121),32,0,G1H32(228),n2h32(124))
  Gcoeff(:)%j = (-(c(103)*M(1,:)%j)) * den(20)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(401),h0tab(:,401),[32,1,12,16,2],[0,nMW,nMW,nMW,0],5,1,wf4(:,11))
  call Hloop_AV_Q(ntryL,G0H64(1),ex6(:),G0H32(121),m3h2x32(:,399),heltab2x64(:,:,399))
  call Hloop_A_Q(ntryL,G0H32(121),32,0,G1H32(229),n2h32(125))
  Gcoeff(:)%j = (c(50)*M(1,:)%j) * den(18)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(402),h0tab(:,402),[32,1,12,16,2],[0,nMW,nMW,nMW,0],5,1,wf4(:,10))
  call Hloop_AV_Q(ntryL,G0H64(1),ex6(:),G0H32(121),m3h2x32(:,400),heltab2x64(:,:,400))
  call Hloop_A_Q(ntryL,G0H32(121),32,0,G1H32(230),n2h32(126))
  Gcoeff(:)%j = (-(c(26)*M(1,:)%j)) * den(20)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(403),h0tab(:,403),[32,1,12,16,2],[0,nMW,nMW,nMW,0],5,1,wf4(:,11))
  call Hloop_AV_Q(ntryL,G0H64(1),ex6(:),G0H32(121),m3h2x32(:,401),heltab2x64(:,:,401))
  call Hloop_A_Q(ntryL,G0H32(121),32,0,G1H32(231),n2h32(127))
  Gcoeff(:)%j = (-(c(17)*M(1,:)%j)) * den(124)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(404),h0tab(:,404),[32,1,12,2,16],[0,nMW,nMW,0,0],5,1,wf4(:,43))
  call Hloop_AV_Q(ntryL,G0H64(1),ex6(:),G0H32(121),m3h2x32(:,402),heltab2x64(:,:,402))
  call Hloop_A_Q(ntryL,G0H32(121),32,0,G1H32(232),n2h32(128))
  Gcoeff(:)%j = (-(c(50)*M(1,:)%j)) * den(18)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(405),h0tab(:,405),[32,1,12,2,16],[0,nMW,nMW,0,0],5,1,wf4(:,10))
  call Hloop_AV_Q(ntryL,G0H64(1),ex6(:),G0H32(121),m3h2x32(:,403),heltab2x64(:,:,403))
  call Hloop_A_Q(ntryL,G0H32(121),32,0,G1H32(233),n2h32(129))
  Gcoeff(:)%j = (c(26)*M(1,:)%j) * den(20)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(406),h0tab(:,406),[32,1,12,2,16],[0,nMW,nMW,0,0],5,1,wf4(:,11))
  call Hloop_AV_Q(ntryL,G0H64(1),ex6(:),G0H32(121),m3h2x32(:,404),heltab2x64(:,:,404))
  call Hloop_A_Q(ntryL,G0H32(121),32,0,G1H32(234),n2h32(130))
  Gcoeff(:)%j = (-(c(75)*M(1,:)%j)) * den(18)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(407),h0tab(:,407),[32,1,12,2,16],[nMW,0,0,nMW,nMW],5,1,wf4(:,10))
  call Hloop_SV_V(ntryL,G0H64(1),ex6(:),G0H32(121),m3h2x32(:,405),heltab2x64(:,:,405))
  Gcoeff(:)%j = (-(c(76)*M(1,:)%j)) * den(20)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(408),h0tab(:,408),[32,1,12,2,16],[nMW,0,0,nMW,nMW],5,1,wf4(:,11))
  call Hloop_SV_V(ntryL,G0H64(1),ex6(:),G0H32(122),m3h2x32(:,406),heltab2x64(:,:,406))
  Gcoeff(:)%j = (c(50)*M(1,:)%j) * den(18)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(409),h0tab(:,409),[32,1,12,2,16],[nMW,0,0,nMW,nMW],5,1,wf4(:,10))
  call Hloop_UV_W(ntryL,G0H64(1),0,ex6(:),32,G1H32(235),m3h2x32(:,407),heltab2x64(:,:,407))
  Gcoeff(:)%j = (c(53)*M(1,:)%j) * den(20)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(410),h0tab(:,410),[32,1,12,2,16],[nMW,0,0,nMW,nMW],5,1,wf4(:,11))
  call Hloop_UV_W(ntryL,G0H64(1),0,ex6(:),32,G1H32(236),m3h2x32(:,408),heltab2x64(:,:,408))
  Gcoeff(:)%j = (c(2)*M(1,:)%j) * den(2)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(411),h0tab(:,411),[32,8,1,2,20],[nMB,nMZ,0,nMZ,nMB],5,1,wf4(:,4))
  call Hloop_QV_A(ntryL,G0H64(1),ex6(:),G0H32(123),m3h2x32(:,409),heltab2x64(:,:,409))
  call Hloop_Q_A(ntryL,G0H32(123),32,nMB,G1H32(237),n2h32(131))
  Gcoeff(:)%j = (-(c(9)*M(1,:)%j)) * den(2)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(412),h0tab(:,412),[32,1,2,8,20],[nMW,0,nMW,nMT,nMW],5,1,wf4(:,4))
  call Hloop_SV_V(ntryL,G0H64(1),ex6(:),G0H32(123),m3h2x32(:,410),heltab2x64(:,:,410))
  Gcoeff(:)%j = (-(c(9)*M(1,:)%j)) * den(2)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(413),h0tab(:,413),[32,1,2,8,20],[nMW,0,nMW,nMT,nMW],5,1,wf4(:,4))
  call Hloop_UV_W(ntryL,G0H64(1),0,ex6(:),32,G1H32(238),m3h2x32(:,411),heltab2x64(:,:,411))
  Gcoeff(:)%j = (c(2)*M(1,:)%j) * den(2)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(414),h0tab(:,414),[32,8,2,1,20],[nMB,nMZ,0,nMZ,nMB],5,1,wf4(:,4))
  call Hloop_QV_A(ntryL,G0H64(1),ex6(:),G0H32(124),m3h2x32(:,412),heltab2x64(:,:,412))
  call Hloop_Q_A(ntryL,G0H32(124),32,nMB,G1H32(239),n2h32(132))
  Gcoeff(:)%j = (-(c(8)*M(1,:)%j)) * den(2)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(415),h0tab(:,415),[32,8,2,1,20],[nMT,nMW,0,nMW,nMT],5,1,wf4(:,4))
  call Hloop_QV_A(ntryL,G0H64(1),ex6(:),G0H32(124),m3h2x32(:,413),heltab2x64(:,:,413))
  call Hloop_Q_A(ntryL,G0H32(124),32,nMT,G1H32(240),n2h32(133))
  Gcoeff(:)%j = (c(9)*M(1,:)%j) * den(2)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(416),h0tab(:,416),[32,2,1,20,8],[nMW,0,nMW,nMT,nMW],5,1,wf4(:,4))
  call Hloop_SV_V(ntryL,G0H64(1),ex6(:),G0H32(124),m3h2x32(:,414),heltab2x64(:,:,414))
  Gcoeff(:)%j = (-(c(9)*M(1,:)%j)) * den(2)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(417),h0tab(:,417),[32,2,1,20,8],[nMW,0,nMW,nMT,nMW],5,1,wf4(:,4))
  call Hloop_UW_V(ntryL,G0H64(1),0,ex6(:),32,G1H32(241),m3h2x32(:,415),heltab2x64(:,:,415))
  Gcoeff(:)%j = (c(9)*M(1,:)%j) * den(2)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(418),h0tab(:,418),[32,1,20,8,2],[0,nMW,nMT,nMW,0],5,1,wf4(:,4))
  call Hloop_AV_Q(ntryL,G0H64(1),ex6(:),G0H32(125),m3h2x32(:,416),heltab2x64(:,:,416))
  call Hloop_A_Q(ntryL,G0H32(125),32,0,G1H32(242),n2h32(134))
  Gcoeff(:)%j = (c(9)*M(1,:)%j) * den(10)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(419),h0tab(:,419),[32,2,1,4,24],[nMW,0,nMW,nMT,nMW],5,1,wf4(:,9))
  call Hloop_SV_V(ntryL,G0H64(1),ex6(:),G0H32(125),m3h2x32(:,417),heltab2x64(:,:,417))
  Gcoeff(:)%j = (-(c(9)*M(1,:)%j)) * den(10)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(420),h0tab(:,420),[32,2,1,4,24],[nMW,0,nMW,nMT,nMW],5,1,wf4(:,9))
  call Hloop_UW_V(ntryL,G0H64(1),0,ex6(:),32,G1H32(243),m3h2x32(:,418),heltab2x64(:,:,418))
  Gcoeff(:)%j = (c(2)*M(1,:)%j) * den(10)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(421),h0tab(:,421),[32,4,1,2,24],[nMB,nMZ,0,nMZ,nMB],5,1,wf4(:,9))
  call Hloop_AV_Q(ntryL,G0H64(1),ex6(:),G0H32(126),m3h2x32(:,419),heltab2x64(:,:,419))
  call Hloop_A_Q(ntryL,G0H32(126),32,nMB,G1H32(244),n2h32(135))
  Gcoeff(:)%j = (-(c(8)*M(1,:)%j)) * den(10)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(422),h0tab(:,422),[32,4,1,2,24],[nMT,nMW,0,nMW,nMT],5,1,wf4(:,9))
  call Hloop_AV_Q(ntryL,G0H64(1),ex6(:),G0H32(126),m3h2x32(:,420),heltab2x64(:,:,420))
  call Hloop_A_Q(ntryL,G0H32(126),32,nMT,G1H32(245),n2h32(136))
  Gcoeff(:)%j = (-(c(9)*M(1,:)%j)) * den(10)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(423),h0tab(:,423),[32,1,2,24,4],[nMW,0,nMW,nMT,nMW],5,1,wf4(:,9))
  call Hloop_SV_V(ntryL,G0H64(1),ex6(:),G0H32(126),m3h2x32(:,421),heltab2x64(:,:,421))
  Gcoeff(:)%j = (-(c(9)*M(1,:)%j)) * den(10)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(424),h0tab(:,424),[32,1,2,24,4],[nMW,0,nMW,nMT,nMW],5,1,wf4(:,9))
  call Hloop_UV_W(ntryL,G0H64(1),0,ex6(:),32,G1H32(246),m3h2x32(:,422),heltab2x64(:,:,422))
  Gcoeff(:)%j = (c(2)*M(1,:)%j) * den(10)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(425),h0tab(:,425),[32,4,2,1,24],[nMB,nMZ,0,nMZ,nMB],5,1,wf4(:,9))
  call Hloop_AV_Q(ntryL,G0H64(1),ex6(:),G0H32(127),m3h2x32(:,423),heltab2x64(:,:,423))
  call Hloop_A_Q(ntryL,G0H32(127),32,nMB,G1H32(247),n2h32(137))
  Gcoeff(:)%j = (c(9)*M(1,:)%j) * den(10)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(426),h0tab(:,426),[32,1,4,24,2],[0,nMW,nMT,nMW,0],5,1,wf4(:,9))
  call Hloop_AV_Q(ntryL,G0H64(1),ex6(:),G0H32(127),m3h2x32(:,424),heltab2x64(:,:,424))
  call Hloop_A_Q(ntryL,G0H32(127),32,0,G1H32(248),n2h32(138))
  Gcoeff(:)%j = (c(2)*M(1,:)%j) * den(9)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(427),h0tab(:,427),[36,2,1,8,16],[nMZ,0,nMZ,nMB,nMB],5,1,wf4(:,8))
  call Hloop_AQ_Z(ntryL,G0H64(1),wf4(:,8),G0H16(3),ngZd,m3h4x16(:,1),heltab2x64(:,:,425))
  Gcoeff(:)%j = (-(c(9)*M(1,:)%j)) * den(9)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(428),h0tab(:,428),[36,8,2,1,16],[nMT,nMW,0,nMW,nMW],5,1,wf4(:,8))
  call Hloop_SQ_A(ntryL,G0H64(1),wf4(:,8),G0H16(4),ngPtb,m3h4x16(:,2),heltab2x64(:,:,426))
  call Hloop_Q_A(ntryL,G0H16(4),36,nMT,G1H16(11),n2h16(35))
  Gcoeff(:)%j = (-(c(9)*M(1,:)%j)) * den(9)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(429),h0tab(:,429),[36,8,2,1,16],[nMT,nMW,0,nMW,nMW],5,1,wf4(:,8))
  call Hloop_WQ_A(ntryL,G0H64(1),wf4(:,8),G0H16(4),m3h4x16(:,3),heltab2x64(:,:,427))
  call Hloop_Q_A(ntryL,G0H16(4),36,nMT,G1H16(12),n2h16(36))
  Gcoeff(:)%j = (c(2)*M(1,:)%j) * den(9)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(430),h0tab(:,430),[36,1,2,8,16],[nMZ,0,nMZ,nMB,nMB],5,1,wf4(:,8))
  call Hloop_AQ_Z(ntryL,G0H64(1),wf4(:,8),G0H16(4),ngZd,m3h4x16(:,4),heltab2x64(:,:,428))
  Gcoeff(:)%j = (-(c(8)*M(1,:)%j)) * den(9)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(431),h0tab(:,431),[36,1,2,8,16],[nMW,0,nMW,nMT,nMT],5,1,wf4(:,8))
  call Hloop_AQ_W(ntryL,G0H64(1),wf4(:,8),G0H16(5),m3h4x16(:,5),heltab2x64(:,:,429))
  Gcoeff(:)%j = (c(9)*M(1,:)%j) * den(9)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(432),h0tab(:,432),[36,1,2,16,8],[nMW,0,nMW,nMW,nMT],5,1,wf4(:,8))
  call Hloop_AQ_W(ntryL,G0H64(1),wf4(:,8),G0H16(6),m3h4x16(:,6),heltab2x64(:,:,430))
  Gcoeff(:)%j = (-(c(9)*M(1,:)%j)) * den(9)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(433),h0tab(:,433),[36,1,2,16,8],[nMW,0,nMW,nMW,nMT],5,1,wf4(:,8))
  call Hloop_AQ_W(ntryL,G0H64(1),wf4(:,8),G0H16(7),m3h4x16(:,7),heltab2x64(:,:,431))
  Gcoeff(:)%j = (c(9)*M(1,:)%j) * den(9)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(434),h0tab(:,434),[36,1,16,2,8],[nMW,0,0,nMW,nMT],5,1,wf4(:,8))
  call Hloop_AQ_W(ntryL,G0H64(1),wf4(:,8),G0H16(8),m3h4x16(:,8),heltab2x64(:,:,432))
  Gcoeff(:)%j = (c(9)*M(1,:)%j) * den(3)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(435),h0tab(:,435),[40,4,1,2,16],[nMT,nMW,0,nMW,nMW],5,1,wf4(:,5))
  call Hloop_SA_Q(ntryL,G0H64(1),wf4(:,5),G0H16(9),ngPbt,m3h4x16(:,9),heltab2x64(:,:,433))
  call Hloop_A_Q(ntryL,G0H16(9),40,nMT,G1H16(13),n2h16(37))
  Gcoeff(:)%j = (-(c(9)*M(1,:)%j)) * den(3)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(436),h0tab(:,436),[40,4,1,2,16],[nMT,nMW,0,nMW,nMW],5,1,wf4(:,5))
  call Hloop_WA_Q(ntryL,G0H64(1),wf4(:,5),G0H16(9),m3h4x16(:,10),heltab2x64(:,:,434))
  call Hloop_A_Q(ntryL,G0H16(9),40,nMT,G1H16(16),n2h16(38))
  Gcoeff(:)%j = (c(2)*M(1,:)%j) * den(3)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(437),h0tab(:,437),[40,2,1,4,16],[nMZ,0,nMZ,nMB,nMB],5,1,wf4(:,5))
  call Hloop_QA_Z(ntryL,G0H64(1),wf4(:,5),G0H16(9),ngZd,m3h4x16(:,11),heltab2x64(:,:,435))
  Gcoeff(:)%j = (-(c(8)*M(1,:)%j)) * den(3)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(438),h0tab(:,438),[40,2,1,4,16],[nMW,0,nMW,nMT,nMT],5,1,wf4(:,5))
  call Hloop_QA_W(ntryL,G0H64(1),wf4(:,5),G0H16(10),m3h4x16(:,12),heltab2x64(:,:,436))
  Gcoeff(:)%j = (-(c(9)*M(1,:)%j)) * den(3)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(439),h0tab(:,439),[40,2,1,16,4],[nMW,0,nMW,nMW,nMT],5,1,wf4(:,5))
  call Hloop_QA_W(ntryL,G0H64(1),wf4(:,5),G0H16(11),m3h4x16(:,13),heltab2x64(:,:,437))
  Gcoeff(:)%j = (-(c(9)*M(1,:)%j)) * den(3)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(440),h0tab(:,440),[40,2,1,16,4],[nMW,0,nMW,nMW,nMT],5,1,wf4(:,5))
  call Hloop_QA_W(ntryL,G0H64(1),wf4(:,5),G0H16(12),m3h4x16(:,14),heltab2x64(:,:,438))
  Gcoeff(:)%j = (c(2)*M(1,:)%j) * den(3)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(441),h0tab(:,441),[40,1,2,4,16],[nMZ,0,nMZ,nMB,nMB],5,1,wf4(:,5))
  call Hloop_QA_Z(ntryL,G0H64(1),wf4(:,5),G0H16(13),ngZd,m3h4x16(:,15),heltab2x64(:,:,439))
  Gcoeff(:)%j = (c(9)*M(1,:)%j) * den(3)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(442),h0tab(:,442),[40,2,16,1,4],[nMW,0,0,nMW,nMT],5,1,wf4(:,5))
  call Hloop_QA_W(ntryL,G0H64(1),wf4(:,5),G0H16(14),m3h4x16(:,16),heltab2x64(:,:,440))
  call Hloop_AV_Q(ntryL,G1H16(15),ex5(:),G1H8(15),m3h2x8(:,55),heltab2x16(:,:,55))
  call Hloop_A_Q(ntryL,G1H8(15),50,0,G2H8(5),n2h8(41))
  call Hloop_QV_A(ntryL,G1H16(7),ex5(:),G1H8(4),m3h2x8(:,56),heltab2x16(:,:,56))
  call Hloop_Q_A(ntryL,G1H8(4),49,0,G2H8(6),n2h8(42))
  call Hloop_WA_Q(ntryL,G0H16(1),ex2(:),G0H8(1),m3h2x8(:,57),heltab2x16(:,:,57))
  call Hloop_A_Q(ntryL,G0H8(1),50,0,G1H8(18),n2h8(43))
  call Hloop_WQ_A(ntryL,G0H16(2),ex1(:),G0H8(1),m3h2x8(:,58),heltab2x16(:,:,58))
  call Hloop_Q_A(ntryL,G0H8(1),49,0,G1H8(19),n2h8(44))
  call Hloop_AZ_Q(ntryL,G1H32(1),wf4(:,1),G1H8(20),ngZd,m3h4x8(:,1),heltab2x32(:,:,51))
  call Hloop_A_Q(ntryL,G1H8(20),35,nMB,G2H8(7),n2h8(45))
  call Hloop_AZ_Q(ntryL,G1H32(2),wf4(:,1),G1H8(21),ngZd,m3h4x8(:,2),heltab2x32(:,:,52))
  call Hloop_A_Q(ntryL,G1H8(21),35,nMB,G2H8(8),n2h8(46))
  call Hloop_AZ_Q(ntryL,G1H32(3),wf4(:,1),G1H8(24),ngZu,m3h4x8(:,3),heltab2x32(:,:,53))
  call Hloop_A_Q(ntryL,G1H8(24),35,nMT,G2H8(9),n2h8(47))
  call Hloop_SV_T(ntryL,G1H32(4),32,wf4(:,1),3,G2H8(10),m3h4x8(:,4),heltab2x32(:,:,54))
  call Hloop_AZ_Q(ntryL,G1H32(5),wf4(:,1),G1H8(25),ngZd,m3h4x8(:,5),heltab2x32(:,:,55))
  call Hloop_A_Q(ntryL,G1H8(25),35,nMB,G2H8(11),n2h8(48))
  call Hloop_AZ_Q(ntryL,G1H32(6),wf4(:,1),G1H8(1),ngZd,m3h4x8(:,6),heltab2x32(:,:,56))
  call Hloop_A_Q(ntryL,G1H8(1),35,nMB,G2H8(12),n2h8(49))
  call Hloop_AZ_Q(ntryL,G1H32(7),wf4(:,1),G1H8(26),ngZu,m3h4x8(:,7),heltab2x32(:,:,57))
  call Hloop_A_Q(ntryL,G1H8(26),35,nMT,G2H8(13),n2h8(50))
  call Hloop_VV_S(ntryL,G0H32(6),wf4(:,1),G0H8(1),m3h4x8(:,8),heltab2x32(:,:,58))
  call Hloop_SV_V(ntryL,G1H32(8),wf4(:,1),G1H8(29),m3h4x8(:,9),heltab2x32(:,:,59))
  call Hloop_SV_T(ntryL,G0H32(7),32,wf4(:,1),3,G1H8(30),m3h4x8(:,10),heltab2x32(:,:,60))
  call Hloop_SV_T(ntryL,G1H32(9),32,wf4(:,1),3,G2H8(14),m3h4x8(:,11),heltab2x32(:,:,61))
  call Hloop_UW_V(ntryL,G0H32(8),32,wf4(:,1),3,G1H8(2),m3h4x8(:,12),heltab2x32(:,:,62))
  call Hloop_VV_S(ntryL,G1H32(10),wf4(:,1),G1H8(31),m3h4x8(:,13),heltab2x32(:,:,63))
  call Hloop_SV_V(ntryL,G0H32(9),wf4(:,1),G0H8(2),m3h4x8(:,14),heltab2x32(:,:,64))
  call Hloop_VV_S(ntryL,G0H32(10),wf4(:,1),G0H8(3),m3h4x8(:,15),heltab2x32(:,:,65))
  call Hloop_SV_V(ntryL,G1H32(11),wf4(:,1),G1H8(34),m3h4x8(:,16),heltab2x32(:,:,66))
  call Hloop_SV_T(ntryL,G0H32(11),32,wf4(:,1),3,G1H8(35),m3h4x8(:,17),heltab2x32(:,:,67))
  call Hloop_UW_V(ntryL,G1H32(12),32,wf4(:,1),3,G2H8(15),m3h4x8(:,18),heltab2x32(:,:,68))
  call Hloop_UW_V(ntryL,G0H32(12),32,wf4(:,1),3,G1H8(3),m3h4x8(:,19),heltab2x32(:,:,69))
  call Hloop_VV_S(ntryL,G1H32(13),wf4(:,1),G1H8(36),m3h4x8(:,20),heltab2x32(:,:,70))
  call Hloop_SV_V(ntryL,G0H32(13),wf4(:,1),G0H8(4),m3h4x8(:,21),heltab2x32(:,:,71))
  call Hloop_UW_V(ntryL,G1H32(14),32,wf4(:,1),3,G2H8(16),m3h4x8(:,22),heltab2x32(:,:,72))
  call Hloop_QZ_A(ntryL,G1H32(15),wf4(:,1),G1H8(39),ngZd,m3h4x8(:,23),heltab2x32(:,:,73))
  call Hloop_Q_A(ntryL,G1H8(39),35,nMB,G2H8(17),n2h8(51))
  call Hloop_QZ_A(ntryL,G1H32(16),wf4(:,1),G1H8(40),ngZd,m3h4x8(:,24),heltab2x32(:,:,74))
  call Hloop_Q_A(ntryL,G1H8(40),35,nMB,G2H8(18),n2h8(52))
  call Hloop_QZ_A(ntryL,G1H32(17),wf4(:,1),G1H8(41),ngZu,m3h4x8(:,25),heltab2x32(:,:,75))
  call Hloop_Q_A(ntryL,G1H8(41),35,nMT,G2H8(19),n2h8(53))
  call Hloop_TV_S(ntryL,G1H32(18),32,wf4(:,1),3,G2H8(20),m3h4x8(:,26),heltab2x32(:,:,76))
  call Hloop_QZ_A(ntryL,G1H32(19),wf4(:,1),G1H8(42),ngZd,m3h4x8(:,27),heltab2x32(:,:,77))
  call Hloop_Q_A(ntryL,G1H8(42),35,nMB,G2H8(21),n2h8(54))
  call Hloop_QZ_A(ntryL,G1H32(20),wf4(:,1),G1H8(45),ngZd,m3h4x8(:,28),heltab2x32(:,:,78))
  call Hloop_Q_A(ntryL,G1H8(45),35,nMB,G2H8(22),n2h8(55))
  call Hloop_QZ_A(ntryL,G1H32(21),wf4(:,1),G1H8(46),ngZu,m3h4x8(:,29),heltab2x32(:,:,79))
  call Hloop_Q_A(ntryL,G1H8(46),35,nMT,G2H8(23),n2h8(56))
  call Hloop_VV_S(ntryL,G0H32(3),wf4(:,1),G0H8(5),m3h4x8(:,30),heltab2x32(:,:,80))
  call Hloop_TV_S(ntryL,G0H32(4),32,wf4(:,1),3,G1H8(47),m3h4x8(:,31),heltab2x32(:,:,81))
  call Hloop_SV_V(ntryL,G1H32(22),wf4(:,1),G1H8(48),m3h4x8(:,32),heltab2x32(:,:,82))
  call Hloop_TV_S(ntryL,G1H32(23),32,wf4(:,1),3,G2H8(24),m3h4x8(:,33),heltab2x32(:,:,83))
  call Hloop_VV_S(ntryL,G1H32(24),wf4(:,1),G1H8(51),m3h4x8(:,34),heltab2x32(:,:,84))
  call Hloop_UV_W(ntryL,G0H32(5),32,wf4(:,1),3,G1H8(52),m3h4x8(:,35),heltab2x32(:,:,85))
  call Hloop_SV_V(ntryL,G0H32(14),wf4(:,1),G0H8(6),m3h4x8(:,36),heltab2x32(:,:,86))
  call Hloop_VV_S(ntryL,G0H32(15),wf4(:,1),G0H8(7),m3h4x8(:,37),heltab2x32(:,:,87))
  call Hloop_TV_S(ntryL,G0H32(16),32,wf4(:,1),3,G1H8(53),m3h4x8(:,38),heltab2x32(:,:,88))
  call Hloop_SV_V(ntryL,G1H32(25),wf4(:,1),G1H8(54),m3h4x8(:,39),heltab2x32(:,:,89))
  call Hloop_UV_W(ntryL,G1H32(26),32,wf4(:,1),3,G2H8(25),m3h4x8(:,40),heltab2x32(:,:,90))
  call Hloop_VV_S(ntryL,G1H32(27),wf4(:,1),G1H8(57),m3h4x8(:,41),heltab2x32(:,:,91))
  call Hloop_UV_W(ntryL,G0H32(17),32,wf4(:,1),3,G1H8(58),m3h4x8(:,42),heltab2x32(:,:,92))
  call Hloop_SV_V(ntryL,G0H32(1),wf4(:,1),G0H8(8),m3h4x8(:,43),heltab2x32(:,:,93))
  call Hloop_UV_W(ntryL,G1H32(28),32,wf4(:,1),3,G2H8(26),m3h4x8(:,44),heltab2x32(:,:,94))
  call Hloop_QZ_A(ntryL,G1H32(29),wf4(:,1),G1H8(5),ngZd,m3h4x8(:,45),heltab2x32(:,:,95))
  call Hloop_Q_A(ntryL,G1H8(5),35,nMB,G2H8(27),n2h8(57))
  call Hloop_QZ_A(ntryL,G1H32(30),wf4(:,1),G1H8(6),ngZd,m3h4x8(:,46),heltab2x32(:,:,96))
  call Hloop_Q_A(ntryL,G1H8(6),35,nMB,G2H8(28),n2h8(58))
  call Hloop_QZ_A(ntryL,G1H32(31),wf4(:,1),G1H8(61),ngZu,m3h4x8(:,47),heltab2x32(:,:,97))
  call Hloop_Q_A(ntryL,G1H8(61),35,nMT,G2H8(29),n2h8(59))



end subroutine vamp_1

end module ol_vamp_1_ppnnjj_ew_nenexbbxaa_2_/**/REALKIND
