
! **********************************************************************
module ol_tables_storage_ppnnjj_ew_nenexuxcdsx_1_/**/REALKIND
! **********************************************************************
  use KIND_TYPES, only: REALKIND, QREALKIND, intkind2
  use ol_data_types_/**/REALKIND, only: hol
  use ol_data_types_/**/REALKIND, only: basis, redset4, redset5
 use ol_data_types_/**/REALKIND, only: scalarbox 

  implicit none

  ! helicity tables for the 1-loop recursion
integer(intkind2), save :: h0tab(64,56)
integer(intkind2), save :: heltab2x2(2,2,102)
integer(intkind2), save :: heltab2x4(2,4,57)
integer(intkind2), save :: heltab2x8(2,8,46)
integer(intkind2), save :: heltab2x16(2,16,27)
integer(intkind2), save :: heltab2x32(2,32,36)
integer(intkind2), save :: heltab2x64(2,64,56)


  ! number of helicity states for openloops recursion steps
integer(intkind2), save :: m0h(56)
integer(intkind2), save :: m3h2x1(3,102)
integer(intkind2), save :: m3h4x1(3,9)
integer(intkind2), save :: m3h8x1(3,10)
integer(intkind2), save :: m3h16x1(3,4)
integer(intkind2), save :: m3h2x2(3,48)
integer(intkind2), save :: m3h4x2(3,18)
integer(intkind2), save :: m3h8x2(3,5)
integer(intkind2), save :: m3h2x4(3,18)
integer(intkind2), save :: m3h4x4(3,6)
integer(intkind2), save :: m3h8x4(3,5)
integer(intkind2), save :: m3h16x4(3,4)
integer(intkind2), save :: m3h2x8(3,12)
integer(intkind2), save :: m3h4x8(3,8)
integer(intkind2), save :: m3h8x8(3,12)
integer(intkind2), save :: m3h2x16(3,23)
integer(intkind2), save :: m3h4x16(3,4)
integer(intkind2), save :: m3h2x32(3,36)

integer(intkind2), save :: n2h1(75)
integer(intkind2), save :: n2h2(47)
integer(intkind2), save :: n2h4(26)
integer(intkind2), save :: n2h8(22)
integer(intkind2), save :: n2h16(19)
integer(intkind2), save :: n2h32(16)


contains

!**********************************************************************
subroutine HOL_m3_init()
!**********************************************************************
! initialize m3 arrays for helicity summation
!**********************************************************************
  use KIND_TYPES, only: REALKIND, intkind2

m3h2x1(1,:)=2
m3h2x1(2,:)=1
m3h2x1(3,:)=2
m3h4x1(1,:)=4
m3h4x1(2,:)=1
m3h4x1(3,:)=4
m3h8x1(1,:)=8
m3h8x1(2,:)=1
m3h8x1(3,:)=8
m3h16x1(1,:)=16
m3h16x1(2,:)=1
m3h16x1(3,:)=16
m3h2x2(1,:)=2
m3h2x2(2,:)=2
m3h2x2(3,:)=4
m3h4x2(1,:)=4
m3h4x2(2,:)=2
m3h4x2(3,:)=8
m3h8x2(1,:)=8
m3h8x2(2,:)=2
m3h8x2(3,:)=16
m3h2x4(1,:)=2
m3h2x4(2,:)=4
m3h2x4(3,:)=8
m3h4x4(1,:)=4
m3h4x4(2,:)=4
m3h4x4(3,:)=16
m3h8x4(1,:)=8
m3h8x4(2,:)=4
m3h8x4(3,:)=32
m3h16x4(1,:)=16
m3h16x4(2,:)=4
m3h16x4(3,:)=64
m3h2x8(1,:)=2
m3h2x8(2,:)=8
m3h2x8(3,:)=16
m3h4x8(1,:)=4
m3h4x8(2,:)=8
m3h4x8(3,:)=32
m3h8x8(1,:)=8
m3h8x8(2,:)=8
m3h8x8(3,:)=64
m3h2x16(1,:)=2
m3h2x16(2,:)=16
m3h2x16(3,:)=32
m3h4x16(1,:)=4
m3h4x16(2,:)=16
m3h4x16(3,:)=64
m3h2x32(1,:)=2
m3h2x32(2,:)=32
m3h2x32(3,:)=64

n2h1(:)=1
n2h2(:)=2
n2h4(:)=4
n2h8(:)=8
n2h16(:)=16
n2h32(:)=32


end subroutine HOL_m3_init

!**********************************************************************

end module ol_tables_storage_ppnnjj_ew_nenexuxcdsx_1_/**/REALKIND

! **********************************************************************
module ol_tensor_sum_storage_ppnnjj_ew_nenexuxcdsx_1_/**/REALKIND
! **********************************************************************
  use KIND_TYPES, only: REALKIND, QREALKIND, intkind2
  use ol_data_types_/**/REALKIND, only: hol, hcl, met
  use ol_data_types_/**/REALKIND, only: basis, redset4, redset5
 use ol_data_types_/**/REALKIND, only: scalarbox 

  implicit none

  type(met), save :: M2L1R1

  ! Declarations of loop wave function tensors

  type(hol), save :: G0H1(1)
  type(hol), save :: G1H1(1)
  type(hol), save :: G1H2(35)
  type(hol), save :: G2H2(29)
  type(hol), save :: G0H4(1)
  type(hol), save :: G1H4(30)
  type(hol), save :: G2H4(9)
  type(hol), save :: G0H8(2)
  type(hol), save :: G1H8(13)
  type(hol), save :: G2H8(4)
  type(hol), save :: G0H16(1)
  type(hol), save :: G1H16(9)
  type(hol), save :: G0H32(7)
  type(hol), save :: G1H32(7)
  type(hol), save :: G0H64(1)
  type(hcl), save, dimension(440) :: G0tensor
  type(hcl), save, dimension(312) :: G1tensor
  type(hcl), save, dimension(71) :: G2tensor



  ! Declarations for on-the-fly tensor reduction
type (basis),      save :: RedBasis(105)
type (redset4),    save :: RedSet_4(86)
type (redset5),    save :: RedSet_5(26)
integer, save :: mass2set(0:1,1)
integer, save :: mass3set(0:2,6)
integer, save :: mass4set(0:3,10)
integer, save :: mass5set(0:4,11)



  ! Declarations for TI calls

  integer, save :: momenta_1(2)
  integer, save :: momenta_2(2)
  integer, save :: momenta_3(2)
  integer, save :: momenta_4(2)
  integer, save :: momenta_5(2)
  integer, save :: momenta_6(2)
  integer, save :: momenta_7(2)
  integer, save :: momenta_8(2)
  integer, save :: momenta_9(2)
  integer, save :: momenta_10(2)
  integer, save :: momenta_11(2)
  integer, save :: momenta_12(2)
  integer, save :: momenta_13(2)
  integer, save :: momenta_14(2)
  integer, save :: momenta_15(2)
  integer, save :: momenta_16(2)
  integer, save :: momenta_17(3)
  integer, save :: momenta_18(3)
  integer, save :: momenta_19(3)
  integer, save :: momenta_20(3)
  integer, save :: momenta_21(3)
  integer, save :: momenta_22(3)
  integer, save :: momenta_23(3)
  integer, save :: momenta_24(3)
  integer, save :: momenta_25(3)
  integer, save :: momenta_26(3)
  integer, save :: momenta_27(3)
  integer, save :: momenta_28(3)
  integer, save :: momenta_29(3)
  integer, save :: momenta_30(3)
  integer, save :: momenta_31(3)
  integer, save :: momenta_32(3)
  integer, save :: momenta_33(3)
  integer, save :: momenta_34(3)
  integer, save :: momenta_35(3)
  integer, save :: momenta_36(3)
  integer, save :: momenta_37(3)
  integer, save :: momenta_38(3)
  integer, save :: momenta_39(3)
  integer, save :: momenta_40(3)
  integer, save :: momenta_41(3)
  integer, save :: momenta_42(3)
  integer, save :: momenta_43(3)
  integer, save :: momenta_44(3)
  integer, save :: momenta_45(3)
  integer, save :: momenta_46(3)
  integer, save :: momenta_47(3)
  integer, save :: momenta_48(3)
  integer, save :: momenta_49(3)
  integer, save :: momenta_50(3)
  integer, save :: momenta_51(3)
  integer, save :: momenta_52(3)
  integer, save :: momenta_53(3)
  integer, save :: momenta_54(3)
  integer, save :: momenta_55(3)
  integer, save :: momenta_56(3)
  integer, save :: momenta_57(3)
  integer, save :: momenta_58(3)
  integer, save :: momenta_59(3)
  integer, save :: momenta_60(3)
  integer, save :: momenta_61(3)
  integer, save :: momenta_62(3)
  integer, save :: momenta_63(3)
  integer, save :: momenta_64(3)
  integer, save :: momenta_65(3)
  integer, save :: momenta_66(3)
  integer, save :: momenta_67(3)
  integer, save :: momenta_68(3)
  integer, save :: momenta_69(3)
  integer, save :: momenta_70(3)
  integer, save :: momenta_71(3)
  integer, save :: momenta_72(3)
  integer, save :: momenta_73(3)
  integer, save :: momenta_74(3)
  integer, save :: momenta_75(3)
  integer, save :: momenta_76(3)
  integer, save :: momenta_77(3)
  integer, save :: momenta_78(3)
  integer, save :: momenta_79(3)
  integer, save :: momenta_80(3)
  integer, save :: momenta_81(3)
  integer, save :: momenta_82(3)
  integer, save :: momenta_83(3)
  integer, save :: momenta_84(3)
  integer, save :: momenta_85(3)
  integer, save :: momenta_86(3)
  integer, save :: momenta_87(4)
  integer, save :: momenta_88(4)
  integer, save :: momenta_89(4)
  integer, save :: momenta_90(4)
  integer, save :: momenta_91(4)
  integer, save :: momenta_92(4)
  integer, save :: momenta_93(4)
  integer, save :: momenta_94(4)
  integer, save :: momenta_95(4)
  integer, save :: momenta_96(4)
  integer, save :: momenta_97(4)
  integer, save :: momenta_98(4)
  integer, save :: momenta_99(4)
  integer, save :: momenta_100(4)
  integer, save :: momenta_101(4)
  integer, save :: momenta_102(4)
  integer, save :: momenta_103(4)
  integer, save :: momenta_104(4)
  integer, save :: momenta_105(4)
  integer, save :: momenta_106(4)
  integer, save :: momenta_107(4)
  integer, save :: momenta_108(4)
  integer, save :: momenta_109(4)
  integer, save :: momenta_110(4)
  integer, save :: momenta_111(4)
  integer, save :: momenta_112(4)
  integer, save :: momenta_113(4)
  integer, save :: momenta_114(4)
  integer, save :: momenta_115(4)
  integer, save :: momenta_116(4)
  integer, save :: momenta_117(4)
  integer, save :: momenta_118(4)
  integer, save :: momenta_119(4)
  integer, save :: momenta_120(4)
  integer, save :: momenta_121(4)
  integer, save :: momenta_122(4)
  integer, save :: momenta_123(4)
  integer, save :: momenta_124(4)
  integer, save :: momenta_125(4)
  integer, save :: momenta_126(4)
  integer, save :: momenta_127(4)
  integer, save :: momenta_128(4)
  integer, save :: momenta_129(4)
  integer, save :: momenta_130(4)
  integer, save :: momenta_131(4)
  integer, save :: momenta_132(4)
  integer, save :: momenta_133(4)
  integer, save :: momenta_134(4)
  integer, save :: momenta_135(4)
  integer, save :: momenta_136(4)
  integer, save :: momenta_137(4)
  integer, save :: momenta_138(4)
  integer, save :: momenta_139(4)
  integer, save :: momenta_140(4)
  integer, save :: momenta_141(4)
  integer, save :: momenta_142(4)
  integer, save :: momenta_143(4)
  integer, save :: momenta_144(4)
  integer, save :: momenta_145(4)
  integer, save :: momenta_146(4)
  integer, save :: momenta_147(4)
  integer, save :: momenta_148(4)
  integer, save :: momenta_149(4)
  integer, save :: momenta_150(4)
  integer, save :: momenta_151(5)
  integer, save :: momenta_152(5)
  integer, save :: momenta_153(5)
  integer, save :: momenta_154(5)
  integer, save :: momenta_155(5)
  integer, save :: momenta_156(5)
  integer, save :: momenta_157(5)
  integer, save :: momenta_158(5)
  integer, save :: momenta_159(5)
  integer, save :: momenta_160(5)
  integer, save :: momenta_161(5)
  integer, save :: momenta_162(5)
  integer, save :: momenta_163(5)
  integer, save :: momenta_164(5)
  integer, save :: momenta_165(5)
  integer, save :: momenta_166(5)
  integer, save :: momenta_167(5)
  integer, save :: momenta_168(5)
  integer, save :: momenta_169(5)
  integer, save :: momenta_170(5)
  integer, save :: momenta_171(5)
  integer, save :: momenta_172(5)
  integer, save :: momenta_173(6)
  integer, save :: momenta_174(6)
  integer, save :: momenta_175(6)
  integer, save :: momenta_176(6)

  integer, save :: masses2_1(2)
  integer, save :: masses2_2(2)
  integer, save :: masses2_3(2)
  integer, save :: masses2_4(2)
  integer, save :: masses2_5(3)
  integer, save :: masses2_6(3)
  integer, save :: masses2_7(3)
  integer, save :: masses2_8(3)
  integer, save :: masses2_9(3)
  integer, save :: masses2_10(3)
  integer, save :: masses2_11(3)
  integer, save :: masses2_12(4)
  integer, save :: masses2_13(4)
  integer, save :: masses2_14(4)
  integer, save :: masses2_15(4)
  integer, save :: masses2_16(4)
  integer, save :: masses2_17(4)
  integer, save :: masses2_18(4)
  integer, save :: masses2_19(4)
  integer, save :: masses2_20(4)
  integer, save :: masses2_21(4)
  integer, save :: masses2_22(4)
  integer, save :: masses2_23(5)
  integer, save :: masses2_24(5)
  integer, save :: masses2_25(5)
  integer, save :: masses2_26(5)
  integer, save :: masses2_27(5)
  integer, save :: masses2_28(5)
  integer, save :: masses2_29(5)
  integer, save :: masses2_30(5)
  integer, save :: masses2_31(5)
  integer, save :: masses2_32(5)
  integer, save :: masses2_33(5)
  integer, save :: masses2_34(6)
  integer, save :: masses2_35(6)
  integer, save :: masses2_36(6)

type(scalarbox), save :: ScalarBoxes(99)

integer, save :: sbarray_1(15)
integer, save :: sbarray_2(15)
integer, save :: sbarray_3(15)
integer, save :: sbarray_4(15)
integer, save :: sbarray_5(5)
integer, save :: sbarray_6(5)
integer, save :: sbarray_7(5)
integer, save :: sbarray_8(5)
integer, save :: sbarray_9(5)
integer, save :: sbarray_10(5)
integer, save :: sbarray_11(5)
integer, save :: sbarray_12(5)
integer, save :: sbarray_13(5)
integer, save :: sbarray_14(5)
integer, save :: sbarray_15(5)
integer, save :: sbarray_16(5)
integer, save :: sbarray_17(5)
integer, save :: sbarray_18(5)
integer, save :: sbarray_19(5)
integer, save :: sbarray_20(5)
integer, save :: sbarray_21(5)
integer, save :: sbarray_22(5)
integer, save :: sbarray_23(5)
integer, save :: sbarray_24(5)
integer, save :: sbarray_25(5)
integer, save :: sbarray_26(5)
integer, save :: sbarray_27(5)
integer, save :: sbarray_28(5)
integer, save :: sbarray_29(5)
integer, save :: sbarray_30(5)

  type(hcl), save, dimension(240) :: T0sum
  type(hcl), save, dimension(30) :: T1sum


  contains

!**********************************************************************
subroutine HOL_memory_allocation()
!**********************************************************************
! allocation of memory for the types hol
!**********************************************************************
  use KIND_TYPES, only: REALKIND
  use ol_data_types_/**/REALKIND, only: hol
  use hol_initialisation_/**/REALKIND, only: hol_allocation
  implicit none

    call hol_allocation(4,1,4,1,G0H1,1)
  call hol_allocation(4,5,4,1,G1H1,1)
  call hol_allocation(4,5,4,2,G1H2,35)
  call hol_allocation(4,15,4,2,G2H2,29)
  call hol_allocation(4,1,4,4,G0H4,1)
  call hol_allocation(4,5,4,4,G1H4,30)
  call hol_allocation(4,15,4,4,G2H4,9)
  call hol_allocation(4,1,4,8,G0H8,2)
  call hol_allocation(4,5,4,8,G1H8,13)
  call hol_allocation(4,15,4,8,G2H8,4)
  call hol_allocation(4,1,4,16,G0H16,1)
  call hol_allocation(4,5,4,16,G1H16,9)
  call hol_allocation(4,1,4,32,G0H32,7)
  call hol_allocation(4,5,4,32,G1H32,7)
  call hol_allocation(4,1,4,64,G0H64,1)


end subroutine HOL_memory_allocation


!**********************************************************************
subroutine HOL_memory_deallocation_/**/REALKIND(dmode)
!**********************************************************************
! allocation of memory for the types hol
!**********************************************************************
  use KIND_TYPES, only: REALKIND
  use ol_data_types_/**/REALKIND, only: hol
  use hol_initialisation_/**/REALKIND, only: hol_deallocation
  implicit none
  integer,   intent(in)    :: dmode

    call hol_deallocation(G0H1,1,dmode)
  call hol_deallocation(G1H1,1,dmode)
  call hol_deallocation(G1H2,35,dmode)
  call hol_deallocation(G2H2,29,dmode)
  call hol_deallocation(G0H4,1,dmode)
  call hol_deallocation(G1H4,30,dmode)
  call hol_deallocation(G2H4,9,dmode)
  call hol_deallocation(G0H8,2,dmode)
  call hol_deallocation(G1H8,13,dmode)
  call hol_deallocation(G2H8,4,dmode)
  call hol_deallocation(G0H16,1,dmode)
  call hol_deallocation(G1H16,9,dmode)
  call hol_deallocation(G0H32,7,dmode)
  call hol_deallocation(G1H32,7,dmode)
  call hol_deallocation(G0H64,1,dmode)


end subroutine HOL_memory_deallocation_/**/REALKIND

!**********************************************************************
subroutine HCL_memory_allocation()
!**********************************************************************
! allocation of memory for the types hcl
!**********************************************************************
  use KIND_TYPES, only: REALKIND
  use ol_data_types_/**/REALKIND, only: hcl
  use hol_initialisation_/**/REALKIND, only: hcl_allocation
  implicit none

  call hcl_allocation(1,G0tensor, 440)
call hcl_allocation(5,G1tensor, 312)
call hcl_allocation(15,G2tensor, 71)


end subroutine HCL_memory_allocation


!**********************************************************************
subroutine HCL_memory_deallocation_/**/REALKIND(dmode)
!**********************************************************************
! deallocation of memory for the types hcl
!**********************************************************************
  use KIND_TYPES, only: REALKIND
  use ol_data_types_/**/REALKIND, only: hcl
  use hol_initialisation_/**/REALKIND, only: hcl_deallocation
  implicit none
  integer,   intent(in)    :: dmode

  call hcl_deallocation(G0tensor, 440,dmode)
call hcl_deallocation(G1tensor, 312,dmode)
call hcl_deallocation(G2tensor, 71,dmode)

    call hcl_deallocation(T0sum,240,dmode)
  call hcl_deallocation(T1sum,30,dmode)


end subroutine HCL_memory_deallocation_/**/REALKIND


!**********************************************************************
subroutine Tsum_memory_allocation()
!**********************************************************************
! allocation of memory for the types hcl
!**********************************************************************
  use KIND_TYPES, only: REALKIND
  use ol_data_types_/**/REALKIND, only: hcl
  use hol_initialisation_/**/REALKIND, only: hcl_allocation
  implicit none

    call hcl_allocation(1,T0sum,240)
  call hcl_allocation(5,T1sum,30)


end subroutine Tsum_memory_allocation


#ifdef PRECISION_dp
subroutine max_point(r) &
    & bind(c,name="ol_f_max_point_ppnnjj_ew_nenexuxcdsx_1")
  ! Return the number maximal tensor rank
  implicit none
  integer, intent(out) :: r
  r = 6
end subroutine max_point

subroutine tensor_rank(r) &
    & bind(c,name="ol_f_tensor_rank_ppnnjj_ew_nenexuxcdsx_1")
  ! Return the number maximal tensor rank
  implicit none
  integer, intent(out) :: r
  r = 1
end subroutine tensor_rank
#endif

subroutine reset_tensor_sum()
  use hol_initialisation_/**/REALKIND, only: hcl_allocation
  use ol_parameters_init_/**/REALKIND, only: init_hcl
  implicit none
  integer :: i

  do i = 1,240
    call init_hcl(T0sum(i))
  end do
  do i = 1,30
    call init_hcl(T1sum(i))
  end do

end subroutine reset_tensor_sum


subroutine scale_one_tsum(tsum, spow)
  use ol_parameters_decl_/**/REALKIND, only: scalefactor
  implicit none
  complex(REALKIND), intent(inout) :: tsum(:)
  integer, intent(in) :: spow ! rank 0 scale power
  real(REALKIND) :: sfinv, sfac
  integer :: sz
  sfinv = 1/scalefactor
  sfac = scalefactor**spow
  sz = size(tsum)
  tsum(1) = sfac*tsum(1)
  if (sz > 1) then ! rank 1
    sfac = sfac*sfinv
    tsum(2:5) = sfac*tsum(2:5)
  end if
  if (sz > 5) then ! rank 2
    sfac = sfac*sfinv
    tsum(6:15) = sfac*tsum(6:15)
  end if
  if (sz > 15) then ! rank 3
    sfac = sfac*sfinv
    tsum(16:35) = sfac*tsum(16:35)
  end if
  if (sz > 35) then ! rank 4
    sfac = sfac*sfinv
    tsum(36:70) = sfac*tsum(36:70)
  end if
  if (sz > 70) then ! rank 5
    sfac = sfac*sfinv
    tsum(71:126) = sfac*tsum(71:126)
  end if
  if (sz > 126) then ! rank 6
    sfac = sfac*sfinv
    tsum(127:210) = sfac*tsum(127:210)
  end if
  if (sz > 210) then ! rank 7
    sfac = sfac*sfinv
    tsum(211:330) = sfac*tsum(211:330)
  end if
end subroutine scale_one_tsum


subroutine scale_tensor_sum()
  implicit none
  call scale_one_tsum(T1sum(1)%cmp, 4)
  call scale_one_tsum(T1sum(2)%cmp, 4)
  call scale_one_tsum(T1sum(3)%cmp, 4)
  call scale_one_tsum(T1sum(4)%cmp, 4)
  call scale_one_tsum(T1sum(5)%cmp, 2)
  call scale_one_tsum(T1sum(6)%cmp, 2)
  call scale_one_tsum(T1sum(7)%cmp, 2)
  call scale_one_tsum(T1sum(8)%cmp, 2)
  call scale_one_tsum(T1sum(9)%cmp, 2)
  call scale_one_tsum(T1sum(10)%cmp, 2)
  call scale_one_tsum(T1sum(11)%cmp, 2)
  call scale_one_tsum(T1sum(12)%cmp, 2)
  call scale_one_tsum(T1sum(13)%cmp, 2)
  call scale_one_tsum(T1sum(14)%cmp, 2)
  call scale_one_tsum(T1sum(15)%cmp, 2)
  call scale_one_tsum(T1sum(16)%cmp, 2)
  call scale_one_tsum(T1sum(17)%cmp, 2)
  call scale_one_tsum(T1sum(18)%cmp, 2)
  call scale_one_tsum(T1sum(19)%cmp, 2)
  call scale_one_tsum(T1sum(20)%cmp, 2)
  call scale_one_tsum(T1sum(21)%cmp, 2)
  call scale_one_tsum(T1sum(22)%cmp, 2)
  call scale_one_tsum(T1sum(23)%cmp, 2)
  call scale_one_tsum(T1sum(24)%cmp, 2)
  call scale_one_tsum(T1sum(25)%cmp, 2)
  call scale_one_tsum(T1sum(26)%cmp, 2)
  call scale_one_tsum(T1sum(27)%cmp, 2)
  call scale_one_tsum(T1sum(28)%cmp, 2)
  call scale_one_tsum(T1sum(29)%cmp, 2)
  call scale_one_tsum(T1sum(30)%cmp, 2)
  call scale_one_tsum(T0sum(1)%cmp, 0)
  call scale_one_tsum(T0sum(2)%cmp, 0)
  call scale_one_tsum(T0sum(3)%cmp, 0)
  call scale_one_tsum(T0sum(4)%cmp, 0)
  call scale_one_tsum(T0sum(5)%cmp, 0)
  call scale_one_tsum(T0sum(6)%cmp, 0)
  call scale_one_tsum(T0sum(7)%cmp, 0)
  call scale_one_tsum(T0sum(8)%cmp, 0)
  call scale_one_tsum(T0sum(9)%cmp, 0)
  call scale_one_tsum(T0sum(10)%cmp, 0)
  call scale_one_tsum(T0sum(11)%cmp, 0)
  call scale_one_tsum(T0sum(12)%cmp, 0)
  call scale_one_tsum(T0sum(13)%cmp, 0)
  call scale_one_tsum(T0sum(14)%cmp, 0)
  call scale_one_tsum(T0sum(15)%cmp, 0)
  call scale_one_tsum(T0sum(16)%cmp, 0)
  call scale_one_tsum(T0sum(17)%cmp, 0)
  call scale_one_tsum(T0sum(18)%cmp, 0)
  call scale_one_tsum(T0sum(19)%cmp, 0)
  call scale_one_tsum(T0sum(20)%cmp, 0)
  call scale_one_tsum(T0sum(21)%cmp, 0)
  call scale_one_tsum(T0sum(22)%cmp, 0)
  call scale_one_tsum(T0sum(23)%cmp, 0)
  call scale_one_tsum(T0sum(24)%cmp, 0)
  call scale_one_tsum(T0sum(25)%cmp, 0)
  call scale_one_tsum(T0sum(26)%cmp, 0)
  call scale_one_tsum(T0sum(27)%cmp, 0)
  call scale_one_tsum(T0sum(28)%cmp, 0)
  call scale_one_tsum(T0sum(29)%cmp, 0)
  call scale_one_tsum(T0sum(30)%cmp, 0)
  call scale_one_tsum(T0sum(31)%cmp, 0)
  call scale_one_tsum(T0sum(32)%cmp, 0)
  call scale_one_tsum(T0sum(33)%cmp, 0)
  call scale_one_tsum(T0sum(34)%cmp, 0)
  call scale_one_tsum(T0sum(35)%cmp, 0)
  call scale_one_tsum(T0sum(36)%cmp, 0)
  call scale_one_tsum(T0sum(37)%cmp, 0)
  call scale_one_tsum(T0sum(38)%cmp, 0)
  call scale_one_tsum(T0sum(39)%cmp, 0)
  call scale_one_tsum(T0sum(40)%cmp, 0)
  call scale_one_tsum(T0sum(41)%cmp, 0)
  call scale_one_tsum(T0sum(42)%cmp, 0)
  call scale_one_tsum(T0sum(43)%cmp, 0)
  call scale_one_tsum(T0sum(44)%cmp, 0)
  call scale_one_tsum(T0sum(45)%cmp, 0)
  call scale_one_tsum(T0sum(46)%cmp, 0)
  call scale_one_tsum(T0sum(47)%cmp, 0)
  call scale_one_tsum(T0sum(48)%cmp, 0)
  call scale_one_tsum(T0sum(49)%cmp, 0)
  call scale_one_tsum(T0sum(50)%cmp, 0)
  call scale_one_tsum(T0sum(51)%cmp, 0)
  call scale_one_tsum(T0sum(52)%cmp, 0)
  call scale_one_tsum(T0sum(53)%cmp, 0)
  call scale_one_tsum(T0sum(54)%cmp, 0)
  call scale_one_tsum(T0sum(55)%cmp, 0)
  call scale_one_tsum(T0sum(56)%cmp, 0)
  call scale_one_tsum(T0sum(57)%cmp, 0)
  call scale_one_tsum(T0sum(58)%cmp, 0)
  call scale_one_tsum(T0sum(59)%cmp, 0)
  call scale_one_tsum(T0sum(60)%cmp, 0)
  call scale_one_tsum(T0sum(61)%cmp, 0)
  call scale_one_tsum(T0sum(62)%cmp, 0)
  call scale_one_tsum(T0sum(63)%cmp, 0)
  call scale_one_tsum(T0sum(64)%cmp, 0)
  call scale_one_tsum(T0sum(65)%cmp, 0)
  call scale_one_tsum(T0sum(66)%cmp, 0)
  call scale_one_tsum(T0sum(67)%cmp, 0)
  call scale_one_tsum(T0sum(68)%cmp, 0)
  call scale_one_tsum(T0sum(69)%cmp, 0)
  call scale_one_tsum(T0sum(70)%cmp, 0)
  call scale_one_tsum(T0sum(71)%cmp, 0)
  call scale_one_tsum(T0sum(72)%cmp, 0)
  call scale_one_tsum(T0sum(73)%cmp, 0)
  call scale_one_tsum(T0sum(74)%cmp, 0)
  call scale_one_tsum(T0sum(75)%cmp, 0)
  call scale_one_tsum(T0sum(76)%cmp, 0)
  call scale_one_tsum(T0sum(77)%cmp, 0)
  call scale_one_tsum(T0sum(78)%cmp, 0)
  call scale_one_tsum(T0sum(79)%cmp, 0)
  call scale_one_tsum(T0sum(80)%cmp, 0)
  call scale_one_tsum(T0sum(81)%cmp, 0)
  call scale_one_tsum(T0sum(82)%cmp, 0)
  call scale_one_tsum(T0sum(83)%cmp, 0)
  call scale_one_tsum(T0sum(84)%cmp, 0)
  call scale_one_tsum(T0sum(85)%cmp, 0)
  call scale_one_tsum(T0sum(86)%cmp, 0)
  call scale_one_tsum(T0sum(87)%cmp, 0)
  call scale_one_tsum(T0sum(88)%cmp, 0)
  call scale_one_tsum(T0sum(89)%cmp, -2)
  call scale_one_tsum(T0sum(90)%cmp, -2)
  call scale_one_tsum(T0sum(91)%cmp, -2)
  call scale_one_tsum(T0sum(92)%cmp, -2)
  call scale_one_tsum(T0sum(93)%cmp, -2)
  call scale_one_tsum(T0sum(94)%cmp, -2)
  call scale_one_tsum(T0sum(95)%cmp, -2)
  call scale_one_tsum(T0sum(96)%cmp, -2)
  call scale_one_tsum(T0sum(97)%cmp, -2)
  call scale_one_tsum(T0sum(98)%cmp, -2)
  call scale_one_tsum(T0sum(99)%cmp, -2)
  call scale_one_tsum(T0sum(100)%cmp, -2)
  call scale_one_tsum(T0sum(101)%cmp, -2)
  call scale_one_tsum(T0sum(102)%cmp, -2)
  call scale_one_tsum(T0sum(103)%cmp, -2)
  call scale_one_tsum(T0sum(104)%cmp, -2)
  call scale_one_tsum(T0sum(105)%cmp, -2)
  call scale_one_tsum(T0sum(106)%cmp, -2)
  call scale_one_tsum(T0sum(107)%cmp, -2)
  call scale_one_tsum(T0sum(108)%cmp, -2)
  call scale_one_tsum(T0sum(109)%cmp, -2)
  call scale_one_tsum(T0sum(110)%cmp, -2)
  call scale_one_tsum(T0sum(111)%cmp, -2)
  call scale_one_tsum(T0sum(112)%cmp, -2)
  call scale_one_tsum(T0sum(113)%cmp, -2)
  call scale_one_tsum(T0sum(114)%cmp, -2)
  call scale_one_tsum(T0sum(115)%cmp, -2)
  call scale_one_tsum(T0sum(116)%cmp, -2)
  call scale_one_tsum(T0sum(117)%cmp, -2)
  call scale_one_tsum(T0sum(118)%cmp, -2)
  call scale_one_tsum(T0sum(119)%cmp, -2)
  call scale_one_tsum(T0sum(120)%cmp, -2)
  call scale_one_tsum(T0sum(121)%cmp, -2)
  call scale_one_tsum(T0sum(122)%cmp, -2)
  call scale_one_tsum(T0sum(123)%cmp, -2)
  call scale_one_tsum(T0sum(124)%cmp, -2)
  call scale_one_tsum(T0sum(125)%cmp, -2)
  call scale_one_tsum(T0sum(126)%cmp, -2)
  call scale_one_tsum(T0sum(127)%cmp, -2)
  call scale_one_tsum(T0sum(128)%cmp, -2)
  call scale_one_tsum(T0sum(129)%cmp, -2)
  call scale_one_tsum(T0sum(130)%cmp, -2)
  call scale_one_tsum(T0sum(131)%cmp, -2)
  call scale_one_tsum(T0sum(132)%cmp, -2)
  call scale_one_tsum(T0sum(133)%cmp, -2)
  call scale_one_tsum(T0sum(134)%cmp, -2)
  call scale_one_tsum(T0sum(135)%cmp, -2)
  call scale_one_tsum(T0sum(136)%cmp, -2)
  call scale_one_tsum(T0sum(137)%cmp, -2)
  call scale_one_tsum(T0sum(138)%cmp, -2)
  call scale_one_tsum(T0sum(139)%cmp, -2)
  call scale_one_tsum(T0sum(140)%cmp, -2)
  call scale_one_tsum(T0sum(141)%cmp, -2)
  call scale_one_tsum(T0sum(142)%cmp, -2)
  call scale_one_tsum(T0sum(143)%cmp, -2)
  call scale_one_tsum(T0sum(144)%cmp, -2)
  call scale_one_tsum(T0sum(145)%cmp, -2)
  call scale_one_tsum(T0sum(146)%cmp, -2)
  call scale_one_tsum(T0sum(147)%cmp, -2)
  call scale_one_tsum(T0sum(148)%cmp, -2)
  call scale_one_tsum(T0sum(149)%cmp, -2)
  call scale_one_tsum(T0sum(150)%cmp, -2)
  call scale_one_tsum(T0sum(151)%cmp, -2)
  call scale_one_tsum(T0sum(152)%cmp, -2)
  call scale_one_tsum(T0sum(153)%cmp, -2)
  call scale_one_tsum(T0sum(154)%cmp, -2)
  call scale_one_tsum(T0sum(155)%cmp, -2)
  call scale_one_tsum(T0sum(156)%cmp, -2)
  call scale_one_tsum(T0sum(157)%cmp, -2)
  call scale_one_tsum(T0sum(158)%cmp, -2)
  call scale_one_tsum(T0sum(159)%cmp, -2)
  call scale_one_tsum(T0sum(160)%cmp, -2)
  call scale_one_tsum(T0sum(161)%cmp, -2)
  call scale_one_tsum(T0sum(162)%cmp, -2)
  call scale_one_tsum(T0sum(163)%cmp, -2)
  call scale_one_tsum(T0sum(164)%cmp, -2)
  call scale_one_tsum(T0sum(165)%cmp, -2)
  call scale_one_tsum(T0sum(166)%cmp, -2)
  call scale_one_tsum(T0sum(167)%cmp, -2)
  call scale_one_tsum(T0sum(168)%cmp, -2)
  call scale_one_tsum(T0sum(169)%cmp, -2)
  call scale_one_tsum(T0sum(170)%cmp, -2)
  call scale_one_tsum(T0sum(171)%cmp, -2)
  call scale_one_tsum(T0sum(172)%cmp, -2)
  call scale_one_tsum(T0sum(173)%cmp, -2)
  call scale_one_tsum(T0sum(174)%cmp, -2)
  call scale_one_tsum(T0sum(175)%cmp, -2)
  call scale_one_tsum(T0sum(176)%cmp, -2)
  call scale_one_tsum(T0sum(177)%cmp, -2)
  call scale_one_tsum(T0sum(178)%cmp, -2)
  call scale_one_tsum(T0sum(179)%cmp, -2)
  call scale_one_tsum(T0sum(180)%cmp, -2)
  call scale_one_tsum(T0sum(181)%cmp, -2)
  call scale_one_tsum(T0sum(182)%cmp, -2)
  call scale_one_tsum(T0sum(183)%cmp, -2)
  call scale_one_tsum(T0sum(184)%cmp, -2)
  call scale_one_tsum(T0sum(185)%cmp, -2)
  call scale_one_tsum(T0sum(186)%cmp, -2)
  call scale_one_tsum(T0sum(187)%cmp, -2)
  call scale_one_tsum(T0sum(188)%cmp, -2)
  call scale_one_tsum(T0sum(189)%cmp, -2)
  call scale_one_tsum(T0sum(190)%cmp, -2)
  call scale_one_tsum(T0sum(191)%cmp, -2)
  call scale_one_tsum(T0sum(192)%cmp, -2)
  call scale_one_tsum(T0sum(193)%cmp, -2)
  call scale_one_tsum(T0sum(194)%cmp, -2)
  call scale_one_tsum(T0sum(195)%cmp, -2)
  call scale_one_tsum(T0sum(196)%cmp, -2)
  call scale_one_tsum(T0sum(197)%cmp, -2)
  call scale_one_tsum(T0sum(198)%cmp, -2)
  call scale_one_tsum(T0sum(199)%cmp, -2)
  call scale_one_tsum(T0sum(200)%cmp, -2)
  call scale_one_tsum(T0sum(201)%cmp, -2)
  call scale_one_tsum(T0sum(202)%cmp, -2)
  call scale_one_tsum(T0sum(203)%cmp, -2)
  call scale_one_tsum(T0sum(204)%cmp, -2)
  call scale_one_tsum(T0sum(205)%cmp, -4)
  call scale_one_tsum(T0sum(206)%cmp, -4)
  call scale_one_tsum(T0sum(207)%cmp, -4)
  call scale_one_tsum(T0sum(208)%cmp, -4)
  call scale_one_tsum(T0sum(209)%cmp, -4)
  call scale_one_tsum(T0sum(210)%cmp, -4)
  call scale_one_tsum(T0sum(211)%cmp, -4)
  call scale_one_tsum(T0sum(212)%cmp, -4)
  call scale_one_tsum(T0sum(213)%cmp, -4)
  call scale_one_tsum(T0sum(214)%cmp, -4)
  call scale_one_tsum(T0sum(215)%cmp, -4)
  call scale_one_tsum(T0sum(216)%cmp, -4)
  call scale_one_tsum(T0sum(217)%cmp, -4)
  call scale_one_tsum(T0sum(218)%cmp, -4)
  call scale_one_tsum(T0sum(219)%cmp, -4)
  call scale_one_tsum(T0sum(220)%cmp, -4)
  call scale_one_tsum(T0sum(221)%cmp, -4)
  call scale_one_tsum(T0sum(222)%cmp, -4)
  call scale_one_tsum(T0sum(223)%cmp, -4)
  call scale_one_tsum(T0sum(224)%cmp, -4)
  call scale_one_tsum(T0sum(225)%cmp, -4)
  call scale_one_tsum(T0sum(226)%cmp, -4)
  call scale_one_tsum(T0sum(227)%cmp, -4)
  call scale_one_tsum(T0sum(228)%cmp, -4)
  call scale_one_tsum(T0sum(229)%cmp, -4)
  call scale_one_tsum(T0sum(230)%cmp, -4)
  call scale_one_tsum(T0sum(231)%cmp, -4)
  call scale_one_tsum(T0sum(232)%cmp, -4)
  call scale_one_tsum(T0sum(233)%cmp, -4)
  call scale_one_tsum(T0sum(234)%cmp, -4)
  call scale_one_tsum(T0sum(235)%cmp, -4)
  call scale_one_tsum(T0sum(236)%cmp, -4)
  call scale_one_tsum(T0sum(237)%cmp, -4)
  call scale_one_tsum(T0sum(238)%cmp, -4)
  call scale_one_tsum(T0sum(239)%cmp, -4)
  call scale_one_tsum(T0sum(240)%cmp, -4)

end subroutine scale_tensor_sum

! **********************************************************************
subroutine set_integral_masses_and_momenta()
! **********************************************************************

  use ol_parameters_decl_/**/REALKIND
  momenta_1 = [ 0, 0 ]
  momenta_2 = [ 32, 31 ]
  momenta_3 = [ 35, 28 ]
  momenta_4 = [ 36, 27 ]
  momenta_5 = [ 39, 24 ]
  momenta_6 = [ 40, 23 ]
  momenta_7 = [ 43, 20 ]
  momenta_8 = [ 44, 19 ]
  momenta_9 = [ 47, 16 ]
  momenta_10 = [ 48, 15 ]
  momenta_11 = [ 51, 12 ]
  momenta_12 = [ 52, 11 ]
  momenta_13 = [ 55, 8 ]
  momenta_14 = [ 56, 7 ]
  momenta_15 = [ 59, 4 ]
  momenta_16 = [ 60, 3 ]
  momenta_17 = [ 32, 2, 29 ]
  momenta_18 = [ 32, 3, 28 ]
  momenta_19 = [ 32, 4, 27 ]
  momenta_20 = [ 32, 7, 24 ]
  momenta_21 = [ 32, 8, 23 ]
  momenta_22 = [ 32, 10, 21 ]
  momenta_23 = [ 32, 11, 20 ]
  momenta_24 = [ 32, 12, 19 ]
  momenta_25 = [ 32, 15, 16 ]
  momenta_26 = [ 32, 19, 12 ]
  momenta_27 = [ 32, 20, 11 ]
  momenta_28 = [ 32, 21, 10 ]
  momenta_29 = [ 32, 23, 8 ]
  momenta_30 = [ 32, 27, 4 ]
  momenta_31 = [ 34, 1, 28 ]
  momenta_32 = [ 34, 5, 24 ]
  momenta_33 = [ 34, 17, 12 ]
  momenta_34 = [ 34, 21, 8 ]
  momenta_35 = [ 35, 4, 24 ]
  momenta_36 = [ 35, 8, 20 ]
  momenta_37 = [ 35, 12, 16 ]
  momenta_38 = [ 35, 16, 12 ]
  momenta_39 = [ 35, 20, 8 ]
  momenta_40 = [ 35, 24, 4 ]
  momenta_41 = [ 36, 3, 24 ]
  momenta_42 = [ 36, 11, 16 ]
  momenta_43 = [ 36, 16, 11 ]
  momenta_44 = [ 36, 17, 10 ]
  momenta_45 = [ 36, 19, 8 ]
  momenta_46 = [ 39, 8, 16 ]
  momenta_47 = [ 39, 16, 8 ]
  momenta_48 = [ 40, 2, 21 ]
  momenta_49 = [ 40, 3, 20 ]
  momenta_50 = [ 40, 4, 19 ]
  momenta_51 = [ 40, 7, 16 ]
  momenta_52 = [ 40, 19, 4 ]
  momenta_53 = [ 40, 20, 3 ]
  momenta_54 = [ 40, 21, 2 ]
  momenta_55 = [ 42, 1, 20 ]
  momenta_56 = [ 42, 4, 17 ]
  momenta_57 = [ 42, 5, 16 ]
  momenta_58 = [ 42, 17, 4 ]
  momenta_59 = [ 42, 20, 1 ]
  momenta_60 = [ 43, 4, 16 ]
  momenta_61 = [ 43, 16, 4 ]
  momenta_62 = [ 44, 2, 17 ]
  momenta_63 = [ 44, 3, 16 ]
  momenta_64 = [ 44, 16, 3 ]
  momenta_65 = [ 44, 17, 2 ]
  momenta_66 = [ 46, 1, 16 ]
  momenta_67 = [ 46, 16, 1 ]
  momenta_68 = [ 48, 3, 12 ]
  momenta_69 = [ 48, 8, 7 ]
  momenta_70 = [ 48, 10, 5 ]
  momenta_71 = [ 48, 11, 4 ]
  momenta_72 = [ 48, 12, 3 ]
  momenta_73 = [ 51, 4, 8 ]
  momenta_74 = [ 51, 8, 4 ]
  momenta_75 = [ 52, 1, 10 ]
  momenta_76 = [ 52, 3, 8 ]
  momenta_77 = [ 52, 8, 3 ]
  momenta_78 = [ 52, 10, 1 ]
  momenta_79 = [ 53, 2, 8 ]
  momenta_80 = [ 53, 8, 2 ]
  momenta_81 = [ 56, 2, 5 ]
  momenta_82 = [ 56, 3, 4 ]
  momenta_83 = [ 56, 4, 3 ]
  momenta_84 = [ 58, 1, 4 ]
  momenta_85 = [ 60, 1, 2 ]
  momenta_86 = [ 60, 2, 1 ]
  momenta_87 = [ 32, 2, 1, 28 ]
  momenta_88 = [ 32, 2, 5, 24 ]
  momenta_89 = [ 32, 2, 17, 12 ]
  momenta_90 = [ 32, 2, 21, 8 ]
  momenta_91 = [ 32, 3, 4, 24 ]
  momenta_92 = [ 32, 3, 8, 20 ]
  momenta_93 = [ 32, 3, 12, 16 ]
  momenta_94 = [ 32, 3, 16, 12 ]
  momenta_95 = [ 32, 3, 20, 8 ]
  momenta_96 = [ 32, 3, 24, 4 ]
  momenta_97 = [ 32, 4, 3, 24 ]
  momenta_98 = [ 32, 4, 16, 11 ]
  momenta_99 = [ 32, 4, 17, 10 ]
  momenta_100 = [ 32, 4, 19, 8 ]
  momenta_101 = [ 32, 7, 16, 8 ]
  momenta_102 = [ 32, 8, 2, 21 ]
  momenta_103 = [ 32, 8, 3, 20 ]
  momenta_104 = [ 32, 8, 4, 19 ]
  momenta_105 = [ 32, 8, 7, 16 ]
  momenta_106 = [ 32, 10, 1, 20 ]
  momenta_107 = [ 32, 10, 5, 16 ]
  momenta_108 = [ 32, 11, 4, 16 ]
  momenta_109 = [ 32, 11, 16, 4 ]
  momenta_110 = [ 32, 12, 3, 16 ]
  momenta_111 = [ 32, 19, 4, 8 ]
  momenta_112 = [ 32, 20, 1, 10 ]
  momenta_113 = [ 32, 20, 3, 8 ]
  momenta_114 = [ 32, 21, 2, 8 ]
  momenta_115 = [ 34, 1, 4, 24 ]
  momenta_116 = [ 34, 1, 16, 12 ]
  momenta_117 = [ 34, 1, 20, 8 ]
  momenta_118 = [ 34, 5, 16, 8 ]
  momenta_119 = [ 34, 17, 4, 8 ]
  momenta_120 = [ 35, 4, 16, 8 ]
  momenta_121 = [ 35, 8, 4, 16 ]
  momenta_122 = [ 35, 8, 16, 4 ]
  momenta_123 = [ 35, 16, 4, 8 ]
  momenta_124 = [ 36, 3, 8, 16 ]
  momenta_125 = [ 36, 3, 16, 8 ]
  momenta_126 = [ 36, 16, 1, 10 ]
  momenta_127 = [ 36, 16, 3, 8 ]
  momenta_128 = [ 36, 17, 2, 8 ]
  momenta_129 = [ 40, 2, 1, 20 ]
  momenta_130 = [ 40, 2, 5, 16 ]
  momenta_131 = [ 40, 2, 17, 4 ]
  momenta_132 = [ 40, 3, 4, 16 ]
  momenta_133 = [ 40, 3, 16, 4 ]
  momenta_134 = [ 40, 4, 3, 16 ]
  momenta_135 = [ 40, 4, 16, 3 ]
  momenta_136 = [ 40, 4, 17, 2 ]
  momenta_137 = [ 40, 20, 1, 2 ]
  momenta_138 = [ 42, 1, 4, 16 ]
  momenta_139 = [ 42, 1, 16, 4 ]
  momenta_140 = [ 42, 4, 16, 1 ]
  momenta_141 = [ 44, 2, 1, 16 ]
  momenta_142 = [ 44, 16, 1, 2 ]
  momenta_143 = [ 48, 3, 8, 4 ]
  momenta_144 = [ 48, 8, 2, 5 ]
  momenta_145 = [ 48, 8, 3, 4 ]
  momenta_146 = [ 48, 8, 4, 3 ]
  momenta_147 = [ 48, 10, 1, 4 ]
  momenta_148 = [ 52, 1, 2, 8 ]
  momenta_149 = [ 52, 8, 2, 1 ]
  momenta_150 = [ 56, 2, 1, 4 ]
  momenta_151 = [ 32, 2, 1, 20, 8 ]
  momenta_152 = [ 32, 2, 5, 16, 8 ]
  momenta_153 = [ 32, 2, 17, 4, 8 ]
  momenta_154 = [ 32, 3, 4, 16, 8 ]
  momenta_155 = [ 32, 3, 8, 4, 16 ]
  momenta_156 = [ 32, 3, 8, 16, 4 ]
  momenta_157 = [ 32, 3, 16, 4, 8 ]
  momenta_158 = [ 32, 4, 3, 16, 8 ]
  momenta_159 = [ 32, 4, 16, 3, 8 ]
  momenta_160 = [ 32, 4, 17, 2, 8 ]
  momenta_161 = [ 32, 8, 2, 5, 16 ]
  momenta_162 = [ 32, 8, 3, 4, 16 ]
  momenta_163 = [ 32, 8, 4, 3, 16 ]
  momenta_164 = [ 32, 10, 1, 4, 16 ]
  momenta_165 = [ 32, 20, 1, 2, 8 ]
  momenta_166 = [ 34, 1, 4, 16, 8 ]
  momenta_167 = [ 34, 1, 16, 4, 8 ]
  momenta_168 = [ 36, 16, 1, 2, 8 ]
  momenta_169 = [ 40, 2, 1, 4, 16 ]
  momenta_170 = [ 40, 2, 1, 16, 4 ]
  momenta_171 = [ 40, 4, 16, 1, 2 ]
  momenta_172 = [ 48, 8, 2, 1, 4 ]
  momenta_173 = [ 32, 2, 1, 4, 16, 8 ]
  momenta_174 = [ 32, 2, 1, 16, 4, 8 ]
  momenta_175 = [ 32, 4, 16, 1, 2, 8 ]
  momenta_176 = [ 32, 8, 2, 1, 4, 16 ]

  masses2_1 = [ 0, 0 ]
  masses2_2 = [ nMW, 0 ]
  masses2_3 = [ 0, nMW ]
  masses2_4 = [ nMW, nMW ]
  masses2_5 = [ 0, 0, 0 ]
  masses2_6 = [ nMW, 0, 0 ]
  masses2_7 = [ 0, 0, nMW ]
  masses2_8 = [ nMW, 0, nMW ]
  masses2_9 = [ 0, nMW, 0 ]
  masses2_10 = [ nMW, nMW, 0 ]
  masses2_11 = [ 0, nMW, nMW ]
  masses2_12 = [ 0, 0, 0, 0 ]
  masses2_13 = [ nMW, 0, 0, 0 ]
  masses2_14 = [ 0, 0, 0, nMW ]
  masses2_15 = [ nMW, 0, 0, nMW ]
  masses2_16 = [ 0, 0, nMW, 0 ]
  masses2_17 = [ nMW, 0, nMW, 0 ]
  masses2_18 = [ 0, 0, nMW, nMW ]
  masses2_19 = [ 0, nMW, 0, 0 ]
  masses2_20 = [ nMW, nMW, 0, 0 ]
  masses2_21 = [ 0, nMW, 0, nMW ]
  masses2_22 = [ 0, nMW, nMW, 0 ]
  masses2_23 = [ nMW, 0, 0, 0, 0 ]
  masses2_24 = [ 0, 0, 0, 0, nMW ]
  masses2_25 = [ 0, 0, 0, nMW, 0 ]
  masses2_26 = [ nMW, 0, 0, nMW, 0 ]
  masses2_27 = [ 0, 0, 0, nMW, nMW ]
  masses2_28 = [ 0, 0, nMW, 0, 0 ]
  masses2_29 = [ 0, 0, nMW, 0, nMW ]
  masses2_30 = [ 0, 0, nMW, nMW, 0 ]
  masses2_31 = [ 0, nMW, 0, 0, 0 ]
  masses2_32 = [ 0, nMW, 0, nMW, 0 ]
  masses2_33 = [ 0, nMW, nMW, 0, 0 ]
  masses2_34 = [ 0, 0, 0, nMW, 0, nMW ]
  masses2_35 = [ 0, 0, nMW, 0, nMW, 0 ]
  masses2_36 = [ 0, nMW, 0, nMW, 0, 0 ]


end subroutine  set_integral_masses_and_momenta

! **********************************************************************
subroutine integrate_tensor_sum(M2out)
! **********************************************************************
  use ol_parameters_decl_/**/REALKIND ! only: ZERO, masses
#ifndef PRECISION_dp
  use ol_parameters_decl_/**/DREALKIND, only: a_switch
#endif
  use ol_parameters_init_/**/REALKIND, only: init_met, add_met, met_to_real
  use ol_loop_routines_/**/REALKIND, only: TI_call_OL
  implicit none
  real(REALKIND), intent(out) :: M2out
  type(met) :: M2
  call init_met(M2)

sbarray_1 = [1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15]
sbarray_2 = [16, 17, 18, 19, 20, 21, 22, 23, 24, 25, 26, 27, 28, 29, 5]
sbarray_3 = [30, 31, 32, 33, 34, 35, 36, 37, 38, 39, 40, 41, 42, 43, 44]
sbarray_4 = [45, 46, 18, 47, 48, 49, 22, 50, 51, 25, 52, 53, 28, 29, 54]
sbarray_5 = [1, 2, 3, 4, 5]
sbarray_6 = [55, 56, 57, 58, 44]
sbarray_7 = [59, 60, 61, 4, 54]
sbarray_8 = [62, 63, 64, 65, 15]
sbarray_9 = [1, 6, 7, 8, 9]
sbarray_10 = [2, 6, 10, 11, 12]
sbarray_11 = [3, 7, 10, 13, 14]
sbarray_12 = [16, 17, 18, 19, 20]
sbarray_13 = [16, 21, 22, 23, 24]
sbarray_14 = [17, 21, 25, 26, 27]
sbarray_15 = [18, 22, 25, 28, 29]
sbarray_16 = [30, 31, 32, 33, 34]
sbarray_17 = [30, 35, 36, 37, 38]
sbarray_18 = [31, 35, 39, 40, 41]
sbarray_19 = [32, 36, 39, 42, 43]
sbarray_20 = [45, 46, 18, 47, 48]
sbarray_21 = [45, 49, 22, 50, 51]
sbarray_22 = [46, 49, 25, 52, 53]
sbarray_23 = [66, 67, 68, 69, 70]
sbarray_24 = [71, 6, 72, 73, 74]
sbarray_25 = [75, 76, 77, 78, 79]
sbarray_26 = [80, 81, 10, 82, 83]
sbarray_27 = [84, 85, 86, 69, 87]
sbarray_28 = [88, 89, 90, 73, 91]
sbarray_29 = [92, 93, 39, 94, 95]
sbarray_30 = [96, 21, 97, 98, 99]


#ifdef LOOPSQUARED
  if (a_switch == 1 .or. a_switch == 7) then
#endif
  call TI_call_OL(0,0, momenta_103, masses2_18, T0sum(1), M2,[11], ScalarBoxes(:))
  call TI_call_OL(0,0, momenta_92, masses2_13, T0sum(2), M2,[69], ScalarBoxes(:))
  call TI_call_OL(0,0, momenta_92, masses2_14, T0sum(3), M2,[73], ScalarBoxes(:))
  call TI_call_OL(0,0, momenta_104, masses2_13, T0sum(4), M2,[78], ScalarBoxes(:))
  call TI_call_OL(0,0, momenta_104, masses2_16, T0sum(5), M2,[82], ScalarBoxes(:))
  call TI_call_OL(0,0, momenta_132, masses2_22, T0sum(6), M2,[2], ScalarBoxes(:))
  call TI_call_OL(0,0, momenta_91, masses2_22, T0sum(7), M2,[23], ScalarBoxes(:))
  call TI_call_OL(0,0, momenta_135, masses2_15, T0sum(8), M2,[58], ScalarBoxes(:))
  call TI_call_OL(0,0, momenta_98, masses2_14, T0sum(9), M2,[42], ScalarBoxes(:))
  call TI_call_OL(0,0, momenta_133, masses2_22, T0sum(10), M2,[60], ScalarBoxes(:))
  call TI_call_OL(0,0, momenta_94, masses2_22, T0sum(11), M2,[50], ScalarBoxes(:))
  call TI_call_OL(0,0, momenta_134, masses2_13, T0sum(12), M2,[75], ScalarBoxes(:))
  call TI_call_OL(0,0, momenta_97, masses2_12, T0sum(13), M2,[94], ScalarBoxes(:))
  call TI_call_OL(0,0, momenta_134, masses2_19, T0sum(14), M2,[80], ScalarBoxes(:))
  call TI_call_OL(0,0, momenta_97, masses2_19, T0sum(15), M2,[98], ScalarBoxes(:))
  call TI_call_OL(0,0, momenta_150, masses2_21, T0sum(16), M2,[62], ScalarBoxes(:))
  call TI_call_OL(0,0, momenta_138, masses2_16, T0sum(17), M2,[1], ScalarBoxes(:))
  call TI_call_OL(0,0, momenta_130, masses2_19, T0sum(18), M2,[3], ScalarBoxes(:))
  call TI_call_OL(0,0, momenta_129, masses2_21, T0sum(19), M2,[4], ScalarBoxes(:))
  call TI_call_OL(0,0, momenta_140, masses2_14, T0sum(20), M2,[44], ScalarBoxes(:))
  call TI_call_OL(0,0, momenta_142, masses2_17, T0sum(21), M2,[55], ScalarBoxes(:))
  call TI_call_OL(0,0, momenta_137, masses2_17, T0sum(22), M2,[56], ScalarBoxes(:))
  call TI_call_OL(0,0, momenta_136, masses2_13, T0sum(23), M2,[57], ScalarBoxes(:))
  call TI_call_OL(0,0, momenta_141, masses2_21, T0sum(24), M2,[54], ScalarBoxes(:))
  call TI_call_OL(0,0, momenta_139, masses2_16, T0sum(25), M2,[59], ScalarBoxes(:))
  call TI_call_OL(0,0, momenta_131, masses2_19, T0sum(26), M2,[61], ScalarBoxes(:))
  call TI_call_OL(0,0, momenta_149, masses2_17, T0sum(27), M2,[15], ScalarBoxes(:))
  call TI_call_OL(0,0, momenta_147, masses2_14, T0sum(28), M2,[63], ScalarBoxes(:))
  call TI_call_OL(0,0, momenta_145, masses2_18, T0sum(29), M2,[64], ScalarBoxes(:))
  call TI_call_OL(0,0, momenta_144, masses2_16, T0sum(30), M2,[65], ScalarBoxes(:))
  call TI_call_OL(0,0, momenta_108, masses2_16, T0sum(31), M2,[6], ScalarBoxes(:))
  call TI_call_OL(0,0, momenta_107, masses2_12, T0sum(32), M2,[7], ScalarBoxes(:))
  call TI_call_OL(0,0, momenta_106, masses2_14, T0sum(33), M2,[8], ScalarBoxes(:))
  call TI_call_OL(0,0, momenta_105, masses2_16, T0sum(34), M2,[10], ScalarBoxes(:))
  call TI_call_OL(0,0, momenta_102, masses2_16, T0sum(35), M2,[13], ScalarBoxes(:))
  call TI_call_OL(0,0, momenta_120, masses2_19, T0sum(36), M2,[16], ScalarBoxes(:))
  call TI_call_OL(0,0, momenta_118, masses2_12, T0sum(37), M2,[17], ScalarBoxes(:))
  call TI_call_OL(0,0, momenta_117, masses2_16, T0sum(38), M2,[18], ScalarBoxes(:))
  call TI_call_OL(0,0, momenta_115, masses2_16, T0sum(39), M2,[19], ScalarBoxes(:))
  call TI_call_OL(0,0, momenta_101, masses2_19, T0sum(40), M2,[21], ScalarBoxes(:))
  call TI_call_OL(0,0, momenta_95, masses2_22, T0sum(41), M2,[22], ScalarBoxes(:))
  call TI_call_OL(0,0, momenta_90, masses2_19, T0sum(42), M2,[25], ScalarBoxes(:))
  call TI_call_OL(0,0, momenta_88, masses2_19, T0sum(43), M2,[26], ScalarBoxes(:))
  call TI_call_OL(0,0, momenta_87, masses2_21, T0sum(44), M2,[28], ScalarBoxes(:))
  call TI_call_OL(0,0, momenta_148, masses2_21, T0sum(45), M2,[30], ScalarBoxes(:))
  call TI_call_OL(0,0, momenta_128, masses2_14, T0sum(46), M2,[31], ScalarBoxes(:))
  call TI_call_OL(0,0, momenta_127, masses2_18, T0sum(47), M2,[32], ScalarBoxes(:))
  call TI_call_OL(0,0, momenta_126, masses2_16, T0sum(48), M2,[33], ScalarBoxes(:))
  call TI_call_OL(0,0, momenta_114, masses2_14, T0sum(49), M2,[35], ScalarBoxes(:))
  call TI_call_OL(0,0, momenta_113, masses2_18, T0sum(50), M2,[36], ScalarBoxes(:))
  call TI_call_OL(0,0, momenta_112, masses2_16, T0sum(51), M2,[37], ScalarBoxes(:))
  call TI_call_OL(0,0, momenta_100, masses2_14, T0sum(52), M2,[39], ScalarBoxes(:))
  call TI_call_OL(0,0, momenta_99, masses2_12, T0sum(53), M2,[40], ScalarBoxes(:))
  call TI_call_OL(0,0, momenta_123, masses2_19, T0sum(54), M2,[45], ScalarBoxes(:))
  call TI_call_OL(0,0, momenta_119, masses2_12, T0sum(55), M2,[46], ScalarBoxes(:))
  call TI_call_OL(0,0, momenta_116, masses2_16, T0sum(56), M2,[47], ScalarBoxes(:))
  call TI_call_OL(0,0, momenta_111, masses2_19, T0sum(57), M2,[49], ScalarBoxes(:))
  call TI_call_OL(0,0, momenta_89, masses2_19, T0sum(58), M2,[52], ScalarBoxes(:))
  call TI_call_OL(0,0, momenta_143, masses2_12, T0sum(59), M2,[70], ScalarBoxes(:))
  call TI_call_OL(0,0, momenta_121, masses2_13, T0sum(60), M2,[66], ScalarBoxes(:))
  call TI_call_OL(0,0, momenta_108, masses2_13, T0sum(61), M2,[67], ScalarBoxes(:))
  call TI_call_OL(0,0, momenta_93, masses2_13, T0sum(62), M2,[68], ScalarBoxes(:))
  call TI_call_OL(0,0, momenta_143, masses2_14, T0sum(63), M2,[74], ScalarBoxes(:))
  call TI_call_OL(0,0, momenta_121, masses2_16, T0sum(64), M2,[71], ScalarBoxes(:))
  call TI_call_OL(0,0, momenta_93, masses2_12, T0sum(65), M2,[72], ScalarBoxes(:))
  call TI_call_OL(0,0, momenta_146, masses2_12, T0sum(66), M2,[79], ScalarBoxes(:))
  call TI_call_OL(0,0, momenta_110, masses2_13, T0sum(67), M2,[76], ScalarBoxes(:))
  call TI_call_OL(0,0, momenta_105, masses2_13, T0sum(68), M2,[77], ScalarBoxes(:))
  call TI_call_OL(0,0, momenta_146, masses2_16, T0sum(69), M2,[83], ScalarBoxes(:))
  call TI_call_OL(0,0, momenta_110, masses2_12, T0sum(70), M2,[81], ScalarBoxes(:))
  call TI_call_OL(0,0, momenta_124, masses2_12, T0sum(71), M2,[87], ScalarBoxes(:))
  call TI_call_OL(0,0, momenta_122, masses2_13, T0sum(72), M2,[84], ScalarBoxes(:))
  call TI_call_OL(0,0, momenta_109, masses2_13, T0sum(73), M2,[85], ScalarBoxes(:))
  call TI_call_OL(0,0, momenta_96, masses2_13, T0sum(74), M2,[86], ScalarBoxes(:))
  call TI_call_OL(0,0, momenta_124, masses2_14, T0sum(75), M2,[91], ScalarBoxes(:))
  call TI_call_OL(0,0, momenta_122, masses2_16, T0sum(76), M2,[88], ScalarBoxes(:))
  call TI_call_OL(0,0, momenta_109, masses2_16, T0sum(77), M2,[89], ScalarBoxes(:))
  call TI_call_OL(0,0, momenta_96, masses2_12, T0sum(78), M2,[90], ScalarBoxes(:))
  call TI_call_OL(0,0, momenta_125, masses2_14, T0sum(79), M2,[92], ScalarBoxes(:))
  call TI_call_OL(0,0, momenta_101, masses2_14, T0sum(80), M2,[93], ScalarBoxes(:))
  call TI_call_OL(0,0, momenta_125, masses2_12, T0sum(81), M2,[96], ScalarBoxes(:))
  call TI_call_OL(0,0, momenta_100, masses2_19, T0sum(82), M2,[97], ScalarBoxes(:))
  call TI_call_OL(0,0, momenta_98, masses2_19, T0sum(83), M2,[85], ScalarBoxes(:))
  call TI_call_OL(0,0, momenta_120, masses2_14, T0sum(84), M2,[88], ScalarBoxes(:))
  call TI_call_OL(0,0, momenta_95, masses2_12, T0sum(85), M2)
  call TI_call_OL(0,0, momenta_103, masses2_12, T0sum(86), M2)
  call TI_call_OL(0,0, momenta_132, masses2_12, T0sum(87), M2)
  call TI_call_OL(0,0, momenta_133, masses2_12, T0sum(88), M2)
  call TI_call_OL(0,0, momenta_18, masses2_5, T0sum(89), M2)
  call TI_call_OL(0,0, momenta_77, masses2_5, T0sum(90), M2)
  call TI_call_OL(0,0, momenta_21, masses2_5, T0sum(91), M2)
  call TI_call_OL(0,0, momenta_82, masses2_5, T0sum(92), M2)
  call TI_call_OL(0,0, momenta_49, masses2_5, T0sum(93), M2)
  call TI_call_OL(0,0, momenta_63, masses2_5, T0sum(94), M2)
  call TI_call_OL(0,0, momenta_77, masses2_8, T0sum(95), M2)
  call TI_call_OL(0,0, momenta_49, masses2_11, T0sum(96), M2)
  call TI_call_OL(0,0, momenta_23, masses2_7, T0sum(97), M2)
  call TI_call_OL(0,0, momenta_21, masses2_7, T0sum(98), M2)
  call TI_call_OL(0,0, momenta_76, masses2_5, T0sum(99), M2)
  call TI_call_OL(0,0, momenta_36, masses2_6, T0sum(100), M2)
  call TI_call_OL(0,0, momenta_23, masses2_6, T0sum(101), M2)
  call TI_call_OL(0,0, momenta_18, masses2_6, T0sum(102), M2)
  call TI_call_OL(0,0, momenta_76, masses2_6, T0sum(103), M2)
  call TI_call_OL(0,0, momenta_36, masses2_7, T0sum(104), M2)
  call TI_call_OL(0,0, momenta_74, masses2_5, T0sum(105), M2)
  call TI_call_OL(0,0, momenta_50, masses2_6, T0sum(106), M2)
  call TI_call_OL(0,0, momenta_24, masses2_6, T0sum(107), M2)
  call TI_call_OL(0,0, momenta_21, masses2_6, T0sum(108), M2)
  call TI_call_OL(0,0, momenta_74, masses2_7, T0sum(109), M2)
  call TI_call_OL(0,0, momenta_50, masses2_9, T0sum(110), M2)
  call TI_call_OL(0,0, momenta_24, masses2_5, T0sum(111), M2)
  call TI_call_OL(0,0, momenta_82, masses2_11, T0sum(112), M2)
  call TI_call_OL(0,0, momenta_60, masses2_9, T0sum(113), M2)
  call TI_call_OL(0,0, momenta_51, masses2_9, T0sum(114), M2)
  call TI_call_OL(0,0, momenta_35, masses2_9, T0sum(115), M2)
  call TI_call_OL(0,0, momenta_20, masses2_9, T0sum(116), M2)
  call TI_call_OL(0,0, momenta_18, masses2_11, T0sum(117), M2)
  call TI_call_OL(0,0, momenta_60, masses2_6, T0sum(118), M2)
  call TI_call_OL(0,0, momenta_64, masses2_8, T0sum(119), M2)
  call TI_call_OL(0,0, momenta_53, masses2_8, T0sum(120), M2)
  call TI_call_OL(0,0, momenta_43, masses2_7, T0sum(121), M2)
  call TI_call_OL(0,0, momenta_27, masses2_7, T0sum(122), M2)
  call TI_call_OL(0,0, momenta_19, masses2_5, T0sum(123), M2)
  call TI_call_OL(0,0, momenta_63, masses2_11, T0sum(124), M2)
  call TI_call_OL(0,0, momenta_61, masses2_9, T0sum(125), M2)
  call TI_call_OL(0,0, momenta_52, masses2_9, T0sum(126), M2)
  call TI_call_OL(0,0, momenta_38, masses2_9, T0sum(127), M2)
  call TI_call_OL(0,0, momenta_26, masses2_9, T0sum(128), M2)
  call TI_call_OL(0,0, momenta_83, masses2_5, T0sum(129), M2)
  call TI_call_OL(0,0, momenta_63, masses2_6, T0sum(130), M2)
  call TI_call_OL(0,0, momenta_51, masses2_6, T0sum(131), M2)
  call TI_call_OL(0,0, momenta_41, masses2_5, T0sum(132), M2)
  call TI_call_OL(0,0, momenta_20, masses2_5, T0sum(133), M2)
  call TI_call_OL(0,0, momenta_83, masses2_9, T0sum(134), M2)
  call TI_call_OL(0,0, momenta_19, masses2_9, T0sum(135), M2)
  call TI_call_OL(0,0, momenta_71, masses2_7, T0sum(136), M2)
  call TI_call_OL(0,0, momenta_69, masses2_7, T0sum(137), M2)
  call TI_call_OL(0,0, momenta_25, masses2_5, T0sum(138), M2)
  call TI_call_OL(0,0, momenta_47, masses2_5, T0sum(139), M2)
  call TI_call_OL(0,0, momenta_39, masses2_9, T0sum(140), M2)
  call TI_call_OL(0,0, momenta_29, masses2_9, T0sum(141), M2)
  call TI_call_OL(0,0, momenta_76, masses2_11, T0sum(142), M2)
  call TI_call_OL(0,0, momenta_45, masses2_7, T0sum(143), M2)
  call TI_call_OL(0,0, momenta_29, masses2_7, T0sum(144), M2)
  call TI_call_OL(0,0, momenta_73, masses2_5, T0sum(145), M2)
  call TI_call_OL(0,0, momenta_71, masses2_5, T0sum(146), M2)
  call TI_call_OL(0,0, momenta_68, masses2_5, T0sum(147), M2)
  call TI_call_OL(0,0, momenta_37, masses2_6, T0sum(148), M2)
  call TI_call_OL(0,0, momenta_25, masses2_6, T0sum(149), M2)
  call TI_call_OL(0,0, momenta_37, masses2_5, T0sum(150), M2)
  call TI_call_OL(0,0, momenta_72, masses2_5, T0sum(151), M2)
  call TI_call_OL(0,0, momenta_69, masses2_5, T0sum(152), M2)
  call TI_call_OL(0,0, momenta_46, masses2_5, T0sum(153), M2)
  call TI_call_OL(0,0, momenta_42, masses2_5, T0sum(154), M2)
  call TI_call_OL(0,0, momenta_61, masses2_6, T0sum(155), M2)
  call TI_call_OL(0,0, momenta_40, masses2_6, T0sum(156), M2)
  call TI_call_OL(0,0, momenta_30, masses2_6, T0sum(157), M2)
  call TI_call_OL(0,0, momenta_46, masses2_7, T0sum(158), M2)
  call TI_call_OL(0,0, momenta_42, masses2_7, T0sum(159), M2)
  call TI_call_OL(0,0, momenta_40, masses2_5, T0sum(160), M2)
  call TI_call_OL(0,0, momenta_30, masses2_5, T0sum(161), M2)
  call TI_call_OL(0,0, momenta_47, masses2_7, T0sum(162), M2)
  call TI_call_OL(0,0, momenta_45, masses2_5, T0sum(163), M2)
  call TI_call_OL(0,0, momenta_43, masses2_5, T0sum(164), M2)
  call TI_call_OL(0,0, momenta_27, masses2_9, T0sum(165), M2)
  call TI_call_OL(0,0, momenta_39, masses2_7, T0sum(166), M2)
  call TI_call_OL(0,0, momenta_35, masses2_5, T0sum(167), M2)
  call TI_call_OL(0,0, momenta_39, masses2_5, T0sum(168), M2)
  call TI_call_OL(0,0, momenta_29, masses2_5, T0sum(169), M2)
  call TI_call_OL(0,0, momenta_23, masses2_5, T0sum(170), M2)
  call TI_call_OL(0,0, momenta_60, masses2_5, T0sum(171), M2)
  call TI_call_OL(0,0, momenta_51, masses2_5, T0sum(172), M2)
  call TI_call_OL(0,0, momenta_61, masses2_5, T0sum(173), M2)
  call TI_call_OL(0,0, momenta_52, masses2_5, T0sum(174), M2)
  call TI_call_OL(0,0, momenta_86, masses2_10, T0sum(175), M2)
  call TI_call_OL(0,0, momenta_84, masses2_7, T0sum(176), M2)
  call TI_call_OL(0,0, momenta_81, masses2_9, T0sum(177), M2)
  call TI_call_OL(0,0, momenta_57, masses2_5, T0sum(178), M2)
  call TI_call_OL(0,0, momenta_55, masses2_7, T0sum(179), M2)
  call TI_call_OL(0,0, momenta_48, masses2_9, T0sum(180), M2)
  call TI_call_OL(0,0, momenta_67, masses2_7, T0sum(181), M2)
  call TI_call_OL(0,0, momenta_59, masses2_7, T0sum(182), M2)
  call TI_call_OL(0,0, momenta_56, masses2_5, T0sum(183), M2)
  call TI_call_OL(0,0, momenta_85, masses2_10, T0sum(184), M2)
  call TI_call_OL(0,0, momenta_65, masses2_6, T0sum(185), M2)
  call TI_call_OL(0,0, momenta_54, masses2_6, T0sum(186), M2)
  call TI_call_OL(0,0, momenta_66, masses2_7, T0sum(187), M2)
  call TI_call_OL(0,0, momenta_62, masses2_9, T0sum(188), M2)
  call TI_call_OL(0,0, momenta_58, masses2_5, T0sum(189), M2)
  call TI_call_OL(0,0, momenta_80, masses2_7, T0sum(190), M2)
  call TI_call_OL(0,0, momenta_78, masses2_6, T0sum(191), M2)
  call TI_call_OL(0,0, momenta_70, masses2_5, T0sum(192), M2)
  call TI_call_OL(0,0, momenta_22, masses2_5, T0sum(193), M2)
  call TI_call_OL(0,0, momenta_34, masses2_5, T0sum(194), M2)
  call TI_call_OL(0,0, momenta_32, masses2_5, T0sum(195), M2)
  call TI_call_OL(0,0, momenta_31, masses2_7, T0sum(196), M2)
  call TI_call_OL(0,0, momenta_17, masses2_9, T0sum(197), M2)
  call TI_call_OL(0,0, momenta_79, masses2_7, T0sum(198), M2)
  call TI_call_OL(0,0, momenta_75, masses2_9, T0sum(199), M2)
  call TI_call_OL(0,0, momenta_44, masses2_5, T0sum(200), M2)
  call TI_call_OL(0,0, momenta_28, masses2_5, T0sum(201), M2)
  call TI_call_OL(0,0, momenta_33, masses2_5, T0sum(202), M2)
  call TI_call_OL(0,0, momenta_36, masses2_5, T0sum(203), M2)
  call TI_call_OL(0,0, momenta_50, masses2_5, T0sum(204), M2)
  call TI_call_OL(0,0, momenta_16, masses2_1, T0sum(205), M2)
  call TI_call_OL(0,0, momenta_3, masses2_1, T0sum(206), M2)
  call TI_call_OL(0,0, momenta_2, masses2_1, T0sum(207), M2)
  call TI_call_OL(0,0, momenta_13, masses2_1, T0sum(208), M2)
  call TI_call_OL(0,0, momenta_12, masses2_1, T0sum(209), M2)
  call TI_call_OL(0,0, momenta_6, masses2_1, T0sum(210), M2)
  call TI_call_OL(0,0, momenta_15, masses2_1, T0sum(211), M2)
  call TI_call_OL(0,0, momenta_14, masses2_1, T0sum(212), M2)
  call TI_call_OL(0,0, momenta_7, masses2_1, T0sum(213), M2)
  call TI_call_OL(0,0, momenta_9, masses2_1, T0sum(214), M2)
  call TI_call_OL(0,0, momenta_8, masses2_1, T0sum(215), M2)
  call TI_call_OL(0,0, momenta_13, masses2_2, T0sum(216), M2)
  call TI_call_OL(0,0, momenta_16, masses2_4, T0sum(217), M2)
  call TI_call_OL(0,0, momenta_12, masses2_2, T0sum(218), M2)
  call TI_call_OL(0,0, momenta_1, masses2_2, T0sum(219), M2)
  call TI_call_OL(0,0, momenta_7, masses2_3, T0sum(220), M2)
  call TI_call_OL(0,0, momenta_6, masses2_3, T0sum(221), M2)
  call TI_call_OL(0,0, momenta_7, masses2_2, T0sum(222), M2)
  call TI_call_OL(0,0, momenta_3, masses2_2, T0sum(223), M2)
  call TI_call_OL(0,0, momenta_2, masses2_2, T0sum(224), M2)
  call TI_call_OL(0,0, momenta_11, masses2_1, T0sum(225), M2)
  call TI_call_OL(0,0, momenta_8, masses2_2, T0sum(226), M2)
  call TI_call_OL(0,0, momenta_6, masses2_2, T0sum(227), M2)
  call TI_call_OL(0,0, momenta_15, masses2_3, T0sum(228), M2)
  call TI_call_OL(0,0, momenta_14, masses2_3, T0sum(229), M2)
  call TI_call_OL(0,0, momenta_5, masses2_1, T0sum(230), M2)
  call TI_call_OL(0,0, momenta_3, masses2_3, T0sum(231), M2)
  call TI_call_OL(0,0, momenta_2, masses2_3, T0sum(232), M2)
  call TI_call_OL(0,0, momenta_9, masses2_2, T0sum(233), M2)
  call TI_call_OL(0,0, momenta_12, masses2_3, T0sum(234), M2)
  call TI_call_OL(0,0, momenta_4, masses2_1, T0sum(235), M2)
  call TI_call_OL(0,0, momenta_9, masses2_3, T0sum(236), M2)
  call TI_call_OL(0,0, momenta_8, masses2_3, T0sum(237), M2)
  call TI_call_OL(0,0, momenta_10, masses2_1, T0sum(238), M2)
  call TI_call_OL(0,0, momenta_13, masses2_3, T0sum(239), M2)
  call TI_call_OL(0,0, momenta_15, masses2_2, T0sum(240), M2)

  call TI_call_OL(0,1, momenta_176, masses2_35, T1sum(1), M2,sbarray_1, ScalarBoxes(:))
  call TI_call_OL(0,1, momenta_173, masses2_36, T1sum(2), M2,sbarray_2, ScalarBoxes(:))
  call TI_call_OL(0,1, momenta_175, masses2_34, T1sum(3), M2,sbarray_3, ScalarBoxes(:))
  call TI_call_OL(0,1, momenta_174, masses2_36, T1sum(4), M2,sbarray_4, ScalarBoxes(:))
  call TI_call_OL(0,1, momenta_169, masses2_32, T1sum(5), M2,sbarray_5, ScalarBoxes(:))
  call TI_call_OL(0,1, momenta_171, masses2_26, T1sum(6), M2,sbarray_6, ScalarBoxes(:))
  call TI_call_OL(0,1, momenta_170, masses2_32, T1sum(7), M2,sbarray_7, ScalarBoxes(:))
  call TI_call_OL(0,1, momenta_172, masses2_29, T1sum(8), M2,sbarray_8, ScalarBoxes(:))
  call TI_call_OL(0,1, momenta_164, masses2_25, T1sum(9), M2,sbarray_9, ScalarBoxes(:))
  call TI_call_OL(0,1, momenta_162, masses2_30, T1sum(10), M2,sbarray_10, ScalarBoxes(:))
  call TI_call_OL(0,1, momenta_161, masses2_28, T1sum(11), M2,sbarray_11, ScalarBoxes(:))
  call TI_call_OL(0,1, momenta_166, masses2_28, T1sum(12), M2,sbarray_12, ScalarBoxes(:))
  call TI_call_OL(0,1, momenta_154, masses2_33, T1sum(13), M2,sbarray_13, ScalarBoxes(:))
  call TI_call_OL(0,1, momenta_152, masses2_31, T1sum(14), M2,sbarray_14, ScalarBoxes(:))
  call TI_call_OL(0,1, momenta_151, masses2_32, T1sum(15), M2,sbarray_15, ScalarBoxes(:))
  call TI_call_OL(0,1, momenta_168, masses2_29, T1sum(16), M2,sbarray_16, ScalarBoxes(:))
  call TI_call_OL(0,1, momenta_165, masses2_29, T1sum(17), M2,sbarray_17, ScalarBoxes(:))
  call TI_call_OL(0,1, momenta_160, masses2_24, T1sum(18), M2,sbarray_18, ScalarBoxes(:))
  call TI_call_OL(0,1, momenta_159, masses2_27, T1sum(19), M2,sbarray_19, ScalarBoxes(:))
  call TI_call_OL(0,1, momenta_167, masses2_28, T1sum(20), M2,sbarray_20, ScalarBoxes(:))
  call TI_call_OL(0,1, momenta_157, masses2_33, T1sum(21), M2,sbarray_21, ScalarBoxes(:))
  call TI_call_OL(0,1, momenta_153, masses2_31, T1sum(22), M2,sbarray_22, ScalarBoxes(:))
  call TI_call_OL(0,1, momenta_155, masses2_23, T1sum(23), M2,sbarray_23, ScalarBoxes(:))
  call TI_call_OL(0,1, momenta_155, masses2_25, T1sum(24), M2,sbarray_24, ScalarBoxes(:))
  call TI_call_OL(0,1, momenta_163, masses2_23, T1sum(25), M2,sbarray_25, ScalarBoxes(:))
  call TI_call_OL(0,1, momenta_163, masses2_28, T1sum(26), M2,sbarray_26, ScalarBoxes(:))
  call TI_call_OL(0,1, momenta_156, masses2_23, T1sum(27), M2,sbarray_27, ScalarBoxes(:))
  call TI_call_OL(0,1, momenta_156, masses2_25, T1sum(28), M2,sbarray_28, ScalarBoxes(:))
  call TI_call_OL(0,1, momenta_158, masses2_24, T1sum(29), M2,sbarray_29, ScalarBoxes(:))
  call TI_call_OL(0,1, momenta_158, masses2_31, T1sum(30), M2,sbarray_30, ScalarBoxes(:))

  call add_met(M2,M2L1R1)

#ifdef LOOPSQUARED
  end if
#endif

  call met_to_real(M2out,M2)

#ifdef PRECISION_dp
  call HOL_memory_deallocation_/**/REALKIND(1)
  call HCL_memory_deallocation_/**/REALKIND(1)
#endif

end subroutine integrate_tensor_sum

end module ol_tensor_sum_storage_ppnnjj_ew_nenexuxcdsx_1_/**/REALKIND
