
! **********************************************************************
module ol_tables_storage_ppnnjj_ew_nenexuuxgg_1_/**/REALKIND
! **********************************************************************
  use KIND_TYPES, only: REALKIND, QREALKIND, intkind2
  use ol_data_types_/**/REALKIND, only: hol
  use ol_data_types_/**/REALKIND, only: basis, redset4, redset5
 use ol_data_types_/**/REALKIND, only: scalarbox 

  implicit none

  ! helicity tables for the 1-loop recursion
integer(intkind2), save :: h0tab(64,600)
integer(intkind2), save :: heltab2x2(2,2,551)
integer(intkind2), save :: heltab2x4(2,4,402)
integer(intkind2), save :: heltab2x8(2,8,354)
integer(intkind2), save :: heltab2x16(2,16,108)
integer(intkind2), save :: heltab2x32(2,32,172)
integer(intkind2), save :: heltab2x64(2,64,600)


  ! number of helicity states for openloops recursion steps
integer(intkind2), save :: m0h(600)
integer(intkind2), save :: m3h2x1(3,551)
integer(intkind2), save :: m3h4x1(3,240)
integer(intkind2), save :: m3h8x1(3,12)
integer(intkind2), save :: m3h16x1(3,24)
integer(intkind2), save :: m3h2x2(3,162)
integer(intkind2), save :: m3h4x2(3,163)
integer(intkind2), save :: m3h8x2(3,15)
integer(intkind2), save :: m3h16x2(3,48)
integer(intkind2), save :: m3h2x4(3,179)
integer(intkind2), save :: m3h4x4(3,26)
integer(intkind2), save :: m3h8x4(3,12)
integer(intkind2), save :: m3h16x4(3,296)
integer(intkind2), save :: m3h2x8(3,43)
integer(intkind2), save :: m3h4x8(3,72)
integer(intkind2), save :: m3h8x8(3,60)
integer(intkind2), save :: m3h2x16(3,40)
integer(intkind2), save :: m3h4x16(3,68)
integer(intkind2), save :: m3h2x32(3,176)

integer(intkind2), save :: n2h1(772)
integer(intkind2), save :: n2h2(295)
integer(intkind2), save :: n2h4(303)
integer(intkind2), save :: n2h8(189)
integer(intkind2), save :: n2h16(28)
integer(intkind2), save :: n2h32(176)


contains

!**********************************************************************
subroutine HOL_m3_init()
!**********************************************************************
! initialize m3 arrays for helicity summation
!**********************************************************************
  use KIND_TYPES, only: REALKIND, intkind2

m3h2x1(1,:)=2
m3h2x1(2,:)=1
m3h2x1(3,:)=2
m3h4x1(1,:)=4
m3h4x1(2,:)=1
m3h4x1(3,:)=4
m3h8x1(1,:)=8
m3h8x1(2,:)=1
m3h8x1(3,:)=8
m3h16x1(1,:)=16
m3h16x1(2,:)=1
m3h16x1(3,:)=16
m3h2x2(1,:)=2
m3h2x2(2,:)=2
m3h2x2(3,:)=4
m3h4x2(1,:)=4
m3h4x2(2,:)=2
m3h4x2(3,:)=8
m3h8x2(1,:)=8
m3h8x2(2,:)=2
m3h8x2(3,:)=16
m3h16x2(1,:)=16
m3h16x2(2,:)=2
m3h16x2(3,:)=32
m3h2x4(1,:)=2
m3h2x4(2,:)=4
m3h2x4(3,:)=8
m3h4x4(1,:)=4
m3h4x4(2,:)=4
m3h4x4(3,:)=16
m3h8x4(1,:)=8
m3h8x4(2,:)=4
m3h8x4(3,:)=32
m3h16x4(1,:)=16
m3h16x4(2,:)=4
m3h16x4(3,:)=64
m3h2x8(1,:)=2
m3h2x8(2,:)=8
m3h2x8(3,:)=16
m3h4x8(1,:)=4
m3h4x8(2,:)=8
m3h4x8(3,:)=32
m3h8x8(1,:)=8
m3h8x8(2,:)=8
m3h8x8(3,:)=64
m3h2x16(1,:)=2
m3h2x16(2,:)=16
m3h2x16(3,:)=32
m3h4x16(1,:)=4
m3h4x16(2,:)=16
m3h4x16(3,:)=64
m3h2x32(1,:)=2
m3h2x32(2,:)=32
m3h2x32(3,:)=64

n2h1(:)=1
n2h2(:)=2
n2h4(:)=4
n2h8(:)=8
n2h16(:)=16
n2h32(:)=32


end subroutine HOL_m3_init

!**********************************************************************

end module ol_tables_storage_ppnnjj_ew_nenexuuxgg_1_/**/REALKIND

! **********************************************************************
module ol_tensor_sum_storage_ppnnjj_ew_nenexuuxgg_1_/**/REALKIND
! **********************************************************************
  use KIND_TYPES, only: REALKIND, QREALKIND, intkind2
  use ol_data_types_/**/REALKIND, only: hol, hcl, met
  use ol_data_types_/**/REALKIND, only: basis, redset4, redset5
 use ol_data_types_/**/REALKIND, only: scalarbox 

  implicit none

  type(met), save :: M2L1R1

  ! Declarations of loop wave function tensors

  type(hol), save :: G0H1(1)
  type(hol), save :: G1H1(1)
  type(hol), save :: G2H1(1)
  type(hol), save :: G0H2(1)
  type(hol), save :: G1H2(376)
  type(hol), save :: G2H2(177)
  type(hol), save :: G0H4(40)
  type(hol), save :: G1H4(204)
  type(hol), save :: G2H4(78)
  type(hol), save :: G0H8(36)
  type(hol), save :: G1H8(187)
  type(hol), save :: G2H8(60)
  type(hol), save :: G0H16(14)
  type(hol), save :: G1H16(17)
  type(hol), save :: G0H32(1)
  type(hol), save :: G1H32(74)
  type(hol), save :: G0H64(1)
  type(hcl), save, dimension(892) :: G0tensor
  type(hcl), save, dimension(791) :: G1tensor
  type(hcl), save, dimension(528) :: G2tensor
  type(hcl), save, dimension(94) :: G3tensor



  ! Declarations for on-the-fly tensor reduction
type (basis),      save :: RedBasis(114)
type (redset4),    save :: RedSet_4(97)
type (redset5),    save :: RedSet_5(28)
integer, save :: mass2set(0:1,11)
integer, save :: mass3set(0:2,15)
integer, save :: mass4set(0:3,19)
integer, save :: mass5set(0:4,13)



  ! Declarations for TI calls

  integer, save :: momenta_1(2)
  integer, save :: momenta_2(2)
  integer, save :: momenta_3(2)
  integer, save :: momenta_4(2)
  integer, save :: momenta_5(2)
  integer, save :: momenta_6(2)
  integer, save :: momenta_7(2)
  integer, save :: momenta_8(2)
  integer, save :: momenta_9(2)
  integer, save :: momenta_10(2)
  integer, save :: momenta_11(2)
  integer, save :: momenta_12(2)
  integer, save :: momenta_13(2)
  integer, save :: momenta_14(2)
  integer, save :: momenta_15(2)
  integer, save :: momenta_16(2)
  integer, save :: momenta_17(2)
  integer, save :: momenta_18(2)
  integer, save :: momenta_19(2)
  integer, save :: momenta_20(2)
  integer, save :: momenta_21(2)
  integer, save :: momenta_22(2)
  integer, save :: momenta_23(2)
  integer, save :: momenta_24(2)
  integer, save :: momenta_25(2)
  integer, save :: momenta_26(2)
  integer, save :: momenta_27(3)
  integer, save :: momenta_28(3)
  integer, save :: momenta_29(3)
  integer, save :: momenta_30(3)
  integer, save :: momenta_31(3)
  integer, save :: momenta_32(3)
  integer, save :: momenta_33(3)
  integer, save :: momenta_34(3)
  integer, save :: momenta_35(3)
  integer, save :: momenta_36(3)
  integer, save :: momenta_37(3)
  integer, save :: momenta_38(3)
  integer, save :: momenta_39(3)
  integer, save :: momenta_40(3)
  integer, save :: momenta_41(3)
  integer, save :: momenta_42(3)
  integer, save :: momenta_43(3)
  integer, save :: momenta_44(3)
  integer, save :: momenta_45(3)
  integer, save :: momenta_46(3)
  integer, save :: momenta_47(3)
  integer, save :: momenta_48(3)
  integer, save :: momenta_49(3)
  integer, save :: momenta_50(3)
  integer, save :: momenta_51(3)
  integer, save :: momenta_52(3)
  integer, save :: momenta_53(3)
  integer, save :: momenta_54(3)
  integer, save :: momenta_55(3)
  integer, save :: momenta_56(3)
  integer, save :: momenta_57(3)
  integer, save :: momenta_58(3)
  integer, save :: momenta_59(3)
  integer, save :: momenta_60(3)
  integer, save :: momenta_61(3)
  integer, save :: momenta_62(3)
  integer, save :: momenta_63(3)
  integer, save :: momenta_64(3)
  integer, save :: momenta_65(3)
  integer, save :: momenta_66(3)
  integer, save :: momenta_67(3)
  integer, save :: momenta_68(3)
  integer, save :: momenta_69(3)
  integer, save :: momenta_70(3)
  integer, save :: momenta_71(3)
  integer, save :: momenta_72(3)
  integer, save :: momenta_73(3)
  integer, save :: momenta_74(3)
  integer, save :: momenta_75(3)
  integer, save :: momenta_76(3)
  integer, save :: momenta_77(3)
  integer, save :: momenta_78(3)
  integer, save :: momenta_79(3)
  integer, save :: momenta_80(3)
  integer, save :: momenta_81(3)
  integer, save :: momenta_82(3)
  integer, save :: momenta_83(3)
  integer, save :: momenta_84(3)
  integer, save :: momenta_85(3)
  integer, save :: momenta_86(3)
  integer, save :: momenta_87(3)
  integer, save :: momenta_88(3)
  integer, save :: momenta_89(3)
  integer, save :: momenta_90(3)
  integer, save :: momenta_91(3)
  integer, save :: momenta_92(3)
  integer, save :: momenta_93(3)
  integer, save :: momenta_94(3)
  integer, save :: momenta_95(3)
  integer, save :: momenta_96(3)
  integer, save :: momenta_97(3)
  integer, save :: momenta_98(3)
  integer, save :: momenta_99(3)
  integer, save :: momenta_100(3)
  integer, save :: momenta_101(3)
  integer, save :: momenta_102(3)
  integer, save :: momenta_103(3)
  integer, save :: momenta_104(3)
  integer, save :: momenta_105(3)
  integer, save :: momenta_106(4)
  integer, save :: momenta_107(4)
  integer, save :: momenta_108(4)
  integer, save :: momenta_109(4)
  integer, save :: momenta_110(4)
  integer, save :: momenta_111(4)
  integer, save :: momenta_112(4)
  integer, save :: momenta_113(4)
  integer, save :: momenta_114(4)
  integer, save :: momenta_115(4)
  integer, save :: momenta_116(4)
  integer, save :: momenta_117(4)
  integer, save :: momenta_118(4)
  integer, save :: momenta_119(4)
  integer, save :: momenta_120(4)
  integer, save :: momenta_121(4)
  integer, save :: momenta_122(4)
  integer, save :: momenta_123(4)
  integer, save :: momenta_124(4)
  integer, save :: momenta_125(4)
  integer, save :: momenta_126(4)
  integer, save :: momenta_127(4)
  integer, save :: momenta_128(4)
  integer, save :: momenta_129(4)
  integer, save :: momenta_130(4)
  integer, save :: momenta_131(4)
  integer, save :: momenta_132(4)
  integer, save :: momenta_133(4)
  integer, save :: momenta_134(4)
  integer, save :: momenta_135(4)
  integer, save :: momenta_136(4)
  integer, save :: momenta_137(4)
  integer, save :: momenta_138(4)
  integer, save :: momenta_139(4)
  integer, save :: momenta_140(4)
  integer, save :: momenta_141(4)
  integer, save :: momenta_142(4)
  integer, save :: momenta_143(4)
  integer, save :: momenta_144(4)
  integer, save :: momenta_145(4)
  integer, save :: momenta_146(4)
  integer, save :: momenta_147(4)
  integer, save :: momenta_148(4)
  integer, save :: momenta_149(4)
  integer, save :: momenta_150(4)
  integer, save :: momenta_151(4)
  integer, save :: momenta_152(4)
  integer, save :: momenta_153(4)
  integer, save :: momenta_154(4)
  integer, save :: momenta_155(4)
  integer, save :: momenta_156(4)
  integer, save :: momenta_157(4)
  integer, save :: momenta_158(4)
  integer, save :: momenta_159(4)
  integer, save :: momenta_160(4)
  integer, save :: momenta_161(4)
  integer, save :: momenta_162(4)
  integer, save :: momenta_163(4)
  integer, save :: momenta_164(4)
  integer, save :: momenta_165(4)
  integer, save :: momenta_166(4)
  integer, save :: momenta_167(4)
  integer, save :: momenta_168(4)
  integer, save :: momenta_169(4)
  integer, save :: momenta_170(4)
  integer, save :: momenta_171(4)
  integer, save :: momenta_172(4)
  integer, save :: momenta_173(4)
  integer, save :: momenta_174(4)
  integer, save :: momenta_175(4)
  integer, save :: momenta_176(4)
  integer, save :: momenta_177(4)
  integer, save :: momenta_178(4)
  integer, save :: momenta_179(5)
  integer, save :: momenta_180(5)
  integer, save :: momenta_181(5)
  integer, save :: momenta_182(5)
  integer, save :: momenta_183(5)
  integer, save :: momenta_184(5)
  integer, save :: momenta_185(5)
  integer, save :: momenta_186(5)
  integer, save :: momenta_187(5)
  integer, save :: momenta_188(5)
  integer, save :: momenta_189(5)
  integer, save :: momenta_190(5)
  integer, save :: momenta_191(5)
  integer, save :: momenta_192(5)
  integer, save :: momenta_193(5)
  integer, save :: momenta_194(5)
  integer, save :: momenta_195(5)
  integer, save :: momenta_196(5)
  integer, save :: momenta_197(5)
  integer, save :: momenta_198(5)
  integer, save :: momenta_199(5)
  integer, save :: momenta_200(5)
  integer, save :: momenta_201(5)
  integer, save :: momenta_202(5)
  integer, save :: momenta_203(5)
  integer, save :: momenta_204(5)
  integer, save :: momenta_205(5)
  integer, save :: momenta_206(5)
  integer, save :: momenta_207(6)
  integer, save :: momenta_208(6)
  integer, save :: momenta_209(6)
  integer, save :: momenta_210(6)

  integer, save :: masses2_1(2)
  integer, save :: masses2_2(2)
  integer, save :: masses2_3(2)
  integer, save :: masses2_4(2)
  integer, save :: masses2_5(2)
  integer, save :: masses2_6(2)
  integer, save :: masses2_7(2)
  integer, save :: masses2_8(2)
  integer, save :: masses2_9(2)
  integer, save :: masses2_10(2)
  integer, save :: masses2_11(2)
  integer, save :: masses2_12(2)
  integer, save :: masses2_13(2)
  integer, save :: masses2_14(2)
  integer, save :: masses2_15(2)
  integer, save :: masses2_16(2)
  integer, save :: masses2_17(2)
  integer, save :: masses2_18(3)
  integer, save :: masses2_19(3)
  integer, save :: masses2_20(3)
  integer, save :: masses2_21(3)
  integer, save :: masses2_22(3)
  integer, save :: masses2_23(3)
  integer, save :: masses2_24(3)
  integer, save :: masses2_25(3)
  integer, save :: masses2_26(3)
  integer, save :: masses2_27(3)
  integer, save :: masses2_28(3)
  integer, save :: masses2_29(3)
  integer, save :: masses2_30(3)
  integer, save :: masses2_31(3)
  integer, save :: masses2_32(3)
  integer, save :: masses2_33(4)
  integer, save :: masses2_34(4)
  integer, save :: masses2_35(4)
  integer, save :: masses2_36(4)
  integer, save :: masses2_37(4)
  integer, save :: masses2_38(4)
  integer, save :: masses2_39(4)
  integer, save :: masses2_40(4)
  integer, save :: masses2_41(4)
  integer, save :: masses2_42(4)
  integer, save :: masses2_43(4)
  integer, save :: masses2_44(4)
  integer, save :: masses2_45(4)
  integer, save :: masses2_46(4)
  integer, save :: masses2_47(4)
  integer, save :: masses2_48(4)
  integer, save :: masses2_49(4)
  integer, save :: masses2_50(4)
  integer, save :: masses2_51(4)
  integer, save :: masses2_52(5)
  integer, save :: masses2_53(5)
  integer, save :: masses2_54(5)
  integer, save :: masses2_55(5)
  integer, save :: masses2_56(5)
  integer, save :: masses2_57(5)
  integer, save :: masses2_58(5)
  integer, save :: masses2_59(5)
  integer, save :: masses2_60(5)
  integer, save :: masses2_61(5)
  integer, save :: masses2_62(5)
  integer, save :: masses2_63(5)
  integer, save :: masses2_64(5)
  integer, save :: masses2_65(6)
  integer, save :: masses2_66(6)

type(scalarbox), save :: ScalarBoxes(167)

integer, save :: sbarray_1(15)
integer, save :: sbarray_2(15)
integer, save :: sbarray_3(15)
integer, save :: sbarray_4(15)
integer, save :: sbarray_5(15)
integer, save :: sbarray_6(15)
integer, save :: sbarray_7(5)
integer, save :: sbarray_8(5)
integer, save :: sbarray_9(5)
integer, save :: sbarray_10(5)
integer, save :: sbarray_11(5)
integer, save :: sbarray_12(5)
integer, save :: sbarray_13(5)
integer, save :: sbarray_14(5)
integer, save :: sbarray_15(5)
integer, save :: sbarray_16(5)
integer, save :: sbarray_17(5)
integer, save :: sbarray_18(5)
integer, save :: sbarray_19(5)
integer, save :: sbarray_20(5)
integer, save :: sbarray_21(5)
integer, save :: sbarray_22(5)
integer, save :: sbarray_23(5)
integer, save :: sbarray_24(5)
integer, save :: sbarray_25(5)
integer, save :: sbarray_26(5)
integer, save :: sbarray_27(5)
integer, save :: sbarray_28(5)
integer, save :: sbarray_29(5)
integer, save :: sbarray_30(5)
integer, save :: sbarray_31(5)
integer, save :: sbarray_32(5)
integer, save :: sbarray_33(5)
integer, save :: sbarray_34(5)
integer, save :: sbarray_35(5)
integer, save :: sbarray_36(5)
integer, save :: sbarray_37(5)
integer, save :: sbarray_38(5)
integer, save :: sbarray_39(5)
integer, save :: sbarray_40(5)
integer, save :: sbarray_41(5)
integer, save :: sbarray_42(5)
integer, save :: sbarray_43(5)
integer, save :: sbarray_44(5)
integer, save :: sbarray_45(5)
integer, save :: sbarray_46(5)
integer, save :: sbarray_47(5)
integer, save :: sbarray_48(5)
integer, save :: sbarray_49(5)
integer, save :: sbarray_50(5)
integer, save :: sbarray_51(5)
integer, save :: sbarray_52(5)
integer, save :: sbarray_53(5)
integer, save :: sbarray_54(5)
integer, save :: sbarray_55(5)
integer, save :: sbarray_56(5)
integer, save :: sbarray_57(5)
integer, save :: sbarray_58(5)

  type(hcl), save, dimension(438) :: T0sum
  type(hcl), save, dimension(85) :: T1sum


  contains

!**********************************************************************
subroutine HOL_memory_allocation()
!**********************************************************************
! allocation of memory for the types hol
!**********************************************************************
  use KIND_TYPES, only: REALKIND
  use ol_data_types_/**/REALKIND, only: hol
  use hol_initialisation_/**/REALKIND, only: hol_allocation
  implicit none

    call hol_allocation(4,1,4,1,G0H1,1)
  call hol_allocation(4,5,4,1,G1H1,1)
  call hol_allocation(4,15,4,1,G2H1,1)
  call hol_allocation(4,1,4,2,G0H2,1)
  call hol_allocation(4,5,4,2,G1H2,376)
  call hol_allocation(4,15,4,2,G2H2,177)
  call hol_allocation(4,1,4,4,G0H4,40)
  call hol_allocation(4,5,4,4,G1H4,204)
  call hol_allocation(4,15,4,4,G2H4,78)
  call hol_allocation(4,1,4,8,G0H8,36)
  call hol_allocation(4,5,4,8,G1H8,187)
  call hol_allocation(4,15,4,8,G2H8,60)
  call hol_allocation(4,1,4,16,G0H16,14)
  call hol_allocation(4,5,4,16,G1H16,17)
  call hol_allocation(4,1,4,32,G0H32,1)
  call hol_allocation(4,5,4,32,G1H32,74)
  call hol_allocation(4,1,4,64,G0H64,1)


end subroutine HOL_memory_allocation


!**********************************************************************
subroutine HOL_memory_deallocation_/**/REALKIND(dmode)
!**********************************************************************
! allocation of memory for the types hol
!**********************************************************************
  use KIND_TYPES, only: REALKIND
  use ol_data_types_/**/REALKIND, only: hol
  use hol_initialisation_/**/REALKIND, only: hol_deallocation
  implicit none
  integer,   intent(in)    :: dmode

    call hol_deallocation(G0H1,1,dmode)
  call hol_deallocation(G1H1,1,dmode)
  call hol_deallocation(G2H1,1,dmode)
  call hol_deallocation(G0H2,1,dmode)
  call hol_deallocation(G1H2,376,dmode)
  call hol_deallocation(G2H2,177,dmode)
  call hol_deallocation(G0H4,40,dmode)
  call hol_deallocation(G1H4,204,dmode)
  call hol_deallocation(G2H4,78,dmode)
  call hol_deallocation(G0H8,36,dmode)
  call hol_deallocation(G1H8,187,dmode)
  call hol_deallocation(G2H8,60,dmode)
  call hol_deallocation(G0H16,14,dmode)
  call hol_deallocation(G1H16,17,dmode)
  call hol_deallocation(G0H32,1,dmode)
  call hol_deallocation(G1H32,74,dmode)
  call hol_deallocation(G0H64,1,dmode)


end subroutine HOL_memory_deallocation_/**/REALKIND

!**********************************************************************
subroutine HCL_memory_allocation()
!**********************************************************************
! allocation of memory for the types hcl
!**********************************************************************
  use KIND_TYPES, only: REALKIND
  use ol_data_types_/**/REALKIND, only: hcl
  use hol_initialisation_/**/REALKIND, only: hcl_allocation
  implicit none

  call hcl_allocation(1,G0tensor, 892)
call hcl_allocation(5,G1tensor, 791)
call hcl_allocation(15,G2tensor, 528)
call hcl_allocation(35,G3tensor, 94)


end subroutine HCL_memory_allocation


!**********************************************************************
subroutine HCL_memory_deallocation_/**/REALKIND(dmode)
!**********************************************************************
! deallocation of memory for the types hcl
!**********************************************************************
  use KIND_TYPES, only: REALKIND
  use ol_data_types_/**/REALKIND, only: hcl
  use hol_initialisation_/**/REALKIND, only: hcl_deallocation
  implicit none
  integer,   intent(in)    :: dmode

  call hcl_deallocation(G0tensor, 892,dmode)
call hcl_deallocation(G1tensor, 791,dmode)
call hcl_deallocation(G2tensor, 528,dmode)
call hcl_deallocation(G3tensor, 94,dmode)

    call hcl_deallocation(T0sum,438,dmode)
  call hcl_deallocation(T1sum,85,dmode)


end subroutine HCL_memory_deallocation_/**/REALKIND


!**********************************************************************
subroutine Tsum_memory_allocation()
!**********************************************************************
! allocation of memory for the types hcl
!**********************************************************************
  use KIND_TYPES, only: REALKIND
  use ol_data_types_/**/REALKIND, only: hcl
  use hol_initialisation_/**/REALKIND, only: hcl_allocation
  implicit none

    call hcl_allocation(1,T0sum,438)
  call hcl_allocation(5,T1sum,85)


end subroutine Tsum_memory_allocation


#ifdef PRECISION_dp
subroutine max_point(r) &
    & bind(c,name="ol_f_max_point_ppnnjj_ew_nenexuuxgg_1")
  ! Return the number maximal tensor rank
  implicit none
  integer, intent(out) :: r
  r = 6
end subroutine max_point

subroutine tensor_rank(r) &
    & bind(c,name="ol_f_tensor_rank_ppnnjj_ew_nenexuuxgg_1")
  ! Return the number maximal tensor rank
  implicit none
  integer, intent(out) :: r
  r = 1
end subroutine tensor_rank
#endif

subroutine reset_tensor_sum()
  use hol_initialisation_/**/REALKIND, only: hcl_allocation
  use ol_parameters_init_/**/REALKIND, only: init_hcl
  implicit none
  integer :: i

  do i = 1,438
    call init_hcl(T0sum(i))
  end do
  do i = 1,85
    call init_hcl(T1sum(i))
  end do

end subroutine reset_tensor_sum


subroutine scale_one_tsum(tsum, spow)
  use ol_parameters_decl_/**/REALKIND, only: scalefactor
  implicit none
  complex(REALKIND), intent(inout) :: tsum(:)
  integer, intent(in) :: spow ! rank 0 scale power
  real(REALKIND) :: sfinv, sfac
  integer :: sz
  sfinv = 1/scalefactor
  sfac = scalefactor**spow
  sz = size(tsum)
  tsum(1) = sfac*tsum(1)
  if (sz > 1) then ! rank 1
    sfac = sfac*sfinv
    tsum(2:5) = sfac*tsum(2:5)
  end if
  if (sz > 5) then ! rank 2
    sfac = sfac*sfinv
    tsum(6:15) = sfac*tsum(6:15)
  end if
  if (sz > 15) then ! rank 3
    sfac = sfac*sfinv
    tsum(16:35) = sfac*tsum(16:35)
  end if
  if (sz > 35) then ! rank 4
    sfac = sfac*sfinv
    tsum(36:70) = sfac*tsum(36:70)
  end if
  if (sz > 70) then ! rank 5
    sfac = sfac*sfinv
    tsum(71:126) = sfac*tsum(71:126)
  end if
  if (sz > 126) then ! rank 6
    sfac = sfac*sfinv
    tsum(127:210) = sfac*tsum(127:210)
  end if
  if (sz > 210) then ! rank 7
    sfac = sfac*sfinv
    tsum(211:330) = sfac*tsum(211:330)
  end if
end subroutine scale_one_tsum


subroutine scale_tensor_sum()
  implicit none
  call scale_one_tsum(T1sum(1)%cmp, 4)
  call scale_one_tsum(T1sum(2)%cmp, 4)
  call scale_one_tsum(T1sum(3)%cmp, 4)
  call scale_one_tsum(T1sum(4)%cmp, 4)
  call scale_one_tsum(T1sum(5)%cmp, 4)
  call scale_one_tsum(T1sum(6)%cmp, 4)
  call scale_one_tsum(T1sum(7)%cmp, 2)
  call scale_one_tsum(T1sum(8)%cmp, 2)
  call scale_one_tsum(T1sum(9)%cmp, 2)
  call scale_one_tsum(T1sum(10)%cmp, 2)
  call scale_one_tsum(T1sum(11)%cmp, 2)
  call scale_one_tsum(T1sum(12)%cmp, 2)
  call scale_one_tsum(T1sum(13)%cmp, 2)
  call scale_one_tsum(T1sum(14)%cmp, 2)
  call scale_one_tsum(T1sum(15)%cmp, 2)
  call scale_one_tsum(T1sum(16)%cmp, 2)
  call scale_one_tsum(T1sum(17)%cmp, 2)
  call scale_one_tsum(T1sum(18)%cmp, 2)
  call scale_one_tsum(T1sum(19)%cmp, 2)
  call scale_one_tsum(T1sum(20)%cmp, 2)
  call scale_one_tsum(T1sum(21)%cmp, 2)
  call scale_one_tsum(T1sum(22)%cmp, 2)
  call scale_one_tsum(T1sum(23)%cmp, 2)
  call scale_one_tsum(T1sum(24)%cmp, 2)
  call scale_one_tsum(T1sum(25)%cmp, 2)
  call scale_one_tsum(T1sum(26)%cmp, 2)
  call scale_one_tsum(T1sum(27)%cmp, 2)
  call scale_one_tsum(T1sum(28)%cmp, 2)
  call scale_one_tsum(T1sum(29)%cmp, 2)
  call scale_one_tsum(T1sum(30)%cmp, 2)
  call scale_one_tsum(T1sum(31)%cmp, 2)
  call scale_one_tsum(T1sum(32)%cmp, 2)
  call scale_one_tsum(T1sum(33)%cmp, 2)
  call scale_one_tsum(T1sum(34)%cmp, 2)
  call scale_one_tsum(T1sum(35)%cmp, 2)
  call scale_one_tsum(T1sum(36)%cmp, 2)
  call scale_one_tsum(T1sum(37)%cmp, 2)
  call scale_one_tsum(T1sum(38)%cmp, 2)
  call scale_one_tsum(T1sum(39)%cmp, 2)
  call scale_one_tsum(T1sum(40)%cmp, 2)
  call scale_one_tsum(T1sum(41)%cmp, 2)
  call scale_one_tsum(T1sum(42)%cmp, 2)
  call scale_one_tsum(T1sum(43)%cmp, 2)
  call scale_one_tsum(T1sum(44)%cmp, 2)
  call scale_one_tsum(T1sum(45)%cmp, 2)
  call scale_one_tsum(T1sum(46)%cmp, 2)
  call scale_one_tsum(T1sum(47)%cmp, 2)
  call scale_one_tsum(T1sum(48)%cmp, 2)
  call scale_one_tsum(T1sum(49)%cmp, 2)
  call scale_one_tsum(T1sum(50)%cmp, 2)
  call scale_one_tsum(T1sum(51)%cmp, 2)
  call scale_one_tsum(T1sum(52)%cmp, 2)
  call scale_one_tsum(T1sum(53)%cmp, 2)
  call scale_one_tsum(T1sum(54)%cmp, 2)
  call scale_one_tsum(T1sum(55)%cmp, 2)
  call scale_one_tsum(T1sum(56)%cmp, 2)
  call scale_one_tsum(T1sum(57)%cmp, 2)
  call scale_one_tsum(T1sum(58)%cmp, 2)
  call scale_one_tsum(T0sum(1)%cmp, 0)
  call scale_one_tsum(T0sum(2)%cmp, 0)
  call scale_one_tsum(T0sum(3)%cmp, 0)
  call scale_one_tsum(T0sum(4)%cmp, 0)
  call scale_one_tsum(T0sum(5)%cmp, 0)
  call scale_one_tsum(T0sum(6)%cmp, 0)
  call scale_one_tsum(T0sum(7)%cmp, 0)
  call scale_one_tsum(T0sum(8)%cmp, 0)
  call scale_one_tsum(T0sum(9)%cmp, 0)
  call scale_one_tsum(T0sum(10)%cmp, 0)
  call scale_one_tsum(T0sum(11)%cmp, 0)
  call scale_one_tsum(T0sum(12)%cmp, 0)
  call scale_one_tsum(T0sum(13)%cmp, 0)
  call scale_one_tsum(T0sum(14)%cmp, 0)
  call scale_one_tsum(T0sum(15)%cmp, 0)
  call scale_one_tsum(T0sum(16)%cmp, 0)
  call scale_one_tsum(T0sum(17)%cmp, 0)
  call scale_one_tsum(T0sum(18)%cmp, 0)
  call scale_one_tsum(T0sum(19)%cmp, 0)
  call scale_one_tsum(T0sum(20)%cmp, 0)
  call scale_one_tsum(T0sum(21)%cmp, 0)
  call scale_one_tsum(T0sum(22)%cmp, 0)
  call scale_one_tsum(T0sum(23)%cmp, 0)
  call scale_one_tsum(T0sum(24)%cmp, 0)
  call scale_one_tsum(T0sum(25)%cmp, 0)
  call scale_one_tsum(T0sum(26)%cmp, 0)
  call scale_one_tsum(T0sum(27)%cmp, 0)
  call scale_one_tsum(T0sum(28)%cmp, 0)
  call scale_one_tsum(T0sum(29)%cmp, 0)
  call scale_one_tsum(T0sum(30)%cmp, 0)
  call scale_one_tsum(T0sum(31)%cmp, 0)
  call scale_one_tsum(T0sum(32)%cmp, 0)
  call scale_one_tsum(T0sum(33)%cmp, 0)
  call scale_one_tsum(T0sum(34)%cmp, 0)
  call scale_one_tsum(T0sum(35)%cmp, 0)
  call scale_one_tsum(T0sum(36)%cmp, 0)
  call scale_one_tsum(T0sum(37)%cmp, 0)
  call scale_one_tsum(T0sum(38)%cmp, 0)
  call scale_one_tsum(T0sum(39)%cmp, 0)
  call scale_one_tsum(T0sum(40)%cmp, 0)
  call scale_one_tsum(T0sum(41)%cmp, 0)
  call scale_one_tsum(T0sum(42)%cmp, 0)
  call scale_one_tsum(T0sum(43)%cmp, 0)
  call scale_one_tsum(T0sum(44)%cmp, 0)
  call scale_one_tsum(T0sum(45)%cmp, 0)
  call scale_one_tsum(T0sum(46)%cmp, 0)
  call scale_one_tsum(T0sum(47)%cmp, 0)
  call scale_one_tsum(T0sum(48)%cmp, 0)
  call scale_one_tsum(T0sum(49)%cmp, 0)
  call scale_one_tsum(T0sum(50)%cmp, 0)
  call scale_one_tsum(T0sum(51)%cmp, 0)
  call scale_one_tsum(T0sum(52)%cmp, 0)
  call scale_one_tsum(T0sum(53)%cmp, 0)
  call scale_one_tsum(T0sum(54)%cmp, 0)
  call scale_one_tsum(T0sum(55)%cmp, 0)
  call scale_one_tsum(T0sum(56)%cmp, 0)
  call scale_one_tsum(T0sum(57)%cmp, 0)
  call scale_one_tsum(T0sum(58)%cmp, 0)
  call scale_one_tsum(T0sum(59)%cmp, 0)
  call scale_one_tsum(T0sum(60)%cmp, 0)
  call scale_one_tsum(T0sum(61)%cmp, 0)
  call scale_one_tsum(T0sum(62)%cmp, 0)
  call scale_one_tsum(T0sum(63)%cmp, 0)
  call scale_one_tsum(T0sum(64)%cmp, 0)
  call scale_one_tsum(T0sum(65)%cmp, 0)
  call scale_one_tsum(T0sum(66)%cmp, 0)
  call scale_one_tsum(T0sum(67)%cmp, 0)
  call scale_one_tsum(T0sum(68)%cmp, 0)
  call scale_one_tsum(T0sum(69)%cmp, 0)
  call scale_one_tsum(T0sum(70)%cmp, 0)
  call scale_one_tsum(T0sum(71)%cmp, 0)
  call scale_one_tsum(T0sum(72)%cmp, 0)
  call scale_one_tsum(T0sum(73)%cmp, 0)
  call scale_one_tsum(T0sum(74)%cmp, 0)
  call scale_one_tsum(T0sum(75)%cmp, 0)
  call scale_one_tsum(T0sum(76)%cmp, 0)
  call scale_one_tsum(T0sum(77)%cmp, 0)
  call scale_one_tsum(T0sum(78)%cmp, 0)
  call scale_one_tsum(T0sum(79)%cmp, 0)
  call scale_one_tsum(T0sum(80)%cmp, 0)
  call scale_one_tsum(T0sum(81)%cmp, 0)
  call scale_one_tsum(T0sum(82)%cmp, 0)
  call scale_one_tsum(T0sum(83)%cmp, 0)
  call scale_one_tsum(T0sum(84)%cmp, 0)
  call scale_one_tsum(T0sum(85)%cmp, 0)
  call scale_one_tsum(T0sum(86)%cmp, 0)
  call scale_one_tsum(T0sum(87)%cmp, 0)
  call scale_one_tsum(T0sum(88)%cmp, 0)
  call scale_one_tsum(T0sum(89)%cmp, 0)
  call scale_one_tsum(T0sum(90)%cmp, 0)
  call scale_one_tsum(T0sum(91)%cmp, 0)
  call scale_one_tsum(T0sum(92)%cmp, 0)
  call scale_one_tsum(T0sum(93)%cmp, 0)
  call scale_one_tsum(T0sum(94)%cmp, 0)
  call scale_one_tsum(T0sum(95)%cmp, 0)
  call scale_one_tsum(T0sum(96)%cmp, 0)
  call scale_one_tsum(T0sum(97)%cmp, 0)
  call scale_one_tsum(T0sum(98)%cmp, 0)
  call scale_one_tsum(T0sum(99)%cmp, 0)
  call scale_one_tsum(T0sum(100)%cmp, 0)
  call scale_one_tsum(T0sum(101)%cmp, 0)
  call scale_one_tsum(T0sum(102)%cmp, 0)
  call scale_one_tsum(T0sum(103)%cmp, 0)
  call scale_one_tsum(T0sum(104)%cmp, 0)
  call scale_one_tsum(T0sum(105)%cmp, 0)
  call scale_one_tsum(T0sum(106)%cmp, 0)
  call scale_one_tsum(T0sum(107)%cmp, 0)
  call scale_one_tsum(T0sum(108)%cmp, 0)
  call scale_one_tsum(T0sum(109)%cmp, 0)
  call scale_one_tsum(T0sum(110)%cmp, 0)
  call scale_one_tsum(T0sum(111)%cmp, 0)
  call scale_one_tsum(T0sum(112)%cmp, 0)
  call scale_one_tsum(T0sum(113)%cmp, 0)
  call scale_one_tsum(T0sum(114)%cmp, 0)
  call scale_one_tsum(T0sum(115)%cmp, 0)
  call scale_one_tsum(T0sum(116)%cmp, 0)
  call scale_one_tsum(T0sum(117)%cmp, 0)
  call scale_one_tsum(T0sum(118)%cmp, 0)
  call scale_one_tsum(T0sum(119)%cmp, 0)
  call scale_one_tsum(T0sum(120)%cmp, 0)
  call scale_one_tsum(T0sum(121)%cmp, 0)
  call scale_one_tsum(T0sum(122)%cmp, 0)
  call scale_one_tsum(T0sum(123)%cmp, 0)
  call scale_one_tsum(T0sum(124)%cmp, 0)
  call scale_one_tsum(T0sum(125)%cmp, 0)
  call scale_one_tsum(T0sum(126)%cmp, 0)
  call scale_one_tsum(T0sum(127)%cmp, 0)
  call scale_one_tsum(T0sum(128)%cmp, 0)
  call scale_one_tsum(T0sum(129)%cmp, 0)
  call scale_one_tsum(T0sum(130)%cmp, 0)
  call scale_one_tsum(T0sum(131)%cmp, 0)
  call scale_one_tsum(T0sum(132)%cmp, 0)
  call scale_one_tsum(T0sum(133)%cmp, 0)
  call scale_one_tsum(T0sum(134)%cmp, 0)
  call scale_one_tsum(T0sum(135)%cmp, 0)
  call scale_one_tsum(T0sum(136)%cmp, 0)
  call scale_one_tsum(T0sum(137)%cmp, 0)
  call scale_one_tsum(T0sum(138)%cmp, 0)
  call scale_one_tsum(T0sum(139)%cmp, 0)
  call scale_one_tsum(T0sum(140)%cmp, 0)
  call scale_one_tsum(T0sum(141)%cmp, 0)
  call scale_one_tsum(T0sum(142)%cmp, 0)
  call scale_one_tsum(T0sum(143)%cmp, 0)
  call scale_one_tsum(T0sum(144)%cmp, 0)
  call scale_one_tsum(T0sum(145)%cmp, 0)
  call scale_one_tsum(T0sum(146)%cmp, 0)
  call scale_one_tsum(T0sum(147)%cmp, 0)
  call scale_one_tsum(T0sum(148)%cmp, 0)
  call scale_one_tsum(T0sum(149)%cmp, 0)
  call scale_one_tsum(T0sum(150)%cmp, 0)
  call scale_one_tsum(T0sum(151)%cmp, 0)
  call scale_one_tsum(T0sum(152)%cmp, 0)
  call scale_one_tsum(T0sum(153)%cmp, 0)
  call scale_one_tsum(T0sum(154)%cmp, 0)
  call scale_one_tsum(T0sum(155)%cmp, 0)
  call scale_one_tsum(T0sum(156)%cmp, 0)
  call scale_one_tsum(T0sum(157)%cmp, 0)
  call scale_one_tsum(T0sum(158)%cmp, 0)
  call scale_one_tsum(T0sum(159)%cmp, 0)
  call scale_one_tsum(T0sum(160)%cmp, 0)
  call scale_one_tsum(T0sum(161)%cmp, -2)
  call scale_one_tsum(T0sum(162)%cmp, -2)
  call scale_one_tsum(T0sum(163)%cmp, -2)
  call scale_one_tsum(T0sum(164)%cmp, -2)
  call scale_one_tsum(T0sum(165)%cmp, -2)
  call scale_one_tsum(T0sum(166)%cmp, -2)
  call scale_one_tsum(T0sum(167)%cmp, -2)
  call scale_one_tsum(T0sum(168)%cmp, -2)
  call scale_one_tsum(T0sum(169)%cmp, -2)
  call scale_one_tsum(T0sum(170)%cmp, -2)
  call scale_one_tsum(T0sum(171)%cmp, -2)
  call scale_one_tsum(T0sum(172)%cmp, -2)
  call scale_one_tsum(T0sum(173)%cmp, -2)
  call scale_one_tsum(T0sum(174)%cmp, -2)
  call scale_one_tsum(T0sum(175)%cmp, -2)
  call scale_one_tsum(T0sum(176)%cmp, -2)
  call scale_one_tsum(T0sum(177)%cmp, -2)
  call scale_one_tsum(T0sum(178)%cmp, -2)
  call scale_one_tsum(T0sum(179)%cmp, -2)
  call scale_one_tsum(T0sum(180)%cmp, -2)
  call scale_one_tsum(T0sum(181)%cmp, -2)
  call scale_one_tsum(T0sum(182)%cmp, -2)
  call scale_one_tsum(T0sum(183)%cmp, -2)
  call scale_one_tsum(T0sum(184)%cmp, -2)
  call scale_one_tsum(T0sum(185)%cmp, -2)
  call scale_one_tsum(T0sum(186)%cmp, -2)
  call scale_one_tsum(T0sum(187)%cmp, -2)
  call scale_one_tsum(T0sum(188)%cmp, -2)
  call scale_one_tsum(T0sum(189)%cmp, -2)
  call scale_one_tsum(T0sum(190)%cmp, -2)
  call scale_one_tsum(T0sum(191)%cmp, -2)
  call scale_one_tsum(T0sum(192)%cmp, -2)
  call scale_one_tsum(T0sum(193)%cmp, -2)
  call scale_one_tsum(T0sum(194)%cmp, -2)
  call scale_one_tsum(T0sum(195)%cmp, -2)
  call scale_one_tsum(T0sum(196)%cmp, -2)
  call scale_one_tsum(T0sum(197)%cmp, -2)
  call scale_one_tsum(T0sum(198)%cmp, -2)
  call scale_one_tsum(T0sum(199)%cmp, -2)
  call scale_one_tsum(T0sum(200)%cmp, -2)
  call scale_one_tsum(T0sum(201)%cmp, -2)
  call scale_one_tsum(T0sum(202)%cmp, -2)
  call scale_one_tsum(T0sum(203)%cmp, -2)
  call scale_one_tsum(T0sum(204)%cmp, -2)
  call scale_one_tsum(T0sum(205)%cmp, -2)
  call scale_one_tsum(T0sum(206)%cmp, -2)
  call scale_one_tsum(T0sum(207)%cmp, -2)
  call scale_one_tsum(T0sum(208)%cmp, -2)
  call scale_one_tsum(T0sum(209)%cmp, -2)
  call scale_one_tsum(T0sum(210)%cmp, -2)
  call scale_one_tsum(T0sum(211)%cmp, -2)
  call scale_one_tsum(T0sum(212)%cmp, -2)
  call scale_one_tsum(T0sum(213)%cmp, -2)
  call scale_one_tsum(T0sum(214)%cmp, -2)
  call scale_one_tsum(T0sum(215)%cmp, -2)
  call scale_one_tsum(T0sum(216)%cmp, -2)
  call scale_one_tsum(T0sum(217)%cmp, -2)
  call scale_one_tsum(T0sum(218)%cmp, -2)
  call scale_one_tsum(T0sum(219)%cmp, -2)
  call scale_one_tsum(T0sum(220)%cmp, -2)
  call scale_one_tsum(T0sum(221)%cmp, -2)
  call scale_one_tsum(T0sum(222)%cmp, -2)
  call scale_one_tsum(T0sum(223)%cmp, -2)
  call scale_one_tsum(T0sum(224)%cmp, -2)
  call scale_one_tsum(T0sum(225)%cmp, -2)
  call scale_one_tsum(T0sum(226)%cmp, -2)
  call scale_one_tsum(T0sum(227)%cmp, -2)
  call scale_one_tsum(T0sum(228)%cmp, -2)
  call scale_one_tsum(T0sum(229)%cmp, -2)
  call scale_one_tsum(T0sum(230)%cmp, -2)
  call scale_one_tsum(T0sum(231)%cmp, -2)
  call scale_one_tsum(T0sum(232)%cmp, -2)
  call scale_one_tsum(T0sum(233)%cmp, -2)
  call scale_one_tsum(T0sum(234)%cmp, -2)
  call scale_one_tsum(T0sum(235)%cmp, -2)
  call scale_one_tsum(T0sum(236)%cmp, -2)
  call scale_one_tsum(T0sum(237)%cmp, -2)
  call scale_one_tsum(T0sum(238)%cmp, -2)
  call scale_one_tsum(T0sum(239)%cmp, -2)
  call scale_one_tsum(T0sum(240)%cmp, -2)
  call scale_one_tsum(T0sum(241)%cmp, -2)
  call scale_one_tsum(T0sum(242)%cmp, -2)
  call scale_one_tsum(T0sum(243)%cmp, -2)
  call scale_one_tsum(T0sum(244)%cmp, -2)
  call scale_one_tsum(T0sum(245)%cmp, -2)
  call scale_one_tsum(T0sum(246)%cmp, -2)
  call scale_one_tsum(T0sum(247)%cmp, -2)
  call scale_one_tsum(T0sum(248)%cmp, -2)
  call scale_one_tsum(T0sum(249)%cmp, -2)
  call scale_one_tsum(T0sum(250)%cmp, -2)
  call scale_one_tsum(T0sum(251)%cmp, -2)
  call scale_one_tsum(T0sum(252)%cmp, -2)
  call scale_one_tsum(T0sum(253)%cmp, -2)
  call scale_one_tsum(T0sum(254)%cmp, -2)
  call scale_one_tsum(T0sum(255)%cmp, -2)
  call scale_one_tsum(T0sum(256)%cmp, -2)
  call scale_one_tsum(T0sum(257)%cmp, -2)
  call scale_one_tsum(T0sum(258)%cmp, -2)
  call scale_one_tsum(T0sum(259)%cmp, -2)
  call scale_one_tsum(T0sum(260)%cmp, -2)
  call scale_one_tsum(T0sum(261)%cmp, -2)
  call scale_one_tsum(T0sum(262)%cmp, -2)
  call scale_one_tsum(T0sum(263)%cmp, -2)
  call scale_one_tsum(T0sum(264)%cmp, -2)
  call scale_one_tsum(T0sum(265)%cmp, -2)
  call scale_one_tsum(T0sum(266)%cmp, -2)
  call scale_one_tsum(T0sum(267)%cmp, -2)
  call scale_one_tsum(T0sum(268)%cmp, -2)
  call scale_one_tsum(T0sum(269)%cmp, -2)
  call scale_one_tsum(T0sum(270)%cmp, -2)
  call scale_one_tsum(T0sum(271)%cmp, -2)
  call scale_one_tsum(T0sum(272)%cmp, -2)
  call scale_one_tsum(T0sum(273)%cmp, -2)
  call scale_one_tsum(T0sum(274)%cmp, -2)
  call scale_one_tsum(T0sum(275)%cmp, -2)
  call scale_one_tsum(T0sum(276)%cmp, -2)
  call scale_one_tsum(T0sum(277)%cmp, -2)
  call scale_one_tsum(T0sum(278)%cmp, -2)
  call scale_one_tsum(T0sum(279)%cmp, -2)
  call scale_one_tsum(T0sum(280)%cmp, -2)
  call scale_one_tsum(T0sum(281)%cmp, -2)
  call scale_one_tsum(T0sum(282)%cmp, -2)
  call scale_one_tsum(T0sum(283)%cmp, -2)
  call scale_one_tsum(T0sum(284)%cmp, -2)
  call scale_one_tsum(T0sum(285)%cmp, -2)
  call scale_one_tsum(T0sum(286)%cmp, -2)
  call scale_one_tsum(T0sum(287)%cmp, -2)
  call scale_one_tsum(T0sum(288)%cmp, -2)
  call scale_one_tsum(T0sum(289)%cmp, -2)
  call scale_one_tsum(T0sum(290)%cmp, -2)
  call scale_one_tsum(T0sum(291)%cmp, -2)
  call scale_one_tsum(T0sum(292)%cmp, -2)
  call scale_one_tsum(T0sum(293)%cmp, -2)
  call scale_one_tsum(T0sum(294)%cmp, -2)
  call scale_one_tsum(T0sum(295)%cmp, -2)
  call scale_one_tsum(T0sum(296)%cmp, -2)
  call scale_one_tsum(T0sum(297)%cmp, -2)
  call scale_one_tsum(T0sum(298)%cmp, -2)
  call scale_one_tsum(T0sum(299)%cmp, -2)
  call scale_one_tsum(T0sum(300)%cmp, -2)
  call scale_one_tsum(T0sum(301)%cmp, -2)
  call scale_one_tsum(T0sum(302)%cmp, -2)
  call scale_one_tsum(T0sum(303)%cmp, -2)
  call scale_one_tsum(T0sum(304)%cmp, -2)
  call scale_one_tsum(T0sum(305)%cmp, -2)
  call scale_one_tsum(T0sum(306)%cmp, -2)
  call scale_one_tsum(T0sum(307)%cmp, -2)
  call scale_one_tsum(T0sum(308)%cmp, -2)
  call scale_one_tsum(T0sum(309)%cmp, -2)
  call scale_one_tsum(T0sum(310)%cmp, -2)
  call scale_one_tsum(T0sum(311)%cmp, -2)
  call scale_one_tsum(T0sum(312)%cmp, -2)
  call scale_one_tsum(T0sum(313)%cmp, -2)
  call scale_one_tsum(T0sum(314)%cmp, -2)
  call scale_one_tsum(T0sum(315)%cmp, -2)
  call scale_one_tsum(T0sum(316)%cmp, -2)
  call scale_one_tsum(T0sum(317)%cmp, -2)
  call scale_one_tsum(T0sum(318)%cmp, -2)
  call scale_one_tsum(T0sum(319)%cmp, -2)
  call scale_one_tsum(T0sum(320)%cmp, -2)
  call scale_one_tsum(T0sum(321)%cmp, -2)
  call scale_one_tsum(T0sum(322)%cmp, -2)
  call scale_one_tsum(T0sum(323)%cmp, -2)
  call scale_one_tsum(T0sum(324)%cmp, -2)
  call scale_one_tsum(T0sum(325)%cmp, -2)
  call scale_one_tsum(T0sum(326)%cmp, -2)
  call scale_one_tsum(T0sum(327)%cmp, -2)
  call scale_one_tsum(T0sum(328)%cmp, -2)
  call scale_one_tsum(T0sum(329)%cmp, -2)
  call scale_one_tsum(T0sum(330)%cmp, -2)
  call scale_one_tsum(T0sum(331)%cmp, -2)
  call scale_one_tsum(T0sum(332)%cmp, -2)
  call scale_one_tsum(T0sum(333)%cmp, -2)
  call scale_one_tsum(T0sum(334)%cmp, -2)
  call scale_one_tsum(T0sum(335)%cmp, -2)
  call scale_one_tsum(T0sum(336)%cmp, -2)
  call scale_one_tsum(T0sum(337)%cmp, -2)
  call scale_one_tsum(T0sum(338)%cmp, -2)
  call scale_one_tsum(T0sum(339)%cmp, -2)
  call scale_one_tsum(T1sum(59)%cmp, -2)
  call scale_one_tsum(T1sum(60)%cmp, -2)
  call scale_one_tsum(T1sum(61)%cmp, -2)
  call scale_one_tsum(T1sum(62)%cmp, -2)
  call scale_one_tsum(T1sum(63)%cmp, -2)
  call scale_one_tsum(T1sum(64)%cmp, -2)
  call scale_one_tsum(T1sum(65)%cmp, -2)
  call scale_one_tsum(T1sum(66)%cmp, -2)
  call scale_one_tsum(T1sum(67)%cmp, -2)
  call scale_one_tsum(T1sum(68)%cmp, -2)
  call scale_one_tsum(T1sum(69)%cmp, -2)
  call scale_one_tsum(T1sum(70)%cmp, -2)
  call scale_one_tsum(T1sum(71)%cmp, -2)
  call scale_one_tsum(T1sum(72)%cmp, -2)
  call scale_one_tsum(T1sum(73)%cmp, -2)
  call scale_one_tsum(T1sum(74)%cmp, -2)
  call scale_one_tsum(T1sum(75)%cmp, -2)
  call scale_one_tsum(T1sum(76)%cmp, -2)
  call scale_one_tsum(T1sum(77)%cmp, -2)
  call scale_one_tsum(T1sum(78)%cmp, -2)
  call scale_one_tsum(T1sum(79)%cmp, -2)
  call scale_one_tsum(T1sum(80)%cmp, -2)
  call scale_one_tsum(T1sum(81)%cmp, -2)
  call scale_one_tsum(T1sum(82)%cmp, -2)
  call scale_one_tsum(T1sum(83)%cmp, -2)
  call scale_one_tsum(T1sum(84)%cmp, -2)
  call scale_one_tsum(T1sum(85)%cmp, -2)
  call scale_one_tsum(T0sum(340)%cmp, -2)
  call scale_one_tsum(T0sum(341)%cmp, -2)
  call scale_one_tsum(T0sum(342)%cmp, -2)
  call scale_one_tsum(T0sum(343)%cmp, -2)
  call scale_one_tsum(T0sum(344)%cmp, -2)
  call scale_one_tsum(T0sum(345)%cmp, -2)
  call scale_one_tsum(T0sum(346)%cmp, -2)
  call scale_one_tsum(T0sum(347)%cmp, -2)
  call scale_one_tsum(T0sum(348)%cmp, -2)
  call scale_one_tsum(T0sum(349)%cmp, -2)
  call scale_one_tsum(T0sum(350)%cmp, -4)
  call scale_one_tsum(T0sum(351)%cmp, -4)
  call scale_one_tsum(T0sum(352)%cmp, -4)
  call scale_one_tsum(T0sum(353)%cmp, -4)
  call scale_one_tsum(T0sum(354)%cmp, -4)
  call scale_one_tsum(T0sum(355)%cmp, -4)
  call scale_one_tsum(T0sum(356)%cmp, -4)
  call scale_one_tsum(T0sum(357)%cmp, -4)
  call scale_one_tsum(T0sum(358)%cmp, -4)
  call scale_one_tsum(T0sum(359)%cmp, -4)
  call scale_one_tsum(T0sum(360)%cmp, -4)
  call scale_one_tsum(T0sum(361)%cmp, -4)
  call scale_one_tsum(T0sum(362)%cmp, -4)
  call scale_one_tsum(T0sum(363)%cmp, -4)
  call scale_one_tsum(T0sum(364)%cmp, -4)
  call scale_one_tsum(T0sum(365)%cmp, -4)
  call scale_one_tsum(T0sum(366)%cmp, -4)
  call scale_one_tsum(T0sum(367)%cmp, -4)
  call scale_one_tsum(T0sum(368)%cmp, -4)
  call scale_one_tsum(T0sum(369)%cmp, -4)
  call scale_one_tsum(T0sum(370)%cmp, -4)
  call scale_one_tsum(T0sum(371)%cmp, -4)
  call scale_one_tsum(T0sum(372)%cmp, -4)
  call scale_one_tsum(T0sum(373)%cmp, -4)
  call scale_one_tsum(T0sum(374)%cmp, -4)
  call scale_one_tsum(T0sum(375)%cmp, -4)
  call scale_one_tsum(T0sum(376)%cmp, -4)
  call scale_one_tsum(T0sum(377)%cmp, -4)
  call scale_one_tsum(T0sum(378)%cmp, -4)
  call scale_one_tsum(T0sum(379)%cmp, -4)
  call scale_one_tsum(T0sum(380)%cmp, -4)
  call scale_one_tsum(T0sum(381)%cmp, -4)
  call scale_one_tsum(T0sum(382)%cmp, -4)
  call scale_one_tsum(T0sum(383)%cmp, -4)
  call scale_one_tsum(T0sum(384)%cmp, -4)
  call scale_one_tsum(T0sum(385)%cmp, -4)
  call scale_one_tsum(T0sum(386)%cmp, -4)
  call scale_one_tsum(T0sum(387)%cmp, -4)
  call scale_one_tsum(T0sum(388)%cmp, -4)
  call scale_one_tsum(T0sum(389)%cmp, -4)
  call scale_one_tsum(T0sum(390)%cmp, -4)
  call scale_one_tsum(T0sum(391)%cmp, -4)
  call scale_one_tsum(T0sum(392)%cmp, -4)
  call scale_one_tsum(T0sum(393)%cmp, -4)
  call scale_one_tsum(T0sum(394)%cmp, -4)
  call scale_one_tsum(T0sum(395)%cmp, -4)
  call scale_one_tsum(T0sum(396)%cmp, -4)
  call scale_one_tsum(T0sum(397)%cmp, -4)
  call scale_one_tsum(T0sum(398)%cmp, -4)
  call scale_one_tsum(T0sum(399)%cmp, -4)
  call scale_one_tsum(T0sum(400)%cmp, -4)
  call scale_one_tsum(T0sum(401)%cmp, -4)
  call scale_one_tsum(T0sum(402)%cmp, -4)
  call scale_one_tsum(T0sum(403)%cmp, -4)
  call scale_one_tsum(T0sum(404)%cmp, -4)
  call scale_one_tsum(T0sum(405)%cmp, -4)
  call scale_one_tsum(T0sum(406)%cmp, -4)
  call scale_one_tsum(T0sum(407)%cmp, -4)
  call scale_one_tsum(T0sum(408)%cmp, -4)
  call scale_one_tsum(T0sum(409)%cmp, -4)
  call scale_one_tsum(T0sum(410)%cmp, -4)
  call scale_one_tsum(T0sum(411)%cmp, -4)
  call scale_one_tsum(T0sum(412)%cmp, -4)
  call scale_one_tsum(T0sum(413)%cmp, -4)
  call scale_one_tsum(T0sum(414)%cmp, -4)
  call scale_one_tsum(T0sum(415)%cmp, -4)
  call scale_one_tsum(T0sum(416)%cmp, -4)
  call scale_one_tsum(T0sum(417)%cmp, -4)
  call scale_one_tsum(T0sum(418)%cmp, -4)
  call scale_one_tsum(T0sum(419)%cmp, -4)
  call scale_one_tsum(T0sum(420)%cmp, -4)
  call scale_one_tsum(T0sum(421)%cmp, -4)
  call scale_one_tsum(T0sum(422)%cmp, -4)
  call scale_one_tsum(T0sum(423)%cmp, -4)
  call scale_one_tsum(T0sum(424)%cmp, -4)
  call scale_one_tsum(T0sum(425)%cmp, -4)
  call scale_one_tsum(T0sum(426)%cmp, -4)
  call scale_one_tsum(T0sum(427)%cmp, -4)
  call scale_one_tsum(T0sum(428)%cmp, -4)
  call scale_one_tsum(T0sum(429)%cmp, -4)
  call scale_one_tsum(T0sum(430)%cmp, -4)
  call scale_one_tsum(T0sum(431)%cmp, -4)
  call scale_one_tsum(T0sum(432)%cmp, -4)
  call scale_one_tsum(T0sum(433)%cmp, -4)
  call scale_one_tsum(T0sum(434)%cmp, -4)
  call scale_one_tsum(T0sum(435)%cmp, -4)
  call scale_one_tsum(T0sum(436)%cmp, -4)
  call scale_one_tsum(T0sum(437)%cmp, -4)
  call scale_one_tsum(T0sum(438)%cmp, -4)

end subroutine scale_tensor_sum

! **********************************************************************
subroutine set_integral_masses_and_momenta()
! **********************************************************************

  use ol_parameters_decl_/**/REALKIND
  momenta_1 = [ 0, 0 ]
  momenta_2 = [ 32, 31 ]
  momenta_3 = [ 35, 28 ]
  momenta_4 = [ 36, 27 ]
  momenta_5 = [ 37, 26 ]
  momenta_6 = [ 38, 25 ]
  momenta_7 = [ 39, 24 ]
  momenta_8 = [ 40, 23 ]
  momenta_9 = [ 41, 22 ]
  momenta_10 = [ 42, 21 ]
  momenta_11 = [ 43, 20 ]
  momenta_12 = [ 44, 19 ]
  momenta_13 = [ 47, 16 ]
  momenta_14 = [ 48, 15 ]
  momenta_15 = [ 51, 12 ]
  momenta_16 = [ 52, 11 ]
  momenta_17 = [ 53, 10 ]
  momenta_18 = [ 54, 9 ]
  momenta_19 = [ 55, 8 ]
  momenta_20 = [ 56, 7 ]
  momenta_21 = [ 57, 6 ]
  momenta_22 = [ 58, 5 ]
  momenta_23 = [ 59, 4 ]
  momenta_24 = [ 60, 3 ]
  momenta_25 = [ 61, 2 ]
  momenta_26 = [ 62, 1 ]
  momenta_27 = [ 32, 3, 28 ]
  momenta_28 = [ 32, 4, 27 ]
  momenta_29 = [ 32, 5, 26 ]
  momenta_30 = [ 32, 6, 25 ]
  momenta_31 = [ 32, 7, 24 ]
  momenta_32 = [ 32, 8, 23 ]
  momenta_33 = [ 32, 9, 22 ]
  momenta_34 = [ 32, 10, 21 ]
  momenta_35 = [ 32, 11, 20 ]
  momenta_36 = [ 32, 12, 19 ]
  momenta_37 = [ 32, 15, 16 ]
  momenta_38 = [ 32, 19, 12 ]
  momenta_39 = [ 32, 23, 8 ]
  momenta_40 = [ 32, 27, 4 ]
  momenta_41 = [ 35, 4, 24 ]
  momenta_42 = [ 35, 8, 20 ]
  momenta_43 = [ 35, 12, 16 ]
  momenta_44 = [ 35, 16, 12 ]
  momenta_45 = [ 35, 20, 8 ]
  momenta_46 = [ 35, 24, 4 ]
  momenta_47 = [ 36, 1, 26 ]
  momenta_48 = [ 36, 2, 25 ]
  momenta_49 = [ 36, 3, 24 ]
  momenta_50 = [ 36, 8, 19 ]
  momenta_51 = [ 36, 11, 16 ]
  momenta_52 = [ 36, 19, 8 ]
  momenta_53 = [ 37, 2, 24 ]
  momenta_54 = [ 37, 10, 16 ]
  momenta_55 = [ 38, 1, 24 ]
  momenta_56 = [ 38, 9, 16 ]
  momenta_57 = [ 39, 8, 16 ]
  momenta_58 = [ 39, 16, 8 ]
  momenta_59 = [ 40, 1, 22 ]
  momenta_60 = [ 40, 2, 21 ]
  momenta_61 = [ 40, 3, 20 ]
  momenta_62 = [ 40, 4, 19 ]
  momenta_63 = [ 40, 7, 16 ]
  momenta_64 = [ 40, 19, 4 ]
  momenta_65 = [ 41, 2, 20 ]
  momenta_66 = [ 41, 6, 16 ]
  momenta_67 = [ 42, 1, 20 ]
  momenta_68 = [ 42, 5, 16 ]
  momenta_69 = [ 43, 4, 16 ]
  momenta_70 = [ 43, 16, 4 ]
  momenta_71 = [ 44, 3, 16 ]
  momenta_72 = [ 48, 3, 12 ]
  momenta_73 = [ 48, 4, 11 ]
  momenta_74 = [ 48, 5, 10 ]
  momenta_75 = [ 48, 6, 9 ]
  momenta_76 = [ 48, 7, 8 ]
  momenta_77 = [ 48, 8, 7 ]
  momenta_78 = [ 48, 9, 6 ]
  momenta_79 = [ 48, 10, 5 ]
  momenta_80 = [ 48, 11, 4 ]
  momenta_81 = [ 48, 12, 3 ]
  momenta_82 = [ 51, 4, 8 ]
  momenta_83 = [ 51, 8, 4 ]
  momenta_84 = [ 52, 1, 10 ]
  momenta_85 = [ 52, 2, 9 ]
  momenta_86 = [ 52, 3, 8 ]
  momenta_87 = [ 52, 8, 3 ]
  momenta_88 = [ 52, 9, 2 ]
  momenta_89 = [ 52, 10, 1 ]
  momenta_90 = [ 53, 2, 8 ]
  momenta_91 = [ 53, 8, 2 ]
  momenta_92 = [ 54, 1, 8 ]
  momenta_93 = [ 54, 8, 1 ]
  momenta_94 = [ 56, 1, 6 ]
  momenta_95 = [ 56, 2, 5 ]
  momenta_96 = [ 56, 3, 4 ]
  momenta_97 = [ 56, 4, 3 ]
  momenta_98 = [ 56, 5, 2 ]
  momenta_99 = [ 56, 6, 1 ]
  momenta_100 = [ 57, 2, 4 ]
  momenta_101 = [ 57, 4, 2 ]
  momenta_102 = [ 58, 1, 4 ]
  momenta_103 = [ 58, 4, 1 ]
  momenta_104 = [ 60, 1, 2 ]
  momenta_105 = [ 60, 2, 1 ]
  momenta_106 = [ 32, 3, 4, 24 ]
  momenta_107 = [ 32, 3, 8, 20 ]
  momenta_108 = [ 32, 3, 12, 16 ]
  momenta_109 = [ 32, 3, 16, 12 ]
  momenta_110 = [ 32, 3, 20, 8 ]
  momenta_111 = [ 32, 3, 24, 4 ]
  momenta_112 = [ 32, 4, 1, 26 ]
  momenta_113 = [ 32, 4, 2, 25 ]
  momenta_114 = [ 32, 4, 3, 24 ]
  momenta_115 = [ 32, 4, 8, 19 ]
  momenta_116 = [ 32, 4, 11, 16 ]
  momenta_117 = [ 32, 5, 2, 24 ]
  momenta_118 = [ 32, 5, 10, 16 ]
  momenta_119 = [ 32, 6, 1, 24 ]
  momenta_120 = [ 32, 6, 9, 16 ]
  momenta_121 = [ 32, 7, 8, 16 ]
  momenta_122 = [ 32, 8, 1, 22 ]
  momenta_123 = [ 32, 8, 2, 21 ]
  momenta_124 = [ 32, 8, 3, 20 ]
  momenta_125 = [ 32, 8, 4, 19 ]
  momenta_126 = [ 32, 8, 7, 16 ]
  momenta_127 = [ 32, 9, 2, 20 ]
  momenta_128 = [ 32, 9, 6, 16 ]
  momenta_129 = [ 32, 10, 1, 20 ]
  momenta_130 = [ 32, 10, 5, 16 ]
  momenta_131 = [ 32, 11, 4, 16 ]
  momenta_132 = [ 32, 12, 3, 16 ]
  momenta_133 = [ 32, 19, 4, 8 ]
  momenta_134 = [ 32, 19, 8, 4 ]
  momenta_135 = [ 35, 4, 8, 16 ]
  momenta_136 = [ 35, 8, 4, 16 ]
  momenta_137 = [ 35, 16, 4, 8 ]
  momenta_138 = [ 35, 16, 8, 4 ]
  momenta_139 = [ 36, 1, 2, 24 ]
  momenta_140 = [ 36, 1, 10, 16 ]
  momenta_141 = [ 36, 2, 1, 24 ]
  momenta_142 = [ 36, 2, 9, 16 ]
  momenta_143 = [ 36, 3, 8, 16 ]
  momenta_144 = [ 36, 3, 16, 8 ]
  momenta_145 = [ 36, 8, 3, 16 ]
  momenta_146 = [ 37, 2, 8, 16 ]
  momenta_147 = [ 38, 1, 8, 16 ]
  momenta_148 = [ 40, 1, 2, 20 ]
  momenta_149 = [ 40, 1, 6, 16 ]
  momenta_150 = [ 40, 2, 1, 20 ]
  momenta_151 = [ 40, 2, 5, 16 ]
  momenta_152 = [ 40, 3, 4, 16 ]
  momenta_153 = [ 40, 3, 16, 4 ]
  momenta_154 = [ 40, 4, 3, 16 ]
  momenta_155 = [ 41, 2, 4, 16 ]
  momenta_156 = [ 42, 1, 4, 16 ]
  momenta_157 = [ 48, 3, 4, 8 ]
  momenta_158 = [ 48, 3, 8, 4 ]
  momenta_159 = [ 48, 4, 1, 10 ]
  momenta_160 = [ 48, 4, 2, 9 ]
  momenta_161 = [ 48, 4, 3, 8 ]
  momenta_162 = [ 48, 4, 8, 3 ]
  momenta_163 = [ 48, 5, 2, 8 ]
  momenta_164 = [ 48, 6, 1, 8 ]
  momenta_165 = [ 48, 8, 1, 6 ]
  momenta_166 = [ 48, 8, 2, 5 ]
  momenta_167 = [ 48, 8, 3, 4 ]
  momenta_168 = [ 48, 8, 4, 3 ]
  momenta_169 = [ 48, 9, 2, 4 ]
  momenta_170 = [ 48, 10, 1, 4 ]
  momenta_171 = [ 52, 1, 2, 8 ]
  momenta_172 = [ 52, 2, 1, 8 ]
  momenta_173 = [ 52, 8, 1, 2 ]
  momenta_174 = [ 52, 8, 2, 1 ]
  momenta_175 = [ 56, 1, 2, 4 ]
  momenta_176 = [ 56, 2, 1, 4 ]
  momenta_177 = [ 56, 4, 1, 2 ]
  momenta_178 = [ 56, 4, 2, 1 ]
  momenta_179 = [ 32, 3, 4, 8, 16 ]
  momenta_180 = [ 32, 3, 8, 4, 16 ]
  momenta_181 = [ 32, 3, 16, 4, 8 ]
  momenta_182 = [ 32, 3, 16, 8, 4 ]
  momenta_183 = [ 32, 4, 1, 2, 24 ]
  momenta_184 = [ 32, 4, 1, 10, 16 ]
  momenta_185 = [ 32, 4, 2, 1, 24 ]
  momenta_186 = [ 32, 4, 2, 9, 16 ]
  momenta_187 = [ 32, 4, 3, 8, 16 ]
  momenta_188 = [ 32, 4, 8, 3, 16 ]
  momenta_189 = [ 32, 5, 2, 8, 16 ]
  momenta_190 = [ 32, 6, 1, 8, 16 ]
  momenta_191 = [ 32, 8, 1, 2, 20 ]
  momenta_192 = [ 32, 8, 1, 6, 16 ]
  momenta_193 = [ 32, 8, 2, 1, 20 ]
  momenta_194 = [ 32, 8, 2, 5, 16 ]
  momenta_195 = [ 32, 8, 3, 4, 16 ]
  momenta_196 = [ 32, 8, 4, 3, 16 ]
  momenta_197 = [ 32, 9, 2, 4, 16 ]
  momenta_198 = [ 32, 10, 1, 4, 16 ]
  momenta_199 = [ 36, 1, 2, 8, 16 ]
  momenta_200 = [ 36, 2, 1, 8, 16 ]
  momenta_201 = [ 40, 1, 2, 4, 16 ]
  momenta_202 = [ 40, 2, 1, 4, 16 ]
  momenta_203 = [ 48, 4, 1, 2, 8 ]
  momenta_204 = [ 48, 4, 2, 1, 8 ]
  momenta_205 = [ 48, 8, 1, 2, 4 ]
  momenta_206 = [ 48, 8, 2, 1, 4 ]
  momenta_207 = [ 32, 4, 1, 2, 8, 16 ]
  momenta_208 = [ 32, 4, 2, 1, 8, 16 ]
  momenta_209 = [ 32, 8, 1, 2, 4, 16 ]
  momenta_210 = [ 32, 8, 2, 1, 4, 16 ]

  masses2_1 = [ 0, 0 ]
  masses2_2 = [ nMB, 0 ]
  masses2_3 = [ nMH, 0 ]
  masses2_4 = [ nML, 0 ]
  masses2_5 = [ nMM, 0 ]
  masses2_6 = [ nMT, 0 ]
  masses2_7 = [ nMW, 0 ]
  masses2_8 = [ nMZ, 0 ]
  masses2_9 = [ nMB, nMB ]
  masses2_10 = [ nMZ, nMH ]
  masses2_11 = [ nML, nML ]
  masses2_12 = [ nMM, nMM ]
  masses2_13 = [ nMT, nMT ]
  masses2_14 = [ 0, nMW ]
  masses2_15 = [ nMW, nMW ]
  masses2_16 = [ 0, nMZ ]
  masses2_17 = [ nMZ, nMZ ]
  masses2_18 = [ 0, 0, 0 ]
  masses2_19 = [ nMW, 0, 0 ]
  masses2_20 = [ nMZ, 0, 0 ]
  masses2_21 = [ 0, 0, nMW ]
  masses2_22 = [ nMW, 0, nMW ]
  masses2_23 = [ 0, 0, nMZ ]
  masses2_24 = [ nMZ, 0, nMZ ]
  masses2_25 = [ nMB, nMB, nMB ]
  masses2_26 = [ nMT, nMT, nMT ]
  masses2_27 = [ 0, nMW, 0 ]
  masses2_28 = [ nMW, nMW, 0 ]
  masses2_29 = [ 0, nMW, nMW ]
  masses2_30 = [ 0, nMZ, 0 ]
  masses2_31 = [ nMZ, nMZ, 0 ]
  masses2_32 = [ 0, nMZ, nMZ ]
  masses2_33 = [ 0, 0, 0, 0 ]
  masses2_34 = [ nMW, 0, 0, 0 ]
  masses2_35 = [ nMZ, 0, 0, 0 ]
  masses2_36 = [ 0, 0, 0, nMW ]
  masses2_37 = [ 0, 0, 0, nMZ ]
  masses2_38 = [ 0, 0, nMW, 0 ]
  masses2_39 = [ nMW, 0, nMW, 0 ]
  masses2_40 = [ 0, 0, nMW, nMW ]
  masses2_41 = [ 0, 0, nMZ, 0 ]
  masses2_42 = [ nMZ, 0, nMZ, 0 ]
  masses2_43 = [ 0, 0, nMZ, nMZ ]
  masses2_44 = [ nMB, nMB, nMB, nMB ]
  masses2_45 = [ nMT, nMT, nMT, nMT ]
  masses2_46 = [ 0, nMW, 0, 0 ]
  masses2_47 = [ 0, nMW, 0, nMW ]
  masses2_48 = [ 0, nMW, nMW, 0 ]
  masses2_49 = [ 0, nMZ, 0, 0 ]
  masses2_50 = [ 0, nMZ, 0, nMZ ]
  masses2_51 = [ 0, nMZ, nMZ, 0 ]
  masses2_52 = [ 0, 0, 0, 0, 0 ]
  masses2_53 = [ 0, 0, 0, 0, nMW ]
  masses2_54 = [ 0, 0, 0, 0, nMZ ]
  masses2_55 = [ 0, 0, 0, nMW, 0 ]
  masses2_56 = [ 0, 0, 0, nMZ, 0 ]
  masses2_57 = [ 0, 0, nMW, 0, 0 ]
  masses2_58 = [ 0, 0, nMW, 0, nMW ]
  masses2_59 = [ 0, 0, nMW, nMW, 0 ]
  masses2_60 = [ 0, 0, nMZ, 0, 0 ]
  masses2_61 = [ 0, 0, nMZ, 0, nMZ ]
  masses2_62 = [ 0, 0, nMZ, nMZ, 0 ]
  masses2_63 = [ 0, nMW, 0, nMW, 0 ]
  masses2_64 = [ 0, nMZ, 0, nMZ, 0 ]
  masses2_65 = [ 0, 0, nMW, 0, nMW, 0 ]
  masses2_66 = [ 0, 0, nMZ, 0, nMZ, 0 ]


end subroutine  set_integral_masses_and_momenta

! **********************************************************************
subroutine integrate_tensor_sum(M2out)
! **********************************************************************
  use ol_parameters_decl_/**/REALKIND ! only: ZERO, masses
#ifndef PRECISION_dp
  use ol_parameters_decl_/**/DREALKIND, only: a_switch
#endif
  use ol_parameters_init_/**/REALKIND, only: init_met, add_met, met_to_real
  use ol_loop_routines_/**/REALKIND, only: TI_call_OL
  implicit none
  real(REALKIND), intent(out) :: M2out
  type(met) :: M2
  call init_met(M2)

sbarray_1 = [1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15]
sbarray_2 = [16, 17, 18, 19, 20, 21, 22, 23, 24, 25, 26, 27, 28, 29, 30]
sbarray_3 = [31, 2, 32, 33, 34, 6, 35, 36, 37, 10, 11, 12, 38, 39, 40]
sbarray_4 = [41, 42, 43, 44, 45, 46, 35, 47, 48, 49, 50, 51, 52, 53, 54]
sbarray_5 = [55, 17, 56, 57, 58, 21, 59, 60, 61, 25, 26, 27, 62, 63, 64]
sbarray_6 = [65, 66, 67, 68, 69, 70, 59, 71, 72, 73, 74, 75, 76, 77, 78]
sbarray_7 = [79, 80, 81, 82, 15]
sbarray_8 = [83, 84, 85, 86, 30]
sbarray_9 = [87, 88, 81, 89, 40]
sbarray_10 = [90, 91, 92, 93, 54]
sbarray_11 = [94, 95, 85, 96, 64]
sbarray_12 = [97, 98, 99, 100, 78]
sbarray_13 = [1, 2, 3, 4, 5]
sbarray_14 = [1, 6, 7, 8, 9]
sbarray_15 = [2, 6, 10, 11, 12]
sbarray_16 = [3, 7, 10, 13, 14]
sbarray_17 = [16, 17, 18, 19, 20]
sbarray_18 = [16, 21, 22, 23, 24]
sbarray_19 = [17, 21, 25, 26, 27]
sbarray_20 = [18, 22, 25, 28, 29]
sbarray_21 = [31, 2, 32, 33, 34]
sbarray_22 = [31, 6, 35, 36, 37]
sbarray_23 = [32, 35, 10, 38, 39]
sbarray_24 = [41, 42, 43, 44, 45]
sbarray_25 = [41, 46, 35, 47, 48]
sbarray_26 = [42, 46, 49, 50, 51]
sbarray_27 = [43, 35, 49, 52, 53]
sbarray_28 = [55, 17, 56, 57, 58]
sbarray_29 = [55, 21, 59, 60, 61]
sbarray_30 = [56, 59, 25, 62, 63]
sbarray_31 = [65, 66, 67, 68, 69]
sbarray_32 = [65, 70, 59, 71, 72]
sbarray_33 = [66, 70, 73, 74, 75]
sbarray_34 = [67, 59, 73, 76, 77]
sbarray_35 = [33, 36, 11, 38, 40]
sbarray_36 = [44, 47, 50, 52, 54]
sbarray_37 = [4, 8, 11, 13, 15]
sbarray_38 = [19, 23, 26, 28, 30]
sbarray_39 = [57, 60, 26, 62, 64]
sbarray_40 = [68, 71, 74, 76, 78]
sbarray_41 = [101, 102, 103, 104, 105]
sbarray_42 = [106, 107, 108, 104, 109]
sbarray_43 = [110, 111, 112, 104, 113]
sbarray_44 = [114, 115, 116, 104, 117]
sbarray_45 = [118, 119, 120, 104, 121]
sbarray_46 = [122, 123, 124, 104, 125]
sbarray_47 = [126, 127, 128, 129, 130]
sbarray_48 = [131, 6, 128, 132, 133]
sbarray_49 = [134, 46, 128, 135, 136]
sbarray_50 = [137, 138, 139, 140, 141]
sbarray_51 = [142, 138, 25, 143, 144]
sbarray_52 = [145, 138, 73, 146, 147]
sbarray_53 = [148, 149, 128, 150, 151]
sbarray_54 = [152, 21, 128, 153, 154]
sbarray_55 = [155, 70, 128, 156, 157]
sbarray_56 = [158, 138, 159, 160, 161]
sbarray_57 = [162, 138, 10, 163, 164]
sbarray_58 = [165, 138, 49, 166, 167]


#ifdef LOOPSQUARED
  if (a_switch == 1 .or. a_switch == 7) then
#endif
  call TI_call_OL(0,0, momenta_174, masses2_42, T0sum(1), M2,[15], ScalarBoxes(:))
  call TI_call_OL(0,0, momenta_166, masses2_41, T0sum(2), M2,[82], ScalarBoxes(:))
  call TI_call_OL(0,0, momenta_123, masses2_41, T0sum(3), M2,[13], ScalarBoxes(:))
  call TI_call_OL(0,0, momenta_177, masses2_42, T0sum(4), M2,[30], ScalarBoxes(:))
  call TI_call_OL(0,0, momenta_159, masses2_41, T0sum(5), M2,[86], ScalarBoxes(:))
  call TI_call_OL(0,0, momenta_112, masses2_41, T0sum(6), M2,[28], ScalarBoxes(:))
  call TI_call_OL(0,0, momenta_173, masses2_42, T0sum(7), M2,[40], ScalarBoxes(:))
  call TI_call_OL(0,0, momenta_165, masses2_41, T0sum(8), M2,[89], ScalarBoxes(:))
  call TI_call_OL(0,0, momenta_122, masses2_41, T0sum(9), M2,[38], ScalarBoxes(:))
  call TI_call_OL(0,0, momenta_173, masses2_39, T0sum(10), M2,[54], ScalarBoxes(:))
  call TI_call_OL(0,0, momenta_165, masses2_38, T0sum(11), M2,[93], ScalarBoxes(:))
  call TI_call_OL(0,0, momenta_122, masses2_38, T0sum(12), M2,[52], ScalarBoxes(:))
  call TI_call_OL(0,0, momenta_178, masses2_42, T0sum(13), M2,[64], ScalarBoxes(:))
  call TI_call_OL(0,0, momenta_160, masses2_41, T0sum(14), M2,[96], ScalarBoxes(:))
  call TI_call_OL(0,0, momenta_113, masses2_41, T0sum(15), M2,[62], ScalarBoxes(:))
  call TI_call_OL(0,0, momenta_178, masses2_39, T0sum(16), M2,[78], ScalarBoxes(:))
  call TI_call_OL(0,0, momenta_160, masses2_38, T0sum(17), M2,[100], ScalarBoxes(:))
  call TI_call_OL(0,0, momenta_113, masses2_38, T0sum(18), M2,[76], ScalarBoxes(:))
  call TI_call_OL(0,0, momenta_176, masses2_50, T0sum(19), M2,[79], ScalarBoxes(:))
  call TI_call_OL(0,0, momenta_150, masses2_50, T0sum(20), M2,[4], ScalarBoxes(:))
  call TI_call_OL(0,0, momenta_170, masses2_37, T0sum(21), M2,[80], ScalarBoxes(:))
  call TI_call_OL(0,0, momenta_129, masses2_37, T0sum(22), M2,[8], ScalarBoxes(:))
  call TI_call_OL(0,0, momenta_167, masses2_43, T0sum(23), M2,[81], ScalarBoxes(:))
  call TI_call_OL(0,0, momenta_124, masses2_43, T0sum(24), M2,[11], ScalarBoxes(:))
  call TI_call_OL(0,0, momenta_171, masses2_50, T0sum(25), M2,[83], ScalarBoxes(:))
  call TI_call_OL(0,0, momenta_139, masses2_50, T0sum(26), M2,[19], ScalarBoxes(:))
  call TI_call_OL(0,0, momenta_163, masses2_37, T0sum(27), M2,[84], ScalarBoxes(:))
  call TI_call_OL(0,0, momenta_117, masses2_37, T0sum(28), M2,[23], ScalarBoxes(:))
  call TI_call_OL(0,0, momenta_161, masses2_43, T0sum(29), M2,[85], ScalarBoxes(:))
  call TI_call_OL(0,0, momenta_114, masses2_43, T0sum(30), M2,[26], ScalarBoxes(:))
  call TI_call_OL(0,0, momenta_175, masses2_50, T0sum(31), M2,[87], ScalarBoxes(:))
  call TI_call_OL(0,0, momenta_148, masses2_50, T0sum(32), M2,[33], ScalarBoxes(:))
  call TI_call_OL(0,0, momenta_169, masses2_37, T0sum(33), M2,[88], ScalarBoxes(:))
  call TI_call_OL(0,0, momenta_127, masses2_37, T0sum(34), M2,[36], ScalarBoxes(:))
  call TI_call_OL(0,0, momenta_175, masses2_47, T0sum(35), M2,[90], ScalarBoxes(:))
  call TI_call_OL(0,0, momenta_148, masses2_47, T0sum(36), M2,[44], ScalarBoxes(:))
  call TI_call_OL(0,0, momenta_169, masses2_36, T0sum(37), M2,[91], ScalarBoxes(:))
  call TI_call_OL(0,0, momenta_127, masses2_36, T0sum(38), M2,[47], ScalarBoxes(:))
  call TI_call_OL(0,0, momenta_167, masses2_40, T0sum(39), M2,[92], ScalarBoxes(:))
  call TI_call_OL(0,0, momenta_124, masses2_40, T0sum(40), M2,[50], ScalarBoxes(:))
  call TI_call_OL(0,0, momenta_172, masses2_50, T0sum(41), M2,[94], ScalarBoxes(:))
  call TI_call_OL(0,0, momenta_141, masses2_50, T0sum(42), M2,[57], ScalarBoxes(:))
  call TI_call_OL(0,0, momenta_164, masses2_37, T0sum(43), M2,[95], ScalarBoxes(:))
  call TI_call_OL(0,0, momenta_119, masses2_37, T0sum(44), M2,[60], ScalarBoxes(:))
  call TI_call_OL(0,0, momenta_172, masses2_47, T0sum(45), M2,[97], ScalarBoxes(:))
  call TI_call_OL(0,0, momenta_141, masses2_47, T0sum(46), M2,[68], ScalarBoxes(:))
  call TI_call_OL(0,0, momenta_164, masses2_36, T0sum(47), M2,[98], ScalarBoxes(:))
  call TI_call_OL(0,0, momenta_119, masses2_36, T0sum(48), M2,[71], ScalarBoxes(:))
  call TI_call_OL(0,0, momenta_161, masses2_40, T0sum(49), M2,[99], ScalarBoxes(:))
  call TI_call_OL(0,0, momenta_114, masses2_40, T0sum(50), M2,[74], ScalarBoxes(:))
  call TI_call_OL(0,0, momenta_153, masses2_33, T0sum(51), M2,[105], ScalarBoxes(:))
  call TI_call_OL(0,0, momenta_109, masses2_33, T0sum(52), M2,[104], ScalarBoxes(:))
  call TI_call_OL(0,0, momenta_153, masses2_35, T0sum(53), M2,[109], ScalarBoxes(:))
  call TI_call_OL(0,0, momenta_153, masses2_34, T0sum(54), M2,[113], ScalarBoxes(:))
  call TI_call_OL(0,0, momenta_144, masses2_33, T0sum(55), M2,[117], ScalarBoxes(:))
  call TI_call_OL(0,0, momenta_144, masses2_35, T0sum(56), M2,[121], ScalarBoxes(:))
  call TI_call_OL(0,0, momenta_144, masses2_34, T0sum(57), M2,[125], ScalarBoxes(:))
  call TI_call_OL(0,0, momenta_158, masses2_33, T0sum(58), M2,[130], ScalarBoxes(:))
  call TI_call_OL(0,0, momenta_107, masses2_33, T0sum(59), M2,[129], ScalarBoxes(:))
  call TI_call_OL(0,0, momenta_158, masses2_37, T0sum(60), M2,[133], ScalarBoxes(:))
  call TI_call_OL(0,0, momenta_107, masses2_37, T0sum(61), M2,[132], ScalarBoxes(:))
  call TI_call_OL(0,0, momenta_158, masses2_36, T0sum(62), M2,[136], ScalarBoxes(:))
  call TI_call_OL(0,0, momenta_107, masses2_36, T0sum(63), M2,[135], ScalarBoxes(:))
  call TI_call_OL(0,0, momenta_162, masses2_33, T0sum(64), M2,[141], ScalarBoxes(:))
  call TI_call_OL(0,0, momenta_115, masses2_33, T0sum(65), M2,[140], ScalarBoxes(:))
  call TI_call_OL(0,0, momenta_162, masses2_41, T0sum(66), M2,[144], ScalarBoxes(:))
  call TI_call_OL(0,0, momenta_115, masses2_41, T0sum(67), M2,[143], ScalarBoxes(:))
  call TI_call_OL(0,0, momenta_162, masses2_38, T0sum(68), M2,[147], ScalarBoxes(:))
  call TI_call_OL(0,0, momenta_115, masses2_38, T0sum(69), M2,[146], ScalarBoxes(:))
  call TI_call_OL(0,0, momenta_157, masses2_33, T0sum(70), M2,[151], ScalarBoxes(:))
  call TI_call_OL(0,0, momenta_106, masses2_33, T0sum(71), M2,[150], ScalarBoxes(:))
  call TI_call_OL(0,0, momenta_157, masses2_37, T0sum(72), M2,[154], ScalarBoxes(:))
  call TI_call_OL(0,0, momenta_106, masses2_37, T0sum(73), M2,[153], ScalarBoxes(:))
  call TI_call_OL(0,0, momenta_157, masses2_36, T0sum(74), M2,[157], ScalarBoxes(:))
  call TI_call_OL(0,0, momenta_106, masses2_36, T0sum(75), M2,[156], ScalarBoxes(:))
  call TI_call_OL(0,0, momenta_168, masses2_33, T0sum(76), M2,[161], ScalarBoxes(:))
  call TI_call_OL(0,0, momenta_125, masses2_33, T0sum(77), M2,[160], ScalarBoxes(:))
  call TI_call_OL(0,0, momenta_168, masses2_41, T0sum(78), M2,[164], ScalarBoxes(:))
  call TI_call_OL(0,0, momenta_125, masses2_41, T0sum(79), M2,[163], ScalarBoxes(:))
  call TI_call_OL(0,0, momenta_168, masses2_38, T0sum(80), M2,[167], ScalarBoxes(:))
  call TI_call_OL(0,0, momenta_125, masses2_38, T0sum(81), M2,[166], ScalarBoxes(:))
  call TI_call_OL(0,0, momenta_156, masses2_41, T0sum(82), M2,[1], ScalarBoxes(:))
  call TI_call_OL(0,0, momenta_152, masses2_51, T0sum(83), M2,[2], ScalarBoxes(:))
  call TI_call_OL(0,0, momenta_151, masses2_49, T0sum(84), M2,[3], ScalarBoxes(:))
  call TI_call_OL(0,0, momenta_131, masses2_41, T0sum(85), M2,[6], ScalarBoxes(:))
  call TI_call_OL(0,0, momenta_130, masses2_33, T0sum(86), M2,[7], ScalarBoxes(:))
  call TI_call_OL(0,0, momenta_126, masses2_41, T0sum(87), M2,[10], ScalarBoxes(:))
  call TI_call_OL(0,0, momenta_146, masses2_41, T0sum(88), M2,[16], ScalarBoxes(:))
  call TI_call_OL(0,0, momenta_143, masses2_51, T0sum(89), M2,[17], ScalarBoxes(:))
  call TI_call_OL(0,0, momenta_140, masses2_49, T0sum(90), M2,[18], ScalarBoxes(:))
  call TI_call_OL(0,0, momenta_121, masses2_41, T0sum(91), M2,[21], ScalarBoxes(:))
  call TI_call_OL(0,0, momenta_118, masses2_33, T0sum(92), M2,[22], ScalarBoxes(:))
  call TI_call_OL(0,0, momenta_116, masses2_41, T0sum(93), M2,[25], ScalarBoxes(:))
  call TI_call_OL(0,0, momenta_155, masses2_41, T0sum(94), M2,[31], ScalarBoxes(:))
  call TI_call_OL(0,0, momenta_149, masses2_49, T0sum(95), M2,[32], ScalarBoxes(:))
  call TI_call_OL(0,0, momenta_128, masses2_33, T0sum(96), M2,[35], ScalarBoxes(:))
  call TI_call_OL(0,0, momenta_155, masses2_38, T0sum(97), M2,[41], ScalarBoxes(:))
  call TI_call_OL(0,0, momenta_152, masses2_48, T0sum(98), M2,[42], ScalarBoxes(:))
  call TI_call_OL(0,0, momenta_149, masses2_46, T0sum(99), M2,[43], ScalarBoxes(:))
  call TI_call_OL(0,0, momenta_131, masses2_38, T0sum(100), M2,[46], ScalarBoxes(:))
  call TI_call_OL(0,0, momenta_126, masses2_38, T0sum(101), M2,[49], ScalarBoxes(:))
  call TI_call_OL(0,0, momenta_147, masses2_41, T0sum(102), M2,[55], ScalarBoxes(:))
  call TI_call_OL(0,0, momenta_142, masses2_49, T0sum(103), M2,[56], ScalarBoxes(:))
  call TI_call_OL(0,0, momenta_120, masses2_33, T0sum(104), M2,[59], ScalarBoxes(:))
  call TI_call_OL(0,0, momenta_147, masses2_38, T0sum(105), M2,[65], ScalarBoxes(:))
  call TI_call_OL(0,0, momenta_143, masses2_48, T0sum(106), M2,[66], ScalarBoxes(:))
  call TI_call_OL(0,0, momenta_142, masses2_46, T0sum(107), M2,[67], ScalarBoxes(:))
  call TI_call_OL(0,0, momenta_121, masses2_38, T0sum(108), M2,[70], ScalarBoxes(:))
  call TI_call_OL(0,0, momenta_116, masses2_38, T0sum(109), M2,[73], ScalarBoxes(:))
  call TI_call_OL(0,0, momenta_137, masses2_33, T0sum(110), M2,[101], ScalarBoxes(:))
  call TI_call_OL(0,0, momenta_133, masses2_33, T0sum(111), M2,[102], ScalarBoxes(:))
  call TI_call_OL(0,0, momenta_110, masses2_33, T0sum(112), M2,[103], ScalarBoxes(:))
  call TI_call_OL(0,0, momenta_137, masses2_37, T0sum(113), M2,[106], ScalarBoxes(:))
  call TI_call_OL(0,0, momenta_133, masses2_37, T0sum(114), M2,[107], ScalarBoxes(:))
  call TI_call_OL(0,0, momenta_110, masses2_37, T0sum(115), M2,[108], ScalarBoxes(:))
  call TI_call_OL(0,0, momenta_137, masses2_36, T0sum(116), M2,[110], ScalarBoxes(:))
  call TI_call_OL(0,0, momenta_133, masses2_36, T0sum(117), M2,[111], ScalarBoxes(:))
  call TI_call_OL(0,0, momenta_110, masses2_36, T0sum(118), M2,[112], ScalarBoxes(:))
  call TI_call_OL(0,0, momenta_138, masses2_33, T0sum(119), M2,[114], ScalarBoxes(:))
  call TI_call_OL(0,0, momenta_134, masses2_33, T0sum(120), M2,[115], ScalarBoxes(:))
  call TI_call_OL(0,0, momenta_111, masses2_33, T0sum(121), M2,[116], ScalarBoxes(:))
  call TI_call_OL(0,0, momenta_138, masses2_37, T0sum(122), M2,[118], ScalarBoxes(:))
  call TI_call_OL(0,0, momenta_134, masses2_37, T0sum(123), M2,[119], ScalarBoxes(:))
  call TI_call_OL(0,0, momenta_111, masses2_37, T0sum(124), M2,[120], ScalarBoxes(:))
  call TI_call_OL(0,0, momenta_138, masses2_36, T0sum(125), M2,[122], ScalarBoxes(:))
  call TI_call_OL(0,0, momenta_134, masses2_36, T0sum(126), M2,[123], ScalarBoxes(:))
  call TI_call_OL(0,0, momenta_111, masses2_36, T0sum(127), M2,[124], ScalarBoxes(:))
  call TI_call_OL(0,0, momenta_136, masses2_33, T0sum(128), M2,[126], ScalarBoxes(:))
  call TI_call_OL(0,0, momenta_131, masses2_33, T0sum(129), M2,[127], ScalarBoxes(:))
  call TI_call_OL(0,0, momenta_108, masses2_33, T0sum(130), M2,[128], ScalarBoxes(:))
  call TI_call_OL(0,0, momenta_136, masses2_41, T0sum(131), M2,[131], ScalarBoxes(:))
  call TI_call_OL(0,0, momenta_136, masses2_38, T0sum(132), M2,[134], ScalarBoxes(:))
  call TI_call_OL(0,0, momenta_145, masses2_33, T0sum(133), M2,[137], ScalarBoxes(:))
  call TI_call_OL(0,0, momenta_132, masses2_33, T0sum(134), M2,[138], ScalarBoxes(:))
  call TI_call_OL(0,0, momenta_116, masses2_33, T0sum(135), M2,[139], ScalarBoxes(:))
  call TI_call_OL(0,0, momenta_145, masses2_49, T0sum(136), M2,[142], ScalarBoxes(:))
  call TI_call_OL(0,0, momenta_145, masses2_46, T0sum(137), M2,[145], ScalarBoxes(:))
  call TI_call_OL(0,0, momenta_135, masses2_33, T0sum(138), M2,[148], ScalarBoxes(:))
  call TI_call_OL(0,0, momenta_121, masses2_33, T0sum(139), M2,[149], ScalarBoxes(:))
  call TI_call_OL(0,0, momenta_135, masses2_41, T0sum(140), M2,[152], ScalarBoxes(:))
  call TI_call_OL(0,0, momenta_135, masses2_38, T0sum(141), M2,[155], ScalarBoxes(:))
  call TI_call_OL(0,0, momenta_154, masses2_33, T0sum(142), M2,[158], ScalarBoxes(:))
  call TI_call_OL(0,0, momenta_126, masses2_33, T0sum(143), M2,[159], ScalarBoxes(:))
  call TI_call_OL(0,0, momenta_154, masses2_49, T0sum(144), M2,[162], ScalarBoxes(:))
  call TI_call_OL(0,0, momenta_154, masses2_46, T0sum(145), M2,[165], ScalarBoxes(:))
  call TI_call_OL(2,0, momenta_132, masses2_33, T0sum(146), M2,[138], ScalarBoxes(:))
  call TI_call_OL(2,0, momenta_132, masses2_45, T0sum(147), M2)
  call TI_call_OL(2,0, momenta_132, masses2_44, T0sum(148), M2)
  call TI_call_OL(2,0, momenta_108, masses2_33, T0sum(149), M2,[128], ScalarBoxes(:))
  call TI_call_OL(2,0, momenta_108, masses2_45, T0sum(150), M2)
  call TI_call_OL(2,0, momenta_108, masses2_44, T0sum(151), M2)
  call TI_call_OL(2,0, momenta_109, masses2_33, T0sum(152), M2,[104], ScalarBoxes(:))
  call TI_call_OL(2,0, momenta_109, masses2_45, T0sum(153), M2)
  call TI_call_OL(2,0, momenta_109, masses2_44, T0sum(154), M2)
  call TI_call_OL(0,0, momenta_132, masses2_45, T0sum(155), M2)
  call TI_call_OL(0,0, momenta_132, masses2_44, T0sum(156), M2)
  call TI_call_OL(0,0, momenta_108, masses2_45, T0sum(157), M2)
  call TI_call_OL(0,0, momenta_108, masses2_44, T0sum(158), M2)
  call TI_call_OL(0,0, momenta_109, masses2_45, T0sum(159), M2)
  call TI_call_OL(0,0, momenta_109, masses2_44, T0sum(160), M2)
  call TI_call_OL(0,0, momenta_71, masses2_18, T0sum(161), M2)
  call TI_call_OL(0,0, momenta_87, masses2_22, T0sum(162), M2)
  call TI_call_OL(0,0, momenta_97, masses2_22, T0sum(163), M2)
  call TI_call_OL(0,0, momenta_86, masses2_18, T0sum(164), M2)
  call TI_call_OL(0,0, momenta_86, masses2_20, T0sum(165), M2)
  call TI_call_OL(0,0, momenta_86, masses2_19, T0sum(166), M2)
  call TI_call_OL(0,0, momenta_82, masses2_18, T0sum(167), M2)
  call TI_call_OL(0,0, momenta_82, masses2_23, T0sum(168), M2)
  call TI_call_OL(0,0, momenta_82, masses2_21, T0sum(169), M2)
  call TI_call_OL(0,0, momenta_96, masses2_18, T0sum(170), M2)
  call TI_call_OL(0,0, momenta_96, masses2_20, T0sum(171), M2)
  call TI_call_OL(0,0, momenta_96, masses2_19, T0sum(172), M2)
  call TI_call_OL(0,0, momenta_83, masses2_18, T0sum(173), M2)
  call TI_call_OL(0,0, momenta_83, masses2_23, T0sum(174), M2)
  call TI_call_OL(0,0, momenta_83, masses2_21, T0sum(175), M2)
  call TI_call_OL(0,0, momenta_44, masses2_18, T0sum(176), M2)
  call TI_call_OL(0,0, momenta_38, masses2_18, T0sum(177), M2)
  call TI_call_OL(0,0, momenta_27, masses2_18, T0sum(178), M2)
  call TI_call_OL(0,0, momenta_61, masses2_29, T0sum(179), M2)
  call TI_call_OL(0,0, momenta_35, masses2_21, T0sum(180), M2)
  call TI_call_OL(0,0, momenta_32, masses2_21, T0sum(181), M2)
  call TI_call_OL(0,0, momenta_49, masses2_29, T0sum(182), M2)
  call TI_call_OL(0,0, momenta_31, masses2_21, T0sum(183), M2)
  call TI_call_OL(0,0, momenta_28, masses2_21, T0sum(184), M2)
  call TI_call_OL(0,0, momenta_42, masses2_18, T0sum(185), M2)
  call TI_call_OL(0,0, momenta_35, masses2_18, T0sum(186), M2)
  call TI_call_OL(0,0, momenta_42, masses2_23, T0sum(187), M2)
  call TI_call_OL(0,0, momenta_35, masses2_23, T0sum(188), M2)
  call TI_call_OL(0,0, momenta_42, masses2_21, T0sum(189), M2)
  call TI_call_OL(0,0, momenta_50, masses2_18, T0sum(190), M2)
  call TI_call_OL(0,0, momenta_36, masses2_18, T0sum(191), M2)
  call TI_call_OL(0,0, momenta_28, masses2_18, T0sum(192), M2)
  call TI_call_OL(0,0, momenta_50, masses2_30, T0sum(193), M2)
  call TI_call_OL(0,0, momenta_28, masses2_23, T0sum(194), M2)
  call TI_call_OL(0,0, momenta_50, masses2_27, T0sum(195), M2)
  call TI_call_OL(0,0, momenta_41, masses2_18, T0sum(196), M2)
  call TI_call_OL(0,0, momenta_31, masses2_18, T0sum(197), M2)
  call TI_call_OL(0,0, momenta_41, masses2_23, T0sum(198), M2)
  call TI_call_OL(0,0, momenta_31, masses2_23, T0sum(199), M2)
  call TI_call_OL(0,0, momenta_41, masses2_21, T0sum(200), M2)
  call TI_call_OL(0,0, momenta_62, masses2_18, T0sum(201), M2)
  call TI_call_OL(0,0, momenta_32, masses2_18, T0sum(202), M2)
  call TI_call_OL(0,0, momenta_62, masses2_30, T0sum(203), M2)
  call TI_call_OL(0,0, momenta_32, masses2_23, T0sum(204), M2)
  call TI_call_OL(0,0, momenta_62, masses2_27, T0sum(205), M2)
  call TI_call_OL(0,0, momenta_61, masses2_18, T0sum(206), M2)
  call TI_call_OL(0,0, momenta_61, masses2_20, T0sum(207), M2)
  call TI_call_OL(0,0, momenta_61, masses2_19, T0sum(208), M2)
  call TI_call_OL(0,0, momenta_49, masses2_18, T0sum(209), M2)
  call TI_call_OL(0,0, momenta_49, masses2_20, T0sum(210), M2)
  call TI_call_OL(0,0, momenta_49, masses2_19, T0sum(211), M2)
  call TI_call_OL(0,0, momenta_36, masses2_26, T0sum(212), M2)
  call TI_call_OL(0,0, momenta_36, masses2_25, T0sum(213), M2)
  call TI_call_OL(0,0, momenta_27, masses2_26, T0sum(214), M2)
  call TI_call_OL(0,0, momenta_27, masses2_25, T0sum(215), M2)
  call TI_call_OL(0,0, momenta_77, masses2_21, T0sum(216), M2)
  call TI_call_OL(0,0, momenta_73, masses2_21, T0sum(217), M2)
  call TI_call_OL(0,0, momenta_72, masses2_18, T0sum(218), M2)
  call TI_call_OL(0,0, momenta_73, masses2_18, T0sum(219), M2)
  call TI_call_OL(0,0, momenta_73, masses2_23, T0sum(220), M2)
  call TI_call_OL(0,0, momenta_77, masses2_18, T0sum(221), M2)
  call TI_call_OL(0,0, momenta_77, masses2_23, T0sum(222), M2)
  call TI_call_OL(0,0, momenta_80, masses2_23, T0sum(223), M2)
  call TI_call_OL(0,0, momenta_76, masses2_23, T0sum(224), M2)
  call TI_call_OL(0,0, momenta_96, masses2_29, T0sum(225), M2)
  call TI_call_OL(0,0, momenta_80, masses2_21, T0sum(226), M2)
  call TI_call_OL(0,0, momenta_86, masses2_29, T0sum(227), M2)
  call TI_call_OL(0,0, momenta_76, masses2_21, T0sum(228), M2)
  call TI_call_OL(0,0, momenta_70, masses2_18, T0sum(229), M2)
  call TI_call_OL(0,0, momenta_64, masses2_18, T0sum(230), M2)
  call TI_call_OL(0,0, momenta_70, masses2_20, T0sum(231), M2)
  call TI_call_OL(0,0, momenta_64, masses2_20, T0sum(232), M2)
  call TI_call_OL(0,0, momenta_70, masses2_19, T0sum(233), M2)
  call TI_call_OL(0,0, momenta_64, masses2_19, T0sum(234), M2)
  call TI_call_OL(0,0, momenta_58, masses2_18, T0sum(235), M2)
  call TI_call_OL(0,0, momenta_52, masses2_18, T0sum(236), M2)
  call TI_call_OL(0,0, momenta_58, masses2_20, T0sum(237), M2)
  call TI_call_OL(0,0, momenta_52, masses2_20, T0sum(238), M2)
  call TI_call_OL(0,0, momenta_58, masses2_19, T0sum(239), M2)
  call TI_call_OL(0,0, momenta_52, masses2_19, T0sum(240), M2)
  call TI_call_OL(0,0, momenta_80, masses2_18, T0sum(241), M2)
  call TI_call_OL(0,0, momenta_87, masses2_18, T0sum(242), M2)
  call TI_call_OL(0,0, momenta_81, masses2_18, T0sum(243), M2)
  call TI_call_OL(0,0, momenta_87, masses2_30, T0sum(244), M2)
  call TI_call_OL(0,0, momenta_87, masses2_27, T0sum(245), M2)
  call TI_call_OL(0,0, momenta_76, masses2_18, T0sum(246), M2)
  call TI_call_OL(0,0, momenta_97, masses2_18, T0sum(247), M2)
  call TI_call_OL(0,0, momenta_97, masses2_30, T0sum(248), M2)
  call TI_call_OL(0,0, momenta_97, masses2_27, T0sum(249), M2)
  call TI_call_OL(0,0, momenta_81, masses2_26, T0sum(250), M2)
  call TI_call_OL(0,0, momenta_81, masses2_25, T0sum(251), M2)
  call TI_call_OL(0,0, momenta_72, masses2_26, T0sum(252), M2)
  call TI_call_OL(0,0, momenta_72, masses2_25, T0sum(253), M2)
  call TI_call_OL(0,0, momenta_71, masses2_26, T0sum(254), M2)
  call TI_call_OL(0,0, momenta_71, masses2_25, T0sum(255), M2)
  call TI_call_OL(0,0, momenta_91, masses2_23, T0sum(256), M2)
  call TI_call_OL(0,0, momenta_105, masses2_31, T0sum(257), M2)
  call TI_call_OL(0,0, momenta_89, masses2_20, T0sum(258), M2)
  call TI_call_OL(0,0, momenta_87, masses2_24, T0sum(259), M2)
  call TI_call_OL(0,0, momenta_95, masses2_30, T0sum(260), M2)
  call TI_call_OL(0,0, momenta_79, masses2_18, T0sum(261), M2)
  call TI_call_OL(0,0, momenta_60, masses2_30, T0sum(262), M2)
  call TI_call_OL(0,0, momenta_34, masses2_18, T0sum(263), M2)
  call TI_call_OL(0,0, momenta_103, masses2_23, T0sum(264), M2)
  call TI_call_OL(0,0, momenta_104, masses2_31, T0sum(265), M2)
  call TI_call_OL(0,0, momenta_98, masses2_20, T0sum(266), M2)
  call TI_call_OL(0,0, momenta_97, masses2_24, T0sum(267), M2)
  call TI_call_OL(0,0, momenta_84, masses2_30, T0sum(268), M2)
  call TI_call_OL(0,0, momenta_74, masses2_18, T0sum(269), M2)
  call TI_call_OL(0,0, momenta_47, masses2_30, T0sum(270), M2)
  call TI_call_OL(0,0, momenta_29, masses2_18, T0sum(271), M2)
  call TI_call_OL(0,0, momenta_93, masses2_23, T0sum(272), M2)
  call TI_call_OL(0,0, momenta_88, masses2_20, T0sum(273), M2)
  call TI_call_OL(0,0, momenta_94, masses2_30, T0sum(274), M2)
  call TI_call_OL(0,0, momenta_78, masses2_18, T0sum(275), M2)
  call TI_call_OL(0,0, momenta_59, masses2_30, T0sum(276), M2)
  call TI_call_OL(0,0, momenta_33, masses2_18, T0sum(277), M2)
  call TI_call_OL(0,0, momenta_93, masses2_21, T0sum(278), M2)
  call TI_call_OL(0,0, momenta_104, masses2_28, T0sum(279), M2)
  call TI_call_OL(0,0, momenta_88, masses2_19, T0sum(280), M2)
  call TI_call_OL(0,0, momenta_94, masses2_27, T0sum(281), M2)
  call TI_call_OL(0,0, momenta_59, masses2_27, T0sum(282), M2)
  call TI_call_OL(0,0, momenta_101, masses2_23, T0sum(283), M2)
  call TI_call_OL(0,0, momenta_99, masses2_20, T0sum(284), M2)
  call TI_call_OL(0,0, momenta_85, masses2_30, T0sum(285), M2)
  call TI_call_OL(0,0, momenta_75, masses2_18, T0sum(286), M2)
  call TI_call_OL(0,0, momenta_48, masses2_30, T0sum(287), M2)
  call TI_call_OL(0,0, momenta_30, masses2_18, T0sum(288), M2)
  call TI_call_OL(0,0, momenta_101, masses2_21, T0sum(289), M2)
  call TI_call_OL(0,0, momenta_105, masses2_28, T0sum(290), M2)
  call TI_call_OL(0,0, momenta_99, masses2_19, T0sum(291), M2)
  call TI_call_OL(0,0, momenta_85, masses2_27, T0sum(292), M2)
  call TI_call_OL(0,0, momenta_48, masses2_27, T0sum(293), M2)
  call TI_call_OL(0,0, momenta_102, masses2_23, T0sum(294), M2)
  call TI_call_OL(0,0, momenta_96, masses2_32, T0sum(295), M2)
  call TI_call_OL(0,0, momenta_67, masses2_23, T0sum(296), M2)
  call TI_call_OL(0,0, momenta_61, masses2_32, T0sum(297), M2)
  call TI_call_OL(0,0, momenta_90, masses2_23, T0sum(298), M2)
  call TI_call_OL(0,0, momenta_86, masses2_32, T0sum(299), M2)
  call TI_call_OL(0,0, momenta_53, masses2_23, T0sum(300), M2)
  call TI_call_OL(0,0, momenta_49, masses2_32, T0sum(301), M2)
  call TI_call_OL(0,0, momenta_100, masses2_23, T0sum(302), M2)
  call TI_call_OL(0,0, momenta_65, masses2_23, T0sum(303), M2)
  call TI_call_OL(0,0, momenta_100, masses2_21, T0sum(304), M2)
  call TI_call_OL(0,0, momenta_65, masses2_21, T0sum(305), M2)
  call TI_call_OL(0,0, momenta_92, masses2_23, T0sum(306), M2)
  call TI_call_OL(0,0, momenta_55, masses2_23, T0sum(307), M2)
  call TI_call_OL(0,0, momenta_92, masses2_21, T0sum(308), M2)
  call TI_call_OL(0,0, momenta_55, masses2_21, T0sum(309), M2)
  call TI_call_OL(0,0, momenta_69, masses2_30, T0sum(310), M2)
  call TI_call_OL(0,0, momenta_68, masses2_18, T0sum(311), M2)
  call TI_call_OL(0,0, momenta_63, masses2_30, T0sum(312), M2)
  call TI_call_OL(0,0, momenta_37, masses2_18, T0sum(313), M2)
  call TI_call_OL(0,0, momenta_57, masses2_30, T0sum(314), M2)
  call TI_call_OL(0,0, momenta_54, masses2_18, T0sum(315), M2)
  call TI_call_OL(0,0, momenta_51, masses2_30, T0sum(316), M2)
  call TI_call_OL(0,0, momenta_66, masses2_18, T0sum(317), M2)
  call TI_call_OL(0,0, momenta_69, masses2_27, T0sum(318), M2)
  call TI_call_OL(0,0, momenta_63, masses2_27, T0sum(319), M2)
  call TI_call_OL(0,0, momenta_56, masses2_18, T0sum(320), M2)
  call TI_call_OL(0,0, momenta_57, masses2_27, T0sum(321), M2)
  call TI_call_OL(0,0, momenta_51, masses2_27, T0sum(322), M2)
  call TI_call_OL(0,0, momenta_45, masses2_18, T0sum(323), M2)
  call TI_call_OL(0,0, momenta_39, masses2_18, T0sum(324), M2)
  call TI_call_OL(0,0, momenta_45, masses2_23, T0sum(325), M2)
  call TI_call_OL(0,0, momenta_39, masses2_23, T0sum(326), M2)
  call TI_call_OL(0,0, momenta_45, masses2_21, T0sum(327), M2)
  call TI_call_OL(0,0, momenta_39, masses2_21, T0sum(328), M2)
  call TI_call_OL(0,0, momenta_46, masses2_18, T0sum(329), M2)
  call TI_call_OL(0,0, momenta_40, masses2_18, T0sum(330), M2)
  call TI_call_OL(0,0, momenta_46, masses2_23, T0sum(331), M2)
  call TI_call_OL(0,0, momenta_40, masses2_23, T0sum(332), M2)
  call TI_call_OL(0,0, momenta_46, masses2_21, T0sum(333), M2)
  call TI_call_OL(0,0, momenta_40, masses2_21, T0sum(334), M2)
  call TI_call_OL(0,0, momenta_69, masses2_18, T0sum(335), M2)
  call TI_call_OL(0,0, momenta_43, masses2_18, T0sum(336), M2)
  call TI_call_OL(0,0, momenta_51, masses2_18, T0sum(337), M2)
  call TI_call_OL(0,0, momenta_57, masses2_18, T0sum(338), M2)
  call TI_call_OL(0,0, momenta_63, masses2_18, T0sum(339), M2)
  call TI_call_OL(0,0, momenta_37, masses2_26, T0sum(340), M2)
  call TI_call_OL(0,0, momenta_37, masses2_25, T0sum(341), M2)
  call TI_call_OL(0,0, momenta_43, masses2_26, T0sum(342), M2)
  call TI_call_OL(0,0, momenta_43, masses2_25, T0sum(343), M2)
  call TI_call_OL(0,0, momenta_44, masses2_26, T0sum(344), M2)
  call TI_call_OL(0,0, momenta_38, masses2_26, T0sum(345), M2)
  call TI_call_OL(0,0, momenta_44, masses2_25, T0sum(346), M2)
  call TI_call_OL(0,0, momenta_38, masses2_25, T0sum(347), M2)
  call TI_call_OL(0,0, momenta_104, masses2_21, T0sum(348), M2)
  call TI_call_OL(0,0, momenta_104, masses2_23, T0sum(349), M2)
  call TI_call_OL(0,0, momenta_24, masses2_1, T0sum(350), M2)
  call TI_call_OL(0,0, momenta_13, masses2_1, T0sum(351), M2)
  call TI_call_OL(0,0, momenta_12, masses2_1, T0sum(352), M2)
  call TI_call_OL(0,0, momenta_19, masses2_7, T0sum(353), M2)
  call TI_call_OL(0,0, momenta_24, masses2_15, T0sum(354), M2)
  call TI_call_OL(0,0, momenta_1, masses2_7, T0sum(355), M2)
  call TI_call_OL(0,0, momenta_16, masses2_7, T0sum(356), M2)
  call TI_call_OL(0,0, momenta_23, masses2_7, T0sum(357), M2)
  call TI_call_OL(0,0, momenta_20, masses2_7, T0sum(358), M2)
  call TI_call_OL(0,0, momenta_19, masses2_1, T0sum(359), M2)
  call TI_call_OL(0,0, momenta_16, masses2_1, T0sum(360), M2)
  call TI_call_OL(0,0, momenta_19, masses2_8, T0sum(361), M2)
  call TI_call_OL(0,0, momenta_16, masses2_8, T0sum(362), M2)
  call TI_call_OL(0,0, momenta_1, masses2_8, T0sum(363), M2)
  call TI_call_OL(0,0, momenta_23, masses2_1, T0sum(364), M2)
  call TI_call_OL(0,0, momenta_15, masses2_1, T0sum(365), M2)
  call TI_call_OL(0,0, momenta_23, masses2_8, T0sum(366), M2)
  call TI_call_OL(0,0, momenta_19, masses2_16, T0sum(367), M2)
  call TI_call_OL(0,0, momenta_19, masses2_14, T0sum(368), M2)
  call TI_call_OL(0,0, momenta_20, masses2_1, T0sum(369), M2)
  call TI_call_OL(0,0, momenta_20, masses2_8, T0sum(370), M2)
  call TI_call_OL(0,0, momenta_23, masses2_16, T0sum(371), M2)
  call TI_call_OL(0,0, momenta_23, masses2_14, T0sum(372), M2)
  call TI_call_OL(0,0, momenta_3, masses2_1, T0sum(373), M2)
  call TI_call_OL(0,0, momenta_2, masses2_1, T0sum(374), M2)
  call TI_call_OL(0,0, momenta_11, masses2_14, T0sum(375), M2)
  call TI_call_OL(0,0, momenta_8, masses2_14, T0sum(376), M2)
  call TI_call_OL(0,0, momenta_7, masses2_14, T0sum(377), M2)
  call TI_call_OL(0,0, momenta_4, masses2_14, T0sum(378), M2)
  call TI_call_OL(0,0, momenta_11, masses2_1, T0sum(379), M2)
  call TI_call_OL(0,0, momenta_11, masses2_16, T0sum(380), M2)
  call TI_call_OL(0,0, momenta_4, masses2_1, T0sum(381), M2)
  call TI_call_OL(0,0, momenta_4, masses2_16, T0sum(382), M2)
  call TI_call_OL(0,0, momenta_7, masses2_1, T0sum(383), M2)
  call TI_call_OL(0,0, momenta_7, masses2_16, T0sum(384), M2)
  call TI_call_OL(0,0, momenta_8, masses2_1, T0sum(385), M2)
  call TI_call_OL(0,0, momenta_8, masses2_16, T0sum(386), M2)
  call TI_call_OL(0,0, momenta_11, masses2_8, T0sum(387), M2)
  call TI_call_OL(0,0, momenta_8, masses2_8, T0sum(388), M2)
  call TI_call_OL(0,0, momenta_11, masses2_7, T0sum(389), M2)
  call TI_call_OL(0,0, momenta_8, masses2_7, T0sum(390), M2)
  call TI_call_OL(0,0, momenta_7, masses2_8, T0sum(391), M2)
  call TI_call_OL(0,0, momenta_4, masses2_8, T0sum(392), M2)
  call TI_call_OL(0,0, momenta_7, masses2_7, T0sum(393), M2)
  call TI_call_OL(0,0, momenta_4, masses2_7, T0sum(394), M2)
  call TI_call_OL(0,0, momenta_15, masses2_13, T0sum(395), M2)
  call TI_call_OL(0,0, momenta_12, masses2_13, T0sum(396), M2)
  call TI_call_OL(0,0, momenta_2, masses2_13, T0sum(397), M2)
  call TI_call_OL(0,0, momenta_1, masses2_6, T0sum(398), M2)
  call TI_call_OL(0,0, momenta_15, masses2_9, T0sum(399), M2)
  call TI_call_OL(0,0, momenta_12, masses2_9, T0sum(400), M2)
  call TI_call_OL(0,0, momenta_2, masses2_9, T0sum(401), M2)
  call TI_call_OL(0,0, momenta_1, masses2_2, T0sum(402), M2)
  call TI_call_OL(0,0, momenta_24, masses2_13, T0sum(403), M2)
  call TI_call_OL(0,0, momenta_3, masses2_13, T0sum(404), M2)
  call TI_call_OL(0,0, momenta_24, masses2_9, T0sum(405), M2)
  call TI_call_OL(0,0, momenta_3, masses2_9, T0sum(406), M2)
  call TI_call_OL(0,0, momenta_20, masses2_14, T0sum(407), M2)
  call TI_call_OL(0,0, momenta_14, masses2_1, T0sum(408), M2)
  call TI_call_OL(0,0, momenta_16, masses2_14, T0sum(409), M2)
  call TI_call_OL(0,0, momenta_16, masses2_16, T0sum(410), M2)
  call TI_call_OL(0,0, momenta_20, masses2_16, T0sum(411), M2)
  call TI_call_OL(0,0, momenta_14, masses2_13, T0sum(412), M2)
  call TI_call_OL(0,0, momenta_14, masses2_9, T0sum(413), M2)
  call TI_call_OL(0,0, momenta_13, masses2_13, T0sum(414), M2)
  call TI_call_OL(0,0, momenta_13, masses2_9, T0sum(415), M2)
  call TI_call_OL(0,0, momenta_26, masses2_14, T0sum(416), M2)
  call TI_call_OL(0,0, momenta_25, masses2_7, T0sum(417), M2)
  call TI_call_OL(0,0, momenta_26, masses2_7, T0sum(418), M2)
  call TI_call_OL(0,0, momenta_25, masses2_14, T0sum(419), M2)
  call TI_call_OL(0,0, momenta_26, masses2_8, T0sum(420), M2)
  call TI_call_OL(0,0, momenta_25, masses2_16, T0sum(421), M2)
  call TI_call_OL(0,0, momenta_17, masses2_1, T0sum(422), M2)
  call TI_call_OL(0,0, momenta_24, masses2_17, T0sum(423), M2)
  call TI_call_OL(0,0, momenta_22, masses2_1, T0sum(424), M2)
  call TI_call_OL(0,0, momenta_10, masses2_1, T0sum(425), M2)
  call TI_call_OL(0,0, momenta_26, masses2_16, T0sum(426), M2)
  call TI_call_OL(0,0, momenta_25, masses2_8, T0sum(427), M2)
  call TI_call_OL(0,0, momenta_5, masses2_1, T0sum(428), M2)
  call TI_call_OL(0,0, momenta_18, masses2_1, T0sum(429), M2)
  call TI_call_OL(0,0, momenta_21, masses2_1, T0sum(430), M2)
  call TI_call_OL(0,0, momenta_9, masses2_1, T0sum(431), M2)
  call TI_call_OL(0,0, momenta_6, masses2_1, T0sum(432), M2)
  call TI_call_OL(0,0, momenta_24, masses2_12, T0sum(433), M2)
  call TI_call_OL(0,0, momenta_1, masses2_5, T0sum(434), M2)
  call TI_call_OL(0,0, momenta_24, masses2_11, T0sum(435), M2)
  call TI_call_OL(0,0, momenta_1, masses2_4, T0sum(436), M2)
  call TI_call_OL(0,0, momenta_24, masses2_10, T0sum(437), M2)
  call TI_call_OL(0,0, momenta_1, masses2_3, T0sum(438), M2)

  call TI_call_OL(0,1, momenta_210, masses2_66, T1sum(1), M2,sbarray_1, ScalarBoxes(:))
  call TI_call_OL(0,1, momenta_207, masses2_66, T1sum(2), M2,sbarray_2, ScalarBoxes(:))
  call TI_call_OL(0,1, momenta_209, masses2_66, T1sum(3), M2,sbarray_3, ScalarBoxes(:))
  call TI_call_OL(0,1, momenta_209, masses2_65, T1sum(4), M2,sbarray_4, ScalarBoxes(:))
  call TI_call_OL(0,1, momenta_208, masses2_66, T1sum(5), M2,sbarray_5, ScalarBoxes(:))
  call TI_call_OL(0,1, momenta_208, masses2_65, T1sum(6), M2,sbarray_6, ScalarBoxes(:))
  call TI_call_OL(0,1, momenta_206, masses2_61, T1sum(7), M2,sbarray_7, ScalarBoxes(:))
  call TI_call_OL(0,1, momenta_203, masses2_61, T1sum(8), M2,sbarray_8, ScalarBoxes(:))
  call TI_call_OL(0,1, momenta_205, masses2_61, T1sum(9), M2,sbarray_9, ScalarBoxes(:))
  call TI_call_OL(0,1, momenta_205, masses2_58, T1sum(10), M2,sbarray_10, ScalarBoxes(:))
  call TI_call_OL(0,1, momenta_204, masses2_61, T1sum(11), M2,sbarray_11, ScalarBoxes(:))
  call TI_call_OL(0,1, momenta_204, masses2_58, T1sum(12), M2,sbarray_12, ScalarBoxes(:))
  call TI_call_OL(0,1, momenta_202, masses2_64, T1sum(13), M2,sbarray_13, ScalarBoxes(:))
  call TI_call_OL(0,1, momenta_198, masses2_56, T1sum(14), M2,sbarray_14, ScalarBoxes(:))
  call TI_call_OL(0,1, momenta_195, masses2_62, T1sum(15), M2,sbarray_15, ScalarBoxes(:))
  call TI_call_OL(0,1, momenta_194, masses2_60, T1sum(16), M2,sbarray_16, ScalarBoxes(:))
  call TI_call_OL(0,1, momenta_199, masses2_64, T1sum(17), M2,sbarray_17, ScalarBoxes(:))
  call TI_call_OL(0,1, momenta_189, masses2_56, T1sum(18), M2,sbarray_18, ScalarBoxes(:))
  call TI_call_OL(0,1, momenta_187, masses2_62, T1sum(19), M2,sbarray_19, ScalarBoxes(:))
  call TI_call_OL(0,1, momenta_184, masses2_60, T1sum(20), M2,sbarray_20, ScalarBoxes(:))
  call TI_call_OL(0,1, momenta_201, masses2_64, T1sum(21), M2,sbarray_21, ScalarBoxes(:))
  call TI_call_OL(0,1, momenta_197, masses2_56, T1sum(22), M2,sbarray_22, ScalarBoxes(:))
  call TI_call_OL(0,1, momenta_192, masses2_60, T1sum(23), M2,sbarray_23, ScalarBoxes(:))
  call TI_call_OL(0,1, momenta_201, masses2_63, T1sum(24), M2,sbarray_24, ScalarBoxes(:))
  call TI_call_OL(0,1, momenta_197, masses2_55, T1sum(25), M2,sbarray_25, ScalarBoxes(:))
  call TI_call_OL(0,1, momenta_195, masses2_59, T1sum(26), M2,sbarray_26, ScalarBoxes(:))
  call TI_call_OL(0,1, momenta_192, masses2_57, T1sum(27), M2,sbarray_27, ScalarBoxes(:))
  call TI_call_OL(0,1, momenta_200, masses2_64, T1sum(28), M2,sbarray_28, ScalarBoxes(:))
  call TI_call_OL(0,1, momenta_190, masses2_56, T1sum(29), M2,sbarray_29, ScalarBoxes(:))
  call TI_call_OL(0,1, momenta_186, masses2_60, T1sum(30), M2,sbarray_30, ScalarBoxes(:))
  call TI_call_OL(0,1, momenta_200, masses2_63, T1sum(31), M2,sbarray_31, ScalarBoxes(:))
  call TI_call_OL(0,1, momenta_190, masses2_55, T1sum(32), M2,sbarray_32, ScalarBoxes(:))
  call TI_call_OL(0,1, momenta_187, masses2_59, T1sum(33), M2,sbarray_33, ScalarBoxes(:))
  call TI_call_OL(0,1, momenta_186, masses2_57, T1sum(34), M2,sbarray_34, ScalarBoxes(:))
  call TI_call_OL(0,1, momenta_191, masses2_61, T1sum(35), M2,sbarray_35, ScalarBoxes(:))
  call TI_call_OL(0,1, momenta_191, masses2_58, T1sum(36), M2,sbarray_36, ScalarBoxes(:))
  call TI_call_OL(0,1, momenta_193, masses2_61, T1sum(37), M2,sbarray_37, ScalarBoxes(:))
  call TI_call_OL(0,1, momenta_183, masses2_61, T1sum(38), M2,sbarray_38, ScalarBoxes(:))
  call TI_call_OL(0,1, momenta_185, masses2_61, T1sum(39), M2,sbarray_39, ScalarBoxes(:))
  call TI_call_OL(0,1, momenta_185, masses2_58, T1sum(40), M2,sbarray_40, ScalarBoxes(:))
  call TI_call_OL(0,1, momenta_181, masses2_52, T1sum(41), M2,sbarray_41, ScalarBoxes(:))
  call TI_call_OL(0,1, momenta_181, masses2_54, T1sum(42), M2,sbarray_42, ScalarBoxes(:))
  call TI_call_OL(0,1, momenta_181, masses2_53, T1sum(43), M2,sbarray_43, ScalarBoxes(:))
  call TI_call_OL(0,1, momenta_182, masses2_52, T1sum(44), M2,sbarray_44, ScalarBoxes(:))
  call TI_call_OL(0,1, momenta_182, masses2_54, T1sum(45), M2,sbarray_45, ScalarBoxes(:))
  call TI_call_OL(0,1, momenta_182, masses2_53, T1sum(46), M2,sbarray_46, ScalarBoxes(:))
  call TI_call_OL(0,1, momenta_180, masses2_52, T1sum(47), M2,sbarray_47, ScalarBoxes(:))
  call TI_call_OL(0,1, momenta_180, masses2_56, T1sum(48), M2,sbarray_48, ScalarBoxes(:))
  call TI_call_OL(0,1, momenta_180, masses2_55, T1sum(49), M2,sbarray_49, ScalarBoxes(:))
  call TI_call_OL(0,1, momenta_188, masses2_52, T1sum(50), M2,sbarray_50, ScalarBoxes(:))
  call TI_call_OL(0,1, momenta_188, masses2_60, T1sum(51), M2,sbarray_51, ScalarBoxes(:))
  call TI_call_OL(0,1, momenta_188, masses2_57, T1sum(52), M2,sbarray_52, ScalarBoxes(:))
  call TI_call_OL(0,1, momenta_179, masses2_52, T1sum(53), M2,sbarray_53, ScalarBoxes(:))
  call TI_call_OL(0,1, momenta_179, masses2_56, T1sum(54), M2,sbarray_54, ScalarBoxes(:))
  call TI_call_OL(0,1, momenta_179, masses2_55, T1sum(55), M2,sbarray_55, ScalarBoxes(:))
  call TI_call_OL(0,1, momenta_196, masses2_52, T1sum(56), M2,sbarray_56, ScalarBoxes(:))
  call TI_call_OL(0,1, momenta_196, masses2_60, T1sum(57), M2,sbarray_57, ScalarBoxes(:))
  call TI_call_OL(0,1, momenta_196, masses2_57, T1sum(58), M2,sbarray_58, ScalarBoxes(:))
  call TI_call_OL(1,1, momenta_81, masses2_18, T1sum(59), M2)
  call TI_call_OL(1,1, momenta_71, masses2_18, T1sum(60), M2)
  call TI_call_OL(1,1, momenta_37, masses2_18, T1sum(61), M2)
  call TI_call_OL(1,1, momenta_36, masses2_18, T1sum(62), M2)
  call TI_call_OL(1,1, momenta_81, masses2_26, T1sum(63), M2)
  call TI_call_OL(1,1, momenta_71, masses2_26, T1sum(64), M2)
  call TI_call_OL(1,1, momenta_37, masses2_26, T1sum(65), M2)
  call TI_call_OL(1,1, momenta_36, masses2_26, T1sum(66), M2)
  call TI_call_OL(1,1, momenta_81, masses2_25, T1sum(67), M2)
  call TI_call_OL(1,1, momenta_71, masses2_25, T1sum(68), M2)
  call TI_call_OL(1,1, momenta_37, masses2_25, T1sum(69), M2)
  call TI_call_OL(1,1, momenta_36, masses2_25, T1sum(70), M2)
  call TI_call_OL(1,1, momenta_72, masses2_18, T1sum(71), M2)
  call TI_call_OL(1,1, momenta_43, masses2_18, T1sum(72), M2)
  call TI_call_OL(1,1, momenta_27, masses2_18, T1sum(73), M2)
  call TI_call_OL(1,1, momenta_72, masses2_26, T1sum(74), M2)
  call TI_call_OL(1,1, momenta_43, masses2_26, T1sum(75), M2)
  call TI_call_OL(1,1, momenta_27, masses2_26, T1sum(76), M2)
  call TI_call_OL(1,1, momenta_72, masses2_25, T1sum(77), M2)
  call TI_call_OL(1,1, momenta_43, masses2_25, T1sum(78), M2)
  call TI_call_OL(1,1, momenta_27, masses2_25, T1sum(79), M2)
  call TI_call_OL(1,1, momenta_44, masses2_18, T1sum(80), M2)
  call TI_call_OL(1,1, momenta_38, masses2_18, T1sum(81), M2)
  call TI_call_OL(1,1, momenta_44, masses2_26, T1sum(82), M2)
  call TI_call_OL(1,1, momenta_38, masses2_26, T1sum(83), M2)
  call TI_call_OL(1,1, momenta_44, masses2_25, T1sum(84), M2)
  call TI_call_OL(1,1, momenta_38, masses2_25, T1sum(85), M2)

  call add_met(M2,M2L1R1)

#ifdef LOOPSQUARED
  end if
#endif

  call met_to_real(M2out,M2)

#ifdef PRECISION_dp
  call HOL_memory_deallocation_/**/REALKIND(1)
  call HCL_memory_deallocation_/**/REALKIND(1)
#endif

end subroutine integrate_tensor_sum

end module ol_tensor_sum_storage_ppnnjj_ew_nenexuuxgg_1_/**/REALKIND
