
! **********************************************************************
module ol_tables_storage_ppnnjj_ew_nenexddxbbx_1_/**/REALKIND
! **********************************************************************
  use KIND_TYPES, only: REALKIND, QREALKIND, intkind2
  use ol_data_types_/**/REALKIND, only: hol
  use ol_data_types_/**/REALKIND, only: basis, redset4, redset5
 use ol_data_types_/**/REALKIND, only: scalarbox 

  implicit none

  ! helicity tables for the 1-loop recursion
integer(intkind2), save :: h0tab(64,495)
integer(intkind2), save :: heltab2x2(2,2,236)
integer(intkind2), save :: heltab2x4(2,4,155)
integer(intkind2), save :: heltab2x8(2,8,183)
integer(intkind2), save :: heltab2x16(2,16,71)
integer(intkind2), save :: heltab2x32(2,32,113)
integer(intkind2), save :: heltab2x64(2,64,495)


  ! number of helicity states for openloops recursion steps
integer(intkind2), save :: m0h(495)
integer(intkind2), save :: m3h2x1(3,236)
integer(intkind2), save :: m3h4x1(3,65)
integer(intkind2), save :: m3h8x1(3,51)
integer(intkind2), save :: m3h16x1(3,10)
integer(intkind2), save :: m3h2x2(3,90)
integer(intkind2), save :: m3h4x2(3,75)
integer(intkind2), save :: m3h8x2(3,10)
integer(intkind2), save :: m3h16x2(3,19)
integer(intkind2), save :: m3h2x4(3,57)
integer(intkind2), save :: m3h4x4(3,20)
integer(intkind2), save :: m3h8x4(3,6)
integer(intkind2), save :: m3h16x4(3,209)
integer(intkind2), save :: m3h2x8(3,31)
integer(intkind2), save :: m3h4x8(3,54)
integer(intkind2), save :: m3h8x8(3,90)
integer(intkind2), save :: m3h2x16(3,34)
integer(intkind2), save :: m3h4x16(3,51)
integer(intkind2), save :: m3h2x32(3,145)

integer(intkind2), save :: n2h1(234)
integer(intkind2), save :: n2h2(112)
integer(intkind2), save :: n2h4(179)
integer(intkind2), save :: n2h8(105)
integer(intkind2), save :: n2h16(78)
integer(intkind2), save :: n2h32(68)


contains

!**********************************************************************
subroutine HOL_m3_init()
!**********************************************************************
! initialize m3 arrays for helicity summation
!**********************************************************************
  use KIND_TYPES, only: REALKIND, intkind2

m3h2x1(1,:)=2
m3h2x1(2,:)=1
m3h2x1(3,:)=2
m3h4x1(1,:)=4
m3h4x1(2,:)=1
m3h4x1(3,:)=4
m3h8x1(1,:)=8
m3h8x1(2,:)=1
m3h8x1(3,:)=8
m3h16x1(1,:)=16
m3h16x1(2,:)=1
m3h16x1(3,:)=16
m3h2x2(1,:)=2
m3h2x2(2,:)=2
m3h2x2(3,:)=4
m3h4x2(1,:)=4
m3h4x2(2,:)=2
m3h4x2(3,:)=8
m3h8x2(1,:)=8
m3h8x2(2,:)=2
m3h8x2(3,:)=16
m3h16x2(1,:)=16
m3h16x2(2,:)=2
m3h16x2(3,:)=32
m3h2x4(1,:)=2
m3h2x4(2,:)=4
m3h2x4(3,:)=8
m3h4x4(1,:)=4
m3h4x4(2,:)=4
m3h4x4(3,:)=16
m3h8x4(1,:)=8
m3h8x4(2,:)=4
m3h8x4(3,:)=32
m3h16x4(1,:)=16
m3h16x4(2,:)=4
m3h16x4(3,:)=64
m3h2x8(1,:)=2
m3h2x8(2,:)=8
m3h2x8(3,:)=16
m3h4x8(1,:)=4
m3h4x8(2,:)=8
m3h4x8(3,:)=32
m3h8x8(1,:)=8
m3h8x8(2,:)=8
m3h8x8(3,:)=64
m3h2x16(1,:)=2
m3h2x16(2,:)=16
m3h2x16(3,:)=32
m3h4x16(1,:)=4
m3h4x16(2,:)=16
m3h4x16(3,:)=64
m3h2x32(1,:)=2
m3h2x32(2,:)=32
m3h2x32(3,:)=64

n2h1(:)=1
n2h2(:)=2
n2h4(:)=4
n2h8(:)=8
n2h16(:)=16
n2h32(:)=32


end subroutine HOL_m3_init

!**********************************************************************

end module ol_tables_storage_ppnnjj_ew_nenexddxbbx_1_/**/REALKIND

! **********************************************************************
module ol_tensor_sum_storage_ppnnjj_ew_nenexddxbbx_1_/**/REALKIND
! **********************************************************************
  use KIND_TYPES, only: REALKIND, QREALKIND, intkind2
  use ol_data_types_/**/REALKIND, only: hol, hcl, met
  use ol_data_types_/**/REALKIND, only: basis, redset4, redset5
 use ol_data_types_/**/REALKIND, only: scalarbox 

  implicit none

  type(met), save :: M2L1R1

  ! Declarations of loop wave function tensors

  type(hol), save :: G0H1(1)
  type(hol), save :: G1H1(1)
  type(hol), save :: G2H1(1)
  type(hol), save :: G0H2(5)
  type(hol), save :: G1H2(61)
  type(hol), save :: G2H2(67)
  type(hol), save :: G0H4(34)
  type(hol), save :: G1H4(134)
  type(hol), save :: G2H4(15)
  type(hol), save :: G0H8(19)
  type(hol), save :: G1H8(79)
  type(hol), save :: G2H8(16)
  type(hol), save :: G0H16(1)
  type(hol), save :: G1H16(22)
  type(hol), save :: G0H32(41)
  type(hol), save :: G1H32(39)
  type(hol), save :: G0H64(1)
  type(hcl), save, dimension(1028) :: G0tensor
  type(hcl), save, dimension(618) :: G1tensor
  type(hcl), save, dimension(160) :: G2tensor
  type(hcl), save, dimension(6) :: G3tensor



  ! Declarations for on-the-fly tensor reduction
type (basis),      save :: RedBasis(152)
type (redset4),    save :: RedSet_4(143)
type (redset5),    save :: RedSet_5(48)
integer, save :: mass2set(0:1,15)
integer, save :: mass3set(0:2,36)
integer, save :: mass4set(0:3,47)
integer, save :: mass5set(0:4,20)



  ! Declarations for TI calls

  integer, save :: momenta_1(2)
  integer, save :: momenta_2(2)
  integer, save :: momenta_3(2)
  integer, save :: momenta_4(2)
  integer, save :: momenta_5(2)
  integer, save :: momenta_6(2)
  integer, save :: momenta_7(2)
  integer, save :: momenta_8(2)
  integer, save :: momenta_9(2)
  integer, save :: momenta_10(2)
  integer, save :: momenta_11(2)
  integer, save :: momenta_12(2)
  integer, save :: momenta_13(2)
  integer, save :: momenta_14(2)
  integer, save :: momenta_15(2)
  integer, save :: momenta_16(2)
  integer, save :: momenta_17(2)
  integer, save :: momenta_18(2)
  integer, save :: momenta_19(2)
  integer, save :: momenta_20(2)
  integer, save :: momenta_21(2)
  integer, save :: momenta_22(2)
  integer, save :: momenta_23(2)
  integer, save :: momenta_24(2)
  integer, save :: momenta_25(2)
  integer, save :: momenta_26(2)
  integer, save :: momenta_27(3)
  integer, save :: momenta_28(3)
  integer, save :: momenta_29(3)
  integer, save :: momenta_30(3)
  integer, save :: momenta_31(3)
  integer, save :: momenta_32(3)
  integer, save :: momenta_33(3)
  integer, save :: momenta_34(3)
  integer, save :: momenta_35(3)
  integer, save :: momenta_36(3)
  integer, save :: momenta_37(3)
  integer, save :: momenta_38(3)
  integer, save :: momenta_39(3)
  integer, save :: momenta_40(3)
  integer, save :: momenta_41(3)
  integer, save :: momenta_42(3)
  integer, save :: momenta_43(3)
  integer, save :: momenta_44(3)
  integer, save :: momenta_45(3)
  integer, save :: momenta_46(3)
  integer, save :: momenta_47(3)
  integer, save :: momenta_48(3)
  integer, save :: momenta_49(3)
  integer, save :: momenta_50(3)
  integer, save :: momenta_51(3)
  integer, save :: momenta_52(3)
  integer, save :: momenta_53(3)
  integer, save :: momenta_54(3)
  integer, save :: momenta_55(3)
  integer, save :: momenta_56(3)
  integer, save :: momenta_57(3)
  integer, save :: momenta_58(3)
  integer, save :: momenta_59(3)
  integer, save :: momenta_60(3)
  integer, save :: momenta_61(3)
  integer, save :: momenta_62(3)
  integer, save :: momenta_63(3)
  integer, save :: momenta_64(3)
  integer, save :: momenta_65(3)
  integer, save :: momenta_66(3)
  integer, save :: momenta_67(3)
  integer, save :: momenta_68(3)
  integer, save :: momenta_69(3)
  integer, save :: momenta_70(3)
  integer, save :: momenta_71(3)
  integer, save :: momenta_72(3)
  integer, save :: momenta_73(3)
  integer, save :: momenta_74(3)
  integer, save :: momenta_75(3)
  integer, save :: momenta_76(3)
  integer, save :: momenta_77(3)
  integer, save :: momenta_78(3)
  integer, save :: momenta_79(3)
  integer, save :: momenta_80(3)
  integer, save :: momenta_81(3)
  integer, save :: momenta_82(3)
  integer, save :: momenta_83(3)
  integer, save :: momenta_84(3)
  integer, save :: momenta_85(3)
  integer, save :: momenta_86(3)
  integer, save :: momenta_87(3)
  integer, save :: momenta_88(3)
  integer, save :: momenta_89(3)
  integer, save :: momenta_90(3)
  integer, save :: momenta_91(3)
  integer, save :: momenta_92(3)
  integer, save :: momenta_93(3)
  integer, save :: momenta_94(3)
  integer, save :: momenta_95(3)
  integer, save :: momenta_96(3)
  integer, save :: momenta_97(3)
  integer, save :: momenta_98(3)
  integer, save :: momenta_99(3)
  integer, save :: momenta_100(3)
  integer, save :: momenta_101(3)
  integer, save :: momenta_102(3)
  integer, save :: momenta_103(3)
  integer, save :: momenta_104(3)
  integer, save :: momenta_105(3)
  integer, save :: momenta_106(3)
  integer, save :: momenta_107(3)
  integer, save :: momenta_108(3)
  integer, save :: momenta_109(3)
  integer, save :: momenta_110(3)
  integer, save :: momenta_111(3)
  integer, save :: momenta_112(3)
  integer, save :: momenta_113(3)
  integer, save :: momenta_114(3)
  integer, save :: momenta_115(3)
  integer, save :: momenta_116(3)
  integer, save :: momenta_117(3)
  integer, save :: momenta_118(3)
  integer, save :: momenta_119(3)
  integer, save :: momenta_120(3)
  integer, save :: momenta_121(3)
  integer, save :: momenta_122(3)
  integer, save :: momenta_123(3)
  integer, save :: momenta_124(3)
  integer, save :: momenta_125(3)
  integer, save :: momenta_126(4)
  integer, save :: momenta_127(4)
  integer, save :: momenta_128(4)
  integer, save :: momenta_129(4)
  integer, save :: momenta_130(4)
  integer, save :: momenta_131(4)
  integer, save :: momenta_132(4)
  integer, save :: momenta_133(4)
  integer, save :: momenta_134(4)
  integer, save :: momenta_135(4)
  integer, save :: momenta_136(4)
  integer, save :: momenta_137(4)
  integer, save :: momenta_138(4)
  integer, save :: momenta_139(4)
  integer, save :: momenta_140(4)
  integer, save :: momenta_141(4)
  integer, save :: momenta_142(4)
  integer, save :: momenta_143(4)
  integer, save :: momenta_144(4)
  integer, save :: momenta_145(4)
  integer, save :: momenta_146(4)
  integer, save :: momenta_147(4)
  integer, save :: momenta_148(4)
  integer, save :: momenta_149(4)
  integer, save :: momenta_150(4)
  integer, save :: momenta_151(4)
  integer, save :: momenta_152(4)
  integer, save :: momenta_153(4)
  integer, save :: momenta_154(4)
  integer, save :: momenta_155(4)
  integer, save :: momenta_156(4)
  integer, save :: momenta_157(4)
  integer, save :: momenta_158(4)
  integer, save :: momenta_159(4)
  integer, save :: momenta_160(4)
  integer, save :: momenta_161(4)
  integer, save :: momenta_162(4)
  integer, save :: momenta_163(4)
  integer, save :: momenta_164(4)
  integer, save :: momenta_165(4)
  integer, save :: momenta_166(4)
  integer, save :: momenta_167(4)
  integer, save :: momenta_168(4)
  integer, save :: momenta_169(4)
  integer, save :: momenta_170(4)
  integer, save :: momenta_171(4)
  integer, save :: momenta_172(4)
  integer, save :: momenta_173(4)
  integer, save :: momenta_174(4)
  integer, save :: momenta_175(4)
  integer, save :: momenta_176(4)
  integer, save :: momenta_177(4)
  integer, save :: momenta_178(4)
  integer, save :: momenta_179(4)
  integer, save :: momenta_180(4)
  integer, save :: momenta_181(4)
  integer, save :: momenta_182(4)
  integer, save :: momenta_183(4)
  integer, save :: momenta_184(4)
  integer, save :: momenta_185(4)
  integer, save :: momenta_186(4)
  integer, save :: momenta_187(4)
  integer, save :: momenta_188(4)
  integer, save :: momenta_189(4)
  integer, save :: momenta_190(4)
  integer, save :: momenta_191(4)
  integer, save :: momenta_192(4)
  integer, save :: momenta_193(4)
  integer, save :: momenta_194(4)
  integer, save :: momenta_195(4)
  integer, save :: momenta_196(4)
  integer, save :: momenta_197(4)
  integer, save :: momenta_198(4)
  integer, save :: momenta_199(4)
  integer, save :: momenta_200(4)
  integer, save :: momenta_201(4)
  integer, save :: momenta_202(4)
  integer, save :: momenta_203(4)
  integer, save :: momenta_204(4)
  integer, save :: momenta_205(4)
  integer, save :: momenta_206(4)
  integer, save :: momenta_207(4)
  integer, save :: momenta_208(4)
  integer, save :: momenta_209(4)
  integer, save :: momenta_210(4)
  integer, save :: momenta_211(4)
  integer, save :: momenta_212(4)
  integer, save :: momenta_213(4)
  integer, save :: momenta_214(4)
  integer, save :: momenta_215(4)
  integer, save :: momenta_216(4)
  integer, save :: momenta_217(4)
  integer, save :: momenta_218(4)
  integer, save :: momenta_219(4)
  integer, save :: momenta_220(4)
  integer, save :: momenta_221(4)
  integer, save :: momenta_222(4)
  integer, save :: momenta_223(4)
  integer, save :: momenta_224(4)
  integer, save :: momenta_225(4)
  integer, save :: momenta_226(4)
  integer, save :: momenta_227(4)
  integer, save :: momenta_228(4)
  integer, save :: momenta_229(4)
  integer, save :: momenta_230(4)
  integer, save :: momenta_231(5)
  integer, save :: momenta_232(5)
  integer, save :: momenta_233(5)
  integer, save :: momenta_234(5)
  integer, save :: momenta_235(5)
  integer, save :: momenta_236(5)
  integer, save :: momenta_237(5)
  integer, save :: momenta_238(5)
  integer, save :: momenta_239(5)
  integer, save :: momenta_240(5)
  integer, save :: momenta_241(5)
  integer, save :: momenta_242(5)
  integer, save :: momenta_243(5)
  integer, save :: momenta_244(5)
  integer, save :: momenta_245(5)
  integer, save :: momenta_246(5)
  integer, save :: momenta_247(5)
  integer, save :: momenta_248(5)
  integer, save :: momenta_249(5)
  integer, save :: momenta_250(5)
  integer, save :: momenta_251(5)
  integer, save :: momenta_252(5)
  integer, save :: momenta_253(5)
  integer, save :: momenta_254(5)
  integer, save :: momenta_255(5)
  integer, save :: momenta_256(5)
  integer, save :: momenta_257(5)
  integer, save :: momenta_258(5)
  integer, save :: momenta_259(5)
  integer, save :: momenta_260(5)
  integer, save :: momenta_261(5)
  integer, save :: momenta_262(5)
  integer, save :: momenta_263(5)
  integer, save :: momenta_264(5)
  integer, save :: momenta_265(5)
  integer, save :: momenta_266(5)
  integer, save :: momenta_267(5)
  integer, save :: momenta_268(5)
  integer, save :: momenta_269(5)
  integer, save :: momenta_270(5)
  integer, save :: momenta_271(6)
  integer, save :: momenta_272(6)
  integer, save :: momenta_273(6)
  integer, save :: momenta_274(6)
  integer, save :: momenta_275(6)
  integer, save :: momenta_276(6)
  integer, save :: momenta_277(6)
  integer, save :: momenta_278(6)

  integer, save :: masses2_1(2)
  integer, save :: masses2_2(2)
  integer, save :: masses2_3(2)
  integer, save :: masses2_4(2)
  integer, save :: masses2_5(2)
  integer, save :: masses2_6(2)
  integer, save :: masses2_7(2)
  integer, save :: masses2_8(2)
  integer, save :: masses2_9(2)
  integer, save :: masses2_10(2)
  integer, save :: masses2_11(2)
  integer, save :: masses2_12(2)
  integer, save :: masses2_13(2)
  integer, save :: masses2_14(2)
  integer, save :: masses2_15(2)
  integer, save :: masses2_16(2)
  integer, save :: masses2_17(2)
  integer, save :: masses2_18(2)
  integer, save :: masses2_19(2)
  integer, save :: masses2_20(2)
  integer, save :: masses2_21(2)
  integer, save :: masses2_22(2)
  integer, save :: masses2_23(2)
  integer, save :: masses2_24(2)
  integer, save :: masses2_25(2)
  integer, save :: masses2_26(3)
  integer, save :: masses2_27(3)
  integer, save :: masses2_28(3)
  integer, save :: masses2_29(3)
  integer, save :: masses2_30(3)
  integer, save :: masses2_31(3)
  integer, save :: masses2_32(3)
  integer, save :: masses2_33(3)
  integer, save :: masses2_34(3)
  integer, save :: masses2_35(3)
  integer, save :: masses2_36(3)
  integer, save :: masses2_37(3)
  integer, save :: masses2_38(3)
  integer, save :: masses2_39(3)
  integer, save :: masses2_40(3)
  integer, save :: masses2_41(3)
  integer, save :: masses2_42(3)
  integer, save :: masses2_43(3)
  integer, save :: masses2_44(3)
  integer, save :: masses2_45(3)
  integer, save :: masses2_46(3)
  integer, save :: masses2_47(3)
  integer, save :: masses2_48(3)
  integer, save :: masses2_49(3)
  integer, save :: masses2_50(3)
  integer, save :: masses2_51(3)
  integer, save :: masses2_52(3)
  integer, save :: masses2_53(3)
  integer, save :: masses2_54(3)
  integer, save :: masses2_55(3)
  integer, save :: masses2_56(3)
  integer, save :: masses2_57(3)
  integer, save :: masses2_58(3)
  integer, save :: masses2_59(3)
  integer, save :: masses2_60(3)
  integer, save :: masses2_61(3)
  integer, save :: masses2_62(3)
  integer, save :: masses2_63(3)
  integer, save :: masses2_64(3)
  integer, save :: masses2_65(3)
  integer, save :: masses2_66(3)
  integer, save :: masses2_67(3)
  integer, save :: masses2_68(4)
  integer, save :: masses2_69(4)
  integer, save :: masses2_70(4)
  integer, save :: masses2_71(4)
  integer, save :: masses2_72(4)
  integer, save :: masses2_73(4)
  integer, save :: masses2_74(4)
  integer, save :: masses2_75(4)
  integer, save :: masses2_76(4)
  integer, save :: masses2_77(4)
  integer, save :: masses2_78(4)
  integer, save :: masses2_79(4)
  integer, save :: masses2_80(4)
  integer, save :: masses2_81(4)
  integer, save :: masses2_82(4)
  integer, save :: masses2_83(4)
  integer, save :: masses2_84(4)
  integer, save :: masses2_85(4)
  integer, save :: masses2_86(4)
  integer, save :: masses2_87(4)
  integer, save :: masses2_88(4)
  integer, save :: masses2_89(4)
  integer, save :: masses2_90(4)
  integer, save :: masses2_91(4)
  integer, save :: masses2_92(4)
  integer, save :: masses2_93(4)
  integer, save :: masses2_94(4)
  integer, save :: masses2_95(4)
  integer, save :: masses2_96(4)
  integer, save :: masses2_97(4)
  integer, save :: masses2_98(4)
  integer, save :: masses2_99(4)
  integer, save :: masses2_100(4)
  integer, save :: masses2_101(4)
  integer, save :: masses2_102(4)
  integer, save :: masses2_103(4)
  integer, save :: masses2_104(4)
  integer, save :: masses2_105(4)
  integer, save :: masses2_106(4)
  integer, save :: masses2_107(4)
  integer, save :: masses2_108(4)
  integer, save :: masses2_109(4)
  integer, save :: masses2_110(4)
  integer, save :: masses2_111(4)
  integer, save :: masses2_112(4)
  integer, save :: masses2_113(4)
  integer, save :: masses2_114(4)
  integer, save :: masses2_115(4)
  integer, save :: masses2_116(4)
  integer, save :: masses2_117(4)
  integer, save :: masses2_118(4)
  integer, save :: masses2_119(4)
  integer, save :: masses2_120(4)
  integer, save :: masses2_121(4)
  integer, save :: masses2_122(5)
  integer, save :: masses2_123(5)
  integer, save :: masses2_124(5)
  integer, save :: masses2_125(5)
  integer, save :: masses2_126(5)
  integer, save :: masses2_127(5)
  integer, save :: masses2_128(5)
  integer, save :: masses2_129(5)
  integer, save :: masses2_130(5)
  integer, save :: masses2_131(5)
  integer, save :: masses2_132(5)
  integer, save :: masses2_133(5)
  integer, save :: masses2_134(5)
  integer, save :: masses2_135(5)
  integer, save :: masses2_136(5)
  integer, save :: masses2_137(5)
  integer, save :: masses2_138(5)
  integer, save :: masses2_139(5)
  integer, save :: masses2_140(5)
  integer, save :: masses2_141(6)
  integer, save :: masses2_142(6)

type(scalarbox), save :: ScalarBoxes(189)

integer, save :: sbarray_1(15)
integer, save :: sbarray_2(15)
integer, save :: sbarray_3(15)
integer, save :: sbarray_4(15)
integer, save :: sbarray_5(15)
integer, save :: sbarray_6(15)
integer, save :: sbarray_7(15)
integer, save :: sbarray_8(15)
integer, save :: sbarray_9(5)
integer, save :: sbarray_10(5)
integer, save :: sbarray_11(5)
integer, save :: sbarray_12(5)
integer, save :: sbarray_13(5)
integer, save :: sbarray_14(5)
integer, save :: sbarray_15(5)
integer, save :: sbarray_16(5)
integer, save :: sbarray_17(5)
integer, save :: sbarray_18(5)
integer, save :: sbarray_19(5)
integer, save :: sbarray_20(5)
integer, save :: sbarray_21(5)
integer, save :: sbarray_22(5)
integer, save :: sbarray_23(5)
integer, save :: sbarray_24(5)
integer, save :: sbarray_25(5)
integer, save :: sbarray_26(5)
integer, save :: sbarray_27(5)
integer, save :: sbarray_28(5)
integer, save :: sbarray_29(5)
integer, save :: sbarray_30(5)
integer, save :: sbarray_31(5)
integer, save :: sbarray_32(5)
integer, save :: sbarray_33(5)
integer, save :: sbarray_34(5)
integer, save :: sbarray_35(5)
integer, save :: sbarray_36(5)
integer, save :: sbarray_37(5)
integer, save :: sbarray_38(5)
integer, save :: sbarray_39(5)
integer, save :: sbarray_40(5)
integer, save :: sbarray_41(5)
integer, save :: sbarray_42(5)
integer, save :: sbarray_43(5)
integer, save :: sbarray_44(5)
integer, save :: sbarray_45(5)
integer, save :: sbarray_46(5)
integer, save :: sbarray_47(5)
integer, save :: sbarray_48(5)
integer, save :: sbarray_49(5)
integer, save :: sbarray_50(5)
integer, save :: sbarray_51(5)
integer, save :: sbarray_52(5)
integer, save :: sbarray_53(5)
integer, save :: sbarray_54(5)
integer, save :: sbarray_55(5)
integer, save :: sbarray_56(5)
integer, save :: sbarray_57(5)
integer, save :: sbarray_58(5)
integer, save :: sbarray_59(5)
integer, save :: sbarray_60(5)
integer, save :: sbarray_61(5)
integer, save :: sbarray_62(5)

  type(hcl), save, dimension(524) :: T0sum
  type(hcl), save, dimension(62) :: T1sum


  contains

!**********************************************************************
subroutine HOL_memory_allocation()
!**********************************************************************
! allocation of memory for the types hol
!**********************************************************************
  use KIND_TYPES, only: REALKIND
  use ol_data_types_/**/REALKIND, only: hol
  use hol_initialisation_/**/REALKIND, only: hol_allocation
  implicit none

    call hol_allocation(4,1,4,1,G0H1,1)
  call hol_allocation(4,5,4,1,G1H1,1)
  call hol_allocation(4,15,4,1,G2H1,1)
  call hol_allocation(4,1,4,2,G0H2,5)
  call hol_allocation(4,5,4,2,G1H2,61)
  call hol_allocation(4,15,4,2,G2H2,67)
  call hol_allocation(4,1,4,4,G0H4,34)
  call hol_allocation(4,5,4,4,G1H4,134)
  call hol_allocation(4,15,4,4,G2H4,15)
  call hol_allocation(4,1,4,8,G0H8,19)
  call hol_allocation(4,5,4,8,G1H8,79)
  call hol_allocation(4,15,4,8,G2H8,16)
  call hol_allocation(4,1,4,16,G0H16,1)
  call hol_allocation(4,5,4,16,G1H16,22)
  call hol_allocation(4,1,4,32,G0H32,41)
  call hol_allocation(4,5,4,32,G1H32,39)
  call hol_allocation(4,1,4,64,G0H64,1)


end subroutine HOL_memory_allocation


!**********************************************************************
subroutine HOL_memory_deallocation_/**/REALKIND(dmode)
!**********************************************************************
! allocation of memory for the types hol
!**********************************************************************
  use KIND_TYPES, only: REALKIND
  use ol_data_types_/**/REALKIND, only: hol
  use hol_initialisation_/**/REALKIND, only: hol_deallocation
  implicit none
  integer,   intent(in)    :: dmode

    call hol_deallocation(G0H1,1,dmode)
  call hol_deallocation(G1H1,1,dmode)
  call hol_deallocation(G2H1,1,dmode)
  call hol_deallocation(G0H2,5,dmode)
  call hol_deallocation(G1H2,61,dmode)
  call hol_deallocation(G2H2,67,dmode)
  call hol_deallocation(G0H4,34,dmode)
  call hol_deallocation(G1H4,134,dmode)
  call hol_deallocation(G2H4,15,dmode)
  call hol_deallocation(G0H8,19,dmode)
  call hol_deallocation(G1H8,79,dmode)
  call hol_deallocation(G2H8,16,dmode)
  call hol_deallocation(G0H16,1,dmode)
  call hol_deallocation(G1H16,22,dmode)
  call hol_deallocation(G0H32,41,dmode)
  call hol_deallocation(G1H32,39,dmode)
  call hol_deallocation(G0H64,1,dmode)


end subroutine HOL_memory_deallocation_/**/REALKIND

!**********************************************************************
subroutine HCL_memory_allocation()
!**********************************************************************
! allocation of memory for the types hcl
!**********************************************************************
  use KIND_TYPES, only: REALKIND
  use ol_data_types_/**/REALKIND, only: hcl
  use hol_initialisation_/**/REALKIND, only: hcl_allocation
  implicit none

  call hcl_allocation(1,G0tensor, 1028)
call hcl_allocation(5,G1tensor, 618)
call hcl_allocation(15,G2tensor, 160)
call hcl_allocation(35,G3tensor, 6)


end subroutine HCL_memory_allocation


!**********************************************************************
subroutine HCL_memory_deallocation_/**/REALKIND(dmode)
!**********************************************************************
! deallocation of memory for the types hcl
!**********************************************************************
  use KIND_TYPES, only: REALKIND
  use ol_data_types_/**/REALKIND, only: hcl
  use hol_initialisation_/**/REALKIND, only: hcl_deallocation
  implicit none
  integer,   intent(in)    :: dmode

  call hcl_deallocation(G0tensor, 1028,dmode)
call hcl_deallocation(G1tensor, 618,dmode)
call hcl_deallocation(G2tensor, 160,dmode)
call hcl_deallocation(G3tensor, 6,dmode)

    call hcl_deallocation(T0sum,524,dmode)
  call hcl_deallocation(T1sum,62,dmode)


end subroutine HCL_memory_deallocation_/**/REALKIND


!**********************************************************************
subroutine Tsum_memory_allocation()
!**********************************************************************
! allocation of memory for the types hcl
!**********************************************************************
  use KIND_TYPES, only: REALKIND
  use ol_data_types_/**/REALKIND, only: hcl
  use hol_initialisation_/**/REALKIND, only: hcl_allocation
  implicit none

    call hcl_allocation(1,T0sum,524)
  call hcl_allocation(5,T1sum,62)


end subroutine Tsum_memory_allocation


#ifdef PRECISION_dp
subroutine max_point(r) &
    & bind(c,name="ol_f_max_point_ppnnjj_ew_nenexddxbbx_1")
  ! Return the number maximal tensor rank
  implicit none
  integer, intent(out) :: r
  r = 6
end subroutine max_point

subroutine tensor_rank(r) &
    & bind(c,name="ol_f_tensor_rank_ppnnjj_ew_nenexddxbbx_1")
  ! Return the number maximal tensor rank
  implicit none
  integer, intent(out) :: r
  r = 1
end subroutine tensor_rank
#endif

subroutine reset_tensor_sum()
  use hol_initialisation_/**/REALKIND, only: hcl_allocation
  use ol_parameters_init_/**/REALKIND, only: init_hcl
  implicit none
  integer :: i

  do i = 1,524
    call init_hcl(T0sum(i))
  end do
  do i = 1,62
    call init_hcl(T1sum(i))
  end do

end subroutine reset_tensor_sum


subroutine scale_one_tsum(tsum, spow)
  use ol_parameters_decl_/**/REALKIND, only: scalefactor
  implicit none
  complex(REALKIND), intent(inout) :: tsum(:)
  integer, intent(in) :: spow ! rank 0 scale power
  real(REALKIND) :: sfinv, sfac
  integer :: sz
  sfinv = 1/scalefactor
  sfac = scalefactor**spow
  sz = size(tsum)
  tsum(1) = sfac*tsum(1)
  if (sz > 1) then ! rank 1
    sfac = sfac*sfinv
    tsum(2:5) = sfac*tsum(2:5)
  end if
  if (sz > 5) then ! rank 2
    sfac = sfac*sfinv
    tsum(6:15) = sfac*tsum(6:15)
  end if
  if (sz > 15) then ! rank 3
    sfac = sfac*sfinv
    tsum(16:35) = sfac*tsum(16:35)
  end if
  if (sz > 35) then ! rank 4
    sfac = sfac*sfinv
    tsum(36:70) = sfac*tsum(36:70)
  end if
  if (sz > 70) then ! rank 5
    sfac = sfac*sfinv
    tsum(71:126) = sfac*tsum(71:126)
  end if
  if (sz > 126) then ! rank 6
    sfac = sfac*sfinv
    tsum(127:210) = sfac*tsum(127:210)
  end if
  if (sz > 210) then ! rank 7
    sfac = sfac*sfinv
    tsum(211:330) = sfac*tsum(211:330)
  end if
end subroutine scale_one_tsum


subroutine scale_tensor_sum()
  implicit none
  call scale_one_tsum(T1sum(1)%cmp, 4)
  call scale_one_tsum(T1sum(2)%cmp, 4)
  call scale_one_tsum(T1sum(3)%cmp, 4)
  call scale_one_tsum(T1sum(4)%cmp, 4)
  call scale_one_tsum(T1sum(5)%cmp, 4)
  call scale_one_tsum(T1sum(6)%cmp, 4)
  call scale_one_tsum(T1sum(7)%cmp, 4)
  call scale_one_tsum(T1sum(8)%cmp, 4)
  call scale_one_tsum(T1sum(9)%cmp, 2)
  call scale_one_tsum(T1sum(10)%cmp, 2)
  call scale_one_tsum(T1sum(11)%cmp, 2)
  call scale_one_tsum(T1sum(12)%cmp, 2)
  call scale_one_tsum(T1sum(13)%cmp, 2)
  call scale_one_tsum(T1sum(14)%cmp, 2)
  call scale_one_tsum(T1sum(15)%cmp, 2)
  call scale_one_tsum(T1sum(16)%cmp, 2)
  call scale_one_tsum(T1sum(17)%cmp, 2)
  call scale_one_tsum(T1sum(18)%cmp, 2)
  call scale_one_tsum(T1sum(19)%cmp, 2)
  call scale_one_tsum(T1sum(20)%cmp, 2)
  call scale_one_tsum(T1sum(21)%cmp, 2)
  call scale_one_tsum(T1sum(22)%cmp, 2)
  call scale_one_tsum(T1sum(23)%cmp, 2)
  call scale_one_tsum(T1sum(24)%cmp, 2)
  call scale_one_tsum(T1sum(25)%cmp, 2)
  call scale_one_tsum(T1sum(26)%cmp, 2)
  call scale_one_tsum(T1sum(27)%cmp, 2)
  call scale_one_tsum(T1sum(28)%cmp, 2)
  call scale_one_tsum(T1sum(29)%cmp, 2)
  call scale_one_tsum(T1sum(30)%cmp, 2)
  call scale_one_tsum(T1sum(31)%cmp, 2)
  call scale_one_tsum(T1sum(32)%cmp, 2)
  call scale_one_tsum(T1sum(33)%cmp, 2)
  call scale_one_tsum(T1sum(34)%cmp, 2)
  call scale_one_tsum(T1sum(35)%cmp, 2)
  call scale_one_tsum(T1sum(36)%cmp, 2)
  call scale_one_tsum(T1sum(37)%cmp, 2)
  call scale_one_tsum(T1sum(38)%cmp, 2)
  call scale_one_tsum(T1sum(39)%cmp, 2)
  call scale_one_tsum(T1sum(40)%cmp, 2)
  call scale_one_tsum(T1sum(41)%cmp, 2)
  call scale_one_tsum(T1sum(42)%cmp, 2)
  call scale_one_tsum(T1sum(43)%cmp, 2)
  call scale_one_tsum(T1sum(44)%cmp, 2)
  call scale_one_tsum(T1sum(45)%cmp, 2)
  call scale_one_tsum(T1sum(46)%cmp, 2)
  call scale_one_tsum(T1sum(47)%cmp, 2)
  call scale_one_tsum(T1sum(48)%cmp, 2)
  call scale_one_tsum(T1sum(49)%cmp, 2)
  call scale_one_tsum(T1sum(50)%cmp, 2)
  call scale_one_tsum(T1sum(51)%cmp, 2)
  call scale_one_tsum(T1sum(52)%cmp, 2)
  call scale_one_tsum(T1sum(53)%cmp, 2)
  call scale_one_tsum(T1sum(54)%cmp, 2)
  call scale_one_tsum(T1sum(55)%cmp, 2)
  call scale_one_tsum(T1sum(56)%cmp, 2)
  call scale_one_tsum(T1sum(57)%cmp, 2)
  call scale_one_tsum(T1sum(58)%cmp, 2)
  call scale_one_tsum(T1sum(59)%cmp, 2)
  call scale_one_tsum(T1sum(60)%cmp, 2)
  call scale_one_tsum(T1sum(61)%cmp, 2)
  call scale_one_tsum(T1sum(62)%cmp, 2)
  call scale_one_tsum(T0sum(1)%cmp, 0)
  call scale_one_tsum(T0sum(2)%cmp, 0)
  call scale_one_tsum(T0sum(3)%cmp, 0)
  call scale_one_tsum(T0sum(4)%cmp, 0)
  call scale_one_tsum(T0sum(5)%cmp, 0)
  call scale_one_tsum(T0sum(6)%cmp, 0)
  call scale_one_tsum(T0sum(7)%cmp, 0)
  call scale_one_tsum(T0sum(8)%cmp, 0)
  call scale_one_tsum(T0sum(9)%cmp, 0)
  call scale_one_tsum(T0sum(10)%cmp, 0)
  call scale_one_tsum(T0sum(11)%cmp, 0)
  call scale_one_tsum(T0sum(12)%cmp, 0)
  call scale_one_tsum(T0sum(13)%cmp, 0)
  call scale_one_tsum(T0sum(14)%cmp, 0)
  call scale_one_tsum(T0sum(15)%cmp, 0)
  call scale_one_tsum(T0sum(16)%cmp, 0)
  call scale_one_tsum(T0sum(17)%cmp, 0)
  call scale_one_tsum(T0sum(18)%cmp, 0)
  call scale_one_tsum(T0sum(19)%cmp, 0)
  call scale_one_tsum(T0sum(20)%cmp, 0)
  call scale_one_tsum(T0sum(21)%cmp, 0)
  call scale_one_tsum(T0sum(22)%cmp, 0)
  call scale_one_tsum(T0sum(23)%cmp, 0)
  call scale_one_tsum(T0sum(24)%cmp, 0)
  call scale_one_tsum(T0sum(25)%cmp, 0)
  call scale_one_tsum(T0sum(26)%cmp, 0)
  call scale_one_tsum(T0sum(27)%cmp, 0)
  call scale_one_tsum(T0sum(28)%cmp, 0)
  call scale_one_tsum(T0sum(29)%cmp, 0)
  call scale_one_tsum(T0sum(30)%cmp, 0)
  call scale_one_tsum(T0sum(31)%cmp, 0)
  call scale_one_tsum(T0sum(32)%cmp, 0)
  call scale_one_tsum(T0sum(33)%cmp, 0)
  call scale_one_tsum(T0sum(34)%cmp, 0)
  call scale_one_tsum(T0sum(35)%cmp, 0)
  call scale_one_tsum(T0sum(36)%cmp, 0)
  call scale_one_tsum(T0sum(37)%cmp, 0)
  call scale_one_tsum(T0sum(38)%cmp, 0)
  call scale_one_tsum(T0sum(39)%cmp, 0)
  call scale_one_tsum(T0sum(40)%cmp, 0)
  call scale_one_tsum(T0sum(41)%cmp, 0)
  call scale_one_tsum(T0sum(42)%cmp, 0)
  call scale_one_tsum(T0sum(43)%cmp, 0)
  call scale_one_tsum(T0sum(44)%cmp, 0)
  call scale_one_tsum(T0sum(45)%cmp, 0)
  call scale_one_tsum(T0sum(46)%cmp, 0)
  call scale_one_tsum(T0sum(47)%cmp, 0)
  call scale_one_tsum(T0sum(48)%cmp, 0)
  call scale_one_tsum(T0sum(49)%cmp, 0)
  call scale_one_tsum(T0sum(50)%cmp, 0)
  call scale_one_tsum(T0sum(51)%cmp, 0)
  call scale_one_tsum(T0sum(52)%cmp, 0)
  call scale_one_tsum(T0sum(53)%cmp, 0)
  call scale_one_tsum(T0sum(54)%cmp, 0)
  call scale_one_tsum(T0sum(55)%cmp, 0)
  call scale_one_tsum(T0sum(56)%cmp, 0)
  call scale_one_tsum(T0sum(57)%cmp, 0)
  call scale_one_tsum(T0sum(58)%cmp, 0)
  call scale_one_tsum(T0sum(59)%cmp, 0)
  call scale_one_tsum(T0sum(60)%cmp, 0)
  call scale_one_tsum(T0sum(61)%cmp, 0)
  call scale_one_tsum(T0sum(62)%cmp, 0)
  call scale_one_tsum(T0sum(63)%cmp, 0)
  call scale_one_tsum(T0sum(64)%cmp, 0)
  call scale_one_tsum(T0sum(65)%cmp, 0)
  call scale_one_tsum(T0sum(66)%cmp, 0)
  call scale_one_tsum(T0sum(67)%cmp, 0)
  call scale_one_tsum(T0sum(68)%cmp, 0)
  call scale_one_tsum(T0sum(69)%cmp, 0)
  call scale_one_tsum(T0sum(70)%cmp, 0)
  call scale_one_tsum(T0sum(71)%cmp, 0)
  call scale_one_tsum(T0sum(72)%cmp, 0)
  call scale_one_tsum(T0sum(73)%cmp, 0)
  call scale_one_tsum(T0sum(74)%cmp, 0)
  call scale_one_tsum(T0sum(75)%cmp, 0)
  call scale_one_tsum(T0sum(76)%cmp, 0)
  call scale_one_tsum(T0sum(77)%cmp, 0)
  call scale_one_tsum(T0sum(78)%cmp, 0)
  call scale_one_tsum(T0sum(79)%cmp, 0)
  call scale_one_tsum(T0sum(80)%cmp, 0)
  call scale_one_tsum(T0sum(81)%cmp, 0)
  call scale_one_tsum(T0sum(82)%cmp, 0)
  call scale_one_tsum(T0sum(83)%cmp, 0)
  call scale_one_tsum(T0sum(84)%cmp, 0)
  call scale_one_tsum(T0sum(85)%cmp, 0)
  call scale_one_tsum(T0sum(86)%cmp, 0)
  call scale_one_tsum(T0sum(87)%cmp, 0)
  call scale_one_tsum(T0sum(88)%cmp, 0)
  call scale_one_tsum(T0sum(89)%cmp, 0)
  call scale_one_tsum(T0sum(90)%cmp, 0)
  call scale_one_tsum(T0sum(91)%cmp, 0)
  call scale_one_tsum(T0sum(92)%cmp, 0)
  call scale_one_tsum(T0sum(93)%cmp, 0)
  call scale_one_tsum(T0sum(94)%cmp, 0)
  call scale_one_tsum(T0sum(95)%cmp, 0)
  call scale_one_tsum(T0sum(96)%cmp, 0)
  call scale_one_tsum(T0sum(97)%cmp, 0)
  call scale_one_tsum(T0sum(98)%cmp, 0)
  call scale_one_tsum(T0sum(99)%cmp, 0)
  call scale_one_tsum(T0sum(100)%cmp, 0)
  call scale_one_tsum(T0sum(101)%cmp, 0)
  call scale_one_tsum(T0sum(102)%cmp, 0)
  call scale_one_tsum(T0sum(103)%cmp, 0)
  call scale_one_tsum(T0sum(104)%cmp, 0)
  call scale_one_tsum(T0sum(105)%cmp, 0)
  call scale_one_tsum(T0sum(106)%cmp, 0)
  call scale_one_tsum(T0sum(107)%cmp, 0)
  call scale_one_tsum(T0sum(108)%cmp, 0)
  call scale_one_tsum(T0sum(109)%cmp, 0)
  call scale_one_tsum(T0sum(110)%cmp, 0)
  call scale_one_tsum(T0sum(111)%cmp, 0)
  call scale_one_tsum(T0sum(112)%cmp, 0)
  call scale_one_tsum(T0sum(113)%cmp, 0)
  call scale_one_tsum(T0sum(114)%cmp, 0)
  call scale_one_tsum(T0sum(115)%cmp, 0)
  call scale_one_tsum(T0sum(116)%cmp, 0)
  call scale_one_tsum(T0sum(117)%cmp, 0)
  call scale_one_tsum(T0sum(118)%cmp, 0)
  call scale_one_tsum(T0sum(119)%cmp, 0)
  call scale_one_tsum(T0sum(120)%cmp, 0)
  call scale_one_tsum(T0sum(121)%cmp, 0)
  call scale_one_tsum(T0sum(122)%cmp, 0)
  call scale_one_tsum(T0sum(123)%cmp, 0)
  call scale_one_tsum(T0sum(124)%cmp, 0)
  call scale_one_tsum(T0sum(125)%cmp, 0)
  call scale_one_tsum(T0sum(126)%cmp, 0)
  call scale_one_tsum(T0sum(127)%cmp, 0)
  call scale_one_tsum(T0sum(128)%cmp, 0)
  call scale_one_tsum(T0sum(129)%cmp, 0)
  call scale_one_tsum(T0sum(130)%cmp, 0)
  call scale_one_tsum(T0sum(131)%cmp, 0)
  call scale_one_tsum(T0sum(132)%cmp, 0)
  call scale_one_tsum(T0sum(133)%cmp, 0)
  call scale_one_tsum(T0sum(134)%cmp, 0)
  call scale_one_tsum(T0sum(135)%cmp, 0)
  call scale_one_tsum(T0sum(136)%cmp, 0)
  call scale_one_tsum(T0sum(137)%cmp, 0)
  call scale_one_tsum(T0sum(138)%cmp, 0)
  call scale_one_tsum(T0sum(139)%cmp, 0)
  call scale_one_tsum(T0sum(140)%cmp, 0)
  call scale_one_tsum(T0sum(141)%cmp, 0)
  call scale_one_tsum(T0sum(142)%cmp, 0)
  call scale_one_tsum(T0sum(143)%cmp, 0)
  call scale_one_tsum(T0sum(144)%cmp, 0)
  call scale_one_tsum(T0sum(145)%cmp, 0)
  call scale_one_tsum(T0sum(146)%cmp, 0)
  call scale_one_tsum(T0sum(147)%cmp, 0)
  call scale_one_tsum(T0sum(148)%cmp, 0)
  call scale_one_tsum(T0sum(149)%cmp, 0)
  call scale_one_tsum(T0sum(150)%cmp, 0)
  call scale_one_tsum(T0sum(151)%cmp, 0)
  call scale_one_tsum(T0sum(152)%cmp, 0)
  call scale_one_tsum(T0sum(153)%cmp, 0)
  call scale_one_tsum(T0sum(154)%cmp, 0)
  call scale_one_tsum(T0sum(155)%cmp, 0)
  call scale_one_tsum(T0sum(156)%cmp, 0)
  call scale_one_tsum(T0sum(157)%cmp, 0)
  call scale_one_tsum(T0sum(158)%cmp, 0)
  call scale_one_tsum(T0sum(159)%cmp, 0)
  call scale_one_tsum(T0sum(160)%cmp, 0)
  call scale_one_tsum(T0sum(161)%cmp, 0)
  call scale_one_tsum(T0sum(162)%cmp, 0)
  call scale_one_tsum(T0sum(163)%cmp, 0)
  call scale_one_tsum(T0sum(164)%cmp, 0)
  call scale_one_tsum(T0sum(165)%cmp, 0)
  call scale_one_tsum(T0sum(166)%cmp, 0)
  call scale_one_tsum(T0sum(167)%cmp, 0)
  call scale_one_tsum(T0sum(168)%cmp, 0)
  call scale_one_tsum(T0sum(169)%cmp, 0)
  call scale_one_tsum(T0sum(170)%cmp, 0)
  call scale_one_tsum(T0sum(171)%cmp, 0)
  call scale_one_tsum(T0sum(172)%cmp, 0)
  call scale_one_tsum(T0sum(173)%cmp, 0)
  call scale_one_tsum(T0sum(174)%cmp, 0)
  call scale_one_tsum(T0sum(175)%cmp, 0)
  call scale_one_tsum(T0sum(176)%cmp, 0)
  call scale_one_tsum(T0sum(177)%cmp, 0)
  call scale_one_tsum(T0sum(178)%cmp, 0)
  call scale_one_tsum(T0sum(179)%cmp, 0)
  call scale_one_tsum(T0sum(180)%cmp, 0)
  call scale_one_tsum(T0sum(181)%cmp, 0)
  call scale_one_tsum(T0sum(182)%cmp, 0)
  call scale_one_tsum(T0sum(183)%cmp, 0)
  call scale_one_tsum(T0sum(184)%cmp, 0)
  call scale_one_tsum(T0sum(185)%cmp, 0)
  call scale_one_tsum(T0sum(186)%cmp, 0)
  call scale_one_tsum(T0sum(187)%cmp, -2)
  call scale_one_tsum(T0sum(188)%cmp, -2)
  call scale_one_tsum(T0sum(189)%cmp, -2)
  call scale_one_tsum(T0sum(190)%cmp, -2)
  call scale_one_tsum(T0sum(191)%cmp, -2)
  call scale_one_tsum(T0sum(192)%cmp, -2)
  call scale_one_tsum(T0sum(193)%cmp, -2)
  call scale_one_tsum(T0sum(194)%cmp, -2)
  call scale_one_tsum(T0sum(195)%cmp, -2)
  call scale_one_tsum(T0sum(196)%cmp, -2)
  call scale_one_tsum(T0sum(197)%cmp, -2)
  call scale_one_tsum(T0sum(198)%cmp, -2)
  call scale_one_tsum(T0sum(199)%cmp, -2)
  call scale_one_tsum(T0sum(200)%cmp, -2)
  call scale_one_tsum(T0sum(201)%cmp, -2)
  call scale_one_tsum(T0sum(202)%cmp, -2)
  call scale_one_tsum(T0sum(203)%cmp, -2)
  call scale_one_tsum(T0sum(204)%cmp, -2)
  call scale_one_tsum(T0sum(205)%cmp, -2)
  call scale_one_tsum(T0sum(206)%cmp, -2)
  call scale_one_tsum(T0sum(207)%cmp, -2)
  call scale_one_tsum(T0sum(208)%cmp, -2)
  call scale_one_tsum(T0sum(209)%cmp, -2)
  call scale_one_tsum(T0sum(210)%cmp, -2)
  call scale_one_tsum(T0sum(211)%cmp, -2)
  call scale_one_tsum(T0sum(212)%cmp, -2)
  call scale_one_tsum(T0sum(213)%cmp, -2)
  call scale_one_tsum(T0sum(214)%cmp, -2)
  call scale_one_tsum(T0sum(215)%cmp, -2)
  call scale_one_tsum(T0sum(216)%cmp, -2)
  call scale_one_tsum(T0sum(217)%cmp, -2)
  call scale_one_tsum(T0sum(218)%cmp, -2)
  call scale_one_tsum(T0sum(219)%cmp, -2)
  call scale_one_tsum(T0sum(220)%cmp, -2)
  call scale_one_tsum(T0sum(221)%cmp, -2)
  call scale_one_tsum(T0sum(222)%cmp, -2)
  call scale_one_tsum(T0sum(223)%cmp, -2)
  call scale_one_tsum(T0sum(224)%cmp, -2)
  call scale_one_tsum(T0sum(225)%cmp, -2)
  call scale_one_tsum(T0sum(226)%cmp, -2)
  call scale_one_tsum(T0sum(227)%cmp, -2)
  call scale_one_tsum(T0sum(228)%cmp, -2)
  call scale_one_tsum(T0sum(229)%cmp, -2)
  call scale_one_tsum(T0sum(230)%cmp, -2)
  call scale_one_tsum(T0sum(231)%cmp, -2)
  call scale_one_tsum(T0sum(232)%cmp, -2)
  call scale_one_tsum(T0sum(233)%cmp, -2)
  call scale_one_tsum(T0sum(234)%cmp, -2)
  call scale_one_tsum(T0sum(235)%cmp, -2)
  call scale_one_tsum(T0sum(236)%cmp, -2)
  call scale_one_tsum(T0sum(237)%cmp, -2)
  call scale_one_tsum(T0sum(238)%cmp, -2)
  call scale_one_tsum(T0sum(239)%cmp, -2)
  call scale_one_tsum(T0sum(240)%cmp, -2)
  call scale_one_tsum(T0sum(241)%cmp, -2)
  call scale_one_tsum(T0sum(242)%cmp, -2)
  call scale_one_tsum(T0sum(243)%cmp, -2)
  call scale_one_tsum(T0sum(244)%cmp, -2)
  call scale_one_tsum(T0sum(245)%cmp, -2)
  call scale_one_tsum(T0sum(246)%cmp, -2)
  call scale_one_tsum(T0sum(247)%cmp, -2)
  call scale_one_tsum(T0sum(248)%cmp, -2)
  call scale_one_tsum(T0sum(249)%cmp, -2)
  call scale_one_tsum(T0sum(250)%cmp, -2)
  call scale_one_tsum(T0sum(251)%cmp, -2)
  call scale_one_tsum(T0sum(252)%cmp, -2)
  call scale_one_tsum(T0sum(253)%cmp, -2)
  call scale_one_tsum(T0sum(254)%cmp, -2)
  call scale_one_tsum(T0sum(255)%cmp, -2)
  call scale_one_tsum(T0sum(256)%cmp, -2)
  call scale_one_tsum(T0sum(257)%cmp, -2)
  call scale_one_tsum(T0sum(258)%cmp, -2)
  call scale_one_tsum(T0sum(259)%cmp, -2)
  call scale_one_tsum(T0sum(260)%cmp, -2)
  call scale_one_tsum(T0sum(261)%cmp, -2)
  call scale_one_tsum(T0sum(262)%cmp, -2)
  call scale_one_tsum(T0sum(263)%cmp, -2)
  call scale_one_tsum(T0sum(264)%cmp, -2)
  call scale_one_tsum(T0sum(265)%cmp, -2)
  call scale_one_tsum(T0sum(266)%cmp, -2)
  call scale_one_tsum(T0sum(267)%cmp, -2)
  call scale_one_tsum(T0sum(268)%cmp, -2)
  call scale_one_tsum(T0sum(269)%cmp, -2)
  call scale_one_tsum(T0sum(270)%cmp, -2)
  call scale_one_tsum(T0sum(271)%cmp, -2)
  call scale_one_tsum(T0sum(272)%cmp, -2)
  call scale_one_tsum(T0sum(273)%cmp, -2)
  call scale_one_tsum(T0sum(274)%cmp, -2)
  call scale_one_tsum(T0sum(275)%cmp, -2)
  call scale_one_tsum(T0sum(276)%cmp, -2)
  call scale_one_tsum(T0sum(277)%cmp, -2)
  call scale_one_tsum(T0sum(278)%cmp, -2)
  call scale_one_tsum(T0sum(279)%cmp, -2)
  call scale_one_tsum(T0sum(280)%cmp, -2)
  call scale_one_tsum(T0sum(281)%cmp, -2)
  call scale_one_tsum(T0sum(282)%cmp, -2)
  call scale_one_tsum(T0sum(283)%cmp, -2)
  call scale_one_tsum(T0sum(284)%cmp, -2)
  call scale_one_tsum(T0sum(285)%cmp, -2)
  call scale_one_tsum(T0sum(286)%cmp, -2)
  call scale_one_tsum(T0sum(287)%cmp, -2)
  call scale_one_tsum(T0sum(288)%cmp, -2)
  call scale_one_tsum(T0sum(289)%cmp, -2)
  call scale_one_tsum(T0sum(290)%cmp, -2)
  call scale_one_tsum(T0sum(291)%cmp, -2)
  call scale_one_tsum(T0sum(292)%cmp, -2)
  call scale_one_tsum(T0sum(293)%cmp, -2)
  call scale_one_tsum(T0sum(294)%cmp, -2)
  call scale_one_tsum(T0sum(295)%cmp, -2)
  call scale_one_tsum(T0sum(296)%cmp, -2)
  call scale_one_tsum(T0sum(297)%cmp, -2)
  call scale_one_tsum(T0sum(298)%cmp, -2)
  call scale_one_tsum(T0sum(299)%cmp, -2)
  call scale_one_tsum(T0sum(300)%cmp, -2)
  call scale_one_tsum(T0sum(301)%cmp, -2)
  call scale_one_tsum(T0sum(302)%cmp, -2)
  call scale_one_tsum(T0sum(303)%cmp, -2)
  call scale_one_tsum(T0sum(304)%cmp, -2)
  call scale_one_tsum(T0sum(305)%cmp, -2)
  call scale_one_tsum(T0sum(306)%cmp, -2)
  call scale_one_tsum(T0sum(307)%cmp, -2)
  call scale_one_tsum(T0sum(308)%cmp, -2)
  call scale_one_tsum(T0sum(309)%cmp, -2)
  call scale_one_tsum(T0sum(310)%cmp, -2)
  call scale_one_tsum(T0sum(311)%cmp, -2)
  call scale_one_tsum(T0sum(312)%cmp, -2)
  call scale_one_tsum(T0sum(313)%cmp, -2)
  call scale_one_tsum(T0sum(314)%cmp, -2)
  call scale_one_tsum(T0sum(315)%cmp, -2)
  call scale_one_tsum(T0sum(316)%cmp, -2)
  call scale_one_tsum(T0sum(317)%cmp, -2)
  call scale_one_tsum(T0sum(318)%cmp, -2)
  call scale_one_tsum(T0sum(319)%cmp, -2)
  call scale_one_tsum(T0sum(320)%cmp, -2)
  call scale_one_tsum(T0sum(321)%cmp, -2)
  call scale_one_tsum(T0sum(322)%cmp, -2)
  call scale_one_tsum(T0sum(323)%cmp, -2)
  call scale_one_tsum(T0sum(324)%cmp, -2)
  call scale_one_tsum(T0sum(325)%cmp, -2)
  call scale_one_tsum(T0sum(326)%cmp, -2)
  call scale_one_tsum(T0sum(327)%cmp, -2)
  call scale_one_tsum(T0sum(328)%cmp, -2)
  call scale_one_tsum(T0sum(329)%cmp, -2)
  call scale_one_tsum(T0sum(330)%cmp, -2)
  call scale_one_tsum(T0sum(331)%cmp, -2)
  call scale_one_tsum(T0sum(332)%cmp, -2)
  call scale_one_tsum(T0sum(333)%cmp, -2)
  call scale_one_tsum(T0sum(334)%cmp, -2)
  call scale_one_tsum(T0sum(335)%cmp, -2)
  call scale_one_tsum(T0sum(336)%cmp, -2)
  call scale_one_tsum(T0sum(337)%cmp, -2)
  call scale_one_tsum(T0sum(338)%cmp, -2)
  call scale_one_tsum(T0sum(339)%cmp, -2)
  call scale_one_tsum(T0sum(340)%cmp, -2)
  call scale_one_tsum(T0sum(341)%cmp, -2)
  call scale_one_tsum(T0sum(342)%cmp, -2)
  call scale_one_tsum(T0sum(343)%cmp, -2)
  call scale_one_tsum(T0sum(344)%cmp, -2)
  call scale_one_tsum(T0sum(345)%cmp, -2)
  call scale_one_tsum(T0sum(346)%cmp, -2)
  call scale_one_tsum(T0sum(347)%cmp, -2)
  call scale_one_tsum(T0sum(348)%cmp, -2)
  call scale_one_tsum(T0sum(349)%cmp, -2)
  call scale_one_tsum(T0sum(350)%cmp, -2)
  call scale_one_tsum(T0sum(351)%cmp, -2)
  call scale_one_tsum(T0sum(352)%cmp, -2)
  call scale_one_tsum(T0sum(353)%cmp, -2)
  call scale_one_tsum(T0sum(354)%cmp, -2)
  call scale_one_tsum(T0sum(355)%cmp, -2)
  call scale_one_tsum(T0sum(356)%cmp, -2)
  call scale_one_tsum(T0sum(357)%cmp, -2)
  call scale_one_tsum(T0sum(358)%cmp, -2)
  call scale_one_tsum(T0sum(359)%cmp, -2)
  call scale_one_tsum(T0sum(360)%cmp, -2)
  call scale_one_tsum(T0sum(361)%cmp, -2)
  call scale_one_tsum(T0sum(362)%cmp, -2)
  call scale_one_tsum(T0sum(363)%cmp, -2)
  call scale_one_tsum(T0sum(364)%cmp, -2)
  call scale_one_tsum(T0sum(365)%cmp, -2)
  call scale_one_tsum(T0sum(366)%cmp, -2)
  call scale_one_tsum(T0sum(367)%cmp, -2)
  call scale_one_tsum(T0sum(368)%cmp, -2)
  call scale_one_tsum(T0sum(369)%cmp, -2)
  call scale_one_tsum(T0sum(370)%cmp, -2)
  call scale_one_tsum(T0sum(371)%cmp, -2)
  call scale_one_tsum(T0sum(372)%cmp, -2)
  call scale_one_tsum(T0sum(373)%cmp, -2)
  call scale_one_tsum(T0sum(374)%cmp, -2)
  call scale_one_tsum(T0sum(375)%cmp, -2)
  call scale_one_tsum(T0sum(376)%cmp, -2)
  call scale_one_tsum(T0sum(377)%cmp, -2)
  call scale_one_tsum(T0sum(378)%cmp, -2)
  call scale_one_tsum(T0sum(379)%cmp, -2)
  call scale_one_tsum(T0sum(380)%cmp, -2)
  call scale_one_tsum(T0sum(381)%cmp, -2)
  call scale_one_tsum(T0sum(382)%cmp, -2)
  call scale_one_tsum(T0sum(383)%cmp, -2)
  call scale_one_tsum(T0sum(384)%cmp, -2)
  call scale_one_tsum(T0sum(385)%cmp, -2)
  call scale_one_tsum(T0sum(386)%cmp, -2)
  call scale_one_tsum(T0sum(387)%cmp, -2)
  call scale_one_tsum(T0sum(388)%cmp, -2)
  call scale_one_tsum(T0sum(389)%cmp, -2)
  call scale_one_tsum(T0sum(390)%cmp, -2)
  call scale_one_tsum(T0sum(391)%cmp, -2)
  call scale_one_tsum(T0sum(392)%cmp, -2)
  call scale_one_tsum(T0sum(393)%cmp, -2)
  call scale_one_tsum(T0sum(394)%cmp, -2)
  call scale_one_tsum(T0sum(395)%cmp, -2)
  call scale_one_tsum(T0sum(396)%cmp, -2)
  call scale_one_tsum(T0sum(397)%cmp, -2)
  call scale_one_tsum(T0sum(398)%cmp, -2)
  call scale_one_tsum(T0sum(399)%cmp, -2)
  call scale_one_tsum(T0sum(400)%cmp, -2)
  call scale_one_tsum(T0sum(401)%cmp, -2)
  call scale_one_tsum(T0sum(402)%cmp, -2)
  call scale_one_tsum(T0sum(403)%cmp, -2)
  call scale_one_tsum(T0sum(404)%cmp, -2)
  call scale_one_tsum(T0sum(405)%cmp, -2)
  call scale_one_tsum(T0sum(406)%cmp, -2)
  call scale_one_tsum(T0sum(407)%cmp, -2)
  call scale_one_tsum(T0sum(408)%cmp, -2)
  call scale_one_tsum(T0sum(409)%cmp, -2)
  call scale_one_tsum(T0sum(410)%cmp, -2)
  call scale_one_tsum(T0sum(411)%cmp, -2)
  call scale_one_tsum(T0sum(412)%cmp, -2)
  call scale_one_tsum(T0sum(413)%cmp, -2)
  call scale_one_tsum(T0sum(414)%cmp, -2)
  call scale_one_tsum(T0sum(415)%cmp, -2)
  call scale_one_tsum(T0sum(416)%cmp, -2)
  call scale_one_tsum(T0sum(417)%cmp, -2)
  call scale_one_tsum(T0sum(418)%cmp, -2)
  call scale_one_tsum(T0sum(419)%cmp, -2)
  call scale_one_tsum(T0sum(420)%cmp, -2)
  call scale_one_tsum(T0sum(421)%cmp, -4)
  call scale_one_tsum(T0sum(422)%cmp, -4)
  call scale_one_tsum(T0sum(423)%cmp, -4)
  call scale_one_tsum(T0sum(424)%cmp, -4)
  call scale_one_tsum(T0sum(425)%cmp, -4)
  call scale_one_tsum(T0sum(426)%cmp, -4)
  call scale_one_tsum(T0sum(427)%cmp, -4)
  call scale_one_tsum(T0sum(428)%cmp, -4)
  call scale_one_tsum(T0sum(429)%cmp, -4)
  call scale_one_tsum(T0sum(430)%cmp, -4)
  call scale_one_tsum(T0sum(431)%cmp, -4)
  call scale_one_tsum(T0sum(432)%cmp, -4)
  call scale_one_tsum(T0sum(433)%cmp, -4)
  call scale_one_tsum(T0sum(434)%cmp, -4)
  call scale_one_tsum(T0sum(435)%cmp, -4)
  call scale_one_tsum(T0sum(436)%cmp, -4)
  call scale_one_tsum(T0sum(437)%cmp, -4)
  call scale_one_tsum(T0sum(438)%cmp, -4)
  call scale_one_tsum(T0sum(439)%cmp, -4)
  call scale_one_tsum(T0sum(440)%cmp, -4)
  call scale_one_tsum(T0sum(441)%cmp, -4)
  call scale_one_tsum(T0sum(442)%cmp, -4)
  call scale_one_tsum(T0sum(443)%cmp, -4)
  call scale_one_tsum(T0sum(444)%cmp, -4)
  call scale_one_tsum(T0sum(445)%cmp, -4)
  call scale_one_tsum(T0sum(446)%cmp, -4)
  call scale_one_tsum(T0sum(447)%cmp, -4)
  call scale_one_tsum(T0sum(448)%cmp, -4)
  call scale_one_tsum(T0sum(449)%cmp, -4)
  call scale_one_tsum(T0sum(450)%cmp, -4)
  call scale_one_tsum(T0sum(451)%cmp, -4)
  call scale_one_tsum(T0sum(452)%cmp, -4)
  call scale_one_tsum(T0sum(453)%cmp, -4)
  call scale_one_tsum(T0sum(454)%cmp, -4)
  call scale_one_tsum(T0sum(455)%cmp, -4)
  call scale_one_tsum(T0sum(456)%cmp, -4)
  call scale_one_tsum(T0sum(457)%cmp, -4)
  call scale_one_tsum(T0sum(458)%cmp, -4)
  call scale_one_tsum(T0sum(459)%cmp, -4)
  call scale_one_tsum(T0sum(460)%cmp, -4)
  call scale_one_tsum(T0sum(461)%cmp, -4)
  call scale_one_tsum(T0sum(462)%cmp, -4)
  call scale_one_tsum(T0sum(463)%cmp, -4)
  call scale_one_tsum(T0sum(464)%cmp, -4)
  call scale_one_tsum(T0sum(465)%cmp, -4)
  call scale_one_tsum(T0sum(466)%cmp, -4)
  call scale_one_tsum(T0sum(467)%cmp, -4)
  call scale_one_tsum(T0sum(468)%cmp, -4)
  call scale_one_tsum(T0sum(469)%cmp, -4)
  call scale_one_tsum(T0sum(470)%cmp, -4)
  call scale_one_tsum(T0sum(471)%cmp, -4)
  call scale_one_tsum(T0sum(472)%cmp, -4)
  call scale_one_tsum(T0sum(473)%cmp, -4)
  call scale_one_tsum(T0sum(474)%cmp, -4)
  call scale_one_tsum(T0sum(475)%cmp, -4)
  call scale_one_tsum(T0sum(476)%cmp, -4)
  call scale_one_tsum(T0sum(477)%cmp, -4)
  call scale_one_tsum(T0sum(478)%cmp, -4)
  call scale_one_tsum(T0sum(479)%cmp, -4)
  call scale_one_tsum(T0sum(480)%cmp, -4)
  call scale_one_tsum(T0sum(481)%cmp, -4)
  call scale_one_tsum(T0sum(482)%cmp, -4)
  call scale_one_tsum(T0sum(483)%cmp, -4)
  call scale_one_tsum(T0sum(484)%cmp, -4)
  call scale_one_tsum(T0sum(485)%cmp, -4)
  call scale_one_tsum(T0sum(486)%cmp, -4)
  call scale_one_tsum(T0sum(487)%cmp, -4)
  call scale_one_tsum(T0sum(488)%cmp, -4)
  call scale_one_tsum(T0sum(489)%cmp, -4)
  call scale_one_tsum(T0sum(490)%cmp, -4)
  call scale_one_tsum(T0sum(491)%cmp, -4)
  call scale_one_tsum(T0sum(492)%cmp, -4)
  call scale_one_tsum(T0sum(493)%cmp, -4)
  call scale_one_tsum(T0sum(494)%cmp, -4)
  call scale_one_tsum(T0sum(495)%cmp, -4)
  call scale_one_tsum(T0sum(496)%cmp, -4)
  call scale_one_tsum(T0sum(497)%cmp, -4)
  call scale_one_tsum(T0sum(498)%cmp, -4)
  call scale_one_tsum(T0sum(499)%cmp, -4)
  call scale_one_tsum(T0sum(500)%cmp, -4)
  call scale_one_tsum(T0sum(501)%cmp, -4)
  call scale_one_tsum(T0sum(502)%cmp, -4)
  call scale_one_tsum(T0sum(503)%cmp, -4)
  call scale_one_tsum(T0sum(504)%cmp, -4)
  call scale_one_tsum(T0sum(505)%cmp, -4)
  call scale_one_tsum(T0sum(506)%cmp, -4)
  call scale_one_tsum(T0sum(507)%cmp, -4)
  call scale_one_tsum(T0sum(508)%cmp, -4)
  call scale_one_tsum(T0sum(509)%cmp, -4)
  call scale_one_tsum(T0sum(510)%cmp, -4)
  call scale_one_tsum(T0sum(511)%cmp, -4)
  call scale_one_tsum(T0sum(512)%cmp, -4)
  call scale_one_tsum(T0sum(513)%cmp, -4)
  call scale_one_tsum(T0sum(514)%cmp, -4)
  call scale_one_tsum(T0sum(515)%cmp, -4)
  call scale_one_tsum(T0sum(516)%cmp, -4)
  call scale_one_tsum(T0sum(517)%cmp, -4)
  call scale_one_tsum(T0sum(518)%cmp, -4)
  call scale_one_tsum(T0sum(519)%cmp, -4)
  call scale_one_tsum(T0sum(520)%cmp, -4)
  call scale_one_tsum(T0sum(521)%cmp, -4)
  call scale_one_tsum(T0sum(522)%cmp, -4)
  call scale_one_tsum(T0sum(523)%cmp, -4)
  call scale_one_tsum(T0sum(524)%cmp, -4)

end subroutine scale_tensor_sum

! **********************************************************************
subroutine set_integral_masses_and_momenta()
! **********************************************************************

  use ol_parameters_decl_/**/REALKIND
  momenta_1 = [ 0, 0 ]
  momenta_2 = [ 32, 31 ]
  momenta_3 = [ 33, 30 ]
  momenta_4 = [ 34, 29 ]
  momenta_5 = [ 35, 28 ]
  momenta_6 = [ 36, 27 ]
  momenta_7 = [ 39, 24 ]
  momenta_8 = [ 40, 23 ]
  momenta_9 = [ 43, 20 ]
  momenta_10 = [ 44, 19 ]
  momenta_11 = [ 45, 18 ]
  momenta_12 = [ 46, 17 ]
  momenta_13 = [ 47, 16 ]
  momenta_14 = [ 48, 15 ]
  momenta_15 = [ 51, 12 ]
  momenta_16 = [ 52, 11 ]
  momenta_17 = [ 53, 10 ]
  momenta_18 = [ 54, 9 ]
  momenta_19 = [ 55, 8 ]
  momenta_20 = [ 56, 7 ]
  momenta_21 = [ 57, 6 ]
  momenta_22 = [ 58, 5 ]
  momenta_23 = [ 59, 4 ]
  momenta_24 = [ 60, 3 ]
  momenta_25 = [ 61, 2 ]
  momenta_26 = [ 62, 1 ]
  momenta_27 = [ 32, 1, 30 ]
  momenta_28 = [ 32, 2, 29 ]
  momenta_29 = [ 32, 3, 28 ]
  momenta_30 = [ 32, 4, 27 ]
  momenta_31 = [ 32, 7, 24 ]
  momenta_32 = [ 32, 8, 23 ]
  momenta_33 = [ 32, 11, 20 ]
  momenta_34 = [ 32, 12, 19 ]
  momenta_35 = [ 32, 13, 18 ]
  momenta_36 = [ 32, 14, 17 ]
  momenta_37 = [ 32, 15, 16 ]
  momenta_38 = [ 32, 19, 12 ]
  momenta_39 = [ 32, 23, 8 ]
  momenta_40 = [ 32, 27, 4 ]
  momenta_41 = [ 33, 2, 28 ]
  momenta_42 = [ 33, 6, 24 ]
  momenta_43 = [ 33, 10, 20 ]
  momenta_44 = [ 33, 14, 16 ]
  momenta_45 = [ 33, 18, 12 ]
  momenta_46 = [ 34, 1, 28 ]
  momenta_47 = [ 34, 5, 24 ]
  momenta_48 = [ 34, 9, 20 ]
  momenta_49 = [ 34, 13, 16 ]
  momenta_50 = [ 34, 17, 12 ]
  momenta_51 = [ 35, 4, 24 ]
  momenta_52 = [ 35, 8, 20 ]
  momenta_53 = [ 35, 12, 16 ]
  momenta_54 = [ 35, 16, 12 ]
  momenta_55 = [ 35, 20, 8 ]
  momenta_56 = [ 35, 24, 4 ]
  momenta_57 = [ 36, 3, 24 ]
  momenta_58 = [ 36, 8, 19 ]
  momenta_59 = [ 36, 9, 18 ]
  momenta_60 = [ 36, 10, 17 ]
  momenta_61 = [ 36, 11, 16 ]
  momenta_62 = [ 36, 19, 8 ]
  momenta_63 = [ 39, 8, 16 ]
  momenta_64 = [ 39, 16, 8 ]
  momenta_65 = [ 40, 3, 20 ]
  momenta_66 = [ 40, 4, 19 ]
  momenta_67 = [ 40, 5, 18 ]
  momenta_68 = [ 40, 6, 17 ]
  momenta_69 = [ 40, 7, 16 ]
  momenta_70 = [ 40, 19, 4 ]
  momenta_71 = [ 43, 4, 16 ]
  momenta_72 = [ 43, 16, 4 ]
  momenta_73 = [ 44, 1, 18 ]
  momenta_74 = [ 44, 2, 17 ]
  momenta_75 = [ 44, 3, 16 ]
  momenta_76 = [ 45, 2, 16 ]
  momenta_77 = [ 46, 1, 16 ]
  momenta_78 = [ 48, 1, 14 ]
  momenta_79 = [ 48, 2, 13 ]
  momenta_80 = [ 48, 3, 12 ]
  momenta_81 = [ 48, 4, 11 ]
  momenta_82 = [ 48, 5, 10 ]
  momenta_83 = [ 48, 6, 9 ]
  momenta_84 = [ 48, 7, 8 ]
  momenta_85 = [ 48, 8, 7 ]
  momenta_86 = [ 48, 11, 4 ]
  momenta_87 = [ 48, 12, 3 ]
  momenta_88 = [ 48, 13, 2 ]
  momenta_89 = [ 48, 14, 1 ]
  momenta_90 = [ 49, 2, 12 ]
  momenta_91 = [ 49, 4, 10 ]
  momenta_92 = [ 49, 6, 8 ]
  momenta_93 = [ 49, 8, 6 ]
  momenta_94 = [ 49, 10, 4 ]
  momenta_95 = [ 49, 12, 2 ]
  momenta_96 = [ 50, 1, 12 ]
  momenta_97 = [ 50, 4, 9 ]
  momenta_98 = [ 50, 5, 8 ]
  momenta_99 = [ 50, 8, 5 ]
  momenta_100 = [ 50, 9, 4 ]
  momenta_101 = [ 50, 12, 1 ]
  momenta_102 = [ 51, 4, 8 ]
  momenta_103 = [ 51, 8, 4 ]
  momenta_104 = [ 52, 1, 10 ]
  momenta_105 = [ 52, 2, 9 ]
  momenta_106 = [ 52, 3, 8 ]
  momenta_107 = [ 52, 8, 3 ]
  momenta_108 = [ 52, 9, 2 ]
  momenta_109 = [ 52, 10, 1 ]
  momenta_110 = [ 53, 2, 8 ]
  momenta_111 = [ 53, 8, 2 ]
  momenta_112 = [ 54, 1, 8 ]
  momenta_113 = [ 54, 8, 1 ]
  momenta_114 = [ 56, 1, 6 ]
  momenta_115 = [ 56, 2, 5 ]
  momenta_116 = [ 56, 3, 4 ]
  momenta_117 = [ 56, 4, 3 ]
  momenta_118 = [ 56, 5, 2 ]
  momenta_119 = [ 56, 6, 1 ]
  momenta_120 = [ 57, 2, 4 ]
  momenta_121 = [ 57, 4, 2 ]
  momenta_122 = [ 58, 1, 4 ]
  momenta_123 = [ 58, 4, 1 ]
  momenta_124 = [ 60, 1, 2 ]
  momenta_125 = [ 60, 2, 1 ]
  momenta_126 = [ 32, 1, 2, 28 ]
  momenta_127 = [ 32, 1, 6, 24 ]
  momenta_128 = [ 32, 1, 10, 20 ]
  momenta_129 = [ 32, 1, 14, 16 ]
  momenta_130 = [ 32, 1, 18, 12 ]
  momenta_131 = [ 32, 2, 1, 28 ]
  momenta_132 = [ 32, 2, 5, 24 ]
  momenta_133 = [ 32, 2, 9, 20 ]
  momenta_134 = [ 32, 2, 13, 16 ]
  momenta_135 = [ 32, 2, 17, 12 ]
  momenta_136 = [ 32, 3, 4, 24 ]
  momenta_137 = [ 32, 3, 8, 20 ]
  momenta_138 = [ 32, 3, 12, 16 ]
  momenta_139 = [ 32, 3, 16, 12 ]
  momenta_140 = [ 32, 3, 20, 8 ]
  momenta_141 = [ 32, 3, 24, 4 ]
  momenta_142 = [ 32, 4, 3, 24 ]
  momenta_143 = [ 32, 4, 8, 19 ]
  momenta_144 = [ 32, 4, 9, 18 ]
  momenta_145 = [ 32, 4, 10, 17 ]
  momenta_146 = [ 32, 4, 11, 16 ]
  momenta_147 = [ 32, 7, 8, 16 ]
  momenta_148 = [ 32, 8, 3, 20 ]
  momenta_149 = [ 32, 8, 4, 19 ]
  momenta_150 = [ 32, 8, 5, 18 ]
  momenta_151 = [ 32, 8, 6, 17 ]
  momenta_152 = [ 32, 8, 7, 16 ]
  momenta_153 = [ 32, 11, 4, 16 ]
  momenta_154 = [ 32, 12, 1, 18 ]
  momenta_155 = [ 32, 12, 2, 17 ]
  momenta_156 = [ 32, 12, 3, 16 ]
  momenta_157 = [ 32, 13, 2, 16 ]
  momenta_158 = [ 32, 14, 1, 16 ]
  momenta_159 = [ 32, 19, 4, 8 ]
  momenta_160 = [ 32, 19, 8, 4 ]
  momenta_161 = [ 33, 2, 4, 24 ]
  momenta_162 = [ 33, 2, 8, 20 ]
  momenta_163 = [ 33, 2, 12, 16 ]
  momenta_164 = [ 33, 2, 16, 12 ]
  momenta_165 = [ 33, 6, 8, 16 ]
  momenta_166 = [ 33, 10, 4, 16 ]
  momenta_167 = [ 34, 1, 4, 24 ]
  momenta_168 = [ 34, 1, 8, 20 ]
  momenta_169 = [ 34, 1, 12, 16 ]
  momenta_170 = [ 34, 1, 16, 12 ]
  momenta_171 = [ 34, 5, 8, 16 ]
  momenta_172 = [ 34, 9, 4, 16 ]
  momenta_173 = [ 35, 4, 8, 16 ]
  momenta_174 = [ 35, 8, 4, 16 ]
  momenta_175 = [ 35, 16, 4, 8 ]
  momenta_176 = [ 35, 16, 8, 4 ]
  momenta_177 = [ 36, 3, 8, 16 ]
  momenta_178 = [ 36, 3, 16, 8 ]
  momenta_179 = [ 36, 8, 1, 18 ]
  momenta_180 = [ 36, 8, 2, 17 ]
  momenta_181 = [ 36, 8, 3, 16 ]
  momenta_182 = [ 36, 9, 2, 16 ]
  momenta_183 = [ 36, 10, 1, 16 ]
  momenta_184 = [ 40, 3, 4, 16 ]
  momenta_185 = [ 40, 3, 16, 4 ]
  momenta_186 = [ 40, 4, 1, 18 ]
  momenta_187 = [ 40, 4, 2, 17 ]
  momenta_188 = [ 40, 4, 3, 16 ]
  momenta_189 = [ 40, 5, 2, 16 ]
  momenta_190 = [ 40, 6, 1, 16 ]
  momenta_191 = [ 44, 1, 2, 16 ]
  momenta_192 = [ 44, 2, 1, 16 ]
  momenta_193 = [ 48, 1, 2, 12 ]
  momenta_194 = [ 48, 1, 6, 8 ]
  momenta_195 = [ 48, 1, 10, 4 ]
  momenta_196 = [ 48, 2, 1, 12 ]
  momenta_197 = [ 48, 2, 5, 8 ]
  momenta_198 = [ 48, 2, 9, 4 ]
  momenta_199 = [ 48, 3, 4, 8 ]
  momenta_200 = [ 48, 3, 8, 4 ]
  momenta_201 = [ 48, 4, 1, 10 ]
  momenta_202 = [ 48, 4, 2, 9 ]
  momenta_203 = [ 48, 4, 3, 8 ]
  momenta_204 = [ 48, 4, 8, 3 ]
  momenta_205 = [ 48, 4, 9, 2 ]
  momenta_206 = [ 48, 4, 10, 1 ]
  momenta_207 = [ 48, 5, 2, 8 ]
  momenta_208 = [ 48, 6, 1, 8 ]
  momenta_209 = [ 48, 8, 3, 4 ]
  momenta_210 = [ 48, 8, 4, 3 ]
  momenta_211 = [ 48, 8, 5, 2 ]
  momenta_212 = [ 48, 8, 6, 1 ]
  momenta_213 = [ 48, 12, 1, 2 ]
  momenta_214 = [ 48, 12, 2, 1 ]
  momenta_215 = [ 49, 2, 4, 8 ]
  momenta_216 = [ 49, 2, 8, 4 ]
  momenta_217 = [ 49, 4, 8, 2 ]
  momenta_218 = [ 49, 8, 4, 2 ]
  momenta_219 = [ 50, 1, 4, 8 ]
  momenta_220 = [ 50, 1, 8, 4 ]
  momenta_221 = [ 50, 4, 8, 1 ]
  momenta_222 = [ 50, 8, 4, 1 ]
  momenta_223 = [ 52, 1, 2, 8 ]
  momenta_224 = [ 52, 2, 1, 8 ]
  momenta_225 = [ 52, 8, 1, 2 ]
  momenta_226 = [ 52, 8, 2, 1 ]
  momenta_227 = [ 56, 1, 2, 4 ]
  momenta_228 = [ 56, 2, 1, 4 ]
  momenta_229 = [ 56, 4, 1, 2 ]
  momenta_230 = [ 56, 4, 2, 1 ]
  momenta_231 = [ 32, 1, 2, 12, 16 ]
  momenta_232 = [ 32, 1, 2, 16, 12 ]
  momenta_233 = [ 32, 1, 6, 8, 16 ]
  momenta_234 = [ 32, 1, 10, 4, 16 ]
  momenta_235 = [ 32, 2, 1, 12, 16 ]
  momenta_236 = [ 32, 2, 1, 16, 12 ]
  momenta_237 = [ 32, 2, 5, 8, 16 ]
  momenta_238 = [ 32, 2, 9, 4, 16 ]
  momenta_239 = [ 32, 3, 4, 8, 16 ]
  momenta_240 = [ 32, 3, 8, 4, 16 ]
  momenta_241 = [ 32, 3, 16, 4, 8 ]
  momenta_242 = [ 32, 3, 16, 8, 4 ]
  momenta_243 = [ 32, 4, 3, 8, 16 ]
  momenta_244 = [ 32, 4, 8, 3, 16 ]
  momenta_245 = [ 32, 4, 9, 2, 16 ]
  momenta_246 = [ 32, 4, 10, 1, 16 ]
  momenta_247 = [ 32, 8, 3, 4, 16 ]
  momenta_248 = [ 32, 8, 4, 3, 16 ]
  momenta_249 = [ 32, 8, 5, 2, 16 ]
  momenta_250 = [ 32, 8, 6, 1, 16 ]
  momenta_251 = [ 32, 12, 1, 2, 16 ]
  momenta_252 = [ 32, 12, 2, 1, 16 ]
  momenta_253 = [ 33, 2, 4, 8, 16 ]
  momenta_254 = [ 33, 2, 8, 4, 16 ]
  momenta_255 = [ 34, 1, 4, 8, 16 ]
  momenta_256 = [ 34, 1, 8, 4, 16 ]
  momenta_257 = [ 36, 8, 1, 2, 16 ]
  momenta_258 = [ 36, 8, 2, 1, 16 ]
  momenta_259 = [ 40, 4, 1, 2, 16 ]
  momenta_260 = [ 40, 4, 2, 1, 16 ]
  momenta_261 = [ 48, 1, 2, 4, 8 ]
  momenta_262 = [ 48, 1, 2, 8, 4 ]
  momenta_263 = [ 48, 2, 1, 4, 8 ]
  momenta_264 = [ 48, 2, 1, 8, 4 ]
  momenta_265 = [ 48, 4, 1, 2, 8 ]
  momenta_266 = [ 48, 4, 2, 1, 8 ]
  momenta_267 = [ 48, 4, 8, 1, 2 ]
  momenta_268 = [ 48, 4, 8, 2, 1 ]
  momenta_269 = [ 48, 8, 4, 1, 2 ]
  momenta_270 = [ 48, 8, 4, 2, 1 ]
  momenta_271 = [ 32, 1, 2, 4, 8, 16 ]
  momenta_272 = [ 32, 1, 2, 8, 4, 16 ]
  momenta_273 = [ 32, 2, 1, 4, 8, 16 ]
  momenta_274 = [ 32, 2, 1, 8, 4, 16 ]
  momenta_275 = [ 32, 4, 8, 1, 2, 16 ]
  momenta_276 = [ 32, 4, 8, 2, 1, 16 ]
  momenta_277 = [ 32, 8, 4, 1, 2, 16 ]
  momenta_278 = [ 32, 8, 4, 2, 1, 16 ]

  masses2_1 = [ 0, 0 ]
  masses2_2 = [ nMB, 0 ]
  masses2_3 = [ nMH, 0 ]
  masses2_4 = [ nML, 0 ]
  masses2_5 = [ nMM, 0 ]
  masses2_6 = [ nMT, 0 ]
  masses2_7 = [ nMW, 0 ]
  masses2_8 = [ nMZ, 0 ]
  masses2_9 = [ 0, nMB ]
  masses2_10 = [ nMB, nMB ]
  masses2_11 = [ nMH, nMB ]
  masses2_12 = [ nMZ, nMB ]
  masses2_13 = [ nMB, nMH ]
  masses2_14 = [ nMZ, nMH ]
  masses2_15 = [ nML, nML ]
  masses2_16 = [ nMM, nMM ]
  masses2_17 = [ nMT, nMT ]
  masses2_18 = [ nMW, nMT ]
  masses2_19 = [ 0, nMW ]
  masses2_20 = [ nMT, nMW ]
  masses2_21 = [ nMW, nMW ]
  masses2_22 = [ 0, nMZ ]
  masses2_23 = [ nMB, nMZ ]
  masses2_24 = [ nMH, nMZ ]
  masses2_25 = [ nMZ, nMZ ]
  masses2_26 = [ 0, 0, 0 ]
  masses2_27 = [ nMB, 0, 0 ]
  masses2_28 = [ nMH, 0, 0 ]
  masses2_29 = [ nMW, 0, 0 ]
  masses2_30 = [ nMZ, 0, 0 ]
  masses2_31 = [ nMB, 0, nMB ]
  masses2_32 = [ nMB, 0, nMH ]
  masses2_33 = [ nMT, 0, nMT ]
  masses2_34 = [ 0, 0, nMW ]
  masses2_35 = [ nMT, 0, nMW ]
  masses2_36 = [ nMW, 0, nMW ]
  masses2_37 = [ 0, 0, nMZ ]
  masses2_38 = [ nMB, 0, nMZ ]
  masses2_39 = [ nMH, 0, nMZ ]
  masses2_40 = [ nMZ, 0, nMZ ]
  masses2_41 = [ 0, nMB, 0 ]
  masses2_42 = [ nMZ, nMB, 0 ]
  masses2_43 = [ 0, nMB, nMB ]
  masses2_44 = [ nMB, nMB, nMB ]
  masses2_45 = [ nMH, nMB, nMB ]
  masses2_46 = [ nMZ, nMB, nMB ]
  masses2_47 = [ 0, nMB, nMZ ]
  masses2_48 = [ 0, nMH, 0 ]
  masses2_49 = [ nMB, nMH, 0 ]
  masses2_50 = [ nMB, nMH, nMB ]
  masses2_51 = [ 0, nMH, nMZ ]
  masses2_52 = [ nMB, nMH, nMZ ]
  masses2_53 = [ nMT, nMT, nMT ]
  masses2_54 = [ nMW, nMT, nMT ]
  masses2_55 = [ 0, nMW, 0 ]
  masses2_56 = [ nMT, nMW, 0 ]
  masses2_57 = [ nMW, nMW, 0 ]
  masses2_58 = [ nMT, nMW, nMT ]
  masses2_59 = [ 0, nMW, nMW ]
  masses2_60 = [ nMT, nMW, nMW ]
  masses2_61 = [ 0, nMZ, 0 ]
  masses2_62 = [ nMB, nMZ, 0 ]
  masses2_63 = [ nMZ, nMZ, 0 ]
  masses2_64 = [ nMB, nMZ, nMB ]
  masses2_65 = [ nMB, nMZ, nMH ]
  masses2_66 = [ 0, nMZ, nMZ ]
  masses2_67 = [ nMB, nMZ, nMZ ]
  masses2_68 = [ 0, 0, 0, 0 ]
  masses2_69 = [ nMB, 0, 0, 0 ]
  masses2_70 = [ nMZ, 0, 0, 0 ]
  masses2_71 = [ nMB, 0, 0, nMH ]
  masses2_72 = [ 0, 0, 0, nMW ]
  masses2_73 = [ 0, 0, 0, nMZ ]
  masses2_74 = [ nMB, 0, 0, nMZ ]
  masses2_75 = [ nMH, 0, 0, nMZ ]
  masses2_76 = [ nMZ, 0, 0, nMZ ]
  masses2_77 = [ 0, 0, nMW, 0 ]
  masses2_78 = [ nMW, 0, nMW, 0 ]
  masses2_79 = [ nMT, 0, nMW, nMT ]
  masses2_80 = [ nMW, 0, nMW, nMT ]
  masses2_81 = [ 0, 0, nMW, nMW ]
  masses2_82 = [ 0, 0, nMZ, 0 ]
  masses2_83 = [ nMB, 0, nMZ, 0 ]
  masses2_84 = [ nMZ, 0, nMZ, 0 ]
  masses2_85 = [ nMB, 0, nMZ, nMB ]
  masses2_86 = [ nMZ, 0, nMZ, nMB ]
  masses2_87 = [ 0, 0, nMZ, nMH ]
  masses2_88 = [ nMB, 0, nMZ, nMH ]
  masses2_89 = [ 0, 0, nMZ, nMZ ]
  masses2_90 = [ nMB, 0, nMZ, nMZ ]
  masses2_91 = [ 0, nMB, 0, 0 ]
  masses2_92 = [ nMB, nMB, 0, 0 ]
  masses2_93 = [ nMZ, nMB, 0, 0 ]
  masses2_94 = [ 0, nMB, nMB, 0 ]
  masses2_95 = [ nMZ, nMB, nMB, 0 ]
  masses2_96 = [ 0, nMB, nMB, nMB ]
  masses2_97 = [ nMH, nMB, nMB, nMB ]
  masses2_98 = [ nMZ, nMB, nMB, nMB ]
  masses2_99 = [ 0, nMB, nMB, nMZ ]
  masses2_100 = [ 0, nMB, nMZ, 0 ]
  masses2_101 = [ nMB, nMB, nMZ, 0 ]
  masses2_102 = [ nMB, nMH, 0, 0 ]
  masses2_103 = [ 0, nMH, nMZ, 0 ]
  masses2_104 = [ nMB, nMH, nMZ, 0 ]
  masses2_105 = [ nMB, nMH, nMZ, nMB ]
  masses2_106 = [ nMW, nMT, nMT, nMT ]
  masses2_107 = [ nMT, nMW, 0, nMT ]
  masses2_108 = [ 0, nMW, 0, nMW ]
  masses2_109 = [ nMT, nMW, 0, nMW ]
  masses2_110 = [ nMT, nMW, nMW, nMT ]
  masses2_111 = [ 0, nMZ, 0, 0 ]
  masses2_112 = [ nMB, nMZ, 0, 0 ]
  masses2_113 = [ nMH, nMZ, 0, 0 ]
  masses2_114 = [ nMZ, nMZ, 0, 0 ]
  masses2_115 = [ nMB, nMZ, 0, nMB ]
  masses2_116 = [ 0, nMZ, 0, nMZ ]
  masses2_117 = [ nMB, nMZ, 0, nMZ ]
  masses2_118 = [ nMB, nMZ, nMH, nMB ]
  masses2_119 = [ 0, nMZ, nMZ, 0 ]
  masses2_120 = [ nMB, nMZ, nMZ, 0 ]
  masses2_121 = [ nMB, nMZ, nMZ, nMB ]
  masses2_122 = [ nMB, 0, 0, 0, 0 ]
  masses2_123 = [ nMB, 0, 0, 0, nMZ ]
  masses2_124 = [ nMZ, 0, 0, nMZ, 0 ]
  masses2_125 = [ nMB, 0, 0, nMZ, nMH ]
  masses2_126 = [ nMB, 0, 0, nMZ, nMZ ]
  masses2_127 = [ 0, 0, nMW, 0, nMW ]
  masses2_128 = [ nMB, 0, nMZ, 0, 0 ]
  masses2_129 = [ 0, 0, nMZ, 0, nMZ ]
  masses2_130 = [ nMB, 0, nMZ, 0, nMZ ]
  masses2_131 = [ 0, nMB, nMB, 0, 0 ]
  masses2_132 = [ nMZ, nMB, nMB, 0, 0 ]
  masses2_133 = [ 0, nMB, nMB, nMZ, 0 ]
  masses2_134 = [ nMB, nMH, nMZ, 0, 0 ]
  masses2_135 = [ nMT, nMW, 0, nMW, nMT ]
  masses2_136 = [ nMB, nMZ, 0, 0, 0 ]
  masses2_137 = [ 0, nMZ, 0, nMZ, 0 ]
  masses2_138 = [ nMB, nMZ, 0, nMZ, 0 ]
  masses2_139 = [ nMB, nMZ, 0, nMZ, nMB ]
  masses2_140 = [ nMB, nMZ, nMZ, 0, 0 ]
  masses2_141 = [ nMB, 0, 0, nMZ, 0, nMZ ]
  masses2_142 = [ nMB, nMZ, 0, nMZ, 0, 0 ]


end subroutine  set_integral_masses_and_momenta

! **********************************************************************
subroutine integrate_tensor_sum(M2out)
! **********************************************************************
  use ol_parameters_decl_/**/REALKIND ! only: ZERO, masses
#ifndef PRECISION_dp
  use ol_parameters_decl_/**/DREALKIND, only: a_switch
#endif
  use ol_parameters_init_/**/REALKIND, only: init_met, add_met, met_to_real
  use ol_loop_routines_/**/REALKIND, only: TI_call_OL
  implicit none
  real(REALKIND), intent(out) :: M2out
  type(met) :: M2
  call init_met(M2)

sbarray_1 = [1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15]
sbarray_2 = [16, 17, 18, 19, 20, 21, 22, 23, 24, 25, 26, 27, 28, 29, 30]
sbarray_3 = [1, 31, 32, 33, 34, 6, 7, 8, 9, 35, 36, 37, 38, 39, 40]
sbarray_4 = [41, 42, 18, 43, 44, 45, 22, 46, 47, 25, 48, 49, 28, 29, 50]
sbarray_5 = [51, 52, 3, 53, 54, 55, 7, 56, 57, 10, 58, 59, 13, 14, 60]
sbarray_6 = [51, 61, 32, 62, 63, 55, 7, 56, 57, 35, 64, 65, 38, 39, 66]
sbarray_7 = [16, 67, 68, 69, 70, 21, 22, 23, 24, 71, 72, 73, 74, 75, 76]
sbarray_8 = [41, 77, 68, 78, 79, 45, 22, 46, 47, 71, 80, 81, 74, 75, 82]
sbarray_9 = [83, 84, 85, 86, 15]
sbarray_10 = [87, 88, 89, 90, 30]
sbarray_11 = [91, 84, 92, 93, 40]
sbarray_12 = [94, 95, 96, 90, 50]
sbarray_13 = [97, 98, 99, 86, 60]
sbarray_14 = [100, 98, 101, 93, 66]
sbarray_15 = [102, 88, 103, 104, 76]
sbarray_16 = [105, 95, 106, 104, 82]
sbarray_17 = [1, 2, 3, 4, 5]
sbarray_18 = [1, 6, 7, 8, 9]
sbarray_19 = [2, 6, 10, 11, 12]
sbarray_20 = [3, 7, 10, 13, 14]
sbarray_21 = [16, 17, 18, 19, 20]
sbarray_22 = [16, 21, 22, 23, 24]
sbarray_23 = [17, 21, 25, 26, 27]
sbarray_24 = [18, 22, 25, 28, 29]
sbarray_25 = [1, 31, 32, 33, 34]
sbarray_26 = [31, 6, 35, 36, 37]
sbarray_27 = [32, 7, 35, 38, 39]
sbarray_28 = [41, 42, 18, 43, 44]
sbarray_29 = [41, 45, 22, 46, 47]
sbarray_30 = [42, 45, 25, 48, 49]
sbarray_31 = [51, 52, 3, 53, 54]
sbarray_32 = [51, 55, 7, 56, 57]
sbarray_33 = [52, 55, 10, 58, 59]
sbarray_34 = [51, 61, 32, 62, 63]
sbarray_35 = [61, 55, 35, 64, 65]
sbarray_36 = [16, 67, 68, 69, 70]
sbarray_37 = [67, 21, 71, 72, 73]
sbarray_38 = [68, 22, 71, 74, 75]
sbarray_39 = [41, 77, 68, 78, 79]
sbarray_40 = [77, 45, 71, 80, 81]
sbarray_41 = [41, 107, 108, 109, 110]
sbarray_42 = [111, 112, 113, 38, 114]
sbarray_43 = [16, 115, 108, 116, 117]
sbarray_44 = [118, 112, 119, 13, 120]
sbarray_45 = [121, 122, 123, 124, 125]
sbarray_46 = [126, 127, 123, 128, 129]
sbarray_47 = [130, 131, 132, 133, 125]
sbarray_48 = [134, 135, 136, 124, 137]
sbarray_49 = [138, 139, 140, 133, 137]
sbarray_50 = [141, 142, 136, 128, 143]
sbarray_51 = [144, 145, 146, 147, 148]
sbarray_52 = [149, 150, 10, 147, 151]
sbarray_53 = [144, 45, 152, 153, 154]
sbarray_54 = [155, 156, 157, 158, 159]
sbarray_55 = [155, 21, 160, 161, 162]
sbarray_56 = [163, 164, 35, 158, 165]
sbarray_57 = [166, 167, 168, 28, 169]
sbarray_58 = [170, 171, 172, 173, 174]
sbarray_59 = [175, 167, 176, 74, 177]
sbarray_60 = [178, 179, 180, 181, 5]
sbarray_61 = [182, 183, 184, 185, 186]
sbarray_62 = [187, 188, 180, 189, 54]


#ifdef LOOPSQUARED
  if (a_switch == 1 .or. a_switch == 7) then
#endif
  call TI_call_OL(0,0, momenta_139, masses2_94, T0sum(1), M2,[124], ScalarBoxes(:))
  call TI_call_OL(0,0, momenta_139, masses2_99, T0sum(2), M2,[128], ScalarBoxes(:))
  call TI_call_OL(0,0, momenta_139, masses2_95, T0sum(3), M2,[133], ScalarBoxes(:))
  call TI_call_OL(0,0, momenta_209, masses2_68, T0sum(4), M2,[148], ScalarBoxes(:))
  call TI_call_OL(0,0, momenta_148, masses2_69, T0sum(5), M2,[147], ScalarBoxes(:))
  call TI_call_OL(0,0, momenta_209, masses2_70, T0sum(6), M2,[151], ScalarBoxes(:))
  call TI_call_OL(0,0, momenta_209, masses2_111, T0sum(7), M2,[154], ScalarBoxes(:))
  call TI_call_OL(0,0, momenta_148, masses2_112, T0sum(8), M2,[153], ScalarBoxes(:))
  call TI_call_OL(0,0, momenta_203, masses2_68, T0sum(9), M2,[159], ScalarBoxes(:))
  call TI_call_OL(0,0, momenta_142, masses2_69, T0sum(10), M2,[158], ScalarBoxes(:))
  call TI_call_OL(0,0, momenta_203, masses2_111, T0sum(11), M2,[162], ScalarBoxes(:))
  call TI_call_OL(0,0, momenta_142, masses2_112, T0sum(12), M2,[161], ScalarBoxes(:))
  call TI_call_OL(0,0, momenta_203, masses2_70, T0sum(13), M2,[165], ScalarBoxes(:))
  call TI_call_OL(0,0, momenta_192, masses2_117, T0sum(14), M2,[51], ScalarBoxes(:))
  call TI_call_OL(0,0, momenta_131, masses2_117, T0sum(15), M2,[28], ScalarBoxes(:))
  call TI_call_OL(0,0, momenta_192, masses2_109, T0sum(16), M2,[174], ScalarBoxes(:))
  call TI_call_OL(0,0, momenta_131, masses2_109, T0sum(17), M2,[173], ScalarBoxes(:))
  call TI_call_OL(0,0, momenta_191, masses2_117, T0sum(18), M2,[1], ScalarBoxes(:))
  call TI_call_OL(0,0, momenta_126, masses2_117, T0sum(19), M2,[74], ScalarBoxes(:))
  call TI_call_OL(0,0, momenta_229, masses2_84, T0sum(20), M2,[83], ScalarBoxes(:))
  call TI_call_OL(0,0, momenta_201, masses2_82, T0sum(21), M2,[181], ScalarBoxes(:))
  call TI_call_OL(0,0, momenta_229, masses2_78, T0sum(22), M2,[186], ScalarBoxes(:))
  call TI_call_OL(0,0, momenta_201, masses2_77, T0sum(23), M2,[185], ScalarBoxes(:))
  call TI_call_OL(0,0, momenta_230, masses2_84, T0sum(24), M2,[97], ScalarBoxes(:))
  call TI_call_OL(0,0, momenta_202, masses2_82, T0sum(25), M2,[189], ScalarBoxes(:))
  call TI_call_OL(0,0, momenta_222, masses2_73, T0sum(26), M2,[15], ScalarBoxes(:))
  call TI_call_OL(0,0, momenta_213, masses2_84, T0sum(27), M2,[84], ScalarBoxes(:))
  call TI_call_OL(0,0, momenta_211, masses2_70, T0sum(28), M2,[85], ScalarBoxes(:))
  call TI_call_OL(0,0, momenta_210, masses2_76, T0sum(29), M2,[86], ScalarBoxes(:))
  call TI_call_OL(0,0, momenta_228, masses2_116, T0sum(30), M2,[30], ScalarBoxes(:))
  call TI_call_OL(0,0, momenta_219, masses2_82, T0sum(31), M2,[87], ScalarBoxes(:))
  call TI_call_OL(0,0, momenta_199, masses2_119, T0sum(32), M2,[88], ScalarBoxes(:))
  call TI_call_OL(0,0, momenta_197, masses2_111, T0sum(33), M2,[89], ScalarBoxes(:))
  call TI_call_OL(0,0, momenta_196, masses2_116, T0sum(34), M2,[90], ScalarBoxes(:))
  call TI_call_OL(0,0, momenta_221, masses2_73, T0sum(35), M2,[40], ScalarBoxes(:))
  call TI_call_OL(0,0, momenta_225, masses2_84, T0sum(36), M2,[91], ScalarBoxes(:))
  call TI_call_OL(0,0, momenta_205, masses2_70, T0sum(37), M2,[92], ScalarBoxes(:))
  call TI_call_OL(0,0, momenta_204, masses2_76, T0sum(38), M2,[93], ScalarBoxes(:))
  call TI_call_OL(0,0, momenta_224, masses2_116, T0sum(39), M2,[187], ScalarBoxes(:))
  call TI_call_OL(0,0, momenta_220, masses2_82, T0sum(40), M2,[94], ScalarBoxes(:))
  call TI_call_OL(0,0, momenta_200, masses2_119, T0sum(41), M2,[95], ScalarBoxes(:))
  call TI_call_OL(0,0, momenta_198, masses2_111, T0sum(42), M2,[96], ScalarBoxes(:))
  call TI_call_OL(0,0, momenta_218, masses2_73, T0sum(43), M2,[60], ScalarBoxes(:))
  call TI_call_OL(0,0, momenta_214, masses2_84, T0sum(44), M2,[98], ScalarBoxes(:))
  call TI_call_OL(0,0, momenta_212, masses2_70, T0sum(45), M2,[99], ScalarBoxes(:))
  call TI_call_OL(0,0, momenta_217, masses2_73, T0sum(46), M2,[66], ScalarBoxes(:))
  call TI_call_OL(0,0, momenta_226, masses2_84, T0sum(47), M2,[100], ScalarBoxes(:))
  call TI_call_OL(0,0, momenta_206, masses2_70, T0sum(48), M2,[101], ScalarBoxes(:))
  call TI_call_OL(0,0, momenta_227, masses2_116, T0sum(49), M2,[76], ScalarBoxes(:))
  call TI_call_OL(0,0, momenta_215, masses2_82, T0sum(50), M2,[102], ScalarBoxes(:))
  call TI_call_OL(0,0, momenta_194, masses2_111, T0sum(51), M2,[103], ScalarBoxes(:))
  call TI_call_OL(0,0, momenta_193, masses2_116, T0sum(52), M2,[104], ScalarBoxes(:))
  call TI_call_OL(0,0, momenta_223, masses2_116, T0sum(53), M2,[178], ScalarBoxes(:))
  call TI_call_OL(0,0, momenta_216, masses2_82, T0sum(54), M2,[105], ScalarBoxes(:))
  call TI_call_OL(0,0, momenta_195, masses2_111, T0sum(55), M2,[106], ScalarBoxes(:))
  call TI_call_OL(0,0, momenta_189, masses2_74, T0sum(56), M2,[2], ScalarBoxes(:))
  call TI_call_OL(0,0, momenta_188, masses2_90, T0sum(57), M2,[3], ScalarBoxes(:))
  call TI_call_OL(0,0, momenta_186, masses2_83, T0sum(58), M2,[4], ScalarBoxes(:))
  call TI_call_OL(0,0, momenta_157, masses2_74, T0sum(59), M2,[6], ScalarBoxes(:))
  call TI_call_OL(0,0, momenta_156, masses2_90, T0sum(60), M2,[7], ScalarBoxes(:))
  call TI_call_OL(0,0, momenta_154, masses2_83, T0sum(61), M2,[8], ScalarBoxes(:))
  call TI_call_OL(0,0, momenta_152, masses2_74, T0sum(62), M2,[10], ScalarBoxes(:))
  call TI_call_OL(0,0, momenta_150, masses2_69, T0sum(63), M2,[11], ScalarBoxes(:))
  call TI_call_OL(0,0, momenta_149, masses2_74, T0sum(64), M2,[13], ScalarBoxes(:))
  call TI_call_OL(0,0, momenta_173, masses2_112, T0sum(65), M2,[16], ScalarBoxes(:))
  call TI_call_OL(0,0, momenta_171, masses2_69, T0sum(66), M2,[17], ScalarBoxes(:))
  call TI_call_OL(0,0, momenta_169, masses2_83, T0sum(67), M2,[18], ScalarBoxes(:))
  call TI_call_OL(0,0, momenta_167, masses2_83, T0sum(68), M2,[19], ScalarBoxes(:))
  call TI_call_OL(0,0, momenta_147, masses2_112, T0sum(69), M2,[21], ScalarBoxes(:))
  call TI_call_OL(0,0, momenta_138, masses2_120, T0sum(70), M2,[22], ScalarBoxes(:))
  call TI_call_OL(0,0, momenta_136, masses2_120, T0sum(71), M2,[23], ScalarBoxes(:))
  call TI_call_OL(0,0, momenta_134, masses2_112, T0sum(72), M2,[25], ScalarBoxes(:))
  call TI_call_OL(0,0, momenta_132, masses2_112, T0sum(73), M2,[26], ScalarBoxes(:))
  call TI_call_OL(0,0, momenta_182, masses2_74, T0sum(74), M2,[31], ScalarBoxes(:))
  call TI_call_OL(0,0, momenta_181, masses2_90, T0sum(75), M2,[32], ScalarBoxes(:))
  call TI_call_OL(0,0, momenta_179, masses2_83, T0sum(76), M2,[33], ScalarBoxes(:))
  call TI_call_OL(0,0, momenta_146, masses2_74, T0sum(77), M2,[35], ScalarBoxes(:))
  call TI_call_OL(0,0, momenta_144, masses2_69, T0sum(78), M2,[36], ScalarBoxes(:))
  call TI_call_OL(0,0, momenta_143, masses2_74, T0sum(79), M2,[38], ScalarBoxes(:))
  call TI_call_OL(0,0, momenta_174, masses2_112, T0sum(80), M2,[41], ScalarBoxes(:))
  call TI_call_OL(0,0, momenta_172, masses2_69, T0sum(81), M2,[42], ScalarBoxes(:))
  call TI_call_OL(0,0, momenta_168, masses2_83, T0sum(82), M2,[43], ScalarBoxes(:))
  call TI_call_OL(0,0, momenta_153, masses2_112, T0sum(83), M2,[45], ScalarBoxes(:))
  call TI_call_OL(0,0, momenta_137, masses2_120, T0sum(84), M2,[46], ScalarBoxes(:))
  call TI_call_OL(0,0, momenta_133, masses2_112, T0sum(85), M2,[48], ScalarBoxes(:))
  call TI_call_OL(0,0, momenta_190, masses2_74, T0sum(86), M2,[52], ScalarBoxes(:))
  call TI_call_OL(0,0, momenta_187, masses2_83, T0sum(87), M2,[53], ScalarBoxes(:))
  call TI_call_OL(0,0, momenta_158, masses2_74, T0sum(88), M2,[55], ScalarBoxes(:))
  call TI_call_OL(0,0, momenta_155, masses2_83, T0sum(89), M2,[56], ScalarBoxes(:))
  call TI_call_OL(0,0, momenta_151, masses2_69, T0sum(90), M2,[58], ScalarBoxes(:))
  call TI_call_OL(0,0, momenta_183, masses2_74, T0sum(91), M2,[61], ScalarBoxes(:))
  call TI_call_OL(0,0, momenta_180, masses2_83, T0sum(92), M2,[62], ScalarBoxes(:))
  call TI_call_OL(0,0, momenta_145, masses2_69, T0sum(93), M2,[64], ScalarBoxes(:))
  call TI_call_OL(0,0, momenta_165, masses2_69, T0sum(94), M2,[67], ScalarBoxes(:))
  call TI_call_OL(0,0, momenta_163, masses2_83, T0sum(95), M2,[68], ScalarBoxes(:))
  call TI_call_OL(0,0, momenta_161, masses2_83, T0sum(96), M2,[69], ScalarBoxes(:))
  call TI_call_OL(0,0, momenta_129, masses2_112, T0sum(97), M2,[71], ScalarBoxes(:))
  call TI_call_OL(0,0, momenta_127, masses2_112, T0sum(98), M2,[72], ScalarBoxes(:))
  call TI_call_OL(0,0, momenta_166, masses2_69, T0sum(99), M2,[77], ScalarBoxes(:))
  call TI_call_OL(0,0, momenta_162, masses2_83, T0sum(100), M2,[78], ScalarBoxes(:))
  call TI_call_OL(0,0, momenta_128, masses2_112, T0sum(101), M2,[80], ScalarBoxes(:))
  call TI_call_OL(0,0, momenta_200, masses2_103, T0sum(102), M2,[110], ScalarBoxes(:))
  call TI_call_OL(0,0, momenta_153, masses2_102, T0sum(103), M2,[107], ScalarBoxes(:))
  call TI_call_OL(0,0, momenta_138, masses2_104, T0sum(104), M2,[108], ScalarBoxes(:))
  call TI_call_OL(0,0, momenta_137, masses2_104, T0sum(105), M2,[109], ScalarBoxes(:))
  call TI_call_OL(0,0, momenta_204, masses2_75, T0sum(106), M2,[114], ScalarBoxes(:))
  call TI_call_OL(0,0, momenta_181, masses2_88, T0sum(107), M2,[111], ScalarBoxes(:))
  call TI_call_OL(0,0, momenta_156, masses2_88, T0sum(108), M2,[112], ScalarBoxes(:))
  call TI_call_OL(0,0, momenta_146, masses2_71, T0sum(109), M2,[113], ScalarBoxes(:))
  call TI_call_OL(0,0, momenta_199, masses2_103, T0sum(110), M2,[117], ScalarBoxes(:))
  call TI_call_OL(0,0, momenta_147, masses2_102, T0sum(111), M2,[115], ScalarBoxes(:))
  call TI_call_OL(0,0, momenta_136, masses2_104, T0sum(112), M2,[116], ScalarBoxes(:))
  call TI_call_OL(0,0, momenta_210, masses2_75, T0sum(113), M2,[120], ScalarBoxes(:))
  call TI_call_OL(0,0, momenta_188, masses2_88, T0sum(114), M2,[118], ScalarBoxes(:))
  call TI_call_OL(0,0, momenta_152, masses2_71, T0sum(115), M2,[119], ScalarBoxes(:))
  call TI_call_OL(0,0, momenta_185, masses2_94, T0sum(116), M2,[125], ScalarBoxes(:))
  call TI_call_OL(0,0, momenta_175, masses2_91, T0sum(117), M2,[121], ScalarBoxes(:))
  call TI_call_OL(0,0, momenta_159, masses2_91, T0sum(118), M2,[122], ScalarBoxes(:))
  call TI_call_OL(0,0, momenta_140, masses2_94, T0sum(119), M2,[123], ScalarBoxes(:))
  call TI_call_OL(0,0, momenta_185, masses2_99, T0sum(120), M2,[129], ScalarBoxes(:))
  call TI_call_OL(0,0, momenta_175, masses2_100, T0sum(121), M2,[126], ScalarBoxes(:))
  call TI_call_OL(0,0, momenta_159, masses2_100, T0sum(122), M2,[127], ScalarBoxes(:))
  call TI_call_OL(0,0, momenta_175, masses2_93, T0sum(123), M2,[130], ScalarBoxes(:))
  call TI_call_OL(0,0, momenta_159, masses2_93, T0sum(124), M2,[131], ScalarBoxes(:))
  call TI_call_OL(0,0, momenta_140, masses2_95, T0sum(125), M2,[132], ScalarBoxes(:))
  call TI_call_OL(0,0, momenta_178, masses2_94, T0sum(126), M2,[137], ScalarBoxes(:))
  call TI_call_OL(0,0, momenta_176, masses2_91, T0sum(127), M2,[134], ScalarBoxes(:))
  call TI_call_OL(0,0, momenta_160, masses2_91, T0sum(128), M2,[135], ScalarBoxes(:))
  call TI_call_OL(0,0, momenta_141, masses2_94, T0sum(129), M2,[136], ScalarBoxes(:))
  call TI_call_OL(0,0, momenta_176, masses2_93, T0sum(130), M2,[138], ScalarBoxes(:))
  call TI_call_OL(0,0, momenta_160, masses2_93, T0sum(131), M2,[139], ScalarBoxes(:))
  call TI_call_OL(0,0, momenta_141, masses2_95, T0sum(132), M2,[140], ScalarBoxes(:))
  call TI_call_OL(0,0, momenta_178, masses2_99, T0sum(133), M2,[143], ScalarBoxes(:))
  call TI_call_OL(0,0, momenta_176, masses2_100, T0sum(134), M2,[141], ScalarBoxes(:))
  call TI_call_OL(0,0, momenta_160, masses2_100, T0sum(135), M2,[142], ScalarBoxes(:))
  call TI_call_OL(0,0, momenta_184, masses2_69, T0sum(136), M2,[144], ScalarBoxes(:))
  call TI_call_OL(0,0, momenta_153, masses2_69, T0sum(137), M2,[145], ScalarBoxes(:))
  call TI_call_OL(0,0, momenta_152, masses2_69, T0sum(138), M2,[146], ScalarBoxes(:))
  call TI_call_OL(0,0, momenta_184, masses2_74, T0sum(139), M2,[149], ScalarBoxes(:))
  call TI_call_OL(0,0, momenta_153, masses2_74, T0sum(140), M2,[150], ScalarBoxes(:))
  call TI_call_OL(0,0, momenta_152, masses2_112, T0sum(141), M2,[152], ScalarBoxes(:))
  call TI_call_OL(0,0, momenta_177, masses2_69, T0sum(142), M2,[155], ScalarBoxes(:))
  call TI_call_OL(0,0, momenta_147, masses2_69, T0sum(143), M2,[156], ScalarBoxes(:))
  call TI_call_OL(0,0, momenta_146, masses2_69, T0sum(144), M2,[157], ScalarBoxes(:))
  call TI_call_OL(0,0, momenta_146, masses2_112, T0sum(145), M2,[160], ScalarBoxes(:))
  call TI_call_OL(0,0, momenta_177, masses2_74, T0sum(146), M2,[163], ScalarBoxes(:))
  call TI_call_OL(0,0, momenta_147, masses2_74, T0sum(147), M2,[164], ScalarBoxes(:))
  call TI_call_OL(0,0, momenta_170, masses2_85, T0sum(148), M2,[166], ScalarBoxes(:))
  call TI_call_OL(0,0, momenta_139, masses2_121, T0sum(149), M2,[167], ScalarBoxes(:))
  call TI_call_OL(0,0, momenta_135, masses2_115, T0sum(150), M2,[168], ScalarBoxes(:))
  call TI_call_OL(0,0, momenta_170, masses2_79, T0sum(151), M2,[170], ScalarBoxes(:))
  call TI_call_OL(0,0, momenta_139, masses2_110, T0sum(152), M2,[171], ScalarBoxes(:))
  call TI_call_OL(0,0, momenta_135, masses2_107, T0sum(153), M2,[172], ScalarBoxes(:))
  call TI_call_OL(0,0, momenta_164, masses2_85, T0sum(154), M2,[175], ScalarBoxes(:))
  call TI_call_OL(0,0, momenta_130, masses2_115, T0sum(155), M2,[176], ScalarBoxes(:))
  call TI_call_OL(0,0, momenta_207, masses2_73, T0sum(156), M2,[179], ScalarBoxes(:))
  call TI_call_OL(0,0, momenta_203, masses2_89, T0sum(157), M2,[180], ScalarBoxes(:))
  call TI_call_OL(0,0, momenta_223, masses2_108, T0sum(158), M2,[182], ScalarBoxes(:))
  call TI_call_OL(0,0, momenta_207, masses2_72, T0sum(159), M2,[183], ScalarBoxes(:))
  call TI_call_OL(0,0, momenta_203, masses2_81, T0sum(160), M2,[184], ScalarBoxes(:))
  call TI_call_OL(0,0, momenta_208, masses2_73, T0sum(161), M2,[188], ScalarBoxes(:))
  call TI_call_OL(0,0, momenta_143, masses2_69, T0sum(162), M2,[135], ScalarBoxes(:))
  call TI_call_OL(0,0, momenta_143, masses2_112, T0sum(163), M2,[139], ScalarBoxes(:))
  call TI_call_OL(0,0, momenta_149, masses2_69, T0sum(164), M2,[122], ScalarBoxes(:))
  call TI_call_OL(0,0, momenta_149, masses2_112, T0sum(165), M2,[131], ScalarBoxes(:))
  call TI_call_OL(0,0, momenta_174, masses2_69, T0sum(166), M2,[121], ScalarBoxes(:))
  call TI_call_OL(0,0, momenta_174, masses2_74, T0sum(167), M2,[126], ScalarBoxes(:))
  call TI_call_OL(0,0, momenta_173, masses2_69, T0sum(168), M2,[134], ScalarBoxes(:))
  call TI_call_OL(0,0, momenta_173, masses2_74, T0sum(169), M2,[141], ScalarBoxes(:))
  call TI_call_OL(0,0, momenta_228, masses2_108, T0sum(170), M2,[186], ScalarBoxes(:))
  call TI_call_OL(0,0, momenta_156, masses2_97, T0sum(171), M2)
  call TI_call_OL(0,0, momenta_156, masses2_98, T0sum(172), M2)
  call TI_call_OL(0,0, momenta_156, masses2_106, T0sum(173), M2)
  call TI_call_OL(0,0, momenta_156, masses2_96, T0sum(174), M2)
  call TI_call_OL(0,0, momenta_138, masses2_97, T0sum(175), M2)
  call TI_call_OL(0,0, momenta_138, masses2_98, T0sum(176), M2)
  call TI_call_OL(0,0, momenta_138, masses2_106, T0sum(177), M2)
  call TI_call_OL(0,0, momenta_138, masses2_96, T0sum(178), M2)
  call TI_call_OL(0,0, momenta_139, masses2_118, T0sum(179), M2)
  call TI_call_OL(0,0, momenta_139, masses2_105, T0sum(180), M2)
  call TI_call_OL(0,0, momenta_199, masses2_68, T0sum(181), M2)
  call TI_call_OL(0,0, momenta_199, masses2_73, T0sum(182), M2)
  call TI_call_OL(0,0, momenta_199, masses2_72, T0sum(183), M2)
  call TI_call_OL(0,0, momenta_200, masses2_68, T0sum(184), M2)
  call TI_call_OL(0,0, momenta_200, masses2_73, T0sum(185), M2)
  call TI_call_OL(0,0, momenta_200, masses2_72, T0sum(186), M2)
  call TI_call_OL(0,0, momenta_34, masses2_45, T0sum(187), M2)
  call TI_call_OL(0,0, momenta_34, masses2_46, T0sum(188), M2)
  call TI_call_OL(0,0, momenta_34, masses2_54, T0sum(189), M2)
  call TI_call_OL(0,0, momenta_34, masses2_43, T0sum(190), M2)
  call TI_call_OL(0,0, momenta_29, masses2_45, T0sum(191), M2)
  call TI_call_OL(0,0, momenta_29, masses2_46, T0sum(192), M2)
  call TI_call_OL(0,0, momenta_29, masses2_54, T0sum(193), M2)
  call TI_call_OL(0,0, momenta_29, masses2_43, T0sum(194), M2)
  call TI_call_OL(0,0, momenta_81, masses2_26, T0sum(195), M2)
  call TI_call_OL(0,0, momenta_75, masses2_60, T0sum(196), M2)
  call TI_call_OL(0,0, momenta_29, masses2_60, T0sum(197), M2)
  call TI_call_OL(0,0, momenta_117, masses2_36, T0sum(198), M2)
  call TI_call_OL(0,0, momenta_81, masses2_34, T0sum(199), M2)
  call TI_call_OL(0,0, momenta_75, masses2_65, T0sum(200), M2)
  call TI_call_OL(0,0, momenta_29, masses2_65, T0sum(201), M2)
  call TI_call_OL(0,0, momenta_75, masses2_52, T0sum(202), M2)
  call TI_call_OL(0,0, momenta_29, masses2_52, T0sum(203), M2)
  call TI_call_OL(0,0, momenta_75, masses2_43, T0sum(204), M2)
  call TI_call_OL(0,0, momenta_116, masses2_26, T0sum(205), M2)
  call TI_call_OL(0,0, momenta_80, masses2_26, T0sum(206), M2)
  call TI_call_OL(0,0, momenta_116, masses2_30, T0sum(207), M2)
  call TI_call_OL(0,0, momenta_116, masses2_29, T0sum(208), M2)
  call TI_call_OL(0,0, momenta_106, masses2_26, T0sum(209), M2)
  call TI_call_OL(0,0, momenta_106, masses2_30, T0sum(210), M2)
  call TI_call_OL(0,0, momenta_106, masses2_29, T0sum(211), M2)
  call TI_call_OL(0,0, momenta_54, masses2_41, T0sum(212), M2)
  call TI_call_OL(0,0, momenta_38, masses2_41, T0sum(213), M2)
  call TI_call_OL(0,0, momenta_75, masses2_46, T0sum(214), M2)
  call TI_call_OL(0,0, momenta_54, masses2_47, T0sum(215), M2)
  call TI_call_OL(0,0, momenta_38, masses2_47, T0sum(216), M2)
  call TI_call_OL(0,0, momenta_54, masses2_42, T0sum(217), M2)
  call TI_call_OL(0,0, momenta_38, masses2_42, T0sum(218), M2)
  call TI_call_OL(0,0, momenta_107, masses2_26, T0sum(219), M2)
  call TI_call_OL(0,0, momenta_86, masses2_26, T0sum(220), M2)
  call TI_call_OL(0,0, momenta_85, masses2_26, T0sum(221), M2)
  call TI_call_OL(0,0, momenta_65, masses2_27, T0sum(222), M2)
  call TI_call_OL(0,0, momenta_33, masses2_27, T0sum(223), M2)
  call TI_call_OL(0,0, momenta_32, masses2_27, T0sum(224), M2)
  call TI_call_OL(0,0, momenta_86, masses2_30, T0sum(225), M2)
  call TI_call_OL(0,0, momenta_85, masses2_30, T0sum(226), M2)
  call TI_call_OL(0,0, momenta_107, masses2_61, T0sum(227), M2)
  call TI_call_OL(0,0, momenta_86, masses2_61, T0sum(228), M2)
  call TI_call_OL(0,0, momenta_85, masses2_61, T0sum(229), M2)
  call TI_call_OL(0,0, momenta_33, masses2_62, T0sum(230), M2)
  call TI_call_OL(0,0, momenta_32, masses2_62, T0sum(231), M2)
  call TI_call_OL(0,0, momenta_117, masses2_26, T0sum(232), M2)
  call TI_call_OL(0,0, momenta_84, masses2_26, T0sum(233), M2)
  call TI_call_OL(0,0, momenta_57, masses2_27, T0sum(234), M2)
  call TI_call_OL(0,0, momenta_31, masses2_27, T0sum(235), M2)
  call TI_call_OL(0,0, momenta_30, masses2_27, T0sum(236), M2)
  call TI_call_OL(0,0, momenta_117, masses2_61, T0sum(237), M2)
  call TI_call_OL(0,0, momenta_84, masses2_61, T0sum(238), M2)
  call TI_call_OL(0,0, momenta_81, masses2_61, T0sum(239), M2)
  call TI_call_OL(0,0, momenta_31, masses2_62, T0sum(240), M2)
  call TI_call_OL(0,0, momenta_30, masses2_62, T0sum(241), M2)
  call TI_call_OL(0,0, momenta_84, masses2_30, T0sum(242), M2)
  call TI_call_OL(0,0, momenta_81, masses2_30, T0sum(243), M2)
  call TI_call_OL(0,0, momenta_125, masses2_63, T0sum(244), M2)
  call TI_call_OL(0,0, momenta_77, masses2_38, T0sum(245), M2)
  call TI_call_OL(0,0, momenta_75, masses2_67, T0sum(246), M2)
  call TI_call_OL(0,0, momenta_74, masses2_62, T0sum(247), M2)
  call TI_call_OL(0,0, momenta_46, masses2_38, T0sum(248), M2)
  call TI_call_OL(0,0, momenta_29, masses2_67, T0sum(249), M2)
  call TI_call_OL(0,0, momenta_28, masses2_62, T0sum(250), M2)
  call TI_call_OL(0,0, momenta_125, masses2_57, T0sum(251), M2)
  call TI_call_OL(0,0, momenta_77, masses2_35, T0sum(252), M2)
  call TI_call_OL(0,0, momenta_74, masses2_56, T0sum(253), M2)
  call TI_call_OL(0,0, momenta_46, masses2_35, T0sum(254), M2)
  call TI_call_OL(0,0, momenta_28, masses2_56, T0sum(255), M2)
  call TI_call_OL(0,0, momenta_124, masses2_63, T0sum(256), M2)
  call TI_call_OL(0,0, momenta_76, masses2_38, T0sum(257), M2)
  call TI_call_OL(0,0, momenta_73, masses2_62, T0sum(258), M2)
  call TI_call_OL(0,0, momenta_41, masses2_38, T0sum(259), M2)
  call TI_call_OL(0,0, momenta_27, masses2_62, T0sum(260), M2)
  call TI_call_OL(0,0, momenta_123, masses2_37, T0sum(261), M2)
  call TI_call_OL(0,0, momenta_118, masses2_30, T0sum(262), M2)
  call TI_call_OL(0,0, momenta_117, masses2_40, T0sum(263), M2)
  call TI_call_OL(0,0, momenta_104, masses2_61, T0sum(264), M2)
  call TI_call_OL(0,0, momenta_82, masses2_26, T0sum(265), M2)
  call TI_call_OL(0,0, momenta_81, masses2_37, T0sum(266), M2)
  call TI_call_OL(0,0, momenta_123, masses2_34, T0sum(267), M2)
  call TI_call_OL(0,0, momenta_124, masses2_57, T0sum(268), M2)
  call TI_call_OL(0,0, momenta_118, masses2_29, T0sum(269), M2)
  call TI_call_OL(0,0, momenta_104, masses2_55, T0sum(270), M2)
  call TI_call_OL(0,0, momenta_121, masses2_37, T0sum(271), M2)
  call TI_call_OL(0,0, momenta_119, masses2_30, T0sum(272), M2)
  call TI_call_OL(0,0, momenta_105, masses2_61, T0sum(273), M2)
  call TI_call_OL(0,0, momenta_83, masses2_26, T0sum(274), M2)
  call TI_call_OL(0,0, momenta_122, masses2_37, T0sum(275), M2)
  call TI_call_OL(0,0, momenta_116, masses2_66, T0sum(276), M2)
  call TI_call_OL(0,0, momenta_115, masses2_61, T0sum(277), M2)
  call TI_call_OL(0,0, momenta_112, masses2_37, T0sum(278), M2)
  call TI_call_OL(0,0, momenta_106, masses2_66, T0sum(279), M2)
  call TI_call_OL(0,0, momenta_120, masses2_37, T0sum(280), M2)
  call TI_call_OL(0,0, momenta_114, masses2_61, T0sum(281), M2)
  call TI_call_OL(0,0, momenta_110, masses2_37, T0sum(282), M2)
  call TI_call_OL(0,0, momenta_69, masses2_38, T0sum(283), M2)
  call TI_call_OL(0,0, momenta_37, masses2_38, T0sum(284), M2)
  call TI_call_OL(0,0, momenta_103, masses2_30, T0sum(285), M2)
  call TI_call_OL(0,0, momenta_66, masses2_38, T0sum(286), M2)
  call TI_call_OL(0,0, momenta_34, masses2_38, T0sum(287), M2)
  call TI_call_OL(0,0, momenta_102, masses2_61, T0sum(288), M2)
  call TI_call_OL(0,0, momenta_63, masses2_27, T0sum(289), M2)
  call TI_call_OL(0,0, momenta_53, masses2_62, T0sum(290), M2)
  call TI_call_OL(0,0, momenta_51, masses2_62, T0sum(291), M2)
  call TI_call_OL(0,0, momenta_37, masses2_62, T0sum(292), M2)
  call TI_call_OL(0,0, momenta_61, masses2_38, T0sum(293), M2)
  call TI_call_OL(0,0, momenta_102, masses2_30, T0sum(294), M2)
  call TI_call_OL(0,0, momenta_58, masses2_38, T0sum(295), M2)
  call TI_call_OL(0,0, momenta_103, masses2_61, T0sum(296), M2)
  call TI_call_OL(0,0, momenta_71, masses2_27, T0sum(297), M2)
  call TI_call_OL(0,0, momenta_52, masses2_62, T0sum(298), M2)
  call TI_call_OL(0,0, momenta_72, masses2_41, T0sum(299), M2)
  call TI_call_OL(0,0, momenta_70, masses2_41, T0sum(300), M2)
  call TI_call_OL(0,0, momenta_65, masses2_43, T0sum(301), M2)
  call TI_call_OL(0,0, momenta_102, masses2_26, T0sum(302), M2)
  call TI_call_OL(0,0, momenta_55, masses2_41, T0sum(303), M2)
  call TI_call_OL(0,0, momenta_39, masses2_41, T0sum(304), M2)
  call TI_call_OL(0,0, momenta_72, masses2_47, T0sum(305), M2)
  call TI_call_OL(0,0, momenta_70, masses2_47, T0sum(306), M2)
  call TI_call_OL(0,0, momenta_55, masses2_42, T0sum(307), M2)
  call TI_call_OL(0,0, momenta_39, masses2_42, T0sum(308), M2)
  call TI_call_OL(0,0, momenta_64, masses2_41, T0sum(309), M2)
  call TI_call_OL(0,0, momenta_62, masses2_41, T0sum(310), M2)
  call TI_call_OL(0,0, momenta_57, masses2_43, T0sum(311), M2)
  call TI_call_OL(0,0, momenta_103, masses2_26, T0sum(312), M2)
  call TI_call_OL(0,0, momenta_56, masses2_41, T0sum(313), M2)
  call TI_call_OL(0,0, momenta_40, masses2_41, T0sum(314), M2)
  call TI_call_OL(0,0, momenta_56, masses2_42, T0sum(315), M2)
  call TI_call_OL(0,0, momenta_40, masses2_42, T0sum(316), M2)
  call TI_call_OL(0,0, momenta_64, masses2_47, T0sum(317), M2)
  call TI_call_OL(0,0, momenta_62, masses2_47, T0sum(318), M2)
  call TI_call_OL(0,0, momenta_69, masses2_27, T0sum(319), M2)
  call TI_call_OL(0,0, momenta_37, masses2_27, T0sum(320), M2)
  call TI_call_OL(0,0, momenta_71, masses2_38, T0sum(321), M2)
  call TI_call_OL(0,0, momenta_61, masses2_27, T0sum(322), M2)
  call TI_call_OL(0,0, momenta_63, masses2_38, T0sum(323), M2)
  call TI_call_OL(0,0, momenta_54, masses2_64, T0sum(324), M2)
  call TI_call_OL(0,0, momenta_50, masses2_31, T0sum(325), M2)
  call TI_call_OL(0,0, momenta_38, masses2_64, T0sum(326), M2)
  call TI_call_OL(0,0, momenta_54, masses2_58, T0sum(327), M2)
  call TI_call_OL(0,0, momenta_50, masses2_33, T0sum(328), M2)
  call TI_call_OL(0,0, momenta_38, masses2_58, T0sum(329), M2)
  call TI_call_OL(0,0, momenta_45, masses2_31, T0sum(330), M2)
  call TI_call_OL(0,0, momenta_84, masses2_37, T0sum(331), M2)
  call TI_call_OL(0,0, momenta_110, masses2_34, T0sum(332), M2)
  call TI_call_OL(0,0, momenta_106, masses2_59, T0sum(333), M2)
  call TI_call_OL(0,0, momenta_84, masses2_34, T0sum(334), M2)
  call TI_call_OL(0,0, momenta_58, masses2_27, T0sum(335), M2)
  call TI_call_OL(0,0, momenta_34, masses2_27, T0sum(336), M2)
  call TI_call_OL(0,0, momenta_34, masses2_62, T0sum(337), M2)
  call TI_call_OL(0,0, momenta_66, masses2_27, T0sum(338), M2)
  call TI_call_OL(0,0, momenta_53, masses2_27, T0sum(339), M2)
  call TI_call_OL(0,0, momenta_52, masses2_27, T0sum(340), M2)
  call TI_call_OL(0,0, momenta_53, masses2_38, T0sum(341), M2)
  call TI_call_OL(0,0, momenta_51, masses2_27, T0sum(342), M2)
  call TI_call_OL(0,0, momenta_122, masses2_34, T0sum(343), M2)
  call TI_call_OL(0,0, momenta_116, masses2_59, T0sum(344), M2)
  call TI_call_OL(0,0, momenta_115, masses2_55, T0sum(345), M2)
  call TI_call_OL(0,0, momenta_87, masses2_44, T0sum(346), M2)
  call TI_call_OL(0,0, momenta_75, masses2_45, T0sum(347), M2)
  call TI_call_OL(0,0, momenta_37, masses2_45, T0sum(348), M2)
  call TI_call_OL(0,0, momenta_37, masses2_46, T0sum(349), M2)
  call TI_call_OL(0,0, momenta_87, masses2_53, T0sum(350), M2)
  call TI_call_OL(0,0, momenta_75, masses2_54, T0sum(351), M2)
  call TI_call_OL(0,0, momenta_37, masses2_54, T0sum(352), M2)
  call TI_call_OL(0,0, momenta_37, masses2_43, T0sum(353), M2)
  call TI_call_OL(0,0, momenta_80, masses2_44, T0sum(354), M2)
  call TI_call_OL(0,0, momenta_53, masses2_45, T0sum(355), M2)
  call TI_call_OL(0,0, momenta_53, masses2_46, T0sum(356), M2)
  call TI_call_OL(0,0, momenta_80, masses2_53, T0sum(357), M2)
  call TI_call_OL(0,0, momenta_53, masses2_54, T0sum(358), M2)
  call TI_call_OL(0,0, momenta_53, masses2_43, T0sum(359), M2)
  call TI_call_OL(0,0, momenta_54, masses2_50, T0sum(360), M2)
  call TI_call_OL(0,0, momenta_38, masses2_50, T0sum(361), M2)
  call TI_call_OL(0,0, momenta_102, masses2_37, T0sum(362), M2)
  call TI_call_OL(0,0, momenta_102, masses2_34, T0sum(363), M2)
  call TI_call_OL(0,0, momenta_103, masses2_37, T0sum(364), M2)
  call TI_call_OL(0,0, momenta_86, masses2_37, T0sum(365), M2)
  call TI_call_OL(0,0, momenta_103, masses2_34, T0sum(366), M2)
  call TI_call_OL(0,0, momenta_86, masses2_34, T0sum(367), M2)
  call TI_call_OL(0,0, momenta_101, masses2_37, T0sum(368), M2)
  call TI_call_OL(0,0, momenta_99, masses2_26, T0sum(369), M2)
  call TI_call_OL(0,0, momenta_88, masses2_30, T0sum(370), M2)
  call TI_call_OL(0,0, momenta_87, masses2_40, T0sum(371), M2)
  call TI_call_OL(0,0, momenta_98, masses2_26, T0sum(372), M2)
  call TI_call_OL(0,0, momenta_96, masses2_37, T0sum(373), M2)
  call TI_call_OL(0,0, momenta_80, masses2_66, T0sum(374), M2)
  call TI_call_OL(0,0, momenta_79, masses2_61, T0sum(375), M2)
  call TI_call_OL(0,0, momenta_113, masses2_37, T0sum(376), M2)
  call TI_call_OL(0,0, momenta_97, masses2_26, T0sum(377), M2)
  call TI_call_OL(0,0, momenta_108, masses2_30, T0sum(378), M2)
  call TI_call_OL(0,0, momenta_107, masses2_40, T0sum(379), M2)
  call TI_call_OL(0,0, momenta_100, masses2_26, T0sum(380), M2)
  call TI_call_OL(0,0, momenta_95, masses2_37, T0sum(381), M2)
  call TI_call_OL(0,0, momenta_93, masses2_26, T0sum(382), M2)
  call TI_call_OL(0,0, momenta_89, masses2_30, T0sum(383), M2)
  call TI_call_OL(0,0, momenta_111, masses2_37, T0sum(384), M2)
  call TI_call_OL(0,0, momenta_91, masses2_26, T0sum(385), M2)
  call TI_call_OL(0,0, momenta_109, masses2_30, T0sum(386), M2)
  call TI_call_OL(0,0, momenta_92, masses2_26, T0sum(387), M2)
  call TI_call_OL(0,0, momenta_90, masses2_37, T0sum(388), M2)
  call TI_call_OL(0,0, momenta_78, masses2_61, T0sum(389), M2)
  call TI_call_OL(0,0, momenta_94, masses2_26, T0sum(390), M2)
  call TI_call_OL(0,0, momenta_67, masses2_27, T0sum(391), M2)
  call TI_call_OL(0,0, momenta_35, masses2_27, T0sum(392), M2)
  call TI_call_OL(0,0, momenta_49, masses2_27, T0sum(393), M2)
  call TI_call_OL(0,0, momenta_47, masses2_27, T0sum(394), M2)
  call TI_call_OL(0,0, momenta_59, masses2_27, T0sum(395), M2)
  call TI_call_OL(0,0, momenta_48, masses2_27, T0sum(396), M2)
  call TI_call_OL(0,0, momenta_68, masses2_27, T0sum(397), M2)
  call TI_call_OL(0,0, momenta_36, masses2_27, T0sum(398), M2)
  call TI_call_OL(0,0, momenta_60, masses2_27, T0sum(399), M2)
  call TI_call_OL(0,0, momenta_44, masses2_27, T0sum(400), M2)
  call TI_call_OL(0,0, momenta_42, masses2_27, T0sum(401), M2)
  call TI_call_OL(0,0, momenta_43, masses2_27, T0sum(402), M2)
  call TI_call_OL(0,0, momenta_106, masses2_51, T0sum(403), M2)
  call TI_call_OL(0,0, momenta_86, masses2_48, T0sum(404), M2)
  call TI_call_OL(0,0, momenta_80, masses2_51, T0sum(405), M2)
  call TI_call_OL(0,0, momenta_37, masses2_49, T0sum(406), M2)
  call TI_call_OL(0,0, momenta_33, masses2_49, T0sum(407), M2)
  call TI_call_OL(0,0, momenta_107, masses2_39, T0sum(408), M2)
  call TI_call_OL(0,0, momenta_87, masses2_39, T0sum(409), M2)
  call TI_call_OL(0,0, momenta_81, masses2_28, T0sum(410), M2)
  call TI_call_OL(0,0, momenta_61, masses2_32, T0sum(411), M2)
  call TI_call_OL(0,0, momenta_37, masses2_32, T0sum(412), M2)
  call TI_call_OL(0,0, momenta_116, masses2_51, T0sum(413), M2)
  call TI_call_OL(0,0, momenta_84, masses2_48, T0sum(414), M2)
  call TI_call_OL(0,0, momenta_31, masses2_49, T0sum(415), M2)
  call TI_call_OL(0,0, momenta_117, masses2_39, T0sum(416), M2)
  call TI_call_OL(0,0, momenta_85, masses2_28, T0sum(417), M2)
  call TI_call_OL(0,0, momenta_69, masses2_32, T0sum(418), M2)
  call TI_call_OL(0,0, momenta_124, masses2_34, T0sum(419), M2)
  call TI_call_OL(0,0, momenta_124, masses2_37, T0sum(420), M2)
  call TI_call_OL(0,0, momenta_15, masses2_10, T0sum(421), M2)
  call TI_call_OL(0,0, momenta_1, masses2_2, T0sum(422), M2)
  call TI_call_OL(0,0, momenta_10, masses2_11, T0sum(423), M2)
  call TI_call_OL(0,0, momenta_1, masses2_3, T0sum(424), M2)
  call TI_call_OL(0,0, momenta_2, masses2_11, T0sum(425), M2)
  call TI_call_OL(0,0, momenta_10, masses2_12, T0sum(426), M2)
  call TI_call_OL(0,0, momenta_1, masses2_8, T0sum(427), M2)
  call TI_call_OL(0,0, momenta_2, masses2_12, T0sum(428), M2)
  call TI_call_OL(0,0, momenta_15, masses2_17, T0sum(429), M2)
  call TI_call_OL(0,0, momenta_1, masses2_6, T0sum(430), M2)
  call TI_call_OL(0,0, momenta_10, masses2_18, T0sum(431), M2)
  call TI_call_OL(0,0, momenta_1, masses2_7, T0sum(432), M2)
  call TI_call_OL(0,0, momenta_2, masses2_18, T0sum(433), M2)
  call TI_call_OL(0,0, momenta_10, masses2_9, T0sum(434), M2)
  call TI_call_OL(0,0, momenta_2, masses2_9, T0sum(435), M2)
  call TI_call_OL(0,0, momenta_24, masses2_10, T0sum(436), M2)
  call TI_call_OL(0,0, momenta_5, masses2_11, T0sum(437), M2)
  call TI_call_OL(0,0, momenta_5, masses2_12, T0sum(438), M2)
  call TI_call_OL(0,0, momenta_24, masses2_17, T0sum(439), M2)
  call TI_call_OL(0,0, momenta_5, masses2_18, T0sum(440), M2)
  call TI_call_OL(0,0, momenta_5, masses2_9, T0sum(441), M2)
  call TI_call_OL(0,0, momenta_23, masses2_1, T0sum(442), M2)
  call TI_call_OL(0,0, momenta_16, masses2_1, T0sum(443), M2)
  call TI_call_OL(0,0, momenta_14, masses2_1, T0sum(444), M2)
  call TI_call_OL(0,0, momenta_24, masses2_21, T0sum(445), M2)
  call TI_call_OL(0,0, momenta_13, masses2_20, T0sum(446), M2)
  call TI_call_OL(0,0, momenta_10, masses2_20, T0sum(447), M2)
  call TI_call_OL(0,0, momenta_5, masses2_20, T0sum(448), M2)
  call TI_call_OL(0,0, momenta_2, masses2_20, T0sum(449), M2)
  call TI_call_OL(0,0, momenta_23, masses2_7, T0sum(450), M2)
  call TI_call_OL(0,0, momenta_20, masses2_7, T0sum(451), M2)
  call TI_call_OL(0,0, momenta_16, masses2_19, T0sum(452), M2)
  call TI_call_OL(0,0, momenta_24, masses2_24, T0sum(453), M2)
  call TI_call_OL(0,0, momenta_13, masses2_13, T0sum(454), M2)
  call TI_call_OL(0,0, momenta_10, masses2_23, T0sum(455), M2)
  call TI_call_OL(0,0, momenta_5, masses2_13, T0sum(456), M2)
  call TI_call_OL(0,0, momenta_2, masses2_23, T0sum(457), M2)
  call TI_call_OL(0,0, momenta_24, masses2_14, T0sum(458), M2)
  call TI_call_OL(0,0, momenta_13, masses2_23, T0sum(459), M2)
  call TI_call_OL(0,0, momenta_10, masses2_13, T0sum(460), M2)
  call TI_call_OL(0,0, momenta_5, masses2_23, T0sum(461), M2)
  call TI_call_OL(0,0, momenta_2, masses2_13, T0sum(462), M2)
  call TI_call_OL(0,0, momenta_13, masses2_9, T0sum(463), M2)
  call TI_call_OL(0,0, momenta_24, masses2_1, T0sum(464), M2)
  call TI_call_OL(0,0, momenta_20, masses2_1, T0sum(465), M2)
  call TI_call_OL(0,0, momenta_15, masses2_1, T0sum(466), M2)
  call TI_call_OL(0,0, momenta_23, masses2_8, T0sum(467), M2)
  call TI_call_OL(0,0, momenta_20, masses2_8, T0sum(468), M2)
  call TI_call_OL(0,0, momenta_19, masses2_1, T0sum(469), M2)
  call TI_call_OL(0,0, momenta_19, masses2_8, T0sum(470), M2)
  call TI_call_OL(0,0, momenta_16, masses2_8, T0sum(471), M2)
  call TI_call_OL(0,0, momenta_19, masses2_7, T0sum(472), M2)
  call TI_call_OL(0,0, momenta_16, masses2_7, T0sum(473), M2)
  call TI_call_OL(0,0, momenta_13, masses2_12, T0sum(474), M2)
  call TI_call_OL(0,0, momenta_16, masses2_22, T0sum(475), M2)
  call TI_call_OL(0,0, momenta_26, masses2_19, T0sum(476), M2)
  call TI_call_OL(0,0, momenta_25, masses2_7, T0sum(477), M2)
  call TI_call_OL(0,0, momenta_13, masses2_2, T0sum(478), M2)
  call TI_call_OL(0,0, momenta_2, masses2_2, T0sum(479), M2)
  call TI_call_OL(0,0, momenta_19, masses2_22, T0sum(480), M2)
  call TI_call_OL(0,0, momenta_19, masses2_19, T0sum(481), M2)
  call TI_call_OL(0,0, momenta_10, masses2_2, T0sum(482), M2)
  call TI_call_OL(0,0, momenta_5, masses2_2, T0sum(483), M2)
  call TI_call_OL(0,0, momenta_23, masses2_19, T0sum(484), M2)
  call TI_call_OL(0,0, momenta_20, masses2_19, T0sum(485), M2)
  call TI_call_OL(0,0, momenta_14, masses2_10, T0sum(486), M2)
  call TI_call_OL(0,0, momenta_13, masses2_11, T0sum(487), M2)
  call TI_call_OL(0,0, momenta_14, masses2_17, T0sum(488), M2)
  call TI_call_OL(0,0, momenta_13, masses2_18, T0sum(489), M2)
  call TI_call_OL(0,0, momenta_23, masses2_22, T0sum(490), M2)
  call TI_call_OL(0,0, momenta_26, masses2_7, T0sum(491), M2)
  call TI_call_OL(0,0, momenta_25, masses2_19, T0sum(492), M2)
  call TI_call_OL(0,0, momenta_26, masses2_8, T0sum(493), M2)
  call TI_call_OL(0,0, momenta_25, masses2_22, T0sum(494), M2)
  call TI_call_OL(0,0, momenta_15, masses2_22, T0sum(495), M2)
  call TI_call_OL(0,0, momenta_15, masses2_8, T0sum(496), M2)
  call TI_call_OL(0,0, momenta_9, masses2_2, T0sum(497), M2)
  call TI_call_OL(0,0, momenta_8, masses2_2, T0sum(498), M2)
  call TI_call_OL(0,0, momenta_14, masses2_8, T0sum(499), M2)
  call TI_call_OL(0,0, momenta_14, masses2_22, T0sum(500), M2)
  call TI_call_OL(0,0, momenta_7, masses2_2, T0sum(501), M2)
  call TI_call_OL(0,0, momenta_6, masses2_2, T0sum(502), M2)
  call TI_call_OL(0,0, momenta_20, masses2_22, T0sum(503), M2)
  call TI_call_OL(0,0, momenta_24, masses2_25, T0sum(504), M2)
  call TI_call_OL(0,0, momenta_12, masses2_2, T0sum(505), M2)
  call TI_call_OL(0,0, momenta_4, masses2_2, T0sum(506), M2)
  call TI_call_OL(0,0, momenta_12, masses2_6, T0sum(507), M2)
  call TI_call_OL(0,0, momenta_4, masses2_6, T0sum(508), M2)
  call TI_call_OL(0,0, momenta_26, masses2_22, T0sum(509), M2)
  call TI_call_OL(0,0, momenta_25, masses2_8, T0sum(510), M2)
  call TI_call_OL(0,0, momenta_11, masses2_2, T0sum(511), M2)
  call TI_call_OL(0,0, momenta_3, masses2_2, T0sum(512), M2)
  call TI_call_OL(0,0, momenta_22, masses2_1, T0sum(513), M2)
  call TI_call_OL(0,0, momenta_17, masses2_1, T0sum(514), M2)
  call TI_call_OL(0,0, momenta_21, masses2_1, T0sum(515), M2)
  call TI_call_OL(0,0, momenta_18, masses2_1, T0sum(516), M2)
  call TI_call_OL(0,0, momenta_9, masses2_9, T0sum(517), M2)
  call TI_call_OL(0,0, momenta_8, masses2_9, T0sum(518), M2)
  call TI_call_OL(0,0, momenta_7, masses2_9, T0sum(519), M2)
  call TI_call_OL(0,0, momenta_6, masses2_9, T0sum(520), M2)
  call TI_call_OL(0,0, momenta_24, masses2_16, T0sum(521), M2)
  call TI_call_OL(0,0, momenta_1, masses2_5, T0sum(522), M2)
  call TI_call_OL(0,0, momenta_24, masses2_15, T0sum(523), M2)
  call TI_call_OL(0,0, momenta_1, masses2_4, T0sum(524), M2)

  call TI_call_OL(0,1, momenta_277, masses2_141, T1sum(1), M2,sbarray_1, ScalarBoxes(:))
  call TI_call_OL(0,1, momenta_273, masses2_142, T1sum(2), M2,sbarray_2, ScalarBoxes(:))
  call TI_call_OL(0,1, momenta_275, masses2_141, T1sum(3), M2,sbarray_3, ScalarBoxes(:))
  call TI_call_OL(0,1, momenta_274, masses2_142, T1sum(4), M2,sbarray_4, ScalarBoxes(:))
  call TI_call_OL(0,1, momenta_278, masses2_141, T1sum(5), M2,sbarray_5, ScalarBoxes(:))
  call TI_call_OL(0,1, momenta_276, masses2_141, T1sum(6), M2,sbarray_6, ScalarBoxes(:))
  call TI_call_OL(0,1, momenta_271, masses2_142, T1sum(7), M2,sbarray_7, ScalarBoxes(:))
  call TI_call_OL(0,1, momenta_272, masses2_142, T1sum(8), M2,sbarray_8, ScalarBoxes(:))
  call TI_call_OL(0,1, momenta_269, masses2_124, T1sum(9), M2,sbarray_9, ScalarBoxes(:))
  call TI_call_OL(0,1, momenta_263, masses2_137, T1sum(10), M2,sbarray_10, ScalarBoxes(:))
  call TI_call_OL(0,1, momenta_267, masses2_124, T1sum(11), M2,sbarray_11, ScalarBoxes(:))
  call TI_call_OL(0,1, momenta_264, masses2_137, T1sum(12), M2,sbarray_12, ScalarBoxes(:))
  call TI_call_OL(0,1, momenta_270, masses2_124, T1sum(13), M2,sbarray_13, ScalarBoxes(:))
  call TI_call_OL(0,1, momenta_268, masses2_124, T1sum(14), M2,sbarray_14, ScalarBoxes(:))
  call TI_call_OL(0,1, momenta_261, masses2_137, T1sum(15), M2,sbarray_15, ScalarBoxes(:))
  call TI_call_OL(0,1, momenta_262, masses2_137, T1sum(16), M2,sbarray_16, ScalarBoxes(:))
  call TI_call_OL(0,1, momenta_259, masses2_130, T1sum(17), M2,sbarray_17, ScalarBoxes(:))
  call TI_call_OL(0,1, momenta_251, masses2_130, T1sum(18), M2,sbarray_18, ScalarBoxes(:))
  call TI_call_OL(0,1, momenta_249, masses2_123, T1sum(19), M2,sbarray_19, ScalarBoxes(:))
  call TI_call_OL(0,1, momenta_248, masses2_126, T1sum(20), M2,sbarray_20, ScalarBoxes(:))
  call TI_call_OL(0,1, momenta_255, masses2_128, T1sum(21), M2,sbarray_21, ScalarBoxes(:))
  call TI_call_OL(0,1, momenta_239, masses2_140, T1sum(22), M2,sbarray_22, ScalarBoxes(:))
  call TI_call_OL(0,1, momenta_237, masses2_136, T1sum(23), M2,sbarray_23, ScalarBoxes(:))
  call TI_call_OL(0,1, momenta_235, masses2_138, T1sum(24), M2,sbarray_24, ScalarBoxes(:))
  call TI_call_OL(0,1, momenta_257, masses2_130, T1sum(25), M2,sbarray_25, ScalarBoxes(:))
  call TI_call_OL(0,1, momenta_245, masses2_123, T1sum(26), M2,sbarray_26, ScalarBoxes(:))
  call TI_call_OL(0,1, momenta_244, masses2_126, T1sum(27), M2,sbarray_27, ScalarBoxes(:))
  call TI_call_OL(0,1, momenta_256, masses2_128, T1sum(28), M2,sbarray_28, ScalarBoxes(:))
  call TI_call_OL(0,1, momenta_240, masses2_140, T1sum(29), M2,sbarray_29, ScalarBoxes(:))
  call TI_call_OL(0,1, momenta_238, masses2_136, T1sum(30), M2,sbarray_30, ScalarBoxes(:))
  call TI_call_OL(0,1, momenta_260, masses2_130, T1sum(31), M2,sbarray_31, ScalarBoxes(:))
  call TI_call_OL(0,1, momenta_252, masses2_130, T1sum(32), M2,sbarray_32, ScalarBoxes(:))
  call TI_call_OL(0,1, momenta_250, masses2_123, T1sum(33), M2,sbarray_33, ScalarBoxes(:))
  call TI_call_OL(0,1, momenta_258, masses2_130, T1sum(34), M2,sbarray_34, ScalarBoxes(:))
  call TI_call_OL(0,1, momenta_246, masses2_123, T1sum(35), M2,sbarray_35, ScalarBoxes(:))
  call TI_call_OL(0,1, momenta_253, masses2_128, T1sum(36), M2,sbarray_36, ScalarBoxes(:))
  call TI_call_OL(0,1, momenta_233, masses2_136, T1sum(37), M2,sbarray_37, ScalarBoxes(:))
  call TI_call_OL(0,1, momenta_231, masses2_138, T1sum(38), M2,sbarray_38, ScalarBoxes(:))
  call TI_call_OL(0,1, momenta_254, masses2_128, T1sum(39), M2,sbarray_39, ScalarBoxes(:))
  call TI_call_OL(0,1, momenta_234, masses2_136, T1sum(40), M2,sbarray_40, ScalarBoxes(:))
  call TI_call_OL(0,1, momenta_240, masses2_134, T1sum(41), M2,sbarray_41, ScalarBoxes(:))
  call TI_call_OL(0,1, momenta_244, masses2_125, T1sum(42), M2,sbarray_42, ScalarBoxes(:))
  call TI_call_OL(0,1, momenta_239, masses2_134, T1sum(43), M2,sbarray_43, ScalarBoxes(:))
  call TI_call_OL(0,1, momenta_248, masses2_125, T1sum(44), M2,sbarray_44, ScalarBoxes(:))
  call TI_call_OL(0,1, momenta_241, masses2_131, T1sum(45), M2,sbarray_45, ScalarBoxes(:))
  call TI_call_OL(0,1, momenta_241, masses2_133, T1sum(46), M2,sbarray_46, ScalarBoxes(:))
  call TI_call_OL(0,1, momenta_241, masses2_132, T1sum(47), M2,sbarray_47, ScalarBoxes(:))
  call TI_call_OL(0,1, momenta_242, masses2_131, T1sum(48), M2,sbarray_48, ScalarBoxes(:))
  call TI_call_OL(0,1, momenta_242, masses2_132, T1sum(49), M2,sbarray_49, ScalarBoxes(:))
  call TI_call_OL(0,1, momenta_242, masses2_133, T1sum(50), M2,sbarray_50, ScalarBoxes(:))
  call TI_call_OL(0,1, momenta_247, masses2_122, T1sum(51), M2,sbarray_51, ScalarBoxes(:))
  call TI_call_OL(0,1, momenta_247, masses2_123, T1sum(52), M2,sbarray_52, ScalarBoxes(:))
  call TI_call_OL(0,1, momenta_247, masses2_136, T1sum(53), M2,sbarray_53, ScalarBoxes(:))
  call TI_call_OL(0,1, momenta_243, masses2_122, T1sum(54), M2,sbarray_54, ScalarBoxes(:))
  call TI_call_OL(0,1, momenta_243, masses2_136, T1sum(55), M2,sbarray_55, ScalarBoxes(:))
  call TI_call_OL(0,1, momenta_243, masses2_123, T1sum(56), M2,sbarray_56, ScalarBoxes(:))
  call TI_call_OL(0,1, momenta_236, masses2_139, T1sum(57), M2,sbarray_57, ScalarBoxes(:))
  call TI_call_OL(0,1, momenta_236, masses2_135, T1sum(58), M2,sbarray_58, ScalarBoxes(:))
  call TI_call_OL(0,1, momenta_232, masses2_139, T1sum(59), M2,sbarray_59, ScalarBoxes(:))
  call TI_call_OL(0,1, momenta_265, masses2_129, T1sum(60), M2,sbarray_60, ScalarBoxes(:))
  call TI_call_OL(0,1, momenta_265, masses2_127, T1sum(61), M2,sbarray_61, ScalarBoxes(:))
  call TI_call_OL(0,1, momenta_266, masses2_129, T1sum(62), M2,sbarray_62, ScalarBoxes(:))

  call add_met(M2,M2L1R1)

#ifdef LOOPSQUARED
  end if
#endif

  call met_to_real(M2out,M2)

#ifdef PRECISION_dp
  call HOL_memory_deallocation_/**/REALKIND(1)
  call HCL_memory_deallocation_/**/REALKIND(1)
#endif

end subroutine integrate_tensor_sum

end module ol_tensor_sum_storage_ppnnjj_ew_nenexddxbbx_1_/**/REALKIND
