
module ol_colourmatrix_ppnnjj_ew_nenexuuuxux_4_/**/REALKIND
  use KIND_TYPES, only: REALKIND
  implicit none
  logical, save           :: colmat_not_initialised = .true.
  complex(REALKIND), save :: K1(46,2), K2(2,2), KL(2,2), Cas(6) = 0
  contains
  subroutine colourmatrix_init
    use ol_parameters_decl_/**/REALKIND, only: CI
    implicit none
    integer :: k, co
    colmat_not_initialised = .false.
    ! colour matrix

  K1( 1,:) = [ 9, 3]
  K1( 2,:) = [ 3, 9]
  K1( 3,:) = [ 0, 0]
  K1( 4,:) = [ 0, 0]
  K1( 5,:) = [ 0, 0]
  K1( 6,:) = [ 0, 0]
  K1( 7,:) = [ 0, 0]
  K1( 8,:) = [ 0, 0]
  K1( 9,:) = [ 0, 0]
  K1(10,:) = [ 0, 0]
  K1(11,:) = [ 0, 0]
  K1(12,:) = [ 0, 0]
  K1(13,:) = [ 0, 0]
  K1(14,:) = [ 0, 0]
  K1(15,:) = [ 0, 0]
  K1(16,:) = [ 0, 0]
  K1(17,:) = [ 0, 0]
  K1(18,:) = [ 0, 0]
  K1(19,:) = [ 0, 0]
  K1(20,:) = [ 0, 0]
  K1(21,:) = [ 0, 0]
  K1(22,:) = [ 0, 0]
  K1(23,:) = [ 0, 0]
  K1(24,:) = [ 0, 0]
  K1(25,:) = [ 0, 0]
  K1(26,:) = [ 0, 0]
  K1(27,:) = [ 0, 0]
  K1(28,:) = [ 0, 0]
  K1(29,:) = [ 0, 0]
  K1(30,:) = [ 0, 0]
  K1(31,:) = [ 0, 0]
  K1(32,:) = [ 0, 0]
  K1(33,:) = [ 0, 0]
  K1(34,:) = [ 0, 0]
  K1(35,:) = [ 0, 0]
  K1(36,:) = [ 0, 0]
  K1(37,:) = [ 0, 0]
  K1(38,:) = [ 0, 0]
  K1(39,:) = [ 0, 0]
  K1(40,:) = [ 0, 0]
  K1(41,:) = [ 0, 0]
  K1(42,:) = [ 0, 0]
  K1(43,:) = [ 0, 0]
  K1(44,:) = [ 0, 0]
  K1(45,:) = [ 9, 3]
  K1(46,:) = [ 3, 9]

  K2(1,:) = [ 9, 3]
  K2(2,:) = [ 3, 9]

  KL(1,:) = [ 9, 3]
  KL(2,:) = [ 3, 9]

#if -1 > 0
    co = 0
    do k = 1, 6
      co = co + k
      Cas(k) = K1(1+2*co,1)/K1(1,1)
    end do
#endif
  end subroutine colourmatrix_init
end module ol_colourmatrix_ppnnjj_ew_nenexuuuxux_4_/**/REALKIND



module ol_forced_parameters_ppnnjj_ew_nenexuuuxux_4_/**/REALKIND
  implicit none
  contains
  subroutine check_forced_parameters
    use ol_parameters_decl_/**/REALKIND
    use ol_loop_parameters_decl_/**/REALKIND
#ifndef PRECISION_dp
    use ol_loop_parameters_decl_/**/DREALKIND, only: LeadingColour, nc, nf, CKMORDER
#endif
    implicit none
    logical, save :: checks_not_written = .true.

    if (checks_not_written) then
    ! e.g.
    ! if (ME /= 0) write(*,101) 'ME = 0'
  if (ME /= 0) write(*,101) 'ME = 0'
  if (CKMORDER /= 0) write(*,101) 'CKMORDER = 0'
  if (nc /= 3) write(*,101) 'nc = 3'
  if (nf /= 6) write(*,101) 'nf = 6'
  if (MU /= 0) write(*,101) 'MU = 0'
  if (MD /= 0) write(*,101) 'MD = 0'
  if (MS /= 0) write(*,101) 'MS = 0'
  if (MC /= 0) write(*,101) 'MC = 0'
  if (LeadingColour /= 0) write(*,101) 'LeadingColour = 0'


    checks_not_written = .false.
    end if

    101 format('[OpenLoops] === WARNING ===',/,'[OpenLoops] code was generated with ',A,/,'[OpenLoops] ===============')
  end subroutine check_forced_parameters
end module ol_forced_parameters_ppnnjj_ew_nenexuuuxux_4_/**/REALKIND


! **********************************************************************
module ol_loop_storage_ppnnjj_ew_nenexuuuxux_4_/**/REALKIND
! **********************************************************************
  use KIND_TYPES, only: REALKIND, intkind1, intkind2
  use ol_data_types_/**/REALKIND, only: wfun, Hpolcont

#ifdef PRECISION_dp
  integer(intkind1), save :: ntry = 1, ntryL = 1
  integer(intkind1), save :: p_switch = 0 ! switch for dp or qp. Used for memory allocation of the OL types
  ! the following are flags for memory allocation of the hol coefficients in dp or qp
  logical, save :: dp_not_alloc = .TRUE., qp_not_alloc = .TRUE.
  integer, save :: n_merge_steps  ! total number of merging steps
  integer, save :: n_merge_mism   ! number of merging mismatches
  integer, save :: merge_step = 1 ! current merging step
  integer(intkind2), save, allocatable :: merge_tables(:,:,:) ! merging tables
  integer(intkind2), save, allocatable :: merge_mism(:)       ! array of merging mismatches
  integer(intkind2), save, allocatable :: merge_hels(:)       ! array with relevant helicities for a merging step
  logical, save :: merge_tables_on = .false.
  integer(intkind2), parameter :: nheltot = 64 ! number of helicity configurations
  integer(intkind2), save :: nhel = 64 ! number of non-vanishing helicity configurations (adapted at runtime)
  integer(intkind2), save :: Hel(64) ! physical helicity states
#endif

  complex(REALKIND), save :: den(441)

  ! external wave functions ex1(h1),... for h<n> helicities
  type(wfun) :: ex1(2), ex2(2), ex3(2), ex4(2), ex5(2), ex6(2)

  ! wf<h>(h,n) n wave functions with h helicity configurations
  type(wfun) :: wf4(4,37), wf8(8,210), wf16(16,62), wf64(64,224)

  ! diagram prefactors
  integer,           save :: fac_status_loop1 = -1, fac_status_loop2 = -1
  complex(REALKIND), save :: f(91), c(87)

  !Vector in helicity and colour space for Born-Loop interference
  type(Hpolcont),   save :: M0_col1_helarray(2,64), M0M1_hel_cc(2,64,22)
  complex(REALKIND), save :: M2ctcc(22)

end module ol_loop_storage_ppnnjj_ew_nenexuuuxux_4_/**/REALKIND






! **********************************************************************
module ol_loop_ppnnjj_ew_nenexuuuxux_4_/**/REALKIND
! **********************************************************************
  use KIND_TYPES, only: REALKIND, DREALKIND, intkind1, intkind2
  use ol_data_types_/**/REALKIND, only: wfun, Hpolcont
  use ol_loop_storage_ppnnjj_ew_nenexuuuxux_4_/**/REALKIND
  implicit none

!*********************************************************************************
  contains

! **********************************************************************
subroutine fac_init_loop()
! Writes diagram prefactors to 'f', rsp. 'c'
! **********************************************************************
  use ol_parameters_decl_/**/REALKIND
  use ol_loop_parameters_decl_/**/REALKIND
  use ol_init, only: set_parameter, tree_parameters_flush, parameters_flush
#ifndef PRECISION_dp
  use ol_loop_parameters_decl_/**/DREALKIND, only: SwF, SwB
!  use ol_loop_parameters_decl_/**/DREALKIND, only: DOI
#endif
  implicit none
  call set_parameter("ew_renorm", 1)
  if (parameters_status == 0) call tree_parameters_flush()
  if (loop_parameters_status == 0) call parameters_flush()
  fac_status_loop1 = parameters_status
  fac_status_loop2 = loop_parameters_status
  ! factors of the diagrams
    f( 1) = (4*CI*eQED**4)/9._/**/REALKIND
    f( 2) = CI*eQED**4
    f( 3) = (8*CI*countertermnorm*eQED**6)/27._/**/REALKIND
    f( 4) = (4*CI*countertermnorm*eQED**6)/9._/**/REALKIND
    f( 5) = (2*CI*countertermnorm*eQED**6)/3._/**/REALKIND
    f( 6) = CI*countertermnorm*eQED**6
    f( 7) = (16*eQED**6*integralnorm*SwB)/81._/**/REALKIND
    f( 8) = (4*eQED**6*integralnorm*SwB)/9._/**/REALKIND
    f( 9) = eQED**6*integralnorm*SwB
    f(10) = (4*eQED**6*integralnorm*MW**2*SwB)/9._/**/REALKIND
    f(11) = (2*eQED**6*integralnorm*MW**2*SwB)/3._/**/REALKIND
    f(12) = (eQED**6*integralnorm*MW**2*SwB)/(cw**2*2._/**/REALKIND)
    f(13) = (eQED**6*integralnorm*SwB)/(sw**6*8._/**/REALKIND)
    f(14) = (cw*eQED**6*integralnorm*SwB)/(sw**5*4._/**/REALKIND)
    f(15) = (eQED**6*integralnorm*SwB)/(sw**4*18._/**/REALKIND)
    f(16) = (eQED**6*integralnorm*SwB)/(sw**4*9._/**/REALKIND)
    f(17) = (eQED**6*integralnorm*SwB)/(sw**4*6._/**/REALKIND)
    f(18) = (eQED**6*integralnorm*SwB)/(sw**4*4._/**/REALKIND)
    f(19) = (cw**2*eQED**6*integralnorm*SwB)/(sw**4*2._/**/REALKIND)
    f(20) = (eQED**6*integralnorm*MW**2*SwB)/(cw**2*sw**4*2._/**/REALKIND)
    f(21) = (cw*eQED**6*integralnorm*SwB)/(sw**3*9._/**/REALKIND)
    f(22) = (2*cw*eQED**6*integralnorm*SwB)/(sw**3*9._/**/REALKIND)
    f(23) = (cw*eQED**6*integralnorm*SwB)/(sw**3*3._/**/REALKIND)
    f(24) = (cw*eQED**6*integralnorm*SwB)/(sw**3*2._/**/REALKIND)
    f(25) = (cw**3*eQED**6*integralnorm*SwB)/sw**3
    f(26) = (eQED**6*integralnorm*MW**2*SwB)/(cw*sw**3*2._/**/REALKIND)
    f(27) = (eQED**6*integralnorm*MW**2*SwB)/(cw*sw**3)
    f(28) = (eQED**6*integralnorm*SwB)/(sw**2*9._/**/REALKIND)
    f(29) = (4*eQED**6*integralnorm*SwB)/(sw**2*27._/**/REALKIND)
    f(30) = (2*eQED**6*integralnorm*SwB)/(sw**2*9._/**/REALKIND)
    f(31) = (eQED**6*integralnorm*SwB)/(sw**2*3._/**/REALKIND)
    f(32) = (eQED**6*integralnorm*SwB)/(sw**2*2._/**/REALKIND)
    f(33) = (eQED**6*integralnorm*SwB)/(cw**2*sw**2*9._/**/REALKIND)
    f(34) = (eQED**6*integralnorm*SwB)/(cw**2*sw**2*4._/**/REALKIND)
    f(35) = (4*cw**2*eQED**6*integralnorm*SwB)/(sw**2*9._/**/REALKIND)
    f(36) = (2*cw**2*eQED**6*integralnorm*SwB)/(sw**2*3._/**/REALKIND)
    f(37) = (cw**2*eQED**6*integralnorm*SwB)/sw**2
    f(38) = (eQED**6*integralnorm*MH**2*SwB)/(cw**2*sw**2*3._/**/REALKIND)
    f(39) = (2*eQED**6*integralnorm*MW**2*SwB)/(sw**2*9._/**/REALKIND)
    f(40) = (4*eQED**6*integralnorm*MW**2*SwB)/(cw**4*sw**2*9._/**/REALKIND)
    f(41) = (eQED**6*integralnorm*MW**2*SwB)/(cw**4*sw**2)
    f(42) = (eQED**6*integralnorm*MW**2*SwB)/(cw**2*sw**2*3._/**/REALKIND)
    f(43) = (2*eQED**6*integralnorm*MW**2*SwB)/(cw**2*sw**2*3._/**/REALKIND)
    f(44) = (8*cw*eQED**6*integralnorm*SwB)/(sw*27._/**/REALKIND)
    f(45) = (4*cw*eQED**6*integralnorm*SwB)/(sw*9._/**/REALKIND)
    f(46) = (2*cw*eQED**6*integralnorm*SwB)/(sw*3._/**/REALKIND)
    f(47) = (eQED**6*integralnorm*MW**2*SwB)/(cw**3*sw*2._/**/REALKIND)
    f(48) = (eQED**6*integralnorm*MW**2*SwB)/(cw*sw*3._/**/REALKIND)
    f(49) = (4*cw*eQED**6*integralnorm*MW**2*SwB)/(sw*9._/**/REALKIND)
    f(50) = (8*eQED**6*integralnorm*MW**2*sw*SwB)/(cw*27._/**/REALKIND)
    f(51) = (4*eQED**6*integralnorm*MW**2*sw*SwB)/(cw*9._/**/REALKIND)
    f(52) = (2*eQED**6*integralnorm*MW**2*sw*SwB)/(cw*3._/**/REALKIND)
    f(53) = (eQED**6*integralnorm*MW**2*sw*SwB)/cw
    f(54) = (4*eQED**6*integralnorm*MW**2*sw**2*SwB)/(cw**2*9._/**/REALKIND)
    f(55) = (2*eQED**6*integralnorm*MW**2*sw**2*SwB)/(cw**2*3._/**/REALKIND)
    f(56) = (eQED**6*integralnorm*MW**2*sw**2*SwB)/cw**2
    f(57) = -((eQED**6*integralnorm*MH**2*(cw - sw)*(cw + sw)*SwB)/(cw**3*sw**3*4._/**/REALKIND))
    f(58) = (-4*eQED**6*integralnorm*(cw - sw)*(cw + sw)*SwB)/(cw*sw*27._/**/REALKIND)
    f(59) = (-2*eQED**6*integralnorm*(cw - sw)*(cw + sw)*SwB)/(cw*sw*9._/**/REALKIND)
    f(60) = -((eQED**6*integralnorm*(cw - sw)*(cw + sw)*SwB)/(cw*sw*3._/**/REALKIND))
    f(61) = (-4*eQED**6*integralnorm*(cw - sw)*(cw + sw)*SwB)/(cw*sw*9._/**/REALKIND)
    f(62) = (-2*eQED**6*integralnorm*MW**2*(cw - sw)*(cw + sw)*SwB)/(cw*sw*9._/**/REALKIND)
    f(63) = (eQED**6*integralnorm*(cw - sw)**2*(cw + sw)**2*SwB)/(cw**2*sw**2*9._/**/REALKIND)
    f(64) = (eQED**6*integralnorm*SwB*(cw**4*3._/**/REALKIND + sw**4*3._/**/REALKIND  &
      - cw**2*sw**2*6._/**/REALKIND))/(cw**2*sw**2*3._/**/REALKIND*6._/**/REALKIND)
    f(65) = (eQED**6*integralnorm*SwB*(cw**4*2._/**/REALKIND + sw**4*2._/**/REALKIND  &
      - cw**2*sw**2*4._/**/REALKIND))/(cw**2*sw**2*2._/**/REALKIND*4._/**/REALKIND)
    f(66) = (eQED**6*integralnorm*(cw - sw)**2*(cw + sw)**2*SwB)/(cw**2*sw**2*3._/**/REALKIND)
    f(67) = -((eQED**6*integralnorm*MW**2*(cw - sw)*(cw + sw)*SwB)/(cw**2*3._/**/REALKIND))
    f(68) = -((eQED**6*integralnorm*(cw - sw)**3*(cw + sw)**3*SwB)/(cw**3*sw**3*8._/**/REALKIND))
    f(69) = -((eQED**6*integralnorm*(cw - sw)**3*(cw + sw)**3*SwB)/(cw**3*sw**3*4._/**/REALKIND))
    f(70) = -((eQED**6*integralnorm*MW**2*(cw - sw)*sw*(cw + sw)*SwB)/(cw**3*2._/**/REALKIND))
    f(71) = (4*eQED**6*integralnorm*SwF)/81._/**/REALKIND
    f(72) = (8*eQED**6*integralnorm*SwF)/81._/**/REALKIND
    f(73) = (16*eQED**6*integralnorm*SwF)/81._/**/REALKIND
    f(74) = (2*eQED**6*integralnorm*SwF)/9._/**/REALKIND
    f(75) = (8*eQED**6*integralnorm*SwF)/27._/**/REALKIND
    f(76) = (32*eQED**6*integralnorm*SwF)/81._/**/REALKIND
    f(77) = (4*eQED**6*integralnorm*SwF)/9._/**/REALKIND
    f(78) = (2*eQED**6*integralnorm*SwF)/3._/**/REALKIND
    f(79) = (8*eQED**6*integralnorm*SwF)/9._/**/REALKIND
    f(80) = eQED**6*integralnorm*SwF
    f(81) = (4*eQED**6*integralnorm*SwF)/3._/**/REALKIND
    f(82) = 2*eQED**6*integralnorm*SwF
    f(83) = 3*eQED**6*integralnorm*SwF
    f(84) = (eQED**6*integralnorm*MB*SwF)/(cw**2*sw**2*9._/**/REALKIND)
    f(85) = (eQED**6*integralnorm*MB*SwF)/(cw**2*sw**2*2._/**/REALKIND)
    f(86) = (eQED**6*integralnorm*ML*SwF)/(cw**2*sw**2*3._/**/REALKIND)
    f(87) = (eQED**6*integralnorm*ML*SwF)/(cw**2*sw**2*2._/**/REALKIND)
    f(88) = (eQED**6*integralnorm*MM*SwF)/(cw**2*sw**2*3._/**/REALKIND)
    f(89) = (eQED**6*integralnorm*MM*SwF)/(cw**2*sw**2*2._/**/REALKIND)
    f(90) = (2*eQED**6*integralnorm*MT*SwF)/(cw**2*sw**2*9._/**/REALKIND)
    f(91) = (eQED**6*integralnorm*MT*SwF)/(cw**2*sw**2*2._/**/REALKIND)

  c = [ f(7), f(8), f(9), f(10), f(11), f(12), f(13), f(14), f(15), f(16), f(17), f(18), f(19), f(20), f(21), f(22), f(23), f(24) &
    , f(25), f(26), f(27), f(28), f(29), f(30), f(31), f(32), f(33), f(34), f(35), f(36), f(37), f(38), f(39), f(40), f(41), f(42) &
    , f(43), f(44), f(45), f(46), f(47), f(48), f(49), f(50), f(51), f(52), f(53), f(54), f(55), f(56), f(57), f(58), f(59), f(60) &
    , f(61), f(62), f(63), f(64), f(65), f(66), f(67), f(68), f(69), f(70), 3*f(71), 3*f(72), 3*f(73), 3*f(74), f(75), 3*f(76) &
    , f(77), 3*f(77), f(78), 3*f(79), f(80), 3*f(80), f(81), 3*f(82), f(83), 3*f(84), 3*f(85), f(86), f(87), f(88), f(89), 3*f(90) &
    , 3*f(91) ]
end subroutine fac_init_loop

subroutine denominators()
  use ol_parameters_decl_/**/REALKIND ! masses
  use ol_momenta_decl_/**/REALKIND, only: L
  implicit none
  ! propagators
  den(1) = 1 /((L(5,3) - MZ2)+L(6,3))
  den(2) = 1 /((L(5,20))+L(6,20))
  den(3) = 1 /((L(5,11))+L(6,11))
  den(6) = 1 /((L(5,20) - MZ2)+L(6,20))
  den(8) = 1 /((L(5,28))+L(6,28))
  den(13) = 1 /((L(5,24))+L(6,24))
  den(14) = 1 /((L(5,7))+L(6,7))
  den(17) = 1 /((L(5,24) - MZ2)+L(6,24))
  den(23) = 1 /((L(5,36))+L(6,36))
  den(25) = 1 /((L(5,36) - MZ2)+L(6,36))
  den(27) = 1 /((L(5,44))+L(6,44))
  den(32) = 1 /((L(5,40))+L(6,40))
  den(34) = 1 /((L(5,40) - MZ2)+L(6,40))
  den(40) = 1 /((L(5,21))+L(6,21))
  den(43) = 1 /((L(5,41))+L(6,41))
  den(46) = 1 /((L(5,37))+L(6,37))
  den(49) = 1 /((L(5,25))+L(6,25))
  den(52) = 1 /((L(5,35))+L(6,35))
  den(56) = 1 /((L(5,52))+L(6,52))
  den(61) = 1 /((L(5,19))+L(6,19))
  den(71) = 1 /((L(5,56))+L(6,56))
  den(86) = 1 /((L(5,42))+L(6,42))
  den(90) = 1 /((L(5,22))+L(6,22))
  den(94) = 1 /((L(5,26))+L(6,26))
  den(98) = 1 /((L(5,38))+L(6,38))
  den(102) = 1 /((L(5,3))+L(6,3))
  den(228) = 1 /((L(5,23) - MH2)+L(6,23))
  den(231) = 1 /((L(5,27) - MH2)+L(6,27))
  den(234) = 1 /((L(5,39) - MH2)+L(6,39))
  den(237) = 1 /((L(5,43) - MH2)+L(6,43))
  den(239) = 1 /((L(5,23))+L(6,23))
  den(241) = 1 /((L(5,23) - MZ2)+L(6,23))
  den(243) = 1 /((L(5,39))+L(6,39))
  den(245) = 1 /((L(5,39) - MZ2)+L(6,39))
  den(247) = 1 /((L(5,27))+L(6,27))
  den(249) = 1 /((L(5,27) - MZ2)+L(6,27))
  den(251) = 1 /((L(5,43))+L(6,43))
  den(253) = 1 /((L(5,43) - MZ2)+L(6,43))
  den(264) = 1 /((L(5,60) - MH2)+L(6,60))
  den(268) = 1 /((L(5,60))+L(6,60))
  den(270) = 1 /((L(5,60) - MZ2)+L(6,60))

  ! denominators
  den(4) = den(1)*den(3)
  den(5) = den(2)*den(4)
  den(7) = den(4)*den(6)
  den(9) = den(2)*den(8)
  den(10) = den(1)*den(9)
  den(11) = den(6)*den(8)
  den(12) = den(1)*den(11)
  den(15) = den(1)*den(14)
  den(16) = den(13)*den(15)
  den(18) = den(15)*den(17)
  den(19) = den(8)*den(13)
  den(20) = den(1)*den(19)
  den(21) = den(8)*den(17)
  den(22) = den(1)*den(21)
  den(24) = den(4)*den(23)
  den(26) = den(4)*den(25)
  den(28) = den(23)*den(27)
  den(29) = den(1)*den(28)
  den(30) = den(25)*den(27)
  den(31) = den(1)*den(30)
  den(33) = den(15)*den(32)
  den(35) = den(15)*den(34)
  den(36) = den(27)*den(32)
  den(37) = den(1)*den(36)
  den(38) = den(27)*den(34)
  den(39) = den(1)*den(38)
  den(41) = den(6)*den(40)
  den(42) = den(34)*den(41)
  den(44) = den(34)*den(43)
  den(45) = den(6)*den(44)
  den(47) = den(25)*den(46)
  den(48) = den(17)*den(47)
  den(50) = den(17)*den(49)
  den(51) = den(25)*den(50)
  den(53) = den(1)*den(52)
  den(54) = den(2)*den(53)
  den(55) = den(6)*den(53)
  den(57) = den(2)*den(56)
  den(58) = den(1)*den(57)
  den(59) = den(6)*den(56)
  den(60) = den(1)*den(59)
  den(62) = den(1)*den(61)
  den(63) = den(23)*den(62)
  den(64) = den(25)*den(62)
  den(65) = den(23)*den(56)
  den(66) = den(1)*den(65)
  den(67) = den(25)*den(56)
  den(68) = den(1)*den(67)
  den(69) = den(13)*den(53)
  den(70) = den(17)*den(53)
  den(72) = den(13)*den(71)
  den(73) = den(1)*den(72)
  den(74) = den(17)*den(71)
  den(75) = den(1)*den(74)
  den(76) = den(32)*den(62)
  den(77) = den(34)*den(62)
  den(78) = den(32)*den(71)
  den(79) = den(1)*den(78)
  den(80) = den(34)*den(71)
  den(81) = den(1)*den(80)
  den(82) = den(32)*den(41)
  den(83) = den(2)*den(44)
  den(84) = den(13)*den(47)
  den(85) = den(23)*den(50)
  den(87) = den(34)*den(86)
  den(88) = den(2)*den(87)
  den(89) = den(6)*den(87)
  den(91) = den(6)*den(90)
  den(92) = den(32)*den(91)
  den(93) = den(34)*den(91)
  den(95) = den(17)*den(94)
  den(96) = den(23)*den(95)
  den(97) = den(25)*den(95)
  den(99) = den(25)*den(98)
  den(100) = den(13)*den(99)
  den(101) = den(17)*den(99)
  den(103) = den(3)*den(102)
  den(104) = den(2)*den(103)
  den(105) = den(6)*den(103)
  den(106) = den(9)*den(102)
  den(107) = den(11)*den(102)
  den(108) = den(14)*den(102)
  den(109) = den(13)*den(108)
  den(110) = den(17)*den(108)
  den(111) = den(19)*den(102)
  den(112) = den(21)*den(102)
  den(113) = den(23)*den(103)
  den(114) = den(25)*den(103)
  den(115) = den(28)*den(102)
  den(116) = den(30)*den(102)
  den(117) = den(32)*den(108)
  den(118) = den(34)*den(108)
  den(119) = den(36)*den(102)
  den(120) = den(38)*den(102)
  den(121) = den(1)*den(102)
  den(122) = den(57)*den(121)
  den(123) = den(59)*den(121)
  den(124) = den(1)**2
  den(125) = den(57)*den(124)
  den(126) = den(59)*den(124)
  den(127) = den(9)*den(121)
  den(128) = den(11)*den(121)
  den(129) = den(9)*den(124)
  den(130) = den(11)*den(124)
  den(131) = den(2)**2
  den(132) = den(53)*den(131)
  den(133) = den(2)*den(6)
  den(134) = den(53)*den(133)
  den(135) = den(6)**2
  den(136) = den(53)*den(135)
  den(137) = den(4)*den(131)
  den(138) = den(4)*den(133)
  den(139) = den(4)*den(135)
  den(140) = den(4)*den(57)
  den(141) = den(4)*den(59)
  den(142) = den(9)*den(53)
  den(143) = den(11)*den(53)
  den(144) = den(72)*den(121)
  den(145) = den(74)*den(121)
  den(146) = den(72)*den(124)
  den(147) = den(74)*den(124)
  den(148) = den(19)*den(121)
  den(149) = den(21)*den(121)
  den(150) = den(19)*den(124)
  den(151) = den(21)*den(124)
  den(152) = den(13)**2
  den(153) = den(53)*den(152)
  den(154) = den(13)*den(17)
  den(155) = den(53)*den(154)
  den(156) = den(17)**2
  den(157) = den(53)*den(156)
  den(158) = den(15)*den(72)
  den(159) = den(15)*den(74)
  den(160) = den(19)*den(53)
  den(161) = den(21)*den(53)
  den(162) = den(15)*den(152)
  den(163) = den(15)*den(154)
  den(164) = den(15)*den(156)
  den(165) = den(65)*den(121)
  den(166) = den(67)*den(121)
  den(167) = den(65)*den(124)
  den(168) = den(67)*den(124)
  den(169) = den(28)*den(121)
  den(170) = den(30)*den(121)
  den(171) = den(28)*den(124)
  den(172) = den(30)*den(124)
  den(173) = den(23)**2
  den(174) = den(62)*den(173)
  den(175) = den(23)*den(25)
  den(176) = den(62)*den(175)
  den(177) = den(25)**2
  den(178) = den(62)*den(177)
  den(179) = den(4)*den(173)
  den(180) = den(4)*den(175)
  den(181) = den(4)*den(177)
  den(182) = den(4)*den(65)
  den(183) = den(4)*den(67)
  den(184) = den(28)*den(62)
  den(185) = den(30)*den(62)
  den(186) = den(78)*den(121)
  den(187) = den(80)*den(121)
  den(188) = den(78)*den(124)
  den(189) = den(80)*den(124)
  den(190) = den(36)*den(121)
  den(191) = den(38)*den(121)
  den(192) = den(36)*den(124)
  den(193) = den(38)*den(124)
  den(194) = den(32)**2
  den(195) = den(62)*den(194)
  den(196) = den(32)*den(34)
  den(197) = den(62)*den(196)
  den(198) = den(34)**2
  den(199) = den(62)*den(198)
  den(200) = den(15)*den(78)
  den(201) = den(15)*den(80)
  den(202) = den(36)*den(62)
  den(203) = den(38)*den(62)
  den(204) = den(15)*den(194)
  den(205) = den(15)*den(196)
  den(206) = den(15)*den(198)
  den(207) = den(41)*den(87)
  den(208) = den(44)*den(91)
  den(209) = den(87)*den(133)
  den(210) = den(87)*den(135)
  den(211) = den(91)*den(196)
  den(212) = den(91)*den(198)
  den(213) = den(44)*den(133)
  den(214) = den(44)*den(135)
  den(215) = den(41)*den(196)
  den(216) = den(41)*den(198)
  den(217) = den(47)*den(95)
  den(218) = den(50)*den(99)
  den(219) = den(95)*den(175)
  den(220) = den(95)*den(177)
  den(221) = den(99)*den(154)
  den(222) = den(99)*den(156)
  den(223) = den(50)*den(175)
  den(224) = den(50)*den(177)
  den(225) = den(47)*den(154)
  den(226) = den(47)*den(156)
  den(227) = den(1)*den(6)
  den(229) = den(227)*den(228)
  den(230) = den(1)*den(17)
  den(232) = den(230)*den(231)
  den(233) = den(1)*den(25)
  den(235) = den(233)*den(234)
  den(236) = den(1)*den(34)
  den(238) = den(236)*den(237)
  den(240) = den(15)*den(239)
  den(242) = den(15)*den(241)
  den(244) = den(15)*den(243)
  den(246) = den(15)*den(245)
  den(248) = den(4)*den(247)
  den(250) = den(4)*den(249)
  den(252) = den(4)*den(251)
  den(254) = den(4)*den(253)
  den(255) = den(62)*den(239)
  den(256) = den(62)*den(241)
  den(257) = den(62)*den(247)
  den(258) = den(62)*den(249)
  den(259) = den(53)*den(243)
  den(260) = den(53)*den(245)
  den(261) = den(53)*den(251)
  den(262) = den(53)*den(253)
  den(263) = den(6)*den(34)
  den(265) = den(263)*den(264)
  den(266) = den(41)*den(241)
  den(267) = den(91)*den(241)
  den(269) = den(9)*den(268)
  den(271) = den(9)*den(270)
  den(272) = den(11)*den(268)
  den(273) = den(11)*den(270)
  den(274) = den(57)*den(268)
  den(275) = den(57)*den(270)
  den(276) = den(59)*den(268)
  den(277) = den(59)*den(270)
  den(278) = den(17)*den(25)
  den(279) = den(264)*den(278)
  den(280) = den(50)*den(249)
  den(281) = den(95)*den(249)
  den(282) = den(19)*den(268)
  den(283) = den(19)*den(270)
  den(284) = den(21)*den(268)
  den(285) = den(21)*den(270)
  den(286) = den(72)*den(268)
  den(287) = den(74)*den(268)
  den(288) = den(72)*den(270)
  den(289) = den(74)*den(270)
  den(290) = den(47)*den(245)
  den(291) = den(99)*den(245)
  den(292) = den(28)*den(268)
  den(293) = den(28)*den(270)
  den(294) = den(30)*den(268)
  den(295) = den(30)*den(270)
  den(296) = den(65)*den(268)
  den(297) = den(65)*den(270)
  den(298) = den(67)*den(268)
  den(299) = den(67)*den(270)
  den(300) = den(44)*den(253)
  den(301) = den(87)*den(253)
  den(302) = den(36)*den(268)
  den(303) = den(36)*den(270)
  den(304) = den(38)*den(268)
  den(305) = den(38)*den(270)
  den(306) = den(78)*den(268)
  den(307) = den(80)*den(268)
  den(308) = den(78)*den(270)
  den(309) = den(80)*den(270)
  den(310) = den(1)*den(2)
  den(311) = den(1)*den(13)
  den(312) = den(1)*den(23)
  den(313) = den(1)*den(32)
  den(314) = den(2)*den(32)
  den(315) = den(2)*den(34)
  den(316) = den(6)*den(32)
  den(317) = den(13)*den(23)
  den(318) = den(17)*den(23)
  den(319) = den(13)*den(25)
  den(320) = den(1)*den(2)*den(32)
  den(321) = den(1)*den(2)*den(34)
  den(322) = den(1)*den(6)*den(32)
  den(323) = den(1)*den(6)*den(34)
  den(324) = den(1)*den(13)*den(23)
  den(325) = den(1)*den(17)*den(23)
  den(326) = den(1)*den(13)*den(25)
  den(327) = den(1)*den(17)*den(25)
  den(328) = den(1)*den(314)
  den(329) = den(1)*den(315)
  den(330) = den(1)*den(316)
  den(331) = den(1)*den(263)
  den(332) = den(2)*den(313)
  den(333) = den(2)*den(236)
  den(334) = den(6)*den(313)
  den(335) = den(6)*den(236)
  den(336) = den(32)*den(310)
  den(337) = den(34)*den(310)
  den(338) = den(32)*den(227)
  den(339) = den(34)*den(227)
  den(340) = den(1)*den(317)
  den(341) = den(1)*den(318)
  den(342) = den(1)*den(319)
  den(343) = den(1)*den(278)
  den(344) = den(23)*den(311)
  den(345) = den(23)*den(230)
  den(346) = den(25)*den(311)
  den(347) = den(25)*den(230)
  den(348) = den(13)*den(312)
  den(349) = den(17)*den(312)
  den(350) = den(13)*den(233)
  den(351) = den(17)*den(233)
  den(352) = den(32)*den(229)
  den(353) = den(34)*den(229)
  den(354) = den(2)*den(238)
  den(355) = den(6)*den(238)
  den(356) = den(1)*den(265)
  den(357) = den(2)*den(252)
  den(358) = den(2)*den(254)
  den(359) = den(6)*den(252)
  den(360) = den(6)*den(254)
  den(361) = den(2)*den(261)
  den(362) = den(2)*den(262)
  den(363) = den(6)*den(261)
  den(364) = den(6)*den(262)
  den(365) = den(1)*den(269)
  den(366) = den(1)*den(271)
  den(367) = den(1)*den(272)
  den(368) = den(1)*den(273)
  den(369) = den(1)*den(274)
  den(370) = den(1)*den(275)
  den(371) = den(1)*den(276)
  den(372) = den(1)*den(277)
  den(373) = den(13)*den(235)
  den(374) = den(17)*den(235)
  den(375) = den(23)*den(232)
  den(376) = den(25)*den(232)
  den(377) = den(1)*den(279)
  den(378) = den(13)*den(244)
  den(379) = den(13)*den(246)
  den(380) = den(17)*den(244)
  den(381) = den(17)*den(246)
  den(382) = den(13)*den(259)
  den(383) = den(17)*den(259)
  den(384) = den(13)*den(260)
  den(385) = den(17)*den(260)
  den(386) = den(1)*den(282)
  den(387) = den(1)*den(283)
  den(388) = den(1)*den(284)
  den(389) = den(1)*den(285)
  den(390) = den(1)*den(286)
  den(391) = den(1)*den(287)
  den(392) = den(1)*den(288)
  den(393) = den(1)*den(289)
  den(394) = den(23)*den(248)
  den(395) = den(23)*den(250)
  den(396) = den(25)*den(248)
  den(397) = den(25)*den(250)
  den(398) = den(23)*den(257)
  den(399) = den(23)*den(258)
  den(400) = den(25)*den(257)
  den(401) = den(25)*den(258)
  den(402) = den(1)*den(292)
  den(403) = den(1)*den(293)
  den(404) = den(1)*den(294)
  den(405) = den(1)*den(295)
  den(406) = den(1)*den(296)
  den(407) = den(1)*den(297)
  den(408) = den(1)*den(298)
  den(409) = den(1)*den(299)
  den(410) = den(32)*den(240)
  den(411) = den(32)*den(242)
  den(412) = den(34)*den(240)
  den(413) = den(34)*den(242)
  den(414) = den(32)*den(255)
  den(415) = den(34)*den(255)
  den(416) = den(32)*den(256)
  den(417) = den(34)*den(256)
  den(418) = den(1)*den(302)
  den(419) = den(1)*den(303)
  den(420) = den(1)*den(304)
  den(421) = den(1)*den(305)
  den(422) = den(1)*den(306)
  den(423) = den(1)*den(307)
  den(424) = den(1)*den(308)
  den(425) = den(1)*den(309)
  den(426) = den(32)*den(266)
  den(427) = den(34)*den(266)
  den(428) = den(2)*den(300)
  den(429) = den(6)*den(300)
  den(430) = den(32)*den(267)
  den(431) = den(34)*den(267)
  den(432) = den(2)*den(301)
  den(433) = den(6)*den(301)
  den(434) = den(13)*den(290)
  den(435) = den(17)*den(290)
  den(436) = den(23)*den(280)
  den(437) = den(25)*den(280)
  den(438) = den(13)*den(291)
  den(439) = den(17)*den(291)
  den(440) = den(23)*den(281)
  den(441) = den(25)*den(281)

end subroutine denominators

#ifdef PRECISION_dp
! **********************************************************************
subroutine init_merging_tables(tot_num_hels, tot_num_merge_steps)
!-----------------------------------------------------------------------
! In the first event the merging tables are fully initialised
! **********************************************************************
  implicit none
  integer, intent(in) :: tot_num_hels, tot_num_merge_steps
  n_merge_steps = tot_num_merge_steps
  allocate(merge_tables(tot_num_hels,2,n_merge_steps))
  allocate(merge_mism(n_merge_steps+1))
  allocate(merge_hels(n_merge_steps))
  merge_tables_on = .true.
  merge_mism = 0_intkind2
  merge_tables = -1_intkind2
  merge_hels = -1_intkind2
end subroutine init_merging_tables

! **********************************************************************
subroutine update_merging_tables(tot_num_hels)
!-----------------------------------------------------------------------
! After the first evaluation the merging tables are adapted
! **********************************************************************
  implicit none
  integer, intent(in) :: tot_num_hels
  integer(intkind2), allocatable ::  merge_tables_tmp(:,:,:), merge_hels_tmp(:)

  if(merge_mism(1) == 0) then ! helicity configurations match in all merging steps
    if(allocated(merge_tables)) deallocate(merge_tables)
    if(allocated(merge_hels)) deallocate(merge_hels)
    if(allocated(merge_mism)) deallocate(merge_mism)
    allocate(merge_mism(1))
    allocate(merge_hels(1))
    allocate(merge_tables(1,1,1)) ! dummy allocation
    merge_mism = 0_intkind2
    merge_tables = -1_intkind2
    merge_hels = -1_intkind2
  else
    n_merge_mism = merge_mism(1)
    allocate(merge_tables_tmp(tot_num_hels,2,n_merge_mism))
    merge_tables_tmp(:,:,1:n_merge_mism) = merge_tables(:,:,1:n_merge_mism)
    if(allocated(merge_tables)) then
      deallocate(merge_tables)
      allocate(merge_tables(tot_num_hels,2,n_merge_mism))
    end if
    merge_tables = merge_tables_tmp
    if(allocated(merge_tables_tmp)) deallocate(merge_tables_tmp)
    allocate(merge_hels_tmp(n_merge_mism))
    merge_hels_tmp(1:n_merge_mism) = merge_hels(1:n_merge_mism)
    if(allocated(merge_hels)) then
      deallocate(merge_hels)
      allocate(merge_hels(n_merge_mism))
    end if
    merge_hels = merge_hels_tmp
    if(allocated(merge_hels_tmp)) deallocate(merge_hels_tmp)
  end if
  merge_tables_on = .true.
end subroutine update_merging_tables
#endif


!
!
!
! **********************************************************************
#ifdef PRECISION_dp
subroutine amp2(P_scatt, M02, M2ct, M2colint, qp_kinematics)
#else
subroutine amp2(P_scatt, M02, M2ct, M2colint, qp_kinematics)
  use ol_loop_storage_ppnnjj_ew_nenexuuuxux_4_/**/DREALKIND, only: ntry, nhel, Hel
#endif
! P_scatt(0:3,Npart) = incoming external momenta
! M2  = helicity-summed squared matrix element for nu_e anti-nu_e up up anti-up anti-up -> 0
! **********************************************************************
  use ol_parameters_decl_/**/REALKIND !, only: ci, parameters_status, ZERO, scalefactor, >masses<
  use ol_parameters_init_/**/REALKIND, only: ensure_mp_init
  use ol_kinematics_/**/REALKIND, only: init_kinematics
  use ol_momenta_decl_/**/DREALKIND, only: momenta_nan_check
  use ol_data_types_/**/REALKIND
  use ol_h_helicity_bookkeeping_/**/REALKIND, only: &
    & helbookkeeping_wf, helsync, flip_phase
  use ol_helicity_init, only: helbookkeeping_flip, helsync_flip
  use ol_hel_propagators_/**/REALKIND
  use ol_hel_wavefunctions_/**/REALKIND
  use ol_wavefunctions_/**/REALKIND, only: wf_V_Std
  use ol_hel_vertices_/**/REALKIND
  use ol_hel_contractions_/**/REALKIND
  use ol_external_ppnnjj_ew_nenexuuuxux_4, only: &
    & external_perm_ppnnjj_ew_nenexuuuxux_4, &
    & external_perm_inv_ppnnjj_ew_nenexuuuxux_4, &
    & extcomb_perm_ppnnjj_ew_nenexuuuxux_4, &
    & average_factor_ppnnjj_ew_nenexuuuxux_4, &
    & photonid_ppnnjj_ew_nenexuuuxux_4
  use ol_ew_renormalisation_/**/REALKIND, only: photon_factors
  use ol_external_ppnnjj_ew_nenexuuuxux_4, only: &
    & H, hel_not_initialised, hel_init, POLSEL
  use ol_colourmatrix_ppnnjj_ew_nenexuuuxux_4_/**/REALKIND, only: &
    & colmat_not_initialised, colourmatrix_init
  use ol_forced_parameters_ppnnjj_ew_nenexuuuxux_4_/**/REALKIND, only: &
    & check_forced_parameters
  use ol_heltables_OLR_ppnnjj_ew_nenexuuuxux_4
  use ol_kinematics_/**/REALKIND, only: LC2Std_Rep_cmplx
  use ol_h_counterterms_/**/REALKIND
  use ol_loop_parameters_decl_/**/REALKIND ! counterterms
  use ol_loop_parameters_decl_/**/DREALKIND, only: IR_is_on
  use ol_init, only: set_parameter, parameters_flush
#ifdef PRECISION_dp
  use ol_kinematics_/**/QREALKIND, only: conv_mom_scatt2in_qp=>conv_mom_scatt2in, &
                                         internal_momenta_qp=>internal_momenta
  use ol_momenta_decl_/**/DREALKIND, only: L
  use ol_momenta_decl_/**/QREALKIND, only: L_qp=>L
#endif
  implicit none

  real(DREALKIND), intent(in)  :: P_scatt(0:3,6)
  real(REALKIND),  intent(out) :: M02, M2ct, M2colint(22)
  logical, intent(in) :: qp_kinematics

  integer           :: shift, k, r, m, n, i
  real(REALKIND)    :: P(0:3,6)
#ifdef PRECISION_dp
  real(QREALKIND)    :: P_qp(0:3,6)
#endif
  integer           :: extmasses2(6)
  real(REALKIND)    :: M2add, M2add_ct, M2add_colint(22)
  complex(REALKIND) :: M1(2), M2(2)
  real(REALKIND)    :: P_scatt_intern(0:3,6)
  real(REALKIND), save :: scalebackfactor, old_scalefactor = 0
  real(REALKIND)       :: bornphotonfactor
  integer(intkind1) :: nsync
  type(Hpolcont),   save :: M1helarray(2,64)
  type(Hpolcont) :: M1helarray_ct(2,64)
  integer, allocatable :: extcombs_permuted(:)
  integer              :: extcombs(22), nextcombs
#if 6 > 3
  integer :: ind_cc_comb(9)
#endif
  type(Hpolcont) :: A(64,224)

  !Aj are not used at the moment
  !complex(REALKIND) :: Aj(224)

  complex(REALKIND) :: omega(2) ! phases for helicity correlations

  call set_parameter("ew_renorm", 1)
  call parameters_flush()
  call ensure_mp_init()

  if (colmat_not_initialised) call colourmatrix_init()

  if (fac_status_loop1 /= parameters_status .or. fac_status_loop2 /= loop_parameters_status) then
    ! Note: if fac_init would only be called when parameters changed which are relevant for the factors,
    ! a different 'status' would have to be used, because forced_parameters should be called after every parameter change.
    call check_forced_parameters()
    call fac_init_loop()
  end if

  if (momenta_nan_check(P_scatt) /= 0) then
    M02 = 0
    return
  end if

  extmasses2 = [ 0, 0, 0, 0, 0, 0 ]
  ! Convert 2 -> n-2 PS-point to n -> 0 (so that P(1) + ... + P(n) = 0) and compute
  ! internal-propagator momenta in light-cone representation
  call init_kinematics(P_scatt, extmasses2, P, &
     external_perm_inv_ppnnjj_ew_nenexuuuxux_4, 6, qp_kinematics)

  ! denominators
  call denominators()

   if (heltables_not_init) call init_heltables()

  ! external WFs
  ! Here the external wavefunctions are initialiased
  call pol_wf_Q(P(:,1), rZERO, H1, ex1, POLSEL(1),1)
  call pol_wf_A(P(:,2), rZERO, H2, ex2, POLSEL(2),2)
  call pol_wf_Q(P(:,3), rZERO, H3, ex3, POLSEL(3),3)
  call pol_wf_Q(P(:,4), rZERO, H4, ex4, POLSEL(4),4)
  call pol_wf_A(P(:,5), rZERO, H5, ex5, POLSEL(5),5)
  call pol_wf_A(P(:,6), rZERO, H6, ex6, POLSEL(6),6)



  ! internal WFs
  ! e.g. call vert_VQ_A(ntry, ex3, ex1, wf1, n1, t1) ...
  call vert_QA_Z(gZn,ntry, ex1(:), ex2(:), wf4(:,1), n3(:,1), t3x4(:,:,1))
  call vert_QA_V(ntry, ex3(:), ex5(:), wf4(:,2), n3(:,2), t3x4(:,:,2))
  call vert_ZQ_A(gZu,ntry, wf4(:,1), ex4(:), wf8(:,1), n3(:,3), t3x8(:,:,1))
  call vert_AV_Q(ntry, ex6(:), wf4(:,2), wf8(:,2), n3(:,4), t3x8(:,:,2))
  call prop_Q_A(ntry, wf8(:,1), 11, ZERO, 0_intkind1, wf8(:,3), n2(1))
  call vert_QA_Z(gZu,ntry, ex3(:), ex5(:), wf4(:,3), n3(:,5), t3x4(:,:,3))
  call vert_AZ_Q(gZu,ntry, ex6(:), wf4(:,3), wf8(:,4), n3(:,6), t3x8(:,:,3))
  call vert_VQ_A(ntry, wf4(:,2), ex4(:), wf8(:,5), n3(:,7), t3x8(:,:,4))
  call vert_AZ_Q(gZu,ntry, ex6(:), wf4(:,1), wf8(:,6), n3(:,8), t3x8(:,:,5))
  call prop_Q_A(ntry, wf8(:,5), 28, ZERO, 0_intkind1, wf8(:,7), n2(2))
  call vert_ZQ_A(gZu,ntry, wf4(:,3), ex4(:), wf8(:,8), n3(:,9), t3x8(:,:,6))
  call prop_Q_A(ntry, wf8(:,8), 28, ZERO, 0_intkind1, wf8(:,9), n2(3))
  call vert_QA_V(ntry, ex4(:), ex5(:), wf4(:,4), n3(:,10), t3x4(:,:,4))
  call vert_ZQ_A(gZu,ntry, wf4(:,1), ex3(:), wf8(:,10), n3(:,11), t3x8(:,:,7))
  call vert_AV_Q(ntry, ex6(:), wf4(:,4), wf8(:,11), n3(:,12), t3x8(:,:,8))
  call prop_Q_A(ntry, wf8(:,10), 7, ZERO, 0_intkind1, wf8(:,12), n2(4))
  call vert_QA_Z(gZu,ntry, ex4(:), ex5(:), wf4(:,5), n3(:,13), t3x4(:,:,5))
  call vert_AZ_Q(gZu,ntry, ex6(:), wf4(:,5), wf8(:,13), n3(:,14), t3x8(:,:,9))
  call vert_VQ_A(ntry, wf4(:,4), ex3(:), wf8(:,14), n3(:,15), t3x8(:,:,10))
  call prop_Q_A(ntry, wf8(:,14), 28, ZERO, 0_intkind1, wf8(:,15), n2(5))
  call vert_ZQ_A(gZu,ntry, wf4(:,5), ex3(:), wf8(:,16), n3(:,16), t3x8(:,:,11))
  call prop_Q_A(ntry, wf8(:,16), 28, ZERO, 0_intkind1, wf8(:,17), n2(6))
  call vert_QA_V(ntry, ex3(:), ex6(:), wf4(:,6), n3(:,17), t3x4(:,:,6))
  call vert_AV_Q(ntry, ex5(:), wf4(:,6), wf8(:,18), n3(:,18), t3x8(:,:,12))
  call vert_QA_Z(gZu,ntry, ex3(:), ex6(:), wf4(:,7), n3(:,19), t3x4(:,:,7))
  call vert_AZ_Q(gZu,ntry, ex5(:), wf4(:,7), wf8(:,19), n3(:,20), t3x8(:,:,13))
  call vert_VQ_A(ntry, wf4(:,6), ex4(:), wf8(:,20), n3(:,21), t3x8(:,:,14))
  call vert_AZ_Q(gZu,ntry, ex5(:), wf4(:,1), wf8(:,21), n3(:,22), t3x8(:,:,15))
  call prop_Q_A(ntry, wf8(:,20), 44, ZERO, 0_intkind1, wf8(:,22), n2(7))
  call vert_ZQ_A(gZu,ntry, wf4(:,7), ex4(:), wf8(:,23), n3(:,23), t3x8(:,:,16))
  call prop_Q_A(ntry, wf8(:,23), 44, ZERO, 0_intkind1, wf8(:,24), n2(8))
  call vert_QA_V(ntry, ex4(:), ex6(:), wf4(:,8), n3(:,24), t3x4(:,:,8))
  call vert_AV_Q(ntry, ex5(:), wf4(:,8), wf8(:,25), n3(:,25), t3x8(:,:,17))
  call vert_QA_Z(gZu,ntry, ex4(:), ex6(:), wf4(:,9), n3(:,26), t3x4(:,:,9))
  call vert_AZ_Q(gZu,ntry, ex5(:), wf4(:,9), wf8(:,26), n3(:,27), t3x8(:,:,18))
  call vert_VQ_A(ntry, wf4(:,8), ex3(:), wf8(:,27), n3(:,28), t3x8(:,:,19))
  call prop_Q_A(ntry, wf8(:,27), 44, ZERO, 0_intkind1, wf8(:,28), n2(9))
  call vert_ZQ_A(gZu,ntry, wf4(:,9), ex3(:), wf8(:,29), n3(:,29), t3x8(:,:,20))
  call prop_Q_A(ntry, wf8(:,29), 44, ZERO, 0_intkind1, wf8(:,30), n2(10))
  call vert_ZQ_A(gZn,ntry, wf4(:,3), ex1(:), wf8(:,31), n3(:,30), t3x8(:,:,21))
  call vert_AZ_Q(gZn,ntry, ex2(:), wf4(:,9), wf8(:,32), n3(:,31), t3x8(:,:,22))
  call prop_Q_A(ntry, wf8(:,31), 21, ZERO, 0_intkind1, wf8(:,33), n2(11))
  call vert_ZQ_A(gZn,ntry, wf4(:,9), ex1(:), wf8(:,34), n3(:,32), t3x8(:,:,23))
  call vert_AZ_Q(gZn,ntry, ex2(:), wf4(:,3), wf8(:,35), n3(:,33), t3x8(:,:,24))
  call prop_Q_A(ntry, wf8(:,34), 41, ZERO, 0_intkind1, wf8(:,36), n2(12))
  call vert_ZQ_A(gZn,ntry, wf4(:,7), ex1(:), wf8(:,37), n3(:,34), t3x8(:,:,25))
  call vert_AZ_Q(gZn,ntry, ex2(:), wf4(:,5), wf8(:,38), n3(:,35), t3x8(:,:,26))
  call prop_Q_A(ntry, wf8(:,37), 37, ZERO, 0_intkind1, wf8(:,39), n2(13))
  call vert_ZQ_A(gZn,ntry, wf4(:,5), ex1(:), wf8(:,40), n3(:,36), t3x8(:,:,27))
  call vert_AZ_Q(gZn,ntry, ex2(:), wf4(:,7), wf8(:,41), n3(:,37), t3x8(:,:,28))
  call prop_Q_A(ntry, wf8(:,40), 25, ZERO, 0_intkind1, wf8(:,42), n2(14))
  call counter_AV_Q_LR(EWctAuu,ntry, ex6(:), wf4(:,2), wf8(:,43), n3(:,38), t3x8(:,:,29))
  call counter_AZ_Q(EWctVuu,ntry, ex6(:), wf4(:,3), wf8(:,44), n3(:,39), t3x8(:,:,30))
  call counter_AZ_Q(EWctVuu,ntry, ex6(:), wf4(:,1), wf8(:,45), n3(:,40), t3x8(:,:,31))
  call counter_AV_Q_LR(EWctAuu,ntry, ex6(:), wf4(:,4), wf8(:,46), n3(:,41), t3x8(:,:,32))
  call counter_AZ_Q(EWctVuu,ntry, ex6(:), wf4(:,5), wf8(:,47), n3(:,42), t3x8(:,:,33))
  call counter_AV_Q_LR(EWctAuu,ntry, ex5(:), wf4(:,6), wf8(:,48), n3(:,43), t3x8(:,:,34))
  call counter_AZ_Q(EWctVuu,ntry, ex5(:), wf4(:,7), wf8(:,49), n3(:,44), t3x8(:,:,35))
  call counter_AZ_Q(EWctVuu,ntry, ex5(:), wf4(:,1), wf8(:,50), n3(:,45), t3x8(:,:,36))
  call counter_AV_Q_LR(EWctAuu,ntry, ex5(:), wf4(:,8), wf8(:,51), n3(:,46), t3x8(:,:,37))
  call counter_AZ_Q(EWctVuu,ntry, ex5(:), wf4(:,9), wf8(:,52), n3(:,47), t3x8(:,:,38))
  call counter_VQ_A_LR(EWctAuu,ntry, wf4(:,2), ex4(:), wf8(:,53), n3(:,48), t3x8(:,:,39))
  call prop_A_Q(ntry, wf8(:,6), 35, ZERO, 0_intkind1, wf8(:,54), n2(15))
  call counter_ZQ_A(EWctVuu,ntry, wf4(:,3), ex4(:), wf8(:,55), n3(:,49), t3x8(:,:,40))
  call counter_ZQ_A(EWctVuu,ntry, wf4(:,1), ex4(:), wf8(:,56), n3(:,50), t3x8(:,:,41))
  call prop_A_Q(ntry, wf8(:,2), 52, ZERO, 0_intkind1, wf8(:,57), n2(16))
  call prop_A_Q(ntry, wf8(:,4), 52, ZERO, 0_intkind1, wf8(:,58), n2(17))
  call counter_VQ_A_LR(EWctAuu,ntry, wf4(:,6), ex4(:), wf8(:,59), n3(:,51), t3x8(:,:,42))
  call prop_A_Q(ntry, wf8(:,21), 19, ZERO, 0_intkind1, wf8(:,60), n2(18))
  call counter_ZQ_A(EWctVuu,ntry, wf4(:,7), ex4(:), wf8(:,61), n3(:,52), t3x8(:,:,43))
  call prop_A_Q(ntry, wf8(:,18), 52, ZERO, 0_intkind1, wf8(:,62), n2(19))
  call prop_A_Q(ntry, wf8(:,19), 52, ZERO, 0_intkind1, wf8(:,63), n2(20))
  call counter_QA_V_LR(EWctAuu,ntry, ex4(:), ex6(:), wf4(:,10), n3(:,53), t3x4(:,:,10))
  call vert_AV_Q(ntry, ex5(:), wf4(:,10), wf8(:,64), n3(:,54), t3x8(:,:,44))
  call counter_QA_Z(EWctVuu,ntry, ex4(:), ex6(:), wf4(:,11), n3(:,55), t3x4(:,:,11))
  call vert_AZ_Q(gZu,ntry, ex5(:), wf4(:,11), wf8(:,65), n3(:,56), t3x8(:,:,45))
  call vert_VQ_A(ntry, wf4(:,10), ex3(:), wf8(:,66), n3(:,57), t3x8(:,:,46))
  call prop_Q_A(ntry, wf8(:,66), 44, ZERO, 0_intkind1, wf8(:,67), n2(21))
  call vert_ZQ_A(gZu,ntry, wf4(:,11), ex3(:), wf8(:,68), n3(:,58), t3x8(:,:,47))
  call prop_Q_A(ntry, wf8(:,68), 44, ZERO, 0_intkind1, wf8(:,69), n2(22))
  call counter_QA_V_LR(EWctAuu,ntry, ex4(:), ex5(:), wf4(:,12), n3(:,59), t3x4(:,:,12))
  call vert_AV_Q(ntry, ex6(:), wf4(:,12), wf8(:,70), n3(:,60), t3x8(:,:,48))
  call counter_QA_Z(EWctVuu,ntry, ex4(:), ex5(:), wf4(:,13), n3(:,61), t3x4(:,:,13))
  call vert_AZ_Q(gZu,ntry, ex6(:), wf4(:,13), wf8(:,71), n3(:,62), t3x8(:,:,49))
  call vert_VQ_A(ntry, wf4(:,12), ex3(:), wf8(:,72), n3(:,63), t3x8(:,:,50))
  call prop_Q_A(ntry, wf8(:,72), 28, ZERO, 0_intkind1, wf8(:,73), n2(23))
  call vert_ZQ_A(gZu,ntry, wf4(:,13), ex3(:), wf8(:,74), n3(:,64), t3x8(:,:,51))
  call prop_Q_A(ntry, wf8(:,74), 28, ZERO, 0_intkind1, wf8(:,75), n2(24))
  call counter_VQ_A_LR(EWctAuu,ntry, wf4(:,4), ex3(:), wf8(:,76), n3(:,65), t3x8(:,:,52))
  call counter_ZQ_A(EWctVuu,ntry, wf4(:,5), ex3(:), wf8(:,77), n3(:,66), t3x8(:,:,53))
  call counter_ZQ_A(EWctVuu,ntry, wf4(:,1), ex3(:), wf8(:,78), n3(:,67), t3x8(:,:,54))
  call prop_A_Q(ntry, wf8(:,11), 56, ZERO, 0_intkind1, wf8(:,79), n2(25))
  call prop_A_Q(ntry, wf8(:,13), 56, ZERO, 0_intkind1, wf8(:,80), n2(26))
  call counter_VQ_A_LR(EWctAuu,ntry, wf4(:,8), ex3(:), wf8(:,81), n3(:,68), t3x8(:,:,55))
  call counter_ZQ_A(EWctVuu,ntry, wf4(:,9), ex3(:), wf8(:,82), n3(:,69), t3x8(:,:,56))
  call prop_A_Q(ntry, wf8(:,25), 56, ZERO, 0_intkind1, wf8(:,83), n2(27))
  call prop_A_Q(ntry, wf8(:,26), 56, ZERO, 0_intkind1, wf8(:,84), n2(28))
  call counter_QA_V_LR(EWctAuu,ntry, ex3(:), ex6(:), wf4(:,14), n3(:,70), t3x4(:,:,14))
  call vert_AV_Q(ntry, ex5(:), wf4(:,14), wf8(:,85), n3(:,71), t3x8(:,:,57))
  call counter_QA_Z(EWctVuu,ntry, ex3(:), ex6(:), wf4(:,15), n3(:,72), t3x4(:,:,15))
  call vert_AZ_Q(gZu,ntry, ex5(:), wf4(:,15), wf8(:,86), n3(:,73), t3x8(:,:,58))
  call vert_VQ_A(ntry, wf4(:,14), ex4(:), wf8(:,87), n3(:,74), t3x8(:,:,59))
  call prop_Q_A(ntry, wf8(:,87), 44, ZERO, 0_intkind1, wf8(:,88), n2(29))
  call vert_ZQ_A(gZu,ntry, wf4(:,15), ex4(:), wf8(:,89), n3(:,75), t3x8(:,:,60))
  call prop_Q_A(ntry, wf8(:,89), 44, ZERO, 0_intkind1, wf8(:,90), n2(30))
  call counter_QA_V_LR(EWctAuu,ntry, ex3(:), ex5(:), wf4(:,16), n3(:,76), t3x4(:,:,16))
  call vert_AV_Q(ntry, ex6(:), wf4(:,16), wf8(:,91), n3(:,77), t3x8(:,:,61))
  call counter_QA_Z(EWctVuu,ntry, ex3(:), ex5(:), wf4(:,17), n3(:,78), t3x4(:,:,17))
  call vert_AZ_Q(gZu,ntry, ex6(:), wf4(:,17), wf8(:,92), n3(:,79), t3x8(:,:,62))
  call vert_VQ_A(ntry, wf4(:,16), ex4(:), wf8(:,93), n3(:,80), t3x8(:,:,63))
  call prop_Q_A(ntry, wf8(:,93), 28, ZERO, 0_intkind1, wf8(:,94), n2(31))
  call vert_ZQ_A(gZu,ntry, wf4(:,17), ex4(:), wf8(:,95), n3(:,81), t3x8(:,:,64))
  call prop_Q_A(ntry, wf8(:,95), 28, ZERO, 0_intkind1, wf8(:,96), n2(32))
  call vert_AZ_Q(gZn,ntry, ex2(:), wf4(:,11), wf8(:,97), n3(:,82), t3x8(:,:,65))
  call vert_ZQ_A(gZn,ntry, wf4(:,11), ex1(:), wf8(:,98), n3(:,83), t3x8(:,:,66))
  call prop_Q_A(ntry, wf8(:,98), 41, ZERO, 0_intkind1, wf8(:,99), n2(33))
  call vert_AZ_Q(gZn,ntry, ex2(:), wf4(:,13), wf8(:,100), n3(:,84), t3x8(:,:,67))
  call vert_ZQ_A(gZn,ntry, wf4(:,13), ex1(:), wf8(:,101), n3(:,85), t3x8(:,:,68))
  call prop_Q_A(ntry, wf8(:,101), 25, ZERO, 0_intkind1, wf8(:,102), n2(34))
  call vert_AZ_Q(gZn,ntry, ex2(:), wf4(:,15), wf8(:,103), n3(:,86), t3x8(:,:,69))
  call vert_ZQ_A(gZn,ntry, wf4(:,15), ex1(:), wf8(:,104), n3(:,87), t3x8(:,:,70))
  call prop_Q_A(ntry, wf8(:,104), 37, ZERO, 0_intkind1, wf8(:,105), n2(35))
  call vert_AZ_Q(gZn,ntry, ex2(:), wf4(:,17), wf8(:,106), n3(:,88), t3x8(:,:,71))
  call vert_ZQ_A(gZn,ntry, wf4(:,17), ex1(:), wf8(:,107), n3(:,89), t3x8(:,:,72))
  call prop_Q_A(ntry, wf8(:,107), 21, ZERO, 0_intkind1, wf8(:,108), n2(36))
  call counter_AZ_Q(EWctAnn,ntry, ex2(:), wf4(:,8), wf8(:,109), n3(:,90), t3x8(:,:,73))
  call counter_AZ_Q(EWctVnn,ntry, ex2(:), wf4(:,9), wf8(:,110), n3(:,91), t3x8(:,:,74))
  call counter_AZ_Q(EWctAnn,ntry, ex2(:), wf4(:,2), wf8(:,111), n3(:,92), t3x8(:,:,75))
  call counter_AZ_Q(EWctVnn,ntry, ex2(:), wf4(:,3), wf8(:,112), n3(:,93), t3x8(:,:,76))
  call counter_AZ_Q(EWctAnn,ntry, ex2(:), wf4(:,4), wf8(:,113), n3(:,94), t3x8(:,:,77))
  call counter_AZ_Q(EWctVnn,ntry, ex2(:), wf4(:,5), wf8(:,114), n3(:,95), t3x8(:,:,78))
  call counter_AZ_Q(EWctAnn,ntry, ex2(:), wf4(:,6), wf8(:,115), n3(:,96), t3x8(:,:,79))
  call counter_AZ_Q(EWctVnn,ntry, ex2(:), wf4(:,7), wf8(:,116), n3(:,97), t3x8(:,:,80))
  call counter_ZQ_A(EWctAnn,ntry, wf4(:,2), ex1(:), wf8(:,117), n3(:,98), t3x8(:,:,81))
  call prop_A_Q(ntry, wf8(:,32), 42, ZERO, 0_intkind1, wf8(:,118), n2(37))
  call counter_ZQ_A(EWctVnn,ntry, wf4(:,3), ex1(:), wf8(:,119), n3(:,99), t3x8(:,:,82))
  call counter_ZQ_A(EWctAnn,ntry, wf4(:,8), ex1(:), wf8(:,120), n3(:,100), t3x8(:,:,83))
  call prop_A_Q(ntry, wf8(:,35), 22, ZERO, 0_intkind1, wf8(:,121), n2(38))
  call counter_ZQ_A(EWctVnn,ntry, wf4(:,9), ex1(:), wf8(:,122), n3(:,101), t3x8(:,:,84))
  call counter_ZQ_A(EWctAnn,ntry, wf4(:,6), ex1(:), wf8(:,123), n3(:,102), t3x8(:,:,85))
  call prop_A_Q(ntry, wf8(:,38), 26, ZERO, 0_intkind1, wf8(:,124), n2(39))
  call counter_ZQ_A(EWctVnn,ntry, wf4(:,7), ex1(:), wf8(:,125), n3(:,103), t3x8(:,:,86))
  call counter_ZQ_A(EWctAnn,ntry, wf4(:,4), ex1(:), wf8(:,126), n3(:,104), t3x8(:,:,87))
  call prop_A_Q(ntry, wf8(:,41), 38, ZERO, 0_intkind1, wf8(:,127), n2(40))
  call counter_ZQ_A(EWctVnn,ntry, wf4(:,5), ex1(:), wf8(:,128), n3(:,105), t3x8(:,:,88))
  call counter_QA_Z(EWctAnn,ntry, ex1(:), ex2(:), wf4(:,18), n3(:,106), t3x4(:,:,18))
  call vert_VQ_A(ntry, wf4(:,18), ex4(:), wf8(:,129), n3(:,107), t3x8(:,:,89))
  call prop_Q_A(ntry, wf8(:,129), 11, ZERO, 0_intkind1, wf8(:,130), n2(41))
  call counter_QA_Z(EWctVnn,ntry, ex1(:), ex2(:), wf4(:,19), n3(:,108), t3x4(:,:,19))
  call vert_ZQ_A(gZu,ntry, wf4(:,19), ex4(:), wf8(:,131), n3(:,109), t3x8(:,:,90))
  call prop_Q_A(ntry, wf8(:,131), 11, ZERO, 0_intkind1, wf8(:,132), n2(42))
  call vert_AV_Q(ntry, ex6(:), wf4(:,18), wf8(:,133), n3(:,110), t3x8(:,:,91))
  call vert_AZ_Q(gZu,ntry, ex6(:), wf4(:,19), wf8(:,134), n3(:,111), t3x8(:,:,92))
  call vert_VQ_A(ntry, wf4(:,18), ex3(:), wf8(:,135), n3(:,112), t3x8(:,:,93))
  call prop_Q_A(ntry, wf8(:,135), 7, ZERO, 0_intkind1, wf8(:,136), n2(43))
  call vert_ZQ_A(gZu,ntry, wf4(:,19), ex3(:), wf8(:,137), n3(:,113), t3x8(:,:,94))
  call prop_Q_A(ntry, wf8(:,137), 7, ZERO, 0_intkind1, wf8(:,138), n2(44))
  call vert_AV_Q(ntry, ex5(:), wf4(:,18), wf8(:,139), n3(:,114), t3x8(:,:,95))
  call vert_AZ_Q(gZu,ntry, ex5(:), wf4(:,19), wf8(:,140), n3(:,115), t3x8(:,:,96))
  call counter_V_V(EWctAZ,ntry, wf4(:,1), 3, wf4(:,20), n2(45))
  call vert_VQ_A(ntry, wf4(:,20), ex4(:), wf8(:,141), n3(:,116), t3x8(:,:,97))
  call counter_V_V(EWctZZ,ntry, wf4(:,1), 3, wf4(:,21), n2(46))
  call vert_ZQ_A(gZu,ntry, wf4(:,21), ex4(:), wf8(:,142), n3(:,117), t3x8(:,:,98))
  call vert_AV_Q(ntry, ex6(:), wf4(:,20), wf8(:,143), n3(:,118), t3x8(:,:,99))
  call vert_AZ_Q(gZu,ntry, ex6(:), wf4(:,21), wf8(:,144), n3(:,119), t3x8(:,:,100))
  call counter_V_V(EWctAA,ntry, wf4(:,2), 20, wf4(:,22), n2(47))
  call vert_VQ_A(ntry, wf4(:,22), ex4(:), wf8(:,145), n3(:,120), t3x8(:,:,101))
  call counter_V_V(EWctAZ,ntry, wf4(:,2), 20, wf4(:,23), n2(48))
  call vert_ZQ_A(gZu,ntry, wf4(:,23), ex4(:), wf8(:,146), n3(:,121), t3x8(:,:,102))
  call counter_V_V(EWctAZ,ntry, wf4(:,3), 20, wf4(:,24), n2(49))
  call vert_VQ_A(ntry, wf4(:,24), ex4(:), wf8(:,147), n3(:,122), t3x8(:,:,103))
  call counter_V_V(EWctZZ,ntry, wf4(:,3), 20, wf4(:,25), n2(50))
  call vert_ZQ_A(gZu,ntry, wf4(:,25), ex4(:), wf8(:,148), n3(:,123), t3x8(:,:,104))
  call vert_AV_Q(ntry, ex6(:), wf4(:,22), wf8(:,149), n3(:,124), t3x8(:,:,105))
  call vert_AZ_Q(gZu,ntry, ex6(:), wf4(:,23), wf8(:,150), n3(:,125), t3x8(:,:,106))
  call vert_AV_Q(ntry, ex6(:), wf4(:,24), wf8(:,151), n3(:,126), t3x8(:,:,107))
  call vert_AZ_Q(gZu,ntry, ex6(:), wf4(:,25), wf8(:,152), n3(:,127), t3x8(:,:,108))
  call counter_Q_A_LR(EWctuu,ntry, wf8(:,3), 11, wf8(:,153), n2(51))
  call counter_Q_A_LR(EWctuu,ntry, wf8(:,7), 28, wf8(:,154), n2(52))
  call counter_Q_A_LR(EWctuu,ntry, wf8(:,9), 28, wf8(:,155), n2(53))
  call vert_VQ_A(ntry, wf4(:,20), ex3(:), wf8(:,156), n3(:,128), t3x8(:,:,109))
  call vert_ZQ_A(gZu,ntry, wf4(:,21), ex3(:), wf8(:,157), n3(:,129), t3x8(:,:,110))
  call counter_V_V(EWctAA,ntry, wf4(:,4), 24, wf4(:,26), n2(54))
  call vert_VQ_A(ntry, wf4(:,26), ex3(:), wf8(:,158), n3(:,130), t3x8(:,:,111))
  call counter_V_V(EWctAZ,ntry, wf4(:,5), 24, wf4(:,27), n2(55))
  call vert_VQ_A(ntry, wf4(:,27), ex3(:), wf8(:,159), n3(:,131), t3x8(:,:,112))
  call counter_V_V(EWctAZ,ntry, wf4(:,4), 24, wf4(:,28), n2(56))
  call vert_ZQ_A(gZu,ntry, wf4(:,28), ex3(:), wf8(:,160), n3(:,132), t3x8(:,:,113))
  call counter_V_V(EWctZZ,ntry, wf4(:,5), 24, wf4(:,29), n2(57))
  call vert_ZQ_A(gZu,ntry, wf4(:,29), ex3(:), wf8(:,161), n3(:,133), t3x8(:,:,114))
  call counter_Q_A_LR(EWctuu,ntry, wf8(:,12), 7, wf8(:,162), n2(58))
  call counter_Q_A_LR(EWctuu,ntry, wf8(:,15), 28, wf8(:,163), n2(59))
  call counter_Q_A_LR(EWctuu,ntry, wf8(:,17), 28, wf8(:,164), n2(60))
  call vert_AV_Q(ntry, ex6(:), wf4(:,26), wf8(:,165), n3(:,134), t3x8(:,:,115))
  call vert_AZ_Q(gZu,ntry, ex6(:), wf4(:,28), wf8(:,166), n3(:,135), t3x8(:,:,116))
  call vert_AV_Q(ntry, ex6(:), wf4(:,27), wf8(:,167), n3(:,136), t3x8(:,:,117))
  call vert_AZ_Q(gZu,ntry, ex6(:), wf4(:,29), wf8(:,168), n3(:,137), t3x8(:,:,118))
  call vert_AV_Q(ntry, ex5(:), wf4(:,20), wf8(:,169), n3(:,138), t3x8(:,:,119))
  call vert_AZ_Q(gZu,ntry, ex5(:), wf4(:,21), wf8(:,170), n3(:,139), t3x8(:,:,120))
  call counter_V_V(EWctAA,ntry, wf4(:,6), 36, wf4(:,30), n2(61))
  call vert_VQ_A(ntry, wf4(:,30), ex4(:), wf8(:,171), n3(:,140), t3x8(:,:,121))
  call counter_V_V(EWctAZ,ntry, wf4(:,6), 36, wf4(:,31), n2(62))
  call vert_ZQ_A(gZu,ntry, wf4(:,31), ex4(:), wf8(:,172), n3(:,141), t3x8(:,:,122))
  call counter_V_V(EWctAZ,ntry, wf4(:,7), 36, wf4(:,32), n2(63))
  call vert_VQ_A(ntry, wf4(:,32), ex4(:), wf8(:,173), n3(:,142), t3x8(:,:,123))
  call counter_V_V(EWctZZ,ntry, wf4(:,7), 36, wf4(:,33), n2(64))
  call vert_ZQ_A(gZu,ntry, wf4(:,33), ex4(:), wf8(:,174), n3(:,143), t3x8(:,:,124))
  call vert_AV_Q(ntry, ex5(:), wf4(:,30), wf8(:,175), n3(:,144), t3x8(:,:,125))
  call vert_AZ_Q(gZu,ntry, ex5(:), wf4(:,31), wf8(:,176), n3(:,145), t3x8(:,:,126))
  call vert_AV_Q(ntry, ex5(:), wf4(:,32), wf8(:,177), n3(:,146), t3x8(:,:,127))
  call vert_AZ_Q(gZu,ntry, ex5(:), wf4(:,33), wf8(:,178), n3(:,147), t3x8(:,:,128))
  call counter_Q_A_LR(EWctuu,ntry, wf8(:,22), 44, wf8(:,179), n2(65))
  call counter_Q_A_LR(EWctuu,ntry, wf8(:,24), 44, wf8(:,180), n2(66))
  call counter_V_V(EWctAA,ntry, wf4(:,8), 40, wf4(:,34), n2(67))
  call vert_VQ_A(ntry, wf4(:,34), ex3(:), wf8(:,181), n3(:,148), t3x8(:,:,129))
  call counter_V_V(EWctAZ,ntry, wf4(:,9), 40, wf4(:,35), n2(68))
  call vert_VQ_A(ntry, wf4(:,35), ex3(:), wf8(:,182), n3(:,149), t3x8(:,:,130))
  call counter_V_V(EWctAZ,ntry, wf4(:,8), 40, wf4(:,36), n2(69))
  call vert_ZQ_A(gZu,ntry, wf4(:,36), ex3(:), wf8(:,183), n3(:,150), t3x8(:,:,131))
  call counter_V_V(EWctZZ,ntry, wf4(:,9), 40, wf4(:,37), n2(70))
  call vert_ZQ_A(gZu,ntry, wf4(:,37), ex3(:), wf8(:,184), n3(:,151), t3x8(:,:,132))
  call counter_Q_A_LR(EWctuu,ntry, wf8(:,28), 44, wf8(:,185), n2(71))
  call counter_Q_A_LR(EWctuu,ntry, wf8(:,30), 44, wf8(:,186), n2(72))
  call vert_AV_Q(ntry, ex5(:), wf4(:,34), wf8(:,187), n3(:,152), t3x8(:,:,133))
  call vert_AZ_Q(gZu,ntry, ex5(:), wf4(:,36), wf8(:,188), n3(:,153), t3x8(:,:,134))
  call vert_AV_Q(ntry, ex5(:), wf4(:,35), wf8(:,189), n3(:,154), t3x8(:,:,135))
  call vert_AZ_Q(gZu,ntry, ex5(:), wf4(:,37), wf8(:,190), n3(:,155), t3x8(:,:,136))
  call counter_Q_A_LR(EWctnn,ntry, wf8(:,33), 21, wf8(:,191), n2(73))
  call counter_Q_A_LR(EWctnn,ntry, wf8(:,36), 41, wf8(:,192), n2(74))
  call vert_ZQ_A(gZn,ntry, wf4(:,23), ex1(:), wf8(:,193), n3(:,156), t3x8(:,:,137))
  call vert_ZQ_A(gZn,ntry, wf4(:,25), ex1(:), wf8(:,194), n3(:,157), t3x8(:,:,138))
  call vert_ZQ_A(gZn,ntry, wf4(:,36), ex1(:), wf8(:,195), n3(:,158), t3x8(:,:,139))
  call vert_ZQ_A(gZn,ntry, wf4(:,37), ex1(:), wf8(:,196), n3(:,159), t3x8(:,:,140))
  call vert_AZ_Q(gZn,ntry, ex2(:), wf4(:,23), wf8(:,197), n3(:,160), t3x8(:,:,141))
  call vert_AZ_Q(gZn,ntry, ex2(:), wf4(:,25), wf8(:,198), n3(:,161), t3x8(:,:,142))
  call vert_AZ_Q(gZn,ntry, ex2(:), wf4(:,36), wf8(:,199), n3(:,162), t3x8(:,:,143))
  call vert_AZ_Q(gZn,ntry, ex2(:), wf4(:,37), wf8(:,200), n3(:,163), t3x8(:,:,144))
  call counter_Q_A_LR(EWctnn,ntry, wf8(:,39), 37, wf8(:,201), n2(75))
  call counter_Q_A_LR(EWctnn,ntry, wf8(:,42), 25, wf8(:,202), n2(76))
  call vert_ZQ_A(gZn,ntry, wf4(:,31), ex1(:), wf8(:,203), n3(:,164), t3x8(:,:,145))
  call vert_ZQ_A(gZn,ntry, wf4(:,33), ex1(:), wf8(:,204), n3(:,165), t3x8(:,:,146))
  call vert_ZQ_A(gZn,ntry, wf4(:,28), ex1(:), wf8(:,205), n3(:,166), t3x8(:,:,147))
  call vert_ZQ_A(gZn,ntry, wf4(:,29), ex1(:), wf8(:,206), n3(:,167), t3x8(:,:,148))
  call vert_AZ_Q(gZn,ntry, ex2(:), wf4(:,31), wf8(:,207), n3(:,168), t3x8(:,:,149))
  call vert_AZ_Q(gZn,ntry, ex2(:), wf4(:,33), wf8(:,208), n3(:,169), t3x8(:,:,150))
  call vert_AZ_Q(gZn,ntry, ex2(:), wf4(:,28), wf8(:,209), n3(:,170), t3x8(:,:,151))
  call vert_AZ_Q(gZn,ntry, ex2(:), wf4(:,29), wf8(:,210), n3(:,171), t3x8(:,:,152))
  call vert_VV_S(ntry, wf4(:,1), wf4(:,3), wf16(:,1), n3(:,172), t3x16(:,:,1))
  call vert_VV_S(ntry, wf4(:,1), wf4(:,5), wf16(:,2), n3(:,173), t3x16(:,:,2))
  call vert_VV_S(ntry, wf4(:,1), wf4(:,7), wf16(:,3), n3(:,174), t3x16(:,:,3))
  call vert_VV_S(ntry, wf4(:,1), wf4(:,9), wf16(:,4), n3(:,175), t3x16(:,:,4))
  call vert_QA_V(ntry, wf8(:,12), ex5(:), wf16(:,5), n3(:,176), t3x16(:,:,5))
  call vert_QA_Z(gZu,ntry, wf8(:,12), ex5(:), wf16(:,6), n3(:,177), t3x16(:,:,6))
  call vert_QA_V(ntry, wf8(:,12), ex6(:), wf16(:,7), n3(:,178), t3x16(:,:,7))
  call vert_QA_Z(gZu,ntry, wf8(:,12), ex6(:), wf16(:,8), n3(:,179), t3x16(:,:,8))
  call vert_QA_V(ntry, wf8(:,3), ex5(:), wf16(:,9), n3(:,180), t3x16(:,:,9))
  call vert_QA_Z(gZu,ntry, wf8(:,3), ex5(:), wf16(:,10), n3(:,181), t3x16(:,:,10))
  call vert_QA_V(ntry, wf8(:,3), ex6(:), wf16(:,11), n3(:,182), t3x16(:,:,11))
  call vert_QA_Z(gZu,ntry, wf8(:,3), ex6(:), wf16(:,12), n3(:,183), t3x16(:,:,12))
  call vert_QA_V(ntry, ex3(:), wf8(:,60), wf16(:,13), n3(:,184), t3x16(:,:,13))
  call vert_QA_Z(gZu,ntry, ex3(:), wf8(:,60), wf16(:,14), n3(:,185), t3x16(:,:,14))
  call vert_QA_V(ntry, ex4(:), wf8(:,60), wf16(:,15), n3(:,186), t3x16(:,:,15))
  call vert_QA_Z(gZu,ntry, ex4(:), wf8(:,60), wf16(:,16), n3(:,187), t3x16(:,:,16))
  call vert_QA_V(ntry, ex3(:), wf8(:,54), wf16(:,17), n3(:,188), t3x16(:,:,17))
  call vert_QA_Z(gZu,ntry, ex3(:), wf8(:,54), wf16(:,18), n3(:,189), t3x16(:,:,18))
  call vert_QA_V(ntry, ex4(:), wf8(:,54), wf16(:,19), n3(:,190), t3x16(:,:,19))
  call vert_QA_Z(gZu,ntry, ex4(:), wf8(:,54), wf16(:,20), n3(:,191), t3x16(:,:,20))
  call vert_VV_S(ntry, wf4(:,3), wf4(:,9), wf16(:,21), n3(:,192), t3x16(:,:,21))
  call vert_QA_Z(gZn,ntry, wf8(:,33), ex2(:), wf16(:,22), n3(:,193), t3x16(:,:,22))
  call vert_QA_Z(gZn,ntry, ex1(:), wf8(:,121), wf16(:,23), n3(:,194), t3x16(:,:,23))
  call vert_QA_V(ntry, wf8(:,7), ex6(:), wf16(:,24), n3(:,195), t3x16(:,:,24))
  call vert_QA_Z(gZu,ntry, wf8(:,7), ex6(:), wf16(:,25), n3(:,196), t3x16(:,:,25))
  call vert_QA_V(ntry, wf8(:,9), ex6(:), wf16(:,26), n3(:,197), t3x16(:,:,26))
  call vert_QA_Z(gZu,ntry, wf8(:,9), ex6(:), wf16(:,27), n3(:,198), t3x16(:,:,27))
  call vert_QA_V(ntry, ex4(:), wf8(:,57), wf16(:,28), n3(:,199), t3x16(:,:,28))
  call vert_QA_Z(gZu,ntry, ex4(:), wf8(:,57), wf16(:,29), n3(:,200), t3x16(:,:,29))
  call vert_QA_V(ntry, ex4(:), wf8(:,58), wf16(:,30), n3(:,201), t3x16(:,:,30))
  call vert_QA_Z(gZu,ntry, ex4(:), wf8(:,58), wf16(:,31), n3(:,202), t3x16(:,:,31))
  call vert_VV_S(ntry, wf4(:,5), wf4(:,7), wf16(:,32), n3(:,203), t3x16(:,:,32))
  call vert_QA_Z(gZn,ntry, wf8(:,42), ex2(:), wf16(:,33), n3(:,204), t3x16(:,:,33))
  call vert_QA_Z(gZn,ntry, ex1(:), wf8(:,124), wf16(:,34), n3(:,205), t3x16(:,:,34))
  call vert_QA_V(ntry, wf8(:,15), ex6(:), wf16(:,35), n3(:,206), t3x16(:,:,35))
  call vert_QA_Z(gZu,ntry, wf8(:,15), ex6(:), wf16(:,36), n3(:,207), t3x16(:,:,36))
  call vert_QA_V(ntry, wf8(:,17), ex6(:), wf16(:,37), n3(:,208), t3x16(:,:,37))
  call vert_QA_Z(gZu,ntry, wf8(:,17), ex6(:), wf16(:,38), n3(:,209), t3x16(:,:,38))
  call vert_QA_V(ntry, ex3(:), wf8(:,79), wf16(:,39), n3(:,210), t3x16(:,:,39))
  call vert_QA_V(ntry, ex3(:), wf8(:,80), wf16(:,40), n3(:,211), t3x16(:,:,40))
  call vert_QA_Z(gZu,ntry, ex3(:), wf8(:,79), wf16(:,41), n3(:,212), t3x16(:,:,41))
  call vert_QA_Z(gZu,ntry, ex3(:), wf8(:,80), wf16(:,42), n3(:,213), t3x16(:,:,42))
  call vert_QA_Z(gZn,ntry, wf8(:,39), ex2(:), wf16(:,43), n3(:,214), t3x16(:,:,43))
  call vert_QA_Z(gZn,ntry, ex1(:), wf8(:,127), wf16(:,44), n3(:,215), t3x16(:,:,44))
  call vert_QA_V(ntry, wf8(:,22), ex5(:), wf16(:,45), n3(:,216), t3x16(:,:,45))
  call vert_QA_Z(gZu,ntry, wf8(:,22), ex5(:), wf16(:,46), n3(:,217), t3x16(:,:,46))
  call vert_QA_V(ntry, wf8(:,24), ex5(:), wf16(:,47), n3(:,218), t3x16(:,:,47))
  call vert_QA_Z(gZu,ntry, wf8(:,24), ex5(:), wf16(:,48), n3(:,219), t3x16(:,:,48))
  call vert_QA_V(ntry, ex4(:), wf8(:,62), wf16(:,49), n3(:,220), t3x16(:,:,49))
  call vert_QA_Z(gZu,ntry, ex4(:), wf8(:,62), wf16(:,50), n3(:,221), t3x16(:,:,50))
  call vert_QA_V(ntry, ex4(:), wf8(:,63), wf16(:,51), n3(:,222), t3x16(:,:,51))
  call vert_QA_Z(gZu,ntry, ex4(:), wf8(:,63), wf16(:,52), n3(:,223), t3x16(:,:,52))
  call vert_QA_Z(gZn,ntry, wf8(:,36), ex2(:), wf16(:,53), n3(:,224), t3x16(:,:,53))
  call vert_QA_Z(gZn,ntry, ex1(:), wf8(:,118), wf16(:,54), n3(:,225), t3x16(:,:,54))
  call vert_QA_V(ntry, wf8(:,28), ex5(:), wf16(:,55), n3(:,226), t3x16(:,:,55))
  call vert_QA_Z(gZu,ntry, wf8(:,28), ex5(:), wf16(:,56), n3(:,227), t3x16(:,:,56))
  call vert_QA_V(ntry, wf8(:,30), ex5(:), wf16(:,57), n3(:,228), t3x16(:,:,57))
  call vert_QA_Z(gZu,ntry, wf8(:,30), ex5(:), wf16(:,58), n3(:,229), t3x16(:,:,58))
  call vert_QA_V(ntry, ex3(:), wf8(:,83), wf16(:,59), n3(:,230), t3x16(:,:,59))
  call vert_QA_V(ntry, ex3(:), wf8(:,84), wf16(:,60), n3(:,231), t3x16(:,:,60))
  call vert_QA_Z(gZu,ntry, ex3(:), wf8(:,83), wf16(:,61), n3(:,232), t3x16(:,:,61))
  call vert_QA_Z(gZu,ntry, ex3(:), wf8(:,84), wf16(:,62), n3(:,233), t3x16(:,:,62))


  call init_hybrid_exwf(ex1)
  call init_hybrid_exwf(ex2)
  call init_hybrid_exwf(ex3)
  call init_hybrid_exwf(ex4)
  call init_hybrid_exwf(ex5)
  call init_hybrid_exwf(ex6)
  call init_hybrid_wf(wf4)
  call init_hybrid_wf(wf8)
  call init_hybrid_wf(wf16)


  if (ntry==1) then
    call physical_helicities()
  end if

  ! computation of the colour-stripped amplitudes
  do nsync = ntry+ntry-1, ntry+1  !  nsync = 1,2  for 1st point and nsync = 3 later
    call diagrams()
    if (nsync == 1) call helsync(nsync, A, nhel, Hel)
  end do

  ! In the following loop the coefficients \Gamma_{i} of the expansion in
  ! the colour basis are computed for every helicity state and stored in M1helarray.
  ! Also the colour vector for the Born-loop interference is computed and saved in
  ! M0_col1_helarray
  do k = 1, nhel
    call colourvectors(A, k, M1helarray(:,k),M1helarray_ct(:,k))
    call colborninterf(M1helarray(:,k), M0_col1_helarray(:,k), 0)
  end do
  M1helarray(:,nhel+1:)%j = 0
  M0_col1_helarray(:,nhel+1:)%hf = -1_intkind2
  M0_col1_helarray(:,nhel+1:)%j = 0

  M2add = 0
  M2add_ct = 0
  M2add_colint = 0

  M02 = 0
  M2ct = 0
  M2colint = 0

  do k = 1, nhel
    call colint(M1helarray(:,k)%j, M2add)
    call colint_ct(M1helarray(:,k)%j, M1helarray_ct(:,k)%j, M2add_ct, 0)
    if (IR_is_on > 0) then
      call colint_IR(M1helarray(:,k)%j, M2add_colint)
    end if
    !summation over helicity configurations
    M02 = M02 + M2add
    M2ct = M2ct + M2add_ct
    M2colint = M2colint + M2add_colint
  end do

  call photon_factors(photonid_ppnnjj_ew_nenexuuuxux_4, &
                    &  0, bornphotonfactor)
  M02 = bornphotonfactor * M02
  M2ct = bornphotonfactor * M2ct
  M2colint = bornphotonfactor * M2colint

  !! used for born-loop colour-correlators
  extcombs = [(i, i = 0, 22-1)]
  nextcombs = 6*(6+1)/2 + 1
  if(nextcombs>0) then
    allocate(extcombs_permuted(nextcombs))
  end if
  do k = 1, nextcombs
    extcombs_permuted(k) = extcomb_perm_ppnnjj_ew_nenexuuuxux_4(extcombs(k))
  end do

#if -1 > 0 && 6 > 3
  !!Born-loop colour correlators interference

  M0M1_hel_cc(:,:,:)%j = 0
  do n = 1, 9
    M2add_ct = 0
    m = ind_cc_comb(n)
      do k = 1, nhel
        call colint_ct(M1helarray(:,k)%j, M1helarray_ct(:,k)%j, M2add_ct, m)
        call colborninterf(M1helarray(:,k), M0M1_hel_cc(:,k,m), m)
        M2ctcc(m) = M2ctcc(m) + M2add_ct
      end do
  end do
  M0M1_hel_cc(:,nhel+1:,:)%hf = -1_intkind2
  M0M1_hel_cc(:,nhel+1:,:)%j = 0
#endif


  contains

subroutine physical_helicities()
  implicit none

integer :: i1,i2,i3,i4,i5,i6
integer :: n

n=0

do i6= 1, 2
do i5= 1, 2
do i4= 1, 2
do i3= 1, 2
do i2= 1, 2
do i1= 1, 2
n = n + 1
 if((ex1(i1)%hf==-1_intkind2) .OR. (ex2(i2)%hf==-1_intkind2) .OR. (ex3(i3)%hf==-1_intkind2) .OR. (ex4(i4)%hf==-1_intkind2)  &
    .OR. (ex5(i5)%hf==-1_intkind2) .OR. (ex6(i6)%hf==-1_intkind2)) then
  Hel(n) = -1_intkind2
 else
  Hel(n) = ex1(i1)%hf + ex2(i2)%hf + ex3(i3)%hf + ex4(i4)%hf + ex5(i5)%hf + ex6(i6)%hf
 end if
end do
end do
end do
end do
end do
end do

end subroutine physical_helicities

subroutine diagrams()
  implicit none
  integer :: h
  ! e.g. call cont_VV(nsync, wf3, wf6, A(:,1), n64, t64, nhel, den(5)) ...

    call Hcont_QA(nsync, wf8(:,2), wf8(:,3), A(:,1), n3(:,234), t3x64(:,:,1), nhel, den(5))
    call Hcont_QA(nsync, wf8(:,3), wf8(:,4), A(:,2), n3(:,235), t3x64(:,:,2), nhel, den(7))
    call Hcont_QA(nsync, wf8(:,6), wf8(:,7), A(:,3), n3(:,236), t3x64(:,:,3), nhel, den(10))
    call Hcont_QA(nsync, wf8(:,6), wf8(:,9), A(:,4), n3(:,237), t3x64(:,:,4), nhel, den(12))
    call Hcont_QA(nsync, wf8(:,11), wf8(:,12), A(:,5), n3(:,238), t3x64(:,:,5), nhel, den(16))
    call Hcont_QA(nsync, wf8(:,12), wf8(:,13), A(:,6), n3(:,239), t3x64(:,:,6), nhel, den(18))
    call Hcont_QA(nsync, wf8(:,6), wf8(:,15), A(:,7), n3(:,240), t3x64(:,:,7), nhel, den(20))
    call Hcont_QA(nsync, wf8(:,6), wf8(:,17), A(:,8), n3(:,241), t3x64(:,:,8), nhel, den(22))
    call Hcont_QA(nsync, wf8(:,3), wf8(:,18), A(:,9), n3(:,242), t3x64(:,:,9), nhel, den(24))
    call Hcont_QA(nsync, wf8(:,3), wf8(:,19), A(:,10), n3(:,243), t3x64(:,:,10), nhel, den(26))
    call Hcont_QA(nsync, wf8(:,21), wf8(:,22), A(:,11), n3(:,244), t3x64(:,:,11), nhel, den(29))
    call Hcont_QA(nsync, wf8(:,21), wf8(:,24), A(:,12), n3(:,245), t3x64(:,:,12), nhel, den(31))
    call Hcont_QA(nsync, wf8(:,12), wf8(:,25), A(:,13), n3(:,246), t3x64(:,:,13), nhel, den(33))
    call Hcont_QA(nsync, wf8(:,12), wf8(:,26), A(:,14), n3(:,247), t3x64(:,:,14), nhel, den(35))
    call Hcont_QA(nsync, wf8(:,21), wf8(:,28), A(:,15), n3(:,248), t3x64(:,:,15), nhel, den(37))
    call Hcont_QA(nsync, wf8(:,21), wf8(:,30), A(:,16), n3(:,249), t3x64(:,:,16), nhel, den(39))
    call Hcont_QA(nsync, wf8(:,32), wf8(:,33), A(:,17), n3(:,250), t3x64(:,:,17), nhel, den(42))
    call Hcont_QA(nsync, wf8(:,35), wf8(:,36), A(:,18), n3(:,251), t3x64(:,:,18), nhel, den(45))
    call Hcont_QA(nsync, wf8(:,38), wf8(:,39), A(:,19), n3(:,252), t3x64(:,:,19), nhel, den(48))
    call Hcont_QA(nsync, wf8(:,41), wf8(:,42), A(:,20), n3(:,253), t3x64(:,:,20), nhel, den(51))

    call Hcont_QA(nsync, wf8(:,3), wf8(:,43), A(:,21), n3(:,254), t3x64(:,:,21), nhel, den(5))
    call Hcont_QA(nsync, wf8(:,3), wf8(:,44), A(:,22), n3(:,255), t3x64(:,:,22), nhel, den(7))
    call Hcont_QA(nsync, wf8(:,7), wf8(:,45), A(:,23), n3(:,256), t3x64(:,:,23), nhel, den(10))
    call Hcont_QA(nsync, wf8(:,9), wf8(:,45), A(:,24), n3(:,257), t3x64(:,:,24), nhel, den(12))
    call Hcont_QA(nsync, wf8(:,12), wf8(:,46), A(:,25), n3(:,258), t3x64(:,:,25), nhel, den(16))
    call Hcont_QA(nsync, wf8(:,12), wf8(:,47), A(:,26), n3(:,259), t3x64(:,:,26), nhel, den(18))
    call Hcont_QA(nsync, wf8(:,15), wf8(:,45), A(:,27), n3(:,260), t3x64(:,:,27), nhel, den(20))
    call Hcont_QA(nsync, wf8(:,17), wf8(:,45), A(:,28), n3(:,261), t3x64(:,:,28), nhel, den(22))
    call Hcont_QA(nsync, wf8(:,3), wf8(:,48), A(:,29), n3(:,262), t3x64(:,:,29), nhel, den(24))
    call Hcont_QA(nsync, wf8(:,3), wf8(:,49), A(:,30), n3(:,263), t3x64(:,:,30), nhel, den(26))
    call Hcont_QA(nsync, wf8(:,22), wf8(:,50), A(:,31), n3(:,264), t3x64(:,:,31), nhel, den(29))
    call Hcont_QA(nsync, wf8(:,24), wf8(:,50), A(:,32), n3(:,265), t3x64(:,:,32), nhel, den(31))
    call Hcont_QA(nsync, wf8(:,12), wf8(:,51), A(:,33), n3(:,266), t3x64(:,:,33), nhel, den(33))
    call Hcont_QA(nsync, wf8(:,12), wf8(:,52), A(:,34), n3(:,267), t3x64(:,:,34), nhel, den(35))
    call Hcont_QA(nsync, wf8(:,28), wf8(:,50), A(:,35), n3(:,268), t3x64(:,:,35), nhel, den(37))
    call Hcont_QA(nsync, wf8(:,30), wf8(:,50), A(:,36), n3(:,269), t3x64(:,:,36), nhel, den(39))
    call Hcont_QA(nsync, wf8(:,53), wf8(:,54), A(:,37), n3(:,270), t3x64(:,:,37), nhel, den(54))
    call Hcont_QA(nsync, wf8(:,54), wf8(:,55), A(:,38), n3(:,271), t3x64(:,:,38), nhel, den(55))
    call Hcont_QA(nsync, wf8(:,56), wf8(:,57), A(:,39), n3(:,272), t3x64(:,:,39), nhel, den(58))
    call Hcont_QA(nsync, wf8(:,56), wf8(:,58), A(:,40), n3(:,273), t3x64(:,:,40), nhel, den(60))
    call Hcont_QA(nsync, wf8(:,59), wf8(:,60), A(:,41), n3(:,274), t3x64(:,:,41), nhel, den(63))
    call Hcont_QA(nsync, wf8(:,60), wf8(:,61), A(:,42), n3(:,275), t3x64(:,:,42), nhel, den(64))
    call Hcont_QA(nsync, wf8(:,56), wf8(:,62), A(:,43), n3(:,276), t3x64(:,:,43), nhel, den(66))
    call Hcont_QA(nsync, wf8(:,56), wf8(:,63), A(:,44), n3(:,277), t3x64(:,:,44), nhel, den(68))
    call Hcont_QA(nsync, wf8(:,12), wf8(:,64), A(:,45), n3(:,278), t3x64(:,:,45), nhel, den(33))
    call Hcont_QA(nsync, wf8(:,12), wf8(:,65), A(:,46), n3(:,279), t3x64(:,:,46), nhel, den(35))
    call Hcont_QA(nsync, wf8(:,21), wf8(:,67), A(:,47), n3(:,280), t3x64(:,:,47), nhel, den(37))
    call Hcont_QA(nsync, wf8(:,21), wf8(:,69), A(:,48), n3(:,281), t3x64(:,:,48), nhel, den(39))
    call Hcont_QA(nsync, wf8(:,12), wf8(:,70), A(:,49), n3(:,282), t3x64(:,:,49), nhel, den(16))
    call Hcont_QA(nsync, wf8(:,12), wf8(:,71), A(:,50), n3(:,283), t3x64(:,:,50), nhel, den(18))
    call Hcont_QA(nsync, wf8(:,6), wf8(:,73), A(:,51), n3(:,284), t3x64(:,:,51), nhel, den(20))
    call Hcont_QA(nsync, wf8(:,6), wf8(:,75), A(:,52), n3(:,285), t3x64(:,:,52), nhel, den(22))
    call Hcont_QA(nsync, wf8(:,54), wf8(:,76), A(:,53), n3(:,286), t3x64(:,:,53), nhel, den(69))
    call Hcont_QA(nsync, wf8(:,54), wf8(:,77), A(:,54), n3(:,287), t3x64(:,:,54), nhel, den(70))
    call Hcont_QA(nsync, wf8(:,78), wf8(:,79), A(:,55), n3(:,288), t3x64(:,:,55), nhel, den(73))
    call Hcont_QA(nsync, wf8(:,78), wf8(:,80), A(:,56), n3(:,289), t3x64(:,:,56), nhel, den(75))
    call Hcont_QA(nsync, wf8(:,60), wf8(:,81), A(:,57), n3(:,290), t3x64(:,:,57), nhel, den(76))
    call Hcont_QA(nsync, wf8(:,60), wf8(:,82), A(:,58), n3(:,291), t3x64(:,:,58), nhel, den(77))
    call Hcont_QA(nsync, wf8(:,78), wf8(:,83), A(:,59), n3(:,292), t3x64(:,:,59), nhel, den(79))
    call Hcont_QA(nsync, wf8(:,78), wf8(:,84), A(:,60), n3(:,293), t3x64(:,:,60), nhel, den(81))
    call Hcont_QA(nsync, wf8(:,3), wf8(:,85), A(:,61), n3(:,294), t3x64(:,:,61), nhel, den(24))
    call Hcont_QA(nsync, wf8(:,3), wf8(:,86), A(:,62), n3(:,295), t3x64(:,:,62), nhel, den(26))
    call Hcont_QA(nsync, wf8(:,21), wf8(:,88), A(:,63), n3(:,296), t3x64(:,:,63), nhel, den(29))
    call Hcont_QA(nsync, wf8(:,21), wf8(:,90), A(:,64), n3(:,297), t3x64(:,:,64), nhel, den(31))
    call Hcont_QA(nsync, wf8(:,3), wf8(:,91), A(:,65), n3(:,298), t3x64(:,:,65), nhel, den(5))
    call Hcont_QA(nsync, wf8(:,3), wf8(:,92), A(:,66), n3(:,299), t3x64(:,:,66), nhel, den(7))
    call Hcont_QA(nsync, wf8(:,6), wf8(:,94), A(:,67), n3(:,300), t3x64(:,:,67), nhel, den(10))
    call Hcont_QA(nsync, wf8(:,6), wf8(:,96), A(:,68), n3(:,301), t3x64(:,:,68), nhel, den(12))
    call Hcont_QA(nsync, wf8(:,33), wf8(:,97), A(:,69), n3(:,302), t3x64(:,:,69), nhel, den(42))
    call Hcont_QA(nsync, wf8(:,35), wf8(:,99), A(:,70), n3(:,303), t3x64(:,:,70), nhel, den(45))
    call Hcont_QA(nsync, wf8(:,39), wf8(:,100), A(:,71), n3(:,304), t3x64(:,:,71), nhel, den(48))
    call Hcont_QA(nsync, wf8(:,41), wf8(:,102), A(:,72), n3(:,305), t3x64(:,:,72), nhel, den(51))
    call Hcont_QA(nsync, wf8(:,42), wf8(:,103), A(:,73), n3(:,306), t3x64(:,:,73), nhel, den(51))
    call Hcont_QA(nsync, wf8(:,38), wf8(:,105), A(:,74), n3(:,307), t3x64(:,:,74), nhel, den(48))
    call Hcont_QA(nsync, wf8(:,36), wf8(:,106), A(:,75), n3(:,308), t3x64(:,:,75), nhel, den(45))
    call Hcont_QA(nsync, wf8(:,32), wf8(:,108), A(:,76), n3(:,309), t3x64(:,:,76), nhel, den(42))
    call Hcont_QA(nsync, wf8(:,33), wf8(:,109), A(:,77), n3(:,310), t3x64(:,:,77), nhel, den(82))
    call Hcont_QA(nsync, wf8(:,33), wf8(:,110), A(:,78), n3(:,311), t3x64(:,:,78), nhel, den(42))
    call Hcont_QA(nsync, wf8(:,36), wf8(:,111), A(:,79), n3(:,312), t3x64(:,:,79), nhel, den(83))
    call Hcont_QA(nsync, wf8(:,36), wf8(:,112), A(:,80), n3(:,313), t3x64(:,:,80), nhel, den(45))
    call Hcont_QA(nsync, wf8(:,39), wf8(:,113), A(:,81), n3(:,314), t3x64(:,:,81), nhel, den(84))
    call Hcont_QA(nsync, wf8(:,39), wf8(:,114), A(:,82), n3(:,315), t3x64(:,:,82), nhel, den(48))
    call Hcont_QA(nsync, wf8(:,42), wf8(:,115), A(:,83), n3(:,316), t3x64(:,:,83), nhel, den(85))
    call Hcont_QA(nsync, wf8(:,42), wf8(:,116), A(:,84), n3(:,317), t3x64(:,:,84), nhel, den(51))
    call Hcont_QA(nsync, wf8(:,117), wf8(:,118), A(:,85), n3(:,318), t3x64(:,:,85), nhel, den(88))
    call Hcont_QA(nsync, wf8(:,118), wf8(:,119), A(:,86), n3(:,319), t3x64(:,:,86), nhel, den(89))
    call Hcont_QA(nsync, wf8(:,120), wf8(:,121), A(:,87), n3(:,320), t3x64(:,:,87), nhel, den(92))
    call Hcont_QA(nsync, wf8(:,121), wf8(:,122), A(:,88), n3(:,321), t3x64(:,:,88), nhel, den(93))
    call Hcont_QA(nsync, wf8(:,123), wf8(:,124), A(:,89), n3(:,322), t3x64(:,:,89), nhel, den(96))
    call Hcont_QA(nsync, wf8(:,124), wf8(:,125), A(:,90), n3(:,323), t3x64(:,:,90), nhel, den(97))
    call Hcont_QA(nsync, wf8(:,126), wf8(:,127), A(:,91), n3(:,324), t3x64(:,:,91), nhel, den(100))
    call Hcont_QA(nsync, wf8(:,127), wf8(:,128), A(:,92), n3(:,325), t3x64(:,:,92), nhel, den(101))
    call Hcont_QA(nsync, wf8(:,2), wf8(:,130), A(:,93), n3(:,326), t3x64(:,:,93), nhel, den(104))
    call Hcont_QA(nsync, wf8(:,4), wf8(:,130), A(:,94), n3(:,327), t3x64(:,:,94), nhel, den(105))
    call Hcont_QA(nsync, wf8(:,2), wf8(:,132), A(:,95), n3(:,328), t3x64(:,:,95), nhel, den(5))
    call Hcont_QA(nsync, wf8(:,4), wf8(:,132), A(:,96), n3(:,329), t3x64(:,:,96), nhel, den(7))
    call Hcont_QA(nsync, wf8(:,7), wf8(:,133), A(:,97), n3(:,330), t3x64(:,:,97), nhel, den(106))
    call Hcont_QA(nsync, wf8(:,9), wf8(:,133), A(:,98), n3(:,331), t3x64(:,:,98), nhel, den(107))
    call Hcont_QA(nsync, wf8(:,7), wf8(:,134), A(:,99), n3(:,332), t3x64(:,:,99), nhel, den(10))
    call Hcont_QA(nsync, wf8(:,9), wf8(:,134), A(:,100), n3(:,333), t3x64(:,:,100), nhel, den(12))
    call Hcont_QA(nsync, wf8(:,11), wf8(:,136), A(:,101), n3(:,334), t3x64(:,:,101), nhel, den(109))
    call Hcont_QA(nsync, wf8(:,13), wf8(:,136), A(:,102), n3(:,335), t3x64(:,:,102), nhel, den(110))
    call Hcont_QA(nsync, wf8(:,11), wf8(:,138), A(:,103), n3(:,336), t3x64(:,:,103), nhel, den(16))
    call Hcont_QA(nsync, wf8(:,13), wf8(:,138), A(:,104), n3(:,337), t3x64(:,:,104), nhel, den(18))
    call Hcont_QA(nsync, wf8(:,15), wf8(:,133), A(:,105), n3(:,338), t3x64(:,:,105), nhel, den(111))
    call Hcont_QA(nsync, wf8(:,17), wf8(:,133), A(:,106), n3(:,339), t3x64(:,:,106), nhel, den(112))
    call Hcont_QA(nsync, wf8(:,15), wf8(:,134), A(:,107), n3(:,340), t3x64(:,:,107), nhel, den(20))
    call Hcont_QA(nsync, wf8(:,17), wf8(:,134), A(:,108), n3(:,341), t3x64(:,:,108), nhel, den(22))
    call Hcont_QA(nsync, wf8(:,18), wf8(:,130), A(:,109), n3(:,342), t3x64(:,:,109), nhel, den(113))
    call Hcont_QA(nsync, wf8(:,19), wf8(:,130), A(:,110), n3(:,343), t3x64(:,:,110), nhel, den(114))
    call Hcont_QA(nsync, wf8(:,18), wf8(:,132), A(:,111), n3(:,344), t3x64(:,:,111), nhel, den(24))
    call Hcont_QA(nsync, wf8(:,19), wf8(:,132), A(:,112), n3(:,345), t3x64(:,:,112), nhel, den(26))
    call Hcont_QA(nsync, wf8(:,22), wf8(:,139), A(:,113), n3(:,346), t3x64(:,:,113), nhel, den(115))
    call Hcont_QA(nsync, wf8(:,24), wf8(:,139), A(:,114), n3(:,347), t3x64(:,:,114), nhel, den(116))
    call Hcont_QA(nsync, wf8(:,22), wf8(:,140), A(:,115), n3(:,348), t3x64(:,:,115), nhel, den(29))
    call Hcont_QA(nsync, wf8(:,24), wf8(:,140), A(:,116), n3(:,349), t3x64(:,:,116), nhel, den(31))
    call Hcont_QA(nsync, wf8(:,25), wf8(:,136), A(:,117), n3(:,350), t3x64(:,:,117), nhel, den(117))
    call Hcont_QA(nsync, wf8(:,26), wf8(:,136), A(:,118), n3(:,351), t3x64(:,:,118), nhel, den(118))
    call Hcont_QA(nsync, wf8(:,25), wf8(:,138), A(:,119), n3(:,352), t3x64(:,:,119), nhel, den(33))
    call Hcont_QA(nsync, wf8(:,26), wf8(:,138), A(:,120), n3(:,353), t3x64(:,:,120), nhel, den(35))
    call Hcont_QA(nsync, wf8(:,28), wf8(:,139), A(:,121), n3(:,354), t3x64(:,:,121), nhel, den(119))
    call Hcont_QA(nsync, wf8(:,30), wf8(:,139), A(:,122), n3(:,355), t3x64(:,:,122), nhel, den(120))
    call Hcont_QA(nsync, wf8(:,28), wf8(:,140), A(:,123), n3(:,356), t3x64(:,:,123), nhel, den(37))
    call Hcont_QA(nsync, wf8(:,30), wf8(:,140), A(:,124), n3(:,357), t3x64(:,:,124), nhel, den(39))
    call Hcont_QA(nsync, wf8(:,57), wf8(:,141), A(:,125), n3(:,358), t3x64(:,:,125), nhel, den(122))
    call Hcont_QA(nsync, wf8(:,58), wf8(:,141), A(:,126), n3(:,359), t3x64(:,:,126), nhel, den(123))
    call Hcont_QA(nsync, wf8(:,57), wf8(:,142), A(:,127), n3(:,360), t3x64(:,:,127), nhel, den(125))
    call Hcont_QA(nsync, wf8(:,58), wf8(:,142), A(:,128), n3(:,361), t3x64(:,:,128), nhel, den(126))
    call Hcont_QA(nsync, wf8(:,7), wf8(:,143), A(:,129), n3(:,362), t3x64(:,:,129), nhel, den(127))
    call Hcont_QA(nsync, wf8(:,9), wf8(:,143), A(:,130), n3(:,363), t3x64(:,:,130), nhel, den(128))
    call Hcont_QA(nsync, wf8(:,7), wf8(:,144), A(:,131), n3(:,364), t3x64(:,:,131), nhel, den(129))
    call Hcont_QA(nsync, wf8(:,9), wf8(:,144), A(:,132), n3(:,365), t3x64(:,:,132), nhel, den(130))
    call Hcont_QA(nsync, wf8(:,54), wf8(:,145), A(:,133), n3(:,366), t3x64(:,:,133), nhel, den(132))
    call Hcont_QA(nsync, wf8(:,54), wf8(:,146), A(:,134), n3(:,367), t3x64(:,:,134), nhel, den(134))
    call Hcont_QA(nsync, wf8(:,54), wf8(:,147), A(:,135), n3(:,368), t3x64(:,:,135), nhel, den(134))
    call Hcont_QA(nsync, wf8(:,54), wf8(:,148), A(:,136), n3(:,369), t3x64(:,:,136), nhel, den(136))
    call Hcont_QA(nsync, wf8(:,3), wf8(:,149), A(:,137), n3(:,370), t3x64(:,:,137), nhel, den(137))
    call Hcont_QA(nsync, wf8(:,3), wf8(:,150), A(:,138), n3(:,371), t3x64(:,:,138), nhel, den(138))
    call Hcont_QA(nsync, wf8(:,3), wf8(:,151), A(:,139), n3(:,372), t3x64(:,:,139), nhel, den(138))
    call Hcont_QA(nsync, wf8(:,3), wf8(:,152), A(:,140), n3(:,373), t3x64(:,:,140), nhel, den(139))
    call Hcont_QA(nsync, wf8(:,57), wf8(:,153), A(:,141), n3(:,374), t3x64(:,:,141), nhel, den(140))
    call Hcont_QA(nsync, wf8(:,58), wf8(:,153), A(:,142), n3(:,375), t3x64(:,:,142), nhel, den(141))
    call Hcont_QA(nsync, wf8(:,54), wf8(:,154), A(:,143), n3(:,376), t3x64(:,:,143), nhel, den(142))
    call Hcont_QA(nsync, wf8(:,54), wf8(:,155), A(:,144), n3(:,377), t3x64(:,:,144), nhel, den(143))
    call Hcont_QA(nsync, wf8(:,79), wf8(:,156), A(:,145), n3(:,378), t3x64(:,:,145), nhel, den(144))
    call Hcont_QA(nsync, wf8(:,80), wf8(:,156), A(:,146), n3(:,379), t3x64(:,:,146), nhel, den(145))
    call Hcont_QA(nsync, wf8(:,79), wf8(:,157), A(:,147), n3(:,380), t3x64(:,:,147), nhel, den(146))
    call Hcont_QA(nsync, wf8(:,80), wf8(:,157), A(:,148), n3(:,381), t3x64(:,:,148), nhel, den(147))
    call Hcont_QA(nsync, wf8(:,15), wf8(:,143), A(:,149), n3(:,382), t3x64(:,:,149), nhel, den(148))
    call Hcont_QA(nsync, wf8(:,17), wf8(:,143), A(:,150), n3(:,383), t3x64(:,:,150), nhel, den(149))
    call Hcont_QA(nsync, wf8(:,15), wf8(:,144), A(:,151), n3(:,384), t3x64(:,:,151), nhel, den(150))
    call Hcont_QA(nsync, wf8(:,17), wf8(:,144), A(:,152), n3(:,385), t3x64(:,:,152), nhel, den(151))
    call Hcont_QA(nsync, wf8(:,54), wf8(:,158), A(:,153), n3(:,386), t3x64(:,:,153), nhel, den(153))
    call Hcont_QA(nsync, wf8(:,54), wf8(:,159), A(:,154), n3(:,387), t3x64(:,:,154), nhel, den(155))
    call Hcont_QA(nsync, wf8(:,54), wf8(:,160), A(:,155), n3(:,388), t3x64(:,:,155), nhel, den(155))
    call Hcont_QA(nsync, wf8(:,54), wf8(:,161), A(:,156), n3(:,389), t3x64(:,:,156), nhel, den(157))
    call Hcont_QA(nsync, wf8(:,79), wf8(:,162), A(:,157), n3(:,390), t3x64(:,:,157), nhel, den(158))
    call Hcont_QA(nsync, wf8(:,80), wf8(:,162), A(:,158), n3(:,391), t3x64(:,:,158), nhel, den(159))
    call Hcont_QA(nsync, wf8(:,54), wf8(:,163), A(:,159), n3(:,392), t3x64(:,:,159), nhel, den(160))
    call Hcont_QA(nsync, wf8(:,54), wf8(:,164), A(:,160), n3(:,393), t3x64(:,:,160), nhel, den(161))
    call Hcont_QA(nsync, wf8(:,12), wf8(:,165), A(:,161), n3(:,394), t3x64(:,:,161), nhel, den(162))
    call Hcont_QA(nsync, wf8(:,12), wf8(:,166), A(:,162), n3(:,395), t3x64(:,:,162), nhel, den(163))
    call Hcont_QA(nsync, wf8(:,12), wf8(:,167), A(:,163), n3(:,396), t3x64(:,:,163), nhel, den(163))
    call Hcont_QA(nsync, wf8(:,12), wf8(:,168), A(:,164), n3(:,397), t3x64(:,:,164), nhel, den(164))
    call Hcont_QA(nsync, wf8(:,62), wf8(:,141), A(:,165), n3(:,398), t3x64(:,:,165), nhel, den(165))
    call Hcont_QA(nsync, wf8(:,63), wf8(:,141), A(:,166), n3(:,399), t3x64(:,:,166), nhel, den(166))
    call Hcont_QA(nsync, wf8(:,62), wf8(:,142), A(:,167), n3(:,400), t3x64(:,:,167), nhel, den(167))
    call Hcont_QA(nsync, wf8(:,63), wf8(:,142), A(:,168), n3(:,401), t3x64(:,:,168), nhel, den(168))
    call Hcont_QA(nsync, wf8(:,22), wf8(:,169), A(:,169), n3(:,402), t3x64(:,:,169), nhel, den(169))
    call Hcont_QA(nsync, wf8(:,24), wf8(:,169), A(:,170), n3(:,403), t3x64(:,:,170), nhel, den(170))
    call Hcont_QA(nsync, wf8(:,22), wf8(:,170), A(:,171), n3(:,404), t3x64(:,:,171), nhel, den(171))
    call Hcont_QA(nsync, wf8(:,24), wf8(:,170), A(:,172), n3(:,405), t3x64(:,:,172), nhel, den(172))
    call Hcont_QA(nsync, wf8(:,60), wf8(:,171), A(:,173), n3(:,406), t3x64(:,:,173), nhel, den(174))
    call Hcont_QA(nsync, wf8(:,60), wf8(:,172), A(:,174), n3(:,407), t3x64(:,:,174), nhel, den(176))
    call Hcont_QA(nsync, wf8(:,60), wf8(:,173), A(:,175), n3(:,408), t3x64(:,:,175), nhel, den(176))
    call Hcont_QA(nsync, wf8(:,60), wf8(:,174), A(:,176), n3(:,409), t3x64(:,:,176), nhel, den(178))
    call Hcont_QA(nsync, wf8(:,3), wf8(:,175), A(:,177), n3(:,410), t3x64(:,:,177), nhel, den(179))
    call Hcont_QA(nsync, wf8(:,3), wf8(:,176), A(:,178), n3(:,411), t3x64(:,:,178), nhel, den(180))
    call Hcont_QA(nsync, wf8(:,3), wf8(:,177), A(:,179), n3(:,412), t3x64(:,:,179), nhel, den(180))
    call Hcont_QA(nsync, wf8(:,3), wf8(:,178), A(:,180), n3(:,413), t3x64(:,:,180), nhel, den(181))
    call Hcont_QA(nsync, wf8(:,62), wf8(:,153), A(:,181), n3(:,414), t3x64(:,:,181), nhel, den(182))
    call Hcont_QA(nsync, wf8(:,63), wf8(:,153), A(:,182), n3(:,415), t3x64(:,:,182), nhel, den(183))
    call Hcont_QA(nsync, wf8(:,60), wf8(:,179), A(:,183), n3(:,416), t3x64(:,:,183), nhel, den(184))
    call Hcont_QA(nsync, wf8(:,60), wf8(:,180), A(:,184), n3(:,417), t3x64(:,:,184), nhel, den(185))
    call Hcont_QA(nsync, wf8(:,83), wf8(:,156), A(:,185), n3(:,418), t3x64(:,:,185), nhel, den(186))
    call Hcont_QA(nsync, wf8(:,84), wf8(:,156), A(:,186), n3(:,419), t3x64(:,:,186), nhel, den(187))
    call Hcont_QA(nsync, wf8(:,83), wf8(:,157), A(:,187), n3(:,420), t3x64(:,:,187), nhel, den(188))
    call Hcont_QA(nsync, wf8(:,84), wf8(:,157), A(:,188), n3(:,421), t3x64(:,:,188), nhel, den(189))
    call Hcont_QA(nsync, wf8(:,28), wf8(:,169), A(:,189), n3(:,422), t3x64(:,:,189), nhel, den(190))
    call Hcont_QA(nsync, wf8(:,30), wf8(:,169), A(:,190), n3(:,423), t3x64(:,:,190), nhel, den(191))
    call Hcont_QA(nsync, wf8(:,28), wf8(:,170), A(:,191), n3(:,424), t3x64(:,:,191), nhel, den(192))
    call Hcont_QA(nsync, wf8(:,30), wf8(:,170), A(:,192), n3(:,425), t3x64(:,:,192), nhel, den(193))
    call Hcont_QA(nsync, wf8(:,60), wf8(:,181), A(:,193), n3(:,426), t3x64(:,:,193), nhel, den(195))
    call Hcont_QA(nsync, wf8(:,60), wf8(:,182), A(:,194), n3(:,427), t3x64(:,:,194), nhel, den(197))
    call Hcont_QA(nsync, wf8(:,60), wf8(:,183), A(:,195), n3(:,428), t3x64(:,:,195), nhel, den(197))
    call Hcont_QA(nsync, wf8(:,60), wf8(:,184), A(:,196), n3(:,429), t3x64(:,:,196), nhel, den(199))
    call Hcont_QA(nsync, wf8(:,83), wf8(:,162), A(:,197), n3(:,430), t3x64(:,:,197), nhel, den(200))
    call Hcont_QA(nsync, wf8(:,84), wf8(:,162), A(:,198), n3(:,431), t3x64(:,:,198), nhel, den(201))
    call Hcont_QA(nsync, wf8(:,60), wf8(:,185), A(:,199), n3(:,432), t3x64(:,:,199), nhel, den(202))
    call Hcont_QA(nsync, wf8(:,60), wf8(:,186), A(:,200), n3(:,433), t3x64(:,:,200), nhel, den(203))
    call Hcont_QA(nsync, wf8(:,12), wf8(:,187), A(:,201), n3(:,434), t3x64(:,:,201), nhel, den(204))
    call Hcont_QA(nsync, wf8(:,12), wf8(:,188), A(:,202), n3(:,435), t3x64(:,:,202), nhel, den(205))
    call Hcont_QA(nsync, wf8(:,12), wf8(:,189), A(:,203), n3(:,436), t3x64(:,:,203), nhel, den(205))
    call Hcont_QA(nsync, wf8(:,12), wf8(:,190), A(:,204), n3(:,437), t3x64(:,:,204), nhel, den(206))
    call Hcont_QA(nsync, wf8(:,118), wf8(:,191), A(:,205), n3(:,438), t3x64(:,:,205), nhel, den(207))
    call Hcont_QA(nsync, wf8(:,121), wf8(:,192), A(:,206), n3(:,439), t3x64(:,:,206), nhel, den(208))
    call Hcont_QA(nsync, wf8(:,118), wf8(:,193), A(:,207), n3(:,440), t3x64(:,:,207), nhel, den(209))
    call Hcont_QA(nsync, wf8(:,118), wf8(:,194), A(:,208), n3(:,441), t3x64(:,:,208), nhel, den(210))
    call Hcont_QA(nsync, wf8(:,121), wf8(:,195), A(:,209), n3(:,442), t3x64(:,:,209), nhel, den(211))
    call Hcont_QA(nsync, wf8(:,121), wf8(:,196), A(:,210), n3(:,443), t3x64(:,:,210), nhel, den(212))
    call Hcont_QA(nsync, wf8(:,36), wf8(:,197), A(:,211), n3(:,444), t3x64(:,:,211), nhel, den(213))
    call Hcont_QA(nsync, wf8(:,36), wf8(:,198), A(:,212), n3(:,445), t3x64(:,:,212), nhel, den(214))
    call Hcont_QA(nsync, wf8(:,33), wf8(:,199), A(:,213), n3(:,446), t3x64(:,:,213), nhel, den(215))
    call Hcont_QA(nsync, wf8(:,33), wf8(:,200), A(:,214), n3(:,447), t3x64(:,:,214), nhel, den(216))
    call Hcont_QA(nsync, wf8(:,124), wf8(:,201), A(:,215), n3(:,448), t3x64(:,:,215), nhel, den(217))
    call Hcont_QA(nsync, wf8(:,127), wf8(:,202), A(:,216), n3(:,449), t3x64(:,:,216), nhel, den(218))
    call Hcont_QA(nsync, wf8(:,124), wf8(:,203), A(:,217), n3(:,450), t3x64(:,:,217), nhel, den(219))
    call Hcont_QA(nsync, wf8(:,124), wf8(:,204), A(:,218), n3(:,451), t3x64(:,:,218), nhel, den(220))
    call Hcont_QA(nsync, wf8(:,127), wf8(:,205), A(:,219), n3(:,452), t3x64(:,:,219), nhel, den(221))
    call Hcont_QA(nsync, wf8(:,127), wf8(:,206), A(:,220), n3(:,453), t3x64(:,:,220), nhel, den(222))
    call Hcont_QA(nsync, wf8(:,42), wf8(:,207), A(:,221), n3(:,454), t3x64(:,:,221), nhel, den(223))
    call Hcont_QA(nsync, wf8(:,42), wf8(:,208), A(:,222), n3(:,455), t3x64(:,:,222), nhel, den(224))
    call Hcont_QA(nsync, wf8(:,39), wf8(:,209), A(:,223), n3(:,456), t3x64(:,:,223), nhel, den(225))
    call Hcont_QA(nsync, wf8(:,39), wf8(:,210), A(:,224), n3(:,457), t3x64(:,:,224), nhel, den(226))

end subroutine diagrams


elemental function diagmap(j, n)
  implicit none
  integer, intent(in) :: j, n
  complex(REALKIND) :: diagmap
  diagmap = A(j,n)%j
end function diagmap

function diagsum(j, pos, neg)
  implicit none
  integer, intent(in) :: j, pos(:), neg(:)
  complex(REALKIND) :: diagsum
  diagsum = sum(diagmap(j, pos)) - sum(diagmap(j, neg))
end function diagsum

subroutine colourvectors(A, j, M1, M2)
  implicit none
  type(Hpolcont) :: A(:,:)
  integer, intent(in) :: j
  type(Hpolcont), intent(out) :: M1(2), M2(2) ! M1helarray(2,64)
  integer :: empty(0), i

  M1(1)%j = (A(j,5)%j+A(j,7)%j+A(j,9)%j+A(j,11)%j)*f(1)+(A(j,6)%j+A(j,8)%j+A(j,10)%j+A(j,12)%j+A(j,19)%j+A(j,20)%j)*f(2)
  M1(2)%j = (-A(j,1)%j-A(j,3)%j-A(j,13)%j-A(j,15)%j)*f(1)+(-A(j,2)%j-A(j,4)%j-A(j,14)%j-A(j,16)%j-A(j,17)%j-A(j,18)%j)*f(2)

  M2(1)%j = (-A(j,101)%j-A(j,105)%j-A(j,109)%j-A(j,113)%j+A(j,145)%j+A(j,149)%j+A(j,165)%j+A(j,169)%j)*f(3)+(A(j,27)%j+A(j,31)%j &
       +A(j,43)%j+A(j,55)%j+A(j,103)%j+A(j,107)%j+A(j,111)%j+A(j,115)%j-A(j,147)%j-A(j,151)%j-A(j,153)%j-A(j,157)%j-A(j,159)%j &
       -A(j,161)%j-A(j,167)%j-A(j,171)%j-A(j,173)%j-A(j,177)%j-A(j,181)%j-A(j,183)%j)*f(4)+(-A(j,25)%j-A(j,29)%j-A(j,41)%j &
       -A(j,49)%j-A(j,51)%j-A(j,53)%j-A(j,61)%j-A(j,63)%j-A(j,81)%j-A(j,83)%j-A(j,89)%j-A(j,91)%j-A(j,102)%j-A(j,106)%j-A(j,110)%j &
       -A(j,114)%j+A(j,146)%j+A(j,150)%j+A(j,154)%j+A(j,155)%j+A(j,162)%j+A(j,163)%j+A(j,166)%j+A(j,170)%j+A(j,174)%j+A(j,175)%j &
       +A(j,178)%j+A(j,179)%j+A(j,217)%j+A(j,219)%j+A(j,221)%j+A(j,223)%j)*f(5)+(A(j,26)%j+A(j,28)%j+A(j,30)%j+A(j,32)%j+A(j,42)%j &
       +A(j,44)%j+A(j,50)%j+A(j,52)%j+A(j,54)%j+A(j,56)%j+A(j,62)%j+A(j,64)%j+A(j,71)%j+A(j,72)%j+A(j,73)%j+A(j,74)%j+A(j,82)%j &
       +A(j,84)%j+A(j,90)%j+A(j,92)%j+A(j,104)%j+A(j,108)%j+A(j,112)%j+A(j,116)%j-A(j,148)%j-A(j,152)%j-A(j,156)%j-A(j,158)%j &
       -A(j,160)%j-A(j,164)%j-A(j,168)%j-A(j,172)%j-A(j,176)%j-A(j,180)%j-A(j,182)%j-A(j,184)%j-A(j,215)%j-A(j,216)%j-A(j,218)%j &
       -A(j,220)%j-A(j,222)%j-A(j,224)%j)*f(6)
  M2(2)%j = (A(j,93)%j+A(j,97)%j+A(j,117)%j+A(j,121)%j-A(j,125)%j-A(j,129)%j-A(j,185)%j-A(j,189)%j)*f(3)+(-A(j,23)%j-A(j,35)%j &
       -A(j,39)%j-A(j,59)%j-A(j,95)%j-A(j,99)%j-A(j,119)%j-A(j,123)%j+A(j,127)%j+A(j,131)%j+A(j,133)%j+A(j,137)%j+A(j,141)%j &
       +A(j,143)%j+A(j,187)%j+A(j,191)%j+A(j,193)%j+A(j,197)%j+A(j,199)%j+A(j,201)%j)*f(4)+(A(j,21)%j+A(j,33)%j+A(j,37)%j &
       +A(j,45)%j+A(j,47)%j+A(j,57)%j+A(j,65)%j+A(j,67)%j+A(j,77)%j+A(j,79)%j+A(j,85)%j+A(j,87)%j+A(j,94)%j+A(j,98)%j+A(j,118)%j &
       +A(j,122)%j-A(j,126)%j-A(j,130)%j-A(j,134)%j-A(j,135)%j-A(j,138)%j-A(j,139)%j-A(j,186)%j-A(j,190)%j-A(j,194)%j-A(j,195)%j &
       -A(j,202)%j-A(j,203)%j-A(j,207)%j-A(j,209)%j-A(j,211)%j-A(j,213)%j)*f(5)+(-A(j,22)%j-A(j,24)%j-A(j,34)%j-A(j,36)%j &
       -A(j,38)%j-A(j,40)%j-A(j,46)%j-A(j,48)%j-A(j,58)%j-A(j,60)%j-A(j,66)%j-A(j,68)%j-A(j,69)%j-A(j,70)%j-A(j,75)%j-A(j,76)%j &
       -A(j,78)%j-A(j,80)%j-A(j,86)%j-A(j,88)%j-A(j,96)%j-A(j,100)%j-A(j,120)%j-A(j,124)%j+A(j,128)%j+A(j,132)%j+A(j,136)%j &
       +A(j,140)%j+A(j,142)%j+A(j,144)%j+A(j,188)%j+A(j,192)%j+A(j,196)%j+A(j,198)%j+A(j,200)%j+A(j,204)%j+A(j,205)%j+A(j,206)%j &
       +A(j,208)%j+A(j,210)%j+A(j,212)%j+A(j,214)%j)*f(6)


  M1(:)%hf = Hel(j)
  M2(:)%hf = Hel(j)

  !M(i) corresponds to \Gamma_{i} in Fabios thesis

end subroutine colourvectors


! **********************************************************************
subroutine colint(M, M2colint)
! M(i)   = <M|Ci> colour component of matrix element
! COLINT = <M|M>
!        = Sum_{i,j} <M|Ci> * <Ci|Cj> * <Cj|M>
!        = colour-summed squared matrix element
! K2(i,j) = <Ci|Cj>
! **********************************************************************
  use ol_colourmatrix_ppnnjj_ew_nenexuuuxux_4_/**/REALKIND, only: K1
  implicit none

  complex(REALKIND), intent(in)  :: M(2)
  real(REALKIND),    intent(out) :: M2colint
  integer :: i, j

  M2colint = 0

    do i = 1, 2
      do j = 1, 2
        M2colint = M2colint + real(conjg(M(i))*K1(i,j)*M(j))
      end do
    end do

end subroutine colint

! **********************************************************************
subroutine colint_ct(M, Mct, M2colint_ct, l)
! M(i)   = <M|Ci> colour component of matrix element
! COLINT = <M|M>
!        = Sum_{i,j} <M|Ci> * <Ci|Cj> * <Cj|M>
!        = colour-summed squared matrix element
! K2(i,j) = <Ci|Cj>
! **********************************************************************
  use ol_colourmatrix_ppnnjj_ew_nenexuuuxux_4_/**/REALKIND, only: K2
  implicit none
  complex(REALKIND), intent(in)  :: M(2), Mct(2)
  real(REALKIND),    intent(out) :: M2colint_ct
  integer, intent(in) :: l
  integer ::  i, j

  M2colint_ct = 0

  do i = 1, 2
    do j = 1, 2
      M2colint_ct = M2colint_ct + real(conjg(M(i))*K2(i+2*l,j)*Mct(j))
    end do
  end do

end subroutine colint_ct

! **********************************************************************
subroutine colint_IR(M, M2IRadd)
! M(i)   = <M|Ci> colour component of matrix element
! K1(i,j) = .....
! **********************************************************************
  use ol_colourmatrix_ppnnjj_ew_nenexuuuxux_4_/**/REALKIND, only: K1
  implicit none

  complex(REALKIND), intent(in)  :: M(2)
  real(REALKIND),    intent(out) :: M2IRadd(22)
  integer ::  i, j, k, colmatpos

  M2IRadd = 0

  do k = 1, 23-1
    colmatpos = 2*k
    do i = 1, 2
      do j = 1, 2
        M2IRadd(k) = M2IRadd(k) + real(conjg(M(i))*K1(i+colmatpos,j)*M(j))
      end do
    end do
  end do

end subroutine colint_IR

! **********************************************************************
subroutine colintmunu(M1, M2, M2colint)
! M1(i)    = <M1|Ci> colour component of matrix element
! M2(i)    = <M2|Ci> colour component of matrix element
! M2colint = <M1|M2>
!          = Sum_{i,j} <M1|Ci> * <Ci|Cj> * <Cj|M2>
!          = colour-summed squared matrix element
! K2(i,j) = <Ci|Cj>
! **********************************************************************
  use ol_colourmatrix_ppnnjj_ew_nenexuuuxux_4_/**/REALKIND, only: K2
  implicit none

  complex(REALKIND), intent(in)  :: M1(2)
  complex(REALKIND), intent(in)  :: M2(2)
  complex(REALKIND),    intent(out) :: M2colint
  integer :: i, j

  M2colint = 0

  do i = 1, 2
    do j = 1, 2
      M2colint = M2colint + M1(i)*K2(i,j)*conjg(M2(j))
    end do
  end do

end subroutine colintmunu





! **********************************************************************
subroutine colborninterf(M, M0_col, l)
! M(i)         = <M|Ci> colour component of matrix element
! M0_col(i)    = <M2|Ci> colour component of matrix element,
!                see \tilde{M}_{j} in Fabios thesis
! M2colint = Sum_{i} <M1|Ci> * <Ci|Cj>
!          = colour-summed squared matrix element
! KL(i,j) = <Ci|Cj> with elements Cj of 1-loop colour basis
! **********************************************************************
  use ol_colourmatrix_ppnnjj_ew_nenexuuuxux_4_/**/REALKIND, only: KL
  implicit none

  type(Hpolcont), intent(in)  :: M(2)
  type(Hpolcont), intent(out)  :: M0_col(2)
  integer, intent(in) :: l
  integer :: i, j

  do j = 1, 2 !size(KL(1,:))
    M0_col(j)%j = 0
    M0_col(j)%hf = M(1)%hf
    do i = 1, 2 !size(KL(:,1))
      M0_col(j)%j = M0_col(j)%j  + conjg(M(i)%j)*KL(i+2*l,j)
    end do
  end do

end subroutine colborninterf

end subroutine amp2

end module ol_loop_ppnnjj_ew_nenexuuuxux_4_/**/REALKIND
