
module ol_colourmatrix_ppnnjj_ew_nenexbbxaa_2_/**/REALKIND
  use KIND_TYPES, only: REALKIND
  implicit none
  logical, save           :: colmat_not_initialised = .true.
  complex(REALKIND), save :: K1(23,1), K2(1,1), KL(1,1), Cas(6) = 0
  contains
  subroutine colourmatrix_init
    use ol_parameters_decl_/**/REALKIND, only: CI
    implicit none
    integer :: k, co
    colmat_not_initialised = .false.
    ! colour matrix

  K1( 1,:) = [ 3]
  K1( 2,:) = [ 0]
  K1( 3,:) = [ 0]
  K1( 4,:) = [ 0]
  K1( 5,:) = [ 0]
  K1( 6,:) = [ 0]
  K1( 7,:) = [ 0]
  K1( 8,:) = [ 0]
  K1( 9,:) = [ 0]
  K1(10,:) = [ 0]
  K1(11,:) = [ 0]
  K1(12,:) = [ 0]
  K1(13,:) = [ 0]
  K1(14,:) = [ 0]
  K1(15,:) = [ 0]
  K1(16,:) = [ 0]
  K1(17,:) = [ 0]
  K1(18,:) = [ 0]
  K1(19,:) = [ 0]
  K1(20,:) = [ 0]
  K1(21,:) = [ 0]
  K1(22,:) = [ 0]
  K1(23,:) = [ 3]

  K2(1,:) = [ 3]

  KL(1,:) = [ 3]

#if -1 > 0
    co = 0
    do k = 1, 6
      co = co + k
      Cas(k) = K1(1+1*co,1)/K1(1,1)
    end do
#endif
  end subroutine colourmatrix_init
end module ol_colourmatrix_ppnnjj_ew_nenexbbxaa_2_/**/REALKIND



module ol_forced_parameters_ppnnjj_ew_nenexbbxaa_2_/**/REALKIND
  implicit none
  contains
  subroutine check_forced_parameters
    use ol_parameters_decl_/**/REALKIND
    use ol_loop_parameters_decl_/**/REALKIND
#ifndef PRECISION_dp
    use ol_loop_parameters_decl_/**/DREALKIND, only: LeadingColour, nc, nf, CKMORDER
#endif
    implicit none
    logical, save :: checks_not_written = .true.

    if (checks_not_written) then
    ! e.g.
    ! if (ME /= 0) write(*,101) 'ME = 0'
  if (ME /= 0) write(*,101) 'ME = 0'
  if (CKMORDER /= 0) write(*,101) 'CKMORDER = 0'
  if (nc /= 3) write(*,101) 'nc = 3'
  if (nf /= 6) write(*,101) 'nf = 6'
  if (MU /= 0) write(*,101) 'MU = 0'
  if (MD /= 0) write(*,101) 'MD = 0'
  if (MS /= 0) write(*,101) 'MS = 0'
  if (MC /= 0) write(*,101) 'MC = 0'
  if (LeadingColour /= 0) write(*,101) 'LeadingColour = 0'
  if (wMB /= 0) write(*,101) 'wMB = 0'
  if (wMB /= 0) write(*,101) 'wMB = 0'


    checks_not_written = .false.
    end if

    101 format('[OpenLoops] === WARNING ===',/,'[OpenLoops] code was generated with ',A,/,'[OpenLoops] ===============')
  end subroutine check_forced_parameters
end module ol_forced_parameters_ppnnjj_ew_nenexbbxaa_2_/**/REALKIND


! **********************************************************************
module ol_loop_storage_ppnnjj_ew_nenexbbxaa_2_/**/REALKIND
! **********************************************************************
  use KIND_TYPES, only: REALKIND, intkind1, intkind2
  use ol_data_types_/**/REALKIND, only: wfun, Hpolcont

#ifdef PRECISION_dp
  integer(intkind1), save :: ntry = 1, ntryL = 1
  integer(intkind1), save :: p_switch = 0 ! switch for dp or qp. Used for memory allocation of the OL types
  ! the following are flags for memory allocation of the hol coefficients in dp or qp
  logical, save :: dp_not_alloc = .TRUE., qp_not_alloc = .TRUE.
  integer, save :: n_merge_steps  ! total number of merging steps
  integer, save :: n_merge_mism   ! number of merging mismatches
  integer, save :: merge_step = 1 ! current merging step
  integer(intkind2), save, allocatable :: merge_tables(:,:,:) ! merging tables
  integer(intkind2), save, allocatable :: merge_mism(:)       ! array of merging mismatches
  integer(intkind2), save, allocatable :: merge_hels(:)       ! array with relevant helicities for a merging step
  logical, save :: merge_tables_on = .false.
  integer(intkind2), parameter :: nheltot = 64 ! number of helicity configurations
  integer(intkind2), save :: nhel = 64 ! number of non-vanishing helicity configurations (adapted at runtime)
  integer(intkind2), save :: Hel(64) ! physical helicity states
#endif

  complex(REALKIND), save :: den(213)

  ! external wave functions ex1(h1),... for h<n> helicities
  type(wfun) :: ex1(2), ex2(2), ex3(2), ex4(2), ex5(2), ex6(2)

  ! wf<h>(h,n) n wave functions with h helicity configurations
  type(wfun) :: wf4(4,43), wf8(8,71), wf16(16,79), wf64(64,84)

  ! diagram prefactors
  integer,           save :: fac_status_loop1 = -1, fac_status_loop2 = -1
  complex(REALKIND), save :: f(216), c(206)

  !Vector in helicity and colour space for Born-Loop interference
  type(Hpolcont),   save :: M0_col1_helarray(1,64), M0M1_hel_cc(1,64,22)
  complex(REALKIND), save :: M2ctcc(22)

end module ol_loop_storage_ppnnjj_ew_nenexbbxaa_2_/**/REALKIND






! **********************************************************************
module ol_loop_ppnnjj_ew_nenexbbxaa_2_/**/REALKIND
! **********************************************************************
  use KIND_TYPES, only: REALKIND, DREALKIND, intkind1, intkind2
  use ol_data_types_/**/REALKIND, only: wfun, Hpolcont
  use ol_loop_storage_ppnnjj_ew_nenexbbxaa_2_/**/REALKIND
  implicit none

!*********************************************************************************
  contains

! **********************************************************************
subroutine fac_init_loop()
! Writes diagram prefactors to 'f', rsp. 'c'
! **********************************************************************
  use ol_parameters_decl_/**/REALKIND
  use ol_loop_parameters_decl_/**/REALKIND
  use ol_init, only: set_parameter, tree_parameters_flush, parameters_flush
#ifndef PRECISION_dp
  use ol_loop_parameters_decl_/**/DREALKIND, only: SwF, SwB
!  use ol_loop_parameters_decl_/**/DREALKIND, only: DOI
#endif
  implicit none
  call set_parameter("ew_renorm", 1)
  if (parameters_status == 0) call tree_parameters_flush()
  if (loop_parameters_status == 0) call parameters_flush()
  fac_status_loop1 = parameters_status
  fac_status_loop2 = loop_parameters_status
  ! factors of the diagrams
    f(  1) = (CI*eQED**4)/9._/**/REALKIND
    f(  2) = (CI*countertermnorm*eQED**6)/27._/**/REALKIND
    f(  3) = (CI*countertermnorm*eQED**6)/9._/**/REALKIND
    f(  4) = (CI*countertermnorm*eQED**6)/3._/**/REALKIND
    f(  5) = (CI*countertermnorm*eQED**6*EWctR2AAAZ)/3._/**/REALKIND
    f(  6) = CI*countertermnorm*eQED**6*EWctR2AAZZ
    f(  7) = (CI*countertermnorm*eQED**6*EWctHAA*MB)/(4._/**/REALKIND*cw*MW*sw**2)
    f(  8) = (countertermnorm*eQED**6*MB)/(MW*sw*18._/**/REALKIND)
    f(  9) = (CI*countertermnorm*eQED**6*EWctHAA*MB)/(2._/**/REALKIND*MW*sw)
    f( 10) = (CI*countertermnorm*eQED**6*EWctHZA*MB)/(6._/**/REALKIND*MW*sw)
    f( 11) = (CI*countertermnorm*eQED**6*EWctHAA*MW)/(cw**2*sw)
    f( 12) = (eQED**6*integralnorm*SwB)/81._/**/REALKIND
    f( 13) = (eQED**6*integralnorm*SwB)/9._/**/REALKIND
    f( 14) = (eQED**6*integralnorm*SwB)/3._/**/REALKIND
    f( 15) = (2*eQED**6*integralnorm*SwB)/3._/**/REALKIND
    f( 16) = (eQED**6*integralnorm*MW**2*SwB)/3._/**/REALKIND
    f( 17) = eQED**6*integralnorm*MW**2*SwB
    f( 18) = (eQED**6*integralnorm*SwB)/(sw**4*36._/**/REALKIND)
    f( 19) = (eQED**6*integralnorm*SwB)/(sw**4*18._/**/REALKIND)
    f( 20) = (eQED**6*integralnorm*SwB)/(sw**4*12._/**/REALKIND)
    f( 21) = (eQED**6*integralnorm*SwB)/(sw**4*9._/**/REALKIND)
    f( 22) = (eQED**6*integralnorm*SwB)/(sw**4*6._/**/REALKIND)
    f( 23) = (eQED**6*integralnorm*SwB)/(sw**4*4._/**/REALKIND)
    f( 24) = (eQED**6*integralnorm*MB*SwB)/(sw**4*36._/**/REALKIND)
    f( 25) = (eQED**6*integralnorm*MB*SwB)/(sw**4*24._/**/REALKIND)
    f( 26) = (eQED**6*integralnorm*MB*SwB)/(sw**4*12._/**/REALKIND)
    f( 27) = (eQED**6*integralnorm*MB*SwB)/(sw**4*8._/**/REALKIND)
    f( 28) = (eQED**6*integralnorm*MB*SwB)/(sw**4*4._/**/REALKIND)
    f( 29) = (eQED**6*integralnorm*MB*MH**2*SwB)/(sw**4*8._/**/REALKIND)
    f( 30) = (eQED**6*integralnorm*MW**2*SwB)/(sw**4*4._/**/REALKIND)
    f( 31) = (eQED**6*integralnorm*MB*MW**2*SwB)/(sw**4*4._/**/REALKIND)
    f( 32) = (cw*eQED**6*integralnorm*SwB)/(sw**3*18._/**/REALKIND)
    f( 33) = (cw*eQED**6*integralnorm*SwB)/(sw**3*9._/**/REALKIND)
    f( 34) = (cw*eQED**6*integralnorm*SwB)/(sw**3*6._/**/REALKIND)
    f( 35) = (2*cw*eQED**6*integralnorm*SwB)/(sw**3*9._/**/REALKIND)
    f( 36) = (cw*eQED**6*integralnorm*SwB)/(sw**3*3._/**/REALKIND)
    f( 37) = (cw*eQED**6*integralnorm*SwB)/(sw**3*2._/**/REALKIND)
    f( 38) = (eQED**6*integralnorm*MB*SwB)/(cw**3*sw**3*36._/**/REALKIND)
    f( 39) = (eQED**6*integralnorm*MB*SwB)/(cw*sw**3*8._/**/REALKIND)
    f( 40) = (eQED**6*integralnorm*MB*SwB)/(cw*sw**3*4._/**/REALKIND)
    f( 41) = (eQED**6*integralnorm*MB*SwB)/(cw*sw**3*2._/**/REALKIND)
    f( 42) = (cw*eQED**6*integralnorm*MB*SwB)/(sw**3*36._/**/REALKIND)
    f( 43) = (cw*eQED**6*integralnorm*MB*SwB)/(sw**3*18._/**/REALKIND)
    f( 44) = (cw*eQED**6*integralnorm*MB*SwB)/(sw**3*12._/**/REALKIND)
    f( 45) = (cw*eQED**6*integralnorm*MB*SwB)/(sw**3*6._/**/REALKIND)
    f( 46) = (cw*eQED**6*integralnorm*MB*SwB)/(sw**3*4._/**/REALKIND)
    f( 47) = (cw*eQED**6*integralnorm*MB*SwB)/(sw**3*2._/**/REALKIND)
    f( 48) = (eQED**6*integralnorm*MB*MH**2*SwB)/(cw*sw**3*8._/**/REALKIND)
    f( 49) = (cw*eQED**6*integralnorm*MB*MH**2*SwB)/(sw**3*4._/**/REALKIND)
    f( 50) = (eQED**6*integralnorm*MB**2*SwB)/(cw*MW**2*sw**3*72._/**/REALKIND)
    f( 51) = (eQED**6*integralnorm*MB*MH**2*SwB)/(cw*MW**2*sw**3*72._/**/REALKIND)
    f( 52) = (eQED**6*integralnorm*MB*MH**2*SwB)/(cw*MW**2*sw**3*8._/**/REALKIND)
    f( 53) = (eQED**6*integralnorm*MB*MH**2*SwB)/(cw*MW**2*sw**3*4._/**/REALKIND)
    f( 54) = (cw*eQED**6*integralnorm*MW**2*SwB)/(sw**3*2._/**/REALKIND)
    f( 55) = (eQED**6*integralnorm*MB*MW**2*SwB)/(cw*sw**3*4._/**/REALKIND)
    f( 56) = (eQED**6*integralnorm*MB*MW**2*SwB)/(cw*sw**3*2._/**/REALKIND)
    f( 57) = (cw*eQED**6*integralnorm*MB*MW**2*SwB)/(sw**3*2._/**/REALKIND)
    f( 58) = (eQED**6*integralnorm*SwB)/(sw**2*54._/**/REALKIND)
    f( 59) = (eQED**6*integralnorm*SwB)/(sw**2*18._/**/REALKIND)
    f( 60) = (eQED**6*integralnorm*SwB)/(sw**2*9._/**/REALKIND)
    f( 61) = (eQED**6*integralnorm*SwB)/(sw**2*6._/**/REALKIND)
    f( 62) = (2*eQED**6*integralnorm*SwB)/(sw**2*9._/**/REALKIND)
    f( 63) = (eQED**6*integralnorm*SwB)/(sw**2*3._/**/REALKIND)
    f( 64) = (eQED**6*integralnorm*SwB)/(sw**2*2._/**/REALKIND)
    f( 65) = (eQED**6*integralnorm*SwB)/(cw**2*sw**2*36._/**/REALKIND)
    f( 66) = (cw**2*eQED**6*integralnorm*SwB)/(sw**2*9._/**/REALKIND)
    f( 67) = (cw**2*eQED**6*integralnorm*SwB)/(sw**2*3._/**/REALKIND)
    f( 68) = (cw**2*eQED**6*integralnorm*SwB)/sw**2
    f( 69) = (eQED**6*integralnorm*MB*SwB)/(sw**2*4._/**/REALKIND)
    f( 70) = (eQED**6*integralnorm*MB*SwB)/(sw**2*2._/**/REALKIND)
    f( 71) = (eQED**6*integralnorm*MB*SwB)/(cw**2*sw**2*18._/**/REALKIND)
    f( 72) = (eQED**6*integralnorm*MH**2*SwB)/(cw**2*sw**2*2._/**/REALKIND)
    f( 73) = (eQED**6*integralnorm*MH**2*SwB)/(cw**2*sw**2)
    f( 74) = (eQED**6*integralnorm*MB*MH**2*SwB)/(sw**2*4._/**/REALKIND)
    f( 75) = (eQED**6*integralnorm*SwB)/(MW**2*sw**2*18._/**/REALKIND)
    f( 76) = (eQED**6*integralnorm*SwB)/(MW**2*sw**2*9._/**/REALKIND)
    f( 77) = (eQED**6*integralnorm*SwB)/(MW**2*sw**2*6._/**/REALKIND)
    f( 78) = (2*eQED**6*integralnorm*SwB)/(MW**2*sw**2*9._/**/REALKIND)
    f( 79) = (eQED**6*integralnorm*SwB)/(MW**2*sw**2*3._/**/REALKIND)
    f( 80) = (eQED**6*integralnorm*SwB)/(MW**2*sw**2*2._/**/REALKIND)
    f( 81) = (eQED**6*integralnorm*SwB)/(MW**2*sw**2)
    f( 82) = (eQED**6*integralnorm*MB**2*SwB)/(MW**2*sw**2*36._/**/REALKIND)
    f( 83) = (eQED**6*integralnorm*MB*MH**2*SwB)/(MW**2*sw**2*4._/**/REALKIND)
    f( 84) = (eQED**6*integralnorm*MB*MH**2*SwB)/(MW**2*sw**2*2._/**/REALKIND)
    f( 85) = (eQED**6*integralnorm*MW**2*SwB)/(sw**2*18._/**/REALKIND)
    f( 86) = (eQED**6*integralnorm*MW**2*SwB)/(sw**2*6._/**/REALKIND)
    f( 87) = (eQED**6*integralnorm*MW**2*SwB)/(sw**2*2._/**/REALKIND)
    f( 88) = (eQED**6*integralnorm*MW**2*SwB)/(cw**4*sw**2*9._/**/REALKIND)
    f( 89) = (eQED**6*integralnorm*MW**2*SwB)/(cw**2*sw**2*2._/**/REALKIND)
    f( 90) = (eQED**6*integralnorm*MW**2*SwB)/(cw**2*sw**2)
    f( 91) = (cw**2*eQED**6*integralnorm*MW**2*SwB)/sw**2
    f( 92) = (eQED**6*integralnorm*MB*MW**2*SwB)/(sw**2*2._/**/REALKIND)
    f( 93) = (eQED**6*integralnorm*MH**2*MW**2*SwB)/(cw**2*sw**2*2._/**/REALKIND)
    f( 94) = (eQED**6*integralnorm*MW**4*SwB)/(cw**2*sw**2)
    f( 95) = (eQED**6*integralnorm*SwB)/(cw*sw*18._/**/REALKIND)
    f( 96) = (eQED**6*integralnorm*SwB)/(cw*sw*9._/**/REALKIND)
    f( 97) = (eQED**6*integralnorm*SwB)/(cw*sw*6._/**/REALKIND)
    f( 98) = (2*eQED**6*integralnorm*SwB)/(cw*sw*9._/**/REALKIND)
    f( 99) = (eQED**6*integralnorm*SwB)/(cw*sw*3._/**/REALKIND)
    f(100) = (eQED**6*integralnorm*SwB)/(cw*sw*2._/**/REALKIND)
    f(101) = (eQED**6*integralnorm*SwB)/(cw*sw)
    f(102) = (cw*eQED**6*integralnorm*SwB)/(sw*27._/**/REALKIND)
    f(103) = (cw*eQED**6*integralnorm*SwB)/(sw*9._/**/REALKIND)
    f(104) = (cw*eQED**6*integralnorm*SwB)/(sw*3._/**/REALKIND)
    f(105) = (cw*eQED**6*integralnorm*SwB)/sw
    f(106) = (eQED**6*integralnorm*MB*SwB)/(cw*sw*36._/**/REALKIND)
    f(107) = (eQED**6*integralnorm*MB*SwB)/(cw*sw*12._/**/REALKIND)
    f(108) = (eQED**6*integralnorm*MB*SwB)/(cw*sw*4._/**/REALKIND)
    f(109) = (eQED**6*integralnorm*MB*SwB)/(cw*sw*2._/**/REALKIND)
    f(110) = (eQED**6*integralnorm*MB*MH**2*SwB)/(cw*sw*12._/**/REALKIND)
    f(111) = (eQED**6*integralnorm*MB*MH**2*SwB)/(cw*sw*4._/**/REALKIND)
    f(112) = (eQED**6*integralnorm*MW**2*SwB)/(cw*sw*6._/**/REALKIND)
    f(113) = (eQED**6*integralnorm*MW**2*SwB)/(cw*sw*3._/**/REALKIND)
    f(114) = (eQED**6*integralnorm*MW**2*SwB)/(cw*sw*2._/**/REALKIND)
    f(115) = (cw*eQED**6*integralnorm*MW**2*SwB)/(sw*9._/**/REALKIND)
    f(116) = (cw*eQED**6*integralnorm*MW**2*SwB)/(sw*3._/**/REALKIND)
    f(117) = (cw*eQED**6*integralnorm*MW**2*SwB)/sw
    f(118) = (eQED**6*integralnorm*MB*MW**2*SwB)/(cw**3*sw*2._/**/REALKIND)
    f(119) = (eQED**6*integralnorm*MB*MW**2*SwB)/(cw*sw*6._/**/REALKIND)
    f(120) = (eQED**6*integralnorm*MB*MW**2*SwB)/(cw*sw*4._/**/REALKIND)
    f(121) = (eQED**6*integralnorm*MB*MW**2*SwB)/(cw*sw*2._/**/REALKIND)
    f(122) = (eQED**6*integralnorm*MW**2*sw*SwB)/(cw*27._/**/REALKIND)
    f(123) = (eQED**6*integralnorm*MW**2*sw*SwB)/(cw*9._/**/REALKIND)
    f(124) = (eQED**6*integralnorm*MW**2*sw*SwB)/(cw*3._/**/REALKIND)
    f(125) = (2*eQED**6*integralnorm*MW**2*sw*SwB)/(cw*3._/**/REALKIND)
    f(126) = (eQED**6*integralnorm*MW**2*sw*SwB)/cw
    f(127) = (eQED**6*integralnorm*MW**4*sw*SwB)/(cw*3._/**/REALKIND)
    f(128) = (eQED**6*integralnorm*MW**2*sw**2*SwB)/(cw**2*9._/**/REALKIND)
    f(129) = (eQED**6*integralnorm*MW**2*sw**2*SwB)/(cw**2*3._/**/REALKIND)
    f(130) = (eQED**6*integralnorm*MW**2*sw**2*SwB)/cw**2
    f(131) = (2*eQED**6*integralnorm*MW**2*sw**2*SwB)/cw**2
    f(132) = (eQED**6*integralnorm*MW**4*sw**2*SwB)/cw**2
    f(133) = (eQED**6*integralnorm*MW**2*(cw - sw)*(cw + sw)*SwB)/(sw**2*2._/**/REALKIND)
    f(134) = -((eQED**6*integralnorm*(cw - sw)*(cw + sw)*SwB)/(cw*sw**3*12._/**/REALKIND))
    f(135) = -((eQED**6*integralnorm*(cw - sw)*(cw + sw)*SwB)/(cw*sw**3*6._/**/REALKIND))
    f(136) = -((eQED**6*integralnorm*(cw - sw)*(cw + sw)*SwB)/(cw*sw**3*4._/**/REALKIND))
    f(137) = -((eQED**6*integralnorm*(cw - sw)*(cw + sw)*SwB)/(cw*sw**3*2._/**/REALKIND))
    f(138) = -((eQED**6*integralnorm*MB*(cw - sw)*(cw + sw)*SwB)/(cw**3*sw**3*4._/**/REALKIND))
    f(139) = -((eQED**6*integralnorm*MB*(cw - sw)*(cw + sw)*SwB)/(cw**3*sw**3*2._/**/REALKIND))
    f(140) = -((eQED**6*integralnorm*MB*(cw - sw)*(cw + sw)*SwB)/(cw*sw**3*24._/**/REALKIND))
    f(141) = -((eQED**6*integralnorm*MB*(cw - sw)*(cw + sw)*SwB)/(cw*sw**3*8._/**/REALKIND))
    f(142) = -((eQED**6*integralnorm*MB*(cw - sw)*(cw + sw)*SwB)/(cw*sw**3*4._/**/REALKIND))
    f(143) = -((eQED**6*integralnorm*MB*MH**2*(cw - sw)*(cw + sw)*SwB)/(cw*sw**3*8._/**/REALKIND))
    f(144) = -((eQED**6*integralnorm*(cw - sw)*(cw + sw)*SwB)/(cw*MW**2*sw**3*36._/**/REALKIND))
    f(145) = -((eQED**6*integralnorm*(cw - sw)*(cw + sw)*SwB)/(cw*MW**2*sw**3*18._/**/REALKIND))
    f(146) = -((eQED**6*integralnorm*(cw - sw)*(cw + sw)*SwB)/(cw*MW**2*sw**3*12._/**/REALKIND))
    f(147) = -((eQED**6*integralnorm*(cw - sw)*(cw + sw)*SwB)/(cw*MW**2*sw**3*9._/**/REALKIND))
    f(148) = -((eQED**6*integralnorm*(cw - sw)*(cw + sw)*SwB)/(cw*MW**2*sw**3*6._/**/REALKIND))
    f(149) = -((eQED**6*integralnorm*(cw - sw)*(cw + sw)*SwB)/(cw*MW**2*sw**3*4._/**/REALKIND))
    f(150) = -((eQED**6*integralnorm*(cw - sw)*(cw + sw)*SwB)/(cw*MW**2*sw**3*3._/**/REALKIND))
    f(151) = -((eQED**6*integralnorm*(cw - sw)*(cw + sw)*SwB)/(cw*MW**2*sw**3*2._/**/REALKIND))
    f(152) = -((eQED**6*integralnorm*MB*MH**2*(cw - sw)*(cw + sw)*SwB)/(cw*MW**2*sw**3*72._/**/REALKIND))
    f(153) = -((eQED**6*integralnorm*MB*MH**2*(cw - sw)*(cw + sw)*SwB)/(cw*MW**2*sw**3*24._/**/REALKIND))
    f(154) = -((eQED**6*integralnorm*MB*MH**2*(cw - sw)*(cw + sw)*SwB)/(cw*MW**2*sw**3*12._/**/REALKIND))
    f(155) = -((eQED**6*integralnorm*MB*MH**2*(cw - sw)*(cw + sw)*SwB)/(cw*MW**2*sw**3*8._/**/REALKIND))
    f(156) = -((eQED**6*integralnorm*MB*MH**2*(cw - sw)*(cw + sw)*SwB)/(cw*MW**2*sw**3*4._/**/REALKIND))
    f(157) = -((eQED**6*integralnorm*MW**2*(cw - sw)*(cw + sw)*SwB)/(cw*sw**3*4._/**/REALKIND))
    f(158) = -((eQED**6*integralnorm*MB*MW**2*(cw - sw)*(cw + sw)*SwB)/(cw**3*sw**3*4._/**/REALKIND))
    f(159) = -((eQED**6*integralnorm*MB*MW**2*(cw - sw)*(cw + sw)*SwB)/(cw*sw**3*4._/**/REALKIND))
    f(160) = -((eQED**6*integralnorm*(cw - sw)*(cw + sw)*SwB)/(cw*sw*54._/**/REALKIND))
    f(161) = -((eQED**6*integralnorm*(cw - sw)*(cw + sw)*SwB)/(cw*sw*18._/**/REALKIND))
    f(162) = -((eQED**6*integralnorm*(cw - sw)*(cw + sw)*SwB)/(cw*sw*9._/**/REALKIND))
    f(163) = -((eQED**6*integralnorm*(cw - sw)*(cw + sw)*SwB)/(cw*sw*6._/**/REALKIND))
    f(164) = -((eQED**6*integralnorm*(cw - sw)*(cw + sw)*SwB)/(cw*sw*3._/**/REALKIND))
    f(165) = -((eQED**6*integralnorm*(cw - sw)*(cw + sw)*SwB)/(cw*sw*2._/**/REALKIND))
    f(166) = (-2*eQED**6*integralnorm*(cw - sw)*(cw + sw)*SwB)/(cw*sw*3._/**/REALKIND)
    f(167) = -((eQED**6*integralnorm*(cw - sw)*(cw + sw)*SwB)/(cw*sw))
    f(168) = -((eQED**6*integralnorm*MW**2*(cw - sw)*(cw + sw)*SwB)/(cw*sw*18._/**/REALKIND))
    f(169) = -((eQED**6*integralnorm*MW**2*(cw - sw)*(cw + sw)*SwB)/(cw*sw*6._/**/REALKIND))
    f(170) = -((eQED**6*integralnorm*MW**2*(cw - sw)*(cw + sw)*SwB)/(cw*sw*3._/**/REALKIND))
    f(171) = -((eQED**6*integralnorm*MW**2*(cw - sw)*(cw + sw)*SwB)/(cw*sw*2._/**/REALKIND))
    f(172) = (eQED**6*integralnorm*SwB*(cw**4*18._/**/REALKIND + sw**4*18._/**/REALKIND  &
      - cw**2*sw**2*36._/**/REALKIND))/(cw**2*sw**2*18._/**/REALKIND*36._/**/REALKIND)
    f(173) = (eQED**6*integralnorm*SwB*(-(cw**2*sw**2*12._/**/REALKIND) + cw**4*6._/**/REALKIND  &
      + sw**4*6._/**/REALKIND))/(cw**2*sw**2*12._/**/REALKIND*6._/**/REALKIND)
    f(174) = (eQED**6*integralnorm*SwB*(cw**4*3._/**/REALKIND + sw**4*3._/**/REALKIND  &
      - cw**2*sw**2*6._/**/REALKIND))/(cw**2*sw**2*3._/**/REALKIND*6._/**/REALKIND)
    f(175) = (eQED**6*integralnorm*SwB*(cw**4*2._/**/REALKIND + sw**4*2._/**/REALKIND  &
      - cw**2*sw**2*4._/**/REALKIND))/(cw**2*sw**2*2._/**/REALKIND*4._/**/REALKIND)
    f(176) = (eQED**6*integralnorm*SwB*(cw**4 + sw**4 - cw**2*sw**2*2._/**/REALKIND))/(cw**2*sw**2*2._/**/REALKIND)
    f(177) = (eQED**6*integralnorm*(cw - sw)**2*(cw + sw)**2*SwB)/(cw**2*sw**2)
    f(178) = -((eQED**6*integralnorm*MW**2*(cw - sw)*(cw + sw)*SwB)/(cw**2*6._/**/REALKIND))
    f(179) = (eQED**6*integralnorm*MW**2*SwB*(cw**4*2._/**/REALKIND + sw**4*2._/**/REALKIND  &
      - cw**2*sw**2*4._/**/REALKIND))/(cw**2*sw**2*2._/**/REALKIND*4._/**/REALKIND)
    f(180) = -((eQED**6*integralnorm*MW**2*(cw - sw)*(cw + sw)*SwB)/(cw**2*2._/**/REALKIND))
    f(181) = (eQED**6*integralnorm*MW**2*SwB*(cw**4 + sw**4 - cw**2*sw**2*2._/**/REALKIND))/(cw**2*sw**2*2._/**/REALKIND)
    f(182) = -((eQED**6*integralnorm*MW**2*(cw - sw)*(cw + sw)*SwB)/cw**2)
    f(183) = (eQED**6*integralnorm*SwF)/81._/**/REALKIND
    f(184) = (2*eQED**6*integralnorm*SwF)/81._/**/REALKIND
    f(185) = (eQED**6*integralnorm*SwF)/27._/**/REALKIND
    f(186) = (4*eQED**6*integralnorm*SwF)/81._/**/REALKIND
    f(187) = (8*eQED**6*integralnorm*SwF)/81._/**/REALKIND
    f(188) = (eQED**6*integralnorm*SwF)/9._/**/REALKIND
    f(189) = (16*eQED**6*integralnorm*SwF)/81._/**/REALKIND
    f(190) = (2*eQED**6*integralnorm*SwF)/9._/**/REALKIND
    f(191) = (eQED**6*integralnorm*SwF)/3._/**/REALKIND
    f(192) = (4*eQED**6*integralnorm*SwF)/9._/**/REALKIND
    f(193) = (8*eQED**6*integralnorm*SwF)/9._/**/REALKIND
    f(194) = eQED**6*integralnorm*SwF
    f(195) = (eQED**6*integralnorm*MB**2*SwF)/(cw*MW**2*sw**3*72._/**/REALKIND)
    f(196) = (eQED**6*integralnorm*MB*ML*SwF)/(cw*MW**2*sw**3*8._/**/REALKIND)
    f(197) = (eQED**6*integralnorm*MB*MM*SwF)/(cw*MW**2*sw**3*8._/**/REALKIND)
    f(198) = (eQED**6*integralnorm*MB*MT*SwF)/(cw*MW**2*sw**3*18._/**/REALKIND)
    f(199) = (eQED**6*integralnorm*MB*SwF)/(cw**2*sw**2*18._/**/REALKIND)
    f(200) = (eQED**6*integralnorm*MB*SwF)/(cw**2*sw**2*9._/**/REALKIND)
    f(201) = (2*eQED**6*integralnorm*MB*SwF)/(cw**2*sw**2*9._/**/REALKIND)
    f(202) = (4*eQED**6*integralnorm*MB*SwF)/(cw**2*sw**2*9._/**/REALKIND)
    f(203) = (eQED**6*integralnorm*MB*SwF)/(cw**2*sw**2*2._/**/REALKIND)
    f(204) = (eQED**6*integralnorm*ML*SwF)/(cw**2*sw**2*2._/**/REALKIND)
    f(205) = (eQED**6*integralnorm*MM*SwF)/(cw**2*sw**2*2._/**/REALKIND)
    f(206) = (2*eQED**6*integralnorm*MT*SwF)/(cw**2*sw**2*9._/**/REALKIND)
    f(207) = (eQED**6*integralnorm*MB**2*SwF)/(MW**2*sw**2*36._/**/REALKIND)
    f(208) = (eQED**6*integralnorm*MB*ML*SwF)/(MW**2*sw**2*36._/**/REALKIND)
    f(209) = (eQED**6*integralnorm*MB*ML*SwF)/(MW**2*sw**2*12._/**/REALKIND)
    f(210) = (eQED**6*integralnorm*MB*ML*SwF)/(MW**2*sw**2*4._/**/REALKIND)
    f(211) = (eQED**6*integralnorm*MB*MM*SwF)/(MW**2*sw**2*36._/**/REALKIND)
    f(212) = (eQED**6*integralnorm*MB*MM*SwF)/(MW**2*sw**2*12._/**/REALKIND)
    f(213) = (eQED**6*integralnorm*MB*MM*SwF)/(MW**2*sw**2*4._/**/REALKIND)
    f(214) = (eQED**6*integralnorm*MB*MT*SwF)/(MW**2*sw**2*36._/**/REALKIND)
    f(215) = (eQED**6*integralnorm*MB*MT*SwF)/(MW**2*sw**2*18._/**/REALKIND)
    f(216) = (eQED**6*integralnorm*MB*MT*SwF)/(MW**2*sw**2*9._/**/REALKIND)

  c = [ f(12), f(13), f(14), f(15), f(16), f(17), f(18), f(19), f(20), f(21), f(22), f(23), f(24), f(25), f(26), f(27), f(28) &
    , f(29), f(30), f(31), f(32), f(33), f(34), f(35), f(36), f(37), f(38), f(39), f(40), f(41), f(42), f(43), f(44), f(45), f(46) &
    , f(47), f(48), f(49), f(50), f(51), f(52), f(53), f(54), f(55), f(56), f(57), f(58), f(59), f(60), f(61), f(62), f(63), f(64) &
    , f(65), f(66), f(67), f(68), f(69), f(70), f(71), f(72), f(73), f(74), f(75), f(76), f(77), f(78), f(79), f(80), f(81), f(82) &
    , f(83), f(84), f(85), f(86), f(87), f(88), f(89), f(90), f(91), f(92), f(93), f(94), f(95), f(96), f(97), f(98), f(99) &
    , f(100), f(101), f(102), f(103), f(104), f(105), f(106), f(107), f(108), f(109), f(110), f(111), f(112), f(113), f(114) &
    , f(115), f(116), f(117), f(118), f(119), f(120), f(121), f(122), f(123), f(124), f(125), f(126), f(127), f(128), f(129) &
    , f(130), f(131), f(132), f(133), f(134), f(135), f(136), f(137), f(138), f(139), f(140), f(141), f(142), f(143), f(144) &
    , f(145), f(146), f(147), f(148), f(149), f(150), f(151), f(152), f(153), f(154), f(155), f(156), f(157), f(158), f(159) &
    , f(160), f(161), f(162), f(163), f(164), f(165), f(166), f(167), f(168), f(169), f(170), f(171), f(172), f(173), f(174) &
    , f(175), f(176), f(177), f(178), f(179), f(180), f(181), f(182), 3*f(183), 3*f(184), f(185), 3*f(186), 3*f(187), f(188) &
    , 3*f(188), 3*f(189), 3*f(190), f(191), 3*f(192), 3*f(193), f(194), 3*f(195), f(196), f(197), 3*f(198), 3*f(199), 3*f(200) &
    , 3*f(201), 3*f(202), f(203), f(204), f(205), 3*f(206), 3*f(207), f(208), f(209), f(210), f(211), f(212), f(213), 3*f(214) &
    , 3*f(215), 3*f(216) ]
end subroutine fac_init_loop

subroutine denominators()
  use ol_parameters_decl_/**/REALKIND ! masses
  use ol_momenta_decl_/**/REALKIND, only: L
  implicit none
  ! propagators
  den(1) = 1 /((L(5,3) - MZ2)+L(6,3))
  den(2) = 1 /((L(5,20) - MB2)+L(6,20))
  den(3) = 1 /((L(5,40) - MB2)+L(6,40))
  den(6) = 1 /((L(5,11) - MB2)+L(6,11))
  den(9) = 1 /((L(5,36) - MB2)+L(6,36))
  den(10) = 1 /((L(5,24) - MB2)+L(6,24))
  den(13) = 1 /((L(5,7) - MB2)+L(6,7))
  den(18) = 1 /((L(5,12))+L(6,12))
  den(20) = 1 /((L(5,12) - MZ2)+L(6,12))
  den(22) = 1 /((L(5,48) - MH2)+L(6,48))
  den(24) = 1 /((L(5,28) - MH2)+L(6,28))
  den(29) = 1 /((L(5,44) - MH2)+L(6,44))
  den(35) = 1 /((L(5,52) - MB2)+L(6,52))
  den(42) = 1 /((L(5,56) - MB2)+L(6,56))
  den(47) = 1 /((L(5,34))+L(6,34))
  den(48) = 1 /((L(5,35) - MZ2)+L(6,35))
  den(52) = 1 /((L(5,18))+L(6,18))
  den(53) = 1 /((L(5,19) - MZ2)+L(6,19))
  den(57) = 1 /((L(5,33))+L(6,33))
  den(61) = 1 /((L(5,17))+L(6,17))
  den(65) = 1 /((L(5,3))+L(6,3))
  den(77) = 1 /((L(5,60) - MZ2)+L(6,60))
  den(80) = 1 /((L(5,60))+L(6,60))
  den(84) = 1 /((L(5,43) - MB2)+L(6,43))
  den(87) = 1 /((L(5,23) - MB2)+L(6,23))
  den(103) = 1 /((L(5,27) - MB2)+L(6,27))
  den(106) = 1 /((L(5,39) - MB2)+L(6,39))
  den(124) = 1 /((L(5,12) - MH2)+L(6,12))
  den(125) = 1 /((L(5,13))+L(6,13))
  den(127) = 1 /((L(5,14))+L(6,14))
  den(129) = 1 /((L(5,28))+L(6,28))
  den(131) = 1 /((L(5,28) - MZ2)+L(6,28))
  den(135) = 1 /((L(5,44))+L(6,44))
  den(137) = 1 /((L(5,44) - MZ2)+L(6,44))
  den(142) = 1 /((L(5,15) - MZ2)+L(6,15))
  den(144) = 1 /((L(5,15) - MH2)+L(6,15))
  den(148) = 1 /((L(5,15))+L(6,15))
  den(159) = 1 /((L(5,60) - MH2)+L(6,60))
  den(161) = 1 /((L(5,29))+L(6,29))
  den(163) = 1 /((L(5,30))+L(6,30))
  den(174) = 1 /((L(5,45))+L(6,45))
  den(176) = 1 /((L(5,46))+L(6,46))

  ! denominators
  den(4) = den(1)*den(2)
  den(5) = den(3)*den(4)
  den(7) = den(1)*den(6)
  den(8) = den(2)*den(7)
  den(11) = den(1)*den(9)
  den(12) = den(10)*den(11)
  den(14) = den(1)*den(13)
  den(15) = den(10)*den(14)
  den(16) = den(7)*den(9)
  den(17) = den(3)*den(14)
  den(19) = den(1)*den(18)
  den(21) = den(1)*den(20)
  den(23) = den(21)*den(22)
  den(25) = den(2)*den(24)
  den(26) = den(1)*den(25)
  den(27) = den(10)*den(24)
  den(28) = den(1)*den(27)
  den(30) = den(9)*den(29)
  den(31) = den(1)*den(30)
  den(32) = den(3)*den(29)
  den(33) = den(1)*den(32)
  den(34) = den(14)*den(22)
  den(36) = den(22)*den(35)
  den(37) = den(1)*den(36)
  den(38) = den(2)*den(35)
  den(39) = den(1)*den(38)
  den(40) = den(9)*den(35)
  den(41) = den(1)*den(40)
  den(43) = den(10)*den(42)
  den(44) = den(1)*den(43)
  den(45) = den(3)*den(42)
  den(46) = den(1)*den(45)
  den(49) = den(47)*den(48)
  den(50) = den(2)*den(49)
  den(51) = den(10)*den(49)
  den(54) = den(52)*den(53)
  den(55) = den(9)*den(54)
  den(56) = den(3)*den(54)
  den(58) = den(48)*den(57)
  den(59) = den(2)*den(58)
  den(60) = den(10)*den(58)
  den(62) = den(53)*den(61)
  den(63) = den(9)*den(62)
  den(64) = den(3)*den(62)
  den(66) = den(2)*den(65)
  den(67) = den(3)*den(66)
  den(68) = den(6)*den(65)
  den(69) = den(2)*den(68)
  den(70) = den(9)*den(65)
  den(71) = den(10)*den(70)
  den(72) = den(13)*den(65)
  den(73) = den(10)*den(72)
  den(74) = den(9)*den(68)
  den(75) = den(3)*den(72)
  den(76) = den(2)*den(3)
  den(78) = den(76)*den(77)
  den(79) = den(1)*den(78)
  den(81) = den(76)*den(80)
  den(82) = den(1)*den(81)
  den(83) = den(1)*den(3)
  den(85) = den(83)*den(84)
  den(86) = den(2)*den(85)
  den(88) = den(4)*den(87)
  den(89) = den(3)*den(88)
  den(90) = den(1)**2
  den(91) = den(38)*den(90)
  den(92) = den(1)*den(65)
  den(93) = den(38)*den(92)
  den(94) = den(2)**2
  den(95) = den(7)*den(94)
  den(96) = den(7)*den(38)
  den(97) = den(9)*den(10)
  den(98) = den(77)*den(97)
  den(99) = den(1)*den(98)
  den(100) = den(80)*den(97)
  den(101) = den(1)*den(100)
  den(102) = den(1)*den(10)
  den(104) = den(102)*den(103)
  den(105) = den(9)*den(104)
  den(107) = den(11)*den(106)
  den(108) = den(10)*den(107)
  den(109) = den(43)*den(90)
  den(110) = den(43)*den(92)
  den(111) = den(14)*den(43)
  den(112) = den(10)**2
  den(113) = den(14)*den(112)
  den(114) = den(40)*den(90)
  den(115) = den(40)*den(92)
  den(116) = den(9)**2
  den(117) = den(7)*den(116)
  den(118) = den(7)*den(40)
  den(119) = den(45)*den(90)
  den(120) = den(45)*den(92)
  den(121) = den(14)*den(45)
  den(122) = den(3)**2
  den(123) = den(14)*den(122)
  den(126) = den(20)*den(125)
  den(128) = den(20)*den(127)
  den(130) = den(2)*den(129)
  den(132) = den(2)*den(131)
  den(133) = den(10)*den(129)
  den(134) = den(10)*den(131)
  den(136) = den(9)*den(135)
  den(138) = den(9)*den(137)
  den(139) = den(3)*den(135)
  den(140) = den(3)*den(137)
  den(141) = den(1)*den(124)
  den(143) = den(141)*den(142)
  den(145) = den(21)*den(144)
  den(146) = den(14)*den(144)
  den(147) = den(14)*den(142)
  den(149) = den(14)*den(148)
  den(150) = den(14)*den(87)
  den(151) = den(14)*den(106)
  den(152) = den(7)*den(144)
  den(153) = den(7)*den(142)
  den(154) = den(7)*den(148)
  den(155) = den(7)*den(103)
  den(156) = den(7)*den(84)
  den(157) = den(126)*den(142)
  den(158) = den(128)*den(142)
  den(160) = den(76)*den(159)
  den(162) = den(132)*den(161)
  den(164) = den(132)*den(163)
  den(165) = den(38)*den(159)
  den(166) = den(38)*den(80)
  den(167) = den(38)*den(77)
  den(168) = den(97)*den(159)
  den(169) = den(134)*den(161)
  den(170) = den(134)*den(163)
  den(171) = den(43)*den(159)
  den(172) = den(43)*den(80)
  den(173) = den(43)*den(77)
  den(175) = den(138)*den(174)
  den(177) = den(138)*den(176)
  den(178) = den(40)*den(159)
  den(179) = den(40)*den(80)
  den(180) = den(40)*den(77)
  den(181) = den(140)*den(174)
  den(182) = den(140)*den(176)
  den(183) = den(45)*den(159)
  den(184) = den(45)*den(80)
  den(185) = den(45)*den(77)
  den(186) = den(1)*den(2)*den(3)
  den(187) = den(1)*den(132)
  den(188) = den(1)*den(130)
  den(189) = den(1)*den(9)*den(10)
  den(190) = den(1)*den(134)
  den(191) = den(1)*den(133)
  den(192) = den(1)*den(138)
  den(193) = den(1)*den(136)
  den(194) = den(1)*den(140)
  den(195) = den(1)*den(139)
  den(196) = den(1)*den(160)
  den(197) = den(2)*den(156)
  den(198) = den(1)*den(165)
  den(199) = den(1)*den(167)
  den(200) = den(1)*den(166)
  den(201) = den(1)*den(168)
  den(202) = den(10)*den(151)
  den(203) = den(1)*den(171)
  den(204) = den(1)*den(173)
  den(205) = den(1)*den(172)
  den(206) = den(9)*den(155)
  den(207) = den(1)*den(178)
  den(208) = den(1)*den(180)
  den(209) = den(1)*den(179)
  den(210) = den(3)*den(150)
  den(211) = den(1)*den(183)
  den(212) = den(1)*den(185)
  den(213) = den(1)*den(184)

end subroutine denominators

#ifdef PRECISION_dp
! **********************************************************************
subroutine init_merging_tables(tot_num_hels, tot_num_merge_steps)
!-----------------------------------------------------------------------
! In the first event the merging tables are fully initialised
! **********************************************************************
  implicit none
  integer, intent(in) :: tot_num_hels, tot_num_merge_steps
  n_merge_steps = tot_num_merge_steps
  allocate(merge_tables(tot_num_hels,2,n_merge_steps))
  allocate(merge_mism(n_merge_steps+1))
  allocate(merge_hels(n_merge_steps))
  merge_tables_on = .true.
  merge_mism = 0_intkind2
  merge_tables = -1_intkind2
  merge_hels = -1_intkind2
end subroutine init_merging_tables

! **********************************************************************
subroutine update_merging_tables(tot_num_hels)
!-----------------------------------------------------------------------
! After the first evaluation the merging tables are adapted
! **********************************************************************
  implicit none
  integer, intent(in) :: tot_num_hels
  integer(intkind2), allocatable ::  merge_tables_tmp(:,:,:), merge_hels_tmp(:)

  if(merge_mism(1) == 0) then ! helicity configurations match in all merging steps
    if(allocated(merge_tables)) deallocate(merge_tables)
    if(allocated(merge_hels)) deallocate(merge_hels)
    if(allocated(merge_mism)) deallocate(merge_mism)
    allocate(merge_mism(1))
    allocate(merge_hels(1))
    allocate(merge_tables(1,1,1)) ! dummy allocation
    merge_mism = 0_intkind2
    merge_tables = -1_intkind2
    merge_hels = -1_intkind2
  else
    n_merge_mism = merge_mism(1)
    allocate(merge_tables_tmp(tot_num_hels,2,n_merge_mism))
    merge_tables_tmp(:,:,1:n_merge_mism) = merge_tables(:,:,1:n_merge_mism)
    if(allocated(merge_tables)) then
      deallocate(merge_tables)
      allocate(merge_tables(tot_num_hels,2,n_merge_mism))
    end if
    merge_tables = merge_tables_tmp
    if(allocated(merge_tables_tmp)) deallocate(merge_tables_tmp)
    allocate(merge_hels_tmp(n_merge_mism))
    merge_hels_tmp(1:n_merge_mism) = merge_hels(1:n_merge_mism)
    if(allocated(merge_hels)) then
      deallocate(merge_hels)
      allocate(merge_hels(n_merge_mism))
    end if
    merge_hels = merge_hels_tmp
    if(allocated(merge_hels_tmp)) deallocate(merge_hels_tmp)
  end if
  merge_tables_on = .true.
end subroutine update_merging_tables
#endif


!
!
!
! **********************************************************************
#ifdef PRECISION_dp
subroutine amp2(P_scatt, M02, M2ct, M2colint, qp_kinematics)
#else
subroutine amp2(P_scatt, M02, M2ct, M2colint, qp_kinematics)
  use ol_loop_storage_ppnnjj_ew_nenexbbxaa_2_/**/DREALKIND, only: ntry, nhel, Hel
#endif
! P_scatt(0:3,Npart) = incoming external momenta
! M2  = helicity-summed squared matrix element for nu_e anti-nu_e bottom anti-bottom gamma gamma -> 0
! **********************************************************************
  use ol_parameters_decl_/**/REALKIND !, only: ci, parameters_status, ZERO, scalefactor, >masses<
  use ol_parameters_init_/**/REALKIND, only: ensure_mp_init
  use ol_kinematics_/**/REALKIND, only: init_kinematics
  use ol_momenta_decl_/**/DREALKIND, only: momenta_nan_check
  use ol_data_types_/**/REALKIND
  use ol_h_helicity_bookkeeping_/**/REALKIND, only: &
    & helbookkeeping_wf, helsync, flip_phase
  use ol_helicity_init, only: helbookkeeping_flip, helsync_flip
  use ol_hel_propagators_/**/REALKIND
  use ol_hel_wavefunctions_/**/REALKIND
  use ol_wavefunctions_/**/REALKIND, only: wf_V_Std
  use ol_hel_vertices_/**/REALKIND
  use ol_hel_contractions_/**/REALKIND
  use ol_external_ppnnjj_ew_nenexbbxaa_2, only: &
    & external_perm_ppnnjj_ew_nenexbbxaa_2, &
    & external_perm_inv_ppnnjj_ew_nenexbbxaa_2, &
    & extcomb_perm_ppnnjj_ew_nenexbbxaa_2, &
    & average_factor_ppnnjj_ew_nenexbbxaa_2, &
    & photonid_ppnnjj_ew_nenexbbxaa_2
  use ol_ew_renormalisation_/**/REALKIND, only: photon_factors
  use ol_external_ppnnjj_ew_nenexbbxaa_2, only: &
    & H, hel_not_initialised, hel_init, POLSEL
  use ol_colourmatrix_ppnnjj_ew_nenexbbxaa_2_/**/REALKIND, only: &
    & colmat_not_initialised, colourmatrix_init
  use ol_forced_parameters_ppnnjj_ew_nenexbbxaa_2_/**/REALKIND, only: &
    & check_forced_parameters
  use ol_heltables_OLR_ppnnjj_ew_nenexbbxaa_2
  use ol_kinematics_/**/REALKIND, only: LC2Std_Rep_cmplx
  use ol_h_counterterms_/**/REALKIND
  use ol_loop_parameters_decl_/**/REALKIND ! counterterms
  use ol_loop_parameters_decl_/**/DREALKIND, only: IR_is_on
  use ol_init, only: set_parameter, parameters_flush
#ifdef PRECISION_dp
  use ol_kinematics_/**/QREALKIND, only: conv_mom_scatt2in_qp=>conv_mom_scatt2in, &
                                         internal_momenta_qp=>internal_momenta
  use ol_momenta_decl_/**/DREALKIND, only: L
  use ol_momenta_decl_/**/QREALKIND, only: L_qp=>L
#endif
  implicit none

  real(DREALKIND), intent(in)  :: P_scatt(0:3,6)
  real(REALKIND),  intent(out) :: M02, M2ct, M2colint(22)
  logical, intent(in) :: qp_kinematics

  integer           :: shift, k, r, m, n, i
  real(REALKIND)    :: P(0:3,6)
#ifdef PRECISION_dp
  real(QREALKIND)    :: P_qp(0:3,6)
#endif
  integer           :: extmasses2(6)
  real(REALKIND)    :: M2add, M2add_ct, M2add_colint(22)
  complex(REALKIND) :: M1(1), M2(1)
  real(REALKIND)    :: P_scatt_intern(0:3,6)
  real(REALKIND), save :: scalebackfactor, old_scalefactor = 0
  real(REALKIND)       :: bornphotonfactor
  integer(intkind1) :: nsync
  type(Hpolcont),   save :: M1helarray(1,64)
  type(Hpolcont) :: M1helarray_ct(1,64)
  integer, allocatable :: extcombs_permuted(:)
  integer              :: extcombs(22), nextcombs
#if 6 > 3
  integer :: ind_cc_comb(9)
#endif
  type(Hpolcont) :: A(64,84)

  !Aj are not used at the moment
  !complex(REALKIND) :: Aj(84)

  complex(REALKIND) :: omega(2) ! phases for helicity correlations

  call set_parameter("ew_renorm", 1)
  call parameters_flush()
  call ensure_mp_init()

  if (colmat_not_initialised) call colourmatrix_init()

  if (fac_status_loop1 /= parameters_status .or. fac_status_loop2 /= loop_parameters_status) then
    ! Note: if fac_init would only be called when parameters changed which are relevant for the factors,
    ! a different 'status' would have to be used, because forced_parameters should be called after every parameter change.
    call check_forced_parameters()
    call fac_init_loop()
  end if

  if (momenta_nan_check(P_scatt) /= 0) then
    M02 = 0
    return
  end if

  extmasses2 = [ 0, 0, nMB, nMB, 0, 0 ]
  ! Convert 2 -> n-2 PS-point to n -> 0 (so that P(1) + ... + P(n) = 0) and compute
  ! internal-propagator momenta in light-cone representation
  call init_kinematics(P_scatt, extmasses2, P, &
     external_perm_inv_ppnnjj_ew_nenexbbxaa_2, 6, qp_kinematics)

  ! denominators
  call denominators()

   if (heltables_not_init) call init_heltables()

  ! external WFs
  ! Here the external wavefunctions are initialiased
  call pol_wf_Q(P(:,1), rZERO, H1, ex1, POLSEL(1),1)
  call pol_wf_A(P(:,2), rZERO, H2, ex2, POLSEL(2),2)
  call pol_wf_Q(P(:,3), rMB, H3, ex3, POLSEL(3),3)
  call pol_wf_A(P(:,4), rMB, H4, ex4, POLSEL(4),4)
  call pol_wf_V(P(:,5), rZERO, H5, ex5, POLSEL(5),5)
  call pol_wf_V(P(:,6), rZERO, H6, ex6, POLSEL(6),6)



  ! internal WFs
  ! e.g. call vert_VQ_A(ntry, ex3, ex1, wf1, n1, t1) ...
  call vert_QA_Z(gZn,ntry, ex1(:), ex2(:), wf4(:,1), n3(:,1), t3x4(:,:,1))
  call vert_VQ_A(ntry, ex5(:), ex3(:), wf4(:,2), n3(:,2), t3x4(:,:,2))
  call vert_AV_Q(ntry, ex4(:), ex6(:), wf4(:,3), n3(:,3), t3x4(:,:,3))
  call prop_Q_A(ntry, wf4(:,2), 20, MB, 1_intkind1, wf4(:,4), n2(1))
  call prop_A_Q(ntry, wf4(:,3), 40, MB, 1_intkind1, wf4(:,5), n2(2))
  call vert_ZQ_A(gZd,ntry, wf4(:,1), wf4(:,4), wf16(:,1), n3(:,4), t3x16(:,:,1))
  call vert_AZ_Q(gZd,ntry, ex4(:), wf4(:,1), wf8(:,1), n3(:,5), t3x8(:,:,1))
  call vert_VQ_A(ntry, ex6(:), wf4(:,4), wf8(:,2), n3(:,6), t3x8(:,:,2))
  call prop_A_Q(ntry, wf8(:,1), 11, MB, 1_intkind1, wf8(:,3), n2(3))
  call vert_VQ_A(ntry, ex6(:), ex3(:), wf4(:,6), n3(:,7), t3x4(:,:,4))
  call vert_AV_Q(ntry, ex4(:), ex5(:), wf4(:,7), n3(:,8), t3x4(:,:,5))
  call prop_Q_A(ntry, wf4(:,6), 36, MB, 1_intkind1, wf4(:,8), n2(4))
  call prop_A_Q(ntry, wf4(:,7), 24, MB, 1_intkind1, wf4(:,9), n2(5))
  call vert_ZQ_A(gZd,ntry, wf4(:,1), wf4(:,8), wf16(:,2), n3(:,9), t3x16(:,:,2))
  call vert_ZQ_A(gZd,ntry, wf4(:,1), ex3(:), wf8(:,4), n3(:,10), t3x8(:,:,3))
  call vert_AV_Q(ntry, wf4(:,9), ex6(:), wf8(:,5), n3(:,11), t3x8(:,:,4))
  call prop_Q_A(ntry, wf8(:,4), 7, MB, 1_intkind1, wf8(:,6), n2(6))
  call vert_VQ_A(ntry, ex5(:), wf4(:,8), wf8(:,7), n3(:,12), t3x8(:,:,5))
  call vert_AV_Q(ntry, wf4(:,5), ex5(:), wf8(:,8), n3(:,13), t3x8(:,:,6))
  call vert_QA_V(ntry, ex3(:), ex4(:), wf4(:,10), n3(:,14), t3x4(:,:,6))
  call counter_VVV_V(ntry, wf4(:,1), ex5(:), ex6(:), wf16(:,3), n4(:,1), t4x16(:,:,1))
  call vert_QA_Z(gZd,ntry, ex3(:), ex4(:), wf4(:,11), n3(:,15), t3x4(:,:,7))
  call vert_AQ_S(gX,ntry, ex4(:), ex3(:), wf4(:,12), n3(:,16), t3x4(:,:,8))
  call counter_VV_S(ntry, ex5(:), ex6(:), wf4(:,13), n3(:,17), t3x4(:,:,9))
  call vert_VS_T(ntry, wf4(:,1), 3, wf4(:,12), 12, wf16(:,4), n3(:,18), t3x16(:,:,3))
  call vert_VV_S(ntry, wf4(:,1), wf4(:,11), wf16(:,5), n3(:,19), t3x16(:,:,4))
  call counter_ZQ_A(EWctVbb,ntry, wf4(:,1), wf4(:,4), wf16(:,6), n3(:,20), t3x16(:,:,5))
  call counter_VQ_A_LR(EWctAbb,ntry, ex6(:), wf4(:,4), wf8(:,9), n3(:,21), t3x8(:,:,7))
  call vert_AQ_S(gH,ntry, ex4(:), wf4(:,4), wf8(:,10), n3(:,22), t3x8(:,:,8))
  call counter_VV_S(ntry, wf4(:,1), ex6(:), wf8(:,11), n3(:,23), t3x8(:,:,9))
  call counter_ZQ_A(EWctVbb,ntry, wf4(:,1), wf4(:,8), wf16(:,7), n3(:,24), t3x16(:,:,6))
  call counter_AV_Q_LR(EWctAbb,ntry, wf4(:,9), ex6(:), wf8(:,12), n3(:,25), t3x8(:,:,10))
  call vert_AQ_S(gH,ntry, wf4(:,9), ex3(:), wf8(:,13), n3(:,26), t3x8(:,:,11))
  call counter_VQ_A_LR(EWctAbb,ntry, ex5(:), wf4(:,8), wf8(:,14), n3(:,27), t3x8(:,:,12))
  call vert_AQ_S(gH,ntry, ex4(:), wf4(:,8), wf8(:,15), n3(:,28), t3x8(:,:,13))
  call counter_VV_S(ntry, wf4(:,1), ex5(:), wf8(:,16), n3(:,29), t3x8(:,:,14))
  call counter_AV_Q_LR(EWctAbb,ntry, wf4(:,5), ex5(:), wf8(:,17), n3(:,30), t3x8(:,:,15))
  call vert_AQ_S(gH,ntry, wf4(:,5), ex3(:), wf8(:,18), n3(:,31), t3x8(:,:,16))
  call vert_SA_Q(gH,ntry, wf4(:,13), ex4(:), wf8(:,19), n3(:,32), t3x8(:,:,17))
  call vert_QS_A(gH,ntry, ex3(:), wf4(:,13), wf8(:,20), n3(:,33), t3x8(:,:,18))
  call prop_Q_A(ntry, wf8(:,20), 52, MB, 1_intkind1, wf8(:,21), n2(7))
  call counter_AZ_Q(EWctVbb,ntry, ex4(:), wf4(:,1), wf8(:,22), n3(:,34), t3x8(:,:,19))
  call prop_Q_A(ntry, wf8(:,2), 52, MB, 1_intkind1, wf8(:,23), n2(8))
  call counter_AV_Q_LR(EWctAbb,ntry, ex4(:), ex6(:), wf4(:,14), n3(:,35), t3x4(:,:,10))
  call prop_A_Q(ntry, wf4(:,14), 40, MB, 1_intkind1, wf4(:,15), n2(9))
  call prop_Q_A(ntry, wf8(:,7), 52, MB, 1_intkind1, wf8(:,24), n2(10))
  call vert_AV_Q(ntry, wf4(:,15), ex5(:), wf8(:,25), n3(:,36), t3x8(:,:,20))
  call counter_AV_Q_LR(EWctAbb,ntry, ex4(:), ex5(:), wf4(:,16), n3(:,37), t3x4(:,:,11))
  call prop_A_Q(ntry, wf4(:,16), 24, MB, 1_intkind1, wf4(:,17), n2(11))
  call vert_AV_Q(ntry, wf4(:,17), ex6(:), wf8(:,26), n3(:,38), t3x8(:,:,21))
  call counter_ZQ_A(EWctVbb,ntry, wf4(:,1), ex3(:), wf8(:,27), n3(:,39), t3x8(:,:,22))
  call prop_A_Q(ntry, wf8(:,5), 56, MB, 1_intkind1, wf8(:,28), n2(12))
  call counter_VQ_A_LR(EWctAbb,ntry, ex6(:), ex3(:), wf4(:,18), n3(:,40), t3x4(:,:,12))
  call prop_Q_A(ntry, wf4(:,18), 36, MB, 1_intkind1, wf4(:,19), n2(13))
  call vert_ZQ_A(gZd,ntry, wf4(:,1), wf4(:,19), wf16(:,8), n3(:,41), t3x16(:,:,7))
  call prop_A_Q(ntry, wf8(:,8), 56, MB, 1_intkind1, wf8(:,29), n2(14))
  call vert_VQ_A(ntry, ex5(:), wf4(:,19), wf8(:,30), n3(:,42), t3x8(:,:,23))
  call counter_VQ_A_LR(EWctAbb,ntry, ex5(:), ex3(:), wf4(:,20), n3(:,43), t3x4(:,:,13))
  call prop_Q_A(ntry, wf4(:,20), 20, MB, 1_intkind1, wf4(:,21), n2(15))
  call vert_ZQ_A(gZd,ntry, wf4(:,1), wf4(:,21), wf16(:,9), n3(:,44), t3x16(:,:,8))
  call vert_VQ_A(ntry, ex6(:), wf4(:,21), wf8(:,31), n3(:,45), t3x8(:,:,24))
  call counter_AZ_Q(EWctAnn,ntry, ex2(:), ex6(:), wf4(:,22), n3(:,46), t3x4(:,:,14))
  call prop_A_Q(ntry, wf4(:,22), 34, ZERO, 0_intkind1, wf4(:,23), n2(16))
  call vert_QA_Z(gZn,ntry, ex1(:), wf4(:,23), wf8(:,32), n3(:,47), t3x8(:,:,25))
  call vert_QA_Z(gZd,ntry, wf4(:,4), ex4(:), wf8(:,33), n3(:,48), t3x8(:,:,26))
  call vert_QA_Z(gZd,ntry, ex3(:), wf4(:,9), wf8(:,34), n3(:,49), t3x8(:,:,27))
  call counter_AZ_Q(EWctAnn,ntry, ex2(:), ex5(:), wf4(:,24), n3(:,50), t3x4(:,:,15))
  call prop_A_Q(ntry, wf4(:,24), 18, ZERO, 0_intkind1, wf4(:,25), n2(17))
  call vert_QA_Z(gZn,ntry, ex1(:), wf4(:,25), wf8(:,35), n3(:,51), t3x8(:,:,28))
  call vert_QA_Z(gZd,ntry, wf4(:,8), ex4(:), wf8(:,36), n3(:,52), t3x8(:,:,29))
  call vert_QA_Z(gZd,ntry, ex3(:), wf4(:,5), wf8(:,37), n3(:,53), t3x8(:,:,30))
  call counter_ZQ_A(EWctAnn,ntry, ex6(:), ex1(:), wf4(:,26), n3(:,54), t3x4(:,:,16))
  call prop_Q_A(ntry, wf4(:,26), 33, ZERO, 0_intkind1, wf4(:,27), n2(18))
  call vert_QA_Z(gZn,ntry, wf4(:,27), ex2(:), wf8(:,38), n3(:,55), t3x8(:,:,31))
  call counter_ZQ_A(EWctAnn,ntry, ex5(:), ex1(:), wf4(:,28), n3(:,56), t3x4(:,:,17))
  call prop_Q_A(ntry, wf4(:,28), 17, ZERO, 0_intkind1, wf4(:,29), n2(19))
  call vert_QA_Z(gZn,ntry, wf4(:,29), ex2(:), wf8(:,39), n3(:,57), t3x8(:,:,32))
  call counter_QA_Z(EWctAnn,ntry, ex1(:), ex2(:), wf4(:,30), n3(:,58), t3x4(:,:,18))
  call vert_VQ_A(ntry, wf4(:,30), wf4(:,4), wf16(:,10), n3(:,59), t3x16(:,:,9))
  call counter_QA_Z(EWctVnn,ntry, ex1(:), ex2(:), wf4(:,31), n3(:,60), t3x4(:,:,19))
  call vert_ZQ_A(gZd,ntry, wf4(:,31), wf4(:,4), wf16(:,11), n3(:,61), t3x16(:,:,10))
  call vert_AV_Q(ntry, ex4(:), wf4(:,30), wf8(:,40), n3(:,62), t3x8(:,:,33))
  call prop_A_Q(ntry, wf8(:,40), 11, MB, 1_intkind1, wf8(:,41), n2(20))
  call vert_AZ_Q(gZd,ntry, ex4(:), wf4(:,31), wf8(:,42), n3(:,63), t3x8(:,:,34))
  call prop_A_Q(ntry, wf8(:,42), 11, MB, 1_intkind1, wf8(:,43), n2(21))
  call vert_VQ_A(ntry, wf4(:,30), wf4(:,8), wf16(:,12), n3(:,64), t3x16(:,:,11))
  call vert_ZQ_A(gZd,ntry, wf4(:,31), wf4(:,8), wf16(:,13), n3(:,65), t3x16(:,:,12))
  call vert_VQ_A(ntry, wf4(:,30), ex3(:), wf8(:,44), n3(:,66), t3x8(:,:,35))
  call prop_Q_A(ntry, wf8(:,44), 7, MB, 1_intkind1, wf8(:,45), n2(22))
  call vert_ZQ_A(gZd,ntry, wf4(:,31), ex3(:), wf8(:,46), n3(:,67), t3x8(:,:,36))
  call prop_Q_A(ntry, wf8(:,46), 7, MB, 1_intkind1, wf8(:,47), n2(23))
  call vert_AQ_S(gX,ntry, wf4(:,5), wf4(:,4), wf16(:,14), n3(:,68), t3x16(:,:,13))
  call counter_V_S(EWctXZ,ntry, wf4(:,1), 3, wf4(:,32), n2(24))
  call vert_QA_V(ntry, wf4(:,4), wf4(:,5), wf16(:,15), n3(:,69), t3x16(:,:,14))
  call counter_V_V(EWctAZ,ntry, wf4(:,1), 3, wf4(:,33), n2(25))
  call vert_QA_Z(gZd,ntry, wf4(:,4), wf4(:,5), wf16(:,16), n3(:,70), t3x16(:,:,15))
  call counter_V_V(EWctZZ,ntry, wf4(:,1), 3, wf4(:,34), n2(26))
  call vert_AZ_Q(gZd,ntry, wf4(:,5), wf4(:,1), wf16(:,17), n3(:,71), t3x16(:,:,16))
  call counter_Q_A_LR(EWctbb,ntry, wf4(:,4), 20, wf4(:,35), n2(27))
  call prop_A_Q(ntry, wf16(:,17), 43, MB, 1_intkind1, wf16(:,18), n2(28))
  call counter_A_Q_LR(EWctbb,ntry, wf4(:,5), 40, wf4(:,36), n2(29))
  call prop_Q_A(ntry, wf16(:,1), 23, MB, 1_intkind1, wf16(:,19), n2(30))
  call vert_SA_Q(gX,ntry, wf4(:,32), ex4(:), wf8(:,48), n3(:,72), t3x8(:,:,37))
  call vert_AV_Q(ntry, ex4(:), wf4(:,33), wf8(:,49), n3(:,73), t3x8(:,:,38))
  call vert_AZ_Q(gZd,ntry, ex4(:), wf4(:,34), wf8(:,50), n3(:,74), t3x8(:,:,39))
  call prop_Q_A(ntry, wf4(:,35), 20, MB, 1_intkind1, wf4(:,37), n2(31))
  call vert_VQ_A(ntry, ex6(:), wf4(:,37), wf8(:,51), n3(:,75), t3x8(:,:,40))
  call counter_A_Q_LR(EWctbb,ntry, wf8(:,3), 11, wf8(:,52), n2(32))
  call vert_AQ_S(gX,ntry, wf4(:,9), wf4(:,8), wf16(:,20), n3(:,76), t3x16(:,:,17))
  call vert_QA_V(ntry, wf4(:,8), wf4(:,9), wf16(:,21), n3(:,77), t3x16(:,:,18))
  call vert_QA_Z(gZd,ntry, wf4(:,8), wf4(:,9), wf16(:,22), n3(:,78), t3x16(:,:,19))
  call vert_AZ_Q(gZd,ntry, wf4(:,9), wf4(:,1), wf16(:,23), n3(:,79), t3x16(:,:,20))
  call counter_Q_A_LR(EWctbb,ntry, wf4(:,8), 36, wf4(:,38), n2(33))
  call prop_A_Q(ntry, wf16(:,23), 27, MB, 1_intkind1, wf16(:,24), n2(34))
  call counter_A_Q_LR(EWctbb,ntry, wf4(:,9), 24, wf4(:,39), n2(35))
  call prop_Q_A(ntry, wf16(:,2), 39, MB, 1_intkind1, wf16(:,25), n2(36))
  call vert_QS_A(gX,ntry, ex3(:), wf4(:,32), wf8(:,53), n3(:,80), t3x8(:,:,41))
  call vert_VQ_A(ntry, wf4(:,33), ex3(:), wf8(:,54), n3(:,81), t3x8(:,:,42))
  call vert_ZQ_A(gZd,ntry, wf4(:,34), ex3(:), wf8(:,55), n3(:,82), t3x8(:,:,43))
  call counter_Q_A_LR(EWctbb,ntry, wf8(:,6), 7, wf8(:,56), n2(37))
  call prop_A_Q(ntry, wf4(:,39), 24, MB, 1_intkind1, wf4(:,40), n2(38))
  call vert_AV_Q(ntry, wf4(:,40), ex6(:), wf8(:,57), n3(:,83), t3x8(:,:,44))
  call prop_Q_A(ntry, wf4(:,38), 36, MB, 1_intkind1, wf4(:,41), n2(39))
  call vert_VQ_A(ntry, ex5(:), wf4(:,41), wf8(:,58), n3(:,84), t3x8(:,:,45))
  call prop_A_Q(ntry, wf4(:,36), 40, MB, 1_intkind1, wf4(:,42), n2(40))
  call vert_AV_Q(ntry, wf4(:,42), ex5(:), wf8(:,59), n3(:,85), t3x8(:,:,46))
  call vert_AQ_S(gH,ntry, ex4(:), ex3(:), wf4(:,43), n3(:,86), t3x4(:,:,20))
  call vert_ZQ_A(gZn,ntry, wf4(:,11), ex1(:), wf8(:,60), n3(:,87), t3x8(:,:,47))
  call prop_Q_A(ntry, wf8(:,60), 13, ZERO, 0_intkind1, wf8(:,61), n2(41))
  call vert_AZ_Q(gZn,ntry, ex2(:), wf4(:,11), wf8(:,62), n3(:,88), t3x8(:,:,48))
  call prop_A_Q(ntry, wf8(:,62), 14, ZERO, 0_intkind1, wf8(:,63), n2(42))
  call vert_QA_V(ntry, wf4(:,4), ex4(:), wf8(:,64), n3(:,89), t3x8(:,:,49))
  call vert_QA_V(ntry, ex3(:), wf4(:,9), wf8(:,65), n3(:,90), t3x8(:,:,50))
  call vert_QA_V(ntry, wf4(:,8), ex4(:), wf8(:,66), n3(:,91), t3x8(:,:,51))
  call vert_QA_V(ntry, ex3(:), wf4(:,5), wf8(:,67), n3(:,92), t3x8(:,:,52))
  call vert_TV_S(ntry, wf4(:,43), 12, wf4(:,1), 3, wf16(:,26), n3(:,93), t3x16(:,:,21))
  call vert_SV_V(ntry, wf4(:,43), wf4(:,1), wf16(:,27), n3(:,94), t3x16(:,:,22))
  call vert_AQ_S(gX,ntry, ex4(:), wf4(:,4), wf8(:,68), n3(:,95), t3x8(:,:,53))
  call vert_AQ_S(gX,ntry, wf4(:,9), ex3(:), wf8(:,69), n3(:,96), t3x8(:,:,54))
  call vert_AQ_S(gX,ntry, ex4(:), wf4(:,8), wf8(:,70), n3(:,97), t3x8(:,:,55))
  call vert_AQ_S(gX,ntry, wf4(:,5), ex3(:), wf8(:,71), n3(:,98), t3x8(:,:,56))
  call vert_AQ_S(gH,ntry, ex4(:), wf8(:,6), wf16(:,28), n3(:,99), t3x16(:,:,23))
  call vert_AQ_S(gX,ntry, ex4(:), wf8(:,6), wf16(:,29), n3(:,100), t3x16(:,:,24))
  call vert_QA_V(ntry, wf8(:,6), ex4(:), wf16(:,30), n3(:,101), t3x16(:,:,25))
  call vert_QA_Z(gZd,ntry, wf8(:,6), ex4(:), wf16(:,31), n3(:,102), t3x16(:,:,26))
  call vert_VQ_A(ntry, ex5(:), wf8(:,6), wf16(:,32), n3(:,103), t3x16(:,:,27))
  call prop_Q_A(ntry, wf16(:,32), 23, MB, 1_intkind1, wf16(:,33), n2(43))
  call vert_VQ_A(ntry, ex6(:), wf8(:,6), wf16(:,34), n3(:,104), t3x16(:,:,28))
  call prop_Q_A(ntry, wf16(:,34), 39, MB, 1_intkind1, wf16(:,35), n2(44))
  call vert_AQ_S(gH,ntry, wf8(:,3), ex3(:), wf16(:,36), n3(:,105), t3x16(:,:,29))
  call vert_AQ_S(gX,ntry, wf8(:,3), ex3(:), wf16(:,37), n3(:,106), t3x16(:,:,30))
  call vert_QA_V(ntry, ex3(:), wf8(:,3), wf16(:,38), n3(:,107), t3x16(:,:,31))
  call vert_QA_Z(gZd,ntry, ex3(:), wf8(:,3), wf16(:,39), n3(:,108), t3x16(:,:,32))
  call vert_AV_Q(ntry, wf8(:,3), ex5(:), wf16(:,40), n3(:,109), t3x16(:,:,33))
  call prop_A_Q(ntry, wf16(:,40), 27, MB, 1_intkind1, wf16(:,41), n2(45))
  call vert_AV_Q(ntry, wf8(:,3), ex6(:), wf16(:,42), n3(:,110), t3x16(:,:,34))
  call prop_A_Q(ntry, wf16(:,42), 43, MB, 1_intkind1, wf16(:,43), n2(46))
  call vert_QA_Z(gZn,ntry, wf8(:,61), ex2(:), wf16(:,44), n3(:,111), t3x16(:,:,35))
  call vert_QA_Z(gZn,ntry, ex1(:), wf8(:,63), wf16(:,45), n3(:,112), t3x16(:,:,36))
  call vert_AQ_S(gH,ntry, wf4(:,5), wf4(:,4), wf16(:,46), n3(:,113), t3x16(:,:,37))
  call vert_ZQ_A(gZn,ntry, wf8(:,33), ex1(:), wf16(:,47), n3(:,114), t3x16(:,:,38))
  call prop_Q_A(ntry, wf16(:,47), 29, ZERO, 0_intkind1, wf16(:,48), n2(47))
  call vert_AZ_Q(gZn,ntry, ex2(:), wf8(:,33), wf16(:,49), n3(:,115), t3x16(:,:,39))
  call prop_A_Q(ntry, wf16(:,49), 30, ZERO, 0_intkind1, wf16(:,50), n2(48))
  call vert_AQ_S(gH,ntry, ex4(:), wf8(:,23), wf16(:,51), n3(:,116), t3x16(:,:,40))
  call vert_QA_V(ntry, wf8(:,23), ex4(:), wf16(:,52), n3(:,117), t3x16(:,:,41))
  call vert_QA_Z(gZd,ntry, wf8(:,23), ex4(:), wf16(:,53), n3(:,118), t3x16(:,:,42))
  call vert_AQ_S(gH,ntry, wf4(:,9), wf4(:,8), wf16(:,54), n3(:,119), t3x16(:,:,43))
  call vert_ZQ_A(gZn,ntry, wf8(:,34), ex1(:), wf16(:,55), n3(:,120), t3x16(:,:,44))
  call prop_Q_A(ntry, wf16(:,55), 29, ZERO, 0_intkind1, wf16(:,56), n2(49))
  call vert_AZ_Q(gZn,ntry, ex2(:), wf8(:,34), wf16(:,57), n3(:,121), t3x16(:,:,45))
  call prop_A_Q(ntry, wf16(:,57), 30, ZERO, 0_intkind1, wf16(:,58), n2(50))
  call vert_AQ_S(gH,ntry, wf8(:,28), ex3(:), wf16(:,59), n3(:,122), t3x16(:,:,46))
  call vert_QA_V(ntry, ex3(:), wf8(:,28), wf16(:,60), n3(:,123), t3x16(:,:,47))
  call vert_QA_Z(gZd,ntry, ex3(:), wf8(:,28), wf16(:,61), n3(:,124), t3x16(:,:,48))
  call vert_ZQ_A(gZn,ntry, wf8(:,36), ex1(:), wf16(:,62), n3(:,125), t3x16(:,:,49))
  call prop_Q_A(ntry, wf16(:,62), 45, ZERO, 0_intkind1, wf16(:,63), n2(51))
  call vert_AZ_Q(gZn,ntry, ex2(:), wf8(:,36), wf16(:,64), n3(:,126), t3x16(:,:,50))
  call prop_A_Q(ntry, wf16(:,64), 46, ZERO, 0_intkind1, wf16(:,65), n2(52))
  call vert_AQ_S(gH,ntry, ex4(:), wf8(:,24), wf16(:,66), n3(:,127), t3x16(:,:,51))
  call vert_QA_V(ntry, wf8(:,24), ex4(:), wf16(:,67), n3(:,128), t3x16(:,:,52))
  call vert_QA_Z(gZd,ntry, wf8(:,24), ex4(:), wf16(:,68), n3(:,129), t3x16(:,:,53))
  call vert_ZQ_A(gZn,ntry, wf8(:,37), ex1(:), wf16(:,69), n3(:,130), t3x16(:,:,54))
  call prop_Q_A(ntry, wf16(:,69), 45, ZERO, 0_intkind1, wf16(:,70), n2(53))
  call vert_AZ_Q(gZn,ntry, ex2(:), wf8(:,37), wf16(:,71), n3(:,131), t3x16(:,:,55))
  call prop_A_Q(ntry, wf16(:,71), 46, ZERO, 0_intkind1, wf16(:,72), n2(54))
  call vert_AQ_S(gH,ntry, wf8(:,29), ex3(:), wf16(:,73), n3(:,132), t3x16(:,:,56))
  call vert_QA_V(ntry, ex3(:), wf8(:,29), wf16(:,74), n3(:,133), t3x16(:,:,57))
  call vert_QA_Z(gZd,ntry, ex3(:), wf8(:,29), wf16(:,75), n3(:,134), t3x16(:,:,58))
  call vert_AQ_S(gX,ntry, ex4(:), wf8(:,23), wf16(:,76), n3(:,135), t3x16(:,:,59))
  call vert_AQ_S(gX,ntry, wf8(:,28), ex3(:), wf16(:,77), n3(:,136), t3x16(:,:,60))
  call vert_AQ_S(gX,ntry, ex4(:), wf8(:,24), wf16(:,78), n3(:,137), t3x16(:,:,61))
  call vert_AQ_S(gX,ntry, wf8(:,29), ex3(:), wf16(:,79), n3(:,138), t3x16(:,:,62))


  call init_hybrid_exwf(ex1)
  call init_hybrid_exwf(ex2)
  call init_hybrid_exwf(ex3)
  call init_hybrid_exwf(ex4)
  call init_hybrid_exwf(ex5)
  call init_hybrid_exwf(ex6)
  call init_hybrid_wf(wf4)
  call init_hybrid_wf(wf8)
  call init_hybrid_wf(wf16)


  if (ntry==1) then
    call physical_helicities()
  end if

  ! computation of the colour-stripped amplitudes
  do nsync = ntry+ntry-1, ntry+1  !  nsync = 1,2  for 1st point and nsync = 3 later
    call diagrams()
    if (nsync == 1) call helsync(nsync, A, nhel, Hel)
  end do

  ! In the following loop the coefficients \Gamma_{i} of the expansion in
  ! the colour basis are computed for every helicity state and stored in M1helarray.
  ! Also the colour vector for the Born-loop interference is computed and saved in
  ! M0_col1_helarray
  do k = 1, nhel
    call colourvectors(A, k, M1helarray(:,k),M1helarray_ct(:,k))
    call colborninterf(M1helarray(:,k), M0_col1_helarray(:,k), 0)
  end do
  M1helarray(:,nhel+1:)%j = 0
  M0_col1_helarray(:,nhel+1:)%hf = -1_intkind2
  M0_col1_helarray(:,nhel+1:)%j = 0

  M2add = 0
  M2add_ct = 0
  M2add_colint = 0

  M02 = 0
  M2ct = 0
  M2colint = 0

  do k = 1, nhel
    call colint(M1helarray(:,k)%j, M2add)
    call colint_ct(M1helarray(:,k)%j, M1helarray_ct(:,k)%j, M2add_ct, 0)
    if (IR_is_on > 0) then
      call colint_IR(M1helarray(:,k)%j, M2add_colint)
    end if
    !summation over helicity configurations
    M02 = M02 + M2add
    M2ct = M2ct + M2add_ct
    M2colint = M2colint + M2add_colint
  end do

  call photon_factors(photonid_ppnnjj_ew_nenexbbxaa_2, &
                    &  0, bornphotonfactor)
  M02 = bornphotonfactor * M02
  M2ct = bornphotonfactor * M2ct
  M2colint = bornphotonfactor * M2colint

  !! used for born-loop colour-correlators
  extcombs = [(i, i = 0, 22-1)]
  nextcombs = 6*(6+1)/2 + 1
  if(nextcombs>0) then
    allocate(extcombs_permuted(nextcombs))
  end if
  do k = 1, nextcombs
    extcombs_permuted(k) = extcomb_perm_ppnnjj_ew_nenexbbxaa_2(extcombs(k))
  end do

#if -1 > 0 && 6 > 3
  !!Born-loop colour correlators interference

  M0M1_hel_cc(:,:,:)%j = 0
  do n = 1, 9
    M2add_ct = 0
    m = ind_cc_comb(n)
      do k = 1, nhel
        call colint_ct(M1helarray(:,k)%j, M1helarray_ct(:,k)%j, M2add_ct, m)
        call colborninterf(M1helarray(:,k), M0M1_hel_cc(:,k,m), m)
        M2ctcc(m) = M2ctcc(m) + M2add_ct
      end do
  end do
  M0M1_hel_cc(:,nhel+1:,:)%hf = -1_intkind2
  M0M1_hel_cc(:,nhel+1:,:)%j = 0
#endif


  contains

subroutine physical_helicities()
  implicit none

integer :: i1,i2,i3,i4,i5,i6
integer :: n

n=0

do i6= 1, 2
do i5= 1, 2
do i4= 1, 2
do i3= 1, 2
do i2= 1, 2
do i1= 1, 2
n = n + 1
 if((ex1(i1)%hf==-1_intkind2) .OR. (ex2(i2)%hf==-1_intkind2) .OR. (ex3(i3)%hf==-1_intkind2) .OR. (ex4(i4)%hf==-1_intkind2)  &
    .OR. (ex5(i5)%hf==-1_intkind2) .OR. (ex6(i6)%hf==-1_intkind2)) then
  Hel(n) = -1_intkind2
 else
  Hel(n) = ex1(i1)%hf + ex2(i2)%hf + ex3(i3)%hf + ex4(i4)%hf + ex5(i5)%hf + ex6(i6)%hf
 end if
end do
end do
end do
end do
end do
end do

end subroutine physical_helicities

subroutine diagrams()
  implicit none
  integer :: h
  ! e.g. call cont_VV(nsync, wf3, wf6, A(:,1), n64, t64, nhel, den(5)) ...

    call Hcont_QA(nsync, wf4(:,5), wf16(:,1), A(:,1), n3(:,139), t3x64(:,:,1), nhel, den(5))
    call Hcont_QA(nsync, wf8(:,2), wf8(:,3), A(:,2), n3(:,140), t3x64(:,:,2), nhel, den(8))
    call Hcont_QA(nsync, wf4(:,9), wf16(:,2), A(:,3), n3(:,141), t3x64(:,:,3), nhel, den(12))
    call Hcont_QA(nsync, wf8(:,5), wf8(:,6), A(:,4), n3(:,142), t3x64(:,:,4), nhel, den(15))
    call Hcont_QA(nsync, wf8(:,3), wf8(:,7), A(:,5), n3(:,143), t3x64(:,:,5), nhel, den(16))
    call Hcont_QA(nsync, wf8(:,6), wf8(:,8), A(:,6), n3(:,144), t3x64(:,:,6), nhel, den(17))

    call Hcont_VV(nsync, wf4(:,10), wf16(:,3), A(:,7), n3(:,145), t3x64(:,:,7), nhel, den(19))
    call Hcont_VV(nsync, wf16(:,3), wf4(:,11), A(:,8), n3(:,146), t3x64(:,:,8), nhel, den(21))
    call Hcont_SS(nsync, wf4(:,13), wf16(:,4), A(:,9), n3(:,147), t3x64(:,:,9), nhel, den(23))
    call Hcont_SS(nsync, wf4(:,13), wf16(:,5), A(:,10), n3(:,148), t3x64(:,:,10), nhel, den(23))
    call Hcont_QA(nsync, wf4(:,5), wf16(:,6), A(:,11), n3(:,149), t3x64(:,:,11), nhel, den(5))
    call Hcont_QA(nsync, wf8(:,3), wf8(:,9), A(:,12), n3(:,150), t3x64(:,:,12), nhel, den(8))
    call Hcont_SS(nsync, wf8(:,10), wf8(:,11), A(:,13), n3(:,151), t3x64(:,:,13), nhel, den(26))
    call Hcont_QA(nsync, wf4(:,9), wf16(:,7), A(:,14), n3(:,152), t3x64(:,:,14), nhel, den(12))
    call Hcont_QA(nsync, wf8(:,6), wf8(:,12), A(:,15), n3(:,153), t3x64(:,:,15), nhel, den(15))
    call Hcont_SS(nsync, wf8(:,11), wf8(:,13), A(:,16), n3(:,154), t3x64(:,:,16), nhel, den(28))
    call Hcont_QA(nsync, wf8(:,3), wf8(:,14), A(:,17), n3(:,155), t3x64(:,:,17), nhel, den(16))
    call Hcont_SS(nsync, wf8(:,15), wf8(:,16), A(:,18), n3(:,156), t3x64(:,:,18), nhel, den(31))
    call Hcont_QA(nsync, wf8(:,6), wf8(:,17), A(:,19), n3(:,157), t3x64(:,:,19), nhel, den(17))
    call Hcont_SS(nsync, wf8(:,16), wf8(:,18), A(:,20), n3(:,158), t3x64(:,:,20), nhel, den(33))
    call Hcont_QA(nsync, wf8(:,6), wf8(:,19), A(:,21), n3(:,159), t3x64(:,:,21), nhel, den(34))
    call Hcont_QA(nsync, wf8(:,1), wf8(:,21), A(:,22), n3(:,160), t3x64(:,:,22), nhel, den(37))
    call Hcont_QA(nsync, wf8(:,22), wf8(:,23), A(:,23), n3(:,161), t3x64(:,:,23), nhel, den(39))
    call Hcont_QA(nsync, wf16(:,1), wf4(:,15), A(:,24), n3(:,162), t3x64(:,:,24), nhel, den(5))
    call Hcont_QA(nsync, wf8(:,22), wf8(:,24), A(:,25), n3(:,163), t3x64(:,:,25), nhel, den(41))
    call Hcont_QA(nsync, wf8(:,6), wf8(:,25), A(:,26), n3(:,164), t3x64(:,:,26), nhel, den(17))
    call Hcont_QA(nsync, wf16(:,2), wf4(:,17), A(:,27), n3(:,165), t3x64(:,:,27), nhel, den(12))
    call Hcont_QA(nsync, wf8(:,6), wf8(:,26), A(:,28), n3(:,166), t3x64(:,:,28), nhel, den(15))
    call Hcont_QA(nsync, wf8(:,27), wf8(:,28), A(:,29), n3(:,167), t3x64(:,:,29), nhel, den(44))
    call Hcont_QA(nsync, wf4(:,9), wf16(:,8), A(:,30), n3(:,168), t3x64(:,:,30), nhel, den(12))
    call Hcont_QA(nsync, wf8(:,27), wf8(:,29), A(:,31), n3(:,169), t3x64(:,:,31), nhel, den(46))
    call Hcont_QA(nsync, wf8(:,3), wf8(:,30), A(:,32), n3(:,170), t3x64(:,:,32), nhel, den(16))
    call Hcont_QA(nsync, wf4(:,5), wf16(:,9), A(:,33), n3(:,171), t3x64(:,:,33), nhel, den(5))
    call Hcont_QA(nsync, wf8(:,3), wf8(:,31), A(:,34), n3(:,172), t3x64(:,:,34), nhel, den(8))
    call Hcont_VV(nsync, wf8(:,32), wf8(:,33), A(:,35), n3(:,173), t3x64(:,:,35), nhel, den(50))
    call Hcont_VV(nsync, wf8(:,32), wf8(:,34), A(:,36), n3(:,174), t3x64(:,:,36), nhel, den(51))
    call Hcont_VV(nsync, wf8(:,35), wf8(:,36), A(:,37), n3(:,175), t3x64(:,:,37), nhel, den(55))
    call Hcont_VV(nsync, wf8(:,35), wf8(:,37), A(:,38), n3(:,176), t3x64(:,:,38), nhel, den(56))
    call Hcont_VV(nsync, wf8(:,33), wf8(:,38), A(:,39), n3(:,177), t3x64(:,:,39), nhel, den(59))
    call Hcont_VV(nsync, wf8(:,34), wf8(:,38), A(:,40), n3(:,178), t3x64(:,:,40), nhel, den(60))
    call Hcont_VV(nsync, wf8(:,36), wf8(:,39), A(:,41), n3(:,179), t3x64(:,:,41), nhel, den(63))
    call Hcont_VV(nsync, wf8(:,37), wf8(:,39), A(:,42), n3(:,180), t3x64(:,:,42), nhel, den(64))
    call Hcont_QA(nsync, wf4(:,5), wf16(:,10), A(:,43), n3(:,181), t3x64(:,:,43), nhel, den(67))
    call Hcont_QA(nsync, wf4(:,5), wf16(:,11), A(:,44), n3(:,182), t3x64(:,:,44), nhel, den(5))
    call Hcont_QA(nsync, wf8(:,2), wf8(:,41), A(:,45), n3(:,183), t3x64(:,:,45), nhel, den(69))
    call Hcont_QA(nsync, wf8(:,2), wf8(:,43), A(:,46), n3(:,184), t3x64(:,:,46), nhel, den(8))
    call Hcont_QA(nsync, wf4(:,9), wf16(:,12), A(:,47), n3(:,185), t3x64(:,:,47), nhel, den(71))
    call Hcont_QA(nsync, wf4(:,9), wf16(:,13), A(:,48), n3(:,186), t3x64(:,:,48), nhel, den(12))
    call Hcont_QA(nsync, wf8(:,5), wf8(:,45), A(:,49), n3(:,187), t3x64(:,:,49), nhel, den(73))
    call Hcont_QA(nsync, wf8(:,5), wf8(:,47), A(:,50), n3(:,188), t3x64(:,:,50), nhel, den(15))
    call Hcont_QA(nsync, wf8(:,7), wf8(:,41), A(:,51), n3(:,189), t3x64(:,:,51), nhel, den(74))
    call Hcont_QA(nsync, wf8(:,7), wf8(:,43), A(:,52), n3(:,190), t3x64(:,:,52), nhel, den(16))
    call Hcont_QA(nsync, wf8(:,8), wf8(:,45), A(:,53), n3(:,191), t3x64(:,:,53), nhel, den(75))
    call Hcont_QA(nsync, wf8(:,8), wf8(:,47), A(:,54), n3(:,192), t3x64(:,:,54), nhel, den(17))
    call Hcont_SS(nsync, wf16(:,14), wf4(:,32), A(:,55), n3(:,193), t3x64(:,:,55), nhel, den(79))
    call Hcont_VV(nsync, wf16(:,15), wf4(:,33), A(:,56), n3(:,194), t3x64(:,:,56), nhel, den(82))
    call Hcont_VV(nsync, wf16(:,16), wf4(:,34), A(:,57), n3(:,195), t3x64(:,:,57), nhel, den(79))
    call Hcont_QA(nsync, wf4(:,35), wf16(:,18), A(:,58), n3(:,196), t3x64(:,:,58), nhel, den(86))
    call Hcont_QA(nsync, wf4(:,36), wf16(:,19), A(:,59), n3(:,197), t3x64(:,:,59), nhel, den(89))
    call Hcont_QA(nsync, wf8(:,23), wf8(:,48), A(:,60), n3(:,198), t3x64(:,:,60), nhel, den(91))
    call Hcont_QA(nsync, wf8(:,23), wf8(:,49), A(:,61), n3(:,199), t3x64(:,:,61), nhel, den(93))
    call Hcont_QA(nsync, wf8(:,23), wf8(:,50), A(:,62), n3(:,200), t3x64(:,:,62), nhel, den(91))
    call Hcont_QA(nsync, wf8(:,3), wf8(:,51), A(:,63), n3(:,201), t3x64(:,:,63), nhel, den(95))
    call Hcont_QA(nsync, wf8(:,23), wf8(:,52), A(:,64), n3(:,202), t3x64(:,:,64), nhel, den(96))
    call Hcont_SS(nsync, wf4(:,32), wf16(:,20), A(:,65), n3(:,203), t3x64(:,:,65), nhel, den(99))
    call Hcont_VV(nsync, wf4(:,33), wf16(:,21), A(:,66), n3(:,204), t3x64(:,:,66), nhel, den(101))
    call Hcont_VV(nsync, wf4(:,34), wf16(:,22), A(:,67), n3(:,205), t3x64(:,:,67), nhel, den(99))
    call Hcont_QA(nsync, wf4(:,38), wf16(:,24), A(:,68), n3(:,206), t3x64(:,:,68), nhel, den(105))
    call Hcont_QA(nsync, wf4(:,39), wf16(:,25), A(:,69), n3(:,207), t3x64(:,:,69), nhel, den(108))
    call Hcont_QA(nsync, wf8(:,28), wf8(:,53), A(:,70), n3(:,208), t3x64(:,:,70), nhel, den(109))
    call Hcont_QA(nsync, wf8(:,28), wf8(:,54), A(:,71), n3(:,209), t3x64(:,:,71), nhel, den(110))
    call Hcont_QA(nsync, wf8(:,28), wf8(:,55), A(:,72), n3(:,210), t3x64(:,:,72), nhel, den(109))
    call Hcont_QA(nsync, wf8(:,28), wf8(:,56), A(:,73), n3(:,211), t3x64(:,:,73), nhel, den(111))
    call Hcont_QA(nsync, wf8(:,6), wf8(:,57), A(:,74), n3(:,212), t3x64(:,:,74), nhel, den(113))
    call Hcont_QA(nsync, wf8(:,24), wf8(:,48), A(:,75), n3(:,213), t3x64(:,:,75), nhel, den(114))
    call Hcont_QA(nsync, wf8(:,24), wf8(:,49), A(:,76), n3(:,214), t3x64(:,:,76), nhel, den(115))
    call Hcont_QA(nsync, wf8(:,24), wf8(:,50), A(:,77), n3(:,215), t3x64(:,:,77), nhel, den(114))
    call Hcont_QA(nsync, wf8(:,3), wf8(:,58), A(:,78), n3(:,216), t3x64(:,:,78), nhel, den(117))
    call Hcont_QA(nsync, wf8(:,24), wf8(:,52), A(:,79), n3(:,217), t3x64(:,:,79), nhel, den(118))
    call Hcont_QA(nsync, wf8(:,29), wf8(:,53), A(:,80), n3(:,218), t3x64(:,:,80), nhel, den(119))
    call Hcont_QA(nsync, wf8(:,29), wf8(:,54), A(:,81), n3(:,219), t3x64(:,:,81), nhel, den(120))
    call Hcont_QA(nsync, wf8(:,29), wf8(:,55), A(:,82), n3(:,220), t3x64(:,:,82), nhel, den(119))
    call Hcont_QA(nsync, wf8(:,29), wf8(:,56), A(:,83), n3(:,221), t3x64(:,:,83), nhel, den(121))
    call Hcont_QA(nsync, wf8(:,6), wf8(:,59), A(:,84), n3(:,222), t3x64(:,:,84), nhel, den(123))

end subroutine diagrams


elemental function diagmap(j, n)
  implicit none
  integer, intent(in) :: j, n
  complex(REALKIND) :: diagmap
  diagmap = A(j,n)%j
end function diagmap

function diagsum(j, pos, neg)
  implicit none
  integer, intent(in) :: j, pos(:), neg(:)
  complex(REALKIND) :: diagsum
  diagsum = sum(diagmap(j, pos)) - sum(diagmap(j, neg))
end function diagsum

subroutine colourvectors(A, j, M1, M2)
  implicit none
  type(Hpolcont) :: A(:,:)
  integer, intent(in) :: j
  type(Hpolcont), intent(out) :: M1(1), M2(1) ! M1helarray(1,64)
  integer :: empty(0), i

  M1(1)%j = (A(j,1)%j+A(j,2)%j+A(j,3)%j+A(j,4)%j+A(j,5)%j+A(j,6)%j)*f(1)

  M2(1)%j = (A(j,43)%j+A(j,45)%j+A(j,47)%j+A(j,49)%j+A(j,51)%j+A(j,53)%j-A(j,56)%j-A(j,61)%j-A(j,66)%j-A(j,71)%j-A(j,76)%j &
       -A(j,81)%j)*f(2)+(A(j,11)%j+A(j,14)%j+A(j,23)%j+A(j,25)%j+A(j,29)%j+A(j,31)%j+A(j,44)%j+A(j,46)%j+A(j,48)%j+A(j,50)%j &
       +A(j,52)%j+A(j,54)%j-A(j,57)%j-A(j,58)%j-A(j,59)%j-A(j,62)%j-A(j,63)%j-A(j,64)%j-A(j,67)%j-A(j,68)%j-A(j,69)%j-A(j,72)%j &
       -A(j,73)%j-A(j,74)%j-A(j,77)%j-A(j,78)%j-A(j,79)%j-A(j,82)%j-A(j,83)%j-A(j,84)%j)*f(3)+(A(j,12)%j+A(j,15)%j+A(j,17)%j &
       +A(j,19)%j+A(j,24)%j+A(j,26)%j+A(j,27)%j+A(j,28)%j+A(j,30)%j+A(j,32)%j+A(j,33)%j+A(j,34)%j+A(j,35)%j+A(j,36)%j+A(j,37)%j &
       +A(j,38)%j+A(j,39)%j+A(j,40)%j+A(j,41)%j+A(j,42)%j)*f(4)+A(j,7)%j*f(5)+A(j,8)%j*f(6)+A(j,9)%j*f(7)+(A(j,55)%j+A(j,60)%j &
       +A(j,65)%j+A(j,70)%j+A(j,75)%j+A(j,80)%j)*f(8)+(-A(j,21)%j-A(j,22)%j)*f(9)+(-A(j,13)%j-A(j,16)%j-A(j,18)%j-A(j,20)%j)*f(10) &
       -A(j,10)%j*f(11)


  M1(:)%hf = Hel(j)
  M2(:)%hf = Hel(j)

  !M(i) corresponds to \Gamma_{i} in Fabios thesis

end subroutine colourvectors


! **********************************************************************
subroutine colint(M, M2colint)
! M(i)   = <M|Ci> colour component of matrix element
! COLINT = <M|M>
!        = Sum_{i,j} <M|Ci> * <Ci|Cj> * <Cj|M>
!        = colour-summed squared matrix element
! K2(i,j) = <Ci|Cj>
! **********************************************************************
  use ol_colourmatrix_ppnnjj_ew_nenexbbxaa_2_/**/REALKIND, only: K1
  implicit none

  complex(REALKIND), intent(in)  :: M(1)
  real(REALKIND),    intent(out) :: M2colint
  integer :: i, j

  M2colint = 0

    do i = 1, 1
      do j = 1, 1
        M2colint = M2colint + real(conjg(M(i))*K1(i,j)*M(j))
      end do
    end do

end subroutine colint

! **********************************************************************
subroutine colint_ct(M, Mct, M2colint_ct, l)
! M(i)   = <M|Ci> colour component of matrix element
! COLINT = <M|M>
!        = Sum_{i,j} <M|Ci> * <Ci|Cj> * <Cj|M>
!        = colour-summed squared matrix element
! K2(i,j) = <Ci|Cj>
! **********************************************************************
  use ol_colourmatrix_ppnnjj_ew_nenexbbxaa_2_/**/REALKIND, only: K2
  implicit none
  complex(REALKIND), intent(in)  :: M(1), Mct(1)
  real(REALKIND),    intent(out) :: M2colint_ct
  integer, intent(in) :: l
  integer ::  i, j

  M2colint_ct = 0

  do i = 1, 1
    do j = 1, 1
      M2colint_ct = M2colint_ct + real(conjg(M(i))*K2(i+1*l,j)*Mct(j))
    end do
  end do

end subroutine colint_ct

! **********************************************************************
subroutine colint_IR(M, M2IRadd)
! M(i)   = <M|Ci> colour component of matrix element
! K1(i,j) = .....
! **********************************************************************
  use ol_colourmatrix_ppnnjj_ew_nenexbbxaa_2_/**/REALKIND, only: K1
  implicit none

  complex(REALKIND), intent(in)  :: M(1)
  real(REALKIND),    intent(out) :: M2IRadd(22)
  integer ::  i, j, k, colmatpos

  M2IRadd = 0

  do k = 1, 23-1
    colmatpos = 1*k
    do i = 1, 1
      do j = 1, 1
        M2IRadd(k) = M2IRadd(k) + real(conjg(M(i))*K1(i+colmatpos,j)*M(j))
      end do
    end do
  end do

end subroutine colint_IR

! **********************************************************************
subroutine colintmunu(M1, M2, M2colint)
! M1(i)    = <M1|Ci> colour component of matrix element
! M2(i)    = <M2|Ci> colour component of matrix element
! M2colint = <M1|M2>
!          = Sum_{i,j} <M1|Ci> * <Ci|Cj> * <Cj|M2>
!          = colour-summed squared matrix element
! K2(i,j) = <Ci|Cj>
! **********************************************************************
  use ol_colourmatrix_ppnnjj_ew_nenexbbxaa_2_/**/REALKIND, only: K2
  implicit none

  complex(REALKIND), intent(in)  :: M1(1)
  complex(REALKIND), intent(in)  :: M2(1)
  complex(REALKIND),    intent(out) :: M2colint
  integer :: i, j

  M2colint = 0

  do i = 1, 1
    do j = 1, 1
      M2colint = M2colint + M1(i)*K2(i,j)*conjg(M2(j))
    end do
  end do

end subroutine colintmunu





! **********************************************************************
subroutine colborninterf(M, M0_col, l)
! M(i)         = <M|Ci> colour component of matrix element
! M0_col(i)    = <M2|Ci> colour component of matrix element,
!                see \tilde{M}_{j} in Fabios thesis
! M2colint = Sum_{i} <M1|Ci> * <Ci|Cj>
!          = colour-summed squared matrix element
! KL(i,j) = <Ci|Cj> with elements Cj of 1-loop colour basis
! **********************************************************************
  use ol_colourmatrix_ppnnjj_ew_nenexbbxaa_2_/**/REALKIND, only: KL
  implicit none

  type(Hpolcont), intent(in)  :: M(1)
  type(Hpolcont), intent(out)  :: M0_col(1)
  integer, intent(in) :: l
  integer :: i, j

  do j = 1, 1 !size(KL(1,:))
    M0_col(j)%j = 0
    M0_col(j)%hf = M(1)%hf
    do i = 1, 1 !size(KL(:,1))
      M0_col(j)%j = M0_col(j)%j  + conjg(M(i)%j)*KL(i+1*l,j)
    end do
  end do

end subroutine colborninterf

end subroutine amp2

end module ol_loop_ppnnjj_ew_nenexbbxaa_2_/**/REALKIND
