
module ol_vamp_1_pplnttj_nexeuttxdxg_1_/**/REALKIND
contains

! **********************************************************************
subroutine vamp_1(M)
! P(0:3,nlegs) = incoming external momenta
! Uses tree structures 'wf', factors 'c', and denominators 'den' from loop_pplnttj_nexeuttxdxg_1.
! Sets colour stripped amplitudes A from the module loop_amplitudes_pplnttj_nexeuttxdxg_1.
! **********************************************************************
  use KIND_TYPES, only: REALKIND, QREALKIND, intkind2
  use ol_parameters_decl_/**/DREALKIND, only: l_switch
  use ol_parameters_decl_/**/QREALKIND ! masses
  use ol_vert_interface_/**/REALKIND
  use ol_prop_interface_/**/REALKIND
  use ol_last_step_/**/REALKIND
  use ol_tables_storage_pplnttj_nexeuttxdxg_1_/**/DREALKIND
  use ol_tensor_sum_storage_pplnttj_nexeuttxdxg_1_/**/REALKIND
  use ol_loop_handling_/**/REALKIND
  use ofred_reduction_/**/REALKIND, only: Hotf_4pt_reduction, Hotf_4pt_reduction_last
  use ofred_reduction_/**/REALKIND, only: Hotf_5pt_reduction, Hotf_5pt_reduction_last
  use ol_loop_reduction_/**/REALKIND, only: TI_bubble_red, TI_triangle_red
use ol_loop_reduction_/**/REALKIND, only: compute_scalar_box

  use ol_loop_storage_pplnttj_nexeuttxdxg_1_/**/REALKIND
#ifndef PRECISION_dp
  use ol_loop_storage_pplnttj_nexeuttxdxg_1_/**/DREALKIND, only: ntryL, p_switch, Hel
#endif
  use hol_initialisation_/**/REALKIND, only: G0_hol_initialisation
  use ol_h_vert_interface_/**/REALKIND
  use ol_h_prop_interface_/**/REALKIND
  use ol_h_last_step_/**/REALKIND
  use ol_merging_/**/REALKIND, only: ol_merge, ol_merge_tensors, ol_merge_last

  implicit none

  type(Hpolcont) :: Gcoeff(128)
  type(Hpolcont), intent(in) :: M(4,128)


#ifndef PRECISION_dp
  if (ntryL==1 .OR. p_switch == 1) Gcoeff(:)%hf = Hel
#else
  if (ntryL==1 .OR. p_switch == 2) Gcoeff(:)%hf = Hel
#endif

  ! =============================================


! Dressing, otf merging and otf reduction calls to build loop structures

Gcoeff(:)%j = (-(c(14)*M(2,:)%j)-c(10)*M(3,:)%j+c(11)*(M(1,:)%j+M(4,:)%j)) * den(1)
call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(1),h0tab(:,1),[64,3,32,16,8,4],[0,0,0,nMT,0,0],6,1,wf4(:,4))
  call Hloop_QV_A(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,1),heltab2x128(:,:,1))
  call Hloop_Q_A(ntryL,G0H64(1),64,0,G1H64(1),n2h64(1))
Gcoeff(:)%j = (-(c(14)*M(2,:)%j)-c(10)*M(3,:)%j+c(11)*(M(1,:)%j+M(4,:)%j)) * den(1)
call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(2),h0tab(:,2),[64,3,4,8,16,32],[0,0,0,nMT,0,0],6,1,wf4(:,4))
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,2),heltab2x128(:,:,2))
  call Hloop_A_Q(ntryL,G0H64(1),64,0,G1H64(2),n2h64(2))
Gcoeff(:)%j = (c(4)*(-M(2,:)%j+M(3,:)%j)+c(3)*(M(1,:)%j-M(4,:)%j)) * den(1)
call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(3),h0tab(:,3),[64,16,8,4,3,32],[0,nMT,0,0,0,0],6,1,wf4(:,4))
  call Hloop_UV_W(ntryL,G0H128(1),0,ex7(:),64,G1H64(3),m3h2x64(:,3),heltab2x128(:,:,3))
Gcoeff(:)%j = (-(c(10)*M(2,:)%j)-c(14)*M(3,:)%j+c(11)*(M(1,:)%j+M(4,:)%j)) * den(1)
call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(4),h0tab(:,4),[64,8,4,3,32,16],[nMT,0,0,0,0,nMT],6,1,wf4(:,4))
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,4),heltab2x128(:,:,4))
  call Hloop_A_Q(ntryL,G0H64(1),64,nMT,G1H64(4),n2h64(3))
Gcoeff(:)%j = (-(c(10)*M(3,:)%j)+c(11)*(M(1,:)%j+M(4,:)%j)) * den(1)
call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(5),h0tab(:,5),[64,3,32,8,16,4],[0,0,0,nMT,0,0],6,1,wf4(:,4))
  call Hloop_QV_A(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,5),heltab2x128(:,:,5))
  call Hloop_Q_A(ntryL,G0H64(1),64,0,G1H64(5),n2h64(4))
Gcoeff(:)%j = (-(c(10)*M(3,:)%j)+c(11)*(M(1,:)%j+M(4,:)%j)) * den(1)
call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(6),h0tab(:,6),[64,3,4,16,8,32],[0,0,0,nMT,0,0],6,1,wf4(:,4))
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,6),heltab2x128(:,:,6))
  call Hloop_A_Q(ntryL,G0H64(1),64,0,G1H64(6),n2h64(5))
Gcoeff(:)%j = (c(3)*M(1,:)%j+c(5)*M(4,:)%j) * den(1)
call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(7),h0tab(:,7),[64,8,16,4,3,32],[0,nMT,0,0,0,0],6,1,wf4(:,4))
  call Hloop_UV_W(ntryL,G0H128(1),0,ex7(:),64,G1H64(7),m3h2x64(:,7),heltab2x128(:,:,7))
Gcoeff(:)%j = (-(c(10)*M(2,:)%j)+c(11)*(M(1,:)%j+M(4,:)%j)) * den(1)
call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(8),h0tab(:,8),[64,8,32,3,4,16],[nMT,0,0,0,0,nMT],6,1,wf4(:,4))
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,8),heltab2x128(:,:,8))
  call Hloop_A_Q(ntryL,G0H64(1),64,nMT,G1H64(8),n2h64(6))
Gcoeff(:)%j = (c(5)*M(1,:)%j+c(3)*M(4,:)%j) * den(1)
call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(9),h0tab(:,9),[64,4,3,32,8,16],[0,0,0,0,nMT,0],6,1,wf4(:,4))
  call Hloop_UV_W(ntryL,G0H128(1),0,ex7(:),64,G1H64(9),m3h2x64(:,9),heltab2x128(:,:,9))
Gcoeff(:)%j = (c(4)*(-M(2,:)%j+M(3,:)%j)+c(3)*(-M(1,:)%j+M(4,:)%j)) * den(1)
call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(10),h0tab(:,10),[64,4,3,32,16,8],[0,0,0,0,nMT,0],6,1,wf4(:,4))
  call Hloop_UV_W(ntryL,G0H128(1),0,ex7(:),64,G1H64(10),m3h2x64(:,10),heltab2x128(:,:,10))
  call Hloop_QW_A(ntryL,G1H64(1),wf4(:,4),G1H16(1),m3h4x16(:,1),heltab2x64(:,:,1))
  call Hloop_Q_A(ntryL,G1H16(1),67,0,G2H16(1),n2h16(1))
  call Hloop_AW_Q(ntryL,G1H64(2),wf4(:,4),G1H16(1),m3h4x16(:,2),heltab2x64(:,:,2))
  call Hloop_A_Q(ntryL,G1H16(1),67,0,G2H16(2),n2h16(2))
  call Hloop_VA_Q(ntryL,G1H64(3),ex5(:),G1H32(1),m3h2x32(:,1),heltab2x64(:,:,3))
  call Hloop_A_Q(ntryL,G1H32(1),80,nMT,G2H32(1),n2h32(1))
  call Hloop_AQ_V(ntryL,G1H64(4),ex4(:),G1H32(1),m3h2x32(:,2),heltab2x64(:,:,4))
  call Hloop_QW_A(ntryL,G1H64(5),wf4(:,4),G1H16(1),m3h4x16(:,3),heltab2x64(:,:,5))
  call Hloop_Q_A(ntryL,G1H16(1),67,0,G2H16(3),n2h16(3))
  call Hloop_AW_Q(ntryL,G1H64(6),wf4(:,4),G1H16(1),m3h4x16(:,4),heltab2x64(:,:,6))
  call Hloop_A_Q(ntryL,G1H16(1),67,0,G2H16(4),n2h16(4))
  call Hloop_VQ_A(ntryL,G1H64(7),ex4(:),G1H32(2),m3h2x32(:,3),heltab2x64(:,:,7))
  call Hloop_Q_A(ntryL,G1H32(2),72,nMT,G2H32(2),n2h32(2))
  call Hloop_AQ_V(ntryL,G1H64(8),ex4(:),G1H32(2),m3h2x32(:,4),heltab2x64(:,:,8))
  call Hloop_VQ_A(ntryL,G1H64(9),ex3(:),G1H32(3),m3h2x32(:,5),heltab2x64(:,:,9))
  call Hloop_Q_A(ntryL,G1H32(3),68,0,G2H32(3),n2h32(3))
  call Hloop_VQ_A(ntryL,G1H64(10),ex3(:),G1H32(3),m3h2x32(:,6),heltab2x64(:,:,10))
  call Hloop_Q_A(ntryL,G1H32(3),68,0,G2H32(4),n2h32(4))
  call Hloop_QA_V(ntryL,G2H16(1),ex6(:),G2H8(1),m3h2x8(:,1),heltab2x16(:,:,1))
  call Hloop_AQ_V(ntryL,G2H16(2),ex3(:),G2H8(2),m3h2x8(:,2),heltab2x16(:,:,2))
  call Hloop_AQ_V(ntryL,G2H32(1),ex4(:),G2H16(1),m3h2x16(:,1),heltab2x32(:,:,1))
  call Hloop_VQ_A(ntryL,G1H32(1),ex3(:),G1H16(1),m3h2x16(:,2),heltab2x32(:,:,2))
  call Hloop_Q_A(ntryL,G1H16(1),76,0,G2H16(2),n2h16(5))
  call Hloop_QA_V(ntryL,G2H16(3),ex6(:),G2H8(3),m3h2x8(:,3),heltab2x16(:,:,3))
  call Hloop_AQ_V(ntryL,G2H16(4),ex3(:),G2H8(4),m3h2x8(:,4),heltab2x16(:,:,4))
  call Hloop_QA_V(ntryL,G2H32(2),ex5(:),G2H16(3),m3h2x16(:,3),heltab2x32(:,:,3))
  call Hloop_VA_Q(ntryL,G1H32(2),ex6(:),G1H16(1),m3h2x16(:,4),heltab2x32(:,:,4))
  call Hloop_A_Q(ntryL,G1H16(1),104,0,G2H16(4),n2h16(6))
call Hotf_5pt_reduction(G2H32(3),RedSet_5(1),mass5set(:,1),  & 
G1H32(3),G1H32(1),G1H32(2),G1H32(4),G1H32(5),G1H32(6),32)
call HG1shiftOLR(G1H32(1),16,32)
call Hotf_5pt_reduction(G2H32(4),RedSet_5(1),mass5set(:,1),  & 
G1H32(7),G1H32(8),G1H32(9),G1H32(10),G1H32(11),G1H32(12),32)
call HG1shiftOLR(G1H32(8),8,32)
  call Hloop_QW_A(ntryL,G1H32(3),wf4(:,4),G1H8(1),m3h4x8(:,1),heltab2x32(:,:,5))
  call Hloop_Q_A(ntryL,G1H8(1),71,0,G2H8(5),n2h8(1))
call HGT_raise_alpha_OLR(G1H32(1),1,1,32)
call HGT_raise_alpha_invQ_OLR(G1H32(1),2,5,32)
  call Hloop_VA_Q(ntryL,G1H32(1),ex5(:),G1H16(1),m3h2x16(:,5),heltab2x32(:,:,6))
  call Hloop_QW_A(ntryL,G1H32(4),wf4(:,4),G1H8(1),m3h4x8(:,2),heltab2x32(:,:,7))
  call Hloop_Q_A(ntryL,G1H8(1),71,0,G2H8(6),n2h8(2))
  call Hloop_QW_A(ntryL,G1H32(5),wf4(:,4),G1H8(1),m3h4x8(:,3),heltab2x32(:,:,8))
  call Hloop_Q_A(ntryL,G1H8(1),71,0,G2H8(7),n2h8(3))
  call Hloop_QW_A(ntryL,G1H32(6),wf4(:,4),G1H8(1),m3h4x8(:,4),heltab2x32(:,:,9))
  call Hloop_Q_A(ntryL,G1H8(1),71,0,G2H8(8),n2h8(4))
  call Hloop_QW_A(ntryL,G1H32(7),wf4(:,4),G1H8(1),m3h4x8(:,5),heltab2x32(:,:,10))
  call Hloop_Q_A(ntryL,G1H8(1),71,0,G2H8(9),n2h8(5))
call HGT_raise_alpha_OLR(G1H32(8),1,1,32)
call HGT_raise_alpha_invQ_OLR(G1H32(8),2,5,32)
  call Hloop_VQ_A(ntryL,G1H32(8),ex4(:),G1H16(2),m3h2x16(:,6),heltab2x32(:,:,11))
  call Hloop_QW_A(ntryL,G1H32(10),wf4(:,4),G1H8(1),m3h4x8(:,6),heltab2x32(:,:,12))
  call Hloop_Q_A(ntryL,G1H8(1),71,0,G2H8(10),n2h8(6))
  call Hloop_QW_A(ntryL,G1H32(11),wf4(:,4),G1H8(1),m3h4x8(:,7),heltab2x32(:,:,13))
  call Hloop_Q_A(ntryL,G1H8(1),71,0,G2H8(11),n2h8(7))
  call Hloop_QW_A(ntryL,G1H32(12),wf4(:,4),G1H8(1),m3h4x8(:,8),heltab2x32(:,:,14))
  call Hloop_Q_A(ntryL,G1H8(1),71,0,G2H8(12),n2h8(8))
call Hotf_5pt_reduction(G2H8(1),RedSet_5(2),mass5set(:,2),  & 
G1H8(1),G1H8(2),G1H8(3),G1H8(4),G1H8(5),G1H8(6),8)
call HG1shiftOLR(G1H8(2),4,8)
call Hotf_5pt_reduction(G2H8(2),RedSet_5(3),mass5set(:,2),  & 
G1H8(7),G1H8(8),G1H8(9),G1H8(10),G1H8(11),G1H8(12),8)
call HG1shiftOLR(G1H8(8),32,8)
call Hotf_5pt_reduction(G2H16(1),RedSet_5(4),mass5set(:,3),  & 
G1H16(3),G1H16(4),G1H16(5),G1H16(6),G1H16(7),G1H16(8),16)
call HG1shiftOLR(G1H16(4),32,16)
call Hotf_5pt_reduction(G2H16(2),RedSet_5(5),mass5set(:,4),  & 
G1H16(9),G1H16(10),G1H16(11),G1H16(12),G1H16(13),G1H16(14),16)
call HG1shiftOLR(G1H16(10),16,16)
call Hotf_5pt_reduction(G2H8(3),RedSet_5(6),mass5set(:,2),  & 
G1H8(13),G1H8(14),G1H8(15),G1H8(16),G1H8(17),G1H8(18),8)
call HG1shiftOLR(G1H8(14),4,8)
call Hotf_5pt_reduction(G2H8(4),RedSet_5(7),mass5set(:,2),  & 
G1H8(19),G1H8(20),G1H8(21),G1H8(22),G1H8(23),G1H8(24),8)
call HG1shiftOLR(G1H8(20),32,8)
call Hotf_5pt_reduction(G2H16(3),RedSet_5(8),mass5set(:,3),  & 
G1H16(15),G1H16(16),G1H16(17),G1H16(18),G1H16(19),G1H16(20),16)
call HG1shiftOLR(G1H16(16),32,16)
call Hotf_5pt_reduction(G2H16(4),RedSet_5(9),mass5set(:,4),  & 
G1H16(21),G1H16(22),G1H16(23),G1H16(24),G1H16(25),G1H16(26),16)
call HG1shiftOLR(G1H16(22),16,16)
  call Hloop_QA_V(ntryL,G2H8(5),ex6(:),G2H4(1),m3h2x4(:,1),heltab2x8(:,:,1))
  call Hloop_QA_V(ntryL,G2H8(7),ex6(:),G2H4(2),m3h2x4(:,2),heltab2x8(:,:,2))
  call Hloop_QA_V(ntryL,G2H8(8),ex6(:),G2H4(3),m3h2x4(:,3),heltab2x8(:,:,3))
  call Hloop_QA_V(ntryL,G2H8(9),ex6(:),G2H4(4),m3h2x4(:,4),heltab2x8(:,:,4))
  call Hloop_QA_V(ntryL,G2H8(11),ex6(:),G2H4(5),m3h2x4(:,5),heltab2x8(:,:,5))
  call Hloop_QA_V(ntryL,G2H8(12),ex6(:),G2H4(6),m3h2x4(:,6),heltab2x8(:,:,6))
  call Hloop_VA_Q(ntryL,G1H8(1),ex5(:),G1H4(1),m3h2x4(:,7),heltab2x8(:,:,7))
  call Hloop_A_Q(ntryL,G1H4(1),115,nMT,G2H4(7),n2h4(1))
call HGT_OLR(G1H8(2),1,1,8)
call HGT_invQ_OLR(G1H8(2),2,5,8)
  call Hloop_A_Q(ntryL,G1H8(2),-4,0,G2H8(1),n2h8(9))
  call Hloop_AQ_V(ntryL,G2H8(1),ex3(:),G2H4(8),m3h2x4(:,8),heltab2x8(:,:,8))
  call Hloop_VA_Q(ntryL,G1H8(5),ex5(:),G1H4(1),m3h2x4(:,9),heltab2x8(:,:,9))
  call Hloop_A_Q(ntryL,G1H4(1),115,nMT,G2H4(9),n2h4(2))
  call Hloop_VA_Q(ntryL,G1H8(6),ex5(:),G1H4(1),m3h2x4(:,10),heltab2x8(:,:,10))
  call Hloop_A_Q(ntryL,G1H4(1),115,nMT,G2H4(10),n2h4(3))
  call Hloop_VQ_A(ntryL,G1H8(7),ex4(:),G1H4(1),m3h2x4(:,11),heltab2x8(:,:,11))
  call Hloop_Q_A(ntryL,G1H4(1),79,nMT,G2H4(11),n2h4(4))
call HGT_OLR(G1H8(8),1,1,8)
call HGT_invQ_OLR(G1H8(8),2,5,8)
  call Hloop_Q_A(ntryL,G1H8(8),-32,0,G2H8(2),n2h8(10))
  call Hloop_QA_V(ntryL,G2H8(2),ex6(:),G2H4(12),m3h2x4(:,12),heltab2x8(:,:,12))
  call Hloop_VQ_A(ntryL,G1H8(11),ex4(:),G1H4(1),m3h2x4(:,13),heltab2x8(:,:,13))
  call Hloop_Q_A(ntryL,G1H4(1),79,nMT,G2H4(13),n2h4(5))
  call Hloop_VQ_A(ntryL,G1H8(12),ex4(:),G1H4(1),m3h2x4(:,14),heltab2x8(:,:,14))
  call Hloop_Q_A(ntryL,G1H4(1),79,nMT,G2H4(14),n2h4(6))
  call Hloop_VQ_A(ntryL,G1H16(3),ex3(:),G1H8(1),m3h2x8(:,5),heltab2x16(:,:,5))
  call Hloop_Q_A(ntryL,G1H8(1),92,0,G2H8(3),n2h8(11))
call HGT_raise_alpha_OLR(G1H16(4),1,1,16)
call HGT_raise_alpha_invQ_OLR(G1H16(4),2,5,16)
  call Hloop_VA_Q(ntryL,G1H16(4),ex6(:),G1H8(2),m3h2x8(:,6),heltab2x16(:,:,6))
  call Hloop_VQ_A(ntryL,G1H16(7),ex3(:),G1H8(5),m3h2x8(:,7),heltab2x16(:,:,7))
  call Hloop_Q_A(ntryL,G1H8(5),92,0,G2H8(4),n2h8(12))
  call Hloop_VQ_A(ntryL,G1H16(8),ex3(:),G1H8(6),m3h2x8(:,8),heltab2x16(:,:,8))
  call Hloop_Q_A(ntryL,G1H8(6),92,0,G2H8(5),n2h8(13))
  call Hloop_QW_A(ntryL,G1H16(9),wf4(:,4),G1H4(1),m3h4x4(:,1),heltab2x16(:,:,9))
  call Hloop_Q_A(ntryL,G1H4(1),79,0,G2H4(15),n2h4(7))
call HGT_OLR(G1H16(10),1,1,16)
call HGT_invQ_OLR(G1H16(10),2,5,16)
  call Hloop_Q_A(ntryL,G1H16(10),-16,nMT,G2H16(1),n2h16(8))
  call Hloop_QA_V(ntryL,G2H16(1),ex5(:),G2H8(7),m3h2x8(:,9),heltab2x16(:,:,10))
  call Hloop_QW_A(ntryL,G1H16(13),wf4(:,4),G1H4(1),m3h4x4(:,2),heltab2x16(:,:,11))
  call Hloop_Q_A(ntryL,G1H4(1),79,0,G2H4(16),n2h4(8))
  call Hloop_QW_A(ntryL,G1H16(14),wf4(:,4),G1H4(1),m3h4x4(:,3),heltab2x16(:,:,12))
  call Hloop_Q_A(ntryL,G1H4(1),79,0,G2H4(17),n2h4(9))
  call Hloop_VQ_A(ntryL,G1H8(13),ex4(:),G1H4(1),m3h2x4(:,15),heltab2x8(:,:,15))
  call Hloop_Q_A(ntryL,G1H4(1),107,nMT,G2H4(18),n2h4(10))
call HGT_OLR(G1H8(14),1,1,8)
call HGT_invQ_OLR(G1H8(14),2,5,8)
  call Hloop_A_Q(ntryL,G1H8(14),-4,0,G2H8(8),n2h8(14))
  call Hloop_AQ_V(ntryL,G2H8(8),ex3(:),G2H4(19),m3h2x4(:,16),heltab2x8(:,:,16))
  call Hloop_VQ_A(ntryL,G1H8(17),ex4(:),G1H4(1),m3h2x4(:,17),heltab2x8(:,:,17))
  call Hloop_Q_A(ntryL,G1H4(1),107,nMT,G2H4(20),n2h4(11))
  call Hloop_VQ_A(ntryL,G1H8(18),ex4(:),G1H4(1),m3h2x4(:,18),heltab2x8(:,:,18))
  call Hloop_Q_A(ntryL,G1H4(1),107,nMT,G2H4(21),n2h4(12))
  call Hloop_VA_Q(ntryL,G1H8(19),ex5(:),G1H4(1),m3h2x4(:,19),heltab2x8(:,:,19))
  call Hloop_A_Q(ntryL,G1H4(1),87,nMT,G2H4(22),n2h4(13))
call HGT_OLR(G1H8(20),1,1,8)
call HGT_invQ_OLR(G1H8(20),2,5,8)
  call Hloop_Q_A(ntryL,G1H8(20),-32,0,G2H8(9),n2h8(15))
  call Hloop_QA_V(ntryL,G2H8(9),ex6(:),G2H4(23),m3h2x4(:,20),heltab2x8(:,:,20))
  call Hloop_VA_Q(ntryL,G1H8(23),ex5(:),G1H4(1),m3h2x4(:,21),heltab2x8(:,:,21))
  call Hloop_A_Q(ntryL,G1H4(1),87,nMT,G2H4(24),n2h4(14))
  call Hloop_VA_Q(ntryL,G1H8(24),ex5(:),G1H4(1),m3h2x4(:,22),heltab2x8(:,:,22))
  call Hloop_A_Q(ntryL,G1H4(1),87,nMT,G2H4(25),n2h4(15))
  call Hloop_VQ_A(ntryL,G1H16(15),ex3(:),G1H8(7),m3h2x8(:,10),heltab2x16(:,:,13))
  call Hloop_Q_A(ntryL,G1H8(7),92,0,G2H8(11),n2h8(16))
call HGT_raise_alpha_OLR(G1H16(16),1,1,16)
call HGT_raise_alpha_invQ_OLR(G1H16(16),2,5,16)
  call Hloop_VA_Q(ntryL,G1H16(16),ex6(:),G1H8(8),m3h2x8(:,11),heltab2x16(:,:,14))
  call Hloop_VQ_A(ntryL,G1H16(19),ex3(:),G1H8(11),m3h2x8(:,12),heltab2x16(:,:,15))
  call Hloop_Q_A(ntryL,G1H8(11),92,0,G2H8(12),n2h8(17))
  call Hloop_VQ_A(ntryL,G1H16(20),ex3(:),G1H8(12),m3h2x8(:,13),heltab2x16(:,:,16))
  call Hloop_Q_A(ntryL,G1H8(12),92,0,G2H8(1),n2h8(18))
  call Hloop_AW_Q(ntryL,G1H16(21),wf4(:,4),G1H4(1),m3h4x4(:,4),heltab2x16(:,:,17))
  call Hloop_A_Q(ntryL,G1H4(1),107,0,G2H4(26),n2h4(16))
call HGT_OLR(G1H16(22),1,1,16)
call HGT_invQ_OLR(G1H16(22),2,5,16)
  call Hloop_Q_A(ntryL,G1H16(22),-16,nMT,G2H16(2),n2h16(10))
  call Hloop_QA_V(ntryL,G2H16(2),ex5(:),G2H8(2),m3h2x8(:,14),heltab2x16(:,:,18))
  call Hloop_AW_Q(ntryL,G1H16(25),wf4(:,4),G1H4(1),m3h4x4(:,5),heltab2x16(:,:,19))
  call Hloop_A_Q(ntryL,G1H4(1),107,0,G2H4(27),n2h4(17))
  call Hloop_AW_Q(ntryL,G1H16(26),wf4(:,4),G1H4(1),m3h4x4(:,6),heltab2x16(:,:,20))
  call Hloop_A_Q(ntryL,G1H4(1),107,0,G2H4(28),n2h4(18))
call Hotf_5pt_reduction(G2H4(1),RedSet_5(1),mass5set(:,1),  & 
G1H4(1),G1H4(2),G1H4(3),G1H4(4),G1H4(5),G1H4(6),4)
call HG1shiftOLR(G1H4(2),16,4)
call Hotf_5pt_reduction(G2H4(3),RedSet_5(10),mass5set(:,2),  & 
G1H4(7),G1H4(8),G1H4(9),G1H4(10),G1H4(11),G1H4(12),4)
call HG1shiftOLR(G1H4(8),16,4)
call Hotf_5pt_reduction(G2H4(4),RedSet_5(1),mass5set(:,1),  & 
G1H4(13),G1H4(14),G1H4(15),G1H4(16),G1H4(17),G1H4(18),4)
call HG1shiftOLR(G1H4(14),8,4)
call Hotf_5pt_reduction(G2H4(6),RedSet_5(11),mass5set(:,2),  & 
G1H4(19),G1H4(20),G1H4(21),G1H4(22),G1H4(23),G1H4(24),4)
call HG1shiftOLR(G1H4(20),8,4)
  call Hloop_AQ_V(ntryL,G2H4(7),ex4(:),G2H2(1),m3h2x2(:,1),heltab2x4(:,:,1))
  call Hloop_AQ_V(ntryL,G2H4(10),ex4(:),G2H2(2),m3h2x2(:,2),heltab2x4(:,:,2))
  call Hloop_QA_V(ntryL,G2H4(11),ex5(:),G2H2(3),m3h2x2(:,3),heltab2x4(:,:,3))
  call Hloop_QA_V(ntryL,G2H4(14),ex5(:),G2H2(4),m3h2x2(:,4),heltab2x4(:,:,4))
call Hotf_5pt_reduction(G2H8(3),RedSet_5(4),mass5set(:,3),  & 
G1H8(1),G1H8(5),G1H8(6),G1H8(13),G1H8(14),G1H8(17),8)
call HG1shiftOLR(G1H8(5),32,8)
call Hotf_5pt_reduction(G2H8(5),RedSet_5(12),mass5set(:,3),  & 
G1H8(18),G1H8(19),G1H8(20),G1H8(23),G1H8(24),G1H8(7),8)
call HG1shiftOLR(G1H8(19),32,8)
  call Hloop_QA_V(ntryL,G2H4(15),ex6(:),G2H2(5),m3h2x2(:,5),heltab2x4(:,:,5))
  call Hloop_QA_V(ntryL,G2H4(17),ex6(:),G2H2(6),m3h2x2(:,6),heltab2x4(:,:,6))
  call Hloop_QA_V(ntryL,G2H4(18),ex5(:),G2H2(7),m3h2x2(:,7),heltab2x4(:,:,7))
  call Hloop_QA_V(ntryL,G2H4(21),ex5(:),G2H2(8),m3h2x2(:,8),heltab2x4(:,:,8))
  call Hloop_AQ_V(ntryL,G2H4(22),ex4(:),G2H2(9),m3h2x2(:,9),heltab2x4(:,:,9))
  call Hloop_AQ_V(ntryL,G2H4(25),ex4(:),G2H2(10),m3h2x2(:,10),heltab2x4(:,:,10))
call Hotf_5pt_reduction(G2H8(11),RedSet_5(8),mass5set(:,3),  & 
G1H8(11),G1H8(12),G1H8(25),G1H8(26),G1H8(27),G1H8(28),8)
call HG1shiftOLR(G1H8(12),32,8)
call Hotf_5pt_reduction(G2H8(1),RedSet_5(13),mass5set(:,3),  & 
G1H8(29),G1H8(30),G1H8(31),G1H8(32),G1H8(33),G1H8(34),8)
call HG1shiftOLR(G1H8(30),32,8)
  call Hloop_AQ_V(ntryL,G2H4(26),ex3(:),G2H2(11),m3h2x2(:,11),heltab2x4(:,:,11))
  call Hloop_AQ_V(ntryL,G2H4(28),ex3(:),G2H2(12),m3h2x2(:,12),heltab2x4(:,:,12))
  call ol_merge(ntryL,G1H4(7),[G1H4(6)])
  call ol_merge(ntryL,G1H4(19),[G1H4(18)])
  call ol_merge(ntryL,G1H8(18),[G1H8(17)])
  call ol_merge(ntryL,G1H8(29),[G1H8(28)])
  call Hloop_VQ_A(ntryL,G1H4(1),ex4(:),G1H2(1),m3h2x2(:,13),heltab2x4(:,:,13))
  call Hloop_Q_A(ntryL,G1H2(1),111,nMT,G2H2(13),n2h2(1))
call HGT_raise_alpha_OLR(G1H4(2),1,1,4)
call HGT_raise_alpha_invQ_OLR(G1H4(2),2,5,4)
  call Hloop_VA_Q(ntryL,G1H4(2),ex5(:),G1H2(1),m3h2x2(:,14),heltab2x4(:,:,14))
  call Hloop_VQ_A(ntryL,G1H4(7),ex4(:),G1H2(2),m3h2x2(:,15),heltab2x4(:,:,15))
  call Hloop_Q_A(ntryL,G1H2(2),111,nMT,G2H2(14),n2h2(2))
call HGT_raise_alpha_OLR(G1H4(8),1,1,4)
call HGT_raise_alpha_invQ_OLR(G1H4(8),2,5,4)
  call Hloop_VA_Q(ntryL,G1H4(8),ex5(:),G1H2(2),m3h2x2(:,16),heltab2x4(:,:,16))
  call Hloop_VQ_A(ntryL,G1H4(12),ex4(:),G1H2(3),m3h2x2(:,17),heltab2x4(:,:,17))
  call Hloop_Q_A(ntryL,G1H2(3),111,nMT,G2H2(15),n2h2(3))
  call Hloop_VA_Q(ntryL,G1H4(13),ex5(:),G1H2(3),m3h2x2(:,18),heltab2x4(:,:,18))
  call Hloop_A_Q(ntryL,G1H2(3),119,nMT,G2H2(16),n2h2(4))
call HGT_raise_alpha_OLR(G1H4(14),1,1,4)
call HGT_raise_alpha_invQ_OLR(G1H4(14),2,5,4)
  call Hloop_VQ_A(ntryL,G1H4(14),ex4(:),G1H2(3),m3h2x2(:,19),heltab2x4(:,:,19))
  call Hloop_VA_Q(ntryL,G1H4(19),ex5(:),G1H2(4),m3h2x2(:,20),heltab2x4(:,:,20))
  call Hloop_A_Q(ntryL,G1H2(4),119,nMT,G2H2(17),n2h2(5))
call HGT_raise_alpha_OLR(G1H4(20),1,1,4)
call HGT_raise_alpha_invQ_OLR(G1H4(20),2,5,4)
  call Hloop_VQ_A(ntryL,G1H4(20),ex4(:),G1H2(4),m3h2x2(:,21),heltab2x4(:,:,21))
  call Hloop_VA_Q(ntryL,G1H4(24),ex5(:),G1H2(5),m3h2x2(:,22),heltab2x4(:,:,22))
  call Hloop_A_Q(ntryL,G1H2(5),119,nMT,G2H2(18),n2h2(6))
  call Hloop_QW_A(ntryL,G1H8(1),wf4(:,4),G1H2(5),m3h4x2(:,1),heltab2x8(:,:,23))
  call Hloop_Q_A(ntryL,G1H2(5),95,0,G2H2(19),n2h2(7))
call HGT_raise_alpha_OLR(G1H8(5),1,1,8)
call HGT_raise_alpha_invQ_OLR(G1H8(5),2,5,8)
  call Hloop_VA_Q(ntryL,G1H8(5),ex6(:),G1H4(6),m3h2x4(:,23),heltab2x8(:,:,24))
  call Hloop_QW_A(ntryL,G1H8(18),wf4(:,4),G1H2(5),m3h4x2(:,2),heltab2x8(:,:,25))
  call Hloop_Q_A(ntryL,G1H2(5),95,0,G2H2(20),n2h2(8))
call HGT_raise_alpha_OLR(G1H8(19),1,1,8)
call HGT_raise_alpha_invQ_OLR(G1H8(19),2,5,8)
  call Hloop_VA_Q(ntryL,G1H8(19),ex6(:),G1H4(18),m3h2x4(:,24),heltab2x8(:,:,26))
  call Hloop_QW_A(ntryL,G1H8(7),wf4(:,4),G1H2(5),m3h4x2(:,3),heltab2x8(:,:,27))
  call Hloop_Q_A(ntryL,G1H2(5),95,0,G2H2(21),n2h2(9))
  call Hloop_QW_A(ntryL,G1H8(11),wf4(:,4),G1H2(5),m3h4x2(:,4),heltab2x8(:,:,28))
  call Hloop_Q_A(ntryL,G1H2(5),95,0,G2H2(22),n2h2(10))
call HGT_raise_alpha_OLR(G1H8(12),1,1,8)
call HGT_raise_alpha_invQ_OLR(G1H8(12),2,5,8)
  call Hloop_VA_Q(ntryL,G1H8(12),ex6(:),G1H4(1),m3h2x4(:,25),heltab2x8(:,:,29))
  call Hloop_QW_A(ntryL,G1H8(29),wf4(:,4),G1H2(5),m3h4x2(:,5),heltab2x8(:,:,30))
  call Hloop_Q_A(ntryL,G1H2(5),95,0,G2H2(23),n2h2(11))
call HGT_raise_alpha_OLR(G1H8(30),1,1,8)
call HGT_raise_alpha_invQ_OLR(G1H8(30),2,5,8)
  call Hloop_VA_Q(ntryL,G1H8(30),ex6(:),G1H4(2),m3h2x4(:,26),heltab2x8(:,:,31))
  call Hloop_QW_A(ntryL,G1H8(34),wf4(:,4),G1H2(5),m3h4x2(:,6),heltab2x8(:,:,32))
  call Hloop_Q_A(ntryL,G1H2(5),95,0,G2H2(24),n2h2(12))
call Hotf_5pt_reduction(G2H2(1),RedSet_5(2),mass5set(:,2),  & 
G1H2(5),G1H2(6),G1H2(7),G1H2(8),G1H2(9),G1H2(10),2)
call HG1shiftOLR(G1H2(6),4,2)
call Hotf_5pt_reduction(G2H2(3),RedSet_5(3),mass5set(:,2),  & 
G1H2(11),G1H2(12),G1H2(13),G1H2(14),G1H2(15),G1H2(16),2)
call HG1shiftOLR(G1H2(12),32,2)
call Hotf_5pt_reduction(G2H2(5),RedSet_5(5),mass5set(:,4),  & 
G1H2(17),G1H2(18),G1H2(19),G1H2(20),G1H2(21),G1H2(22),2)
call HG1shiftOLR(G1H2(18),16,2)
call Hotf_5pt_reduction(G2H2(7),RedSet_5(6),mass5set(:,2),  & 
G1H2(23),G1H2(24),G1H2(25),G1H2(26),G1H2(27),G1H2(28),2)
call HG1shiftOLR(G1H2(24),4,2)
call Hotf_5pt_reduction(G2H2(9),RedSet_5(7),mass5set(:,2),  & 
G1H2(29),G1H2(30),G1H2(31),G1H2(32),G1H2(33),G1H2(34),2)
call HG1shiftOLR(G1H2(30),32,2)
call Hotf_5pt_reduction(G2H2(11),RedSet_5(9),mass5set(:,4),  & 
G1H2(35),G1H2(36),G1H2(37),G1H2(38),G1H2(39),G1H2(40),2)
call HG1shiftOLR(G1H2(36),16,2)
  call Hcheck_last_QA_V(ntryL,l_switch,G2H2(13),ex5(:),G2tensor(1),m3h2x1(:,1),heltab2x2(:,:,1))
  call Hcheck_last_AQ_V(ntryL,l_switch,G2H2(16),ex4(:),G2tensor(2),m3h2x1(:,2),heltab2x2(:,:,2))
  call Hcheck_last_QA_V(ntryL,l_switch,G2H2(19),ex6(:),G2tensor(3),m3h2x1(:,3),heltab2x2(:,:,3))
  call Hcheck_last_QA_V(ntryL,l_switch,G2H2(22),ex6(:),G2tensor(4),m3h2x1(:,4),heltab2x2(:,:,4))
  call Hloop_VQ_A(ntryL,G1H2(5),ex3(:),G1H1(1),m3h2x1(:,5),heltab2x2(:,:,5))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),127,0,G2tensor(5),n2h1(1))
  call Hloop_VQ_A(ntryL,G1H2(6),ex3(:),G1H1(1),m3h2x1(:,6),heltab2x2(:,:,6))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),4,0,G2tensor(6),n2h1(2))
  call Hloop_VA_Q(ntryL,G1H2(11),ex6(:),G1H1(1),m3h2x1(:,7),heltab2x2(:,:,7))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),127,0,G2tensor(7),n2h1(3))
  call Hloop_VA_Q(ntryL,G1H2(12),ex6(:),G1H1(1),m3h2x1(:,8),heltab2x2(:,:,8))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),32,0,G2tensor(8),n2h1(4))
  call Hloop_VA_Q(ntryL,G1H2(17),ex5(:),G1H1(1),m3h2x1(:,9),heltab2x2(:,:,9))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),127,nMT,G2tensor(9),n2h1(5))
  call Hloop_VA_Q(ntryL,G1H2(18),ex5(:),G1H1(1),m3h2x1(:,10),heltab2x2(:,:,10))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),16,nMT,G2tensor(10),n2h1(6))
  call Hloop_VQ_A(ntryL,G1H2(23),ex3(:),G1H1(1),m3h2x1(:,11),heltab2x2(:,:,11))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),127,0,G2tensor(11),n2h1(7))
  call Hloop_VQ_A(ntryL,G1H2(24),ex3(:),G1H1(1),m3h2x1(:,12),heltab2x2(:,:,12))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),4,0,G2tensor(12),n2h1(8))
  call Hloop_VA_Q(ntryL,G1H2(29),ex6(:),G1H1(1),m3h2x1(:,13),heltab2x2(:,:,13))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),127,0,G2tensor(13),n2h1(9))
  call Hloop_VA_Q(ntryL,G1H2(30),ex6(:),G1H1(1),m3h2x1(:,14),heltab2x2(:,:,14))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),32,0,G2tensor(14),n2h1(10))
  call Hloop_VA_Q(ntryL,G1H2(35),ex5(:),G1H1(1),m3h2x1(:,15),heltab2x2(:,:,15))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),127,nMT,G2tensor(15),n2h1(11))
  call Hloop_VA_Q(ntryL,G1H2(36),ex5(:),G1H1(1),m3h2x1(:,16),heltab2x2(:,:,16))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),16,nMT,G2tensor(16),n2h1(12))
call Hotf_5pt_reduction_last(G2tensor(1),RedSet_5(1),mass5set(:,1),  & 
G1tensor(1),G1tensor(2),G1tensor(3),G1tensor(4),G1tensor(5),G1tensor(6))
call G_TensorShift(G1tensor(2),16)
call Hotf_5pt_reduction_last(G2tensor(2),RedSet_5(1),mass5set(:,1),  & 
G1tensor(7),G1tensor(8),G1tensor(9),G1tensor(10),G1tensor(11),G1tensor(12))
call G_TensorShift(G1tensor(8),8)
call Hotf_5pt_reduction_last(G2tensor(3),RedSet_5(4),mass5set(:,3),  & 
G1tensor(13),G1tensor(14),G1tensor(15),G1tensor(16),G1tensor(17),G1tensor(18))
call G_TensorShift(G1tensor(14),32)
call Hotf_5pt_reduction_last(G2tensor(4),RedSet_5(8),mass5set(:,3),  & 
G1tensor(19),G1tensor(20),G1tensor(21),G1tensor(22),G1tensor(23),G1tensor(24))
call G_TensorShift(G1tensor(20),32)
call Hotf_5pt_reduction_last(G2tensor(5),RedSet_5(2),mass5set(:,2),  & 
G1tensor(25),G1tensor(26),G1tensor(27),G1tensor(28),G1tensor(29),G1tensor(30))
call G_TensorShift(G1tensor(26),4)
call Hotf_5pt_reduction_last(G2tensor(7),RedSet_5(3),mass5set(:,2),  & 
G1tensor(31),G1tensor(32),G1tensor(33),G1tensor(34),G1tensor(35),G1tensor(36))
call G_TensorShift(G1tensor(32),32)
call Hotf_5pt_reduction_last(G2tensor(9),RedSet_5(5),mass5set(:,4),  & 
G1tensor(37),G1tensor(38),G1tensor(39),G1tensor(40),G1tensor(41),G1tensor(42))
call G_TensorShift(G1tensor(38),16)
call Hotf_5pt_reduction_last(G2tensor(11),RedSet_5(6),mass5set(:,2),  & 
G1tensor(43),G1tensor(44),G1tensor(45),G1tensor(46),G1tensor(47),G1tensor(48))
call G_TensorShift(G1tensor(44),4)
call Hotf_5pt_reduction_last(G2tensor(13),RedSet_5(7),mass5set(:,2),  & 
G1tensor(49),G1tensor(50),G1tensor(51),G1tensor(52),G1tensor(53),G1tensor(54))
call G_TensorShift(G1tensor(50),32)
call Hotf_5pt_reduction_last(G2tensor(15),RedSet_5(9),mass5set(:,4),  & 
G1tensor(55),G1tensor(56),G1tensor(57),G1tensor(58),G1tensor(59),G1tensor(60))
call G_TensorShift(G1tensor(56),16)
call ol_merge_tensors(T1sum(1),[G1tensor(1)])
call ol_merge_tensors(T1sum(2),[G1tensor(7)])
call ol_merge_tensors(T1sum(3),[G1tensor(13)])
call ol_merge_tensors(T1sum(4),[G1tensor(19)])
call ol_merge_tensors(T1sum(5),[G1tensor(25)])
call ol_merge_tensors(T1sum(6),[G1tensor(31)])
call ol_merge_tensors(T1sum(7),[G1tensor(37)])
call ol_merge_tensors(T1sum(8),[G1tensor(43)])
call ol_merge_tensors(T1sum(9),[G1tensor(49)])
call ol_merge_tensors(T1sum(10),[G1tensor(55)])
Gcoeff(:)%j = (c(11)*M(1,:)%j-c(14)*M(2,:)%j-c(10)*M(3,:)%j) * den(138)
call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(11),h0tab(:,11),[64,4,32,3,24],[0,0,0,0,0],5,2,wf4(:,4),wf4(:,3))
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,11),heltab2x128(:,:,11))
  call Hloop_A_Q(ntryL,G0H64(1),64,0,G1H64(1),n2h64(7))
Gcoeff(:)%j = (c(11)*M(1,:)%j-c(14)*M(2,:)%j-c(10)*M(3,:)%j) * den(138)
call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(12),h0tab(:,12),[64,3,24,32,4],[0,0,0,0,0],5,2,wf4(:,4),wf4(:,3))
  call Hloop_QV_A(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,12),heltab2x128(:,:,12))
  call Hloop_Q_A(ntryL,G0H64(1),64,0,G1H64(2),n2h64(8))
Gcoeff(:)%j = (-(c(14)*M(2,:)%j)-c(10)*M(3,:)%j+c(11)*M(4,:)%j) * den(138)
call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(13),h0tab(:,13),[64,24,3,4,32],[0,0,0,0,0],5,2,wf4(:,3),wf4(:,4))
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,13),heltab2x128(:,:,13))
  call Hloop_A_Q(ntryL,G0H64(1),64,0,G1H64(3),n2h64(9))
Gcoeff(:)%j = (c(11)*M(1,:)%j-c(14)*M(2,:)%j-c(10)*M(3,:)%j) * den(138)
call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(14),h0tab(:,14),[64,3,4,32,24],[0,0,0,0,0],5,2,wf4(:,4),wf4(:,3))
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,14),heltab2x128(:,:,14))
  call Hloop_A_Q(ntryL,G0H64(1),64,0,G1H64(4),n2h64(10))
Gcoeff(:)%j = (-(c(14)*M(2,:)%j)-c(10)*M(3,:)%j+c(11)*M(4,:)%j) * den(138)
call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(15),h0tab(:,15),[64,3,24,4,32],[0,0,0,0,0],5,2,wf4(:,4),wf4(:,3))
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,15),heltab2x128(:,:,15))
  call Hloop_A_Q(ntryL,G0H64(1),64,0,G1H64(5),n2h64(11))
Gcoeff(:)%j = (-(c(14)*M(2,:)%j)-c(10)*M(3,:)%j+c(11)*M(4,:)%j) * den(138)
call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(16),h0tab(:,16),[64,3,32,4,24],[0,0,0,0,0],5,2,wf4(:,4),wf4(:,3))
  call Hloop_QV_A(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,16),heltab2x128(:,:,16))
  call Hloop_Q_A(ntryL,G0H64(1),64,0,G1H64(6),n2h64(12))
Gcoeff(:)%j = (-(c(4)*M(2,:)%j)) * den(138)
call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(17),h0tab(:,17),[64,4,3,24,32],[0,0,0,0,0],5,2,wf4(:,4),wf4(:,3))
  call Hloop_UV_W(ntryL,G0H128(1),0,ex7(:),64,G1H64(7),m3h2x64(:,17),heltab2x128(:,:,17))
Gcoeff(:)%j = (-(c(19)*M(1,:)%j)+c(14)*(-M(2,:)%j+M(3,:)%j)) * den(138)
call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(18),h0tab(:,18),[64,4,3,32,24],[0,0,0,0,0],5,2,wf4(:,4),wf4(:,3))
  call Hloop_UV_W(ntryL,G0H128(1),0,ex7(:),64,G1H64(8),m3h2x64(:,18),heltab2x128(:,:,18))
Gcoeff(:)%j = (-(c(4)*M(2,:)%j)) * den(138)
call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(19),h0tab(:,19),[64,4,24,3,32],[0,0,0,0,0],5,2,wf4(:,3),wf4(:,4))
  call Hloop_UV_W(ntryL,G0H128(1),0,ex7(:),64,G1H64(9),m3h2x64(:,19),heltab2x128(:,:,19))
Gcoeff(:)%j = (-(c(4)*M(2,:)%j)) * den(138)
call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(20),h0tab(:,20),[64,3,32,24,4],[0,0,0,0,0],5,2,wf4(:,4),wf4(:,3))
  call Hloop_QV_A(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,20),heltab2x128(:,:,20))
  call Hloop_Q_A(ntryL,G0H64(1),64,0,G1H64(10),n2h64(13))
Gcoeff(:)%j = (c(14)*(-M(2,:)%j+M(3,:)%j)-c(19)*M(4,:)%j) * den(138)
call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(21),h0tab(:,21),[64,24,4,3,32],[0,0,0,0,0],5,2,wf4(:,3),wf4(:,4))
  call Hloop_UV_W(ntryL,G0H128(1),0,ex7(:),64,G1H64(11),m3h2x64(:,21),heltab2x128(:,:,21))
Gcoeff(:)%j = (c(4)*M(2,:)%j) * den(138)
call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(22),h0tab(:,22),[64,3,4,24,32],[0,0,0,0,0],5,2,wf4(:,4),wf4(:,3))
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,22),heltab2x128(:,:,22))
  call Hloop_A_Q(ntryL,G0H64(1),64,0,G1H64(12),n2h64(14))
Gcoeff(:)%j = (-(c(17)*M(1,:)%j)-c(10)*M(3,:)%j) * den(8)
call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(23),h0tab(:,23),[68,3,32,8,16],[0,0,0,nMT,0],5,2,wf4(:,5),wf4(:,4))
  call Hloop_VQ_A(ntryL,G0H128(1),wf4(:,5),G0H32(1),m3h4x32(:,1),heltab2x128(:,:,23))
  call Hloop_Q_A(ntryL,G0H32(1),68,0,G1H32(3),n2h32(7))
Gcoeff(:)%j = (c(12)*M(1,:)%j-c(15)*M(3,:)%j) * den(8)
call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(24),h0tab(:,24),[68,3,32,16,8],[0,0,0,nMT,0],5,2,wf4(:,5),wf4(:,4))
  call Hloop_VQ_A(ntryL,G0H128(1),wf4(:,5),G0H32(1),m3h4x32(:,2),heltab2x128(:,:,24))
  call Hloop_Q_A(ntryL,G0H32(1),68,0,G1H32(1),n2h32(8))
Gcoeff(:)%j = (-(c(10)*M(2,:)%j)-c(17)*M(4,:)%j) * den(161)
call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(25),h0tab(:,25),[72,16,4,3,32],[nMT,0,0,0,0],5,2,wf4(:,9),wf4(:,4))
  call Hloop_VQ_A(ntryL,G0H128(1),wf4(:,9),G0H32(1),m3h4x32(:,3),heltab2x128(:,:,25))
  call Hloop_Q_A(ntryL,G0H32(1),72,nMT,G1H32(4),n2h32(9))
Gcoeff(:)%j = (-(c(15)*M(2,:)%j)+c(12)*M(4,:)%j) * den(161)
call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(26),h0tab(:,26),[72,4,3,32,16],[0,0,0,0,nMT],5,2,wf4(:,9),wf4(:,4))
  call Hloop_AQ_V(ntryL,G0H128(1),wf4(:,9),G0H32(1),m3h4x32(:,4),heltab2x128(:,:,26))
Gcoeff(:)%j = (c(12)*M(1,:)%j-c(15)*M(2,:)%j) * den(169)
call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(27),h0tab(:,27),[80,8,4,3,32],[nMT,0,0,0,0],5,2,wf4(:,11),wf4(:,4))
  call Hloop_VA_Q(ntryL,G0H128(1),wf4(:,11),G0H32(2),m3h4x32(:,5),heltab2x128(:,:,27))
  call Hloop_A_Q(ntryL,G0H32(2),80,nMT,G1H32(5),n2h32(10))
Gcoeff(:)%j = (-(c(17)*M(1,:)%j)-c(10)*M(2,:)%j) * den(169)
call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(28),h0tab(:,28),[80,4,3,32,8],[0,0,0,0,nMT],5,2,wf4(:,11),wf4(:,4))
  call Hloop_QA_V(ntryL,G0H128(1),wf4(:,11),G0H32(2),m3h4x32(:,6),heltab2x128(:,:,28))
Gcoeff(:)%j = (-(c(15)*M(3,:)%j)+c(12)*M(4,:)%j) * den(17)
call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(29),h0tab(:,29),[96,3,4,8,16],[0,0,0,nMT,0],5,2,wf4(:,7),wf4(:,4))
  call Hloop_VA_Q(ntryL,G0H128(1),wf4(:,7),G0H32(3),m3h4x32(:,7),heltab2x128(:,:,29))
  call Hloop_A_Q(ntryL,G0H32(3),96,0,G1H32(6),n2h32(11))
Gcoeff(:)%j = (-(c(10)*M(3,:)%j)-c(17)*M(4,:)%j) * den(17)
call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(30),h0tab(:,30),[96,3,4,16,8],[0,0,0,nMT,0],5,2,wf4(:,7),wf4(:,4))
  call Hloop_VA_Q(ntryL,G0H128(1),wf4(:,7),G0H32(3),m3h4x32(:,8),heltab2x128(:,:,30))
  call Hloop_A_Q(ntryL,G0H32(3),96,0,G1H32(7),n2h32(12))
Gcoeff(:)%j = (c(5)*M(1,:)%j+c(3)*M(4,:)%j) * den(15)
call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(31),h0tab(:,31),[64,7,32,8,16],[0,0,0,nMT,0],5,1,wf8(:,6))
  call Hloop_UV_W(ntryL,G0H128(1),0,ex7(:),64,G1H64(13),m3h2x64(:,23),heltab2x128(:,:,31))
Gcoeff(:)%j = (-(c(10)*M(3,:)%j)+c(11)*(M(1,:)%j+M(4,:)%j)) * den(15)
call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(32),h0tab(:,32),[64,7,16,8,32],[0,0,nMT,0,0],5,1,wf8(:,6))
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,24),heltab2x128(:,:,32))
  call Hloop_A_Q(ntryL,G0H64(1),64,0,G1H64(14),n2h64(15))
Gcoeff(:)%j = (c(4)*(-M(2,:)%j+M(3,:)%j)+c(3)*(-M(1,:)%j+M(4,:)%j)) * den(15)
call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(33),h0tab(:,33),[64,7,32,16,8],[0,0,0,nMT,0],5,1,wf8(:,6))
  call Hloop_UV_W(ntryL,G0H128(1),0,ex7(:),64,G1H64(15),m3h2x64(:,25),heltab2x128(:,:,33))
Gcoeff(:)%j = (c(3)*M(1,:)%j+c(5)*M(4,:)%j) * den(15)
call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(34),h0tab(:,34),[64,8,16,7,32],[0,nMT,0,0,0],5,1,wf8(:,6))
  call Hloop_UV_W(ntryL,G0H128(1),0,ex7(:),64,G1H64(16),m3h2x64(:,26),heltab2x128(:,:,34))
Gcoeff(:)%j = (-(c(14)*M(2,:)%j)-c(10)*M(3,:)%j+c(11)*(M(1,:)%j+M(4,:)%j)) * den(15)
call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(35),h0tab(:,35),[64,7,8,16,32],[0,0,nMT,0,0],5,1,wf8(:,6))
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,27),heltab2x128(:,:,35))
  call Hloop_A_Q(ntryL,G0H64(1),64,0,G1H64(17),n2h64(16))
Gcoeff(:)%j = (c(4)*(-M(2,:)%j+M(3,:)%j)+c(3)*(M(1,:)%j-M(4,:)%j)) * den(15)
call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(36),h0tab(:,36),[64,16,8,7,32],[0,nMT,0,0,0],5,1,wf8(:,6))
  call Hloop_UV_W(ntryL,G0H128(1),0,ex7(:),64,G1H64(18),m3h2x64(:,28),heltab2x128(:,:,36))
Gcoeff(:)%j = (-(c(10)*M(2,:)%j)+c(11)*(M(1,:)%j+M(4,:)%j)) * den(15)
call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(37),h0tab(:,37),[64,8,32,7,16],[nMT,0,0,0,nMT],5,1,wf8(:,6))
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,29),heltab2x128(:,:,37))
  call Hloop_A_Q(ntryL,G0H64(1),64,nMT,G1H64(19),n2h64(17))
Gcoeff(:)%j = (-(c(10)*M(2,:)%j)-c(14)*M(3,:)%j+c(11)*(M(1,:)%j+M(4,:)%j)) * den(15)
call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(38),h0tab(:,38),[64,8,7,32,16],[nMT,0,0,0,nMT],5,1,wf8(:,6))
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,30),heltab2x128(:,:,38))
  call Hloop_A_Q(ntryL,G0H64(1),64,nMT,G1H64(20),n2h64(18))
Gcoeff(:)%j = (-(c(14)*M(2,:)%j)-c(10)*M(3,:)%j+c(11)*(M(1,:)%j+M(4,:)%j)) * den(6)
call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(39),h0tab(:,39),[64,4,8,16,35],[0,0,nMT,0,0],5,1,wf8(:,2))
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,31),heltab2x128(:,:,39))
  call Hloop_A_Q(ntryL,G0H64(1),64,0,G1H64(21),n2h64(19))
Gcoeff(:)%j = (c(4)*(-M(2,:)%j+M(3,:)%j)+c(3)*(M(1,:)%j-M(4,:)%j)) * den(6)
call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(40),h0tab(:,40),[64,16,8,4,35],[0,nMT,0,0,0],5,1,wf8(:,2))
  call Hloop_UV_W(ntryL,G0H128(1),0,ex7(:),64,G1H64(22),m3h2x64(:,32),heltab2x128(:,:,40))
Gcoeff(:)%j = (-(c(10)*M(2,:)%j)-c(14)*M(3,:)%j+c(11)*(M(1,:)%j+M(4,:)%j)) * den(6)
call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(41),h0tab(:,41),[64,8,4,35,16],[nMT,0,0,0,nMT],5,1,wf8(:,2))
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,33),heltab2x128(:,:,41))
  call Hloop_A_Q(ntryL,G0H64(1),64,nMT,G1H64(23),n2h64(20))
Gcoeff(:)%j = (-(c(10)*M(3,:)%j)+c(11)*(M(1,:)%j+M(4,:)%j)) * den(6)
call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(42),h0tab(:,42),[64,4,16,8,35],[0,0,nMT,0,0],5,1,wf8(:,2))
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,34),heltab2x128(:,:,42))
  call Hloop_A_Q(ntryL,G0H64(1),64,0,G1H64(24),n2h64(21))
Gcoeff(:)%j = (c(3)*M(1,:)%j+c(5)*M(4,:)%j) * den(6)
call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(43),h0tab(:,43),[64,8,16,4,35],[0,nMT,0,0,0],5,1,wf8(:,2))
  call Hloop_UV_W(ntryL,G0H128(1),0,ex7(:),64,G1H64(25),m3h2x64(:,35),heltab2x128(:,:,43))
Gcoeff(:)%j = (-(c(10)*M(2,:)%j)+c(11)*(M(1,:)%j+M(4,:)%j)) * den(6)
call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(44),h0tab(:,44),[64,8,35,4,16],[nMT,0,0,0,nMT],5,1,wf8(:,2))
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,36),heltab2x128(:,:,44))
  call Hloop_A_Q(ntryL,G0H64(1),64,nMT,G1H64(26),n2h64(22))
Gcoeff(:)%j = (c(4)*(-M(2,:)%j+M(3,:)%j)+c(3)*(-M(1,:)%j+M(4,:)%j)) * den(6)
call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(45),h0tab(:,45),[64,4,35,16,8],[0,0,0,nMT,0],5,1,wf8(:,2))
  call Hloop_UV_W(ntryL,G0H128(1),0,ex7(:),64,G1H64(27),m3h2x64(:,37),heltab2x128(:,:,45))
Gcoeff(:)%j = (c(5)*M(1,:)%j+c(3)*M(4,:)%j) * den(6)
call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(46),h0tab(:,46),[64,4,35,8,16],[0,0,0,nMT,0],5,1,wf8(:,2))
  call Hloop_UV_W(ntryL,G0H128(1),0,ex7(:),64,G1H64(28),m3h2x64(:,38),heltab2x128(:,:,46))
  call ol_merge(ntryL,G1H32(3),[G1H32(2)])
  call ol_merge(ntryL,G1H32(1),[G1H32(9)])
  call Hloop_QW_A(ntryL,G1H32(3),wf4(:,4),G1H8(17),m3h4x8(:,9),heltab2x32(:,:,15))
  call Hloop_Q_A(ntryL,G1H8(17),71,0,G2H8(8),n2h8(23))
  call Hloop_QW_A(ntryL,G1H32(1),wf4(:,4),G1H8(28),m3h4x8(:,10),heltab2x32(:,:,16))
  call Hloop_Q_A(ntryL,G1H8(28),71,0,G2H8(9),n2h8(24))
  call Hloop_AQ_V(ntryL,G1H64(1),ex3(:),G1H32(8),m3h2x32(:,7),heltab2x64(:,:,11))
  call Hloop_QW_A(ntryL,G1H64(2),wf4(:,4),G1H16(3),m3h4x16(:,5),heltab2x64(:,:,12))
  call Hloop_Q_A(ntryL,G1H16(3),67,0,G2H16(3),n2h16(11))
  call Hloop_AV_Q(ntryL,G1H64(3),wf4(:,3),G1H16(4),m3h4x16(:,6),heltab2x64(:,:,13))
  call Hloop_A_Q(ntryL,G1H16(4),88,0,G2H16(4),n2h16(12))
  call Hloop_AW_Q(ntryL,G1H64(4),wf4(:,4),G1H16(7),m3h4x16(:,7),heltab2x64(:,:,14))
  call Hloop_A_Q(ntryL,G1H16(7),67,0,G2H16(1),n2h16(13))
  call Hloop_AW_Q(ntryL,G1H64(5),wf4(:,4),G1H16(8),m3h4x16(:,8),heltab2x64(:,:,15))
  call Hloop_A_Q(ntryL,G1H16(8),67,0,G2H16(2),n2h16(14))
  call Hloop_QW_A(ntryL,G1H64(6),wf4(:,4),G1H16(9),m3h4x16(:,9),heltab2x64(:,:,16))
  call Hloop_Q_A(ntryL,G1H16(9),67,0,G2H16(5),n2h16(15))
  call Hloop_VQ_A(ntryL,G1H64(7),ex3(:),G1H32(10),m3h2x32(:,8),heltab2x64(:,:,17))
  call Hloop_Q_A(ntryL,G1H32(10),68,0,G2H32(1),n2h32(13))
  call Hloop_VQ_A(ntryL,G1H64(8),ex3(:),G1H32(11),m3h2x32(:,9),heltab2x64(:,:,18))
  call Hloop_Q_A(ntryL,G1H32(11),68,0,G2H32(2),n2h32(14))
  call Hloop_VQ_A(ntryL,G1H64(9),ex3(:),G1H32(12),m3h2x32(:,10),heltab2x64(:,:,19))
  call Hloop_Q_A(ntryL,G1H32(12),68,0,G2H32(3),n2h32(15))
  call Hloop_QW_A(ntryL,G1H64(10),wf4(:,4),G1H16(10),m3h4x16(:,10),heltab2x64(:,:,20))
  call Hloop_Q_A(ntryL,G1H16(10),67,0,G2H16(6),n2h16(16))
  call Hloop_UV_W(ntryL,G1H64(11),64,wf4(:,3),24,G2H16(7),m3h4x16(:,11),heltab2x64(:,:,21))
  call Hloop_AW_Q(ntryL,G1H64(12),wf4(:,4),G1H16(13),m3h4x16(:,12),heltab2x64(:,:,22))
  call Hloop_A_Q(ntryL,G1H16(13),67,0,G2H16(8),n2h16(17))
  call Hloop_QA_V(ntryL,G1H32(4),ex5(:),G1H16(14),m3h2x16(:,7),heltab2x32(:,:,17))
  call Hloop_VQ_A(ntryL,G0H32(1),ex3(:),G0H16(1),m3h2x16(:,8),heltab2x32(:,:,18))
  call Hloop_Q_A(ntryL,G0H16(1),76,0,G1H16(15),n2h16(18))
  call Hloop_AQ_V(ntryL,G1H32(5),ex4(:),G1H16(16),m3h2x16(:,9),heltab2x32(:,:,19))
  call Hloop_VQ_A(ntryL,G0H32(2),ex3(:),G0H16(1),m3h2x16(:,10),heltab2x32(:,:,20))
  call Hloop_Q_A(ntryL,G0H16(1),84,0,G1H16(19),n2h16(19))
  call Hloop_AW_Q(ntryL,G1H32(6),wf4(:,4),G1H8(1),m3h4x8(:,11),heltab2x32(:,:,21))
  call Hloop_A_Q(ntryL,G1H8(1),99,0,G2H8(3),n2h8(25))
  call Hloop_AW_Q(ntryL,G1H32(7),wf4(:,4),G1H8(5),m3h4x8(:,12),heltab2x32(:,:,22))
  call Hloop_A_Q(ntryL,G1H8(5),99,0,G2H8(5),n2h8(26))
  call Hloop_VQ_A(ntryL,G1H64(13),wf8(:,6),G1H8(18),m3h8x8(:,1),heltab2x64(:,:,23))
  call Hloop_Q_A(ntryL,G1H8(18),71,0,G2H8(11),n2h8(27))
  call Hloop_AQ_V(ntryL,G1H64(14),wf8(:,6),G1H8(19),m3h8x8(:,2),heltab2x64(:,:,24))
  call Hloop_VQ_A(ntryL,G1H64(15),wf8(:,6),G1H8(7),m3h8x8(:,3),heltab2x64(:,:,25))
  call Hloop_Q_A(ntryL,G1H8(7),71,0,G2H8(1),n2h8(28))
  call Hloop_VQ_A(ntryL,G1H64(16),ex4(:),G1H32(2),m3h2x32(:,11),heltab2x64(:,:,26))
  call Hloop_Q_A(ntryL,G1H32(2),72,nMT,G2H32(4),n2h32(16))
  call Hloop_AQ_V(ntryL,G1H64(17),wf8(:,6),G1H8(11),m3h8x8(:,4),heltab2x64(:,:,27))
  call Hloop_VA_Q(ntryL,G1H64(18),ex5(:),G1H32(9),m3h2x32(:,12),heltab2x64(:,:,28))
  call Hloop_A_Q(ntryL,G1H32(9),80,nMT,G2H32(5),n2h32(17))
  call Hloop_AQ_V(ntryL,G1H64(19),ex4(:),G1H32(3),m3h2x32(:,13),heltab2x64(:,:,29))
  call Hloop_AQ_V(ntryL,G1H64(20),ex4(:),G1H32(1),m3h2x32(:,14),heltab2x64(:,:,30))
  call Hloop_AQ_V(ntryL,G1H64(21),ex3(:),G1H32(10),m3h2x32(:,15),heltab2x64(:,:,31))
  call Hloop_VA_Q(ntryL,G1H64(22),ex5(:),G1H32(11),m3h2x32(:,16),heltab2x64(:,:,32))
  call Hloop_A_Q(ntryL,G1H32(11),80,nMT,G2H32(6),n2h32(18))
  call Hloop_AQ_V(ntryL,G1H64(23),ex4(:),G1H32(12),m3h2x32(:,17),heltab2x64(:,:,33))
  call Hloop_AQ_V(ntryL,G1H64(24),ex3(:),G1H32(4),m3h2x32(:,18),heltab2x64(:,:,34))
  call Hloop_VQ_A(ntryL,G1H64(25),ex4(:),G1H32(5),m3h2x32(:,19),heltab2x64(:,:,35))
  call Hloop_Q_A(ntryL,G1H32(5),72,nMT,G2H32(7),n2h32(19))
  call Hloop_AQ_V(ntryL,G1H64(26),ex4(:),G1H32(6),m3h2x32(:,20),heltab2x64(:,:,36))
  call Hloop_VQ_A(ntryL,G1H64(27),ex3(:),G1H32(7),m3h2x32(:,21),heltab2x64(:,:,37))
  call Hloop_Q_A(ntryL,G1H32(7),68,0,G2H32(8),n2h32(20))
  call Hloop_VQ_A(ntryL,G1H64(28),ex3(:),G1H32(2),m3h2x32(:,22),heltab2x64(:,:,38))
  call Hloop_Q_A(ntryL,G1H32(2),68,0,G2H32(9),n2h32(21))
call HGT_w2_OLR(G1H16(1),1,1,16)
call HGT_w2_invQ_OLR(G1H16(1),2,5,16)
  call ol_merge(ntryL,G1H16(1),[G1H16(19)])
  call ol_merge(ntryL,G2H8(11),[G2H8(6)])
  call ol_merge(ntryL,G1H16(15),[G1H16(11)])
call HGT_w2_OLR(G1H16(2),1,1,16)
call HGT_w2_invQ_OLR(G1H16(2),2,5,16)
  call ol_merge(ntryL,G1H16(2),[G1H16(15)])
  call ol_merge(ntryL,G2H8(1),[G2H8(10)])
  call ol_merge(ntryL,G1H8(11),[G1H8(10)])
  call ol_merge(ntryL,G1H16(16),[G1H16(5)])
  call ol_merge(ntryL,G2H16(7),[G1H16(18),G1H16(6)])
  call ol_merge(ntryL,G1H8(19),[G1H8(22)])
  call ol_merge(ntryL,G1H16(14),[G1H16(17)])
  call Hloop_QW_A(ntryL,G1H16(1),wf4(:,4),G1H4(7),m3h4x4(:,7),heltab2x16(:,:,21))
  call Hloop_Q_A(ntryL,G1H4(7),87,0,G2H4(1),n2h4(23))
  call Hloop_QA_V(ntryL,G2H8(11),ex6(:),G2H4(3),m3h2x4(:,27),heltab2x8(:,:,33))
  call Hloop_QW_A(ntryL,G1H16(2),wf4(:,4),G1H4(8),m3h4x4(:,8),heltab2x16(:,:,22))
  call Hloop_Q_A(ntryL,G1H4(8),79,0,G2H4(4),n2h4(24))
  call Hloop_QA_V(ntryL,G2H8(1),ex6(:),G2H4(6),m3h2x4(:,28),heltab2x8(:,:,34))
  call Hloop_VA_Q(ntryL,G1H8(3),ex5(:),G1H4(12),m3h2x4(:,29),heltab2x8(:,:,35))
  call Hloop_A_Q(ntryL,G1H4(12),115,nMT,G2H4(7),n2h4(25))
  call Hloop_VA_Q(ntryL,G1H8(4),ex5(:),G1H4(13),m3h2x4(:,30),heltab2x8(:,:,36))
  call Hloop_A_Q(ntryL,G1H4(13),115,nMT,G2H4(10),n2h4(26))
  call Hloop_VQ_A(ntryL,G1H8(9),ex4(:),G1H4(14),m3h2x4(:,31),heltab2x8(:,:,37))
  call Hloop_Q_A(ntryL,G1H4(14),79,nMT,G2H4(11),n2h4(27))
  call Hloop_VQ_A(ntryL,G1H8(11),ex4(:),G1H4(19),m3h2x4(:,32),heltab2x8(:,:,38))
  call Hloop_Q_A(ntryL,G1H4(19),79,nMT,G2H4(14),n2h4(28))
  call Hloop_VQ_A(ntryL,G1H16(16),ex3(:),G1H8(12),m3h2x8(:,15),heltab2x16(:,:,23))
  call Hloop_Q_A(ntryL,G1H8(12),92,0,G2H8(6),n2h8(29))
call Hotf_5pt_reduction(G2H16(7),RedSet_5(14),mass5set(:,1),  & 
G1H16(20),G1H16(21),G1H16(22),G1H16(25),G1H16(26),G1H16(3),16)
call HG1shiftOLR(G1H16(21),32,16)
  call Hloop_QW_A(ntryL,G1H16(12),wf4(:,4),G1H4(20),m3h4x4(:,9),heltab2x16(:,:,24))
  call Hloop_Q_A(ntryL,G1H4(20),79,0,G2H4(15),n2h4(29))
  call Hloop_VQ_A(ntryL,G1H8(15),ex4(:),G1H4(24),m3h2x4(:,33),heltab2x8(:,:,39))
  call Hloop_Q_A(ntryL,G1H4(24),107,nMT,G2H4(17),n2h4(30))
  call Hloop_VQ_A(ntryL,G1H8(16),ex4(:),G1H4(7),m3h2x4(:,34),heltab2x8(:,:,40))
  call Hloop_Q_A(ntryL,G1H4(7),107,nMT,G2H4(18),n2h4(31))
  call Hloop_VA_Q(ntryL,G1H8(21),ex5(:),G1H4(8),m3h2x4(:,35),heltab2x8(:,:,41))
  call Hloop_A_Q(ntryL,G1H4(8),87,nMT,G2H4(21),n2h4(32))
  call Hloop_VA_Q(ntryL,G1H8(19),ex5(:),G1H4(12),m3h2x4(:,36),heltab2x8(:,:,42))
  call Hloop_A_Q(ntryL,G1H4(12),87,nMT,G2H4(22),n2h4(33))
  call Hloop_VQ_A(ntryL,G1H16(14),ex3(:),G1H8(29),m3h2x8(:,16),heltab2x16(:,:,25))
  call Hloop_Q_A(ntryL,G1H8(29),92,0,G2H8(10),n2h8(30))
  call Hloop_AW_Q(ntryL,G1H16(23),wf4(:,4),G1H4(13),m3h4x4(:,10),heltab2x16(:,:,26))
  call Hloop_A_Q(ntryL,G1H4(13),107,0,G2H4(25),n2h4(34))
  call Hloop_AW_Q(ntryL,G1H16(24),wf4(:,4),G1H4(14),m3h4x4(:,11),heltab2x16(:,:,27))
  call Hloop_A_Q(ntryL,G1H4(14),107,0,G2H4(26),n2h4(35))
  call Hloop_QA_V(ntryL,G2H8(8),ex6(:),G2H4(28),m3h2x4(:,37),heltab2x8(:,:,43))
  call Hloop_QA_V(ntryL,G2H8(9),ex6(:),G2H4(29),m3h2x4(:,38),heltab2x8(:,:,44))
  call Hloop_VA_Q(ntryL,G1H32(8),ex6(:),G1H16(4),m3h2x16(:,11),heltab2x32(:,:,23))
  call Hloop_A_Q(ntryL,G1H16(4),100,0,G2H16(7),n2h16(20))
call Hotf_5pt_reduction(G2H16(3),RedSet_5(15),mass5set(:,1),  & 
G1H16(7),G1H16(8),G1H16(9),G1H16(10),G1H16(13),G1H16(19),16)
call HG1shiftOLR(G1H16(8),4,16)
call Hotf_5pt_reduction(G2H16(4),RedSet_5(16),mass5set(:,1),  & 
G1H16(11),G1H16(15),G1H16(5),G1H16(18),G1H16(6),G1H16(17),16)
call HG1shiftOLR(G1H16(15),32,16)
  call Hloop_AQ_V(ntryL,G2H16(1),ex3(:),G2H8(11),m3h2x8(:,17),heltab2x16(:,:,28))
call Hotf_5pt_reduction(G2H16(2),RedSet_5(17),mass5set(:,1),  & 
G1H16(1),G1H16(2),G1H16(16),G1H16(12),G1H16(14),G1H16(23),16)
call HG1shiftOLR(G1H16(2),32,16)
  call Hloop_QA_V(ntryL,G2H16(5),ex6(:),G2H8(1),m3h2x8(:,18),heltab2x16(:,:,29))
call Hotf_5pt_reduction(G2H32(1),RedSet_5(18),mass5set(:,1),  & 
G1H32(9),G1H32(11),G1H32(5),G1H32(7),G1H32(2),G1H32(8),32)
call HG1shiftOLR(G1H32(11),32,32)
call Hotf_5pt_reduction(G2H32(2),RedSet_5(1),mass5set(:,1),  & 
G1H32(13),G1H32(14),G1H32(15),G1H32(16),G1H32(17),G1H32(18),32)
call HG1shiftOLR(G1H32(14),24,32)
call Hotf_5pt_reduction(G2H32(3),RedSet_5(19),mass5set(:,1),  & 
G1H32(19),G1H32(20),G1H32(21),G1H32(22),G1H32(23),G1H32(24),32)
call HG1shiftOLR(G1H32(20),32,32)
  call Hloop_QA_V(ntryL,G2H16(6),ex6(:),G2H8(8),m3h2x8(:,19),heltab2x16(:,:,30))
  call Hloop_AQ_V(ntryL,G2H16(8),ex3(:),G2H8(9),m3h2x8(:,20),heltab2x16(:,:,31))
  call Hloop_AQ_V(ntryL,G2H8(3),ex3(:),G2H4(30),m3h2x4(:,39),heltab2x8(:,:,45))
  call Hloop_AQ_V(ntryL,G2H8(5),ex3(:),G2H4(31),m3h2x4(:,40),heltab2x8(:,:,46))
  call Hloop_QA_V(ntryL,G2H32(4),ex5(:),G2H16(3),m3h2x16(:,12),heltab2x32(:,:,24))
  call Hloop_AQ_V(ntryL,G2H32(5),ex4(:),G2H16(4),m3h2x16(:,13),heltab2x32(:,:,25))
  call Hloop_VA_Q(ntryL,G1H32(3),ex6(:),G1H16(24),m3h2x16(:,14),heltab2x32(:,:,26))
  call Hloop_A_Q(ntryL,G1H16(24),104,0,G2H16(1),n2h16(21))
  call Hloop_VQ_A(ntryL,G1H32(1),wf8(:,6),G1H4(19),m3h8x4(:,1),heltab2x32(:,:,27))
  call Hloop_Q_A(ntryL,G1H4(19),79,0,G2H4(32),n2h4(36))
  call Hloop_VQ_A(ntryL,G1H32(10),ex4(:),G1H16(4),m3h2x16(:,15),heltab2x32(:,:,28))
  call Hloop_Q_A(ntryL,G1H16(4),76,nMT,G2H16(2),n2h16(22))
  call Hloop_AQ_V(ntryL,G2H32(6),ex4(:),G2H16(5),m3h2x16(:,16),heltab2x32(:,:,29))
  call Hloop_VQ_A(ntryL,G1H32(12),ex3(:),G1H16(24),m3h2x16(:,17),heltab2x32(:,:,30))
  call Hloop_Q_A(ntryL,G1H16(24),76,0,G2H16(6),n2h16(23))
  call Hloop_VA_Q(ntryL,G1H32(4),ex5(:),G1H16(4),m3h2x16(:,18),heltab2x32(:,:,31))
  call Hloop_A_Q(ntryL,G1H16(4),84,nMT,G2H16(8),n2h16(24))
  call Hloop_QA_V(ntryL,G2H32(7),ex5(:),G2H16(9),m3h2x16(:,19),heltab2x32(:,:,32))
  call Hloop_VA_Q(ntryL,G1H32(6),wf8(:,2),G1H4(20),m3h8x4(:,2),heltab2x32(:,:,33))
  call Hloop_A_Q(ntryL,G1H4(20),107,0,G2H4(33),n2h4(37))
  call Hloop_QA_V(ntryL,G2H32(8),wf8(:,2),G2H4(34),m3h8x4(:,3),heltab2x32(:,:,34))
  call Hloop_QA_V(ntryL,G2H32(9),wf8(:,2),G2H4(35),m3h8x4(:,4),heltab2x32(:,:,35))
  call Hloop_VQ_A(ntryL,G1H16(20),ex3(:),G1H8(30),m3h2x8(:,21),heltab2x16(:,:,32))
  call Hloop_Q_A(ntryL,G1H8(30),92,0,G2H8(3),n2h8(31))
call HGT_raise_alpha_OLR(G1H16(21),1,1,16)
call HGT_raise_alpha_invQ_OLR(G1H16(21),2,5,16)
  call Hloop_VA_Q(ntryL,G1H16(21),ex6(:),G1H8(34),m3h2x8(:,22),heltab2x16(:,:,33))
  call Hloop_VQ_A(ntryL,G1H16(25),ex3(:),G1H8(17),m3h2x8(:,23),heltab2x16(:,:,34))
  call Hloop_Q_A(ntryL,G1H8(17),92,0,G2H8(5),n2h8(32))
  call Hloop_VQ_A(ntryL,G1H16(26),ex3(:),G1H8(28),m3h2x8(:,24),heltab2x16(:,:,35))
  call Hloop_Q_A(ntryL,G1H8(28),92,0,G2H8(13),n2h8(33))
  call Hloop_VQ_A(ntryL,G1H16(3),ex3(:),G1H8(1),m3h2x8(:,25),heltab2x16(:,:,36))
  call Hloop_Q_A(ntryL,G1H8(1),92,0,G2H8(14),n2h8(34))
  call Hloop_QV_A(ntryL,G1H16(7),wf4(:,3),G1H4(24),m3h4x4(:,12),heltab2x16(:,:,37))
  call Hloop_Q_A(ntryL,G1H4(24),91,0,G2H4(36),n2h4(38))
call HGT_OLR(G1H16(8),1,1,16)
call HGT_invQ_OLR(G1H16(8),2,5,16)
  call Hloop_A_Q(ntryL,G1H16(8),-4,0,G2H16(10),n2h16(26))
  call Hloop_AQ_V(ntryL,G2H16(10),ex3(:),G2H8(15),m3h2x8(:,26),heltab2x16(:,:,38))
  call Hloop_QV_A(ntryL,G1H16(10),wf4(:,3),G1H4(7),m3h4x4(:,13),heltab2x16(:,:,39))
  call Hloop_Q_A(ntryL,G1H4(7),91,0,G2H4(37),n2h4(39))
  call Hloop_QV_A(ntryL,G1H16(13),wf4(:,3),G1H4(8),m3h4x4(:,14),heltab2x16(:,:,40))
  call Hloop_Q_A(ntryL,G1H4(8),91,0,G2H4(38),n2h4(40))
  call Hloop_QV_A(ntryL,G1H16(19),wf4(:,3),G1H4(12),m3h4x4(:,15),heltab2x16(:,:,41))
  call Hloop_Q_A(ntryL,G1H4(12),91,0,G2H4(39),n2h4(41))
  call Hloop_AW_Q(ntryL,G1H16(11),wf4(:,4),G1H4(13),m3h4x4(:,16),heltab2x16(:,:,42))
  call Hloop_A_Q(ntryL,G1H4(13),91,0,G2H4(40),n2h4(42))
call HGT_OLR(G1H16(15),1,1,16)
call HGT_invQ_OLR(G1H16(15),2,5,16)
  call Hloop_Q_A(ntryL,G1H16(15),-32,0,G2H16(10),n2h16(27))
  call Hloop_QA_V(ntryL,G2H16(10),ex6(:),G2H8(16),m3h2x8(:,27),heltab2x16(:,:,43))
  call Hloop_AW_Q(ntryL,G1H16(18),wf4(:,4),G1H4(14),m3h4x4(:,17),heltab2x16(:,:,44))
  call Hloop_A_Q(ntryL,G1H4(14),91,0,G2H4(41),n2h4(43))
  call Hloop_AW_Q(ntryL,G1H16(6),wf4(:,4),G1H4(19),m3h4x4(:,18),heltab2x16(:,:,45))
  call Hloop_A_Q(ntryL,G1H4(19),91,0,G2H4(42),n2h4(44))
  call Hloop_AW_Q(ntryL,G1H16(17),wf4(:,4),G1H4(20),m3h4x4(:,19),heltab2x16(:,:,46))
  call Hloop_A_Q(ntryL,G1H4(20),91,0,G2H4(43),n2h4(45))
  call Hloop_AV_Q(ntryL,G1H16(1),wf4(:,3),G1H4(24),m3h4x4(:,20),heltab2x16(:,:,47))
  call Hloop_A_Q(ntryL,G1H4(24),91,0,G2H4(44),n2h4(46))
call HGT_OLR(G1H16(2),1,1,16)
call HGT_invQ_OLR(G1H16(2),2,5,16)
  call Hloop_Q_A(ntryL,G1H16(2),-32,0,G2H16(10),n2h16(28))
  call Hloop_QA_V(ntryL,G2H16(10),ex6(:),G2H8(17),m3h2x8(:,28),heltab2x16(:,:,48))
  call Hloop_AV_Q(ntryL,G1H16(12),wf4(:,3),G1H4(7),m3h4x4(:,21),heltab2x16(:,:,49))
  call Hloop_A_Q(ntryL,G1H4(7),91,0,G2H4(45),n2h4(47))
  call Hloop_AV_Q(ntryL,G1H16(14),wf4(:,3),G1H4(8),m3h4x4(:,22),heltab2x16(:,:,50))
  call Hloop_A_Q(ntryL,G1H4(8),91,0,G2H4(46),n2h4(48))
  call Hloop_AV_Q(ntryL,G1H16(23),wf4(:,3),G1H4(12),m3h4x4(:,23),heltab2x16(:,:,51))
  call Hloop_A_Q(ntryL,G1H4(12),91,0,G2H4(47),n2h4(49))
  call Hloop_QW_A(ntryL,G1H32(9),wf4(:,4),G1H8(5),m3h4x8(:,13),heltab2x32(:,:,36))
  call Hloop_Q_A(ntryL,G1H8(5),71,0,G2H8(18),n2h8(35))
call HGT_raise_alpha_OLR(G1H32(11),1,1,32)
call HGT_raise_alpha_invQ_OLR(G1H32(11),2,5,32)
  call Hloop_VA_Q(ntryL,G1H32(11),ex6(:),G1H16(24),m3h2x16(:,20),heltab2x32(:,:,37))
  call Hloop_QW_A(ntryL,G1H32(7),wf4(:,4),G1H8(18),m3h4x8(:,14),heltab2x32(:,:,38))
  call Hloop_Q_A(ntryL,G1H8(18),71,0,G2H8(19),n2h8(36))
  call Hloop_QW_A(ntryL,G1H32(2),wf4(:,4),G1H8(7),m3h4x8(:,15),heltab2x32(:,:,39))
  call Hloop_Q_A(ntryL,G1H8(7),71,0,G2H8(20),n2h8(37))
  call Hloop_QW_A(ntryL,G1H32(8),wf4(:,4),G1H8(10),m3h4x8(:,16),heltab2x32(:,:,40))
  call Hloop_Q_A(ntryL,G1H8(10),71,0,G2H8(21),n2h8(38))
  call Hloop_QW_A(ntryL,G1H32(13),wf4(:,4),G1H8(22),m3h4x8(:,17),heltab2x32(:,:,41))
  call Hloop_Q_A(ntryL,G1H8(22),71,0,G2H8(22),n2h8(39))
call HGT_raise_alpha_OLR(G1H32(14),1,1,32)
call HGT_raise_alpha_invQ_OLR(G1H32(14),2,5,32)
  call Hloop_UV_W(ntryL,G1H32(14),-24,wf4(:,3),24,G2H8(23),m3h4x8(:,18),heltab2x32(:,:,42))
call signflip_OLR(G2H8(23))
  call Hloop_QW_A(ntryL,G1H32(16),wf4(:,4),G1H8(3),m3h4x8(:,19),heltab2x32(:,:,43))
  call Hloop_Q_A(ntryL,G1H8(3),71,0,G2H8(24),n2h8(40))
  call Hloop_QW_A(ntryL,G1H32(17),wf4(:,4),G1H8(4),m3h4x8(:,20),heltab2x32(:,:,44))
  call Hloop_Q_A(ntryL,G1H8(4),71,0,G2H8(25),n2h8(41))
  call Hloop_QW_A(ntryL,G1H32(18),wf4(:,4),G1H8(9),m3h4x8(:,21),heltab2x32(:,:,45))
  call Hloop_Q_A(ntryL,G1H8(9),71,0,G2H8(26),n2h8(42))
  call Hloop_QV_A(ntryL,G1H32(19),wf4(:,3),G1H8(11),m3h4x8(:,22),heltab2x32(:,:,46))
  call Hloop_Q_A(ntryL,G1H8(11),92,0,G2H8(27),n2h8(43))
call HGT_raise_alpha_OLR(G1H32(20),1,1,32)
call HGT_raise_alpha_invQ_OLR(G1H32(20),2,5,32)
  call Hloop_VA_Q(ntryL,G1H32(20),ex6(:),G1H16(4),m3h2x16(:,21),heltab2x32(:,:,47))
  call Hloop_QV_A(ntryL,G1H32(22),wf4(:,3),G1H8(12),m3h4x8(:,23),heltab2x32(:,:,48))
  call Hloop_Q_A(ntryL,G1H8(12),92,0,G2H8(28),n2h8(44))
  call Hloop_QV_A(ntryL,G1H32(23),wf4(:,3),G1H8(15),m3h4x8(:,24),heltab2x32(:,:,49))
  call Hloop_Q_A(ntryL,G1H8(15),92,0,G2H8(29),n2h8(45))
  call Hloop_QV_A(ntryL,G1H32(24),wf4(:,3),G1H8(16),m3h4x8(:,25),heltab2x32(:,:,50))
  call Hloop_Q_A(ntryL,G1H8(16),92,0,G2H8(30),n2h8(46))
  call ol_merge(ntryL,G2H4(35),[G2H4(2),G1H4(5)])
  call ol_merge(ntryL,G2H4(34),[G2H4(5),G1H4(17)])
  call ol_merge(ntryL,G2H4(29),[G1H4(15)])
call HGT_lower_alpha_w2_OLR(G2H4(8),1,1,4)
call HGT_lower_alpha_w2_invQ_OLR(G2H4(8),2,5,4)
call HGT_lower_alpha_w2_OLR(G2H4(8),6,15,4)
  call ol_merge(ntryL,G2H4(8),[G2H4(29)])
call HGT_lower_alpha_w2_OLR(G2H4(12),1,1,4)
call HGT_lower_alpha_w2_invQ_OLR(G2H4(12),2,5,4)
call HGT_lower_alpha_w2_OLR(G2H4(12),6,15,4)
  call ol_merge(ntryL,G2H4(12),[G2H4(30)])
  call ol_merge(ntryL,G2H8(4),[G1H8(14)])
  call ol_merge(ntryL,G2H8(6),[G1H8(6)])
call HGT_lower_alpha_w2_OLR(G2H8(7),1,1,8)
call HGT_lower_alpha_w2_invQ_OLR(G2H8(7),2,5,8)
call HGT_lower_alpha_w2_OLR(G2H8(7),6,15,8)
  call ol_merge(ntryL,G2H8(7),[G2H8(6)])
  call ol_merge(ntryL,G2H4(32),[G2H4(16)])
  call ol_merge(ntryL,G2H4(28),[G1H4(3)])
call HGT_lower_alpha_w2_OLR(G2H4(19),1,1,4)
call HGT_lower_alpha_w2_invQ_OLR(G2H4(19),2,5,4)
call HGT_lower_alpha_w2_OLR(G2H4(19),6,15,4)
  call ol_merge(ntryL,G2H4(19),[G2H4(28)])
call HGT_lower_alpha_w2_OLR(G2H4(23),1,1,4)
call HGT_lower_alpha_w2_invQ_OLR(G2H4(23),2,5,4)
call HGT_lower_alpha_w2_OLR(G2H4(23),6,15,4)
  call ol_merge(ntryL,G2H4(23),[G2H4(31)])
  call ol_merge(ntryL,G2H8(12),[G1H8(27)])
  call ol_merge(ntryL,G2H4(33),[G2H4(27)])
  call ol_merge(ntryL,G2H4(3),[G1H4(4)])
  call ol_merge(ntryL,G2H4(6),[G1H4(16)])
  call ol_merge(ntryL,G2H8(3),[G1H8(26),G1H8(13)])
  call ol_merge(ntryL,G2H8(13),[G1H8(32),G1H8(23)])
  call ol_merge(ntryL,G2H8(10),[G1H8(25)])
call Hotf_5pt_reduction(G2H4(35),RedSet_5(20),mass5set(:,2),  & 
G1H4(13),G1H4(14),G1H4(19),G1H4(20),G1H4(24),G1H4(7),4)
call HG1shiftOLR(G1H4(14),16,4)
call Hotf_5pt_reduction(G2H4(34),RedSet_5(21),mass5set(:,2),  & 
G1H4(8),G1H4(12),G1H4(5),G1H4(17),G1H4(15),G1H4(3),4)
call HG1shiftOLR(G1H4(12),8,4)
call Hotf_5pt_reduction(G2H4(8),RedSet_5(22),mass5set(:,2),  & 
G1H4(4),G1H4(16),G1H4(25),G1H4(26),G1H4(27),G1H4(28),4)
call HG1shiftOLR(G1H4(16),8,4)
  call Hloop_AQ_V(ntryL,G2H4(9),ex4(:),G2H2(1),m3h2x2(:,23),heltab2x4(:,:,23))
call Hotf_5pt_reduction(G2H4(12),RedSet_5(23),mass5set(:,2),  & 
G1H4(29),G1H4(30),G1H4(31),G1H4(32),G1H4(33),G1H4(34),4)
call HG1shiftOLR(G1H4(30),16,4)
  call Hloop_QA_V(ntryL,G2H4(13),ex5(:),G2H2(3),m3h2x2(:,24),heltab2x4(:,:,24))
call HGT_w2_OLR(G1H8(2),1,1,8)
call HGT_w2_invQ_OLR(G1H8(2),2,5,8)
  call Hloop_VQ_A(ntryL,G1H8(2),ex3(:),G1H4(35),m3h2x4(:,41),heltab2x8(:,:,47))
  call Hloop_Q_A(ntryL,G1H4(35),124,0,G2H4(2),n2h4(50))
call Hotf_5pt_reduction(G2H8(4),RedSet_5(24),mass5set(:,3),  & 
G1H8(21),G1H8(19),G1H8(29),G1H8(30),G1H8(17),G1H8(28),8)
call HG1shiftOLR(G1H8(19),32,8)
call Hotf_5pt_reduction(G2H8(7),RedSet_5(25),mass5set(:,5),  & 
G1H8(1),G1H8(5),G1H8(18),G1H8(7),G1H8(10),G1H8(22),8)
call HG1shiftOLR(G1H8(5),32,8)
  call Hloop_QA_V(ntryL,G2H4(32),ex6(:),G2H2(5),m3h2x2(:,25),heltab2x4(:,:,25))
call Hotf_5pt_reduction(G2H4(19),RedSet_5(26),mass5set(:,2),  & 
G1H4(35),G1H4(36),G1H4(37),G1H4(38),G1H4(39),G1H4(40),4)
call HG1shiftOLR(G1H4(36),16,4)
  call Hloop_QA_V(ntryL,G2H4(20),ex5(:),G2H2(7),m3h2x2(:,26),heltab2x4(:,:,26))
call Hotf_5pt_reduction(G2H4(23),RedSet_5(27),mass5set(:,2),  & 
G1H4(41),G1H4(42),G1H4(43),G1H4(44),G1H4(45),G1H4(46),4)
call HG1shiftOLR(G1H4(42),8,4)
  call Hloop_AQ_V(ntryL,G2H4(24),ex4(:),G2H2(9),m3h2x2(:,27),heltab2x4(:,:,27))
call HGT_w2_OLR(G1H8(8),1,1,8)
call HGT_w2_invQ_OLR(G1H8(8),2,5,8)
  call Hloop_VQ_A(ntryL,G1H8(8),ex3(:),G1H4(47),m3h2x4(:,42),heltab2x8(:,:,48))
  call Hloop_Q_A(ntryL,G1H4(47),124,0,G2H4(5),n2h4(51))
call Hotf_5pt_reduction(G2H8(12),RedSet_5(28),mass5set(:,3),  & 
G1H8(3),G1H8(4),G1H8(9),G1H8(11),G1H8(12),G1H8(15),8)
call HG1shiftOLR(G1H8(4),32,8)
call HGT_lower_alpha_w2_OLR(G2H8(2),1,1,8)
call HGT_lower_alpha_w2_invQ_OLR(G2H8(2),2,5,8)
call HGT_lower_alpha_w2_OLR(G2H8(2),6,15,8)
call Hotf_5pt_reduction(G2H8(2),RedSet_5(29),mass5set(:,5),  & 
G1H8(16),G1H8(14),G1H8(6),G1H8(27),G1H8(26),G1H8(13),8)
call HG1shiftOLR(G1H8(14),4,8)
  call Hloop_AQ_V(ntryL,G2H4(33),ex3(:),G2H2(11),m3h2x2(:,28),heltab2x4(:,:,28))
call Hotf_5pt_reduction(G2H4(3),RedSet_5(30),mass5set(:,2),  & 
G1H4(47),G1H4(48),G1H4(49),G1H4(50),G1H4(51),G1H4(52),4)
call HG1shiftOLR(G1H4(48),16,4)
  call Hloop_VQ_A(ntryL,G1H4(9),ex4(:),G1H2(5),m3h2x2(:,29),heltab2x4(:,:,29))
  call Hloop_Q_A(ntryL,G1H2(5),111,nMT,G2H2(13),n2h2(13))
  call Hloop_VQ_A(ntryL,G1H4(10),ex4(:),G1H2(6),m3h2x2(:,30),heltab2x4(:,:,30))
  call Hloop_Q_A(ntryL,G1H2(6),111,nMT,G2H2(16),n2h2(14))
  call Hloop_VQ_A(ntryL,G1H4(11),ex4(:),G1H2(11),m3h2x2(:,31),heltab2x4(:,:,31))
  call Hloop_Q_A(ntryL,G1H2(11),111,nMT,G2H2(19),n2h2(15))
call Hotf_5pt_reduction(G2H4(6),RedSet_5(31),mass5set(:,2),  & 
G1H4(9),G1H4(10),G1H4(11),G1H4(53),G1H4(54),G1H4(55),4)
call HG1shiftOLR(G1H4(10),8,4)
  call Hloop_VA_Q(ntryL,G1H4(21),ex5(:),G1H2(12),m3h2x2(:,32),heltab2x4(:,:,32))
  call Hloop_A_Q(ntryL,G1H2(12),119,nMT,G2H2(22),n2h2(16))
  call Hloop_VA_Q(ntryL,G1H4(22),ex5(:),G1H2(17),m3h2x2(:,33),heltab2x4(:,:,33))
  call Hloop_A_Q(ntryL,G1H2(17),119,nMT,G2H2(25),n2h2(17))
  call Hloop_VA_Q(ntryL,G1H4(23),ex5(:),G1H2(18),m3h2x2(:,34),heltab2x4(:,:,34))
  call Hloop_A_Q(ntryL,G1H2(18),119,nMT,G2H2(26),n2h2(18))
call Hotf_5pt_reduction(G2H8(3),RedSet_5(14),mass5set(:,1),  & 
G1H8(32),G1H8(23),G1H8(25),G1H8(2),G1H8(8),G1H8(35),8)
call HG1shiftOLR(G1H8(23),32,8)
  call Hloop_QW_A(ntryL,G1H8(20),wf4(:,4),G1H2(23),m3h4x2(:,7),heltab2x8(:,:,49))
  call Hloop_Q_A(ntryL,G1H2(23),95,0,G2H2(27),n2h2(19))
call Hotf_4pt_reduction(G2H8(13),RedSet_4(32),mass4set(:,1),  & 
G1H8(20),G1H8(36),G1H8(37),G1H8(38),G1H8(39),8)
call HG1shiftOLR(G1H8(36),32,8)
  call Hloop_QW_A(ntryL,G1H8(24),wf4(:,4),G1H2(24),m3h4x2(:,8),heltab2x8(:,:,50))
  call Hloop_Q_A(ntryL,G1H2(24),95,0,G2H2(28),n2h2(20))
call Hotf_5pt_reduction(G2H8(10),RedSet_5(32),mass5set(:,5),  & 
G1H8(24),G1H8(40),G1H8(41),G1H8(42),G1H8(43),G1H8(44),8)
call HG1shiftOLR(G1H8(40),32,8)
  call Hloop_QW_A(ntryL,G1H8(31),wf4(:,4),G1H2(29),m3h4x2(:,9),heltab2x8(:,:,51))
  call Hloop_Q_A(ntryL,G1H2(29),95,0,G2H2(29),n2h2(21))
  call Hloop_QW_A(ntryL,G1H8(33),wf4(:,4),G1H2(30),m3h4x2(:,10),heltab2x8(:,:,52))
  call Hloop_Q_A(ntryL,G1H2(30),95,0,G2H2(30),n2h2(22))
  call Hloop_QA_V(ntryL,G2H4(1),ex6(:),G2H2(31),m3h2x2(:,35),heltab2x4(:,:,35))
  call Hloop_QA_V(ntryL,G2H4(4),ex6(:),G2H2(32),m3h2x2(:,36),heltab2x4(:,:,36))
  call Hloop_AQ_V(ntryL,G2H4(7),ex4(:),G2H2(33),m3h2x2(:,37),heltab2x4(:,:,37))
  call Hloop_AQ_V(ntryL,G2H4(10),ex4(:),G2H2(34),m3h2x2(:,38),heltab2x4(:,:,38))
  call Hloop_QA_V(ntryL,G2H4(11),ex5(:),G2H2(35),m3h2x2(:,39),heltab2x4(:,:,39))
  call Hloop_QA_V(ntryL,G2H4(14),ex5(:),G2H2(36),m3h2x2(:,40),heltab2x4(:,:,40))
  call Hloop_QA_V(ntryL,G2H4(15),ex6(:),G2H2(37),m3h2x2(:,41),heltab2x4(:,:,41))
  call Hloop_QA_V(ntryL,G2H4(17),ex5(:),G2H2(38),m3h2x2(:,42),heltab2x4(:,:,42))
  call Hloop_QA_V(ntryL,G2H4(18),ex5(:),G2H2(39),m3h2x2(:,43),heltab2x4(:,:,43))
  call Hloop_AQ_V(ntryL,G2H4(21),ex4(:),G2H2(40),m3h2x2(:,44),heltab2x4(:,:,44))
  call Hloop_AQ_V(ntryL,G2H4(22),ex4(:),G2H2(41),m3h2x2(:,45),heltab2x4(:,:,45))
  call Hloop_AQ_V(ntryL,G2H4(25),ex3(:),G2H2(42),m3h2x2(:,46),heltab2x4(:,:,46))
  call Hloop_AQ_V(ntryL,G2H4(26),ex3(:),G2H2(43),m3h2x2(:,47),heltab2x4(:,:,47))
call Hotf_5pt_reduction(G2H16(7),RedSet_5(33),mass5set(:,1),  & 
G1H16(20),G1H16(21),G1H16(25),G1H16(26),G1H16(3),G1H16(7),16)
call HG1shiftOLR(G1H16(21),24,16)
call Hotf_5pt_reduction(G2H8(11),RedSet_5(34),mass5set(:,1),  & 
G1H8(31),G1H8(33),G1H8(45),G1H8(46),G1H8(47),G1H8(48),8)
call HG1shiftOLR(G1H8(33),24,8)
call Hotf_5pt_reduction(G2H8(1),RedSet_5(35),mass5set(:,1),  & 
G1H8(49),G1H8(50),G1H8(51),G1H8(52),G1H8(53),G1H8(54),8)
call HG1shiftOLR(G1H8(50),24,8)
call Hotf_5pt_reduction(G2H8(8),RedSet_5(36),mass5set(:,1),  & 
G1H8(55),G1H8(56),G1H8(57),G1H8(58),G1H8(59),G1H8(60),8)
call HG1shiftOLR(G1H8(56),4,8)
call Hotf_5pt_reduction(G2H8(9),RedSet_5(37),mass5set(:,1),  & 
G1H8(61),G1H8(62),G1H8(63),G1H8(64),G1H8(65),G1H8(66),8)
call HG1shiftOLR(G1H8(62),32,8)
call Hotf_5pt_reduction(G2H16(3),RedSet_5(13),mass5set(:,3),  & 
G1H16(8),G1H16(10),G1H16(13),G1H16(19),G1H16(11),G1H16(15),16)
call HG1shiftOLR(G1H16(10),32,16)
call Hotf_5pt_reduction(G2H16(4),RedSet_5(12),mass5set(:,3),  & 
G1H16(18),G1H16(6),G1H16(17),G1H16(1),G1H16(2),G1H16(12),16)
call HG1shiftOLR(G1H16(6),32,16)
  call Hloop_AQ_V(ntryL,G2H16(1),wf8(:,6),G2H2(44),m3h8x2(:,1),heltab2x16(:,:,52))
  call Hloop_QA_V(ntryL,G2H16(2),ex5(:),G2H8(6),m3h2x8(:,29),heltab2x16(:,:,53))
call Hotf_5pt_reduction(G2H16(5),RedSet_5(4),mass5set(:,3),  & 
G1H16(14),G1H16(23),G1H16(27),G1H16(28),G1H16(29),G1H16(30),16)
call HG1shiftOLR(G1H16(23),35,16)
  call Hloop_QA_V(ntryL,G2H16(6),wf8(:,2),G2H2(45),m3h8x2(:,2),heltab2x16(:,:,54))
  call Hloop_AQ_V(ntryL,G2H16(8),ex4(:),G2H8(4),m3h2x8(:,30),heltab2x16(:,:,55))
call Hotf_5pt_reduction(G2H16(9),RedSet_5(8),mass5set(:,3),  & 
G1H16(31),G1H16(32),G1H16(33),G1H16(34),G1H16(35),G1H16(36),16)
call HG1shiftOLR(G1H16(32),35,16)
call Hotf_4pt_reduction(G2H8(14),RedSet_4(33),mass4set(:,1),  & 
G1H8(67),G1H8(68),G1H8(69),G1H8(70),G1H8(71),8)
call HG1shiftOLR(G1H8(68),35,8)
  call Hloop_QA_V(ntryL,G2H4(36),ex6(:),G2H2(46),m3h2x2(:,48),heltab2x4(:,:,48))
  call Hloop_QA_V(ntryL,G2H4(38),ex6(:),G2H2(47),m3h2x2(:,49),heltab2x4(:,:,49))
  call Hloop_QA_V(ntryL,G2H4(39),ex6(:),G2H2(48),m3h2x2(:,50),heltab2x4(:,:,50))
  call Hloop_AQ_V(ntryL,G2H4(40),ex3(:),G2H2(49),m3h2x2(:,51),heltab2x4(:,:,51))
  call Hloop_AQ_V(ntryL,G2H4(42),ex3(:),G2H2(50),m3h2x2(:,52),heltab2x4(:,:,52))
  call Hloop_AQ_V(ntryL,G2H4(43),ex3(:),G2H2(51),m3h2x2(:,53),heltab2x4(:,:,53))
  call Hloop_AQ_V(ntryL,G2H4(44),ex3(:),G2H2(52),m3h2x2(:,54),heltab2x4(:,:,54))
  call Hloop_AQ_V(ntryL,G2H4(46),ex3(:),G2H2(53),m3h2x2(:,55),heltab2x4(:,:,55))
  call Hloop_AQ_V(ntryL,G2H4(47),ex3(:),G2H2(54),m3h2x2(:,56),heltab2x4(:,:,56))
call Hotf_5pt_reduction(G2H8(18),RedSet_5(18),mass5set(:,1),  & 
G1H8(72),G1H8(73),G1H8(74),G1H8(75),G1H8(76),G1H8(77),8)
call HG1shiftOLR(G1H8(73),32,8)
call Hotf_4pt_reduction(G2H8(20),RedSet_4(126),mass4set(:,1),  & 
G1H8(78),G1H8(79),G1H8(80),G1H8(81),G1H8(82),8)
call HG1shiftOLR(G1H8(79),32,8)
call Hotf_4pt_reduction(G2H8(21),RedSet_4(13),mass4set(:,1),  & 
G1H8(83),G1H8(84),G1H8(85),G1H8(86),G1H8(87),8)
call HG1shiftOLR(G1H8(84),56,8)
  call Hloop_QA_V(ntryL,G2H8(22),ex6(:),G2H4(29),m3h2x4(:,43),heltab2x8(:,:,53))
  call Hloop_QA_V(ntryL,G2H8(25),ex6(:),G2H4(30),m3h2x4(:,44),heltab2x8(:,:,54))
  call Hloop_QA_V(ntryL,G2H8(26),ex6(:),G2H4(16),m3h2x4(:,45),heltab2x8(:,:,55))
call Hotf_5pt_reduction(G2H8(27),RedSet_5(19),mass5set(:,1),  & 
G1H8(88),G1H8(89),G1H8(90),G1H8(91),G1H8(92),G1H8(93),8)
call HG1shiftOLR(G1H8(89),32,8)
call Hotf_4pt_reduction(G2H8(29),RedSet_4(126),mass4set(:,1),  & 
G1H8(94),G1H8(95),G1H8(96),G1H8(97),G1H8(98),8)
call HG1shiftOLR(G1H8(95),32,8)
call Hotf_4pt_reduction(G2H8(30),RedSet_4(127),mass4set(:,1),  & 
G1H8(99),G1H8(100),G1H8(101),G1H8(102),G1H8(103),8)
call HG1shiftOLR(G1H8(100),35,8)
  call ol_merge(ntryL,G1H8(20),[G1H8(8)])
  call ol_merge(ntryL,G1H8(67),[G1H8(35)])
  call ol_merge(ntryL,G1H8(78),[G1H8(76)])
  call ol_merge(ntryL,G1H8(83),[G1H8(77)])
  call ol_merge(ntryL,G1H8(94),[G1H8(92)])
  call ol_merge(ntryL,G1H8(99),[G1H8(93)])
  call Hloop_VQ_A(ntryL,G1H4(13),ex4(:),G1H2(35),m3h2x2(:,57),heltab2x4(:,:,57))
  call Hloop_Q_A(ntryL,G1H2(35),111,nMT,G2H2(55),n2h2(23))
call HGT_raise_alpha_OLR(G1H4(14),1,1,4)
call HGT_raise_alpha_invQ_OLR(G1H4(14),2,5,4)
  call Hloop_VA_Q(ntryL,G1H4(14),ex5(:),G1H2(36),m3h2x2(:,58),heltab2x4(:,:,58))
  call Hloop_VQ_A(ntryL,G1H4(24),ex4(:),G1H2(5),m3h2x2(:,59),heltab2x4(:,:,59))
  call Hloop_Q_A(ntryL,G1H2(5),111,nMT,G2H2(56),n2h2(24))
  call Hloop_VQ_A(ntryL,G1H4(7),ex4(:),G1H2(6),m3h2x2(:,60),heltab2x4(:,:,60))
  call Hloop_Q_A(ntryL,G1H2(6),111,nMT,G2H2(57),n2h2(25))
  call Hloop_VA_Q(ntryL,G1H4(8),ex5(:),G1H2(11),m3h2x2(:,61),heltab2x4(:,:,61))
  call Hloop_A_Q(ntryL,G1H2(11),119,nMT,G2H2(58),n2h2(26))
call HGT_raise_alpha_OLR(G1H4(12),1,1,4)
call HGT_raise_alpha_invQ_OLR(G1H4(12),2,5,4)
  call Hloop_VQ_A(ntryL,G1H4(12),ex4(:),G1H2(12),m3h2x2(:,62),heltab2x4(:,:,62))
  call Hloop_VA_Q(ntryL,G1H4(15),ex5(:),G1H2(17),m3h2x2(:,63),heltab2x4(:,:,63))
  call Hloop_A_Q(ntryL,G1H2(17),119,nMT,G2H2(59),n2h2(27))
  call Hloop_VA_Q(ntryL,G1H4(3),ex5(:),G1H2(18),m3h2x2(:,64),heltab2x4(:,:,64))
  call Hloop_A_Q(ntryL,G1H2(18),119,nMT,G2H2(60),n2h2(28))
  call Hloop_VA_Q(ntryL,G1H4(4),ex5(:),G1H2(23),m3h2x2(:,65),heltab2x4(:,:,65))
  call Hloop_A_Q(ntryL,G1H2(23),119,nMT,G2H2(61),n2h2(29))
call HGT_raise_alpha_OLR(G1H4(16),1,1,4)
call HGT_raise_alpha_invQ_OLR(G1H4(16),2,5,4)
  call Hloop_VQ_A(ntryL,G1H4(16),ex4(:),G1H2(24),m3h2x2(:,66),heltab2x4(:,:,66))
  call Hloop_VA_Q(ntryL,G1H4(27),ex5(:),G1H2(29),m3h2x2(:,67),heltab2x4(:,:,67))
  call Hloop_A_Q(ntryL,G1H2(29),119,nMT,G2H2(62),n2h2(30))
  call Hloop_VA_Q(ntryL,G1H4(28),ex5(:),G1H2(30),m3h2x2(:,68),heltab2x4(:,:,68))
  call Hloop_A_Q(ntryL,G1H2(30),119,nMT,G2H2(63),n2h2(31))
  call Hloop_VQ_A(ntryL,G1H4(29),ex4(:),G1H2(35),m3h2x2(:,69),heltab2x4(:,:,69))
  call Hloop_Q_A(ntryL,G1H2(35),111,nMT,G2H2(64),n2h2(32))
call HGT_raise_alpha_OLR(G1H4(30),1,1,4)
call HGT_raise_alpha_invQ_OLR(G1H4(30),2,5,4)
  call Hloop_VA_Q(ntryL,G1H4(30),ex5(:),G1H2(5),m3h2x2(:,70),heltab2x4(:,:,70))
  call Hloop_VQ_A(ntryL,G1H4(33),ex4(:),G1H2(6),m3h2x2(:,71),heltab2x4(:,:,71))
  call Hloop_Q_A(ntryL,G1H2(6),111,nMT,G2H2(65),n2h2(33))
  call Hloop_VQ_A(ntryL,G1H4(34),ex4(:),G1H2(11),m3h2x2(:,72),heltab2x4(:,:,72))
  call Hloop_Q_A(ntryL,G1H2(11),111,nMT,G2H2(66),n2h2(34))
  call Hloop_QW_A(ntryL,G1H8(21),wf4(:,4),G1H2(17),m3h4x2(:,11),heltab2x8(:,:,56))
  call Hloop_Q_A(ntryL,G1H2(17),95,0,G2H2(67),n2h2(35))
call HGT_raise_alpha_OLR(G1H8(19),1,1,8)
call HGT_raise_alpha_invQ_OLR(G1H8(19),2,5,8)
  call Hloop_VA_Q(ntryL,G1H8(19),ex6(:),G1H4(21),m3h2x4(:,46),heltab2x8(:,:,57))
  call Hloop_QW_A(ntryL,G1H8(17),wf4(:,4),G1H2(18),m3h4x2(:,12),heltab2x8(:,:,58))
  call Hloop_Q_A(ntryL,G1H2(18),95,0,G2H2(68),n2h2(36))
  call Hloop_QW_A(ntryL,G1H8(28),wf4(:,4),G1H2(23),m3h4x2(:,13),heltab2x8(:,:,59))
  call Hloop_Q_A(ntryL,G1H2(23),95,0,G2H2(69),n2h2(37))
  call Hloop_QW_A(ntryL,G1H8(1),wf4(:,4),G1H2(29),m3h4x2(:,14),heltab2x8(:,:,60))
  call Hloop_Q_A(ntryL,G1H2(29),95,0,G2H2(70),n2h2(38))
call HGT_raise_alpha_OLR(G1H8(5),1,1,8)
call HGT_raise_alpha_invQ_OLR(G1H8(5),2,5,8)
  call Hloop_VA_Q(ntryL,G1H8(5),ex6(:),G1H4(22),m3h2x4(:,47),heltab2x8(:,:,61))
  call Hloop_QW_A(ntryL,G1H8(10),wf4(:,4),G1H2(30),m3h4x2(:,15),heltab2x8(:,:,62))
  call Hloop_Q_A(ntryL,G1H2(30),95,0,G2H2(71),n2h2(39))
  call Hloop_QW_A(ntryL,G1H8(22),wf4(:,4),G1H2(35),m3h4x2(:,16),heltab2x8(:,:,63))
  call Hloop_Q_A(ntryL,G1H2(35),95,0,G2H2(72),n2h2(40))
  call Hloop_VQ_A(ntryL,G1H4(35),ex4(:),G1H2(6),m3h2x2(:,73),heltab2x4(:,:,73))
  call Hloop_Q_A(ntryL,G1H2(6),111,nMT,G2H2(73),n2h2(41))
call HGT_raise_alpha_OLR(G1H4(36),1,1,4)
call HGT_raise_alpha_invQ_OLR(G1H4(36),2,5,4)
  call Hloop_VA_Q(ntryL,G1H4(36),ex5(:),G1H2(11),m3h2x2(:,74),heltab2x4(:,:,74))
  call Hloop_VQ_A(ntryL,G1H4(39),ex4(:),G1H2(17),m3h2x2(:,75),heltab2x4(:,:,75))
  call Hloop_Q_A(ntryL,G1H2(17),111,nMT,G2H2(74),n2h2(42))
  call Hloop_VQ_A(ntryL,G1H4(40),ex4(:),G1H2(18),m3h2x2(:,76),heltab2x4(:,:,76))
  call Hloop_Q_A(ntryL,G1H2(18),111,nMT,G2H2(75),n2h2(43))
  call Hloop_VA_Q(ntryL,G1H4(41),ex5(:),G1H2(23),m3h2x2(:,77),heltab2x4(:,:,77))
  call Hloop_A_Q(ntryL,G1H2(23),119,nMT,G2H2(76),n2h2(44))
call HGT_raise_alpha_OLR(G1H4(42),1,1,4)
call HGT_raise_alpha_invQ_OLR(G1H4(42),2,5,4)
  call Hloop_VQ_A(ntryL,G1H4(42),ex4(:),G1H2(29),m3h2x2(:,78),heltab2x4(:,:,78))
  call Hloop_VA_Q(ntryL,G1H4(45),ex5(:),G1H2(30),m3h2x2(:,79),heltab2x4(:,:,79))
  call Hloop_A_Q(ntryL,G1H2(30),119,nMT,G2H2(77),n2h2(45))
  call Hloop_VA_Q(ntryL,G1H4(46),ex5(:),G1H2(35),m3h2x2(:,80),heltab2x4(:,:,80))
  call Hloop_A_Q(ntryL,G1H2(35),119,nMT,G2H2(78),n2h2(46))
  call Hloop_QW_A(ntryL,G1H8(3),wf4(:,4),G1H2(6),m3h4x2(:,17),heltab2x8(:,:,64))
  call Hloop_Q_A(ntryL,G1H2(6),95,0,G2H2(79),n2h2(47))
call HGT_raise_alpha_OLR(G1H8(4),1,1,8)
call HGT_raise_alpha_invQ_OLR(G1H8(4),2,5,8)
  call Hloop_VA_Q(ntryL,G1H8(4),ex6(:),G1H4(23),m3h2x4(:,48),heltab2x8(:,:,65))
  call Hloop_QW_A(ntryL,G1H8(12),wf4(:,4),G1H2(17),m3h4x2(:,18),heltab2x8(:,:,66))
  call Hloop_Q_A(ntryL,G1H2(17),95,0,G2H2(80),n2h2(48))
  call Hloop_QW_A(ntryL,G1H8(15),wf4(:,4),G1H2(18),m3h4x2(:,19),heltab2x8(:,:,67))
  call Hloop_Q_A(ntryL,G1H2(18),95,0,G2H2(81),n2h2(49))
  call Hloop_AW_Q(ntryL,G1H8(16),wf4(:,4),G1H2(23),m3h4x2(:,20),heltab2x8(:,:,68))
  call Hloop_A_Q(ntryL,G1H2(23),123,0,G2H2(82),n2h2(50))
call HGT_raise_alpha_OLR(G1H8(14),1,1,8)
call HGT_raise_alpha_invQ_OLR(G1H8(14),2,5,8)
  call Hloop_VQ_A(ntryL,G1H8(14),ex3(:),G1H4(13),m3h2x4(:,49),heltab2x8(:,:,69))
  call Hloop_AW_Q(ntryL,G1H8(26),wf4(:,4),G1H2(30),m3h4x2(:,21),heltab2x8(:,:,70))
  call Hloop_A_Q(ntryL,G1H2(30),123,0,G2H2(83),n2h2(51))
  call Hloop_AW_Q(ntryL,G1H8(13),wf4(:,4),G1H2(35),m3h4x2(:,22),heltab2x8(:,:,71))
  call Hloop_A_Q(ntryL,G1H2(35),123,0,G2H2(84),n2h2(52))
  call Hloop_VQ_A(ntryL,G1H4(47),ex4(:),G1H2(6),m3h2x2(:,81),heltab2x4(:,:,81))
  call Hloop_Q_A(ntryL,G1H2(6),111,nMT,G2H2(85),n2h2(53))
call HGT_raise_alpha_OLR(G1H4(48),1,1,4)
call HGT_raise_alpha_invQ_OLR(G1H4(48),2,5,4)
  call Hloop_VA_Q(ntryL,G1H4(48),ex5(:),G1H2(17),m3h2x2(:,82),heltab2x4(:,:,82))
  call Hloop_VQ_A(ntryL,G1H4(51),ex4(:),G1H2(18),m3h2x2(:,83),heltab2x4(:,:,83))
  call Hloop_Q_A(ntryL,G1H2(18),111,nMT,G2H2(86),n2h2(54))
  call Hloop_VQ_A(ntryL,G1H4(52),ex4(:),G1H2(23),m3h2x2(:,84),heltab2x4(:,:,84))
  call Hloop_Q_A(ntryL,G1H2(23),111,nMT,G2H2(87),n2h2(55))
  call Hloop_VA_Q(ntryL,G1H4(9),ex5(:),G1H2(30),m3h2x2(:,85),heltab2x4(:,:,85))
  call Hloop_A_Q(ntryL,G1H2(30),119,nMT,G2H2(88),n2h2(56))
call HGT_raise_alpha_OLR(G1H4(10),1,1,4)
call HGT_raise_alpha_invQ_OLR(G1H4(10),2,5,4)
  call Hloop_VQ_A(ntryL,G1H4(10),ex4(:),G1H2(35),m3h2x2(:,86),heltab2x4(:,:,86))
  call Hloop_VA_Q(ntryL,G1H4(54),ex5(:),G1H2(6),m3h2x2(:,87),heltab2x4(:,:,87))
  call Hloop_A_Q(ntryL,G1H2(6),119,nMT,G2H2(89),n2h2(57))
  call Hloop_VA_Q(ntryL,G1H4(55),ex5(:),G1H2(18),m3h2x2(:,88),heltab2x4(:,:,88))
  call Hloop_A_Q(ntryL,G1H2(18),119,nMT,G2H2(90),n2h2(58))
  call Hloop_QW_A(ntryL,G1H8(32),wf4(:,4),G1H2(23),m3h4x2(:,23),heltab2x8(:,:,72))
  call Hloop_Q_A(ntryL,G1H2(23),95,0,G2H2(91),n2h2(59))
call HGT_raise_alpha_OLR(G1H8(23),1,1,8)
call HGT_raise_alpha_invQ_OLR(G1H8(23),2,5,8)
  call Hloop_VA_Q(ntryL,G1H8(23),ex6(:),G1H4(14),m3h2x4(:,50),heltab2x8(:,:,73))
  call Hloop_QW_A(ntryL,G1H8(20),wf4(:,4),G1H2(30),m3h4x2(:,24),heltab2x8(:,:,74))
  call Hloop_Q_A(ntryL,G1H2(30),95,0,G2H2(92),n2h2(60))
  call Hloop_QW_A(ntryL,G1H8(67),wf4(:,4),G1H2(6),m3h4x2(:,25),heltab2x8(:,:,75))
  call Hloop_Q_A(ntryL,G1H2(6),95,0,G2H2(93),n2h2(61))
call HGT_raise_alpha_OLR(G1H8(36),1,1,8)
call HGT_raise_alpha_invQ_OLR(G1H8(36),2,5,8)
  call Hloop_VA_Q(ntryL,G1H8(36),ex6(:),G1H4(24),m3h2x4(:,51),heltab2x8(:,:,76))
  call Hloop_QW_A(ntryL,G1H8(39),wf4(:,4),G1H2(18),m3h4x2(:,26),heltab2x8(:,:,77))
  call Hloop_Q_A(ntryL,G1H2(18),95,0,G2H2(94),n2h2(62))
  call Hloop_QW_A(ntryL,G1H8(24),wf4(:,4),G1H2(23),m3h4x2(:,27),heltab2x8(:,:,78))
  call Hloop_Q_A(ntryL,G1H2(23),95,0,G2H2(95),n2h2(63))
call HGT_raise_alpha_OLR(G1H8(40),1,1,8)
call HGT_raise_alpha_invQ_OLR(G1H8(40),2,5,8)
  call Hloop_VA_Q(ntryL,G1H8(40),ex6(:),G1H4(7),m3h2x4(:,52),heltab2x8(:,:,79))
  call Hloop_QW_A(ntryL,G1H8(43),wf4(:,4),G1H2(30),m3h4x2(:,28),heltab2x8(:,:,80))
  call Hloop_Q_A(ntryL,G1H2(30),95,0,G2H2(96),n2h2(64))
  call Hloop_QW_A(ntryL,G1H8(44),wf4(:,4),G1H2(6),m3h4x2(:,29),heltab2x8(:,:,81))
  call Hloop_Q_A(ntryL,G1H2(6),95,0,G2H2(97),n2h2(65))
  call Hloop_AW_Q(ntryL,G1H16(20),wf4(:,4),G1H4(8),m3h4x4(:,24),heltab2x16(:,:,56))
  call Hloop_A_Q(ntryL,G1H4(8),103,0,G2H4(28),n2h4(60))
call HGT_OLR(G1H16(21),1,1,16)
call HGT_invQ_OLR(G1H16(21),2,5,16)
  call Hloop_Q_A(ntryL,G1H16(21),-24,0,G2H16(10),n2h16(29))
  call Hloop_QV_A(ntryL,G2H16(10),wf4(:,3),G2H4(31),m3h4x4(:,25),heltab2x16(:,:,57))
  call Hloop_AW_Q(ntryL,G1H16(3),wf4(:,4),G1H4(12),m3h4x4(:,26),heltab2x16(:,:,58))
  call Hloop_A_Q(ntryL,G1H4(12),103,0,G2H4(27),n2h4(61))
  call Hloop_AW_Q(ntryL,G1H16(7),wf4(:,4),G1H4(15),m3h4x4(:,27),heltab2x16(:,:,59))
  call Hloop_A_Q(ntryL,G1H4(15),103,0,G2H4(35),n2h4(62))
  call Hloop_VA_Q(ntryL,G1H8(31),ex6(:),G1H4(3),m3h2x4(:,53),heltab2x8(:,:,82))
  call Hloop_A_Q(ntryL,G1H4(3),103,0,G2H4(34),n2h4(63))
call HGT_OLR(G1H8(33),1,1,8)
call HGT_invQ_OLR(G1H8(33),2,5,8)
  call Hloop_Q_A(ntryL,G1H8(33),-24,0,G2H8(7),n2h8(54))
  call Hloop_QV_A(ntryL,G2H8(7),wf4(:,3),G2H2(98),m3h4x2(:,30),heltab2x8(:,:,83))
  call Hloop_VA_Q(ntryL,G1H8(47),ex6(:),G1H4(4),m3h2x4(:,54),heltab2x8(:,:,84))
  call Hloop_A_Q(ntryL,G1H4(4),103,0,G2H4(8),n2h4(64))
  call Hloop_VA_Q(ntryL,G1H8(48),ex6(:),G1H4(16),m3h2x4(:,55),heltab2x8(:,:,85))
  call Hloop_A_Q(ntryL,G1H4(16),103,0,G2H4(9),n2h4(65))
  call Hloop_VQ_A(ntryL,G1H8(49),ex3(:),G1H4(27),m3h2x4(:,56),heltab2x8(:,:,86))
  call Hloop_Q_A(ntryL,G1H4(27),103,0,G2H4(12),n2h4(66))
call HGT_OLR(G1H8(50),1,1,8)
call HGT_invQ_OLR(G1H8(50),2,5,8)
  call Hloop_A_Q(ntryL,G1H8(50),-24,0,G2H8(12),n2h8(55))
  call Hloop_AV_Q(ntryL,G2H8(12),wf4(:,3),G2H2(99),m3h4x2(:,31),heltab2x8(:,:,87))
  call Hloop_VQ_A(ntryL,G1H8(53),ex3(:),G1H4(28),m3h2x4(:,57),heltab2x8(:,:,88))
  call Hloop_Q_A(ntryL,G1H4(28),103,0,G2H4(13),n2h4(67))
  call Hloop_VQ_A(ntryL,G1H8(54),ex3(:),G1H4(29),m3h2x4(:,58),heltab2x8(:,:,89))
  call Hloop_Q_A(ntryL,G1H4(29),103,0,G2H4(32),n2h4(68))
  call Hloop_UV_W(ntryL,G1H8(55),99,wf4(:,3),24,G2H2(100),m3h4x2(:,32),heltab2x8(:,:,90))
call HGT_OLR(G1H8(56),1,1,8)
call HGT_invQ_OLR(G1H8(56),2,5,8)
  call Hloop_A_Q(ntryL,G1H8(56),-4,0,G2H8(2),n2h8(56))
  call Hloop_AQ_V(ntryL,G2H8(2),ex3(:),G2H4(19),m3h2x4(:,59),heltab2x8(:,:,91))
  call Hloop_UV_W(ntryL,G1H8(59),99,wf4(:,3),24,G2H2(101),m3h4x2(:,33),heltab2x8(:,:,92))
  call Hloop_UV_W(ntryL,G1H8(60),99,wf4(:,3),24,G2H2(102),m3h4x2(:,34),heltab2x8(:,:,93))
  call Hloop_UV_W(ntryL,G1H8(61),71,wf4(:,3),24,G2H2(103),m3h4x2(:,35),heltab2x8(:,:,94))
call HGT_OLR(G1H8(62),1,1,8)
call HGT_invQ_OLR(G1H8(62),2,5,8)
  call Hloop_Q_A(ntryL,G1H8(62),-32,0,G2H8(3),n2h8(57))
  call Hloop_QA_V(ntryL,G2H8(3),ex6(:),G2H4(20),m3h2x4(:,60),heltab2x8(:,:,95))
  call Hloop_UV_W(ntryL,G1H8(65),71,wf4(:,3),24,G2H2(104),m3h4x2(:,36),heltab2x8(:,:,96))
  call Hloop_UV_W(ntryL,G1H8(66),71,wf4(:,3),24,G2H2(105),m3h4x2(:,37),heltab2x8(:,:,97))
  call Hloop_VQ_A(ntryL,G1H16(8),wf8(:,6),G1H2(18),m3h8x2(:,3),heltab2x16(:,:,60))
  call Hloop_Q_A(ntryL,G1H2(18),95,0,G2H2(106),n2h2(66))
call HGT_raise_alpha_OLR(G1H16(10),1,1,16)
call HGT_raise_alpha_invQ_OLR(G1H16(10),2,5,16)
  call Hloop_VA_Q(ntryL,G1H16(10),ex6(:),G1H8(8),m3h2x8(:,31),heltab2x16(:,:,61))
  call Hloop_VQ_A(ntryL,G1H16(11),wf8(:,6),G1H2(23),m3h8x2(:,4),heltab2x16(:,:,62))
  call Hloop_Q_A(ntryL,G1H2(23),95,0,G2H2(107),n2h2(67))
  call Hloop_VQ_A(ntryL,G1H16(15),wf8(:,6),G1H2(30),m3h8x2(:,5),heltab2x16(:,:,63))
  call Hloop_Q_A(ntryL,G1H2(30),95,0,G2H2(108),n2h2(68))
  call Hloop_VQ_A(ntryL,G1H16(18),wf8(:,6),G1H2(6),m3h8x2(:,6),heltab2x16(:,:,64))
  call Hloop_Q_A(ntryL,G1H2(6),95,0,G2H2(109),n2h2(69))
call HGT_raise_alpha_OLR(G1H16(6),1,1,16)
call HGT_raise_alpha_invQ_OLR(G1H16(6),2,5,16)
  call Hloop_VA_Q(ntryL,G1H16(6),ex6(:),G1H8(35),m3h2x8(:,32),heltab2x16(:,:,65))
  call Hloop_VQ_A(ntryL,G1H16(2),wf8(:,6),G1H2(18),m3h8x2(:,7),heltab2x16(:,:,66))
  call Hloop_Q_A(ntryL,G1H2(18),95,0,G2H2(110),n2h2(70))
  call Hloop_VQ_A(ntryL,G1H16(12),wf8(:,6),G1H2(23),m3h8x2(:,8),heltab2x16(:,:,67))
  call Hloop_Q_A(ntryL,G1H2(23),95,0,G2H2(111),n2h2(71))
  call Hloop_VQ_A(ntryL,G1H16(14),ex3(:),G1H8(76),m3h2x8(:,33),heltab2x16(:,:,68))
  call Hloop_Q_A(ntryL,G1H8(76),92,0,G2H8(13),n2h8(58))
call HGT_raise_alpha_OLR(G1H16(23),1,1,16)
call HGT_raise_alpha_invQ_OLR(G1H16(23),2,5,16)
  call Hloop_VA_Q(ntryL,G1H16(23),wf8(:,2),G1H2(30),m3h8x2(:,9),heltab2x16(:,:,69))
  call Hloop_VQ_A(ntryL,G1H16(29),ex3(:),G1H8(77),m3h2x8(:,34),heltab2x16(:,:,70))
  call Hloop_Q_A(ntryL,G1H8(77),92,0,G2H8(10),n2h8(59))
  call Hloop_VQ_A(ntryL,G1H16(30),ex3(:),G1H8(92),m3h2x8(:,35),heltab2x16(:,:,71))
  call Hloop_Q_A(ntryL,G1H8(92),92,0,G2H8(11),n2h8(60))
  call Hloop_VQ_A(ntryL,G1H16(31),ex3(:),G1H8(93),m3h2x8(:,36),heltab2x16(:,:,72))
  call Hloop_Q_A(ntryL,G1H8(93),92,0,G2H8(1),n2h8(61))
call HGT_raise_alpha_OLR(G1H16(32),1,1,16)
call HGT_raise_alpha_invQ_OLR(G1H16(32),2,5,16)
  call Hloop_VA_Q(ntryL,G1H16(32),wf8(:,2),G1H2(6),m3h8x2(:,10),heltab2x16(:,:,73))
  call Hloop_VQ_A(ntryL,G1H16(35),ex3(:),G1H8(21),m3h2x8(:,37),heltab2x16(:,:,74))
  call Hloop_Q_A(ntryL,G1H8(21),92,0,G2H8(8),n2h8(62))
  call Hloop_VQ_A(ntryL,G1H16(36),ex3(:),G1H8(19),m3h2x8(:,38),heltab2x16(:,:,75))
  call Hloop_Q_A(ntryL,G1H8(19),92,0,G2H8(9),n2h8(63))
call HGT_raise_alpha_OLR(G1H8(68),1,1,8)
call HGT_raise_alpha_invQ_OLR(G1H8(68),2,5,8)
  call Hloop_VA_Q(ntryL,G1H8(68),ex6(:),G1H4(30),m3h2x4(:,61),heltab2x8(:,:,98))
  call Hloop_QW_A(ntryL,G1H8(71),wf4(:,4),G1H2(18),m3h4x2(:,38),heltab2x8(:,:,99))
  call Hloop_Q_A(ntryL,G1H2(18),95,0,G2H2(112),n2h2(72))
  call Hloop_QV_A(ntryL,G1H8(72),wf4(:,3),G1H2(23),m3h4x2(:,39),heltab2x8(:,:,100))
  call Hloop_Q_A(ntryL,G1H2(23),95,0,G2H2(113),n2h2(73))
call HGT_raise_alpha_OLR(G1H8(73),1,1,8)
call HGT_raise_alpha_invQ_OLR(G1H8(73),2,5,8)
  call Hloop_VA_Q(ntryL,G1H8(73),ex6(:),G1H4(33),m3h2x4(:,62),heltab2x8(:,:,101))
  call Hloop_QV_A(ntryL,G1H8(78),wf4(:,3),G1H2(18),m3h4x2(:,40),heltab2x8(:,:,102))
  call Hloop_Q_A(ntryL,G1H2(18),95,0,G2H2(114),n2h2(74))
  call Hloop_QV_A(ntryL,G1H8(83),wf4(:,3),G1H2(23),m3h4x2(:,41),heltab2x8(:,:,103))
  call Hloop_Q_A(ntryL,G1H2(23),95,0,G2H2(115),n2h2(75))
call HGT_raise_alpha_OLR(G1H8(79),1,1,8)
call HGT_raise_alpha_invQ_OLR(G1H8(79),2,5,8)
  call Hloop_VA_Q(ntryL,G1H8(79),ex6(:),G1H4(34),m3h2x4(:,63),heltab2x8(:,:,104))
  call Hloop_QV_A(ntryL,G1H8(82),wf4(:,3),G1H2(18),m3h4x2(:,42),heltab2x8(:,:,105))
  call Hloop_Q_A(ntryL,G1H2(18),95,0,G2H2(116),n2h2(76))
call HGT_raise_alpha_OLR(G1H8(84),1,1,8)
call HGT_raise_alpha_invQ_OLR(G1H8(84),2,5,8)
  call Hloop_VA_Q(ntryL,G1H8(84),ex6(:),G1H4(35),m3h2x4(:,64),heltab2x8(:,:,106))
  call Hloop_QV_A(ntryL,G1H8(87),wf4(:,3),G1H2(23),m3h4x2(:,43),heltab2x8(:,:,107))
  call Hloop_Q_A(ntryL,G1H2(23),95,0,G2H2(117),n2h2(77))
  call Hloop_QW_A(ntryL,G1H8(88),wf4(:,4),G1H2(18),m3h4x2(:,44),heltab2x8(:,:,108))
  call Hloop_Q_A(ntryL,G1H2(18),95,0,G2H2(118),n2h2(78))
call HGT_raise_alpha_OLR(G1H8(89),1,1,8)
call HGT_raise_alpha_invQ_OLR(G1H8(89),2,5,8)
  call Hloop_VA_Q(ntryL,G1H8(89),ex6(:),G1H4(36),m3h2x4(:,65),heltab2x8(:,:,109))
  call Hloop_QW_A(ntryL,G1H8(94),wf4(:,4),G1H2(23),m3h4x2(:,45),heltab2x8(:,:,110))
  call Hloop_Q_A(ntryL,G1H2(23),95,0,G2H2(119),n2h2(79))
  call Hloop_QW_A(ntryL,G1H8(99),wf4(:,4),G1H2(18),m3h4x2(:,46),heltab2x8(:,:,111))
  call Hloop_Q_A(ntryL,G1H2(18),95,0,G2H2(120),n2h2(80))
call HGT_raise_alpha_OLR(G1H8(95),1,1,8)
call HGT_raise_alpha_invQ_OLR(G1H8(95),2,5,8)
  call Hloop_VA_Q(ntryL,G1H8(95),ex6(:),G1H4(39),m3h2x4(:,66),heltab2x8(:,:,112))
  call Hloop_QW_A(ntryL,G1H8(98),wf4(:,4),G1H2(23),m3h4x2(:,47),heltab2x8(:,:,113))
  call Hloop_Q_A(ntryL,G1H2(23),95,0,G2H2(121),n2h2(81))
call HGT_raise_alpha_OLR(G1H8(100),1,1,8)
call HGT_raise_alpha_invQ_OLR(G1H8(100),2,5,8)
  call Hloop_VA_Q(ntryL,G1H8(100),ex6(:),G1H4(40),m3h2x4(:,67),heltab2x8(:,:,114))
  call Hloop_QW_A(ntryL,G1H8(103),wf4(:,4),G1H2(18),m3h4x2(:,48),heltab2x8(:,:,115))
  call Hloop_Q_A(ntryL,G1H2(18),95,0,G2H2(122),n2h2(82))
  call ol_merge(ntryL,G2H2(100),[G2H2(8),G2H2(2),G1H2(28),G1H2(10)])
  call ol_merge(ntryL,G2H2(103),[G2H2(10),G2H2(4),G1H2(34),G1H2(16)])
  call ol_merge(ntryL,G2H2(45),[G2H2(6),G1H2(22)])
  call ol_merge(ntryL,G2H2(44),[G2H2(12),G1H2(40)])
call HGT_w2_OLR(G1H2(1),1,1,2)
call HGT_w2_invQ_OLR(G1H2(1),2,5,2)
  call ol_merge(ntryL,G2H2(31),[G1H2(1)])
  call ol_merge(ntryL,G2H2(32),[G1H2(19)])
call HGT_w2_OLR(G1H2(3),1,1,2)
call HGT_w2_invQ_OLR(G1H2(3),2,5,2)
  call ol_merge(ntryL,G2H2(32),[G1H2(3)])
call HGT_w2_OLR(G1H4(6),1,1,4)
call HGT_w2_invQ_OLR(G1H4(6),2,5,4)
  call ol_merge(ntryL,G2H4(2),[G1H4(6)])
  call ol_merge(ntryL,G2H2(109),[G2H2(20)])
  call ol_merge(ntryL,G2H2(111),[G2H2(21)])
call HGT_w2_OLR(G1H4(1),1,1,4)
call HGT_w2_invQ_OLR(G1H4(1),2,5,4)
  call ol_merge(ntryL,G2H4(5),[G1H4(1)])
  call ol_merge(ntryL,G2H2(106),[G2H2(23)])
  call ol_merge(ntryL,G2H2(108),[G2H2(24)])
  call ol_merge(ntryL,G2H2(33),[G1H2(7)])
  call ol_merge(ntryL,G2H2(34),[G1H2(8)])
  call ol_merge(ntryL,G2H2(1),[G1H2(9)])
  call ol_merge(ntryL,G2H2(35),[G1H2(13)])
  call ol_merge(ntryL,G2H2(36),[G1H2(14)])
  call ol_merge(ntryL,G2H2(3),[G1H2(15)])
  call ol_merge(ntryL,G2H2(37),[G1H2(20)])
  call ol_merge(ntryL,G2H2(5),[G1H2(21)])
  call ol_merge(ntryL,G2H2(38),[G1H2(25)])
  call ol_merge(ntryL,G2H2(39),[G1H2(26)])
  call ol_merge(ntryL,G2H2(7),[G1H2(27)])
  call ol_merge(ntryL,G2H2(40),[G1H2(31)])
  call ol_merge(ntryL,G2H2(41),[G1H2(32)])
  call ol_merge(ntryL,G2H2(9),[G1H2(33)])
  call ol_merge(ntryL,G2H2(42),[G1H2(37)])
  call ol_merge(ntryL,G2H2(43),[G1H2(38)])
  call ol_merge(ntryL,G2H2(11),[G1H2(39)])
call Hotf_5pt_reduction(G2H2(100),RedSet_5(36),mass5set(:,1),  & 
G1H2(23),G1H2(18),G1H2(28),G1H2(10),G1H2(34),G1H2(16),2)
call HG1shiftOLR(G1H2(18),4,2)
call Hotf_5pt_reduction(G2H2(103),RedSet_5(37),mass5set(:,1),  & 
G1H2(22),G1H2(40),G1H2(1),G1H2(19),G1H2(3),G1H2(7),2)
call HG1shiftOLR(G1H2(40),32,2)
call Hotf_5pt_reduction(G2H2(45),RedSet_5(38),mass5set(:,4),  & 
G1H2(8),G1H2(9),G1H2(13),G1H2(14),G1H2(15),G1H2(20),2)
call HG1shiftOLR(G1H2(9),16,2)
call Hotf_5pt_reduction(G2H2(44),RedSet_5(39),mass5set(:,4),  & 
G1H2(21),G1H2(25),G1H2(26),G1H2(27),G1H2(31),G1H2(32),2)
call HG1shiftOLR(G1H2(25),16,2)
call Hotf_5pt_reduction(G2H2(31),RedSet_5(40),mass5set(:,6),  & 
G1H2(33),G1H2(37),G1H2(38),G1H2(39),G1H2(41),G1H2(42),2)
call HG1shiftOLR(G1H2(37),8,2)
  call Hcheck_last_QA_V(ntryL,l_switch,G2H2(14),ex5(:),G2tensor(1),m3h2x1(:,17),heltab2x2(:,:,17))
call HGT_w2_OLR(G1H2(2),1,1,2)
call HGT_w2_invQ_OLR(G1H2(2),2,5,2)
  call Hloop_VQ_A(ntryL,G1H2(2),ex4(:),G1H1(1),m3h2x1(:,18),heltab2x2(:,:,18))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),127,nMT,G2tensor(2),n2h1(13))
  call Hcheck_last_QA_V(ntryL,l_switch,G2H2(15),ex5(:),G2tensor(3),m3h2x1(:,19),heltab2x2(:,:,19))
call Hotf_5pt_reduction(G2H2(32),RedSet_5(41),mass5set(:,6),  & 
G1H2(2),G1H2(43),G1H2(44),G1H2(45),G1H2(46),G1H2(47),2)
call HG1shiftOLR(G1H2(43),16,2)
  call Hcheck_last_AQ_V(ntryL,l_switch,G2H2(17),ex4(:),G2tensor(4),m3h2x1(:,20),heltab2x2(:,:,20))
call HGT_w2_OLR(G1H2(4),1,1,2)
call HGT_w2_invQ_OLR(G1H2(4),2,5,2)
  call Hloop_VA_Q(ntryL,G1H2(4),ex5(:),G1H1(1),m3h2x1(:,21),heltab2x2(:,:,21))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),127,nMT,G2tensor(5),n2h1(14))
  call Hcheck_last_AQ_V(ntryL,l_switch,G2H2(18),ex4(:),G2tensor(7),m3h2x1(:,22),heltab2x2(:,:,22))
call Hotf_5pt_reduction(G2H4(2),RedSet_5(42),mass5set(:,3),  & 
G1H4(41),G1H4(42),G1H4(45),G1H4(46),G1H4(47),G1H4(48),4)
call HG1shiftOLR(G1H4(42),3,4)
  call Hcheck_last_QA_V(ntryL,l_switch,G2H2(109),ex6(:),G2tensor(9),m3h2x1(:,23),heltab2x2(:,:,23))
call HGT_w2_OLR(G1H4(18),1,1,4)
call HGT_w2_invQ_OLR(G1H4(18),2,5,4)
  call Hloop_QW_A(ntryL,G1H4(18),wf4(:,4),G1H1(1),m3h4x1(:,1),heltab2x4(:,:,89))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),127,0,G2tensor(11),n2h1(15))
  call Hcheck_last_QA_V(ntryL,l_switch,G2H2(111),ex6(:),G2tensor(13),m3h2x1(:,24),heltab2x2(:,:,24))
call Hotf_5pt_reduction(G2H4(5),RedSet_5(43),mass5set(:,3),  & 
G1H4(51),G1H4(52),G1H4(9),G1H4(10),G1H4(54),G1H4(55),4)
call HG1shiftOLR(G1H4(52),3,4)
  call Hcheck_last_QA_V(ntryL,l_switch,G2H2(106),ex6(:),G2tensor(15),m3h2x1(:,25),heltab2x2(:,:,25))
call HGT_w2_OLR(G1H4(2),1,1,4)
call HGT_w2_invQ_OLR(G1H4(2),2,5,4)
  call Hloop_QW_A(ntryL,G1H4(2),wf4(:,4),G1H1(1),m3h4x1(:,2),heltab2x4(:,:,90))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),127,0,G2tensor(17),n2h1(16))
  call Hcheck_last_QA_V(ntryL,l_switch,G2H2(108),ex6(:),G2tensor(18),m3h2x1(:,26),heltab2x2(:,:,26))
call Hotf_5pt_reduction(G2H2(33),RedSet_5(44),mass5set(:,7),  & 
G1H2(4),G1H2(48),G1H2(49),G1H2(50),G1H2(51),G1H2(52),2)
call HG1shiftOLR(G1H2(48),4,2)
call Hotf_5pt_reduction(G2H2(34),RedSet_5(45),mass5set(:,7),  & 
G1H2(53),G1H2(54),G1H2(55),G1H2(56),G1H2(57),G1H2(58),2)
call HG1shiftOLR(G1H2(54),4,2)
call Hotf_5pt_reduction(G2H2(1),RedSet_5(46),mass5set(:,7),  & 
G1H2(59),G1H2(60),G1H2(61),G1H2(62),G1H2(63),G1H2(64),2)
call HG1shiftOLR(G1H2(60),4,2)
call Hotf_5pt_reduction(G2H2(35),RedSet_5(47),mass5set(:,7),  & 
G1H2(65),G1H2(66),G1H2(67),G1H2(68),G1H2(69),G1H2(70),2)
call HG1shiftOLR(G1H2(66),32,2)
call Hotf_5pt_reduction(G2H2(36),RedSet_5(48),mass5set(:,7),  & 
G1H2(71),G1H2(72),G1H2(73),G1H2(74),G1H2(75),G1H2(76),2)
call HG1shiftOLR(G1H2(72),32,2)
call Hotf_5pt_reduction(G2H2(3),RedSet_5(49),mass5set(:,7),  & 
G1H2(77),G1H2(78),G1H2(79),G1H2(80),G1H2(81),G1H2(82),2)
call HG1shiftOLR(G1H2(78),32,2)
call Hotf_5pt_reduction(G2H2(37),RedSet_5(50),mass5set(:,4),  & 
G1H2(83),G1H2(84),G1H2(85),G1H2(86),G1H2(87),G1H2(88),2)
call HG1shiftOLR(G1H2(84),16,2)
call Hotf_5pt_reduction(G2H2(5),RedSet_5(51),mass5set(:,4),  & 
G1H2(89),G1H2(90),G1H2(91),G1H2(92),G1H2(93),G1H2(94),2)
call HG1shiftOLR(G1H2(90),16,2)
call Hotf_5pt_reduction(G2H2(38),RedSet_5(52),mass5set(:,7),  & 
G1H2(95),G1H2(96),G1H2(97),G1H2(98),G1H2(99),G1H2(100),2)
call HG1shiftOLR(G1H2(96),4,2)
call Hotf_5pt_reduction(G2H2(39),RedSet_5(53),mass5set(:,7),  & 
G1H2(101),G1H2(102),G1H2(103),G1H2(104),G1H2(105),G1H2(106),2)
call HG1shiftOLR(G1H2(102),4,2)
call Hotf_5pt_reduction(G2H2(7),RedSet_5(54),mass5set(:,7),  & 
G1H2(107),G1H2(108),G1H2(109),G1H2(110),G1H2(111),G1H2(112),2)
call HG1shiftOLR(G1H2(108),4,2)
call Hotf_5pt_reduction(G2H2(40),RedSet_5(55),mass5set(:,7),  & 
G1H2(113),G1H2(114),G1H2(115),G1H2(116),G1H2(117),G1H2(118),2)
call HG1shiftOLR(G1H2(114),32,2)
call Hotf_5pt_reduction(G2H2(41),RedSet_5(56),mass5set(:,7),  & 
G1H2(119),G1H2(120),G1H2(121),G1H2(122),G1H2(123),G1H2(124),2)
call HG1shiftOLR(G1H2(120),32,2)
call Hotf_5pt_reduction(G2H2(9),RedSet_5(57),mass5set(:,7),  & 
G1H2(125),G1H2(126),G1H2(127),G1H2(128),G1H2(129),G1H2(130),2)
call HG1shiftOLR(G1H2(126),32,2)
call Hotf_5pt_reduction(G2H2(42),RedSet_5(58),mass5set(:,6),  & 
G1H2(131),G1H2(132),G1H2(133),G1H2(134),G1H2(135),G1H2(136),2)
call HG1shiftOLR(G1H2(132),16,2)
call Hotf_5pt_reduction(G2H2(43),RedSet_5(59),mass5set(:,4),  & 
G1H2(137),G1H2(138),G1H2(139),G1H2(140),G1H2(141),G1H2(142),2)
call HG1shiftOLR(G1H2(138),16,2)
call Hotf_5pt_reduction(G2H2(11),RedSet_5(60),mass5set(:,4),  & 
G1H2(143),G1H2(144),G1H2(145),G1H2(146),G1H2(147),G1H2(148),2)
call HG1shiftOLR(G1H2(144),16,2)
call Hotf_5pt_reduction(G2H8(6),RedSet_5(61),mass5set(:,7),  & 
G1H8(17),G1H8(28),G1H8(1),G1H8(5),G1H8(10),G1H8(22),8)
call HG1shiftOLR(G1H8(28),35,8)
call Hotf_5pt_reduction(G2H8(4),RedSet_5(62),mass5set(:,7),  & 
G1H8(3),G1H8(4),G1H8(12),G1H8(15),G1H8(16),G1H8(14),8)
call HG1shiftOLR(G1H8(4),35,8)
call Hotf_5pt_reduction(G2H2(46),RedSet_5(15),mass5set(:,1),  & 
G1H2(149),G1H2(150),G1H2(151),G1H2(152),G1H2(153),G1H2(154),2)
call HG1shiftOLR(G1H2(150),4,2)
call Hotf_4pt_reduction(G2H2(48),RedSet_4(128),mass4set(:,1),  & 
G1H2(155),G1H2(156),G1H2(157),G1H2(158),G1H2(159),2)
call HG1shiftOLR(G1H2(156),36,2)
call Hotf_5pt_reduction(G2H2(49),RedSet_5(16),mass5set(:,1),  & 
G1H2(160),G1H2(161),G1H2(162),G1H2(163),G1H2(164),G1H2(165),2)
call HG1shiftOLR(G1H2(161),32,2)
call Hotf_4pt_reduction(G2H2(51),RedSet_4(129),mass4set(:,1),  & 
G1H2(166),G1H2(167),G1H2(168),G1H2(169),G1H2(170),2)
call HG1shiftOLR(G1H2(167),36,2)
call Hotf_5pt_reduction(G2H2(52),RedSet_5(17),mass5set(:,1),  & 
G1H2(171),G1H2(172),G1H2(173),G1H2(174),G1H2(175),G1H2(176),2)
call HG1shiftOLR(G1H2(172),32,2)
call Hotf_4pt_reduction(G2H2(54),RedSet_4(128),mass4set(:,1),  & 
G1H2(177),G1H2(178),G1H2(179),G1H2(180),G1H2(181),2)
call HG1shiftOLR(G1H2(178),36,2)
call Hotf_5pt_reduction(G2H4(29),RedSet_5(1),mass5set(:,1),  & 
G1H4(8),G1H4(12),G1H4(15),G1H4(3),G1H4(4),G1H4(16),4)
call HG1shiftOLR(G1H4(12),24,4)
call Hotf_4pt_reduction(G2H4(16),RedSet_4(13),mass4set(:,1),  & 
G1H4(27),G1H4(28),G1H4(29),G1H4(6),G1H4(1),4)
call HG1shiftOLR(G1H4(28),56,4)
  call Hcheck_last_QA_V(ntryL,l_switch,G2H2(55),ex5(:),G2tensor(19),m3h2x1(:,27),heltab2x2(:,:,27))
  call Hcheck_last_QA_V(ntryL,l_switch,G2H2(57),ex5(:),G2tensor(20),m3h2x1(:,28),heltab2x2(:,:,28))
  call Hcheck_last_AQ_V(ntryL,l_switch,G2H2(58),ex4(:),G2tensor(21),m3h2x1(:,29),heltab2x2(:,:,29))
  call Hcheck_last_AQ_V(ntryL,l_switch,G2H2(60),ex4(:),G2tensor(22),m3h2x1(:,30),heltab2x2(:,:,30))
  call Hcheck_last_AQ_V(ntryL,l_switch,G2H2(61),ex4(:),G2tensor(23),m3h2x1(:,31),heltab2x2(:,:,31))
  call Hcheck_last_AQ_V(ntryL,l_switch,G2H2(63),ex4(:),G2tensor(24),m3h2x1(:,32),heltab2x2(:,:,32))
  call Hcheck_last_QA_V(ntryL,l_switch,G2H2(64),ex5(:),G2tensor(25),m3h2x1(:,33),heltab2x2(:,:,33))
  call Hcheck_last_QA_V(ntryL,l_switch,G2H2(66),ex5(:),G2tensor(26),m3h2x1(:,34),heltab2x2(:,:,34))
  call Hcheck_last_QA_V(ntryL,l_switch,G2H2(67),ex6(:),G2tensor(27),m3h2x1(:,35),heltab2x2(:,:,35))
  call Hcheck_last_QA_V(ntryL,l_switch,G2H2(69),ex6(:),G2tensor(28),m3h2x1(:,36),heltab2x2(:,:,36))
  call Hcheck_last_QA_V(ntryL,l_switch,G2H2(70),ex6(:),G2tensor(29),m3h2x1(:,37),heltab2x2(:,:,37))
  call Hcheck_last_QA_V(ntryL,l_switch,G2H2(72),ex6(:),G2tensor(30),m3h2x1(:,38),heltab2x2(:,:,38))
  call Hcheck_last_QA_V(ntryL,l_switch,G2H2(73),ex5(:),G2tensor(31),m3h2x1(:,39),heltab2x2(:,:,39))
  call Hcheck_last_QA_V(ntryL,l_switch,G2H2(75),ex5(:),G2tensor(32),m3h2x1(:,40),heltab2x2(:,:,40))
  call Hcheck_last_AQ_V(ntryL,l_switch,G2H2(76),ex4(:),G2tensor(33),m3h2x1(:,41),heltab2x2(:,:,41))
  call Hcheck_last_AQ_V(ntryL,l_switch,G2H2(78),ex4(:),G2tensor(34),m3h2x1(:,42),heltab2x2(:,:,42))
  call Hcheck_last_QA_V(ntryL,l_switch,G2H2(79),ex6(:),G2tensor(35),m3h2x1(:,43),heltab2x2(:,:,43))
  call Hcheck_last_QA_V(ntryL,l_switch,G2H2(81),ex6(:),G2tensor(36),m3h2x1(:,44),heltab2x2(:,:,44))
  call Hcheck_last_AQ_V(ntryL,l_switch,G2H2(82),ex3(:),G2tensor(37),m3h2x1(:,45),heltab2x2(:,:,45))
  call Hcheck_last_AQ_V(ntryL,l_switch,G2H2(84),ex3(:),G2tensor(38),m3h2x1(:,46),heltab2x2(:,:,46))
  call Hcheck_last_QA_V(ntryL,l_switch,G2H2(85),ex5(:),G2tensor(39),m3h2x1(:,47),heltab2x2(:,:,47))
  call Hcheck_last_QA_V(ntryL,l_switch,G2H2(87),ex5(:),G2tensor(40),m3h2x1(:,48),heltab2x2(:,:,48))
  call Hcheck_last_AQ_V(ntryL,l_switch,G2H2(88),ex4(:),G2tensor(41),m3h2x1(:,49),heltab2x2(:,:,49))
  call Hcheck_last_AQ_V(ntryL,l_switch,G2H2(90),ex4(:),G2tensor(42),m3h2x1(:,50),heltab2x2(:,:,50))
  call Hcheck_last_QA_V(ntryL,l_switch,G2H2(91),ex6(:),G2tensor(43),m3h2x1(:,51),heltab2x2(:,:,51))
  call Hcheck_last_QA_V(ntryL,l_switch,G2H2(93),ex6(:),G2tensor(44),m3h2x1(:,52),heltab2x2(:,:,52))
  call Hcheck_last_QA_V(ntryL,l_switch,G2H2(95),ex6(:),G2tensor(45),m3h2x1(:,53),heltab2x2(:,:,53))
  call Hcheck_last_QA_V(ntryL,l_switch,G2H2(97),ex6(:),G2tensor(46),m3h2x1(:,54),heltab2x2(:,:,54))
call Hotf_5pt_reduction(G2H4(28),RedSet_5(33),mass5set(:,1),  & 
G1H4(18),G1H4(2),G1H4(56),G1H4(57),G1H4(58),G1H4(59),4)
call HG1shiftOLR(G1H4(2),24,4)
call Hotf_4pt_reduction(G2H4(35),RedSet_4(130),mass4set(:,1),  & 
G1H4(60),G1H4(61),G1H4(62),G1H4(63),G1H4(64),4)
call HG1shiftOLR(G1H4(61),27,4)
call Hotf_5pt_reduction(G2H4(34),RedSet_5(34),mass5set(:,1),  & 
G1H4(65),G1H4(66),G1H4(67),G1H4(68),G1H4(69),G1H4(70),4)
call HG1shiftOLR(G1H4(66),24,4)
call Hotf_4pt_reduction(G2H4(9),RedSet_4(77),mass4set(:,1),  & 
G1H4(71),G1H4(72),G1H4(73),G1H4(74),G1H4(75),4)
call HG1shiftOLR(G1H4(72),56,4)
call Hotf_5pt_reduction(G2H4(12),RedSet_5(35),mass5set(:,1),  & 
G1H4(76),G1H4(77),G1H4(78),G1H4(79),G1H4(80),G1H4(81),4)
call HG1shiftOLR(G1H4(77),24,4)
call Hotf_4pt_reduction(G2H4(32),RedSet_4(63),mass4set(:,1),  & 
G1H4(82),G1H4(83),G1H4(84),G1H4(85),G1H4(86),4)
call HG1shiftOLR(G1H4(83),28,4)
call Hotf_4pt_reduction(G2H2(102),RedSet_4(63),mass4set(:,1),  & 
G1H2(182),G1H2(183),G1H2(184),G1H2(185),G1H2(186),2)
call HG1shiftOLR(G1H2(183),28,2)
call Hotf_4pt_reduction(G2H2(105),RedSet_4(77),mass4set(:,1),  & 
G1H2(187),G1H2(188),G1H2(189),G1H2(190),G1H2(191),2)
call HG1shiftOLR(G1H2(188),56,2)
  call Hcheck_last_QA_V(ntryL,l_switch,G2H8(13),wf8(:,2),G2tensor(47),m3h8x1(:,1),heltab2x8(:,:,116))
  call Hcheck_last_QA_V(ntryL,l_switch,G2H8(11),wf8(:,2),G2tensor(48),m3h8x1(:,2),heltab2x8(:,:,117))
  call Hcheck_last_QA_V(ntryL,l_switch,G2H8(1),wf8(:,2),G2tensor(49),m3h8x1(:,3),heltab2x8(:,:,118))
  call Hcheck_last_QA_V(ntryL,l_switch,G2H8(9),wf8(:,2),G2tensor(50),m3h8x1(:,4),heltab2x8(:,:,119))
  call Hcheck_last_QA_V(ntryL,l_switch,G2H2(113),ex6(:),G2tensor(51),m3h2x1(:,55),heltab2x2(:,:,55))
  call Hcheck_last_QA_V(ntryL,l_switch,G2H2(115),ex6(:),G2tensor(52),m3h2x1(:,56),heltab2x2(:,:,56))
  call Hcheck_last_QA_V(ntryL,l_switch,G2H2(118),ex6(:),G2tensor(53),m3h2x1(:,57),heltab2x2(:,:,57))
  call Hcheck_last_QA_V(ntryL,l_switch,G2H2(120),ex6(:),G2tensor(54),m3h2x1(:,58),heltab2x2(:,:,58))
  call ol_merge(ntryL,G1H2(182),[G1H2(16)])
  call ol_merge(ntryL,G1H2(187),[G1H2(7)])
  call ol_merge(ntryL,G1H2(155),[G1H2(154)])
  call ol_merge(ntryL,G1H2(166),[G1H2(165)])
  call ol_merge(ntryL,G1H2(177),[G1H2(176)])
  call ol_merge(ntryL,G1H4(27),[G1H4(16)])
  call ol_merge(ntryL,G1H4(60),[G1H4(59)])
  call ol_merge(ntryL,G1H4(71),[G1H4(70)])
  call ol_merge(ntryL,G1H4(82),[G1H4(81)])
  call Hloop_VQ_A(ntryL,G1H2(23),ex3(:),G1H1(1),m3h2x1(:,59),heltab2x2(:,:,59))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),127,0,G2tensor(55),n2h1(17))
  call Hloop_VQ_A(ntryL,G1H2(18),ex3(:),G1H1(1),m3h2x1(:,60),heltab2x2(:,:,60))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),4,0,G2tensor(56),n2h1(18))
  call Hloop_VQ_A(ntryL,G1H2(182),ex3(:),G1H1(1),m3h2x1(:,61),heltab2x2(:,:,61))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),127,0,G2tensor(57),n2h1(19))
  call Hloop_VA_Q(ntryL,G1H2(22),ex6(:),G1H1(1),m3h2x1(:,62),heltab2x2(:,:,62))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),127,0,G2tensor(58),n2h1(20))
  call Hloop_VA_Q(ntryL,G1H2(40),ex6(:),G1H1(1),m3h2x1(:,63),heltab2x2(:,:,63))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),32,0,G2tensor(59),n2h1(21))
  call Hloop_VA_Q(ntryL,G1H2(187),ex6(:),G1H1(1),m3h2x1(:,64),heltab2x2(:,:,64))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),127,0,G2tensor(60),n2h1(22))
  call Hloop_VA_Q(ntryL,G1H2(8),ex5(:),G1H1(1),m3h2x1(:,65),heltab2x2(:,:,65))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),127,nMT,G2tensor(61),n2h1(23))
  call Hloop_VA_Q(ntryL,G1H2(9),ex5(:),G1H1(1),m3h2x1(:,66),heltab2x2(:,:,66))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),16,nMT,G2tensor(62),n2h1(24))
  call Hloop_VA_Q(ntryL,G1H2(20),ex5(:),G1H1(1),m3h2x1(:,67),heltab2x2(:,:,67))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),127,nMT,G2tensor(63),n2h1(25))
  call Hloop_VA_Q(ntryL,G1H2(21),ex5(:),G1H1(1),m3h2x1(:,68),heltab2x2(:,:,68))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),127,nMT,G2tensor(64),n2h1(26))
  call Hloop_VA_Q(ntryL,G1H2(25),ex5(:),G1H1(1),m3h2x1(:,69),heltab2x2(:,:,69))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),16,nMT,G2tensor(65),n2h1(27))
  call Hloop_VA_Q(ntryL,G1H2(32),ex5(:),G1H1(1),m3h2x1(:,70),heltab2x2(:,:,70))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),127,nMT,G2tensor(66),n2h1(28))
  call Hloop_VQ_A(ntryL,G1H2(33),ex4(:),G1H1(1),m3h2x1(:,71),heltab2x2(:,:,71))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),127,nMT,G2tensor(67),n2h1(29))
  call Hloop_VQ_A(ntryL,G1H2(37),ex4(:),G1H1(1),m3h2x1(:,72),heltab2x2(:,:,72))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),8,nMT,G2tensor(68),n2h1(30))
  call Hloop_VQ_A(ntryL,G1H2(42),ex4(:),G1H1(1),m3h2x1(:,73),heltab2x2(:,:,73))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),127,nMT,G2tensor(69),n2h1(31))
  call Hloop_VA_Q(ntryL,G1H2(2),ex5(:),G1H1(1),m3h2x1(:,74),heltab2x2(:,:,74))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),127,nMT,G2tensor(70),n2h1(32))
  call Hloop_VA_Q(ntryL,G1H2(43),ex5(:),G1H1(1),m3h2x1(:,75),heltab2x2(:,:,75))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),16,nMT,G2tensor(71),n2h1(33))
  call Hloop_VA_Q(ntryL,G1H2(47),ex5(:),G1H1(1),m3h2x1(:,76),heltab2x2(:,:,76))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),127,nMT,G2tensor(72),n2h1(34))
  call Hloop_QW_A(ntryL,G1H4(41),wf4(:,4),G1H1(1),m3h4x1(:,3),heltab2x4(:,:,91))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),127,0,G2tensor(73),n2h1(35))
  call Hloop_QW_A(ntryL,G1H4(42),wf4(:,4),G1H1(1),m3h4x1(:,4),heltab2x4(:,:,92))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),3,0,G2tensor(74),n2h1(36))
  call Hloop_QW_A(ntryL,G1H4(48),wf4(:,4),G1H1(1),m3h4x1(:,5),heltab2x4(:,:,93))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),127,0,G2tensor(75),n2h1(37))
  call Hloop_QW_A(ntryL,G1H4(51),wf4(:,4),G1H1(1),m3h4x1(:,6),heltab2x4(:,:,94))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),127,0,G2tensor(76),n2h1(38))
  call Hloop_QW_A(ntryL,G1H4(52),wf4(:,4),G1H1(1),m3h4x1(:,7),heltab2x4(:,:,95))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),3,0,G2tensor(77),n2h1(39))
  call Hloop_QW_A(ntryL,G1H4(55),wf4(:,4),G1H1(1),m3h4x1(:,8),heltab2x4(:,:,96))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),127,0,G2tensor(78),n2h1(40))
  call Hloop_VQ_A(ntryL,G1H2(4),ex3(:),G1H1(1),m3h2x1(:,77),heltab2x2(:,:,77))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),127,0,G2tensor(79),n2h1(41))
  call Hloop_VQ_A(ntryL,G1H2(48),ex3(:),G1H1(1),m3h2x1(:,78),heltab2x2(:,:,78))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),4,0,G2tensor(80),n2h1(42))
  call Hloop_VQ_A(ntryL,G1H2(52),ex3(:),G1H1(1),m3h2x1(:,79),heltab2x2(:,:,79))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),127,0,G2tensor(81),n2h1(43))
  call Hloop_VQ_A(ntryL,G1H2(53),ex3(:),G1H1(1),m3h2x1(:,80),heltab2x2(:,:,80))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),127,0,G2tensor(82),n2h1(44))
  call Hloop_VQ_A(ntryL,G1H2(54),ex3(:),G1H1(1),m3h2x1(:,81),heltab2x2(:,:,81))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),4,0,G2tensor(83),n2h1(45))
  call Hloop_VQ_A(ntryL,G1H2(58),ex3(:),G1H1(1),m3h2x1(:,82),heltab2x2(:,:,82))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),127,0,G2tensor(84),n2h1(46))
  call Hloop_VQ_A(ntryL,G1H2(59),ex3(:),G1H1(1),m3h2x1(:,83),heltab2x2(:,:,83))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),127,0,G2tensor(85),n2h1(47))
  call Hloop_VQ_A(ntryL,G1H2(60),ex3(:),G1H1(1),m3h2x1(:,84),heltab2x2(:,:,84))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),4,0,G2tensor(86),n2h1(48))
  call Hloop_VQ_A(ntryL,G1H2(64),ex3(:),G1H1(1),m3h2x1(:,85),heltab2x2(:,:,85))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),127,0,G2tensor(87),n2h1(49))
  call Hloop_VA_Q(ntryL,G1H2(65),ex6(:),G1H1(1),m3h2x1(:,86),heltab2x2(:,:,86))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),127,0,G2tensor(88),n2h1(50))
  call Hloop_VA_Q(ntryL,G1H2(66),ex6(:),G1H1(1),m3h2x1(:,87),heltab2x2(:,:,87))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),32,0,G2tensor(89),n2h1(51))
  call Hloop_VA_Q(ntryL,G1H2(70),ex6(:),G1H1(1),m3h2x1(:,88),heltab2x2(:,:,88))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),127,0,G2tensor(90),n2h1(52))
  call Hloop_VA_Q(ntryL,G1H2(71),ex6(:),G1H1(1),m3h2x1(:,89),heltab2x2(:,:,89))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),127,0,G2tensor(91),n2h1(53))
  call Hloop_VA_Q(ntryL,G1H2(72),ex6(:),G1H1(1),m3h2x1(:,90),heltab2x2(:,:,90))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),32,0,G2tensor(92),n2h1(54))
  call Hloop_VA_Q(ntryL,G1H2(76),ex6(:),G1H1(1),m3h2x1(:,91),heltab2x2(:,:,91))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),127,0,G2tensor(93),n2h1(55))
  call Hloop_VA_Q(ntryL,G1H2(77),ex6(:),G1H1(1),m3h2x1(:,92),heltab2x2(:,:,92))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),127,0,G2tensor(94),n2h1(56))
  call Hloop_VA_Q(ntryL,G1H2(78),ex6(:),G1H1(1),m3h2x1(:,93),heltab2x2(:,:,93))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),32,0,G2tensor(95),n2h1(57))
  call Hloop_VA_Q(ntryL,G1H2(82),ex6(:),G1H1(1),m3h2x1(:,94),heltab2x2(:,:,94))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),127,0,G2tensor(96),n2h1(58))
  call Hloop_VA_Q(ntryL,G1H2(83),ex5(:),G1H1(1),m3h2x1(:,95),heltab2x2(:,:,95))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),127,nMT,G2tensor(97),n2h1(59))
  call Hloop_VA_Q(ntryL,G1H2(84),ex5(:),G1H1(1),m3h2x1(:,96),heltab2x2(:,:,96))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),16,nMT,G2tensor(98),n2h1(60))
  call Hloop_VA_Q(ntryL,G1H2(88),ex5(:),G1H1(1),m3h2x1(:,97),heltab2x2(:,:,97))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),127,nMT,G2tensor(99),n2h1(61))
  call Hloop_VA_Q(ntryL,G1H2(89),ex5(:),G1H1(1),m3h2x1(:,98),heltab2x2(:,:,98))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),127,nMT,G2tensor(100),n2h1(62))
  call Hloop_VA_Q(ntryL,G1H2(90),ex5(:),G1H1(1),m3h2x1(:,99),heltab2x2(:,:,99))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),16,nMT,G2tensor(101),n2h1(63))
  call Hloop_VA_Q(ntryL,G1H2(94),ex5(:),G1H1(1),m3h2x1(:,100),heltab2x2(:,:,100))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),127,nMT,G2tensor(102),n2h1(64))
  call Hloop_VQ_A(ntryL,G1H2(95),ex3(:),G1H1(1),m3h2x1(:,101),heltab2x2(:,:,101))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),127,0,G2tensor(103),n2h1(65))
  call Hloop_VQ_A(ntryL,G1H2(96),ex3(:),G1H1(1),m3h2x1(:,102),heltab2x2(:,:,102))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),4,0,G2tensor(104),n2h1(66))
  call Hloop_VQ_A(ntryL,G1H2(100),ex3(:),G1H1(1),m3h2x1(:,103),heltab2x2(:,:,103))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),127,0,G2tensor(105),n2h1(67))
  call Hloop_VQ_A(ntryL,G1H2(101),ex3(:),G1H1(1),m3h2x1(:,104),heltab2x2(:,:,104))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),127,0,G2tensor(106),n2h1(68))
  call Hloop_VQ_A(ntryL,G1H2(102),ex3(:),G1H1(1),m3h2x1(:,105),heltab2x2(:,:,105))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),4,0,G2tensor(107),n2h1(69))
  call Hloop_VQ_A(ntryL,G1H2(106),ex3(:),G1H1(1),m3h2x1(:,106),heltab2x2(:,:,106))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),127,0,G2tensor(108),n2h1(70))
  call Hloop_VQ_A(ntryL,G1H2(107),ex3(:),G1H1(1),m3h2x1(:,107),heltab2x2(:,:,107))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),127,0,G2tensor(109),n2h1(71))
  call Hloop_VQ_A(ntryL,G1H2(108),ex3(:),G1H1(1),m3h2x1(:,108),heltab2x2(:,:,108))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),4,0,G2tensor(110),n2h1(72))
  call Hloop_VQ_A(ntryL,G1H2(112),ex3(:),G1H1(1),m3h2x1(:,109),heltab2x2(:,:,109))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),127,0,G2tensor(111),n2h1(73))
  call Hloop_VA_Q(ntryL,G1H2(113),ex6(:),G1H1(1),m3h2x1(:,110),heltab2x2(:,:,110))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),127,0,G2tensor(112),n2h1(74))
  call Hloop_VA_Q(ntryL,G1H2(114),ex6(:),G1H1(1),m3h2x1(:,111),heltab2x2(:,:,111))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),32,0,G2tensor(113),n2h1(75))
  call Hloop_VA_Q(ntryL,G1H2(118),ex6(:),G1H1(1),m3h2x1(:,112),heltab2x2(:,:,112))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),127,0,G2tensor(114),n2h1(76))
  call Hloop_VA_Q(ntryL,G1H2(119),ex6(:),G1H1(1),m3h2x1(:,113),heltab2x2(:,:,113))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),127,0,G2tensor(115),n2h1(77))
  call Hloop_VA_Q(ntryL,G1H2(120),ex6(:),G1H1(1),m3h2x1(:,114),heltab2x2(:,:,114))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),32,0,G2tensor(116),n2h1(78))
  call Hloop_VA_Q(ntryL,G1H2(124),ex6(:),G1H1(1),m3h2x1(:,115),heltab2x2(:,:,115))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),127,0,G2tensor(117),n2h1(79))
  call Hloop_VA_Q(ntryL,G1H2(125),ex6(:),G1H1(1),m3h2x1(:,116),heltab2x2(:,:,116))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),127,0,G2tensor(118),n2h1(80))
  call Hloop_VA_Q(ntryL,G1H2(126),ex6(:),G1H1(1),m3h2x1(:,117),heltab2x2(:,:,117))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),32,0,G2tensor(119),n2h1(81))
  call Hloop_VA_Q(ntryL,G1H2(130),ex6(:),G1H1(1),m3h2x1(:,118),heltab2x2(:,:,118))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),127,0,G2tensor(120),n2h1(82))
  call Hloop_VA_Q(ntryL,G1H2(131),ex5(:),G1H1(1),m3h2x1(:,119),heltab2x2(:,:,119))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),127,nMT,G2tensor(121),n2h1(83))
  call Hloop_VA_Q(ntryL,G1H2(132),ex5(:),G1H1(1),m3h2x1(:,120),heltab2x2(:,:,120))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),16,nMT,G2tensor(122),n2h1(84))
  call Hloop_VA_Q(ntryL,G1H2(136),ex5(:),G1H1(1),m3h2x1(:,121),heltab2x2(:,:,121))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),127,nMT,G2tensor(123),n2h1(85))
  call Hloop_VA_Q(ntryL,G1H2(137),ex5(:),G1H1(1),m3h2x1(:,122),heltab2x2(:,:,122))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),127,nMT,G2tensor(124),n2h1(86))
  call Hloop_VA_Q(ntryL,G1H2(138),ex5(:),G1H1(1),m3h2x1(:,123),heltab2x2(:,:,123))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),16,nMT,G2tensor(125),n2h1(87))
  call Hloop_VA_Q(ntryL,G1H2(142),ex5(:),G1H1(1),m3h2x1(:,124),heltab2x2(:,:,124))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),127,nMT,G2tensor(126),n2h1(88))
  call Hloop_VA_Q(ntryL,G1H2(143),ex5(:),G1H1(1),m3h2x1(:,125),heltab2x2(:,:,125))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),127,nMT,G2tensor(127),n2h1(89))
  call Hloop_VA_Q(ntryL,G1H2(144),ex5(:),G1H1(1),m3h2x1(:,126),heltab2x2(:,:,126))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),16,nMT,G2tensor(128),n2h1(90))
  call Hloop_VA_Q(ntryL,G1H2(148),ex5(:),G1H1(1),m3h2x1(:,127),heltab2x2(:,:,127))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),127,nMT,G2tensor(129),n2h1(91))
  call Hloop_VA_Q(ntryL,G1H8(17),wf8(:,2),G1H1(1),m3h8x1(:,5),heltab2x8(:,:,120))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),127,0,G2tensor(130),n2h1(92))
  call Hloop_VA_Q(ntryL,G1H8(28),wf8(:,2),G1H1(1),m3h8x1(:,6),heltab2x8(:,:,121))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),35,0,G2tensor(131),n2h1(93))
  call Hloop_VA_Q(ntryL,G1H8(22),wf8(:,2),G1H1(1),m3h8x1(:,7),heltab2x8(:,:,122))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),127,0,G2tensor(132),n2h1(94))
  call Hloop_VA_Q(ntryL,G1H8(3),wf8(:,2),G1H1(1),m3h8x1(:,8),heltab2x8(:,:,123))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),127,0,G2tensor(133),n2h1(95))
  call Hloop_VA_Q(ntryL,G1H8(4),wf8(:,2),G1H1(1),m3h8x1(:,9),heltab2x8(:,:,124))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),35,0,G2tensor(134),n2h1(96))
  call Hloop_VA_Q(ntryL,G1H8(14),wf8(:,2),G1H1(1),m3h8x1(:,10),heltab2x8(:,:,125))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),127,0,G2tensor(135),n2h1(97))
  call Hloop_VQ_A(ntryL,G1H2(149),ex3(:),G1H1(1),m3h2x1(:,128),heltab2x2(:,:,128))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),127,0,G2tensor(136),n2h1(98))
  call Hloop_VQ_A(ntryL,G1H2(150),ex3(:),G1H1(1),m3h2x1(:,129),heltab2x2(:,:,129))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),4,0,G2tensor(137),n2h1(99))
  call Hloop_VQ_A(ntryL,G1H2(155),ex3(:),G1H1(1),m3h2x1(:,130),heltab2x2(:,:,130))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),127,0,G2tensor(138),n2h1(100))
  call Hloop_VQ_A(ntryL,G1H2(156),ex3(:),G1H1(1),m3h2x1(:,131),heltab2x2(:,:,131))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),36,0,G2tensor(139),n2h1(101))
  call Hloop_VA_Q(ntryL,G1H2(160),ex6(:),G1H1(1),m3h2x1(:,132),heltab2x2(:,:,132))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),127,0,G2tensor(140),n2h1(102))
  call Hloop_VA_Q(ntryL,G1H2(161),ex6(:),G1H1(1),m3h2x1(:,133),heltab2x2(:,:,133))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),32,0,G2tensor(141),n2h1(103))
  call Hloop_VA_Q(ntryL,G1H2(166),ex6(:),G1H1(1),m3h2x1(:,134),heltab2x2(:,:,134))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),127,0,G2tensor(142),n2h1(104))
  call Hloop_VA_Q(ntryL,G1H2(167),ex6(:),G1H1(1),m3h2x1(:,135),heltab2x2(:,:,135))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),36,0,G2tensor(143),n2h1(105))
  call Hloop_VA_Q(ntryL,G1H2(171),ex6(:),G1H1(1),m3h2x1(:,136),heltab2x2(:,:,136))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),127,0,G2tensor(144),n2h1(106))
  call Hloop_VA_Q(ntryL,G1H2(172),ex6(:),G1H1(1),m3h2x1(:,137),heltab2x2(:,:,137))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),32,0,G2tensor(145),n2h1(107))
  call Hloop_VA_Q(ntryL,G1H2(177),ex6(:),G1H1(1),m3h2x1(:,138),heltab2x2(:,:,138))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),127,0,G2tensor(146),n2h1(108))
  call Hloop_VA_Q(ntryL,G1H2(178),ex6(:),G1H1(1),m3h2x1(:,139),heltab2x2(:,:,139))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),36,0,G2tensor(147),n2h1(109))
  call Hcheck_last_UV_W(ntryL,l_switch,G1H4(8),103,wf4(:,3),24,G2tensor(148),m3h4x1(:,9),heltab2x4(:,:,97))
  call Hcheck_last_UV_W(ntryL,l_switch,G1H4(12),0,wf4(:,3),24,G2tensor(149),m3h4x1(:,10),heltab2x4(:,:,98))
  call Hcheck_last_UV_W(ntryL,l_switch,G1H4(27),103,wf4(:,3),24,G2tensor(150),m3h4x1(:,11),heltab2x4(:,:,99))
  call Hcheck_last_UV_W(ntryL,l_switch,G1H4(28),32,wf4(:,3),24,G2tensor(151),m3h4x1(:,12),heltab2x4(:,:,100))
  call Hloop_AV_Q(ntryL,G1H4(18),wf4(:,3),G1H1(1),m3h4x1(:,13),heltab2x4(:,:,101))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),127,0,G2tensor(152),n2h1(112))
  call Hloop_AV_Q(ntryL,G1H4(2),wf4(:,3),G1H1(1),m3h4x1(:,14),heltab2x4(:,:,102))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),24,0,G2tensor(153),n2h1(113))
  call Hloop_AV_Q(ntryL,G1H4(60),wf4(:,3),G1H1(1),m3h4x1(:,15),heltab2x4(:,:,103))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),127,0,G2tensor(154),n2h1(114))
  call Hloop_AV_Q(ntryL,G1H4(61),wf4(:,3),G1H1(1),m3h4x1(:,16),heltab2x4(:,:,104))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),27,0,G2tensor(155),n2h1(115))
  call Hloop_AV_Q(ntryL,G1H4(65),wf4(:,3),G1H1(1),m3h4x1(:,17),heltab2x4(:,:,105))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),127,0,G2tensor(156),n2h1(116))
  call Hloop_AV_Q(ntryL,G1H4(66),wf4(:,3),G1H1(1),m3h4x1(:,18),heltab2x4(:,:,106))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),24,0,G2tensor(157),n2h1(117))
  call Hloop_AV_Q(ntryL,G1H4(71),wf4(:,3),G1H1(1),m3h4x1(:,19),heltab2x4(:,:,107))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),127,0,G2tensor(158),n2h1(118))
  call Hloop_AV_Q(ntryL,G1H4(72),wf4(:,3),G1H1(1),m3h4x1(:,20),heltab2x4(:,:,108))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),56,0,G2tensor(159),n2h1(119))
  call Hloop_QV_A(ntryL,G1H4(76),wf4(:,3),G1H1(1),m3h4x1(:,21),heltab2x4(:,:,109))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),127,0,G2tensor(160),n2h1(120))
  call Hloop_QV_A(ntryL,G1H4(77),wf4(:,3),G1H1(1),m3h4x1(:,22),heltab2x4(:,:,110))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),24,0,G2tensor(161),n2h1(121))
  call Hloop_QV_A(ntryL,G1H4(82),wf4(:,3),G1H1(1),m3h4x1(:,23),heltab2x4(:,:,111))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),127,0,G2tensor(162),n2h1(122))
  call Hloop_QV_A(ntryL,G1H4(83),wf4(:,3),G1H1(1),m3h4x1(:,24),heltab2x4(:,:,112))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),28,0,G2tensor(163),n2h1(123))
  call Hloop_VQ_A(ntryL,G1H2(183),ex3(:),G1H1(1),m3h2x1(:,140),heltab2x2(:,:,140))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),28,0,G2tensor(164),n2h1(124))
  call Hloop_VA_Q(ntryL,G1H2(188),ex6(:),G1H1(1),m3h2x1(:,141),heltab2x2(:,:,141))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),56,0,G2tensor(165),n2h1(125))
  call ol_merge_tensors(G2tensor(23),[G2tensor(6),G1tensor(26),G1tensor(9)])
  call ol_merge_tensors(G2tensor(25),[G2tensor(8),G1tensor(32)])
  call ol_merge_tensors(G2tensor(29),[G2tensor(10),G1tensor(38),G1tensor(15)])
  call ol_merge_tensors(G2tensor(31),[G2tensor(12),G1tensor(44),G1tensor(3)])
  call ol_merge_tensors(G2tensor(33),[G2tensor(14),G1tensor(50)])
  call ol_merge_tensors(G2tensor(37),[G2tensor(16),G1tensor(56)])
  call ol_merge_tensors(G2tensor(67),[G1tensor(2)])
  call ol_merge_tensors(G2tensor(39),[G1tensor(4)])
  call ol_merge_tensors(G2tensor(19),[G1tensor(5)])
  call ol_merge_tensors(G2tensor(1),[G1tensor(6)])
  call ol_merge_tensors(G2tensor(70),[G1tensor(39),G1tensor(8)])
  call ol_merge_tensors(G2tensor(41),[G1tensor(10)])
  call ol_merge_tensors(G2tensor(21),[G1tensor(11)])
  call ol_merge_tensors(G2tensor(4),[G1tensor(12)])
  call ol_merge_tensors(G2tensor(73),[G1tensor(14)])
  call ol_merge_tensors(G2tensor(43),[G1tensor(22),G1tensor(16)])
  call ol_merge_tensors(G2tensor(27),[G1tensor(17)])
  call ol_merge_tensors(G2tensor(9),[G1tensor(18)])
  call ol_merge_tensors(G2tensor(76),[G1tensor(20)])
  call ol_merge_tensors(G2tensor(45),[G1tensor(21)])
  call ol_merge_tensors(G2tensor(35),[G1tensor(23)])
  call ol_merge_tensors(G2tensor(15),[G1tensor(24)])
  call ol_merge_tensors(G2tensor(79),[G1tensor(27)])
  call ol_merge_tensors(G2tensor(82),[G1tensor(28)])
  call ol_merge_tensors(G2tensor(85),[G1tensor(29)])
  call ol_merge_tensors(G2tensor(55),[G1tensor(48),G1tensor(30)])
  call ol_merge_tensors(G2tensor(88),[G1tensor(33)])
  call ol_merge_tensors(G2tensor(91),[G1tensor(34)])
  call ol_merge_tensors(G2tensor(94),[G1tensor(35)])
  call ol_merge_tensors(G2tensor(58),[G1tensor(54),G1tensor(36)])
  call ol_merge_tensors(G2tensor(97),[G1tensor(40)])
  call ol_merge_tensors(G2tensor(100),[G1tensor(41)])
  call ol_merge_tensors(G2tensor(61),[G1tensor(42)])
  call ol_merge_tensors(G2tensor(103),[G1tensor(45)])
  call ol_merge_tensors(G2tensor(106),[G1tensor(46)])
  call ol_merge_tensors(G2tensor(109),[G1tensor(47)])
  call ol_merge_tensors(G2tensor(112),[G1tensor(51)])
  call ol_merge_tensors(G2tensor(115),[G1tensor(52)])
  call ol_merge_tensors(G2tensor(118),[G1tensor(53)])
  call ol_merge_tensors(G2tensor(121),[G1tensor(57)])
  call ol_merge_tensors(G2tensor(124),[G1tensor(58)])
  call ol_merge_tensors(G2tensor(127),[G1tensor(59)])
  call ol_merge_tensors(G2tensor(64),[G1tensor(60)])
call Hotf_5pt_reduction_last(G2tensor(23),RedSet_5(22),mass5set(:,2),  & 
G1tensor(1),G1tensor(7),G1tensor(13),G1tensor(19),G1tensor(25),G1tensor(31))
call G_TensorShift(G1tensor(7),8)
call Hotf_5pt_reduction_last(G2tensor(25),RedSet_5(23),mass5set(:,2),  & 
G1tensor(37),G1tensor(43),G1tensor(49),G1tensor(55),G1tensor(26),G1tensor(9))
call G_TensorShift(G1tensor(43),16)
call Hotf_5pt_reduction_last(G2tensor(29),RedSet_5(25),mass5set(:,5),  & 
G1tensor(32),G1tensor(38),G1tensor(15),G1tensor(44),G1tensor(3),G1tensor(50))
call G_TensorShift(G1tensor(38),32)
call Hotf_5pt_reduction_last(G2tensor(31),RedSet_5(26),mass5set(:,2),  & 
G1tensor(56),G1tensor(2),G1tensor(4),G1tensor(5),G1tensor(6),G1tensor(39))
call G_TensorShift(G1tensor(2),16)
call Hotf_5pt_reduction_last(G2tensor(33),RedSet_5(27),mass5set(:,2),  & 
G1tensor(8),G1tensor(10),G1tensor(11),G1tensor(12),G1tensor(14),G1tensor(22))
call G_TensorShift(G1tensor(10),8)
call Hotf_5pt_reduction_last(G2tensor(37),RedSet_5(29),mass5set(:,5),  & 
G1tensor(16),G1tensor(17),G1tensor(18),G1tensor(20),G1tensor(21),G1tensor(23))
call G_TensorShift(G1tensor(17),4)
call Hotf_5pt_reduction_last(G2tensor(67),RedSet_5(40),mass5set(:,6),  & 
G1tensor(24),G1tensor(27),G1tensor(28),G1tensor(29),G1tensor(48),G1tensor(30))
call G_TensorShift(G1tensor(27),8)
call Hotf_5pt_reduction_last(G2tensor(39),RedSet_5(30),mass5set(:,2),  & 
G1tensor(33),G1tensor(34),G1tensor(35),G1tensor(54),G1tensor(36),G1tensor(40))
call G_TensorShift(G1tensor(34),16)
call Hotf_5pt_reduction_last(G2tensor(19),RedSet_5(20),mass5set(:,2),  & 
G1tensor(41),G1tensor(42),G1tensor(45),G1tensor(46),G1tensor(47),G1tensor(51))
call G_TensorShift(G1tensor(42),16)
call Hotf_5pt_reduction_last(G2tensor(1),RedSet_5(10),mass5set(:,2),  & 
G1tensor(52),G1tensor(53),G1tensor(57),G1tensor(58),G1tensor(59),G1tensor(60))
call G_TensorShift(G1tensor(53),16)
call Hotf_5pt_reduction_last(G2tensor(70),RedSet_5(41),mass5set(:,6),  & 
G1tensor(61),G1tensor(62),G1tensor(63),G1tensor(64),G1tensor(65),G1tensor(66))
call G_TensorShift(G1tensor(62),16)
call Hotf_5pt_reduction_last(G2tensor(41),RedSet_5(31),mass5set(:,2),  & 
G1tensor(67),G1tensor(68),G1tensor(69),G1tensor(70),G1tensor(71),G1tensor(72))
call G_TensorShift(G1tensor(68),8)
call Hotf_5pt_reduction_last(G2tensor(21),RedSet_5(21),mass5set(:,2),  & 
G1tensor(73),G1tensor(74),G1tensor(75),G1tensor(76),G1tensor(77),G1tensor(78))
call G_TensorShift(G1tensor(74),8)
call Hotf_5pt_reduction_last(G2tensor(4),RedSet_5(11),mass5set(:,2),  & 
G1tensor(79),G1tensor(80),G1tensor(81),G1tensor(82),G1tensor(83),G1tensor(84))
call G_TensorShift(G1tensor(80),8)
call Hotf_5pt_reduction_last(G2tensor(73),RedSet_5(42),mass5set(:,3),  & 
G1tensor(85),G1tensor(86),G1tensor(87),G1tensor(88),G1tensor(89),G1tensor(90))
call G_TensorShift(G1tensor(86),3)
call Hotf_5pt_reduction_last(G2tensor(43),RedSet_5(14),mass5set(:,1),  & 
G1tensor(91),G1tensor(92),G1tensor(93),G1tensor(94),G1tensor(95),G1tensor(96))
call G_TensorShift(G1tensor(92),32)
call Hotf_5pt_reduction_last(G2tensor(27),RedSet_5(24),mass5set(:,3),  & 
G1tensor(97),G1tensor(98),G1tensor(99),G1tensor(100),G1tensor(101),G1tensor(102))
call G_TensorShift(G1tensor(98),32)
call Hotf_5pt_reduction_last(G2tensor(9),RedSet_5(12),mass5set(:,3),  & 
G1tensor(103),G1tensor(104),G1tensor(105),G1tensor(106),G1tensor(107),G1tensor(108))
call G_TensorShift(G1tensor(104),32)
call Hotf_5pt_reduction_last(G2tensor(76),RedSet_5(43),mass5set(:,3),  & 
G1tensor(109),G1tensor(110),G1tensor(111),G1tensor(112),G1tensor(113),G1tensor(114))
call G_TensorShift(G1tensor(110),3)
call Hotf_5pt_reduction_last(G2tensor(45),RedSet_5(32),mass5set(:,5),  & 
G1tensor(115),G1tensor(116),G1tensor(117),G1tensor(118),G1tensor(119),G1tensor(120))
call G_TensorShift(G1tensor(116),32)
call Hotf_5pt_reduction_last(G2tensor(35),RedSet_5(28),mass5set(:,3),  & 
G1tensor(121),G1tensor(122),G1tensor(123),G1tensor(124),G1tensor(125),G1tensor(126))
call G_TensorShift(G1tensor(122),32)
call Hotf_5pt_reduction_last(G2tensor(15),RedSet_5(13),mass5set(:,3),  & 
G1tensor(127),G1tensor(128),G1tensor(129),G1tensor(130),G1tensor(131),G1tensor(132))
call G_TensorShift(G1tensor(128),32)
call Hotf_5pt_reduction_last(G2tensor(79),RedSet_5(44),mass5set(:,7),  & 
G1tensor(133),G1tensor(134),G1tensor(135),G1tensor(136),G1tensor(137),G1tensor(138))
call G_TensorShift(G1tensor(134),4)
call Hotf_5pt_reduction_last(G2tensor(82),RedSet_5(45),mass5set(:,7),  & 
G1tensor(139),G1tensor(140),G1tensor(141),G1tensor(142),G1tensor(143),G1tensor(144))
call G_TensorShift(G1tensor(140),4)
call Hotf_5pt_reduction_last(G2tensor(85),RedSet_5(46),mass5set(:,7),  & 
G1tensor(145),G1tensor(146),G1tensor(147),G1tensor(148),G1tensor(149),G1tensor(150))
call G_TensorShift(G1tensor(146),4)
call Hotf_5pt_reduction_last(G2tensor(55),RedSet_5(36),mass5set(:,1),  & 
G1tensor(151),G1tensor(152),G1tensor(153),G1tensor(154),G1tensor(155),G1tensor(156))
call G_TensorShift(G1tensor(152),4)
call Hotf_5pt_reduction_last(G2tensor(88),RedSet_5(47),mass5set(:,7),  & 
G1tensor(157),G1tensor(158),G1tensor(159),G1tensor(160),G1tensor(161),G1tensor(162))
call G_TensorShift(G1tensor(158),32)
call Hotf_5pt_reduction_last(G2tensor(91),RedSet_5(48),mass5set(:,7),  & 
G1tensor(163),G1tensor(164),G1tensor(165),G1tensor(166),G1tensor(167),G1tensor(168))
call G_TensorShift(G1tensor(164),32)
call Hotf_5pt_reduction_last(G2tensor(94),RedSet_5(49),mass5set(:,7),  & 
G1tensor(169),G1tensor(170),G1tensor(171),G1tensor(172),G1tensor(173),G1tensor(174))
call G_TensorShift(G1tensor(170),32)
call Hotf_5pt_reduction_last(G2tensor(58),RedSet_5(37),mass5set(:,1),  & 
G1tensor(175),G1tensor(176),G1tensor(177),G1tensor(178),G1tensor(179),G1tensor(180))
call G_TensorShift(G1tensor(176),32)
call Hotf_5pt_reduction_last(G2tensor(97),RedSet_5(50),mass5set(:,4),  & 
G1tensor(181),G1tensor(182),G1tensor(183),G1tensor(184),G1tensor(185),G1tensor(186))
call G_TensorShift(G1tensor(182),16)
call Hotf_5pt_reduction_last(G2tensor(100),RedSet_5(51),mass5set(:,4),  & 
G1tensor(187),G1tensor(188),G1tensor(189),G1tensor(190),G1tensor(191),G1tensor(192))
call G_TensorShift(G1tensor(188),16)
call Hotf_5pt_reduction_last(G2tensor(61),RedSet_5(38),mass5set(:,4),  & 
G1tensor(193),G1tensor(194),G1tensor(195),G1tensor(196),G1tensor(197),G1tensor(198))
call G_TensorShift(G1tensor(194),16)
call Hotf_5pt_reduction_last(G2tensor(103),RedSet_5(52),mass5set(:,7),  & 
G1tensor(199),G1tensor(200),G1tensor(201),G1tensor(202),G1tensor(203),G1tensor(204))
call G_TensorShift(G1tensor(200),4)
call Hotf_5pt_reduction_last(G2tensor(106),RedSet_5(53),mass5set(:,7),  & 
G1tensor(205),G1tensor(206),G1tensor(207),G1tensor(208),G1tensor(209),G1tensor(210))
call G_TensorShift(G1tensor(206),4)
call Hotf_5pt_reduction_last(G2tensor(109),RedSet_5(54),mass5set(:,7),  & 
G1tensor(211),G1tensor(212),G1tensor(213),G1tensor(214),G1tensor(215),G1tensor(216))
call G_TensorShift(G1tensor(212),4)
call Hotf_5pt_reduction_last(G2tensor(112),RedSet_5(55),mass5set(:,7),  & 
G1tensor(217),G1tensor(218),G1tensor(219),G1tensor(220),G1tensor(221),G1tensor(222))
call G_TensorShift(G1tensor(218),32)
call Hotf_5pt_reduction_last(G2tensor(115),RedSet_5(56),mass5set(:,7),  & 
G1tensor(223),G1tensor(224),G1tensor(225),G1tensor(226),G1tensor(227),G1tensor(228))
call G_TensorShift(G1tensor(224),32)
call Hotf_5pt_reduction_last(G2tensor(118),RedSet_5(57),mass5set(:,7),  & 
G1tensor(229),G1tensor(230),G1tensor(231),G1tensor(232),G1tensor(233),G1tensor(234))
call G_TensorShift(G1tensor(230),32)
call Hotf_5pt_reduction_last(G2tensor(121),RedSet_5(58),mass5set(:,6),  & 
G1tensor(235),G1tensor(236),G1tensor(237),G1tensor(238),G1tensor(239),G1tensor(240))
call G_TensorShift(G1tensor(236),16)
call Hotf_5pt_reduction_last(G2tensor(124),RedSet_5(59),mass5set(:,4),  & 
G1tensor(241),G1tensor(242),G1tensor(243),G1tensor(244),G1tensor(245),G1tensor(246))
call G_TensorShift(G1tensor(242),16)
call Hotf_5pt_reduction_last(G2tensor(127),RedSet_5(60),mass5set(:,4),  & 
G1tensor(247),G1tensor(248),G1tensor(249),G1tensor(250),G1tensor(251),G1tensor(252))
call G_TensorShift(G1tensor(248),16)
call Hotf_5pt_reduction_last(G2tensor(64),RedSet_5(39),mass5set(:,4),  & 
G1tensor(253),G1tensor(254),G1tensor(255),G1tensor(256),G1tensor(257),G1tensor(258))
call G_TensorShift(G1tensor(254),16)
call Hotf_5pt_reduction_last(G2tensor(47),RedSet_5(4),mass5set(:,3),  & 
G1tensor(259),G1tensor(260),G1tensor(261),G1tensor(262),G1tensor(263),G1tensor(264))
call G_TensorShift(G1tensor(260),35)
call Hotf_5pt_reduction_last(G2tensor(49),RedSet_5(8),mass5set(:,3),  & 
G1tensor(265),G1tensor(266),G1tensor(267),G1tensor(268),G1tensor(269),G1tensor(270))
call G_TensorShift(G1tensor(266),35)
call Hotf_5pt_reduction_last(G2tensor(51),RedSet_5(18),mass5set(:,1),  & 
G1tensor(271),G1tensor(272),G1tensor(273),G1tensor(274),G1tensor(275),G1tensor(276))
call G_TensorShift(G1tensor(272),32)
call Hotf_5pt_reduction_last(G2tensor(53),RedSet_5(19),mass5set(:,1),  & 
G1tensor(277),G1tensor(278),G1tensor(279),G1tensor(280),G1tensor(281),G1tensor(282))
call G_TensorShift(G1tensor(278),32)
call Hotf_5pt_reduction_last(G2tensor(130),RedSet_5(61),mass5set(:,7),  & 
G1tensor(283),G1tensor(284),G1tensor(285),G1tensor(286),G1tensor(287),G1tensor(288))
call G_TensorShift(G1tensor(284),35)
call Hotf_5pt_reduction_last(G2tensor(133),RedSet_5(62),mass5set(:,7),  & 
G1tensor(289),G1tensor(290),G1tensor(291),G1tensor(292),G1tensor(293),G1tensor(294))
call G_TensorShift(G1tensor(290),35)
call Hotf_5pt_reduction_last(G2tensor(136),RedSet_5(15),mass5set(:,1),  & 
G1tensor(295),G1tensor(296),G1tensor(297),G1tensor(298),G1tensor(299),G1tensor(300))
call G_TensorShift(G1tensor(296),4)
call Hotf_5pt_reduction_last(G2tensor(140),RedSet_5(16),mass5set(:,1),  & 
G1tensor(301),G1tensor(302),G1tensor(303),G1tensor(304),G1tensor(305),G1tensor(306))
call G_TensorShift(G1tensor(302),32)
call Hotf_5pt_reduction_last(G2tensor(144),RedSet_5(17),mass5set(:,1),  & 
G1tensor(307),G1tensor(308),G1tensor(309),G1tensor(310),G1tensor(311),G1tensor(312))
call G_TensorShift(G1tensor(308),32)
call Hotf_5pt_reduction_last(G2tensor(148),RedSet_5(1),mass5set(:,1),  & 
G1tensor(313),G1tensor(314),G1tensor(315),G1tensor(316),G1tensor(317),G1tensor(318))
call G_TensorShift(G1tensor(314),24)
call Hotf_5pt_reduction_last(G2tensor(152),RedSet_5(33),mass5set(:,1),  & 
G1tensor(319),G1tensor(320),G1tensor(321),G1tensor(322),G1tensor(323),G1tensor(324))
call G_TensorShift(G1tensor(320),24)
call Hotf_5pt_reduction_last(G2tensor(156),RedSet_5(34),mass5set(:,1),  & 
G1tensor(325),G1tensor(326),G1tensor(327),G1tensor(328),G1tensor(329),G1tensor(330))
call G_TensorShift(G1tensor(326),24)
call Hotf_5pt_reduction_last(G2tensor(160),RedSet_5(35),mass5set(:,1),  & 
G1tensor(331),G1tensor(332),G1tensor(333),G1tensor(334),G1tensor(335),G1tensor(336))
call G_TensorShift(G1tensor(332),24)
call ol_merge_tensors(T1sum(11),[G1tensor(1)])
call ol_merge_tensors(T1sum(12),[G1tensor(37)])
call ol_merge_tensors(T1sum(13),[G1tensor(32)])
call ol_merge_tensors(T1sum(14),[G1tensor(56)])
call ol_merge_tensors(T1sum(15),[G1tensor(8)])
call ol_merge_tensors(T1sum(16),[G1tensor(16)])
call ol_merge_tensors(T1sum(17),[G1tensor(24)])
call ol_merge_tensors(T1sum(18),[G1tensor(33)])
call ol_merge_tensors(T1sum(19),[G1tensor(41)])
call ol_merge_tensors(T1sum(20),[G1tensor(52)])
call ol_merge_tensors(T1sum(21),[G1tensor(61)])
call ol_merge_tensors(T1sum(22),[G1tensor(67)])
call ol_merge_tensors(T1sum(23),[G1tensor(73)])
call ol_merge_tensors(T1sum(24),[G1tensor(79)])
call ol_merge_tensors(T1sum(25),[G1tensor(85)])
call ol_merge_tensors(T1sum(26),[G1tensor(91)])
call ol_merge_tensors(T1sum(27),[G1tensor(97)])
call ol_merge_tensors(T1sum(28),[G1tensor(103)])
call ol_merge_tensors(T1sum(29),[G1tensor(109)])
call ol_merge_tensors(T1sum(30),[G1tensor(115)])
call ol_merge_tensors(T1sum(31),[G1tensor(121)])
call ol_merge_tensors(T1sum(32),[G1tensor(127)])
call ol_merge_tensors(T1sum(33),[G1tensor(133)])
call ol_merge_tensors(T1sum(34),[G1tensor(139)])
call ol_merge_tensors(T1sum(35),[G1tensor(145)])
call ol_merge_tensors(T1sum(36),[G1tensor(151)])
call ol_merge_tensors(T1sum(37),[G1tensor(157)])
call ol_merge_tensors(T1sum(38),[G1tensor(163)])
call ol_merge_tensors(T1sum(39),[G1tensor(169)])
call ol_merge_tensors(T1sum(40),[G1tensor(175)])
call ol_merge_tensors(T1sum(41),[G1tensor(181)])
call ol_merge_tensors(T1sum(42),[G1tensor(187)])
call ol_merge_tensors(T1sum(43),[G1tensor(193)])
call ol_merge_tensors(T1sum(44),[G1tensor(199)])
call ol_merge_tensors(T1sum(45),[G1tensor(205)])
call ol_merge_tensors(T1sum(46),[G1tensor(211)])
call ol_merge_tensors(T1sum(47),[G1tensor(217)])
call ol_merge_tensors(T1sum(48),[G1tensor(223)])
call ol_merge_tensors(T1sum(49),[G1tensor(229)])
call ol_merge_tensors(T1sum(50),[G1tensor(235)])
call ol_merge_tensors(T1sum(51),[G1tensor(241)])
call ol_merge_tensors(T1sum(52),[G1tensor(247)])
call ol_merge_tensors(T1sum(53),[G1tensor(253)])
call ol_merge_tensors(T1sum(54),[G1tensor(259)])
call ol_merge_tensors(T1sum(55),[G1tensor(265)])
call ol_merge_tensors(T1sum(56),[G1tensor(271)])
call ol_merge_tensors(T1sum(57),[G1tensor(277)])
call ol_merge_tensors(T1sum(58),[G1tensor(283)])
call ol_merge_tensors(T1sum(59),[G1tensor(289)])
call ol_merge_tensors(T1sum(60),[G1tensor(295)])
call ol_merge_tensors(T1sum(61),[G1tensor(301)])
call ol_merge_tensors(T1sum(62),[G1tensor(307)])
call ol_merge_tensors(T1sum(63),[G1tensor(313)])
call ol_merge_tensors(T1sum(64),[G1tensor(319)])
call ol_merge_tensors(T1sum(65),[G1tensor(325)])
call ol_merge_tensors(T1sum(66),[G1tensor(331)])
Gcoeff(:)%j = (c(14)*(-M(2,:)%j+M(3,:)%j)-c(19)*M(4,:)%j) * den(138)
call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(47),h0tab(:,47),[88,4,3,32],[0,0,0,0],5,2,wf4(:,3),wf4(:,4))
  call Hloop_GGG_G_12(ntryL,G0H128(1),ex7(:),wf4(:,3),G0H16(1),m4h2x4x16(:,1),heltab3x128(:,:,1))
Gcoeff(:)%j = (-(c(19)*M(1,:)%j)+c(14)*(-M(2,:)%j+M(3,:)%j)) * den(138)
call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(48),h0tab(:,48),[88,4,3,32],[0,0,0,0],5,2,wf4(:,3),wf4(:,4))
  call Hloop_GGG_G_12(ntryL,G0H128(1),wf4(:,3),ex7(:),G0H16(2),m4h4x2x16(:,1),heltab3x128(:,:,2))
Gcoeff(:)%j = (c(19)*(-M(1,:)%j+M(4,:)%j)) * den(138)
call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(49),h0tab(:,49),[88,4,3,32],[0,0,0,0],5,2,wf4(:,3),wf4(:,4))
  call Hloop_GGG_G_23(ntryL,G0H128(1),ex7(:),wf4(:,3),G0H16(3),m4h2x4x16(:,2),heltab3x128(:,:,3))
Gcoeff(:)%j = (c(11)*M(1,:)%j-c(10)*M(3,:)%j) * den(141)
call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(50),h0tab(:,50),[68,24,3,32],[0,0,0,0],4,3,wf4(:,5),wf4(:,3),wf4(:,4))
  call Hloop_VQ_A(ntryL,G0H128(1),wf4(:,5),G0H32(3),m3h4x32(:,9),heltab2x128(:,:,47))
  call Hloop_Q_A(ntryL,G0H32(3),68,0,G1H32(3),n2h32(25))
Gcoeff(:)%j = (c(6)*M(1,:)%j-c(4)*M(3,:)%j) * den(141)
call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(51),h0tab(:,51),[68,3,32,24],[0,0,0,0],4,3,wf4(:,5),wf4(:,4),wf4(:,3))
  call Hloop_VQ_A(ntryL,G0H128(1),wf4(:,5),G0H32(1),m3h4x32(:,10),heltab2x128(:,:,48))
  call Hloop_Q_A(ntryL,G0H32(1),68,0,G1H32(1),n2h32(26))
Gcoeff(:)%j = (c(11)*M(1,:)%j-c(10)*M(3,:)%j) * den(141)
call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(52),h0tab(:,52),[68,3,24,32],[0,0,0,0],4,3,wf4(:,5),wf4(:,4),wf4(:,3))
  call Hloop_VQ_A(ntryL,G0H128(1),wf4(:,5),G0H32(2),m3h4x32(:,11),heltab2x128(:,:,49))
  call Hloop_Q_A(ntryL,G0H32(2),68,0,G1H32(10),n2h32(27))
Gcoeff(:)%j = (c(4)*M(3,:)%j-c(6)*M(4,:)%j) * den(144)
call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(53),h0tab(:,53),[96,3,4,24],[0,0,0,0],4,3,wf4(:,7),wf4(:,4),wf4(:,3))
  call Hloop_VA_Q(ntryL,G0H128(1),wf4(:,7),G0H32(3),m3h4x32(:,12),heltab2x128(:,:,50))
  call Hloop_A_Q(ntryL,G0H32(3),96,0,G1H32(12),n2h32(28))
Gcoeff(:)%j = (-(c(10)*M(3,:)%j)+c(11)*M(4,:)%j) * den(144)
call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(54),h0tab(:,54),[96,4,3,24],[0,0,0,0],4,3,wf4(:,7),wf4(:,4),wf4(:,3))
  call Hloop_QA_V(ntryL,G0H128(1),wf4(:,7),G0H32(1),m3h4x32(:,13),heltab2x128(:,:,51))
Gcoeff(:)%j = (-(c(10)*M(3,:)%j)+c(11)*M(4,:)%j) * den(144)
call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(55),h0tab(:,55),[96,3,24,4],[0,0,0,0],4,3,wf4(:,7),wf4(:,4),wf4(:,3))
  call Hloop_VA_Q(ntryL,G0H128(1),wf4(:,7),G0H32(2),m3h4x32(:,14),heltab2x128(:,:,52))
  call Hloop_A_Q(ntryL,G0H32(2),96,0,G1H32(4),n2h32(29))
Gcoeff(:)%j = (-(c(14)*M(2,:)%j)-c(10)*M(3,:)%j+c(11)*M(4,:)%j) * den(111)
call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(56),h0tab(:,56),[64,24,7,32],[0,0,0,0],4,2,wf4(:,3),wf8(:,6))
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,39),heltab2x128(:,:,53))
  call Hloop_A_Q(ntryL,G0H64(1),64,0,G1H64(1),n2h64(23))
Gcoeff(:)%j = (c(14)*(-M(2,:)%j+M(3,:)%j)-c(19)*M(4,:)%j) * den(111)
call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(57),h0tab(:,57),[64,24,7,32],[0,0,0,0],4,2,wf4(:,3),wf8(:,6))
  call Hloop_UV_W(ntryL,G0H128(1),0,ex7(:),64,G1H64(2),m3h2x64(:,40),heltab2x128(:,:,54))
Gcoeff(:)%j = (c(4)*M(2,:)%j) * den(111)
call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(58),h0tab(:,58),[64,7,24,32],[0,0,0,0],4,2,wf8(:,6),wf4(:,3))
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,41),heltab2x128(:,:,55))
  call Hloop_A_Q(ntryL,G0H64(1),64,0,G1H64(3),n2h64(24))
Gcoeff(:)%j = (-(c(4)*M(2,:)%j)) * den(111)
call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(59),h0tab(:,59),[64,7,24,32],[0,0,0,0],4,2,wf8(:,6),wf4(:,3))
  call Hloop_UV_W(ntryL,G0H128(1),0,ex7(:),64,G1H64(4),m3h2x64(:,42),heltab2x128(:,:,56))
Gcoeff(:)%j = (c(11)*M(1,:)%j-c(14)*M(2,:)%j-c(10)*M(3,:)%j) * den(111)
call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(60),h0tab(:,60),[64,7,32,24],[0,0,0,0],4,2,wf8(:,6),wf4(:,3))
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,43),heltab2x128(:,:,57))
  call Hloop_A_Q(ntryL,G0H64(1),64,0,G1H64(5),n2h64(25))
Gcoeff(:)%j = (-(c(19)*M(1,:)%j)+c(14)*(-M(2,:)%j+M(3,:)%j)) * den(111)
call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(61),h0tab(:,61),[64,7,32,24],[0,0,0,0],4,2,wf8(:,6),wf4(:,3))
  call Hloop_UV_W(ntryL,G0H128(1),0,ex7(:),64,G1H64(6),m3h2x64(:,44),heltab2x128(:,:,58))
Gcoeff(:)%j = (c(4)*M(2,:)%j) * den(114)
call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(62),h0tab(:,62),[64,4,24,35],[0,0,0,0],4,2,wf4(:,3),wf8(:,2))
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,45),heltab2x128(:,:,59))
  call Hloop_A_Q(ntryL,G0H64(1),64,0,G1H64(7),n2h64(26))
Gcoeff(:)%j = (-(c(4)*M(2,:)%j)) * den(114)
call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(63),h0tab(:,63),[64,4,24,35],[0,0,0,0],4,2,wf4(:,3),wf8(:,2))
  call Hloop_UV_W(ntryL,G0H128(1),0,ex7(:),64,G1H64(8),m3h2x64(:,46),heltab2x128(:,:,60))
Gcoeff(:)%j = (c(11)*M(1,:)%j-c(14)*M(2,:)%j-c(10)*M(3,:)%j) * den(114)
call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(64),h0tab(:,64),[64,4,35,24],[0,0,0,0],4,2,wf8(:,2),wf4(:,3))
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,47),heltab2x128(:,:,61))
  call Hloop_A_Q(ntryL,G0H64(1),64,0,G1H64(9),n2h64(27))
Gcoeff(:)%j = (-(c(19)*M(1,:)%j)+c(14)*(-M(2,:)%j+M(3,:)%j)) * den(114)
call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(65),h0tab(:,65),[64,4,35,24],[0,0,0,0],4,2,wf8(:,2),wf4(:,3))
  call Hloop_UV_W(ntryL,G0H128(1),0,ex7(:),64,G1H64(10),m3h2x64(:,48),heltab2x128(:,:,62))
Gcoeff(:)%j = (-(c(14)*M(2,:)%j)-c(10)*M(3,:)%j+c(11)*M(4,:)%j) * den(114)
call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(66),h0tab(:,66),[64,24,4,35],[0,0,0,0],4,2,wf4(:,3),wf8(:,2))
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,49),heltab2x128(:,:,63))
  call Hloop_A_Q(ntryL,G0H64(1),64,0,G1H64(11),n2h64(28))
Gcoeff(:)%j = (c(14)*(-M(2,:)%j+M(3,:)%j)-c(19)*M(4,:)%j) * den(114)
call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(67),h0tab(:,67),[64,24,4,35],[0,0,0,0],4,2,wf4(:,3),wf8(:,2))
  call Hloop_UV_W(ntryL,G0H128(1),0,ex7(:),64,G1H64(12),m3h2x64(:,50),heltab2x128(:,:,64))
Gcoeff(:)%j = (-(c(4)*M(3,:)%j)+c(6)*M(4,:)%j) * den(117)
call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(68),h0tab(:,68),[64,28,3,32],[0,0,0,0],4,2,wf8(:,8),wf4(:,4))
  call Hloop_UV_W(ntryL,G0H128(1),0,ex7(:),64,G1H64(13),m3h2x64(:,51),heltab2x128(:,:,65))
Gcoeff(:)%j = (-(c(10)*M(3,:)%j)+c(11)*M(4,:)%j) * den(117)
call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(69),h0tab(:,69),[64,3,28,32],[0,0,0,0],4,2,wf4(:,4),wf8(:,8))
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,52),heltab2x128(:,:,66))
  call Hloop_A_Q(ntryL,G0H64(1),64,0,G1H64(14),n2h64(29))
Gcoeff(:)%j = (-(c(10)*M(3,:)%j)+c(11)*M(4,:)%j) * den(117)
call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(70),h0tab(:,70),[64,3,32,28],[0,0,0,0],4,2,wf4(:,4),wf8(:,8))
  call Hloop_QV_A(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,53),heltab2x128(:,:,67))
  call Hloop_Q_A(ntryL,G0H64(1),64,0,G1H64(15),n2h64(30))
Gcoeff(:)%j = (c(6)*M(1,:)%j-c(4)*M(3,:)%j) * den(119)
call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(71),h0tab(:,71),[64,4,3,56],[0,0,0,0],4,2,wf4(:,4),wf8(:,4))
  call Hloop_UV_W(ntryL,G0H128(1),0,ex7(:),64,G1H64(16),m3h2x64(:,54),heltab2x128(:,:,68))
Gcoeff(:)%j = (c(11)*M(1,:)%j-c(10)*M(3,:)%j) * den(119)
call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(72),h0tab(:,72),[64,3,56,4],[0,0,0,0],4,2,wf4(:,4),wf8(:,4))
  call Hloop_QV_A(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,55),heltab2x128(:,:,69))
  call Hloop_Q_A(ntryL,G0H64(1),64,0,G1H64(17),n2h64(31))
Gcoeff(:)%j = (c(11)*M(1,:)%j-c(10)*M(3,:)%j) * den(119)
call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(73),h0tab(:,73),[64,3,4,56],[0,0,0,0],4,2,wf4(:,4),wf8(:,4))
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,56),heltab2x128(:,:,70))
  call Hloop_A_Q(ntryL,G0H64(1),64,0,G1H64(18),n2h64(32))
Gcoeff(:)%j = (c(3)*(-M(1,:)%j+M(4,:)%j)) * den(153)
call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(74),h0tab(:,74),[88,3,4,32],[0,0,0,0],4,2,wf8(:,9),wf4(:,4))
  call Hloop_AV_Q(ntryL,G0H128(1),wf8(:,9),G0H16(4),m3h8x16(:,1),heltab2x128(:,:,71))
  call Hloop_A_Q(ntryL,G0H16(4),88,0,G1H16(20),n2h16(34))
Gcoeff(:)%j = (c(3)*(-M(1,:)%j+M(4,:)%j)) * den(153)
call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(75),h0tab(:,75),[88,3,32,4],[0,0,0,0],4,2,wf8(:,9),wf4(:,4))
  call Hloop_QV_A(ntryL,G0H128(1),wf8(:,9),G0H16(4),m3h8x16(:,2),heltab2x128(:,:,72))
  call Hloop_Q_A(ntryL,G0H16(4),88,0,G1H16(21),n2h16(35))
Gcoeff(:)%j = (c(19)*(-M(1,:)%j+M(4,:)%j)) * den(153)
call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(76),h0tab(:,76),[88,4,3,32],[0,0,0,0],4,2,wf8(:,9),wf4(:,4))
  call Hloop_UV_W(ntryL,G0H128(1),0,wf8(:,9),88,G1H16(3),m3h8x16(:,3),heltab2x128(:,:,73))
Gcoeff(:)%j = (c(12)*M(1,:)%j-c(15)*M(3,:)%j) * den(121)
call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(77),h0tab(:,77),[68,8,16,35],[0,nMT,0,0],4,2,wf4(:,5),wf8(:,2))
  call Hloop_AQ_V(ntryL,G0H128(1),wf4(:,5),G0H32(3),m3h4x32(:,15),heltab2x128(:,:,74))
Gcoeff(:)%j = (-(c(17)*M(1,:)%j)-c(10)*M(3,:)%j) * den(121)
call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(78),h0tab(:,78),[68,16,8,35],[0,nMT,0,0],4,2,wf4(:,5),wf8(:,2))
  call Hloop_AQ_V(ntryL,G0H128(1),wf4(:,5),G0H32(2),m3h4x32(:,16),heltab2x128(:,:,75))
Gcoeff(:)%j = (-(c(17)*M(1,:)%j)-c(10)*M(3,:)%j) * den(36)
call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(79),h0tab(:,79),[71,16,8,32],[0,nMT,0,0],4,1,wf16(:,17))
  call Hloop_AQ_V(ntryL,G0H128(1),wf16(:,17),G0H8(1),m3h16x8(:,1),heltab2x128(:,:,76))
Gcoeff(:)%j = (c(12)*M(1,:)%j-c(15)*M(3,:)%j) * den(36)
call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(80),h0tab(:,80),[71,8,16,32],[0,nMT,0,0],4,1,wf16(:,17))
  call Hloop_AQ_V(ntryL,G0H128(1),wf16(:,17),G0H8(2),m3h16x8(:,2),heltab2x128(:,:,77))
Gcoeff(:)%j = (-(c(15)*M(2,:)%j)+c(12)*M(4,:)%j) * den(155)
call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(81),h0tab(:,81),[72,7,32,16],[0,0,0,nMT],4,2,wf4(:,9),wf8(:,6))
  call Hloop_AQ_V(ntryL,G0H128(1),wf4(:,9),G0H32(4),m3h4x32(:,17),heltab2x128(:,:,78))
Gcoeff(:)%j = (-(c(10)*M(2,:)%j)-c(17)*M(4,:)%j) * den(155)
call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(82),h0tab(:,82),[72,16,7,32],[nMT,0,0,0],4,2,wf4(:,9),wf8(:,6))
  call Hloop_VQ_A(ntryL,G0H128(1),wf4(:,9),G0H32(5),m3h4x32(:,18),heltab2x128(:,:,79))
  call Hloop_Q_A(ntryL,G0H32(5),72,nMT,G1H32(6),n2h32(30))
Gcoeff(:)%j = (-(c(10)*M(2,:)%j)-c(17)*M(4,:)%j) * den(157)
call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(83),h0tab(:,83),[72,16,4,35],[nMT,0,0,0],4,2,wf4(:,9),wf8(:,2))
  call Hloop_VQ_A(ntryL,G0H128(1),wf4(:,9),G0H32(5),m3h4x32(:,19),heltab2x128(:,:,80))
  call Hloop_Q_A(ntryL,G0H32(5),72,nMT,G1H32(9),n2h32(31))
Gcoeff(:)%j = (-(c(15)*M(2,:)%j)+c(12)*M(4,:)%j) * den(157)
call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(84),h0tab(:,84),[72,4,35,16],[0,0,0,nMT],4,2,wf4(:,9),wf8(:,2))
  call Hloop_AQ_V(ntryL,G0H128(1),wf4(:,9),G0H32(5),m3h4x32(:,20),heltab2x128(:,:,81))
Gcoeff(:)%j = (-(c(10)*M(2,:)%j)+c(11)*M(4,:)%j) * den(160)
call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(85),h0tab(:,85),[88,3,4,32],[0,0,0,0],4,2,wf8(:,10),wf4(:,4))
  call Hloop_AV_Q(ntryL,G0H128(1),wf8(:,10),G0H16(4),m3h8x16(:,4),heltab2x128(:,:,82))
  call Hloop_A_Q(ntryL,G0H16(4),88,0,G1H16(7),n2h16(36))
Gcoeff(:)%j = (-(c(10)*M(2,:)%j)+c(11)*M(4,:)%j) * den(160)
call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(86),h0tab(:,86),[88,3,32,4],[0,0,0,0],4,2,wf8(:,10),wf4(:,4))
  call Hloop_QV_A(ntryL,G0H128(1),wf8(:,10),G0H16(4),m3h8x16(:,5),heltab2x128(:,:,83))
  call Hloop_Q_A(ntryL,G0H16(4),88,0,G1H16(8),n2h16(37))
Gcoeff(:)%j = (-(c(4)*M(2,:)%j)+c(6)*M(4,:)%j) * den(160)
call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(87),h0tab(:,87),[88,4,3,32],[0,0,0,0],4,2,wf8(:,10),wf4(:,4))
  call Hloop_UV_W(ntryL,G0H128(1),0,wf8(:,10),88,G1H16(10),m3h8x16(:,6),heltab2x128(:,:,84))
Gcoeff(:)%j = (-(c(17)*M(1,:)%j)-c(10)*M(2,:)%j) * den(163)
call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(88),h0tab(:,88),[80,7,32,8],[0,0,0,nMT],4,2,wf4(:,11),wf8(:,6))
  call Hloop_QA_V(ntryL,G0H128(1),wf4(:,11),G0H32(6),m3h4x32(:,21),heltab2x128(:,:,85))
Gcoeff(:)%j = (c(12)*M(1,:)%j-c(15)*M(2,:)%j) * den(163)
call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(89),h0tab(:,89),[80,8,7,32],[nMT,0,0,0],4,2,wf4(:,11),wf8(:,6))
  call Hloop_VA_Q(ntryL,G0H128(1),wf4(:,11),G0H32(7),m3h4x32(:,22),heltab2x128(:,:,86))
  call Hloop_A_Q(ntryL,G0H32(7),80,nMT,G1H32(11),n2h32(32))
Gcoeff(:)%j = (c(12)*M(1,:)%j-c(15)*M(2,:)%j) * den(165)
call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(90),h0tab(:,90),[80,8,4,35],[nMT,0,0,0],4,2,wf4(:,11),wf8(:,2))
  call Hloop_VA_Q(ntryL,G0H128(1),wf4(:,11),G0H32(7),m3h4x32(:,23),heltab2x128(:,:,87))
  call Hloop_A_Q(ntryL,G0H32(7),80,nMT,G1H32(7),n2h32(33))
Gcoeff(:)%j = (-(c(17)*M(1,:)%j)-c(10)*M(2,:)%j) * den(165)
call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(91),h0tab(:,91),[80,4,35,8],[0,0,0,nMT],4,2,wf4(:,11),wf8(:,2))
  call Hloop_QA_V(ntryL,G0H128(1),wf4(:,11),G0H32(7),m3h4x32(:,24),heltab2x128(:,:,88))
Gcoeff(:)%j = (c(11)*M(1,:)%j-c(10)*M(2,:)%j) * den(168)
call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(92),h0tab(:,92),[88,3,4,32],[0,0,0,0],4,2,wf8(:,11),wf4(:,4))
  call Hloop_AV_Q(ntryL,G0H128(1),wf8(:,11),G0H16(4),m3h8x16(:,7),heltab2x128(:,:,89))
  call Hloop_A_Q(ntryL,G0H16(4),88,0,G1H16(11),n2h16(38))
Gcoeff(:)%j = (c(11)*M(1,:)%j-c(10)*M(2,:)%j) * den(168)
call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(93),h0tab(:,93),[88,3,32,4],[0,0,0,0],4,2,wf8(:,11),wf4(:,4))
  call Hloop_QV_A(ntryL,G0H128(1),wf8(:,11),G0H16(4),m3h8x16(:,8),heltab2x128(:,:,90))
  call Hloop_Q_A(ntryL,G0H16(4),88,0,G1H16(15),n2h16(39))
Gcoeff(:)%j = (c(6)*M(1,:)%j-c(4)*M(2,:)%j) * den(168)
call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(94),h0tab(:,94),[88,4,3,32],[0,0,0,0],4,2,wf8(:,11),wf4(:,4))
  call Hloop_UV_W(ntryL,G0H128(1),0,wf8(:,11),88,G1H16(18),m3h8x16(:,9),heltab2x128(:,:,91))
Gcoeff(:)%j = (-(c(15)*M(3,:)%j)+c(12)*M(4,:)%j) * den(125)
call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(95),h0tab(:,95),[96,7,8,16],[0,0,nMT,0],4,2,wf4(:,7),wf8(:,6))
  call Hloop_VA_Q(ntryL,G0H128(1),wf4(:,7),G0H32(8),m3h4x32(:,25),heltab2x128(:,:,92))
  call Hloop_A_Q(ntryL,G0H32(8),96,0,G1H32(2),n2h32(34))
Gcoeff(:)%j = (-(c(10)*M(3,:)%j)-c(17)*M(4,:)%j) * den(125)
call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(96),h0tab(:,96),[96,7,16,8],[0,0,nMT,0],4,2,wf4(:,7),wf8(:,6))
  call Hloop_VA_Q(ntryL,G0H128(1),wf4(:,7),G0H32(8),m3h4x32(:,26),heltab2x128(:,:,93))
  call Hloop_A_Q(ntryL,G0H32(8),96,0,G1H32(8),n2h32(35))
Gcoeff(:)%j = (-(c(15)*M(3,:)%j)+c(12)*M(4,:)%j) * den(42)
call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(97),h0tab(:,97),[99,4,8,16],[0,0,nMT,0],4,1,wf16(:,30))
  call Hloop_VA_Q(ntryL,G0H128(1),wf16(:,30),G0H8(3),m3h16x8(:,3),heltab2x128(:,:,94))
  call Hloop_A_Q(ntryL,G0H8(3),99,0,G1H8(26),n2h8(71))
Gcoeff(:)%j = (-(c(10)*M(3,:)%j)-c(17)*M(4,:)%j) * den(42)
call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(98),h0tab(:,98),[99,4,16,8],[0,0,nMT,0],4,1,wf16(:,30))
  call Hloop_VA_Q(ntryL,G0H128(1),wf16(:,30),G0H8(3),m3h16x8(:,4),heltab2x128(:,:,95))
  call Hloop_A_Q(ntryL,G0H8(3),99,0,G1H8(13),n2h8(72))
Gcoeff(:)%j = (-(c(10)*M(2,:)%j)-c(14)*M(3,:)%j+c(11)*M(4,:)%j) * den(83)
call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(99),h0tab(:,99),[64,8,16,39],[nMT,0,nMT,nMT],4,1,wf16(:,5))
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,57),heltab2x128(:,:,96))
  call Hloop_A_Q(ntryL,G0H64(1),64,nMT,G1H64(19),n2h64(33))
Gcoeff(:)%j = (c(14)*(M(2,:)%j-M(3,:)%j)-c(19)*M(4,:)%j) * den(83)
call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(100),h0tab(:,100),[64,8,16,39],[0,nMT,0,0],4,1,wf16(:,5))
  call Hloop_UV_W(ntryL,G0H128(1),0,ex7(:),64,G1H64(20),m3h2x64(:,58),heltab2x128(:,:,97))
Gcoeff(:)%j = (c(11)*M(1,:)%j-c(10)*M(2,:)%j-c(14)*M(3,:)%j) * den(83)
call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(101),h0tab(:,101),[64,16,8,39],[nMT,0,nMT,nMT],4,1,wf16(:,5))
  call Hloop_QV_A(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,59),heltab2x128(:,:,98))
  call Hloop_Q_A(ntryL,G0H64(1),64,nMT,G1H64(21),n2h64(34))
Gcoeff(:)%j = (-(c(19)*M(1,:)%j)+c(14)*(M(2,:)%j-M(3,:)%j)) * den(83)
call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(102),h0tab(:,102),[64,16,8,39],[0,nMT,0,0],4,1,wf16(:,5))
  call Hloop_UV_W(ntryL,G0H128(1),0,ex7(:),64,G1H64(22),m3h2x64(:,60),heltab2x128(:,:,99))
Gcoeff(:)%j = (c(4)*M(3,:)%j) * den(83)
call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(103),h0tab(:,103),[64,8,39,16],[nMT,0,0,nMT],4,1,wf16(:,5))
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,61),heltab2x128(:,:,100))
  call Hloop_A_Q(ntryL,G0H64(1),64,nMT,G1H64(23),n2h64(35))
Gcoeff(:)%j = (-(c(4)*M(3,:)%j)) * den(83)
call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(104),h0tab(:,104),[64,8,39,16],[0,nMT,nMT,0],4,1,wf16(:,5))
  call Hloop_UV_W(ntryL,G0H128(1),0,ex7(:),64,G1H64(24),m3h2x64(:,62),heltab2x128(:,:,101))
Gcoeff(:)%j = (-(c(17)*M(1,:)%j)-c(10)*M(3,:)%j) * den(87)
call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(105),h0tab(:,105),[71,16,8,32],[0,nMT,0,0],4,1,wf16(:,52))
  call Hloop_AQ_V(ntryL,G0H128(1),wf16(:,52),G0H8(3),m3h16x8(:,5),heltab2x128(:,:,102))
Gcoeff(:)%j = (c(12)*M(1,:)%j-c(15)*M(3,:)%j) * den(87)
call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(106),h0tab(:,106),[71,8,16,32],[0,nMT,0,0],4,1,wf16(:,52))
  call Hloop_AQ_V(ntryL,G0H128(1),wf16(:,52),G0H8(4),m3h16x8(:,6),heltab2x128(:,:,103))
Gcoeff(:)%j = (-(c(10)*M(2,:)%j)-c(14)*M(3,:)%j+c(11)*M(4,:)%j) * den(79)
call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(107),h0tab(:,107),[64,8,16,39],[nMT,0,nMT,nMT],4,1,wf16(:,8))
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,63),heltab2x128(:,:,104))
  call Hloop_A_Q(ntryL,G0H64(1),64,nMT,G1H64(25),n2h64(36))
Gcoeff(:)%j = (c(14)*(M(2,:)%j-M(3,:)%j)-c(19)*M(4,:)%j) * den(79)
call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(108),h0tab(:,108),[64,8,16,39],[0,nMT,0,0],4,1,wf16(:,8))
  call Hloop_UV_W(ntryL,G0H128(1),0,ex7(:),64,G1H64(26),m3h2x64(:,64),heltab2x128(:,:,105))
Gcoeff(:)%j = (c(11)*M(1,:)%j-c(10)*M(2,:)%j-c(14)*M(3,:)%j) * den(79)
call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(109),h0tab(:,109),[64,16,8,39],[nMT,0,nMT,nMT],4,1,wf16(:,8))
  call Hloop_QV_A(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,65),heltab2x128(:,:,106))
  call Hloop_Q_A(ntryL,G0H64(1),64,nMT,G1H64(27),n2h64(37))
Gcoeff(:)%j = (-(c(19)*M(1,:)%j)+c(14)*(M(2,:)%j-M(3,:)%j)) * den(79)
call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(110),h0tab(:,110),[64,16,8,39],[0,nMT,0,0],4,1,wf16(:,8))
  call Hloop_UV_W(ntryL,G0H128(1),0,ex7(:),64,G1H64(28),m3h2x64(:,66),heltab2x128(:,:,107))
Gcoeff(:)%j = (c(4)*M(3,:)%j) * den(79)
call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(111),h0tab(:,111),[64,8,39,16],[nMT,0,0,nMT],4,1,wf16(:,8))
  call Hloop_AV_Q(ntryL,G0H128(1),ex7(:),G0H64(1),m3h2x64(:,67),heltab2x128(:,:,108))
  call Hloop_A_Q(ntryL,G0H64(1),64,nMT,G1H64(29),n2h64(38))
Gcoeff(:)%j = (-(c(4)*M(3,:)%j)) * den(79)
call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(112),h0tab(:,112),[64,8,39,16],[0,nMT,nMT,0],4,1,wf16(:,8))
  call Hloop_UV_W(ntryL,G0H128(1),0,ex7(:),64,G1H64(30),m3h2x64(:,68),heltab2x128(:,:,109))
Gcoeff(:)%j = (-(c(15)*M(3,:)%j)+c(12)*M(4,:)%j) * den(76)
call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(113),h0tab(:,113),[99,4,8,16],[0,0,nMT,0],4,1,wf16(:,51))
  call Hloop_VA_Q(ntryL,G0H128(1),wf16(:,51),G0H8(5),m3h16x8(:,7),heltab2x128(:,:,110))
  call Hloop_A_Q(ntryL,G0H8(5),99,0,G1H8(32),n2h8(73))
Gcoeff(:)%j = (-(c(10)*M(3,:)%j)-c(17)*M(4,:)%j) * den(76)
call G0_hol_initialisation(ntryL,Gcoeff,G0H128(1),m0h(114),h0tab(:,114),[99,4,16,8],[0,0,nMT,0],4,1,wf16(:,51))
  call Hloop_VA_Q(ntryL,G0H128(1),wf16(:,51),G0H8(5),m3h16x8(:,8),heltab2x128(:,:,111))
  call Hloop_A_Q(ntryL,G0H8(5),99,0,G1H8(23),n2h8(74))
  call ol_merge(ntryL,G1H16(18),[G1H16(10),G1H16(3),G1H16(22),G0H16(3),G0H16(2),G0H16(1)])
  call ol_merge(ntryL,G1H16(11),[G1H16(7),G1H16(20),G1H16(5)])
  call ol_merge(ntryL,G1H32(10),[G1H32(5)])
  call ol_merge(ntryL,G1H32(1),[G1H32(15)])
  call ol_merge(ntryL,G1H32(3),[G1H32(21)])
  call ol_merge(ntryL,G1H16(15),[G1H16(8),G1H16(21)])
  call ol_merge(ntryL,G0H8(3),[G0H8(1)])
  call ol_merge(ntryL,G0H8(4),[G0H8(2)])
  call ol_merge(ntryL,G1H8(32),[G1H8(26)])
  call ol_merge(ntryL,G1H8(23),[G1H8(13)])
  call Hloop_VQ_A(ntryL,G1H16(18),ex3(:),G1H8(20),m3h2x8(:,39),heltab2x16(:,:,76))
  call Hloop_Q_A(ntryL,G1H8(20),92,0,G2H8(14),n2h8(75))
  call Hloop_QV_A(ntryL,G1H16(9),wf4(:,3),G1H4(16),m3h4x4(:,28),heltab2x16(:,:,77))
  call Hloop_Q_A(ntryL,G1H4(16),91,0,G2H4(23),n2h4(69))
  call Hloop_AW_Q(ntryL,G1H16(11),wf4(:,4),G1H4(59),m3h4x4(:,29),heltab2x16(:,:,78))
  call Hloop_A_Q(ntryL,G1H4(59),91,0,G2H4(24),n2h4(70))
  call Hloop_AV_Q(ntryL,G1H16(16),wf4(:,3),G1H4(70),m3h4x4(:,30),heltab2x16(:,:,79))
  call Hloop_A_Q(ntryL,G1H4(70),91,0,G2H4(33),n2h4(71))
  call Hloop_QW_A(ntryL,G1H32(10),wf4(:,4),G1H8(67),m3h4x8(:,26),heltab2x32(:,:,51))
  call Hloop_Q_A(ntryL,G1H8(67),71,0,G2H8(18),n2h8(76))
  call Hloop_QW_A(ntryL,G1H32(1),wf4(:,4),G1H8(36),m3h4x8(:,27),heltab2x32(:,:,52))
  call Hloop_Q_A(ntryL,G1H8(36),71,0,G2H8(20),n2h8(77))
  call Hloop_QV_A(ntryL,G1H32(3),wf4(:,3),G1H8(39),m3h4x8(:,28),heltab2x32(:,:,53))
  call Hloop_Q_A(ntryL,G1H8(39),92,0,G2H8(21),n2h8(78))
  call Hloop_AW_Q(ntryL,G1H32(12),wf4(:,4),G1H8(24),m3h4x8(:,29),heltab2x32(:,:,54))
  call Hloop_A_Q(ntryL,G1H8(24),99,0,G2H8(22),n2h8(79))
  call Hloop_VQ_A(ntryL,G0H32(1),ex3(:),G0H16(4),m3h2x16(:,22),heltab2x32(:,:,55))
  call Hloop_Q_A(ntryL,G0H16(4),100,0,G1H16(6),n2h16(40))
  call Hloop_AW_Q(ntryL,G1H32(4),wf4(:,4),G1H8(40),m3h4x8(:,30),heltab2x32(:,:,56))
  call Hloop_A_Q(ntryL,G1H8(40),99,0,G2H8(25),n2h8(80))
  call Hloop_AV_Q(ntryL,G1H64(1),wf4(:,3),G1H16(2),m3h4x16(:,13),heltab2x64(:,:,39))
  call Hloop_A_Q(ntryL,G1H16(2),88,0,G2H16(7),n2h16(41))
  call Hloop_UV_W(ntryL,G1H64(2),64,wf4(:,3),24,G2H16(3),m3h4x16(:,14),heltab2x64(:,:,40))
  call Hloop_AQ_V(ntryL,G1H64(3),wf8(:,6),G1H8(43),m3h8x8(:,5),heltab2x64(:,:,41))
  call Hloop_VQ_A(ntryL,G1H64(4),wf8(:,6),G1H8(44),m3h8x8(:,6),heltab2x64(:,:,42))
  call Hloop_Q_A(ntryL,G1H8(44),71,0,G2H8(26),n2h8(81))
  call Hloop_AQ_V(ntryL,G1H64(5),wf8(:,6),G1H8(31),m3h8x8(:,7),heltab2x64(:,:,43))
  call Hloop_VQ_A(ntryL,G1H64(6),wf8(:,6),G1H8(33),m3h8x8(:,8),heltab2x64(:,:,44))
  call Hloop_Q_A(ntryL,G1H8(33),71,0,G2H8(27),n2h8(82))
  call Hloop_AQ_V(ntryL,G1H64(7),ex3(:),G1H32(13),m3h2x32(:,23),heltab2x64(:,:,45))
  call Hloop_VQ_A(ntryL,G1H64(8),ex3(:),G1H32(14),m3h2x32(:,24),heltab2x64(:,:,46))
  call Hloop_Q_A(ntryL,G1H32(14),68,0,G2H32(1),n2h32(36))
  call Hloop_AQ_V(ntryL,G1H64(9),ex3(:),G1H32(16),m3h2x32(:,25),heltab2x64(:,:,47))
  call Hloop_VQ_A(ntryL,G1H64(10),ex3(:),G1H32(17),m3h2x32(:,26),heltab2x64(:,:,48))
  call Hloop_Q_A(ntryL,G1H32(17),68,0,G2H32(2),n2h32(37))
  call Hloop_AV_Q(ntryL,G1H64(11),wf4(:,3),G1H16(12),m3h4x16(:,15),heltab2x64(:,:,49))
  call Hloop_A_Q(ntryL,G1H16(12),88,0,G2H16(4),n2h16(42))
  call Hloop_UV_W(ntryL,G1H64(12),64,wf4(:,3),24,G2H16(1),m3h4x16(:,16),heltab2x64(:,:,50))
  call Hloop_VQ_A(ntryL,G1H64(13),wf8(:,8),G1H8(47),m3h8x8(:,9),heltab2x64(:,:,51))
  call Hloop_Q_A(ntryL,G1H8(47),92,0,G2H8(29),n2h8(83))
  call Hloop_AW_Q(ntryL,G1H64(14),wf4(:,4),G1H16(14),m3h4x16(:,17),heltab2x64(:,:,52))
  call Hloop_A_Q(ntryL,G1H16(14),67,0,G2H16(2),n2h16(43))
  call Hloop_QW_A(ntryL,G1H64(15),wf4(:,4),G1H16(23),m3h4x16(:,18),heltab2x64(:,:,53))
  call Hloop_Q_A(ntryL,G1H16(23),67,0,G2H16(5),n2h16(44))
  call Hloop_VQ_A(ntryL,G1H64(16),ex3(:),G1H32(18),m3h2x32(:,27),heltab2x64(:,:,54))
  call Hloop_Q_A(ntryL,G1H32(18),68,0,G2H32(3),n2h32(38))
  call Hloop_QW_A(ntryL,G1H64(17),wf4(:,4),G1H16(29),m3h4x16(:,19),heltab2x64(:,:,55))
  call Hloop_Q_A(ntryL,G1H16(29),67,0,G2H16(6),n2h16(45))
  call Hloop_AW_Q(ntryL,G1H64(18),wf4(:,4),G1H16(30),m3h4x16(:,20),heltab2x64(:,:,56))
  call Hloop_A_Q(ntryL,G1H16(30),67,0,G2H16(8),n2h16(46))
  call Hloop_QW_A(ntryL,G1H16(15),wf4(:,4),G1H4(81),m3h4x4(:,31),heltab2x16(:,:,80))
  call Hloop_Q_A(ntryL,G1H4(81),91,0,G2H4(3),n2h4(72))
  call Hloop_VQ_A(ntryL,G0H32(3),ex4(:),G0H16(3),m3h2x16(:,23),heltab2x32(:,:,57))
  call Hloop_Q_A(ntryL,G0H16(3),76,nMT,G1H16(31),n2h16(47))
  call Hloop_VA_Q(ntryL,G0H32(2),ex5(:),G0H16(2),m3h2x16(:,24),heltab2x32(:,:,58))
  call Hloop_A_Q(ntryL,G0H16(2),84,nMT,G1H16(32),n2h16(48))
  call Hloop_VA_Q(ntryL,G0H8(3),ex5(:),G0H4(1),m3h2x4(:,68),heltab2x8(:,:,126))
  call Hloop_A_Q(ntryL,G0H4(1),87,nMT,G1H4(41),n2h4(73))
  call Hloop_VQ_A(ntryL,G0H8(4),ex4(:),G0H4(1),m3h2x4(:,69),heltab2x8(:,:,127))
  call Hloop_Q_A(ntryL,G0H4(1),79,nMT,G1H4(42),n2h4(74))
  call Hloop_VQ_A(ntryL,G0H32(4),wf8(:,6),G0H4(1),m3h8x4(:,5),heltab2x32(:,:,59))
  call Hloop_Q_A(ntryL,G0H4(1),79,0,G1H4(48),n2h4(75))
  call Hloop_QA_V(ntryL,G1H32(6),ex5(:),G1H16(35),m3h2x16(:,25),heltab2x32(:,:,60))
  call Hloop_QA_V(ntryL,G1H32(9),ex5(:),G1H16(36),m3h2x16(:,26),heltab2x32(:,:,61))
  call Hloop_VQ_A(ntryL,G0H32(5),ex3(:),G0H16(1),m3h2x16(:,27),heltab2x32(:,:,62))
  call Hloop_Q_A(ntryL,G0H16(1),76,0,G1H16(10),n2h16(49))
  call Hloop_VQ_A(ntryL,G0H32(6),wf8(:,6),G0H4(1),m3h8x4(:,6),heltab2x32(:,:,63))
  call Hloop_Q_A(ntryL,G0H4(1),87,0,G1H4(51),n2h4(76))
  call Hloop_AQ_V(ntryL,G1H32(11),ex4(:),G1H16(3),m3h2x16(:,28),heltab2x32(:,:,64))
  call Hloop_AQ_V(ntryL,G1H32(7),ex4(:),G1H16(22),m3h2x16(:,29),heltab2x32(:,:,65))
  call Hloop_VQ_A(ntryL,G0H32(7),ex3(:),G0H16(4),m3h2x16(:,30),heltab2x32(:,:,66))
  call Hloop_Q_A(ntryL,G0H16(4),84,0,G1H16(7),n2h16(50))
  call Hloop_AQ_V(ntryL,G1H32(2),wf8(:,6),G1H4(52),m3h8x4(:,7),heltab2x32(:,:,67))
  call Hloop_AQ_V(ntryL,G1H32(8),wf8(:,6),G1H4(55),m3h8x4(:,8),heltab2x32(:,:,68))
  call Hloop_AQ_V(ntryL,G1H8(32),ex3(:),G1H4(8),m3h2x4(:,70),heltab2x8(:,:,128))
  call Hloop_AQ_V(ntryL,G1H8(23),ex3(:),G1H4(12),m3h2x4(:,71),heltab2x8(:,:,129))
  call Hloop_AQ_V(ntryL,G1H64(19),ex4(:),G1H32(19),m3h2x32(:,28),heltab2x64(:,:,57))
  call Hloop_VQ_A(ntryL,G1H64(20),ex4(:),G1H32(20),m3h2x32(:,29),heltab2x64(:,:,58))
  call Hloop_Q_A(ntryL,G1H32(20),72,nMT,G2H32(4),n2h32(39))
  call Hloop_QA_V(ntryL,G1H64(21),ex5(:),G1H32(22),m3h2x32(:,30),heltab2x64(:,:,59))
  call Hloop_VA_Q(ntryL,G1H64(22),ex5(:),G1H32(23),m3h2x32(:,31),heltab2x64(:,:,60))
  call Hloop_A_Q(ntryL,G1H32(23),80,nMT,G2H32(5),n2h32(40))
  call Hloop_AQ_V(ntryL,G1H64(23),ex4(:),G1H32(24),m3h2x32(:,32),heltab2x64(:,:,61))
  call Hloop_VQ_A(ntryL,G1H64(24),ex4(:),G1H32(5),m3h2x32(:,33),heltab2x64(:,:,62))
  call Hloop_Q_A(ntryL,G1H32(5),72,nMT,G2H32(6),n2h32(41))
  call Hloop_AQ_V(ntryL,G1H64(25),ex4(:),G1H32(15),m3h2x32(:,34),heltab2x64(:,:,63))
  call Hloop_VQ_A(ntryL,G1H64(26),ex4(:),G1H32(21),m3h2x32(:,35),heltab2x64(:,:,64))
  call Hloop_Q_A(ntryL,G1H32(21),72,nMT,G2H32(7),n2h32(42))
  call Hloop_QA_V(ntryL,G1H64(27),ex5(:),G1H32(10),m3h2x32(:,36),heltab2x64(:,:,65))
  call Hloop_VA_Q(ntryL,G1H64(28),ex5(:),G1H32(1),m3h2x32(:,37),heltab2x64(:,:,66))
  call Hloop_A_Q(ntryL,G1H32(1),80,nMT,G2H32(8),n2h32(43))
  call Hloop_AQ_V(ntryL,G1H64(29),ex4(:),G1H32(3),m3h2x32(:,38),heltab2x64(:,:,67))
  call Hloop_VQ_A(ntryL,G1H64(30),ex4(:),G1H32(12),m3h2x32(:,39),heltab2x64(:,:,68))
  call Hloop_Q_A(ntryL,G1H32(12),72,nMT,G2H32(9),n2h32(44))
  call ol_merge(ntryL,G2H8(29),[G2H8(28),G2H8(5),G1H8(91),G1H8(2),G1H8(11),G1H8(30)])
  call ol_merge(ntryL,G2H8(18),[G1H8(74)])
call HGT_lower_alpha_w2_OLR(G2H8(15),1,1,8)
call HGT_lower_alpha_w2_invQ_OLR(G2H8(15),2,5,8)
call HGT_lower_alpha_w2_OLR(G2H8(15),6,15,8)
  call ol_merge(ntryL,G2H8(15),[G2H8(18)])
  call ol_merge(ntryL,G2H4(45),[G2H4(41)])
call HGT_lower_alpha_w2_OLR(G2H8(17),1,1,8)
call HGT_lower_alpha_w2_invQ_OLR(G2H8(17),2,5,8)
call HGT_lower_alpha_w2_OLR(G2H8(17),6,15,8)
  call ol_merge(ntryL,G2H8(17),[G2H8(25)])
call HGT_w2_OLR(G1H16(24),1,1,16)
call HGT_w2_invQ_OLR(G1H16(24),2,5,16)
  call ol_merge(ntryL,G1H16(24),[G1H16(6)])
  call ol_merge(ntryL,G2H8(26),[G2H8(19),G1H8(75)])
  call ol_merge(ntryL,G2H8(14),[G1H8(41),G1H8(25),G1H8(18)])
call HGT_lower_alpha_OLR(G2H8(23),1,1,8)
call HGT_lower_alpha_invQ_OLR(G2H8(23),2,5,8)
call HGT_lower_alpha_OLR(G2H8(23),6,15,8)
  call ol_merge(ntryL,G2H8(23),[G2H8(14)])
  call ol_merge(ntryL,G2H8(27),[G2H8(24)])
  call ol_merge(ntryL,G1H4(38),[G1H4(19)])
  call ol_merge(ntryL,G1H4(50),[G1H4(20)])
  call ol_merge(ntryL,G1H4(26),[G1H4(5)])
  call ol_merge(ntryL,G1H4(53),[G1H4(17)])
  call ol_merge(ntryL,G1H4(11),[G1H4(25)])
  call ol_merge(ntryL,G1H4(8),[G1H4(31)])
  call ol_merge(ntryL,G1H4(52),[G1H4(32)])
  call ol_merge(ntryL,G1H8(7),[G1H8(29)])
  call ol_merge(ntryL,G1H4(49),[G1H4(37)])
  call ol_merge(ntryL,G1H4(12),[G1H4(43)])
  call ol_merge(ntryL,G1H4(55),[G1H4(44)])
  call ol_merge(ntryL,G1H8(42),[G1H8(9)])
  call ol_merge(ntryL,G1H8(97),[G1H8(38)])
  call ol_merge(ntryL,G1H8(31),[G1H8(46)])
  call ol_merge(ntryL,G1H8(43),[G1H8(64)])
  call ol_merge(ntryL,G1H16(35),[G1H16(13)])
  call ol_merge(ntryL,G2H16(3),[G1H16(1),G1H16(19)])
  call ol_merge(ntryL,G1H16(3),[G1H16(17)])
  call ol_merge(ntryL,G1H16(22),[G1H16(27)])
  call ol_merge(ntryL,G2H16(1),[G1H16(34),G1H16(28)])
  call ol_merge(ntryL,G1H16(36),[G1H16(33)])
  call ol_merge(ntryL,G1H8(102),[G1H8(70)])
  call ol_merge(ntryL,G2H8(21),[G1H8(90)])
call HGT_w2_OLR(G1H8(34),1,1,8)
call HGT_w2_invQ_OLR(G1H8(34),2,5,8)
  call Hloop_VQ_A(ntryL,G1H8(34),ex3(:),G1H4(27),m3h2x4(:,72),heltab2x8(:,:,130))
  call Hloop_Q_A(ntryL,G1H4(27),124,0,G2H4(6),n2h4(77))
call Hotf_4pt_reduction(G2H8(29),RedSet_4(31),mass4set(:,1),  & 
G1H8(48),G1H8(49),G1H8(50),G1H8(53),G1H8(54),8)
call HG1shiftOLR(G1H8(49),32,8)
call Hotf_4pt_reduction(G2H8(15),RedSet_4(153),mass4set(:,1),  & 
G1H8(55),G1H8(56),G1H8(59),G1H8(60),G1H8(61),8)
call HG1shiftOLR(G1H8(56),32,8)
  call Hloop_QA_V(ntryL,G2H4(37),ex6(:),G2H2(8),m3h2x2(:,89),heltab2x4(:,:,113))
call HGT_lower_alpha_w2_OLR(G2H8(16),1,1,8)
call HGT_lower_alpha_w2_invQ_OLR(G2H8(16),2,5,8)
call HGT_lower_alpha_w2_OLR(G2H8(16),6,15,8)
call Hotf_4pt_reduction(G2H8(16),RedSet_4(180),mass4set(:,1),  & 
G1H8(62),G1H8(65),G1H8(66),G1H8(76),G1H8(77),8)
call HG1shiftOLR(G1H8(65),4,8)
  call Hloop_AQ_V(ntryL,G2H4(45),ex3(:),G2H2(2),m3h2x2(:,90),heltab2x4(:,:,114))
call Hotf_4pt_reduction(G2H8(17),RedSet_4(181),mass4set(:,1),  & 
G1H8(92),G1H8(93),G1H8(21),G1H8(19),G1H8(68),8)
call HG1shiftOLR(G1H8(93),4,8)
  call Hloop_QW_A(ntryL,G1H16(24),wf4(:,4),G1H4(28),m3h4x4(:,32),heltab2x16(:,:,81))
  call Hloop_Q_A(ntryL,G1H4(28),103,0,G2H4(1),n2h4(78))
call Hotf_4pt_reduction(G2H8(26),RedSet_4(71),mass4set(:,1),  & 
G1H8(71),G1H8(72),G1H8(73),G1H8(78),G1H8(83),8)
call HG1shiftOLR(G1H8(72),32,8)
call Hotf_4pt_reduction(G2H8(23),RedSet_4(26),mass4set(:,1),  & 
G1H8(79),G1H8(82),G1H8(84),G1H8(87),G1H8(88),8)
call HG1shiftOLR(G1H8(82),32,8)
  call Hloop_QA_V(ntryL,G2H8(27),ex6(:),G2H4(4),m3h2x4(:,73),heltab2x8(:,:,131))
call HGT_w2_OLR(G1H16(4),1,1,16)
call HGT_w2_invQ_OLR(G1H16(4),2,5,16)
  call Hloop_QV_A(ntryL,G1H16(4),wf4(:,3),G1H4(18),m3h4x4(:,33),heltab2x16(:,:,82))
  call Hloop_Q_A(ntryL,G1H4(18),124,0,G2H4(7),n2h4(79))



end subroutine vamp_1

end module ol_vamp_1_pplnttj_nexeuttxdxg_1_/**/REALKIND
