
module ol_colourmatrix_pplnttj_neexuxttxdg_1_/**/REALKIND
  use KIND_TYPES, only: REALKIND
  implicit none
  logical, save           :: colmat_not_initialised = .true.
  complex(REALKIND), save :: K1(120,4), K2(4,4), KL(4,4)
  contains
  subroutine colourmatrix_init
    use ol_parameters_decl_/**/REALKIND, only: CI
    implicit none
    colmat_not_initialised = .false.
    ! colour matrix

  K1(  1,:) = [  36,  12,  12,   0]
  K1(  2,:) = [  12,  36,   0,  12]
  K1(  3,:) = [  12,   0,  36,  12]
  K1(  4,:) = [   0,  12,  12,  36]
  K1(  5,:) = [   0,   0,   0,   0]
  K1(  6,:) = [   0,   0,   0,   0]
  K1(  7,:) = [   0,   0,   0,   0]
  K1(  8,:) = [   0,   0,   0,   0]
  K1(  9,:) = [   0,   0,   0,   0]
  K1( 10,:) = [   0,   0,   0,   0]
  K1( 11,:) = [   0,   0,   0,   0]
  K1( 12,:) = [   0,   0,   0,   0]
  K1( 13,:) = [   0,   0,   0,   0]
  K1( 14,:) = [   0,   0,   0,   0]
  K1( 15,:) = [   0,   0,   0,   0]
  K1( 16,:) = [   0,   0,   0,   0]
  K1( 17,:) = [   0,   0,   0,   0]
  K1( 18,:) = [   0,   0,   0,   0]
  K1( 19,:) = [   0,   0,   0,   0]
  K1( 20,:) = [   0,   0,   0,   0]
  K1( 21,:) = [   0,   0,   0,   0]
  K1( 22,:) = [   0,   0,   0,   0]
  K1( 23,:) = [   0,   0,   0,   0]
  K1( 24,:) = [   0,   0,   0,   0]
  K1( 25,:) = [  48,  16,  16,   0]
  K1( 26,:) = [  16,  48,   0,  16]
  K1( 27,:) = [  16,   0,  48,  16]
  K1( 28,:) = [   0,  16,  16,  48]
  K1( 29,:) = [   0,   0,   0,   0]
  K1( 30,:) = [   0,   0,   0,   0]
  K1( 31,:) = [   0,   0,   0,   0]
  K1( 32,:) = [   0,   0,   0,   0]
  K1( 33,:) = [   0,   0,   0,   0]
  K1( 34,:) = [   0,   0,   0,   0]
  K1( 35,:) = [   0,   0,   0,   0]
  K1( 36,:) = [   0,   0,   0,   0]
  K1( 37,:) = [   6,   2,   2,   0]
  K1( 38,:) = [   2,   0,  -6, -16]
  K1( 39,:) = [   2,  -6,   0, -16]
  K1( 40,:) = [   0, -16, -16, -48]
  K1( 41,:) = [  48,  16,  16,   0]
  K1( 42,:) = [  16,  48,   0,  16]
  K1( 43,:) = [  16,   0,  48,  16]
  K1( 44,:) = [   0,  16,  16,  48]
  K1( 45,:) = [   0,   0,   0,   0]
  K1( 46,:) = [   0,   0,   0,   0]
  K1( 47,:) = [   0,   0,   0,   0]
  K1( 48,:) = [   0,   0,   0,   0]
  K1( 49,:) = [   0,   0,   0,   0]
  K1( 50,:) = [   0,   0,   0,   0]
  K1( 51,:) = [   0,   0,   0,   0]
  K1( 52,:) = [   0,   0,   0,   0]
  K1( 53,:) = [   0,  -2,  16,   6]
  K1( 54,:) = [  -2,   0,   6,  16]
  K1( 55,:) = [  16,   6,   0,  -2]
  K1( 56,:) = [   6,  16,  -2,   0]
  K1( 57,:) = [   0, -16,   2,  -6]
  K1( 58,:) = [ -16, -48,   0, -16]
  K1( 59,:) = [   2,   0,   6,   2]
  K1( 60,:) = [  -6, -16,   2,   0]
  K1( 61,:) = [  48,  16,  16,   0]
  K1( 62,:) = [  16,  48,   0,  16]
  K1( 63,:) = [  16,   0,  48,  16]
  K1( 64,:) = [   0,  16,  16,  48]
  K1( 65,:) = [   0,   0,   0,   0]
  K1( 66,:) = [   0,   0,   0,   0]
  K1( 67,:) = [   0,   0,   0,   0]
  K1( 68,:) = [   0,   0,   0,   0]
  K1( 69,:) = [   0,   0,   0,   0]
  K1( 70,:) = [   0,   0,   0,   0]
  K1( 71,:) = [   0,   0,   0,   0]
  K1( 72,:) = [   0,   0,   0,   0]
  K1( 73,:) = [   0,   2, -16,  -6]
  K1( 74,:) = [   2,   6,   0,   2]
  K1( 75,:) = [ -16,   0, -48, -16]
  K1( 76,:) = [  -6,   2, -16,   0]
  K1( 77,:) = [   0,  16,  -2,   6]
  K1( 78,:) = [  16,   0,   6,  -2]
  K1( 79,:) = [  -2,   6,   0,  16]
  K1( 80,:) = [   6,  -2,  16,   0]
  K1( 81,:) = [ -48, -16, -16,   0]
  K1( 82,:) = [ -16,   0,  -6,   2]
  K1( 83,:) = [ -16,  -6,   0,   2]
  K1( 84,:) = [   0,   2,   2,   6]
  K1( 85,:) = [  48,  16,  16,   0]
  K1( 86,:) = [  16,  48,   0,  16]
  K1( 87,:) = [  16,   0,  48,  16]
  K1( 88,:) = [   0,  16,  16,  48]
  K1( 89,:) = [   0,   0,   0,   0]
  K1( 90,:) = [   0,   0,   0,   0]
  K1( 91,:) = [   0,   0,   0,   0]
  K1( 92,:) = [   0,   0,   0,   0]
  K1( 93,:) = [   0,   0,   0,   0]
  K1( 94,:) = [   0,   0,   0,   0]
  K1( 95,:) = [   0,   0,   0,   0]
  K1( 96,:) = [   0,   0,   0,   0]
  K1( 97,:) = [ -54, -18, -18,   0]
  K1( 98,:) = [ -18, -54,   0, -18]
  K1( 99,:) = [ -18,   0,   0,  18]
  K1(100,:) = [   0, -18,  18,   0]
  K1(101,:) = [ -54, -18, -18,   0]
  K1(102,:) = [ -18,   0,   0,  18]
  K1(103,:) = [ -18,   0, -54, -18]
  K1(104,:) = [   0,  18, -18,   0]
  K1(105,:) = [   0,  18, -18,   0]
  K1(106,:) = [  18,   0,   0, -18]
  K1(107,:) = [ -18,   0, -54, -18]
  K1(108,:) = [   0, -18, -18, -54]
  K1(109,:) = [   0, -18,  18,   0]
  K1(110,:) = [ -18, -54,   0, -18]
  K1(111,:) = [  18,   0,   0, -18]
  K1(112,:) = [   0, -18, -18, -54]
  K1(113,:) = [ 108,  36,  36,   0]
  K1(114,:) = [  36, 108,   0,  36]
  K1(115,:) = [  36,   0, 108,  36]
  K1(116,:) = [   0,  36,  36, 108]
  K1(117,:) = [   0,   0,   0,   0]
  K1(118,:) = [   0,   0,   0,   0]
  K1(119,:) = [   0,   0,   0,   0]
  K1(120,:) = [   0,   0,   0,   0]
  K1 = (1._/**/REALKIND / 3) * K1

  K2(1,:) = [ 12,  4,  4,  0]
  K2(2,:) = [  4, 12,  0,  4]
  K2(3,:) = [  4,  0, 12,  4]
  K2(4,:) = [  0,  4,  4, 12]

  KL(1,:) = [ 12,  4,  4,  0]
  KL(2,:) = [  4, 12,  0,  4]
  KL(3,:) = [  4,  0, 12,  4]
  KL(4,:) = [  0,  4,  4, 12]

  end subroutine colourmatrix_init
end module ol_colourmatrix_pplnttj_neexuxttxdg_1_/**/REALKIND



module ol_forced_parameters_pplnttj_neexuxttxdg_1_/**/REALKIND
  implicit none
  contains
  subroutine check_forced_parameters
    use ol_parameters_decl_/**/REALKIND
    use ol_loop_parameters_decl_/**/REALKIND
#ifndef PRECISION_dp
    use ol_loop_parameters_decl_/**/DREALKIND, only: LeadingColour, nc, nf, CKMORDER
#endif
    implicit none
    logical, save :: checks_not_written = .true.

    if (checks_not_written) then
    ! e.g.
    ! if (ME /= 0) write(*,101) 'ME = 0'
  if (ME /= 0) write(*,101) 'ME = 0'
  if (CKMORDER /= 0) write(*,101) 'CKMORDER = 0'
  if (nc /= 3) write(*,101) 'nc = 3'
  if (nf /= 6) write(*,101) 'nf = 6'
  if (MU /= 0) write(*,101) 'MU = 0'
  if (MD /= 0) write(*,101) 'MD = 0'
  if (MS /= 0) write(*,101) 'MS = 0'
  if (MC /= 0) write(*,101) 'MC = 0'
  if (LeadingColour /= 0) write(*,101) 'LeadingColour = 0'
  if (wMT /= 0) write(*,101) 'wMT = 0'
  if (wMT /= 0) write(*,101) 'wMT = 0'


    checks_not_written = .false.
    end if

    101 format('[OpenLoops] === WARNING ===',/,'[OpenLoops] code was generated with ',A,/,'[OpenLoops] ===============')
  end subroutine check_forced_parameters
end module ol_forced_parameters_pplnttj_neexuxttxdg_1_/**/REALKIND
! **********************************************************************
module ol_loop_storage_pplnttj_neexuxttxdg_1_/**/REALKIND
! **********************************************************************
  use KIND_TYPES, only: REALKIND, intkind1, intkind2  
  use ol_data_types_/**/REALKIND, only: wfun, Hpolcont
  
#ifdef PRECISION_dp
  integer(intkind1), save :: ntry = 1, ntryL = 1
  integer(intkind1), save :: p_switch = 0 ! switch for dp or qp. Used for memory allocation of the OL types 
  ! the following are flags for memory allocation of the hol coefficients in dp or qp 
  logical, save :: dp_not_alloc = .TRUE., qp_not_alloc = .TRUE.
  integer(intkind2), parameter :: nheltot = 128 ! number of helicity configurations
  integer(intkind2), save :: nhel = 128 ! number of non-vanishing helicity configurations (adapted at runtime)
  integer(intkind2), save :: Hel(128) ! physical helicity states
#endif

  complex(REALKIND), save :: den(185)

  ! external wave functions ex1(h1),... for h<n> helicities
  type(wfun) :: ex1(2), ex2(2), ex3(2), ex4(2), ex5(2), ex6(2), ex7(2)

  ! wf<h>(h,n) n wave functions with h helicity configurations
  type(wfun) :: wf4(4,29), wf8(8,43), wf16(16,59), wf32(32,26), wf128(128,96)

  ! diagram prefactors
  integer,           save :: fac_status_loop1 = -1, fac_status_loop2 = -1
  complex(REALKIND), save :: f(19), c(26)

  !below the colour vector for Born-Loop interference
  type(Hpolcont),   save :: M0_col1_helarray(4,128)

end module ol_loop_storage_pplnttj_neexuxttxdg_1_/**/REALKIND






! **********************************************************************
module ol_loop_pplnttj_neexuxttxdg_1_/**/REALKIND
! **********************************************************************
  use KIND_TYPES, only: REALKIND, DREALKIND, intkind1, intkind2  
  use ol_data_types_/**/REALKIND, only: wfun, Hpolcont
  use ol_loop_storage_pplnttj_neexuxttxdg_1_/**/REALKIND
  implicit none

!*********************************************************************************
  contains

! **********************************************************************
subroutine fac_init_loop()
! Writes diagram prefactors to 'f', rsp. 'c'
! **********************************************************************
  use ol_parameters_decl_/**/REALKIND
  use ol_loop_parameters_decl_/**/REALKIND
  use ol_init, only: set_parameter, tree_parameters_flush, parameters_flush
#ifndef PRECISION_dp
  use ol_loop_parameters_decl_/**/DREALKIND, only: SwF, SwB
!  use ol_loop_parameters_decl_/**/DREALKIND, only: DOI
#endif
  implicit none
  call set_parameter("ew_renorm", 0)
  if (parameters_status == 0) call tree_parameters_flush()
  if (loop_parameters_status == 0) call parameters_flush()
  fac_status_loop1 = parameters_status
  fac_status_loop2 = loop_parameters_status
  ! factors of the diagrams
    f( 1) = (CI*eQED**2*gQCD**3)/(2._/**/REALKIND*sw**2)
    f( 2) = (eQED**2*gQCD**3)/(sw**2*2._/**/REALKIND)
    f( 3) = (CI*countertermnorm*eQED**2*gQCD**5)/(2._/**/REALKIND*sw**2)
    f( 4) = (countertermnorm*eQED**2*gQCD**5)/(sw**2*2._/**/REALKIND)
    f( 5) = (CI*countertermnorm*ctGqq*eQED**2*gQCD**5)/(2._/**/REALKIND*sw**2)
    f( 6) = (countertermnorm*ctGqq*eQED**2*gQCD**5)/(sw**2*2._/**/REALKIND)
    f( 7) = (CI*countertermnorm*ctGtt*eQED**2*gQCD**5)/(2._/**/REALKIND*sw**2)
    f( 8) = (countertermnorm*ctGtt*eQED**2*gQCD**5)/(sw**2*2._/**/REALKIND)
    f( 9) = (CI*countertermnorm*ctVqq*eQED**2*gQCD**5)/(2._/**/REALKIND*sw**2)
    f(10) = (countertermnorm*ctVqq*eQED**2*gQCD**5)/(sw**2*2._/**/REALKIND)
    f(11) = (countertermnorm*ctVVV*eQED**2*gQCD**5)/(sw**2*2._/**/REALKIND)
    f(12) = (CI*eQED**2*gQCD**5*integralnorm*SwB)/(4._/**/REALKIND*sw**2)
    f(13) = (CI*eQED**2*gQCD**5*integralnorm*SwB)/(2._/**/REALKIND*sw**2)
    f(14) = (eQED**2*gQCD**5*integralnorm*SwB)/(sw**2*4._/**/REALKIND)
    f(15) = (eQED**2*gQCD**5*integralnorm*SwB)/(sw**2*2._/**/REALKIND)
    f(16) = (CI*eQED**2*gQCD**5*integralnorm*SwF)/(2._/**/REALKIND*sw**2)
    f(17) = (CI*eQED**2*gQCD**5*integralnorm*SwF)/sw**2
    f(18) = (eQED**2*gQCD**5*integralnorm*SwF)/(sw**2*2._/**/REALKIND)
    f(19) = (eQED**2*gQCD**5*integralnorm*SwF)/sw**2

  c = [ 27*CI*f(12), 54*CI*f(12), 3*CI*f(13), 9*CI*f(13), 24*CI*f(13), 27*CI*f(13), 54*CI*f(13), 18*f(14), 54*f(14), f(15) &
    , 3*f(15), 6*f(15), 8*f(15), 9*f(15), 10*f(15), 18*f(15), 21*f(15), 24*f(15), 27*f(15), 54*f(15), 9*CI*f(16), 9*CI*f(17) &
    , 3*f(18), 9*f(18), 3*f(19), 9*f(19) ]
  c = (1._/**/REALKIND / 36) * c
end subroutine fac_init_loop

subroutine denominators()
  use ol_parameters_decl_/**/REALKIND ! masses
  use ol_momenta_decl_/**/REALKIND, only: L
  implicit none
  ! propagators
  den(1) = 1 /((L(5,3) - MW2)+L(6,3))
  den(2) = 1 /((L(5,68))+L(6,68))
  den(3) = 1 /((L(5,24))+L(6,24))
  den(5) = 1 /((L(5,35))+L(6,35))
  den(9) = 1 /((L(5,56))+L(6,56))
  den(12) = 1 /((L(5,96))+L(6,96))
  den(14) = 1 /((L(5,7))+L(6,7))
  den(18) = 1 /((L(5,28))+L(6,28))
  den(21) = 1 /((L(5,88))+L(6,88))
  den(27) = 1 /((L(5,72) - MT2)+L(6,72))
  den(31) = 1 /((L(5,80) - MT2)+L(6,80))
  den(35) = 1 /((L(5,71))+L(6,71))
  den(38) = 1 /((L(5,92))+L(6,92))
  den(41) = 1 /((L(5,99))+L(6,99))
  den(44) = 1 /((L(5,120))+L(6,120))
  den(78) = 1 /((L(5,39))+L(6,39))
  den(112) = 1 /((L(5,31))+L(6,31))
  den(115) = 1 /((L(5,59))+L(6,59))
  den(122) = 1 /((L(5,103))+L(6,103))
  den(128) = 1 /((L(5,47) - MT2)+L(6,47))
  den(130) = 1 /((L(5,55) - MT2)+L(6,55))

  ! denominators
  den(4) = den(2)*den(3)
  den(6) = den(1)*den(5)
  den(7) = den(4)*den(6)
  den(8) = den(1)*den(2)
  den(10) = den(3)*den(9)
  den(11) = den(8)*den(10)
  den(13) = den(3)*den(12)
  den(15) = den(1)*den(14)
  den(16) = den(13)*den(15)
  den(17) = den(1)*den(12)
  den(19) = den(3)*den(18)
  den(20) = den(17)*den(19)
  den(22) = den(3)*den(21)
  den(23) = den(15)*den(22)
  den(24) = den(10)*den(15)
  den(25) = den(6)*den(19)
  den(26) = den(6)*den(22)
  den(28) = den(21)*den(27)
  den(29) = den(15)*den(28)
  den(30) = den(6)*den(28)
  den(32) = den(21)*den(31)
  den(33) = den(15)*den(32)
  den(34) = den(6)*den(32)
  den(36) = den(8)*den(35)
  den(37) = den(3)*den(36)
  den(39) = den(4)*den(38)
  den(40) = den(1)*den(39)
  den(42) = den(17)*den(41)
  den(43) = den(3)*den(42)
  den(45) = den(13)*den(44)
  den(46) = den(1)*den(45)
  den(47) = den(2)**2
  den(48) = den(3)*den(47)
  den(49) = den(6)*den(48)
  den(50) = den(1)*den(47)
  den(51) = den(10)*den(50)
  den(52) = den(3)**2
  den(53) = den(36)*den(52)
  den(54) = den(2)*den(52)
  den(55) = den(6)*den(54)
  den(56) = den(6)*den(39)
  den(57) = den(10)*den(36)
  den(58) = den(42)*den(52)
  den(59) = den(15)*den(45)
  den(60) = den(19)*den(42)
  den(61) = den(15)*den(52)
  den(62) = den(12)*den(61)
  den(63) = den(12)**2
  den(64) = den(15)*den(63)
  den(65) = den(3)*den(64)
  den(66) = den(1)*den(63)
  den(67) = den(19)*den(66)
  den(68) = den(18)*den(52)
  den(69) = den(6)*den(68)
  den(70) = den(22)*den(44)
  den(71) = den(15)*den(70)
  den(72) = den(22)*den(38)
  den(73) = den(6)*den(72)
  den(74) = den(10)*den(44)
  den(75) = den(15)*den(74)
  den(76) = den(6)*den(41)
  den(77) = den(19)*den(76)
  den(79) = den(6)*den(78)
  den(80) = den(22)*den(79)
  den(81) = den(9)*den(52)
  den(82) = den(15)*den(81)
  den(83) = den(15)*den(78)
  den(84) = den(52)*den(83)
  den(85) = den(52)*den(79)
  den(86) = den(22)*den(83)
  den(87) = den(15)*den(35)
  den(88) = den(10)*den(87)
  den(89) = den(19)*den(38)
  den(90) = den(6)*den(89)
  den(91) = den(28)*den(79)
  den(92) = den(28)*den(44)
  den(93) = den(15)*den(92)
  den(94) = den(28)*den(38)
  den(95) = den(6)*den(94)
  den(96) = den(27)**2
  den(97) = den(21)*den(96)
  den(98) = den(15)*den(97)
  den(99) = den(79)*den(96)
  den(100) = den(28)*den(83)
  den(101) = den(32)*den(79)
  den(102) = den(32)*den(44)
  den(103) = den(15)*den(102)
  den(104) = den(32)*den(38)
  den(105) = den(6)*den(104)
  den(106) = den(31)**2
  den(107) = den(21)*den(106)
  den(108) = den(15)*den(107)
  den(109) = den(79)*den(106)
  den(110) = den(32)*den(83)
  den(111) = den(3)*den(15)
  den(113) = den(111)*den(112)
  den(114) = den(3)*den(6)
  den(116) = den(114)*den(115)
  den(117) = den(1)*den(19)
  den(118) = den(112)*den(117)
  den(119) = den(1)*den(10)
  den(120) = den(115)*den(119)
  den(121) = den(2)*den(6)
  den(123) = den(121)*den(122)
  den(124) = den(36)*den(122)
  den(125) = den(12)*den(15)
  den(126) = den(122)*den(125)
  den(127) = den(42)*den(122)
  den(129) = den(83)*den(128)
  den(131) = den(83)*den(130)
  den(132) = den(83)*den(122)
  den(133) = den(87)*den(122)
  den(134) = den(79)*den(128)
  den(135) = den(79)*den(130)
  den(136) = den(79)*den(122)
  den(137) = den(76)*den(122)
  den(138) = den(1)*den(3)
  den(139) = den(2)*den(3)*den(6)
  den(140) = den(1)*den(2)*den(10)
  den(141) = den(1)*den(2)*den(3)
  den(142) = den(3)*den(12)*den(15)
  den(143) = den(1)*den(12)*den(19)
  den(144) = den(1)*den(3)*den(12)
  den(145) = den(3)*den(83)
  den(146) = den(3)*den(87)
  den(147) = den(3)*den(79)
  den(148) = den(3)*den(76)
  den(149) = den(1)*den(89)
  den(150) = den(1)*den(72)
  den(151) = den(1)*den(74)
  den(152) = den(1)*den(70)
  den(153) = den(1)*den(22)
  den(154) = den(27)*den(83)
  den(155) = den(15)*den(27)
  den(156) = den(27)*den(79)
  den(157) = den(6)*den(27)
  den(158) = den(1)*den(94)
  den(159) = den(1)*den(92)
  den(160) = den(1)*den(28)
  den(161) = den(1)*den(27)
  den(162) = den(31)*den(83)
  den(163) = den(15)*den(31)
  den(164) = den(31)*den(79)
  den(165) = den(6)*den(31)
  den(166) = den(1)*den(104)
  den(167) = den(1)*den(102)
  den(168) = den(1)*den(32)
  den(169) = den(1)*den(31)
  den(170) = den(3)*den(123)
  den(171) = den(2)*den(116)
  den(172) = den(3)*den(124)
  den(173) = den(2)*den(120)
  den(174) = den(12)*den(113)
  den(175) = den(3)*den(126)
  den(176) = den(12)*den(118)
  den(177) = den(3)*den(127)
  den(178) = den(3)*den(132)
  den(179) = den(3)*den(133)
  den(180) = den(3)*den(136)
  den(181) = den(3)*den(137)
  den(182) = den(27)*den(131)
  den(183) = den(27)*den(135)
  den(184) = den(31)*den(129)
  den(185) = den(31)*den(134)

end subroutine denominators

!
!
!
!
!
! **********************************************************************
#ifdef PRECISION_dp
subroutine amp2(P_scatt, M02, M2ct, M2colint, qp_kinematics)
#else
subroutine amp2(P_scatt, M02, M2ct, M2colint, qp_kinematics)
  use ol_loop_storage_pplnttj_neexuxttxdg_1_/**/DREALKIND, only: ntry, nhel, Hel
#endif
! P_scatt(0:3,Npart) = incoming external momenta
! M2  = helicity-summed squared matrix element for nu_e e+ anti-up top anti-top down glue -> 0
! **********************************************************************
  use ol_parameters_decl_/**/REALKIND !, only: ci, parameters_status, ZERO, scalefactor, >masses<
  use ol_parameters_init_/**/REALKIND, only: ensure_mp_init
  use ol_kinematics_/**/REALKIND, only: init_kinematics
  use ol_momenta_decl_/**/DREALKIND, only: momenta_nan_check
  use ol_data_types_/**/REALKIND
  use ol_h_helicity_bookkeeping_/**/REALKIND, only: &
    & helbookkeeping_wf, helsync, flip_phase
  use ol_helicity_init, only: helbookkeeping_flip, helsync_flip
  use ol_hel_propagators_/**/REALKIND
  use ol_hel_wavefunctions_/**/REALKIND
  use ol_wavefunctions_/**/REALKIND, only: wf_V_Std
  use ol_hel_vertices_/**/REALKIND
  use ol_hel_contractions_/**/REALKIND
  use ol_external_pplnttj_neexuxttxdg_1, only: external_perm_pplnttj_neexuxttxdg_1, &
    & external_perm_inv_pplnttj_neexuxttxdg_1, extcomb_perm_pplnttj_neexuxttxdg_1, &
    & average_factor_pplnttj_neexuxttxdg_1
  use ol_external_pplnttj_neexuxttxdg_1, only: H, hel_not_initialised, hel_init, POLSEL
  use ol_colourmatrix_pplnttj_neexuxttxdg_1_/**/REALKIND, only: colmat_not_initialised, colourmatrix_init
  use ol_forced_parameters_pplnttj_neexuxttxdg_1_/**/REALKIND, only: check_forced_parameters
  use ol_heltables_OLR_pplnttj_neexuxttxdg_1
  use ol_kinematics_/**/REALKIND, only: LC2Std_Rep_cmplx
  use ol_h_counterterms_/**/REALKIND
  use ol_loop_parameters_decl_/**/REALKIND ! counterterms
  use ol_loop_parameters_decl_/**/DREALKIND, only: IR_is_on
  use ol_init, only: set_parameter, parameters_flush
#ifdef PRECISION_dp
  use ol_kinematics_/**/QREALKIND, only: conv_mom_scatt2in_qp=>conv_mom_scatt2in, &
                                         internal_momenta_qp=>internal_momenta
  use ol_momenta_decl_/**/DREALKIND, only: L
  use ol_momenta_decl_/**/QREALKIND, only: L_qp=>L
#endif
  implicit none

  real(DREALKIND), intent(in)  :: P_scatt(0:3,7)
  real(REALKIND),  intent(out) :: M02, M2ct, M2colint(29)
  logical, intent(in) :: qp_kinematics

  integer           :: shift, k, r, m, n
  real(REALKIND)    :: P(0:3,7)
#ifdef PRECISION_dp
  real(QREALKIND)    :: P_qp(0:3,7)
#endif
  integer           :: extmasses2(7)
  real(REALKIND)    :: M2add, M2add_ct, M2add_colint(29)
  complex(REALKIND) :: M1(4), M2(4) 
  real(REALKIND)    :: P_scatt_intern(0:3,7)
  real(REALKIND), save :: scalebackfactor, old_scalefactor = 0
  integer(intkind1) :: nsync
  type(Hpolcont),   save :: M1helarray(4,128)
  type(Hpolcont) :: M1helarray_ct(4,128)

  type(Hpolcont) :: A(128,96)

  !Aj are not used at the moment
  !complex(REALKIND) :: Aj(96)

  complex(REALKIND) :: omega(2) ! phases for helicity correlations

  call set_parameter("ew_renorm", 0)
  call parameters_flush()
  call ensure_mp_init()

  if (colmat_not_initialised) call colourmatrix_init()

  if (fac_status_loop1 /= parameters_status .or. fac_status_loop2 /= loop_parameters_status) then
    ! Note: if fac_init would only be called when parameters changed which are relevant for the factors,
    ! a different 'status' would have to be used, because forced_parameters should be called after every parameter change.
    call check_forced_parameters()
    call fac_init_loop()
  end if

  if (momenta_nan_check(P_scatt) /= 0) then
    M02 = 0
    return
  end if

  extmasses2 = [ 0, 0, 0, nMT, nMT, 0, 0 ]
  ! Convert 2 -> n-2 PS-point to n -> 0 (so that P(1) + ... + P(n) = 0) and compute
  ! internal-propagator momenta in light-cone representation
  call init_kinematics(P_scatt, extmasses2, P, external_perm_inv_pplnttj_neexuxttxdg_1, 7, qp_kinematics)

  ! denominators
  call denominators()

   if (heltables_not_init) call init_heltables()

  ! external WFs
  ! Here the external wavefunctions are initialiased
  call pol_wf_Q(P(:,1), rZERO, H1, ex1, POLSEL(1),1)
  call pol_wf_A(P(:,2), rZERO, H2, ex2, POLSEL(2),2)
  call pol_wf_A(P(:,3), rZERO, H3, ex3, POLSEL(3),3)
  call pol_wf_Q(P(:,4), rMT, H4, ex4, POLSEL(4),4)
  call pol_wf_A(P(:,5), rMT, H5, ex5, POLSEL(5),5)
  call pol_wf_Q(P(:,6), rZERO, H6, ex6, POLSEL(6),6)
  call pol_wf_V(P(:,7), rZERO, H7, ex7, POLSEL(7),7)



  ! internal WFs
  ! e.g. call vert_VQ_A(ntry, ex3, ex1, wf1, n1, t1) ...
  call vert_QA_W(ntry, ex1(:), ex2(:), wf4(:,1), n3(:,1), t3x4(:,:,1))
  call vert_AV_Q(ntry, ex3(:), ex7(:), wf4(:,2), n3(:,2), t3x4(:,:,2))
  call vert_QA_V(ntry, ex4(:), ex5(:), wf4(:,3), n3(:,3), t3x4(:,:,3))
  call prop_W_W(ntry, wf4(:,1), 3, MW, 1_intkind1, wf4(:,4), n2(1))
  call prop_A_Q(ntry, wf4(:,2), 68, ZERO, 0_intkind1, wf4(:,5), n2(2))
  call vert_WQ_A(ntry, wf4(:,4), ex6(:), wf8(:,1), n3(:,4), t3x8(:,:,1))
  call vert_AV_Q(ntry, wf4(:,5), wf4(:,3), wf16(:,1), n3(:,5), t3x16(:,:,1))
  call prop_Q_A(ntry, wf8(:,1), 35, ZERO, 0_intkind1, wf8(:,2), n2(3))
  call vert_VQ_A(ntry, wf4(:,3), ex6(:), wf8(:,3), n3(:,6), t3x8(:,:,2))
  call vert_AW_Q(ntry, wf4(:,5), wf4(:,4), wf16(:,2), n3(:,7), t3x16(:,:,2))
  call prop_Q_A(ntry, wf8(:,3), 56, ZERO, 0_intkind1, wf8(:,4), n2(4))
  call vert_VQ_A(ntry, ex7(:), ex6(:), wf4(:,6), n3(:,8), t3x4(:,:,4))
  call prop_Q_A(ntry, wf4(:,6), 96, ZERO, 0_intkind1, wf4(:,7), n2(5))
  call vert_AW_Q(ntry, ex3(:), wf4(:,4), wf8(:,5), n3(:,9), t3x8(:,:,3))
  call vert_VQ_A(ntry, wf4(:,3), wf4(:,7), wf16(:,3), n3(:,10), t3x16(:,:,3))
  call prop_A_Q(ntry, wf8(:,5), 7, ZERO, 0_intkind1, wf8(:,6), n2(6))
  call vert_AV_Q(ntry, ex3(:), wf4(:,3), wf8(:,7), n3(:,11), t3x8(:,:,4))
  call vert_WQ_A(ntry, wf4(:,4), wf4(:,7), wf16(:,4), n3(:,12), t3x16(:,:,4))
  call prop_A_Q(ntry, wf8(:,7), 28, ZERO, 0_intkind1, wf8(:,8), n2(7))
  call vert_UV_W(ntry, wf4(:,3), 24, ex7(:), 64, wf8(:,9), n3(:,13), t3x8(:,:,5))
  call vert_QA_V(ntry, ex6(:), wf8(:,6), wf16(:,5), n3(:,14), t3x16(:,:,5))
  call vert_AV_Q(ntry, wf8(:,6), ex7(:), wf16(:,6), n3(:,15), t3x16(:,:,6))
  call vert_AV_Q(ntry, wf8(:,8), ex7(:), wf16(:,7), n3(:,16), t3x16(:,:,7))
  call vert_QA_V(ntry, wf8(:,2), ex3(:), wf16(:,8), n3(:,17), t3x16(:,:,8))
  call vert_VQ_A(ntry, ex7(:), ex4(:), wf4(:,8), n3(:,18), t3x4(:,:,5))
  call prop_Q_A(ntry, wf4(:,8), 72, MT, 1_intkind1, wf4(:,9), n2(8))
  call vert_QA_V(ntry, wf4(:,9), ex5(:), wf8(:,10), n3(:,19), t3x8(:,:,6))
  call vert_AV_Q(ntry, ex3(:), wf8(:,10), wf16(:,9), n3(:,20), t3x16(:,:,9))
  call vert_AV_Q(ntry, ex5(:), ex7(:), wf4(:,10), n3(:,21), t3x4(:,:,6))
  call prop_A_Q(ntry, wf4(:,10), 80, MT, 1_intkind1, wf4(:,11), n2(9))
  call vert_QA_V(ntry, ex4(:), wf4(:,11), wf8(:,11), n3(:,22), t3x8(:,:,7))
  call vert_AV_Q(ntry, ex3(:), wf8(:,11), wf16(:,10), n3(:,23), t3x16(:,:,10))
  call counter_AV_Q(ntry, wf4(:,5), wf4(:,3), wf16(:,11), n3(:,24), t3x16(:,:,11))
  call counter_AW_Q(ntry, wf4(:,5), wf4(:,4), wf16(:,12), n3(:,25), t3x16(:,:,12))
  call counter_VQ_A(ntry, wf4(:,3), wf4(:,7), wf16(:,13), n3(:,26), t3x16(:,:,13))
  call counter_WQ_A(ntry, wf4(:,4), wf4(:,7), wf16(:,14), n3(:,27), t3x16(:,:,14))
  call counter_UV_W(ntry, wf4(:,3), 24, ex7(:), 64, wf8(:,12), n3(:,28), t3x8(:,:,8))
  call counter_AV_Q(ntry, wf8(:,6), ex7(:), wf16(:,15), n3(:,29), t3x16(:,:,15))
  call counter_AV_Q(ntry, wf8(:,8), ex7(:), wf16(:,16), n3(:,30), t3x16(:,:,16))
  call counter_VQ_A(ntry, wf4(:,3), ex6(:), wf8(:,13), n3(:,31), t3x8(:,:,9))
  call prop_A_Q(ntry, wf16(:,2), 71, ZERO, 0_intkind1, wf16(:,17), n2(10))
  call counter_WQ_A(ntry, wf4(:,4), ex6(:), wf8(:,14), n3(:,32), t3x8(:,:,10))
  call prop_A_Q(ntry, wf16(:,1), 92, ZERO, 0_intkind1, wf16(:,18), n2(11))
  call prop_Q_A(ntry, wf8(:,13), 56, ZERO, 0_intkind1, wf8(:,15), n2(12))
  call counter_QA_V(ntry, ex6(:), wf8(:,6), wf16(:,19), n3(:,33), t3x16(:,:,17))
  call prop_Q_A(ntry, wf8(:,14), 35, ZERO, 0_intkind1, wf8(:,16), n2(13))
  call vert_QA_V(ntry, wf8(:,16), ex3(:), wf16(:,20), n3(:,34), t3x16(:,:,18))
  call counter_VQ_A(ntry, ex7(:), ex6(:), wf4(:,12), n3(:,35), t3x4(:,:,7))
  call prop_Q_A(ntry, wf4(:,12), 96, ZERO, 0_intkind1, wf4(:,13), n2(14))
  call vert_VQ_A(ntry, wf4(:,3), wf4(:,13), wf16(:,21), n3(:,36), t3x16(:,:,19))
  call vert_WQ_A(ntry, wf4(:,4), wf4(:,13), wf16(:,22), n3(:,37), t3x16(:,:,20))
  call counter_QA_V(ntry, wf4(:,9), ex5(:), wf8(:,17), n3(:,38), t3x8(:,:,11))
  call vert_AV_Q(ntry, ex3(:), wf8(:,17), wf16(:,23), n3(:,39), t3x16(:,:,21))
  call counter_AV_Q(ntry, ex5(:), ex7(:), wf4(:,14), n3(:,40), t3x4(:,:,8))
  call prop_A_Q(ntry, wf4(:,14), 80, MT, 1_intkind1, wf4(:,15), n2(15))
  call vert_QA_V(ntry, ex4(:), wf4(:,15), wf8(:,18), n3(:,41), t3x8(:,:,12))
  call vert_AV_Q(ntry, ex3(:), wf8(:,18), wf16(:,24), n3(:,42), t3x16(:,:,22))
  call counter_QA_V(ntry, ex4(:), wf4(:,11), wf8(:,19), n3(:,43), t3x8(:,:,13))
  call vert_AV_Q(ntry, ex3(:), wf8(:,19), wf16(:,25), n3(:,44), t3x16(:,:,23))
  call counter_VQ_A(ntry, ex7(:), ex4(:), wf4(:,16), n3(:,45), t3x4(:,:,9))
  call prop_Q_A(ntry, wf4(:,16), 72, MT, 1_intkind1, wf4(:,17), n2(16))
  call vert_QA_V(ntry, wf4(:,17), ex5(:), wf8(:,20), n3(:,46), t3x8(:,:,14))
  call vert_AV_Q(ntry, ex3(:), wf8(:,20), wf16(:,26), n3(:,47), t3x16(:,:,24))
  call counter_QA_V(ntry, ex4(:), ex5(:), wf4(:,18), n3(:,48), t3x4(:,:,10))
  call vert_AV_Q(ntry, wf4(:,5), wf4(:,18), wf16(:,27), n3(:,49), t3x16(:,:,25))
  call vert_VQ_A(ntry, wf4(:,18), ex6(:), wf8(:,21), n3(:,50), t3x8(:,:,15))
  call prop_Q_A(ntry, wf8(:,21), 56, ZERO, 0_intkind1, wf8(:,22), n2(17))
  call vert_VQ_A(ntry, wf4(:,18), wf4(:,7), wf16(:,28), n3(:,51), t3x16(:,:,26))
  call vert_AV_Q(ntry, ex3(:), wf4(:,18), wf8(:,23), n3(:,52), t3x8(:,:,16))
  call prop_A_Q(ntry, wf8(:,23), 28, ZERO, 0_intkind1, wf8(:,24), n2(18))
  call vert_UV_W(ntry, wf4(:,18), 24, ex7(:), 64, wf8(:,25), n3(:,53), t3x8(:,:,17))
  call vert_AV_Q(ntry, wf8(:,24), ex7(:), wf16(:,29), n3(:,54), t3x16(:,:,27))
  call counter_AV_Q(ntry, ex3(:), wf4(:,3), wf8(:,26), n3(:,55), t3x8(:,:,18))
  call prop_Q_A(ntry, wf16(:,4), 99, ZERO, 0_intkind1, wf16(:,30), n2(19))
  call counter_AW_Q(ntry, ex3(:), wf4(:,4), wf8(:,27), n3(:,56), t3x8(:,:,19))
  call prop_Q_A(ntry, wf16(:,3), 120, ZERO, 0_intkind1, wf16(:,31), n2(20))
  call prop_A_Q(ntry, wf8(:,26), 28, ZERO, 0_intkind1, wf8(:,28), n2(21))
  call vert_AV_Q(ntry, wf8(:,28), ex7(:), wf16(:,32), n3(:,57), t3x16(:,:,28))
  call counter_QA_V(ntry, wf8(:,2), ex3(:), wf16(:,33), n3(:,58), t3x16(:,:,29))
  call prop_A_Q(ntry, wf8(:,27), 7, ZERO, 0_intkind1, wf8(:,29), n2(22))
  call vert_QA_V(ntry, ex6(:), wf8(:,29), wf16(:,34), n3(:,59), t3x16(:,:,30))
  call vert_AV_Q(ntry, wf8(:,29), ex7(:), wf16(:,35), n3(:,60), t3x16(:,:,31))
  call counter_AV_Q(ntry, ex3(:), ex7(:), wf4(:,19), n3(:,61), t3x4(:,:,11))
  call prop_A_Q(ntry, wf4(:,19), 68, ZERO, 0_intkind1, wf4(:,20), n2(23))
  call vert_AV_Q(ntry, wf4(:,20), wf4(:,3), wf16(:,36), n3(:,62), t3x16(:,:,32))
  call vert_AW_Q(ntry, wf4(:,20), wf4(:,4), wf16(:,37), n3(:,63), t3x16(:,:,33))
  call counter_AV_Q(ntry, ex3(:), wf8(:,10), wf16(:,38), n3(:,64), t3x16(:,:,34))
  call counter_AV_Q(ntry, ex3(:), wf8(:,11), wf16(:,39), n3(:,65), t3x16(:,:,35))
  call counter_A_Q(ctqq,2,ntry, wf4(:,5), 68, wf4(:,21), n2(24))
  call prop_A_Q(ntry, wf4(:,21), 68, ZERO, 0_intkind1, wf4(:,22), n2(25))
  call vert_AV_Q(ntry, wf4(:,22), wf4(:,3), wf16(:,40), n3(:,66), t3x16(:,:,36))
  call vert_AW_Q(ntry, wf4(:,22), wf4(:,4), wf16(:,41), n3(:,67), t3x16(:,:,37))
  call counter_V_V(ctGG,21,ntry, wf4(:,3), 24, wf4(:,23), n2(26))
  call vert_VQ_A(ntry, wf4(:,23), ex6(:), wf8(:,30), n3(:,68), t3x8(:,:,20))
  call vert_AV_Q(ntry, wf4(:,5), wf4(:,23), wf16(:,42), n3(:,69), t3x16(:,:,38))
  call counter_Q_A(ctqq,2,ntry, wf8(:,2), 35, wf8(:,31), n2(27))
  call counter_Q_A(ctqq,1,ntry, wf8(:,4), 56, wf8(:,32), n2(28))
  call vert_AV_Q(ntry, ex3(:), wf4(:,23), wf8(:,33), n3(:,70), t3x8(:,:,21))
  call counter_A_Q(ctqq,1,ntry, wf8(:,6), 7, wf8(:,34), n2(29))
  call counter_A_Q(ctqq,2,ntry, wf8(:,8), 28, wf8(:,35), n2(30))
  call vert_AV_Q(ntry, wf8(:,6), wf4(:,23), wf32(:,1), n3(:,71), t3x32(:,:,1))
  call counter_Q_A(ctqq,1,ntry, wf4(:,7), 96, wf4(:,24), n2(31))
  call prop_Q_A(ntry, wf4(:,24), 96, ZERO, 0_intkind1, wf4(:,25), n2(32))
  call vert_QA_V(ntry, wf4(:,25), wf8(:,6), wf32(:,2), n3(:,72), t3x32(:,:,2))
  call vert_WQ_A(ntry, wf4(:,4), wf4(:,25), wf16(:,43), n3(:,73), t3x16(:,:,39))
  call vert_VQ_A(ntry, ex7(:), wf8(:,2), wf16(:,44), n3(:,74), t3x16(:,:,40))
  call prop_A_Q(ntry, wf8(:,33), 28, ZERO, 0_intkind1, wf8(:,36), n2(33))
  call vert_VQ_A(ntry, wf8(:,9), ex6(:), wf16(:,45), n3(:,75), t3x16(:,:,41))
  call prop_Q_A(ntry, wf16(:,45), 120, ZERO, 0_intkind1, wf16(:,46), n2(34))
  call vert_AV_Q(ntry, ex3(:), wf8(:,9), wf16(:,47), n3(:,76), t3x16(:,:,42))
  call prop_A_Q(ntry, wf16(:,47), 92, ZERO, 0_intkind1, wf16(:,48), n2(35))
  call vert_VQ_A(ntry, ex7(:), wf8(:,4), wf16(:,49), n3(:,77), t3x16(:,:,43))
  call prop_Q_A(ntry, wf16(:,49), 120, ZERO, 0_intkind1, wf16(:,50), n2(36))
  call prop_Q_A(ntry, wf16(:,44), 99, ZERO, 0_intkind1, wf16(:,51), n2(37))
  call counter_V_V(ctGG,21,ntry, wf8(:,9), 88, wf8(:,37), n2(38))
  call prop_Q_A(ntry, wf8(:,30), 56, ZERO, 0_intkind1, wf8(:,38), n2(39))
  call vert_UV_W(ntry, wf4(:,23), 24, ex7(:), 64, wf8(:,39), n3(:,78), t3x8(:,:,22))
  call prop_A_Q(ntry, wf16(:,6), 71, ZERO, 0_intkind1, wf16(:,52), n2(40))
  call prop_A_Q(ntry, wf16(:,7), 92, ZERO, 0_intkind1, wf16(:,53), n2(41))
  call counter_V_V(ctGG,21,ntry, wf8(:,10), 88, wf8(:,40), n2(42))
  call vert_VQ_A(ntry, wf8(:,10), ex6(:), wf16(:,54), n3(:,79), t3x16(:,:,44))
  call prop_Q_A(ntry, wf16(:,54), 120, ZERO, 0_intkind1, wf16(:,55), n2(43))
  call prop_A_Q(ntry, wf16(:,9), 92, ZERO, 0_intkind1, wf16(:,56), n2(44))
  call counter_Q_A(cttt,6,ntry, wf4(:,9), 72, wf4(:,26), n2(45))
  call prop_Q_A(ntry, wf4(:,26), 72, MT, 1_intkind1, wf4(:,27), n2(46))
  call vert_QA_V(ntry, wf4(:,27), ex5(:), wf8(:,41), n3(:,80), t3x8(:,:,23))
  call counter_V_V(ctGG,21,ntry, wf8(:,11), 88, wf8(:,42), n2(47))
  call vert_VQ_A(ntry, wf8(:,11), ex6(:), wf16(:,57), n3(:,81), t3x16(:,:,45))
  call prop_Q_A(ntry, wf16(:,57), 120, ZERO, 0_intkind1, wf16(:,58), n2(48))
  call prop_A_Q(ntry, wf16(:,10), 92, ZERO, 0_intkind1, wf16(:,59), n2(49))
  call counter_A_Q(cttt,6,ntry, wf4(:,11), 80, wf4(:,28), n2(50))
  call prop_A_Q(ntry, wf4(:,28), 80, MT, 1_intkind1, wf4(:,29), n2(51))
  call vert_QA_V(ntry, ex4(:), wf4(:,29), wf8(:,43), n3(:,82), t3x8(:,:,24))
  call vert_AV_Q(ntry, wf8(:,6), wf4(:,3), wf32(:,3), n3(:,83), t3x32(:,:,3))
  call prop_A_Q(ntry, wf32(:,3), 31, ZERO, 0_intkind1, wf32(:,4), n2(52))
  call vert_VQ_A(ntry, wf4(:,3), wf8(:,2), wf32(:,5), n3(:,84), t3x32(:,:,4))
  call prop_Q_A(ntry, wf32(:,5), 59, ZERO, 0_intkind1, wf32(:,6), n2(53))
  call vert_AW_Q(ntry, wf8(:,8), wf4(:,4), wf32(:,7), n3(:,85), t3x32(:,:,5))
  call prop_A_Q(ntry, wf32(:,7), 31, ZERO, 0_intkind1, wf32(:,8), n2(54))
  call vert_WQ_A(ntry, wf4(:,4), wf8(:,4), wf32(:,9), n3(:,86), t3x32(:,:,6))
  call prop_Q_A(ntry, wf32(:,9), 59, ZERO, 0_intkind1, wf32(:,10), n2(55))
  call vert_QA_V(ntry, wf8(:,2), wf4(:,5), wf32(:,11), n3(:,87), t3x32(:,:,7))
  call vert_QA_V(ntry, ex6(:), wf16(:,17), wf32(:,12), n3(:,88), t3x32(:,:,8))
  call vert_QA_V(ntry, wf4(:,7), wf8(:,6), wf32(:,13), n3(:,89), t3x32(:,:,9))
  call vert_QA_V(ntry, wf16(:,30), ex3(:), wf32(:,14), n3(:,90), t3x32(:,:,10))
  call vert_VQ_A(ntry, wf16(:,5), ex4(:), wf32(:,15), n3(:,91), t3x32(:,:,11))
  call prop_Q_A(ntry, wf32(:,15), 47, MT, 1_intkind1, wf32(:,16), n2(56))
  call vert_AV_Q(ntry, ex5(:), wf16(:,5), wf32(:,17), n3(:,92), t3x32(:,:,12))
  call prop_A_Q(ntry, wf32(:,17), 55, MT, 1_intkind1, wf32(:,18), n2(57))
  call vert_UV_W(ntry, wf16(:,5), 39, ex7(:), 64, wf32(:,19), n3(:,93), t3x32(:,:,13))
  call vert_QA_V(ntry, ex6(:), wf16(:,52), wf32(:,20), n3(:,94), t3x32(:,:,14))
  call vert_VQ_A(ntry, wf16(:,8), ex4(:), wf32(:,21), n3(:,95), t3x32(:,:,15))
  call prop_Q_A(ntry, wf32(:,21), 47, MT, 1_intkind1, wf32(:,22), n2(58))
  call vert_AV_Q(ntry, ex5(:), wf16(:,8), wf32(:,23), n3(:,96), t3x32(:,:,16))
  call prop_A_Q(ntry, wf32(:,23), 55, MT, 1_intkind1, wf32(:,24), n2(59))
  call vert_UV_W(ntry, wf16(:,8), 39, ex7(:), 64, wf32(:,25), n3(:,97), t3x32(:,:,17))
  call vert_QA_V(ntry, wf16(:,51), ex3(:), wf32(:,26), n3(:,98), t3x32(:,:,18))


  call init_hybrid_exwf(ex1)
  call init_hybrid_exwf(ex2)
  call init_hybrid_exwf(ex3)
  call init_hybrid_exwf(ex4)
  call init_hybrid_exwf(ex5)
  call init_hybrid_exwf(ex6)
  call init_hybrid_exwf(ex7)
  call init_hybrid_wf(wf4)
  call init_hybrid_wf(wf8)
  call init_hybrid_wf(wf16)
  call init_hybrid_wf(wf32)


  if (ntry==1) then
    call physical_helicities()
  end if

  ! computation of the colour-stripped amplitudes
  do nsync = ntry+ntry-1, ntry+1  !  nsync = 1,2  for 1st point and nsync = 3 later
    call diagrams()
    if (nsync == 1) call helsync(nsync, A, nhel, Hel)
  end do

  ! In the following loop the coefficients \Gamma_{i} of the expansion in
  ! the colour basis are computed for every helicity state and stored in M1helarray.
  ! Also the colour vector for the Born-loop interference is computed and saved in
  ! M0_col1_helarray
  do k = 1, nhel
    call colourvectors(A, k, M1helarray(:,k),M1helarray_ct(:,k))
    call colborninterf(M1helarray(:,k), M0_col1_helarray(:,k))
  end do
  M1helarray(:,nhel+1:)%j = 0
  M0_col1_helarray(:,nhel+1:)%hf = -1_intkind2
  M0_col1_helarray(:,nhel+1:)%j = 0

  M2add = 0
  M2add_ct = 0
  M2add_colint = 0

  M02 = 0
  M2ct = 0
  M2colint = 0
  
    do k = 1, nhel
      call colint(M1helarray(:,k)%j, M2add)
      call colint_ct(M1helarray(:,k)%j, M1helarray_ct(:,k)%j, M2add_ct)
      if (IR_is_on > 0) then
	call colint_IR(M1helarray(:,k)%j, M2add_colint)
      end if
      !summation over helicity configurations
      M02 = M02 + M2add
      M2ct = M2ct + M2add_ct
      M2colint = M2colint + M2add_colint
    end do



  contains

subroutine physical_helicities()
  implicit none 

integer :: i1,i2,i3,i4,i5,i6,i7
integer :: n

n=0

do i7= 1, 2
do i6= 1, 2
do i5= 1, 2
do i4= 1, 2
do i3= 1, 2
do i2= 1, 2
do i1= 1, 2
n = n + 1
 if((ex1(i1)%hf==-1_intkind2) .OR. (ex2(i2)%hf==-1_intkind2) .OR. (ex3(i3)%hf==-1_intkind2) .OR. (ex4(i4)%hf==-1_intkind2)  &
    .OR. (ex5(i5)%hf==-1_intkind2) .OR. (ex6(i6)%hf==-1_intkind2) .OR. (ex7(i7)%hf==-1_intkind2)) then
  Hel(n) = -1_intkind2
 else
  Hel(n) = ex1(i1)%hf + ex2(i2)%hf + ex3(i3)%hf + ex4(i4)%hf + ex5(i5)%hf + ex6(i6)%hf + ex7(i7)%hf
 end if
end do
end do
end do
end do
end do
end do
end do

end subroutine physical_helicities

subroutine diagrams()
  implicit none
  integer :: h
  ! e.g. call cont_VV(nsync, wf3, wf6, A(:,1), n64, t64, nhel, den(5)) ...

    call Hcont_QA(nsync, wf16(:,1), wf8(:,2), A(:,1), n3(:,99), t3x128(:,:,1), nhel, den(7))
    call Hcont_QA(nsync, wf16(:,2), wf8(:,4), A(:,2), n3(:,100), t3x128(:,:,2), nhel, den(11))
    call Hcont_QA(nsync, wf16(:,3), wf8(:,6), A(:,3), n3(:,101), t3x128(:,:,3), nhel, den(16))
    call Hcont_QA(nsync, wf16(:,4), wf8(:,8), A(:,4), n3(:,102), t3x128(:,:,4), nhel, den(20))
    call Hcont_VV(nsync, wf8(:,9), wf16(:,5), A(:,5), n3(:,103), t3x128(:,:,5), nhel, den(23))
    call Hcont_QA(nsync, wf8(:,4), wf16(:,6), A(:,6), n3(:,104), t3x128(:,:,6), nhel, den(24))
    call Hcont_QA(nsync, wf8(:,2), wf16(:,7), A(:,7), n3(:,105), t3x128(:,:,7), nhel, den(25))
    call Hcont_VV(nsync, wf8(:,9), wf16(:,8), A(:,8), n3(:,106), t3x128(:,:,8), nhel, den(26))
    call Hcont_VV(nsync, wf16(:,5), wf8(:,10), A(:,9), n3(:,107), t3x128(:,:,9), nhel, den(29))
    call Hcont_QA(nsync, wf8(:,2), wf16(:,9), A(:,10), n3(:,108), t3x128(:,:,10), nhel, den(30))
    call Hcont_VV(nsync, wf16(:,5), wf8(:,11), A(:,11), n3(:,109), t3x128(:,:,11), nhel, den(33))
    call Hcont_QA(nsync, wf8(:,2), wf16(:,10), A(:,12), n3(:,110), t3x128(:,:,12), nhel, den(34))

    call Hcont_QA(nsync, wf8(:,2), wf16(:,11), A(:,13), n3(:,111), t3x128(:,:,13), nhel, den(7))
    call Hcont_QA(nsync, wf8(:,4), wf16(:,12), A(:,14), n3(:,112), t3x128(:,:,14), nhel, den(11))
    call Hcont_QA(nsync, wf8(:,6), wf16(:,13), A(:,15), n3(:,113), t3x128(:,:,15), nhel, den(16))
    call Hcont_QA(nsync, wf8(:,8), wf16(:,14), A(:,16), n3(:,114), t3x128(:,:,16), nhel, den(20))
    call Hcont_VV(nsync, wf16(:,5), wf8(:,12), A(:,17), n3(:,115), t3x128(:,:,17), nhel, den(23))
    call Hcont_QA(nsync, wf8(:,4), wf16(:,15), A(:,18), n3(:,116), t3x128(:,:,18), nhel, den(24))
    call Hcont_QA(nsync, wf8(:,2), wf16(:,16), A(:,19), n3(:,117), t3x128(:,:,19), nhel, den(25))
    call Hcont_VV(nsync, wf16(:,8), wf8(:,12), A(:,20), n3(:,118), t3x128(:,:,20), nhel, den(26))
    call Hcont_QA(nsync, wf8(:,13), wf16(:,17), A(:,21), n3(:,119), t3x128(:,:,21), nhel, den(37))
    call Hcont_QA(nsync, wf8(:,14), wf16(:,18), A(:,22), n3(:,120), t3x128(:,:,22), nhel, den(40))
    call Hcont_QA(nsync, wf16(:,6), wf8(:,15), A(:,23), n3(:,121), t3x128(:,:,23), nhel, den(24))
    call Hcont_VV(nsync, wf8(:,9), wf16(:,19), A(:,24), n3(:,122), t3x128(:,:,24), nhel, den(23))
    call Hcont_QA(nsync, wf16(:,7), wf8(:,16), A(:,25), n3(:,123), t3x128(:,:,25), nhel, den(25))
    call Hcont_VV(nsync, wf8(:,9), wf16(:,20), A(:,26), n3(:,124), t3x128(:,:,26), nhel, den(26))
    call Hcont_QA(nsync, wf8(:,6), wf16(:,21), A(:,27), n3(:,125), t3x128(:,:,27), nhel, den(16))
    call Hcont_QA(nsync, wf8(:,8), wf16(:,22), A(:,28), n3(:,126), t3x128(:,:,28), nhel, den(20))
    call Hcont_VV(nsync, wf8(:,10), wf16(:,19), A(:,29), n3(:,127), t3x128(:,:,29), nhel, den(29))
    call Hcont_QA(nsync, wf16(:,9), wf8(:,16), A(:,30), n3(:,128), t3x128(:,:,30), nhel, den(30))
    call Hcont_VV(nsync, wf8(:,11), wf16(:,19), A(:,31), n3(:,129), t3x128(:,:,31), nhel, den(33))
    call Hcont_QA(nsync, wf16(:,10), wf8(:,16), A(:,32), n3(:,130), t3x128(:,:,32), nhel, den(34))
    call Hcont_VV(nsync, wf16(:,5), wf8(:,17), A(:,33), n3(:,131), t3x128(:,:,33), nhel, den(29))
    call Hcont_QA(nsync, wf8(:,2), wf16(:,23), A(:,34), n3(:,132), t3x128(:,:,34), nhel, den(30))
    call Hcont_VV(nsync, wf16(:,5), wf8(:,18), A(:,35), n3(:,133), t3x128(:,:,35), nhel, den(33))
    call Hcont_QA(nsync, wf8(:,2), wf16(:,24), A(:,36), n3(:,134), t3x128(:,:,36), nhel, den(34))
    call Hcont_VV(nsync, wf16(:,5), wf8(:,19), A(:,37), n3(:,135), t3x128(:,:,37), nhel, den(33))
    call Hcont_QA(nsync, wf8(:,2), wf16(:,25), A(:,38), n3(:,136), t3x128(:,:,38), nhel, den(34))
    call Hcont_VV(nsync, wf16(:,5), wf8(:,20), A(:,39), n3(:,137), t3x128(:,:,39), nhel, den(29))
    call Hcont_QA(nsync, wf8(:,2), wf16(:,26), A(:,40), n3(:,138), t3x128(:,:,40), nhel, den(30))
    call Hcont_QA(nsync, wf8(:,2), wf16(:,27), A(:,41), n3(:,139), t3x128(:,:,41), nhel, den(7))
    call Hcont_QA(nsync, wf16(:,2), wf8(:,22), A(:,42), n3(:,140), t3x128(:,:,42), nhel, den(11))
    call Hcont_QA(nsync, wf8(:,6), wf16(:,28), A(:,43), n3(:,141), t3x128(:,:,43), nhel, den(16))
    call Hcont_QA(nsync, wf16(:,4), wf8(:,24), A(:,44), n3(:,142), t3x128(:,:,44), nhel, den(20))
    call Hcont_VV(nsync, wf16(:,5), wf8(:,25), A(:,45), n3(:,143), t3x128(:,:,45), nhel, den(23))
    call Hcont_QA(nsync, wf16(:,6), wf8(:,22), A(:,46), n3(:,144), t3x128(:,:,46), nhel, den(24))
    call Hcont_VV(nsync, wf16(:,8), wf8(:,25), A(:,47), n3(:,145), t3x128(:,:,47), nhel, den(26))
    call Hcont_QA(nsync, wf8(:,2), wf16(:,29), A(:,48), n3(:,146), t3x128(:,:,48), nhel, den(25))
    call Hcont_QA(nsync, wf8(:,26), wf16(:,30), A(:,49), n3(:,147), t3x128(:,:,49), nhel, den(43))
    call Hcont_QA(nsync, wf8(:,27), wf16(:,31), A(:,50), n3(:,148), t3x128(:,:,50), nhel, den(46))
    call Hcont_QA(nsync, wf8(:,2), wf16(:,32), A(:,51), n3(:,149), t3x128(:,:,51), nhel, den(25))
    call Hcont_VV(nsync, wf8(:,9), wf16(:,33), A(:,52), n3(:,150), t3x128(:,:,52), nhel, den(26))
    call Hcont_VV(nsync, wf8(:,9), wf16(:,34), A(:,53), n3(:,151), t3x128(:,:,53), nhel, den(23))
    call Hcont_QA(nsync, wf8(:,4), wf16(:,35), A(:,54), n3(:,152), t3x128(:,:,54), nhel, den(24))
    call Hcont_QA(nsync, wf8(:,2), wf16(:,36), A(:,55), n3(:,153), t3x128(:,:,55), nhel, den(7))
    call Hcont_QA(nsync, wf8(:,4), wf16(:,37), A(:,56), n3(:,154), t3x128(:,:,56), nhel, den(11))
    call Hcont_QA(nsync, wf8(:,2), wf16(:,38), A(:,57), n3(:,155), t3x128(:,:,57), nhel, den(30))
    call Hcont_VV(nsync, wf8(:,10), wf16(:,34), A(:,58), n3(:,156), t3x128(:,:,58), nhel, den(29))
    call Hcont_QA(nsync, wf8(:,2), wf16(:,39), A(:,59), n3(:,157), t3x128(:,:,59), nhel, den(34))
    call Hcont_VV(nsync, wf8(:,11), wf16(:,34), A(:,60), n3(:,158), t3x128(:,:,60), nhel, den(33))
    call Hcont_QA(nsync, wf8(:,2), wf16(:,40), A(:,61), n3(:,159), t3x128(:,:,61), nhel, den(49))
    call Hcont_QA(nsync, wf8(:,4), wf16(:,41), A(:,62), n3(:,160), t3x128(:,:,62), nhel, den(51))
    call Hcont_QA(nsync, wf16(:,17), wf8(:,30), A(:,63), n3(:,161), t3x128(:,:,63), nhel, den(53))
    call Hcont_QA(nsync, wf8(:,2), wf16(:,42), A(:,64), n3(:,162), t3x128(:,:,64), nhel, den(55))
    call Hcont_QA(nsync, wf16(:,18), wf8(:,31), A(:,65), n3(:,163), t3x128(:,:,65), nhel, den(56))
    call Hcont_QA(nsync, wf16(:,17), wf8(:,32), A(:,66), n3(:,164), t3x128(:,:,66), nhel, den(57))
    call Hcont_QA(nsync, wf16(:,30), wf8(:,33), A(:,67), n3(:,165), t3x128(:,:,67), nhel, den(58))
    call Hcont_QA(nsync, wf16(:,31), wf8(:,34), A(:,68), n3(:,166), t3x128(:,:,68), nhel, den(59))
    call Hcont_QA(nsync, wf16(:,30), wf8(:,35), A(:,69), n3(:,167), t3x128(:,:,69), nhel, den(60))
    call Hcont_QA(nsync, wf4(:,7), wf32(:,1), A(:,70), n3(:,168), t3x128(:,:,70), nhel, den(62))
    call Hcont_VV(nsync, wf4(:,3), wf32(:,2), A(:,71), n3(:,169), t3x128(:,:,71), nhel, den(65))
    call Hcont_QA(nsync, wf8(:,8), wf16(:,43), A(:,72), n3(:,170), t3x128(:,:,72), nhel, den(67))
    call Hcont_QA(nsync, wf16(:,44), wf8(:,36), A(:,73), n3(:,171), t3x128(:,:,73), nhel, den(69))
    call Hcont_QA(nsync, wf8(:,34), wf16(:,46), A(:,74), n3(:,172), t3x128(:,:,74), nhel, den(71))
    call Hcont_QA(nsync, wf8(:,31), wf16(:,48), A(:,75), n3(:,173), t3x128(:,:,75), nhel, den(73))
    call Hcont_QA(nsync, wf8(:,34), wf16(:,50), A(:,76), n3(:,174), t3x128(:,:,76), nhel, den(75))
    call Hcont_QA(nsync, wf8(:,35), wf16(:,51), A(:,77), n3(:,175), t3x128(:,:,77), nhel, den(77))
    call Hcont_VV(nsync, wf16(:,8), wf8(:,37), A(:,78), n3(:,176), t3x128(:,:,78), nhel, den(80))
    call Hcont_QA(nsync, wf16(:,6), wf8(:,38), A(:,79), n3(:,177), t3x128(:,:,79), nhel, den(82))
    call Hcont_VV(nsync, wf16(:,5), wf8(:,39), A(:,80), n3(:,178), t3x128(:,:,80), nhel, den(84))
    call Hcont_VV(nsync, wf16(:,8), wf8(:,39), A(:,81), n3(:,179), t3x128(:,:,81), nhel, den(85))
    call Hcont_VV(nsync, wf16(:,5), wf8(:,37), A(:,82), n3(:,180), t3x128(:,:,82), nhel, den(86))
    call Hcont_QA(nsync, wf8(:,32), wf16(:,52), A(:,83), n3(:,181), t3x128(:,:,83), nhel, den(88))
    call Hcont_QA(nsync, wf8(:,31), wf16(:,53), A(:,84), n3(:,182), t3x128(:,:,84), nhel, den(90))
    call Hcont_VV(nsync, wf16(:,8), wf8(:,40), A(:,85), n3(:,183), t3x128(:,:,85), nhel, den(91))
    call Hcont_QA(nsync, wf8(:,34), wf16(:,55), A(:,86), n3(:,184), t3x128(:,:,86), nhel, den(93))
    call Hcont_QA(nsync, wf8(:,31), wf16(:,56), A(:,87), n3(:,185), t3x128(:,:,87), nhel, den(95))
    call Hcont_VV(nsync, wf16(:,5), wf8(:,41), A(:,88), n3(:,186), t3x128(:,:,88), nhel, den(98))
    call Hcont_VV(nsync, wf16(:,8), wf8(:,41), A(:,89), n3(:,187), t3x128(:,:,89), nhel, den(99))
    call Hcont_VV(nsync, wf16(:,5), wf8(:,40), A(:,90), n3(:,188), t3x128(:,:,90), nhel, den(100))
    call Hcont_VV(nsync, wf16(:,8), wf8(:,42), A(:,91), n3(:,189), t3x128(:,:,91), nhel, den(101))
    call Hcont_QA(nsync, wf8(:,34), wf16(:,58), A(:,92), n3(:,190), t3x128(:,:,92), nhel, den(103))
    call Hcont_QA(nsync, wf8(:,31), wf16(:,59), A(:,93), n3(:,191), t3x128(:,:,93), nhel, den(105))
    call Hcont_VV(nsync, wf16(:,5), wf8(:,43), A(:,94), n3(:,192), t3x128(:,:,94), nhel, den(108))
    call Hcont_VV(nsync, wf16(:,8), wf8(:,43), A(:,95), n3(:,193), t3x128(:,:,95), nhel, den(109))
    call Hcont_VV(nsync, wf16(:,5), wf8(:,42), A(:,96), n3(:,194), t3x128(:,:,96), nhel, den(110))

end subroutine diagrams


elemental function diagmap(j, n)
  implicit none
  integer, intent(in) :: j, n
  complex(REALKIND) :: diagmap
  diagmap = A(j,n)%j
end function diagmap

function diagsum(j, pos, neg)
  implicit none
  integer, intent(in) :: j, pos(:), neg(:)
  complex(REALKIND) :: diagsum
  diagsum = sum(diagmap(j, pos)) - sum(diagmap(j, neg))
end function diagsum

subroutine colourvectors(A, j, M1, M2)
  implicit none
  type(Hpolcont) :: A(:,:)
  integer, intent(in) :: j
  type(Hpolcont), intent(out) :: M1(4), M2(4) ! M1helarray(4,128)
  integer :: empty(0), i

  M1(1)%j = ((-A(j,1)%j-A(j,2)%j-A(j,6)%j-A(j,9)%j-A(j,10)%j)*f(1))/2._/**/REALKIND+(CI*(A(j,5)%j+A(j,8)%j)*f(2))/2._/**/REALKIND
  M1(2)%j = ((A(j,1)%j+A(j,2)%j+A(j,3)%j+A(j,4)%j+A(j,6)%j+A(j,7)%j)*f(1))/6._/**/REALKIND
  M1(3)%j = ((A(j,9)%j+A(j,10)%j+A(j,11)%j+A(j,12)%j)*f(1))/6._/**/REALKIND
  M1(4)%j = ((-A(j,3)%j-A(j,4)%j-A(j,7)%j-A(j,11)%j-A(j,12)%j)*f(1))/2._/**/REALKIND+(CI*(-A(j,5)%j &
       -A(j,8)%j)*f(2))/2._/**/REALKIND

  M2(1)%j = ((A(j,61)%j+A(j,62)%j+A(j,63)%j+A(j,64)%j+A(j,65)%j+A(j,66)%j+A(j,76)%j+A(j,79)%j+A(j,83)%j+A(j,85)%j+A(j,86)%j &
       +A(j,87)%j+A(j,88)%j+A(j,89)%j+A(j,90)%j)*f(3))/2._/**/REALKIND+(CI*(-A(j,74)%j-A(j,75)%j-A(j,78)%j-A(j,80)%j-A(j,81)%j &
       -A(j,82)%j)*f(4))/2._/**/REALKIND+((-A(j,13)%j-A(j,18)%j-A(j,21)%j-A(j,23)%j-A(j,29)%j-A(j,55)%j-A(j,56)%j &
       -A(j,57)%j)*f(5))/2._/**/REALKIND+(CI*(A(j,24)%j+A(j,52)%j)*f(6))/2._/**/REALKIND+((-A(j,33)%j-A(j,34)%j-A(j,39)%j &
       -A(j,40)%j-A(j,41)%j-A(j,42)%j-A(j,46)%j)*f(7))/2._/**/REALKIND+(CI*(A(j,45)%j+A(j,47)%j)*f(8))/2._/**/REALKIND+(( &
       -A(j,14)%j-A(j,22)%j-A(j,30)%j-A(j,54)%j-A(j,58)%j)*f(9))/2._/**/REALKIND+(CI*(A(j,26)%j+A(j,53)%j)*f(10))/2._/**/REALKIND &
       +(CI*(A(j,17)%j+A(j,20)%j)*f(11))/2._/**/REALKIND
  M2(2)%j = ((-A(j,61)%j-A(j,62)%j-A(j,63)%j-A(j,64)%j-A(j,65)%j-A(j,66)%j-A(j,67)%j-A(j,68)%j-A(j,69)%j-A(j,70)%j-A(j,71)%j &
       -A(j,72)%j-A(j,73)%j-A(j,76)%j-A(j,77)%j-A(j,79)%j-A(j,83)%j-A(j,84)%j)*f(3))/6._/**/REALKIND+((A(j,13)%j+A(j,15)%j &
       +A(j,18)%j+A(j,19)%j+A(j,21)%j+A(j,23)%j+A(j,27)%j+A(j,28)%j+A(j,49)%j+A(j,51)%j+A(j,55)%j+A(j,56)%j)*f(5))/6._/**/REALKIND &
       +((A(j,41)%j+A(j,42)%j+A(j,43)%j+A(j,44)%j+A(j,46)%j+A(j,48)%j)*f(7))/6._/**/REALKIND+((A(j,14)%j+A(j,16)%j+A(j,22)%j &
       +A(j,25)%j+A(j,50)%j+A(j,54)%j)*f(9))/6._/**/REALKIND
  M2(3)%j = ((-A(j,85)%j-A(j,86)%j-A(j,87)%j-A(j,88)%j-A(j,89)%j-A(j,90)%j-A(j,91)%j-A(j,92)%j-A(j,93)%j-A(j,94)%j-A(j,95)%j &
       -A(j,96)%j)*f(3))/6._/**/REALKIND+((A(j,29)%j+A(j,31)%j+A(j,57)%j+A(j,59)%j)*f(5))/6._/**/REALKIND+((A(j,33)%j+A(j,34)%j &
       +A(j,35)%j+A(j,36)%j+A(j,37)%j+A(j,38)%j+A(j,39)%j+A(j,40)%j)*f(7))/6._/**/REALKIND+((A(j,30)%j+A(j,32)%j+A(j,58)%j &
       +A(j,60)%j)*f(9))/6._/**/REALKIND
  M2(4)%j = ((A(j,67)%j+A(j,68)%j+A(j,69)%j+A(j,70)%j+A(j,71)%j+A(j,72)%j+A(j,73)%j+A(j,77)%j+A(j,84)%j+A(j,91)%j+A(j,92)%j &
       +A(j,93)%j+A(j,94)%j+A(j,95)%j+A(j,96)%j)*f(3))/2._/**/REALKIND+(CI*(A(j,74)%j+A(j,75)%j+A(j,78)%j+A(j,80)%j+A(j,81)%j &
       +A(j,82)%j)*f(4))/2._/**/REALKIND+((-A(j,15)%j-A(j,19)%j-A(j,27)%j-A(j,28)%j-A(j,31)%j-A(j,49)%j-A(j,51)%j &
       -A(j,59)%j)*f(5))/2._/**/REALKIND+(CI*(-A(j,24)%j-A(j,52)%j)*f(6))/2._/**/REALKIND+((-A(j,35)%j-A(j,36)%j-A(j,37)%j &
       -A(j,38)%j-A(j,43)%j-A(j,44)%j-A(j,48)%j)*f(7))/2._/**/REALKIND+(CI*(-A(j,45)%j-A(j,47)%j)*f(8))/2._/**/REALKIND+(( &
       -A(j,16)%j-A(j,25)%j-A(j,32)%j-A(j,50)%j-A(j,60)%j)*f(9))/2._/**/REALKIND+(CI*(-A(j,26)%j-A(j,53)%j)*f(10))/2._/**/REALKIND &
       +(CI*(-A(j,17)%j-A(j,20)%j)*f(11))/2._/**/REALKIND


  M1(:)%hf = Hel(j)
  M2(:)%hf = Hel(j)  

  !M(i) corresponds to \Gamma_{i} in Fabio's thesis

end subroutine colourvectors


! **********************************************************************
subroutine colint(M, M2colint)
! M(i)   = <M|Ci> colour component of matrix element
! COLINT = <M|M>
!        = Sum_{i,j} <M|Ci> * <Ci|Cj> * <Cj|M>
!        = colour-summed squared matrix element
! K2(i,j) = <Ci|Cj>
! **********************************************************************
  use ol_colourmatrix_pplnttj_neexuxttxdg_1_/**/REALKIND, only: K1
  implicit none

  complex(REALKIND), intent(in)  :: M(4)
  real(REALKIND),    intent(out) :: M2colint
  integer :: i, j

  M2colint = 0

    do i = 1, 4
      do j = 1, 4
        M2colint = M2colint + real(conjg(M(i))*K1(i,j)*M(j))
      end do
    end do

end subroutine colint

! **********************************************************************
subroutine colint_ct(M, Mct, M2colint_ct)
! M(i)   = <M|Ci> colour component of matrix element
! COLINT = <M|M>
!        = Sum_{i,j} <M|Ci> * <Ci|Cj> * <Cj|M>
!        = colour-summed squared matrix element
! K2(i,j) = <Ci|Cj>
! **********************************************************************
  use ol_colourmatrix_pplnttj_neexuxttxdg_1_/**/REALKIND, only: K2
  implicit none

  complex(REALKIND), intent(in)  :: M(4), Mct(4)
  real(REALKIND),    intent(out) :: M2colint_ct
  integer ::  i, j

  M2colint_ct = 0

    do i = 1, 4
      do j = 1, 4
        M2colint_ct = M2colint_ct + real(conjg(M(i))*K2(i,j)*Mct(j))
      end do
    end do


end subroutine colint_ct

! **********************************************************************
subroutine colint_IR(M, M2IRadd)
! M(i)   = <M|Ci> colour component of matrix element
! K1(i,j) = .....
! **********************************************************************
  use ol_colourmatrix_pplnttj_neexuxttxdg_1_/**/REALKIND, only: K1
  implicit none

  complex(REALKIND), intent(in)  :: M(4)
  real(REALKIND),    intent(out) :: M2IRadd(29)
  integer ::  i, j, k, colmatpos

  M2IRadd = 0

  do k = 1, 30-1
    colmatpos = 4*k
    do i = 1, 4
      do j = 1, 4
	M2IRadd(k) = M2IRadd(k) + real(conjg(M(i))*K1(i+colmatpos,j)*M(j))
      end do
    end do
  end do
  
end subroutine colint_IR

! **********************************************************************
subroutine colintmunu(M1, M2, M2colint)
! M1(i)    = <M1|Ci> colour component of matrix element
! M2(i)    = <M2|Ci> colour component of matrix element
! M2colint = <M1|M2>
!          = Sum_{i,j} <M1|Ci> * <Ci|Cj> * <Cj|M2>
!          = colour-summed squared matrix element
! K2(i,j) = <Ci|Cj>
! **********************************************************************
  use ol_colourmatrix_pplnttj_neexuxttxdg_1_/**/REALKIND, only: K2
  implicit none

  complex(REALKIND), intent(in)  :: M1(4)
  complex(REALKIND), intent(in)  :: M2(4)
  complex(REALKIND),    intent(out) :: M2colint
  integer :: i, j

  M2colint = 0

  do i = 1, 4
    do j = 1, 4
      M2colint = M2colint + M1(i)*K2(i,j)*conjg(M2(j))
    end do
  end do

end subroutine colintmunu





! **********************************************************************
subroutine colborninterf(M, M0_col)
! M(i)         = <M|Ci> colour component of matrix element
! M0_col(i)    = <M2|Ci> colour component of matrix element,
!                see \tilde{M}_{j} in Fabio's thesis
! M2colint = Sum_{i} <M1|Ci> * <Ci|Cj>
!          = colour-summed squared matrix element
! KL(i,j) = <Ci|Cj> with elements Cj of 1-loop colour basis
! **********************************************************************
  use ol_colourmatrix_pplnttj_neexuxttxdg_1_/**/REALKIND, only: KL
  implicit none

  type(Hpolcont), intent(in)  :: M(4)
  type(Hpolcont), intent(out)  :: M0_col(4)
  integer :: i, j


  do j = 1, 4 !size(KL(1,:))
    M0_col(j)%j = 0
    M0_col(j)%hf = M(1)%hf
    do i = 1, 4 !size(KL(:,1))
      M0_col(j)%j = M0_col(j)%j  + conjg(M(i)%j)*KL(i,j)
    end do    
  end do

end subroutine colborninterf

end subroutine amp2

end module ol_loop_pplnttj_neexuxttxdg_1_/**/REALKIND
